initSidebarItems({"enum":[["DepConstructor",""],["DepKind",""],["DepNodeColor",""],["OpenTask",""],["WorkProductFileKind",""]],"mod":[["debug","Code for debugging the dep-graph."],["dep_node","This module defines the `DepNode` type which the compiler uses to represent nodes in the dependency graph. A `DepNode` consists of a `DepKind` (which specifies the kind of thing it represents, like a piece of HIR, MIR, etc) and a `Fingerprint`, a 128 bit hash value the exact meaning of which depends on the node's `DepKind`. Together, the kind and the fingerprint fully identify a dependency node, even across multiple compilation sessions. In other words, the value of the fingerprint does not depend on anything that is specific to a given compilation session, like an unpredictable interning key (e.g. NodeId, DefId, Symbol) or the numeric value of a pointer. The concept behind this could be compared to how git commit hashes uniquely identify a given commit and has a few advantages:"],["dep_tracking_map",""],["graph",""],["label_strs","Contains variant => str representations for constructing DepNode groups for tests."],["prev",""],["query",""],["safe","The `DepGraphSafe` trait"],["serialized","The data that we will serialize and deserialize."]],"struct":[["AssertDepGraphSafe","A convenient override that lets you pass arbitrary state into a task. Every use should be accompanied by a comment explaining why it makes sense (or how it could be refactored away in the future)."],["DepGraph",""],["DepGraphQuery",""],["DepNode",""],["DepNodeIndex",""],["DepTrackingMap","A DepTrackingMap offers a subset of the `Map` API and ensures that we make calls to `read` and `write` as appropriate. We key the maps with a unique type for brevity."],["PreviousDepGraph",""],["SerializedDepGraph","Data for use when recompiling the current crate."],["SerializedDepNodeIndex",""],["WorkProduct","A \"work product\" is an intermediate result that we save into the incremental directory for later re-use. The primary example are the object files that we save for each partition at code generation time."],["WorkProductId","A \"work product\" corresponds to a `.o` (or other) file that we save in between runs. These ids do not have a DefId but rather some independent path or string that persists between runs without the need to be mapped or unmapped. (This ensures we can serialize them even in the absence of a tcx.)"]],"trait":[["DepGraphSafe","The `DepGraphSafe` trait is used to specify what kinds of values are safe to \"leak\" into a task. The idea is that this should be only be implemented for things like the tcx as well as various id types, which will create reads in the dep-graph whenever the trait loads anything that might depend on the input program."],["DepTrackingMapConfig",""]]});