// Copyright 2012-2014 The Rust Project Developers. See the COPYRIGHT
// file at the top-level directory of this distribution and at
// http://rust-lang.org/COPYRIGHT.
//
// Licensed under the Apache License, Version 2.0 <LICENSE-APACHE or
// http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your
// option. This file may not be copied, modified, or distributed
// except according to those terms.

// NOTE: The following code was generated by "src/etc/unicode.py", do not edit directly

#![allow(missing_docs, non_upper_case_globals, non_snake_case)]

/// The version of [Unicode](http://www.unicode.org/)
/// that the `UnicodeChar` and `UnicodeStrPrelude` traits are based on.
pub const UNICODE_VERSION: (uint, uint, uint) = (7, 0, 0);

fn bsearch_range_table(c: char, r: &'static [(char,char)]) -> bool {
    use core::cmp::Ordering::{Equal, Less, Greater};
    use core::slice::SliceExt;
    r.binary_search_by(|&(lo,hi)| {
        if lo <= c && c <= hi { Equal }
        else if hi < c { Less }
        else { Greater }
    }).is_ok()
}

pub mod general_category {
    pub static C_table: &'static [(char, char)] = &[
        ('\u{0}', '\u{1f}'), ('\u{7f}', '\u{9f}'), ('\u{ad}', '\u{ad}'), ('\u{378}', '\u{379}'),
        ('\u{380}', '\u{383}'), ('\u{38b}', '\u{38b}'), ('\u{38d}', '\u{38d}'), ('\u{3a2}',
        '\u{3a2}'), ('\u{530}', '\u{530}'), ('\u{557}', '\u{558}'), ('\u{560}', '\u{560}'),
        ('\u{588}', '\u{588}'), ('\u{58b}', '\u{58c}'), ('\u{590}', '\u{590}'), ('\u{5c8}',
        '\u{5cf}'), ('\u{5eb}', '\u{5ef}'), ('\u{5f5}', '\u{605}'), ('\u{61c}', '\u{61d}'),
        ('\u{6dd}', '\u{6dd}'), ('\u{70e}', '\u{70f}'), ('\u{74b}', '\u{74c}'), ('\u{7b2}',
        '\u{7bf}'), ('\u{7fb}', '\u{7ff}'), ('\u{82e}', '\u{82f}'), ('\u{83f}', '\u{83f}'),
        ('\u{85c}', '\u{85d}'), ('\u{85f}', '\u{89f}'), ('\u{8b3}', '\u{8e3}'), ('\u{984}',
        '\u{984}'), ('\u{98d}', '\u{98e}'), ('\u{991}', '\u{992}'), ('\u{9a9}', '\u{9a9}'),
        ('\u{9b1}', '\u{9b1}'), ('\u{9b3}', '\u{9b5}'), ('\u{9ba}', '\u{9bb}'), ('\u{9c5}',
        '\u{9c6}'), ('\u{9c9}', '\u{9ca}'), ('\u{9cf}', '\u{9d6}'), ('\u{9d8}', '\u{9db}'),
        ('\u{9de}', '\u{9de}'), ('\u{9e4}', '\u{9e5}'), ('\u{9fc}', '\u{a00}'), ('\u{a04}',
        '\u{a04}'), ('\u{a0b}', '\u{a0e}'), ('\u{a11}', '\u{a12}'), ('\u{a29}', '\u{a29}'),
        ('\u{a31}', '\u{a31}'), ('\u{a34}', '\u{a34}'), ('\u{a37}', '\u{a37}'), ('\u{a3a}',
        '\u{a3b}'), ('\u{a3d}', '\u{a3d}'), ('\u{a43}', '\u{a46}'), ('\u{a49}', '\u{a4a}'),
        ('\u{a4e}', '\u{a50}'), ('\u{a52}', '\u{a58}'), ('\u{a5d}', '\u{a5d}'), ('\u{a5f}',
        '\u{a65}'), ('\u{a76}', '\u{a80}'), ('\u{a84}', '\u{a84}'), ('\u{a8e}', '\u{a8e}'),
        ('\u{a92}', '\u{a92}'), ('\u{aa9}', '\u{aa9}'), ('\u{ab1}', '\u{ab1}'), ('\u{ab4}',
        '\u{ab4}'), ('\u{aba}', '\u{abb}'), ('\u{ac6}', '\u{ac6}'), ('\u{aca}', '\u{aca}'),
        ('\u{ace}', '\u{acf}'), ('\u{ad1}', '\u{adf}'), ('\u{ae4}', '\u{ae5}'), ('\u{af2}',
        '\u{b00}'), ('\u{b04}', '\u{b04}'), ('\u{b0d}', '\u{b0e}'), ('\u{b11}', '\u{b12}'),
        ('\u{b29}', '\u{b29}'), ('\u{b31}', '\u{b31}'), ('\u{b34}', '\u{b34}'), ('\u{b3a}',
        '\u{b3b}'), ('\u{b45}', '\u{b46}'), ('\u{b49}', '\u{b4a}'), ('\u{b4e}', '\u{b55}'),
        ('\u{b58}', '\u{b5b}'), ('\u{b5e}', '\u{b5e}'), ('\u{b64}', '\u{b65}'), ('\u{b78}',
        '\u{b81}'), ('\u{b84}', '\u{b84}'), ('\u{b8b}', '\u{b8d}'), ('\u{b91}', '\u{b91}'),
        ('\u{b96}', '\u{b98}'), ('\u{b9b}', '\u{b9b}'), ('\u{b9d}', '\u{b9d}'), ('\u{ba0}',
        '\u{ba2}'), ('\u{ba5}', '\u{ba7}'), ('\u{bab}', '\u{bad}'), ('\u{bba}', '\u{bbd}'),
        ('\u{bc3}', '\u{bc5}'), ('\u{bc9}', '\u{bc9}'), ('\u{bce}', '\u{bcf}'), ('\u{bd1}',
        '\u{bd6}'), ('\u{bd8}', '\u{be5}'), ('\u{bfb}', '\u{bff}'), ('\u{c04}', '\u{c04}'),
        ('\u{c0d}', '\u{c0d}'), ('\u{c11}', '\u{c11}'), ('\u{c29}', '\u{c29}'), ('\u{c3a}',
        '\u{c3c}'), ('\u{c45}', '\u{c45}'), ('\u{c49}', '\u{c49}'), ('\u{c4e}', '\u{c54}'),
        ('\u{c57}', '\u{c57}'), ('\u{c5a}', '\u{c5f}'), ('\u{c64}', '\u{c65}'), ('\u{c70}',
        '\u{c77}'), ('\u{c80}', '\u{c80}'), ('\u{c84}', '\u{c84}'), ('\u{c8d}', '\u{c8d}'),
        ('\u{c91}', '\u{c91}'), ('\u{ca9}', '\u{ca9}'), ('\u{cb4}', '\u{cb4}'), ('\u{cba}',
        '\u{cbb}'), ('\u{cc5}', '\u{cc5}'), ('\u{cc9}', '\u{cc9}'), ('\u{cce}', '\u{cd4}'),
        ('\u{cd7}', '\u{cdd}'), ('\u{cdf}', '\u{cdf}'), ('\u{ce4}', '\u{ce5}'), ('\u{cf0}',
        '\u{cf0}'), ('\u{cf3}', '\u{d00}'), ('\u{d04}', '\u{d04}'), ('\u{d0d}', '\u{d0d}'),
        ('\u{d11}', '\u{d11}'), ('\u{d3b}', '\u{d3c}'), ('\u{d45}', '\u{d45}'), ('\u{d49}',
        '\u{d49}'), ('\u{d4f}', '\u{d56}'), ('\u{d58}', '\u{d5f}'), ('\u{d64}', '\u{d65}'),
        ('\u{d76}', '\u{d78}'), ('\u{d80}', '\u{d81}'), ('\u{d84}', '\u{d84}'), ('\u{d97}',
        '\u{d99}'), ('\u{db2}', '\u{db2}'), ('\u{dbc}', '\u{dbc}'), ('\u{dbe}', '\u{dbf}'),
        ('\u{dc7}', '\u{dc9}'), ('\u{dcb}', '\u{dce}'), ('\u{dd5}', '\u{dd5}'), ('\u{dd7}',
        '\u{dd7}'), ('\u{de0}', '\u{de5}'), ('\u{df0}', '\u{df1}'), ('\u{df5}', '\u{e00}'),
        ('\u{e3b}', '\u{e3e}'), ('\u{e5c}', '\u{e80}'), ('\u{e83}', '\u{e83}'), ('\u{e85}',
        '\u{e86}'), ('\u{e89}', '\u{e89}'), ('\u{e8b}', '\u{e8c}'), ('\u{e8e}', '\u{e93}'),
        ('\u{e98}', '\u{e98}'), ('\u{ea0}', '\u{ea0}'), ('\u{ea4}', '\u{ea4}'), ('\u{ea6}',
        '\u{ea6}'), ('\u{ea8}', '\u{ea9}'), ('\u{eac}', '\u{eac}'), ('\u{eba}', '\u{eba}'),
        ('\u{ebe}', '\u{ebf}'), ('\u{ec5}', '\u{ec5}'), ('\u{ec7}', '\u{ec7}'), ('\u{ece}',
        '\u{ecf}'), ('\u{eda}', '\u{edb}'), ('\u{ee0}', '\u{eff}'), ('\u{f48}', '\u{f48}'),
        ('\u{f6d}', '\u{f70}'), ('\u{f98}', '\u{f98}'), ('\u{fbd}', '\u{fbd}'), ('\u{fcd}',
        '\u{fcd}'), ('\u{fdb}', '\u{fff}'), ('\u{10c6}', '\u{10c6}'), ('\u{10c8}', '\u{10cc}'),
        ('\u{10ce}', '\u{10cf}'), ('\u{1249}', '\u{1249}'), ('\u{124e}', '\u{124f}'), ('\u{1257}',
        '\u{1257}'), ('\u{1259}', '\u{1259}'), ('\u{125e}', '\u{125f}'), ('\u{1289}', '\u{1289}'),
        ('\u{128e}', '\u{128f}'), ('\u{12b1}', '\u{12b1}'), ('\u{12b6}', '\u{12b7}'), ('\u{12bf}',
        '\u{12bf}'), ('\u{12c1}', '\u{12c1}'), ('\u{12c6}', '\u{12c7}'), ('\u{12d7}', '\u{12d7}'),
        ('\u{1311}', '\u{1311}'), ('\u{1316}', '\u{1317}'), ('\u{135b}', '\u{135c}'), ('\u{137d}',
        '\u{137f}'), ('\u{139a}', '\u{139f}'), ('\u{13f5}', '\u{13ff}'), ('\u{169d}', '\u{169f}'),
        ('\u{16f9}', '\u{16ff}'), ('\u{170d}', '\u{170d}'), ('\u{1715}', '\u{171f}'), ('\u{1737}',
        '\u{173f}'), ('\u{1754}', '\u{175f}'), ('\u{176d}', '\u{176d}'), ('\u{1771}', '\u{1771}'),
        ('\u{1774}', '\u{177f}'), ('\u{17de}', '\u{17df}'), ('\u{17ea}', '\u{17ef}'), ('\u{17fa}',
        '\u{17ff}'), ('\u{180e}', '\u{180f}'), ('\u{181a}', '\u{181f}'), ('\u{1878}', '\u{187f}'),
        ('\u{18ab}', '\u{18af}'), ('\u{18f6}', '\u{18ff}'), ('\u{191f}', '\u{191f}'), ('\u{192c}',
        '\u{192f}'), ('\u{193c}', '\u{193f}'), ('\u{1941}', '\u{1943}'), ('\u{196e}', '\u{196f}'),
        ('\u{1975}', '\u{197f}'), ('\u{19ac}', '\u{19af}'), ('\u{19ca}', '\u{19cf}'), ('\u{19db}',
        '\u{19dd}'), ('\u{1a1c}', '\u{1a1d}'), ('\u{1a5f}', '\u{1a5f}'), ('\u{1a7d}', '\u{1a7e}'),
        ('\u{1a8a}', '\u{1a8f}'), ('\u{1a9a}', '\u{1a9f}'), ('\u{1aae}', '\u{1aaf}'), ('\u{1abf}',
        '\u{1aff}'), ('\u{1b4c}', '\u{1b4f}'), ('\u{1b7d}', '\u{1b7f}'), ('\u{1bf4}', '\u{1bfb}'),
        ('\u{1c38}', '\u{1c3a}'), ('\u{1c4a}', '\u{1c4c}'), ('\u{1c80}', '\u{1cbf}'), ('\u{1cc8}',
        '\u{1ccf}'), ('\u{1cf7}', '\u{1cf7}'), ('\u{1cfa}', '\u{1cff}'), ('\u{1df6}', '\u{1dfb}'),
        ('\u{1f16}', '\u{1f17}'), ('\u{1f1e}', '\u{1f1f}'), ('\u{1f46}', '\u{1f47}'), ('\u{1f4e}',
        '\u{1f4f}'), ('\u{1f58}', '\u{1f58}'), ('\u{1f5a}', '\u{1f5a}'), ('\u{1f5c}', '\u{1f5c}'),
        ('\u{1f5e}', '\u{1f5e}'), ('\u{1f7e}', '\u{1f7f}'), ('\u{1fb5}', '\u{1fb5}'), ('\u{1fc5}',
        '\u{1fc5}'), ('\u{1fd4}', '\u{1fd5}'), ('\u{1fdc}', '\u{1fdc}'), ('\u{1ff0}', '\u{1ff1}'),
        ('\u{1ff5}', '\u{1ff5}'), ('\u{1fff}', '\u{1fff}'), ('\u{200b}', '\u{200f}'), ('\u{202a}',
        '\u{202e}'), ('\u{2060}', '\u{206f}'), ('\u{2072}', '\u{2073}'), ('\u{208f}', '\u{208f}'),
        ('\u{209d}', '\u{209f}'), ('\u{20be}', '\u{20cf}'), ('\u{20f1}', '\u{20ff}'), ('\u{218a}',
        '\u{218f}'), ('\u{23fb}', '\u{23ff}'), ('\u{2427}', '\u{243f}'), ('\u{244b}', '\u{245f}'),
        ('\u{2b74}', '\u{2b75}'), ('\u{2b96}', '\u{2b97}'), ('\u{2bba}', '\u{2bbc}'), ('\u{2bc9}',
        '\u{2bc9}'), ('\u{2bd2}', '\u{2bff}'), ('\u{2c2f}', '\u{2c2f}'), ('\u{2c5f}', '\u{2c5f}'),
        ('\u{2cf4}', '\u{2cf8}'), ('\u{2d26}', '\u{2d26}'), ('\u{2d28}', '\u{2d2c}'), ('\u{2d2e}',
        '\u{2d2f}'), ('\u{2d68}', '\u{2d6e}'), ('\u{2d71}', '\u{2d7e}'), ('\u{2d97}', '\u{2d9f}'),
        ('\u{2da7}', '\u{2da7}'), ('\u{2daf}', '\u{2daf}'), ('\u{2db7}', '\u{2db7}'), ('\u{2dbf}',
        '\u{2dbf}'), ('\u{2dc7}', '\u{2dc7}'), ('\u{2dcf}', '\u{2dcf}'), ('\u{2dd7}', '\u{2dd7}'),
        ('\u{2ddf}', '\u{2ddf}'), ('\u{2e43}', '\u{2e7f}'), ('\u{2e9a}', '\u{2e9a}'), ('\u{2ef4}',
        '\u{2eff}'), ('\u{2fd6}', '\u{2fef}'), ('\u{2ffc}', '\u{2fff}'), ('\u{3040}', '\u{3040}'),
        ('\u{3097}', '\u{3098}'), ('\u{3100}', '\u{3104}'), ('\u{312e}', '\u{3130}'), ('\u{318f}',
        '\u{318f}'), ('\u{31bb}', '\u{31bf}'), ('\u{31e4}', '\u{31ef}'), ('\u{321f}', '\u{321f}'),
        ('\u{32ff}', '\u{32ff}'), ('\u{3401}', '\u{4db4}'), ('\u{4db6}', '\u{4dbf}'), ('\u{4e01}',
        '\u{9fcb}'), ('\u{9fcd}', '\u{9fff}'), ('\u{a48d}', '\u{a48f}'), ('\u{a4c7}', '\u{a4cf}'),
        ('\u{a62c}', '\u{a63f}'), ('\u{a69e}', '\u{a69e}'), ('\u{a6f8}', '\u{a6ff}'), ('\u{a78f}',
        '\u{a78f}'), ('\u{a7ae}', '\u{a7af}'), ('\u{a7b2}', '\u{a7f6}'), ('\u{a82c}', '\u{a82f}'),
        ('\u{a83a}', '\u{a83f}'), ('\u{a878}', '\u{a87f}'), ('\u{a8c5}', '\u{a8cd}'), ('\u{a8da}',
        '\u{a8df}'), ('\u{a8fc}', '\u{a8ff}'), ('\u{a954}', '\u{a95e}'), ('\u{a97d}', '\u{a97f}'),
        ('\u{a9ce}', '\u{a9ce}'), ('\u{a9da}', '\u{a9dd}'), ('\u{a9ff}', '\u{a9ff}'), ('\u{aa37}',
        '\u{aa3f}'), ('\u{aa4e}', '\u{aa4f}'), ('\u{aa5a}', '\u{aa5b}'), ('\u{aac3}', '\u{aada}'),
        ('\u{aaf7}', '\u{ab00}'), ('\u{ab07}', '\u{ab08}'), ('\u{ab0f}', '\u{ab10}'), ('\u{ab17}',
        '\u{ab1f}'), ('\u{ab27}', '\u{ab27}'), ('\u{ab2f}', '\u{ab2f}'), ('\u{ab60}', '\u{ab63}'),
        ('\u{ab66}', '\u{abbf}'), ('\u{abee}', '\u{abef}'), ('\u{abfa}', '\u{abff}'), ('\u{ac01}',
        '\u{d7a2}'), ('\u{d7a4}', '\u{d7af}'), ('\u{d7c7}', '\u{d7ca}'), ('\u{d7fc}', '\u{d7ff}'),
        ('\u{e000}', '\u{f8ff}'), ('\u{fa6e}', '\u{fa6f}'), ('\u{fada}', '\u{faff}'), ('\u{fb07}',
        '\u{fb12}'), ('\u{fb18}', '\u{fb1c}'), ('\u{fb37}', '\u{fb37}'), ('\u{fb3d}', '\u{fb3d}'),
        ('\u{fb3f}', '\u{fb3f}'), ('\u{fb42}', '\u{fb42}'), ('\u{fb45}', '\u{fb45}'), ('\u{fbc2}',
        '\u{fbd2}'), ('\u{fd40}', '\u{fd4f}'), ('\u{fd90}', '\u{fd91}'), ('\u{fdc8}', '\u{fdef}'),
        ('\u{fdfe}', '\u{fdff}'), ('\u{fe1a}', '\u{fe1f}'), ('\u{fe2e}', '\u{fe2f}'), ('\u{fe53}',
        '\u{fe53}'), ('\u{fe67}', '\u{fe67}'), ('\u{fe6c}', '\u{fe6f}'), ('\u{fe75}', '\u{fe75}'),
        ('\u{fefd}', '\u{ff00}'), ('\u{ffbf}', '\u{ffc1}'), ('\u{ffc8}', '\u{ffc9}'), ('\u{ffd0}',
        '\u{ffd1}'), ('\u{ffd8}', '\u{ffd9}'), ('\u{ffdd}', '\u{ffdf}'), ('\u{ffe7}', '\u{ffe7}'),
        ('\u{ffef}', '\u{fffb}'), ('\u{fffe}', '\u{ffff}'), ('\u{1000c}', '\u{1000c}'),
        ('\u{10027}', '\u{10027}'), ('\u{1003b}', '\u{1003b}'), ('\u{1003e}', '\u{1003e}'),
        ('\u{1004e}', '\u{1004f}'), ('\u{1005e}', '\u{1007f}'), ('\u{100fb}', '\u{100ff}'),
        ('\u{10103}', '\u{10106}'), ('\u{10134}', '\u{10136}'), ('\u{1018d}', '\u{1018f}'),
        ('\u{1019c}', '\u{1019f}'), ('\u{101a1}', '\u{101cf}'), ('\u{101fe}', '\u{1027f}'),
        ('\u{1029d}', '\u{1029f}'), ('\u{102d1}', '\u{102df}'), ('\u{102fc}', '\u{102ff}'),
        ('\u{10324}', '\u{1032f}'), ('\u{1034b}', '\u{1034f}'), ('\u{1037b}', '\u{1037f}'),
        ('\u{1039e}', '\u{1039e}'), ('\u{103c4}', '\u{103c7}'), ('\u{103d6}', '\u{103ff}'),
        ('\u{1049e}', '\u{1049f}'), ('\u{104aa}', '\u{104ff}'), ('\u{10528}', '\u{1052f}'),
        ('\u{10564}', '\u{1056e}'), ('\u{10570}', '\u{105ff}'), ('\u{10737}', '\u{1073f}'),
        ('\u{10756}', '\u{1075f}'), ('\u{10768}', '\u{107ff}'), ('\u{10806}', '\u{10807}'),
        ('\u{10809}', '\u{10809}'), ('\u{10836}', '\u{10836}'), ('\u{10839}', '\u{1083b}'),
        ('\u{1083d}', '\u{1083e}'), ('\u{10856}', '\u{10856}'), ('\u{1089f}', '\u{108a6}'),
        ('\u{108b0}', '\u{108ff}'), ('\u{1091c}', '\u{1091e}'), ('\u{1093a}', '\u{1093e}'),
        ('\u{10940}', '\u{1097f}'), ('\u{109b8}', '\u{109bd}'), ('\u{109c0}', '\u{109ff}'),
        ('\u{10a04}', '\u{10a04}'), ('\u{10a07}', '\u{10a0b}'), ('\u{10a14}', '\u{10a14}'),
        ('\u{10a18}', '\u{10a18}'), ('\u{10a34}', '\u{10a37}'), ('\u{10a3b}', '\u{10a3e}'),
        ('\u{10a48}', '\u{10a4f}'), ('\u{10a59}', '\u{10a5f}'), ('\u{10aa0}', '\u{10abf}'),
        ('\u{10ae7}', '\u{10aea}'), ('\u{10af7}', '\u{10aff}'), ('\u{10b36}', '\u{10b38}'),
        ('\u{10b56}', '\u{10b57}'), ('\u{10b73}', '\u{10b77}'), ('\u{10b92}', '\u{10b98}'),
        ('\u{10b9d}', '\u{10ba8}'), ('\u{10bb0}', '\u{10bff}'), ('\u{10c49}', '\u{10e5f}'),
        ('\u{10e7f}', '\u{10fff}'), ('\u{1104e}', '\u{11051}'), ('\u{11070}', '\u{1107e}'),
        ('\u{110bd}', '\u{110bd}'), ('\u{110c2}', '\u{110cf}'), ('\u{110e9}', '\u{110ef}'),
        ('\u{110fa}', '\u{110ff}'), ('\u{11135}', '\u{11135}'), ('\u{11144}', '\u{1114f}'),
        ('\u{11177}', '\u{1117f}'), ('\u{111c9}', '\u{111cc}'), ('\u{111ce}', '\u{111cf}'),
        ('\u{111db}', '\u{111e0}'), ('\u{111f5}', '\u{111ff}'), ('\u{11212}', '\u{11212}'),
        ('\u{1123e}', '\u{112af}'), ('\u{112eb}', '\u{112ef}'), ('\u{112fa}', '\u{11300}'),
        ('\u{11304}', '\u{11304}'), ('\u{1130d}', '\u{1130e}'), ('\u{11311}', '\u{11312}'),
        ('\u{11329}', '\u{11329}'), ('\u{11331}', '\u{11331}'), ('\u{11334}', '\u{11334}'),
        ('\u{1133a}', '\u{1133b}'), ('\u{11345}', '\u{11346}'), ('\u{11349}', '\u{1134a}'),
        ('\u{1134e}', '\u{11356}'), ('\u{11358}', '\u{1135c}'), ('\u{11364}', '\u{11365}'),
        ('\u{1136d}', '\u{1136f}'), ('\u{11375}', '\u{1147f}'), ('\u{114c8}', '\u{114cf}'),
        ('\u{114da}', '\u{1157f}'), ('\u{115b6}', '\u{115b7}'), ('\u{115ca}', '\u{115ff}'),
        ('\u{11645}', '\u{1164f}'), ('\u{1165a}', '\u{1167f}'), ('\u{116b8}', '\u{116bf}'),
        ('\u{116ca}', '\u{1189f}'), ('\u{118f3}', '\u{118fe}'), ('\u{11900}', '\u{11abf}'),
        ('\u{11af9}', '\u{11fff}'), ('\u{12399}', '\u{123ff}'), ('\u{1246f}', '\u{1246f}'),
        ('\u{12475}', '\u{12fff}'), ('\u{1342f}', '\u{167ff}'), ('\u{16a39}', '\u{16a3f}'),
        ('\u{16a5f}', '\u{16a5f}'), ('\u{16a6a}', '\u{16a6d}'), ('\u{16a70}', '\u{16acf}'),
        ('\u{16aee}', '\u{16aef}'), ('\u{16af6}', '\u{16aff}'), ('\u{16b46}', '\u{16b4f}'),
        ('\u{16b5a}', '\u{16b5a}'), ('\u{16b62}', '\u{16b62}'), ('\u{16b78}', '\u{16b7c}'),
        ('\u{16b90}', '\u{16eff}'), ('\u{16f45}', '\u{16f4f}'), ('\u{16f7f}', '\u{16f8e}'),
        ('\u{16fa0}', '\u{1afff}'), ('\u{1b002}', '\u{1bbff}'), ('\u{1bc6b}', '\u{1bc6f}'),
        ('\u{1bc7d}', '\u{1bc7f}'), ('\u{1bc89}', '\u{1bc8f}'), ('\u{1bc9a}', '\u{1bc9b}'),
        ('\u{1bca0}', '\u{1cfff}'), ('\u{1d0f6}', '\u{1d0ff}'), ('\u{1d127}', '\u{1d128}'),
        ('\u{1d173}', '\u{1d17a}'), ('\u{1d1de}', '\u{1d1ff}'), ('\u{1d246}', '\u{1d2ff}'),
        ('\u{1d357}', '\u{1d35f}'), ('\u{1d372}', '\u{1d3ff}'), ('\u{1d455}', '\u{1d455}'),
        ('\u{1d49d}', '\u{1d49d}'), ('\u{1d4a0}', '\u{1d4a1}'), ('\u{1d4a3}', '\u{1d4a4}'),
        ('\u{1d4a7}', '\u{1d4a8}'), ('\u{1d4ad}', '\u{1d4ad}'), ('\u{1d4ba}', '\u{1d4ba}'),
        ('\u{1d4bc}', '\u{1d4bc}'), ('\u{1d4c4}', '\u{1d4c4}'), ('\u{1d506}', '\u{1d506}'),
        ('\u{1d50b}', '\u{1d50c}'), ('\u{1d515}', '\u{1d515}'), ('\u{1d51d}', '\u{1d51d}'),
        ('\u{1d53a}', '\u{1d53a}'), ('\u{1d53f}', '\u{1d53f}'), ('\u{1d545}', '\u{1d545}'),
        ('\u{1d547}', '\u{1d549}'), ('\u{1d551}', '\u{1d551}'), ('\u{1d6a6}', '\u{1d6a7}'),
        ('\u{1d7cc}', '\u{1d7cd}'), ('\u{1d800}', '\u{1e7ff}'), ('\u{1e8c5}', '\u{1e8c6}'),
        ('\u{1e8d7}', '\u{1edff}'), ('\u{1ee04}', '\u{1ee04}'), ('\u{1ee20}', '\u{1ee20}'),
        ('\u{1ee23}', '\u{1ee23}'), ('\u{1ee25}', '\u{1ee26}'), ('\u{1ee28}', '\u{1ee28}'),
        ('\u{1ee33}', '\u{1ee33}'), ('\u{1ee38}', '\u{1ee38}'), ('\u{1ee3a}', '\u{1ee3a}'),
        ('\u{1ee3c}', '\u{1ee41}'), ('\u{1ee43}', '\u{1ee46}'), ('\u{1ee48}', '\u{1ee48}'),
        ('\u{1ee4a}', '\u{1ee4a}'), ('\u{1ee4c}', '\u{1ee4c}'), ('\u{1ee50}', '\u{1ee50}'),
        ('\u{1ee53}', '\u{1ee53}'), ('\u{1ee55}', '\u{1ee56}'), ('\u{1ee58}', '\u{1ee58}'),
        ('\u{1ee5a}', '\u{1ee5a}'), ('\u{1ee5c}', '\u{1ee5c}'), ('\u{1ee5e}', '\u{1ee5e}'),
        ('\u{1ee60}', '\u{1ee60}'), ('\u{1ee63}', '\u{1ee63}'), ('\u{1ee65}', '\u{1ee66}'),
        ('\u{1ee6b}', '\u{1ee6b}'), ('\u{1ee73}', '\u{1ee73}'), ('\u{1ee78}', '\u{1ee78}'),
        ('\u{1ee7d}', '\u{1ee7d}'), ('\u{1ee7f}', '\u{1ee7f}'), ('\u{1ee8a}', '\u{1ee8a}'),
        ('\u{1ee9c}', '\u{1eea0}'), ('\u{1eea4}', '\u{1eea4}'), ('\u{1eeaa}', '\u{1eeaa}'),
        ('\u{1eebc}', '\u{1eeef}'), ('\u{1eef2}', '\u{1efff}'), ('\u{1f02c}', '\u{1f02f}'),
        ('\u{1f094}', '\u{1f09f}'), ('\u{1f0af}', '\u{1f0b0}'), ('\u{1f0c0}', '\u{1f0c0}'),
        ('\u{1f0d0}', '\u{1f0d0}'), ('\u{1f0f6}', '\u{1f0ff}'), ('\u{1f10d}', '\u{1f10f}'),
        ('\u{1f12f}', '\u{1f12f}'), ('\u{1f16c}', '\u{1f16f}'), ('\u{1f19b}', '\u{1f1e5}'),
        ('\u{1f203}', '\u{1f20f}'), ('\u{1f23b}', '\u{1f23f}'), ('\u{1f249}', '\u{1f24f}'),
        ('\u{1f252}', '\u{1f2ff}'), ('\u{1f32d}', '\u{1f32f}'), ('\u{1f37e}', '\u{1f37f}'),
        ('\u{1f3cf}', '\u{1f3d3}'), ('\u{1f3f8}', '\u{1f3ff}'), ('\u{1f4ff}', '\u{1f4ff}'),
        ('\u{1f54b}', '\u{1f54f}'), ('\u{1f57a}', '\u{1f57a}'), ('\u{1f5a4}', '\u{1f5a4}'),
        ('\u{1f643}', '\u{1f644}'), ('\u{1f6d0}', '\u{1f6df}'), ('\u{1f6ed}', '\u{1f6ef}'),
        ('\u{1f6f4}', '\u{1f6ff}'), ('\u{1f774}', '\u{1f77f}'), ('\u{1f7d5}', '\u{1f7ff}'),
        ('\u{1f80c}', '\u{1f80f}'), ('\u{1f848}', '\u{1f84f}'), ('\u{1f85a}', '\u{1f85f}'),
        ('\u{1f888}', '\u{1f88f}'), ('\u{1f8ae}', '\u{1ffff}'), ('\u{20001}', '\u{2a6d5}'),
        ('\u{2a6d7}', '\u{2a6ff}'), ('\u{2a701}', '\u{2b733}'), ('\u{2b735}', '\u{2b73f}'),
        ('\u{2b741}', '\u{2b81c}'), ('\u{2b81e}', '\u{2f7ff}'), ('\u{2fa1e}', '\u{e00ff}'),
        ('\u{e01f0}', '\u{10ffff}')
    ];

    pub static Cc_table: &'static [(char, char)] = &[
        ('\u{0}', '\u{1f}'), ('\u{7f}', '\u{9f}')
    ];

    pub fn Cc(c: char) -> bool {
        super::bsearch_range_table(c, Cc_table)
    }

    pub static Cf_table: &'static [(char, char)] = &[
        ('\u{ad}', '\u{ad}'), ('\u{600}', '\u{605}'), ('\u{61c}', '\u{61c}'), ('\u{6dd}',
        '\u{6dd}'), ('\u{70f}', '\u{70f}'), ('\u{180e}', '\u{180e}'), ('\u{200b}', '\u{200f}'),
        ('\u{202a}', '\u{202e}'), ('\u{2060}', '\u{2064}'), ('\u{2066}', '\u{206f}'), ('\u{feff}',
        '\u{feff}'), ('\u{fff9}', '\u{fffb}'), ('\u{110bd}', '\u{110bd}'), ('\u{1bca0}',
        '\u{1bca3}'), ('\u{1d173}', '\u{1d17a}'), ('\u{e0001}', '\u{e0001}'), ('\u{e0020}',
        '\u{e007f}')
    ];

    pub static Cn_table: &'static [(char, char)] = &[
        ('\u{378}', '\u{379}'), ('\u{380}', '\u{383}'), ('\u{38b}', '\u{38b}'), ('\u{38d}',
        '\u{38d}'), ('\u{3a2}', '\u{3a2}'), ('\u{530}', '\u{530}'), ('\u{557}', '\u{558}'),
        ('\u{560}', '\u{560}'), ('\u{588}', '\u{588}'), ('\u{58b}', '\u{58c}'), ('\u{590}',
        '\u{590}'), ('\u{5c8}', '\u{5cf}'), ('\u{5eb}', '\u{5ef}'), ('\u{5f5}', '\u{5ff}'),
        ('\u{61d}', '\u{61d}'), ('\u{70e}', '\u{70e}'), ('\u{74b}', '\u{74c}'), ('\u{7b2}',
        '\u{7bf}'), ('\u{7fb}', '\u{7ff}'), ('\u{82e}', '\u{82f}'), ('\u{83f}', '\u{83f}'),
        ('\u{85c}', '\u{85d}'), ('\u{85f}', '\u{89f}'), ('\u{8b3}', '\u{8e3}'), ('\u{984}',
        '\u{984}'), ('\u{98d}', '\u{98e}'), ('\u{991}', '\u{992}'), ('\u{9a9}', '\u{9a9}'),
        ('\u{9b1}', '\u{9b1}'), ('\u{9b3}', '\u{9b5}'), ('\u{9ba}', '\u{9bb}'), ('\u{9c5}',
        '\u{9c6}'), ('\u{9c9}', '\u{9ca}'), ('\u{9cf}', '\u{9d6}'), ('\u{9d8}', '\u{9db}'),
        ('\u{9de}', '\u{9de}'), ('\u{9e4}', '\u{9e5}'), ('\u{9fc}', '\u{a00}'), ('\u{a04}',
        '\u{a04}'), ('\u{a0b}', '\u{a0e}'), ('\u{a11}', '\u{a12}'), ('\u{a29}', '\u{a29}'),
        ('\u{a31}', '\u{a31}'), ('\u{a34}', '\u{a34}'), ('\u{a37}', '\u{a37}'), ('\u{a3a}',
        '\u{a3b}'), ('\u{a3d}', '\u{a3d}'), ('\u{a43}', '\u{a46}'), ('\u{a49}', '\u{a4a}'),
        ('\u{a4e}', '\u{a50}'), ('\u{a52}', '\u{a58}'), ('\u{a5d}', '\u{a5d}'), ('\u{a5f}',
        '\u{a65}'), ('\u{a76}', '\u{a80}'), ('\u{a84}', '\u{a84}'), ('\u{a8e}', '\u{a8e}'),
        ('\u{a92}', '\u{a92}'), ('\u{aa9}', '\u{aa9}'), ('\u{ab1}', '\u{ab1}'), ('\u{ab4}',
        '\u{ab4}'), ('\u{aba}', '\u{abb}'), ('\u{ac6}', '\u{ac6}'), ('\u{aca}', '\u{aca}'),
        ('\u{ace}', '\u{acf}'), ('\u{ad1}', '\u{adf}'), ('\u{ae4}', '\u{ae5}'), ('\u{af2}',
        '\u{b00}'), ('\u{b04}', '\u{b04}'), ('\u{b0d}', '\u{b0e}'), ('\u{b11}', '\u{b12}'),
        ('\u{b29}', '\u{b29}'), ('\u{b31}', '\u{b31}'), ('\u{b34}', '\u{b34}'), ('\u{b3a}',
        '\u{b3b}'), ('\u{b45}', '\u{b46}'), ('\u{b49}', '\u{b4a}'), ('\u{b4e}', '\u{b55}'),
        ('\u{b58}', '\u{b5b}'), ('\u{b5e}', '\u{b5e}'), ('\u{b64}', '\u{b65}'), ('\u{b78}',
        '\u{b81}'), ('\u{b84}', '\u{b84}'), ('\u{b8b}', '\u{b8d}'), ('\u{b91}', '\u{b91}'),
        ('\u{b96}', '\u{b98}'), ('\u{b9b}', '\u{b9b}'), ('\u{b9d}', '\u{b9d}'), ('\u{ba0}',
        '\u{ba2}'), ('\u{ba5}', '\u{ba7}'), ('\u{bab}', '\u{bad}'), ('\u{bba}', '\u{bbd}'),
        ('\u{bc3}', '\u{bc5}'), ('\u{bc9}', '\u{bc9}'), ('\u{bce}', '\u{bcf}'), ('\u{bd1}',
        '\u{bd6}'), ('\u{bd8}', '\u{be5}'), ('\u{bfb}', '\u{bff}'), ('\u{c04}', '\u{c04}'),
        ('\u{c0d}', '\u{c0d}'), ('\u{c11}', '\u{c11}'), ('\u{c29}', '\u{c29}'), ('\u{c3a}',
        '\u{c3c}'), ('\u{c45}', '\u{c45}'), ('\u{c49}', '\u{c49}'), ('\u{c4e}', '\u{c54}'),
        ('\u{c57}', '\u{c57}'), ('\u{c5a}', '\u{c5f}'), ('\u{c64}', '\u{c65}'), ('\u{c70}',
        '\u{c77}'), ('\u{c80}', '\u{c80}'), ('\u{c84}', '\u{c84}'), ('\u{c8d}', '\u{c8d}'),
        ('\u{c91}', '\u{c91}'), ('\u{ca9}', '\u{ca9}'), ('\u{cb4}', '\u{cb4}'), ('\u{cba}',
        '\u{cbb}'), ('\u{cc5}', '\u{cc5}'), ('\u{cc9}', '\u{cc9}'), ('\u{cce}', '\u{cd4}'),
        ('\u{cd7}', '\u{cdd}'), ('\u{cdf}', '\u{cdf}'), ('\u{ce4}', '\u{ce5}'), ('\u{cf0}',
        '\u{cf0}'), ('\u{cf3}', '\u{d00}'), ('\u{d04}', '\u{d04}'), ('\u{d0d}', '\u{d0d}'),
        ('\u{d11}', '\u{d11}'), ('\u{d3b}', '\u{d3c}'), ('\u{d45}', '\u{d45}'), ('\u{d49}',
        '\u{d49}'), ('\u{d4f}', '\u{d56}'), ('\u{d58}', '\u{d5f}'), ('\u{d64}', '\u{d65}'),
        ('\u{d76}', '\u{d78}'), ('\u{d80}', '\u{d81}'), ('\u{d84}', '\u{d84}'), ('\u{d97}',
        '\u{d99}'), ('\u{db2}', '\u{db2}'), ('\u{dbc}', '\u{dbc}'), ('\u{dbe}', '\u{dbf}'),
        ('\u{dc7}', '\u{dc9}'), ('\u{dcb}', '\u{dce}'), ('\u{dd5}', '\u{dd5}'), ('\u{dd7}',
        '\u{dd7}'), ('\u{de0}', '\u{de5}'), ('\u{df0}', '\u{df1}'), ('\u{df5}', '\u{e00}'),
        ('\u{e3b}', '\u{e3e}'), ('\u{e5c}', '\u{e80}'), ('\u{e83}', '\u{e83}'), ('\u{e85}',
        '\u{e86}'), ('\u{e89}', '\u{e89}'), ('\u{e8b}', '\u{e8c}'), ('\u{e8e}', '\u{e93}'),
        ('\u{e98}', '\u{e98}'), ('\u{ea0}', '\u{ea0}'), ('\u{ea4}', '\u{ea4}'), ('\u{ea6}',
        '\u{ea6}'), ('\u{ea8}', '\u{ea9}'), ('\u{eac}', '\u{eac}'), ('\u{eba}', '\u{eba}'),
        ('\u{ebe}', '\u{ebf}'), ('\u{ec5}', '\u{ec5}'), ('\u{ec7}', '\u{ec7}'), ('\u{ece}',
        '\u{ecf}'), ('\u{eda}', '\u{edb}'), ('\u{ee0}', '\u{eff}'), ('\u{f48}', '\u{f48}'),
        ('\u{f6d}', '\u{f70}'), ('\u{f98}', '\u{f98}'), ('\u{fbd}', '\u{fbd}'), ('\u{fcd}',
        '\u{fcd}'), ('\u{fdb}', '\u{fff}'), ('\u{10c6}', '\u{10c6}'), ('\u{10c8}', '\u{10cc}'),
        ('\u{10ce}', '\u{10cf}'), ('\u{1249}', '\u{1249}'), ('\u{124e}', '\u{124f}'), ('\u{1257}',
        '\u{1257}'), ('\u{1259}', '\u{1259}'), ('\u{125e}', '\u{125f}'), ('\u{1289}', '\u{1289}'),
        ('\u{128e}', '\u{128f}'), ('\u{12b1}', '\u{12b1}'), ('\u{12b6}', '\u{12b7}'), ('\u{12bf}',
        '\u{12bf}'), ('\u{12c1}', '\u{12c1}'), ('\u{12c6}', '\u{12c7}'), ('\u{12d7}', '\u{12d7}'),
        ('\u{1311}', '\u{1311}'), ('\u{1316}', '\u{1317}'), ('\u{135b}', '\u{135c}'), ('\u{137d}',
        '\u{137f}'), ('\u{139a}', '\u{139f}'), ('\u{13f5}', '\u{13ff}'), ('\u{169d}', '\u{169f}'),
        ('\u{16f9}', '\u{16ff}'), ('\u{170d}', '\u{170d}'), ('\u{1715}', '\u{171f}'), ('\u{1737}',
        '\u{173f}'), ('\u{1754}', '\u{175f}'), ('\u{176d}', '\u{176d}'), ('\u{1771}', '\u{1771}'),
        ('\u{1774}', '\u{177f}'), ('\u{17de}', '\u{17df}'), ('\u{17ea}', '\u{17ef}'), ('\u{17fa}',
        '\u{17ff}'), ('\u{180f}', '\u{180f}'), ('\u{181a}', '\u{181f}'), ('\u{1878}', '\u{187f}'),
        ('\u{18ab}', '\u{18af}'), ('\u{18f6}', '\u{18ff}'), ('\u{191f}', '\u{191f}'), ('\u{192c}',
        '\u{192f}'), ('\u{193c}', '\u{193f}'), ('\u{1941}', '\u{1943}'), ('\u{196e}', '\u{196f}'),
        ('\u{1975}', '\u{197f}'), ('\u{19ac}', '\u{19af}'), ('\u{19ca}', '\u{19cf}'), ('\u{19db}',
        '\u{19dd}'), ('\u{1a1c}', '\u{1a1d}'), ('\u{1a5f}', '\u{1a5f}'), ('\u{1a7d}', '\u{1a7e}'),
        ('\u{1a8a}', '\u{1a8f}'), ('\u{1a9a}', '\u{1a9f}'), ('\u{1aae}', '\u{1aaf}'), ('\u{1abf}',
        '\u{1aff}'), ('\u{1b4c}', '\u{1b4f}'), ('\u{1b7d}', '\u{1b7f}'), ('\u{1bf4}', '\u{1bfb}'),
        ('\u{1c38}', '\u{1c3a}'), ('\u{1c4a}', '\u{1c4c}'), ('\u{1c80}', '\u{1cbf}'), ('\u{1cc8}',
        '\u{1ccf}'), ('\u{1cf7}', '\u{1cf7}'), ('\u{1cfa}', '\u{1cff}'), ('\u{1df6}', '\u{1dfb}'),
        ('\u{1f16}', '\u{1f17}'), ('\u{1f1e}', '\u{1f1f}'), ('\u{1f46}', '\u{1f47}'), ('\u{1f4e}',
        '\u{1f4f}'), ('\u{1f58}', '\u{1f58}'), ('\u{1f5a}', '\u{1f5a}'), ('\u{1f5c}', '\u{1f5c}'),
        ('\u{1f5e}', '\u{1f5e}'), ('\u{1f7e}', '\u{1f7f}'), ('\u{1fb5}', '\u{1fb5}'), ('\u{1fc5}',
        '\u{1fc5}'), ('\u{1fd4}', '\u{1fd5}'), ('\u{1fdc}', '\u{1fdc}'), ('\u{1ff0}', '\u{1ff1}'),
        ('\u{1ff5}', '\u{1ff5}'), ('\u{1fff}', '\u{1fff}'), ('\u{2065}', '\u{2065}'), ('\u{2072}',
        '\u{2073}'), ('\u{208f}', '\u{208f}'), ('\u{209d}', '\u{209f}'), ('\u{20be}', '\u{20cf}'),
        ('\u{20f1}', '\u{20ff}'), ('\u{218a}', '\u{218f}'), ('\u{23fb}', '\u{23ff}'), ('\u{2427}',
        '\u{243f}'), ('\u{244b}', '\u{245f}'), ('\u{2b74}', '\u{2b75}'), ('\u{2b96}', '\u{2b97}'),
        ('\u{2bba}', '\u{2bbc}'), ('\u{2bc9}', '\u{2bc9}'), ('\u{2bd2}', '\u{2bff}'), ('\u{2c2f}',
        '\u{2c2f}'), ('\u{2c5f}', '\u{2c5f}'), ('\u{2cf4}', '\u{2cf8}'), ('\u{2d26}', '\u{2d26}'),
        ('\u{2d28}', '\u{2d2c}'), ('\u{2d2e}', '\u{2d2f}'), ('\u{2d68}', '\u{2d6e}'), ('\u{2d71}',
        '\u{2d7e}'), ('\u{2d97}', '\u{2d9f}'), ('\u{2da7}', '\u{2da7}'), ('\u{2daf}', '\u{2daf}'),
        ('\u{2db7}', '\u{2db7}'), ('\u{2dbf}', '\u{2dbf}'), ('\u{2dc7}', '\u{2dc7}'), ('\u{2dcf}',
        '\u{2dcf}'), ('\u{2dd7}', '\u{2dd7}'), ('\u{2ddf}', '\u{2ddf}'), ('\u{2e43}', '\u{2e7f}'),
        ('\u{2e9a}', '\u{2e9a}'), ('\u{2ef4}', '\u{2eff}'), ('\u{2fd6}', '\u{2fef}'), ('\u{2ffc}',
        '\u{2fff}'), ('\u{3040}', '\u{3040}'), ('\u{3097}', '\u{3098}'), ('\u{3100}', '\u{3104}'),
        ('\u{312e}', '\u{3130}'), ('\u{318f}', '\u{318f}'), ('\u{31bb}', '\u{31bf}'), ('\u{31e4}',
        '\u{31ef}'), ('\u{321f}', '\u{321f}'), ('\u{32ff}', '\u{32ff}'), ('\u{3401}', '\u{4db4}'),
        ('\u{4db6}', '\u{4dbf}'), ('\u{4e01}', '\u{9fcb}'), ('\u{9fcd}', '\u{9fff}'), ('\u{a48d}',
        '\u{a48f}'), ('\u{a4c7}', '\u{a4cf}'), ('\u{a62c}', '\u{a63f}'), ('\u{a69e}', '\u{a69e}'),
        ('\u{a6f8}', '\u{a6ff}'), ('\u{a78f}', '\u{a78f}'), ('\u{a7ae}', '\u{a7af}'), ('\u{a7b2}',
        '\u{a7f6}'), ('\u{a82c}', '\u{a82f}'), ('\u{a83a}', '\u{a83f}'), ('\u{a878}', '\u{a87f}'),
        ('\u{a8c5}', '\u{a8cd}'), ('\u{a8da}', '\u{a8df}'), ('\u{a8fc}', '\u{a8ff}'), ('\u{a954}',
        '\u{a95e}'), ('\u{a97d}', '\u{a97f}'), ('\u{a9ce}', '\u{a9ce}'), ('\u{a9da}', '\u{a9dd}'),
        ('\u{a9ff}', '\u{a9ff}'), ('\u{aa37}', '\u{aa3f}'), ('\u{aa4e}', '\u{aa4f}'), ('\u{aa5a}',
        '\u{aa5b}'), ('\u{aac3}', '\u{aada}'), ('\u{aaf7}', '\u{ab00}'), ('\u{ab07}', '\u{ab08}'),
        ('\u{ab0f}', '\u{ab10}'), ('\u{ab17}', '\u{ab1f}'), ('\u{ab27}', '\u{ab27}'), ('\u{ab2f}',
        '\u{ab2f}'), ('\u{ab60}', '\u{ab63}'), ('\u{ab66}', '\u{abbf}'), ('\u{abee}', '\u{abef}'),
        ('\u{abfa}', '\u{abff}'), ('\u{ac01}', '\u{d7a2}'), ('\u{d7a4}', '\u{d7af}'), ('\u{d7c7}',
        '\u{d7ca}'), ('\u{d7fc}', '\u{d7ff}'), ('\u{e001}', '\u{f8fe}'), ('\u{fa6e}', '\u{fa6f}'),
        ('\u{fada}', '\u{faff}'), ('\u{fb07}', '\u{fb12}'), ('\u{fb18}', '\u{fb1c}'), ('\u{fb37}',
        '\u{fb37}'), ('\u{fb3d}', '\u{fb3d}'), ('\u{fb3f}', '\u{fb3f}'), ('\u{fb42}', '\u{fb42}'),
        ('\u{fb45}', '\u{fb45}'), ('\u{fbc2}', '\u{fbd2}'), ('\u{fd40}', '\u{fd4f}'), ('\u{fd90}',
        '\u{fd91}'), ('\u{fdc8}', '\u{fdef}'), ('\u{fdfe}', '\u{fdff}'), ('\u{fe1a}', '\u{fe1f}'),
        ('\u{fe2e}', '\u{fe2f}'), ('\u{fe53}', '\u{fe53}'), ('\u{fe67}', '\u{fe67}'), ('\u{fe6c}',
        '\u{fe6f}'), ('\u{fe75}', '\u{fe75}'), ('\u{fefd}', '\u{fefe}'), ('\u{ff00}', '\u{ff00}'),
        ('\u{ffbf}', '\u{ffc1}'), ('\u{ffc8}', '\u{ffc9}'), ('\u{ffd0}', '\u{ffd1}'), ('\u{ffd8}',
        '\u{ffd9}'), ('\u{ffdd}', '\u{ffdf}'), ('\u{ffe7}', '\u{ffe7}'), ('\u{ffef}', '\u{fff8}'),
        ('\u{fffe}', '\u{ffff}'), ('\u{1000c}', '\u{1000c}'), ('\u{10027}', '\u{10027}'),
        ('\u{1003b}', '\u{1003b}'), ('\u{1003e}', '\u{1003e}'), ('\u{1004e}', '\u{1004f}'),
        ('\u{1005e}', '\u{1007f}'), ('\u{100fb}', '\u{100ff}'), ('\u{10103}', '\u{10106}'),
        ('\u{10134}', '\u{10136}'), ('\u{1018d}', '\u{1018f}'), ('\u{1019c}', '\u{1019f}'),
        ('\u{101a1}', '\u{101cf}'), ('\u{101fe}', '\u{1027f}'), ('\u{1029d}', '\u{1029f}'),
        ('\u{102d1}', '\u{102df}'), ('\u{102fc}', '\u{102ff}'), ('\u{10324}', '\u{1032f}'),
        ('\u{1034b}', '\u{1034f}'), ('\u{1037b}', '\u{1037f}'), ('\u{1039e}', '\u{1039e}'),
        ('\u{103c4}', '\u{103c7}'), ('\u{103d6}', '\u{103ff}'), ('\u{1049e}', '\u{1049f}'),
        ('\u{104aa}', '\u{104ff}'), ('\u{10528}', '\u{1052f}'), ('\u{10564}', '\u{1056e}'),
        ('\u{10570}', '\u{105ff}'), ('\u{10737}', '\u{1073f}'), ('\u{10756}', '\u{1075f}'),
        ('\u{10768}', '\u{107ff}'), ('\u{10806}', '\u{10807}'), ('\u{10809}', '\u{10809}'),
        ('\u{10836}', '\u{10836}'), ('\u{10839}', '\u{1083b}'), ('\u{1083d}', '\u{1083e}'),
        ('\u{10856}', '\u{10856}'), ('\u{1089f}', '\u{108a6}'), ('\u{108b0}', '\u{108ff}'),
        ('\u{1091c}', '\u{1091e}'), ('\u{1093a}', '\u{1093e}'), ('\u{10940}', '\u{1097f}'),
        ('\u{109b8}', '\u{109bd}'), ('\u{109c0}', '\u{109ff}'), ('\u{10a04}', '\u{10a04}'),
        ('\u{10a07}', '\u{10a0b}'), ('\u{10a14}', '\u{10a14}'), ('\u{10a18}', '\u{10a18}'),
        ('\u{10a34}', '\u{10a37}'), ('\u{10a3b}', '\u{10a3e}'), ('\u{10a48}', '\u{10a4f}'),
        ('\u{10a59}', '\u{10a5f}'), ('\u{10aa0}', '\u{10abf}'), ('\u{10ae7}', '\u{10aea}'),
        ('\u{10af7}', '\u{10aff}'), ('\u{10b36}', '\u{10b38}'), ('\u{10b56}', '\u{10b57}'),
        ('\u{10b73}', '\u{10b77}'), ('\u{10b92}', '\u{10b98}'), ('\u{10b9d}', '\u{10ba8}'),
        ('\u{10bb0}', '\u{10bff}'), ('\u{10c49}', '\u{10e5f}'), ('\u{10e7f}', '\u{10fff}'),
        ('\u{1104e}', '\u{11051}'), ('\u{11070}', '\u{1107e}'), ('\u{110c2}', '\u{110cf}'),
        ('\u{110e9}', '\u{110ef}'), ('\u{110fa}', '\u{110ff}'), ('\u{11135}', '\u{11135}'),
        ('\u{11144}', '\u{1114f}'), ('\u{11177}', '\u{1117f}'), ('\u{111c9}', '\u{111cc}'),
        ('\u{111ce}', '\u{111cf}'), ('\u{111db}', '\u{111e0}'), ('\u{111f5}', '\u{111ff}'),
        ('\u{11212}', '\u{11212}'), ('\u{1123e}', '\u{112af}'), ('\u{112eb}', '\u{112ef}'),
        ('\u{112fa}', '\u{11300}'), ('\u{11304}', '\u{11304}'), ('\u{1130d}', '\u{1130e}'),
        ('\u{11311}', '\u{11312}'), ('\u{11329}', '\u{11329}'), ('\u{11331}', '\u{11331}'),
        ('\u{11334}', '\u{11334}'), ('\u{1133a}', '\u{1133b}'), ('\u{11345}', '\u{11346}'),
        ('\u{11349}', '\u{1134a}'), ('\u{1134e}', '\u{11356}'), ('\u{11358}', '\u{1135c}'),
        ('\u{11364}', '\u{11365}'), ('\u{1136d}', '\u{1136f}'), ('\u{11375}', '\u{1147f}'),
        ('\u{114c8}', '\u{114cf}'), ('\u{114da}', '\u{1157f}'), ('\u{115b6}', '\u{115b7}'),
        ('\u{115ca}', '\u{115ff}'), ('\u{11645}', '\u{1164f}'), ('\u{1165a}', '\u{1167f}'),
        ('\u{116b8}', '\u{116bf}'), ('\u{116ca}', '\u{1189f}'), ('\u{118f3}', '\u{118fe}'),
        ('\u{11900}', '\u{11abf}'), ('\u{11af9}', '\u{11fff}'), ('\u{12399}', '\u{123ff}'),
        ('\u{1246f}', '\u{1246f}'), ('\u{12475}', '\u{12fff}'), ('\u{1342f}', '\u{167ff}'),
        ('\u{16a39}', '\u{16a3f}'), ('\u{16a5f}', '\u{16a5f}'), ('\u{16a6a}', '\u{16a6d}'),
        ('\u{16a70}', '\u{16acf}'), ('\u{16aee}', '\u{16aef}'), ('\u{16af6}', '\u{16aff}'),
        ('\u{16b46}', '\u{16b4f}'), ('\u{16b5a}', '\u{16b5a}'), ('\u{16b62}', '\u{16b62}'),
        ('\u{16b78}', '\u{16b7c}'), ('\u{16b90}', '\u{16eff}'), ('\u{16f45}', '\u{16f4f}'),
        ('\u{16f7f}', '\u{16f8e}'), ('\u{16fa0}', '\u{1afff}'), ('\u{1b002}', '\u{1bbff}'),
        ('\u{1bc6b}', '\u{1bc6f}'), ('\u{1bc7d}', '\u{1bc7f}'), ('\u{1bc89}', '\u{1bc8f}'),
        ('\u{1bc9a}', '\u{1bc9b}'), ('\u{1bca4}', '\u{1cfff}'), ('\u{1d0f6}', '\u{1d0ff}'),
        ('\u{1d127}', '\u{1d128}'), ('\u{1d1de}', '\u{1d1ff}'), ('\u{1d246}', '\u{1d2ff}'),
        ('\u{1d357}', '\u{1d35f}'), ('\u{1d372}', '\u{1d3ff}'), ('\u{1d455}', '\u{1d455}'),
        ('\u{1d49d}', '\u{1d49d}'), ('\u{1d4a0}', '\u{1d4a1}'), ('\u{1d4a3}', '\u{1d4a4}'),
        ('\u{1d4a7}', '\u{1d4a8}'), ('\u{1d4ad}', '\u{1d4ad}'), ('\u{1d4ba}', '\u{1d4ba}'),
        ('\u{1d4bc}', '\u{1d4bc}'), ('\u{1d4c4}', '\u{1d4c4}'), ('\u{1d506}', '\u{1d506}'),
        ('\u{1d50b}', '\u{1d50c}'), ('\u{1d515}', '\u{1d515}'), ('\u{1d51d}', '\u{1d51d}'),
        ('\u{1d53a}', '\u{1d53a}'), ('\u{1d53f}', '\u{1d53f}'), ('\u{1d545}', '\u{1d545}'),
        ('\u{1d547}', '\u{1d549}'), ('\u{1d551}', '\u{1d551}'), ('\u{1d6a6}', '\u{1d6a7}'),
        ('\u{1d7cc}', '\u{1d7cd}'), ('\u{1d800}', '\u{1e7ff}'), ('\u{1e8c5}', '\u{1e8c6}'),
        ('\u{1e8d7}', '\u{1edff}'), ('\u{1ee04}', '\u{1ee04}'), ('\u{1ee20}', '\u{1ee20}'),
        ('\u{1ee23}', '\u{1ee23}'), ('\u{1ee25}', '\u{1ee26}'), ('\u{1ee28}', '\u{1ee28}'),
        ('\u{1ee33}', '\u{1ee33}'), ('\u{1ee38}', '\u{1ee38}'), ('\u{1ee3a}', '\u{1ee3a}'),
        ('\u{1ee3c}', '\u{1ee41}'), ('\u{1ee43}', '\u{1ee46}'), ('\u{1ee48}', '\u{1ee48}'),
        ('\u{1ee4a}', '\u{1ee4a}'), ('\u{1ee4c}', '\u{1ee4c}'), ('\u{1ee50}', '\u{1ee50}'),
        ('\u{1ee53}', '\u{1ee53}'), ('\u{1ee55}', '\u{1ee56}'), ('\u{1ee58}', '\u{1ee58}'),
        ('\u{1ee5a}', '\u{1ee5a}'), ('\u{1ee5c}', '\u{1ee5c}'), ('\u{1ee5e}', '\u{1ee5e}'),
        ('\u{1ee60}', '\u{1ee60}'), ('\u{1ee63}', '\u{1ee63}'), ('\u{1ee65}', '\u{1ee66}'),
        ('\u{1ee6b}', '\u{1ee6b}'), ('\u{1ee73}', '\u{1ee73}'), ('\u{1ee78}', '\u{1ee78}'),
        ('\u{1ee7d}', '\u{1ee7d}'), ('\u{1ee7f}', '\u{1ee7f}'), ('\u{1ee8a}', '\u{1ee8a}'),
        ('\u{1ee9c}', '\u{1eea0}'), ('\u{1eea4}', '\u{1eea4}'), ('\u{1eeaa}', '\u{1eeaa}'),
        ('\u{1eebc}', '\u{1eeef}'), ('\u{1eef2}', '\u{1efff}'), ('\u{1f02c}', '\u{1f02f}'),
        ('\u{1f094}', '\u{1f09f}'), ('\u{1f0af}', '\u{1f0b0}'), ('\u{1f0c0}', '\u{1f0c0}'),
        ('\u{1f0d0}', '\u{1f0d0}'), ('\u{1f0f6}', '\u{1f0ff}'), ('\u{1f10d}', '\u{1f10f}'),
        ('\u{1f12f}', '\u{1f12f}'), ('\u{1f16c}', '\u{1f16f}'), ('\u{1f19b}', '\u{1f1e5}'),
        ('\u{1f203}', '\u{1f20f}'), ('\u{1f23b}', '\u{1f23f}'), ('\u{1f249}', '\u{1f24f}'),
        ('\u{1f252}', '\u{1f2ff}'), ('\u{1f32d}', '\u{1f32f}'), ('\u{1f37e}', '\u{1f37f}'),
        ('\u{1f3cf}', '\u{1f3d3}'), ('\u{1f3f8}', '\u{1f3ff}'), ('\u{1f4ff}', '\u{1f4ff}'),
        ('\u{1f54b}', '\u{1f54f}'), ('\u{1f57a}', '\u{1f57a}'), ('\u{1f5a4}', '\u{1f5a4}'),
        ('\u{1f643}', '\u{1f644}'), ('\u{1f6d0}', '\u{1f6df}'), ('\u{1f6ed}', '\u{1f6ef}'),
        ('\u{1f6f4}', '\u{1f6ff}'), ('\u{1f774}', '\u{1f77f}'), ('\u{1f7d5}', '\u{1f7ff}'),
        ('\u{1f80c}', '\u{1f80f}'), ('\u{1f848}', '\u{1f84f}'), ('\u{1f85a}', '\u{1f85f}'),
        ('\u{1f888}', '\u{1f88f}'), ('\u{1f8ae}', '\u{1ffff}'), ('\u{20001}', '\u{2a6d5}'),
        ('\u{2a6d7}', '\u{2a6ff}'), ('\u{2a701}', '\u{2b733}'), ('\u{2b735}', '\u{2b73f}'),
        ('\u{2b741}', '\u{2b81c}'), ('\u{2b81e}', '\u{2f7ff}'), ('\u{2fa1e}', '\u{e0000}'),
        ('\u{e0002}', '\u{e001f}'), ('\u{e0080}', '\u{e00ff}'), ('\u{e01f0}', '\u{effff}'),
        ('\u{f0001}', '\u{ffffc}'), ('\u{ffffe}', '\u{fffff}'), ('\u{100001}', '\u{10fffc}'),
        ('\u{10fffe}', '\u{10ffff}')
    ];

    pub static Co_table: &'static [(char, char)] = &[
        ('\u{e000}', '\u{e000}'), ('\u{f8ff}', '\u{f8ff}'), ('\u{f0000}', '\u{f0000}'),
        ('\u{ffffd}', '\u{ffffd}'), ('\u{100000}', '\u{100000}'), ('\u{10fffd}', '\u{10fffd}')
    ];

    pub static L_table: &'static [(char, char)] = &[
        ('\u{41}', '\u{5a}'), ('\u{61}', '\u{7a}'), ('\u{aa}', '\u{aa}'), ('\u{b5}', '\u{b5}'),
        ('\u{ba}', '\u{ba}'), ('\u{c0}', '\u{d6}'), ('\u{d8}', '\u{f6}'), ('\u{f8}', '\u{2c1}'),
        ('\u{2c6}', '\u{2d1}'), ('\u{2e0}', '\u{2e4}'), ('\u{2ec}', '\u{2ec}'), ('\u{2ee}',
        '\u{2ee}'), ('\u{370}', '\u{374}'), ('\u{376}', '\u{377}'), ('\u{37a}', '\u{37d}'),
        ('\u{37f}', '\u{37f}'), ('\u{386}', '\u{386}'), ('\u{388}', '\u{38a}'), ('\u{38c}',
        '\u{38c}'), ('\u{38e}', '\u{3a1}'), ('\u{3a3}', '\u{3f5}'), ('\u{3f7}', '\u{481}'),
        ('\u{48a}', '\u{52f}'), ('\u{531}', '\u{556}'), ('\u{559}', '\u{559}'), ('\u{561}',
        '\u{587}'), ('\u{5d0}', '\u{5ea}'), ('\u{5f0}', '\u{5f2}'), ('\u{620}', '\u{64a}'),
        ('\u{66e}', '\u{66f}'), ('\u{671}', '\u{6d3}'), ('\u{6d5}', '\u{6d5}'), ('\u{6e5}',
        '\u{6e6}'), ('\u{6ee}', '\u{6ef}'), ('\u{6fa}', '\u{6fc}'), ('\u{6ff}', '\u{6ff}'),
        ('\u{710}', '\u{710}'), ('\u{712}', '\u{72f}'), ('\u{74d}', '\u{7a5}'), ('\u{7b1}',
        '\u{7b1}'), ('\u{7ca}', '\u{7ea}'), ('\u{7f4}', '\u{7f5}'), ('\u{7fa}', '\u{7fa}'),
        ('\u{800}', '\u{815}'), ('\u{81a}', '\u{81a}'), ('\u{824}', '\u{824}'), ('\u{828}',
        '\u{828}'), ('\u{840}', '\u{858}'), ('\u{8a0}', '\u{8b2}'), ('\u{904}', '\u{939}'),
        ('\u{93d}', '\u{93d}'), ('\u{950}', '\u{950}'), ('\u{958}', '\u{961}'), ('\u{971}',
        '\u{980}'), ('\u{985}', '\u{98c}'), ('\u{98f}', '\u{990}'), ('\u{993}', '\u{9a8}'),
        ('\u{9aa}', '\u{9b0}'), ('\u{9b2}', '\u{9b2}'), ('\u{9b6}', '\u{9b9}'), ('\u{9bd}',
        '\u{9bd}'), ('\u{9ce}', '\u{9ce}'), ('\u{9dc}', '\u{9dd}'), ('\u{9df}', '\u{9e1}'),
        ('\u{9f0}', '\u{9f1}'), ('\u{a05}', '\u{a0a}'), ('\u{a0f}', '\u{a10}'), ('\u{a13}',
        '\u{a28}'), ('\u{a2a}', '\u{a30}'), ('\u{a32}', '\u{a33}'), ('\u{a35}', '\u{a36}'),
        ('\u{a38}', '\u{a39}'), ('\u{a59}', '\u{a5c}'), ('\u{a5e}', '\u{a5e}'), ('\u{a72}',
        '\u{a74}'), ('\u{a85}', '\u{a8d}'), ('\u{a8f}', '\u{a91}'), ('\u{a93}', '\u{aa8}'),
        ('\u{aaa}', '\u{ab0}'), ('\u{ab2}', '\u{ab3}'), ('\u{ab5}', '\u{ab9}'), ('\u{abd}',
        '\u{abd}'), ('\u{ad0}', '\u{ad0}'), ('\u{ae0}', '\u{ae1}'), ('\u{b05}', '\u{b0c}'),
        ('\u{b0f}', '\u{b10}'), ('\u{b13}', '\u{b28}'), ('\u{b2a}', '\u{b30}'), ('\u{b32}',
        '\u{b33}'), ('\u{b35}', '\u{b39}'), ('\u{b3d}', '\u{b3d}'), ('\u{b5c}', '\u{b5d}'),
        ('\u{b5f}', '\u{b61}'), ('\u{b71}', '\u{b71}'), ('\u{b83}', '\u{b83}'), ('\u{b85}',
        '\u{b8a}'), ('\u{b8e}', '\u{b90}'), ('\u{b92}', '\u{b95}'), ('\u{b99}', '\u{b9a}'),
        ('\u{b9c}', '\u{b9c}'), ('\u{b9e}', '\u{b9f}'), ('\u{ba3}', '\u{ba4}'), ('\u{ba8}',
        '\u{baa}'), ('\u{bae}', '\u{bb9}'), ('\u{bd0}', '\u{bd0}'), ('\u{c05}', '\u{c0c}'),
        ('\u{c0e}', '\u{c10}'), ('\u{c12}', '\u{c28}'), ('\u{c2a}', '\u{c39}'), ('\u{c3d}',
        '\u{c3d}'), ('\u{c58}', '\u{c59}'), ('\u{c60}', '\u{c61}'), ('\u{c85}', '\u{c8c}'),
        ('\u{c8e}', '\u{c90}'), ('\u{c92}', '\u{ca8}'), ('\u{caa}', '\u{cb3}'), ('\u{cb5}',
        '\u{cb9}'), ('\u{cbd}', '\u{cbd}'), ('\u{cde}', '\u{cde}'), ('\u{ce0}', '\u{ce1}'),
        ('\u{cf1}', '\u{cf2}'), ('\u{d05}', '\u{d0c}'), ('\u{d0e}', '\u{d10}'), ('\u{d12}',
        '\u{d3a}'), ('\u{d3d}', '\u{d3d}'), ('\u{d4e}', '\u{d4e}'), ('\u{d60}', '\u{d61}'),
        ('\u{d7a}', '\u{d7f}'), ('\u{d85}', '\u{d96}'), ('\u{d9a}', '\u{db1}'), ('\u{db3}',
        '\u{dbb}'), ('\u{dbd}', '\u{dbd}'), ('\u{dc0}', '\u{dc6}'), ('\u{e01}', '\u{e30}'),
        ('\u{e32}', '\u{e33}'), ('\u{e40}', '\u{e46}'), ('\u{e81}', '\u{e82}'), ('\u{e84}',
        '\u{e84}'), ('\u{e87}', '\u{e88}'), ('\u{e8a}', '\u{e8a}'), ('\u{e8d}', '\u{e8d}'),
        ('\u{e94}', '\u{e97}'), ('\u{e99}', '\u{e9f}'), ('\u{ea1}', '\u{ea3}'), ('\u{ea5}',
        '\u{ea5}'), ('\u{ea7}', '\u{ea7}'), ('\u{eaa}', '\u{eab}'), ('\u{ead}', '\u{eb0}'),
        ('\u{eb2}', '\u{eb3}'), ('\u{ebd}', '\u{ebd}'), ('\u{ec0}', '\u{ec4}'), ('\u{ec6}',
        '\u{ec6}'), ('\u{edc}', '\u{edf}'), ('\u{f00}', '\u{f00}'), ('\u{f40}', '\u{f47}'),
        ('\u{f49}', '\u{f6c}'), ('\u{f88}', '\u{f8c}'), ('\u{1000}', '\u{102a}'), ('\u{103f}',
        '\u{103f}'), ('\u{1050}', '\u{1055}'), ('\u{105a}', '\u{105d}'), ('\u{1061}', '\u{1061}'),
        ('\u{1065}', '\u{1066}'), ('\u{106e}', '\u{1070}'), ('\u{1075}', '\u{1081}'), ('\u{108e}',
        '\u{108e}'), ('\u{10a0}', '\u{10c5}'), ('\u{10c7}', '\u{10c7}'), ('\u{10cd}', '\u{10cd}'),
        ('\u{10d0}', '\u{10fa}'), ('\u{10fc}', '\u{1248}'), ('\u{124a}', '\u{124d}'), ('\u{1250}',
        '\u{1256}'), ('\u{1258}', '\u{1258}'), ('\u{125a}', '\u{125d}'), ('\u{1260}', '\u{1288}'),
        ('\u{128a}', '\u{128d}'), ('\u{1290}', '\u{12b0}'), ('\u{12b2}', '\u{12b5}'), ('\u{12b8}',
        '\u{12be}'), ('\u{12c0}', '\u{12c0}'), ('\u{12c2}', '\u{12c5}'), ('\u{12c8}', '\u{12d6}'),
        ('\u{12d8}', '\u{1310}'), ('\u{1312}', '\u{1315}'), ('\u{1318}', '\u{135a}'), ('\u{1380}',
        '\u{138f}'), ('\u{13a0}', '\u{13f4}'), ('\u{1401}', '\u{166c}'), ('\u{166f}', '\u{167f}'),
        ('\u{1681}', '\u{169a}'), ('\u{16a0}', '\u{16ea}'), ('\u{16f1}', '\u{16f8}'), ('\u{1700}',
        '\u{170c}'), ('\u{170e}', '\u{1711}'), ('\u{1720}', '\u{1731}'), ('\u{1740}', '\u{1751}'),
        ('\u{1760}', '\u{176c}'), ('\u{176e}', '\u{1770}'), ('\u{1780}', '\u{17b3}'), ('\u{17d7}',
        '\u{17d7}'), ('\u{17dc}', '\u{17dc}'), ('\u{1820}', '\u{1877}'), ('\u{1880}', '\u{18a8}'),
        ('\u{18aa}', '\u{18aa}'), ('\u{18b0}', '\u{18f5}'), ('\u{1900}', '\u{191e}'), ('\u{1950}',
        '\u{196d}'), ('\u{1970}', '\u{1974}'), ('\u{1980}', '\u{19ab}'), ('\u{19c1}', '\u{19c7}'),
        ('\u{1a00}', '\u{1a16}'), ('\u{1a20}', '\u{1a54}'), ('\u{1aa7}', '\u{1aa7}'), ('\u{1b05}',
        '\u{1b33}'), ('\u{1b45}', '\u{1b4b}'), ('\u{1b83}', '\u{1ba0}'), ('\u{1bae}', '\u{1baf}'),
        ('\u{1bba}', '\u{1be5}'), ('\u{1c00}', '\u{1c23}'), ('\u{1c4d}', '\u{1c4f}'), ('\u{1c5a}',
        '\u{1c7d}'), ('\u{1ce9}', '\u{1cec}'), ('\u{1cee}', '\u{1cf1}'), ('\u{1cf5}', '\u{1cf6}'),
        ('\u{1d00}', '\u{1dbf}'), ('\u{1e00}', '\u{1f15}'), ('\u{1f18}', '\u{1f1d}'), ('\u{1f20}',
        '\u{1f45}'), ('\u{1f48}', '\u{1f4d}'), ('\u{1f50}', '\u{1f57}'), ('\u{1f59}', '\u{1f59}'),
        ('\u{1f5b}', '\u{1f5b}'), ('\u{1f5d}', '\u{1f5d}'), ('\u{1f5f}', '\u{1f7d}'), ('\u{1f80}',
        '\u{1fb4}'), ('\u{1fb6}', '\u{1fbc}'), ('\u{1fbe}', '\u{1fbe}'), ('\u{1fc2}', '\u{1fc4}'),
        ('\u{1fc6}', '\u{1fcc}'), ('\u{1fd0}', '\u{1fd3}'), ('\u{1fd6}', '\u{1fdb}'), ('\u{1fe0}',
        '\u{1fec}'), ('\u{1ff2}', '\u{1ff4}'), ('\u{1ff6}', '\u{1ffc}'), ('\u{2071}', '\u{2071}'),
        ('\u{207f}', '\u{207f}'), ('\u{2090}', '\u{209c}'), ('\u{2102}', '\u{2102}'), ('\u{2107}',
        '\u{2107}'), ('\u{210a}', '\u{2113}'), ('\u{2115}', '\u{2115}'), ('\u{2119}', '\u{211d}'),
        ('\u{2124}', '\u{2124}'), ('\u{2126}', '\u{2126}'), ('\u{2128}', '\u{2128}'), ('\u{212a}',
        '\u{212d}'), ('\u{212f}', '\u{2139}'), ('\u{213c}', '\u{213f}'), ('\u{2145}', '\u{2149}'),
        ('\u{214e}', '\u{214e}'), ('\u{2183}', '\u{2184}'), ('\u{2c00}', '\u{2c2e}'), ('\u{2c30}',
        '\u{2c5e}'), ('\u{2c60}', '\u{2ce4}'), ('\u{2ceb}', '\u{2cee}'), ('\u{2cf2}', '\u{2cf3}'),
        ('\u{2d00}', '\u{2d25}'), ('\u{2d27}', '\u{2d27}'), ('\u{2d2d}', '\u{2d2d}'), ('\u{2d30}',
        '\u{2d67}'), ('\u{2d6f}', '\u{2d6f}'), ('\u{2d80}', '\u{2d96}'), ('\u{2da0}', '\u{2da6}'),
        ('\u{2da8}', '\u{2dae}'), ('\u{2db0}', '\u{2db6}'), ('\u{2db8}', '\u{2dbe}'), ('\u{2dc0}',
        '\u{2dc6}'), ('\u{2dc8}', '\u{2dce}'), ('\u{2dd0}', '\u{2dd6}'), ('\u{2dd8}', '\u{2dde}'),
        ('\u{2e2f}', '\u{2e2f}'), ('\u{3005}', '\u{3006}'), ('\u{3031}', '\u{3035}'), ('\u{303b}',
        '\u{303c}'), ('\u{3041}', '\u{3096}'), ('\u{309d}', '\u{309f}'), ('\u{30a1}', '\u{30fa}'),
        ('\u{30fc}', '\u{30ff}'), ('\u{3105}', '\u{312d}'), ('\u{3131}', '\u{318e}'), ('\u{31a0}',
        '\u{31ba}'), ('\u{31f0}', '\u{31ff}'), ('\u{3400}', '\u{3400}'), ('\u{4db5}', '\u{4db5}'),
        ('\u{4e00}', '\u{4e00}'), ('\u{9fcc}', '\u{9fcc}'), ('\u{a000}', '\u{a48c}'), ('\u{a4d0}',
        '\u{a4fd}'), ('\u{a500}', '\u{a60c}'), ('\u{a610}', '\u{a61f}'), ('\u{a62a}', '\u{a62b}'),
        ('\u{a640}', '\u{a66e}'), ('\u{a67f}', '\u{a69d}'), ('\u{a6a0}', '\u{a6e5}'), ('\u{a717}',
        '\u{a71f}'), ('\u{a722}', '\u{a788}'), ('\u{a78b}', '\u{a78e}'), ('\u{a790}', '\u{a7ad}'),
        ('\u{a7b0}', '\u{a7b1}'), ('\u{a7f7}', '\u{a801}'), ('\u{a803}', '\u{a805}'), ('\u{a807}',
        '\u{a80a}'), ('\u{a80c}', '\u{a822}'), ('\u{a840}', '\u{a873}'), ('\u{a882}', '\u{a8b3}'),
        ('\u{a8f2}', '\u{a8f7}'), ('\u{a8fb}', '\u{a8fb}'), ('\u{a90a}', '\u{a925}'), ('\u{a930}',
        '\u{a946}'), ('\u{a960}', '\u{a97c}'), ('\u{a984}', '\u{a9b2}'), ('\u{a9cf}', '\u{a9cf}'),
        ('\u{a9e0}', '\u{a9e4}'), ('\u{a9e6}', '\u{a9ef}'), ('\u{a9fa}', '\u{a9fe}'), ('\u{aa00}',
        '\u{aa28}'), ('\u{aa40}', '\u{aa42}'), ('\u{aa44}', '\u{aa4b}'), ('\u{aa60}', '\u{aa76}'),
        ('\u{aa7a}', '\u{aa7a}'), ('\u{aa7e}', '\u{aaaf}'), ('\u{aab1}', '\u{aab1}'), ('\u{aab5}',
        '\u{aab6}'), ('\u{aab9}', '\u{aabd}'), ('\u{aac0}', '\u{aac0}'), ('\u{aac2}', '\u{aac2}'),
        ('\u{aadb}', '\u{aadd}'), ('\u{aae0}', '\u{aaea}'), ('\u{aaf2}', '\u{aaf4}'), ('\u{ab01}',
        '\u{ab06}'), ('\u{ab09}', '\u{ab0e}'), ('\u{ab11}', '\u{ab16}'), ('\u{ab20}', '\u{ab26}'),
        ('\u{ab28}', '\u{ab2e}'), ('\u{ab30}', '\u{ab5a}'), ('\u{ab5c}', '\u{ab5f}'), ('\u{ab64}',
        '\u{ab65}'), ('\u{abc0}', '\u{abe2}'), ('\u{ac00}', '\u{ac00}'), ('\u{d7a3}', '\u{d7a3}'),
        ('\u{d7b0}', '\u{d7c6}'), ('\u{d7cb}', '\u{d7fb}'), ('\u{f900}', '\u{fa6d}'), ('\u{fa70}',
        '\u{fad9}'), ('\u{fb00}', '\u{fb06}'), ('\u{fb13}', '\u{fb17}'), ('\u{fb1d}', '\u{fb1d}'),
        ('\u{fb1f}', '\u{fb28}'), ('\u{fb2a}', '\u{fb36}'), ('\u{fb38}', '\u{fb3c}'), ('\u{fb3e}',
        '\u{fb3e}'), ('\u{fb40}', '\u{fb41}'), ('\u{fb43}', '\u{fb44}'), ('\u{fb46}', '\u{fbb1}'),
        ('\u{fbd3}', '\u{fd3d}'), ('\u{fd50}', '\u{fd8f}'), ('\u{fd92}', '\u{fdc7}'), ('\u{fdf0}',
        '\u{fdfb}'), ('\u{fe70}', '\u{fe74}'), ('\u{fe76}', '\u{fefc}'), ('\u{ff21}', '\u{ff3a}'),
        ('\u{ff41}', '\u{ff5a}'), ('\u{ff66}', '\u{ffbe}'), ('\u{ffc2}', '\u{ffc7}'), ('\u{ffca}',
        '\u{ffcf}'), ('\u{ffd2}', '\u{ffd7}'), ('\u{ffda}', '\u{ffdc}'), ('\u{10000}', '\u{1000b}'),
        ('\u{1000d}', '\u{10026}'), ('\u{10028}', '\u{1003a}'), ('\u{1003c}', '\u{1003d}'),
        ('\u{1003f}', '\u{1004d}'), ('\u{10050}', '\u{1005d}'), ('\u{10080}', '\u{100fa}'),
        ('\u{10280}', '\u{1029c}'), ('\u{102a0}', '\u{102d0}'), ('\u{10300}', '\u{1031f}'),
        ('\u{10330}', '\u{10340}'), ('\u{10342}', '\u{10349}'), ('\u{10350}', '\u{10375}'),
        ('\u{10380}', '\u{1039d}'), ('\u{103a0}', '\u{103c3}'), ('\u{103c8}', '\u{103cf}'),
        ('\u{10400}', '\u{1049d}'), ('\u{10500}', '\u{10527}'), ('\u{10530}', '\u{10563}'),
        ('\u{10600}', '\u{10736}'), ('\u{10740}', '\u{10755}'), ('\u{10760}', '\u{10767}'),
        ('\u{10800}', '\u{10805}'), ('\u{10808}', '\u{10808}'), ('\u{1080a}', '\u{10835}'),
        ('\u{10837}', '\u{10838}'), ('\u{1083c}', '\u{1083c}'), ('\u{1083f}', '\u{10855}'),
        ('\u{10860}', '\u{10876}'), ('\u{10880}', '\u{1089e}'), ('\u{10900}', '\u{10915}'),
        ('\u{10920}', '\u{10939}'), ('\u{10980}', '\u{109b7}'), ('\u{109be}', '\u{109bf}'),
        ('\u{10a00}', '\u{10a00}'), ('\u{10a10}', '\u{10a13}'), ('\u{10a15}', '\u{10a17}'),
        ('\u{10a19}', '\u{10a33}'), ('\u{10a60}', '\u{10a7c}'), ('\u{10a80}', '\u{10a9c}'),
        ('\u{10ac0}', '\u{10ac7}'), ('\u{10ac9}', '\u{10ae4}'), ('\u{10b00}', '\u{10b35}'),
        ('\u{10b40}', '\u{10b55}'), ('\u{10b60}', '\u{10b72}'), ('\u{10b80}', '\u{10b91}'),
        ('\u{10c00}', '\u{10c48}'), ('\u{11003}', '\u{11037}'), ('\u{11083}', '\u{110af}'),
        ('\u{110d0}', '\u{110e8}'), ('\u{11103}', '\u{11126}'), ('\u{11150}', '\u{11172}'),
        ('\u{11176}', '\u{11176}'), ('\u{11183}', '\u{111b2}'), ('\u{111c1}', '\u{111c4}'),
        ('\u{111da}', '\u{111da}'), ('\u{11200}', '\u{11211}'), ('\u{11213}', '\u{1122b}'),
        ('\u{112b0}', '\u{112de}'), ('\u{11305}', '\u{1130c}'), ('\u{1130f}', '\u{11310}'),
        ('\u{11313}', '\u{11328}'), ('\u{1132a}', '\u{11330}'), ('\u{11332}', '\u{11333}'),
        ('\u{11335}', '\u{11339}'), ('\u{1133d}', '\u{1133d}'), ('\u{1135d}', '\u{11361}'),
        ('\u{11480}', '\u{114af}'), ('\u{114c4}', '\u{114c5}'), ('\u{114c7}', '\u{114c7}'),
        ('\u{11580}', '\u{115ae}'), ('\u{11600}', '\u{1162f}'), ('\u{11644}', '\u{11644}'),
        ('\u{11680}', '\u{116aa}'), ('\u{118a0}', '\u{118df}'), ('\u{118ff}', '\u{118ff}'),
        ('\u{11ac0}', '\u{11af8}'), ('\u{12000}', '\u{12398}'), ('\u{13000}', '\u{1342e}'),
        ('\u{16800}', '\u{16a38}'), ('\u{16a40}', '\u{16a5e}'), ('\u{16ad0}', '\u{16aed}'),
        ('\u{16b00}', '\u{16b2f}'), ('\u{16b40}', '\u{16b43}'), ('\u{16b63}', '\u{16b77}'),
        ('\u{16b7d}', '\u{16b8f}'), ('\u{16f00}', '\u{16f44}'), ('\u{16f50}', '\u{16f50}'),
        ('\u{16f93}', '\u{16f9f}'), ('\u{1b000}', '\u{1b001}'), ('\u{1bc00}', '\u{1bc6a}'),
        ('\u{1bc70}', '\u{1bc7c}'), ('\u{1bc80}', '\u{1bc88}'), ('\u{1bc90}', '\u{1bc99}'),
        ('\u{1d400}', '\u{1d454}'), ('\u{1d456}', '\u{1d49c}'), ('\u{1d49e}', '\u{1d49f}'),
        ('\u{1d4a2}', '\u{1d4a2}'), ('\u{1d4a5}', '\u{1d4a6}'), ('\u{1d4a9}', '\u{1d4ac}'),
        ('\u{1d4ae}', '\u{1d4b9}'), ('\u{1d4bb}', '\u{1d4bb}'), ('\u{1d4bd}', '\u{1d4c3}'),
        ('\u{1d4c5}', '\u{1d505}'), ('\u{1d507}', '\u{1d50a}'), ('\u{1d50d}', '\u{1d514}'),
        ('\u{1d516}', '\u{1d51c}'), ('\u{1d51e}', '\u{1d539}'), ('\u{1d53b}', '\u{1d53e}'),
        ('\u{1d540}', '\u{1d544}'), ('\u{1d546}', '\u{1d546}'), ('\u{1d54a}', '\u{1d550}'),
        ('\u{1d552}', '\u{1d6a5}'), ('\u{1d6a8}', '\u{1d6c0}'), ('\u{1d6c2}', '\u{1d6da}'),
        ('\u{1d6dc}', '\u{1d6fa}'), ('\u{1d6fc}', '\u{1d714}'), ('\u{1d716}', '\u{1d734}'),
        ('\u{1d736}', '\u{1d74e}'), ('\u{1d750}', '\u{1d76e}'), ('\u{1d770}', '\u{1d788}'),
        ('\u{1d78a}', '\u{1d7a8}'), ('\u{1d7aa}', '\u{1d7c2}'), ('\u{1d7c4}', '\u{1d7cb}'),
        ('\u{1e800}', '\u{1e8c4}'), ('\u{1ee00}', '\u{1ee03}'), ('\u{1ee05}', '\u{1ee1f}'),
        ('\u{1ee21}', '\u{1ee22}'), ('\u{1ee24}', '\u{1ee24}'), ('\u{1ee27}', '\u{1ee27}'),
        ('\u{1ee29}', '\u{1ee32}'), ('\u{1ee34}', '\u{1ee37}'), ('\u{1ee39}', '\u{1ee39}'),
        ('\u{1ee3b}', '\u{1ee3b}'), ('\u{1ee42}', '\u{1ee42}'), ('\u{1ee47}', '\u{1ee47}'),
        ('\u{1ee49}', '\u{1ee49}'), ('\u{1ee4b}', '\u{1ee4b}'), ('\u{1ee4d}', '\u{1ee4f}'),
        ('\u{1ee51}', '\u{1ee52}'), ('\u{1ee54}', '\u{1ee54}'), ('\u{1ee57}', '\u{1ee57}'),
        ('\u{1ee59}', '\u{1ee59}'), ('\u{1ee5b}', '\u{1ee5b}'), ('\u{1ee5d}', '\u{1ee5d}'),
        ('\u{1ee5f}', '\u{1ee5f}'), ('\u{1ee61}', '\u{1ee62}'), ('\u{1ee64}', '\u{1ee64}'),
        ('\u{1ee67}', '\u{1ee6a}'), ('\u{1ee6c}', '\u{1ee72}'), ('\u{1ee74}', '\u{1ee77}'),
        ('\u{1ee79}', '\u{1ee7c}'), ('\u{1ee7e}', '\u{1ee7e}'), ('\u{1ee80}', '\u{1ee89}'),
        ('\u{1ee8b}', '\u{1ee9b}'), ('\u{1eea1}', '\u{1eea3}'), ('\u{1eea5}', '\u{1eea9}'),
        ('\u{1eeab}', '\u{1eebb}'), ('\u{20000}', '\u{20000}'), ('\u{2a6d6}', '\u{2a6d6}'),
        ('\u{2a700}', '\u{2a700}'), ('\u{2b734}', '\u{2b734}'), ('\u{2b740}', '\u{2b740}'),
        ('\u{2b81d}', '\u{2b81d}'), ('\u{2f800}', '\u{2fa1d}')
    ];

    pub static LC_table: &'static [(char, char)] = &[
        ('\u{41}', '\u{5a}'), ('\u{61}', '\u{7a}'), ('\u{b5}', '\u{b5}'), ('\u{c0}', '\u{d6}'),
        ('\u{d8}', '\u{f6}'), ('\u{f8}', '\u{1ba}'), ('\u{1bc}', '\u{1bf}'), ('\u{1c4}', '\u{293}'),
        ('\u{295}', '\u{2af}'), ('\u{370}', '\u{373}'), ('\u{376}', '\u{377}'), ('\u{37b}',
        '\u{37d}'), ('\u{37f}', '\u{37f}'), ('\u{386}', '\u{386}'), ('\u{388}', '\u{38a}'),
        ('\u{38c}', '\u{38c}'), ('\u{38e}', '\u{3a1}'), ('\u{3a3}', '\u{3f5}'), ('\u{3f7}',
        '\u{481}'), ('\u{48a}', '\u{52f}'), ('\u{531}', '\u{556}'), ('\u{561}', '\u{587}'),
        ('\u{10a0}', '\u{10c5}'), ('\u{10c7}', '\u{10c7}'), ('\u{10cd}', '\u{10cd}'), ('\u{1d00}',
        '\u{1d2b}'), ('\u{1d6b}', '\u{1d77}'), ('\u{1d79}', '\u{1d9a}'), ('\u{1e00}', '\u{1f15}'),
        ('\u{1f18}', '\u{1f1d}'), ('\u{1f20}', '\u{1f45}'), ('\u{1f48}', '\u{1f4d}'), ('\u{1f50}',
        '\u{1f57}'), ('\u{1f59}', '\u{1f59}'), ('\u{1f5b}', '\u{1f5b}'), ('\u{1f5d}', '\u{1f5d}'),
        ('\u{1f5f}', '\u{1f7d}'), ('\u{1f80}', '\u{1fb4}'), ('\u{1fb6}', '\u{1fbc}'), ('\u{1fbe}',
        '\u{1fbe}'), ('\u{1fc2}', '\u{1fc4}'), ('\u{1fc6}', '\u{1fcc}'), ('\u{1fd0}', '\u{1fd3}'),
        ('\u{1fd6}', '\u{1fdb}'), ('\u{1fe0}', '\u{1fec}'), ('\u{1ff2}', '\u{1ff4}'), ('\u{1ff6}',
        '\u{1ffc}'), ('\u{2102}', '\u{2102}'), ('\u{2107}', '\u{2107}'), ('\u{210a}', '\u{2113}'),
        ('\u{2115}', '\u{2115}'), ('\u{2119}', '\u{211d}'), ('\u{2124}', '\u{2124}'), ('\u{2126}',
        '\u{2126}'), ('\u{2128}', '\u{2128}'), ('\u{212a}', '\u{212d}'), ('\u{212f}', '\u{2134}'),
        ('\u{2139}', '\u{2139}'), ('\u{213c}', '\u{213f}'), ('\u{2145}', '\u{2149}'), ('\u{214e}',
        '\u{214e}'), ('\u{2183}', '\u{2184}'), ('\u{2c00}', '\u{2c2e}'), ('\u{2c30}', '\u{2c5e}'),
        ('\u{2c60}', '\u{2c7b}'), ('\u{2c7e}', '\u{2ce4}'), ('\u{2ceb}', '\u{2cee}'), ('\u{2cf2}',
        '\u{2cf3}'), ('\u{2d00}', '\u{2d25}'), ('\u{2d27}', '\u{2d27}'), ('\u{2d2d}', '\u{2d2d}'),
        ('\u{a640}', '\u{a66d}'), ('\u{a680}', '\u{a69b}'), ('\u{a722}', '\u{a76f}'), ('\u{a771}',
        '\u{a787}'), ('\u{a78b}', '\u{a78e}'), ('\u{a790}', '\u{a7ad}'), ('\u{a7b0}', '\u{a7b1}'),
        ('\u{a7fa}', '\u{a7fa}'), ('\u{ab30}', '\u{ab5a}'), ('\u{ab64}', '\u{ab65}'), ('\u{fb00}',
        '\u{fb06}'), ('\u{fb13}', '\u{fb17}'), ('\u{ff21}', '\u{ff3a}'), ('\u{ff41}', '\u{ff5a}'),
        ('\u{10400}', '\u{1044f}'), ('\u{118a0}', '\u{118df}'), ('\u{1d400}', '\u{1d454}'),
        ('\u{1d456}', '\u{1d49c}'), ('\u{1d49e}', '\u{1d49f}'), ('\u{1d4a2}', '\u{1d4a2}'),
        ('\u{1d4a5}', '\u{1d4a6}'), ('\u{1d4a9}', '\u{1d4ac}'), ('\u{1d4ae}', '\u{1d4b9}'),
        ('\u{1d4bb}', '\u{1d4bb}'), ('\u{1d4bd}', '\u{1d4c3}'), ('\u{1d4c5}', '\u{1d505}'),
        ('\u{1d507}', '\u{1d50a}'), ('\u{1d50d}', '\u{1d514}'), ('\u{1d516}', '\u{1d51c}'),
        ('\u{1d51e}', '\u{1d539}'), ('\u{1d53b}', '\u{1d53e}'), ('\u{1d540}', '\u{1d544}'),
        ('\u{1d546}', '\u{1d546}'), ('\u{1d54a}', '\u{1d550}'), ('\u{1d552}', '\u{1d6a5}'),
        ('\u{1d6a8}', '\u{1d6c0}'), ('\u{1d6c2}', '\u{1d6da}'), ('\u{1d6dc}', '\u{1d6fa}'),
        ('\u{1d6fc}', '\u{1d714}'), ('\u{1d716}', '\u{1d734}'), ('\u{1d736}', '\u{1d74e}'),
        ('\u{1d750}', '\u{1d76e}'), ('\u{1d770}', '\u{1d788}'), ('\u{1d78a}', '\u{1d7a8}'),
        ('\u{1d7aa}', '\u{1d7c2}'), ('\u{1d7c4}', '\u{1d7cb}')
    ];

    pub static Ll_table: &'static [(char, char)] = &[
        ('\u{61}', '\u{7a}'), ('\u{b5}', '\u{b5}'), ('\u{df}', '\u{f6}'), ('\u{f8}', '\u{ff}'),
        ('\u{101}', '\u{101}'), ('\u{103}', '\u{103}'), ('\u{105}', '\u{105}'), ('\u{107}',
        '\u{107}'), ('\u{109}', '\u{109}'), ('\u{10b}', '\u{10b}'), ('\u{10d}', '\u{10d}'),
        ('\u{10f}', '\u{10f}'), ('\u{111}', '\u{111}'), ('\u{113}', '\u{113}'), ('\u{115}',
        '\u{115}'), ('\u{117}', '\u{117}'), ('\u{119}', '\u{119}'), ('\u{11b}', '\u{11b}'),
        ('\u{11d}', '\u{11d}'), ('\u{11f}', '\u{11f}'), ('\u{121}', '\u{121}'), ('\u{123}',
        '\u{123}'), ('\u{125}', '\u{125}'), ('\u{127}', '\u{127}'), ('\u{129}', '\u{129}'),
        ('\u{12b}', '\u{12b}'), ('\u{12d}', '\u{12d}'), ('\u{12f}', '\u{12f}'), ('\u{131}',
        '\u{131}'), ('\u{133}', '\u{133}'), ('\u{135}', '\u{135}'), ('\u{137}', '\u{138}'),
        ('\u{13a}', '\u{13a}'), ('\u{13c}', '\u{13c}'), ('\u{13e}', '\u{13e}'), ('\u{140}',
        '\u{140}'), ('\u{142}', '\u{142}'), ('\u{144}', '\u{144}'), ('\u{146}', '\u{146}'),
        ('\u{148}', '\u{149}'), ('\u{14b}', '\u{14b}'), ('\u{14d}', '\u{14d}'), ('\u{14f}',
        '\u{14f}'), ('\u{151}', '\u{151}'), ('\u{153}', '\u{153}'), ('\u{155}', '\u{155}'),
        ('\u{157}', '\u{157}'), ('\u{159}', '\u{159}'), ('\u{15b}', '\u{15b}'), ('\u{15d}',
        '\u{15d}'), ('\u{15f}', '\u{15f}'), ('\u{161}', '\u{161}'), ('\u{163}', '\u{163}'),
        ('\u{165}', '\u{165}'), ('\u{167}', '\u{167}'), ('\u{169}', '\u{169}'), ('\u{16b}',
        '\u{16b}'), ('\u{16d}', '\u{16d}'), ('\u{16f}', '\u{16f}'), ('\u{171}', '\u{171}'),
        ('\u{173}', '\u{173}'), ('\u{175}', '\u{175}'), ('\u{177}', '\u{177}'), ('\u{17a}',
        '\u{17a}'), ('\u{17c}', '\u{17c}'), ('\u{17e}', '\u{180}'), ('\u{183}', '\u{183}'),
        ('\u{185}', '\u{185}'), ('\u{188}', '\u{188}'), ('\u{18c}', '\u{18d}'), ('\u{192}',
        '\u{192}'), ('\u{195}', '\u{195}'), ('\u{199}', '\u{19b}'), ('\u{19e}', '\u{19e}'),
        ('\u{1a1}', '\u{1a1}'), ('\u{1a3}', '\u{1a3}'), ('\u{1a5}', '\u{1a5}'), ('\u{1a8}',
        '\u{1a8}'), ('\u{1aa}', '\u{1ab}'), ('\u{1ad}', '\u{1ad}'), ('\u{1b0}', '\u{1b0}'),
        ('\u{1b4}', '\u{1b4}'), ('\u{1b6}', '\u{1b6}'), ('\u{1b9}', '\u{1ba}'), ('\u{1bd}',
        '\u{1bf}'), ('\u{1c6}', '\u{1c6}'), ('\u{1c9}', '\u{1c9}'), ('\u{1cc}', '\u{1cc}'),
        ('\u{1ce}', '\u{1ce}'), ('\u{1d0}', '\u{1d0}'), ('\u{1d2}', '\u{1d2}'), ('\u{1d4}',
        '\u{1d4}'), ('\u{1d6}', '\u{1d6}'), ('\u{1d8}', '\u{1d8}'), ('\u{1da}', '\u{1da}'),
        ('\u{1dc}', '\u{1dd}'), ('\u{1df}', '\u{1df}'), ('\u{1e1}', '\u{1e1}'), ('\u{1e3}',
        '\u{1e3}'), ('\u{1e5}', '\u{1e5}'), ('\u{1e7}', '\u{1e7}'), ('\u{1e9}', '\u{1e9}'),
        ('\u{1eb}', '\u{1eb}'), ('\u{1ed}', '\u{1ed}'), ('\u{1ef}', '\u{1f0}'), ('\u{1f3}',
        '\u{1f3}'), ('\u{1f5}', '\u{1f5}'), ('\u{1f9}', '\u{1f9}'), ('\u{1fb}', '\u{1fb}'),
        ('\u{1fd}', '\u{1fd}'), ('\u{1ff}', '\u{1ff}'), ('\u{201}', '\u{201}'), ('\u{203}',
        '\u{203}'), ('\u{205}', '\u{205}'), ('\u{207}', '\u{207}'), ('\u{209}', '\u{209}'),
        ('\u{20b}', '\u{20b}'), ('\u{20d}', '\u{20d}'), ('\u{20f}', '\u{20f}'), ('\u{211}',
        '\u{211}'), ('\u{213}', '\u{213}'), ('\u{215}', '\u{215}'), ('\u{217}', '\u{217}'),
        ('\u{219}', '\u{219}'), ('\u{21b}', '\u{21b}'), ('\u{21d}', '\u{21d}'), ('\u{21f}',
        '\u{21f}'), ('\u{221}', '\u{221}'), ('\u{223}', '\u{223}'), ('\u{225}', '\u{225}'),
        ('\u{227}', '\u{227}'), ('\u{229}', '\u{229}'), ('\u{22b}', '\u{22b}'), ('\u{22d}',
        '\u{22d}'), ('\u{22f}', '\u{22f}'), ('\u{231}', '\u{231}'), ('\u{233}', '\u{239}'),
        ('\u{23c}', '\u{23c}'), ('\u{23f}', '\u{240}'), ('\u{242}', '\u{242}'), ('\u{247}',
        '\u{247}'), ('\u{249}', '\u{249}'), ('\u{24b}', '\u{24b}'), ('\u{24d}', '\u{24d}'),
        ('\u{24f}', '\u{293}'), ('\u{295}', '\u{2af}'), ('\u{371}', '\u{371}'), ('\u{373}',
        '\u{373}'), ('\u{377}', '\u{377}'), ('\u{37b}', '\u{37d}'), ('\u{390}', '\u{390}'),
        ('\u{3ac}', '\u{3ce}'), ('\u{3d0}', '\u{3d1}'), ('\u{3d5}', '\u{3d7}'), ('\u{3d9}',
        '\u{3d9}'), ('\u{3db}', '\u{3db}'), ('\u{3dd}', '\u{3dd}'), ('\u{3df}', '\u{3df}'),
        ('\u{3e1}', '\u{3e1}'), ('\u{3e3}', '\u{3e3}'), ('\u{3e5}', '\u{3e5}'), ('\u{3e7}',
        '\u{3e7}'), ('\u{3e9}', '\u{3e9}'), ('\u{3eb}', '\u{3eb}'), ('\u{3ed}', '\u{3ed}'),
        ('\u{3ef}', '\u{3f3}'), ('\u{3f5}', '\u{3f5}'), ('\u{3f8}', '\u{3f8}'), ('\u{3fb}',
        '\u{3fc}'), ('\u{430}', '\u{45f}'), ('\u{461}', '\u{461}'), ('\u{463}', '\u{463}'),
        ('\u{465}', '\u{465}'), ('\u{467}', '\u{467}'), ('\u{469}', '\u{469}'), ('\u{46b}',
        '\u{46b}'), ('\u{46d}', '\u{46d}'), ('\u{46f}', '\u{46f}'), ('\u{471}', '\u{471}'),
        ('\u{473}', '\u{473}'), ('\u{475}', '\u{475}'), ('\u{477}', '\u{477}'), ('\u{479}',
        '\u{479}'), ('\u{47b}', '\u{47b}'), ('\u{47d}', '\u{47d}'), ('\u{47f}', '\u{47f}'),
        ('\u{481}', '\u{481}'), ('\u{48b}', '\u{48b}'), ('\u{48d}', '\u{48d}'), ('\u{48f}',
        '\u{48f}'), ('\u{491}', '\u{491}'), ('\u{493}', '\u{493}'), ('\u{495}', '\u{495}'),
        ('\u{497}', '\u{497}'), ('\u{499}', '\u{499}'), ('\u{49b}', '\u{49b}'), ('\u{49d}',
        '\u{49d}'), ('\u{49f}', '\u{49f}'), ('\u{4a1}', '\u{4a1}'), ('\u{4a3}', '\u{4a3}'),
        ('\u{4a5}', '\u{4a5}'), ('\u{4a7}', '\u{4a7}'), ('\u{4a9}', '\u{4a9}'), ('\u{4ab}',
        '\u{4ab}'), ('\u{4ad}', '\u{4ad}'), ('\u{4af}', '\u{4af}'), ('\u{4b1}', '\u{4b1}'),
        ('\u{4b3}', '\u{4b3}'), ('\u{4b5}', '\u{4b5}'), ('\u{4b7}', '\u{4b7}'), ('\u{4b9}',
        '\u{4b9}'), ('\u{4bb}', '\u{4bb}'), ('\u{4bd}', '\u{4bd}'), ('\u{4bf}', '\u{4bf}'),
        ('\u{4c2}', '\u{4c2}'), ('\u{4c4}', '\u{4c4}'), ('\u{4c6}', '\u{4c6}'), ('\u{4c8}',
        '\u{4c8}'), ('\u{4ca}', '\u{4ca}'), ('\u{4cc}', '\u{4cc}'), ('\u{4ce}', '\u{4cf}'),
        ('\u{4d1}', '\u{4d1}'), ('\u{4d3}', '\u{4d3}'), ('\u{4d5}', '\u{4d5}'), ('\u{4d7}',
        '\u{4d7}'), ('\u{4d9}', '\u{4d9}'), ('\u{4db}', '\u{4db}'), ('\u{4dd}', '\u{4dd}'),
        ('\u{4df}', '\u{4df}'), ('\u{4e1}', '\u{4e1}'), ('\u{4e3}', '\u{4e3}'), ('\u{4e5}',
        '\u{4e5}'), ('\u{4e7}', '\u{4e7}'), ('\u{4e9}', '\u{4e9}'), ('\u{4eb}', '\u{4eb}'),
        ('\u{4ed}', '\u{4ed}'), ('\u{4ef}', '\u{4ef}'), ('\u{4f1}', '\u{4f1}'), ('\u{4f3}',
        '\u{4f3}'), ('\u{4f5}', '\u{4f5}'), ('\u{4f7}', '\u{4f7}'), ('\u{4f9}', '\u{4f9}'),
        ('\u{4fb}', '\u{4fb}'), ('\u{4fd}', '\u{4fd}'), ('\u{4ff}', '\u{4ff}'), ('\u{501}',
        '\u{501}'), ('\u{503}', '\u{503}'), ('\u{505}', '\u{505}'), ('\u{507}', '\u{507}'),
        ('\u{509}', '\u{509}'), ('\u{50b}', '\u{50b}'), ('\u{50d}', '\u{50d}'), ('\u{50f}',
        '\u{50f}'), ('\u{511}', '\u{511}'), ('\u{513}', '\u{513}'), ('\u{515}', '\u{515}'),
        ('\u{517}', '\u{517}'), ('\u{519}', '\u{519}'), ('\u{51b}', '\u{51b}'), ('\u{51d}',
        '\u{51d}'), ('\u{51f}', '\u{51f}'), ('\u{521}', '\u{521}'), ('\u{523}', '\u{523}'),
        ('\u{525}', '\u{525}'), ('\u{527}', '\u{527}'), ('\u{529}', '\u{529}'), ('\u{52b}',
        '\u{52b}'), ('\u{52d}', '\u{52d}'), ('\u{52f}', '\u{52f}'), ('\u{561}', '\u{587}'),
        ('\u{1d00}', '\u{1d2b}'), ('\u{1d6b}', '\u{1d77}'), ('\u{1d79}', '\u{1d9a}'), ('\u{1e01}',
        '\u{1e01}'), ('\u{1e03}', '\u{1e03}'), ('\u{1e05}', '\u{1e05}'), ('\u{1e07}', '\u{1e07}'),
        ('\u{1e09}', '\u{1e09}'), ('\u{1e0b}', '\u{1e0b}'), ('\u{1e0d}', '\u{1e0d}'), ('\u{1e0f}',
        '\u{1e0f}'), ('\u{1e11}', '\u{1e11}'), ('\u{1e13}', '\u{1e13}'), ('\u{1e15}', '\u{1e15}'),
        ('\u{1e17}', '\u{1e17}'), ('\u{1e19}', '\u{1e19}'), ('\u{1e1b}', '\u{1e1b}'), ('\u{1e1d}',
        '\u{1e1d}'), ('\u{1e1f}', '\u{1e1f}'), ('\u{1e21}', '\u{1e21}'), ('\u{1e23}', '\u{1e23}'),
        ('\u{1e25}', '\u{1e25}'), ('\u{1e27}', '\u{1e27}'), ('\u{1e29}', '\u{1e29}'), ('\u{1e2b}',
        '\u{1e2b}'), ('\u{1e2d}', '\u{1e2d}'), ('\u{1e2f}', '\u{1e2f}'), ('\u{1e31}', '\u{1e31}'),
        ('\u{1e33}', '\u{1e33}'), ('\u{1e35}', '\u{1e35}'), ('\u{1e37}', '\u{1e37}'), ('\u{1e39}',
        '\u{1e39}'), ('\u{1e3b}', '\u{1e3b}'), ('\u{1e3d}', '\u{1e3d}'), ('\u{1e3f}', '\u{1e3f}'),
        ('\u{1e41}', '\u{1e41}'), ('\u{1e43}', '\u{1e43}'), ('\u{1e45}', '\u{1e45}'), ('\u{1e47}',
        '\u{1e47}'), ('\u{1e49}', '\u{1e49}'), ('\u{1e4b}', '\u{1e4b}'), ('\u{1e4d}', '\u{1e4d}'),
        ('\u{1e4f}', '\u{1e4f}'), ('\u{1e51}', '\u{1e51}'), ('\u{1e53}', '\u{1e53}'), ('\u{1e55}',
        '\u{1e55}'), ('\u{1e57}', '\u{1e57}'), ('\u{1e59}', '\u{1e59}'), ('\u{1e5b}', '\u{1e5b}'),
        ('\u{1e5d}', '\u{1e5d}'), ('\u{1e5f}', '\u{1e5f}'), ('\u{1e61}', '\u{1e61}'), ('\u{1e63}',
        '\u{1e63}'), ('\u{1e65}', '\u{1e65}'), ('\u{1e67}', '\u{1e67}'), ('\u{1e69}', '\u{1e69}'),
        ('\u{1e6b}', '\u{1e6b}'), ('\u{1e6d}', '\u{1e6d}'), ('\u{1e6f}', '\u{1e6f}'), ('\u{1e71}',
        '\u{1e71}'), ('\u{1e73}', '\u{1e73}'), ('\u{1e75}', '\u{1e75}'), ('\u{1e77}', '\u{1e77}'),
        ('\u{1e79}', '\u{1e79}'), ('\u{1e7b}', '\u{1e7b}'), ('\u{1e7d}', '\u{1e7d}'), ('\u{1e7f}',
        '\u{1e7f}'), ('\u{1e81}', '\u{1e81}'), ('\u{1e83}', '\u{1e83}'), ('\u{1e85}', '\u{1e85}'),
        ('\u{1e87}', '\u{1e87}'), ('\u{1e89}', '\u{1e89}'), ('\u{1e8b}', '\u{1e8b}'), ('\u{1e8d}',
        '\u{1e8d}'), ('\u{1e8f}', '\u{1e8f}'), ('\u{1e91}', '\u{1e91}'), ('\u{1e93}', '\u{1e93}'),
        ('\u{1e95}', '\u{1e9d}'), ('\u{1e9f}', '\u{1e9f}'), ('\u{1ea1}', '\u{1ea1}'), ('\u{1ea3}',
        '\u{1ea3}'), ('\u{1ea5}', '\u{1ea5}'), ('\u{1ea7}', '\u{1ea7}'), ('\u{1ea9}', '\u{1ea9}'),
        ('\u{1eab}', '\u{1eab}'), ('\u{1ead}', '\u{1ead}'), ('\u{1eaf}', '\u{1eaf}'), ('\u{1eb1}',
        '\u{1eb1}'), ('\u{1eb3}', '\u{1eb3}'), ('\u{1eb5}', '\u{1eb5}'), ('\u{1eb7}', '\u{1eb7}'),
        ('\u{1eb9}', '\u{1eb9}'), ('\u{1ebb}', '\u{1ebb}'), ('\u{1ebd}', '\u{1ebd}'), ('\u{1ebf}',
        '\u{1ebf}'), ('\u{1ec1}', '\u{1ec1}'), ('\u{1ec3}', '\u{1ec3}'), ('\u{1ec5}', '\u{1ec5}'),
        ('\u{1ec7}', '\u{1ec7}'), ('\u{1ec9}', '\u{1ec9}'), ('\u{1ecb}', '\u{1ecb}'), ('\u{1ecd}',
        '\u{1ecd}'), ('\u{1ecf}', '\u{1ecf}'), ('\u{1ed1}', '\u{1ed1}'), ('\u{1ed3}', '\u{1ed3}'),
        ('\u{1ed5}', '\u{1ed5}'), ('\u{1ed7}', '\u{1ed7}'), ('\u{1ed9}', '\u{1ed9}'), ('\u{1edb}',
        '\u{1edb}'), ('\u{1edd}', '\u{1edd}'), ('\u{1edf}', '\u{1edf}'), ('\u{1ee1}', '\u{1ee1}'),
        ('\u{1ee3}', '\u{1ee3}'), ('\u{1ee5}', '\u{1ee5}'), ('\u{1ee7}', '\u{1ee7}'), ('\u{1ee9}',
        '\u{1ee9}'), ('\u{1eeb}', '\u{1eeb}'), ('\u{1eed}', '\u{1eed}'), ('\u{1eef}', '\u{1eef}'),
        ('\u{1ef1}', '\u{1ef1}'), ('\u{1ef3}', '\u{1ef3}'), ('\u{1ef5}', '\u{1ef5}'), ('\u{1ef7}',
        '\u{1ef7}'), ('\u{1ef9}', '\u{1ef9}'), ('\u{1efb}', '\u{1efb}'), ('\u{1efd}', '\u{1efd}'),
        ('\u{1eff}', '\u{1f07}'), ('\u{1f10}', '\u{1f15}'), ('\u{1f20}', '\u{1f27}'), ('\u{1f30}',
        '\u{1f37}'), ('\u{1f40}', '\u{1f45}'), ('\u{1f50}', '\u{1f57}'), ('\u{1f60}', '\u{1f67}'),
        ('\u{1f70}', '\u{1f7d}'), ('\u{1f80}', '\u{1f87}'), ('\u{1f90}', '\u{1f97}'), ('\u{1fa0}',
        '\u{1fa7}'), ('\u{1fb0}', '\u{1fb4}'), ('\u{1fb6}', '\u{1fb7}'), ('\u{1fbe}', '\u{1fbe}'),
        ('\u{1fc2}', '\u{1fc4}'), ('\u{1fc6}', '\u{1fc7}'), ('\u{1fd0}', '\u{1fd3}'), ('\u{1fd6}',
        '\u{1fd7}'), ('\u{1fe0}', '\u{1fe7}'), ('\u{1ff2}', '\u{1ff4}'), ('\u{1ff6}', '\u{1ff7}'),
        ('\u{210a}', '\u{210a}'), ('\u{210e}', '\u{210f}'), ('\u{2113}', '\u{2113}'), ('\u{212f}',
        '\u{212f}'), ('\u{2134}', '\u{2134}'), ('\u{2139}', '\u{2139}'), ('\u{213c}', '\u{213d}'),
        ('\u{2146}', '\u{2149}'), ('\u{214e}', '\u{214e}'), ('\u{2184}', '\u{2184}'), ('\u{2c30}',
        '\u{2c5e}'), ('\u{2c61}', '\u{2c61}'), ('\u{2c65}', '\u{2c66}'), ('\u{2c68}', '\u{2c68}'),
        ('\u{2c6a}', '\u{2c6a}'), ('\u{2c6c}', '\u{2c6c}'), ('\u{2c71}', '\u{2c71}'), ('\u{2c73}',
        '\u{2c74}'), ('\u{2c76}', '\u{2c7b}'), ('\u{2c81}', '\u{2c81}'), ('\u{2c83}', '\u{2c83}'),
        ('\u{2c85}', '\u{2c85}'), ('\u{2c87}', '\u{2c87}'), ('\u{2c89}', '\u{2c89}'), ('\u{2c8b}',
        '\u{2c8b}'), ('\u{2c8d}', '\u{2c8d}'), ('\u{2c8f}', '\u{2c8f}'), ('\u{2c91}', '\u{2c91}'),
        ('\u{2c93}', '\u{2c93}'), ('\u{2c95}', '\u{2c95}'), ('\u{2c97}', '\u{2c97}'), ('\u{2c99}',
        '\u{2c99}'), ('\u{2c9b}', '\u{2c9b}'), ('\u{2c9d}', '\u{2c9d}'), ('\u{2c9f}', '\u{2c9f}'),
        ('\u{2ca1}', '\u{2ca1}'), ('\u{2ca3}', '\u{2ca3}'), ('\u{2ca5}', '\u{2ca5}'), ('\u{2ca7}',
        '\u{2ca7}'), ('\u{2ca9}', '\u{2ca9}'), ('\u{2cab}', '\u{2cab}'), ('\u{2cad}', '\u{2cad}'),
        ('\u{2caf}', '\u{2caf}'), ('\u{2cb1}', '\u{2cb1}'), ('\u{2cb3}', '\u{2cb3}'), ('\u{2cb5}',
        '\u{2cb5}'), ('\u{2cb7}', '\u{2cb7}'), ('\u{2cb9}', '\u{2cb9}'), ('\u{2cbb}', '\u{2cbb}'),
        ('\u{2cbd}', '\u{2cbd}'), ('\u{2cbf}', '\u{2cbf}'), ('\u{2cc1}', '\u{2cc1}'), ('\u{2cc3}',
        '\u{2cc3}'), ('\u{2cc5}', '\u{2cc5}'), ('\u{2cc7}', '\u{2cc7}'), ('\u{2cc9}', '\u{2cc9}'),
        ('\u{2ccb}', '\u{2ccb}'), ('\u{2ccd}', '\u{2ccd}'), ('\u{2ccf}', '\u{2ccf}'), ('\u{2cd1}',
        '\u{2cd1}'), ('\u{2cd3}', '\u{2cd3}'), ('\u{2cd5}', '\u{2cd5}'), ('\u{2cd7}', '\u{2cd7}'),
        ('\u{2cd9}', '\u{2cd9}'), ('\u{2cdb}', '\u{2cdb}'), ('\u{2cdd}', '\u{2cdd}'), ('\u{2cdf}',
        '\u{2cdf}'), ('\u{2ce1}', '\u{2ce1}'), ('\u{2ce3}', '\u{2ce4}'), ('\u{2cec}', '\u{2cec}'),
        ('\u{2cee}', '\u{2cee}'), ('\u{2cf3}', '\u{2cf3}'), ('\u{2d00}', '\u{2d25}'), ('\u{2d27}',
        '\u{2d27}'), ('\u{2d2d}', '\u{2d2d}'), ('\u{a641}', '\u{a641}'), ('\u{a643}', '\u{a643}'),
        ('\u{a645}', '\u{a645}'), ('\u{a647}', '\u{a647}'), ('\u{a649}', '\u{a649}'), ('\u{a64b}',
        '\u{a64b}'), ('\u{a64d}', '\u{a64d}'), ('\u{a64f}', '\u{a64f}'), ('\u{a651}', '\u{a651}'),
        ('\u{a653}', '\u{a653}'), ('\u{a655}', '\u{a655}'), ('\u{a657}', '\u{a657}'), ('\u{a659}',
        '\u{a659}'), ('\u{a65b}', '\u{a65b}'), ('\u{a65d}', '\u{a65d}'), ('\u{a65f}', '\u{a65f}'),
        ('\u{a661}', '\u{a661}'), ('\u{a663}', '\u{a663}'), ('\u{a665}', '\u{a665}'), ('\u{a667}',
        '\u{a667}'), ('\u{a669}', '\u{a669}'), ('\u{a66b}', '\u{a66b}'), ('\u{a66d}', '\u{a66d}'),
        ('\u{a681}', '\u{a681}'), ('\u{a683}', '\u{a683}'), ('\u{a685}', '\u{a685}'), ('\u{a687}',
        '\u{a687}'), ('\u{a689}', '\u{a689}'), ('\u{a68b}', '\u{a68b}'), ('\u{a68d}', '\u{a68d}'),
        ('\u{a68f}', '\u{a68f}'), ('\u{a691}', '\u{a691}'), ('\u{a693}', '\u{a693}'), ('\u{a695}',
        '\u{a695}'), ('\u{a697}', '\u{a697}'), ('\u{a699}', '\u{a699}'), ('\u{a69b}', '\u{a69b}'),
        ('\u{a723}', '\u{a723}'), ('\u{a725}', '\u{a725}'), ('\u{a727}', '\u{a727}'), ('\u{a729}',
        '\u{a729}'), ('\u{a72b}', '\u{a72b}'), ('\u{a72d}', '\u{a72d}'), ('\u{a72f}', '\u{a731}'),
        ('\u{a733}', '\u{a733}'), ('\u{a735}', '\u{a735}'), ('\u{a737}', '\u{a737}'), ('\u{a739}',
        '\u{a739}'), ('\u{a73b}', '\u{a73b}'), ('\u{a73d}', '\u{a73d}'), ('\u{a73f}', '\u{a73f}'),
        ('\u{a741}', '\u{a741}'), ('\u{a743}', '\u{a743}'), ('\u{a745}', '\u{a745}'), ('\u{a747}',
        '\u{a747}'), ('\u{a749}', '\u{a749}'), ('\u{a74b}', '\u{a74b}'), ('\u{a74d}', '\u{a74d}'),
        ('\u{a74f}', '\u{a74f}'), ('\u{a751}', '\u{a751}'), ('\u{a753}', '\u{a753}'), ('\u{a755}',
        '\u{a755}'), ('\u{a757}', '\u{a757}'), ('\u{a759}', '\u{a759}'), ('\u{a75b}', '\u{a75b}'),
        ('\u{a75d}', '\u{a75d}'), ('\u{a75f}', '\u{a75f}'), ('\u{a761}', '\u{a761}'), ('\u{a763}',
        '\u{a763}'), ('\u{a765}', '\u{a765}'), ('\u{a767}', '\u{a767}'), ('\u{a769}', '\u{a769}'),
        ('\u{a76b}', '\u{a76b}'), ('\u{a76d}', '\u{a76d}'), ('\u{a76f}', '\u{a76f}'), ('\u{a771}',
        '\u{a778}'), ('\u{a77a}', '\u{a77a}'), ('\u{a77c}', '\u{a77c}'), ('\u{a77f}', '\u{a77f}'),
        ('\u{a781}', '\u{a781}'), ('\u{a783}', '\u{a783}'), ('\u{a785}', '\u{a785}'), ('\u{a787}',
        '\u{a787}'), ('\u{a78c}', '\u{a78c}'), ('\u{a78e}', '\u{a78e}'), ('\u{a791}', '\u{a791}'),
        ('\u{a793}', '\u{a795}'), ('\u{a797}', '\u{a797}'), ('\u{a799}', '\u{a799}'), ('\u{a79b}',
        '\u{a79b}'), ('\u{a79d}', '\u{a79d}'), ('\u{a79f}', '\u{a79f}'), ('\u{a7a1}', '\u{a7a1}'),
        ('\u{a7a3}', '\u{a7a3}'), ('\u{a7a5}', '\u{a7a5}'), ('\u{a7a7}', '\u{a7a7}'), ('\u{a7a9}',
        '\u{a7a9}'), ('\u{a7fa}', '\u{a7fa}'), ('\u{ab30}', '\u{ab5a}'), ('\u{ab64}', '\u{ab65}'),
        ('\u{fb00}', '\u{fb06}'), ('\u{fb13}', '\u{fb17}'), ('\u{ff41}', '\u{ff5a}'), ('\u{10428}',
        '\u{1044f}'), ('\u{118c0}', '\u{118df}'), ('\u{1d41a}', '\u{1d433}'), ('\u{1d44e}',
        '\u{1d454}'), ('\u{1d456}', '\u{1d467}'), ('\u{1d482}', '\u{1d49b}'), ('\u{1d4b6}',
        '\u{1d4b9}'), ('\u{1d4bb}', '\u{1d4bb}'), ('\u{1d4bd}', '\u{1d4c3}'), ('\u{1d4c5}',
        '\u{1d4cf}'), ('\u{1d4ea}', '\u{1d503}'), ('\u{1d51e}', '\u{1d537}'), ('\u{1d552}',
        '\u{1d56b}'), ('\u{1d586}', '\u{1d59f}'), ('\u{1d5ba}', '\u{1d5d3}'), ('\u{1d5ee}',
        '\u{1d607}'), ('\u{1d622}', '\u{1d63b}'), ('\u{1d656}', '\u{1d66f}'), ('\u{1d68a}',
        '\u{1d6a5}'), ('\u{1d6c2}', '\u{1d6da}'), ('\u{1d6dc}', '\u{1d6e1}'), ('\u{1d6fc}',
        '\u{1d714}'), ('\u{1d716}', '\u{1d71b}'), ('\u{1d736}', '\u{1d74e}'), ('\u{1d750}',
        '\u{1d755}'), ('\u{1d770}', '\u{1d788}'), ('\u{1d78a}', '\u{1d78f}'), ('\u{1d7aa}',
        '\u{1d7c2}'), ('\u{1d7c4}', '\u{1d7c9}'), ('\u{1d7cb}', '\u{1d7cb}')
    ];

    pub static Lm_table: &'static [(char, char)] = &[
        ('\u{2b0}', '\u{2c1}'), ('\u{2c6}', '\u{2d1}'), ('\u{2e0}', '\u{2e4}'), ('\u{2ec}',
        '\u{2ec}'), ('\u{2ee}', '\u{2ee}'), ('\u{374}', '\u{374}'), ('\u{37a}', '\u{37a}'),
        ('\u{559}', '\u{559}'), ('\u{640}', '\u{640}'), ('\u{6e5}', '\u{6e6}'), ('\u{7f4}',
        '\u{7f5}'), ('\u{7fa}', '\u{7fa}'), ('\u{81a}', '\u{81a}'), ('\u{824}', '\u{824}'),
        ('\u{828}', '\u{828}'), ('\u{971}', '\u{971}'), ('\u{e46}', '\u{e46}'), ('\u{ec6}',
        '\u{ec6}'), ('\u{10fc}', '\u{10fc}'), ('\u{17d7}', '\u{17d7}'), ('\u{1843}', '\u{1843}'),
        ('\u{1aa7}', '\u{1aa7}'), ('\u{1c78}', '\u{1c7d}'), ('\u{1d2c}', '\u{1d6a}'), ('\u{1d78}',
        '\u{1d78}'), ('\u{1d9b}', '\u{1dbf}'), ('\u{2071}', '\u{2071}'), ('\u{207f}', '\u{207f}'),
        ('\u{2090}', '\u{209c}'), ('\u{2c7c}', '\u{2c7d}'), ('\u{2d6f}', '\u{2d6f}'), ('\u{2e2f}',
        '\u{2e2f}'), ('\u{3005}', '\u{3005}'), ('\u{3031}', '\u{3035}'), ('\u{303b}', '\u{303b}'),
        ('\u{309d}', '\u{309e}'), ('\u{30fc}', '\u{30fe}'), ('\u{a015}', '\u{a015}'), ('\u{a4f8}',
        '\u{a4fd}'), ('\u{a60c}', '\u{a60c}'), ('\u{a67f}', '\u{a67f}'), ('\u{a69c}', '\u{a69d}'),
        ('\u{a717}', '\u{a71f}'), ('\u{a770}', '\u{a770}'), ('\u{a788}', '\u{a788}'), ('\u{a7f8}',
        '\u{a7f9}'), ('\u{a9cf}', '\u{a9cf}'), ('\u{a9e6}', '\u{a9e6}'), ('\u{aa70}', '\u{aa70}'),
        ('\u{aadd}', '\u{aadd}'), ('\u{aaf3}', '\u{aaf4}'), ('\u{ab5c}', '\u{ab5f}'), ('\u{ff70}',
        '\u{ff70}'), ('\u{ff9e}', '\u{ff9f}'), ('\u{16b40}', '\u{16b43}'), ('\u{16f93}',
        '\u{16f9f}')
    ];

    pub static Lo_table: &'static [(char, char)] = &[
        ('\u{aa}', '\u{aa}'), ('\u{ba}', '\u{ba}'), ('\u{1bb}', '\u{1bb}'), ('\u{1c0}', '\u{1c3}'),
        ('\u{294}', '\u{294}'), ('\u{5d0}', '\u{5ea}'), ('\u{5f0}', '\u{5f2}'), ('\u{620}',
        '\u{63f}'), ('\u{641}', '\u{64a}'), ('\u{66e}', '\u{66f}'), ('\u{671}', '\u{6d3}'),
        ('\u{6d5}', '\u{6d5}'), ('\u{6ee}', '\u{6ef}'), ('\u{6fa}', '\u{6fc}'), ('\u{6ff}',
        '\u{6ff}'), ('\u{710}', '\u{710}'), ('\u{712}', '\u{72f}'), ('\u{74d}', '\u{7a5}'),
        ('\u{7b1}', '\u{7b1}'), ('\u{7ca}', '\u{7ea}'), ('\u{800}', '\u{815}'), ('\u{840}',
        '\u{858}'), ('\u{8a0}', '\u{8b2}'), ('\u{904}', '\u{939}'), ('\u{93d}', '\u{93d}'),
        ('\u{950}', '\u{950}'), ('\u{958}', '\u{961}'), ('\u{972}', '\u{980}'), ('\u{985}',
        '\u{98c}'), ('\u{98f}', '\u{990}'), ('\u{993}', '\u{9a8}'), ('\u{9aa}', '\u{9b0}'),
        ('\u{9b2}', '\u{9b2}'), ('\u{9b6}', '\u{9b9}'), ('\u{9bd}', '\u{9bd}'), ('\u{9ce}',
        '\u{9ce}'), ('\u{9dc}', '\u{9dd}'), ('\u{9df}', '\u{9e1}'), ('\u{9f0}', '\u{9f1}'),
        ('\u{a05}', '\u{a0a}'), ('\u{a0f}', '\u{a10}'), ('\u{a13}', '\u{a28}'), ('\u{a2a}',
        '\u{a30}'), ('\u{a32}', '\u{a33}'), ('\u{a35}', '\u{a36}'), ('\u{a38}', '\u{a39}'),
        ('\u{a59}', '\u{a5c}'), ('\u{a5e}', '\u{a5e}'), ('\u{a72}', '\u{a74}'), ('\u{a85}',
        '\u{a8d}'), ('\u{a8f}', '\u{a91}'), ('\u{a93}', '\u{aa8}'), ('\u{aaa}', '\u{ab0}'),
        ('\u{ab2}', '\u{ab3}'), ('\u{ab5}', '\u{ab9}'), ('\u{abd}', '\u{abd}'), ('\u{ad0}',
        '\u{ad0}'), ('\u{ae0}', '\u{ae1}'), ('\u{b05}', '\u{b0c}'), ('\u{b0f}', '\u{b10}'),
        ('\u{b13}', '\u{b28}'), ('\u{b2a}', '\u{b30}'), ('\u{b32}', '\u{b33}'), ('\u{b35}',
        '\u{b39}'), ('\u{b3d}', '\u{b3d}'), ('\u{b5c}', '\u{b5d}'), ('\u{b5f}', '\u{b61}'),
        ('\u{b71}', '\u{b71}'), ('\u{b83}', '\u{b83}'), ('\u{b85}', '\u{b8a}'), ('\u{b8e}',
        '\u{b90}'), ('\u{b92}', '\u{b95}'), ('\u{b99}', '\u{b9a}'), ('\u{b9c}', '\u{b9c}'),
        ('\u{b9e}', '\u{b9f}'), ('\u{ba3}', '\u{ba4}'), ('\u{ba8}', '\u{baa}'), ('\u{bae}',
        '\u{bb9}'), ('\u{bd0}', '\u{bd0}'), ('\u{c05}', '\u{c0c}'), ('\u{c0e}', '\u{c10}'),
        ('\u{c12}', '\u{c28}'), ('\u{c2a}', '\u{c39}'), ('\u{c3d}', '\u{c3d}'), ('\u{c58}',
        '\u{c59}'), ('\u{c60}', '\u{c61}'), ('\u{c85}', '\u{c8c}'), ('\u{c8e}', '\u{c90}'),
        ('\u{c92}', '\u{ca8}'), ('\u{caa}', '\u{cb3}'), ('\u{cb5}', '\u{cb9}'), ('\u{cbd}',
        '\u{cbd}'), ('\u{cde}', '\u{cde}'), ('\u{ce0}', '\u{ce1}'), ('\u{cf1}', '\u{cf2}'),
        ('\u{d05}', '\u{d0c}'), ('\u{d0e}', '\u{d10}'), ('\u{d12}', '\u{d3a}'), ('\u{d3d}',
        '\u{d3d}'), ('\u{d4e}', '\u{d4e}'), ('\u{d60}', '\u{d61}'), ('\u{d7a}', '\u{d7f}'),
        ('\u{d85}', '\u{d96}'), ('\u{d9a}', '\u{db1}'), ('\u{db3}', '\u{dbb}'), ('\u{dbd}',
        '\u{dbd}'), ('\u{dc0}', '\u{dc6}'), ('\u{e01}', '\u{e30}'), ('\u{e32}', '\u{e33}'),
        ('\u{e40}', '\u{e45}'), ('\u{e81}', '\u{e82}'), ('\u{e84}', '\u{e84}'), ('\u{e87}',
        '\u{e88}'), ('\u{e8a}', '\u{e8a}'), ('\u{e8d}', '\u{e8d}'), ('\u{e94}', '\u{e97}'),
        ('\u{e99}', '\u{e9f}'), ('\u{ea1}', '\u{ea3}'), ('\u{ea5}', '\u{ea5}'), ('\u{ea7}',
        '\u{ea7}'), ('\u{eaa}', '\u{eab}'), ('\u{ead}', '\u{eb0}'), ('\u{eb2}', '\u{eb3}'),
        ('\u{ebd}', '\u{ebd}'), ('\u{ec0}', '\u{ec4}'), ('\u{edc}', '\u{edf}'), ('\u{f00}',
        '\u{f00}'), ('\u{f40}', '\u{f47}'), ('\u{f49}', '\u{f6c}'), ('\u{f88}', '\u{f8c}'),
        ('\u{1000}', '\u{102a}'), ('\u{103f}', '\u{103f}'), ('\u{1050}', '\u{1055}'), ('\u{105a}',
        '\u{105d}'), ('\u{1061}', '\u{1061}'), ('\u{1065}', '\u{1066}'), ('\u{106e}', '\u{1070}'),
        ('\u{1075}', '\u{1081}'), ('\u{108e}', '\u{108e}'), ('\u{10d0}', '\u{10fa}'), ('\u{10fd}',
        '\u{1248}'), ('\u{124a}', '\u{124d}'), ('\u{1250}', '\u{1256}'), ('\u{1258}', '\u{1258}'),
        ('\u{125a}', '\u{125d}'), ('\u{1260}', '\u{1288}'), ('\u{128a}', '\u{128d}'), ('\u{1290}',
        '\u{12b0}'), ('\u{12b2}', '\u{12b5}'), ('\u{12b8}', '\u{12be}'), ('\u{12c0}', '\u{12c0}'),
        ('\u{12c2}', '\u{12c5}'), ('\u{12c8}', '\u{12d6}'), ('\u{12d8}', '\u{1310}'), ('\u{1312}',
        '\u{1315}'), ('\u{1318}', '\u{135a}'), ('\u{1380}', '\u{138f}'), ('\u{13a0}', '\u{13f4}'),
        ('\u{1401}', '\u{166c}'), ('\u{166f}', '\u{167f}'), ('\u{1681}', '\u{169a}'), ('\u{16a0}',
        '\u{16ea}'), ('\u{16f1}', '\u{16f8}'), ('\u{1700}', '\u{170c}'), ('\u{170e}', '\u{1711}'),
        ('\u{1720}', '\u{1731}'), ('\u{1740}', '\u{1751}'), ('\u{1760}', '\u{176c}'), ('\u{176e}',
        '\u{1770}'), ('\u{1780}', '\u{17b3}'), ('\u{17dc}', '\u{17dc}'), ('\u{1820}', '\u{1842}'),
        ('\u{1844}', '\u{1877}'), ('\u{1880}', '\u{18a8}'), ('\u{18aa}', '\u{18aa}'), ('\u{18b0}',
        '\u{18f5}'), ('\u{1900}', '\u{191e}'), ('\u{1950}', '\u{196d}'), ('\u{1970}', '\u{1974}'),
        ('\u{1980}', '\u{19ab}'), ('\u{19c1}', '\u{19c7}'), ('\u{1a00}', '\u{1a16}'), ('\u{1a20}',
        '\u{1a54}'), ('\u{1b05}', '\u{1b33}'), ('\u{1b45}', '\u{1b4b}'), ('\u{1b83}', '\u{1ba0}'),
        ('\u{1bae}', '\u{1baf}'), ('\u{1bba}', '\u{1be5}'), ('\u{1c00}', '\u{1c23}'), ('\u{1c4d}',
        '\u{1c4f}'), ('\u{1c5a}', '\u{1c77}'), ('\u{1ce9}', '\u{1cec}'), ('\u{1cee}', '\u{1cf1}'),
        ('\u{1cf5}', '\u{1cf6}'), ('\u{2135}', '\u{2138}'), ('\u{2d30}', '\u{2d67}'), ('\u{2d80}',
        '\u{2d96}'), ('\u{2da0}', '\u{2da6}'), ('\u{2da8}', '\u{2dae}'), ('\u{2db0}', '\u{2db6}'),
        ('\u{2db8}', '\u{2dbe}'), ('\u{2dc0}', '\u{2dc6}'), ('\u{2dc8}', '\u{2dce}'), ('\u{2dd0}',
        '\u{2dd6}'), ('\u{2dd8}', '\u{2dde}'), ('\u{3006}', '\u{3006}'), ('\u{303c}', '\u{303c}'),
        ('\u{3041}', '\u{3096}'), ('\u{309f}', '\u{309f}'), ('\u{30a1}', '\u{30fa}'), ('\u{30ff}',
        '\u{30ff}'), ('\u{3105}', '\u{312d}'), ('\u{3131}', '\u{318e}'), ('\u{31a0}', '\u{31ba}'),
        ('\u{31f0}', '\u{31ff}'), ('\u{3400}', '\u{3400}'), ('\u{4db5}', '\u{4db5}'), ('\u{4e00}',
        '\u{4e00}'), ('\u{9fcc}', '\u{9fcc}'), ('\u{a000}', '\u{a014}'), ('\u{a016}', '\u{a48c}'),
        ('\u{a4d0}', '\u{a4f7}'), ('\u{a500}', '\u{a60b}'), ('\u{a610}', '\u{a61f}'), ('\u{a62a}',
        '\u{a62b}'), ('\u{a66e}', '\u{a66e}'), ('\u{a6a0}', '\u{a6e5}'), ('\u{a7f7}', '\u{a7f7}'),
        ('\u{a7fb}', '\u{a801}'), ('\u{a803}', '\u{a805}'), ('\u{a807}', '\u{a80a}'), ('\u{a80c}',
        '\u{a822}'), ('\u{a840}', '\u{a873}'), ('\u{a882}', '\u{a8b3}'), ('\u{a8f2}', '\u{a8f7}'),
        ('\u{a8fb}', '\u{a8fb}'), ('\u{a90a}', '\u{a925}'), ('\u{a930}', '\u{a946}'), ('\u{a960}',
        '\u{a97c}'), ('\u{a984}', '\u{a9b2}'), ('\u{a9e0}', '\u{a9e4}'), ('\u{a9e7}', '\u{a9ef}'),
        ('\u{a9fa}', '\u{a9fe}'), ('\u{aa00}', '\u{aa28}'), ('\u{aa40}', '\u{aa42}'), ('\u{aa44}',
        '\u{aa4b}'), ('\u{aa60}', '\u{aa6f}'), ('\u{aa71}', '\u{aa76}'), ('\u{aa7a}', '\u{aa7a}'),
        ('\u{aa7e}', '\u{aaaf}'), ('\u{aab1}', '\u{aab1}'), ('\u{aab5}', '\u{aab6}'), ('\u{aab9}',
        '\u{aabd}'), ('\u{aac0}', '\u{aac0}'), ('\u{aac2}', '\u{aac2}'), ('\u{aadb}', '\u{aadc}'),
        ('\u{aae0}', '\u{aaea}'), ('\u{aaf2}', '\u{aaf2}'), ('\u{ab01}', '\u{ab06}'), ('\u{ab09}',
        '\u{ab0e}'), ('\u{ab11}', '\u{ab16}'), ('\u{ab20}', '\u{ab26}'), ('\u{ab28}', '\u{ab2e}'),
        ('\u{abc0}', '\u{abe2}'), ('\u{ac00}', '\u{ac00}'), ('\u{d7a3}', '\u{d7a3}'), ('\u{d7b0}',
        '\u{d7c6}'), ('\u{d7cb}', '\u{d7fb}'), ('\u{f900}', '\u{fa6d}'), ('\u{fa70}', '\u{fad9}'),
        ('\u{fb1d}', '\u{fb1d}'), ('\u{fb1f}', '\u{fb28}'), ('\u{fb2a}', '\u{fb36}'), ('\u{fb38}',
        '\u{fb3c}'), ('\u{fb3e}', '\u{fb3e}'), ('\u{fb40}', '\u{fb41}'), ('\u{fb43}', '\u{fb44}'),
        ('\u{fb46}', '\u{fbb1}'), ('\u{fbd3}', '\u{fd3d}'), ('\u{fd50}', '\u{fd8f}'), ('\u{fd92}',
        '\u{fdc7}'), ('\u{fdf0}', '\u{fdfb}'), ('\u{fe70}', '\u{fe74}'), ('\u{fe76}', '\u{fefc}'),
        ('\u{ff66}', '\u{ff6f}'), ('\u{ff71}', '\u{ff9d}'), ('\u{ffa0}', '\u{ffbe}'), ('\u{ffc2}',
        '\u{ffc7}'), ('\u{ffca}', '\u{ffcf}'), ('\u{ffd2}', '\u{ffd7}'), ('\u{ffda}', '\u{ffdc}'),
        ('\u{10000}', '\u{1000b}'), ('\u{1000d}', '\u{10026}'), ('\u{10028}', '\u{1003a}'),
        ('\u{1003c}', '\u{1003d}'), ('\u{1003f}', '\u{1004d}'), ('\u{10050}', '\u{1005d}'),
        ('\u{10080}', '\u{100fa}'), ('\u{10280}', '\u{1029c}'), ('\u{102a0}', '\u{102d0}'),
        ('\u{10300}', '\u{1031f}'), ('\u{10330}', '\u{10340}'), ('\u{10342}', '\u{10349}'),
        ('\u{10350}', '\u{10375}'), ('\u{10380}', '\u{1039d}'), ('\u{103a0}', '\u{103c3}'),
        ('\u{103c8}', '\u{103cf}'), ('\u{10450}', '\u{1049d}'), ('\u{10500}', '\u{10527}'),
        ('\u{10530}', '\u{10563}'), ('\u{10600}', '\u{10736}'), ('\u{10740}', '\u{10755}'),
        ('\u{10760}', '\u{10767}'), ('\u{10800}', '\u{10805}'), ('\u{10808}', '\u{10808}'),
        ('\u{1080a}', '\u{10835}'), ('\u{10837}', '\u{10838}'), ('\u{1083c}', '\u{1083c}'),
        ('\u{1083f}', '\u{10855}'), ('\u{10860}', '\u{10876}'), ('\u{10880}', '\u{1089e}'),
        ('\u{10900}', '\u{10915}'), ('\u{10920}', '\u{10939}'), ('\u{10980}', '\u{109b7}'),
        ('\u{109be}', '\u{109bf}'), ('\u{10a00}', '\u{10a00}'), ('\u{10a10}', '\u{10a13}'),
        ('\u{10a15}', '\u{10a17}'), ('\u{10a19}', '\u{10a33}'), ('\u{10a60}', '\u{10a7c}'),
        ('\u{10a80}', '\u{10a9c}'), ('\u{10ac0}', '\u{10ac7}'), ('\u{10ac9}', '\u{10ae4}'),
        ('\u{10b00}', '\u{10b35}'), ('\u{10b40}', '\u{10b55}'), ('\u{10b60}', '\u{10b72}'),
        ('\u{10b80}', '\u{10b91}'), ('\u{10c00}', '\u{10c48}'), ('\u{11003}', '\u{11037}'),
        ('\u{11083}', '\u{110af}'), ('\u{110d0}', '\u{110e8}'), ('\u{11103}', '\u{11126}'),
        ('\u{11150}', '\u{11172}'), ('\u{11176}', '\u{11176}'), ('\u{11183}', '\u{111b2}'),
        ('\u{111c1}', '\u{111c4}'), ('\u{111da}', '\u{111da}'), ('\u{11200}', '\u{11211}'),
        ('\u{11213}', '\u{1122b}'), ('\u{112b0}', '\u{112de}'), ('\u{11305}', '\u{1130c}'),
        ('\u{1130f}', '\u{11310}'), ('\u{11313}', '\u{11328}'), ('\u{1132a}', '\u{11330}'),
        ('\u{11332}', '\u{11333}'), ('\u{11335}', '\u{11339}'), ('\u{1133d}', '\u{1133d}'),
        ('\u{1135d}', '\u{11361}'), ('\u{11480}', '\u{114af}'), ('\u{114c4}', '\u{114c5}'),
        ('\u{114c7}', '\u{114c7}'), ('\u{11580}', '\u{115ae}'), ('\u{11600}', '\u{1162f}'),
        ('\u{11644}', '\u{11644}'), ('\u{11680}', '\u{116aa}'), ('\u{118ff}', '\u{118ff}'),
        ('\u{11ac0}', '\u{11af8}'), ('\u{12000}', '\u{12398}'), ('\u{13000}', '\u{1342e}'),
        ('\u{16800}', '\u{16a38}'), ('\u{16a40}', '\u{16a5e}'), ('\u{16ad0}', '\u{16aed}'),
        ('\u{16b00}', '\u{16b2f}'), ('\u{16b63}', '\u{16b77}'), ('\u{16b7d}', '\u{16b8f}'),
        ('\u{16f00}', '\u{16f44}'), ('\u{16f50}', '\u{16f50}'), ('\u{1b000}', '\u{1b001}'),
        ('\u{1bc00}', '\u{1bc6a}'), ('\u{1bc70}', '\u{1bc7c}'), ('\u{1bc80}', '\u{1bc88}'),
        ('\u{1bc90}', '\u{1bc99}'), ('\u{1e800}', '\u{1e8c4}'), ('\u{1ee00}', '\u{1ee03}'),
        ('\u{1ee05}', '\u{1ee1f}'), ('\u{1ee21}', '\u{1ee22}'), ('\u{1ee24}', '\u{1ee24}'),
        ('\u{1ee27}', '\u{1ee27}'), ('\u{1ee29}', '\u{1ee32}'), ('\u{1ee34}', '\u{1ee37}'),
        ('\u{1ee39}', '\u{1ee39}'), ('\u{1ee3b}', '\u{1ee3b}'), ('\u{1ee42}', '\u{1ee42}'),
        ('\u{1ee47}', '\u{1ee47}'), ('\u{1ee49}', '\u{1ee49}'), ('\u{1ee4b}', '\u{1ee4b}'),
        ('\u{1ee4d}', '\u{1ee4f}'), ('\u{1ee51}', '\u{1ee52}'), ('\u{1ee54}', '\u{1ee54}'),
        ('\u{1ee57}', '\u{1ee57}'), ('\u{1ee59}', '\u{1ee59}'), ('\u{1ee5b}', '\u{1ee5b}'),
        ('\u{1ee5d}', '\u{1ee5d}'), ('\u{1ee5f}', '\u{1ee5f}'), ('\u{1ee61}', '\u{1ee62}'),
        ('\u{1ee64}', '\u{1ee64}'), ('\u{1ee67}', '\u{1ee6a}'), ('\u{1ee6c}', '\u{1ee72}'),
        ('\u{1ee74}', '\u{1ee77}'), ('\u{1ee79}', '\u{1ee7c}'), ('\u{1ee7e}', '\u{1ee7e}'),
        ('\u{1ee80}', '\u{1ee89}'), ('\u{1ee8b}', '\u{1ee9b}'), ('\u{1eea1}', '\u{1eea3}'),
        ('\u{1eea5}', '\u{1eea9}'), ('\u{1eeab}', '\u{1eebb}'), ('\u{20000}', '\u{20000}'),
        ('\u{2a6d6}', '\u{2a6d6}'), ('\u{2a700}', '\u{2a700}'), ('\u{2b734}', '\u{2b734}'),
        ('\u{2b740}', '\u{2b740}'), ('\u{2b81d}', '\u{2b81d}'), ('\u{2f800}', '\u{2fa1d}')
    ];

    pub static Lt_table: &'static [(char, char)] = &[
        ('\u{1c5}', '\u{1c5}'), ('\u{1c8}', '\u{1c8}'), ('\u{1cb}', '\u{1cb}'), ('\u{1f2}',
        '\u{1f2}'), ('\u{1f88}', '\u{1f8f}'), ('\u{1f98}', '\u{1f9f}'), ('\u{1fa8}', '\u{1faf}'),
        ('\u{1fbc}', '\u{1fbc}'), ('\u{1fcc}', '\u{1fcc}'), ('\u{1ffc}', '\u{1ffc}')
    ];

    pub static Lu_table: &'static [(char, char)] = &[
        ('\u{41}', '\u{5a}'), ('\u{c0}', '\u{d6}'), ('\u{d8}', '\u{de}'), ('\u{100}', '\u{100}'),
        ('\u{102}', '\u{102}'), ('\u{104}', '\u{104}'), ('\u{106}', '\u{106}'), ('\u{108}',
        '\u{108}'), ('\u{10a}', '\u{10a}'), ('\u{10c}', '\u{10c}'), ('\u{10e}', '\u{10e}'),
        ('\u{110}', '\u{110}'), ('\u{112}', '\u{112}'), ('\u{114}', '\u{114}'), ('\u{116}',
        '\u{116}'), ('\u{118}', '\u{118}'), ('\u{11a}', '\u{11a}'), ('\u{11c}', '\u{11c}'),
        ('\u{11e}', '\u{11e}'), ('\u{120}', '\u{120}'), ('\u{122}', '\u{122}'), ('\u{124}',
        '\u{124}'), ('\u{126}', '\u{126}'), ('\u{128}', '\u{128}'), ('\u{12a}', '\u{12a}'),
        ('\u{12c}', '\u{12c}'), ('\u{12e}', '\u{12e}'), ('\u{130}', '\u{130}'), ('\u{132}',
        '\u{132}'), ('\u{134}', '\u{134}'), ('\u{136}', '\u{136}'), ('\u{139}', '\u{139}'),
        ('\u{13b}', '\u{13b}'), ('\u{13d}', '\u{13d}'), ('\u{13f}', '\u{13f}'), ('\u{141}',
        '\u{141}'), ('\u{143}', '\u{143}'), ('\u{145}', '\u{145}'), ('\u{147}', '\u{147}'),
        ('\u{14a}', '\u{14a}'), ('\u{14c}', '\u{14c}'), ('\u{14e}', '\u{14e}'), ('\u{150}',
        '\u{150}'), ('\u{152}', '\u{152}'), ('\u{154}', '\u{154}'), ('\u{156}', '\u{156}'),
        ('\u{158}', '\u{158}'), ('\u{15a}', '\u{15a}'), ('\u{15c}', '\u{15c}'), ('\u{15e}',
        '\u{15e}'), ('\u{160}', '\u{160}'), ('\u{162}', '\u{162}'), ('\u{164}', '\u{164}'),
        ('\u{166}', '\u{166}'), ('\u{168}', '\u{168}'), ('\u{16a}', '\u{16a}'), ('\u{16c}',
        '\u{16c}'), ('\u{16e}', '\u{16e}'), ('\u{170}', '\u{170}'), ('\u{172}', '\u{172}'),
        ('\u{174}', '\u{174}'), ('\u{176}', '\u{176}'), ('\u{178}', '\u{179}'), ('\u{17b}',
        '\u{17b}'), ('\u{17d}', '\u{17d}'), ('\u{181}', '\u{182}'), ('\u{184}', '\u{184}'),
        ('\u{186}', '\u{187}'), ('\u{189}', '\u{18b}'), ('\u{18e}', '\u{191}'), ('\u{193}',
        '\u{194}'), ('\u{196}', '\u{198}'), ('\u{19c}', '\u{19d}'), ('\u{19f}', '\u{1a0}'),
        ('\u{1a2}', '\u{1a2}'), ('\u{1a4}', '\u{1a4}'), ('\u{1a6}', '\u{1a7}'), ('\u{1a9}',
        '\u{1a9}'), ('\u{1ac}', '\u{1ac}'), ('\u{1ae}', '\u{1af}'), ('\u{1b1}', '\u{1b3}'),
        ('\u{1b5}', '\u{1b5}'), ('\u{1b7}', '\u{1b8}'), ('\u{1bc}', '\u{1bc}'), ('\u{1c4}',
        '\u{1c4}'), ('\u{1c7}', '\u{1c7}'), ('\u{1ca}', '\u{1ca}'), ('\u{1cd}', '\u{1cd}'),
        ('\u{1cf}', '\u{1cf}'), ('\u{1d1}', '\u{1d1}'), ('\u{1d3}', '\u{1d3}'), ('\u{1d5}',
        '\u{1d5}'), ('\u{1d7}', '\u{1d7}'), ('\u{1d9}', '\u{1d9}'), ('\u{1db}', '\u{1db}'),
        ('\u{1de}', '\u{1de}'), ('\u{1e0}', '\u{1e0}'), ('\u{1e2}', '\u{1e2}'), ('\u{1e4}',
        '\u{1e4}'), ('\u{1e6}', '\u{1e6}'), ('\u{1e8}', '\u{1e8}'), ('\u{1ea}', '\u{1ea}'),
        ('\u{1ec}', '\u{1ec}'), ('\u{1ee}', '\u{1ee}'), ('\u{1f1}', '\u{1f1}'), ('\u{1f4}',
        '\u{1f4}'), ('\u{1f6}', '\u{1f8}'), ('\u{1fa}', '\u{1fa}'), ('\u{1fc}', '\u{1fc}'),
        ('\u{1fe}', '\u{1fe}'), ('\u{200}', '\u{200}'), ('\u{202}', '\u{202}'), ('\u{204}',
        '\u{204}'), ('\u{206}', '\u{206}'), ('\u{208}', '\u{208}'), ('\u{20a}', '\u{20a}'),
        ('\u{20c}', '\u{20c}'), ('\u{20e}', '\u{20e}'), ('\u{210}', '\u{210}'), ('\u{212}',
        '\u{212}'), ('\u{214}', '\u{214}'), ('\u{216}', '\u{216}'), ('\u{218}', '\u{218}'),
        ('\u{21a}', '\u{21a}'), ('\u{21c}', '\u{21c}'), ('\u{21e}', '\u{21e}'), ('\u{220}',
        '\u{220}'), ('\u{222}', '\u{222}'), ('\u{224}', '\u{224}'), ('\u{226}', '\u{226}'),
        ('\u{228}', '\u{228}'), ('\u{22a}', '\u{22a}'), ('\u{22c}', '\u{22c}'), ('\u{22e}',
        '\u{22e}'), ('\u{230}', '\u{230}'), ('\u{232}', '\u{232}'), ('\u{23a}', '\u{23b}'),
        ('\u{23d}', '\u{23e}'), ('\u{241}', '\u{241}'), ('\u{243}', '\u{246}'), ('\u{248}',
        '\u{248}'), ('\u{24a}', '\u{24a}'), ('\u{24c}', '\u{24c}'), ('\u{24e}', '\u{24e}'),
        ('\u{370}', '\u{370}'), ('\u{372}', '\u{372}'), ('\u{376}', '\u{376}'), ('\u{37f}',
        '\u{37f}'), ('\u{386}', '\u{386}'), ('\u{388}', '\u{38a}'), ('\u{38c}', '\u{38c}'),
        ('\u{38e}', '\u{38f}'), ('\u{391}', '\u{3a1}'), ('\u{3a3}', '\u{3ab}'), ('\u{3cf}',
        '\u{3cf}'), ('\u{3d2}', '\u{3d4}'), ('\u{3d8}', '\u{3d8}'), ('\u{3da}', '\u{3da}'),
        ('\u{3dc}', '\u{3dc}'), ('\u{3de}', '\u{3de}'), ('\u{3e0}', '\u{3e0}'), ('\u{3e2}',
        '\u{3e2}'), ('\u{3e4}', '\u{3e4}'), ('\u{3e6}', '\u{3e6}'), ('\u{3e8}', '\u{3e8}'),
        ('\u{3ea}', '\u{3ea}'), ('\u{3ec}', '\u{3ec}'), ('\u{3ee}', '\u{3ee}'), ('\u{3f4}',
        '\u{3f4}'), ('\u{3f7}', '\u{3f7}'), ('\u{3f9}', '\u{3fa}'), ('\u{3fd}', '\u{42f}'),
        ('\u{460}', '\u{460}'), ('\u{462}', '\u{462}'), ('\u{464}', '\u{464}'), ('\u{466}',
        '\u{466}'), ('\u{468}', '\u{468}'), ('\u{46a}', '\u{46a}'), ('\u{46c}', '\u{46c}'),
        ('\u{46e}', '\u{46e}'), ('\u{470}', '\u{470}'), ('\u{472}', '\u{472}'), ('\u{474}',
        '\u{474}'), ('\u{476}', '\u{476}'), ('\u{478}', '\u{478}'), ('\u{47a}', '\u{47a}'),
        ('\u{47c}', '\u{47c}'), ('\u{47e}', '\u{47e}'), ('\u{480}', '\u{480}'), ('\u{48a}',
        '\u{48a}'), ('\u{48c}', '\u{48c}'), ('\u{48e}', '\u{48e}'), ('\u{490}', '\u{490}'),
        ('\u{492}', '\u{492}'), ('\u{494}', '\u{494}'), ('\u{496}', '\u{496}'), ('\u{498}',
        '\u{498}'), ('\u{49a}', '\u{49a}'), ('\u{49c}', '\u{49c}'), ('\u{49e}', '\u{49e}'),
        ('\u{4a0}', '\u{4a0}'), ('\u{4a2}', '\u{4a2}'), ('\u{4a4}', '\u{4a4}'), ('\u{4a6}',
        '\u{4a6}'), ('\u{4a8}', '\u{4a8}'), ('\u{4aa}', '\u{4aa}'), ('\u{4ac}', '\u{4ac}'),
        ('\u{4ae}', '\u{4ae}'), ('\u{4b0}', '\u{4b0}'), ('\u{4b2}', '\u{4b2}'), ('\u{4b4}',
        '\u{4b4}'), ('\u{4b6}', '\u{4b6}'), ('\u{4b8}', '\u{4b8}'), ('\u{4ba}', '\u{4ba}'),
        ('\u{4bc}', '\u{4bc}'), ('\u{4be}', '\u{4be}'), ('\u{4c0}', '\u{4c1}'), ('\u{4c3}',
        '\u{4c3}'), ('\u{4c5}', '\u{4c5}'), ('\u{4c7}', '\u{4c7}'), ('\u{4c9}', '\u{4c9}'),
        ('\u{4cb}', '\u{4cb}'), ('\u{4cd}', '\u{4cd}'), ('\u{4d0}', '\u{4d0}'), ('\u{4d2}',
        '\u{4d2}'), ('\u{4d4}', '\u{4d4}'), ('\u{4d6}', '\u{4d6}'), ('\u{4d8}', '\u{4d8}'),
        ('\u{4da}', '\u{4da}'), ('\u{4dc}', '\u{4dc}'), ('\u{4de}', '\u{4de}'), ('\u{4e0}',
        '\u{4e0}'), ('\u{4e2}', '\u{4e2}'), ('\u{4e4}', '\u{4e4}'), ('\u{4e6}', '\u{4e6}'),
        ('\u{4e8}', '\u{4e8}'), ('\u{4ea}', '\u{4ea}'), ('\u{4ec}', '\u{4ec}'), ('\u{4ee}',
        '\u{4ee}'), ('\u{4f0}', '\u{4f0}'), ('\u{4f2}', '\u{4f2}'), ('\u{4f4}', '\u{4f4}'),
        ('\u{4f6}', '\u{4f6}'), ('\u{4f8}', '\u{4f8}'), ('\u{4fa}', '\u{4fa}'), ('\u{4fc}',
        '\u{4fc}'), ('\u{4fe}', '\u{4fe}'), ('\u{500}', '\u{500}'), ('\u{502}', '\u{502}'),
        ('\u{504}', '\u{504}'), ('\u{506}', '\u{506}'), ('\u{508}', '\u{508}'), ('\u{50a}',
        '\u{50a}'), ('\u{50c}', '\u{50c}'), ('\u{50e}', '\u{50e}'), ('\u{510}', '\u{510}'),
        ('\u{512}', '\u{512}'), ('\u{514}', '\u{514}'), ('\u{516}', '\u{516}'), ('\u{518}',
        '\u{518}'), ('\u{51a}', '\u{51a}'), ('\u{51c}', '\u{51c}'), ('\u{51e}', '\u{51e}'),
        ('\u{520}', '\u{520}'), ('\u{522}', '\u{522}'), ('\u{524}', '\u{524}'), ('\u{526}',
        '\u{526}'), ('\u{528}', '\u{528}'), ('\u{52a}', '\u{52a}'), ('\u{52c}', '\u{52c}'),
        ('\u{52e}', '\u{52e}'), ('\u{531}', '\u{556}'), ('\u{10a0}', '\u{10c5}'), ('\u{10c7}',
        '\u{10c7}'), ('\u{10cd}', '\u{10cd}'), ('\u{1e00}', '\u{1e00}'), ('\u{1e02}', '\u{1e02}'),
        ('\u{1e04}', '\u{1e04}'), ('\u{1e06}', '\u{1e06}'), ('\u{1e08}', '\u{1e08}'), ('\u{1e0a}',
        '\u{1e0a}'), ('\u{1e0c}', '\u{1e0c}'), ('\u{1e0e}', '\u{1e0e}'), ('\u{1e10}', '\u{1e10}'),
        ('\u{1e12}', '\u{1e12}'), ('\u{1e14}', '\u{1e14}'), ('\u{1e16}', '\u{1e16}'), ('\u{1e18}',
        '\u{1e18}'), ('\u{1e1a}', '\u{1e1a}'), ('\u{1e1c}', '\u{1e1c}'), ('\u{1e1e}', '\u{1e1e}'),
        ('\u{1e20}', '\u{1e20}'), ('\u{1e22}', '\u{1e22}'), ('\u{1e24}', '\u{1e24}'), ('\u{1e26}',
        '\u{1e26}'), ('\u{1e28}', '\u{1e28}'), ('\u{1e2a}', '\u{1e2a}'), ('\u{1e2c}', '\u{1e2c}'),
        ('\u{1e2e}', '\u{1e2e}'), ('\u{1e30}', '\u{1e30}'), ('\u{1e32}', '\u{1e32}'), ('\u{1e34}',
        '\u{1e34}'), ('\u{1e36}', '\u{1e36}'), ('\u{1e38}', '\u{1e38}'), ('\u{1e3a}', '\u{1e3a}'),
        ('\u{1e3c}', '\u{1e3c}'), ('\u{1e3e}', '\u{1e3e}'), ('\u{1e40}', '\u{1e40}'), ('\u{1e42}',
        '\u{1e42}'), ('\u{1e44}', '\u{1e44}'), ('\u{1e46}', '\u{1e46}'), ('\u{1e48}', '\u{1e48}'),
        ('\u{1e4a}', '\u{1e4a}'), ('\u{1e4c}', '\u{1e4c}'), ('\u{1e4e}', '\u{1e4e}'), ('\u{1e50}',
        '\u{1e50}'), ('\u{1e52}', '\u{1e52}'), ('\u{1e54}', '\u{1e54}'), ('\u{1e56}', '\u{1e56}'),
        ('\u{1e58}', '\u{1e58}'), ('\u{1e5a}', '\u{1e5a}'), ('\u{1e5c}', '\u{1e5c}'), ('\u{1e5e}',
        '\u{1e5e}'), ('\u{1e60}', '\u{1e60}'), ('\u{1e62}', '\u{1e62}'), ('\u{1e64}', '\u{1e64}'),
        ('\u{1e66}', '\u{1e66}'), ('\u{1e68}', '\u{1e68}'), ('\u{1e6a}', '\u{1e6a}'), ('\u{1e6c}',
        '\u{1e6c}'), ('\u{1e6e}', '\u{1e6e}'), ('\u{1e70}', '\u{1e70}'), ('\u{1e72}', '\u{1e72}'),
        ('\u{1e74}', '\u{1e74}'), ('\u{1e76}', '\u{1e76}'), ('\u{1e78}', '\u{1e78}'), ('\u{1e7a}',
        '\u{1e7a}'), ('\u{1e7c}', '\u{1e7c}'), ('\u{1e7e}', '\u{1e7e}'), ('\u{1e80}', '\u{1e80}'),
        ('\u{1e82}', '\u{1e82}'), ('\u{1e84}', '\u{1e84}'), ('\u{1e86}', '\u{1e86}'), ('\u{1e88}',
        '\u{1e88}'), ('\u{1e8a}', '\u{1e8a}'), ('\u{1e8c}', '\u{1e8c}'), ('\u{1e8e}', '\u{1e8e}'),
        ('\u{1e90}', '\u{1e90}'), ('\u{1e92}', '\u{1e92}'), ('\u{1e94}', '\u{1e94}'), ('\u{1e9e}',
        '\u{1e9e}'), ('\u{1ea0}', '\u{1ea0}'), ('\u{1ea2}', '\u{1ea2}'), ('\u{1ea4}', '\u{1ea4}'),
        ('\u{1ea6}', '\u{1ea6}'), ('\u{1ea8}', '\u{1ea8}'), ('\u{1eaa}', '\u{1eaa}'), ('\u{1eac}',
        '\u{1eac}'), ('\u{1eae}', '\u{1eae}'), ('\u{1eb0}', '\u{1eb0}'), ('\u{1eb2}', '\u{1eb2}'),
        ('\u{1eb4}', '\u{1eb4}'), ('\u{1eb6}', '\u{1eb6}'), ('\u{1eb8}', '\u{1eb8}'), ('\u{1eba}',
        '\u{1eba}'), ('\u{1ebc}', '\u{1ebc}'), ('\u{1ebe}', '\u{1ebe}'), ('\u{1ec0}', '\u{1ec0}'),
        ('\u{1ec2}', '\u{1ec2}'), ('\u{1ec4}', '\u{1ec4}'), ('\u{1ec6}', '\u{1ec6}'), ('\u{1ec8}',
        '\u{1ec8}'), ('\u{1eca}', '\u{1eca}'), ('\u{1ecc}', '\u{1ecc}'), ('\u{1ece}', '\u{1ece}'),
        ('\u{1ed0}', '\u{1ed0}'), ('\u{1ed2}', '\u{1ed2}'), ('\u{1ed4}', '\u{1ed4}'), ('\u{1ed6}',
        '\u{1ed6}'), ('\u{1ed8}', '\u{1ed8}'), ('\u{1eda}', '\u{1eda}'), ('\u{1edc}', '\u{1edc}'),
        ('\u{1ede}', '\u{1ede}'), ('\u{1ee0}', '\u{1ee0}'), ('\u{1ee2}', '\u{1ee2}'), ('\u{1ee4}',
        '\u{1ee4}'), ('\u{1ee6}', '\u{1ee6}'), ('\u{1ee8}', '\u{1ee8}'), ('\u{1eea}', '\u{1eea}'),
        ('\u{1eec}', '\u{1eec}'), ('\u{1eee}', '\u{1eee}'), ('\u{1ef0}', '\u{1ef0}'), ('\u{1ef2}',
        '\u{1ef2}'), ('\u{1ef4}', '\u{1ef4}'), ('\u{1ef6}', '\u{1ef6}'), ('\u{1ef8}', '\u{1ef8}'),
        ('\u{1efa}', '\u{1efa}'), ('\u{1efc}', '\u{1efc}'), ('\u{1efe}', '\u{1efe}'), ('\u{1f08}',
        '\u{1f0f}'), ('\u{1f18}', '\u{1f1d}'), ('\u{1f28}', '\u{1f2f}'), ('\u{1f38}', '\u{1f3f}'),
        ('\u{1f48}', '\u{1f4d}'), ('\u{1f59}', '\u{1f59}'), ('\u{1f5b}', '\u{1f5b}'), ('\u{1f5d}',
        '\u{1f5d}'), ('\u{1f5f}', '\u{1f5f}'), ('\u{1f68}', '\u{1f6f}'), ('\u{1fb8}', '\u{1fbb}'),
        ('\u{1fc8}', '\u{1fcb}'), ('\u{1fd8}', '\u{1fdb}'), ('\u{1fe8}', '\u{1fec}'), ('\u{1ff8}',
        '\u{1ffb}'), ('\u{2102}', '\u{2102}'), ('\u{2107}', '\u{2107}'), ('\u{210b}', '\u{210d}'),
        ('\u{2110}', '\u{2112}'), ('\u{2115}', '\u{2115}'), ('\u{2119}', '\u{211d}'), ('\u{2124}',
        '\u{2124}'), ('\u{2126}', '\u{2126}'), ('\u{2128}', '\u{2128}'), ('\u{212a}', '\u{212d}'),
        ('\u{2130}', '\u{2133}'), ('\u{213e}', '\u{213f}'), ('\u{2145}', '\u{2145}'), ('\u{2183}',
        '\u{2183}'), ('\u{2c00}', '\u{2c2e}'), ('\u{2c60}', '\u{2c60}'), ('\u{2c62}', '\u{2c64}'),
        ('\u{2c67}', '\u{2c67}'), ('\u{2c69}', '\u{2c69}'), ('\u{2c6b}', '\u{2c6b}'), ('\u{2c6d}',
        '\u{2c70}'), ('\u{2c72}', '\u{2c72}'), ('\u{2c75}', '\u{2c75}'), ('\u{2c7e}', '\u{2c80}'),
        ('\u{2c82}', '\u{2c82}'), ('\u{2c84}', '\u{2c84}'), ('\u{2c86}', '\u{2c86}'), ('\u{2c88}',
        '\u{2c88}'), ('\u{2c8a}', '\u{2c8a}'), ('\u{2c8c}', '\u{2c8c}'), ('\u{2c8e}', '\u{2c8e}'),
        ('\u{2c90}', '\u{2c90}'), ('\u{2c92}', '\u{2c92}'), ('\u{2c94}', '\u{2c94}'), ('\u{2c96}',
        '\u{2c96}'), ('\u{2c98}', '\u{2c98}'), ('\u{2c9a}', '\u{2c9a}'), ('\u{2c9c}', '\u{2c9c}'),
        ('\u{2c9e}', '\u{2c9e}'), ('\u{2ca0}', '\u{2ca0}'), ('\u{2ca2}', '\u{2ca2}'), ('\u{2ca4}',
        '\u{2ca4}'), ('\u{2ca6}', '\u{2ca6}'), ('\u{2ca8}', '\u{2ca8}'), ('\u{2caa}', '\u{2caa}'),
        ('\u{2cac}', '\u{2cac}'), ('\u{2cae}', '\u{2cae}'), ('\u{2cb0}', '\u{2cb0}'), ('\u{2cb2}',
        '\u{2cb2}'), ('\u{2cb4}', '\u{2cb4}'), ('\u{2cb6}', '\u{2cb6}'), ('\u{2cb8}', '\u{2cb8}'),
        ('\u{2cba}', '\u{2cba}'), ('\u{2cbc}', '\u{2cbc}'), ('\u{2cbe}', '\u{2cbe}'), ('\u{2cc0}',
        '\u{2cc0}'), ('\u{2cc2}', '\u{2cc2}'), ('\u{2cc4}', '\u{2cc4}'), ('\u{2cc6}', '\u{2cc6}'),
        ('\u{2cc8}', '\u{2cc8}'), ('\u{2cca}', '\u{2cca}'), ('\u{2ccc}', '\u{2ccc}'), ('\u{2cce}',
        '\u{2cce}'), ('\u{2cd0}', '\u{2cd0}'), ('\u{2cd2}', '\u{2cd2}'), ('\u{2cd4}', '\u{2cd4}'),
        ('\u{2cd6}', '\u{2cd6}'), ('\u{2cd8}', '\u{2cd8}'), ('\u{2cda}', '\u{2cda}'), ('\u{2cdc}',
        '\u{2cdc}'), ('\u{2cde}', '\u{2cde}'), ('\u{2ce0}', '\u{2ce0}'), ('\u{2ce2}', '\u{2ce2}'),
        ('\u{2ceb}', '\u{2ceb}'), ('\u{2ced}', '\u{2ced}'), ('\u{2cf2}', '\u{2cf2}'), ('\u{a640}',
        '\u{a640}'), ('\u{a642}', '\u{a642}'), ('\u{a644}', '\u{a644}'), ('\u{a646}', '\u{a646}'),
        ('\u{a648}', '\u{a648}'), ('\u{a64a}', '\u{a64a}'), ('\u{a64c}', '\u{a64c}'), ('\u{a64e}',
        '\u{a64e}'), ('\u{a650}', '\u{a650}'), ('\u{a652}', '\u{a652}'), ('\u{a654}', '\u{a654}'),
        ('\u{a656}', '\u{a656}'), ('\u{a658}', '\u{a658}'), ('\u{a65a}', '\u{a65a}'), ('\u{a65c}',
        '\u{a65c}'), ('\u{a65e}', '\u{a65e}'), ('\u{a660}', '\u{a660}'), ('\u{a662}', '\u{a662}'),
        ('\u{a664}', '\u{a664}'), ('\u{a666}', '\u{a666}'), ('\u{a668}', '\u{a668}'), ('\u{a66a}',
        '\u{a66a}'), ('\u{a66c}', '\u{a66c}'), ('\u{a680}', '\u{a680}'), ('\u{a682}', '\u{a682}'),
        ('\u{a684}', '\u{a684}'), ('\u{a686}', '\u{a686}'), ('\u{a688}', '\u{a688}'), ('\u{a68a}',
        '\u{a68a}'), ('\u{a68c}', '\u{a68c}'), ('\u{a68e}', '\u{a68e}'), ('\u{a690}', '\u{a690}'),
        ('\u{a692}', '\u{a692}'), ('\u{a694}', '\u{a694}'), ('\u{a696}', '\u{a696}'), ('\u{a698}',
        '\u{a698}'), ('\u{a69a}', '\u{a69a}'), ('\u{a722}', '\u{a722}'), ('\u{a724}', '\u{a724}'),
        ('\u{a726}', '\u{a726}'), ('\u{a728}', '\u{a728}'), ('\u{a72a}', '\u{a72a}'), ('\u{a72c}',
        '\u{a72c}'), ('\u{a72e}', '\u{a72e}'), ('\u{a732}', '\u{a732}'), ('\u{a734}', '\u{a734}'),
        ('\u{a736}', '\u{a736}'), ('\u{a738}', '\u{a738}'), ('\u{a73a}', '\u{a73a}'), ('\u{a73c}',
        '\u{a73c}'), ('\u{a73e}', '\u{a73e}'), ('\u{a740}', '\u{a740}'), ('\u{a742}', '\u{a742}'),
        ('\u{a744}', '\u{a744}'), ('\u{a746}', '\u{a746}'), ('\u{a748}', '\u{a748}'), ('\u{a74a}',
        '\u{a74a}'), ('\u{a74c}', '\u{a74c}'), ('\u{a74e}', '\u{a74e}'), ('\u{a750}', '\u{a750}'),
        ('\u{a752}', '\u{a752}'), ('\u{a754}', '\u{a754}'), ('\u{a756}', '\u{a756}'), ('\u{a758}',
        '\u{a758}'), ('\u{a75a}', '\u{a75a}'), ('\u{a75c}', '\u{a75c}'), ('\u{a75e}', '\u{a75e}'),
        ('\u{a760}', '\u{a760}'), ('\u{a762}', '\u{a762}'), ('\u{a764}', '\u{a764}'), ('\u{a766}',
        '\u{a766}'), ('\u{a768}', '\u{a768}'), ('\u{a76a}', '\u{a76a}'), ('\u{a76c}', '\u{a76c}'),
        ('\u{a76e}', '\u{a76e}'), ('\u{a779}', '\u{a779}'), ('\u{a77b}', '\u{a77b}'), ('\u{a77d}',
        '\u{a77e}'), ('\u{a780}', '\u{a780}'), ('\u{a782}', '\u{a782}'), ('\u{a784}', '\u{a784}'),
        ('\u{a786}', '\u{a786}'), ('\u{a78b}', '\u{a78b}'), ('\u{a78d}', '\u{a78d}'), ('\u{a790}',
        '\u{a790}'), ('\u{a792}', '\u{a792}'), ('\u{a796}', '\u{a796}'), ('\u{a798}', '\u{a798}'),
        ('\u{a79a}', '\u{a79a}'), ('\u{a79c}', '\u{a79c}'), ('\u{a79e}', '\u{a79e}'), ('\u{a7a0}',
        '\u{a7a0}'), ('\u{a7a2}', '\u{a7a2}'), ('\u{a7a4}', '\u{a7a4}'), ('\u{a7a6}', '\u{a7a6}'),
        ('\u{a7a8}', '\u{a7a8}'), ('\u{a7aa}', '\u{a7ad}'), ('\u{a7b0}', '\u{a7b1}'), ('\u{ff21}',
        '\u{ff3a}'), ('\u{10400}', '\u{10427}'), ('\u{118a0}', '\u{118bf}'), ('\u{1d400}',
        '\u{1d419}'), ('\u{1d434}', '\u{1d44d}'), ('\u{1d468}', '\u{1d481}'), ('\u{1d49c}',
        '\u{1d49c}'), ('\u{1d49e}', '\u{1d49f}'), ('\u{1d4a2}', '\u{1d4a2}'), ('\u{1d4a5}',
        '\u{1d4a6}'), ('\u{1d4a9}', '\u{1d4ac}'), ('\u{1d4ae}', '\u{1d4b5}'), ('\u{1d4d0}',
        '\u{1d4e9}'), ('\u{1d504}', '\u{1d505}'), ('\u{1d507}', '\u{1d50a}'), ('\u{1d50d}',
        '\u{1d514}'), ('\u{1d516}', '\u{1d51c}'), ('\u{1d538}', '\u{1d539}'), ('\u{1d53b}',
        '\u{1d53e}'), ('\u{1d540}', '\u{1d544}'), ('\u{1d546}', '\u{1d546}'), ('\u{1d54a}',
        '\u{1d550}'), ('\u{1d56c}', '\u{1d585}'), ('\u{1d5a0}', '\u{1d5b9}'), ('\u{1d5d4}',
        '\u{1d5ed}'), ('\u{1d608}', '\u{1d621}'), ('\u{1d63c}', '\u{1d655}'), ('\u{1d670}',
        '\u{1d689}'), ('\u{1d6a8}', '\u{1d6c0}'), ('\u{1d6e2}', '\u{1d6fa}'), ('\u{1d71c}',
        '\u{1d734}'), ('\u{1d756}', '\u{1d76e}'), ('\u{1d790}', '\u{1d7a8}'), ('\u{1d7ca}',
        '\u{1d7ca}')
    ];

    pub static M_table: &'static [(char, char)] = &[
        ('\u{300}', '\u{36f}'), ('\u{483}', '\u{489}'), ('\u{591}', '\u{5bd}'), ('\u{5bf}',
        '\u{5bf}'), ('\u{5c1}', '\u{5c2}'), ('\u{5c4}', '\u{5c5}'), ('\u{5c7}', '\u{5c7}'),
        ('\u{610}', '\u{61a}'), ('\u{64b}', '\u{65f}'), ('\u{670}', '\u{670}'), ('\u{6d6}',
        '\u{6dc}'), ('\u{6df}', '\u{6e4}'), ('\u{6e7}', '\u{6e8}'), ('\u{6ea}', '\u{6ed}'),
        ('\u{711}', '\u{711}'), ('\u{730}', '\u{74a}'), ('\u{7a6}', '\u{7b0}'), ('\u{7eb}',
        '\u{7f3}'), ('\u{816}', '\u{819}'), ('\u{81b}', '\u{823}'), ('\u{825}', '\u{827}'),
        ('\u{829}', '\u{82d}'), ('\u{859}', '\u{85b}'), ('\u{8e4}', '\u{903}'), ('\u{93a}',
        '\u{93c}'), ('\u{93e}', '\u{94f}'), ('\u{951}', '\u{957}'), ('\u{962}', '\u{963}'),
        ('\u{981}', '\u{983}'), ('\u{9bc}', '\u{9bc}'), ('\u{9be}', '\u{9c4}'), ('\u{9c7}',
        '\u{9c8}'), ('\u{9cb}', '\u{9cd}'), ('\u{9d7}', '\u{9d7}'), ('\u{9e2}', '\u{9e3}'),
        ('\u{a01}', '\u{a03}'), ('\u{a3c}', '\u{a3c}'), ('\u{a3e}', '\u{a42}'), ('\u{a47}',
        '\u{a48}'), ('\u{a4b}', '\u{a4d}'), ('\u{a51}', '\u{a51}'), ('\u{a70}', '\u{a71}'),
        ('\u{a75}', '\u{a75}'), ('\u{a81}', '\u{a83}'), ('\u{abc}', '\u{abc}'), ('\u{abe}',
        '\u{ac5}'), ('\u{ac7}', '\u{ac9}'), ('\u{acb}', '\u{acd}'), ('\u{ae2}', '\u{ae3}'),
        ('\u{b01}', '\u{b03}'), ('\u{b3c}', '\u{b3c}'), ('\u{b3e}', '\u{b44}'), ('\u{b47}',
        '\u{b48}'), ('\u{b4b}', '\u{b4d}'), ('\u{b56}', '\u{b57}'), ('\u{b62}', '\u{b63}'),
        ('\u{b82}', '\u{b82}'), ('\u{bbe}', '\u{bc2}'), ('\u{bc6}', '\u{bc8}'), ('\u{bca}',
        '\u{bcd}'), ('\u{bd7}', '\u{bd7}'), ('\u{c00}', '\u{c03}'), ('\u{c3e}', '\u{c44}'),
        ('\u{c46}', '\u{c48}'), ('\u{c4a}', '\u{c4d}'), ('\u{c55}', '\u{c56}'), ('\u{c62}',
        '\u{c63}'), ('\u{c81}', '\u{c83}'), ('\u{cbc}', '\u{cbc}'), ('\u{cbe}', '\u{cc4}'),
        ('\u{cc6}', '\u{cc8}'), ('\u{cca}', '\u{ccd}'), ('\u{cd5}', '\u{cd6}'), ('\u{ce2}',
        '\u{ce3}'), ('\u{d01}', '\u{d03}'), ('\u{d3e}', '\u{d44}'), ('\u{d46}', '\u{d48}'),
        ('\u{d4a}', '\u{d4d}'), ('\u{d57}', '\u{d57}'), ('\u{d62}', '\u{d63}'), ('\u{d82}',
        '\u{d83}'), ('\u{dca}', '\u{dca}'), ('\u{dcf}', '\u{dd4}'), ('\u{dd6}', '\u{dd6}'),
        ('\u{dd8}', '\u{ddf}'), ('\u{df2}', '\u{df3}'), ('\u{e31}', '\u{e31}'), ('\u{e34}',
        '\u{e3a}'), ('\u{e47}', '\u{e4e}'), ('\u{eb1}', '\u{eb1}'), ('\u{eb4}', '\u{eb9}'),
        ('\u{ebb}', '\u{ebc}'), ('\u{ec8}', '\u{ecd}'), ('\u{f18}', '\u{f19}'), ('\u{f35}',
        '\u{f35}'), ('\u{f37}', '\u{f37}'), ('\u{f39}', '\u{f39}'), ('\u{f3e}', '\u{f3f}'),
        ('\u{f71}', '\u{f84}'), ('\u{f86}', '\u{f87}'), ('\u{f8d}', '\u{f97}'), ('\u{f99}',
        '\u{fbc}'), ('\u{fc6}', '\u{fc6}'), ('\u{102b}', '\u{103e}'), ('\u{1056}', '\u{1059}'),
        ('\u{105e}', '\u{1060}'), ('\u{1062}', '\u{1064}'), ('\u{1067}', '\u{106d}'), ('\u{1071}',
        '\u{1074}'), ('\u{1082}', '\u{108d}'), ('\u{108f}', '\u{108f}'), ('\u{109a}', '\u{109d}'),
        ('\u{135d}', '\u{135f}'), ('\u{1712}', '\u{1714}'), ('\u{1732}', '\u{1734}'), ('\u{1752}',
        '\u{1753}'), ('\u{1772}', '\u{1773}'), ('\u{17b4}', '\u{17d3}'), ('\u{17dd}', '\u{17dd}'),
        ('\u{180b}', '\u{180d}'), ('\u{18a9}', '\u{18a9}'), ('\u{1920}', '\u{192b}'), ('\u{1930}',
        '\u{193b}'), ('\u{19b0}', '\u{19c0}'), ('\u{19c8}', '\u{19c9}'), ('\u{1a17}', '\u{1a1b}'),
        ('\u{1a55}', '\u{1a5e}'), ('\u{1a60}', '\u{1a7c}'), ('\u{1a7f}', '\u{1a7f}'), ('\u{1ab0}',
        '\u{1abe}'), ('\u{1b00}', '\u{1b04}'), ('\u{1b34}', '\u{1b44}'), ('\u{1b6b}', '\u{1b73}'),
        ('\u{1b80}', '\u{1b82}'), ('\u{1ba1}', '\u{1bad}'), ('\u{1be6}', '\u{1bf3}'), ('\u{1c24}',
        '\u{1c37}'), ('\u{1cd0}', '\u{1cd2}'), ('\u{1cd4}', '\u{1ce8}'), ('\u{1ced}', '\u{1ced}'),
        ('\u{1cf2}', '\u{1cf4}'), ('\u{1cf8}', '\u{1cf9}'), ('\u{1dc0}', '\u{1df5}'), ('\u{1dfc}',
        '\u{1dff}'), ('\u{20d0}', '\u{20f0}'), ('\u{2cef}', '\u{2cf1}'), ('\u{2d7f}', '\u{2d7f}'),
        ('\u{2de0}', '\u{2dff}'), ('\u{302a}', '\u{302f}'), ('\u{3099}', '\u{309a}'), ('\u{a66f}',
        '\u{a672}'), ('\u{a674}', '\u{a67d}'), ('\u{a69f}', '\u{a69f}'), ('\u{a6f0}', '\u{a6f1}'),
        ('\u{a802}', '\u{a802}'), ('\u{a806}', '\u{a806}'), ('\u{a80b}', '\u{a80b}'), ('\u{a823}',
        '\u{a827}'), ('\u{a880}', '\u{a881}'), ('\u{a8b4}', '\u{a8c4}'), ('\u{a8e0}', '\u{a8f1}'),
        ('\u{a926}', '\u{a92d}'), ('\u{a947}', '\u{a953}'), ('\u{a980}', '\u{a983}'), ('\u{a9b3}',
        '\u{a9c0}'), ('\u{a9e5}', '\u{a9e5}'), ('\u{aa29}', '\u{aa36}'), ('\u{aa43}', '\u{aa43}'),
        ('\u{aa4c}', '\u{aa4d}'), ('\u{aa7b}', '\u{aa7d}'), ('\u{aab0}', '\u{aab0}'), ('\u{aab2}',
        '\u{aab4}'), ('\u{aab7}', '\u{aab8}'), ('\u{aabe}', '\u{aabf}'), ('\u{aac1}', '\u{aac1}'),
        ('\u{aaeb}', '\u{aaef}'), ('\u{aaf5}', '\u{aaf6}'), ('\u{abe3}', '\u{abea}'), ('\u{abec}',
        '\u{abed}'), ('\u{fb1e}', '\u{fb1e}'), ('\u{fe00}', '\u{fe0f}'), ('\u{fe20}', '\u{fe2d}'),
        ('\u{101fd}', '\u{101fd}'), ('\u{102e0}', '\u{102e0}'), ('\u{10376}', '\u{1037a}'),
        ('\u{10a01}', '\u{10a03}'), ('\u{10a05}', '\u{10a06}'), ('\u{10a0c}', '\u{10a0f}'),
        ('\u{10a38}', '\u{10a3a}'), ('\u{10a3f}', '\u{10a3f}'), ('\u{10ae5}', '\u{10ae6}'),
        ('\u{11000}', '\u{11002}'), ('\u{11038}', '\u{11046}'), ('\u{1107f}', '\u{11082}'),
        ('\u{110b0}', '\u{110ba}'), ('\u{11100}', '\u{11102}'), ('\u{11127}', '\u{11134}'),
        ('\u{11173}', '\u{11173}'), ('\u{11180}', '\u{11182}'), ('\u{111b3}', '\u{111c0}'),
        ('\u{1122c}', '\u{11237}'), ('\u{112df}', '\u{112ea}'), ('\u{11301}', '\u{11303}'),
        ('\u{1133c}', '\u{1133c}'), ('\u{1133e}', '\u{11344}'), ('\u{11347}', '\u{11348}'),
        ('\u{1134b}', '\u{1134d}'), ('\u{11357}', '\u{11357}'), ('\u{11362}', '\u{11363}'),
        ('\u{11366}', '\u{1136c}'), ('\u{11370}', '\u{11374}'), ('\u{114b0}', '\u{114c3}'),
        ('\u{115af}', '\u{115b5}'), ('\u{115b8}', '\u{115c0}'), ('\u{11630}', '\u{11640}'),
        ('\u{116ab}', '\u{116b7}'), ('\u{16af0}', '\u{16af4}'), ('\u{16b30}', '\u{16b36}'),
        ('\u{16f51}', '\u{16f7e}'), ('\u{16f8f}', '\u{16f92}'), ('\u{1bc9d}', '\u{1bc9e}'),
        ('\u{1d165}', '\u{1d169}'), ('\u{1d16d}', '\u{1d172}'), ('\u{1d17b}', '\u{1d182}'),
        ('\u{1d185}', '\u{1d18b}'), ('\u{1d1aa}', '\u{1d1ad}'), ('\u{1d242}', '\u{1d244}'),
        ('\u{1e8d0}', '\u{1e8d6}'), ('\u{e0100}', '\u{e01ef}')
    ];

    pub static Mc_table: &'static [(char, char)] = &[
        ('\u{903}', '\u{903}'), ('\u{93b}', '\u{93b}'), ('\u{93e}', '\u{940}'), ('\u{949}',
        '\u{94c}'), ('\u{94e}', '\u{94f}'), ('\u{982}', '\u{983}'), ('\u{9be}', '\u{9c0}'),
        ('\u{9c7}', '\u{9c8}'), ('\u{9cb}', '\u{9cc}'), ('\u{9d7}', '\u{9d7}'), ('\u{a03}',
        '\u{a03}'), ('\u{a3e}', '\u{a40}'), ('\u{a83}', '\u{a83}'), ('\u{abe}', '\u{ac0}'),
        ('\u{ac9}', '\u{ac9}'), ('\u{acb}', '\u{acc}'), ('\u{b02}', '\u{b03}'), ('\u{b3e}',
        '\u{b3e}'), ('\u{b40}', '\u{b40}'), ('\u{b47}', '\u{b48}'), ('\u{b4b}', '\u{b4c}'),
        ('\u{b57}', '\u{b57}'), ('\u{bbe}', '\u{bbf}'), ('\u{bc1}', '\u{bc2}'), ('\u{bc6}',
        '\u{bc8}'), ('\u{bca}', '\u{bcc}'), ('\u{bd7}', '\u{bd7}'), ('\u{c01}', '\u{c03}'),
        ('\u{c41}', '\u{c44}'), ('\u{c82}', '\u{c83}'), ('\u{cbe}', '\u{cbe}'), ('\u{cc0}',
        '\u{cc4}'), ('\u{cc7}', '\u{cc8}'), ('\u{cca}', '\u{ccb}'), ('\u{cd5}', '\u{cd6}'),
        ('\u{d02}', '\u{d03}'), ('\u{d3e}', '\u{d40}'), ('\u{d46}', '\u{d48}'), ('\u{d4a}',
        '\u{d4c}'), ('\u{d57}', '\u{d57}'), ('\u{d82}', '\u{d83}'), ('\u{dcf}', '\u{dd1}'),
        ('\u{dd8}', '\u{ddf}'), ('\u{df2}', '\u{df3}'), ('\u{f3e}', '\u{f3f}'), ('\u{f7f}',
        '\u{f7f}'), ('\u{102b}', '\u{102c}'), ('\u{1031}', '\u{1031}'), ('\u{1038}', '\u{1038}'),
        ('\u{103b}', '\u{103c}'), ('\u{1056}', '\u{1057}'), ('\u{1062}', '\u{1064}'), ('\u{1067}',
        '\u{106d}'), ('\u{1083}', '\u{1084}'), ('\u{1087}', '\u{108c}'), ('\u{108f}', '\u{108f}'),
        ('\u{109a}', '\u{109c}'), ('\u{17b6}', '\u{17b6}'), ('\u{17be}', '\u{17c5}'), ('\u{17c7}',
        '\u{17c8}'), ('\u{1923}', '\u{1926}'), ('\u{1929}', '\u{192b}'), ('\u{1930}', '\u{1931}'),
        ('\u{1933}', '\u{1938}'), ('\u{19b0}', '\u{19c0}'), ('\u{19c8}', '\u{19c9}'), ('\u{1a19}',
        '\u{1a1a}'), ('\u{1a55}', '\u{1a55}'), ('\u{1a57}', '\u{1a57}'), ('\u{1a61}', '\u{1a61}'),
        ('\u{1a63}', '\u{1a64}'), ('\u{1a6d}', '\u{1a72}'), ('\u{1b04}', '\u{1b04}'), ('\u{1b35}',
        '\u{1b35}'), ('\u{1b3b}', '\u{1b3b}'), ('\u{1b3d}', '\u{1b41}'), ('\u{1b43}', '\u{1b44}'),
        ('\u{1b82}', '\u{1b82}'), ('\u{1ba1}', '\u{1ba1}'), ('\u{1ba6}', '\u{1ba7}'), ('\u{1baa}',
        '\u{1baa}'), ('\u{1be7}', '\u{1be7}'), ('\u{1bea}', '\u{1bec}'), ('\u{1bee}', '\u{1bee}'),
        ('\u{1bf2}', '\u{1bf3}'), ('\u{1c24}', '\u{1c2b}'), ('\u{1c34}', '\u{1c35}'), ('\u{1ce1}',
        '\u{1ce1}'), ('\u{1cf2}', '\u{1cf3}'), ('\u{302e}', '\u{302f}'), ('\u{a823}', '\u{a824}'),
        ('\u{a827}', '\u{a827}'), ('\u{a880}', '\u{a881}'), ('\u{a8b4}', '\u{a8c3}'), ('\u{a952}',
        '\u{a953}'), ('\u{a983}', '\u{a983}'), ('\u{a9b4}', '\u{a9b5}'), ('\u{a9ba}', '\u{a9bb}'),
        ('\u{a9bd}', '\u{a9c0}'), ('\u{aa2f}', '\u{aa30}'), ('\u{aa33}', '\u{aa34}'), ('\u{aa4d}',
        '\u{aa4d}'), ('\u{aa7b}', '\u{aa7b}'), ('\u{aa7d}', '\u{aa7d}'), ('\u{aaeb}', '\u{aaeb}'),
        ('\u{aaee}', '\u{aaef}'), ('\u{aaf5}', '\u{aaf5}'), ('\u{abe3}', '\u{abe4}'), ('\u{abe6}',
        '\u{abe7}'), ('\u{abe9}', '\u{abea}'), ('\u{abec}', '\u{abec}'), ('\u{11000}', '\u{11000}'),
        ('\u{11002}', '\u{11002}'), ('\u{11082}', '\u{11082}'), ('\u{110b0}', '\u{110b2}'),
        ('\u{110b7}', '\u{110b8}'), ('\u{1112c}', '\u{1112c}'), ('\u{11182}', '\u{11182}'),
        ('\u{111b3}', '\u{111b5}'), ('\u{111bf}', '\u{111c0}'), ('\u{1122c}', '\u{1122e}'),
        ('\u{11232}', '\u{11233}'), ('\u{11235}', '\u{11235}'), ('\u{112e0}', '\u{112e2}'),
        ('\u{11302}', '\u{11303}'), ('\u{1133e}', '\u{1133f}'), ('\u{11341}', '\u{11344}'),
        ('\u{11347}', '\u{11348}'), ('\u{1134b}', '\u{1134d}'), ('\u{11357}', '\u{11357}'),
        ('\u{11362}', '\u{11363}'), ('\u{114b0}', '\u{114b2}'), ('\u{114b9}', '\u{114b9}'),
        ('\u{114bb}', '\u{114be}'), ('\u{114c1}', '\u{114c1}'), ('\u{115af}', '\u{115b1}'),
        ('\u{115b8}', '\u{115bb}'), ('\u{115be}', '\u{115be}'), ('\u{11630}', '\u{11632}'),
        ('\u{1163b}', '\u{1163c}'), ('\u{1163e}', '\u{1163e}'), ('\u{116ac}', '\u{116ac}'),
        ('\u{116ae}', '\u{116af}'), ('\u{116b6}', '\u{116b6}'), ('\u{16f51}', '\u{16f7e}'),
        ('\u{1d165}', '\u{1d166}'), ('\u{1d16d}', '\u{1d172}')
    ];

    pub static Me_table: &'static [(char, char)] = &[
        ('\u{488}', '\u{489}'), ('\u{1abe}', '\u{1abe}'), ('\u{20dd}', '\u{20e0}'), ('\u{20e2}',
        '\u{20e4}'), ('\u{a670}', '\u{a672}')
    ];

    pub static Mn_table: &'static [(char, char)] = &[
        ('\u{300}', '\u{36f}'), ('\u{483}', '\u{487}'), ('\u{591}', '\u{5bd}'), ('\u{5bf}',
        '\u{5bf}'), ('\u{5c1}', '\u{5c2}'), ('\u{5c4}', '\u{5c5}'), ('\u{5c7}', '\u{5c7}'),
        ('\u{610}', '\u{61a}'), ('\u{64b}', '\u{65f}'), ('\u{670}', '\u{670}'), ('\u{6d6}',
        '\u{6dc}'), ('\u{6df}', '\u{6e4}'), ('\u{6e7}', '\u{6e8}'), ('\u{6ea}', '\u{6ed}'),
        ('\u{711}', '\u{711}'), ('\u{730}', '\u{74a}'), ('\u{7a6}', '\u{7b0}'), ('\u{7eb}',
        '\u{7f3}'), ('\u{816}', '\u{819}'), ('\u{81b}', '\u{823}'), ('\u{825}', '\u{827}'),
        ('\u{829}', '\u{82d}'), ('\u{859}', '\u{85b}'), ('\u{8e4}', '\u{902}'), ('\u{93a}',
        '\u{93a}'), ('\u{93c}', '\u{93c}'), ('\u{941}', '\u{948}'), ('\u{94d}', '\u{94d}'),
        ('\u{951}', '\u{957}'), ('\u{962}', '\u{963}'), ('\u{981}', '\u{981}'), ('\u{9bc}',
        '\u{9bc}'), ('\u{9c1}', '\u{9c4}'), ('\u{9cd}', '\u{9cd}'), ('\u{9e2}', '\u{9e3}'),
        ('\u{a01}', '\u{a02}'), ('\u{a3c}', '\u{a3c}'), ('\u{a41}', '\u{a42}'), ('\u{a47}',
        '\u{a48}'), ('\u{a4b}', '\u{a4d}'), ('\u{a51}', '\u{a51}'), ('\u{a70}', '\u{a71}'),
        ('\u{a75}', '\u{a75}'), ('\u{a81}', '\u{a82}'), ('\u{abc}', '\u{abc}'), ('\u{ac1}',
        '\u{ac5}'), ('\u{ac7}', '\u{ac8}'), ('\u{acd}', '\u{acd}'), ('\u{ae2}', '\u{ae3}'),
        ('\u{b01}', '\u{b01}'), ('\u{b3c}', '\u{b3c}'), ('\u{b3f}', '\u{b3f}'), ('\u{b41}',
        '\u{b44}'), ('\u{b4d}', '\u{b4d}'), ('\u{b56}', '\u{b56}'), ('\u{b62}', '\u{b63}'),
        ('\u{b82}', '\u{b82}'), ('\u{bc0}', '\u{bc0}'), ('\u{bcd}', '\u{bcd}'), ('\u{c00}',
        '\u{c00}'), ('\u{c3e}', '\u{c40}'), ('\u{c46}', '\u{c48}'), ('\u{c4a}', '\u{c4d}'),
        ('\u{c55}', '\u{c56}'), ('\u{c62}', '\u{c63}'), ('\u{c81}', '\u{c81}'), ('\u{cbc}',
        '\u{cbc}'), ('\u{cbf}', '\u{cbf}'), ('\u{cc6}', '\u{cc6}'), ('\u{ccc}', '\u{ccd}'),
        ('\u{ce2}', '\u{ce3}'), ('\u{d01}', '\u{d01}'), ('\u{d41}', '\u{d44}'), ('\u{d4d}',
        '\u{d4d}'), ('\u{d62}', '\u{d63}'), ('\u{dca}', '\u{dca}'), ('\u{dd2}', '\u{dd4}'),
        ('\u{dd6}', '\u{dd6}'), ('\u{e31}', '\u{e31}'), ('\u{e34}', '\u{e3a}'), ('\u{e47}',
        '\u{e4e}'), ('\u{eb1}', '\u{eb1}'), ('\u{eb4}', '\u{eb9}'), ('\u{ebb}', '\u{ebc}'),
        ('\u{ec8}', '\u{ecd}'), ('\u{f18}', '\u{f19}'), ('\u{f35}', '\u{f35}'), ('\u{f37}',
        '\u{f37}'), ('\u{f39}', '\u{f39}'), ('\u{f71}', '\u{f7e}'), ('\u{f80}', '\u{f84}'),
        ('\u{f86}', '\u{f87}'), ('\u{f8d}', '\u{f97}'), ('\u{f99}', '\u{fbc}'), ('\u{fc6}',
        '\u{fc6}'), ('\u{102d}', '\u{1030}'), ('\u{1032}', '\u{1037}'), ('\u{1039}', '\u{103a}'),
        ('\u{103d}', '\u{103e}'), ('\u{1058}', '\u{1059}'), ('\u{105e}', '\u{1060}'), ('\u{1071}',
        '\u{1074}'), ('\u{1082}', '\u{1082}'), ('\u{1085}', '\u{1086}'), ('\u{108d}', '\u{108d}'),
        ('\u{109d}', '\u{109d}'), ('\u{135d}', '\u{135f}'), ('\u{1712}', '\u{1714}'), ('\u{1732}',
        '\u{1734}'), ('\u{1752}', '\u{1753}'), ('\u{1772}', '\u{1773}'), ('\u{17b4}', '\u{17b5}'),
        ('\u{17b7}', '\u{17bd}'), ('\u{17c6}', '\u{17c6}'), ('\u{17c9}', '\u{17d3}'), ('\u{17dd}',
        '\u{17dd}'), ('\u{180b}', '\u{180d}'), ('\u{18a9}', '\u{18a9}'), ('\u{1920}', '\u{1922}'),
        ('\u{1927}', '\u{1928}'), ('\u{1932}', '\u{1932}'), ('\u{1939}', '\u{193b}'), ('\u{1a17}',
        '\u{1a18}'), ('\u{1a1b}', '\u{1a1b}'), ('\u{1a56}', '\u{1a56}'), ('\u{1a58}', '\u{1a5e}'),
        ('\u{1a60}', '\u{1a60}'), ('\u{1a62}', '\u{1a62}'), ('\u{1a65}', '\u{1a6c}'), ('\u{1a73}',
        '\u{1a7c}'), ('\u{1a7f}', '\u{1a7f}'), ('\u{1ab0}', '\u{1abd}'), ('\u{1b00}', '\u{1b03}'),
        ('\u{1b34}', '\u{1b34}'), ('\u{1b36}', '\u{1b3a}'), ('\u{1b3c}', '\u{1b3c}'), ('\u{1b42}',
        '\u{1b42}'), ('\u{1b6b}', '\u{1b73}'), ('\u{1b80}', '\u{1b81}'), ('\u{1ba2}', '\u{1ba5}'),
        ('\u{1ba8}', '\u{1ba9}'), ('\u{1bab}', '\u{1bad}'), ('\u{1be6}', '\u{1be6}'), ('\u{1be8}',
        '\u{1be9}'), ('\u{1bed}', '\u{1bed}'), ('\u{1bef}', '\u{1bf1}'), ('\u{1c2c}', '\u{1c33}'),
        ('\u{1c36}', '\u{1c37}'), ('\u{1cd0}', '\u{1cd2}'), ('\u{1cd4}', '\u{1ce0}'), ('\u{1ce2}',
        '\u{1ce8}'), ('\u{1ced}', '\u{1ced}'), ('\u{1cf4}', '\u{1cf4}'), ('\u{1cf8}', '\u{1cf9}'),
        ('\u{1dc0}', '\u{1df5}'), ('\u{1dfc}', '\u{1dff}'), ('\u{20d0}', '\u{20dc}'), ('\u{20e1}',
        '\u{20e1}'), ('\u{20e5}', '\u{20f0}'), ('\u{2cef}', '\u{2cf1}'), ('\u{2d7f}', '\u{2d7f}'),
        ('\u{2de0}', '\u{2dff}'), ('\u{302a}', '\u{302d}'), ('\u{3099}', '\u{309a}'), ('\u{a66f}',
        '\u{a66f}'), ('\u{a674}', '\u{a67d}'), ('\u{a69f}', '\u{a69f}'), ('\u{a6f0}', '\u{a6f1}'),
        ('\u{a802}', '\u{a802}'), ('\u{a806}', '\u{a806}'), ('\u{a80b}', '\u{a80b}'), ('\u{a825}',
        '\u{a826}'), ('\u{a8c4}', '\u{a8c4}'), ('\u{a8e0}', '\u{a8f1}'), ('\u{a926}', '\u{a92d}'),
        ('\u{a947}', '\u{a951}'), ('\u{a980}', '\u{a982}'), ('\u{a9b3}', '\u{a9b3}'), ('\u{a9b6}',
        '\u{a9b9}'), ('\u{a9bc}', '\u{a9bc}'), ('\u{a9e5}', '\u{a9e5}'), ('\u{aa29}', '\u{aa2e}'),
        ('\u{aa31}', '\u{aa32}'), ('\u{aa35}', '\u{aa36}'), ('\u{aa43}', '\u{aa43}'), ('\u{aa4c}',
        '\u{aa4c}'), ('\u{aa7c}', '\u{aa7c}'), ('\u{aab0}', '\u{aab0}'), ('\u{aab2}', '\u{aab4}'),
        ('\u{aab7}', '\u{aab8}'), ('\u{aabe}', '\u{aabf}'), ('\u{aac1}', '\u{aac1}'), ('\u{aaec}',
        '\u{aaed}'), ('\u{aaf6}', '\u{aaf6}'), ('\u{abe5}', '\u{abe5}'), ('\u{abe8}', '\u{abe8}'),
        ('\u{abed}', '\u{abed}'), ('\u{fb1e}', '\u{fb1e}'), ('\u{fe00}', '\u{fe0f}'), ('\u{fe20}',
        '\u{fe2d}'), ('\u{101fd}', '\u{101fd}'), ('\u{102e0}', '\u{102e0}'), ('\u{10376}',
        '\u{1037a}'), ('\u{10a01}', '\u{10a03}'), ('\u{10a05}', '\u{10a06}'), ('\u{10a0c}',
        '\u{10a0f}'), ('\u{10a38}', '\u{10a3a}'), ('\u{10a3f}', '\u{10a3f}'), ('\u{10ae5}',
        '\u{10ae6}'), ('\u{11001}', '\u{11001}'), ('\u{11038}', '\u{11046}'), ('\u{1107f}',
        '\u{11081}'), ('\u{110b3}', '\u{110b6}'), ('\u{110b9}', '\u{110ba}'), ('\u{11100}',
        '\u{11102}'), ('\u{11127}', '\u{1112b}'), ('\u{1112d}', '\u{11134}'), ('\u{11173}',
        '\u{11173}'), ('\u{11180}', '\u{11181}'), ('\u{111b6}', '\u{111be}'), ('\u{1122f}',
        '\u{11231}'), ('\u{11234}', '\u{11234}'), ('\u{11236}', '\u{11237}'), ('\u{112df}',
        '\u{112df}'), ('\u{112e3}', '\u{112ea}'), ('\u{11301}', '\u{11301}'), ('\u{1133c}',
        '\u{1133c}'), ('\u{11340}', '\u{11340}'), ('\u{11366}', '\u{1136c}'), ('\u{11370}',
        '\u{11374}'), ('\u{114b3}', '\u{114b8}'), ('\u{114ba}', '\u{114ba}'), ('\u{114bf}',
        '\u{114c0}'), ('\u{114c2}', '\u{114c3}'), ('\u{115b2}', '\u{115b5}'), ('\u{115bc}',
        '\u{115bd}'), ('\u{115bf}', '\u{115c0}'), ('\u{11633}', '\u{1163a}'), ('\u{1163d}',
        '\u{1163d}'), ('\u{1163f}', '\u{11640}'), ('\u{116ab}', '\u{116ab}'), ('\u{116ad}',
        '\u{116ad}'), ('\u{116b0}', '\u{116b5}'), ('\u{116b7}', '\u{116b7}'), ('\u{16af0}',
        '\u{16af4}'), ('\u{16b30}', '\u{16b36}'), ('\u{16f8f}', '\u{16f92}'), ('\u{1bc9d}',
        '\u{1bc9e}'), ('\u{1d167}', '\u{1d169}'), ('\u{1d17b}', '\u{1d182}'), ('\u{1d185}',
        '\u{1d18b}'), ('\u{1d1aa}', '\u{1d1ad}'), ('\u{1d242}', '\u{1d244}'), ('\u{1e8d0}',
        '\u{1e8d6}'), ('\u{e0100}', '\u{e01ef}')
    ];

    pub static N_table: &'static [(char, char)] = &[
        ('\u{30}', '\u{39}'), ('\u{660}', '\u{669}'), ('\u{6f0}', '\u{6f9}'), ('\u{7c0}',
        '\u{7c9}'), ('\u{966}', '\u{96f}'), ('\u{9e6}', '\u{9ef}'), ('\u{a66}', '\u{a6f}'),
        ('\u{ae6}', '\u{aef}'), ('\u{b66}', '\u{b6f}'), ('\u{be6}', '\u{bef}'), ('\u{c66}',
        '\u{c6f}'), ('\u{ce6}', '\u{cef}'), ('\u{d66}', '\u{d6f}'), ('\u{de6}', '\u{def}'),
        ('\u{e50}', '\u{e59}'), ('\u{ed0}', '\u{ed9}'), ('\u{f20}', '\u{f29}'), ('\u{1040}',
        '\u{1049}'), ('\u{1090}', '\u{1099}'), ('\u{16ee}', '\u{16f0}'), ('\u{17e0}', '\u{17e9}'),
        ('\u{1810}', '\u{1819}'), ('\u{1946}', '\u{194f}'), ('\u{19d0}', '\u{19d9}'), ('\u{1a80}',
        '\u{1a89}'), ('\u{1a90}', '\u{1a99}'), ('\u{1b50}', '\u{1b59}'), ('\u{1bb0}', '\u{1bb9}'),
        ('\u{1c40}', '\u{1c49}'), ('\u{1c50}', '\u{1c59}'), ('\u{2160}', '\u{2182}'), ('\u{2185}',
        '\u{2188}'), ('\u{3007}', '\u{3007}'), ('\u{3021}', '\u{3029}'), ('\u{3038}', '\u{303a}'),
        ('\u{a620}', '\u{a629}'), ('\u{a6e6}', '\u{a6ef}'), ('\u{a8d0}', '\u{a8d9}'), ('\u{a900}',
        '\u{a909}'), ('\u{a9d0}', '\u{a9d9}'), ('\u{a9f0}', '\u{a9f9}'), ('\u{aa50}', '\u{aa59}'),
        ('\u{abf0}', '\u{abf9}'), ('\u{ff10}', '\u{ff19}'), ('\u{10140}', '\u{10174}'),
        ('\u{10341}', '\u{10341}'), ('\u{1034a}', '\u{1034a}'), ('\u{103d1}', '\u{103d5}'),
        ('\u{104a0}', '\u{104a9}'), ('\u{11066}', '\u{1106f}'), ('\u{110f0}', '\u{110f9}'),
        ('\u{11136}', '\u{1113f}'), ('\u{111d0}', '\u{111d9}'), ('\u{112f0}', '\u{112f9}'),
        ('\u{114d0}', '\u{114d9}'), ('\u{11650}', '\u{11659}'), ('\u{116c0}', '\u{116c9}'),
        ('\u{118e0}', '\u{118e9}'), ('\u{12400}', '\u{1246e}'), ('\u{16a60}', '\u{16a69}'),
        ('\u{16b50}', '\u{16b59}'), ('\u{1d7ce}', '\u{1d7ff}')
    ];

    pub fn N(c: char) -> bool {
        super::bsearch_range_table(c, N_table)
    }

    pub static Nd_table: &'static [(char, char)] = &[
        ('\u{30}', '\u{39}'), ('\u{660}', '\u{669}'), ('\u{6f0}', '\u{6f9}'), ('\u{7c0}',
        '\u{7c9}'), ('\u{966}', '\u{96f}'), ('\u{9e6}', '\u{9ef}'), ('\u{a66}', '\u{a6f}'),
        ('\u{ae6}', '\u{aef}'), ('\u{b66}', '\u{b6f}'), ('\u{be6}', '\u{bef}'), ('\u{c66}',
        '\u{c6f}'), ('\u{ce6}', '\u{cef}'), ('\u{d66}', '\u{d6f}'), ('\u{de6}', '\u{def}'),
        ('\u{e50}', '\u{e59}'), ('\u{ed0}', '\u{ed9}'), ('\u{f20}', '\u{f29}'), ('\u{1040}',
        '\u{1049}'), ('\u{1090}', '\u{1099}'), ('\u{17e0}', '\u{17e9}'), ('\u{1810}', '\u{1819}'),
        ('\u{1946}', '\u{194f}'), ('\u{19d0}', '\u{19d9}'), ('\u{1a80}', '\u{1a89}'), ('\u{1a90}',
        '\u{1a99}'), ('\u{1b50}', '\u{1b59}'), ('\u{1bb0}', '\u{1bb9}'), ('\u{1c40}', '\u{1c49}'),
        ('\u{1c50}', '\u{1c59}'), ('\u{a620}', '\u{a629}'), ('\u{a8d0}', '\u{a8d9}'), ('\u{a900}',
        '\u{a909}'), ('\u{a9d0}', '\u{a9d9}'), ('\u{a9f0}', '\u{a9f9}'), ('\u{aa50}', '\u{aa59}'),
        ('\u{abf0}', '\u{abf9}'), ('\u{ff10}', '\u{ff19}'), ('\u{104a0}', '\u{104a9}'),
        ('\u{11066}', '\u{1106f}'), ('\u{110f0}', '\u{110f9}'), ('\u{11136}', '\u{1113f}'),
        ('\u{111d0}', '\u{111d9}'), ('\u{112f0}', '\u{112f9}'), ('\u{114d0}', '\u{114d9}'),
        ('\u{11650}', '\u{11659}'), ('\u{116c0}', '\u{116c9}'), ('\u{118e0}', '\u{118e9}'),
        ('\u{16a60}', '\u{16a69}'), ('\u{16b50}', '\u{16b59}'), ('\u{1d7ce}', '\u{1d7ff}')
    ];

    pub static Nl_table: &'static [(char, char)] = &[
        ('\u{16ee}', '\u{16f0}'), ('\u{2160}', '\u{2182}'), ('\u{2185}', '\u{2188}'), ('\u{3007}',
        '\u{3007}'), ('\u{3021}', '\u{3029}'), ('\u{3038}', '\u{303a}'), ('\u{a6e6}', '\u{a6ef}'),
        ('\u{10140}', '\u{10174}'), ('\u{10341}', '\u{10341}'), ('\u{1034a}', '\u{1034a}'),
        ('\u{103d1}', '\u{103d5}'), ('\u{12400}', '\u{1246e}')
    ];

    pub static No_table: &'static [(char, char)] = &[
        ('\u{b2}', '\u{b3}'), ('\u{b9}', '\u{b9}'), ('\u{bc}', '\u{be}'), ('\u{9f4}', '\u{9f9}'),
        ('\u{b72}', '\u{b77}'), ('\u{bf0}', '\u{bf2}'), ('\u{c78}', '\u{c7e}'), ('\u{d70}',
        '\u{d75}'), ('\u{f2a}', '\u{f33}'), ('\u{1369}', '\u{137c}'), ('\u{17f0}', '\u{17f9}'),
        ('\u{19da}', '\u{19da}'), ('\u{2070}', '\u{2070}'), ('\u{2074}', '\u{2079}'), ('\u{2080}',
        '\u{2089}'), ('\u{2150}', '\u{215f}'), ('\u{2189}', '\u{2189}'), ('\u{2460}', '\u{249b}'),
        ('\u{24ea}', '\u{24ff}'), ('\u{2776}', '\u{2793}'), ('\u{2cfd}', '\u{2cfd}'), ('\u{3192}',
        '\u{3195}'), ('\u{3220}', '\u{3229}'), ('\u{3248}', '\u{324f}'), ('\u{3251}', '\u{325f}'),
        ('\u{3280}', '\u{3289}'), ('\u{32b1}', '\u{32bf}'), ('\u{a830}', '\u{a835}'), ('\u{10107}',
        '\u{10133}'), ('\u{10175}', '\u{10178}'), ('\u{1018a}', '\u{1018b}'), ('\u{102e1}',
        '\u{102fb}'), ('\u{10320}', '\u{10323}'), ('\u{10858}', '\u{1085f}'), ('\u{10879}',
        '\u{1087f}'), ('\u{108a7}', '\u{108af}'), ('\u{10916}', '\u{1091b}'), ('\u{10a40}',
        '\u{10a47}'), ('\u{10a7d}', '\u{10a7e}'), ('\u{10a9d}', '\u{10a9f}'), ('\u{10aeb}',
        '\u{10aef}'), ('\u{10b58}', '\u{10b5f}'), ('\u{10b78}', '\u{10b7f}'), ('\u{10ba9}',
        '\u{10baf}'), ('\u{10e60}', '\u{10e7e}'), ('\u{11052}', '\u{11065}'), ('\u{111e1}',
        '\u{111f4}'), ('\u{118ea}', '\u{118f2}'), ('\u{16b5b}', '\u{16b61}'), ('\u{1d360}',
        '\u{1d371}'), ('\u{1e8c7}', '\u{1e8cf}'), ('\u{1f100}', '\u{1f10c}')
    ];

    pub static P_table: &'static [(char, char)] = &[
        ('\u{21}', '\u{23}'), ('\u{25}', '\u{2a}'), ('\u{2c}', '\u{2f}'), ('\u{3a}', '\u{3b}'),
        ('\u{3f}', '\u{40}'), ('\u{5b}', '\u{5d}'), ('\u{5f}', '\u{5f}'), ('\u{7b}', '\u{7b}'),
        ('\u{7d}', '\u{7d}'), ('\u{a1}', '\u{a1}'), ('\u{a7}', '\u{a7}'), ('\u{ab}', '\u{ab}'),
        ('\u{b6}', '\u{b7}'), ('\u{bb}', '\u{bb}'), ('\u{bf}', '\u{bf}'), ('\u{37e}', '\u{37e}'),
        ('\u{387}', '\u{387}'), ('\u{55a}', '\u{55f}'), ('\u{589}', '\u{58a}'), ('\u{5be}',
        '\u{5be}'), ('\u{5c0}', '\u{5c0}'), ('\u{5c3}', '\u{5c3}'), ('\u{5c6}', '\u{5c6}'),
        ('\u{5f3}', '\u{5f4}'), ('\u{609}', '\u{60a}'), ('\u{60c}', '\u{60d}'), ('\u{61b}',
        '\u{61b}'), ('\u{61e}', '\u{61f}'), ('\u{66a}', '\u{66d}'), ('\u{6d4}', '\u{6d4}'),
        ('\u{700}', '\u{70d}'), ('\u{7f7}', '\u{7f9}'), ('\u{830}', '\u{83e}'), ('\u{85e}',
        '\u{85e}'), ('\u{964}', '\u{965}'), ('\u{970}', '\u{970}'), ('\u{af0}', '\u{af0}'),
        ('\u{df4}', '\u{df4}'), ('\u{e4f}', '\u{e4f}'), ('\u{e5a}', '\u{e5b}'), ('\u{f04}',
        '\u{f12}'), ('\u{f14}', '\u{f14}'), ('\u{f3a}', '\u{f3d}'), ('\u{f85}', '\u{f85}'),
        ('\u{fd0}', '\u{fd4}'), ('\u{fd9}', '\u{fda}'), ('\u{104a}', '\u{104f}'), ('\u{10fb}',
        '\u{10fb}'), ('\u{1360}', '\u{1368}'), ('\u{1400}', '\u{1400}'), ('\u{166d}', '\u{166e}'),
        ('\u{169b}', '\u{169c}'), ('\u{16eb}', '\u{16ed}'), ('\u{1735}', '\u{1736}'), ('\u{17d4}',
        '\u{17d6}'), ('\u{17d8}', '\u{17da}'), ('\u{1800}', '\u{180a}'), ('\u{1944}', '\u{1945}'),
        ('\u{1a1e}', '\u{1a1f}'), ('\u{1aa0}', '\u{1aa6}'), ('\u{1aa8}', '\u{1aad}'), ('\u{1b5a}',
        '\u{1b60}'), ('\u{1bfc}', '\u{1bff}'), ('\u{1c3b}', '\u{1c3f}'), ('\u{1c7e}', '\u{1c7f}'),
        ('\u{1cc0}', '\u{1cc7}'), ('\u{1cd3}', '\u{1cd3}'), ('\u{2010}', '\u{2027}'), ('\u{2030}',
        '\u{2043}'), ('\u{2045}', '\u{2051}'), ('\u{2053}', '\u{205e}'), ('\u{207d}', '\u{207e}'),
        ('\u{208d}', '\u{208e}'), ('\u{2308}', '\u{230b}'), ('\u{2329}', '\u{232a}'), ('\u{2768}',
        '\u{2775}'), ('\u{27c5}', '\u{27c6}'), ('\u{27e6}', '\u{27ef}'), ('\u{2983}', '\u{2998}'),
        ('\u{29d8}', '\u{29db}'), ('\u{29fc}', '\u{29fd}'), ('\u{2cf9}', '\u{2cfc}'), ('\u{2cfe}',
        '\u{2cff}'), ('\u{2d70}', '\u{2d70}'), ('\u{2e00}', '\u{2e2e}'), ('\u{2e30}', '\u{2e42}'),
        ('\u{3001}', '\u{3003}'), ('\u{3008}', '\u{3011}'), ('\u{3014}', '\u{301f}'), ('\u{3030}',
        '\u{3030}'), ('\u{303d}', '\u{303d}'), ('\u{30a0}', '\u{30a0}'), ('\u{30fb}', '\u{30fb}'),
        ('\u{a4fe}', '\u{a4ff}'), ('\u{a60d}', '\u{a60f}'), ('\u{a673}', '\u{a673}'), ('\u{a67e}',
        '\u{a67e}'), ('\u{a6f2}', '\u{a6f7}'), ('\u{a874}', '\u{a877}'), ('\u{a8ce}', '\u{a8cf}'),
        ('\u{a8f8}', '\u{a8fa}'), ('\u{a92e}', '\u{a92f}'), ('\u{a95f}', '\u{a95f}'), ('\u{a9c1}',
        '\u{a9cd}'), ('\u{a9de}', '\u{a9df}'), ('\u{aa5c}', '\u{aa5f}'), ('\u{aade}', '\u{aadf}'),
        ('\u{aaf0}', '\u{aaf1}'), ('\u{abeb}', '\u{abeb}'), ('\u{fd3e}', '\u{fd3f}'), ('\u{fe10}',
        '\u{fe19}'), ('\u{fe30}', '\u{fe52}'), ('\u{fe54}', '\u{fe61}'), ('\u{fe63}', '\u{fe63}'),
        ('\u{fe68}', '\u{fe68}'), ('\u{fe6a}', '\u{fe6b}'), ('\u{ff01}', '\u{ff03}'), ('\u{ff05}',
        '\u{ff0a}'), ('\u{ff0c}', '\u{ff0f}'), ('\u{ff1a}', '\u{ff1b}'), ('\u{ff1f}', '\u{ff20}'),
        ('\u{ff3b}', '\u{ff3d}'), ('\u{ff3f}', '\u{ff3f}'), ('\u{ff5b}', '\u{ff5b}'), ('\u{ff5d}',
        '\u{ff5d}'), ('\u{ff5f}', '\u{ff65}'), ('\u{10100}', '\u{10102}'), ('\u{1039f}',
        '\u{1039f}'), ('\u{103d0}', '\u{103d0}'), ('\u{1056f}', '\u{1056f}'), ('\u{10857}',
        '\u{10857}'), ('\u{1091f}', '\u{1091f}'), ('\u{1093f}', '\u{1093f}'), ('\u{10a50}',
        '\u{10a58}'), ('\u{10a7f}', '\u{10a7f}'), ('\u{10af0}', '\u{10af6}'), ('\u{10b39}',
        '\u{10b3f}'), ('\u{10b99}', '\u{10b9c}'), ('\u{11047}', '\u{1104d}'), ('\u{110bb}',
        '\u{110bc}'), ('\u{110be}', '\u{110c1}'), ('\u{11140}', '\u{11143}'), ('\u{11174}',
        '\u{11175}'), ('\u{111c5}', '\u{111c8}'), ('\u{111cd}', '\u{111cd}'), ('\u{11238}',
        '\u{1123d}'), ('\u{114c6}', '\u{114c6}'), ('\u{115c1}', '\u{115c9}'), ('\u{11641}',
        '\u{11643}'), ('\u{12470}', '\u{12474}'), ('\u{16a6e}', '\u{16a6f}'), ('\u{16af5}',
        '\u{16af5}'), ('\u{16b37}', '\u{16b3b}'), ('\u{16b44}', '\u{16b44}'), ('\u{1bc9f}',
        '\u{1bc9f}')
    ];

    pub static Pc_table: &'static [(char, char)] = &[
        ('\u{5f}', '\u{5f}'), ('\u{203f}', '\u{2040}'), ('\u{2054}', '\u{2054}'), ('\u{fe33}',
        '\u{fe34}'), ('\u{fe4d}', '\u{fe4f}'), ('\u{ff3f}', '\u{ff3f}')
    ];

    pub static Pd_table: &'static [(char, char)] = &[
        ('\u{2d}', '\u{2d}'), ('\u{58a}', '\u{58a}'), ('\u{5be}', '\u{5be}'), ('\u{1400}',
        '\u{1400}'), ('\u{1806}', '\u{1806}'), ('\u{2010}', '\u{2015}'), ('\u{2e17}', '\u{2e17}'),
        ('\u{2e1a}', '\u{2e1a}'), ('\u{2e3a}', '\u{2e3b}'), ('\u{2e40}', '\u{2e40}'), ('\u{301c}',
        '\u{301c}'), ('\u{3030}', '\u{3030}'), ('\u{30a0}', '\u{30a0}'), ('\u{fe31}', '\u{fe32}'),
        ('\u{fe58}', '\u{fe58}'), ('\u{fe63}', '\u{fe63}'), ('\u{ff0d}', '\u{ff0d}')
    ];

    pub static Pe_table: &'static [(char, char)] = &[
        ('\u{29}', '\u{29}'), ('\u{5d}', '\u{5d}'), ('\u{7d}', '\u{7d}'), ('\u{f3b}', '\u{f3b}'),
        ('\u{f3d}', '\u{f3d}'), ('\u{169c}', '\u{169c}'), ('\u{2046}', '\u{2046}'), ('\u{207e}',
        '\u{207e}'), ('\u{208e}', '\u{208e}'), ('\u{2309}', '\u{2309}'), ('\u{230b}', '\u{230b}'),
        ('\u{232a}', '\u{232a}'), ('\u{2769}', '\u{2769}'), ('\u{276b}', '\u{276b}'), ('\u{276d}',
        '\u{276d}'), ('\u{276f}', '\u{276f}'), ('\u{2771}', '\u{2771}'), ('\u{2773}', '\u{2773}'),
        ('\u{2775}', '\u{2775}'), ('\u{27c6}', '\u{27c6}'), ('\u{27e7}', '\u{27e7}'), ('\u{27e9}',
        '\u{27e9}'), ('\u{27eb}', '\u{27eb}'), ('\u{27ed}', '\u{27ed}'), ('\u{27ef}', '\u{27ef}'),
        ('\u{2984}', '\u{2984}'), ('\u{2986}', '\u{2986}'), ('\u{2988}', '\u{2988}'), ('\u{298a}',
        '\u{298a}'), ('\u{298c}', '\u{298c}'), ('\u{298e}', '\u{298e}'), ('\u{2990}', '\u{2990}'),
        ('\u{2992}', '\u{2992}'), ('\u{2994}', '\u{2994}'), ('\u{2996}', '\u{2996}'), ('\u{2998}',
        '\u{2998}'), ('\u{29d9}', '\u{29d9}'), ('\u{29db}', '\u{29db}'), ('\u{29fd}', '\u{29fd}'),
        ('\u{2e23}', '\u{2e23}'), ('\u{2e25}', '\u{2e25}'), ('\u{2e27}', '\u{2e27}'), ('\u{2e29}',
        '\u{2e29}'), ('\u{3009}', '\u{3009}'), ('\u{300b}', '\u{300b}'), ('\u{300d}', '\u{300d}'),
        ('\u{300f}', '\u{300f}'), ('\u{3011}', '\u{3011}'), ('\u{3015}', '\u{3015}'), ('\u{3017}',
        '\u{3017}'), ('\u{3019}', '\u{3019}'), ('\u{301b}', '\u{301b}'), ('\u{301e}', '\u{301f}'),
        ('\u{fd3e}', '\u{fd3e}'), ('\u{fe18}', '\u{fe18}'), ('\u{fe36}', '\u{fe36}'), ('\u{fe38}',
        '\u{fe38}'), ('\u{fe3a}', '\u{fe3a}'), ('\u{fe3c}', '\u{fe3c}'), ('\u{fe3e}', '\u{fe3e}'),
        ('\u{fe40}', '\u{fe40}'), ('\u{fe42}', '\u{fe42}'), ('\u{fe44}', '\u{fe44}'), ('\u{fe48}',
        '\u{fe48}'), ('\u{fe5a}', '\u{fe5a}'), ('\u{fe5c}', '\u{fe5c}'), ('\u{fe5e}', '\u{fe5e}'),
        ('\u{ff09}', '\u{ff09}'), ('\u{ff3d}', '\u{ff3d}'), ('\u{ff5d}', '\u{ff5d}'), ('\u{ff60}',
        '\u{ff60}'), ('\u{ff63}', '\u{ff63}')
    ];

    pub static Pf_table: &'static [(char, char)] = &[
        ('\u{bb}', '\u{bb}'), ('\u{2019}', '\u{2019}'), ('\u{201d}', '\u{201d}'), ('\u{203a}',
        '\u{203a}'), ('\u{2e03}', '\u{2e03}'), ('\u{2e05}', '\u{2e05}'), ('\u{2e0a}', '\u{2e0a}'),
        ('\u{2e0d}', '\u{2e0d}'), ('\u{2e1d}', '\u{2e1d}'), ('\u{2e21}', '\u{2e21}')
    ];

    pub static Pi_table: &'static [(char, char)] = &[
        ('\u{ab}', '\u{ab}'), ('\u{2018}', '\u{2018}'), ('\u{201b}', '\u{201c}'), ('\u{201f}',
        '\u{201f}'), ('\u{2039}', '\u{2039}'), ('\u{2e02}', '\u{2e02}'), ('\u{2e04}', '\u{2e04}'),
        ('\u{2e09}', '\u{2e09}'), ('\u{2e0c}', '\u{2e0c}'), ('\u{2e1c}', '\u{2e1c}'), ('\u{2e20}',
        '\u{2e20}')
    ];

    pub static Po_table: &'static [(char, char)] = &[
        ('\u{21}', '\u{23}'), ('\u{25}', '\u{27}'), ('\u{2a}', '\u{2a}'), ('\u{2c}', '\u{2c}'),
        ('\u{2e}', '\u{2f}'), ('\u{3a}', '\u{3b}'), ('\u{3f}', '\u{40}'), ('\u{5c}', '\u{5c}'),
        ('\u{a1}', '\u{a1}'), ('\u{a7}', '\u{a7}'), ('\u{b6}', '\u{b7}'), ('\u{bf}', '\u{bf}'),
        ('\u{37e}', '\u{37e}'), ('\u{387}', '\u{387}'), ('\u{55a}', '\u{55f}'), ('\u{589}',
        '\u{589}'), ('\u{5c0}', '\u{5c0}'), ('\u{5c3}', '\u{5c3}'), ('\u{5c6}', '\u{5c6}'),
        ('\u{5f3}', '\u{5f4}'), ('\u{609}', '\u{60a}'), ('\u{60c}', '\u{60d}'), ('\u{61b}',
        '\u{61b}'), ('\u{61e}', '\u{61f}'), ('\u{66a}', '\u{66d}'), ('\u{6d4}', '\u{6d4}'),
        ('\u{700}', '\u{70d}'), ('\u{7f7}', '\u{7f9}'), ('\u{830}', '\u{83e}'), ('\u{85e}',
        '\u{85e}'), ('\u{964}', '\u{965}'), ('\u{970}', '\u{970}'), ('\u{af0}', '\u{af0}'),
        ('\u{df4}', '\u{df4}'), ('\u{e4f}', '\u{e4f}'), ('\u{e5a}', '\u{e5b}'), ('\u{f04}',
        '\u{f12}'), ('\u{f14}', '\u{f14}'), ('\u{f85}', '\u{f85}'), ('\u{fd0}', '\u{fd4}'),
        ('\u{fd9}', '\u{fda}'), ('\u{104a}', '\u{104f}'), ('\u{10fb}', '\u{10fb}'), ('\u{1360}',
        '\u{1368}'), ('\u{166d}', '\u{166e}'), ('\u{16eb}', '\u{16ed}'), ('\u{1735}', '\u{1736}'),
        ('\u{17d4}', '\u{17d6}'), ('\u{17d8}', '\u{17da}'), ('\u{1800}', '\u{1805}'), ('\u{1807}',
        '\u{180a}'), ('\u{1944}', '\u{1945}'), ('\u{1a1e}', '\u{1a1f}'), ('\u{1aa0}', '\u{1aa6}'),
        ('\u{1aa8}', '\u{1aad}'), ('\u{1b5a}', '\u{1b60}'), ('\u{1bfc}', '\u{1bff}'), ('\u{1c3b}',
        '\u{1c3f}'), ('\u{1c7e}', '\u{1c7f}'), ('\u{1cc0}', '\u{1cc7}'), ('\u{1cd3}', '\u{1cd3}'),
        ('\u{2016}', '\u{2017}'), ('\u{2020}', '\u{2027}'), ('\u{2030}', '\u{2038}'), ('\u{203b}',
        '\u{203e}'), ('\u{2041}', '\u{2043}'), ('\u{2047}', '\u{2051}'), ('\u{2053}', '\u{2053}'),
        ('\u{2055}', '\u{205e}'), ('\u{2cf9}', '\u{2cfc}'), ('\u{2cfe}', '\u{2cff}'), ('\u{2d70}',
        '\u{2d70}'), ('\u{2e00}', '\u{2e01}'), ('\u{2e06}', '\u{2e08}'), ('\u{2e0b}', '\u{2e0b}'),
        ('\u{2e0e}', '\u{2e16}'), ('\u{2e18}', '\u{2e19}'), ('\u{2e1b}', '\u{2e1b}'), ('\u{2e1e}',
        '\u{2e1f}'), ('\u{2e2a}', '\u{2e2e}'), ('\u{2e30}', '\u{2e39}'), ('\u{2e3c}', '\u{2e3f}'),
        ('\u{2e41}', '\u{2e41}'), ('\u{3001}', '\u{3003}'), ('\u{303d}', '\u{303d}'), ('\u{30fb}',
        '\u{30fb}'), ('\u{a4fe}', '\u{a4ff}'), ('\u{a60d}', '\u{a60f}'), ('\u{a673}', '\u{a673}'),
        ('\u{a67e}', '\u{a67e}'), ('\u{a6f2}', '\u{a6f7}'), ('\u{a874}', '\u{a877}'), ('\u{a8ce}',
        '\u{a8cf}'), ('\u{a8f8}', '\u{a8fa}'), ('\u{a92e}', '\u{a92f}'), ('\u{a95f}', '\u{a95f}'),
        ('\u{a9c1}', '\u{a9cd}'), ('\u{a9de}', '\u{a9df}'), ('\u{aa5c}', '\u{aa5f}'), ('\u{aade}',
        '\u{aadf}'), ('\u{aaf0}', '\u{aaf1}'), ('\u{abeb}', '\u{abeb}'), ('\u{fe10}', '\u{fe16}'),
        ('\u{fe19}', '\u{fe19}'), ('\u{fe30}', '\u{fe30}'), ('\u{fe45}', '\u{fe46}'), ('\u{fe49}',
        '\u{fe4c}'), ('\u{fe50}', '\u{fe52}'), ('\u{fe54}', '\u{fe57}'), ('\u{fe5f}', '\u{fe61}'),
        ('\u{fe68}', '\u{fe68}'), ('\u{fe6a}', '\u{fe6b}'), ('\u{ff01}', '\u{ff03}'), ('\u{ff05}',
        '\u{ff07}'), ('\u{ff0a}', '\u{ff0a}'), ('\u{ff0c}', '\u{ff0c}'), ('\u{ff0e}', '\u{ff0f}'),
        ('\u{ff1a}', '\u{ff1b}'), ('\u{ff1f}', '\u{ff20}'), ('\u{ff3c}', '\u{ff3c}'), ('\u{ff61}',
        '\u{ff61}'), ('\u{ff64}', '\u{ff65}'), ('\u{10100}', '\u{10102}'), ('\u{1039f}',
        '\u{1039f}'), ('\u{103d0}', '\u{103d0}'), ('\u{1056f}', '\u{1056f}'), ('\u{10857}',
        '\u{10857}'), ('\u{1091f}', '\u{1091f}'), ('\u{1093f}', '\u{1093f}'), ('\u{10a50}',
        '\u{10a58}'), ('\u{10a7f}', '\u{10a7f}'), ('\u{10af0}', '\u{10af6}'), ('\u{10b39}',
        '\u{10b3f}'), ('\u{10b99}', '\u{10b9c}'), ('\u{11047}', '\u{1104d}'), ('\u{110bb}',
        '\u{110bc}'), ('\u{110be}', '\u{110c1}'), ('\u{11140}', '\u{11143}'), ('\u{11174}',
        '\u{11175}'), ('\u{111c5}', '\u{111c8}'), ('\u{111cd}', '\u{111cd}'), ('\u{11238}',
        '\u{1123d}'), ('\u{114c6}', '\u{114c6}'), ('\u{115c1}', '\u{115c9}'), ('\u{11641}',
        '\u{11643}'), ('\u{12470}', '\u{12474}'), ('\u{16a6e}', '\u{16a6f}'), ('\u{16af5}',
        '\u{16af5}'), ('\u{16b37}', '\u{16b3b}'), ('\u{16b44}', '\u{16b44}'), ('\u{1bc9f}',
        '\u{1bc9f}')
    ];

    pub static Ps_table: &'static [(char, char)] = &[
        ('\u{28}', '\u{28}'), ('\u{5b}', '\u{5b}'), ('\u{7b}', '\u{7b}'), ('\u{f3a}', '\u{f3a}'),
        ('\u{f3c}', '\u{f3c}'), ('\u{169b}', '\u{169b}'), ('\u{201a}', '\u{201a}'), ('\u{201e}',
        '\u{201e}'), ('\u{2045}', '\u{2045}'), ('\u{207d}', '\u{207d}'), ('\u{208d}', '\u{208d}'),
        ('\u{2308}', '\u{2308}'), ('\u{230a}', '\u{230a}'), ('\u{2329}', '\u{2329}'), ('\u{2768}',
        '\u{2768}'), ('\u{276a}', '\u{276a}'), ('\u{276c}', '\u{276c}'), ('\u{276e}', '\u{276e}'),
        ('\u{2770}', '\u{2770}'), ('\u{2772}', '\u{2772}'), ('\u{2774}', '\u{2774}'), ('\u{27c5}',
        '\u{27c5}'), ('\u{27e6}', '\u{27e6}'), ('\u{27e8}', '\u{27e8}'), ('\u{27ea}', '\u{27ea}'),
        ('\u{27ec}', '\u{27ec}'), ('\u{27ee}', '\u{27ee}'), ('\u{2983}', '\u{2983}'), ('\u{2985}',
        '\u{2985}'), ('\u{2987}', '\u{2987}'), ('\u{2989}', '\u{2989}'), ('\u{298b}', '\u{298b}'),
        ('\u{298d}', '\u{298d}'), ('\u{298f}', '\u{298f}'), ('\u{2991}', '\u{2991}'), ('\u{2993}',
        '\u{2993}'), ('\u{2995}', '\u{2995}'), ('\u{2997}', '\u{2997}'), ('\u{29d8}', '\u{29d8}'),
        ('\u{29da}', '\u{29da}'), ('\u{29fc}', '\u{29fc}'), ('\u{2e22}', '\u{2e22}'), ('\u{2e24}',
        '\u{2e24}'), ('\u{2e26}', '\u{2e26}'), ('\u{2e28}', '\u{2e28}'), ('\u{2e42}', '\u{2e42}'),
        ('\u{3008}', '\u{3008}'), ('\u{300a}', '\u{300a}'), ('\u{300c}', '\u{300c}'), ('\u{300e}',
        '\u{300e}'), ('\u{3010}', '\u{3010}'), ('\u{3014}', '\u{3014}'), ('\u{3016}', '\u{3016}'),
        ('\u{3018}', '\u{3018}'), ('\u{301a}', '\u{301a}'), ('\u{301d}', '\u{301d}'), ('\u{fd3f}',
        '\u{fd3f}'), ('\u{fe17}', '\u{fe17}'), ('\u{fe35}', '\u{fe35}'), ('\u{fe37}', '\u{fe37}'),
        ('\u{fe39}', '\u{fe39}'), ('\u{fe3b}', '\u{fe3b}'), ('\u{fe3d}', '\u{fe3d}'), ('\u{fe3f}',
        '\u{fe3f}'), ('\u{fe41}', '\u{fe41}'), ('\u{fe43}', '\u{fe43}'), ('\u{fe47}', '\u{fe47}'),
        ('\u{fe59}', '\u{fe59}'), ('\u{fe5b}', '\u{fe5b}'), ('\u{fe5d}', '\u{fe5d}'), ('\u{ff08}',
        '\u{ff08}'), ('\u{ff3b}', '\u{ff3b}'), ('\u{ff5b}', '\u{ff5b}'), ('\u{ff5f}', '\u{ff5f}'),
        ('\u{ff62}', '\u{ff62}')
    ];

    pub static S_table: &'static [(char, char)] = &[
        ('\u{24}', '\u{24}'), ('\u{2b}', '\u{2b}'), ('\u{3c}', '\u{3e}'), ('\u{5e}', '\u{5e}'),
        ('\u{60}', '\u{60}'), ('\u{7c}', '\u{7c}'), ('\u{7e}', '\u{7e}'), ('\u{a2}', '\u{a6}'),
        ('\u{a8}', '\u{a9}'), ('\u{ac}', '\u{ac}'), ('\u{ae}', '\u{b1}'), ('\u{b4}', '\u{b4}'),
        ('\u{b8}', '\u{b8}'), ('\u{d7}', '\u{d7}'), ('\u{f7}', '\u{f7}'), ('\u{2c2}', '\u{2c5}'),
        ('\u{2d2}', '\u{2df}'), ('\u{2e5}', '\u{2eb}'), ('\u{2ed}', '\u{2ed}'), ('\u{2ef}',
        '\u{2ff}'), ('\u{375}', '\u{375}'), ('\u{384}', '\u{385}'), ('\u{3f6}', '\u{3f6}'),
        ('\u{482}', '\u{482}'), ('\u{58d}', '\u{58f}'), ('\u{606}', '\u{608}'), ('\u{60b}',
        '\u{60b}'), ('\u{60e}', '\u{60f}'), ('\u{6de}', '\u{6de}'), ('\u{6e9}', '\u{6e9}'),
        ('\u{6fd}', '\u{6fe}'), ('\u{7f6}', '\u{7f6}'), ('\u{9f2}', '\u{9f3}'), ('\u{9fa}',
        '\u{9fb}'), ('\u{af1}', '\u{af1}'), ('\u{b70}', '\u{b70}'), ('\u{bf3}', '\u{bfa}'),
        ('\u{c7f}', '\u{c7f}'), ('\u{d79}', '\u{d79}'), ('\u{e3f}', '\u{e3f}'), ('\u{f01}',
        '\u{f03}'), ('\u{f13}', '\u{f13}'), ('\u{f15}', '\u{f17}'), ('\u{f1a}', '\u{f1f}'),
        ('\u{f34}', '\u{f34}'), ('\u{f36}', '\u{f36}'), ('\u{f38}', '\u{f38}'), ('\u{fbe}',
        '\u{fc5}'), ('\u{fc7}', '\u{fcc}'), ('\u{fce}', '\u{fcf}'), ('\u{fd5}', '\u{fd8}'),
        ('\u{109e}', '\u{109f}'), ('\u{1390}', '\u{1399}'), ('\u{17db}', '\u{17db}'), ('\u{1940}',
        '\u{1940}'), ('\u{19de}', '\u{19ff}'), ('\u{1b61}', '\u{1b6a}'), ('\u{1b74}', '\u{1b7c}'),
        ('\u{1fbd}', '\u{1fbd}'), ('\u{1fbf}', '\u{1fc1}'), ('\u{1fcd}', '\u{1fcf}'), ('\u{1fdd}',
        '\u{1fdf}'), ('\u{1fed}', '\u{1fef}'), ('\u{1ffd}', '\u{1ffe}'), ('\u{2044}', '\u{2044}'),
        ('\u{2052}', '\u{2052}'), ('\u{207a}', '\u{207c}'), ('\u{208a}', '\u{208c}'), ('\u{20a0}',
        '\u{20bd}'), ('\u{2100}', '\u{2101}'), ('\u{2103}', '\u{2106}'), ('\u{2108}', '\u{2109}'),
        ('\u{2114}', '\u{2114}'), ('\u{2116}', '\u{2118}'), ('\u{211e}', '\u{2123}'), ('\u{2125}',
        '\u{2125}'), ('\u{2127}', '\u{2127}'), ('\u{2129}', '\u{2129}'), ('\u{212e}', '\u{212e}'),
        ('\u{213a}', '\u{213b}'), ('\u{2140}', '\u{2144}'), ('\u{214a}', '\u{214d}'), ('\u{214f}',
        '\u{214f}'), ('\u{2190}', '\u{2307}'), ('\u{230c}', '\u{2328}'), ('\u{232b}', '\u{23fa}'),
        ('\u{2400}', '\u{2426}'), ('\u{2440}', '\u{244a}'), ('\u{249c}', '\u{24e9}'), ('\u{2500}',
        '\u{2767}'), ('\u{2794}', '\u{27c4}'), ('\u{27c7}', '\u{27e5}'), ('\u{27f0}', '\u{2982}'),
        ('\u{2999}', '\u{29d7}'), ('\u{29dc}', '\u{29fb}'), ('\u{29fe}', '\u{2b73}'), ('\u{2b76}',
        '\u{2b95}'), ('\u{2b98}', '\u{2bb9}'), ('\u{2bbd}', '\u{2bc8}'), ('\u{2bca}', '\u{2bd1}'),
        ('\u{2ce5}', '\u{2cea}'), ('\u{2e80}', '\u{2e99}'), ('\u{2e9b}', '\u{2ef3}'), ('\u{2f00}',
        '\u{2fd5}'), ('\u{2ff0}', '\u{2ffb}'), ('\u{3004}', '\u{3004}'), ('\u{3012}', '\u{3013}'),
        ('\u{3020}', '\u{3020}'), ('\u{3036}', '\u{3037}'), ('\u{303e}', '\u{303f}'), ('\u{309b}',
        '\u{309c}'), ('\u{3190}', '\u{3191}'), ('\u{3196}', '\u{319f}'), ('\u{31c0}', '\u{31e3}'),
        ('\u{3200}', '\u{321e}'), ('\u{322a}', '\u{3247}'), ('\u{3250}', '\u{3250}'), ('\u{3260}',
        '\u{327f}'), ('\u{328a}', '\u{32b0}'), ('\u{32c0}', '\u{32fe}'), ('\u{3300}', '\u{33ff}'),
        ('\u{4dc0}', '\u{4dff}'), ('\u{a490}', '\u{a4c6}'), ('\u{a700}', '\u{a716}'), ('\u{a720}',
        '\u{a721}'), ('\u{a789}', '\u{a78a}'), ('\u{a828}', '\u{a82b}'), ('\u{a836}', '\u{a839}'),
        ('\u{aa77}', '\u{aa79}'), ('\u{ab5b}', '\u{ab5b}'), ('\u{fb29}', '\u{fb29}'), ('\u{fbb2}',
        '\u{fbc1}'), ('\u{fdfc}', '\u{fdfd}'), ('\u{fe62}', '\u{fe62}'), ('\u{fe64}', '\u{fe66}'),
        ('\u{fe69}', '\u{fe69}'), ('\u{ff04}', '\u{ff04}'), ('\u{ff0b}', '\u{ff0b}'), ('\u{ff1c}',
        '\u{ff1e}'), ('\u{ff3e}', '\u{ff3e}'), ('\u{ff40}', '\u{ff40}'), ('\u{ff5c}', '\u{ff5c}'),
        ('\u{ff5e}', '\u{ff5e}'), ('\u{ffe0}', '\u{ffe6}'), ('\u{ffe8}', '\u{ffee}'), ('\u{fffc}',
        '\u{fffd}'), ('\u{10137}', '\u{1013f}'), ('\u{10179}', '\u{10189}'), ('\u{1018c}',
        '\u{1018c}'), ('\u{10190}', '\u{1019b}'), ('\u{101a0}', '\u{101a0}'), ('\u{101d0}',
        '\u{101fc}'), ('\u{10877}', '\u{10878}'), ('\u{10ac8}', '\u{10ac8}'), ('\u{16b3c}',
        '\u{16b3f}'), ('\u{16b45}', '\u{16b45}'), ('\u{1bc9c}', '\u{1bc9c}'), ('\u{1d000}',
        '\u{1d0f5}'), ('\u{1d100}', '\u{1d126}'), ('\u{1d129}', '\u{1d164}'), ('\u{1d16a}',
        '\u{1d16c}'), ('\u{1d183}', '\u{1d184}'), ('\u{1d18c}', '\u{1d1a9}'), ('\u{1d1ae}',
        '\u{1d1dd}'), ('\u{1d200}', '\u{1d241}'), ('\u{1d245}', '\u{1d245}'), ('\u{1d300}',
        '\u{1d356}'), ('\u{1d6c1}', '\u{1d6c1}'), ('\u{1d6db}', '\u{1d6db}'), ('\u{1d6fb}',
        '\u{1d6fb}'), ('\u{1d715}', '\u{1d715}'), ('\u{1d735}', '\u{1d735}'), ('\u{1d74f}',
        '\u{1d74f}'), ('\u{1d76f}', '\u{1d76f}'), ('\u{1d789}', '\u{1d789}'), ('\u{1d7a9}',
        '\u{1d7a9}'), ('\u{1d7c3}', '\u{1d7c3}'), ('\u{1eef0}', '\u{1eef1}'), ('\u{1f000}',
        '\u{1f02b}'), ('\u{1f030}', '\u{1f093}'), ('\u{1f0a0}', '\u{1f0ae}'), ('\u{1f0b1}',
        '\u{1f0bf}'), ('\u{1f0c1}', '\u{1f0cf}'), ('\u{1f0d1}', '\u{1f0f5}'), ('\u{1f110}',
        '\u{1f12e}'), ('\u{1f130}', '\u{1f16b}'), ('\u{1f170}', '\u{1f19a}'), ('\u{1f1e6}',
        '\u{1f202}'), ('\u{1f210}', '\u{1f23a}'), ('\u{1f240}', '\u{1f248}'), ('\u{1f250}',
        '\u{1f251}'), ('\u{1f300}', '\u{1f32c}'), ('\u{1f330}', '\u{1f37d}'), ('\u{1f380}',
        '\u{1f3ce}'), ('\u{1f3d4}', '\u{1f3f7}'), ('\u{1f400}', '\u{1f4fe}'), ('\u{1f500}',
        '\u{1f54a}'), ('\u{1f550}', '\u{1f579}'), ('\u{1f57b}', '\u{1f5a3}'), ('\u{1f5a5}',
        '\u{1f642}'), ('\u{1f645}', '\u{1f6cf}'), ('\u{1f6e0}', '\u{1f6ec}'), ('\u{1f6f0}',
        '\u{1f6f3}'), ('\u{1f700}', '\u{1f773}'), ('\u{1f780}', '\u{1f7d4}'), ('\u{1f800}',
        '\u{1f80b}'), ('\u{1f810}', '\u{1f847}'), ('\u{1f850}', '\u{1f859}'), ('\u{1f860}',
        '\u{1f887}'), ('\u{1f890}', '\u{1f8ad}')
    ];

    pub static Sc_table: &'static [(char, char)] = &[
        ('\u{24}', '\u{24}'), ('\u{a2}', '\u{a5}'), ('\u{58f}', '\u{58f}'), ('\u{60b}', '\u{60b}'),
        ('\u{9f2}', '\u{9f3}'), ('\u{9fb}', '\u{9fb}'), ('\u{af1}', '\u{af1}'), ('\u{bf9}',
        '\u{bf9}'), ('\u{e3f}', '\u{e3f}'), ('\u{17db}', '\u{17db}'), ('\u{20a0}', '\u{20bd}'),
        ('\u{a838}', '\u{a838}'), ('\u{fdfc}', '\u{fdfc}'), ('\u{fe69}', '\u{fe69}'), ('\u{ff04}',
        '\u{ff04}'), ('\u{ffe0}', '\u{ffe1}'), ('\u{ffe5}', '\u{ffe6}')
    ];

    pub static Sk_table: &'static [(char, char)] = &[
        ('\u{5e}', '\u{5e}'), ('\u{60}', '\u{60}'), ('\u{a8}', '\u{a8}'), ('\u{af}', '\u{af}'),
        ('\u{b4}', '\u{b4}'), ('\u{b8}', '\u{b8}'), ('\u{2c2}', '\u{2c5}'), ('\u{2d2}', '\u{2df}'),
        ('\u{2e5}', '\u{2eb}'), ('\u{2ed}', '\u{2ed}'), ('\u{2ef}', '\u{2ff}'), ('\u{375}',
        '\u{375}'), ('\u{384}', '\u{385}'), ('\u{1fbd}', '\u{1fbd}'), ('\u{1fbf}', '\u{1fc1}'),
        ('\u{1fcd}', '\u{1fcf}'), ('\u{1fdd}', '\u{1fdf}'), ('\u{1fed}', '\u{1fef}'), ('\u{1ffd}',
        '\u{1ffe}'), ('\u{309b}', '\u{309c}'), ('\u{a700}', '\u{a716}'), ('\u{a720}', '\u{a721}'),
        ('\u{a789}', '\u{a78a}'), ('\u{ab5b}', '\u{ab5b}'), ('\u{fbb2}', '\u{fbc1}'), ('\u{ff3e}',
        '\u{ff3e}'), ('\u{ff40}', '\u{ff40}'), ('\u{ffe3}', '\u{ffe3}')
    ];

    pub static Sm_table: &'static [(char, char)] = &[
        ('\u{2b}', '\u{2b}'), ('\u{3c}', '\u{3e}'), ('\u{7c}', '\u{7c}'), ('\u{7e}', '\u{7e}'),
        ('\u{ac}', '\u{ac}'), ('\u{b1}', '\u{b1}'), ('\u{d7}', '\u{d7}'), ('\u{f7}', '\u{f7}'),
        ('\u{3f6}', '\u{3f6}'), ('\u{606}', '\u{608}'), ('\u{2044}', '\u{2044}'), ('\u{2052}',
        '\u{2052}'), ('\u{207a}', '\u{207c}'), ('\u{208a}', '\u{208c}'), ('\u{2118}', '\u{2118}'),
        ('\u{2140}', '\u{2144}'), ('\u{214b}', '\u{214b}'), ('\u{2190}', '\u{2194}'), ('\u{219a}',
        '\u{219b}'), ('\u{21a0}', '\u{21a0}'), ('\u{21a3}', '\u{21a3}'), ('\u{21a6}', '\u{21a6}'),
        ('\u{21ae}', '\u{21ae}'), ('\u{21ce}', '\u{21cf}'), ('\u{21d2}', '\u{21d2}'), ('\u{21d4}',
        '\u{21d4}'), ('\u{21f4}', '\u{22ff}'), ('\u{2320}', '\u{2321}'), ('\u{237c}', '\u{237c}'),
        ('\u{239b}', '\u{23b3}'), ('\u{23dc}', '\u{23e1}'), ('\u{25b7}', '\u{25b7}'), ('\u{25c1}',
        '\u{25c1}'), ('\u{25f8}', '\u{25ff}'), ('\u{266f}', '\u{266f}'), ('\u{27c0}', '\u{27c4}'),
        ('\u{27c7}', '\u{27e5}'), ('\u{27f0}', '\u{27ff}'), ('\u{2900}', '\u{2982}'), ('\u{2999}',
        '\u{29d7}'), ('\u{29dc}', '\u{29fb}'), ('\u{29fe}', '\u{2aff}'), ('\u{2b30}', '\u{2b44}'),
        ('\u{2b47}', '\u{2b4c}'), ('\u{fb29}', '\u{fb29}'), ('\u{fe62}', '\u{fe62}'), ('\u{fe64}',
        '\u{fe66}'), ('\u{ff0b}', '\u{ff0b}'), ('\u{ff1c}', '\u{ff1e}'), ('\u{ff5c}', '\u{ff5c}'),
        ('\u{ff5e}', '\u{ff5e}'), ('\u{ffe2}', '\u{ffe2}'), ('\u{ffe9}', '\u{ffec}'), ('\u{1d6c1}',
        '\u{1d6c1}'), ('\u{1d6db}', '\u{1d6db}'), ('\u{1d6fb}', '\u{1d6fb}'), ('\u{1d715}',
        '\u{1d715}'), ('\u{1d735}', '\u{1d735}'), ('\u{1d74f}', '\u{1d74f}'), ('\u{1d76f}',
        '\u{1d76f}'), ('\u{1d789}', '\u{1d789}'), ('\u{1d7a9}', '\u{1d7a9}'), ('\u{1d7c3}',
        '\u{1d7c3}'), ('\u{1eef0}', '\u{1eef1}')
    ];

    pub static So_table: &'static [(char, char)] = &[
        ('\u{a6}', '\u{a6}'), ('\u{a9}', '\u{a9}'), ('\u{ae}', '\u{ae}'), ('\u{b0}', '\u{b0}'),
        ('\u{482}', '\u{482}'), ('\u{58d}', '\u{58e}'), ('\u{60e}', '\u{60f}'), ('\u{6de}',
        '\u{6de}'), ('\u{6e9}', '\u{6e9}'), ('\u{6fd}', '\u{6fe}'), ('\u{7f6}', '\u{7f6}'),
        ('\u{9fa}', '\u{9fa}'), ('\u{b70}', '\u{b70}'), ('\u{bf3}', '\u{bf8}'), ('\u{bfa}',
        '\u{bfa}'), ('\u{c7f}', '\u{c7f}'), ('\u{d79}', '\u{d79}'), ('\u{f01}', '\u{f03}'),
        ('\u{f13}', '\u{f13}'), ('\u{f15}', '\u{f17}'), ('\u{f1a}', '\u{f1f}'), ('\u{f34}',
        '\u{f34}'), ('\u{f36}', '\u{f36}'), ('\u{f38}', '\u{f38}'), ('\u{fbe}', '\u{fc5}'),
        ('\u{fc7}', '\u{fcc}'), ('\u{fce}', '\u{fcf}'), ('\u{fd5}', '\u{fd8}'), ('\u{109e}',
        '\u{109f}'), ('\u{1390}', '\u{1399}'), ('\u{1940}', '\u{1940}'), ('\u{19de}', '\u{19ff}'),
        ('\u{1b61}', '\u{1b6a}'), ('\u{1b74}', '\u{1b7c}'), ('\u{2100}', '\u{2101}'), ('\u{2103}',
        '\u{2106}'), ('\u{2108}', '\u{2109}'), ('\u{2114}', '\u{2114}'), ('\u{2116}', '\u{2117}'),
        ('\u{211e}', '\u{2123}'), ('\u{2125}', '\u{2125}'), ('\u{2127}', '\u{2127}'), ('\u{2129}',
        '\u{2129}'), ('\u{212e}', '\u{212e}'), ('\u{213a}', '\u{213b}'), ('\u{214a}', '\u{214a}'),
        ('\u{214c}', '\u{214d}'), ('\u{214f}', '\u{214f}'), ('\u{2195}', '\u{2199}'), ('\u{219c}',
        '\u{219f}'), ('\u{21a1}', '\u{21a2}'), ('\u{21a4}', '\u{21a5}'), ('\u{21a7}', '\u{21ad}'),
        ('\u{21af}', '\u{21cd}'), ('\u{21d0}', '\u{21d1}'), ('\u{21d3}', '\u{21d3}'), ('\u{21d5}',
        '\u{21f3}'), ('\u{2300}', '\u{2307}'), ('\u{230c}', '\u{231f}'), ('\u{2322}', '\u{2328}'),
        ('\u{232b}', '\u{237b}'), ('\u{237d}', '\u{239a}'), ('\u{23b4}', '\u{23db}'), ('\u{23e2}',
        '\u{23fa}'), ('\u{2400}', '\u{2426}'), ('\u{2440}', '\u{244a}'), ('\u{249c}', '\u{24e9}'),
        ('\u{2500}', '\u{25b6}'), ('\u{25b8}', '\u{25c0}'), ('\u{25c2}', '\u{25f7}'), ('\u{2600}',
        '\u{266e}'), ('\u{2670}', '\u{2767}'), ('\u{2794}', '\u{27bf}'), ('\u{2800}', '\u{28ff}'),
        ('\u{2b00}', '\u{2b2f}'), ('\u{2b45}', '\u{2b46}'), ('\u{2b4d}', '\u{2b73}'), ('\u{2b76}',
        '\u{2b95}'), ('\u{2b98}', '\u{2bb9}'), ('\u{2bbd}', '\u{2bc8}'), ('\u{2bca}', '\u{2bd1}'),
        ('\u{2ce5}', '\u{2cea}'), ('\u{2e80}', '\u{2e99}'), ('\u{2e9b}', '\u{2ef3}'), ('\u{2f00}',
        '\u{2fd5}'), ('\u{2ff0}', '\u{2ffb}'), ('\u{3004}', '\u{3004}'), ('\u{3012}', '\u{3013}'),
        ('\u{3020}', '\u{3020}'), ('\u{3036}', '\u{3037}'), ('\u{303e}', '\u{303f}'), ('\u{3190}',
        '\u{3191}'), ('\u{3196}', '\u{319f}'), ('\u{31c0}', '\u{31e3}'), ('\u{3200}', '\u{321e}'),
        ('\u{322a}', '\u{3247}'), ('\u{3250}', '\u{3250}'), ('\u{3260}', '\u{327f}'), ('\u{328a}',
        '\u{32b0}'), ('\u{32c0}', '\u{32fe}'), ('\u{3300}', '\u{33ff}'), ('\u{4dc0}', '\u{4dff}'),
        ('\u{a490}', '\u{a4c6}'), ('\u{a828}', '\u{a82b}'), ('\u{a836}', '\u{a837}'), ('\u{a839}',
        '\u{a839}'), ('\u{aa77}', '\u{aa79}'), ('\u{fdfd}', '\u{fdfd}'), ('\u{ffe4}', '\u{ffe4}'),
        ('\u{ffe8}', '\u{ffe8}'), ('\u{ffed}', '\u{ffee}'), ('\u{fffc}', '\u{fffd}'), ('\u{10137}',
        '\u{1013f}'), ('\u{10179}', '\u{10189}'), ('\u{1018c}', '\u{1018c}'), ('\u{10190}',
        '\u{1019b}'), ('\u{101a0}', '\u{101a0}'), ('\u{101d0}', '\u{101fc}'), ('\u{10877}',
        '\u{10878}'), ('\u{10ac8}', '\u{10ac8}'), ('\u{16b3c}', '\u{16b3f}'), ('\u{16b45}',
        '\u{16b45}'), ('\u{1bc9c}', '\u{1bc9c}'), ('\u{1d000}', '\u{1d0f5}'), ('\u{1d100}',
        '\u{1d126}'), ('\u{1d129}', '\u{1d164}'), ('\u{1d16a}', '\u{1d16c}'), ('\u{1d183}',
        '\u{1d184}'), ('\u{1d18c}', '\u{1d1a9}'), ('\u{1d1ae}', '\u{1d1dd}'), ('\u{1d200}',
        '\u{1d241}'), ('\u{1d245}', '\u{1d245}'), ('\u{1d300}', '\u{1d356}'), ('\u{1f000}',
        '\u{1f02b}'), ('\u{1f030}', '\u{1f093}'), ('\u{1f0a0}', '\u{1f0ae}'), ('\u{1f0b1}',
        '\u{1f0bf}'), ('\u{1f0c1}', '\u{1f0cf}'), ('\u{1f0d1}', '\u{1f0f5}'), ('\u{1f110}',
        '\u{1f12e}'), ('\u{1f130}', '\u{1f16b}'), ('\u{1f170}', '\u{1f19a}'), ('\u{1f1e6}',
        '\u{1f202}'), ('\u{1f210}', '\u{1f23a}'), ('\u{1f240}', '\u{1f248}'), ('\u{1f250}',
        '\u{1f251}'), ('\u{1f300}', '\u{1f32c}'), ('\u{1f330}', '\u{1f37d}'), ('\u{1f380}',
        '\u{1f3ce}'), ('\u{1f3d4}', '\u{1f3f7}'), ('\u{1f400}', '\u{1f4fe}'), ('\u{1f500}',
        '\u{1f54a}'), ('\u{1f550}', '\u{1f579}'), ('\u{1f57b}', '\u{1f5a3}'), ('\u{1f5a5}',
        '\u{1f642}'), ('\u{1f645}', '\u{1f6cf}'), ('\u{1f6e0}', '\u{1f6ec}'), ('\u{1f6f0}',
        '\u{1f6f3}'), ('\u{1f700}', '\u{1f773}'), ('\u{1f780}', '\u{1f7d4}'), ('\u{1f800}',
        '\u{1f80b}'), ('\u{1f810}', '\u{1f847}'), ('\u{1f850}', '\u{1f859}'), ('\u{1f860}',
        '\u{1f887}'), ('\u{1f890}', '\u{1f8ad}')
    ];

    pub static Z_table: &'static [(char, char)] = &[
        ('\u{20}', '\u{20}'), ('\u{a0}', '\u{a0}'), ('\u{1680}', '\u{1680}'), ('\u{2000}',
        '\u{200a}'), ('\u{2028}', '\u{2029}'), ('\u{202f}', '\u{202f}'), ('\u{205f}', '\u{205f}'),
        ('\u{3000}', '\u{3000}')
    ];

    pub static Zl_table: &'static [(char, char)] = &[
        ('\u{2028}', '\u{2028}')
    ];

    pub static Zp_table: &'static [(char, char)] = &[
        ('\u{2029}', '\u{2029}')
    ];

    pub static Zs_table: &'static [(char, char)] = &[
        ('\u{20}', '\u{20}'), ('\u{a0}', '\u{a0}'), ('\u{1680}', '\u{1680}'), ('\u{2000}',
        '\u{200a}'), ('\u{202f}', '\u{202f}'), ('\u{205f}', '\u{205f}'), ('\u{3000}', '\u{3000}')
    ];

}

pub mod derived_property {
    pub static Alphabetic_table: &'static [(char, char)] = &[
        ('\u{41}', '\u{5a}'), ('\u{61}', '\u{7a}'), ('\u{aa}', '\u{aa}'), ('\u{b5}', '\u{b5}'),
        ('\u{ba}', '\u{ba}'), ('\u{c0}', '\u{d6}'), ('\u{d8}', '\u{f6}'), ('\u{f8}', '\u{1ba}'),
        ('\u{1bb}', '\u{1bb}'), ('\u{1bc}', '\u{1bf}'), ('\u{1c0}', '\u{1c3}'), ('\u{1c4}',
        '\u{293}'), ('\u{294}', '\u{294}'), ('\u{295}', '\u{2af}'), ('\u{2b0}', '\u{2c1}'),
        ('\u{2c6}', '\u{2d1}'), ('\u{2e0}', '\u{2e4}'), ('\u{2ec}', '\u{2ec}'), ('\u{2ee}',
        '\u{2ee}'), ('\u{345}', '\u{345}'), ('\u{370}', '\u{373}'), ('\u{374}', '\u{374}'),
        ('\u{376}', '\u{377}'), ('\u{37a}', '\u{37a}'), ('\u{37b}', '\u{37d}'), ('\u{37f}',
        '\u{37f}'), ('\u{386}', '\u{386}'), ('\u{388}', '\u{38a}'), ('\u{38c}', '\u{38c}'),
        ('\u{38e}', '\u{3a1}'), ('\u{3a3}', '\u{3f5}'), ('\u{3f7}', '\u{481}'), ('\u{48a}',
        '\u{52f}'), ('\u{531}', '\u{556}'), ('\u{559}', '\u{559}'), ('\u{561}', '\u{587}'),
        ('\u{5b0}', '\u{5bd}'), ('\u{5bf}', '\u{5bf}'), ('\u{5c1}', '\u{5c2}'), ('\u{5c4}',
        '\u{5c5}'), ('\u{5c7}', '\u{5c7}'), ('\u{5d0}', '\u{5ea}'), ('\u{5f0}', '\u{5f2}'),
        ('\u{610}', '\u{61a}'), ('\u{620}', '\u{63f}'), ('\u{640}', '\u{640}'), ('\u{641}',
        '\u{64a}'), ('\u{64b}', '\u{657}'), ('\u{659}', '\u{65f}'), ('\u{66e}', '\u{66f}'),
        ('\u{670}', '\u{670}'), ('\u{671}', '\u{6d3}'), ('\u{6d5}', '\u{6d5}'), ('\u{6d6}',
        '\u{6dc}'), ('\u{6e1}', '\u{6e4}'), ('\u{6e5}', '\u{6e6}'), ('\u{6e7}', '\u{6e8}'),
        ('\u{6ed}', '\u{6ed}'), ('\u{6ee}', '\u{6ef}'), ('\u{6fa}', '\u{6fc}'), ('\u{6ff}',
        '\u{6ff}'), ('\u{710}', '\u{710}'), ('\u{711}', '\u{711}'), ('\u{712}', '\u{72f}'),
        ('\u{730}', '\u{73f}'), ('\u{74d}', '\u{7a5}'), ('\u{7a6}', '\u{7b0}'), ('\u{7b1}',
        '\u{7b1}'), ('\u{7ca}', '\u{7ea}'), ('\u{7f4}', '\u{7f5}'), ('\u{7fa}', '\u{7fa}'),
        ('\u{800}', '\u{815}'), ('\u{816}', '\u{817}'), ('\u{81a}', '\u{81a}'), ('\u{81b}',
        '\u{823}'), ('\u{824}', '\u{824}'), ('\u{825}', '\u{827}'), ('\u{828}', '\u{828}'),
        ('\u{829}', '\u{82c}'), ('\u{840}', '\u{858}'), ('\u{8a0}', '\u{8b2}'), ('\u{8e4}',
        '\u{8e9}'), ('\u{8f0}', '\u{902}'), ('\u{903}', '\u{903}'), ('\u{904}', '\u{939}'),
        ('\u{93a}', '\u{93a}'), ('\u{93b}', '\u{93b}'), ('\u{93d}', '\u{93d}'), ('\u{93e}',
        '\u{940}'), ('\u{941}', '\u{948}'), ('\u{949}', '\u{94c}'), ('\u{94e}', '\u{94f}'),
        ('\u{950}', '\u{950}'), ('\u{955}', '\u{957}'), ('\u{958}', '\u{961}'), ('\u{962}',
        '\u{963}'), ('\u{971}', '\u{971}'), ('\u{972}', '\u{980}'), ('\u{981}', '\u{981}'),
        ('\u{982}', '\u{983}'), ('\u{985}', '\u{98c}'), ('\u{98f}', '\u{990}'), ('\u{993}',
        '\u{9a8}'), ('\u{9aa}', '\u{9b0}'), ('\u{9b2}', '\u{9b2}'), ('\u{9b6}', '\u{9b9}'),
        ('\u{9bd}', '\u{9bd}'), ('\u{9be}', '\u{9c0}'), ('\u{9c1}', '\u{9c4}'), ('\u{9c7}',
        '\u{9c8}'), ('\u{9cb}', '\u{9cc}'), ('\u{9ce}', '\u{9ce}'), ('\u{9d7}', '\u{9d7}'),
        ('\u{9dc}', '\u{9dd}'), ('\u{9df}', '\u{9e1}'), ('\u{9e2}', '\u{9e3}'), ('\u{9f0}',
        '\u{9f1}'), ('\u{a01}', '\u{a02}'), ('\u{a03}', '\u{a03}'), ('\u{a05}', '\u{a0a}'),
        ('\u{a0f}', '\u{a10}'), ('\u{a13}', '\u{a28}'), ('\u{a2a}', '\u{a30}'), ('\u{a32}',
        '\u{a33}'), ('\u{a35}', '\u{a36}'), ('\u{a38}', '\u{a39}'), ('\u{a3e}', '\u{a40}'),
        ('\u{a41}', '\u{a42}'), ('\u{a47}', '\u{a48}'), ('\u{a4b}', '\u{a4c}'), ('\u{a51}',
        '\u{a51}'), ('\u{a59}', '\u{a5c}'), ('\u{a5e}', '\u{a5e}'), ('\u{a70}', '\u{a71}'),
        ('\u{a72}', '\u{a74}'), ('\u{a75}', '\u{a75}'), ('\u{a81}', '\u{a82}'), ('\u{a83}',
        '\u{a83}'), ('\u{a85}', '\u{a8d}'), ('\u{a8f}', '\u{a91}'), ('\u{a93}', '\u{aa8}'),
        ('\u{aaa}', '\u{ab0}'), ('\u{ab2}', '\u{ab3}'), ('\u{ab5}', '\u{ab9}'), ('\u{abd}',
        '\u{abd}'), ('\u{abe}', '\u{ac0}'), ('\u{ac1}', '\u{ac5}'), ('\u{ac7}', '\u{ac8}'),
        ('\u{ac9}', '\u{ac9}'), ('\u{acb}', '\u{acc}'), ('\u{ad0}', '\u{ad0}'), ('\u{ae0}',
        '\u{ae1}'), ('\u{ae2}', '\u{ae3}'), ('\u{b01}', '\u{b01}'), ('\u{b02}', '\u{b03}'),
        ('\u{b05}', '\u{b0c}'), ('\u{b0f}', '\u{b10}'), ('\u{b13}', '\u{b28}'), ('\u{b2a}',
        '\u{b30}'), ('\u{b32}', '\u{b33}'), ('\u{b35}', '\u{b39}'), ('\u{b3d}', '\u{b3d}'),
        ('\u{b3e}', '\u{b3e}'), ('\u{b3f}', '\u{b3f}'), ('\u{b40}', '\u{b40}'), ('\u{b41}',
        '\u{b44}'), ('\u{b47}', '\u{b48}'), ('\u{b4b}', '\u{b4c}'), ('\u{b56}', '\u{b56}'),
        ('\u{b57}', '\u{b57}'), ('\u{b5c}', '\u{b5d}'), ('\u{b5f}', '\u{b61}'), ('\u{b62}',
        '\u{b63}'), ('\u{b71}', '\u{b71}'), ('\u{b82}', '\u{b82}'), ('\u{b83}', '\u{b83}'),
        ('\u{b85}', '\u{b8a}'), ('\u{b8e}', '\u{b90}'), ('\u{b92}', '\u{b95}'), ('\u{b99}',
        '\u{b9a}'), ('\u{b9c}', '\u{b9c}'), ('\u{b9e}', '\u{b9f}'), ('\u{ba3}', '\u{ba4}'),
        ('\u{ba8}', '\u{baa}'), ('\u{bae}', '\u{bb9}'), ('\u{bbe}', '\u{bbf}'), ('\u{bc0}',
        '\u{bc0}'), ('\u{bc1}', '\u{bc2}'), ('\u{bc6}', '\u{bc8}'), ('\u{bca}', '\u{bcc}'),
        ('\u{bd0}', '\u{bd0}'), ('\u{bd7}', '\u{bd7}'), ('\u{c00}', '\u{c00}'), ('\u{c01}',
        '\u{c03}'), ('\u{c05}', '\u{c0c}'), ('\u{c0e}', '\u{c10}'), ('\u{c12}', '\u{c28}'),
        ('\u{c2a}', '\u{c39}'), ('\u{c3d}', '\u{c3d}'), ('\u{c3e}', '\u{c40}'), ('\u{c41}',
        '\u{c44}'), ('\u{c46}', '\u{c48}'), ('\u{c4a}', '\u{c4c}'), ('\u{c55}', '\u{c56}'),
        ('\u{c58}', '\u{c59}'), ('\u{c60}', '\u{c61}'), ('\u{c62}', '\u{c63}'), ('\u{c81}',
        '\u{c81}'), ('\u{c82}', '\u{c83}'), ('\u{c85}', '\u{c8c}'), ('\u{c8e}', '\u{c90}'),
        ('\u{c92}', '\u{ca8}'), ('\u{caa}', '\u{cb3}'), ('\u{cb5}', '\u{cb9}'), ('\u{cbd}',
        '\u{cbd}'), ('\u{cbe}', '\u{cbe}'), ('\u{cbf}', '\u{cbf}'), ('\u{cc0}', '\u{cc4}'),
        ('\u{cc6}', '\u{cc6}'), ('\u{cc7}', '\u{cc8}'), ('\u{cca}', '\u{ccb}'), ('\u{ccc}',
        '\u{ccc}'), ('\u{cd5}', '\u{cd6}'), ('\u{cde}', '\u{cde}'), ('\u{ce0}', '\u{ce1}'),
        ('\u{ce2}', '\u{ce3}'), ('\u{cf1}', '\u{cf2}'), ('\u{d01}', '\u{d01}'), ('\u{d02}',
        '\u{d03}'), ('\u{d05}', '\u{d0c}'), ('\u{d0e}', '\u{d10}'), ('\u{d12}', '\u{d3a}'),
        ('\u{d3d}', '\u{d3d}'), ('\u{d3e}', '\u{d40}'), ('\u{d41}', '\u{d44}'), ('\u{d46}',
        '\u{d48}'), ('\u{d4a}', '\u{d4c}'), ('\u{d4e}', '\u{d4e}'), ('\u{d57}', '\u{d57}'),
        ('\u{d60}', '\u{d61}'), ('\u{d62}', '\u{d63}'), ('\u{d7a}', '\u{d7f}'), ('\u{d82}',
        '\u{d83}'), ('\u{d85}', '\u{d96}'), ('\u{d9a}', '\u{db1}'), ('\u{db3}', '\u{dbb}'),
        ('\u{dbd}', '\u{dbd}'), ('\u{dc0}', '\u{dc6}'), ('\u{dcf}', '\u{dd1}'), ('\u{dd2}',
        '\u{dd4}'), ('\u{dd6}', '\u{dd6}'), ('\u{dd8}', '\u{ddf}'), ('\u{df2}', '\u{df3}'),
        ('\u{e01}', '\u{e30}'), ('\u{e31}', '\u{e31}'), ('\u{e32}', '\u{e33}'), ('\u{e34}',
        '\u{e3a}'), ('\u{e40}', '\u{e45}'), ('\u{e46}', '\u{e46}'), ('\u{e4d}', '\u{e4d}'),
        ('\u{e81}', '\u{e82}'), ('\u{e84}', '\u{e84}'), ('\u{e87}', '\u{e88}'), ('\u{e8a}',
        '\u{e8a}'), ('\u{e8d}', '\u{e8d}'), ('\u{e94}', '\u{e97}'), ('\u{e99}', '\u{e9f}'),
        ('\u{ea1}', '\u{ea3}'), ('\u{ea5}', '\u{ea5}'), ('\u{ea7}', '\u{ea7}'), ('\u{eaa}',
        '\u{eab}'), ('\u{ead}', '\u{eb0}'), ('\u{eb1}', '\u{eb1}'), ('\u{eb2}', '\u{eb3}'),
        ('\u{eb4}', '\u{eb9}'), ('\u{ebb}', '\u{ebc}'), ('\u{ebd}', '\u{ebd}'), ('\u{ec0}',
        '\u{ec4}'), ('\u{ec6}', '\u{ec6}'), ('\u{ecd}', '\u{ecd}'), ('\u{edc}', '\u{edf}'),
        ('\u{f00}', '\u{f00}'), ('\u{f40}', '\u{f47}'), ('\u{f49}', '\u{f6c}'), ('\u{f71}',
        '\u{f7e}'), ('\u{f7f}', '\u{f7f}'), ('\u{f80}', '\u{f81}'), ('\u{f88}', '\u{f8c}'),
        ('\u{f8d}', '\u{f97}'), ('\u{f99}', '\u{fbc}'), ('\u{1000}', '\u{102a}'), ('\u{102b}',
        '\u{102c}'), ('\u{102d}', '\u{1030}'), ('\u{1031}', '\u{1031}'), ('\u{1032}', '\u{1036}'),
        ('\u{1038}', '\u{1038}'), ('\u{103b}', '\u{103c}'), ('\u{103d}', '\u{103e}'), ('\u{103f}',
        '\u{103f}'), ('\u{1050}', '\u{1055}'), ('\u{1056}', '\u{1057}'), ('\u{1058}', '\u{1059}'),
        ('\u{105a}', '\u{105d}'), ('\u{105e}', '\u{1060}'), ('\u{1061}', '\u{1061}'), ('\u{1062}',
        '\u{1062}'), ('\u{1065}', '\u{1066}'), ('\u{1067}', '\u{1068}'), ('\u{106e}', '\u{1070}'),
        ('\u{1071}', '\u{1074}'), ('\u{1075}', '\u{1081}'), ('\u{1082}', '\u{1082}'), ('\u{1083}',
        '\u{1084}'), ('\u{1085}', '\u{1086}'), ('\u{108e}', '\u{108e}'), ('\u{109c}', '\u{109c}'),
        ('\u{109d}', '\u{109d}'), ('\u{10a0}', '\u{10c5}'), ('\u{10c7}', '\u{10c7}'), ('\u{10cd}',
        '\u{10cd}'), ('\u{10d0}', '\u{10fa}'), ('\u{10fc}', '\u{10fc}'), ('\u{10fd}', '\u{1248}'),
        ('\u{124a}', '\u{124d}'), ('\u{1250}', '\u{1256}'), ('\u{1258}', '\u{1258}'), ('\u{125a}',
        '\u{125d}'), ('\u{1260}', '\u{1288}'), ('\u{128a}', '\u{128d}'), ('\u{1290}', '\u{12b0}'),
        ('\u{12b2}', '\u{12b5}'), ('\u{12b8}', '\u{12be}'), ('\u{12c0}', '\u{12c0}'), ('\u{12c2}',
        '\u{12c5}'), ('\u{12c8}', '\u{12d6}'), ('\u{12d8}', '\u{1310}'), ('\u{1312}', '\u{1315}'),
        ('\u{1318}', '\u{135a}'), ('\u{135f}', '\u{135f}'), ('\u{1380}', '\u{138f}'), ('\u{13a0}',
        '\u{13f4}'), ('\u{1401}', '\u{166c}'), ('\u{166f}', '\u{167f}'), ('\u{1681}', '\u{169a}'),
        ('\u{16a0}', '\u{16ea}'), ('\u{16ee}', '\u{16f0}'), ('\u{16f1}', '\u{16f8}'), ('\u{1700}',
        '\u{170c}'), ('\u{170e}', '\u{1711}'), ('\u{1712}', '\u{1713}'), ('\u{1720}', '\u{1731}'),
        ('\u{1732}', '\u{1733}'), ('\u{1740}', '\u{1751}'), ('\u{1752}', '\u{1753}'), ('\u{1760}',
        '\u{176c}'), ('\u{176e}', '\u{1770}'), ('\u{1772}', '\u{1773}'), ('\u{1780}', '\u{17b3}'),
        ('\u{17b6}', '\u{17b6}'), ('\u{17b7}', '\u{17bd}'), ('\u{17be}', '\u{17c5}'), ('\u{17c6}',
        '\u{17c6}'), ('\u{17c7}', '\u{17c8}'), ('\u{17d7}', '\u{17d7}'), ('\u{17dc}', '\u{17dc}'),
        ('\u{1820}', '\u{1842}'), ('\u{1843}', '\u{1843}'), ('\u{1844}', '\u{1877}'), ('\u{1880}',
        '\u{18a8}'), ('\u{18a9}', '\u{18a9}'), ('\u{18aa}', '\u{18aa}'), ('\u{18b0}', '\u{18f5}'),
        ('\u{1900}', '\u{191e}'), ('\u{1920}', '\u{1922}'), ('\u{1923}', '\u{1926}'), ('\u{1927}',
        '\u{1928}'), ('\u{1929}', '\u{192b}'), ('\u{1930}', '\u{1931}'), ('\u{1932}', '\u{1932}'),
        ('\u{1933}', '\u{1938}'), ('\u{1950}', '\u{196d}'), ('\u{1970}', '\u{1974}'), ('\u{1980}',
        '\u{19ab}'), ('\u{19b0}', '\u{19c0}'), ('\u{19c1}', '\u{19c7}'), ('\u{19c8}', '\u{19c9}'),
        ('\u{1a00}', '\u{1a16}'), ('\u{1a17}', '\u{1a18}'), ('\u{1a19}', '\u{1a1a}'), ('\u{1a1b}',
        '\u{1a1b}'), ('\u{1a20}', '\u{1a54}'), ('\u{1a55}', '\u{1a55}'), ('\u{1a56}', '\u{1a56}'),
        ('\u{1a57}', '\u{1a57}'), ('\u{1a58}', '\u{1a5e}'), ('\u{1a61}', '\u{1a61}'), ('\u{1a62}',
        '\u{1a62}'), ('\u{1a63}', '\u{1a64}'), ('\u{1a65}', '\u{1a6c}'), ('\u{1a6d}', '\u{1a72}'),
        ('\u{1a73}', '\u{1a74}'), ('\u{1aa7}', '\u{1aa7}'), ('\u{1b00}', '\u{1b03}'), ('\u{1b04}',
        '\u{1b04}'), ('\u{1b05}', '\u{1b33}'), ('\u{1b35}', '\u{1b35}'), ('\u{1b36}', '\u{1b3a}'),
        ('\u{1b3b}', '\u{1b3b}'), ('\u{1b3c}', '\u{1b3c}'), ('\u{1b3d}', '\u{1b41}'), ('\u{1b42}',
        '\u{1b42}'), ('\u{1b43}', '\u{1b43}'), ('\u{1b45}', '\u{1b4b}'), ('\u{1b80}', '\u{1b81}'),
        ('\u{1b82}', '\u{1b82}'), ('\u{1b83}', '\u{1ba0}'), ('\u{1ba1}', '\u{1ba1}'), ('\u{1ba2}',
        '\u{1ba5}'), ('\u{1ba6}', '\u{1ba7}'), ('\u{1ba8}', '\u{1ba9}'), ('\u{1bac}', '\u{1bad}'),
        ('\u{1bae}', '\u{1baf}'), ('\u{1bba}', '\u{1be5}'), ('\u{1be7}', '\u{1be7}'), ('\u{1be8}',
        '\u{1be9}'), ('\u{1bea}', '\u{1bec}'), ('\u{1bed}', '\u{1bed}'), ('\u{1bee}', '\u{1bee}'),
        ('\u{1bef}', '\u{1bf1}'), ('\u{1c00}', '\u{1c23}'), ('\u{1c24}', '\u{1c2b}'), ('\u{1c2c}',
        '\u{1c33}'), ('\u{1c34}', '\u{1c35}'), ('\u{1c4d}', '\u{1c4f}'), ('\u{1c5a}', '\u{1c77}'),
        ('\u{1c78}', '\u{1c7d}'), ('\u{1ce9}', '\u{1cec}'), ('\u{1cee}', '\u{1cf1}'), ('\u{1cf2}',
        '\u{1cf3}'), ('\u{1cf5}', '\u{1cf6}'), ('\u{1d00}', '\u{1d2b}'), ('\u{1d2c}', '\u{1d6a}'),
        ('\u{1d6b}', '\u{1d77}'), ('\u{1d78}', '\u{1d78}'), ('\u{1d79}', '\u{1d9a}'), ('\u{1d9b}',
        '\u{1dbf}'), ('\u{1de7}', '\u{1df4}'), ('\u{1e00}', '\u{1f15}'), ('\u{1f18}', '\u{1f1d}'),
        ('\u{1f20}', '\u{1f45}'), ('\u{1f48}', '\u{1f4d}'), ('\u{1f50}', '\u{1f57}'), ('\u{1f59}',
        '\u{1f59}'), ('\u{1f5b}', '\u{1f5b}'), ('\u{1f5d}', '\u{1f5d}'), ('\u{1f5f}', '\u{1f7d}'),
        ('\u{1f80}', '\u{1fb4}'), ('\u{1fb6}', '\u{1fbc}'), ('\u{1fbe}', '\u{1fbe}'), ('\u{1fc2}',
        '\u{1fc4}'), ('\u{1fc6}', '\u{1fcc}'), ('\u{1fd0}', '\u{1fd3}'), ('\u{1fd6}', '\u{1fdb}'),
        ('\u{1fe0}', '\u{1fec}'), ('\u{1ff2}', '\u{1ff4}'), ('\u{1ff6}', '\u{1ffc}'), ('\u{2071}',
        '\u{2071}'), ('\u{207f}', '\u{207f}'), ('\u{2090}', '\u{209c}'), ('\u{2102}', '\u{2102}'),
        ('\u{2107}', '\u{2107}'), ('\u{210a}', '\u{2113}'), ('\u{2115}', '\u{2115}'), ('\u{2119}',
        '\u{211d}'), ('\u{2124}', '\u{2124}'), ('\u{2126}', '\u{2126}'), ('\u{2128}', '\u{2128}'),
        ('\u{212a}', '\u{212d}'), ('\u{212f}', '\u{2134}'), ('\u{2135}', '\u{2138}'), ('\u{2139}',
        '\u{2139}'), ('\u{213c}', '\u{213f}'), ('\u{2145}', '\u{2149}'), ('\u{214e}', '\u{214e}'),
        ('\u{2160}', '\u{2182}'), ('\u{2183}', '\u{2184}'), ('\u{2185}', '\u{2188}'), ('\u{24b6}',
        '\u{24e9}'), ('\u{2c00}', '\u{2c2e}'), ('\u{2c30}', '\u{2c5e}'), ('\u{2c60}', '\u{2c7b}'),
        ('\u{2c7c}', '\u{2c7d}'), ('\u{2c7e}', '\u{2ce4}'), ('\u{2ceb}', '\u{2cee}'), ('\u{2cf2}',
        '\u{2cf3}'), ('\u{2d00}', '\u{2d25}'), ('\u{2d27}', '\u{2d27}'), ('\u{2d2d}', '\u{2d2d}'),
        ('\u{2d30}', '\u{2d67}'), ('\u{2d6f}', '\u{2d6f}'), ('\u{2d80}', '\u{2d96}'), ('\u{2da0}',
        '\u{2da6}'), ('\u{2da8}', '\u{2dae}'), ('\u{2db0}', '\u{2db6}'), ('\u{2db8}', '\u{2dbe}'),
        ('\u{2dc0}', '\u{2dc6}'), ('\u{2dc8}', '\u{2dce}'), ('\u{2dd0}', '\u{2dd6}'), ('\u{2dd8}',
        '\u{2dde}'), ('\u{2de0}', '\u{2dff}'), ('\u{2e2f}', '\u{2e2f}'), ('\u{3005}', '\u{3005}'),
        ('\u{3006}', '\u{3006}'), ('\u{3007}', '\u{3007}'), ('\u{3021}', '\u{3029}'), ('\u{3031}',
        '\u{3035}'), ('\u{3038}', '\u{303a}'), ('\u{303b}', '\u{303b}'), ('\u{303c}', '\u{303c}'),
        ('\u{3041}', '\u{3096}'), ('\u{309d}', '\u{309e}'), ('\u{309f}', '\u{309f}'), ('\u{30a1}',
        '\u{30fa}'), ('\u{30fc}', '\u{30fe}'), ('\u{30ff}', '\u{30ff}'), ('\u{3105}', '\u{312d}'),
        ('\u{3131}', '\u{318e}'), ('\u{31a0}', '\u{31ba}'), ('\u{31f0}', '\u{31ff}'), ('\u{3400}',
        '\u{4db5}'), ('\u{4e00}', '\u{9fcc}'), ('\u{a000}', '\u{a014}'), ('\u{a015}', '\u{a015}'),
        ('\u{a016}', '\u{a48c}'), ('\u{a4d0}', '\u{a4f7}'), ('\u{a4f8}', '\u{a4fd}'), ('\u{a500}',
        '\u{a60b}'), ('\u{a60c}', '\u{a60c}'), ('\u{a610}', '\u{a61f}'), ('\u{a62a}', '\u{a62b}'),
        ('\u{a640}', '\u{a66d}'), ('\u{a66e}', '\u{a66e}'), ('\u{a674}', '\u{a67b}'), ('\u{a67f}',
        '\u{a67f}'), ('\u{a680}', '\u{a69b}'), ('\u{a69c}', '\u{a69d}'), ('\u{a69f}', '\u{a69f}'),
        ('\u{a6a0}', '\u{a6e5}'), ('\u{a6e6}', '\u{a6ef}'), ('\u{a717}', '\u{a71f}'), ('\u{a722}',
        '\u{a76f}'), ('\u{a770}', '\u{a770}'), ('\u{a771}', '\u{a787}'), ('\u{a788}', '\u{a788}'),
        ('\u{a78b}', '\u{a78e}'), ('\u{a790}', '\u{a7ad}'), ('\u{a7b0}', '\u{a7b1}'), ('\u{a7f7}',
        '\u{a7f7}'), ('\u{a7f8}', '\u{a7f9}'), ('\u{a7fa}', '\u{a7fa}'), ('\u{a7fb}', '\u{a801}'),
        ('\u{a803}', '\u{a805}'), ('\u{a807}', '\u{a80a}'), ('\u{a80c}', '\u{a822}'), ('\u{a823}',
        '\u{a824}'), ('\u{a825}', '\u{a826}'), ('\u{a827}', '\u{a827}'), ('\u{a840}', '\u{a873}'),
        ('\u{a880}', '\u{a881}'), ('\u{a882}', '\u{a8b3}'), ('\u{a8b4}', '\u{a8c3}'), ('\u{a8f2}',
        '\u{a8f7}'), ('\u{a8fb}', '\u{a8fb}'), ('\u{a90a}', '\u{a925}'), ('\u{a926}', '\u{a92a}'),
        ('\u{a930}', '\u{a946}'), ('\u{a947}', '\u{a951}'), ('\u{a952}', '\u{a952}'), ('\u{a960}',
        '\u{a97c}'), ('\u{a980}', '\u{a982}'), ('\u{a983}', '\u{a983}'), ('\u{a984}', '\u{a9b2}'),
        ('\u{a9b4}', '\u{a9b5}'), ('\u{a9b6}', '\u{a9b9}'), ('\u{a9ba}', '\u{a9bb}'), ('\u{a9bc}',
        '\u{a9bc}'), ('\u{a9bd}', '\u{a9bf}'), ('\u{a9cf}', '\u{a9cf}'), ('\u{a9e0}', '\u{a9e4}'),
        ('\u{a9e6}', '\u{a9e6}'), ('\u{a9e7}', '\u{a9ef}'), ('\u{a9fa}', '\u{a9fe}'), ('\u{aa00}',
        '\u{aa28}'), ('\u{aa29}', '\u{aa2e}'), ('\u{aa2f}', '\u{aa30}'), ('\u{aa31}', '\u{aa32}'),
        ('\u{aa33}', '\u{aa34}'), ('\u{aa35}', '\u{aa36}'), ('\u{aa40}', '\u{aa42}'), ('\u{aa43}',
        '\u{aa43}'), ('\u{aa44}', '\u{aa4b}'), ('\u{aa4c}', '\u{aa4c}'), ('\u{aa4d}', '\u{aa4d}'),
        ('\u{aa60}', '\u{aa6f}'), ('\u{aa70}', '\u{aa70}'), ('\u{aa71}', '\u{aa76}'), ('\u{aa7a}',
        '\u{aa7a}'), ('\u{aa7e}', '\u{aaaf}'), ('\u{aab0}', '\u{aab0}'), ('\u{aab1}', '\u{aab1}'),
        ('\u{aab2}', '\u{aab4}'), ('\u{aab5}', '\u{aab6}'), ('\u{aab7}', '\u{aab8}'), ('\u{aab9}',
        '\u{aabd}'), ('\u{aabe}', '\u{aabe}'), ('\u{aac0}', '\u{aac0}'), ('\u{aac2}', '\u{aac2}'),
        ('\u{aadb}', '\u{aadc}'), ('\u{aadd}', '\u{aadd}'), ('\u{aae0}', '\u{aaea}'), ('\u{aaeb}',
        '\u{aaeb}'), ('\u{aaec}', '\u{aaed}'), ('\u{aaee}', '\u{aaef}'), ('\u{aaf2}', '\u{aaf2}'),
        ('\u{aaf3}', '\u{aaf4}'), ('\u{aaf5}', '\u{aaf5}'), ('\u{ab01}', '\u{ab06}'), ('\u{ab09}',
        '\u{ab0e}'), ('\u{ab11}', '\u{ab16}'), ('\u{ab20}', '\u{ab26}'), ('\u{ab28}', '\u{ab2e}'),
        ('\u{ab30}', '\u{ab5a}'), ('\u{ab5c}', '\u{ab5f}'), ('\u{ab64}', '\u{ab65}'), ('\u{abc0}',
        '\u{abe2}'), ('\u{abe3}', '\u{abe4}'), ('\u{abe5}', '\u{abe5}'), ('\u{abe6}', '\u{abe7}'),
        ('\u{abe8}', '\u{abe8}'), ('\u{abe9}', '\u{abea}'), ('\u{ac00}', '\u{d7a3}'), ('\u{d7b0}',
        '\u{d7c6}'), ('\u{d7cb}', '\u{d7fb}'), ('\u{f900}', '\u{fa6d}'), ('\u{fa70}', '\u{fad9}'),
        ('\u{fb00}', '\u{fb06}'), ('\u{fb13}', '\u{fb17}'), ('\u{fb1d}', '\u{fb1d}'), ('\u{fb1e}',
        '\u{fb1e}'), ('\u{fb1f}', '\u{fb28}'), ('\u{fb2a}', '\u{fb36}'), ('\u{fb38}', '\u{fb3c}'),
        ('\u{fb3e}', '\u{fb3e}'), ('\u{fb40}', '\u{fb41}'), ('\u{fb43}', '\u{fb44}'), ('\u{fb46}',
        '\u{fbb1}'), ('\u{fbd3}', '\u{fd3d}'), ('\u{fd50}', '\u{fd8f}'), ('\u{fd92}', '\u{fdc7}'),
        ('\u{fdf0}', '\u{fdfb}'), ('\u{fe70}', '\u{fe74}'), ('\u{fe76}', '\u{fefc}'), ('\u{ff21}',
        '\u{ff3a}'), ('\u{ff41}', '\u{ff5a}'), ('\u{ff66}', '\u{ff6f}'), ('\u{ff70}', '\u{ff70}'),
        ('\u{ff71}', '\u{ff9d}'), ('\u{ff9e}', '\u{ff9f}'), ('\u{ffa0}', '\u{ffbe}'), ('\u{ffc2}',
        '\u{ffc7}'), ('\u{ffca}', '\u{ffcf}'), ('\u{ffd2}', '\u{ffd7}'), ('\u{ffda}', '\u{ffdc}'),
        ('\u{10000}', '\u{1000b}'), ('\u{1000d}', '\u{10026}'), ('\u{10028}', '\u{1003a}'),
        ('\u{1003c}', '\u{1003d}'), ('\u{1003f}', '\u{1004d}'), ('\u{10050}', '\u{1005d}'),
        ('\u{10080}', '\u{100fa}'), ('\u{10140}', '\u{10174}'), ('\u{10280}', '\u{1029c}'),
        ('\u{102a0}', '\u{102d0}'), ('\u{10300}', '\u{1031f}'), ('\u{10330}', '\u{10340}'),
        ('\u{10341}', '\u{10341}'), ('\u{10342}', '\u{10349}'), ('\u{1034a}', '\u{1034a}'),
        ('\u{10350}', '\u{10375}'), ('\u{10376}', '\u{1037a}'), ('\u{10380}', '\u{1039d}'),
        ('\u{103a0}', '\u{103c3}'), ('\u{103c8}', '\u{103cf}'), ('\u{103d1}', '\u{103d5}'),
        ('\u{10400}', '\u{1044f}'), ('\u{10450}', '\u{1049d}'), ('\u{10500}', '\u{10527}'),
        ('\u{10530}', '\u{10563}'), ('\u{10600}', '\u{10736}'), ('\u{10740}', '\u{10755}'),
        ('\u{10760}', '\u{10767}'), ('\u{10800}', '\u{10805}'), ('\u{10808}', '\u{10808}'),
        ('\u{1080a}', '\u{10835}'), ('\u{10837}', '\u{10838}'), ('\u{1083c}', '\u{1083c}'),
        ('\u{1083f}', '\u{10855}'), ('\u{10860}', '\u{10876}'), ('\u{10880}', '\u{1089e}'),
        ('\u{10900}', '\u{10915}'), ('\u{10920}', '\u{10939}'), ('\u{10980}', '\u{109b7}'),
        ('\u{109be}', '\u{109bf}'), ('\u{10a00}', '\u{10a00}'), ('\u{10a01}', '\u{10a03}'),
        ('\u{10a05}', '\u{10a06}'), ('\u{10a0c}', '\u{10a0f}'), ('\u{10a10}', '\u{10a13}'),
        ('\u{10a15}', '\u{10a17}'), ('\u{10a19}', '\u{10a33}'), ('\u{10a60}', '\u{10a7c}'),
        ('\u{10a80}', '\u{10a9c}'), ('\u{10ac0}', '\u{10ac7}'), ('\u{10ac9}', '\u{10ae4}'),
        ('\u{10b00}', '\u{10b35}'), ('\u{10b40}', '\u{10b55}'), ('\u{10b60}', '\u{10b72}'),
        ('\u{10b80}', '\u{10b91}'), ('\u{10c00}', '\u{10c48}'), ('\u{11000}', '\u{11000}'),
        ('\u{11001}', '\u{11001}'), ('\u{11002}', '\u{11002}'), ('\u{11003}', '\u{11037}'),
        ('\u{11038}', '\u{11045}'), ('\u{11082}', '\u{11082}'), ('\u{11083}', '\u{110af}'),
        ('\u{110b0}', '\u{110b2}'), ('\u{110b3}', '\u{110b6}'), ('\u{110b7}', '\u{110b8}'),
        ('\u{110d0}', '\u{110e8}'), ('\u{11100}', '\u{11102}'), ('\u{11103}', '\u{11126}'),
        ('\u{11127}', '\u{1112b}'), ('\u{1112c}', '\u{1112c}'), ('\u{1112d}', '\u{11132}'),
        ('\u{11150}', '\u{11172}'), ('\u{11176}', '\u{11176}'), ('\u{11180}', '\u{11181}'),
        ('\u{11182}', '\u{11182}'), ('\u{11183}', '\u{111b2}'), ('\u{111b3}', '\u{111b5}'),
        ('\u{111b6}', '\u{111be}'), ('\u{111bf}', '\u{111bf}'), ('\u{111c1}', '\u{111c4}'),
        ('\u{111da}', '\u{111da}'), ('\u{11200}', '\u{11211}'), ('\u{11213}', '\u{1122b}'),
        ('\u{1122c}', '\u{1122e}'), ('\u{1122f}', '\u{11231}'), ('\u{11232}', '\u{11233}'),
        ('\u{11234}', '\u{11234}'), ('\u{11237}', '\u{11237}'), ('\u{112b0}', '\u{112de}'),
        ('\u{112df}', '\u{112df}'), ('\u{112e0}', '\u{112e2}'), ('\u{112e3}', '\u{112e8}'),
        ('\u{11301}', '\u{11301}'), ('\u{11302}', '\u{11303}'), ('\u{11305}', '\u{1130c}'),
        ('\u{1130f}', '\u{11310}'), ('\u{11313}', '\u{11328}'), ('\u{1132a}', '\u{11330}'),
        ('\u{11332}', '\u{11333}'), ('\u{11335}', '\u{11339}'), ('\u{1133d}', '\u{1133d}'),
        ('\u{1133e}', '\u{1133f}'), ('\u{11340}', '\u{11340}'), ('\u{11341}', '\u{11344}'),
        ('\u{11347}', '\u{11348}'), ('\u{1134b}', '\u{1134c}'), ('\u{11357}', '\u{11357}'),
        ('\u{1135d}', '\u{11361}'), ('\u{11362}', '\u{11363}'), ('\u{11480}', '\u{114af}'),
        ('\u{114b0}', '\u{114b2}'), ('\u{114b3}', '\u{114b8}'), ('\u{114b9}', '\u{114b9}'),
        ('\u{114ba}', '\u{114ba}'), ('\u{114bb}', '\u{114be}'), ('\u{114bf}', '\u{114c0}'),
        ('\u{114c1}', '\u{114c1}'), ('\u{114c4}', '\u{114c5}'), ('\u{114c7}', '\u{114c7}'),
        ('\u{11580}', '\u{115ae}'), ('\u{115af}', '\u{115b1}'), ('\u{115b2}', '\u{115b5}'),
        ('\u{115b8}', '\u{115bb}'), ('\u{115bc}', '\u{115bd}'), ('\u{115be}', '\u{115be}'),
        ('\u{11600}', '\u{1162f}'), ('\u{11630}', '\u{11632}'), ('\u{11633}', '\u{1163a}'),
        ('\u{1163b}', '\u{1163c}'), ('\u{1163d}', '\u{1163d}'), ('\u{1163e}', '\u{1163e}'),
        ('\u{11640}', '\u{11640}'), ('\u{11644}', '\u{11644}'), ('\u{11680}', '\u{116aa}'),
        ('\u{116ab}', '\u{116ab}'), ('\u{116ac}', '\u{116ac}'), ('\u{116ad}', '\u{116ad}'),
        ('\u{116ae}', '\u{116af}'), ('\u{116b0}', '\u{116b5}'), ('\u{118a0}', '\u{118df}'),
        ('\u{118ff}', '\u{118ff}'), ('\u{11ac0}', '\u{11af8}'), ('\u{12000}', '\u{12398}'),
        ('\u{12400}', '\u{1246e}'), ('\u{13000}', '\u{1342e}'), ('\u{16800}', '\u{16a38}'),
        ('\u{16a40}', '\u{16a5e}'), ('\u{16ad0}', '\u{16aed}'), ('\u{16b00}', '\u{16b2f}'),
        ('\u{16b30}', '\u{16b36}'), ('\u{16b40}', '\u{16b43}'), ('\u{16b63}', '\u{16b77}'),
        ('\u{16b7d}', '\u{16b8f}'), ('\u{16f00}', '\u{16f44}'), ('\u{16f50}', '\u{16f50}'),
        ('\u{16f51}', '\u{16f7e}'), ('\u{16f93}', '\u{16f9f}'), ('\u{1b000}', '\u{1b001}'),
        ('\u{1bc00}', '\u{1bc6a}'), ('\u{1bc70}', '\u{1bc7c}'), ('\u{1bc80}', '\u{1bc88}'),
        ('\u{1bc90}', '\u{1bc99}'), ('\u{1bc9e}', '\u{1bc9e}'), ('\u{1d400}', '\u{1d454}'),
        ('\u{1d456}', '\u{1d49c}'), ('\u{1d49e}', '\u{1d49f}'), ('\u{1d4a2}', '\u{1d4a2}'),
        ('\u{1d4a5}', '\u{1d4a6}'), ('\u{1d4a9}', '\u{1d4ac}'), ('\u{1d4ae}', '\u{1d4b9}'),
        ('\u{1d4bb}', '\u{1d4bb}'), ('\u{1d4bd}', '\u{1d4c3}'), ('\u{1d4c5}', '\u{1d505}'),
        ('\u{1d507}', '\u{1d50a}'), ('\u{1d50d}', '\u{1d514}'), ('\u{1d516}', '\u{1d51c}'),
        ('\u{1d51e}', '\u{1d539}'), ('\u{1d53b}', '\u{1d53e}'), ('\u{1d540}', '\u{1d544}'),
        ('\u{1d546}', '\u{1d546}'), ('\u{1d54a}', '\u{1d550}'), ('\u{1d552}', '\u{1d6a5}'),
        ('\u{1d6a8}', '\u{1d6c0}'), ('\u{1d6c2}', '\u{1d6da}'), ('\u{1d6dc}', '\u{1d6fa}'),
        ('\u{1d6fc}', '\u{1d714}'), ('\u{1d716}', '\u{1d734}'), ('\u{1d736}', '\u{1d74e}'),
        ('\u{1d750}', '\u{1d76e}'), ('\u{1d770}', '\u{1d788}'), ('\u{1d78a}', '\u{1d7a8}'),
        ('\u{1d7aa}', '\u{1d7c2}'), ('\u{1d7c4}', '\u{1d7cb}'), ('\u{1e800}', '\u{1e8c4}'),
        ('\u{1ee00}', '\u{1ee03}'), ('\u{1ee05}', '\u{1ee1f}'), ('\u{1ee21}', '\u{1ee22}'),
        ('\u{1ee24}', '\u{1ee24}'), ('\u{1ee27}', '\u{1ee27}'), ('\u{1ee29}', '\u{1ee32}'),
        ('\u{1ee34}', '\u{1ee37}'), ('\u{1ee39}', '\u{1ee39}'), ('\u{1ee3b}', '\u{1ee3b}'),
        ('\u{1ee42}', '\u{1ee42}'), ('\u{1ee47}', '\u{1ee47}'), ('\u{1ee49}', '\u{1ee49}'),
        ('\u{1ee4b}', '\u{1ee4b}'), ('\u{1ee4d}', '\u{1ee4f}'), ('\u{1ee51}', '\u{1ee52}'),
        ('\u{1ee54}', '\u{1ee54}'), ('\u{1ee57}', '\u{1ee57}'), ('\u{1ee59}', '\u{1ee59}'),
        ('\u{1ee5b}', '\u{1ee5b}'), ('\u{1ee5d}', '\u{1ee5d}'), ('\u{1ee5f}', '\u{1ee5f}'),
        ('\u{1ee61}', '\u{1ee62}'), ('\u{1ee64}', '\u{1ee64}'), ('\u{1ee67}', '\u{1ee6a}'),
        ('\u{1ee6c}', '\u{1ee72}'), ('\u{1ee74}', '\u{1ee77}'), ('\u{1ee79}', '\u{1ee7c}'),
        ('\u{1ee7e}', '\u{1ee7e}'), ('\u{1ee80}', '\u{1ee89}'), ('\u{1ee8b}', '\u{1ee9b}'),
        ('\u{1eea1}', '\u{1eea3}'), ('\u{1eea5}', '\u{1eea9}'), ('\u{1eeab}', '\u{1eebb}'),
        ('\u{1f130}', '\u{1f149}'), ('\u{1f150}', '\u{1f169}'), ('\u{1f170}', '\u{1f189}'),
        ('\u{20000}', '\u{2a6d6}'), ('\u{2a700}', '\u{2b734}'), ('\u{2b740}', '\u{2b81d}'),
        ('\u{2f800}', '\u{2fa1d}')
    ];

    pub fn Alphabetic(c: char) -> bool {
        super::bsearch_range_table(c, Alphabetic_table)
    }

    pub static Default_Ignorable_Code_Point_table: &'static [(char, char)] = &[
        ('\u{ad}', '\u{ad}'), ('\u{34f}', '\u{34f}'), ('\u{61c}', '\u{61c}'), ('\u{115f}',
        '\u{1160}'), ('\u{17b4}', '\u{17b5}'), ('\u{180b}', '\u{180d}'), ('\u{180e}', '\u{180e}'),
        ('\u{200b}', '\u{200f}'), ('\u{202a}', '\u{202e}'), ('\u{2060}', '\u{2064}'), ('\u{2065}',
        '\u{2065}'), ('\u{2066}', '\u{206f}'), ('\u{3164}', '\u{3164}'), ('\u{fe00}', '\u{fe0f}'),
        ('\u{feff}', '\u{feff}'), ('\u{ffa0}', '\u{ffa0}'), ('\u{fff0}', '\u{fff8}'), ('\u{1bca0}',
        '\u{1bca3}'), ('\u{1d173}', '\u{1d17a}'), ('\u{e0000}', '\u{e0000}'), ('\u{e0001}',
        '\u{e0001}'), ('\u{e0002}', '\u{e001f}'), ('\u{e0020}', '\u{e007f}'), ('\u{e0080}',
        '\u{e00ff}'), ('\u{e0100}', '\u{e01ef}'), ('\u{e01f0}', '\u{e0fff}')
    ];

    pub static Lowercase_table: &'static [(char, char)] = &[
        ('\u{61}', '\u{7a}'), ('\u{aa}', '\u{aa}'), ('\u{b5}', '\u{b5}'), ('\u{ba}', '\u{ba}'),
        ('\u{df}', '\u{f6}'), ('\u{f8}', '\u{ff}'), ('\u{101}', '\u{101}'), ('\u{103}', '\u{103}'),
        ('\u{105}', '\u{105}'), ('\u{107}', '\u{107}'), ('\u{109}', '\u{109}'), ('\u{10b}',
        '\u{10b}'), ('\u{10d}', '\u{10d}'), ('\u{10f}', '\u{10f}'), ('\u{111}', '\u{111}'),
        ('\u{113}', '\u{113}'), ('\u{115}', '\u{115}'), ('\u{117}', '\u{117}'), ('\u{119}',
        '\u{119}'), ('\u{11b}', '\u{11b}'), ('\u{11d}', '\u{11d}'), ('\u{11f}', '\u{11f}'),
        ('\u{121}', '\u{121}'), ('\u{123}', '\u{123}'), ('\u{125}', '\u{125}'), ('\u{127}',
        '\u{127}'), ('\u{129}', '\u{129}'), ('\u{12b}', '\u{12b}'), ('\u{12d}', '\u{12d}'),
        ('\u{12f}', '\u{12f}'), ('\u{131}', '\u{131}'), ('\u{133}', '\u{133}'), ('\u{135}',
        '\u{135}'), ('\u{137}', '\u{138}'), ('\u{13a}', '\u{13a}'), ('\u{13c}', '\u{13c}'),
        ('\u{13e}', '\u{13e}'), ('\u{140}', '\u{140}'), ('\u{142}', '\u{142}'), ('\u{144}',
        '\u{144}'), ('\u{146}', '\u{146}'), ('\u{148}', '\u{149}'), ('\u{14b}', '\u{14b}'),
        ('\u{14d}', '\u{14d}'), ('\u{14f}', '\u{14f}'), ('\u{151}', '\u{151}'), ('\u{153}',
        '\u{153}'), ('\u{155}', '\u{155}'), ('\u{157}', '\u{157}'), ('\u{159}', '\u{159}'),
        ('\u{15b}', '\u{15b}'), ('\u{15d}', '\u{15d}'), ('\u{15f}', '\u{15f}'), ('\u{161}',
        '\u{161}'), ('\u{163}', '\u{163}'), ('\u{165}', '\u{165}'), ('\u{167}', '\u{167}'),
        ('\u{169}', '\u{169}'), ('\u{16b}', '\u{16b}'), ('\u{16d}', '\u{16d}'), ('\u{16f}',
        '\u{16f}'), ('\u{171}', '\u{171}'), ('\u{173}', '\u{173}'), ('\u{175}', '\u{175}'),
        ('\u{177}', '\u{177}'), ('\u{17a}', '\u{17a}'), ('\u{17c}', '\u{17c}'), ('\u{17e}',
        '\u{180}'), ('\u{183}', '\u{183}'), ('\u{185}', '\u{185}'), ('\u{188}', '\u{188}'),
        ('\u{18c}', '\u{18d}'), ('\u{192}', '\u{192}'), ('\u{195}', '\u{195}'), ('\u{199}',
        '\u{19b}'), ('\u{19e}', '\u{19e}'), ('\u{1a1}', '\u{1a1}'), ('\u{1a3}', '\u{1a3}'),
        ('\u{1a5}', '\u{1a5}'), ('\u{1a8}', '\u{1a8}'), ('\u{1aa}', '\u{1ab}'), ('\u{1ad}',
        '\u{1ad}'), ('\u{1b0}', '\u{1b0}'), ('\u{1b4}', '\u{1b4}'), ('\u{1b6}', '\u{1b6}'),
        ('\u{1b9}', '\u{1ba}'), ('\u{1bd}', '\u{1bf}'), ('\u{1c6}', '\u{1c6}'), ('\u{1c9}',
        '\u{1c9}'), ('\u{1cc}', '\u{1cc}'), ('\u{1ce}', '\u{1ce}'), ('\u{1d0}', '\u{1d0}'),
        ('\u{1d2}', '\u{1d2}'), ('\u{1d4}', '\u{1d4}'), ('\u{1d6}', '\u{1d6}'), ('\u{1d8}',
        '\u{1d8}'), ('\u{1da}', '\u{1da}'), ('\u{1dc}', '\u{1dd}'), ('\u{1df}', '\u{1df}'),
        ('\u{1e1}', '\u{1e1}'), ('\u{1e3}', '\u{1e3}'), ('\u{1e5}', '\u{1e5}'), ('\u{1e7}',
        '\u{1e7}'), ('\u{1e9}', '\u{1e9}'), ('\u{1eb}', '\u{1eb}'), ('\u{1ed}', '\u{1ed}'),
        ('\u{1ef}', '\u{1f0}'), ('\u{1f3}', '\u{1f3}'), ('\u{1f5}', '\u{1f5}'), ('\u{1f9}',
        '\u{1f9}'), ('\u{1fb}', '\u{1fb}'), ('\u{1fd}', '\u{1fd}'), ('\u{1ff}', '\u{1ff}'),
        ('\u{201}', '\u{201}'), ('\u{203}', '\u{203}'), ('\u{205}', '\u{205}'), ('\u{207}',
        '\u{207}'), ('\u{209}', '\u{209}'), ('\u{20b}', '\u{20b}'), ('\u{20d}', '\u{20d}'),
        ('\u{20f}', '\u{20f}'), ('\u{211}', '\u{211}'), ('\u{213}', '\u{213}'), ('\u{215}',
        '\u{215}'), ('\u{217}', '\u{217}'), ('\u{219}', '\u{219}'), ('\u{21b}', '\u{21b}'),
        ('\u{21d}', '\u{21d}'), ('\u{21f}', '\u{21f}'), ('\u{221}', '\u{221}'), ('\u{223}',
        '\u{223}'), ('\u{225}', '\u{225}'), ('\u{227}', '\u{227}'), ('\u{229}', '\u{229}'),
        ('\u{22b}', '\u{22b}'), ('\u{22d}', '\u{22d}'), ('\u{22f}', '\u{22f}'), ('\u{231}',
        '\u{231}'), ('\u{233}', '\u{239}'), ('\u{23c}', '\u{23c}'), ('\u{23f}', '\u{240}'),
        ('\u{242}', '\u{242}'), ('\u{247}', '\u{247}'), ('\u{249}', '\u{249}'), ('\u{24b}',
        '\u{24b}'), ('\u{24d}', '\u{24d}'), ('\u{24f}', '\u{293}'), ('\u{295}', '\u{2af}'),
        ('\u{2b0}', '\u{2b8}'), ('\u{2c0}', '\u{2c1}'), ('\u{2e0}', '\u{2e4}'), ('\u{345}',
        '\u{345}'), ('\u{371}', '\u{371}'), ('\u{373}', '\u{373}'), ('\u{377}', '\u{377}'),
        ('\u{37a}', '\u{37a}'), ('\u{37b}', '\u{37d}'), ('\u{390}', '\u{390}'), ('\u{3ac}',
        '\u{3ce}'), ('\u{3d0}', '\u{3d1}'), ('\u{3d5}', '\u{3d7}'), ('\u{3d9}', '\u{3d9}'),
        ('\u{3db}', '\u{3db}'), ('\u{3dd}', '\u{3dd}'), ('\u{3df}', '\u{3df}'), ('\u{3e1}',
        '\u{3e1}'), ('\u{3e3}', '\u{3e3}'), ('\u{3e5}', '\u{3e5}'), ('\u{3e7}', '\u{3e7}'),
        ('\u{3e9}', '\u{3e9}'), ('\u{3eb}', '\u{3eb}'), ('\u{3ed}', '\u{3ed}'), ('\u{3ef}',
        '\u{3f3}'), ('\u{3f5}', '\u{3f5}'), ('\u{3f8}', '\u{3f8}'), ('\u{3fb}', '\u{3fc}'),
        ('\u{430}', '\u{45f}'), ('\u{461}', '\u{461}'), ('\u{463}', '\u{463}'), ('\u{465}',
        '\u{465}'), ('\u{467}', '\u{467}'), ('\u{469}', '\u{469}'), ('\u{46b}', '\u{46b}'),
        ('\u{46d}', '\u{46d}'), ('\u{46f}', '\u{46f}'), ('\u{471}', '\u{471}'), ('\u{473}',
        '\u{473}'), ('\u{475}', '\u{475}'), ('\u{477}', '\u{477}'), ('\u{479}', '\u{479}'),
        ('\u{47b}', '\u{47b}'), ('\u{47d}', '\u{47d}'), ('\u{47f}', '\u{47f}'), ('\u{481}',
        '\u{481}'), ('\u{48b}', '\u{48b}'), ('\u{48d}', '\u{48d}'), ('\u{48f}', '\u{48f}'),
        ('\u{491}', '\u{491}'), ('\u{493}', '\u{493}'), ('\u{495}', '\u{495}'), ('\u{497}',
        '\u{497}'), ('\u{499}', '\u{499}'), ('\u{49b}', '\u{49b}'), ('\u{49d}', '\u{49d}'),
        ('\u{49f}', '\u{49f}'), ('\u{4a1}', '\u{4a1}'), ('\u{4a3}', '\u{4a3}'), ('\u{4a5}',
        '\u{4a5}'), ('\u{4a7}', '\u{4a7}'), ('\u{4a9}', '\u{4a9}'), ('\u{4ab}', '\u{4ab}'),
        ('\u{4ad}', '\u{4ad}'), ('\u{4af}', '\u{4af}'), ('\u{4b1}', '\u{4b1}'), ('\u{4b3}',
        '\u{4b3}'), ('\u{4b5}', '\u{4b5}'), ('\u{4b7}', '\u{4b7}'), ('\u{4b9}', '\u{4b9}'),
        ('\u{4bb}', '\u{4bb}'), ('\u{4bd}', '\u{4bd}'), ('\u{4bf}', '\u{4bf}'), ('\u{4c2}',
        '\u{4c2}'), ('\u{4c4}', '\u{4c4}'), ('\u{4c6}', '\u{4c6}'), ('\u{4c8}', '\u{4c8}'),
        ('\u{4ca}', '\u{4ca}'), ('\u{4cc}', '\u{4cc}'), ('\u{4ce}', '\u{4cf}'), ('\u{4d1}',
        '\u{4d1}'), ('\u{4d3}', '\u{4d3}'), ('\u{4d5}', '\u{4d5}'), ('\u{4d7}', '\u{4d7}'),
        ('\u{4d9}', '\u{4d9}'), ('\u{4db}', '\u{4db}'), ('\u{4dd}', '\u{4dd}'), ('\u{4df}',
        '\u{4df}'), ('\u{4e1}', '\u{4e1}'), ('\u{4e3}', '\u{4e3}'), ('\u{4e5}', '\u{4e5}'),
        ('\u{4e7}', '\u{4e7}'), ('\u{4e9}', '\u{4e9}'), ('\u{4eb}', '\u{4eb}'), ('\u{4ed}',
        '\u{4ed}'), ('\u{4ef}', '\u{4ef}'), ('\u{4f1}', '\u{4f1}'), ('\u{4f3}', '\u{4f3}'),
        ('\u{4f5}', '\u{4f5}'), ('\u{4f7}', '\u{4f7}'), ('\u{4f9}', '\u{4f9}'), ('\u{4fb}',
        '\u{4fb}'), ('\u{4fd}', '\u{4fd}'), ('\u{4ff}', '\u{4ff}'), ('\u{501}', '\u{501}'),
        ('\u{503}', '\u{503}'), ('\u{505}', '\u{505}'), ('\u{507}', '\u{507}'), ('\u{509}',
        '\u{509}'), ('\u{50b}', '\u{50b}'), ('\u{50d}', '\u{50d}'), ('\u{50f}', '\u{50f}'),
        ('\u{511}', '\u{511}'), ('\u{513}', '\u{513}'), ('\u{515}', '\u{515}'), ('\u{517}',
        '\u{517}'), ('\u{519}', '\u{519}'), ('\u{51b}', '\u{51b}'), ('\u{51d}', '\u{51d}'),
        ('\u{51f}', '\u{51f}'), ('\u{521}', '\u{521}'), ('\u{523}', '\u{523}'), ('\u{525}',
        '\u{525}'), ('\u{527}', '\u{527}'), ('\u{529}', '\u{529}'), ('\u{52b}', '\u{52b}'),
        ('\u{52d}', '\u{52d}'), ('\u{52f}', '\u{52f}'), ('\u{561}', '\u{587}'), ('\u{1d00}',
        '\u{1d2b}'), ('\u{1d2c}', '\u{1d6a}'), ('\u{1d6b}', '\u{1d77}'), ('\u{1d78}', '\u{1d78}'),
        ('\u{1d79}', '\u{1d9a}'), ('\u{1d9b}', '\u{1dbf}'), ('\u{1e01}', '\u{1e01}'), ('\u{1e03}',
        '\u{1e03}'), ('\u{1e05}', '\u{1e05}'), ('\u{1e07}', '\u{1e07}'), ('\u{1e09}', '\u{1e09}'),
        ('\u{1e0b}', '\u{1e0b}'), ('\u{1e0d}', '\u{1e0d}'), ('\u{1e0f}', '\u{1e0f}'), ('\u{1e11}',
        '\u{1e11}'), ('\u{1e13}', '\u{1e13}'), ('\u{1e15}', '\u{1e15}'), ('\u{1e17}', '\u{1e17}'),
        ('\u{1e19}', '\u{1e19}'), ('\u{1e1b}', '\u{1e1b}'), ('\u{1e1d}', '\u{1e1d}'), ('\u{1e1f}',
        '\u{1e1f}'), ('\u{1e21}', '\u{1e21}'), ('\u{1e23}', '\u{1e23}'), ('\u{1e25}', '\u{1e25}'),
        ('\u{1e27}', '\u{1e27}'), ('\u{1e29}', '\u{1e29}'), ('\u{1e2b}', '\u{1e2b}'), ('\u{1e2d}',
        '\u{1e2d}'), ('\u{1e2f}', '\u{1e2f}'), ('\u{1e31}', '\u{1e31}'), ('\u{1e33}', '\u{1e33}'),
        ('\u{1e35}', '\u{1e35}'), ('\u{1e37}', '\u{1e37}'), ('\u{1e39}', '\u{1e39}'), ('\u{1e3b}',
        '\u{1e3b}'), ('\u{1e3d}', '\u{1e3d}'), ('\u{1e3f}', '\u{1e3f}'), ('\u{1e41}', '\u{1e41}'),
        ('\u{1e43}', '\u{1e43}'), ('\u{1e45}', '\u{1e45}'), ('\u{1e47}', '\u{1e47}'), ('\u{1e49}',
        '\u{1e49}'), ('\u{1e4b}', '\u{1e4b}'), ('\u{1e4d}', '\u{1e4d}'), ('\u{1e4f}', '\u{1e4f}'),
        ('\u{1e51}', '\u{1e51}'), ('\u{1e53}', '\u{1e53}'), ('\u{1e55}', '\u{1e55}'), ('\u{1e57}',
        '\u{1e57}'), ('\u{1e59}', '\u{1e59}'), ('\u{1e5b}', '\u{1e5b}'), ('\u{1e5d}', '\u{1e5d}'),
        ('\u{1e5f}', '\u{1e5f}'), ('\u{1e61}', '\u{1e61}'), ('\u{1e63}', '\u{1e63}'), ('\u{1e65}',
        '\u{1e65}'), ('\u{1e67}', '\u{1e67}'), ('\u{1e69}', '\u{1e69}'), ('\u{1e6b}', '\u{1e6b}'),
        ('\u{1e6d}', '\u{1e6d}'), ('\u{1e6f}', '\u{1e6f}'), ('\u{1e71}', '\u{1e71}'), ('\u{1e73}',
        '\u{1e73}'), ('\u{1e75}', '\u{1e75}'), ('\u{1e77}', '\u{1e77}'), ('\u{1e79}', '\u{1e79}'),
        ('\u{1e7b}', '\u{1e7b}'), ('\u{1e7d}', '\u{1e7d}'), ('\u{1e7f}', '\u{1e7f}'), ('\u{1e81}',
        '\u{1e81}'), ('\u{1e83}', '\u{1e83}'), ('\u{1e85}', '\u{1e85}'), ('\u{1e87}', '\u{1e87}'),
        ('\u{1e89}', '\u{1e89}'), ('\u{1e8b}', '\u{1e8b}'), ('\u{1e8d}', '\u{1e8d}'), ('\u{1e8f}',
        '\u{1e8f}'), ('\u{1e91}', '\u{1e91}'), ('\u{1e93}', '\u{1e93}'), ('\u{1e95}', '\u{1e9d}'),
        ('\u{1e9f}', '\u{1e9f}'), ('\u{1ea1}', '\u{1ea1}'), ('\u{1ea3}', '\u{1ea3}'), ('\u{1ea5}',
        '\u{1ea5}'), ('\u{1ea7}', '\u{1ea7}'), ('\u{1ea9}', '\u{1ea9}'), ('\u{1eab}', '\u{1eab}'),
        ('\u{1ead}', '\u{1ead}'), ('\u{1eaf}', '\u{1eaf}'), ('\u{1eb1}', '\u{1eb1}'), ('\u{1eb3}',
        '\u{1eb3}'), ('\u{1eb5}', '\u{1eb5}'), ('\u{1eb7}', '\u{1eb7}'), ('\u{1eb9}', '\u{1eb9}'),
        ('\u{1ebb}', '\u{1ebb}'), ('\u{1ebd}', '\u{1ebd}'), ('\u{1ebf}', '\u{1ebf}'), ('\u{1ec1}',
        '\u{1ec1}'), ('\u{1ec3}', '\u{1ec3}'), ('\u{1ec5}', '\u{1ec5}'), ('\u{1ec7}', '\u{1ec7}'),
        ('\u{1ec9}', '\u{1ec9}'), ('\u{1ecb}', '\u{1ecb}'), ('\u{1ecd}', '\u{1ecd}'), ('\u{1ecf}',
        '\u{1ecf}'), ('\u{1ed1}', '\u{1ed1}'), ('\u{1ed3}', '\u{1ed3}'), ('\u{1ed5}', '\u{1ed5}'),
        ('\u{1ed7}', '\u{1ed7}'), ('\u{1ed9}', '\u{1ed9}'), ('\u{1edb}', '\u{1edb}'), ('\u{1edd}',
        '\u{1edd}'), ('\u{1edf}', '\u{1edf}'), ('\u{1ee1}', '\u{1ee1}'), ('\u{1ee3}', '\u{1ee3}'),
        ('\u{1ee5}', '\u{1ee5}'), ('\u{1ee7}', '\u{1ee7}'), ('\u{1ee9}', '\u{1ee9}'), ('\u{1eeb}',
        '\u{1eeb}'), ('\u{1eed}', '\u{1eed}'), ('\u{1eef}', '\u{1eef}'), ('\u{1ef1}', '\u{1ef1}'),
        ('\u{1ef3}', '\u{1ef3}'), ('\u{1ef5}', '\u{1ef5}'), ('\u{1ef7}', '\u{1ef7}'), ('\u{1ef9}',
        '\u{1ef9}'), ('\u{1efb}', '\u{1efb}'), ('\u{1efd}', '\u{1efd}'), ('\u{1eff}', '\u{1f07}'),
        ('\u{1f10}', '\u{1f15}'), ('\u{1f20}', '\u{1f27}'), ('\u{1f30}', '\u{1f37}'), ('\u{1f40}',
        '\u{1f45}'), ('\u{1f50}', '\u{1f57}'), ('\u{1f60}', '\u{1f67}'), ('\u{1f70}', '\u{1f7d}'),
        ('\u{1f80}', '\u{1f87}'), ('\u{1f90}', '\u{1f97}'), ('\u{1fa0}', '\u{1fa7}'), ('\u{1fb0}',
        '\u{1fb4}'), ('\u{1fb6}', '\u{1fb7}'), ('\u{1fbe}', '\u{1fbe}'), ('\u{1fc2}', '\u{1fc4}'),
        ('\u{1fc6}', '\u{1fc7}'), ('\u{1fd0}', '\u{1fd3}'), ('\u{1fd6}', '\u{1fd7}'), ('\u{1fe0}',
        '\u{1fe7}'), ('\u{1ff2}', '\u{1ff4}'), ('\u{1ff6}', '\u{1ff7}'), ('\u{2071}', '\u{2071}'),
        ('\u{207f}', '\u{207f}'), ('\u{2090}', '\u{209c}'), ('\u{210a}', '\u{210a}'), ('\u{210e}',
        '\u{210f}'), ('\u{2113}', '\u{2113}'), ('\u{212f}', '\u{212f}'), ('\u{2134}', '\u{2134}'),
        ('\u{2139}', '\u{2139}'), ('\u{213c}', '\u{213d}'), ('\u{2146}', '\u{2149}'), ('\u{214e}',
        '\u{214e}'), ('\u{2170}', '\u{217f}'), ('\u{2184}', '\u{2184}'), ('\u{24d0}', '\u{24e9}'),
        ('\u{2c30}', '\u{2c5e}'), ('\u{2c61}', '\u{2c61}'), ('\u{2c65}', '\u{2c66}'), ('\u{2c68}',
        '\u{2c68}'), ('\u{2c6a}', '\u{2c6a}'), ('\u{2c6c}', '\u{2c6c}'), ('\u{2c71}', '\u{2c71}'),
        ('\u{2c73}', '\u{2c74}'), ('\u{2c76}', '\u{2c7b}'), ('\u{2c7c}', '\u{2c7d}'), ('\u{2c81}',
        '\u{2c81}'), ('\u{2c83}', '\u{2c83}'), ('\u{2c85}', '\u{2c85}'), ('\u{2c87}', '\u{2c87}'),
        ('\u{2c89}', '\u{2c89}'), ('\u{2c8b}', '\u{2c8b}'), ('\u{2c8d}', '\u{2c8d}'), ('\u{2c8f}',
        '\u{2c8f}'), ('\u{2c91}', '\u{2c91}'), ('\u{2c93}', '\u{2c93}'), ('\u{2c95}', '\u{2c95}'),
        ('\u{2c97}', '\u{2c97}'), ('\u{2c99}', '\u{2c99}'), ('\u{2c9b}', '\u{2c9b}'), ('\u{2c9d}',
        '\u{2c9d}'), ('\u{2c9f}', '\u{2c9f}'), ('\u{2ca1}', '\u{2ca1}'), ('\u{2ca3}', '\u{2ca3}'),
        ('\u{2ca5}', '\u{2ca5}'), ('\u{2ca7}', '\u{2ca7}'), ('\u{2ca9}', '\u{2ca9}'), ('\u{2cab}',
        '\u{2cab}'), ('\u{2cad}', '\u{2cad}'), ('\u{2caf}', '\u{2caf}'), ('\u{2cb1}', '\u{2cb1}'),
        ('\u{2cb3}', '\u{2cb3}'), ('\u{2cb5}', '\u{2cb5}'), ('\u{2cb7}', '\u{2cb7}'), ('\u{2cb9}',
        '\u{2cb9}'), ('\u{2cbb}', '\u{2cbb}'), ('\u{2cbd}', '\u{2cbd}'), ('\u{2cbf}', '\u{2cbf}'),
        ('\u{2cc1}', '\u{2cc1}'), ('\u{2cc3}', '\u{2cc3}'), ('\u{2cc5}', '\u{2cc5}'), ('\u{2cc7}',
        '\u{2cc7}'), ('\u{2cc9}', '\u{2cc9}'), ('\u{2ccb}', '\u{2ccb}'), ('\u{2ccd}', '\u{2ccd}'),
        ('\u{2ccf}', '\u{2ccf}'), ('\u{2cd1}', '\u{2cd1}'), ('\u{2cd3}', '\u{2cd3}'), ('\u{2cd5}',
        '\u{2cd5}'), ('\u{2cd7}', '\u{2cd7}'), ('\u{2cd9}', '\u{2cd9}'), ('\u{2cdb}', '\u{2cdb}'),
        ('\u{2cdd}', '\u{2cdd}'), ('\u{2cdf}', '\u{2cdf}'), ('\u{2ce1}', '\u{2ce1}'), ('\u{2ce3}',
        '\u{2ce4}'), ('\u{2cec}', '\u{2cec}'), ('\u{2cee}', '\u{2cee}'), ('\u{2cf3}', '\u{2cf3}'),
        ('\u{2d00}', '\u{2d25}'), ('\u{2d27}', '\u{2d27}'), ('\u{2d2d}', '\u{2d2d}'), ('\u{a641}',
        '\u{a641}'), ('\u{a643}', '\u{a643}'), ('\u{a645}', '\u{a645}'), ('\u{a647}', '\u{a647}'),
        ('\u{a649}', '\u{a649}'), ('\u{a64b}', '\u{a64b}'), ('\u{a64d}', '\u{a64d}'), ('\u{a64f}',
        '\u{a64f}'), ('\u{a651}', '\u{a651}'), ('\u{a653}', '\u{a653}'), ('\u{a655}', '\u{a655}'),
        ('\u{a657}', '\u{a657}'), ('\u{a659}', '\u{a659}'), ('\u{a65b}', '\u{a65b}'), ('\u{a65d}',
        '\u{a65d}'), ('\u{a65f}', '\u{a65f}'), ('\u{a661}', '\u{a661}'), ('\u{a663}', '\u{a663}'),
        ('\u{a665}', '\u{a665}'), ('\u{a667}', '\u{a667}'), ('\u{a669}', '\u{a669}'), ('\u{a66b}',
        '\u{a66b}'), ('\u{a66d}', '\u{a66d}'), ('\u{a681}', '\u{a681}'), ('\u{a683}', '\u{a683}'),
        ('\u{a685}', '\u{a685}'), ('\u{a687}', '\u{a687}'), ('\u{a689}', '\u{a689}'), ('\u{a68b}',
        '\u{a68b}'), ('\u{a68d}', '\u{a68d}'), ('\u{a68f}', '\u{a68f}'), ('\u{a691}', '\u{a691}'),
        ('\u{a693}', '\u{a693}'), ('\u{a695}', '\u{a695}'), ('\u{a697}', '\u{a697}'), ('\u{a699}',
        '\u{a699}'), ('\u{a69b}', '\u{a69b}'), ('\u{a69c}', '\u{a69d}'), ('\u{a723}', '\u{a723}'),
        ('\u{a725}', '\u{a725}'), ('\u{a727}', '\u{a727}'), ('\u{a729}', '\u{a729}'), ('\u{a72b}',
        '\u{a72b}'), ('\u{a72d}', '\u{a72d}'), ('\u{a72f}', '\u{a731}'), ('\u{a733}', '\u{a733}'),
        ('\u{a735}', '\u{a735}'), ('\u{a737}', '\u{a737}'), ('\u{a739}', '\u{a739}'), ('\u{a73b}',
        '\u{a73b}'), ('\u{a73d}', '\u{a73d}'), ('\u{a73f}', '\u{a73f}'), ('\u{a741}', '\u{a741}'),
        ('\u{a743}', '\u{a743}'), ('\u{a745}', '\u{a745}'), ('\u{a747}', '\u{a747}'), ('\u{a749}',
        '\u{a749}'), ('\u{a74b}', '\u{a74b}'), ('\u{a74d}', '\u{a74d}'), ('\u{a74f}', '\u{a74f}'),
        ('\u{a751}', '\u{a751}'), ('\u{a753}', '\u{a753}'), ('\u{a755}', '\u{a755}'), ('\u{a757}',
        '\u{a757}'), ('\u{a759}', '\u{a759}'), ('\u{a75b}', '\u{a75b}'), ('\u{a75d}', '\u{a75d}'),
        ('\u{a75f}', '\u{a75f}'), ('\u{a761}', '\u{a761}'), ('\u{a763}', '\u{a763}'), ('\u{a765}',
        '\u{a765}'), ('\u{a767}', '\u{a767}'), ('\u{a769}', '\u{a769}'), ('\u{a76b}', '\u{a76b}'),
        ('\u{a76d}', '\u{a76d}'), ('\u{a76f}', '\u{a76f}'), ('\u{a770}', '\u{a770}'), ('\u{a771}',
        '\u{a778}'), ('\u{a77a}', '\u{a77a}'), ('\u{a77c}', '\u{a77c}'), ('\u{a77f}', '\u{a77f}'),
        ('\u{a781}', '\u{a781}'), ('\u{a783}', '\u{a783}'), ('\u{a785}', '\u{a785}'), ('\u{a787}',
        '\u{a787}'), ('\u{a78c}', '\u{a78c}'), ('\u{a78e}', '\u{a78e}'), ('\u{a791}', '\u{a791}'),
        ('\u{a793}', '\u{a795}'), ('\u{a797}', '\u{a797}'), ('\u{a799}', '\u{a799}'), ('\u{a79b}',
        '\u{a79b}'), ('\u{a79d}', '\u{a79d}'), ('\u{a79f}', '\u{a79f}'), ('\u{a7a1}', '\u{a7a1}'),
        ('\u{a7a3}', '\u{a7a3}'), ('\u{a7a5}', '\u{a7a5}'), ('\u{a7a7}', '\u{a7a7}'), ('\u{a7a9}',
        '\u{a7a9}'), ('\u{a7f8}', '\u{a7f9}'), ('\u{a7fa}', '\u{a7fa}'), ('\u{ab30}', '\u{ab5a}'),
        ('\u{ab5c}', '\u{ab5f}'), ('\u{ab64}', '\u{ab65}'), ('\u{fb00}', '\u{fb06}'), ('\u{fb13}',
        '\u{fb17}'), ('\u{ff41}', '\u{ff5a}'), ('\u{10428}', '\u{1044f}'), ('\u{118c0}',
        '\u{118df}'), ('\u{1d41a}', '\u{1d433}'), ('\u{1d44e}', '\u{1d454}'), ('\u{1d456}',
        '\u{1d467}'), ('\u{1d482}', '\u{1d49b}'), ('\u{1d4b6}', '\u{1d4b9}'), ('\u{1d4bb}',
        '\u{1d4bb}'), ('\u{1d4bd}', '\u{1d4c3}'), ('\u{1d4c5}', '\u{1d4cf}'), ('\u{1d4ea}',
        '\u{1d503}'), ('\u{1d51e}', '\u{1d537}'), ('\u{1d552}', '\u{1d56b}'), ('\u{1d586}',
        '\u{1d59f}'), ('\u{1d5ba}', '\u{1d5d3}'), ('\u{1d5ee}', '\u{1d607}'), ('\u{1d622}',
        '\u{1d63b}'), ('\u{1d656}', '\u{1d66f}'), ('\u{1d68a}', '\u{1d6a5}'), ('\u{1d6c2}',
        '\u{1d6da}'), ('\u{1d6dc}', '\u{1d6e1}'), ('\u{1d6fc}', '\u{1d714}'), ('\u{1d716}',
        '\u{1d71b}'), ('\u{1d736}', '\u{1d74e}'), ('\u{1d750}', '\u{1d755}'), ('\u{1d770}',
        '\u{1d788}'), ('\u{1d78a}', '\u{1d78f}'), ('\u{1d7aa}', '\u{1d7c2}'), ('\u{1d7c4}',
        '\u{1d7c9}'), ('\u{1d7cb}', '\u{1d7cb}')
    ];

    pub fn Lowercase(c: char) -> bool {
        super::bsearch_range_table(c, Lowercase_table)
    }

    pub static Uppercase_table: &'static [(char, char)] = &[
        ('\u{41}', '\u{5a}'), ('\u{c0}', '\u{d6}'), ('\u{d8}', '\u{de}'), ('\u{100}', '\u{100}'),
        ('\u{102}', '\u{102}'), ('\u{104}', '\u{104}'), ('\u{106}', '\u{106}'), ('\u{108}',
        '\u{108}'), ('\u{10a}', '\u{10a}'), ('\u{10c}', '\u{10c}'), ('\u{10e}', '\u{10e}'),
        ('\u{110}', '\u{110}'), ('\u{112}', '\u{112}'), ('\u{114}', '\u{114}'), ('\u{116}',
        '\u{116}'), ('\u{118}', '\u{118}'), ('\u{11a}', '\u{11a}'), ('\u{11c}', '\u{11c}'),
        ('\u{11e}', '\u{11e}'), ('\u{120}', '\u{120}'), ('\u{122}', '\u{122}'), ('\u{124}',
        '\u{124}'), ('\u{126}', '\u{126}'), ('\u{128}', '\u{128}'), ('\u{12a}', '\u{12a}'),
        ('\u{12c}', '\u{12c}'), ('\u{12e}', '\u{12e}'), ('\u{130}', '\u{130}'), ('\u{132}',
        '\u{132}'), ('\u{134}', '\u{134}'), ('\u{136}', '\u{136}'), ('\u{139}', '\u{139}'),
        ('\u{13b}', '\u{13b}'), ('\u{13d}', '\u{13d}'), ('\u{13f}', '\u{13f}'), ('\u{141}',
        '\u{141}'), ('\u{143}', '\u{143}'), ('\u{145}', '\u{145}'), ('\u{147}', '\u{147}'),
        ('\u{14a}', '\u{14a}'), ('\u{14c}', '\u{14c}'), ('\u{14e}', '\u{14e}'), ('\u{150}',
        '\u{150}'), ('\u{152}', '\u{152}'), ('\u{154}', '\u{154}'), ('\u{156}', '\u{156}'),
        ('\u{158}', '\u{158}'), ('\u{15a}', '\u{15a}'), ('\u{15c}', '\u{15c}'), ('\u{15e}',
        '\u{15e}'), ('\u{160}', '\u{160}'), ('\u{162}', '\u{162}'), ('\u{164}', '\u{164}'),
        ('\u{166}', '\u{166}'), ('\u{168}', '\u{168}'), ('\u{16a}', '\u{16a}'), ('\u{16c}',
        '\u{16c}'), ('\u{16e}', '\u{16e}'), ('\u{170}', '\u{170}'), ('\u{172}', '\u{172}'),
        ('\u{174}', '\u{174}'), ('\u{176}', '\u{176}'), ('\u{178}', '\u{179}'), ('\u{17b}',
        '\u{17b}'), ('\u{17d}', '\u{17d}'), ('\u{181}', '\u{182}'), ('\u{184}', '\u{184}'),
        ('\u{186}', '\u{187}'), ('\u{189}', '\u{18b}'), ('\u{18e}', '\u{191}'), ('\u{193}',
        '\u{194}'), ('\u{196}', '\u{198}'), ('\u{19c}', '\u{19d}'), ('\u{19f}', '\u{1a0}'),
        ('\u{1a2}', '\u{1a2}'), ('\u{1a4}', '\u{1a4}'), ('\u{1a6}', '\u{1a7}'), ('\u{1a9}',
        '\u{1a9}'), ('\u{1ac}', '\u{1ac}'), ('\u{1ae}', '\u{1af}'), ('\u{1b1}', '\u{1b3}'),
        ('\u{1b5}', '\u{1b5}'), ('\u{1b7}', '\u{1b8}'), ('\u{1bc}', '\u{1bc}'), ('\u{1c4}',
        '\u{1c4}'), ('\u{1c7}', '\u{1c7}'), ('\u{1ca}', '\u{1ca}'), ('\u{1cd}', '\u{1cd}'),
        ('\u{1cf}', '\u{1cf}'), ('\u{1d1}', '\u{1d1}'), ('\u{1d3}', '\u{1d3}'), ('\u{1d5}',
        '\u{1d5}'), ('\u{1d7}', '\u{1d7}'), ('\u{1d9}', '\u{1d9}'), ('\u{1db}', '\u{1db}'),
        ('\u{1de}', '\u{1de}'), ('\u{1e0}', '\u{1e0}'), ('\u{1e2}', '\u{1e2}'), ('\u{1e4}',
        '\u{1e4}'), ('\u{1e6}', '\u{1e6}'), ('\u{1e8}', '\u{1e8}'), ('\u{1ea}', '\u{1ea}'),
        ('\u{1ec}', '\u{1ec}'), ('\u{1ee}', '\u{1ee}'), ('\u{1f1}', '\u{1f1}'), ('\u{1f4}',
        '\u{1f4}'), ('\u{1f6}', '\u{1f8}'), ('\u{1fa}', '\u{1fa}'), ('\u{1fc}', '\u{1fc}'),
        ('\u{1fe}', '\u{1fe}'), ('\u{200}', '\u{200}'), ('\u{202}', '\u{202}'), ('\u{204}',
        '\u{204}'), ('\u{206}', '\u{206}'), ('\u{208}', '\u{208}'), ('\u{20a}', '\u{20a}'),
        ('\u{20c}', '\u{20c}'), ('\u{20e}', '\u{20e}'), ('\u{210}', '\u{210}'), ('\u{212}',
        '\u{212}'), ('\u{214}', '\u{214}'), ('\u{216}', '\u{216}'), ('\u{218}', '\u{218}'),
        ('\u{21a}', '\u{21a}'), ('\u{21c}', '\u{21c}'), ('\u{21e}', '\u{21e}'), ('\u{220}',
        '\u{220}'), ('\u{222}', '\u{222}'), ('\u{224}', '\u{224}'), ('\u{226}', '\u{226}'),
        ('\u{228}', '\u{228}'), ('\u{22a}', '\u{22a}'), ('\u{22c}', '\u{22c}'), ('\u{22e}',
        '\u{22e}'), ('\u{230}', '\u{230}'), ('\u{232}', '\u{232}'), ('\u{23a}', '\u{23b}'),
        ('\u{23d}', '\u{23e}'), ('\u{241}', '\u{241}'), ('\u{243}', '\u{246}'), ('\u{248}',
        '\u{248}'), ('\u{24a}', '\u{24a}'), ('\u{24c}', '\u{24c}'), ('\u{24e}', '\u{24e}'),
        ('\u{370}', '\u{370}'), ('\u{372}', '\u{372}'), ('\u{376}', '\u{376}'), ('\u{37f}',
        '\u{37f}'), ('\u{386}', '\u{386}'), ('\u{388}', '\u{38a}'), ('\u{38c}', '\u{38c}'),
        ('\u{38e}', '\u{38f}'), ('\u{391}', '\u{3a1}'), ('\u{3a3}', '\u{3ab}'), ('\u{3cf}',
        '\u{3cf}'), ('\u{3d2}', '\u{3d4}'), ('\u{3d8}', '\u{3d8}'), ('\u{3da}', '\u{3da}'),
        ('\u{3dc}', '\u{3dc}'), ('\u{3de}', '\u{3de}'), ('\u{3e0}', '\u{3e0}'), ('\u{3e2}',
        '\u{3e2}'), ('\u{3e4}', '\u{3e4}'), ('\u{3e6}', '\u{3e6}'), ('\u{3e8}', '\u{3e8}'),
        ('\u{3ea}', '\u{3ea}'), ('\u{3ec}', '\u{3ec}'), ('\u{3ee}', '\u{3ee}'), ('\u{3f4}',
        '\u{3f4}'), ('\u{3f7}', '\u{3f7}'), ('\u{3f9}', '\u{3fa}'), ('\u{3fd}', '\u{42f}'),
        ('\u{460}', '\u{460}'), ('\u{462}', '\u{462}'), ('\u{464}', '\u{464}'), ('\u{466}',
        '\u{466}'), ('\u{468}', '\u{468}'), ('\u{46a}', '\u{46a}'), ('\u{46c}', '\u{46c}'),
        ('\u{46e}', '\u{46e}'), ('\u{470}', '\u{470}'), ('\u{472}', '\u{472}'), ('\u{474}',
        '\u{474}'), ('\u{476}', '\u{476}'), ('\u{478}', '\u{478}'), ('\u{47a}', '\u{47a}'),
        ('\u{47c}', '\u{47c}'), ('\u{47e}', '\u{47e}'), ('\u{480}', '\u{480}'), ('\u{48a}',
        '\u{48a}'), ('\u{48c}', '\u{48c}'), ('\u{48e}', '\u{48e}'), ('\u{490}', '\u{490}'),
        ('\u{492}', '\u{492}'), ('\u{494}', '\u{494}'), ('\u{496}', '\u{496}'), ('\u{498}',
        '\u{498}'), ('\u{49a}', '\u{49a}'), ('\u{49c}', '\u{49c}'), ('\u{49e}', '\u{49e}'),
        ('\u{4a0}', '\u{4a0}'), ('\u{4a2}', '\u{4a2}'), ('\u{4a4}', '\u{4a4}'), ('\u{4a6}',
        '\u{4a6}'), ('\u{4a8}', '\u{4a8}'), ('\u{4aa}', '\u{4aa}'), ('\u{4ac}', '\u{4ac}'),
        ('\u{4ae}', '\u{4ae}'), ('\u{4b0}', '\u{4b0}'), ('\u{4b2}', '\u{4b2}'), ('\u{4b4}',
        '\u{4b4}'), ('\u{4b6}', '\u{4b6}'), ('\u{4b8}', '\u{4b8}'), ('\u{4ba}', '\u{4ba}'),
        ('\u{4bc}', '\u{4bc}'), ('\u{4be}', '\u{4be}'), ('\u{4c0}', '\u{4c1}'), ('\u{4c3}',
        '\u{4c3}'), ('\u{4c5}', '\u{4c5}'), ('\u{4c7}', '\u{4c7}'), ('\u{4c9}', '\u{4c9}'),
        ('\u{4cb}', '\u{4cb}'), ('\u{4cd}', '\u{4cd}'), ('\u{4d0}', '\u{4d0}'), ('\u{4d2}',
        '\u{4d2}'), ('\u{4d4}', '\u{4d4}'), ('\u{4d6}', '\u{4d6}'), ('\u{4d8}', '\u{4d8}'),
        ('\u{4da}', '\u{4da}'), ('\u{4dc}', '\u{4dc}'), ('\u{4de}', '\u{4de}'), ('\u{4e0}',
        '\u{4e0}'), ('\u{4e2}', '\u{4e2}'), ('\u{4e4}', '\u{4e4}'), ('\u{4e6}', '\u{4e6}'),
        ('\u{4e8}', '\u{4e8}'), ('\u{4ea}', '\u{4ea}'), ('\u{4ec}', '\u{4ec}'), ('\u{4ee}',
        '\u{4ee}'), ('\u{4f0}', '\u{4f0}'), ('\u{4f2}', '\u{4f2}'), ('\u{4f4}', '\u{4f4}'),
        ('\u{4f6}', '\u{4f6}'), ('\u{4f8}', '\u{4f8}'), ('\u{4fa}', '\u{4fa}'), ('\u{4fc}',
        '\u{4fc}'), ('\u{4fe}', '\u{4fe}'), ('\u{500}', '\u{500}'), ('\u{502}', '\u{502}'),
        ('\u{504}', '\u{504}'), ('\u{506}', '\u{506}'), ('\u{508}', '\u{508}'), ('\u{50a}',
        '\u{50a}'), ('\u{50c}', '\u{50c}'), ('\u{50e}', '\u{50e}'), ('\u{510}', '\u{510}'),
        ('\u{512}', '\u{512}'), ('\u{514}', '\u{514}'), ('\u{516}', '\u{516}'), ('\u{518}',
        '\u{518}'), ('\u{51a}', '\u{51a}'), ('\u{51c}', '\u{51c}'), ('\u{51e}', '\u{51e}'),
        ('\u{520}', '\u{520}'), ('\u{522}', '\u{522}'), ('\u{524}', '\u{524}'), ('\u{526}',
        '\u{526}'), ('\u{528}', '\u{528}'), ('\u{52a}', '\u{52a}'), ('\u{52c}', '\u{52c}'),
        ('\u{52e}', '\u{52e}'), ('\u{531}', '\u{556}'), ('\u{10a0}', '\u{10c5}'), ('\u{10c7}',
        '\u{10c7}'), ('\u{10cd}', '\u{10cd}'), ('\u{1e00}', '\u{1e00}'), ('\u{1e02}', '\u{1e02}'),
        ('\u{1e04}', '\u{1e04}'), ('\u{1e06}', '\u{1e06}'), ('\u{1e08}', '\u{1e08}'), ('\u{1e0a}',
        '\u{1e0a}'), ('\u{1e0c}', '\u{1e0c}'), ('\u{1e0e}', '\u{1e0e}'), ('\u{1e10}', '\u{1e10}'),
        ('\u{1e12}', '\u{1e12}'), ('\u{1e14}', '\u{1e14}'), ('\u{1e16}', '\u{1e16}'), ('\u{1e18}',
        '\u{1e18}'), ('\u{1e1a}', '\u{1e1a}'), ('\u{1e1c}', '\u{1e1c}'), ('\u{1e1e}', '\u{1e1e}'),
        ('\u{1e20}', '\u{1e20}'), ('\u{1e22}', '\u{1e22}'), ('\u{1e24}', '\u{1e24}'), ('\u{1e26}',
        '\u{1e26}'), ('\u{1e28}', '\u{1e28}'), ('\u{1e2a}', '\u{1e2a}'), ('\u{1e2c}', '\u{1e2c}'),
        ('\u{1e2e}', '\u{1e2e}'), ('\u{1e30}', '\u{1e30}'), ('\u{1e32}', '\u{1e32}'), ('\u{1e34}',
        '\u{1e34}'), ('\u{1e36}', '\u{1e36}'), ('\u{1e38}', '\u{1e38}'), ('\u{1e3a}', '\u{1e3a}'),
        ('\u{1e3c}', '\u{1e3c}'), ('\u{1e3e}', '\u{1e3e}'), ('\u{1e40}', '\u{1e40}'), ('\u{1e42}',
        '\u{1e42}'), ('\u{1e44}', '\u{1e44}'), ('\u{1e46}', '\u{1e46}'), ('\u{1e48}', '\u{1e48}'),
        ('\u{1e4a}', '\u{1e4a}'), ('\u{1e4c}', '\u{1e4c}'), ('\u{1e4e}', '\u{1e4e}'), ('\u{1e50}',
        '\u{1e50}'), ('\u{1e52}', '\u{1e52}'), ('\u{1e54}', '\u{1e54}'), ('\u{1e56}', '\u{1e56}'),
        ('\u{1e58}', '\u{1e58}'), ('\u{1e5a}', '\u{1e5a}'), ('\u{1e5c}', '\u{1e5c}'), ('\u{1e5e}',
        '\u{1e5e}'), ('\u{1e60}', '\u{1e60}'), ('\u{1e62}', '\u{1e62}'), ('\u{1e64}', '\u{1e64}'),
        ('\u{1e66}', '\u{1e66}'), ('\u{1e68}', '\u{1e68}'), ('\u{1e6a}', '\u{1e6a}'), ('\u{1e6c}',
        '\u{1e6c}'), ('\u{1e6e}', '\u{1e6e}'), ('\u{1e70}', '\u{1e70}'), ('\u{1e72}', '\u{1e72}'),
        ('\u{1e74}', '\u{1e74}'), ('\u{1e76}', '\u{1e76}'), ('\u{1e78}', '\u{1e78}'), ('\u{1e7a}',
        '\u{1e7a}'), ('\u{1e7c}', '\u{1e7c}'), ('\u{1e7e}', '\u{1e7e}'), ('\u{1e80}', '\u{1e80}'),
        ('\u{1e82}', '\u{1e82}'), ('\u{1e84}', '\u{1e84}'), ('\u{1e86}', '\u{1e86}'), ('\u{1e88}',
        '\u{1e88}'), ('\u{1e8a}', '\u{1e8a}'), ('\u{1e8c}', '\u{1e8c}'), ('\u{1e8e}', '\u{1e8e}'),
        ('\u{1e90}', '\u{1e90}'), ('\u{1e92}', '\u{1e92}'), ('\u{1e94}', '\u{1e94}'), ('\u{1e9e}',
        '\u{1e9e}'), ('\u{1ea0}', '\u{1ea0}'), ('\u{1ea2}', '\u{1ea2}'), ('\u{1ea4}', '\u{1ea4}'),
        ('\u{1ea6}', '\u{1ea6}'), ('\u{1ea8}', '\u{1ea8}'), ('\u{1eaa}', '\u{1eaa}'), ('\u{1eac}',
        '\u{1eac}'), ('\u{1eae}', '\u{1eae}'), ('\u{1eb0}', '\u{1eb0}'), ('\u{1eb2}', '\u{1eb2}'),
        ('\u{1eb4}', '\u{1eb4}'), ('\u{1eb6}', '\u{1eb6}'), ('\u{1eb8}', '\u{1eb8}'), ('\u{1eba}',
        '\u{1eba}'), ('\u{1ebc}', '\u{1ebc}'), ('\u{1ebe}', '\u{1ebe}'), ('\u{1ec0}', '\u{1ec0}'),
        ('\u{1ec2}', '\u{1ec2}'), ('\u{1ec4}', '\u{1ec4}'), ('\u{1ec6}', '\u{1ec6}'), ('\u{1ec8}',
        '\u{1ec8}'), ('\u{1eca}', '\u{1eca}'), ('\u{1ecc}', '\u{1ecc}'), ('\u{1ece}', '\u{1ece}'),
        ('\u{1ed0}', '\u{1ed0}'), ('\u{1ed2}', '\u{1ed2}'), ('\u{1ed4}', '\u{1ed4}'), ('\u{1ed6}',
        '\u{1ed6}'), ('\u{1ed8}', '\u{1ed8}'), ('\u{1eda}', '\u{1eda}'), ('\u{1edc}', '\u{1edc}'),
        ('\u{1ede}', '\u{1ede}'), ('\u{1ee0}', '\u{1ee0}'), ('\u{1ee2}', '\u{1ee2}'), ('\u{1ee4}',
        '\u{1ee4}'), ('\u{1ee6}', '\u{1ee6}'), ('\u{1ee8}', '\u{1ee8}'), ('\u{1eea}', '\u{1eea}'),
        ('\u{1eec}', '\u{1eec}'), ('\u{1eee}', '\u{1eee}'), ('\u{1ef0}', '\u{1ef0}'), ('\u{1ef2}',
        '\u{1ef2}'), ('\u{1ef4}', '\u{1ef4}'), ('\u{1ef6}', '\u{1ef6}'), ('\u{1ef8}', '\u{1ef8}'),
        ('\u{1efa}', '\u{1efa}'), ('\u{1efc}', '\u{1efc}'), ('\u{1efe}', '\u{1efe}'), ('\u{1f08}',
        '\u{1f0f}'), ('\u{1f18}', '\u{1f1d}'), ('\u{1f28}', '\u{1f2f}'), ('\u{1f38}', '\u{1f3f}'),
        ('\u{1f48}', '\u{1f4d}'), ('\u{1f59}', '\u{1f59}'), ('\u{1f5b}', '\u{1f5b}'), ('\u{1f5d}',
        '\u{1f5d}'), ('\u{1f5f}', '\u{1f5f}'), ('\u{1f68}', '\u{1f6f}'), ('\u{1fb8}', '\u{1fbb}'),
        ('\u{1fc8}', '\u{1fcb}'), ('\u{1fd8}', '\u{1fdb}'), ('\u{1fe8}', '\u{1fec}'), ('\u{1ff8}',
        '\u{1ffb}'), ('\u{2102}', '\u{2102}'), ('\u{2107}', '\u{2107}'), ('\u{210b}', '\u{210d}'),
        ('\u{2110}', '\u{2112}'), ('\u{2115}', '\u{2115}'), ('\u{2119}', '\u{211d}'), ('\u{2124}',
        '\u{2124}'), ('\u{2126}', '\u{2126}'), ('\u{2128}', '\u{2128}'), ('\u{212a}', '\u{212d}'),
        ('\u{2130}', '\u{2133}'), ('\u{213e}', '\u{213f}'), ('\u{2145}', '\u{2145}'), ('\u{2160}',
        '\u{216f}'), ('\u{2183}', '\u{2183}'), ('\u{24b6}', '\u{24cf}'), ('\u{2c00}', '\u{2c2e}'),
        ('\u{2c60}', '\u{2c60}'), ('\u{2c62}', '\u{2c64}'), ('\u{2c67}', '\u{2c67}'), ('\u{2c69}',
        '\u{2c69}'), ('\u{2c6b}', '\u{2c6b}'), ('\u{2c6d}', '\u{2c70}'), ('\u{2c72}', '\u{2c72}'),
        ('\u{2c75}', '\u{2c75}'), ('\u{2c7e}', '\u{2c80}'), ('\u{2c82}', '\u{2c82}'), ('\u{2c84}',
        '\u{2c84}'), ('\u{2c86}', '\u{2c86}'), ('\u{2c88}', '\u{2c88}'), ('\u{2c8a}', '\u{2c8a}'),
        ('\u{2c8c}', '\u{2c8c}'), ('\u{2c8e}', '\u{2c8e}'), ('\u{2c90}', '\u{2c90}'), ('\u{2c92}',
        '\u{2c92}'), ('\u{2c94}', '\u{2c94}'), ('\u{2c96}', '\u{2c96}'), ('\u{2c98}', '\u{2c98}'),
        ('\u{2c9a}', '\u{2c9a}'), ('\u{2c9c}', '\u{2c9c}'), ('\u{2c9e}', '\u{2c9e}'), ('\u{2ca0}',
        '\u{2ca0}'), ('\u{2ca2}', '\u{2ca2}'), ('\u{2ca4}', '\u{2ca4}'), ('\u{2ca6}', '\u{2ca6}'),
        ('\u{2ca8}', '\u{2ca8}'), ('\u{2caa}', '\u{2caa}'), ('\u{2cac}', '\u{2cac}'), ('\u{2cae}',
        '\u{2cae}'), ('\u{2cb0}', '\u{2cb0}'), ('\u{2cb2}', '\u{2cb2}'), ('\u{2cb4}', '\u{2cb4}'),
        ('\u{2cb6}', '\u{2cb6}'), ('\u{2cb8}', '\u{2cb8}'), ('\u{2cba}', '\u{2cba}'), ('\u{2cbc}',
        '\u{2cbc}'), ('\u{2cbe}', '\u{2cbe}'), ('\u{2cc0}', '\u{2cc0}'), ('\u{2cc2}', '\u{2cc2}'),
        ('\u{2cc4}', '\u{2cc4}'), ('\u{2cc6}', '\u{2cc6}'), ('\u{2cc8}', '\u{2cc8}'), ('\u{2cca}',
        '\u{2cca}'), ('\u{2ccc}', '\u{2ccc}'), ('\u{2cce}', '\u{2cce}'), ('\u{2cd0}', '\u{2cd0}'),
        ('\u{2cd2}', '\u{2cd2}'), ('\u{2cd4}', '\u{2cd4}'), ('\u{2cd6}', '\u{2cd6}'), ('\u{2cd8}',
        '\u{2cd8}'), ('\u{2cda}', '\u{2cda}'), ('\u{2cdc}', '\u{2cdc}'), ('\u{2cde}', '\u{2cde}'),
        ('\u{2ce0}', '\u{2ce0}'), ('\u{2ce2}', '\u{2ce2}'), ('\u{2ceb}', '\u{2ceb}'), ('\u{2ced}',
        '\u{2ced}'), ('\u{2cf2}', '\u{2cf2}'), ('\u{a640}', '\u{a640}'), ('\u{a642}', '\u{a642}'),
        ('\u{a644}', '\u{a644}'), ('\u{a646}', '\u{a646}'), ('\u{a648}', '\u{a648}'), ('\u{a64a}',
        '\u{a64a}'), ('\u{a64c}', '\u{a64c}'), ('\u{a64e}', '\u{a64e}'), ('\u{a650}', '\u{a650}'),
        ('\u{a652}', '\u{a652}'), ('\u{a654}', '\u{a654}'), ('\u{a656}', '\u{a656}'), ('\u{a658}',
        '\u{a658}'), ('\u{a65a}', '\u{a65a}'), ('\u{a65c}', '\u{a65c}'), ('\u{a65e}', '\u{a65e}'),
        ('\u{a660}', '\u{a660}'), ('\u{a662}', '\u{a662}'), ('\u{a664}', '\u{a664}'), ('\u{a666}',
        '\u{a666}'), ('\u{a668}', '\u{a668}'), ('\u{a66a}', '\u{a66a}'), ('\u{a66c}', '\u{a66c}'),
        ('\u{a680}', '\u{a680}'), ('\u{a682}', '\u{a682}'), ('\u{a684}', '\u{a684}'), ('\u{a686}',
        '\u{a686}'), ('\u{a688}', '\u{a688}'), ('\u{a68a}', '\u{a68a}'), ('\u{a68c}', '\u{a68c}'),
        ('\u{a68e}', '\u{a68e}'), ('\u{a690}', '\u{a690}'), ('\u{a692}', '\u{a692}'), ('\u{a694}',
        '\u{a694}'), ('\u{a696}', '\u{a696}'), ('\u{a698}', '\u{a698}'), ('\u{a69a}', '\u{a69a}'),
        ('\u{a722}', '\u{a722}'), ('\u{a724}', '\u{a724}'), ('\u{a726}', '\u{a726}'), ('\u{a728}',
        '\u{a728}'), ('\u{a72a}', '\u{a72a}'), ('\u{a72c}', '\u{a72c}'), ('\u{a72e}', '\u{a72e}'),
        ('\u{a732}', '\u{a732}'), ('\u{a734}', '\u{a734}'), ('\u{a736}', '\u{a736}'), ('\u{a738}',
        '\u{a738}'), ('\u{a73a}', '\u{a73a}'), ('\u{a73c}', '\u{a73c}'), ('\u{a73e}', '\u{a73e}'),
        ('\u{a740}', '\u{a740}'), ('\u{a742}', '\u{a742}'), ('\u{a744}', '\u{a744}'), ('\u{a746}',
        '\u{a746}'), ('\u{a748}', '\u{a748}'), ('\u{a74a}', '\u{a74a}'), ('\u{a74c}', '\u{a74c}'),
        ('\u{a74e}', '\u{a74e}'), ('\u{a750}', '\u{a750}'), ('\u{a752}', '\u{a752}'), ('\u{a754}',
        '\u{a754}'), ('\u{a756}', '\u{a756}'), ('\u{a758}', '\u{a758}'), ('\u{a75a}', '\u{a75a}'),
        ('\u{a75c}', '\u{a75c}'), ('\u{a75e}', '\u{a75e}'), ('\u{a760}', '\u{a760}'), ('\u{a762}',
        '\u{a762}'), ('\u{a764}', '\u{a764}'), ('\u{a766}', '\u{a766}'), ('\u{a768}', '\u{a768}'),
        ('\u{a76a}', '\u{a76a}'), ('\u{a76c}', '\u{a76c}'), ('\u{a76e}', '\u{a76e}'), ('\u{a779}',
        '\u{a779}'), ('\u{a77b}', '\u{a77b}'), ('\u{a77d}', '\u{a77e}'), ('\u{a780}', '\u{a780}'),
        ('\u{a782}', '\u{a782}'), ('\u{a784}', '\u{a784}'), ('\u{a786}', '\u{a786}'), ('\u{a78b}',
        '\u{a78b}'), ('\u{a78d}', '\u{a78d}'), ('\u{a790}', '\u{a790}'), ('\u{a792}', '\u{a792}'),
        ('\u{a796}', '\u{a796}'), ('\u{a798}', '\u{a798}'), ('\u{a79a}', '\u{a79a}'), ('\u{a79c}',
        '\u{a79c}'), ('\u{a79e}', '\u{a79e}'), ('\u{a7a0}', '\u{a7a0}'), ('\u{a7a2}', '\u{a7a2}'),
        ('\u{a7a4}', '\u{a7a4}'), ('\u{a7a6}', '\u{a7a6}'), ('\u{a7a8}', '\u{a7a8}'), ('\u{a7aa}',
        '\u{a7ad}'), ('\u{a7b0}', '\u{a7b1}'), ('\u{ff21}', '\u{ff3a}'), ('\u{10400}', '\u{10427}'),
        ('\u{118a0}', '\u{118bf}'), ('\u{1d400}', '\u{1d419}'), ('\u{1d434}', '\u{1d44d}'),
        ('\u{1d468}', '\u{1d481}'), ('\u{1d49c}', '\u{1d49c}'), ('\u{1d49e}', '\u{1d49f}'),
        ('\u{1d4a2}', '\u{1d4a2}'), ('\u{1d4a5}', '\u{1d4a6}'), ('\u{1d4a9}', '\u{1d4ac}'),
        ('\u{1d4ae}', '\u{1d4b5}'), ('\u{1d4d0}', '\u{1d4e9}'), ('\u{1d504}', '\u{1d505}'),
        ('\u{1d507}', '\u{1d50a}'), ('\u{1d50d}', '\u{1d514}'), ('\u{1d516}', '\u{1d51c}'),
        ('\u{1d538}', '\u{1d539}'), ('\u{1d53b}', '\u{1d53e}'), ('\u{1d540}', '\u{1d544}'),
        ('\u{1d546}', '\u{1d546}'), ('\u{1d54a}', '\u{1d550}'), ('\u{1d56c}', '\u{1d585}'),
        ('\u{1d5a0}', '\u{1d5b9}'), ('\u{1d5d4}', '\u{1d5ed}'), ('\u{1d608}', '\u{1d621}'),
        ('\u{1d63c}', '\u{1d655}'), ('\u{1d670}', '\u{1d689}'), ('\u{1d6a8}', '\u{1d6c0}'),
        ('\u{1d6e2}', '\u{1d6fa}'), ('\u{1d71c}', '\u{1d734}'), ('\u{1d756}', '\u{1d76e}'),
        ('\u{1d790}', '\u{1d7a8}'), ('\u{1d7ca}', '\u{1d7ca}'), ('\u{1f130}', '\u{1f149}'),
        ('\u{1f150}', '\u{1f169}'), ('\u{1f170}', '\u{1f189}')
    ];

    pub fn Uppercase(c: char) -> bool {
        super::bsearch_range_table(c, Uppercase_table)
    }

    pub static XID_Continue_table: &'static [(char, char)] = &[
        ('\u{30}', '\u{39}'), ('\u{41}', '\u{5a}'), ('\u{5f}', '\u{5f}'), ('\u{61}', '\u{7a}'),
        ('\u{aa}', '\u{aa}'), ('\u{b5}', '\u{b5}'), ('\u{b7}', '\u{b7}'), ('\u{ba}', '\u{ba}'),
        ('\u{c0}', '\u{d6}'), ('\u{d8}', '\u{f6}'), ('\u{f8}', '\u{1ba}'), ('\u{1bb}', '\u{1bb}'),
        ('\u{1bc}', '\u{1bf}'), ('\u{1c0}', '\u{1c3}'), ('\u{1c4}', '\u{293}'), ('\u{294}',
        '\u{294}'), ('\u{295}', '\u{2af}'), ('\u{2b0}', '\u{2c1}'), ('\u{2c6}', '\u{2d1}'),
        ('\u{2e0}', '\u{2e4}'), ('\u{2ec}', '\u{2ec}'), ('\u{2ee}', '\u{2ee}'), ('\u{300}',
        '\u{36f}'), ('\u{370}', '\u{373}'), ('\u{374}', '\u{374}'), ('\u{376}', '\u{377}'),
        ('\u{37b}', '\u{37d}'), ('\u{37f}', '\u{37f}'), ('\u{386}', '\u{386}'), ('\u{387}',
        '\u{387}'), ('\u{388}', '\u{38a}'), ('\u{38c}', '\u{38c}'), ('\u{38e}', '\u{3a1}'),
        ('\u{3a3}', '\u{3f5}'), ('\u{3f7}', '\u{481}'), ('\u{483}', '\u{487}'), ('\u{48a}',
        '\u{52f}'), ('\u{531}', '\u{556}'), ('\u{559}', '\u{559}'), ('\u{561}', '\u{587}'),
        ('\u{591}', '\u{5bd}'), ('\u{5bf}', '\u{5bf}'), ('\u{5c1}', '\u{5c2}'), ('\u{5c4}',
        '\u{5c5}'), ('\u{5c7}', '\u{5c7}'), ('\u{5d0}', '\u{5ea}'), ('\u{5f0}', '\u{5f2}'),
        ('\u{610}', '\u{61a}'), ('\u{620}', '\u{63f}'), ('\u{640}', '\u{640}'), ('\u{641}',
        '\u{64a}'), ('\u{64b}', '\u{65f}'), ('\u{660}', '\u{669}'), ('\u{66e}', '\u{66f}'),
        ('\u{670}', '\u{670}'), ('\u{671}', '\u{6d3}'), ('\u{6d5}', '\u{6d5}'), ('\u{6d6}',
        '\u{6dc}'), ('\u{6df}', '\u{6e4}'), ('\u{6e5}', '\u{6e6}'), ('\u{6e7}', '\u{6e8}'),
        ('\u{6ea}', '\u{6ed}'), ('\u{6ee}', '\u{6ef}'), ('\u{6f0}', '\u{6f9}'), ('\u{6fa}',
        '\u{6fc}'), ('\u{6ff}', '\u{6ff}'), ('\u{710}', '\u{710}'), ('\u{711}', '\u{711}'),
        ('\u{712}', '\u{72f}'), ('\u{730}', '\u{74a}'), ('\u{74d}', '\u{7a5}'), ('\u{7a6}',
        '\u{7b0}'), ('\u{7b1}', '\u{7b1}'), ('\u{7c0}', '\u{7c9}'), ('\u{7ca}', '\u{7ea}'),
        ('\u{7eb}', '\u{7f3}'), ('\u{7f4}', '\u{7f5}'), ('\u{7fa}', '\u{7fa}'), ('\u{800}',
        '\u{815}'), ('\u{816}', '\u{819}'), ('\u{81a}', '\u{81a}'), ('\u{81b}', '\u{823}'),
        ('\u{824}', '\u{824}'), ('\u{825}', '\u{827}'), ('\u{828}', '\u{828}'), ('\u{829}',
        '\u{82d}'), ('\u{840}', '\u{858}'), ('\u{859}', '\u{85b}'), ('\u{8a0}', '\u{8b2}'),
        ('\u{8e4}', '\u{902}'), ('\u{903}', '\u{903}'), ('\u{904}', '\u{939}'), ('\u{93a}',
        '\u{93a}'), ('\u{93b}', '\u{93b}'), ('\u{93c}', '\u{93c}'), ('\u{93d}', '\u{93d}'),
        ('\u{93e}', '\u{940}'), ('\u{941}', '\u{948}'), ('\u{949}', '\u{94c}'), ('\u{94d}',
        '\u{94d}'), ('\u{94e}', '\u{94f}'), ('\u{950}', '\u{950}'), ('\u{951}', '\u{957}'),
        ('\u{958}', '\u{961}'), ('\u{962}', '\u{963}'), ('\u{966}', '\u{96f}'), ('\u{971}',
        '\u{971}'), ('\u{972}', '\u{980}'), ('\u{981}', '\u{981}'), ('\u{982}', '\u{983}'),
        ('\u{985}', '\u{98c}'), ('\u{98f}', '\u{990}'), ('\u{993}', '\u{9a8}'), ('\u{9aa}',
        '\u{9b0}'), ('\u{9b2}', '\u{9b2}'), ('\u{9b6}', '\u{9b9}'), ('\u{9bc}', '\u{9bc}'),
        ('\u{9bd}', '\u{9bd}'), ('\u{9be}', '\u{9c0}'), ('\u{9c1}', '\u{9c4}'), ('\u{9c7}',
        '\u{9c8}'), ('\u{9cb}', '\u{9cc}'), ('\u{9cd}', '\u{9cd}'), ('\u{9ce}', '\u{9ce}'),
        ('\u{9d7}', '\u{9d7}'), ('\u{9dc}', '\u{9dd}'), ('\u{9df}', '\u{9e1}'), ('\u{9e2}',
        '\u{9e3}'), ('\u{9e6}', '\u{9ef}'), ('\u{9f0}', '\u{9f1}'), ('\u{a01}', '\u{a02}'),
        ('\u{a03}', '\u{a03}'), ('\u{a05}', '\u{a0a}'), ('\u{a0f}', '\u{a10}'), ('\u{a13}',
        '\u{a28}'), ('\u{a2a}', '\u{a30}'), ('\u{a32}', '\u{a33}'), ('\u{a35}', '\u{a36}'),
        ('\u{a38}', '\u{a39}'), ('\u{a3c}', '\u{a3c}'), ('\u{a3e}', '\u{a40}'), ('\u{a41}',
        '\u{a42}'), ('\u{a47}', '\u{a48}'), ('\u{a4b}', '\u{a4d}'), ('\u{a51}', '\u{a51}'),
        ('\u{a59}', '\u{a5c}'), ('\u{a5e}', '\u{a5e}'), ('\u{a66}', '\u{a6f}'), ('\u{a70}',
        '\u{a71}'), ('\u{a72}', '\u{a74}'), ('\u{a75}', '\u{a75}'), ('\u{a81}', '\u{a82}'),
        ('\u{a83}', '\u{a83}'), ('\u{a85}', '\u{a8d}'), ('\u{a8f}', '\u{a91}'), ('\u{a93}',
        '\u{aa8}'), ('\u{aaa}', '\u{ab0}'), ('\u{ab2}', '\u{ab3}'), ('\u{ab5}', '\u{ab9}'),
        ('\u{abc}', '\u{abc}'), ('\u{abd}', '\u{abd}'), ('\u{abe}', '\u{ac0}'), ('\u{ac1}',
        '\u{ac5}'), ('\u{ac7}', '\u{ac8}'), ('\u{ac9}', '\u{ac9}'), ('\u{acb}', '\u{acc}'),
        ('\u{acd}', '\u{acd}'), ('\u{ad0}', '\u{ad0}'), ('\u{ae0}', '\u{ae1}'), ('\u{ae2}',
        '\u{ae3}'), ('\u{ae6}', '\u{aef}'), ('\u{b01}', '\u{b01}'), ('\u{b02}', '\u{b03}'),
        ('\u{b05}', '\u{b0c}'), ('\u{b0f}', '\u{b10}'), ('\u{b13}', '\u{b28}'), ('\u{b2a}',
        '\u{b30}'), ('\u{b32}', '\u{b33}'), ('\u{b35}', '\u{b39}'), ('\u{b3c}', '\u{b3c}'),
        ('\u{b3d}', '\u{b3d}'), ('\u{b3e}', '\u{b3e}'), ('\u{b3f}', '\u{b3f}'), ('\u{b40}',
        '\u{b40}'), ('\u{b41}', '\u{b44}'), ('\u{b47}', '\u{b48}'), ('\u{b4b}', '\u{b4c}'),
        ('\u{b4d}', '\u{b4d}'), ('\u{b56}', '\u{b56}'), ('\u{b57}', '\u{b57}'), ('\u{b5c}',
        '\u{b5d}'), ('\u{b5f}', '\u{b61}'), ('\u{b62}', '\u{b63}'), ('\u{b66}', '\u{b6f}'),
        ('\u{b71}', '\u{b71}'), ('\u{b82}', '\u{b82}'), ('\u{b83}', '\u{b83}'), ('\u{b85}',
        '\u{b8a}'), ('\u{b8e}', '\u{b90}'), ('\u{b92}', '\u{b95}'), ('\u{b99}', '\u{b9a}'),
        ('\u{b9c}', '\u{b9c}'), ('\u{b9e}', '\u{b9f}'), ('\u{ba3}', '\u{ba4}'), ('\u{ba8}',
        '\u{baa}'), ('\u{bae}', '\u{bb9}'), ('\u{bbe}', '\u{bbf}'), ('\u{bc0}', '\u{bc0}'),
        ('\u{bc1}', '\u{bc2}'), ('\u{bc6}', '\u{bc8}'), ('\u{bca}', '\u{bcc}'), ('\u{bcd}',
        '\u{bcd}'), ('\u{bd0}', '\u{bd0}'), ('\u{bd7}', '\u{bd7}'), ('\u{be6}', '\u{bef}'),
        ('\u{c00}', '\u{c00}'), ('\u{c01}', '\u{c03}'), ('\u{c05}', '\u{c0c}'), ('\u{c0e}',
        '\u{c10}'), ('\u{c12}', '\u{c28}'), ('\u{c2a}', '\u{c39}'), ('\u{c3d}', '\u{c3d}'),
        ('\u{c3e}', '\u{c40}'), ('\u{c41}', '\u{c44}'), ('\u{c46}', '\u{c48}'), ('\u{c4a}',
        '\u{c4d}'), ('\u{c55}', '\u{c56}'), ('\u{c58}', '\u{c59}'), ('\u{c60}', '\u{c61}'),
        ('\u{c62}', '\u{c63}'), ('\u{c66}', '\u{c6f}'), ('\u{c81}', '\u{c81}'), ('\u{c82}',
        '\u{c83}'), ('\u{c85}', '\u{c8c}'), ('\u{c8e}', '\u{c90}'), ('\u{c92}', '\u{ca8}'),
        ('\u{caa}', '\u{cb3}'), ('\u{cb5}', '\u{cb9}'), ('\u{cbc}', '\u{cbc}'), ('\u{cbd}',
        '\u{cbd}'), ('\u{cbe}', '\u{cbe}'), ('\u{cbf}', '\u{cbf}'), ('\u{cc0}', '\u{cc4}'),
        ('\u{cc6}', '\u{cc6}'), ('\u{cc7}', '\u{cc8}'), ('\u{cca}', '\u{ccb}'), ('\u{ccc}',
        '\u{ccd}'), ('\u{cd5}', '\u{cd6}'), ('\u{cde}', '\u{cde}'), ('\u{ce0}', '\u{ce1}'),
        ('\u{ce2}', '\u{ce3}'), ('\u{ce6}', '\u{cef}'), ('\u{cf1}', '\u{cf2}'), ('\u{d01}',
        '\u{d01}'), ('\u{d02}', '\u{d03}'), ('\u{d05}', '\u{d0c}'), ('\u{d0e}', '\u{d10}'),
        ('\u{d12}', '\u{d3a}'), ('\u{d3d}', '\u{d3d}'), ('\u{d3e}', '\u{d40}'), ('\u{d41}',
        '\u{d44}'), ('\u{d46}', '\u{d48}'), ('\u{d4a}', '\u{d4c}'), ('\u{d4d}', '\u{d4d}'),
        ('\u{d4e}', '\u{d4e}'), ('\u{d57}', '\u{d57}'), ('\u{d60}', '\u{d61}'), ('\u{d62}',
        '\u{d63}'), ('\u{d66}', '\u{d6f}'), ('\u{d7a}', '\u{d7f}'), ('\u{d82}', '\u{d83}'),
        ('\u{d85}', '\u{d96}'), ('\u{d9a}', '\u{db1}'), ('\u{db3}', '\u{dbb}'), ('\u{dbd}',
        '\u{dbd}'), ('\u{dc0}', '\u{dc6}'), ('\u{dca}', '\u{dca}'), ('\u{dcf}', '\u{dd1}'),
        ('\u{dd2}', '\u{dd4}'), ('\u{dd6}', '\u{dd6}'), ('\u{dd8}', '\u{ddf}'), ('\u{de6}',
        '\u{def}'), ('\u{df2}', '\u{df3}'), ('\u{e01}', '\u{e30}'), ('\u{e31}', '\u{e31}'),
        ('\u{e32}', '\u{e33}'), ('\u{e34}', '\u{e3a}'), ('\u{e40}', '\u{e45}'), ('\u{e46}',
        '\u{e46}'), ('\u{e47}', '\u{e4e}'), ('\u{e50}', '\u{e59}'), ('\u{e81}', '\u{e82}'),
        ('\u{e84}', '\u{e84}'), ('\u{e87}', '\u{e88}'), ('\u{e8a}', '\u{e8a}'), ('\u{e8d}',
        '\u{e8d}'), ('\u{e94}', '\u{e97}'), ('\u{e99}', '\u{e9f}'), ('\u{ea1}', '\u{ea3}'),
        ('\u{ea5}', '\u{ea5}'), ('\u{ea7}', '\u{ea7}'), ('\u{eaa}', '\u{eab}'), ('\u{ead}',
        '\u{eb0}'), ('\u{eb1}', '\u{eb1}'), ('\u{eb2}', '\u{eb3}'), ('\u{eb4}', '\u{eb9}'),
        ('\u{ebb}', '\u{ebc}'), ('\u{ebd}', '\u{ebd}'), ('\u{ec0}', '\u{ec4}'), ('\u{ec6}',
        '\u{ec6}'), ('\u{ec8}', '\u{ecd}'), ('\u{ed0}', '\u{ed9}'), ('\u{edc}', '\u{edf}'),
        ('\u{f00}', '\u{f00}'), ('\u{f18}', '\u{f19}'), ('\u{f20}', '\u{f29}'), ('\u{f35}',
        '\u{f35}'), ('\u{f37}', '\u{f37}'), ('\u{f39}', '\u{f39}'), ('\u{f3e}', '\u{f3f}'),
        ('\u{f40}', '\u{f47}'), ('\u{f49}', '\u{f6c}'), ('\u{f71}', '\u{f7e}'), ('\u{f7f}',
        '\u{f7f}'), ('\u{f80}', '\u{f84}'), ('\u{f86}', '\u{f87}'), ('\u{f88}', '\u{f8c}'),
        ('\u{f8d}', '\u{f97}'), ('\u{f99}', '\u{fbc}'), ('\u{fc6}', '\u{fc6}'), ('\u{1000}',
        '\u{102a}'), ('\u{102b}', '\u{102c}'), ('\u{102d}', '\u{1030}'), ('\u{1031}', '\u{1031}'),
        ('\u{1032}', '\u{1037}'), ('\u{1038}', '\u{1038}'), ('\u{1039}', '\u{103a}'), ('\u{103b}',
        '\u{103c}'), ('\u{103d}', '\u{103e}'), ('\u{103f}', '\u{103f}'), ('\u{1040}', '\u{1049}'),
        ('\u{1050}', '\u{1055}'), ('\u{1056}', '\u{1057}'), ('\u{1058}', '\u{1059}'), ('\u{105a}',
        '\u{105d}'), ('\u{105e}', '\u{1060}'), ('\u{1061}', '\u{1061}'), ('\u{1062}', '\u{1064}'),
        ('\u{1065}', '\u{1066}'), ('\u{1067}', '\u{106d}'), ('\u{106e}', '\u{1070}'), ('\u{1071}',
        '\u{1074}'), ('\u{1075}', '\u{1081}'), ('\u{1082}', '\u{1082}'), ('\u{1083}', '\u{1084}'),
        ('\u{1085}', '\u{1086}'), ('\u{1087}', '\u{108c}'), ('\u{108d}', '\u{108d}'), ('\u{108e}',
        '\u{108e}'), ('\u{108f}', '\u{108f}'), ('\u{1090}', '\u{1099}'), ('\u{109a}', '\u{109c}'),
        ('\u{109d}', '\u{109d}'), ('\u{10a0}', '\u{10c5}'), ('\u{10c7}', '\u{10c7}'), ('\u{10cd}',
        '\u{10cd}'), ('\u{10d0}', '\u{10fa}'), ('\u{10fc}', '\u{10fc}'), ('\u{10fd}', '\u{1248}'),
        ('\u{124a}', '\u{124d}'), ('\u{1250}', '\u{1256}'), ('\u{1258}', '\u{1258}'), ('\u{125a}',
        '\u{125d}'), ('\u{1260}', '\u{1288}'), ('\u{128a}', '\u{128d}'), ('\u{1290}', '\u{12b0}'),
        ('\u{12b2}', '\u{12b5}'), ('\u{12b8}', '\u{12be}'), ('\u{12c0}', '\u{12c0}'), ('\u{12c2}',
        '\u{12c5}'), ('\u{12c8}', '\u{12d6}'), ('\u{12d8}', '\u{1310}'), ('\u{1312}', '\u{1315}'),
        ('\u{1318}', '\u{135a}'), ('\u{135d}', '\u{135f}'), ('\u{1369}', '\u{1371}'), ('\u{1380}',
        '\u{138f}'), ('\u{13a0}', '\u{13f4}'), ('\u{1401}', '\u{166c}'), ('\u{166f}', '\u{167f}'),
        ('\u{1681}', '\u{169a}'), ('\u{16a0}', '\u{16ea}'), ('\u{16ee}', '\u{16f0}'), ('\u{16f1}',
        '\u{16f8}'), ('\u{1700}', '\u{170c}'), ('\u{170e}', '\u{1711}'), ('\u{1712}', '\u{1714}'),
        ('\u{1720}', '\u{1731}'), ('\u{1732}', '\u{1734}'), ('\u{1740}', '\u{1751}'), ('\u{1752}',
        '\u{1753}'), ('\u{1760}', '\u{176c}'), ('\u{176e}', '\u{1770}'), ('\u{1772}', '\u{1773}'),
        ('\u{1780}', '\u{17b3}'), ('\u{17b4}', '\u{17b5}'), ('\u{17b6}', '\u{17b6}'), ('\u{17b7}',
        '\u{17bd}'), ('\u{17be}', '\u{17c5}'), ('\u{17c6}', '\u{17c6}'), ('\u{17c7}', '\u{17c8}'),
        ('\u{17c9}', '\u{17d3}'), ('\u{17d7}', '\u{17d7}'), ('\u{17dc}', '\u{17dc}'), ('\u{17dd}',
        '\u{17dd}'), ('\u{17e0}', '\u{17e9}'), ('\u{180b}', '\u{180d}'), ('\u{1810}', '\u{1819}'),
        ('\u{1820}', '\u{1842}'), ('\u{1843}', '\u{1843}'), ('\u{1844}', '\u{1877}'), ('\u{1880}',
        '\u{18a8}'), ('\u{18a9}', '\u{18a9}'), ('\u{18aa}', '\u{18aa}'), ('\u{18b0}', '\u{18f5}'),
        ('\u{1900}', '\u{191e}'), ('\u{1920}', '\u{1922}'), ('\u{1923}', '\u{1926}'), ('\u{1927}',
        '\u{1928}'), ('\u{1929}', '\u{192b}'), ('\u{1930}', '\u{1931}'), ('\u{1932}', '\u{1932}'),
        ('\u{1933}', '\u{1938}'), ('\u{1939}', '\u{193b}'), ('\u{1946}', '\u{194f}'), ('\u{1950}',
        '\u{196d}'), ('\u{1970}', '\u{1974}'), ('\u{1980}', '\u{19ab}'), ('\u{19b0}', '\u{19c0}'),
        ('\u{19c1}', '\u{19c7}'), ('\u{19c8}', '\u{19c9}'), ('\u{19d0}', '\u{19d9}'), ('\u{19da}',
        '\u{19da}'), ('\u{1a00}', '\u{1a16}'), ('\u{1a17}', '\u{1a18}'), ('\u{1a19}', '\u{1a1a}'),
        ('\u{1a1b}', '\u{1a1b}'), ('\u{1a20}', '\u{1a54}'), ('\u{1a55}', '\u{1a55}'), ('\u{1a56}',
        '\u{1a56}'), ('\u{1a57}', '\u{1a57}'), ('\u{1a58}', '\u{1a5e}'), ('\u{1a60}', '\u{1a60}'),
        ('\u{1a61}', '\u{1a61}'), ('\u{1a62}', '\u{1a62}'), ('\u{1a63}', '\u{1a64}'), ('\u{1a65}',
        '\u{1a6c}'), ('\u{1a6d}', '\u{1a72}'), ('\u{1a73}', '\u{1a7c}'), ('\u{1a7f}', '\u{1a7f}'),
        ('\u{1a80}', '\u{1a89}'), ('\u{1a90}', '\u{1a99}'), ('\u{1aa7}', '\u{1aa7}'), ('\u{1ab0}',
        '\u{1abd}'), ('\u{1b00}', '\u{1b03}'), ('\u{1b04}', '\u{1b04}'), ('\u{1b05}', '\u{1b33}'),
        ('\u{1b34}', '\u{1b34}'), ('\u{1b35}', '\u{1b35}'), ('\u{1b36}', '\u{1b3a}'), ('\u{1b3b}',
        '\u{1b3b}'), ('\u{1b3c}', '\u{1b3c}'), ('\u{1b3d}', '\u{1b41}'), ('\u{1b42}', '\u{1b42}'),
        ('\u{1b43}', '\u{1b44}'), ('\u{1b45}', '\u{1b4b}'), ('\u{1b50}', '\u{1b59}'), ('\u{1b6b}',
        '\u{1b73}'), ('\u{1b80}', '\u{1b81}'), ('\u{1b82}', '\u{1b82}'), ('\u{1b83}', '\u{1ba0}'),
        ('\u{1ba1}', '\u{1ba1}'), ('\u{1ba2}', '\u{1ba5}'), ('\u{1ba6}', '\u{1ba7}'), ('\u{1ba8}',
        '\u{1ba9}'), ('\u{1baa}', '\u{1baa}'), ('\u{1bab}', '\u{1bad}'), ('\u{1bae}', '\u{1baf}'),
        ('\u{1bb0}', '\u{1bb9}'), ('\u{1bba}', '\u{1be5}'), ('\u{1be6}', '\u{1be6}'), ('\u{1be7}',
        '\u{1be7}'), ('\u{1be8}', '\u{1be9}'), ('\u{1bea}', '\u{1bec}'), ('\u{1bed}', '\u{1bed}'),
        ('\u{1bee}', '\u{1bee}'), ('\u{1bef}', '\u{1bf1}'), ('\u{1bf2}', '\u{1bf3}'), ('\u{1c00}',
        '\u{1c23}'), ('\u{1c24}', '\u{1c2b}'), ('\u{1c2c}', '\u{1c33}'), ('\u{1c34}', '\u{1c35}'),
        ('\u{1c36}', '\u{1c37}'), ('\u{1c40}', '\u{1c49}'), ('\u{1c4d}', '\u{1c4f}'), ('\u{1c50}',
        '\u{1c59}'), ('\u{1c5a}', '\u{1c77}'), ('\u{1c78}', '\u{1c7d}'), ('\u{1cd0}', '\u{1cd2}'),
        ('\u{1cd4}', '\u{1ce0}'), ('\u{1ce1}', '\u{1ce1}'), ('\u{1ce2}', '\u{1ce8}'), ('\u{1ce9}',
        '\u{1cec}'), ('\u{1ced}', '\u{1ced}'), ('\u{1cee}', '\u{1cf1}'), ('\u{1cf2}', '\u{1cf3}'),
        ('\u{1cf4}', '\u{1cf4}'), ('\u{1cf5}', '\u{1cf6}'), ('\u{1cf8}', '\u{1cf9}'), ('\u{1d00}',
        '\u{1d2b}'), ('\u{1d2c}', '\u{1d6a}'), ('\u{1d6b}', '\u{1d77}'), ('\u{1d78}', '\u{1d78}'),
        ('\u{1d79}', '\u{1d9a}'), ('\u{1d9b}', '\u{1dbf}'), ('\u{1dc0}', '\u{1df5}'), ('\u{1dfc}',
        '\u{1dff}'), ('\u{1e00}', '\u{1f15}'), ('\u{1f18}', '\u{1f1d}'), ('\u{1f20}', '\u{1f45}'),
        ('\u{1f48}', '\u{1f4d}'), ('\u{1f50}', '\u{1f57}'), ('\u{1f59}', '\u{1f59}'), ('\u{1f5b}',
        '\u{1f5b}'), ('\u{1f5d}', '\u{1f5d}'), ('\u{1f5f}', '\u{1f7d}'), ('\u{1f80}', '\u{1fb4}'),
        ('\u{1fb6}', '\u{1fbc}'), ('\u{1fbe}', '\u{1fbe}'), ('\u{1fc2}', '\u{1fc4}'), ('\u{1fc6}',
        '\u{1fcc}'), ('\u{1fd0}', '\u{1fd3}'), ('\u{1fd6}', '\u{1fdb}'), ('\u{1fe0}', '\u{1fec}'),
        ('\u{1ff2}', '\u{1ff4}'), ('\u{1ff6}', '\u{1ffc}'), ('\u{203f}', '\u{2040}'), ('\u{2054}',
        '\u{2054}'), ('\u{2071}', '\u{2071}'), ('\u{207f}', '\u{207f}'), ('\u{2090}', '\u{209c}'),
        ('\u{20d0}', '\u{20dc}'), ('\u{20e1}', '\u{20e1}'), ('\u{20e5}', '\u{20f0}'), ('\u{2102}',
        '\u{2102}'), ('\u{2107}', '\u{2107}'), ('\u{210a}', '\u{2113}'), ('\u{2115}', '\u{2115}'),
        ('\u{2118}', '\u{2118}'), ('\u{2119}', '\u{211d}'), ('\u{2124}', '\u{2124}'), ('\u{2126}',
        '\u{2126}'), ('\u{2128}', '\u{2128}'), ('\u{212a}', '\u{212d}'), ('\u{212e}', '\u{212e}'),
        ('\u{212f}', '\u{2134}'), ('\u{2135}', '\u{2138}'), ('\u{2139}', '\u{2139}'), ('\u{213c}',
        '\u{213f}'), ('\u{2145}', '\u{2149}'), ('\u{214e}', '\u{214e}'), ('\u{2160}', '\u{2182}'),
        ('\u{2183}', '\u{2184}'), ('\u{2185}', '\u{2188}'), ('\u{2c00}', '\u{2c2e}'), ('\u{2c30}',
        '\u{2c5e}'), ('\u{2c60}', '\u{2c7b}'), ('\u{2c7c}', '\u{2c7d}'), ('\u{2c7e}', '\u{2ce4}'),
        ('\u{2ceb}', '\u{2cee}'), ('\u{2cef}', '\u{2cf1}'), ('\u{2cf2}', '\u{2cf3}'), ('\u{2d00}',
        '\u{2d25}'), ('\u{2d27}', '\u{2d27}'), ('\u{2d2d}', '\u{2d2d}'), ('\u{2d30}', '\u{2d67}'),
        ('\u{2d6f}', '\u{2d6f}'), ('\u{2d7f}', '\u{2d7f}'), ('\u{2d80}', '\u{2d96}'), ('\u{2da0}',
        '\u{2da6}'), ('\u{2da8}', '\u{2dae}'), ('\u{2db0}', '\u{2db6}'), ('\u{2db8}', '\u{2dbe}'),
        ('\u{2dc0}', '\u{2dc6}'), ('\u{2dc8}', '\u{2dce}'), ('\u{2dd0}', '\u{2dd6}'), ('\u{2dd8}',
        '\u{2dde}'), ('\u{2de0}', '\u{2dff}'), ('\u{3005}', '\u{3005}'), ('\u{3006}', '\u{3006}'),
        ('\u{3007}', '\u{3007}'), ('\u{3021}', '\u{3029}'), ('\u{302a}', '\u{302d}'), ('\u{302e}',
        '\u{302f}'), ('\u{3031}', '\u{3035}'), ('\u{3038}', '\u{303a}'), ('\u{303b}', '\u{303b}'),
        ('\u{303c}', '\u{303c}'), ('\u{3041}', '\u{3096}'), ('\u{3099}', '\u{309a}'), ('\u{309d}',
        '\u{309e}'), ('\u{309f}', '\u{309f}'), ('\u{30a1}', '\u{30fa}'), ('\u{30fc}', '\u{30fe}'),
        ('\u{30ff}', '\u{30ff}'), ('\u{3105}', '\u{312d}'), ('\u{3131}', '\u{318e}'), ('\u{31a0}',
        '\u{31ba}'), ('\u{31f0}', '\u{31ff}'), ('\u{3400}', '\u{4db5}'), ('\u{4e00}', '\u{9fcc}'),
        ('\u{a000}', '\u{a014}'), ('\u{a015}', '\u{a015}'), ('\u{a016}', '\u{a48c}'), ('\u{a4d0}',
        '\u{a4f7}'), ('\u{a4f8}', '\u{a4fd}'), ('\u{a500}', '\u{a60b}'), ('\u{a60c}', '\u{a60c}'),
        ('\u{a610}', '\u{a61f}'), ('\u{a620}', '\u{a629}'), ('\u{a62a}', '\u{a62b}'), ('\u{a640}',
        '\u{a66d}'), ('\u{a66e}', '\u{a66e}'), ('\u{a66f}', '\u{a66f}'), ('\u{a674}', '\u{a67d}'),
        ('\u{a67f}', '\u{a67f}'), ('\u{a680}', '\u{a69b}'), ('\u{a69c}', '\u{a69d}'), ('\u{a69f}',
        '\u{a69f}'), ('\u{a6a0}', '\u{a6e5}'), ('\u{a6e6}', '\u{a6ef}'), ('\u{a6f0}', '\u{a6f1}'),
        ('\u{a717}', '\u{a71f}'), ('\u{a722}', '\u{a76f}'), ('\u{a770}', '\u{a770}'), ('\u{a771}',
        '\u{a787}'), ('\u{a788}', '\u{a788}'), ('\u{a78b}', '\u{a78e}'), ('\u{a790}', '\u{a7ad}'),
        ('\u{a7b0}', '\u{a7b1}'), ('\u{a7f7}', '\u{a7f7}'), ('\u{a7f8}', '\u{a7f9}'), ('\u{a7fa}',
        '\u{a7fa}'), ('\u{a7fb}', '\u{a801}'), ('\u{a802}', '\u{a802}'), ('\u{a803}', '\u{a805}'),
        ('\u{a806}', '\u{a806}'), ('\u{a807}', '\u{a80a}'), ('\u{a80b}', '\u{a80b}'), ('\u{a80c}',
        '\u{a822}'), ('\u{a823}', '\u{a824}'), ('\u{a825}', '\u{a826}'), ('\u{a827}', '\u{a827}'),
        ('\u{a840}', '\u{a873}'), ('\u{a880}', '\u{a881}'), ('\u{a882}', '\u{a8b3}'), ('\u{a8b4}',
        '\u{a8c3}'), ('\u{a8c4}', '\u{a8c4}'), ('\u{a8d0}', '\u{a8d9}'), ('\u{a8e0}', '\u{a8f1}'),
        ('\u{a8f2}', '\u{a8f7}'), ('\u{a8fb}', '\u{a8fb}'), ('\u{a900}', '\u{a909}'), ('\u{a90a}',
        '\u{a925}'), ('\u{a926}', '\u{a92d}'), ('\u{a930}', '\u{a946}'), ('\u{a947}', '\u{a951}'),
        ('\u{a952}', '\u{a953}'), ('\u{a960}', '\u{a97c}'), ('\u{a980}', '\u{a982}'), ('\u{a983}',
        '\u{a983}'), ('\u{a984}', '\u{a9b2}'), ('\u{a9b3}', '\u{a9b3}'), ('\u{a9b4}', '\u{a9b5}'),
        ('\u{a9b6}', '\u{a9b9}'), ('\u{a9ba}', '\u{a9bb}'), ('\u{a9bc}', '\u{a9bc}'), ('\u{a9bd}',
        '\u{a9c0}'), ('\u{a9cf}', '\u{a9cf}'), ('\u{a9d0}', '\u{a9d9}'), ('\u{a9e0}', '\u{a9e4}'),
        ('\u{a9e5}', '\u{a9e5}'), ('\u{a9e6}', '\u{a9e6}'), ('\u{a9e7}', '\u{a9ef}'), ('\u{a9f0}',
        '\u{a9f9}'), ('\u{a9fa}', '\u{a9fe}'), ('\u{aa00}', '\u{aa28}'), ('\u{aa29}', '\u{aa2e}'),
        ('\u{aa2f}', '\u{aa30}'), ('\u{aa31}', '\u{aa32}'), ('\u{aa33}', '\u{aa34}'), ('\u{aa35}',
        '\u{aa36}'), ('\u{aa40}', '\u{aa42}'), ('\u{aa43}', '\u{aa43}'), ('\u{aa44}', '\u{aa4b}'),
        ('\u{aa4c}', '\u{aa4c}'), ('\u{aa4d}', '\u{aa4d}'), ('\u{aa50}', '\u{aa59}'), ('\u{aa60}',
        '\u{aa6f}'), ('\u{aa70}', '\u{aa70}'), ('\u{aa71}', '\u{aa76}'), ('\u{aa7a}', '\u{aa7a}'),
        ('\u{aa7b}', '\u{aa7b}'), ('\u{aa7c}', '\u{aa7c}'), ('\u{aa7d}', '\u{aa7d}'), ('\u{aa7e}',
        '\u{aaaf}'), ('\u{aab0}', '\u{aab0}'), ('\u{aab1}', '\u{aab1}'), ('\u{aab2}', '\u{aab4}'),
        ('\u{aab5}', '\u{aab6}'), ('\u{aab7}', '\u{aab8}'), ('\u{aab9}', '\u{aabd}'), ('\u{aabe}',
        '\u{aabf}'), ('\u{aac0}', '\u{aac0}'), ('\u{aac1}', '\u{aac1}'), ('\u{aac2}', '\u{aac2}'),
        ('\u{aadb}', '\u{aadc}'), ('\u{aadd}', '\u{aadd}'), ('\u{aae0}', '\u{aaea}'), ('\u{aaeb}',
        '\u{aaeb}'), ('\u{aaec}', '\u{aaed}'), ('\u{aaee}', '\u{aaef}'), ('\u{aaf2}', '\u{aaf2}'),
        ('\u{aaf3}', '\u{aaf4}'), ('\u{aaf5}', '\u{aaf5}'), ('\u{aaf6}', '\u{aaf6}'), ('\u{ab01}',
        '\u{ab06}'), ('\u{ab09}', '\u{ab0e}'), ('\u{ab11}', '\u{ab16}'), ('\u{ab20}', '\u{ab26}'),
        ('\u{ab28}', '\u{ab2e}'), ('\u{ab30}', '\u{ab5a}'), ('\u{ab5c}', '\u{ab5f}'), ('\u{ab64}',
        '\u{ab65}'), ('\u{abc0}', '\u{abe2}'), ('\u{abe3}', '\u{abe4}'), ('\u{abe5}', '\u{abe5}'),
        ('\u{abe6}', '\u{abe7}'), ('\u{abe8}', '\u{abe8}'), ('\u{abe9}', '\u{abea}'), ('\u{abec}',
        '\u{abec}'), ('\u{abed}', '\u{abed}'), ('\u{abf0}', '\u{abf9}'), ('\u{ac00}', '\u{d7a3}'),
        ('\u{d7b0}', '\u{d7c6}'), ('\u{d7cb}', '\u{d7fb}'), ('\u{f900}', '\u{fa6d}'), ('\u{fa70}',
        '\u{fad9}'), ('\u{fb00}', '\u{fb06}'), ('\u{fb13}', '\u{fb17}'), ('\u{fb1d}', '\u{fb1d}'),
        ('\u{fb1e}', '\u{fb1e}'), ('\u{fb1f}', '\u{fb28}'), ('\u{fb2a}', '\u{fb36}'), ('\u{fb38}',
        '\u{fb3c}'), ('\u{fb3e}', '\u{fb3e}'), ('\u{fb40}', '\u{fb41}'), ('\u{fb43}', '\u{fb44}'),
        ('\u{fb46}', '\u{fbb1}'), ('\u{fbd3}', '\u{fc5d}'), ('\u{fc64}', '\u{fd3d}'), ('\u{fd50}',
        '\u{fd8f}'), ('\u{fd92}', '\u{fdc7}'), ('\u{fdf0}', '\u{fdf9}'), ('\u{fe00}', '\u{fe0f}'),
        ('\u{fe20}', '\u{fe2d}'), ('\u{fe33}', '\u{fe34}'), ('\u{fe4d}', '\u{fe4f}'), ('\u{fe71}',
        '\u{fe71}'), ('\u{fe73}', '\u{fe73}'), ('\u{fe77}', '\u{fe77}'), ('\u{fe79}', '\u{fe79}'),
        ('\u{fe7b}', '\u{fe7b}'), ('\u{fe7d}', '\u{fe7d}'), ('\u{fe7f}', '\u{fefc}'), ('\u{ff10}',
        '\u{ff19}'), ('\u{ff21}', '\u{ff3a}'), ('\u{ff3f}', '\u{ff3f}'), ('\u{ff41}', '\u{ff5a}'),
        ('\u{ff66}', '\u{ff6f}'), ('\u{ff70}', '\u{ff70}'), ('\u{ff71}', '\u{ff9d}'), ('\u{ff9e}',
        '\u{ff9f}'), ('\u{ffa0}', '\u{ffbe}'), ('\u{ffc2}', '\u{ffc7}'), ('\u{ffca}', '\u{ffcf}'),
        ('\u{ffd2}', '\u{ffd7}'), ('\u{ffda}', '\u{ffdc}'), ('\u{10000}', '\u{1000b}'),
        ('\u{1000d}', '\u{10026}'), ('\u{10028}', '\u{1003a}'), ('\u{1003c}', '\u{1003d}'),
        ('\u{1003f}', '\u{1004d}'), ('\u{10050}', '\u{1005d}'), ('\u{10080}', '\u{100fa}'),
        ('\u{10140}', '\u{10174}'), ('\u{101fd}', '\u{101fd}'), ('\u{10280}', '\u{1029c}'),
        ('\u{102a0}', '\u{102d0}'), ('\u{102e0}', '\u{102e0}'), ('\u{10300}', '\u{1031f}'),
        ('\u{10330}', '\u{10340}'), ('\u{10341}', '\u{10341}'), ('\u{10342}', '\u{10349}'),
        ('\u{1034a}', '\u{1034a}'), ('\u{10350}', '\u{10375}'), ('\u{10376}', '\u{1037a}'),
        ('\u{10380}', '\u{1039d}'), ('\u{103a0}', '\u{103c3}'), ('\u{103c8}', '\u{103cf}'),
        ('\u{103d1}', '\u{103d5}'), ('\u{10400}', '\u{1044f}'), ('\u{10450}', '\u{1049d}'),
        ('\u{104a0}', '\u{104a9}'), ('\u{10500}', '\u{10527}'), ('\u{10530}', '\u{10563}'),
        ('\u{10600}', '\u{10736}'), ('\u{10740}', '\u{10755}'), ('\u{10760}', '\u{10767}'),
        ('\u{10800}', '\u{10805}'), ('\u{10808}', '\u{10808}'), ('\u{1080a}', '\u{10835}'),
        ('\u{10837}', '\u{10838}'), ('\u{1083c}', '\u{1083c}'), ('\u{1083f}', '\u{10855}'),
        ('\u{10860}', '\u{10876}'), ('\u{10880}', '\u{1089e}'), ('\u{10900}', '\u{10915}'),
        ('\u{10920}', '\u{10939}'), ('\u{10980}', '\u{109b7}'), ('\u{109be}', '\u{109bf}'),
        ('\u{10a00}', '\u{10a00}'), ('\u{10a01}', '\u{10a03}'), ('\u{10a05}', '\u{10a06}'),
        ('\u{10a0c}', '\u{10a0f}'), ('\u{10a10}', '\u{10a13}'), ('\u{10a15}', '\u{10a17}'),
        ('\u{10a19}', '\u{10a33}'), ('\u{10a38}', '\u{10a3a}'), ('\u{10a3f}', '\u{10a3f}'),
        ('\u{10a60}', '\u{10a7c}'), ('\u{10a80}', '\u{10a9c}'), ('\u{10ac0}', '\u{10ac7}'),
        ('\u{10ac9}', '\u{10ae4}'), ('\u{10ae5}', '\u{10ae6}'), ('\u{10b00}', '\u{10b35}'),
        ('\u{10b40}', '\u{10b55}'), ('\u{10b60}', '\u{10b72}'), ('\u{10b80}', '\u{10b91}'),
        ('\u{10c00}', '\u{10c48}'), ('\u{11000}', '\u{11000}'), ('\u{11001}', '\u{11001}'),
        ('\u{11002}', '\u{11002}'), ('\u{11003}', '\u{11037}'), ('\u{11038}', '\u{11046}'),
        ('\u{11066}', '\u{1106f}'), ('\u{1107f}', '\u{11081}'), ('\u{11082}', '\u{11082}'),
        ('\u{11083}', '\u{110af}'), ('\u{110b0}', '\u{110b2}'), ('\u{110b3}', '\u{110b6}'),
        ('\u{110b7}', '\u{110b8}'), ('\u{110b9}', '\u{110ba}'), ('\u{110d0}', '\u{110e8}'),
        ('\u{110f0}', '\u{110f9}'), ('\u{11100}', '\u{11102}'), ('\u{11103}', '\u{11126}'),
        ('\u{11127}', '\u{1112b}'), ('\u{1112c}', '\u{1112c}'), ('\u{1112d}', '\u{11134}'),
        ('\u{11136}', '\u{1113f}'), ('\u{11150}', '\u{11172}'), ('\u{11173}', '\u{11173}'),
        ('\u{11176}', '\u{11176}'), ('\u{11180}', '\u{11181}'), ('\u{11182}', '\u{11182}'),
        ('\u{11183}', '\u{111b2}'), ('\u{111b3}', '\u{111b5}'), ('\u{111b6}', '\u{111be}'),
        ('\u{111bf}', '\u{111c0}'), ('\u{111c1}', '\u{111c4}'), ('\u{111d0}', '\u{111d9}'),
        ('\u{111da}', '\u{111da}'), ('\u{11200}', '\u{11211}'), ('\u{11213}', '\u{1122b}'),
        ('\u{1122c}', '\u{1122e}'), ('\u{1122f}', '\u{11231}'), ('\u{11232}', '\u{11233}'),
        ('\u{11234}', '\u{11234}'), ('\u{11235}', '\u{11235}'), ('\u{11236}', '\u{11237}'),
        ('\u{112b0}', '\u{112de}'), ('\u{112df}', '\u{112df}'), ('\u{112e0}', '\u{112e2}'),
        ('\u{112e3}', '\u{112ea}'), ('\u{112f0}', '\u{112f9}'), ('\u{11301}', '\u{11301}'),
        ('\u{11302}', '\u{11303}'), ('\u{11305}', '\u{1130c}'), ('\u{1130f}', '\u{11310}'),
        ('\u{11313}', '\u{11328}'), ('\u{1132a}', '\u{11330}'), ('\u{11332}', '\u{11333}'),
        ('\u{11335}', '\u{11339}'), ('\u{1133c}', '\u{1133c}'), ('\u{1133d}', '\u{1133d}'),
        ('\u{1133e}', '\u{1133f}'), ('\u{11340}', '\u{11340}'), ('\u{11341}', '\u{11344}'),
        ('\u{11347}', '\u{11348}'), ('\u{1134b}', '\u{1134d}'), ('\u{11357}', '\u{11357}'),
        ('\u{1135d}', '\u{11361}'), ('\u{11362}', '\u{11363}'), ('\u{11366}', '\u{1136c}'),
        ('\u{11370}', '\u{11374}'), ('\u{11480}', '\u{114af}'), ('\u{114b0}', '\u{114b2}'),
        ('\u{114b3}', '\u{114b8}'), ('\u{114b9}', '\u{114b9}'), ('\u{114ba}', '\u{114ba}'),
        ('\u{114bb}', '\u{114be}'), ('\u{114bf}', '\u{114c0}'), ('\u{114c1}', '\u{114c1}'),
        ('\u{114c2}', '\u{114c3}'), ('\u{114c4}', '\u{114c5}'), ('\u{114c7}', '\u{114c7}'),
        ('\u{114d0}', '\u{114d9}'), ('\u{11580}', '\u{115ae}'), ('\u{115af}', '\u{115b1}'),
        ('\u{115b2}', '\u{115b5}'), ('\u{115b8}', '\u{115bb}'), ('\u{115bc}', '\u{115bd}'),
        ('\u{115be}', '\u{115be}'), ('\u{115bf}', '\u{115c0}'), ('\u{11600}', '\u{1162f}'),
        ('\u{11630}', '\u{11632}'), ('\u{11633}', '\u{1163a}'), ('\u{1163b}', '\u{1163c}'),
        ('\u{1163d}', '\u{1163d}'), ('\u{1163e}', '\u{1163e}'), ('\u{1163f}', '\u{11640}'),
        ('\u{11644}', '\u{11644}'), ('\u{11650}', '\u{11659}'), ('\u{11680}', '\u{116aa}'),
        ('\u{116ab}', '\u{116ab}'), ('\u{116ac}', '\u{116ac}'), ('\u{116ad}', '\u{116ad}'),
        ('\u{116ae}', '\u{116af}'), ('\u{116b0}', '\u{116b5}'), ('\u{116b6}', '\u{116b6}'),
        ('\u{116b7}', '\u{116b7}'), ('\u{116c0}', '\u{116c9}'), ('\u{118a0}', '\u{118df}'),
        ('\u{118e0}', '\u{118e9}'), ('\u{118ff}', '\u{118ff}'), ('\u{11ac0}', '\u{11af8}'),
        ('\u{12000}', '\u{12398}'), ('\u{12400}', '\u{1246e}'), ('\u{13000}', '\u{1342e}'),
        ('\u{16800}', '\u{16a38}'), ('\u{16a40}', '\u{16a5e}'), ('\u{16a60}', '\u{16a69}'),
        ('\u{16ad0}', '\u{16aed}'), ('\u{16af0}', '\u{16af4}'), ('\u{16b00}', '\u{16b2f}'),
        ('\u{16b30}', '\u{16b36}'), ('\u{16b40}', '\u{16b43}'), ('\u{16b50}', '\u{16b59}'),
        ('\u{16b63}', '\u{16b77}'), ('\u{16b7d}', '\u{16b8f}'), ('\u{16f00}', '\u{16f44}'),
        ('\u{16f50}', '\u{16f50}'), ('\u{16f51}', '\u{16f7e}'), ('\u{16f8f}', '\u{16f92}'),
        ('\u{16f93}', '\u{16f9f}'), ('\u{1b000}', '\u{1b001}'), ('\u{1bc00}', '\u{1bc6a}'),
        ('\u{1bc70}', '\u{1bc7c}'), ('\u{1bc80}', '\u{1bc88}'), ('\u{1bc90}', '\u{1bc99}'),
        ('\u{1bc9d}', '\u{1bc9e}'), ('\u{1d165}', '\u{1d166}'), ('\u{1d167}', '\u{1d169}'),
        ('\u{1d16d}', '\u{1d172}'), ('\u{1d17b}', '\u{1d182}'), ('\u{1d185}', '\u{1d18b}'),
        ('\u{1d1aa}', '\u{1d1ad}'), ('\u{1d242}', '\u{1d244}'), ('\u{1d400}', '\u{1d454}'),
        ('\u{1d456}', '\u{1d49c}'), ('\u{1d49e}', '\u{1d49f}'), ('\u{1d4a2}', '\u{1d4a2}'),
        ('\u{1d4a5}', '\u{1d4a6}'), ('\u{1d4a9}', '\u{1d4ac}'), ('\u{1d4ae}', '\u{1d4b9}'),
        ('\u{1d4bb}', '\u{1d4bb}'), ('\u{1d4bd}', '\u{1d4c3}'), ('\u{1d4c5}', '\u{1d505}'),
        ('\u{1d507}', '\u{1d50a}'), ('\u{1d50d}', '\u{1d514}'), ('\u{1d516}', '\u{1d51c}'),
        ('\u{1d51e}', '\u{1d539}'), ('\u{1d53b}', '\u{1d53e}'), ('\u{1d540}', '\u{1d544}'),
        ('\u{1d546}', '\u{1d546}'), ('\u{1d54a}', '\u{1d550}'), ('\u{1d552}', '\u{1d6a5}'),
        ('\u{1d6a8}', '\u{1d6c0}'), ('\u{1d6c2}', '\u{1d6da}'), ('\u{1d6dc}', '\u{1d6fa}'),
        ('\u{1d6fc}', '\u{1d714}'), ('\u{1d716}', '\u{1d734}'), ('\u{1d736}', '\u{1d74e}'),
        ('\u{1d750}', '\u{1d76e}'), ('\u{1d770}', '\u{1d788}'), ('\u{1d78a}', '\u{1d7a8}'),
        ('\u{1d7aa}', '\u{1d7c2}'), ('\u{1d7c4}', '\u{1d7cb}'), ('\u{1d7ce}', '\u{1d7ff}'),
        ('\u{1e800}', '\u{1e8c4}'), ('\u{1e8d0}', '\u{1e8d6}'), ('\u{1ee00}', '\u{1ee03}'),
        ('\u{1ee05}', '\u{1ee1f}'), ('\u{1ee21}', '\u{1ee22}'), ('\u{1ee24}', '\u{1ee24}'),
        ('\u{1ee27}', '\u{1ee27}'), ('\u{1ee29}', '\u{1ee32}'), ('\u{1ee34}', '\u{1ee37}'),
        ('\u{1ee39}', '\u{1ee39}'), ('\u{1ee3b}', '\u{1ee3b}'), ('\u{1ee42}', '\u{1ee42}'),
        ('\u{1ee47}', '\u{1ee47}'), ('\u{1ee49}', '\u{1ee49}'), ('\u{1ee4b}', '\u{1ee4b}'),
        ('\u{1ee4d}', '\u{1ee4f}'), ('\u{1ee51}', '\u{1ee52}'), ('\u{1ee54}', '\u{1ee54}'),
        ('\u{1ee57}', '\u{1ee57}'), ('\u{1ee59}', '\u{1ee59}'), ('\u{1ee5b}', '\u{1ee5b}'),
        ('\u{1ee5d}', '\u{1ee5d}'), ('\u{1ee5f}', '\u{1ee5f}'), ('\u{1ee61}', '\u{1ee62}'),
        ('\u{1ee64}', '\u{1ee64}'), ('\u{1ee67}', '\u{1ee6a}'), ('\u{1ee6c}', '\u{1ee72}'),
        ('\u{1ee74}', '\u{1ee77}'), ('\u{1ee79}', '\u{1ee7c}'), ('\u{1ee7e}', '\u{1ee7e}'),
        ('\u{1ee80}', '\u{1ee89}'), ('\u{1ee8b}', '\u{1ee9b}'), ('\u{1eea1}', '\u{1eea3}'),
        ('\u{1eea5}', '\u{1eea9}'), ('\u{1eeab}', '\u{1eebb}'), ('\u{20000}', '\u{2a6d6}'),
        ('\u{2a700}', '\u{2b734}'), ('\u{2b740}', '\u{2b81d}'), ('\u{2f800}', '\u{2fa1d}'),
        ('\u{e0100}', '\u{e01ef}')
    ];

    pub fn XID_Continue(c: char) -> bool {
        super::bsearch_range_table(c, XID_Continue_table)
    }

    pub static XID_Start_table: &'static [(char, char)] = &[
        ('\u{41}', '\u{5a}'), ('\u{61}', '\u{7a}'), ('\u{aa}', '\u{aa}'), ('\u{b5}', '\u{b5}'),
        ('\u{ba}', '\u{ba}'), ('\u{c0}', '\u{d6}'), ('\u{d8}', '\u{f6}'), ('\u{f8}', '\u{1ba}'),
        ('\u{1bb}', '\u{1bb}'), ('\u{1bc}', '\u{1bf}'), ('\u{1c0}', '\u{1c3}'), ('\u{1c4}',
        '\u{293}'), ('\u{294}', '\u{294}'), ('\u{295}', '\u{2af}'), ('\u{2b0}', '\u{2c1}'),
        ('\u{2c6}', '\u{2d1}'), ('\u{2e0}', '\u{2e4}'), ('\u{2ec}', '\u{2ec}'), ('\u{2ee}',
        '\u{2ee}'), ('\u{370}', '\u{373}'), ('\u{374}', '\u{374}'), ('\u{376}', '\u{377}'),
        ('\u{37b}', '\u{37d}'), ('\u{37f}', '\u{37f}'), ('\u{386}', '\u{386}'), ('\u{388}',
        '\u{38a}'), ('\u{38c}', '\u{38c}'), ('\u{38e}', '\u{3a1}'), ('\u{3a3}', '\u{3f5}'),
        ('\u{3f7}', '\u{481}'), ('\u{48a}', '\u{52f}'), ('\u{531}', '\u{556}'), ('\u{559}',
        '\u{559}'), ('\u{561}', '\u{587}'), ('\u{5d0}', '\u{5ea}'), ('\u{5f0}', '\u{5f2}'),
        ('\u{620}', '\u{63f}'), ('\u{640}', '\u{640}'), ('\u{641}', '\u{64a}'), ('\u{66e}',
        '\u{66f}'), ('\u{671}', '\u{6d3}'), ('\u{6d5}', '\u{6d5}'), ('\u{6e5}', '\u{6e6}'),
        ('\u{6ee}', '\u{6ef}'), ('\u{6fa}', '\u{6fc}'), ('\u{6ff}', '\u{6ff}'), ('\u{710}',
        '\u{710}'), ('\u{712}', '\u{72f}'), ('\u{74d}', '\u{7a5}'), ('\u{7b1}', '\u{7b1}'),
        ('\u{7ca}', '\u{7ea}'), ('\u{7f4}', '\u{7f5}'), ('\u{7fa}', '\u{7fa}'), ('\u{800}',
        '\u{815}'), ('\u{81a}', '\u{81a}'), ('\u{824}', '\u{824}'), ('\u{828}', '\u{828}'),
        ('\u{840}', '\u{858}'), ('\u{8a0}', '\u{8b2}'), ('\u{904}', '\u{939}'), ('\u{93d}',
        '\u{93d}'), ('\u{950}', '\u{950}'), ('\u{958}', '\u{961}'), ('\u{971}', '\u{971}'),
        ('\u{972}', '\u{980}'), ('\u{985}', '\u{98c}'), ('\u{98f}', '\u{990}'), ('\u{993}',
        '\u{9a8}'), ('\u{9aa}', '\u{9b0}'), ('\u{9b2}', '\u{9b2}'), ('\u{9b6}', '\u{9b9}'),
        ('\u{9bd}', '\u{9bd}'), ('\u{9ce}', '\u{9ce}'), ('\u{9dc}', '\u{9dd}'), ('\u{9df}',
        '\u{9e1}'), ('\u{9f0}', '\u{9f1}'), ('\u{a05}', '\u{a0a}'), ('\u{a0f}', '\u{a10}'),
        ('\u{a13}', '\u{a28}'), ('\u{a2a}', '\u{a30}'), ('\u{a32}', '\u{a33}'), ('\u{a35}',
        '\u{a36}'), ('\u{a38}', '\u{a39}'), ('\u{a59}', '\u{a5c}'), ('\u{a5e}', '\u{a5e}'),
        ('\u{a72}', '\u{a74}'), ('\u{a85}', '\u{a8d}'), ('\u{a8f}', '\u{a91}'), ('\u{a93}',
        '\u{aa8}'), ('\u{aaa}', '\u{ab0}'), ('\u{ab2}', '\u{ab3}'), ('\u{ab5}', '\u{ab9}'),
        ('\u{abd}', '\u{abd}'), ('\u{ad0}', '\u{ad0}'), ('\u{ae0}', '\u{ae1}'), ('\u{b05}',
        '\u{b0c}'), ('\u{b0f}', '\u{b10}'), ('\u{b13}', '\u{b28}'), ('\u{b2a}', '\u{b30}'),
        ('\u{b32}', '\u{b33}'), ('\u{b35}', '\u{b39}'), ('\u{b3d}', '\u{b3d}'), ('\u{b5c}',
        '\u{b5d}'), ('\u{b5f}', '\u{b61}'), ('\u{b71}', '\u{b71}'), ('\u{b83}', '\u{b83}'),
        ('\u{b85}', '\u{b8a}'), ('\u{b8e}', '\u{b90}'), ('\u{b92}', '\u{b95}'), ('\u{b99}',
        '\u{b9a}'), ('\u{b9c}', '\u{b9c}'), ('\u{b9e}', '\u{b9f}'), ('\u{ba3}', '\u{ba4}'),
        ('\u{ba8}', '\u{baa}'), ('\u{bae}', '\u{bb9}'), ('\u{bd0}', '\u{bd0}'), ('\u{c05}',
        '\u{c0c}'), ('\u{c0e}', '\u{c10}'), ('\u{c12}', '\u{c28}'), ('\u{c2a}', '\u{c39}'),
        ('\u{c3d}', '\u{c3d}'), ('\u{c58}', '\u{c59}'), ('\u{c60}', '\u{c61}'), ('\u{c85}',
        '\u{c8c}'), ('\u{c8e}', '\u{c90}'), ('\u{c92}', '\u{ca8}'), ('\u{caa}', '\u{cb3}'),
        ('\u{cb5}', '\u{cb9}'), ('\u{cbd}', '\u{cbd}'), ('\u{cde}', '\u{cde}'), ('\u{ce0}',
        '\u{ce1}'), ('\u{cf1}', '\u{cf2}'), ('\u{d05}', '\u{d0c}'), ('\u{d0e}', '\u{d10}'),
        ('\u{d12}', '\u{d3a}'), ('\u{d3d}', '\u{d3d}'), ('\u{d4e}', '\u{d4e}'), ('\u{d60}',
        '\u{d61}'), ('\u{d7a}', '\u{d7f}'), ('\u{d85}', '\u{d96}'), ('\u{d9a}', '\u{db1}'),
        ('\u{db3}', '\u{dbb}'), ('\u{dbd}', '\u{dbd}'), ('\u{dc0}', '\u{dc6}'), ('\u{e01}',
        '\u{e30}'), ('\u{e32}', '\u{e32}'), ('\u{e40}', '\u{e45}'), ('\u{e46}', '\u{e46}'),
        ('\u{e81}', '\u{e82}'), ('\u{e84}', '\u{e84}'), ('\u{e87}', '\u{e88}'), ('\u{e8a}',
        '\u{e8a}'), ('\u{e8d}', '\u{e8d}'), ('\u{e94}', '\u{e97}'), ('\u{e99}', '\u{e9f}'),
        ('\u{ea1}', '\u{ea3}'), ('\u{ea5}', '\u{ea5}'), ('\u{ea7}', '\u{ea7}'), ('\u{eaa}',
        '\u{eab}'), ('\u{ead}', '\u{eb0}'), ('\u{eb2}', '\u{eb2}'), ('\u{ebd}', '\u{ebd}'),
        ('\u{ec0}', '\u{ec4}'), ('\u{ec6}', '\u{ec6}'), ('\u{edc}', '\u{edf}'), ('\u{f00}',
        '\u{f00}'), ('\u{f40}', '\u{f47}'), ('\u{f49}', '\u{f6c}'), ('\u{f88}', '\u{f8c}'),
        ('\u{1000}', '\u{102a}'), ('\u{103f}', '\u{103f}'), ('\u{1050}', '\u{1055}'), ('\u{105a}',
        '\u{105d}'), ('\u{1061}', '\u{1061}'), ('\u{1065}', '\u{1066}'), ('\u{106e}', '\u{1070}'),
        ('\u{1075}', '\u{1081}'), ('\u{108e}', '\u{108e}'), ('\u{10a0}', '\u{10c5}'), ('\u{10c7}',
        '\u{10c7}'), ('\u{10cd}', '\u{10cd}'), ('\u{10d0}', '\u{10fa}'), ('\u{10fc}', '\u{10fc}'),
        ('\u{10fd}', '\u{1248}'), ('\u{124a}', '\u{124d}'), ('\u{1250}', '\u{1256}'), ('\u{1258}',
        '\u{1258}'), ('\u{125a}', '\u{125d}'), ('\u{1260}', '\u{1288}'), ('\u{128a}', '\u{128d}'),
        ('\u{1290}', '\u{12b0}'), ('\u{12b2}', '\u{12b5}'), ('\u{12b8}', '\u{12be}'), ('\u{12c0}',
        '\u{12c0}'), ('\u{12c2}', '\u{12c5}'), ('\u{12c8}', '\u{12d6}'), ('\u{12d8}', '\u{1310}'),
        ('\u{1312}', '\u{1315}'), ('\u{1318}', '\u{135a}'), ('\u{1380}', '\u{138f}'), ('\u{13a0}',
        '\u{13f4}'), ('\u{1401}', '\u{166c}'), ('\u{166f}', '\u{167f}'), ('\u{1681}', '\u{169a}'),
        ('\u{16a0}', '\u{16ea}'), ('\u{16ee}', '\u{16f0}'), ('\u{16f1}', '\u{16f8}'), ('\u{1700}',
        '\u{170c}'), ('\u{170e}', '\u{1711}'), ('\u{1720}', '\u{1731}'), ('\u{1740}', '\u{1751}'),
        ('\u{1760}', '\u{176c}'), ('\u{176e}', '\u{1770}'), ('\u{1780}', '\u{17b3}'), ('\u{17d7}',
        '\u{17d7}'), ('\u{17dc}', '\u{17dc}'), ('\u{1820}', '\u{1842}'), ('\u{1843}', '\u{1843}'),
        ('\u{1844}', '\u{1877}'), ('\u{1880}', '\u{18a8}'), ('\u{18aa}', '\u{18aa}'), ('\u{18b0}',
        '\u{18f5}'), ('\u{1900}', '\u{191e}'), ('\u{1950}', '\u{196d}'), ('\u{1970}', '\u{1974}'),
        ('\u{1980}', '\u{19ab}'), ('\u{19c1}', '\u{19c7}'), ('\u{1a00}', '\u{1a16}'), ('\u{1a20}',
        '\u{1a54}'), ('\u{1aa7}', '\u{1aa7}'), ('\u{1b05}', '\u{1b33}'), ('\u{1b45}', '\u{1b4b}'),
        ('\u{1b83}', '\u{1ba0}'), ('\u{1bae}', '\u{1baf}'), ('\u{1bba}', '\u{1be5}'), ('\u{1c00}',
        '\u{1c23}'), ('\u{1c4d}', '\u{1c4f}'), ('\u{1c5a}', '\u{1c77}'), ('\u{1c78}', '\u{1c7d}'),
        ('\u{1ce9}', '\u{1cec}'), ('\u{1cee}', '\u{1cf1}'), ('\u{1cf5}', '\u{1cf6}'), ('\u{1d00}',
        '\u{1d2b}'), ('\u{1d2c}', '\u{1d6a}'), ('\u{1d6b}', '\u{1d77}'), ('\u{1d78}', '\u{1d78}'),
        ('\u{1d79}', '\u{1d9a}'), ('\u{1d9b}', '\u{1dbf}'), ('\u{1e00}', '\u{1f15}'), ('\u{1f18}',
        '\u{1f1d}'), ('\u{1f20}', '\u{1f45}'), ('\u{1f48}', '\u{1f4d}'), ('\u{1f50}', '\u{1f57}'),
        ('\u{1f59}', '\u{1f59}'), ('\u{1f5b}', '\u{1f5b}'), ('\u{1f5d}', '\u{1f5d}'), ('\u{1f5f}',
        '\u{1f7d}'), ('\u{1f80}', '\u{1fb4}'), ('\u{1fb6}', '\u{1fbc}'), ('\u{1fbe}', '\u{1fbe}'),
        ('\u{1fc2}', '\u{1fc4}'), ('\u{1fc6}', '\u{1fcc}'), ('\u{1fd0}', '\u{1fd3}'), ('\u{1fd6}',
        '\u{1fdb}'), ('\u{1fe0}', '\u{1fec}'), ('\u{1ff2}', '\u{1ff4}'), ('\u{1ff6}', '\u{1ffc}'),
        ('\u{2071}', '\u{2071}'), ('\u{207f}', '\u{207f}'), ('\u{2090}', '\u{209c}'), ('\u{2102}',
        '\u{2102}'), ('\u{2107}', '\u{2107}'), ('\u{210a}', '\u{2113}'), ('\u{2115}', '\u{2115}'),
        ('\u{2118}', '\u{2118}'), ('\u{2119}', '\u{211d}'), ('\u{2124}', '\u{2124}'), ('\u{2126}',
        '\u{2126}'), ('\u{2128}', '\u{2128}'), ('\u{212a}', '\u{212d}'), ('\u{212e}', '\u{212e}'),
        ('\u{212f}', '\u{2134}'), ('\u{2135}', '\u{2138}'), ('\u{2139}', '\u{2139}'), ('\u{213c}',
        '\u{213f}'), ('\u{2145}', '\u{2149}'), ('\u{214e}', '\u{214e}'), ('\u{2160}', '\u{2182}'),
        ('\u{2183}', '\u{2184}'), ('\u{2185}', '\u{2188}'), ('\u{2c00}', '\u{2c2e}'), ('\u{2c30}',
        '\u{2c5e}'), ('\u{2c60}', '\u{2c7b}'), ('\u{2c7c}', '\u{2c7d}'), ('\u{2c7e}', '\u{2ce4}'),
        ('\u{2ceb}', '\u{2cee}'), ('\u{2cf2}', '\u{2cf3}'), ('\u{2d00}', '\u{2d25}'), ('\u{2d27}',
        '\u{2d27}'), ('\u{2d2d}', '\u{2d2d}'), ('\u{2d30}', '\u{2d67}'), ('\u{2d6f}', '\u{2d6f}'),
        ('\u{2d80}', '\u{2d96}'), ('\u{2da0}', '\u{2da6}'), ('\u{2da8}', '\u{2dae}'), ('\u{2db0}',
        '\u{2db6}'), ('\u{2db8}', '\u{2dbe}'), ('\u{2dc0}', '\u{2dc6}'), ('\u{2dc8}', '\u{2dce}'),
        ('\u{2dd0}', '\u{2dd6}'), ('\u{2dd8}', '\u{2dde}'), ('\u{3005}', '\u{3005}'), ('\u{3006}',
        '\u{3006}'), ('\u{3007}', '\u{3007}'), ('\u{3021}', '\u{3029}'), ('\u{3031}', '\u{3035}'),
        ('\u{3038}', '\u{303a}'), ('\u{303b}', '\u{303b}'), ('\u{303c}', '\u{303c}'), ('\u{3041}',
        '\u{3096}'), ('\u{309d}', '\u{309e}'), ('\u{309f}', '\u{309f}'), ('\u{30a1}', '\u{30fa}'),
        ('\u{30fc}', '\u{30fe}'), ('\u{30ff}', '\u{30ff}'), ('\u{3105}', '\u{312d}'), ('\u{3131}',
        '\u{318e}'), ('\u{31a0}', '\u{31ba}'), ('\u{31f0}', '\u{31ff}'), ('\u{3400}', '\u{4db5}'),
        ('\u{4e00}', '\u{9fcc}'), ('\u{a000}', '\u{a014}'), ('\u{a015}', '\u{a015}'), ('\u{a016}',
        '\u{a48c}'), ('\u{a4d0}', '\u{a4f7}'), ('\u{a4f8}', '\u{a4fd}'), ('\u{a500}', '\u{a60b}'),
        ('\u{a60c}', '\u{a60c}'), ('\u{a610}', '\u{a61f}'), ('\u{a62a}', '\u{a62b}'), ('\u{a640}',
        '\u{a66d}'), ('\u{a66e}', '\u{a66e}'), ('\u{a67f}', '\u{a67f}'), ('\u{a680}', '\u{a69b}'),
        ('\u{a69c}', '\u{a69d}'), ('\u{a6a0}', '\u{a6e5}'), ('\u{a6e6}', '\u{a6ef}'), ('\u{a717}',
        '\u{a71f}'), ('\u{a722}', '\u{a76f}'), ('\u{a770}', '\u{a770}'), ('\u{a771}', '\u{a787}'),
        ('\u{a788}', '\u{a788}'), ('\u{a78b}', '\u{a78e}'), ('\u{a790}', '\u{a7ad}'), ('\u{a7b0}',
        '\u{a7b1}'), ('\u{a7f7}', '\u{a7f7}'), ('\u{a7f8}', '\u{a7f9}'), ('\u{a7fa}', '\u{a7fa}'),
        ('\u{a7fb}', '\u{a801}'), ('\u{a803}', '\u{a805}'), ('\u{a807}', '\u{a80a}'), ('\u{a80c}',
        '\u{a822}'), ('\u{a840}', '\u{a873}'), ('\u{a882}', '\u{a8b3}'), ('\u{a8f2}', '\u{a8f7}'),
        ('\u{a8fb}', '\u{a8fb}'), ('\u{a90a}', '\u{a925}'), ('\u{a930}', '\u{a946}'), ('\u{a960}',
        '\u{a97c}'), ('\u{a984}', '\u{a9b2}'), ('\u{a9cf}', '\u{a9cf}'), ('\u{a9e0}', '\u{a9e4}'),
        ('\u{a9e6}', '\u{a9e6}'), ('\u{a9e7}', '\u{a9ef}'), ('\u{a9fa}', '\u{a9fe}'), ('\u{aa00}',
        '\u{aa28}'), ('\u{aa40}', '\u{aa42}'), ('\u{aa44}', '\u{aa4b}'), ('\u{aa60}', '\u{aa6f}'),
        ('\u{aa70}', '\u{aa70}'), ('\u{aa71}', '\u{aa76}'), ('\u{aa7a}', '\u{aa7a}'), ('\u{aa7e}',
        '\u{aaaf}'), ('\u{aab1}', '\u{aab1}'), ('\u{aab5}', '\u{aab6}'), ('\u{aab9}', '\u{aabd}'),
        ('\u{aac0}', '\u{aac0}'), ('\u{aac2}', '\u{aac2}'), ('\u{aadb}', '\u{aadc}'), ('\u{aadd}',
        '\u{aadd}'), ('\u{aae0}', '\u{aaea}'), ('\u{aaf2}', '\u{aaf2}'), ('\u{aaf3}', '\u{aaf4}'),
        ('\u{ab01}', '\u{ab06}'), ('\u{ab09}', '\u{ab0e}'), ('\u{ab11}', '\u{ab16}'), ('\u{ab20}',
        '\u{ab26}'), ('\u{ab28}', '\u{ab2e}'), ('\u{ab30}', '\u{ab5a}'), ('\u{ab5c}', '\u{ab5f}'),
        ('\u{ab64}', '\u{ab65}'), ('\u{abc0}', '\u{abe2}'), ('\u{ac00}', '\u{d7a3}'), ('\u{d7b0}',
        '\u{d7c6}'), ('\u{d7cb}', '\u{d7fb}'), ('\u{f900}', '\u{fa6d}'), ('\u{fa70}', '\u{fad9}'),
        ('\u{fb00}', '\u{fb06}'), ('\u{fb13}', '\u{fb17}'), ('\u{fb1d}', '\u{fb1d}'), ('\u{fb1f}',
        '\u{fb28}'), ('\u{fb2a}', '\u{fb36}'), ('\u{fb38}', '\u{fb3c}'), ('\u{fb3e}', '\u{fb3e}'),
        ('\u{fb40}', '\u{fb41}'), ('\u{fb43}', '\u{fb44}'), ('\u{fb46}', '\u{fbb1}'), ('\u{fbd3}',
        '\u{fc5d}'), ('\u{fc64}', '\u{fd3d}'), ('\u{fd50}', '\u{fd8f}'), ('\u{fd92}', '\u{fdc7}'),
        ('\u{fdf0}', '\u{fdf9}'), ('\u{fe71}', '\u{fe71}'), ('\u{fe73}', '\u{fe73}'), ('\u{fe77}',
        '\u{fe77}'), ('\u{fe79}', '\u{fe79}'), ('\u{fe7b}', '\u{fe7b}'), ('\u{fe7d}', '\u{fe7d}'),
        ('\u{fe7f}', '\u{fefc}'), ('\u{ff21}', '\u{ff3a}'), ('\u{ff41}', '\u{ff5a}'), ('\u{ff66}',
        '\u{ff6f}'), ('\u{ff70}', '\u{ff70}'), ('\u{ff71}', '\u{ff9d}'), ('\u{ffa0}', '\u{ffbe}'),
        ('\u{ffc2}', '\u{ffc7}'), ('\u{ffca}', '\u{ffcf}'), ('\u{ffd2}', '\u{ffd7}'), ('\u{ffda}',
        '\u{ffdc}'), ('\u{10000}', '\u{1000b}'), ('\u{1000d}', '\u{10026}'), ('\u{10028}',
        '\u{1003a}'), ('\u{1003c}', '\u{1003d}'), ('\u{1003f}', '\u{1004d}'), ('\u{10050}',
        '\u{1005d}'), ('\u{10080}', '\u{100fa}'), ('\u{10140}', '\u{10174}'), ('\u{10280}',
        '\u{1029c}'), ('\u{102a0}', '\u{102d0}'), ('\u{10300}', '\u{1031f}'), ('\u{10330}',
        '\u{10340}'), ('\u{10341}', '\u{10341}'), ('\u{10342}', '\u{10349}'), ('\u{1034a}',
        '\u{1034a}'), ('\u{10350}', '\u{10375}'), ('\u{10380}', '\u{1039d}'), ('\u{103a0}',
        '\u{103c3}'), ('\u{103c8}', '\u{103cf}'), ('\u{103d1}', '\u{103d5}'), ('\u{10400}',
        '\u{1044f}'), ('\u{10450}', '\u{1049d}'), ('\u{10500}', '\u{10527}'), ('\u{10530}',
        '\u{10563}'), ('\u{10600}', '\u{10736}'), ('\u{10740}', '\u{10755}'), ('\u{10760}',
        '\u{10767}'), ('\u{10800}', '\u{10805}'), ('\u{10808}', '\u{10808}'), ('\u{1080a}',
        '\u{10835}'), ('\u{10837}', '\u{10838}'), ('\u{1083c}', '\u{1083c}'), ('\u{1083f}',
        '\u{10855}'), ('\u{10860}', '\u{10876}'), ('\u{10880}', '\u{1089e}'), ('\u{10900}',
        '\u{10915}'), ('\u{10920}', '\u{10939}'), ('\u{10980}', '\u{109b7}'), ('\u{109be}',
        '\u{109bf}'), ('\u{10a00}', '\u{10a00}'), ('\u{10a10}', '\u{10a13}'), ('\u{10a15}',
        '\u{10a17}'), ('\u{10a19}', '\u{10a33}'), ('\u{10a60}', '\u{10a7c}'), ('\u{10a80}',
        '\u{10a9c}'), ('\u{10ac0}', '\u{10ac7}'), ('\u{10ac9}', '\u{10ae4}'), ('\u{10b00}',
        '\u{10b35}'), ('\u{10b40}', '\u{10b55}'), ('\u{10b60}', '\u{10b72}'), ('\u{10b80}',
        '\u{10b91}'), ('\u{10c00}', '\u{10c48}'), ('\u{11003}', '\u{11037}'), ('\u{11083}',
        '\u{110af}'), ('\u{110d0}', '\u{110e8}'), ('\u{11103}', '\u{11126}'), ('\u{11150}',
        '\u{11172}'), ('\u{11176}', '\u{11176}'), ('\u{11183}', '\u{111b2}'), ('\u{111c1}',
        '\u{111c4}'), ('\u{111da}', '\u{111da}'), ('\u{11200}', '\u{11211}'), ('\u{11213}',
        '\u{1122b}'), ('\u{112b0}', '\u{112de}'), ('\u{11305}', '\u{1130c}'), ('\u{1130f}',
        '\u{11310}'), ('\u{11313}', '\u{11328}'), ('\u{1132a}', '\u{11330}'), ('\u{11332}',
        '\u{11333}'), ('\u{11335}', '\u{11339}'), ('\u{1133d}', '\u{1133d}'), ('\u{1135d}',
        '\u{11361}'), ('\u{11480}', '\u{114af}'), ('\u{114c4}', '\u{114c5}'), ('\u{114c7}',
        '\u{114c7}'), ('\u{11580}', '\u{115ae}'), ('\u{11600}', '\u{1162f}'), ('\u{11644}',
        '\u{11644}'), ('\u{11680}', '\u{116aa}'), ('\u{118a0}', '\u{118df}'), ('\u{118ff}',
        '\u{118ff}'), ('\u{11ac0}', '\u{11af8}'), ('\u{12000}', '\u{12398}'), ('\u{12400}',
        '\u{1246e}'), ('\u{13000}', '\u{1342e}'), ('\u{16800}', '\u{16a38}'), ('\u{16a40}',
        '\u{16a5e}'), ('\u{16ad0}', '\u{16aed}'), ('\u{16b00}', '\u{16b2f}'), ('\u{16b40}',
        '\u{16b43}'), ('\u{16b63}', '\u{16b77}'), ('\u{16b7d}', '\u{16b8f}'), ('\u{16f00}',
        '\u{16f44}'), ('\u{16f50}', '\u{16f50}'), ('\u{16f93}', '\u{16f9f}'), ('\u{1b000}',
        '\u{1b001}'), ('\u{1bc00}', '\u{1bc6a}'), ('\u{1bc70}', '\u{1bc7c}'), ('\u{1bc80}',
        '\u{1bc88}'), ('\u{1bc90}', '\u{1bc99}'), ('\u{1d400}', '\u{1d454}'), ('\u{1d456}',
        '\u{1d49c}'), ('\u{1d49e}', '\u{1d49f}'), ('\u{1d4a2}', '\u{1d4a2}'), ('\u{1d4a5}',
        '\u{1d4a6}'), ('\u{1d4a9}', '\u{1d4ac}'), ('\u{1d4ae}', '\u{1d4b9}'), ('\u{1d4bb}',
        '\u{1d4bb}'), ('\u{1d4bd}', '\u{1d4c3}'), ('\u{1d4c5}', '\u{1d505}'), ('\u{1d507}',
        '\u{1d50a}'), ('\u{1d50d}', '\u{1d514}'), ('\u{1d516}', '\u{1d51c}'), ('\u{1d51e}',
        '\u{1d539}'), ('\u{1d53b}', '\u{1d53e}'), ('\u{1d540}', '\u{1d544}'), ('\u{1d546}',
        '\u{1d546}'), ('\u{1d54a}', '\u{1d550}'), ('\u{1d552}', '\u{1d6a5}'), ('\u{1d6a8}',
        '\u{1d6c0}'), ('\u{1d6c2}', '\u{1d6da}'), ('\u{1d6dc}', '\u{1d6fa}'), ('\u{1d6fc}',
        '\u{1d714}'), ('\u{1d716}', '\u{1d734}'), ('\u{1d736}', '\u{1d74e}'), ('\u{1d750}',
        '\u{1d76e}'), ('\u{1d770}', '\u{1d788}'), ('\u{1d78a}', '\u{1d7a8}'), ('\u{1d7aa}',
        '\u{1d7c2}'), ('\u{1d7c4}', '\u{1d7cb}'), ('\u{1e800}', '\u{1e8c4}'), ('\u{1ee00}',
        '\u{1ee03}'), ('\u{1ee05}', '\u{1ee1f}'), ('\u{1ee21}', '\u{1ee22}'), ('\u{1ee24}',
        '\u{1ee24}'), ('\u{1ee27}', '\u{1ee27}'), ('\u{1ee29}', '\u{1ee32}'), ('\u{1ee34}',
        '\u{1ee37}'), ('\u{1ee39}', '\u{1ee39}'), ('\u{1ee3b}', '\u{1ee3b}'), ('\u{1ee42}',
        '\u{1ee42}'), ('\u{1ee47}', '\u{1ee47}'), ('\u{1ee49}', '\u{1ee49}'), ('\u{1ee4b}',
        '\u{1ee4b}'), ('\u{1ee4d}', '\u{1ee4f}'), ('\u{1ee51}', '\u{1ee52}'), ('\u{1ee54}',
        '\u{1ee54}'), ('\u{1ee57}', '\u{1ee57}'), ('\u{1ee59}', '\u{1ee59}'), ('\u{1ee5b}',
        '\u{1ee5b}'), ('\u{1ee5d}', '\u{1ee5d}'), ('\u{1ee5f}', '\u{1ee5f}'), ('\u{1ee61}',
        '\u{1ee62}'), ('\u{1ee64}', '\u{1ee64}'), ('\u{1ee67}', '\u{1ee6a}'), ('\u{1ee6c}',
        '\u{1ee72}'), ('\u{1ee74}', '\u{1ee77}'), ('\u{1ee79}', '\u{1ee7c}'), ('\u{1ee7e}',
        '\u{1ee7e}'), ('\u{1ee80}', '\u{1ee89}'), ('\u{1ee8b}', '\u{1ee9b}'), ('\u{1eea1}',
        '\u{1eea3}'), ('\u{1eea5}', '\u{1eea9}'), ('\u{1eeab}', '\u{1eebb}'), ('\u{20000}',
        '\u{2a6d6}'), ('\u{2a700}', '\u{2b734}'), ('\u{2b740}', '\u{2b81d}'), ('\u{2f800}',
        '\u{2fa1d}')
    ];

    pub fn XID_Start(c: char) -> bool {
        super::bsearch_range_table(c, XID_Start_table)
    }

}

pub mod script {
    pub static Arabic_table: &'static [(char, char)] = &[
        ('\u{600}', '\u{604}'), ('\u{606}', '\u{608}'), ('\u{609}', '\u{60a}'), ('\u{60b}',
        '\u{60b}'), ('\u{60d}', '\u{60d}'), ('\u{60e}', '\u{60f}'), ('\u{610}', '\u{61a}'),
        ('\u{61e}', '\u{61e}'), ('\u{620}', '\u{63f}'), ('\u{641}', '\u{64a}'), ('\u{656}',
        '\u{65f}'), ('\u{66a}', '\u{66d}'), ('\u{66e}', '\u{66f}'), ('\u{671}', '\u{6d3}'),
        ('\u{6d4}', '\u{6d4}'), ('\u{6d5}', '\u{6d5}'), ('\u{6d6}', '\u{6dc}'), ('\u{6de}',
        '\u{6de}'), ('\u{6df}', '\u{6e4}'), ('\u{6e5}', '\u{6e6}'), ('\u{6e7}', '\u{6e8}'),
        ('\u{6e9}', '\u{6e9}'), ('\u{6ea}', '\u{6ed}'), ('\u{6ee}', '\u{6ef}'), ('\u{6f0}',
        '\u{6f9}'), ('\u{6fa}', '\u{6fc}'), ('\u{6fd}', '\u{6fe}'), ('\u{6ff}', '\u{6ff}'),
        ('\u{750}', '\u{77f}'), ('\u{8a0}', '\u{8b2}'), ('\u{8e4}', '\u{8ff}'), ('\u{fb50}',
        '\u{fbb1}'), ('\u{fbb2}', '\u{fbc1}'), ('\u{fbd3}', '\u{fd3d}'), ('\u{fd50}', '\u{fd8f}'),
        ('\u{fd92}', '\u{fdc7}'), ('\u{fdf0}', '\u{fdfb}'), ('\u{fdfc}', '\u{fdfc}'), ('\u{fdfd}',
        '\u{fdfd}'), ('\u{fe70}', '\u{fe74}'), ('\u{fe76}', '\u{fefc}'), ('\u{10e60}', '\u{10e7e}'),
        ('\u{1ee00}', '\u{1ee03}'), ('\u{1ee05}', '\u{1ee1f}'), ('\u{1ee21}', '\u{1ee22}'),
        ('\u{1ee24}', '\u{1ee24}'), ('\u{1ee27}', '\u{1ee27}'), ('\u{1ee29}', '\u{1ee32}'),
        ('\u{1ee34}', '\u{1ee37}'), ('\u{1ee39}', '\u{1ee39}'), ('\u{1ee3b}', '\u{1ee3b}'),
        ('\u{1ee42}', '\u{1ee42}'), ('\u{1ee47}', '\u{1ee47}'), ('\u{1ee49}', '\u{1ee49}'),
        ('\u{1ee4b}', '\u{1ee4b}'), ('\u{1ee4d}', '\u{1ee4f}'), ('\u{1ee51}', '\u{1ee52}'),
        ('\u{1ee54}', '\u{1ee54}'), ('\u{1ee57}', '\u{1ee57}'), ('\u{1ee59}', '\u{1ee59}'),
        ('\u{1ee5b}', '\u{1ee5b}'), ('\u{1ee5d}', '\u{1ee5d}'), ('\u{1ee5f}', '\u{1ee5f}'),
        ('\u{1ee61}', '\u{1ee62}'), ('\u{1ee64}', '\u{1ee64}'), ('\u{1ee67}', '\u{1ee6a}'),
        ('\u{1ee6c}', '\u{1ee72}'), ('\u{1ee74}', '\u{1ee77}'), ('\u{1ee79}', '\u{1ee7c}'),
        ('\u{1ee7e}', '\u{1ee7e}'), ('\u{1ee80}', '\u{1ee89}'), ('\u{1ee8b}', '\u{1ee9b}'),
        ('\u{1eea1}', '\u{1eea3}'), ('\u{1eea5}', '\u{1eea9}'), ('\u{1eeab}', '\u{1eebb}'),
        ('\u{1eef0}', '\u{1eef1}')
    ];

    pub static Armenian_table: &'static [(char, char)] = &[
        ('\u{531}', '\u{556}'), ('\u{559}', '\u{559}'), ('\u{55a}', '\u{55f}'), ('\u{561}',
        '\u{587}'), ('\u{58a}', '\u{58a}'), ('\u{58d}', '\u{58e}'), ('\u{58f}', '\u{58f}'),
        ('\u{fb13}', '\u{fb17}')
    ];

    pub static Avestan_table: &'static [(char, char)] = &[
        ('\u{10b00}', '\u{10b35}'), ('\u{10b39}', '\u{10b3f}')
    ];

    pub static Balinese_table: &'static [(char, char)] = &[
        ('\u{1b00}', '\u{1b03}'), ('\u{1b04}', '\u{1b04}'), ('\u{1b05}', '\u{1b33}'), ('\u{1b34}',
        '\u{1b34}'), ('\u{1b35}', '\u{1b35}'), ('\u{1b36}', '\u{1b3a}'), ('\u{1b3b}', '\u{1b3b}'),
        ('\u{1b3c}', '\u{1b3c}'), ('\u{1b3d}', '\u{1b41}'), ('\u{1b42}', '\u{1b42}'), ('\u{1b43}',
        '\u{1b44}'), ('\u{1b45}', '\u{1b4b}'), ('\u{1b50}', '\u{1b59}'), ('\u{1b5a}', '\u{1b60}'),
        ('\u{1b61}', '\u{1b6a}'), ('\u{1b6b}', '\u{1b73}'), ('\u{1b74}', '\u{1b7c}')
    ];

    pub static Bamum_table: &'static [(char, char)] = &[
        ('\u{a6a0}', '\u{a6e5}'), ('\u{a6e6}', '\u{a6ef}'), ('\u{a6f0}', '\u{a6f1}'), ('\u{a6f2}',
        '\u{a6f7}'), ('\u{16800}', '\u{16a38}')
    ];

    pub static Bassa_Vah_table: &'static [(char, char)] = &[
        ('\u{16ad0}', '\u{16aed}'), ('\u{16af0}', '\u{16af4}'), ('\u{16af5}', '\u{16af5}')
    ];

    pub static Batak_table: &'static [(char, char)] = &[
        ('\u{1bc0}', '\u{1be5}'), ('\u{1be6}', '\u{1be6}'), ('\u{1be7}', '\u{1be7}'), ('\u{1be8}',
        '\u{1be9}'), ('\u{1bea}', '\u{1bec}'), ('\u{1bed}', '\u{1bed}'), ('\u{1bee}', '\u{1bee}'),
        ('\u{1bef}', '\u{1bf1}'), ('\u{1bf2}', '\u{1bf3}'), ('\u{1bfc}', '\u{1bff}')
    ];

    pub static Bengali_table: &'static [(char, char)] = &[
        ('\u{980}', '\u{980}'), ('\u{981}', '\u{981}'), ('\u{982}', '\u{983}'), ('\u{985}',
        '\u{98c}'), ('\u{98f}', '\u{990}'), ('\u{993}', '\u{9a8}'), ('\u{9aa}', '\u{9b0}'),
        ('\u{9b2}', '\u{9b2}'), ('\u{9b6}', '\u{9b9}'), ('\u{9bc}', '\u{9bc}'), ('\u{9bd}',
        '\u{9bd}'), ('\u{9be}', '\u{9c0}'), ('\u{9c1}', '\u{9c4}'), ('\u{9c7}', '\u{9c8}'),
        ('\u{9cb}', '\u{9cc}'), ('\u{9cd}', '\u{9cd}'), ('\u{9ce}', '\u{9ce}'), ('\u{9d7}',
        '\u{9d7}'), ('\u{9dc}', '\u{9dd}'), ('\u{9df}', '\u{9e1}'), ('\u{9e2}', '\u{9e3}'),
        ('\u{9e6}', '\u{9ef}'), ('\u{9f0}', '\u{9f1}'), ('\u{9f2}', '\u{9f3}'), ('\u{9f4}',
        '\u{9f9}'), ('\u{9fa}', '\u{9fa}'), ('\u{9fb}', '\u{9fb}')
    ];

    pub static Bopomofo_table: &'static [(char, char)] = &[
        ('\u{2ea}', '\u{2eb}'), ('\u{3105}', '\u{312d}'), ('\u{31a0}', '\u{31ba}')
    ];

    pub static Brahmi_table: &'static [(char, char)] = &[
        ('\u{11000}', '\u{11000}'), ('\u{11001}', '\u{11001}'), ('\u{11002}', '\u{11002}'),
        ('\u{11003}', '\u{11037}'), ('\u{11038}', '\u{11046}'), ('\u{11047}', '\u{1104d}'),
        ('\u{11052}', '\u{11065}'), ('\u{11066}', '\u{1106f}'), ('\u{1107f}', '\u{1107f}')
    ];

    pub static Braille_table: &'static [(char, char)] = &[
        ('\u{2800}', '\u{28ff}')
    ];

    pub static Buginese_table: &'static [(char, char)] = &[
        ('\u{1a00}', '\u{1a16}'), ('\u{1a17}', '\u{1a18}'), ('\u{1a19}', '\u{1a1a}'), ('\u{1a1b}',
        '\u{1a1b}'), ('\u{1a1e}', '\u{1a1f}')
    ];

    pub static Buhid_table: &'static [(char, char)] = &[
        ('\u{1740}', '\u{1751}'), ('\u{1752}', '\u{1753}')
    ];

    pub static Canadian_Aboriginal_table: &'static [(char, char)] = &[
        ('\u{1400}', '\u{1400}'), ('\u{1401}', '\u{166c}'), ('\u{166d}', '\u{166e}'), ('\u{166f}',
        '\u{167f}'), ('\u{18b0}', '\u{18f5}')
    ];

    pub static Carian_table: &'static [(char, char)] = &[
        ('\u{102a0}', '\u{102d0}')
    ];

    pub static Caucasian_Albanian_table: &'static [(char, char)] = &[
        ('\u{10530}', '\u{10563}'), ('\u{1056f}', '\u{1056f}')
    ];

    pub static Chakma_table: &'static [(char, char)] = &[
        ('\u{11100}', '\u{11102}'), ('\u{11103}', '\u{11126}'), ('\u{11127}', '\u{1112b}'),
        ('\u{1112c}', '\u{1112c}'), ('\u{1112d}', '\u{11134}'), ('\u{11136}', '\u{1113f}'),
        ('\u{11140}', '\u{11143}')
    ];

    pub static Cham_table: &'static [(char, char)] = &[
        ('\u{aa00}', '\u{aa28}'), ('\u{aa29}', '\u{aa2e}'), ('\u{aa2f}', '\u{aa30}'), ('\u{aa31}',
        '\u{aa32}'), ('\u{aa33}', '\u{aa34}'), ('\u{aa35}', '\u{aa36}'), ('\u{aa40}', '\u{aa42}'),
        ('\u{aa43}', '\u{aa43}'), ('\u{aa44}', '\u{aa4b}'), ('\u{aa4c}', '\u{aa4c}'), ('\u{aa4d}',
        '\u{aa4d}'), ('\u{aa50}', '\u{aa59}'), ('\u{aa5c}', '\u{aa5f}')
    ];

    pub static Cherokee_table: &'static [(char, char)] = &[
        ('\u{13a0}', '\u{13f4}')
    ];

    pub static Common_table: &'static [(char, char)] = &[
        ('\u{0}', '\u{1f}'), ('\u{20}', '\u{20}'), ('\u{21}', '\u{23}'), ('\u{24}', '\u{24}'),
        ('\u{25}', '\u{27}'), ('\u{28}', '\u{28}'), ('\u{29}', '\u{29}'), ('\u{2a}', '\u{2a}'),
        ('\u{2b}', '\u{2b}'), ('\u{2c}', '\u{2c}'), ('\u{2d}', '\u{2d}'), ('\u{2e}', '\u{2f}'),
        ('\u{30}', '\u{39}'), ('\u{3a}', '\u{3b}'), ('\u{3c}', '\u{3e}'), ('\u{3f}', '\u{40}'),
        ('\u{5b}', '\u{5b}'), ('\u{5c}', '\u{5c}'), ('\u{5d}', '\u{5d}'), ('\u{5e}', '\u{5e}'),
        ('\u{5f}', '\u{5f}'), ('\u{60}', '\u{60}'), ('\u{7b}', '\u{7b}'), ('\u{7c}', '\u{7c}'),
        ('\u{7d}', '\u{7d}'), ('\u{7e}', '\u{7e}'), ('\u{7f}', '\u{9f}'), ('\u{a0}', '\u{a0}'),
        ('\u{a1}', '\u{a1}'), ('\u{a2}', '\u{a5}'), ('\u{a6}', '\u{a6}'), ('\u{a7}', '\u{a7}'),
        ('\u{a8}', '\u{a8}'), ('\u{a9}', '\u{a9}'), ('\u{ab}', '\u{ab}'), ('\u{ac}', '\u{ac}'),
        ('\u{ad}', '\u{ad}'), ('\u{ae}', '\u{ae}'), ('\u{af}', '\u{af}'), ('\u{b0}', '\u{b0}'),
        ('\u{b1}', '\u{b1}'), ('\u{b2}', '\u{b3}'), ('\u{b4}', '\u{b4}'), ('\u{b5}', '\u{b5}'),
        ('\u{b6}', '\u{b7}'), ('\u{b8}', '\u{b8}'), ('\u{b9}', '\u{b9}'), ('\u{bb}', '\u{bb}'),
        ('\u{bc}', '\u{be}'), ('\u{bf}', '\u{bf}'), ('\u{d7}', '\u{d7}'), ('\u{f7}', '\u{f7}'),
        ('\u{2b9}', '\u{2c1}'), ('\u{2c2}', '\u{2c5}'), ('\u{2c6}', '\u{2d1}'), ('\u{2d2}',
        '\u{2df}'), ('\u{2e5}', '\u{2e9}'), ('\u{2ec}', '\u{2ec}'), ('\u{2ed}', '\u{2ed}'),
        ('\u{2ee}', '\u{2ee}'), ('\u{2ef}', '\u{2ff}'), ('\u{374}', '\u{374}'), ('\u{37e}',
        '\u{37e}'), ('\u{385}', '\u{385}'), ('\u{387}', '\u{387}'), ('\u{589}', '\u{589}'),
        ('\u{605}', '\u{605}'), ('\u{60c}', '\u{60c}'), ('\u{61b}', '\u{61b}'), ('\u{61c}',
        '\u{61c}'), ('\u{61f}', '\u{61f}'), ('\u{640}', '\u{640}'), ('\u{660}', '\u{669}'),
        ('\u{6dd}', '\u{6dd}'), ('\u{964}', '\u{965}'), ('\u{e3f}', '\u{e3f}'), ('\u{fd5}',
        '\u{fd8}'), ('\u{10fb}', '\u{10fb}'), ('\u{16eb}', '\u{16ed}'), ('\u{1735}', '\u{1736}'),
        ('\u{1802}', '\u{1803}'), ('\u{1805}', '\u{1805}'), ('\u{1cd3}', '\u{1cd3}'), ('\u{1ce1}',
        '\u{1ce1}'), ('\u{1ce9}', '\u{1cec}'), ('\u{1cee}', '\u{1cf1}'), ('\u{1cf2}', '\u{1cf3}'),
        ('\u{1cf5}', '\u{1cf6}'), ('\u{2000}', '\u{200a}'), ('\u{200b}', '\u{200b}'), ('\u{200e}',
        '\u{200f}'), ('\u{2010}', '\u{2015}'), ('\u{2016}', '\u{2017}'), ('\u{2018}', '\u{2018}'),
        ('\u{2019}', '\u{2019}'), ('\u{201a}', '\u{201a}'), ('\u{201b}', '\u{201c}'), ('\u{201d}',
        '\u{201d}'), ('\u{201e}', '\u{201e}'), ('\u{201f}', '\u{201f}'), ('\u{2020}', '\u{2027}'),
        ('\u{2028}', '\u{2028}'), ('\u{2029}', '\u{2029}'), ('\u{202a}', '\u{202e}'), ('\u{202f}',
        '\u{202f}'), ('\u{2030}', '\u{2038}'), ('\u{2039}', '\u{2039}'), ('\u{203a}', '\u{203a}'),
        ('\u{203b}', '\u{203e}'), ('\u{203f}', '\u{2040}'), ('\u{2041}', '\u{2043}'), ('\u{2044}',
        '\u{2044}'), ('\u{2045}', '\u{2045}'), ('\u{2046}', '\u{2046}'), ('\u{2047}', '\u{2051}'),
        ('\u{2052}', '\u{2052}'), ('\u{2053}', '\u{2053}'), ('\u{2054}', '\u{2054}'), ('\u{2055}',
        '\u{205e}'), ('\u{205f}', '\u{205f}'), ('\u{2060}', '\u{2064}'), ('\u{2066}', '\u{206f}'),
        ('\u{2070}', '\u{2070}'), ('\u{2074}', '\u{2079}'), ('\u{207a}', '\u{207c}'), ('\u{207d}',
        '\u{207d}'), ('\u{207e}', '\u{207e}'), ('\u{2080}', '\u{2089}'), ('\u{208a}', '\u{208c}'),
        ('\u{208d}', '\u{208d}'), ('\u{208e}', '\u{208e}'), ('\u{20a0}', '\u{20bd}'), ('\u{2100}',
        '\u{2101}'), ('\u{2102}', '\u{2102}'), ('\u{2103}', '\u{2106}'), ('\u{2107}', '\u{2107}'),
        ('\u{2108}', '\u{2109}'), ('\u{210a}', '\u{2113}'), ('\u{2114}', '\u{2114}'), ('\u{2115}',
        '\u{2115}'), ('\u{2116}', '\u{2117}'), ('\u{2118}', '\u{2118}'), ('\u{2119}', '\u{211d}'),
        ('\u{211e}', '\u{2123}'), ('\u{2124}', '\u{2124}'), ('\u{2125}', '\u{2125}'), ('\u{2127}',
        '\u{2127}'), ('\u{2128}', '\u{2128}'), ('\u{2129}', '\u{2129}'), ('\u{212c}', '\u{212d}'),
        ('\u{212e}', '\u{212e}'), ('\u{212f}', '\u{2131}'), ('\u{2133}', '\u{2134}'), ('\u{2135}',
        '\u{2138}'), ('\u{2139}', '\u{2139}'), ('\u{213a}', '\u{213b}'), ('\u{213c}', '\u{213f}'),
        ('\u{2140}', '\u{2144}'), ('\u{2145}', '\u{2149}'), ('\u{214a}', '\u{214a}'), ('\u{214b}',
        '\u{214b}'), ('\u{214c}', '\u{214d}'), ('\u{214f}', '\u{214f}'), ('\u{2150}', '\u{215f}'),
        ('\u{2189}', '\u{2189}'), ('\u{2190}', '\u{2194}'), ('\u{2195}', '\u{2199}'), ('\u{219a}',
        '\u{219b}'), ('\u{219c}', '\u{219f}'), ('\u{21a0}', '\u{21a0}'), ('\u{21a1}', '\u{21a2}'),
        ('\u{21a3}', '\u{21a3}'), ('\u{21a4}', '\u{21a5}'), ('\u{21a6}', '\u{21a6}'), ('\u{21a7}',
        '\u{21ad}'), ('\u{21ae}', '\u{21ae}'), ('\u{21af}', '\u{21cd}'), ('\u{21ce}', '\u{21cf}'),
        ('\u{21d0}', '\u{21d1}'), ('\u{21d2}', '\u{21d2}'), ('\u{21d3}', '\u{21d3}'), ('\u{21d4}',
        '\u{21d4}'), ('\u{21d5}', '\u{21f3}'), ('\u{21f4}', '\u{22ff}'), ('\u{2300}', '\u{2307}'),
        ('\u{2308}', '\u{2308}'), ('\u{2309}', '\u{2309}'), ('\u{230a}', '\u{230a}'), ('\u{230b}',
        '\u{230b}'), ('\u{230c}', '\u{231f}'), ('\u{2320}', '\u{2321}'), ('\u{2322}', '\u{2328}'),
        ('\u{2329}', '\u{2329}'), ('\u{232a}', '\u{232a}'), ('\u{232b}', '\u{237b}'), ('\u{237c}',
        '\u{237c}'), ('\u{237d}', '\u{239a}'), ('\u{239b}', '\u{23b3}'), ('\u{23b4}', '\u{23db}'),
        ('\u{23dc}', '\u{23e1}'), ('\u{23e2}', '\u{23fa}'), ('\u{2400}', '\u{2426}'), ('\u{2440}',
        '\u{244a}'), ('\u{2460}', '\u{249b}'), ('\u{249c}', '\u{24e9}'), ('\u{24ea}', '\u{24ff}'),
        ('\u{2500}', '\u{25b6}'), ('\u{25b7}', '\u{25b7}'), ('\u{25b8}', '\u{25c0}'), ('\u{25c1}',
        '\u{25c1}'), ('\u{25c2}', '\u{25f7}'), ('\u{25f8}', '\u{25ff}'), ('\u{2600}', '\u{266e}'),
        ('\u{266f}', '\u{266f}'), ('\u{2670}', '\u{2767}'), ('\u{2768}', '\u{2768}'), ('\u{2769}',
        '\u{2769}'), ('\u{276a}', '\u{276a}'), ('\u{276b}', '\u{276b}'), ('\u{276c}', '\u{276c}'),
        ('\u{276d}', '\u{276d}'), ('\u{276e}', '\u{276e}'), ('\u{276f}', '\u{276f}'), ('\u{2770}',
        '\u{2770}'), ('\u{2771}', '\u{2771}'), ('\u{2772}', '\u{2772}'), ('\u{2773}', '\u{2773}'),
        ('\u{2774}', '\u{2774}'), ('\u{2775}', '\u{2775}'), ('\u{2776}', '\u{2793}'), ('\u{2794}',
        '\u{27bf}'), ('\u{27c0}', '\u{27c4}'), ('\u{27c5}', '\u{27c5}'), ('\u{27c6}', '\u{27c6}'),
        ('\u{27c7}', '\u{27e5}'), ('\u{27e6}', '\u{27e6}'), ('\u{27e7}', '\u{27e7}'), ('\u{27e8}',
        '\u{27e8}'), ('\u{27e9}', '\u{27e9}'), ('\u{27ea}', '\u{27ea}'), ('\u{27eb}', '\u{27eb}'),
        ('\u{27ec}', '\u{27ec}'), ('\u{27ed}', '\u{27ed}'), ('\u{27ee}', '\u{27ee}'), ('\u{27ef}',
        '\u{27ef}'), ('\u{27f0}', '\u{27ff}'), ('\u{2900}', '\u{2982}'), ('\u{2983}', '\u{2983}'),
        ('\u{2984}', '\u{2984}'), ('\u{2985}', '\u{2985}'), ('\u{2986}', '\u{2986}'), ('\u{2987}',
        '\u{2987}'), ('\u{2988}', '\u{2988}'), ('\u{2989}', '\u{2989}'), ('\u{298a}', '\u{298a}'),
        ('\u{298b}', '\u{298b}'), ('\u{298c}', '\u{298c}'), ('\u{298d}', '\u{298d}'), ('\u{298e}',
        '\u{298e}'), ('\u{298f}', '\u{298f}'), ('\u{2990}', '\u{2990}'), ('\u{2991}', '\u{2991}'),
        ('\u{2992}', '\u{2992}'), ('\u{2993}', '\u{2993}'), ('\u{2994}', '\u{2994}'), ('\u{2995}',
        '\u{2995}'), ('\u{2996}', '\u{2996}'), ('\u{2997}', '\u{2997}'), ('\u{2998}', '\u{2998}'),
        ('\u{2999}', '\u{29d7}'), ('\u{29d8}', '\u{29d8}'), ('\u{29d9}', '\u{29d9}'), ('\u{29da}',
        '\u{29da}'), ('\u{29db}', '\u{29db}'), ('\u{29dc}', '\u{29fb}'), ('\u{29fc}', '\u{29fc}'),
        ('\u{29fd}', '\u{29fd}'), ('\u{29fe}', '\u{2aff}'), ('\u{2b00}', '\u{2b2f}'), ('\u{2b30}',
        '\u{2b44}'), ('\u{2b45}', '\u{2b46}'), ('\u{2b47}', '\u{2b4c}'), ('\u{2b4d}', '\u{2b73}'),
        ('\u{2b76}', '\u{2b95}'), ('\u{2b98}', '\u{2bb9}'), ('\u{2bbd}', '\u{2bc8}'), ('\u{2bca}',
        '\u{2bd1}'), ('\u{2e00}', '\u{2e01}'), ('\u{2e02}', '\u{2e02}'), ('\u{2e03}', '\u{2e03}'),
        ('\u{2e04}', '\u{2e04}'), ('\u{2e05}', '\u{2e05}'), ('\u{2e06}', '\u{2e08}'), ('\u{2e09}',
        '\u{2e09}'), ('\u{2e0a}', '\u{2e0a}'), ('\u{2e0b}', '\u{2e0b}'), ('\u{2e0c}', '\u{2e0c}'),
        ('\u{2e0d}', '\u{2e0d}'), ('\u{2e0e}', '\u{2e16}'), ('\u{2e17}', '\u{2e17}'), ('\u{2e18}',
        '\u{2e19}'), ('\u{2e1a}', '\u{2e1a}'), ('\u{2e1b}', '\u{2e1b}'), ('\u{2e1c}', '\u{2e1c}'),
        ('\u{2e1d}', '\u{2e1d}'), ('\u{2e1e}', '\u{2e1f}'), ('\u{2e20}', '\u{2e20}'), ('\u{2e21}',
        '\u{2e21}'), ('\u{2e22}', '\u{2e22}'), ('\u{2e23}', '\u{2e23}'), ('\u{2e24}', '\u{2e24}'),
        ('\u{2e25}', '\u{2e25}'), ('\u{2e26}', '\u{2e26}'), ('\u{2e27}', '\u{2e27}'), ('\u{2e28}',
        '\u{2e28}'), ('\u{2e29}', '\u{2e29}'), ('\u{2e2a}', '\u{2e2e}'), ('\u{2e2f}', '\u{2e2f}'),
        ('\u{2e30}', '\u{2e39}'), ('\u{2e3a}', '\u{2e3b}'), ('\u{2e3c}', '\u{2e3f}'), ('\u{2e40}',
        '\u{2e40}'), ('\u{2e41}', '\u{2e41}'), ('\u{2e42}', '\u{2e42}'), ('\u{2ff0}', '\u{2ffb}'),
        ('\u{3000}', '\u{3000}'), ('\u{3001}', '\u{3003}'), ('\u{3004}', '\u{3004}'), ('\u{3006}',
        '\u{3006}'), ('\u{3008}', '\u{3008}'), ('\u{3009}', '\u{3009}'), ('\u{300a}', '\u{300a}'),
        ('\u{300b}', '\u{300b}'), ('\u{300c}', '\u{300c}'), ('\u{300d}', '\u{300d}'), ('\u{300e}',
        '\u{300e}'), ('\u{300f}', '\u{300f}'), ('\u{3010}', '\u{3010}'), ('\u{3011}', '\u{3011}'),
        ('\u{3012}', '\u{3013}'), ('\u{3014}', '\u{3014}'), ('\u{3015}', '\u{3015}'), ('\u{3016}',
        '\u{3016}'), ('\u{3017}', '\u{3017}'), ('\u{3018}', '\u{3018}'), ('\u{3019}', '\u{3019}'),
        ('\u{301a}', '\u{301a}'), ('\u{301b}', '\u{301b}'), ('\u{301c}', '\u{301c}'), ('\u{301d}',
        '\u{301d}'), ('\u{301e}', '\u{301f}'), ('\u{3020}', '\u{3020}'), ('\u{3030}', '\u{3030}'),
        ('\u{3031}', '\u{3035}'), ('\u{3036}', '\u{3037}'), ('\u{303c}', '\u{303c}'), ('\u{303d}',
        '\u{303d}'), ('\u{303e}', '\u{303f}'), ('\u{309b}', '\u{309c}'), ('\u{30a0}', '\u{30a0}'),
        ('\u{30fb}', '\u{30fb}'), ('\u{30fc}', '\u{30fc}'), ('\u{3190}', '\u{3191}'), ('\u{3192}',
        '\u{3195}'), ('\u{3196}', '\u{319f}'), ('\u{31c0}', '\u{31e3}'), ('\u{3220}', '\u{3229}'),
        ('\u{322a}', '\u{3247}'), ('\u{3248}', '\u{324f}'), ('\u{3250}', '\u{3250}'), ('\u{3251}',
        '\u{325f}'), ('\u{327f}', '\u{327f}'), ('\u{3280}', '\u{3289}'), ('\u{328a}', '\u{32b0}'),
        ('\u{32b1}', '\u{32bf}'), ('\u{32c0}', '\u{32cf}'), ('\u{3358}', '\u{33ff}'), ('\u{4dc0}',
        '\u{4dff}'), ('\u{a700}', '\u{a716}'), ('\u{a717}', '\u{a71f}'), ('\u{a720}', '\u{a721}'),
        ('\u{a788}', '\u{a788}'), ('\u{a789}', '\u{a78a}'), ('\u{a830}', '\u{a835}'), ('\u{a836}',
        '\u{a837}'), ('\u{a838}', '\u{a838}'), ('\u{a839}', '\u{a839}'), ('\u{a92e}', '\u{a92e}'),
        ('\u{a9cf}', '\u{a9cf}'), ('\u{ab5b}', '\u{ab5b}'), ('\u{fd3e}', '\u{fd3e}'), ('\u{fd3f}',
        '\u{fd3f}'), ('\u{fe10}', '\u{fe16}'), ('\u{fe17}', '\u{fe17}'), ('\u{fe18}', '\u{fe18}'),
        ('\u{fe19}', '\u{fe19}'), ('\u{fe30}', '\u{fe30}'), ('\u{fe31}', '\u{fe32}'), ('\u{fe33}',
        '\u{fe34}'), ('\u{fe35}', '\u{fe35}'), ('\u{fe36}', '\u{fe36}'), ('\u{fe37}', '\u{fe37}'),
        ('\u{fe38}', '\u{fe38}'), ('\u{fe39}', '\u{fe39}'), ('\u{fe3a}', '\u{fe3a}'), ('\u{fe3b}',
        '\u{fe3b}'), ('\u{fe3c}', '\u{fe3c}'), ('\u{fe3d}', '\u{fe3d}'), ('\u{fe3e}', '\u{fe3e}'),
        ('\u{fe3f}', '\u{fe3f}'), ('\u{fe40}', '\u{fe40}'), ('\u{fe41}', '\u{fe41}'), ('\u{fe42}',
        '\u{fe42}'), ('\u{fe43}', '\u{fe43}'), ('\u{fe44}', '\u{fe44}'), ('\u{fe45}', '\u{fe46}'),
        ('\u{fe47}', '\u{fe47}'), ('\u{fe48}', '\u{fe48}'), ('\u{fe49}', '\u{fe4c}'), ('\u{fe4d}',
        '\u{fe4f}'), ('\u{fe50}', '\u{fe52}'), ('\u{fe54}', '\u{fe57}'), ('\u{fe58}', '\u{fe58}'),
        ('\u{fe59}', '\u{fe59}'), ('\u{fe5a}', '\u{fe5a}'), ('\u{fe5b}', '\u{fe5b}'), ('\u{fe5c}',
        '\u{fe5c}'), ('\u{fe5d}', '\u{fe5d}'), ('\u{fe5e}', '\u{fe5e}'), ('\u{fe5f}', '\u{fe61}'),
        ('\u{fe62}', '\u{fe62}'), ('\u{fe63}', '\u{fe63}'), ('\u{fe64}', '\u{fe66}'), ('\u{fe68}',
        '\u{fe68}'), ('\u{fe69}', '\u{fe69}'), ('\u{fe6a}', '\u{fe6b}'), ('\u{feff}', '\u{feff}'),
        ('\u{ff01}', '\u{ff03}'), ('\u{ff04}', '\u{ff04}'), ('\u{ff05}', '\u{ff07}'), ('\u{ff08}',
        '\u{ff08}'), ('\u{ff09}', '\u{ff09}'), ('\u{ff0a}', '\u{ff0a}'), ('\u{ff0b}', '\u{ff0b}'),
        ('\u{ff0c}', '\u{ff0c}'), ('\u{ff0d}', '\u{ff0d}'), ('\u{ff0e}', '\u{ff0f}'), ('\u{ff10}',
        '\u{ff19}'), ('\u{ff1a}', '\u{ff1b}'), ('\u{ff1c}', '\u{ff1e}'), ('\u{ff1f}', '\u{ff20}'),
        ('\u{ff3b}', '\u{ff3b}'), ('\u{ff3c}', '\u{ff3c}'), ('\u{ff3d}', '\u{ff3d}'), ('\u{ff3e}',
        '\u{ff3e}'), ('\u{ff3f}', '\u{ff3f}'), ('\u{ff40}', '\u{ff40}'), ('\u{ff5b}', '\u{ff5b}'),
        ('\u{ff5c}', '\u{ff5c}'), ('\u{ff5d}', '\u{ff5d}'), ('\u{ff5e}', '\u{ff5e}'), ('\u{ff5f}',
        '\u{ff5f}'), ('\u{ff60}', '\u{ff60}'), ('\u{ff61}', '\u{ff61}'), ('\u{ff62}', '\u{ff62}'),
        ('\u{ff63}', '\u{ff63}'), ('\u{ff64}', '\u{ff65}'), ('\u{ff70}', '\u{ff70}'), ('\u{ff9e}',
        '\u{ff9f}'), ('\u{ffe0}', '\u{ffe1}'), ('\u{ffe2}', '\u{ffe2}'), ('\u{ffe3}', '\u{ffe3}'),
        ('\u{ffe4}', '\u{ffe4}'), ('\u{ffe5}', '\u{ffe6}'), ('\u{ffe8}', '\u{ffe8}'), ('\u{ffe9}',
        '\u{ffec}'), ('\u{ffed}', '\u{ffee}'), ('\u{fff9}', '\u{fffb}'), ('\u{fffc}', '\u{fffd}'),
        ('\u{10100}', '\u{10102}'), ('\u{10107}', '\u{10133}'), ('\u{10137}', '\u{1013f}'),
        ('\u{10190}', '\u{1019b}'), ('\u{101d0}', '\u{101fc}'), ('\u{102e1}', '\u{102fb}'),
        ('\u{1bca0}', '\u{1bca3}'), ('\u{1d000}', '\u{1d0f5}'), ('\u{1d100}', '\u{1d126}'),
        ('\u{1d129}', '\u{1d164}'), ('\u{1d165}', '\u{1d166}'), ('\u{1d16a}', '\u{1d16c}'),
        ('\u{1d16d}', '\u{1d172}'), ('\u{1d173}', '\u{1d17a}'), ('\u{1d183}', '\u{1d184}'),
        ('\u{1d18c}', '\u{1d1a9}'), ('\u{1d1ae}', '\u{1d1dd}'), ('\u{1d300}', '\u{1d356}'),
        ('\u{1d360}', '\u{1d371}'), ('\u{1d400}', '\u{1d454}'), ('\u{1d456}', '\u{1d49c}'),
        ('\u{1d49e}', '\u{1d49f}'), ('\u{1d4a2}', '\u{1d4a2}'), ('\u{1d4a5}', '\u{1d4a6}'),
        ('\u{1d4a9}', '\u{1d4ac}'), ('\u{1d4ae}', '\u{1d4b9}'), ('\u{1d4bb}', '\u{1d4bb}'),
        ('\u{1d4bd}', '\u{1d4c3}'), ('\u{1d4c5}', '\u{1d505}'), ('\u{1d507}', '\u{1d50a}'),
        ('\u{1d50d}', '\u{1d514}'), ('\u{1d516}', '\u{1d51c}'), ('\u{1d51e}', '\u{1d539}'),
        ('\u{1d53b}', '\u{1d53e}'), ('\u{1d540}', '\u{1d544}'), ('\u{1d546}', '\u{1d546}'),
        ('\u{1d54a}', '\u{1d550}'), ('\u{1d552}', '\u{1d6a5}'), ('\u{1d6a8}', '\u{1d6c0}'),
        ('\u{1d6c1}', '\u{1d6c1}'), ('\u{1d6c2}', '\u{1d6da}'), ('\u{1d6db}', '\u{1d6db}'),
        ('\u{1d6dc}', '\u{1d6fa}'), ('\u{1d6fb}', '\u{1d6fb}'), ('\u{1d6fc}', '\u{1d714}'),
        ('\u{1d715}', '\u{1d715}'), ('\u{1d716}', '\u{1d734}'), ('\u{1d735}', '\u{1d735}'),
        ('\u{1d736}', '\u{1d74e}'), ('\u{1d74f}', '\u{1d74f}'), ('\u{1d750}', '\u{1d76e}'),
        ('\u{1d76f}', '\u{1d76f}'), ('\u{1d770}', '\u{1d788}'), ('\u{1d789}', '\u{1d789}'),
        ('\u{1d78a}', '\u{1d7a8}'), ('\u{1d7a9}', '\u{1d7a9}'), ('\u{1d7aa}', '\u{1d7c2}'),
        ('\u{1d7c3}', '\u{1d7c3}'), ('\u{1d7c4}', '\u{1d7cb}'), ('\u{1d7ce}', '\u{1d7ff}'),
        ('\u{1f000}', '\u{1f02b}'), ('\u{1f030}', '\u{1f093}'), ('\u{1f0a0}', '\u{1f0ae}'),
        ('\u{1f0b1}', '\u{1f0bf}'), ('\u{1f0c1}', '\u{1f0cf}'), ('\u{1f0d1}', '\u{1f0f5}'),
        ('\u{1f100}', '\u{1f10c}'), ('\u{1f110}', '\u{1f12e}'), ('\u{1f130}', '\u{1f16b}'),
        ('\u{1f170}', '\u{1f19a}'), ('\u{1f1e6}', '\u{1f1ff}'), ('\u{1f201}', '\u{1f202}'),
        ('\u{1f210}', '\u{1f23a}'), ('\u{1f240}', '\u{1f248}'), ('\u{1f250}', '\u{1f251}'),
        ('\u{1f300}', '\u{1f32c}'), ('\u{1f330}', '\u{1f37d}'), ('\u{1f380}', '\u{1f3ce}'),
        ('\u{1f3d4}', '\u{1f3f7}'), ('\u{1f400}', '\u{1f4fe}'), ('\u{1f500}', '\u{1f54a}'),
        ('\u{1f550}', '\u{1f579}'), ('\u{1f57b}', '\u{1f5a3}'), ('\u{1f5a5}', '\u{1f642}'),
        ('\u{1f645}', '\u{1f6cf}'), ('\u{1f6e0}', '\u{1f6ec}'), ('\u{1f6f0}', '\u{1f6f3}'),
        ('\u{1f700}', '\u{1f773}'), ('\u{1f780}', '\u{1f7d4}'), ('\u{1f800}', '\u{1f80b}'),
        ('\u{1f810}', '\u{1f847}'), ('\u{1f850}', '\u{1f859}'), ('\u{1f860}', '\u{1f887}'),
        ('\u{1f890}', '\u{1f8ad}'), ('\u{e0001}', '\u{e0001}'), ('\u{e0020}', '\u{e007f}')
    ];

    pub static Coptic_table: &'static [(char, char)] = &[
        ('\u{3e2}', '\u{3ef}'), ('\u{2c80}', '\u{2ce4}'), ('\u{2ce5}', '\u{2cea}'), ('\u{2ceb}',
        '\u{2cee}'), ('\u{2cef}', '\u{2cf1}'), ('\u{2cf2}', '\u{2cf3}'), ('\u{2cf9}', '\u{2cfc}'),
        ('\u{2cfd}', '\u{2cfd}'), ('\u{2cfe}', '\u{2cff}')
    ];

    pub static Cuneiform_table: &'static [(char, char)] = &[
        ('\u{12000}', '\u{12398}'), ('\u{12400}', '\u{1246e}'), ('\u{12470}', '\u{12474}')
    ];

    pub static Cypriot_table: &'static [(char, char)] = &[
        ('\u{10800}', '\u{10805}'), ('\u{10808}', '\u{10808}'), ('\u{1080a}', '\u{10835}'),
        ('\u{10837}', '\u{10838}'), ('\u{1083c}', '\u{1083c}'), ('\u{1083f}', '\u{1083f}')
    ];

    pub static Cyrillic_table: &'static [(char, char)] = &[
        ('\u{400}', '\u{481}'), ('\u{482}', '\u{482}'), ('\u{483}', '\u{484}'), ('\u{487}',
        '\u{487}'), ('\u{488}', '\u{489}'), ('\u{48a}', '\u{52f}'), ('\u{1d2b}', '\u{1d2b}'),
        ('\u{1d78}', '\u{1d78}'), ('\u{2de0}', '\u{2dff}'), ('\u{a640}', '\u{a66d}'), ('\u{a66e}',
        '\u{a66e}'), ('\u{a66f}', '\u{a66f}'), ('\u{a670}', '\u{a672}'), ('\u{a673}', '\u{a673}'),
        ('\u{a674}', '\u{a67d}'), ('\u{a67e}', '\u{a67e}'), ('\u{a67f}', '\u{a67f}'), ('\u{a680}',
        '\u{a69b}'), ('\u{a69c}', '\u{a69d}'), ('\u{a69f}', '\u{a69f}')
    ];

    pub static Deseret_table: &'static [(char, char)] = &[
        ('\u{10400}', '\u{1044f}')
    ];

    pub static Devanagari_table: &'static [(char, char)] = &[
        ('\u{900}', '\u{902}'), ('\u{903}', '\u{903}'), ('\u{904}', '\u{939}'), ('\u{93a}',
        '\u{93a}'), ('\u{93b}', '\u{93b}'), ('\u{93c}', '\u{93c}'), ('\u{93d}', '\u{93d}'),
        ('\u{93e}', '\u{940}'), ('\u{941}', '\u{948}'), ('\u{949}', '\u{94c}'), ('\u{94d}',
        '\u{94d}'), ('\u{94e}', '\u{94f}'), ('\u{950}', '\u{950}'), ('\u{953}', '\u{957}'),
        ('\u{958}', '\u{961}'), ('\u{962}', '\u{963}'), ('\u{966}', '\u{96f}'), ('\u{970}',
        '\u{970}'), ('\u{971}', '\u{971}'), ('\u{972}', '\u{97f}'), ('\u{a8e0}', '\u{a8f1}'),
        ('\u{a8f2}', '\u{a8f7}'), ('\u{a8f8}', '\u{a8fa}'), ('\u{a8fb}', '\u{a8fb}')
    ];

    pub static Duployan_table: &'static [(char, char)] = &[
        ('\u{1bc00}', '\u{1bc6a}'), ('\u{1bc70}', '\u{1bc7c}'), ('\u{1bc80}', '\u{1bc88}'),
        ('\u{1bc90}', '\u{1bc99}'), ('\u{1bc9c}', '\u{1bc9c}'), ('\u{1bc9d}', '\u{1bc9e}'),
        ('\u{1bc9f}', '\u{1bc9f}')
    ];

    pub static Egyptian_Hieroglyphs_table: &'static [(char, char)] = &[
        ('\u{13000}', '\u{1342e}')
    ];

    pub static Elbasan_table: &'static [(char, char)] = &[
        ('\u{10500}', '\u{10527}')
    ];

    pub static Ethiopic_table: &'static [(char, char)] = &[
        ('\u{1200}', '\u{1248}'), ('\u{124a}', '\u{124d}'), ('\u{1250}', '\u{1256}'), ('\u{1258}',
        '\u{1258}'), ('\u{125a}', '\u{125d}'), ('\u{1260}', '\u{1288}'), ('\u{128a}', '\u{128d}'),
        ('\u{1290}', '\u{12b0}'), ('\u{12b2}', '\u{12b5}'), ('\u{12b8}', '\u{12be}'), ('\u{12c0}',
        '\u{12c0}'), ('\u{12c2}', '\u{12c5}'), ('\u{12c8}', '\u{12d6}'), ('\u{12d8}', '\u{1310}'),
        ('\u{1312}', '\u{1315}'), ('\u{1318}', '\u{135a}'), ('\u{135d}', '\u{135f}'), ('\u{1360}',
        '\u{1368}'), ('\u{1369}', '\u{137c}'), ('\u{1380}', '\u{138f}'), ('\u{1390}', '\u{1399}'),
        ('\u{2d80}', '\u{2d96}'), ('\u{2da0}', '\u{2da6}'), ('\u{2da8}', '\u{2dae}'), ('\u{2db0}',
        '\u{2db6}'), ('\u{2db8}', '\u{2dbe}'), ('\u{2dc0}', '\u{2dc6}'), ('\u{2dc8}', '\u{2dce}'),
        ('\u{2dd0}', '\u{2dd6}'), ('\u{2dd8}', '\u{2dde}'), ('\u{ab01}', '\u{ab06}'), ('\u{ab09}',
        '\u{ab0e}'), ('\u{ab11}', '\u{ab16}'), ('\u{ab20}', '\u{ab26}'), ('\u{ab28}', '\u{ab2e}')
    ];

    pub static Georgian_table: &'static [(char, char)] = &[
        ('\u{10a0}', '\u{10c5}'), ('\u{10c7}', '\u{10c7}'), ('\u{10cd}', '\u{10cd}'), ('\u{10d0}',
        '\u{10fa}'), ('\u{10fc}', '\u{10fc}'), ('\u{10fd}', '\u{10ff}'), ('\u{2d00}', '\u{2d25}'),
        ('\u{2d27}', '\u{2d27}'), ('\u{2d2d}', '\u{2d2d}')
    ];

    pub static Glagolitic_table: &'static [(char, char)] = &[
        ('\u{2c00}', '\u{2c2e}'), ('\u{2c30}', '\u{2c5e}')
    ];

    pub static Gothic_table: &'static [(char, char)] = &[
        ('\u{10330}', '\u{10340}'), ('\u{10341}', '\u{10341}'), ('\u{10342}', '\u{10349}'),
        ('\u{1034a}', '\u{1034a}')
    ];

    pub static Grantha_table: &'static [(char, char)] = &[
        ('\u{11301}', '\u{11301}'), ('\u{11302}', '\u{11303}'), ('\u{11305}', '\u{1130c}'),
        ('\u{1130f}', '\u{11310}'), ('\u{11313}', '\u{11328}'), ('\u{1132a}', '\u{11330}'),
        ('\u{11332}', '\u{11333}'), ('\u{11335}', '\u{11339}'), ('\u{1133c}', '\u{1133c}'),
        ('\u{1133d}', '\u{1133d}'), ('\u{1133e}', '\u{1133f}'), ('\u{11340}', '\u{11340}'),
        ('\u{11341}', '\u{11344}'), ('\u{11347}', '\u{11348}'), ('\u{1134b}', '\u{1134d}'),
        ('\u{11357}', '\u{11357}'), ('\u{1135d}', '\u{11361}'), ('\u{11362}', '\u{11363}'),
        ('\u{11366}', '\u{1136c}'), ('\u{11370}', '\u{11374}')
    ];

    pub static Greek_table: &'static [(char, char)] = &[
        ('\u{370}', '\u{373}'), ('\u{375}', '\u{375}'), ('\u{376}', '\u{377}'), ('\u{37a}',
        '\u{37a}'), ('\u{37b}', '\u{37d}'), ('\u{37f}', '\u{37f}'), ('\u{384}', '\u{384}'),
        ('\u{386}', '\u{386}'), ('\u{388}', '\u{38a}'), ('\u{38c}', '\u{38c}'), ('\u{38e}',
        '\u{3a1}'), ('\u{3a3}', '\u{3e1}'), ('\u{3f0}', '\u{3f5}'), ('\u{3f6}', '\u{3f6}'),
        ('\u{3f7}', '\u{3ff}'), ('\u{1d26}', '\u{1d2a}'), ('\u{1d5d}', '\u{1d61}'), ('\u{1d66}',
        '\u{1d6a}'), ('\u{1dbf}', '\u{1dbf}'), ('\u{1f00}', '\u{1f15}'), ('\u{1f18}', '\u{1f1d}'),
        ('\u{1f20}', '\u{1f45}'), ('\u{1f48}', '\u{1f4d}'), ('\u{1f50}', '\u{1f57}'), ('\u{1f59}',
        '\u{1f59}'), ('\u{1f5b}', '\u{1f5b}'), ('\u{1f5d}', '\u{1f5d}'), ('\u{1f5f}', '\u{1f7d}'),
        ('\u{1f80}', '\u{1fb4}'), ('\u{1fb6}', '\u{1fbc}'), ('\u{1fbd}', '\u{1fbd}'), ('\u{1fbe}',
        '\u{1fbe}'), ('\u{1fbf}', '\u{1fc1}'), ('\u{1fc2}', '\u{1fc4}'), ('\u{1fc6}', '\u{1fcc}'),
        ('\u{1fcd}', '\u{1fcf}'), ('\u{1fd0}', '\u{1fd3}'), ('\u{1fd6}', '\u{1fdb}'), ('\u{1fdd}',
        '\u{1fdf}'), ('\u{1fe0}', '\u{1fec}'), ('\u{1fed}', '\u{1fef}'), ('\u{1ff2}', '\u{1ff4}'),
        ('\u{1ff6}', '\u{1ffc}'), ('\u{1ffd}', '\u{1ffe}'), ('\u{2126}', '\u{2126}'), ('\u{ab65}',
        '\u{ab65}'), ('\u{10140}', '\u{10174}'), ('\u{10175}', '\u{10178}'), ('\u{10179}',
        '\u{10189}'), ('\u{1018a}', '\u{1018b}'), ('\u{1018c}', '\u{1018c}'), ('\u{101a0}',
        '\u{101a0}'), ('\u{1d200}', '\u{1d241}'), ('\u{1d242}', '\u{1d244}'), ('\u{1d245}',
        '\u{1d245}')
    ];

    pub static Gujarati_table: &'static [(char, char)] = &[
        ('\u{a81}', '\u{a82}'), ('\u{a83}', '\u{a83}'), ('\u{a85}', '\u{a8d}'), ('\u{a8f}',
        '\u{a91}'), ('\u{a93}', '\u{aa8}'), ('\u{aaa}', '\u{ab0}'), ('\u{ab2}', '\u{ab3}'),
        ('\u{ab5}', '\u{ab9}'), ('\u{abc}', '\u{abc}'), ('\u{abd}', '\u{abd}'), ('\u{abe}',
        '\u{ac0}'), ('\u{ac1}', '\u{ac5}'), ('\u{ac7}', '\u{ac8}'), ('\u{ac9}', '\u{ac9}'),
        ('\u{acb}', '\u{acc}'), ('\u{acd}', '\u{acd}'), ('\u{ad0}', '\u{ad0}'), ('\u{ae0}',
        '\u{ae1}'), ('\u{ae2}', '\u{ae3}'), ('\u{ae6}', '\u{aef}'), ('\u{af0}', '\u{af0}'),
        ('\u{af1}', '\u{af1}')
    ];

    pub static Gurmukhi_table: &'static [(char, char)] = &[
        ('\u{a01}', '\u{a02}'), ('\u{a03}', '\u{a03}'), ('\u{a05}', '\u{a0a}'), ('\u{a0f}',
        '\u{a10}'), ('\u{a13}', '\u{a28}'), ('\u{a2a}', '\u{a30}'), ('\u{a32}', '\u{a33}'),
        ('\u{a35}', '\u{a36}'), ('\u{a38}', '\u{a39}'), ('\u{a3c}', '\u{a3c}'), ('\u{a3e}',
        '\u{a40}'), ('\u{a41}', '\u{a42}'), ('\u{a47}', '\u{a48}'), ('\u{a4b}', '\u{a4d}'),
        ('\u{a51}', '\u{a51}'), ('\u{a59}', '\u{a5c}'), ('\u{a5e}', '\u{a5e}'), ('\u{a66}',
        '\u{a6f}'), ('\u{a70}', '\u{a71}'), ('\u{a72}', '\u{a74}'), ('\u{a75}', '\u{a75}')
    ];

    pub static Han_table: &'static [(char, char)] = &[
        ('\u{2e80}', '\u{2e99}'), ('\u{2e9b}', '\u{2ef3}'), ('\u{2f00}', '\u{2fd5}'), ('\u{3005}',
        '\u{3005}'), ('\u{3007}', '\u{3007}'), ('\u{3021}', '\u{3029}'), ('\u{3038}', '\u{303a}'),
        ('\u{303b}', '\u{303b}'), ('\u{3400}', '\u{4db5}'), ('\u{4e00}', '\u{9fcc}'), ('\u{f900}',
        '\u{fa6d}'), ('\u{fa70}', '\u{fad9}'), ('\u{20000}', '\u{2a6d6}'), ('\u{2a700}',
        '\u{2b734}'), ('\u{2b740}', '\u{2b81d}'), ('\u{2f800}', '\u{2fa1d}')
    ];

    pub static Hangul_table: &'static [(char, char)] = &[
        ('\u{1100}', '\u{11ff}'), ('\u{302e}', '\u{302f}'), ('\u{3131}', '\u{318e}'), ('\u{3200}',
        '\u{321e}'), ('\u{3260}', '\u{327e}'), ('\u{a960}', '\u{a97c}'), ('\u{ac00}', '\u{d7a3}'),
        ('\u{d7b0}', '\u{d7c6}'), ('\u{d7cb}', '\u{d7fb}'), ('\u{ffa0}', '\u{ffbe}'), ('\u{ffc2}',
        '\u{ffc7}'), ('\u{ffca}', '\u{ffcf}'), ('\u{ffd2}', '\u{ffd7}'), ('\u{ffda}', '\u{ffdc}')
    ];

    pub static Hanunoo_table: &'static [(char, char)] = &[
        ('\u{1720}', '\u{1731}'), ('\u{1732}', '\u{1734}')
    ];

    pub static Hebrew_table: &'static [(char, char)] = &[
        ('\u{591}', '\u{5bd}'), ('\u{5be}', '\u{5be}'), ('\u{5bf}', '\u{5bf}'), ('\u{5c0}',
        '\u{5c0}'), ('\u{5c1}', '\u{5c2}'), ('\u{5c3}', '\u{5c3}'), ('\u{5c4}', '\u{5c5}'),
        ('\u{5c6}', '\u{5c6}'), ('\u{5c7}', '\u{5c7}'), ('\u{5d0}', '\u{5ea}'), ('\u{5f0}',
        '\u{5f2}'), ('\u{5f3}', '\u{5f4}'), ('\u{fb1d}', '\u{fb1d}'), ('\u{fb1e}', '\u{fb1e}'),
        ('\u{fb1f}', '\u{fb28}'), ('\u{fb29}', '\u{fb29}'), ('\u{fb2a}', '\u{fb36}'), ('\u{fb38}',
        '\u{fb3c}'), ('\u{fb3e}', '\u{fb3e}'), ('\u{fb40}', '\u{fb41}'), ('\u{fb43}', '\u{fb44}'),
        ('\u{fb46}', '\u{fb4f}')
    ];

    pub static Hiragana_table: &'static [(char, char)] = &[
        ('\u{3041}', '\u{3096}'), ('\u{309d}', '\u{309e}'), ('\u{309f}', '\u{309f}'), ('\u{1b001}',
        '\u{1b001}'), ('\u{1f200}', '\u{1f200}')
    ];

    pub static Imperial_Aramaic_table: &'static [(char, char)] = &[
        ('\u{10840}', '\u{10855}'), ('\u{10857}', '\u{10857}'), ('\u{10858}', '\u{1085f}')
    ];

    pub static Inherited_table: &'static [(char, char)] = &[
        ('\u{300}', '\u{36f}'), ('\u{485}', '\u{486}'), ('\u{64b}', '\u{655}'), ('\u{670}',
        '\u{670}'), ('\u{951}', '\u{952}'), ('\u{1ab0}', '\u{1abd}'), ('\u{1abe}', '\u{1abe}'),
        ('\u{1cd0}', '\u{1cd2}'), ('\u{1cd4}', '\u{1ce0}'), ('\u{1ce2}', '\u{1ce8}'), ('\u{1ced}',
        '\u{1ced}'), ('\u{1cf4}', '\u{1cf4}'), ('\u{1cf8}', '\u{1cf9}'), ('\u{1dc0}', '\u{1df5}'),
        ('\u{1dfc}', '\u{1dff}'), ('\u{200c}', '\u{200d}'), ('\u{20d0}', '\u{20dc}'), ('\u{20dd}',
        '\u{20e0}'), ('\u{20e1}', '\u{20e1}'), ('\u{20e2}', '\u{20e4}'), ('\u{20e5}', '\u{20f0}'),
        ('\u{302a}', '\u{302d}'), ('\u{3099}', '\u{309a}'), ('\u{fe00}', '\u{fe0f}'), ('\u{fe20}',
        '\u{fe2d}'), ('\u{101fd}', '\u{101fd}'), ('\u{102e0}', '\u{102e0}'), ('\u{1d167}',
        '\u{1d169}'), ('\u{1d17b}', '\u{1d182}'), ('\u{1d185}', '\u{1d18b}'), ('\u{1d1aa}',
        '\u{1d1ad}'), ('\u{e0100}', '\u{e01ef}')
    ];

    pub static Inscriptional_Pahlavi_table: &'static [(char, char)] = &[
        ('\u{10b60}', '\u{10b72}'), ('\u{10b78}', '\u{10b7f}')
    ];

    pub static Inscriptional_Parthian_table: &'static [(char, char)] = &[
        ('\u{10b40}', '\u{10b55}'), ('\u{10b58}', '\u{10b5f}')
    ];

    pub static Javanese_table: &'static [(char, char)] = &[
        ('\u{a980}', '\u{a982}'), ('\u{a983}', '\u{a983}'), ('\u{a984}', '\u{a9b2}'), ('\u{a9b3}',
        '\u{a9b3}'), ('\u{a9b4}', '\u{a9b5}'), ('\u{a9b6}', '\u{a9b9}'), ('\u{a9ba}', '\u{a9bb}'),
        ('\u{a9bc}', '\u{a9bc}'), ('\u{a9bd}', '\u{a9c0}'), ('\u{a9c1}', '\u{a9cd}'), ('\u{a9d0}',
        '\u{a9d9}'), ('\u{a9de}', '\u{a9df}')
    ];

    pub static Kaithi_table: &'static [(char, char)] = &[
        ('\u{11080}', '\u{11081}'), ('\u{11082}', '\u{11082}'), ('\u{11083}', '\u{110af}'),
        ('\u{110b0}', '\u{110b2}'), ('\u{110b3}', '\u{110b6}'), ('\u{110b7}', '\u{110b8}'),
        ('\u{110b9}', '\u{110ba}'), ('\u{110bb}', '\u{110bc}'), ('\u{110bd}', '\u{110bd}'),
        ('\u{110be}', '\u{110c1}')
    ];

    pub static Kannada_table: &'static [(char, char)] = &[
        ('\u{c81}', '\u{c81}'), ('\u{c82}', '\u{c83}'), ('\u{c85}', '\u{c8c}'), ('\u{c8e}',
        '\u{c90}'), ('\u{c92}', '\u{ca8}'), ('\u{caa}', '\u{cb3}'), ('\u{cb5}', '\u{cb9}'),
        ('\u{cbc}', '\u{cbc}'), ('\u{cbd}', '\u{cbd}'), ('\u{cbe}', '\u{cbe}'), ('\u{cbf}',
        '\u{cbf}'), ('\u{cc0}', '\u{cc4}'), ('\u{cc6}', '\u{cc6}'), ('\u{cc7}', '\u{cc8}'),
        ('\u{cca}', '\u{ccb}'), ('\u{ccc}', '\u{ccd}'), ('\u{cd5}', '\u{cd6}'), ('\u{cde}',
        '\u{cde}'), ('\u{ce0}', '\u{ce1}'), ('\u{ce2}', '\u{ce3}'), ('\u{ce6}', '\u{cef}'),
        ('\u{cf1}', '\u{cf2}')
    ];

    pub static Katakana_table: &'static [(char, char)] = &[
        ('\u{30a1}', '\u{30fa}'), ('\u{30fd}', '\u{30fe}'), ('\u{30ff}', '\u{30ff}'), ('\u{31f0}',
        '\u{31ff}'), ('\u{32d0}', '\u{32fe}'), ('\u{3300}', '\u{3357}'), ('\u{ff66}', '\u{ff6f}'),
        ('\u{ff71}', '\u{ff9d}'), ('\u{1b000}', '\u{1b000}')
    ];

    pub static Kayah_Li_table: &'static [(char, char)] = &[
        ('\u{a900}', '\u{a909}'), ('\u{a90a}', '\u{a925}'), ('\u{a926}', '\u{a92d}'), ('\u{a92f}',
        '\u{a92f}')
    ];

    pub static Kharoshthi_table: &'static [(char, char)] = &[
        ('\u{10a00}', '\u{10a00}'), ('\u{10a01}', '\u{10a03}'), ('\u{10a05}', '\u{10a06}'),
        ('\u{10a0c}', '\u{10a0f}'), ('\u{10a10}', '\u{10a13}'), ('\u{10a15}', '\u{10a17}'),
        ('\u{10a19}', '\u{10a33}'), ('\u{10a38}', '\u{10a3a}'), ('\u{10a3f}', '\u{10a3f}'),
        ('\u{10a40}', '\u{10a47}'), ('\u{10a50}', '\u{10a58}')
    ];

    pub static Khmer_table: &'static [(char, char)] = &[
        ('\u{1780}', '\u{17b3}'), ('\u{17b4}', '\u{17b5}'), ('\u{17b6}', '\u{17b6}'), ('\u{17b7}',
        '\u{17bd}'), ('\u{17be}', '\u{17c5}'), ('\u{17c6}', '\u{17c6}'), ('\u{17c7}', '\u{17c8}'),
        ('\u{17c9}', '\u{17d3}'), ('\u{17d4}', '\u{17d6}'), ('\u{17d7}', '\u{17d7}'), ('\u{17d8}',
        '\u{17da}'), ('\u{17db}', '\u{17db}'), ('\u{17dc}', '\u{17dc}'), ('\u{17dd}', '\u{17dd}'),
        ('\u{17e0}', '\u{17e9}'), ('\u{17f0}', '\u{17f9}'), ('\u{19e0}', '\u{19ff}')
    ];

    pub static Khojki_table: &'static [(char, char)] = &[
        ('\u{11200}', '\u{11211}'), ('\u{11213}', '\u{1122b}'), ('\u{1122c}', '\u{1122e}'),
        ('\u{1122f}', '\u{11231}'), ('\u{11232}', '\u{11233}'), ('\u{11234}', '\u{11234}'),
        ('\u{11235}', '\u{11235}'), ('\u{11236}', '\u{11237}'), ('\u{11238}', '\u{1123d}')
    ];

    pub static Khudawadi_table: &'static [(char, char)] = &[
        ('\u{112b0}', '\u{112de}'), ('\u{112df}', '\u{112df}'), ('\u{112e0}', '\u{112e2}'),
        ('\u{112e3}', '\u{112ea}'), ('\u{112f0}', '\u{112f9}')
    ];

    pub static Lao_table: &'static [(char, char)] = &[
        ('\u{e81}', '\u{e82}'), ('\u{e84}', '\u{e84}'), ('\u{e87}', '\u{e88}'), ('\u{e8a}',
        '\u{e8a}'), ('\u{e8d}', '\u{e8d}'), ('\u{e94}', '\u{e97}'), ('\u{e99}', '\u{e9f}'),
        ('\u{ea1}', '\u{ea3}'), ('\u{ea5}', '\u{ea5}'), ('\u{ea7}', '\u{ea7}'), ('\u{eaa}',
        '\u{eab}'), ('\u{ead}', '\u{eb0}'), ('\u{eb1}', '\u{eb1}'), ('\u{eb2}', '\u{eb3}'),
        ('\u{eb4}', '\u{eb9}'), ('\u{ebb}', '\u{ebc}'), ('\u{ebd}', '\u{ebd}'), ('\u{ec0}',
        '\u{ec4}'), ('\u{ec6}', '\u{ec6}'), ('\u{ec8}', '\u{ecd}'), ('\u{ed0}', '\u{ed9}'),
        ('\u{edc}', '\u{edf}')
    ];

    pub static Latin_table: &'static [(char, char)] = &[
        ('\u{41}', '\u{5a}'), ('\u{61}', '\u{7a}'), ('\u{aa}', '\u{aa}'), ('\u{ba}', '\u{ba}'),
        ('\u{c0}', '\u{d6}'), ('\u{d8}', '\u{f6}'), ('\u{f8}', '\u{1ba}'), ('\u{1bb}', '\u{1bb}'),
        ('\u{1bc}', '\u{1bf}'), ('\u{1c0}', '\u{1c3}'), ('\u{1c4}', '\u{293}'), ('\u{294}',
        '\u{294}'), ('\u{295}', '\u{2af}'), ('\u{2b0}', '\u{2b8}'), ('\u{2e0}', '\u{2e4}'),
        ('\u{1d00}', '\u{1d25}'), ('\u{1d2c}', '\u{1d5c}'), ('\u{1d62}', '\u{1d65}'), ('\u{1d6b}',
        '\u{1d77}'), ('\u{1d79}', '\u{1d9a}'), ('\u{1d9b}', '\u{1dbe}'), ('\u{1e00}', '\u{1eff}'),
        ('\u{2071}', '\u{2071}'), ('\u{207f}', '\u{207f}'), ('\u{2090}', '\u{209c}'), ('\u{212a}',
        '\u{212b}'), ('\u{2132}', '\u{2132}'), ('\u{214e}', '\u{214e}'), ('\u{2160}', '\u{2182}'),
        ('\u{2183}', '\u{2184}'), ('\u{2185}', '\u{2188}'), ('\u{2c60}', '\u{2c7b}'), ('\u{2c7c}',
        '\u{2c7d}'), ('\u{2c7e}', '\u{2c7f}'), ('\u{a722}', '\u{a76f}'), ('\u{a770}', '\u{a770}'),
        ('\u{a771}', '\u{a787}'), ('\u{a78b}', '\u{a78e}'), ('\u{a790}', '\u{a7ad}'), ('\u{a7b0}',
        '\u{a7b1}'), ('\u{a7f7}', '\u{a7f7}'), ('\u{a7f8}', '\u{a7f9}'), ('\u{a7fa}', '\u{a7fa}'),
        ('\u{a7fb}', '\u{a7ff}'), ('\u{ab30}', '\u{ab5a}'), ('\u{ab5c}', '\u{ab5f}'), ('\u{ab64}',
        '\u{ab64}'), ('\u{fb00}', '\u{fb06}'), ('\u{ff21}', '\u{ff3a}'), ('\u{ff41}', '\u{ff5a}')
    ];

    pub static Lepcha_table: &'static [(char, char)] = &[
        ('\u{1c00}', '\u{1c23}'), ('\u{1c24}', '\u{1c2b}'), ('\u{1c2c}', '\u{1c33}'), ('\u{1c34}',
        '\u{1c35}'), ('\u{1c36}', '\u{1c37}'), ('\u{1c3b}', '\u{1c3f}'), ('\u{1c40}', '\u{1c49}'),
        ('\u{1c4d}', '\u{1c4f}')
    ];

    pub static Limbu_table: &'static [(char, char)] = &[
        ('\u{1900}', '\u{191e}'), ('\u{1920}', '\u{1922}'), ('\u{1923}', '\u{1926}'), ('\u{1927}',
        '\u{1928}'), ('\u{1929}', '\u{192b}'), ('\u{1930}', '\u{1931}'), ('\u{1932}', '\u{1932}'),
        ('\u{1933}', '\u{1938}'), ('\u{1939}', '\u{193b}'), ('\u{1940}', '\u{1940}'), ('\u{1944}',
        '\u{1945}'), ('\u{1946}', '\u{194f}')
    ];

    pub static Linear_A_table: &'static [(char, char)] = &[
        ('\u{10600}', '\u{10736}'), ('\u{10740}', '\u{10755}'), ('\u{10760}', '\u{10767}')
    ];

    pub static Linear_B_table: &'static [(char, char)] = &[
        ('\u{10000}', '\u{1000b}'), ('\u{1000d}', '\u{10026}'), ('\u{10028}', '\u{1003a}'),
        ('\u{1003c}', '\u{1003d}'), ('\u{1003f}', '\u{1004d}'), ('\u{10050}', '\u{1005d}'),
        ('\u{10080}', '\u{100fa}')
    ];

    pub static Lisu_table: &'static [(char, char)] = &[
        ('\u{a4d0}', '\u{a4f7}'), ('\u{a4f8}', '\u{a4fd}'), ('\u{a4fe}', '\u{a4ff}')
    ];

    pub static Lycian_table: &'static [(char, char)] = &[
        ('\u{10280}', '\u{1029c}')
    ];

    pub static Lydian_table: &'static [(char, char)] = &[
        ('\u{10920}', '\u{10939}'), ('\u{1093f}', '\u{1093f}')
    ];

    pub static Mahajani_table: &'static [(char, char)] = &[
        ('\u{11150}', '\u{11172}'), ('\u{11173}', '\u{11173}'), ('\u{11174}', '\u{11175}'),
        ('\u{11176}', '\u{11176}')
    ];

    pub static Malayalam_table: &'static [(char, char)] = &[
        ('\u{d01}', '\u{d01}'), ('\u{d02}', '\u{d03}'), ('\u{d05}', '\u{d0c}'), ('\u{d0e}',
        '\u{d10}'), ('\u{d12}', '\u{d3a}'), ('\u{d3d}', '\u{d3d}'), ('\u{d3e}', '\u{d40}'),
        ('\u{d41}', '\u{d44}'), ('\u{d46}', '\u{d48}'), ('\u{d4a}', '\u{d4c}'), ('\u{d4d}',
        '\u{d4d}'), ('\u{d4e}', '\u{d4e}'), ('\u{d57}', '\u{d57}'), ('\u{d60}', '\u{d61}'),
        ('\u{d62}', '\u{d63}'), ('\u{d66}', '\u{d6f}'), ('\u{d70}', '\u{d75}'), ('\u{d79}',
        '\u{d79}'), ('\u{d7a}', '\u{d7f}')
    ];

    pub static Mandaic_table: &'static [(char, char)] = &[
        ('\u{840}', '\u{858}'), ('\u{859}', '\u{85b}'), ('\u{85e}', '\u{85e}')
    ];

    pub static Manichaean_table: &'static [(char, char)] = &[
        ('\u{10ac0}', '\u{10ac7}'), ('\u{10ac8}', '\u{10ac8}'), ('\u{10ac9}', '\u{10ae4}'),
        ('\u{10ae5}', '\u{10ae6}'), ('\u{10aeb}', '\u{10aef}'), ('\u{10af0}', '\u{10af6}')
    ];

    pub static Meetei_Mayek_table: &'static [(char, char)] = &[
        ('\u{aae0}', '\u{aaea}'), ('\u{aaeb}', '\u{aaeb}'), ('\u{aaec}', '\u{aaed}'), ('\u{aaee}',
        '\u{aaef}'), ('\u{aaf0}', '\u{aaf1}'), ('\u{aaf2}', '\u{aaf2}'), ('\u{aaf3}', '\u{aaf4}'),
        ('\u{aaf5}', '\u{aaf5}'), ('\u{aaf6}', '\u{aaf6}'), ('\u{abc0}', '\u{abe2}'), ('\u{abe3}',
        '\u{abe4}'), ('\u{abe5}', '\u{abe5}'), ('\u{abe6}', '\u{abe7}'), ('\u{abe8}', '\u{abe8}'),
        ('\u{abe9}', '\u{abea}'), ('\u{abeb}', '\u{abeb}'), ('\u{abec}', '\u{abec}'), ('\u{abed}',
        '\u{abed}'), ('\u{abf0}', '\u{abf9}')
    ];

    pub static Mende_Kikakui_table: &'static [(char, char)] = &[
        ('\u{1e800}', '\u{1e8c4}'), ('\u{1e8c7}', '\u{1e8cf}'), ('\u{1e8d0}', '\u{1e8d6}')
    ];

    pub static Meroitic_Cursive_table: &'static [(char, char)] = &[
        ('\u{109a0}', '\u{109b7}'), ('\u{109be}', '\u{109bf}')
    ];

    pub static Meroitic_Hieroglyphs_table: &'static [(char, char)] = &[
        ('\u{10980}', '\u{1099f}')
    ];

    pub static Miao_table: &'static [(char, char)] = &[
        ('\u{16f00}', '\u{16f44}'), ('\u{16f50}', '\u{16f50}'), ('\u{16f51}', '\u{16f7e}'),
        ('\u{16f8f}', '\u{16f92}'), ('\u{16f93}', '\u{16f9f}')
    ];

    pub static Modi_table: &'static [(char, char)] = &[
        ('\u{11600}', '\u{1162f}'), ('\u{11630}', '\u{11632}'), ('\u{11633}', '\u{1163a}'),
        ('\u{1163b}', '\u{1163c}'), ('\u{1163d}', '\u{1163d}'), ('\u{1163e}', '\u{1163e}'),
        ('\u{1163f}', '\u{11640}'), ('\u{11641}', '\u{11643}'), ('\u{11644}', '\u{11644}'),
        ('\u{11650}', '\u{11659}')
    ];

    pub static Mongolian_table: &'static [(char, char)] = &[
        ('\u{1800}', '\u{1801}'), ('\u{1804}', '\u{1804}'), ('\u{1806}', '\u{1806}'), ('\u{1807}',
        '\u{180a}'), ('\u{180b}', '\u{180d}'), ('\u{180e}', '\u{180e}'), ('\u{1810}', '\u{1819}'),
        ('\u{1820}', '\u{1842}'), ('\u{1843}', '\u{1843}'), ('\u{1844}', '\u{1877}'), ('\u{1880}',
        '\u{18a8}'), ('\u{18a9}', '\u{18a9}'), ('\u{18aa}', '\u{18aa}')
    ];

    pub static Mro_table: &'static [(char, char)] = &[
        ('\u{16a40}', '\u{16a5e}'), ('\u{16a60}', '\u{16a69}'), ('\u{16a6e}', '\u{16a6f}')
    ];

    pub static Myanmar_table: &'static [(char, char)] = &[
        ('\u{1000}', '\u{102a}'), ('\u{102b}', '\u{102c}'), ('\u{102d}', '\u{1030}'), ('\u{1031}',
        '\u{1031}'), ('\u{1032}', '\u{1037}'), ('\u{1038}', '\u{1038}'), ('\u{1039}', '\u{103a}'),
        ('\u{103b}', '\u{103c}'), ('\u{103d}', '\u{103e}'), ('\u{103f}', '\u{103f}'), ('\u{1040}',
        '\u{1049}'), ('\u{104a}', '\u{104f}'), ('\u{1050}', '\u{1055}'), ('\u{1056}', '\u{1057}'),
        ('\u{1058}', '\u{1059}'), ('\u{105a}', '\u{105d}'), ('\u{105e}', '\u{1060}'), ('\u{1061}',
        '\u{1061}'), ('\u{1062}', '\u{1064}'), ('\u{1065}', '\u{1066}'), ('\u{1067}', '\u{106d}'),
        ('\u{106e}', '\u{1070}'), ('\u{1071}', '\u{1074}'), ('\u{1075}', '\u{1081}'), ('\u{1082}',
        '\u{1082}'), ('\u{1083}', '\u{1084}'), ('\u{1085}', '\u{1086}'), ('\u{1087}', '\u{108c}'),
        ('\u{108d}', '\u{108d}'), ('\u{108e}', '\u{108e}'), ('\u{108f}', '\u{108f}'), ('\u{1090}',
        '\u{1099}'), ('\u{109a}', '\u{109c}'), ('\u{109d}', '\u{109d}'), ('\u{109e}', '\u{109f}'),
        ('\u{a9e0}', '\u{a9e4}'), ('\u{a9e5}', '\u{a9e5}'), ('\u{a9e6}', '\u{a9e6}'), ('\u{a9e7}',
        '\u{a9ef}'), ('\u{a9f0}', '\u{a9f9}'), ('\u{a9fa}', '\u{a9fe}'), ('\u{aa60}', '\u{aa6f}'),
        ('\u{aa70}', '\u{aa70}'), ('\u{aa71}', '\u{aa76}'), ('\u{aa77}', '\u{aa79}'), ('\u{aa7a}',
        '\u{aa7a}'), ('\u{aa7b}', '\u{aa7b}'), ('\u{aa7c}', '\u{aa7c}'), ('\u{aa7d}', '\u{aa7d}'),
        ('\u{aa7e}', '\u{aa7f}')
    ];

    pub static Nabataean_table: &'static [(char, char)] = &[
        ('\u{10880}', '\u{1089e}'), ('\u{108a7}', '\u{108af}')
    ];

    pub static New_Tai_Lue_table: &'static [(char, char)] = &[
        ('\u{1980}', '\u{19ab}'), ('\u{19b0}', '\u{19c0}'), ('\u{19c1}', '\u{19c7}'), ('\u{19c8}',
        '\u{19c9}'), ('\u{19d0}', '\u{19d9}'), ('\u{19da}', '\u{19da}'), ('\u{19de}', '\u{19df}')
    ];

    pub static Nko_table: &'static [(char, char)] = &[
        ('\u{7c0}', '\u{7c9}'), ('\u{7ca}', '\u{7ea}'), ('\u{7eb}', '\u{7f3}'), ('\u{7f4}',
        '\u{7f5}'), ('\u{7f6}', '\u{7f6}'), ('\u{7f7}', '\u{7f9}'), ('\u{7fa}', '\u{7fa}')
    ];

    pub static Ogham_table: &'static [(char, char)] = &[
        ('\u{1680}', '\u{1680}'), ('\u{1681}', '\u{169a}'), ('\u{169b}', '\u{169b}'), ('\u{169c}',
        '\u{169c}')
    ];

    pub static Ol_Chiki_table: &'static [(char, char)] = &[
        ('\u{1c50}', '\u{1c59}'), ('\u{1c5a}', '\u{1c77}'), ('\u{1c78}', '\u{1c7d}'), ('\u{1c7e}',
        '\u{1c7f}')
    ];

    pub static Old_Italic_table: &'static [(char, char)] = &[
        ('\u{10300}', '\u{1031f}'), ('\u{10320}', '\u{10323}')
    ];

    pub static Old_North_Arabian_table: &'static [(char, char)] = &[
        ('\u{10a80}', '\u{10a9c}'), ('\u{10a9d}', '\u{10a9f}')
    ];

    pub static Old_Permic_table: &'static [(char, char)] = &[
        ('\u{10350}', '\u{10375}'), ('\u{10376}', '\u{1037a}')
    ];

    pub static Old_Persian_table: &'static [(char, char)] = &[
        ('\u{103a0}', '\u{103c3}'), ('\u{103c8}', '\u{103cf}'), ('\u{103d0}', '\u{103d0}'),
        ('\u{103d1}', '\u{103d5}')
    ];

    pub static Old_South_Arabian_table: &'static [(char, char)] = &[
        ('\u{10a60}', '\u{10a7c}'), ('\u{10a7d}', '\u{10a7e}'), ('\u{10a7f}', '\u{10a7f}')
    ];

    pub static Old_Turkic_table: &'static [(char, char)] = &[
        ('\u{10c00}', '\u{10c48}')
    ];

    pub static Oriya_table: &'static [(char, char)] = &[
        ('\u{b01}', '\u{b01}'), ('\u{b02}', '\u{b03}'), ('\u{b05}', '\u{b0c}'), ('\u{b0f}',
        '\u{b10}'), ('\u{b13}', '\u{b28}'), ('\u{b2a}', '\u{b30}'), ('\u{b32}', '\u{b33}'),
        ('\u{b35}', '\u{b39}'), ('\u{b3c}', '\u{b3c}'), ('\u{b3d}', '\u{b3d}'), ('\u{b3e}',
        '\u{b3e}'), ('\u{b3f}', '\u{b3f}'), ('\u{b40}', '\u{b40}'), ('\u{b41}', '\u{b44}'),
        ('\u{b47}', '\u{b48}'), ('\u{b4b}', '\u{b4c}'), ('\u{b4d}', '\u{b4d}'), ('\u{b56}',
        '\u{b56}'), ('\u{b57}', '\u{b57}'), ('\u{b5c}', '\u{b5d}'), ('\u{b5f}', '\u{b61}'),
        ('\u{b62}', '\u{b63}'), ('\u{b66}', '\u{b6f}'), ('\u{b70}', '\u{b70}'), ('\u{b71}',
        '\u{b71}'), ('\u{b72}', '\u{b77}')
    ];

    pub static Osmanya_table: &'static [(char, char)] = &[
        ('\u{10480}', '\u{1049d}'), ('\u{104a0}', '\u{104a9}')
    ];

    pub static Pahawh_Hmong_table: &'static [(char, char)] = &[
        ('\u{16b00}', '\u{16b2f}'), ('\u{16b30}', '\u{16b36}'), ('\u{16b37}', '\u{16b3b}'),
        ('\u{16b3c}', '\u{16b3f}'), ('\u{16b40}', '\u{16b43}'), ('\u{16b44}', '\u{16b44}'),
        ('\u{16b45}', '\u{16b45}'), ('\u{16b50}', '\u{16b59}'), ('\u{16b5b}', '\u{16b61}'),
        ('\u{16b63}', '\u{16b77}'), ('\u{16b7d}', '\u{16b8f}')
    ];

    pub static Palmyrene_table: &'static [(char, char)] = &[
        ('\u{10860}', '\u{10876}'), ('\u{10877}', '\u{10878}'), ('\u{10879}', '\u{1087f}')
    ];

    pub static Pau_Cin_Hau_table: &'static [(char, char)] = &[
        ('\u{11ac0}', '\u{11af8}')
    ];

    pub static Phags_Pa_table: &'static [(char, char)] = &[
        ('\u{a840}', '\u{a873}'), ('\u{a874}', '\u{a877}')
    ];

    pub static Phoenician_table: &'static [(char, char)] = &[
        ('\u{10900}', '\u{10915}'), ('\u{10916}', '\u{1091b}'), ('\u{1091f}', '\u{1091f}')
    ];

    pub static Psalter_Pahlavi_table: &'static [(char, char)] = &[
        ('\u{10b80}', '\u{10b91}'), ('\u{10b99}', '\u{10b9c}'), ('\u{10ba9}', '\u{10baf}')
    ];

    pub static Rejang_table: &'static [(char, char)] = &[
        ('\u{a930}', '\u{a946}'), ('\u{a947}', '\u{a951}'), ('\u{a952}', '\u{a953}'), ('\u{a95f}',
        '\u{a95f}')
    ];

    pub static Runic_table: &'static [(char, char)] = &[
        ('\u{16a0}', '\u{16ea}'), ('\u{16ee}', '\u{16f0}'), ('\u{16f1}', '\u{16f8}')
    ];

    pub static Samaritan_table: &'static [(char, char)] = &[
        ('\u{800}', '\u{815}'), ('\u{816}', '\u{819}'), ('\u{81a}', '\u{81a}'), ('\u{81b}',
        '\u{823}'), ('\u{824}', '\u{824}'), ('\u{825}', '\u{827}'), ('\u{828}', '\u{828}'),
        ('\u{829}', '\u{82d}'), ('\u{830}', '\u{83e}')
    ];

    pub static Saurashtra_table: &'static [(char, char)] = &[
        ('\u{a880}', '\u{a881}'), ('\u{a882}', '\u{a8b3}'), ('\u{a8b4}', '\u{a8c3}'), ('\u{a8c4}',
        '\u{a8c4}'), ('\u{a8ce}', '\u{a8cf}'), ('\u{a8d0}', '\u{a8d9}')
    ];

    pub static Sharada_table: &'static [(char, char)] = &[
        ('\u{11180}', '\u{11181}'), ('\u{11182}', '\u{11182}'), ('\u{11183}', '\u{111b2}'),
        ('\u{111b3}', '\u{111b5}'), ('\u{111b6}', '\u{111be}'), ('\u{111bf}', '\u{111c0}'),
        ('\u{111c1}', '\u{111c4}'), ('\u{111c5}', '\u{111c8}'), ('\u{111cd}', '\u{111cd}'),
        ('\u{111d0}', '\u{111d9}'), ('\u{111da}', '\u{111da}')
    ];

    pub static Shavian_table: &'static [(char, char)] = &[
        ('\u{10450}', '\u{1047f}')
    ];

    pub static Siddham_table: &'static [(char, char)] = &[
        ('\u{11580}', '\u{115ae}'), ('\u{115af}', '\u{115b1}'), ('\u{115b2}', '\u{115b5}'),
        ('\u{115b8}', '\u{115bb}'), ('\u{115bc}', '\u{115bd}'), ('\u{115be}', '\u{115be}'),
        ('\u{115bf}', '\u{115c0}'), ('\u{115c1}', '\u{115c9}')
    ];

    pub static Sinhala_table: &'static [(char, char)] = &[
        ('\u{d82}', '\u{d83}'), ('\u{d85}', '\u{d96}'), ('\u{d9a}', '\u{db1}'), ('\u{db3}',
        '\u{dbb}'), ('\u{dbd}', '\u{dbd}'), ('\u{dc0}', '\u{dc6}'), ('\u{dca}', '\u{dca}'),
        ('\u{dcf}', '\u{dd1}'), ('\u{dd2}', '\u{dd4}'), ('\u{dd6}', '\u{dd6}'), ('\u{dd8}',
        '\u{ddf}'), ('\u{de6}', '\u{def}'), ('\u{df2}', '\u{df3}'), ('\u{df4}', '\u{df4}'),
        ('\u{111e1}', '\u{111f4}')
    ];

    pub static Sora_Sompeng_table: &'static [(char, char)] = &[
        ('\u{110d0}', '\u{110e8}'), ('\u{110f0}', '\u{110f9}')
    ];

    pub static Sundanese_table: &'static [(char, char)] = &[
        ('\u{1b80}', '\u{1b81}'), ('\u{1b82}', '\u{1b82}'), ('\u{1b83}', '\u{1ba0}'), ('\u{1ba1}',
        '\u{1ba1}'), ('\u{1ba2}', '\u{1ba5}'), ('\u{1ba6}', '\u{1ba7}'), ('\u{1ba8}', '\u{1ba9}'),
        ('\u{1baa}', '\u{1baa}'), ('\u{1bab}', '\u{1bad}'), ('\u{1bae}', '\u{1baf}'), ('\u{1bb0}',
        '\u{1bb9}'), ('\u{1bba}', '\u{1bbf}'), ('\u{1cc0}', '\u{1cc7}')
    ];

    pub static Syloti_Nagri_table: &'static [(char, char)] = &[
        ('\u{a800}', '\u{a801}'), ('\u{a802}', '\u{a802}'), ('\u{a803}', '\u{a805}'), ('\u{a806}',
        '\u{a806}'), ('\u{a807}', '\u{a80a}'), ('\u{a80b}', '\u{a80b}'), ('\u{a80c}', '\u{a822}'),
        ('\u{a823}', '\u{a824}'), ('\u{a825}', '\u{a826}'), ('\u{a827}', '\u{a827}'), ('\u{a828}',
        '\u{a82b}')
    ];

    pub static Syriac_table: &'static [(char, char)] = &[
        ('\u{700}', '\u{70d}'), ('\u{70f}', '\u{70f}'), ('\u{710}', '\u{710}'), ('\u{711}',
        '\u{711}'), ('\u{712}', '\u{72f}'), ('\u{730}', '\u{74a}'), ('\u{74d}', '\u{74f}')
    ];

    pub static Tagalog_table: &'static [(char, char)] = &[
        ('\u{1700}', '\u{170c}'), ('\u{170e}', '\u{1711}'), ('\u{1712}', '\u{1714}')
    ];

    pub static Tagbanwa_table: &'static [(char, char)] = &[
        ('\u{1760}', '\u{176c}'), ('\u{176e}', '\u{1770}'), ('\u{1772}', '\u{1773}')
    ];

    pub static Tai_Le_table: &'static [(char, char)] = &[
        ('\u{1950}', '\u{196d}'), ('\u{1970}', '\u{1974}')
    ];

    pub static Tai_Tham_table: &'static [(char, char)] = &[
        ('\u{1a20}', '\u{1a54}'), ('\u{1a55}', '\u{1a55}'), ('\u{1a56}', '\u{1a56}'), ('\u{1a57}',
        '\u{1a57}'), ('\u{1a58}', '\u{1a5e}'), ('\u{1a60}', '\u{1a60}'), ('\u{1a61}', '\u{1a61}'),
        ('\u{1a62}', '\u{1a62}'), ('\u{1a63}', '\u{1a64}'), ('\u{1a65}', '\u{1a6c}'), ('\u{1a6d}',
        '\u{1a72}'), ('\u{1a73}', '\u{1a7c}'), ('\u{1a7f}', '\u{1a7f}'), ('\u{1a80}', '\u{1a89}'),
        ('\u{1a90}', '\u{1a99}'), ('\u{1aa0}', '\u{1aa6}'), ('\u{1aa7}', '\u{1aa7}'), ('\u{1aa8}',
        '\u{1aad}')
    ];

    pub static Tai_Viet_table: &'static [(char, char)] = &[
        ('\u{aa80}', '\u{aaaf}'), ('\u{aab0}', '\u{aab0}'), ('\u{aab1}', '\u{aab1}'), ('\u{aab2}',
        '\u{aab4}'), ('\u{aab5}', '\u{aab6}'), ('\u{aab7}', '\u{aab8}'), ('\u{aab9}', '\u{aabd}'),
        ('\u{aabe}', '\u{aabf}'), ('\u{aac0}', '\u{aac0}'), ('\u{aac1}', '\u{aac1}'), ('\u{aac2}',
        '\u{aac2}'), ('\u{aadb}', '\u{aadc}'), ('\u{aadd}', '\u{aadd}'), ('\u{aade}', '\u{aadf}')
    ];

    pub static Takri_table: &'static [(char, char)] = &[
        ('\u{11680}', '\u{116aa}'), ('\u{116ab}', '\u{116ab}'), ('\u{116ac}', '\u{116ac}'),
        ('\u{116ad}', '\u{116ad}'), ('\u{116ae}', '\u{116af}'), ('\u{116b0}', '\u{116b5}'),
        ('\u{116b6}', '\u{116b6}'), ('\u{116b7}', '\u{116b7}'), ('\u{116c0}', '\u{116c9}')
    ];

    pub static Tamil_table: &'static [(char, char)] = &[
        ('\u{b82}', '\u{b82}'), ('\u{b83}', '\u{b83}'), ('\u{b85}', '\u{b8a}'), ('\u{b8e}',
        '\u{b90}'), ('\u{b92}', '\u{b95}'), ('\u{b99}', '\u{b9a}'), ('\u{b9c}', '\u{b9c}'),
        ('\u{b9e}', '\u{b9f}'), ('\u{ba3}', '\u{ba4}'), ('\u{ba8}', '\u{baa}'), ('\u{bae}',
        '\u{bb9}'), ('\u{bbe}', '\u{bbf}'), ('\u{bc0}', '\u{bc0}'), ('\u{bc1}', '\u{bc2}'),
        ('\u{bc6}', '\u{bc8}'), ('\u{bca}', '\u{bcc}'), ('\u{bcd}', '\u{bcd}'), ('\u{bd0}',
        '\u{bd0}'), ('\u{bd7}', '\u{bd7}'), ('\u{be6}', '\u{bef}'), ('\u{bf0}', '\u{bf2}'),
        ('\u{bf3}', '\u{bf8}'), ('\u{bf9}', '\u{bf9}'), ('\u{bfa}', '\u{bfa}')
    ];

    pub static Telugu_table: &'static [(char, char)] = &[
        ('\u{c00}', '\u{c00}'), ('\u{c01}', '\u{c03}'), ('\u{c05}', '\u{c0c}'), ('\u{c0e}',
        '\u{c10}'), ('\u{c12}', '\u{c28}'), ('\u{c2a}', '\u{c39}'), ('\u{c3d}', '\u{c3d}'),
        ('\u{c3e}', '\u{c40}'), ('\u{c41}', '\u{c44}'), ('\u{c46}', '\u{c48}'), ('\u{c4a}',
        '\u{c4d}'), ('\u{c55}', '\u{c56}'), ('\u{c58}', '\u{c59}'), ('\u{c60}', '\u{c61}'),
        ('\u{c62}', '\u{c63}'), ('\u{c66}', '\u{c6f}'), ('\u{c78}', '\u{c7e}'), ('\u{c7f}',
        '\u{c7f}')
    ];

    pub static Thaana_table: &'static [(char, char)] = &[
        ('\u{780}', '\u{7a5}'), ('\u{7a6}', '\u{7b0}'), ('\u{7b1}', '\u{7b1}')
    ];

    pub static Thai_table: &'static [(char, char)] = &[
        ('\u{e01}', '\u{e30}'), ('\u{e31}', '\u{e31}'), ('\u{e32}', '\u{e33}'), ('\u{e34}',
        '\u{e3a}'), ('\u{e40}', '\u{e45}'), ('\u{e46}', '\u{e46}'), ('\u{e47}', '\u{e4e}'),
        ('\u{e4f}', '\u{e4f}'), ('\u{e50}', '\u{e59}'), ('\u{e5a}', '\u{e5b}')
    ];

    pub static Tibetan_table: &'static [(char, char)] = &[
        ('\u{f00}', '\u{f00}'), ('\u{f01}', '\u{f03}'), ('\u{f04}', '\u{f12}'), ('\u{f13}',
        '\u{f13}'), ('\u{f14}', '\u{f14}'), ('\u{f15}', '\u{f17}'), ('\u{f18}', '\u{f19}'),
        ('\u{f1a}', '\u{f1f}'), ('\u{f20}', '\u{f29}'), ('\u{f2a}', '\u{f33}'), ('\u{f34}',
        '\u{f34}'), ('\u{f35}', '\u{f35}'), ('\u{f36}', '\u{f36}'), ('\u{f37}', '\u{f37}'),
        ('\u{f38}', '\u{f38}'), ('\u{f39}', '\u{f39}'), ('\u{f3a}', '\u{f3a}'), ('\u{f3b}',
        '\u{f3b}'), ('\u{f3c}', '\u{f3c}'), ('\u{f3d}', '\u{f3d}'), ('\u{f3e}', '\u{f3f}'),
        ('\u{f40}', '\u{f47}'), ('\u{f49}', '\u{f6c}'), ('\u{f71}', '\u{f7e}'), ('\u{f7f}',
        '\u{f7f}'), ('\u{f80}', '\u{f84}'), ('\u{f85}', '\u{f85}'), ('\u{f86}', '\u{f87}'),
        ('\u{f88}', '\u{f8c}'), ('\u{f8d}', '\u{f97}'), ('\u{f99}', '\u{fbc}'), ('\u{fbe}',
        '\u{fc5}'), ('\u{fc6}', '\u{fc6}'), ('\u{fc7}', '\u{fcc}'), ('\u{fce}', '\u{fcf}'),
        ('\u{fd0}', '\u{fd4}'), ('\u{fd9}', '\u{fda}')
    ];

    pub static Tifinagh_table: &'static [(char, char)] = &[
        ('\u{2d30}', '\u{2d67}'), ('\u{2d6f}', '\u{2d6f}'), ('\u{2d70}', '\u{2d70}'), ('\u{2d7f}',
        '\u{2d7f}')
    ];

    pub static Tirhuta_table: &'static [(char, char)] = &[
        ('\u{11480}', '\u{114af}'), ('\u{114b0}', '\u{114b2}'), ('\u{114b3}', '\u{114b8}'),
        ('\u{114b9}', '\u{114b9}'), ('\u{114ba}', '\u{114ba}'), ('\u{114bb}', '\u{114be}'),
        ('\u{114bf}', '\u{114c0}'), ('\u{114c1}', '\u{114c1}'), ('\u{114c2}', '\u{114c3}'),
        ('\u{114c4}', '\u{114c5}'), ('\u{114c6}', '\u{114c6}'), ('\u{114c7}', '\u{114c7}'),
        ('\u{114d0}', '\u{114d9}')
    ];

    pub static Ugaritic_table: &'static [(char, char)] = &[
        ('\u{10380}', '\u{1039d}'), ('\u{1039f}', '\u{1039f}')
    ];

    pub static Vai_table: &'static [(char, char)] = &[
        ('\u{a500}', '\u{a60b}'), ('\u{a60c}', '\u{a60c}'), ('\u{a60d}', '\u{a60f}'), ('\u{a610}',
        '\u{a61f}'), ('\u{a620}', '\u{a629}'), ('\u{a62a}', '\u{a62b}')
    ];

    pub static Warang_Citi_table: &'static [(char, char)] = &[
        ('\u{118a0}', '\u{118df}'), ('\u{118e0}', '\u{118e9}'), ('\u{118ea}', '\u{118f2}'),
        ('\u{118ff}', '\u{118ff}')
    ];

    pub static Yi_table: &'static [(char, char)] = &[
        ('\u{a000}', '\u{a014}'), ('\u{a015}', '\u{a015}'), ('\u{a016}', '\u{a48c}'), ('\u{a490}',
        '\u{a4c6}')
    ];

}

pub mod property {
    pub static Join_Control_table: &'static [(char, char)] = &[
        ('\u{200c}', '\u{200d}')
    ];

    pub static Noncharacter_Code_Point_table: &'static [(char, char)] = &[
        ('\u{fdd0}', '\u{fdef}'), ('\u{fffe}', '\u{ffff}'), ('\u{1fffe}', '\u{1ffff}'),
        ('\u{2fffe}', '\u{2ffff}'), ('\u{3fffe}', '\u{3ffff}'), ('\u{4fffe}', '\u{4ffff}'),
        ('\u{5fffe}', '\u{5ffff}'), ('\u{6fffe}', '\u{6ffff}'), ('\u{7fffe}', '\u{7ffff}'),
        ('\u{8fffe}', '\u{8ffff}'), ('\u{9fffe}', '\u{9ffff}'), ('\u{afffe}', '\u{affff}'),
        ('\u{bfffe}', '\u{bffff}'), ('\u{cfffe}', '\u{cffff}'), ('\u{dfffe}', '\u{dffff}'),
        ('\u{efffe}', '\u{effff}'), ('\u{ffffe}', '\u{fffff}')
    ];

    pub static White_Space_table: &'static [(char, char)] = &[
        ('\u{9}', '\u{d}'), ('\u{20}', '\u{20}'), ('\u{85}', '\u{85}'), ('\u{a0}', '\u{a0}'),
        ('\u{1680}', '\u{1680}'), ('\u{2000}', '\u{200a}'), ('\u{2028}', '\u{2028}'), ('\u{2029}',
        '\u{2029}'), ('\u{202f}', '\u{202f}'), ('\u{205f}', '\u{205f}'), ('\u{3000}', '\u{3000}')
    ];

    pub fn White_Space(c: char) -> bool {
        super::bsearch_range_table(c, White_Space_table)
    }

}

pub mod regex {
    pub static UNICODE_CLASSES: &'static [(&'static str, &'static &'static [(char, char)])] = &[
        ("Alphabetic", &super::derived_property::Alphabetic_table), ("Arabic",
        &super::script::Arabic_table), ("Armenian", &super::script::Armenian_table), ("Avestan",
        &super::script::Avestan_table), ("Balinese", &super::script::Balinese_table), ("Bamum",
        &super::script::Bamum_table), ("Bassa_Vah", &super::script::Bassa_Vah_table), ("Batak",
        &super::script::Batak_table), ("Bengali", &super::script::Bengali_table), ("Bopomofo",
        &super::script::Bopomofo_table), ("Brahmi", &super::script::Brahmi_table), ("Braille",
        &super::script::Braille_table), ("Buginese", &super::script::Buginese_table), ("Buhid",
        &super::script::Buhid_table), ("C", &super::general_category::C_table),
        ("Canadian_Aboriginal", &super::script::Canadian_Aboriginal_table), ("Carian",
        &super::script::Carian_table), ("Caucasian_Albanian",
        &super::script::Caucasian_Albanian_table), ("Cc", &super::general_category::Cc_table),
        ("Cf", &super::general_category::Cf_table), ("Chakma", &super::script::Chakma_table),
        ("Cham", &super::script::Cham_table), ("Cherokee", &super::script::Cherokee_table), ("Cn",
        &super::general_category::Cn_table), ("Co", &super::general_category::Co_table), ("Common",
        &super::script::Common_table), ("Coptic", &super::script::Coptic_table), ("Cuneiform",
        &super::script::Cuneiform_table), ("Cypriot", &super::script::Cypriot_table), ("Cyrillic",
        &super::script::Cyrillic_table), ("Default_Ignorable_Code_Point",
        &super::derived_property::Default_Ignorable_Code_Point_table), ("Deseret",
        &super::script::Deseret_table), ("Devanagari", &super::script::Devanagari_table),
        ("Duployan", &super::script::Duployan_table), ("Egyptian_Hieroglyphs",
        &super::script::Egyptian_Hieroglyphs_table), ("Elbasan", &super::script::Elbasan_table),
        ("Ethiopic", &super::script::Ethiopic_table), ("Georgian", &super::script::Georgian_table),
        ("Glagolitic", &super::script::Glagolitic_table), ("Gothic", &super::script::Gothic_table),
        ("Grantha", &super::script::Grantha_table), ("Greek", &super::script::Greek_table),
        ("Gujarati", &super::script::Gujarati_table), ("Gurmukhi", &super::script::Gurmukhi_table),
        ("Han", &super::script::Han_table), ("Hangul", &super::script::Hangul_table), ("Hanunoo",
        &super::script::Hanunoo_table), ("Hebrew", &super::script::Hebrew_table), ("Hiragana",
        &super::script::Hiragana_table), ("Imperial_Aramaic",
        &super::script::Imperial_Aramaic_table), ("Inherited", &super::script::Inherited_table),
        ("Inscriptional_Pahlavi", &super::script::Inscriptional_Pahlavi_table),
        ("Inscriptional_Parthian", &super::script::Inscriptional_Parthian_table), ("Javanese",
        &super::script::Javanese_table), ("Join_Control", &super::property::Join_Control_table),
        ("Kaithi", &super::script::Kaithi_table), ("Kannada", &super::script::Kannada_table),
        ("Katakana", &super::script::Katakana_table), ("Kayah_Li", &super::script::Kayah_Li_table),
        ("Kharoshthi", &super::script::Kharoshthi_table), ("Khmer", &super::script::Khmer_table),
        ("Khojki", &super::script::Khojki_table), ("Khudawadi", &super::script::Khudawadi_table),
        ("L", &super::general_category::L_table), ("LC", &super::general_category::LC_table),
        ("Lao", &super::script::Lao_table), ("Latin", &super::script::Latin_table), ("Lepcha",
        &super::script::Lepcha_table), ("Limbu", &super::script::Limbu_table), ("Linear_A",
        &super::script::Linear_A_table), ("Linear_B", &super::script::Linear_B_table), ("Lisu",
        &super::script::Lisu_table), ("Ll", &super::general_category::Ll_table), ("Lm",
        &super::general_category::Lm_table), ("Lo", &super::general_category::Lo_table),
        ("Lowercase", &super::derived_property::Lowercase_table), ("Lt",
        &super::general_category::Lt_table), ("Lu", &super::general_category::Lu_table), ("Lycian",
        &super::script::Lycian_table), ("Lydian", &super::script::Lydian_table), ("M",
        &super::general_category::M_table), ("Mahajani", &super::script::Mahajani_table),
        ("Malayalam", &super::script::Malayalam_table), ("Mandaic", &super::script::Mandaic_table),
        ("Manichaean", &super::script::Manichaean_table), ("Mc",
        &super::general_category::Mc_table), ("Me", &super::general_category::Me_table),
        ("Meetei_Mayek", &super::script::Meetei_Mayek_table), ("Mende_Kikakui",
        &super::script::Mende_Kikakui_table), ("Meroitic_Cursive",
        &super::script::Meroitic_Cursive_table), ("Meroitic_Hieroglyphs",
        &super::script::Meroitic_Hieroglyphs_table), ("Miao", &super::script::Miao_table), ("Mn",
        &super::general_category::Mn_table), ("Modi", &super::script::Modi_table), ("Mongolian",
        &super::script::Mongolian_table), ("Mro", &super::script::Mro_table), ("Myanmar",
        &super::script::Myanmar_table), ("N", &super::general_category::N_table), ("Nabataean",
        &super::script::Nabataean_table), ("Nd", &super::general_category::Nd_table),
        ("New_Tai_Lue", &super::script::New_Tai_Lue_table), ("Nko", &super::script::Nko_table),
        ("Nl", &super::general_category::Nl_table), ("No", &super::general_category::No_table),
        ("Noncharacter_Code_Point", &super::property::Noncharacter_Code_Point_table), ("Ogham",
        &super::script::Ogham_table), ("Ol_Chiki", &super::script::Ol_Chiki_table), ("Old_Italic",
        &super::script::Old_Italic_table), ("Old_North_Arabian",
        &super::script::Old_North_Arabian_table), ("Old_Permic", &super::script::Old_Permic_table),
        ("Old_Persian", &super::script::Old_Persian_table), ("Old_South_Arabian",
        &super::script::Old_South_Arabian_table), ("Old_Turkic", &super::script::Old_Turkic_table),
        ("Oriya", &super::script::Oriya_table), ("Osmanya", &super::script::Osmanya_table), ("P",
        &super::general_category::P_table), ("Pahawh_Hmong", &super::script::Pahawh_Hmong_table),
        ("Palmyrene", &super::script::Palmyrene_table), ("Pau_Cin_Hau",
        &super::script::Pau_Cin_Hau_table), ("Pc", &super::general_category::Pc_table), ("Pd",
        &super::general_category::Pd_table), ("Pe", &super::general_category::Pe_table), ("Pf",
        &super::general_category::Pf_table), ("Phags_Pa", &super::script::Phags_Pa_table),
        ("Phoenician", &super::script::Phoenician_table), ("Pi",
        &super::general_category::Pi_table), ("Po", &super::general_category::Po_table), ("Ps",
        &super::general_category::Ps_table), ("Psalter_Pahlavi",
        &super::script::Psalter_Pahlavi_table), ("Rejang", &super::script::Rejang_table), ("Runic",
        &super::script::Runic_table), ("S", &super::general_category::S_table), ("Samaritan",
        &super::script::Samaritan_table), ("Saurashtra", &super::script::Saurashtra_table), ("Sc",
        &super::general_category::Sc_table), ("Sharada", &super::script::Sharada_table), ("Shavian",
        &super::script::Shavian_table), ("Siddham", &super::script::Siddham_table), ("Sinhala",
        &super::script::Sinhala_table), ("Sk", &super::general_category::Sk_table), ("Sm",
        &super::general_category::Sm_table), ("So", &super::general_category::So_table),
        ("Sora_Sompeng", &super::script::Sora_Sompeng_table), ("Sundanese",
        &super::script::Sundanese_table), ("Syloti_Nagri", &super::script::Syloti_Nagri_table),
        ("Syriac", &super::script::Syriac_table), ("Tagalog", &super::script::Tagalog_table),
        ("Tagbanwa", &super::script::Tagbanwa_table), ("Tai_Le", &super::script::Tai_Le_table),
        ("Tai_Tham", &super::script::Tai_Tham_table), ("Tai_Viet", &super::script::Tai_Viet_table),
        ("Takri", &super::script::Takri_table), ("Tamil", &super::script::Tamil_table), ("Telugu",
        &super::script::Telugu_table), ("Thaana", &super::script::Thaana_table), ("Thai",
        &super::script::Thai_table), ("Tibetan", &super::script::Tibetan_table), ("Tifinagh",
        &super::script::Tifinagh_table), ("Tirhuta", &super::script::Tirhuta_table), ("Ugaritic",
        &super::script::Ugaritic_table), ("Uppercase", &super::derived_property::Uppercase_table),
        ("Vai", &super::script::Vai_table), ("Warang_Citi", &super::script::Warang_Citi_table),
        ("White_Space", &super::property::White_Space_table), ("XID_Continue",
        &super::derived_property::XID_Continue_table), ("XID_Start",
        &super::derived_property::XID_Start_table), ("Yi", &super::script::Yi_table), ("Z",
        &super::general_category::Z_table), ("Zl", &super::general_category::Zl_table), ("Zp",
        &super::general_category::Zp_table), ("Zs", &super::general_category::Zs_table)
    ];

    pub static PERLD: &'static &'static [(char, char)] = &super::general_category::Nd_table;

    pub static PERLS: &'static &'static [(char, char)] = &super::property::White_Space_table;

    pub static PERLW: &'static [(char, char)] = &[
        ('\u{30}', '\u{39}'), ('\u{41}', '\u{5a}'), ('\u{5f}', '\u{5f}'), ('\u{61}', '\u{7a}'),
        ('\u{aa}', '\u{aa}'), ('\u{b5}', '\u{b5}'), ('\u{ba}', '\u{ba}'), ('\u{c0}', '\u{d6}'),
        ('\u{d8}', '\u{f6}'), ('\u{f8}', '\u{2c1}'), ('\u{2c6}', '\u{2d1}'), ('\u{2e0}', '\u{2e4}'),
        ('\u{2ec}', '\u{2ec}'), ('\u{2ee}', '\u{2ee}'), ('\u{300}', '\u{374}'), ('\u{376}',
        '\u{377}'), ('\u{37a}', '\u{37d}'), ('\u{37f}', '\u{37f}'), ('\u{386}', '\u{386}'),
        ('\u{388}', '\u{38a}'), ('\u{38c}', '\u{38c}'), ('\u{38e}', '\u{3a1}'), ('\u{3a3}',
        '\u{3f5}'), ('\u{3f7}', '\u{481}'), ('\u{483}', '\u{52f}'), ('\u{531}', '\u{556}'),
        ('\u{559}', '\u{559}'), ('\u{561}', '\u{587}'), ('\u{591}', '\u{5bd}'), ('\u{5bf}',
        '\u{5bf}'), ('\u{5c1}', '\u{5c2}'), ('\u{5c4}', '\u{5c5}'), ('\u{5c7}', '\u{5c7}'),
        ('\u{5d0}', '\u{5ea}'), ('\u{5f0}', '\u{5f2}'), ('\u{610}', '\u{61a}'), ('\u{620}',
        '\u{669}'), ('\u{66e}', '\u{6d3}'), ('\u{6d5}', '\u{6dc}'), ('\u{6df}', '\u{6e8}'),
        ('\u{6ea}', '\u{6fc}'), ('\u{6ff}', '\u{6ff}'), ('\u{710}', '\u{74a}'), ('\u{74d}',
        '\u{7b1}'), ('\u{7c0}', '\u{7f5}'), ('\u{7fa}', '\u{7fa}'), ('\u{800}', '\u{82d}'),
        ('\u{840}', '\u{85b}'), ('\u{8a0}', '\u{8b2}'), ('\u{8e4}', '\u{963}'), ('\u{966}',
        '\u{96f}'), ('\u{971}', '\u{983}'), ('\u{985}', '\u{98c}'), ('\u{98f}', '\u{990}'),
        ('\u{993}', '\u{9a8}'), ('\u{9aa}', '\u{9b0}'), ('\u{9b2}', '\u{9b2}'), ('\u{9b6}',
        '\u{9b9}'), ('\u{9bc}', '\u{9c4}'), ('\u{9c7}', '\u{9c8}'), ('\u{9cb}', '\u{9ce}'),
        ('\u{9d7}', '\u{9d7}'), ('\u{9dc}', '\u{9dd}'), ('\u{9df}', '\u{9e3}'), ('\u{9e6}',
        '\u{9f1}'), ('\u{a01}', '\u{a03}'), ('\u{a05}', '\u{a0a}'), ('\u{a0f}', '\u{a10}'),
        ('\u{a13}', '\u{a28}'), ('\u{a2a}', '\u{a30}'), ('\u{a32}', '\u{a33}'), ('\u{a35}',
        '\u{a36}'), ('\u{a38}', '\u{a39}'), ('\u{a3c}', '\u{a3c}'), ('\u{a3e}', '\u{a42}'),
        ('\u{a47}', '\u{a48}'), ('\u{a4b}', '\u{a4d}'), ('\u{a51}', '\u{a51}'), ('\u{a59}',
        '\u{a5c}'), ('\u{a5e}', '\u{a5e}'), ('\u{a66}', '\u{a75}'), ('\u{a81}', '\u{a83}'),
        ('\u{a85}', '\u{a8d}'), ('\u{a8f}', '\u{a91}'), ('\u{a93}', '\u{aa8}'), ('\u{aaa}',
        '\u{ab0}'), ('\u{ab2}', '\u{ab3}'), ('\u{ab5}', '\u{ab9}'), ('\u{abc}', '\u{ac5}'),
        ('\u{ac7}', '\u{ac9}'), ('\u{acb}', '\u{acd}'), ('\u{ad0}', '\u{ad0}'), ('\u{ae0}',
        '\u{ae3}'), ('\u{ae6}', '\u{aef}'), ('\u{b01}', '\u{b03}'), ('\u{b05}', '\u{b0c}'),
        ('\u{b0f}', '\u{b10}'), ('\u{b13}', '\u{b28}'), ('\u{b2a}', '\u{b30}'), ('\u{b32}',
        '\u{b33}'), ('\u{b35}', '\u{b39}'), ('\u{b3c}', '\u{b44}'), ('\u{b47}', '\u{b48}'),
        ('\u{b4b}', '\u{b4d}'), ('\u{b56}', '\u{b57}'), ('\u{b5c}', '\u{b5d}'), ('\u{b5f}',
        '\u{b63}'), ('\u{b66}', '\u{b6f}'), ('\u{b71}', '\u{b71}'), ('\u{b82}', '\u{b83}'),
        ('\u{b85}', '\u{b8a}'), ('\u{b8e}', '\u{b90}'), ('\u{b92}', '\u{b95}'), ('\u{b99}',
        '\u{b9a}'), ('\u{b9c}', '\u{b9c}'), ('\u{b9e}', '\u{b9f}'), ('\u{ba3}', '\u{ba4}'),
        ('\u{ba8}', '\u{baa}'), ('\u{bae}', '\u{bb9}'), ('\u{bbe}', '\u{bc2}'), ('\u{bc6}',
        '\u{bc8}'), ('\u{bca}', '\u{bcd}'), ('\u{bd0}', '\u{bd0}'), ('\u{bd7}', '\u{bd7}'),
        ('\u{be6}', '\u{bef}'), ('\u{c00}', '\u{c03}'), ('\u{c05}', '\u{c0c}'), ('\u{c0e}',
        '\u{c10}'), ('\u{c12}', '\u{c28}'), ('\u{c2a}', '\u{c39}'), ('\u{c3d}', '\u{c44}'),
        ('\u{c46}', '\u{c48}'), ('\u{c4a}', '\u{c4d}'), ('\u{c55}', '\u{c56}'), ('\u{c58}',
        '\u{c59}'), ('\u{c60}', '\u{c63}'), ('\u{c66}', '\u{c6f}'), ('\u{c81}', '\u{c83}'),
        ('\u{c85}', '\u{c8c}'), ('\u{c8e}', '\u{c90}'), ('\u{c92}', '\u{ca8}'), ('\u{caa}',
        '\u{cb3}'), ('\u{cb5}', '\u{cb9}'), ('\u{cbc}', '\u{cc4}'), ('\u{cc6}', '\u{cc8}'),
        ('\u{cca}', '\u{ccd}'), ('\u{cd5}', '\u{cd6}'), ('\u{cde}', '\u{cde}'), ('\u{ce0}',
        '\u{ce3}'), ('\u{ce6}', '\u{cef}'), ('\u{cf1}', '\u{cf2}'), ('\u{d01}', '\u{d03}'),
        ('\u{d05}', '\u{d0c}'), ('\u{d0e}', '\u{d10}'), ('\u{d12}', '\u{d3a}'), ('\u{d3d}',
        '\u{d44}'), ('\u{d46}', '\u{d48}'), ('\u{d4a}', '\u{d4e}'), ('\u{d57}', '\u{d57}'),
        ('\u{d60}', '\u{d63}'), ('\u{d66}', '\u{d6f}'), ('\u{d7a}', '\u{d7f}'), ('\u{d82}',
        '\u{d83}'), ('\u{d85}', '\u{d96}'), ('\u{d9a}', '\u{db1}'), ('\u{db3}', '\u{dbb}'),
        ('\u{dbd}', '\u{dbd}'), ('\u{dc0}', '\u{dc6}'), ('\u{dca}', '\u{dca}'), ('\u{dcf}',
        '\u{dd4}'), ('\u{dd6}', '\u{dd6}'), ('\u{dd8}', '\u{ddf}'), ('\u{de6}', '\u{def}'),
        ('\u{df2}', '\u{df3}'), ('\u{e01}', '\u{e3a}'), ('\u{e40}', '\u{e4e}'), ('\u{e50}',
        '\u{e59}'), ('\u{e81}', '\u{e82}'), ('\u{e84}', '\u{e84}'), ('\u{e87}', '\u{e88}'),
        ('\u{e8a}', '\u{e8a}'), ('\u{e8d}', '\u{e8d}'), ('\u{e94}', '\u{e97}'), ('\u{e99}',
        '\u{e9f}'), ('\u{ea1}', '\u{ea3}'), ('\u{ea5}', '\u{ea5}'), ('\u{ea7}', '\u{ea7}'),
        ('\u{eaa}', '\u{eab}'), ('\u{ead}', '\u{eb9}'), ('\u{ebb}', '\u{ebd}'), ('\u{ec0}',
        '\u{ec4}'), ('\u{ec6}', '\u{ec6}'), ('\u{ec8}', '\u{ecd}'), ('\u{ed0}', '\u{ed9}'),
        ('\u{edc}', '\u{edf}'), ('\u{f00}', '\u{f00}'), ('\u{f18}', '\u{f19}'), ('\u{f20}',
        '\u{f29}'), ('\u{f35}', '\u{f35}'), ('\u{f37}', '\u{f37}'), ('\u{f39}', '\u{f39}'),
        ('\u{f3e}', '\u{f47}'), ('\u{f49}', '\u{f6c}'), ('\u{f71}', '\u{f84}'), ('\u{f86}',
        '\u{f97}'), ('\u{f99}', '\u{fbc}'), ('\u{fc6}', '\u{fc6}'), ('\u{1000}', '\u{1049}'),
        ('\u{1050}', '\u{109d}'), ('\u{10a0}', '\u{10c5}'), ('\u{10c7}', '\u{10c7}'), ('\u{10cd}',
        '\u{10cd}'), ('\u{10d0}', '\u{10fa}'), ('\u{10fc}', '\u{1248}'), ('\u{124a}', '\u{124d}'),
        ('\u{1250}', '\u{1256}'), ('\u{1258}', '\u{1258}'), ('\u{125a}', '\u{125d}'), ('\u{1260}',
        '\u{1288}'), ('\u{128a}', '\u{128d}'), ('\u{1290}', '\u{12b0}'), ('\u{12b2}', '\u{12b5}'),
        ('\u{12b8}', '\u{12be}'), ('\u{12c0}', '\u{12c0}'), ('\u{12c2}', '\u{12c5}'), ('\u{12c8}',
        '\u{12d6}'), ('\u{12d8}', '\u{1310}'), ('\u{1312}', '\u{1315}'), ('\u{1318}', '\u{135a}'),
        ('\u{135d}', '\u{135f}'), ('\u{1380}', '\u{138f}'), ('\u{13a0}', '\u{13f4}'), ('\u{1401}',
        '\u{166c}'), ('\u{166f}', '\u{167f}'), ('\u{1681}', '\u{169a}'), ('\u{16a0}', '\u{16ea}'),
        ('\u{16ee}', '\u{16f8}'), ('\u{1700}', '\u{170c}'), ('\u{170e}', '\u{1714}'), ('\u{1720}',
        '\u{1734}'), ('\u{1740}', '\u{1753}'), ('\u{1760}', '\u{176c}'), ('\u{176e}', '\u{1770}'),
        ('\u{1772}', '\u{1773}'), ('\u{1780}', '\u{17d3}'), ('\u{17d7}', '\u{17d7}'), ('\u{17dc}',
        '\u{17dd}'), ('\u{17e0}', '\u{17e9}'), ('\u{180b}', '\u{180d}'), ('\u{1810}', '\u{1819}'),
        ('\u{1820}', '\u{1877}'), ('\u{1880}', '\u{18aa}'), ('\u{18b0}', '\u{18f5}'), ('\u{1900}',
        '\u{191e}'), ('\u{1920}', '\u{192b}'), ('\u{1930}', '\u{193b}'), ('\u{1946}', '\u{196d}'),
        ('\u{1970}', '\u{1974}'), ('\u{1980}', '\u{19ab}'), ('\u{19b0}', '\u{19c9}'), ('\u{19d0}',
        '\u{19d9}'), ('\u{1a00}', '\u{1a1b}'), ('\u{1a20}', '\u{1a5e}'), ('\u{1a60}', '\u{1a7c}'),
        ('\u{1a7f}', '\u{1a89}'), ('\u{1a90}', '\u{1a99}'), ('\u{1aa7}', '\u{1aa7}'), ('\u{1ab0}',
        '\u{1abe}'), ('\u{1b00}', '\u{1b4b}'), ('\u{1b50}', '\u{1b59}'), ('\u{1b6b}', '\u{1b73}'),
        ('\u{1b80}', '\u{1bf3}'), ('\u{1c00}', '\u{1c37}'), ('\u{1c40}', '\u{1c49}'), ('\u{1c4d}',
        '\u{1c7d}'), ('\u{1cd0}', '\u{1cd2}'), ('\u{1cd4}', '\u{1cf6}'), ('\u{1cf8}', '\u{1cf9}'),
        ('\u{1d00}', '\u{1df5}'), ('\u{1dfc}', '\u{1f15}'), ('\u{1f18}', '\u{1f1d}'), ('\u{1f20}',
        '\u{1f45}'), ('\u{1f48}', '\u{1f4d}'), ('\u{1f50}', '\u{1f57}'), ('\u{1f59}', '\u{1f59}'),
        ('\u{1f5b}', '\u{1f5b}'), ('\u{1f5d}', '\u{1f5d}'), ('\u{1f5f}', '\u{1f7d}'), ('\u{1f80}',
        '\u{1fb4}'), ('\u{1fb6}', '\u{1fbc}'), ('\u{1fbe}', '\u{1fbe}'), ('\u{1fc2}', '\u{1fc4}'),
        ('\u{1fc6}', '\u{1fcc}'), ('\u{1fd0}', '\u{1fd3}'), ('\u{1fd6}', '\u{1fdb}'), ('\u{1fe0}',
        '\u{1fec}'), ('\u{1ff2}', '\u{1ff4}'), ('\u{1ff6}', '\u{1ffc}'), ('\u{200c}', '\u{200d}'),
        ('\u{203f}', '\u{2040}'), ('\u{2054}', '\u{2054}'), ('\u{2071}', '\u{2071}'), ('\u{207f}',
        '\u{207f}'), ('\u{2090}', '\u{209c}'), ('\u{20d0}', '\u{20f0}'), ('\u{2102}', '\u{2102}'),
        ('\u{2107}', '\u{2107}'), ('\u{210a}', '\u{2113}'), ('\u{2115}', '\u{2115}'), ('\u{2119}',
        '\u{211d}'), ('\u{2124}', '\u{2124}'), ('\u{2126}', '\u{2126}'), ('\u{2128}', '\u{2128}'),
        ('\u{212a}', '\u{212d}'), ('\u{212f}', '\u{2139}'), ('\u{213c}', '\u{213f}'), ('\u{2145}',
        '\u{2149}'), ('\u{214e}', '\u{214e}'), ('\u{2160}', '\u{2188}'), ('\u{24b6}', '\u{24e9}'),
        ('\u{2c00}', '\u{2c2e}'), ('\u{2c30}', '\u{2c5e}'), ('\u{2c60}', '\u{2ce4}'), ('\u{2ceb}',
        '\u{2cf3}'), ('\u{2d00}', '\u{2d25}'), ('\u{2d27}', '\u{2d27}'), ('\u{2d2d}', '\u{2d2d}'),
        ('\u{2d30}', '\u{2d67}'), ('\u{2d6f}', '\u{2d6f}'), ('\u{2d7f}', '\u{2d96}'), ('\u{2da0}',
        '\u{2da6}'), ('\u{2da8}', '\u{2dae}'), ('\u{2db0}', '\u{2db6}'), ('\u{2db8}', '\u{2dbe}'),
        ('\u{2dc0}', '\u{2dc6}'), ('\u{2dc8}', '\u{2dce}'), ('\u{2dd0}', '\u{2dd6}'), ('\u{2dd8}',
        '\u{2dde}'), ('\u{2de0}', '\u{2dff}'), ('\u{2e2f}', '\u{2e2f}'), ('\u{3005}', '\u{3007}'),
        ('\u{3021}', '\u{302f}'), ('\u{3031}', '\u{3035}'), ('\u{3038}', '\u{303c}'), ('\u{3041}',
        '\u{3096}'), ('\u{3099}', '\u{309a}'), ('\u{309d}', '\u{309f}'), ('\u{30a1}', '\u{30fa}'),
        ('\u{30fc}', '\u{30ff}'), ('\u{3105}', '\u{312d}'), ('\u{3131}', '\u{318e}'), ('\u{31a0}',
        '\u{31ba}'), ('\u{31f0}', '\u{31ff}'), ('\u{3400}', '\u{4db5}'), ('\u{4e00}', '\u{9fcc}'),
        ('\u{a000}', '\u{a48c}'), ('\u{a4d0}', '\u{a4fd}'), ('\u{a500}', '\u{a60c}'), ('\u{a610}',
        '\u{a62b}'), ('\u{a640}', '\u{a672}'), ('\u{a674}', '\u{a67d}'), ('\u{a67f}', '\u{a69d}'),
        ('\u{a69f}', '\u{a6f1}'), ('\u{a717}', '\u{a71f}'), ('\u{a722}', '\u{a788}'), ('\u{a78b}',
        '\u{a78e}'), ('\u{a790}', '\u{a7ad}'), ('\u{a7b0}', '\u{a7b1}'), ('\u{a7f7}', '\u{a827}'),
        ('\u{a840}', '\u{a873}'), ('\u{a880}', '\u{a8c4}'), ('\u{a8d0}', '\u{a8d9}'), ('\u{a8e0}',
        '\u{a8f7}'), ('\u{a8fb}', '\u{a8fb}'), ('\u{a900}', '\u{a92d}'), ('\u{a930}', '\u{a953}'),
        ('\u{a960}', '\u{a97c}'), ('\u{a980}', '\u{a9c0}'), ('\u{a9cf}', '\u{a9d9}'), ('\u{a9e0}',
        '\u{a9fe}'), ('\u{aa00}', '\u{aa36}'), ('\u{aa40}', '\u{aa4d}'), ('\u{aa50}', '\u{aa59}'),
        ('\u{aa60}', '\u{aa76}'), ('\u{aa7a}', '\u{aac2}'), ('\u{aadb}', '\u{aadd}'), ('\u{aae0}',
        '\u{aaef}'), ('\u{aaf2}', '\u{aaf6}'), ('\u{ab01}', '\u{ab06}'), ('\u{ab09}', '\u{ab0e}'),
        ('\u{ab11}', '\u{ab16}'), ('\u{ab20}', '\u{ab26}'), ('\u{ab28}', '\u{ab2e}'), ('\u{ab30}',
        '\u{ab5a}'), ('\u{ab5c}', '\u{ab5f}'), ('\u{ab64}', '\u{ab65}'), ('\u{abc0}', '\u{abea}'),
        ('\u{abec}', '\u{abed}'), ('\u{abf0}', '\u{abf9}'), ('\u{ac00}', '\u{d7a3}'), ('\u{d7b0}',
        '\u{d7c6}'), ('\u{d7cb}', '\u{d7fb}'), ('\u{f900}', '\u{fa6d}'), ('\u{fa70}', '\u{fad9}'),
        ('\u{fb00}', '\u{fb06}'), ('\u{fb13}', '\u{fb17}'), ('\u{fb1d}', '\u{fb28}'), ('\u{fb2a}',
        '\u{fb36}'), ('\u{fb38}', '\u{fb3c}'), ('\u{fb3e}', '\u{fb3e}'), ('\u{fb40}', '\u{fb41}'),
        ('\u{fb43}', '\u{fb44}'), ('\u{fb46}', '\u{fbb1}'), ('\u{fbd3}', '\u{fd3d}'), ('\u{fd50}',
        '\u{fd8f}'), ('\u{fd92}', '\u{fdc7}'), ('\u{fdf0}', '\u{fdfb}'), ('\u{fe00}', '\u{fe0f}'),
        ('\u{fe20}', '\u{fe2d}'), ('\u{fe33}', '\u{fe34}'), ('\u{fe4d}', '\u{fe4f}'), ('\u{fe70}',
        '\u{fe74}'), ('\u{fe76}', '\u{fefc}'), ('\u{ff10}', '\u{ff19}'), ('\u{ff21}', '\u{ff3a}'),
        ('\u{ff3f}', '\u{ff3f}'), ('\u{ff41}', '\u{ff5a}'), ('\u{ff66}', '\u{ffbe}'), ('\u{ffc2}',
        '\u{ffc7}'), ('\u{ffca}', '\u{ffcf}'), ('\u{ffd2}', '\u{ffd7}'), ('\u{ffda}', '\u{ffdc}'),
        ('\u{10000}', '\u{1000b}'), ('\u{1000d}', '\u{10026}'), ('\u{10028}', '\u{1003a}'),
        ('\u{1003c}', '\u{1003d}'), ('\u{1003f}', '\u{1004d}'), ('\u{10050}', '\u{1005d}'),
        ('\u{10080}', '\u{100fa}'), ('\u{10140}', '\u{10174}'), ('\u{101fd}', '\u{101fd}'),
        ('\u{10280}', '\u{1029c}'), ('\u{102a0}', '\u{102d0}'), ('\u{102e0}', '\u{102e0}'),
        ('\u{10300}', '\u{1031f}'), ('\u{10330}', '\u{1034a}'), ('\u{10350}', '\u{1037a}'),
        ('\u{10380}', '\u{1039d}'), ('\u{103a0}', '\u{103c3}'), ('\u{103c8}', '\u{103cf}'),
        ('\u{103d1}', '\u{103d5}'), ('\u{10400}', '\u{1049d}'), ('\u{104a0}', '\u{104a9}'),
        ('\u{10500}', '\u{10527}'), ('\u{10530}', '\u{10563}'), ('\u{10600}', '\u{10736}'),
        ('\u{10740}', '\u{10755}'), ('\u{10760}', '\u{10767}'), ('\u{10800}', '\u{10805}'),
        ('\u{10808}', '\u{10808}'), ('\u{1080a}', '\u{10835}'), ('\u{10837}', '\u{10838}'),
        ('\u{1083c}', '\u{1083c}'), ('\u{1083f}', '\u{10855}'), ('\u{10860}', '\u{10876}'),
        ('\u{10880}', '\u{1089e}'), ('\u{10900}', '\u{10915}'), ('\u{10920}', '\u{10939}'),
        ('\u{10980}', '\u{109b7}'), ('\u{109be}', '\u{109bf}'), ('\u{10a00}', '\u{10a03}'),
        ('\u{10a05}', '\u{10a06}'), ('\u{10a0c}', '\u{10a13}'), ('\u{10a15}', '\u{10a17}'),
        ('\u{10a19}', '\u{10a33}'), ('\u{10a38}', '\u{10a3a}'), ('\u{10a3f}', '\u{10a3f}'),
        ('\u{10a60}', '\u{10a7c}'), ('\u{10a80}', '\u{10a9c}'), ('\u{10ac0}', '\u{10ac7}'),
        ('\u{10ac9}', '\u{10ae6}'), ('\u{10b00}', '\u{10b35}'), ('\u{10b40}', '\u{10b55}'),
        ('\u{10b60}', '\u{10b72}'), ('\u{10b80}', '\u{10b91}'), ('\u{10c00}', '\u{10c48}'),
        ('\u{11000}', '\u{11046}'), ('\u{11066}', '\u{1106f}'), ('\u{1107f}', '\u{110ba}'),
        ('\u{110d0}', '\u{110e8}'), ('\u{110f0}', '\u{110f9}'), ('\u{11100}', '\u{11134}'),
        ('\u{11136}', '\u{1113f}'), ('\u{11150}', '\u{11173}'), ('\u{11176}', '\u{11176}'),
        ('\u{11180}', '\u{111c4}'), ('\u{111d0}', '\u{111da}'), ('\u{11200}', '\u{11211}'),
        ('\u{11213}', '\u{11237}'), ('\u{112b0}', '\u{112ea}'), ('\u{112f0}', '\u{112f9}'),
        ('\u{11301}', '\u{11303}'), ('\u{11305}', '\u{1130c}'), ('\u{1130f}', '\u{11310}'),
        ('\u{11313}', '\u{11328}'), ('\u{1132a}', '\u{11330}'), ('\u{11332}', '\u{11333}'),
        ('\u{11335}', '\u{11339}'), ('\u{1133c}', '\u{11344}'), ('\u{11347}', '\u{11348}'),
        ('\u{1134b}', '\u{1134d}'), ('\u{11357}', '\u{11357}'), ('\u{1135d}', '\u{11363}'),
        ('\u{11366}', '\u{1136c}'), ('\u{11370}', '\u{11374}'), ('\u{11480}', '\u{114c5}'),
        ('\u{114c7}', '\u{114c7}'), ('\u{114d0}', '\u{114d9}'), ('\u{11580}', '\u{115b5}'),
        ('\u{115b8}', '\u{115c0}'), ('\u{11600}', '\u{11640}'), ('\u{11644}', '\u{11644}'),
        ('\u{11650}', '\u{11659}'), ('\u{11680}', '\u{116b7}'), ('\u{116c0}', '\u{116c9}'),
        ('\u{118a0}', '\u{118e9}'), ('\u{118ff}', '\u{118ff}'), ('\u{11ac0}', '\u{11af8}'),
        ('\u{12000}', '\u{12398}'), ('\u{12400}', '\u{1246e}'), ('\u{13000}', '\u{1342e}'),
        ('\u{16800}', '\u{16a38}'), ('\u{16a40}', '\u{16a5e}'), ('\u{16a60}', '\u{16a69}'),
        ('\u{16ad0}', '\u{16aed}'), ('\u{16af0}', '\u{16af4}'), ('\u{16b00}', '\u{16b36}'),
        ('\u{16b40}', '\u{16b43}'), ('\u{16b50}', '\u{16b59}'), ('\u{16b63}', '\u{16b77}'),
        ('\u{16b7d}', '\u{16b8f}'), ('\u{16f00}', '\u{16f44}'), ('\u{16f50}', '\u{16f7e}'),
        ('\u{16f8f}', '\u{16f9f}'), ('\u{1b000}', '\u{1b001}'), ('\u{1bc00}', '\u{1bc6a}'),
        ('\u{1bc70}', '\u{1bc7c}'), ('\u{1bc80}', '\u{1bc88}'), ('\u{1bc90}', '\u{1bc99}'),
        ('\u{1bc9d}', '\u{1bc9e}'), ('\u{1d165}', '\u{1d169}'), ('\u{1d16d}', '\u{1d172}'),
        ('\u{1d17b}', '\u{1d182}'), ('\u{1d185}', '\u{1d18b}'), ('\u{1d1aa}', '\u{1d1ad}'),
        ('\u{1d242}', '\u{1d244}'), ('\u{1d400}', '\u{1d454}'), ('\u{1d456}', '\u{1d49c}'),
        ('\u{1d49e}', '\u{1d49f}'), ('\u{1d4a2}', '\u{1d4a2}'), ('\u{1d4a5}', '\u{1d4a6}'),
        ('\u{1d4a9}', '\u{1d4ac}'), ('\u{1d4ae}', '\u{1d4b9}'), ('\u{1d4bb}', '\u{1d4bb}'),
        ('\u{1d4bd}', '\u{1d4c3}'), ('\u{1d4c5}', '\u{1d505}'), ('\u{1d507}', '\u{1d50a}'),
        ('\u{1d50d}', '\u{1d514}'), ('\u{1d516}', '\u{1d51c}'), ('\u{1d51e}', '\u{1d539}'),
        ('\u{1d53b}', '\u{1d53e}'), ('\u{1d540}', '\u{1d544}'), ('\u{1d546}', '\u{1d546}'),
        ('\u{1d54a}', '\u{1d550}'), ('\u{1d552}', '\u{1d6a5}'), ('\u{1d6a8}', '\u{1d6c0}'),
        ('\u{1d6c2}', '\u{1d6da}'), ('\u{1d6dc}', '\u{1d6fa}'), ('\u{1d6fc}', '\u{1d714}'),
        ('\u{1d716}', '\u{1d734}'), ('\u{1d736}', '\u{1d74e}'), ('\u{1d750}', '\u{1d76e}'),
        ('\u{1d770}', '\u{1d788}'), ('\u{1d78a}', '\u{1d7a8}'), ('\u{1d7aa}', '\u{1d7c2}'),
        ('\u{1d7c4}', '\u{1d7cb}'), ('\u{1d7ce}', '\u{1d7ff}'), ('\u{1e800}', '\u{1e8c4}'),
        ('\u{1e8d0}', '\u{1e8d6}'), ('\u{1ee00}', '\u{1ee03}'), ('\u{1ee05}', '\u{1ee1f}'),
        ('\u{1ee21}', '\u{1ee22}'), ('\u{1ee24}', '\u{1ee24}'), ('\u{1ee27}', '\u{1ee27}'),
        ('\u{1ee29}', '\u{1ee32}'), ('\u{1ee34}', '\u{1ee37}'), ('\u{1ee39}', '\u{1ee39}'),
        ('\u{1ee3b}', '\u{1ee3b}'), ('\u{1ee42}', '\u{1ee42}'), ('\u{1ee47}', '\u{1ee47}'),
        ('\u{1ee49}', '\u{1ee49}'), ('\u{1ee4b}', '\u{1ee4b}'), ('\u{1ee4d}', '\u{1ee4f}'),
        ('\u{1ee51}', '\u{1ee52}'), ('\u{1ee54}', '\u{1ee54}'), ('\u{1ee57}', '\u{1ee57}'),
        ('\u{1ee59}', '\u{1ee59}'), ('\u{1ee5b}', '\u{1ee5b}'), ('\u{1ee5d}', '\u{1ee5d}'),
        ('\u{1ee5f}', '\u{1ee5f}'), ('\u{1ee61}', '\u{1ee62}'), ('\u{1ee64}', '\u{1ee64}'),
        ('\u{1ee67}', '\u{1ee6a}'), ('\u{1ee6c}', '\u{1ee72}'), ('\u{1ee74}', '\u{1ee77}'),
        ('\u{1ee79}', '\u{1ee7c}'), ('\u{1ee7e}', '\u{1ee7e}'), ('\u{1ee80}', '\u{1ee89}'),
        ('\u{1ee8b}', '\u{1ee9b}'), ('\u{1eea1}', '\u{1eea3}'), ('\u{1eea5}', '\u{1eea9}'),
        ('\u{1eeab}', '\u{1eebb}'), ('\u{1f130}', '\u{1f149}'), ('\u{1f150}', '\u{1f169}'),
        ('\u{1f170}', '\u{1f189}'), ('\u{20000}', '\u{2a6d6}'), ('\u{2a700}', '\u{2b734}'),
        ('\u{2b740}', '\u{2b81d}'), ('\u{2f800}', '\u{2fa1d}'), ('\u{e0100}', '\u{e01ef}')
    ];

}

pub mod normalization {
    // Canonical decompositions
    pub static canonical_table: &'static [(char, &'static [char])] = &[
        ('\u{c0}', &['\u{41}', '\u{300}']), ('\u{c1}', &['\u{41}', '\u{301}']), ('\u{c2}',
        &['\u{41}', '\u{302}']), ('\u{c3}', &['\u{41}', '\u{303}']), ('\u{c4}', &['\u{41}',
        '\u{308}']), ('\u{c5}', &['\u{41}', '\u{30a}']), ('\u{c7}', &['\u{43}', '\u{327}']),
        ('\u{c8}', &['\u{45}', '\u{300}']), ('\u{c9}', &['\u{45}', '\u{301}']), ('\u{ca}',
        &['\u{45}', '\u{302}']), ('\u{cb}', &['\u{45}', '\u{308}']), ('\u{cc}', &['\u{49}',
        '\u{300}']), ('\u{cd}', &['\u{49}', '\u{301}']), ('\u{ce}', &['\u{49}', '\u{302}']),
        ('\u{cf}', &['\u{49}', '\u{308}']), ('\u{d1}', &['\u{4e}', '\u{303}']), ('\u{d2}',
        &['\u{4f}', '\u{300}']), ('\u{d3}', &['\u{4f}', '\u{301}']), ('\u{d4}', &['\u{4f}',
        '\u{302}']), ('\u{d5}', &['\u{4f}', '\u{303}']), ('\u{d6}', &['\u{4f}', '\u{308}']),
        ('\u{d9}', &['\u{55}', '\u{300}']), ('\u{da}', &['\u{55}', '\u{301}']), ('\u{db}',
        &['\u{55}', '\u{302}']), ('\u{dc}', &['\u{55}', '\u{308}']), ('\u{dd}', &['\u{59}',
        '\u{301}']), ('\u{e0}', &['\u{61}', '\u{300}']), ('\u{e1}', &['\u{61}', '\u{301}']),
        ('\u{e2}', &['\u{61}', '\u{302}']), ('\u{e3}', &['\u{61}', '\u{303}']), ('\u{e4}',
        &['\u{61}', '\u{308}']), ('\u{e5}', &['\u{61}', '\u{30a}']), ('\u{e7}', &['\u{63}',
        '\u{327}']), ('\u{e8}', &['\u{65}', '\u{300}']), ('\u{e9}', &['\u{65}', '\u{301}']),
        ('\u{ea}', &['\u{65}', '\u{302}']), ('\u{eb}', &['\u{65}', '\u{308}']), ('\u{ec}',
        &['\u{69}', '\u{300}']), ('\u{ed}', &['\u{69}', '\u{301}']), ('\u{ee}', &['\u{69}',
        '\u{302}']), ('\u{ef}', &['\u{69}', '\u{308}']), ('\u{f1}', &['\u{6e}', '\u{303}']),
        ('\u{f2}', &['\u{6f}', '\u{300}']), ('\u{f3}', &['\u{6f}', '\u{301}']), ('\u{f4}',
        &['\u{6f}', '\u{302}']), ('\u{f5}', &['\u{6f}', '\u{303}']), ('\u{f6}', &['\u{6f}',
        '\u{308}']), ('\u{f9}', &['\u{75}', '\u{300}']), ('\u{fa}', &['\u{75}', '\u{301}']),
        ('\u{fb}', &['\u{75}', '\u{302}']), ('\u{fc}', &['\u{75}', '\u{308}']), ('\u{fd}',
        &['\u{79}', '\u{301}']), ('\u{ff}', &['\u{79}', '\u{308}']), ('\u{100}', &['\u{41}',
        '\u{304}']), ('\u{101}', &['\u{61}', '\u{304}']), ('\u{102}', &['\u{41}', '\u{306}']),
        ('\u{103}', &['\u{61}', '\u{306}']), ('\u{104}', &['\u{41}', '\u{328}']), ('\u{105}',
        &['\u{61}', '\u{328}']), ('\u{106}', &['\u{43}', '\u{301}']), ('\u{107}', &['\u{63}',
        '\u{301}']), ('\u{108}', &['\u{43}', '\u{302}']), ('\u{109}', &['\u{63}', '\u{302}']),
        ('\u{10a}', &['\u{43}', '\u{307}']), ('\u{10b}', &['\u{63}', '\u{307}']), ('\u{10c}',
        &['\u{43}', '\u{30c}']), ('\u{10d}', &['\u{63}', '\u{30c}']), ('\u{10e}', &['\u{44}',
        '\u{30c}']), ('\u{10f}', &['\u{64}', '\u{30c}']), ('\u{112}', &['\u{45}', '\u{304}']),
        ('\u{113}', &['\u{65}', '\u{304}']), ('\u{114}', &['\u{45}', '\u{306}']), ('\u{115}',
        &['\u{65}', '\u{306}']), ('\u{116}', &['\u{45}', '\u{307}']), ('\u{117}', &['\u{65}',
        '\u{307}']), ('\u{118}', &['\u{45}', '\u{328}']), ('\u{119}', &['\u{65}', '\u{328}']),
        ('\u{11a}', &['\u{45}', '\u{30c}']), ('\u{11b}', &['\u{65}', '\u{30c}']), ('\u{11c}',
        &['\u{47}', '\u{302}']), ('\u{11d}', &['\u{67}', '\u{302}']), ('\u{11e}', &['\u{47}',
        '\u{306}']), ('\u{11f}', &['\u{67}', '\u{306}']), ('\u{120}', &['\u{47}', '\u{307}']),
        ('\u{121}', &['\u{67}', '\u{307}']), ('\u{122}', &['\u{47}', '\u{327}']), ('\u{123}',
        &['\u{67}', '\u{327}']), ('\u{124}', &['\u{48}', '\u{302}']), ('\u{125}', &['\u{68}',
        '\u{302}']), ('\u{128}', &['\u{49}', '\u{303}']), ('\u{129}', &['\u{69}', '\u{303}']),
        ('\u{12a}', &['\u{49}', '\u{304}']), ('\u{12b}', &['\u{69}', '\u{304}']), ('\u{12c}',
        &['\u{49}', '\u{306}']), ('\u{12d}', &['\u{69}', '\u{306}']), ('\u{12e}', &['\u{49}',
        '\u{328}']), ('\u{12f}', &['\u{69}', '\u{328}']), ('\u{130}', &['\u{49}', '\u{307}']),
        ('\u{134}', &['\u{4a}', '\u{302}']), ('\u{135}', &['\u{6a}', '\u{302}']), ('\u{136}',
        &['\u{4b}', '\u{327}']), ('\u{137}', &['\u{6b}', '\u{327}']), ('\u{139}', &['\u{4c}',
        '\u{301}']), ('\u{13a}', &['\u{6c}', '\u{301}']), ('\u{13b}', &['\u{4c}', '\u{327}']),
        ('\u{13c}', &['\u{6c}', '\u{327}']), ('\u{13d}', &['\u{4c}', '\u{30c}']), ('\u{13e}',
        &['\u{6c}', '\u{30c}']), ('\u{143}', &['\u{4e}', '\u{301}']), ('\u{144}', &['\u{6e}',
        '\u{301}']), ('\u{145}', &['\u{4e}', '\u{327}']), ('\u{146}', &['\u{6e}', '\u{327}']),
        ('\u{147}', &['\u{4e}', '\u{30c}']), ('\u{148}', &['\u{6e}', '\u{30c}']), ('\u{14c}',
        &['\u{4f}', '\u{304}']), ('\u{14d}', &['\u{6f}', '\u{304}']), ('\u{14e}', &['\u{4f}',
        '\u{306}']), ('\u{14f}', &['\u{6f}', '\u{306}']), ('\u{150}', &['\u{4f}', '\u{30b}']),
        ('\u{151}', &['\u{6f}', '\u{30b}']), ('\u{154}', &['\u{52}', '\u{301}']), ('\u{155}',
        &['\u{72}', '\u{301}']), ('\u{156}', &['\u{52}', '\u{327}']), ('\u{157}', &['\u{72}',
        '\u{327}']), ('\u{158}', &['\u{52}', '\u{30c}']), ('\u{159}', &['\u{72}', '\u{30c}']),
        ('\u{15a}', &['\u{53}', '\u{301}']), ('\u{15b}', &['\u{73}', '\u{301}']), ('\u{15c}',
        &['\u{53}', '\u{302}']), ('\u{15d}', &['\u{73}', '\u{302}']), ('\u{15e}', &['\u{53}',
        '\u{327}']), ('\u{15f}', &['\u{73}', '\u{327}']), ('\u{160}', &['\u{53}', '\u{30c}']),
        ('\u{161}', &['\u{73}', '\u{30c}']), ('\u{162}', &['\u{54}', '\u{327}']), ('\u{163}',
        &['\u{74}', '\u{327}']), ('\u{164}', &['\u{54}', '\u{30c}']), ('\u{165}', &['\u{74}',
        '\u{30c}']), ('\u{168}', &['\u{55}', '\u{303}']), ('\u{169}', &['\u{75}', '\u{303}']),
        ('\u{16a}', &['\u{55}', '\u{304}']), ('\u{16b}', &['\u{75}', '\u{304}']), ('\u{16c}',
        &['\u{55}', '\u{306}']), ('\u{16d}', &['\u{75}', '\u{306}']), ('\u{16e}', &['\u{55}',
        '\u{30a}']), ('\u{16f}', &['\u{75}', '\u{30a}']), ('\u{170}', &['\u{55}', '\u{30b}']),
        ('\u{171}', &['\u{75}', '\u{30b}']), ('\u{172}', &['\u{55}', '\u{328}']), ('\u{173}',
        &['\u{75}', '\u{328}']), ('\u{174}', &['\u{57}', '\u{302}']), ('\u{175}', &['\u{77}',
        '\u{302}']), ('\u{176}', &['\u{59}', '\u{302}']), ('\u{177}', &['\u{79}', '\u{302}']),
        ('\u{178}', &['\u{59}', '\u{308}']), ('\u{179}', &['\u{5a}', '\u{301}']), ('\u{17a}',
        &['\u{7a}', '\u{301}']), ('\u{17b}', &['\u{5a}', '\u{307}']), ('\u{17c}', &['\u{7a}',
        '\u{307}']), ('\u{17d}', &['\u{5a}', '\u{30c}']), ('\u{17e}', &['\u{7a}', '\u{30c}']),
        ('\u{1a0}', &['\u{4f}', '\u{31b}']), ('\u{1a1}', &['\u{6f}', '\u{31b}']), ('\u{1af}',
        &['\u{55}', '\u{31b}']), ('\u{1b0}', &['\u{75}', '\u{31b}']), ('\u{1cd}', &['\u{41}',
        '\u{30c}']), ('\u{1ce}', &['\u{61}', '\u{30c}']), ('\u{1cf}', &['\u{49}', '\u{30c}']),
        ('\u{1d0}', &['\u{69}', '\u{30c}']), ('\u{1d1}', &['\u{4f}', '\u{30c}']), ('\u{1d2}',
        &['\u{6f}', '\u{30c}']), ('\u{1d3}', &['\u{55}', '\u{30c}']), ('\u{1d4}', &['\u{75}',
        '\u{30c}']), ('\u{1d5}', &['\u{dc}', '\u{304}']), ('\u{1d6}', &['\u{fc}', '\u{304}']),
        ('\u{1d7}', &['\u{dc}', '\u{301}']), ('\u{1d8}', &['\u{fc}', '\u{301}']), ('\u{1d9}',
        &['\u{dc}', '\u{30c}']), ('\u{1da}', &['\u{fc}', '\u{30c}']), ('\u{1db}', &['\u{dc}',
        '\u{300}']), ('\u{1dc}', &['\u{fc}', '\u{300}']), ('\u{1de}', &['\u{c4}', '\u{304}']),
        ('\u{1df}', &['\u{e4}', '\u{304}']), ('\u{1e0}', &['\u{226}', '\u{304}']), ('\u{1e1}',
        &['\u{227}', '\u{304}']), ('\u{1e2}', &['\u{c6}', '\u{304}']), ('\u{1e3}', &['\u{e6}',
        '\u{304}']), ('\u{1e6}', &['\u{47}', '\u{30c}']), ('\u{1e7}', &['\u{67}', '\u{30c}']),
        ('\u{1e8}', &['\u{4b}', '\u{30c}']), ('\u{1e9}', &['\u{6b}', '\u{30c}']), ('\u{1ea}',
        &['\u{4f}', '\u{328}']), ('\u{1eb}', &['\u{6f}', '\u{328}']), ('\u{1ec}', &['\u{1ea}',
        '\u{304}']), ('\u{1ed}', &['\u{1eb}', '\u{304}']), ('\u{1ee}', &['\u{1b7}', '\u{30c}']),
        ('\u{1ef}', &['\u{292}', '\u{30c}']), ('\u{1f0}', &['\u{6a}', '\u{30c}']), ('\u{1f4}',
        &['\u{47}', '\u{301}']), ('\u{1f5}', &['\u{67}', '\u{301}']), ('\u{1f8}', &['\u{4e}',
        '\u{300}']), ('\u{1f9}', &['\u{6e}', '\u{300}']), ('\u{1fa}', &['\u{c5}', '\u{301}']),
        ('\u{1fb}', &['\u{e5}', '\u{301}']), ('\u{1fc}', &['\u{c6}', '\u{301}']), ('\u{1fd}',
        &['\u{e6}', '\u{301}']), ('\u{1fe}', &['\u{d8}', '\u{301}']), ('\u{1ff}', &['\u{f8}',
        '\u{301}']), ('\u{200}', &['\u{41}', '\u{30f}']), ('\u{201}', &['\u{61}', '\u{30f}']),
        ('\u{202}', &['\u{41}', '\u{311}']), ('\u{203}', &['\u{61}', '\u{311}']), ('\u{204}',
        &['\u{45}', '\u{30f}']), ('\u{205}', &['\u{65}', '\u{30f}']), ('\u{206}', &['\u{45}',
        '\u{311}']), ('\u{207}', &['\u{65}', '\u{311}']), ('\u{208}', &['\u{49}', '\u{30f}']),
        ('\u{209}', &['\u{69}', '\u{30f}']), ('\u{20a}', &['\u{49}', '\u{311}']), ('\u{20b}',
        &['\u{69}', '\u{311}']), ('\u{20c}', &['\u{4f}', '\u{30f}']), ('\u{20d}', &['\u{6f}',
        '\u{30f}']), ('\u{20e}', &['\u{4f}', '\u{311}']), ('\u{20f}', &['\u{6f}', '\u{311}']),
        ('\u{210}', &['\u{52}', '\u{30f}']), ('\u{211}', &['\u{72}', '\u{30f}']), ('\u{212}',
        &['\u{52}', '\u{311}']), ('\u{213}', &['\u{72}', '\u{311}']), ('\u{214}', &['\u{55}',
        '\u{30f}']), ('\u{215}', &['\u{75}', '\u{30f}']), ('\u{216}', &['\u{55}', '\u{311}']),
        ('\u{217}', &['\u{75}', '\u{311}']), ('\u{218}', &['\u{53}', '\u{326}']), ('\u{219}',
        &['\u{73}', '\u{326}']), ('\u{21a}', &['\u{54}', '\u{326}']), ('\u{21b}', &['\u{74}',
        '\u{326}']), ('\u{21e}', &['\u{48}', '\u{30c}']), ('\u{21f}', &['\u{68}', '\u{30c}']),
        ('\u{226}', &['\u{41}', '\u{307}']), ('\u{227}', &['\u{61}', '\u{307}']), ('\u{228}',
        &['\u{45}', '\u{327}']), ('\u{229}', &['\u{65}', '\u{327}']), ('\u{22a}', &['\u{d6}',
        '\u{304}']), ('\u{22b}', &['\u{f6}', '\u{304}']), ('\u{22c}', &['\u{d5}', '\u{304}']),
        ('\u{22d}', &['\u{f5}', '\u{304}']), ('\u{22e}', &['\u{4f}', '\u{307}']), ('\u{22f}',
        &['\u{6f}', '\u{307}']), ('\u{230}', &['\u{22e}', '\u{304}']), ('\u{231}', &['\u{22f}',
        '\u{304}']), ('\u{232}', &['\u{59}', '\u{304}']), ('\u{233}', &['\u{79}', '\u{304}']),
        ('\u{340}', &['\u{300}']), ('\u{341}', &['\u{301}']), ('\u{343}', &['\u{313}']), ('\u{344}',
        &['\u{308}', '\u{301}']), ('\u{374}', &['\u{2b9}']), ('\u{37e}', &['\u{3b}']), ('\u{385}',
        &['\u{a8}', '\u{301}']), ('\u{386}', &['\u{391}', '\u{301}']), ('\u{387}', &['\u{b7}']),
        ('\u{388}', &['\u{395}', '\u{301}']), ('\u{389}', &['\u{397}', '\u{301}']), ('\u{38a}',
        &['\u{399}', '\u{301}']), ('\u{38c}', &['\u{39f}', '\u{301}']), ('\u{38e}', &['\u{3a5}',
        '\u{301}']), ('\u{38f}', &['\u{3a9}', '\u{301}']), ('\u{390}', &['\u{3ca}', '\u{301}']),
        ('\u{3aa}', &['\u{399}', '\u{308}']), ('\u{3ab}', &['\u{3a5}', '\u{308}']), ('\u{3ac}',
        &['\u{3b1}', '\u{301}']), ('\u{3ad}', &['\u{3b5}', '\u{301}']), ('\u{3ae}', &['\u{3b7}',
        '\u{301}']), ('\u{3af}', &['\u{3b9}', '\u{301}']), ('\u{3b0}', &['\u{3cb}', '\u{301}']),
        ('\u{3ca}', &['\u{3b9}', '\u{308}']), ('\u{3cb}', &['\u{3c5}', '\u{308}']), ('\u{3cc}',
        &['\u{3bf}', '\u{301}']), ('\u{3cd}', &['\u{3c5}', '\u{301}']), ('\u{3ce}', &['\u{3c9}',
        '\u{301}']), ('\u{3d3}', &['\u{3d2}', '\u{301}']), ('\u{3d4}', &['\u{3d2}', '\u{308}']),
        ('\u{400}', &['\u{415}', '\u{300}']), ('\u{401}', &['\u{415}', '\u{308}']), ('\u{403}',
        &['\u{413}', '\u{301}']), ('\u{407}', &['\u{406}', '\u{308}']), ('\u{40c}', &['\u{41a}',
        '\u{301}']), ('\u{40d}', &['\u{418}', '\u{300}']), ('\u{40e}', &['\u{423}', '\u{306}']),
        ('\u{419}', &['\u{418}', '\u{306}']), ('\u{439}', &['\u{438}', '\u{306}']), ('\u{450}',
        &['\u{435}', '\u{300}']), ('\u{451}', &['\u{435}', '\u{308}']), ('\u{453}', &['\u{433}',
        '\u{301}']), ('\u{457}', &['\u{456}', '\u{308}']), ('\u{45c}', &['\u{43a}', '\u{301}']),
        ('\u{45d}', &['\u{438}', '\u{300}']), ('\u{45e}', &['\u{443}', '\u{306}']), ('\u{476}',
        &['\u{474}', '\u{30f}']), ('\u{477}', &['\u{475}', '\u{30f}']), ('\u{4c1}', &['\u{416}',
        '\u{306}']), ('\u{4c2}', &['\u{436}', '\u{306}']), ('\u{4d0}', &['\u{410}', '\u{306}']),
        ('\u{4d1}', &['\u{430}', '\u{306}']), ('\u{4d2}', &['\u{410}', '\u{308}']), ('\u{4d3}',
        &['\u{430}', '\u{308}']), ('\u{4d6}', &['\u{415}', '\u{306}']), ('\u{4d7}', &['\u{435}',
        '\u{306}']), ('\u{4da}', &['\u{4d8}', '\u{308}']), ('\u{4db}', &['\u{4d9}', '\u{308}']),
        ('\u{4dc}', &['\u{416}', '\u{308}']), ('\u{4dd}', &['\u{436}', '\u{308}']), ('\u{4de}',
        &['\u{417}', '\u{308}']), ('\u{4df}', &['\u{437}', '\u{308}']), ('\u{4e2}', &['\u{418}',
        '\u{304}']), ('\u{4e3}', &['\u{438}', '\u{304}']), ('\u{4e4}', &['\u{418}', '\u{308}']),
        ('\u{4e5}', &['\u{438}', '\u{308}']), ('\u{4e6}', &['\u{41e}', '\u{308}']), ('\u{4e7}',
        &['\u{43e}', '\u{308}']), ('\u{4ea}', &['\u{4e8}', '\u{308}']), ('\u{4eb}', &['\u{4e9}',
        '\u{308}']), ('\u{4ec}', &['\u{42d}', '\u{308}']), ('\u{4ed}', &['\u{44d}', '\u{308}']),
        ('\u{4ee}', &['\u{423}', '\u{304}']), ('\u{4ef}', &['\u{443}', '\u{304}']), ('\u{4f0}',
        &['\u{423}', '\u{308}']), ('\u{4f1}', &['\u{443}', '\u{308}']), ('\u{4f2}', &['\u{423}',
        '\u{30b}']), ('\u{4f3}', &['\u{443}', '\u{30b}']), ('\u{4f4}', &['\u{427}', '\u{308}']),
        ('\u{4f5}', &['\u{447}', '\u{308}']), ('\u{4f8}', &['\u{42b}', '\u{308}']), ('\u{4f9}',
        &['\u{44b}', '\u{308}']), ('\u{622}', &['\u{627}', '\u{653}']), ('\u{623}', &['\u{627}',
        '\u{654}']), ('\u{624}', &['\u{648}', '\u{654}']), ('\u{625}', &['\u{627}', '\u{655}']),
        ('\u{626}', &['\u{64a}', '\u{654}']), ('\u{6c0}', &['\u{6d5}', '\u{654}']), ('\u{6c2}',
        &['\u{6c1}', '\u{654}']), ('\u{6d3}', &['\u{6d2}', '\u{654}']), ('\u{929}', &['\u{928}',
        '\u{93c}']), ('\u{931}', &['\u{930}', '\u{93c}']), ('\u{934}', &['\u{933}', '\u{93c}']),
        ('\u{958}', &['\u{915}', '\u{93c}']), ('\u{959}', &['\u{916}', '\u{93c}']), ('\u{95a}',
        &['\u{917}', '\u{93c}']), ('\u{95b}', &['\u{91c}', '\u{93c}']), ('\u{95c}', &['\u{921}',
        '\u{93c}']), ('\u{95d}', &['\u{922}', '\u{93c}']), ('\u{95e}', &['\u{92b}', '\u{93c}']),
        ('\u{95f}', &['\u{92f}', '\u{93c}']), ('\u{9cb}', &['\u{9c7}', '\u{9be}']), ('\u{9cc}',
        &['\u{9c7}', '\u{9d7}']), ('\u{9dc}', &['\u{9a1}', '\u{9bc}']), ('\u{9dd}', &['\u{9a2}',
        '\u{9bc}']), ('\u{9df}', &['\u{9af}', '\u{9bc}']), ('\u{a33}', &['\u{a32}', '\u{a3c}']),
        ('\u{a36}', &['\u{a38}', '\u{a3c}']), ('\u{a59}', &['\u{a16}', '\u{a3c}']), ('\u{a5a}',
        &['\u{a17}', '\u{a3c}']), ('\u{a5b}', &['\u{a1c}', '\u{a3c}']), ('\u{a5e}', &['\u{a2b}',
        '\u{a3c}']), ('\u{b48}', &['\u{b47}', '\u{b56}']), ('\u{b4b}', &['\u{b47}', '\u{b3e}']),
        ('\u{b4c}', &['\u{b47}', '\u{b57}']), ('\u{b5c}', &['\u{b21}', '\u{b3c}']), ('\u{b5d}',
        &['\u{b22}', '\u{b3c}']), ('\u{b94}', &['\u{b92}', '\u{bd7}']), ('\u{bca}', &['\u{bc6}',
        '\u{bbe}']), ('\u{bcb}', &['\u{bc7}', '\u{bbe}']), ('\u{bcc}', &['\u{bc6}', '\u{bd7}']),
        ('\u{c48}', &['\u{c46}', '\u{c56}']), ('\u{cc0}', &['\u{cbf}', '\u{cd5}']), ('\u{cc7}',
        &['\u{cc6}', '\u{cd5}']), ('\u{cc8}', &['\u{cc6}', '\u{cd6}']), ('\u{cca}', &['\u{cc6}',
        '\u{cc2}']), ('\u{ccb}', &['\u{cca}', '\u{cd5}']), ('\u{d4a}', &['\u{d46}', '\u{d3e}']),
        ('\u{d4b}', &['\u{d47}', '\u{d3e}']), ('\u{d4c}', &['\u{d46}', '\u{d57}']), ('\u{dda}',
        &['\u{dd9}', '\u{dca}']), ('\u{ddc}', &['\u{dd9}', '\u{dcf}']), ('\u{ddd}', &['\u{ddc}',
        '\u{dca}']), ('\u{dde}', &['\u{dd9}', '\u{ddf}']), ('\u{f43}', &['\u{f42}', '\u{fb7}']),
        ('\u{f4d}', &['\u{f4c}', '\u{fb7}']), ('\u{f52}', &['\u{f51}', '\u{fb7}']), ('\u{f57}',
        &['\u{f56}', '\u{fb7}']), ('\u{f5c}', &['\u{f5b}', '\u{fb7}']), ('\u{f69}', &['\u{f40}',
        '\u{fb5}']), ('\u{f73}', &['\u{f71}', '\u{f72}']), ('\u{f75}', &['\u{f71}', '\u{f74}']),
        ('\u{f76}', &['\u{fb2}', '\u{f80}']), ('\u{f78}', &['\u{fb3}', '\u{f80}']), ('\u{f81}',
        &['\u{f71}', '\u{f80}']), ('\u{f93}', &['\u{f92}', '\u{fb7}']), ('\u{f9d}', &['\u{f9c}',
        '\u{fb7}']), ('\u{fa2}', &['\u{fa1}', '\u{fb7}']), ('\u{fa7}', &['\u{fa6}', '\u{fb7}']),
        ('\u{fac}', &['\u{fab}', '\u{fb7}']), ('\u{fb9}', &['\u{f90}', '\u{fb5}']), ('\u{1026}',
        &['\u{1025}', '\u{102e}']), ('\u{1b06}', &['\u{1b05}', '\u{1b35}']), ('\u{1b08}',
        &['\u{1b07}', '\u{1b35}']), ('\u{1b0a}', &['\u{1b09}', '\u{1b35}']), ('\u{1b0c}',
        &['\u{1b0b}', '\u{1b35}']), ('\u{1b0e}', &['\u{1b0d}', '\u{1b35}']), ('\u{1b12}',
        &['\u{1b11}', '\u{1b35}']), ('\u{1b3b}', &['\u{1b3a}', '\u{1b35}']), ('\u{1b3d}',
        &['\u{1b3c}', '\u{1b35}']), ('\u{1b40}', &['\u{1b3e}', '\u{1b35}']), ('\u{1b41}',
        &['\u{1b3f}', '\u{1b35}']), ('\u{1b43}', &['\u{1b42}', '\u{1b35}']), ('\u{1e00}',
        &['\u{41}', '\u{325}']), ('\u{1e01}', &['\u{61}', '\u{325}']), ('\u{1e02}', &['\u{42}',
        '\u{307}']), ('\u{1e03}', &['\u{62}', '\u{307}']), ('\u{1e04}', &['\u{42}', '\u{323}']),
        ('\u{1e05}', &['\u{62}', '\u{323}']), ('\u{1e06}', &['\u{42}', '\u{331}']), ('\u{1e07}',
        &['\u{62}', '\u{331}']), ('\u{1e08}', &['\u{c7}', '\u{301}']), ('\u{1e09}', &['\u{e7}',
        '\u{301}']), ('\u{1e0a}', &['\u{44}', '\u{307}']), ('\u{1e0b}', &['\u{64}', '\u{307}']),
        ('\u{1e0c}', &['\u{44}', '\u{323}']), ('\u{1e0d}', &['\u{64}', '\u{323}']), ('\u{1e0e}',
        &['\u{44}', '\u{331}']), ('\u{1e0f}', &['\u{64}', '\u{331}']), ('\u{1e10}', &['\u{44}',
        '\u{327}']), ('\u{1e11}', &['\u{64}', '\u{327}']), ('\u{1e12}', &['\u{44}', '\u{32d}']),
        ('\u{1e13}', &['\u{64}', '\u{32d}']), ('\u{1e14}', &['\u{112}', '\u{300}']), ('\u{1e15}',
        &['\u{113}', '\u{300}']), ('\u{1e16}', &['\u{112}', '\u{301}']), ('\u{1e17}', &['\u{113}',
        '\u{301}']), ('\u{1e18}', &['\u{45}', '\u{32d}']), ('\u{1e19}', &['\u{65}', '\u{32d}']),
        ('\u{1e1a}', &['\u{45}', '\u{330}']), ('\u{1e1b}', &['\u{65}', '\u{330}']), ('\u{1e1c}',
        &['\u{228}', '\u{306}']), ('\u{1e1d}', &['\u{229}', '\u{306}']), ('\u{1e1e}', &['\u{46}',
        '\u{307}']), ('\u{1e1f}', &['\u{66}', '\u{307}']), ('\u{1e20}', &['\u{47}', '\u{304}']),
        ('\u{1e21}', &['\u{67}', '\u{304}']), ('\u{1e22}', &['\u{48}', '\u{307}']), ('\u{1e23}',
        &['\u{68}', '\u{307}']), ('\u{1e24}', &['\u{48}', '\u{323}']), ('\u{1e25}', &['\u{68}',
        '\u{323}']), ('\u{1e26}', &['\u{48}', '\u{308}']), ('\u{1e27}', &['\u{68}', '\u{308}']),
        ('\u{1e28}', &['\u{48}', '\u{327}']), ('\u{1e29}', &['\u{68}', '\u{327}']), ('\u{1e2a}',
        &['\u{48}', '\u{32e}']), ('\u{1e2b}', &['\u{68}', '\u{32e}']), ('\u{1e2c}', &['\u{49}',
        '\u{330}']), ('\u{1e2d}', &['\u{69}', '\u{330}']), ('\u{1e2e}', &['\u{cf}', '\u{301}']),
        ('\u{1e2f}', &['\u{ef}', '\u{301}']), ('\u{1e30}', &['\u{4b}', '\u{301}']), ('\u{1e31}',
        &['\u{6b}', '\u{301}']), ('\u{1e32}', &['\u{4b}', '\u{323}']), ('\u{1e33}', &['\u{6b}',
        '\u{323}']), ('\u{1e34}', &['\u{4b}', '\u{331}']), ('\u{1e35}', &['\u{6b}', '\u{331}']),
        ('\u{1e36}', &['\u{4c}', '\u{323}']), ('\u{1e37}', &['\u{6c}', '\u{323}']), ('\u{1e38}',
        &['\u{1e36}', '\u{304}']), ('\u{1e39}', &['\u{1e37}', '\u{304}']), ('\u{1e3a}', &['\u{4c}',
        '\u{331}']), ('\u{1e3b}', &['\u{6c}', '\u{331}']), ('\u{1e3c}', &['\u{4c}', '\u{32d}']),
        ('\u{1e3d}', &['\u{6c}', '\u{32d}']), ('\u{1e3e}', &['\u{4d}', '\u{301}']), ('\u{1e3f}',
        &['\u{6d}', '\u{301}']), ('\u{1e40}', &['\u{4d}', '\u{307}']), ('\u{1e41}', &['\u{6d}',
        '\u{307}']), ('\u{1e42}', &['\u{4d}', '\u{323}']), ('\u{1e43}', &['\u{6d}', '\u{323}']),
        ('\u{1e44}', &['\u{4e}', '\u{307}']), ('\u{1e45}', &['\u{6e}', '\u{307}']), ('\u{1e46}',
        &['\u{4e}', '\u{323}']), ('\u{1e47}', &['\u{6e}', '\u{323}']), ('\u{1e48}', &['\u{4e}',
        '\u{331}']), ('\u{1e49}', &['\u{6e}', '\u{331}']), ('\u{1e4a}', &['\u{4e}', '\u{32d}']),
        ('\u{1e4b}', &['\u{6e}', '\u{32d}']), ('\u{1e4c}', &['\u{d5}', '\u{301}']), ('\u{1e4d}',
        &['\u{f5}', '\u{301}']), ('\u{1e4e}', &['\u{d5}', '\u{308}']), ('\u{1e4f}', &['\u{f5}',
        '\u{308}']), ('\u{1e50}', &['\u{14c}', '\u{300}']), ('\u{1e51}', &['\u{14d}', '\u{300}']),
        ('\u{1e52}', &['\u{14c}', '\u{301}']), ('\u{1e53}', &['\u{14d}', '\u{301}']), ('\u{1e54}',
        &['\u{50}', '\u{301}']), ('\u{1e55}', &['\u{70}', '\u{301}']), ('\u{1e56}', &['\u{50}',
        '\u{307}']), ('\u{1e57}', &['\u{70}', '\u{307}']), ('\u{1e58}', &['\u{52}', '\u{307}']),
        ('\u{1e59}', &['\u{72}', '\u{307}']), ('\u{1e5a}', &['\u{52}', '\u{323}']), ('\u{1e5b}',
        &['\u{72}', '\u{323}']), ('\u{1e5c}', &['\u{1e5a}', '\u{304}']), ('\u{1e5d}', &['\u{1e5b}',
        '\u{304}']), ('\u{1e5e}', &['\u{52}', '\u{331}']), ('\u{1e5f}', &['\u{72}', '\u{331}']),
        ('\u{1e60}', &['\u{53}', '\u{307}']), ('\u{1e61}', &['\u{73}', '\u{307}']), ('\u{1e62}',
        &['\u{53}', '\u{323}']), ('\u{1e63}', &['\u{73}', '\u{323}']), ('\u{1e64}', &['\u{15a}',
        '\u{307}']), ('\u{1e65}', &['\u{15b}', '\u{307}']), ('\u{1e66}', &['\u{160}', '\u{307}']),
        ('\u{1e67}', &['\u{161}', '\u{307}']), ('\u{1e68}', &['\u{1e62}', '\u{307}']), ('\u{1e69}',
        &['\u{1e63}', '\u{307}']), ('\u{1e6a}', &['\u{54}', '\u{307}']), ('\u{1e6b}', &['\u{74}',
        '\u{307}']), ('\u{1e6c}', &['\u{54}', '\u{323}']), ('\u{1e6d}', &['\u{74}', '\u{323}']),
        ('\u{1e6e}', &['\u{54}', '\u{331}']), ('\u{1e6f}', &['\u{74}', '\u{331}']), ('\u{1e70}',
        &['\u{54}', '\u{32d}']), ('\u{1e71}', &['\u{74}', '\u{32d}']), ('\u{1e72}', &['\u{55}',
        '\u{324}']), ('\u{1e73}', &['\u{75}', '\u{324}']), ('\u{1e74}', &['\u{55}', '\u{330}']),
        ('\u{1e75}', &['\u{75}', '\u{330}']), ('\u{1e76}', &['\u{55}', '\u{32d}']), ('\u{1e77}',
        &['\u{75}', '\u{32d}']), ('\u{1e78}', &['\u{168}', '\u{301}']), ('\u{1e79}', &['\u{169}',
        '\u{301}']), ('\u{1e7a}', &['\u{16a}', '\u{308}']), ('\u{1e7b}', &['\u{16b}', '\u{308}']),
        ('\u{1e7c}', &['\u{56}', '\u{303}']), ('\u{1e7d}', &['\u{76}', '\u{303}']), ('\u{1e7e}',
        &['\u{56}', '\u{323}']), ('\u{1e7f}', &['\u{76}', '\u{323}']), ('\u{1e80}', &['\u{57}',
        '\u{300}']), ('\u{1e81}', &['\u{77}', '\u{300}']), ('\u{1e82}', &['\u{57}', '\u{301}']),
        ('\u{1e83}', &['\u{77}', '\u{301}']), ('\u{1e84}', &['\u{57}', '\u{308}']), ('\u{1e85}',
        &['\u{77}', '\u{308}']), ('\u{1e86}', &['\u{57}', '\u{307}']), ('\u{1e87}', &['\u{77}',
        '\u{307}']), ('\u{1e88}', &['\u{57}', '\u{323}']), ('\u{1e89}', &['\u{77}', '\u{323}']),
        ('\u{1e8a}', &['\u{58}', '\u{307}']), ('\u{1e8b}', &['\u{78}', '\u{307}']), ('\u{1e8c}',
        &['\u{58}', '\u{308}']), ('\u{1e8d}', &['\u{78}', '\u{308}']), ('\u{1e8e}', &['\u{59}',
        '\u{307}']), ('\u{1e8f}', &['\u{79}', '\u{307}']), ('\u{1e90}', &['\u{5a}', '\u{302}']),
        ('\u{1e91}', &['\u{7a}', '\u{302}']), ('\u{1e92}', &['\u{5a}', '\u{323}']), ('\u{1e93}',
        &['\u{7a}', '\u{323}']), ('\u{1e94}', &['\u{5a}', '\u{331}']), ('\u{1e95}', &['\u{7a}',
        '\u{331}']), ('\u{1e96}', &['\u{68}', '\u{331}']), ('\u{1e97}', &['\u{74}', '\u{308}']),
        ('\u{1e98}', &['\u{77}', '\u{30a}']), ('\u{1e99}', &['\u{79}', '\u{30a}']), ('\u{1e9b}',
        &['\u{17f}', '\u{307}']), ('\u{1ea0}', &['\u{41}', '\u{323}']), ('\u{1ea1}', &['\u{61}',
        '\u{323}']), ('\u{1ea2}', &['\u{41}', '\u{309}']), ('\u{1ea3}', &['\u{61}', '\u{309}']),
        ('\u{1ea4}', &['\u{c2}', '\u{301}']), ('\u{1ea5}', &['\u{e2}', '\u{301}']), ('\u{1ea6}',
        &['\u{c2}', '\u{300}']), ('\u{1ea7}', &['\u{e2}', '\u{300}']), ('\u{1ea8}', &['\u{c2}',
        '\u{309}']), ('\u{1ea9}', &['\u{e2}', '\u{309}']), ('\u{1eaa}', &['\u{c2}', '\u{303}']),
        ('\u{1eab}', &['\u{e2}', '\u{303}']), ('\u{1eac}', &['\u{1ea0}', '\u{302}']), ('\u{1ead}',
        &['\u{1ea1}', '\u{302}']), ('\u{1eae}', &['\u{102}', '\u{301}']), ('\u{1eaf}', &['\u{103}',
        '\u{301}']), ('\u{1eb0}', &['\u{102}', '\u{300}']), ('\u{1eb1}', &['\u{103}', '\u{300}']),
        ('\u{1eb2}', &['\u{102}', '\u{309}']), ('\u{1eb3}', &['\u{103}', '\u{309}']), ('\u{1eb4}',
        &['\u{102}', '\u{303}']), ('\u{1eb5}', &['\u{103}', '\u{303}']), ('\u{1eb6}', &['\u{1ea0}',
        '\u{306}']), ('\u{1eb7}', &['\u{1ea1}', '\u{306}']), ('\u{1eb8}', &['\u{45}', '\u{323}']),
        ('\u{1eb9}', &['\u{65}', '\u{323}']), ('\u{1eba}', &['\u{45}', '\u{309}']), ('\u{1ebb}',
        &['\u{65}', '\u{309}']), ('\u{1ebc}', &['\u{45}', '\u{303}']), ('\u{1ebd}', &['\u{65}',
        '\u{303}']), ('\u{1ebe}', &['\u{ca}', '\u{301}']), ('\u{1ebf}', &['\u{ea}', '\u{301}']),
        ('\u{1ec0}', &['\u{ca}', '\u{300}']), ('\u{1ec1}', &['\u{ea}', '\u{300}']), ('\u{1ec2}',
        &['\u{ca}', '\u{309}']), ('\u{1ec3}', &['\u{ea}', '\u{309}']), ('\u{1ec4}', &['\u{ca}',
        '\u{303}']), ('\u{1ec5}', &['\u{ea}', '\u{303}']), ('\u{1ec6}', &['\u{1eb8}', '\u{302}']),
        ('\u{1ec7}', &['\u{1eb9}', '\u{302}']), ('\u{1ec8}', &['\u{49}', '\u{309}']), ('\u{1ec9}',
        &['\u{69}', '\u{309}']), ('\u{1eca}', &['\u{49}', '\u{323}']), ('\u{1ecb}', &['\u{69}',
        '\u{323}']), ('\u{1ecc}', &['\u{4f}', '\u{323}']), ('\u{1ecd}', &['\u{6f}', '\u{323}']),
        ('\u{1ece}', &['\u{4f}', '\u{309}']), ('\u{1ecf}', &['\u{6f}', '\u{309}']), ('\u{1ed0}',
        &['\u{d4}', '\u{301}']), ('\u{1ed1}', &['\u{f4}', '\u{301}']), ('\u{1ed2}', &['\u{d4}',
        '\u{300}']), ('\u{1ed3}', &['\u{f4}', '\u{300}']), ('\u{1ed4}', &['\u{d4}', '\u{309}']),
        ('\u{1ed5}', &['\u{f4}', '\u{309}']), ('\u{1ed6}', &['\u{d4}', '\u{303}']), ('\u{1ed7}',
        &['\u{f4}', '\u{303}']), ('\u{1ed8}', &['\u{1ecc}', '\u{302}']), ('\u{1ed9}', &['\u{1ecd}',
        '\u{302}']), ('\u{1eda}', &['\u{1a0}', '\u{301}']), ('\u{1edb}', &['\u{1a1}', '\u{301}']),
        ('\u{1edc}', &['\u{1a0}', '\u{300}']), ('\u{1edd}', &['\u{1a1}', '\u{300}']), ('\u{1ede}',
        &['\u{1a0}', '\u{309}']), ('\u{1edf}', &['\u{1a1}', '\u{309}']), ('\u{1ee0}', &['\u{1a0}',
        '\u{303}']), ('\u{1ee1}', &['\u{1a1}', '\u{303}']), ('\u{1ee2}', &['\u{1a0}', '\u{323}']),
        ('\u{1ee3}', &['\u{1a1}', '\u{323}']), ('\u{1ee4}', &['\u{55}', '\u{323}']), ('\u{1ee5}',
        &['\u{75}', '\u{323}']), ('\u{1ee6}', &['\u{55}', '\u{309}']), ('\u{1ee7}', &['\u{75}',
        '\u{309}']), ('\u{1ee8}', &['\u{1af}', '\u{301}']), ('\u{1ee9}', &['\u{1b0}', '\u{301}']),
        ('\u{1eea}', &['\u{1af}', '\u{300}']), ('\u{1eeb}', &['\u{1b0}', '\u{300}']), ('\u{1eec}',
        &['\u{1af}', '\u{309}']), ('\u{1eed}', &['\u{1b0}', '\u{309}']), ('\u{1eee}', &['\u{1af}',
        '\u{303}']), ('\u{1eef}', &['\u{1b0}', '\u{303}']), ('\u{1ef0}', &['\u{1af}', '\u{323}']),
        ('\u{1ef1}', &['\u{1b0}', '\u{323}']), ('\u{1ef2}', &['\u{59}', '\u{300}']), ('\u{1ef3}',
        &['\u{79}', '\u{300}']), ('\u{1ef4}', &['\u{59}', '\u{323}']), ('\u{1ef5}', &['\u{79}',
        '\u{323}']), ('\u{1ef6}', &['\u{59}', '\u{309}']), ('\u{1ef7}', &['\u{79}', '\u{309}']),
        ('\u{1ef8}', &['\u{59}', '\u{303}']), ('\u{1ef9}', &['\u{79}', '\u{303}']), ('\u{1f00}',
        &['\u{3b1}', '\u{313}']), ('\u{1f01}', &['\u{3b1}', '\u{314}']), ('\u{1f02}', &['\u{1f00}',
        '\u{300}']), ('\u{1f03}', &['\u{1f01}', '\u{300}']), ('\u{1f04}', &['\u{1f00}', '\u{301}']),
        ('\u{1f05}', &['\u{1f01}', '\u{301}']), ('\u{1f06}', &['\u{1f00}', '\u{342}']), ('\u{1f07}',
        &['\u{1f01}', '\u{342}']), ('\u{1f08}', &['\u{391}', '\u{313}']), ('\u{1f09}', &['\u{391}',
        '\u{314}']), ('\u{1f0a}', &['\u{1f08}', '\u{300}']), ('\u{1f0b}', &['\u{1f09}', '\u{300}']),
        ('\u{1f0c}', &['\u{1f08}', '\u{301}']), ('\u{1f0d}', &['\u{1f09}', '\u{301}']), ('\u{1f0e}',
        &['\u{1f08}', '\u{342}']), ('\u{1f0f}', &['\u{1f09}', '\u{342}']), ('\u{1f10}', &['\u{3b5}',
        '\u{313}']), ('\u{1f11}', &['\u{3b5}', '\u{314}']), ('\u{1f12}', &['\u{1f10}', '\u{300}']),
        ('\u{1f13}', &['\u{1f11}', '\u{300}']), ('\u{1f14}', &['\u{1f10}', '\u{301}']), ('\u{1f15}',
        &['\u{1f11}', '\u{301}']), ('\u{1f18}', &['\u{395}', '\u{313}']), ('\u{1f19}', &['\u{395}',
        '\u{314}']), ('\u{1f1a}', &['\u{1f18}', '\u{300}']), ('\u{1f1b}', &['\u{1f19}', '\u{300}']),
        ('\u{1f1c}', &['\u{1f18}', '\u{301}']), ('\u{1f1d}', &['\u{1f19}', '\u{301}']), ('\u{1f20}',
        &['\u{3b7}', '\u{313}']), ('\u{1f21}', &['\u{3b7}', '\u{314}']), ('\u{1f22}', &['\u{1f20}',
        '\u{300}']), ('\u{1f23}', &['\u{1f21}', '\u{300}']), ('\u{1f24}', &['\u{1f20}', '\u{301}']),
        ('\u{1f25}', &['\u{1f21}', '\u{301}']), ('\u{1f26}', &['\u{1f20}', '\u{342}']), ('\u{1f27}',
        &['\u{1f21}', '\u{342}']), ('\u{1f28}', &['\u{397}', '\u{313}']), ('\u{1f29}', &['\u{397}',
        '\u{314}']), ('\u{1f2a}', &['\u{1f28}', '\u{300}']), ('\u{1f2b}', &['\u{1f29}', '\u{300}']),
        ('\u{1f2c}', &['\u{1f28}', '\u{301}']), ('\u{1f2d}', &['\u{1f29}', '\u{301}']), ('\u{1f2e}',
        &['\u{1f28}', '\u{342}']), ('\u{1f2f}', &['\u{1f29}', '\u{342}']), ('\u{1f30}', &['\u{3b9}',
        '\u{313}']), ('\u{1f31}', &['\u{3b9}', '\u{314}']), ('\u{1f32}', &['\u{1f30}', '\u{300}']),
        ('\u{1f33}', &['\u{1f31}', '\u{300}']), ('\u{1f34}', &['\u{1f30}', '\u{301}']), ('\u{1f35}',
        &['\u{1f31}', '\u{301}']), ('\u{1f36}', &['\u{1f30}', '\u{342}']), ('\u{1f37}',
        &['\u{1f31}', '\u{342}']), ('\u{1f38}', &['\u{399}', '\u{313}']), ('\u{1f39}', &['\u{399}',
        '\u{314}']), ('\u{1f3a}', &['\u{1f38}', '\u{300}']), ('\u{1f3b}', &['\u{1f39}', '\u{300}']),
        ('\u{1f3c}', &['\u{1f38}', '\u{301}']), ('\u{1f3d}', &['\u{1f39}', '\u{301}']), ('\u{1f3e}',
        &['\u{1f38}', '\u{342}']), ('\u{1f3f}', &['\u{1f39}', '\u{342}']), ('\u{1f40}', &['\u{3bf}',
        '\u{313}']), ('\u{1f41}', &['\u{3bf}', '\u{314}']), ('\u{1f42}', &['\u{1f40}', '\u{300}']),
        ('\u{1f43}', &['\u{1f41}', '\u{300}']), ('\u{1f44}', &['\u{1f40}', '\u{301}']), ('\u{1f45}',
        &['\u{1f41}', '\u{301}']), ('\u{1f48}', &['\u{39f}', '\u{313}']), ('\u{1f49}', &['\u{39f}',
        '\u{314}']), ('\u{1f4a}', &['\u{1f48}', '\u{300}']), ('\u{1f4b}', &['\u{1f49}', '\u{300}']),
        ('\u{1f4c}', &['\u{1f48}', '\u{301}']), ('\u{1f4d}', &['\u{1f49}', '\u{301}']), ('\u{1f50}',
        &['\u{3c5}', '\u{313}']), ('\u{1f51}', &['\u{3c5}', '\u{314}']), ('\u{1f52}', &['\u{1f50}',
        '\u{300}']), ('\u{1f53}', &['\u{1f51}', '\u{300}']), ('\u{1f54}', &['\u{1f50}', '\u{301}']),
        ('\u{1f55}', &['\u{1f51}', '\u{301}']), ('\u{1f56}', &['\u{1f50}', '\u{342}']), ('\u{1f57}',
        &['\u{1f51}', '\u{342}']), ('\u{1f59}', &['\u{3a5}', '\u{314}']), ('\u{1f5b}', &['\u{1f59}',
        '\u{300}']), ('\u{1f5d}', &['\u{1f59}', '\u{301}']), ('\u{1f5f}', &['\u{1f59}', '\u{342}']),
        ('\u{1f60}', &['\u{3c9}', '\u{313}']), ('\u{1f61}', &['\u{3c9}', '\u{314}']), ('\u{1f62}',
        &['\u{1f60}', '\u{300}']), ('\u{1f63}', &['\u{1f61}', '\u{300}']), ('\u{1f64}',
        &['\u{1f60}', '\u{301}']), ('\u{1f65}', &['\u{1f61}', '\u{301}']), ('\u{1f66}',
        &['\u{1f60}', '\u{342}']), ('\u{1f67}', &['\u{1f61}', '\u{342}']), ('\u{1f68}', &['\u{3a9}',
        '\u{313}']), ('\u{1f69}', &['\u{3a9}', '\u{314}']), ('\u{1f6a}', &['\u{1f68}', '\u{300}']),
        ('\u{1f6b}', &['\u{1f69}', '\u{300}']), ('\u{1f6c}', &['\u{1f68}', '\u{301}']), ('\u{1f6d}',
        &['\u{1f69}', '\u{301}']), ('\u{1f6e}', &['\u{1f68}', '\u{342}']), ('\u{1f6f}',
        &['\u{1f69}', '\u{342}']), ('\u{1f70}', &['\u{3b1}', '\u{300}']), ('\u{1f71}',
        &['\u{3ac}']), ('\u{1f72}', &['\u{3b5}', '\u{300}']), ('\u{1f73}', &['\u{3ad}']),
        ('\u{1f74}', &['\u{3b7}', '\u{300}']), ('\u{1f75}', &['\u{3ae}']), ('\u{1f76}', &['\u{3b9}',
        '\u{300}']), ('\u{1f77}', &['\u{3af}']), ('\u{1f78}', &['\u{3bf}', '\u{300}']), ('\u{1f79}',
        &['\u{3cc}']), ('\u{1f7a}', &['\u{3c5}', '\u{300}']), ('\u{1f7b}', &['\u{3cd}']),
        ('\u{1f7c}', &['\u{3c9}', '\u{300}']), ('\u{1f7d}', &['\u{3ce}']), ('\u{1f80}',
        &['\u{1f00}', '\u{345}']), ('\u{1f81}', &['\u{1f01}', '\u{345}']), ('\u{1f82}',
        &['\u{1f02}', '\u{345}']), ('\u{1f83}', &['\u{1f03}', '\u{345}']), ('\u{1f84}',
        &['\u{1f04}', '\u{345}']), ('\u{1f85}', &['\u{1f05}', '\u{345}']), ('\u{1f86}',
        &['\u{1f06}', '\u{345}']), ('\u{1f87}', &['\u{1f07}', '\u{345}']), ('\u{1f88}',
        &['\u{1f08}', '\u{345}']), ('\u{1f89}', &['\u{1f09}', '\u{345}']), ('\u{1f8a}',
        &['\u{1f0a}', '\u{345}']), ('\u{1f8b}', &['\u{1f0b}', '\u{345}']), ('\u{1f8c}',
        &['\u{1f0c}', '\u{345}']), ('\u{1f8d}', &['\u{1f0d}', '\u{345}']), ('\u{1f8e}',
        &['\u{1f0e}', '\u{345}']), ('\u{1f8f}', &['\u{1f0f}', '\u{345}']), ('\u{1f90}',
        &['\u{1f20}', '\u{345}']), ('\u{1f91}', &['\u{1f21}', '\u{345}']), ('\u{1f92}',
        &['\u{1f22}', '\u{345}']), ('\u{1f93}', &['\u{1f23}', '\u{345}']), ('\u{1f94}',
        &['\u{1f24}', '\u{345}']), ('\u{1f95}', &['\u{1f25}', '\u{345}']), ('\u{1f96}',
        &['\u{1f26}', '\u{345}']), ('\u{1f97}', &['\u{1f27}', '\u{345}']), ('\u{1f98}',
        &['\u{1f28}', '\u{345}']), ('\u{1f99}', &['\u{1f29}', '\u{345}']), ('\u{1f9a}',
        &['\u{1f2a}', '\u{345}']), ('\u{1f9b}', &['\u{1f2b}', '\u{345}']), ('\u{1f9c}',
        &['\u{1f2c}', '\u{345}']), ('\u{1f9d}', &['\u{1f2d}', '\u{345}']), ('\u{1f9e}',
        &['\u{1f2e}', '\u{345}']), ('\u{1f9f}', &['\u{1f2f}', '\u{345}']), ('\u{1fa0}',
        &['\u{1f60}', '\u{345}']), ('\u{1fa1}', &['\u{1f61}', '\u{345}']), ('\u{1fa2}',
        &['\u{1f62}', '\u{345}']), ('\u{1fa3}', &['\u{1f63}', '\u{345}']), ('\u{1fa4}',
        &['\u{1f64}', '\u{345}']), ('\u{1fa5}', &['\u{1f65}', '\u{345}']), ('\u{1fa6}',
        &['\u{1f66}', '\u{345}']), ('\u{1fa7}', &['\u{1f67}', '\u{345}']), ('\u{1fa8}',
        &['\u{1f68}', '\u{345}']), ('\u{1fa9}', &['\u{1f69}', '\u{345}']), ('\u{1faa}',
        &['\u{1f6a}', '\u{345}']), ('\u{1fab}', &['\u{1f6b}', '\u{345}']), ('\u{1fac}',
        &['\u{1f6c}', '\u{345}']), ('\u{1fad}', &['\u{1f6d}', '\u{345}']), ('\u{1fae}',
        &['\u{1f6e}', '\u{345}']), ('\u{1faf}', &['\u{1f6f}', '\u{345}']), ('\u{1fb0}', &['\u{3b1}',
        '\u{306}']), ('\u{1fb1}', &['\u{3b1}', '\u{304}']), ('\u{1fb2}', &['\u{1f70}', '\u{345}']),
        ('\u{1fb3}', &['\u{3b1}', '\u{345}']), ('\u{1fb4}', &['\u{3ac}', '\u{345}']), ('\u{1fb6}',
        &['\u{3b1}', '\u{342}']), ('\u{1fb7}', &['\u{1fb6}', '\u{345}']), ('\u{1fb8}', &['\u{391}',
        '\u{306}']), ('\u{1fb9}', &['\u{391}', '\u{304}']), ('\u{1fba}', &['\u{391}', '\u{300}']),
        ('\u{1fbb}', &['\u{386}']), ('\u{1fbc}', &['\u{391}', '\u{345}']), ('\u{1fbe}',
        &['\u{3b9}']), ('\u{1fc1}', &['\u{a8}', '\u{342}']), ('\u{1fc2}', &['\u{1f74}', '\u{345}']),
        ('\u{1fc3}', &['\u{3b7}', '\u{345}']), ('\u{1fc4}', &['\u{3ae}', '\u{345}']), ('\u{1fc6}',
        &['\u{3b7}', '\u{342}']), ('\u{1fc7}', &['\u{1fc6}', '\u{345}']), ('\u{1fc8}', &['\u{395}',
        '\u{300}']), ('\u{1fc9}', &['\u{388}']), ('\u{1fca}', &['\u{397}', '\u{300}']), ('\u{1fcb}',
        &['\u{389}']), ('\u{1fcc}', &['\u{397}', '\u{345}']), ('\u{1fcd}', &['\u{1fbf}',
        '\u{300}']), ('\u{1fce}', &['\u{1fbf}', '\u{301}']), ('\u{1fcf}', &['\u{1fbf}', '\u{342}']),
        ('\u{1fd0}', &['\u{3b9}', '\u{306}']), ('\u{1fd1}', &['\u{3b9}', '\u{304}']), ('\u{1fd2}',
        &['\u{3ca}', '\u{300}']), ('\u{1fd3}', &['\u{390}']), ('\u{1fd6}', &['\u{3b9}', '\u{342}']),
        ('\u{1fd7}', &['\u{3ca}', '\u{342}']), ('\u{1fd8}', &['\u{399}', '\u{306}']), ('\u{1fd9}',
        &['\u{399}', '\u{304}']), ('\u{1fda}', &['\u{399}', '\u{300}']), ('\u{1fdb}', &['\u{38a}']),
        ('\u{1fdd}', &['\u{1ffe}', '\u{300}']), ('\u{1fde}', &['\u{1ffe}', '\u{301}']), ('\u{1fdf}',
        &['\u{1ffe}', '\u{342}']), ('\u{1fe0}', &['\u{3c5}', '\u{306}']), ('\u{1fe1}', &['\u{3c5}',
        '\u{304}']), ('\u{1fe2}', &['\u{3cb}', '\u{300}']), ('\u{1fe3}', &['\u{3b0}']), ('\u{1fe4}',
        &['\u{3c1}', '\u{313}']), ('\u{1fe5}', &['\u{3c1}', '\u{314}']), ('\u{1fe6}', &['\u{3c5}',
        '\u{342}']), ('\u{1fe7}', &['\u{3cb}', '\u{342}']), ('\u{1fe8}', &['\u{3a5}', '\u{306}']),
        ('\u{1fe9}', &['\u{3a5}', '\u{304}']), ('\u{1fea}', &['\u{3a5}', '\u{300}']), ('\u{1feb}',
        &['\u{38e}']), ('\u{1fec}', &['\u{3a1}', '\u{314}']), ('\u{1fed}', &['\u{a8}', '\u{300}']),
        ('\u{1fee}', &['\u{385}']), ('\u{1fef}', &['\u{60}']), ('\u{1ff2}', &['\u{1f7c}',
        '\u{345}']), ('\u{1ff3}', &['\u{3c9}', '\u{345}']), ('\u{1ff4}', &['\u{3ce}', '\u{345}']),
        ('\u{1ff6}', &['\u{3c9}', '\u{342}']), ('\u{1ff7}', &['\u{1ff6}', '\u{345}']), ('\u{1ff8}',
        &['\u{39f}', '\u{300}']), ('\u{1ff9}', &['\u{38c}']), ('\u{1ffa}', &['\u{3a9}', '\u{300}']),
        ('\u{1ffb}', &['\u{38f}']), ('\u{1ffc}', &['\u{3a9}', '\u{345}']), ('\u{1ffd}',
        &['\u{b4}']), ('\u{2000}', &['\u{2002}']), ('\u{2001}', &['\u{2003}']), ('\u{2126}',
        &['\u{3a9}']), ('\u{212a}', &['\u{4b}']), ('\u{212b}', &['\u{c5}']), ('\u{219a}',
        &['\u{2190}', '\u{338}']), ('\u{219b}', &['\u{2192}', '\u{338}']), ('\u{21ae}',
        &['\u{2194}', '\u{338}']), ('\u{21cd}', &['\u{21d0}', '\u{338}']), ('\u{21ce}',
        &['\u{21d4}', '\u{338}']), ('\u{21cf}', &['\u{21d2}', '\u{338}']), ('\u{2204}',
        &['\u{2203}', '\u{338}']), ('\u{2209}', &['\u{2208}', '\u{338}']), ('\u{220c}',
        &['\u{220b}', '\u{338}']), ('\u{2224}', &['\u{2223}', '\u{338}']), ('\u{2226}',
        &['\u{2225}', '\u{338}']), ('\u{2241}', &['\u{223c}', '\u{338}']), ('\u{2244}',
        &['\u{2243}', '\u{338}']), ('\u{2247}', &['\u{2245}', '\u{338}']), ('\u{2249}',
        &['\u{2248}', '\u{338}']), ('\u{2260}', &['\u{3d}', '\u{338}']), ('\u{2262}', &['\u{2261}',
        '\u{338}']), ('\u{226d}', &['\u{224d}', '\u{338}']), ('\u{226e}', &['\u{3c}', '\u{338}']),
        ('\u{226f}', &['\u{3e}', '\u{338}']), ('\u{2270}', &['\u{2264}', '\u{338}']), ('\u{2271}',
        &['\u{2265}', '\u{338}']), ('\u{2274}', &['\u{2272}', '\u{338}']), ('\u{2275}',
        &['\u{2273}', '\u{338}']), ('\u{2278}', &['\u{2276}', '\u{338}']), ('\u{2279}',
        &['\u{2277}', '\u{338}']), ('\u{2280}', &['\u{227a}', '\u{338}']), ('\u{2281}',
        &['\u{227b}', '\u{338}']), ('\u{2284}', &['\u{2282}', '\u{338}']), ('\u{2285}',
        &['\u{2283}', '\u{338}']), ('\u{2288}', &['\u{2286}', '\u{338}']), ('\u{2289}',
        &['\u{2287}', '\u{338}']), ('\u{22ac}', &['\u{22a2}', '\u{338}']), ('\u{22ad}',
        &['\u{22a8}', '\u{338}']), ('\u{22ae}', &['\u{22a9}', '\u{338}']), ('\u{22af}',
        &['\u{22ab}', '\u{338}']), ('\u{22e0}', &['\u{227c}', '\u{338}']), ('\u{22e1}',
        &['\u{227d}', '\u{338}']), ('\u{22e2}', &['\u{2291}', '\u{338}']), ('\u{22e3}',
        &['\u{2292}', '\u{338}']), ('\u{22ea}', &['\u{22b2}', '\u{338}']), ('\u{22eb}',
        &['\u{22b3}', '\u{338}']), ('\u{22ec}', &['\u{22b4}', '\u{338}']), ('\u{22ed}',
        &['\u{22b5}', '\u{338}']), ('\u{2329}', &['\u{3008}']), ('\u{232a}', &['\u{3009}']),
        ('\u{2adc}', &['\u{2add}', '\u{338}']), ('\u{304c}', &['\u{304b}', '\u{3099}']),
        ('\u{304e}', &['\u{304d}', '\u{3099}']), ('\u{3050}', &['\u{304f}', '\u{3099}']),
        ('\u{3052}', &['\u{3051}', '\u{3099}']), ('\u{3054}', &['\u{3053}', '\u{3099}']),
        ('\u{3056}', &['\u{3055}', '\u{3099}']), ('\u{3058}', &['\u{3057}', '\u{3099}']),
        ('\u{305a}', &['\u{3059}', '\u{3099}']), ('\u{305c}', &['\u{305b}', '\u{3099}']),
        ('\u{305e}', &['\u{305d}', '\u{3099}']), ('\u{3060}', &['\u{305f}', '\u{3099}']),
        ('\u{3062}', &['\u{3061}', '\u{3099}']), ('\u{3065}', &['\u{3064}', '\u{3099}']),
        ('\u{3067}', &['\u{3066}', '\u{3099}']), ('\u{3069}', &['\u{3068}', '\u{3099}']),
        ('\u{3070}', &['\u{306f}', '\u{3099}']), ('\u{3071}', &['\u{306f}', '\u{309a}']),
        ('\u{3073}', &['\u{3072}', '\u{3099}']), ('\u{3074}', &['\u{3072}', '\u{309a}']),
        ('\u{3076}', &['\u{3075}', '\u{3099}']), ('\u{3077}', &['\u{3075}', '\u{309a}']),
        ('\u{3079}', &['\u{3078}', '\u{3099}']), ('\u{307a}', &['\u{3078}', '\u{309a}']),
        ('\u{307c}', &['\u{307b}', '\u{3099}']), ('\u{307d}', &['\u{307b}', '\u{309a}']),
        ('\u{3094}', &['\u{3046}', '\u{3099}']), ('\u{309e}', &['\u{309d}', '\u{3099}']),
        ('\u{30ac}', &['\u{30ab}', '\u{3099}']), ('\u{30ae}', &['\u{30ad}', '\u{3099}']),
        ('\u{30b0}', &['\u{30af}', '\u{3099}']), ('\u{30b2}', &['\u{30b1}', '\u{3099}']),
        ('\u{30b4}', &['\u{30b3}', '\u{3099}']), ('\u{30b6}', &['\u{30b5}', '\u{3099}']),
        ('\u{30b8}', &['\u{30b7}', '\u{3099}']), ('\u{30ba}', &['\u{30b9}', '\u{3099}']),
        ('\u{30bc}', &['\u{30bb}', '\u{3099}']), ('\u{30be}', &['\u{30bd}', '\u{3099}']),
        ('\u{30c0}', &['\u{30bf}', '\u{3099}']), ('\u{30c2}', &['\u{30c1}', '\u{3099}']),
        ('\u{30c5}', &['\u{30c4}', '\u{3099}']), ('\u{30c7}', &['\u{30c6}', '\u{3099}']),
        ('\u{30c9}', &['\u{30c8}', '\u{3099}']), ('\u{30d0}', &['\u{30cf}', '\u{3099}']),
        ('\u{30d1}', &['\u{30cf}', '\u{309a}']), ('\u{30d3}', &['\u{30d2}', '\u{3099}']),
        ('\u{30d4}', &['\u{30d2}', '\u{309a}']), ('\u{30d6}', &['\u{30d5}', '\u{3099}']),
        ('\u{30d7}', &['\u{30d5}', '\u{309a}']), ('\u{30d9}', &['\u{30d8}', '\u{3099}']),
        ('\u{30da}', &['\u{30d8}', '\u{309a}']), ('\u{30dc}', &['\u{30db}', '\u{3099}']),
        ('\u{30dd}', &['\u{30db}', '\u{309a}']), ('\u{30f4}', &['\u{30a6}', '\u{3099}']),
        ('\u{30f7}', &['\u{30ef}', '\u{3099}']), ('\u{30f8}', &['\u{30f0}', '\u{3099}']),
        ('\u{30f9}', &['\u{30f1}', '\u{3099}']), ('\u{30fa}', &['\u{30f2}', '\u{3099}']),
        ('\u{30fe}', &['\u{30fd}', '\u{3099}']), ('\u{f900}', &['\u{8c48}']), ('\u{f901}',
        &['\u{66f4}']), ('\u{f902}', &['\u{8eca}']), ('\u{f903}', &['\u{8cc8}']), ('\u{f904}',
        &['\u{6ed1}']), ('\u{f905}', &['\u{4e32}']), ('\u{f906}', &['\u{53e5}']), ('\u{f907}',
        &['\u{9f9c}']), ('\u{f908}', &['\u{9f9c}']), ('\u{f909}', &['\u{5951}']), ('\u{f90a}',
        &['\u{91d1}']), ('\u{f90b}', &['\u{5587}']), ('\u{f90c}', &['\u{5948}']), ('\u{f90d}',
        &['\u{61f6}']), ('\u{f90e}', &['\u{7669}']), ('\u{f90f}', &['\u{7f85}']), ('\u{f910}',
        &['\u{863f}']), ('\u{f911}', &['\u{87ba}']), ('\u{f912}', &['\u{88f8}']), ('\u{f913}',
        &['\u{908f}']), ('\u{f914}', &['\u{6a02}']), ('\u{f915}', &['\u{6d1b}']), ('\u{f916}',
        &['\u{70d9}']), ('\u{f917}', &['\u{73de}']), ('\u{f918}', &['\u{843d}']), ('\u{f919}',
        &['\u{916a}']), ('\u{f91a}', &['\u{99f1}']), ('\u{f91b}', &['\u{4e82}']), ('\u{f91c}',
        &['\u{5375}']), ('\u{f91d}', &['\u{6b04}']), ('\u{f91e}', &['\u{721b}']), ('\u{f91f}',
        &['\u{862d}']), ('\u{f920}', &['\u{9e1e}']), ('\u{f921}', &['\u{5d50}']), ('\u{f922}',
        &['\u{6feb}']), ('\u{f923}', &['\u{85cd}']), ('\u{f924}', &['\u{8964}']), ('\u{f925}',
        &['\u{62c9}']), ('\u{f926}', &['\u{81d8}']), ('\u{f927}', &['\u{881f}']), ('\u{f928}',
        &['\u{5eca}']), ('\u{f929}', &['\u{6717}']), ('\u{f92a}', &['\u{6d6a}']), ('\u{f92b}',
        &['\u{72fc}']), ('\u{f92c}', &['\u{90ce}']), ('\u{f92d}', &['\u{4f86}']), ('\u{f92e}',
        &['\u{51b7}']), ('\u{f92f}', &['\u{52de}']), ('\u{f930}', &['\u{64c4}']), ('\u{f931}',
        &['\u{6ad3}']), ('\u{f932}', &['\u{7210}']), ('\u{f933}', &['\u{76e7}']), ('\u{f934}',
        &['\u{8001}']), ('\u{f935}', &['\u{8606}']), ('\u{f936}', &['\u{865c}']), ('\u{f937}',
        &['\u{8def}']), ('\u{f938}', &['\u{9732}']), ('\u{f939}', &['\u{9b6f}']), ('\u{f93a}',
        &['\u{9dfa}']), ('\u{f93b}', &['\u{788c}']), ('\u{f93c}', &['\u{797f}']), ('\u{f93d}',
        &['\u{7da0}']), ('\u{f93e}', &['\u{83c9}']), ('\u{f93f}', &['\u{9304}']), ('\u{f940}',
        &['\u{9e7f}']), ('\u{f941}', &['\u{8ad6}']), ('\u{f942}', &['\u{58df}']), ('\u{f943}',
        &['\u{5f04}']), ('\u{f944}', &['\u{7c60}']), ('\u{f945}', &['\u{807e}']), ('\u{f946}',
        &['\u{7262}']), ('\u{f947}', &['\u{78ca}']), ('\u{f948}', &['\u{8cc2}']), ('\u{f949}',
        &['\u{96f7}']), ('\u{f94a}', &['\u{58d8}']), ('\u{f94b}', &['\u{5c62}']), ('\u{f94c}',
        &['\u{6a13}']), ('\u{f94d}', &['\u{6dda}']), ('\u{f94e}', &['\u{6f0f}']), ('\u{f94f}',
        &['\u{7d2f}']), ('\u{f950}', &['\u{7e37}']), ('\u{f951}', &['\u{964b}']), ('\u{f952}',
        &['\u{52d2}']), ('\u{f953}', &['\u{808b}']), ('\u{f954}', &['\u{51dc}']), ('\u{f955}',
        &['\u{51cc}']), ('\u{f956}', &['\u{7a1c}']), ('\u{f957}', &['\u{7dbe}']), ('\u{f958}',
        &['\u{83f1}']), ('\u{f959}', &['\u{9675}']), ('\u{f95a}', &['\u{8b80}']), ('\u{f95b}',
        &['\u{62cf}']), ('\u{f95c}', &['\u{6a02}']), ('\u{f95d}', &['\u{8afe}']), ('\u{f95e}',
        &['\u{4e39}']), ('\u{f95f}', &['\u{5be7}']), ('\u{f960}', &['\u{6012}']), ('\u{f961}',
        &['\u{7387}']), ('\u{f962}', &['\u{7570}']), ('\u{f963}', &['\u{5317}']), ('\u{f964}',
        &['\u{78fb}']), ('\u{f965}', &['\u{4fbf}']), ('\u{f966}', &['\u{5fa9}']), ('\u{f967}',
        &['\u{4e0d}']), ('\u{f968}', &['\u{6ccc}']), ('\u{f969}', &['\u{6578}']), ('\u{f96a}',
        &['\u{7d22}']), ('\u{f96b}', &['\u{53c3}']), ('\u{f96c}', &['\u{585e}']), ('\u{f96d}',
        &['\u{7701}']), ('\u{f96e}', &['\u{8449}']), ('\u{f96f}', &['\u{8aaa}']), ('\u{f970}',
        &['\u{6bba}']), ('\u{f971}', &['\u{8fb0}']), ('\u{f972}', &['\u{6c88}']), ('\u{f973}',
        &['\u{62fe}']), ('\u{f974}', &['\u{82e5}']), ('\u{f975}', &['\u{63a0}']), ('\u{f976}',
        &['\u{7565}']), ('\u{f977}', &['\u{4eae}']), ('\u{f978}', &['\u{5169}']), ('\u{f979}',
        &['\u{51c9}']), ('\u{f97a}', &['\u{6881}']), ('\u{f97b}', &['\u{7ce7}']), ('\u{f97c}',
        &['\u{826f}']), ('\u{f97d}', &['\u{8ad2}']), ('\u{f97e}', &['\u{91cf}']), ('\u{f97f}',
        &['\u{52f5}']), ('\u{f980}', &['\u{5442}']), ('\u{f981}', &['\u{5973}']), ('\u{f982}',
        &['\u{5eec}']), ('\u{f983}', &['\u{65c5}']), ('\u{f984}', &['\u{6ffe}']), ('\u{f985}',
        &['\u{792a}']), ('\u{f986}', &['\u{95ad}']), ('\u{f987}', &['\u{9a6a}']), ('\u{f988}',
        &['\u{9e97}']), ('\u{f989}', &['\u{9ece}']), ('\u{f98a}', &['\u{529b}']), ('\u{f98b}',
        &['\u{66c6}']), ('\u{f98c}', &['\u{6b77}']), ('\u{f98d}', &['\u{8f62}']), ('\u{f98e}',
        &['\u{5e74}']), ('\u{f98f}', &['\u{6190}']), ('\u{f990}', &['\u{6200}']), ('\u{f991}',
        &['\u{649a}']), ('\u{f992}', &['\u{6f23}']), ('\u{f993}', &['\u{7149}']), ('\u{f994}',
        &['\u{7489}']), ('\u{f995}', &['\u{79ca}']), ('\u{f996}', &['\u{7df4}']), ('\u{f997}',
        &['\u{806f}']), ('\u{f998}', &['\u{8f26}']), ('\u{f999}', &['\u{84ee}']), ('\u{f99a}',
        &['\u{9023}']), ('\u{f99b}', &['\u{934a}']), ('\u{f99c}', &['\u{5217}']), ('\u{f99d}',
        &['\u{52a3}']), ('\u{f99e}', &['\u{54bd}']), ('\u{f99f}', &['\u{70c8}']), ('\u{f9a0}',
        &['\u{88c2}']), ('\u{f9a1}', &['\u{8aaa}']), ('\u{f9a2}', &['\u{5ec9}']), ('\u{f9a3}',
        &['\u{5ff5}']), ('\u{f9a4}', &['\u{637b}']), ('\u{f9a5}', &['\u{6bae}']), ('\u{f9a6}',
        &['\u{7c3e}']), ('\u{f9a7}', &['\u{7375}']), ('\u{f9a8}', &['\u{4ee4}']), ('\u{f9a9}',
        &['\u{56f9}']), ('\u{f9aa}', &['\u{5be7}']), ('\u{f9ab}', &['\u{5dba}']), ('\u{f9ac}',
        &['\u{601c}']), ('\u{f9ad}', &['\u{73b2}']), ('\u{f9ae}', &['\u{7469}']), ('\u{f9af}',
        &['\u{7f9a}']), ('\u{f9b0}', &['\u{8046}']), ('\u{f9b1}', &['\u{9234}']), ('\u{f9b2}',
        &['\u{96f6}']), ('\u{f9b3}', &['\u{9748}']), ('\u{f9b4}', &['\u{9818}']), ('\u{f9b5}',
        &['\u{4f8b}']), ('\u{f9b6}', &['\u{79ae}']), ('\u{f9b7}', &['\u{91b4}']), ('\u{f9b8}',
        &['\u{96b8}']), ('\u{f9b9}', &['\u{60e1}']), ('\u{f9ba}', &['\u{4e86}']), ('\u{f9bb}',
        &['\u{50da}']), ('\u{f9bc}', &['\u{5bee}']), ('\u{f9bd}', &['\u{5c3f}']), ('\u{f9be}',
        &['\u{6599}']), ('\u{f9bf}', &['\u{6a02}']), ('\u{f9c0}', &['\u{71ce}']), ('\u{f9c1}',
        &['\u{7642}']), ('\u{f9c2}', &['\u{84fc}']), ('\u{f9c3}', &['\u{907c}']), ('\u{f9c4}',
        &['\u{9f8d}']), ('\u{f9c5}', &['\u{6688}']), ('\u{f9c6}', &['\u{962e}']), ('\u{f9c7}',
        &['\u{5289}']), ('\u{f9c8}', &['\u{677b}']), ('\u{f9c9}', &['\u{67f3}']), ('\u{f9ca}',
        &['\u{6d41}']), ('\u{f9cb}', &['\u{6e9c}']), ('\u{f9cc}', &['\u{7409}']), ('\u{f9cd}',
        &['\u{7559}']), ('\u{f9ce}', &['\u{786b}']), ('\u{f9cf}', &['\u{7d10}']), ('\u{f9d0}',
        &['\u{985e}']), ('\u{f9d1}', &['\u{516d}']), ('\u{f9d2}', &['\u{622e}']), ('\u{f9d3}',
        &['\u{9678}']), ('\u{f9d4}', &['\u{502b}']), ('\u{f9d5}', &['\u{5d19}']), ('\u{f9d6}',
        &['\u{6dea}']), ('\u{f9d7}', &['\u{8f2a}']), ('\u{f9d8}', &['\u{5f8b}']), ('\u{f9d9}',
        &['\u{6144}']), ('\u{f9da}', &['\u{6817}']), ('\u{f9db}', &['\u{7387}']), ('\u{f9dc}',
        &['\u{9686}']), ('\u{f9dd}', &['\u{5229}']), ('\u{f9de}', &['\u{540f}']), ('\u{f9df}',
        &['\u{5c65}']), ('\u{f9e0}', &['\u{6613}']), ('\u{f9e1}', &['\u{674e}']), ('\u{f9e2}',
        &['\u{68a8}']), ('\u{f9e3}', &['\u{6ce5}']), ('\u{f9e4}', &['\u{7406}']), ('\u{f9e5}',
        &['\u{75e2}']), ('\u{f9e6}', &['\u{7f79}']), ('\u{f9e7}', &['\u{88cf}']), ('\u{f9e8}',
        &['\u{88e1}']), ('\u{f9e9}', &['\u{91cc}']), ('\u{f9ea}', &['\u{96e2}']), ('\u{f9eb}',
        &['\u{533f}']), ('\u{f9ec}', &['\u{6eba}']), ('\u{f9ed}', &['\u{541d}']), ('\u{f9ee}',
        &['\u{71d0}']), ('\u{f9ef}', &['\u{7498}']), ('\u{f9f0}', &['\u{85fa}']), ('\u{f9f1}',
        &['\u{96a3}']), ('\u{f9f2}', &['\u{9c57}']), ('\u{f9f3}', &['\u{9e9f}']), ('\u{f9f4}',
        &['\u{6797}']), ('\u{f9f5}', &['\u{6dcb}']), ('\u{f9f6}', &['\u{81e8}']), ('\u{f9f7}',
        &['\u{7acb}']), ('\u{f9f8}', &['\u{7b20}']), ('\u{f9f9}', &['\u{7c92}']), ('\u{f9fa}',
        &['\u{72c0}']), ('\u{f9fb}', &['\u{7099}']), ('\u{f9fc}', &['\u{8b58}']), ('\u{f9fd}',
        &['\u{4ec0}']), ('\u{f9fe}', &['\u{8336}']), ('\u{f9ff}', &['\u{523a}']), ('\u{fa00}',
        &['\u{5207}']), ('\u{fa01}', &['\u{5ea6}']), ('\u{fa02}', &['\u{62d3}']), ('\u{fa03}',
        &['\u{7cd6}']), ('\u{fa04}', &['\u{5b85}']), ('\u{fa05}', &['\u{6d1e}']), ('\u{fa06}',
        &['\u{66b4}']), ('\u{fa07}', &['\u{8f3b}']), ('\u{fa08}', &['\u{884c}']), ('\u{fa09}',
        &['\u{964d}']), ('\u{fa0a}', &['\u{898b}']), ('\u{fa0b}', &['\u{5ed3}']), ('\u{fa0c}',
        &['\u{5140}']), ('\u{fa0d}', &['\u{55c0}']), ('\u{fa10}', &['\u{585a}']), ('\u{fa12}',
        &['\u{6674}']), ('\u{fa15}', &['\u{51de}']), ('\u{fa16}', &['\u{732a}']), ('\u{fa17}',
        &['\u{76ca}']), ('\u{fa18}', &['\u{793c}']), ('\u{fa19}', &['\u{795e}']), ('\u{fa1a}',
        &['\u{7965}']), ('\u{fa1b}', &['\u{798f}']), ('\u{fa1c}', &['\u{9756}']), ('\u{fa1d}',
        &['\u{7cbe}']), ('\u{fa1e}', &['\u{7fbd}']), ('\u{fa20}', &['\u{8612}']), ('\u{fa22}',
        &['\u{8af8}']), ('\u{fa25}', &['\u{9038}']), ('\u{fa26}', &['\u{90fd}']), ('\u{fa2a}',
        &['\u{98ef}']), ('\u{fa2b}', &['\u{98fc}']), ('\u{fa2c}', &['\u{9928}']), ('\u{fa2d}',
        &['\u{9db4}']), ('\u{fa2e}', &['\u{90de}']), ('\u{fa2f}', &['\u{96b7}']), ('\u{fa30}',
        &['\u{4fae}']), ('\u{fa31}', &['\u{50e7}']), ('\u{fa32}', &['\u{514d}']), ('\u{fa33}',
        &['\u{52c9}']), ('\u{fa34}', &['\u{52e4}']), ('\u{fa35}', &['\u{5351}']), ('\u{fa36}',
        &['\u{559d}']), ('\u{fa37}', &['\u{5606}']), ('\u{fa38}', &['\u{5668}']), ('\u{fa39}',
        &['\u{5840}']), ('\u{fa3a}', &['\u{58a8}']), ('\u{fa3b}', &['\u{5c64}']), ('\u{fa3c}',
        &['\u{5c6e}']), ('\u{fa3d}', &['\u{6094}']), ('\u{fa3e}', &['\u{6168}']), ('\u{fa3f}',
        &['\u{618e}']), ('\u{fa40}', &['\u{61f2}']), ('\u{fa41}', &['\u{654f}']), ('\u{fa42}',
        &['\u{65e2}']), ('\u{fa43}', &['\u{6691}']), ('\u{fa44}', &['\u{6885}']), ('\u{fa45}',
        &['\u{6d77}']), ('\u{fa46}', &['\u{6e1a}']), ('\u{fa47}', &['\u{6f22}']), ('\u{fa48}',
        &['\u{716e}']), ('\u{fa49}', &['\u{722b}']), ('\u{fa4a}', &['\u{7422}']), ('\u{fa4b}',
        &['\u{7891}']), ('\u{fa4c}', &['\u{793e}']), ('\u{fa4d}', &['\u{7949}']), ('\u{fa4e}',
        &['\u{7948}']), ('\u{fa4f}', &['\u{7950}']), ('\u{fa50}', &['\u{7956}']), ('\u{fa51}',
        &['\u{795d}']), ('\u{fa52}', &['\u{798d}']), ('\u{fa53}', &['\u{798e}']), ('\u{fa54}',
        &['\u{7a40}']), ('\u{fa55}', &['\u{7a81}']), ('\u{fa56}', &['\u{7bc0}']), ('\u{fa57}',
        &['\u{7df4}']), ('\u{fa58}', &['\u{7e09}']), ('\u{fa59}', &['\u{7e41}']), ('\u{fa5a}',
        &['\u{7f72}']), ('\u{fa5b}', &['\u{8005}']), ('\u{fa5c}', &['\u{81ed}']), ('\u{fa5d}',
        &['\u{8279}']), ('\u{fa5e}', &['\u{8279}']), ('\u{fa5f}', &['\u{8457}']), ('\u{fa60}',
        &['\u{8910}']), ('\u{fa61}', &['\u{8996}']), ('\u{fa62}', &['\u{8b01}']), ('\u{fa63}',
        &['\u{8b39}']), ('\u{fa64}', &['\u{8cd3}']), ('\u{fa65}', &['\u{8d08}']), ('\u{fa66}',
        &['\u{8fb6}']), ('\u{fa67}', &['\u{9038}']), ('\u{fa68}', &['\u{96e3}']), ('\u{fa69}',
        &['\u{97ff}']), ('\u{fa6a}', &['\u{983b}']), ('\u{fa6b}', &['\u{6075}']), ('\u{fa6c}',
        &['\u{242ee}']), ('\u{fa6d}', &['\u{8218}']), ('\u{fa70}', &['\u{4e26}']), ('\u{fa71}',
        &['\u{51b5}']), ('\u{fa72}', &['\u{5168}']), ('\u{fa73}', &['\u{4f80}']), ('\u{fa74}',
        &['\u{5145}']), ('\u{fa75}', &['\u{5180}']), ('\u{fa76}', &['\u{52c7}']), ('\u{fa77}',
        &['\u{52fa}']), ('\u{fa78}', &['\u{559d}']), ('\u{fa79}', &['\u{5555}']), ('\u{fa7a}',
        &['\u{5599}']), ('\u{fa7b}', &['\u{55e2}']), ('\u{fa7c}', &['\u{585a}']), ('\u{fa7d}',
        &['\u{58b3}']), ('\u{fa7e}', &['\u{5944}']), ('\u{fa7f}', &['\u{5954}']), ('\u{fa80}',
        &['\u{5a62}']), ('\u{fa81}', &['\u{5b28}']), ('\u{fa82}', &['\u{5ed2}']), ('\u{fa83}',
        &['\u{5ed9}']), ('\u{fa84}', &['\u{5f69}']), ('\u{fa85}', &['\u{5fad}']), ('\u{fa86}',
        &['\u{60d8}']), ('\u{fa87}', &['\u{614e}']), ('\u{fa88}', &['\u{6108}']), ('\u{fa89}',
        &['\u{618e}']), ('\u{fa8a}', &['\u{6160}']), ('\u{fa8b}', &['\u{61f2}']), ('\u{fa8c}',
        &['\u{6234}']), ('\u{fa8d}', &['\u{63c4}']), ('\u{fa8e}', &['\u{641c}']), ('\u{fa8f}',
        &['\u{6452}']), ('\u{fa90}', &['\u{6556}']), ('\u{fa91}', &['\u{6674}']), ('\u{fa92}',
        &['\u{6717}']), ('\u{fa93}', &['\u{671b}']), ('\u{fa94}', &['\u{6756}']), ('\u{fa95}',
        &['\u{6b79}']), ('\u{fa96}', &['\u{6bba}']), ('\u{fa97}', &['\u{6d41}']), ('\u{fa98}',
        &['\u{6edb}']), ('\u{fa99}', &['\u{6ecb}']), ('\u{fa9a}', &['\u{6f22}']), ('\u{fa9b}',
        &['\u{701e}']), ('\u{fa9c}', &['\u{716e}']), ('\u{fa9d}', &['\u{77a7}']), ('\u{fa9e}',
        &['\u{7235}']), ('\u{fa9f}', &['\u{72af}']), ('\u{faa0}', &['\u{732a}']), ('\u{faa1}',
        &['\u{7471}']), ('\u{faa2}', &['\u{7506}']), ('\u{faa3}', &['\u{753b}']), ('\u{faa4}',
        &['\u{761d}']), ('\u{faa5}', &['\u{761f}']), ('\u{faa6}', &['\u{76ca}']), ('\u{faa7}',
        &['\u{76db}']), ('\u{faa8}', &['\u{76f4}']), ('\u{faa9}', &['\u{774a}']), ('\u{faaa}',
        &['\u{7740}']), ('\u{faab}', &['\u{78cc}']), ('\u{faac}', &['\u{7ab1}']), ('\u{faad}',
        &['\u{7bc0}']), ('\u{faae}', &['\u{7c7b}']), ('\u{faaf}', &['\u{7d5b}']), ('\u{fab0}',
        &['\u{7df4}']), ('\u{fab1}', &['\u{7f3e}']), ('\u{fab2}', &['\u{8005}']), ('\u{fab3}',
        &['\u{8352}']), ('\u{fab4}', &['\u{83ef}']), ('\u{fab5}', &['\u{8779}']), ('\u{fab6}',
        &['\u{8941}']), ('\u{fab7}', &['\u{8986}']), ('\u{fab8}', &['\u{8996}']), ('\u{fab9}',
        &['\u{8abf}']), ('\u{faba}', &['\u{8af8}']), ('\u{fabb}', &['\u{8acb}']), ('\u{fabc}',
        &['\u{8b01}']), ('\u{fabd}', &['\u{8afe}']), ('\u{fabe}', &['\u{8aed}']), ('\u{fabf}',
        &['\u{8b39}']), ('\u{fac0}', &['\u{8b8a}']), ('\u{fac1}', &['\u{8d08}']), ('\u{fac2}',
        &['\u{8f38}']), ('\u{fac3}', &['\u{9072}']), ('\u{fac4}', &['\u{9199}']), ('\u{fac5}',
        &['\u{9276}']), ('\u{fac6}', &['\u{967c}']), ('\u{fac7}', &['\u{96e3}']), ('\u{fac8}',
        &['\u{9756}']), ('\u{fac9}', &['\u{97db}']), ('\u{faca}', &['\u{97ff}']), ('\u{facb}',
        &['\u{980b}']), ('\u{facc}', &['\u{983b}']), ('\u{facd}', &['\u{9b12}']), ('\u{face}',
        &['\u{9f9c}']), ('\u{facf}', &['\u{2284a}']), ('\u{fad0}', &['\u{22844}']), ('\u{fad1}',
        &['\u{233d5}']), ('\u{fad2}', &['\u{3b9d}']), ('\u{fad3}', &['\u{4018}']), ('\u{fad4}',
        &['\u{4039}']), ('\u{fad5}', &['\u{25249}']), ('\u{fad6}', &['\u{25cd0}']), ('\u{fad7}',
        &['\u{27ed3}']), ('\u{fad8}', &['\u{9f43}']), ('\u{fad9}', &['\u{9f8e}']), ('\u{fb1d}',
        &['\u{5d9}', '\u{5b4}']), ('\u{fb1f}', &['\u{5f2}', '\u{5b7}']), ('\u{fb2a}', &['\u{5e9}',
        '\u{5c1}']), ('\u{fb2b}', &['\u{5e9}', '\u{5c2}']), ('\u{fb2c}', &['\u{fb49}', '\u{5c1}']),
        ('\u{fb2d}', &['\u{fb49}', '\u{5c2}']), ('\u{fb2e}', &['\u{5d0}', '\u{5b7}']), ('\u{fb2f}',
        &['\u{5d0}', '\u{5b8}']), ('\u{fb30}', &['\u{5d0}', '\u{5bc}']), ('\u{fb31}', &['\u{5d1}',
        '\u{5bc}']), ('\u{fb32}', &['\u{5d2}', '\u{5bc}']), ('\u{fb33}', &['\u{5d3}', '\u{5bc}']),
        ('\u{fb34}', &['\u{5d4}', '\u{5bc}']), ('\u{fb35}', &['\u{5d5}', '\u{5bc}']), ('\u{fb36}',
        &['\u{5d6}', '\u{5bc}']), ('\u{fb38}', &['\u{5d8}', '\u{5bc}']), ('\u{fb39}', &['\u{5d9}',
        '\u{5bc}']), ('\u{fb3a}', &['\u{5da}', '\u{5bc}']), ('\u{fb3b}', &['\u{5db}', '\u{5bc}']),
        ('\u{fb3c}', &['\u{5dc}', '\u{5bc}']), ('\u{fb3e}', &['\u{5de}', '\u{5bc}']), ('\u{fb40}',
        &['\u{5e0}', '\u{5bc}']), ('\u{fb41}', &['\u{5e1}', '\u{5bc}']), ('\u{fb43}', &['\u{5e3}',
        '\u{5bc}']), ('\u{fb44}', &['\u{5e4}', '\u{5bc}']), ('\u{fb46}', &['\u{5e6}', '\u{5bc}']),
        ('\u{fb47}', &['\u{5e7}', '\u{5bc}']), ('\u{fb48}', &['\u{5e8}', '\u{5bc}']), ('\u{fb49}',
        &['\u{5e9}', '\u{5bc}']), ('\u{fb4a}', &['\u{5ea}', '\u{5bc}']), ('\u{fb4b}', &['\u{5d5}',
        '\u{5b9}']), ('\u{fb4c}', &['\u{5d1}', '\u{5bf}']), ('\u{fb4d}', &['\u{5db}', '\u{5bf}']),
        ('\u{fb4e}', &['\u{5e4}', '\u{5bf}']), ('\u{1109a}', &['\u{11099}', '\u{110ba}']),
        ('\u{1109c}', &['\u{1109b}', '\u{110ba}']), ('\u{110ab}', &['\u{110a5}', '\u{110ba}']),
        ('\u{1112e}', &['\u{11131}', '\u{11127}']), ('\u{1112f}', &['\u{11132}', '\u{11127}']),
        ('\u{1134b}', &['\u{11347}', '\u{1133e}']), ('\u{1134c}', &['\u{11347}', '\u{11357}']),
        ('\u{114bb}', &['\u{114b9}', '\u{114ba}']), ('\u{114bc}', &['\u{114b9}', '\u{114b0}']),
        ('\u{114be}', &['\u{114b9}', '\u{114bd}']), ('\u{115ba}', &['\u{115b8}', '\u{115af}']),
        ('\u{115bb}', &['\u{115b9}', '\u{115af}']), ('\u{1d15e}', &['\u{1d157}', '\u{1d165}']),
        ('\u{1d15f}', &['\u{1d158}', '\u{1d165}']), ('\u{1d160}', &['\u{1d15f}', '\u{1d16e}']),
        ('\u{1d161}', &['\u{1d15f}', '\u{1d16f}']), ('\u{1d162}', &['\u{1d15f}', '\u{1d170}']),
        ('\u{1d163}', &['\u{1d15f}', '\u{1d171}']), ('\u{1d164}', &['\u{1d15f}', '\u{1d172}']),
        ('\u{1d1bb}', &['\u{1d1b9}', '\u{1d165}']), ('\u{1d1bc}', &['\u{1d1ba}', '\u{1d165}']),
        ('\u{1d1bd}', &['\u{1d1bb}', '\u{1d16e}']), ('\u{1d1be}', &['\u{1d1bc}', '\u{1d16e}']),
        ('\u{1d1bf}', &['\u{1d1bb}', '\u{1d16f}']), ('\u{1d1c0}', &['\u{1d1bc}', '\u{1d16f}']),
        ('\u{2f800}', &['\u{4e3d}']), ('\u{2f801}', &['\u{4e38}']), ('\u{2f802}', &['\u{4e41}']),
        ('\u{2f803}', &['\u{20122}']), ('\u{2f804}', &['\u{4f60}']), ('\u{2f805}', &['\u{4fae}']),
        ('\u{2f806}', &['\u{4fbb}']), ('\u{2f807}', &['\u{5002}']), ('\u{2f808}', &['\u{507a}']),
        ('\u{2f809}', &['\u{5099}']), ('\u{2f80a}', &['\u{50e7}']), ('\u{2f80b}', &['\u{50cf}']),
        ('\u{2f80c}', &['\u{349e}']), ('\u{2f80d}', &['\u{2063a}']), ('\u{2f80e}', &['\u{514d}']),
        ('\u{2f80f}', &['\u{5154}']), ('\u{2f810}', &['\u{5164}']), ('\u{2f811}', &['\u{5177}']),
        ('\u{2f812}', &['\u{2051c}']), ('\u{2f813}', &['\u{34b9}']), ('\u{2f814}', &['\u{5167}']),
        ('\u{2f815}', &['\u{518d}']), ('\u{2f816}', &['\u{2054b}']), ('\u{2f817}', &['\u{5197}']),
        ('\u{2f818}', &['\u{51a4}']), ('\u{2f819}', &['\u{4ecc}']), ('\u{2f81a}', &['\u{51ac}']),
        ('\u{2f81b}', &['\u{51b5}']), ('\u{2f81c}', &['\u{291df}']), ('\u{2f81d}', &['\u{51f5}']),
        ('\u{2f81e}', &['\u{5203}']), ('\u{2f81f}', &['\u{34df}']), ('\u{2f820}', &['\u{523b}']),
        ('\u{2f821}', &['\u{5246}']), ('\u{2f822}', &['\u{5272}']), ('\u{2f823}', &['\u{5277}']),
        ('\u{2f824}', &['\u{3515}']), ('\u{2f825}', &['\u{52c7}']), ('\u{2f826}', &['\u{52c9}']),
        ('\u{2f827}', &['\u{52e4}']), ('\u{2f828}', &['\u{52fa}']), ('\u{2f829}', &['\u{5305}']),
        ('\u{2f82a}', &['\u{5306}']), ('\u{2f82b}', &['\u{5317}']), ('\u{2f82c}', &['\u{5349}']),
        ('\u{2f82d}', &['\u{5351}']), ('\u{2f82e}', &['\u{535a}']), ('\u{2f82f}', &['\u{5373}']),
        ('\u{2f830}', &['\u{537d}']), ('\u{2f831}', &['\u{537f}']), ('\u{2f832}', &['\u{537f}']),
        ('\u{2f833}', &['\u{537f}']), ('\u{2f834}', &['\u{20a2c}']), ('\u{2f835}', &['\u{7070}']),
        ('\u{2f836}', &['\u{53ca}']), ('\u{2f837}', &['\u{53df}']), ('\u{2f838}', &['\u{20b63}']),
        ('\u{2f839}', &['\u{53eb}']), ('\u{2f83a}', &['\u{53f1}']), ('\u{2f83b}', &['\u{5406}']),
        ('\u{2f83c}', &['\u{549e}']), ('\u{2f83d}', &['\u{5438}']), ('\u{2f83e}', &['\u{5448}']),
        ('\u{2f83f}', &['\u{5468}']), ('\u{2f840}', &['\u{54a2}']), ('\u{2f841}', &['\u{54f6}']),
        ('\u{2f842}', &['\u{5510}']), ('\u{2f843}', &['\u{5553}']), ('\u{2f844}', &['\u{5563}']),
        ('\u{2f845}', &['\u{5584}']), ('\u{2f846}', &['\u{5584}']), ('\u{2f847}', &['\u{5599}']),
        ('\u{2f848}', &['\u{55ab}']), ('\u{2f849}', &['\u{55b3}']), ('\u{2f84a}', &['\u{55c2}']),
        ('\u{2f84b}', &['\u{5716}']), ('\u{2f84c}', &['\u{5606}']), ('\u{2f84d}', &['\u{5717}']),
        ('\u{2f84e}', &['\u{5651}']), ('\u{2f84f}', &['\u{5674}']), ('\u{2f850}', &['\u{5207}']),
        ('\u{2f851}', &['\u{58ee}']), ('\u{2f852}', &['\u{57ce}']), ('\u{2f853}', &['\u{57f4}']),
        ('\u{2f854}', &['\u{580d}']), ('\u{2f855}', &['\u{578b}']), ('\u{2f856}', &['\u{5832}']),
        ('\u{2f857}', &['\u{5831}']), ('\u{2f858}', &['\u{58ac}']), ('\u{2f859}', &['\u{214e4}']),
        ('\u{2f85a}', &['\u{58f2}']), ('\u{2f85b}', &['\u{58f7}']), ('\u{2f85c}', &['\u{5906}']),
        ('\u{2f85d}', &['\u{591a}']), ('\u{2f85e}', &['\u{5922}']), ('\u{2f85f}', &['\u{5962}']),
        ('\u{2f860}', &['\u{216a8}']), ('\u{2f861}', &['\u{216ea}']), ('\u{2f862}', &['\u{59ec}']),
        ('\u{2f863}', &['\u{5a1b}']), ('\u{2f864}', &['\u{5a27}']), ('\u{2f865}', &['\u{59d8}']),
        ('\u{2f866}', &['\u{5a66}']), ('\u{2f867}', &['\u{36ee}']), ('\u{2f868}', &['\u{36fc}']),
        ('\u{2f869}', &['\u{5b08}']), ('\u{2f86a}', &['\u{5b3e}']), ('\u{2f86b}', &['\u{5b3e}']),
        ('\u{2f86c}', &['\u{219c8}']), ('\u{2f86d}', &['\u{5bc3}']), ('\u{2f86e}', &['\u{5bd8}']),
        ('\u{2f86f}', &['\u{5be7}']), ('\u{2f870}', &['\u{5bf3}']), ('\u{2f871}', &['\u{21b18}']),
        ('\u{2f872}', &['\u{5bff}']), ('\u{2f873}', &['\u{5c06}']), ('\u{2f874}', &['\u{5f53}']),
        ('\u{2f875}', &['\u{5c22}']), ('\u{2f876}', &['\u{3781}']), ('\u{2f877}', &['\u{5c60}']),
        ('\u{2f878}', &['\u{5c6e}']), ('\u{2f879}', &['\u{5cc0}']), ('\u{2f87a}', &['\u{5c8d}']),
        ('\u{2f87b}', &['\u{21de4}']), ('\u{2f87c}', &['\u{5d43}']), ('\u{2f87d}', &['\u{21de6}']),
        ('\u{2f87e}', &['\u{5d6e}']), ('\u{2f87f}', &['\u{5d6b}']), ('\u{2f880}', &['\u{5d7c}']),
        ('\u{2f881}', &['\u{5de1}']), ('\u{2f882}', &['\u{5de2}']), ('\u{2f883}', &['\u{382f}']),
        ('\u{2f884}', &['\u{5dfd}']), ('\u{2f885}', &['\u{5e28}']), ('\u{2f886}', &['\u{5e3d}']),
        ('\u{2f887}', &['\u{5e69}']), ('\u{2f888}', &['\u{3862}']), ('\u{2f889}', &['\u{22183}']),
        ('\u{2f88a}', &['\u{387c}']), ('\u{2f88b}', &['\u{5eb0}']), ('\u{2f88c}', &['\u{5eb3}']),
        ('\u{2f88d}', &['\u{5eb6}']), ('\u{2f88e}', &['\u{5eca}']), ('\u{2f88f}', &['\u{2a392}']),
        ('\u{2f890}', &['\u{5efe}']), ('\u{2f891}', &['\u{22331}']), ('\u{2f892}', &['\u{22331}']),
        ('\u{2f893}', &['\u{8201}']), ('\u{2f894}', &['\u{5f22}']), ('\u{2f895}', &['\u{5f22}']),
        ('\u{2f896}', &['\u{38c7}']), ('\u{2f897}', &['\u{232b8}']), ('\u{2f898}', &['\u{261da}']),
        ('\u{2f899}', &['\u{5f62}']), ('\u{2f89a}', &['\u{5f6b}']), ('\u{2f89b}', &['\u{38e3}']),
        ('\u{2f89c}', &['\u{5f9a}']), ('\u{2f89d}', &['\u{5fcd}']), ('\u{2f89e}', &['\u{5fd7}']),
        ('\u{2f89f}', &['\u{5ff9}']), ('\u{2f8a0}', &['\u{6081}']), ('\u{2f8a1}', &['\u{393a}']),
        ('\u{2f8a2}', &['\u{391c}']), ('\u{2f8a3}', &['\u{6094}']), ('\u{2f8a4}', &['\u{226d4}']),
        ('\u{2f8a5}', &['\u{60c7}']), ('\u{2f8a6}', &['\u{6148}']), ('\u{2f8a7}', &['\u{614c}']),
        ('\u{2f8a8}', &['\u{614e}']), ('\u{2f8a9}', &['\u{614c}']), ('\u{2f8aa}', &['\u{617a}']),
        ('\u{2f8ab}', &['\u{618e}']), ('\u{2f8ac}', &['\u{61b2}']), ('\u{2f8ad}', &['\u{61a4}']),
        ('\u{2f8ae}', &['\u{61af}']), ('\u{2f8af}', &['\u{61de}']), ('\u{2f8b0}', &['\u{61f2}']),
        ('\u{2f8b1}', &['\u{61f6}']), ('\u{2f8b2}', &['\u{6210}']), ('\u{2f8b3}', &['\u{621b}']),
        ('\u{2f8b4}', &['\u{625d}']), ('\u{2f8b5}', &['\u{62b1}']), ('\u{2f8b6}', &['\u{62d4}']),
        ('\u{2f8b7}', &['\u{6350}']), ('\u{2f8b8}', &['\u{22b0c}']), ('\u{2f8b9}', &['\u{633d}']),
        ('\u{2f8ba}', &['\u{62fc}']), ('\u{2f8bb}', &['\u{6368}']), ('\u{2f8bc}', &['\u{6383}']),
        ('\u{2f8bd}', &['\u{63e4}']), ('\u{2f8be}', &['\u{22bf1}']), ('\u{2f8bf}', &['\u{6422}']),
        ('\u{2f8c0}', &['\u{63c5}']), ('\u{2f8c1}', &['\u{63a9}']), ('\u{2f8c2}', &['\u{3a2e}']),
        ('\u{2f8c3}', &['\u{6469}']), ('\u{2f8c4}', &['\u{647e}']), ('\u{2f8c5}', &['\u{649d}']),
        ('\u{2f8c6}', &['\u{6477}']), ('\u{2f8c7}', &['\u{3a6c}']), ('\u{2f8c8}', &['\u{654f}']),
        ('\u{2f8c9}', &['\u{656c}']), ('\u{2f8ca}', &['\u{2300a}']), ('\u{2f8cb}', &['\u{65e3}']),
        ('\u{2f8cc}', &['\u{66f8}']), ('\u{2f8cd}', &['\u{6649}']), ('\u{2f8ce}', &['\u{3b19}']),
        ('\u{2f8cf}', &['\u{6691}']), ('\u{2f8d0}', &['\u{3b08}']), ('\u{2f8d1}', &['\u{3ae4}']),
        ('\u{2f8d2}', &['\u{5192}']), ('\u{2f8d3}', &['\u{5195}']), ('\u{2f8d4}', &['\u{6700}']),
        ('\u{2f8d5}', &['\u{669c}']), ('\u{2f8d6}', &['\u{80ad}']), ('\u{2f8d7}', &['\u{43d9}']),
        ('\u{2f8d8}', &['\u{6717}']), ('\u{2f8d9}', &['\u{671b}']), ('\u{2f8da}', &['\u{6721}']),
        ('\u{2f8db}', &['\u{675e}']), ('\u{2f8dc}', &['\u{6753}']), ('\u{2f8dd}', &['\u{233c3}']),
        ('\u{2f8de}', &['\u{3b49}']), ('\u{2f8df}', &['\u{67fa}']), ('\u{2f8e0}', &['\u{6785}']),
        ('\u{2f8e1}', &['\u{6852}']), ('\u{2f8e2}', &['\u{6885}']), ('\u{2f8e3}', &['\u{2346d}']),
        ('\u{2f8e4}', &['\u{688e}']), ('\u{2f8e5}', &['\u{681f}']), ('\u{2f8e6}', &['\u{6914}']),
        ('\u{2f8e7}', &['\u{3b9d}']), ('\u{2f8e8}', &['\u{6942}']), ('\u{2f8e9}', &['\u{69a3}']),
        ('\u{2f8ea}', &['\u{69ea}']), ('\u{2f8eb}', &['\u{6aa8}']), ('\u{2f8ec}', &['\u{236a3}']),
        ('\u{2f8ed}', &['\u{6adb}']), ('\u{2f8ee}', &['\u{3c18}']), ('\u{2f8ef}', &['\u{6b21}']),
        ('\u{2f8f0}', &['\u{238a7}']), ('\u{2f8f1}', &['\u{6b54}']), ('\u{2f8f2}', &['\u{3c4e}']),
        ('\u{2f8f3}', &['\u{6b72}']), ('\u{2f8f4}', &['\u{6b9f}']), ('\u{2f8f5}', &['\u{6bba}']),
        ('\u{2f8f6}', &['\u{6bbb}']), ('\u{2f8f7}', &['\u{23a8d}']), ('\u{2f8f8}', &['\u{21d0b}']),
        ('\u{2f8f9}', &['\u{23afa}']), ('\u{2f8fa}', &['\u{6c4e}']), ('\u{2f8fb}', &['\u{23cbc}']),
        ('\u{2f8fc}', &['\u{6cbf}']), ('\u{2f8fd}', &['\u{6ccd}']), ('\u{2f8fe}', &['\u{6c67}']),
        ('\u{2f8ff}', &['\u{6d16}']), ('\u{2f900}', &['\u{6d3e}']), ('\u{2f901}', &['\u{6d77}']),
        ('\u{2f902}', &['\u{6d41}']), ('\u{2f903}', &['\u{6d69}']), ('\u{2f904}', &['\u{6d78}']),
        ('\u{2f905}', &['\u{6d85}']), ('\u{2f906}', &['\u{23d1e}']), ('\u{2f907}', &['\u{6d34}']),
        ('\u{2f908}', &['\u{6e2f}']), ('\u{2f909}', &['\u{6e6e}']), ('\u{2f90a}', &['\u{3d33}']),
        ('\u{2f90b}', &['\u{6ecb}']), ('\u{2f90c}', &['\u{6ec7}']), ('\u{2f90d}', &['\u{23ed1}']),
        ('\u{2f90e}', &['\u{6df9}']), ('\u{2f90f}', &['\u{6f6e}']), ('\u{2f910}', &['\u{23f5e}']),
        ('\u{2f911}', &['\u{23f8e}']), ('\u{2f912}', &['\u{6fc6}']), ('\u{2f913}', &['\u{7039}']),
        ('\u{2f914}', &['\u{701e}']), ('\u{2f915}', &['\u{701b}']), ('\u{2f916}', &['\u{3d96}']),
        ('\u{2f917}', &['\u{704a}']), ('\u{2f918}', &['\u{707d}']), ('\u{2f919}', &['\u{7077}']),
        ('\u{2f91a}', &['\u{70ad}']), ('\u{2f91b}', &['\u{20525}']), ('\u{2f91c}', &['\u{7145}']),
        ('\u{2f91d}', &['\u{24263}']), ('\u{2f91e}', &['\u{719c}']), ('\u{2f91f}', &['\u{243ab}']),
        ('\u{2f920}', &['\u{7228}']), ('\u{2f921}', &['\u{7235}']), ('\u{2f922}', &['\u{7250}']),
        ('\u{2f923}', &['\u{24608}']), ('\u{2f924}', &['\u{7280}']), ('\u{2f925}', &['\u{7295}']),
        ('\u{2f926}', &['\u{24735}']), ('\u{2f927}', &['\u{24814}']), ('\u{2f928}', &['\u{737a}']),
        ('\u{2f929}', &['\u{738b}']), ('\u{2f92a}', &['\u{3eac}']), ('\u{2f92b}', &['\u{73a5}']),
        ('\u{2f92c}', &['\u{3eb8}']), ('\u{2f92d}', &['\u{3eb8}']), ('\u{2f92e}', &['\u{7447}']),
        ('\u{2f92f}', &['\u{745c}']), ('\u{2f930}', &['\u{7471}']), ('\u{2f931}', &['\u{7485}']),
        ('\u{2f932}', &['\u{74ca}']), ('\u{2f933}', &['\u{3f1b}']), ('\u{2f934}', &['\u{7524}']),
        ('\u{2f935}', &['\u{24c36}']), ('\u{2f936}', &['\u{753e}']), ('\u{2f937}', &['\u{24c92}']),
        ('\u{2f938}', &['\u{7570}']), ('\u{2f939}', &['\u{2219f}']), ('\u{2f93a}', &['\u{7610}']),
        ('\u{2f93b}', &['\u{24fa1}']), ('\u{2f93c}', &['\u{24fb8}']), ('\u{2f93d}', &['\u{25044}']),
        ('\u{2f93e}', &['\u{3ffc}']), ('\u{2f93f}', &['\u{4008}']), ('\u{2f940}', &['\u{76f4}']),
        ('\u{2f941}', &['\u{250f3}']), ('\u{2f942}', &['\u{250f2}']), ('\u{2f943}', &['\u{25119}']),
        ('\u{2f944}', &['\u{25133}']), ('\u{2f945}', &['\u{771e}']), ('\u{2f946}', &['\u{771f}']),
        ('\u{2f947}', &['\u{771f}']), ('\u{2f948}', &['\u{774a}']), ('\u{2f949}', &['\u{4039}']),
        ('\u{2f94a}', &['\u{778b}']), ('\u{2f94b}', &['\u{4046}']), ('\u{2f94c}', &['\u{4096}']),
        ('\u{2f94d}', &['\u{2541d}']), ('\u{2f94e}', &['\u{784e}']), ('\u{2f94f}', &['\u{788c}']),
        ('\u{2f950}', &['\u{78cc}']), ('\u{2f951}', &['\u{40e3}']), ('\u{2f952}', &['\u{25626}']),
        ('\u{2f953}', &['\u{7956}']), ('\u{2f954}', &['\u{2569a}']), ('\u{2f955}', &['\u{256c5}']),
        ('\u{2f956}', &['\u{798f}']), ('\u{2f957}', &['\u{79eb}']), ('\u{2f958}', &['\u{412f}']),
        ('\u{2f959}', &['\u{7a40}']), ('\u{2f95a}', &['\u{7a4a}']), ('\u{2f95b}', &['\u{7a4f}']),
        ('\u{2f95c}', &['\u{2597c}']), ('\u{2f95d}', &['\u{25aa7}']), ('\u{2f95e}', &['\u{25aa7}']),
        ('\u{2f95f}', &['\u{7aee}']), ('\u{2f960}', &['\u{4202}']), ('\u{2f961}', &['\u{25bab}']),
        ('\u{2f962}', &['\u{7bc6}']), ('\u{2f963}', &['\u{7bc9}']), ('\u{2f964}', &['\u{4227}']),
        ('\u{2f965}', &['\u{25c80}']), ('\u{2f966}', &['\u{7cd2}']), ('\u{2f967}', &['\u{42a0}']),
        ('\u{2f968}', &['\u{7ce8}']), ('\u{2f969}', &['\u{7ce3}']), ('\u{2f96a}', &['\u{7d00}']),
        ('\u{2f96b}', &['\u{25f86}']), ('\u{2f96c}', &['\u{7d63}']), ('\u{2f96d}', &['\u{4301}']),
        ('\u{2f96e}', &['\u{7dc7}']), ('\u{2f96f}', &['\u{7e02}']), ('\u{2f970}', &['\u{7e45}']),
        ('\u{2f971}', &['\u{4334}']), ('\u{2f972}', &['\u{26228}']), ('\u{2f973}', &['\u{26247}']),
        ('\u{2f974}', &['\u{4359}']), ('\u{2f975}', &['\u{262d9}']), ('\u{2f976}', &['\u{7f7a}']),
        ('\u{2f977}', &['\u{2633e}']), ('\u{2f978}', &['\u{7f95}']), ('\u{2f979}', &['\u{7ffa}']),
        ('\u{2f97a}', &['\u{8005}']), ('\u{2f97b}', &['\u{264da}']), ('\u{2f97c}', &['\u{26523}']),
        ('\u{2f97d}', &['\u{8060}']), ('\u{2f97e}', &['\u{265a8}']), ('\u{2f97f}', &['\u{8070}']),
        ('\u{2f980}', &['\u{2335f}']), ('\u{2f981}', &['\u{43d5}']), ('\u{2f982}', &['\u{80b2}']),
        ('\u{2f983}', &['\u{8103}']), ('\u{2f984}', &['\u{440b}']), ('\u{2f985}', &['\u{813e}']),
        ('\u{2f986}', &['\u{5ab5}']), ('\u{2f987}', &['\u{267a7}']), ('\u{2f988}', &['\u{267b5}']),
        ('\u{2f989}', &['\u{23393}']), ('\u{2f98a}', &['\u{2339c}']), ('\u{2f98b}', &['\u{8201}']),
        ('\u{2f98c}', &['\u{8204}']), ('\u{2f98d}', &['\u{8f9e}']), ('\u{2f98e}', &['\u{446b}']),
        ('\u{2f98f}', &['\u{8291}']), ('\u{2f990}', &['\u{828b}']), ('\u{2f991}', &['\u{829d}']),
        ('\u{2f992}', &['\u{52b3}']), ('\u{2f993}', &['\u{82b1}']), ('\u{2f994}', &['\u{82b3}']),
        ('\u{2f995}', &['\u{82bd}']), ('\u{2f996}', &['\u{82e6}']), ('\u{2f997}', &['\u{26b3c}']),
        ('\u{2f998}', &['\u{82e5}']), ('\u{2f999}', &['\u{831d}']), ('\u{2f99a}', &['\u{8363}']),
        ('\u{2f99b}', &['\u{83ad}']), ('\u{2f99c}', &['\u{8323}']), ('\u{2f99d}', &['\u{83bd}']),
        ('\u{2f99e}', &['\u{83e7}']), ('\u{2f99f}', &['\u{8457}']), ('\u{2f9a0}', &['\u{8353}']),
        ('\u{2f9a1}', &['\u{83ca}']), ('\u{2f9a2}', &['\u{83cc}']), ('\u{2f9a3}', &['\u{83dc}']),
        ('\u{2f9a4}', &['\u{26c36}']), ('\u{2f9a5}', &['\u{26d6b}']), ('\u{2f9a6}', &['\u{26cd5}']),
        ('\u{2f9a7}', &['\u{452b}']), ('\u{2f9a8}', &['\u{84f1}']), ('\u{2f9a9}', &['\u{84f3}']),
        ('\u{2f9aa}', &['\u{8516}']), ('\u{2f9ab}', &['\u{273ca}']), ('\u{2f9ac}', &['\u{8564}']),
        ('\u{2f9ad}', &['\u{26f2c}']), ('\u{2f9ae}', &['\u{455d}']), ('\u{2f9af}', &['\u{4561}']),
        ('\u{2f9b0}', &['\u{26fb1}']), ('\u{2f9b1}', &['\u{270d2}']), ('\u{2f9b2}', &['\u{456b}']),
        ('\u{2f9b3}', &['\u{8650}']), ('\u{2f9b4}', &['\u{865c}']), ('\u{2f9b5}', &['\u{8667}']),
        ('\u{2f9b6}', &['\u{8669}']), ('\u{2f9b7}', &['\u{86a9}']), ('\u{2f9b8}', &['\u{8688}']),
        ('\u{2f9b9}', &['\u{870e}']), ('\u{2f9ba}', &['\u{86e2}']), ('\u{2f9bb}', &['\u{8779}']),
        ('\u{2f9bc}', &['\u{8728}']), ('\u{2f9bd}', &['\u{876b}']), ('\u{2f9be}', &['\u{8786}']),
        ('\u{2f9bf}', &['\u{45d7}']), ('\u{2f9c0}', &['\u{87e1}']), ('\u{2f9c1}', &['\u{8801}']),
        ('\u{2f9c2}', &['\u{45f9}']), ('\u{2f9c3}', &['\u{8860}']), ('\u{2f9c4}', &['\u{8863}']),
        ('\u{2f9c5}', &['\u{27667}']), ('\u{2f9c6}', &['\u{88d7}']), ('\u{2f9c7}', &['\u{88de}']),
        ('\u{2f9c8}', &['\u{4635}']), ('\u{2f9c9}', &['\u{88fa}']), ('\u{2f9ca}', &['\u{34bb}']),
        ('\u{2f9cb}', &['\u{278ae}']), ('\u{2f9cc}', &['\u{27966}']), ('\u{2f9cd}', &['\u{46be}']),
        ('\u{2f9ce}', &['\u{46c7}']), ('\u{2f9cf}', &['\u{8aa0}']), ('\u{2f9d0}', &['\u{8aed}']),
        ('\u{2f9d1}', &['\u{8b8a}']), ('\u{2f9d2}', &['\u{8c55}']), ('\u{2f9d3}', &['\u{27ca8}']),
        ('\u{2f9d4}', &['\u{8cab}']), ('\u{2f9d5}', &['\u{8cc1}']), ('\u{2f9d6}', &['\u{8d1b}']),
        ('\u{2f9d7}', &['\u{8d77}']), ('\u{2f9d8}', &['\u{27f2f}']), ('\u{2f9d9}', &['\u{20804}']),
        ('\u{2f9da}', &['\u{8dcb}']), ('\u{2f9db}', &['\u{8dbc}']), ('\u{2f9dc}', &['\u{8df0}']),
        ('\u{2f9dd}', &['\u{208de}']), ('\u{2f9de}', &['\u{8ed4}']), ('\u{2f9df}', &['\u{8f38}']),
        ('\u{2f9e0}', &['\u{285d2}']), ('\u{2f9e1}', &['\u{285ed}']), ('\u{2f9e2}', &['\u{9094}']),
        ('\u{2f9e3}', &['\u{90f1}']), ('\u{2f9e4}', &['\u{9111}']), ('\u{2f9e5}', &['\u{2872e}']),
        ('\u{2f9e6}', &['\u{911b}']), ('\u{2f9e7}', &['\u{9238}']), ('\u{2f9e8}', &['\u{92d7}']),
        ('\u{2f9e9}', &['\u{92d8}']), ('\u{2f9ea}', &['\u{927c}']), ('\u{2f9eb}', &['\u{93f9}']),
        ('\u{2f9ec}', &['\u{9415}']), ('\u{2f9ed}', &['\u{28bfa}']), ('\u{2f9ee}', &['\u{958b}']),
        ('\u{2f9ef}', &['\u{4995}']), ('\u{2f9f0}', &['\u{95b7}']), ('\u{2f9f1}', &['\u{28d77}']),
        ('\u{2f9f2}', &['\u{49e6}']), ('\u{2f9f3}', &['\u{96c3}']), ('\u{2f9f4}', &['\u{5db2}']),
        ('\u{2f9f5}', &['\u{9723}']), ('\u{2f9f6}', &['\u{29145}']), ('\u{2f9f7}', &['\u{2921a}']),
        ('\u{2f9f8}', &['\u{4a6e}']), ('\u{2f9f9}', &['\u{4a76}']), ('\u{2f9fa}', &['\u{97e0}']),
        ('\u{2f9fb}', &['\u{2940a}']), ('\u{2f9fc}', &['\u{4ab2}']), ('\u{2f9fd}', &['\u{29496}']),
        ('\u{2f9fe}', &['\u{980b}']), ('\u{2f9ff}', &['\u{980b}']), ('\u{2fa00}', &['\u{9829}']),
        ('\u{2fa01}', &['\u{295b6}']), ('\u{2fa02}', &['\u{98e2}']), ('\u{2fa03}', &['\u{4b33}']),
        ('\u{2fa04}', &['\u{9929}']), ('\u{2fa05}', &['\u{99a7}']), ('\u{2fa06}', &['\u{99c2}']),
        ('\u{2fa07}', &['\u{99fe}']), ('\u{2fa08}', &['\u{4bce}']), ('\u{2fa09}', &['\u{29b30}']),
        ('\u{2fa0a}', &['\u{9b12}']), ('\u{2fa0b}', &['\u{9c40}']), ('\u{2fa0c}', &['\u{9cfd}']),
        ('\u{2fa0d}', &['\u{4cce}']), ('\u{2fa0e}', &['\u{4ced}']), ('\u{2fa0f}', &['\u{9d67}']),
        ('\u{2fa10}', &['\u{2a0ce}']), ('\u{2fa11}', &['\u{4cf8}']), ('\u{2fa12}', &['\u{2a105}']),
        ('\u{2fa13}', &['\u{2a20e}']), ('\u{2fa14}', &['\u{2a291}']), ('\u{2fa15}', &['\u{9ebb}']),
        ('\u{2fa16}', &['\u{4d56}']), ('\u{2fa17}', &['\u{9ef9}']), ('\u{2fa18}', &['\u{9efe}']),
        ('\u{2fa19}', &['\u{9f05}']), ('\u{2fa1a}', &['\u{9f0f}']), ('\u{2fa1b}', &['\u{9f16}']),
        ('\u{2fa1c}', &['\u{9f3b}']), ('\u{2fa1d}', &['\u{2a600}'])
    ];

    // Compatibility decompositions
    pub static compatibility_table: &'static [(char, &'static [char])] = &[
        ('\u{a0}', &['\u{20}']), ('\u{a8}', &['\u{20}', '\u{308}']), ('\u{aa}', &['\u{61}']),
        ('\u{af}', &['\u{20}', '\u{304}']), ('\u{b2}', &['\u{32}']), ('\u{b3}', &['\u{33}']),
        ('\u{b4}', &['\u{20}', '\u{301}']), ('\u{b5}', &['\u{3bc}']), ('\u{b8}', &['\u{20}',
        '\u{327}']), ('\u{b9}', &['\u{31}']), ('\u{ba}', &['\u{6f}']), ('\u{bc}', &['\u{31}',
        '\u{2044}', '\u{34}']), ('\u{bd}', &['\u{31}', '\u{2044}', '\u{32}']), ('\u{be}',
        &['\u{33}', '\u{2044}', '\u{34}']), ('\u{132}', &['\u{49}', '\u{4a}']), ('\u{133}',
        &['\u{69}', '\u{6a}']), ('\u{13f}', &['\u{4c}', '\u{b7}']), ('\u{140}', &['\u{6c}',
        '\u{b7}']), ('\u{149}', &['\u{2bc}', '\u{6e}']), ('\u{17f}', &['\u{73}']), ('\u{1c4}',
        &['\u{44}', '\u{17d}']), ('\u{1c5}', &['\u{44}', '\u{17e}']), ('\u{1c6}', &['\u{64}',
        '\u{17e}']), ('\u{1c7}', &['\u{4c}', '\u{4a}']), ('\u{1c8}', &['\u{4c}', '\u{6a}']),
        ('\u{1c9}', &['\u{6c}', '\u{6a}']), ('\u{1ca}', &['\u{4e}', '\u{4a}']), ('\u{1cb}',
        &['\u{4e}', '\u{6a}']), ('\u{1cc}', &['\u{6e}', '\u{6a}']), ('\u{1f1}', &['\u{44}',
        '\u{5a}']), ('\u{1f2}', &['\u{44}', '\u{7a}']), ('\u{1f3}', &['\u{64}', '\u{7a}']),
        ('\u{2b0}', &['\u{68}']), ('\u{2b1}', &['\u{266}']), ('\u{2b2}', &['\u{6a}']), ('\u{2b3}',
        &['\u{72}']), ('\u{2b4}', &['\u{279}']), ('\u{2b5}', &['\u{27b}']), ('\u{2b6}',
        &['\u{281}']), ('\u{2b7}', &['\u{77}']), ('\u{2b8}', &['\u{79}']), ('\u{2d8}', &['\u{20}',
        '\u{306}']), ('\u{2d9}', &['\u{20}', '\u{307}']), ('\u{2da}', &['\u{20}', '\u{30a}']),
        ('\u{2db}', &['\u{20}', '\u{328}']), ('\u{2dc}', &['\u{20}', '\u{303}']), ('\u{2dd}',
        &['\u{20}', '\u{30b}']), ('\u{2e0}', &['\u{263}']), ('\u{2e1}', &['\u{6c}']), ('\u{2e2}',
        &['\u{73}']), ('\u{2e3}', &['\u{78}']), ('\u{2e4}', &['\u{295}']), ('\u{37a}', &['\u{20}',
        '\u{345}']), ('\u{384}', &['\u{20}', '\u{301}']), ('\u{3d0}', &['\u{3b2}']), ('\u{3d1}',
        &['\u{3b8}']), ('\u{3d2}', &['\u{3a5}']), ('\u{3d5}', &['\u{3c6}']), ('\u{3d6}',
        &['\u{3c0}']), ('\u{3f0}', &['\u{3ba}']), ('\u{3f1}', &['\u{3c1}']), ('\u{3f2}',
        &['\u{3c2}']), ('\u{3f4}', &['\u{398}']), ('\u{3f5}', &['\u{3b5}']), ('\u{3f9}',
        &['\u{3a3}']), ('\u{587}', &['\u{565}', '\u{582}']), ('\u{675}', &['\u{627}', '\u{674}']),
        ('\u{676}', &['\u{648}', '\u{674}']), ('\u{677}', &['\u{6c7}', '\u{674}']), ('\u{678}',
        &['\u{64a}', '\u{674}']), ('\u{e33}', &['\u{e4d}', '\u{e32}']), ('\u{eb3}', &['\u{ecd}',
        '\u{eb2}']), ('\u{edc}', &['\u{eab}', '\u{e99}']), ('\u{edd}', &['\u{eab}', '\u{ea1}']),
        ('\u{f0c}', &['\u{f0b}']), ('\u{f77}', &['\u{fb2}', '\u{f81}']), ('\u{f79}', &['\u{fb3}',
        '\u{f81}']), ('\u{10fc}', &['\u{10dc}']), ('\u{1d2c}', &['\u{41}']), ('\u{1d2d}',
        &['\u{c6}']), ('\u{1d2e}', &['\u{42}']), ('\u{1d30}', &['\u{44}']), ('\u{1d31}',
        &['\u{45}']), ('\u{1d32}', &['\u{18e}']), ('\u{1d33}', &['\u{47}']), ('\u{1d34}',
        &['\u{48}']), ('\u{1d35}', &['\u{49}']), ('\u{1d36}', &['\u{4a}']), ('\u{1d37}',
        &['\u{4b}']), ('\u{1d38}', &['\u{4c}']), ('\u{1d39}', &['\u{4d}']), ('\u{1d3a}',
        &['\u{4e}']), ('\u{1d3c}', &['\u{4f}']), ('\u{1d3d}', &['\u{222}']), ('\u{1d3e}',
        &['\u{50}']), ('\u{1d3f}', &['\u{52}']), ('\u{1d40}', &['\u{54}']), ('\u{1d41}',
        &['\u{55}']), ('\u{1d42}', &['\u{57}']), ('\u{1d43}', &['\u{61}']), ('\u{1d44}',
        &['\u{250}']), ('\u{1d45}', &['\u{251}']), ('\u{1d46}', &['\u{1d02}']), ('\u{1d47}',
        &['\u{62}']), ('\u{1d48}', &['\u{64}']), ('\u{1d49}', &['\u{65}']), ('\u{1d4a}',
        &['\u{259}']), ('\u{1d4b}', &['\u{25b}']), ('\u{1d4c}', &['\u{25c}']), ('\u{1d4d}',
        &['\u{67}']), ('\u{1d4f}', &['\u{6b}']), ('\u{1d50}', &['\u{6d}']), ('\u{1d51}',
        &['\u{14b}']), ('\u{1d52}', &['\u{6f}']), ('\u{1d53}', &['\u{254}']), ('\u{1d54}',
        &['\u{1d16}']), ('\u{1d55}', &['\u{1d17}']), ('\u{1d56}', &['\u{70}']), ('\u{1d57}',
        &['\u{74}']), ('\u{1d58}', &['\u{75}']), ('\u{1d59}', &['\u{1d1d}']), ('\u{1d5a}',
        &['\u{26f}']), ('\u{1d5b}', &['\u{76}']), ('\u{1d5c}', &['\u{1d25}']), ('\u{1d5d}',
        &['\u{3b2}']), ('\u{1d5e}', &['\u{3b3}']), ('\u{1d5f}', &['\u{3b4}']), ('\u{1d60}',
        &['\u{3c6}']), ('\u{1d61}', &['\u{3c7}']), ('\u{1d62}', &['\u{69}']), ('\u{1d63}',
        &['\u{72}']), ('\u{1d64}', &['\u{75}']), ('\u{1d65}', &['\u{76}']), ('\u{1d66}',
        &['\u{3b2}']), ('\u{1d67}', &['\u{3b3}']), ('\u{1d68}', &['\u{3c1}']), ('\u{1d69}',
        &['\u{3c6}']), ('\u{1d6a}', &['\u{3c7}']), ('\u{1d78}', &['\u{43d}']), ('\u{1d9b}',
        &['\u{252}']), ('\u{1d9c}', &['\u{63}']), ('\u{1d9d}', &['\u{255}']), ('\u{1d9e}',
        &['\u{f0}']), ('\u{1d9f}', &['\u{25c}']), ('\u{1da0}', &['\u{66}']), ('\u{1da1}',
        &['\u{25f}']), ('\u{1da2}', &['\u{261}']), ('\u{1da3}', &['\u{265}']), ('\u{1da4}',
        &['\u{268}']), ('\u{1da5}', &['\u{269}']), ('\u{1da6}', &['\u{26a}']), ('\u{1da7}',
        &['\u{1d7b}']), ('\u{1da8}', &['\u{29d}']), ('\u{1da9}', &['\u{26d}']), ('\u{1daa}',
        &['\u{1d85}']), ('\u{1dab}', &['\u{29f}']), ('\u{1dac}', &['\u{271}']), ('\u{1dad}',
        &['\u{270}']), ('\u{1dae}', &['\u{272}']), ('\u{1daf}', &['\u{273}']), ('\u{1db0}',
        &['\u{274}']), ('\u{1db1}', &['\u{275}']), ('\u{1db2}', &['\u{278}']), ('\u{1db3}',
        &['\u{282}']), ('\u{1db4}', &['\u{283}']), ('\u{1db5}', &['\u{1ab}']), ('\u{1db6}',
        &['\u{289}']), ('\u{1db7}', &['\u{28a}']), ('\u{1db8}', &['\u{1d1c}']), ('\u{1db9}',
        &['\u{28b}']), ('\u{1dba}', &['\u{28c}']), ('\u{1dbb}', &['\u{7a}']), ('\u{1dbc}',
        &['\u{290}']), ('\u{1dbd}', &['\u{291}']), ('\u{1dbe}', &['\u{292}']), ('\u{1dbf}',
        &['\u{3b8}']), ('\u{1e9a}', &['\u{61}', '\u{2be}']), ('\u{1fbd}', &['\u{20}', '\u{313}']),
        ('\u{1fbf}', &['\u{20}', '\u{313}']), ('\u{1fc0}', &['\u{20}', '\u{342}']), ('\u{1ffe}',
        &['\u{20}', '\u{314}']), ('\u{2002}', &['\u{20}']), ('\u{2003}', &['\u{20}']), ('\u{2004}',
        &['\u{20}']), ('\u{2005}', &['\u{20}']), ('\u{2006}', &['\u{20}']), ('\u{2007}',
        &['\u{20}']), ('\u{2008}', &['\u{20}']), ('\u{2009}', &['\u{20}']), ('\u{200a}',
        &['\u{20}']), ('\u{2011}', &['\u{2010}']), ('\u{2017}', &['\u{20}', '\u{333}']),
        ('\u{2024}', &['\u{2e}']), ('\u{2025}', &['\u{2e}', '\u{2e}']), ('\u{2026}', &['\u{2e}',
        '\u{2e}', '\u{2e}']), ('\u{202f}', &['\u{20}']), ('\u{2033}', &['\u{2032}', '\u{2032}']),
        ('\u{2034}', &['\u{2032}', '\u{2032}', '\u{2032}']), ('\u{2036}', &['\u{2035}',
        '\u{2035}']), ('\u{2037}', &['\u{2035}', '\u{2035}', '\u{2035}']), ('\u{203c}', &['\u{21}',
        '\u{21}']), ('\u{203e}', &['\u{20}', '\u{305}']), ('\u{2047}', &['\u{3f}', '\u{3f}']),
        ('\u{2048}', &['\u{3f}', '\u{21}']), ('\u{2049}', &['\u{21}', '\u{3f}']), ('\u{2057}',
        &['\u{2032}', '\u{2032}', '\u{2032}', '\u{2032}']), ('\u{205f}', &['\u{20}']), ('\u{2070}',
        &['\u{30}']), ('\u{2071}', &['\u{69}']), ('\u{2074}', &['\u{34}']), ('\u{2075}',
        &['\u{35}']), ('\u{2076}', &['\u{36}']), ('\u{2077}', &['\u{37}']), ('\u{2078}',
        &['\u{38}']), ('\u{2079}', &['\u{39}']), ('\u{207a}', &['\u{2b}']), ('\u{207b}',
        &['\u{2212}']), ('\u{207c}', &['\u{3d}']), ('\u{207d}', &['\u{28}']), ('\u{207e}',
        &['\u{29}']), ('\u{207f}', &['\u{6e}']), ('\u{2080}', &['\u{30}']), ('\u{2081}',
        &['\u{31}']), ('\u{2082}', &['\u{32}']), ('\u{2083}', &['\u{33}']), ('\u{2084}',
        &['\u{34}']), ('\u{2085}', &['\u{35}']), ('\u{2086}', &['\u{36}']), ('\u{2087}',
        &['\u{37}']), ('\u{2088}', &['\u{38}']), ('\u{2089}', &['\u{39}']), ('\u{208a}',
        &['\u{2b}']), ('\u{208b}', &['\u{2212}']), ('\u{208c}', &['\u{3d}']), ('\u{208d}',
        &['\u{28}']), ('\u{208e}', &['\u{29}']), ('\u{2090}', &['\u{61}']), ('\u{2091}',
        &['\u{65}']), ('\u{2092}', &['\u{6f}']), ('\u{2093}', &['\u{78}']), ('\u{2094}',
        &['\u{259}']), ('\u{2095}', &['\u{68}']), ('\u{2096}', &['\u{6b}']), ('\u{2097}',
        &['\u{6c}']), ('\u{2098}', &['\u{6d}']), ('\u{2099}', &['\u{6e}']), ('\u{209a}',
        &['\u{70}']), ('\u{209b}', &['\u{73}']), ('\u{209c}', &['\u{74}']), ('\u{20a8}', &['\u{52}',
        '\u{73}']), ('\u{2100}', &['\u{61}', '\u{2f}', '\u{63}']), ('\u{2101}', &['\u{61}',
        '\u{2f}', '\u{73}']), ('\u{2102}', &['\u{43}']), ('\u{2103}', &['\u{b0}', '\u{43}']),
        ('\u{2105}', &['\u{63}', '\u{2f}', '\u{6f}']), ('\u{2106}', &['\u{63}', '\u{2f}',
        '\u{75}']), ('\u{2107}', &['\u{190}']), ('\u{2109}', &['\u{b0}', '\u{46}']), ('\u{210a}',
        &['\u{67}']), ('\u{210b}', &['\u{48}']), ('\u{210c}', &['\u{48}']), ('\u{210d}',
        &['\u{48}']), ('\u{210e}', &['\u{68}']), ('\u{210f}', &['\u{127}']), ('\u{2110}',
        &['\u{49}']), ('\u{2111}', &['\u{49}']), ('\u{2112}', &['\u{4c}']), ('\u{2113}',
        &['\u{6c}']), ('\u{2115}', &['\u{4e}']), ('\u{2116}', &['\u{4e}', '\u{6f}']), ('\u{2119}',
        &['\u{50}']), ('\u{211a}', &['\u{51}']), ('\u{211b}', &['\u{52}']), ('\u{211c}',
        &['\u{52}']), ('\u{211d}', &['\u{52}']), ('\u{2120}', &['\u{53}', '\u{4d}']), ('\u{2121}',
        &['\u{54}', '\u{45}', '\u{4c}']), ('\u{2122}', &['\u{54}', '\u{4d}']), ('\u{2124}',
        &['\u{5a}']), ('\u{2128}', &['\u{5a}']), ('\u{212c}', &['\u{42}']), ('\u{212d}',
        &['\u{43}']), ('\u{212f}', &['\u{65}']), ('\u{2130}', &['\u{45}']), ('\u{2131}',
        &['\u{46}']), ('\u{2133}', &['\u{4d}']), ('\u{2134}', &['\u{6f}']), ('\u{2135}',
        &['\u{5d0}']), ('\u{2136}', &['\u{5d1}']), ('\u{2137}', &['\u{5d2}']), ('\u{2138}',
        &['\u{5d3}']), ('\u{2139}', &['\u{69}']), ('\u{213b}', &['\u{46}', '\u{41}', '\u{58}']),
        ('\u{213c}', &['\u{3c0}']), ('\u{213d}', &['\u{3b3}']), ('\u{213e}', &['\u{393}']),
        ('\u{213f}', &['\u{3a0}']), ('\u{2140}', &['\u{2211}']), ('\u{2145}', &['\u{44}']),
        ('\u{2146}', &['\u{64}']), ('\u{2147}', &['\u{65}']), ('\u{2148}', &['\u{69}']),
        ('\u{2149}', &['\u{6a}']), ('\u{2150}', &['\u{31}', '\u{2044}', '\u{37}']), ('\u{2151}',
        &['\u{31}', '\u{2044}', '\u{39}']), ('\u{2152}', &['\u{31}', '\u{2044}', '\u{31}',
        '\u{30}']), ('\u{2153}', &['\u{31}', '\u{2044}', '\u{33}']), ('\u{2154}', &['\u{32}',
        '\u{2044}', '\u{33}']), ('\u{2155}', &['\u{31}', '\u{2044}', '\u{35}']), ('\u{2156}',
        &['\u{32}', '\u{2044}', '\u{35}']), ('\u{2157}', &['\u{33}', '\u{2044}', '\u{35}']),
        ('\u{2158}', &['\u{34}', '\u{2044}', '\u{35}']), ('\u{2159}', &['\u{31}', '\u{2044}',
        '\u{36}']), ('\u{215a}', &['\u{35}', '\u{2044}', '\u{36}']), ('\u{215b}', &['\u{31}',
        '\u{2044}', '\u{38}']), ('\u{215c}', &['\u{33}', '\u{2044}', '\u{38}']), ('\u{215d}',
        &['\u{35}', '\u{2044}', '\u{38}']), ('\u{215e}', &['\u{37}', '\u{2044}', '\u{38}']),
        ('\u{215f}', &['\u{31}', '\u{2044}']), ('\u{2160}', &['\u{49}']), ('\u{2161}', &['\u{49}',
        '\u{49}']), ('\u{2162}', &['\u{49}', '\u{49}', '\u{49}']), ('\u{2163}', &['\u{49}',
        '\u{56}']), ('\u{2164}', &['\u{56}']), ('\u{2165}', &['\u{56}', '\u{49}']), ('\u{2166}',
        &['\u{56}', '\u{49}', '\u{49}']), ('\u{2167}', &['\u{56}', '\u{49}', '\u{49}', '\u{49}']),
        ('\u{2168}', &['\u{49}', '\u{58}']), ('\u{2169}', &['\u{58}']), ('\u{216a}', &['\u{58}',
        '\u{49}']), ('\u{216b}', &['\u{58}', '\u{49}', '\u{49}']), ('\u{216c}', &['\u{4c}']),
        ('\u{216d}', &['\u{43}']), ('\u{216e}', &['\u{44}']), ('\u{216f}', &['\u{4d}']),
        ('\u{2170}', &['\u{69}']), ('\u{2171}', &['\u{69}', '\u{69}']), ('\u{2172}', &['\u{69}',
        '\u{69}', '\u{69}']), ('\u{2173}', &['\u{69}', '\u{76}']), ('\u{2174}', &['\u{76}']),
        ('\u{2175}', &['\u{76}', '\u{69}']), ('\u{2176}', &['\u{76}', '\u{69}', '\u{69}']),
        ('\u{2177}', &['\u{76}', '\u{69}', '\u{69}', '\u{69}']), ('\u{2178}', &['\u{69}',
        '\u{78}']), ('\u{2179}', &['\u{78}']), ('\u{217a}', &['\u{78}', '\u{69}']), ('\u{217b}',
        &['\u{78}', '\u{69}', '\u{69}']), ('\u{217c}', &['\u{6c}']), ('\u{217d}', &['\u{63}']),
        ('\u{217e}', &['\u{64}']), ('\u{217f}', &['\u{6d}']), ('\u{2189}', &['\u{30}', '\u{2044}',
        '\u{33}']), ('\u{222c}', &['\u{222b}', '\u{222b}']), ('\u{222d}', &['\u{222b}', '\u{222b}',
        '\u{222b}']), ('\u{222f}', &['\u{222e}', '\u{222e}']), ('\u{2230}', &['\u{222e}',
        '\u{222e}', '\u{222e}']), ('\u{2460}', &['\u{31}']), ('\u{2461}', &['\u{32}']), ('\u{2462}',
        &['\u{33}']), ('\u{2463}', &['\u{34}']), ('\u{2464}', &['\u{35}']), ('\u{2465}',
        &['\u{36}']), ('\u{2466}', &['\u{37}']), ('\u{2467}', &['\u{38}']), ('\u{2468}',
        &['\u{39}']), ('\u{2469}', &['\u{31}', '\u{30}']), ('\u{246a}', &['\u{31}', '\u{31}']),
        ('\u{246b}', &['\u{31}', '\u{32}']), ('\u{246c}', &['\u{31}', '\u{33}']), ('\u{246d}',
        &['\u{31}', '\u{34}']), ('\u{246e}', &['\u{31}', '\u{35}']), ('\u{246f}', &['\u{31}',
        '\u{36}']), ('\u{2470}', &['\u{31}', '\u{37}']), ('\u{2471}', &['\u{31}', '\u{38}']),
        ('\u{2472}', &['\u{31}', '\u{39}']), ('\u{2473}', &['\u{32}', '\u{30}']), ('\u{2474}',
        &['\u{28}', '\u{31}', '\u{29}']), ('\u{2475}', &['\u{28}', '\u{32}', '\u{29}']),
        ('\u{2476}', &['\u{28}', '\u{33}', '\u{29}']), ('\u{2477}', &['\u{28}', '\u{34}',
        '\u{29}']), ('\u{2478}', &['\u{28}', '\u{35}', '\u{29}']), ('\u{2479}', &['\u{28}',
        '\u{36}', '\u{29}']), ('\u{247a}', &['\u{28}', '\u{37}', '\u{29}']), ('\u{247b}',
        &['\u{28}', '\u{38}', '\u{29}']), ('\u{247c}', &['\u{28}', '\u{39}', '\u{29}']),
        ('\u{247d}', &['\u{28}', '\u{31}', '\u{30}', '\u{29}']), ('\u{247e}', &['\u{28}', '\u{31}',
        '\u{31}', '\u{29}']), ('\u{247f}', &['\u{28}', '\u{31}', '\u{32}', '\u{29}']), ('\u{2480}',
        &['\u{28}', '\u{31}', '\u{33}', '\u{29}']), ('\u{2481}', &['\u{28}', '\u{31}', '\u{34}',
        '\u{29}']), ('\u{2482}', &['\u{28}', '\u{31}', '\u{35}', '\u{29}']), ('\u{2483}',
        &['\u{28}', '\u{31}', '\u{36}', '\u{29}']), ('\u{2484}', &['\u{28}', '\u{31}', '\u{37}',
        '\u{29}']), ('\u{2485}', &['\u{28}', '\u{31}', '\u{38}', '\u{29}']), ('\u{2486}',
        &['\u{28}', '\u{31}', '\u{39}', '\u{29}']), ('\u{2487}', &['\u{28}', '\u{32}', '\u{30}',
        '\u{29}']), ('\u{2488}', &['\u{31}', '\u{2e}']), ('\u{2489}', &['\u{32}', '\u{2e}']),
        ('\u{248a}', &['\u{33}', '\u{2e}']), ('\u{248b}', &['\u{34}', '\u{2e}']), ('\u{248c}',
        &['\u{35}', '\u{2e}']), ('\u{248d}', &['\u{36}', '\u{2e}']), ('\u{248e}', &['\u{37}',
        '\u{2e}']), ('\u{248f}', &['\u{38}', '\u{2e}']), ('\u{2490}', &['\u{39}', '\u{2e}']),
        ('\u{2491}', &['\u{31}', '\u{30}', '\u{2e}']), ('\u{2492}', &['\u{31}', '\u{31}',
        '\u{2e}']), ('\u{2493}', &['\u{31}', '\u{32}', '\u{2e}']), ('\u{2494}', &['\u{31}',
        '\u{33}', '\u{2e}']), ('\u{2495}', &['\u{31}', '\u{34}', '\u{2e}']), ('\u{2496}',
        &['\u{31}', '\u{35}', '\u{2e}']), ('\u{2497}', &['\u{31}', '\u{36}', '\u{2e}']),
        ('\u{2498}', &['\u{31}', '\u{37}', '\u{2e}']), ('\u{2499}', &['\u{31}', '\u{38}',
        '\u{2e}']), ('\u{249a}', &['\u{31}', '\u{39}', '\u{2e}']), ('\u{249b}', &['\u{32}',
        '\u{30}', '\u{2e}']), ('\u{249c}', &['\u{28}', '\u{61}', '\u{29}']), ('\u{249d}',
        &['\u{28}', '\u{62}', '\u{29}']), ('\u{249e}', &['\u{28}', '\u{63}', '\u{29}']),
        ('\u{249f}', &['\u{28}', '\u{64}', '\u{29}']), ('\u{24a0}', &['\u{28}', '\u{65}',
        '\u{29}']), ('\u{24a1}', &['\u{28}', '\u{66}', '\u{29}']), ('\u{24a2}', &['\u{28}',
        '\u{67}', '\u{29}']), ('\u{24a3}', &['\u{28}', '\u{68}', '\u{29}']), ('\u{24a4}',
        &['\u{28}', '\u{69}', '\u{29}']), ('\u{24a5}', &['\u{28}', '\u{6a}', '\u{29}']),
        ('\u{24a6}', &['\u{28}', '\u{6b}', '\u{29}']), ('\u{24a7}', &['\u{28}', '\u{6c}',
        '\u{29}']), ('\u{24a8}', &['\u{28}', '\u{6d}', '\u{29}']), ('\u{24a9}', &['\u{28}',
        '\u{6e}', '\u{29}']), ('\u{24aa}', &['\u{28}', '\u{6f}', '\u{29}']), ('\u{24ab}',
        &['\u{28}', '\u{70}', '\u{29}']), ('\u{24ac}', &['\u{28}', '\u{71}', '\u{29}']),
        ('\u{24ad}', &['\u{28}', '\u{72}', '\u{29}']), ('\u{24ae}', &['\u{28}', '\u{73}',
        '\u{29}']), ('\u{24af}', &['\u{28}', '\u{74}', '\u{29}']), ('\u{24b0}', &['\u{28}',
        '\u{75}', '\u{29}']), ('\u{24b1}', &['\u{28}', '\u{76}', '\u{29}']), ('\u{24b2}',
        &['\u{28}', '\u{77}', '\u{29}']), ('\u{24b3}', &['\u{28}', '\u{78}', '\u{29}']),
        ('\u{24b4}', &['\u{28}', '\u{79}', '\u{29}']), ('\u{24b5}', &['\u{28}', '\u{7a}',
        '\u{29}']), ('\u{24b6}', &['\u{41}']), ('\u{24b7}', &['\u{42}']), ('\u{24b8}', &['\u{43}']),
        ('\u{24b9}', &['\u{44}']), ('\u{24ba}', &['\u{45}']), ('\u{24bb}', &['\u{46}']),
        ('\u{24bc}', &['\u{47}']), ('\u{24bd}', &['\u{48}']), ('\u{24be}', &['\u{49}']),
        ('\u{24bf}', &['\u{4a}']), ('\u{24c0}', &['\u{4b}']), ('\u{24c1}', &['\u{4c}']),
        ('\u{24c2}', &['\u{4d}']), ('\u{24c3}', &['\u{4e}']), ('\u{24c4}', &['\u{4f}']),
        ('\u{24c5}', &['\u{50}']), ('\u{24c6}', &['\u{51}']), ('\u{24c7}', &['\u{52}']),
        ('\u{24c8}', &['\u{53}']), ('\u{24c9}', &['\u{54}']), ('\u{24ca}', &['\u{55}']),
        ('\u{24cb}', &['\u{56}']), ('\u{24cc}', &['\u{57}']), ('\u{24cd}', &['\u{58}']),
        ('\u{24ce}', &['\u{59}']), ('\u{24cf}', &['\u{5a}']), ('\u{24d0}', &['\u{61}']),
        ('\u{24d1}', &['\u{62}']), ('\u{24d2}', &['\u{63}']), ('\u{24d3}', &['\u{64}']),
        ('\u{24d4}', &['\u{65}']), ('\u{24d5}', &['\u{66}']), ('\u{24d6}', &['\u{67}']),
        ('\u{24d7}', &['\u{68}']), ('\u{24d8}', &['\u{69}']), ('\u{24d9}', &['\u{6a}']),
        ('\u{24da}', &['\u{6b}']), ('\u{24db}', &['\u{6c}']), ('\u{24dc}', &['\u{6d}']),
        ('\u{24dd}', &['\u{6e}']), ('\u{24de}', &['\u{6f}']), ('\u{24df}', &['\u{70}']),
        ('\u{24e0}', &['\u{71}']), ('\u{24e1}', &['\u{72}']), ('\u{24e2}', &['\u{73}']),
        ('\u{24e3}', &['\u{74}']), ('\u{24e4}', &['\u{75}']), ('\u{24e5}', &['\u{76}']),
        ('\u{24e6}', &['\u{77}']), ('\u{24e7}', &['\u{78}']), ('\u{24e8}', &['\u{79}']),
        ('\u{24e9}', &['\u{7a}']), ('\u{24ea}', &['\u{30}']), ('\u{2a0c}', &['\u{222b}', '\u{222b}',
        '\u{222b}', '\u{222b}']), ('\u{2a74}', &['\u{3a}', '\u{3a}', '\u{3d}']), ('\u{2a75}',
        &['\u{3d}', '\u{3d}']), ('\u{2a76}', &['\u{3d}', '\u{3d}', '\u{3d}']), ('\u{2c7c}',
        &['\u{6a}']), ('\u{2c7d}', &['\u{56}']), ('\u{2d6f}', &['\u{2d61}']), ('\u{2e9f}',
        &['\u{6bcd}']), ('\u{2ef3}', &['\u{9f9f}']), ('\u{2f00}', &['\u{4e00}']), ('\u{2f01}',
        &['\u{4e28}']), ('\u{2f02}', &['\u{4e36}']), ('\u{2f03}', &['\u{4e3f}']), ('\u{2f04}',
        &['\u{4e59}']), ('\u{2f05}', &['\u{4e85}']), ('\u{2f06}', &['\u{4e8c}']), ('\u{2f07}',
        &['\u{4ea0}']), ('\u{2f08}', &['\u{4eba}']), ('\u{2f09}', &['\u{513f}']), ('\u{2f0a}',
        &['\u{5165}']), ('\u{2f0b}', &['\u{516b}']), ('\u{2f0c}', &['\u{5182}']), ('\u{2f0d}',
        &['\u{5196}']), ('\u{2f0e}', &['\u{51ab}']), ('\u{2f0f}', &['\u{51e0}']), ('\u{2f10}',
        &['\u{51f5}']), ('\u{2f11}', &['\u{5200}']), ('\u{2f12}', &['\u{529b}']), ('\u{2f13}',
        &['\u{52f9}']), ('\u{2f14}', &['\u{5315}']), ('\u{2f15}', &['\u{531a}']), ('\u{2f16}',
        &['\u{5338}']), ('\u{2f17}', &['\u{5341}']), ('\u{2f18}', &['\u{535c}']), ('\u{2f19}',
        &['\u{5369}']), ('\u{2f1a}', &['\u{5382}']), ('\u{2f1b}', &['\u{53b6}']), ('\u{2f1c}',
        &['\u{53c8}']), ('\u{2f1d}', &['\u{53e3}']), ('\u{2f1e}', &['\u{56d7}']), ('\u{2f1f}',
        &['\u{571f}']), ('\u{2f20}', &['\u{58eb}']), ('\u{2f21}', &['\u{5902}']), ('\u{2f22}',
        &['\u{590a}']), ('\u{2f23}', &['\u{5915}']), ('\u{2f24}', &['\u{5927}']), ('\u{2f25}',
        &['\u{5973}']), ('\u{2f26}', &['\u{5b50}']), ('\u{2f27}', &['\u{5b80}']), ('\u{2f28}',
        &['\u{5bf8}']), ('\u{2f29}', &['\u{5c0f}']), ('\u{2f2a}', &['\u{5c22}']), ('\u{2f2b}',
        &['\u{5c38}']), ('\u{2f2c}', &['\u{5c6e}']), ('\u{2f2d}', &['\u{5c71}']), ('\u{2f2e}',
        &['\u{5ddb}']), ('\u{2f2f}', &['\u{5de5}']), ('\u{2f30}', &['\u{5df1}']), ('\u{2f31}',
        &['\u{5dfe}']), ('\u{2f32}', &['\u{5e72}']), ('\u{2f33}', &['\u{5e7a}']), ('\u{2f34}',
        &['\u{5e7f}']), ('\u{2f35}', &['\u{5ef4}']), ('\u{2f36}', &['\u{5efe}']), ('\u{2f37}',
        &['\u{5f0b}']), ('\u{2f38}', &['\u{5f13}']), ('\u{2f39}', &['\u{5f50}']), ('\u{2f3a}',
        &['\u{5f61}']), ('\u{2f3b}', &['\u{5f73}']), ('\u{2f3c}', &['\u{5fc3}']), ('\u{2f3d}',
        &['\u{6208}']), ('\u{2f3e}', &['\u{6236}']), ('\u{2f3f}', &['\u{624b}']), ('\u{2f40}',
        &['\u{652f}']), ('\u{2f41}', &['\u{6534}']), ('\u{2f42}', &['\u{6587}']), ('\u{2f43}',
        &['\u{6597}']), ('\u{2f44}', &['\u{65a4}']), ('\u{2f45}', &['\u{65b9}']), ('\u{2f46}',
        &['\u{65e0}']), ('\u{2f47}', &['\u{65e5}']), ('\u{2f48}', &['\u{66f0}']), ('\u{2f49}',
        &['\u{6708}']), ('\u{2f4a}', &['\u{6728}']), ('\u{2f4b}', &['\u{6b20}']), ('\u{2f4c}',
        &['\u{6b62}']), ('\u{2f4d}', &['\u{6b79}']), ('\u{2f4e}', &['\u{6bb3}']), ('\u{2f4f}',
        &['\u{6bcb}']), ('\u{2f50}', &['\u{6bd4}']), ('\u{2f51}', &['\u{6bdb}']), ('\u{2f52}',
        &['\u{6c0f}']), ('\u{2f53}', &['\u{6c14}']), ('\u{2f54}', &['\u{6c34}']), ('\u{2f55}',
        &['\u{706b}']), ('\u{2f56}', &['\u{722a}']), ('\u{2f57}', &['\u{7236}']), ('\u{2f58}',
        &['\u{723b}']), ('\u{2f59}', &['\u{723f}']), ('\u{2f5a}', &['\u{7247}']), ('\u{2f5b}',
        &['\u{7259}']), ('\u{2f5c}', &['\u{725b}']), ('\u{2f5d}', &['\u{72ac}']), ('\u{2f5e}',
        &['\u{7384}']), ('\u{2f5f}', &['\u{7389}']), ('\u{2f60}', &['\u{74dc}']), ('\u{2f61}',
        &['\u{74e6}']), ('\u{2f62}', &['\u{7518}']), ('\u{2f63}', &['\u{751f}']), ('\u{2f64}',
        &['\u{7528}']), ('\u{2f65}', &['\u{7530}']), ('\u{2f66}', &['\u{758b}']), ('\u{2f67}',
        &['\u{7592}']), ('\u{2f68}', &['\u{7676}']), ('\u{2f69}', &['\u{767d}']), ('\u{2f6a}',
        &['\u{76ae}']), ('\u{2f6b}', &['\u{76bf}']), ('\u{2f6c}', &['\u{76ee}']), ('\u{2f6d}',
        &['\u{77db}']), ('\u{2f6e}', &['\u{77e2}']), ('\u{2f6f}', &['\u{77f3}']), ('\u{2f70}',
        &['\u{793a}']), ('\u{2f71}', &['\u{79b8}']), ('\u{2f72}', &['\u{79be}']), ('\u{2f73}',
        &['\u{7a74}']), ('\u{2f74}', &['\u{7acb}']), ('\u{2f75}', &['\u{7af9}']), ('\u{2f76}',
        &['\u{7c73}']), ('\u{2f77}', &['\u{7cf8}']), ('\u{2f78}', &['\u{7f36}']), ('\u{2f79}',
        &['\u{7f51}']), ('\u{2f7a}', &['\u{7f8a}']), ('\u{2f7b}', &['\u{7fbd}']), ('\u{2f7c}',
        &['\u{8001}']), ('\u{2f7d}', &['\u{800c}']), ('\u{2f7e}', &['\u{8012}']), ('\u{2f7f}',
        &['\u{8033}']), ('\u{2f80}', &['\u{807f}']), ('\u{2f81}', &['\u{8089}']), ('\u{2f82}',
        &['\u{81e3}']), ('\u{2f83}', &['\u{81ea}']), ('\u{2f84}', &['\u{81f3}']), ('\u{2f85}',
        &['\u{81fc}']), ('\u{2f86}', &['\u{820c}']), ('\u{2f87}', &['\u{821b}']), ('\u{2f88}',
        &['\u{821f}']), ('\u{2f89}', &['\u{826e}']), ('\u{2f8a}', &['\u{8272}']), ('\u{2f8b}',
        &['\u{8278}']), ('\u{2f8c}', &['\u{864d}']), ('\u{2f8d}', &['\u{866b}']), ('\u{2f8e}',
        &['\u{8840}']), ('\u{2f8f}', &['\u{884c}']), ('\u{2f90}', &['\u{8863}']), ('\u{2f91}',
        &['\u{897e}']), ('\u{2f92}', &['\u{898b}']), ('\u{2f93}', &['\u{89d2}']), ('\u{2f94}',
        &['\u{8a00}']), ('\u{2f95}', &['\u{8c37}']), ('\u{2f96}', &['\u{8c46}']), ('\u{2f97}',
        &['\u{8c55}']), ('\u{2f98}', &['\u{8c78}']), ('\u{2f99}', &['\u{8c9d}']), ('\u{2f9a}',
        &['\u{8d64}']), ('\u{2f9b}', &['\u{8d70}']), ('\u{2f9c}', &['\u{8db3}']), ('\u{2f9d}',
        &['\u{8eab}']), ('\u{2f9e}', &['\u{8eca}']), ('\u{2f9f}', &['\u{8f9b}']), ('\u{2fa0}',
        &['\u{8fb0}']), ('\u{2fa1}', &['\u{8fb5}']), ('\u{2fa2}', &['\u{9091}']), ('\u{2fa3}',
        &['\u{9149}']), ('\u{2fa4}', &['\u{91c6}']), ('\u{2fa5}', &['\u{91cc}']), ('\u{2fa6}',
        &['\u{91d1}']), ('\u{2fa7}', &['\u{9577}']), ('\u{2fa8}', &['\u{9580}']), ('\u{2fa9}',
        &['\u{961c}']), ('\u{2faa}', &['\u{96b6}']), ('\u{2fab}', &['\u{96b9}']), ('\u{2fac}',
        &['\u{96e8}']), ('\u{2fad}', &['\u{9751}']), ('\u{2fae}', &['\u{975e}']), ('\u{2faf}',
        &['\u{9762}']), ('\u{2fb0}', &['\u{9769}']), ('\u{2fb1}', &['\u{97cb}']), ('\u{2fb2}',
        &['\u{97ed}']), ('\u{2fb3}', &['\u{97f3}']), ('\u{2fb4}', &['\u{9801}']), ('\u{2fb5}',
        &['\u{98a8}']), ('\u{2fb6}', &['\u{98db}']), ('\u{2fb7}', &['\u{98df}']), ('\u{2fb8}',
        &['\u{9996}']), ('\u{2fb9}', &['\u{9999}']), ('\u{2fba}', &['\u{99ac}']), ('\u{2fbb}',
        &['\u{9aa8}']), ('\u{2fbc}', &['\u{9ad8}']), ('\u{2fbd}', &['\u{9adf}']), ('\u{2fbe}',
        &['\u{9b25}']), ('\u{2fbf}', &['\u{9b2f}']), ('\u{2fc0}', &['\u{9b32}']), ('\u{2fc1}',
        &['\u{9b3c}']), ('\u{2fc2}', &['\u{9b5a}']), ('\u{2fc3}', &['\u{9ce5}']), ('\u{2fc4}',
        &['\u{9e75}']), ('\u{2fc5}', &['\u{9e7f}']), ('\u{2fc6}', &['\u{9ea5}']), ('\u{2fc7}',
        &['\u{9ebb}']), ('\u{2fc8}', &['\u{9ec3}']), ('\u{2fc9}', &['\u{9ecd}']), ('\u{2fca}',
        &['\u{9ed1}']), ('\u{2fcb}', &['\u{9ef9}']), ('\u{2fcc}', &['\u{9efd}']), ('\u{2fcd}',
        &['\u{9f0e}']), ('\u{2fce}', &['\u{9f13}']), ('\u{2fcf}', &['\u{9f20}']), ('\u{2fd0}',
        &['\u{9f3b}']), ('\u{2fd1}', &['\u{9f4a}']), ('\u{2fd2}', &['\u{9f52}']), ('\u{2fd3}',
        &['\u{9f8d}']), ('\u{2fd4}', &['\u{9f9c}']), ('\u{2fd5}', &['\u{9fa0}']), ('\u{3000}',
        &['\u{20}']), ('\u{3036}', &['\u{3012}']), ('\u{3038}', &['\u{5341}']), ('\u{3039}',
        &['\u{5344}']), ('\u{303a}', &['\u{5345}']), ('\u{309b}', &['\u{20}', '\u{3099}']),
        ('\u{309c}', &['\u{20}', '\u{309a}']), ('\u{309f}', &['\u{3088}', '\u{308a}']), ('\u{30ff}',
        &['\u{30b3}', '\u{30c8}']), ('\u{3131}', &['\u{1100}']), ('\u{3132}', &['\u{1101}']),
        ('\u{3133}', &['\u{11aa}']), ('\u{3134}', &['\u{1102}']), ('\u{3135}', &['\u{11ac}']),
        ('\u{3136}', &['\u{11ad}']), ('\u{3137}', &['\u{1103}']), ('\u{3138}', &['\u{1104}']),
        ('\u{3139}', &['\u{1105}']), ('\u{313a}', &['\u{11b0}']), ('\u{313b}', &['\u{11b1}']),
        ('\u{313c}', &['\u{11b2}']), ('\u{313d}', &['\u{11b3}']), ('\u{313e}', &['\u{11b4}']),
        ('\u{313f}', &['\u{11b5}']), ('\u{3140}', &['\u{111a}']), ('\u{3141}', &['\u{1106}']),
        ('\u{3142}', &['\u{1107}']), ('\u{3143}', &['\u{1108}']), ('\u{3144}', &['\u{1121}']),
        ('\u{3145}', &['\u{1109}']), ('\u{3146}', &['\u{110a}']), ('\u{3147}', &['\u{110b}']),
        ('\u{3148}', &['\u{110c}']), ('\u{3149}', &['\u{110d}']), ('\u{314a}', &['\u{110e}']),
        ('\u{314b}', &['\u{110f}']), ('\u{314c}', &['\u{1110}']), ('\u{314d}', &['\u{1111}']),
        ('\u{314e}', &['\u{1112}']), ('\u{314f}', &['\u{1161}']), ('\u{3150}', &['\u{1162}']),
        ('\u{3151}', &['\u{1163}']), ('\u{3152}', &['\u{1164}']), ('\u{3153}', &['\u{1165}']),
        ('\u{3154}', &['\u{1166}']), ('\u{3155}', &['\u{1167}']), ('\u{3156}', &['\u{1168}']),
        ('\u{3157}', &['\u{1169}']), ('\u{3158}', &['\u{116a}']), ('\u{3159}', &['\u{116b}']),
        ('\u{315a}', &['\u{116c}']), ('\u{315b}', &['\u{116d}']), ('\u{315c}', &['\u{116e}']),
        ('\u{315d}', &['\u{116f}']), ('\u{315e}', &['\u{1170}']), ('\u{315f}', &['\u{1171}']),
        ('\u{3160}', &['\u{1172}']), ('\u{3161}', &['\u{1173}']), ('\u{3162}', &['\u{1174}']),
        ('\u{3163}', &['\u{1175}']), ('\u{3164}', &['\u{1160}']), ('\u{3165}', &['\u{1114}']),
        ('\u{3166}', &['\u{1115}']), ('\u{3167}', &['\u{11c7}']), ('\u{3168}', &['\u{11c8}']),
        ('\u{3169}', &['\u{11cc}']), ('\u{316a}', &['\u{11ce}']), ('\u{316b}', &['\u{11d3}']),
        ('\u{316c}', &['\u{11d7}']), ('\u{316d}', &['\u{11d9}']), ('\u{316e}', &['\u{111c}']),
        ('\u{316f}', &['\u{11dd}']), ('\u{3170}', &['\u{11df}']), ('\u{3171}', &['\u{111d}']),
        ('\u{3172}', &['\u{111e}']), ('\u{3173}', &['\u{1120}']), ('\u{3174}', &['\u{1122}']),
        ('\u{3175}', &['\u{1123}']), ('\u{3176}', &['\u{1127}']), ('\u{3177}', &['\u{1129}']),
        ('\u{3178}', &['\u{112b}']), ('\u{3179}', &['\u{112c}']), ('\u{317a}', &['\u{112d}']),
        ('\u{317b}', &['\u{112e}']), ('\u{317c}', &['\u{112f}']), ('\u{317d}', &['\u{1132}']),
        ('\u{317e}', &['\u{1136}']), ('\u{317f}', &['\u{1140}']), ('\u{3180}', &['\u{1147}']),
        ('\u{3181}', &['\u{114c}']), ('\u{3182}', &['\u{11f1}']), ('\u{3183}', &['\u{11f2}']),
        ('\u{3184}', &['\u{1157}']), ('\u{3185}', &['\u{1158}']), ('\u{3186}', &['\u{1159}']),
        ('\u{3187}', &['\u{1184}']), ('\u{3188}', &['\u{1185}']), ('\u{3189}', &['\u{1188}']),
        ('\u{318a}', &['\u{1191}']), ('\u{318b}', &['\u{1192}']), ('\u{318c}', &['\u{1194}']),
        ('\u{318d}', &['\u{119e}']), ('\u{318e}', &['\u{11a1}']), ('\u{3192}', &['\u{4e00}']),
        ('\u{3193}', &['\u{4e8c}']), ('\u{3194}', &['\u{4e09}']), ('\u{3195}', &['\u{56db}']),
        ('\u{3196}', &['\u{4e0a}']), ('\u{3197}', &['\u{4e2d}']), ('\u{3198}', &['\u{4e0b}']),
        ('\u{3199}', &['\u{7532}']), ('\u{319a}', &['\u{4e59}']), ('\u{319b}', &['\u{4e19}']),
        ('\u{319c}', &['\u{4e01}']), ('\u{319d}', &['\u{5929}']), ('\u{319e}', &['\u{5730}']),
        ('\u{319f}', &['\u{4eba}']), ('\u{3200}', &['\u{28}', '\u{1100}', '\u{29}']), ('\u{3201}',
        &['\u{28}', '\u{1102}', '\u{29}']), ('\u{3202}', &['\u{28}', '\u{1103}', '\u{29}']),
        ('\u{3203}', &['\u{28}', '\u{1105}', '\u{29}']), ('\u{3204}', &['\u{28}', '\u{1106}',
        '\u{29}']), ('\u{3205}', &['\u{28}', '\u{1107}', '\u{29}']), ('\u{3206}', &['\u{28}',
        '\u{1109}', '\u{29}']), ('\u{3207}', &['\u{28}', '\u{110b}', '\u{29}']), ('\u{3208}',
        &['\u{28}', '\u{110c}', '\u{29}']), ('\u{3209}', &['\u{28}', '\u{110e}', '\u{29}']),
        ('\u{320a}', &['\u{28}', '\u{110f}', '\u{29}']), ('\u{320b}', &['\u{28}', '\u{1110}',
        '\u{29}']), ('\u{320c}', &['\u{28}', '\u{1111}', '\u{29}']), ('\u{320d}', &['\u{28}',
        '\u{1112}', '\u{29}']), ('\u{320e}', &['\u{28}', '\u{1100}', '\u{1161}', '\u{29}']),
        ('\u{320f}', &['\u{28}', '\u{1102}', '\u{1161}', '\u{29}']), ('\u{3210}', &['\u{28}',
        '\u{1103}', '\u{1161}', '\u{29}']), ('\u{3211}', &['\u{28}', '\u{1105}', '\u{1161}',
        '\u{29}']), ('\u{3212}', &['\u{28}', '\u{1106}', '\u{1161}', '\u{29}']), ('\u{3213}',
        &['\u{28}', '\u{1107}', '\u{1161}', '\u{29}']), ('\u{3214}', &['\u{28}', '\u{1109}',
        '\u{1161}', '\u{29}']), ('\u{3215}', &['\u{28}', '\u{110b}', '\u{1161}', '\u{29}']),
        ('\u{3216}', &['\u{28}', '\u{110c}', '\u{1161}', '\u{29}']), ('\u{3217}', &['\u{28}',
        '\u{110e}', '\u{1161}', '\u{29}']), ('\u{3218}', &['\u{28}', '\u{110f}', '\u{1161}',
        '\u{29}']), ('\u{3219}', &['\u{28}', '\u{1110}', '\u{1161}', '\u{29}']), ('\u{321a}',
        &['\u{28}', '\u{1111}', '\u{1161}', '\u{29}']), ('\u{321b}', &['\u{28}', '\u{1112}',
        '\u{1161}', '\u{29}']), ('\u{321c}', &['\u{28}', '\u{110c}', '\u{116e}', '\u{29}']),
        ('\u{321d}', &['\u{28}', '\u{110b}', '\u{1169}', '\u{110c}', '\u{1165}', '\u{11ab}',
        '\u{29}']), ('\u{321e}', &['\u{28}', '\u{110b}', '\u{1169}', '\u{1112}', '\u{116e}',
        '\u{29}']), ('\u{3220}', &['\u{28}', '\u{4e00}', '\u{29}']), ('\u{3221}', &['\u{28}',
        '\u{4e8c}', '\u{29}']), ('\u{3222}', &['\u{28}', '\u{4e09}', '\u{29}']), ('\u{3223}',
        &['\u{28}', '\u{56db}', '\u{29}']), ('\u{3224}', &['\u{28}', '\u{4e94}', '\u{29}']),
        ('\u{3225}', &['\u{28}', '\u{516d}', '\u{29}']), ('\u{3226}', &['\u{28}', '\u{4e03}',
        '\u{29}']), ('\u{3227}', &['\u{28}', '\u{516b}', '\u{29}']), ('\u{3228}', &['\u{28}',
        '\u{4e5d}', '\u{29}']), ('\u{3229}', &['\u{28}', '\u{5341}', '\u{29}']), ('\u{322a}',
        &['\u{28}', '\u{6708}', '\u{29}']), ('\u{322b}', &['\u{28}', '\u{706b}', '\u{29}']),
        ('\u{322c}', &['\u{28}', '\u{6c34}', '\u{29}']), ('\u{322d}', &['\u{28}', '\u{6728}',
        '\u{29}']), ('\u{322e}', &['\u{28}', '\u{91d1}', '\u{29}']), ('\u{322f}', &['\u{28}',
        '\u{571f}', '\u{29}']), ('\u{3230}', &['\u{28}', '\u{65e5}', '\u{29}']), ('\u{3231}',
        &['\u{28}', '\u{682a}', '\u{29}']), ('\u{3232}', &['\u{28}', '\u{6709}', '\u{29}']),
        ('\u{3233}', &['\u{28}', '\u{793e}', '\u{29}']), ('\u{3234}', &['\u{28}', '\u{540d}',
        '\u{29}']), ('\u{3235}', &['\u{28}', '\u{7279}', '\u{29}']), ('\u{3236}', &['\u{28}',
        '\u{8ca1}', '\u{29}']), ('\u{3237}', &['\u{28}', '\u{795d}', '\u{29}']), ('\u{3238}',
        &['\u{28}', '\u{52b4}', '\u{29}']), ('\u{3239}', &['\u{28}', '\u{4ee3}', '\u{29}']),
        ('\u{323a}', &['\u{28}', '\u{547c}', '\u{29}']), ('\u{323b}', &['\u{28}', '\u{5b66}',
        '\u{29}']), ('\u{323c}', &['\u{28}', '\u{76e3}', '\u{29}']), ('\u{323d}', &['\u{28}',
        '\u{4f01}', '\u{29}']), ('\u{323e}', &['\u{28}', '\u{8cc7}', '\u{29}']), ('\u{323f}',
        &['\u{28}', '\u{5354}', '\u{29}']), ('\u{3240}', &['\u{28}', '\u{796d}', '\u{29}']),
        ('\u{3241}', &['\u{28}', '\u{4f11}', '\u{29}']), ('\u{3242}', &['\u{28}', '\u{81ea}',
        '\u{29}']), ('\u{3243}', &['\u{28}', '\u{81f3}', '\u{29}']), ('\u{3244}', &['\u{554f}']),
        ('\u{3245}', &['\u{5e7c}']), ('\u{3246}', &['\u{6587}']), ('\u{3247}', &['\u{7b8f}']),
        ('\u{3250}', &['\u{50}', '\u{54}', '\u{45}']), ('\u{3251}', &['\u{32}', '\u{31}']),
        ('\u{3252}', &['\u{32}', '\u{32}']), ('\u{3253}', &['\u{32}', '\u{33}']), ('\u{3254}',
        &['\u{32}', '\u{34}']), ('\u{3255}', &['\u{32}', '\u{35}']), ('\u{3256}', &['\u{32}',
        '\u{36}']), ('\u{3257}', &['\u{32}', '\u{37}']), ('\u{3258}', &['\u{32}', '\u{38}']),
        ('\u{3259}', &['\u{32}', '\u{39}']), ('\u{325a}', &['\u{33}', '\u{30}']), ('\u{325b}',
        &['\u{33}', '\u{31}']), ('\u{325c}', &['\u{33}', '\u{32}']), ('\u{325d}', &['\u{33}',
        '\u{33}']), ('\u{325e}', &['\u{33}', '\u{34}']), ('\u{325f}', &['\u{33}', '\u{35}']),
        ('\u{3260}', &['\u{1100}']), ('\u{3261}', &['\u{1102}']), ('\u{3262}', &['\u{1103}']),
        ('\u{3263}', &['\u{1105}']), ('\u{3264}', &['\u{1106}']), ('\u{3265}', &['\u{1107}']),
        ('\u{3266}', &['\u{1109}']), ('\u{3267}', &['\u{110b}']), ('\u{3268}', &['\u{110c}']),
        ('\u{3269}', &['\u{110e}']), ('\u{326a}', &['\u{110f}']), ('\u{326b}', &['\u{1110}']),
        ('\u{326c}', &['\u{1111}']), ('\u{326d}', &['\u{1112}']), ('\u{326e}', &['\u{1100}',
        '\u{1161}']), ('\u{326f}', &['\u{1102}', '\u{1161}']), ('\u{3270}', &['\u{1103}',
        '\u{1161}']), ('\u{3271}', &['\u{1105}', '\u{1161}']), ('\u{3272}', &['\u{1106}',
        '\u{1161}']), ('\u{3273}', &['\u{1107}', '\u{1161}']), ('\u{3274}', &['\u{1109}',
        '\u{1161}']), ('\u{3275}', &['\u{110b}', '\u{1161}']), ('\u{3276}', &['\u{110c}',
        '\u{1161}']), ('\u{3277}', &['\u{110e}', '\u{1161}']), ('\u{3278}', &['\u{110f}',
        '\u{1161}']), ('\u{3279}', &['\u{1110}', '\u{1161}']), ('\u{327a}', &['\u{1111}',
        '\u{1161}']), ('\u{327b}', &['\u{1112}', '\u{1161}']), ('\u{327c}', &['\u{110e}',
        '\u{1161}', '\u{11b7}', '\u{1100}', '\u{1169}']), ('\u{327d}', &['\u{110c}', '\u{116e}',
        '\u{110b}', '\u{1174}']), ('\u{327e}', &['\u{110b}', '\u{116e}']), ('\u{3280}',
        &['\u{4e00}']), ('\u{3281}', &['\u{4e8c}']), ('\u{3282}', &['\u{4e09}']), ('\u{3283}',
        &['\u{56db}']), ('\u{3284}', &['\u{4e94}']), ('\u{3285}', &['\u{516d}']), ('\u{3286}',
        &['\u{4e03}']), ('\u{3287}', &['\u{516b}']), ('\u{3288}', &['\u{4e5d}']), ('\u{3289}',
        &['\u{5341}']), ('\u{328a}', &['\u{6708}']), ('\u{328b}', &['\u{706b}']), ('\u{328c}',
        &['\u{6c34}']), ('\u{328d}', &['\u{6728}']), ('\u{328e}', &['\u{91d1}']), ('\u{328f}',
        &['\u{571f}']), ('\u{3290}', &['\u{65e5}']), ('\u{3291}', &['\u{682a}']), ('\u{3292}',
        &['\u{6709}']), ('\u{3293}', &['\u{793e}']), ('\u{3294}', &['\u{540d}']), ('\u{3295}',
        &['\u{7279}']), ('\u{3296}', &['\u{8ca1}']), ('\u{3297}', &['\u{795d}']), ('\u{3298}',
        &['\u{52b4}']), ('\u{3299}', &['\u{79d8}']), ('\u{329a}', &['\u{7537}']), ('\u{329b}',
        &['\u{5973}']), ('\u{329c}', &['\u{9069}']), ('\u{329d}', &['\u{512a}']), ('\u{329e}',
        &['\u{5370}']), ('\u{329f}', &['\u{6ce8}']), ('\u{32a0}', &['\u{9805}']), ('\u{32a1}',
        &['\u{4f11}']), ('\u{32a2}', &['\u{5199}']), ('\u{32a3}', &['\u{6b63}']), ('\u{32a4}',
        &['\u{4e0a}']), ('\u{32a5}', &['\u{4e2d}']), ('\u{32a6}', &['\u{4e0b}']), ('\u{32a7}',
        &['\u{5de6}']), ('\u{32a8}', &['\u{53f3}']), ('\u{32a9}', &['\u{533b}']), ('\u{32aa}',
        &['\u{5b97}']), ('\u{32ab}', &['\u{5b66}']), ('\u{32ac}', &['\u{76e3}']), ('\u{32ad}',
        &['\u{4f01}']), ('\u{32ae}', &['\u{8cc7}']), ('\u{32af}', &['\u{5354}']), ('\u{32b0}',
        &['\u{591c}']), ('\u{32b1}', &['\u{33}', '\u{36}']), ('\u{32b2}', &['\u{33}', '\u{37}']),
        ('\u{32b3}', &['\u{33}', '\u{38}']), ('\u{32b4}', &['\u{33}', '\u{39}']), ('\u{32b5}',
        &['\u{34}', '\u{30}']), ('\u{32b6}', &['\u{34}', '\u{31}']), ('\u{32b7}', &['\u{34}',
        '\u{32}']), ('\u{32b8}', &['\u{34}', '\u{33}']), ('\u{32b9}', &['\u{34}', '\u{34}']),
        ('\u{32ba}', &['\u{34}', '\u{35}']), ('\u{32bb}', &['\u{34}', '\u{36}']), ('\u{32bc}',
        &['\u{34}', '\u{37}']), ('\u{32bd}', &['\u{34}', '\u{38}']), ('\u{32be}', &['\u{34}',
        '\u{39}']), ('\u{32bf}', &['\u{35}', '\u{30}']), ('\u{32c0}', &['\u{31}', '\u{6708}']),
        ('\u{32c1}', &['\u{32}', '\u{6708}']), ('\u{32c2}', &['\u{33}', '\u{6708}']), ('\u{32c3}',
        &['\u{34}', '\u{6708}']), ('\u{32c4}', &['\u{35}', '\u{6708}']), ('\u{32c5}', &['\u{36}',
        '\u{6708}']), ('\u{32c6}', &['\u{37}', '\u{6708}']), ('\u{32c7}', &['\u{38}', '\u{6708}']),
        ('\u{32c8}', &['\u{39}', '\u{6708}']), ('\u{32c9}', &['\u{31}', '\u{30}', '\u{6708}']),
        ('\u{32ca}', &['\u{31}', '\u{31}', '\u{6708}']), ('\u{32cb}', &['\u{31}', '\u{32}',
        '\u{6708}']), ('\u{32cc}', &['\u{48}', '\u{67}']), ('\u{32cd}', &['\u{65}', '\u{72}',
        '\u{67}']), ('\u{32ce}', &['\u{65}', '\u{56}']), ('\u{32cf}', &['\u{4c}', '\u{54}',
        '\u{44}']), ('\u{32d0}', &['\u{30a2}']), ('\u{32d1}', &['\u{30a4}']), ('\u{32d2}',
        &['\u{30a6}']), ('\u{32d3}', &['\u{30a8}']), ('\u{32d4}', &['\u{30aa}']), ('\u{32d5}',
        &['\u{30ab}']), ('\u{32d6}', &['\u{30ad}']), ('\u{32d7}', &['\u{30af}']), ('\u{32d8}',
        &['\u{30b1}']), ('\u{32d9}', &['\u{30b3}']), ('\u{32da}', &['\u{30b5}']), ('\u{32db}',
        &['\u{30b7}']), ('\u{32dc}', &['\u{30b9}']), ('\u{32dd}', &['\u{30bb}']), ('\u{32de}',
        &['\u{30bd}']), ('\u{32df}', &['\u{30bf}']), ('\u{32e0}', &['\u{30c1}']), ('\u{32e1}',
        &['\u{30c4}']), ('\u{32e2}', &['\u{30c6}']), ('\u{32e3}', &['\u{30c8}']), ('\u{32e4}',
        &['\u{30ca}']), ('\u{32e5}', &['\u{30cb}']), ('\u{32e6}', &['\u{30cc}']), ('\u{32e7}',
        &['\u{30cd}']), ('\u{32e8}', &['\u{30ce}']), ('\u{32e9}', &['\u{30cf}']), ('\u{32ea}',
        &['\u{30d2}']), ('\u{32eb}', &['\u{30d5}']), ('\u{32ec}', &['\u{30d8}']), ('\u{32ed}',
        &['\u{30db}']), ('\u{32ee}', &['\u{30de}']), ('\u{32ef}', &['\u{30df}']), ('\u{32f0}',
        &['\u{30e0}']), ('\u{32f1}', &['\u{30e1}']), ('\u{32f2}', &['\u{30e2}']), ('\u{32f3}',
        &['\u{30e4}']), ('\u{32f4}', &['\u{30e6}']), ('\u{32f5}', &['\u{30e8}']), ('\u{32f6}',
        &['\u{30e9}']), ('\u{32f7}', &['\u{30ea}']), ('\u{32f8}', &['\u{30eb}']), ('\u{32f9}',
        &['\u{30ec}']), ('\u{32fa}', &['\u{30ed}']), ('\u{32fb}', &['\u{30ef}']), ('\u{32fc}',
        &['\u{30f0}']), ('\u{32fd}', &['\u{30f1}']), ('\u{32fe}', &['\u{30f2}']), ('\u{3300}',
        &['\u{30a2}', '\u{30d1}', '\u{30fc}', '\u{30c8}']), ('\u{3301}', &['\u{30a2}', '\u{30eb}',
        '\u{30d5}', '\u{30a1}']), ('\u{3302}', &['\u{30a2}', '\u{30f3}', '\u{30da}', '\u{30a2}']),
        ('\u{3303}', &['\u{30a2}', '\u{30fc}', '\u{30eb}']), ('\u{3304}', &['\u{30a4}', '\u{30cb}',
        '\u{30f3}', '\u{30b0}']), ('\u{3305}', &['\u{30a4}', '\u{30f3}', '\u{30c1}']), ('\u{3306}',
        &['\u{30a6}', '\u{30a9}', '\u{30f3}']), ('\u{3307}', &['\u{30a8}', '\u{30b9}', '\u{30af}',
        '\u{30fc}', '\u{30c9}']), ('\u{3308}', &['\u{30a8}', '\u{30fc}', '\u{30ab}', '\u{30fc}']),
        ('\u{3309}', &['\u{30aa}', '\u{30f3}', '\u{30b9}']), ('\u{330a}', &['\u{30aa}', '\u{30fc}',
        '\u{30e0}']), ('\u{330b}', &['\u{30ab}', '\u{30a4}', '\u{30ea}']), ('\u{330c}',
        &['\u{30ab}', '\u{30e9}', '\u{30c3}', '\u{30c8}']), ('\u{330d}', &['\u{30ab}', '\u{30ed}',
        '\u{30ea}', '\u{30fc}']), ('\u{330e}', &['\u{30ac}', '\u{30ed}', '\u{30f3}']), ('\u{330f}',
        &['\u{30ac}', '\u{30f3}', '\u{30de}']), ('\u{3310}', &['\u{30ae}', '\u{30ac}']),
        ('\u{3311}', &['\u{30ae}', '\u{30cb}', '\u{30fc}']), ('\u{3312}', &['\u{30ad}', '\u{30e5}',
        '\u{30ea}', '\u{30fc}']), ('\u{3313}', &['\u{30ae}', '\u{30eb}', '\u{30c0}', '\u{30fc}']),
        ('\u{3314}', &['\u{30ad}', '\u{30ed}']), ('\u{3315}', &['\u{30ad}', '\u{30ed}', '\u{30b0}',
        '\u{30e9}', '\u{30e0}']), ('\u{3316}', &['\u{30ad}', '\u{30ed}', '\u{30e1}', '\u{30fc}',
        '\u{30c8}', '\u{30eb}']), ('\u{3317}', &['\u{30ad}', '\u{30ed}', '\u{30ef}', '\u{30c3}',
        '\u{30c8}']), ('\u{3318}', &['\u{30b0}', '\u{30e9}', '\u{30e0}']), ('\u{3319}',
        &['\u{30b0}', '\u{30e9}', '\u{30e0}', '\u{30c8}', '\u{30f3}']), ('\u{331a}', &['\u{30af}',
        '\u{30eb}', '\u{30bc}', '\u{30a4}', '\u{30ed}']), ('\u{331b}', &['\u{30af}', '\u{30ed}',
        '\u{30fc}', '\u{30cd}']), ('\u{331c}', &['\u{30b1}', '\u{30fc}', '\u{30b9}']), ('\u{331d}',
        &['\u{30b3}', '\u{30eb}', '\u{30ca}']), ('\u{331e}', &['\u{30b3}', '\u{30fc}', '\u{30dd}']),
        ('\u{331f}', &['\u{30b5}', '\u{30a4}', '\u{30af}', '\u{30eb}']), ('\u{3320}', &['\u{30b5}',
        '\u{30f3}', '\u{30c1}', '\u{30fc}', '\u{30e0}']), ('\u{3321}', &['\u{30b7}', '\u{30ea}',
        '\u{30f3}', '\u{30b0}']), ('\u{3322}', &['\u{30bb}', '\u{30f3}', '\u{30c1}']), ('\u{3323}',
        &['\u{30bb}', '\u{30f3}', '\u{30c8}']), ('\u{3324}', &['\u{30c0}', '\u{30fc}', '\u{30b9}']),
        ('\u{3325}', &['\u{30c7}', '\u{30b7}']), ('\u{3326}', &['\u{30c9}', '\u{30eb}']),
        ('\u{3327}', &['\u{30c8}', '\u{30f3}']), ('\u{3328}', &['\u{30ca}', '\u{30ce}']),
        ('\u{3329}', &['\u{30ce}', '\u{30c3}', '\u{30c8}']), ('\u{332a}', &['\u{30cf}', '\u{30a4}',
        '\u{30c4}']), ('\u{332b}', &['\u{30d1}', '\u{30fc}', '\u{30bb}', '\u{30f3}', '\u{30c8}']),
        ('\u{332c}', &['\u{30d1}', '\u{30fc}', '\u{30c4}']), ('\u{332d}', &['\u{30d0}', '\u{30fc}',
        '\u{30ec}', '\u{30eb}']), ('\u{332e}', &['\u{30d4}', '\u{30a2}', '\u{30b9}', '\u{30c8}',
        '\u{30eb}']), ('\u{332f}', &['\u{30d4}', '\u{30af}', '\u{30eb}']), ('\u{3330}',
        &['\u{30d4}', '\u{30b3}']), ('\u{3331}', &['\u{30d3}', '\u{30eb}']), ('\u{3332}',
        &['\u{30d5}', '\u{30a1}', '\u{30e9}', '\u{30c3}', '\u{30c9}']), ('\u{3333}', &['\u{30d5}',
        '\u{30a3}', '\u{30fc}', '\u{30c8}']), ('\u{3334}', &['\u{30d6}', '\u{30c3}', '\u{30b7}',
        '\u{30a7}', '\u{30eb}']), ('\u{3335}', &['\u{30d5}', '\u{30e9}', '\u{30f3}']), ('\u{3336}',
        &['\u{30d8}', '\u{30af}', '\u{30bf}', '\u{30fc}', '\u{30eb}']), ('\u{3337}', &['\u{30da}',
        '\u{30bd}']), ('\u{3338}', &['\u{30da}', '\u{30cb}', '\u{30d2}']), ('\u{3339}',
        &['\u{30d8}', '\u{30eb}', '\u{30c4}']), ('\u{333a}', &['\u{30da}', '\u{30f3}', '\u{30b9}']),
        ('\u{333b}', &['\u{30da}', '\u{30fc}', '\u{30b8}']), ('\u{333c}', &['\u{30d9}', '\u{30fc}',
        '\u{30bf}']), ('\u{333d}', &['\u{30dd}', '\u{30a4}', '\u{30f3}', '\u{30c8}']), ('\u{333e}',
        &['\u{30dc}', '\u{30eb}', '\u{30c8}']), ('\u{333f}', &['\u{30db}', '\u{30f3}']),
        ('\u{3340}', &['\u{30dd}', '\u{30f3}', '\u{30c9}']), ('\u{3341}', &['\u{30db}', '\u{30fc}',
        '\u{30eb}']), ('\u{3342}', &['\u{30db}', '\u{30fc}', '\u{30f3}']), ('\u{3343}',
        &['\u{30de}', '\u{30a4}', '\u{30af}', '\u{30ed}']), ('\u{3344}', &['\u{30de}', '\u{30a4}',
        '\u{30eb}']), ('\u{3345}', &['\u{30de}', '\u{30c3}', '\u{30cf}']), ('\u{3346}',
        &['\u{30de}', '\u{30eb}', '\u{30af}']), ('\u{3347}', &['\u{30de}', '\u{30f3}', '\u{30b7}',
        '\u{30e7}', '\u{30f3}']), ('\u{3348}', &['\u{30df}', '\u{30af}', '\u{30ed}', '\u{30f3}']),
        ('\u{3349}', &['\u{30df}', '\u{30ea}']), ('\u{334a}', &['\u{30df}', '\u{30ea}', '\u{30d0}',
        '\u{30fc}', '\u{30eb}']), ('\u{334b}', &['\u{30e1}', '\u{30ac}']), ('\u{334c}',
        &['\u{30e1}', '\u{30ac}', '\u{30c8}', '\u{30f3}']), ('\u{334d}', &['\u{30e1}', '\u{30fc}',
        '\u{30c8}', '\u{30eb}']), ('\u{334e}', &['\u{30e4}', '\u{30fc}', '\u{30c9}']), ('\u{334f}',
        &['\u{30e4}', '\u{30fc}', '\u{30eb}']), ('\u{3350}', &['\u{30e6}', '\u{30a2}', '\u{30f3}']),
        ('\u{3351}', &['\u{30ea}', '\u{30c3}', '\u{30c8}', '\u{30eb}']), ('\u{3352}', &['\u{30ea}',
        '\u{30e9}']), ('\u{3353}', &['\u{30eb}', '\u{30d4}', '\u{30fc}']), ('\u{3354}',
        &['\u{30eb}', '\u{30fc}', '\u{30d6}', '\u{30eb}']), ('\u{3355}', &['\u{30ec}', '\u{30e0}']),
        ('\u{3356}', &['\u{30ec}', '\u{30f3}', '\u{30c8}', '\u{30b2}', '\u{30f3}']), ('\u{3357}',
        &['\u{30ef}', '\u{30c3}', '\u{30c8}']), ('\u{3358}', &['\u{30}', '\u{70b9}']), ('\u{3359}',
        &['\u{31}', '\u{70b9}']), ('\u{335a}', &['\u{32}', '\u{70b9}']), ('\u{335b}', &['\u{33}',
        '\u{70b9}']), ('\u{335c}', &['\u{34}', '\u{70b9}']), ('\u{335d}', &['\u{35}', '\u{70b9}']),
        ('\u{335e}', &['\u{36}', '\u{70b9}']), ('\u{335f}', &['\u{37}', '\u{70b9}']), ('\u{3360}',
        &['\u{38}', '\u{70b9}']), ('\u{3361}', &['\u{39}', '\u{70b9}']), ('\u{3362}', &['\u{31}',
        '\u{30}', '\u{70b9}']), ('\u{3363}', &['\u{31}', '\u{31}', '\u{70b9}']), ('\u{3364}',
        &['\u{31}', '\u{32}', '\u{70b9}']), ('\u{3365}', &['\u{31}', '\u{33}', '\u{70b9}']),
        ('\u{3366}', &['\u{31}', '\u{34}', '\u{70b9}']), ('\u{3367}', &['\u{31}', '\u{35}',
        '\u{70b9}']), ('\u{3368}', &['\u{31}', '\u{36}', '\u{70b9}']), ('\u{3369}', &['\u{31}',
        '\u{37}', '\u{70b9}']), ('\u{336a}', &['\u{31}', '\u{38}', '\u{70b9}']), ('\u{336b}',
        &['\u{31}', '\u{39}', '\u{70b9}']), ('\u{336c}', &['\u{32}', '\u{30}', '\u{70b9}']),
        ('\u{336d}', &['\u{32}', '\u{31}', '\u{70b9}']), ('\u{336e}', &['\u{32}', '\u{32}',
        '\u{70b9}']), ('\u{336f}', &['\u{32}', '\u{33}', '\u{70b9}']), ('\u{3370}', &['\u{32}',
        '\u{34}', '\u{70b9}']), ('\u{3371}', &['\u{68}', '\u{50}', '\u{61}']), ('\u{3372}',
        &['\u{64}', '\u{61}']), ('\u{3373}', &['\u{41}', '\u{55}']), ('\u{3374}', &['\u{62}',
        '\u{61}', '\u{72}']), ('\u{3375}', &['\u{6f}', '\u{56}']), ('\u{3376}', &['\u{70}',
        '\u{63}']), ('\u{3377}', &['\u{64}', '\u{6d}']), ('\u{3378}', &['\u{64}', '\u{6d}',
        '\u{b2}']), ('\u{3379}', &['\u{64}', '\u{6d}', '\u{b3}']), ('\u{337a}', &['\u{49}',
        '\u{55}']), ('\u{337b}', &['\u{5e73}', '\u{6210}']), ('\u{337c}', &['\u{662d}',
        '\u{548c}']), ('\u{337d}', &['\u{5927}', '\u{6b63}']), ('\u{337e}', &['\u{660e}',
        '\u{6cbb}']), ('\u{337f}', &['\u{682a}', '\u{5f0f}', '\u{4f1a}', '\u{793e}']), ('\u{3380}',
        &['\u{70}', '\u{41}']), ('\u{3381}', &['\u{6e}', '\u{41}']), ('\u{3382}', &['\u{3bc}',
        '\u{41}']), ('\u{3383}', &['\u{6d}', '\u{41}']), ('\u{3384}', &['\u{6b}', '\u{41}']),
        ('\u{3385}', &['\u{4b}', '\u{42}']), ('\u{3386}', &['\u{4d}', '\u{42}']), ('\u{3387}',
        &['\u{47}', '\u{42}']), ('\u{3388}', &['\u{63}', '\u{61}', '\u{6c}']), ('\u{3389}',
        &['\u{6b}', '\u{63}', '\u{61}', '\u{6c}']), ('\u{338a}', &['\u{70}', '\u{46}']),
        ('\u{338b}', &['\u{6e}', '\u{46}']), ('\u{338c}', &['\u{3bc}', '\u{46}']), ('\u{338d}',
        &['\u{3bc}', '\u{67}']), ('\u{338e}', &['\u{6d}', '\u{67}']), ('\u{338f}', &['\u{6b}',
        '\u{67}']), ('\u{3390}', &['\u{48}', '\u{7a}']), ('\u{3391}', &['\u{6b}', '\u{48}',
        '\u{7a}']), ('\u{3392}', &['\u{4d}', '\u{48}', '\u{7a}']), ('\u{3393}', &['\u{47}',
        '\u{48}', '\u{7a}']), ('\u{3394}', &['\u{54}', '\u{48}', '\u{7a}']), ('\u{3395}',
        &['\u{3bc}', '\u{2113}']), ('\u{3396}', &['\u{6d}', '\u{2113}']), ('\u{3397}', &['\u{64}',
        '\u{2113}']), ('\u{3398}', &['\u{6b}', '\u{2113}']), ('\u{3399}', &['\u{66}', '\u{6d}']),
        ('\u{339a}', &['\u{6e}', '\u{6d}']), ('\u{339b}', &['\u{3bc}', '\u{6d}']), ('\u{339c}',
        &['\u{6d}', '\u{6d}']), ('\u{339d}', &['\u{63}', '\u{6d}']), ('\u{339e}', &['\u{6b}',
        '\u{6d}']), ('\u{339f}', &['\u{6d}', '\u{6d}', '\u{b2}']), ('\u{33a0}', &['\u{63}',
        '\u{6d}', '\u{b2}']), ('\u{33a1}', &['\u{6d}', '\u{b2}']), ('\u{33a2}', &['\u{6b}',
        '\u{6d}', '\u{b2}']), ('\u{33a3}', &['\u{6d}', '\u{6d}', '\u{b3}']), ('\u{33a4}',
        &['\u{63}', '\u{6d}', '\u{b3}']), ('\u{33a5}', &['\u{6d}', '\u{b3}']), ('\u{33a6}',
        &['\u{6b}', '\u{6d}', '\u{b3}']), ('\u{33a7}', &['\u{6d}', '\u{2215}', '\u{73}']),
        ('\u{33a8}', &['\u{6d}', '\u{2215}', '\u{73}', '\u{b2}']), ('\u{33a9}', &['\u{50}',
        '\u{61}']), ('\u{33aa}', &['\u{6b}', '\u{50}', '\u{61}']), ('\u{33ab}', &['\u{4d}',
        '\u{50}', '\u{61}']), ('\u{33ac}', &['\u{47}', '\u{50}', '\u{61}']), ('\u{33ad}',
        &['\u{72}', '\u{61}', '\u{64}']), ('\u{33ae}', &['\u{72}', '\u{61}', '\u{64}', '\u{2215}',
        '\u{73}']), ('\u{33af}', &['\u{72}', '\u{61}', '\u{64}', '\u{2215}', '\u{73}', '\u{b2}']),
        ('\u{33b0}', &['\u{70}', '\u{73}']), ('\u{33b1}', &['\u{6e}', '\u{73}']), ('\u{33b2}',
        &['\u{3bc}', '\u{73}']), ('\u{33b3}', &['\u{6d}', '\u{73}']), ('\u{33b4}', &['\u{70}',
        '\u{56}']), ('\u{33b5}', &['\u{6e}', '\u{56}']), ('\u{33b6}', &['\u{3bc}', '\u{56}']),
        ('\u{33b7}', &['\u{6d}', '\u{56}']), ('\u{33b8}', &['\u{6b}', '\u{56}']), ('\u{33b9}',
        &['\u{4d}', '\u{56}']), ('\u{33ba}', &['\u{70}', '\u{57}']), ('\u{33bb}', &['\u{6e}',
        '\u{57}']), ('\u{33bc}', &['\u{3bc}', '\u{57}']), ('\u{33bd}', &['\u{6d}', '\u{57}']),
        ('\u{33be}', &['\u{6b}', '\u{57}']), ('\u{33bf}', &['\u{4d}', '\u{57}']), ('\u{33c0}',
        &['\u{6b}', '\u{3a9}']), ('\u{33c1}', &['\u{4d}', '\u{3a9}']), ('\u{33c2}', &['\u{61}',
        '\u{2e}', '\u{6d}', '\u{2e}']), ('\u{33c3}', &['\u{42}', '\u{71}']), ('\u{33c4}',
        &['\u{63}', '\u{63}']), ('\u{33c5}', &['\u{63}', '\u{64}']), ('\u{33c6}', &['\u{43}',
        '\u{2215}', '\u{6b}', '\u{67}']), ('\u{33c7}', &['\u{43}', '\u{6f}', '\u{2e}']),
        ('\u{33c8}', &['\u{64}', '\u{42}']), ('\u{33c9}', &['\u{47}', '\u{79}']), ('\u{33ca}',
        &['\u{68}', '\u{61}']), ('\u{33cb}', &['\u{48}', '\u{50}']), ('\u{33cc}', &['\u{69}',
        '\u{6e}']), ('\u{33cd}', &['\u{4b}', '\u{4b}']), ('\u{33ce}', &['\u{4b}', '\u{4d}']),
        ('\u{33cf}', &['\u{6b}', '\u{74}']), ('\u{33d0}', &['\u{6c}', '\u{6d}']), ('\u{33d1}',
        &['\u{6c}', '\u{6e}']), ('\u{33d2}', &['\u{6c}', '\u{6f}', '\u{67}']), ('\u{33d3}',
        &['\u{6c}', '\u{78}']), ('\u{33d4}', &['\u{6d}', '\u{62}']), ('\u{33d5}', &['\u{6d}',
        '\u{69}', '\u{6c}']), ('\u{33d6}', &['\u{6d}', '\u{6f}', '\u{6c}']), ('\u{33d7}',
        &['\u{50}', '\u{48}']), ('\u{33d8}', &['\u{70}', '\u{2e}', '\u{6d}', '\u{2e}']),
        ('\u{33d9}', &['\u{50}', '\u{50}', '\u{4d}']), ('\u{33da}', &['\u{50}', '\u{52}']),
        ('\u{33db}', &['\u{73}', '\u{72}']), ('\u{33dc}', &['\u{53}', '\u{76}']), ('\u{33dd}',
        &['\u{57}', '\u{62}']), ('\u{33de}', &['\u{56}', '\u{2215}', '\u{6d}']), ('\u{33df}',
        &['\u{41}', '\u{2215}', '\u{6d}']), ('\u{33e0}', &['\u{31}', '\u{65e5}']), ('\u{33e1}',
        &['\u{32}', '\u{65e5}']), ('\u{33e2}', &['\u{33}', '\u{65e5}']), ('\u{33e3}', &['\u{34}',
        '\u{65e5}']), ('\u{33e4}', &['\u{35}', '\u{65e5}']), ('\u{33e5}', &['\u{36}', '\u{65e5}']),
        ('\u{33e6}', &['\u{37}', '\u{65e5}']), ('\u{33e7}', &['\u{38}', '\u{65e5}']), ('\u{33e8}',
        &['\u{39}', '\u{65e5}']), ('\u{33e9}', &['\u{31}', '\u{30}', '\u{65e5}']), ('\u{33ea}',
        &['\u{31}', '\u{31}', '\u{65e5}']), ('\u{33eb}', &['\u{31}', '\u{32}', '\u{65e5}']),
        ('\u{33ec}', &['\u{31}', '\u{33}', '\u{65e5}']), ('\u{33ed}', &['\u{31}', '\u{34}',
        '\u{65e5}']), ('\u{33ee}', &['\u{31}', '\u{35}', '\u{65e5}']), ('\u{33ef}', &['\u{31}',
        '\u{36}', '\u{65e5}']), ('\u{33f0}', &['\u{31}', '\u{37}', '\u{65e5}']), ('\u{33f1}',
        &['\u{31}', '\u{38}', '\u{65e5}']), ('\u{33f2}', &['\u{31}', '\u{39}', '\u{65e5}']),
        ('\u{33f3}', &['\u{32}', '\u{30}', '\u{65e5}']), ('\u{33f4}', &['\u{32}', '\u{31}',
        '\u{65e5}']), ('\u{33f5}', &['\u{32}', '\u{32}', '\u{65e5}']), ('\u{33f6}', &['\u{32}',
        '\u{33}', '\u{65e5}']), ('\u{33f7}', &['\u{32}', '\u{34}', '\u{65e5}']), ('\u{33f8}',
        &['\u{32}', '\u{35}', '\u{65e5}']), ('\u{33f9}', &['\u{32}', '\u{36}', '\u{65e5}']),
        ('\u{33fa}', &['\u{32}', '\u{37}', '\u{65e5}']), ('\u{33fb}', &['\u{32}', '\u{38}',
        '\u{65e5}']), ('\u{33fc}', &['\u{32}', '\u{39}', '\u{65e5}']), ('\u{33fd}', &['\u{33}',
        '\u{30}', '\u{65e5}']), ('\u{33fe}', &['\u{33}', '\u{31}', '\u{65e5}']), ('\u{33ff}',
        &['\u{67}', '\u{61}', '\u{6c}']), ('\u{a69c}', &['\u{44a}']), ('\u{a69d}', &['\u{44c}']),
        ('\u{a770}', &['\u{a76f}']), ('\u{a7f8}', &['\u{126}']), ('\u{a7f9}', &['\u{153}']),
        ('\u{ab5c}', &['\u{a727}']), ('\u{ab5d}', &['\u{ab37}']), ('\u{ab5e}', &['\u{26b}']),
        ('\u{ab5f}', &['\u{ab52}']), ('\u{fb00}', &['\u{66}', '\u{66}']), ('\u{fb01}', &['\u{66}',
        '\u{69}']), ('\u{fb02}', &['\u{66}', '\u{6c}']), ('\u{fb03}', &['\u{66}', '\u{66}',
        '\u{69}']), ('\u{fb04}', &['\u{66}', '\u{66}', '\u{6c}']), ('\u{fb05}', &['\u{17f}',
        '\u{74}']), ('\u{fb06}', &['\u{73}', '\u{74}']), ('\u{fb13}', &['\u{574}', '\u{576}']),
        ('\u{fb14}', &['\u{574}', '\u{565}']), ('\u{fb15}', &['\u{574}', '\u{56b}']), ('\u{fb16}',
        &['\u{57e}', '\u{576}']), ('\u{fb17}', &['\u{574}', '\u{56d}']), ('\u{fb20}', &['\u{5e2}']),
        ('\u{fb21}', &['\u{5d0}']), ('\u{fb22}', &['\u{5d3}']), ('\u{fb23}', &['\u{5d4}']),
        ('\u{fb24}', &['\u{5db}']), ('\u{fb25}', &['\u{5dc}']), ('\u{fb26}', &['\u{5dd}']),
        ('\u{fb27}', &['\u{5e8}']), ('\u{fb28}', &['\u{5ea}']), ('\u{fb29}', &['\u{2b}']),
        ('\u{fb4f}', &['\u{5d0}', '\u{5dc}']), ('\u{fb50}', &['\u{671}']), ('\u{fb51}',
        &['\u{671}']), ('\u{fb52}', &['\u{67b}']), ('\u{fb53}', &['\u{67b}']), ('\u{fb54}',
        &['\u{67b}']), ('\u{fb55}', &['\u{67b}']), ('\u{fb56}', &['\u{67e}']), ('\u{fb57}',
        &['\u{67e}']), ('\u{fb58}', &['\u{67e}']), ('\u{fb59}', &['\u{67e}']), ('\u{fb5a}',
        &['\u{680}']), ('\u{fb5b}', &['\u{680}']), ('\u{fb5c}', &['\u{680}']), ('\u{fb5d}',
        &['\u{680}']), ('\u{fb5e}', &['\u{67a}']), ('\u{fb5f}', &['\u{67a}']), ('\u{fb60}',
        &['\u{67a}']), ('\u{fb61}', &['\u{67a}']), ('\u{fb62}', &['\u{67f}']), ('\u{fb63}',
        &['\u{67f}']), ('\u{fb64}', &['\u{67f}']), ('\u{fb65}', &['\u{67f}']), ('\u{fb66}',
        &['\u{679}']), ('\u{fb67}', &['\u{679}']), ('\u{fb68}', &['\u{679}']), ('\u{fb69}',
        &['\u{679}']), ('\u{fb6a}', &['\u{6a4}']), ('\u{fb6b}', &['\u{6a4}']), ('\u{fb6c}',
        &['\u{6a4}']), ('\u{fb6d}', &['\u{6a4}']), ('\u{fb6e}', &['\u{6a6}']), ('\u{fb6f}',
        &['\u{6a6}']), ('\u{fb70}', &['\u{6a6}']), ('\u{fb71}', &['\u{6a6}']), ('\u{fb72}',
        &['\u{684}']), ('\u{fb73}', &['\u{684}']), ('\u{fb74}', &['\u{684}']), ('\u{fb75}',
        &['\u{684}']), ('\u{fb76}', &['\u{683}']), ('\u{fb77}', &['\u{683}']), ('\u{fb78}',
        &['\u{683}']), ('\u{fb79}', &['\u{683}']), ('\u{fb7a}', &['\u{686}']), ('\u{fb7b}',
        &['\u{686}']), ('\u{fb7c}', &['\u{686}']), ('\u{fb7d}', &['\u{686}']), ('\u{fb7e}',
        &['\u{687}']), ('\u{fb7f}', &['\u{687}']), ('\u{fb80}', &['\u{687}']), ('\u{fb81}',
        &['\u{687}']), ('\u{fb82}', &['\u{68d}']), ('\u{fb83}', &['\u{68d}']), ('\u{fb84}',
        &['\u{68c}']), ('\u{fb85}', &['\u{68c}']), ('\u{fb86}', &['\u{68e}']), ('\u{fb87}',
        &['\u{68e}']), ('\u{fb88}', &['\u{688}']), ('\u{fb89}', &['\u{688}']), ('\u{fb8a}',
        &['\u{698}']), ('\u{fb8b}', &['\u{698}']), ('\u{fb8c}', &['\u{691}']), ('\u{fb8d}',
        &['\u{691}']), ('\u{fb8e}', &['\u{6a9}']), ('\u{fb8f}', &['\u{6a9}']), ('\u{fb90}',
        &['\u{6a9}']), ('\u{fb91}', &['\u{6a9}']), ('\u{fb92}', &['\u{6af}']), ('\u{fb93}',
        &['\u{6af}']), ('\u{fb94}', &['\u{6af}']), ('\u{fb95}', &['\u{6af}']), ('\u{fb96}',
        &['\u{6b3}']), ('\u{fb97}', &['\u{6b3}']), ('\u{fb98}', &['\u{6b3}']), ('\u{fb99}',
        &['\u{6b3}']), ('\u{fb9a}', &['\u{6b1}']), ('\u{fb9b}', &['\u{6b1}']), ('\u{fb9c}',
        &['\u{6b1}']), ('\u{fb9d}', &['\u{6b1}']), ('\u{fb9e}', &['\u{6ba}']), ('\u{fb9f}',
        &['\u{6ba}']), ('\u{fba0}', &['\u{6bb}']), ('\u{fba1}', &['\u{6bb}']), ('\u{fba2}',
        &['\u{6bb}']), ('\u{fba3}', &['\u{6bb}']), ('\u{fba4}', &['\u{6c0}']), ('\u{fba5}',
        &['\u{6c0}']), ('\u{fba6}', &['\u{6c1}']), ('\u{fba7}', &['\u{6c1}']), ('\u{fba8}',
        &['\u{6c1}']), ('\u{fba9}', &['\u{6c1}']), ('\u{fbaa}', &['\u{6be}']), ('\u{fbab}',
        &['\u{6be}']), ('\u{fbac}', &['\u{6be}']), ('\u{fbad}', &['\u{6be}']), ('\u{fbae}',
        &['\u{6d2}']), ('\u{fbaf}', &['\u{6d2}']), ('\u{fbb0}', &['\u{6d3}']), ('\u{fbb1}',
        &['\u{6d3}']), ('\u{fbd3}', &['\u{6ad}']), ('\u{fbd4}', &['\u{6ad}']), ('\u{fbd5}',
        &['\u{6ad}']), ('\u{fbd6}', &['\u{6ad}']), ('\u{fbd7}', &['\u{6c7}']), ('\u{fbd8}',
        &['\u{6c7}']), ('\u{fbd9}', &['\u{6c6}']), ('\u{fbda}', &['\u{6c6}']), ('\u{fbdb}',
        &['\u{6c8}']), ('\u{fbdc}', &['\u{6c8}']), ('\u{fbdd}', &['\u{677}']), ('\u{fbde}',
        &['\u{6cb}']), ('\u{fbdf}', &['\u{6cb}']), ('\u{fbe0}', &['\u{6c5}']), ('\u{fbe1}',
        &['\u{6c5}']), ('\u{fbe2}', &['\u{6c9}']), ('\u{fbe3}', &['\u{6c9}']), ('\u{fbe4}',
        &['\u{6d0}']), ('\u{fbe5}', &['\u{6d0}']), ('\u{fbe6}', &['\u{6d0}']), ('\u{fbe7}',
        &['\u{6d0}']), ('\u{fbe8}', &['\u{649}']), ('\u{fbe9}', &['\u{649}']), ('\u{fbea}',
        &['\u{626}', '\u{627}']), ('\u{fbeb}', &['\u{626}', '\u{627}']), ('\u{fbec}', &['\u{626}',
        '\u{6d5}']), ('\u{fbed}', &['\u{626}', '\u{6d5}']), ('\u{fbee}', &['\u{626}', '\u{648}']),
        ('\u{fbef}', &['\u{626}', '\u{648}']), ('\u{fbf0}', &['\u{626}', '\u{6c7}']), ('\u{fbf1}',
        &['\u{626}', '\u{6c7}']), ('\u{fbf2}', &['\u{626}', '\u{6c6}']), ('\u{fbf3}', &['\u{626}',
        '\u{6c6}']), ('\u{fbf4}', &['\u{626}', '\u{6c8}']), ('\u{fbf5}', &['\u{626}', '\u{6c8}']),
        ('\u{fbf6}', &['\u{626}', '\u{6d0}']), ('\u{fbf7}', &['\u{626}', '\u{6d0}']), ('\u{fbf8}',
        &['\u{626}', '\u{6d0}']), ('\u{fbf9}', &['\u{626}', '\u{649}']), ('\u{fbfa}', &['\u{626}',
        '\u{649}']), ('\u{fbfb}', &['\u{626}', '\u{649}']), ('\u{fbfc}', &['\u{6cc}']), ('\u{fbfd}',
        &['\u{6cc}']), ('\u{fbfe}', &['\u{6cc}']), ('\u{fbff}', &['\u{6cc}']), ('\u{fc00}',
        &['\u{626}', '\u{62c}']), ('\u{fc01}', &['\u{626}', '\u{62d}']), ('\u{fc02}', &['\u{626}',
        '\u{645}']), ('\u{fc03}', &['\u{626}', '\u{649}']), ('\u{fc04}', &['\u{626}', '\u{64a}']),
        ('\u{fc05}', &['\u{628}', '\u{62c}']), ('\u{fc06}', &['\u{628}', '\u{62d}']), ('\u{fc07}',
        &['\u{628}', '\u{62e}']), ('\u{fc08}', &['\u{628}', '\u{645}']), ('\u{fc09}', &['\u{628}',
        '\u{649}']), ('\u{fc0a}', &['\u{628}', '\u{64a}']), ('\u{fc0b}', &['\u{62a}', '\u{62c}']),
        ('\u{fc0c}', &['\u{62a}', '\u{62d}']), ('\u{fc0d}', &['\u{62a}', '\u{62e}']), ('\u{fc0e}',
        &['\u{62a}', '\u{645}']), ('\u{fc0f}', &['\u{62a}', '\u{649}']), ('\u{fc10}', &['\u{62a}',
        '\u{64a}']), ('\u{fc11}', &['\u{62b}', '\u{62c}']), ('\u{fc12}', &['\u{62b}', '\u{645}']),
        ('\u{fc13}', &['\u{62b}', '\u{649}']), ('\u{fc14}', &['\u{62b}', '\u{64a}']), ('\u{fc15}',
        &['\u{62c}', '\u{62d}']), ('\u{fc16}', &['\u{62c}', '\u{645}']), ('\u{fc17}', &['\u{62d}',
        '\u{62c}']), ('\u{fc18}', &['\u{62d}', '\u{645}']), ('\u{fc19}', &['\u{62e}', '\u{62c}']),
        ('\u{fc1a}', &['\u{62e}', '\u{62d}']), ('\u{fc1b}', &['\u{62e}', '\u{645}']), ('\u{fc1c}',
        &['\u{633}', '\u{62c}']), ('\u{fc1d}', &['\u{633}', '\u{62d}']), ('\u{fc1e}', &['\u{633}',
        '\u{62e}']), ('\u{fc1f}', &['\u{633}', '\u{645}']), ('\u{fc20}', &['\u{635}', '\u{62d}']),
        ('\u{fc21}', &['\u{635}', '\u{645}']), ('\u{fc22}', &['\u{636}', '\u{62c}']), ('\u{fc23}',
        &['\u{636}', '\u{62d}']), ('\u{fc24}', &['\u{636}', '\u{62e}']), ('\u{fc25}', &['\u{636}',
        '\u{645}']), ('\u{fc26}', &['\u{637}', '\u{62d}']), ('\u{fc27}', &['\u{637}', '\u{645}']),
        ('\u{fc28}', &['\u{638}', '\u{645}']), ('\u{fc29}', &['\u{639}', '\u{62c}']), ('\u{fc2a}',
        &['\u{639}', '\u{645}']), ('\u{fc2b}', &['\u{63a}', '\u{62c}']), ('\u{fc2c}', &['\u{63a}',
        '\u{645}']), ('\u{fc2d}', &['\u{641}', '\u{62c}']), ('\u{fc2e}', &['\u{641}', '\u{62d}']),
        ('\u{fc2f}', &['\u{641}', '\u{62e}']), ('\u{fc30}', &['\u{641}', '\u{645}']), ('\u{fc31}',
        &['\u{641}', '\u{649}']), ('\u{fc32}', &['\u{641}', '\u{64a}']), ('\u{fc33}', &['\u{642}',
        '\u{62d}']), ('\u{fc34}', &['\u{642}', '\u{645}']), ('\u{fc35}', &['\u{642}', '\u{649}']),
        ('\u{fc36}', &['\u{642}', '\u{64a}']), ('\u{fc37}', &['\u{643}', '\u{627}']), ('\u{fc38}',
        &['\u{643}', '\u{62c}']), ('\u{fc39}', &['\u{643}', '\u{62d}']), ('\u{fc3a}', &['\u{643}',
        '\u{62e}']), ('\u{fc3b}', &['\u{643}', '\u{644}']), ('\u{fc3c}', &['\u{643}', '\u{645}']),
        ('\u{fc3d}', &['\u{643}', '\u{649}']), ('\u{fc3e}', &['\u{643}', '\u{64a}']), ('\u{fc3f}',
        &['\u{644}', '\u{62c}']), ('\u{fc40}', &['\u{644}', '\u{62d}']), ('\u{fc41}', &['\u{644}',
        '\u{62e}']), ('\u{fc42}', &['\u{644}', '\u{645}']), ('\u{fc43}', &['\u{644}', '\u{649}']),
        ('\u{fc44}', &['\u{644}', '\u{64a}']), ('\u{fc45}', &['\u{645}', '\u{62c}']), ('\u{fc46}',
        &['\u{645}', '\u{62d}']), ('\u{fc47}', &['\u{645}', '\u{62e}']), ('\u{fc48}', &['\u{645}',
        '\u{645}']), ('\u{fc49}', &['\u{645}', '\u{649}']), ('\u{fc4a}', &['\u{645}', '\u{64a}']),
        ('\u{fc4b}', &['\u{646}', '\u{62c}']), ('\u{fc4c}', &['\u{646}', '\u{62d}']), ('\u{fc4d}',
        &['\u{646}', '\u{62e}']), ('\u{fc4e}', &['\u{646}', '\u{645}']), ('\u{fc4f}', &['\u{646}',
        '\u{649}']), ('\u{fc50}', &['\u{646}', '\u{64a}']), ('\u{fc51}', &['\u{647}', '\u{62c}']),
        ('\u{fc52}', &['\u{647}', '\u{645}']), ('\u{fc53}', &['\u{647}', '\u{649}']), ('\u{fc54}',
        &['\u{647}', '\u{64a}']), ('\u{fc55}', &['\u{64a}', '\u{62c}']), ('\u{fc56}', &['\u{64a}',
        '\u{62d}']), ('\u{fc57}', &['\u{64a}', '\u{62e}']), ('\u{fc58}', &['\u{64a}', '\u{645}']),
        ('\u{fc59}', &['\u{64a}', '\u{649}']), ('\u{fc5a}', &['\u{64a}', '\u{64a}']), ('\u{fc5b}',
        &['\u{630}', '\u{670}']), ('\u{fc5c}', &['\u{631}', '\u{670}']), ('\u{fc5d}', &['\u{649}',
        '\u{670}']), ('\u{fc5e}', &['\u{20}', '\u{64c}', '\u{651}']), ('\u{fc5f}', &['\u{20}',
        '\u{64d}', '\u{651}']), ('\u{fc60}', &['\u{20}', '\u{64e}', '\u{651}']), ('\u{fc61}',
        &['\u{20}', '\u{64f}', '\u{651}']), ('\u{fc62}', &['\u{20}', '\u{650}', '\u{651}']),
        ('\u{fc63}', &['\u{20}', '\u{651}', '\u{670}']), ('\u{fc64}', &['\u{626}', '\u{631}']),
        ('\u{fc65}', &['\u{626}', '\u{632}']), ('\u{fc66}', &['\u{626}', '\u{645}']), ('\u{fc67}',
        &['\u{626}', '\u{646}']), ('\u{fc68}', &['\u{626}', '\u{649}']), ('\u{fc69}', &['\u{626}',
        '\u{64a}']), ('\u{fc6a}', &['\u{628}', '\u{631}']), ('\u{fc6b}', &['\u{628}', '\u{632}']),
        ('\u{fc6c}', &['\u{628}', '\u{645}']), ('\u{fc6d}', &['\u{628}', '\u{646}']), ('\u{fc6e}',
        &['\u{628}', '\u{649}']), ('\u{fc6f}', &['\u{628}', '\u{64a}']), ('\u{fc70}', &['\u{62a}',
        '\u{631}']), ('\u{fc71}', &['\u{62a}', '\u{632}']), ('\u{fc72}', &['\u{62a}', '\u{645}']),
        ('\u{fc73}', &['\u{62a}', '\u{646}']), ('\u{fc74}', &['\u{62a}', '\u{649}']), ('\u{fc75}',
        &['\u{62a}', '\u{64a}']), ('\u{fc76}', &['\u{62b}', '\u{631}']), ('\u{fc77}', &['\u{62b}',
        '\u{632}']), ('\u{fc78}', &['\u{62b}', '\u{645}']), ('\u{fc79}', &['\u{62b}', '\u{646}']),
        ('\u{fc7a}', &['\u{62b}', '\u{649}']), ('\u{fc7b}', &['\u{62b}', '\u{64a}']), ('\u{fc7c}',
        &['\u{641}', '\u{649}']), ('\u{fc7d}', &['\u{641}', '\u{64a}']), ('\u{fc7e}', &['\u{642}',
        '\u{649}']), ('\u{fc7f}', &['\u{642}', '\u{64a}']), ('\u{fc80}', &['\u{643}', '\u{627}']),
        ('\u{fc81}', &['\u{643}', '\u{644}']), ('\u{fc82}', &['\u{643}', '\u{645}']), ('\u{fc83}',
        &['\u{643}', '\u{649}']), ('\u{fc84}', &['\u{643}', '\u{64a}']), ('\u{fc85}', &['\u{644}',
        '\u{645}']), ('\u{fc86}', &['\u{644}', '\u{649}']), ('\u{fc87}', &['\u{644}', '\u{64a}']),
        ('\u{fc88}', &['\u{645}', '\u{627}']), ('\u{fc89}', &['\u{645}', '\u{645}']), ('\u{fc8a}',
        &['\u{646}', '\u{631}']), ('\u{fc8b}', &['\u{646}', '\u{632}']), ('\u{fc8c}', &['\u{646}',
        '\u{645}']), ('\u{fc8d}', &['\u{646}', '\u{646}']), ('\u{fc8e}', &['\u{646}', '\u{649}']),
        ('\u{fc8f}', &['\u{646}', '\u{64a}']), ('\u{fc90}', &['\u{649}', '\u{670}']), ('\u{fc91}',
        &['\u{64a}', '\u{631}']), ('\u{fc92}', &['\u{64a}', '\u{632}']), ('\u{fc93}', &['\u{64a}',
        '\u{645}']), ('\u{fc94}', &['\u{64a}', '\u{646}']), ('\u{fc95}', &['\u{64a}', '\u{649}']),
        ('\u{fc96}', &['\u{64a}', '\u{64a}']), ('\u{fc97}', &['\u{626}', '\u{62c}']), ('\u{fc98}',
        &['\u{626}', '\u{62d}']), ('\u{fc99}', &['\u{626}', '\u{62e}']), ('\u{fc9a}', &['\u{626}',
        '\u{645}']), ('\u{fc9b}', &['\u{626}', '\u{647}']), ('\u{fc9c}', &['\u{628}', '\u{62c}']),
        ('\u{fc9d}', &['\u{628}', '\u{62d}']), ('\u{fc9e}', &['\u{628}', '\u{62e}']), ('\u{fc9f}',
        &['\u{628}', '\u{645}']), ('\u{fca0}', &['\u{628}', '\u{647}']), ('\u{fca1}', &['\u{62a}',
        '\u{62c}']), ('\u{fca2}', &['\u{62a}', '\u{62d}']), ('\u{fca3}', &['\u{62a}', '\u{62e}']),
        ('\u{fca4}', &['\u{62a}', '\u{645}']), ('\u{fca5}', &['\u{62a}', '\u{647}']), ('\u{fca6}',
        &['\u{62b}', '\u{645}']), ('\u{fca7}', &['\u{62c}', '\u{62d}']), ('\u{fca8}', &['\u{62c}',
        '\u{645}']), ('\u{fca9}', &['\u{62d}', '\u{62c}']), ('\u{fcaa}', &['\u{62d}', '\u{645}']),
        ('\u{fcab}', &['\u{62e}', '\u{62c}']), ('\u{fcac}', &['\u{62e}', '\u{645}']), ('\u{fcad}',
        &['\u{633}', '\u{62c}']), ('\u{fcae}', &['\u{633}', '\u{62d}']), ('\u{fcaf}', &['\u{633}',
        '\u{62e}']), ('\u{fcb0}', &['\u{633}', '\u{645}']), ('\u{fcb1}', &['\u{635}', '\u{62d}']),
        ('\u{fcb2}', &['\u{635}', '\u{62e}']), ('\u{fcb3}', &['\u{635}', '\u{645}']), ('\u{fcb4}',
        &['\u{636}', '\u{62c}']), ('\u{fcb5}', &['\u{636}', '\u{62d}']), ('\u{fcb6}', &['\u{636}',
        '\u{62e}']), ('\u{fcb7}', &['\u{636}', '\u{645}']), ('\u{fcb8}', &['\u{637}', '\u{62d}']),
        ('\u{fcb9}', &['\u{638}', '\u{645}']), ('\u{fcba}', &['\u{639}', '\u{62c}']), ('\u{fcbb}',
        &['\u{639}', '\u{645}']), ('\u{fcbc}', &['\u{63a}', '\u{62c}']), ('\u{fcbd}', &['\u{63a}',
        '\u{645}']), ('\u{fcbe}', &['\u{641}', '\u{62c}']), ('\u{fcbf}', &['\u{641}', '\u{62d}']),
        ('\u{fcc0}', &['\u{641}', '\u{62e}']), ('\u{fcc1}', &['\u{641}', '\u{645}']), ('\u{fcc2}',
        &['\u{642}', '\u{62d}']), ('\u{fcc3}', &['\u{642}', '\u{645}']), ('\u{fcc4}', &['\u{643}',
        '\u{62c}']), ('\u{fcc5}', &['\u{643}', '\u{62d}']), ('\u{fcc6}', &['\u{643}', '\u{62e}']),
        ('\u{fcc7}', &['\u{643}', '\u{644}']), ('\u{fcc8}', &['\u{643}', '\u{645}']), ('\u{fcc9}',
        &['\u{644}', '\u{62c}']), ('\u{fcca}', &['\u{644}', '\u{62d}']), ('\u{fccb}', &['\u{644}',
        '\u{62e}']), ('\u{fccc}', &['\u{644}', '\u{645}']), ('\u{fccd}', &['\u{644}', '\u{647}']),
        ('\u{fcce}', &['\u{645}', '\u{62c}']), ('\u{fccf}', &['\u{645}', '\u{62d}']), ('\u{fcd0}',
        &['\u{645}', '\u{62e}']), ('\u{fcd1}', &['\u{645}', '\u{645}']), ('\u{fcd2}', &['\u{646}',
        '\u{62c}']), ('\u{fcd3}', &['\u{646}', '\u{62d}']), ('\u{fcd4}', &['\u{646}', '\u{62e}']),
        ('\u{fcd5}', &['\u{646}', '\u{645}']), ('\u{fcd6}', &['\u{646}', '\u{647}']), ('\u{fcd7}',
        &['\u{647}', '\u{62c}']), ('\u{fcd8}', &['\u{647}', '\u{645}']), ('\u{fcd9}', &['\u{647}',
        '\u{670}']), ('\u{fcda}', &['\u{64a}', '\u{62c}']), ('\u{fcdb}', &['\u{64a}', '\u{62d}']),
        ('\u{fcdc}', &['\u{64a}', '\u{62e}']), ('\u{fcdd}', &['\u{64a}', '\u{645}']), ('\u{fcde}',
        &['\u{64a}', '\u{647}']), ('\u{fcdf}', &['\u{626}', '\u{645}']), ('\u{fce0}', &['\u{626}',
        '\u{647}']), ('\u{fce1}', &['\u{628}', '\u{645}']), ('\u{fce2}', &['\u{628}', '\u{647}']),
        ('\u{fce3}', &['\u{62a}', '\u{645}']), ('\u{fce4}', &['\u{62a}', '\u{647}']), ('\u{fce5}',
        &['\u{62b}', '\u{645}']), ('\u{fce6}', &['\u{62b}', '\u{647}']), ('\u{fce7}', &['\u{633}',
        '\u{645}']), ('\u{fce8}', &['\u{633}', '\u{647}']), ('\u{fce9}', &['\u{634}', '\u{645}']),
        ('\u{fcea}', &['\u{634}', '\u{647}']), ('\u{fceb}', &['\u{643}', '\u{644}']), ('\u{fcec}',
        &['\u{643}', '\u{645}']), ('\u{fced}', &['\u{644}', '\u{645}']), ('\u{fcee}', &['\u{646}',
        '\u{645}']), ('\u{fcef}', &['\u{646}', '\u{647}']), ('\u{fcf0}', &['\u{64a}', '\u{645}']),
        ('\u{fcf1}', &['\u{64a}', '\u{647}']), ('\u{fcf2}', &['\u{640}', '\u{64e}', '\u{651}']),
        ('\u{fcf3}', &['\u{640}', '\u{64f}', '\u{651}']), ('\u{fcf4}', &['\u{640}', '\u{650}',
        '\u{651}']), ('\u{fcf5}', &['\u{637}', '\u{649}']), ('\u{fcf6}', &['\u{637}', '\u{64a}']),
        ('\u{fcf7}', &['\u{639}', '\u{649}']), ('\u{fcf8}', &['\u{639}', '\u{64a}']), ('\u{fcf9}',
        &['\u{63a}', '\u{649}']), ('\u{fcfa}', &['\u{63a}', '\u{64a}']), ('\u{fcfb}', &['\u{633}',
        '\u{649}']), ('\u{fcfc}', &['\u{633}', '\u{64a}']), ('\u{fcfd}', &['\u{634}', '\u{649}']),
        ('\u{fcfe}', &['\u{634}', '\u{64a}']), ('\u{fcff}', &['\u{62d}', '\u{649}']), ('\u{fd00}',
        &['\u{62d}', '\u{64a}']), ('\u{fd01}', &['\u{62c}', '\u{649}']), ('\u{fd02}', &['\u{62c}',
        '\u{64a}']), ('\u{fd03}', &['\u{62e}', '\u{649}']), ('\u{fd04}', &['\u{62e}', '\u{64a}']),
        ('\u{fd05}', &['\u{635}', '\u{649}']), ('\u{fd06}', &['\u{635}', '\u{64a}']), ('\u{fd07}',
        &['\u{636}', '\u{649}']), ('\u{fd08}', &['\u{636}', '\u{64a}']), ('\u{fd09}', &['\u{634}',
        '\u{62c}']), ('\u{fd0a}', &['\u{634}', '\u{62d}']), ('\u{fd0b}', &['\u{634}', '\u{62e}']),
        ('\u{fd0c}', &['\u{634}', '\u{645}']), ('\u{fd0d}', &['\u{634}', '\u{631}']), ('\u{fd0e}',
        &['\u{633}', '\u{631}']), ('\u{fd0f}', &['\u{635}', '\u{631}']), ('\u{fd10}', &['\u{636}',
        '\u{631}']), ('\u{fd11}', &['\u{637}', '\u{649}']), ('\u{fd12}', &['\u{637}', '\u{64a}']),
        ('\u{fd13}', &['\u{639}', '\u{649}']), ('\u{fd14}', &['\u{639}', '\u{64a}']), ('\u{fd15}',
        &['\u{63a}', '\u{649}']), ('\u{fd16}', &['\u{63a}', '\u{64a}']), ('\u{fd17}', &['\u{633}',
        '\u{649}']), ('\u{fd18}', &['\u{633}', '\u{64a}']), ('\u{fd19}', &['\u{634}', '\u{649}']),
        ('\u{fd1a}', &['\u{634}', '\u{64a}']), ('\u{fd1b}', &['\u{62d}', '\u{649}']), ('\u{fd1c}',
        &['\u{62d}', '\u{64a}']), ('\u{fd1d}', &['\u{62c}', '\u{649}']), ('\u{fd1e}', &['\u{62c}',
        '\u{64a}']), ('\u{fd1f}', &['\u{62e}', '\u{649}']), ('\u{fd20}', &['\u{62e}', '\u{64a}']),
        ('\u{fd21}', &['\u{635}', '\u{649}']), ('\u{fd22}', &['\u{635}', '\u{64a}']), ('\u{fd23}',
        &['\u{636}', '\u{649}']), ('\u{fd24}', &['\u{636}', '\u{64a}']), ('\u{fd25}', &['\u{634}',
        '\u{62c}']), ('\u{fd26}', &['\u{634}', '\u{62d}']), ('\u{fd27}', &['\u{634}', '\u{62e}']),
        ('\u{fd28}', &['\u{634}', '\u{645}']), ('\u{fd29}', &['\u{634}', '\u{631}']), ('\u{fd2a}',
        &['\u{633}', '\u{631}']), ('\u{fd2b}', &['\u{635}', '\u{631}']), ('\u{fd2c}', &['\u{636}',
        '\u{631}']), ('\u{fd2d}', &['\u{634}', '\u{62c}']), ('\u{fd2e}', &['\u{634}', '\u{62d}']),
        ('\u{fd2f}', &['\u{634}', '\u{62e}']), ('\u{fd30}', &['\u{634}', '\u{645}']), ('\u{fd31}',
        &['\u{633}', '\u{647}']), ('\u{fd32}', &['\u{634}', '\u{647}']), ('\u{fd33}', &['\u{637}',
        '\u{645}']), ('\u{fd34}', &['\u{633}', '\u{62c}']), ('\u{fd35}', &['\u{633}', '\u{62d}']),
        ('\u{fd36}', &['\u{633}', '\u{62e}']), ('\u{fd37}', &['\u{634}', '\u{62c}']), ('\u{fd38}',
        &['\u{634}', '\u{62d}']), ('\u{fd39}', &['\u{634}', '\u{62e}']), ('\u{fd3a}', &['\u{637}',
        '\u{645}']), ('\u{fd3b}', &['\u{638}', '\u{645}']), ('\u{fd3c}', &['\u{627}', '\u{64b}']),
        ('\u{fd3d}', &['\u{627}', '\u{64b}']), ('\u{fd50}', &['\u{62a}', '\u{62c}', '\u{645}']),
        ('\u{fd51}', &['\u{62a}', '\u{62d}', '\u{62c}']), ('\u{fd52}', &['\u{62a}', '\u{62d}',
        '\u{62c}']), ('\u{fd53}', &['\u{62a}', '\u{62d}', '\u{645}']), ('\u{fd54}', &['\u{62a}',
        '\u{62e}', '\u{645}']), ('\u{fd55}', &['\u{62a}', '\u{645}', '\u{62c}']), ('\u{fd56}',
        &['\u{62a}', '\u{645}', '\u{62d}']), ('\u{fd57}', &['\u{62a}', '\u{645}', '\u{62e}']),
        ('\u{fd58}', &['\u{62c}', '\u{645}', '\u{62d}']), ('\u{fd59}', &['\u{62c}', '\u{645}',
        '\u{62d}']), ('\u{fd5a}', &['\u{62d}', '\u{645}', '\u{64a}']), ('\u{fd5b}', &['\u{62d}',
        '\u{645}', '\u{649}']), ('\u{fd5c}', &['\u{633}', '\u{62d}', '\u{62c}']), ('\u{fd5d}',
        &['\u{633}', '\u{62c}', '\u{62d}']), ('\u{fd5e}', &['\u{633}', '\u{62c}', '\u{649}']),
        ('\u{fd5f}', &['\u{633}', '\u{645}', '\u{62d}']), ('\u{fd60}', &['\u{633}', '\u{645}',
        '\u{62d}']), ('\u{fd61}', &['\u{633}', '\u{645}', '\u{62c}']), ('\u{fd62}', &['\u{633}',
        '\u{645}', '\u{645}']), ('\u{fd63}', &['\u{633}', '\u{645}', '\u{645}']), ('\u{fd64}',
        &['\u{635}', '\u{62d}', '\u{62d}']), ('\u{fd65}', &['\u{635}', '\u{62d}', '\u{62d}']),
        ('\u{fd66}', &['\u{635}', '\u{645}', '\u{645}']), ('\u{fd67}', &['\u{634}', '\u{62d}',
        '\u{645}']), ('\u{fd68}', &['\u{634}', '\u{62d}', '\u{645}']), ('\u{fd69}', &['\u{634}',
        '\u{62c}', '\u{64a}']), ('\u{fd6a}', &['\u{634}', '\u{645}', '\u{62e}']), ('\u{fd6b}',
        &['\u{634}', '\u{645}', '\u{62e}']), ('\u{fd6c}', &['\u{634}', '\u{645}', '\u{645}']),
        ('\u{fd6d}', &['\u{634}', '\u{645}', '\u{645}']), ('\u{fd6e}', &['\u{636}', '\u{62d}',
        '\u{649}']), ('\u{fd6f}', &['\u{636}', '\u{62e}', '\u{645}']), ('\u{fd70}', &['\u{636}',
        '\u{62e}', '\u{645}']), ('\u{fd71}', &['\u{637}', '\u{645}', '\u{62d}']), ('\u{fd72}',
        &['\u{637}', '\u{645}', '\u{62d}']), ('\u{fd73}', &['\u{637}', '\u{645}', '\u{645}']),
        ('\u{fd74}', &['\u{637}', '\u{645}', '\u{64a}']), ('\u{fd75}', &['\u{639}', '\u{62c}',
        '\u{645}']), ('\u{fd76}', &['\u{639}', '\u{645}', '\u{645}']), ('\u{fd77}', &['\u{639}',
        '\u{645}', '\u{645}']), ('\u{fd78}', &['\u{639}', '\u{645}', '\u{649}']), ('\u{fd79}',
        &['\u{63a}', '\u{645}', '\u{645}']), ('\u{fd7a}', &['\u{63a}', '\u{645}', '\u{64a}']),
        ('\u{fd7b}', &['\u{63a}', '\u{645}', '\u{649}']), ('\u{fd7c}', &['\u{641}', '\u{62e}',
        '\u{645}']), ('\u{fd7d}', &['\u{641}', '\u{62e}', '\u{645}']), ('\u{fd7e}', &['\u{642}',
        '\u{645}', '\u{62d}']), ('\u{fd7f}', &['\u{642}', '\u{645}', '\u{645}']), ('\u{fd80}',
        &['\u{644}', '\u{62d}', '\u{645}']), ('\u{fd81}', &['\u{644}', '\u{62d}', '\u{64a}']),
        ('\u{fd82}', &['\u{644}', '\u{62d}', '\u{649}']), ('\u{fd83}', &['\u{644}', '\u{62c}',
        '\u{62c}']), ('\u{fd84}', &['\u{644}', '\u{62c}', '\u{62c}']), ('\u{fd85}', &['\u{644}',
        '\u{62e}', '\u{645}']), ('\u{fd86}', &['\u{644}', '\u{62e}', '\u{645}']), ('\u{fd87}',
        &['\u{644}', '\u{645}', '\u{62d}']), ('\u{fd88}', &['\u{644}', '\u{645}', '\u{62d}']),
        ('\u{fd89}', &['\u{645}', '\u{62d}', '\u{62c}']), ('\u{fd8a}', &['\u{645}', '\u{62d}',
        '\u{645}']), ('\u{fd8b}', &['\u{645}', '\u{62d}', '\u{64a}']), ('\u{fd8c}', &['\u{645}',
        '\u{62c}', '\u{62d}']), ('\u{fd8d}', &['\u{645}', '\u{62c}', '\u{645}']), ('\u{fd8e}',
        &['\u{645}', '\u{62e}', '\u{62c}']), ('\u{fd8f}', &['\u{645}', '\u{62e}', '\u{645}']),
        ('\u{fd92}', &['\u{645}', '\u{62c}', '\u{62e}']), ('\u{fd93}', &['\u{647}', '\u{645}',
        '\u{62c}']), ('\u{fd94}', &['\u{647}', '\u{645}', '\u{645}']), ('\u{fd95}', &['\u{646}',
        '\u{62d}', '\u{645}']), ('\u{fd96}', &['\u{646}', '\u{62d}', '\u{649}']), ('\u{fd97}',
        &['\u{646}', '\u{62c}', '\u{645}']), ('\u{fd98}', &['\u{646}', '\u{62c}', '\u{645}']),
        ('\u{fd99}', &['\u{646}', '\u{62c}', '\u{649}']), ('\u{fd9a}', &['\u{646}', '\u{645}',
        '\u{64a}']), ('\u{fd9b}', &['\u{646}', '\u{645}', '\u{649}']), ('\u{fd9c}', &['\u{64a}',
        '\u{645}', '\u{645}']), ('\u{fd9d}', &['\u{64a}', '\u{645}', '\u{645}']), ('\u{fd9e}',
        &['\u{628}', '\u{62e}', '\u{64a}']), ('\u{fd9f}', &['\u{62a}', '\u{62c}', '\u{64a}']),
        ('\u{fda0}', &['\u{62a}', '\u{62c}', '\u{649}']), ('\u{fda1}', &['\u{62a}', '\u{62e}',
        '\u{64a}']), ('\u{fda2}', &['\u{62a}', '\u{62e}', '\u{649}']), ('\u{fda3}', &['\u{62a}',
        '\u{645}', '\u{64a}']), ('\u{fda4}', &['\u{62a}', '\u{645}', '\u{649}']), ('\u{fda5}',
        &['\u{62c}', '\u{645}', '\u{64a}']), ('\u{fda6}', &['\u{62c}', '\u{62d}', '\u{649}']),
        ('\u{fda7}', &['\u{62c}', '\u{645}', '\u{649}']), ('\u{fda8}', &['\u{633}', '\u{62e}',
        '\u{649}']), ('\u{fda9}', &['\u{635}', '\u{62d}', '\u{64a}']), ('\u{fdaa}', &['\u{634}',
        '\u{62d}', '\u{64a}']), ('\u{fdab}', &['\u{636}', '\u{62d}', '\u{64a}']), ('\u{fdac}',
        &['\u{644}', '\u{62c}', '\u{64a}']), ('\u{fdad}', &['\u{644}', '\u{645}', '\u{64a}']),
        ('\u{fdae}', &['\u{64a}', '\u{62d}', '\u{64a}']), ('\u{fdaf}', &['\u{64a}', '\u{62c}',
        '\u{64a}']), ('\u{fdb0}', &['\u{64a}', '\u{645}', '\u{64a}']), ('\u{fdb1}', &['\u{645}',
        '\u{645}', '\u{64a}']), ('\u{fdb2}', &['\u{642}', '\u{645}', '\u{64a}']), ('\u{fdb3}',
        &['\u{646}', '\u{62d}', '\u{64a}']), ('\u{fdb4}', &['\u{642}', '\u{645}', '\u{62d}']),
        ('\u{fdb5}', &['\u{644}', '\u{62d}', '\u{645}']), ('\u{fdb6}', &['\u{639}', '\u{645}',
        '\u{64a}']), ('\u{fdb7}', &['\u{643}', '\u{645}', '\u{64a}']), ('\u{fdb8}', &['\u{646}',
        '\u{62c}', '\u{62d}']), ('\u{fdb9}', &['\u{645}', '\u{62e}', '\u{64a}']), ('\u{fdba}',
        &['\u{644}', '\u{62c}', '\u{645}']), ('\u{fdbb}', &['\u{643}', '\u{645}', '\u{645}']),
        ('\u{fdbc}', &['\u{644}', '\u{62c}', '\u{645}']), ('\u{fdbd}', &['\u{646}', '\u{62c}',
        '\u{62d}']), ('\u{fdbe}', &['\u{62c}', '\u{62d}', '\u{64a}']), ('\u{fdbf}', &['\u{62d}',
        '\u{62c}', '\u{64a}']), ('\u{fdc0}', &['\u{645}', '\u{62c}', '\u{64a}']), ('\u{fdc1}',
        &['\u{641}', '\u{645}', '\u{64a}']), ('\u{fdc2}', &['\u{628}', '\u{62d}', '\u{64a}']),
        ('\u{fdc3}', &['\u{643}', '\u{645}', '\u{645}']), ('\u{fdc4}', &['\u{639}', '\u{62c}',
        '\u{645}']), ('\u{fdc5}', &['\u{635}', '\u{645}', '\u{645}']), ('\u{fdc6}', &['\u{633}',
        '\u{62e}', '\u{64a}']), ('\u{fdc7}', &['\u{646}', '\u{62c}', '\u{64a}']), ('\u{fdf0}',
        &['\u{635}', '\u{644}', '\u{6d2}']), ('\u{fdf1}', &['\u{642}', '\u{644}', '\u{6d2}']),
        ('\u{fdf2}', &['\u{627}', '\u{644}', '\u{644}', '\u{647}']), ('\u{fdf3}', &['\u{627}',
        '\u{643}', '\u{628}', '\u{631}']), ('\u{fdf4}', &['\u{645}', '\u{62d}', '\u{645}',
        '\u{62f}']), ('\u{fdf5}', &['\u{635}', '\u{644}', '\u{639}', '\u{645}']), ('\u{fdf6}',
        &['\u{631}', '\u{633}', '\u{648}', '\u{644}']), ('\u{fdf7}', &['\u{639}', '\u{644}',
        '\u{64a}', '\u{647}']), ('\u{fdf8}', &['\u{648}', '\u{633}', '\u{644}', '\u{645}']),
        ('\u{fdf9}', &['\u{635}', '\u{644}', '\u{649}']), ('\u{fdfa}', &['\u{635}', '\u{644}',
        '\u{649}', '\u{20}', '\u{627}', '\u{644}', '\u{644}', '\u{647}', '\u{20}', '\u{639}',
        '\u{644}', '\u{64a}', '\u{647}', '\u{20}', '\u{648}', '\u{633}', '\u{644}', '\u{645}']),
        ('\u{fdfb}', &['\u{62c}', '\u{644}', '\u{20}', '\u{62c}', '\u{644}', '\u{627}', '\u{644}',
        '\u{647}']), ('\u{fdfc}', &['\u{631}', '\u{6cc}', '\u{627}', '\u{644}']), ('\u{fe10}',
        &['\u{2c}']), ('\u{fe11}', &['\u{3001}']), ('\u{fe12}', &['\u{3002}']), ('\u{fe13}',
        &['\u{3a}']), ('\u{fe14}', &['\u{3b}']), ('\u{fe15}', &['\u{21}']), ('\u{fe16}',
        &['\u{3f}']), ('\u{fe17}', &['\u{3016}']), ('\u{fe18}', &['\u{3017}']), ('\u{fe19}',
        &['\u{2026}']), ('\u{fe30}', &['\u{2025}']), ('\u{fe31}', &['\u{2014}']), ('\u{fe32}',
        &['\u{2013}']), ('\u{fe33}', &['\u{5f}']), ('\u{fe34}', &['\u{5f}']), ('\u{fe35}',
        &['\u{28}']), ('\u{fe36}', &['\u{29}']), ('\u{fe37}', &['\u{7b}']), ('\u{fe38}',
        &['\u{7d}']), ('\u{fe39}', &['\u{3014}']), ('\u{fe3a}', &['\u{3015}']), ('\u{fe3b}',
        &['\u{3010}']), ('\u{fe3c}', &['\u{3011}']), ('\u{fe3d}', &['\u{300a}']), ('\u{fe3e}',
        &['\u{300b}']), ('\u{fe3f}', &['\u{3008}']), ('\u{fe40}', &['\u{3009}']), ('\u{fe41}',
        &['\u{300c}']), ('\u{fe42}', &['\u{300d}']), ('\u{fe43}', &['\u{300e}']), ('\u{fe44}',
        &['\u{300f}']), ('\u{fe47}', &['\u{5b}']), ('\u{fe48}', &['\u{5d}']), ('\u{fe49}',
        &['\u{203e}']), ('\u{fe4a}', &['\u{203e}']), ('\u{fe4b}', &['\u{203e}']), ('\u{fe4c}',
        &['\u{203e}']), ('\u{fe4d}', &['\u{5f}']), ('\u{fe4e}', &['\u{5f}']), ('\u{fe4f}',
        &['\u{5f}']), ('\u{fe50}', &['\u{2c}']), ('\u{fe51}', &['\u{3001}']), ('\u{fe52}',
        &['\u{2e}']), ('\u{fe54}', &['\u{3b}']), ('\u{fe55}', &['\u{3a}']), ('\u{fe56}',
        &['\u{3f}']), ('\u{fe57}', &['\u{21}']), ('\u{fe58}', &['\u{2014}']), ('\u{fe59}',
        &['\u{28}']), ('\u{fe5a}', &['\u{29}']), ('\u{fe5b}', &['\u{7b}']), ('\u{fe5c}',
        &['\u{7d}']), ('\u{fe5d}', &['\u{3014}']), ('\u{fe5e}', &['\u{3015}']), ('\u{fe5f}',
        &['\u{23}']), ('\u{fe60}', &['\u{26}']), ('\u{fe61}', &['\u{2a}']), ('\u{fe62}',
        &['\u{2b}']), ('\u{fe63}', &['\u{2d}']), ('\u{fe64}', &['\u{3c}']), ('\u{fe65}',
        &['\u{3e}']), ('\u{fe66}', &['\u{3d}']), ('\u{fe68}', &['\u{5c}']), ('\u{fe69}',
        &['\u{24}']), ('\u{fe6a}', &['\u{25}']), ('\u{fe6b}', &['\u{40}']), ('\u{fe70}', &['\u{20}',
        '\u{64b}']), ('\u{fe71}', &['\u{640}', '\u{64b}']), ('\u{fe72}', &['\u{20}', '\u{64c}']),
        ('\u{fe74}', &['\u{20}', '\u{64d}']), ('\u{fe76}', &['\u{20}', '\u{64e}']), ('\u{fe77}',
        &['\u{640}', '\u{64e}']), ('\u{fe78}', &['\u{20}', '\u{64f}']), ('\u{fe79}', &['\u{640}',
        '\u{64f}']), ('\u{fe7a}', &['\u{20}', '\u{650}']), ('\u{fe7b}', &['\u{640}', '\u{650}']),
        ('\u{fe7c}', &['\u{20}', '\u{651}']), ('\u{fe7d}', &['\u{640}', '\u{651}']), ('\u{fe7e}',
        &['\u{20}', '\u{652}']), ('\u{fe7f}', &['\u{640}', '\u{652}']), ('\u{fe80}', &['\u{621}']),
        ('\u{fe81}', &['\u{622}']), ('\u{fe82}', &['\u{622}']), ('\u{fe83}', &['\u{623}']),
        ('\u{fe84}', &['\u{623}']), ('\u{fe85}', &['\u{624}']), ('\u{fe86}', &['\u{624}']),
        ('\u{fe87}', &['\u{625}']), ('\u{fe88}', &['\u{625}']), ('\u{fe89}', &['\u{626}']),
        ('\u{fe8a}', &['\u{626}']), ('\u{fe8b}', &['\u{626}']), ('\u{fe8c}', &['\u{626}']),
        ('\u{fe8d}', &['\u{627}']), ('\u{fe8e}', &['\u{627}']), ('\u{fe8f}', &['\u{628}']),
        ('\u{fe90}', &['\u{628}']), ('\u{fe91}', &['\u{628}']), ('\u{fe92}', &['\u{628}']),
        ('\u{fe93}', &['\u{629}']), ('\u{fe94}', &['\u{629}']), ('\u{fe95}', &['\u{62a}']),
        ('\u{fe96}', &['\u{62a}']), ('\u{fe97}', &['\u{62a}']), ('\u{fe98}', &['\u{62a}']),
        ('\u{fe99}', &['\u{62b}']), ('\u{fe9a}', &['\u{62b}']), ('\u{fe9b}', &['\u{62b}']),
        ('\u{fe9c}', &['\u{62b}']), ('\u{fe9d}', &['\u{62c}']), ('\u{fe9e}', &['\u{62c}']),
        ('\u{fe9f}', &['\u{62c}']), ('\u{fea0}', &['\u{62c}']), ('\u{fea1}', &['\u{62d}']),
        ('\u{fea2}', &['\u{62d}']), ('\u{fea3}', &['\u{62d}']), ('\u{fea4}', &['\u{62d}']),
        ('\u{fea5}', &['\u{62e}']), ('\u{fea6}', &['\u{62e}']), ('\u{fea7}', &['\u{62e}']),
        ('\u{fea8}', &['\u{62e}']), ('\u{fea9}', &['\u{62f}']), ('\u{feaa}', &['\u{62f}']),
        ('\u{feab}', &['\u{630}']), ('\u{feac}', &['\u{630}']), ('\u{fead}', &['\u{631}']),
        ('\u{feae}', &['\u{631}']), ('\u{feaf}', &['\u{632}']), ('\u{feb0}', &['\u{632}']),
        ('\u{feb1}', &['\u{633}']), ('\u{feb2}', &['\u{633}']), ('\u{feb3}', &['\u{633}']),
        ('\u{feb4}', &['\u{633}']), ('\u{feb5}', &['\u{634}']), ('\u{feb6}', &['\u{634}']),
        ('\u{feb7}', &['\u{634}']), ('\u{feb8}', &['\u{634}']), ('\u{feb9}', &['\u{635}']),
        ('\u{feba}', &['\u{635}']), ('\u{febb}', &['\u{635}']), ('\u{febc}', &['\u{635}']),
        ('\u{febd}', &['\u{636}']), ('\u{febe}', &['\u{636}']), ('\u{febf}', &['\u{636}']),
        ('\u{fec0}', &['\u{636}']), ('\u{fec1}', &['\u{637}']), ('\u{fec2}', &['\u{637}']),
        ('\u{fec3}', &['\u{637}']), ('\u{fec4}', &['\u{637}']), ('\u{fec5}', &['\u{638}']),
        ('\u{fec6}', &['\u{638}']), ('\u{fec7}', &['\u{638}']), ('\u{fec8}', &['\u{638}']),
        ('\u{fec9}', &['\u{639}']), ('\u{feca}', &['\u{639}']), ('\u{fecb}', &['\u{639}']),
        ('\u{fecc}', &['\u{639}']), ('\u{fecd}', &['\u{63a}']), ('\u{fece}', &['\u{63a}']),
        ('\u{fecf}', &['\u{63a}']), ('\u{fed0}', &['\u{63a}']), ('\u{fed1}', &['\u{641}']),
        ('\u{fed2}', &['\u{641}']), ('\u{fed3}', &['\u{641}']), ('\u{fed4}', &['\u{641}']),
        ('\u{fed5}', &['\u{642}']), ('\u{fed6}', &['\u{642}']), ('\u{fed7}', &['\u{642}']),
        ('\u{fed8}', &['\u{642}']), ('\u{fed9}', &['\u{643}']), ('\u{feda}', &['\u{643}']),
        ('\u{fedb}', &['\u{643}']), ('\u{fedc}', &['\u{643}']), ('\u{fedd}', &['\u{644}']),
        ('\u{fede}', &['\u{644}']), ('\u{fedf}', &['\u{644}']), ('\u{fee0}', &['\u{644}']),
        ('\u{fee1}', &['\u{645}']), ('\u{fee2}', &['\u{645}']), ('\u{fee3}', &['\u{645}']),
        ('\u{fee4}', &['\u{645}']), ('\u{fee5}', &['\u{646}']), ('\u{fee6}', &['\u{646}']),
        ('\u{fee7}', &['\u{646}']), ('\u{fee8}', &['\u{646}']), ('\u{fee9}', &['\u{647}']),
        ('\u{feea}', &['\u{647}']), ('\u{feeb}', &['\u{647}']), ('\u{feec}', &['\u{647}']),
        ('\u{feed}', &['\u{648}']), ('\u{feee}', &['\u{648}']), ('\u{feef}', &['\u{649}']),
        ('\u{fef0}', &['\u{649}']), ('\u{fef1}', &['\u{64a}']), ('\u{fef2}', &['\u{64a}']),
        ('\u{fef3}', &['\u{64a}']), ('\u{fef4}', &['\u{64a}']), ('\u{fef5}', &['\u{644}',
        '\u{622}']), ('\u{fef6}', &['\u{644}', '\u{622}']), ('\u{fef7}', &['\u{644}', '\u{623}']),
        ('\u{fef8}', &['\u{644}', '\u{623}']), ('\u{fef9}', &['\u{644}', '\u{625}']), ('\u{fefa}',
        &['\u{644}', '\u{625}']), ('\u{fefb}', &['\u{644}', '\u{627}']), ('\u{fefc}', &['\u{644}',
        '\u{627}']), ('\u{ff01}', &['\u{21}']), ('\u{ff02}', &['\u{22}']), ('\u{ff03}',
        &['\u{23}']), ('\u{ff04}', &['\u{24}']), ('\u{ff05}', &['\u{25}']), ('\u{ff06}',
        &['\u{26}']), ('\u{ff07}', &['\u{27}']), ('\u{ff08}', &['\u{28}']), ('\u{ff09}',
        &['\u{29}']), ('\u{ff0a}', &['\u{2a}']), ('\u{ff0b}', &['\u{2b}']), ('\u{ff0c}',
        &['\u{2c}']), ('\u{ff0d}', &['\u{2d}']), ('\u{ff0e}', &['\u{2e}']), ('\u{ff0f}',
        &['\u{2f}']), ('\u{ff10}', &['\u{30}']), ('\u{ff11}', &['\u{31}']), ('\u{ff12}',
        &['\u{32}']), ('\u{ff13}', &['\u{33}']), ('\u{ff14}', &['\u{34}']), ('\u{ff15}',
        &['\u{35}']), ('\u{ff16}', &['\u{36}']), ('\u{ff17}', &['\u{37}']), ('\u{ff18}',
        &['\u{38}']), ('\u{ff19}', &['\u{39}']), ('\u{ff1a}', &['\u{3a}']), ('\u{ff1b}',
        &['\u{3b}']), ('\u{ff1c}', &['\u{3c}']), ('\u{ff1d}', &['\u{3d}']), ('\u{ff1e}',
        &['\u{3e}']), ('\u{ff1f}', &['\u{3f}']), ('\u{ff20}', &['\u{40}']), ('\u{ff21}',
        &['\u{41}']), ('\u{ff22}', &['\u{42}']), ('\u{ff23}', &['\u{43}']), ('\u{ff24}',
        &['\u{44}']), ('\u{ff25}', &['\u{45}']), ('\u{ff26}', &['\u{46}']), ('\u{ff27}',
        &['\u{47}']), ('\u{ff28}', &['\u{48}']), ('\u{ff29}', &['\u{49}']), ('\u{ff2a}',
        &['\u{4a}']), ('\u{ff2b}', &['\u{4b}']), ('\u{ff2c}', &['\u{4c}']), ('\u{ff2d}',
        &['\u{4d}']), ('\u{ff2e}', &['\u{4e}']), ('\u{ff2f}', &['\u{4f}']), ('\u{ff30}',
        &['\u{50}']), ('\u{ff31}', &['\u{51}']), ('\u{ff32}', &['\u{52}']), ('\u{ff33}',
        &['\u{53}']), ('\u{ff34}', &['\u{54}']), ('\u{ff35}', &['\u{55}']), ('\u{ff36}',
        &['\u{56}']), ('\u{ff37}', &['\u{57}']), ('\u{ff38}', &['\u{58}']), ('\u{ff39}',
        &['\u{59}']), ('\u{ff3a}', &['\u{5a}']), ('\u{ff3b}', &['\u{5b}']), ('\u{ff3c}',
        &['\u{5c}']), ('\u{ff3d}', &['\u{5d}']), ('\u{ff3e}', &['\u{5e}']), ('\u{ff3f}',
        &['\u{5f}']), ('\u{ff40}', &['\u{60}']), ('\u{ff41}', &['\u{61}']), ('\u{ff42}',
        &['\u{62}']), ('\u{ff43}', &['\u{63}']), ('\u{ff44}', &['\u{64}']), ('\u{ff45}',
        &['\u{65}']), ('\u{ff46}', &['\u{66}']), ('\u{ff47}', &['\u{67}']), ('\u{ff48}',
        &['\u{68}']), ('\u{ff49}', &['\u{69}']), ('\u{ff4a}', &['\u{6a}']), ('\u{ff4b}',
        &['\u{6b}']), ('\u{ff4c}', &['\u{6c}']), ('\u{ff4d}', &['\u{6d}']), ('\u{ff4e}',
        &['\u{6e}']), ('\u{ff4f}', &['\u{6f}']), ('\u{ff50}', &['\u{70}']), ('\u{ff51}',
        &['\u{71}']), ('\u{ff52}', &['\u{72}']), ('\u{ff53}', &['\u{73}']), ('\u{ff54}',
        &['\u{74}']), ('\u{ff55}', &['\u{75}']), ('\u{ff56}', &['\u{76}']), ('\u{ff57}',
        &['\u{77}']), ('\u{ff58}', &['\u{78}']), ('\u{ff59}', &['\u{79}']), ('\u{ff5a}',
        &['\u{7a}']), ('\u{ff5b}', &['\u{7b}']), ('\u{ff5c}', &['\u{7c}']), ('\u{ff5d}',
        &['\u{7d}']), ('\u{ff5e}', &['\u{7e}']), ('\u{ff5f}', &['\u{2985}']), ('\u{ff60}',
        &['\u{2986}']), ('\u{ff61}', &['\u{3002}']), ('\u{ff62}', &['\u{300c}']), ('\u{ff63}',
        &['\u{300d}']), ('\u{ff64}', &['\u{3001}']), ('\u{ff65}', &['\u{30fb}']), ('\u{ff66}',
        &['\u{30f2}']), ('\u{ff67}', &['\u{30a1}']), ('\u{ff68}', &['\u{30a3}']), ('\u{ff69}',
        &['\u{30a5}']), ('\u{ff6a}', &['\u{30a7}']), ('\u{ff6b}', &['\u{30a9}']), ('\u{ff6c}',
        &['\u{30e3}']), ('\u{ff6d}', &['\u{30e5}']), ('\u{ff6e}', &['\u{30e7}']), ('\u{ff6f}',
        &['\u{30c3}']), ('\u{ff70}', &['\u{30fc}']), ('\u{ff71}', &['\u{30a2}']), ('\u{ff72}',
        &['\u{30a4}']), ('\u{ff73}', &['\u{30a6}']), ('\u{ff74}', &['\u{30a8}']), ('\u{ff75}',
        &['\u{30aa}']), ('\u{ff76}', &['\u{30ab}']), ('\u{ff77}', &['\u{30ad}']), ('\u{ff78}',
        &['\u{30af}']), ('\u{ff79}', &['\u{30b1}']), ('\u{ff7a}', &['\u{30b3}']), ('\u{ff7b}',
        &['\u{30b5}']), ('\u{ff7c}', &['\u{30b7}']), ('\u{ff7d}', &['\u{30b9}']), ('\u{ff7e}',
        &['\u{30bb}']), ('\u{ff7f}', &['\u{30bd}']), ('\u{ff80}', &['\u{30bf}']), ('\u{ff81}',
        &['\u{30c1}']), ('\u{ff82}', &['\u{30c4}']), ('\u{ff83}', &['\u{30c6}']), ('\u{ff84}',
        &['\u{30c8}']), ('\u{ff85}', &['\u{30ca}']), ('\u{ff86}', &['\u{30cb}']), ('\u{ff87}',
        &['\u{30cc}']), ('\u{ff88}', &['\u{30cd}']), ('\u{ff89}', &['\u{30ce}']), ('\u{ff8a}',
        &['\u{30cf}']), ('\u{ff8b}', &['\u{30d2}']), ('\u{ff8c}', &['\u{30d5}']), ('\u{ff8d}',
        &['\u{30d8}']), ('\u{ff8e}', &['\u{30db}']), ('\u{ff8f}', &['\u{30de}']), ('\u{ff90}',
        &['\u{30df}']), ('\u{ff91}', &['\u{30e0}']), ('\u{ff92}', &['\u{30e1}']), ('\u{ff93}',
        &['\u{30e2}']), ('\u{ff94}', &['\u{30e4}']), ('\u{ff95}', &['\u{30e6}']), ('\u{ff96}',
        &['\u{30e8}']), ('\u{ff97}', &['\u{30e9}']), ('\u{ff98}', &['\u{30ea}']), ('\u{ff99}',
        &['\u{30eb}']), ('\u{ff9a}', &['\u{30ec}']), ('\u{ff9b}', &['\u{30ed}']), ('\u{ff9c}',
        &['\u{30ef}']), ('\u{ff9d}', &['\u{30f3}']), ('\u{ff9e}', &['\u{3099}']), ('\u{ff9f}',
        &['\u{309a}']), ('\u{ffa0}', &['\u{3164}']), ('\u{ffa1}', &['\u{3131}']), ('\u{ffa2}',
        &['\u{3132}']), ('\u{ffa3}', &['\u{3133}']), ('\u{ffa4}', &['\u{3134}']), ('\u{ffa5}',
        &['\u{3135}']), ('\u{ffa6}', &['\u{3136}']), ('\u{ffa7}', &['\u{3137}']), ('\u{ffa8}',
        &['\u{3138}']), ('\u{ffa9}', &['\u{3139}']), ('\u{ffaa}', &['\u{313a}']), ('\u{ffab}',
        &['\u{313b}']), ('\u{ffac}', &['\u{313c}']), ('\u{ffad}', &['\u{313d}']), ('\u{ffae}',
        &['\u{313e}']), ('\u{ffaf}', &['\u{313f}']), ('\u{ffb0}', &['\u{3140}']), ('\u{ffb1}',
        &['\u{3141}']), ('\u{ffb2}', &['\u{3142}']), ('\u{ffb3}', &['\u{3143}']), ('\u{ffb4}',
        &['\u{3144}']), ('\u{ffb5}', &['\u{3145}']), ('\u{ffb6}', &['\u{3146}']), ('\u{ffb7}',
        &['\u{3147}']), ('\u{ffb8}', &['\u{3148}']), ('\u{ffb9}', &['\u{3149}']), ('\u{ffba}',
        &['\u{314a}']), ('\u{ffbb}', &['\u{314b}']), ('\u{ffbc}', &['\u{314c}']), ('\u{ffbd}',
        &['\u{314d}']), ('\u{ffbe}', &['\u{314e}']), ('\u{ffc2}', &['\u{314f}']), ('\u{ffc3}',
        &['\u{3150}']), ('\u{ffc4}', &['\u{3151}']), ('\u{ffc5}', &['\u{3152}']), ('\u{ffc6}',
        &['\u{3153}']), ('\u{ffc7}', &['\u{3154}']), ('\u{ffca}', &['\u{3155}']), ('\u{ffcb}',
        &['\u{3156}']), ('\u{ffcc}', &['\u{3157}']), ('\u{ffcd}', &['\u{3158}']), ('\u{ffce}',
        &['\u{3159}']), ('\u{ffcf}', &['\u{315a}']), ('\u{ffd2}', &['\u{315b}']), ('\u{ffd3}',
        &['\u{315c}']), ('\u{ffd4}', &['\u{315d}']), ('\u{ffd5}', &['\u{315e}']), ('\u{ffd6}',
        &['\u{315f}']), ('\u{ffd7}', &['\u{3160}']), ('\u{ffda}', &['\u{3161}']), ('\u{ffdb}',
        &['\u{3162}']), ('\u{ffdc}', &['\u{3163}']), ('\u{ffe0}', &['\u{a2}']), ('\u{ffe1}',
        &['\u{a3}']), ('\u{ffe2}', &['\u{ac}']), ('\u{ffe3}', &['\u{af}']), ('\u{ffe4}',
        &['\u{a6}']), ('\u{ffe5}', &['\u{a5}']), ('\u{ffe6}', &['\u{20a9}']), ('\u{ffe8}',
        &['\u{2502}']), ('\u{ffe9}', &['\u{2190}']), ('\u{ffea}', &['\u{2191}']), ('\u{ffeb}',
        &['\u{2192}']), ('\u{ffec}', &['\u{2193}']), ('\u{ffed}', &['\u{25a0}']), ('\u{ffee}',
        &['\u{25cb}']), ('\u{1d400}', &['\u{41}']), ('\u{1d401}', &['\u{42}']), ('\u{1d402}',
        &['\u{43}']), ('\u{1d403}', &['\u{44}']), ('\u{1d404}', &['\u{45}']), ('\u{1d405}',
        &['\u{46}']), ('\u{1d406}', &['\u{47}']), ('\u{1d407}', &['\u{48}']), ('\u{1d408}',
        &['\u{49}']), ('\u{1d409}', &['\u{4a}']), ('\u{1d40a}', &['\u{4b}']), ('\u{1d40b}',
        &['\u{4c}']), ('\u{1d40c}', &['\u{4d}']), ('\u{1d40d}', &['\u{4e}']), ('\u{1d40e}',
        &['\u{4f}']), ('\u{1d40f}', &['\u{50}']), ('\u{1d410}', &['\u{51}']), ('\u{1d411}',
        &['\u{52}']), ('\u{1d412}', &['\u{53}']), ('\u{1d413}', &['\u{54}']), ('\u{1d414}',
        &['\u{55}']), ('\u{1d415}', &['\u{56}']), ('\u{1d416}', &['\u{57}']), ('\u{1d417}',
        &['\u{58}']), ('\u{1d418}', &['\u{59}']), ('\u{1d419}', &['\u{5a}']), ('\u{1d41a}',
        &['\u{61}']), ('\u{1d41b}', &['\u{62}']), ('\u{1d41c}', &['\u{63}']), ('\u{1d41d}',
        &['\u{64}']), ('\u{1d41e}', &['\u{65}']), ('\u{1d41f}', &['\u{66}']), ('\u{1d420}',
        &['\u{67}']), ('\u{1d421}', &['\u{68}']), ('\u{1d422}', &['\u{69}']), ('\u{1d423}',
        &['\u{6a}']), ('\u{1d424}', &['\u{6b}']), ('\u{1d425}', &['\u{6c}']), ('\u{1d426}',
        &['\u{6d}']), ('\u{1d427}', &['\u{6e}']), ('\u{1d428}', &['\u{6f}']), ('\u{1d429}',
        &['\u{70}']), ('\u{1d42a}', &['\u{71}']), ('\u{1d42b}', &['\u{72}']), ('\u{1d42c}',
        &['\u{73}']), ('\u{1d42d}', &['\u{74}']), ('\u{1d42e}', &['\u{75}']), ('\u{1d42f}',
        &['\u{76}']), ('\u{1d430}', &['\u{77}']), ('\u{1d431}', &['\u{78}']), ('\u{1d432}',
        &['\u{79}']), ('\u{1d433}', &['\u{7a}']), ('\u{1d434}', &['\u{41}']), ('\u{1d435}',
        &['\u{42}']), ('\u{1d436}', &['\u{43}']), ('\u{1d437}', &['\u{44}']), ('\u{1d438}',
        &['\u{45}']), ('\u{1d439}', &['\u{46}']), ('\u{1d43a}', &['\u{47}']), ('\u{1d43b}',
        &['\u{48}']), ('\u{1d43c}', &['\u{49}']), ('\u{1d43d}', &['\u{4a}']), ('\u{1d43e}',
        &['\u{4b}']), ('\u{1d43f}', &['\u{4c}']), ('\u{1d440}', &['\u{4d}']), ('\u{1d441}',
        &['\u{4e}']), ('\u{1d442}', &['\u{4f}']), ('\u{1d443}', &['\u{50}']), ('\u{1d444}',
        &['\u{51}']), ('\u{1d445}', &['\u{52}']), ('\u{1d446}', &['\u{53}']), ('\u{1d447}',
        &['\u{54}']), ('\u{1d448}', &['\u{55}']), ('\u{1d449}', &['\u{56}']), ('\u{1d44a}',
        &['\u{57}']), ('\u{1d44b}', &['\u{58}']), ('\u{1d44c}', &['\u{59}']), ('\u{1d44d}',
        &['\u{5a}']), ('\u{1d44e}', &['\u{61}']), ('\u{1d44f}', &['\u{62}']), ('\u{1d450}',
        &['\u{63}']), ('\u{1d451}', &['\u{64}']), ('\u{1d452}', &['\u{65}']), ('\u{1d453}',
        &['\u{66}']), ('\u{1d454}', &['\u{67}']), ('\u{1d456}', &['\u{69}']), ('\u{1d457}',
        &['\u{6a}']), ('\u{1d458}', &['\u{6b}']), ('\u{1d459}', &['\u{6c}']), ('\u{1d45a}',
        &['\u{6d}']), ('\u{1d45b}', &['\u{6e}']), ('\u{1d45c}', &['\u{6f}']), ('\u{1d45d}',
        &['\u{70}']), ('\u{1d45e}', &['\u{71}']), ('\u{1d45f}', &['\u{72}']), ('\u{1d460}',
        &['\u{73}']), ('\u{1d461}', &['\u{74}']), ('\u{1d462}', &['\u{75}']), ('\u{1d463}',
        &['\u{76}']), ('\u{1d464}', &['\u{77}']), ('\u{1d465}', &['\u{78}']), ('\u{1d466}',
        &['\u{79}']), ('\u{1d467}', &['\u{7a}']), ('\u{1d468}', &['\u{41}']), ('\u{1d469}',
        &['\u{42}']), ('\u{1d46a}', &['\u{43}']), ('\u{1d46b}', &['\u{44}']), ('\u{1d46c}',
        &['\u{45}']), ('\u{1d46d}', &['\u{46}']), ('\u{1d46e}', &['\u{47}']), ('\u{1d46f}',
        &['\u{48}']), ('\u{1d470}', &['\u{49}']), ('\u{1d471}', &['\u{4a}']), ('\u{1d472}',
        &['\u{4b}']), ('\u{1d473}', &['\u{4c}']), ('\u{1d474}', &['\u{4d}']), ('\u{1d475}',
        &['\u{4e}']), ('\u{1d476}', &['\u{4f}']), ('\u{1d477}', &['\u{50}']), ('\u{1d478}',
        &['\u{51}']), ('\u{1d479}', &['\u{52}']), ('\u{1d47a}', &['\u{53}']), ('\u{1d47b}',
        &['\u{54}']), ('\u{1d47c}', &['\u{55}']), ('\u{1d47d}', &['\u{56}']), ('\u{1d47e}',
        &['\u{57}']), ('\u{1d47f}', &['\u{58}']), ('\u{1d480}', &['\u{59}']), ('\u{1d481}',
        &['\u{5a}']), ('\u{1d482}', &['\u{61}']), ('\u{1d483}', &['\u{62}']), ('\u{1d484}',
        &['\u{63}']), ('\u{1d485}', &['\u{64}']), ('\u{1d486}', &['\u{65}']), ('\u{1d487}',
        &['\u{66}']), ('\u{1d488}', &['\u{67}']), ('\u{1d489}', &['\u{68}']), ('\u{1d48a}',
        &['\u{69}']), ('\u{1d48b}', &['\u{6a}']), ('\u{1d48c}', &['\u{6b}']), ('\u{1d48d}',
        &['\u{6c}']), ('\u{1d48e}', &['\u{6d}']), ('\u{1d48f}', &['\u{6e}']), ('\u{1d490}',
        &['\u{6f}']), ('\u{1d491}', &['\u{70}']), ('\u{1d492}', &['\u{71}']), ('\u{1d493}',
        &['\u{72}']), ('\u{1d494}', &['\u{73}']), ('\u{1d495}', &['\u{74}']), ('\u{1d496}',
        &['\u{75}']), ('\u{1d497}', &['\u{76}']), ('\u{1d498}', &['\u{77}']), ('\u{1d499}',
        &['\u{78}']), ('\u{1d49a}', &['\u{79}']), ('\u{1d49b}', &['\u{7a}']), ('\u{1d49c}',
        &['\u{41}']), ('\u{1d49e}', &['\u{43}']), ('\u{1d49f}', &['\u{44}']), ('\u{1d4a2}',
        &['\u{47}']), ('\u{1d4a5}', &['\u{4a}']), ('\u{1d4a6}', &['\u{4b}']), ('\u{1d4a9}',
        &['\u{4e}']), ('\u{1d4aa}', &['\u{4f}']), ('\u{1d4ab}', &['\u{50}']), ('\u{1d4ac}',
        &['\u{51}']), ('\u{1d4ae}', &['\u{53}']), ('\u{1d4af}', &['\u{54}']), ('\u{1d4b0}',
        &['\u{55}']), ('\u{1d4b1}', &['\u{56}']), ('\u{1d4b2}', &['\u{57}']), ('\u{1d4b3}',
        &['\u{58}']), ('\u{1d4b4}', &['\u{59}']), ('\u{1d4b5}', &['\u{5a}']), ('\u{1d4b6}',
        &['\u{61}']), ('\u{1d4b7}', &['\u{62}']), ('\u{1d4b8}', &['\u{63}']), ('\u{1d4b9}',
        &['\u{64}']), ('\u{1d4bb}', &['\u{66}']), ('\u{1d4bd}', &['\u{68}']), ('\u{1d4be}',
        &['\u{69}']), ('\u{1d4bf}', &['\u{6a}']), ('\u{1d4c0}', &['\u{6b}']), ('\u{1d4c1}',
        &['\u{6c}']), ('\u{1d4c2}', &['\u{6d}']), ('\u{1d4c3}', &['\u{6e}']), ('\u{1d4c5}',
        &['\u{70}']), ('\u{1d4c6}', &['\u{71}']), ('\u{1d4c7}', &['\u{72}']), ('\u{1d4c8}',
        &['\u{73}']), ('\u{1d4c9}', &['\u{74}']), ('\u{1d4ca}', &['\u{75}']), ('\u{1d4cb}',
        &['\u{76}']), ('\u{1d4cc}', &['\u{77}']), ('\u{1d4cd}', &['\u{78}']), ('\u{1d4ce}',
        &['\u{79}']), ('\u{1d4cf}', &['\u{7a}']), ('\u{1d4d0}', &['\u{41}']), ('\u{1d4d1}',
        &['\u{42}']), ('\u{1d4d2}', &['\u{43}']), ('\u{1d4d3}', &['\u{44}']), ('\u{1d4d4}',
        &['\u{45}']), ('\u{1d4d5}', &['\u{46}']), ('\u{1d4d6}', &['\u{47}']), ('\u{1d4d7}',
        &['\u{48}']), ('\u{1d4d8}', &['\u{49}']), ('\u{1d4d9}', &['\u{4a}']), ('\u{1d4da}',
        &['\u{4b}']), ('\u{1d4db}', &['\u{4c}']), ('\u{1d4dc}', &['\u{4d}']), ('\u{1d4dd}',
        &['\u{4e}']), ('\u{1d4de}', &['\u{4f}']), ('\u{1d4df}', &['\u{50}']), ('\u{1d4e0}',
        &['\u{51}']), ('\u{1d4e1}', &['\u{52}']), ('\u{1d4e2}', &['\u{53}']), ('\u{1d4e3}',
        &['\u{54}']), ('\u{1d4e4}', &['\u{55}']), ('\u{1d4e5}', &['\u{56}']), ('\u{1d4e6}',
        &['\u{57}']), ('\u{1d4e7}', &['\u{58}']), ('\u{1d4e8}', &['\u{59}']), ('\u{1d4e9}',
        &['\u{5a}']), ('\u{1d4ea}', &['\u{61}']), ('\u{1d4eb}', &['\u{62}']), ('\u{1d4ec}',
        &['\u{63}']), ('\u{1d4ed}', &['\u{64}']), ('\u{1d4ee}', &['\u{65}']), ('\u{1d4ef}',
        &['\u{66}']), ('\u{1d4f0}', &['\u{67}']), ('\u{1d4f1}', &['\u{68}']), ('\u{1d4f2}',
        &['\u{69}']), ('\u{1d4f3}', &['\u{6a}']), ('\u{1d4f4}', &['\u{6b}']), ('\u{1d4f5}',
        &['\u{6c}']), ('\u{1d4f6}', &['\u{6d}']), ('\u{1d4f7}', &['\u{6e}']), ('\u{1d4f8}',
        &['\u{6f}']), ('\u{1d4f9}', &['\u{70}']), ('\u{1d4fa}', &['\u{71}']), ('\u{1d4fb}',
        &['\u{72}']), ('\u{1d4fc}', &['\u{73}']), ('\u{1d4fd}', &['\u{74}']), ('\u{1d4fe}',
        &['\u{75}']), ('\u{1d4ff}', &['\u{76}']), ('\u{1d500}', &['\u{77}']), ('\u{1d501}',
        &['\u{78}']), ('\u{1d502}', &['\u{79}']), ('\u{1d503}', &['\u{7a}']), ('\u{1d504}',
        &['\u{41}']), ('\u{1d505}', &['\u{42}']), ('\u{1d507}', &['\u{44}']), ('\u{1d508}',
        &['\u{45}']), ('\u{1d509}', &['\u{46}']), ('\u{1d50a}', &['\u{47}']), ('\u{1d50d}',
        &['\u{4a}']), ('\u{1d50e}', &['\u{4b}']), ('\u{1d50f}', &['\u{4c}']), ('\u{1d510}',
        &['\u{4d}']), ('\u{1d511}', &['\u{4e}']), ('\u{1d512}', &['\u{4f}']), ('\u{1d513}',
        &['\u{50}']), ('\u{1d514}', &['\u{51}']), ('\u{1d516}', &['\u{53}']), ('\u{1d517}',
        &['\u{54}']), ('\u{1d518}', &['\u{55}']), ('\u{1d519}', &['\u{56}']), ('\u{1d51a}',
        &['\u{57}']), ('\u{1d51b}', &['\u{58}']), ('\u{1d51c}', &['\u{59}']), ('\u{1d51e}',
        &['\u{61}']), ('\u{1d51f}', &['\u{62}']), ('\u{1d520}', &['\u{63}']), ('\u{1d521}',
        &['\u{64}']), ('\u{1d522}', &['\u{65}']), ('\u{1d523}', &['\u{66}']), ('\u{1d524}',
        &['\u{67}']), ('\u{1d525}', &['\u{68}']), ('\u{1d526}', &['\u{69}']), ('\u{1d527}',
        &['\u{6a}']), ('\u{1d528}', &['\u{6b}']), ('\u{1d529}', &['\u{6c}']), ('\u{1d52a}',
        &['\u{6d}']), ('\u{1d52b}', &['\u{6e}']), ('\u{1d52c}', &['\u{6f}']), ('\u{1d52d}',
        &['\u{70}']), ('\u{1d52e}', &['\u{71}']), ('\u{1d52f}', &['\u{72}']), ('\u{1d530}',
        &['\u{73}']), ('\u{1d531}', &['\u{74}']), ('\u{1d532}', &['\u{75}']), ('\u{1d533}',
        &['\u{76}']), ('\u{1d534}', &['\u{77}']), ('\u{1d535}', &['\u{78}']), ('\u{1d536}',
        &['\u{79}']), ('\u{1d537}', &['\u{7a}']), ('\u{1d538}', &['\u{41}']), ('\u{1d539}',
        &['\u{42}']), ('\u{1d53b}', &['\u{44}']), ('\u{1d53c}', &['\u{45}']), ('\u{1d53d}',
        &['\u{46}']), ('\u{1d53e}', &['\u{47}']), ('\u{1d540}', &['\u{49}']), ('\u{1d541}',
        &['\u{4a}']), ('\u{1d542}', &['\u{4b}']), ('\u{1d543}', &['\u{4c}']), ('\u{1d544}',
        &['\u{4d}']), ('\u{1d546}', &['\u{4f}']), ('\u{1d54a}', &['\u{53}']), ('\u{1d54b}',
        &['\u{54}']), ('\u{1d54c}', &['\u{55}']), ('\u{1d54d}', &['\u{56}']), ('\u{1d54e}',
        &['\u{57}']), ('\u{1d54f}', &['\u{58}']), ('\u{1d550}', &['\u{59}']), ('\u{1d552}',
        &['\u{61}']), ('\u{1d553}', &['\u{62}']), ('\u{1d554}', &['\u{63}']), ('\u{1d555}',
        &['\u{64}']), ('\u{1d556}', &['\u{65}']), ('\u{1d557}', &['\u{66}']), ('\u{1d558}',
        &['\u{67}']), ('\u{1d559}', &['\u{68}']), ('\u{1d55a}', &['\u{69}']), ('\u{1d55b}',
        &['\u{6a}']), ('\u{1d55c}', &['\u{6b}']), ('\u{1d55d}', &['\u{6c}']), ('\u{1d55e}',
        &['\u{6d}']), ('\u{1d55f}', &['\u{6e}']), ('\u{1d560}', &['\u{6f}']), ('\u{1d561}',
        &['\u{70}']), ('\u{1d562}', &['\u{71}']), ('\u{1d563}', &['\u{72}']), ('\u{1d564}',
        &['\u{73}']), ('\u{1d565}', &['\u{74}']), ('\u{1d566}', &['\u{75}']), ('\u{1d567}',
        &['\u{76}']), ('\u{1d568}', &['\u{77}']), ('\u{1d569}', &['\u{78}']), ('\u{1d56a}',
        &['\u{79}']), ('\u{1d56b}', &['\u{7a}']), ('\u{1d56c}', &['\u{41}']), ('\u{1d56d}',
        &['\u{42}']), ('\u{1d56e}', &['\u{43}']), ('\u{1d56f}', &['\u{44}']), ('\u{1d570}',
        &['\u{45}']), ('\u{1d571}', &['\u{46}']), ('\u{1d572}', &['\u{47}']), ('\u{1d573}',
        &['\u{48}']), ('\u{1d574}', &['\u{49}']), ('\u{1d575}', &['\u{4a}']), ('\u{1d576}',
        &['\u{4b}']), ('\u{1d577}', &['\u{4c}']), ('\u{1d578}', &['\u{4d}']), ('\u{1d579}',
        &['\u{4e}']), ('\u{1d57a}', &['\u{4f}']), ('\u{1d57b}', &['\u{50}']), ('\u{1d57c}',
        &['\u{51}']), ('\u{1d57d}', &['\u{52}']), ('\u{1d57e}', &['\u{53}']), ('\u{1d57f}',
        &['\u{54}']), ('\u{1d580}', &['\u{55}']), ('\u{1d581}', &['\u{56}']), ('\u{1d582}',
        &['\u{57}']), ('\u{1d583}', &['\u{58}']), ('\u{1d584}', &['\u{59}']), ('\u{1d585}',
        &['\u{5a}']), ('\u{1d586}', &['\u{61}']), ('\u{1d587}', &['\u{62}']), ('\u{1d588}',
        &['\u{63}']), ('\u{1d589}', &['\u{64}']), ('\u{1d58a}', &['\u{65}']), ('\u{1d58b}',
        &['\u{66}']), ('\u{1d58c}', &['\u{67}']), ('\u{1d58d}', &['\u{68}']), ('\u{1d58e}',
        &['\u{69}']), ('\u{1d58f}', &['\u{6a}']), ('\u{1d590}', &['\u{6b}']), ('\u{1d591}',
        &['\u{6c}']), ('\u{1d592}', &['\u{6d}']), ('\u{1d593}', &['\u{6e}']), ('\u{1d594}',
        &['\u{6f}']), ('\u{1d595}', &['\u{70}']), ('\u{1d596}', &['\u{71}']), ('\u{1d597}',
        &['\u{72}']), ('\u{1d598}', &['\u{73}']), ('\u{1d599}', &['\u{74}']), ('\u{1d59a}',
        &['\u{75}']), ('\u{1d59b}', &['\u{76}']), ('\u{1d59c}', &['\u{77}']), ('\u{1d59d}',
        &['\u{78}']), ('\u{1d59e}', &['\u{79}']), ('\u{1d59f}', &['\u{7a}']), ('\u{1d5a0}',
        &['\u{41}']), ('\u{1d5a1}', &['\u{42}']), ('\u{1d5a2}', &['\u{43}']), ('\u{1d5a3}',
        &['\u{44}']), ('\u{1d5a4}', &['\u{45}']), ('\u{1d5a5}', &['\u{46}']), ('\u{1d5a6}',
        &['\u{47}']), ('\u{1d5a7}', &['\u{48}']), ('\u{1d5a8}', &['\u{49}']), ('\u{1d5a9}',
        &['\u{4a}']), ('\u{1d5aa}', &['\u{4b}']), ('\u{1d5ab}', &['\u{4c}']), ('\u{1d5ac}',
        &['\u{4d}']), ('\u{1d5ad}', &['\u{4e}']), ('\u{1d5ae}', &['\u{4f}']), ('\u{1d5af}',
        &['\u{50}']), ('\u{1d5b0}', &['\u{51}']), ('\u{1d5b1}', &['\u{52}']), ('\u{1d5b2}',
        &['\u{53}']), ('\u{1d5b3}', &['\u{54}']), ('\u{1d5b4}', &['\u{55}']), ('\u{1d5b5}',
        &['\u{56}']), ('\u{1d5b6}', &['\u{57}']), ('\u{1d5b7}', &['\u{58}']), ('\u{1d5b8}',
        &['\u{59}']), ('\u{1d5b9}', &['\u{5a}']), ('\u{1d5ba}', &['\u{61}']), ('\u{1d5bb}',
        &['\u{62}']), ('\u{1d5bc}', &['\u{63}']), ('\u{1d5bd}', &['\u{64}']), ('\u{1d5be}',
        &['\u{65}']), ('\u{1d5bf}', &['\u{66}']), ('\u{1d5c0}', &['\u{67}']), ('\u{1d5c1}',
        &['\u{68}']), ('\u{1d5c2}', &['\u{69}']), ('\u{1d5c3}', &['\u{6a}']), ('\u{1d5c4}',
        &['\u{6b}']), ('\u{1d5c5}', &['\u{6c}']), ('\u{1d5c6}', &['\u{6d}']), ('\u{1d5c7}',
        &['\u{6e}']), ('\u{1d5c8}', &['\u{6f}']), ('\u{1d5c9}', &['\u{70}']), ('\u{1d5ca}',
        &['\u{71}']), ('\u{1d5cb}', &['\u{72}']), ('\u{1d5cc}', &['\u{73}']), ('\u{1d5cd}',
        &['\u{74}']), ('\u{1d5ce}', &['\u{75}']), ('\u{1d5cf}', &['\u{76}']), ('\u{1d5d0}',
        &['\u{77}']), ('\u{1d5d1}', &['\u{78}']), ('\u{1d5d2}', &['\u{79}']), ('\u{1d5d3}',
        &['\u{7a}']), ('\u{1d5d4}', &['\u{41}']), ('\u{1d5d5}', &['\u{42}']), ('\u{1d5d6}',
        &['\u{43}']), ('\u{1d5d7}', &['\u{44}']), ('\u{1d5d8}', &['\u{45}']), ('\u{1d5d9}',
        &['\u{46}']), ('\u{1d5da}', &['\u{47}']), ('\u{1d5db}', &['\u{48}']), ('\u{1d5dc}',
        &['\u{49}']), ('\u{1d5dd}', &['\u{4a}']), ('\u{1d5de}', &['\u{4b}']), ('\u{1d5df}',
        &['\u{4c}']), ('\u{1d5e0}', &['\u{4d}']), ('\u{1d5e1}', &['\u{4e}']), ('\u{1d5e2}',
        &['\u{4f}']), ('\u{1d5e3}', &['\u{50}']), ('\u{1d5e4}', &['\u{51}']), ('\u{1d5e5}',
        &['\u{52}']), ('\u{1d5e6}', &['\u{53}']), ('\u{1d5e7}', &['\u{54}']), ('\u{1d5e8}',
        &['\u{55}']), ('\u{1d5e9}', &['\u{56}']), ('\u{1d5ea}', &['\u{57}']), ('\u{1d5eb}',
        &['\u{58}']), ('\u{1d5ec}', &['\u{59}']), ('\u{1d5ed}', &['\u{5a}']), ('\u{1d5ee}',
        &['\u{61}']), ('\u{1d5ef}', &['\u{62}']), ('\u{1d5f0}', &['\u{63}']), ('\u{1d5f1}',
        &['\u{64}']), ('\u{1d5f2}', &['\u{65}']), ('\u{1d5f3}', &['\u{66}']), ('\u{1d5f4}',
        &['\u{67}']), ('\u{1d5f5}', &['\u{68}']), ('\u{1d5f6}', &['\u{69}']), ('\u{1d5f7}',
        &['\u{6a}']), ('\u{1d5f8}', &['\u{6b}']), ('\u{1d5f9}', &['\u{6c}']), ('\u{1d5fa}',
        &['\u{6d}']), ('\u{1d5fb}', &['\u{6e}']), ('\u{1d5fc}', &['\u{6f}']), ('\u{1d5fd}',
        &['\u{70}']), ('\u{1d5fe}', &['\u{71}']), ('\u{1d5ff}', &['\u{72}']), ('\u{1d600}',
        &['\u{73}']), ('\u{1d601}', &['\u{74}']), ('\u{1d602}', &['\u{75}']), ('\u{1d603}',
        &['\u{76}']), ('\u{1d604}', &['\u{77}']), ('\u{1d605}', &['\u{78}']), ('\u{1d606}',
        &['\u{79}']), ('\u{1d607}', &['\u{7a}']), ('\u{1d608}', &['\u{41}']), ('\u{1d609}',
        &['\u{42}']), ('\u{1d60a}', &['\u{43}']), ('\u{1d60b}', &['\u{44}']), ('\u{1d60c}',
        &['\u{45}']), ('\u{1d60d}', &['\u{46}']), ('\u{1d60e}', &['\u{47}']), ('\u{1d60f}',
        &['\u{48}']), ('\u{1d610}', &['\u{49}']), ('\u{1d611}', &['\u{4a}']), ('\u{1d612}',
        &['\u{4b}']), ('\u{1d613}', &['\u{4c}']), ('\u{1d614}', &['\u{4d}']), ('\u{1d615}',
        &['\u{4e}']), ('\u{1d616}', &['\u{4f}']), ('\u{1d617}', &['\u{50}']), ('\u{1d618}',
        &['\u{51}']), ('\u{1d619}', &['\u{52}']), ('\u{1d61a}', &['\u{53}']), ('\u{1d61b}',
        &['\u{54}']), ('\u{1d61c}', &['\u{55}']), ('\u{1d61d}', &['\u{56}']), ('\u{1d61e}',
        &['\u{57}']), ('\u{1d61f}', &['\u{58}']), ('\u{1d620}', &['\u{59}']), ('\u{1d621}',
        &['\u{5a}']), ('\u{1d622}', &['\u{61}']), ('\u{1d623}', &['\u{62}']), ('\u{1d624}',
        &['\u{63}']), ('\u{1d625}', &['\u{64}']), ('\u{1d626}', &['\u{65}']), ('\u{1d627}',
        &['\u{66}']), ('\u{1d628}', &['\u{67}']), ('\u{1d629}', &['\u{68}']), ('\u{1d62a}',
        &['\u{69}']), ('\u{1d62b}', &['\u{6a}']), ('\u{1d62c}', &['\u{6b}']), ('\u{1d62d}',
        &['\u{6c}']), ('\u{1d62e}', &['\u{6d}']), ('\u{1d62f}', &['\u{6e}']), ('\u{1d630}',
        &['\u{6f}']), ('\u{1d631}', &['\u{70}']), ('\u{1d632}', &['\u{71}']), ('\u{1d633}',
        &['\u{72}']), ('\u{1d634}', &['\u{73}']), ('\u{1d635}', &['\u{74}']), ('\u{1d636}',
        &['\u{75}']), ('\u{1d637}', &['\u{76}']), ('\u{1d638}', &['\u{77}']), ('\u{1d639}',
        &['\u{78}']), ('\u{1d63a}', &['\u{79}']), ('\u{1d63b}', &['\u{7a}']), ('\u{1d63c}',
        &['\u{41}']), ('\u{1d63d}', &['\u{42}']), ('\u{1d63e}', &['\u{43}']), ('\u{1d63f}',
        &['\u{44}']), ('\u{1d640}', &['\u{45}']), ('\u{1d641}', &['\u{46}']), ('\u{1d642}',
        &['\u{47}']), ('\u{1d643}', &['\u{48}']), ('\u{1d644}', &['\u{49}']), ('\u{1d645}',
        &['\u{4a}']), ('\u{1d646}', &['\u{4b}']), ('\u{1d647}', &['\u{4c}']), ('\u{1d648}',
        &['\u{4d}']), ('\u{1d649}', &['\u{4e}']), ('\u{1d64a}', &['\u{4f}']), ('\u{1d64b}',
        &['\u{50}']), ('\u{1d64c}', &['\u{51}']), ('\u{1d64d}', &['\u{52}']), ('\u{1d64e}',
        &['\u{53}']), ('\u{1d64f}', &['\u{54}']), ('\u{1d650}', &['\u{55}']), ('\u{1d651}',
        &['\u{56}']), ('\u{1d652}', &['\u{57}']), ('\u{1d653}', &['\u{58}']), ('\u{1d654}',
        &['\u{59}']), ('\u{1d655}', &['\u{5a}']), ('\u{1d656}', &['\u{61}']), ('\u{1d657}',
        &['\u{62}']), ('\u{1d658}', &['\u{63}']), ('\u{1d659}', &['\u{64}']), ('\u{1d65a}',
        &['\u{65}']), ('\u{1d65b}', &['\u{66}']), ('\u{1d65c}', &['\u{67}']), ('\u{1d65d}',
        &['\u{68}']), ('\u{1d65e}', &['\u{69}']), ('\u{1d65f}', &['\u{6a}']), ('\u{1d660}',
        &['\u{6b}']), ('\u{1d661}', &['\u{6c}']), ('\u{1d662}', &['\u{6d}']), ('\u{1d663}',
        &['\u{6e}']), ('\u{1d664}', &['\u{6f}']), ('\u{1d665}', &['\u{70}']), ('\u{1d666}',
        &['\u{71}']), ('\u{1d667}', &['\u{72}']), ('\u{1d668}', &['\u{73}']), ('\u{1d669}',
        &['\u{74}']), ('\u{1d66a}', &['\u{75}']), ('\u{1d66b}', &['\u{76}']), ('\u{1d66c}',
        &['\u{77}']), ('\u{1d66d}', &['\u{78}']), ('\u{1d66e}', &['\u{79}']), ('\u{1d66f}',
        &['\u{7a}']), ('\u{1d670}', &['\u{41}']), ('\u{1d671}', &['\u{42}']), ('\u{1d672}',
        &['\u{43}']), ('\u{1d673}', &['\u{44}']), ('\u{1d674}', &['\u{45}']), ('\u{1d675}',
        &['\u{46}']), ('\u{1d676}', &['\u{47}']), ('\u{1d677}', &['\u{48}']), ('\u{1d678}',
        &['\u{49}']), ('\u{1d679}', &['\u{4a}']), ('\u{1d67a}', &['\u{4b}']), ('\u{1d67b}',
        &['\u{4c}']), ('\u{1d67c}', &['\u{4d}']), ('\u{1d67d}', &['\u{4e}']), ('\u{1d67e}',
        &['\u{4f}']), ('\u{1d67f}', &['\u{50}']), ('\u{1d680}', &['\u{51}']), ('\u{1d681}',
        &['\u{52}']), ('\u{1d682}', &['\u{53}']), ('\u{1d683}', &['\u{54}']), ('\u{1d684}',
        &['\u{55}']), ('\u{1d685}', &['\u{56}']), ('\u{1d686}', &['\u{57}']), ('\u{1d687}',
        &['\u{58}']), ('\u{1d688}', &['\u{59}']), ('\u{1d689}', &['\u{5a}']), ('\u{1d68a}',
        &['\u{61}']), ('\u{1d68b}', &['\u{62}']), ('\u{1d68c}', &['\u{63}']), ('\u{1d68d}',
        &['\u{64}']), ('\u{1d68e}', &['\u{65}']), ('\u{1d68f}', &['\u{66}']), ('\u{1d690}',
        &['\u{67}']), ('\u{1d691}', &['\u{68}']), ('\u{1d692}', &['\u{69}']), ('\u{1d693}',
        &['\u{6a}']), ('\u{1d694}', &['\u{6b}']), ('\u{1d695}', &['\u{6c}']), ('\u{1d696}',
        &['\u{6d}']), ('\u{1d697}', &['\u{6e}']), ('\u{1d698}', &['\u{6f}']), ('\u{1d699}',
        &['\u{70}']), ('\u{1d69a}', &['\u{71}']), ('\u{1d69b}', &['\u{72}']), ('\u{1d69c}',
        &['\u{73}']), ('\u{1d69d}', &['\u{74}']), ('\u{1d69e}', &['\u{75}']), ('\u{1d69f}',
        &['\u{76}']), ('\u{1d6a0}', &['\u{77}']), ('\u{1d6a1}', &['\u{78}']), ('\u{1d6a2}',
        &['\u{79}']), ('\u{1d6a3}', &['\u{7a}']), ('\u{1d6a4}', &['\u{131}']), ('\u{1d6a5}',
        &['\u{237}']), ('\u{1d6a8}', &['\u{391}']), ('\u{1d6a9}', &['\u{392}']), ('\u{1d6aa}',
        &['\u{393}']), ('\u{1d6ab}', &['\u{394}']), ('\u{1d6ac}', &['\u{395}']), ('\u{1d6ad}',
        &['\u{396}']), ('\u{1d6ae}', &['\u{397}']), ('\u{1d6af}', &['\u{398}']), ('\u{1d6b0}',
        &['\u{399}']), ('\u{1d6b1}', &['\u{39a}']), ('\u{1d6b2}', &['\u{39b}']), ('\u{1d6b3}',
        &['\u{39c}']), ('\u{1d6b4}', &['\u{39d}']), ('\u{1d6b5}', &['\u{39e}']), ('\u{1d6b6}',
        &['\u{39f}']), ('\u{1d6b7}', &['\u{3a0}']), ('\u{1d6b8}', &['\u{3a1}']), ('\u{1d6b9}',
        &['\u{3f4}']), ('\u{1d6ba}', &['\u{3a3}']), ('\u{1d6bb}', &['\u{3a4}']), ('\u{1d6bc}',
        &['\u{3a5}']), ('\u{1d6bd}', &['\u{3a6}']), ('\u{1d6be}', &['\u{3a7}']), ('\u{1d6bf}',
        &['\u{3a8}']), ('\u{1d6c0}', &['\u{3a9}']), ('\u{1d6c1}', &['\u{2207}']), ('\u{1d6c2}',
        &['\u{3b1}']), ('\u{1d6c3}', &['\u{3b2}']), ('\u{1d6c4}', &['\u{3b3}']), ('\u{1d6c5}',
        &['\u{3b4}']), ('\u{1d6c6}', &['\u{3b5}']), ('\u{1d6c7}', &['\u{3b6}']), ('\u{1d6c8}',
        &['\u{3b7}']), ('\u{1d6c9}', &['\u{3b8}']), ('\u{1d6ca}', &['\u{3b9}']), ('\u{1d6cb}',
        &['\u{3ba}']), ('\u{1d6cc}', &['\u{3bb}']), ('\u{1d6cd}', &['\u{3bc}']), ('\u{1d6ce}',
        &['\u{3bd}']), ('\u{1d6cf}', &['\u{3be}']), ('\u{1d6d0}', &['\u{3bf}']), ('\u{1d6d1}',
        &['\u{3c0}']), ('\u{1d6d2}', &['\u{3c1}']), ('\u{1d6d3}', &['\u{3c2}']), ('\u{1d6d4}',
        &['\u{3c3}']), ('\u{1d6d5}', &['\u{3c4}']), ('\u{1d6d6}', &['\u{3c5}']), ('\u{1d6d7}',
        &['\u{3c6}']), ('\u{1d6d8}', &['\u{3c7}']), ('\u{1d6d9}', &['\u{3c8}']), ('\u{1d6da}',
        &['\u{3c9}']), ('\u{1d6db}', &['\u{2202}']), ('\u{1d6dc}', &['\u{3f5}']), ('\u{1d6dd}',
        &['\u{3d1}']), ('\u{1d6de}', &['\u{3f0}']), ('\u{1d6df}', &['\u{3d5}']), ('\u{1d6e0}',
        &['\u{3f1}']), ('\u{1d6e1}', &['\u{3d6}']), ('\u{1d6e2}', &['\u{391}']), ('\u{1d6e3}',
        &['\u{392}']), ('\u{1d6e4}', &['\u{393}']), ('\u{1d6e5}', &['\u{394}']), ('\u{1d6e6}',
        &['\u{395}']), ('\u{1d6e7}', &['\u{396}']), ('\u{1d6e8}', &['\u{397}']), ('\u{1d6e9}',
        &['\u{398}']), ('\u{1d6ea}', &['\u{399}']), ('\u{1d6eb}', &['\u{39a}']), ('\u{1d6ec}',
        &['\u{39b}']), ('\u{1d6ed}', &['\u{39c}']), ('\u{1d6ee}', &['\u{39d}']), ('\u{1d6ef}',
        &['\u{39e}']), ('\u{1d6f0}', &['\u{39f}']), ('\u{1d6f1}', &['\u{3a0}']), ('\u{1d6f2}',
        &['\u{3a1}']), ('\u{1d6f3}', &['\u{3f4}']), ('\u{1d6f4}', &['\u{3a3}']), ('\u{1d6f5}',
        &['\u{3a4}']), ('\u{1d6f6}', &['\u{3a5}']), ('\u{1d6f7}', &['\u{3a6}']), ('\u{1d6f8}',
        &['\u{3a7}']), ('\u{1d6f9}', &['\u{3a8}']), ('\u{1d6fa}', &['\u{3a9}']), ('\u{1d6fb}',
        &['\u{2207}']), ('\u{1d6fc}', &['\u{3b1}']), ('\u{1d6fd}', &['\u{3b2}']), ('\u{1d6fe}',
        &['\u{3b3}']), ('\u{1d6ff}', &['\u{3b4}']), ('\u{1d700}', &['\u{3b5}']), ('\u{1d701}',
        &['\u{3b6}']), ('\u{1d702}', &['\u{3b7}']), ('\u{1d703}', &['\u{3b8}']), ('\u{1d704}',
        &['\u{3b9}']), ('\u{1d705}', &['\u{3ba}']), ('\u{1d706}', &['\u{3bb}']), ('\u{1d707}',
        &['\u{3bc}']), ('\u{1d708}', &['\u{3bd}']), ('\u{1d709}', &['\u{3be}']), ('\u{1d70a}',
        &['\u{3bf}']), ('\u{1d70b}', &['\u{3c0}']), ('\u{1d70c}', &['\u{3c1}']), ('\u{1d70d}',
        &['\u{3c2}']), ('\u{1d70e}', &['\u{3c3}']), ('\u{1d70f}', &['\u{3c4}']), ('\u{1d710}',
        &['\u{3c5}']), ('\u{1d711}', &['\u{3c6}']), ('\u{1d712}', &['\u{3c7}']), ('\u{1d713}',
        &['\u{3c8}']), ('\u{1d714}', &['\u{3c9}']), ('\u{1d715}', &['\u{2202}']), ('\u{1d716}',
        &['\u{3f5}']), ('\u{1d717}', &['\u{3d1}']), ('\u{1d718}', &['\u{3f0}']), ('\u{1d719}',
        &['\u{3d5}']), ('\u{1d71a}', &['\u{3f1}']), ('\u{1d71b}', &['\u{3d6}']), ('\u{1d71c}',
        &['\u{391}']), ('\u{1d71d}', &['\u{392}']), ('\u{1d71e}', &['\u{393}']), ('\u{1d71f}',
        &['\u{394}']), ('\u{1d720}', &['\u{395}']), ('\u{1d721}', &['\u{396}']), ('\u{1d722}',
        &['\u{397}']), ('\u{1d723}', &['\u{398}']), ('\u{1d724}', &['\u{399}']), ('\u{1d725}',
        &['\u{39a}']), ('\u{1d726}', &['\u{39b}']), ('\u{1d727}', &['\u{39c}']), ('\u{1d728}',
        &['\u{39d}']), ('\u{1d729}', &['\u{39e}']), ('\u{1d72a}', &['\u{39f}']), ('\u{1d72b}',
        &['\u{3a0}']), ('\u{1d72c}', &['\u{3a1}']), ('\u{1d72d}', &['\u{3f4}']), ('\u{1d72e}',
        &['\u{3a3}']), ('\u{1d72f}', &['\u{3a4}']), ('\u{1d730}', &['\u{3a5}']), ('\u{1d731}',
        &['\u{3a6}']), ('\u{1d732}', &['\u{3a7}']), ('\u{1d733}', &['\u{3a8}']), ('\u{1d734}',
        &['\u{3a9}']), ('\u{1d735}', &['\u{2207}']), ('\u{1d736}', &['\u{3b1}']), ('\u{1d737}',
        &['\u{3b2}']), ('\u{1d738}', &['\u{3b3}']), ('\u{1d739}', &['\u{3b4}']), ('\u{1d73a}',
        &['\u{3b5}']), ('\u{1d73b}', &['\u{3b6}']), ('\u{1d73c}', &['\u{3b7}']), ('\u{1d73d}',
        &['\u{3b8}']), ('\u{1d73e}', &['\u{3b9}']), ('\u{1d73f}', &['\u{3ba}']), ('\u{1d740}',
        &['\u{3bb}']), ('\u{1d741}', &['\u{3bc}']), ('\u{1d742}', &['\u{3bd}']), ('\u{1d743}',
        &['\u{3be}']), ('\u{1d744}', &['\u{3bf}']), ('\u{1d745}', &['\u{3c0}']), ('\u{1d746}',
        &['\u{3c1}']), ('\u{1d747}', &['\u{3c2}']), ('\u{1d748}', &['\u{3c3}']), ('\u{1d749}',
        &['\u{3c4}']), ('\u{1d74a}', &['\u{3c5}']), ('\u{1d74b}', &['\u{3c6}']), ('\u{1d74c}',
        &['\u{3c7}']), ('\u{1d74d}', &['\u{3c8}']), ('\u{1d74e}', &['\u{3c9}']), ('\u{1d74f}',
        &['\u{2202}']), ('\u{1d750}', &['\u{3f5}']), ('\u{1d751}', &['\u{3d1}']), ('\u{1d752}',
        &['\u{3f0}']), ('\u{1d753}', &['\u{3d5}']), ('\u{1d754}', &['\u{3f1}']), ('\u{1d755}',
        &['\u{3d6}']), ('\u{1d756}', &['\u{391}']), ('\u{1d757}', &['\u{392}']), ('\u{1d758}',
        &['\u{393}']), ('\u{1d759}', &['\u{394}']), ('\u{1d75a}', &['\u{395}']), ('\u{1d75b}',
        &['\u{396}']), ('\u{1d75c}', &['\u{397}']), ('\u{1d75d}', &['\u{398}']), ('\u{1d75e}',
        &['\u{399}']), ('\u{1d75f}', &['\u{39a}']), ('\u{1d760}', &['\u{39b}']), ('\u{1d761}',
        &['\u{39c}']), ('\u{1d762}', &['\u{39d}']), ('\u{1d763}', &['\u{39e}']), ('\u{1d764}',
        &['\u{39f}']), ('\u{1d765}', &['\u{3a0}']), ('\u{1d766}', &['\u{3a1}']), ('\u{1d767}',
        &['\u{3f4}']), ('\u{1d768}', &['\u{3a3}']), ('\u{1d769}', &['\u{3a4}']), ('\u{1d76a}',
        &['\u{3a5}']), ('\u{1d76b}', &['\u{3a6}']), ('\u{1d76c}', &['\u{3a7}']), ('\u{1d76d}',
        &['\u{3a8}']), ('\u{1d76e}', &['\u{3a9}']), ('\u{1d76f}', &['\u{2207}']), ('\u{1d770}',
        &['\u{3b1}']), ('\u{1d771}', &['\u{3b2}']), ('\u{1d772}', &['\u{3b3}']), ('\u{1d773}',
        &['\u{3b4}']), ('\u{1d774}', &['\u{3b5}']), ('\u{1d775}', &['\u{3b6}']), ('\u{1d776}',
        &['\u{3b7}']), ('\u{1d777}', &['\u{3b8}']), ('\u{1d778}', &['\u{3b9}']), ('\u{1d779}',
        &['\u{3ba}']), ('\u{1d77a}', &['\u{3bb}']), ('\u{1d77b}', &['\u{3bc}']), ('\u{1d77c}',
        &['\u{3bd}']), ('\u{1d77d}', &['\u{3be}']), ('\u{1d77e}', &['\u{3bf}']), ('\u{1d77f}',
        &['\u{3c0}']), ('\u{1d780}', &['\u{3c1}']), ('\u{1d781}', &['\u{3c2}']), ('\u{1d782}',
        &['\u{3c3}']), ('\u{1d783}', &['\u{3c4}']), ('\u{1d784}', &['\u{3c5}']), ('\u{1d785}',
        &['\u{3c6}']), ('\u{1d786}', &['\u{3c7}']), ('\u{1d787}', &['\u{3c8}']), ('\u{1d788}',
        &['\u{3c9}']), ('\u{1d789}', &['\u{2202}']), ('\u{1d78a}', &['\u{3f5}']), ('\u{1d78b}',
        &['\u{3d1}']), ('\u{1d78c}', &['\u{3f0}']), ('\u{1d78d}', &['\u{3d5}']), ('\u{1d78e}',
        &['\u{3f1}']), ('\u{1d78f}', &['\u{3d6}']), ('\u{1d790}', &['\u{391}']), ('\u{1d791}',
        &['\u{392}']), ('\u{1d792}', &['\u{393}']), ('\u{1d793}', &['\u{394}']), ('\u{1d794}',
        &['\u{395}']), ('\u{1d795}', &['\u{396}']), ('\u{1d796}', &['\u{397}']), ('\u{1d797}',
        &['\u{398}']), ('\u{1d798}', &['\u{399}']), ('\u{1d799}', &['\u{39a}']), ('\u{1d79a}',
        &['\u{39b}']), ('\u{1d79b}', &['\u{39c}']), ('\u{1d79c}', &['\u{39d}']), ('\u{1d79d}',
        &['\u{39e}']), ('\u{1d79e}', &['\u{39f}']), ('\u{1d79f}', &['\u{3a0}']), ('\u{1d7a0}',
        &['\u{3a1}']), ('\u{1d7a1}', &['\u{3f4}']), ('\u{1d7a2}', &['\u{3a3}']), ('\u{1d7a3}',
        &['\u{3a4}']), ('\u{1d7a4}', &['\u{3a5}']), ('\u{1d7a5}', &['\u{3a6}']), ('\u{1d7a6}',
        &['\u{3a7}']), ('\u{1d7a7}', &['\u{3a8}']), ('\u{1d7a8}', &['\u{3a9}']), ('\u{1d7a9}',
        &['\u{2207}']), ('\u{1d7aa}', &['\u{3b1}']), ('\u{1d7ab}', &['\u{3b2}']), ('\u{1d7ac}',
        &['\u{3b3}']), ('\u{1d7ad}', &['\u{3b4}']), ('\u{1d7ae}', &['\u{3b5}']), ('\u{1d7af}',
        &['\u{3b6}']), ('\u{1d7b0}', &['\u{3b7}']), ('\u{1d7b1}', &['\u{3b8}']), ('\u{1d7b2}',
        &['\u{3b9}']), ('\u{1d7b3}', &['\u{3ba}']), ('\u{1d7b4}', &['\u{3bb}']), ('\u{1d7b5}',
        &['\u{3bc}']), ('\u{1d7b6}', &['\u{3bd}']), ('\u{1d7b7}', &['\u{3be}']), ('\u{1d7b8}',
        &['\u{3bf}']), ('\u{1d7b9}', &['\u{3c0}']), ('\u{1d7ba}', &['\u{3c1}']), ('\u{1d7bb}',
        &['\u{3c2}']), ('\u{1d7bc}', &['\u{3c3}']), ('\u{1d7bd}', &['\u{3c4}']), ('\u{1d7be}',
        &['\u{3c5}']), ('\u{1d7bf}', &['\u{3c6}']), ('\u{1d7c0}', &['\u{3c7}']), ('\u{1d7c1}',
        &['\u{3c8}']), ('\u{1d7c2}', &['\u{3c9}']), ('\u{1d7c3}', &['\u{2202}']), ('\u{1d7c4}',
        &['\u{3f5}']), ('\u{1d7c5}', &['\u{3d1}']), ('\u{1d7c6}', &['\u{3f0}']), ('\u{1d7c7}',
        &['\u{3d5}']), ('\u{1d7c8}', &['\u{3f1}']), ('\u{1d7c9}', &['\u{3d6}']), ('\u{1d7ca}',
        &['\u{3dc}']), ('\u{1d7cb}', &['\u{3dd}']), ('\u{1d7ce}', &['\u{30}']), ('\u{1d7cf}',
        &['\u{31}']), ('\u{1d7d0}', &['\u{32}']), ('\u{1d7d1}', &['\u{33}']), ('\u{1d7d2}',
        &['\u{34}']), ('\u{1d7d3}', &['\u{35}']), ('\u{1d7d4}', &['\u{36}']), ('\u{1d7d5}',
        &['\u{37}']), ('\u{1d7d6}', &['\u{38}']), ('\u{1d7d7}', &['\u{39}']), ('\u{1d7d8}',
        &['\u{30}']), ('\u{1d7d9}', &['\u{31}']), ('\u{1d7da}', &['\u{32}']), ('\u{1d7db}',
        &['\u{33}']), ('\u{1d7dc}', &['\u{34}']), ('\u{1d7dd}', &['\u{35}']), ('\u{1d7de}',
        &['\u{36}']), ('\u{1d7df}', &['\u{37}']), ('\u{1d7e0}', &['\u{38}']), ('\u{1d7e1}',
        &['\u{39}']), ('\u{1d7e2}', &['\u{30}']), ('\u{1d7e3}', &['\u{31}']), ('\u{1d7e4}',
        &['\u{32}']), ('\u{1d7e5}', &['\u{33}']), ('\u{1d7e6}', &['\u{34}']), ('\u{1d7e7}',
        &['\u{35}']), ('\u{1d7e8}', &['\u{36}']), ('\u{1d7e9}', &['\u{37}']), ('\u{1d7ea}',
        &['\u{38}']), ('\u{1d7eb}', &['\u{39}']), ('\u{1d7ec}', &['\u{30}']), ('\u{1d7ed}',
        &['\u{31}']), ('\u{1d7ee}', &['\u{32}']), ('\u{1d7ef}', &['\u{33}']), ('\u{1d7f0}',
        &['\u{34}']), ('\u{1d7f1}', &['\u{35}']), ('\u{1d7f2}', &['\u{36}']), ('\u{1d7f3}',
        &['\u{37}']), ('\u{1d7f4}', &['\u{38}']), ('\u{1d7f5}', &['\u{39}']), ('\u{1d7f6}',
        &['\u{30}']), ('\u{1d7f7}', &['\u{31}']), ('\u{1d7f8}', &['\u{32}']), ('\u{1d7f9}',
        &['\u{33}']), ('\u{1d7fa}', &['\u{34}']), ('\u{1d7fb}', &['\u{35}']), ('\u{1d7fc}',
        &['\u{36}']), ('\u{1d7fd}', &['\u{37}']), ('\u{1d7fe}', &['\u{38}']), ('\u{1d7ff}',
        &['\u{39}']), ('\u{1ee00}', &['\u{627}']), ('\u{1ee01}', &['\u{628}']), ('\u{1ee02}',
        &['\u{62c}']), ('\u{1ee03}', &['\u{62f}']), ('\u{1ee05}', &['\u{648}']), ('\u{1ee06}',
        &['\u{632}']), ('\u{1ee07}', &['\u{62d}']), ('\u{1ee08}', &['\u{637}']), ('\u{1ee09}',
        &['\u{64a}']), ('\u{1ee0a}', &['\u{643}']), ('\u{1ee0b}', &['\u{644}']), ('\u{1ee0c}',
        &['\u{645}']), ('\u{1ee0d}', &['\u{646}']), ('\u{1ee0e}', &['\u{633}']), ('\u{1ee0f}',
        &['\u{639}']), ('\u{1ee10}', &['\u{641}']), ('\u{1ee11}', &['\u{635}']), ('\u{1ee12}',
        &['\u{642}']), ('\u{1ee13}', &['\u{631}']), ('\u{1ee14}', &['\u{634}']), ('\u{1ee15}',
        &['\u{62a}']), ('\u{1ee16}', &['\u{62b}']), ('\u{1ee17}', &['\u{62e}']), ('\u{1ee18}',
        &['\u{630}']), ('\u{1ee19}', &['\u{636}']), ('\u{1ee1a}', &['\u{638}']), ('\u{1ee1b}',
        &['\u{63a}']), ('\u{1ee1c}', &['\u{66e}']), ('\u{1ee1d}', &['\u{6ba}']), ('\u{1ee1e}',
        &['\u{6a1}']), ('\u{1ee1f}', &['\u{66f}']), ('\u{1ee21}', &['\u{628}']), ('\u{1ee22}',
        &['\u{62c}']), ('\u{1ee24}', &['\u{647}']), ('\u{1ee27}', &['\u{62d}']), ('\u{1ee29}',
        &['\u{64a}']), ('\u{1ee2a}', &['\u{643}']), ('\u{1ee2b}', &['\u{644}']), ('\u{1ee2c}',
        &['\u{645}']), ('\u{1ee2d}', &['\u{646}']), ('\u{1ee2e}', &['\u{633}']), ('\u{1ee2f}',
        &['\u{639}']), ('\u{1ee30}', &['\u{641}']), ('\u{1ee31}', &['\u{635}']), ('\u{1ee32}',
        &['\u{642}']), ('\u{1ee34}', &['\u{634}']), ('\u{1ee35}', &['\u{62a}']), ('\u{1ee36}',
        &['\u{62b}']), ('\u{1ee37}', &['\u{62e}']), ('\u{1ee39}', &['\u{636}']), ('\u{1ee3b}',
        &['\u{63a}']), ('\u{1ee42}', &['\u{62c}']), ('\u{1ee47}', &['\u{62d}']), ('\u{1ee49}',
        &['\u{64a}']), ('\u{1ee4b}', &['\u{644}']), ('\u{1ee4d}', &['\u{646}']), ('\u{1ee4e}',
        &['\u{633}']), ('\u{1ee4f}', &['\u{639}']), ('\u{1ee51}', &['\u{635}']), ('\u{1ee52}',
        &['\u{642}']), ('\u{1ee54}', &['\u{634}']), ('\u{1ee57}', &['\u{62e}']), ('\u{1ee59}',
        &['\u{636}']), ('\u{1ee5b}', &['\u{63a}']), ('\u{1ee5d}', &['\u{6ba}']), ('\u{1ee5f}',
        &['\u{66f}']), ('\u{1ee61}', &['\u{628}']), ('\u{1ee62}', &['\u{62c}']), ('\u{1ee64}',
        &['\u{647}']), ('\u{1ee67}', &['\u{62d}']), ('\u{1ee68}', &['\u{637}']), ('\u{1ee69}',
        &['\u{64a}']), ('\u{1ee6a}', &['\u{643}']), ('\u{1ee6c}', &['\u{645}']), ('\u{1ee6d}',
        &['\u{646}']), ('\u{1ee6e}', &['\u{633}']), ('\u{1ee6f}', &['\u{639}']), ('\u{1ee70}',
        &['\u{641}']), ('\u{1ee71}', &['\u{635}']), ('\u{1ee72}', &['\u{642}']), ('\u{1ee74}',
        &['\u{634}']), ('\u{1ee75}', &['\u{62a}']), ('\u{1ee76}', &['\u{62b}']), ('\u{1ee77}',
        &['\u{62e}']), ('\u{1ee79}', &['\u{636}']), ('\u{1ee7a}', &['\u{638}']), ('\u{1ee7b}',
        &['\u{63a}']), ('\u{1ee7c}', &['\u{66e}']), ('\u{1ee7e}', &['\u{6a1}']), ('\u{1ee80}',
        &['\u{627}']), ('\u{1ee81}', &['\u{628}']), ('\u{1ee82}', &['\u{62c}']), ('\u{1ee83}',
        &['\u{62f}']), ('\u{1ee84}', &['\u{647}']), ('\u{1ee85}', &['\u{648}']), ('\u{1ee86}',
        &['\u{632}']), ('\u{1ee87}', &['\u{62d}']), ('\u{1ee88}', &['\u{637}']), ('\u{1ee89}',
        &['\u{64a}']), ('\u{1ee8b}', &['\u{644}']), ('\u{1ee8c}', &['\u{645}']), ('\u{1ee8d}',
        &['\u{646}']), ('\u{1ee8e}', &['\u{633}']), ('\u{1ee8f}', &['\u{639}']), ('\u{1ee90}',
        &['\u{641}']), ('\u{1ee91}', &['\u{635}']), ('\u{1ee92}', &['\u{642}']), ('\u{1ee93}',
        &['\u{631}']), ('\u{1ee94}', &['\u{634}']), ('\u{1ee95}', &['\u{62a}']), ('\u{1ee96}',
        &['\u{62b}']), ('\u{1ee97}', &['\u{62e}']), ('\u{1ee98}', &['\u{630}']), ('\u{1ee99}',
        &['\u{636}']), ('\u{1ee9a}', &['\u{638}']), ('\u{1ee9b}', &['\u{63a}']), ('\u{1eea1}',
        &['\u{628}']), ('\u{1eea2}', &['\u{62c}']), ('\u{1eea3}', &['\u{62f}']), ('\u{1eea5}',
        &['\u{648}']), ('\u{1eea6}', &['\u{632}']), ('\u{1eea7}', &['\u{62d}']), ('\u{1eea8}',
        &['\u{637}']), ('\u{1eea9}', &['\u{64a}']), ('\u{1eeab}', &['\u{644}']), ('\u{1eeac}',
        &['\u{645}']), ('\u{1eead}', &['\u{646}']), ('\u{1eeae}', &['\u{633}']), ('\u{1eeaf}',
        &['\u{639}']), ('\u{1eeb0}', &['\u{641}']), ('\u{1eeb1}', &['\u{635}']), ('\u{1eeb2}',
        &['\u{642}']), ('\u{1eeb3}', &['\u{631}']), ('\u{1eeb4}', &['\u{634}']), ('\u{1eeb5}',
        &['\u{62a}']), ('\u{1eeb6}', &['\u{62b}']), ('\u{1eeb7}', &['\u{62e}']), ('\u{1eeb8}',
        &['\u{630}']), ('\u{1eeb9}', &['\u{636}']), ('\u{1eeba}', &['\u{638}']), ('\u{1eebb}',
        &['\u{63a}']), ('\u{1f100}', &['\u{30}', '\u{2e}']), ('\u{1f101}', &['\u{30}', '\u{2c}']),
        ('\u{1f102}', &['\u{31}', '\u{2c}']), ('\u{1f103}', &['\u{32}', '\u{2c}']), ('\u{1f104}',
        &['\u{33}', '\u{2c}']), ('\u{1f105}', &['\u{34}', '\u{2c}']), ('\u{1f106}', &['\u{35}',
        '\u{2c}']), ('\u{1f107}', &['\u{36}', '\u{2c}']), ('\u{1f108}', &['\u{37}', '\u{2c}']),
        ('\u{1f109}', &['\u{38}', '\u{2c}']), ('\u{1f10a}', &['\u{39}', '\u{2c}']), ('\u{1f110}',
        &['\u{28}', '\u{41}', '\u{29}']), ('\u{1f111}', &['\u{28}', '\u{42}', '\u{29}']),
        ('\u{1f112}', &['\u{28}', '\u{43}', '\u{29}']), ('\u{1f113}', &['\u{28}', '\u{44}',
        '\u{29}']), ('\u{1f114}', &['\u{28}', '\u{45}', '\u{29}']), ('\u{1f115}', &['\u{28}',
        '\u{46}', '\u{29}']), ('\u{1f116}', &['\u{28}', '\u{47}', '\u{29}']), ('\u{1f117}',
        &['\u{28}', '\u{48}', '\u{29}']), ('\u{1f118}', &['\u{28}', '\u{49}', '\u{29}']),
        ('\u{1f119}', &['\u{28}', '\u{4a}', '\u{29}']), ('\u{1f11a}', &['\u{28}', '\u{4b}',
        '\u{29}']), ('\u{1f11b}', &['\u{28}', '\u{4c}', '\u{29}']), ('\u{1f11c}', &['\u{28}',
        '\u{4d}', '\u{29}']), ('\u{1f11d}', &['\u{28}', '\u{4e}', '\u{29}']), ('\u{1f11e}',
        &['\u{28}', '\u{4f}', '\u{29}']), ('\u{1f11f}', &['\u{28}', '\u{50}', '\u{29}']),
        ('\u{1f120}', &['\u{28}', '\u{51}', '\u{29}']), ('\u{1f121}', &['\u{28}', '\u{52}',
        '\u{29}']), ('\u{1f122}', &['\u{28}', '\u{53}', '\u{29}']), ('\u{1f123}', &['\u{28}',
        '\u{54}', '\u{29}']), ('\u{1f124}', &['\u{28}', '\u{55}', '\u{29}']), ('\u{1f125}',
        &['\u{28}', '\u{56}', '\u{29}']), ('\u{1f126}', &['\u{28}', '\u{57}', '\u{29}']),
        ('\u{1f127}', &['\u{28}', '\u{58}', '\u{29}']), ('\u{1f128}', &['\u{28}', '\u{59}',
        '\u{29}']), ('\u{1f129}', &['\u{28}', '\u{5a}', '\u{29}']), ('\u{1f12a}', &['\u{3014}',
        '\u{53}', '\u{3015}']), ('\u{1f12b}', &['\u{43}']), ('\u{1f12c}', &['\u{52}']),
        ('\u{1f12d}', &['\u{43}', '\u{44}']), ('\u{1f12e}', &['\u{57}', '\u{5a}']), ('\u{1f130}',
        &['\u{41}']), ('\u{1f131}', &['\u{42}']), ('\u{1f132}', &['\u{43}']), ('\u{1f133}',
        &['\u{44}']), ('\u{1f134}', &['\u{45}']), ('\u{1f135}', &['\u{46}']), ('\u{1f136}',
        &['\u{47}']), ('\u{1f137}', &['\u{48}']), ('\u{1f138}', &['\u{49}']), ('\u{1f139}',
        &['\u{4a}']), ('\u{1f13a}', &['\u{4b}']), ('\u{1f13b}', &['\u{4c}']), ('\u{1f13c}',
        &['\u{4d}']), ('\u{1f13d}', &['\u{4e}']), ('\u{1f13e}', &['\u{4f}']), ('\u{1f13f}',
        &['\u{50}']), ('\u{1f140}', &['\u{51}']), ('\u{1f141}', &['\u{52}']), ('\u{1f142}',
        &['\u{53}']), ('\u{1f143}', &['\u{54}']), ('\u{1f144}', &['\u{55}']), ('\u{1f145}',
        &['\u{56}']), ('\u{1f146}', &['\u{57}']), ('\u{1f147}', &['\u{58}']), ('\u{1f148}',
        &['\u{59}']), ('\u{1f149}', &['\u{5a}']), ('\u{1f14a}', &['\u{48}', '\u{56}']),
        ('\u{1f14b}', &['\u{4d}', '\u{56}']), ('\u{1f14c}', &['\u{53}', '\u{44}']), ('\u{1f14d}',
        &['\u{53}', '\u{53}']), ('\u{1f14e}', &['\u{50}', '\u{50}', '\u{56}']), ('\u{1f14f}',
        &['\u{57}', '\u{43}']), ('\u{1f16a}', &['\u{4d}', '\u{43}']), ('\u{1f16b}', &['\u{4d}',
        '\u{44}']), ('\u{1f190}', &['\u{44}', '\u{4a}']), ('\u{1f200}', &['\u{307b}', '\u{304b}']),
        ('\u{1f201}', &['\u{30b3}', '\u{30b3}']), ('\u{1f202}', &['\u{30b5}']), ('\u{1f210}',
        &['\u{624b}']), ('\u{1f211}', &['\u{5b57}']), ('\u{1f212}', &['\u{53cc}']), ('\u{1f213}',
        &['\u{30c7}']), ('\u{1f214}', &['\u{4e8c}']), ('\u{1f215}', &['\u{591a}']), ('\u{1f216}',
        &['\u{89e3}']), ('\u{1f217}', &['\u{5929}']), ('\u{1f218}', &['\u{4ea4}']), ('\u{1f219}',
        &['\u{6620}']), ('\u{1f21a}', &['\u{7121}']), ('\u{1f21b}', &['\u{6599}']), ('\u{1f21c}',
        &['\u{524d}']), ('\u{1f21d}', &['\u{5f8c}']), ('\u{1f21e}', &['\u{518d}']), ('\u{1f21f}',
        &['\u{65b0}']), ('\u{1f220}', &['\u{521d}']), ('\u{1f221}', &['\u{7d42}']), ('\u{1f222}',
        &['\u{751f}']), ('\u{1f223}', &['\u{8ca9}']), ('\u{1f224}', &['\u{58f0}']), ('\u{1f225}',
        &['\u{5439}']), ('\u{1f226}', &['\u{6f14}']), ('\u{1f227}', &['\u{6295}']), ('\u{1f228}',
        &['\u{6355}']), ('\u{1f229}', &['\u{4e00}']), ('\u{1f22a}', &['\u{4e09}']), ('\u{1f22b}',
        &['\u{904a}']), ('\u{1f22c}', &['\u{5de6}']), ('\u{1f22d}', &['\u{4e2d}']), ('\u{1f22e}',
        &['\u{53f3}']), ('\u{1f22f}', &['\u{6307}']), ('\u{1f230}', &['\u{8d70}']), ('\u{1f231}',
        &['\u{6253}']), ('\u{1f232}', &['\u{7981}']), ('\u{1f233}', &['\u{7a7a}']), ('\u{1f234}',
        &['\u{5408}']), ('\u{1f235}', &['\u{6e80}']), ('\u{1f236}', &['\u{6709}']), ('\u{1f237}',
        &['\u{6708}']), ('\u{1f238}', &['\u{7533}']), ('\u{1f239}', &['\u{5272}']), ('\u{1f23a}',
        &['\u{55b6}']), ('\u{1f240}', &['\u{3014}', '\u{672c}', '\u{3015}']), ('\u{1f241}',
        &['\u{3014}', '\u{4e09}', '\u{3015}']), ('\u{1f242}', &['\u{3014}', '\u{4e8c}',
        '\u{3015}']), ('\u{1f243}', &['\u{3014}', '\u{5b89}', '\u{3015}']), ('\u{1f244}',
        &['\u{3014}', '\u{70b9}', '\u{3015}']), ('\u{1f245}', &['\u{3014}', '\u{6253}',
        '\u{3015}']), ('\u{1f246}', &['\u{3014}', '\u{76d7}', '\u{3015}']), ('\u{1f247}',
        &['\u{3014}', '\u{52dd}', '\u{3015}']), ('\u{1f248}', &['\u{3014}', '\u{6557}',
        '\u{3015}']), ('\u{1f250}', &['\u{5f97}']), ('\u{1f251}', &['\u{53ef}'])
    ];

    // Canonical compositions
    pub static composition_table: &'static [(char, &'static [(char, char)])] = &[
        ('\u{3c}', &[('\u{338}', '\u{226e}')]), ('\u{3d}', &[('\u{338}', '\u{2260}')]), ('\u{3e}',
        &[('\u{338}', '\u{226f}')]), ('\u{41}', &[('\u{300}', '\u{c0}'), ('\u{301}', '\u{c1}'),
        ('\u{302}', '\u{c2}'), ('\u{303}', '\u{c3}'), ('\u{304}', '\u{100}'), ('\u{306}',
        '\u{102}'), ('\u{307}', '\u{226}'), ('\u{308}', '\u{c4}'), ('\u{309}', '\u{1ea2}'),
        ('\u{30a}', '\u{c5}'), ('\u{30c}', '\u{1cd}'), ('\u{30f}', '\u{200}'), ('\u{311}',
        '\u{202}'), ('\u{323}', '\u{1ea0}'), ('\u{325}', '\u{1e00}'), ('\u{328}', '\u{104}')]),
        ('\u{42}', &[('\u{307}', '\u{1e02}'), ('\u{323}', '\u{1e04}'), ('\u{331}', '\u{1e06}')]),
        ('\u{43}', &[('\u{301}', '\u{106}'), ('\u{302}', '\u{108}'), ('\u{307}', '\u{10a}'),
        ('\u{30c}', '\u{10c}'), ('\u{327}', '\u{c7}')]), ('\u{44}', &[('\u{307}', '\u{1e0a}'),
        ('\u{30c}', '\u{10e}'), ('\u{323}', '\u{1e0c}'), ('\u{327}', '\u{1e10}'), ('\u{32d}',
        '\u{1e12}'), ('\u{331}', '\u{1e0e}')]), ('\u{45}', &[('\u{300}', '\u{c8}'), ('\u{301}',
        '\u{c9}'), ('\u{302}', '\u{ca}'), ('\u{303}', '\u{1ebc}'), ('\u{304}', '\u{112}'),
        ('\u{306}', '\u{114}'), ('\u{307}', '\u{116}'), ('\u{308}', '\u{cb}'), ('\u{309}',
        '\u{1eba}'), ('\u{30c}', '\u{11a}'), ('\u{30f}', '\u{204}'), ('\u{311}', '\u{206}'),
        ('\u{323}', '\u{1eb8}'), ('\u{327}', '\u{228}'), ('\u{328}', '\u{118}'), ('\u{32d}',
        '\u{1e18}'), ('\u{330}', '\u{1e1a}')]), ('\u{46}', &[('\u{307}', '\u{1e1e}')]), ('\u{47}',
        &[('\u{301}', '\u{1f4}'), ('\u{302}', '\u{11c}'), ('\u{304}', '\u{1e20}'), ('\u{306}',
        '\u{11e}'), ('\u{307}', '\u{120}'), ('\u{30c}', '\u{1e6}'), ('\u{327}', '\u{122}')]),
        ('\u{48}', &[('\u{302}', '\u{124}'), ('\u{307}', '\u{1e22}'), ('\u{308}', '\u{1e26}'),
        ('\u{30c}', '\u{21e}'), ('\u{323}', '\u{1e24}'), ('\u{327}', '\u{1e28}'), ('\u{32e}',
        '\u{1e2a}')]), ('\u{49}', &[('\u{300}', '\u{cc}'), ('\u{301}', '\u{cd}'), ('\u{302}',
        '\u{ce}'), ('\u{303}', '\u{128}'), ('\u{304}', '\u{12a}'), ('\u{306}', '\u{12c}'),
        ('\u{307}', '\u{130}'), ('\u{308}', '\u{cf}'), ('\u{309}', '\u{1ec8}'), ('\u{30c}',
        '\u{1cf}'), ('\u{30f}', '\u{208}'), ('\u{311}', '\u{20a}'), ('\u{323}', '\u{1eca}'),
        ('\u{328}', '\u{12e}'), ('\u{330}', '\u{1e2c}')]), ('\u{4a}', &[('\u{302}', '\u{134}')]),
        ('\u{4b}', &[('\u{301}', '\u{1e30}'), ('\u{30c}', '\u{1e8}'), ('\u{323}', '\u{1e32}'),
        ('\u{327}', '\u{136}'), ('\u{331}', '\u{1e34}')]), ('\u{4c}', &[('\u{301}', '\u{139}'),
        ('\u{30c}', '\u{13d}'), ('\u{323}', '\u{1e36}'), ('\u{327}', '\u{13b}'), ('\u{32d}',
        '\u{1e3c}'), ('\u{331}', '\u{1e3a}')]), ('\u{4d}', &[('\u{301}', '\u{1e3e}'), ('\u{307}',
        '\u{1e40}'), ('\u{323}', '\u{1e42}')]), ('\u{4e}', &[('\u{300}', '\u{1f8}'), ('\u{301}',
        '\u{143}'), ('\u{303}', '\u{d1}'), ('\u{307}', '\u{1e44}'), ('\u{30c}', '\u{147}'),
        ('\u{323}', '\u{1e46}'), ('\u{327}', '\u{145}'), ('\u{32d}', '\u{1e4a}'), ('\u{331}',
        '\u{1e48}')]), ('\u{4f}', &[('\u{300}', '\u{d2}'), ('\u{301}', '\u{d3}'), ('\u{302}',
        '\u{d4}'), ('\u{303}', '\u{d5}'), ('\u{304}', '\u{14c}'), ('\u{306}', '\u{14e}'),
        ('\u{307}', '\u{22e}'), ('\u{308}', '\u{d6}'), ('\u{309}', '\u{1ece}'), ('\u{30b}',
        '\u{150}'), ('\u{30c}', '\u{1d1}'), ('\u{30f}', '\u{20c}'), ('\u{311}', '\u{20e}'),
        ('\u{31b}', '\u{1a0}'), ('\u{323}', '\u{1ecc}'), ('\u{328}', '\u{1ea}')]), ('\u{50}',
        &[('\u{301}', '\u{1e54}'), ('\u{307}', '\u{1e56}')]), ('\u{52}', &[('\u{301}', '\u{154}'),
        ('\u{307}', '\u{1e58}'), ('\u{30c}', '\u{158}'), ('\u{30f}', '\u{210}'), ('\u{311}',
        '\u{212}'), ('\u{323}', '\u{1e5a}'), ('\u{327}', '\u{156}'), ('\u{331}', '\u{1e5e}')]),
        ('\u{53}', &[('\u{301}', '\u{15a}'), ('\u{302}', '\u{15c}'), ('\u{307}', '\u{1e60}'),
        ('\u{30c}', '\u{160}'), ('\u{323}', '\u{1e62}'), ('\u{326}', '\u{218}'), ('\u{327}',
        '\u{15e}')]), ('\u{54}', &[('\u{307}', '\u{1e6a}'), ('\u{30c}', '\u{164}'), ('\u{323}',
        '\u{1e6c}'), ('\u{326}', '\u{21a}'), ('\u{327}', '\u{162}'), ('\u{32d}', '\u{1e70}'),
        ('\u{331}', '\u{1e6e}')]), ('\u{55}', &[('\u{300}', '\u{d9}'), ('\u{301}', '\u{da}'),
        ('\u{302}', '\u{db}'), ('\u{303}', '\u{168}'), ('\u{304}', '\u{16a}'), ('\u{306}',
        '\u{16c}'), ('\u{308}', '\u{dc}'), ('\u{309}', '\u{1ee6}'), ('\u{30a}', '\u{16e}'),
        ('\u{30b}', '\u{170}'), ('\u{30c}', '\u{1d3}'), ('\u{30f}', '\u{214}'), ('\u{311}',
        '\u{216}'), ('\u{31b}', '\u{1af}'), ('\u{323}', '\u{1ee4}'), ('\u{324}', '\u{1e72}'),
        ('\u{328}', '\u{172}'), ('\u{32d}', '\u{1e76}'), ('\u{330}', '\u{1e74}')]), ('\u{56}',
        &[('\u{303}', '\u{1e7c}'), ('\u{323}', '\u{1e7e}')]), ('\u{57}', &[('\u{300}', '\u{1e80}'),
        ('\u{301}', '\u{1e82}'), ('\u{302}', '\u{174}'), ('\u{307}', '\u{1e86}'), ('\u{308}',
        '\u{1e84}'), ('\u{323}', '\u{1e88}')]), ('\u{58}', &[('\u{307}', '\u{1e8a}'), ('\u{308}',
        '\u{1e8c}')]), ('\u{59}', &[('\u{300}', '\u{1ef2}'), ('\u{301}', '\u{dd}'), ('\u{302}',
        '\u{176}'), ('\u{303}', '\u{1ef8}'), ('\u{304}', '\u{232}'), ('\u{307}', '\u{1e8e}'),
        ('\u{308}', '\u{178}'), ('\u{309}', '\u{1ef6}'), ('\u{323}', '\u{1ef4}')]), ('\u{5a}',
        &[('\u{301}', '\u{179}'), ('\u{302}', '\u{1e90}'), ('\u{307}', '\u{17b}'), ('\u{30c}',
        '\u{17d}'), ('\u{323}', '\u{1e92}'), ('\u{331}', '\u{1e94}')]), ('\u{61}', &[('\u{300}',
        '\u{e0}'), ('\u{301}', '\u{e1}'), ('\u{302}', '\u{e2}'), ('\u{303}', '\u{e3}'), ('\u{304}',
        '\u{101}'), ('\u{306}', '\u{103}'), ('\u{307}', '\u{227}'), ('\u{308}', '\u{e4}'),
        ('\u{309}', '\u{1ea3}'), ('\u{30a}', '\u{e5}'), ('\u{30c}', '\u{1ce}'), ('\u{30f}',
        '\u{201}'), ('\u{311}', '\u{203}'), ('\u{323}', '\u{1ea1}'), ('\u{325}', '\u{1e01}'),
        ('\u{328}', '\u{105}')]), ('\u{62}', &[('\u{307}', '\u{1e03}'), ('\u{323}', '\u{1e05}'),
        ('\u{331}', '\u{1e07}')]), ('\u{63}', &[('\u{301}', '\u{107}'), ('\u{302}', '\u{109}'),
        ('\u{307}', '\u{10b}'), ('\u{30c}', '\u{10d}'), ('\u{327}', '\u{e7}')]), ('\u{64}',
        &[('\u{307}', '\u{1e0b}'), ('\u{30c}', '\u{10f}'), ('\u{323}', '\u{1e0d}'), ('\u{327}',
        '\u{1e11}'), ('\u{32d}', '\u{1e13}'), ('\u{331}', '\u{1e0f}')]), ('\u{65}', &[('\u{300}',
        '\u{e8}'), ('\u{301}', '\u{e9}'), ('\u{302}', '\u{ea}'), ('\u{303}', '\u{1ebd}'),
        ('\u{304}', '\u{113}'), ('\u{306}', '\u{115}'), ('\u{307}', '\u{117}'), ('\u{308}',
        '\u{eb}'), ('\u{309}', '\u{1ebb}'), ('\u{30c}', '\u{11b}'), ('\u{30f}', '\u{205}'),
        ('\u{311}', '\u{207}'), ('\u{323}', '\u{1eb9}'), ('\u{327}', '\u{229}'), ('\u{328}',
        '\u{119}'), ('\u{32d}', '\u{1e19}'), ('\u{330}', '\u{1e1b}')]), ('\u{66}', &[('\u{307}',
        '\u{1e1f}')]), ('\u{67}', &[('\u{301}', '\u{1f5}'), ('\u{302}', '\u{11d}'), ('\u{304}',
        '\u{1e21}'), ('\u{306}', '\u{11f}'), ('\u{307}', '\u{121}'), ('\u{30c}', '\u{1e7}'),
        ('\u{327}', '\u{123}')]), ('\u{68}', &[('\u{302}', '\u{125}'), ('\u{307}', '\u{1e23}'),
        ('\u{308}', '\u{1e27}'), ('\u{30c}', '\u{21f}'), ('\u{323}', '\u{1e25}'), ('\u{327}',
        '\u{1e29}'), ('\u{32e}', '\u{1e2b}'), ('\u{331}', '\u{1e96}')]), ('\u{69}', &[('\u{300}',
        '\u{ec}'), ('\u{301}', '\u{ed}'), ('\u{302}', '\u{ee}'), ('\u{303}', '\u{129}'), ('\u{304}',
        '\u{12b}'), ('\u{306}', '\u{12d}'), ('\u{308}', '\u{ef}'), ('\u{309}', '\u{1ec9}'),
        ('\u{30c}', '\u{1d0}'), ('\u{30f}', '\u{209}'), ('\u{311}', '\u{20b}'), ('\u{323}',
        '\u{1ecb}'), ('\u{328}', '\u{12f}'), ('\u{330}', '\u{1e2d}')]), ('\u{6a}', &[('\u{302}',
        '\u{135}'), ('\u{30c}', '\u{1f0}')]), ('\u{6b}', &[('\u{301}', '\u{1e31}'), ('\u{30c}',
        '\u{1e9}'), ('\u{323}', '\u{1e33}'), ('\u{327}', '\u{137}'), ('\u{331}', '\u{1e35}')]),
        ('\u{6c}', &[('\u{301}', '\u{13a}'), ('\u{30c}', '\u{13e}'), ('\u{323}', '\u{1e37}'),
        ('\u{327}', '\u{13c}'), ('\u{32d}', '\u{1e3d}'), ('\u{331}', '\u{1e3b}')]), ('\u{6d}',
        &[('\u{301}', '\u{1e3f}'), ('\u{307}', '\u{1e41}'), ('\u{323}', '\u{1e43}')]), ('\u{6e}',
        &[('\u{300}', '\u{1f9}'), ('\u{301}', '\u{144}'), ('\u{303}', '\u{f1}'), ('\u{307}',
        '\u{1e45}'), ('\u{30c}', '\u{148}'), ('\u{323}', '\u{1e47}'), ('\u{327}', '\u{146}'),
        ('\u{32d}', '\u{1e4b}'), ('\u{331}', '\u{1e49}')]), ('\u{6f}', &[('\u{300}', '\u{f2}'),
        ('\u{301}', '\u{f3}'), ('\u{302}', '\u{f4}'), ('\u{303}', '\u{f5}'), ('\u{304}', '\u{14d}'),
        ('\u{306}', '\u{14f}'), ('\u{307}', '\u{22f}'), ('\u{308}', '\u{f6}'), ('\u{309}',
        '\u{1ecf}'), ('\u{30b}', '\u{151}'), ('\u{30c}', '\u{1d2}'), ('\u{30f}', '\u{20d}'),
        ('\u{311}', '\u{20f}'), ('\u{31b}', '\u{1a1}'), ('\u{323}', '\u{1ecd}'), ('\u{328}',
        '\u{1eb}')]), ('\u{70}', &[('\u{301}', '\u{1e55}'), ('\u{307}', '\u{1e57}')]), ('\u{72}',
        &[('\u{301}', '\u{155}'), ('\u{307}', '\u{1e59}'), ('\u{30c}', '\u{159}'), ('\u{30f}',
        '\u{211}'), ('\u{311}', '\u{213}'), ('\u{323}', '\u{1e5b}'), ('\u{327}', '\u{157}'),
        ('\u{331}', '\u{1e5f}')]), ('\u{73}', &[('\u{301}', '\u{15b}'), ('\u{302}', '\u{15d}'),
        ('\u{307}', '\u{1e61}'), ('\u{30c}', '\u{161}'), ('\u{323}', '\u{1e63}'), ('\u{326}',
        '\u{219}'), ('\u{327}', '\u{15f}')]), ('\u{74}', &[('\u{307}', '\u{1e6b}'), ('\u{308}',
        '\u{1e97}'), ('\u{30c}', '\u{165}'), ('\u{323}', '\u{1e6d}'), ('\u{326}', '\u{21b}'),
        ('\u{327}', '\u{163}'), ('\u{32d}', '\u{1e71}'), ('\u{331}', '\u{1e6f}')]), ('\u{75}',
        &[('\u{300}', '\u{f9}'), ('\u{301}', '\u{fa}'), ('\u{302}', '\u{fb}'), ('\u{303}',
        '\u{169}'), ('\u{304}', '\u{16b}'), ('\u{306}', '\u{16d}'), ('\u{308}', '\u{fc}'),
        ('\u{309}', '\u{1ee7}'), ('\u{30a}', '\u{16f}'), ('\u{30b}', '\u{171}'), ('\u{30c}',
        '\u{1d4}'), ('\u{30f}', '\u{215}'), ('\u{311}', '\u{217}'), ('\u{31b}', '\u{1b0}'),
        ('\u{323}', '\u{1ee5}'), ('\u{324}', '\u{1e73}'), ('\u{328}', '\u{173}'), ('\u{32d}',
        '\u{1e77}'), ('\u{330}', '\u{1e75}')]), ('\u{76}', &[('\u{303}', '\u{1e7d}'), ('\u{323}',
        '\u{1e7f}')]), ('\u{77}', &[('\u{300}', '\u{1e81}'), ('\u{301}', '\u{1e83}'), ('\u{302}',
        '\u{175}'), ('\u{307}', '\u{1e87}'), ('\u{308}', '\u{1e85}'), ('\u{30a}', '\u{1e98}'),
        ('\u{323}', '\u{1e89}')]), ('\u{78}', &[('\u{307}', '\u{1e8b}'), ('\u{308}', '\u{1e8d}')]),
        ('\u{79}', &[('\u{300}', '\u{1ef3}'), ('\u{301}', '\u{fd}'), ('\u{302}', '\u{177}'),
        ('\u{303}', '\u{1ef9}'), ('\u{304}', '\u{233}'), ('\u{307}', '\u{1e8f}'), ('\u{308}',
        '\u{ff}'), ('\u{309}', '\u{1ef7}'), ('\u{30a}', '\u{1e99}'), ('\u{323}', '\u{1ef5}')]),
        ('\u{7a}', &[('\u{301}', '\u{17a}'), ('\u{302}', '\u{1e91}'), ('\u{307}', '\u{17c}'),
        ('\u{30c}', '\u{17e}'), ('\u{323}', '\u{1e93}'), ('\u{331}', '\u{1e95}')]), ('\u{a8}',
        &[('\u{300}', '\u{1fed}'), ('\u{301}', '\u{385}'), ('\u{342}', '\u{1fc1}')]), ('\u{c2}',
        &[('\u{300}', '\u{1ea6}'), ('\u{301}', '\u{1ea4}'), ('\u{303}', '\u{1eaa}'), ('\u{309}',
        '\u{1ea8}')]), ('\u{c4}', &[('\u{304}', '\u{1de}')]), ('\u{c5}', &[('\u{301}', '\u{1fa}')]),
        ('\u{c6}', &[('\u{301}', '\u{1fc}'), ('\u{304}', '\u{1e2}')]), ('\u{c7}', &[('\u{301}',
        '\u{1e08}')]), ('\u{ca}', &[('\u{300}', '\u{1ec0}'), ('\u{301}', '\u{1ebe}'), ('\u{303}',
        '\u{1ec4}'), ('\u{309}', '\u{1ec2}')]), ('\u{cf}', &[('\u{301}', '\u{1e2e}')]), ('\u{d4}',
        &[('\u{300}', '\u{1ed2}'), ('\u{301}', '\u{1ed0}'), ('\u{303}', '\u{1ed6}'), ('\u{309}',
        '\u{1ed4}')]), ('\u{d5}', &[('\u{301}', '\u{1e4c}'), ('\u{304}', '\u{22c}'), ('\u{308}',
        '\u{1e4e}')]), ('\u{d6}', &[('\u{304}', '\u{22a}')]), ('\u{d8}', &[('\u{301}', '\u{1fe}')]),
        ('\u{dc}', &[('\u{300}', '\u{1db}'), ('\u{301}', '\u{1d7}'), ('\u{304}', '\u{1d5}'),
        ('\u{30c}', '\u{1d9}')]), ('\u{e2}', &[('\u{300}', '\u{1ea7}'), ('\u{301}', '\u{1ea5}'),
        ('\u{303}', '\u{1eab}'), ('\u{309}', '\u{1ea9}')]), ('\u{e4}', &[('\u{304}', '\u{1df}')]),
        ('\u{e5}', &[('\u{301}', '\u{1fb}')]), ('\u{e6}', &[('\u{301}', '\u{1fd}'), ('\u{304}',
        '\u{1e3}')]), ('\u{e7}', &[('\u{301}', '\u{1e09}')]), ('\u{ea}', &[('\u{300}', '\u{1ec1}'),
        ('\u{301}', '\u{1ebf}'), ('\u{303}', '\u{1ec5}'), ('\u{309}', '\u{1ec3}')]), ('\u{ef}',
        &[('\u{301}', '\u{1e2f}')]), ('\u{f4}', &[('\u{300}', '\u{1ed3}'), ('\u{301}', '\u{1ed1}'),
        ('\u{303}', '\u{1ed7}'), ('\u{309}', '\u{1ed5}')]), ('\u{f5}', &[('\u{301}', '\u{1e4d}'),
        ('\u{304}', '\u{22d}'), ('\u{308}', '\u{1e4f}')]), ('\u{f6}', &[('\u{304}', '\u{22b}')]),
        ('\u{f8}', &[('\u{301}', '\u{1ff}')]), ('\u{fc}', &[('\u{300}', '\u{1dc}'), ('\u{301}',
        '\u{1d8}'), ('\u{304}', '\u{1d6}'), ('\u{30c}', '\u{1da}')]), ('\u{102}', &[('\u{300}',
        '\u{1eb0}'), ('\u{301}', '\u{1eae}'), ('\u{303}', '\u{1eb4}'), ('\u{309}', '\u{1eb2}')]),
        ('\u{103}', &[('\u{300}', '\u{1eb1}'), ('\u{301}', '\u{1eaf}'), ('\u{303}', '\u{1eb5}'),
        ('\u{309}', '\u{1eb3}')]), ('\u{112}', &[('\u{300}', '\u{1e14}'), ('\u{301}', '\u{1e16}')]),
        ('\u{113}', &[('\u{300}', '\u{1e15}'), ('\u{301}', '\u{1e17}')]), ('\u{14c}', &[('\u{300}',
        '\u{1e50}'), ('\u{301}', '\u{1e52}')]), ('\u{14d}', &[('\u{300}', '\u{1e51}'), ('\u{301}',
        '\u{1e53}')]), ('\u{15a}', &[('\u{307}', '\u{1e64}')]), ('\u{15b}', &[('\u{307}',
        '\u{1e65}')]), ('\u{160}', &[('\u{307}', '\u{1e66}')]), ('\u{161}', &[('\u{307}',
        '\u{1e67}')]), ('\u{168}', &[('\u{301}', '\u{1e78}')]), ('\u{169}', &[('\u{301}',
        '\u{1e79}')]), ('\u{16a}', &[('\u{308}', '\u{1e7a}')]), ('\u{16b}', &[('\u{308}',
        '\u{1e7b}')]), ('\u{17f}', &[('\u{307}', '\u{1e9b}')]), ('\u{1a0}', &[('\u{300}',
        '\u{1edc}'), ('\u{301}', '\u{1eda}'), ('\u{303}', '\u{1ee0}'), ('\u{309}', '\u{1ede}'),
        ('\u{323}', '\u{1ee2}')]), ('\u{1a1}', &[('\u{300}', '\u{1edd}'), ('\u{301}', '\u{1edb}'),
        ('\u{303}', '\u{1ee1}'), ('\u{309}', '\u{1edf}'), ('\u{323}', '\u{1ee3}')]), ('\u{1af}',
        &[('\u{300}', '\u{1eea}'), ('\u{301}', '\u{1ee8}'), ('\u{303}', '\u{1eee}'), ('\u{309}',
        '\u{1eec}'), ('\u{323}', '\u{1ef0}')]), ('\u{1b0}', &[('\u{300}', '\u{1eeb}'), ('\u{301}',
        '\u{1ee9}'), ('\u{303}', '\u{1eef}'), ('\u{309}', '\u{1eed}'), ('\u{323}', '\u{1ef1}')]),
        ('\u{1b7}', &[('\u{30c}', '\u{1ee}')]), ('\u{1ea}', &[('\u{304}', '\u{1ec}')]), ('\u{1eb}',
        &[('\u{304}', '\u{1ed}')]), ('\u{226}', &[('\u{304}', '\u{1e0}')]), ('\u{227}',
        &[('\u{304}', '\u{1e1}')]), ('\u{228}', &[('\u{306}', '\u{1e1c}')]), ('\u{229}',
        &[('\u{306}', '\u{1e1d}')]), ('\u{22e}', &[('\u{304}', '\u{230}')]), ('\u{22f}',
        &[('\u{304}', '\u{231}')]), ('\u{292}', &[('\u{30c}', '\u{1ef}')]), ('\u{391}',
        &[('\u{300}', '\u{1fba}'), ('\u{301}', '\u{386}'), ('\u{304}', '\u{1fb9}'), ('\u{306}',
        '\u{1fb8}'), ('\u{313}', '\u{1f08}'), ('\u{314}', '\u{1f09}'), ('\u{345}', '\u{1fbc}')]),
        ('\u{395}', &[('\u{300}', '\u{1fc8}'), ('\u{301}', '\u{388}'), ('\u{313}', '\u{1f18}'),
        ('\u{314}', '\u{1f19}')]), ('\u{397}', &[('\u{300}', '\u{1fca}'), ('\u{301}', '\u{389}'),
        ('\u{313}', '\u{1f28}'), ('\u{314}', '\u{1f29}'), ('\u{345}', '\u{1fcc}')]), ('\u{399}',
        &[('\u{300}', '\u{1fda}'), ('\u{301}', '\u{38a}'), ('\u{304}', '\u{1fd9}'), ('\u{306}',
        '\u{1fd8}'), ('\u{308}', '\u{3aa}'), ('\u{313}', '\u{1f38}'), ('\u{314}', '\u{1f39}')]),
        ('\u{39f}', &[('\u{300}', '\u{1ff8}'), ('\u{301}', '\u{38c}'), ('\u{313}', '\u{1f48}'),
        ('\u{314}', '\u{1f49}')]), ('\u{3a1}', &[('\u{314}', '\u{1fec}')]), ('\u{3a5}',
        &[('\u{300}', '\u{1fea}'), ('\u{301}', '\u{38e}'), ('\u{304}', '\u{1fe9}'), ('\u{306}',
        '\u{1fe8}'), ('\u{308}', '\u{3ab}'), ('\u{314}', '\u{1f59}')]), ('\u{3a9}', &[('\u{300}',
        '\u{1ffa}'), ('\u{301}', '\u{38f}'), ('\u{313}', '\u{1f68}'), ('\u{314}', '\u{1f69}'),
        ('\u{345}', '\u{1ffc}')]), ('\u{3ac}', &[('\u{345}', '\u{1fb4}')]), ('\u{3ae}',
        &[('\u{345}', '\u{1fc4}')]), ('\u{3b1}', &[('\u{300}', '\u{1f70}'), ('\u{301}', '\u{3ac}'),
        ('\u{304}', '\u{1fb1}'), ('\u{306}', '\u{1fb0}'), ('\u{313}', '\u{1f00}'), ('\u{314}',
        '\u{1f01}'), ('\u{342}', '\u{1fb6}'), ('\u{345}', '\u{1fb3}')]), ('\u{3b5}', &[('\u{300}',
        '\u{1f72}'), ('\u{301}', '\u{3ad}'), ('\u{313}', '\u{1f10}'), ('\u{314}', '\u{1f11}')]),
        ('\u{3b7}', &[('\u{300}', '\u{1f74}'), ('\u{301}', '\u{3ae}'), ('\u{313}', '\u{1f20}'),
        ('\u{314}', '\u{1f21}'), ('\u{342}', '\u{1fc6}'), ('\u{345}', '\u{1fc3}')]), ('\u{3b9}',
        &[('\u{300}', '\u{1f76}'), ('\u{301}', '\u{3af}'), ('\u{304}', '\u{1fd1}'), ('\u{306}',
        '\u{1fd0}'), ('\u{308}', '\u{3ca}'), ('\u{313}', '\u{1f30}'), ('\u{314}', '\u{1f31}'),
        ('\u{342}', '\u{1fd6}')]), ('\u{3bf}', &[('\u{300}', '\u{1f78}'), ('\u{301}', '\u{3cc}'),
        ('\u{313}', '\u{1f40}'), ('\u{314}', '\u{1f41}')]), ('\u{3c1}', &[('\u{313}', '\u{1fe4}'),
        ('\u{314}', '\u{1fe5}')]), ('\u{3c5}', &[('\u{300}', '\u{1f7a}'), ('\u{301}', '\u{3cd}'),
        ('\u{304}', '\u{1fe1}'), ('\u{306}', '\u{1fe0}'), ('\u{308}', '\u{3cb}'), ('\u{313}',
        '\u{1f50}'), ('\u{314}', '\u{1f51}'), ('\u{342}', '\u{1fe6}')]), ('\u{3c9}', &[('\u{300}',
        '\u{1f7c}'), ('\u{301}', '\u{3ce}'), ('\u{313}', '\u{1f60}'), ('\u{314}', '\u{1f61}'),
        ('\u{342}', '\u{1ff6}'), ('\u{345}', '\u{1ff3}')]), ('\u{3ca}', &[('\u{300}', '\u{1fd2}'),
        ('\u{301}', '\u{390}'), ('\u{342}', '\u{1fd7}')]), ('\u{3cb}', &[('\u{300}', '\u{1fe2}'),
        ('\u{301}', '\u{3b0}'), ('\u{342}', '\u{1fe7}')]), ('\u{3ce}', &[('\u{345}', '\u{1ff4}')]),
        ('\u{3d2}', &[('\u{301}', '\u{3d3}'), ('\u{308}', '\u{3d4}')]), ('\u{406}', &[('\u{308}',
        '\u{407}')]), ('\u{410}', &[('\u{306}', '\u{4d0}'), ('\u{308}', '\u{4d2}')]), ('\u{413}',
        &[('\u{301}', '\u{403}')]), ('\u{415}', &[('\u{300}', '\u{400}'), ('\u{306}', '\u{4d6}'),
        ('\u{308}', '\u{401}')]), ('\u{416}', &[('\u{306}', '\u{4c1}'), ('\u{308}', '\u{4dc}')]),
        ('\u{417}', &[('\u{308}', '\u{4de}')]), ('\u{418}', &[('\u{300}', '\u{40d}'), ('\u{304}',
        '\u{4e2}'), ('\u{306}', '\u{419}'), ('\u{308}', '\u{4e4}')]), ('\u{41a}', &[('\u{301}',
        '\u{40c}')]), ('\u{41e}', &[('\u{308}', '\u{4e6}')]), ('\u{423}', &[('\u{304}', '\u{4ee}'),
        ('\u{306}', '\u{40e}'), ('\u{308}', '\u{4f0}'), ('\u{30b}', '\u{4f2}')]), ('\u{427}',
        &[('\u{308}', '\u{4f4}')]), ('\u{42b}', &[('\u{308}', '\u{4f8}')]), ('\u{42d}',
        &[('\u{308}', '\u{4ec}')]), ('\u{430}', &[('\u{306}', '\u{4d1}'), ('\u{308}', '\u{4d3}')]),
        ('\u{433}', &[('\u{301}', '\u{453}')]), ('\u{435}', &[('\u{300}', '\u{450}'), ('\u{306}',
        '\u{4d7}'), ('\u{308}', '\u{451}')]), ('\u{436}', &[('\u{306}', '\u{4c2}'), ('\u{308}',
        '\u{4dd}')]), ('\u{437}', &[('\u{308}', '\u{4df}')]), ('\u{438}', &[('\u{300}', '\u{45d}'),
        ('\u{304}', '\u{4e3}'), ('\u{306}', '\u{439}'), ('\u{308}', '\u{4e5}')]), ('\u{43a}',
        &[('\u{301}', '\u{45c}')]), ('\u{43e}', &[('\u{308}', '\u{4e7}')]), ('\u{443}',
        &[('\u{304}', '\u{4ef}'), ('\u{306}', '\u{45e}'), ('\u{308}', '\u{4f1}'), ('\u{30b}',
        '\u{4f3}')]), ('\u{447}', &[('\u{308}', '\u{4f5}')]), ('\u{44b}', &[('\u{308}',
        '\u{4f9}')]), ('\u{44d}', &[('\u{308}', '\u{4ed}')]), ('\u{456}', &[('\u{308}',
        '\u{457}')]), ('\u{474}', &[('\u{30f}', '\u{476}')]), ('\u{475}', &[('\u{30f}',
        '\u{477}')]), ('\u{4d8}', &[('\u{308}', '\u{4da}')]), ('\u{4d9}', &[('\u{308}',
        '\u{4db}')]), ('\u{4e8}', &[('\u{308}', '\u{4ea}')]), ('\u{4e9}', &[('\u{308}',
        '\u{4eb}')]), ('\u{627}', &[('\u{653}', '\u{622}'), ('\u{654}', '\u{623}'), ('\u{655}',
        '\u{625}')]), ('\u{648}', &[('\u{654}', '\u{624}')]), ('\u{64a}', &[('\u{654}',
        '\u{626}')]), ('\u{6c1}', &[('\u{654}', '\u{6c2}')]), ('\u{6d2}', &[('\u{654}',
        '\u{6d3}')]), ('\u{6d5}', &[('\u{654}', '\u{6c0}')]), ('\u{928}', &[('\u{93c}',
        '\u{929}')]), ('\u{930}', &[('\u{93c}', '\u{931}')]), ('\u{933}', &[('\u{93c}',
        '\u{934}')]), ('\u{9c7}', &[('\u{9be}', '\u{9cb}'), ('\u{9d7}', '\u{9cc}')]), ('\u{b47}',
        &[('\u{b3e}', '\u{b4b}'), ('\u{b56}', '\u{b48}'), ('\u{b57}', '\u{b4c}')]), ('\u{b92}',
        &[('\u{bd7}', '\u{b94}')]), ('\u{bc6}', &[('\u{bbe}', '\u{bca}'), ('\u{bd7}', '\u{bcc}')]),
        ('\u{bc7}', &[('\u{bbe}', '\u{bcb}')]), ('\u{c46}', &[('\u{c56}', '\u{c48}')]), ('\u{cbf}',
        &[('\u{cd5}', '\u{cc0}')]), ('\u{cc6}', &[('\u{cc2}', '\u{cca}'), ('\u{cd5}', '\u{cc7}'),
        ('\u{cd6}', '\u{cc8}')]), ('\u{cca}', &[('\u{cd5}', '\u{ccb}')]), ('\u{d46}', &[('\u{d3e}',
        '\u{d4a}'), ('\u{d57}', '\u{d4c}')]), ('\u{d47}', &[('\u{d3e}', '\u{d4b}')]), ('\u{dd9}',
        &[('\u{dca}', '\u{dda}'), ('\u{dcf}', '\u{ddc}'), ('\u{ddf}', '\u{dde}')]), ('\u{ddc}',
        &[('\u{dca}', '\u{ddd}')]), ('\u{1025}', &[('\u{102e}', '\u{1026}')]), ('\u{1b05}',
        &[('\u{1b35}', '\u{1b06}')]), ('\u{1b07}', &[('\u{1b35}', '\u{1b08}')]), ('\u{1b09}',
        &[('\u{1b35}', '\u{1b0a}')]), ('\u{1b0b}', &[('\u{1b35}', '\u{1b0c}')]), ('\u{1b0d}',
        &[('\u{1b35}', '\u{1b0e}')]), ('\u{1b11}', &[('\u{1b35}', '\u{1b12}')]), ('\u{1b3a}',
        &[('\u{1b35}', '\u{1b3b}')]), ('\u{1b3c}', &[('\u{1b35}', '\u{1b3d}')]), ('\u{1b3e}',
        &[('\u{1b35}', '\u{1b40}')]), ('\u{1b3f}', &[('\u{1b35}', '\u{1b41}')]), ('\u{1b42}',
        &[('\u{1b35}', '\u{1b43}')]), ('\u{1e36}', &[('\u{304}', '\u{1e38}')]), ('\u{1e37}',
        &[('\u{304}', '\u{1e39}')]), ('\u{1e5a}', &[('\u{304}', '\u{1e5c}')]), ('\u{1e5b}',
        &[('\u{304}', '\u{1e5d}')]), ('\u{1e62}', &[('\u{307}', '\u{1e68}')]), ('\u{1e63}',
        &[('\u{307}', '\u{1e69}')]), ('\u{1ea0}', &[('\u{302}', '\u{1eac}'), ('\u{306}',
        '\u{1eb6}')]), ('\u{1ea1}', &[('\u{302}', '\u{1ead}'), ('\u{306}', '\u{1eb7}')]),
        ('\u{1eb8}', &[('\u{302}', '\u{1ec6}')]), ('\u{1eb9}', &[('\u{302}', '\u{1ec7}')]),
        ('\u{1ecc}', &[('\u{302}', '\u{1ed8}')]), ('\u{1ecd}', &[('\u{302}', '\u{1ed9}')]),
        ('\u{1f00}', &[('\u{300}', '\u{1f02}'), ('\u{301}', '\u{1f04}'), ('\u{342}', '\u{1f06}'),
        ('\u{345}', '\u{1f80}')]), ('\u{1f01}', &[('\u{300}', '\u{1f03}'), ('\u{301}', '\u{1f05}'),
        ('\u{342}', '\u{1f07}'), ('\u{345}', '\u{1f81}')]), ('\u{1f02}', &[('\u{345}',
        '\u{1f82}')]), ('\u{1f03}', &[('\u{345}', '\u{1f83}')]), ('\u{1f04}', &[('\u{345}',
        '\u{1f84}')]), ('\u{1f05}', &[('\u{345}', '\u{1f85}')]), ('\u{1f06}', &[('\u{345}',
        '\u{1f86}')]), ('\u{1f07}', &[('\u{345}', '\u{1f87}')]), ('\u{1f08}', &[('\u{300}',
        '\u{1f0a}'), ('\u{301}', '\u{1f0c}'), ('\u{342}', '\u{1f0e}'), ('\u{345}', '\u{1f88}')]),
        ('\u{1f09}', &[('\u{300}', '\u{1f0b}'), ('\u{301}', '\u{1f0d}'), ('\u{342}', '\u{1f0f}'),
        ('\u{345}', '\u{1f89}')]), ('\u{1f0a}', &[('\u{345}', '\u{1f8a}')]), ('\u{1f0b}',
        &[('\u{345}', '\u{1f8b}')]), ('\u{1f0c}', &[('\u{345}', '\u{1f8c}')]), ('\u{1f0d}',
        &[('\u{345}', '\u{1f8d}')]), ('\u{1f0e}', &[('\u{345}', '\u{1f8e}')]), ('\u{1f0f}',
        &[('\u{345}', '\u{1f8f}')]), ('\u{1f10}', &[('\u{300}', '\u{1f12}'), ('\u{301}',
        '\u{1f14}')]), ('\u{1f11}', &[('\u{300}', '\u{1f13}'), ('\u{301}', '\u{1f15}')]),
        ('\u{1f18}', &[('\u{300}', '\u{1f1a}'), ('\u{301}', '\u{1f1c}')]), ('\u{1f19}',
        &[('\u{300}', '\u{1f1b}'), ('\u{301}', '\u{1f1d}')]), ('\u{1f20}', &[('\u{300}',
        '\u{1f22}'), ('\u{301}', '\u{1f24}'), ('\u{342}', '\u{1f26}'), ('\u{345}', '\u{1f90}')]),
        ('\u{1f21}', &[('\u{300}', '\u{1f23}'), ('\u{301}', '\u{1f25}'), ('\u{342}', '\u{1f27}'),
        ('\u{345}', '\u{1f91}')]), ('\u{1f22}', &[('\u{345}', '\u{1f92}')]), ('\u{1f23}',
        &[('\u{345}', '\u{1f93}')]), ('\u{1f24}', &[('\u{345}', '\u{1f94}')]), ('\u{1f25}',
        &[('\u{345}', '\u{1f95}')]), ('\u{1f26}', &[('\u{345}', '\u{1f96}')]), ('\u{1f27}',
        &[('\u{345}', '\u{1f97}')]), ('\u{1f28}', &[('\u{300}', '\u{1f2a}'), ('\u{301}',
        '\u{1f2c}'), ('\u{342}', '\u{1f2e}'), ('\u{345}', '\u{1f98}')]), ('\u{1f29}', &[('\u{300}',
        '\u{1f2b}'), ('\u{301}', '\u{1f2d}'), ('\u{342}', '\u{1f2f}'), ('\u{345}', '\u{1f99}')]),
        ('\u{1f2a}', &[('\u{345}', '\u{1f9a}')]), ('\u{1f2b}', &[('\u{345}', '\u{1f9b}')]),
        ('\u{1f2c}', &[('\u{345}', '\u{1f9c}')]), ('\u{1f2d}', &[('\u{345}', '\u{1f9d}')]),
        ('\u{1f2e}', &[('\u{345}', '\u{1f9e}')]), ('\u{1f2f}', &[('\u{345}', '\u{1f9f}')]),
        ('\u{1f30}', &[('\u{300}', '\u{1f32}'), ('\u{301}', '\u{1f34}'), ('\u{342}', '\u{1f36}')]),
        ('\u{1f31}', &[('\u{300}', '\u{1f33}'), ('\u{301}', '\u{1f35}'), ('\u{342}', '\u{1f37}')]),
        ('\u{1f38}', &[('\u{300}', '\u{1f3a}'), ('\u{301}', '\u{1f3c}'), ('\u{342}', '\u{1f3e}')]),
        ('\u{1f39}', &[('\u{300}', '\u{1f3b}'), ('\u{301}', '\u{1f3d}'), ('\u{342}', '\u{1f3f}')]),
        ('\u{1f40}', &[('\u{300}', '\u{1f42}'), ('\u{301}', '\u{1f44}')]), ('\u{1f41}',
        &[('\u{300}', '\u{1f43}'), ('\u{301}', '\u{1f45}')]), ('\u{1f48}', &[('\u{300}',
        '\u{1f4a}'), ('\u{301}', '\u{1f4c}')]), ('\u{1f49}', &[('\u{300}', '\u{1f4b}'), ('\u{301}',
        '\u{1f4d}')]), ('\u{1f50}', &[('\u{300}', '\u{1f52}'), ('\u{301}', '\u{1f54}'), ('\u{342}',
        '\u{1f56}')]), ('\u{1f51}', &[('\u{300}', '\u{1f53}'), ('\u{301}', '\u{1f55}'), ('\u{342}',
        '\u{1f57}')]), ('\u{1f59}', &[('\u{300}', '\u{1f5b}'), ('\u{301}', '\u{1f5d}'), ('\u{342}',
        '\u{1f5f}')]), ('\u{1f60}', &[('\u{300}', '\u{1f62}'), ('\u{301}', '\u{1f64}'), ('\u{342}',
        '\u{1f66}'), ('\u{345}', '\u{1fa0}')]), ('\u{1f61}', &[('\u{300}', '\u{1f63}'), ('\u{301}',
        '\u{1f65}'), ('\u{342}', '\u{1f67}'), ('\u{345}', '\u{1fa1}')]), ('\u{1f62}', &[('\u{345}',
        '\u{1fa2}')]), ('\u{1f63}', &[('\u{345}', '\u{1fa3}')]), ('\u{1f64}', &[('\u{345}',
        '\u{1fa4}')]), ('\u{1f65}', &[('\u{345}', '\u{1fa5}')]), ('\u{1f66}', &[('\u{345}',
        '\u{1fa6}')]), ('\u{1f67}', &[('\u{345}', '\u{1fa7}')]), ('\u{1f68}', &[('\u{300}',
        '\u{1f6a}'), ('\u{301}', '\u{1f6c}'), ('\u{342}', '\u{1f6e}'), ('\u{345}', '\u{1fa8}')]),
        ('\u{1f69}', &[('\u{300}', '\u{1f6b}'), ('\u{301}', '\u{1f6d}'), ('\u{342}', '\u{1f6f}'),
        ('\u{345}', '\u{1fa9}')]), ('\u{1f6a}', &[('\u{345}', '\u{1faa}')]), ('\u{1f6b}',
        &[('\u{345}', '\u{1fab}')]), ('\u{1f6c}', &[('\u{345}', '\u{1fac}')]), ('\u{1f6d}',
        &[('\u{345}', '\u{1fad}')]), ('\u{1f6e}', &[('\u{345}', '\u{1fae}')]), ('\u{1f6f}',
        &[('\u{345}', '\u{1faf}')]), ('\u{1f70}', &[('\u{345}', '\u{1fb2}')]), ('\u{1f74}',
        &[('\u{345}', '\u{1fc2}')]), ('\u{1f7c}', &[('\u{345}', '\u{1ff2}')]), ('\u{1fb6}',
        &[('\u{345}', '\u{1fb7}')]), ('\u{1fbf}', &[('\u{300}', '\u{1fcd}'), ('\u{301}',
        '\u{1fce}'), ('\u{342}', '\u{1fcf}')]), ('\u{1fc6}', &[('\u{345}', '\u{1fc7}')]),
        ('\u{1ff6}', &[('\u{345}', '\u{1ff7}')]), ('\u{1ffe}', &[('\u{300}', '\u{1fdd}'),
        ('\u{301}', '\u{1fde}'), ('\u{342}', '\u{1fdf}')]), ('\u{2190}', &[('\u{338}',
        '\u{219a}')]), ('\u{2192}', &[('\u{338}', '\u{219b}')]), ('\u{2194}', &[('\u{338}',
        '\u{21ae}')]), ('\u{21d0}', &[('\u{338}', '\u{21cd}')]), ('\u{21d2}', &[('\u{338}',
        '\u{21cf}')]), ('\u{21d4}', &[('\u{338}', '\u{21ce}')]), ('\u{2203}', &[('\u{338}',
        '\u{2204}')]), ('\u{2208}', &[('\u{338}', '\u{2209}')]), ('\u{220b}', &[('\u{338}',
        '\u{220c}')]), ('\u{2223}', &[('\u{338}', '\u{2224}')]), ('\u{2225}', &[('\u{338}',
        '\u{2226}')]), ('\u{223c}', &[('\u{338}', '\u{2241}')]), ('\u{2243}', &[('\u{338}',
        '\u{2244}')]), ('\u{2245}', &[('\u{338}', '\u{2247}')]), ('\u{2248}', &[('\u{338}',
        '\u{2249}')]), ('\u{224d}', &[('\u{338}', '\u{226d}')]), ('\u{2261}', &[('\u{338}',
        '\u{2262}')]), ('\u{2264}', &[('\u{338}', '\u{2270}')]), ('\u{2265}', &[('\u{338}',
        '\u{2271}')]), ('\u{2272}', &[('\u{338}', '\u{2274}')]), ('\u{2273}', &[('\u{338}',
        '\u{2275}')]), ('\u{2276}', &[('\u{338}', '\u{2278}')]), ('\u{2277}', &[('\u{338}',
        '\u{2279}')]), ('\u{227a}', &[('\u{338}', '\u{2280}')]), ('\u{227b}', &[('\u{338}',
        '\u{2281}')]), ('\u{227c}', &[('\u{338}', '\u{22e0}')]), ('\u{227d}', &[('\u{338}',
        '\u{22e1}')]), ('\u{2282}', &[('\u{338}', '\u{2284}')]), ('\u{2283}', &[('\u{338}',
        '\u{2285}')]), ('\u{2286}', &[('\u{338}', '\u{2288}')]), ('\u{2287}', &[('\u{338}',
        '\u{2289}')]), ('\u{2291}', &[('\u{338}', '\u{22e2}')]), ('\u{2292}', &[('\u{338}',
        '\u{22e3}')]), ('\u{22a2}', &[('\u{338}', '\u{22ac}')]), ('\u{22a8}', &[('\u{338}',
        '\u{22ad}')]), ('\u{22a9}', &[('\u{338}', '\u{22ae}')]), ('\u{22ab}', &[('\u{338}',
        '\u{22af}')]), ('\u{22b2}', &[('\u{338}', '\u{22ea}')]), ('\u{22b3}', &[('\u{338}',
        '\u{22eb}')]), ('\u{22b4}', &[('\u{338}', '\u{22ec}')]), ('\u{22b5}', &[('\u{338}',
        '\u{22ed}')]), ('\u{3046}', &[('\u{3099}', '\u{3094}')]), ('\u{304b}', &[('\u{3099}',
        '\u{304c}')]), ('\u{304d}', &[('\u{3099}', '\u{304e}')]), ('\u{304f}', &[('\u{3099}',
        '\u{3050}')]), ('\u{3051}', &[('\u{3099}', '\u{3052}')]), ('\u{3053}', &[('\u{3099}',
        '\u{3054}')]), ('\u{3055}', &[('\u{3099}', '\u{3056}')]), ('\u{3057}', &[('\u{3099}',
        '\u{3058}')]), ('\u{3059}', &[('\u{3099}', '\u{305a}')]), ('\u{305b}', &[('\u{3099}',
        '\u{305c}')]), ('\u{305d}', &[('\u{3099}', '\u{305e}')]), ('\u{305f}', &[('\u{3099}',
        '\u{3060}')]), ('\u{3061}', &[('\u{3099}', '\u{3062}')]), ('\u{3064}', &[('\u{3099}',
        '\u{3065}')]), ('\u{3066}', &[('\u{3099}', '\u{3067}')]), ('\u{3068}', &[('\u{3099}',
        '\u{3069}')]), ('\u{306f}', &[('\u{3099}', '\u{3070}'), ('\u{309a}', '\u{3071}')]),
        ('\u{3072}', &[('\u{3099}', '\u{3073}'), ('\u{309a}', '\u{3074}')]), ('\u{3075}',
        &[('\u{3099}', '\u{3076}'), ('\u{309a}', '\u{3077}')]), ('\u{3078}', &[('\u{3099}',
        '\u{3079}'), ('\u{309a}', '\u{307a}')]), ('\u{307b}', &[('\u{3099}', '\u{307c}'),
        ('\u{309a}', '\u{307d}')]), ('\u{309d}', &[('\u{3099}', '\u{309e}')]), ('\u{30a6}',
        &[('\u{3099}', '\u{30f4}')]), ('\u{30ab}', &[('\u{3099}', '\u{30ac}')]), ('\u{30ad}',
        &[('\u{3099}', '\u{30ae}')]), ('\u{30af}', &[('\u{3099}', '\u{30b0}')]), ('\u{30b1}',
        &[('\u{3099}', '\u{30b2}')]), ('\u{30b3}', &[('\u{3099}', '\u{30b4}')]), ('\u{30b5}',
        &[('\u{3099}', '\u{30b6}')]), ('\u{30b7}', &[('\u{3099}', '\u{30b8}')]), ('\u{30b9}',
        &[('\u{3099}', '\u{30ba}')]), ('\u{30bb}', &[('\u{3099}', '\u{30bc}')]), ('\u{30bd}',
        &[('\u{3099}', '\u{30be}')]), ('\u{30bf}', &[('\u{3099}', '\u{30c0}')]), ('\u{30c1}',
        &[('\u{3099}', '\u{30c2}')]), ('\u{30c4}', &[('\u{3099}', '\u{30c5}')]), ('\u{30c6}',
        &[('\u{3099}', '\u{30c7}')]), ('\u{30c8}', &[('\u{3099}', '\u{30c9}')]), ('\u{30cf}',
        &[('\u{3099}', '\u{30d0}'), ('\u{309a}', '\u{30d1}')]), ('\u{30d2}', &[('\u{3099}',
        '\u{30d3}'), ('\u{309a}', '\u{30d4}')]), ('\u{30d5}', &[('\u{3099}', '\u{30d6}'),
        ('\u{309a}', '\u{30d7}')]), ('\u{30d8}', &[('\u{3099}', '\u{30d9}'), ('\u{309a}',
        '\u{30da}')]), ('\u{30db}', &[('\u{3099}', '\u{30dc}'), ('\u{309a}', '\u{30dd}')]),
        ('\u{30ef}', &[('\u{3099}', '\u{30f7}')]), ('\u{30f0}', &[('\u{3099}', '\u{30f8}')]),
        ('\u{30f1}', &[('\u{3099}', '\u{30f9}')]), ('\u{30f2}', &[('\u{3099}', '\u{30fa}')]),
        ('\u{30fd}', &[('\u{3099}', '\u{30fe}')]), ('\u{11099}', &[('\u{110ba}', '\u{1109a}')]),
        ('\u{1109b}', &[('\u{110ba}', '\u{1109c}')]), ('\u{110a5}', &[('\u{110ba}', '\u{110ab}')]),
        ('\u{11131}', &[('\u{11127}', '\u{1112e}')]), ('\u{11132}', &[('\u{11127}', '\u{1112f}')]),
        ('\u{11347}', &[('\u{1133e}', '\u{1134b}'), ('\u{11357}', '\u{1134c}')]), ('\u{114b9}',
        &[('\u{114b0}', '\u{114bc}'), ('\u{114ba}', '\u{114bb}'), ('\u{114bd}', '\u{114be}')]),
        ('\u{115b8}', &[('\u{115af}', '\u{115ba}')]), ('\u{115b9}', &[('\u{115af}', '\u{115bb}')])
    ];


    fn bsearch_range_value_table(c: char, r: &'static [(char, char, u8)]) -> u8 {
        use core::cmp::Ordering::{Equal, Less, Greater};
        use core::slice::SliceExt;
        use core::result::Result::{Ok, Err};
        match r.binary_search_by(|&(lo, hi, _)| {
            if lo <= c && c <= hi { Equal }
            else if hi < c { Less }
            else { Greater }
        }) {
            Ok(idx) => {
                let (_, _, result) = r[idx];
                result
            }
            Err(_) => 0
        }
    }

    static combining_class_table: &'static [(char, char, u8)] = &[
        ('\u{300}', '\u{314}', 230), ('\u{315}', '\u{315}', 232), ('\u{316}', '\u{319}', 220),
        ('\u{31a}', '\u{31a}', 232), ('\u{31b}', '\u{31b}', 216), ('\u{31c}', '\u{320}', 220),
        ('\u{321}', '\u{322}', 202), ('\u{323}', '\u{326}', 220), ('\u{327}', '\u{328}', 202),
        ('\u{329}', '\u{333}', 220), ('\u{334}', '\u{338}', 1), ('\u{339}', '\u{33c}', 220),
        ('\u{33d}', '\u{344}', 230), ('\u{345}', '\u{345}', 240), ('\u{346}', '\u{346}', 230),
        ('\u{347}', '\u{349}', 220), ('\u{34a}', '\u{34c}', 230), ('\u{34d}', '\u{34e}', 220),
        ('\u{350}', '\u{352}', 230), ('\u{353}', '\u{356}', 220), ('\u{357}', '\u{357}', 230),
        ('\u{358}', '\u{358}', 232), ('\u{359}', '\u{35a}', 220), ('\u{35b}', '\u{35b}', 230),
        ('\u{35c}', '\u{35c}', 233), ('\u{35d}', '\u{35e}', 234), ('\u{35f}', '\u{35f}', 233),
        ('\u{360}', '\u{361}', 234), ('\u{362}', '\u{362}', 233), ('\u{363}', '\u{36f}', 230),
        ('\u{483}', '\u{487}', 230), ('\u{591}', '\u{591}', 220), ('\u{592}', '\u{595}', 230),
        ('\u{596}', '\u{596}', 220), ('\u{597}', '\u{599}', 230), ('\u{59a}', '\u{59a}', 222),
        ('\u{59b}', '\u{59b}', 220), ('\u{59c}', '\u{5a1}', 230), ('\u{5a2}', '\u{5a7}', 220),
        ('\u{5a8}', '\u{5a9}', 230), ('\u{5aa}', '\u{5aa}', 220), ('\u{5ab}', '\u{5ac}', 230),
        ('\u{5ad}', '\u{5ad}', 222), ('\u{5ae}', '\u{5ae}', 228), ('\u{5af}', '\u{5af}', 230),
        ('\u{5b0}', '\u{5b0}', 10), ('\u{5b1}', '\u{5b1}', 11), ('\u{5b2}', '\u{5b2}', 12),
        ('\u{5b3}', '\u{5b3}', 13), ('\u{5b4}', '\u{5b4}', 14), ('\u{5b5}', '\u{5b5}', 15),
        ('\u{5b6}', '\u{5b6}', 16), ('\u{5b7}', '\u{5b7}', 17), ('\u{5b8}', '\u{5b8}', 18),
        ('\u{5b9}', '\u{5ba}', 19), ('\u{5bb}', '\u{5bb}', 20), ('\u{5bc}', '\u{5bc}', 21),
        ('\u{5bd}', '\u{5bd}', 22), ('\u{5bf}', '\u{5bf}', 23), ('\u{5c1}', '\u{5c1}', 24),
        ('\u{5c2}', '\u{5c2}', 25), ('\u{5c4}', '\u{5c4}', 230), ('\u{5c5}', '\u{5c5}', 220),
        ('\u{5c7}', '\u{5c7}', 18), ('\u{610}', '\u{617}', 230), ('\u{618}', '\u{618}', 30),
        ('\u{619}', '\u{619}', 31), ('\u{61a}', '\u{61a}', 32), ('\u{64b}', '\u{64b}', 27),
        ('\u{64c}', '\u{64c}', 28), ('\u{64d}', '\u{64d}', 29), ('\u{64e}', '\u{64e}', 30),
        ('\u{64f}', '\u{64f}', 31), ('\u{650}', '\u{650}', 32), ('\u{651}', '\u{651}', 33),
        ('\u{652}', '\u{652}', 34), ('\u{653}', '\u{654}', 230), ('\u{655}', '\u{656}', 220),
        ('\u{657}', '\u{65b}', 230), ('\u{65c}', '\u{65c}', 220), ('\u{65d}', '\u{65e}', 230),
        ('\u{65f}', '\u{65f}', 220), ('\u{670}', '\u{670}', 35), ('\u{6d6}', '\u{6dc}', 230),
        ('\u{6df}', '\u{6e2}', 230), ('\u{6e3}', '\u{6e3}', 220), ('\u{6e4}', '\u{6e4}', 230),
        ('\u{6e7}', '\u{6e8}', 230), ('\u{6ea}', '\u{6ea}', 220), ('\u{6eb}', '\u{6ec}', 230),
        ('\u{6ed}', '\u{6ed}', 220), ('\u{711}', '\u{711}', 36), ('\u{730}', '\u{730}', 230),
        ('\u{731}', '\u{731}', 220), ('\u{732}', '\u{733}', 230), ('\u{734}', '\u{734}', 220),
        ('\u{735}', '\u{736}', 230), ('\u{737}', '\u{739}', 220), ('\u{73a}', '\u{73a}', 230),
        ('\u{73b}', '\u{73c}', 220), ('\u{73d}', '\u{73d}', 230), ('\u{73e}', '\u{73e}', 220),
        ('\u{73f}', '\u{741}', 230), ('\u{742}', '\u{742}', 220), ('\u{743}', '\u{743}', 230),
        ('\u{744}', '\u{744}', 220), ('\u{745}', '\u{745}', 230), ('\u{746}', '\u{746}', 220),
        ('\u{747}', '\u{747}', 230), ('\u{748}', '\u{748}', 220), ('\u{749}', '\u{74a}', 230),
        ('\u{7eb}', '\u{7f1}', 230), ('\u{7f2}', '\u{7f2}', 220), ('\u{7f3}', '\u{7f3}', 230),
        ('\u{816}', '\u{819}', 230), ('\u{81b}', '\u{823}', 230), ('\u{825}', '\u{827}', 230),
        ('\u{829}', '\u{82d}', 230), ('\u{859}', '\u{85b}', 220), ('\u{8e4}', '\u{8e5}', 230),
        ('\u{8e6}', '\u{8e6}', 220), ('\u{8e7}', '\u{8e8}', 230), ('\u{8e9}', '\u{8e9}', 220),
        ('\u{8ea}', '\u{8ec}', 230), ('\u{8ed}', '\u{8ef}', 220), ('\u{8f0}', '\u{8f0}', 27),
        ('\u{8f1}', '\u{8f1}', 28), ('\u{8f2}', '\u{8f2}', 29), ('\u{8f3}', '\u{8f5}', 230),
        ('\u{8f6}', '\u{8f6}', 220), ('\u{8f7}', '\u{8f8}', 230), ('\u{8f9}', '\u{8fa}', 220),
        ('\u{8fb}', '\u{8ff}', 230), ('\u{93c}', '\u{93c}', 7), ('\u{94d}', '\u{94d}', 9),
        ('\u{951}', '\u{951}', 230), ('\u{952}', '\u{952}', 220), ('\u{953}', '\u{954}', 230),
        ('\u{9bc}', '\u{9bc}', 7), ('\u{9cd}', '\u{9cd}', 9), ('\u{a3c}', '\u{a3c}', 7), ('\u{a4d}',
        '\u{a4d}', 9), ('\u{abc}', '\u{abc}', 7), ('\u{acd}', '\u{acd}', 9), ('\u{b3c}', '\u{b3c}',
        7), ('\u{b4d}', '\u{b4d}', 9), ('\u{bcd}', '\u{bcd}', 9), ('\u{c4d}', '\u{c4d}', 9),
        ('\u{c55}', '\u{c55}', 84), ('\u{c56}', '\u{c56}', 91), ('\u{cbc}', '\u{cbc}', 7),
        ('\u{ccd}', '\u{ccd}', 9), ('\u{d4d}', '\u{d4d}', 9), ('\u{dca}', '\u{dca}', 9), ('\u{e38}',
        '\u{e39}', 103), ('\u{e3a}', '\u{e3a}', 9), ('\u{e48}', '\u{e4b}', 107), ('\u{eb8}',
        '\u{eb9}', 118), ('\u{ec8}', '\u{ecb}', 122), ('\u{f18}', '\u{f19}', 220), ('\u{f35}',
        '\u{f35}', 220), ('\u{f37}', '\u{f37}', 220), ('\u{f39}', '\u{f39}', 216), ('\u{f71}',
        '\u{f71}', 129), ('\u{f72}', '\u{f72}', 130), ('\u{f74}', '\u{f74}', 132), ('\u{f7a}',
        '\u{f7d}', 130), ('\u{f80}', '\u{f80}', 130), ('\u{f82}', '\u{f83}', 230), ('\u{f84}',
        '\u{f84}', 9), ('\u{f86}', '\u{f87}', 230), ('\u{fc6}', '\u{fc6}', 220), ('\u{1037}',
        '\u{1037}', 7), ('\u{1039}', '\u{103a}', 9), ('\u{108d}', '\u{108d}', 220), ('\u{135d}',
        '\u{135f}', 230), ('\u{1714}', '\u{1714}', 9), ('\u{1734}', '\u{1734}', 9), ('\u{17d2}',
        '\u{17d2}', 9), ('\u{17dd}', '\u{17dd}', 230), ('\u{18a9}', '\u{18a9}', 228), ('\u{1939}',
        '\u{1939}', 222), ('\u{193a}', '\u{193a}', 230), ('\u{193b}', '\u{193b}', 220), ('\u{1a17}',
        '\u{1a17}', 230), ('\u{1a18}', '\u{1a18}', 220), ('\u{1a60}', '\u{1a60}', 9), ('\u{1a75}',
        '\u{1a7c}', 230), ('\u{1a7f}', '\u{1a7f}', 220), ('\u{1ab0}', '\u{1ab4}', 230), ('\u{1ab5}',
        '\u{1aba}', 220), ('\u{1abb}', '\u{1abc}', 230), ('\u{1abd}', '\u{1abd}', 220), ('\u{1b34}',
        '\u{1b34}', 7), ('\u{1b44}', '\u{1b44}', 9), ('\u{1b6b}', '\u{1b6b}', 230), ('\u{1b6c}',
        '\u{1b6c}', 220), ('\u{1b6d}', '\u{1b73}', 230), ('\u{1baa}', '\u{1bab}', 9), ('\u{1be6}',
        '\u{1be6}', 7), ('\u{1bf2}', '\u{1bf3}', 9), ('\u{1c37}', '\u{1c37}', 7), ('\u{1cd0}',
        '\u{1cd2}', 230), ('\u{1cd4}', '\u{1cd4}', 1), ('\u{1cd5}', '\u{1cd9}', 220), ('\u{1cda}',
        '\u{1cdb}', 230), ('\u{1cdc}', '\u{1cdf}', 220), ('\u{1ce0}', '\u{1ce0}', 230), ('\u{1ce2}',
        '\u{1ce8}', 1), ('\u{1ced}', '\u{1ced}', 220), ('\u{1cf4}', '\u{1cf4}', 230), ('\u{1cf8}',
        '\u{1cf9}', 230), ('\u{1dc0}', '\u{1dc1}', 230), ('\u{1dc2}', '\u{1dc2}', 220), ('\u{1dc3}',
        '\u{1dc9}', 230), ('\u{1dca}', '\u{1dca}', 220), ('\u{1dcb}', '\u{1dcc}', 230), ('\u{1dcd}',
        '\u{1dcd}', 234), ('\u{1dce}', '\u{1dce}', 214), ('\u{1dcf}', '\u{1dcf}', 220), ('\u{1dd0}',
        '\u{1dd0}', 202), ('\u{1dd1}', '\u{1df5}', 230), ('\u{1dfc}', '\u{1dfc}', 233), ('\u{1dfd}',
        '\u{1dfd}', 220), ('\u{1dfe}', '\u{1dfe}', 230), ('\u{1dff}', '\u{1dff}', 220), ('\u{20d0}',
        '\u{20d1}', 230), ('\u{20d2}', '\u{20d3}', 1), ('\u{20d4}', '\u{20d7}', 230), ('\u{20d8}',
        '\u{20da}', 1), ('\u{20db}', '\u{20dc}', 230), ('\u{20e1}', '\u{20e1}', 230), ('\u{20e5}',
        '\u{20e6}', 1), ('\u{20e7}', '\u{20e7}', 230), ('\u{20e8}', '\u{20e8}', 220), ('\u{20e9}',
        '\u{20e9}', 230), ('\u{20ea}', '\u{20eb}', 1), ('\u{20ec}', '\u{20ef}', 220), ('\u{20f0}',
        '\u{20f0}', 230), ('\u{2cef}', '\u{2cf1}', 230), ('\u{2d7f}', '\u{2d7f}', 9), ('\u{2de0}',
        '\u{2dff}', 230), ('\u{302a}', '\u{302a}', 218), ('\u{302b}', '\u{302b}', 228), ('\u{302c}',
        '\u{302c}', 232), ('\u{302d}', '\u{302d}', 222), ('\u{302e}', '\u{302f}', 224), ('\u{3099}',
        '\u{309a}', 8), ('\u{a66f}', '\u{a66f}', 230), ('\u{a674}', '\u{a67d}', 230), ('\u{a69f}',
        '\u{a69f}', 230), ('\u{a6f0}', '\u{a6f1}', 230), ('\u{a806}', '\u{a806}', 9), ('\u{a8c4}',
        '\u{a8c4}', 9), ('\u{a8e0}', '\u{a8f1}', 230), ('\u{a92b}', '\u{a92d}', 220), ('\u{a953}',
        '\u{a953}', 9), ('\u{a9b3}', '\u{a9b3}', 7), ('\u{a9c0}', '\u{a9c0}', 9), ('\u{aab0}',
        '\u{aab0}', 230), ('\u{aab2}', '\u{aab3}', 230), ('\u{aab4}', '\u{aab4}', 220), ('\u{aab7}',
        '\u{aab8}', 230), ('\u{aabe}', '\u{aabf}', 230), ('\u{aac1}', '\u{aac1}', 230), ('\u{aaf6}',
        '\u{aaf6}', 9), ('\u{abed}', '\u{abed}', 9), ('\u{fb1e}', '\u{fb1e}', 26), ('\u{fe20}',
        '\u{fe26}', 230), ('\u{fe27}', '\u{fe2d}', 220), ('\u{101fd}', '\u{101fd}', 220),
        ('\u{102e0}', '\u{102e0}', 220), ('\u{10376}', '\u{1037a}', 230), ('\u{10a0d}', '\u{10a0d}',
        220), ('\u{10a0f}', '\u{10a0f}', 230), ('\u{10a38}', '\u{10a38}', 230), ('\u{10a39}',
        '\u{10a39}', 1), ('\u{10a3a}', '\u{10a3a}', 220), ('\u{10a3f}', '\u{10a3f}', 9),
        ('\u{10ae5}', '\u{10ae5}', 230), ('\u{10ae6}', '\u{10ae6}', 220), ('\u{11046}', '\u{11046}',
        9), ('\u{1107f}', '\u{1107f}', 9), ('\u{110b9}', '\u{110b9}', 9), ('\u{110ba}', '\u{110ba}',
        7), ('\u{11100}', '\u{11102}', 230), ('\u{11133}', '\u{11134}', 9), ('\u{11173}',
        '\u{11173}', 7), ('\u{111c0}', '\u{111c0}', 9), ('\u{11235}', '\u{11235}', 9), ('\u{11236}',
        '\u{11236}', 7), ('\u{112e9}', '\u{112e9}', 7), ('\u{112ea}', '\u{112ea}', 9), ('\u{1133c}',
        '\u{1133c}', 7), ('\u{1134d}', '\u{1134d}', 9), ('\u{11366}', '\u{1136c}', 230),
        ('\u{11370}', '\u{11374}', 230), ('\u{114c2}', '\u{114c2}', 9), ('\u{114c3}', '\u{114c3}',
        7), ('\u{115bf}', '\u{115bf}', 9), ('\u{115c0}', '\u{115c0}', 7), ('\u{1163f}', '\u{1163f}',
        9), ('\u{116b6}', '\u{116b6}', 9), ('\u{116b7}', '\u{116b7}', 7), ('\u{16af0}', '\u{16af4}',
        1), ('\u{16b30}', '\u{16b36}', 230), ('\u{1bc9e}', '\u{1bc9e}', 1), ('\u{1d165}',
        '\u{1d166}', 216), ('\u{1d167}', '\u{1d169}', 1), ('\u{1d16d}', '\u{1d16d}', 226),
        ('\u{1d16e}', '\u{1d172}', 216), ('\u{1d17b}', '\u{1d182}', 220), ('\u{1d185}', '\u{1d189}',
        230), ('\u{1d18a}', '\u{1d18b}', 220), ('\u{1d1aa}', '\u{1d1ad}', 230), ('\u{1d242}',
        '\u{1d244}', 230), ('\u{1e8d0}', '\u{1e8d6}', 220)
    ];

    pub fn canonical_combining_class(c: char) -> u8 {
        bsearch_range_value_table(c, combining_class_table)
    }

}

pub mod conversions {
    use core::cmp::Ordering::{Equal, Less, Greater};
    use core::slice::SliceExt;
    use core::option::Option;
    use core::option::Option::{Some, None};
    use core::result::Result::{Ok, Err};

    pub fn to_lower(c: char) -> char {
        match bsearch_case_table(c, LuLl_table) {
          None        => c,
          Some(index) => LuLl_table[index].1
        }
    }

    pub fn to_upper(c: char) -> char {
        match bsearch_case_table(c, LlLu_table) {
            None        => c,
            Some(index) => LlLu_table[index].1
        }
    }

    fn bsearch_case_table(c: char, table: &'static [(char, char)]) -> Option<uint> {
        match table.binary_search_by(|&(key, _)| {
            if c == key { Equal }
            else if key < c { Less }
            else { Greater }
        }) {
            Ok(i) => Some(i),
            Err(_) => None,
        }
    }

    static LuLl_table: &'static [(char, char)] = &[
        ('\u{41}', '\u{61}'), ('\u{42}', '\u{62}'), ('\u{43}', '\u{63}'), ('\u{44}', '\u{64}'),
        ('\u{45}', '\u{65}'), ('\u{46}', '\u{66}'), ('\u{47}', '\u{67}'), ('\u{48}', '\u{68}'),
        ('\u{49}', '\u{69}'), ('\u{4a}', '\u{6a}'), ('\u{4b}', '\u{6b}'), ('\u{4c}', '\u{6c}'),
        ('\u{4d}', '\u{6d}'), ('\u{4e}', '\u{6e}'), ('\u{4f}', '\u{6f}'), ('\u{50}', '\u{70}'),
        ('\u{51}', '\u{71}'), ('\u{52}', '\u{72}'), ('\u{53}', '\u{73}'), ('\u{54}', '\u{74}'),
        ('\u{55}', '\u{75}'), ('\u{56}', '\u{76}'), ('\u{57}', '\u{77}'), ('\u{58}', '\u{78}'),
        ('\u{59}', '\u{79}'), ('\u{5a}', '\u{7a}'), ('\u{c0}', '\u{e0}'), ('\u{c1}', '\u{e1}'),
        ('\u{c2}', '\u{e2}'), ('\u{c3}', '\u{e3}'), ('\u{c4}', '\u{e4}'), ('\u{c5}', '\u{e5}'),
        ('\u{c6}', '\u{e6}'), ('\u{c7}', '\u{e7}'), ('\u{c8}', '\u{e8}'), ('\u{c9}', '\u{e9}'),
        ('\u{ca}', '\u{ea}'), ('\u{cb}', '\u{eb}'), ('\u{cc}', '\u{ec}'), ('\u{cd}', '\u{ed}'),
        ('\u{ce}', '\u{ee}'), ('\u{cf}', '\u{ef}'), ('\u{d0}', '\u{f0}'), ('\u{d1}', '\u{f1}'),
        ('\u{d2}', '\u{f2}'), ('\u{d3}', '\u{f3}'), ('\u{d4}', '\u{f4}'), ('\u{d5}', '\u{f5}'),
        ('\u{d6}', '\u{f6}'), ('\u{d8}', '\u{f8}'), ('\u{d9}', '\u{f9}'), ('\u{da}', '\u{fa}'),
        ('\u{db}', '\u{fb}'), ('\u{dc}', '\u{fc}'), ('\u{dd}', '\u{fd}'), ('\u{de}', '\u{fe}'),
        ('\u{100}', '\u{101}'), ('\u{102}', '\u{103}'), ('\u{104}', '\u{105}'), ('\u{106}',
        '\u{107}'), ('\u{108}', '\u{109}'), ('\u{10a}', '\u{10b}'), ('\u{10c}', '\u{10d}'),
        ('\u{10e}', '\u{10f}'), ('\u{110}', '\u{111}'), ('\u{112}', '\u{113}'), ('\u{114}',
        '\u{115}'), ('\u{116}', '\u{117}'), ('\u{118}', '\u{119}'), ('\u{11a}', '\u{11b}'),
        ('\u{11c}', '\u{11d}'), ('\u{11e}', '\u{11f}'), ('\u{120}', '\u{121}'), ('\u{122}',
        '\u{123}'), ('\u{124}', '\u{125}'), ('\u{126}', '\u{127}'), ('\u{128}', '\u{129}'),
        ('\u{12a}', '\u{12b}'), ('\u{12c}', '\u{12d}'), ('\u{12e}', '\u{12f}'), ('\u{130}',
        '\u{69}'), ('\u{132}', '\u{133}'), ('\u{134}', '\u{135}'), ('\u{136}', '\u{137}'),
        ('\u{139}', '\u{13a}'), ('\u{13b}', '\u{13c}'), ('\u{13d}', '\u{13e}'), ('\u{13f}',
        '\u{140}'), ('\u{141}', '\u{142}'), ('\u{143}', '\u{144}'), ('\u{145}', '\u{146}'),
        ('\u{147}', '\u{148}'), ('\u{14a}', '\u{14b}'), ('\u{14c}', '\u{14d}'), ('\u{14e}',
        '\u{14f}'), ('\u{150}', '\u{151}'), ('\u{152}', '\u{153}'), ('\u{154}', '\u{155}'),
        ('\u{156}', '\u{157}'), ('\u{158}', '\u{159}'), ('\u{15a}', '\u{15b}'), ('\u{15c}',
        '\u{15d}'), ('\u{15e}', '\u{15f}'), ('\u{160}', '\u{161}'), ('\u{162}', '\u{163}'),
        ('\u{164}', '\u{165}'), ('\u{166}', '\u{167}'), ('\u{168}', '\u{169}'), ('\u{16a}',
        '\u{16b}'), ('\u{16c}', '\u{16d}'), ('\u{16e}', '\u{16f}'), ('\u{170}', '\u{171}'),
        ('\u{172}', '\u{173}'), ('\u{174}', '\u{175}'), ('\u{176}', '\u{177}'), ('\u{178}',
        '\u{ff}'), ('\u{179}', '\u{17a}'), ('\u{17b}', '\u{17c}'), ('\u{17d}', '\u{17e}'),
        ('\u{181}', '\u{253}'), ('\u{182}', '\u{183}'), ('\u{184}', '\u{185}'), ('\u{186}',
        '\u{254}'), ('\u{187}', '\u{188}'), ('\u{189}', '\u{256}'), ('\u{18a}', '\u{257}'),
        ('\u{18b}', '\u{18c}'), ('\u{18e}', '\u{1dd}'), ('\u{18f}', '\u{259}'), ('\u{190}',
        '\u{25b}'), ('\u{191}', '\u{192}'), ('\u{193}', '\u{260}'), ('\u{194}', '\u{263}'),
        ('\u{196}', '\u{269}'), ('\u{197}', '\u{268}'), ('\u{198}', '\u{199}'), ('\u{19c}',
        '\u{26f}'), ('\u{19d}', '\u{272}'), ('\u{19f}', '\u{275}'), ('\u{1a0}', '\u{1a1}'),
        ('\u{1a2}', '\u{1a3}'), ('\u{1a4}', '\u{1a5}'), ('\u{1a6}', '\u{280}'), ('\u{1a7}',
        '\u{1a8}'), ('\u{1a9}', '\u{283}'), ('\u{1ac}', '\u{1ad}'), ('\u{1ae}', '\u{288}'),
        ('\u{1af}', '\u{1b0}'), ('\u{1b1}', '\u{28a}'), ('\u{1b2}', '\u{28b}'), ('\u{1b3}',
        '\u{1b4}'), ('\u{1b5}', '\u{1b6}'), ('\u{1b7}', '\u{292}'), ('\u{1b8}', '\u{1b9}'),
        ('\u{1bc}', '\u{1bd}'), ('\u{1c4}', '\u{1c6}'), ('\u{1c7}', '\u{1c9}'), ('\u{1ca}',
        '\u{1cc}'), ('\u{1cd}', '\u{1ce}'), ('\u{1cf}', '\u{1d0}'), ('\u{1d1}', '\u{1d2}'),
        ('\u{1d3}', '\u{1d4}'), ('\u{1d5}', '\u{1d6}'), ('\u{1d7}', '\u{1d8}'), ('\u{1d9}',
        '\u{1da}'), ('\u{1db}', '\u{1dc}'), ('\u{1de}', '\u{1df}'), ('\u{1e0}', '\u{1e1}'),
        ('\u{1e2}', '\u{1e3}'), ('\u{1e4}', '\u{1e5}'), ('\u{1e6}', '\u{1e7}'), ('\u{1e8}',
        '\u{1e9}'), ('\u{1ea}', '\u{1eb}'), ('\u{1ec}', '\u{1ed}'), ('\u{1ee}', '\u{1ef}'),
        ('\u{1f1}', '\u{1f3}'), ('\u{1f4}', '\u{1f5}'), ('\u{1f6}', '\u{195}'), ('\u{1f7}',
        '\u{1bf}'), ('\u{1f8}', '\u{1f9}'), ('\u{1fa}', '\u{1fb}'), ('\u{1fc}', '\u{1fd}'),
        ('\u{1fe}', '\u{1ff}'), ('\u{200}', '\u{201}'), ('\u{202}', '\u{203}'), ('\u{204}',
        '\u{205}'), ('\u{206}', '\u{207}'), ('\u{208}', '\u{209}'), ('\u{20a}', '\u{20b}'),
        ('\u{20c}', '\u{20d}'), ('\u{20e}', '\u{20f}'), ('\u{210}', '\u{211}'), ('\u{212}',
        '\u{213}'), ('\u{214}', '\u{215}'), ('\u{216}', '\u{217}'), ('\u{218}', '\u{219}'),
        ('\u{21a}', '\u{21b}'), ('\u{21c}', '\u{21d}'), ('\u{21e}', '\u{21f}'), ('\u{220}',
        '\u{19e}'), ('\u{222}', '\u{223}'), ('\u{224}', '\u{225}'), ('\u{226}', '\u{227}'),
        ('\u{228}', '\u{229}'), ('\u{22a}', '\u{22b}'), ('\u{22c}', '\u{22d}'), ('\u{22e}',
        '\u{22f}'), ('\u{230}', '\u{231}'), ('\u{232}', '\u{233}'), ('\u{23a}', '\u{2c65}'),
        ('\u{23b}', '\u{23c}'), ('\u{23d}', '\u{19a}'), ('\u{23e}', '\u{2c66}'), ('\u{241}',
        '\u{242}'), ('\u{243}', '\u{180}'), ('\u{244}', '\u{289}'), ('\u{245}', '\u{28c}'),
        ('\u{246}', '\u{247}'), ('\u{248}', '\u{249}'), ('\u{24a}', '\u{24b}'), ('\u{24c}',
        '\u{24d}'), ('\u{24e}', '\u{24f}'), ('\u{370}', '\u{371}'), ('\u{372}', '\u{373}'),
        ('\u{376}', '\u{377}'), ('\u{37f}', '\u{3f3}'), ('\u{386}', '\u{3ac}'), ('\u{388}',
        '\u{3ad}'), ('\u{389}', '\u{3ae}'), ('\u{38a}', '\u{3af}'), ('\u{38c}', '\u{3cc}'),
        ('\u{38e}', '\u{3cd}'), ('\u{38f}', '\u{3ce}'), ('\u{391}', '\u{3b1}'), ('\u{392}',
        '\u{3b2}'), ('\u{393}', '\u{3b3}'), ('\u{394}', '\u{3b4}'), ('\u{395}', '\u{3b5}'),
        ('\u{396}', '\u{3b6}'), ('\u{397}', '\u{3b7}'), ('\u{398}', '\u{3b8}'), ('\u{399}',
        '\u{3b9}'), ('\u{39a}', '\u{3ba}'), ('\u{39b}', '\u{3bb}'), ('\u{39c}', '\u{3bc}'),
        ('\u{39d}', '\u{3bd}'), ('\u{39e}', '\u{3be}'), ('\u{39f}', '\u{3bf}'), ('\u{3a0}',
        '\u{3c0}'), ('\u{3a1}', '\u{3c1}'), ('\u{3a3}', '\u{3c3}'), ('\u{3a4}', '\u{3c4}'),
        ('\u{3a5}', '\u{3c5}'), ('\u{3a6}', '\u{3c6}'), ('\u{3a7}', '\u{3c7}'), ('\u{3a8}',
        '\u{3c8}'), ('\u{3a9}', '\u{3c9}'), ('\u{3aa}', '\u{3ca}'), ('\u{3ab}', '\u{3cb}'),
        ('\u{3cf}', '\u{3d7}'), ('\u{3d8}', '\u{3d9}'), ('\u{3da}', '\u{3db}'), ('\u{3dc}',
        '\u{3dd}'), ('\u{3de}', '\u{3df}'), ('\u{3e0}', '\u{3e1}'), ('\u{3e2}', '\u{3e3}'),
        ('\u{3e4}', '\u{3e5}'), ('\u{3e6}', '\u{3e7}'), ('\u{3e8}', '\u{3e9}'), ('\u{3ea}',
        '\u{3eb}'), ('\u{3ec}', '\u{3ed}'), ('\u{3ee}', '\u{3ef}'), ('\u{3f4}', '\u{3b8}'),
        ('\u{3f7}', '\u{3f8}'), ('\u{3f9}', '\u{3f2}'), ('\u{3fa}', '\u{3fb}'), ('\u{3fd}',
        '\u{37b}'), ('\u{3fe}', '\u{37c}'), ('\u{3ff}', '\u{37d}'), ('\u{400}', '\u{450}'),
        ('\u{401}', '\u{451}'), ('\u{402}', '\u{452}'), ('\u{403}', '\u{453}'), ('\u{404}',
        '\u{454}'), ('\u{405}', '\u{455}'), ('\u{406}', '\u{456}'), ('\u{407}', '\u{457}'),
        ('\u{408}', '\u{458}'), ('\u{409}', '\u{459}'), ('\u{40a}', '\u{45a}'), ('\u{40b}',
        '\u{45b}'), ('\u{40c}', '\u{45c}'), ('\u{40d}', '\u{45d}'), ('\u{40e}', '\u{45e}'),
        ('\u{40f}', '\u{45f}'), ('\u{410}', '\u{430}'), ('\u{411}', '\u{431}'), ('\u{412}',
        '\u{432}'), ('\u{413}', '\u{433}'), ('\u{414}', '\u{434}'), ('\u{415}', '\u{435}'),
        ('\u{416}', '\u{436}'), ('\u{417}', '\u{437}'), ('\u{418}', '\u{438}'), ('\u{419}',
        '\u{439}'), ('\u{41a}', '\u{43a}'), ('\u{41b}', '\u{43b}'), ('\u{41c}', '\u{43c}'),
        ('\u{41d}', '\u{43d}'), ('\u{41e}', '\u{43e}'), ('\u{41f}', '\u{43f}'), ('\u{420}',
        '\u{440}'), ('\u{421}', '\u{441}'), ('\u{422}', '\u{442}'), ('\u{423}', '\u{443}'),
        ('\u{424}', '\u{444}'), ('\u{425}', '\u{445}'), ('\u{426}', '\u{446}'), ('\u{427}',
        '\u{447}'), ('\u{428}', '\u{448}'), ('\u{429}', '\u{449}'), ('\u{42a}', '\u{44a}'),
        ('\u{42b}', '\u{44b}'), ('\u{42c}', '\u{44c}'), ('\u{42d}', '\u{44d}'), ('\u{42e}',
        '\u{44e}'), ('\u{42f}', '\u{44f}'), ('\u{460}', '\u{461}'), ('\u{462}', '\u{463}'),
        ('\u{464}', '\u{465}'), ('\u{466}', '\u{467}'), ('\u{468}', '\u{469}'), ('\u{46a}',
        '\u{46b}'), ('\u{46c}', '\u{46d}'), ('\u{46e}', '\u{46f}'), ('\u{470}', '\u{471}'),
        ('\u{472}', '\u{473}'), ('\u{474}', '\u{475}'), ('\u{476}', '\u{477}'), ('\u{478}',
        '\u{479}'), ('\u{47a}', '\u{47b}'), ('\u{47c}', '\u{47d}'), ('\u{47e}', '\u{47f}'),
        ('\u{480}', '\u{481}'), ('\u{48a}', '\u{48b}'), ('\u{48c}', '\u{48d}'), ('\u{48e}',
        '\u{48f}'), ('\u{490}', '\u{491}'), ('\u{492}', '\u{493}'), ('\u{494}', '\u{495}'),
        ('\u{496}', '\u{497}'), ('\u{498}', '\u{499}'), ('\u{49a}', '\u{49b}'), ('\u{49c}',
        '\u{49d}'), ('\u{49e}', '\u{49f}'), ('\u{4a0}', '\u{4a1}'), ('\u{4a2}', '\u{4a3}'),
        ('\u{4a4}', '\u{4a5}'), ('\u{4a6}', '\u{4a7}'), ('\u{4a8}', '\u{4a9}'), ('\u{4aa}',
        '\u{4ab}'), ('\u{4ac}', '\u{4ad}'), ('\u{4ae}', '\u{4af}'), ('\u{4b0}', '\u{4b1}'),
        ('\u{4b2}', '\u{4b3}'), ('\u{4b4}', '\u{4b5}'), ('\u{4b6}', '\u{4b7}'), ('\u{4b8}',
        '\u{4b9}'), ('\u{4ba}', '\u{4bb}'), ('\u{4bc}', '\u{4bd}'), ('\u{4be}', '\u{4bf}'),
        ('\u{4c0}', '\u{4cf}'), ('\u{4c1}', '\u{4c2}'), ('\u{4c3}', '\u{4c4}'), ('\u{4c5}',
        '\u{4c6}'), ('\u{4c7}', '\u{4c8}'), ('\u{4c9}', '\u{4ca}'), ('\u{4cb}', '\u{4cc}'),
        ('\u{4cd}', '\u{4ce}'), ('\u{4d0}', '\u{4d1}'), ('\u{4d2}', '\u{4d3}'), ('\u{4d4}',
        '\u{4d5}'), ('\u{4d6}', '\u{4d7}'), ('\u{4d8}', '\u{4d9}'), ('\u{4da}', '\u{4db}'),
        ('\u{4dc}', '\u{4dd}'), ('\u{4de}', '\u{4df}'), ('\u{4e0}', '\u{4e1}'), ('\u{4e2}',
        '\u{4e3}'), ('\u{4e4}', '\u{4e5}'), ('\u{4e6}', '\u{4e7}'), ('\u{4e8}', '\u{4e9}'),
        ('\u{4ea}', '\u{4eb}'), ('\u{4ec}', '\u{4ed}'), ('\u{4ee}', '\u{4ef}'), ('\u{4f0}',
        '\u{4f1}'), ('\u{4f2}', '\u{4f3}'), ('\u{4f4}', '\u{4f5}'), ('\u{4f6}', '\u{4f7}'),
        ('\u{4f8}', '\u{4f9}'), ('\u{4fa}', '\u{4fb}'), ('\u{4fc}', '\u{4fd}'), ('\u{4fe}',
        '\u{4ff}'), ('\u{500}', '\u{501}'), ('\u{502}', '\u{503}'), ('\u{504}', '\u{505}'),
        ('\u{506}', '\u{507}'), ('\u{508}', '\u{509}'), ('\u{50a}', '\u{50b}'), ('\u{50c}',
        '\u{50d}'), ('\u{50e}', '\u{50f}'), ('\u{510}', '\u{511}'), ('\u{512}', '\u{513}'),
        ('\u{514}', '\u{515}'), ('\u{516}', '\u{517}'), ('\u{518}', '\u{519}'), ('\u{51a}',
        '\u{51b}'), ('\u{51c}', '\u{51d}'), ('\u{51e}', '\u{51f}'), ('\u{520}', '\u{521}'),
        ('\u{522}', '\u{523}'), ('\u{524}', '\u{525}'), ('\u{526}', '\u{527}'), ('\u{528}',
        '\u{529}'), ('\u{52a}', '\u{52b}'), ('\u{52c}', '\u{52d}'), ('\u{52e}', '\u{52f}'),
        ('\u{531}', '\u{561}'), ('\u{532}', '\u{562}'), ('\u{533}', '\u{563}'), ('\u{534}',
        '\u{564}'), ('\u{535}', '\u{565}'), ('\u{536}', '\u{566}'), ('\u{537}', '\u{567}'),
        ('\u{538}', '\u{568}'), ('\u{539}', '\u{569}'), ('\u{53a}', '\u{56a}'), ('\u{53b}',
        '\u{56b}'), ('\u{53c}', '\u{56c}'), ('\u{53d}', '\u{56d}'), ('\u{53e}', '\u{56e}'),
        ('\u{53f}', '\u{56f}'), ('\u{540}', '\u{570}'), ('\u{541}', '\u{571}'), ('\u{542}',
        '\u{572}'), ('\u{543}', '\u{573}'), ('\u{544}', '\u{574}'), ('\u{545}', '\u{575}'),
        ('\u{546}', '\u{576}'), ('\u{547}', '\u{577}'), ('\u{548}', '\u{578}'), ('\u{549}',
        '\u{579}'), ('\u{54a}', '\u{57a}'), ('\u{54b}', '\u{57b}'), ('\u{54c}', '\u{57c}'),
        ('\u{54d}', '\u{57d}'), ('\u{54e}', '\u{57e}'), ('\u{54f}', '\u{57f}'), ('\u{550}',
        '\u{580}'), ('\u{551}', '\u{581}'), ('\u{552}', '\u{582}'), ('\u{553}', '\u{583}'),
        ('\u{554}', '\u{584}'), ('\u{555}', '\u{585}'), ('\u{556}', '\u{586}'), ('\u{10a0}',
        '\u{2d00}'), ('\u{10a1}', '\u{2d01}'), ('\u{10a2}', '\u{2d02}'), ('\u{10a3}', '\u{2d03}'),
        ('\u{10a4}', '\u{2d04}'), ('\u{10a5}', '\u{2d05}'), ('\u{10a6}', '\u{2d06}'), ('\u{10a7}',
        '\u{2d07}'), ('\u{10a8}', '\u{2d08}'), ('\u{10a9}', '\u{2d09}'), ('\u{10aa}', '\u{2d0a}'),
        ('\u{10ab}', '\u{2d0b}'), ('\u{10ac}', '\u{2d0c}'), ('\u{10ad}', '\u{2d0d}'), ('\u{10ae}',
        '\u{2d0e}'), ('\u{10af}', '\u{2d0f}'), ('\u{10b0}', '\u{2d10}'), ('\u{10b1}', '\u{2d11}'),
        ('\u{10b2}', '\u{2d12}'), ('\u{10b3}', '\u{2d13}'), ('\u{10b4}', '\u{2d14}'), ('\u{10b5}',
        '\u{2d15}'), ('\u{10b6}', '\u{2d16}'), ('\u{10b7}', '\u{2d17}'), ('\u{10b8}', '\u{2d18}'),
        ('\u{10b9}', '\u{2d19}'), ('\u{10ba}', '\u{2d1a}'), ('\u{10bb}', '\u{2d1b}'), ('\u{10bc}',
        '\u{2d1c}'), ('\u{10bd}', '\u{2d1d}'), ('\u{10be}', '\u{2d1e}'), ('\u{10bf}', '\u{2d1f}'),
        ('\u{10c0}', '\u{2d20}'), ('\u{10c1}', '\u{2d21}'), ('\u{10c2}', '\u{2d22}'), ('\u{10c3}',
        '\u{2d23}'), ('\u{10c4}', '\u{2d24}'), ('\u{10c5}', '\u{2d25}'), ('\u{10c7}', '\u{2d27}'),
        ('\u{10cd}', '\u{2d2d}'), ('\u{1e00}', '\u{1e01}'), ('\u{1e02}', '\u{1e03}'), ('\u{1e04}',
        '\u{1e05}'), ('\u{1e06}', '\u{1e07}'), ('\u{1e08}', '\u{1e09}'), ('\u{1e0a}', '\u{1e0b}'),
        ('\u{1e0c}', '\u{1e0d}'), ('\u{1e0e}', '\u{1e0f}'), ('\u{1e10}', '\u{1e11}'), ('\u{1e12}',
        '\u{1e13}'), ('\u{1e14}', '\u{1e15}'), ('\u{1e16}', '\u{1e17}'), ('\u{1e18}', '\u{1e19}'),
        ('\u{1e1a}', '\u{1e1b}'), ('\u{1e1c}', '\u{1e1d}'), ('\u{1e1e}', '\u{1e1f}'), ('\u{1e20}',
        '\u{1e21}'), ('\u{1e22}', '\u{1e23}'), ('\u{1e24}', '\u{1e25}'), ('\u{1e26}', '\u{1e27}'),
        ('\u{1e28}', '\u{1e29}'), ('\u{1e2a}', '\u{1e2b}'), ('\u{1e2c}', '\u{1e2d}'), ('\u{1e2e}',
        '\u{1e2f}'), ('\u{1e30}', '\u{1e31}'), ('\u{1e32}', '\u{1e33}'), ('\u{1e34}', '\u{1e35}'),
        ('\u{1e36}', '\u{1e37}'), ('\u{1e38}', '\u{1e39}'), ('\u{1e3a}', '\u{1e3b}'), ('\u{1e3c}',
        '\u{1e3d}'), ('\u{1e3e}', '\u{1e3f}'), ('\u{1e40}', '\u{1e41}'), ('\u{1e42}', '\u{1e43}'),
        ('\u{1e44}', '\u{1e45}'), ('\u{1e46}', '\u{1e47}'), ('\u{1e48}', '\u{1e49}'), ('\u{1e4a}',
        '\u{1e4b}'), ('\u{1e4c}', '\u{1e4d}'), ('\u{1e4e}', '\u{1e4f}'), ('\u{1e50}', '\u{1e51}'),
        ('\u{1e52}', '\u{1e53}'), ('\u{1e54}', '\u{1e55}'), ('\u{1e56}', '\u{1e57}'), ('\u{1e58}',
        '\u{1e59}'), ('\u{1e5a}', '\u{1e5b}'), ('\u{1e5c}', '\u{1e5d}'), ('\u{1e5e}', '\u{1e5f}'),
        ('\u{1e60}', '\u{1e61}'), ('\u{1e62}', '\u{1e63}'), ('\u{1e64}', '\u{1e65}'), ('\u{1e66}',
        '\u{1e67}'), ('\u{1e68}', '\u{1e69}'), ('\u{1e6a}', '\u{1e6b}'), ('\u{1e6c}', '\u{1e6d}'),
        ('\u{1e6e}', '\u{1e6f}'), ('\u{1e70}', '\u{1e71}'), ('\u{1e72}', '\u{1e73}'), ('\u{1e74}',
        '\u{1e75}'), ('\u{1e76}', '\u{1e77}'), ('\u{1e78}', '\u{1e79}'), ('\u{1e7a}', '\u{1e7b}'),
        ('\u{1e7c}', '\u{1e7d}'), ('\u{1e7e}', '\u{1e7f}'), ('\u{1e80}', '\u{1e81}'), ('\u{1e82}',
        '\u{1e83}'), ('\u{1e84}', '\u{1e85}'), ('\u{1e86}', '\u{1e87}'), ('\u{1e88}', '\u{1e89}'),
        ('\u{1e8a}', '\u{1e8b}'), ('\u{1e8c}', '\u{1e8d}'), ('\u{1e8e}', '\u{1e8f}'), ('\u{1e90}',
        '\u{1e91}'), ('\u{1e92}', '\u{1e93}'), ('\u{1e94}', '\u{1e95}'), ('\u{1e9e}', '\u{df}'),
        ('\u{1ea0}', '\u{1ea1}'), ('\u{1ea2}', '\u{1ea3}'), ('\u{1ea4}', '\u{1ea5}'), ('\u{1ea6}',
        '\u{1ea7}'), ('\u{1ea8}', '\u{1ea9}'), ('\u{1eaa}', '\u{1eab}'), ('\u{1eac}', '\u{1ead}'),
        ('\u{1eae}', '\u{1eaf}'), ('\u{1eb0}', '\u{1eb1}'), ('\u{1eb2}', '\u{1eb3}'), ('\u{1eb4}',
        '\u{1eb5}'), ('\u{1eb6}', '\u{1eb7}'), ('\u{1eb8}', '\u{1eb9}'), ('\u{1eba}', '\u{1ebb}'),
        ('\u{1ebc}', '\u{1ebd}'), ('\u{1ebe}', '\u{1ebf}'), ('\u{1ec0}', '\u{1ec1}'), ('\u{1ec2}',
        '\u{1ec3}'), ('\u{1ec4}', '\u{1ec5}'), ('\u{1ec6}', '\u{1ec7}'), ('\u{1ec8}', '\u{1ec9}'),
        ('\u{1eca}', '\u{1ecb}'), ('\u{1ecc}', '\u{1ecd}'), ('\u{1ece}', '\u{1ecf}'), ('\u{1ed0}',
        '\u{1ed1}'), ('\u{1ed2}', '\u{1ed3}'), ('\u{1ed4}', '\u{1ed5}'), ('\u{1ed6}', '\u{1ed7}'),
        ('\u{1ed8}', '\u{1ed9}'), ('\u{1eda}', '\u{1edb}'), ('\u{1edc}', '\u{1edd}'), ('\u{1ede}',
        '\u{1edf}'), ('\u{1ee0}', '\u{1ee1}'), ('\u{1ee2}', '\u{1ee3}'), ('\u{1ee4}', '\u{1ee5}'),
        ('\u{1ee6}', '\u{1ee7}'), ('\u{1ee8}', '\u{1ee9}'), ('\u{1eea}', '\u{1eeb}'), ('\u{1eec}',
        '\u{1eed}'), ('\u{1eee}', '\u{1eef}'), ('\u{1ef0}', '\u{1ef1}'), ('\u{1ef2}', '\u{1ef3}'),
        ('\u{1ef4}', '\u{1ef5}'), ('\u{1ef6}', '\u{1ef7}'), ('\u{1ef8}', '\u{1ef9}'), ('\u{1efa}',
        '\u{1efb}'), ('\u{1efc}', '\u{1efd}'), ('\u{1efe}', '\u{1eff}'), ('\u{1f08}', '\u{1f00}'),
        ('\u{1f09}', '\u{1f01}'), ('\u{1f0a}', '\u{1f02}'), ('\u{1f0b}', '\u{1f03}'), ('\u{1f0c}',
        '\u{1f04}'), ('\u{1f0d}', '\u{1f05}'), ('\u{1f0e}', '\u{1f06}'), ('\u{1f0f}', '\u{1f07}'),
        ('\u{1f18}', '\u{1f10}'), ('\u{1f19}', '\u{1f11}'), ('\u{1f1a}', '\u{1f12}'), ('\u{1f1b}',
        '\u{1f13}'), ('\u{1f1c}', '\u{1f14}'), ('\u{1f1d}', '\u{1f15}'), ('\u{1f28}', '\u{1f20}'),
        ('\u{1f29}', '\u{1f21}'), ('\u{1f2a}', '\u{1f22}'), ('\u{1f2b}', '\u{1f23}'), ('\u{1f2c}',
        '\u{1f24}'), ('\u{1f2d}', '\u{1f25}'), ('\u{1f2e}', '\u{1f26}'), ('\u{1f2f}', '\u{1f27}'),
        ('\u{1f38}', '\u{1f30}'), ('\u{1f39}', '\u{1f31}'), ('\u{1f3a}', '\u{1f32}'), ('\u{1f3b}',
        '\u{1f33}'), ('\u{1f3c}', '\u{1f34}'), ('\u{1f3d}', '\u{1f35}'), ('\u{1f3e}', '\u{1f36}'),
        ('\u{1f3f}', '\u{1f37}'), ('\u{1f48}', '\u{1f40}'), ('\u{1f49}', '\u{1f41}'), ('\u{1f4a}',
        '\u{1f42}'), ('\u{1f4b}', '\u{1f43}'), ('\u{1f4c}', '\u{1f44}'), ('\u{1f4d}', '\u{1f45}'),
        ('\u{1f59}', '\u{1f51}'), ('\u{1f5b}', '\u{1f53}'), ('\u{1f5d}', '\u{1f55}'), ('\u{1f5f}',
        '\u{1f57}'), ('\u{1f68}', '\u{1f60}'), ('\u{1f69}', '\u{1f61}'), ('\u{1f6a}', '\u{1f62}'),
        ('\u{1f6b}', '\u{1f63}'), ('\u{1f6c}', '\u{1f64}'), ('\u{1f6d}', '\u{1f65}'), ('\u{1f6e}',
        '\u{1f66}'), ('\u{1f6f}', '\u{1f67}'), ('\u{1fb8}', '\u{1fb0}'), ('\u{1fb9}', '\u{1fb1}'),
        ('\u{1fba}', '\u{1f70}'), ('\u{1fbb}', '\u{1f71}'), ('\u{1fc8}', '\u{1f72}'), ('\u{1fc9}',
        '\u{1f73}'), ('\u{1fca}', '\u{1f74}'), ('\u{1fcb}', '\u{1f75}'), ('\u{1fd8}', '\u{1fd0}'),
        ('\u{1fd9}', '\u{1fd1}'), ('\u{1fda}', '\u{1f76}'), ('\u{1fdb}', '\u{1f77}'), ('\u{1fe8}',
        '\u{1fe0}'), ('\u{1fe9}', '\u{1fe1}'), ('\u{1fea}', '\u{1f7a}'), ('\u{1feb}', '\u{1f7b}'),
        ('\u{1fec}', '\u{1fe5}'), ('\u{1ff8}', '\u{1f78}'), ('\u{1ff9}', '\u{1f79}'), ('\u{1ffa}',
        '\u{1f7c}'), ('\u{1ffb}', '\u{1f7d}'), ('\u{2126}', '\u{3c9}'), ('\u{212a}', '\u{6b}'),
        ('\u{212b}', '\u{e5}'), ('\u{2132}', '\u{214e}'), ('\u{2183}', '\u{2184}'), ('\u{2c00}',
        '\u{2c30}'), ('\u{2c01}', '\u{2c31}'), ('\u{2c02}', '\u{2c32}'), ('\u{2c03}', '\u{2c33}'),
        ('\u{2c04}', '\u{2c34}'), ('\u{2c05}', '\u{2c35}'), ('\u{2c06}', '\u{2c36}'), ('\u{2c07}',
        '\u{2c37}'), ('\u{2c08}', '\u{2c38}'), ('\u{2c09}', '\u{2c39}'), ('\u{2c0a}', '\u{2c3a}'),
        ('\u{2c0b}', '\u{2c3b}'), ('\u{2c0c}', '\u{2c3c}'), ('\u{2c0d}', '\u{2c3d}'), ('\u{2c0e}',
        '\u{2c3e}'), ('\u{2c0f}', '\u{2c3f}'), ('\u{2c10}', '\u{2c40}'), ('\u{2c11}', '\u{2c41}'),
        ('\u{2c12}', '\u{2c42}'), ('\u{2c13}', '\u{2c43}'), ('\u{2c14}', '\u{2c44}'), ('\u{2c15}',
        '\u{2c45}'), ('\u{2c16}', '\u{2c46}'), ('\u{2c17}', '\u{2c47}'), ('\u{2c18}', '\u{2c48}'),
        ('\u{2c19}', '\u{2c49}'), ('\u{2c1a}', '\u{2c4a}'), ('\u{2c1b}', '\u{2c4b}'), ('\u{2c1c}',
        '\u{2c4c}'), ('\u{2c1d}', '\u{2c4d}'), ('\u{2c1e}', '\u{2c4e}'), ('\u{2c1f}', '\u{2c4f}'),
        ('\u{2c20}', '\u{2c50}'), ('\u{2c21}', '\u{2c51}'), ('\u{2c22}', '\u{2c52}'), ('\u{2c23}',
        '\u{2c53}'), ('\u{2c24}', '\u{2c54}'), ('\u{2c25}', '\u{2c55}'), ('\u{2c26}', '\u{2c56}'),
        ('\u{2c27}', '\u{2c57}'), ('\u{2c28}', '\u{2c58}'), ('\u{2c29}', '\u{2c59}'), ('\u{2c2a}',
        '\u{2c5a}'), ('\u{2c2b}', '\u{2c5b}'), ('\u{2c2c}', '\u{2c5c}'), ('\u{2c2d}', '\u{2c5d}'),
        ('\u{2c2e}', '\u{2c5e}'), ('\u{2c60}', '\u{2c61}'), ('\u{2c62}', '\u{26b}'), ('\u{2c63}',
        '\u{1d7d}'), ('\u{2c64}', '\u{27d}'), ('\u{2c67}', '\u{2c68}'), ('\u{2c69}', '\u{2c6a}'),
        ('\u{2c6b}', '\u{2c6c}'), ('\u{2c6d}', '\u{251}'), ('\u{2c6e}', '\u{271}'), ('\u{2c6f}',
        '\u{250}'), ('\u{2c70}', '\u{252}'), ('\u{2c72}', '\u{2c73}'), ('\u{2c75}', '\u{2c76}'),
        ('\u{2c7e}', '\u{23f}'), ('\u{2c7f}', '\u{240}'), ('\u{2c80}', '\u{2c81}'), ('\u{2c82}',
        '\u{2c83}'), ('\u{2c84}', '\u{2c85}'), ('\u{2c86}', '\u{2c87}'), ('\u{2c88}', '\u{2c89}'),
        ('\u{2c8a}', '\u{2c8b}'), ('\u{2c8c}', '\u{2c8d}'), ('\u{2c8e}', '\u{2c8f}'), ('\u{2c90}',
        '\u{2c91}'), ('\u{2c92}', '\u{2c93}'), ('\u{2c94}', '\u{2c95}'), ('\u{2c96}', '\u{2c97}'),
        ('\u{2c98}', '\u{2c99}'), ('\u{2c9a}', '\u{2c9b}'), ('\u{2c9c}', '\u{2c9d}'), ('\u{2c9e}',
        '\u{2c9f}'), ('\u{2ca0}', '\u{2ca1}'), ('\u{2ca2}', '\u{2ca3}'), ('\u{2ca4}', '\u{2ca5}'),
        ('\u{2ca6}', '\u{2ca7}'), ('\u{2ca8}', '\u{2ca9}'), ('\u{2caa}', '\u{2cab}'), ('\u{2cac}',
        '\u{2cad}'), ('\u{2cae}', '\u{2caf}'), ('\u{2cb0}', '\u{2cb1}'), ('\u{2cb2}', '\u{2cb3}'),
        ('\u{2cb4}', '\u{2cb5}'), ('\u{2cb6}', '\u{2cb7}'), ('\u{2cb8}', '\u{2cb9}'), ('\u{2cba}',
        '\u{2cbb}'), ('\u{2cbc}', '\u{2cbd}'), ('\u{2cbe}', '\u{2cbf}'), ('\u{2cc0}', '\u{2cc1}'),
        ('\u{2cc2}', '\u{2cc3}'), ('\u{2cc4}', '\u{2cc5}'), ('\u{2cc6}', '\u{2cc7}'), ('\u{2cc8}',
        '\u{2cc9}'), ('\u{2cca}', '\u{2ccb}'), ('\u{2ccc}', '\u{2ccd}'), ('\u{2cce}', '\u{2ccf}'),
        ('\u{2cd0}', '\u{2cd1}'), ('\u{2cd2}', '\u{2cd3}'), ('\u{2cd4}', '\u{2cd5}'), ('\u{2cd6}',
        '\u{2cd7}'), ('\u{2cd8}', '\u{2cd9}'), ('\u{2cda}', '\u{2cdb}'), ('\u{2cdc}', '\u{2cdd}'),
        ('\u{2cde}', '\u{2cdf}'), ('\u{2ce0}', '\u{2ce1}'), ('\u{2ce2}', '\u{2ce3}'), ('\u{2ceb}',
        '\u{2cec}'), ('\u{2ced}', '\u{2cee}'), ('\u{2cf2}', '\u{2cf3}'), ('\u{a640}', '\u{a641}'),
        ('\u{a642}', '\u{a643}'), ('\u{a644}', '\u{a645}'), ('\u{a646}', '\u{a647}'), ('\u{a648}',
        '\u{a649}'), ('\u{a64a}', '\u{a64b}'), ('\u{a64c}', '\u{a64d}'), ('\u{a64e}', '\u{a64f}'),
        ('\u{a650}', '\u{a651}'), ('\u{a652}', '\u{a653}'), ('\u{a654}', '\u{a655}'), ('\u{a656}',
        '\u{a657}'), ('\u{a658}', '\u{a659}'), ('\u{a65a}', '\u{a65b}'), ('\u{a65c}', '\u{a65d}'),
        ('\u{a65e}', '\u{a65f}'), ('\u{a660}', '\u{a661}'), ('\u{a662}', '\u{a663}'), ('\u{a664}',
        '\u{a665}'), ('\u{a666}', '\u{a667}'), ('\u{a668}', '\u{a669}'), ('\u{a66a}', '\u{a66b}'),
        ('\u{a66c}', '\u{a66d}'), ('\u{a680}', '\u{a681}'), ('\u{a682}', '\u{a683}'), ('\u{a684}',
        '\u{a685}'), ('\u{a686}', '\u{a687}'), ('\u{a688}', '\u{a689}'), ('\u{a68a}', '\u{a68b}'),
        ('\u{a68c}', '\u{a68d}'), ('\u{a68e}', '\u{a68f}'), ('\u{a690}', '\u{a691}'), ('\u{a692}',
        '\u{a693}'), ('\u{a694}', '\u{a695}'), ('\u{a696}', '\u{a697}'), ('\u{a698}', '\u{a699}'),
        ('\u{a69a}', '\u{a69b}'), ('\u{a722}', '\u{a723}'), ('\u{a724}', '\u{a725}'), ('\u{a726}',
        '\u{a727}'), ('\u{a728}', '\u{a729}'), ('\u{a72a}', '\u{a72b}'), ('\u{a72c}', '\u{a72d}'),
        ('\u{a72e}', '\u{a72f}'), ('\u{a732}', '\u{a733}'), ('\u{a734}', '\u{a735}'), ('\u{a736}',
        '\u{a737}'), ('\u{a738}', '\u{a739}'), ('\u{a73a}', '\u{a73b}'), ('\u{a73c}', '\u{a73d}'),
        ('\u{a73e}', '\u{a73f}'), ('\u{a740}', '\u{a741}'), ('\u{a742}', '\u{a743}'), ('\u{a744}',
        '\u{a745}'), ('\u{a746}', '\u{a747}'), ('\u{a748}', '\u{a749}'), ('\u{a74a}', '\u{a74b}'),
        ('\u{a74c}', '\u{a74d}'), ('\u{a74e}', '\u{a74f}'), ('\u{a750}', '\u{a751}'), ('\u{a752}',
        '\u{a753}'), ('\u{a754}', '\u{a755}'), ('\u{a756}', '\u{a757}'), ('\u{a758}', '\u{a759}'),
        ('\u{a75a}', '\u{a75b}'), ('\u{a75c}', '\u{a75d}'), ('\u{a75e}', '\u{a75f}'), ('\u{a760}',
        '\u{a761}'), ('\u{a762}', '\u{a763}'), ('\u{a764}', '\u{a765}'), ('\u{a766}', '\u{a767}'),
        ('\u{a768}', '\u{a769}'), ('\u{a76a}', '\u{a76b}'), ('\u{a76c}', '\u{a76d}'), ('\u{a76e}',
        '\u{a76f}'), ('\u{a779}', '\u{a77a}'), ('\u{a77b}', '\u{a77c}'), ('\u{a77d}', '\u{1d79}'),
        ('\u{a77e}', '\u{a77f}'), ('\u{a780}', '\u{a781}'), ('\u{a782}', '\u{a783}'), ('\u{a784}',
        '\u{a785}'), ('\u{a786}', '\u{a787}'), ('\u{a78b}', '\u{a78c}'), ('\u{a78d}', '\u{265}'),
        ('\u{a790}', '\u{a791}'), ('\u{a792}', '\u{a793}'), ('\u{a796}', '\u{a797}'), ('\u{a798}',
        '\u{a799}'), ('\u{a79a}', '\u{a79b}'), ('\u{a79c}', '\u{a79d}'), ('\u{a79e}', '\u{a79f}'),
        ('\u{a7a0}', '\u{a7a1}'), ('\u{a7a2}', '\u{a7a3}'), ('\u{a7a4}', '\u{a7a5}'), ('\u{a7a6}',
        '\u{a7a7}'), ('\u{a7a8}', '\u{a7a9}'), ('\u{a7aa}', '\u{266}'), ('\u{a7ab}', '\u{25c}'),
        ('\u{a7ac}', '\u{261}'), ('\u{a7ad}', '\u{26c}'), ('\u{a7b0}', '\u{29e}'), ('\u{a7b1}',
        '\u{287}'), ('\u{ff21}', '\u{ff41}'), ('\u{ff22}', '\u{ff42}'), ('\u{ff23}', '\u{ff43}'),
        ('\u{ff24}', '\u{ff44}'), ('\u{ff25}', '\u{ff45}'), ('\u{ff26}', '\u{ff46}'), ('\u{ff27}',
        '\u{ff47}'), ('\u{ff28}', '\u{ff48}'), ('\u{ff29}', '\u{ff49}'), ('\u{ff2a}', '\u{ff4a}'),
        ('\u{ff2b}', '\u{ff4b}'), ('\u{ff2c}', '\u{ff4c}'), ('\u{ff2d}', '\u{ff4d}'), ('\u{ff2e}',
        '\u{ff4e}'), ('\u{ff2f}', '\u{ff4f}'), ('\u{ff30}', '\u{ff50}'), ('\u{ff31}', '\u{ff51}'),
        ('\u{ff32}', '\u{ff52}'), ('\u{ff33}', '\u{ff53}'), ('\u{ff34}', '\u{ff54}'), ('\u{ff35}',
        '\u{ff55}'), ('\u{ff36}', '\u{ff56}'), ('\u{ff37}', '\u{ff57}'), ('\u{ff38}', '\u{ff58}'),
        ('\u{ff39}', '\u{ff59}'), ('\u{ff3a}', '\u{ff5a}'), ('\u{10400}', '\u{10428}'),
        ('\u{10401}', '\u{10429}'), ('\u{10402}', '\u{1042a}'), ('\u{10403}', '\u{1042b}'),
        ('\u{10404}', '\u{1042c}'), ('\u{10405}', '\u{1042d}'), ('\u{10406}', '\u{1042e}'),
        ('\u{10407}', '\u{1042f}'), ('\u{10408}', '\u{10430}'), ('\u{10409}', '\u{10431}'),
        ('\u{1040a}', '\u{10432}'), ('\u{1040b}', '\u{10433}'), ('\u{1040c}', '\u{10434}'),
        ('\u{1040d}', '\u{10435}'), ('\u{1040e}', '\u{10436}'), ('\u{1040f}', '\u{10437}'),
        ('\u{10410}', '\u{10438}'), ('\u{10411}', '\u{10439}'), ('\u{10412}', '\u{1043a}'),
        ('\u{10413}', '\u{1043b}'), ('\u{10414}', '\u{1043c}'), ('\u{10415}', '\u{1043d}'),
        ('\u{10416}', '\u{1043e}'), ('\u{10417}', '\u{1043f}'), ('\u{10418}', '\u{10440}'),
        ('\u{10419}', '\u{10441}'), ('\u{1041a}', '\u{10442}'), ('\u{1041b}', '\u{10443}'),
        ('\u{1041c}', '\u{10444}'), ('\u{1041d}', '\u{10445}'), ('\u{1041e}', '\u{10446}'),
        ('\u{1041f}', '\u{10447}'), ('\u{10420}', '\u{10448}'), ('\u{10421}', '\u{10449}'),
        ('\u{10422}', '\u{1044a}'), ('\u{10423}', '\u{1044b}'), ('\u{10424}', '\u{1044c}'),
        ('\u{10425}', '\u{1044d}'), ('\u{10426}', '\u{1044e}'), ('\u{10427}', '\u{1044f}'),
        ('\u{118a0}', '\u{118c0}'), ('\u{118a1}', '\u{118c1}'), ('\u{118a2}', '\u{118c2}'),
        ('\u{118a3}', '\u{118c3}'), ('\u{118a4}', '\u{118c4}'), ('\u{118a5}', '\u{118c5}'),
        ('\u{118a6}', '\u{118c6}'), ('\u{118a7}', '\u{118c7}'), ('\u{118a8}', '\u{118c8}'),
        ('\u{118a9}', '\u{118c9}'), ('\u{118aa}', '\u{118ca}'), ('\u{118ab}', '\u{118cb}'),
        ('\u{118ac}', '\u{118cc}'), ('\u{118ad}', '\u{118cd}'), ('\u{118ae}', '\u{118ce}'),
        ('\u{118af}', '\u{118cf}'), ('\u{118b0}', '\u{118d0}'), ('\u{118b1}', '\u{118d1}'),
        ('\u{118b2}', '\u{118d2}'), ('\u{118b3}', '\u{118d3}'), ('\u{118b4}', '\u{118d4}'),
        ('\u{118b5}', '\u{118d5}'), ('\u{118b6}', '\u{118d6}'), ('\u{118b7}', '\u{118d7}'),
        ('\u{118b8}', '\u{118d8}'), ('\u{118b9}', '\u{118d9}'), ('\u{118ba}', '\u{118da}'),
        ('\u{118bb}', '\u{118db}'), ('\u{118bc}', '\u{118dc}'), ('\u{118bd}', '\u{118dd}'),
        ('\u{118be}', '\u{118de}'), ('\u{118bf}', '\u{118df}')
    ];

    static LlLu_table: &'static [(char, char)] = &[
        ('\u{61}', '\u{41}'), ('\u{62}', '\u{42}'), ('\u{63}', '\u{43}'), ('\u{64}', '\u{44}'),
        ('\u{65}', '\u{45}'), ('\u{66}', '\u{46}'), ('\u{67}', '\u{47}'), ('\u{68}', '\u{48}'),
        ('\u{69}', '\u{49}'), ('\u{6a}', '\u{4a}'), ('\u{6b}', '\u{4b}'), ('\u{6c}', '\u{4c}'),
        ('\u{6d}', '\u{4d}'), ('\u{6e}', '\u{4e}'), ('\u{6f}', '\u{4f}'), ('\u{70}', '\u{50}'),
        ('\u{71}', '\u{51}'), ('\u{72}', '\u{52}'), ('\u{73}', '\u{53}'), ('\u{74}', '\u{54}'),
        ('\u{75}', '\u{55}'), ('\u{76}', '\u{56}'), ('\u{77}', '\u{57}'), ('\u{78}', '\u{58}'),
        ('\u{79}', '\u{59}'), ('\u{7a}', '\u{5a}'), ('\u{b5}', '\u{39c}'), ('\u{e0}', '\u{c0}'),
        ('\u{e1}', '\u{c1}'), ('\u{e2}', '\u{c2}'), ('\u{e3}', '\u{c3}'), ('\u{e4}', '\u{c4}'),
        ('\u{e5}', '\u{c5}'), ('\u{e6}', '\u{c6}'), ('\u{e7}', '\u{c7}'), ('\u{e8}', '\u{c8}'),
        ('\u{e9}', '\u{c9}'), ('\u{ea}', '\u{ca}'), ('\u{eb}', '\u{cb}'), ('\u{ec}', '\u{cc}'),
        ('\u{ed}', '\u{cd}'), ('\u{ee}', '\u{ce}'), ('\u{ef}', '\u{cf}'), ('\u{f0}', '\u{d0}'),
        ('\u{f1}', '\u{d1}'), ('\u{f2}', '\u{d2}'), ('\u{f3}', '\u{d3}'), ('\u{f4}', '\u{d4}'),
        ('\u{f5}', '\u{d5}'), ('\u{f6}', '\u{d6}'), ('\u{f8}', '\u{d8}'), ('\u{f9}', '\u{d9}'),
        ('\u{fa}', '\u{da}'), ('\u{fb}', '\u{db}'), ('\u{fc}', '\u{dc}'), ('\u{fd}', '\u{dd}'),
        ('\u{fe}', '\u{de}'), ('\u{ff}', '\u{178}'), ('\u{101}', '\u{100}'), ('\u{103}', '\u{102}'),
        ('\u{105}', '\u{104}'), ('\u{107}', '\u{106}'), ('\u{109}', '\u{108}'), ('\u{10b}',
        '\u{10a}'), ('\u{10d}', '\u{10c}'), ('\u{10f}', '\u{10e}'), ('\u{111}', '\u{110}'),
        ('\u{113}', '\u{112}'), ('\u{115}', '\u{114}'), ('\u{117}', '\u{116}'), ('\u{119}',
        '\u{118}'), ('\u{11b}', '\u{11a}'), ('\u{11d}', '\u{11c}'), ('\u{11f}', '\u{11e}'),
        ('\u{121}', '\u{120}'), ('\u{123}', '\u{122}'), ('\u{125}', '\u{124}'), ('\u{127}',
        '\u{126}'), ('\u{129}', '\u{128}'), ('\u{12b}', '\u{12a}'), ('\u{12d}', '\u{12c}'),
        ('\u{12f}', '\u{12e}'), ('\u{131}', '\u{49}'), ('\u{133}', '\u{132}'), ('\u{135}',
        '\u{134}'), ('\u{137}', '\u{136}'), ('\u{13a}', '\u{139}'), ('\u{13c}', '\u{13b}'),
        ('\u{13e}', '\u{13d}'), ('\u{140}', '\u{13f}'), ('\u{142}', '\u{141}'), ('\u{144}',
        '\u{143}'), ('\u{146}', '\u{145}'), ('\u{148}', '\u{147}'), ('\u{14b}', '\u{14a}'),
        ('\u{14d}', '\u{14c}'), ('\u{14f}', '\u{14e}'), ('\u{151}', '\u{150}'), ('\u{153}',
        '\u{152}'), ('\u{155}', '\u{154}'), ('\u{157}', '\u{156}'), ('\u{159}', '\u{158}'),
        ('\u{15b}', '\u{15a}'), ('\u{15d}', '\u{15c}'), ('\u{15f}', '\u{15e}'), ('\u{161}',
        '\u{160}'), ('\u{163}', '\u{162}'), ('\u{165}', '\u{164}'), ('\u{167}', '\u{166}'),
        ('\u{169}', '\u{168}'), ('\u{16b}', '\u{16a}'), ('\u{16d}', '\u{16c}'), ('\u{16f}',
        '\u{16e}'), ('\u{171}', '\u{170}'), ('\u{173}', '\u{172}'), ('\u{175}', '\u{174}'),
        ('\u{177}', '\u{176}'), ('\u{17a}', '\u{179}'), ('\u{17c}', '\u{17b}'), ('\u{17e}',
        '\u{17d}'), ('\u{17f}', '\u{53}'), ('\u{180}', '\u{243}'), ('\u{183}', '\u{182}'),
        ('\u{185}', '\u{184}'), ('\u{188}', '\u{187}'), ('\u{18c}', '\u{18b}'), ('\u{192}',
        '\u{191}'), ('\u{195}', '\u{1f6}'), ('\u{199}', '\u{198}'), ('\u{19a}', '\u{23d}'),
        ('\u{19e}', '\u{220}'), ('\u{1a1}', '\u{1a0}'), ('\u{1a3}', '\u{1a2}'), ('\u{1a5}',
        '\u{1a4}'), ('\u{1a8}', '\u{1a7}'), ('\u{1ad}', '\u{1ac}'), ('\u{1b0}', '\u{1af}'),
        ('\u{1b4}', '\u{1b3}'), ('\u{1b6}', '\u{1b5}'), ('\u{1b9}', '\u{1b8}'), ('\u{1bd}',
        '\u{1bc}'), ('\u{1bf}', '\u{1f7}'), ('\u{1c6}', '\u{1c4}'), ('\u{1c9}', '\u{1c7}'),
        ('\u{1cc}', '\u{1ca}'), ('\u{1ce}', '\u{1cd}'), ('\u{1d0}', '\u{1cf}'), ('\u{1d2}',
        '\u{1d1}'), ('\u{1d4}', '\u{1d3}'), ('\u{1d6}', '\u{1d5}'), ('\u{1d8}', '\u{1d7}'),
        ('\u{1da}', '\u{1d9}'), ('\u{1dc}', '\u{1db}'), ('\u{1dd}', '\u{18e}'), ('\u{1df}',
        '\u{1de}'), ('\u{1e1}', '\u{1e0}'), ('\u{1e3}', '\u{1e2}'), ('\u{1e5}', '\u{1e4}'),
        ('\u{1e7}', '\u{1e6}'), ('\u{1e9}', '\u{1e8}'), ('\u{1eb}', '\u{1ea}'), ('\u{1ed}',
        '\u{1ec}'), ('\u{1ef}', '\u{1ee}'), ('\u{1f3}', '\u{1f1}'), ('\u{1f5}', '\u{1f4}'),
        ('\u{1f9}', '\u{1f8}'), ('\u{1fb}', '\u{1fa}'), ('\u{1fd}', '\u{1fc}'), ('\u{1ff}',
        '\u{1fe}'), ('\u{201}', '\u{200}'), ('\u{203}', '\u{202}'), ('\u{205}', '\u{204}'),
        ('\u{207}', '\u{206}'), ('\u{209}', '\u{208}'), ('\u{20b}', '\u{20a}'), ('\u{20d}',
        '\u{20c}'), ('\u{20f}', '\u{20e}'), ('\u{211}', '\u{210}'), ('\u{213}', '\u{212}'),
        ('\u{215}', '\u{214}'), ('\u{217}', '\u{216}'), ('\u{219}', '\u{218}'), ('\u{21b}',
        '\u{21a}'), ('\u{21d}', '\u{21c}'), ('\u{21f}', '\u{21e}'), ('\u{223}', '\u{222}'),
        ('\u{225}', '\u{224}'), ('\u{227}', '\u{226}'), ('\u{229}', '\u{228}'), ('\u{22b}',
        '\u{22a}'), ('\u{22d}', '\u{22c}'), ('\u{22f}', '\u{22e}'), ('\u{231}', '\u{230}'),
        ('\u{233}', '\u{232}'), ('\u{23c}', '\u{23b}'), ('\u{23f}', '\u{2c7e}'), ('\u{240}',
        '\u{2c7f}'), ('\u{242}', '\u{241}'), ('\u{247}', '\u{246}'), ('\u{249}', '\u{248}'),
        ('\u{24b}', '\u{24a}'), ('\u{24d}', '\u{24c}'), ('\u{24f}', '\u{24e}'), ('\u{250}',
        '\u{2c6f}'), ('\u{251}', '\u{2c6d}'), ('\u{252}', '\u{2c70}'), ('\u{253}', '\u{181}'),
        ('\u{254}', '\u{186}'), ('\u{256}', '\u{189}'), ('\u{257}', '\u{18a}'), ('\u{259}',
        '\u{18f}'), ('\u{25b}', '\u{190}'), ('\u{25c}', '\u{a7ab}'), ('\u{260}', '\u{193}'),
        ('\u{261}', '\u{a7ac}'), ('\u{263}', '\u{194}'), ('\u{265}', '\u{a78d}'), ('\u{266}',
        '\u{a7aa}'), ('\u{268}', '\u{197}'), ('\u{269}', '\u{196}'), ('\u{26b}', '\u{2c62}'),
        ('\u{26c}', '\u{a7ad}'), ('\u{26f}', '\u{19c}'), ('\u{271}', '\u{2c6e}'), ('\u{272}',
        '\u{19d}'), ('\u{275}', '\u{19f}'), ('\u{27d}', '\u{2c64}'), ('\u{280}', '\u{1a6}'),
        ('\u{283}', '\u{1a9}'), ('\u{287}', '\u{a7b1}'), ('\u{288}', '\u{1ae}'), ('\u{289}',
        '\u{244}'), ('\u{28a}', '\u{1b1}'), ('\u{28b}', '\u{1b2}'), ('\u{28c}', '\u{245}'),
        ('\u{292}', '\u{1b7}'), ('\u{29e}', '\u{a7b0}'), ('\u{371}', '\u{370}'), ('\u{373}',
        '\u{372}'), ('\u{377}', '\u{376}'), ('\u{37b}', '\u{3fd}'), ('\u{37c}', '\u{3fe}'),
        ('\u{37d}', '\u{3ff}'), ('\u{3ac}', '\u{386}'), ('\u{3ad}', '\u{388}'), ('\u{3ae}',
        '\u{389}'), ('\u{3af}', '\u{38a}'), ('\u{3b1}', '\u{391}'), ('\u{3b2}', '\u{392}'),
        ('\u{3b3}', '\u{393}'), ('\u{3b4}', '\u{394}'), ('\u{3b5}', '\u{395}'), ('\u{3b6}',
        '\u{396}'), ('\u{3b7}', '\u{397}'), ('\u{3b8}', '\u{398}'), ('\u{3b9}', '\u{399}'),
        ('\u{3ba}', '\u{39a}'), ('\u{3bb}', '\u{39b}'), ('\u{3bc}', '\u{39c}'), ('\u{3bd}',
        '\u{39d}'), ('\u{3be}', '\u{39e}'), ('\u{3bf}', '\u{39f}'), ('\u{3c0}', '\u{3a0}'),
        ('\u{3c1}', '\u{3a1}'), ('\u{3c2}', '\u{3a3}'), ('\u{3c3}', '\u{3a3}'), ('\u{3c4}',
        '\u{3a4}'), ('\u{3c5}', '\u{3a5}'), ('\u{3c6}', '\u{3a6}'), ('\u{3c7}', '\u{3a7}'),
        ('\u{3c8}', '\u{3a8}'), ('\u{3c9}', '\u{3a9}'), ('\u{3ca}', '\u{3aa}'), ('\u{3cb}',
        '\u{3ab}'), ('\u{3cc}', '\u{38c}'), ('\u{3cd}', '\u{38e}'), ('\u{3ce}', '\u{38f}'),
        ('\u{3d0}', '\u{392}'), ('\u{3d1}', '\u{398}'), ('\u{3d5}', '\u{3a6}'), ('\u{3d6}',
        '\u{3a0}'), ('\u{3d7}', '\u{3cf}'), ('\u{3d9}', '\u{3d8}'), ('\u{3db}', '\u{3da}'),
        ('\u{3dd}', '\u{3dc}'), ('\u{3df}', '\u{3de}'), ('\u{3e1}', '\u{3e0}'), ('\u{3e3}',
        '\u{3e2}'), ('\u{3e5}', '\u{3e4}'), ('\u{3e7}', '\u{3e6}'), ('\u{3e9}', '\u{3e8}'),
        ('\u{3eb}', '\u{3ea}'), ('\u{3ed}', '\u{3ec}'), ('\u{3ef}', '\u{3ee}'), ('\u{3f0}',
        '\u{39a}'), ('\u{3f1}', '\u{3a1}'), ('\u{3f2}', '\u{3f9}'), ('\u{3f3}', '\u{37f}'),
        ('\u{3f5}', '\u{395}'), ('\u{3f8}', '\u{3f7}'), ('\u{3fb}', '\u{3fa}'), ('\u{430}',
        '\u{410}'), ('\u{431}', '\u{411}'), ('\u{432}', '\u{412}'), ('\u{433}', '\u{413}'),
        ('\u{434}', '\u{414}'), ('\u{435}', '\u{415}'), ('\u{436}', '\u{416}'), ('\u{437}',
        '\u{417}'), ('\u{438}', '\u{418}'), ('\u{439}', '\u{419}'), ('\u{43a}', '\u{41a}'),
        ('\u{43b}', '\u{41b}'), ('\u{43c}', '\u{41c}'), ('\u{43d}', '\u{41d}'), ('\u{43e}',
        '\u{41e}'), ('\u{43f}', '\u{41f}'), ('\u{440}', '\u{420}'), ('\u{441}', '\u{421}'),
        ('\u{442}', '\u{422}'), ('\u{443}', '\u{423}'), ('\u{444}', '\u{424}'), ('\u{445}',
        '\u{425}'), ('\u{446}', '\u{426}'), ('\u{447}', '\u{427}'), ('\u{448}', '\u{428}'),
        ('\u{449}', '\u{429}'), ('\u{44a}', '\u{42a}'), ('\u{44b}', '\u{42b}'), ('\u{44c}',
        '\u{42c}'), ('\u{44d}', '\u{42d}'), ('\u{44e}', '\u{42e}'), ('\u{44f}', '\u{42f}'),
        ('\u{450}', '\u{400}'), ('\u{451}', '\u{401}'), ('\u{452}', '\u{402}'), ('\u{453}',
        '\u{403}'), ('\u{454}', '\u{404}'), ('\u{455}', '\u{405}'), ('\u{456}', '\u{406}'),
        ('\u{457}', '\u{407}'), ('\u{458}', '\u{408}'), ('\u{459}', '\u{409}'), ('\u{45a}',
        '\u{40a}'), ('\u{45b}', '\u{40b}'), ('\u{45c}', '\u{40c}'), ('\u{45d}', '\u{40d}'),
        ('\u{45e}', '\u{40e}'), ('\u{45f}', '\u{40f}'), ('\u{461}', '\u{460}'), ('\u{463}',
        '\u{462}'), ('\u{465}', '\u{464}'), ('\u{467}', '\u{466}'), ('\u{469}', '\u{468}'),
        ('\u{46b}', '\u{46a}'), ('\u{46d}', '\u{46c}'), ('\u{46f}', '\u{46e}'), ('\u{471}',
        '\u{470}'), ('\u{473}', '\u{472}'), ('\u{475}', '\u{474}'), ('\u{477}', '\u{476}'),
        ('\u{479}', '\u{478}'), ('\u{47b}', '\u{47a}'), ('\u{47d}', '\u{47c}'), ('\u{47f}',
        '\u{47e}'), ('\u{481}', '\u{480}'), ('\u{48b}', '\u{48a}'), ('\u{48d}', '\u{48c}'),
        ('\u{48f}', '\u{48e}'), ('\u{491}', '\u{490}'), ('\u{493}', '\u{492}'), ('\u{495}',
        '\u{494}'), ('\u{497}', '\u{496}'), ('\u{499}', '\u{498}'), ('\u{49b}', '\u{49a}'),
        ('\u{49d}', '\u{49c}'), ('\u{49f}', '\u{49e}'), ('\u{4a1}', '\u{4a0}'), ('\u{4a3}',
        '\u{4a2}'), ('\u{4a5}', '\u{4a4}'), ('\u{4a7}', '\u{4a6}'), ('\u{4a9}', '\u{4a8}'),
        ('\u{4ab}', '\u{4aa}'), ('\u{4ad}', '\u{4ac}'), ('\u{4af}', '\u{4ae}'), ('\u{4b1}',
        '\u{4b0}'), ('\u{4b3}', '\u{4b2}'), ('\u{4b5}', '\u{4b4}'), ('\u{4b7}', '\u{4b6}'),
        ('\u{4b9}', '\u{4b8}'), ('\u{4bb}', '\u{4ba}'), ('\u{4bd}', '\u{4bc}'), ('\u{4bf}',
        '\u{4be}'), ('\u{4c2}', '\u{4c1}'), ('\u{4c4}', '\u{4c3}'), ('\u{4c6}', '\u{4c5}'),
        ('\u{4c8}', '\u{4c7}'), ('\u{4ca}', '\u{4c9}'), ('\u{4cc}', '\u{4cb}'), ('\u{4ce}',
        '\u{4cd}'), ('\u{4cf}', '\u{4c0}'), ('\u{4d1}', '\u{4d0}'), ('\u{4d3}', '\u{4d2}'),
        ('\u{4d5}', '\u{4d4}'), ('\u{4d7}', '\u{4d6}'), ('\u{4d9}', '\u{4d8}'), ('\u{4db}',
        '\u{4da}'), ('\u{4dd}', '\u{4dc}'), ('\u{4df}', '\u{4de}'), ('\u{4e1}', '\u{4e0}'),
        ('\u{4e3}', '\u{4e2}'), ('\u{4e5}', '\u{4e4}'), ('\u{4e7}', '\u{4e6}'), ('\u{4e9}',
        '\u{4e8}'), ('\u{4eb}', '\u{4ea}'), ('\u{4ed}', '\u{4ec}'), ('\u{4ef}', '\u{4ee}'),
        ('\u{4f1}', '\u{4f0}'), ('\u{4f3}', '\u{4f2}'), ('\u{4f5}', '\u{4f4}'), ('\u{4f7}',
        '\u{4f6}'), ('\u{4f9}', '\u{4f8}'), ('\u{4fb}', '\u{4fa}'), ('\u{4fd}', '\u{4fc}'),
        ('\u{4ff}', '\u{4fe}'), ('\u{501}', '\u{500}'), ('\u{503}', '\u{502}'), ('\u{505}',
        '\u{504}'), ('\u{507}', '\u{506}'), ('\u{509}', '\u{508}'), ('\u{50b}', '\u{50a}'),
        ('\u{50d}', '\u{50c}'), ('\u{50f}', '\u{50e}'), ('\u{511}', '\u{510}'), ('\u{513}',
        '\u{512}'), ('\u{515}', '\u{514}'), ('\u{517}', '\u{516}'), ('\u{519}', '\u{518}'),
        ('\u{51b}', '\u{51a}'), ('\u{51d}', '\u{51c}'), ('\u{51f}', '\u{51e}'), ('\u{521}',
        '\u{520}'), ('\u{523}', '\u{522}'), ('\u{525}', '\u{524}'), ('\u{527}', '\u{526}'),
        ('\u{529}', '\u{528}'), ('\u{52b}', '\u{52a}'), ('\u{52d}', '\u{52c}'), ('\u{52f}',
        '\u{52e}'), ('\u{561}', '\u{531}'), ('\u{562}', '\u{532}'), ('\u{563}', '\u{533}'),
        ('\u{564}', '\u{534}'), ('\u{565}', '\u{535}'), ('\u{566}', '\u{536}'), ('\u{567}',
        '\u{537}'), ('\u{568}', '\u{538}'), ('\u{569}', '\u{539}'), ('\u{56a}', '\u{53a}'),
        ('\u{56b}', '\u{53b}'), ('\u{56c}', '\u{53c}'), ('\u{56d}', '\u{53d}'), ('\u{56e}',
        '\u{53e}'), ('\u{56f}', '\u{53f}'), ('\u{570}', '\u{540}'), ('\u{571}', '\u{541}'),
        ('\u{572}', '\u{542}'), ('\u{573}', '\u{543}'), ('\u{574}', '\u{544}'), ('\u{575}',
        '\u{545}'), ('\u{576}', '\u{546}'), ('\u{577}', '\u{547}'), ('\u{578}', '\u{548}'),
        ('\u{579}', '\u{549}'), ('\u{57a}', '\u{54a}'), ('\u{57b}', '\u{54b}'), ('\u{57c}',
        '\u{54c}'), ('\u{57d}', '\u{54d}'), ('\u{57e}', '\u{54e}'), ('\u{57f}', '\u{54f}'),
        ('\u{580}', '\u{550}'), ('\u{581}', '\u{551}'), ('\u{582}', '\u{552}'), ('\u{583}',
        '\u{553}'), ('\u{584}', '\u{554}'), ('\u{585}', '\u{555}'), ('\u{586}', '\u{556}'),
        ('\u{1d79}', '\u{a77d}'), ('\u{1d7d}', '\u{2c63}'), ('\u{1e01}', '\u{1e00}'), ('\u{1e03}',
        '\u{1e02}'), ('\u{1e05}', '\u{1e04}'), ('\u{1e07}', '\u{1e06}'), ('\u{1e09}', '\u{1e08}'),
        ('\u{1e0b}', '\u{1e0a}'), ('\u{1e0d}', '\u{1e0c}'), ('\u{1e0f}', '\u{1e0e}'), ('\u{1e11}',
        '\u{1e10}'), ('\u{1e13}', '\u{1e12}'), ('\u{1e15}', '\u{1e14}'), ('\u{1e17}', '\u{1e16}'),
        ('\u{1e19}', '\u{1e18}'), ('\u{1e1b}', '\u{1e1a}'), ('\u{1e1d}', '\u{1e1c}'), ('\u{1e1f}',
        '\u{1e1e}'), ('\u{1e21}', '\u{1e20}'), ('\u{1e23}', '\u{1e22}'), ('\u{1e25}', '\u{1e24}'),
        ('\u{1e27}', '\u{1e26}'), ('\u{1e29}', '\u{1e28}'), ('\u{1e2b}', '\u{1e2a}'), ('\u{1e2d}',
        '\u{1e2c}'), ('\u{1e2f}', '\u{1e2e}'), ('\u{1e31}', '\u{1e30}'), ('\u{1e33}', '\u{1e32}'),
        ('\u{1e35}', '\u{1e34}'), ('\u{1e37}', '\u{1e36}'), ('\u{1e39}', '\u{1e38}'), ('\u{1e3b}',
        '\u{1e3a}'), ('\u{1e3d}', '\u{1e3c}'), ('\u{1e3f}', '\u{1e3e}'), ('\u{1e41}', '\u{1e40}'),
        ('\u{1e43}', '\u{1e42}'), ('\u{1e45}', '\u{1e44}'), ('\u{1e47}', '\u{1e46}'), ('\u{1e49}',
        '\u{1e48}'), ('\u{1e4b}', '\u{1e4a}'), ('\u{1e4d}', '\u{1e4c}'), ('\u{1e4f}', '\u{1e4e}'),
        ('\u{1e51}', '\u{1e50}'), ('\u{1e53}', '\u{1e52}'), ('\u{1e55}', '\u{1e54}'), ('\u{1e57}',
        '\u{1e56}'), ('\u{1e59}', '\u{1e58}'), ('\u{1e5b}', '\u{1e5a}'), ('\u{1e5d}', '\u{1e5c}'),
        ('\u{1e5f}', '\u{1e5e}'), ('\u{1e61}', '\u{1e60}'), ('\u{1e63}', '\u{1e62}'), ('\u{1e65}',
        '\u{1e64}'), ('\u{1e67}', '\u{1e66}'), ('\u{1e69}', '\u{1e68}'), ('\u{1e6b}', '\u{1e6a}'),
        ('\u{1e6d}', '\u{1e6c}'), ('\u{1e6f}', '\u{1e6e}'), ('\u{1e71}', '\u{1e70}'), ('\u{1e73}',
        '\u{1e72}'), ('\u{1e75}', '\u{1e74}'), ('\u{1e77}', '\u{1e76}'), ('\u{1e79}', '\u{1e78}'),
        ('\u{1e7b}', '\u{1e7a}'), ('\u{1e7d}', '\u{1e7c}'), ('\u{1e7f}', '\u{1e7e}'), ('\u{1e81}',
        '\u{1e80}'), ('\u{1e83}', '\u{1e82}'), ('\u{1e85}', '\u{1e84}'), ('\u{1e87}', '\u{1e86}'),
        ('\u{1e89}', '\u{1e88}'), ('\u{1e8b}', '\u{1e8a}'), ('\u{1e8d}', '\u{1e8c}'), ('\u{1e8f}',
        '\u{1e8e}'), ('\u{1e91}', '\u{1e90}'), ('\u{1e93}', '\u{1e92}'), ('\u{1e95}', '\u{1e94}'),
        ('\u{1e9b}', '\u{1e60}'), ('\u{1ea1}', '\u{1ea0}'), ('\u{1ea3}', '\u{1ea2}'), ('\u{1ea5}',
        '\u{1ea4}'), ('\u{1ea7}', '\u{1ea6}'), ('\u{1ea9}', '\u{1ea8}'), ('\u{1eab}', '\u{1eaa}'),
        ('\u{1ead}', '\u{1eac}'), ('\u{1eaf}', '\u{1eae}'), ('\u{1eb1}', '\u{1eb0}'), ('\u{1eb3}',
        '\u{1eb2}'), ('\u{1eb5}', '\u{1eb4}'), ('\u{1eb7}', '\u{1eb6}'), ('\u{1eb9}', '\u{1eb8}'),
        ('\u{1ebb}', '\u{1eba}'), ('\u{1ebd}', '\u{1ebc}'), ('\u{1ebf}', '\u{1ebe}'), ('\u{1ec1}',
        '\u{1ec0}'), ('\u{1ec3}', '\u{1ec2}'), ('\u{1ec5}', '\u{1ec4}'), ('\u{1ec7}', '\u{1ec6}'),
        ('\u{1ec9}', '\u{1ec8}'), ('\u{1ecb}', '\u{1eca}'), ('\u{1ecd}', '\u{1ecc}'), ('\u{1ecf}',
        '\u{1ece}'), ('\u{1ed1}', '\u{1ed0}'), ('\u{1ed3}', '\u{1ed2}'), ('\u{1ed5}', '\u{1ed4}'),
        ('\u{1ed7}', '\u{1ed6}'), ('\u{1ed9}', '\u{1ed8}'), ('\u{1edb}', '\u{1eda}'), ('\u{1edd}',
        '\u{1edc}'), ('\u{1edf}', '\u{1ede}'), ('\u{1ee1}', '\u{1ee0}'), ('\u{1ee3}', '\u{1ee2}'),
        ('\u{1ee5}', '\u{1ee4}'), ('\u{1ee7}', '\u{1ee6}'), ('\u{1ee9}', '\u{1ee8}'), ('\u{1eeb}',
        '\u{1eea}'), ('\u{1eed}', '\u{1eec}'), ('\u{1eef}', '\u{1eee}'), ('\u{1ef1}', '\u{1ef0}'),
        ('\u{1ef3}', '\u{1ef2}'), ('\u{1ef5}', '\u{1ef4}'), ('\u{1ef7}', '\u{1ef6}'), ('\u{1ef9}',
        '\u{1ef8}'), ('\u{1efb}', '\u{1efa}'), ('\u{1efd}', '\u{1efc}'), ('\u{1eff}', '\u{1efe}'),
        ('\u{1f00}', '\u{1f08}'), ('\u{1f01}', '\u{1f09}'), ('\u{1f02}', '\u{1f0a}'), ('\u{1f03}',
        '\u{1f0b}'), ('\u{1f04}', '\u{1f0c}'), ('\u{1f05}', '\u{1f0d}'), ('\u{1f06}', '\u{1f0e}'),
        ('\u{1f07}', '\u{1f0f}'), ('\u{1f10}', '\u{1f18}'), ('\u{1f11}', '\u{1f19}'), ('\u{1f12}',
        '\u{1f1a}'), ('\u{1f13}', '\u{1f1b}'), ('\u{1f14}', '\u{1f1c}'), ('\u{1f15}', '\u{1f1d}'),
        ('\u{1f20}', '\u{1f28}'), ('\u{1f21}', '\u{1f29}'), ('\u{1f22}', '\u{1f2a}'), ('\u{1f23}',
        '\u{1f2b}'), ('\u{1f24}', '\u{1f2c}'), ('\u{1f25}', '\u{1f2d}'), ('\u{1f26}', '\u{1f2e}'),
        ('\u{1f27}', '\u{1f2f}'), ('\u{1f30}', '\u{1f38}'), ('\u{1f31}', '\u{1f39}'), ('\u{1f32}',
        '\u{1f3a}'), ('\u{1f33}', '\u{1f3b}'), ('\u{1f34}', '\u{1f3c}'), ('\u{1f35}', '\u{1f3d}'),
        ('\u{1f36}', '\u{1f3e}'), ('\u{1f37}', '\u{1f3f}'), ('\u{1f40}', '\u{1f48}'), ('\u{1f41}',
        '\u{1f49}'), ('\u{1f42}', '\u{1f4a}'), ('\u{1f43}', '\u{1f4b}'), ('\u{1f44}', '\u{1f4c}'),
        ('\u{1f45}', '\u{1f4d}'), ('\u{1f51}', '\u{1f59}'), ('\u{1f53}', '\u{1f5b}'), ('\u{1f55}',
        '\u{1f5d}'), ('\u{1f57}', '\u{1f5f}'), ('\u{1f60}', '\u{1f68}'), ('\u{1f61}', '\u{1f69}'),
        ('\u{1f62}', '\u{1f6a}'), ('\u{1f63}', '\u{1f6b}'), ('\u{1f64}', '\u{1f6c}'), ('\u{1f65}',
        '\u{1f6d}'), ('\u{1f66}', '\u{1f6e}'), ('\u{1f67}', '\u{1f6f}'), ('\u{1f70}', '\u{1fba}'),
        ('\u{1f71}', '\u{1fbb}'), ('\u{1f72}', '\u{1fc8}'), ('\u{1f73}', '\u{1fc9}'), ('\u{1f74}',
        '\u{1fca}'), ('\u{1f75}', '\u{1fcb}'), ('\u{1f76}', '\u{1fda}'), ('\u{1f77}', '\u{1fdb}'),
        ('\u{1f78}', '\u{1ff8}'), ('\u{1f79}', '\u{1ff9}'), ('\u{1f7a}', '\u{1fea}'), ('\u{1f7b}',
        '\u{1feb}'), ('\u{1f7c}', '\u{1ffa}'), ('\u{1f7d}', '\u{1ffb}'), ('\u{1f80}', '\u{1f88}'),
        ('\u{1f81}', '\u{1f89}'), ('\u{1f82}', '\u{1f8a}'), ('\u{1f83}', '\u{1f8b}'), ('\u{1f84}',
        '\u{1f8c}'), ('\u{1f85}', '\u{1f8d}'), ('\u{1f86}', '\u{1f8e}'), ('\u{1f87}', '\u{1f8f}'),
        ('\u{1f90}', '\u{1f98}'), ('\u{1f91}', '\u{1f99}'), ('\u{1f92}', '\u{1f9a}'), ('\u{1f93}',
        '\u{1f9b}'), ('\u{1f94}', '\u{1f9c}'), ('\u{1f95}', '\u{1f9d}'), ('\u{1f96}', '\u{1f9e}'),
        ('\u{1f97}', '\u{1f9f}'), ('\u{1fa0}', '\u{1fa8}'), ('\u{1fa1}', '\u{1fa9}'), ('\u{1fa2}',
        '\u{1faa}'), ('\u{1fa3}', '\u{1fab}'), ('\u{1fa4}', '\u{1fac}'), ('\u{1fa5}', '\u{1fad}'),
        ('\u{1fa6}', '\u{1fae}'), ('\u{1fa7}', '\u{1faf}'), ('\u{1fb0}', '\u{1fb8}'), ('\u{1fb1}',
        '\u{1fb9}'), ('\u{1fb3}', '\u{1fbc}'), ('\u{1fbe}', '\u{399}'), ('\u{1fc3}', '\u{1fcc}'),
        ('\u{1fd0}', '\u{1fd8}'), ('\u{1fd1}', '\u{1fd9}'), ('\u{1fe0}', '\u{1fe8}'), ('\u{1fe1}',
        '\u{1fe9}'), ('\u{1fe5}', '\u{1fec}'), ('\u{1ff3}', '\u{1ffc}'), ('\u{214e}', '\u{2132}'),
        ('\u{2184}', '\u{2183}'), ('\u{2c30}', '\u{2c00}'), ('\u{2c31}', '\u{2c01}'), ('\u{2c32}',
        '\u{2c02}'), ('\u{2c33}', '\u{2c03}'), ('\u{2c34}', '\u{2c04}'), ('\u{2c35}', '\u{2c05}'),
        ('\u{2c36}', '\u{2c06}'), ('\u{2c37}', '\u{2c07}'), ('\u{2c38}', '\u{2c08}'), ('\u{2c39}',
        '\u{2c09}'), ('\u{2c3a}', '\u{2c0a}'), ('\u{2c3b}', '\u{2c0b}'), ('\u{2c3c}', '\u{2c0c}'),
        ('\u{2c3d}', '\u{2c0d}'), ('\u{2c3e}', '\u{2c0e}'), ('\u{2c3f}', '\u{2c0f}'), ('\u{2c40}',
        '\u{2c10}'), ('\u{2c41}', '\u{2c11}'), ('\u{2c42}', '\u{2c12}'), ('\u{2c43}', '\u{2c13}'),
        ('\u{2c44}', '\u{2c14}'), ('\u{2c45}', '\u{2c15}'), ('\u{2c46}', '\u{2c16}'), ('\u{2c47}',
        '\u{2c17}'), ('\u{2c48}', '\u{2c18}'), ('\u{2c49}', '\u{2c19}'), ('\u{2c4a}', '\u{2c1a}'),
        ('\u{2c4b}', '\u{2c1b}'), ('\u{2c4c}', '\u{2c1c}'), ('\u{2c4d}', '\u{2c1d}'), ('\u{2c4e}',
        '\u{2c1e}'), ('\u{2c4f}', '\u{2c1f}'), ('\u{2c50}', '\u{2c20}'), ('\u{2c51}', '\u{2c21}'),
        ('\u{2c52}', '\u{2c22}'), ('\u{2c53}', '\u{2c23}'), ('\u{2c54}', '\u{2c24}'), ('\u{2c55}',
        '\u{2c25}'), ('\u{2c56}', '\u{2c26}'), ('\u{2c57}', '\u{2c27}'), ('\u{2c58}', '\u{2c28}'),
        ('\u{2c59}', '\u{2c29}'), ('\u{2c5a}', '\u{2c2a}'), ('\u{2c5b}', '\u{2c2b}'), ('\u{2c5c}',
        '\u{2c2c}'), ('\u{2c5d}', '\u{2c2d}'), ('\u{2c5e}', '\u{2c2e}'), ('\u{2c61}', '\u{2c60}'),
        ('\u{2c65}', '\u{23a}'), ('\u{2c66}', '\u{23e}'), ('\u{2c68}', '\u{2c67}'), ('\u{2c6a}',
        '\u{2c69}'), ('\u{2c6c}', '\u{2c6b}'), ('\u{2c73}', '\u{2c72}'), ('\u{2c76}', '\u{2c75}'),
        ('\u{2c81}', '\u{2c80}'), ('\u{2c83}', '\u{2c82}'), ('\u{2c85}', '\u{2c84}'), ('\u{2c87}',
        '\u{2c86}'), ('\u{2c89}', '\u{2c88}'), ('\u{2c8b}', '\u{2c8a}'), ('\u{2c8d}', '\u{2c8c}'),
        ('\u{2c8f}', '\u{2c8e}'), ('\u{2c91}', '\u{2c90}'), ('\u{2c93}', '\u{2c92}'), ('\u{2c95}',
        '\u{2c94}'), ('\u{2c97}', '\u{2c96}'), ('\u{2c99}', '\u{2c98}'), ('\u{2c9b}', '\u{2c9a}'),
        ('\u{2c9d}', '\u{2c9c}'), ('\u{2c9f}', '\u{2c9e}'), ('\u{2ca1}', '\u{2ca0}'), ('\u{2ca3}',
        '\u{2ca2}'), ('\u{2ca5}', '\u{2ca4}'), ('\u{2ca7}', '\u{2ca6}'), ('\u{2ca9}', '\u{2ca8}'),
        ('\u{2cab}', '\u{2caa}'), ('\u{2cad}', '\u{2cac}'), ('\u{2caf}', '\u{2cae}'), ('\u{2cb1}',
        '\u{2cb0}'), ('\u{2cb3}', '\u{2cb2}'), ('\u{2cb5}', '\u{2cb4}'), ('\u{2cb7}', '\u{2cb6}'),
        ('\u{2cb9}', '\u{2cb8}'), ('\u{2cbb}', '\u{2cba}'), ('\u{2cbd}', '\u{2cbc}'), ('\u{2cbf}',
        '\u{2cbe}'), ('\u{2cc1}', '\u{2cc0}'), ('\u{2cc3}', '\u{2cc2}'), ('\u{2cc5}', '\u{2cc4}'),
        ('\u{2cc7}', '\u{2cc6}'), ('\u{2cc9}', '\u{2cc8}'), ('\u{2ccb}', '\u{2cca}'), ('\u{2ccd}',
        '\u{2ccc}'), ('\u{2ccf}', '\u{2cce}'), ('\u{2cd1}', '\u{2cd0}'), ('\u{2cd3}', '\u{2cd2}'),
        ('\u{2cd5}', '\u{2cd4}'), ('\u{2cd7}', '\u{2cd6}'), ('\u{2cd9}', '\u{2cd8}'), ('\u{2cdb}',
        '\u{2cda}'), ('\u{2cdd}', '\u{2cdc}'), ('\u{2cdf}', '\u{2cde}'), ('\u{2ce1}', '\u{2ce0}'),
        ('\u{2ce3}', '\u{2ce2}'), ('\u{2cec}', '\u{2ceb}'), ('\u{2cee}', '\u{2ced}'), ('\u{2cf3}',
        '\u{2cf2}'), ('\u{2d00}', '\u{10a0}'), ('\u{2d01}', '\u{10a1}'), ('\u{2d02}', '\u{10a2}'),
        ('\u{2d03}', '\u{10a3}'), ('\u{2d04}', '\u{10a4}'), ('\u{2d05}', '\u{10a5}'), ('\u{2d06}',
        '\u{10a6}'), ('\u{2d07}', '\u{10a7}'), ('\u{2d08}', '\u{10a8}'), ('\u{2d09}', '\u{10a9}'),
        ('\u{2d0a}', '\u{10aa}'), ('\u{2d0b}', '\u{10ab}'), ('\u{2d0c}', '\u{10ac}'), ('\u{2d0d}',
        '\u{10ad}'), ('\u{2d0e}', '\u{10ae}'), ('\u{2d0f}', '\u{10af}'), ('\u{2d10}', '\u{10b0}'),
        ('\u{2d11}', '\u{10b1}'), ('\u{2d12}', '\u{10b2}'), ('\u{2d13}', '\u{10b3}'), ('\u{2d14}',
        '\u{10b4}'), ('\u{2d15}', '\u{10b5}'), ('\u{2d16}', '\u{10b6}'), ('\u{2d17}', '\u{10b7}'),
        ('\u{2d18}', '\u{10b8}'), ('\u{2d19}', '\u{10b9}'), ('\u{2d1a}', '\u{10ba}'), ('\u{2d1b}',
        '\u{10bb}'), ('\u{2d1c}', '\u{10bc}'), ('\u{2d1d}', '\u{10bd}'), ('\u{2d1e}', '\u{10be}'),
        ('\u{2d1f}', '\u{10bf}'), ('\u{2d20}', '\u{10c0}'), ('\u{2d21}', '\u{10c1}'), ('\u{2d22}',
        '\u{10c2}'), ('\u{2d23}', '\u{10c3}'), ('\u{2d24}', '\u{10c4}'), ('\u{2d25}', '\u{10c5}'),
        ('\u{2d27}', '\u{10c7}'), ('\u{2d2d}', '\u{10cd}'), ('\u{a641}', '\u{a640}'), ('\u{a643}',
        '\u{a642}'), ('\u{a645}', '\u{a644}'), ('\u{a647}', '\u{a646}'), ('\u{a649}', '\u{a648}'),
        ('\u{a64b}', '\u{a64a}'), ('\u{a64d}', '\u{a64c}'), ('\u{a64f}', '\u{a64e}'), ('\u{a651}',
        '\u{a650}'), ('\u{a653}', '\u{a652}'), ('\u{a655}', '\u{a654}'), ('\u{a657}', '\u{a656}'),
        ('\u{a659}', '\u{a658}'), ('\u{a65b}', '\u{a65a}'), ('\u{a65d}', '\u{a65c}'), ('\u{a65f}',
        '\u{a65e}'), ('\u{a661}', '\u{a660}'), ('\u{a663}', '\u{a662}'), ('\u{a665}', '\u{a664}'),
        ('\u{a667}', '\u{a666}'), ('\u{a669}', '\u{a668}'), ('\u{a66b}', '\u{a66a}'), ('\u{a66d}',
        '\u{a66c}'), ('\u{a681}', '\u{a680}'), ('\u{a683}', '\u{a682}'), ('\u{a685}', '\u{a684}'),
        ('\u{a687}', '\u{a686}'), ('\u{a689}', '\u{a688}'), ('\u{a68b}', '\u{a68a}'), ('\u{a68d}',
        '\u{a68c}'), ('\u{a68f}', '\u{a68e}'), ('\u{a691}', '\u{a690}'), ('\u{a693}', '\u{a692}'),
        ('\u{a695}', '\u{a694}'), ('\u{a697}', '\u{a696}'), ('\u{a699}', '\u{a698}'), ('\u{a69b}',
        '\u{a69a}'), ('\u{a723}', '\u{a722}'), ('\u{a725}', '\u{a724}'), ('\u{a727}', '\u{a726}'),
        ('\u{a729}', '\u{a728}'), ('\u{a72b}', '\u{a72a}'), ('\u{a72d}', '\u{a72c}'), ('\u{a72f}',
        '\u{a72e}'), ('\u{a733}', '\u{a732}'), ('\u{a735}', '\u{a734}'), ('\u{a737}', '\u{a736}'),
        ('\u{a739}', '\u{a738}'), ('\u{a73b}', '\u{a73a}'), ('\u{a73d}', '\u{a73c}'), ('\u{a73f}',
        '\u{a73e}'), ('\u{a741}', '\u{a740}'), ('\u{a743}', '\u{a742}'), ('\u{a745}', '\u{a744}'),
        ('\u{a747}', '\u{a746}'), ('\u{a749}', '\u{a748}'), ('\u{a74b}', '\u{a74a}'), ('\u{a74d}',
        '\u{a74c}'), ('\u{a74f}', '\u{a74e}'), ('\u{a751}', '\u{a750}'), ('\u{a753}', '\u{a752}'),
        ('\u{a755}', '\u{a754}'), ('\u{a757}', '\u{a756}'), ('\u{a759}', '\u{a758}'), ('\u{a75b}',
        '\u{a75a}'), ('\u{a75d}', '\u{a75c}'), ('\u{a75f}', '\u{a75e}'), ('\u{a761}', '\u{a760}'),
        ('\u{a763}', '\u{a762}'), ('\u{a765}', '\u{a764}'), ('\u{a767}', '\u{a766}'), ('\u{a769}',
        '\u{a768}'), ('\u{a76b}', '\u{a76a}'), ('\u{a76d}', '\u{a76c}'), ('\u{a76f}', '\u{a76e}'),
        ('\u{a77a}', '\u{a779}'), ('\u{a77c}', '\u{a77b}'), ('\u{a77f}', '\u{a77e}'), ('\u{a781}',
        '\u{a780}'), ('\u{a783}', '\u{a782}'), ('\u{a785}', '\u{a784}'), ('\u{a787}', '\u{a786}'),
        ('\u{a78c}', '\u{a78b}'), ('\u{a791}', '\u{a790}'), ('\u{a793}', '\u{a792}'), ('\u{a797}',
        '\u{a796}'), ('\u{a799}', '\u{a798}'), ('\u{a79b}', '\u{a79a}'), ('\u{a79d}', '\u{a79c}'),
        ('\u{a79f}', '\u{a79e}'), ('\u{a7a1}', '\u{a7a0}'), ('\u{a7a3}', '\u{a7a2}'), ('\u{a7a5}',
        '\u{a7a4}'), ('\u{a7a7}', '\u{a7a6}'), ('\u{a7a9}', '\u{a7a8}'), ('\u{ff41}', '\u{ff21}'),
        ('\u{ff42}', '\u{ff22}'), ('\u{ff43}', '\u{ff23}'), ('\u{ff44}', '\u{ff24}'), ('\u{ff45}',
        '\u{ff25}'), ('\u{ff46}', '\u{ff26}'), ('\u{ff47}', '\u{ff27}'), ('\u{ff48}', '\u{ff28}'),
        ('\u{ff49}', '\u{ff29}'), ('\u{ff4a}', '\u{ff2a}'), ('\u{ff4b}', '\u{ff2b}'), ('\u{ff4c}',
        '\u{ff2c}'), ('\u{ff4d}', '\u{ff2d}'), ('\u{ff4e}', '\u{ff2e}'), ('\u{ff4f}', '\u{ff2f}'),
        ('\u{ff50}', '\u{ff30}'), ('\u{ff51}', '\u{ff31}'), ('\u{ff52}', '\u{ff32}'), ('\u{ff53}',
        '\u{ff33}'), ('\u{ff54}', '\u{ff34}'), ('\u{ff55}', '\u{ff35}'), ('\u{ff56}', '\u{ff36}'),
        ('\u{ff57}', '\u{ff37}'), ('\u{ff58}', '\u{ff38}'), ('\u{ff59}', '\u{ff39}'), ('\u{ff5a}',
        '\u{ff3a}'), ('\u{10428}', '\u{10400}'), ('\u{10429}', '\u{10401}'), ('\u{1042a}',
        '\u{10402}'), ('\u{1042b}', '\u{10403}'), ('\u{1042c}', '\u{10404}'), ('\u{1042d}',
        '\u{10405}'), ('\u{1042e}', '\u{10406}'), ('\u{1042f}', '\u{10407}'), ('\u{10430}',
        '\u{10408}'), ('\u{10431}', '\u{10409}'), ('\u{10432}', '\u{1040a}'), ('\u{10433}',
        '\u{1040b}'), ('\u{10434}', '\u{1040c}'), ('\u{10435}', '\u{1040d}'), ('\u{10436}',
        '\u{1040e}'), ('\u{10437}', '\u{1040f}'), ('\u{10438}', '\u{10410}'), ('\u{10439}',
        '\u{10411}'), ('\u{1043a}', '\u{10412}'), ('\u{1043b}', '\u{10413}'), ('\u{1043c}',
        '\u{10414}'), ('\u{1043d}', '\u{10415}'), ('\u{1043e}', '\u{10416}'), ('\u{1043f}',
        '\u{10417}'), ('\u{10440}', '\u{10418}'), ('\u{10441}', '\u{10419}'), ('\u{10442}',
        '\u{1041a}'), ('\u{10443}', '\u{1041b}'), ('\u{10444}', '\u{1041c}'), ('\u{10445}',
        '\u{1041d}'), ('\u{10446}', '\u{1041e}'), ('\u{10447}', '\u{1041f}'), ('\u{10448}',
        '\u{10420}'), ('\u{10449}', '\u{10421}'), ('\u{1044a}', '\u{10422}'), ('\u{1044b}',
        '\u{10423}'), ('\u{1044c}', '\u{10424}'), ('\u{1044d}', '\u{10425}'), ('\u{1044e}',
        '\u{10426}'), ('\u{1044f}', '\u{10427}'), ('\u{118c0}', '\u{118a0}'), ('\u{118c1}',
        '\u{118a1}'), ('\u{118c2}', '\u{118a2}'), ('\u{118c3}', '\u{118a3}'), ('\u{118c4}',
        '\u{118a4}'), ('\u{118c5}', '\u{118a5}'), ('\u{118c6}', '\u{118a6}'), ('\u{118c7}',
        '\u{118a7}'), ('\u{118c8}', '\u{118a8}'), ('\u{118c9}', '\u{118a9}'), ('\u{118ca}',
        '\u{118aa}'), ('\u{118cb}', '\u{118ab}'), ('\u{118cc}', '\u{118ac}'), ('\u{118cd}',
        '\u{118ad}'), ('\u{118ce}', '\u{118ae}'), ('\u{118cf}', '\u{118af}'), ('\u{118d0}',
        '\u{118b0}'), ('\u{118d1}', '\u{118b1}'), ('\u{118d2}', '\u{118b2}'), ('\u{118d3}',
        '\u{118b3}'), ('\u{118d4}', '\u{118b4}'), ('\u{118d5}', '\u{118b5}'), ('\u{118d6}',
        '\u{118b6}'), ('\u{118d7}', '\u{118b7}'), ('\u{118d8}', '\u{118b8}'), ('\u{118d9}',
        '\u{118b9}'), ('\u{118da}', '\u{118ba}'), ('\u{118db}', '\u{118bb}'), ('\u{118dc}',
        '\u{118bc}'), ('\u{118dd}', '\u{118bd}'), ('\u{118de}', '\u{118be}'), ('\u{118df}',
        '\u{118bf}')
    ];

}

pub mod charwidth {
    use core::option::Option;
    use core::option::Option::{Some, None};
    use core::slice::SliceExt;
    use core::result::Result::{Ok, Err};

    fn bsearch_range_value_table(c: char, is_cjk: bool, r: &'static [(char, char, u8, u8)]) -> u8 {
        use core::cmp::Ordering::{Equal, Less, Greater};
        match r.binary_search_by(|&(lo, hi, _, _)| {
            if lo <= c && c <= hi { Equal }
            else if hi < c { Less }
            else { Greater }
        }) {
            Ok(idx) => {
                let (_, _, r_ncjk, r_cjk) = r[idx];
                if is_cjk { r_cjk } else { r_ncjk }
            }
            Err(_) => 1
        }
    }

    pub fn width(c: char, is_cjk: bool) -> Option<uint> {
        match c as uint {
            _c @ 0 => Some(0),          // null is zero width
            cu if cu < 0x20 => None,    // control sequences have no width
            cu if cu < 0x7F => Some(1), // ASCII
            cu if cu < 0xA0 => None,    // more control sequences
            _ => Some(bsearch_range_value_table(c, is_cjk, charwidth_table) as uint)
        }
    }

    // character width table. Based on Markus Kuhn's free wcwidth() implementation,
    //     http://www.cl.cam.ac.uk/~mgk25/ucs/wcwidth.c
    static charwidth_table: &'static [(char, char, u8, u8)] = &[
        ('\u{a1}', '\u{a1}', 1, 2), ('\u{a4}', '\u{a4}', 1, 2), ('\u{a7}', '\u{a8}', 1, 2),
        ('\u{aa}', '\u{aa}', 1, 2), ('\u{ae}', '\u{ae}', 1, 2), ('\u{b0}', '\u{b4}', 1, 2),
        ('\u{b6}', '\u{ba}', 1, 2), ('\u{bc}', '\u{bf}', 1, 2), ('\u{c6}', '\u{c6}', 1, 2),
        ('\u{d0}', '\u{d0}', 1, 2), ('\u{d7}', '\u{d8}', 1, 2), ('\u{de}', '\u{e1}', 1, 2),
        ('\u{e6}', '\u{e6}', 1, 2), ('\u{e8}', '\u{ea}', 1, 2), ('\u{ec}', '\u{ed}', 1, 2),
        ('\u{f0}', '\u{f0}', 1, 2), ('\u{f2}', '\u{f3}', 1, 2), ('\u{f7}', '\u{fa}', 1, 2),
        ('\u{fc}', '\u{fc}', 1, 2), ('\u{fe}', '\u{fe}', 1, 2), ('\u{101}', '\u{101}', 1, 2),
        ('\u{111}', '\u{111}', 1, 2), ('\u{113}', '\u{113}', 1, 2), ('\u{11b}', '\u{11b}', 1, 2),
        ('\u{126}', '\u{127}', 1, 2), ('\u{12b}', '\u{12b}', 1, 2), ('\u{131}', '\u{133}', 1, 2),
        ('\u{138}', '\u{138}', 1, 2), ('\u{13f}', '\u{142}', 1, 2), ('\u{144}', '\u{144}', 1, 2),
        ('\u{148}', '\u{14b}', 1, 2), ('\u{14d}', '\u{14d}', 1, 2), ('\u{152}', '\u{153}', 1, 2),
        ('\u{166}', '\u{167}', 1, 2), ('\u{16b}', '\u{16b}', 1, 2), ('\u{1ce}', '\u{1ce}', 1, 2),
        ('\u{1d0}', '\u{1d0}', 1, 2), ('\u{1d2}', '\u{1d2}', 1, 2), ('\u{1d4}', '\u{1d4}', 1, 2),
        ('\u{1d6}', '\u{1d6}', 1, 2), ('\u{1d8}', '\u{1d8}', 1, 2), ('\u{1da}', '\u{1da}', 1, 2),
        ('\u{1dc}', '\u{1dc}', 1, 2), ('\u{251}', '\u{251}', 1, 2), ('\u{261}', '\u{261}', 1, 2),
        ('\u{2c4}', '\u{2c4}', 1, 2), ('\u{2c7}', '\u{2c7}', 1, 2), ('\u{2c9}', '\u{2cb}', 1, 2),
        ('\u{2cd}', '\u{2cd}', 1, 2), ('\u{2d0}', '\u{2d0}', 1, 2), ('\u{2d8}', '\u{2db}', 1, 2),
        ('\u{2dd}', '\u{2dd}', 1, 2), ('\u{2df}', '\u{2df}', 1, 2), ('\u{300}', '\u{36f}', 0, 0),
        ('\u{391}', '\u{3a1}', 1, 2), ('\u{3a3}', '\u{3a9}', 1, 2), ('\u{3b1}', '\u{3c1}', 1, 2),
        ('\u{3c3}', '\u{3c9}', 1, 2), ('\u{401}', '\u{401}', 1, 2), ('\u{410}', '\u{44f}', 1, 2),
        ('\u{451}', '\u{451}', 1, 2), ('\u{483}', '\u{489}', 0, 0), ('\u{591}', '\u{5bd}', 0, 0),
        ('\u{5bf}', '\u{5bf}', 0, 0), ('\u{5c1}', '\u{5c2}', 0, 0), ('\u{5c4}', '\u{5c5}', 0, 0),
        ('\u{5c7}', '\u{5c7}', 0, 0), ('\u{600}', '\u{605}', 0, 0), ('\u{610}', '\u{61a}', 0, 0),
        ('\u{61c}', '\u{61c}', 0, 0), ('\u{64b}', '\u{65f}', 0, 0), ('\u{670}', '\u{670}', 0, 0),
        ('\u{6d6}', '\u{6dd}', 0, 0), ('\u{6df}', '\u{6e4}', 0, 0), ('\u{6e7}', '\u{6e8}', 0, 0),
        ('\u{6ea}', '\u{6ed}', 0, 0), ('\u{70f}', '\u{70f}', 0, 0), ('\u{711}', '\u{711}', 0, 0),
        ('\u{730}', '\u{74a}', 0, 0), ('\u{7a6}', '\u{7b0}', 0, 0), ('\u{7eb}', '\u{7f3}', 0, 0),
        ('\u{816}', '\u{819}', 0, 0), ('\u{81b}', '\u{823}', 0, 0), ('\u{825}', '\u{827}', 0, 0),
        ('\u{829}', '\u{82d}', 0, 0), ('\u{859}', '\u{85b}', 0, 0), ('\u{8e4}', '\u{902}', 0, 0),
        ('\u{93a}', '\u{93a}', 0, 0), ('\u{93c}', '\u{93c}', 0, 0), ('\u{941}', '\u{948}', 0, 0),
        ('\u{94d}', '\u{94d}', 0, 0), ('\u{951}', '\u{957}', 0, 0), ('\u{962}', '\u{963}', 0, 0),
        ('\u{981}', '\u{981}', 0, 0), ('\u{9bc}', '\u{9bc}', 0, 0), ('\u{9c1}', '\u{9c4}', 0, 0),
        ('\u{9cd}', '\u{9cd}', 0, 0), ('\u{9e2}', '\u{9e3}', 0, 0), ('\u{a01}', '\u{a02}', 0, 0),
        ('\u{a3c}', '\u{a3c}', 0, 0), ('\u{a41}', '\u{a42}', 0, 0), ('\u{a47}', '\u{a48}', 0, 0),
        ('\u{a4b}', '\u{a4d}', 0, 0), ('\u{a51}', '\u{a51}', 0, 0), ('\u{a70}', '\u{a71}', 0, 0),
        ('\u{a75}', '\u{a75}', 0, 0), ('\u{a81}', '\u{a82}', 0, 0), ('\u{abc}', '\u{abc}', 0, 0),
        ('\u{ac1}', '\u{ac5}', 0, 0), ('\u{ac7}', '\u{ac8}', 0, 0), ('\u{acd}', '\u{acd}', 0, 0),
        ('\u{ae2}', '\u{ae3}', 0, 0), ('\u{b01}', '\u{b01}', 0, 0), ('\u{b3c}', '\u{b3c}', 0, 0),
        ('\u{b3f}', '\u{b3f}', 0, 0), ('\u{b41}', '\u{b44}', 0, 0), ('\u{b4d}', '\u{b4d}', 0, 0),
        ('\u{b56}', '\u{b56}', 0, 0), ('\u{b62}', '\u{b63}', 0, 0), ('\u{b82}', '\u{b82}', 0, 0),
        ('\u{bc0}', '\u{bc0}', 0, 0), ('\u{bcd}', '\u{bcd}', 0, 0), ('\u{c00}', '\u{c00}', 0, 0),
        ('\u{c3e}', '\u{c40}', 0, 0), ('\u{c46}', '\u{c48}', 0, 0), ('\u{c4a}', '\u{c4d}', 0, 0),
        ('\u{c55}', '\u{c56}', 0, 0), ('\u{c62}', '\u{c63}', 0, 0), ('\u{c81}', '\u{c81}', 0, 0),
        ('\u{cbc}', '\u{cbc}', 0, 0), ('\u{cbf}', '\u{cbf}', 0, 0), ('\u{cc6}', '\u{cc6}', 0, 0),
        ('\u{ccc}', '\u{ccd}', 0, 0), ('\u{ce2}', '\u{ce3}', 0, 0), ('\u{d01}', '\u{d01}', 0, 0),
        ('\u{d41}', '\u{d44}', 0, 0), ('\u{d4d}', '\u{d4d}', 0, 0), ('\u{d62}', '\u{d63}', 0, 0),
        ('\u{dca}', '\u{dca}', 0, 0), ('\u{dd2}', '\u{dd4}', 0, 0), ('\u{dd6}', '\u{dd6}', 0, 0),
        ('\u{e31}', '\u{e31}', 0, 0), ('\u{e34}', '\u{e3a}', 0, 0), ('\u{e47}', '\u{e4e}', 0, 0),
        ('\u{eb1}', '\u{eb1}', 0, 0), ('\u{eb4}', '\u{eb9}', 0, 0), ('\u{ebb}', '\u{ebc}', 0, 0),
        ('\u{ec8}', '\u{ecd}', 0, 0), ('\u{f18}', '\u{f19}', 0, 0), ('\u{f35}', '\u{f35}', 0, 0),
        ('\u{f37}', '\u{f37}', 0, 0), ('\u{f39}', '\u{f39}', 0, 0), ('\u{f71}', '\u{f7e}', 0, 0),
        ('\u{f80}', '\u{f84}', 0, 0), ('\u{f86}', '\u{f87}', 0, 0), ('\u{f8d}', '\u{f97}', 0, 0),
        ('\u{f99}', '\u{fbc}', 0, 0), ('\u{fc6}', '\u{fc6}', 0, 0), ('\u{102d}', '\u{1030}', 0, 0),
        ('\u{1032}', '\u{1037}', 0, 0), ('\u{1039}', '\u{103a}', 0, 0), ('\u{103d}', '\u{103e}', 0,
        0), ('\u{1058}', '\u{1059}', 0, 0), ('\u{105e}', '\u{1060}', 0, 0), ('\u{1071}', '\u{1074}',
        0, 0), ('\u{1082}', '\u{1082}', 0, 0), ('\u{1085}', '\u{1086}', 0, 0), ('\u{108d}',
        '\u{108d}', 0, 0), ('\u{109d}', '\u{109d}', 0, 0), ('\u{1100}', '\u{115f}', 2, 2),
        ('\u{1160}', '\u{11ff}', 0, 0), ('\u{135d}', '\u{135f}', 0, 0), ('\u{1712}', '\u{1714}', 0,
        0), ('\u{1732}', '\u{1734}', 0, 0), ('\u{1752}', '\u{1753}', 0, 0), ('\u{1772}', '\u{1773}',
        0, 0), ('\u{17b4}', '\u{17b5}', 0, 0), ('\u{17b7}', '\u{17bd}', 0, 0), ('\u{17c6}',
        '\u{17c6}', 0, 0), ('\u{17c9}', '\u{17d3}', 0, 0), ('\u{17dd}', '\u{17dd}', 0, 0),
        ('\u{180b}', '\u{180e}', 0, 0), ('\u{18a9}', '\u{18a9}', 0, 0), ('\u{1920}', '\u{1922}', 0,
        0), ('\u{1927}', '\u{1928}', 0, 0), ('\u{1932}', '\u{1932}', 0, 0), ('\u{1939}', '\u{193b}',
        0, 0), ('\u{1a17}', '\u{1a18}', 0, 0), ('\u{1a1b}', '\u{1a1b}', 0, 0), ('\u{1a56}',
        '\u{1a56}', 0, 0), ('\u{1a58}', '\u{1a5e}', 0, 0), ('\u{1a60}', '\u{1a60}', 0, 0),
        ('\u{1a62}', '\u{1a62}', 0, 0), ('\u{1a65}', '\u{1a6c}', 0, 0), ('\u{1a73}', '\u{1a7c}', 0,
        0), ('\u{1a7f}', '\u{1a7f}', 0, 0), ('\u{1ab0}', '\u{1abe}', 0, 0), ('\u{1b00}', '\u{1b03}',
        0, 0), ('\u{1b34}', '\u{1b34}', 0, 0), ('\u{1b36}', '\u{1b3a}', 0, 0), ('\u{1b3c}',
        '\u{1b3c}', 0, 0), ('\u{1b42}', '\u{1b42}', 0, 0), ('\u{1b6b}', '\u{1b73}', 0, 0),
        ('\u{1b80}', '\u{1b81}', 0, 0), ('\u{1ba2}', '\u{1ba5}', 0, 0), ('\u{1ba8}', '\u{1ba9}', 0,
        0), ('\u{1bab}', '\u{1bad}', 0, 0), ('\u{1be6}', '\u{1be6}', 0, 0), ('\u{1be8}', '\u{1be9}',
        0, 0), ('\u{1bed}', '\u{1bed}', 0, 0), ('\u{1bef}', '\u{1bf1}', 0, 0), ('\u{1c2c}',
        '\u{1c33}', 0, 0), ('\u{1c36}', '\u{1c37}', 0, 0), ('\u{1cd0}', '\u{1cd2}', 0, 0),
        ('\u{1cd4}', '\u{1ce0}', 0, 0), ('\u{1ce2}', '\u{1ce8}', 0, 0), ('\u{1ced}', '\u{1ced}', 0,
        0), ('\u{1cf4}', '\u{1cf4}', 0, 0), ('\u{1cf8}', '\u{1cf9}', 0, 0), ('\u{1dc0}', '\u{1df5}',
        0, 0), ('\u{1dfc}', '\u{1dff}', 0, 0), ('\u{200b}', '\u{200f}', 0, 0), ('\u{2010}',
        '\u{2010}', 1, 2), ('\u{2013}', '\u{2016}', 1, 2), ('\u{2018}', '\u{2019}', 1, 2),
        ('\u{201c}', '\u{201d}', 1, 2), ('\u{2020}', '\u{2022}', 1, 2), ('\u{2024}', '\u{2027}', 1,
        2), ('\u{202a}', '\u{202e}', 0, 0), ('\u{2030}', '\u{2030}', 1, 2), ('\u{2032}', '\u{2033}',
        1, 2), ('\u{2035}', '\u{2035}', 1, 2), ('\u{203b}', '\u{203b}', 1, 2), ('\u{203e}',
        '\u{203e}', 1, 2), ('\u{2060}', '\u{2064}', 0, 0), ('\u{2066}', '\u{206f}', 0, 0),
        ('\u{2074}', '\u{2074}', 1, 2), ('\u{207f}', '\u{207f}', 1, 2), ('\u{2081}', '\u{2084}', 1,
        2), ('\u{20ac}', '\u{20ac}', 1, 2), ('\u{20d0}', '\u{20f0}', 0, 0), ('\u{2103}', '\u{2103}',
        1, 2), ('\u{2105}', '\u{2105}', 1, 2), ('\u{2109}', '\u{2109}', 1, 2), ('\u{2113}',
        '\u{2113}', 1, 2), ('\u{2116}', '\u{2116}', 1, 2), ('\u{2121}', '\u{2122}', 1, 2),
        ('\u{2126}', '\u{2126}', 1, 2), ('\u{212b}', '\u{212b}', 1, 2), ('\u{2153}', '\u{2154}', 1,
        2), ('\u{215b}', '\u{215e}', 1, 2), ('\u{2160}', '\u{216b}', 1, 2), ('\u{2170}', '\u{2179}',
        1, 2), ('\u{2189}', '\u{2189}', 1, 2), ('\u{2190}', '\u{2199}', 1, 2), ('\u{21b8}',
        '\u{21b9}', 1, 2), ('\u{21d2}', '\u{21d2}', 1, 2), ('\u{21d4}', '\u{21d4}', 1, 2),
        ('\u{21e7}', '\u{21e7}', 1, 2), ('\u{2200}', '\u{2200}', 1, 2), ('\u{2202}', '\u{2203}', 1,
        2), ('\u{2207}', '\u{2208}', 1, 2), ('\u{220b}', '\u{220b}', 1, 2), ('\u{220f}', '\u{220f}',
        1, 2), ('\u{2211}', '\u{2211}', 1, 2), ('\u{2215}', '\u{2215}', 1, 2), ('\u{221a}',
        '\u{221a}', 1, 2), ('\u{221d}', '\u{2220}', 1, 2), ('\u{2223}', '\u{2223}', 1, 2),
        ('\u{2225}', '\u{2225}', 1, 2), ('\u{2227}', '\u{222c}', 1, 2), ('\u{222e}', '\u{222e}', 1,
        2), ('\u{2234}', '\u{2237}', 1, 2), ('\u{223c}', '\u{223d}', 1, 2), ('\u{2248}', '\u{2248}',
        1, 2), ('\u{224c}', '\u{224c}', 1, 2), ('\u{2252}', '\u{2252}', 1, 2), ('\u{2260}',
        '\u{2261}', 1, 2), ('\u{2264}', '\u{2267}', 1, 2), ('\u{226a}', '\u{226b}', 1, 2),
        ('\u{226e}', '\u{226f}', 1, 2), ('\u{2282}', '\u{2283}', 1, 2), ('\u{2286}', '\u{2287}', 1,
        2), ('\u{2295}', '\u{2295}', 1, 2), ('\u{2299}', '\u{2299}', 1, 2), ('\u{22a5}', '\u{22a5}',
        1, 2), ('\u{22bf}', '\u{22bf}', 1, 2), ('\u{2312}', '\u{2312}', 1, 2), ('\u{2329}',
        '\u{232a}', 2, 2), ('\u{2460}', '\u{24e9}', 1, 2), ('\u{24eb}', '\u{254b}', 1, 2),
        ('\u{2550}', '\u{2573}', 1, 2), ('\u{2580}', '\u{258f}', 1, 2), ('\u{2592}', '\u{2595}', 1,
        2), ('\u{25a0}', '\u{25a1}', 1, 2), ('\u{25a3}', '\u{25a9}', 1, 2), ('\u{25b2}', '\u{25b3}',
        1, 2), ('\u{25b6}', '\u{25b7}', 1, 2), ('\u{25bc}', '\u{25bd}', 1, 2), ('\u{25c0}',
        '\u{25c1}', 1, 2), ('\u{25c6}', '\u{25c8}', 1, 2), ('\u{25cb}', '\u{25cb}', 1, 2),
        ('\u{25ce}', '\u{25d1}', 1, 2), ('\u{25e2}', '\u{25e5}', 1, 2), ('\u{25ef}', '\u{25ef}', 1,
        2), ('\u{2605}', '\u{2606}', 1, 2), ('\u{2609}', '\u{2609}', 1, 2), ('\u{260e}', '\u{260f}',
        1, 2), ('\u{2614}', '\u{2615}', 1, 2), ('\u{261c}', '\u{261c}', 1, 2), ('\u{261e}',
        '\u{261e}', 1, 2), ('\u{2640}', '\u{2640}', 1, 2), ('\u{2642}', '\u{2642}', 1, 2),
        ('\u{2660}', '\u{2661}', 1, 2), ('\u{2663}', '\u{2665}', 1, 2), ('\u{2667}', '\u{266a}', 1,
        2), ('\u{266c}', '\u{266d}', 1, 2), ('\u{266f}', '\u{266f}', 1, 2), ('\u{269e}', '\u{269f}',
        1, 2), ('\u{26be}', '\u{26bf}', 1, 2), ('\u{26c4}', '\u{26cd}', 1, 2), ('\u{26cf}',
        '\u{26e1}', 1, 2), ('\u{26e3}', '\u{26e3}', 1, 2), ('\u{26e8}', '\u{26ff}', 1, 2),
        ('\u{273d}', '\u{273d}', 1, 2), ('\u{2757}', '\u{2757}', 1, 2), ('\u{2776}', '\u{277f}', 1,
        2), ('\u{2b55}', '\u{2b59}', 1, 2), ('\u{2cef}', '\u{2cf1}', 0, 0), ('\u{2d7f}', '\u{2d7f}',
        0, 0), ('\u{2de0}', '\u{2dff}', 0, 0), ('\u{2e80}', '\u{2e99}', 2, 2), ('\u{2e9b}',
        '\u{2ef3}', 2, 2), ('\u{2f00}', '\u{2fd5}', 2, 2), ('\u{2ff0}', '\u{2ffb}', 2, 2),
        ('\u{3000}', '\u{3029}', 2, 2), ('\u{302a}', '\u{302d}', 0, 0), ('\u{302e}', '\u{303e}', 2,
        2), ('\u{3041}', '\u{3096}', 2, 2), ('\u{3099}', '\u{309a}', 0, 0), ('\u{309b}', '\u{30ff}',
        2, 2), ('\u{3105}', '\u{312d}', 2, 2), ('\u{3131}', '\u{318e}', 2, 2), ('\u{3190}',
        '\u{31ba}', 2, 2), ('\u{31c0}', '\u{31e3}', 2, 2), ('\u{31f0}', '\u{321e}', 2, 2),
        ('\u{3220}', '\u{3247}', 2, 2), ('\u{3248}', '\u{324f}', 1, 2), ('\u{3250}', '\u{32fe}', 2,
        2), ('\u{3300}', '\u{4dbf}', 2, 2), ('\u{4e00}', '\u{a48c}', 2, 2), ('\u{a490}', '\u{a4c6}',
        2, 2), ('\u{a66f}', '\u{a672}', 0, 0), ('\u{a674}', '\u{a67d}', 0, 0), ('\u{a69f}',
        '\u{a69f}', 0, 0), ('\u{a6f0}', '\u{a6f1}', 0, 0), ('\u{a802}', '\u{a802}', 0, 0),
        ('\u{a806}', '\u{a806}', 0, 0), ('\u{a80b}', '\u{a80b}', 0, 0), ('\u{a825}', '\u{a826}', 0,
        0), ('\u{a8c4}', '\u{a8c4}', 0, 0), ('\u{a8e0}', '\u{a8f1}', 0, 0), ('\u{a926}', '\u{a92d}',
        0, 0), ('\u{a947}', '\u{a951}', 0, 0), ('\u{a960}', '\u{a97c}', 2, 2), ('\u{a980}',
        '\u{a982}', 0, 0), ('\u{a9b3}', '\u{a9b3}', 0, 0), ('\u{a9b6}', '\u{a9b9}', 0, 0),
        ('\u{a9bc}', '\u{a9bc}', 0, 0), ('\u{a9e5}', '\u{a9e5}', 0, 0), ('\u{aa29}', '\u{aa2e}', 0,
        0), ('\u{aa31}', '\u{aa32}', 0, 0), ('\u{aa35}', '\u{aa36}', 0, 0), ('\u{aa43}', '\u{aa43}',
        0, 0), ('\u{aa4c}', '\u{aa4c}', 0, 0), ('\u{aa7c}', '\u{aa7c}', 0, 0), ('\u{aab0}',
        '\u{aab0}', 0, 0), ('\u{aab2}', '\u{aab4}', 0, 0), ('\u{aab7}', '\u{aab8}', 0, 0),
        ('\u{aabe}', '\u{aabf}', 0, 0), ('\u{aac1}', '\u{aac1}', 0, 0), ('\u{aaec}', '\u{aaed}', 0,
        0), ('\u{aaf6}', '\u{aaf6}', 0, 0), ('\u{abe5}', '\u{abe5}', 0, 0), ('\u{abe8}', '\u{abe8}',
        0, 0), ('\u{abed}', '\u{abed}', 0, 0), ('\u{ac00}', '\u{d7a3}', 2, 2), ('\u{e000}',
        '\u{f8ff}', 1, 2), ('\u{f900}', '\u{faff}', 2, 2), ('\u{fb1e}', '\u{fb1e}', 0, 0),
        ('\u{fe00}', '\u{fe0f}', 0, 0), ('\u{fe10}', '\u{fe19}', 2, 2), ('\u{fe20}', '\u{fe2d}', 0,
        0), ('\u{fe30}', '\u{fe52}', 2, 2), ('\u{fe54}', '\u{fe66}', 2, 2), ('\u{fe68}', '\u{fe6b}',
        2, 2), ('\u{feff}', '\u{feff}', 0, 0), ('\u{ff01}', '\u{ff60}', 2, 2), ('\u{ffe0}',
        '\u{ffe6}', 2, 2), ('\u{fff9}', '\u{fffb}', 0, 0), ('\u{fffd}', '\u{fffd}', 1, 2),
        ('\u{101fd}', '\u{101fd}', 0, 0), ('\u{102e0}', '\u{102e0}', 0, 0), ('\u{10376}',
        '\u{1037a}', 0, 0), ('\u{10a01}', '\u{10a03}', 0, 0), ('\u{10a05}', '\u{10a06}', 0, 0),
        ('\u{10a0c}', '\u{10a0f}', 0, 0), ('\u{10a38}', '\u{10a3a}', 0, 0), ('\u{10a3f}',
        '\u{10a3f}', 0, 0), ('\u{10ae5}', '\u{10ae6}', 0, 0), ('\u{11001}', '\u{11001}', 0, 0),
        ('\u{11038}', '\u{11046}', 0, 0), ('\u{1107f}', '\u{11081}', 0, 0), ('\u{110b3}',
        '\u{110b6}', 0, 0), ('\u{110b9}', '\u{110ba}', 0, 0), ('\u{110bd}', '\u{110bd}', 0, 0),
        ('\u{11100}', '\u{11102}', 0, 0), ('\u{11127}', '\u{1112b}', 0, 0), ('\u{1112d}',
        '\u{11134}', 0, 0), ('\u{11173}', '\u{11173}', 0, 0), ('\u{11180}', '\u{11181}', 0, 0),
        ('\u{111b6}', '\u{111be}', 0, 0), ('\u{1122f}', '\u{11231}', 0, 0), ('\u{11234}',
        '\u{11234}', 0, 0), ('\u{11236}', '\u{11237}', 0, 0), ('\u{112df}', '\u{112df}', 0, 0),
        ('\u{112e3}', '\u{112ea}', 0, 0), ('\u{11301}', '\u{11301}', 0, 0), ('\u{1133c}',
        '\u{1133c}', 0, 0), ('\u{11340}', '\u{11340}', 0, 0), ('\u{11366}', '\u{1136c}', 0, 0),
        ('\u{11370}', '\u{11374}', 0, 0), ('\u{114b3}', '\u{114b8}', 0, 0), ('\u{114ba}',
        '\u{114ba}', 0, 0), ('\u{114bf}', '\u{114c0}', 0, 0), ('\u{114c2}', '\u{114c3}', 0, 0),
        ('\u{115b2}', '\u{115b5}', 0, 0), ('\u{115bc}', '\u{115bd}', 0, 0), ('\u{115bf}',
        '\u{115c0}', 0, 0), ('\u{11633}', '\u{1163a}', 0, 0), ('\u{1163d}', '\u{1163d}', 0, 0),
        ('\u{1163f}', '\u{11640}', 0, 0), ('\u{116ab}', '\u{116ab}', 0, 0), ('\u{116ad}',
        '\u{116ad}', 0, 0), ('\u{116b0}', '\u{116b5}', 0, 0), ('\u{116b7}', '\u{116b7}', 0, 0),
        ('\u{16af0}', '\u{16af4}', 0, 0), ('\u{16b30}', '\u{16b36}', 0, 0), ('\u{16f8f}',
        '\u{16f92}', 0, 0), ('\u{1b000}', '\u{1b001}', 2, 2), ('\u{1bc9d}', '\u{1bc9e}', 0, 0),
        ('\u{1bca0}', '\u{1bca3}', 0, 0), ('\u{1d167}', '\u{1d169}', 0, 0), ('\u{1d173}',
        '\u{1d182}', 0, 0), ('\u{1d185}', '\u{1d18b}', 0, 0), ('\u{1d1aa}', '\u{1d1ad}', 0, 0),
        ('\u{1d242}', '\u{1d244}', 0, 0), ('\u{1e8d0}', '\u{1e8d6}', 0, 0), ('\u{1f100}',
        '\u{1f10a}', 1, 2), ('\u{1f110}', '\u{1f12d}', 1, 2), ('\u{1f130}', '\u{1f169}', 1, 2),
        ('\u{1f170}', '\u{1f19a}', 1, 2), ('\u{1f200}', '\u{1f202}', 2, 2), ('\u{1f210}',
        '\u{1f23a}', 2, 2), ('\u{1f240}', '\u{1f248}', 2, 2), ('\u{1f250}', '\u{1f251}', 2, 2),
        ('\u{20000}', '\u{2fffd}', 2, 2), ('\u{30000}', '\u{3fffd}', 2, 2), ('\u{e0001}',
        '\u{e0001}', 0, 0), ('\u{e0020}', '\u{e007f}', 0, 0), ('\u{e0100}', '\u{e01ef}', 0, 0),
        ('\u{f0000}', '\u{ffffd}', 1, 2), ('\u{100000}', '\u{10fffd}', 1, 2)
    ];

}

pub mod grapheme {
    use core::kinds::Copy;
    use core::slice::SliceExt;
    pub use self::GraphemeCat::*;
    use core::result::Result::{Ok, Err};

    #[allow(non_camel_case_types)]
    #[deriving(Clone)]
    pub enum GraphemeCat {
        GC_LV,
        GC_LVT,
        GC_T,
        GC_Extend,
        GC_V,
        GC_Control,
        GC_SpacingMark,
        GC_L,
        GC_RegionalIndicator,
        GC_Any,
    }

    impl Copy for GraphemeCat {}

    fn bsearch_range_value_table(c: char, r: &'static [(char, char, GraphemeCat)]) -> GraphemeCat {
        use core::cmp::Ordering::{Equal, Less, Greater};
        match r.binary_search_by(|&(lo, hi, _)| {
            if lo <= c && c <= hi { Equal }
            else if hi < c { Less }
            else { Greater }
        }) {
            Ok(idx) => {
                let (_, _, cat) = r[idx];
                cat
            }
            Err(_) => GC_Any
        }
    }

    pub fn grapheme_category(c: char) -> GraphemeCat {
        bsearch_range_value_table(c, grapheme_cat_table)
    }

    static grapheme_cat_table: &'static [(char, char, GraphemeCat)] = &[
        ('\u{0}', '\u{1f}', GC_Control), ('\u{7f}', '\u{9f}', GC_Control), ('\u{ad}', '\u{ad}',
        GC_Control), ('\u{300}', '\u{36f}', GC_Extend), ('\u{483}', '\u{487}', GC_Extend),
        ('\u{488}', '\u{489}', GC_Extend), ('\u{591}', '\u{5bd}', GC_Extend), ('\u{5bf}', '\u{5bf}',
        GC_Extend), ('\u{5c1}', '\u{5c2}', GC_Extend), ('\u{5c4}', '\u{5c5}', GC_Extend),
        ('\u{5c7}', '\u{5c7}', GC_Extend), ('\u{600}', '\u{605}', GC_Control), ('\u{610}',
        '\u{61a}', GC_Extend), ('\u{61c}', '\u{61c}', GC_Control), ('\u{64b}', '\u{65f}',
        GC_Extend), ('\u{670}', '\u{670}', GC_Extend), ('\u{6d6}', '\u{6dc}', GC_Extend),
        ('\u{6dd}', '\u{6dd}', GC_Control), ('\u{6df}', '\u{6e4}', GC_Extend), ('\u{6e7}',
        '\u{6e8}', GC_Extend), ('\u{6ea}', '\u{6ed}', GC_Extend), ('\u{70f}', '\u{70f}',
        GC_Control), ('\u{711}', '\u{711}', GC_Extend), ('\u{730}', '\u{74a}', GC_Extend),
        ('\u{7a6}', '\u{7b0}', GC_Extend), ('\u{7eb}', '\u{7f3}', GC_Extend), ('\u{816}', '\u{819}',
        GC_Extend), ('\u{81b}', '\u{823}', GC_Extend), ('\u{825}', '\u{827}', GC_Extend),
        ('\u{829}', '\u{82d}', GC_Extend), ('\u{859}', '\u{85b}', GC_Extend), ('\u{8e4}', '\u{902}',
        GC_Extend), ('\u{903}', '\u{903}', GC_SpacingMark), ('\u{93a}', '\u{93a}', GC_Extend),
        ('\u{93b}', '\u{93b}', GC_SpacingMark), ('\u{93c}', '\u{93c}', GC_Extend), ('\u{93e}',
        '\u{940}', GC_SpacingMark), ('\u{941}', '\u{948}', GC_Extend), ('\u{949}', '\u{94c}',
        GC_SpacingMark), ('\u{94d}', '\u{94d}', GC_Extend), ('\u{94e}', '\u{94f}', GC_SpacingMark),
        ('\u{951}', '\u{957}', GC_Extend), ('\u{962}', '\u{963}', GC_Extend), ('\u{981}', '\u{981}',
        GC_Extend), ('\u{982}', '\u{983}', GC_SpacingMark), ('\u{9bc}', '\u{9bc}', GC_Extend),
        ('\u{9be}', '\u{9be}', GC_Extend), ('\u{9bf}', '\u{9c0}', GC_SpacingMark), ('\u{9c1}',
        '\u{9c4}', GC_Extend), ('\u{9c7}', '\u{9c8}', GC_SpacingMark), ('\u{9cb}', '\u{9cc}',
        GC_SpacingMark), ('\u{9cd}', '\u{9cd}', GC_Extend), ('\u{9d7}', '\u{9d7}', GC_Extend),
        ('\u{9e2}', '\u{9e3}', GC_Extend), ('\u{a01}', '\u{a02}', GC_Extend), ('\u{a03}', '\u{a03}',
        GC_SpacingMark), ('\u{a3c}', '\u{a3c}', GC_Extend), ('\u{a3e}', '\u{a40}', GC_SpacingMark),
        ('\u{a41}', '\u{a42}', GC_Extend), ('\u{a47}', '\u{a48}', GC_Extend), ('\u{a4b}', '\u{a4d}',
        GC_Extend), ('\u{a51}', '\u{a51}', GC_Extend), ('\u{a70}', '\u{a71}', GC_Extend),
        ('\u{a75}', '\u{a75}', GC_Extend), ('\u{a81}', '\u{a82}', GC_Extend), ('\u{a83}', '\u{a83}',
        GC_SpacingMark), ('\u{abc}', '\u{abc}', GC_Extend), ('\u{abe}', '\u{ac0}', GC_SpacingMark),
        ('\u{ac1}', '\u{ac5}', GC_Extend), ('\u{ac7}', '\u{ac8}', GC_Extend), ('\u{ac9}', '\u{ac9}',
        GC_SpacingMark), ('\u{acb}', '\u{acc}', GC_SpacingMark), ('\u{acd}', '\u{acd}', GC_Extend),
        ('\u{ae2}', '\u{ae3}', GC_Extend), ('\u{b01}', '\u{b01}', GC_Extend), ('\u{b02}', '\u{b03}',
        GC_SpacingMark), ('\u{b3c}', '\u{b3c}', GC_Extend), ('\u{b3e}', '\u{b3e}', GC_Extend),
        ('\u{b3f}', '\u{b3f}', GC_Extend), ('\u{b40}', '\u{b40}', GC_SpacingMark), ('\u{b41}',
        '\u{b44}', GC_Extend), ('\u{b47}', '\u{b48}', GC_SpacingMark), ('\u{b4b}', '\u{b4c}',
        GC_SpacingMark), ('\u{b4d}', '\u{b4d}', GC_Extend), ('\u{b56}', '\u{b56}', GC_Extend),
        ('\u{b57}', '\u{b57}', GC_Extend), ('\u{b62}', '\u{b63}', GC_Extend), ('\u{b82}', '\u{b82}',
        GC_Extend), ('\u{bbe}', '\u{bbe}', GC_Extend), ('\u{bbf}', '\u{bbf}', GC_SpacingMark),
        ('\u{bc0}', '\u{bc0}', GC_Extend), ('\u{bc1}', '\u{bc2}', GC_SpacingMark), ('\u{bc6}',
        '\u{bc8}', GC_SpacingMark), ('\u{bca}', '\u{bcc}', GC_SpacingMark), ('\u{bcd}', '\u{bcd}',
        GC_Extend), ('\u{bd7}', '\u{bd7}', GC_Extend), ('\u{c00}', '\u{c00}', GC_Extend),
        ('\u{c01}', '\u{c03}', GC_SpacingMark), ('\u{c3e}', '\u{c40}', GC_Extend), ('\u{c41}',
        '\u{c44}', GC_SpacingMark), ('\u{c46}', '\u{c48}', GC_Extend), ('\u{c4a}', '\u{c4d}',
        GC_Extend), ('\u{c55}', '\u{c56}', GC_Extend), ('\u{c62}', '\u{c63}', GC_Extend),
        ('\u{c81}', '\u{c81}', GC_Extend), ('\u{c82}', '\u{c83}', GC_SpacingMark), ('\u{cbc}',
        '\u{cbc}', GC_Extend), ('\u{cbe}', '\u{cbe}', GC_SpacingMark), ('\u{cbf}', '\u{cbf}',
        GC_Extend), ('\u{cc0}', '\u{cc1}', GC_SpacingMark), ('\u{cc2}', '\u{cc2}', GC_Extend),
        ('\u{cc3}', '\u{cc4}', GC_SpacingMark), ('\u{cc6}', '\u{cc6}', GC_Extend), ('\u{cc7}',
        '\u{cc8}', GC_SpacingMark), ('\u{cca}', '\u{ccb}', GC_SpacingMark), ('\u{ccc}', '\u{ccd}',
        GC_Extend), ('\u{cd5}', '\u{cd6}', GC_Extend), ('\u{ce2}', '\u{ce3}', GC_Extend),
        ('\u{d01}', '\u{d01}', GC_Extend), ('\u{d02}', '\u{d03}', GC_SpacingMark), ('\u{d3e}',
        '\u{d3e}', GC_Extend), ('\u{d3f}', '\u{d40}', GC_SpacingMark), ('\u{d41}', '\u{d44}',
        GC_Extend), ('\u{d46}', '\u{d48}', GC_SpacingMark), ('\u{d4a}', '\u{d4c}', GC_SpacingMark),
        ('\u{d4d}', '\u{d4d}', GC_Extend), ('\u{d57}', '\u{d57}', GC_Extend), ('\u{d62}', '\u{d63}',
        GC_Extend), ('\u{d82}', '\u{d83}', GC_SpacingMark), ('\u{dca}', '\u{dca}', GC_Extend),
        ('\u{dcf}', '\u{dcf}', GC_Extend), ('\u{dd0}', '\u{dd1}', GC_SpacingMark), ('\u{dd2}',
        '\u{dd4}', GC_Extend), ('\u{dd6}', '\u{dd6}', GC_Extend), ('\u{dd8}', '\u{dde}',
        GC_SpacingMark), ('\u{ddf}', '\u{ddf}', GC_Extend), ('\u{df2}', '\u{df3}', GC_SpacingMark),
        ('\u{e31}', '\u{e31}', GC_Extend), ('\u{e33}', '\u{e33}', GC_SpacingMark), ('\u{e34}',
        '\u{e3a}', GC_Extend), ('\u{e47}', '\u{e4e}', GC_Extend), ('\u{eb1}', '\u{eb1}', GC_Extend),
        ('\u{eb3}', '\u{eb3}', GC_SpacingMark), ('\u{eb4}', '\u{eb9}', GC_Extend), ('\u{ebb}',
        '\u{ebc}', GC_Extend), ('\u{ec8}', '\u{ecd}', GC_Extend), ('\u{f18}', '\u{f19}', GC_Extend),
        ('\u{f35}', '\u{f35}', GC_Extend), ('\u{f37}', '\u{f37}', GC_Extend), ('\u{f39}', '\u{f39}',
        GC_Extend), ('\u{f3e}', '\u{f3f}', GC_SpacingMark), ('\u{f71}', '\u{f7e}', GC_Extend),
        ('\u{f7f}', '\u{f7f}', GC_SpacingMark), ('\u{f80}', '\u{f84}', GC_Extend), ('\u{f86}',
        '\u{f87}', GC_Extend), ('\u{f8d}', '\u{f97}', GC_Extend), ('\u{f99}', '\u{fbc}', GC_Extend),
        ('\u{fc6}', '\u{fc6}', GC_Extend), ('\u{102b}', '\u{102c}', GC_SpacingMark), ('\u{102d}',
        '\u{1030}', GC_Extend), ('\u{1031}', '\u{1031}', GC_SpacingMark), ('\u{1032}', '\u{1037}',
        GC_Extend), ('\u{1038}', '\u{1038}', GC_SpacingMark), ('\u{1039}', '\u{103a}', GC_Extend),
        ('\u{103b}', '\u{103c}', GC_SpacingMark), ('\u{103d}', '\u{103e}', GC_Extend), ('\u{1056}',
        '\u{1057}', GC_SpacingMark), ('\u{1058}', '\u{1059}', GC_Extend), ('\u{105e}', '\u{1060}',
        GC_Extend), ('\u{1062}', '\u{1064}', GC_SpacingMark), ('\u{1067}', '\u{106d}',
        GC_SpacingMark), ('\u{1071}', '\u{1074}', GC_Extend), ('\u{1082}', '\u{1082}', GC_Extend),
        ('\u{1083}', '\u{1084}', GC_SpacingMark), ('\u{1085}', '\u{1086}', GC_Extend), ('\u{1087}',
        '\u{108c}', GC_SpacingMark), ('\u{108d}', '\u{108d}', GC_Extend), ('\u{108f}', '\u{108f}',
        GC_SpacingMark), ('\u{109a}', '\u{109c}', GC_SpacingMark), ('\u{109d}', '\u{109d}',
        GC_Extend), ('\u{1100}', '\u{115f}', GC_L), ('\u{1160}', '\u{11a7}', GC_V), ('\u{11a8}',
        '\u{11ff}', GC_T), ('\u{135d}', '\u{135f}', GC_Extend), ('\u{1712}', '\u{1714}', GC_Extend),
        ('\u{1732}', '\u{1734}', GC_Extend), ('\u{1752}', '\u{1753}', GC_Extend), ('\u{1772}',
        '\u{1773}', GC_Extend), ('\u{17b4}', '\u{17b5}', GC_Extend), ('\u{17b6}', '\u{17b6}',
        GC_SpacingMark), ('\u{17b7}', '\u{17bd}', GC_Extend), ('\u{17be}', '\u{17c5}',
        GC_SpacingMark), ('\u{17c6}', '\u{17c6}', GC_Extend), ('\u{17c7}', '\u{17c8}',
        GC_SpacingMark), ('\u{17c9}', '\u{17d3}', GC_Extend), ('\u{17dd}', '\u{17dd}', GC_Extend),
        ('\u{180b}', '\u{180d}', GC_Extend), ('\u{180e}', '\u{180e}', GC_Control), ('\u{18a9}',
        '\u{18a9}', GC_Extend), ('\u{1920}', '\u{1922}', GC_Extend), ('\u{1923}', '\u{1926}',
        GC_SpacingMark), ('\u{1927}', '\u{1928}', GC_Extend), ('\u{1929}', '\u{192b}',
        GC_SpacingMark), ('\u{1930}', '\u{1931}', GC_SpacingMark), ('\u{1932}', '\u{1932}',
        GC_Extend), ('\u{1933}', '\u{1938}', GC_SpacingMark), ('\u{1939}', '\u{193b}', GC_Extend),
        ('\u{19b0}', '\u{19c0}', GC_SpacingMark), ('\u{19c8}', '\u{19c9}', GC_SpacingMark),
        ('\u{1a17}', '\u{1a18}', GC_Extend), ('\u{1a19}', '\u{1a1a}', GC_SpacingMark), ('\u{1a1b}',
        '\u{1a1b}', GC_Extend), ('\u{1a55}', '\u{1a55}', GC_SpacingMark), ('\u{1a56}', '\u{1a56}',
        GC_Extend), ('\u{1a57}', '\u{1a57}', GC_SpacingMark), ('\u{1a58}', '\u{1a5e}', GC_Extend),
        ('\u{1a60}', '\u{1a60}', GC_Extend), ('\u{1a61}', '\u{1a61}', GC_SpacingMark), ('\u{1a62}',
        '\u{1a62}', GC_Extend), ('\u{1a63}', '\u{1a64}', GC_SpacingMark), ('\u{1a65}', '\u{1a6c}',
        GC_Extend), ('\u{1a6d}', '\u{1a72}', GC_SpacingMark), ('\u{1a73}', '\u{1a7c}', GC_Extend),
        ('\u{1a7f}', '\u{1a7f}', GC_Extend), ('\u{1ab0}', '\u{1abd}', GC_Extend), ('\u{1abe}',
        '\u{1abe}', GC_Extend), ('\u{1b00}', '\u{1b03}', GC_Extend), ('\u{1b04}', '\u{1b04}',
        GC_SpacingMark), ('\u{1b34}', '\u{1b34}', GC_Extend), ('\u{1b35}', '\u{1b35}',
        GC_SpacingMark), ('\u{1b36}', '\u{1b3a}', GC_Extend), ('\u{1b3b}', '\u{1b3b}',
        GC_SpacingMark), ('\u{1b3c}', '\u{1b3c}', GC_Extend), ('\u{1b3d}', '\u{1b41}',
        GC_SpacingMark), ('\u{1b42}', '\u{1b42}', GC_Extend), ('\u{1b43}', '\u{1b44}',
        GC_SpacingMark), ('\u{1b6b}', '\u{1b73}', GC_Extend), ('\u{1b80}', '\u{1b81}', GC_Extend),
        ('\u{1b82}', '\u{1b82}', GC_SpacingMark), ('\u{1ba1}', '\u{1ba1}', GC_SpacingMark),
        ('\u{1ba2}', '\u{1ba5}', GC_Extend), ('\u{1ba6}', '\u{1ba7}', GC_SpacingMark), ('\u{1ba8}',
        '\u{1ba9}', GC_Extend), ('\u{1baa}', '\u{1baa}', GC_SpacingMark), ('\u{1bab}', '\u{1bad}',
        GC_Extend), ('\u{1be6}', '\u{1be6}', GC_Extend), ('\u{1be7}', '\u{1be7}', GC_SpacingMark),
        ('\u{1be8}', '\u{1be9}', GC_Extend), ('\u{1bea}', '\u{1bec}', GC_SpacingMark), ('\u{1bed}',
        '\u{1bed}', GC_Extend), ('\u{1bee}', '\u{1bee}', GC_SpacingMark), ('\u{1bef}', '\u{1bf1}',
        GC_Extend), ('\u{1bf2}', '\u{1bf3}', GC_SpacingMark), ('\u{1c24}', '\u{1c2b}',
        GC_SpacingMark), ('\u{1c2c}', '\u{1c33}', GC_Extend), ('\u{1c34}', '\u{1c35}',
        GC_SpacingMark), ('\u{1c36}', '\u{1c37}', GC_Extend), ('\u{1cd0}', '\u{1cd2}', GC_Extend),
        ('\u{1cd4}', '\u{1ce0}', GC_Extend), ('\u{1ce1}', '\u{1ce1}', GC_SpacingMark), ('\u{1ce2}',
        '\u{1ce8}', GC_Extend), ('\u{1ced}', '\u{1ced}', GC_Extend), ('\u{1cf2}', '\u{1cf3}',
        GC_SpacingMark), ('\u{1cf4}', '\u{1cf4}', GC_Extend), ('\u{1cf8}', '\u{1cf9}', GC_Extend),
        ('\u{1dc0}', '\u{1df5}', GC_Extend), ('\u{1dfc}', '\u{1dff}', GC_Extend), ('\u{200b}',
        '\u{200b}', GC_Control), ('\u{200c}', '\u{200d}', GC_Extend), ('\u{200e}', '\u{200f}',
        GC_Control), ('\u{2028}', '\u{202e}', GC_Control), ('\u{2060}', '\u{206f}', GC_Control),
        ('\u{20d0}', '\u{20dc}', GC_Extend), ('\u{20dd}', '\u{20e0}', GC_Extend), ('\u{20e1}',
        '\u{20e1}', GC_Extend), ('\u{20e2}', '\u{20e4}', GC_Extend), ('\u{20e5}', '\u{20f0}',
        GC_Extend), ('\u{2cef}', '\u{2cf1}', GC_Extend), ('\u{2d7f}', '\u{2d7f}', GC_Extend),
        ('\u{2de0}', '\u{2dff}', GC_Extend), ('\u{302a}', '\u{302d}', GC_Extend), ('\u{302e}',
        '\u{302f}', GC_Extend), ('\u{3099}', '\u{309a}', GC_Extend), ('\u{a66f}', '\u{a66f}',
        GC_Extend), ('\u{a670}', '\u{a672}', GC_Extend), ('\u{a674}', '\u{a67d}', GC_Extend),
        ('\u{a69f}', '\u{a69f}', GC_Extend), ('\u{a6f0}', '\u{a6f1}', GC_Extend), ('\u{a802}',
        '\u{a802}', GC_Extend), ('\u{a806}', '\u{a806}', GC_Extend), ('\u{a80b}', '\u{a80b}',
        GC_Extend), ('\u{a823}', '\u{a824}', GC_SpacingMark), ('\u{a825}', '\u{a826}', GC_Extend),
        ('\u{a827}', '\u{a827}', GC_SpacingMark), ('\u{a880}', '\u{a881}', GC_SpacingMark),
        ('\u{a8b4}', '\u{a8c3}', GC_SpacingMark), ('\u{a8c4}', '\u{a8c4}', GC_Extend), ('\u{a8e0}',
        '\u{a8f1}', GC_Extend), ('\u{a926}', '\u{a92d}', GC_Extend), ('\u{a947}', '\u{a951}',
        GC_Extend), ('\u{a952}', '\u{a953}', GC_SpacingMark), ('\u{a960}', '\u{a97c}', GC_L),
        ('\u{a980}', '\u{a982}', GC_Extend), ('\u{a983}', '\u{a983}', GC_SpacingMark), ('\u{a9b3}',
        '\u{a9b3}', GC_Extend), ('\u{a9b4}', '\u{a9b5}', GC_SpacingMark), ('\u{a9b6}', '\u{a9b9}',
        GC_Extend), ('\u{a9ba}', '\u{a9bb}', GC_SpacingMark), ('\u{a9bc}', '\u{a9bc}', GC_Extend),
        ('\u{a9bd}', '\u{a9c0}', GC_SpacingMark), ('\u{a9e5}', '\u{a9e5}', GC_Extend), ('\u{aa29}',
        '\u{aa2e}', GC_Extend), ('\u{aa2f}', '\u{aa30}', GC_SpacingMark), ('\u{aa31}', '\u{aa32}',
        GC_Extend), ('\u{aa33}', '\u{aa34}', GC_SpacingMark), ('\u{aa35}', '\u{aa36}', GC_Extend),
        ('\u{aa43}', '\u{aa43}', GC_Extend), ('\u{aa4c}', '\u{aa4c}', GC_Extend), ('\u{aa4d}',
        '\u{aa4d}', GC_SpacingMark), ('\u{aa7b}', '\u{aa7b}', GC_SpacingMark), ('\u{aa7c}',
        '\u{aa7c}', GC_Extend), ('\u{aa7d}', '\u{aa7d}', GC_SpacingMark), ('\u{aab0}', '\u{aab0}',
        GC_Extend), ('\u{aab2}', '\u{aab4}', GC_Extend), ('\u{aab7}', '\u{aab8}', GC_Extend),
        ('\u{aabe}', '\u{aabf}', GC_Extend), ('\u{aac1}', '\u{aac1}', GC_Extend), ('\u{aaeb}',
        '\u{aaeb}', GC_SpacingMark), ('\u{aaec}', '\u{aaed}', GC_Extend), ('\u{aaee}', '\u{aaef}',
        GC_SpacingMark), ('\u{aaf5}', '\u{aaf5}', GC_SpacingMark), ('\u{aaf6}', '\u{aaf6}',
        GC_Extend), ('\u{abe3}', '\u{abe4}', GC_SpacingMark), ('\u{abe5}', '\u{abe5}', GC_Extend),
        ('\u{abe6}', '\u{abe7}', GC_SpacingMark), ('\u{abe8}', '\u{abe8}', GC_Extend), ('\u{abe9}',
        '\u{abea}', GC_SpacingMark), ('\u{abec}', '\u{abec}', GC_SpacingMark), ('\u{abed}',
        '\u{abed}', GC_Extend), ('\u{ac00}', '\u{ac00}', GC_LV), ('\u{ac01}', '\u{ac1b}', GC_LVT),
        ('\u{ac1c}', '\u{ac1c}', GC_LV), ('\u{ac1d}', '\u{ac37}', GC_LVT), ('\u{ac38}', '\u{ac38}',
        GC_LV), ('\u{ac39}', '\u{ac53}', GC_LVT), ('\u{ac54}', '\u{ac54}', GC_LV), ('\u{ac55}',
        '\u{ac6f}', GC_LVT), ('\u{ac70}', '\u{ac70}', GC_LV), ('\u{ac71}', '\u{ac8b}', GC_LVT),
        ('\u{ac8c}', '\u{ac8c}', GC_LV), ('\u{ac8d}', '\u{aca7}', GC_LVT), ('\u{aca8}', '\u{aca8}',
        GC_LV), ('\u{aca9}', '\u{acc3}', GC_LVT), ('\u{acc4}', '\u{acc4}', GC_LV), ('\u{acc5}',
        '\u{acdf}', GC_LVT), ('\u{ace0}', '\u{ace0}', GC_LV), ('\u{ace1}', '\u{acfb}', GC_LVT),
        ('\u{acfc}', '\u{acfc}', GC_LV), ('\u{acfd}', '\u{ad17}', GC_LVT), ('\u{ad18}', '\u{ad18}',
        GC_LV), ('\u{ad19}', '\u{ad33}', GC_LVT), ('\u{ad34}', '\u{ad34}', GC_LV), ('\u{ad35}',
        '\u{ad4f}', GC_LVT), ('\u{ad50}', '\u{ad50}', GC_LV), ('\u{ad51}', '\u{ad6b}', GC_LVT),
        ('\u{ad6c}', '\u{ad6c}', GC_LV), ('\u{ad6d}', '\u{ad87}', GC_LVT), ('\u{ad88}', '\u{ad88}',
        GC_LV), ('\u{ad89}', '\u{ada3}', GC_LVT), ('\u{ada4}', '\u{ada4}', GC_LV), ('\u{ada5}',
        '\u{adbf}', GC_LVT), ('\u{adc0}', '\u{adc0}', GC_LV), ('\u{adc1}', '\u{addb}', GC_LVT),
        ('\u{addc}', '\u{addc}', GC_LV), ('\u{addd}', '\u{adf7}', GC_LVT), ('\u{adf8}', '\u{adf8}',
        GC_LV), ('\u{adf9}', '\u{ae13}', GC_LVT), ('\u{ae14}', '\u{ae14}', GC_LV), ('\u{ae15}',
        '\u{ae2f}', GC_LVT), ('\u{ae30}', '\u{ae30}', GC_LV), ('\u{ae31}', '\u{ae4b}', GC_LVT),
        ('\u{ae4c}', '\u{ae4c}', GC_LV), ('\u{ae4d}', '\u{ae67}', GC_LVT), ('\u{ae68}', '\u{ae68}',
        GC_LV), ('\u{ae69}', '\u{ae83}', GC_LVT), ('\u{ae84}', '\u{ae84}', GC_LV), ('\u{ae85}',
        '\u{ae9f}', GC_LVT), ('\u{aea0}', '\u{aea0}', GC_LV), ('\u{aea1}', '\u{aebb}', GC_LVT),
        ('\u{aebc}', '\u{aebc}', GC_LV), ('\u{aebd}', '\u{aed7}', GC_LVT), ('\u{aed8}', '\u{aed8}',
        GC_LV), ('\u{aed9}', '\u{aef3}', GC_LVT), ('\u{aef4}', '\u{aef4}', GC_LV), ('\u{aef5}',
        '\u{af0f}', GC_LVT), ('\u{af10}', '\u{af10}', GC_LV), ('\u{af11}', '\u{af2b}', GC_LVT),
        ('\u{af2c}', '\u{af2c}', GC_LV), ('\u{af2d}', '\u{af47}', GC_LVT), ('\u{af48}', '\u{af48}',
        GC_LV), ('\u{af49}', '\u{af63}', GC_LVT), ('\u{af64}', '\u{af64}', GC_LV), ('\u{af65}',
        '\u{af7f}', GC_LVT), ('\u{af80}', '\u{af80}', GC_LV), ('\u{af81}', '\u{af9b}', GC_LVT),
        ('\u{af9c}', '\u{af9c}', GC_LV), ('\u{af9d}', '\u{afb7}', GC_LVT), ('\u{afb8}', '\u{afb8}',
        GC_LV), ('\u{afb9}', '\u{afd3}', GC_LVT), ('\u{afd4}', '\u{afd4}', GC_LV), ('\u{afd5}',
        '\u{afef}', GC_LVT), ('\u{aff0}', '\u{aff0}', GC_LV), ('\u{aff1}', '\u{b00b}', GC_LVT),
        ('\u{b00c}', '\u{b00c}', GC_LV), ('\u{b00d}', '\u{b027}', GC_LVT), ('\u{b028}', '\u{b028}',
        GC_LV), ('\u{b029}', '\u{b043}', GC_LVT), ('\u{b044}', '\u{b044}', GC_LV), ('\u{b045}',
        '\u{b05f}', GC_LVT), ('\u{b060}', '\u{b060}', GC_LV), ('\u{b061}', '\u{b07b}', GC_LVT),
        ('\u{b07c}', '\u{b07c}', GC_LV), ('\u{b07d}', '\u{b097}', GC_LVT), ('\u{b098}', '\u{b098}',
        GC_LV), ('\u{b099}', '\u{b0b3}', GC_LVT), ('\u{b0b4}', '\u{b0b4}', GC_LV), ('\u{b0b5}',
        '\u{b0cf}', GC_LVT), ('\u{b0d0}', '\u{b0d0}', GC_LV), ('\u{b0d1}', '\u{b0eb}', GC_LVT),
        ('\u{b0ec}', '\u{b0ec}', GC_LV), ('\u{b0ed}', '\u{b107}', GC_LVT), ('\u{b108}', '\u{b108}',
        GC_LV), ('\u{b109}', '\u{b123}', GC_LVT), ('\u{b124}', '\u{b124}', GC_LV), ('\u{b125}',
        '\u{b13f}', GC_LVT), ('\u{b140}', '\u{b140}', GC_LV), ('\u{b141}', '\u{b15b}', GC_LVT),
        ('\u{b15c}', '\u{b15c}', GC_LV), ('\u{b15d}', '\u{b177}', GC_LVT), ('\u{b178}', '\u{b178}',
        GC_LV), ('\u{b179}', '\u{b193}', GC_LVT), ('\u{b194}', '\u{b194}', GC_LV), ('\u{b195}',
        '\u{b1af}', GC_LVT), ('\u{b1b0}', '\u{b1b0}', GC_LV), ('\u{b1b1}', '\u{b1cb}', GC_LVT),
        ('\u{b1cc}', '\u{b1cc}', GC_LV), ('\u{b1cd}', '\u{b1e7}', GC_LVT), ('\u{b1e8}', '\u{b1e8}',
        GC_LV), ('\u{b1e9}', '\u{b203}', GC_LVT), ('\u{b204}', '\u{b204}', GC_LV), ('\u{b205}',
        '\u{b21f}', GC_LVT), ('\u{b220}', '\u{b220}', GC_LV), ('\u{b221}', '\u{b23b}', GC_LVT),
        ('\u{b23c}', '\u{b23c}', GC_LV), ('\u{b23d}', '\u{b257}', GC_LVT), ('\u{b258}', '\u{b258}',
        GC_LV), ('\u{b259}', '\u{b273}', GC_LVT), ('\u{b274}', '\u{b274}', GC_LV), ('\u{b275}',
        '\u{b28f}', GC_LVT), ('\u{b290}', '\u{b290}', GC_LV), ('\u{b291}', '\u{b2ab}', GC_LVT),
        ('\u{b2ac}', '\u{b2ac}', GC_LV), ('\u{b2ad}', '\u{b2c7}', GC_LVT), ('\u{b2c8}', '\u{b2c8}',
        GC_LV), ('\u{b2c9}', '\u{b2e3}', GC_LVT), ('\u{b2e4}', '\u{b2e4}', GC_LV), ('\u{b2e5}',
        '\u{b2ff}', GC_LVT), ('\u{b300}', '\u{b300}', GC_LV), ('\u{b301}', '\u{b31b}', GC_LVT),
        ('\u{b31c}', '\u{b31c}', GC_LV), ('\u{b31d}', '\u{b337}', GC_LVT), ('\u{b338}', '\u{b338}',
        GC_LV), ('\u{b339}', '\u{b353}', GC_LVT), ('\u{b354}', '\u{b354}', GC_LV), ('\u{b355}',
        '\u{b36f}', GC_LVT), ('\u{b370}', '\u{b370}', GC_LV), ('\u{b371}', '\u{b38b}', GC_LVT),
        ('\u{b38c}', '\u{b38c}', GC_LV), ('\u{b38d}', '\u{b3a7}', GC_LVT), ('\u{b3a8}', '\u{b3a8}',
        GC_LV), ('\u{b3a9}', '\u{b3c3}', GC_LVT), ('\u{b3c4}', '\u{b3c4}', GC_LV), ('\u{b3c5}',
        '\u{b3df}', GC_LVT), ('\u{b3e0}', '\u{b3e0}', GC_LV), ('\u{b3e1}', '\u{b3fb}', GC_LVT),
        ('\u{b3fc}', '\u{b3fc}', GC_LV), ('\u{b3fd}', '\u{b417}', GC_LVT), ('\u{b418}', '\u{b418}',
        GC_LV), ('\u{b419}', '\u{b433}', GC_LVT), ('\u{b434}', '\u{b434}', GC_LV), ('\u{b435}',
        '\u{b44f}', GC_LVT), ('\u{b450}', '\u{b450}', GC_LV), ('\u{b451}', '\u{b46b}', GC_LVT),
        ('\u{b46c}', '\u{b46c}', GC_LV), ('\u{b46d}', '\u{b487}', GC_LVT), ('\u{b488}', '\u{b488}',
        GC_LV), ('\u{b489}', '\u{b4a3}', GC_LVT), ('\u{b4a4}', '\u{b4a4}', GC_LV), ('\u{b4a5}',
        '\u{b4bf}', GC_LVT), ('\u{b4c0}', '\u{b4c0}', GC_LV), ('\u{b4c1}', '\u{b4db}', GC_LVT),
        ('\u{b4dc}', '\u{b4dc}', GC_LV), ('\u{b4dd}', '\u{b4f7}', GC_LVT), ('\u{b4f8}', '\u{b4f8}',
        GC_LV), ('\u{b4f9}', '\u{b513}', GC_LVT), ('\u{b514}', '\u{b514}', GC_LV), ('\u{b515}',
        '\u{b52f}', GC_LVT), ('\u{b530}', '\u{b530}', GC_LV), ('\u{b531}', '\u{b54b}', GC_LVT),
        ('\u{b54c}', '\u{b54c}', GC_LV), ('\u{b54d}', '\u{b567}', GC_LVT), ('\u{b568}', '\u{b568}',
        GC_LV), ('\u{b569}', '\u{b583}', GC_LVT), ('\u{b584}', '\u{b584}', GC_LV), ('\u{b585}',
        '\u{b59f}', GC_LVT), ('\u{b5a0}', '\u{b5a0}', GC_LV), ('\u{b5a1}', '\u{b5bb}', GC_LVT),
        ('\u{b5bc}', '\u{b5bc}', GC_LV), ('\u{b5bd}', '\u{b5d7}', GC_LVT), ('\u{b5d8}', '\u{b5d8}',
        GC_LV), ('\u{b5d9}', '\u{b5f3}', GC_LVT), ('\u{b5f4}', '\u{b5f4}', GC_LV), ('\u{b5f5}',
        '\u{b60f}', GC_LVT), ('\u{b610}', '\u{b610}', GC_LV), ('\u{b611}', '\u{b62b}', GC_LVT),
        ('\u{b62c}', '\u{b62c}', GC_LV), ('\u{b62d}', '\u{b647}', GC_LVT), ('\u{b648}', '\u{b648}',
        GC_LV), ('\u{b649}', '\u{b663}', GC_LVT), ('\u{b664}', '\u{b664}', GC_LV), ('\u{b665}',
        '\u{b67f}', GC_LVT), ('\u{b680}', '\u{b680}', GC_LV), ('\u{b681}', '\u{b69b}', GC_LVT),
        ('\u{b69c}', '\u{b69c}', GC_LV), ('\u{b69d}', '\u{b6b7}', GC_LVT), ('\u{b6b8}', '\u{b6b8}',
        GC_LV), ('\u{b6b9}', '\u{b6d3}', GC_LVT), ('\u{b6d4}', '\u{b6d4}', GC_LV), ('\u{b6d5}',
        '\u{b6ef}', GC_LVT), ('\u{b6f0}', '\u{b6f0}', GC_LV), ('\u{b6f1}', '\u{b70b}', GC_LVT),
        ('\u{b70c}', '\u{b70c}', GC_LV), ('\u{b70d}', '\u{b727}', GC_LVT), ('\u{b728}', '\u{b728}',
        GC_LV), ('\u{b729}', '\u{b743}', GC_LVT), ('\u{b744}', '\u{b744}', GC_LV), ('\u{b745}',
        '\u{b75f}', GC_LVT), ('\u{b760}', '\u{b760}', GC_LV), ('\u{b761}', '\u{b77b}', GC_LVT),
        ('\u{b77c}', '\u{b77c}', GC_LV), ('\u{b77d}', '\u{b797}', GC_LVT), ('\u{b798}', '\u{b798}',
        GC_LV), ('\u{b799}', '\u{b7b3}', GC_LVT), ('\u{b7b4}', '\u{b7b4}', GC_LV), ('\u{b7b5}',
        '\u{b7cf}', GC_LVT), ('\u{b7d0}', '\u{b7d0}', GC_LV), ('\u{b7d1}', '\u{b7eb}', GC_LVT),
        ('\u{b7ec}', '\u{b7ec}', GC_LV), ('\u{b7ed}', '\u{b807}', GC_LVT), ('\u{b808}', '\u{b808}',
        GC_LV), ('\u{b809}', '\u{b823}', GC_LVT), ('\u{b824}', '\u{b824}', GC_LV), ('\u{b825}',
        '\u{b83f}', GC_LVT), ('\u{b840}', '\u{b840}', GC_LV), ('\u{b841}', '\u{b85b}', GC_LVT),
        ('\u{b85c}', '\u{b85c}', GC_LV), ('\u{b85d}', '\u{b877}', GC_LVT), ('\u{b878}', '\u{b878}',
        GC_LV), ('\u{b879}', '\u{b893}', GC_LVT), ('\u{b894}', '\u{b894}', GC_LV), ('\u{b895}',
        '\u{b8af}', GC_LVT), ('\u{b8b0}', '\u{b8b0}', GC_LV), ('\u{b8b1}', '\u{b8cb}', GC_LVT),
        ('\u{b8cc}', '\u{b8cc}', GC_LV), ('\u{b8cd}', '\u{b8e7}', GC_LVT), ('\u{b8e8}', '\u{b8e8}',
        GC_LV), ('\u{b8e9}', '\u{b903}', GC_LVT), ('\u{b904}', '\u{b904}', GC_LV), ('\u{b905}',
        '\u{b91f}', GC_LVT), ('\u{b920}', '\u{b920}', GC_LV), ('\u{b921}', '\u{b93b}', GC_LVT),
        ('\u{b93c}', '\u{b93c}', GC_LV), ('\u{b93d}', '\u{b957}', GC_LVT), ('\u{b958}', '\u{b958}',
        GC_LV), ('\u{b959}', '\u{b973}', GC_LVT), ('\u{b974}', '\u{b974}', GC_LV), ('\u{b975}',
        '\u{b98f}', GC_LVT), ('\u{b990}', '\u{b990}', GC_LV), ('\u{b991}', '\u{b9ab}', GC_LVT),
        ('\u{b9ac}', '\u{b9ac}', GC_LV), ('\u{b9ad}', '\u{b9c7}', GC_LVT), ('\u{b9c8}', '\u{b9c8}',
        GC_LV), ('\u{b9c9}', '\u{b9e3}', GC_LVT), ('\u{b9e4}', '\u{b9e4}', GC_LV), ('\u{b9e5}',
        '\u{b9ff}', GC_LVT), ('\u{ba00}', '\u{ba00}', GC_LV), ('\u{ba01}', '\u{ba1b}', GC_LVT),
        ('\u{ba1c}', '\u{ba1c}', GC_LV), ('\u{ba1d}', '\u{ba37}', GC_LVT), ('\u{ba38}', '\u{ba38}',
        GC_LV), ('\u{ba39}', '\u{ba53}', GC_LVT), ('\u{ba54}', '\u{ba54}', GC_LV), ('\u{ba55}',
        '\u{ba6f}', GC_LVT), ('\u{ba70}', '\u{ba70}', GC_LV), ('\u{ba71}', '\u{ba8b}', GC_LVT),
        ('\u{ba8c}', '\u{ba8c}', GC_LV), ('\u{ba8d}', '\u{baa7}', GC_LVT), ('\u{baa8}', '\u{baa8}',
        GC_LV), ('\u{baa9}', '\u{bac3}', GC_LVT), ('\u{bac4}', '\u{bac4}', GC_LV), ('\u{bac5}',
        '\u{badf}', GC_LVT), ('\u{bae0}', '\u{bae0}', GC_LV), ('\u{bae1}', '\u{bafb}', GC_LVT),
        ('\u{bafc}', '\u{bafc}', GC_LV), ('\u{bafd}', '\u{bb17}', GC_LVT), ('\u{bb18}', '\u{bb18}',
        GC_LV), ('\u{bb19}', '\u{bb33}', GC_LVT), ('\u{bb34}', '\u{bb34}', GC_LV), ('\u{bb35}',
        '\u{bb4f}', GC_LVT), ('\u{bb50}', '\u{bb50}', GC_LV), ('\u{bb51}', '\u{bb6b}', GC_LVT),
        ('\u{bb6c}', '\u{bb6c}', GC_LV), ('\u{bb6d}', '\u{bb87}', GC_LVT), ('\u{bb88}', '\u{bb88}',
        GC_LV), ('\u{bb89}', '\u{bba3}', GC_LVT), ('\u{bba4}', '\u{bba4}', GC_LV), ('\u{bba5}',
        '\u{bbbf}', GC_LVT), ('\u{bbc0}', '\u{bbc0}', GC_LV), ('\u{bbc1}', '\u{bbdb}', GC_LVT),
        ('\u{bbdc}', '\u{bbdc}', GC_LV), ('\u{bbdd}', '\u{bbf7}', GC_LVT), ('\u{bbf8}', '\u{bbf8}',
        GC_LV), ('\u{bbf9}', '\u{bc13}', GC_LVT), ('\u{bc14}', '\u{bc14}', GC_LV), ('\u{bc15}',
        '\u{bc2f}', GC_LVT), ('\u{bc30}', '\u{bc30}', GC_LV), ('\u{bc31}', '\u{bc4b}', GC_LVT),
        ('\u{bc4c}', '\u{bc4c}', GC_LV), ('\u{bc4d}', '\u{bc67}', GC_LVT), ('\u{bc68}', '\u{bc68}',
        GC_LV), ('\u{bc69}', '\u{bc83}', GC_LVT), ('\u{bc84}', '\u{bc84}', GC_LV), ('\u{bc85}',
        '\u{bc9f}', GC_LVT), ('\u{bca0}', '\u{bca0}', GC_LV), ('\u{bca1}', '\u{bcbb}', GC_LVT),
        ('\u{bcbc}', '\u{bcbc}', GC_LV), ('\u{bcbd}', '\u{bcd7}', GC_LVT), ('\u{bcd8}', '\u{bcd8}',
        GC_LV), ('\u{bcd9}', '\u{bcf3}', GC_LVT), ('\u{bcf4}', '\u{bcf4}', GC_LV), ('\u{bcf5}',
        '\u{bd0f}', GC_LVT), ('\u{bd10}', '\u{bd10}', GC_LV), ('\u{bd11}', '\u{bd2b}', GC_LVT),
        ('\u{bd2c}', '\u{bd2c}', GC_LV), ('\u{bd2d}', '\u{bd47}', GC_LVT), ('\u{bd48}', '\u{bd48}',
        GC_LV), ('\u{bd49}', '\u{bd63}', GC_LVT), ('\u{bd64}', '\u{bd64}', GC_LV), ('\u{bd65}',
        '\u{bd7f}', GC_LVT), ('\u{bd80}', '\u{bd80}', GC_LV), ('\u{bd81}', '\u{bd9b}', GC_LVT),
        ('\u{bd9c}', '\u{bd9c}', GC_LV), ('\u{bd9d}', '\u{bdb7}', GC_LVT), ('\u{bdb8}', '\u{bdb8}',
        GC_LV), ('\u{bdb9}', '\u{bdd3}', GC_LVT), ('\u{bdd4}', '\u{bdd4}', GC_LV), ('\u{bdd5}',
        '\u{bdef}', GC_LVT), ('\u{bdf0}', '\u{bdf0}', GC_LV), ('\u{bdf1}', '\u{be0b}', GC_LVT),
        ('\u{be0c}', '\u{be0c}', GC_LV), ('\u{be0d}', '\u{be27}', GC_LVT), ('\u{be28}', '\u{be28}',
        GC_LV), ('\u{be29}', '\u{be43}', GC_LVT), ('\u{be44}', '\u{be44}', GC_LV), ('\u{be45}',
        '\u{be5f}', GC_LVT), ('\u{be60}', '\u{be60}', GC_LV), ('\u{be61}', '\u{be7b}', GC_LVT),
        ('\u{be7c}', '\u{be7c}', GC_LV), ('\u{be7d}', '\u{be97}', GC_LVT), ('\u{be98}', '\u{be98}',
        GC_LV), ('\u{be99}', '\u{beb3}', GC_LVT), ('\u{beb4}', '\u{beb4}', GC_LV), ('\u{beb5}',
        '\u{becf}', GC_LVT), ('\u{bed0}', '\u{bed0}', GC_LV), ('\u{bed1}', '\u{beeb}', GC_LVT),
        ('\u{beec}', '\u{beec}', GC_LV), ('\u{beed}', '\u{bf07}', GC_LVT), ('\u{bf08}', '\u{bf08}',
        GC_LV), ('\u{bf09}', '\u{bf23}', GC_LVT), ('\u{bf24}', '\u{bf24}', GC_LV), ('\u{bf25}',
        '\u{bf3f}', GC_LVT), ('\u{bf40}', '\u{bf40}', GC_LV), ('\u{bf41}', '\u{bf5b}', GC_LVT),
        ('\u{bf5c}', '\u{bf5c}', GC_LV), ('\u{bf5d}', '\u{bf77}', GC_LVT), ('\u{bf78}', '\u{bf78}',
        GC_LV), ('\u{bf79}', '\u{bf93}', GC_LVT), ('\u{bf94}', '\u{bf94}', GC_LV), ('\u{bf95}',
        '\u{bfaf}', GC_LVT), ('\u{bfb0}', '\u{bfb0}', GC_LV), ('\u{bfb1}', '\u{bfcb}', GC_LVT),
        ('\u{bfcc}', '\u{bfcc}', GC_LV), ('\u{bfcd}', '\u{bfe7}', GC_LVT), ('\u{bfe8}', '\u{bfe8}',
        GC_LV), ('\u{bfe9}', '\u{c003}', GC_LVT), ('\u{c004}', '\u{c004}', GC_LV), ('\u{c005}',
        '\u{c01f}', GC_LVT), ('\u{c020}', '\u{c020}', GC_LV), ('\u{c021}', '\u{c03b}', GC_LVT),
        ('\u{c03c}', '\u{c03c}', GC_LV), ('\u{c03d}', '\u{c057}', GC_LVT), ('\u{c058}', '\u{c058}',
        GC_LV), ('\u{c059}', '\u{c073}', GC_LVT), ('\u{c074}', '\u{c074}', GC_LV), ('\u{c075}',
        '\u{c08f}', GC_LVT), ('\u{c090}', '\u{c090}', GC_LV), ('\u{c091}', '\u{c0ab}', GC_LVT),
        ('\u{c0ac}', '\u{c0ac}', GC_LV), ('\u{c0ad}', '\u{c0c7}', GC_LVT), ('\u{c0c8}', '\u{c0c8}',
        GC_LV), ('\u{c0c9}', '\u{c0e3}', GC_LVT), ('\u{c0e4}', '\u{c0e4}', GC_LV), ('\u{c0e5}',
        '\u{c0ff}', GC_LVT), ('\u{c100}', '\u{c100}', GC_LV), ('\u{c101}', '\u{c11b}', GC_LVT),
        ('\u{c11c}', '\u{c11c}', GC_LV), ('\u{c11d}', '\u{c137}', GC_LVT), ('\u{c138}', '\u{c138}',
        GC_LV), ('\u{c139}', '\u{c153}', GC_LVT), ('\u{c154}', '\u{c154}', GC_LV), ('\u{c155}',
        '\u{c16f}', GC_LVT), ('\u{c170}', '\u{c170}', GC_LV), ('\u{c171}', '\u{c18b}', GC_LVT),
        ('\u{c18c}', '\u{c18c}', GC_LV), ('\u{c18d}', '\u{c1a7}', GC_LVT), ('\u{c1a8}', '\u{c1a8}',
        GC_LV), ('\u{c1a9}', '\u{c1c3}', GC_LVT), ('\u{c1c4}', '\u{c1c4}', GC_LV), ('\u{c1c5}',
        '\u{c1df}', GC_LVT), ('\u{c1e0}', '\u{c1e0}', GC_LV), ('\u{c1e1}', '\u{c1fb}', GC_LVT),
        ('\u{c1fc}', '\u{c1fc}', GC_LV), ('\u{c1fd}', '\u{c217}', GC_LVT), ('\u{c218}', '\u{c218}',
        GC_LV), ('\u{c219}', '\u{c233}', GC_LVT), ('\u{c234}', '\u{c234}', GC_LV), ('\u{c235}',
        '\u{c24f}', GC_LVT), ('\u{c250}', '\u{c250}', GC_LV), ('\u{c251}', '\u{c26b}', GC_LVT),
        ('\u{c26c}', '\u{c26c}', GC_LV), ('\u{c26d}', '\u{c287}', GC_LVT), ('\u{c288}', '\u{c288}',
        GC_LV), ('\u{c289}', '\u{c2a3}', GC_LVT), ('\u{c2a4}', '\u{c2a4}', GC_LV), ('\u{c2a5}',
        '\u{c2bf}', GC_LVT), ('\u{c2c0}', '\u{c2c0}', GC_LV), ('\u{c2c1}', '\u{c2db}', GC_LVT),
        ('\u{c2dc}', '\u{c2dc}', GC_LV), ('\u{c2dd}', '\u{c2f7}', GC_LVT), ('\u{c2f8}', '\u{c2f8}',
        GC_LV), ('\u{c2f9}', '\u{c313}', GC_LVT), ('\u{c314}', '\u{c314}', GC_LV), ('\u{c315}',
        '\u{c32f}', GC_LVT), ('\u{c330}', '\u{c330}', GC_LV), ('\u{c331}', '\u{c34b}', GC_LVT),
        ('\u{c34c}', '\u{c34c}', GC_LV), ('\u{c34d}', '\u{c367}', GC_LVT), ('\u{c368}', '\u{c368}',
        GC_LV), ('\u{c369}', '\u{c383}', GC_LVT), ('\u{c384}', '\u{c384}', GC_LV), ('\u{c385}',
        '\u{c39f}', GC_LVT), ('\u{c3a0}', '\u{c3a0}', GC_LV), ('\u{c3a1}', '\u{c3bb}', GC_LVT),
        ('\u{c3bc}', '\u{c3bc}', GC_LV), ('\u{c3bd}', '\u{c3d7}', GC_LVT), ('\u{c3d8}', '\u{c3d8}',
        GC_LV), ('\u{c3d9}', '\u{c3f3}', GC_LVT), ('\u{c3f4}', '\u{c3f4}', GC_LV), ('\u{c3f5}',
        '\u{c40f}', GC_LVT), ('\u{c410}', '\u{c410}', GC_LV), ('\u{c411}', '\u{c42b}', GC_LVT),
        ('\u{c42c}', '\u{c42c}', GC_LV), ('\u{c42d}', '\u{c447}', GC_LVT), ('\u{c448}', '\u{c448}',
        GC_LV), ('\u{c449}', '\u{c463}', GC_LVT), ('\u{c464}', '\u{c464}', GC_LV), ('\u{c465}',
        '\u{c47f}', GC_LVT), ('\u{c480}', '\u{c480}', GC_LV), ('\u{c481}', '\u{c49b}', GC_LVT),
        ('\u{c49c}', '\u{c49c}', GC_LV), ('\u{c49d}', '\u{c4b7}', GC_LVT), ('\u{c4b8}', '\u{c4b8}',
        GC_LV), ('\u{c4b9}', '\u{c4d3}', GC_LVT), ('\u{c4d4}', '\u{c4d4}', GC_LV), ('\u{c4d5}',
        '\u{c4ef}', GC_LVT), ('\u{c4f0}', '\u{c4f0}', GC_LV), ('\u{c4f1}', '\u{c50b}', GC_LVT),
        ('\u{c50c}', '\u{c50c}', GC_LV), ('\u{c50d}', '\u{c527}', GC_LVT), ('\u{c528}', '\u{c528}',
        GC_LV), ('\u{c529}', '\u{c543}', GC_LVT), ('\u{c544}', '\u{c544}', GC_LV), ('\u{c545}',
        '\u{c55f}', GC_LVT), ('\u{c560}', '\u{c560}', GC_LV), ('\u{c561}', '\u{c57b}', GC_LVT),
        ('\u{c57c}', '\u{c57c}', GC_LV), ('\u{c57d}', '\u{c597}', GC_LVT), ('\u{c598}', '\u{c598}',
        GC_LV), ('\u{c599}', '\u{c5b3}', GC_LVT), ('\u{c5b4}', '\u{c5b4}', GC_LV), ('\u{c5b5}',
        '\u{c5cf}', GC_LVT), ('\u{c5d0}', '\u{c5d0}', GC_LV), ('\u{c5d1}', '\u{c5eb}', GC_LVT),
        ('\u{c5ec}', '\u{c5ec}', GC_LV), ('\u{c5ed}', '\u{c607}', GC_LVT), ('\u{c608}', '\u{c608}',
        GC_LV), ('\u{c609}', '\u{c623}', GC_LVT), ('\u{c624}', '\u{c624}', GC_LV), ('\u{c625}',
        '\u{c63f}', GC_LVT), ('\u{c640}', '\u{c640}', GC_LV), ('\u{c641}', '\u{c65b}', GC_LVT),
        ('\u{c65c}', '\u{c65c}', GC_LV), ('\u{c65d}', '\u{c677}', GC_LVT), ('\u{c678}', '\u{c678}',
        GC_LV), ('\u{c679}', '\u{c693}', GC_LVT), ('\u{c694}', '\u{c694}', GC_LV), ('\u{c695}',
        '\u{c6af}', GC_LVT), ('\u{c6b0}', '\u{c6b0}', GC_LV), ('\u{c6b1}', '\u{c6cb}', GC_LVT),
        ('\u{c6cc}', '\u{c6cc}', GC_LV), ('\u{c6cd}', '\u{c6e7}', GC_LVT), ('\u{c6e8}', '\u{c6e8}',
        GC_LV), ('\u{c6e9}', '\u{c703}', GC_LVT), ('\u{c704}', '\u{c704}', GC_LV), ('\u{c705}',
        '\u{c71f}', GC_LVT), ('\u{c720}', '\u{c720}', GC_LV), ('\u{c721}', '\u{c73b}', GC_LVT),
        ('\u{c73c}', '\u{c73c}', GC_LV), ('\u{c73d}', '\u{c757}', GC_LVT), ('\u{c758}', '\u{c758}',
        GC_LV), ('\u{c759}', '\u{c773}', GC_LVT), ('\u{c774}', '\u{c774}', GC_LV), ('\u{c775}',
        '\u{c78f}', GC_LVT), ('\u{c790}', '\u{c790}', GC_LV), ('\u{c791}', '\u{c7ab}', GC_LVT),
        ('\u{c7ac}', '\u{c7ac}', GC_LV), ('\u{c7ad}', '\u{c7c7}', GC_LVT), ('\u{c7c8}', '\u{c7c8}',
        GC_LV), ('\u{c7c9}', '\u{c7e3}', GC_LVT), ('\u{c7e4}', '\u{c7e4}', GC_LV), ('\u{c7e5}',
        '\u{c7ff}', GC_LVT), ('\u{c800}', '\u{c800}', GC_LV), ('\u{c801}', '\u{c81b}', GC_LVT),
        ('\u{c81c}', '\u{c81c}', GC_LV), ('\u{c81d}', '\u{c837}', GC_LVT), ('\u{c838}', '\u{c838}',
        GC_LV), ('\u{c839}', '\u{c853}', GC_LVT), ('\u{c854}', '\u{c854}', GC_LV), ('\u{c855}',
        '\u{c86f}', GC_LVT), ('\u{c870}', '\u{c870}', GC_LV), ('\u{c871}', '\u{c88b}', GC_LVT),
        ('\u{c88c}', '\u{c88c}', GC_LV), ('\u{c88d}', '\u{c8a7}', GC_LVT), ('\u{c8a8}', '\u{c8a8}',
        GC_LV), ('\u{c8a9}', '\u{c8c3}', GC_LVT), ('\u{c8c4}', '\u{c8c4}', GC_LV), ('\u{c8c5}',
        '\u{c8df}', GC_LVT), ('\u{c8e0}', '\u{c8e0}', GC_LV), ('\u{c8e1}', '\u{c8fb}', GC_LVT),
        ('\u{c8fc}', '\u{c8fc}', GC_LV), ('\u{c8fd}', '\u{c917}', GC_LVT), ('\u{c918}', '\u{c918}',
        GC_LV), ('\u{c919}', '\u{c933}', GC_LVT), ('\u{c934}', '\u{c934}', GC_LV), ('\u{c935}',
        '\u{c94f}', GC_LVT), ('\u{c950}', '\u{c950}', GC_LV), ('\u{c951}', '\u{c96b}', GC_LVT),
        ('\u{c96c}', '\u{c96c}', GC_LV), ('\u{c96d}', '\u{c987}', GC_LVT), ('\u{c988}', '\u{c988}',
        GC_LV), ('\u{c989}', '\u{c9a3}', GC_LVT), ('\u{c9a4}', '\u{c9a4}', GC_LV), ('\u{c9a5}',
        '\u{c9bf}', GC_LVT), ('\u{c9c0}', '\u{c9c0}', GC_LV), ('\u{c9c1}', '\u{c9db}', GC_LVT),
        ('\u{c9dc}', '\u{c9dc}', GC_LV), ('\u{c9dd}', '\u{c9f7}', GC_LVT), ('\u{c9f8}', '\u{c9f8}',
        GC_LV), ('\u{c9f9}', '\u{ca13}', GC_LVT), ('\u{ca14}', '\u{ca14}', GC_LV), ('\u{ca15}',
        '\u{ca2f}', GC_LVT), ('\u{ca30}', '\u{ca30}', GC_LV), ('\u{ca31}', '\u{ca4b}', GC_LVT),
        ('\u{ca4c}', '\u{ca4c}', GC_LV), ('\u{ca4d}', '\u{ca67}', GC_LVT), ('\u{ca68}', '\u{ca68}',
        GC_LV), ('\u{ca69}', '\u{ca83}', GC_LVT), ('\u{ca84}', '\u{ca84}', GC_LV), ('\u{ca85}',
        '\u{ca9f}', GC_LVT), ('\u{caa0}', '\u{caa0}', GC_LV), ('\u{caa1}', '\u{cabb}', GC_LVT),
        ('\u{cabc}', '\u{cabc}', GC_LV), ('\u{cabd}', '\u{cad7}', GC_LVT), ('\u{cad8}', '\u{cad8}',
        GC_LV), ('\u{cad9}', '\u{caf3}', GC_LVT), ('\u{caf4}', '\u{caf4}', GC_LV), ('\u{caf5}',
        '\u{cb0f}', GC_LVT), ('\u{cb10}', '\u{cb10}', GC_LV), ('\u{cb11}', '\u{cb2b}', GC_LVT),
        ('\u{cb2c}', '\u{cb2c}', GC_LV), ('\u{cb2d}', '\u{cb47}', GC_LVT), ('\u{cb48}', '\u{cb48}',
        GC_LV), ('\u{cb49}', '\u{cb63}', GC_LVT), ('\u{cb64}', '\u{cb64}', GC_LV), ('\u{cb65}',
        '\u{cb7f}', GC_LVT), ('\u{cb80}', '\u{cb80}', GC_LV), ('\u{cb81}', '\u{cb9b}', GC_LVT),
        ('\u{cb9c}', '\u{cb9c}', GC_LV), ('\u{cb9d}', '\u{cbb7}', GC_LVT), ('\u{cbb8}', '\u{cbb8}',
        GC_LV), ('\u{cbb9}', '\u{cbd3}', GC_LVT), ('\u{cbd4}', '\u{cbd4}', GC_LV), ('\u{cbd5}',
        '\u{cbef}', GC_LVT), ('\u{cbf0}', '\u{cbf0}', GC_LV), ('\u{cbf1}', '\u{cc0b}', GC_LVT),
        ('\u{cc0c}', '\u{cc0c}', GC_LV), ('\u{cc0d}', '\u{cc27}', GC_LVT), ('\u{cc28}', '\u{cc28}',
        GC_LV), ('\u{cc29}', '\u{cc43}', GC_LVT), ('\u{cc44}', '\u{cc44}', GC_LV), ('\u{cc45}',
        '\u{cc5f}', GC_LVT), ('\u{cc60}', '\u{cc60}', GC_LV), ('\u{cc61}', '\u{cc7b}', GC_LVT),
        ('\u{cc7c}', '\u{cc7c}', GC_LV), ('\u{cc7d}', '\u{cc97}', GC_LVT), ('\u{cc98}', '\u{cc98}',
        GC_LV), ('\u{cc99}', '\u{ccb3}', GC_LVT), ('\u{ccb4}', '\u{ccb4}', GC_LV), ('\u{ccb5}',
        '\u{cccf}', GC_LVT), ('\u{ccd0}', '\u{ccd0}', GC_LV), ('\u{ccd1}', '\u{cceb}', GC_LVT),
        ('\u{ccec}', '\u{ccec}', GC_LV), ('\u{cced}', '\u{cd07}', GC_LVT), ('\u{cd08}', '\u{cd08}',
        GC_LV), ('\u{cd09}', '\u{cd23}', GC_LVT), ('\u{cd24}', '\u{cd24}', GC_LV), ('\u{cd25}',
        '\u{cd3f}', GC_LVT), ('\u{cd40}', '\u{cd40}', GC_LV), ('\u{cd41}', '\u{cd5b}', GC_LVT),
        ('\u{cd5c}', '\u{cd5c}', GC_LV), ('\u{cd5d}', '\u{cd77}', GC_LVT), ('\u{cd78}', '\u{cd78}',
        GC_LV), ('\u{cd79}', '\u{cd93}', GC_LVT), ('\u{cd94}', '\u{cd94}', GC_LV), ('\u{cd95}',
        '\u{cdaf}', GC_LVT), ('\u{cdb0}', '\u{cdb0}', GC_LV), ('\u{cdb1}', '\u{cdcb}', GC_LVT),
        ('\u{cdcc}', '\u{cdcc}', GC_LV), ('\u{cdcd}', '\u{cde7}', GC_LVT), ('\u{cde8}', '\u{cde8}',
        GC_LV), ('\u{cde9}', '\u{ce03}', GC_LVT), ('\u{ce04}', '\u{ce04}', GC_LV), ('\u{ce05}',
        '\u{ce1f}', GC_LVT), ('\u{ce20}', '\u{ce20}', GC_LV), ('\u{ce21}', '\u{ce3b}', GC_LVT),
        ('\u{ce3c}', '\u{ce3c}', GC_LV), ('\u{ce3d}', '\u{ce57}', GC_LVT), ('\u{ce58}', '\u{ce58}',
        GC_LV), ('\u{ce59}', '\u{ce73}', GC_LVT), ('\u{ce74}', '\u{ce74}', GC_LV), ('\u{ce75}',
        '\u{ce8f}', GC_LVT), ('\u{ce90}', '\u{ce90}', GC_LV), ('\u{ce91}', '\u{ceab}', GC_LVT),
        ('\u{ceac}', '\u{ceac}', GC_LV), ('\u{cead}', '\u{cec7}', GC_LVT), ('\u{cec8}', '\u{cec8}',
        GC_LV), ('\u{cec9}', '\u{cee3}', GC_LVT), ('\u{cee4}', '\u{cee4}', GC_LV), ('\u{cee5}',
        '\u{ceff}', GC_LVT), ('\u{cf00}', '\u{cf00}', GC_LV), ('\u{cf01}', '\u{cf1b}', GC_LVT),
        ('\u{cf1c}', '\u{cf1c}', GC_LV), ('\u{cf1d}', '\u{cf37}', GC_LVT), ('\u{cf38}', '\u{cf38}',
        GC_LV), ('\u{cf39}', '\u{cf53}', GC_LVT), ('\u{cf54}', '\u{cf54}', GC_LV), ('\u{cf55}',
        '\u{cf6f}', GC_LVT), ('\u{cf70}', '\u{cf70}', GC_LV), ('\u{cf71}', '\u{cf8b}', GC_LVT),
        ('\u{cf8c}', '\u{cf8c}', GC_LV), ('\u{cf8d}', '\u{cfa7}', GC_LVT), ('\u{cfa8}', '\u{cfa8}',
        GC_LV), ('\u{cfa9}', '\u{cfc3}', GC_LVT), ('\u{cfc4}', '\u{cfc4}', GC_LV), ('\u{cfc5}',
        '\u{cfdf}', GC_LVT), ('\u{cfe0}', '\u{cfe0}', GC_LV), ('\u{cfe1}', '\u{cffb}', GC_LVT),
        ('\u{cffc}', '\u{cffc}', GC_LV), ('\u{cffd}', '\u{d017}', GC_LVT), ('\u{d018}', '\u{d018}',
        GC_LV), ('\u{d019}', '\u{d033}', GC_LVT), ('\u{d034}', '\u{d034}', GC_LV), ('\u{d035}',
        '\u{d04f}', GC_LVT), ('\u{d050}', '\u{d050}', GC_LV), ('\u{d051}', '\u{d06b}', GC_LVT),
        ('\u{d06c}', '\u{d06c}', GC_LV), ('\u{d06d}', '\u{d087}', GC_LVT), ('\u{d088}', '\u{d088}',
        GC_LV), ('\u{d089}', '\u{d0a3}', GC_LVT), ('\u{d0a4}', '\u{d0a4}', GC_LV), ('\u{d0a5}',
        '\u{d0bf}', GC_LVT), ('\u{d0c0}', '\u{d0c0}', GC_LV), ('\u{d0c1}', '\u{d0db}', GC_LVT),
        ('\u{d0dc}', '\u{d0dc}', GC_LV), ('\u{d0dd}', '\u{d0f7}', GC_LVT), ('\u{d0f8}', '\u{d0f8}',
        GC_LV), ('\u{d0f9}', '\u{d113}', GC_LVT), ('\u{d114}', '\u{d114}', GC_LV), ('\u{d115}',
        '\u{d12f}', GC_LVT), ('\u{d130}', '\u{d130}', GC_LV), ('\u{d131}', '\u{d14b}', GC_LVT),
        ('\u{d14c}', '\u{d14c}', GC_LV), ('\u{d14d}', '\u{d167}', GC_LVT), ('\u{d168}', '\u{d168}',
        GC_LV), ('\u{d169}', '\u{d183}', GC_LVT), ('\u{d184}', '\u{d184}', GC_LV), ('\u{d185}',
        '\u{d19f}', GC_LVT), ('\u{d1a0}', '\u{d1a0}', GC_LV), ('\u{d1a1}', '\u{d1bb}', GC_LVT),
        ('\u{d1bc}', '\u{d1bc}', GC_LV), ('\u{d1bd}', '\u{d1d7}', GC_LVT), ('\u{d1d8}', '\u{d1d8}',
        GC_LV), ('\u{d1d9}', '\u{d1f3}', GC_LVT), ('\u{d1f4}', '\u{d1f4}', GC_LV), ('\u{d1f5}',
        '\u{d20f}', GC_LVT), ('\u{d210}', '\u{d210}', GC_LV), ('\u{d211}', '\u{d22b}', GC_LVT),
        ('\u{d22c}', '\u{d22c}', GC_LV), ('\u{d22d}', '\u{d247}', GC_LVT), ('\u{d248}', '\u{d248}',
        GC_LV), ('\u{d249}', '\u{d263}', GC_LVT), ('\u{d264}', '\u{d264}', GC_LV), ('\u{d265}',
        '\u{d27f}', GC_LVT), ('\u{d280}', '\u{d280}', GC_LV), ('\u{d281}', '\u{d29b}', GC_LVT),
        ('\u{d29c}', '\u{d29c}', GC_LV), ('\u{d29d}', '\u{d2b7}', GC_LVT), ('\u{d2b8}', '\u{d2b8}',
        GC_LV), ('\u{d2b9}', '\u{d2d3}', GC_LVT), ('\u{d2d4}', '\u{d2d4}', GC_LV), ('\u{d2d5}',
        '\u{d2ef}', GC_LVT), ('\u{d2f0}', '\u{d2f0}', GC_LV), ('\u{d2f1}', '\u{d30b}', GC_LVT),
        ('\u{d30c}', '\u{d30c}', GC_LV), ('\u{d30d}', '\u{d327}', GC_LVT), ('\u{d328}', '\u{d328}',
        GC_LV), ('\u{d329}', '\u{d343}', GC_LVT), ('\u{d344}', '\u{d344}', GC_LV), ('\u{d345}',
        '\u{d35f}', GC_LVT), ('\u{d360}', '\u{d360}', GC_LV), ('\u{d361}', '\u{d37b}', GC_LVT),
        ('\u{d37c}', '\u{d37c}', GC_LV), ('\u{d37d}', '\u{d397}', GC_LVT), ('\u{d398}', '\u{d398}',
        GC_LV), ('\u{d399}', '\u{d3b3}', GC_LVT), ('\u{d3b4}', '\u{d3b4}', GC_LV), ('\u{d3b5}',
        '\u{d3cf}', GC_LVT), ('\u{d3d0}', '\u{d3d0}', GC_LV), ('\u{d3d1}', '\u{d3eb}', GC_LVT),
        ('\u{d3ec}', '\u{d3ec}', GC_LV), ('\u{d3ed}', '\u{d407}', GC_LVT), ('\u{d408}', '\u{d408}',
        GC_LV), ('\u{d409}', '\u{d423}', GC_LVT), ('\u{d424}', '\u{d424}', GC_LV), ('\u{d425}',
        '\u{d43f}', GC_LVT), ('\u{d440}', '\u{d440}', GC_LV), ('\u{d441}', '\u{d45b}', GC_LVT),
        ('\u{d45c}', '\u{d45c}', GC_LV), ('\u{d45d}', '\u{d477}', GC_LVT), ('\u{d478}', '\u{d478}',
        GC_LV), ('\u{d479}', '\u{d493}', GC_LVT), ('\u{d494}', '\u{d494}', GC_LV), ('\u{d495}',
        '\u{d4af}', GC_LVT), ('\u{d4b0}', '\u{d4b0}', GC_LV), ('\u{d4b1}', '\u{d4cb}', GC_LVT),
        ('\u{d4cc}', '\u{d4cc}', GC_LV), ('\u{d4cd}', '\u{d4e7}', GC_LVT), ('\u{d4e8}', '\u{d4e8}',
        GC_LV), ('\u{d4e9}', '\u{d503}', GC_LVT), ('\u{d504}', '\u{d504}', GC_LV), ('\u{d505}',
        '\u{d51f}', GC_LVT), ('\u{d520}', '\u{d520}', GC_LV), ('\u{d521}', '\u{d53b}', GC_LVT),
        ('\u{d53c}', '\u{d53c}', GC_LV), ('\u{d53d}', '\u{d557}', GC_LVT), ('\u{d558}', '\u{d558}',
        GC_LV), ('\u{d559}', '\u{d573}', GC_LVT), ('\u{d574}', '\u{d574}', GC_LV), ('\u{d575}',
        '\u{d58f}', GC_LVT), ('\u{d590}', '\u{d590}', GC_LV), ('\u{d591}', '\u{d5ab}', GC_LVT),
        ('\u{d5ac}', '\u{d5ac}', GC_LV), ('\u{d5ad}', '\u{d5c7}', GC_LVT), ('\u{d5c8}', '\u{d5c8}',
        GC_LV), ('\u{d5c9}', '\u{d5e3}', GC_LVT), ('\u{d5e4}', '\u{d5e4}', GC_LV), ('\u{d5e5}',
        '\u{d5ff}', GC_LVT), ('\u{d600}', '\u{d600}', GC_LV), ('\u{d601}', '\u{d61b}', GC_LVT),
        ('\u{d61c}', '\u{d61c}', GC_LV), ('\u{d61d}', '\u{d637}', GC_LVT), ('\u{d638}', '\u{d638}',
        GC_LV), ('\u{d639}', '\u{d653}', GC_LVT), ('\u{d654}', '\u{d654}', GC_LV), ('\u{d655}',
        '\u{d66f}', GC_LVT), ('\u{d670}', '\u{d670}', GC_LV), ('\u{d671}', '\u{d68b}', GC_LVT),
        ('\u{d68c}', '\u{d68c}', GC_LV), ('\u{d68d}', '\u{d6a7}', GC_LVT), ('\u{d6a8}', '\u{d6a8}',
        GC_LV), ('\u{d6a9}', '\u{d6c3}', GC_LVT), ('\u{d6c4}', '\u{d6c4}', GC_LV), ('\u{d6c5}',
        '\u{d6df}', GC_LVT), ('\u{d6e0}', '\u{d6e0}', GC_LV), ('\u{d6e1}', '\u{d6fb}', GC_LVT),
        ('\u{d6fc}', '\u{d6fc}', GC_LV), ('\u{d6fd}', '\u{d717}', GC_LVT), ('\u{d718}', '\u{d718}',
        GC_LV), ('\u{d719}', '\u{d733}', GC_LVT), ('\u{d734}', '\u{d734}', GC_LV), ('\u{d735}',
        '\u{d74f}', GC_LVT), ('\u{d750}', '\u{d750}', GC_LV), ('\u{d751}', '\u{d76b}', GC_LVT),
        ('\u{d76c}', '\u{d76c}', GC_LV), ('\u{d76d}', '\u{d787}', GC_LVT), ('\u{d788}', '\u{d788}',
        GC_LV), ('\u{d789}', '\u{d7a3}', GC_LVT), ('\u{d7b0}', '\u{d7c6}', GC_V), ('\u{d7cb}',
        '\u{d7fb}', GC_T), ('\u{fb1e}', '\u{fb1e}', GC_Extend), ('\u{fe00}', '\u{fe0f}', GC_Extend),
        ('\u{fe20}', '\u{fe2d}', GC_Extend), ('\u{feff}', '\u{feff}', GC_Control), ('\u{ff9e}',
        '\u{ff9f}', GC_Extend), ('\u{fff0}', '\u{fffb}', GC_Control), ('\u{101fd}', '\u{101fd}',
        GC_Extend), ('\u{102e0}', '\u{102e0}', GC_Extend), ('\u{10376}', '\u{1037a}', GC_Extend),
        ('\u{10a01}', '\u{10a03}', GC_Extend), ('\u{10a05}', '\u{10a06}', GC_Extend), ('\u{10a0c}',
        '\u{10a0f}', GC_Extend), ('\u{10a38}', '\u{10a3a}', GC_Extend), ('\u{10a3f}', '\u{10a3f}',
        GC_Extend), ('\u{10ae5}', '\u{10ae6}', GC_Extend), ('\u{11000}', '\u{11000}',
        GC_SpacingMark), ('\u{11001}', '\u{11001}', GC_Extend), ('\u{11002}', '\u{11002}',
        GC_SpacingMark), ('\u{11038}', '\u{11046}', GC_Extend), ('\u{1107f}', '\u{11081}',
        GC_Extend), ('\u{11082}', '\u{11082}', GC_SpacingMark), ('\u{110b0}', '\u{110b2}',
        GC_SpacingMark), ('\u{110b3}', '\u{110b6}', GC_Extend), ('\u{110b7}', '\u{110b8}',
        GC_SpacingMark), ('\u{110b9}', '\u{110ba}', GC_Extend), ('\u{110bd}', '\u{110bd}',
        GC_Control), ('\u{11100}', '\u{11102}', GC_Extend), ('\u{11127}', '\u{1112b}', GC_Extend),
        ('\u{1112c}', '\u{1112c}', GC_SpacingMark), ('\u{1112d}', '\u{11134}', GC_Extend),
        ('\u{11173}', '\u{11173}', GC_Extend), ('\u{11180}', '\u{11181}', GC_Extend), ('\u{11182}',
        '\u{11182}', GC_SpacingMark), ('\u{111b3}', '\u{111b5}', GC_SpacingMark), ('\u{111b6}',
        '\u{111be}', GC_Extend), ('\u{111bf}', '\u{111c0}', GC_SpacingMark), ('\u{1122c}',
        '\u{1122e}', GC_SpacingMark), ('\u{1122f}', '\u{11231}', GC_Extend), ('\u{11232}',
        '\u{11233}', GC_SpacingMark), ('\u{11234}', '\u{11234}', GC_Extend), ('\u{11235}',
        '\u{11235}', GC_SpacingMark), ('\u{11236}', '\u{11237}', GC_Extend), ('\u{112df}',
        '\u{112df}', GC_Extend), ('\u{112e0}', '\u{112e2}', GC_SpacingMark), ('\u{112e3}',
        '\u{112ea}', GC_Extend), ('\u{11301}', '\u{11301}', GC_Extend), ('\u{11302}', '\u{11303}',
        GC_SpacingMark), ('\u{1133c}', '\u{1133c}', GC_Extend), ('\u{1133e}', '\u{1133e}',
        GC_Extend), ('\u{1133f}', '\u{1133f}', GC_SpacingMark), ('\u{11340}', '\u{11340}',
        GC_Extend), ('\u{11341}', '\u{11344}', GC_SpacingMark), ('\u{11347}', '\u{11348}',
        GC_SpacingMark), ('\u{1134b}', '\u{1134d}', GC_SpacingMark), ('\u{11357}', '\u{11357}',
        GC_Extend), ('\u{11362}', '\u{11363}', GC_SpacingMark), ('\u{11366}', '\u{1136c}',
        GC_Extend), ('\u{11370}', '\u{11374}', GC_Extend), ('\u{114b0}', '\u{114b0}', GC_Extend),
        ('\u{114b1}', '\u{114b2}', GC_SpacingMark), ('\u{114b3}', '\u{114b8}', GC_Extend),
        ('\u{114b9}', '\u{114b9}', GC_SpacingMark), ('\u{114ba}', '\u{114ba}', GC_Extend),
        ('\u{114bb}', '\u{114bc}', GC_SpacingMark), ('\u{114bd}', '\u{114bd}', GC_Extend),
        ('\u{114be}', '\u{114be}', GC_SpacingMark), ('\u{114bf}', '\u{114c0}', GC_Extend),
        ('\u{114c1}', '\u{114c1}', GC_SpacingMark), ('\u{114c2}', '\u{114c3}', GC_Extend),
        ('\u{115af}', '\u{115af}', GC_Extend), ('\u{115b0}', '\u{115b1}', GC_SpacingMark),
        ('\u{115b2}', '\u{115b5}', GC_Extend), ('\u{115b8}', '\u{115bb}', GC_SpacingMark),
        ('\u{115bc}', '\u{115bd}', GC_Extend), ('\u{115be}', '\u{115be}', GC_SpacingMark),
        ('\u{115bf}', '\u{115c0}', GC_Extend), ('\u{11630}', '\u{11632}', GC_SpacingMark),
        ('\u{11633}', '\u{1163a}', GC_Extend), ('\u{1163b}', '\u{1163c}', GC_SpacingMark),
        ('\u{1163d}', '\u{1163d}', GC_Extend), ('\u{1163e}', '\u{1163e}', GC_SpacingMark),
        ('\u{1163f}', '\u{11640}', GC_Extend), ('\u{116ab}', '\u{116ab}', GC_Extend), ('\u{116ac}',
        '\u{116ac}', GC_SpacingMark), ('\u{116ad}', '\u{116ad}', GC_Extend), ('\u{116ae}',
        '\u{116af}', GC_SpacingMark), ('\u{116b0}', '\u{116b5}', GC_Extend), ('\u{116b6}',
        '\u{116b6}', GC_SpacingMark), ('\u{116b7}', '\u{116b7}', GC_Extend), ('\u{16af0}',
        '\u{16af4}', GC_Extend), ('\u{16b30}', '\u{16b36}', GC_Extend), ('\u{16f51}', '\u{16f7e}',
        GC_SpacingMark), ('\u{16f8f}', '\u{16f92}', GC_Extend), ('\u{1bc9d}', '\u{1bc9e}',
        GC_Extend), ('\u{1bca0}', '\u{1bca3}', GC_Control), ('\u{1d165}', '\u{1d165}', GC_Extend),
        ('\u{1d166}', '\u{1d166}', GC_SpacingMark), ('\u{1d167}', '\u{1d169}', GC_Extend),
        ('\u{1d16d}', '\u{1d16d}', GC_SpacingMark), ('\u{1d16e}', '\u{1d172}', GC_Extend),
        ('\u{1d173}', '\u{1d17a}', GC_Control), ('\u{1d17b}', '\u{1d182}', GC_Extend), ('\u{1d185}',
        '\u{1d18b}', GC_Extend), ('\u{1d1aa}', '\u{1d1ad}', GC_Extend), ('\u{1d242}', '\u{1d244}',
        GC_Extend), ('\u{1e8d0}', '\u{1e8d6}', GC_Extend), ('\u{1f1e6}', '\u{1f1ff}',
        GC_RegionalIndicator), ('\u{e0000}', '\u{e00ff}', GC_Control), ('\u{e0100}', '\u{e01ef}',
        GC_Extend), ('\u{e01f0}', '\u{e0fff}', GC_Control)
    ];

}
