// Copyright 2014 The Rust Project Developers. See the COPYRIGHT
// file at the top-level directory of this distribution and at
// http://rust-lang.org/COPYRIGHT.
//
// Licensed under the Apache License, Version 2.0 <LICENSE-APACHE or
// http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your
// option. This file may not be copied, modified, or distributed
// except according to those terms.

// ignore-stage1

#![feature(phase)]

extern crate regex;
#[phase(plugin)] extern crate regex_macros;

#[deny(unused_variables)]
#[deny(dead_code)]
#[allow(non_upper_case_globals)]

// Tests to make sure that extraneous dead code warnings aren't emitted from
// the code generated by regex!.
//
// The warning used for `static` items seems to be dead_code, which is why this
// is a distinct test from using a normal let binding (which generates an
// unused variable warning).

fn main() {
    static fubar: regex::Regex = regex!("abc"); //~ ERROR static item is never used: `fubar`
}
