% Rust Documentation

Welcome to the Rust documentation! You can use the section headings above
to jump to any particular section.

# Getting Started

If you haven't seen Rust at all yet, the first thing you should read is the [30
minute intro](intro.html). It will give you an overview of the basic ideas of Rust
at a high level.

Once you know you really want to learn Rust, the next step is reading [the
guide](guide.html). It is a lengthy explanation of Rust, its syntax, and its
concepts. Upon completing the guide, you'll be an intermediate Rust developer,
and will have a good grasp of the fundamental ideas behind Rust.

# Community & Getting Help

If you need help with something, or just want to talk about Rust with others,
there's a few places you can do that:

The Rust IRC channels on [irc.mozilla.org](http://irc.mozilla.org/) are the
fastest way to get help.
[`#rust`](http://chat.mibbit.com/?server=irc.mozilla.org&channel=%23rust) is
the general discussion channel, and you'll find people willing to help you with
any questions you may have.

There are also three specialty channels:
[`#rust-gamedev`](http://chat.mibbit.com/?server=irc.mozilla.org&channel=%23rust-gamedev)
and
[`#rust-osdev`](http://chat.mibbit.com/?server=irc.mozilla.org&channel=%23rust-osdev)
are for game development and operating system development, respectively.
There's also
[`#rust-internals`](http://chat.mibbit.com/?server=irc.mozilla.org&channel=%23rust-internals), which is for discussion of the development of Rust itself.

You can also get help on [Stack
Overflow](http://stackoverflow.com/questions/tagged/rust). Searching for your
problem might reveal someone who has asked it before!

There is an active [subreddit](http://reddit.com/r/rust) with lots of
discussion about Rust.

There is also a [developer forum](http://discuss.rust-lang.org/), where the
development of Rust itself is discussed.

# Specification

Rust does not have an exact specification, but an effort to describe as much of
the language in as much detail as possible is in [the reference](reference.html).

# Guides

Rust Guides are in-depth looks at a particular topic that's relevant to Rust
development. If you're trying to figure out how to do something, there may be
a guide that can help you out:

* [Ownership](guide-ownership.html)
* [Strings](guide-strings.html)
* [Pointers](guide-pointers.html)
* [Crates and modules](guide-crates.html)
* [Threads and Communication](guide-threads.html)
* [Error Handling](guide-error-handling.html)
* [Foreign Function Interface](guide-ffi.html)
* [Writing Unsafe and Low-Level Code](guide-unsafe.html)
* [Macros](guide-macros.html)
* [Testing](guide-testing.html)
* [Compiler Plugins](guide-plugin.html)

# Tools

Rust's still a young language, so there isn't a ton of tooling yet, but the
tools we have are really nice.

[Cargo](http://crates.io) is Rust's package manager, and its website contains
lots of good documentation.

[The `rustdoc` manual](rustdoc.html) contains information about Rust's
documentation tool.

# FAQs

There are questions that are asked quite often, and so we've made FAQs for them:

* [Language Design FAQ](complement-design-faq.html)
* [Language FAQ](complement-lang-faq.html)
* [Project FAQ](complement-project-faq.html)
* [How to submit a bug report](complement-bugreport.html)

# The standard library

We have [API documentation for the entire standard
library](std/index.html). There's a list of crates on the left with more
specific sections, or you can use the search bar at the top to search for
something if you know its name.

# External documentation

*Note: While these are great resources for learning Rust, they may track a
particular version of Rust that is likely not exactly the same as that for
which this documentation was generated.*

* [Rust by Example] - Short examples of common tasks in Rust (tracks the master
  branch).
* [Rust for Rubyists] - The first community tutorial for Rust. Tracks the last
  stable release. Not just for Ruby programmers.

[Rust by Example]: http://rustbyexample.com/
[Rust for Rubyists]: http://www.rustforrubyists.com/
