var searchIndex = {};
searchIndex["alloc"] = {"doc":"The Rust core allocation and collections library","items":[[4,"Bound","alloc","An endpoint of a range of keys.",null,null],[13,"Included","","An inclusive bound.",0,null],[13,"Excluded","","An exclusive bound.",0,null],[13,"Unbounded","","An infinite endpoint. Indicates that there is no bound in this direction.",0,null],[0,"allocator","","",null,null],[3,"Excess","alloc::allocator","Represents the combination of a starting address and a total capacity of the returned block.",null,null],[12,"0","","",1,null],[12,"1","","",1,null],[3,"Layout","","Layout of a block of memory.",null,null],[3,"CannotReallocInPlace","","The `CannotReallocInPlace` error is used when `grow_in_place` or `shrink_in_place` were unable to reuse the given memory block for a requested layout.",null,null],[4,"AllocErr","","The `AllocErr` error specifies whether an allocation failure is specifically due to resource exhaustion or if it is due to something wrong when combining the given input arguments with this allocator.",null,null],[13,"Exhausted","","Error due to hitting some resource limit or otherwise running out of memory. This condition strongly implies that some series of deallocations would allow a subsequent reissuing of the original allocation request to succeed.",2,null],[12,"request","alloc::allocator::AllocErr","",2,null],[13,"Unsupported","alloc::allocator","Error due to allocator being fundamentally incapable of satisfying the original request. This condition implies that such an allocation request will never succeed on the given allocator, regardless of environment, memory pressure, or other contextual conditions.",2,null],[12,"details","alloc::allocator::AllocErr","",2,null],[8,"Alloc","alloc::allocator","An implementation of `Alloc` can allocate, reallocate, and deallocate arbitrary blocks of data described via `Layout`.",null,null],[10,"alloc","","Returns a pointer meeting the size and alignment guarantees of `layout`.",3,{"inputs":[{"name":"self"},{"name":"layout"}],"output":{"name":"result"}}],[10,"dealloc","","Deallocate the memory referenced by `ptr`.",3,null],[11,"oom","","Allocator-specific method for signaling an out-of-memory condition.",3,null],[11,"usable_size","","Returns bounds on the guaranteed usable size of a successful allocation created with the specified `layout`.",3,null],[11,"realloc","","Returns a pointer suitable for holding data described by `new_layout`, meeting its size and alignment guarantees. To accomplish this, this may extend or shrink the allocation referenced by `ptr` to fit `new_layout`.",3,null],[11,"alloc_zeroed","","Behaves like `alloc`, but also ensures that the contents are set to zero before being returned.",3,{"inputs":[{"name":"self"},{"name":"layout"}],"output":{"name":"result"}}],[11,"alloc_excess","","Behaves like `alloc`, but also returns the whole size of the returned block. For some `layout` inputs, like arrays, this may include extra storage usable for additional data.",3,{"inputs":[{"name":"self"},{"name":"layout"}],"output":{"name":"result"}}],[11,"realloc_excess","","Behaves like `realloc`, but also returns the whole size of the returned block. For some `layout` inputs, like arrays, this may include extra storage usable for additional data.",3,null],[11,"grow_in_place","","Attempts to extend the allocation referenced by `ptr` to fit `new_layout`.",3,null],[11,"shrink_in_place","","Attempts to shrink the allocation referenced by `ptr` to fit `new_layout`.",3,null],[11,"alloc_one","","Allocates a block suitable for holding an instance of `T`.",3,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"dealloc_one","","Deallocates a block suitable for holding an instance of `T`.",3,{"inputs":[{"name":"self"},{"name":"unique"}],"output":null}],[11,"alloc_array","","Allocates a block suitable for holding `n` instances of `T`.",3,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"result"}}],[11,"realloc_array","","Reallocates a block previously suitable for holding `n_old` instances of `T`, returning a block suitable for holding `n_new` instances of `T`.",3,{"inputs":[{"name":"self"},{"name":"unique"},{"name":"usize"},{"name":"usize"}],"output":{"name":"result"}}],[11,"dealloc_array","","Deallocates a block suitable for holding `n` instances of `T`.",3,{"inputs":[{"name":"self"},{"name":"unique"},{"name":"usize"}],"output":{"name":"result"}}],[11,"fmt","","",1,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",4,{"inputs":[{"name":"self"}],"output":{"name":"layout"}}],[11,"fmt","","",4,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",4,{"inputs":[{"name":"self"},{"name":"layout"}],"output":{"name":"bool"}}],[11,"ne","","",4,{"inputs":[{"name":"self"},{"name":"layout"}],"output":{"name":"bool"}}],[11,"from_size_align","","Constructs a `Layout` from a given `size` and `align`, or returns `None` if any of the following conditions are not met:",4,{"inputs":[{"name":"usize"},{"name":"usize"}],"output":{"name":"option"}}],[11,"from_size_align_unchecked","","Creates a layout, bypassing all checks.",4,{"inputs":[{"name":"usize"},{"name":"usize"}],"output":{"name":"layout"}}],[11,"size","","The minimum size in bytes for a memory block of this layout.",4,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"align","","The minimum byte alignment for a memory block of this layout.",4,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"new","","Constructs a `Layout` suitable for holding a value of type `T`.",4,{"inputs":[],"output":{"name":"self"}}],[11,"for_value","","Produces layout describing a record that could be used to allocate backing structure for `T` (which could be a trait or other unsized type like a slice).",4,{"inputs":[{"name":"t"}],"output":{"name":"self"}}],[11,"align_to","","Creates a layout describing the record that can hold a value of the same layout as `self`, but that also is aligned to alignment `align` (measured in bytes).",4,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"self"}}],[11,"padding_needed_for","","Returns the amount of padding we must insert after `self` to ensure that the following address will satisfy `align` (measured in bytes).",4,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"usize"}}],[11,"repeat","","Creates a layout describing the record for `n` instances of `self`, with a suitable amount of padding between each to ensure that each instance is given its requested size and alignment. On success, returns `(k, offs)` where `k` is the layout of the array and `offs` is the distance between the start of each element in the array.",4,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"extend","","Creates a layout describing the record for `self` followed by `next`, including any necessary padding to ensure that `next` will be properly aligned. Note that the result layout will satisfy the alignment properties of both `self` and `next`.",4,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"option"}}],[11,"repeat_packed","","Creates a layout describing the record for `n` instances of `self`, with no padding between each instance.",4,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"extend_packed","","Creates a layout describing the record for `self` followed by `next` with no additional padding between the two. Since no padding is inserted, the alignment of `next` is irrelevant, and is not incorporated at all into the resulting layout.",4,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"option"}}],[11,"array","","Creates a layout describing the record for a `[T; n]`.",4,{"inputs":[{"name":"usize"}],"output":{"name":"option"}}],[11,"clone","","",2,{"inputs":[{"name":"self"}],"output":{"name":"allocerr"}}],[11,"eq","","",2,{"inputs":[{"name":"self"},{"name":"allocerr"}],"output":{"name":"bool"}}],[11,"ne","","",2,{"inputs":[{"name":"self"},{"name":"allocerr"}],"output":{"name":"bool"}}],[11,"fmt","","",2,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"invalid_input","","",2,{"inputs":[{"name":"str"}],"output":{"name":"self"}}],[11,"is_memory_exhausted","","",2,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_request_unsupported","","",2,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"description","","",2,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"fmt","","",2,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",5,{"inputs":[{"name":"self"}],"output":{"name":"cannotreallocinplace"}}],[11,"eq","","",5,{"inputs":[{"name":"self"},{"name":"cannotreallocinplace"}],"output":{"name":"bool"}}],[11,"fmt","","",5,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"description","","",5,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"fmt","","",5,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[0,"heap","alloc","",null,null],[3,"Heap","alloc::heap","",null,null],[17,"EMPTY","","An arbitrary non-null address to represent zero-size allocations.",null,null],[11,"clone","","",6,{"inputs":[{"name":"self"}],"output":{"name":"heap"}}],[11,"default","","",6,{"inputs":[],"output":{"name":"heap"}}],[11,"fmt","","",6,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"alloc","","",6,{"inputs":[{"name":"self"},{"name":"layout"}],"output":{"name":"result"}}],[11,"oom","","",6,null],[11,"dealloc","","",6,null],[11,"usable_size","","",6,null],[11,"realloc","","",6,null],[11,"alloc_zeroed","","",6,{"inputs":[{"name":"self"},{"name":"layout"}],"output":{"name":"result"}}],[11,"alloc_excess","","",6,{"inputs":[{"name":"self"},{"name":"layout"}],"output":{"name":"result"}}],[11,"realloc_excess","","",6,null],[11,"grow_in_place","","",6,null],[11,"shrink_in_place","","",6,null],[0,"boxed","alloc","A pointer type for heap allocation.",null,null],[3,"ExchangeHeapSingleton","alloc::boxed","This the singleton type used solely for `boxed::HEAP`.",null,null],[3,"Box","","A pointer type for heap allocation.",null,null],[3,"IntermediateBox","","`IntermediateBox` represents uninitialized backing storage for `Box`.",null,null],[17,"HEAP","","A value that represents the heap. This is the default place that the `box` keyword allocates into when no place is supplied.",null,null],[8,"FnBox","","`FnBox` is a version of the `FnOnce` intended for use with boxed closure objects. The idea is that where one would normally store a `Box<FnOnce()>` in a data structure, you should use `Box<FnBox()>`. The two traits behave essentially the same, except that a `FnBox` closure can only be called if it is boxed. (Note that `FnBox` may be deprecated in the future if `Box<FnOnce()>` closures become directly usable.)",null,null],[16,"Output","","",7,null],[10,"call_box","","",7,null],[11,"clone","","",8,{"inputs":[{"name":"self"}],"output":{"name":"exchangeheapsingleton"}}],[11,"pointer","","",9,null],[11,"make_place","","",9,{"inputs":[],"output":{"name":"intermediatebox"}}],[11,"finalize","","",9,{"inputs":[{"name":"self"}],"output":{"name":"box"}}],[11,"finalize","","",10,{"inputs":[{"name":"intermediatebox"}],"output":{"name":"box"}}],[11,"make_place","","",8,{"inputs":[{"name":"self"}],"output":{"name":"intermediatebox"}}],[11,"drop","","",9,{"inputs":[{"name":"self"}],"output":null}],[11,"new","","Allocates memory on the heap and then places `x` into it.",10,{"inputs":[{"name":"t"}],"output":{"name":"box"}}],[11,"from_raw","","Constructs a box from a raw pointer.",10,null],[11,"into_raw","","Consumes the `Box`, returning the wrapped raw pointer.",10,null],[11,"into_unique","","Consumes the `Box`, returning the wrapped pointer as `Unique<T>`.",10,{"inputs":[{"name":"box"}],"output":{"name":"unique"}}],[11,"drop","","",10,{"inputs":[{"name":"self"}],"output":null}],[11,"default","","Creates a `Box<T>`, with the `Default` value for T.",10,{"inputs":[],"output":{"name":"box"}}],[11,"default","","",10,{"inputs":[],"output":{"name":"box"}}],[11,"default","","",10,{"inputs":[],"output":{"name":"box"}}],[11,"clone","","Returns a new box with a `clone()` of this box's contents.",10,{"inputs":[{"name":"self"}],"output":{"name":"box"}}],[11,"clone_from","","Copies `source`'s contents into `self` without creating a new allocation.",10,{"inputs":[{"name":"self"},{"name":"box"}],"output":null}],[11,"clone","","",10,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"eq","","",10,{"inputs":[{"name":"self"},{"name":"box"}],"output":{"name":"bool"}}],[11,"ne","","",10,{"inputs":[{"name":"self"},{"name":"box"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",10,{"inputs":[{"name":"self"},{"name":"box"}],"output":{"name":"option"}}],[11,"lt","","",10,{"inputs":[{"name":"self"},{"name":"box"}],"output":{"name":"bool"}}],[11,"le","","",10,{"inputs":[{"name":"self"},{"name":"box"}],"output":{"name":"bool"}}],[11,"ge","","",10,{"inputs":[{"name":"self"},{"name":"box"}],"output":{"name":"bool"}}],[11,"gt","","",10,{"inputs":[{"name":"self"},{"name":"box"}],"output":{"name":"bool"}}],[11,"cmp","","",10,{"inputs":[{"name":"self"},{"name":"box"}],"output":{"name":"ordering"}}],[11,"hash","","",10,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"finish","","",10,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"write","","",10,null],[11,"write_u8","","",10,{"inputs":[{"name":"self"},{"name":"u8"}],"output":null}],[11,"write_u16","","",10,{"inputs":[{"name":"self"},{"name":"u16"}],"output":null}],[11,"write_u32","","",10,{"inputs":[{"name":"self"},{"name":"u32"}],"output":null}],[11,"write_u64","","",10,{"inputs":[{"name":"self"},{"name":"u64"}],"output":null}],[11,"write_u128","","",10,{"inputs":[{"name":"self"},{"name":"u128"}],"output":null}],[11,"write_usize","","",10,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"write_i8","","",10,{"inputs":[{"name":"self"},{"name":"i8"}],"output":null}],[11,"write_i16","","",10,{"inputs":[{"name":"self"},{"name":"i16"}],"output":null}],[11,"write_i32","","",10,{"inputs":[{"name":"self"},{"name":"i32"}],"output":null}],[11,"write_i64","","",10,{"inputs":[{"name":"self"},{"name":"i64"}],"output":null}],[11,"write_i128","","",10,{"inputs":[{"name":"self"},{"name":"i128"}],"output":null}],[11,"write_isize","","",10,{"inputs":[{"name":"self"},{"name":"isize"}],"output":null}],[11,"from","","",10,{"inputs":[{"name":"t"}],"output":{"name":"self"}}],[11,"from","","",10,null],[11,"from","","",10,{"inputs":[{"name":"str"}],"output":{"name":"box"}}],[11,"from","","",10,{"inputs":[{"name":"box"}],"output":{"name":"self"}}],[11,"downcast","","Attempt to downcast the box to a concrete type.",10,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"downcast","","Attempt to downcast the box to a concrete type.",10,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"fmt","","",10,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",10,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",10,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"deref","","",10,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"deref_mut","","",10,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"next","","",10,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",10,null],[11,"nth","","",10,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"next_back","","",10,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"len","","",10,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","",10,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"call_once","","",10,{"inputs":[{"name":"self"},{"name":"a"}],"output":{"name":"r"}}],[11,"call_once","","",10,{"inputs":[{"name":"self"},{"name":"a"}],"output":{"name":"r"}}],[11,"clone","","",10,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"borrow","","",10,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"borrow_mut","","",10,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"as_ref","","",10,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"as_mut","","",10,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"resume","","",10,{"inputs":[{"name":"self"}],"output":{"name":"generatorstate"}}],[0,"arc","alloc","Thread-safe reference-counting pointers.",null,null],[3,"Arc","alloc::arc","A thread-safe reference-counting pointer. 'Arc' stands for 'Atomically Reference Counted'.",null,null],[3,"Weak","","`Weak` is a version of [`Arc`] that holds a non-owning reference to the managed value. The value is accessed by calling [`upgrade`] on the `Weak` pointer, which returns an [`Option`]`<`[`Arc`]`<T>>`.",null,null],[11,"fmt","","",11,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Constructs a new `Arc<T>`.",12,{"inputs":[{"name":"t"}],"output":{"name":"arc"}}],[11,"try_unwrap","","Returns the contained value, if the `Arc` has exactly one strong reference.",12,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"into_raw","","Consumes the `Arc`, returning the wrapped pointer.",12,null],[11,"from_raw","","Constructs an `Arc` from a raw pointer.",12,null],[11,"downgrade","","Creates a new [`Weak`][weak] pointer to this value.",12,{"inputs":[{"name":"self"}],"output":{"name":"weak"}}],[11,"weak_count","","Gets the number of [`Weak`][weak] pointers to this value.",12,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"strong_count","","Gets the number of strong (`Arc`) pointers to this value.",12,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"ptr_eq","","Returns true if the two `Arc`s point to the same value (not just values that compare as equal).",12,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","Makes a clone of the `Arc` pointer.",12,{"inputs":[{"name":"self"}],"output":{"name":"arc"}}],[11,"deref","","",12,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"make_mut","","Makes a mutable reference into the given `Arc`.",12,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"get_mut","","Returns a mutable reference to the inner value, if there are no other `Arc` or [`Weak`][weak] pointers to the same value.",12,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"drop","","Drops the `Arc`.",12,{"inputs":[{"name":"self"}],"output":null}],[11,"new","","Constructs a new `Weak<T>`, allocating memory for `T` without initializing it. Calling [`upgrade`] on the return value always gives [`None`].",11,{"inputs":[],"output":{"name":"weak"}}],[11,"upgrade","","Attempts to upgrade the `Weak` pointer to an [`Arc`], extending the lifetime of the value if successful.",11,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","Makes a clone of the `Weak` pointer that points to the same value.",11,{"inputs":[{"name":"self"}],"output":{"name":"weak"}}],[11,"default","","Constructs a new `Weak<T>`, allocating memory for `T` without initializing it. Calling [`upgrade`] on the return value always gives [`None`].",11,{"inputs":[],"output":{"name":"weak"}}],[11,"drop","","Drops the `Weak` pointer.",11,{"inputs":[{"name":"self"}],"output":null}],[11,"eq","","Equality for two `Arc`s.",12,{"inputs":[{"name":"self"},{"name":"arc"}],"output":{"name":"bool"}}],[11,"ne","","Inequality for two `Arc`s.",12,{"inputs":[{"name":"self"},{"name":"arc"}],"output":{"name":"bool"}}],[11,"partial_cmp","","Partial comparison for two `Arc`s.",12,{"inputs":[{"name":"self"},{"name":"arc"}],"output":{"name":"option"}}],[11,"lt","","Less-than comparison for two `Arc`s.",12,{"inputs":[{"name":"self"},{"name":"arc"}],"output":{"name":"bool"}}],[11,"le","","'Less than or equal to' comparison for two `Arc`s.",12,{"inputs":[{"name":"self"},{"name":"arc"}],"output":{"name":"bool"}}],[11,"gt","","Greater-than comparison for two `Arc`s.",12,{"inputs":[{"name":"self"},{"name":"arc"}],"output":{"name":"bool"}}],[11,"ge","","'Greater than or equal to' comparison for two `Arc`s.",12,{"inputs":[{"name":"self"},{"name":"arc"}],"output":{"name":"bool"}}],[11,"cmp","","Comparison for two `Arc`s.",12,{"inputs":[{"name":"self"},{"name":"arc"}],"output":{"name":"ordering"}}],[11,"fmt","","",12,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",12,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",12,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"default","","Creates a new `Arc<T>`, with the `Default` value for `T`.",12,{"inputs":[],"output":{"name":"arc"}}],[11,"hash","","",12,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"from","","",12,{"inputs":[{"name":"t"}],"output":{"name":"self"}}],[11,"from","","",12,null],[11,"from","","",12,{"inputs":[{"name":"str"}],"output":{"name":"arc"}}],[11,"from","","",12,{"inputs":[{"name":"string"}],"output":{"name":"arc"}}],[11,"from","","",12,{"inputs":[{"name":"box"}],"output":{"name":"arc"}}],[11,"from","","",12,{"inputs":[{"name":"vec"}],"output":{"name":"arc"}}],[11,"borrow","","",12,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"as_ref","","",12,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[0,"rc","alloc","Single-threaded reference-counting pointers. 'Rc' stands for 'Reference Counted'.",null,null],[3,"Rc","alloc::rc","A single-threaded reference-counting pointer. 'Rc' stands for 'Reference Counted'.",null,null],[3,"Weak","","`Weak` is a version of [`Rc`] that holds a non-owning reference to the managed value. The value is accessed by calling [`upgrade`] on the `Weak` pointer, which returns an [`Option`]`<`[`Rc`]`<T>>`.",null,null],[11,"new","","Constructs a new `Rc<T>`.",13,{"inputs":[{"name":"t"}],"output":{"name":"rc"}}],[11,"try_unwrap","","Returns the contained value, if the `Rc` has exactly one strong reference.",13,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"into_raw","","Consumes the `Rc`, returning the wrapped pointer.",13,null],[11,"from_raw","","Constructs an `Rc` from a raw pointer.",13,null],[11,"downgrade","","Creates a new [`Weak`][weak] pointer to this value.",13,{"inputs":[{"name":"self"}],"output":{"name":"weak"}}],[11,"weak_count","","Gets the number of [`Weak`][weak] pointers to this value.",13,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"strong_count","","Gets the number of strong (`Rc`) pointers to this value.",13,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"get_mut","","Returns a mutable reference to the inner value, if there are no other `Rc` or [`Weak`][weak] pointers to the same value.",13,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"ptr_eq","","Returns true if the two `Rc`s point to the same value (not just values that compare as equal).",13,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"bool"}}],[11,"make_mut","","Makes a mutable reference into the given `Rc`.",13,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"downcast","","Attempt to downcast the `Rc<Any>` to a concrete type.",13,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"deref","","",13,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"drop","","Drops the `Rc`.",13,{"inputs":[{"name":"self"}],"output":null}],[11,"clone","","Makes a clone of the `Rc` pointer.",13,{"inputs":[{"name":"self"}],"output":{"name":"rc"}}],[11,"default","","Creates a new `Rc<T>`, with the `Default` value for `T`.",13,{"inputs":[],"output":{"name":"rc"}}],[11,"eq","","Equality for two `Rc`s.",13,{"inputs":[{"name":"self"},{"name":"rc"}],"output":{"name":"bool"}}],[11,"ne","","Inequality for two `Rc`s.",13,{"inputs":[{"name":"self"},{"name":"rc"}],"output":{"name":"bool"}}],[11,"partial_cmp","","Partial comparison for two `Rc`s.",13,{"inputs":[{"name":"self"},{"name":"rc"}],"output":{"name":"option"}}],[11,"lt","","Less-than comparison for two `Rc`s.",13,{"inputs":[{"name":"self"},{"name":"rc"}],"output":{"name":"bool"}}],[11,"le","","'Less than or equal to' comparison for two `Rc`s.",13,{"inputs":[{"name":"self"},{"name":"rc"}],"output":{"name":"bool"}}],[11,"gt","","Greater-than comparison for two `Rc`s.",13,{"inputs":[{"name":"self"},{"name":"rc"}],"output":{"name":"bool"}}],[11,"ge","","'Greater than or equal to' comparison for two `Rc`s.",13,{"inputs":[{"name":"self"},{"name":"rc"}],"output":{"name":"bool"}}],[11,"cmp","","Comparison for two `Rc`s.",13,{"inputs":[{"name":"self"},{"name":"rc"}],"output":{"name":"ordering"}}],[11,"hash","","",13,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"fmt","","",13,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",13,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",13,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"from","","",13,{"inputs":[{"name":"t"}],"output":{"name":"self"}}],[11,"from","","",13,null],[11,"from","","",13,{"inputs":[{"name":"str"}],"output":{"name":"rc"}}],[11,"from","","",13,{"inputs":[{"name":"string"}],"output":{"name":"rc"}}],[11,"from","","",13,{"inputs":[{"name":"box"}],"output":{"name":"rc"}}],[11,"from","","",13,{"inputs":[{"name":"vec"}],"output":{"name":"rc"}}],[11,"new","","Constructs a new `Weak<T>`, allocating memory for `T` without initializing it. Calling [`upgrade`] on the return value always gives [`None`].",14,{"inputs":[],"output":{"name":"weak"}}],[11,"upgrade","","Attempts to upgrade the `Weak` pointer to an [`Rc`], extending the lifetime of the value if successful.",14,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"drop","","Drops the `Weak` pointer.",14,{"inputs":[{"name":"self"}],"output":null}],[11,"clone","","Makes a clone of the `Weak` pointer that points to the same value.",14,{"inputs":[{"name":"self"}],"output":{"name":"weak"}}],[11,"fmt","","",14,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"default","","Constructs a new `Weak<T>`, allocating memory for `T` without initializing it. Calling [`upgrade`] on the return value always gives [`None`].",14,{"inputs":[],"output":{"name":"weak"}}],[11,"borrow","","",13,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"as_ref","","",13,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[0,"raw_vec","alloc","",null,null],[3,"RawVec","alloc::raw_vec","A low-level utility for more ergonomically allocating, reallocating, and deallocating a buffer of memory on the heap without having to worry about all the corner cases involved. This type is excellent for building your own data structures like Vec and VecDeque. In particular:",null,null],[11,"new_in","","Like `new` but parameterized over the choice of allocator for the returned RawVec.",15,{"inputs":[{"name":"a"}],"output":{"name":"self"}}],[11,"with_capacity_in","","Like `with_capacity` but parameterized over the choice of allocator for the returned RawVec.",15,{"inputs":[{"name":"usize"},{"name":"a"}],"output":{"name":"self"}}],[11,"with_capacity_zeroed_in","","Like `with_capacity_zeroed` but parameterized over the choice of allocator for the returned RawVec.",15,{"inputs":[{"name":"usize"},{"name":"a"}],"output":{"name":"self"}}],[11,"new","","Creates the biggest possible RawVec (on the system heap) without allocating. If T has positive size, then this makes a RawVec with capacity 0. If T has 0 size, then it it makes a RawVec with capacity `usize::MAX`. Useful for implementing delayed allocation.",15,{"inputs":[],"output":{"name":"self"}}],[11,"with_capacity","","Creates a RawVec (on the system heap) with exactly the capacity and alignment requirements for a `[T; cap]`. This is equivalent to calling RawVec::new when `cap` is 0 or T is zero-sized. Note that if `T` is zero-sized this means you will not get a RawVec with the requested capacity!",15,{"inputs":[{"name":"usize"}],"output":{"name":"self"}}],[11,"with_capacity_zeroed","","Like `with_capacity` but guarantees the buffer is zeroed.",15,{"inputs":[{"name":"usize"}],"output":{"name":"self"}}],[11,"from_raw_parts_in","","Reconstitutes a RawVec from a pointer, capacity, and allocator.",15,null],[11,"from_raw_parts","","Reconstitutes a RawVec from a pointer, capacity.",15,null],[11,"from_box","","Converts a `Box<[T]>` into a `RawVec<T>`.",15,{"inputs":[{"name":"box"}],"output":{"name":"self"}}],[11,"ptr","","Gets a raw pointer to the start of the allocation. Note that this is Unique::empty() if `cap = 0` or T is zero-sized. In the former case, you must be careful.",15,null],[11,"cap","","Gets the capacity of the allocation.",15,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"alloc","","Returns a shared reference to the allocator backing this RawVec.",15,{"inputs":[{"name":"self"}],"output":{"name":"a"}}],[11,"alloc_mut","","Returns a mutable reference to the allocator backing this RawVec.",15,{"inputs":[{"name":"self"}],"output":{"name":"a"}}],[11,"double","","Doubles the size of the type's backing allocation. This is common enough to want to do that it's easiest to just have a dedicated method. Slightly more efficient logic can be provided for this than the general case.",15,{"inputs":[{"name":"self"}],"output":null}],[11,"double_in_place","","Attempts to double the size of the type's backing allocation in place. This is common enough to want to do that it's easiest to just have a dedicated method. Slightly more efficient logic can be provided for this than the general case.",15,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"reserve_exact","","Ensures that the buffer contains at least enough space to hold `used_cap + needed_extra_cap` elements. If it doesn't already, will reallocate the minimum possible amount of memory necessary. Generally this will be exactly the amount of memory necessary, but in principle the allocator is free to give back more than we asked for.",15,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"usize"}],"output":null}],[11,"reserve","","Ensures that the buffer contains at least enough space to hold `used_cap + needed_extra_cap` elements. If it doesn't already have enough capacity, will reallocate enough space plus comfortable slack space to get amortized `O(1)` behavior. Will limit this behavior if it would needlessly cause itself to panic.",15,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"usize"}],"output":null}],[11,"reserve_in_place","","Attempts to ensure that the buffer contains at least enough space to hold `used_cap + needed_extra_cap` elements. If it doesn't already have enough capacity, will reallocate in place enough space plus comfortable slack space to get amortized `O(1)` behavior. Will limit this behaviour if it would needlessly cause itself to panic.",15,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"usize"}],"output":{"name":"bool"}}],[11,"shrink_to_fit","","Shrinks the allocation down to the specified amount. If the given amount is 0, actually completely deallocates.",15,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"into_box","","Converts the entire buffer into `Box<[T]>`.",15,{"inputs":[{"name":"self"}],"output":{"name":"box"}}],[11,"dealloc_buffer","","Frees the memory owned by the RawVec without trying to Drop its contents.",15,{"inputs":[{"name":"self"}],"output":null}],[11,"drop","","Frees the memory owned by the RawVec without trying to Drop its contents.",15,{"inputs":[{"name":"self"}],"output":null}],[0,"binary_heap","alloc","A priority queue implemented with a binary heap.",null,null],[3,"BinaryHeap","alloc::binary_heap","A priority queue implemented with a binary heap.",null,null],[3,"PeekMut","","Structure wrapping a mutable reference to the greatest item on a `BinaryHeap`.",null,null],[3,"Iter","","An iterator over the elements of a `BinaryHeap`.",null,null],[3,"IntoIter","","An owning iterator over the elements of a `BinaryHeap`.",null,null],[3,"Drain","","A draining iterator over the elements of a `BinaryHeap`.",null,null],[3,"BinaryHeapPlace","","",null,null],[11,"fmt","","",16,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"drop","","",16,{"inputs":[{"name":"self"}],"output":null}],[11,"deref","","",16,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"deref_mut","","",16,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"pop","","Removes the peeked value from the heap and returns it.",16,{"inputs":[{"name":"peekmut"}],"output":{"name":"t"}}],[11,"clone","","",17,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"clone_from","","",17,{"inputs":[{"name":"self"},{"name":"self"}],"output":null}],[11,"default","","Creates an empty `BinaryHeap<T>`.",17,{"inputs":[],"output":{"name":"binaryheap"}}],[11,"fmt","","",17,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates an empty `BinaryHeap` as a max-heap.",17,{"inputs":[],"output":{"name":"binaryheap"}}],[11,"with_capacity","","Creates an empty `BinaryHeap` with a specific capacity. This preallocates enough memory for `capacity` elements, so that the `BinaryHeap` does not have to be reallocated until it contains at least that many values.",17,{"inputs":[{"name":"usize"}],"output":{"name":"binaryheap"}}],[11,"iter","","Returns an iterator visiting all values in the underlying vector, in arbitrary order.",17,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"peek","","Returns the greatest item in the binary heap, or `None` if it is empty.",17,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"peek_mut","","Returns a mutable reference to the greatest item in the binary heap, or `None` if it is empty.",17,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"capacity","","Returns the number of elements the binary heap can hold without reallocating.",17,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"reserve_exact","","Reserves the minimum capacity for exactly `additional` more elements to be inserted in the given `BinaryHeap`. Does nothing if the capacity is already sufficient.",17,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"reserve","","Reserves capacity for at least `additional` more elements to be inserted in the `BinaryHeap`. The collection may reserve more space to avoid frequent reallocations.",17,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shrink_to_fit","","Discards as much additional capacity as possible.",17,{"inputs":[{"name":"self"}],"output":null}],[11,"pop","","Removes the greatest item from the binary heap and returns it, or `None` if it is empty.",17,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"push","","Pushes an item onto the binary heap.",17,{"inputs":[{"name":"self"},{"name":"t"}],"output":null}],[11,"into_vec","","Consumes the `BinaryHeap` and returns the underlying vector in arbitrary order.",17,{"inputs":[{"name":"self"}],"output":{"name":"vec"}}],[11,"into_sorted_vec","","Consumes the `BinaryHeap` and returns a vector in sorted (ascending) order.",17,{"inputs":[{"name":"self"}],"output":{"name":"vec"}}],[11,"len","","Returns the length of the binary heap.",17,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","Checks if the binary heap is empty.",17,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"drain","","Clears the binary heap, returning an iterator over the removed elements.",17,{"inputs":[{"name":"self"}],"output":{"name":"drain"}}],[11,"clear","","Drops all items from the binary heap.",17,{"inputs":[{"name":"self"}],"output":null}],[11,"append","","Moves all the elements of `other` into `self`, leaving `other` empty.",17,{"inputs":[{"name":"self"},{"name":"self"}],"output":null}],[11,"fmt","","",18,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",18,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"next","","",18,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",18,null],[11,"next_back","","",18,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"is_empty","","",18,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",19,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"fmt","","",19,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",19,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",19,null],[11,"next_back","","",19,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"is_empty","","",19,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"fmt","","",20,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",20,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",20,null],[11,"next_back","","",20,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"is_empty","","",20,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"from","","",17,{"inputs":[{"name":"vec"}],"output":{"name":"binaryheap"}}],[11,"from_iter","","",17,{"inputs":[{"name":"i"}],"output":{"name":"binaryheap"}}],[11,"into_iter","","Creates a consuming iterator, that is, one that moves each value out of the binary heap in arbitrary order. The binary heap cannot be used after calling this.",17,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"extend","","",17,{"inputs":[{"name":"self"},{"name":"i"}],"output":null}],[11,"extend","","",17,{"inputs":[{"name":"self"},{"name":"i"}],"output":null}],[11,"fmt","","",21,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"pointer","","",21,null],[11,"finalize","","",21,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[0,"borrow","alloc","A module for working with borrowed data.",null,null],[8,"Borrow","alloc::borrow","A trait for borrowing data.",null,null],[10,"borrow","","Immutably borrows from an owned value.",22,{"inputs":[{"name":"self"}],"output":{"name":"borrowed"}}],[8,"BorrowMut","","A trait for mutably borrowing data.",null,null],[10,"borrow_mut","","Mutably borrows from an owned value.",23,{"inputs":[{"name":"self"}],"output":{"name":"borrowed"}}],[4,"Cow","","A clone-on-write smart pointer.",null,null],[13,"Borrowed","","Borrowed data.",24,null],[13,"Owned","","Owned data.",24,null],[8,"ToOwned","","A generalization of `Clone` to borrowed data.",null,null],[16,"Owned","","",25,null],[10,"to_owned","","Creates owned data from borrowed data, usually by cloning.",25,null],[11,"clone_into","","Uses borrowed data to replace owned data, usually by cloning.",25,null],[11,"borrow","","",24,{"inputs":[{"name":"self"}],"output":{"name":"b"}}],[11,"clone","","",24,{"inputs":[{"name":"self"}],"output":{"name":"cow"}}],[11,"clone_from","","",24,{"inputs":[{"name":"self"},{"name":"cow"}],"output":null}],[11,"to_mut","","Acquires a mutable reference to the owned form of the data.",24,null],[11,"into_owned","","Extracts the owned data.",24,null],[11,"deref","","",24,{"inputs":[{"name":"self"}],"output":{"name":"b"}}],[11,"cmp","","",24,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"ordering"}}],[11,"eq","","",24,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",24,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"option"}}],[11,"fmt","","",24,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",24,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"default","","Creates an owned Cow<'a, B> with the default value for the contained owned value.",24,{"inputs":[],"output":{"name":"cow"}}],[11,"hash","","",24,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"as_ref","","",24,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"add","","",24,null],[11,"add","","",24,null],[11,"add_assign","","",24,{"inputs":[{"name":"self"},{"name":"str"}],"output":null}],[11,"add_assign","","",24,{"inputs":[{"name":"self"},{"name":"cow"}],"output":null}],[0,"fmt","alloc","Utilities for formatting and printing `String`s",null,null],[3,"Formatter","alloc::fmt","A struct to represent both where to emit formatting strings to and how they should be formatted. A mutable version of this is passed to all formatting traits.",null,null],[6,"Result","","The type returned by formatter methods.",null,null],[8,"Write","","A collection of methods that are required to format a message into a stream.",null,null],[10,"write_str","","Writes a slice of bytes into this writer, returning whether the write succeeded.",26,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"result"}}],[11,"write_char","","Writes a [`char`] into this writer, returning whether the write succeeded.",26,{"inputs":[{"name":"self"},{"name":"char"}],"output":{"name":"result"}}],[11,"write_fmt","","Glue for usage of the [`write!`] macro with implementors of this trait.",26,{"inputs":[{"name":"self"},{"name":"arguments"}],"output":{"name":"result"}}],[8,"Octal","","`o` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",27,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"Binary","","`b` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",28,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"Display","","Format trait for an empty format, `{}`.",null,null],[10,"fmt","","Formats the value using the given formatter.",29,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"Debug","","`?` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",30,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"LowerHex","","`x` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",31,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"UpperHex","","`X` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",32,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"Pointer","","`p` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",33,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"LowerExp","","`e` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",34,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"UpperExp","","`E` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",35,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"Error","","The error type which is returned from formatting a message into a stream.",null,null],[3,"Arguments","","This structure represents a safely precompiled version of a format string and its arguments. This cannot be generated at runtime because it cannot safely be done, so no constructors are given and the fields are private to prevent modification.",null,null],[5,"write","","The `write` function takes an output stream, and an `Arguments` struct that can be precompiled with the `format_args!` macro.",null,{"inputs":[{"name":"write"},{"name":"arguments"}],"output":{"name":"result"}}],[3,"DebugList","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugMap","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugSet","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugStruct","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugTuple","","A struct to help with `fmt::Debug` implementations.",null,null],[5,"format","","The `format` function takes an [`Arguments`] struct and returns the resulting formatted string.",null,{"inputs":[{"name":"arguments"}],"output":{"name":"string"}}],[0,"linked_list","alloc","A doubly-linked list with owned nodes.",null,null],[3,"LinkedList","alloc::linked_list","A doubly-linked list with owned nodes.",null,null],[3,"Iter","","An iterator over the elements of a `LinkedList`.",null,null],[3,"IterMut","","A mutable iterator over the elements of a `LinkedList`.",null,null],[3,"IntoIter","","An owning iterator over the elements of a `LinkedList`.",null,null],[3,"FrontPlace","","A place for insertion at the front of a `LinkedList`.",null,null],[3,"BackPlace","","A place for insertion at the back of a `LinkedList`.",null,null],[11,"fmt","","",36,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",36,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"fmt","","",37,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",38,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"fmt","","",38,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"default","","Creates an empty `LinkedList<T>`.",39,{"inputs":[],"output":{"name":"self"}}],[11,"new","","Creates an empty `LinkedList`.",39,{"inputs":[],"output":{"name":"self"}}],[11,"append","","Moves all elements from `other` to the end of the list.",39,{"inputs":[{"name":"self"},{"name":"self"}],"output":null}],[11,"iter","","Provides a forward iterator.",39,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"iter_mut","","Provides a forward iterator with mutable references.",39,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"is_empty","","Returns `true` if the `LinkedList` is empty.",39,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"len","","Returns the length of the `LinkedList`.",39,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"clear","","Removes all elements from the `LinkedList`.",39,{"inputs":[{"name":"self"}],"output":null}],[11,"contains","","Returns `true` if the `LinkedList` contains an element equal to the given value.",39,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"bool"}}],[11,"front","","Provides a reference to the front element, or `None` if the list is empty.",39,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"front_mut","","Provides a mutable reference to the front element, or `None` if the list is empty.",39,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"back","","Provides a reference to the back element, or `None` if the list is empty.",39,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"back_mut","","Provides a mutable reference to the back element, or `None` if the list is empty.",39,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"push_front","","Adds an element first in the list.",39,{"inputs":[{"name":"self"},{"name":"t"}],"output":null}],[11,"pop_front","","Removes the first element and returns it, or `None` if the list is empty.",39,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"push_back","","Appends an element to the back of a list",39,{"inputs":[{"name":"self"},{"name":"t"}],"output":null}],[11,"pop_back","","Removes the last element from a list and returns it, or `None` if it is empty.",39,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"split_off","","Splits the list into two at the given index. Returns everything after the given index, including the index.",39,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"linkedlist"}}],[11,"front_place","","Returns a place for insertion at the front of the list.",39,{"inputs":[{"name":"self"}],"output":{"name":"frontplace"}}],[11,"back_place","","Returns a place for insertion at the back of the list.",39,{"inputs":[{"name":"self"}],"output":{"name":"backplace"}}],[11,"drop","","",39,{"inputs":[{"name":"self"}],"output":null}],[11,"next","","",36,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",36,null],[11,"next_back","","",36,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",37,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",37,null],[11,"next_back","","",37,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"insert_next","","Inserts the given element just after the element most recently returned by `.next()`. The inserted element does not appear in the iteration.",37,{"inputs":[{"name":"self"},{"name":"t"}],"output":null}],[11,"peek_next","","Provides a reference to the next element, without changing the iterator.",37,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",38,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",38,null],[11,"next_back","","",38,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"from_iter","","",39,{"inputs":[{"name":"i"}],"output":{"name":"self"}}],[11,"into_iter","","Consumes the list into an iterator yielding elements by value.",39,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"extend","","",39,{"inputs":[{"name":"self"},{"name":"i"}],"output":null}],[11,"extend","","",39,{"inputs":[{"name":"self"},{"name":"i"}],"output":null}],[11,"eq","","",39,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"bool"}}],[11,"ne","","",39,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",39,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"option"}}],[11,"cmp","","",39,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"ordering"}}],[11,"clone","","",39,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"fmt","","",39,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",39,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"fmt","","",40,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"make_place","","",40,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"pointer","","",40,null],[11,"finalize","","",40,{"inputs":[{"name":"self"}],"output":null}],[11,"fmt","","",41,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"make_place","","",41,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"pointer","","",41,null],[11,"finalize","","",41,{"inputs":[{"name":"self"}],"output":null}],[0,"range","alloc","Range syntax.",null,null],[8,"RangeArgument","alloc::range","`RangeArgument` is implemented by Rust's built-in range types, produced by range syntax like `..`, `a..`, `..b` or `c..d`.",null,null],[10,"start","","Start index bound.",42,{"inputs":[{"name":"self"}],"output":{"name":"bound"}}],[10,"end","","End index bound.",42,{"inputs":[{"name":"self"}],"output":{"name":"bound"}}],[0,"slice","alloc","A dynamically-sized view into a contiguous sequence, `[T]`.",null,null],[3,"Chunks","alloc::slice","An iterator over a slice in (non-overlapping) chunks (`size` elements at a time).",null,null],[3,"Windows","","An iterator over overlapping subslices of length `size`.",null,null],[3,"Iter","","Immutable slice iterator",null,null],[3,"IterMut","","Mutable slice iterator.",null,null],[3,"SplitMut","","An iterator over the subslices of the vector which are separated by elements that match `pred`.",null,null],[3,"ChunksMut","","An iterator over a slice in (non-overlapping) mutable chunks (`size` elements at a time). When the slice len is not evenly divided by the chunk size, the last slice of the iteration will be the remainder.",null,null],[3,"Split","","An iterator over subslices separated by elements that match a predicate function.",null,null],[3,"SplitN","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits.",null,null],[3,"RSplitN","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits, starting from the end of the slice.",null,null],[3,"SplitNMut","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits.",null,null],[3,"RSplitNMut","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits, starting from the end of the slice.",null,null],[3,"RSplit","","An iterator over subslices separated by elements that match a predicate function, starting from the end of the slice.",null,null],[3,"RSplitMut","","An iterator over the subslices of the vector which are separated by elements that match `pred`, starting from the end of the slice.",null,null],[5,"from_raw_parts","","Forms a slice from a pointer and a length.",null,null],[5,"from_raw_parts_mut","","Performs the same functionality as `from_raw_parts`, except that a mutable slice is returned.",null,null],[8,"SliceIndex","","A helper trait used for indexing operations.",null,null],[16,"Output","","The output type returned by methods.",43,null],[10,"get","","Returns a shared reference to the output at this location, if in bounds.",43,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"option"}}],[10,"get_mut","","Returns a mutable reference to the output at this location, if in bounds.",43,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"option"}}],[10,"get_unchecked","","Returns a shared reference to the output at this location, without performing any bounds checking.",43,null],[10,"get_unchecked_mut","","Returns a mutable reference to the output at this location, without performing any bounds checking.",43,null],[10,"index","","Returns a shared reference to the output at this location, panicking if out of bounds.",43,null],[10,"index_mut","","Returns a mutable reference to the output at this location, panicking if out of bounds.",43,null],[8,"SliceConcatExt","","An extension trait for concatenating slices",null,null],[16,"Output","","The resulting type after concatenation",44,null],[10,"concat","","Flattens a slice of `T` into a single value `Self::Output`.",44,null],[10,"join","","Flattens a slice of `T` into a single value `Self::Output`, placing a given separator between each.",44,null],[10,"connect","","",44,null],[0,"str","alloc","Unicode string slices.",null,null],[8,"FromStr","alloc::str","A trait to abstract the idea of creating a new instance of a type from a string.",null,null],[16,"Err","","The associated error which can be returned from parsing.",45,null],[10,"from_str","","Parses a string `s` to return a value of this type.",45,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[3,"Utf8Error","","Errors which can occur when attempting to interpret a sequence of [`u8`] as a string.",null,null],[3,"Lines","","An iterator over the lines of a string, as string slices.",null,null],[3,"LinesAny","","Created with the method [`lines_any`].",null,null],[3,"Split","","Created with the method [`split`].",null,null],[3,"RSplit","","Created with the method [`rsplit`].",null,null],[3,"SplitN","","Created with the method [`splitn`].",null,null],[3,"RSplitN","","Created with the method [`rsplitn`].",null,null],[3,"SplitTerminator","","Created with the method [`split_terminator`].",null,null],[3,"RSplitTerminator","","Created with the method [`rsplit_terminator`].",null,null],[3,"Matches","","Created with the method [`matches`].",null,null],[3,"RMatches","","Created with the method [`rmatches`].",null,null],[3,"MatchIndices","","Created with the method [`match_indices`].",null,null],[3,"RMatchIndices","","Created with the method [`rmatch_indices`].",null,null],[5,"from_utf8","","Converts a slice of bytes to a string slice.",null,null],[5,"from_utf8_mut","","Converts a mutable slice of bytes to a mutable string slice.",null,null],[3,"Chars","","An iterator over the [`char`]s of a string slice.",null,null],[3,"CharIndices","","An iterator over the [`char`]s of a string slice, and their positions.",null,null],[3,"Bytes","","An iterator over the bytes of a string slice.",null,null],[5,"from_utf8_unchecked","","Converts a slice of bytes to a string slice without checking that the string contains valid UTF-8.",null,null],[5,"from_utf8_unchecked_mut","","Converts a slice of bytes to a string slice without checking that the string contains valid UTF-8; mutable version.",null,null],[3,"ParseBoolError","","An error returned when parsing a `bool` using [`from_str`] fails",null,null],[3,"SplitWhitespace","","An iterator over the non-whitespace substrings of a string, separated by any amount of whitespace.",null,null],[0,"pattern","","The string Pattern API.",null,null],[8,"Pattern","alloc::str::pattern","A string pattern.",null,null],[16,"Searcher","","Associated searcher for this pattern",46,null],[10,"into_searcher","","Constructs the associated searcher from `self` and the `haystack` to search in.",46,null],[11,"is_contained_in","","Checks whether the pattern matches anywhere in the haystack",46,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"is_prefix_of","","Checks whether the pattern matches at the front of the haystack",46,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"is_suffix_of","","Checks whether the pattern matches at the back of the haystack",46,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[4,"SearchStep","","Result of calling `Searcher::next()` or `ReverseSearcher::next_back()`.",null,null],[13,"Match","","Expresses that a match of the pattern has been found at `haystack[a..b]`.",47,null],[13,"Reject","","Expresses that `haystack[a..b]` has been rejected as a possible match of the pattern.",47,null],[13,"Done","","Expresses that every byte of the haystack has been visited, ending the iteration.",47,null],[8,"Searcher","","A searcher for a string pattern.",null,null],[10,"haystack","","Getter for the underlying string to be searched in",48,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[10,"next","","Performs the next search step starting from the front.",48,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match","","Find the next `Match` result. See `next()`",48,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject","","Find the next `Reject` result. See `next()`",48,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[8,"ReverseSearcher","","A reverse searcher for a string pattern.",null,null],[10,"next_back","","Performs the next search step starting from the back.",49,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match_back","","Find the next `Match` result. See `next_back()`",49,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject_back","","Find the next `Reject` result. See `next_back()`",49,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[8,"DoubleEndedSearcher","","A marker trait to express that a `ReverseSearcher` can be used for a `DoubleEndedIterator` implementation.",null,null],[3,"CharSearcher","","Associated type for `<char as Pattern<'a>>::Searcher`.",null,null],[3,"CharSliceSearcher","","Associated type for `<&[char] as Pattern<'a>>::Searcher`.",null,null],[3,"CharPredicateSearcher","","Associated type for `<F as Pattern<'a>>::Searcher`.",null,null],[3,"StrSearcher","","Associated type for `<&str as Pattern<'a>>::Searcher`.",null,null],[3,"EncodeUtf16","alloc::str","An iterator of [`u16`] over the string encoded as UTF-16.",null,null],[5,"from_boxed_utf8_unchecked","","Converts a boxed slice of bytes to a boxed string slice without checking that the string contains valid UTF-8.",null,{"inputs":[{"name":"box"}],"output":{"name":"box"}}],[11,"clone","","",50,{"inputs":[{"name":"self"}],"output":{"name":"encodeutf16"}}],[11,"fmt","","",50,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",50,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",50,null],[0,"string","alloc","A UTF-8 encoded, growable string.",null,null],[3,"String","alloc::string","A UTF-8 encoded, growable string.",null,null],[3,"FromUtf8Error","","A possible error value when converting a `String` from a UTF-8 byte vector.",null,null],[3,"FromUtf16Error","","A possible error value when converting a `String` from a UTF-16 byte slice.",null,null],[3,"Drain","","A draining iterator for `String`.",null,null],[4,"ParseError","","An error when parsing a `String`.",null,null],[8,"ToString","","A trait for converting a value to a `String`.",null,null],[10,"to_string","","Converts the given value to a `String`.",51,{"inputs":[{"name":"self"}],"output":{"name":"string"}}],[11,"partial_cmp","","",52,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"option"}}],[11,"lt","","",52,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"bool"}}],[11,"le","","",52,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"bool"}}],[11,"gt","","",52,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"bool"}}],[11,"ge","","",52,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"bool"}}],[11,"cmp","","",52,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"ordering"}}],[11,"fmt","","",53,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",54,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new empty `String`.",52,{"inputs":[],"output":{"name":"string"}}],[11,"with_capacity","","Creates a new empty `String` with a particular capacity.",52,{"inputs":[{"name":"usize"}],"output":{"name":"string"}}],[11,"from_utf8","","Converts a vector of bytes to a `String`.",52,{"inputs":[{"name":"vec"}],"output":{"name":"result"}}],[11,"from_utf8_lossy","","Converts a slice of bytes to a string, including invalid characters.",52,null],[11,"from_utf16","","Decode a UTF-16 encoded vector `v` into a `String`, returning [`Err`] if `v` contains any invalid data.",52,null],[11,"from_utf16_lossy","","Decode a UTF-16 encoded slice `v` into a `String`, replacing invalid data with the replacement character (U+FFFD).",52,null],[11,"from_raw_parts","","Creates a new `String` from a length, capacity, and pointer.",52,null],[11,"from_utf8_unchecked","","Converts a vector of bytes to a `String` without checking that the string contains valid UTF-8.",52,{"inputs":[{"name":"vec"}],"output":{"name":"string"}}],[11,"into_bytes","","Converts a `String` into a byte vector.",52,{"inputs":[{"name":"self"}],"output":{"name":"vec"}}],[11,"as_str","","Extracts a string slice containing the entire string.",52,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"as_mut_str","","Converts a `String` into a mutable string slice.",52,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"push_str","","Appends a given string slice onto the end of this `String`.",52,{"inputs":[{"name":"self"},{"name":"str"}],"output":null}],[11,"capacity","","Returns this `String`'s capacity, in bytes.",52,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"reserve","","Ensures that this `String`'s capacity is at least `additional` bytes larger than its length.",52,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"reserve_exact","","Ensures that this `String`'s capacity is `additional` bytes larger than its length.",52,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shrink_to_fit","","Shrinks the capacity of this `String` to match its length.",52,{"inputs":[{"name":"self"}],"output":null}],[11,"push","","Appends the given [`char`] to the end of this `String`.",52,{"inputs":[{"name":"self"},{"name":"char"}],"output":null}],[11,"as_bytes","","Returns a byte slice of this `String`'s contents.",52,null],[11,"truncate","","Shortens this `String` to the specified length.",52,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"pop","","Removes the last character from the string buffer and returns it.",52,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"remove","","Removes a [`char`] from this `String` at a byte position and returns it.",52,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"char"}}],[11,"retain","","Retains only the characters specified by the predicate.",52,{"inputs":[{"name":"self"},{"name":"f"}],"output":null}],[11,"insert","","Inserts a character into this `String` at a byte position.",52,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"char"}],"output":null}],[11,"insert_str","","Inserts a string slice into this `String` at a byte position.",52,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"str"}],"output":null}],[11,"as_mut_vec","","Returns a mutable reference to the contents of this `String`.",52,{"inputs":[{"name":"self"}],"output":{"name":"vec"}}],[11,"len","","Returns the length of this `String`, in bytes.",52,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","Returns `true` if this `String` has a length of zero.",52,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"split_off","","Splits the string into two at the given index.",52,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"string"}}],[11,"clear","","Truncates this `String`, removing all contents.",52,{"inputs":[{"name":"self"}],"output":null}],[11,"drain","","Creates a draining iterator that removes the specified range in the string and yields the removed chars.",52,{"inputs":[{"name":"self"},{"name":"r"}],"output":{"name":"drain"}}],[11,"splice","","Creates a splicing iterator that removes the specified range in the string, and replaces it with the given string. The given string doesn't need to be the same length as the range.",52,{"inputs":[{"name":"self"},{"name":"r"},{"name":"str"}],"output":null}],[11,"into_boxed_str","","Converts this `String` into a [`Box`]`<`[`str`]`>`.",52,{"inputs":[{"name":"self"}],"output":{"name":"box"}}],[11,"as_bytes","","Returns a slice of [`u8`]s bytes that were attempted to convert to a `String`.",53,null],[11,"into_bytes","","Returns the bytes that were attempted to convert to a `String`.",53,{"inputs":[{"name":"self"}],"output":{"name":"vec"}}],[11,"utf8_error","","Fetch a `Utf8Error` to get more details about the conversion failure.",53,{"inputs":[{"name":"self"}],"output":{"name":"utf8error"}}],[11,"fmt","","",53,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",54,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",52,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"clone_from","","",52,{"inputs":[{"name":"self"},{"name":"self"}],"output":null}],[11,"from_iter","","",52,{"inputs":[{"name":"i"}],"output":{"name":"string"}}],[11,"from_iter","","",52,{"inputs":[{"name":"i"}],"output":{"name":"string"}}],[11,"from_iter","","",52,{"inputs":[{"name":"i"}],"output":{"name":"string"}}],[11,"from_iter","","",52,{"inputs":[{"name":"i"}],"output":{"name":"string"}}],[11,"from_iter","","",52,{"inputs":[{"name":"i"}],"output":{"name":"string"}}],[11,"extend","","",52,{"inputs":[{"name":"self"},{"name":"i"}],"output":null}],[11,"extend","","",52,{"inputs":[{"name":"self"},{"name":"i"}],"output":null}],[11,"extend","","",52,{"inputs":[{"name":"self"},{"name":"i"}],"output":null}],[11,"extend","","",52,{"inputs":[{"name":"self"},{"name":"i"}],"output":null}],[11,"extend","","",52,{"inputs":[{"name":"self"},{"name":"i"}],"output":null}],[11,"eq","","",52,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"bool"}}],[11,"ne","","",52,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"bool"}}],[11,"eq","","",52,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"ne","","",52,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"eq","","",52,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"ne","","",52,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"eq","alloc::borrow","",24,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"ne","","",24,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"eq","","",24,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"ne","","",24,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"eq","","",24,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"bool"}}],[11,"ne","","",24,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"bool"}}],[11,"eq","alloc::string","",52,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"bool"}}],[11,"ne","","",52,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"bool"}}],[11,"default","","Creates an empty `String`.",52,{"inputs":[],"output":{"name":"string"}}],[11,"fmt","","",52,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",52,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",52,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"add","","",52,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"string"}}],[11,"add_assign","","",52,{"inputs":[{"name":"self"},{"name":"str"}],"output":null}],[11,"index","","",52,{"inputs":[{"name":"self"},{"name":"range"}],"output":{"name":"str"}}],[11,"index","","",52,{"inputs":[{"name":"self"},{"name":"rangeto"}],"output":{"name":"str"}}],[11,"index","","",52,{"inputs":[{"name":"self"},{"name":"rangefrom"}],"output":{"name":"str"}}],[11,"index","","",52,{"inputs":[{"name":"self"},{"name":"rangefull"}],"output":{"name":"str"}}],[11,"index","","",52,{"inputs":[{"name":"self"},{"name":"rangeinclusive"}],"output":{"name":"str"}}],[11,"index","","",52,{"inputs":[{"name":"self"},{"name":"rangetoinclusive"}],"output":{"name":"str"}}],[11,"index_mut","","",52,{"inputs":[{"name":"self"},{"name":"range"}],"output":{"name":"str"}}],[11,"index_mut","","",52,{"inputs":[{"name":"self"},{"name":"rangeto"}],"output":{"name":"str"}}],[11,"index_mut","","",52,{"inputs":[{"name":"self"},{"name":"rangefrom"}],"output":{"name":"str"}}],[11,"index_mut","","",52,{"inputs":[{"name":"self"},{"name":"rangefull"}],"output":{"name":"str"}}],[11,"index_mut","","",52,{"inputs":[{"name":"self"},{"name":"rangeinclusive"}],"output":{"name":"str"}}],[11,"index_mut","","",52,{"inputs":[{"name":"self"},{"name":"rangetoinclusive"}],"output":{"name":"str"}}],[11,"deref","","",52,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"deref_mut","","",52,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"from_str","","",52,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"clone","","",55,{"inputs":[{"name":"self"}],"output":{"name":"parseerror"}}],[11,"fmt","","",55,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",55,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",55,{"inputs":[{"name":"self"},{"name":"parseerror"}],"output":{"name":"bool"}}],[11,"to_string","alloc::borrow","",24,{"inputs":[{"name":"self"}],"output":{"name":"string"}}],[11,"to_string","alloc::string","",52,{"inputs":[{"name":"self"}],"output":{"name":"string"}}],[11,"as_ref","","",52,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"as_ref","","",52,null],[11,"from","","",52,{"inputs":[{"name":"str"}],"output":{"name":"string"}}],[11,"from","","",52,{"inputs":[{"name":"box"}],"output":{"name":"string"}}],[11,"from","alloc::boxed","",10,{"inputs":[{"name":"string"}],"output":{"name":"box"}}],[11,"from","alloc::string","",52,{"inputs":[{"name":"cow"}],"output":{"name":"string"}}],[11,"from","alloc::borrow","",24,{"inputs":[{"name":"str"}],"output":{"name":"cow"}}],[11,"from","","",24,{"inputs":[{"name":"string"}],"output":{"name":"cow"}}],[11,"from_iter","","",24,{"inputs":[{"name":"i"}],"output":{"name":"cow"}}],[11,"from_iter","","",24,{"inputs":[{"name":"i"}],"output":{"name":"cow"}}],[11,"from_iter","","",24,{"inputs":[{"name":"i"}],"output":{"name":"cow"}}],[11,"write_str","alloc::string","",52,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"result"}}],[11,"write_char","","",52,{"inputs":[{"name":"self"},{"name":"char"}],"output":{"name":"result"}}],[11,"fmt","","",56,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"drop","","",56,{"inputs":[{"name":"self"}],"output":null}],[11,"next","","",56,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",56,null],[11,"next_back","","",56,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[0,"vec","alloc","A contiguous growable array type with heap-allocated contents, written `Vec<T>`.",null,null],[3,"Vec","alloc::vec","A contiguous growable array type, written `Vec<T>` but pronounced 'vector'.",null,null],[3,"IntoIter","","An iterator that moves out of a vector.",null,null],[3,"Drain","","A draining iterator for `Vec<T>`.",null,null],[3,"PlaceBack","","A place for insertion at the back of a `Vec`.",null,null],[3,"Splice","","A splicing iterator for `Vec`.",null,null],[3,"DrainFilter","","An iterator produced by calling `drain_filter` on Vec.",null,null],[11,"new","","Constructs a new, empty `Vec<T>`.",57,{"inputs":[],"output":{"name":"vec"}}],[11,"with_capacity","","Constructs a new, empty `Vec<T>` with the specified capacity.",57,{"inputs":[{"name":"usize"}],"output":{"name":"vec"}}],[11,"from_raw_parts","","Creates a `Vec<T>` directly from the raw components of another vector.",57,null],[11,"capacity","","Returns the number of elements the vector can hold without reallocating.",57,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"reserve","","Reserves capacity for at least `additional` more elements to be inserted in the given `Vec<T>`. The collection may reserve more space to avoid frequent reallocations. After calling `reserve`, capacity will be greater than or equal to `self.len() + additional`. Does nothing if capacity is already sufficient.",57,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"reserve_exact","","Reserves the minimum capacity for exactly `additional` more elements to be inserted in the given `Vec<T>`. After calling `reserve_exact`, capacity will be greater than or equal to `self.len() + additional`. Does nothing if the capacity is already sufficient.",57,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shrink_to_fit","","Shrinks the capacity of the vector as much as possible.",57,{"inputs":[{"name":"self"}],"output":null}],[11,"into_boxed_slice","","Converts the vector into [`Box<[T]>`][owned slice].",57,{"inputs":[{"name":"self"}],"output":{"name":"box"}}],[11,"truncate","","Shortens the vector, keeping the first `len` elements and dropping the rest.",57,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"as_slice","","Extracts a slice containing the entire vector.",57,null],[11,"as_mut_slice","","Extracts a mutable slice of the entire vector.",57,null],[11,"set_len","","Sets the length of a vector.",57,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"swap_remove","","Removes an element from the vector and returns it.",57,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"t"}}],[11,"insert","","Inserts an element at position `index` within the vector, shifting all elements after it to the right.",57,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"t"}],"output":null}],[11,"remove","","Removes and returns the element at position `index` within the vector, shifting all elements after it to the left.",57,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"t"}}],[11,"retain","","Retains only the elements specified by the predicate.",57,{"inputs":[{"name":"self"},{"name":"f"}],"output":null}],[11,"dedup_by_key","","Removes all but the first of consecutive elements in the vector that resolve to the same key.",57,{"inputs":[{"name":"self"},{"name":"f"}],"output":null}],[11,"dedup_by","","Removes all but the first of consecutive elements in the vector satisfying a given equality relation.",57,{"inputs":[{"name":"self"},{"name":"f"}],"output":null}],[11,"push","","Appends an element to the back of a collection.",57,{"inputs":[{"name":"self"},{"name":"t"}],"output":null}],[11,"place_back","","Returns a place for insertion at the back of the `Vec`.",57,{"inputs":[{"name":"self"}],"output":{"name":"placeback"}}],[11,"pop","","Removes the last element from a vector and returns it, or [`None`] if it is empty.",57,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"append","","Moves all the elements of `other` into `Self`, leaving `other` empty.",57,{"inputs":[{"name":"self"},{"name":"self"}],"output":null}],[11,"drain","","Creates a draining iterator that removes the specified range in the vector and yields the removed items.",57,{"inputs":[{"name":"self"},{"name":"r"}],"output":{"name":"drain"}}],[11,"clear","","Clears the vector, removing all values.",57,{"inputs":[{"name":"self"}],"output":null}],[11,"len","","Returns the number of elements in the vector, also referred to as its 'length'.",57,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","Returns `true` if the vector contains no elements.",57,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"split_off","","Splits the collection into two at the given index.",57,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"self"}}],[11,"resize","","Resizes the `Vec` in-place so that `len` is equal to `new_len`.",57,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"t"}],"output":null}],[11,"extend_from_slice","","Clones and appends all elements in a slice to the `Vec`.",57,null],[11,"resize_default","","Resizes the `Vec` in-place so that `len` is equal to `new_len`.",57,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"dedup","","Removes consecutive repeated elements in the vector.",57,{"inputs":[{"name":"self"}],"output":null}],[11,"remove_item","","Removes the first instance of `item` from the vector if the item exists.",57,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"option"}}],[11,"clone","","",57,{"inputs":[{"name":"self"}],"output":{"name":"vec"}}],[11,"clone_from","","",57,{"inputs":[{"name":"self"},{"name":"vec"}],"output":null}],[11,"hash","","",57,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"index","","",57,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"t"}}],[11,"index_mut","","",57,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"t"}}],[11,"index","","",57,null],[11,"index","","",57,null],[11,"index","","",57,null],[11,"index","","",57,null],[11,"index","","",57,null],[11,"index","","",57,null],[11,"index_mut","","",57,null],[11,"index_mut","","",57,null],[11,"index_mut","","",57,null],[11,"index_mut","","",57,null],[11,"index_mut","","",57,null],[11,"index_mut","","",57,null],[11,"deref","","",57,null],[11,"deref_mut","","",57,null],[11,"from_iter","","",57,{"inputs":[{"name":"i"}],"output":{"name":"vec"}}],[11,"into_iter","","Creates a consuming iterator, that is, one that moves each value out of the vector (from start to end). The vector cannot be used after calling this.",57,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"extend","","",57,{"inputs":[{"name":"self"},{"name":"i"}],"output":null}],[11,"splice","","Creates a splicing iterator that replaces the specified range in the vector with the given `replace_with` iterator and yields the removed items. `replace_with` does not need to be the same length as `range`.",57,{"inputs":[{"name":"self"},{"name":"r"},{"name":"i"}],"output":{"name":"splice"}}],[11,"drain_filter","","Creates an iterator which uses a closure to determine if an element should be removed.",57,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"drainfilter"}}],[11,"extend","","",57,{"inputs":[{"name":"self"},{"name":"i"}],"output":null}],[11,"eq","","",57,{"inputs":[{"name":"self"},{"name":"vec"}],"output":{"name":"bool"}}],[11,"ne","","",57,{"inputs":[{"name":"self"},{"name":"vec"}],"output":{"name":"bool"}}],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","alloc::borrow","",24,null],[11,"ne","","",24,null],[11,"eq","","",24,null],[11,"ne","","",24,null],[11,"eq","","",24,{"inputs":[{"name":"self"},{"name":"vec"}],"output":{"name":"bool"}}],[11,"ne","","",24,{"inputs":[{"name":"self"},{"name":"vec"}],"output":{"name":"bool"}}],[11,"eq","alloc::vec","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"eq","","",57,null],[11,"ne","","",57,null],[11,"partial_cmp","","",57,{"inputs":[{"name":"self"},{"name":"vec"}],"output":{"name":"option"}}],[11,"cmp","","",57,{"inputs":[{"name":"self"},{"name":"vec"}],"output":{"name":"ordering"}}],[11,"drop","","",57,{"inputs":[{"name":"self"}],"output":null}],[11,"default","","Creates an empty `Vec<T>`.",57,{"inputs":[],"output":{"name":"vec"}}],[11,"fmt","","",57,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"as_ref","","",57,{"inputs":[{"name":"self"}],"output":{"name":"vec"}}],[11,"as_mut","","",57,{"inputs":[{"name":"self"}],"output":{"name":"vec"}}],[11,"as_ref","","",57,null],[11,"as_mut","","",57,null],[11,"from","","",57,null],[11,"from","","",57,null],[11,"from","","",57,{"inputs":[{"name":"cow"}],"output":{"name":"vec"}}],[11,"from","","",57,{"inputs":[{"name":"box"}],"output":{"name":"vec"}}],[11,"from","alloc::boxed","",10,{"inputs":[{"name":"vec"}],"output":{"name":"box"}}],[11,"from","alloc::vec","",57,{"inputs":[{"name":"str"}],"output":{"name":"vec"}}],[11,"from","alloc::borrow","",24,null],[11,"from","","",24,{"inputs":[{"name":"vec"}],"output":{"name":"cow"}}],[11,"from_iter","","",24,{"inputs":[{"name":"i"}],"output":{"name":"cow"}}],[11,"fmt","alloc::vec","",58,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"as_slice","","Returns the remaining items of this iterator as a slice.",58,null],[11,"as_mut_slice","","Returns the remaining items of this iterator as a mutable slice.",58,null],[11,"next","","",58,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",58,null],[11,"count","","",58,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"next_back","","",58,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"is_empty","","",58,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",58,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"drop","","",58,{"inputs":[{"name":"self"}],"output":null}],[11,"fmt","","",59,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",59,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",59,null],[11,"next_back","","",59,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"drop","","",59,{"inputs":[{"name":"self"}],"output":null}],[11,"is_empty","","",59,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"fmt","","",60,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"make_place","","",60,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"pointer","","",60,null],[11,"finalize","","",60,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"fmt","","",61,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",61,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",61,null],[11,"next_back","","",61,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"drop","","",61,{"inputs":[{"name":"self"}],"output":null}],[11,"fmt","","",62,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",62,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",62,null],[11,"drop","","",62,{"inputs":[{"name":"self"}],"output":null}],[0,"vec_deque","alloc","A double-ended queue implemented with a growable ring buffer.",null,null],[3,"VecDeque","alloc::vec_deque","A double-ended queue implemented with a growable ring buffer.",null,null],[3,"Iter","","An iterator over the elements of a `VecDeque`.",null,null],[3,"IterMut","","A mutable iterator over the elements of a `VecDeque`.",null,null],[3,"IntoIter","","An owning iterator over the elements of a `VecDeque`.",null,null],[3,"Drain","","A draining iterator over the elements of a `VecDeque`.",null,null],[3,"PlaceBack","","A place for insertion at the back of a `VecDeque`.",null,null],[3,"PlaceFront","","A place for insertion at the front of a `VecDeque`.",null,null],[11,"clone","","",63,{"inputs":[{"name":"self"}],"output":{"name":"vecdeque"}}],[11,"drop","","",63,{"inputs":[{"name":"self"}],"output":null}],[11,"default","","Creates an empty `VecDeque<T>`.",63,{"inputs":[],"output":{"name":"vecdeque"}}],[11,"new","","Creates an empty `VecDeque`.",63,{"inputs":[],"output":{"name":"vecdeque"}}],[11,"with_capacity","","Creates an empty `VecDeque` with space for at least `n` elements.",63,{"inputs":[{"name":"usize"}],"output":{"name":"vecdeque"}}],[11,"get","","Retrieves an element in the `VecDeque` by index.",63,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"get_mut","","Retrieves an element in the `VecDeque` mutably by index.",63,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"swap","","Swaps elements at indices `i` and `j`.",63,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"usize"}],"output":null}],[11,"capacity","","Returns the number of elements the `VecDeque` can hold without reallocating.",63,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"reserve_exact","","Reserves the minimum capacity for exactly `additional` more elements to be inserted in the given `VecDeque`. Does nothing if the capacity is already sufficient.",63,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"reserve","","Reserves capacity for at least `additional` more elements to be inserted in the given `VecDeque`. The collection may reserve more space to avoid frequent reallocations.",63,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shrink_to_fit","","Shrinks the capacity of the `VecDeque` as much as possible.",63,{"inputs":[{"name":"self"}],"output":null}],[11,"truncate","","Shortens the `VecDeque`, dropping excess elements from the back.",63,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"iter","","Returns a front-to-back iterator.",63,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"iter_mut","","Returns a front-to-back iterator that returns mutable references.",63,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"as_slices","","Returns a pair of slices which contain, in order, the contents of the `VecDeque`.",63,null],[11,"as_mut_slices","","Returns a pair of slices which contain, in order, the contents of the `VecDeque`.",63,null],[11,"len","","Returns the number of elements in the `VecDeque`.",63,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","Returns `true` if the `VecDeque` is empty.",63,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"drain","","Create a draining iterator that removes the specified range in the `VecDeque` and yields the removed items.",63,{"inputs":[{"name":"self"},{"name":"r"}],"output":{"name":"drain"}}],[11,"clear","","Clears the buffer, removing all values.",63,{"inputs":[{"name":"self"}],"output":null}],[11,"contains","","Returns `true` if the `VecDeque` contains an element equal to the given value.",63,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"bool"}}],[11,"front","","Provides a reference to the front element, or `None` if the `VecDeque` is empty.",63,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"front_mut","","Provides a mutable reference to the front element, or `None` if the `VecDeque` is empty.",63,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"back","","Provides a reference to the back element, or `None` if the `VecDeque` is empty.",63,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"back_mut","","Provides a mutable reference to the back element, or `None` if the `VecDeque` is empty.",63,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"pop_front","","Removes the first element and returns it, or `None` if the `VecDeque` is empty.",63,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"push_front","","Prepends an element to the `VecDeque`.",63,{"inputs":[{"name":"self"},{"name":"t"}],"output":null}],[11,"push_back","","Appends an element to the back of the `VecDeque`.",63,{"inputs":[{"name":"self"},{"name":"t"}],"output":null}],[11,"pop_back","","Removes the last element from the `VecDeque` and returns it, or `None` if it is empty.",63,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"swap_remove_back","","Removes an element from anywhere in the `VecDeque` and returns it, replacing it with the last element.",63,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"swap_remove_front","","Removes an element from anywhere in the `VecDeque` and returns it, replacing it with the first element.",63,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"insert","","Inserts an element at `index` within the `VecDeque`, shifting all elements with indices greater than or equal to `index` towards the back.",63,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"t"}],"output":null}],[11,"remove","","Removes and returns the element at `index` from the `VecDeque`. Whichever end is closer to the removal point will be moved to make room, and all the affected elements will be moved to new positions. Returns `None` if `index` is out of bounds.",63,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"split_off","","Splits the collection into two at the given index.",63,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"self"}}],[11,"append","","Moves all the elements of `other` into `Self`, leaving `other` empty.",63,{"inputs":[{"name":"self"},{"name":"self"}],"output":null}],[11,"retain","","Retains only the elements specified by the predicate.",63,{"inputs":[{"name":"self"},{"name":"f"}],"output":null}],[11,"place_back","","Returns a place for insertion at the back of the `VecDeque`.",63,{"inputs":[{"name":"self"}],"output":{"name":"placeback"}}],[11,"place_front","","Returns a place for insertion at the front of the `VecDeque`.",63,{"inputs":[{"name":"self"}],"output":{"name":"placefront"}}],[11,"resize","","Modifies the `VecDeque` in-place so that `len()` is equal to new_len, either by removing excess elements or by appending clones of `value` to the back.",63,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"t"}],"output":null}],[11,"fmt","","",64,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",64,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"next","","",64,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",64,null],[11,"fold","","",64,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"f"}],"output":{"name":"acc"}}],[11,"next_back","","",64,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"rfold","","",64,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"f"}],"output":{"name":"acc"}}],[11,"is_empty","","",64,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"fmt","","",65,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",65,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",65,null],[11,"fold","","",65,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"f"}],"output":{"name":"acc"}}],[11,"next_back","","",65,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"rfold","","",65,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"f"}],"output":{"name":"acc"}}],[11,"is_empty","","",65,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",66,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"fmt","","",66,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",66,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",66,null],[11,"next_back","","",66,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"is_empty","","",66,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"fmt","","",67,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"drop","","",67,{"inputs":[{"name":"self"}],"output":null}],[11,"next","","",67,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",67,null],[11,"next_back","","",67,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"eq","","",63,{"inputs":[{"name":"self"},{"name":"vecdeque"}],"output":{"name":"bool"}}],[11,"eq","","",63,{"inputs":[{"name":"self"},{"name":"vec"}],"output":{"name":"bool"}}],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"eq","","",63,null],[11,"partial_cmp","","",63,{"inputs":[{"name":"self"},{"name":"vecdeque"}],"output":{"name":"option"}}],[11,"cmp","","",63,{"inputs":[{"name":"self"},{"name":"vecdeque"}],"output":{"name":"ordering"}}],[11,"hash","","",63,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"index","","",63,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"a"}}],[11,"index_mut","","",63,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"a"}}],[11,"from_iter","","",63,{"inputs":[{"name":"t"}],"output":{"name":"vecdeque"}}],[11,"into_iter","","Consumes the list into a front-to-back iterator yielding elements by value.",63,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"extend","","",63,{"inputs":[{"name":"self"},{"name":"t"}],"output":null}],[11,"extend","","",63,{"inputs":[{"name":"self"},{"name":"i"}],"output":null}],[11,"fmt","","",63,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"from","","",63,{"inputs":[{"name":"vec"}],"output":{"name":"self"}}],[11,"from","alloc::vec","",57,{"inputs":[{"name":"vecdeque"}],"output":{"name":"self"}}],[11,"fmt","alloc::vec_deque","",68,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"make_place","","",68,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"pointer","","",68,null],[11,"finalize","","",68,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"fmt","","",69,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"make_place","","",69,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"pointer","","",69,null],[11,"finalize","","",69,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[0,"btree_map","alloc","A map based on a B-Tree.",null,null],[3,"BTreeMap","alloc::btree_map","A map based on a B-Tree.",null,null],[3,"Iter","","An iterator over the entries of a `BTreeMap`.",null,null],[3,"IterMut","","A mutable iterator over the entries of a `BTreeMap`.",null,null],[3,"IntoIter","","An owning iterator over the entries of a `BTreeMap`.",null,null],[3,"Keys","","An iterator over the keys of a `BTreeMap`.",null,null],[3,"Values","","An iterator over the values of a `BTreeMap`.",null,null],[3,"ValuesMut","","A mutable iterator over the values of a `BTreeMap`.",null,null],[3,"Range","","An iterator over a sub-range of entries in a `BTreeMap`.",null,null],[3,"RangeMut","","A mutable iterator over a sub-range of entries in a `BTreeMap`.",null,null],[3,"VacantEntry","","A view into a vacant entry in a `BTreeMap`. It is part of the [`Entry`] enum.",null,null],[3,"OccupiedEntry","","A view into an occupied entry in a `BTreeMap`. It is part of the [`Entry`] enum.",null,null],[4,"Entry","","A view into a single entry in a map, which may either be vacant or occupied.",null,null],[13,"Vacant","","A vacant entry.",70,null],[13,"Occupied","","An occupied entry.",70,null],[0,"btree_set","alloc","A set based on a B-Tree.",null,null],[3,"BTreeSet","alloc::btree_set","A set based on a B-Tree.",null,null],[3,"Iter","","An iterator over the items of a `BTreeSet`.",null,null],[3,"IntoIter","","An owning iterator over the items of a `BTreeSet`.",null,null],[3,"Range","","An iterator over a sub-range of items in a `BTreeSet`.",null,null],[3,"Difference","","A lazy iterator producing elements in the difference of `BTreeSet`s.",null,null],[3,"SymmetricDifference","","A lazy iterator producing elements in the symmetric difference of `BTreeSet`s.",null,null],[3,"Intersection","","A lazy iterator producing elements in the intersection of `BTreeSet`s.",null,null],[3,"Union","","A lazy iterator producing elements in the union of `BTreeSet`s.",null,null],[11,"clone","alloc","",0,{"inputs":[{"name":"self"}],"output":{"name":"bound"}}],[11,"fmt","","",0,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",0,null],[11,"eq","","",0,{"inputs":[{"name":"self"},{"name":"bound"}],"output":{"name":"bool"}}],[11,"ne","","",0,{"inputs":[{"name":"self"},{"name":"bound"}],"output":{"name":"bool"}}],[14,"vec","","Creates a [`Vec`] containing the arguments.",null,null],[14,"format","","Creates a `String` using interpolation of runtime expressions.",null,null],[11,"from","alloc::vec","",57,{"inputs":[{"name":"binaryheap"}],"output":{"name":"vec"}}],[11,"drop","alloc::btree_map","",71,{"inputs":[{"name":"self"}],"output":null}],[11,"clone","","",71,{"inputs":[{"name":"self"}],"output":{"name":"btreemap"}}],[11,"fmt","","",72,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",73,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",74,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",75,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",76,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",77,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",78,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",79,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",70,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",80,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",81,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Makes a new empty BTreeMap with a reasonable choice for B.",71,{"inputs":[],"output":{"name":"btreemap"}}],[11,"clear","","Clears the map, removing all values.",71,{"inputs":[{"name":"self"}],"output":null}],[11,"get","","Returns a reference to the value corresponding to the key.",71,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"option"}}],[11,"contains_key","","Returns `true` if the map contains a value for the specified key.",71,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"bool"}}],[11,"get_mut","","Returns a mutable reference to the value corresponding to the key.",71,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"option"}}],[11,"insert","","Inserts a key-value pair into the map.",71,{"inputs":[{"name":"self"},{"name":"k"},{"name":"v"}],"output":{"name":"option"}}],[11,"remove","","Removes a key from the map, returning the value at the key if the key was previously in the map.",71,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"option"}}],[11,"append","","Moves all elements from `other` into `Self`, leaving `other` empty.",71,{"inputs":[{"name":"self"},{"name":"self"}],"output":null}],[11,"range","","Constructs a double-ended iterator over a sub-range of elements in the map. The simplest way is to use the range syntax `min..max`, thus `range(min..max)` will yield elements from min (inclusive) to max (exclusive). The range may also be entered as `(Bound<T>, Bound<T>)`, so for example `range((Excluded(4), Included(10)))` will yield a left-exclusive, right-inclusive range from 4 to 10.",71,{"inputs":[{"name":"self"},{"name":"r"}],"output":{"name":"range"}}],[11,"range_mut","","Constructs a mutable double-ended iterator over a sub-range of elements in the map. The simplest way is to use the range syntax `min..max`, thus `range(min..max)` will yield elements from min (inclusive) to max (exclusive). The range may also be entered as `(Bound<T>, Bound<T>)`, so for example `range((Excluded(4), Included(10)))` will yield a left-exclusive, right-inclusive range from 4 to 10.",71,{"inputs":[{"name":"self"},{"name":"r"}],"output":{"name":"rangemut"}}],[11,"entry","","Gets the given key's corresponding entry in the map for in-place manipulation.",71,{"inputs":[{"name":"self"},{"name":"k"}],"output":{"name":"entry"}}],[11,"split_off","","Splits the collection into two at the given key. Returns everything after the given key, including the key.",71,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"self"}}],[11,"next","","",72,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",72,null],[11,"next_back","","",72,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"len","","",72,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"clone","","",72,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"next","","",73,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",73,null],[11,"next_back","","",73,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"len","","",73,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"into_iter","","",71,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"drop","","",74,{"inputs":[{"name":"self"}],"output":null}],[11,"next","","",74,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",74,null],[11,"next_back","","",74,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"len","","",74,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"next","","",75,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",75,null],[11,"next_back","","",75,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"len","","",75,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"clone","","",75,{"inputs":[{"name":"self"}],"output":{"name":"keys"}}],[11,"next","","",76,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",76,null],[11,"next_back","","",76,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"len","","",76,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"clone","","",76,{"inputs":[{"name":"self"}],"output":{"name":"values"}}],[11,"next","","",78,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",77,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",77,null],[11,"next_back","","",77,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"len","","",77,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"next_back","","",78,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",78,{"inputs":[{"name":"self"}],"output":{"name":"range"}}],[11,"next","","",79,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",79,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"from_iter","","",71,{"inputs":[{"name":"t"}],"output":{"name":"btreemap"}}],[11,"extend","","",71,{"inputs":[{"name":"self"},{"name":"t"}],"output":null}],[11,"extend","","",71,{"inputs":[{"name":"self"},{"name":"i"}],"output":null}],[11,"hash","","",71,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"default","","Creates an empty `BTreeMap<K, V>`.",71,{"inputs":[],"output":{"name":"btreemap"}}],[11,"eq","","",71,{"inputs":[{"name":"self"},{"name":"btreemap"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",71,{"inputs":[{"name":"self"},{"name":"btreemap"}],"output":{"name":"option"}}],[11,"cmp","","",71,{"inputs":[{"name":"self"},{"name":"btreemap"}],"output":{"name":"ordering"}}],[11,"fmt","","",71,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"index","","",71,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"v"}}],[11,"iter","","Gets an iterator over the entries of the map, sorted by key.",71,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"iter_mut","","Gets a mutable iterator over the entries of the map, sorted by key.",71,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"keys","","Gets an iterator over the keys of the map, in sorted order.",71,{"inputs":[{"name":"self"}],"output":{"name":"keys"}}],[11,"values","","Gets an iterator over the values of the map, in order by key.",71,{"inputs":[{"name":"self"}],"output":{"name":"values"}}],[11,"values_mut","","Gets a mutable iterator over the values of the map, in order by key.",71,{"inputs":[{"name":"self"}],"output":{"name":"valuesmut"}}],[11,"len","","Returns the number of elements in the map.",71,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","Returns `true` if the map contains no elements.",71,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"or_insert","","Ensures a value is in the entry by inserting the default if empty, and returns a mutable reference to the value in the entry.",70,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"v"}}],[11,"or_insert_with","","Ensures a value is in the entry by inserting the result of the default function if empty, and returns a mutable reference to the value in the entry.",70,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"v"}}],[11,"key","","Returns a reference to this entry's key.",70,{"inputs":[{"name":"self"}],"output":{"name":"k"}}],[11,"and_modify","","Provides in-place mutable access to an occupied entry before any potential inserts into the map.",70,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"self"}}],[11,"or_default","","Ensures a value is in the entry by inserting the default value if empty, and returns a mutable reference to the value in the entry.",70,{"inputs":[{"name":"self"}],"output":{"name":"v"}}],[11,"key","","Gets a reference to the key that would be used when inserting a value through the VacantEntry.",80,{"inputs":[{"name":"self"}],"output":{"name":"k"}}],[11,"into_key","","Take ownership of the key.",80,{"inputs":[{"name":"self"}],"output":{"name":"k"}}],[11,"insert","","Sets the value of the entry with the `VacantEntry`'s key, and returns a mutable reference to it.",80,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"v"}}],[11,"key","","Gets a reference to the key in the entry.",81,{"inputs":[{"name":"self"}],"output":{"name":"k"}}],[11,"remove_entry","","Take ownership of the key and value from the map.",81,null],[11,"get","","Gets a reference to the value in the entry.",81,{"inputs":[{"name":"self"}],"output":{"name":"v"}}],[11,"get_mut","","Gets a mutable reference to the value in the entry.",81,{"inputs":[{"name":"self"}],"output":{"name":"v"}}],[11,"into_mut","","Converts the entry into a mutable reference to its value.",81,{"inputs":[{"name":"self"}],"output":{"name":"v"}}],[11,"insert","","Sets the value of the entry with the `OccupiedEntry`'s key, and returns the entry's old value.",81,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"v"}}],[11,"remove","","Takes the value of the entry out of the map, and returns it.",81,{"inputs":[{"name":"self"}],"output":{"name":"v"}}],[11,"clone","alloc::btree_set","",82,{"inputs":[{"name":"self"}],"output":{"name":"btreeset"}}],[11,"hash","","",82,null],[11,"eq","","",82,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"ne","","",82,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"cmp","","",82,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",82,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"option"}}],[11,"lt","","",82,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"le","","",82,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"gt","","",82,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"ge","","",82,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"fmt","","",83,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",84,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",85,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",86,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",87,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",88,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",89,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Makes a new `BTreeSet` with a reasonable choice of B.",82,{"inputs":[],"output":{"name":"btreeset"}}],[11,"iter","","Gets an iterator that visits the values in the `BTreeSet` in ascending order.",82,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"range","","Constructs a double-ended iterator over a sub-range of elements in the set. The simplest way is to use the range syntax `min..max`, thus `range(min..max)` will yield elements from min (inclusive) to max (exclusive). The range may also be entered as `(Bound<T>, Bound<T>)`, so for example `range((Excluded(4), Included(10)))` will yield a left-exclusive, right-inclusive range from 4 to 10.",82,{"inputs":[{"name":"self"},{"name":"r"}],"output":{"name":"range"}}],[11,"difference","","Visits the values representing the difference, i.e. the values that are in `self` but not in `other`, in ascending order.",82,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"difference"}}],[11,"symmetric_difference","","Visits the values representing the symmetric difference, i.e. the values that are in `self` or in `other` but not in both, in ascending order.",82,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"symmetricdifference"}}],[11,"intersection","","Visits the values representing the intersection, i.e. the values that are both in `self` and `other`, in ascending order.",82,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"intersection"}}],[11,"union","","Visits the values representing the union, i.e. all the values in `self` or `other`, without duplicates, in ascending order.",82,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"union"}}],[11,"len","","Returns the number of elements in the set.",82,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","Returns `true` if the set contains no elements.",82,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clear","","Clears the set, removing all values.",82,{"inputs":[{"name":"self"}],"output":null}],[11,"contains","","Returns `true` if the set contains a value.",82,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"bool"}}],[11,"get","","Returns a reference to the value in the set, if any, that is equal to the given value.",82,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"option"}}],[11,"is_disjoint","","Returns `true` if `self` has no elements in common with `other`. This is equivalent to checking for an empty intersection.",82,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"is_subset","","Returns `true` if the set is a subset of another, i.e. `other` contains at least all the values in `self`.",82,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"is_superset","","Returns `true` if the set is a superset of another, i.e. `self` contains at least all the values in `other`.",82,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"insert","","Adds a value to the set.",82,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"bool"}}],[11,"replace","","Adds a value to the set, replacing the existing value, if any, that is equal to the given one. Returns the replaced value.",82,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"option"}}],[11,"remove","","Removes a value from the set. Returns `true` if the value was present in the set.",82,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"bool"}}],[11,"take","","Removes and returns the value in the set, if any, that is equal to the given one.",82,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"option"}}],[11,"append","","Moves all elements from `other` into `Self`, leaving `other` empty.",82,{"inputs":[{"name":"self"},{"name":"self"}],"output":null}],[11,"split_off","","Splits the collection into two at the given key. Returns everything after the given key, including the key.",82,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"self"}}],[11,"from_iter","","",82,{"inputs":[{"name":"i"}],"output":{"name":"btreeset"}}],[11,"into_iter","","Gets an iterator for moving out the `BTreeSet`'s contents.",82,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"extend","","",82,{"inputs":[{"name":"self"},{"name":"iter"}],"output":null}],[11,"extend","","",82,{"inputs":[{"name":"self"},{"name":"i"}],"output":null}],[11,"default","","Makes an empty `BTreeSet<T>` with a reasonable choice of B.",82,{"inputs":[],"output":{"name":"btreeset"}}],[11,"fmt","","",82,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",83,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"next","","",83,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",83,null],[11,"next_back","","",83,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"len","","",83,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"next","","",84,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",84,null],[11,"next_back","","",84,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"len","","",84,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"clone","","",85,{"inputs":[{"name":"self"}],"output":{"name":"range"}}],[11,"next","","",85,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",85,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",86,{"inputs":[{"name":"self"}],"output":{"name":"difference"}}],[11,"next","","",86,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",86,null],[11,"clone","","",87,{"inputs":[{"name":"self"}],"output":{"name":"symmetricdifference"}}],[11,"next","","",87,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",87,null],[11,"clone","","",88,{"inputs":[{"name":"self"}],"output":{"name":"intersection"}}],[11,"next","","",88,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",88,null],[11,"clone","","",89,{"inputs":[{"name":"self"}],"output":{"name":"union"}}],[11,"next","","",89,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",89,null],[11,"next_back","alloc::str","",90,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",90,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",90,{"inputs":[{"name":"self"}],"output":{"name":"splitwhitespace"}}],[11,"fmt","","",90,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",91,{"inputs":[{"name":"self"},{"name":"parseboolerror"}],"output":{"name":"bool"}}],[11,"ne","","",91,{"inputs":[{"name":"self"},{"name":"parseboolerror"}],"output":{"name":"bool"}}],[11,"eq","alloc::str::pattern","",47,{"inputs":[{"name":"self"},{"name":"searchstep"}],"output":{"name":"bool"}}],[11,"ne","","",47,{"inputs":[{"name":"self"},{"name":"searchstep"}],"output":{"name":"bool"}}],[11,"eq","alloc::str","",92,{"inputs":[{"name":"self"},{"name":"utf8error"}],"output":{"name":"bool"}}],[11,"ne","","",92,{"inputs":[{"name":"self"},{"name":"utf8error"}],"output":{"name":"bool"}}],[11,"eq","alloc::fmt","",93,{"inputs":[{"name":"self"},{"name":"error"}],"output":{"name":"bool"}}],[11,"fmt","","",94,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",93,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","alloc::str","",91,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",92,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"haystack","alloc::str::pattern","",95,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"next","","",95,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match","","",95,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject","","",95,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"haystack","","",96,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"next","","",96,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match","","",96,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject","","",96,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"haystack","","",97,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"next","","",97,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match","","",97,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"haystack","","",98,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"next","","",98,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match","","",98,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject","","",98,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"default","alloc::fmt","",93,{"inputs":[],"output":{"name":"error"}}],[11,"clone","alloc::str","",99,{"inputs":[{"name":"self"}],"output":{"name":"split"}}],[11,"clone","alloc::str::pattern","",95,{"inputs":[{"name":"self"}],"output":{"name":"charslicesearcher"}}],[11,"clone","alloc::str","",100,{"inputs":[{"name":"self"}],"output":{"name":"matches"}}],[11,"clone","alloc::slice","",101,{"inputs":[{"name":"self"}],"output":{"name":"windows"}}],[11,"clone","alloc::str","",102,{"inputs":[{"name":"self"}],"output":{"name":"chars"}}],[11,"clone","","",103,{"inputs":[{"name":"self"}],"output":{"name":"splitterminator"}}],[11,"clone","alloc::slice","",104,{"inputs":[{"name":"self"}],"output":{"name":"rsplit"}}],[11,"clone","","",105,{"inputs":[{"name":"self"}],"output":{"name":"chunks"}}],[11,"clone","","",106,{"inputs":[{"name":"self"}],"output":{"name":"split"}}],[11,"clone","alloc::str::pattern","",47,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"clone","alloc::str","",92,{"inputs":[{"name":"self"}],"output":{"name":"utf8error"}}],[11,"clone","","",107,{"inputs":[{"name":"self"}],"output":{"name":"matchindices"}}],[11,"clone","alloc::fmt","",94,{"inputs":[{"name":"self"}],"output":{"name":"arguments"}}],[11,"clone","alloc::str","",108,{"inputs":[{"name":"self"}],"output":{"name":"linesany"}}],[11,"clone","alloc::fmt","",93,{"inputs":[{"name":"self"}],"output":{"name":"error"}}],[11,"clone","alloc::str","",109,{"inputs":[{"name":"self"}],"output":{"name":"lines"}}],[11,"clone","","",110,{"inputs":[{"name":"self"}],"output":{"name":"rmatches"}}],[11,"clone","alloc::str::pattern","",96,{"inputs":[{"name":"self"}],"output":{"name":"charpredicatesearcher"}}],[11,"clone","alloc::str","",111,{"inputs":[{"name":"self"}],"output":{"name":"rsplitn"}}],[11,"clone","","",112,{"inputs":[{"name":"self"}],"output":{"name":"rmatchindices"}}],[11,"clone","","",113,{"inputs":[{"name":"self"}],"output":{"name":"rsplit"}}],[11,"clone","","",114,{"inputs":[{"name":"self"}],"output":{"name":"charindices"}}],[11,"clone","","",91,{"inputs":[{"name":"self"}],"output":{"name":"parseboolerror"}}],[11,"clone","alloc::str::pattern","",97,{"inputs":[{"name":"self"}],"output":{"name":"strsearcher"}}],[11,"clone","alloc::str","",115,{"inputs":[{"name":"self"}],"output":{"name":"rsplitterminator"}}],[11,"clone","","",116,{"inputs":[{"name":"self"}],"output":{"name":"bytes"}}],[11,"clone","","",117,{"inputs":[{"name":"self"}],"output":{"name":"splitn"}}],[11,"clone","alloc::str::pattern","",98,{"inputs":[{"name":"self"}],"output":{"name":"charsearcher"}}],[11,"clone","alloc::slice","",118,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"partial_cmp","alloc::fmt","",93,{"inputs":[{"name":"self"},{"name":"error"}],"output":{"name":"option"}}],[11,"as_ref","alloc::slice","",118,null],[11,"fmt","alloc::str","",109,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","alloc::fmt","",93,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","alloc::str","",111,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",117,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","alloc::slice","",119,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","alloc::str","",91,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",113,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","alloc::slice","",120,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","alloc::str","",112,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","alloc::slice","",121,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","alloc::str::pattern","",97,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","alloc::slice","",118,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","alloc::fmt","",94,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","alloc::slice","",105,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","alloc::str","",92,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",114,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","alloc::slice","",122,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",104,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","alloc::str","",99,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","alloc::str::pattern","",95,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","alloc::slice","",123,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",124,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","alloc::str","",102,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","alloc::slice","",101,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","alloc::str","",115,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",110,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",100,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",116,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","alloc::slice","",106,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","alloc::str::pattern","",47,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","alloc::str","",107,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","alloc::str::pattern","",98,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",96,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","alloc::str","",103,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",108,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","alloc::slice","",125,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",126,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"write_str","alloc::fmt","",127,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"result"}}],[11,"write_char","","",127,{"inputs":[{"name":"self"},{"name":"char"}],"output":{"name":"result"}}],[11,"write_fmt","","",127,{"inputs":[{"name":"self"},{"name":"arguments"}],"output":{"name":"result"}}],[11,"next","alloc::slice","",123,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",123,null],[11,"next","","",125,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",125,null],[11,"next","alloc::str","",116,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",116,null],[11,"count","","",116,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"last","","",116,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"nth","","",116,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"all","","",116,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"any","","",116,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"find","","",116,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"option"}}],[11,"position","","",116,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"option"}}],[11,"rposition","","",116,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"option"}}],[11,"next","alloc::slice","",118,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",118,null],[11,"count","","",118,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"nth","","",118,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",118,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"all","","",118,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"any","","",118,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"find","","",118,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"position","","",118,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"rposition","","",118,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"next","alloc::str","",113,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","alloc::slice","",105,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",105,null],[11,"count","","",105,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"nth","","",105,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",105,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",106,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",106,null],[11,"next","","",124,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",124,null],[11,"next","","",101,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",101,null],[11,"count","","",101,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"nth","","",101,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",101,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","alloc::str","",109,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",109,null],[11,"next","","",100,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",114,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"count","","",114,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"size_hint","","",114,null],[11,"last","","",114,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","alloc::slice","",119,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",119,null],[11,"count","","",119,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"nth","","",119,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",119,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","alloc::str","",117,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",103,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","alloc::slice","",121,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",121,null],[11,"next","","",120,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",120,null],[11,"next","alloc::str","",112,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",111,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",108,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",108,null],[11,"next","","",102,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"count","","",102,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"size_hint","","",102,null],[11,"last","","",102,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","alloc::slice","",104,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",104,null],[11,"next","alloc::str","",110,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","alloc::slice","",122,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",122,null],[11,"count","","",122,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"nth","","",122,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",122,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"all","","",122,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"any","","",122,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"find","","",122,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"position","","",122,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"rposition","","",122,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"next","","",126,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",126,null],[11,"next","alloc::str","",107,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",115,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",99,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"is_empty","alloc::slice","",122,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_empty","","",118,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"len","alloc::str","",116,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","",116,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"next_back","alloc::slice","",101,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",123,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","alloc::str","",100,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","alloc::slice","",118,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"rfind","","",118,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"next_back","","",121,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","alloc::str","",102,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",110,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",113,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",115,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",107,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","alloc::slice","",105,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","alloc::str","",103,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",99,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","alloc::slice","",104,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","alloc::str","",112,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",109,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",114,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",108,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",116,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"rfind","","",116,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"option"}}],[11,"next_back","alloc::slice","",122,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"rfind","","",122,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"next_back","","",119,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",106,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"hash","alloc::fmt","",93,null],[11,"cmp","","",93,{"inputs":[{"name":"self"},{"name":"error"}],"output":{"name":"ordering"}}],[11,"next_back","alloc::str::pattern","",96,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match_back","","",96,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject_back","","",96,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",97,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match_back","","",97,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",98,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match_back","","",98,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject_back","","",98,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",95,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match_back","","",95,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject_back","","",95,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"pad_integral","alloc::fmt","Performs the correct padding for an integer which has already been emitted into a str. The str should not contain the sign for the integer, that will be added by this method.",127,{"inputs":[{"name":"self"},{"name":"bool"},{"name":"str"},{"name":"str"}],"output":{"name":"result"}}],[11,"pad","","This function takes a string slice and emits it to the internal buffer after applying the relevant formatting flags specified. The flags recognized for generic strings are:",127,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"result"}}],[11,"write_str","","Writes some data to the underlying buffer contained within this formatter.",127,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"result"}}],[11,"write_fmt","","Writes some formatted information into this instance",127,{"inputs":[{"name":"self"},{"name":"arguments"}],"output":{"name":"result"}}],[11,"flags","","Flags for formatting",127,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"fill","","Character used as 'fill' whenever there is alignment",127,{"inputs":[{"name":"self"}],"output":{"name":"char"}}],[11,"align","","Flag indicating what form of alignment was requested",127,{"inputs":[{"name":"self"}],"output":{"name":"alignment"}}],[11,"width","","Optionally specified integer width that the output should be",127,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"precision","","Optionally specified precision for numeric types",127,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"sign_plus","","Determines if the `+` flag was specified.",127,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"sign_minus","","Determines if the `-` flag was specified.",127,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"alternate","","Determines if the `#` flag was specified.",127,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"sign_aware_zero_pad","","Determines if the `0` flag was specified.",127,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"debug_struct","","Creates a [`DebugStruct`] builder designed to assist with creation of [`fmt::Debug`] implementations for structs.",127,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"debugstruct"}}],[11,"debug_tuple","","Creates a `DebugTuple` builder designed to assist with creation of `fmt::Debug` implementations for tuple structs.",127,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"debugtuple"}}],[11,"debug_list","","Creates a `DebugList` builder designed to assist with creation of `fmt::Debug` implementations for list-like structures.",127,{"inputs":[{"name":"self"}],"output":{"name":"debuglist"}}],[11,"debug_set","","Creates a `DebugSet` builder designed to assist with creation of `fmt::Debug` implementations for set-like structures.",127,{"inputs":[{"name":"self"}],"output":{"name":"debugset"}}],[11,"debug_map","","Creates a `DebugMap` builder designed to assist with creation of `fmt::Debug` implementations for map-like structures.",127,{"inputs":[{"name":"self"}],"output":{"name":"debugmap"}}],[11,"entry","","Adds a new entry to the list output.",128,{"inputs":[{"name":"self"},{"name":"debug"}],"output":{"name":"debuglist"}}],[11,"entries","","Adds the contents of an iterator of entries to the list output.",128,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"debuglist"}}],[11,"finish","","Finishes output and returns any error encountered.",128,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"entry","","Adds a new entry to the map output.",129,{"inputs":[{"name":"self"},{"name":"debug"},{"name":"debug"}],"output":{"name":"debugmap"}}],[11,"entries","","Adds the contents of an iterator of entries to the map output.",129,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"debugmap"}}],[11,"finish","","Finishes output and returns any error encountered.",129,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"entry","","Adds a new entry to the set output.",130,{"inputs":[{"name":"self"},{"name":"debug"}],"output":{"name":"debugset"}}],[11,"entries","","Adds the contents of an iterator of entries to the set output.",130,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"debugset"}}],[11,"finish","","Finishes output and returns any error encountered.",130,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"field","","Adds a new field to the generated struct output.",131,{"inputs":[{"name":"self"},{"name":"str"},{"name":"debug"}],"output":{"name":"debugstruct"}}],[11,"finish","","Finishes output and returns any error encountered.",131,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"field","","Adds a new field to the generated tuple struct output.",132,{"inputs":[{"name":"self"},{"name":"debug"}],"output":{"name":"debugtuple"}}],[11,"finish","","Finishes output and returns any error encountered.",132,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"as_slice","alloc::slice","View the underlying data as a subslice of the original data.",118,null],[11,"into_slice","","View the underlying data as a subslice of the original data.",122,null],[11,"borrow","alloc::vec","",57,null],[11,"borrow_mut","","",57,null],[11,"valid_up_to","alloc::str","Returns the index in the given string up to which valid UTF-8 was verified.",92,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"error_len","","Provide more information about the failure:",92,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"as_str","","View the underlying data as a subslice of the original data.",102,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"as_str","","View the underlying data as a subslice of the original data.",114,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"borrow","alloc::string","",52,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"from","alloc::vec","",57,{"inputs":[{"name":"string"}],"output":{"name":"vec"}}]],"paths":[[4,"Bound"],[3,"Excess"],[4,"AllocErr"],[8,"Alloc"],[3,"Layout"],[3,"CannotReallocInPlace"],[3,"Heap"],[8,"FnBox"],[3,"ExchangeHeapSingleton"],[3,"IntermediateBox"],[3,"Box"],[3,"Weak"],[3,"Arc"],[3,"Rc"],[3,"Weak"],[3,"RawVec"],[3,"PeekMut"],[3,"BinaryHeap"],[3,"Iter"],[3,"IntoIter"],[3,"Drain"],[3,"BinaryHeapPlace"],[8,"Borrow"],[8,"BorrowMut"],[4,"Cow"],[8,"ToOwned"],[8,"Write"],[8,"Octal"],[8,"Binary"],[8,"Display"],[8,"Debug"],[8,"LowerHex"],[8,"UpperHex"],[8,"Pointer"],[8,"LowerExp"],[8,"UpperExp"],[3,"Iter"],[3,"IterMut"],[3,"IntoIter"],[3,"LinkedList"],[3,"FrontPlace"],[3,"BackPlace"],[8,"RangeArgument"],[8,"SliceIndex"],[8,"SliceConcatExt"],[8,"FromStr"],[8,"Pattern"],[4,"SearchStep"],[8,"Searcher"],[8,"ReverseSearcher"],[3,"EncodeUtf16"],[8,"ToString"],[3,"String"],[3,"FromUtf8Error"],[3,"FromUtf16Error"],[4,"ParseError"],[3,"Drain"],[3,"Vec"],[3,"IntoIter"],[3,"Drain"],[3,"PlaceBack"],[3,"Splice"],[3,"DrainFilter"],[3,"VecDeque"],[3,"Iter"],[3,"IterMut"],[3,"IntoIter"],[3,"Drain"],[3,"PlaceBack"],[3,"PlaceFront"],[4,"Entry"],[3,"BTreeMap"],[3,"Iter"],[3,"IterMut"],[3,"IntoIter"],[3,"Keys"],[3,"Values"],[3,"ValuesMut"],[3,"Range"],[3,"RangeMut"],[3,"VacantEntry"],[3,"OccupiedEntry"],[3,"BTreeSet"],[3,"Iter"],[3,"IntoIter"],[3,"Range"],[3,"Difference"],[3,"SymmetricDifference"],[3,"Intersection"],[3,"Union"],[3,"SplitWhitespace"],[3,"ParseBoolError"],[3,"Utf8Error"],[3,"Error"],[3,"Arguments"],[3,"CharSliceSearcher"],[3,"CharPredicateSearcher"],[3,"StrSearcher"],[3,"CharSearcher"],[3,"Split"],[3,"Matches"],[3,"Windows"],[3,"Chars"],[3,"SplitTerminator"],[3,"RSplit"],[3,"Chunks"],[3,"Split"],[3,"MatchIndices"],[3,"LinesAny"],[3,"Lines"],[3,"RMatches"],[3,"RSplitN"],[3,"RMatchIndices"],[3,"RSplit"],[3,"CharIndices"],[3,"RSplitTerminator"],[3,"Bytes"],[3,"SplitN"],[3,"Iter"],[3,"ChunksMut"],[3,"SplitNMut"],[3,"RSplitMut"],[3,"IterMut"],[3,"SplitMut"],[3,"RSplitNMut"],[3,"RSplitN"],[3,"SplitN"],[3,"Formatter"],[3,"DebugList"],[3,"DebugMap"],[3,"DebugSet"],[3,"DebugStruct"],[3,"DebugTuple"]]};
searchIndex["collections"] = {"doc":"Collection types","items":[[4,"Bound","collections","An endpoint of a range of keys.",null,null],[13,"Included","","An inclusive bound.",0,null],[13,"Excluded","","An exclusive bound.",0,null],[13,"Unbounded","","An infinite endpoint. Indicates that there is no bound in this direction.",0,null],[0,"binary_heap","","A priority queue implemented with a binary heap.",null,null],[3,"BinaryHeap","collections::binary_heap","A priority queue implemented with a binary heap.",null,null],[3,"PeekMut","","Structure wrapping a mutable reference to the greatest item on a `BinaryHeap`.",null,null],[3,"Iter","","An iterator over the elements of a `BinaryHeap`.",null,null],[3,"IntoIter","","An owning iterator over the elements of a `BinaryHeap`.",null,null],[3,"Drain","","A draining iterator over the elements of a `BinaryHeap`.",null,null],[3,"BinaryHeapPlace","","",null,null],[0,"borrow","collections","A module for working with borrowed data.",null,null],[8,"ToOwned","collections::borrow","A generalization of `Clone` to borrowed data.",null,null],[16,"Owned","","",1,null],[10,"to_owned","","Creates owned data from borrowed data, usually by cloning.",1,null],[11,"clone_into","","Uses borrowed data to replace owned data, usually by cloning.",1,null],[4,"Cow","","A clone-on-write smart pointer.",null,null],[13,"Borrowed","","Borrowed data.",2,null],[13,"Owned","","Owned data.",2,null],[8,"Borrow","","A trait for borrowing data.",null,null],[10,"borrow","","Immutably borrows from an owned value.",3,{"inputs":[{"name":"self"}],"output":{"name":"borrowed"}}],[8,"BorrowMut","","A trait for mutably borrowing data.",null,null],[10,"borrow_mut","","Mutably borrows from an owned value.",4,{"inputs":[{"name":"self"}],"output":{"name":"borrowed"}}],[0,"fmt","collections","Utilities for formatting and printing `String`s",null,null],[5,"format","collections::fmt","The `format` function takes an [`Arguments`] struct and returns the resulting formatted string.",null,{"inputs":[{"name":"arguments"}],"output":{"name":"string"}}],[8,"Octal","","`o` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",5,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"DebugList","","A struct to help with `fmt::Debug` implementations.",null,null],[5,"write","","The `write` function takes an output stream, and an `Arguments` struct that can be precompiled with the `format_args!` macro.",null,{"inputs":[{"name":"write"},{"name":"arguments"}],"output":{"name":"result"}}],[8,"LowerExp","","`e` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",6,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"DebugSet","","A struct to help with `fmt::Debug` implementations.",null,null],[8,"Debug","","`?` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",7,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"DebugTuple","","A struct to help with `fmt::Debug` implementations.",null,null],[8,"Write","","A collection of methods that are required to format a message into a stream.",null,null],[10,"write_str","","Writes a slice of bytes into this writer, returning whether the write succeeded.",8,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"result"}}],[11,"write_char","","Writes a [`char`] into this writer, returning whether the write succeeded.",8,{"inputs":[{"name":"self"},{"name":"char"}],"output":{"name":"result"}}],[11,"write_fmt","","Glue for usage of the [`write!`] macro with implementors of this trait.",8,{"inputs":[{"name":"self"},{"name":"arguments"}],"output":{"name":"result"}}],[3,"Error","","The error type which is returned from formatting a message into a stream.",null,null],[3,"Formatter","","A struct to represent both where to emit formatting strings to and how they should be formatted. A mutable version of this is passed to all formatting traits.",null,null],[8,"UpperExp","","`E` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",9,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"Binary","","`b` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",10,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"UpperHex","","`X` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",11,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"Pointer","","`p` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",12,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"DebugStruct","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"Arguments","","This structure represents a safely precompiled version of a format string and its arguments. This cannot be generated at runtime because it cannot safely be done, so no constructors are given and the fields are private to prevent modification.",null,null],[3,"DebugMap","","A struct to help with `fmt::Debug` implementations.",null,null],[6,"Result","","The type returned by formatter methods.",null,null],[8,"LowerHex","","`x` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",13,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"Display","","Format trait for an empty format, `{}`.",null,null],[10,"fmt","","Formats the value using the given formatter.",14,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[0,"linked_list","collections","A doubly-linked list with owned nodes.",null,null],[3,"LinkedList","collections::linked_list","A doubly-linked list with owned nodes.",null,null],[3,"Iter","","An iterator over the elements of a `LinkedList`.",null,null],[3,"IterMut","","A mutable iterator over the elements of a `LinkedList`.",null,null],[3,"IntoIter","","An owning iterator over the elements of a `LinkedList`.",null,null],[3,"FrontPlace","","A place for insertion at the front of a `LinkedList`.",null,null],[3,"BackPlace","","A place for insertion at the back of a `LinkedList`.",null,null],[0,"range","collections","Range syntax.",null,null],[8,"RangeArgument","collections::range","`RangeArgument` is implemented by Rust's built-in range types, produced by range syntax like `..`, `a..`, `..b` or `c..d`.",null,null],[10,"start","","Start index bound.",15,{"inputs":[{"name":"self"}],"output":{"name":"bound"}}],[10,"end","","End index bound.",15,{"inputs":[{"name":"self"}],"output":{"name":"bound"}}],[0,"slice","collections","A dynamically-sized view into a contiguous sequence, `[T]`.",null,null],[8,"SliceConcatExt","collections::slice","An extension trait for concatenating slices",null,null],[16,"Output","","The resulting type after concatenation",16,null],[10,"concat","","Flattens a slice of `T` into a single value `Self::Output`.",16,null],[10,"join","","Flattens a slice of `T` into a single value `Self::Output`, placing a given separator between each.",16,null],[10,"connect","","",16,null],[5,"from_raw_parts_mut","","Performs the same functionality as `from_raw_parts`, except that a mutable slice is returned.",null,null],[3,"IterMut","","Mutable slice iterator.",null,null],[3,"SplitNMut","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits.",null,null],[3,"RSplitN","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits, starting from the end of the slice.",null,null],[3,"RSplit","","An iterator over subslices separated by elements that match a predicate function, starting from the end of the slice.",null,null],[3,"SplitMut","","An iterator over the subslices of the vector which are separated by elements that match `pred`.",null,null],[3,"Iter","","Immutable slice iterator",null,null],[3,"Windows","","An iterator over overlapping subslices of length `size`.",null,null],[3,"Chunks","","An iterator over a slice in (non-overlapping) chunks (`size` elements at a time).",null,null],[8,"SliceIndex","","A helper trait used for indexing operations.",null,null],[16,"Output","","The output type returned by methods.",17,null],[10,"get","","Returns a shared reference to the output at this location, if in bounds.",17,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"option"}}],[10,"get_mut","","Returns a mutable reference to the output at this location, if in bounds.",17,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"option"}}],[10,"get_unchecked","","Returns a shared reference to the output at this location, without performing any bounds checking.",17,null],[10,"get_unchecked_mut","","Returns a mutable reference to the output at this location, without performing any bounds checking.",17,null],[10,"index","","Returns a shared reference to the output at this location, panicking if out of bounds.",17,null],[10,"index_mut","","Returns a mutable reference to the output at this location, panicking if out of bounds.",17,null],[3,"RSplitNMut","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits, starting from the end of the slice.",null,null],[3,"SplitN","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits.",null,null],[3,"Split","","An iterator over subslices separated by elements that match a predicate function.",null,null],[3,"ChunksMut","","An iterator over a slice in (non-overlapping) mutable chunks (`size` elements at a time). When the slice len is not evenly divided by the chunk size, the last slice of the iteration will be the remainder.",null,null],[3,"RSplitMut","","An iterator over the subslices of the vector which are separated by elements that match `pred`, starting from the end of the slice.",null,null],[5,"from_raw_parts","","Forms a slice from a pointer and a length.",null,null],[0,"str","collections","Unicode string slices.",null,null],[3,"EncodeUtf16","collections::str","An iterator of [`u16`] over the string encoded as UTF-16.",null,null],[5,"from_boxed_utf8_unchecked","","Converts a boxed slice of bytes to a boxed string slice without checking that the string contains valid UTF-8.",null,{"inputs":[{"name":"box"}],"output":{"name":"box"}}],[3,"CharIndices","","An iterator over the [`char`]s of a string slice, and their positions.",null,null],[3,"RSplitTerminator","","Created with the method [`rsplit_terminator`].",null,null],[3,"ParseBoolError","","An error returned when parsing a `bool` using [`from_str`] fails",null,null],[5,"from_utf8_unchecked_mut","","Converts a slice of bytes to a string slice without checking that the string contains valid UTF-8; mutable version.",null,null],[0,"pattern","","The string Pattern API.",null,null],[8,"Pattern","collections::str::pattern","A string pattern.",null,null],[16,"Searcher","","Associated searcher for this pattern",18,null],[10,"into_searcher","","Constructs the associated searcher from `self` and the `haystack` to search in.",18,null],[11,"is_contained_in","","Checks whether the pattern matches anywhere in the haystack",18,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"is_prefix_of","","Checks whether the pattern matches at the front of the haystack",18,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"is_suffix_of","","Checks whether the pattern matches at the back of the haystack",18,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[4,"SearchStep","","Result of calling `Searcher::next()` or `ReverseSearcher::next_back()`.",null,null],[13,"Match","","Expresses that a match of the pattern has been found at `haystack[a..b]`.",19,null],[13,"Reject","","Expresses that `haystack[a..b]` has been rejected as a possible match of the pattern.",19,null],[13,"Done","","Expresses that every byte of the haystack has been visited, ending the iteration.",19,null],[8,"Searcher","","A searcher for a string pattern.",null,null],[10,"haystack","","Getter for the underlying string to be searched in",20,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[10,"next","","Performs the next search step starting from the front.",20,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match","","Find the next `Match` result. See `next()`",20,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject","","Find the next `Reject` result. See `next()`",20,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[8,"ReverseSearcher","","A reverse searcher for a string pattern.",null,null],[10,"next_back","","Performs the next search step starting from the back.",21,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match_back","","Find the next `Match` result. See `next_back()`",21,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject_back","","Find the next `Reject` result. See `next_back()`",21,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[8,"DoubleEndedSearcher","","A marker trait to express that a `ReverseSearcher` can be used for a `DoubleEndedIterator` implementation.",null,null],[3,"CharSearcher","","Associated type for `<char as Pattern<'a>>::Searcher`.",null,null],[3,"CharSliceSearcher","","Associated type for `<&[char] as Pattern<'a>>::Searcher`.",null,null],[3,"CharPredicateSearcher","","Associated type for `<F as Pattern<'a>>::Searcher`.",null,null],[3,"StrSearcher","","Associated type for `<&str as Pattern<'a>>::Searcher`.",null,null],[3,"RMatchIndices","collections::str","Created with the method [`rmatch_indices`].",null,null],[3,"RSplit","","Created with the method [`rsplit`].",null,null],[3,"RSplitN","","Created with the method [`rsplitn`].",null,null],[3,"Chars","","An iterator over the [`char`]s of a string slice.",null,null],[3,"SplitTerminator","","Created with the method [`split_terminator`].",null,null],[5,"from_utf8_unchecked","","Converts a slice of bytes to a string slice without checking that the string contains valid UTF-8.",null,null],[8,"FromStr","","A trait to abstract the idea of creating a new instance of a type from a string.",null,null],[16,"Err","","The associated error which can be returned from parsing.",22,null],[10,"from_str","","Parses a string `s` to return a value of this type.",22,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[3,"MatchIndices","","Created with the method [`match_indices`].",null,null],[5,"from_utf8_mut","","Converts a mutable slice of bytes to a mutable string slice.",null,null],[5,"from_utf8","","Converts a slice of bytes to a string slice.",null,null],[3,"RMatches","","Created with the method [`rmatches`].",null,null],[3,"LinesAny","","Created with the method [`lines_any`].",null,null],[3,"SplitN","","Created with the method [`splitn`].",null,null],[3,"Split","","Created with the method [`split`].",null,null],[3,"Bytes","","An iterator over the bytes of a string slice.",null,null],[3,"SplitWhitespace","","An iterator over the non-whitespace substrings of a string, separated by any amount of whitespace.",null,null],[3,"Lines","","An iterator over the lines of a string, as string slices.",null,null],[3,"Matches","","Created with the method [`matches`].",null,null],[3,"Utf8Error","","Errors which can occur when attempting to interpret a sequence of [`u8`] as a string.",null,null],[0,"string","collections","A UTF-8 encoded, growable string.",null,null],[3,"String","collections::string","A UTF-8 encoded, growable string.",null,null],[3,"FromUtf8Error","","A possible error value when converting a `String` from a UTF-8 byte vector.",null,null],[3,"FromUtf16Error","","A possible error value when converting a `String` from a UTF-16 byte slice.",null,null],[4,"ParseError","","An error when parsing a `String`.",null,null],[8,"ToString","","A trait for converting a value to a `String`.",null,null],[10,"to_string","","Converts the given value to a `String`.",23,{"inputs":[{"name":"self"}],"output":{"name":"string"}}],[3,"Drain","","A draining iterator for `String`.",null,null],[0,"vec","collections","A contiguous growable array type with heap-allocated contents, written `Vec<T>`.",null,null],[3,"Vec","collections::vec","A contiguous growable array type, written `Vec<T>` but pronounced 'vector'.",null,null],[3,"IntoIter","","An iterator that moves out of a vector.",null,null],[3,"Drain","","A draining iterator for `Vec<T>`.",null,null],[3,"PlaceBack","","A place for insertion at the back of a `Vec`.",null,null],[3,"Splice","","A splicing iterator for `Vec`.",null,null],[3,"DrainFilter","","An iterator produced by calling `drain_filter` on Vec.",null,null],[0,"vec_deque","collections","A double-ended queue implemented with a growable ring buffer.",null,null],[3,"VecDeque","collections::vec_deque","A double-ended queue implemented with a growable ring buffer.",null,null],[3,"Iter","","An iterator over the elements of a `VecDeque`.",null,null],[3,"IterMut","","A mutable iterator over the elements of a `VecDeque`.",null,null],[3,"IntoIter","","An owning iterator over the elements of a `VecDeque`.",null,null],[3,"Drain","","A draining iterator over the elements of a `VecDeque`.",null,null],[3,"PlaceBack","","A place for insertion at the back of a `VecDeque`.",null,null],[3,"PlaceFront","","A place for insertion at the front of a `VecDeque`.",null,null],[0,"btree_map","collections","A map based on a B-Tree.",null,null],[3,"IterMut","collections::btree_map","A mutable iterator over the entries of a `BTreeMap`.",null,null],[3,"BTreeMap","","A map based on a B-Tree.",null,null],[3,"ValuesMut","","A mutable iterator over the values of a `BTreeMap`.",null,null],[3,"Values","","An iterator over the values of a `BTreeMap`.",null,null],[3,"OccupiedEntry","","A view into an occupied entry in a `BTreeMap`. It is part of the [`Entry`] enum.",null,null],[4,"Entry","","A view into a single entry in a map, which may either be vacant or occupied.",null,null],[13,"Vacant","","A vacant entry.",24,null],[13,"Occupied","","An occupied entry.",24,null],[3,"RangeMut","","A mutable iterator over a sub-range of entries in a `BTreeMap`.",null,null],[3,"Keys","","An iterator over the keys of a `BTreeMap`.",null,null],[3,"IntoIter","","An owning iterator over the entries of a `BTreeMap`.",null,null],[3,"Iter","","An iterator over the entries of a `BTreeMap`.",null,null],[3,"Range","","An iterator over a sub-range of entries in a `BTreeMap`.",null,null],[3,"VacantEntry","","A view into a vacant entry in a `BTreeMap`. It is part of the [`Entry`] enum.",null,null],[0,"btree_set","collections","A set based on a B-Tree.",null,null],[3,"SymmetricDifference","collections::btree_set","A lazy iterator producing elements in the symmetric difference of `BTreeSet`s.",null,null],[3,"BTreeSet","","A set based on a B-Tree.",null,null],[3,"Intersection","","A lazy iterator producing elements in the intersection of `BTreeSet`s.",null,null],[3,"IntoIter","","An owning iterator over the items of a `BTreeSet`.",null,null],[3,"Difference","","A lazy iterator producing elements in the difference of `BTreeSet`s.",null,null],[3,"Union","","A lazy iterator producing elements in the union of `BTreeSet`s.",null,null],[3,"Iter","","An iterator over the items of a `BTreeSet`.",null,null],[3,"Range","","An iterator over a sub-range of items in a `BTreeSet`.",null,null],[14,"format","collections","Creates a `String` using interpolation of runtime expressions.",null,null],[14,"vec","","Creates a [`Vec`] containing the arguments.",null,null],[11,"deref_mut","collections::vec","",25,null],[11,"deref_mut","collections::binary_heap","",26,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"deref_mut","collections::string","",27,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"is_empty","collections::vec_deque","",28,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_empty","collections::binary_heap","",29,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"len","collections::btree_map","",30,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","collections::vec_deque","",31,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"len","collections::btree_map","",32,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"len","","",33,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"len","","",34,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","collections::binary_heap","",35,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_empty","collections::vec","",36,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"len","collections::btree_map","",37,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"len","collections::btree_set","",38,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","collections::vec_deque","",39,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_empty","collections::binary_heap","",40,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"len","collections::btree_set","",41,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"len","collections::btree_map","",42,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","collections::vec","",43,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"index","collections::string","",27,{"inputs":[{"name":"self"},{"name":"rangeto"}],"output":{"name":"str"}}],[11,"index","collections::vec_deque","",44,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"a"}}],[11,"index","collections::string","",27,{"inputs":[{"name":"self"},{"name":"rangetoinclusive"}],"output":{"name":"str"}}],[11,"index","collections::vec","",25,null],[11,"index","","",25,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"t"}}],[11,"index","collections::string","",27,{"inputs":[{"name":"self"},{"name":"rangefrom"}],"output":{"name":"str"}}],[11,"index","collections::vec","",25,null],[11,"index","collections::string","",27,{"inputs":[{"name":"self"},{"name":"rangefull"}],"output":{"name":"str"}}],[11,"index","","",27,{"inputs":[{"name":"self"},{"name":"rangeinclusive"}],"output":{"name":"str"}}],[11,"index","collections::vec","",25,null],[11,"index","collections::string","",27,{"inputs":[{"name":"self"},{"name":"range"}],"output":{"name":"str"}}],[11,"index","collections::vec","",25,null],[11,"index","","",25,null],[11,"index","collections::btree_map","",45,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"v"}}],[11,"index","collections::vec","",25,null],[11,"from_str","collections::string","",27,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"clone","collections::binary_heap","",40,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"clone","collections::string","",27,{"inputs":[{"name":"self"}],"output":{"name":"string"}}],[11,"clone_from","","",27,null],[11,"clone","collections::vec_deque","",39,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"clone","collections::btree_map","",45,{"inputs":[{"name":"self"}],"output":{"name":"btreemap"}}],[11,"clone","collections::btree_set","",46,{"inputs":[{"name":"self"}],"output":{"name":"union"}}],[11,"clone","","",47,{"inputs":[{"name":"self"}],"output":{"name":"btreeset"}}],[11,"clone","collections::linked_list","",48,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"clone","collections::string","",49,{"inputs":[{"name":"self"}],"output":{"name":"parseerror"}}],[11,"clone","collections::binary_heap","",50,{"inputs":[{"name":"self"}],"output":{"name":"binaryheap"}}],[11,"clone_from","","",50,null],[11,"clone","collections::btree_map","",33,{"inputs":[{"name":"self"}],"output":{"name":"keys"}}],[11,"clone","collections::btree_set","",51,{"inputs":[{"name":"self"}],"output":{"name":"intersection"}}],[11,"clone","collections::btree_map","",52,{"inputs":[{"name":"self"}],"output":{"name":"range"}}],[11,"clone","collections::btree_set","",53,{"inputs":[{"name":"self"}],"output":{"name":"range"}}],[11,"clone","collections::vec","",43,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"clone","collections::btree_set","",54,{"inputs":[{"name":"self"}],"output":{"name":"difference"}}],[11,"clone","collections::btree_map","",32,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"clone","collections::binary_heap","",35,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"clone","collections::vec","",25,{"inputs":[{"name":"self"}],"output":{"name":"vec"}}],[11,"clone_from","","",25,null],[11,"clone","collections::vec_deque","",44,{"inputs":[{"name":"self"}],"output":{"name":"vecdeque"}}],[11,"clone","collections::btree_set","",41,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"clone","","",55,{"inputs":[{"name":"self"}],"output":{"name":"symmetricdifference"}}],[11,"clone","collections::str","",56,{"inputs":[{"name":"self"}],"output":{"name":"encodeutf16"}}],[11,"clone","collections","",0,{"inputs":[{"name":"self"}],"output":{"name":"bound"}}],[11,"clone","collections::borrow","",2,{"inputs":[{"name":"self"}],"output":{"name":"cow"}}],[11,"clone_from","","",2,null],[11,"clone","collections::btree_map","",34,{"inputs":[{"name":"self"}],"output":{"name":"values"}}],[11,"clone","collections::vec_deque","",31,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"clone","collections::linked_list","",57,{"inputs":[{"name":"self"}],"output":{"name":"linkedlist"}}],[11,"clone","","",58,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"default","","Creates an empty `LinkedList<T>`.",57,{"inputs":[],"output":{"name":"linkedlist"}}],[11,"default","collections::btree_map","Creates an empty `BTreeMap<K, V>`.",45,{"inputs":[],"output":{"name":"btreemap"}}],[11,"default","collections::vec_deque","Creates an empty `VecDeque<T>`.",44,{"inputs":[],"output":{"name":"vecdeque"}}],[11,"default","collections::string","Creates an empty `String`.",27,{"inputs":[],"output":{"name":"string"}}],[11,"default","collections::vec","Creates an empty `Vec<T>`.",25,{"inputs":[],"output":{"name":"vec"}}],[11,"default","collections::btree_set","Makes an empty `BTreeSet<T>` with a reasonable choice of B.",47,{"inputs":[],"output":{"name":"btreeset"}}],[11,"default","collections::binary_heap","Creates an empty `BinaryHeap<T>`.",50,{"inputs":[],"output":{"name":"binaryheap"}}],[11,"default","collections::borrow","Creates an owned Cow<'a, B> with the default value for the contained owned value.",2,{"inputs":[],"output":{"name":"cow"}}],[11,"from_iter","collections::string","",27,{"inputs":[{"name":"i"}],"output":{"name":"string"}}],[11,"from_iter","","",27,{"inputs":[{"name":"i"}],"output":{"name":"string"}}],[11,"from_iter","collections::borrow","",2,{"inputs":[{"name":"i"}],"output":{"name":"cow"}}],[11,"from_iter","","",2,{"inputs":[{"name":"i"}],"output":{"name":"cow"}}],[11,"from_iter","collections::btree_map","",45,{"inputs":[{"name":"t"}],"output":{"name":"btreemap"}}],[11,"from_iter","collections::borrow","",2,{"inputs":[{"name":"i"}],"output":{"name":"cow"}}],[11,"from_iter","","",2,{"inputs":[{"name":"i"}],"output":{"name":"cow"}}],[11,"from_iter","collections::string","",27,{"inputs":[{"name":"i"}],"output":{"name":"string"}}],[11,"from_iter","collections::binary_heap","",50,{"inputs":[{"name":"i"}],"output":{"name":"binaryheap"}}],[11,"from_iter","collections::string","",27,{"inputs":[{"name":"i"}],"output":{"name":"string"}}],[11,"from_iter","collections::btree_set","",47,{"inputs":[{"name":"i"}],"output":{"name":"btreeset"}}],[11,"from_iter","collections::linked_list","",57,{"inputs":[{"name":"i"}],"output":{"name":"linkedlist"}}],[11,"from_iter","collections::vec","",25,{"inputs":[{"name":"i"}],"output":{"name":"vec"}}],[11,"from_iter","collections::string","",27,{"inputs":[{"name":"i"}],"output":{"name":"string"}}],[11,"from_iter","collections::vec_deque","",44,{"inputs":[{"name":"t"}],"output":{"name":"vecdeque"}}],[11,"add","collections::borrow","",2,null],[11,"add","collections::string","",27,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"string"}}],[11,"add","collections::borrow","",2,null],[11,"eq","collections::vec_deque","",44,null],[11,"eq","","",44,null],[11,"eq","","",44,null],[11,"eq","","",44,null],[11,"eq","","",44,null],[11,"eq","collections::vec","",25,null],[11,"ne","","",25,null],[11,"eq","collections::string","",27,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"ne","","",27,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"eq","collections::vec","",25,null],[11,"ne","","",25,null],[11,"eq","collections::string","",27,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"bool"}}],[11,"ne","","",27,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"bool"}}],[11,"eq","collections::vec_deque","",44,null],[11,"eq","collections::vec","",25,null],[11,"ne","","",25,null],[11,"eq","collections::vec_deque","",44,null],[11,"eq","collections::vec","",25,null],[11,"ne","","",25,null],[11,"eq","","",25,null],[11,"ne","","",25,null],[11,"eq","collections::vec_deque","",44,null],[11,"eq","","",44,{"inputs":[{"name":"self"},{"name":"vecdeque"}],"output":{"name":"bool"}}],[11,"eq","collections::vec","",25,null],[11,"ne","","",25,null],[11,"eq","","",25,null],[11,"ne","","",25,null],[11,"eq","collections::vec_deque","",44,null],[11,"eq","collections::vec","",25,null],[11,"ne","","",25,null],[11,"eq","collections::vec_deque","",44,null],[11,"eq","collections::vec","",25,null],[11,"ne","","",25,null],[11,"eq","collections::vec_deque","",44,null],[11,"eq","","",44,null],[11,"eq","collections::vec","",25,null],[11,"ne","","",25,null],[11,"eq","","",25,null],[11,"ne","","",25,null],[11,"eq","","",25,null],[11,"ne","","",25,null],[11,"eq","collections::vec_deque","",44,null],[11,"eq","collections::vec","",25,null],[11,"ne","","",25,null],[11,"eq","collections::vec_deque","",44,null],[11,"eq","","",44,null],[11,"eq","","",44,null],[11,"eq","","",44,null],[11,"eq","","",44,null],[11,"eq","","",44,null],[11,"eq","","",44,null],[11,"eq","collections::vec","",25,null],[11,"ne","","",25,null],[11,"eq","","",25,null],[11,"ne","","",25,null],[11,"eq","","",25,{"inputs":[{"name":"self"},{"name":"vec"}],"output":{"name":"bool"}}],[11,"ne","","",25,{"inputs":[{"name":"self"},{"name":"vec"}],"output":{"name":"bool"}}],[11,"eq","","",25,null],[11,"ne","","",25,null],[11,"eq","collections::vec_deque","",44,null],[11,"eq","","",44,null],[11,"eq","collections::vec","",25,null],[11,"ne","","",25,null],[11,"eq","","",25,null],[11,"ne","","",25,null],[11,"eq","","",25,null],[11,"ne","","",25,null],[11,"eq","collections::vec_deque","",44,null],[11,"eq","collections::borrow","",2,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"ne","","",2,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"eq","collections::vec_deque","",44,null],[11,"eq","","",44,null],[11,"eq","","",44,null],[11,"eq","","",44,null],[11,"eq","","",44,null],[11,"eq","collections::vec","",25,null],[11,"ne","","",25,null],[11,"eq","","",25,null],[11,"ne","","",25,null],[11,"eq","collections::vec_deque","",44,null],[11,"eq","collections::vec","",25,null],[11,"ne","","",25,null],[11,"eq","collections::vec_deque","",44,null],[11,"eq","","",44,null],[11,"eq","","",44,null],[11,"eq","collections::vec","",25,null],[11,"ne","","",25,null],[11,"eq","collections::vec_deque","",44,null],[11,"eq","","",44,null],[11,"eq","","",44,null],[11,"eq","","",44,null],[11,"eq","","",44,null],[11,"eq","collections::borrow","",2,{"inputs":[{"name":"self"},{"name":"vec"}],"output":{"name":"bool"}}],[11,"ne","","",2,{"inputs":[{"name":"self"},{"name":"vec"}],"output":{"name":"bool"}}],[11,"eq","collections::vec","",25,null],[11,"ne","","",25,null],[11,"eq","collections::linked_list","",57,{"inputs":[{"name":"self"},{"name":"linkedlist"}],"output":{"name":"bool"}}],[11,"ne","","",57,{"inputs":[{"name":"self"},{"name":"linkedlist"}],"output":{"name":"bool"}}],[11,"eq","collections::borrow","",2,null],[11,"ne","","",2,null],[11,"eq","collections::vec","",25,null],[11,"ne","","",25,null],[11,"eq","collections::vec_deque","",44,null],[11,"eq","","",44,null],[11,"eq","","",44,null],[11,"eq","","",44,null],[11,"eq","","",44,null],[11,"eq","collections::vec","",25,null],[11,"ne","","",25,null],[11,"eq","collections::vec_deque","",44,null],[11,"eq","collections::vec","",25,null],[11,"ne","","",25,null],[11,"eq","","",25,null],[11,"ne","","",25,null],[11,"eq","collections::vec_deque","",44,null],[11,"eq","","",44,null],[11,"eq","collections::vec","",25,null],[11,"ne","","",25,null],[11,"eq","","",25,null],[11,"ne","","",25,null],[11,"eq","","",25,null],[11,"ne","","",25,null],[11,"eq","collections::vec_deque","",44,null],[11,"eq","collections::vec","",25,null],[11,"ne","","",25,null],[11,"eq","collections::vec_deque","",44,null],[11,"eq","","",44,null],[11,"eq","","",44,null],[11,"eq","","",44,null],[11,"eq","collections","",0,{"inputs":[{"name":"self"},{"name":"bound"}],"output":{"name":"bool"}}],[11,"ne","","",0,{"inputs":[{"name":"self"},{"name":"bound"}],"output":{"name":"bool"}}],[11,"eq","collections::btree_set","",47,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"ne","","",47,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"eq","collections::btree_map","",45,{"inputs":[{"name":"self"},{"name":"btreemap"}],"output":{"name":"bool"}}],[11,"eq","collections::vec_deque","",44,null],[11,"eq","","",44,null],[11,"eq","collections::vec","",25,null],[11,"ne","","",25,null],[11,"eq","collections::vec_deque","",44,null],[11,"eq","","",44,null],[11,"eq","","",44,null],[11,"eq","","",44,null],[11,"eq","collections::vec","",25,null],[11,"ne","","",25,null],[11,"eq","collections::string","",27,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"ne","","",27,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"eq","collections::vec_deque","",44,null],[11,"eq","collections::vec","",25,null],[11,"ne","","",25,null],[11,"eq","","",25,null],[11,"ne","","",25,null],[11,"eq","","",25,null],[11,"ne","","",25,null],[11,"eq","collections::vec_deque","",44,null],[11,"eq","","",44,null],[11,"eq","collections::vec","",25,null],[11,"ne","","",25,null],[11,"eq","collections::vec_deque","",44,null],[11,"eq","collections::vec","",25,null],[11,"ne","","",25,null],[11,"eq","collections::vec_deque","",44,null],[11,"eq","","",44,null],[11,"eq","collections::vec","",25,null],[11,"ne","","",25,null],[11,"eq","collections::vec_deque","",44,null],[11,"eq","","",44,null],[11,"eq","","",44,null],[11,"eq","collections::vec","",25,null],[11,"ne","","",25,null],[11,"eq","","",25,null],[11,"ne","","",25,null],[11,"eq","collections::vec_deque","",44,null],[11,"eq","","",44,null],[11,"eq","","",44,null],[11,"eq","collections::vec","",25,null],[11,"ne","","",25,null],[11,"eq","collections::vec_deque","",44,null],[11,"eq","","",44,null],[11,"eq","","",44,null],[11,"eq","","",44,null],[11,"eq","collections::borrow","",2,null],[11,"ne","","",2,null],[11,"eq","collections::vec_deque","",44,null],[11,"eq","","",44,null],[11,"eq","collections::vec","",25,null],[11,"ne","","",25,null],[11,"eq","collections::vec_deque","",44,null],[11,"eq","","",44,null],[11,"eq","","",44,null],[11,"eq","","",44,null],[11,"eq","","",44,null],[11,"eq","","",44,null],[11,"eq","","",44,null],[11,"eq","collections::vec","",25,null],[11,"ne","","",25,null],[11,"eq","collections::borrow","",2,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"bool"}}],[11,"eq","collections::vec","",25,null],[11,"ne","","",25,null],[11,"eq","collections::vec_deque","",44,null],[11,"eq","collections::vec","",25,null],[11,"ne","","",25,null],[11,"eq","","",25,null],[11,"ne","","",25,null],[11,"eq","collections::vec_deque","",44,null],[11,"eq","","",44,null],[11,"eq","","",44,null],[11,"eq","collections::vec","",25,null],[11,"ne","","",25,null],[11,"eq","","",25,null],[11,"ne","","",25,null],[11,"eq","collections::borrow","",2,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"ne","","",2,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"eq","collections::vec_deque","",44,null],[11,"eq","","",44,null],[11,"eq","","",44,{"inputs":[{"name":"self"},{"name":"vec"}],"output":{"name":"bool"}}],[11,"eq","collections::vec","",25,null],[11,"ne","","",25,null],[11,"eq","collections::vec_deque","",44,null],[11,"eq","collections::vec","",25,null],[11,"ne","","",25,null],[11,"eq","","",25,null],[11,"ne","","",25,null],[11,"eq","collections::vec_deque","",44,null],[11,"eq","collections::vec","",25,null],[11,"ne","","",25,null],[11,"eq","collections::string","",27,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"bool"}}],[11,"ne","","",27,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"bool"}}],[11,"eq","collections::vec","",25,null],[11,"ne","","",25,null],[11,"eq","","",25,null],[11,"ne","","",25,null],[11,"eq","","",25,null],[11,"ne","","",25,null],[11,"eq","collections::vec_deque","",44,null],[11,"eq","","",44,null],[11,"eq","","",44,null],[11,"eq","collections::vec","",25,null],[11,"ne","","",25,null],[11,"eq","collections::vec_deque","",44,null],[11,"eq","","",44,null],[11,"eq","collections::borrow","",2,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"bool"}}],[11,"ne","","",2,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"bool"}}],[11,"eq","collections::vec","",25,null],[11,"ne","","",25,null],[11,"eq","collections::vec_deque","",44,null],[11,"eq","","",44,null],[11,"eq","","",44,null],[11,"eq","collections::vec","",25,null],[11,"ne","","",25,null],[11,"eq","","",25,null],[11,"ne","","",25,null],[11,"eq","collections::vec_deque","",44,null],[11,"eq","collections::vec","",25,null],[11,"ne","","",25,null],[11,"eq","collections::vec_deque","",44,null],[11,"eq","collections::vec","",25,null],[11,"ne","","",25,null],[11,"eq","","",25,null],[11,"ne","","",25,null],[11,"eq","collections::string","",49,{"inputs":[{"name":"self"},{"name":"parseerror"}],"output":{"name":"bool"}}],[11,"eq","collections::vec_deque","",44,null],[11,"eq","collections::vec","",25,null],[11,"ne","","",25,null],[11,"eq","","",25,null],[11,"ne","","",25,null],[11,"eq","","",25,null],[11,"ne","","",25,null],[11,"eq","collections::vec_deque","",44,null],[11,"eq","collections::vec","",25,null],[11,"ne","","",25,null],[11,"next_back","collections::btree_map","",30,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","collections::btree_set","",38,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","collections::vec","",43,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","collections::linked_list","",58,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","collections::vec_deque","",39,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","collections::string","",59,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","collections::vec_deque","",60,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","collections::vec","",61,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","collections::btree_map","",52,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","collections::binary_heap","",29,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","collections::vec_deque","",28,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"rfold","","",28,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"f"}],"output":{"name":"acc"}}],[11,"next_back","collections::binary_heap","",40,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","collections::btree_set","",53,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","collections::btree_map","",37,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","collections::vec_deque","",31,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"rfold","","",31,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"f"}],"output":{"name":"acc"}}],[11,"next_back","collections::btree_set","",41,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","collections::vec","",36,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","collections::btree_map","",34,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",32,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",33,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",42,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",62,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","collections::binary_heap","",35,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","collections::linked_list","",48,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",63,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"extend","","",57,null],[11,"extend","collections::binary_heap","",50,null],[11,"extend","collections::string","",27,null],[11,"extend","","",27,null],[11,"extend","","",27,null],[11,"extend","collections::vec","",25,null],[11,"extend","collections::linked_list","",57,null],[11,"extend","collections::vec_deque","",44,null],[11,"extend","collections::btree_map","",45,null],[11,"extend","collections::vec_deque","",44,null],[11,"extend","collections::btree_set","",47,null],[11,"extend","","",47,null],[11,"extend","collections::btree_map","",45,null],[11,"extend","collections::vec","",25,null],[11,"extend","collections::string","",27,null],[11,"extend","","",27,null],[11,"extend","collections::binary_heap","",50,null],[11,"pointer","","",64,null],[11,"pointer","collections::linked_list","",65,null],[11,"pointer","collections::vec","",66,null],[11,"pointer","collections::vec_deque","",67,null],[11,"pointer","","",68,null],[11,"pointer","collections::linked_list","",69,null],[11,"fmt","collections::string","",27,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",70,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",49,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::borrow","",2,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::string","",71,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::btree_map","",45,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",42,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::vec","",25,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::btree_map","",62,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::string","",27,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::binary_heap","",35,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::string","",49,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::linked_list","",48,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::btree_set","",51,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::vec_deque","",44,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::binary_heap","",29,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::btree_map","",52,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::btree_set","",54,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::linked_list","",65,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",57,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::btree_set","",47,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::vec","",72,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::btree_map","",33,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::vec","",61,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",36,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::btree_set","",55,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::string","",59,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::vec_deque","",67,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",28,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",60,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::btree_map","",24,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::btree_set","",46,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::btree_map","",73,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::linked_list","",63,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::vec","",43,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::vec_deque","",31,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::string","",71,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::btree_map","",37,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::str","",56,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::btree_map","",30,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::linked_list","",58,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::borrow","",2,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::btree_map","",34,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::btree_set","",53,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::vec","",66,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::binary_heap","",64,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::string","",70,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::binary_heap","",50,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::btree_map","",32,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::binary_heap","",40,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::btree_set","",38,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::vec_deque","",68,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",39,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::btree_set","",41,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections","",0,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::binary_heap","",26,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::btree_map","",74,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::linked_list","",69,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","collections::vec","",25,null],[11,"hash","collections::btree_set","",47,null],[11,"hash","collections::string","",27,null],[11,"hash","collections::vec_deque","",44,null],[11,"hash","collections","",0,null],[11,"hash","collections::linked_list","",57,null],[11,"hash","collections::btree_map","",45,null],[11,"hash","collections::borrow","",2,null],[11,"cmp","","",2,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"ordering"}}],[11,"cmp","collections::btree_set","",47,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"ordering"}}],[11,"cmp","collections::string","",27,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"ordering"}}],[11,"cmp","collections::linked_list","",57,{"inputs":[{"name":"self"},{"name":"linkedlist"}],"output":{"name":"ordering"}}],[11,"cmp","collections::btree_map","",45,{"inputs":[{"name":"self"},{"name":"btreemap"}],"output":{"name":"ordering"}}],[11,"cmp","collections::vec_deque","",44,{"inputs":[{"name":"self"},{"name":"vecdeque"}],"output":{"name":"ordering"}}],[11,"cmp","collections::vec","",25,{"inputs":[{"name":"self"},{"name":"vec"}],"output":{"name":"ordering"}}],[11,"finalize","","",66,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"finalize","collections::linked_list","",65,null],[11,"finalize","","",69,null],[11,"finalize","collections::binary_heap","",64,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"finalize","collections::vec_deque","",68,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"finalize","","",67,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"borrow_mut","collections::vec","",25,null],[11,"as_mut","","",25,{"inputs":[{"name":"self"}],"output":{"name":"vec"}}],[11,"as_mut","","",25,null],[11,"next","collections::vec_deque","",60,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",60,null],[11,"next","collections::btree_set","",54,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",54,null],[11,"next","collections::vec_deque","",31,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",31,null],[11,"fold","","",31,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"f"}],"output":{"name":"acc"}}],[11,"next","collections::linked_list","",63,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",63,null],[11,"next","collections::btree_set","",46,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",46,null],[11,"next","collections::vec","",61,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",61,null],[11,"next","collections::btree_map","",52,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",42,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",42,null],[11,"next","collections::str","",56,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",56,null],[11,"next","collections::string","",59,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",59,null],[11,"next","collections::binary_heap","",35,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",35,null],[11,"next","","",29,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",29,null],[11,"next","collections::btree_map","",37,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",37,null],[11,"next","collections::linked_list","",48,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",48,null],[11,"next","","",58,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",58,null],[11,"next","collections::vec","",36,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",36,null],[11,"next","collections::btree_set","",51,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",51,null],[11,"next","collections::btree_map","",62,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",32,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",32,null],[11,"next","collections::vec_deque","",28,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",28,null],[11,"fold","","",28,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"f"}],"output":{"name":"acc"}}],[11,"next","collections::btree_set","",53,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",38,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",38,null],[11,"next","collections::binary_heap","",40,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",40,null],[11,"next","collections::btree_map","",30,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",30,null],[11,"next","collections::vec","",72,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",72,null],[11,"next","collections::vec_deque","",39,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",39,null],[11,"next","collections::vec","",43,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",43,null],[11,"count","","",43,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"next","collections::btree_set","",55,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",55,null],[11,"next","","",41,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",41,null],[11,"next","collections::btree_map","",33,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",33,null],[11,"next","","",34,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",34,null],[11,"from","collections::string","",27,{"inputs":[{"name":"cow"}],"output":{"name":"string"}}],[11,"from","collections::vec","",25,null],[11,"from","","",25,{"inputs":[{"name":"binaryheap"}],"output":{"name":"vec"}}],[11,"from","","",25,{"inputs":[{"name":"string"}],"output":{"name":"vec"}}],[11,"from","","",25,{"inputs":[{"name":"str"}],"output":{"name":"vec"}}],[11,"from","","",25,{"inputs":[{"name":"cow"}],"output":{"name":"vec"}}],[11,"from","collections::borrow","",2,null],[11,"from","collections::vec","",25,{"inputs":[{"name":"vecdeque"}],"output":{"name":"vec"}}],[11,"from","collections::borrow","",2,{"inputs":[{"name":"vec"}],"output":{"name":"cow"}}],[11,"from","collections::vec","",25,{"inputs":[{"name":"box"}],"output":{"name":"vec"}}],[11,"from","collections::borrow","",2,{"inputs":[{"name":"str"}],"output":{"name":"cow"}}],[11,"from","collections::vec_deque","",44,{"inputs":[{"name":"vec"}],"output":{"name":"vecdeque"}}],[11,"from","collections::binary_heap","",50,{"inputs":[{"name":"vec"}],"output":{"name":"binaryheap"}}],[11,"from","collections::string","",27,{"inputs":[{"name":"box"}],"output":{"name":"string"}}],[11,"from","collections::borrow","",2,{"inputs":[{"name":"string"}],"output":{"name":"cow"}}],[11,"from","collections::string","",27,{"inputs":[{"name":"str"}],"output":{"name":"string"}}],[11,"from","collections::vec","",25,null],[11,"write_str","collections::string","",27,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"result"}}],[11,"write_char","","",27,{"inputs":[{"name":"self"},{"name":"char"}],"output":{"name":"result"}}],[11,"to_string","collections::borrow","",2,{"inputs":[{"name":"self"}],"output":{"name":"string"}}],[11,"to_string","collections::string","",27,{"inputs":[{"name":"self"}],"output":{"name":"string"}}],[11,"make_place","collections::linked_list","",65,{"inputs":[{"name":"self"}],"output":{"name":"frontplace"}}],[11,"make_place","collections::vec_deque","",68,{"inputs":[{"name":"self"}],"output":{"name":"placeback"}}],[11,"make_place","collections::linked_list","",69,{"inputs":[{"name":"self"}],"output":{"name":"backplace"}}],[11,"make_place","collections::vec_deque","",67,{"inputs":[{"name":"self"}],"output":{"name":"placefront"}}],[11,"make_place","collections::vec","",66,{"inputs":[{"name":"self"}],"output":{"name":"placeback"}}],[11,"partial_cmp","collections::vec_deque","",44,{"inputs":[{"name":"self"},{"name":"vecdeque"}],"output":{"name":"option"}}],[11,"partial_cmp","collections::btree_set","",47,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"option"}}],[11,"lt","","",47,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"le","","",47,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"gt","","",47,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"ge","","",47,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"partial_cmp","collections::linked_list","",57,{"inputs":[{"name":"self"},{"name":"linkedlist"}],"output":{"name":"option"}}],[11,"partial_cmp","collections::btree_map","",45,{"inputs":[{"name":"self"},{"name":"btreemap"}],"output":{"name":"option"}}],[11,"partial_cmp","collections::vec","",25,{"inputs":[{"name":"self"},{"name":"vec"}],"output":{"name":"option"}}],[11,"partial_cmp","collections::borrow","",2,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"option"}}],[11,"partial_cmp","collections::string","",27,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"option"}}],[11,"lt","","",27,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"bool"}}],[11,"le","","",27,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"bool"}}],[11,"gt","","",27,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"bool"}}],[11,"ge","","",27,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"bool"}}],[11,"deref","","",27,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"deref","collections::vec","",25,null],[11,"deref","collections::binary_heap","",26,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"deref","collections::borrow","",2,{"inputs":[{"name":"self"}],"output":{"name":"b"}}],[11,"drop","collections::vec","",36,null],[11,"drop","collections::btree_map","",30,null],[11,"drop","collections::binary_heap","",26,null],[11,"drop","collections::vec","",72,null],[11,"drop","","",61,null],[11,"drop","collections::string","",59,null],[11,"drop","collections::btree_map","",45,null],[11,"drop","collections::vec_deque","",60,null],[11,"drop","collections::vec","",43,null],[11,"drop","collections::vec_deque","",44,null],[11,"drop","collections::linked_list","",57,null],[11,"drop","collections::vec","",25,null],[11,"index_mut","collections::string","",27,{"inputs":[{"name":"self"},{"name":"rangeinclusive"}],"output":{"name":"str"}}],[11,"index_mut","collections::vec","",25,null],[11,"index_mut","collections::vec_deque","",44,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"a"}}],[11,"index_mut","collections::string","",27,{"inputs":[{"name":"self"},{"name":"rangefrom"}],"output":{"name":"str"}}],[11,"index_mut","","",27,{"inputs":[{"name":"self"},{"name":"range"}],"output":{"name":"str"}}],[11,"index_mut","collections::vec","",25,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"t"}}],[11,"index_mut","collections::string","",27,{"inputs":[{"name":"self"},{"name":"rangefull"}],"output":{"name":"str"}}],[11,"index_mut","collections::vec","",25,null],[11,"index_mut","","",25,null],[11,"index_mut","collections::string","",27,{"inputs":[{"name":"self"},{"name":"rangeto"}],"output":{"name":"str"}}],[11,"index_mut","collections::vec","",25,null],[11,"index_mut","","",25,null],[11,"index_mut","","",25,null],[11,"index_mut","collections::string","",27,{"inputs":[{"name":"self"},{"name":"rangetoinclusive"}],"output":{"name":"str"}}],[11,"borrow","collections::borrow","",2,{"inputs":[{"name":"self"}],"output":{"name":"b"}}],[11,"borrow","collections::string","",27,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"borrow","collections::vec","",25,null],[11,"into_iter","collections::btree_map","",45,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"into_iter","collections::vec","Creates a consuming iterator, that is, one that moves each value out of the vector (from start to end). The vector cannot be used after calling this.",25,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"into_iter","collections::binary_heap","Creates a consuming iterator, that is, one that moves each value out of the binary heap in arbitrary order. The binary heap cannot be used after calling this.",50,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"into_iter","collections::vec_deque","Consumes the list into a front-to-back iterator yielding elements by value.",44,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"into_iter","collections::linked_list","Consumes the list into an iterator yielding elements by value.",57,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"into_iter","collections::btree_set","Gets an iterator for moving out the `BTreeSet`'s contents.",47,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"as_ref","collections::borrow","",2,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"as_ref","collections::string","",27,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"as_ref","collections::vec","",25,{"inputs":[{"name":"self"}],"output":{"name":"vec"}}],[11,"as_ref","collections::string","",27,null],[11,"as_ref","collections::vec","",25,null],[11,"add_assign","collections::borrow","",2,null],[11,"add_assign","","",2,null],[11,"add_assign","collections::string","",27,null],[11,"eq","collections::str","",75,{"inputs":[{"name":"self"},{"name":"parseboolerror"}],"output":{"name":"bool"}}],[11,"ne","","",75,{"inputs":[{"name":"self"},{"name":"parseboolerror"}],"output":{"name":"bool"}}],[11,"eq","collections::str::pattern","",19,{"inputs":[{"name":"self"},{"name":"searchstep"}],"output":{"name":"bool"}}],[11,"ne","","",19,{"inputs":[{"name":"self"},{"name":"searchstep"}],"output":{"name":"bool"}}],[11,"eq","collections::str","",76,{"inputs":[{"name":"self"},{"name":"utf8error"}],"output":{"name":"bool"}}],[11,"ne","","",76,{"inputs":[{"name":"self"},{"name":"utf8error"}],"output":{"name":"bool"}}],[11,"eq","collections::fmt","",77,{"inputs":[{"name":"self"},{"name":"error"}],"output":{"name":"bool"}}],[11,"fmt","","",78,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",77,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::str","",75,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",76,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"haystack","collections::str::pattern","",79,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"next","","",79,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match","","",79,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject","","",79,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"haystack","","",80,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"next","","",80,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match","","",80,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject","","",80,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"haystack","","",81,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"next","","",81,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match","","",81,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"haystack","","",82,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"next","","",82,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match","","",82,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject","","",82,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"default","collections::fmt","",77,{"inputs":[],"output":{"name":"error"}}],[11,"clone","collections::str","",83,{"inputs":[{"name":"self"}],"output":{"name":"split"}}],[11,"clone","collections::str::pattern","",79,{"inputs":[{"name":"self"}],"output":{"name":"charslicesearcher"}}],[11,"clone","collections::str","",84,{"inputs":[{"name":"self"}],"output":{"name":"matches"}}],[11,"clone","collections::slice","",85,{"inputs":[{"name":"self"}],"output":{"name":"windows"}}],[11,"clone","collections::str","",86,{"inputs":[{"name":"self"}],"output":{"name":"chars"}}],[11,"clone","","",87,{"inputs":[{"name":"self"}],"output":{"name":"splitterminator"}}],[11,"clone","collections::slice","",88,{"inputs":[{"name":"self"}],"output":{"name":"rsplit"}}],[11,"clone","","",89,{"inputs":[{"name":"self"}],"output":{"name":"chunks"}}],[11,"clone","","",90,{"inputs":[{"name":"self"}],"output":{"name":"split"}}],[11,"clone","collections::str::pattern","",19,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"clone","collections::str","",76,{"inputs":[{"name":"self"}],"output":{"name":"utf8error"}}],[11,"clone","","",91,{"inputs":[{"name":"self"}],"output":{"name":"matchindices"}}],[11,"clone","collections::fmt","",78,{"inputs":[{"name":"self"}],"output":{"name":"arguments"}}],[11,"clone","collections::str","",92,{"inputs":[{"name":"self"}],"output":{"name":"linesany"}}],[11,"clone","collections::fmt","",77,{"inputs":[{"name":"self"}],"output":{"name":"error"}}],[11,"clone","collections::str","",93,{"inputs":[{"name":"self"}],"output":{"name":"lines"}}],[11,"clone","","",94,{"inputs":[{"name":"self"}],"output":{"name":"rmatches"}}],[11,"clone","collections::str::pattern","",80,{"inputs":[{"name":"self"}],"output":{"name":"charpredicatesearcher"}}],[11,"clone","collections::str","",95,{"inputs":[{"name":"self"}],"output":{"name":"rsplitn"}}],[11,"clone","","",96,{"inputs":[{"name":"self"}],"output":{"name":"rmatchindices"}}],[11,"clone","","",97,{"inputs":[{"name":"self"}],"output":{"name":"rsplit"}}],[11,"clone","","",98,{"inputs":[{"name":"self"}],"output":{"name":"charindices"}}],[11,"clone","","",75,{"inputs":[{"name":"self"}],"output":{"name":"parseboolerror"}}],[11,"clone","collections::str::pattern","",81,{"inputs":[{"name":"self"}],"output":{"name":"strsearcher"}}],[11,"clone","collections::str","",99,{"inputs":[{"name":"self"}],"output":{"name":"rsplitterminator"}}],[11,"clone","","",100,{"inputs":[{"name":"self"}],"output":{"name":"bytes"}}],[11,"clone","","",101,{"inputs":[{"name":"self"}],"output":{"name":"splitn"}}],[11,"clone","collections::str::pattern","",82,{"inputs":[{"name":"self"}],"output":{"name":"charsearcher"}}],[11,"clone","collections::slice","",102,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"partial_cmp","collections::fmt","",77,{"inputs":[{"name":"self"},{"name":"error"}],"output":{"name":"option"}}],[11,"as_ref","collections::slice","",102,null],[11,"fmt","collections::str","",93,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::fmt","",77,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::str","",95,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",101,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::slice","",103,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::str","",75,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",97,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::slice","",104,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::str","",96,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::slice","",105,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::str::pattern","",81,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::slice","",102,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::fmt","",78,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::slice","",89,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::str","",76,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",98,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::slice","",106,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",88,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::str","",83,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::str::pattern","",79,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::slice","",107,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",108,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::str","",86,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::slice","",85,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::str","",99,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",94,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",84,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",100,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::slice","",90,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::str::pattern","",19,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::str","",91,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::str::pattern","",82,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",80,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::str","",87,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",92,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::slice","",109,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",110,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"write_str","collections::fmt","",111,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"result"}}],[11,"write_char","","",111,{"inputs":[{"name":"self"},{"name":"char"}],"output":{"name":"result"}}],[11,"write_fmt","","",111,{"inputs":[{"name":"self"},{"name":"arguments"}],"output":{"name":"result"}}],[11,"next","collections::slice","",107,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",107,null],[11,"next","","",109,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",109,null],[11,"next","collections::str","",100,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",100,null],[11,"count","","",100,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"last","","",100,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"nth","","",100,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"all","","",100,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"any","","",100,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"find","","",100,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"option"}}],[11,"position","","",100,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"option"}}],[11,"rposition","","",100,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"option"}}],[11,"next","collections::slice","",102,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",102,null],[11,"count","","",102,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"nth","","",102,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",102,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"all","","",102,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"any","","",102,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"find","","",102,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"position","","",102,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"rposition","","",102,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"next","collections::str","",97,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","collections::slice","",89,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",89,null],[11,"count","","",89,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"nth","","",89,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",89,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",90,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",90,null],[11,"next","","",108,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",108,null],[11,"next","","",85,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",85,null],[11,"count","","",85,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"nth","","",85,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",85,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","collections::str","",93,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",93,null],[11,"next","","",84,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",98,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"count","","",98,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"size_hint","","",98,null],[11,"last","","",98,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","collections::slice","",103,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",103,null],[11,"count","","",103,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"nth","","",103,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",103,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","collections::str","",101,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",87,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","collections::slice","",105,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",105,null],[11,"next","","",104,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",104,null],[11,"next","collections::str","",96,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",95,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",92,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",92,null],[11,"next","","",86,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"count","","",86,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"size_hint","","",86,null],[11,"last","","",86,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","collections::slice","",88,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",88,null],[11,"next","collections::str","",94,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","collections::slice","",106,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",106,null],[11,"count","","",106,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"nth","","",106,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",106,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"all","","",106,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"any","","",106,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"find","","",106,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"position","","",106,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"rposition","","",106,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"next","","",110,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",110,null],[11,"next","collections::str","",91,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",99,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",83,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"is_empty","collections::slice","",106,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_empty","","",102,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"len","collections::str","",100,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","",100,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"next_back","collections::slice","",85,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",107,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","collections::str","",84,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","collections::slice","",102,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"rfind","","",102,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"next_back","","",105,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","collections::str","",86,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",94,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",97,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",99,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",91,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","collections::slice","",89,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","collections::str","",87,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",83,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","collections::slice","",88,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","collections::str","",96,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",93,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",98,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",92,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",100,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"rfind","","",100,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"option"}}],[11,"next_back","collections::slice","",106,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"rfind","","",106,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"next_back","","",103,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",90,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"hash","collections::fmt","",77,null],[11,"cmp","","",77,{"inputs":[{"name":"self"},{"name":"error"}],"output":{"name":"ordering"}}],[11,"next_back","collections::str::pattern","",80,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match_back","","",80,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject_back","","",80,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",81,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match_back","","",81,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",82,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match_back","","",82,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject_back","","",82,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",79,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match_back","","",79,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject_back","","",79,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","collections::str","",112,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",112,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",112,{"inputs":[{"name":"self"}],"output":{"name":"splitwhitespace"}}],[11,"fmt","","",112,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","collections::binary_heap","Creates an empty `BinaryHeap` as a max-heap.",50,{"inputs":[],"output":{"name":"binaryheap"}}],[11,"with_capacity","","Creates an empty `BinaryHeap` with a specific capacity. This preallocates enough memory for `capacity` elements, so that the `BinaryHeap` does not have to be reallocated until it contains at least that many values.",50,{"inputs":[{"name":"usize"}],"output":{"name":"binaryheap"}}],[11,"iter","","Returns an iterator visiting all values in the underlying vector, in arbitrary order.",50,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"peek","","Returns the greatest item in the binary heap, or `None` if it is empty.",50,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"peek_mut","","Returns a mutable reference to the greatest item in the binary heap, or `None` if it is empty.",50,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"capacity","","Returns the number of elements the binary heap can hold without reallocating.",50,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"reserve_exact","","Reserves the minimum capacity for exactly `additional` more elements to be inserted in the given `BinaryHeap`. Does nothing if the capacity is already sufficient.",50,null],[11,"reserve","","Reserves capacity for at least `additional` more elements to be inserted in the `BinaryHeap`. The collection may reserve more space to avoid frequent reallocations.",50,null],[11,"shrink_to_fit","","Discards as much additional capacity as possible.",50,null],[11,"pop","","Removes the greatest item from the binary heap and returns it, or `None` if it is empty.",50,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"push","","Pushes an item onto the binary heap.",50,null],[11,"into_vec","","Consumes the `BinaryHeap` and returns the underlying vector in arbitrary order.",50,{"inputs":[{"name":"self"}],"output":{"name":"vec"}}],[11,"into_sorted_vec","","Consumes the `BinaryHeap` and returns a vector in sorted (ascending) order.",50,{"inputs":[{"name":"self"}],"output":{"name":"vec"}}],[11,"len","","Returns the length of the binary heap.",50,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","Checks if the binary heap is empty.",50,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"drain","","Clears the binary heap, returning an iterator over the removed elements.",50,{"inputs":[{"name":"self"}],"output":{"name":"drain"}}],[11,"clear","","Drops all items from the binary heap.",50,null],[11,"append","","Moves all the elements of `other` into `self`, leaving `other` empty.",50,null],[11,"pop","","Removes the peeked value from the heap and returns it.",26,{"inputs":[{"name":"peekmut"}],"output":{"name":"t"}}],[11,"to_mut","collections::borrow","Acquires a mutable reference to the owned form of the data.",2,null],[11,"into_owned","","Extracts the owned data.",2,null],[11,"entry","collections::fmt","Adds a new entry to the list output.",113,{"inputs":[{"name":"self"},{"name":"debug"}],"output":{"name":"debuglist"}}],[11,"entries","","Adds the contents of an iterator of entries to the list output.",113,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"debuglist"}}],[11,"finish","","Finishes output and returns any error encountered.",113,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"entry","","Adds a new entry to the set output.",114,{"inputs":[{"name":"self"},{"name":"debug"}],"output":{"name":"debugset"}}],[11,"entries","","Adds the contents of an iterator of entries to the set output.",114,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"debugset"}}],[11,"finish","","Finishes output and returns any error encountered.",114,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"field","","Adds a new field to the generated tuple struct output.",115,{"inputs":[{"name":"self"},{"name":"debug"}],"output":{"name":"debugtuple"}}],[11,"finish","","Finishes output and returns any error encountered.",115,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"pad_integral","","Performs the correct padding for an integer which has already been emitted into a str. The str should not contain the sign for the integer, that will be added by this method.",111,{"inputs":[{"name":"self"},{"name":"bool"},{"name":"str"},{"name":"str"}],"output":{"name":"result"}}],[11,"pad","","This function takes a string slice and emits it to the internal buffer after applying the relevant formatting flags specified. The flags recognized for generic strings are:",111,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"result"}}],[11,"write_str","","Writes some data to the underlying buffer contained within this formatter.",111,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"result"}}],[11,"write_fmt","","Writes some formatted information into this instance",111,{"inputs":[{"name":"self"},{"name":"arguments"}],"output":{"name":"result"}}],[11,"flags","","Flags for formatting",111,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"fill","","Character used as 'fill' whenever there is alignment",111,{"inputs":[{"name":"self"}],"output":{"name":"char"}}],[11,"align","","Flag indicating what form of alignment was requested",111,{"inputs":[{"name":"self"}],"output":{"name":"alignment"}}],[11,"width","","Optionally specified integer width that the output should be",111,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"precision","","Optionally specified precision for numeric types",111,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"sign_plus","","Determines if the `+` flag was specified.",111,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"sign_minus","","Determines if the `-` flag was specified.",111,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"alternate","","Determines if the `#` flag was specified.",111,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"sign_aware_zero_pad","","Determines if the `0` flag was specified.",111,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"debug_struct","","Creates a [`DebugStruct`] builder designed to assist with creation of [`fmt::Debug`] implementations for structs.",111,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"debugstruct"}}],[11,"debug_tuple","","Creates a `DebugTuple` builder designed to assist with creation of `fmt::Debug` implementations for tuple structs.",111,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"debugtuple"}}],[11,"debug_list","","Creates a `DebugList` builder designed to assist with creation of `fmt::Debug` implementations for list-like structures.",111,{"inputs":[{"name":"self"}],"output":{"name":"debuglist"}}],[11,"debug_set","","Creates a `DebugSet` builder designed to assist with creation of `fmt::Debug` implementations for set-like structures.",111,{"inputs":[{"name":"self"}],"output":{"name":"debugset"}}],[11,"debug_map","","Creates a `DebugMap` builder designed to assist with creation of `fmt::Debug` implementations for map-like structures.",111,{"inputs":[{"name":"self"}],"output":{"name":"debugmap"}}],[11,"field","","Adds a new field to the generated struct output.",116,{"inputs":[{"name":"self"},{"name":"str"},{"name":"debug"}],"output":{"name":"debugstruct"}}],[11,"finish","","Finishes output and returns any error encountered.",116,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"entry","","Adds a new entry to the map output.",117,{"inputs":[{"name":"self"},{"name":"debug"},{"name":"debug"}],"output":{"name":"debugmap"}}],[11,"entries","","Adds the contents of an iterator of entries to the map output.",117,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"debugmap"}}],[11,"finish","","Finishes output and returns any error encountered.",117,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"new","collections::linked_list","Creates an empty `LinkedList`.",57,{"inputs":[],"output":{"name":"linkedlist"}}],[11,"append","","Moves all elements from `other` to the end of the list.",57,null],[11,"iter","","Provides a forward iterator.",57,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"iter_mut","","Provides a forward iterator with mutable references.",57,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"is_empty","","Returns `true` if the `LinkedList` is empty.",57,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"len","","Returns the length of the `LinkedList`.",57,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"clear","","Removes all elements from the `LinkedList`.",57,null],[11,"contains","","Returns `true` if the `LinkedList` contains an element equal to the given value.",57,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"bool"}}],[11,"front","","Provides a reference to the front element, or `None` if the list is empty.",57,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"front_mut","","Provides a mutable reference to the front element, or `None` if the list is empty.",57,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"back","","Provides a reference to the back element, or `None` if the list is empty.",57,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"back_mut","","Provides a mutable reference to the back element, or `None` if the list is empty.",57,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"push_front","","Adds an element first in the list.",57,null],[11,"pop_front","","Removes the first element and returns it, or `None` if the list is empty.",57,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"push_back","","Appends an element to the back of a list",57,null],[11,"pop_back","","Removes the last element from a list and returns it, or `None` if it is empty.",57,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"split_off","","Splits the list into two at the given index. Returns everything after the given index, including the index.",57,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"linkedlist"}}],[11,"front_place","","Returns a place for insertion at the front of the list.",57,{"inputs":[{"name":"self"}],"output":{"name":"frontplace"}}],[11,"back_place","","Returns a place for insertion at the back of the list.",57,{"inputs":[{"name":"self"}],"output":{"name":"backplace"}}],[11,"insert_next","","Inserts the given element just after the element most recently returned by `.next()`. The inserted element does not appear in the iteration.",63,null],[11,"peek_next","","Provides a reference to the next element, without changing the iterator.",63,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"into_slice","collections::slice","View the underlying data as a subslice of the original data.",106,null],[11,"as_slice","","View the underlying data as a subslice of the original data.",102,null],[11,"as_str","collections::str","View the underlying data as a subslice of the original data.",98,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"as_str","","View the underlying data as a subslice of the original data.",86,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"valid_up_to","","Returns the index in the given string up to which valid UTF-8 was verified.",76,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"error_len","","Provide more information about the failure:",76,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"new","collections::string","Creates a new empty `String`.",27,{"inputs":[],"output":{"name":"string"}}],[11,"with_capacity","","Creates a new empty `String` with a particular capacity.",27,{"inputs":[{"name":"usize"}],"output":{"name":"string"}}],[11,"from_utf8","","Converts a vector of bytes to a `String`.",27,{"inputs":[{"name":"vec"}],"output":{"name":"result"}}],[11,"from_utf8_lossy","","Converts a slice of bytes to a string, including invalid characters.",27,null],[11,"from_utf16","","Decode a UTF-16 encoded vector `v` into a `String`, returning [`Err`] if `v` contains any invalid data.",27,null],[11,"from_utf16_lossy","","Decode a UTF-16 encoded slice `v` into a `String`, replacing invalid data with the replacement character (U+FFFD).",27,null],[11,"from_raw_parts","","Creates a new `String` from a length, capacity, and pointer.",27,null],[11,"from_utf8_unchecked","","Converts a vector of bytes to a `String` without checking that the string contains valid UTF-8.",27,{"inputs":[{"name":"vec"}],"output":{"name":"string"}}],[11,"into_bytes","","Converts a `String` into a byte vector.",27,{"inputs":[{"name":"self"}],"output":{"name":"vec"}}],[11,"as_str","","Extracts a string slice containing the entire string.",27,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"as_mut_str","","Converts a `String` into a mutable string slice.",27,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"push_str","","Appends a given string slice onto the end of this `String`.",27,null],[11,"capacity","","Returns this `String`'s capacity, in bytes.",27,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"reserve","","Ensures that this `String`'s capacity is at least `additional` bytes larger than its length.",27,null],[11,"reserve_exact","","Ensures that this `String`'s capacity is `additional` bytes larger than its length.",27,null],[11,"shrink_to_fit","","Shrinks the capacity of this `String` to match its length.",27,null],[11,"push","","Appends the given [`char`] to the end of this `String`.",27,null],[11,"as_bytes","","Returns a byte slice of this `String`'s contents.",27,null],[11,"truncate","","Shortens this `String` to the specified length.",27,null],[11,"pop","","Removes the last character from the string buffer and returns it.",27,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"remove","","Removes a [`char`] from this `String` at a byte position and returns it.",27,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"char"}}],[11,"retain","","Retains only the characters specified by the predicate.",27,null],[11,"insert","","Inserts a character into this `String` at a byte position.",27,null],[11,"insert_str","","Inserts a string slice into this `String` at a byte position.",27,null],[11,"as_mut_vec","","Returns a mutable reference to the contents of this `String`.",27,{"inputs":[{"name":"self"}],"output":{"name":"vec"}}],[11,"len","","Returns the length of this `String`, in bytes.",27,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","Returns `true` if this `String` has a length of zero.",27,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"split_off","","Splits the string into two at the given index.",27,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"string"}}],[11,"clear","","Truncates this `String`, removing all contents.",27,null],[11,"drain","","Creates a draining iterator that removes the specified range in the string and yields the removed chars.",27,{"inputs":[{"name":"self"},{"name":"r"}],"output":{"name":"drain"}}],[11,"splice","","Creates a splicing iterator that removes the specified range in the string, and replaces it with the given string. The given string doesn't need to be the same length as the range.",27,null],[11,"into_boxed_str","","Converts this `String` into a [`Box`]`<`[`str`]`>`.",27,{"inputs":[{"name":"self"}],"output":{"name":"box"}}],[11,"as_bytes","","Returns a slice of [`u8`]s bytes that were attempted to convert to a `String`.",70,null],[11,"into_bytes","","Returns the bytes that were attempted to convert to a `String`.",70,{"inputs":[{"name":"self"}],"output":{"name":"vec"}}],[11,"utf8_error","","Fetch a `Utf8Error` to get more details about the conversion failure.",70,{"inputs":[{"name":"self"}],"output":{"name":"utf8error"}}],[11,"new","collections::vec","Constructs a new, empty `Vec<T>`.",25,{"inputs":[],"output":{"name":"vec"}}],[11,"with_capacity","","Constructs a new, empty `Vec<T>` with the specified capacity.",25,{"inputs":[{"name":"usize"}],"output":{"name":"vec"}}],[11,"from_raw_parts","","Creates a `Vec<T>` directly from the raw components of another vector.",25,null],[11,"capacity","","Returns the number of elements the vector can hold without reallocating.",25,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"reserve","","Reserves capacity for at least `additional` more elements to be inserted in the given `Vec<T>`. The collection may reserve more space to avoid frequent reallocations. After calling `reserve`, capacity will be greater than or equal to `self.len() + additional`. Does nothing if capacity is already sufficient.",25,null],[11,"reserve_exact","","Reserves the minimum capacity for exactly `additional` more elements to be inserted in the given `Vec<T>`. After calling `reserve_exact`, capacity will be greater than or equal to `self.len() + additional`. Does nothing if the capacity is already sufficient.",25,null],[11,"shrink_to_fit","","Shrinks the capacity of the vector as much as possible.",25,null],[11,"into_boxed_slice","","Converts the vector into [`Box<[T]>`][owned slice].",25,{"inputs":[{"name":"self"}],"output":{"name":"box"}}],[11,"truncate","","Shortens the vector, keeping the first `len` elements and dropping the rest.",25,null],[11,"as_slice","","Extracts a slice containing the entire vector.",25,null],[11,"as_mut_slice","","Extracts a mutable slice of the entire vector.",25,null],[11,"set_len","","Sets the length of a vector.",25,null],[11,"swap_remove","","Removes an element from the vector and returns it.",25,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"t"}}],[11,"insert","","Inserts an element at position `index` within the vector, shifting all elements after it to the right.",25,null],[11,"remove","","Removes and returns the element at position `index` within the vector, shifting all elements after it to the left.",25,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"t"}}],[11,"retain","","Retains only the elements specified by the predicate.",25,null],[11,"dedup_by_key","","Removes all but the first of consecutive elements in the vector that resolve to the same key.",25,null],[11,"dedup_by","","Removes all but the first of consecutive elements in the vector satisfying a given equality relation.",25,null],[11,"push","","Appends an element to the back of a collection.",25,null],[11,"place_back","","Returns a place for insertion at the back of the `Vec`.",25,{"inputs":[{"name":"self"}],"output":{"name":"placeback"}}],[11,"pop","","Removes the last element from a vector and returns it, or [`None`] if it is empty.",25,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"append","","Moves all the elements of `other` into `Self`, leaving `other` empty.",25,null],[11,"drain","","Creates a draining iterator that removes the specified range in the vector and yields the removed items.",25,{"inputs":[{"name":"self"},{"name":"r"}],"output":{"name":"drain"}}],[11,"clear","","Clears the vector, removing all values.",25,null],[11,"len","","Returns the number of elements in the vector, also referred to as its 'length'.",25,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","Returns `true` if the vector contains no elements.",25,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"split_off","","Splits the collection into two at the given index.",25,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"vec"}}],[11,"resize","","Resizes the `Vec` in-place so that `len` is equal to `new_len`.",25,null],[11,"extend_from_slice","","Clones and appends all elements in a slice to the `Vec`.",25,null],[11,"resize_default","","Resizes the `Vec` in-place so that `len` is equal to `new_len`.",25,null],[11,"dedup","","Removes consecutive repeated elements in the vector.",25,null],[11,"remove_item","","Removes the first instance of `item` from the vector if the item exists.",25,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"option"}}],[11,"splice","","Creates a splicing iterator that replaces the specified range in the vector with the given `replace_with` iterator and yields the removed items. `replace_with` does not need to be the same length as `range`.",25,{"inputs":[{"name":"self"},{"name":"r"},{"name":"i"}],"output":{"name":"splice"}}],[11,"drain_filter","","Creates an iterator which uses a closure to determine if an element should be removed.",25,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"drainfilter"}}],[11,"as_slice","","Returns the remaining items of this iterator as a slice.",43,null],[11,"as_mut_slice","","Returns the remaining items of this iterator as a mutable slice.",43,null],[11,"new","collections::vec_deque","Creates an empty `VecDeque`.",44,{"inputs":[],"output":{"name":"vecdeque"}}],[11,"with_capacity","","Creates an empty `VecDeque` with space for at least `n` elements.",44,{"inputs":[{"name":"usize"}],"output":{"name":"vecdeque"}}],[11,"get","","Retrieves an element in the `VecDeque` by index.",44,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"get_mut","","Retrieves an element in the `VecDeque` mutably by index.",44,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"swap","","Swaps elements at indices `i` and `j`.",44,null],[11,"capacity","","Returns the number of elements the `VecDeque` can hold without reallocating.",44,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"reserve_exact","","Reserves the minimum capacity for exactly `additional` more elements to be inserted in the given `VecDeque`. Does nothing if the capacity is already sufficient.",44,null],[11,"reserve","","Reserves capacity for at least `additional` more elements to be inserted in the given `VecDeque`. The collection may reserve more space to avoid frequent reallocations.",44,null],[11,"shrink_to_fit","","Shrinks the capacity of the `VecDeque` as much as possible.",44,null],[11,"truncate","","Shortens the `VecDeque`, dropping excess elements from the back.",44,null],[11,"iter","","Returns a front-to-back iterator.",44,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"iter_mut","","Returns a front-to-back iterator that returns mutable references.",44,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"as_slices","","Returns a pair of slices which contain, in order, the contents of the `VecDeque`.",44,null],[11,"as_mut_slices","","Returns a pair of slices which contain, in order, the contents of the `VecDeque`.",44,null],[11,"len","","Returns the number of elements in the `VecDeque`.",44,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","Returns `true` if the `VecDeque` is empty.",44,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"drain","","Create a draining iterator that removes the specified range in the `VecDeque` and yields the removed items.",44,{"inputs":[{"name":"self"},{"name":"r"}],"output":{"name":"drain"}}],[11,"clear","","Clears the buffer, removing all values.",44,null],[11,"contains","","Returns `true` if the `VecDeque` contains an element equal to the given value.",44,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"bool"}}],[11,"front","","Provides a reference to the front element, or `None` if the `VecDeque` is empty.",44,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"front_mut","","Provides a mutable reference to the front element, or `None` if the `VecDeque` is empty.",44,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"back","","Provides a reference to the back element, or `None` if the `VecDeque` is empty.",44,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"back_mut","","Provides a mutable reference to the back element, or `None` if the `VecDeque` is empty.",44,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"pop_front","","Removes the first element and returns it, or `None` if the `VecDeque` is empty.",44,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"push_front","","Prepends an element to the `VecDeque`.",44,null],[11,"push_back","","Appends an element to the back of the `VecDeque`.",44,null],[11,"pop_back","","Removes the last element from the `VecDeque` and returns it, or `None` if it is empty.",44,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"swap_remove_back","","Removes an element from anywhere in the `VecDeque` and returns it, replacing it with the last element.",44,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"swap_remove_front","","Removes an element from anywhere in the `VecDeque` and returns it, replacing it with the first element.",44,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"insert","","Inserts an element at `index` within the `VecDeque`, shifting all elements with indices greater than or equal to `index` towards the back.",44,null],[11,"remove","","Removes and returns the element at `index` from the `VecDeque`. Whichever end is closer to the removal point will be moved to make room, and all the affected elements will be moved to new positions. Returns `None` if `index` is out of bounds.",44,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"split_off","","Splits the collection into two at the given index.",44,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"vecdeque"}}],[11,"append","","Moves all the elements of `other` into `Self`, leaving `other` empty.",44,null],[11,"retain","","Retains only the elements specified by the predicate.",44,null],[11,"place_back","","Returns a place for insertion at the back of the `VecDeque`.",44,{"inputs":[{"name":"self"}],"output":{"name":"placeback"}}],[11,"place_front","","Returns a place for insertion at the front of the `VecDeque`.",44,{"inputs":[{"name":"self"}],"output":{"name":"placefront"}}],[11,"resize","","Modifies the `VecDeque` in-place so that `len()` is equal to new_len, either by removing excess elements or by appending clones of `value` to the back.",44,null],[11,"new","collections::btree_map","Makes a new empty BTreeMap with a reasonable choice for B.",45,{"inputs":[],"output":{"name":"btreemap"}}],[11,"clear","","Clears the map, removing all values.",45,null],[11,"get","","Returns a reference to the value corresponding to the key.",45,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"option"}}],[11,"contains_key","","Returns `true` if the map contains a value for the specified key.",45,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"bool"}}],[11,"get_mut","","Returns a mutable reference to the value corresponding to the key.",45,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"option"}}],[11,"insert","","Inserts a key-value pair into the map.",45,{"inputs":[{"name":"self"},{"name":"k"},{"name":"v"}],"output":{"name":"option"}}],[11,"remove","","Removes a key from the map, returning the value at the key if the key was previously in the map.",45,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"option"}}],[11,"append","","Moves all elements from `other` into `Self`, leaving `other` empty.",45,null],[11,"range","","Constructs a double-ended iterator over a sub-range of elements in the map. The simplest way is to use the range syntax `min..max`, thus `range(min..max)` will yield elements from min (inclusive) to max (exclusive). The range may also be entered as `(Bound<T>, Bound<T>)`, so for example `range((Excluded(4), Included(10)))` will yield a left-exclusive, right-inclusive range from 4 to 10.",45,{"inputs":[{"name":"self"},{"name":"r"}],"output":{"name":"range"}}],[11,"range_mut","","Constructs a mutable double-ended iterator over a sub-range of elements in the map. The simplest way is to use the range syntax `min..max`, thus `range(min..max)` will yield elements from min (inclusive) to max (exclusive). The range may also be entered as `(Bound<T>, Bound<T>)`, so for example `range((Excluded(4), Included(10)))` will yield a left-exclusive, right-inclusive range from 4 to 10.",45,{"inputs":[{"name":"self"},{"name":"r"}],"output":{"name":"rangemut"}}],[11,"entry","","Gets the given key's corresponding entry in the map for in-place manipulation.",45,{"inputs":[{"name":"self"},{"name":"k"}],"output":{"name":"entry"}}],[11,"split_off","","Splits the collection into two at the given key. Returns everything after the given key, including the key.",45,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"btreemap"}}],[11,"iter","","Gets an iterator over the entries of the map, sorted by key.",45,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"iter_mut","","Gets a mutable iterator over the entries of the map, sorted by key.",45,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"keys","","Gets an iterator over the keys of the map, in sorted order.",45,{"inputs":[{"name":"self"}],"output":{"name":"keys"}}],[11,"values","","Gets an iterator over the values of the map, in order by key.",45,{"inputs":[{"name":"self"}],"output":{"name":"values"}}],[11,"values_mut","","Gets a mutable iterator over the values of the map, in order by key.",45,{"inputs":[{"name":"self"}],"output":{"name":"valuesmut"}}],[11,"len","","Returns the number of elements in the map.",45,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","Returns `true` if the map contains no elements.",45,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"key","","Gets a reference to the key in the entry.",73,{"inputs":[{"name":"self"}],"output":{"name":"k"}}],[11,"remove_entry","","Take ownership of the key and value from the map.",73,null],[11,"get","","Gets a reference to the value in the entry.",73,{"inputs":[{"name":"self"}],"output":{"name":"v"}}],[11,"get_mut","","Gets a mutable reference to the value in the entry.",73,{"inputs":[{"name":"self"}],"output":{"name":"v"}}],[11,"into_mut","","Converts the entry into a mutable reference to its value.",73,{"inputs":[{"name":"self"}],"output":{"name":"v"}}],[11,"insert","","Sets the value of the entry with the `OccupiedEntry`'s key, and returns the entry's old value.",73,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"v"}}],[11,"remove","","Takes the value of the entry out of the map, and returns it.",73,{"inputs":[{"name":"self"}],"output":{"name":"v"}}],[11,"or_insert","","Ensures a value is in the entry by inserting the default if empty, and returns a mutable reference to the value in the entry.",24,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"v"}}],[11,"or_insert_with","","Ensures a value is in the entry by inserting the result of the default function if empty, and returns a mutable reference to the value in the entry.",24,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"v"}}],[11,"key","","Returns a reference to this entry's key.",24,{"inputs":[{"name":"self"}],"output":{"name":"k"}}],[11,"and_modify","","Provides in-place mutable access to an occupied entry before any potential inserts into the map.",24,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"entry"}}],[11,"or_default","","Ensures a value is in the entry by inserting the default value if empty, and returns a mutable reference to the value in the entry.",24,{"inputs":[{"name":"self"}],"output":{"name":"v"}}],[11,"key","","Gets a reference to the key that would be used when inserting a value through the VacantEntry.",74,{"inputs":[{"name":"self"}],"output":{"name":"k"}}],[11,"into_key","","Take ownership of the key.",74,{"inputs":[{"name":"self"}],"output":{"name":"k"}}],[11,"insert","","Sets the value of the entry with the `VacantEntry`'s key, and returns a mutable reference to it.",74,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"v"}}],[11,"new","collections::btree_set","Makes a new `BTreeSet` with a reasonable choice of B.",47,{"inputs":[],"output":{"name":"btreeset"}}],[11,"iter","","Gets an iterator that visits the values in the `BTreeSet` in ascending order.",47,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"range","","Constructs a double-ended iterator over a sub-range of elements in the set. The simplest way is to use the range syntax `min..max`, thus `range(min..max)` will yield elements from min (inclusive) to max (exclusive). The range may also be entered as `(Bound<T>, Bound<T>)`, so for example `range((Excluded(4), Included(10)))` will yield a left-exclusive, right-inclusive range from 4 to 10.",47,{"inputs":[{"name":"self"},{"name":"r"}],"output":{"name":"range"}}],[11,"difference","","Visits the values representing the difference, i.e. the values that are in `self` but not in `other`, in ascending order.",47,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"difference"}}],[11,"symmetric_difference","","Visits the values representing the symmetric difference, i.e. the values that are in `self` or in `other` but not in both, in ascending order.",47,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"symmetricdifference"}}],[11,"intersection","","Visits the values representing the intersection, i.e. the values that are both in `self` and `other`, in ascending order.",47,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"intersection"}}],[11,"union","","Visits the values representing the union, i.e. all the values in `self` or `other`, without duplicates, in ascending order.",47,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"union"}}],[11,"len","","Returns the number of elements in the set.",47,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","Returns `true` if the set contains no elements.",47,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clear","","Clears the set, removing all values.",47,null],[11,"contains","","Returns `true` if the set contains a value.",47,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"bool"}}],[11,"get","","Returns a reference to the value in the set, if any, that is equal to the given value.",47,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"option"}}],[11,"is_disjoint","","Returns `true` if `self` has no elements in common with `other`. This is equivalent to checking for an empty intersection.",47,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"is_subset","","Returns `true` if the set is a subset of another, i.e. `other` contains at least all the values in `self`.",47,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"is_superset","","Returns `true` if the set is a superset of another, i.e. `self` contains at least all the values in `other`.",47,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"insert","","Adds a value to the set.",47,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"bool"}}],[11,"replace","","Adds a value to the set, replacing the existing value, if any, that is equal to the given one. Returns the replaced value.",47,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"option"}}],[11,"remove","","Removes a value from the set. Returns `true` if the value was present in the set.",47,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"bool"}}],[11,"take","","Removes and returns the value in the set, if any, that is equal to the given one.",47,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"option"}}],[11,"append","","Moves all elements from `other` into `Self`, leaving `other` empty.",47,null],[11,"split_off","","Splits the collection into two at the given key. Returns everything after the given key, including the key.",47,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"btreeset"}}]],"paths":[[4,"Bound"],[8,"ToOwned"],[4,"Cow"],[8,"Borrow"],[8,"BorrowMut"],[8,"Octal"],[8,"LowerExp"],[8,"Debug"],[8,"Write"],[8,"UpperExp"],[8,"Binary"],[8,"UpperHex"],[8,"Pointer"],[8,"LowerHex"],[8,"Display"],[8,"RangeArgument"],[8,"SliceConcatExt"],[8,"SliceIndex"],[8,"Pattern"],[4,"SearchStep"],[8,"Searcher"],[8,"ReverseSearcher"],[8,"FromStr"],[8,"ToString"],[4,"Entry"],[3,"Vec"],[3,"PeekMut"],[3,"String"],[3,"IterMut"],[3,"Drain"],[3,"IntoIter"],[3,"Iter"],[3,"Iter"],[3,"Keys"],[3,"Values"],[3,"Iter"],[3,"Drain"],[3,"ValuesMut"],[3,"IntoIter"],[3,"IntoIter"],[3,"IntoIter"],[3,"Iter"],[3,"IterMut"],[3,"IntoIter"],[3,"VecDeque"],[3,"BTreeMap"],[3,"Union"],[3,"BTreeSet"],[3,"Iter"],[4,"ParseError"],[3,"BinaryHeap"],[3,"Intersection"],[3,"Range"],[3,"Range"],[3,"Difference"],[3,"SymmetricDifference"],[3,"EncodeUtf16"],[3,"LinkedList"],[3,"IntoIter"],[3,"Drain"],[3,"Drain"],[3,"Splice"],[3,"RangeMut"],[3,"IterMut"],[3,"BinaryHeapPlace"],[3,"FrontPlace"],[3,"PlaceBack"],[3,"PlaceFront"],[3,"PlaceBack"],[3,"BackPlace"],[3,"FromUtf8Error"],[3,"FromUtf16Error"],[3,"DrainFilter"],[3,"OccupiedEntry"],[3,"VacantEntry"],[3,"ParseBoolError"],[3,"Utf8Error"],[3,"Error"],[3,"Arguments"],[3,"CharSliceSearcher"],[3,"CharPredicateSearcher"],[3,"StrSearcher"],[3,"CharSearcher"],[3,"Split"],[3,"Matches"],[3,"Windows"],[3,"Chars"],[3,"SplitTerminator"],[3,"RSplit"],[3,"Chunks"],[3,"Split"],[3,"MatchIndices"],[3,"LinesAny"],[3,"Lines"],[3,"RMatches"],[3,"RSplitN"],[3,"RMatchIndices"],[3,"RSplit"],[3,"CharIndices"],[3,"RSplitTerminator"],[3,"Bytes"],[3,"SplitN"],[3,"Iter"],[3,"ChunksMut"],[3,"SplitNMut"],[3,"RSplitMut"],[3,"IterMut"],[3,"SplitMut"],[3,"RSplitNMut"],[3,"RSplitN"],[3,"SplitN"],[3,"Formatter"],[3,"SplitWhitespace"],[3,"DebugList"],[3,"DebugSet"],[3,"DebugTuple"],[3,"DebugStruct"],[3,"DebugMap"]]};
searchIndex["core"] = {"doc":"The Rust Core Library","items":[[0,"isize","core","The pointer-sized signed integer type.",null,null],[17,"MIN","core::isize","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"i8","core","The 8-bit signed integer type.",null,null],[17,"MIN","core::i8","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"i16","core","The 16-bit signed integer type.",null,null],[17,"MIN","core::i16","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"i32","core","The 32-bit signed integer type.",null,null],[17,"MIN","core::i32","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"i64","core","The 64-bit signed integer type.",null,null],[17,"MIN","core::i64","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"i128","core","The 128-bit signed integer type.",null,null],[17,"MIN","core::i128","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"usize","core","The pointer-sized unsigned integer type.",null,null],[17,"MIN","core::usize","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"u8","core","The 8-bit unsigned integer type.",null,null],[17,"MIN","core::u8","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"u16","core","The 16-bit unsigned integer type.",null,null],[17,"MIN","core::u16","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"u32","core","The 32-bit unsigned integer type.",null,null],[17,"MIN","core::u32","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"u64","core","The 64-bit unsigned integer type.",null,null],[17,"MIN","core::u64","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"u128","core","The 128-bit unsigned integer type.",null,null],[17,"MIN","core::u128","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"f32","core","Operations and constants for 32-bits floats (`f32` type)",null,null],[0,"consts","core::f32","Basic mathematical constants.",null,null],[17,"PI","core::f32::consts","Archimedes' constant (π)",null,null],[17,"FRAC_PI_2","","π/2",null,null],[17,"FRAC_PI_3","","π/3",null,null],[17,"FRAC_PI_4","","π/4",null,null],[17,"FRAC_PI_6","","π/6",null,null],[17,"FRAC_PI_8","","π/8",null,null],[17,"FRAC_1_PI","","1/π",null,null],[17,"FRAC_2_PI","","2/π",null,null],[17,"FRAC_2_SQRT_PI","","2/sqrt(π)",null,null],[17,"SQRT_2","","sqrt(2)",null,null],[17,"FRAC_1_SQRT_2","","1/sqrt(2)",null,null],[17,"E","","Euler's number (e)",null,null],[17,"LOG2_E","","log2(e)",null,null],[17,"LOG10_E","","log10(e)",null,null],[17,"LN_2","","ln(2)",null,null],[17,"LN_10","","ln(10)",null,null],[17,"RADIX","core::f32","The radix or base of the internal representation of `f32`.",null,null],[17,"MANTISSA_DIGITS","","Number of significant digits in base 2.",null,null],[17,"DIGITS","","Approximate number of significant digits in base 10.",null,null],[17,"EPSILON","","Difference between `1.0` and the next largest representable number.",null,null],[17,"MIN","","Smallest finite `f32` value.",null,null],[17,"MIN_POSITIVE","","Smallest positive normal `f32` value.",null,null],[17,"MAX","","Largest finite `f32` value.",null,null],[17,"MIN_EXP","","One greater than the minimum possible normal power of 2 exponent.",null,null],[17,"MAX_EXP","","Maximum possible power of 2 exponent.",null,null],[17,"MIN_10_EXP","","Minimum possible normal power of 10 exponent.",null,null],[17,"MAX_10_EXP","","Maximum possible power of 10 exponent.",null,null],[17,"NAN","","Not a Number (NaN).",null,null],[17,"INFINITY","","Infinity (∞).",null,null],[17,"NEG_INFINITY","","Negative infinity (-∞).",null,null],[0,"f64","core","Operations and constants for 64-bits floats (`f64` type)",null,null],[0,"consts","core::f64","Basic mathematical constants.",null,null],[17,"PI","core::f64::consts","Archimedes' constant (π)",null,null],[17,"FRAC_PI_2","","π/2",null,null],[17,"FRAC_PI_3","","π/3",null,null],[17,"FRAC_PI_4","","π/4",null,null],[17,"FRAC_PI_6","","π/6",null,null],[17,"FRAC_PI_8","","π/8",null,null],[17,"FRAC_1_PI","","1/π",null,null],[17,"FRAC_2_PI","","2/π",null,null],[17,"FRAC_2_SQRT_PI","","2/sqrt(π)",null,null],[17,"SQRT_2","","sqrt(2)",null,null],[17,"FRAC_1_SQRT_2","","1/sqrt(2)",null,null],[17,"E","","Euler's number (e)",null,null],[17,"LOG2_E","","log2(e)",null,null],[17,"LOG10_E","","log10(e)",null,null],[17,"LN_2","","ln(2)",null,null],[17,"LN_10","","ln(10)",null,null],[17,"RADIX","core::f64","The radix or base of the internal representation of `f64`.",null,null],[17,"MANTISSA_DIGITS","","Number of significant digits in base 2.",null,null],[17,"DIGITS","","Approximate number of significant digits in base 10.",null,null],[17,"EPSILON","","Difference between `1.0` and the next largest representable number.",null,null],[17,"MIN","","Smallest finite `f64` value.",null,null],[17,"MIN_POSITIVE","","Smallest positive normal `f64` value.",null,null],[17,"MAX","","Largest finite `f64` value.",null,null],[17,"MIN_EXP","","One greater than the minimum possible normal power of 2 exponent.",null,null],[17,"MAX_EXP","","Maximum possible power of 2 exponent.",null,null],[17,"MIN_10_EXP","","Minimum possible normal power of 10 exponent.",null,null],[17,"MAX_10_EXP","","Maximum possible power of 10 exponent.",null,null],[17,"NAN","","Not a Number (NaN).",null,null],[17,"INFINITY","","Infinity (∞).",null,null],[17,"NEG_INFINITY","","Negative infinity (-∞).",null,null],[0,"num","core","Numeric traits and functions for the built-in numeric types.",null,null],[3,"Wrapping","core::num","Provides intentionally-wrapped arithmetic on `T`.",null,null],[12,"0","","",0,null],[3,"TryFromIntError","","The error type returned when a checked integral type conversion fails.",null,null],[3,"ParseIntError","","An error which can be returned when parsing an integer.",null,null],[3,"ParseFloatError","","An error which can be returned when parsing a float.",null,null],[4,"FpCategory","","A classification of floating point numbers.",null,null],[13,"Nan","","\"Not a Number\", often obtained by dividing by zero.",1,null],[13,"Infinite","","Positive or negative infinity.",1,null],[13,"Zero","","Positive or negative zero.",1,null],[13,"Subnormal","","De-normalized floating point representation (less precise than `Normal`).",1,null],[13,"Normal","","A regular floating point number.",1,null],[11,"shl","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shl_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shl_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shr","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shr_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shr_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shl","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shl_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shl_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shr","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shr_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shr_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shl","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shl_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shl_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shr","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shr_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shr_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shl","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shl_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shl_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shr","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shr_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shr_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shl","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shl_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shl_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shr","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shr_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shr_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shl","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shl_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shl_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shr","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shr_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shr_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shl","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shl_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shl_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shr","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shr_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shr_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shl","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shl_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shl_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shr","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shr_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shr_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shl","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shl_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shl_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shr","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shr_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shr_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shl","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shl_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shl_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shr","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shr_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shr_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"add","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add","","",0,null],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"sub","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"sub","","",0,null],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"mul","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul","","",0,null],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"div","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"div","","",0,null],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"rem","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"rem","","",0,null],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"not","","",0,{"inputs":[{"name":"self"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitor","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitand","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"neg","","",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"add","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add","","",0,null],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"sub","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"sub","","",0,null],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"mul","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul","","",0,null],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"div","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"div","","",0,null],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"rem","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"rem","","",0,null],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"not","","",0,{"inputs":[{"name":"self"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitor","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitand","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"neg","","",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"add","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add","","",0,null],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"sub","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"sub","","",0,null],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"mul","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul","","",0,null],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"div","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"div","","",0,null],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"rem","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"rem","","",0,null],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"not","","",0,{"inputs":[{"name":"self"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitor","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitand","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"neg","","",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"add","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add","","",0,null],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"sub","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"sub","","",0,null],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"mul","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul","","",0,null],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"div","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"div","","",0,null],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"rem","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"rem","","",0,null],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"not","","",0,{"inputs":[{"name":"self"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitor","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitand","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"neg","","",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"add","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add","","",0,null],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"sub","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"sub","","",0,null],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"mul","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul","","",0,null],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"div","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"div","","",0,null],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"rem","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"rem","","",0,null],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"not","","",0,{"inputs":[{"name":"self"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitor","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitand","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"neg","","",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"add","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add","","",0,null],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"sub","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"sub","","",0,null],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"mul","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul","","",0,null],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"div","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"div","","",0,null],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"rem","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"rem","","",0,null],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"not","","",0,{"inputs":[{"name":"self"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitor","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitand","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"neg","","",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"add","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add","","",0,null],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"sub","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"sub","","",0,null],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"mul","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul","","",0,null],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"div","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"div","","",0,null],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"rem","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"rem","","",0,null],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"not","","",0,{"inputs":[{"name":"self"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitor","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitand","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"neg","","",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"add","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add","","",0,null],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"sub","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"sub","","",0,null],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"mul","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul","","",0,null],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"div","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"div","","",0,null],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"rem","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"rem","","",0,null],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"not","","",0,{"inputs":[{"name":"self"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitor","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitand","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"neg","","",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"add","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add","","",0,null],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"sub","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"sub","","",0,null],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"mul","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul","","",0,null],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"div","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"div","","",0,null],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"rem","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"rem","","",0,null],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"not","","",0,{"inputs":[{"name":"self"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitor","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitand","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"neg","","",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"add","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add","","",0,null],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"sub","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"sub","","",0,null],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"mul","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul","","",0,null],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"div","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"div","","",0,null],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"rem","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"rem","","",0,null],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"not","","",0,{"inputs":[{"name":"self"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitor","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitand","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"neg","","",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"add","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add","","",0,null],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"sub","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"sub","","",0,null],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"mul","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul","","",0,null],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"div","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"div","","",0,null],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"rem","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"rem","","",0,null],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"not","","",0,{"inputs":[{"name":"self"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitor","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitand","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"neg","","",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"add","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add","","",0,null],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"sub","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"sub","","",0,null],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"mul","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul","","",0,null],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"div","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"div","","",0,null],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"rem","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"rem","","",0,null],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"not","","",0,{"inputs":[{"name":"self"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitor","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitand","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"neg","","",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"fmt","","",2,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",2,{"inputs":[{"name":"self"}],"output":{"name":"parsefloaterror"}}],[11,"eq","","",2,{"inputs":[{"name":"self"},{"name":"parsefloaterror"}],"output":{"name":"bool"}}],[11,"ne","","",2,{"inputs":[{"name":"self"},{"name":"parsefloaterror"}],"output":{"name":"bool"}}],[11,"fmt","","",2,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"bool"}}],[11,"ne","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"option"}}],[11,"lt","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"bool"}}],[11,"le","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"bool"}}],[11,"gt","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"bool"}}],[11,"ge","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"bool"}}],[11,"cmp","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"ordering"}}],[11,"clone","","",0,{"inputs":[{"name":"self"}],"output":{"name":"wrapping"}}],[11,"default","","",0,{"inputs":[],"output":{"name":"wrapping"}}],[11,"hash","","",0,null],[11,"fmt","","",0,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",0,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",0,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",0,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",0,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",0,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",1,{"inputs":[{"name":"self"}],"output":{"name":"fpcategory"}}],[11,"eq","","",1,{"inputs":[{"name":"self"},{"name":"fpcategory"}],"output":{"name":"bool"}}],[11,"fmt","","",1,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",3,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",3,{"inputs":[{"name":"self"}],"output":{"name":"tryfrominterror"}}],[11,"fmt","","",3,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"from","","",3,{"inputs":[{"name":"infallible"}],"output":{"name":"tryfrominterror"}}],[11,"fmt","","",4,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",4,{"inputs":[{"name":"self"}],"output":{"name":"parseinterror"}}],[11,"eq","","",4,{"inputs":[{"name":"self"},{"name":"parseinterror"}],"output":{"name":"bool"}}],[11,"ne","","",4,{"inputs":[{"name":"self"},{"name":"parseinterror"}],"output":{"name":"bool"}}],[11,"fmt","","",4,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[0,"prelude","core","The libcore prelude",null,null],[0,"v1","core::prelude","The core prelude",null,null],[0,"intrinsics","core","rustc compiler intrinsics.",null,null],[5,"atomic_cxchg","core::intrinsics","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::SeqCst` as both the `success` and `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",null,null],[5,"atomic_cxchg_acq","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::Acquire` as both the `success` and `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",null,null],[5,"atomic_cxchg_rel","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::Release` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",null,null],[5,"atomic_cxchg_acqrel","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::AcqRel` as the `success` and `Ordering::Acquire` as the `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",null,null],[5,"atomic_cxchg_relaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::Relaxed` as both the `success` and `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",null,null],[5,"atomic_cxchg_failrelaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::SeqCst` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",null,null],[5,"atomic_cxchg_failacq","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::SeqCst` as the `success` and `Ordering::Acquire` as the `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",null,null],[5,"atomic_cxchg_acq_failrelaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::Acquire` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",null,null],[5,"atomic_cxchg_acqrel_failrelaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::AcqRel` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",null,null],[5,"atomic_cxchgweak","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::SeqCst` as both the `success` and `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",null,null],[5,"atomic_cxchgweak_acq","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::Acquire` as both the `success` and `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",null,null],[5,"atomic_cxchgweak_rel","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::Release` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",null,null],[5,"atomic_cxchgweak_acqrel","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::AcqRel` as the `success` and `Ordering::Acquire` as the `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",null,null],[5,"atomic_cxchgweak_relaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::Relaxed` as both the `success` and `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",null,null],[5,"atomic_cxchgweak_failrelaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::SeqCst` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",null,null],[5,"atomic_cxchgweak_failacq","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::SeqCst` as the `success` and `Ordering::Acquire` as the `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",null,null],[5,"atomic_cxchgweak_acq_failrelaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::Acquire` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",null,null],[5,"atomic_cxchgweak_acqrel_failrelaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::AcqRel` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",null,null],[5,"atomic_load","","Loads the current value of the pointer. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `load` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::load`.",null,null],[5,"atomic_load_acq","","Loads the current value of the pointer. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `load` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicBool::load`.",null,null],[5,"atomic_load_relaxed","","Loads the current value of the pointer. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `load` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::load`.",null,null],[5,"atomic_load_unordered","","",null,null],[5,"atomic_store","","Stores the value at the specified memory location. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `store` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::store`.",null,null],[5,"atomic_store_rel","","Stores the value at the specified memory location. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `store` method by passing `Ordering::Release` as the `order`. For example, `AtomicBool::store`.",null,null],[5,"atomic_store_relaxed","","Stores the value at the specified memory location. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `store` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::store`.",null,null],[5,"atomic_store_unordered","","",null,null],[5,"atomic_xchg","","Stores the value at the specified memory location, returning the old value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `swap` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::swap`.",null,null],[5,"atomic_xchg_acq","","Stores the value at the specified memory location, returning the old value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `swap` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicBool::swap`.",null,null],[5,"atomic_xchg_rel","","Stores the value at the specified memory location, returning the old value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `swap` method by passing `Ordering::Release` as the `order`. For example, `AtomicBool::swap`.",null,null],[5,"atomic_xchg_acqrel","","Stores the value at the specified memory location, returning the old value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `swap` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicBool::swap`.",null,null],[5,"atomic_xchg_relaxed","","Stores the value at the specified memory location, returning the old value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `swap` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::swap`.",null,null],[5,"atomic_xadd","","Add to the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_add` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicIsize::fetch_add`.",null,null],[5,"atomic_xadd_acq","","Add to the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_add` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicIsize::fetch_add`.",null,null],[5,"atomic_xadd_rel","","Add to the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_add` method by passing `Ordering::Release` as the `order`. For example, `AtomicIsize::fetch_add`.",null,null],[5,"atomic_xadd_acqrel","","Add to the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_add` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicIsize::fetch_add`.",null,null],[5,"atomic_xadd_relaxed","","Add to the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_add` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicIsize::fetch_add`.",null,null],[5,"atomic_xsub","","Subtract from the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_sub` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicIsize::fetch_sub`.",null,null],[5,"atomic_xsub_acq","","Subtract from the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_sub` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicIsize::fetch_sub`.",null,null],[5,"atomic_xsub_rel","","Subtract from the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_sub` method by passing `Ordering::Release` as the `order`. For example, `AtomicIsize::fetch_sub`.",null,null],[5,"atomic_xsub_acqrel","","Subtract from the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_sub` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicIsize::fetch_sub`.",null,null],[5,"atomic_xsub_relaxed","","Subtract from the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_sub` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicIsize::fetch_sub`.",null,null],[5,"atomic_and","","Bitwise and with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_and` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::fetch_and`.",null,null],[5,"atomic_and_acq","","Bitwise and with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_and` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicBool::fetch_and`.",null,null],[5,"atomic_and_rel","","Bitwise and with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_and` method by passing `Ordering::Release` as the `order`. For example, `AtomicBool::fetch_and`.",null,null],[5,"atomic_and_acqrel","","Bitwise and with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_and` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicBool::fetch_and`.",null,null],[5,"atomic_and_relaxed","","Bitwise and with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_and` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::fetch_and`.",null,null],[5,"atomic_nand","","Bitwise nand with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic::AtomicBool` type via the `fetch_nand` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::fetch_nand`.",null,null],[5,"atomic_nand_acq","","Bitwise nand with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic::AtomicBool` type via the `fetch_nand` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicBool::fetch_nand`.",null,null],[5,"atomic_nand_rel","","Bitwise nand with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic::AtomicBool` type via the `fetch_nand` method by passing `Ordering::Release` as the `order`. For example, `AtomicBool::fetch_nand`.",null,null],[5,"atomic_nand_acqrel","","Bitwise nand with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic::AtomicBool` type via the `fetch_nand` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicBool::fetch_nand`.",null,null],[5,"atomic_nand_relaxed","","Bitwise nand with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic::AtomicBool` type via the `fetch_nand` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::fetch_nand`.",null,null],[5,"atomic_or","","Bitwise or with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_or` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::fetch_or`.",null,null],[5,"atomic_or_acq","","Bitwise or with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_or` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicBool::fetch_or`.",null,null],[5,"atomic_or_rel","","Bitwise or with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_or` method by passing `Ordering::Release` as the `order`. For example, `AtomicBool::fetch_or`.",null,null],[5,"atomic_or_acqrel","","Bitwise or with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_or` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicBool::fetch_or`.",null,null],[5,"atomic_or_relaxed","","Bitwise or with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_or` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::fetch_or`.",null,null],[5,"atomic_xor","","Bitwise xor with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_xor` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::fetch_xor`.",null,null],[5,"atomic_xor_acq","","Bitwise xor with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_xor` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicBool::fetch_xor`.",null,null],[5,"atomic_xor_rel","","Bitwise xor with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_xor` method by passing `Ordering::Release` as the `order`. For example, `AtomicBool::fetch_xor`.",null,null],[5,"atomic_xor_acqrel","","Bitwise xor with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_xor` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicBool::fetch_xor`.",null,null],[5,"atomic_xor_relaxed","","Bitwise xor with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_xor` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::fetch_xor`.",null,null],[5,"atomic_max","","",null,null],[5,"atomic_max_acq","","",null,null],[5,"atomic_max_rel","","",null,null],[5,"atomic_max_acqrel","","",null,null],[5,"atomic_max_relaxed","","",null,null],[5,"atomic_min","","",null,null],[5,"atomic_min_acq","","",null,null],[5,"atomic_min_rel","","",null,null],[5,"atomic_min_acqrel","","",null,null],[5,"atomic_min_relaxed","","",null,null],[5,"atomic_umin","","",null,null],[5,"atomic_umin_acq","","",null,null],[5,"atomic_umin_rel","","",null,null],[5,"atomic_umin_acqrel","","",null,null],[5,"atomic_umin_relaxed","","",null,null],[5,"atomic_umax","","",null,null],[5,"atomic_umax_acq","","",null,null],[5,"atomic_umax_rel","","",null,null],[5,"atomic_umax_acqrel","","",null,null],[5,"atomic_umax_relaxed","","",null,null],[5,"prefetch_read_data","","The `prefetch` intrinsic is a hint to the code generator to insert a prefetch instruction if supported; otherwise, it is a noop. Prefetches have no effect on the behavior of the program but can change its performance characteristics.",null,null],[5,"prefetch_write_data","","The `prefetch` intrinsic is a hint to the code generator to insert a prefetch instruction if supported; otherwise, it is a noop. Prefetches have no effect on the behavior of the program but can change its performance characteristics.",null,null],[5,"prefetch_read_instruction","","The `prefetch` intrinsic is a hint to the code generator to insert a prefetch instruction if supported; otherwise, it is a noop. Prefetches have no effect on the behavior of the program but can change its performance characteristics.",null,null],[5,"prefetch_write_instruction","","The `prefetch` intrinsic is a hint to the code generator to insert a prefetch instruction if supported; otherwise, it is a noop. Prefetches have no effect on the behavior of the program but can change its performance characteristics.",null,null],[5,"atomic_fence","","",null,null],[5,"atomic_fence_acq","","",null,null],[5,"atomic_fence_rel","","",null,null],[5,"atomic_fence_acqrel","","",null,null],[5,"atomic_singlethreadfence","","A compiler-only memory barrier.",null,null],[5,"atomic_singlethreadfence_acq","","",null,null],[5,"atomic_singlethreadfence_rel","","",null,null],[5,"atomic_singlethreadfence_acqrel","","",null,null],[5,"rustc_peek","","Magic intrinsic that derives its meaning from attributes attached to the function.",null,null],[5,"abort","","Aborts the execution of the process.",null,null],[5,"unreachable","","Tells LLVM that this point in the code is not reachable, enabling further optimizations.",null,null],[5,"assume","","Informs the optimizer that a condition is always true. If the condition is false, the behavior is undefined.",null,null],[5,"likely","","Hints to the compiler that branch condition is likely to be true. Returns the value passed to it.",null,null],[5,"unlikely","","Hints to the compiler that branch condition is likely to be false. Returns the value passed to it.",null,null],[5,"breakpoint","","Executes a breakpoint trap, for inspection by a debugger.",null,null],[5,"size_of","","The size of a type in bytes.",null,null],[5,"move_val_init","","Moves a value to an uninitialized memory location.",null,null],[5,"min_align_of","","",null,null],[5,"pref_align_of","","",null,null],[5,"size_of_val","","",null,null],[5,"min_align_of_val","","",null,null],[5,"type_name","","Gets a static string slice containing the name of a type.",null,null],[5,"type_id","","Gets an identifier which is globally unique to the specified type. This function will return the same value for a type regardless of whichever crate it is invoked in.",null,null],[5,"init","","Creates a value initialized to zero.",null,null],[5,"uninit","","Creates an uninitialized value.",null,null],[5,"transmute","","Reinterprets the bits of a value of one type as another type.",null,null],[5,"needs_drop","","Returns `true` if the actual type given as `T` requires drop glue; returns `false` if the actual type provided for `T` implements `Copy`.",null,null],[5,"offset","","Calculates the offset from a pointer.",null,null],[5,"arith_offset","","Calculates the offset from a pointer, potentially wrapping.",null,null],[5,"copy_nonoverlapping","","Copies `count * size_of<T>` bytes from `src` to `dst`. The source and destination may not overlap.",null,null],[5,"copy","","Copies `count * size_of<T>` bytes from `src` to `dst`. The source and destination may overlap.",null,null],[5,"write_bytes","","Invokes memset on the specified pointer, setting `count * size_of::<T>()` bytes of memory starting at `dst` to `val`.",null,null],[5,"volatile_copy_nonoverlapping_memory","","Equivalent to the appropriate `llvm.memcpy.p0i8.0i8.*` intrinsic, with a size of `count` * `size_of::<T>()` and an alignment of `min_align_of::<T>()`",null,null],[5,"volatile_copy_memory","","Equivalent to the appropriate `llvm.memmove.p0i8.0i8.*` intrinsic, with a size of `count` * `size_of::<T>()` and an alignment of `min_align_of::<T>()`",null,null],[5,"volatile_set_memory","","Equivalent to the appropriate `llvm.memset.p0i8.*` intrinsic, with a size of `count` * `size_of::<T>()` and an alignment of `min_align_of::<T>()`.",null,null],[5,"volatile_load","","Perform a volatile load from the `src` pointer. The stabilized version of this intrinsic is `std::ptr::read_volatile`.",null,null],[5,"volatile_store","","Perform a volatile store to the `dst` pointer. The stabilized version of this intrinsic is `std::ptr::write_volatile`.",null,null],[5,"sqrtf32","","Returns the square root of an `f32`",null,null],[5,"sqrtf64","","Returns the square root of an `f64`",null,null],[5,"powif32","","Raises an `f32` to an integer power.",null,null],[5,"powif64","","Raises an `f64` to an integer power.",null,null],[5,"sinf32","","Returns the sine of an `f32`.",null,null],[5,"sinf64","","Returns the sine of an `f64`.",null,null],[5,"cosf32","","Returns the cosine of an `f32`.",null,null],[5,"cosf64","","Returns the cosine of an `f64`.",null,null],[5,"powf32","","Raises an `f32` to an `f32` power.",null,null],[5,"powf64","","Raises an `f64` to an `f64` power.",null,null],[5,"expf32","","Returns the exponential of an `f32`.",null,null],[5,"expf64","","Returns the exponential of an `f64`.",null,null],[5,"exp2f32","","Returns 2 raised to the power of an `f32`.",null,null],[5,"exp2f64","","Returns 2 raised to the power of an `f64`.",null,null],[5,"logf32","","Returns the natural logarithm of an `f32`.",null,null],[5,"logf64","","Returns the natural logarithm of an `f64`.",null,null],[5,"log10f32","","Returns the base 10 logarithm of an `f32`.",null,null],[5,"log10f64","","Returns the base 10 logarithm of an `f64`.",null,null],[5,"log2f32","","Returns the base 2 logarithm of an `f32`.",null,null],[5,"log2f64","","Returns the base 2 logarithm of an `f64`.",null,null],[5,"fmaf32","","Returns `a * b + c` for `f32` values.",null,null],[5,"fmaf64","","Returns `a * b + c` for `f64` values.",null,null],[5,"fabsf32","","Returns the absolute value of an `f32`.",null,null],[5,"fabsf64","","Returns the absolute value of an `f64`.",null,null],[5,"copysignf32","","Copies the sign from `y` to `x` for `f32` values.",null,null],[5,"copysignf64","","Copies the sign from `y` to `x` for `f64` values.",null,null],[5,"floorf32","","Returns the largest integer less than or equal to an `f32`.",null,null],[5,"floorf64","","Returns the largest integer less than or equal to an `f64`.",null,null],[5,"ceilf32","","Returns the smallest integer greater than or equal to an `f32`.",null,null],[5,"ceilf64","","Returns the smallest integer greater than or equal to an `f64`.",null,null],[5,"truncf32","","Returns the integer part of an `f32`.",null,null],[5,"truncf64","","Returns the integer part of an `f64`.",null,null],[5,"rintf32","","Returns the nearest integer to an `f32`. May raise an inexact floating-point exception if the argument is not an integer.",null,null],[5,"rintf64","","Returns the nearest integer to an `f64`. May raise an inexact floating-point exception if the argument is not an integer.",null,null],[5,"nearbyintf32","","Returns the nearest integer to an `f32`.",null,null],[5,"nearbyintf64","","Returns the nearest integer to an `f64`.",null,null],[5,"roundf32","","Returns the nearest integer to an `f32`. Rounds half-way cases away from zero.",null,null],[5,"roundf64","","Returns the nearest integer to an `f64`. Rounds half-way cases away from zero.",null,null],[5,"fadd_fast","","Float addition that allows optimizations based on algebraic rules. May assume inputs are finite.",null,null],[5,"fsub_fast","","Float subtraction that allows optimizations based on algebraic rules. May assume inputs are finite.",null,null],[5,"fmul_fast","","Float multiplication that allows optimizations based on algebraic rules. May assume inputs are finite.",null,null],[5,"fdiv_fast","","Float division that allows optimizations based on algebraic rules. May assume inputs are finite.",null,null],[5,"frem_fast","","Float remainder that allows optimizations based on algebraic rules. May assume inputs are finite.",null,null],[5,"ctpop","","Returns the number of bits set in an integer type `T`",null,null],[5,"ctlz","","Returns the number of leading unset bits (zeroes) in an integer type `T`.",null,null],[5,"ctlz_nonzero","","Like `ctlz`, but extra-unsafe as it returns `undef` when given an `x` with value `0`.",null,null],[5,"cttz","","Returns the number of trailing unset bits (zeroes) in an integer type `T`.",null,null],[5,"cttz_nonzero","","Like `cttz`, but extra-unsafe as it returns `undef` when given an `x` with value `0`.",null,null],[5,"bswap","","Reverses the bytes in an integer type `T`.",null,null],[5,"add_with_overflow","","Performs checked integer addition. The stabilized versions of this intrinsic are available on the integer primitives via the `overflowing_add` method. For example, `std::u32::overflowing_add`",null,null],[5,"sub_with_overflow","","Performs checked integer subtraction The stabilized versions of this intrinsic are available on the integer primitives via the `overflowing_sub` method. For example, `std::u32::overflowing_sub`",null,null],[5,"mul_with_overflow","","Performs checked integer multiplication The stabilized versions of this intrinsic are available on the integer primitives via the `overflowing_mul` method. For example, `std::u32::overflowing_mul`",null,null],[5,"unchecked_div","","Performs an unchecked division, resulting in undefined behavior where y = 0 or x = `T::min_value()` and y = -1",null,null],[5,"unchecked_rem","","Returns the remainder of an unchecked division, resulting in undefined behavior where y = 0 or x = `T::min_value()` and y = -1",null,null],[5,"unchecked_shl","","Performs an unchecked left shift, resulting in undefined behavior when y < 0 or y >= N, where N is the width of T in bits.",null,null],[5,"unchecked_shr","","Performs an unchecked right shift, resulting in undefined behavior when y < 0 or y >= N, where N is the width of T in bits.",null,null],[5,"overflowing_add","","Returns (a + b) mod 2N, where N is the width of T in bits. The stabilized versions of this intrinsic are available on the integer primitives via the `wrapping_add` method. For example, `std::u32::wrapping_add`",null,null],[5,"overflowing_sub","","Returns (a - b) mod 2N, where N is the width of T in bits. The stabilized versions of this intrinsic are available on the integer primitives via the `wrapping_sub` method. For example, `std::u32::wrapping_sub`",null,null],[5,"overflowing_mul","","Returns (a * b) mod 2N, where N is the width of T in bits. The stabilized versions of this intrinsic are available on the integer primitives via the `wrapping_mul` method. For example, `std::u32::wrapping_mul`",null,null],[5,"discriminant_value","","Returns the value of the discriminant for the variant in 'v', cast to a `u64`; if `T` has no discriminant, returns 0.",null,null],[5,"try","","Rust's \"try catch\" construct which invokes the function pointer `f` with the data pointer `data`.",null,null],[5,"align_offset","","Computes the byte offset that needs to be applied to `ptr` in order to make it aligned to `align`. If it is not possible to align `ptr`, the implementation returns `usize::max_value()`.",null,null],[0,"mem","core","Basic functions for dealing with memory.",null,null],[3,"Discriminant","core::mem","Opaque type representing the discriminant of an enum.",null,null],[19,"ManuallyDrop","","A wrapper to inhibit compiler from automatically calling `T`’s destructor.",null,null],[5,"forget","","Leaks a value: takes ownership and \"forgets\" about the value without running its destructor.",null,{"inputs":[{"name":"t"}],"output":null}],[5,"size_of","","Returns the size of a type in bytes.",null,{"inputs":[],"output":{"name":"usize"}}],[5,"size_of_val","","Returns the size of the pointed-to value in bytes.",null,{"inputs":[{"name":"t"}],"output":{"name":"usize"}}],[5,"min_align_of","","Returns the [ABI]-required minimum alignment of a type.",null,{"inputs":[],"output":{"name":"usize"}}],[5,"min_align_of_val","","Returns the [ABI]-required minimum alignment of the type of the value that `val` points to.",null,{"inputs":[{"name":"t"}],"output":{"name":"usize"}}],[5,"align_of","","Returns the [ABI]-required minimum alignment of a type.",null,{"inputs":[],"output":{"name":"usize"}}],[5,"align_of_val","","Returns the [ABI]-required minimum alignment of the type of the value that `val` points to.",null,{"inputs":[{"name":"t"}],"output":{"name":"usize"}}],[5,"needs_drop","","Returns whether dropping values of type `T` matters.",null,{"inputs":[],"output":{"name":"bool"}}],[5,"zeroed","","Creates a value whose bytes are all zero.",null,{"inputs":[],"output":{"name":"t"}}],[5,"uninitialized","","Bypasses Rust's normal memory-initialization checks by pretending to produce a value of type `T`, while doing nothing at all.",null,{"inputs":[],"output":{"name":"t"}}],[5,"swap","","Swaps the values at two mutable locations, without deinitializing either one.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":null}],[5,"replace","","Replaces the value at a mutable location with a new one, returning the old value, without deinitializing either one.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"drop","","Disposes of a value.",null,{"inputs":[{"name":"t"}],"output":null}],[5,"transmute_copy","","Interprets `src` as having type `&U`, and then reads `src` without moving the contained value.",null,{"inputs":[{"name":"t"}],"output":{"name":"u"}}],[5,"discriminant","","Returns a value uniquely identifying the enum variant in `v`.",null,{"inputs":[{"name":"t"}],"output":{"name":"discriminant"}}],[5,"unreachable","","Tells LLVM that this point in the code is not reachable, enabling further optimizations.",null,null],[11,"clone","","",5,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"eq","","",5,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"bool"}}],[11,"hash","","",5,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"fmt","","",5,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Wrap a value to be manually dropped.",6,{"inputs":[{"name":"t"}],"output":{"name":"manuallydrop"}}],[11,"into_inner","","Extract the value from the ManuallyDrop container.",6,{"inputs":[{"name":"manuallydrop"}],"output":{"name":"t"}}],[11,"drop","","Manually drops the contained value.",6,{"inputs":[{"name":"manuallydrop"}],"output":null}],[11,"deref","","",6,null],[11,"deref_mut","","",6,null],[11,"fmt","","",6,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",6,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"clone_from","","",6,{"inputs":[{"name":"self"},{"name":"self"}],"output":null}],[11,"default","","",6,{"inputs":[],"output":{"name":"self"}}],[11,"eq","","",6,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"bool"}}],[11,"ne","","",6,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",6,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"option"}}],[11,"lt","","",6,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"bool"}}],[11,"le","","",6,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"bool"}}],[11,"gt","","",6,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"bool"}}],[11,"ge","","",6,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"bool"}}],[11,"cmp","","",6,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"ordering"}}],[11,"hash","","",6,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[0,"nonzero","core","Exposes the NonZero lang item which provides optimization hints.",null,null],[3,"NonZero","core::nonzero","A wrapper type for raw pointers and integers that will never be NULL or 0 that might allow certain optimizations.",null,null],[8,"Zeroable","","Unsafe trait to indicate what types are usable with the NonZero struct",null,null],[10,"is_zero","","Whether this value is zero",7,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",8,{"inputs":[{"name":"self"}],"output":{"name":"nonzero"}}],[11,"eq","","",8,{"inputs":[{"name":"self"},{"name":"nonzero"}],"output":{"name":"bool"}}],[11,"ne","","",8,{"inputs":[{"name":"self"},{"name":"nonzero"}],"output":{"name":"bool"}}],[11,"cmp","","",8,{"inputs":[{"name":"self"},{"name":"nonzero"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",8,{"inputs":[{"name":"self"},{"name":"nonzero"}],"output":{"name":"option"}}],[11,"lt","","",8,{"inputs":[{"name":"self"},{"name":"nonzero"}],"output":{"name":"bool"}}],[11,"le","","",8,{"inputs":[{"name":"self"},{"name":"nonzero"}],"output":{"name":"bool"}}],[11,"gt","","",8,{"inputs":[{"name":"self"},{"name":"nonzero"}],"output":{"name":"bool"}}],[11,"ge","","",8,{"inputs":[{"name":"self"},{"name":"nonzero"}],"output":{"name":"bool"}}],[11,"fmt","","",8,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",8,null],[11,"new_unchecked","","Creates an instance of NonZero with the provided value. You must indeed ensure that the value is actually \"non-zero\".",8,{"inputs":[{"name":"t"}],"output":{"name":"self"}}],[11,"new","","Creates an instance of NonZero with the provided value.",8,{"inputs":[{"name":"t"}],"output":{"name":"option"}}],[11,"get","","Gets the inner value.",8,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"from","","",8,{"inputs":[{"name":"t"}],"output":{"name":"self"}}],[11,"from","","",8,{"inputs":[{"name":"t"}],"output":{"name":"self"}}],[11,"from","","",8,{"inputs":[{"name":"t"}],"output":{"name":"self"}}],[0,"ptr","core","Raw, unsafe pointers, `*const T`, and `*mut T`.",null,null],[3,"Unique","core::ptr","A wrapper around a raw non-null `*mut T` that indicates that the possessor of this wrapper owns the referent. Useful for building abstractions like `Box<T>`, `Vec<T>`, `String`, and `HashMap<K, V>`.",null,null],[3,"Shared","","A wrapper around a raw `*mut T` that indicates that the possessor of this wrapper has shared ownership of the referent. Useful for building abstractions like `Rc<T>`, `Arc<T>`, or doubly-linked lists, which internally use aliased raw pointers to manage the memory that they own.",null,null],[5,"drop_in_place","","Executes the destructor (if any) of the pointed-to value.",null,null],[5,"null","","Creates a null raw pointer.",null,null],[5,"null_mut","","Creates a null mutable raw pointer.",null,null],[5,"swap","","Swaps the values at two mutable locations of the same type, without deinitializing either. They may overlap, unlike `mem::swap` which is otherwise equivalent.",null,null],[5,"swap_nonoverlapping","","Swaps a sequence of values at two mutable locations of the same type.",null,null],[5,"replace","","Replaces the value at `dest` with `src`, returning the old value, without dropping either.",null,null],[5,"read","","Reads the value from `src` without moving it. This leaves the memory in `src` unchanged.",null,null],[5,"read_unaligned","","Reads the value from `src` without moving it. This leaves the memory in `src` unchanged.",null,null],[5,"write","","Overwrites a memory location with the given value without reading or dropping the old value.",null,null],[5,"write_unaligned","","Overwrites a memory location with the given value without reading or dropping the old value.",null,null],[5,"read_volatile","","Performs a volatile read of the value from `src` without moving it. This leaves the memory in `src` unchanged.",null,null],[5,"write_volatile","","Performs a volatile write of a memory location with the given value without reading or dropping the old value.",null,null],[5,"eq","","Compare raw pointers for equality.",null,null],[11,"empty","","Creates a new `Unique` that is dangling, but well-aligned.",9,{"inputs":[],"output":{"name":"self"}}],[11,"new_unchecked","","Creates a new `Unique`.",9,null],[11,"new","","Creates a new `Unique` if `ptr` is non-null.",9,null],[11,"as_ptr","","Acquires the underlying `*mut` pointer.",9,null],[11,"as_ref","","Dereferences the content.",9,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"as_mut","","Mutably dereferences the content.",9,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"clone","","",9,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"fmt","","",9,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"from","","",9,{"inputs":[{"name":"t"}],"output":{"name":"self"}}],[11,"from","","",9,{"inputs":[{"name":"t"}],"output":{"name":"self"}}],[11,"empty","","Creates a new `Shared` that is dangling, but well-aligned.",10,{"inputs":[],"output":{"name":"self"}}],[11,"new_unchecked","","Creates a new `Shared`.",10,null],[11,"new","","Creates a new `Shared` if `ptr` is non-null.",10,null],[11,"as_ptr","","Acquires the underlying `*mut` pointer.",10,null],[11,"as_ref","","Dereferences the content.",10,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"as_mut","","Mutably dereferences the content.",10,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"as_mut_ptr","","Acquires the underlying pointer as a `*mut` pointer.",10,null],[11,"clone","","",10,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"fmt","","",10,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"from","","",10,{"inputs":[{"name":"unique"}],"output":{"name":"self"}}],[11,"from","","",10,{"inputs":[{"name":"t"}],"output":{"name":"self"}}],[11,"from","","",10,{"inputs":[{"name":"t"}],"output":{"name":"self"}}],[0,"marker","core","Primitive traits and types representing basic properties of types.",null,null],[3,"PhantomData","core::marker","Zero-sized type used to mark things that \"act like\" they own a `T`.",null,null],[8,"Send","","Types that can be transferred across thread boundaries.",null,null],[8,"Sized","","Types with a constant size known at compile time.",null,null],[8,"Unsize","","Types that can be \"unsized\" to a dynamically-sized type.",null,null],[8,"Copy","","Types whose values can be duplicated simply by copying bits.",null,null],[8,"Sync","","Types for which it is safe to share references between threads.",null,null],[11,"hash","","",11,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"eq","","",11,{"inputs":[{"name":"self"},{"name":"phantomdata"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",11,{"inputs":[{"name":"self"},{"name":"phantomdata"}],"output":{"name":"option"}}],[11,"cmp","","",11,{"inputs":[{"name":"self"},{"name":"phantomdata"}],"output":{"name":"ordering"}}],[11,"clone","","",11,{"inputs":[{"name":"self"}],"output":{"name":"phantomdata"}}],[11,"default","","",11,{"inputs":[],"output":{"name":"phantomdata"}}],[0,"ops","core","Overloadable operators.",null,null],[3,"Range","core::ops","A (half-open) range bounded inclusively below and exclusively above (`start..end`).",null,null],[12,"start","","The lower bound of the range (inclusive).",12,null],[12,"end","","The upper bound of the range (exclusive).",12,null],[3,"RangeFrom","","A range only bounded inclusively below (`start..`).",null,null],[12,"start","","The lower bound of the range (inclusive).",13,null],[3,"RangeFull","","An unbounded range (`..`).",null,null],[3,"RangeTo","","A range only bounded exclusively above (`..end`).",null,null],[12,"end","","The upper bound of the range (exclusive).",14,null],[3,"RangeInclusive","","An range bounded inclusively below and above (`start..=end`).",null,null],[12,"start","","The lower bound of the range (inclusive).",15,null],[12,"end","","The upper bound of the range (inclusive).",15,null],[3,"RangeToInclusive","","A range only bounded inclusively above (`..=end`).",null,null],[12,"end","","The upper bound of the range (inclusive)",16,null],[4,"GeneratorState","","The result of a generator resumption.",null,null],[13,"Yielded","","The generator suspended with a value.",17,null],[13,"Complete","","The generator completed with a return value.",17,null],[11,"clone","","",17,{"inputs":[{"name":"self"}],"output":{"name":"generatorstate"}}],[11,"eq","","",17,{"inputs":[{"name":"self"},{"name":"generatorstate"}],"output":{"name":"bool"}}],[11,"ne","","",17,{"inputs":[{"name":"self"},{"name":"generatorstate"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",17,{"inputs":[{"name":"self"},{"name":"generatorstate"}],"output":{"name":"option"}}],[11,"lt","","",17,{"inputs":[{"name":"self"},{"name":"generatorstate"}],"output":{"name":"bool"}}],[11,"le","","",17,{"inputs":[{"name":"self"},{"name":"generatorstate"}],"output":{"name":"bool"}}],[11,"gt","","",17,{"inputs":[{"name":"self"},{"name":"generatorstate"}],"output":{"name":"bool"}}],[11,"ge","","",17,{"inputs":[{"name":"self"},{"name":"generatorstate"}],"output":{"name":"bool"}}],[11,"cmp","","",17,{"inputs":[{"name":"self"},{"name":"generatorstate"}],"output":{"name":"ordering"}}],[11,"fmt","","",17,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",17,null],[11,"clone","","",18,{"inputs":[{"name":"self"}],"output":{"name":"rangefull"}}],[11,"eq","","",18,{"inputs":[{"name":"self"},{"name":"rangefull"}],"output":{"name":"bool"}}],[11,"hash","","",18,null],[11,"fmt","","",18,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",12,{"inputs":[{"name":"self"}],"output":{"name":"range"}}],[11,"eq","","",12,{"inputs":[{"name":"self"},{"name":"range"}],"output":{"name":"bool"}}],[11,"ne","","",12,{"inputs":[{"name":"self"},{"name":"range"}],"output":{"name":"bool"}}],[11,"hash","","",12,null],[11,"fmt","","",12,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"contains","","Returns `true` if `item` is contained in the range.",12,{"inputs":[{"name":"self"},{"name":"idx"}],"output":{"name":"bool"}}],[11,"clone","","",13,{"inputs":[{"name":"self"}],"output":{"name":"rangefrom"}}],[11,"eq","","",13,{"inputs":[{"name":"self"},{"name":"rangefrom"}],"output":{"name":"bool"}}],[11,"ne","","",13,{"inputs":[{"name":"self"},{"name":"rangefrom"}],"output":{"name":"bool"}}],[11,"hash","","",13,null],[11,"fmt","","",13,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"contains","","Returns `true` if `item` is contained in the range.",13,{"inputs":[{"name":"self"},{"name":"idx"}],"output":{"name":"bool"}}],[11,"clone","","",14,{"inputs":[{"name":"self"}],"output":{"name":"rangeto"}}],[11,"eq","","",14,{"inputs":[{"name":"self"},{"name":"rangeto"}],"output":{"name":"bool"}}],[11,"ne","","",14,{"inputs":[{"name":"self"},{"name":"rangeto"}],"output":{"name":"bool"}}],[11,"hash","","",14,null],[11,"fmt","","",14,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"contains","","Returns `true` if `item` is contained in the range.",14,{"inputs":[{"name":"self"},{"name":"idx"}],"output":{"name":"bool"}}],[11,"clone","","",15,{"inputs":[{"name":"self"}],"output":{"name":"rangeinclusive"}}],[11,"eq","","",15,{"inputs":[{"name":"self"},{"name":"rangeinclusive"}],"output":{"name":"bool"}}],[11,"ne","","",15,{"inputs":[{"name":"self"},{"name":"rangeinclusive"}],"output":{"name":"bool"}}],[11,"hash","","",15,null],[11,"fmt","","",15,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"contains","","Returns `true` if `item` is contained in the range.",15,{"inputs":[{"name":"self"},{"name":"idx"}],"output":{"name":"bool"}}],[11,"clone","","",16,{"inputs":[{"name":"self"}],"output":{"name":"rangetoinclusive"}}],[11,"eq","","",16,{"inputs":[{"name":"self"},{"name":"rangetoinclusive"}],"output":{"name":"bool"}}],[11,"ne","","",16,{"inputs":[{"name":"self"},{"name":"rangetoinclusive"}],"output":{"name":"bool"}}],[11,"hash","","",16,null],[11,"fmt","","",16,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"contains","","Returns `true` if `item` is contained in the range.",16,{"inputs":[{"name":"self"},{"name":"idx"}],"output":{"name":"bool"}}],[8,"Add","","The addition operator `+`.",null,null],[16,"Output","","The resulting type after applying the `+` operator.",19,null],[10,"add","","Performs the `+` operation.",19,null],[8,"Sub","","The subtraction operator `-`.",null,null],[16,"Output","","The resulting type after applying the `-` operator.",20,null],[10,"sub","","Performs the `-` operation.",20,null],[8,"Mul","","The multiplication operator `*`.",null,null],[16,"Output","","The resulting type after applying the `*` operator.",21,null],[10,"mul","","Performs the `*` operation.",21,null],[8,"Div","","The division operator `/`.",null,null],[16,"Output","","The resulting type after applying the `/` operator.",22,null],[10,"div","","Performs the `/` operation.",22,null],[8,"Rem","","The remainder operator `%`.",null,null],[16,"Output","","The resulting type after applying the `%` operator.",23,null],[10,"rem","","Performs the `%` operation.",23,null],[8,"Neg","","The unary negation operator `-`.",null,null],[16,"Output","","The resulting type after applying the `-` operator.",24,null],[10,"neg","","Performs the unary `-` operation.",24,null],[8,"AddAssign","","The addition assignment operator `+=`.",null,null],[10,"add_assign","","Performs the `+=` operation.",25,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":null}],[8,"SubAssign","","The subtraction assignment operator `-=`.",null,null],[10,"sub_assign","","Performs the `-=` operation.",26,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":null}],[8,"MulAssign","","The multiplication assignment operator `*=`.",null,null],[10,"mul_assign","","Performs the `*=` operation.",27,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":null}],[8,"DivAssign","","The division assignment operator `/=`.",null,null],[10,"div_assign","","Performs the `/=` operation.",28,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":null}],[8,"RemAssign","","The remainder assignment operator `%=`.",null,null],[10,"rem_assign","","Performs the `%=` operation.",29,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":null}],[8,"Not","","The unary logical negation operator `!`.",null,null],[16,"Output","","The resulting type after applying the `!` operator.",30,null],[10,"not","","Performs the unary `!` operation.",30,null],[8,"BitAnd","","The bitwise AND operator `&`.",null,null],[16,"Output","","The resulting type after applying the `&` operator.",31,null],[10,"bitand","","Performs the `&` operation.",31,null],[8,"BitOr","","The bitwise OR operator `|`.",null,null],[16,"Output","","The resulting type after applying the `|` operator.",32,null],[10,"bitor","","Performs the `|` operation.",32,null],[8,"BitXor","","The bitwise XOR operator `^`.",null,null],[16,"Output","","The resulting type after applying the `^` operator.",33,null],[10,"bitxor","","Performs the `^` operation.",33,null],[8,"Shl","","The left shift operator `<<`.",null,null],[16,"Output","","The resulting type after applying the `<<` operator.",34,null],[10,"shl","","Performs the `<<` operation.",34,null],[8,"Shr","","The right shift operator `>>`.",null,null],[16,"Output","","The resulting type after applying the `>>` operator.",35,null],[10,"shr","","Performs the `>>` operation.",35,null],[8,"BitAndAssign","","The bitwise AND assignment operator `&=`.",null,null],[10,"bitand_assign","","Performs the `&=` operation.",36,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":null}],[8,"BitOrAssign","","The bitwise OR assignment operator `|=`.",null,null],[10,"bitor_assign","","Performs the `|=` operation.",37,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":null}],[8,"BitXorAssign","","The bitwise XOR assignment operator `^=`.",null,null],[10,"bitxor_assign","","Performs the `^=` operation.",38,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":null}],[8,"ShlAssign","","The left shift assignment operator `<<=`.",null,null],[10,"shl_assign","","Performs the `<<=` operation.",39,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":null}],[8,"ShrAssign","","The right shift assignment operator `>>=`.",null,null],[10,"shr_assign","","Performs the `>>=` operation.",40,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":null}],[8,"Deref","","Used for immutable dereferencing operations, like `*v`.",null,null],[16,"Target","","The resulting type after dereferencing.",41,null],[10,"deref","","Dereferences the value.",41,null],[8,"DerefMut","","Used for mutable dereferencing operations, like in `*v = 1;`.",null,null],[10,"deref_mut","","Mutably dereferences the value.",42,null],[8,"Drop","","Used to run some code when a value goes out of scope. This is sometimes called a 'destructor'.",null,null],[10,"drop","","Executes the destructor for this type.",43,{"inputs":[{"name":"self"}],"output":null}],[8,"Fn","","The version of the call operator that takes an immutable receiver.",null,null],[10,"call","","Performs the call operation.",44,null],[8,"FnMut","","The version of the call operator that takes a mutable receiver.",null,null],[10,"call_mut","","Performs the call operation.",45,null],[8,"FnOnce","","The version of the call operator that takes a by-value receiver.",null,null],[16,"Output","","The returned type after the call operator is used.",46,null],[10,"call_once","","Performs the call operation.",46,null],[8,"Index","","Used for indexing operations (`container[index]`) in immutable contexts.",null,null],[16,"Output","","The returned type after indexing.",47,null],[10,"index","","Performs the indexing (`container[index]`) operation.",47,null],[8,"IndexMut","","Used for indexing operations (`container[index]`) in mutable contexts.",null,null],[10,"index_mut","","Performs the mutable indexing (`container[index]`) operation.",48,null],[8,"Try","","A trait for customizing the behavior of the `?` operator.",null,null],[16,"Ok","","The type of this value when viewed as successful.",49,null],[16,"Error","","The type of this value when viewed as failed.",49,null],[10,"into_result","","Applies the \"?\" operator. A return of `Ok(t)` means that the execution should continue normally, and the result of `?` is the value `t`. A return of `Err(e)` means that execution should branch to the innermost enclosing `catch`, or return from the function.",49,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[10,"from_error","","Wrap an error value to construct the composite result. For example, `Result::Err(x)` and `Result::from_error(x)` are equivalent.",49,null],[10,"from_ok","","Wrap an OK value to construct the composite result. For example, `Result::Ok(x)` and `Result::from_ok(x)` are equivalent.",49,null],[8,"Generator","","The trait implemented by builtin generator types.",null,null],[16,"Yield","","The type of value this generator yields.",50,null],[16,"Return","","The type of value this generator returns.",50,null],[10,"resume","","Resumes the execution of this generator.",50,{"inputs":[{"name":"self"}],"output":{"name":"generatorstate"}}],[8,"Place","","Both `PLACE <- EXPR` and `box EXPR` desugar into expressions that allocate an intermediate \"place\" that holds uninitialized state.  The desugaring evaluates EXPR, and writes the result at the address returned by the `pointer` method of this trait.",null,null],[10,"pointer","","Returns the address where the input value will be written. Note that the data at this address is generally uninitialized, and thus one should use `ptr::write` for initializing it.",51,null],[8,"Placer","","Interface to implementations of  `PLACE <- EXPR`.",null,null],[16,"Place","","`Place` is the intermediate agent guarding the uninitialized state for `Data`.",52,null],[10,"make_place","","Creates a fresh place from `self`.",52,null],[8,"InPlace","","Specialization of `Place` trait supporting `PLACE <- EXPR`.",null,null],[16,"Owner","","`Owner` is the type of the end value of `PLACE <- EXPR`",53,null],[10,"finalize","","Converts self into the final value, shifting deallocation/cleanup responsibilities (if any remain), over to the returned instance of `Owner` and forgetting self.",53,null],[8,"Boxed","","Core trait for the `box EXPR` form.",null,null],[16,"Data","","The kind of data that is stored in this kind of box.",54,null],[16,"Place","","The place that will negotiate the storage of the data.",54,null],[10,"finalize","","Converts filled place into final owning value, shifting deallocation/cleanup responsibilities (if any remain), over to returned instance of `Self` and forgetting `filled`.",54,null],[8,"BoxPlace","","Specialization of `Place` trait supporting `box EXPR`.",null,null],[10,"make_place","","Creates a globally fresh place.",55,{"inputs":[],"output":{"name":"self"}}],[8,"CoerceUnsized","","Trait that indicates that this is a pointer or a wrapper for one, where unsizing can be performed on the pointee.",null,null],[0,"cmp","core","Functionality for ordering and comparison.",null,null],[3,"Reverse","core::cmp","A helper struct for reverse ordering.",null,null],[12,"0","","",56,null],[4,"Ordering","","An `Ordering` is the result of a comparison between two values.",null,null],[13,"Less","","An ordering where a compared value is less [than another].",57,null],[13,"Equal","","An ordering where a compared value is equal [to another].",57,null],[13,"Greater","","An ordering where a compared value is greater [than another].",57,null],[5,"min","","Compares and returns the minimum of two values.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"max","","Compares and returns the maximum of two values.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[8,"PartialEq","","Trait for equality comparisons which are partial equivalence relations.",null,null],[10,"eq","","This method tests for `self` and `other` values to be equal, and is used by `==`.",58,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":{"name":"bool"}}],[11,"ne","","This method tests for `!=`.",58,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":{"name":"bool"}}],[8,"Eq","","Trait for equality comparisons which are equivalence relations.",null,null],[8,"Ord","","Trait for types that form a total order.",null,null],[10,"cmp","","This method returns an `Ordering` between `self` and `other`.",59,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"ordering"}}],[11,"max","","Compares and returns the maximum of two values.",59,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"self"}}],[11,"min","","Compares and returns the minimum of two values.",59,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"self"}}],[8,"PartialOrd","","Trait for values that can be compared for a sort-order.",null,null],[10,"partial_cmp","","This method returns an ordering between `self` and `other` values if one exists.",60,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":{"name":"option"}}],[11,"lt","","This method tests less than (for `self` and `other`) and is used by the `<` operator.",60,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":{"name":"bool"}}],[11,"le","","This method tests less than or equal to (for `self` and `other`) and is used by the `<=` operator.",60,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":{"name":"bool"}}],[11,"gt","","This method tests greater than (for `self` and `other`) and is used by the `>` operator.",60,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":{"name":"bool"}}],[11,"ge","","This method tests greater than or equal to (for `self` and `other`) and is used by the `>=` operator.",60,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":{"name":"bool"}}],[11,"clone","","",57,{"inputs":[{"name":"self"}],"output":{"name":"ordering"}}],[11,"eq","","",57,{"inputs":[{"name":"self"},{"name":"ordering"}],"output":{"name":"bool"}}],[11,"fmt","","",57,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",57,null],[11,"reverse","","Reverses the `Ordering`.",57,{"inputs":[{"name":"self"}],"output":{"name":"ordering"}}],[11,"then","","Chains two orderings.",57,{"inputs":[{"name":"self"},{"name":"ordering"}],"output":{"name":"ordering"}}],[11,"then_with","","Chains the ordering with the given function.",57,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"ordering"}}],[11,"eq","","",56,{"inputs":[{"name":"self"},{"name":"reverse"}],"output":{"name":"bool"}}],[11,"ne","","",56,{"inputs":[{"name":"self"},{"name":"reverse"}],"output":{"name":"bool"}}],[11,"fmt","","",56,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"partial_cmp","","",56,{"inputs":[{"name":"self"},{"name":"reverse"}],"output":{"name":"option"}}],[11,"lt","","",56,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"bool"}}],[11,"le","","",56,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"bool"}}],[11,"ge","","",56,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"bool"}}],[11,"gt","","",56,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"bool"}}],[11,"cmp","","",56,{"inputs":[{"name":"self"},{"name":"reverse"}],"output":{"name":"ordering"}}],[11,"cmp","","",57,{"inputs":[{"name":"self"},{"name":"ordering"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",57,{"inputs":[{"name":"self"},{"name":"ordering"}],"output":{"name":"option"}}],[0,"clone","core","The `Clone` trait for types that cannot be 'implicitly copied'.",null,null],[8,"Clone","core::clone","A common trait for the ability to explicitly duplicate an object.",null,null],[10,"clone","","Returns a copy of the value.",61,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"clone_from","","Performs copy-assignment from `source`.",61,{"inputs":[{"name":"self"},{"name":"self"}],"output":null}],[0,"default","core","The `Default` trait for types which may have meaningful default values.",null,null],[8,"Default","core::default","A trait for giving a type a useful default value.",null,null],[10,"default","","Returns the \"default value\" for a type.",62,{"inputs":[],"output":{"name":"self"}}],[0,"convert","core","Traits for conversions between types.",null,null],[4,"Infallible","core::convert","A type used as the error type for implementations of fallible conversion traits in cases where conversions cannot actually fail.",null,null],[8,"AsRef","","A cheap reference-to-reference conversion. Used to convert a value to a reference value within generic code.",null,null],[10,"as_ref","","Performs the conversion.",63,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[8,"AsMut","","A cheap, mutable reference-to-mutable reference conversion.",null,null],[10,"as_mut","","Performs the conversion.",64,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[8,"Into","","A conversion that consumes `self`, which may or may not be expensive. The reciprocal of [`From`][From].",null,null],[10,"into","","Performs the conversion.",65,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[8,"From","","Simple and safe type conversions in to `Self`. It is the reciprocal of `Into`.",null,null],[10,"from","","Performs the conversion.",66,{"inputs":[{"name":"t"}],"output":{"name":"self"}}],[8,"TryInto","","An attempted conversion that consumes `self`, which may or may not be expensive.",null,null],[16,"Error","","The type returned in the event of a conversion error.",67,null],[10,"try_into","","Performs the conversion.",67,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[8,"TryFrom","","Attempt to construct `Self` via a conversion.",null,null],[16,"Error","","The type returned in the event of a conversion error.",68,null],[10,"try_from","","Performs the conversion.",68,{"inputs":[{"name":"t"}],"output":{"name":"result"}}],[11,"clone","","",69,{"inputs":[{"name":"self"}],"output":{"name":"infallible"}}],[11,"fmt","","",69,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",69,null],[11,"cmp","","",69,{"inputs":[{"name":"self"},{"name":"infallible"}],"output":{"name":"ordering"}}],[11,"eq","","",69,{"inputs":[{"name":"self"},{"name":"infallible"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",69,{"inputs":[{"name":"self"},{"name":"infallible"}],"output":{"name":"option"}}],[11,"fmt","","",69,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[0,"borrow","core","A module for working with borrowed data.",null,null],[8,"Borrow","core::borrow","A trait for borrowing data.",null,null],[10,"borrow","","Immutably borrows from an owned value.",70,{"inputs":[{"name":"self"}],"output":{"name":"borrowed"}}],[8,"BorrowMut","","A trait for mutably borrowing data.",null,null],[10,"borrow_mut","","Mutably borrows from an owned value.",71,{"inputs":[{"name":"self"}],"output":{"name":"borrowed"}}],[0,"any","core","This module implements the `Any` trait, which enables dynamic typing of any `'static` type through runtime reflection.",null,null],[3,"TypeId","core::any","A `TypeId` represents a globally unique identifier for a type.",null,null],[8,"Any","","A type to emulate dynamic typing.",null,null],[10,"get_type_id","","Gets the `TypeId` of `self`.",72,{"inputs":[{"name":"self"}],"output":{"name":"typeid"}}],[11,"fmt","","",72,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",72,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"is","","Returns `true` if the boxed type is the same as `T`.",72,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"downcast_ref","","Returns some reference to the boxed value if it is of type `T`, or `None` if it isn't.",72,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"downcast_mut","","Returns some mutable reference to the boxed value if it is of type `T`, or `None` if it isn't.",72,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"is","","Forwards to the method defined on the type `Any`.",72,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"downcast_ref","","Forwards to the method defined on the type `Any`.",72,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"downcast_mut","","Forwards to the method defined on the type `Any`.",72,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",73,{"inputs":[{"name":"self"}],"output":{"name":"typeid"}}],[11,"eq","","",73,{"inputs":[{"name":"self"},{"name":"typeid"}],"output":{"name":"bool"}}],[11,"ne","","",73,{"inputs":[{"name":"self"},{"name":"typeid"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",73,{"inputs":[{"name":"self"},{"name":"typeid"}],"output":{"name":"option"}}],[11,"lt","","",73,{"inputs":[{"name":"self"},{"name":"typeid"}],"output":{"name":"bool"}}],[11,"le","","",73,{"inputs":[{"name":"self"},{"name":"typeid"}],"output":{"name":"bool"}}],[11,"gt","","",73,{"inputs":[{"name":"self"},{"name":"typeid"}],"output":{"name":"bool"}}],[11,"ge","","",73,{"inputs":[{"name":"self"},{"name":"typeid"}],"output":{"name":"bool"}}],[11,"cmp","","",73,{"inputs":[{"name":"self"},{"name":"typeid"}],"output":{"name":"ordering"}}],[11,"fmt","","",73,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",73,null],[11,"of","","Returns the `TypeId` of the type this generic function has been instantiated with.",73,{"inputs":[],"output":{"name":"typeid"}}],[0,"array","core","Implementations of things like `Eq` for fixed-length arrays up to a certain length. Eventually we should able to generalize to all lengths.",null,null],[8,"FixedSizeArray","core::array","Utility trait implemented only on arrays of fixed size",null,null],[10,"as_slice","","Converts the array to immutable slice",74,null],[10,"as_mut_slice","","Converts the array to mutable slice",74,null],[0,"sync","core","Synchronization primitives",null,null],[0,"atomic","core::sync","Atomic types",null,null],[3,"AtomicBool","core::sync::atomic","A boolean type which can be safely shared between threads.",null,null],[3,"AtomicPtr","","A raw pointer type which can be safely shared between threads.",null,null],[3,"AtomicI8","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicU8","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicI16","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicU16","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicI32","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicU32","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicI64","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicU64","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicIsize","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicUsize","","An integer type which can be safely shared between threads.",null,null],[4,"Ordering","","Atomic memory orderings",null,null],[13,"Relaxed","","No ordering constraints, only atomic operations.",75,null],[13,"Release","","When coupled with a store, all previous writes become visible to the other threads that perform a load with [`Acquire`] ordering on the same value.",75,null],[13,"Acquire","","When coupled with a load, all subsequent loads will see data written before a store with [`Release`] ordering on the same value in other threads.",75,null],[13,"AcqRel","","When coupled with a load, uses [`Acquire`] ordering, and with a store [`Release`] ordering.",75,null],[13,"SeqCst","","Like `AcqRel` with the additional guarantee that all threads see all sequentially consistent operations in the same order.",75,null],[5,"hint_core_should_pause","","Save power or switch hyperthreads in a busy-wait spin-loop.",null,{"inputs":[],"output":null}],[5,"fence","","An atomic fence.",null,{"inputs":[{"name":"ordering"}],"output":null}],[5,"compiler_fence","","A compiler memory fence.",null,{"inputs":[{"name":"ordering"}],"output":null}],[17,"ATOMIC_BOOL_INIT","","An [`AtomicBool`] initialized to `false`.",null,null],[17,"ATOMIC_I8_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_U8_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_I16_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_U16_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_I32_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_U32_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_I64_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_U64_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_ISIZE_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_USIZE_INIT","","An atomic integer initialized to `0`.",null,null],[11,"default","","Creates an `AtomicBool` initialized to `false`.",76,{"inputs":[],"output":{"name":"self"}}],[11,"default","","Creates a null `AtomicPtr<T>`.",77,{"inputs":[],"output":{"name":"atomicptr"}}],[11,"clone","","",75,{"inputs":[{"name":"self"}],"output":{"name":"ordering"}}],[11,"fmt","","",75,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new `AtomicBool`.",76,{"inputs":[{"name":"bool"}],"output":{"name":"atomicbool"}}],[11,"get_mut","","Returns a mutable reference to the underlying [`bool`].",76,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"into_inner","","Consumes the atomic and returns the contained value.",76,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"load","","Loads a value from the bool.",76,{"inputs":[{"name":"self"},{"name":"ordering"}],"output":{"name":"bool"}}],[11,"store","","Stores a value into the bool.",76,{"inputs":[{"name":"self"},{"name":"bool"},{"name":"ordering"}],"output":null}],[11,"swap","","Stores a value into the bool, returning the previous value.",76,{"inputs":[{"name":"self"},{"name":"bool"},{"name":"ordering"}],"output":{"name":"bool"}}],[11,"compare_and_swap","","Stores a value into the [`bool`] if the current value is the same as the `current` value.",76,{"inputs":[{"name":"self"},{"name":"bool"},{"name":"bool"},{"name":"ordering"}],"output":{"name":"bool"}}],[11,"compare_exchange","","Stores a value into the [`bool`] if the current value is the same as the `current` value.",76,{"inputs":[{"name":"self"},{"name":"bool"},{"name":"bool"},{"name":"ordering"},{"name":"ordering"}],"output":{"name":"result"}}],[11,"compare_exchange_weak","","Stores a value into the [`bool`] if the current value is the same as the `current` value.",76,{"inputs":[{"name":"self"},{"name":"bool"},{"name":"bool"},{"name":"ordering"},{"name":"ordering"}],"output":{"name":"result"}}],[11,"fetch_and","","Logical \"and\" with a boolean value.",76,{"inputs":[{"name":"self"},{"name":"bool"},{"name":"ordering"}],"output":{"name":"bool"}}],[11,"fetch_nand","","Logical \"nand\" with a boolean value.",76,{"inputs":[{"name":"self"},{"name":"bool"},{"name":"ordering"}],"output":{"name":"bool"}}],[11,"fetch_or","","Logical \"or\" with a boolean value.",76,{"inputs":[{"name":"self"},{"name":"bool"},{"name":"ordering"}],"output":{"name":"bool"}}],[11,"fetch_xor","","Logical \"xor\" with a boolean value.",76,{"inputs":[{"name":"self"},{"name":"bool"},{"name":"ordering"}],"output":{"name":"bool"}}],[11,"new","","Creates a new `AtomicPtr`.",77,null],[11,"get_mut","","Returns a mutable reference to the underlying pointer.",77,null],[11,"into_inner","","Consumes the atomic and returns the contained value.",77,null],[11,"load","","Loads a value from the pointer.",77,null],[11,"store","","Stores a value into the pointer.",77,null],[11,"swap","","Stores a value into the pointer, returning the previous value.",77,null],[11,"compare_and_swap","","Stores a value into the pointer if the current value is the same as the `current` value.",77,null],[11,"compare_exchange","","Stores a value into the pointer if the current value is the same as the `current` value.",77,null],[11,"compare_exchange_weak","","Stores a value into the pointer if the current value is the same as the `current` value.",77,null],[11,"default","","",78,{"inputs":[],"output":{"name":"self"}}],[11,"fmt","","",78,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new atomic integer.",78,{"inputs":[{"name":"i8"}],"output":{"name":"self"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",78,{"inputs":[{"name":"self"}],"output":{"name":"i8"}}],[11,"into_inner","","Consumes the atomic and returns the contained value.",78,{"inputs":[{"name":"self"}],"output":{"name":"i8"}}],[11,"load","","Loads a value from the atomic integer.",78,{"inputs":[{"name":"self"},{"name":"ordering"}],"output":{"name":"i8"}}],[11,"store","","Stores a value into the atomic integer.",78,{"inputs":[{"name":"self"},{"name":"i8"},{"name":"ordering"}],"output":null}],[11,"swap","","Stores a value into the atomic integer, returning the previous value.",78,{"inputs":[{"name":"self"},{"name":"i8"},{"name":"ordering"}],"output":{"name":"i8"}}],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",78,{"inputs":[{"name":"self"},{"name":"i8"},{"name":"i8"},{"name":"ordering"}],"output":{"name":"i8"}}],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",78,{"inputs":[{"name":"self"},{"name":"i8"},{"name":"i8"},{"name":"ordering"},{"name":"ordering"}],"output":{"name":"result"}}],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",78,{"inputs":[{"name":"self"},{"name":"i8"},{"name":"i8"},{"name":"ordering"},{"name":"ordering"}],"output":{"name":"result"}}],[11,"fetch_add","","Adds to the current value, returning the previous value.",78,{"inputs":[{"name":"self"},{"name":"i8"},{"name":"ordering"}],"output":{"name":"i8"}}],[11,"fetch_sub","","Subtracts from the current value, returning the previous value.",78,{"inputs":[{"name":"self"},{"name":"i8"},{"name":"ordering"}],"output":{"name":"i8"}}],[11,"fetch_and","","Bitwise \"and\" with the current value.",78,{"inputs":[{"name":"self"},{"name":"i8"},{"name":"ordering"}],"output":{"name":"i8"}}],[11,"fetch_or","","Bitwise \"or\" with the current value.",78,{"inputs":[{"name":"self"},{"name":"i8"},{"name":"ordering"}],"output":{"name":"i8"}}],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",78,{"inputs":[{"name":"self"},{"name":"i8"},{"name":"ordering"}],"output":{"name":"i8"}}],[11,"default","","",79,{"inputs":[],"output":{"name":"self"}}],[11,"fmt","","",79,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new atomic integer.",79,{"inputs":[{"name":"u8"}],"output":{"name":"self"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",79,{"inputs":[{"name":"self"}],"output":{"name":"u8"}}],[11,"into_inner","","Consumes the atomic and returns the contained value.",79,{"inputs":[{"name":"self"}],"output":{"name":"u8"}}],[11,"load","","Loads a value from the atomic integer.",79,{"inputs":[{"name":"self"},{"name":"ordering"}],"output":{"name":"u8"}}],[11,"store","","Stores a value into the atomic integer.",79,{"inputs":[{"name":"self"},{"name":"u8"},{"name":"ordering"}],"output":null}],[11,"swap","","Stores a value into the atomic integer, returning the previous value.",79,{"inputs":[{"name":"self"},{"name":"u8"},{"name":"ordering"}],"output":{"name":"u8"}}],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",79,{"inputs":[{"name":"self"},{"name":"u8"},{"name":"u8"},{"name":"ordering"}],"output":{"name":"u8"}}],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",79,{"inputs":[{"name":"self"},{"name":"u8"},{"name":"u8"},{"name":"ordering"},{"name":"ordering"}],"output":{"name":"result"}}],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",79,{"inputs":[{"name":"self"},{"name":"u8"},{"name":"u8"},{"name":"ordering"},{"name":"ordering"}],"output":{"name":"result"}}],[11,"fetch_add","","Adds to the current value, returning the previous value.",79,{"inputs":[{"name":"self"},{"name":"u8"},{"name":"ordering"}],"output":{"name":"u8"}}],[11,"fetch_sub","","Subtracts from the current value, returning the previous value.",79,{"inputs":[{"name":"self"},{"name":"u8"},{"name":"ordering"}],"output":{"name":"u8"}}],[11,"fetch_and","","Bitwise \"and\" with the current value.",79,{"inputs":[{"name":"self"},{"name":"u8"},{"name":"ordering"}],"output":{"name":"u8"}}],[11,"fetch_or","","Bitwise \"or\" with the current value.",79,{"inputs":[{"name":"self"},{"name":"u8"},{"name":"ordering"}],"output":{"name":"u8"}}],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",79,{"inputs":[{"name":"self"},{"name":"u8"},{"name":"ordering"}],"output":{"name":"u8"}}],[11,"default","","",80,{"inputs":[],"output":{"name":"self"}}],[11,"fmt","","",80,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new atomic integer.",80,{"inputs":[{"name":"i16"}],"output":{"name":"self"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",80,{"inputs":[{"name":"self"}],"output":{"name":"i16"}}],[11,"into_inner","","Consumes the atomic and returns the contained value.",80,{"inputs":[{"name":"self"}],"output":{"name":"i16"}}],[11,"load","","Loads a value from the atomic integer.",80,{"inputs":[{"name":"self"},{"name":"ordering"}],"output":{"name":"i16"}}],[11,"store","","Stores a value into the atomic integer.",80,{"inputs":[{"name":"self"},{"name":"i16"},{"name":"ordering"}],"output":null}],[11,"swap","","Stores a value into the atomic integer, returning the previous value.",80,{"inputs":[{"name":"self"},{"name":"i16"},{"name":"ordering"}],"output":{"name":"i16"}}],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",80,{"inputs":[{"name":"self"},{"name":"i16"},{"name":"i16"},{"name":"ordering"}],"output":{"name":"i16"}}],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",80,{"inputs":[{"name":"self"},{"name":"i16"},{"name":"i16"},{"name":"ordering"},{"name":"ordering"}],"output":{"name":"result"}}],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",80,{"inputs":[{"name":"self"},{"name":"i16"},{"name":"i16"},{"name":"ordering"},{"name":"ordering"}],"output":{"name":"result"}}],[11,"fetch_add","","Adds to the current value, returning the previous value.",80,{"inputs":[{"name":"self"},{"name":"i16"},{"name":"ordering"}],"output":{"name":"i16"}}],[11,"fetch_sub","","Subtracts from the current value, returning the previous value.",80,{"inputs":[{"name":"self"},{"name":"i16"},{"name":"ordering"}],"output":{"name":"i16"}}],[11,"fetch_and","","Bitwise \"and\" with the current value.",80,{"inputs":[{"name":"self"},{"name":"i16"},{"name":"ordering"}],"output":{"name":"i16"}}],[11,"fetch_or","","Bitwise \"or\" with the current value.",80,{"inputs":[{"name":"self"},{"name":"i16"},{"name":"ordering"}],"output":{"name":"i16"}}],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",80,{"inputs":[{"name":"self"},{"name":"i16"},{"name":"ordering"}],"output":{"name":"i16"}}],[11,"default","","",81,{"inputs":[],"output":{"name":"self"}}],[11,"fmt","","",81,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new atomic integer.",81,{"inputs":[{"name":"u16"}],"output":{"name":"self"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",81,{"inputs":[{"name":"self"}],"output":{"name":"u16"}}],[11,"into_inner","","Consumes the atomic and returns the contained value.",81,{"inputs":[{"name":"self"}],"output":{"name":"u16"}}],[11,"load","","Loads a value from the atomic integer.",81,{"inputs":[{"name":"self"},{"name":"ordering"}],"output":{"name":"u16"}}],[11,"store","","Stores a value into the atomic integer.",81,{"inputs":[{"name":"self"},{"name":"u16"},{"name":"ordering"}],"output":null}],[11,"swap","","Stores a value into the atomic integer, returning the previous value.",81,{"inputs":[{"name":"self"},{"name":"u16"},{"name":"ordering"}],"output":{"name":"u16"}}],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",81,{"inputs":[{"name":"self"},{"name":"u16"},{"name":"u16"},{"name":"ordering"}],"output":{"name":"u16"}}],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",81,{"inputs":[{"name":"self"},{"name":"u16"},{"name":"u16"},{"name":"ordering"},{"name":"ordering"}],"output":{"name":"result"}}],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",81,{"inputs":[{"name":"self"},{"name":"u16"},{"name":"u16"},{"name":"ordering"},{"name":"ordering"}],"output":{"name":"result"}}],[11,"fetch_add","","Adds to the current value, returning the previous value.",81,{"inputs":[{"name":"self"},{"name":"u16"},{"name":"ordering"}],"output":{"name":"u16"}}],[11,"fetch_sub","","Subtracts from the current value, returning the previous value.",81,{"inputs":[{"name":"self"},{"name":"u16"},{"name":"ordering"}],"output":{"name":"u16"}}],[11,"fetch_and","","Bitwise \"and\" with the current value.",81,{"inputs":[{"name":"self"},{"name":"u16"},{"name":"ordering"}],"output":{"name":"u16"}}],[11,"fetch_or","","Bitwise \"or\" with the current value.",81,{"inputs":[{"name":"self"},{"name":"u16"},{"name":"ordering"}],"output":{"name":"u16"}}],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",81,{"inputs":[{"name":"self"},{"name":"u16"},{"name":"ordering"}],"output":{"name":"u16"}}],[11,"default","","",82,{"inputs":[],"output":{"name":"self"}}],[11,"fmt","","",82,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new atomic integer.",82,{"inputs":[{"name":"i32"}],"output":{"name":"self"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",82,{"inputs":[{"name":"self"}],"output":{"name":"i32"}}],[11,"into_inner","","Consumes the atomic and returns the contained value.",82,{"inputs":[{"name":"self"}],"output":{"name":"i32"}}],[11,"load","","Loads a value from the atomic integer.",82,{"inputs":[{"name":"self"},{"name":"ordering"}],"output":{"name":"i32"}}],[11,"store","","Stores a value into the atomic integer.",82,{"inputs":[{"name":"self"},{"name":"i32"},{"name":"ordering"}],"output":null}],[11,"swap","","Stores a value into the atomic integer, returning the previous value.",82,{"inputs":[{"name":"self"},{"name":"i32"},{"name":"ordering"}],"output":{"name":"i32"}}],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",82,{"inputs":[{"name":"self"},{"name":"i32"},{"name":"i32"},{"name":"ordering"}],"output":{"name":"i32"}}],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",82,{"inputs":[{"name":"self"},{"name":"i32"},{"name":"i32"},{"name":"ordering"},{"name":"ordering"}],"output":{"name":"result"}}],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",82,{"inputs":[{"name":"self"},{"name":"i32"},{"name":"i32"},{"name":"ordering"},{"name":"ordering"}],"output":{"name":"result"}}],[11,"fetch_add","","Adds to the current value, returning the previous value.",82,{"inputs":[{"name":"self"},{"name":"i32"},{"name":"ordering"}],"output":{"name":"i32"}}],[11,"fetch_sub","","Subtracts from the current value, returning the previous value.",82,{"inputs":[{"name":"self"},{"name":"i32"},{"name":"ordering"}],"output":{"name":"i32"}}],[11,"fetch_and","","Bitwise \"and\" with the current value.",82,{"inputs":[{"name":"self"},{"name":"i32"},{"name":"ordering"}],"output":{"name":"i32"}}],[11,"fetch_or","","Bitwise \"or\" with the current value.",82,{"inputs":[{"name":"self"},{"name":"i32"},{"name":"ordering"}],"output":{"name":"i32"}}],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",82,{"inputs":[{"name":"self"},{"name":"i32"},{"name":"ordering"}],"output":{"name":"i32"}}],[11,"default","","",83,{"inputs":[],"output":{"name":"self"}}],[11,"fmt","","",83,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new atomic integer.",83,{"inputs":[{"name":"u32"}],"output":{"name":"self"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",83,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"into_inner","","Consumes the atomic and returns the contained value.",83,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"load","","Loads a value from the atomic integer.",83,{"inputs":[{"name":"self"},{"name":"ordering"}],"output":{"name":"u32"}}],[11,"store","","Stores a value into the atomic integer.",83,{"inputs":[{"name":"self"},{"name":"u32"},{"name":"ordering"}],"output":null}],[11,"swap","","Stores a value into the atomic integer, returning the previous value.",83,{"inputs":[{"name":"self"},{"name":"u32"},{"name":"ordering"}],"output":{"name":"u32"}}],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",83,{"inputs":[{"name":"self"},{"name":"u32"},{"name":"u32"},{"name":"ordering"}],"output":{"name":"u32"}}],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",83,{"inputs":[{"name":"self"},{"name":"u32"},{"name":"u32"},{"name":"ordering"},{"name":"ordering"}],"output":{"name":"result"}}],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",83,{"inputs":[{"name":"self"},{"name":"u32"},{"name":"u32"},{"name":"ordering"},{"name":"ordering"}],"output":{"name":"result"}}],[11,"fetch_add","","Adds to the current value, returning the previous value.",83,{"inputs":[{"name":"self"},{"name":"u32"},{"name":"ordering"}],"output":{"name":"u32"}}],[11,"fetch_sub","","Subtracts from the current value, returning the previous value.",83,{"inputs":[{"name":"self"},{"name":"u32"},{"name":"ordering"}],"output":{"name":"u32"}}],[11,"fetch_and","","Bitwise \"and\" with the current value.",83,{"inputs":[{"name":"self"},{"name":"u32"},{"name":"ordering"}],"output":{"name":"u32"}}],[11,"fetch_or","","Bitwise \"or\" with the current value.",83,{"inputs":[{"name":"self"},{"name":"u32"},{"name":"ordering"}],"output":{"name":"u32"}}],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",83,{"inputs":[{"name":"self"},{"name":"u32"},{"name":"ordering"}],"output":{"name":"u32"}}],[11,"default","","",84,{"inputs":[],"output":{"name":"self"}}],[11,"fmt","","",84,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new atomic integer.",84,{"inputs":[{"name":"i64"}],"output":{"name":"self"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",84,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[11,"into_inner","","Consumes the atomic and returns the contained value.",84,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[11,"load","","Loads a value from the atomic integer.",84,{"inputs":[{"name":"self"},{"name":"ordering"}],"output":{"name":"i64"}}],[11,"store","","Stores a value into the atomic integer.",84,{"inputs":[{"name":"self"},{"name":"i64"},{"name":"ordering"}],"output":null}],[11,"swap","","Stores a value into the atomic integer, returning the previous value.",84,{"inputs":[{"name":"self"},{"name":"i64"},{"name":"ordering"}],"output":{"name":"i64"}}],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",84,{"inputs":[{"name":"self"},{"name":"i64"},{"name":"i64"},{"name":"ordering"}],"output":{"name":"i64"}}],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",84,{"inputs":[{"name":"self"},{"name":"i64"},{"name":"i64"},{"name":"ordering"},{"name":"ordering"}],"output":{"name":"result"}}],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",84,{"inputs":[{"name":"self"},{"name":"i64"},{"name":"i64"},{"name":"ordering"},{"name":"ordering"}],"output":{"name":"result"}}],[11,"fetch_add","","Adds to the current value, returning the previous value.",84,{"inputs":[{"name":"self"},{"name":"i64"},{"name":"ordering"}],"output":{"name":"i64"}}],[11,"fetch_sub","","Subtracts from the current value, returning the previous value.",84,{"inputs":[{"name":"self"},{"name":"i64"},{"name":"ordering"}],"output":{"name":"i64"}}],[11,"fetch_and","","Bitwise \"and\" with the current value.",84,{"inputs":[{"name":"self"},{"name":"i64"},{"name":"ordering"}],"output":{"name":"i64"}}],[11,"fetch_or","","Bitwise \"or\" with the current value.",84,{"inputs":[{"name":"self"},{"name":"i64"},{"name":"ordering"}],"output":{"name":"i64"}}],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",84,{"inputs":[{"name":"self"},{"name":"i64"},{"name":"ordering"}],"output":{"name":"i64"}}],[11,"default","","",85,{"inputs":[],"output":{"name":"self"}}],[11,"fmt","","",85,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new atomic integer.",85,{"inputs":[{"name":"u64"}],"output":{"name":"self"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",85,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"into_inner","","Consumes the atomic and returns the contained value.",85,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"load","","Loads a value from the atomic integer.",85,{"inputs":[{"name":"self"},{"name":"ordering"}],"output":{"name":"u64"}}],[11,"store","","Stores a value into the atomic integer.",85,{"inputs":[{"name":"self"},{"name":"u64"},{"name":"ordering"}],"output":null}],[11,"swap","","Stores a value into the atomic integer, returning the previous value.",85,{"inputs":[{"name":"self"},{"name":"u64"},{"name":"ordering"}],"output":{"name":"u64"}}],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",85,{"inputs":[{"name":"self"},{"name":"u64"},{"name":"u64"},{"name":"ordering"}],"output":{"name":"u64"}}],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",85,{"inputs":[{"name":"self"},{"name":"u64"},{"name":"u64"},{"name":"ordering"},{"name":"ordering"}],"output":{"name":"result"}}],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",85,{"inputs":[{"name":"self"},{"name":"u64"},{"name":"u64"},{"name":"ordering"},{"name":"ordering"}],"output":{"name":"result"}}],[11,"fetch_add","","Adds to the current value, returning the previous value.",85,{"inputs":[{"name":"self"},{"name":"u64"},{"name":"ordering"}],"output":{"name":"u64"}}],[11,"fetch_sub","","Subtracts from the current value, returning the previous value.",85,{"inputs":[{"name":"self"},{"name":"u64"},{"name":"ordering"}],"output":{"name":"u64"}}],[11,"fetch_and","","Bitwise \"and\" with the current value.",85,{"inputs":[{"name":"self"},{"name":"u64"},{"name":"ordering"}],"output":{"name":"u64"}}],[11,"fetch_or","","Bitwise \"or\" with the current value.",85,{"inputs":[{"name":"self"},{"name":"u64"},{"name":"ordering"}],"output":{"name":"u64"}}],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",85,{"inputs":[{"name":"self"},{"name":"u64"},{"name":"ordering"}],"output":{"name":"u64"}}],[11,"default","","",86,{"inputs":[],"output":{"name":"self"}}],[11,"fmt","","",86,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new atomic integer.",86,{"inputs":[{"name":"isize"}],"output":{"name":"self"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",86,{"inputs":[{"name":"self"}],"output":{"name":"isize"}}],[11,"into_inner","","Consumes the atomic and returns the contained value.",86,{"inputs":[{"name":"self"}],"output":{"name":"isize"}}],[11,"load","","Loads a value from the atomic integer.",86,{"inputs":[{"name":"self"},{"name":"ordering"}],"output":{"name":"isize"}}],[11,"store","","Stores a value into the atomic integer.",86,{"inputs":[{"name":"self"},{"name":"isize"},{"name":"ordering"}],"output":null}],[11,"swap","","Stores a value into the atomic integer, returning the previous value.",86,{"inputs":[{"name":"self"},{"name":"isize"},{"name":"ordering"}],"output":{"name":"isize"}}],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",86,{"inputs":[{"name":"self"},{"name":"isize"},{"name":"isize"},{"name":"ordering"}],"output":{"name":"isize"}}],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",86,{"inputs":[{"name":"self"},{"name":"isize"},{"name":"isize"},{"name":"ordering"},{"name":"ordering"}],"output":{"name":"result"}}],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",86,{"inputs":[{"name":"self"},{"name":"isize"},{"name":"isize"},{"name":"ordering"},{"name":"ordering"}],"output":{"name":"result"}}],[11,"fetch_add","","Adds to the current value, returning the previous value.",86,{"inputs":[{"name":"self"},{"name":"isize"},{"name":"ordering"}],"output":{"name":"isize"}}],[11,"fetch_sub","","Subtracts from the current value, returning the previous value.",86,{"inputs":[{"name":"self"},{"name":"isize"},{"name":"ordering"}],"output":{"name":"isize"}}],[11,"fetch_and","","Bitwise \"and\" with the current value.",86,{"inputs":[{"name":"self"},{"name":"isize"},{"name":"ordering"}],"output":{"name":"isize"}}],[11,"fetch_or","","Bitwise \"or\" with the current value.",86,{"inputs":[{"name":"self"},{"name":"isize"},{"name":"ordering"}],"output":{"name":"isize"}}],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",86,{"inputs":[{"name":"self"},{"name":"isize"},{"name":"ordering"}],"output":{"name":"isize"}}],[11,"default","","",87,{"inputs":[],"output":{"name":"self"}}],[11,"fmt","","",87,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new atomic integer.",87,{"inputs":[{"name":"usize"}],"output":{"name":"self"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",87,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"into_inner","","Consumes the atomic and returns the contained value.",87,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"load","","Loads a value from the atomic integer.",87,{"inputs":[{"name":"self"},{"name":"ordering"}],"output":{"name":"usize"}}],[11,"store","","Stores a value into the atomic integer.",87,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"ordering"}],"output":null}],[11,"swap","","Stores a value into the atomic integer, returning the previous value.",87,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"ordering"}],"output":{"name":"usize"}}],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",87,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"usize"},{"name":"ordering"}],"output":{"name":"usize"}}],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",87,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"usize"},{"name":"ordering"},{"name":"ordering"}],"output":{"name":"result"}}],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",87,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"usize"},{"name":"ordering"},{"name":"ordering"}],"output":{"name":"result"}}],[11,"fetch_add","","Adds to the current value, returning the previous value.",87,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"ordering"}],"output":{"name":"usize"}}],[11,"fetch_sub","","Subtracts from the current value, returning the previous value.",87,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"ordering"}],"output":{"name":"usize"}}],[11,"fetch_and","","Bitwise \"and\" with the current value.",87,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"ordering"}],"output":{"name":"usize"}}],[11,"fetch_or","","Bitwise \"or\" with the current value.",87,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"ordering"}],"output":{"name":"usize"}}],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",87,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"ordering"}],"output":{"name":"usize"}}],[11,"fmt","","",76,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",77,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[0,"cell","core","Shareable mutable containers.",null,null],[3,"Cell","core::cell","A mutable memory location.",null,null],[3,"RefCell","","A mutable memory location with dynamically checked borrow rules",null,null],[3,"BorrowError","","An error returned by `RefCell::try_borrow`.",null,null],[3,"BorrowMutError","","An error returned by `RefCell::try_borrow_mut`.",null,null],[3,"Ref","","Wraps a borrowed reference to a value in a `RefCell` box. A wrapper type for an immutably borrowed value from a `RefCell<T>`.",null,null],[3,"RefMut","","A wrapper type for a mutably borrowed value from a `RefCell<T>`.",null,null],[3,"UnsafeCell","","The core primitive for interior mutability in Rust.",null,null],[11,"get","","Returns a copy of the contained value.",88,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"clone","","",88,{"inputs":[{"name":"self"}],"output":{"name":"cell"}}],[11,"default","","Creates a `Cell<T>`, with the `Default` value for T.",88,{"inputs":[],"output":{"name":"cell"}}],[11,"eq","","",88,{"inputs":[{"name":"self"},{"name":"cell"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",88,{"inputs":[{"name":"self"},{"name":"cell"}],"output":{"name":"option"}}],[11,"lt","","",88,{"inputs":[{"name":"self"},{"name":"cell"}],"output":{"name":"bool"}}],[11,"le","","",88,{"inputs":[{"name":"self"},{"name":"cell"}],"output":{"name":"bool"}}],[11,"gt","","",88,{"inputs":[{"name":"self"},{"name":"cell"}],"output":{"name":"bool"}}],[11,"ge","","",88,{"inputs":[{"name":"self"},{"name":"cell"}],"output":{"name":"bool"}}],[11,"cmp","","",88,{"inputs":[{"name":"self"},{"name":"cell"}],"output":{"name":"ordering"}}],[11,"from","","",88,{"inputs":[{"name":"t"}],"output":{"name":"cell"}}],[11,"new","","Creates a new `Cell` containing the given value.",88,{"inputs":[{"name":"t"}],"output":{"name":"cell"}}],[11,"as_ptr","","Returns a raw pointer to the underlying data in this cell.",88,null],[11,"get_mut","","Returns a mutable reference to the underlying data.",88,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"set","","Sets the contained value.",88,{"inputs":[{"name":"self"},{"name":"t"}],"output":null}],[11,"swap","","Swaps the values of two Cells. Difference with `std::mem::swap` is that this function doesn't require `&mut` reference.",88,{"inputs":[{"name":"self"},{"name":"self"}],"output":null}],[11,"replace","","Replaces the contained value, and returns it.",88,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"t"}}],[11,"into_inner","","Unwraps the value.",88,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"take","","Takes the value of the cell, leaving `Default::default()` in its place.",88,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"fmt","","",89,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",89,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",90,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",90,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new `RefCell` containing `value`.",91,{"inputs":[{"name":"t"}],"output":{"name":"refcell"}}],[11,"into_inner","","Consumes the `RefCell`, returning the wrapped value.",91,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"replace","","Replaces the wrapped value with a new one, returning the old value, without deinitializing either one.",91,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"t"}}],[11,"swap","","Swaps the wrapped value of `self` with the wrapped value of `other`, without deinitializing either one.",91,{"inputs":[{"name":"self"},{"name":"self"}],"output":null}],[11,"borrow","","Immutably borrows the wrapped value.",91,{"inputs":[{"name":"self"}],"output":{"name":"ref"}}],[11,"try_borrow","","Immutably borrows the wrapped value, returning an error if the value is currently mutably borrowed.",91,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"borrow_mut","","Mutably borrows the wrapped value.",91,{"inputs":[{"name":"self"}],"output":{"name":"refmut"}}],[11,"try_borrow_mut","","Mutably borrows the wrapped value, returning an error if the value is currently borrowed.",91,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"as_ptr","","Returns a raw pointer to the underlying data in this cell.",91,null],[11,"get_mut","","Returns a mutable reference to the underlying data.",91,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"clone","","",91,{"inputs":[{"name":"self"}],"output":{"name":"refcell"}}],[11,"default","","Creates a `RefCell<T>`, with the `Default` value for T.",91,{"inputs":[],"output":{"name":"refcell"}}],[11,"eq","","",91,{"inputs":[{"name":"self"},{"name":"refcell"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",91,{"inputs":[{"name":"self"},{"name":"refcell"}],"output":{"name":"option"}}],[11,"lt","","",91,{"inputs":[{"name":"self"},{"name":"refcell"}],"output":{"name":"bool"}}],[11,"le","","",91,{"inputs":[{"name":"self"},{"name":"refcell"}],"output":{"name":"bool"}}],[11,"gt","","",91,{"inputs":[{"name":"self"},{"name":"refcell"}],"output":{"name":"bool"}}],[11,"ge","","",91,{"inputs":[{"name":"self"},{"name":"refcell"}],"output":{"name":"bool"}}],[11,"cmp","","",91,{"inputs":[{"name":"self"},{"name":"refcell"}],"output":{"name":"ordering"}}],[11,"from","","",91,{"inputs":[{"name":"t"}],"output":{"name":"refcell"}}],[11,"deref","","",92,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"clone","","Copies a `Ref`.",92,{"inputs":[{"name":"ref"}],"output":{"name":"ref"}}],[11,"map","","Make a new `Ref` for a component of the borrowed data.",92,{"inputs":[{"name":"ref"},{"name":"f"}],"output":{"name":"ref"}}],[11,"fmt","","",92,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"map","","Make a new `RefMut` for a component of the borrowed data, e.g. an enum variant.",93,{"inputs":[{"name":"refmut"},{"name":"f"}],"output":{"name":"refmut"}}],[11,"deref","","",93,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"deref_mut","","",93,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"fmt","","",93,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Constructs a new instance of `UnsafeCell` which will wrap the specified value.",94,{"inputs":[{"name":"t"}],"output":{"name":"unsafecell"}}],[11,"into_inner","","Unwraps the value.",94,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"get","","Gets a mutable pointer to the wrapped value.",94,null],[11,"default","","Creates an `UnsafeCell`, with the `Default` value for T.",94,{"inputs":[],"output":{"name":"unsafecell"}}],[11,"from","","",94,{"inputs":[{"name":"t"}],"output":{"name":"unsafecell"}}],[0,"char","core","Character manipulation.",null,null],[3,"ParseCharError","core::char","An error which can be returned when parsing a char.",null,null],[3,"CharTryFromError","","The error type returned when a conversion from u32 to char fails.",null,null],[3,"EscapeUnicode","","Returns an iterator that yields the hexadecimal Unicode escape of a character, as `char`s.",null,null],[3,"EscapeDefault","","An iterator that yields the literal escape code of a `char`.",null,null],[3,"EscapeDebug","","An iterator that yields the literal escape code of a `char`.",null,null],[3,"DecodeUtf8","","An iterator over an iterator of bytes of the characters the bytes represent as UTF-8",null,null],[3,"InvalidSequence","","`<DecodeUtf8 as Iterator>::next` returns this for an invalid input sequence.",null,null],[5,"from_u32","","Converts a `u32` to a `char`.",null,{"inputs":[{"name":"u32"}],"output":{"name":"option"}}],[5,"from_u32_unchecked","","Converts a `u32` to a `char`, ignoring validity.",null,{"inputs":[{"name":"u32"}],"output":{"name":"char"}}],[5,"from_digit","","Converts a digit in the given radix to a `char`.",null,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"option"}}],[5,"decode_utf8","","Decodes an `Iterator` of bytes as UTF-8.",null,{"inputs":[{"name":"i"}],"output":{"name":"decodeutf8"}}],[17,"MAX","","The highest valid code point a `char` can have.",null,null],[11,"clone","","",95,{"inputs":[{"name":"self"}],"output":{"name":"parsecharerror"}}],[11,"fmt","","",95,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",95,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",96,{"inputs":[{"name":"self"}],"output":{"name":"chartryfromerror"}}],[11,"fmt","","",96,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",96,{"inputs":[{"name":"self"},{"name":"chartryfromerror"}],"output":{"name":"bool"}}],[11,"ne","","",96,{"inputs":[{"name":"self"},{"name":"chartryfromerror"}],"output":{"name":"bool"}}],[11,"fmt","","",96,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",97,{"inputs":[{"name":"self"}],"output":{"name":"escapeunicode"}}],[11,"fmt","","",97,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",97,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",97,null],[11,"count","","",97,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"last","","",97,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"len","","",97,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"fmt","","",97,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",98,{"inputs":[{"name":"self"}],"output":{"name":"escapedefault"}}],[11,"fmt","","",98,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",98,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",98,null],[11,"count","","",98,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"nth","","",98,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",98,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"len","","",98,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"fmt","","",98,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",99,{"inputs":[{"name":"self"}],"output":{"name":"escapedebug"}}],[11,"fmt","","",99,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",99,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",99,null],[11,"fmt","","",99,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",100,{"inputs":[{"name":"self"}],"output":{"name":"decodeutf8"}}],[11,"fmt","","",100,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",101,{"inputs":[{"name":"self"},{"name":"invalidsequence"}],"output":{"name":"bool"}}],[11,"ne","","",101,{"inputs":[{"name":"self"},{"name":"invalidsequence"}],"output":{"name":"bool"}}],[11,"fmt","","",101,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",100,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[0,"panicking","core","Panic support for libcore",null,null],[5,"panic","core::panicking","",null,null],[5,"panic_fmt","","",null,null],[0,"iter","core","Composable external iteration.",null,null],[3,"Repeat","core::iter","An iterator that repeats an element endlessly.",null,null],[3,"Empty","","An iterator that yields nothing.",null,null],[3,"Once","","An iterator that yields an element exactly once.",null,null],[3,"Rev","","A double-ended iterator with the direction inverted.",null,null],[3,"Cloned","","An iterator that clones the elements of an underlying iterator.",null,null],[3,"Cycle","","An iterator that repeats endlessly.",null,null],[3,"StepBy","","An iterator for stepping iterators by a custom amount.",null,null],[3,"Chain","","An iterator that strings two iterators together.",null,null],[3,"Zip","","An iterator that iterates two other iterators simultaneously.",null,null],[3,"Map","","An iterator that maps the values of `iter` with `f`.",null,null],[3,"Filter","","An iterator that filters the elements of `iter` with `predicate`.",null,null],[3,"FilterMap","","An iterator that uses `f` to both filter and map elements from `iter`.",null,null],[3,"Enumerate","","An iterator that yields the current count and the element during iteration.",null,null],[3,"Peekable","","An iterator with a `peek()` that returns an optional reference to the next element.",null,null],[3,"SkipWhile","","An iterator that rejects elements while `predicate` is true.",null,null],[3,"TakeWhile","","An iterator that only accepts elements while `predicate` is true.",null,null],[3,"Skip","","An iterator that skips over `n` elements of `iter`.",null,null],[3,"Take","","An iterator that only iterates over the first `n` iterations of `iter`.",null,null],[3,"Scan","","An iterator to maintain state while iterating another iterator.",null,null],[3,"FlatMap","","An iterator that maps each element to an iterator, and yields the elements of the produced iterators.",null,null],[3,"Fuse","","An iterator that yields `None` forever after the underlying iterator yields `None` once.",null,null],[3,"Inspect","","An iterator that calls a function with a reference to each element before yielding it.",null,null],[5,"repeat","","Creates a new iterator that endlessly repeats a single element.",null,{"inputs":[{"name":"t"}],"output":{"name":"repeat"}}],[5,"empty","","Creates an iterator that yields nothing.",null,{"inputs":[],"output":{"name":"empty"}}],[5,"once","","Creates an iterator that yields an element exactly once.",null,{"inputs":[{"name":"t"}],"output":{"name":"once"}}],[11,"next","core::ops","",12,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",12,null],[11,"nth","","",12,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"next_back","","",12,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",13,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",13,null],[11,"nth","","",13,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"next","","",15,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",15,null],[11,"nth","","",15,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"next_back","","",15,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","core::iter","",102,{"inputs":[{"name":"self"}],"output":{"name":"repeat"}}],[11,"fmt","","",102,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",102,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",102,null],[11,"next_back","","",102,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",103,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",103,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",103,null],[11,"next_back","","",103,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"len","","",103,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"clone","","",103,{"inputs":[{"name":"self"}],"output":{"name":"empty"}}],[11,"default","","",103,{"inputs":[],"output":{"name":"empty"}}],[11,"clone","","",104,{"inputs":[{"name":"self"}],"output":{"name":"once"}}],[11,"fmt","","",104,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",104,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",104,null],[11,"next_back","","",104,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"len","","",104,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"sum","core::num","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[8,"Iterator","core::iter","An interface for dealing with iterators.",null,null],[16,"Item","","The type of the elements being iterated over.",105,null],[10,"next","","Advances the iterator and returns the next value.",105,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","Returns the bounds on the remaining length of the iterator.",105,null],[11,"count","","Consumes the iterator, counting the number of iterations and returning it.",105,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"last","","Consumes the iterator, returning the last element.",105,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"nth","","Returns the `n`th element of the iterator.",105,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"step_by","","Creates an iterator starting at the same point, but stepping by the given amount at each iteration.",105,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"stepby"}}],[11,"chain","","Takes two iterators and creates a new iterator over both in sequence.",105,{"inputs":[{"name":"self"},{"name":"u"}],"output":{"name":"chain"}}],[11,"zip","","'Zips up' two iterators into a single iterator of pairs.",105,{"inputs":[{"name":"self"},{"name":"u"}],"output":{"name":"zip"}}],[11,"map","","Takes a closure and creates an iterator which calls that closure on each element.",105,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"map"}}],[11,"for_each","","Calls a closure on each element of an iterator.",105,{"inputs":[{"name":"self"},{"name":"f"}],"output":null}],[11,"filter","","Creates an iterator which uses a closure to determine if an element should be yielded.",105,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"filter"}}],[11,"filter_map","","Creates an iterator that both filters and maps.",105,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"filtermap"}}],[11,"enumerate","","Creates an iterator which gives the current iteration count as well as the next value.",105,{"inputs":[{"name":"self"}],"output":{"name":"enumerate"}}],[11,"peekable","","Creates an iterator which can use `peek` to look at the next element of the iterator without consuming it.",105,{"inputs":[{"name":"self"}],"output":{"name":"peekable"}}],[11,"skip_while","","Creates an iterator that [`skip`]s elements based on a predicate.",105,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"skipwhile"}}],[11,"take_while","","Creates an iterator that yields elements based on a predicate.",105,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"takewhile"}}],[11,"skip","","Creates an iterator that skips the first `n` elements.",105,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"skip"}}],[11,"take","","Creates an iterator that yields its first `n` elements.",105,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"take"}}],[11,"scan","","An iterator adaptor similar to [`fold`] that holds internal state and produces a new iterator.",105,{"inputs":[{"name":"self"},{"name":"st"},{"name":"f"}],"output":{"name":"scan"}}],[11,"flat_map","","Creates an iterator that works like map, but flattens nested structure.",105,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"flatmap"}}],[11,"fuse","","Creates an iterator which ends after the first [`None`].",105,{"inputs":[{"name":"self"}],"output":{"name":"fuse"}}],[11,"inspect","","Do something with each element of an iterator, passing the value on.",105,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"inspect"}}],[11,"by_ref","","Borrows an iterator, rather than consuming it.",105,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"collect","","Transforms an iterator into a collection.",105,{"inputs":[{"name":"self"}],"output":{"name":"b"}}],[11,"partition","","Consumes an iterator, creating two collections from it.",105,null],[11,"fold","","An iterator method that applies a function, producing a single, final value.",105,{"inputs":[{"name":"self"},{"name":"b"},{"name":"f"}],"output":{"name":"b"}}],[11,"all","","Tests if every element of the iterator matches a predicate.",105,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"any","","Tests if any element of the iterator matches a predicate.",105,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"find","","Searches for an element of an iterator that satisfies a predicate.",105,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"option"}}],[11,"position","","Searches for an element in an iterator, returning its index.",105,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"option"}}],[11,"rposition","","Searches for an element in an iterator from the right, returning its index.",105,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"option"}}],[11,"max","","Returns the maximum element of an iterator.",105,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"min","","Returns the minimum element of an iterator.",105,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"max_by_key","","Returns the element that gives the maximum value from the specified function.",105,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"max_by","","Returns the element that gives the maximum value with respect to the specified comparison function.",105,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"min_by_key","","Returns the element that gives the minimum value from the specified function.",105,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"min_by","","Returns the element that gives the minimum value with respect to the specified comparison function.",105,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"rev","","Reverses an iterator's direction.",105,{"inputs":[{"name":"self"}],"output":{"name":"rev"}}],[11,"unzip","","Converts an iterator of pairs into a pair of containers.",105,null],[11,"cloned","","Creates an iterator which [`clone`]s all of its elements.",105,{"inputs":[{"name":"self"}],"output":{"name":"cloned"}}],[11,"cycle","","Repeats an iterator endlessly.",105,{"inputs":[{"name":"self"}],"output":{"name":"cycle"}}],[11,"sum","","Sums the elements of an iterator.",105,{"inputs":[{"name":"self"}],"output":{"name":"s"}}],[11,"product","","Iterates over the entire iterator, multiplying all the elements",105,{"inputs":[{"name":"self"}],"output":{"name":"p"}}],[11,"cmp","","Lexicographically compares the elements of this `Iterator` with those of another.",105,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","Lexicographically compares the elements of this `Iterator` with those of another.",105,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"option"}}],[11,"eq","","Determines if the elements of this `Iterator` are equal to those of another.",105,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"bool"}}],[11,"ne","","Determines if the elements of this `Iterator` are unequal to those of another.",105,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"bool"}}],[11,"lt","","Determines if the elements of this `Iterator` are lexicographically less than those of another.",105,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"bool"}}],[11,"le","","Determines if the elements of this `Iterator` are lexicographically less or equal to those of another.",105,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"bool"}}],[11,"gt","","Determines if the elements of this `Iterator` are lexicographically greater than those of another.",105,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"bool"}}],[11,"ge","","Determines if the elements of this `Iterator` are lexicographically greater than or equal to those of another.",105,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"bool"}}],[8,"Step","","Objects that can be stepped over in both directions.",null,null],[10,"steps_between","","Returns the number of steps between two step objects. The count is inclusive of `start` and exclusive of `end`.",106,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"option"}}],[10,"replace_one","","Replaces this step with `1`, returning itself",106,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[10,"replace_zero","","Replaces this step with `0`, returning itself",106,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[10,"add_one","","Adds one to this step, returning the result",106,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[10,"sub_one","","Subtracts one to this step, returning the result",106,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[10,"add_usize","","Add an usize, returning None on overflow",106,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[8,"FromIterator","","Conversion from an `Iterator`.",null,null],[10,"from_iter","","Creates a value from an iterator.",107,{"inputs":[{"name":"t"}],"output":{"name":"self"}}],[8,"IntoIterator","","Conversion into an `Iterator`.",null,null],[16,"Item","","The type of the elements being iterated over.",108,null],[16,"IntoIter","","Which kind of iterator are we turning this into?",108,null],[10,"into_iter","","Creates an iterator from a value.",108,null],[8,"DoubleEndedIterator","","An iterator able to yield elements from both ends.",null,null],[10,"next_back","","Removes and returns an element from the end of the iterator.",109,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"rfold","","An iterator method that reduces the iterator's elements to a single, final value, starting from the back.",109,{"inputs":[{"name":"self"},{"name":"b"},{"name":"f"}],"output":{"name":"b"}}],[11,"rfind","","Searches for an element of an iterator from the right that satisfies a predicate.",109,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"option"}}],[8,"Extend","","Extend a collection with the contents of an iterator.",null,null],[10,"extend","","Extends a collection with the contents of an iterator.",110,{"inputs":[{"name":"self"},{"name":"t"}],"output":null}],[8,"ExactSizeIterator","","An iterator that knows its exact length.",null,null],[11,"len","","Returns the exact number of times the iterator will iterate.",111,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","Returns whether the iterator is empty.",111,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[8,"Sum","","Trait to represent types that can be created by summing up an iterator.",null,null],[10,"sum","","Method which takes an iterator and generates `Self` from the elements by \"summing up\" the items.",112,{"inputs":[{"name":"i"}],"output":{"name":"self"}}],[8,"Product","","Trait to represent types that can be created by multiplying elements of an iterator.",null,null],[10,"product","","Method which takes an iterator and generates `Self` from the elements by multiplying the items.",113,{"inputs":[{"name":"i"}],"output":{"name":"self"}}],[8,"FusedIterator","","An iterator that always continues to yield `None` when exhausted.",null,null],[8,"TrustedLen","","An iterator that reports an accurate length using size_hint.",null,null],[11,"clone","","",114,{"inputs":[{"name":"self"}],"output":{"name":"rev"}}],[11,"fmt","","",114,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",114,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",114,null],[11,"fold","","",114,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"f"}],"output":{"name":"acc"}}],[11,"find","","",114,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"option"}}],[11,"rposition","","",114,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"option"}}],[11,"next_back","","",114,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"rfold","","",114,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"f"}],"output":{"name":"acc"}}],[11,"rfind","","",114,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"option"}}],[11,"len","","",114,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","",114,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",115,{"inputs":[{"name":"self"}],"output":{"name":"cloned"}}],[11,"fmt","","",115,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",115,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",115,null],[11,"fold","","",115,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"f"}],"output":{"name":"acc"}}],[11,"next_back","","",115,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"rfold","","",115,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"f"}],"output":{"name":"acc"}}],[11,"len","","",115,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","",115,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",116,{"inputs":[{"name":"self"}],"output":{"name":"cycle"}}],[11,"fmt","","",116,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",116,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",116,null],[11,"clone","","",117,{"inputs":[{"name":"self"}],"output":{"name":"stepby"}}],[11,"fmt","","",117,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",117,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",117,null],[11,"clone","","",118,{"inputs":[{"name":"self"}],"output":{"name":"chain"}}],[11,"fmt","","",118,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",118,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"count","","",118,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"fold","","",118,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"f"}],"output":{"name":"acc"}}],[11,"nth","","",118,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"find","","",118,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"option"}}],[11,"last","","",118,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",118,null],[11,"next_back","","",118,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"rfold","","",118,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"f"}],"output":{"name":"acc"}}],[11,"clone","","",119,{"inputs":[{"name":"self"}],"output":{"name":"zip"}}],[11,"fmt","","",119,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",119,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",119,null],[11,"next_back","","",119,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",120,{"inputs":[{"name":"self"}],"output":{"name":"map"}}],[11,"fmt","","",120,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",120,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",120,null],[11,"fold","","",120,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"g"}],"output":{"name":"acc"}}],[11,"next_back","","",120,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"rfold","","",120,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"g"}],"output":{"name":"acc"}}],[11,"len","","",120,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","",120,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",121,{"inputs":[{"name":"self"}],"output":{"name":"filter"}}],[11,"fmt","","",121,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",121,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",121,null],[11,"count","","",121,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"fold","","",121,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"acc"}}],[11,"next_back","","",121,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"rfold","","",121,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"acc"}}],[11,"clone","","",122,{"inputs":[{"name":"self"}],"output":{"name":"filtermap"}}],[11,"fmt","","",122,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",122,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",122,null],[11,"fold","","",122,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"acc"}}],[11,"next_back","","",122,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"rfold","","",122,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"acc"}}],[11,"clone","","",123,{"inputs":[{"name":"self"}],"output":{"name":"enumerate"}}],[11,"fmt","","",123,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","Overflow Behavior",123,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",123,null],[11,"nth","","",123,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"count","","",123,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"fold","","",123,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"acc"}}],[11,"next_back","","",123,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"rfold","","",123,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"acc"}}],[11,"len","","",123,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","",123,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",124,{"inputs":[{"name":"self"}],"output":{"name":"peekable"}}],[11,"fmt","","",124,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",124,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"count","","",124,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"nth","","",124,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",124,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",124,null],[11,"fold","","",124,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"acc"}}],[11,"peek","","Returns a reference to the next() value without advancing the iterator.",124,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",125,{"inputs":[{"name":"self"}],"output":{"name":"skipwhile"}}],[11,"fmt","","",125,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",125,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",125,null],[11,"fold","","",125,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"acc"}}],[11,"clone","","",126,{"inputs":[{"name":"self"}],"output":{"name":"takewhile"}}],[11,"fmt","","",126,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",126,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",126,null],[11,"clone","","",127,{"inputs":[{"name":"self"}],"output":{"name":"skip"}}],[11,"fmt","","",127,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",127,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"nth","","",127,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"count","","",127,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"last","","",127,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",127,null],[11,"fold","","",127,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"acc"}}],[11,"next_back","","",127,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",128,{"inputs":[{"name":"self"}],"output":{"name":"take"}}],[11,"fmt","","",128,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",128,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"nth","","",128,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"size_hint","","",128,null],[11,"clone","","",129,{"inputs":[{"name":"self"}],"output":{"name":"scan"}}],[11,"fmt","","",129,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",129,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",129,null],[11,"clone","","",130,{"inputs":[{"name":"self"}],"output":{"name":"flatmap"}}],[11,"fmt","","",130,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",130,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",130,null],[11,"fold","","",130,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"acc"}}],[11,"next_back","","",130,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"rfold","","",130,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"acc"}}],[11,"clone","","",131,{"inputs":[{"name":"self"}],"output":{"name":"fuse"}}],[11,"fmt","","",131,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",131,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"nth","","",131,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",131,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"count","","",131,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"size_hint","","",131,null],[11,"fold","","",131,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"acc"}}],[11,"next_back","","",131,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"rfold","","",131,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"acc"}}],[11,"next","","",131,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"nth","","",131,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",131,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"count","","",131,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"size_hint","","",131,null],[11,"fold","","",131,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"acc"}}],[11,"next_back","","",131,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"rfold","","",131,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"acc"}}],[11,"len","","",131,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","",131,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",132,{"inputs":[{"name":"self"}],"output":{"name":"inspect"}}],[11,"fmt","","",132,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",132,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",132,null],[11,"fold","","",132,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"acc"}}],[11,"next_back","","",132,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"rfold","","",132,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"acc"}}],[11,"len","","",132,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","",132,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[0,"option","core","Optional values.",null,null],[3,"Iter","core::option","An iterator over a reference to the [`Some`] variant of an [`Option`].",null,null],[3,"IterMut","","An iterator over a mutable reference to the [`Some`] variant of an [`Option`].",null,null],[3,"IntoIter","","An iterator over the value in [`Some`] variant of an [`Option`].",null,null],[3,"NoneError","","The error type that results from applying the try operator (`?`) to a `None` value. If you wish to allow `x?` (where `x` is an `Option<T>`) to be converted into your error type, you can implement `impl From<NoneError>` for `YourErrorType`. In that case, `x?` within a function that returns `Result<_, YourErrorType>` will translate a `None` value into an `Err` result.",null,null],[4,"Option","","The `Option` type. See the module level documentation for more.",null,null],[13,"None","","No value",133,null],[13,"Some","","Some value `T`",133,null],[11,"clone","","",133,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"eq","","",133,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"name":"bool"}}],[11,"ne","","",133,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",133,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"name":"option"}}],[11,"lt","","",133,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"name":"bool"}}],[11,"le","","",133,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"name":"bool"}}],[11,"gt","","",133,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"name":"bool"}}],[11,"ge","","",133,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"name":"bool"}}],[11,"cmp","","",133,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"name":"ordering"}}],[11,"fmt","","",133,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",133,null],[11,"is_some","","Returns `true` if the option is a [`Some`] value.",133,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_none","","Returns `true` if the option is a [`None`] value.",133,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"as_ref","","Converts from `Option<T>` to `Option<&T>`.",133,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"as_mut","","Converts from `Option<T>` to `Option<&mut T>`.",133,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"expect","","Unwraps an option, yielding the content of a [`Some`].",133,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"t"}}],[11,"unwrap","","Moves the value `v` out of the `Option<T>` if it is [`Some(v)`].",133,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"unwrap_or","","Returns the contained value or a default.",133,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"t"}}],[11,"unwrap_or_else","","Returns the contained value or computes it from a closure.",133,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"t"}}],[11,"map","","Maps an `Option<T>` to `Option<U>` by applying a function to a contained value.",133,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"map_or","","Applies a function to the contained value (if any), or returns a [`default`][] (if not).",133,{"inputs":[{"name":"self"},{"name":"u"},{"name":"f"}],"output":{"name":"u"}}],[11,"map_or_else","","Applies a function to the contained value (if any), or computes a [`default`][] (if not).",133,{"inputs":[{"name":"self"},{"name":"d"},{"name":"f"}],"output":{"name":"u"}}],[11,"ok_or","","Transforms the `Option<T>` into a [`Result<T, E>`], mapping [`Some(v)`] to [`Ok(v)`] and [`None`] to [`Err(err)`].",133,{"inputs":[{"name":"self"},{"name":"e"}],"output":{"name":"result"}}],[11,"ok_or_else","","Transforms the `Option<T>` into a [`Result<T, E>`], mapping [`Some(v)`] to [`Ok(v)`] and [`None`] to [`Err(err())`].",133,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"result"}}],[11,"iter","","Returns an iterator over the possibly contained value.",133,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"iter_mut","","Returns a mutable iterator over the possibly contained value.",133,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"and","","Returns [`None`] if the option is [`None`], otherwise returns `optb`.",133,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"name":"option"}}],[11,"and_then","","Returns [`None`] if the option is [`None`], otherwise calls `f` with the wrapped value and returns the result.",133,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"or","","Returns the option if it contains a value, otherwise returns `optb`.",133,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"name":"option"}}],[11,"or_else","","Returns the option if it contains a value, otherwise calls `f` and returns the result.",133,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"get_or_insert","","Inserts `v` into the option if it is [`None`], then returns a mutable reference to the contained value.",133,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"t"}}],[11,"get_or_insert_with","","Inserts a value computed from `f` into the option if it is [`None`], then returns a mutable reference to the contained value.",133,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"t"}}],[11,"take","","Takes the value out of the option, leaving a [`None`] in its place.",133,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"cloned","","Maps an `Option<&T>` to an `Option<T>` by cloning the contents of the option.",133,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"cloned","","Maps an `Option<&mut T>` to an `Option<T>` by cloning the contents of the option.",133,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"unwrap_or_default","","Returns the contained value or a default",133,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"default","","Returns [`None`].",133,{"inputs":[],"output":{"name":"option"}}],[11,"into_iter","","Returns a consuming iterator over the possibly contained value.",133,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"from","","",133,{"inputs":[{"name":"t"}],"output":{"name":"option"}}],[11,"fmt","","",134,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",134,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",134,null],[11,"next_back","","",134,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",134,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"fmt","","",135,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",135,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",135,null],[11,"next_back","","",135,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",136,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"fmt","","",136,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",136,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",136,null],[11,"next_back","","",136,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"from_iter","","Takes each element in the [`Iterator`]: if it is [`None`], no further elements are taken, and the [`None`] is returned. Should no [`None`] occur, a container with the values of each `Option` is returned.",133,{"inputs":[{"name":"i"}],"output":{"name":"option"}}],[11,"clone","","",137,{"inputs":[{"name":"self"}],"output":{"name":"noneerror"}}],[11,"eq","","",137,{"inputs":[{"name":"self"},{"name":"noneerror"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",137,{"inputs":[{"name":"self"},{"name":"noneerror"}],"output":{"name":"option"}}],[11,"cmp","","",137,{"inputs":[{"name":"self"},{"name":"noneerror"}],"output":{"name":"ordering"}}],[11,"fmt","","",137,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",137,null],[11,"into_result","","",133,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"from_ok","","",133,{"inputs":[{"name":"t"}],"output":{"name":"self"}}],[11,"from_error","","",133,{"inputs":[{"name":"noneerror"}],"output":{"name":"self"}}],[0,"raw","core","Contains struct definitions for the layout of compiler built-in types.",null,null],[3,"TraitObject","core::raw","The representation of a trait object like `&SomeTrait`.",null,null],[12,"data","","",138,null],[12,"vtable","","",138,null],[11,"clone","","",138,{"inputs":[{"name":"self"}],"output":{"name":"traitobject"}}],[0,"result","core","Error handling with the `Result` type.",null,null],[3,"Iter","core::result","An iterator over a reference to the [`Ok`] variant of a [`Result`].",null,null],[3,"IterMut","","An iterator over a mutable reference to the [`Ok`] variant of a [`Result`].",null,null],[3,"IntoIter","","An iterator over the value in a [`Ok`] variant of a [`Result`].",null,null],[4,"Result","","`Result` is a type that represents either success ([`Ok`]) or failure ([`Err`]).",null,null],[13,"Ok","","Contains the success value",139,null],[13,"Err","","Contains the error value",139,null],[11,"clone","","",139,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"eq","","",139,{"inputs":[{"name":"self"},{"name":"result"}],"output":{"name":"bool"}}],[11,"ne","","",139,{"inputs":[{"name":"self"},{"name":"result"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",139,{"inputs":[{"name":"self"},{"name":"result"}],"output":{"name":"option"}}],[11,"lt","","",139,{"inputs":[{"name":"self"},{"name":"result"}],"output":{"name":"bool"}}],[11,"le","","",139,{"inputs":[{"name":"self"},{"name":"result"}],"output":{"name":"bool"}}],[11,"gt","","",139,{"inputs":[{"name":"self"},{"name":"result"}],"output":{"name":"bool"}}],[11,"ge","","",139,{"inputs":[{"name":"self"},{"name":"result"}],"output":{"name":"bool"}}],[11,"cmp","","",139,{"inputs":[{"name":"self"},{"name":"result"}],"output":{"name":"ordering"}}],[11,"fmt","","",139,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",139,null],[11,"is_ok","","Returns `true` if the result is [`Ok`].",139,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_err","","Returns `true` if the result is [`Err`].",139,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"ok","","Converts from `Result<T, E>` to [`Option<T>`].",139,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"err","","Converts from `Result<T, E>` to [`Option<E>`].",139,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"as_ref","","Converts from `Result<T, E>` to `Result<&T, &E>`.",139,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"as_mut","","Converts from `Result<T, E>` to `Result<&mut T, &mut E>`.",139,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"map","","Maps a `Result<T, E>` to `Result<U, E>` by applying a function to a contained [`Ok`] value, leaving an [`Err`] value untouched.",139,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"result"}}],[11,"map_err","","Maps a `Result<T, E>` to `Result<T, F>` by applying a function to a contained [`Err`] value, leaving an [`Ok`] value untouched.",139,{"inputs":[{"name":"self"},{"name":"o"}],"output":{"name":"result"}}],[11,"iter","","Returns an iterator over the possibly contained value.",139,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"iter_mut","","Returns a mutable iterator over the possibly contained value.",139,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"and","","Returns `res` if the result is [`Ok`], otherwise returns the [`Err`] value of `self`.",139,{"inputs":[{"name":"self"},{"name":"result"}],"output":{"name":"result"}}],[11,"and_then","","Calls `op` if the result is [`Ok`], otherwise returns the [`Err`] value of `self`.",139,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"result"}}],[11,"or","","Returns `res` if the result is [`Err`], otherwise returns the [`Ok`] value of `self`.",139,{"inputs":[{"name":"self"},{"name":"result"}],"output":{"name":"result"}}],[11,"or_else","","Calls `op` if the result is [`Err`], otherwise returns the [`Ok`] value of `self`.",139,{"inputs":[{"name":"self"},{"name":"o"}],"output":{"name":"result"}}],[11,"unwrap_or","","Unwraps a result, yielding the content of an [`Ok`]. Else, it returns `optb`.",139,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"t"}}],[11,"unwrap_or_else","","Unwraps a result, yielding the content of an [`Ok`]. If the value is an [`Err`] then it calls `op` with its value.",139,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"t"}}],[11,"unwrap","","Unwraps a result, yielding the content of an [`Ok`].",139,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"expect","","Unwraps a result, yielding the content of an [`Ok`].",139,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"t"}}],[11,"unwrap_err","","Unwraps a result, yielding the content of an [`Err`].",139,{"inputs":[{"name":"self"}],"output":{"name":"e"}}],[11,"expect_err","","Unwraps a result, yielding the content of an [`Err`].",139,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"e"}}],[11,"unwrap_or_default","","Returns the contained value or a default",139,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"into_iter","","Returns a consuming iterator over the possibly contained value.",139,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"fmt","","",140,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",140,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",140,null],[11,"next_back","","",140,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",140,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"fmt","","",141,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",141,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",141,null],[11,"next_back","","",141,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",142,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",142,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",142,null],[11,"next_back","","",142,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"from_iter","","Takes each element in the `Iterator`: if it is an `Err`, no further elements are taken, and the `Err` is returned. Should no `Err` occur, a container with the values of each `Result` is returned.",139,{"inputs":[{"name":"i"}],"output":{"name":"result"}}],[11,"into_result","","",139,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"from_ok","","",139,{"inputs":[{"name":"t"}],"output":{"name":"self"}}],[11,"from_error","","",139,{"inputs":[{"name":"e"}],"output":{"name":"self"}}],[0,"slice","core","Slice management and manipulation",null,null],[3,"Iter","core::slice","Immutable slice iterator",null,null],[3,"IterMut","","Mutable slice iterator.",null,null],[3,"Split","","An iterator over subslices separated by elements that match a predicate function.",null,null],[3,"SplitMut","","An iterator over the subslices of the vector which are separated by elements that match `pred`.",null,null],[3,"RSplit","","An iterator over subslices separated by elements that match a predicate function, starting from the end of the slice.",null,null],[3,"RSplitMut","","An iterator over the subslices of the vector which are separated by elements that match `pred`, starting from the end of the slice.",null,null],[3,"SplitN","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits.",null,null],[3,"RSplitN","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits, starting from the end of the slice.",null,null],[3,"SplitNMut","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits.",null,null],[3,"RSplitNMut","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits, starting from the end of the slice.",null,null],[3,"Windows","","An iterator over overlapping subslices of length `size`.",null,null],[3,"Chunks","","An iterator over a slice in (non-overlapping) chunks (`size` elements at a time).",null,null],[3,"ChunksMut","","An iterator over a slice in (non-overlapping) mutable chunks (`size` elements at a time). When the slice len is not evenly divided by the chunk size, the last slice of the iteration will be the remainder.",null,null],[5,"from_raw_parts","","Forms a slice from a pointer and a length.",null,null],[5,"from_raw_parts_mut","","Performs the same functionality as `from_raw_parts`, except that a mutable slice is returned.",null,null],[8,"SliceExt","","Extension methods for slices.",null,null],[16,"Item","","",143,null],[10,"split_at","","",143,null],[10,"iter","","",143,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[10,"split","","",143,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"split"}}],[10,"rsplit","","",143,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"rsplit"}}],[10,"splitn","","",143,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"p"}],"output":{"name":"splitn"}}],[10,"rsplitn","","",143,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"p"}],"output":{"name":"rsplitn"}}],[10,"windows","","",143,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"windows"}}],[10,"chunks","","",143,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"chunks"}}],[10,"get","","",143,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"option"}}],[10,"first","","",143,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[10,"split_first","","",143,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[10,"split_last","","",143,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[10,"last","","",143,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[10,"get_unchecked","","",143,null],[10,"as_ptr","","",143,null],[10,"binary_search","","",143,null],[10,"binary_search_by","","",143,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"result"}}],[10,"binary_search_by_key","","",143,{"inputs":[{"name":"self"},{"name":"b"},{"name":"f"}],"output":{"name":"result"}}],[10,"len","","",143,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","",143,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[10,"get_mut","","",143,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"option"}}],[10,"iter_mut","","",143,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[10,"first_mut","","",143,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[10,"split_first_mut","","",143,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[10,"split_last_mut","","",143,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[10,"last_mut","","",143,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[10,"split_mut","","",143,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"splitmut"}}],[10,"rsplit_mut","","",143,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"rsplitmut"}}],[10,"splitn_mut","","",143,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"p"}],"output":{"name":"splitnmut"}}],[10,"rsplitn_mut","","",143,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"p"}],"output":{"name":"rsplitnmut"}}],[10,"chunks_mut","","",143,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"chunksmut"}}],[10,"swap","","",143,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"usize"}],"output":null}],[10,"split_at_mut","","",143,null],[10,"reverse","","",143,{"inputs":[{"name":"self"}],"output":null}],[10,"get_unchecked_mut","","",143,null],[10,"as_mut_ptr","","",143,null],[10,"contains","","",143,null],[10,"starts_with","","",143,null],[10,"ends_with","","",143,null],[10,"rotate","","",143,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[10,"clone_from_slice","","",143,null],[10,"copy_from_slice","","",143,null],[10,"swap_with_slice","","",143,null],[10,"sort_unstable","","",143,{"inputs":[{"name":"self"}],"output":null}],[10,"sort_unstable_by","","",143,{"inputs":[{"name":"self"},{"name":"f"}],"output":null}],[10,"sort_unstable_by_key","","",143,{"inputs":[{"name":"self"},{"name":"f"}],"output":null}],[8,"SliceIndex","","A helper trait used for indexing operations.",null,null],[16,"Output","","The output type returned by methods.",144,null],[10,"get","","Returns a shared reference to the output at this location, if in bounds.",144,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"option"}}],[10,"get_mut","","Returns a mutable reference to the output at this location, if in bounds.",144,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"option"}}],[10,"get_unchecked","","Returns a shared reference to the output at this location, without performing any bounds checking.",144,null],[10,"get_unchecked_mut","","Returns a mutable reference to the output at this location, without performing any bounds checking.",144,null],[10,"index","","Returns a shared reference to the output at this location, panicking if out of bounds.",144,null],[10,"index_mut","","Returns a mutable reference to the output at this location, panicking if out of bounds.",144,null],[11,"get","core::ops","",12,null],[11,"get_mut","","",12,null],[11,"get_unchecked","","",12,null],[11,"get_unchecked_mut","","",12,null],[11,"index","","",12,null],[11,"index_mut","","",12,null],[11,"get","","",14,null],[11,"get_mut","","",14,null],[11,"get_unchecked","","",14,null],[11,"get_unchecked_mut","","",14,null],[11,"index","","",14,null],[11,"index_mut","","",14,null],[11,"get","","",13,null],[11,"get_mut","","",13,null],[11,"get_unchecked","","",13,null],[11,"get_unchecked_mut","","",13,null],[11,"index","","",13,null],[11,"index_mut","","",13,null],[11,"get","","",18,null],[11,"get_mut","","",18,null],[11,"get_unchecked","","",18,null],[11,"get_unchecked_mut","","",18,null],[11,"index","","",18,null],[11,"index_mut","","",18,null],[11,"get","","",15,null],[11,"get_mut","","",15,null],[11,"get_unchecked","","",15,null],[11,"get_unchecked_mut","","",15,null],[11,"index","","",15,null],[11,"index_mut","","",15,null],[11,"get","","",16,null],[11,"get_mut","","",16,null],[11,"get_unchecked","","",16,null],[11,"get_unchecked_mut","","",16,null],[11,"index","","",16,null],[11,"index_mut","","",16,null],[11,"fmt","core::slice","",145,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"as_slice","","View the underlying data as a subslice of the original data.",145,null],[11,"next","","",145,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",145,null],[11,"count","","",145,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"nth","","",145,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",145,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"all","","",145,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"any","","",145,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"find","","",145,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"position","","",145,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"rposition","","",145,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"next_back","","",145,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"rfind","","",145,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"is_empty","","",145,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",145,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"as_ref","","",145,null],[11,"fmt","","",146,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"into_slice","","View the underlying data as a subslice of the original data.",146,null],[11,"next","","",146,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",146,null],[11,"count","","",146,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"nth","","",146,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",146,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"all","","",146,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"any","","",146,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"find","","",146,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"position","","",146,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"rposition","","",146,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"next_back","","",146,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"rfind","","",146,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"is_empty","","",146,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"fmt","","",147,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",147,{"inputs":[{"name":"self"}],"output":{"name":"split"}}],[11,"next","","",147,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",147,null],[11,"next_back","","",147,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",148,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",148,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",148,null],[11,"next_back","","",148,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",149,{"inputs":[{"name":"self"}],"output":{"name":"rsplit"}}],[11,"fmt","","",149,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",149,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",149,null],[11,"next_back","","",149,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",150,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",150,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",150,null],[11,"next_back","","",150,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",151,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",152,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",153,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",154,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",151,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",151,null],[11,"next","","",152,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",152,null],[11,"next","","",153,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",153,null],[11,"next","","",154,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",154,null],[11,"fmt","","",155,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",155,{"inputs":[{"name":"self"}],"output":{"name":"windows"}}],[11,"next","","",155,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",155,null],[11,"count","","",155,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"nth","","",155,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",155,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",155,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",156,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",156,{"inputs":[{"name":"self"}],"output":{"name":"chunks"}}],[11,"next","","",156,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",156,null],[11,"count","","",156,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"nth","","",156,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",156,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",156,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",157,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",157,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",157,null],[11,"count","","",157,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"nth","","",157,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",157,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",157,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[0,"str","core","String manipulation",null,null],[3,"ParseBoolError","core::str","An error returned when parsing a `bool` using [`from_str`] fails",null,null],[3,"Utf8Error","","Errors which can occur when attempting to interpret a sequence of [`u8`] as a string.",null,null],[3,"Chars","","An iterator over the [`char`]s of a string slice.",null,null],[3,"CharIndices","","An iterator over the [`char`]s of a string slice, and their positions.",null,null],[3,"Bytes","","An iterator over the bytes of a string slice.",null,null],[3,"Split","","Created with the method [`split`].",null,null],[3,"RSplit","","Created with the method [`rsplit`].",null,null],[3,"SplitTerminator","","Created with the method [`split_terminator`].",null,null],[3,"RSplitTerminator","","Created with the method [`rsplit_terminator`].",null,null],[3,"SplitN","","Created with the method [`splitn`].",null,null],[3,"RSplitN","","Created with the method [`rsplitn`].",null,null],[3,"MatchIndices","","Created with the method [`match_indices`].",null,null],[3,"RMatchIndices","","Created with the method [`rmatch_indices`].",null,null],[3,"Matches","","Created with the method [`matches`].",null,null],[3,"RMatches","","Created with the method [`rmatches`].",null,null],[3,"Lines","","An iterator over the lines of a string, as string slices.",null,null],[3,"LinesAny","","Created with the method [`lines_any`].",null,null],[5,"from_utf8","","Converts a slice of bytes to a string slice.",null,null],[5,"from_utf8_mut","","Converts a mutable slice of bytes to a mutable string slice.",null,null],[5,"from_utf8_unchecked","","Converts a slice of bytes to a string slice without checking that the string contains valid UTF-8.",null,null],[5,"from_utf8_unchecked_mut","","Converts a slice of bytes to a string slice without checking that the string contains valid UTF-8; mutable version.",null,null],[5,"next_code_point","","Reads the next code point out of a byte iterator (assuming a UTF-8-like encoding).",null,{"inputs":[{"name":"i"}],"output":{"name":"option"}}],[5,"utf8_char_width","","Given a first byte, determines how many bytes are in this UTF-8 character.",null,{"inputs":[{"name":"u8"}],"output":{"name":"usize"}}],[0,"pattern","","The string Pattern API.",null,null],[3,"CharSearcher","core::str::pattern","Associated type for `<char as Pattern<'a>>::Searcher`.",null,null],[3,"CharSliceSearcher","","Associated type for `<&[char] as Pattern<'a>>::Searcher`.",null,null],[3,"CharPredicateSearcher","","Associated type for `<F as Pattern<'a>>::Searcher`.",null,null],[3,"StrSearcher","","Associated type for `<&str as Pattern<'a>>::Searcher`.",null,null],[4,"SearchStep","","Result of calling `Searcher::next()` or `ReverseSearcher::next_back()`.",null,null],[13,"Match","","Expresses that a match of the pattern has been found at `haystack[a..b]`.",158,null],[13,"Reject","","Expresses that `haystack[a..b]` has been rejected as a possible match of the pattern.",158,null],[13,"Done","","Expresses that every byte of the haystack has been visited, ending the iteration.",158,null],[8,"Pattern","","A string pattern.",null,null],[16,"Searcher","","Associated searcher for this pattern",159,null],[10,"into_searcher","","Constructs the associated searcher from `self` and the `haystack` to search in.",159,null],[11,"is_contained_in","","Checks whether the pattern matches anywhere in the haystack",159,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"is_prefix_of","","Checks whether the pattern matches at the front of the haystack",159,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"is_suffix_of","","Checks whether the pattern matches at the back of the haystack",159,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[8,"Searcher","","A searcher for a string pattern.",null,null],[10,"haystack","","Getter for the underlying string to be searched in",160,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[10,"next","","Performs the next search step starting from the front.",160,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match","","Find the next `Match` result. See `next()`",160,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject","","Find the next `Reject` result. See `next()`",160,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[8,"ReverseSearcher","","A reverse searcher for a string pattern.",null,null],[10,"next_back","","Performs the next search step starting from the back.",161,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match_back","","Find the next `Match` result. See `next_back()`",161,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject_back","","Find the next `Reject` result. See `next_back()`",161,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[8,"DoubleEndedSearcher","","A marker trait to express that a `ReverseSearcher` can be used for a `DoubleEndedIterator` implementation.",null,null],[11,"clone","","",158,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"eq","","",158,{"inputs":[{"name":"self"},{"name":"searchstep"}],"output":{"name":"bool"}}],[11,"ne","","",158,{"inputs":[{"name":"self"},{"name":"searchstep"}],"output":{"name":"bool"}}],[11,"fmt","","",158,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",162,{"inputs":[{"name":"self"}],"output":{"name":"charsearcher"}}],[11,"fmt","","",162,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"haystack","","",162,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"next","","",162,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match","","",162,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject","","",162,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",162,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match_back","","",162,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject_back","","",162,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",163,{"inputs":[{"name":"self"}],"output":{"name":"charslicesearcher"}}],[11,"fmt","","",163,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"haystack","","",163,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"next","","",163,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match","","",163,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject","","",163,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",163,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match_back","","",163,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject_back","","",163,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",164,{"inputs":[{"name":"self"}],"output":{"name":"charpredicatesearcher"}}],[11,"fmt","","",164,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"haystack","","",164,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"next","","",164,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match","","",164,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject","","",164,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",164,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match_back","","",164,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject_back","","",164,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",165,{"inputs":[{"name":"self"}],"output":{"name":"strsearcher"}}],[11,"fmt","","",165,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"haystack","","",165,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"next","","",165,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match","","",165,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",165,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match_back","","",165,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"get","core::ops","",18,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"option"}}],[11,"get_mut","","",18,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"option"}}],[11,"get_unchecked","","",18,null],[11,"get_unchecked_mut","","",18,null],[11,"index","","",18,null],[11,"index_mut","","",18,null],[11,"get","","",12,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"option"}}],[11,"get_mut","","",12,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"option"}}],[11,"get_unchecked","","",12,null],[11,"get_unchecked_mut","","",12,null],[11,"index","","",12,null],[11,"index_mut","","",12,null],[11,"get","","",14,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"option"}}],[11,"get_mut","","",14,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"option"}}],[11,"get_unchecked","","",14,null],[11,"get_unchecked_mut","","",14,null],[11,"index","","",14,null],[11,"index_mut","","",14,null],[11,"get","","",13,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"option"}}],[11,"get_mut","","",13,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"option"}}],[11,"get_unchecked","","",13,null],[11,"get_unchecked_mut","","",13,null],[11,"index","","",13,null],[11,"index_mut","","",13,null],[11,"get","","",15,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"option"}}],[11,"get_mut","","",15,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"option"}}],[11,"get_unchecked","","",15,null],[11,"get_unchecked_mut","","",15,null],[11,"index","","",15,null],[11,"index_mut","","",15,null],[11,"get","","",16,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"option"}}],[11,"get_mut","","",16,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"option"}}],[11,"get_unchecked","","",16,null],[11,"get_unchecked_mut","","",16,null],[11,"index","","",16,null],[11,"index_mut","","",16,null],[8,"FromStr","core::str","A trait to abstract the idea of creating a new instance of a type from a string.",null,null],[16,"Err","","The associated error which can be returned from parsing.",166,null],[10,"from_str","","Parses a string `s` to return a value of this type.",166,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"fmt","","",167,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",167,{"inputs":[{"name":"self"}],"output":{"name":"parseboolerror"}}],[11,"eq","","",167,{"inputs":[{"name":"self"},{"name":"parseboolerror"}],"output":{"name":"bool"}}],[11,"ne","","",167,{"inputs":[{"name":"self"},{"name":"parseboolerror"}],"output":{"name":"bool"}}],[11,"fmt","","",167,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",168,{"inputs":[{"name":"self"},{"name":"utf8error"}],"output":{"name":"bool"}}],[11,"ne","","",168,{"inputs":[{"name":"self"},{"name":"utf8error"}],"output":{"name":"bool"}}],[11,"clone","","",168,{"inputs":[{"name":"self"}],"output":{"name":"utf8error"}}],[11,"fmt","","",168,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"valid_up_to","","Returns the index in the given string up to which valid UTF-8 was verified.",168,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"error_len","","Provide more information about the failure:",168,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",168,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",169,{"inputs":[{"name":"self"}],"output":{"name":"chars"}}],[11,"fmt","","",169,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",169,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"count","","",169,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"size_hint","","",169,null],[11,"last","","",169,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",169,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"as_str","","View the underlying data as a subslice of the original data.",169,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"clone","","",170,{"inputs":[{"name":"self"}],"output":{"name":"charindices"}}],[11,"fmt","","",170,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",170,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"count","","",170,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"size_hint","","",170,null],[11,"last","","",170,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",170,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"as_str","","View the underlying data as a subslice of the original data.",170,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"clone","","",171,{"inputs":[{"name":"self"}],"output":{"name":"bytes"}}],[11,"fmt","","",171,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",171,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",171,null],[11,"count","","",171,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"last","","",171,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"nth","","",171,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"all","","",171,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"any","","",171,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"find","","",171,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"option"}}],[11,"position","","",171,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"option"}}],[11,"rposition","","",171,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"option"}}],[11,"next_back","","",171,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"rfind","","",171,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"option"}}],[11,"len","","",171,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","",171,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"fmt","","",172,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",172,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",172,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"fmt","","",173,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",173,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",173,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"next_back","","",172,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",173,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",174,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",174,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",174,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"fmt","","",175,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",175,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",175,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"next_back","","",174,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",175,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",176,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",176,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",176,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"fmt","","",177,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",177,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",177,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"fmt","","",178,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",178,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",178,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"fmt","","",179,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",179,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",179,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"next_back","","",178,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",179,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",180,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",180,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",180,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"fmt","","",181,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",181,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",181,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"next_back","","",180,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",181,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",182,{"inputs":[{"name":"self"}],"output":{"name":"lines"}}],[11,"fmt","","",182,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",182,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",182,null],[11,"next_back","","",182,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",183,{"inputs":[{"name":"self"}],"output":{"name":"linesany"}}],[11,"fmt","","",183,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",183,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",183,null],[11,"next_back","","",183,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[0,"hash","core","Generic hashing support.",null,null],[3,"SipHasher","core::hash","An implementation of SipHash 2-4.",null,null],[3,"SipHasher13","","An implementation of SipHash 1-3.",null,null],[3,"SipHasher24","","An implementation of SipHash 2-4.",null,null],[3,"BuildHasherDefault","","Used to create a default [`BuildHasher`] instance for types that implement [`Hasher`] and [`Default`].",null,null],[11,"fmt","","",184,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",184,{"inputs":[{"name":"self"}],"output":{"name":"siphasher13"}}],[11,"default","","",184,{"inputs":[],"output":{"name":"siphasher13"}}],[11,"fmt","","",185,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",185,{"inputs":[{"name":"self"}],"output":{"name":"siphasher24"}}],[11,"default","","",185,{"inputs":[],"output":{"name":"siphasher24"}}],[11,"fmt","","",186,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",186,{"inputs":[{"name":"self"}],"output":{"name":"siphasher"}}],[11,"default","","",186,{"inputs":[],"output":{"name":"siphasher"}}],[11,"new","","Creates a new `SipHasher` with the two initial keys set to 0.",186,{"inputs":[],"output":{"name":"siphasher"}}],[11,"new_with_keys","","Creates a `SipHasher` that is keyed off the provided keys.",186,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"siphasher"}}],[11,"new","","Creates a new `SipHasher13` with the two initial keys set to 0.",184,{"inputs":[],"output":{"name":"siphasher13"}}],[11,"new_with_keys","","Creates a `SipHasher13` that is keyed off the provided keys.",184,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"siphasher13"}}],[11,"new","","Creates a new `SipHasher24` with the two initial keys set to 0.",185,{"inputs":[],"output":{"name":"siphasher24"}}],[11,"new_with_keys","","Creates a `SipHasher24` that is keyed off the provided keys.",185,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"siphasher24"}}],[11,"write","","",186,null],[11,"finish","","",186,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"write","","",184,null],[11,"finish","","",184,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"write","","",185,null],[11,"finish","","",185,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[8,"Hash","","A hashable type.",null,null],[10,"hash","","Feeds this value into the given [`Hasher`].",187,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"hash_slice","","Feeds a slice of this type into the given [`Hasher`].",187,null],[8,"Hasher","","A trait for hashing an arbitrary stream of bytes.",null,null],[10,"finish","","Returns the hash value for the values written so far.",188,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[10,"write","","Writes some data into this `Hasher`.",188,null],[11,"write_u8","","Writes a single `u8` into this hasher.",188,{"inputs":[{"name":"self"},{"name":"u8"}],"output":null}],[11,"write_u16","","Writes a single `u16` into this hasher.",188,{"inputs":[{"name":"self"},{"name":"u16"}],"output":null}],[11,"write_u32","","Writes a single `u32` into this hasher.",188,{"inputs":[{"name":"self"},{"name":"u32"}],"output":null}],[11,"write_u64","","Writes a single `u64` into this hasher.",188,{"inputs":[{"name":"self"},{"name":"u64"}],"output":null}],[11,"write_u128","","Writes a single `u128` into this hasher.",188,{"inputs":[{"name":"self"},{"name":"u128"}],"output":null}],[11,"write_usize","","Writes a single `usize` into this hasher.",188,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"write_i8","","Writes a single `i8` into this hasher.",188,{"inputs":[{"name":"self"},{"name":"i8"}],"output":null}],[11,"write_i16","","Writes a single `i16` into this hasher.",188,{"inputs":[{"name":"self"},{"name":"i16"}],"output":null}],[11,"write_i32","","Writes a single `i32` into this hasher.",188,{"inputs":[{"name":"self"},{"name":"i32"}],"output":null}],[11,"write_i64","","Writes a single `i64` into this hasher.",188,{"inputs":[{"name":"self"},{"name":"i64"}],"output":null}],[11,"write_i128","","Writes a single `i128` into this hasher.",188,{"inputs":[{"name":"self"},{"name":"i128"}],"output":null}],[11,"write_isize","","Writes a single `isize` into this hasher.",188,{"inputs":[{"name":"self"},{"name":"isize"}],"output":null}],[8,"BuildHasher","","A trait for creating instances of [`Hasher`].",null,null],[16,"Hasher","","Type of the hasher that will be created.",189,null],[10,"build_hasher","","Creates a new hasher.",189,null],[11,"fmt","","",190,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"build_hasher","","",190,{"inputs":[{"name":"self"}],"output":{"name":"h"}}],[11,"clone","","",190,{"inputs":[{"name":"self"}],"output":{"name":"buildhasherdefault"}}],[11,"default","","",190,{"inputs":[],"output":{"name":"buildhasherdefault"}}],[0,"fmt","core","Utilities for formatting and printing strings.",null,null],[3,"DebugStruct","core::fmt","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugTuple","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugSet","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugList","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugMap","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"Error","","The error type which is returned from formatting a message into a stream.",null,null],[3,"Formatter","","A struct to represent both where to emit formatting strings to and how they should be formatted. A mutable version of this is passed to all formatting traits.",null,null],[3,"Arguments","","This structure represents a safely precompiled version of a format string and its arguments. This cannot be generated at runtime because it cannot safely be done, so no constructors are given and the fields are private to prevent modification.",null,null],[4,"Alignment","","Possible alignments returned by `Formatter::align`",null,null],[13,"Left","","Indication that contents should be left-aligned.",191,null],[13,"Right","","Indication that contents should be right-aligned.",191,null],[13,"Center","","Indication that contents should be center-aligned.",191,null],[13,"Unknown","","No alignment was requested.",191,null],[5,"write","","The `write` function takes an output stream, and an `Arguments` struct that can be precompiled with the `format_args!` macro.",null,{"inputs":[{"name":"write"},{"name":"arguments"}],"output":{"name":"result"}}],[11,"field","","Adds a new field to the generated struct output.",192,{"inputs":[{"name":"self"},{"name":"str"},{"name":"debug"}],"output":{"name":"debugstruct"}}],[11,"finish","","Finishes output and returns any error encountered.",192,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"field","","Adds a new field to the generated tuple struct output.",193,{"inputs":[{"name":"self"},{"name":"debug"}],"output":{"name":"debugtuple"}}],[11,"finish","","Finishes output and returns any error encountered.",193,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"entry","","Adds a new entry to the set output.",194,{"inputs":[{"name":"self"},{"name":"debug"}],"output":{"name":"debugset"}}],[11,"entries","","Adds the contents of an iterator of entries to the set output.",194,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"debugset"}}],[11,"finish","","Finishes output and returns any error encountered.",194,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"entry","","Adds a new entry to the list output.",195,{"inputs":[{"name":"self"},{"name":"debug"}],"output":{"name":"debuglist"}}],[11,"entries","","Adds the contents of an iterator of entries to the list output.",195,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"debuglist"}}],[11,"finish","","Finishes output and returns any error encountered.",195,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"entry","","Adds a new entry to the map output.",196,{"inputs":[{"name":"self"},{"name":"debug"},{"name":"debug"}],"output":{"name":"debugmap"}}],[11,"entries","","Adds the contents of an iterator of entries to the map output.",196,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"debugmap"}}],[11,"finish","","Finishes output and returns any error encountered.",196,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[6,"Result","","The type returned by formatter methods.",null,null],[8,"Write","","A collection of methods that are required to format a message into a stream.",null,null],[10,"write_str","","Writes a slice of bytes into this writer, returning whether the write succeeded.",197,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"result"}}],[11,"write_char","","Writes a [`char`] into this writer, returning whether the write succeeded.",197,{"inputs":[{"name":"self"},{"name":"char"}],"output":{"name":"result"}}],[11,"write_fmt","","Glue for usage of the [`write!`] macro with implementors of this trait.",197,{"inputs":[{"name":"self"},{"name":"arguments"}],"output":{"name":"result"}}],[8,"Debug","","`?` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",198,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"Display","","Format trait for an empty format, `{}`.",null,null],[10,"fmt","","Formats the value using the given formatter.",199,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"Octal","","`o` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",200,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"Binary","","`b` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",201,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"LowerHex","","`x` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",202,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"UpperHex","","`X` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",203,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"Pointer","","`p` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",204,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"LowerExp","","`e` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",205,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"UpperExp","","`E` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",206,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",191,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",207,{"inputs":[{"name":"self"}],"output":{"name":"error"}}],[11,"fmt","","",207,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"default","","",207,{"inputs":[],"output":{"name":"error"}}],[11,"hash","","",207,null],[11,"cmp","","",207,{"inputs":[{"name":"self"},{"name":"error"}],"output":{"name":"ordering"}}],[11,"eq","","",207,{"inputs":[{"name":"self"},{"name":"error"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",207,{"inputs":[{"name":"self"},{"name":"error"}],"output":{"name":"option"}}],[11,"clone","","",208,{"inputs":[{"name":"self"}],"output":{"name":"arguments"}}],[11,"fmt","","",208,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",208,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"pad_integral","","Performs the correct padding for an integer which has already been emitted into a str. The str should not contain the sign for the integer, that will be added by this method.",209,{"inputs":[{"name":"self"},{"name":"bool"},{"name":"str"},{"name":"str"}],"output":{"name":"result"}}],[11,"pad","","This function takes a string slice and emits it to the internal buffer after applying the relevant formatting flags specified. The flags recognized for generic strings are:",209,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"result"}}],[11,"write_str","","Writes some data to the underlying buffer contained within this formatter.",209,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"result"}}],[11,"write_fmt","","Writes some formatted information into this instance",209,{"inputs":[{"name":"self"},{"name":"arguments"}],"output":{"name":"result"}}],[11,"flags","","Flags for formatting",209,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"fill","","Character used as 'fill' whenever there is alignment",209,{"inputs":[{"name":"self"}],"output":{"name":"char"}}],[11,"align","","Flag indicating what form of alignment was requested",209,{"inputs":[{"name":"self"}],"output":{"name":"alignment"}}],[11,"width","","Optionally specified integer width that the output should be",209,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"precision","","Optionally specified precision for numeric types",209,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"sign_plus","","Determines if the `+` flag was specified.",209,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"sign_minus","","Determines if the `-` flag was specified.",209,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"alternate","","Determines if the `#` flag was specified.",209,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"sign_aware_zero_pad","","Determines if the `0` flag was specified.",209,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"debug_struct","","Creates a [`DebugStruct`] builder designed to assist with creation of [`fmt::Debug`] implementations for structs.",209,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"debugstruct"}}],[11,"debug_tuple","","Creates a `DebugTuple` builder designed to assist with creation of `fmt::Debug` implementations for tuple structs.",209,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"debugtuple"}}],[11,"debug_list","","Creates a `DebugList` builder designed to assist with creation of `fmt::Debug` implementations for list-like structures.",209,{"inputs":[{"name":"self"}],"output":{"name":"debuglist"}}],[11,"debug_set","","Creates a `DebugSet` builder designed to assist with creation of `fmt::Debug` implementations for set-like structures.",209,{"inputs":[{"name":"self"}],"output":{"name":"debugset"}}],[11,"debug_map","","Creates a `DebugMap` builder designed to assist with creation of `fmt::Debug` implementations for map-like structures.",209,{"inputs":[{"name":"self"}],"output":{"name":"debugmap"}}],[11,"write_str","","",209,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"result"}}],[11,"write_char","","",209,{"inputs":[{"name":"self"},{"name":"char"}],"output":{"name":"result"}}],[11,"write_fmt","","",209,{"inputs":[{"name":"self"},{"name":"arguments"}],"output":{"name":"result"}}],[11,"fmt","","",207,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","core::marker","",11,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","core::cell","",88,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",91,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",92,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",93,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",94,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[14,"panic","core","Entry point of thread panic, for details, see std::macros",null,null],[14,"assert","","Ensure that a boolean expression is `true` at runtime.",null,null],[14,"assert_eq","","Asserts that two expressions are equal to each other (using [`PartialEq`]).",null,null],[14,"assert_ne","","Asserts that two expressions are not equal to each other (using [`PartialEq`]).",null,null],[14,"debug_assert","","Ensure that a boolean expression is `true` at runtime.",null,null],[14,"debug_assert_eq","","Asserts that two expressions are equal to each other.",null,null],[14,"debug_assert_ne","","Asserts that two expressions are not equal to each other.",null,null],[14,"try","","Helper macro for reducing boilerplate code for matching `Result` together with converting downstream errors.",null,null],[14,"write","","Write formatted data into a buffer",null,null],[14,"writeln","","Write formatted data into a buffer, with a newline appended.",null,null],[14,"unreachable","","A utility macro for indicating unreachable code.",null,null],[14,"unimplemented","","A standardized placeholder for marking unfinished code.",null,null],[14,"compile_error","","Unconditionally causes compilation to fail with the given error message when encountered.",null,null],[14,"format_args","","The core macro for formatted string creation & output.",null,null],[14,"env","","Inspect an environment variable at compile time.",null,null],[14,"option_env","","Optionally inspect an environment variable at compile time.",null,null],[14,"concat_idents","","Concatenate identifiers into one identifier.",null,null],[14,"concat","","Concatenates literals into a static string slice.",null,null],[14,"line","","A macro which expands to the line number on which it was invoked.",null,null],[14,"column","","A macro which expands to the column number on which it was invoked.",null,null],[14,"file","","A macro which expands to the file name from which it was invoked.",null,null],[14,"stringify","","A macro which stringifies its argument.",null,null],[14,"include_str","","Includes a utf8-encoded file as a string.",null,null],[14,"include_bytes","","Includes a file as a reference to a byte array.",null,null],[14,"module_path","","Expands to a string that represents the current module path.",null,null],[14,"cfg","","Boolean evaluation of configuration flags.",null,null],[14,"include","","Parse a file as an expression or an item according to the context.",null,null],[11,"size_hint","core::iter","Returns the bounds on the remaining length of the iterator.",105,null],[11,"count","","Consumes the iterator, counting the number of iterations and returning it.",105,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"last","","Consumes the iterator, returning the last element.",105,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"nth","","Returns the `n`th element of the iterator.",105,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"step_by","","Creates an iterator starting at the same point, but stepping by the given amount at each iteration.",105,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"stepby"}}],[11,"chain","","Takes two iterators and creates a new iterator over both in sequence.",105,{"inputs":[{"name":"self"},{"name":"u"}],"output":{"name":"chain"}}],[11,"zip","","'Zips up' two iterators into a single iterator of pairs.",105,{"inputs":[{"name":"self"},{"name":"u"}],"output":{"name":"zip"}}],[11,"map","","Takes a closure and creates an iterator which calls that closure on each element.",105,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"map"}}],[11,"for_each","","Calls a closure on each element of an iterator.",105,{"inputs":[{"name":"self"},{"name":"f"}],"output":null}],[11,"filter","","Creates an iterator which uses a closure to determine if an element should be yielded.",105,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"filter"}}],[11,"filter_map","","Creates an iterator that both filters and maps.",105,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"filtermap"}}],[11,"enumerate","","Creates an iterator which gives the current iteration count as well as the next value.",105,{"inputs":[{"name":"self"}],"output":{"name":"enumerate"}}],[11,"peekable","","Creates an iterator which can use `peek` to look at the next element of the iterator without consuming it.",105,{"inputs":[{"name":"self"}],"output":{"name":"peekable"}}],[11,"skip_while","","Creates an iterator that [`skip`]s elements based on a predicate.",105,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"skipwhile"}}],[11,"take_while","","Creates an iterator that yields elements based on a predicate.",105,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"takewhile"}}],[11,"skip","","Creates an iterator that skips the first `n` elements.",105,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"skip"}}],[11,"take","","Creates an iterator that yields its first `n` elements.",105,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"take"}}],[11,"scan","","An iterator adaptor similar to [`fold`] that holds internal state and produces a new iterator.",105,{"inputs":[{"name":"self"},{"name":"st"},{"name":"f"}],"output":{"name":"scan"}}],[11,"flat_map","","Creates an iterator that works like map, but flattens nested structure.",105,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"flatmap"}}],[11,"fuse","","Creates an iterator which ends after the first [`None`].",105,{"inputs":[{"name":"self"}],"output":{"name":"fuse"}}],[11,"inspect","","Do something with each element of an iterator, passing the value on.",105,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"inspect"}}],[11,"by_ref","","Borrows an iterator, rather than consuming it.",105,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"collect","","Transforms an iterator into a collection.",105,{"inputs":[{"name":"self"}],"output":{"name":"b"}}],[11,"partition","","Consumes an iterator, creating two collections from it.",105,null],[11,"fold","","An iterator method that applies a function, producing a single, final value.",105,{"inputs":[{"name":"self"},{"name":"b"},{"name":"f"}],"output":{"name":"b"}}],[11,"all","","Tests if every element of the iterator matches a predicate.",105,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"any","","Tests if any element of the iterator matches a predicate.",105,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"find","","Searches for an element of an iterator that satisfies a predicate.",105,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"option"}}],[11,"position","","Searches for an element in an iterator, returning its index.",105,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"option"}}],[11,"rposition","","Searches for an element in an iterator from the right, returning its index.",105,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"option"}}],[11,"max","","Returns the maximum element of an iterator.",105,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"min","","Returns the minimum element of an iterator.",105,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"max_by_key","","Returns the element that gives the maximum value from the specified function.",105,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"max_by","","Returns the element that gives the maximum value with respect to the specified comparison function.",105,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"min_by_key","","Returns the element that gives the minimum value from the specified function.",105,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"min_by","","Returns the element that gives the minimum value with respect to the specified comparison function.",105,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"rev","","Reverses an iterator's direction.",105,{"inputs":[{"name":"self"}],"output":{"name":"rev"}}],[11,"unzip","","Converts an iterator of pairs into a pair of containers.",105,null],[11,"cloned","","Creates an iterator which [`clone`]s all of its elements.",105,{"inputs":[{"name":"self"}],"output":{"name":"cloned"}}],[11,"cycle","","Repeats an iterator endlessly.",105,{"inputs":[{"name":"self"}],"output":{"name":"cycle"}}],[11,"sum","","Sums the elements of an iterator.",105,{"inputs":[{"name":"self"}],"output":{"name":"s"}}],[11,"product","","Iterates over the entire iterator, multiplying all the elements",105,{"inputs":[{"name":"self"}],"output":{"name":"p"}}],[11,"cmp","","Lexicographically compares the elements of this `Iterator` with those of another.",105,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","Lexicographically compares the elements of this `Iterator` with those of another.",105,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"option"}}],[11,"eq","","Determines if the elements of this `Iterator` are equal to those of another.",105,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"bool"}}],[11,"ne","","Determines if the elements of this `Iterator` are unequal to those of another.",105,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"bool"}}],[11,"lt","","Determines if the elements of this `Iterator` are lexicographically less than those of another.",105,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"bool"}}],[11,"le","","Determines if the elements of this `Iterator` are lexicographically less or equal to those of another.",105,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"bool"}}],[11,"gt","","Determines if the elements of this `Iterator` are lexicographically greater than those of another.",105,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"bool"}}],[11,"ge","","Determines if the elements of this `Iterator` are lexicographically greater than or equal to those of another.",105,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"bool"}}],[11,"rfold","","An iterator method that reduces the iterator's elements to a single, final value, starting from the back.",109,{"inputs":[{"name":"self"},{"name":"b"},{"name":"f"}],"output":{"name":"b"}}],[11,"rfind","","Searches for an element of an iterator from the right that satisfies a predicate.",109,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"option"}}],[11,"len","","Returns the exact number of times the iterator will iterate.",111,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","Returns whether the iterator is empty.",111,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"sum","core::result","Takes each element in the `Iterator`: if it is an `Err`, no further elements are taken, and the `Err` is returned. Should no `Err` occur, the sum of all elements is returned.",139,{"inputs":[{"name":"i"}],"output":{"name":"result"}}],[11,"product","","Takes each element in the `Iterator`: if it is an `Err`, no further elements are taken, and the `Err` is returned. Should no `Err` occur, the product of all elements is returned.",139,{"inputs":[{"name":"i"}],"output":{"name":"result"}}]],"paths":[[3,"Wrapping"],[4,"FpCategory"],[3,"ParseFloatError"],[3,"TryFromIntError"],[3,"ParseIntError"],[3,"Discriminant"],[19,"ManuallyDrop"],[8,"Zeroable"],[3,"NonZero"],[3,"Unique"],[3,"Shared"],[3,"PhantomData"],[3,"Range"],[3,"RangeFrom"],[3,"RangeTo"],[3,"RangeInclusive"],[3,"RangeToInclusive"],[4,"GeneratorState"],[3,"RangeFull"],[8,"Add"],[8,"Sub"],[8,"Mul"],[8,"Div"],[8,"Rem"],[8,"Neg"],[8,"AddAssign"],[8,"SubAssign"],[8,"MulAssign"],[8,"DivAssign"],[8,"RemAssign"],[8,"Not"],[8,"BitAnd"],[8,"BitOr"],[8,"BitXor"],[8,"Shl"],[8,"Shr"],[8,"BitAndAssign"],[8,"BitOrAssign"],[8,"BitXorAssign"],[8,"ShlAssign"],[8,"ShrAssign"],[8,"Deref"],[8,"DerefMut"],[8,"Drop"],[8,"Fn"],[8,"FnMut"],[8,"FnOnce"],[8,"Index"],[8,"IndexMut"],[8,"Try"],[8,"Generator"],[8,"Place"],[8,"Placer"],[8,"InPlace"],[8,"Boxed"],[8,"BoxPlace"],[3,"Reverse"],[4,"Ordering"],[8,"PartialEq"],[8,"Ord"],[8,"PartialOrd"],[8,"Clone"],[8,"Default"],[8,"AsRef"],[8,"AsMut"],[8,"Into"],[8,"From"],[8,"TryInto"],[8,"TryFrom"],[4,"Infallible"],[8,"Borrow"],[8,"BorrowMut"],[8,"Any"],[3,"TypeId"],[8,"FixedSizeArray"],[4,"Ordering"],[3,"AtomicBool"],[3,"AtomicPtr"],[3,"AtomicI8"],[3,"AtomicU8"],[3,"AtomicI16"],[3,"AtomicU16"],[3,"AtomicI32"],[3,"AtomicU32"],[3,"AtomicI64"],[3,"AtomicU64"],[3,"AtomicIsize"],[3,"AtomicUsize"],[3,"Cell"],[3,"BorrowError"],[3,"BorrowMutError"],[3,"RefCell"],[3,"Ref"],[3,"RefMut"],[3,"UnsafeCell"],[3,"ParseCharError"],[3,"CharTryFromError"],[3,"EscapeUnicode"],[3,"EscapeDefault"],[3,"EscapeDebug"],[3,"DecodeUtf8"],[3,"InvalidSequence"],[3,"Repeat"],[3,"Empty"],[3,"Once"],[8,"Iterator"],[8,"Step"],[8,"FromIterator"],[8,"IntoIterator"],[8,"DoubleEndedIterator"],[8,"Extend"],[8,"ExactSizeIterator"],[8,"Sum"],[8,"Product"],[3,"Rev"],[3,"Cloned"],[3,"Cycle"],[3,"StepBy"],[3,"Chain"],[3,"Zip"],[3,"Map"],[3,"Filter"],[3,"FilterMap"],[3,"Enumerate"],[3,"Peekable"],[3,"SkipWhile"],[3,"TakeWhile"],[3,"Skip"],[3,"Take"],[3,"Scan"],[3,"FlatMap"],[3,"Fuse"],[3,"Inspect"],[4,"Option"],[3,"Iter"],[3,"IterMut"],[3,"IntoIter"],[3,"NoneError"],[3,"TraitObject"],[4,"Result"],[3,"Iter"],[3,"IterMut"],[3,"IntoIter"],[8,"SliceExt"],[8,"SliceIndex"],[3,"Iter"],[3,"IterMut"],[3,"Split"],[3,"SplitMut"],[3,"RSplit"],[3,"RSplitMut"],[3,"SplitN"],[3,"RSplitN"],[3,"SplitNMut"],[3,"RSplitNMut"],[3,"Windows"],[3,"Chunks"],[3,"ChunksMut"],[4,"SearchStep"],[8,"Pattern"],[8,"Searcher"],[8,"ReverseSearcher"],[3,"CharSearcher"],[3,"CharSliceSearcher"],[3,"CharPredicateSearcher"],[3,"StrSearcher"],[8,"FromStr"],[3,"ParseBoolError"],[3,"Utf8Error"],[3,"Chars"],[3,"CharIndices"],[3,"Bytes"],[3,"Split"],[3,"RSplit"],[3,"SplitTerminator"],[3,"RSplitTerminator"],[3,"SplitN"],[3,"RSplitN"],[3,"MatchIndices"],[3,"RMatchIndices"],[3,"Matches"],[3,"RMatches"],[3,"Lines"],[3,"LinesAny"],[3,"SipHasher13"],[3,"SipHasher24"],[3,"SipHasher"],[8,"Hash"],[8,"Hasher"],[8,"BuildHasher"],[3,"BuildHasherDefault"],[4,"Alignment"],[3,"DebugStruct"],[3,"DebugTuple"],[3,"DebugSet"],[3,"DebugList"],[3,"DebugMap"],[8,"Write"],[8,"Debug"],[8,"Display"],[8,"Octal"],[8,"Binary"],[8,"LowerHex"],[8,"UpperHex"],[8,"Pointer"],[8,"LowerExp"],[8,"UpperExp"],[3,"Error"],[3,"Arguments"],[3,"Formatter"]]};
searchIndex["std"] = {"doc":"The Rust Standard Library","items":[[0,"any","std","This module implements the `Any` trait, which enables dynamic typing of any `'static` type through runtime reflection.",null,null],[8,"Any","std::any","A type to emulate dynamic typing.",null,null],[10,"get_type_id","","Gets the `TypeId` of `self`.",0,{"inputs":[{"name":"self"}],"output":{"name":"typeid"}}],[3,"TypeId","","A `TypeId` represents a globally unique identifier for a type.",null,null],[0,"cell","std","Shareable mutable containers.",null,null],[3,"Cell","std::cell","A mutable memory location.",null,null],[3,"RefCell","","A mutable memory location with dynamically checked borrow rules",null,null],[3,"BorrowError","","An error returned by `RefCell::try_borrow`.",null,null],[3,"BorrowMutError","","An error returned by `RefCell::try_borrow_mut`.",null,null],[3,"Ref","","Wraps a borrowed reference to a value in a `RefCell` box. A wrapper type for an immutably borrowed value from a `RefCell<T>`.",null,null],[3,"RefMut","","A wrapper type for a mutably borrowed value from a `RefCell<T>`.",null,null],[3,"UnsafeCell","","The core primitive for interior mutability in Rust.",null,null],[0,"clone","std","The `Clone` trait for types that cannot be 'implicitly copied'.",null,null],[8,"Clone","std::clone","A common trait for the ability to explicitly duplicate an object.",null,null],[10,"clone","","Returns a copy of the value.",1,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"clone_from","","Performs copy-assignment from `source`.",1,null],[0,"cmp","std","Functionality for ordering and comparison.",null,null],[8,"PartialEq","std::cmp","Trait for equality comparisons which are partial equivalence relations.",null,null],[10,"eq","","This method tests for `self` and `other` values to be equal, and is used by `==`.",2,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":{"name":"bool"}}],[11,"ne","","This method tests for `!=`.",2,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":{"name":"bool"}}],[8,"Eq","","Trait for equality comparisons which are equivalence relations.",null,null],[4,"Ordering","","An `Ordering` is the result of a comparison between two values.",null,null],[13,"Less","","An ordering where a compared value is less [than another].",3,null],[13,"Equal","","An ordering where a compared value is equal [to another].",3,null],[13,"Greater","","An ordering where a compared value is greater [than another].",3,null],[3,"Reverse","","A helper struct for reverse ordering.",null,null],[12,"0","","",4,null],[8,"Ord","","Trait for types that form a total order.",null,null],[10,"cmp","","This method returns an `Ordering` between `self` and `other`.",5,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"ordering"}}],[11,"max","","Compares and returns the maximum of two values.",5,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"self"}}],[11,"min","","Compares and returns the minimum of two values.",5,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"self"}}],[8,"PartialOrd","","Trait for values that can be compared for a sort-order.",null,null],[10,"partial_cmp","","This method returns an ordering between `self` and `other` values if one exists.",6,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":{"name":"option"}}],[11,"lt","","This method tests less than (for `self` and `other`) and is used by the `<` operator.",6,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":{"name":"bool"}}],[11,"le","","This method tests less than or equal to (for `self` and `other`) and is used by the `<=` operator.",6,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":{"name":"bool"}}],[11,"gt","","This method tests greater than (for `self` and `other`) and is used by the `>` operator.",6,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":{"name":"bool"}}],[11,"ge","","This method tests greater than or equal to (for `self` and `other`) and is used by the `>=` operator.",6,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":{"name":"bool"}}],[5,"min","","Compares and returns the minimum of two values.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"max","","Compares and returns the maximum of two values.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[0,"convert","std","Traits for conversions between types.",null,null],[4,"Infallible","std::convert","A type used as the error type for implementations of fallible conversion traits in cases where conversions cannot actually fail.",null,null],[8,"AsRef","","A cheap reference-to-reference conversion. Used to convert a value to a reference value within generic code.",null,null],[10,"as_ref","","Performs the conversion.",7,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[8,"AsMut","","A cheap, mutable reference-to-mutable reference conversion.",null,null],[10,"as_mut","","Performs the conversion.",8,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[8,"Into","","A conversion that consumes `self`, which may or may not be expensive. The reciprocal of [`From`][From].",null,null],[10,"into","","Performs the conversion.",9,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[8,"From","","Simple and safe type conversions in to `Self`. It is the reciprocal of `Into`.",null,null],[10,"from","","Performs the conversion.",10,{"inputs":[{"name":"t"}],"output":{"name":"self"}}],[8,"TryInto","","An attempted conversion that consumes `self`, which may or may not be expensive.",null,null],[16,"Error","","The type returned in the event of a conversion error.",11,null],[10,"try_into","","Performs the conversion.",11,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[8,"TryFrom","","Attempt to construct `Self` via a conversion.",null,null],[16,"Error","","The type returned in the event of a conversion error.",12,null],[10,"try_from","","Performs the conversion.",12,{"inputs":[{"name":"t"}],"output":{"name":"result"}}],[0,"default","std","The `Default` trait for types which may have meaningful default values.",null,null],[8,"Default","std::default","A trait for giving a type a useful default value.",null,null],[10,"default","","Returns the \"default value\" for a type.",13,{"inputs":[],"output":{"name":"self"}}],[0,"hash","std","Generic hashing support.",null,null],[8,"Hash","std::hash","A hashable type.",null,null],[10,"hash","","Feeds this value into the given [`Hasher`].",14,null],[11,"hash_slice","","Feeds a slice of this type into the given [`Hasher`].",14,null],[8,"Hasher","","A trait for hashing an arbitrary stream of bytes.",null,null],[10,"finish","","Returns the hash value for the values written so far.",15,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[10,"write","","Writes some data into this `Hasher`.",15,null],[11,"write_u8","","Writes a single `u8` into this hasher.",15,null],[11,"write_u16","","Writes a single `u16` into this hasher.",15,null],[11,"write_u32","","Writes a single `u32` into this hasher.",15,null],[11,"write_u64","","Writes a single `u64` into this hasher.",15,null],[11,"write_u128","","Writes a single `u128` into this hasher.",15,null],[11,"write_usize","","Writes a single `usize` into this hasher.",15,null],[11,"write_i8","","Writes a single `i8` into this hasher.",15,null],[11,"write_i16","","Writes a single `i16` into this hasher.",15,null],[11,"write_i32","","Writes a single `i32` into this hasher.",15,null],[11,"write_i64","","Writes a single `i64` into this hasher.",15,null],[11,"write_i128","","Writes a single `i128` into this hasher.",15,null],[11,"write_isize","","Writes a single `isize` into this hasher.",15,null],[8,"BuildHasher","","A trait for creating instances of [`Hasher`].",null,null],[16,"Hasher","","Type of the hasher that will be created.",16,null],[10,"build_hasher","","Creates a new hasher.",16,null],[3,"BuildHasherDefault","","Used to create a default [`BuildHasher`] instance for types that implement [`Hasher`] and [`Default`].",null,null],[3,"SipHasher","","An implementation of SipHash 2-4.",null,null],[3,"SipHasher13","","An implementation of SipHash 1-3.",null,null],[3,"SipHasher24","","An implementation of SipHash 2-4.",null,null],[0,"intrinsics","std","rustc compiler intrinsics.",null,null],[5,"atomic_cxchg","std::intrinsics","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::SeqCst` as both the `success` and `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",null,null],[5,"atomic_cxchg_acq","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::Acquire` as both the `success` and `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",null,null],[5,"atomic_cxchg_rel","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::Release` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",null,null],[5,"atomic_cxchg_acqrel","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::AcqRel` as the `success` and `Ordering::Acquire` as the `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",null,null],[5,"atomic_cxchg_relaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::Relaxed` as both the `success` and `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",null,null],[5,"atomic_cxchg_failrelaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::SeqCst` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",null,null],[5,"atomic_cxchg_failacq","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::SeqCst` as the `success` and `Ordering::Acquire` as the `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",null,null],[5,"atomic_cxchg_acq_failrelaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::Acquire` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",null,null],[5,"atomic_cxchg_acqrel_failrelaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::AcqRel` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",null,null],[5,"atomic_cxchgweak","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::SeqCst` as both the `success` and `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",null,null],[5,"atomic_cxchgweak_acq","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::Acquire` as both the `success` and `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",null,null],[5,"atomic_cxchgweak_rel","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::Release` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",null,null],[5,"atomic_cxchgweak_acqrel","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::AcqRel` as the `success` and `Ordering::Acquire` as the `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",null,null],[5,"atomic_cxchgweak_relaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::Relaxed` as both the `success` and `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",null,null],[5,"atomic_cxchgweak_failrelaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::SeqCst` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",null,null],[5,"atomic_cxchgweak_failacq","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::SeqCst` as the `success` and `Ordering::Acquire` as the `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",null,null],[5,"atomic_cxchgweak_acq_failrelaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::Acquire` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",null,null],[5,"atomic_cxchgweak_acqrel_failrelaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::AcqRel` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",null,null],[5,"atomic_load","","Loads the current value of the pointer. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `load` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::load`.",null,null],[5,"atomic_load_acq","","Loads the current value of the pointer. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `load` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicBool::load`.",null,null],[5,"atomic_load_relaxed","","Loads the current value of the pointer. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `load` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::load`.",null,null],[5,"atomic_load_unordered","","",null,null],[5,"atomic_store","","Stores the value at the specified memory location. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `store` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::store`.",null,null],[5,"atomic_store_rel","","Stores the value at the specified memory location. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `store` method by passing `Ordering::Release` as the `order`. For example, `AtomicBool::store`.",null,null],[5,"atomic_store_relaxed","","Stores the value at the specified memory location. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `store` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::store`.",null,null],[5,"atomic_store_unordered","","",null,null],[5,"atomic_xchg","","Stores the value at the specified memory location, returning the old value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `swap` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::swap`.",null,null],[5,"atomic_xchg_acq","","Stores the value at the specified memory location, returning the old value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `swap` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicBool::swap`.",null,null],[5,"atomic_xchg_rel","","Stores the value at the specified memory location, returning the old value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `swap` method by passing `Ordering::Release` as the `order`. For example, `AtomicBool::swap`.",null,null],[5,"atomic_xchg_acqrel","","Stores the value at the specified memory location, returning the old value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `swap` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicBool::swap`.",null,null],[5,"atomic_xchg_relaxed","","Stores the value at the specified memory location, returning the old value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `swap` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::swap`.",null,null],[5,"atomic_xadd","","Add to the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_add` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicIsize::fetch_add`.",null,null],[5,"atomic_xadd_acq","","Add to the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_add` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicIsize::fetch_add`.",null,null],[5,"atomic_xadd_rel","","Add to the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_add` method by passing `Ordering::Release` as the `order`. For example, `AtomicIsize::fetch_add`.",null,null],[5,"atomic_xadd_acqrel","","Add to the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_add` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicIsize::fetch_add`.",null,null],[5,"atomic_xadd_relaxed","","Add to the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_add` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicIsize::fetch_add`.",null,null],[5,"atomic_xsub","","Subtract from the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_sub` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicIsize::fetch_sub`.",null,null],[5,"atomic_xsub_acq","","Subtract from the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_sub` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicIsize::fetch_sub`.",null,null],[5,"atomic_xsub_rel","","Subtract from the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_sub` method by passing `Ordering::Release` as the `order`. For example, `AtomicIsize::fetch_sub`.",null,null],[5,"atomic_xsub_acqrel","","Subtract from the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_sub` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicIsize::fetch_sub`.",null,null],[5,"atomic_xsub_relaxed","","Subtract from the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_sub` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicIsize::fetch_sub`.",null,null],[5,"atomic_and","","Bitwise and with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_and` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::fetch_and`.",null,null],[5,"atomic_and_acq","","Bitwise and with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_and` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicBool::fetch_and`.",null,null],[5,"atomic_and_rel","","Bitwise and with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_and` method by passing `Ordering::Release` as the `order`. For example, `AtomicBool::fetch_and`.",null,null],[5,"atomic_and_acqrel","","Bitwise and with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_and` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicBool::fetch_and`.",null,null],[5,"atomic_and_relaxed","","Bitwise and with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_and` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::fetch_and`.",null,null],[5,"atomic_nand","","Bitwise nand with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic::AtomicBool` type via the `fetch_nand` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::fetch_nand`.",null,null],[5,"atomic_nand_acq","","Bitwise nand with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic::AtomicBool` type via the `fetch_nand` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicBool::fetch_nand`.",null,null],[5,"atomic_nand_rel","","Bitwise nand with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic::AtomicBool` type via the `fetch_nand` method by passing `Ordering::Release` as the `order`. For example, `AtomicBool::fetch_nand`.",null,null],[5,"atomic_nand_acqrel","","Bitwise nand with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic::AtomicBool` type via the `fetch_nand` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicBool::fetch_nand`.",null,null],[5,"atomic_nand_relaxed","","Bitwise nand with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic::AtomicBool` type via the `fetch_nand` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::fetch_nand`.",null,null],[5,"atomic_or","","Bitwise or with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_or` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::fetch_or`.",null,null],[5,"atomic_or_acq","","Bitwise or with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_or` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicBool::fetch_or`.",null,null],[5,"atomic_or_rel","","Bitwise or with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_or` method by passing `Ordering::Release` as the `order`. For example, `AtomicBool::fetch_or`.",null,null],[5,"atomic_or_acqrel","","Bitwise or with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_or` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicBool::fetch_or`.",null,null],[5,"atomic_or_relaxed","","Bitwise or with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_or` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::fetch_or`.",null,null],[5,"atomic_xor","","Bitwise xor with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_xor` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::fetch_xor`.",null,null],[5,"atomic_xor_acq","","Bitwise xor with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_xor` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicBool::fetch_xor`.",null,null],[5,"atomic_xor_rel","","Bitwise xor with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_xor` method by passing `Ordering::Release` as the `order`. For example, `AtomicBool::fetch_xor`.",null,null],[5,"atomic_xor_acqrel","","Bitwise xor with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_xor` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicBool::fetch_xor`.",null,null],[5,"atomic_xor_relaxed","","Bitwise xor with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_xor` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::fetch_xor`.",null,null],[5,"atomic_max","","",null,null],[5,"atomic_max_acq","","",null,null],[5,"atomic_max_rel","","",null,null],[5,"atomic_max_acqrel","","",null,null],[5,"atomic_max_relaxed","","",null,null],[5,"atomic_min","","",null,null],[5,"atomic_min_acq","","",null,null],[5,"atomic_min_rel","","",null,null],[5,"atomic_min_acqrel","","",null,null],[5,"atomic_min_relaxed","","",null,null],[5,"atomic_umin","","",null,null],[5,"atomic_umin_acq","","",null,null],[5,"atomic_umin_rel","","",null,null],[5,"atomic_umin_acqrel","","",null,null],[5,"atomic_umin_relaxed","","",null,null],[5,"atomic_umax","","",null,null],[5,"atomic_umax_acq","","",null,null],[5,"atomic_umax_rel","","",null,null],[5,"atomic_umax_acqrel","","",null,null],[5,"atomic_umax_relaxed","","",null,null],[5,"prefetch_read_data","","The `prefetch` intrinsic is a hint to the code generator to insert a prefetch instruction if supported; otherwise, it is a noop. Prefetches have no effect on the behavior of the program but can change its performance characteristics.",null,null],[5,"prefetch_write_data","","The `prefetch` intrinsic is a hint to the code generator to insert a prefetch instruction if supported; otherwise, it is a noop. Prefetches have no effect on the behavior of the program but can change its performance characteristics.",null,null],[5,"prefetch_read_instruction","","The `prefetch` intrinsic is a hint to the code generator to insert a prefetch instruction if supported; otherwise, it is a noop. Prefetches have no effect on the behavior of the program but can change its performance characteristics.",null,null],[5,"prefetch_write_instruction","","The `prefetch` intrinsic is a hint to the code generator to insert a prefetch instruction if supported; otherwise, it is a noop. Prefetches have no effect on the behavior of the program but can change its performance characteristics.",null,null],[5,"atomic_fence","","",null,null],[5,"atomic_fence_acq","","",null,null],[5,"atomic_fence_rel","","",null,null],[5,"atomic_fence_acqrel","","",null,null],[5,"atomic_singlethreadfence","","A compiler-only memory barrier.",null,null],[5,"atomic_singlethreadfence_acq","","",null,null],[5,"atomic_singlethreadfence_rel","","",null,null],[5,"atomic_singlethreadfence_acqrel","","",null,null],[5,"rustc_peek","","Magic intrinsic that derives its meaning from attributes attached to the function.",null,{"inputs":[{"name":"t"}],"output":{"name":"t"}}],[5,"abort","","Aborts the execution of the process.",null,null],[5,"unreachable","","Tells LLVM that this point in the code is not reachable, enabling further optimizations.",null,null],[5,"assume","","Informs the optimizer that a condition is always true. If the condition is false, the behavior is undefined.",null,null],[5,"likely","","Hints to the compiler that branch condition is likely to be true. Returns the value passed to it.",null,{"inputs":[{"name":"bool"}],"output":{"name":"bool"}}],[5,"unlikely","","Hints to the compiler that branch condition is likely to be false. Returns the value passed to it.",null,{"inputs":[{"name":"bool"}],"output":{"name":"bool"}}],[5,"breakpoint","","Executes a breakpoint trap, for inspection by a debugger.",null,null],[5,"size_of","","The size of a type in bytes.",null,{"inputs":[],"output":{"name":"usize"}}],[5,"move_val_init","","Moves a value to an uninitialized memory location.",null,null],[5,"min_align_of","","",null,{"inputs":[],"output":{"name":"usize"}}],[5,"pref_align_of","","",null,{"inputs":[],"output":{"name":"usize"}}],[5,"size_of_val","","",null,{"inputs":[{"name":"t"}],"output":{"name":"usize"}}],[5,"min_align_of_val","","",null,{"inputs":[{"name":"t"}],"output":{"name":"usize"}}],[5,"type_name","","Gets a static string slice containing the name of a type.",null,{"inputs":[],"output":{"name":"str"}}],[5,"type_id","","Gets an identifier which is globally unique to the specified type. This function will return the same value for a type regardless of whichever crate it is invoked in.",null,{"inputs":[],"output":{"name":"u64"}}],[5,"init","","Creates a value initialized to zero.",null,{"inputs":[],"output":{"name":"t"}}],[5,"uninit","","Creates an uninitialized value.",null,{"inputs":[],"output":{"name":"t"}}],[5,"transmute","","Reinterprets the bits of a value of one type as another type.",null,{"inputs":[{"name":"t"}],"output":{"name":"u"}}],[5,"needs_drop","","Returns `true` if the actual type given as `T` requires drop glue; returns `false` if the actual type provided for `T` implements `Copy`.",null,{"inputs":[],"output":{"name":"bool"}}],[5,"offset","","Calculates the offset from a pointer.",null,null],[5,"arith_offset","","Calculates the offset from a pointer, potentially wrapping.",null,null],[5,"copy_nonoverlapping","","Copies `count * size_of<T>` bytes from `src` to `dst`. The source and destination may not overlap.",null,null],[5,"copy","","Copies `count * size_of<T>` bytes from `src` to `dst`. The source and destination may overlap.",null,null],[5,"write_bytes","","Invokes memset on the specified pointer, setting `count * size_of::<T>()` bytes of memory starting at `dst` to `val`.",null,null],[5,"volatile_copy_nonoverlapping_memory","","Equivalent to the appropriate `llvm.memcpy.p0i8.0i8.*` intrinsic, with a size of `count` * `size_of::<T>()` and an alignment of `min_align_of::<T>()`",null,null],[5,"volatile_copy_memory","","Equivalent to the appropriate `llvm.memmove.p0i8.0i8.*` intrinsic, with a size of `count` * `size_of::<T>()` and an alignment of `min_align_of::<T>()`",null,null],[5,"volatile_set_memory","","Equivalent to the appropriate `llvm.memset.p0i8.*` intrinsic, with a size of `count` * `size_of::<T>()` and an alignment of `min_align_of::<T>()`.",null,null],[5,"volatile_load","","Perform a volatile load from the `src` pointer. The stabilized version of this intrinsic is `std::ptr::read_volatile`.",null,null],[5,"volatile_store","","Perform a volatile store to the `dst` pointer. The stabilized version of this intrinsic is `std::ptr::write_volatile`.",null,null],[5,"sqrtf32","","Returns the square root of an `f32`",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"sqrtf64","","Returns the square root of an `f64`",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"powif32","","Raises an `f32` to an integer power.",null,{"inputs":[{"name":"f32"},{"name":"i32"}],"output":{"name":"f32"}}],[5,"powif64","","Raises an `f64` to an integer power.",null,{"inputs":[{"name":"f64"},{"name":"i32"}],"output":{"name":"f64"}}],[5,"sinf32","","Returns the sine of an `f32`.",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"sinf64","","Returns the sine of an `f64`.",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"cosf32","","Returns the cosine of an `f32`.",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"cosf64","","Returns the cosine of an `f64`.",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"powf32","","Raises an `f32` to an `f32` power.",null,{"inputs":[{"name":"f32"},{"name":"f32"}],"output":{"name":"f32"}}],[5,"powf64","","Raises an `f64` to an `f64` power.",null,{"inputs":[{"name":"f64"},{"name":"f64"}],"output":{"name":"f64"}}],[5,"expf32","","Returns the exponential of an `f32`.",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"expf64","","Returns the exponential of an `f64`.",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"exp2f32","","Returns 2 raised to the power of an `f32`.",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"exp2f64","","Returns 2 raised to the power of an `f64`.",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"logf32","","Returns the natural logarithm of an `f32`.",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"logf64","","Returns the natural logarithm of an `f64`.",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"log10f32","","Returns the base 10 logarithm of an `f32`.",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"log10f64","","Returns the base 10 logarithm of an `f64`.",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"log2f32","","Returns the base 2 logarithm of an `f32`.",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"log2f64","","Returns the base 2 logarithm of an `f64`.",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"fmaf32","","Returns `a * b + c` for `f32` values.",null,{"inputs":[{"name":"f32"},{"name":"f32"},{"name":"f32"}],"output":{"name":"f32"}}],[5,"fmaf64","","Returns `a * b + c` for `f64` values.",null,{"inputs":[{"name":"f64"},{"name":"f64"},{"name":"f64"}],"output":{"name":"f64"}}],[5,"fabsf32","","Returns the absolute value of an `f32`.",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"fabsf64","","Returns the absolute value of an `f64`.",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"copysignf32","","Copies the sign from `y` to `x` for `f32` values.",null,{"inputs":[{"name":"f32"},{"name":"f32"}],"output":{"name":"f32"}}],[5,"copysignf64","","Copies the sign from `y` to `x` for `f64` values.",null,{"inputs":[{"name":"f64"},{"name":"f64"}],"output":{"name":"f64"}}],[5,"floorf32","","Returns the largest integer less than or equal to an `f32`.",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"floorf64","","Returns the largest integer less than or equal to an `f64`.",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"ceilf32","","Returns the smallest integer greater than or equal to an `f32`.",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"ceilf64","","Returns the smallest integer greater than or equal to an `f64`.",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"truncf32","","Returns the integer part of an `f32`.",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"truncf64","","Returns the integer part of an `f64`.",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"rintf32","","Returns the nearest integer to an `f32`. May raise an inexact floating-point exception if the argument is not an integer.",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"rintf64","","Returns the nearest integer to an `f64`. May raise an inexact floating-point exception if the argument is not an integer.",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"nearbyintf32","","Returns the nearest integer to an `f32`.",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"nearbyintf64","","Returns the nearest integer to an `f64`.",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"roundf32","","Returns the nearest integer to an `f32`. Rounds half-way cases away from zero.",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"roundf64","","Returns the nearest integer to an `f64`. Rounds half-way cases away from zero.",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"fadd_fast","","Float addition that allows optimizations based on algebraic rules. May assume inputs are finite.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"fsub_fast","","Float subtraction that allows optimizations based on algebraic rules. May assume inputs are finite.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"fmul_fast","","Float multiplication that allows optimizations based on algebraic rules. May assume inputs are finite.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"fdiv_fast","","Float division that allows optimizations based on algebraic rules. May assume inputs are finite.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"frem_fast","","Float remainder that allows optimizations based on algebraic rules. May assume inputs are finite.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"ctpop","","Returns the number of bits set in an integer type `T`",null,{"inputs":[{"name":"t"}],"output":{"name":"t"}}],[5,"ctlz","","Returns the number of leading unset bits (zeroes) in an integer type `T`.",null,{"inputs":[{"name":"t"}],"output":{"name":"t"}}],[5,"ctlz_nonzero","","Like `ctlz`, but extra-unsafe as it returns `undef` when given an `x` with value `0`.",null,{"inputs":[{"name":"t"}],"output":{"name":"t"}}],[5,"cttz","","Returns the number of trailing unset bits (zeroes) in an integer type `T`.",null,{"inputs":[{"name":"t"}],"output":{"name":"t"}}],[5,"cttz_nonzero","","Like `cttz`, but extra-unsafe as it returns `undef` when given an `x` with value `0`.",null,{"inputs":[{"name":"t"}],"output":{"name":"t"}}],[5,"bswap","","Reverses the bytes in an integer type `T`.",null,{"inputs":[{"name":"t"}],"output":{"name":"t"}}],[5,"add_with_overflow","","Performs checked integer addition. The stabilized versions of this intrinsic are available on the integer primitives via the `overflowing_add` method. For example, `std::u32::overflowing_add`",null,null],[5,"sub_with_overflow","","Performs checked integer subtraction The stabilized versions of this intrinsic are available on the integer primitives via the `overflowing_sub` method. For example, `std::u32::overflowing_sub`",null,null],[5,"mul_with_overflow","","Performs checked integer multiplication The stabilized versions of this intrinsic are available on the integer primitives via the `overflowing_mul` method. For example, `std::u32::overflowing_mul`",null,null],[5,"unchecked_div","","Performs an unchecked division, resulting in undefined behavior where y = 0 or x = `T::min_value()` and y = -1",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"unchecked_rem","","Returns the remainder of an unchecked division, resulting in undefined behavior where y = 0 or x = `T::min_value()` and y = -1",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"unchecked_shl","","Performs an unchecked left shift, resulting in undefined behavior when y < 0 or y >= N, where N is the width of T in bits.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"unchecked_shr","","Performs an unchecked right shift, resulting in undefined behavior when y < 0 or y >= N, where N is the width of T in bits.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"overflowing_add","","Returns (a + b) mod 2N, where N is the width of T in bits. The stabilized versions of this intrinsic are available on the integer primitives via the `wrapping_add` method. For example, `std::u32::wrapping_add`",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"overflowing_sub","","Returns (a - b) mod 2N, where N is the width of T in bits. The stabilized versions of this intrinsic are available on the integer primitives via the `wrapping_sub` method. For example, `std::u32::wrapping_sub`",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"overflowing_mul","","Returns (a * b) mod 2N, where N is the width of T in bits. The stabilized versions of this intrinsic are available on the integer primitives via the `wrapping_mul` method. For example, `std::u32::wrapping_mul`",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"discriminant_value","","Returns the value of the discriminant for the variant in 'v', cast to a `u64`; if `T` has no discriminant, returns 0.",null,{"inputs":[{"name":"t"}],"output":{"name":"u64"}}],[5,"try","","Rust's \"try catch\" construct which invokes the function pointer `f` with the data pointer `data`.",null,null],[5,"align_offset","","Computes the byte offset that needs to be applied to `ptr` in order to make it aligned to `align`. If it is not possible to align `ptr`, the implementation returns `usize::max_value()`.",null,null],[5,"drop_in_place","","Executes the destructor (if any) of the pointed-to value.",null,null],[0,"iter","std","Composable external iteration.",null,null],[3,"Rev","std::iter","A double-ended iterator with the direction inverted.",null,null],[3,"Cloned","","An iterator that clones the elements of an underlying iterator.",null,null],[3,"Cycle","","An iterator that repeats endlessly.",null,null],[3,"StepBy","","An iterator for stepping iterators by a custom amount.",null,null],[3,"Chain","","An iterator that strings two iterators together.",null,null],[3,"Zip","","An iterator that iterates two other iterators simultaneously.",null,null],[3,"Map","","An iterator that maps the values of `iter` with `f`.",null,null],[3,"Filter","","An iterator that filters the elements of `iter` with `predicate`.",null,null],[3,"FilterMap","","An iterator that uses `f` to both filter and map elements from `iter`.",null,null],[3,"Enumerate","","An iterator that yields the current count and the element during iteration.",null,null],[3,"Peekable","","An iterator with a `peek()` that returns an optional reference to the next element.",null,null],[3,"SkipWhile","","An iterator that rejects elements while `predicate` is true.",null,null],[3,"TakeWhile","","An iterator that only accepts elements while `predicate` is true.",null,null],[3,"Skip","","An iterator that skips over `n` elements of `iter`.",null,null],[3,"Take","","An iterator that only iterates over the first `n` iterations of `iter`.",null,null],[3,"Scan","","An iterator to maintain state while iterating another iterator.",null,null],[3,"FlatMap","","An iterator that maps each element to an iterator, and yields the elements of the produced iterators.",null,null],[3,"Fuse","","An iterator that yields `None` forever after the underlying iterator yields `None` once.",null,null],[3,"Inspect","","An iterator that calls a function with a reference to each element before yielding it.",null,null],[8,"ExactSizeIterator","","An iterator that knows its exact length.",null,null],[11,"len","","Returns the exact number of times the iterator will iterate.",17,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","Returns whether the iterator is empty.",17,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[5,"repeat","","Creates a new iterator that endlessly repeats a single element.",null,{"inputs":[{"name":"t"}],"output":{"name":"repeat"}}],[8,"Product","","Trait to represent types that can be created by multiplying elements of an iterator.",null,null],[10,"product","","Method which takes an iterator and generates `Self` from the elements by multiplying the items.",18,{"inputs":[{"name":"i"}],"output":{"name":"self"}}],[8,"DoubleEndedIterator","","An iterator able to yield elements from both ends.",null,null],[10,"next_back","","Removes and returns an element from the end of the iterator.",19,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"rfold","","An iterator method that reduces the iterator's elements to a single, final value, starting from the back.",19,{"inputs":[{"name":"self"},{"name":"b"},{"name":"f"}],"output":{"name":"b"}}],[11,"rfind","","Searches for an element of an iterator from the right that satisfies a predicate.",19,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"option"}}],[8,"Extend","","Extend a collection with the contents of an iterator.",null,null],[10,"extend","","Extends a collection with the contents of an iterator.",20,null],[3,"Repeat","","An iterator that repeats an element endlessly.",null,null],[5,"once","","Creates an iterator that yields an element exactly once.",null,{"inputs":[{"name":"t"}],"output":{"name":"once"}}],[3,"Once","","An iterator that yields an element exactly once.",null,null],[8,"FusedIterator","","An iterator that always continues to yield `None` when exhausted.",null,null],[8,"Iterator","","An interface for dealing with iterators.",null,null],[16,"Item","","The type of the elements being iterated over.",21,null],[10,"next","","Advances the iterator and returns the next value.",21,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","Returns the bounds on the remaining length of the iterator.",21,null],[11,"count","","Consumes the iterator, counting the number of iterations and returning it.",21,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"last","","Consumes the iterator, returning the last element.",21,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"nth","","Returns the `n`th element of the iterator.",21,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"step_by","","Creates an iterator starting at the same point, but stepping by the given amount at each iteration.",21,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"stepby"}}],[11,"chain","","Takes two iterators and creates a new iterator over both in sequence.",21,{"inputs":[{"name":"self"},{"name":"u"}],"output":{"name":"chain"}}],[11,"zip","","'Zips up' two iterators into a single iterator of pairs.",21,{"inputs":[{"name":"self"},{"name":"u"}],"output":{"name":"zip"}}],[11,"map","","Takes a closure and creates an iterator which calls that closure on each element.",21,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"map"}}],[11,"for_each","","Calls a closure on each element of an iterator.",21,null],[11,"filter","","Creates an iterator which uses a closure to determine if an element should be yielded.",21,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"filter"}}],[11,"filter_map","","Creates an iterator that both filters and maps.",21,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"filtermap"}}],[11,"enumerate","","Creates an iterator which gives the current iteration count as well as the next value.",21,{"inputs":[{"name":"self"}],"output":{"name":"enumerate"}}],[11,"peekable","","Creates an iterator which can use `peek` to look at the next element of the iterator without consuming it.",21,{"inputs":[{"name":"self"}],"output":{"name":"peekable"}}],[11,"skip_while","","Creates an iterator that [`skip`]s elements based on a predicate.",21,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"skipwhile"}}],[11,"take_while","","Creates an iterator that yields elements based on a predicate.",21,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"takewhile"}}],[11,"skip","","Creates an iterator that skips the first `n` elements.",21,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"skip"}}],[11,"take","","Creates an iterator that yields its first `n` elements.",21,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"take"}}],[11,"scan","","An iterator adaptor similar to [`fold`] that holds internal state and produces a new iterator.",21,{"inputs":[{"name":"self"},{"name":"st"},{"name":"f"}],"output":{"name":"scan"}}],[11,"flat_map","","Creates an iterator that works like map, but flattens nested structure.",21,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"flatmap"}}],[11,"fuse","","Creates an iterator which ends after the first [`None`].",21,{"inputs":[{"name":"self"}],"output":{"name":"fuse"}}],[11,"inspect","","Do something with each element of an iterator, passing the value on.",21,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"inspect"}}],[11,"by_ref","","Borrows an iterator, rather than consuming it.",21,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"collect","","Transforms an iterator into a collection.",21,{"inputs":[{"name":"self"}],"output":{"name":"b"}}],[11,"partition","","Consumes an iterator, creating two collections from it.",21,null],[11,"fold","","An iterator method that applies a function, producing a single, final value.",21,{"inputs":[{"name":"self"},{"name":"b"},{"name":"f"}],"output":{"name":"b"}}],[11,"all","","Tests if every element of the iterator matches a predicate.",21,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"any","","Tests if any element of the iterator matches a predicate.",21,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"find","","Searches for an element of an iterator that satisfies a predicate.",21,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"option"}}],[11,"position","","Searches for an element in an iterator, returning its index.",21,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"option"}}],[11,"rposition","","Searches for an element in an iterator from the right, returning its index.",21,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"option"}}],[11,"max","","Returns the maximum element of an iterator.",21,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"min","","Returns the minimum element of an iterator.",21,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"max_by_key","","Returns the element that gives the maximum value from the specified function.",21,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"max_by","","Returns the element that gives the maximum value with respect to the specified comparison function.",21,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"min_by_key","","Returns the element that gives the minimum value from the specified function.",21,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"min_by","","Returns the element that gives the minimum value with respect to the specified comparison function.",21,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"rev","","Reverses an iterator's direction.",21,{"inputs":[{"name":"self"}],"output":{"name":"rev"}}],[11,"unzip","","Converts an iterator of pairs into a pair of containers.",21,null],[11,"cloned","","Creates an iterator which [`clone`]s all of its elements.",21,{"inputs":[{"name":"self"}],"output":{"name":"cloned"}}],[11,"cycle","","Repeats an iterator endlessly.",21,{"inputs":[{"name":"self"}],"output":{"name":"cycle"}}],[11,"sum","","Sums the elements of an iterator.",21,{"inputs":[{"name":"self"}],"output":{"name":"s"}}],[11,"product","","Iterates over the entire iterator, multiplying all the elements",21,{"inputs":[{"name":"self"}],"output":{"name":"p"}}],[11,"cmp","","Lexicographically compares the elements of this `Iterator` with those of another.",21,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","Lexicographically compares the elements of this `Iterator` with those of another.",21,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"option"}}],[11,"eq","","Determines if the elements of this `Iterator` are equal to those of another.",21,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"bool"}}],[11,"ne","","Determines if the elements of this `Iterator` are unequal to those of another.",21,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"bool"}}],[11,"lt","","Determines if the elements of this `Iterator` are lexicographically less than those of another.",21,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"bool"}}],[11,"le","","Determines if the elements of this `Iterator` are lexicographically less or equal to those of another.",21,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"bool"}}],[11,"gt","","Determines if the elements of this `Iterator` are lexicographically greater than those of another.",21,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"bool"}}],[11,"ge","","Determines if the elements of this `Iterator` are lexicographically greater than or equal to those of another.",21,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"bool"}}],[8,"TrustedLen","","An iterator that reports an accurate length using size_hint.",null,null],[8,"Sum","","Trait to represent types that can be created by summing up an iterator.",null,null],[10,"sum","","Method which takes an iterator and generates `Self` from the elements by \"summing up\" the items.",22,{"inputs":[{"name":"i"}],"output":{"name":"self"}}],[3,"Empty","","An iterator that yields nothing.",null,null],[8,"FromIterator","","Conversion from an `Iterator`.",null,null],[10,"from_iter","","Creates a value from an iterator.",23,{"inputs":[{"name":"t"}],"output":{"name":"self"}}],[8,"IntoIterator","","Conversion into an `Iterator`.",null,null],[16,"Item","","The type of the elements being iterated over.",24,null],[16,"IntoIter","","Which kind of iterator are we turning this into?",24,null],[10,"into_iter","","Creates an iterator from a value.",24,null],[5,"empty","","Creates an iterator that yields nothing.",null,{"inputs":[],"output":{"name":"empty"}}],[8,"Step","","Objects that can be stepped over in both directions.",null,null],[10,"steps_between","","Returns the number of steps between two step objects. The count is inclusive of `start` and exclusive of `end`.",25,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"option"}}],[10,"replace_one","","Replaces this step with `1`, returning itself",25,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[10,"replace_zero","","Replaces this step with `0`, returning itself",25,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[10,"add_one","","Adds one to this step, returning the result",25,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[10,"sub_one","","Subtracts one to this step, returning the result",25,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[10,"add_usize","","Add an usize, returning None on overflow",25,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[0,"marker","std","Primitive traits and types representing basic properties of types.",null,null],[8,"Send","std::marker","Types that can be transferred across thread boundaries.",null,null],[8,"Sized","","Types with a constant size known at compile time.",null,null],[8,"Unsize","","Types that can be \"unsized\" to a dynamically-sized type.",null,null],[8,"Copy","","Types whose values can be duplicated simply by copying bits.",null,null],[8,"Sync","","Types for which it is safe to share references between threads.",null,null],[3,"PhantomData","","Zero-sized type used to mark things that \"act like\" they own a `T`.",null,null],[0,"mem","std","Basic functions for dealing with memory.",null,null],[5,"forget","std::mem","Leaks a value: takes ownership and \"forgets\" about the value without running its destructor.",null,null],[5,"size_of","","Returns the size of a type in bytes.",null,{"inputs":[],"output":{"name":"usize"}}],[5,"size_of_val","","Returns the size of the pointed-to value in bytes.",null,{"inputs":[{"name":"t"}],"output":{"name":"usize"}}],[5,"min_align_of","","Returns the [ABI]-required minimum alignment of a type.",null,{"inputs":[],"output":{"name":"usize"}}],[5,"min_align_of_val","","Returns the [ABI]-required minimum alignment of the type of the value that `val` points to.",null,{"inputs":[{"name":"t"}],"output":{"name":"usize"}}],[5,"align_of","","Returns the [ABI]-required minimum alignment of a type.",null,{"inputs":[],"output":{"name":"usize"}}],[5,"align_of_val","","Returns the [ABI]-required minimum alignment of the type of the value that `val` points to.",null,{"inputs":[{"name":"t"}],"output":{"name":"usize"}}],[5,"needs_drop","","Returns whether dropping values of type `T` matters.",null,{"inputs":[],"output":{"name":"bool"}}],[5,"zeroed","","Creates a value whose bytes are all zero.",null,{"inputs":[],"output":{"name":"t"}}],[5,"uninitialized","","Bypasses Rust's normal memory-initialization checks by pretending to produce a value of type `T`, while doing nothing at all.",null,{"inputs":[],"output":{"name":"t"}}],[5,"swap","","Swaps the values at two mutable locations, without deinitializing either one.",null,null],[5,"replace","","Replaces the value at a mutable location with a new one, returning the old value, without deinitializing either one.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"drop","","Disposes of a value.",null,null],[5,"transmute_copy","","Interprets `src` as having type `&U`, and then reads `src` without moving the contained value.",null,{"inputs":[{"name":"t"}],"output":{"name":"u"}}],[3,"Discriminant","","Opaque type representing the discriminant of an enum.",null,null],[5,"discriminant","","Returns a value uniquely identifying the enum variant in `v`.",null,{"inputs":[{"name":"t"}],"output":{"name":"discriminant"}}],[19,"ManuallyDrop","","A wrapper to inhibit compiler from automatically calling `T`’s destructor.",null,null],[5,"unreachable","","Tells LLVM that this point in the code is not reachable, enabling further optimizations.",null,null],[5,"transmute","","Reinterprets the bits of a value of one type as another type.",null,{"inputs":[{"name":"t"}],"output":{"name":"u"}}],[0,"ops","std","Overloadable operators.",null,null],[3,"RangeToInclusive","std::ops","A range only bounded inclusively above (`..=end`).",null,null],[12,"end","","The upper bound of the range (inclusive)",26,null],[8,"Neg","","The unary negation operator `-`.",null,null],[16,"Output","","The resulting type after applying the `-` operator.",27,null],[10,"neg","","Performs the unary `-` operation.",27,null],[8,"InPlace","","Specialization of `Place` trait supporting `PLACE <- EXPR`.",null,null],[16,"Owner","","`Owner` is the type of the end value of `PLACE <- EXPR`",28,null],[10,"finalize","","Converts self into the final value, shifting deallocation/cleanup responsibilities (if any remain), over to the returned instance of `Owner` and forgetting self.",28,null],[8,"DivAssign","","The division assignment operator `/=`.",null,null],[10,"div_assign","","Performs the `/=` operation.",29,null],[4,"GeneratorState","","The result of a generator resumption.",null,null],[13,"Yielded","","The generator suspended with a value.",30,null],[13,"Complete","","The generator completed with a return value.",30,null],[8,"BitAnd","","The bitwise AND operator `&`.",null,null],[16,"Output","","The resulting type after applying the `&` operator.",31,null],[10,"bitand","","Performs the `&` operation.",31,null],[8,"BitXor","","The bitwise XOR operator `^`.",null,null],[16,"Output","","The resulting type after applying the `^` operator.",32,null],[10,"bitxor","","Performs the `^` operation.",32,null],[3,"RangeInclusive","","An range bounded inclusively below and above (`start..=end`).",null,null],[12,"start","","The lower bound of the range (inclusive).",33,null],[12,"end","","The upper bound of the range (inclusive).",33,null],[8,"IndexMut","","Used for indexing operations (`container[index]`) in mutable contexts.",null,null],[10,"index_mut","","Performs the mutable indexing (`container[index]`) operation.",34,null],[8,"Placer","","Interface to implementations of  `PLACE <- EXPR`.",null,null],[16,"Place","","`Place` is the intermediate agent guarding the uninitialized state for `Data`.",35,null],[10,"make_place","","Creates a fresh place from `self`.",35,null],[8,"Add","","The addition operator `+`.",null,null],[16,"Output","","The resulting type after applying the `+` operator.",36,null],[10,"add","","Performs the `+` operation.",36,null],[8,"Rem","","The remainder operator `%`.",null,null],[16,"Output","","The resulting type after applying the `%` operator.",37,null],[10,"rem","","Performs the `%` operation.",37,null],[3,"RangeTo","","A range only bounded exclusively above (`..end`).",null,null],[12,"end","","The upper bound of the range (exclusive).",38,null],[8,"Generator","","The trait implemented by builtin generator types.",null,null],[16,"Yield","","The type of value this generator yields.",39,null],[16,"Return","","The type of value this generator returns.",39,null],[10,"resume","","Resumes the execution of this generator.",39,{"inputs":[{"name":"self"}],"output":{"name":"generatorstate"}}],[8,"AddAssign","","The addition assignment operator `+=`.",null,null],[10,"add_assign","","Performs the `+=` operation.",40,null],[8,"Not","","The unary logical negation operator `!`.",null,null],[16,"Output","","The resulting type after applying the `!` operator.",41,null],[10,"not","","Performs the unary `!` operation.",41,null],[8,"Try","","A trait for customizing the behavior of the `?` operator.",null,null],[16,"Ok","","The type of this value when viewed as successful.",42,null],[16,"Error","","The type of this value when viewed as failed.",42,null],[10,"into_result","","Applies the \"?\" operator. A return of `Ok(t)` means that the execution should continue normally, and the result of `?` is the value `t`. A return of `Err(e)` means that execution should branch to the innermost enclosing `catch`, or return from the function.",42,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[10,"from_error","","Wrap an error value to construct the composite result. For example, `Result::Err(x)` and `Result::from_error(x)` are equivalent.",42,null],[10,"from_ok","","Wrap an OK value to construct the composite result. For example, `Result::Ok(x)` and `Result::from_ok(x)` are equivalent.",42,null],[8,"Place","","Both `PLACE <- EXPR` and `box EXPR` desugar into expressions that allocate an intermediate \"place\" that holds uninitialized state.  The desugaring evaluates EXPR, and writes the result at the address returned by the `pointer` method of this trait.",null,null],[10,"pointer","","Returns the address where the input value will be written. Note that the data at this address is generally uninitialized, and thus one should use `ptr::write` for initializing it.",43,null],[8,"Index","","Used for indexing operations (`container[index]`) in immutable contexts.",null,null],[16,"Output","","The returned type after indexing.",44,null],[10,"index","","Performs the indexing (`container[index]`) operation.",44,null],[8,"SubAssign","","The subtraction assignment operator `-=`.",null,null],[10,"sub_assign","","Performs the `-=` operation.",45,null],[3,"RangeFull","","An unbounded range (`..`).",null,null],[8,"BitOrAssign","","The bitwise OR assignment operator `|=`.",null,null],[10,"bitor_assign","","Performs the `|=` operation.",46,null],[8,"BitAndAssign","","The bitwise AND assignment operator `&=`.",null,null],[10,"bitand_assign","","Performs the `&=` operation.",47,null],[8,"Div","","The division operator `/`.",null,null],[16,"Output","","The resulting type after applying the `/` operator.",48,null],[10,"div","","Performs the `/` operation.",48,null],[8,"BoxPlace","","Specialization of `Place` trait supporting `box EXPR`.",null,null],[10,"make_place","","Creates a globally fresh place.",49,{"inputs":[],"output":{"name":"self"}}],[8,"ShrAssign","","The right shift assignment operator `>>=`.",null,null],[10,"shr_assign","","Performs the `>>=` operation.",50,null],[8,"MulAssign","","The multiplication assignment operator `*=`.",null,null],[10,"mul_assign","","Performs the `*=` operation.",51,null],[3,"RangeFrom","","A range only bounded inclusively below (`start..`).",null,null],[12,"start","","The lower bound of the range (inclusive).",52,null],[8,"FnOnce","","The version of the call operator that takes a by-value receiver.",null,null],[16,"Output","","The returned type after the call operator is used.",53,null],[10,"call_once","","Performs the call operation.",53,null],[8,"Mul","","The multiplication operator `*`.",null,null],[16,"Output","","The resulting type after applying the `*` operator.",54,null],[10,"mul","","Performs the `*` operation.",54,null],[8,"DerefMut","","Used for mutable dereferencing operations, like in `*v = 1;`.",null,null],[10,"deref_mut","","Mutably dereferences the value.",55,null],[8,"BitXorAssign","","The bitwise XOR assignment operator `^=`.",null,null],[10,"bitxor_assign","","Performs the `^=` operation.",56,null],[8,"Boxed","","Core trait for the `box EXPR` form.",null,null],[16,"Data","","The kind of data that is stored in this kind of box.",57,null],[16,"Place","","The place that will negotiate the storage of the data.",57,null],[10,"finalize","","Converts filled place into final owning value, shifting deallocation/cleanup responsibilities (if any remain), over to returned instance of `Self` and forgetting `filled`.",57,null],[8,"CoerceUnsized","","Trait that indicates that this is a pointer or a wrapper for one, where unsizing can be performed on the pointee.",null,null],[8,"ShlAssign","","The left shift assignment operator `<<=`.",null,null],[10,"shl_assign","","Performs the `<<=` operation.",58,null],[8,"Shl","","The left shift operator `<<`.",null,null],[16,"Output","","The resulting type after applying the `<<` operator.",59,null],[10,"shl","","Performs the `<<` operation.",59,null],[8,"Fn","","The version of the call operator that takes an immutable receiver.",null,null],[10,"call","","Performs the call operation.",60,null],[8,"Drop","","Used to run some code when a value goes out of scope. This is sometimes called a 'destructor'.",null,null],[10,"drop","","Executes the destructor for this type.",61,null],[8,"Deref","","Used for immutable dereferencing operations, like `*v`.",null,null],[16,"Target","","The resulting type after dereferencing.",62,null],[10,"deref","","Dereferences the value.",62,null],[8,"Sub","","The subtraction operator `-`.",null,null],[16,"Output","","The resulting type after applying the `-` operator.",63,null],[10,"sub","","Performs the `-` operation.",63,null],[8,"FnMut","","The version of the call operator that takes a mutable receiver.",null,null],[10,"call_mut","","Performs the call operation.",64,null],[3,"Range","","A (half-open) range bounded inclusively below and exclusively above (`start..end`).",null,null],[12,"start","","The lower bound of the range (inclusive).",65,null],[12,"end","","The upper bound of the range (exclusive).",65,null],[8,"Shr","","The right shift operator `>>`.",null,null],[16,"Output","","The resulting type after applying the `>>` operator.",66,null],[10,"shr","","Performs the `>>` operation.",66,null],[8,"RemAssign","","The remainder assignment operator `%=`.",null,null],[10,"rem_assign","","Performs the `%=` operation.",67,null],[8,"BitOr","","The bitwise OR operator `|`.",null,null],[16,"Output","","The resulting type after applying the `|` operator.",68,null],[10,"bitor","","Performs the `|` operation.",68,null],[0,"ptr","std","Raw, unsafe pointers, `*const T`, and `*mut T`.",null,null],[5,"drop_in_place","std::ptr","Executes the destructor (if any) of the pointed-to value.",null,null],[5,"null","","Creates a null raw pointer.",null,null],[5,"null_mut","","Creates a null mutable raw pointer.",null,null],[5,"swap","","Swaps the values at two mutable locations of the same type, without deinitializing either. They may overlap, unlike `mem::swap` which is otherwise equivalent.",null,null],[5,"swap_nonoverlapping","","Swaps a sequence of values at two mutable locations of the same type.",null,null],[5,"replace","","Replaces the value at `dest` with `src`, returning the old value, without dropping either.",null,null],[5,"read","","Reads the value from `src` without moving it. This leaves the memory in `src` unchanged.",null,null],[5,"read_unaligned","","Reads the value from `src` without moving it. This leaves the memory in `src` unchanged.",null,null],[5,"write","","Overwrites a memory location with the given value without reading or dropping the old value.",null,null],[5,"write_unaligned","","Overwrites a memory location with the given value without reading or dropping the old value.",null,null],[5,"read_volatile","","Performs a volatile read of the value from `src` without moving it. This leaves the memory in `src` unchanged.",null,null],[5,"write_volatile","","Performs a volatile write of a memory location with the given value without reading or dropping the old value.",null,null],[5,"eq","","Compare raw pointers for equality.",null,null],[3,"Unique","","A wrapper around a raw non-null `*mut T` that indicates that the possessor of this wrapper owns the referent. Useful for building abstractions like `Box<T>`, `Vec<T>`, `String`, and `HashMap<K, V>`.",null,null],[3,"Shared","","A wrapper around a raw `*mut T` that indicates that the possessor of this wrapper has shared ownership of the referent. Useful for building abstractions like `Rc<T>`, `Arc<T>`, or doubly-linked lists, which internally use aliased raw pointers to manage the memory that they own.",null,null],[5,"write_bytes","","Invokes memset on the specified pointer, setting `count * size_of::<T>()` bytes of memory starting at `dst` to `val`.",null,null],[5,"copy","","Copies `count * size_of<T>` bytes from `src` to `dst`. The source and destination may overlap.",null,null],[5,"copy_nonoverlapping","","Copies `count * size_of<T>` bytes from `src` to `dst`. The source and destination may not overlap.",null,null],[0,"raw","std","Contains struct definitions for the layout of compiler built-in types.",null,null],[3,"TraitObject","std::raw","The representation of a trait object like `&SomeTrait`.",null,null],[12,"data","","",69,null],[12,"vtable","","",69,null],[0,"result","std","Error handling with the `Result` type.",null,null],[4,"Result","std::result","`Result` is a type that represents either success ([`Ok`]) or failure ([`Err`]).",null,null],[13,"Ok","","Contains the success value",70,null],[13,"Err","","Contains the error value",70,null],[3,"Iter","","An iterator over a reference to the [`Ok`] variant of a [`Result`].",null,null],[3,"IterMut","","An iterator over a mutable reference to the [`Ok`] variant of a [`Result`].",null,null],[3,"IntoIter","","An iterator over the value in a [`Ok`] variant of a [`Result`].",null,null],[0,"option","std","Optional values.",null,null],[4,"Option","std::option","The `Option` type. See the module level documentation for more.",null,null],[13,"None","","No value",71,null],[13,"Some","","Some value `T`",71,null],[3,"Iter","","An iterator over a reference to the [`Some`] variant of an [`Option`].",null,null],[3,"IterMut","","An iterator over a mutable reference to the [`Some`] variant of an [`Option`].",null,null],[3,"IntoIter","","An iterator over the value in [`Some`] variant of an [`Option`].",null,null],[3,"NoneError","","The error type that results from applying the try operator (`?`) to a `None` value. If you wish to allow `x?` (where `x` is an `Option<T>`) to be converted into your error type, you can implement `impl From<NoneError>` for `YourErrorType`. In that case, `x?` within a function that returns `Result<_, YourErrorType>` will translate a `None` value into an `Err` result.",null,null],[0,"isize","std","The pointer-sized signed integer type.",null,null],[17,"MIN","std::isize","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"i8","std","The 8-bit signed integer type.",null,null],[17,"MIN","std::i8","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"i16","std","The 16-bit signed integer type.",null,null],[17,"MIN","std::i16","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"i32","std","The 32-bit signed integer type.",null,null],[17,"MIN","std::i32","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"i64","std","The 64-bit signed integer type.",null,null],[17,"MIN","std::i64","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"i128","std","The 128-bit signed integer type.",null,null],[17,"MIN","std::i128","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"usize","std","The pointer-sized unsigned integer type.",null,null],[17,"MIN","std::usize","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"u8","std","The 8-bit unsigned integer type.",null,null],[17,"MIN","std::u8","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"u16","std","The 16-bit unsigned integer type.",null,null],[17,"MIN","std::u16","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"u32","std","The 32-bit unsigned integer type.",null,null],[17,"MIN","std::u32","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"u64","std","The 64-bit unsigned integer type.",null,null],[17,"MIN","std::u64","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"boxed","std","A pointer type for heap allocation.",null,null],[17,"HEAP","std::boxed","A value that represents the heap. This is the default place that the `box` keyword allocates into when no place is supplied.",null,null],[3,"ExchangeHeapSingleton","","This the singleton type used solely for `boxed::HEAP`.",null,null],[3,"Box","","A pointer type for heap allocation.",null,null],[3,"IntermediateBox","","`IntermediateBox` represents uninitialized backing storage for `Box`.",null,null],[8,"FnBox","","`FnBox` is a version of the `FnOnce` intended for use with boxed closure objects. The idea is that where one would normally store a `Box<FnOnce()>` in a data structure, you should use `Box<FnBox()>`. The two traits behave essentially the same, except that a `FnBox` closure can only be called if it is boxed. (Note that `FnBox` may be deprecated in the future if `Box<FnOnce()>` closures become directly usable.)",null,null],[16,"Output","","",72,null],[10,"call_box","","",72,null],[0,"rc","std","Single-threaded reference-counting pointers. 'Rc' stands for 'Reference Counted'.",null,null],[3,"Rc","std::rc","A single-threaded reference-counting pointer. 'Rc' stands for 'Reference Counted'.",null,null],[3,"Weak","","`Weak` is a version of [`Rc`] that holds a non-owning reference to the managed value. The value is accessed by calling [`upgrade`] on the `Weak` pointer, which returns an [`Option`]`<`[`Rc`]`<T>>`.",null,null],[0,"borrow","std","A module for working with borrowed data.",null,null],[8,"ToOwned","std::borrow","A generalization of `Clone` to borrowed data.",null,null],[16,"Owned","","",73,null],[10,"to_owned","","Creates owned data from borrowed data, usually by cloning.",73,null],[11,"clone_into","","Uses borrowed data to replace owned data, usually by cloning.",73,null],[4,"Cow","","A clone-on-write smart pointer.",null,null],[13,"Borrowed","","Borrowed data.",74,null],[13,"Owned","","Owned data.",74,null],[8,"Borrow","","A trait for borrowing data.",null,null],[10,"borrow","","Immutably borrows from an owned value.",75,{"inputs":[{"name":"self"}],"output":{"name":"borrowed"}}],[8,"BorrowMut","","A trait for mutably borrowing data.",null,null],[10,"borrow_mut","","Mutably borrows from an owned value.",76,{"inputs":[{"name":"self"}],"output":{"name":"borrowed"}}],[0,"fmt","std","Utilities for formatting and printing `String`s",null,null],[5,"format","std::fmt","The `format` function takes an [`Arguments`] struct and returns the resulting formatted string.",null,{"inputs":[{"name":"arguments"}],"output":{"name":"string"}}],[8,"Octal","","`o` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",77,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"DebugList","","A struct to help with `fmt::Debug` implementations.",null,null],[5,"write","","The `write` function takes an output stream, and an `Arguments` struct that can be precompiled with the `format_args!` macro.",null,{"inputs":[{"name":"write"},{"name":"arguments"}],"output":{"name":"result"}}],[8,"LowerExp","","`e` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",78,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"DebugSet","","A struct to help with `fmt::Debug` implementations.",null,null],[8,"Debug","","`?` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",79,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"DebugTuple","","A struct to help with `fmt::Debug` implementations.",null,null],[8,"Write","","A collection of methods that are required to format a message into a stream.",null,null],[10,"write_str","","Writes a slice of bytes into this writer, returning whether the write succeeded.",80,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"result"}}],[11,"write_char","","Writes a [`char`] into this writer, returning whether the write succeeded.",80,{"inputs":[{"name":"self"},{"name":"char"}],"output":{"name":"result"}}],[11,"write_fmt","","Glue for usage of the [`write!`] macro with implementors of this trait.",80,{"inputs":[{"name":"self"},{"name":"arguments"}],"output":{"name":"result"}}],[3,"Error","","The error type which is returned from formatting a message into a stream.",null,null],[3,"Formatter","","A struct to represent both where to emit formatting strings to and how they should be formatted. A mutable version of this is passed to all formatting traits.",null,null],[8,"UpperExp","","`E` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",81,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"Binary","","`b` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",82,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"UpperHex","","`X` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",83,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"Pointer","","`p` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",84,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"DebugStruct","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"Arguments","","This structure represents a safely precompiled version of a format string and its arguments. This cannot be generated at runtime because it cannot safely be done, so no constructors are given and the fields are private to prevent modification.",null,null],[3,"DebugMap","","A struct to help with `fmt::Debug` implementations.",null,null],[6,"Result","","The type returned by formatter methods.",null,null],[8,"LowerHex","","`x` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",85,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"Display","","Format trait for an empty format, `{}`.",null,null],[10,"fmt","","Formats the value using the given formatter.",86,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[0,"slice","std","A dynamically-sized view into a contiguous sequence, `[T]`.",null,null],[8,"SliceConcatExt","std::slice","An extension trait for concatenating slices",null,null],[16,"Output","","The resulting type after concatenation",87,null],[10,"concat","","Flattens a slice of `T` into a single value `Self::Output`.",87,null],[10,"join","","Flattens a slice of `T` into a single value `Self::Output`, placing a given separator between each.",87,null],[10,"connect","","",87,null],[5,"from_raw_parts_mut","","Performs the same functionality as `from_raw_parts`, except that a mutable slice is returned.",null,null],[3,"IterMut","","Mutable slice iterator.",null,null],[3,"SplitNMut","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits.",null,null],[3,"RSplitN","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits, starting from the end of the slice.",null,null],[3,"RSplit","","An iterator over subslices separated by elements that match a predicate function, starting from the end of the slice.",null,null],[3,"SplitMut","","An iterator over the subslices of the vector which are separated by elements that match `pred`.",null,null],[3,"Iter","","Immutable slice iterator",null,null],[3,"Windows","","An iterator over overlapping subslices of length `size`.",null,null],[3,"Chunks","","An iterator over a slice in (non-overlapping) chunks (`size` elements at a time).",null,null],[8,"SliceIndex","","A helper trait used for indexing operations.",null,null],[16,"Output","","The output type returned by methods.",88,null],[10,"get","","Returns a shared reference to the output at this location, if in bounds.",88,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"option"}}],[10,"get_mut","","Returns a mutable reference to the output at this location, if in bounds.",88,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"option"}}],[10,"get_unchecked","","Returns a shared reference to the output at this location, without performing any bounds checking.",88,null],[10,"get_unchecked_mut","","Returns a mutable reference to the output at this location, without performing any bounds checking.",88,null],[10,"index","","Returns a shared reference to the output at this location, panicking if out of bounds.",88,null],[10,"index_mut","","Returns a mutable reference to the output at this location, panicking if out of bounds.",88,null],[3,"RSplitNMut","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits, starting from the end of the slice.",null,null],[3,"SplitN","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits.",null,null],[3,"Split","","An iterator over subslices separated by elements that match a predicate function.",null,null],[3,"ChunksMut","","An iterator over a slice in (non-overlapping) mutable chunks (`size` elements at a time). When the slice len is not evenly divided by the chunk size, the last slice of the iteration will be the remainder.",null,null],[3,"RSplitMut","","An iterator over the subslices of the vector which are separated by elements that match `pred`, starting from the end of the slice.",null,null],[5,"from_raw_parts","","Forms a slice from a pointer and a length.",null,null],[0,"str","std","Unicode string slices.",null,null],[3,"EncodeUtf16","std::str","An iterator of [`u16`] over the string encoded as UTF-16.",null,null],[5,"from_boxed_utf8_unchecked","","Converts a boxed slice of bytes to a boxed string slice without checking that the string contains valid UTF-8.",null,{"inputs":[{"name":"box"}],"output":{"name":"box"}}],[3,"CharIndices","","An iterator over the [`char`]s of a string slice, and their positions.",null,null],[3,"RSplitTerminator","","Created with the method [`rsplit_terminator`].",null,null],[3,"ParseBoolError","","An error returned when parsing a `bool` using [`from_str`] fails",null,null],[5,"from_utf8_unchecked_mut","","Converts a slice of bytes to a string slice without checking that the string contains valid UTF-8; mutable version.",null,null],[0,"pattern","","The string Pattern API.",null,null],[8,"Pattern","std::str::pattern","A string pattern.",null,null],[16,"Searcher","","Associated searcher for this pattern",89,null],[10,"into_searcher","","Constructs the associated searcher from `self` and the `haystack` to search in.",89,null],[11,"is_contained_in","","Checks whether the pattern matches anywhere in the haystack",89,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"is_prefix_of","","Checks whether the pattern matches at the front of the haystack",89,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"is_suffix_of","","Checks whether the pattern matches at the back of the haystack",89,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[4,"SearchStep","","Result of calling `Searcher::next()` or `ReverseSearcher::next_back()`.",null,null],[13,"Match","","Expresses that a match of the pattern has been found at `haystack[a..b]`.",90,null],[13,"Reject","","Expresses that `haystack[a..b]` has been rejected as a possible match of the pattern.",90,null],[13,"Done","","Expresses that every byte of the haystack has been visited, ending the iteration.",90,null],[8,"Searcher","","A searcher for a string pattern.",null,null],[10,"haystack","","Getter for the underlying string to be searched in",91,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[10,"next","","Performs the next search step starting from the front.",91,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match","","Find the next `Match` result. See `next()`",91,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject","","Find the next `Reject` result. See `next()`",91,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[8,"ReverseSearcher","","A reverse searcher for a string pattern.",null,null],[10,"next_back","","Performs the next search step starting from the back.",92,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match_back","","Find the next `Match` result. See `next_back()`",92,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject_back","","Find the next `Reject` result. See `next_back()`",92,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[8,"DoubleEndedSearcher","","A marker trait to express that a `ReverseSearcher` can be used for a `DoubleEndedIterator` implementation.",null,null],[3,"CharSearcher","","Associated type for `<char as Pattern<'a>>::Searcher`.",null,null],[3,"CharSliceSearcher","","Associated type for `<&[char] as Pattern<'a>>::Searcher`.",null,null],[3,"CharPredicateSearcher","","Associated type for `<F as Pattern<'a>>::Searcher`.",null,null],[3,"StrSearcher","","Associated type for `<&str as Pattern<'a>>::Searcher`.",null,null],[3,"RMatchIndices","std::str","Created with the method [`rmatch_indices`].",null,null],[3,"RSplit","","Created with the method [`rsplit`].",null,null],[3,"RSplitN","","Created with the method [`rsplitn`].",null,null],[3,"Chars","","An iterator over the [`char`]s of a string slice.",null,null],[3,"SplitTerminator","","Created with the method [`split_terminator`].",null,null],[5,"from_utf8_unchecked","","Converts a slice of bytes to a string slice without checking that the string contains valid UTF-8.",null,null],[8,"FromStr","","A trait to abstract the idea of creating a new instance of a type from a string.",null,null],[16,"Err","","The associated error which can be returned from parsing.",93,null],[10,"from_str","","Parses a string `s` to return a value of this type.",93,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[3,"MatchIndices","","Created with the method [`match_indices`].",null,null],[5,"from_utf8_mut","","Converts a mutable slice of bytes to a mutable string slice.",null,null],[5,"from_utf8","","Converts a slice of bytes to a string slice.",null,null],[3,"RMatches","","Created with the method [`rmatches`].",null,null],[3,"LinesAny","","Created with the method [`lines_any`].",null,null],[3,"SplitN","","Created with the method [`splitn`].",null,null],[3,"Split","","Created with the method [`split`].",null,null],[3,"Bytes","","An iterator over the bytes of a string slice.",null,null],[3,"SplitWhitespace","","An iterator over the non-whitespace substrings of a string, separated by any amount of whitespace.",null,null],[3,"Lines","","An iterator over the lines of a string, as string slices.",null,null],[3,"Matches","","Created with the method [`matches`].",null,null],[3,"Utf8Error","","Errors which can occur when attempting to interpret a sequence of [`u8`] as a string.",null,null],[0,"string","std","A UTF-8 encoded, growable string.",null,null],[3,"String","std::string","A UTF-8 encoded, growable string.",null,null],[3,"FromUtf8Error","","A possible error value when converting a `String` from a UTF-8 byte vector.",null,null],[3,"FromUtf16Error","","A possible error value when converting a `String` from a UTF-16 byte slice.",null,null],[4,"ParseError","","An error when parsing a `String`.",null,null],[8,"ToString","","A trait for converting a value to a `String`.",null,null],[10,"to_string","","Converts the given value to a `String`.",94,{"inputs":[{"name":"self"}],"output":{"name":"string"}}],[3,"Drain","","A draining iterator for `String`.",null,null],[0,"vec","std","A contiguous growable array type with heap-allocated contents, written `Vec<T>`.",null,null],[3,"Vec","std::vec","A contiguous growable array type, written `Vec<T>` but pronounced 'vector'.",null,null],[3,"IntoIter","","An iterator that moves out of a vector.",null,null],[3,"Drain","","A draining iterator for `Vec<T>`.",null,null],[3,"PlaceBack","","A place for insertion at the back of a `Vec`.",null,null],[3,"Splice","","A splicing iterator for `Vec`.",null,null],[3,"DrainFilter","","An iterator produced by calling `drain_filter` on Vec.",null,null],[0,"char","std","A character type.",null,null],[3,"ToLowercase","std::char","Returns an iterator that yields the lowercase equivalent of a `char`.",null,null],[3,"ToUppercase","","Returns an iterator that yields the uppercase equivalent of a `char`.",null,null],[3,"DecodeUtf16","","An iterator that decodes UTF-16 encoded code points from an iterator of `u16`s.",null,null],[3,"DecodeUtf16Error","","An iterator that decodes UTF-16 encoded code points from an iterator of `u16`s.",null,null],[5,"decode_utf16","","Create an iterator over the UTF-16 encoded code points in `iter`, returning unpaired surrogates as `Err`s.",null,{"inputs":[{"name":"i"}],"output":{"name":"decodeutf16"}}],[17,"REPLACEMENT_CHARACTER","","`U+FFFD REPLACEMENT CHARACTER` (�) is used in Unicode to represent a decoding error.",null,null],[5,"from_u32_unchecked","","Converts a `u32` to a `char`, ignoring validity.",null,{"inputs":[{"name":"u32"}],"output":{"name":"char"}}],[17,"UNICODE_VERSION","","The version of Unicode that the Unicode parts of `CharExt` and `UnicodeStrPrelude` traits are based on.",null,null],[3,"DecodeUtf8","","An iterator over an iterator of bytes of the characters the bytes represent as UTF-8",null,null],[3,"EscapeDebug","","An iterator that yields the literal escape code of a `char`.",null,null],[3,"EscapeUnicode","","Returns an iterator that yields the hexadecimal Unicode escape of a character, as `char`s.",null,null],[17,"MAX","","The highest valid code point a `char` can have.",null,null],[5,"from_u32","","Converts a `u32` to a `char`.",null,{"inputs":[{"name":"u32"}],"output":{"name":"option"}}],[3,"EscapeDefault","","An iterator that yields the literal escape code of a `char`.",null,null],[3,"CharTryFromError","","The error type returned when a conversion from u32 to char fails.",null,null],[3,"ParseCharError","","An error which can be returned when parsing a char.",null,null],[3,"UnicodeVersion","","Represents a Unicode Version.",null,null],[12,"major","","Major version.",95,null],[12,"minor","","Minor version.",95,null],[12,"micro","","Micro (or Update) version.",95,null],[5,"from_digit","","Converts a digit in the given radix to a `char`.",null,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"option"}}],[5,"decode_utf8","","Decodes an `Iterator` of bytes as UTF-8.",null,{"inputs":[{"name":"i"}],"output":{"name":"decodeutf8"}}],[0,"u128","std","The 128-bit unsigned integer type.",null,null],[17,"MIN","std::u128","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"prelude","std","The Rust Prelude.",null,null],[0,"v1","std::prelude","The first version of the prelude of The Rust Standard Library.",null,null],[0,"f32","std","This module provides constants which are specific to the implementation of the `f32` floating point data type. Mathematically significant numbers are provided in the `consts` sub-module.",null,null],[17,"RADIX","std::f32","The radix or base of the internal representation of `f32`.",null,null],[17,"MANTISSA_DIGITS","","Number of significant digits in base 2.",null,null],[17,"DIGITS","","Approximate number of significant digits in base 10.",null,null],[17,"EPSILON","","Difference between `1.0` and the next largest representable number.",null,null],[17,"MIN_EXP","","One greater than the minimum possible normal power of 2 exponent.",null,null],[17,"MAX_EXP","","Maximum possible power of 2 exponent.",null,null],[17,"MIN_10_EXP","","Minimum possible normal power of 10 exponent.",null,null],[17,"MAX_10_EXP","","Maximum possible power of 10 exponent.",null,null],[17,"NAN","","Not a Number (NaN).",null,null],[17,"INFINITY","","Infinity (∞).",null,null],[17,"NEG_INFINITY","","Negative infinity (-∞).",null,null],[17,"MIN","","Smallest finite `f32` value.",null,null],[17,"MIN_POSITIVE","","Smallest positive normal `f32` value.",null,null],[17,"MAX","","Largest finite `f32` value.",null,null],[0,"consts","","Basic mathematical constants.",null,null],[17,"PI","std::f32::consts","Archimedes' constant (π)",null,null],[17,"FRAC_PI_2","","π/2",null,null],[17,"FRAC_PI_3","","π/3",null,null],[17,"FRAC_PI_4","","π/4",null,null],[17,"FRAC_PI_6","","π/6",null,null],[17,"FRAC_PI_8","","π/8",null,null],[17,"FRAC_1_PI","","1/π",null,null],[17,"FRAC_2_PI","","2/π",null,null],[17,"FRAC_2_SQRT_PI","","2/sqrt(π)",null,null],[17,"SQRT_2","","sqrt(2)",null,null],[17,"FRAC_1_SQRT_2","","1/sqrt(2)",null,null],[17,"E","","Euler's number (e)",null,null],[17,"LOG2_E","","log2(e)",null,null],[17,"LOG10_E","","log10(e)",null,null],[17,"LN_2","","ln(2)",null,null],[17,"LN_10","","ln(10)",null,null],[0,"f64","std","This module provides constants which are specific to the implementation of the `f64` floating point data type. Mathematically significant numbers are provided in the `consts` sub-module.",null,null],[17,"RADIX","std::f64","The radix or base of the internal representation of `f64`.",null,null],[17,"MANTISSA_DIGITS","","Number of significant digits in base 2.",null,null],[17,"DIGITS","","Approximate number of significant digits in base 10.",null,null],[17,"EPSILON","","Difference between `1.0` and the next largest representable number.",null,null],[17,"MIN_EXP","","One greater than the minimum possible normal power of 2 exponent.",null,null],[17,"MAX_EXP","","Maximum possible power of 2 exponent.",null,null],[17,"MIN_10_EXP","","Minimum possible normal power of 10 exponent.",null,null],[17,"MAX_10_EXP","","Maximum possible power of 10 exponent.",null,null],[17,"NAN","","Not a Number (NaN).",null,null],[17,"INFINITY","","Infinity (∞).",null,null],[17,"NEG_INFINITY","","Negative infinity (-∞).",null,null],[17,"MIN","","Smallest finite `f64` value.",null,null],[17,"MIN_POSITIVE","","Smallest positive normal `f64` value.",null,null],[17,"MAX","","Largest finite `f64` value.",null,null],[0,"consts","","Basic mathematical constants.",null,null],[17,"PI","std::f64::consts","Archimedes' constant (π)",null,null],[17,"FRAC_PI_2","","π/2",null,null],[17,"FRAC_PI_3","","π/3",null,null],[17,"FRAC_PI_4","","π/4",null,null],[17,"FRAC_PI_6","","π/6",null,null],[17,"FRAC_PI_8","","π/8",null,null],[17,"FRAC_1_PI","","1/π",null,null],[17,"FRAC_2_PI","","2/π",null,null],[17,"FRAC_2_SQRT_PI","","2/sqrt(π)",null,null],[17,"SQRT_2","","sqrt(2)",null,null],[17,"FRAC_1_SQRT_2","","1/sqrt(2)",null,null],[17,"E","","Euler's number (e)",null,null],[17,"LOG2_E","","log2(e)",null,null],[17,"LOG10_E","","log10(e)",null,null],[17,"LN_2","","ln(2)",null,null],[17,"LN_10","","ln(10)",null,null],[0,"thread","std","Native threads.",null,null],[3,"LocalKey","std::thread","A thread local storage key which owns its contents.",null,null],[3,"AccessError","","An error returned by `LocalKey::try_with`.",null,null],[3,"Builder","","Thread factory, which can be used in order to configure the properties of a new thread.",null,null],[3,"ThreadId","","A unique identifier for a running thread.",null,null],[3,"Thread","","A handle to a thread.",null,null],[3,"JoinHandle","","An owned permission to join on a thread (block on its termination).",null,null],[4,"LocalKeyState","","Indicator of the state of a thread local storage key.",null,null],[13,"Uninitialized","","All keys are in this state whenever a thread starts. Keys will transition to the `Valid` state once the first call to [`with`] happens and the initialization expression succeeds.",96,null],[13,"Valid","","Once a key has been accessed successfully, it will enter the `Valid` state. Keys in the `Valid` state will remain so until the thread exits, at which point the destructor will be run and the key will enter the `Destroyed` state.",96,null],[13,"Destroyed","","When a thread exits, the destructors for keys will be run (if necessary). While a destructor is running, and possibly after a destructor has run, a key is in the `Destroyed` state.",96,null],[5,"spawn","","Spawns a new thread, returning a [`JoinHandle`] for it.",null,{"inputs":[{"name":"f"}],"output":{"name":"joinhandle"}}],[5,"current","","Gets a handle to the thread that invokes it.",null,{"inputs":[],"output":{"name":"thread"}}],[5,"yield_now","","Cooperatively gives up a timeslice to the OS scheduler.",null,{"inputs":[],"output":null}],[5,"panicking","","Determines whether the current thread is unwinding because of panic.",null,{"inputs":[],"output":{"name":"bool"}}],[5,"sleep_ms","","Puts the current thread to sleep for the specified amount of time.",null,{"inputs":[{"name":"u32"}],"output":null}],[5,"sleep","","Puts the current thread to sleep for the specified amount of time.",null,{"inputs":[{"name":"duration"}],"output":null}],[5,"park","","Blocks unless or until the current thread's token is made available.",null,{"inputs":[],"output":null}],[5,"park_timeout_ms","","Use [`park_timeout`].",null,{"inputs":[{"name":"u32"}],"output":null}],[5,"park_timeout","","Blocks unless or until the current thread's token is made available or the specified duration has been reached (may wake spuriously).",null,{"inputs":[{"name":"duration"}],"output":null}],[11,"fmt","","",97,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",96,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",96,{"inputs":[{"name":"self"},{"name":"localkeystate"}],"output":{"name":"bool"}}],[11,"clone","","",96,{"inputs":[{"name":"self"}],"output":{"name":"localkeystate"}}],[11,"fmt","","",98,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",98,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"with","","Acquires a reference to the value in this TLS key.",97,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"r"}}],[11,"state","","Query the current state of this key.",97,{"inputs":[{"name":"self"}],"output":{"name":"localkeystate"}}],[11,"try_with","","Acquires a reference to the value in this TLS key.",97,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"result"}}],[6,"Result","","A specialized [`Result`] type for threads.",null,null],[11,"fmt","","",99,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Generates the base configuration for spawning a thread, from which configuration methods can be chained.",99,{"inputs":[],"output":{"name":"builder"}}],[11,"name","","Names the thread-to-be. Currently the name is used for identification only in panic messages.",99,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"builder"}}],[11,"stack_size","","Sets the size of the stack (in bytes) for the new thread.",99,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"builder"}}],[11,"spawn","","Spawns a new thread by taking ownership of the `Builder`, and returns an [`io::Result`] to its [`JoinHandle`].",99,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"result"}}],[11,"eq","","",100,{"inputs":[{"name":"self"},{"name":"threadid"}],"output":{"name":"bool"}}],[11,"ne","","",100,{"inputs":[{"name":"self"},{"name":"threadid"}],"output":{"name":"bool"}}],[11,"clone","","",100,{"inputs":[{"name":"self"}],"output":{"name":"threadid"}}],[11,"hash","","",100,null],[11,"fmt","","",100,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",101,{"inputs":[{"name":"self"}],"output":{"name":"thread"}}],[11,"unpark","","Atomically makes the handle's token available if it is not already.",101,{"inputs":[{"name":"self"}],"output":null}],[11,"id","","Gets the thread's unique identifier.",101,{"inputs":[{"name":"self"}],"output":{"name":"threadid"}}],[11,"name","","Gets the thread's name.",101,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",101,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"thread","","Extracts a handle to the underlying thread.",102,{"inputs":[{"name":"self"}],"output":{"name":"thread"}}],[11,"join","","Waits for the associated thread to finish.",102,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"fmt","","",102,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[0,"ascii","std","Operations on ASCII strings and characters.",null,null],[3,"EscapeDefault","std::ascii","An iterator over the escaped version of a byte.",null,null],[5,"escape_default","","Returns an iterator that produces an escaped version of a `u8`.",null,{"inputs":[{"name":"u8"}],"output":{"name":"escapedefault"}}],[8,"AsciiExt","","Extension methods for ASCII-subset only operations.",null,null],[16,"Owned","","Container type for copied ASCII characters.",103,null],[10,"is_ascii","","Checks if the value is within the ASCII range.",103,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[10,"to_ascii_uppercase","","Makes a copy of the value in its ASCII upper case equivalent.",103,null],[10,"to_ascii_lowercase","","Makes a copy of the value in its ASCII lower case equivalent.",103,null],[10,"eq_ignore_ascii_case","","Checks that two values are an ASCII case-insensitive match.",103,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"bool"}}],[10,"make_ascii_uppercase","","Converts this type to its ASCII upper case equivalent in-place.",103,{"inputs":[{"name":"self"}],"output":null}],[10,"make_ascii_lowercase","","Converts this type to its ASCII lower case equivalent in-place.",103,{"inputs":[{"name":"self"}],"output":null}],[11,"is_ascii_alphabetic","","Checks if the value is an ASCII alphabetic character: U+0041 'A' ... U+005A 'Z' or U+0061 'a' ... U+007A 'z'. For strings, true if all characters in the string are ASCII alphabetic.",103,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_ascii_uppercase","","Checks if the value is an ASCII uppercase character: U+0041 'A' ... U+005A 'Z'. For strings, true if all characters in the string are ASCII uppercase.",103,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_ascii_lowercase","","Checks if the value is an ASCII lowercase character: U+0061 'a' ... U+007A 'z'. For strings, true if all characters in the string are ASCII lowercase.",103,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_ascii_alphanumeric","","Checks if the value is an ASCII alphanumeric character: U+0041 'A' ... U+005A 'Z', U+0061 'a' ... U+007A 'z', or U+0030 '0' ... U+0039 '9'. For strings, true if all characters in the string are ASCII alphanumeric.",103,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_ascii_digit","","Checks if the value is an ASCII decimal digit: U+0030 '0' ... U+0039 '9'. For strings, true if all characters in the string are ASCII digits.",103,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_ascii_hexdigit","","Checks if the value is an ASCII hexadecimal digit: U+0030 '0' ... U+0039 '9', U+0041 'A' ... U+0046 'F', or U+0061 'a' ... U+0066 'f'. For strings, true if all characters in the string are ASCII hex digits.",103,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_ascii_punctuation","","Checks if the value is an ASCII punctuation character: U+0021 ... U+002F `! \" # $ % & ' ( ) * + , - . /` U+003A ... U+0040 `: ; < = > ? @` U+005B ... U+0060 `[ \\\\ ] ^ _ \\`` U+007B ... U+007E`{ | } ~` For strings, true if all characters in the string are ASCII punctuation.",103,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_ascii_graphic","","Checks if the value is an ASCII graphic character: U+0021 '@' ... U+007E '~'. For strings, true if all characters in the string are ASCII punctuation.",103,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_ascii_whitespace","","Checks if the value is an ASCII whitespace character: U+0020 SPACE, U+0009 HORIZONTAL TAB, U+000A LINE FEED, U+000C FORM FEED, or U+000D CARRIAGE RETURN. For strings, true if all characters in the string are ASCII whitespace.",103,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_ascii_control","","Checks if the value is an ASCII control character: U+0000 NUL ... U+001F UNIT SEPARATOR, or U+007F DELETE. Note that most ASCII whitespace characters are control characters, but SPACE is not.",103,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"next","","",104,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",104,null],[11,"next_back","","",104,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",104,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[0,"collections","std","Collection types.",null,null],[4,"Bound","std::collections","An endpoint of a range of keys.",null,null],[13,"Included","","An inclusive bound.",105,null],[13,"Excluded","","An exclusive bound.",105,null],[13,"Unbounded","","An infinite endpoint. Indicates that there is no bound in this direction.",105,null],[3,"BinaryHeap","","A priority queue implemented with a binary heap.",null,null],[3,"BTreeMap","","A map based on a B-Tree.",null,null],[3,"BTreeSet","","A set based on a B-Tree.",null,null],[3,"LinkedList","","A doubly-linked list with owned nodes.",null,null],[3,"VecDeque","","A double-ended queue implemented with a growable ring buffer.",null,null],[0,"binary_heap","","A priority queue implemented with a binary heap.",null,null],[3,"BinaryHeap","std::collections::binary_heap","A priority queue implemented with a binary heap.",null,null],[3,"PeekMut","","Structure wrapping a mutable reference to the greatest item on a `BinaryHeap`.",null,null],[3,"Iter","","An iterator over the elements of a `BinaryHeap`.",null,null],[3,"IntoIter","","An owning iterator over the elements of a `BinaryHeap`.",null,null],[3,"Drain","","A draining iterator over the elements of a `BinaryHeap`.",null,null],[3,"BinaryHeapPlace","","",null,null],[0,"btree_map","std::collections","A map based on a B-Tree.",null,null],[3,"IterMut","std::collections::btree_map","A mutable iterator over the entries of a `BTreeMap`.",null,null],[3,"BTreeMap","","A map based on a B-Tree.",null,null],[3,"ValuesMut","","A mutable iterator over the values of a `BTreeMap`.",null,null],[3,"Values","","An iterator over the values of a `BTreeMap`.",null,null],[3,"OccupiedEntry","","A view into an occupied entry in a `BTreeMap`. It is part of the [`Entry`] enum.",null,null],[4,"Entry","","A view into a single entry in a map, which may either be vacant or occupied.",null,null],[13,"Vacant","","A vacant entry.",106,null],[13,"Occupied","","An occupied entry.",106,null],[3,"RangeMut","","A mutable iterator over a sub-range of entries in a `BTreeMap`.",null,null],[3,"Keys","","An iterator over the keys of a `BTreeMap`.",null,null],[3,"IntoIter","","An owning iterator over the entries of a `BTreeMap`.",null,null],[3,"Iter","","An iterator over the entries of a `BTreeMap`.",null,null],[3,"Range","","An iterator over a sub-range of entries in a `BTreeMap`.",null,null],[3,"VacantEntry","","A view into a vacant entry in a `BTreeMap`. It is part of the [`Entry`] enum.",null,null],[0,"btree_set","std::collections","A set based on a B-Tree.",null,null],[3,"SymmetricDifference","std::collections::btree_set","A lazy iterator producing elements in the symmetric difference of `BTreeSet`s.",null,null],[3,"BTreeSet","","A set based on a B-Tree.",null,null],[3,"Intersection","","A lazy iterator producing elements in the intersection of `BTreeSet`s.",null,null],[3,"IntoIter","","An owning iterator over the items of a `BTreeSet`.",null,null],[3,"Difference","","A lazy iterator producing elements in the difference of `BTreeSet`s.",null,null],[3,"Union","","A lazy iterator producing elements in the union of `BTreeSet`s.",null,null],[3,"Iter","","An iterator over the items of a `BTreeSet`.",null,null],[3,"Range","","An iterator over a sub-range of items in a `BTreeSet`.",null,null],[0,"linked_list","std::collections","A doubly-linked list with owned nodes.",null,null],[3,"LinkedList","std::collections::linked_list","A doubly-linked list with owned nodes.",null,null],[3,"Iter","","An iterator over the elements of a `LinkedList`.",null,null],[3,"IterMut","","A mutable iterator over the elements of a `LinkedList`.",null,null],[3,"IntoIter","","An owning iterator over the elements of a `LinkedList`.",null,null],[3,"FrontPlace","","A place for insertion at the front of a `LinkedList`.",null,null],[3,"BackPlace","","A place for insertion at the back of a `LinkedList`.",null,null],[0,"vec_deque","std::collections","A double-ended queue implemented with a growable ring buffer.",null,null],[3,"VecDeque","std::collections::vec_deque","A double-ended queue implemented with a growable ring buffer.",null,null],[3,"Iter","","An iterator over the elements of a `VecDeque`.",null,null],[3,"IterMut","","A mutable iterator over the elements of a `VecDeque`.",null,null],[3,"IntoIter","","An owning iterator over the elements of a `VecDeque`.",null,null],[3,"Drain","","A draining iterator over the elements of a `VecDeque`.",null,null],[3,"PlaceBack","","A place for insertion at the back of a `VecDeque`.",null,null],[3,"PlaceFront","","A place for insertion at the front of a `VecDeque`.",null,null],[0,"range","std::collections","Range syntax.",null,null],[8,"RangeArgument","std::collections::range","`RangeArgument` is implemented by Rust's built-in range types, produced by range syntax like `..`, `a..`, `..b` or `c..d`.",null,null],[10,"start","","Start index bound.",107,{"inputs":[{"name":"self"}],"output":{"name":"bound"}}],[10,"end","","End index bound.",107,{"inputs":[{"name":"self"}],"output":{"name":"bound"}}],[3,"HashMap","std::collections","A hash map implemented with linear probing and Robin Hood bucket stealing.",null,null],[3,"HashSet","","A hash set implemented as a `HashMap` where the value is `()`.",null,null],[11,"clone","","",108,{"inputs":[{"name":"self"}],"output":{"name":"hashmap"}}],[11,"new","","Creates an empty `HashMap`.",108,{"inputs":[],"output":{"name":"hashmap"}}],[11,"with_capacity","","Creates an empty `HashMap` with the specified capacity.",108,{"inputs":[{"name":"usize"}],"output":{"name":"hashmap"}}],[11,"with_hasher","","Creates an empty `HashMap` which will use the given hash builder to hash keys.",108,{"inputs":[{"name":"s"}],"output":{"name":"hashmap"}}],[11,"with_capacity_and_hasher","","Creates an empty `HashMap` with the specified capacity, using `hash_builder` to hash the keys.",108,{"inputs":[{"name":"usize"},{"name":"s"}],"output":{"name":"hashmap"}}],[11,"hasher","","Returns a reference to the map's [`BuildHasher`].",108,{"inputs":[{"name":"self"}],"output":{"name":"s"}}],[11,"capacity","","Returns the number of elements the map can hold without reallocating.",108,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"reserve","","Reserves capacity for at least `additional` more elements to be inserted in the `HashMap`. The collection may reserve more space to avoid frequent reallocations.",108,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shrink_to_fit","","Shrinks the capacity of the map as much as possible. It will drop down as much as possible while maintaining the internal rules and possibly leaving some space in accordance with the resize policy.",108,{"inputs":[{"name":"self"}],"output":null}],[11,"keys","","An iterator visiting all keys in arbitrary order. The iterator element type is `&'a K`.",108,{"inputs":[{"name":"self"}],"output":{"name":"keys"}}],[11,"values","","An iterator visiting all values in arbitrary order. The iterator element type is `&'a V`.",108,{"inputs":[{"name":"self"}],"output":{"name":"values"}}],[11,"values_mut","","An iterator visiting all values mutably in arbitrary order. The iterator element type is `&'a mut V`.",108,{"inputs":[{"name":"self"}],"output":{"name":"valuesmut"}}],[11,"iter","","An iterator visiting all key-value pairs in arbitrary order. The iterator element type is `(&'a K, &'a V)`.",108,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"iter_mut","","An iterator visiting all key-value pairs in arbitrary order, with mutable references to the values. The iterator element type is `(&'a K, &'a mut V)`.",108,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"entry","","Gets the given key's corresponding entry in the map for in-place manipulation.",108,{"inputs":[{"name":"self"},{"name":"k"}],"output":{"name":"entry"}}],[11,"len","","Returns the number of elements in the map.",108,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","Returns true if the map contains no elements.",108,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"drain","","Clears the map, returning all key-value pairs as an iterator. Keeps the allocated memory for reuse.",108,{"inputs":[{"name":"self"}],"output":{"name":"drain"}}],[11,"clear","","Clears the map, removing all key-value pairs. Keeps the allocated memory for reuse.",108,{"inputs":[{"name":"self"}],"output":null}],[11,"get","","Returns a reference to the value corresponding to the key.",108,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"option"}}],[11,"contains_key","","Returns true if the map contains a value for the specified key.",108,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"bool"}}],[11,"get_mut","","Returns a mutable reference to the value corresponding to the key.",108,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"option"}}],[11,"insert","","Inserts a key-value pair into the map.",108,{"inputs":[{"name":"self"},{"name":"k"},{"name":"v"}],"output":{"name":"option"}}],[11,"remove","","Removes a key from the map, returning the value at the key if the key was previously in the map.",108,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"option"}}],[11,"retain","","Retains only the elements specified by the predicate.",108,{"inputs":[{"name":"self"},{"name":"f"}],"output":null}],[11,"eq","","",108,{"inputs":[{"name":"self"},{"name":"hashmap"}],"output":{"name":"bool"}}],[11,"fmt","","",108,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"default","","Creates an empty `HashMap<K, V, S>`, with the `Default` value for the hasher.",108,{"inputs":[],"output":{"name":"hashmap"}}],[11,"index","","",108,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"v"}}],[11,"into_iter","","Creates a consuming iterator, that is, one that moves each key-value pair out of the map in arbitrary order. The map cannot be used after calling this.",108,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"from_iter","","",108,{"inputs":[{"name":"t"}],"output":{"name":"hashmap"}}],[11,"extend","","",108,{"inputs":[{"name":"self"},{"name":"t"}],"output":null}],[11,"extend","","",108,{"inputs":[{"name":"self"},{"name":"t"}],"output":null}],[11,"clone","","",109,{"inputs":[{"name":"self"}],"output":{"name":"hashset"}}],[11,"new","","Creates an empty `HashSet`.",109,{"inputs":[],"output":{"name":"hashset"}}],[11,"with_capacity","","Creates an empty `HashSet` with the specified capacity.",109,{"inputs":[{"name":"usize"}],"output":{"name":"hashset"}}],[11,"with_hasher","","Creates a new empty hash set which will use the given hasher to hash keys.",109,{"inputs":[{"name":"s"}],"output":{"name":"hashset"}}],[11,"with_capacity_and_hasher","","Creates an empty `HashSet` with with the specified capacity, using `hasher` to hash the keys.",109,{"inputs":[{"name":"usize"},{"name":"s"}],"output":{"name":"hashset"}}],[11,"hasher","","Returns a reference to the set's [`BuildHasher`].",109,{"inputs":[{"name":"self"}],"output":{"name":"s"}}],[11,"capacity","","Returns the number of elements the set can hold without reallocating.",109,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"reserve","","Reserves capacity for at least `additional` more elements to be inserted in the `HashSet`. The collection may reserve more space to avoid frequent reallocations.",109,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shrink_to_fit","","Shrinks the capacity of the set as much as possible. It will drop down as much as possible while maintaining the internal rules and possibly leaving some space in accordance with the resize policy.",109,{"inputs":[{"name":"self"}],"output":null}],[11,"iter","","An iterator visiting all elements in arbitrary order. The iterator element type is `&'a T`.",109,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"difference","","Visits the values representing the difference, i.e. the values that are in `self` but not in `other`.",109,{"inputs":[{"name":"self"},{"name":"hashset"}],"output":{"name":"difference"}}],[11,"symmetric_difference","","Visits the values representing the symmetric difference, i.e. the values that are in `self` or in `other` but not in both.",109,{"inputs":[{"name":"self"},{"name":"hashset"}],"output":{"name":"symmetricdifference"}}],[11,"intersection","","Visits the values representing the intersection, i.e. the values that are both in `self` and `other`.",109,{"inputs":[{"name":"self"},{"name":"hashset"}],"output":{"name":"intersection"}}],[11,"union","","Visits the values representing the union, i.e. all the values in `self` or `other`, without duplicates.",109,{"inputs":[{"name":"self"},{"name":"hashset"}],"output":{"name":"union"}}],[11,"len","","Returns the number of elements in the set.",109,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","Returns true if the set contains no elements.",109,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"drain","","Clears the set, returning all elements in an iterator.",109,{"inputs":[{"name":"self"}],"output":{"name":"drain"}}],[11,"clear","","Clears the set, removing all values.",109,{"inputs":[{"name":"self"}],"output":null}],[11,"contains","","Returns `true` if the set contains a value.",109,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"bool"}}],[11,"get","","Returns a reference to the value in the set, if any, that is equal to the given value.",109,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"option"}}],[11,"is_disjoint","","Returns `true` if `self` has no elements in common with `other`. This is equivalent to checking for an empty intersection.",109,{"inputs":[{"name":"self"},{"name":"hashset"}],"output":{"name":"bool"}}],[11,"is_subset","","Returns `true` if the set is a subset of another, i.e. `other` contains at least all the values in `self`.",109,{"inputs":[{"name":"self"},{"name":"hashset"}],"output":{"name":"bool"}}],[11,"is_superset","","Returns `true` if the set is a superset of another, i.e. `self` contains at least all the values in `other`.",109,{"inputs":[{"name":"self"},{"name":"hashset"}],"output":{"name":"bool"}}],[11,"insert","","Adds a value to the set.",109,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"bool"}}],[11,"replace","","Adds a value to the set, replacing the existing value, if any, that is equal to the given one. Returns the replaced value.",109,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"option"}}],[11,"remove","","Removes a value from the set. Returns `true` if the value was present in the set.",109,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"bool"}}],[11,"take","","Removes and returns the value in the set, if any, that is equal to the given one.",109,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"option"}}],[11,"retain","","Retains only the elements specified by the predicate.",109,{"inputs":[{"name":"self"},{"name":"f"}],"output":null}],[11,"eq","","",109,{"inputs":[{"name":"self"},{"name":"hashset"}],"output":{"name":"bool"}}],[11,"fmt","","",109,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"from_iter","","",109,{"inputs":[{"name":"i"}],"output":{"name":"hashset"}}],[11,"extend","","",109,{"inputs":[{"name":"self"},{"name":"i"}],"output":null}],[11,"extend","","",109,{"inputs":[{"name":"self"},{"name":"i"}],"output":null}],[11,"default","","Creates an empty `HashSet<T, S>` with the `Default` value for the hasher.",109,{"inputs":[],"output":{"name":"hashset"}}],[11,"into_iter","","Creates a consuming iterator, that is, one that moves each value out of the set in arbitrary order. The set cannot be used after calling this.",109,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[0,"hash_map","","A hash map implemented with linear probing and Robin Hood bucket stealing.",null,null],[3,"HashMap","std::collections::hash_map","A hash map implemented with linear probing and Robin Hood bucket stealing.",null,null],[3,"Iter","","An iterator over the entries of a `HashMap`.",null,null],[3,"IterMut","","A mutable iterator over the entries of a `HashMap`.",null,null],[3,"IntoIter","","An owning iterator over the entries of a `HashMap`.",null,null],[3,"Keys","","An iterator over the keys of a `HashMap`.",null,null],[3,"Values","","An iterator over the values of a `HashMap`.",null,null],[3,"Drain","","A draining iterator over the entries of a `HashMap`.",null,null],[3,"ValuesMut","","A mutable iterator over the values of a `HashMap`.",null,null],[3,"OccupiedEntry","","A view into an occupied entry in a `HashMap`. It is part of the [`Entry`] enum.",null,null],[3,"VacantEntry","","A view into a vacant entry in a `HashMap`. It is part of the [`Entry`] enum.",null,null],[3,"EntryPlace","","A place for insertion to a `Entry`.",null,null],[3,"RandomState","","`RandomState` is the default state for [`HashMap`] types.",null,null],[3,"DefaultHasher","","The default [`Hasher`] used by [`RandomState`].",null,null],[4,"Entry","","A view into a single entry in a map, which may either be vacant or occupied.",null,null],[13,"Occupied","","An occupied entry.",110,null],[13,"Vacant","","A vacant entry.",110,null],[0,"hash_set","std::collections","A hash set implemented as a `HashMap` where the value is `()`.",null,null],[3,"HashSet","std::collections::hash_set","A hash set implemented as a `HashMap` where the value is `()`.",null,null],[3,"Iter","","An iterator over the items of a `HashSet`.",null,null],[3,"IntoIter","","An owning iterator over the items of a `HashSet`.",null,null],[3,"Drain","","A draining iterator over the items of a `HashSet`.",null,null],[3,"Intersection","","A lazy iterator producing elements in the intersection of `HashSet`s.",null,null],[3,"Difference","","A lazy iterator producing elements in the difference of `HashSet`s.",null,null],[3,"SymmetricDifference","","A lazy iterator producing elements in the symmetric difference of `HashSet`s.",null,null],[3,"Union","","A lazy iterator producing elements in the union of `HashSet`s.",null,null],[0,"env","std","Inspection and manipulation of the process's environment.",null,null],[3,"Vars","std::env","An iterator over a snapshot of the environment variables of this process.",null,null],[3,"VarsOs","","An iterator over a snapshot of the environment variables of this process.",null,null],[3,"SplitPaths","","An iterator that splits an environment variable into paths according to platform-specific conventions.",null,null],[3,"JoinPathsError","","The error type for operations on the `PATH` variable. Possibly returned from the [`env::join_paths`] function.",null,null],[3,"Args","","An iterator over the arguments of a process, yielding a [`String`] value for each argument.",null,null],[3,"ArgsOs","","An iterator over the arguments of a process, yielding an [`OsString`] value for each argument.",null,null],[4,"VarError","","The error type for operations interacting with environment variables. Possibly returned from the [`env::var`] function.",null,null],[13,"NotPresent","","The specified environment variable was not present in the current process's environment.",111,null],[13,"NotUnicode","","The specified environment variable was found, but it did not contain valid unicode data. The found data is returned as a payload of this variant.",111,null],[5,"current_dir","","Returns the current working directory as a [`PathBuf`].",null,{"inputs":[],"output":{"name":"result"}}],[5,"set_current_dir","","Changes the current working directory to the specified path.",null,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[5,"vars","","Returns an iterator of (variable, value) pairs of strings, for all the environment variables of the current process.",null,{"inputs":[],"output":{"name":"vars"}}],[5,"vars_os","","Returns an iterator of (variable, value) pairs of OS strings, for all the environment variables of the current process.",null,{"inputs":[],"output":{"name":"varsos"}}],[5,"var","","Fetches the environment variable `key` from the current process.",null,{"inputs":[{"name":"k"}],"output":{"name":"result"}}],[5,"var_os","","Fetches the environment variable `key` from the current process, returning [`None`] if the variable isn't set.",null,{"inputs":[{"name":"k"}],"output":{"name":"option"}}],[5,"set_var","","Sets the environment variable `k` to the value `v` for the currently running process.",null,{"inputs":[{"name":"k"},{"name":"v"}],"output":null}],[5,"remove_var","","Removes an environment variable from the environment of the currently running process.",null,{"inputs":[{"name":"k"}],"output":null}],[5,"split_paths","","Parses input according to platform conventions for the `PATH` environment variable.",null,{"inputs":[{"name":"t"}],"output":{"name":"splitpaths"}}],[5,"join_paths","","Joins a collection of [`Path`]s appropriately for the `PATH` environment variable.",null,{"inputs":[{"name":"i"}],"output":{"name":"result"}}],[5,"home_dir","","Returns the path of the current user's home directory if known.",null,{"inputs":[],"output":{"name":"option"}}],[5,"temp_dir","","Returns the path of a temporary directory.",null,{"inputs":[],"output":{"name":"pathbuf"}}],[5,"current_exe","","Returns the full filesystem path of the current running executable.",null,{"inputs":[],"output":{"name":"result"}}],[5,"args","","Returns the arguments which this program was started with (normally passed via the command line).",null,{"inputs":[],"output":{"name":"args"}}],[5,"args_os","","Returns the arguments which this program was started with (normally passed via the command line).",null,{"inputs":[],"output":{"name":"argsos"}}],[0,"consts","","Constants associated with the current target",null,null],[17,"ARCH","std::env::consts","A string describing the architecture of the CPU that is currently in use.",null,null],[17,"FAMILY","","The family of the operating system. Example value is `unix`.",null,null],[17,"OS","","A string describing the specific operating system in use. Example value is `linux`.",null,null],[17,"DLL_PREFIX","","Specifies the filename prefix used for shared libraries on this platform. Example value is `lib`.",null,null],[17,"DLL_SUFFIX","","Specifies the filename suffix used for shared libraries on this platform. Example value is `.so`.",null,null],[17,"DLL_EXTENSION","","Specifies the file extension used for shared libraries on this platform that goes after the dot. Example value is `so`.",null,null],[17,"EXE_SUFFIX","","Specifies the filename suffix used for executable binaries on this platform. Example value is `.exe`.",null,null],[17,"EXE_EXTENSION","","Specifies the file extension, if any, used for executable binaries on this platform. Example value is `exe`.",null,null],[11,"next","std::env","",112,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",112,null],[11,"fmt","","",112,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",113,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",113,null],[11,"fmt","","",113,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",111,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",111,{"inputs":[{"name":"self"},{"name":"varerror"}],"output":{"name":"bool"}}],[11,"ne","","",111,{"inputs":[{"name":"self"},{"name":"varerror"}],"output":{"name":"bool"}}],[11,"clone","","",111,{"inputs":[{"name":"self"}],"output":{"name":"varerror"}}],[11,"fmt","","",111,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"description","","",111,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"next","","",114,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",114,null],[11,"fmt","","",114,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",115,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",115,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"description","","",115,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"next","","",116,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",116,null],[11,"len","","",116,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","",116,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"next_back","","",116,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",116,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",117,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",117,null],[11,"len","","",117,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","",117,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"next_back","","",117,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",117,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[0,"error","std","Traits for working with Errors.",null,null],[8,"Error","std::error","Base functionality for all errors in Rust.",null,null],[10,"description","","A short description of the error.",118,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"cause","","The lower-level cause of this error, if any.",118,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"from","std::boxed","",119,{"inputs":[{"name":"e"}],"output":{"name":"box"}}],[11,"from","","",119,{"inputs":[{"name":"e"}],"output":{"name":"box"}}],[11,"from","","",119,{"inputs":[{"name":"string"}],"output":{"name":"box"}}],[11,"from","","",119,{"inputs":[{"name":"string"}],"output":{"name":"box"}}],[11,"from","","",119,{"inputs":[{"name":"str"}],"output":{"name":"box"}}],[11,"from","","",119,{"inputs":[{"name":"str"}],"output":{"name":"box"}}],[11,"from","","",119,{"inputs":[{"name":"cow"}],"output":{"name":"box"}}],[11,"from","","",119,{"inputs":[{"name":"cow"}],"output":{"name":"box"}}],[11,"description","std::str","",120,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"description","","",121,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"description","std::string","",122,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"description","","",123,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"description","","",124,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"description","std::char","",125,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"description","std::boxed","",119,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"cause","","",119,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"description","std::fmt","",126,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"description","std::cell","",127,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"description","","",128,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"description","std::char","",129,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"description","","",130,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"description","std::convert","",131,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"is","std::error","Returns true if the boxed type is the same as `T`",118,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"downcast_ref","","Returns some reference to the boxed value if it is of type `T`, or `None` if it isn't.",118,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"downcast_mut","","Returns some mutable reference to the boxed value if it is of type `T`, or `None` if it isn't.",118,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"is","","Forwards to the method defined on the type `Any`.",118,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"downcast_ref","","Forwards to the method defined on the type `Any`.",118,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"downcast_mut","","Forwards to the method defined on the type `Any`.",118,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"is","","Forwards to the method defined on the type `Any`.",118,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"downcast_ref","","Forwards to the method defined on the type `Any`.",118,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"downcast_mut","","Forwards to the method defined on the type `Any`.",118,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"downcast","","Attempt to downcast the box to a concrete type.",118,{"inputs":[{"name":"box"}],"output":{"name":"result"}}],[11,"downcast","","Attempt to downcast the box to a concrete type.",118,{"inputs":[{"name":"box"}],"output":{"name":"result"}}],[11,"downcast","","Attempt to downcast the box to a concrete type.",118,{"inputs":[{"name":"box"}],"output":{"name":"result"}}],[0,"ffi","std","Utilities related to FFI bindings.",null,null],[3,"CString","std::ffi","A type representing an owned C-compatible string.",null,null],[3,"CStr","","Representation of a borrowed C string.",null,null],[3,"NulError","","An error returned from [`CString::new`] to indicate that a nul byte was found in the vector provided.",null,null],[3,"IntoStringError","","An error returned from [`CString::into_string`] to indicate that a UTF-8 error was encountered during the conversion.",null,null],[3,"FromBytesWithNulError","","An error returned from [`CStr::from_bytes_with_nul`] to indicate that a nul byte was found too early in the slice provided or one wasn't found at all.",null,null],[3,"OsString","","A type that can represent owned, mutable platform-native strings, but is cheaply inter-convertible with Rust strings.",null,null],[3,"OsStr","","Slices into OS strings (see [`OsString`]).",null,null],[11,"eq","","",132,{"inputs":[{"name":"self"},{"name":"cstring"}],"output":{"name":"bool"}}],[11,"ne","","",132,{"inputs":[{"name":"self"},{"name":"cstring"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",132,{"inputs":[{"name":"self"},{"name":"cstring"}],"output":{"name":"option"}}],[11,"lt","","",132,{"inputs":[{"name":"self"},{"name":"cstring"}],"output":{"name":"bool"}}],[11,"le","","",132,{"inputs":[{"name":"self"},{"name":"cstring"}],"output":{"name":"bool"}}],[11,"gt","","",132,{"inputs":[{"name":"self"},{"name":"cstring"}],"output":{"name":"bool"}}],[11,"ge","","",132,{"inputs":[{"name":"self"},{"name":"cstring"}],"output":{"name":"bool"}}],[11,"cmp","","",132,{"inputs":[{"name":"self"},{"name":"cstring"}],"output":{"name":"ordering"}}],[11,"hash","","",132,null],[11,"clone","","",132,{"inputs":[{"name":"self"}],"output":{"name":"cstring"}}],[11,"hash","","",133,null],[11,"clone","","",134,{"inputs":[{"name":"self"}],"output":{"name":"nulerror"}}],[11,"eq","","",134,{"inputs":[{"name":"self"},{"name":"nulerror"}],"output":{"name":"bool"}}],[11,"ne","","",134,{"inputs":[{"name":"self"},{"name":"nulerror"}],"output":{"name":"bool"}}],[11,"fmt","","",134,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",135,{"inputs":[{"name":"self"}],"output":{"name":"frombyteswithnulerror"}}],[11,"eq","","",135,{"inputs":[{"name":"self"},{"name":"frombyteswithnulerror"}],"output":{"name":"bool"}}],[11,"ne","","",135,{"inputs":[{"name":"self"},{"name":"frombyteswithnulerror"}],"output":{"name":"bool"}}],[11,"fmt","","",135,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",136,{"inputs":[{"name":"self"}],"output":{"name":"intostringerror"}}],[11,"eq","","",136,{"inputs":[{"name":"self"},{"name":"intostringerror"}],"output":{"name":"bool"}}],[11,"ne","","",136,{"inputs":[{"name":"self"},{"name":"intostringerror"}],"output":{"name":"bool"}}],[11,"fmt","","",136,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new C-compatible string from a container of bytes.",132,{"inputs":[{"name":"t"}],"output":{"name":"result"}}],[11,"from_vec_unchecked","","Creates a C-compatible string from a byte vector without checking for interior 0 bytes.",132,{"inputs":[{"name":"vec"}],"output":{"name":"cstring"}}],[11,"from_raw","","Retakes ownership of a `CString` that was transferred to C.",132,null],[11,"into_raw","","Transfers ownership of the string to a C caller.",132,null],[11,"into_string","","Converts the `CString` into a [`String`] if it contains valid Unicode data.",132,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"into_bytes","","Returns the underlying byte buffer.",132,{"inputs":[{"name":"self"}],"output":{"name":"vec"}}],[11,"into_bytes_with_nul","","Equivalent to the [`into_bytes`] function except that the returned vector includes the trailing nul byte.",132,{"inputs":[{"name":"self"}],"output":{"name":"vec"}}],[11,"as_bytes","","Returns the contents of this `CString` as a slice of bytes.",132,null],[11,"as_bytes_with_nul","","Equivalent to the [`as_bytes`] function except that the returned slice includes the trailing nul byte.",132,null],[11,"as_c_str","","Extracts a [`CStr`] slice containing the entire string.",132,{"inputs":[{"name":"self"}],"output":{"name":"cstr"}}],[11,"into_boxed_c_str","","Converts this `CString` into a boxed [`CStr`].",132,{"inputs":[{"name":"self"}],"output":{"name":"box"}}],[11,"drop","","",132,{"inputs":[{"name":"self"}],"output":null}],[11,"deref","","",132,{"inputs":[{"name":"self"}],"output":{"name":"cstr"}}],[11,"fmt","","",132,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"from","std::vec","",137,{"inputs":[{"name":"cstring"}],"output":{"name":"vec"}}],[11,"fmt","std::ffi","",133,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"default","","Creates an empty `CString`.",132,{"inputs":[],"output":{"name":"cstring"}}],[11,"borrow","","",132,{"inputs":[{"name":"self"}],"output":{"name":"cstr"}}],[11,"from","std::boxed","",119,{"inputs":[{"name":"cstr"}],"output":{"name":"box"}}],[11,"from","std::ffi","",132,{"inputs":[{"name":"box"}],"output":{"name":"cstring"}}],[11,"from","std::boxed","",119,{"inputs":[{"name":"cstring"}],"output":{"name":"box"}}],[11,"default","","",119,{"inputs":[],"output":{"name":"box"}}],[11,"nul_position","std::ffi","Returns the position of the nul byte in the slice that was provided to [`CString::new`].",134,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"into_vec","","Consumes this error, returning the underlying vector of bytes which generated the error in the first place.",134,{"inputs":[{"name":"self"}],"output":{"name":"vec"}}],[11,"description","","",134,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"fmt","","",134,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"description","","",135,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"fmt","","",135,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"into_cstring","","Consumes this error, returning original [`CString`] which generated the error.",136,{"inputs":[{"name":"self"}],"output":{"name":"cstring"}}],[11,"utf8_error","","Access the underlying UTF-8 error that was the cause of this error.",136,{"inputs":[{"name":"self"}],"output":{"name":"utf8error"}}],[11,"description","","",136,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"cause","","",136,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",136,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"from_ptr","","Casts a raw C string to a safe C string wrapper.",133,null],[11,"from_bytes_with_nul","","Creates a C string wrapper from a byte slice.",133,null],[11,"from_bytes_with_nul_unchecked","","Unsafely creates a C string wrapper from a byte slice.",133,null],[11,"as_ptr","","Returns the inner pointer to this C string.",133,null],[11,"to_bytes","","Converts this C string to a byte slice.",133,null],[11,"to_bytes_with_nul","","Converts this C string to a byte slice containing the trailing 0 byte.",133,null],[11,"to_str","","Yields a [`&str`] slice if the `CStr` contains valid UTF-8.",133,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"to_string_lossy","","Converts a `CStr` into a [`Cow`]`<`[`str`]`>`.",133,{"inputs":[{"name":"self"}],"output":{"name":"cow"}}],[11,"into_c_string","","Converts a [`Box`]`<CStr>` into a [`CString`] without copying or allocating.",133,{"inputs":[{"name":"box"}],"output":{"name":"cstring"}}],[11,"eq","","",133,{"inputs":[{"name":"self"},{"name":"cstr"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",133,{"inputs":[{"name":"self"},{"name":"cstr"}],"output":{"name":"option"}}],[11,"cmp","","",133,{"inputs":[{"name":"self"},{"name":"cstr"}],"output":{"name":"ordering"}}],[11,"to_owned","","",133,{"inputs":[{"name":"self"}],"output":{"name":"cstring"}}],[11,"from","","",132,{"inputs":[{"name":"cstr"}],"output":{"name":"cstring"}}],[11,"index","","",132,{"inputs":[{"name":"self"},{"name":"rangefull"}],"output":{"name":"cstr"}}],[11,"as_ref","","",133,{"inputs":[{"name":"self"}],"output":{"name":"cstr"}}],[11,"as_ref","","",132,{"inputs":[{"name":"self"}],"output":{"name":"cstr"}}],[11,"clone","","",138,{"inputs":[{"name":"self"}],"output":{"name":"osstring"}}],[11,"new","","Constructs a new empty `OsString`.",138,{"inputs":[],"output":{"name":"osstring"}}],[11,"as_os_str","","Converts to an [`OsStr`] slice.",138,{"inputs":[{"name":"self"}],"output":{"name":"osstr"}}],[11,"into_string","","Converts the `OsString` into a [`String`] if it contains valid Unicode data.",138,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"push","","Extends the string with the given [`&OsStr`] slice.",138,{"inputs":[{"name":"self"},{"name":"t"}],"output":null}],[11,"with_capacity","","Creates a new `OsString` with the given capacity.",138,{"inputs":[{"name":"usize"}],"output":{"name":"osstring"}}],[11,"clear","","Truncates the `OsString` to zero length.",138,{"inputs":[{"name":"self"}],"output":null}],[11,"capacity","","Returns the capacity this `OsString` can hold without reallocating.",138,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"reserve","","Reserves capacity for at least `additional` more capacity to be inserted in the given `OsString`.",138,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"reserve_exact","","Reserves the minimum capacity for exactly `additional` more capacity to be inserted in the given `OsString`. Does nothing if the capacity is already sufficient.",138,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shrink_to_fit","","Shrinks the capacity of the `OsString` to match its length.",138,{"inputs":[{"name":"self"}],"output":null}],[11,"into_boxed_os_str","","Converts this `OsString` into a boxed [`OsStr`].",138,{"inputs":[{"name":"self"}],"output":{"name":"box"}}],[11,"from","","",138,{"inputs":[{"name":"string"}],"output":{"name":"osstring"}}],[11,"from","","",138,{"inputs":[{"name":"t"}],"output":{"name":"osstring"}}],[11,"index","","",138,{"inputs":[{"name":"self"},{"name":"rangefull"}],"output":{"name":"osstr"}}],[11,"deref","","",138,{"inputs":[{"name":"self"}],"output":{"name":"osstr"}}],[11,"default","","Constructs an empty `OsString`.",138,{"inputs":[],"output":{"name":"osstring"}}],[11,"fmt","","",138,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",138,{"inputs":[{"name":"self"},{"name":"osstring"}],"output":{"name":"bool"}}],[11,"eq","","",138,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",138,{"inputs":[{"name":"self"},{"name":"osstring"}],"output":{"name":"option"}}],[11,"lt","","",138,{"inputs":[{"name":"self"},{"name":"osstring"}],"output":{"name":"bool"}}],[11,"le","","",138,{"inputs":[{"name":"self"},{"name":"osstring"}],"output":{"name":"bool"}}],[11,"gt","","",138,{"inputs":[{"name":"self"},{"name":"osstring"}],"output":{"name":"bool"}}],[11,"ge","","",138,{"inputs":[{"name":"self"},{"name":"osstring"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",138,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"option"}}],[11,"cmp","","",138,{"inputs":[{"name":"self"},{"name":"osstring"}],"output":{"name":"ordering"}}],[11,"hash","","",138,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"new","","Coerces into an `OsStr` slice.",139,{"inputs":[{"name":"s"}],"output":{"name":"osstr"}}],[11,"to_str","","Yields a [`&str`] slice if the `OsStr` is valid Unicode.",139,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"to_string_lossy","","Converts an `OsStr` to a [`Cow`]`<`[`str`]`>`.",139,{"inputs":[{"name":"self"}],"output":{"name":"cow"}}],[11,"to_os_string","","Copies the slice into an owned [`OsString`].",139,{"inputs":[{"name":"self"}],"output":{"name":"osstring"}}],[11,"is_empty","","Checks whether the `OsStr` is empty.",139,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"len","","Returns the length of this `OsStr`.",139,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"into_os_string","","Converts a [`Box`]`<OsStr>` into an [`OsString`] without copying or allocating.",139,{"inputs":[{"name":"box"}],"output":{"name":"osstring"}}],[11,"from","std::boxed","",119,{"inputs":[{"name":"osstr"}],"output":{"name":"box"}}],[11,"from","std::ffi","",138,{"inputs":[{"name":"box"}],"output":{"name":"osstring"}}],[11,"from","std::boxed","",119,{"inputs":[{"name":"osstring"}],"output":{"name":"box"}}],[11,"default","","",119,{"inputs":[],"output":{"name":"box"}}],[11,"eq","std::ffi","",139,{"inputs":[{"name":"self"},{"name":"osstr"}],"output":{"name":"bool"}}],[11,"eq","","",139,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",139,{"inputs":[{"name":"self"},{"name":"osstr"}],"output":{"name":"option"}}],[11,"lt","","",139,{"inputs":[{"name":"self"},{"name":"osstr"}],"output":{"name":"bool"}}],[11,"le","","",139,{"inputs":[{"name":"self"},{"name":"osstr"}],"output":{"name":"bool"}}],[11,"gt","","",139,{"inputs":[{"name":"self"},{"name":"osstr"}],"output":{"name":"bool"}}],[11,"ge","","",139,{"inputs":[{"name":"self"},{"name":"osstr"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",139,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"option"}}],[11,"cmp","","",139,{"inputs":[{"name":"self"},{"name":"osstr"}],"output":{"name":"ordering"}}],[11,"eq","","",138,{"inputs":[{"name":"self"},{"name":"osstr"}],"output":{"name":"bool"}}],[11,"eq","","",139,{"inputs":[{"name":"self"},{"name":"osstring"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",138,{"inputs":[{"name":"self"},{"name":"osstr"}],"output":{"name":"option"}}],[11,"partial_cmp","","",139,{"inputs":[{"name":"self"},{"name":"osstring"}],"output":{"name":"option"}}],[11,"eq","","",138,{"inputs":[{"name":"self"},{"name":"osstr"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",138,{"inputs":[{"name":"self"},{"name":"osstr"}],"output":{"name":"option"}}],[11,"eq","std::borrow","",74,{"inputs":[{"name":"self"},{"name":"osstr"}],"output":{"name":"bool"}}],[11,"eq","std::ffi","",139,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"bool"}}],[11,"partial_cmp","std::borrow","",74,{"inputs":[{"name":"self"},{"name":"osstr"}],"output":{"name":"option"}}],[11,"partial_cmp","std::ffi","",139,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"option"}}],[11,"eq","std::borrow","",74,{"inputs":[{"name":"self"},{"name":"osstr"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",74,{"inputs":[{"name":"self"},{"name":"osstr"}],"output":{"name":"option"}}],[11,"eq","","",74,{"inputs":[{"name":"self"},{"name":"osstring"}],"output":{"name":"bool"}}],[11,"eq","std::ffi","",138,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"bool"}}],[11,"partial_cmp","std::borrow","",74,{"inputs":[{"name":"self"},{"name":"osstring"}],"output":{"name":"option"}}],[11,"partial_cmp","std::ffi","",138,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"option"}}],[11,"hash","","",139,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"fmt","","",139,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"borrow","","",138,{"inputs":[{"name":"self"}],"output":{"name":"osstr"}}],[11,"to_owned","","",139,{"inputs":[{"name":"self"}],"output":{"name":"osstring"}}],[11,"clone_into","","",139,{"inputs":[{"name":"self"},{"name":"osstring"}],"output":null}],[11,"as_ref","","",139,{"inputs":[{"name":"self"}],"output":{"name":"osstr"}}],[11,"as_ref","","",138,{"inputs":[{"name":"self"}],"output":{"name":"osstr"}}],[11,"as_ref","std::string","",140,{"inputs":[{"name":"self"}],"output":{"name":"osstr"}}],[0,"fs","std","Filesystem manipulation operations.",null,null],[3,"File","std::fs","A reference to an open file on the filesystem.",null,null],[3,"Metadata","","Metadata information about a file.",null,null],[3,"ReadDir","","Iterator over the entries in a directory.",null,null],[3,"DirEntry","","Entries returned by the [`ReadDir`] iterator.",null,null],[3,"OpenOptions","","Options and flags which can be used to configure how a file is opened.",null,null],[3,"Permissions","","Representation of the various permissions on a file.",null,null],[3,"FileType","","A structure representing a type of file with accessors for each file type. It is returned by [`Metadata::file_type`] method.",null,null],[3,"DirBuilder","","A builder used to create directories in various manners.",null,null],[5,"remove_file","","Removes a file from the filesystem.",null,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[5,"metadata","","Given a path, query the file system to get information about a file, directory, etc.",null,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[5,"symlink_metadata","","Query the metadata about a file without following symlinks.",null,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[5,"rename","","Rename a file or directory to a new name, replacing the original file if `to` already exists.",null,{"inputs":[{"name":"p"},{"name":"q"}],"output":{"name":"result"}}],[5,"copy","","Copies the contents of one file to another. This function will also copy the permission bits of the original file to the destination file.",null,{"inputs":[{"name":"p"},{"name":"q"}],"output":{"name":"result"}}],[5,"hard_link","","Creates a new hard link on the filesystem.",null,{"inputs":[{"name":"p"},{"name":"q"}],"output":{"name":"result"}}],[5,"soft_link","","Creates a new symbolic link on the filesystem.",null,{"inputs":[{"name":"p"},{"name":"q"}],"output":{"name":"result"}}],[5,"read_link","","Reads a symbolic link, returning the file that the link points to.",null,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[5,"canonicalize","","Returns the canonical form of a path with all intermediate components normalized and symbolic links resolved.",null,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[5,"create_dir","","Creates a new, empty directory at the provided path",null,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[5,"create_dir_all","","Recursively create a directory and all of its parent components if they are missing.",null,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[5,"remove_dir","","Removes an existing, empty directory.",null,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[5,"remove_dir_all","","Removes a directory at this path, after removing all its contents. Use carefully!",null,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[5,"read_dir","","Returns an iterator over the entries within a directory.",null,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[5,"set_permissions","","Changes the permissions found on a file or a directory.",null,{"inputs":[{"name":"p"},{"name":"permissions"}],"output":{"name":"result"}}],[11,"clone","","",141,{"inputs":[{"name":"self"}],"output":{"name":"metadata"}}],[11,"fmt","","",142,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",143,{"inputs":[{"name":"self"}],"output":{"name":"openoptions"}}],[11,"fmt","","",143,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",144,{"inputs":[{"name":"self"}],"output":{"name":"permissions"}}],[11,"eq","","",144,{"inputs":[{"name":"self"},{"name":"permissions"}],"output":{"name":"bool"}}],[11,"ne","","",144,{"inputs":[{"name":"self"},{"name":"permissions"}],"output":{"name":"bool"}}],[11,"fmt","","",144,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",145,{"inputs":[{"name":"self"}],"output":{"name":"filetype"}}],[11,"eq","","",145,{"inputs":[{"name":"self"},{"name":"filetype"}],"output":{"name":"bool"}}],[11,"ne","","",145,{"inputs":[{"name":"self"},{"name":"filetype"}],"output":{"name":"bool"}}],[11,"hash","","",145,null],[11,"fmt","","",145,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",146,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"open","","Attempts to open a file in read-only mode.",147,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[11,"create","","Opens a file in write-only mode.",147,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[11,"sync_all","","Attempts to sync all OS-internal metadata to disk.",147,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"sync_data","","This function is similar to [`sync_all`], except that it may not synchronize file metadata to the filesystem.",147,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"set_len","","Truncates or extends the underlying file, updating the size of this file to become `size`.",147,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"result"}}],[11,"metadata","","Queries metadata about the underlying file.",147,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"try_clone","","Creates a new independently owned handle to the underlying file.",147,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"set_permissions","","Changes the permissions on the underlying file.",147,{"inputs":[{"name":"self"},{"name":"permissions"}],"output":{"name":"result"}}],[11,"fmt","","",147,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"read","","",147,null],[11,"initializer","","",147,{"inputs":[{"name":"self"}],"output":{"name":"initializer"}}],[11,"write","","",147,null],[11,"flush","","",147,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"seek","","",147,{"inputs":[{"name":"self"},{"name":"seekfrom"}],"output":{"name":"result"}}],[11,"new","","Creates a blank new set of options ready for configuration.",143,{"inputs":[],"output":{"name":"openoptions"}}],[11,"read","","Sets the option for read access.",143,{"inputs":[{"name":"self"},{"name":"bool"}],"output":{"name":"openoptions"}}],[11,"write","","Sets the option for write access.",143,{"inputs":[{"name":"self"},{"name":"bool"}],"output":{"name":"openoptions"}}],[11,"append","","Sets the option for the append mode.",143,{"inputs":[{"name":"self"},{"name":"bool"}],"output":{"name":"openoptions"}}],[11,"truncate","","Sets the option for truncating a previous file.",143,{"inputs":[{"name":"self"},{"name":"bool"}],"output":{"name":"openoptions"}}],[11,"create","","Sets the option for creating a new file.",143,{"inputs":[{"name":"self"},{"name":"bool"}],"output":{"name":"openoptions"}}],[11,"create_new","","Sets the option to always create a new file.",143,{"inputs":[{"name":"self"},{"name":"bool"}],"output":{"name":"openoptions"}}],[11,"open","","Opens a file at `path` with the options specified by `self`.",143,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"result"}}],[11,"file_type","","Returns the file type for this metadata.",141,{"inputs":[{"name":"self"}],"output":{"name":"filetype"}}],[11,"is_dir","","Returns whether this metadata is for a directory.",141,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_file","","Returns whether this metadata is for a regular file.",141,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"len","","Returns the size of the file, in bytes, this metadata is for.",141,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"permissions","","Returns the permissions of the file this metadata is for.",141,{"inputs":[{"name":"self"}],"output":{"name":"permissions"}}],[11,"modified","","Returns the last modification time listed in this metadata.",141,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"accessed","","Returns the last access time of this metadata.",141,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"created","","Returns the creation time listed in the this metadata.",141,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"fmt","","",141,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"readonly","","Returns whether these permissions describe a readonly (unwritable) file.",144,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"set_readonly","","Modifies the readonly flag for this set of permissions. If the `readonly` argument is `true`, using the resulting `Permission` will update file permissions to forbid writing. Conversely, if it's `false`, using the resulting `Permission` will update file permissions to allow writing.",144,{"inputs":[{"name":"self"},{"name":"bool"}],"output":null}],[11,"is_dir","","Test whether this file type represents a directory.",145,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_file","","Test whether this file type represents a regular file.",145,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_symlink","","Test whether this file type represents a symbolic link.",145,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"next","","",142,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"path","","Returns the full path to the file that this entry represents.",148,{"inputs":[{"name":"self"}],"output":{"name":"pathbuf"}}],[11,"metadata","","Return the metadata for the file that this entry points at.",148,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"file_type","","Return the file type for the file that this entry points at.",148,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"file_name","","Returns the bare file name of this directory entry without any other leading path component.",148,{"inputs":[{"name":"self"}],"output":{"name":"osstring"}}],[11,"fmt","","",148,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new set of options with default mode/security settings for all platforms and also non-recursive.",146,{"inputs":[],"output":{"name":"dirbuilder"}}],[11,"recursive","","Indicates that directories should be created recursively, creating all parent directories. Parents that do not exist are created with the same security and permissions settings.",146,{"inputs":[{"name":"self"},{"name":"bool"}],"output":{"name":"self"}}],[11,"create","","Create the specified directory with the options configured in this builder.",146,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"result"}}],[0,"io","std","Traits, helpers, and type definitions for core I/O functionality.",null,null],[3,"BufReader","std::io","The `BufReader` struct adds buffering to any reader.",null,null],[3,"BufWriter","","Wraps a writer and buffers its output.",null,null],[3,"LineWriter","","Wraps a writer and buffers output to it, flushing whenever a newline (`0x0a`, `'\\n'`) is detected.",null,null],[3,"IntoInnerError","","An error returned by `into_inner` which combines an error that happened while writing out the buffer, and the buffered writer object which may be used to recover from the condition.",null,null],[3,"Cursor","","A `Cursor` wraps another type and provides it with a [`Seek`] implementation.",null,null],[3,"Error","","The error type for I/O operations of the [`Read`], [`Write`], [`Seek`], and associated traits.",null,null],[3,"Sink","","A writer which will move data into the void.",null,null],[3,"Empty","","A reader which is always at EOF.",null,null],[3,"Repeat","","A reader which yields one byte over and over and over and over and over and...",null,null],[3,"Stdin","","A handle to the standard input stream of a process.",null,null],[3,"Stdout","","A handle to the global standard output stream of the current process.",null,null],[3,"Stderr","","A handle to the standard error stream of a process.",null,null],[3,"StdoutLock","","A locked reference to the `Stdout` handle.",null,null],[3,"StderrLock","","A locked reference to the `Stderr` handle.",null,null],[3,"StdinLock","","A locked reference to the `Stdin` handle.",null,null],[3,"Initializer","","A type used to conditionally initialize buffers passed to `Read` methods.",null,null],[3,"Chain","","Adaptor to chain together two readers.",null,null],[3,"Take","","Reader adaptor which limits the bytes read from an underlying reader.",null,null],[3,"Bytes","","An iterator over `u8` values of a reader.",null,null],[3,"Chars","","An iterator over the `char`s of a reader.",null,null],[3,"Split","","An iterator over the contents of an instance of `BufRead` split on a particular byte.",null,null],[3,"Lines","","An iterator over the lines of an instance of `BufRead`.",null,null],[4,"ErrorKind","","A list specifying general categories of I/O error.",null,null],[13,"NotFound","","An entity was not found, often a file.",149,null],[13,"PermissionDenied","","The operation lacked the necessary privileges to complete.",149,null],[13,"ConnectionRefused","","The connection was refused by the remote server.",149,null],[13,"ConnectionReset","","The connection was reset by the remote server.",149,null],[13,"ConnectionAborted","","The connection was aborted (terminated) by the remote server.",149,null],[13,"NotConnected","","The network operation failed because it was not connected yet.",149,null],[13,"AddrInUse","","A socket address could not be bound because the address is already in use elsewhere.",149,null],[13,"AddrNotAvailable","","A nonexistent interface was requested or the requested address was not local.",149,null],[13,"BrokenPipe","","The operation failed because a pipe was closed.",149,null],[13,"AlreadyExists","","An entity already exists, often a file.",149,null],[13,"WouldBlock","","The operation needs to block to complete, but the blocking operation was requested to not occur.",149,null],[13,"InvalidInput","","A parameter was incorrect.",149,null],[13,"InvalidData","","Data not valid for the operation were encountered.",149,null],[13,"TimedOut","","The I/O operation's timeout expired, causing it to be canceled.",149,null],[13,"WriteZero","","An error returned when an operation could not be completed because a call to [`write`] returned [`Ok(0)`].",149,null],[13,"Interrupted","","This operation was interrupted.",149,null],[13,"Other","","Any I/O error not part of this list.",149,null],[13,"UnexpectedEof","","An error returned when an operation could not be completed because an \"end of file\" was reached prematurely.",149,null],[4,"SeekFrom","","Enumeration of possible methods to seek within an I/O object.",null,null],[13,"Start","","Set the offset to the provided number of bytes.",150,null],[13,"End","","Set the offset to the size of this object plus the specified number of bytes.",150,null],[13,"Current","","Set the offset to the current position plus the specified number of bytes.",150,null],[4,"CharsError","","An enumeration of possible errors that can be generated from the `Chars` adapter.",null,null],[13,"NotUtf8","","Variant representing that the underlying stream was read successfully but it did not contain valid utf8 data.",151,null],[13,"Other","","Variant representing that an I/O error occurred.",151,null],[5,"copy","","Copies the entire contents of a reader into a writer.",null,{"inputs":[{"name":"r"},{"name":"w"}],"output":{"name":"result"}}],[5,"sink","","Creates an instance of a writer which will successfully consume all data.",null,{"inputs":[],"output":{"name":"sink"}}],[5,"empty","","Constructs a new handle to an empty reader.",null,{"inputs":[],"output":{"name":"empty"}}],[5,"repeat","","Creates an instance of a reader that infinitely repeats one byte.",null,{"inputs":[{"name":"u8"}],"output":{"name":"repeat"}}],[5,"stdin","","Constructs a new handle to the standard input of the current process.",null,{"inputs":[],"output":{"name":"stdin"}}],[5,"stdout","","Constructs a new handle to the standard output of the current process.",null,{"inputs":[],"output":{"name":"stdout"}}],[5,"stderr","","Constructs a new handle to the standard error of the current process.",null,{"inputs":[],"output":{"name":"stderr"}}],[0,"prelude","","The I/O Prelude",null,null],[11,"new","","Creates a new `BufReader` with a default buffer capacity.",152,{"inputs":[{"name":"r"}],"output":{"name":"bufreader"}}],[11,"with_capacity","","Creates a new `BufReader` with the specified buffer capacity.",152,{"inputs":[{"name":"usize"},{"name":"r"}],"output":{"name":"bufreader"}}],[11,"get_ref","","Gets a reference to the underlying reader.",152,{"inputs":[{"name":"self"}],"output":{"name":"r"}}],[11,"get_mut","","Gets a mutable reference to the underlying reader.",152,{"inputs":[{"name":"self"}],"output":{"name":"r"}}],[11,"into_inner","","Unwraps this `BufReader`, returning the underlying reader.",152,{"inputs":[{"name":"self"}],"output":{"name":"r"}}],[11,"read","","",152,null],[11,"initializer","","",152,{"inputs":[{"name":"self"}],"output":{"name":"initializer"}}],[11,"fill_buf","","",152,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"consume","","",152,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"fmt","","",152,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"seek","","Seek to an offset, in bytes, in the underlying reader.",152,{"inputs":[{"name":"self"},{"name":"seekfrom"}],"output":{"name":"result"}}],[11,"fmt","","",153,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new `BufWriter` with a default buffer capacity.",154,{"inputs":[{"name":"w"}],"output":{"name":"bufwriter"}}],[11,"with_capacity","","Creates a new `BufWriter` with the specified buffer capacity.",154,{"inputs":[{"name":"usize"},{"name":"w"}],"output":{"name":"bufwriter"}}],[11,"get_ref","","Gets a reference to the underlying writer.",154,{"inputs":[{"name":"self"}],"output":{"name":"w"}}],[11,"get_mut","","Gets a mutable reference to the underlying writer.",154,{"inputs":[{"name":"self"}],"output":{"name":"w"}}],[11,"into_inner","","Unwraps this `BufWriter`, returning the underlying writer.",154,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"write","","",154,null],[11,"flush","","",154,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"fmt","","",154,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"seek","","Seek to the offset, in bytes, in the underlying writer.",154,{"inputs":[{"name":"self"},{"name":"seekfrom"}],"output":{"name":"result"}}],[11,"drop","","",154,{"inputs":[{"name":"self"}],"output":null}],[11,"error","","Returns the error which caused the call to `into_inner()` to fail.",153,{"inputs":[{"name":"self"}],"output":{"name":"error"}}],[11,"into_inner","","Returns the buffered writer instance which generated the error.",153,{"inputs":[{"name":"self"}],"output":{"name":"w"}}],[11,"from","","",155,{"inputs":[{"name":"intoinnererror"}],"output":{"name":"error"}}],[11,"description","","",153,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"fmt","","",153,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new `LineWriter`.",156,{"inputs":[{"name":"w"}],"output":{"name":"linewriter"}}],[11,"with_capacity","","Creates a new `LineWriter` with a specified capacity for the internal buffer.",156,{"inputs":[{"name":"usize"},{"name":"w"}],"output":{"name":"linewriter"}}],[11,"get_ref","","Gets a reference to the underlying writer.",156,{"inputs":[{"name":"self"}],"output":{"name":"w"}}],[11,"get_mut","","Gets a mutable reference to the underlying writer.",156,{"inputs":[{"name":"self"}],"output":{"name":"w"}}],[11,"into_inner","","Unwraps this `LineWriter`, returning the underlying writer.",156,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"write","","",156,null],[11,"flush","","",156,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"fmt","","",156,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",157,{"inputs":[{"name":"self"}],"output":{"name":"cursor"}}],[11,"fmt","","",157,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new cursor wrapping the provided underlying I/O object.",157,{"inputs":[{"name":"t"}],"output":{"name":"cursor"}}],[11,"into_inner","","Consumes this cursor, returning the underlying value.",157,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"get_ref","","Gets a reference to the underlying value in this cursor.",157,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"get_mut","","Gets a mutable reference to the underlying value in this cursor.",157,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"position","","Returns the current position of this cursor.",157,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"set_position","","Sets the position of this cursor.",157,{"inputs":[{"name":"self"},{"name":"u64"}],"output":null}],[11,"seek","","",157,{"inputs":[{"name":"self"},{"name":"seekfrom"}],"output":{"name":"result"}}],[11,"read","","",157,null],[11,"initializer","","",157,{"inputs":[{"name":"self"}],"output":{"name":"initializer"}}],[11,"fill_buf","","",157,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"consume","","",157,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"write","","",157,null],[11,"flush","","",157,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"write","","",157,null],[11,"flush","","",157,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"write","","",157,null],[11,"flush","","",157,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"fmt","","",155,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",149,{"inputs":[{"name":"self"}],"output":{"name":"errorkind"}}],[11,"fmt","","",149,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",149,null],[11,"cmp","","",149,{"inputs":[{"name":"self"},{"name":"errorkind"}],"output":{"name":"ordering"}}],[11,"eq","","",149,{"inputs":[{"name":"self"},{"name":"errorkind"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",149,{"inputs":[{"name":"self"},{"name":"errorkind"}],"output":{"name":"option"}}],[11,"from","","",155,{"inputs":[{"name":"errorkind"}],"output":{"name":"error"}}],[11,"new","","Creates a new I/O error from a known kind of error as well as an arbitrary error payload.",155,{"inputs":[{"name":"errorkind"},{"name":"e"}],"output":{"name":"error"}}],[11,"last_os_error","","Returns an error representing the last OS error which occurred.",155,{"inputs":[],"output":{"name":"error"}}],[11,"from_raw_os_error","","Creates a new instance of an `Error` from a particular OS error code.",155,{"inputs":[{"name":"i32"}],"output":{"name":"error"}}],[11,"raw_os_error","","Returns the OS error that this error represents (if any).",155,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"get_ref","","Returns a reference to the inner error wrapped by this error (if any).",155,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"get_mut","","Returns a mutable reference to the inner error wrapped by this error (if any).",155,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"into_inner","","Consumes the `Error`, returning its inner error (if any).",155,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"kind","","Returns the corresponding `ErrorKind` for this error.",155,{"inputs":[{"name":"self"}],"output":{"name":"errorkind"}}],[11,"fmt","","",155,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"description","","",155,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"cause","","",155,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"read","std::boxed","",119,null],[11,"initializer","","",119,{"inputs":[{"name":"self"}],"output":{"name":"initializer"}}],[11,"read_to_end","","",119,{"inputs":[{"name":"self"},{"name":"vec"}],"output":{"name":"result"}}],[11,"read_to_string","","",119,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"result"}}],[11,"read_exact","","",119,null],[11,"write","","",119,null],[11,"flush","","",119,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"write_all","","",119,null],[11,"write_fmt","","",119,{"inputs":[{"name":"self"},{"name":"arguments"}],"output":{"name":"result"}}],[11,"seek","","",119,{"inputs":[{"name":"self"},{"name":"seekfrom"}],"output":{"name":"result"}}],[11,"fill_buf","","",119,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"consume","","",119,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"read_until","","",119,{"inputs":[{"name":"self"},{"name":"u8"},{"name":"vec"}],"output":{"name":"result"}}],[11,"read_line","","",119,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"result"}}],[11,"write","std::vec","",137,null],[11,"write_all","","",137,null],[11,"flush","","",137,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"read","std::io","",158,null],[11,"initializer","","",158,{"inputs":[{"name":"self"}],"output":{"name":"initializer"}}],[11,"fill_buf","","",158,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"consume","","",158,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"fmt","","",158,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"read","","",159,null],[11,"initializer","","",159,{"inputs":[{"name":"self"}],"output":{"name":"initializer"}}],[11,"fmt","","",159,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"write","","",160,null],[11,"flush","","",160,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"fmt","","",160,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"lock","","Locks this handle to the standard input stream, returning a readable guard.",161,{"inputs":[{"name":"self"}],"output":{"name":"stdinlock"}}],[11,"read_line","","Locks this handle and reads a line of input into the specified buffer.",161,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"result"}}],[11,"fmt","","",161,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"read","","",161,null],[11,"initializer","","",161,{"inputs":[{"name":"self"}],"output":{"name":"initializer"}}],[11,"read_to_end","","",161,{"inputs":[{"name":"self"},{"name":"vec"}],"output":{"name":"result"}}],[11,"read_to_string","","",161,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"result"}}],[11,"read_exact","","",161,null],[11,"read","","",162,null],[11,"initializer","","",162,{"inputs":[{"name":"self"}],"output":{"name":"initializer"}}],[11,"fill_buf","","",162,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"consume","","",162,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"fmt","","",162,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"lock","","Locks this handle to the standard output stream, returning a writable guard.",163,{"inputs":[{"name":"self"}],"output":{"name":"stdoutlock"}}],[11,"fmt","","",163,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"write","","",163,null],[11,"flush","","",163,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"write_all","","",163,null],[11,"write_fmt","","",163,{"inputs":[{"name":"self"},{"name":"arguments"}],"output":{"name":"result"}}],[11,"write","","",164,null],[11,"flush","","",164,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"fmt","","",164,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"lock","","Locks this handle to the standard error stream, returning a writable guard.",165,{"inputs":[{"name":"self"}],"output":{"name":"stderrlock"}}],[11,"fmt","","",165,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"write","","",165,null],[11,"flush","","",165,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"write_all","","",165,null],[11,"write_fmt","","",165,{"inputs":[{"name":"self"},{"name":"arguments"}],"output":{"name":"result"}}],[11,"write","","",166,null],[11,"flush","","",166,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"fmt","","",166,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[6,"Result","","A specialized `Result` type for I/O operations.",null,null],[8,"Read","","The `Read` trait allows for reading bytes from a source.",null,null],[10,"read","","Pull some bytes from this source into the specified buffer, returning how many bytes were read.",167,null],[11,"initializer","","Determines if this `Read`er can work with buffers of uninitialized memory.",167,{"inputs":[{"name":"self"}],"output":{"name":"initializer"}}],[11,"read_to_end","","Read all bytes until EOF in this source, placing them into `buf`.",167,{"inputs":[{"name":"self"},{"name":"vec"}],"output":{"name":"result"}}],[11,"read_to_string","","Read all bytes until EOF in this source, placing them into `buf`.",167,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"result"}}],[11,"read_exact","","Read the exact number of bytes required to fill `buf`.",167,null],[11,"by_ref","","Creates a \"by reference\" adaptor for this instance of `Read`.",167,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"bytes","","Transforms this `Read` instance to an [`Iterator`] over its bytes.",167,{"inputs":[{"name":"self"}],"output":{"name":"bytes"}}],[11,"chars","","Transforms this `Read` instance to an [`Iterator`] over [`char`]s.",167,{"inputs":[{"name":"self"}],"output":{"name":"chars"}}],[11,"chain","","Creates an adaptor which will chain this stream with another.",167,{"inputs":[{"name":"self"},{"name":"r"}],"output":{"name":"chain"}}],[11,"take","","Creates an adaptor which will read at most `limit` bytes from it.",167,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"take"}}],[8,"Write","","A trait for objects which are byte-oriented sinks.",null,null],[10,"write","","Write a buffer into this object, returning how many bytes were written.",168,null],[10,"flush","","Flush this output stream, ensuring that all intermediately buffered contents reach their destination.",168,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"write_all","","Attempts to write an entire buffer into this write.",168,null],[11,"write_fmt","","Writes a formatted string into this writer, returning any error encountered.",168,{"inputs":[{"name":"self"},{"name":"arguments"}],"output":{"name":"result"}}],[11,"by_ref","","Creates a \"by reference\" adaptor for this instance of `Write`.",168,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[8,"Seek","","The `Seek` trait provides a cursor which can be moved within a stream of bytes.",null,null],[10,"seek","","Seek to an offset, in bytes, in a stream.",169,{"inputs":[{"name":"self"},{"name":"seekfrom"}],"output":{"name":"result"}}],[8,"BufRead","","A `BufRead` is a type of `Read`er which has an internal buffer, allowing it to perform extra ways of reading.",null,null],[10,"fill_buf","","Fills the internal buffer of this object, returning the buffer contents.",170,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[10,"consume","","Tells this buffer that `amt` bytes have been consumed from the buffer, so they should no longer be returned in calls to `read`.",170,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"read_until","","Read all bytes into `buf` until the delimiter `byte` or EOF is reached.",170,{"inputs":[{"name":"self"},{"name":"u8"},{"name":"vec"}],"output":{"name":"result"}}],[11,"read_line","","Read all bytes until a newline (the 0xA byte) is reached, and append them to the provided buffer.",170,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"result"}}],[11,"split","","Returns an iterator over the contents of this reader split on the byte `byte`.",170,{"inputs":[{"name":"self"},{"name":"u8"}],"output":{"name":"split"}}],[11,"lines","","Returns an iterator over the lines of this reader.",170,{"inputs":[{"name":"self"}],"output":{"name":"lines"}}],[11,"fmt","","",171,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"zeroing","","Returns a new `Initializer` which will zero out buffers.",171,{"inputs":[],"output":{"name":"initializer"}}],[11,"nop","","Returns a new `Initializer` which will not zero out buffers.",171,{"inputs":[],"output":{"name":"initializer"}}],[11,"should_initialize","","Indicates if a buffer should be initialized.",171,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"initialize","","Initializes a buffer if necessary.",171,null],[11,"eq","","",150,{"inputs":[{"name":"self"},{"name":"seekfrom"}],"output":{"name":"bool"}}],[11,"ne","","",150,{"inputs":[{"name":"self"},{"name":"seekfrom"}],"output":{"name":"bool"}}],[11,"clone","","",150,{"inputs":[{"name":"self"}],"output":{"name":"seekfrom"}}],[11,"fmt","","",150,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"into_inner","","Consumes the `Chain`, returning the wrapped readers.",172,null],[11,"get_ref","","Gets references to the underlying readers in this `Chain`.",172,null],[11,"get_mut","","Gets mutable references to the underlying readers in this `Chain`.",172,null],[11,"fmt","","",172,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"read","","",172,null],[11,"initializer","","",172,{"inputs":[{"name":"self"}],"output":{"name":"initializer"}}],[11,"fill_buf","","",172,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"consume","","",172,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"fmt","","",173,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"limit","","Returns the number of bytes that can be read before this instance will return EOF.",173,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"set_limit","","Sets the number of bytes that can be read before this instance will return EOF. This is the same as constructing a new `Take` instance, so the amount of bytes read and the previous limit value don't matter when calling this method.",173,{"inputs":[{"name":"self"},{"name":"u64"}],"output":null}],[11,"into_inner","","Consumes the `Take`, returning the wrapped reader.",173,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"get_ref","","Gets a reference to the underlying reader.",173,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"get_mut","","Gets a mutable reference to the underlying reader.",173,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"read","","",173,null],[11,"initializer","","",173,{"inputs":[{"name":"self"}],"output":{"name":"initializer"}}],[11,"fill_buf","","",173,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"consume","","",173,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"fmt","","",174,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",174,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",175,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",151,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",175,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"description","","",151,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"cause","","",151,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",151,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",176,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",176,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",177,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",177,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[0,"net","std","Networking primitives for TCP/UDP communication.",null,null],[3,"Ipv4Addr","std::net","An IPv4 address.",null,null],[3,"Ipv6Addr","","An IPv6 address.",null,null],[3,"SocketAddrV4","","An IPv4 socket address.",null,null],[3,"SocketAddrV6","","An IPv6 socket address.",null,null],[3,"TcpStream","","A TCP stream between a local and a remote socket.",null,null],[3,"TcpListener","","A TCP socket server, listening for connections.",null,null],[3,"Incoming","","An iterator that infinitely [`accept`]s connections on a [`TcpListener`].",null,null],[3,"UdpSocket","","A UDP socket.",null,null],[3,"AddrParseError","","An error which can be returned when parsing an IP address or a socket address.",null,null],[3,"LookupHost","","An iterator over `SocketAddr` values returned from a host lookup operation.",null,null],[4,"IpAddr","","An IP address, either IPv4 or IPv6.",null,null],[13,"V4","","An IPv4 address.",178,null],[13,"V6","","An IPv6 address.",178,null],[4,"Ipv6MulticastScope","","",null,null],[13,"InterfaceLocal","","",179,null],[13,"LinkLocal","","",179,null],[13,"RealmLocal","","",179,null],[13,"AdminLocal","","",179,null],[13,"SiteLocal","","",179,null],[13,"OrganizationLocal","","",179,null],[13,"Global","","",179,null],[4,"SocketAddr","","An internet socket address, either IPv4 or IPv6.",null,null],[13,"V4","","An IPv4 socket address.",180,null],[13,"V6","","An IPv6 socket address.",180,null],[4,"Shutdown","","Possible values which can be passed to the [`shutdown`] method of [`TcpStream`].",null,null],[13,"Read","","The reading portion of the [`TcpStream`] should be shut down.",181,null],[13,"Write","","The writing portion of the [`TcpStream`] should be shut down.",181,null],[13,"Both","","Both the reading and the writing portions of the [`TcpStream`] should be shut down.",181,null],[5,"lookup_host","","Resolve the host specified by `host` as a number of `SocketAddr` instances.",null,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"clone","","",178,{"inputs":[{"name":"self"}],"output":{"name":"ipaddr"}}],[11,"eq","","",178,{"inputs":[{"name":"self"},{"name":"ipaddr"}],"output":{"name":"bool"}}],[11,"ne","","",178,{"inputs":[{"name":"self"},{"name":"ipaddr"}],"output":{"name":"bool"}}],[11,"fmt","","",178,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",178,null],[11,"partial_cmp","","",178,{"inputs":[{"name":"self"},{"name":"ipaddr"}],"output":{"name":"option"}}],[11,"lt","","",178,{"inputs":[{"name":"self"},{"name":"ipaddr"}],"output":{"name":"bool"}}],[11,"le","","",178,{"inputs":[{"name":"self"},{"name":"ipaddr"}],"output":{"name":"bool"}}],[11,"gt","","",178,{"inputs":[{"name":"self"},{"name":"ipaddr"}],"output":{"name":"bool"}}],[11,"ge","","",178,{"inputs":[{"name":"self"},{"name":"ipaddr"}],"output":{"name":"bool"}}],[11,"cmp","","",178,{"inputs":[{"name":"self"},{"name":"ipaddr"}],"output":{"name":"ordering"}}],[11,"eq","","",179,{"inputs":[{"name":"self"},{"name":"ipv6multicastscope"}],"output":{"name":"bool"}}],[11,"clone","","",179,{"inputs":[{"name":"self"}],"output":{"name":"ipv6multicastscope"}}],[11,"hash","","",179,null],[11,"fmt","","",179,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"is_unspecified","","Returns [`true`] for the special 'unspecified' address.",178,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_loopback","","Returns [`true`] if this is a loopback address.",178,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_global","","Returns [`true`] if the address appears to be globally routable.",178,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_multicast","","Returns [`true`] if this is a multicast address.",178,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_documentation","","Returns [`true`] if this address is in a range designated for documentation.",178,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_ipv4","","Returns [`true`] if this address is an [IPv4 address], and [`false`] otherwise.",178,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_ipv6","","Returns [`true`] if this address is an [IPv6 address], and [`false`] otherwise.",178,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"new","","Creates a new IPv4 address from four eight-bit octets.",182,{"inputs":[{"name":"u8"},{"name":"u8"},{"name":"u8"},{"name":"u8"}],"output":{"name":"ipv4addr"}}],[11,"localhost","","Creates a new IPv4 address with the address pointing to localhost: 127.0.0.1.",182,{"inputs":[],"output":{"name":"ipv4addr"}}],[11,"unspecified","","Creates a new IPv4 address representing an unspecified address: 0.0.0.0",182,{"inputs":[],"output":{"name":"ipv4addr"}}],[11,"octets","","Returns the four eight-bit integers that make up this address.",182,null],[11,"is_unspecified","","Returns [`true`] for the special 'unspecified' address (0.0.0.0).",182,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_loopback","","Returns [`true`] if this is a loopback address (127.0.0.0/8).",182,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_private","","Returns [`true`] if this is a private address.",182,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_link_local","","Returns [`true`] if the address is link-local (169.254.0.0/16).",182,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_global","","Returns [`true`] if the address appears to be globally routable. See [iana-ipv4-special-registry][ipv4-sr].",182,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_multicast","","Returns [`true`] if this is a multicast address (224.0.0.0/4).",182,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_broadcast","","Returns [`true`] if this is a broadcast address (255.255.255.255).",182,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_documentation","","Returns [`true`] if this address is in a range designated for documentation.",182,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"to_ipv6_compatible","","Converts this address to an IPv4-compatible [IPv6 address].",182,{"inputs":[{"name":"self"}],"output":{"name":"ipv6addr"}}],[11,"to_ipv6_mapped","","Converts this address to an IPv4-mapped [IPv6 address].",182,{"inputs":[{"name":"self"}],"output":{"name":"ipv6addr"}}],[11,"fmt","","",178,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"from","","",178,{"inputs":[{"name":"ipv4addr"}],"output":{"name":"ipaddr"}}],[11,"from","","",178,{"inputs":[{"name":"ipv6addr"}],"output":{"name":"ipaddr"}}],[11,"fmt","","",182,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",182,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",182,{"inputs":[{"name":"self"}],"output":{"name":"ipv4addr"}}],[11,"eq","","",182,{"inputs":[{"name":"self"},{"name":"ipv4addr"}],"output":{"name":"bool"}}],[11,"eq","","",178,{"inputs":[{"name":"self"},{"name":"ipv4addr"}],"output":{"name":"bool"}}],[11,"eq","","",182,{"inputs":[{"name":"self"},{"name":"ipaddr"}],"output":{"name":"bool"}}],[11,"hash","","",182,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"partial_cmp","","",182,{"inputs":[{"name":"self"},{"name":"ipv4addr"}],"output":{"name":"option"}}],[11,"partial_cmp","","",178,{"inputs":[{"name":"self"},{"name":"ipv4addr"}],"output":{"name":"option"}}],[11,"partial_cmp","","",182,{"inputs":[{"name":"self"},{"name":"ipaddr"}],"output":{"name":"option"}}],[11,"cmp","","",182,{"inputs":[{"name":"self"},{"name":"ipv4addr"}],"output":{"name":"ordering"}}],[11,"from","","It performs the conversion in network order (big-endian).",182,{"inputs":[{"name":"u32"}],"output":{"name":"ipv4addr"}}],[11,"from","","",182,null],[11,"from","","",178,null],[11,"new","","Creates a new IPv6 address from eight 16-bit segments.",183,{"inputs":[{"name":"u16"},{"name":"u16"},{"name":"u16"},{"name":"u16"},{"name":"u16"},{"name":"u16"},{"name":"u16"},{"name":"u16"}],"output":{"name":"ipv6addr"}}],[11,"localhost","","Creates a new IPv6 address representing localhost: `::1`.",183,{"inputs":[],"output":{"name":"ipv6addr"}}],[11,"unspecified","","Creates a new IPv6 address representing the unspecified address: `::`",183,{"inputs":[],"output":{"name":"ipv6addr"}}],[11,"segments","","Returns the eight 16-bit segments that make up this address.",183,null],[11,"is_unspecified","","Returns [`true`] for the special 'unspecified' address (::).",183,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_loopback","","Returns [`true`] if this is a loopback address (::1).",183,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_global","","Returns [`true`] if the address appears to be globally routable.",183,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_unique_local","","Returns [`true`] if this is a unique local address (fc00::/7).",183,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_unicast_link_local","","Returns [`true`] if the address is unicast and link-local (fe80::/10).",183,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_unicast_site_local","","Returns [`true`] if this is a deprecated unicast site-local address (fec0::/10).",183,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_documentation","","Returns [`true`] if this is an address reserved for documentation (2001:db8::/32).",183,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_unicast_global","","Returns [`true`] if the address is a globally routable unicast address.",183,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"multicast_scope","","Returns the address's multicast scope if the address is multicast.",183,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"is_multicast","","Returns [`true`] if this is a multicast address (ff00::/8).",183,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"to_ipv4","","Converts this address to an [IPv4 address]. Returns [`None`] if this address is neither IPv4-compatible or IPv4-mapped.",183,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"octets","","Returns the sixteen eight-bit integers the IPv6 address consists of.",183,null],[11,"fmt","","",183,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",183,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",183,{"inputs":[{"name":"self"}],"output":{"name":"ipv6addr"}}],[11,"eq","","",183,{"inputs":[{"name":"self"},{"name":"ipv6addr"}],"output":{"name":"bool"}}],[11,"eq","","",183,{"inputs":[{"name":"self"},{"name":"ipaddr"}],"output":{"name":"bool"}}],[11,"eq","","",178,{"inputs":[{"name":"self"},{"name":"ipv6addr"}],"output":{"name":"bool"}}],[11,"hash","","",183,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"partial_cmp","","",183,{"inputs":[{"name":"self"},{"name":"ipv6addr"}],"output":{"name":"option"}}],[11,"partial_cmp","","",178,{"inputs":[{"name":"self"},{"name":"ipv6addr"}],"output":{"name":"option"}}],[11,"partial_cmp","","",183,{"inputs":[{"name":"self"},{"name":"ipaddr"}],"output":{"name":"option"}}],[11,"cmp","","",183,{"inputs":[{"name":"self"},{"name":"ipv6addr"}],"output":{"name":"ordering"}}],[11,"from","","",183,{"inputs":[{"name":"u128"}],"output":{"name":"ipv6addr"}}],[11,"from","","",183,null],[11,"from","","",183,null],[11,"from","","",178,null],[11,"from","","",178,null],[11,"clone","","",180,{"inputs":[{"name":"self"}],"output":{"name":"socketaddr"}}],[11,"eq","","",180,{"inputs":[{"name":"self"},{"name":"socketaddr"}],"output":{"name":"bool"}}],[11,"ne","","",180,{"inputs":[{"name":"self"},{"name":"socketaddr"}],"output":{"name":"bool"}}],[11,"hash","","",180,null],[11,"fmt","","",180,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new socket address from an [IP address] and a port number.",180,{"inputs":[{"name":"ipaddr"},{"name":"u16"}],"output":{"name":"socketaddr"}}],[11,"ip","","Returns the IP address associated with this socket address.",180,{"inputs":[{"name":"self"}],"output":{"name":"ipaddr"}}],[11,"set_ip","","Changes the IP address associated with this socket address.",180,{"inputs":[{"name":"self"},{"name":"ipaddr"}],"output":null}],[11,"port","","Returns the port number associated with this socket address.",180,{"inputs":[{"name":"self"}],"output":{"name":"u16"}}],[11,"set_port","","Changes the port number associated with this socket address.",180,{"inputs":[{"name":"self"},{"name":"u16"}],"output":null}],[11,"is_ipv4","","Returns [`true`] if the [IP address] in this `SocketAddr` is an [IPv4 address], and [`false`] otherwise.",180,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_ipv6","","Returns [`true`] if the [IP address] in this `SocketAddr` is an [IPv6 address], and [`false`] otherwise.",180,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"new","","Creates a new socket address from an [IPv4 address] and a port number.",184,{"inputs":[{"name":"ipv4addr"},{"name":"u16"}],"output":{"name":"socketaddrv4"}}],[11,"ip","","Returns the IP address associated with this socket address.",184,{"inputs":[{"name":"self"}],"output":{"name":"ipv4addr"}}],[11,"set_ip","","Changes the IP address associated with this socket address.",184,{"inputs":[{"name":"self"},{"name":"ipv4addr"}],"output":null}],[11,"port","","Returns the port number associated with this socket address.",184,{"inputs":[{"name":"self"}],"output":{"name":"u16"}}],[11,"set_port","","Changes the port number associated with this socket address.",184,{"inputs":[{"name":"self"},{"name":"u16"}],"output":null}],[11,"new","","Creates a new socket address from an [IPv6 address], a 16-bit port number, and the `flowinfo` and `scope_id` fields.",185,{"inputs":[{"name":"ipv6addr"},{"name":"u16"},{"name":"u32"},{"name":"u32"}],"output":{"name":"socketaddrv6"}}],[11,"ip","","Returns the IP address associated with this socket address.",185,{"inputs":[{"name":"self"}],"output":{"name":"ipv6addr"}}],[11,"set_ip","","Changes the IP address associated with this socket address.",185,{"inputs":[{"name":"self"},{"name":"ipv6addr"}],"output":null}],[11,"port","","Returns the port number associated with this socket address.",185,{"inputs":[{"name":"self"}],"output":{"name":"u16"}}],[11,"set_port","","Changes the port number associated with this socket address.",185,{"inputs":[{"name":"self"},{"name":"u16"}],"output":null}],[11,"flowinfo","","Returns the flow information associated with this address.",185,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"set_flowinfo","","Changes the flow information associated with this socket address.",185,{"inputs":[{"name":"self"},{"name":"u32"}],"output":null}],[11,"scope_id","","Returns the scope ID associated with this address.",185,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"set_scope_id","","Change the scope ID associated with this socket address.",185,{"inputs":[{"name":"self"},{"name":"u32"}],"output":null}],[11,"from","","",180,{"inputs":[{"name":"socketaddrv4"}],"output":{"name":"socketaddr"}}],[11,"from","","",180,{"inputs":[{"name":"socketaddrv6"}],"output":{"name":"socketaddr"}}],[11,"from","","",180,null],[11,"fmt","","",180,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",184,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",184,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",185,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",185,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",184,{"inputs":[{"name":"self"}],"output":{"name":"socketaddrv4"}}],[11,"clone","","",185,{"inputs":[{"name":"self"}],"output":{"name":"socketaddrv6"}}],[11,"eq","","",184,{"inputs":[{"name":"self"},{"name":"socketaddrv4"}],"output":{"name":"bool"}}],[11,"eq","","",185,{"inputs":[{"name":"self"},{"name":"socketaddrv6"}],"output":{"name":"bool"}}],[11,"hash","","",184,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"hash","","",185,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"to_socket_addrs","","",180,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"to_socket_addrs","","",184,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"to_socket_addrs","","",185,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"to_socket_addrs","std::string","",140,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"fmt","std::net","",186,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"connect","","Opens a TCP connection to a remote host.",187,{"inputs":[{"name":"a"}],"output":{"name":"result"}}],[11,"connect_timeout","","Opens a TCP connection to a remote host with a timeout.",187,{"inputs":[{"name":"socketaddr"},{"name":"duration"}],"output":{"name":"result"}}],[11,"peer_addr","","Returns the socket address of the remote peer of this TCP connection.",187,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"local_addr","","Returns the socket address of the local half of this TCP connection.",187,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"shutdown","","Shuts down the read, write, or both halves of this connection.",187,{"inputs":[{"name":"self"},{"name":"shutdown"}],"output":{"name":"result"}}],[11,"try_clone","","Creates a new independently owned handle to the underlying socket.",187,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"set_read_timeout","","Sets the read timeout to the timeout specified.",187,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"name":"result"}}],[11,"set_write_timeout","","Sets the write timeout to the timeout specified.",187,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"name":"result"}}],[11,"read_timeout","","Returns the read timeout of this socket.",187,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"write_timeout","","Returns the write timeout of this socket.",187,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"peek","","Receives data on the socket from the remote address to which it is connected, without removing that data from the queue. On success, returns the number of bytes peeked.",187,null],[11,"set_nodelay","","Sets the value of the `TCP_NODELAY` option on this socket.",187,{"inputs":[{"name":"self"},{"name":"bool"}],"output":{"name":"result"}}],[11,"nodelay","","Gets the value of the `TCP_NODELAY` option on this socket.",187,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"set_ttl","","Sets the value for the `IP_TTL` option on this socket.",187,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"result"}}],[11,"ttl","","Gets the value of the `IP_TTL` option for this socket.",187,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"take_error","","Get the value of the `SO_ERROR` option on this socket.",187,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"set_nonblocking","","Moves this TCP stream into or out of nonblocking mode.",187,{"inputs":[{"name":"self"},{"name":"bool"}],"output":{"name":"result"}}],[11,"read","","",187,null],[11,"initializer","","",187,{"inputs":[{"name":"self"}],"output":{"name":"initializer"}}],[11,"write","","",187,null],[11,"flush","","",187,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"fmt","","",187,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"bind","","Creates a new `TcpListener` which will be bound to the specified address.",188,{"inputs":[{"name":"a"}],"output":{"name":"result"}}],[11,"local_addr","","Returns the local socket address of this listener.",188,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"try_clone","","Creates a new independently owned handle to the underlying socket.",188,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"accept","","Accept a new incoming connection from this listener.",188,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"incoming","","Returns an iterator over the connections being received on this listener.",188,{"inputs":[{"name":"self"}],"output":{"name":"incoming"}}],[11,"set_ttl","","Sets the value for the `IP_TTL` option on this socket.",188,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"result"}}],[11,"ttl","","Gets the value of the `IP_TTL` option for this socket.",188,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"set_only_v6","","",188,{"inputs":[{"name":"self"},{"name":"bool"}],"output":{"name":"result"}}],[11,"only_v6","","",188,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"take_error","","Get the value of the `SO_ERROR` option on this socket.",188,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"set_nonblocking","","Moves this TCP stream into or out of nonblocking mode.",188,{"inputs":[{"name":"self"},{"name":"bool"}],"output":{"name":"result"}}],[11,"next","","",186,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",188,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"bind","","Creates a UDP socket from the given address.",189,{"inputs":[{"name":"a"}],"output":{"name":"result"}}],[11,"recv_from","","Receives a single datagram message on the socket. On success, returns the number of bytes read and the origin.",189,null],[11,"peek_from","","Receives a single datagram message on the socket, without removing it from the queue. On success, returns the number of bytes read and the origin.",189,null],[11,"send_to","","Sends data on the socket to the given address. On success, returns the number of bytes written.",189,null],[11,"local_addr","","Returns the socket address that this socket was created from.",189,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"try_clone","","Creates a new independently owned handle to the underlying socket.",189,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"set_read_timeout","","Sets the read timeout to the timeout specified.",189,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"name":"result"}}],[11,"set_write_timeout","","Sets the write timeout to the timeout specified.",189,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"name":"result"}}],[11,"read_timeout","","Returns the read timeout of this socket.",189,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"write_timeout","","Returns the write timeout of this socket.",189,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"set_broadcast","","Sets the value of the `SO_BROADCAST` option for this socket.",189,{"inputs":[{"name":"self"},{"name":"bool"}],"output":{"name":"result"}}],[11,"broadcast","","Gets the value of the `SO_BROADCAST` option for this socket.",189,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"set_multicast_loop_v4","","Sets the value of the `IP_MULTICAST_LOOP` option for this socket.",189,{"inputs":[{"name":"self"},{"name":"bool"}],"output":{"name":"result"}}],[11,"multicast_loop_v4","","Gets the value of the `IP_MULTICAST_LOOP` option for this socket.",189,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"set_multicast_ttl_v4","","Sets the value of the `IP_MULTICAST_TTL` option for this socket.",189,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"result"}}],[11,"multicast_ttl_v4","","Gets the value of the `IP_MULTICAST_TTL` option for this socket.",189,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"set_multicast_loop_v6","","Sets the value of the `IPV6_MULTICAST_LOOP` option for this socket.",189,{"inputs":[{"name":"self"},{"name":"bool"}],"output":{"name":"result"}}],[11,"multicast_loop_v6","","Gets the value of the `IPV6_MULTICAST_LOOP` option for this socket.",189,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"set_ttl","","Sets the value for the `IP_TTL` option on this socket.",189,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"result"}}],[11,"ttl","","Gets the value of the `IP_TTL` option for this socket.",189,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"join_multicast_v4","","Executes an operation of the `IP_ADD_MEMBERSHIP` type.",189,{"inputs":[{"name":"self"},{"name":"ipv4addr"},{"name":"ipv4addr"}],"output":{"name":"result"}}],[11,"join_multicast_v6","","Executes an operation of the `IPV6_ADD_MEMBERSHIP` type.",189,{"inputs":[{"name":"self"},{"name":"ipv6addr"},{"name":"u32"}],"output":{"name":"result"}}],[11,"leave_multicast_v4","","Executes an operation of the `IP_DROP_MEMBERSHIP` type.",189,{"inputs":[{"name":"self"},{"name":"ipv4addr"},{"name":"ipv4addr"}],"output":{"name":"result"}}],[11,"leave_multicast_v6","","Executes an operation of the `IPV6_DROP_MEMBERSHIP` type.",189,{"inputs":[{"name":"self"},{"name":"ipv6addr"},{"name":"u32"}],"output":{"name":"result"}}],[11,"take_error","","Get the value of the `SO_ERROR` option on this socket.",189,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"connect","","Connects this UDP socket to a remote address, allowing the `send` and `recv` syscalls to be used to send data and also applies filters to only receive data from the specified address.",189,{"inputs":[{"name":"self"},{"name":"a"}],"output":{"name":"result"}}],[11,"send","","Sends data on the socket to the remote address to which it is connected.",189,null],[11,"recv","","Receives a single datagram message on the socket from the remote address to which it is connected. On success, returns the number of bytes read.",189,null],[11,"peek","","Receives single datagram on the socket from the remote address to which it is connected, without removing the message from input queue. On success, returns the number of bytes peeked.",189,null],[11,"set_nonblocking","","Moves this UDP socket into or out of nonblocking mode.",189,{"inputs":[{"name":"self"},{"name":"bool"}],"output":{"name":"result"}}],[11,"fmt","","",189,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"from_str","","",178,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",182,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",183,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",184,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",185,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",180,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"fmt","","",190,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",190,{"inputs":[{"name":"self"}],"output":{"name":"addrparseerror"}}],[11,"eq","","",190,{"inputs":[{"name":"self"},{"name":"addrparseerror"}],"output":{"name":"bool"}}],[11,"ne","","",190,{"inputs":[{"name":"self"},{"name":"addrparseerror"}],"output":{"name":"bool"}}],[11,"fmt","","",190,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"description","","",190,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[8,"ToSocketAddrs","","A trait for objects which can be converted or resolved to one or more [`SocketAddr`] values.",null,null],[16,"Iter","","Returned iterator over socket addresses which this type may correspond to.",191,null],[10,"to_socket_addrs","","Converts this object to an iterator of resolved `SocketAddr`s.",191,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"clone","","",181,{"inputs":[{"name":"self"}],"output":{"name":"shutdown"}}],[11,"eq","","",181,{"inputs":[{"name":"self"},{"name":"shutdown"}],"output":{"name":"bool"}}],[11,"fmt","","",181,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",192,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",192,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[0,"num","std","Additional functionality for numerics.",null,null],[4,"FpCategory","std::num","A classification of floating point numbers.",null,null],[13,"Nan","","\"Not a Number\", often obtained by dividing by zero.",193,null],[13,"Infinite","","Positive or negative infinity.",193,null],[13,"Zero","","Positive or negative zero.",193,null],[13,"Subnormal","","De-normalized floating point representation (less precise than `Normal`).",193,null],[13,"Normal","","A regular floating point number.",193,null],[3,"ParseIntError","","An error which can be returned when parsing an integer.",null,null],[3,"ParseFloatError","","An error which can be returned when parsing a float.",null,null],[3,"TryFromIntError","","The error type returned when a checked integral type conversion fails.",null,null],[3,"Wrapping","","Provides intentionally-wrapped arithmetic on `T`.",null,null],[12,"0","","",194,null],[0,"os","std","OS-specific functionality.",null,null],[0,"unix","std::os","Experimental extensions to `std` for Unix platforms.",null,null],[0,"io","std::os::unix","Unix-specific extensions to general I/O primitives",null,null],[6,"RawFd","std::os::unix::io","Raw file descriptors.",null,null],[8,"AsRawFd","","A trait to extract the raw unix file descriptor from an underlying object.",null,null],[10,"as_raw_fd","","Extracts the raw file descriptor.",195,{"inputs":[{"name":"self"}],"output":{"name":"rawfd"}}],[8,"FromRawFd","","A trait to express the ability to construct an object from a raw file descriptor.",null,null],[10,"from_raw_fd","","Constructs a new instance of `Self` from the given raw file descriptor.",196,{"inputs":[{"name":"rawfd"}],"output":{"name":"self"}}],[8,"IntoRawFd","","A trait to express the ability to consume an object and acquire ownership of its raw file descriptor.",null,null],[10,"into_raw_fd","","Consumes this object, returning the raw underlying file descriptor.",197,{"inputs":[{"name":"self"}],"output":{"name":"rawfd"}}],[0,"ffi","std::os::unix","Unix-specific extension to the primitives in the `std::ffi` module",null,null],[8,"OsStringExt","std::os::unix::ffi","Unix-specific extensions to `OsString`.",null,null],[10,"from_vec","","Creates an [`OsString`] from a byte vector.",198,{"inputs":[{"name":"vec"}],"output":{"name":"self"}}],[10,"into_vec","","Yields the underlying byte vector of this [`OsString`].",198,{"inputs":[{"name":"self"}],"output":{"name":"vec"}}],[8,"OsStrExt","","Unix-specific extensions to `OsStr`.",null,null],[10,"from_bytes","","Creates an [`OsStr`] from a byte slice.",199,null],[10,"as_bytes","","Gets the underlying byte view of the [`OsStr`] slice.",199,null],[0,"fs","std::os::unix","Unix-specific extensions to primitives in the `std::fs` module.",null,null],[5,"symlink","std::os::unix::fs","Creates a new symbolic link on the filesystem.",null,{"inputs":[{"name":"p"},{"name":"q"}],"output":{"name":"result"}}],[8,"FileExt","","Unix-specific extensions to `File`",null,null],[10,"read_at","","Reads a number of bytes starting from a given offset.",200,null],[10,"write_at","","Writes a number of bytes starting from a given offset.",200,null],[8,"PermissionsExt","","Unix-specific extensions to `Permissions`",null,null],[10,"mode","","Returns the underlying raw `st_mode` bits that contain the standard Unix permissions for this file.",201,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[10,"set_mode","","Sets the underlying raw bits for this set of permissions.",201,{"inputs":[{"name":"self"},{"name":"u32"}],"output":null}],[10,"from_mode","","Creates a new instance of `Permissions` from the given set of Unix permission bits.",201,{"inputs":[{"name":"u32"}],"output":{"name":"self"}}],[8,"OpenOptionsExt","","Unix-specific extensions to `OpenOptions`",null,null],[10,"mode","","Sets the mode bits that a new file will be created with.",202,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"self"}}],[10,"custom_flags","","Pass custom flags to the `flags` argument of `open`.",202,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"self"}}],[8,"MetadataExt","","",null,null],[10,"dev","","",203,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[10,"ino","","",203,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[10,"mode","","",203,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[10,"nlink","","",203,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[10,"uid","","",203,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[10,"gid","","",203,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[10,"rdev","","",203,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[10,"size","","",203,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[10,"atime","","",203,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[10,"atime_nsec","","",203,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[10,"mtime","","",203,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[10,"mtime_nsec","","",203,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[10,"ctime","","",203,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[10,"ctime_nsec","","",203,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[10,"blksize","","",203,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[10,"blocks","","",203,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[8,"FileTypeExt","","Add special unix types (block/char device, fifo and socket)",null,null],[10,"is_block_device","","Returns whether this file type is a block device.",204,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[10,"is_char_device","","Returns whether this file type is a char device.",204,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[10,"is_fifo","","Returns whether this file type is a fifo.",204,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[10,"is_socket","","Returns whether this file type is a socket.",204,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[8,"DirEntryExt","","Unix-specific extension methods for `fs::DirEntry`",null,null],[10,"ino","","Returns the underlying `d_ino` field in the contained `dirent` structure.",205,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[8,"DirBuilderExt","","An extension trait for `fs::DirBuilder` for unix-specific options.",null,null],[10,"mode","","Sets the mode to create new directories with. This option defaults to 0o777.",206,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"self"}}],[0,"process","std::os::unix","Unix-specific extensions to primitives in the `std::process` module.",null,null],[8,"CommandExt","std::os::unix::process","Unix-specific extensions to the `std::process::Command` builder",null,null],[10,"uid","","Sets the child process's user id. This translates to a `setuid` call in the child process. Failure in the `setuid` call will cause the spawn to fail.",207,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"command"}}],[10,"gid","","Similar to `uid`, but sets the group id of the child process. This has the same semantics as the `uid` field.",207,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"command"}}],[10,"before_exec","","Schedules a closure to be run just before the `exec` function is invoked.",207,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"command"}}],[10,"exec","","Performs all the required setup by this `Command`, followed by calling the `execvp` syscall.",207,{"inputs":[{"name":"self"}],"output":{"name":"error"}}],[8,"ExitStatusExt","","Unix-specific extensions to `std::process::ExitStatus`",null,null],[10,"from_raw","","Creates a new `ExitStatus` from the raw underlying `i32` return value of a process.",208,{"inputs":[{"name":"i32"}],"output":{"name":"self"}}],[10,"signal","","If the process was terminated by a signal, returns that signal.",208,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[0,"raw","std::os::unix","Unix-specific primitives available on all unix platforms",null,null],[6,"uid_t","std::os::unix::raw","",null,null],[6,"gid_t","","",null,null],[6,"pid_t","","",null,null],[6,"pthread_t","","",null,null],[6,"dev_t","","",null,null],[6,"ino_t","","",null,null],[6,"mode_t","","",null,null],[6,"nlink_t","","",null,null],[6,"off_t","","",null,null],[6,"blksize_t","","",null,null],[6,"blkcnt_t","","",null,null],[6,"time_t","","",null,null],[0,"thread","std::os::unix","Unix-specific extensions to primitives in the `std::thread` module.",null,null],[6,"RawPthread","std::os::unix::thread","",null,null],[8,"JoinHandleExt","","Unix-specific extensions to `std::thread::JoinHandle`",null,null],[10,"as_pthread_t","","Extracts the raw pthread_t without taking ownership",209,{"inputs":[{"name":"self"}],"output":{"name":"rawpthread"}}],[10,"into_pthread_t","","Consumes the thread, returning the raw pthread_t",209,{"inputs":[{"name":"self"}],"output":{"name":"rawpthread"}}],[0,"net","std::os::unix","Unix-specific networking functionality",null,null],[3,"SocketAddr","std::os::unix::net","An address associated with a Unix socket.",null,null],[3,"UnixStream","","A Unix stream socket.",null,null],[3,"UnixListener","","A structure representing a Unix domain socket server.",null,null],[3,"Incoming","","An iterator over incoming connections to a [`UnixListener`].",null,null],[3,"UnixDatagram","","A Unix datagram socket.",null,null],[0,"prelude","std::os::unix","A prelude for conveniently writing platform-specific code.",null,null],[0,"windows","std::os","Platform-specific extensions to `std` for Windows.",null,null],[0,"ffi","std::os::windows","Windows-specific extensions to the primitives in the `std::ffi` module.",null,null],[3,"EncodeWide","std::os::windows::ffi","Generates a wide character sequence for potentially ill-formed UTF-16.",null,null],[8,"OsStringExt","","Windows-specific extensions to `OsString`.",null,null],[10,"from_wide","","Creates an `OsString` from a potentially ill-formed UTF-16 slice of 16-bit code units.",210,null],[8,"OsStrExt","","Windows-specific extensions to `OsStr`.",null,null],[10,"encode_wide","","Re-encodes an `OsStr` as a wide character sequence, i.e. potentially ill-formed UTF-16.",211,{"inputs":[{"name":"self"}],"output":{"name":"encodewide"}}],[0,"fs","std::os::windows","Windows-specific extensions for the primitives in the `std::fs` module.",null,null],[5,"symlink_file","std::os::windows::fs","Creates a new file symbolic link on the filesystem.",null,{"inputs":[{"name":"p"},{"name":"q"}],"output":{"name":"result"}}],[5,"symlink_dir","","Creates a new directory symlink on the filesystem.",null,{"inputs":[{"name":"p"},{"name":"q"}],"output":{"name":"result"}}],[8,"FileExt","","Windows-specific extensions to [`File`].",null,null],[10,"seek_read","","Seeks to a given position and reads a number of bytes.",212,null],[10,"seek_write","","Seeks to a given position and writes a number of bytes.",212,null],[8,"OpenOptionsExt","","Windows-specific extensions to [`OpenOptions`].",null,null],[10,"access_mode","","Overrides the `dwDesiredAccess` argument to the call to [`CreateFile`] with the specified value.",213,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"self"}}],[10,"share_mode","","Overrides the `dwShareMode` argument to the call to [`CreateFile`] with the specified value.",213,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"self"}}],[10,"custom_flags","","Sets extra flags for the `dwFileFlags` argument to the call to [`CreateFile2`] to the specified value (or combines it with `attributes` and `security_qos_flags` to set the `dwFlagsAndAttributes` for [`CreateFile`]).",213,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"self"}}],[10,"attributes","","Sets the `dwFileAttributes` argument to the call to [`CreateFile2`] to the specified value (or combines it with `custom_flags` and `security_qos_flags` to set the `dwFlagsAndAttributes` for [`CreateFile`]).",213,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"self"}}],[10,"security_qos_flags","","Sets the `dwSecurityQosFlags` argument to the call to [`CreateFile2`] to the specified value (or combines it with `custom_flags` and `attributes` to set the `dwFlagsAndAttributes` for [`CreateFile`]).",213,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"openoptions"}}],[8,"MetadataExt","","Extension methods for [`fs::Metadata`] to access the raw fields contained within.",null,null],[10,"file_attributes","","Returns the value of the `dwFileAttributes` field of this metadata.",214,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[10,"creation_time","","Returns the value of the `ftCreationTime` field of this metadata.",214,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[10,"last_access_time","","Returns the value of the `ftLastAccessTime` field of this metadata.",214,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[10,"last_write_time","","Returns the value of the `ftLastWriteTime` field of this metadata.",214,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[10,"file_size","","Returns the value of the `nFileSize{High,Low}` fields of this metadata.",214,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[0,"io","std::os::windows","",null,null],[6,"RawHandle","std::os::windows::io","Raw HANDLEs.",null,null],[6,"RawSocket","","Raw SOCKETs.",null,null],[8,"AsRawHandle","","Extract raw handles.",null,null],[10,"as_raw_handle","","Extracts the raw handle, without taking any ownership.",215,{"inputs":[{"name":"self"}],"output":{"name":"rawhandle"}}],[8,"FromRawHandle","","Construct I/O objects from raw handles.",null,null],[10,"from_raw_handle","","Constructs a new I/O object from the specified raw handle.",216,{"inputs":[{"name":"rawhandle"}],"output":{"name":"self"}}],[8,"IntoRawHandle","","A trait to express the ability to consume an object and acquire ownership of its raw `HANDLE`.",null,null],[10,"into_raw_handle","","Consumes this object, returning the raw underlying handle.",217,{"inputs":[{"name":"self"}],"output":{"name":"rawhandle"}}],[8,"AsRawSocket","","Extract raw sockets.",null,null],[10,"as_raw_socket","","Extracts the underlying raw socket from this object.",218,{"inputs":[{"name":"self"}],"output":{"name":"rawsocket"}}],[8,"FromRawSocket","","Create I/O objects from raw sockets.",null,null],[10,"from_raw_socket","","Creates a new I/O object from the given raw socket.",219,{"inputs":[{"name":"rawsocket"}],"output":{"name":"self"}}],[8,"IntoRawSocket","","A trait to express the ability to consume an object and acquire ownership of its raw `SOCKET`.",null,null],[10,"into_raw_socket","","Consumes this object, returning the raw underlying socket.",220,{"inputs":[{"name":"self"}],"output":{"name":"rawsocket"}}],[0,"raw","std::os::windows","Windows-specific primitives",null,null],[6,"HANDLE","std::os::windows::raw","",null,null],[6,"SOCKET","","",null,null],[0,"process","std::os::windows","Extensions to `std::process` for Windows.",null,null],[8,"ExitStatusExt","std::os::windows::process","Windows-specific extensions to `std::process::ExitStatus`",null,null],[10,"from_raw","","Creates a new `ExitStatus` from the raw underlying `u32` return value of a process.",221,{"inputs":[{"name":"u32"}],"output":{"name":"self"}}],[8,"CommandExt","","Windows-specific extensions to the `std::process::Command` builder",null,null],[10,"creation_flags","","Sets the [process creation flags][1] to be passed to `CreateProcess`.",222,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"command"}}],[0,"thread","std::os::windows","Extensions to `std::thread` for Windows.",null,null],[0,"prelude","","A prelude for conveniently writing platform-specific code.",null,null],[0,"linux","std::os","Linux-specific definitions",null,null],[0,"raw","std::os::linux","Linux-specific raw type definitions",null,null],[3,"stat","std::os::linux::raw","",null,null],[12,"st_dev","","",223,null],[12,"__pad1","","",223,null],[12,"__st_ino","","",223,null],[12,"st_mode","","",223,null],[12,"st_nlink","","",223,null],[12,"st_uid","","",223,null],[12,"st_gid","","",223,null],[12,"st_rdev","","",223,null],[12,"__pad2","","",223,null],[12,"st_size","","",223,null],[12,"st_blksize","","",223,null],[12,"st_blocks","","",223,null],[12,"st_atime","","",223,null],[12,"st_atime_nsec","","",223,null],[12,"st_mtime","","",223,null],[12,"st_mtime_nsec","","",223,null],[12,"st_ctime","","",223,null],[12,"st_ctime_nsec","","",223,null],[12,"st_ino","","",223,null],[11,"clone","","",223,{"inputs":[{"name":"self"}],"output":{"name":"stat"}}],[6,"dev_t","","",null,null],[6,"mode_t","","",null,null],[6,"pthread_t","","",null,null],[6,"off_t","","",null,null],[6,"ino_t","","",null,null],[6,"nlink_t","","",null,null],[6,"blksize_t","","",null,null],[6,"blkcnt_t","","",null,null],[6,"time_t","","",null,null],[0,"fs","std::os::linux","",null,null],[8,"MetadataExt","std::os::linux::fs","OS-specific extension methods for `fs::Metadata`",null,null],[10,"as_raw_stat","","Gain a reference to the underlying `stat` structure which contains the raw information returned by the OS.",224,{"inputs":[{"name":"self"}],"output":{"name":"stat"}}],[10,"st_dev","","Returns the device ID on which this file resides.",224,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[10,"st_ino","","Returns the inode number.",224,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[10,"st_mode","","Returns the file type and mode.",224,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[10,"st_nlink","","Returns the number of hard links to file.",224,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[10,"st_uid","","Returns the user ID of the file owner.",224,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[10,"st_gid","","Returns the group ID of the file owner.",224,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[10,"st_rdev","","Returns the device ID that this file represents. Only relevant for special file.",224,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[10,"st_size","","Returns the size of the file (if it is a regular file or a symbolic link) in bytes.",224,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[10,"st_atime","","Returns the last access time.",224,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[10,"st_atime_nsec","","Returns the last access time, nano seconds part.",224,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[10,"st_mtime","","Returns the last modification time.",224,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[10,"st_mtime_nsec","","Returns the last modification time, nano seconds part.",224,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[10,"st_ctime","","Returns the last status change time.",224,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[10,"st_ctime_nsec","","Returns the last status change time, nano seconds part.",224,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[10,"st_blksize","","Returns the \"preferred\" blocksize for efficient filesystem I/O.",224,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[10,"st_blocks","","Returns the number of blocks allocated to the file, 512-byte units.",224,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"as_raw_stat","std::fs","",141,{"inputs":[{"name":"self"}],"output":{"name":"stat"}}],[11,"st_dev","","",141,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"st_ino","","",141,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"st_mode","","",141,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"st_nlink","","",141,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"st_uid","","",141,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"st_gid","","",141,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"st_rdev","","",141,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"st_size","","",141,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"st_atime","","",141,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[11,"st_atime_nsec","","",141,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[11,"st_mtime","","",141,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[11,"st_mtime_nsec","","",141,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[11,"st_ctime","","",141,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[11,"st_ctime_nsec","","",141,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[11,"st_blksize","","",141,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"st_blocks","","",141,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[0,"raw","std::os","Raw OS-specific types for the current platform/architecture",null,null],[4,"c_void","std::os::raw","Type used to construct void pointers for use with C.",null,null],[6,"c_char","","",null,null],[6,"c_schar","","",null,null],[6,"c_uchar","","",null,null],[6,"c_short","","",null,null],[6,"c_ushort","","",null,null],[6,"c_int","","",null,null],[6,"c_uint","","",null,null],[6,"c_long","","",null,null],[6,"c_ulong","","",null,null],[6,"c_longlong","","",null,null],[6,"c_ulonglong","","",null,null],[6,"c_float","","",null,null],[6,"c_double","","",null,null],[11,"fmt","","",225,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[0,"panic","std","Panic support in the standard library",null,null],[3,"PanicInfo","std::panic","A struct providing information about a panic.",null,null],[3,"Location","","A struct containing information about the location of a panic.",null,null],[3,"AssertUnwindSafe","","A simple wrapper around a type to assert that it is unwind safe.",null,null],[12,"0","","",226,null],[5,"take_hook","","Unregisters the current panic hook, returning it.",null,{"inputs":[],"output":{"name":"box"}}],[5,"set_hook","","Registers a custom panic hook, replacing any that was previously registered.",null,{"inputs":[{"name":"box"}],"output":null}],[5,"catch_unwind","","Invokes a closure, capturing the cause of an unwinding panic if one occurs.",null,{"inputs":[{"name":"f"}],"output":{"name":"result"}}],[5,"resume_unwind","","Triggers a panic without invoking the panic hook.",null,null],[8,"UnwindSafe","","A marker trait which represents \"panic safe\" types in Rust.",null,null],[8,"RefUnwindSafe","","A marker trait representing types where a shared reference is considered unwind safe.",null,null],[11,"deref","","",226,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"deref_mut","","",226,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"call_once","","",226,null],[11,"fmt","","",226,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[0,"path","std","Cross-platform path manipulation.",null,null],[3,"PrefixComponent","std::path","A structure wrapping a Windows path prefix as well as its unparsed string representation.",null,null],[3,"Components","","An iterator over the [`Component`]s of a [`Path`].",null,null],[3,"Iter","","An iterator over the [`Component`]s of a [`Path`], as [`OsStr`] slices.",null,null],[3,"PathBuf","","An owned, mutable path (akin to [`String`]).",null,null],[3,"Path","","A slice of a path (akin to [`str`]).",null,null],[3,"StripPrefixError","","An error returned from [`Path::strip_prefix`][`strip_prefix`] if the prefix was not found.",null,null],[3,"Display","","Helper struct for safely printing paths with [`format!`] and `{}`.",null,null],[4,"Prefix","","Windows path prefixes, e.g. `C:` or `\\\\server\\share`.",null,null],[13,"Verbatim","","Verbatim prefix, e.g. `\\\\?\\cat_pics`.",227,null],[13,"VerbatimUNC","","Verbatim prefix using Windows' Uniform Naming Convention, e.g. `\\\\?\\UNC\\server\\share`.",227,null],[13,"VerbatimDisk","","Verbatim disk prefix, e.g. `\\\\?\\C:\\`.",227,null],[13,"DeviceNS","","Device namespace prefix, e.g. `\\\\.\\COM42`.",227,null],[13,"UNC","","Prefix using Windows' Uniform Naming Convention, e.g. `\\\\server\\share`.",227,null],[13,"Disk","","Prefix `C:` for the given disk drive.",227,null],[4,"Component","","A single component of a path.",null,null],[13,"Prefix","","A Windows path prefix, e.g. `C:` or `\\\\server\\share`.",228,null],[13,"RootDir","","The root directory component, appears after any prefix and before anything else.",228,null],[13,"CurDir","","A reference to the current directory, i.e. `.`.",228,null],[13,"ParentDir","","A reference to the parent directory, i.e. `..`.",228,null],[13,"Normal","","A normal component, e.g. `a` and `b` in `a/b`.",228,null],[5,"is_separator","","Determines whether the character is one of the permitted path separators for the current platform.",null,{"inputs":[{"name":"char"}],"output":{"name":"bool"}}],[17,"MAIN_SEPARATOR","","The primary separator of path components for the current platform.",null,null],[11,"clone","","",227,{"inputs":[{"name":"self"}],"output":{"name":"prefix"}}],[11,"fmt","","",227,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",227,null],[11,"partial_cmp","","",227,{"inputs":[{"name":"self"},{"name":"prefix"}],"output":{"name":"option"}}],[11,"lt","","",227,{"inputs":[{"name":"self"},{"name":"prefix"}],"output":{"name":"bool"}}],[11,"le","","",227,{"inputs":[{"name":"self"},{"name":"prefix"}],"output":{"name":"bool"}}],[11,"gt","","",227,{"inputs":[{"name":"self"},{"name":"prefix"}],"output":{"name":"bool"}}],[11,"ge","","",227,{"inputs":[{"name":"self"},{"name":"prefix"}],"output":{"name":"bool"}}],[11,"cmp","","",227,{"inputs":[{"name":"self"},{"name":"prefix"}],"output":{"name":"ordering"}}],[11,"eq","","",227,{"inputs":[{"name":"self"},{"name":"prefix"}],"output":{"name":"bool"}}],[11,"ne","","",227,{"inputs":[{"name":"self"},{"name":"prefix"}],"output":{"name":"bool"}}],[11,"is_verbatim","","Determines if the prefix is verbatim, i.e. begins with `\\\\?\\`.",227,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",229,{"inputs":[{"name":"self"}],"output":{"name":"prefixcomponent"}}],[11,"fmt","","",229,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"kind","","Returns the parsed prefix data.",229,{"inputs":[{"name":"self"}],"output":{"name":"prefix"}}],[11,"as_os_str","","Returns the raw [`OsStr`] slice for this prefix.",229,{"inputs":[{"name":"self"}],"output":{"name":"osstr"}}],[11,"eq","","",229,{"inputs":[{"name":"self"},{"name":"prefixcomponent"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",229,{"inputs":[{"name":"self"},{"name":"prefixcomponent"}],"output":{"name":"option"}}],[11,"cmp","","",229,{"inputs":[{"name":"self"},{"name":"prefixcomponent"}],"output":{"name":"ordering"}}],[11,"hash","","",229,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"clone","","",228,{"inputs":[{"name":"self"}],"output":{"name":"component"}}],[11,"eq","","",228,{"inputs":[{"name":"self"},{"name":"component"}],"output":{"name":"bool"}}],[11,"ne","","",228,{"inputs":[{"name":"self"},{"name":"component"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",228,{"inputs":[{"name":"self"},{"name":"component"}],"output":{"name":"option"}}],[11,"lt","","",228,{"inputs":[{"name":"self"},{"name":"component"}],"output":{"name":"bool"}}],[11,"le","","",228,{"inputs":[{"name":"self"},{"name":"component"}],"output":{"name":"bool"}}],[11,"gt","","",228,{"inputs":[{"name":"self"},{"name":"component"}],"output":{"name":"bool"}}],[11,"ge","","",228,{"inputs":[{"name":"self"},{"name":"component"}],"output":{"name":"bool"}}],[11,"cmp","","",228,{"inputs":[{"name":"self"},{"name":"component"}],"output":{"name":"ordering"}}],[11,"hash","","",228,null],[11,"fmt","","",228,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"as_os_str","","Extracts the underlying [`OsStr`] slice.",228,{"inputs":[{"name":"self"}],"output":{"name":"osstr"}}],[11,"as_ref","","",228,{"inputs":[{"name":"self"}],"output":{"name":"osstr"}}],[11,"clone","","",230,{"inputs":[{"name":"self"}],"output":{"name":"components"}}],[11,"clone","","",231,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"fmt","","",230,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"as_path","","Extracts a slice corresponding to the portion of the path remaining for iteration.",230,{"inputs":[{"name":"self"}],"output":{"name":"path"}}],[11,"as_ref","","",230,{"inputs":[{"name":"self"}],"output":{"name":"path"}}],[11,"as_ref","","",230,{"inputs":[{"name":"self"}],"output":{"name":"osstr"}}],[11,"fmt","","",231,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"as_path","","Extracts a slice corresponding to the portion of the path remaining for iteration.",231,{"inputs":[{"name":"self"}],"output":{"name":"path"}}],[11,"as_ref","","",231,{"inputs":[{"name":"self"}],"output":{"name":"path"}}],[11,"as_ref","","",231,{"inputs":[{"name":"self"}],"output":{"name":"osstr"}}],[11,"next","","",231,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",231,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",230,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",230,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"eq","","",230,{"inputs":[{"name":"self"},{"name":"components"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",230,{"inputs":[{"name":"self"},{"name":"components"}],"output":{"name":"option"}}],[11,"cmp","","",230,{"inputs":[{"name":"self"},{"name":"components"}],"output":{"name":"ordering"}}],[11,"clone","","",232,{"inputs":[{"name":"self"}],"output":{"name":"pathbuf"}}],[11,"new","","Allocates an empty `PathBuf`.",232,{"inputs":[],"output":{"name":"pathbuf"}}],[11,"as_path","","Coerces to a [`Path`] slice.",232,{"inputs":[{"name":"self"}],"output":{"name":"path"}}],[11,"push","","Extends `self` with `path`.",232,{"inputs":[{"name":"self"},{"name":"p"}],"output":null}],[11,"pop","","Truncates `self` to [`self.parent`].",232,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"set_file_name","","Updates [`self.file_name`] to `file_name`.",232,{"inputs":[{"name":"self"},{"name":"s"}],"output":null}],[11,"set_extension","","Updates [`self.extension`] to `extension`.",232,{"inputs":[{"name":"self"},{"name":"s"}],"output":{"name":"bool"}}],[11,"into_os_string","","Consumes the `PathBuf`, yielding its internal [`OsString`] storage.",232,{"inputs":[{"name":"self"}],"output":{"name":"osstring"}}],[11,"into_boxed_path","","Converts this `PathBuf` into a [boxed][`Box`] [`Path`].",232,{"inputs":[{"name":"self"}],"output":{"name":"box"}}],[11,"from","std::boxed","",119,{"inputs":[{"name":"path"}],"output":{"name":"box"}}],[11,"from","std::path","",232,{"inputs":[{"name":"box"}],"output":{"name":"pathbuf"}}],[11,"from","std::boxed","",119,{"inputs":[{"name":"pathbuf"}],"output":{"name":"box"}}],[11,"from","std::path","",232,{"inputs":[{"name":"t"}],"output":{"name":"pathbuf"}}],[11,"from","","",232,{"inputs":[{"name":"osstring"}],"output":{"name":"pathbuf"}}],[11,"from","std::ffi","",138,{"inputs":[{"name":"pathbuf"}],"output":{"name":"osstring"}}],[11,"from","std::path","",232,{"inputs":[{"name":"string"}],"output":{"name":"pathbuf"}}],[11,"from_iter","","",232,{"inputs":[{"name":"i"}],"output":{"name":"pathbuf"}}],[11,"extend","","",232,{"inputs":[{"name":"self"},{"name":"i"}],"output":null}],[11,"fmt","","",232,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"deref","","",232,{"inputs":[{"name":"self"}],"output":{"name":"path"}}],[11,"borrow","","",232,{"inputs":[{"name":"self"}],"output":{"name":"path"}}],[11,"default","","",232,{"inputs":[],"output":{"name":"self"}}],[11,"from","std::borrow","",74,{"inputs":[{"name":"path"}],"output":{"name":"cow"}}],[11,"from","","",74,{"inputs":[{"name":"pathbuf"}],"output":{"name":"cow"}}],[11,"to_owned","std::path","",233,{"inputs":[{"name":"self"}],"output":{"name":"pathbuf"}}],[11,"clone_into","","",233,{"inputs":[{"name":"self"},{"name":"pathbuf"}],"output":null}],[11,"eq","","",232,{"inputs":[{"name":"self"},{"name":"pathbuf"}],"output":{"name":"bool"}}],[11,"hash","","",232,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"partial_cmp","","",232,{"inputs":[{"name":"self"},{"name":"pathbuf"}],"output":{"name":"option"}}],[11,"cmp","","",232,{"inputs":[{"name":"self"},{"name":"pathbuf"}],"output":{"name":"ordering"}}],[11,"as_ref","","",232,{"inputs":[{"name":"self"}],"output":{"name":"osstr"}}],[11,"fmt","","",234,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",234,{"inputs":[{"name":"self"}],"output":{"name":"stripprefixerror"}}],[11,"eq","","",234,{"inputs":[{"name":"self"},{"name":"stripprefixerror"}],"output":{"name":"bool"}}],[11,"ne","","",234,{"inputs":[{"name":"self"},{"name":"stripprefixerror"}],"output":{"name":"bool"}}],[11,"new","","Directly wraps a string slice as a `Path` slice.",233,{"inputs":[{"name":"s"}],"output":{"name":"path"}}],[11,"as_os_str","","Yields the underlying [`OsStr`] slice.",233,{"inputs":[{"name":"self"}],"output":{"name":"osstr"}}],[11,"to_str","","Yields a [`&str`] slice if the `Path` is valid unicode.",233,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"to_string_lossy","","Converts a `Path` to a [`Cow<str>`].",233,{"inputs":[{"name":"self"}],"output":{"name":"cow"}}],[11,"to_path_buf","","Converts a `Path` to an owned [`PathBuf`].",233,{"inputs":[{"name":"self"}],"output":{"name":"pathbuf"}}],[11,"is_absolute","","Returns `true` if the `Path` is absolute, i.e. if it is independent of the current directory.",233,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_relative","","Returns `true` if the `Path` is relative, i.e. not absolute.",233,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"has_root","","Returns `true` if the `Path` has a root.",233,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"parent","","Returns the `Path` without its final component, if there is one.",233,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"file_name","","Returns the final component of the `Path`, if there is one.",233,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"strip_prefix","","Returns a path that, when joined onto `base`, yields `self`.",233,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"result"}}],[11,"starts_with","","Determines whether `base` is a prefix of `self`.",233,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"bool"}}],[11,"ends_with","","Determines whether `child` is a suffix of `self`.",233,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"bool"}}],[11,"file_stem","","Extracts the stem (non-extension) portion of [`self.file_name`].",233,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"extension","","Extracts the extension of [`self.file_name`], if possible.",233,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"join","","Creates an owned [`PathBuf`] with `path` adjoined to `self`.",233,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"pathbuf"}}],[11,"with_file_name","","Creates an owned [`PathBuf`] like `self` but with the given file name.",233,{"inputs":[{"name":"self"},{"name":"s"}],"output":{"name":"pathbuf"}}],[11,"with_extension","","Creates an owned [`PathBuf`] like `self` but with the given extension.",233,{"inputs":[{"name":"self"},{"name":"s"}],"output":{"name":"pathbuf"}}],[11,"components","","Produces an iterator over the [`Component`]s of the path.",233,{"inputs":[{"name":"self"}],"output":{"name":"components"}}],[11,"iter","","Produces an iterator over the path's components viewed as [`OsStr`] slices.",233,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"display","","Returns an object that implements [`Display`] for safely printing paths that may contain non-Unicode data.",233,{"inputs":[{"name":"self"}],"output":{"name":"display"}}],[11,"metadata","","Queries the file system to get information about a file, directory, etc.",233,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"symlink_metadata","","Queries the metadata about a file without following symlinks.",233,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"canonicalize","","Returns the canonical form of the path with all intermediate components normalized and symbolic links resolved.",233,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"read_link","","Reads a symbolic link, returning the file that the link points to.",233,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"read_dir","","Returns an iterator over the entries within a directory.",233,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"exists","","Returns whether the path points at an existing entity.",233,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_file","","Returns whether the path exists on disk and is pointing at a regular file.",233,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_dir","","Returns whether the path exists on disk and is pointing at a directory.",233,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"into_path_buf","","Converts a [`Box<Path>`][`Box`] into a [`PathBuf`] without copying or allocating.",233,{"inputs":[{"name":"box"}],"output":{"name":"pathbuf"}}],[11,"as_ref","","",233,{"inputs":[{"name":"self"}],"output":{"name":"osstr"}}],[11,"fmt","","",233,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",235,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",235,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",233,{"inputs":[{"name":"self"},{"name":"path"}],"output":{"name":"bool"}}],[11,"hash","","",233,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"partial_cmp","","",233,{"inputs":[{"name":"self"},{"name":"path"}],"output":{"name":"option"}}],[11,"cmp","","",233,{"inputs":[{"name":"self"},{"name":"path"}],"output":{"name":"ordering"}}],[11,"as_ref","","",233,{"inputs":[{"name":"self"}],"output":{"name":"path"}}],[11,"as_ref","std::ffi","",139,{"inputs":[{"name":"self"}],"output":{"name":"path"}}],[11,"as_ref","std::borrow","",74,{"inputs":[{"name":"self"}],"output":{"name":"path"}}],[11,"as_ref","std::ffi","",138,{"inputs":[{"name":"self"}],"output":{"name":"path"}}],[11,"as_ref","std::string","",140,{"inputs":[{"name":"self"}],"output":{"name":"path"}}],[11,"as_ref","std::path","",232,{"inputs":[{"name":"self"}],"output":{"name":"path"}}],[11,"eq","","",232,{"inputs":[{"name":"self"},{"name":"path"}],"output":{"name":"bool"}}],[11,"eq","","",233,{"inputs":[{"name":"self"},{"name":"pathbuf"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",232,{"inputs":[{"name":"self"},{"name":"path"}],"output":{"name":"option"}}],[11,"partial_cmp","","",233,{"inputs":[{"name":"self"},{"name":"pathbuf"}],"output":{"name":"option"}}],[11,"eq","","",232,{"inputs":[{"name":"self"},{"name":"path"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",232,{"inputs":[{"name":"self"},{"name":"path"}],"output":{"name":"option"}}],[11,"eq","std::borrow","",74,{"inputs":[{"name":"self"},{"name":"path"}],"output":{"name":"bool"}}],[11,"eq","std::path","",233,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"bool"}}],[11,"partial_cmp","std::borrow","",74,{"inputs":[{"name":"self"},{"name":"path"}],"output":{"name":"option"}}],[11,"partial_cmp","std::path","",233,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"option"}}],[11,"eq","std::borrow","",74,{"inputs":[{"name":"self"},{"name":"path"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",74,{"inputs":[{"name":"self"},{"name":"path"}],"output":{"name":"option"}}],[11,"eq","","",74,{"inputs":[{"name":"self"},{"name":"pathbuf"}],"output":{"name":"bool"}}],[11,"eq","std::path","",232,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"bool"}}],[11,"partial_cmp","std::borrow","",74,{"inputs":[{"name":"self"},{"name":"pathbuf"}],"output":{"name":"option"}}],[11,"partial_cmp","std::path","",232,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"option"}}],[11,"eq","","",232,{"inputs":[{"name":"self"},{"name":"osstr"}],"output":{"name":"bool"}}],[11,"eq","std::ffi","",139,{"inputs":[{"name":"self"},{"name":"pathbuf"}],"output":{"name":"bool"}}],[11,"partial_cmp","std::path","",232,{"inputs":[{"name":"self"},{"name":"osstr"}],"output":{"name":"option"}}],[11,"partial_cmp","std::ffi","",139,{"inputs":[{"name":"self"},{"name":"pathbuf"}],"output":{"name":"option"}}],[11,"eq","std::path","",232,{"inputs":[{"name":"self"},{"name":"osstr"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",232,{"inputs":[{"name":"self"},{"name":"osstr"}],"output":{"name":"option"}}],[11,"eq","","",232,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"bool"}}],[11,"eq","std::borrow","",74,{"inputs":[{"name":"self"},{"name":"pathbuf"}],"output":{"name":"bool"}}],[11,"partial_cmp","std::path","",232,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"option"}}],[11,"partial_cmp","std::borrow","",74,{"inputs":[{"name":"self"},{"name":"pathbuf"}],"output":{"name":"option"}}],[11,"eq","std::path","",232,{"inputs":[{"name":"self"},{"name":"osstring"}],"output":{"name":"bool"}}],[11,"eq","std::ffi","",138,{"inputs":[{"name":"self"},{"name":"pathbuf"}],"output":{"name":"bool"}}],[11,"partial_cmp","std::path","",232,{"inputs":[{"name":"self"},{"name":"osstring"}],"output":{"name":"option"}}],[11,"partial_cmp","std::ffi","",138,{"inputs":[{"name":"self"},{"name":"pathbuf"}],"output":{"name":"option"}}],[11,"eq","std::path","",233,{"inputs":[{"name":"self"},{"name":"osstr"}],"output":{"name":"bool"}}],[11,"eq","std::ffi","",139,{"inputs":[{"name":"self"},{"name":"path"}],"output":{"name":"bool"}}],[11,"partial_cmp","std::path","",233,{"inputs":[{"name":"self"},{"name":"osstr"}],"output":{"name":"option"}}],[11,"partial_cmp","std::ffi","",139,{"inputs":[{"name":"self"},{"name":"path"}],"output":{"name":"option"}}],[11,"eq","std::path","",233,{"inputs":[{"name":"self"},{"name":"osstr"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",233,{"inputs":[{"name":"self"},{"name":"osstr"}],"output":{"name":"option"}}],[11,"eq","","",233,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"bool"}}],[11,"eq","std::borrow","",74,{"inputs":[{"name":"self"},{"name":"path"}],"output":{"name":"bool"}}],[11,"partial_cmp","std::path","",233,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"option"}}],[11,"partial_cmp","std::borrow","",74,{"inputs":[{"name":"self"},{"name":"path"}],"output":{"name":"option"}}],[11,"eq","std::path","",233,{"inputs":[{"name":"self"},{"name":"osstring"}],"output":{"name":"bool"}}],[11,"eq","std::ffi","",138,{"inputs":[{"name":"self"},{"name":"path"}],"output":{"name":"bool"}}],[11,"partial_cmp","std::path","",233,{"inputs":[{"name":"self"},{"name":"osstring"}],"output":{"name":"option"}}],[11,"partial_cmp","std::ffi","",138,{"inputs":[{"name":"self"},{"name":"path"}],"output":{"name":"option"}}],[11,"eq","","",139,{"inputs":[{"name":"self"},{"name":"path"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",139,{"inputs":[{"name":"self"},{"name":"path"}],"output":{"name":"option"}}],[11,"eq","std::borrow","",74,{"inputs":[{"name":"self"},{"name":"path"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",74,{"inputs":[{"name":"self"},{"name":"path"}],"output":{"name":"option"}}],[11,"eq","std::ffi","",138,{"inputs":[{"name":"self"},{"name":"path"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",138,{"inputs":[{"name":"self"},{"name":"path"}],"output":{"name":"option"}}],[11,"eq","std::borrow","",74,{"inputs":[{"name":"self"},{"name":"osstr"}],"output":{"name":"bool"}}],[11,"eq","std::ffi","",139,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"bool"}}],[11,"partial_cmp","std::borrow","",74,{"inputs":[{"name":"self"},{"name":"osstr"}],"output":{"name":"option"}}],[11,"partial_cmp","std::ffi","",139,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"option"}}],[11,"eq","std::borrow","",74,{"inputs":[{"name":"self"},{"name":"osstr"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",74,{"inputs":[{"name":"self"},{"name":"osstr"}],"output":{"name":"option"}}],[11,"eq","","",74,{"inputs":[{"name":"self"},{"name":"osstring"}],"output":{"name":"bool"}}],[11,"eq","std::ffi","",138,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"bool"}}],[11,"partial_cmp","std::borrow","",74,{"inputs":[{"name":"self"},{"name":"osstring"}],"output":{"name":"option"}}],[11,"partial_cmp","std::ffi","",138,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"option"}}],[11,"fmt","std::path","",234,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"description","","",234,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[0,"process","std","A module for working with processes.",null,null],[3,"Child","std::process","Representation of a running or exited child process.",null,null],[12,"stdin","","The handle for writing to the child's standard input (stdin), if it has been captured.",236,null],[12,"stdout","","The handle for reading from the child's standard output (stdout), if it has been captured.",236,null],[12,"stderr","","The handle for reading from the child's standard error (stderr), if it has been captured.",236,null],[3,"ChildStdin","","A handle to a child process's standard input (stdin).",null,null],[3,"ChildStdout","","A handle to a child process's standard output (stdout).",null,null],[3,"ChildStderr","","A handle to a child process's stderr.",null,null],[3,"Command","","A process builder, providing fine-grained control over how a new process should be spawned.",null,null],[3,"Output","","The output of a finished process.",null,null],[12,"status","","The status (exit code) of the process.",237,null],[12,"stdout","","The data that the process wrote to stdout.",237,null],[12,"stderr","","The data that the process wrote to stderr.",237,null],[3,"Stdio","","Describes what to do with a standard I/O stream for a child process.",null,null],[3,"ExitStatus","","Describes the result of a process after it has terminated.",null,null],[5,"exit","","Terminates the current process with the specified exit code.",null,null],[5,"abort","","Terminates the process in an abnormal fashion.",null,null],[11,"fmt","","",236,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"write","","",238,null],[11,"flush","","",238,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"fmt","","",238,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"read","","",239,null],[11,"initializer","","",239,{"inputs":[{"name":"self"}],"output":{"name":"initializer"}}],[11,"fmt","","",239,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"read","","",240,null],[11,"initializer","","",240,{"inputs":[{"name":"self"}],"output":{"name":"initializer"}}],[11,"fmt","","",240,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Constructs a new `Command` for launching the program at path `program`, with the following default configuration:",241,{"inputs":[{"name":"s"}],"output":{"name":"command"}}],[11,"arg","","Add an argument to pass to the program.",241,{"inputs":[{"name":"self"},{"name":"s"}],"output":{"name":"command"}}],[11,"args","","Add multiple arguments to pass to the program.",241,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"command"}}],[11,"env","","Inserts or updates an environment variable mapping.",241,{"inputs":[{"name":"self"},{"name":"k"},{"name":"v"}],"output":{"name":"command"}}],[11,"envs","","Add or update multiple environment variable mappings.",241,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"command"}}],[11,"env_remove","","Removes an environment variable mapping.",241,{"inputs":[{"name":"self"},{"name":"k"}],"output":{"name":"command"}}],[11,"env_clear","","Clears the entire environment map for the child process.",241,{"inputs":[{"name":"self"}],"output":{"name":"command"}}],[11,"current_dir","","Sets the working directory for the child process.",241,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"command"}}],[11,"stdin","","Configuration for the child process's standard input (stdin) handle.",241,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"command"}}],[11,"stdout","","Configuration for the child process's standard output (stdout) handle.",241,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"command"}}],[11,"stderr","","Configuration for the child process's standard error (stderr) handle.",241,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"command"}}],[11,"spawn","","Executes the command as a child process, returning a handle to it.",241,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"output","","Executes the command as a child process, waiting for it to finish and collecting all of its output.",241,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"status","","Executes a command as a child process, waiting for it to finish and collecting its exit status.",241,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"fmt","","Format the program and arguments of a Command for display. Any non-utf8 data is lossily converted using the utf8 replacement character.",241,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",237,{"inputs":[{"name":"self"},{"name":"output"}],"output":{"name":"bool"}}],[11,"ne","","",237,{"inputs":[{"name":"self"},{"name":"output"}],"output":{"name":"bool"}}],[11,"clone","","",237,{"inputs":[{"name":"self"}],"output":{"name":"output"}}],[11,"fmt","","",237,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"piped","","A new pipe should be arranged to connect the parent and child processes.",242,{"inputs":[],"output":{"name":"stdio"}}],[11,"inherit","","The child inherits from the corresponding parent descriptor.",242,{"inputs":[],"output":{"name":"stdio"}}],[11,"null","","This stream will be ignored. This is the equivalent of attaching the stream to `/dev/null`",242,{"inputs":[],"output":{"name":"stdio"}}],[11,"fmt","","",242,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"from","","",242,{"inputs":[{"name":"childstdin"}],"output":{"name":"stdio"}}],[11,"from","","",242,{"inputs":[{"name":"childstdout"}],"output":{"name":"stdio"}}],[11,"from","","",242,{"inputs":[{"name":"childstderr"}],"output":{"name":"stdio"}}],[11,"from","","",242,{"inputs":[{"name":"file"}],"output":{"name":"stdio"}}],[11,"eq","","",243,{"inputs":[{"name":"self"},{"name":"exitstatus"}],"output":{"name":"bool"}}],[11,"ne","","",243,{"inputs":[{"name":"self"},{"name":"exitstatus"}],"output":{"name":"bool"}}],[11,"clone","","",243,{"inputs":[{"name":"self"}],"output":{"name":"exitstatus"}}],[11,"fmt","","",243,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"success","","Was termination successful? Signal termination is not considered a success, and success is defined as a zero exit status.",243,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"code","","Returns the exit code of the process, if any.",243,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",243,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"kill","","Forces the child to exit. This is equivalent to sending a SIGKILL on unix platforms.",236,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"id","","Returns the OS-assigned process identifier associated with this child.",236,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"wait","","Waits for the child to exit completely, returning the status that it exited with. This function will continue to have the same return value after it has been called at least once.",236,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"try_wait","","Attempts to collect the exit status of the child if it has already exited.",236,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"wait_with_output","","Simultaneously waits for the child to exit and collect all remaining output on the stdout/stderr handles, returning an `Output` instance.",236,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[0,"sync","std","Useful synchronization primitives.",null,null],[3,"Arc","std::sync","A thread-safe reference-counting pointer. 'Arc' stands for 'Atomically Reference Counted'.",null,null],[3,"Weak","","`Weak` is a version of [`Arc`] that holds a non-owning reference to the managed value. The value is accessed by calling [`upgrade`] on the `Weak` pointer, which returns an [`Option`]`<`[`Arc`]`<T>>`.",null,null],[0,"atomic","","Atomic types",null,null],[5,"hint_core_should_pause","std::sync::atomic","Save power or switch hyperthreads in a busy-wait spin-loop.",null,null],[3,"AtomicBool","","A boolean type which can be safely shared between threads.",null,null],[3,"AtomicPtr","","A raw pointer type which can be safely shared between threads.",null,null],[4,"Ordering","","Atomic memory orderings",null,null],[13,"Relaxed","","No ordering constraints, only atomic operations.",244,null],[13,"Release","","When coupled with a store, all previous writes become visible to the other threads that perform a load with [`Acquire`] ordering on the same value.",244,null],[13,"Acquire","","When coupled with a load, all subsequent loads will see data written before a store with [`Release`] ordering on the same value in other threads.",244,null],[13,"AcqRel","","When coupled with a load, uses [`Acquire`] ordering, and with a store [`Release`] ordering.",244,null],[13,"SeqCst","","Like `AcqRel` with the additional guarantee that all threads see all sequentially consistent operations in the same order.",244,null],[17,"ATOMIC_BOOL_INIT","","An [`AtomicBool`] initialized to `false`.",null,null],[3,"AtomicI8","","An integer type which can be safely shared between threads.",null,null],[17,"ATOMIC_I8_INIT","","An atomic integer initialized to `0`.",null,null],[3,"AtomicU8","","An integer type which can be safely shared between threads.",null,null],[17,"ATOMIC_U8_INIT","","An atomic integer initialized to `0`.",null,null],[3,"AtomicI16","","An integer type which can be safely shared between threads.",null,null],[17,"ATOMIC_I16_INIT","","An atomic integer initialized to `0`.",null,null],[3,"AtomicU16","","An integer type which can be safely shared between threads.",null,null],[17,"ATOMIC_U16_INIT","","An atomic integer initialized to `0`.",null,null],[3,"AtomicI32","","An integer type which can be safely shared between threads.",null,null],[17,"ATOMIC_I32_INIT","","An atomic integer initialized to `0`.",null,null],[3,"AtomicU32","","An integer type which can be safely shared between threads.",null,null],[17,"ATOMIC_U32_INIT","","An atomic integer initialized to `0`.",null,null],[3,"AtomicI64","","An integer type which can be safely shared between threads.",null,null],[17,"ATOMIC_I64_INIT","","An atomic integer initialized to `0`.",null,null],[3,"AtomicU64","","An integer type which can be safely shared between threads.",null,null],[17,"ATOMIC_U64_INIT","","An atomic integer initialized to `0`.",null,null],[3,"AtomicIsize","","An integer type which can be safely shared between threads.",null,null],[17,"ATOMIC_ISIZE_INIT","","An atomic integer initialized to `0`.",null,null],[3,"AtomicUsize","","An integer type which can be safely shared between threads.",null,null],[17,"ATOMIC_USIZE_INIT","","An atomic integer initialized to `0`.",null,null],[5,"fence","","An atomic fence.",null,null],[5,"compiler_fence","","A compiler memory fence.",null,null],[3,"Barrier","std::sync","A barrier enables multiple threads to synchronize the beginning of some computation.",null,null],[3,"BarrierWaitResult","","A `BarrierWaitResult` is returned by [`wait`] when all threads in the [`Barrier`] have rendezvoused.",null,null],[3,"Condvar","","A Condition Variable",null,null],[3,"WaitTimeoutResult","","A type indicating whether a timed wait on a condition variable returned due to a time out or not.",null,null],[3,"Mutex","","A mutual exclusion primitive useful for protecting shared data",null,null],[3,"MutexGuard","","An RAII implementation of a \"scoped lock\" of a mutex. When this structure is dropped (falls out of scope), the lock will be unlocked.",null,null],[3,"Once","","A synchronization primitive which can be used to run a one-time global initialization. Useful for one-time initialization for FFI or related functionality. This type can only be constructed with the [`ONCE_INIT`] value.",null,null],[3,"OnceState","","State yielded to the [`call_once_force`] method which can be used to query whether the [`Once`] was previously poisoned or not.",null,null],[3,"PoisonError","","A type of error which can be returned whenever a lock is acquired.",null,null],[3,"RwLock","","A reader-writer lock",null,null],[3,"RwLockReadGuard","","RAII structure used to release the shared read access of a lock when dropped.",null,null],[3,"RwLockWriteGuard","","RAII structure used to release the exclusive write access of a lock when dropped.",null,null],[4,"TryLockError","","An enumeration of possible errors associated with a [`TryLockResult`] which can occur while trying to aquire a lock, from the [`try_lock`] method on a [`Mutex`] or the [`try_read`] and [`try_write`] methods on an [`RwLock`].",null,null],[13,"Poisoned","","The lock could not be acquired because another thread failed while holding the lock.",245,null],[13,"WouldBlock","","The lock could not be acquired at this time because the operation would otherwise block.",245,null],[0,"mpsc","","Multi-producer, single-consumer FIFO queue communication primitives.",null,null],[3,"Select","std::sync::mpsc","The \"receiver set\" of the select interface. This structure is used to manage a set of receivers which are being selected over.",null,null],[3,"Handle","","A handle to a receiver which is currently a member of a `Select` set of receivers.  This handle is used to keep the receiver in the set as well as interact with the underlying receiver.",null,null],[3,"Receiver","","The receiving half of Rust's [`channel`][] (or [`sync_channel`]) type. This half can only be owned by one thread.",null,null],[3,"Iter","","An iterator over messages on a [`Receiver`], created by [`iter`].",null,null],[3,"TryIter","","An iterator that attempts to yield all pending values for a [`Receiver`], created by [`try_iter`].",null,null],[3,"IntoIter","","An owning iterator over messages on a [`Receiver`], created by Receiver::into_iter.",null,null],[3,"Sender","","The sending-half of Rust's asynchronous [`channel`] type. This half can only be owned by one thread, but it can be cloned to send to other threads.",null,null],[3,"SyncSender","","The sending-half of Rust's synchronous [`sync_channel`] type.",null,null],[3,"SendError","","An error returned from the [`Sender::send`] or [`SyncSender::send`] function on channels.",null,null],[12,"0","","",246,null],[3,"RecvError","","An error returned from the [`recv`] function on a [`Receiver`].",null,null],[4,"TryRecvError","","This enumeration is the list of the possible reasons that [`try_recv`] could not return data when called. This can occur with both a [`channel`] and a [`sync_channel`].",null,null],[13,"Empty","","This channel is currently empty, but the Sender(s) have not yet disconnected, so data may yet become available.",247,null],[13,"Disconnected","","The channel's sending half has become disconnected, and there will never be any more data received on it.",247,null],[4,"RecvTimeoutError","","This enumeration is the list of possible errors that made [`recv_timeout`] unable to return data when called. This can occur with both a [`channel`] and a [`sync_channel`].",null,null],[13,"Timeout","","This channel is currently empty, but the Sender(s) have not yet disconnected, so data may yet become available.",248,null],[13,"Disconnected","","The channel's sending half has become disconnected, and there will never be any more data received on it.",248,null],[4,"TrySendError","","This enumeration is the list of the possible error outcomes for the [`try_send`] method.",null,null],[13,"Full","","The data could not be sent on the [`sync_channel`] because it would require that the callee block to send the data.",249,null],[13,"Disconnected","","This [`sync_channel`]'s receiving half has disconnected, so the data could not be sent. The data is returned back to the callee in this case.",249,null],[5,"channel","","Creates a new asynchronous channel, returning the sender/receiver halves. All data sent on the [`Sender`] will become available on the [`Receiver`] in the same order as it was sent, and no [`send`] will block the calling thread (this channel has an \"infinite buffer\", unlike [`sync_channel`], which will block after its buffer limit is reached). [`recv`] will block until a message is available.",null,null],[5,"sync_channel","","Creates a new synchronous, bounded channel. All data sent on the [`SyncSender`] will become available on the [`Receiver`] in the same order as it was sent. Like asynchronous [`channel`]s, the [`Receiver`] will block until a message becomes available. `sync_channel` differs greatly in the semantics of the sender, however.",null,null],[11,"new","","Creates a new selection structure. This set is initially empty.",250,{"inputs":[],"output":{"name":"select"}}],[11,"handle","","Creates a new handle into this receiver set for a new receiver. Note that this does not add the receiver to the receiver set, for that you must call the `add` method on the handle itself.",250,{"inputs":[{"name":"self"},{"name":"receiver"}],"output":{"name":"handle"}}],[11,"wait","","Waits for an event on this receiver set. The returned value is not an index, but rather an id. This id can be queried against any active `Handle` structures (each one has an `id` method). The handle with the matching `id` will have some sort of event available on it. The event could either be that data is available or the corresponding channel has been closed.",250,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"id","","Retrieves the id of this handle.",251,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"recv","","Blocks to receive a value on the underlying receiver, returning `Some` on success or `None` if the channel disconnects. This function has the same semantics as `Receiver.recv`",251,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"add","","Adds this handle to the receiver set that the handle was created from. This method can be called multiple times, but it has no effect if `add` was called previously.",251,{"inputs":[{"name":"self"}],"output":null}],[11,"remove","","Removes this handle from the `Select` set. This method is unsafe because it has no guarantee that the `Handle` was not moved since `add` was called.",251,{"inputs":[{"name":"self"}],"output":null}],[11,"drop","","",250,{"inputs":[{"name":"self"}],"output":null}],[11,"drop","","",251,{"inputs":[{"name":"self"}],"output":null}],[11,"fmt","","",250,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",251,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",252,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",253,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",254,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",246,{"inputs":[{"name":"self"},{"name":"senderror"}],"output":{"name":"bool"}}],[11,"ne","","",246,{"inputs":[{"name":"self"},{"name":"senderror"}],"output":{"name":"bool"}}],[11,"clone","","",246,{"inputs":[{"name":"self"}],"output":{"name":"senderror"}}],[11,"eq","","",255,{"inputs":[{"name":"self"},{"name":"recverror"}],"output":{"name":"bool"}}],[11,"clone","","",255,{"inputs":[{"name":"self"}],"output":{"name":"recverror"}}],[11,"fmt","","",255,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",247,{"inputs":[{"name":"self"},{"name":"tryrecverror"}],"output":{"name":"bool"}}],[11,"clone","","",247,{"inputs":[{"name":"self"}],"output":{"name":"tryrecverror"}}],[11,"fmt","","",247,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",248,{"inputs":[{"name":"self"},{"name":"recvtimeouterror"}],"output":{"name":"bool"}}],[11,"clone","","",248,{"inputs":[{"name":"self"}],"output":{"name":"recvtimeouterror"}}],[11,"fmt","","",248,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",249,{"inputs":[{"name":"self"},{"name":"trysenderror"}],"output":{"name":"bool"}}],[11,"ne","","",249,{"inputs":[{"name":"self"},{"name":"trysenderror"}],"output":{"name":"bool"}}],[11,"clone","","",249,{"inputs":[{"name":"self"}],"output":{"name":"trysenderror"}}],[11,"send","","Attempts to send a value on this channel, returning it back if it could not be sent.",256,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"result"}}],[11,"clone","","",256,{"inputs":[{"name":"self"}],"output":{"name":"sender"}}],[11,"drop","","",256,{"inputs":[{"name":"self"}],"output":null}],[11,"fmt","","",256,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"send","","Sends a value on this synchronous channel.",257,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"result"}}],[11,"try_send","","Attempts to send a value on this channel without blocking.",257,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"result"}}],[11,"clone","","",257,{"inputs":[{"name":"self"}],"output":{"name":"syncsender"}}],[11,"drop","","",257,{"inputs":[{"name":"self"}],"output":null}],[11,"fmt","","",257,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"try_recv","","Attempts to return a pending value on this receiver without blocking.",258,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"recv","","Attempts to wait for a value on this receiver, returning an error if the corresponding channel has hung up.",258,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"recv_timeout","","Attempts to wait for a value on this receiver, returning an error if the corresponding channel has hung up, or if it waits more than `timeout`.",258,{"inputs":[{"name":"self"},{"name":"duration"}],"output":{"name":"result"}}],[11,"iter","","Returns an iterator that will block waiting for messages, but never [`panic!`]. It will return [`None`] when the channel has hung up.",258,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"try_iter","","Returns an iterator that will attempt to yield all pending values. It will return `None` if there are no more pending values or if the channel has hung up. The iterator will never [`panic!`] or block the user by waiting for values.",258,{"inputs":[{"name":"self"}],"output":{"name":"tryiter"}}],[11,"next","","",252,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",253,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",254,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"into_iter","","",258,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"drop","","",258,{"inputs":[{"name":"self"}],"output":null}],[11,"fmt","","",258,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",246,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",246,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"description","","",246,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"cause","","",246,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",249,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",249,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"description","","",249,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"cause","","",249,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",255,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"description","","",255,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"cause","","",255,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",247,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"description","","",247,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"cause","","",247,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",248,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"description","","",248,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"cause","","",248,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","std::sync","",259,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new barrier that can block a given number of threads.",259,{"inputs":[{"name":"usize"}],"output":{"name":"barrier"}}],[11,"wait","","Blocks the current thread until all threads have rendezvoused here.",259,{"inputs":[{"name":"self"}],"output":{"name":"barrierwaitresult"}}],[11,"fmt","","",260,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"is_leader","","Returns whether this thread from [`wait`] is the \"leader thread\".",260,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"fmt","","",261,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",261,{"inputs":[{"name":"self"},{"name":"waittimeoutresult"}],"output":{"name":"bool"}}],[11,"ne","","",261,{"inputs":[{"name":"self"},{"name":"waittimeoutresult"}],"output":{"name":"bool"}}],[11,"clone","","",261,{"inputs":[{"name":"self"}],"output":{"name":"waittimeoutresult"}}],[11,"timed_out","","Returns whether the wait was known to have timed out.",261,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"new","","Creates a new condition variable which is ready to be waited on and notified.",262,{"inputs":[],"output":{"name":"condvar"}}],[11,"wait","","Blocks the current thread until this condition variable receives a notification.",262,{"inputs":[{"name":"self"},{"name":"mutexguard"}],"output":{"name":"lockresult"}}],[11,"wait_timeout_ms","","Waits on this condition variable for a notification, timing out after a specified duration.",262,{"inputs":[{"name":"self"},{"name":"mutexguard"},{"name":"u32"}],"output":{"name":"lockresult"}}],[11,"wait_timeout","","Waits on this condition variable for a notification, timing out after a specified duration.",262,{"inputs":[{"name":"self"},{"name":"mutexguard"},{"name":"duration"}],"output":{"name":"lockresult"}}],[11,"notify_one","","Wakes up one blocked thread on this condvar.",262,{"inputs":[{"name":"self"}],"output":null}],[11,"notify_all","","Wakes up all blocked threads on this condvar.",262,{"inputs":[{"name":"self"}],"output":null}],[11,"fmt","","",262,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"default","","Creates a `Condvar` which is ready to be waited on and notified.",262,{"inputs":[],"output":{"name":"condvar"}}],[11,"drop","","",262,{"inputs":[{"name":"self"}],"output":null}],[11,"new","","Creates a new mutex in an unlocked state ready for use.",263,{"inputs":[{"name":"t"}],"output":{"name":"mutex"}}],[11,"lock","","Acquires a mutex, blocking the current thread until it is able to do so.",263,{"inputs":[{"name":"self"}],"output":{"name":"lockresult"}}],[11,"try_lock","","Attempts to acquire this lock.",263,{"inputs":[{"name":"self"}],"output":{"name":"trylockresult"}}],[11,"is_poisoned","","Determines whether the mutex is poisoned.",263,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"into_inner","","Consumes this mutex, returning the underlying data.",263,{"inputs":[{"name":"self"}],"output":{"name":"lockresult"}}],[11,"get_mut","","Returns a mutable reference to the underlying data.",263,{"inputs":[{"name":"self"}],"output":{"name":"lockresult"}}],[11,"drop","","",263,{"inputs":[{"name":"self"}],"output":null}],[11,"default","","Creates a `Mutex<T>`, with the `Default` value for T.",263,{"inputs":[],"output":{"name":"mutex"}}],[11,"fmt","","",263,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"deref","","",264,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"deref_mut","","",264,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"drop","","",264,{"inputs":[{"name":"self"}],"output":null}],[11,"fmt","","",264,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",264,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",265,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new `Once` value.",266,{"inputs":[],"output":{"name":"once"}}],[11,"call_once","","Performs an initialization routine once and only once. The given closure will be executed if this is the first time `call_once` has been called, and otherwise the routine will not be invoked.",266,{"inputs":[{"name":"self"},{"name":"f"}],"output":null}],[11,"call_once_force","","Performs the same function as [`call_once`] except ignores poisoning.",266,{"inputs":[{"name":"self"},{"name":"f"}],"output":null}],[11,"fmt","","",266,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"poisoned","","Returns whether the associated [`Once`] has been poisoned.",265,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"new","","Creates a new instance of an `RwLock<T>` which is unlocked.",267,{"inputs":[{"name":"t"}],"output":{"name":"rwlock"}}],[11,"read","","Locks this rwlock with shared read access, blocking the current thread until it can be acquired.",267,{"inputs":[{"name":"self"}],"output":{"name":"lockresult"}}],[11,"try_read","","Attempts to acquire this rwlock with shared read access.",267,{"inputs":[{"name":"self"}],"output":{"name":"trylockresult"}}],[11,"write","","Locks this rwlock with exclusive write access, blocking the current thread until it can be acquired.",267,{"inputs":[{"name":"self"}],"output":{"name":"lockresult"}}],[11,"try_write","","Attempts to lock this rwlock with exclusive write access.",267,{"inputs":[{"name":"self"}],"output":{"name":"trylockresult"}}],[11,"is_poisoned","","Determines whether the lock is poisoned.",267,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"into_inner","","Consumes this `RwLock`, returning the underlying data.",267,{"inputs":[{"name":"self"}],"output":{"name":"lockresult"}}],[11,"get_mut","","Returns a mutable reference to the underlying data.",267,{"inputs":[{"name":"self"}],"output":{"name":"lockresult"}}],[11,"drop","","",267,{"inputs":[{"name":"self"}],"output":null}],[11,"fmt","","",267,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"default","","Creates a new `RwLock<T>`, with the `Default` value for T.",267,{"inputs":[],"output":{"name":"rwlock"}}],[11,"fmt","","",268,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",268,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",269,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",269,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"deref","","",268,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"deref","","",269,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"deref_mut","","",269,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"drop","","",268,{"inputs":[{"name":"self"}],"output":null}],[11,"drop","","",269,{"inputs":[{"name":"self"}],"output":null}],[6,"TryLockResult","","A type alias for the result of a nonblocking locking method.",null,null],[6,"LockResult","","A type alias for the result of a lock method which can be poisoned.",null,null],[17,"ONCE_INIT","","Initialization value for static [`Once`] values.",null,null],[0,"time","std","Temporal quantification.",null,null],[3,"Duration","std::time","A `Duration` type to represent a span of time, typically used for system timeouts.",null,null],[3,"Instant","","A measurement of a monotonically nondecreasing clock. Opaque and useful only with `Duration`.",null,null],[3,"SystemTime","","A measurement of the system clock, useful for talking to external entities like the file system or other processes.",null,null],[3,"SystemTimeError","","An error returned from the `duration_since` and `elapsed` methods on `SystemTime`, used to learn how far in the opposite direction a system time lies.",null,null],[11,"clone","","",270,{"inputs":[{"name":"self"}],"output":{"name":"duration"}}],[11,"eq","","",270,{"inputs":[{"name":"self"},{"name":"duration"}],"output":{"name":"bool"}}],[11,"ne","","",270,{"inputs":[{"name":"self"},{"name":"duration"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",270,{"inputs":[{"name":"self"},{"name":"duration"}],"output":{"name":"option"}}],[11,"lt","","",270,{"inputs":[{"name":"self"},{"name":"duration"}],"output":{"name":"bool"}}],[11,"le","","",270,{"inputs":[{"name":"self"},{"name":"duration"}],"output":{"name":"bool"}}],[11,"gt","","",270,{"inputs":[{"name":"self"},{"name":"duration"}],"output":{"name":"bool"}}],[11,"ge","","",270,{"inputs":[{"name":"self"},{"name":"duration"}],"output":{"name":"bool"}}],[11,"cmp","","",270,{"inputs":[{"name":"self"},{"name":"duration"}],"output":{"name":"ordering"}}],[11,"fmt","","",270,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",270,null],[11,"default","","",270,{"inputs":[],"output":{"name":"duration"}}],[11,"new","","Creates a new `Duration` from the specified number of whole seconds and additional nanoseconds.",270,{"inputs":[{"name":"u64"},{"name":"u32"}],"output":{"name":"duration"}}],[11,"from_secs","","Creates a new `Duration` from the specified number of whole seconds.",270,{"inputs":[{"name":"u64"}],"output":{"name":"duration"}}],[11,"from_millis","","Creates a new `Duration` from the specified number of milliseconds.",270,{"inputs":[{"name":"u64"}],"output":{"name":"duration"}}],[11,"from_micros","","Creates a new `Duration` from the specified number of microseconds.",270,{"inputs":[{"name":"u64"}],"output":{"name":"duration"}}],[11,"as_secs","","Returns the number of whole seconds contained by this `Duration`.",270,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"subsec_nanos","","Returns the fractional part of this `Duration`, in nanoseconds.",270,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"checked_add","","Checked `Duration` addition. Computes `self + other`, returning [`None`] if overflow occurred.",270,{"inputs":[{"name":"self"},{"name":"duration"}],"output":{"name":"option"}}],[11,"checked_sub","","Checked `Duration` subtraction. Computes `self - other`, returning [`None`] if the result would be negative or if underflow occurred.",270,{"inputs":[{"name":"self"},{"name":"duration"}],"output":{"name":"option"}}],[11,"checked_mul","","Checked `Duration` multiplication. Computes `self * other`, returning [`None`] if overflow occurred.",270,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"option"}}],[11,"checked_div","","Checked `Duration` division. Computes `self / other`, returning [`None`] if `other == 0`.",270,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"option"}}],[11,"add","","",270,{"inputs":[{"name":"self"},{"name":"duration"}],"output":{"name":"duration"}}],[11,"add_assign","","",270,{"inputs":[{"name":"self"},{"name":"duration"}],"output":null}],[11,"sub","","",270,{"inputs":[{"name":"self"},{"name":"duration"}],"output":{"name":"duration"}}],[11,"sub_assign","","",270,{"inputs":[{"name":"self"},{"name":"duration"}],"output":null}],[11,"mul","","",270,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"duration"}}],[11,"mul_assign","","",270,{"inputs":[{"name":"self"},{"name":"u32"}],"output":null}],[11,"div","","",270,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"duration"}}],[11,"div_assign","","",270,{"inputs":[{"name":"self"},{"name":"u32"}],"output":null}],[11,"sum","","",270,{"inputs":[{"name":"i"}],"output":{"name":"duration"}}],[11,"sum","","",270,{"inputs":[{"name":"i"}],"output":{"name":"duration"}}],[17,"UNIX_EPOCH","","An anchor in time which can be used to create new `SystemTime` instances or learn about where in time a `SystemTime` lies.",null,null],[11,"clone","","",271,{"inputs":[{"name":"self"}],"output":{"name":"instant"}}],[11,"eq","","",271,{"inputs":[{"name":"self"},{"name":"instant"}],"output":{"name":"bool"}}],[11,"ne","","",271,{"inputs":[{"name":"self"},{"name":"instant"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",271,{"inputs":[{"name":"self"},{"name":"instant"}],"output":{"name":"option"}}],[11,"lt","","",271,{"inputs":[{"name":"self"},{"name":"instant"}],"output":{"name":"bool"}}],[11,"le","","",271,{"inputs":[{"name":"self"},{"name":"instant"}],"output":{"name":"bool"}}],[11,"gt","","",271,{"inputs":[{"name":"self"},{"name":"instant"}],"output":{"name":"bool"}}],[11,"ge","","",271,{"inputs":[{"name":"self"},{"name":"instant"}],"output":{"name":"bool"}}],[11,"cmp","","",271,{"inputs":[{"name":"self"},{"name":"instant"}],"output":{"name":"ordering"}}],[11,"clone","","",272,{"inputs":[{"name":"self"}],"output":{"name":"systemtime"}}],[11,"eq","","",272,{"inputs":[{"name":"self"},{"name":"systemtime"}],"output":{"name":"bool"}}],[11,"ne","","",272,{"inputs":[{"name":"self"},{"name":"systemtime"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",272,{"inputs":[{"name":"self"},{"name":"systemtime"}],"output":{"name":"option"}}],[11,"lt","","",272,{"inputs":[{"name":"self"},{"name":"systemtime"}],"output":{"name":"bool"}}],[11,"le","","",272,{"inputs":[{"name":"self"},{"name":"systemtime"}],"output":{"name":"bool"}}],[11,"gt","","",272,{"inputs":[{"name":"self"},{"name":"systemtime"}],"output":{"name":"bool"}}],[11,"ge","","",272,{"inputs":[{"name":"self"},{"name":"systemtime"}],"output":{"name":"bool"}}],[11,"cmp","","",272,{"inputs":[{"name":"self"},{"name":"systemtime"}],"output":{"name":"ordering"}}],[11,"clone","","",273,{"inputs":[{"name":"self"}],"output":{"name":"systemtimeerror"}}],[11,"fmt","","",273,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"now","","Returns an instant corresponding to \"now\".",271,{"inputs":[],"output":{"name":"instant"}}],[11,"duration_since","","Returns the amount of time elapsed from another instant to this one.",271,{"inputs":[{"name":"self"},{"name":"instant"}],"output":{"name":"duration"}}],[11,"elapsed","","Returns the amount of time elapsed since this instant was created.",271,{"inputs":[{"name":"self"}],"output":{"name":"duration"}}],[11,"add","","",271,{"inputs":[{"name":"self"},{"name":"duration"}],"output":{"name":"instant"}}],[11,"add_assign","","",271,{"inputs":[{"name":"self"},{"name":"duration"}],"output":null}],[11,"sub","","",271,{"inputs":[{"name":"self"},{"name":"duration"}],"output":{"name":"instant"}}],[11,"sub_assign","","",271,{"inputs":[{"name":"self"},{"name":"duration"}],"output":null}],[11,"sub","","",271,{"inputs":[{"name":"self"},{"name":"instant"}],"output":{"name":"duration"}}],[11,"fmt","","",271,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"now","","Returns the system time corresponding to \"now\".",272,{"inputs":[],"output":{"name":"systemtime"}}],[11,"duration_since","","Returns the amount of time elapsed from an earlier point in time.",272,{"inputs":[{"name":"self"},{"name":"systemtime"}],"output":{"name":"result"}}],[11,"elapsed","","Returns the amount of time elapsed since this system time was created.",272,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"add","","",272,{"inputs":[{"name":"self"},{"name":"duration"}],"output":{"name":"systemtime"}}],[11,"add_assign","","",272,{"inputs":[{"name":"self"},{"name":"duration"}],"output":null}],[11,"sub","","",272,{"inputs":[{"name":"self"},{"name":"duration"}],"output":{"name":"systemtime"}}],[11,"sub_assign","","",272,{"inputs":[{"name":"self"},{"name":"duration"}],"output":null}],[11,"fmt","","",272,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"duration","","Returns the positive duration which represents how far forward the second system time was from the first.",273,{"inputs":[{"name":"self"}],"output":{"name":"duration"}}],[11,"description","","",273,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"fmt","","",273,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[0,"heap","std","dox",null,null],[3,"Heap","std::heap","",null,null],[8,"Alloc","","An implementation of `Alloc` can allocate, reallocate, and deallocate arbitrary blocks of data described via `Layout`.",null,null],[10,"alloc","","Returns a pointer meeting the size and alignment guarantees of `layout`.",274,{"inputs":[{"name":"self"},{"name":"layout"}],"output":{"name":"result"}}],[10,"dealloc","","Deallocate the memory referenced by `ptr`.",274,null],[11,"oom","","Allocator-specific method for signaling an out-of-memory condition.",274,null],[11,"usable_size","","Returns bounds on the guaranteed usable size of a successful allocation created with the specified `layout`.",274,null],[11,"realloc","","Returns a pointer suitable for holding data described by `new_layout`, meeting its size and alignment guarantees. To accomplish this, this may extend or shrink the allocation referenced by `ptr` to fit `new_layout`.",274,null],[11,"alloc_zeroed","","Behaves like `alloc`, but also ensures that the contents are set to zero before being returned.",274,{"inputs":[{"name":"self"},{"name":"layout"}],"output":{"name":"result"}}],[11,"alloc_excess","","Behaves like `alloc`, but also returns the whole size of the returned block. For some `layout` inputs, like arrays, this may include extra storage usable for additional data.",274,{"inputs":[{"name":"self"},{"name":"layout"}],"output":{"name":"result"}}],[11,"realloc_excess","","Behaves like `realloc`, but also returns the whole size of the returned block. For some `layout` inputs, like arrays, this may include extra storage usable for additional data.",274,null],[11,"grow_in_place","","Attempts to extend the allocation referenced by `ptr` to fit `new_layout`.",274,null],[11,"shrink_in_place","","Attempts to shrink the allocation referenced by `ptr` to fit `new_layout`.",274,null],[11,"alloc_one","","Allocates a block suitable for holding an instance of `T`.",274,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"dealloc_one","","Deallocates a block suitable for holding an instance of `T`.",274,null],[11,"alloc_array","","Allocates a block suitable for holding `n` instances of `T`.",274,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"result"}}],[11,"realloc_array","","Reallocates a block previously suitable for holding `n_old` instances of `T`, returning a block suitable for holding `n_new` instances of `T`.",274,{"inputs":[{"name":"self"},{"name":"unique"},{"name":"usize"},{"name":"usize"}],"output":{"name":"result"}}],[11,"dealloc_array","","Deallocates a block suitable for holding `n` instances of `T`.",274,{"inputs":[{"name":"self"},{"name":"unique"},{"name":"usize"}],"output":{"name":"result"}}],[3,"Layout","","Layout of a block of memory.",null,null],[3,"Excess","","Represents the combination of a starting address and a total capacity of the returned block.",null,null],[12,"0","","",275,null],[12,"1","","",275,null],[3,"CannotReallocInPlace","","The `CannotReallocInPlace` error is used when `grow_in_place` or `shrink_in_place` were unable to reuse the given memory block for a requested layout.",null,null],[4,"AllocErr","","The `AllocErr` error specifies whether an allocation failure is specifically due to resource exhaustion or if it is due to something wrong when combining the given input arguments with this allocator.",null,null],[13,"Exhausted","","Error due to hitting some resource limit or otherwise running out of memory. This condition strongly implies that some series of deallocations would allow a subsequent reissuing of the original allocation request to succeed.",276,null],[12,"request","std::heap::AllocErr","",276,null],[13,"Unsupported","std::heap","Error due to allocator being fundamentally incapable of satisfying the original request. This condition implies that such an allocation request will never succeed on the given allocator, regardless of environment, memory pressure, or other contextual conditions.",276,null],[12,"details","std::heap::AllocErr","",276,null],[3,"System","std::heap","",null,null],[11,"fmt","std::sync","",277,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",277,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"description","","",277,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"new","","Creates a `PoisonError`.",277,{"inputs":[{"name":"t"}],"output":{"name":"poisonerror"}}],[11,"into_inner","","Consumes this error indicating that a lock is poisoned, returning the underlying guard to allow access regardless.",277,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"get_ref","","Reaches into this error indicating that a lock is poisoned, returning a reference to the underlying guard to allow access regardless.",277,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"get_mut","","Reaches into this error indicating that a lock is poisoned, returning a mutable reference to the underlying guard to allow access regardless.",277,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"from","","",245,{"inputs":[{"name":"poisonerror"}],"output":{"name":"trylockerror"}}],[11,"fmt","","",245,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",245,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"description","","",245,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"cause","","",245,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","std::os::windows::ffi","",278,{"inputs":[{"name":"self"}],"output":{"name":"encodewide"}}],[11,"next","","",278,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",278,null],[11,"as_raw_fd","std::fs","",147,{"inputs":[{"name":"self"}],"output":{"name":"rawfd"}}],[11,"from_raw_fd","","",147,{"inputs":[{"name":"rawfd"}],"output":{"name":"file"}}],[11,"into_raw_fd","","",147,{"inputs":[{"name":"self"}],"output":{"name":"rawfd"}}],[11,"as_raw_fd","std::io","",161,{"inputs":[{"name":"self"}],"output":{"name":"rawfd"}}],[11,"as_raw_fd","","",163,{"inputs":[{"name":"self"}],"output":{"name":"rawfd"}}],[11,"as_raw_fd","","",165,{"inputs":[{"name":"self"}],"output":{"name":"rawfd"}}],[11,"from_vec","std::ffi","",138,{"inputs":[{"name":"vec"}],"output":{"name":"osstring"}}],[11,"into_vec","","",138,{"inputs":[{"name":"self"}],"output":{"name":"vec"}}],[11,"from_bytes","","",139,null],[11,"as_bytes","","",139,null],[11,"read_at","std::fs","",147,null],[11,"write_at","","",147,null],[11,"mode","","",144,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"set_mode","","",144,{"inputs":[{"name":"self"},{"name":"u32"}],"output":null}],[11,"from_mode","","",144,{"inputs":[{"name":"u32"}],"output":{"name":"permissions"}}],[11,"mode","","",143,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"openoptions"}}],[11,"custom_flags","","",143,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"openoptions"}}],[11,"dev","","",141,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"ino","","",141,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"mode","","",141,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"nlink","","",141,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"uid","","",141,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"gid","","",141,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"rdev","","",141,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"size","","",141,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"atime","","",141,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[11,"atime_nsec","","",141,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[11,"mtime","","",141,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[11,"mtime_nsec","","",141,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[11,"ctime","","",141,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[11,"ctime_nsec","","",141,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[11,"blksize","","",141,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"blocks","","",141,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"is_block_device","","",145,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_char_device","","",145,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_fifo","","",145,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_socket","","",145,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"ino","","",148,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"mode","","",146,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"dirbuilder"}}],[11,"uid","std::process","",241,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"command"}}],[11,"gid","","",241,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"command"}}],[11,"before_exec","","",241,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"command"}}],[11,"exec","","",241,{"inputs":[{"name":"self"}],"output":{"name":"error"}}],[11,"from_raw","","",243,{"inputs":[{"name":"i32"}],"output":{"name":"self"}}],[11,"signal","","",243,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"from_raw_fd","","",242,{"inputs":[{"name":"rawfd"}],"output":{"name":"stdio"}}],[11,"as_raw_fd","","",238,{"inputs":[{"name":"self"}],"output":{"name":"rawfd"}}],[11,"as_raw_fd","","",239,{"inputs":[{"name":"self"}],"output":{"name":"rawfd"}}],[11,"as_raw_fd","","",240,{"inputs":[{"name":"self"}],"output":{"name":"rawfd"}}],[11,"into_raw_fd","","",238,{"inputs":[{"name":"self"}],"output":{"name":"rawfd"}}],[11,"into_raw_fd","","",239,{"inputs":[{"name":"self"}],"output":{"name":"rawfd"}}],[11,"into_raw_fd","","",240,{"inputs":[{"name":"self"}],"output":{"name":"rawfd"}}],[11,"as_pthread_t","std::thread","",102,{"inputs":[{"name":"self"}],"output":{"name":"rawpthread"}}],[11,"into_pthread_t","","",102,{"inputs":[{"name":"self"}],"output":{"name":"rawpthread"}}],[11,"clone","std::os::unix::net","",279,{"inputs":[{"name":"self"}],"output":{"name":"socketaddr"}}],[11,"is_unnamed","","Returns true if and only if the address is unnamed.",279,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"as_pathname","","Returns the contents of this address if it is a `pathname` address.",279,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",279,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",280,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"connect","","Connects to the socket named by `path`.",280,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[11,"pair","","Creates an unnamed pair of connected sockets.",280,{"inputs":[],"output":{"name":"result"}}],[11,"try_clone","","Creates a new independently owned handle to the underlying socket.",280,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"local_addr","","Returns the socket address of the local half of this connection.",280,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"peer_addr","","Returns the socket address of the remote half of this connection.",280,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"set_read_timeout","","Sets the read timeout for the socket.",280,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"name":"result"}}],[11,"set_write_timeout","","Sets the write timeout for the socket.",280,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"name":"result"}}],[11,"read_timeout","","Returns the read timeout of this socket.",280,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"write_timeout","","Returns the write timeout of this socket.",280,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"set_nonblocking","","Moves the socket into or out of nonblocking mode.",280,{"inputs":[{"name":"self"},{"name":"bool"}],"output":{"name":"result"}}],[11,"take_error","","Returns the value of the `SO_ERROR` option.",280,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"shutdown","","Shuts down the read, write, or both halves of this connection.",280,{"inputs":[{"name":"self"},{"name":"shutdown"}],"output":{"name":"result"}}],[11,"read","","",280,null],[11,"initializer","","",280,{"inputs":[{"name":"self"}],"output":{"name":"initializer"}}],[11,"write","","",280,null],[11,"flush","","",280,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"as_raw_fd","","",280,{"inputs":[{"name":"self"}],"output":{"name":"rawfd"}}],[11,"from_raw_fd","","",280,{"inputs":[{"name":"rawfd"}],"output":{"name":"unixstream"}}],[11,"into_raw_fd","","",280,{"inputs":[{"name":"self"}],"output":{"name":"rawfd"}}],[11,"as_raw_fd","std::net","",187,{"inputs":[{"name":"self"}],"output":{"name":"rawfd"}}],[11,"as_raw_fd","","",188,{"inputs":[{"name":"self"}],"output":{"name":"rawfd"}}],[11,"as_raw_fd","","",189,{"inputs":[{"name":"self"}],"output":{"name":"rawfd"}}],[11,"from_raw_fd","","",187,{"inputs":[{"name":"rawfd"}],"output":{"name":"tcpstream"}}],[11,"from_raw_fd","","",188,{"inputs":[{"name":"rawfd"}],"output":{"name":"tcplistener"}}],[11,"from_raw_fd","","",189,{"inputs":[{"name":"rawfd"}],"output":{"name":"udpsocket"}}],[11,"into_raw_fd","","",187,{"inputs":[{"name":"self"}],"output":{"name":"rawfd"}}],[11,"into_raw_fd","","",188,{"inputs":[{"name":"self"}],"output":{"name":"rawfd"}}],[11,"into_raw_fd","","",189,{"inputs":[{"name":"self"}],"output":{"name":"rawfd"}}],[11,"fmt","std::os::unix::net","",281,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"bind","","Creates a new `UnixListener` bound to the specified socket.",281,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[11,"accept","","Accepts a new incoming connection to this listener.",281,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"try_clone","","Creates a new independently owned handle to the underlying socket.",281,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"local_addr","","Returns the local socket address of this listener.",281,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"set_nonblocking","","Moves the socket into or out of nonblocking mode.",281,{"inputs":[{"name":"self"},{"name":"bool"}],"output":{"name":"result"}}],[11,"take_error","","Returns the value of the `SO_ERROR` option.",281,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"incoming","","Returns an iterator over incoming connections.",281,{"inputs":[{"name":"self"}],"output":{"name":"incoming"}}],[11,"as_raw_fd","","",281,{"inputs":[{"name":"self"}],"output":{"name":"rawfd"}}],[11,"from_raw_fd","","",281,{"inputs":[{"name":"rawfd"}],"output":{"name":"unixlistener"}}],[11,"into_raw_fd","","",281,{"inputs":[{"name":"self"}],"output":{"name":"rawfd"}}],[11,"fmt","","",282,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",282,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",282,null],[11,"fmt","","",283,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"bind","","Creates a Unix datagram socket bound to the given path.",283,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[11,"unbound","","Creates a Unix Datagram socket which is not bound to any address.",283,{"inputs":[],"output":{"name":"result"}}],[11,"pair","","Create an unnamed pair of connected sockets.",283,{"inputs":[],"output":{"name":"result"}}],[11,"connect","","Connects the socket to the specified address.",283,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"result"}}],[11,"try_clone","","Creates a new independently owned handle to the underlying socket.",283,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"local_addr","","Returns the address of this socket.",283,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"peer_addr","","Returns the address of this socket's peer.",283,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"recv_from","","Receives data from the socket.",283,null],[11,"recv","","Receives data from the socket.",283,null],[11,"send_to","","Sends data on the socket to the specified address.",283,null],[11,"send","","Sends data on the socket to the socket's peer.",283,null],[11,"set_read_timeout","","Sets the read timeout for the socket.",283,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"name":"result"}}],[11,"set_write_timeout","","Sets the write timeout for the socket.",283,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"name":"result"}}],[11,"read_timeout","","Returns the read timeout of this socket.",283,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"write_timeout","","Returns the write timeout of this socket.",283,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"set_nonblocking","","Moves the socket into or out of nonblocking mode.",283,{"inputs":[{"name":"self"},{"name":"bool"}],"output":{"name":"result"}}],[11,"take_error","","Returns the value of the `SO_ERROR` option.",283,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"shutdown","","Shut down the read, write, or both halves of this connection.",283,{"inputs":[{"name":"self"},{"name":"shutdown"}],"output":{"name":"result"}}],[11,"as_raw_fd","","",283,{"inputs":[{"name":"self"}],"output":{"name":"rawfd"}}],[11,"from_raw_fd","","",283,{"inputs":[{"name":"rawfd"}],"output":{"name":"unixdatagram"}}],[11,"into_raw_fd","","",283,{"inputs":[{"name":"self"}],"output":{"name":"rawfd"}}],[11,"from_wide","std::ffi","",138,null],[11,"encode_wide","","",139,{"inputs":[{"name":"self"}],"output":{"name":"encodewide"}}],[11,"seek_read","std::fs","",147,null],[11,"seek_write","","",147,null],[11,"access_mode","","",143,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"openoptions"}}],[11,"share_mode","","",143,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"openoptions"}}],[11,"custom_flags","","",143,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"openoptions"}}],[11,"attributes","","",143,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"openoptions"}}],[11,"security_qos_flags","","",143,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"openoptions"}}],[11,"file_attributes","","",141,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"creation_time","","",141,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"last_access_time","","",141,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"last_write_time","","",141,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"file_size","","",141,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"as_raw_handle","","",147,{"inputs":[{"name":"self"}],"output":{"name":"rawhandle"}}],[11,"as_raw_handle","std::io","",161,{"inputs":[{"name":"self"}],"output":{"name":"rawhandle"}}],[11,"as_raw_handle","","",163,{"inputs":[{"name":"self"}],"output":{"name":"rawhandle"}}],[11,"as_raw_handle","","",165,{"inputs":[{"name":"self"}],"output":{"name":"rawhandle"}}],[11,"from_raw_handle","std::fs","",147,{"inputs":[{"name":"rawhandle"}],"output":{"name":"file"}}],[11,"into_raw_handle","","",147,{"inputs":[{"name":"self"}],"output":{"name":"rawhandle"}}],[11,"as_raw_socket","std::net","",187,{"inputs":[{"name":"self"}],"output":{"name":"rawsocket"}}],[11,"as_raw_socket","","",188,{"inputs":[{"name":"self"}],"output":{"name":"rawsocket"}}],[11,"as_raw_socket","","",189,{"inputs":[{"name":"self"}],"output":{"name":"rawsocket"}}],[11,"from_raw_socket","","",187,{"inputs":[{"name":"rawsocket"}],"output":{"name":"tcpstream"}}],[11,"from_raw_socket","","",188,{"inputs":[{"name":"rawsocket"}],"output":{"name":"tcplistener"}}],[11,"from_raw_socket","","",189,{"inputs":[{"name":"rawsocket"}],"output":{"name":"udpsocket"}}],[11,"into_raw_socket","","",187,{"inputs":[{"name":"self"}],"output":{"name":"rawsocket"}}],[11,"into_raw_socket","","",188,{"inputs":[{"name":"self"}],"output":{"name":"rawsocket"}}],[11,"into_raw_socket","","",189,{"inputs":[{"name":"self"}],"output":{"name":"rawsocket"}}],[11,"from_raw_handle","std::process","",242,{"inputs":[{"name":"rawhandle"}],"output":{"name":"stdio"}}],[11,"as_raw_handle","","",236,{"inputs":[{"name":"self"}],"output":{"name":"rawhandle"}}],[11,"into_raw_handle","","",236,{"inputs":[{"name":"self"}],"output":{"name":"rawhandle"}}],[11,"as_raw_handle","","",238,{"inputs":[{"name":"self"}],"output":{"name":"rawhandle"}}],[11,"as_raw_handle","","",239,{"inputs":[{"name":"self"}],"output":{"name":"rawhandle"}}],[11,"as_raw_handle","","",240,{"inputs":[{"name":"self"}],"output":{"name":"rawhandle"}}],[11,"into_raw_handle","","",238,{"inputs":[{"name":"self"}],"output":{"name":"rawhandle"}}],[11,"into_raw_handle","","",239,{"inputs":[{"name":"self"}],"output":{"name":"rawhandle"}}],[11,"into_raw_handle","","",240,{"inputs":[{"name":"self"}],"output":{"name":"rawhandle"}}],[11,"from_raw","","",243,{"inputs":[{"name":"u32"}],"output":{"name":"self"}}],[11,"creation_flags","","",241,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"command"}}],[11,"as_raw_handle","std::thread","",102,{"inputs":[{"name":"self"}],"output":{"name":"rawhandle"}}],[11,"into_raw_handle","","",102,{"inputs":[{"name":"self"}],"output":{"name":"rawhandle"}}],[11,"fmt","std::panic","",284,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"payload","","Returns the payload associated with the panic.",284,{"inputs":[{"name":"self"}],"output":{"name":"any"}}],[11,"location","","Returns information about the location from which the panic originated, if available.",284,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",285,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"file","","Returns the name of the source file from which the panic originated.",285,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"line","","Returns the line number from which the panic originated.",285,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"column","","Returns the column from which the panic originated.",285,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[14,"format","std","Creates a `String` using interpolation of runtime expressions.",null,null],[14,"vec","","Creates a [`Vec`] containing the arguments.",null,null],[14,"try","","Helper macro for reducing boilerplate code for matching `Result` together with converting downstream errors.",null,null],[14,"writeln","","Write formatted data into a buffer, with a newline appended.",null,null],[14,"write","","Write formatted data into a buffer",null,null],[14,"unimplemented","","A standardized placeholder for marking unfinished code.",null,null],[14,"unreachable","","A utility macro for indicating unreachable code.",null,null],[14,"debug_assert_ne","","Asserts that two expressions are not equal to each other.",null,null],[14,"debug_assert_eq","","Asserts that two expressions are equal to each other.",null,null],[14,"debug_assert","","Ensure that a boolean expression is `true` at runtime.",null,null],[14,"assert_ne","","Asserts that two expressions are not equal to each other (using [`PartialEq`]).",null,null],[14,"assert_eq","","Asserts that two expressions are equal to each other (using [`PartialEq`]).",null,null],[14,"assert","","Ensure that a boolean expression is `true` at runtime.",null,null],[14,"panic","","The entry point for panic of Rust threads.",null,null],[14,"print","","Macro for printing to the standard output.",null,null],[14,"println","","Macro for printing to the standard output, with a newline.",null,null],[14,"eprint","","Macro for printing to the standard error.",null,null],[14,"eprintln","","Macro for printing to the standard error, with a newline.",null,null],[14,"select","","A macro to select an event from a number of receivers.",null,null],[14,"compile_error","","Unconditionally causes compilation to fail with the given error message when encountered.",null,null],[14,"format_args","","The core macro for formatted string creation & output.",null,null],[14,"env","","Inspect an environment variable at compile time.",null,null],[14,"option_env","","Optionally inspect an environment variable at compile time.",null,null],[14,"concat_idents","","Concatenate identifiers into one identifier.",null,null],[14,"concat","","Concatenates literals into a static string slice.",null,null],[14,"line","","A macro which expands to the line number on which it was invoked.",null,null],[14,"column","","A macro which expands to the column number on which it was invoked.",null,null],[14,"file","","A macro which expands to the file name from which it was invoked.",null,null],[14,"stringify","","A macro which stringifies its argument.",null,null],[14,"include_str","","Includes a utf8-encoded file as a string.",null,null],[14,"include_bytes","","Includes a file as a reference to a byte array.",null,null],[14,"module_path","","Expands to a string that represents the current module path.",null,null],[14,"cfg","","Boolean evaluation of configuration flags.",null,null],[14,"include","","Parse a file as an expression or an item according to the context.",null,null],[14,"thread_local","","Declare a new thread local storage key of type [`std::thread::LocalKey`].",null,null],[15,"bool","","The boolean type.",null,null],[15,"char","","A character type.",null,null],[15,"pointer","","Raw, unsafe pointers, `*const T`, and `*mut T`.",null,null],[15,"array","","A fixed-size array, denoted `[T; N]`, for the element type, `T`, and the non-negative compile-time constant size, `N`.",null,null],[15,"slice","","A dynamically-sized view into a contiguous sequence, `[T]`.",null,null],[15,"str","","String slices.",null,null],[15,"tuple","","A finite heterogeneous sequence, `(T, U, ..)`.",null,null],[15,"f32","","The 32-bit floating point type.",null,null],[15,"f64","","The 64-bit floating point type.",null,null],[15,"i8","","The 8-bit signed integer type.",null,null],[15,"i16","","The 16-bit signed integer type.",null,null],[15,"i32","","The 32-bit signed integer type.",null,null],[15,"i64","","The 64-bit signed integer type.",null,null],[15,"i128","","The 128-bit signed integer type.",null,null],[15,"u8","","The 8-bit unsigned integer type.",null,null],[15,"u16","","The 16-bit unsigned integer type.",null,null],[15,"u32","","The 32-bit unsigned integer type.",null,null],[15,"u64","","The 64-bit unsigned integer type.",null,null],[15,"u128","","The 128-bit unsigned integer type.",null,null],[15,"isize","","The pointer-sized signed integer type.",null,null],[15,"usize","","The pointer-sized unsigned integer type.",null,null],[15,"reference","","References, both shared and mutable.",null,null],[15,"fn","","Function pointers, like `fn(usize) -> bool`.",null,null],[11,"is","std::any","Returns `true` if the boxed type is the same as `T`.",0,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"downcast_ref","","Returns some reference to the boxed value if it is of type `T`, or `None` if it isn't.",0,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"downcast_mut","","Returns some mutable reference to the boxed value if it is of type `T`, or `None` if it isn't.",0,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"is","","Forwards to the method defined on the type `Any`.",0,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"downcast_ref","","Forwards to the method defined on the type `Any`.",0,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"downcast_mut","","Forwards to the method defined on the type `Any`.",0,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"extract_sign","std","",286,null],[11,"unsigned","","",286,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"from_unsigned","","",286,{"inputs":[{"name":"u32"}],"output":{"name":"u32"}}],[11,"from_bool","","",286,{"inputs":[{"name":"bool"}],"output":{"name":"u32"}}],[11,"max_value","","",286,{"inputs":[],"output":{"name":"u32"}}],[11,"min_value","","",286,{"inputs":[],"output":{"name":"u32"}}],[11,"wrapping_add","","",286,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"u32"}}],[11,"wrapping_mul","","",286,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"u32"}}],[11,"wrapping_sub","","",286,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"u32"}}],[11,"wrapping_shl","","",286,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"u32"}}],[11,"aborting_div","","",286,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"u32"}}],[11,"aborting_rem","","",286,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"u32"}}],[11,"leading_zeros","","",286,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"extract_sign","","",287,null],[11,"unsigned","","",287,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"from_unsigned","","",287,{"inputs":[{"name":"u64"}],"output":{"name":"u64"}}],[11,"from_bool","","",287,{"inputs":[{"name":"bool"}],"output":{"name":"u64"}}],[11,"max_value","","",287,{"inputs":[],"output":{"name":"u64"}}],[11,"min_value","","",287,{"inputs":[],"output":{"name":"u64"}}],[11,"wrapping_add","","",287,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"u64"}}],[11,"wrapping_mul","","",287,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"u64"}}],[11,"wrapping_sub","","",287,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"u64"}}],[11,"wrapping_shl","","",287,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"u64"}}],[11,"aborting_div","","",287,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"u64"}}],[11,"aborting_rem","","",287,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"u64"}}],[11,"leading_zeros","","",287,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"extract_sign","","",288,null],[11,"unsigned","","",288,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"from_unsigned","","",288,{"inputs":[{"name":"u64"}],"output":{"name":"i64"}}],[11,"from_bool","","",288,{"inputs":[{"name":"bool"}],"output":{"name":"i64"}}],[11,"max_value","","",288,{"inputs":[],"output":{"name":"i64"}}],[11,"min_value","","",288,{"inputs":[],"output":{"name":"i64"}}],[11,"wrapping_add","","",288,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"i64"}}],[11,"wrapping_mul","","",288,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"i64"}}],[11,"wrapping_sub","","",288,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"i64"}}],[11,"wrapping_shl","","",288,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"i64"}}],[11,"aborting_div","","",288,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"i64"}}],[11,"aborting_rem","","",288,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"i64"}}],[11,"leading_zeros","","",288,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"extract_sign","","",289,null],[11,"unsigned","","",289,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"from_unsigned","","",289,{"inputs":[{"name":"u32"}],"output":{"name":"i32"}}],[11,"from_bool","","",289,{"inputs":[{"name":"bool"}],"output":{"name":"i32"}}],[11,"max_value","","",289,{"inputs":[],"output":{"name":"i32"}}],[11,"min_value","","",289,{"inputs":[],"output":{"name":"i32"}}],[11,"wrapping_add","","",289,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"i32"}}],[11,"wrapping_mul","","",289,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"i32"}}],[11,"wrapping_sub","","",289,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"i32"}}],[11,"wrapping_shl","","",289,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"i32"}}],[11,"aborting_div","","",289,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"i32"}}],[11,"aborting_rem","","",289,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"i32"}}],[11,"leading_zeros","","",289,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"extract_sign","","",290,null],[11,"unsigned","","",290,{"inputs":[{"name":"self"}],"output":{"name":"u128"}}],[11,"from_unsigned","","",290,{"inputs":[{"name":"u128"}],"output":{"name":"i128"}}],[11,"from_bool","","",290,{"inputs":[{"name":"bool"}],"output":{"name":"i128"}}],[11,"max_value","","",290,{"inputs":[],"output":{"name":"i128"}}],[11,"min_value","","",290,{"inputs":[],"output":{"name":"i128"}}],[11,"wrapping_add","","",290,{"inputs":[{"name":"self"},{"name":"i128"}],"output":{"name":"i128"}}],[11,"wrapping_mul","","",290,{"inputs":[{"name":"self"},{"name":"i128"}],"output":{"name":"i128"}}],[11,"wrapping_sub","","",290,{"inputs":[{"name":"self"},{"name":"i128"}],"output":{"name":"i128"}}],[11,"wrapping_shl","","",290,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"i128"}}],[11,"aborting_div","","",290,{"inputs":[{"name":"self"},{"name":"i128"}],"output":{"name":"i128"}}],[11,"aborting_rem","","",290,{"inputs":[{"name":"self"},{"name":"i128"}],"output":{"name":"i128"}}],[11,"leading_zeros","","",290,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"extract_sign","","",291,null],[11,"unsigned","","",291,{"inputs":[{"name":"self"}],"output":{"name":"u128"}}],[11,"from_unsigned","","",291,{"inputs":[{"name":"u128"}],"output":{"name":"u128"}}],[11,"from_bool","","",291,{"inputs":[{"name":"bool"}],"output":{"name":"u128"}}],[11,"max_value","","",291,{"inputs":[],"output":{"name":"u128"}}],[11,"min_value","","",291,{"inputs":[],"output":{"name":"u128"}}],[11,"wrapping_add","","",291,{"inputs":[{"name":"self"},{"name":"u128"}],"output":{"name":"u128"}}],[11,"wrapping_mul","","",291,{"inputs":[{"name":"self"},{"name":"u128"}],"output":{"name":"u128"}}],[11,"wrapping_sub","","",291,{"inputs":[{"name":"self"},{"name":"u128"}],"output":{"name":"u128"}}],[11,"wrapping_shl","","",291,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"u128"}}],[11,"aborting_div","","",291,{"inputs":[{"name":"self"},{"name":"u128"}],"output":{"name":"u128"}}],[11,"aborting_rem","","",291,{"inputs":[{"name":"self"},{"name":"u128"}],"output":{"name":"u128"}}],[11,"leading_zeros","","",291,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"repr","","",292,null],[11,"from_repr","","",292,null],[11,"from_parts","","",292,null],[11,"normalize","","",292,null],[11,"repr","","",293,null],[11,"from_repr","","",293,null],[11,"from_parts","","",293,null],[11,"normalize","","",293,null],[11,"cast","","",287,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"cast","","",288,{"inputs":[{"name":"self"}],"output":{"name":"i32"}}],[11,"cast","","",286,{"inputs":[{"name":"self"}],"output":{"name":"i128"}}],[11,"cast","","",289,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"cast","","",289,{"inputs":[{"name":"self"}],"output":{"name":"u128"}}],[11,"cast","","",289,{"inputs":[{"name":"self"}],"output":{"name":"i128"}}],[11,"cast","","",288,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"cast","","",286,{"inputs":[{"name":"self"}],"output":{"name":"i32"}}],[11,"cast","","",287,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"cast","","",291,{"inputs":[{"name":"self"}],"output":{"name":"i128"}}],[11,"cast","","",290,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"cast","","",288,{"inputs":[{"name":"self"}],"output":{"name":"u128"}}],[11,"cast","","",291,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"cast","","",287,{"inputs":[{"name":"self"}],"output":{"name":"u128"}}],[11,"cast","","",287,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"cast","","",290,{"inputs":[{"name":"self"}],"output":{"name":"u128"}}],[11,"cast","","",288,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"cast","","",291,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"cast","","",288,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"cast","","",286,{"inputs":[{"name":"self"}],"output":{"name":"u128"}}],[11,"cast","","",291,{"inputs":[{"name":"self"}],"output":{"name":"u128"}}],[11,"cast","","",290,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[11,"cast","","",287,{"inputs":[{"name":"self"}],"output":{"name":"isize"}}],[11,"cast","","",290,{"inputs":[{"name":"self"}],"output":{"name":"i32"}}],[11,"cast","","",288,{"inputs":[{"name":"self"}],"output":{"name":"i128"}}],[11,"cast","","",288,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[11,"cast","","",287,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[11,"cast","","",289,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"cast","","",291,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[11,"cast","","",286,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"cast","","",286,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"cast","","",290,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"cast","","",291,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"cast","","",286,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"cast","","",286,{"inputs":[{"name":"self"}],"output":{"name":"isize"}}],[11,"cast","","",289,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"cast","","",289,{"inputs":[{"name":"self"}],"output":{"name":"i32"}}],[11,"cast","","",287,{"inputs":[{"name":"self"}],"output":{"name":"i32"}}],[11,"cast","","",287,{"inputs":[{"name":"self"}],"output":{"name":"i128"}}],[11,"cast","","",291,{"inputs":[{"name":"self"}],"output":{"name":"i32"}}],[11,"cast","","",288,{"inputs":[{"name":"self"}],"output":{"name":"isize"}}],[11,"cast","","",286,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[11,"cast","","",290,{"inputs":[{"name":"self"}],"output":{"name":"i128"}}],[11,"cast","","",289,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[11,"cast","","",289,{"inputs":[{"name":"self"}],"output":{"name":"isize"}}],[11,"cast","","",290,{"inputs":[{"name":"self"}],"output":{"name":"isize"}}],[11,"cast","","",291,{"inputs":[{"name":"self"}],"output":{"name":"isize"}}],[11,"cast","","",290,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"low","","",290,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"low_as_high","","",290,{"inputs":[{"name":"u64"}],"output":{"name":"i64"}}],[11,"high","","",290,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[11,"high_as_low","","",290,{"inputs":[{"name":"i64"}],"output":{"name":"u64"}}],[11,"from_parts","","",290,{"inputs":[{"name":"u64"},{"name":"i64"}],"output":{"name":"i128"}}],[11,"low","","",287,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"low_as_high","","",287,{"inputs":[{"name":"u32"}],"output":{"name":"u32"}}],[11,"high","","",287,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"high_as_low","","",287,{"inputs":[{"name":"u32"}],"output":{"name":"u32"}}],[11,"from_parts","","",287,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"u64"}}],[11,"low","","",291,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"low_as_high","","",291,{"inputs":[{"name":"u64"}],"output":{"name":"u64"}}],[11,"high","","",291,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"high_as_low","","",291,{"inputs":[{"name":"u64"}],"output":{"name":"u64"}}],[11,"from_parts","","",291,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"u128"}}],[11,"low","","",288,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"low_as_high","","",288,{"inputs":[{"name":"u32"}],"output":{"name":"i32"}}],[11,"high","","",288,{"inputs":[{"name":"self"}],"output":{"name":"i32"}}],[11,"high_as_low","","",288,{"inputs":[{"name":"i32"}],"output":{"name":"u32"}}],[11,"from_parts","","",288,{"inputs":[{"name":"u32"},{"name":"i32"}],"output":{"name":"i64"}}],[11,"alloc","std::heap","",294,{"inputs":[{"name":"self"},{"name":"layout"}],"output":{"name":"result"}}],[11,"alloc_zeroed","","",294,{"inputs":[{"name":"self"},{"name":"layout"}],"output":{"name":"result"}}],[11,"dealloc","","",294,null],[11,"realloc","","",294,null],[11,"oom","","",294,null],[11,"usable_size","","",294,null],[11,"alloc_excess","","",294,{"inputs":[{"name":"self"},{"name":"layout"}],"output":{"name":"result"}}],[11,"realloc_excess","","",294,null],[11,"grow_in_place","","",294,null],[11,"shrink_in_place","","",294,null],[11,"split_whitespace","std","",295,{"inputs":[{"name":"self"}],"output":{"name":"splitwhitespace"}}],[11,"is_whitespace","","",295,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_alphanumeric","","",295,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"trim","","",295,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"trim_left","","",295,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"trim_right","","",295,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"cmp","std::char","",95,{"inputs":[{"name":"self"},{"name":"unicodeversion"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",95,{"inputs":[{"name":"self"},{"name":"unicodeversion"}],"output":{"name":"option"}}],[11,"lt","","",95,{"inputs":[{"name":"self"},{"name":"unicodeversion"}],"output":{"name":"bool"}}],[11,"le","","",95,{"inputs":[{"name":"self"},{"name":"unicodeversion"}],"output":{"name":"bool"}}],[11,"gt","","",95,{"inputs":[{"name":"self"},{"name":"unicodeversion"}],"output":{"name":"bool"}}],[11,"ge","","",95,{"inputs":[{"name":"self"},{"name":"unicodeversion"}],"output":{"name":"bool"}}],[11,"next_back","std::str","",296,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","std::char","",297,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",298,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",298,null],[11,"next","std::str","",296,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","std::char","",299,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",125,{"inputs":[{"name":"self"}],"output":{"name":"decodeutf16error"}}],[11,"clone","std::str","",296,{"inputs":[{"name":"self"}],"output":{"name":"splitwhitespace"}}],[11,"clone","std::char","",298,{"inputs":[{"name":"self"}],"output":{"name":"decodeutf16"}}],[11,"clone","","",95,{"inputs":[{"name":"self"}],"output":{"name":"unicodeversion"}}],[11,"fmt","","",125,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",297,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",299,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",95,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::str","",296,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::char","",125,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",125,{"inputs":[{"name":"self"},{"name":"decodeutf16error"}],"output":{"name":"bool"}}],[11,"ne","","",125,{"inputs":[{"name":"self"},{"name":"decodeutf16error"}],"output":{"name":"bool"}}],[11,"eq","","",95,{"inputs":[{"name":"self"},{"name":"unicodeversion"}],"output":{"name":"bool"}}],[11,"ne","","",95,{"inputs":[{"name":"self"},{"name":"unicodeversion"}],"output":{"name":"bool"}}],[11,"bitor_assign","std","",288,null],[11,"bitor_assign","std::num","",194,null],[11,"bitor_assign","std","",300,null],[11,"bitor_assign","std::num","",194,null],[11,"bitor_assign","","",194,null],[11,"bitor_assign","","",194,null],[11,"bitor_assign","","",194,null],[11,"bitor_assign","std","",291,null],[11,"bitor_assign","std::num","",194,null],[11,"bitor_assign","std","",301,null],[11,"bitor_assign","","",287,null],[11,"bitor_assign","std::num","",194,null],[11,"bitor_assign","","",194,null],[11,"bitor_assign","std","",302,null],[11,"bitor_assign","","",303,null],[11,"bitor_assign","std::num","",194,null],[11,"bitor_assign","","",194,null],[11,"bitor_assign","std","",302,null],[11,"bitor_assign","std::num","",194,null],[11,"bitor_assign","std","",289,null],[11,"bitor_assign","","",304,null],[11,"bitor_assign","std::num","",194,null],[11,"bitor_assign","std","",305,null],[11,"bitor_assign","std::num","",194,null],[11,"bitor_assign","std","",300,null],[11,"bitor_assign","","",288,null],[11,"bitor_assign","std::num","",194,null],[11,"bitor_assign","","",194,null],[11,"bitor_assign","std","",286,null],[11,"bitor_assign","","",286,null],[11,"bitor_assign","","",291,null],[11,"bitor_assign","std::num","",194,null],[11,"bitor_assign","std","",290,null],[11,"bitor_assign","std::num","",194,null],[11,"bitor_assign","std","",289,null],[11,"bitor_assign","","",301,null],[11,"bitor_assign","std::num","",194,null],[11,"bitor_assign","std","",290,null],[11,"bitor_assign","std::num","",194,null],[11,"bitor_assign","std","",303,null],[11,"bitor_assign","","",306,null],[11,"bitor_assign","std::num","",194,null],[11,"bitor_assign","std","",305,null],[11,"bitor_assign","","",306,null],[11,"bitor_assign","std::num","",194,null],[11,"bitor_assign","std","",287,null],[11,"bitor_assign","std::num","",194,null],[11,"bitor_assign","","",194,null],[11,"bitor_assign","","",194,null],[11,"bitor_assign","std","",304,null],[11,"eq","","",307,null],[11,"eq","","",307,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",307,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",307,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","std::cmp","",4,{"inputs":[{"name":"self"},{"name":"reverse"}],"output":{"name":"bool"}}],[11,"ne","","",4,{"inputs":[{"name":"self"},{"name":"reverse"}],"output":{"name":"bool"}}],[11,"eq","std","",307,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",310,{"inputs":[{"name":"self"},{"name":"char"}],"output":{"name":"bool"}}],[11,"ne","","",310,{"inputs":[{"name":"self"},{"name":"char"}],"output":{"name":"bool"}}],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",307,null],[11,"eq","std::marker","",311,{"inputs":[{"name":"self"},{"name":"phantomdata"}],"output":{"name":"bool"}}],[11,"eq","std","",309,null],[11,"ne","","",309,null],[11,"eq","","",307,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",307,null],[11,"eq","","",307,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",307,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",312,{"inputs":[{"name":"self"},{"name":"b"}],"output":{"name":"bool"}}],[11,"ne","","",312,{"inputs":[{"name":"self"},{"name":"b"}],"output":{"name":"bool"}}],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",307,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",307,null],[11,"eq","","",303,{"inputs":[{"name":"self"},{"name":"isize"}],"output":{"name":"bool"}}],[11,"ne","","",303,{"inputs":[{"name":"self"},{"name":"isize"}],"output":{"name":"bool"}}],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","std::num","",193,{"inputs":[{"name":"self"},{"name":"fpcategory"}],"output":{"name":"bool"}}],[11,"eq","std","",307,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",307,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",307,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",307,null],[11,"eq","","",313,null],[11,"ne","","",313,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",307,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","std::ops","",33,{"inputs":[{"name":"self"},{"name":"rangeinclusive"}],"output":{"name":"bool"}}],[11,"ne","","",33,{"inputs":[{"name":"self"},{"name":"rangeinclusive"}],"output":{"name":"bool"}}],[11,"eq","std","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",286,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"bool"}}],[11,"ne","","",286,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"bool"}}],[11,"eq","std::convert","",131,{"inputs":[{"name":"self"},{"name":"infallible"}],"output":{"name":"bool"}}],[11,"eq","std","",308,null],[11,"ne","","",308,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",302,{"inputs":[{"name":"self"},{"name":"bool"}],"output":{"name":"bool"}}],[11,"ne","","",302,{"inputs":[{"name":"self"},{"name":"bool"}],"output":{"name":"bool"}}],[11,"eq","","",313,null],[11,"ne","","",313,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",307,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","std::num","",314,{"inputs":[{"name":"self"},{"name":"parsefloaterror"}],"output":{"name":"bool"}}],[11,"ne","","",314,{"inputs":[{"name":"self"},{"name":"parsefloaterror"}],"output":{"name":"bool"}}],[11,"eq","std","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",313,null],[11,"ne","","",313,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","std::cell","",315,{"inputs":[{"name":"self"},{"name":"refcell"}],"output":{"name":"bool"}}],[11,"eq","std","",309,null],[11,"ne","","",309,null],[11,"eq","","",307,null],[11,"eq","std::option","",316,{"inputs":[{"name":"self"},{"name":"noneerror"}],"output":{"name":"bool"}}],[11,"eq","std","",307,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","std::str","",120,{"inputs":[{"name":"self"},{"name":"parseboolerror"}],"output":{"name":"bool"}}],[11,"ne","","",120,{"inputs":[{"name":"self"},{"name":"parseboolerror"}],"output":{"name":"bool"}}],[11,"eq","std","",309,null],[11,"ne","","",309,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","std::cmp","",3,{"inputs":[{"name":"self"},{"name":"ordering"}],"output":{"name":"bool"}}],[11,"eq","std","",309,null],[11,"ne","","",309,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",307,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",307,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",307,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",313,null],[11,"ne","","",313,null],[11,"eq","","",307,null],[11,"eq","std::ops","",65,{"inputs":[{"name":"self"},{"name":"range"}],"output":{"name":"bool"}}],[11,"ne","","",65,{"inputs":[{"name":"self"},{"name":"range"}],"output":{"name":"bool"}}],[11,"eq","std","",307,null],[11,"eq","","",313,null],[11,"ne","","",313,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",307,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",307,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",293,{"inputs":[{"name":"self"},{"name":"f64"}],"output":{"name":"bool"}}],[11,"ne","","",293,{"inputs":[{"name":"self"},{"name":"f64"}],"output":{"name":"bool"}}],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",313,null],[11,"ne","","",313,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",307,null],[11,"eq","","",287,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"bool"}}],[11,"ne","","",287,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"bool"}}],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",307,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",307,null],[11,"eq","","",313,null],[11,"ne","","",313,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","std::option","",71,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"name":"bool"}}],[11,"ne","","",71,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"name":"bool"}}],[11,"eq","std","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",317,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",307,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",307,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","std::cell","",318,{"inputs":[{"name":"self"},{"name":"cell"}],"output":{"name":"bool"}}],[11,"eq","std","",308,null],[11,"ne","","",308,null],[11,"eq","std::result","",70,{"inputs":[{"name":"self"},{"name":"result"}],"output":{"name":"bool"}}],[11,"ne","","",70,{"inputs":[{"name":"self"},{"name":"result"}],"output":{"name":"bool"}}],[11,"eq","std","",309,null],[11,"ne","","",309,null],[11,"eq","std::num","",319,{"inputs":[{"name":"self"},{"name":"parseinterror"}],"output":{"name":"bool"}}],[11,"ne","","",319,{"inputs":[{"name":"self"},{"name":"parseinterror"}],"output":{"name":"bool"}}],[11,"eq","std","",312,{"inputs":[{"name":"self"},{"name":"b"}],"output":{"name":"bool"}}],[11,"ne","","",312,{"inputs":[{"name":"self"},{"name":"b"}],"output":{"name":"bool"}}],[11,"eq","","",305,{"inputs":[{"name":"self"},{"name":"u16"}],"output":{"name":"bool"}}],[11,"ne","","",305,{"inputs":[{"name":"self"},{"name":"u16"}],"output":{"name":"bool"}}],[11,"eq","std::ops","",52,{"inputs":[{"name":"self"},{"name":"rangefrom"}],"output":{"name":"bool"}}],[11,"ne","","",52,{"inputs":[{"name":"self"},{"name":"rangefrom"}],"output":{"name":"bool"}}],[11,"eq","std","",308,null],[11,"ne","","",308,null],[11,"eq","std::char","",129,{"inputs":[{"name":"self"},{"name":"chartryfromerror"}],"output":{"name":"bool"}}],[11,"ne","","",129,{"inputs":[{"name":"self"},{"name":"chartryfromerror"}],"output":{"name":"bool"}}],[11,"eq","std","",308,null],[11,"ne","","",308,null],[11,"eq","","",307,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",306,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"bool"}}],[11,"ne","","",306,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"bool"}}],[11,"eq","","",290,{"inputs":[{"name":"self"},{"name":"i128"}],"output":{"name":"bool"}}],[11,"ne","","",290,{"inputs":[{"name":"self"},{"name":"i128"}],"output":{"name":"bool"}}],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",312,{"inputs":[{"name":"self"},{"name":"b"}],"output":{"name":"bool"}}],[11,"ne","","",312,{"inputs":[{"name":"self"},{"name":"b"}],"output":{"name":"bool"}}],[11,"eq","","",307,null],[11,"eq","","",307,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","std::mem","",320,{"inputs":[{"name":"self"},{"name":"manuallydrop"}],"output":{"name":"bool"}}],[11,"ne","","",320,{"inputs":[{"name":"self"},{"name":"manuallydrop"}],"output":{"name":"bool"}}],[11,"eq","std","",309,null],[11,"ne","","",309,null],[11,"eq","","",307,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",304,{"inputs":[{"name":"self"},{"name":"i16"}],"output":{"name":"bool"}}],[11,"ne","","",304,{"inputs":[{"name":"self"},{"name":"i16"}],"output":{"name":"bool"}}],[11,"eq","","",307,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",307,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","std::ops","",26,{"inputs":[{"name":"self"},{"name":"rangetoinclusive"}],"output":{"name":"bool"}}],[11,"ne","","",26,{"inputs":[{"name":"self"},{"name":"rangetoinclusive"}],"output":{"name":"bool"}}],[11,"eq","std","",307,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",307,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",307,null],[11,"eq","","",307,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",307,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","std::ops","",38,{"inputs":[{"name":"self"},{"name":"rangeto"}],"output":{"name":"bool"}}],[11,"ne","","",38,{"inputs":[{"name":"self"},{"name":"rangeto"}],"output":{"name":"bool"}}],[11,"eq","std","",307,null],[11,"eq","","",313,null],[11,"ne","","",313,null],[11,"eq","","",307,null],[11,"eq","","",307,null],[11,"eq","","",307,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",307,null],[11,"eq","","",307,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",307,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","std::str::pattern","",90,{"inputs":[{"name":"self"},{"name":"searchstep"}],"output":{"name":"bool"}}],[11,"ne","","",90,{"inputs":[{"name":"self"},{"name":"searchstep"}],"output":{"name":"bool"}}],[11,"eq","std","",308,null],[11,"ne","","",308,null],[11,"eq","std::ops","",30,{"inputs":[{"name":"self"},{"name":"generatorstate"}],"output":{"name":"bool"}}],[11,"ne","","",30,{"inputs":[{"name":"self"},{"name":"generatorstate"}],"output":{"name":"bool"}}],[11,"eq","std","",295,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"ne","","",295,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"eq","std::num","",194,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"bool"}}],[11,"ne","","",194,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"bool"}}],[11,"eq","std","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",312,{"inputs":[{"name":"self"},{"name":"b"}],"output":{"name":"bool"}}],[11,"ne","","",312,{"inputs":[{"name":"self"},{"name":"b"}],"output":{"name":"bool"}}],[11,"eq","","",313,null],[11,"ne","","",313,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","std::str","",121,{"inputs":[{"name":"self"},{"name":"utf8error"}],"output":{"name":"bool"}}],[11,"ne","","",121,{"inputs":[{"name":"self"},{"name":"utf8error"}],"output":{"name":"bool"}}],[11,"eq","std","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",307,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","std::mem","",321,{"inputs":[{"name":"self"},{"name":"discriminant"}],"output":{"name":"bool"}}],[11,"eq","std","",308,null],[11,"ne","","",308,null],[11,"eq","","",307,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",307,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",301,{"inputs":[{"name":"self"},{"name":"i8"}],"output":{"name":"bool"}}],[11,"ne","","",301,{"inputs":[{"name":"self"},{"name":"i8"}],"output":{"name":"bool"}}],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",291,{"inputs":[{"name":"self"},{"name":"u128"}],"output":{"name":"bool"}}],[11,"ne","","",291,{"inputs":[{"name":"self"},{"name":"u128"}],"output":{"name":"bool"}}],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",307,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",313,null],[11,"ne","","",313,null],[11,"eq","","",313,null],[11,"ne","","",313,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",307,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",292,{"inputs":[{"name":"self"},{"name":"f32"}],"output":{"name":"bool"}}],[11,"ne","","",292,{"inputs":[{"name":"self"},{"name":"f32"}],"output":{"name":"bool"}}],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",307,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",307,null],[11,"eq","","",307,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","std::ops","",322,{"inputs":[{"name":"self"},{"name":"rangefull"}],"output":{"name":"bool"}}],[11,"eq","std","",308,null],[11,"ne","","",308,null],[11,"eq","","",307,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",307,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",288,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"bool"}}],[11,"ne","","",288,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"bool"}}],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",307,null],[11,"eq","","",307,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",307,null],[11,"eq","","",307,null],[11,"eq","std::fmt","",126,{"inputs":[{"name":"self"},{"name":"error"}],"output":{"name":"bool"}}],[11,"eq","std","",308,null],[11,"ne","","",308,null],[11,"eq","std::any","",323,{"inputs":[{"name":"self"},{"name":"typeid"}],"output":{"name":"bool"}}],[11,"ne","","",323,{"inputs":[{"name":"self"},{"name":"typeid"}],"output":{"name":"bool"}}],[11,"eq","std","",308,null],[11,"ne","","",308,null],[11,"eq","","",307,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",307,null],[11,"eq","","",307,null],[11,"eq","","",307,null],[11,"eq","","",307,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",307,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",317,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",300,{"inputs":[{"name":"self"},{"name":"u8"}],"output":{"name":"bool"}}],[11,"ne","","",300,{"inputs":[{"name":"self"},{"name":"u8"}],"output":{"name":"bool"}}],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",313,null],[11,"ne","","",313,null],[11,"eq","","",313,null],[11,"ne","","",313,null],[11,"eq","","",307,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",289,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"bool"}}],[11,"ne","","",289,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"bool"}}],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",307,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",307,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",307,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",307,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",308,null],[11,"ne","","",308,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",309,null],[11,"ne","","",309,null],[11,"eq","","",307,null],[11,"add","","",306,null],[11,"add","","",289,null],[11,"add","std::num","",194,null],[11,"add","std","",303,{"inputs":[{"name":"self"},{"name":"isize"}],"output":{"name":"isize"}}],[11,"add","","",292,{"inputs":[{"name":"self"},{"name":"f32"}],"output":{"name":"f32"}}],[11,"add","","",291,null],[11,"add","","",305,null],[11,"add","","",306,null],[11,"add","","",301,null],[11,"add","std::num","",194,null],[11,"add","std","",305,null],[11,"add","","",288,null],[11,"add","","",304,{"inputs":[{"name":"self"},{"name":"i16"}],"output":{"name":"i16"}}],[11,"add","","",287,null],[11,"add","","",289,null],[11,"add","std::num","",194,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add","std","",304,null],[11,"add","","",300,null],[11,"add","std::num","",194,null],[11,"add","","",194,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add","std","",287,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"u64"}}],[11,"add","std::num","",194,null],[11,"add","std","",290,null],[11,"add","","",289,null],[11,"add","","",301,{"inputs":[{"name":"self"},{"name":"i8"}],"output":{"name":"i8"}}],[11,"add","std::num","",194,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add","std","",286,null],[11,"add","","",289,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"i32"}}],[11,"add","std::num","",194,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add","std","",287,null],[11,"add","std::num","",194,null],[11,"add","std","",288,null],[11,"add","","",291,null],[11,"add","std::num","",194,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add","std","",293,null],[11,"add","std::num","",194,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add","","",194,null],[11,"add","std","",290,{"inputs":[{"name":"self"},{"name":"i128"}],"output":{"name":"i128"}}],[11,"add","","",303,null],[11,"add","","",292,null],[11,"add","","",300,null],[11,"add","std::num","",194,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add","std","",291,{"inputs":[{"name":"self"},{"name":"u128"}],"output":{"name":"u128"}}],[11,"add","","",293,null],[11,"add","","",305,null],[11,"add","","",306,null],[11,"add","","",290,null],[11,"add","","",303,null],[11,"add","std::num","",194,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add","std","",287,null],[11,"add","","",301,null],[11,"add","std::num","",194,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add","","",194,null],[11,"add","std","",293,{"inputs":[{"name":"self"},{"name":"f64"}],"output":{"name":"f64"}}],[11,"add","std::num","",194,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add","std","",304,null],[11,"add","","",293,null],[11,"add","std::num","",194,null],[11,"add","std","",305,{"inputs":[{"name":"self"},{"name":"u16"}],"output":{"name":"u16"}}],[11,"add","std::num","",194,null],[11,"add","std","",304,null],[11,"add","","",292,null],[11,"add","std::num","",194,null],[11,"add","std","",292,null],[11,"add","","",303,null],[11,"add","","",306,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"usize"}}],[11,"add","","",286,null],[11,"add","","",288,null],[11,"add","","",291,null],[11,"add","","",300,{"inputs":[{"name":"self"},{"name":"u8"}],"output":{"name":"u8"}}],[11,"add","","",288,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"i64"}}],[11,"add","std::num","",194,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add","","",194,null],[11,"add","std","",290,null],[11,"add","","",286,null],[11,"add","std::num","",194,null],[11,"add","std","",300,null],[11,"add","std::num","",194,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add","std","",301,null],[11,"add","","",286,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"u32"}}],[11,"fmt","","",292,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",312,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",293,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",312,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",287,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",286,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",290,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",291,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",312,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",312,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",303,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",288,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::num","",194,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std","",301,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",289,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",300,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",305,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",306,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",304,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::cell","",128,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std","",286,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::char","",324,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::fmt","",325,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::char","",326,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::fmt","",126,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::str","",120,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::char","",327,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::num","",314,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::char","",129,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std","",305,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::convert","",131,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std","",290,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",300,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",288,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",312,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",289,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::cell","",328,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std","",303,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::cell","",329,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",127,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::num","",330,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",194,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::str","",121,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std","",304,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",312,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",310,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",301,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::num","",319,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::char","",130,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std","",293,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",302,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",291,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",295,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",306,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",292,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",287,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"div_assign","","",289,null],[11,"div_assign","","",286,null],[11,"div_assign","std::num","",194,null],[11,"div_assign","std","",291,null],[11,"div_assign","std::num","",194,null],[11,"div_assign","std","",293,null],[11,"div_assign","std::num","",194,null],[11,"div_assign","std","",303,null],[11,"div_assign","std::num","",194,null],[11,"div_assign","std","",305,null],[11,"div_assign","","",291,null],[11,"div_assign","","",303,null],[11,"div_assign","","",292,null],[11,"div_assign","","",286,null],[11,"div_assign","","",304,null],[11,"div_assign","","",289,null],[11,"div_assign","","",300,null],[11,"div_assign","std::num","",194,null],[11,"div_assign","","",194,null],[11,"div_assign","","",194,null],[11,"div_assign","","",194,null],[11,"div_assign","std","",290,null],[11,"div_assign","std::num","",194,null],[11,"div_assign","std","",301,null],[11,"div_assign","std::num","",194,null],[11,"div_assign","","",194,null],[11,"div_assign","","",194,null],[11,"div_assign","","",194,null],[11,"div_assign","","",194,null],[11,"div_assign","std","",290,null],[11,"div_assign","std::num","",194,null],[11,"div_assign","","",194,null],[11,"div_assign","std","",301,null],[11,"div_assign","","",287,null],[11,"div_assign","std::num","",194,null],[11,"div_assign","","",194,null],[11,"div_assign","std","",293,null],[11,"div_assign","","",304,null],[11,"div_assign","","",306,null],[11,"div_assign","","",288,null],[11,"div_assign","","",287,null],[11,"div_assign","std::num","",194,null],[11,"div_assign","std","",300,null],[11,"div_assign","std::num","",194,null],[11,"div_assign","","",194,null],[11,"div_assign","","",194,null],[11,"div_assign","","",194,null],[11,"div_assign","std","",305,null],[11,"div_assign","","",306,null],[11,"div_assign","","",288,null],[11,"div_assign","","",292,null],[11,"div_assign","std::num","",194,null],[11,"sub_assign","std","",290,null],[11,"sub_assign","","",293,null],[11,"sub_assign","","",305,null],[11,"sub_assign","","",301,null],[11,"sub_assign","","",286,null],[11,"sub_assign","std::num","",194,null],[11,"sub_assign","","",194,null],[11,"sub_assign","","",194,null],[11,"sub_assign","std","",304,null],[11,"sub_assign","std::num","",194,null],[11,"sub_assign","std","",292,null],[11,"sub_assign","","",292,null],[11,"sub_assign","std::num","",194,null],[11,"sub_assign","std","",300,null],[11,"sub_assign","","",287,null],[11,"sub_assign","std::num","",194,null],[11,"sub_assign","std","",288,null],[11,"sub_assign","std::num","",194,null],[11,"sub_assign","std","",303,null],[11,"sub_assign","","",304,null],[11,"sub_assign","std::num","",194,null],[11,"sub_assign","std","",288,null],[11,"sub_assign","std::num","",194,null],[11,"sub_assign","std","",291,null],[11,"sub_assign","std::num","",194,null],[11,"sub_assign","","",194,null],[11,"sub_assign","std","",301,null],[11,"sub_assign","","",305,null],[11,"sub_assign","","",306,null],[11,"sub_assign","std::num","",194,null],[11,"sub_assign","std","",303,null],[11,"sub_assign","std::num","",194,null],[11,"sub_assign","std","",290,null],[11,"sub_assign","","",293,null],[11,"sub_assign","std::num","",194,null],[11,"sub_assign","std","",300,null],[11,"sub_assign","std::num","",194,null],[11,"sub_assign","","",194,null],[11,"sub_assign","std","",306,null],[11,"sub_assign","std::num","",194,null],[11,"sub_assign","std","",291,null],[11,"sub_assign","","",289,null],[11,"sub_assign","","",286,null],[11,"sub_assign","std::num","",194,null],[11,"sub_assign","","",194,null],[11,"sub_assign","","",194,null],[11,"sub_assign","","",194,null],[11,"sub_assign","","",194,null],[11,"sub_assign","std","",289,null],[11,"sub_assign","std::num","",194,null],[11,"sub_assign","std","",287,null],[11,"sub_assign","std::num","",194,null],[11,"haystack","std::str::pattern","",331,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"next","","",331,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match","","",331,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject","","",331,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"haystack","","",332,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"next","","",332,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match","","",332,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject","","",332,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"haystack","","",333,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"next","","",333,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match","","",333,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"haystack","","",334,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"next","","",334,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match","","",334,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject","","",334,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"into_searcher","std","",310,null],[11,"is_contained_in","","",310,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"is_prefix_of","","",310,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"is_suffix_of","","",310,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"into_searcher","","",295,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"strsearcher"}}],[11,"is_prefix_of","","Checks whether the pattern matches at the front of the haystack",295,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"is_suffix_of","","Checks whether the pattern matches at the back of the haystack",295,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"into_searcher","","",309,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"charslicesearcher"}}],[11,"is_contained_in","","",309,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"is_prefix_of","","",309,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"is_suffix_of","","",309,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"index","","",295,{"inputs":[{"name":"self"},{"name":"range"}],"output":{"name":"str"}}],[11,"index","","",309,null],[11,"index","","",295,{"inputs":[{"name":"self"},{"name":"rangetoinclusive"}],"output":{"name":"str"}}],[11,"index","","",295,{"inputs":[{"name":"self"},{"name":"rangeto"}],"output":{"name":"str"}}],[11,"index","","",295,{"inputs":[{"name":"self"},{"name":"rangeinclusive"}],"output":{"name":"str"}}],[11,"index","","",295,{"inputs":[{"name":"self"},{"name":"rangefull"}],"output":{"name":"str"}}],[11,"index","","",295,{"inputs":[{"name":"self"},{"name":"rangefrom"}],"output":{"name":"str"}}],[11,"split_at","","",309,null],[11,"iter","","",309,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"split","","",309,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"split"}}],[11,"rsplit","","",309,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"rsplit"}}],[11,"splitn","","",309,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"p"}],"output":{"name":"splitn"}}],[11,"rsplitn","","",309,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"p"}],"output":{"name":"rsplitn"}}],[11,"windows","","",309,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"windows"}}],[11,"chunks","","",309,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"chunks"}}],[11,"get","","",309,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"option"}}],[11,"first","","",309,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"split_first","","",309,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"split_last","","",309,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"last","","",309,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"get_unchecked","","",309,null],[11,"as_ptr","","",309,null],[11,"binary_search_by","","",309,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"result"}}],[11,"len","","",309,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"get_mut","","",309,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"option"}}],[11,"split_at_mut","","",309,null],[11,"iter_mut","","",309,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"last_mut","","",309,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"first_mut","","",309,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"split_first_mut","","",309,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"split_last_mut","","",309,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"split_mut","","",309,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"splitmut"}}],[11,"rsplit_mut","","",309,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"rsplitmut"}}],[11,"splitn_mut","","",309,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"p"}],"output":{"name":"splitnmut"}}],[11,"rsplitn_mut","","",309,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"p"}],"output":{"name":"rsplitnmut"}}],[11,"chunks_mut","","",309,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"chunksmut"}}],[11,"swap","","",309,null],[11,"reverse","","",309,null],[11,"get_unchecked_mut","","",309,null],[11,"as_mut_ptr","","",309,null],[11,"contains","","",309,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"bool"}}],[11,"starts_with","","",309,null],[11,"ends_with","","",309,null],[11,"binary_search","","",309,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"result"}}],[11,"rotate","","",309,null],[11,"clone_from_slice","","",309,null],[11,"copy_from_slice","","",309,null],[11,"swap_with_slice","","",309,null],[11,"binary_search_by_key","","",309,{"inputs":[{"name":"self"},{"name":"b"},{"name":"f"}],"output":{"name":"result"}}],[11,"sort_unstable","","",309,null],[11,"sort_unstable_by","","",309,null],[11,"sort_unstable_by_key","","",309,null],[11,"bitxor","","",305,null],[11,"bitxor","","",289,null],[11,"bitxor","","",306,null],[11,"bitxor","std::num","",194,null],[11,"bitxor","std","",290,null],[11,"bitxor","","",286,null],[11,"bitxor","","",286,null],[11,"bitxor","","",302,null],[11,"bitxor","std::num","",194,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",194,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",194,null],[11,"bitxor","std","",291,{"inputs":[{"name":"self"},{"name":"u128"}],"output":{"name":"u128"}}],[11,"bitxor","std::num","",194,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",194,null],[11,"bitxor","std","",289,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"i32"}}],[11,"bitxor","","",304,null],[11,"bitxor","","",301,{"inputs":[{"name":"self"},{"name":"i8"}],"output":{"name":"i8"}}],[11,"bitxor","","",286,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"u32"}}],[11,"bitxor","","",302,{"inputs":[{"name":"self"},{"name":"bool"}],"output":{"name":"bool"}}],[11,"bitxor","std::num","",194,null],[11,"bitxor","std","",303,null],[11,"bitxor","","",305,null],[11,"bitxor","std::num","",194,null],[11,"bitxor","","",194,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","std","",306,null],[11,"bitxor","","",289,null],[11,"bitxor","","",286,null],[11,"bitxor","","",301,null],[11,"bitxor","std::num","",194,null],[11,"bitxor","std","",306,null],[11,"bitxor","","",291,null],[11,"bitxor","","",300,null],[11,"bitxor","","",305,{"inputs":[{"name":"self"},{"name":"u16"}],"output":{"name":"u16"}}],[11,"bitxor","","",303,{"inputs":[{"name":"self"},{"name":"isize"}],"output":{"name":"isize"}}],[11,"bitxor","std::num","",194,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","std","",306,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"usize"}}],[11,"bitxor","std::num","",194,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","std","",287,null],[11,"bitxor","","",301,null],[11,"bitxor","","",302,null],[11,"bitxor","","",300,null],[11,"bitxor","std::num","",194,null],[11,"bitxor","std","",291,null],[11,"bitxor","","",302,null],[11,"bitxor","","",287,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"u64"}}],[11,"bitxor","std::num","",194,null],[11,"bitxor","","",194,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","std","",287,null],[11,"bitxor","std::num","",194,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","std","",304,null],[11,"bitxor","","",303,null],[11,"bitxor","std::num","",194,null],[11,"bitxor","std","",305,null],[11,"bitxor","std::num","",194,null],[11,"bitxor","std","",290,null],[11,"bitxor","std::num","",194,null],[11,"bitxor","std","",288,null],[11,"bitxor","","",303,null],[11,"bitxor","","",287,null],[11,"bitxor","std::num","",194,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",194,null],[11,"bitxor","std","",304,null],[11,"bitxor","std::num","",194,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",194,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","std","",300,{"inputs":[{"name":"self"},{"name":"u8"}],"output":{"name":"u8"}}],[11,"bitxor","std::num","",194,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","std","",300,null],[11,"bitxor","","",290,null],[11,"bitxor","","",290,{"inputs":[{"name":"self"},{"name":"i128"}],"output":{"name":"i128"}}],[11,"bitxor","","",291,null],[11,"bitxor","","",288,null],[11,"bitxor","","",288,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"i64"}}],[11,"bitxor","","",288,null],[11,"bitxor","","",301,null],[11,"bitxor","","",289,null],[11,"bitxor","","",304,{"inputs":[{"name":"self"},{"name":"i16"}],"output":{"name":"i16"}}],[11,"not","std::num","",194,{"inputs":[{"name":"self"}],"output":{"name":"wrapping"}}],[11,"not","std","",300,null],[11,"not","","",287,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"not","","",306,null],[11,"not","","",301,null],[11,"not","","",303,null],[11,"not","","",291,null],[11,"not","","",290,null],[11,"not","","",286,null],[11,"not","std::num","",194,{"inputs":[{"name":"self"}],"output":{"name":"wrapping"}}],[11,"not","std","",286,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"not","","",302,null],[11,"not","std::num","",194,{"inputs":[{"name":"self"}],"output":{"name":"wrapping"}}],[11,"not","std","",288,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[11,"not","std::num","",194,{"inputs":[{"name":"self"}],"output":{"name":"wrapping"}}],[11,"not","std","",287,null],[11,"not","","",306,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"not","std::num","",194,{"inputs":[{"name":"self"}],"output":{"name":"wrapping"}}],[11,"not","std","",288,null],[11,"not","","",289,{"inputs":[{"name":"self"}],"output":{"name":"i32"}}],[11,"not","","",304,null],[11,"not","std::num","",194,{"inputs":[{"name":"self"}],"output":{"name":"wrapping"}}],[11,"not","std","",289,null],[11,"not","","",301,{"inputs":[{"name":"self"}],"output":{"name":"i8"}}],[11,"not","std::num","",194,{"inputs":[{"name":"self"}],"output":{"name":"wrapping"}}],[11,"not","std","",305,null],[11,"not","std::num","",194,{"inputs":[{"name":"self"}],"output":{"name":"wrapping"}}],[11,"not","std","",300,{"inputs":[{"name":"self"}],"output":{"name":"u8"}}],[11,"not","","",290,{"inputs":[{"name":"self"}],"output":{"name":"i128"}}],[11,"not","","",305,{"inputs":[{"name":"self"}],"output":{"name":"u16"}}],[11,"not","std::num","",194,{"inputs":[{"name":"self"}],"output":{"name":"wrapping"}}],[11,"not","","",194,{"inputs":[{"name":"self"}],"output":{"name":"wrapping"}}],[11,"not","std","",304,{"inputs":[{"name":"self"}],"output":{"name":"i16"}}],[11,"not","","",303,{"inputs":[{"name":"self"}],"output":{"name":"isize"}}],[11,"not","","",302,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"not","std::num","",194,{"inputs":[{"name":"self"}],"output":{"name":"wrapping"}}],[11,"not","std","",291,{"inputs":[{"name":"self"}],"output":{"name":"u128"}}],[11,"not","std::num","",194,{"inputs":[{"name":"self"}],"output":{"name":"wrapping"}}],[11,"call","std","",312,null],[11,"product","","",290,{"inputs":[{"name":"i"}],"output":{"name":"i128"}}],[11,"product","std::num","",194,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","std","",291,{"inputs":[{"name":"i"}],"output":{"name":"u128"}}],[11,"product","std::num","",194,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",194,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",194,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",194,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","std","",288,{"inputs":[{"name":"i"}],"output":{"name":"i64"}}],[11,"product","","",306,{"inputs":[{"name":"i"}],"output":{"name":"usize"}}],[11,"product","std::num","",194,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",194,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","std","",288,{"inputs":[{"name":"i"}],"output":{"name":"i64"}}],[11,"product","","",293,{"inputs":[{"name":"i"}],"output":{"name":"f64"}}],[11,"product","std::num","",194,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","std::result","Takes each element in the `Iterator`: if it is an `Err`, no further elements are taken, and the `Err` is returned. Should no `Err` occur, the product of all elements is returned.",70,{"inputs":[{"name":"i"}],"output":{"name":"result"}}],[11,"product","std","",304,{"inputs":[{"name":"i"}],"output":{"name":"i16"}}],[11,"product","","",292,{"inputs":[{"name":"i"}],"output":{"name":"f32"}}],[11,"product","","",300,{"inputs":[{"name":"i"}],"output":{"name":"u8"}}],[11,"product","","",290,{"inputs":[{"name":"i"}],"output":{"name":"i128"}}],[11,"product","","",286,{"inputs":[{"name":"i"}],"output":{"name":"u32"}}],[11,"product","std::num","",194,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","std","",304,{"inputs":[{"name":"i"}],"output":{"name":"i16"}}],[11,"product","","",300,{"inputs":[{"name":"i"}],"output":{"name":"u8"}}],[11,"product","std::num","",194,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","std","",306,{"inputs":[{"name":"i"}],"output":{"name":"usize"}}],[11,"product","","",303,{"inputs":[{"name":"i"}],"output":{"name":"isize"}}],[11,"product","","",287,{"inputs":[{"name":"i"}],"output":{"name":"u64"}}],[11,"product","","",301,{"inputs":[{"name":"i"}],"output":{"name":"i8"}}],[11,"product","std::num","",194,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",194,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","std","",305,{"inputs":[{"name":"i"}],"output":{"name":"u16"}}],[11,"product","","",293,{"inputs":[{"name":"i"}],"output":{"name":"f64"}}],[11,"product","std::num","",194,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","std","",289,{"inputs":[{"name":"i"}],"output":{"name":"i32"}}],[11,"product","","",303,{"inputs":[{"name":"i"}],"output":{"name":"isize"}}],[11,"product","std::num","",194,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",194,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","std","",301,{"inputs":[{"name":"i"}],"output":{"name":"i8"}}],[11,"product","","",287,{"inputs":[{"name":"i"}],"output":{"name":"u64"}}],[11,"product","","",291,{"inputs":[{"name":"i"}],"output":{"name":"u128"}}],[11,"product","std::num","",194,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",194,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",194,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","std","",289,{"inputs":[{"name":"i"}],"output":{"name":"i32"}}],[11,"product","std::num","",194,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","std","",305,{"inputs":[{"name":"i"}],"output":{"name":"u16"}}],[11,"product","","",286,{"inputs":[{"name":"i"}],"output":{"name":"u32"}}],[11,"product","std::num","",194,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",194,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","std","",292,{"inputs":[{"name":"i"}],"output":{"name":"f32"}}],[11,"product","std::num","",194,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",194,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",194,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"into_iter","std","",308,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","std::option","Returns a consuming iterator over the possibly contained value.",71,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"into_iter","std","",308,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",309,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",309,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","std::result","Returns a consuming iterator over the possibly contained value.",70,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"into_iter","std","",308,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",308,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"mul","","",303,null],[11,"mul","","",290,{"inputs":[{"name":"self"},{"name":"i128"}],"output":{"name":"i128"}}],[11,"mul","std::num","",194,null],[11,"mul","std","",288,null],[11,"mul","","",306,null],[11,"mul","std::num","",194,null],[11,"mul","std","",306,null],[11,"mul","","",289,null],[11,"mul","std::num","",194,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul","","",194,null],[11,"mul","std","",301,{"inputs":[{"name":"self"},{"name":"i8"}],"output":{"name":"i8"}}],[11,"mul","","",291,null],[11,"mul","std::num","",194,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul","","",194,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul","","",194,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul","std","",292,null],[11,"mul","","",291,null],[11,"mul","","",290,null],[11,"mul","std::num","",194,null],[11,"mul","std","",304,null],[11,"mul","std::num","",194,null],[11,"mul","std","",287,null],[11,"mul","","",292,null],[11,"mul","","",287,null],[11,"mul","std::num","",194,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul","std","",293,{"inputs":[{"name":"self"},{"name":"f64"}],"output":{"name":"f64"}}],[11,"mul","","",300,null],[11,"mul","std::num","",194,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul","std","",301,null],[11,"mul","","",286,null],[11,"mul","","",291,null],[11,"mul","","",304,{"inputs":[{"name":"self"},{"name":"i16"}],"output":{"name":"i16"}}],[11,"mul","","",287,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"u64"}}],[11,"mul","","",306,null],[11,"mul","","",292,null],[11,"mul","","",305,null],[11,"mul","","",305,null],[11,"mul","","",305,null],[11,"mul","","",304,null],[11,"mul","","",292,{"inputs":[{"name":"self"},{"name":"f32"}],"output":{"name":"f32"}}],[11,"mul","","",293,null],[11,"mul","","",306,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"usize"}}],[11,"mul","std::num","",194,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul","","",194,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul","std","",300,null],[11,"mul","","",289,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"i32"}}],[11,"mul","std::num","",194,null],[11,"mul","std","",301,null],[11,"mul","","",303,null],[11,"mul","std::num","",194,null],[11,"mul","","",194,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul","std","",300,{"inputs":[{"name":"self"},{"name":"u8"}],"output":{"name":"u8"}}],[11,"mul","","",293,null],[11,"mul","","",305,{"inputs":[{"name":"self"},{"name":"u16"}],"output":{"name":"u16"}}],[11,"mul","","",286,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"u32"}}],[11,"mul","","",304,null],[11,"mul","","",288,null],[11,"mul","","",286,null],[11,"mul","","",287,null],[11,"mul","","",290,null],[11,"mul","","",300,null],[11,"mul","std::num","",194,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul","std","",303,{"inputs":[{"name":"self"},{"name":"isize"}],"output":{"name":"isize"}}],[11,"mul","std::num","",194,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul","","",194,null],[11,"mul","","",194,null],[11,"mul","","",194,null],[11,"mul","std","",289,null],[11,"mul","","",291,{"inputs":[{"name":"self"},{"name":"u128"}],"output":{"name":"u128"}}],[11,"mul","","",289,null],[11,"mul","","",293,null],[11,"mul","","",290,null],[11,"mul","std::num","",194,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul","","",194,null],[11,"mul","std","",286,null],[11,"mul","","",301,null],[11,"mul","","",288,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"i64"}}],[11,"mul","","",288,null],[11,"mul","std::num","",194,null],[11,"mul","std","",303,null],[11,"fmt","","",292,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",312,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",312,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",293,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"try_from","","",286,{"inputs":[{"name":"isize"}],"output":{"name":"result"}}],[11,"try_from","","",286,{"inputs":[{"name":"u64"}],"output":{"name":"result"}}],[11,"try_from","","",303,{"inputs":[{"name":"i64"}],"output":{"name":"result"}}],[11,"try_from","","",286,{"inputs":[{"name":"i16"}],"output":{"name":"result"}}],[11,"try_from","","",288,{"inputs":[{"name":"usize"}],"output":{"name":"result"}}],[11,"try_from","","",289,{"inputs":[{"name":"u64"}],"output":{"name":"result"}}],[11,"try_from","","",301,{"inputs":[{"name":"i16"}],"output":{"name":"result"}}],[11,"try_from","","",291,{"inputs":[{"name":"isize"}],"output":{"name":"result"}}],[11,"try_from","","",304,{"inputs":[{"name":"isize"}],"output":{"name":"result"}}],[11,"try_from","","",289,{"inputs":[{"name":"isize"}],"output":{"name":"result"}}],[11,"try_from","","",301,{"inputs":[{"name":"usize"}],"output":{"name":"result"}}],[11,"try_from","","",300,{"inputs":[{"name":"u64"}],"output":{"name":"result"}}],[11,"try_from","","",300,{"inputs":[{"name":"i32"}],"output":{"name":"result"}}],[11,"try_from","","",306,{"inputs":[{"name":"i128"}],"output":{"name":"result"}}],[11,"try_from","","",303,{"inputs":[{"name":"i128"}],"output":{"name":"result"}}],[11,"try_from","","",300,{"inputs":[{"name":"usize"}],"output":{"name":"result"}}],[11,"try_from","","",304,{"inputs":[{"name":"u16"}],"output":{"name":"result"}}],[11,"try_from","","",303,{"inputs":[{"name":"u32"}],"output":{"name":"result"}}],[11,"try_from","","",303,{"inputs":[{"name":"i32"}],"output":{"name":"result"}}],[11,"try_from","","",306,{"inputs":[{"name":"i32"}],"output":{"name":"result"}}],[11,"try_from","","",287,{"inputs":[{"name":"u128"}],"output":{"name":"result"}}],[11,"try_from","","",304,{"inputs":[{"name":"u64"}],"output":{"name":"result"}}],[11,"try_from","","",291,{"inputs":[{"name":"i32"}],"output":{"name":"result"}}],[11,"try_from","","",290,{"inputs":[{"name":"usize"}],"output":{"name":"result"}}],[11,"try_from","","",304,{"inputs":[{"name":"i128"}],"output":{"name":"result"}}],[11,"try_from","","",291,{"inputs":[{"name":"usize"}],"output":{"name":"result"}}],[11,"try_from","","",305,{"inputs":[{"name":"i8"}],"output":{"name":"result"}}],[11,"try_from","","",286,{"inputs":[{"name":"i128"}],"output":{"name":"result"}}],[11,"try_from","","",304,{"inputs":[{"name":"i64"}],"output":{"name":"result"}}],[11,"try_from","","",301,{"inputs":[{"name":"u64"}],"output":{"name":"result"}}],[11,"try_from","","",304,{"inputs":[{"name":"usize"}],"output":{"name":"result"}}],[11,"try_from","","",301,{"inputs":[{"name":"i64"}],"output":{"name":"result"}}],[11,"try_from","","",303,{"inputs":[{"name":"u128"}],"output":{"name":"result"}}],[11,"try_from","","",287,{"inputs":[{"name":"i64"}],"output":{"name":"result"}}],[11,"try_from","","",301,{"inputs":[{"name":"i32"}],"output":{"name":"result"}}],[11,"try_from","","",305,{"inputs":[{"name":"i16"}],"output":{"name":"result"}}],[11,"try_from","","",291,{"inputs":[{"name":"i64"}],"output":{"name":"result"}}],[11,"try_from","","",306,{"inputs":[{"name":"isize"}],"output":{"name":"result"}}],[11,"try_from","","",306,{"inputs":[{"name":"i64"}],"output":{"name":"result"}}],[11,"try_from","","",287,{"inputs":[{"name":"i16"}],"output":{"name":"result"}}],[11,"try_from","","",301,{"inputs":[{"name":"i128"}],"output":{"name":"result"}}],[11,"try_from","","",306,{"inputs":[{"name":"u16"}],"output":{"name":"result"}}],[11,"try_from","","",287,{"inputs":[{"name":"i32"}],"output":{"name":"result"}}],[11,"try_from","","",301,{"inputs":[{"name":"u16"}],"output":{"name":"result"}}],[11,"try_from","","",291,{"inputs":[{"name":"i16"}],"output":{"name":"result"}}],[11,"try_from","","",300,{"inputs":[{"name":"i16"}],"output":{"name":"result"}}],[11,"try_from","","",291,{"inputs":[{"name":"i128"}],"output":{"name":"result"}}],[11,"try_from","","",289,{"inputs":[{"name":"u32"}],"output":{"name":"result"}}],[11,"try_from","","",289,{"inputs":[{"name":"i64"}],"output":{"name":"result"}}],[11,"try_from","","",301,{"inputs":[{"name":"u128"}],"output":{"name":"result"}}],[11,"try_from","","",305,{"inputs":[{"name":"u128"}],"output":{"name":"result"}}],[11,"try_from","","",286,{"inputs":[{"name":"u128"}],"output":{"name":"result"}}],[11,"try_from","","",303,{"inputs":[{"name":"u16"}],"output":{"name":"result"}}],[11,"try_from","","",287,{"inputs":[{"name":"i128"}],"output":{"name":"result"}}],[11,"try_from","","",305,{"inputs":[{"name":"i64"}],"output":{"name":"result"}}],[11,"try_from","","",300,{"inputs":[{"name":"i8"}],"output":{"name":"result"}}],[11,"try_from","","",286,{"inputs":[{"name":"i8"}],"output":{"name":"result"}}],[11,"try_from","","",300,{"inputs":[{"name":"u32"}],"output":{"name":"result"}}],[11,"try_from","","",301,{"inputs":[{"name":"isize"}],"output":{"name":"result"}}],[11,"try_from","","",304,{"inputs":[{"name":"i32"}],"output":{"name":"result"}}],[11,"try_from","","",303,{"inputs":[{"name":"u8"}],"output":{"name":"result"}}],[11,"try_from","","",305,{"inputs":[{"name":"i128"}],"output":{"name":"result"}}],[11,"try_from","","",300,{"inputs":[{"name":"i64"}],"output":{"name":"result"}}],[11,"try_from","","",291,{"inputs":[{"name":"i8"}],"output":{"name":"result"}}],[11,"try_from","","",287,{"inputs":[{"name":"usize"}],"output":{"name":"result"}}],[11,"try_from","","",306,{"inputs":[{"name":"u64"}],"output":{"name":"result"}}],[11,"try_from","","",288,{"inputs":[{"name":"u128"}],"output":{"name":"result"}}],[11,"try_from","","",301,{"inputs":[{"name":"u8"}],"output":{"name":"result"}}],[11,"try_from","","",305,{"inputs":[{"name":"usize"}],"output":{"name":"result"}}],[11,"try_from","","",300,{"inputs":[{"name":"u16"}],"output":{"name":"result"}}],[11,"try_from","","",288,{"inputs":[{"name":"u64"}],"output":{"name":"result"}}],[11,"try_from","","",290,{"inputs":[{"name":"isize"}],"output":{"name":"result"}}],[11,"try_from","","",286,{"inputs":[{"name":"i64"}],"output":{"name":"result"}}],[11,"try_from","","",303,{"inputs":[{"name":"i16"}],"output":{"name":"result"}}],[11,"try_from","","",288,{"inputs":[{"name":"i128"}],"output":{"name":"result"}}],[11,"try_from","","",289,{"inputs":[{"name":"usize"}],"output":{"name":"result"}}],[11,"try_from","","",300,{"inputs":[{"name":"isize"}],"output":{"name":"result"}}],[11,"try_from","","",305,{"inputs":[{"name":"u32"}],"output":{"name":"result"}}],[11,"try_from","","",304,{"inputs":[{"name":"u32"}],"output":{"name":"result"}}],[11,"try_from","","",286,{"inputs":[{"name":"usize"}],"output":{"name":"result"}}],[11,"try_from","","",305,{"inputs":[{"name":"i32"}],"output":{"name":"result"}}],[11,"try_from","","",287,{"inputs":[{"name":"i8"}],"output":{"name":"result"}}],[11,"try_from","","",303,{"inputs":[{"name":"u64"}],"output":{"name":"result"}}],[11,"try_from","","",290,{"inputs":[{"name":"u128"}],"output":{"name":"result"}}],[11,"try_from","","",305,{"inputs":[{"name":"isize"}],"output":{"name":"result"}}],[11,"try_from","","",288,{"inputs":[{"name":"isize"}],"output":{"name":"result"}}],[11,"try_from","","",289,{"inputs":[{"name":"i128"}],"output":{"name":"result"}}],[11,"try_from","","",305,{"inputs":[{"name":"u64"}],"output":{"name":"result"}}],[11,"try_from","","",306,{"inputs":[{"name":"i8"}],"output":{"name":"result"}}],[11,"try_from","","",300,{"inputs":[{"name":"i128"}],"output":{"name":"result"}}],[11,"try_from","","",300,{"inputs":[{"name":"u128"}],"output":{"name":"result"}}],[11,"try_from","","",306,{"inputs":[{"name":"u32"}],"output":{"name":"result"}}],[11,"try_from","","",306,{"inputs":[{"name":"u128"}],"output":{"name":"result"}}],[11,"try_from","","",310,{"inputs":[{"name":"u32"}],"output":{"name":"result"}}],[11,"try_from","","",303,{"inputs":[{"name":"usize"}],"output":{"name":"result"}}],[11,"try_from","","",289,{"inputs":[{"name":"u128"}],"output":{"name":"result"}}],[11,"try_from","","",301,{"inputs":[{"name":"u32"}],"output":{"name":"result"}}],[11,"try_from","","",306,{"inputs":[{"name":"i16"}],"output":{"name":"result"}}],[11,"try_from","","",304,{"inputs":[{"name":"u128"}],"output":{"name":"result"}}],[11,"try_from","","",286,{"inputs":[{"name":"i32"}],"output":{"name":"result"}}],[11,"try_from","","",287,{"inputs":[{"name":"isize"}],"output":{"name":"result"}}],[11,"steps_between","","",300,{"inputs":[{"name":"u8"},{"name":"u8"}],"output":{"name":"option"}}],[11,"add_usize","","",300,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"replace_one","","",300,{"inputs":[{"name":"self"}],"output":{"name":"u8"}}],[11,"replace_zero","","",300,{"inputs":[{"name":"self"}],"output":{"name":"u8"}}],[11,"add_one","","",300,{"inputs":[{"name":"self"}],"output":{"name":"u8"}}],[11,"sub_one","","",300,{"inputs":[{"name":"self"}],"output":{"name":"u8"}}],[11,"steps_between","","",306,{"inputs":[{"name":"usize"},{"name":"usize"}],"output":{"name":"option"}}],[11,"add_usize","","",306,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"replace_one","","",306,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"replace_zero","","",306,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"add_one","","",306,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"sub_one","","",306,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"steps_between","","",304,{"inputs":[{"name":"i16"},{"name":"i16"}],"output":{"name":"option"}}],[11,"add_usize","","",304,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"replace_one","","",304,{"inputs":[{"name":"self"}],"output":{"name":"i16"}}],[11,"replace_zero","","",304,{"inputs":[{"name":"self"}],"output":{"name":"i16"}}],[11,"add_one","","",304,{"inputs":[{"name":"self"}],"output":{"name":"i16"}}],[11,"sub_one","","",304,{"inputs":[{"name":"self"}],"output":{"name":"i16"}}],[11,"steps_between","","",301,{"inputs":[{"name":"i8"},{"name":"i8"}],"output":{"name":"option"}}],[11,"add_usize","","",301,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"replace_one","","",301,{"inputs":[{"name":"self"}],"output":{"name":"i8"}}],[11,"replace_zero","","",301,{"inputs":[{"name":"self"}],"output":{"name":"i8"}}],[11,"add_one","","",301,{"inputs":[{"name":"self"}],"output":{"name":"i8"}}],[11,"sub_one","","",301,{"inputs":[{"name":"self"}],"output":{"name":"i8"}}],[11,"steps_between","","",286,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"option"}}],[11,"add_usize","","",286,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"replace_one","","",286,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"replace_zero","","",286,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"add_one","","",286,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"sub_one","","",286,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"steps_between","","",303,{"inputs":[{"name":"isize"},{"name":"isize"}],"output":{"name":"option"}}],[11,"add_usize","","",303,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"replace_one","","",303,{"inputs":[{"name":"self"}],"output":{"name":"isize"}}],[11,"replace_zero","","",303,{"inputs":[{"name":"self"}],"output":{"name":"isize"}}],[11,"add_one","","",303,{"inputs":[{"name":"self"}],"output":{"name":"isize"}}],[11,"sub_one","","",303,{"inputs":[{"name":"self"}],"output":{"name":"isize"}}],[11,"steps_between","","",305,{"inputs":[{"name":"u16"},{"name":"u16"}],"output":{"name":"option"}}],[11,"add_usize","","",305,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"replace_one","","",305,{"inputs":[{"name":"self"}],"output":{"name":"u16"}}],[11,"replace_zero","","",305,{"inputs":[{"name":"self"}],"output":{"name":"u16"}}],[11,"add_one","","",305,{"inputs":[{"name":"self"}],"output":{"name":"u16"}}],[11,"sub_one","","",305,{"inputs":[{"name":"self"}],"output":{"name":"u16"}}],[11,"steps_between","","",287,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"option"}}],[11,"add_usize","","",287,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"replace_one","","",287,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"replace_zero","","",287,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"add_one","","",287,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"sub_one","","",287,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"steps_between","","",289,{"inputs":[{"name":"i32"},{"name":"i32"}],"output":{"name":"option"}}],[11,"add_usize","","",289,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"replace_one","","",289,{"inputs":[{"name":"self"}],"output":{"name":"i32"}}],[11,"replace_zero","","",289,{"inputs":[{"name":"self"}],"output":{"name":"i32"}}],[11,"add_one","","",289,{"inputs":[{"name":"self"}],"output":{"name":"i32"}}],[11,"sub_one","","",289,{"inputs":[{"name":"self"}],"output":{"name":"i32"}}],[11,"steps_between","","",288,{"inputs":[{"name":"i64"},{"name":"i64"}],"output":{"name":"option"}}],[11,"add_usize","","",288,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"replace_one","","",288,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[11,"replace_zero","","",288,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[11,"add_one","","",288,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[11,"sub_one","","",288,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[11,"steps_between","","",290,{"inputs":[{"name":"i128"},{"name":"i128"}],"output":{"name":"option"}}],[11,"add_usize","","",290,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"replace_one","","",290,{"inputs":[{"name":"self"}],"output":{"name":"i128"}}],[11,"replace_zero","","",290,{"inputs":[{"name":"self"}],"output":{"name":"i128"}}],[11,"add_one","","",290,{"inputs":[{"name":"self"}],"output":{"name":"i128"}}],[11,"sub_one","","",290,{"inputs":[{"name":"self"}],"output":{"name":"i128"}}],[11,"steps_between","","",291,{"inputs":[{"name":"u128"},{"name":"u128"}],"output":{"name":"option"}}],[11,"add_usize","","",291,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"replace_one","","",291,{"inputs":[{"name":"self"}],"output":{"name":"u128"}}],[11,"replace_zero","","",291,{"inputs":[{"name":"self"}],"output":{"name":"u128"}}],[11,"add_one","","",291,{"inputs":[{"name":"self"}],"output":{"name":"u128"}}],[11,"sub_one","","",291,{"inputs":[{"name":"self"}],"output":{"name":"u128"}}],[11,"build_hasher","std::hash","",335,{"inputs":[{"name":"self"}],"output":{"name":"h"}}],[11,"fmt","std::num","",194,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std","",288,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",304,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",312,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",287,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",306,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",286,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",291,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",290,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",312,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",303,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",300,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",305,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",301,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",289,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",312,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",305,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",286,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",289,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",291,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",300,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::num","",194,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std","",288,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",306,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",304,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",290,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",287,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",301,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",303,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",312,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"from_str","","",288,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",305,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","Converts a string in base 10 to a float. Accepts an optional decimal exponent.",293,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",304,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",310,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",303,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",290,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",287,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",300,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",301,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",286,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",291,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",289,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","Converts a string in base 10 to a float. Accepts an optional decimal exponent.",292,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",306,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","Parse a `bool` from a string.",302,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"get","std::ops","",65,null],[11,"get_mut","","",65,null],[11,"get_unchecked","","",65,null],[11,"get_unchecked_mut","","",65,null],[11,"index","","",65,null],[11,"index_mut","","",65,null],[11,"get","","",65,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"option"}}],[11,"get_mut","","",65,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"option"}}],[11,"get_unchecked","","",65,null],[11,"get_unchecked_mut","","",65,null],[11,"index","","",65,null],[11,"index_mut","","",65,null],[11,"get","","",322,null],[11,"get_mut","","",322,null],[11,"get_unchecked","","",322,null],[11,"get_unchecked_mut","","",322,null],[11,"index","","",322,null],[11,"index_mut","","",322,null],[11,"get","","",52,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"option"}}],[11,"get_mut","","",52,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"option"}}],[11,"get_unchecked","","",52,null],[11,"get_unchecked_mut","","",52,null],[11,"index","","",52,null],[11,"index_mut","","",52,null],[11,"get","","",38,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"option"}}],[11,"get_mut","","",38,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"option"}}],[11,"get_unchecked","","",38,null],[11,"get_unchecked_mut","","",38,null],[11,"index","","",38,null],[11,"index_mut","","",38,null],[11,"get","","",33,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"option"}}],[11,"get_mut","","",33,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"option"}}],[11,"get_unchecked","","",33,null],[11,"get_unchecked_mut","","",33,null],[11,"index","","",33,null],[11,"index_mut","","",33,null],[11,"get","std","",306,null],[11,"get_mut","","",306,null],[11,"get_unchecked","","",306,null],[11,"get_unchecked_mut","","",306,null],[11,"index","","",306,null],[11,"index_mut","","",306,null],[11,"get","std::ops","",26,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"option"}}],[11,"get_mut","","",26,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"option"}}],[11,"get_unchecked","","",26,null],[11,"get_unchecked_mut","","",26,null],[11,"index","","",26,null],[11,"index_mut","","",26,null],[11,"get","","",33,null],[11,"get_mut","","",33,null],[11,"get_unchecked","","",33,null],[11,"get_unchecked_mut","","",33,null],[11,"index","","",33,null],[11,"index_mut","","",33,null],[11,"get","","",26,null],[11,"get_mut","","",26,null],[11,"get_unchecked","","",26,null],[11,"get_unchecked_mut","","",26,null],[11,"index","","",26,null],[11,"index_mut","","",26,null],[11,"get","","",322,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"option"}}],[11,"get_mut","","",322,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"option"}}],[11,"get_unchecked","","",322,null],[11,"get_unchecked_mut","","",322,null],[11,"index","","",322,null],[11,"index_mut","","",322,null],[11,"get","","",38,null],[11,"get_mut","","",38,null],[11,"get_unchecked","","",38,null],[11,"get_unchecked_mut","","",38,null],[11,"index","","",38,null],[11,"index_mut","","",38,null],[11,"get","","",52,null],[11,"get_mut","","",52,null],[11,"get_unchecked","","",52,null],[11,"get_unchecked_mut","","",52,null],[11,"index","","",52,null],[11,"index_mut","","",52,null],[11,"default","std","",308,null],[11,"default","","",308,null],[11,"default","std::sync::atomic","",336,{"inputs":[],"output":{"name":"atomici16"}}],[11,"default","std","",308,null],[11,"default","","",308,null],[11,"default","","",308,null],[11,"default","","",308,null],[11,"default","","Returns the default value of `0`",290,{"inputs":[],"output":{"name":"i128"}}],[11,"default","","",308,null],[11,"default","","Returns the default value of `0`",301,{"inputs":[],"output":{"name":"i8"}}],[11,"default","","",313,null],[11,"default","","",308,null],[11,"default","","Returns the default value of `0`",303,{"inputs":[],"output":{"name":"isize"}}],[11,"default","std::hash","",335,{"inputs":[],"output":{"name":"buildhasherdefault"}}],[11,"default","std","Returns the default value of `0`",305,{"inputs":[],"output":{"name":"u16"}}],[11,"default","","",313,null],[11,"default","std::sync::atomic","",337,{"inputs":[],"output":{"name":"atomicu8"}}],[11,"default","std","Returns the default value of `0`",287,{"inputs":[],"output":{"name":"u64"}}],[11,"default","","",308,null],[11,"default","","",308,null],[11,"default","","Returns the default value of `0`",306,{"inputs":[],"output":{"name":"usize"}}],[11,"default","std::hash","",338,{"inputs":[],"output":{"name":"siphasher13"}}],[11,"default","std::sync::atomic","",339,{"inputs":[],"output":{"name":"atomicu16"}}],[11,"default","","Creates an `AtomicBool` initialized to `false`.",340,{"inputs":[],"output":{"name":"atomicbool"}}],[11,"default","std::cell","Creates an `UnsafeCell`, with the `Default` value for T.",341,{"inputs":[],"output":{"name":"unsafecell"}}],[11,"default","std::sync::atomic","",342,{"inputs":[],"output":{"name":"atomicu64"}}],[11,"default","","",343,{"inputs":[],"output":{"name":"atomicusize"}}],[11,"default","std","",308,null],[11,"default","std::cell","Creates a `Cell<T>`, with the `Default` value for T.",318,{"inputs":[],"output":{"name":"cell"}}],[11,"default","std","",313,null],[11,"default","","",308,null],[11,"default","std::fmt","",126,{"inputs":[],"output":{"name":"error"}}],[11,"default","std::cell","Creates a `RefCell<T>`, with the `Default` value for T.",315,{"inputs":[],"output":{"name":"refcell"}}],[11,"default","std","",308,null],[11,"default","","Creates an empty slice.",309,null],[11,"default","","",308,null],[11,"default","","",308,null],[11,"default","","",313,null],[11,"default","","",308,null],[11,"default","","",313,null],[11,"default","std::sync::atomic","",344,{"inputs":[],"output":{"name":"atomicu32"}}],[11,"default","std","",308,null],[11,"default","std::option","Returns [`None`].",71,{"inputs":[],"output":{"name":"option"}}],[11,"default","std","Returns the default value of `0`",288,{"inputs":[],"output":{"name":"i64"}}],[11,"default","","",308,null],[11,"default","","",308,null],[11,"default","","",308,null],[11,"default","","",313,null],[11,"default","std::sync::atomic","",345,{"inputs":[],"output":{"name":"atomici32"}}],[11,"default","std","",308,null],[11,"default","","",308,null],[11,"default","","",308,null],[11,"default","","",313,null],[11,"default","std::sync::atomic","",346,{"inputs":[],"output":{"name":"atomici64"}}],[11,"default","std","",308,null],[11,"default","","Returns the default value of `()`",313,null],[11,"default","","Returns the default value of `0`",304,{"inputs":[],"output":{"name":"i16"}}],[11,"default","","",313,null],[11,"default","","",308,null],[11,"default","","",308,null],[11,"default","","Returns the default value of `false`",302,{"inputs":[],"output":{"name":"bool"}}],[11,"default","std::sync::atomic","Creates a null `AtomicPtr<T>`.",347,{"inputs":[],"output":{"name":"atomicptr"}}],[11,"default","std","",308,null],[11,"default","","",308,null],[11,"default","","Creates a mutable empty slice.",309,null],[11,"default","","Returns the default value of `0`",291,{"inputs":[],"output":{"name":"u128"}}],[11,"default","","",308,null],[11,"default","std::sync::atomic","",348,{"inputs":[],"output":{"name":"atomici8"}}],[11,"default","std","",308,null],[11,"default","","Returns the default value of `0`",289,{"inputs":[],"output":{"name":"i32"}}],[11,"default","","",308,null],[11,"default","std::sync::atomic","",349,{"inputs":[],"output":{"name":"atomicisize"}}],[11,"default","std","",308,null],[11,"default","","",313,null],[11,"default","","Returns the default value of `0.0`",293,{"inputs":[],"output":{"name":"f64"}}],[11,"default","std::hash","",350,{"inputs":[],"output":{"name":"siphasher24"}}],[11,"default","std","Returns the default value of `0`",300,{"inputs":[],"output":{"name":"u8"}}],[11,"default","std::marker","",311,{"inputs":[],"output":{"name":"phantomdata"}}],[11,"default","std::hash","",351,{"inputs":[],"output":{"name":"siphasher"}}],[11,"default","std","Returns the default value of `0.0`",292,{"inputs":[],"output":{"name":"f32"}}],[11,"default","","Returns the default value of `0`",286,{"inputs":[],"output":{"name":"u32"}}],[11,"default","std::num","",194,{"inputs":[],"output":{"name":"wrapping"}}],[11,"default","std::mem","",320,{"inputs":[],"output":{"name":"manuallydrop"}}],[11,"default","std","",313,null],[11,"default","","",313,null],[11,"default","","",308,null],[11,"default","","",313,null],[11,"default","","Creates an empty str",295,{"inputs":[],"output":{"name":"str"}}],[11,"default","","Returns the default value of `\\x00`",310,{"inputs":[],"output":{"name":"char"}}],[11,"default","std::iter","",352,{"inputs":[],"output":{"name":"empty"}}],[11,"clone","std::str","",353,{"inputs":[{"name":"self"}],"output":{"name":"split"}}],[11,"clone","std::str::pattern","",331,{"inputs":[{"name":"self"}],"output":{"name":"charslicesearcher"}}],[11,"clone","std::ops","",52,{"inputs":[{"name":"self"}],"output":{"name":"rangefrom"}}],[11,"clone","std::str","",354,{"inputs":[{"name":"self"}],"output":{"name":"matches"}}],[11,"clone","std::option","",355,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"clone","std::ops","",30,{"inputs":[{"name":"self"}],"output":{"name":"generatorstate"}}],[11,"clone","std::slice","",356,{"inputs":[{"name":"self"}],"output":{"name":"windows"}}],[11,"clone","std::mem","",320,{"inputs":[{"name":"self"}],"output":{"name":"manuallydrop"}}],[11,"clone_from","","",320,null],[11,"clone","std::iter","",357,{"inputs":[{"name":"self"}],"output":{"name":"skipwhile"}}],[11,"clone","std::option","",71,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","std::ops","",322,{"inputs":[{"name":"self"}],"output":{"name":"rangefull"}}],[11,"clone","std::hash","",335,{"inputs":[{"name":"self"}],"output":{"name":"buildhasherdefault"}}],[11,"clone","std::str","",358,{"inputs":[{"name":"self"}],"output":{"name":"chars"}}],[11,"clone","std::convert","",131,{"inputs":[{"name":"self"}],"output":{"name":"infallible"}}],[11,"clone","std::str","",359,{"inputs":[{"name":"self"}],"output":{"name":"splitterminator"}}],[11,"clone","std::char","",130,{"inputs":[{"name":"self"}],"output":{"name":"parsecharerror"}}],[11,"clone","std::iter","",360,{"inputs":[{"name":"self"}],"output":{"name":"once"}}],[11,"clone","std::char","",327,{"inputs":[{"name":"self"}],"output":{"name":"escapedebug"}}],[11,"clone","std::option","",361,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"clone","std::num","",314,{"inputs":[{"name":"self"}],"output":{"name":"parsefloaterror"}}],[11,"clone","std::result","",362,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"clone","std::raw","",69,{"inputs":[{"name":"self"}],"output":{"name":"traitobject"}}],[11,"clone","std::slice","",363,{"inputs":[{"name":"self"}],"output":{"name":"rsplit"}}],[11,"clone","std::cmp","",3,{"inputs":[{"name":"self"}],"output":{"name":"ordering"}}],[11,"clone","std::slice","",364,{"inputs":[{"name":"self"}],"output":{"name":"chunks"}}],[11,"clone","std::ops","",26,{"inputs":[{"name":"self"}],"output":{"name":"rangetoinclusive"}}],[11,"clone","std::cell","",318,{"inputs":[{"name":"self"}],"output":{"name":"cell"}}],[11,"clone","std::marker","",311,{"inputs":[{"name":"self"}],"output":{"name":"phantomdata"}}],[11,"clone","std::slice","",365,{"inputs":[{"name":"self"}],"output":{"name":"split"}}],[11,"clone","std::num","",193,{"inputs":[{"name":"self"}],"output":{"name":"fpcategory"}}],[11,"clone","std::iter","",352,{"inputs":[{"name":"self"}],"output":{"name":"empty"}}],[11,"clone","std::ptr","",366,{"inputs":[{"name":"self"}],"output":{"name":"unique"}}],[11,"clone","std::str::pattern","",90,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"clone","std::iter","",367,{"inputs":[{"name":"self"}],"output":{"name":"cloned"}}],[11,"clone","std::any","",323,{"inputs":[{"name":"self"}],"output":{"name":"typeid"}}],[11,"clone","std::iter","",368,{"inputs":[{"name":"self"}],"output":{"name":"takewhile"}}],[11,"clone","","",369,{"inputs":[{"name":"self"}],"output":{"name":"inspect"}}],[11,"clone","std::mem","",321,{"inputs":[{"name":"self"}],"output":{"name":"discriminant"}}],[11,"clone","std::num","",330,{"inputs":[{"name":"self"}],"output":{"name":"tryfrominterror"}}],[11,"clone","std::ops","",33,{"inputs":[{"name":"self"}],"output":{"name":"rangeinclusive"}}],[11,"clone","std::iter","",370,{"inputs":[{"name":"self"}],"output":{"name":"skip"}}],[11,"clone","std::str","",121,{"inputs":[{"name":"self"}],"output":{"name":"utf8error"}}],[11,"clone","std::iter","",371,{"inputs":[{"name":"self"}],"output":{"name":"flatmap"}}],[11,"clone","std::result","",70,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"clone","std::str","",372,{"inputs":[{"name":"self"}],"output":{"name":"matchindices"}}],[11,"clone","std::num","",319,{"inputs":[{"name":"self"}],"output":{"name":"parseinterror"}}],[11,"clone","std::iter","",373,{"inputs":[{"name":"self"}],"output":{"name":"chain"}}],[11,"clone","std::fmt","",325,{"inputs":[{"name":"self"}],"output":{"name":"arguments"}}],[11,"clone","std::iter","",374,{"inputs":[{"name":"self"}],"output":{"name":"enumerate"}}],[11,"clone","","",375,{"inputs":[{"name":"self"}],"output":{"name":"filtermap"}}],[11,"clone","std::str","",376,{"inputs":[{"name":"self"}],"output":{"name":"linesany"}}],[11,"clone","std::iter","",377,{"inputs":[{"name":"self"}],"output":{"name":"repeat"}}],[11,"clone","","",378,{"inputs":[{"name":"self"}],"output":{"name":"map"}}],[11,"clone","std::char","",129,{"inputs":[{"name":"self"}],"output":{"name":"chartryfromerror"}}],[11,"clone","std::ptr","",379,{"inputs":[{"name":"self"}],"output":{"name":"shared"}}],[11,"clone","std::hash","",351,{"inputs":[{"name":"self"}],"output":{"name":"siphasher"}}],[11,"clone","std::char","",326,{"inputs":[{"name":"self"}],"output":{"name":"escapeunicode"}}],[11,"clone","std::fmt","",126,{"inputs":[{"name":"self"}],"output":{"name":"error"}}],[11,"clone","std::iter","",380,{"inputs":[{"name":"self"}],"output":{"name":"take"}}],[11,"clone","std::char","",324,{"inputs":[{"name":"self"}],"output":{"name":"escapedefault"}}],[11,"clone","std::iter","",381,{"inputs":[{"name":"self"}],"output":{"name":"peekable"}}],[11,"clone","std::hash","",350,{"inputs":[{"name":"self"}],"output":{"name":"siphasher24"}}],[11,"clone","std::sync::atomic","",244,{"inputs":[{"name":"self"}],"output":{"name":"ordering"}}],[11,"clone","std::iter","",382,{"inputs":[{"name":"self"}],"output":{"name":"rev"}}],[11,"clone","","",383,{"inputs":[{"name":"self"}],"output":{"name":"zip"}}],[11,"clone","","",384,{"inputs":[{"name":"self"}],"output":{"name":"fuse"}}],[11,"clone","std::str","",385,{"inputs":[{"name":"self"}],"output":{"name":"lines"}}],[11,"clone","","",386,{"inputs":[{"name":"self"}],"output":{"name":"rmatches"}}],[11,"clone","std::char","",387,{"inputs":[{"name":"self"}],"output":{"name":"decodeutf8"}}],[11,"clone","std::ops","",38,{"inputs":[{"name":"self"}],"output":{"name":"rangeto"}}],[11,"clone","std::str::pattern","",332,{"inputs":[{"name":"self"}],"output":{"name":"charpredicatesearcher"}}],[11,"clone","std::cell","",315,{"inputs":[{"name":"self"}],"output":{"name":"refcell"}}],[11,"clone","std::str","",388,{"inputs":[{"name":"self"}],"output":{"name":"rsplitn"}}],[11,"clone","","",389,{"inputs":[{"name":"self"}],"output":{"name":"rmatchindices"}}],[11,"clone","std::ops","",65,{"inputs":[{"name":"self"}],"output":{"name":"range"}}],[11,"clone","std::str","",390,{"inputs":[{"name":"self"}],"output":{"name":"rsplit"}}],[11,"clone","std::iter","",391,{"inputs":[{"name":"self"}],"output":{"name":"scan"}}],[11,"clone","","",392,{"inputs":[{"name":"self"}],"output":{"name":"stepby"}}],[11,"clone","std::str","",393,{"inputs":[{"name":"self"}],"output":{"name":"charindices"}}],[11,"clone","std::hash","",338,{"inputs":[{"name":"self"}],"output":{"name":"siphasher13"}}],[11,"clone","std::str","",120,{"inputs":[{"name":"self"}],"output":{"name":"parseboolerror"}}],[11,"clone","std::iter","",394,{"inputs":[{"name":"self"}],"output":{"name":"cycle"}}],[11,"clone","std::option","",316,{"inputs":[{"name":"self"}],"output":{"name":"noneerror"}}],[11,"clone","std::str::pattern","",333,{"inputs":[{"name":"self"}],"output":{"name":"strsearcher"}}],[11,"clone","std::str","",395,{"inputs":[{"name":"self"}],"output":{"name":"rsplitterminator"}}],[11,"clone","std::iter","",396,{"inputs":[{"name":"self"}],"output":{"name":"filter"}}],[11,"clone","std::str","",397,{"inputs":[{"name":"self"}],"output":{"name":"bytes"}}],[11,"clone","","",398,{"inputs":[{"name":"self"}],"output":{"name":"splitn"}}],[11,"clone","std::str::pattern","",334,{"inputs":[{"name":"self"}],"output":{"name":"charsearcher"}}],[11,"clone","std::slice","",399,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"clone","std::num","",194,{"inputs":[{"name":"self"}],"output":{"name":"wrapping"}}],[11,"partial_cmp","std","",313,null],[11,"lt","","",313,null],[11,"le","","",313,null],[11,"ge","","",313,null],[11,"gt","","",313,null],[11,"partial_cmp","","",308,null],[11,"lt","","",308,null],[11,"le","","",308,null],[11,"ge","","",308,null],[11,"gt","","",308,null],[11,"partial_cmp","","",313,null],[11,"lt","","",313,null],[11,"le","","",313,null],[11,"ge","","",313,null],[11,"gt","","",313,null],[11,"partial_cmp","","",307,null],[11,"partial_cmp","","",307,null],[11,"partial_cmp","","",307,null],[11,"partial_cmp","","",307,null],[11,"partial_cmp","","",303,{"inputs":[{"name":"self"},{"name":"isize"}],"output":{"name":"option"}}],[11,"lt","","",303,{"inputs":[{"name":"self"},{"name":"isize"}],"output":{"name":"bool"}}],[11,"le","","",303,{"inputs":[{"name":"self"},{"name":"isize"}],"output":{"name":"bool"}}],[11,"ge","","",303,{"inputs":[{"name":"self"},{"name":"isize"}],"output":{"name":"bool"}}],[11,"gt","","",303,{"inputs":[{"name":"self"},{"name":"isize"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",308,null],[11,"lt","","",308,null],[11,"le","","",308,null],[11,"ge","","",308,null],[11,"gt","","",308,null],[11,"partial_cmp","","",308,null],[11,"lt","","",308,null],[11,"le","","",308,null],[11,"ge","","",308,null],[11,"gt","","",308,null],[11,"partial_cmp","","",307,null],[11,"partial_cmp","","",308,null],[11,"lt","","",308,null],[11,"le","","",308,null],[11,"ge","","",308,null],[11,"gt","","",308,null],[11,"partial_cmp","","",307,null],[11,"partial_cmp","","",307,null],[11,"partial_cmp","","",307,null],[11,"partial_cmp","","",308,null],[11,"lt","","",308,null],[11,"le","","",308,null],[11,"ge","","",308,null],[11,"gt","","",308,null],[11,"partial_cmp","","",307,null],[11,"partial_cmp","","",308,null],[11,"lt","","",308,null],[11,"le","","",308,null],[11,"ge","","",308,null],[11,"gt","","",308,null],[11,"partial_cmp","","",308,null],[11,"lt","","",308,null],[11,"le","","",308,null],[11,"ge","","",308,null],[11,"gt","","",308,null],[11,"partial_cmp","","",307,null],[11,"partial_cmp","","",307,null],[11,"partial_cmp","std::cmp","",3,{"inputs":[{"name":"self"},{"name":"ordering"}],"output":{"name":"option"}}],[11,"partial_cmp","std","",307,null],[11,"partial_cmp","","",307,null],[11,"partial_cmp","std::option","",71,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"name":"option"}}],[11,"lt","","",71,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"name":"bool"}}],[11,"le","","",71,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"name":"bool"}}],[11,"gt","","",71,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"name":"bool"}}],[11,"ge","","",71,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"name":"bool"}}],[11,"partial_cmp","std","",307,null],[11,"partial_cmp","","",288,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"option"}}],[11,"lt","","",288,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"bool"}}],[11,"le","","",288,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"bool"}}],[11,"ge","","",288,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"bool"}}],[11,"gt","","",288,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",307,null],[11,"partial_cmp","std::cmp","",4,{"inputs":[{"name":"self"},{"name":"reverse"}],"output":{"name":"option"}}],[11,"lt","","",4,{"inputs":[{"name":"self"},{"name":"reverse"}],"output":{"name":"bool"}}],[11,"le","","",4,{"inputs":[{"name":"self"},{"name":"reverse"}],"output":{"name":"bool"}}],[11,"ge","","",4,{"inputs":[{"name":"self"},{"name":"reverse"}],"output":{"name":"bool"}}],[11,"gt","","",4,{"inputs":[{"name":"self"},{"name":"reverse"}],"output":{"name":"bool"}}],[11,"partial_cmp","std","",293,{"inputs":[{"name":"self"},{"name":"f64"}],"output":{"name":"option"}}],[11,"lt","","",293,{"inputs":[{"name":"self"},{"name":"f64"}],"output":{"name":"bool"}}],[11,"le","","",293,{"inputs":[{"name":"self"},{"name":"f64"}],"output":{"name":"bool"}}],[11,"ge","","",293,{"inputs":[{"name":"self"},{"name":"f64"}],"output":{"name":"bool"}}],[11,"gt","","",293,{"inputs":[{"name":"self"},{"name":"f64"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",307,null],[11,"partial_cmp","","",308,null],[11,"lt","","",308,null],[11,"le","","",308,null],[11,"ge","","",308,null],[11,"gt","","",308,null],[11,"partial_cmp","","",307,null],[11,"partial_cmp","","",307,null],[11,"partial_cmp","","",308,null],[11,"lt","","",308,null],[11,"le","","",308,null],[11,"ge","","",308,null],[11,"gt","","",308,null],[11,"partial_cmp","","",312,{"inputs":[{"name":"self"},{"name":"b"}],"output":{"name":"option"}}],[11,"lt","","",312,{"inputs":[{"name":"self"},{"name":"b"}],"output":{"name":"bool"}}],[11,"le","","",312,{"inputs":[{"name":"self"},{"name":"b"}],"output":{"name":"bool"}}],[11,"ge","","",312,{"inputs":[{"name":"self"},{"name":"b"}],"output":{"name":"bool"}}],[11,"gt","","",312,{"inputs":[{"name":"self"},{"name":"b"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",307,null],[11,"partial_cmp","","",307,null],[11,"partial_cmp","","",308,null],[11,"lt","","",308,null],[11,"le","","",308,null],[11,"ge","","",308,null],[11,"gt","","",308,null],[11,"partial_cmp","","",307,null],[11,"partial_cmp","","",309,null],[11,"partial_cmp","std::mem","",320,{"inputs":[{"name":"self"},{"name":"manuallydrop"}],"output":{"name":"option"}}],[11,"lt","","",320,{"inputs":[{"name":"self"},{"name":"manuallydrop"}],"output":{"name":"bool"}}],[11,"le","","",320,{"inputs":[{"name":"self"},{"name":"manuallydrop"}],"output":{"name":"bool"}}],[11,"gt","","",320,{"inputs":[{"name":"self"},{"name":"manuallydrop"}],"output":{"name":"bool"}}],[11,"ge","","",320,{"inputs":[{"name":"self"},{"name":"manuallydrop"}],"output":{"name":"bool"}}],[11,"partial_cmp","std","",292,{"inputs":[{"name":"self"},{"name":"f32"}],"output":{"name":"option"}}],[11,"lt","","",292,{"inputs":[{"name":"self"},{"name":"f32"}],"output":{"name":"bool"}}],[11,"le","","",292,{"inputs":[{"name":"self"},{"name":"f32"}],"output":{"name":"bool"}}],[11,"ge","","",292,{"inputs":[{"name":"self"},{"name":"f32"}],"output":{"name":"bool"}}],[11,"gt","","",292,{"inputs":[{"name":"self"},{"name":"f32"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",308,null],[11,"lt","","",308,null],[11,"le","","",308,null],[11,"ge","","",308,null],[11,"gt","","",308,null],[11,"partial_cmp","","",308,null],[11,"lt","","",308,null],[11,"le","","",308,null],[11,"ge","","",308,null],[11,"gt","","",308,null],[11,"partial_cmp","","",307,null],[11,"partial_cmp","","",307,null],[11,"partial_cmp","","",313,null],[11,"lt","","",313,null],[11,"le","","",313,null],[11,"ge","","",313,null],[11,"gt","","",313,null],[11,"partial_cmp","","",307,null],[11,"partial_cmp","","",307,null],[11,"partial_cmp","","",307,null],[11,"partial_cmp","std::cell","",318,{"inputs":[{"name":"self"},{"name":"cell"}],"output":{"name":"option"}}],[11,"lt","","",318,{"inputs":[{"name":"self"},{"name":"cell"}],"output":{"name":"bool"}}],[11,"le","","",318,{"inputs":[{"name":"self"},{"name":"cell"}],"output":{"name":"bool"}}],[11,"gt","","",318,{"inputs":[{"name":"self"},{"name":"cell"}],"output":{"name":"bool"}}],[11,"ge","","",318,{"inputs":[{"name":"self"},{"name":"cell"}],"output":{"name":"bool"}}],[11,"partial_cmp","std","",307,null],[11,"partial_cmp","","",317,null],[11,"lt","","",317,null],[11,"le","","",317,null],[11,"gt","","",317,null],[11,"ge","","",317,null],[11,"partial_cmp","","",308,null],[11,"lt","","",308,null],[11,"le","","",308,null],[11,"ge","","",308,null],[11,"gt","","",308,null],[11,"partial_cmp","","",307,null],[11,"partial_cmp","","",307,null],[11,"partial_cmp","","",307,null],[11,"partial_cmp","","",307,null],[11,"partial_cmp","","",308,null],[11,"lt","","",308,null],[11,"le","","",308,null],[11,"ge","","",308,null],[11,"gt","","",308,null],[11,"partial_cmp","","",307,null],[11,"partial_cmp","","",313,null],[11,"partial_cmp","","",308,null],[11,"lt","","",308,null],[11,"le","","",308,null],[11,"ge","","",308,null],[11,"gt","","",308,null],[11,"partial_cmp","","",307,null],[11,"partial_cmp","","",308,null],[11,"lt","","",308,null],[11,"le","","",308,null],[11,"ge","","",308,null],[11,"gt","","",308,null],[11,"partial_cmp","","",313,null],[11,"lt","","",313,null],[11,"le","","",313,null],[11,"ge","","",313,null],[11,"gt","","",313,null],[11,"partial_cmp","","",307,null],[11,"partial_cmp","","",307,null],[11,"partial_cmp","","",307,null],[11,"partial_cmp","","",307,null],[11,"partial_cmp","","",307,null],[11,"partial_cmp","","",307,null],[11,"partial_cmp","","",307,null],[11,"partial_cmp","std::marker","",311,{"inputs":[{"name":"self"},{"name":"phantomdata"}],"output":{"name":"option"}}],[11,"partial_cmp","std","",304,{"inputs":[{"name":"self"},{"name":"i16"}],"output":{"name":"option"}}],[11,"lt","","",304,{"inputs":[{"name":"self"},{"name":"i16"}],"output":{"name":"bool"}}],[11,"le","","",304,{"inputs":[{"name":"self"},{"name":"i16"}],"output":{"name":"bool"}}],[11,"ge","","",304,{"inputs":[{"name":"self"},{"name":"i16"}],"output":{"name":"bool"}}],[11,"gt","","",304,{"inputs":[{"name":"self"},{"name":"i16"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",313,null],[11,"lt","","",313,null],[11,"le","","",313,null],[11,"ge","","",313,null],[11,"gt","","",313,null],[11,"partial_cmp","","",313,null],[11,"lt","","",313,null],[11,"le","","",313,null],[11,"ge","","",313,null],[11,"gt","","",313,null],[11,"partial_cmp","","",308,null],[11,"lt","","",308,null],[11,"le","","",308,null],[11,"ge","","",308,null],[11,"gt","","",308,null],[11,"partial_cmp","","",289,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"option"}}],[11,"lt","","",289,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"bool"}}],[11,"le","","",289,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"bool"}}],[11,"ge","","",289,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"bool"}}],[11,"gt","","",289,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",308,null],[11,"lt","","",308,null],[11,"le","","",308,null],[11,"ge","","",308,null],[11,"gt","","",308,null],[11,"partial_cmp","","",308,null],[11,"lt","","",308,null],[11,"le","","",308,null],[11,"ge","","",308,null],[11,"gt","","",308,null],[11,"partial_cmp","","",313,null],[11,"lt","","",313,null],[11,"le","","",313,null],[11,"ge","","",313,null],[11,"gt","","",313,null],[11,"partial_cmp","","",306,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"lt","","",306,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"bool"}}],[11,"le","","",306,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"bool"}}],[11,"ge","","",306,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"bool"}}],[11,"gt","","",306,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",313,null],[11,"lt","","",313,null],[11,"le","","",313,null],[11,"ge","","",313,null],[11,"gt","","",313,null],[11,"partial_cmp","","",307,null],[11,"partial_cmp","","",308,null],[11,"lt","","",308,null],[11,"le","","",308,null],[11,"ge","","",308,null],[11,"gt","","",308,null],[11,"partial_cmp","","",307,null],[11,"partial_cmp","","",312,{"inputs":[{"name":"self"},{"name":"b"}],"output":{"name":"option"}}],[11,"lt","","",312,{"inputs":[{"name":"self"},{"name":"b"}],"output":{"name":"bool"}}],[11,"le","","",312,{"inputs":[{"name":"self"},{"name":"b"}],"output":{"name":"bool"}}],[11,"ge","","",312,{"inputs":[{"name":"self"},{"name":"b"}],"output":{"name":"bool"}}],[11,"gt","","",312,{"inputs":[{"name":"self"},{"name":"b"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",307,null],[11,"partial_cmp","","",291,{"inputs":[{"name":"self"},{"name":"u128"}],"output":{"name":"option"}}],[11,"lt","","",291,{"inputs":[{"name":"self"},{"name":"u128"}],"output":{"name":"bool"}}],[11,"le","","",291,{"inputs":[{"name":"self"},{"name":"u128"}],"output":{"name":"bool"}}],[11,"ge","","",291,{"inputs":[{"name":"self"},{"name":"u128"}],"output":{"name":"bool"}}],[11,"gt","","",291,{"inputs":[{"name":"self"},{"name":"u128"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",307,null],[11,"partial_cmp","","",307,null],[11,"partial_cmp","","",308,null],[11,"lt","","",308,null],[11,"le","","",308,null],[11,"ge","","",308,null],[11,"gt","","",308,null],[11,"partial_cmp","","",307,null],[11,"partial_cmp","","",290,{"inputs":[{"name":"self"},{"name":"i128"}],"output":{"name":"option"}}],[11,"lt","","",290,{"inputs":[{"name":"self"},{"name":"i128"}],"output":{"name":"bool"}}],[11,"le","","",290,{"inputs":[{"name":"self"},{"name":"i128"}],"output":{"name":"bool"}}],[11,"ge","","",290,{"inputs":[{"name":"self"},{"name":"i128"}],"output":{"name":"bool"}}],[11,"gt","","",290,{"inputs":[{"name":"self"},{"name":"i128"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",307,null],[11,"partial_cmp","","",286,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"option"}}],[11,"lt","","",286,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"bool"}}],[11,"le","","",286,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"bool"}}],[11,"ge","","",286,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"bool"}}],[11,"gt","","",286,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"bool"}}],[11,"partial_cmp","std::any","",323,{"inputs":[{"name":"self"},{"name":"typeid"}],"output":{"name":"option"}}],[11,"lt","","",323,{"inputs":[{"name":"self"},{"name":"typeid"}],"output":{"name":"bool"}}],[11,"le","","",323,{"inputs":[{"name":"self"},{"name":"typeid"}],"output":{"name":"bool"}}],[11,"gt","","",323,{"inputs":[{"name":"self"},{"name":"typeid"}],"output":{"name":"bool"}}],[11,"ge","","",323,{"inputs":[{"name":"self"},{"name":"typeid"}],"output":{"name":"bool"}}],[11,"partial_cmp","std","",307,null],[11,"partial_cmp","","",308,null],[11,"lt","","",308,null],[11,"le","","",308,null],[11,"ge","","",308,null],[11,"gt","","",308,null],[11,"partial_cmp","std::cell","",315,{"inputs":[{"name":"self"},{"name":"refcell"}],"output":{"name":"option"}}],[11,"lt","","",315,{"inputs":[{"name":"self"},{"name":"refcell"}],"output":{"name":"bool"}}],[11,"le","","",315,{"inputs":[{"name":"self"},{"name":"refcell"}],"output":{"name":"bool"}}],[11,"gt","","",315,{"inputs":[{"name":"self"},{"name":"refcell"}],"output":{"name":"bool"}}],[11,"ge","","",315,{"inputs":[{"name":"self"},{"name":"refcell"}],"output":{"name":"bool"}}],[11,"partial_cmp","std","",307,null],[11,"partial_cmp","std::ops","",30,{"inputs":[{"name":"self"},{"name":"generatorstate"}],"output":{"name":"option"}}],[11,"lt","","",30,{"inputs":[{"name":"self"},{"name":"generatorstate"}],"output":{"name":"bool"}}],[11,"le","","",30,{"inputs":[{"name":"self"},{"name":"generatorstate"}],"output":{"name":"bool"}}],[11,"gt","","",30,{"inputs":[{"name":"self"},{"name":"generatorstate"}],"output":{"name":"bool"}}],[11,"ge","","",30,{"inputs":[{"name":"self"},{"name":"generatorstate"}],"output":{"name":"bool"}}],[11,"partial_cmp","std","",307,null],[11,"partial_cmp","","",307,null],[11,"partial_cmp","","",307,null],[11,"partial_cmp","","",308,