var searchIndex = {};
searchIndex["alloc"] = {"doc":"The Rust core allocation and collections library","items":[[0,"allocator","alloc","Use the `alloc` module instead.",null,null],[0,"alloc","","",null,null],[3,"Global","alloc::alloc","",null,null],[5,"oom","","",null,null],[6,"Heap","","",null,null],[17,"Heap","","",null,null],[11,"clone","","",0,{"inputs":[{"name":"self"}],"output":{"name":"global"}}],[11,"default","","",0,{"inputs":[],"output":{"name":"global"}}],[11,"fmt","","",0,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"alloc","","",0,null],[11,"dealloc","","",0,null],[11,"realloc","","",0,null],[11,"alloc_zeroed","","",0,null],[11,"alloc","","",0,{"inputs":[{"name":"self"},{"name":"layout"}],"output":{"generics":["nonnull","allocerr"],"name":"result"}}],[11,"dealloc","","",0,{"inputs":[{"name":"self"},{"generics":["opaque"],"name":"nonnull"},{"name":"layout"}],"output":null}],[11,"realloc","","",0,{"inputs":[{"name":"self"},{"generics":["opaque"],"name":"nonnull"},{"name":"layout"},{"name":"usize"}],"output":{"generics":["nonnull","allocerr"],"name":"result"}}],[11,"alloc_zeroed","","",0,{"inputs":[{"name":"self"},{"name":"layout"}],"output":{"generics":["nonnull","allocerr"],"name":"result"}}],[0,"heap","alloc","Use the `alloc` module instead.",null,null],[0,"boxed","","A pointer type for heap allocation.",null,null],[3,"Box","alloc::boxed","A pointer type for heap allocation.",null,null],[3,"PinBox","","A pinned, heap allocated reference.",null,null],[8,"FnBox","","`FnBox` is a version of the `FnOnce` intended for use with boxed closure objects. The idea is that where one would normally store a `Box<FnOnce()>` in a data structure, you should use `Box<FnBox()>`. The two traits behave essentially the same, except that a `FnBox` closure can only be called if it is boxed. (Note that `FnBox` may be deprecated in the future if `Box<FnOnce()>` closures become directly usable.)",null,null],[16,"Output","","",1,null],[10,"call_box","","",1,null],[11,"new","","Allocates memory on the heap and then places `x` into it.",2,{"inputs":[{"name":"t"}],"output":{"name":"box"}}],[11,"from_raw","","Constructs a box from a raw pointer.",2,null],[11,"into_raw","","Consumes the `Box`, returning the wrapped raw pointer.",2,null],[11,"into_raw_non_null","","Consumes the `Box`, returning the wrapped pointer as `NonNull<T>`.",2,{"inputs":[{"name":"box"}],"output":{"name":"nonnull"}}],[11,"leak","","Consumes and leaks the `Box`, returning a mutable reference, `&'a mut T`. Here, the lifetime `'a` may be chosen to be `'static`.",2,{"inputs":[{"name":"box"}],"output":{"name":"t"}}],[11,"drop","","",2,{"inputs":[{"name":"self"}],"output":null}],[11,"default","","Creates a `Box<T>`, with the `Default` value for T.",2,{"inputs":[],"output":{"name":"box"}}],[11,"default","","",2,{"inputs":[],"output":{"name":"box"}}],[11,"default","","",2,{"inputs":[],"output":{"generics":["str"],"name":"box"}}],[11,"clone","","Returns a new box with a `clone()` of this box's contents.",2,{"inputs":[{"name":"self"}],"output":{"name":"box"}}],[11,"clone_from","","Copies `source`'s contents into `self` without creating a new allocation.",2,{"inputs":[{"name":"self"},{"name":"box"}],"output":null}],[11,"clone","","",2,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"eq","","",2,{"inputs":[{"name":"self"},{"name":"box"}],"output":{"name":"bool"}}],[11,"ne","","",2,{"inputs":[{"name":"self"},{"name":"box"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",2,{"inputs":[{"name":"self"},{"name":"box"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",2,{"inputs":[{"name":"self"},{"name":"box"}],"output":{"name":"bool"}}],[11,"le","","",2,{"inputs":[{"name":"self"},{"name":"box"}],"output":{"name":"bool"}}],[11,"ge","","",2,{"inputs":[{"name":"self"},{"name":"box"}],"output":{"name":"bool"}}],[11,"gt","","",2,{"inputs":[{"name":"self"},{"name":"box"}],"output":{"name":"bool"}}],[11,"cmp","","",2,{"inputs":[{"name":"self"},{"name":"box"}],"output":{"name":"ordering"}}],[11,"hash","","",2,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"finish","","",2,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"write","","",2,null],[11,"write_u8","","",2,{"inputs":[{"name":"self"},{"name":"u8"}],"output":null}],[11,"write_u16","","",2,{"inputs":[{"name":"self"},{"name":"u16"}],"output":null}],[11,"write_u32","","",2,{"inputs":[{"name":"self"},{"name":"u32"}],"output":null}],[11,"write_u64","","",2,{"inputs":[{"name":"self"},{"name":"u64"}],"output":null}],[11,"write_u128","","",2,{"inputs":[{"name":"self"},{"name":"u128"}],"output":null}],[11,"write_usize","","",2,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"write_i8","","",2,{"inputs":[{"name":"self"},{"name":"i8"}],"output":null}],[11,"write_i16","","",2,{"inputs":[{"name":"self"},{"name":"i16"}],"output":null}],[11,"write_i32","","",2,{"inputs":[{"name":"self"},{"name":"i32"}],"output":null}],[11,"write_i64","","",2,{"inputs":[{"name":"self"},{"name":"i64"}],"output":null}],[11,"write_i128","","",2,{"inputs":[{"name":"self"},{"name":"i128"}],"output":null}],[11,"write_isize","","",2,{"inputs":[{"name":"self"},{"name":"isize"}],"output":null}],[11,"from","","",2,{"inputs":[{"name":"t"}],"output":{"name":"self"}}],[11,"from","","",2,null],[11,"from","","",2,{"inputs":[{"name":"str"}],"output":{"generics":["str"],"name":"box"}}],[11,"from","","",2,{"inputs":[{"generics":["str"],"name":"box"}],"output":{"name":"self"}}],[11,"downcast","","Attempt to downcast the box to a concrete type.",2,{"inputs":[{"name":"self"}],"output":{"generics":["box","box"],"name":"result"}}],[11,"downcast","","Attempt to downcast the box to a concrete type.",2,{"inputs":[{"name":"self"}],"output":{"generics":["box","box"],"name":"result"}}],[11,"fmt","","",2,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",2,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",2,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"deref","","",2,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"deref_mut","","",2,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"next","","",2,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",2,null],[11,"nth","","",2,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"next_back","","",2,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"len","","",2,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","",2,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"call_once","","",2,{"inputs":[{"name":"self"},{"name":"a"}],"output":{"name":"r"}}],[11,"call_once","","",2,{"inputs":[{"name":"self"},{"name":"a"}],"output":{"name":"r"}}],[11,"clone","","",2,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"borrow","","",2,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"borrow_mut","","",2,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"as_ref","","",2,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"as_mut","","",2,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"resume","","",2,{"inputs":[{"name":"self"}],"output":{"name":"generatorstate"}}],[11,"new","","Allocate memory on the heap, move the data into it and pin it.",3,{"inputs":[{"name":"t"}],"output":{"name":"pinbox"}}],[11,"as_pin","","Get a pinned reference to the data in this PinBox.",3,{"inputs":[{"name":"self"}],"output":{"name":"pin"}}],[11,"get_mut","","Get a mutable reference to the data inside this PinBox.",3,{"inputs":[{"name":"pinbox"}],"output":{"name":"t"}}],[11,"unpin","","Convert this PinBox into an unpinned Box.",3,{"inputs":[{"name":"pinbox"}],"output":{"name":"box"}}],[11,"from","","",3,{"inputs":[{"name":"box"}],"output":{"name":"pinbox"}}],[11,"from","","",2,{"inputs":[{"name":"pinbox"}],"output":{"name":"box"}}],[11,"deref","","",3,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"deref_mut","","",3,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"fmt","","",3,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",3,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",3,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[0,"arc","alloc","Thread-safe reference-counting pointers.",null,null],[3,"Arc","alloc::arc","A thread-safe reference-counting pointer. 'Arc' stands for 'Atomically Reference Counted'.",null,null],[3,"Weak","","`Weak` is a version of [`Arc`] that holds a non-owning reference to the managed value. The value is accessed by calling [`upgrade`] on the `Weak` pointer, which returns an [`Option`]`<`[`Arc`]`<T>>`.",null,null],[11,"fmt","","",4,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Constructs a new `Arc<T>`.",5,{"inputs":[{"name":"t"}],"output":{"name":"arc"}}],[11,"try_unwrap","","Returns the contained value, if the `Arc` has exactly one strong reference.",5,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"into_raw","","Consumes the `Arc`, returning the wrapped pointer.",5,null],[11,"from_raw","","Constructs an `Arc` from a raw pointer.",5,null],[11,"downgrade","","Creates a new [`Weak`][weak] pointer to this value.",5,{"inputs":[{"name":"self"}],"output":{"name":"weak"}}],[11,"weak_count","","Gets the number of [`Weak`][weak] pointers to this value.",5,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"strong_count","","Gets the number of strong (`Arc`) pointers to this value.",5,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"ptr_eq","","Returns true if the two `Arc`s point to the same value (not just values that compare as equal).",5,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","Makes a clone of the `Arc` pointer.",5,{"inputs":[{"name":"self"}],"output":{"name":"arc"}}],[11,"deref","","",5,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"make_mut","","Makes a mutable reference into the given `Arc`.",5,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"get_mut","","Returns a mutable reference to the inner value, if there are no other `Arc` or [`Weak`][weak] pointers to the same value.",5,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"drop","","Drops the `Arc`.",5,{"inputs":[{"name":"self"}],"output":null}],[11,"new","","Constructs a new `Weak<T>`, allocating memory for `T` without initializing it. Calling [`upgrade`] on the return value always gives [`None`].",4,{"inputs":[],"output":{"name":"weak"}}],[11,"upgrade","","Attempts to upgrade the `Weak` pointer to an [`Arc`], extending the lifetime of the value if successful.",4,{"inputs":[{"name":"self"}],"output":{"generics":["arc"],"name":"option"}}],[11,"clone","","Makes a clone of the `Weak` pointer that points to the same value.",4,{"inputs":[{"name":"self"}],"output":{"name":"weak"}}],[11,"default","","Constructs a new `Weak<T>`, allocating memory for `T` without initializing it. Calling [`upgrade`] on the return value always gives [`None`].",4,{"inputs":[],"output":{"name":"weak"}}],[11,"drop","","Drops the `Weak` pointer.",4,{"inputs":[{"name":"self"}],"output":null}],[11,"eq","","Equality for two `Arc`s.",5,{"inputs":[{"name":"self"},{"name":"arc"}],"output":{"name":"bool"}}],[11,"ne","","Inequality for two `Arc`s.",5,{"inputs":[{"name":"self"},{"name":"arc"}],"output":{"name":"bool"}}],[11,"partial_cmp","","Partial comparison for two `Arc`s.",5,{"inputs":[{"name":"self"},{"name":"arc"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","Less-than comparison for two `Arc`s.",5,{"inputs":[{"name":"self"},{"name":"arc"}],"output":{"name":"bool"}}],[11,"le","","'Less than or equal to' comparison for two `Arc`s.",5,{"inputs":[{"name":"self"},{"name":"arc"}],"output":{"name":"bool"}}],[11,"gt","","Greater-than comparison for two `Arc`s.",5,{"inputs":[{"name":"self"},{"name":"arc"}],"output":{"name":"bool"}}],[11,"ge","","'Greater than or equal to' comparison for two `Arc`s.",5,{"inputs":[{"name":"self"},{"name":"arc"}],"output":{"name":"bool"}}],[11,"cmp","","Comparison for two `Arc`s.",5,{"inputs":[{"name":"self"},{"name":"arc"}],"output":{"name":"ordering"}}],[11,"fmt","","",5,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",5,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",5,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"default","","Creates a new `Arc<T>`, with the `Default` value for `T`.",5,{"inputs":[],"output":{"name":"arc"}}],[11,"hash","","",5,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"from","","",5,{"inputs":[{"name":"t"}],"output":{"name":"self"}}],[11,"from","","",5,null],[11,"from","","",5,{"inputs":[{"name":"str"}],"output":{"generics":["str"],"name":"arc"}}],[11,"from","","",5,{"inputs":[{"name":"string"}],"output":{"generics":["str"],"name":"arc"}}],[11,"from","","",5,{"inputs":[{"name":"box"}],"output":{"name":"arc"}}],[11,"from","","",5,{"inputs":[{"name":"vec"}],"output":{"name":"arc"}}],[11,"borrow","","",5,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"as_ref","","",5,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[0,"rc","alloc","Single-threaded reference-counting pointers. 'Rc' stands for 'Reference Counted'.",null,null],[3,"Rc","alloc::rc","A single-threaded reference-counting pointer. 'Rc' stands for 'Reference Counted'.",null,null],[3,"Weak","","`Weak` is a version of [`Rc`] that holds a non-owning reference to the managed value. The value is accessed by calling [`upgrade`] on the `Weak` pointer, which returns an [`Option`]`<`[`Rc`]`<T>>`.",null,null],[11,"new","","Constructs a new `Rc<T>`.",6,{"inputs":[{"name":"t"}],"output":{"name":"rc"}}],[11,"try_unwrap","","Returns the contained value, if the `Rc` has exactly one strong reference.",6,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"into_raw","","Consumes the `Rc`, returning the wrapped pointer.",6,null],[11,"from_raw","","Constructs an `Rc` from a raw pointer.",6,null],[11,"downgrade","","Creates a new [`Weak`][weak] pointer to this value.",6,{"inputs":[{"name":"self"}],"output":{"name":"weak"}}],[11,"weak_count","","Gets the number of [`Weak`][weak] pointers to this value.",6,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"strong_count","","Gets the number of strong (`Rc`) pointers to this value.",6,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"get_mut","","Returns a mutable reference to the inner value, if there are no other `Rc` or [`Weak`][weak] pointers to the same value.",6,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"ptr_eq","","Returns true if the two `Rc`s point to the same value (not just values that compare as equal).",6,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"bool"}}],[11,"make_mut","","Makes a mutable reference into the given `Rc`.",6,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"downcast","","Attempt to downcast the `Rc<Any>` to a concrete type.",6,{"inputs":[{"name":"self"}],"output":{"generics":["rc","rc"],"name":"result"}}],[11,"deref","","",6,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"drop","","Drops the `Rc`.",6,{"inputs":[{"name":"self"}],"output":null}],[11,"clone","","Makes a clone of the `Rc` pointer.",6,{"inputs":[{"name":"self"}],"output":{"name":"rc"}}],[11,"default","","Creates a new `Rc<T>`, with the `Default` value for `T`.",6,{"inputs":[],"output":{"name":"rc"}}],[11,"eq","","Equality for two `Rc`s.",6,{"inputs":[{"name":"self"},{"name":"rc"}],"output":{"name":"bool"}}],[11,"ne","","Inequality for two `Rc`s.",6,{"inputs":[{"name":"self"},{"name":"rc"}],"output":{"name":"bool"}}],[11,"partial_cmp","","Partial comparison for two `Rc`s.",6,{"inputs":[{"name":"self"},{"name":"rc"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","Less-than comparison for two `Rc`s.",6,{"inputs":[{"name":"self"},{"name":"rc"}],"output":{"name":"bool"}}],[11,"le","","'Less than or equal to' comparison for two `Rc`s.",6,{"inputs":[{"name":"self"},{"name":"rc"}],"output":{"name":"bool"}}],[11,"gt","","Greater-than comparison for two `Rc`s.",6,{"inputs":[{"name":"self"},{"name":"rc"}],"output":{"name":"bool"}}],[11,"ge","","'Greater than or equal to' comparison for two `Rc`s.",6,{"inputs":[{"name":"self"},{"name":"rc"}],"output":{"name":"bool"}}],[11,"cmp","","Comparison for two `Rc`s.",6,{"inputs":[{"name":"self"},{"name":"rc"}],"output":{"name":"ordering"}}],[11,"hash","","",6,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"fmt","","",6,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",6,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",6,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"from","","",6,{"inputs":[{"name":"t"}],"output":{"name":"self"}}],[11,"from","","",6,null],[11,"from","","",6,{"inputs":[{"name":"str"}],"output":{"generics":["str"],"name":"rc"}}],[11,"from","","",6,{"inputs":[{"name":"string"}],"output":{"generics":["str"],"name":"rc"}}],[11,"from","","",6,{"inputs":[{"name":"box"}],"output":{"name":"rc"}}],[11,"from","","",6,{"inputs":[{"name":"vec"}],"output":{"name":"rc"}}],[11,"new","","Constructs a new `Weak<T>`, allocating memory for `T` without initializing it. Calling [`upgrade`] on the return value always gives [`None`].",7,{"inputs":[],"output":{"name":"weak"}}],[11,"upgrade","","Attempts to upgrade the `Weak` pointer to an [`Rc`], extending the lifetime of the value if successful.",7,{"inputs":[{"name":"self"}],"output":{"generics":["rc"],"name":"option"}}],[11,"drop","","Drops the `Weak` pointer.",7,{"inputs":[{"name":"self"}],"output":null}],[11,"clone","","Makes a clone of the `Weak` pointer that points to the same value.",7,{"inputs":[{"name":"self"}],"output":{"name":"weak"}}],[11,"fmt","","",7,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"default","","Constructs a new `Weak<T>`, allocating memory for `T` without initializing it. Calling [`upgrade`] on the return value always gives [`None`].",7,{"inputs":[],"output":{"name":"weak"}}],[11,"borrow","","",6,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"as_ref","","",6,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[0,"raw_vec","alloc","",null,null],[3,"RawVec","alloc::raw_vec","A low-level utility for more ergonomically allocating, reallocating, and deallocating a buffer of memory on the heap without having to worry about all the corner cases involved. This type is excellent for building your own data structures like Vec and VecDeque. In particular:",null,null],[11,"new_in","","Like `new` but parameterized over the choice of allocator for the returned RawVec.",8,{"inputs":[{"name":"a"}],"output":{"name":"self"}}],[11,"with_capacity_in","","Like `with_capacity` but parameterized over the choice of allocator for the returned RawVec.",8,{"inputs":[{"name":"usize"},{"name":"a"}],"output":{"name":"self"}}],[11,"with_capacity_zeroed_in","","Like `with_capacity_zeroed` but parameterized over the choice of allocator for the returned RawVec.",8,{"inputs":[{"name":"usize"},{"name":"a"}],"output":{"name":"self"}}],[11,"new","","Creates the biggest possible RawVec (on the system heap) without allocating. If T has positive size, then this makes a RawVec with capacity 0. If T has 0 size, then it makes a RawVec with capacity `usize::MAX`. Useful for implementing delayed allocation.",8,{"inputs":[],"output":{"name":"self"}}],[11,"with_capacity","","Creates a RawVec (on the system heap) with exactly the capacity and alignment requirements for a `[T; cap]`. This is equivalent to calling RawVec::new when `cap` is 0 or T is zero-sized. Note that if `T` is zero-sized this means you will not get a RawVec with the requested capacity!",8,{"inputs":[{"name":"usize"}],"output":{"name":"self"}}],[11,"with_capacity_zeroed","","Like `with_capacity` but guarantees the buffer is zeroed.",8,{"inputs":[{"name":"usize"}],"output":{"name":"self"}}],[11,"from_raw_parts_in","","Reconstitutes a RawVec from a pointer, capacity, and allocator.",8,null],[11,"from_raw_parts","","Reconstitutes a RawVec from a pointer, capacity.",8,null],[11,"from_box","","Converts a `Box<[T]>` into a `RawVec<T>`.",8,{"inputs":[{"name":"box"}],"output":{"name":"self"}}],[11,"ptr","","Gets a raw pointer to the start of the allocation. Note that this is Unique::empty() if `cap = 0` or T is zero-sized. In the former case, you must be careful.",8,null],[11,"cap","","Gets the capacity of the allocation.",8,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"alloc","","Returns a shared reference to the allocator backing this RawVec.",8,{"inputs":[{"name":"self"}],"output":{"name":"a"}}],[11,"alloc_mut","","Returns a mutable reference to the allocator backing this RawVec.",8,{"inputs":[{"name":"self"}],"output":{"name":"a"}}],[11,"double","","Doubles the size of the type's backing allocation. This is common enough to want to do that it's easiest to just have a dedicated method. Slightly more efficient logic can be provided for this than the general case.",8,{"inputs":[{"name":"self"}],"output":null}],[11,"double_in_place","","Attempts to double the size of the type's backing allocation in place. This is common enough to want to do that it's easiest to just have a dedicated method. Slightly more efficient logic can be provided for this than the general case.",8,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"try_reserve_exact","","Ensures that the buffer contains at least enough space to hold `used_cap + needed_extra_cap` elements. If it doesn't already, will reallocate the minimum possible amount of memory necessary. Generally this will be exactly the amount of memory necessary, but in principle the allocator is free to give back more than we asked for.",8,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"usize"}],"output":{"generics":["collectionallocerr"],"name":"result"}}],[11,"reserve_exact","","",8,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"usize"}],"output":null}],[11,"try_reserve","","Ensures that the buffer contains at least enough space to hold `used_cap + needed_extra_cap` elements. If it doesn't already have enough capacity, will reallocate enough space plus comfortable slack space to get amortized `O(1)` behavior. Will limit this behavior if it would needlessly cause itself to panic.",8,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"usize"}],"output":{"generics":["collectionallocerr"],"name":"result"}}],[11,"reserve","","The same as try_reserve, but errors are lowered to a call to oom().",8,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"usize"}],"output":null}],[11,"reserve_in_place","","Attempts to ensure that the buffer contains at least enough space to hold `used_cap + needed_extra_cap` elements. If it doesn't already have enough capacity, will reallocate in place enough space plus comfortable slack space to get amortized `O(1)` behavior. Will limit this behaviour if it would needlessly cause itself to panic.",8,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"usize"}],"output":{"name":"bool"}}],[11,"shrink_to_fit","","Shrinks the allocation down to the specified amount. If the given amount is 0, actually completely deallocates.",8,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"into_box","","Converts the entire buffer into `Box<[T]>`.",8,{"inputs":[{"name":"self"}],"output":{"name":"box"}}],[11,"dealloc_buffer","","Frees the memory owned by the RawVec without trying to Drop its contents.",8,{"inputs":[{"name":"self"}],"output":null}],[11,"drop","","Frees the memory owned by the RawVec without trying to Drop its contents.",8,{"inputs":[{"name":"self"}],"output":null}],[0,"binary_heap","alloc","A priority queue implemented with a binary heap.",null,null],[3,"BinaryHeap","alloc::binary_heap","A priority queue implemented with a binary heap.",null,null],[3,"PeekMut","","Structure wrapping a mutable reference to the greatest item on a `BinaryHeap`.",null,null],[3,"Iter","","An iterator over the elements of a `BinaryHeap`.",null,null],[3,"IntoIter","","An owning iterator over the elements of a `BinaryHeap`.",null,null],[3,"Drain","","A draining iterator over the elements of a `BinaryHeap`.",null,null],[11,"fmt","","",9,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"drop","","",9,{"inputs":[{"name":"self"}],"output":null}],[11,"deref","","",9,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"deref_mut","","",9,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"pop","","Removes the peeked value from the heap and returns it.",9,{"inputs":[{"name":"peekmut"}],"output":{"name":"t"}}],[11,"clone","","",10,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"clone_from","","",10,{"inputs":[{"name":"self"},{"name":"self"}],"output":null}],[11,"default","","Creates an empty `BinaryHeap<T>`.",10,{"inputs":[],"output":{"name":"binaryheap"}}],[11,"fmt","","",10,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates an empty `BinaryHeap` as a max-heap.",10,{"inputs":[],"output":{"name":"binaryheap"}}],[11,"with_capacity","","Creates an empty `BinaryHeap` with a specific capacity. This preallocates enough memory for `capacity` elements, so that the `BinaryHeap` does not have to be reallocated until it contains at least that many values.",10,{"inputs":[{"name":"usize"}],"output":{"name":"binaryheap"}}],[11,"iter","","Returns an iterator visiting all values in the underlying vector, in arbitrary order.",10,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"peek","","Returns the greatest item in the binary heap, or `None` if it is empty.",10,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"peek_mut","","Returns a mutable reference to the greatest item in the binary heap, or `None` if it is empty.",10,{"inputs":[{"name":"self"}],"output":{"generics":["peekmut"],"name":"option"}}],[11,"capacity","","Returns the number of elements the binary heap can hold without reallocating.",10,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"reserve_exact","","Reserves the minimum capacity for exactly `additional` more elements to be inserted in the given `BinaryHeap`. Does nothing if the capacity is already sufficient.",10,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"reserve","","Reserves capacity for at least `additional` more elements to be inserted in the `BinaryHeap`. The collection may reserve more space to avoid frequent reallocations.",10,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shrink_to_fit","","Discards as much additional capacity as possible.",10,{"inputs":[{"name":"self"}],"output":null}],[11,"shrink_to","","Discards capacity with a lower bound.",10,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"pop","","Removes the greatest item from the binary heap and returns it, or `None` if it is empty.",10,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"push","","Pushes an item onto the binary heap.",10,{"inputs":[{"name":"self"},{"name":"t"}],"output":null}],[11,"into_vec","","Consumes the `BinaryHeap` and returns the underlying vector in arbitrary order.",10,{"inputs":[{"name":"self"}],"output":{"name":"vec"}}],[11,"into_sorted_vec","","Consumes the `BinaryHeap` and returns a vector in sorted (ascending) order.",10,{"inputs":[{"name":"self"}],"output":{"name":"vec"}}],[11,"len","","Returns the length of the binary heap.",10,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","Checks if the binary heap is empty.",10,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"drain","","Clears the binary heap, returning an iterator over the removed elements.",10,{"inputs":[{"name":"self"}],"output":{"name":"drain"}}],[11,"clear","","Drops all items from the binary heap.",10,{"inputs":[{"name":"self"}],"output":null}],[11,"append","","Moves all the elements of `other` into `self`, leaving `other` empty.",10,{"inputs":[{"name":"self"},{"name":"self"}],"output":null}],[11,"fmt","","",11,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",11,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"next","","",11,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",11,null],[11,"next_back","","",11,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"is_empty","","",11,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",12,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"fmt","","",12,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",12,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",12,null],[11,"next_back","","",12,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"is_empty","","",12,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"fmt","","",13,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",13,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",13,null],[11,"next_back","","",13,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"is_empty","","",13,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"from","","",10,{"inputs":[{"name":"vec"}],"output":{"name":"binaryheap"}}],[11,"from_iter","","",10,{"inputs":[{"name":"i"}],"output":{"name":"binaryheap"}}],[11,"into_iter","","Creates a consuming iterator, that is, one that moves each value out of the binary heap in arbitrary order. The binary heap cannot be used after calling this.",10,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"extend","","",10,{"inputs":[{"name":"self"},{"name":"i"}],"output":null}],[11,"extend","","",10,{"inputs":[{"name":"self"},{"name":"i"}],"output":null}],[0,"borrow","alloc","A module for working with borrowed data.",null,null],[8,"Borrow","alloc::borrow","A trait for borrowing data.",null,null],[10,"borrow","","Immutably borrows from an owned value.",14,{"inputs":[{"name":"self"}],"output":{"name":"borrowed"}}],[8,"BorrowMut","","A trait for mutably borrowing data.",null,null],[10,"borrow_mut","","Mutably borrows from an owned value.",15,{"inputs":[{"name":"self"}],"output":{"name":"borrowed"}}],[4,"Cow","","A clone-on-write smart pointer.",null,null],[13,"Borrowed","","Borrowed data.",16,null],[13,"Owned","","Owned data.",16,null],[8,"ToOwned","","A generalization of `Clone` to borrowed data.",null,null],[16,"Owned","","",17,null],[10,"to_owned","","Creates owned data from borrowed data, usually by cloning.",17,null],[11,"clone_into","","Uses borrowed data to replace owned data, usually by cloning.",17,null],[11,"borrow","","",16,{"inputs":[{"name":"self"}],"output":{"name":"b"}}],[11,"clone","","",16,{"inputs":[{"name":"self"}],"output":{"name":"cow"}}],[11,"clone_from","","",16,{"inputs":[{"name":"self"},{"name":"cow"}],"output":null}],[11,"to_mut","","Acquires a mutable reference to the owned form of the data.",16,null],[11,"into_owned","","Extracts the owned data.",16,null],[11,"deref","","",16,{"inputs":[{"name":"self"}],"output":{"name":"b"}}],[11,"cmp","","",16,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"ordering"}}],[11,"eq","","",16,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",16,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"fmt","","",16,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",16,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"default","","Creates an owned Cow<'a, B> with the default value for the contained owned value.",16,{"inputs":[],"output":{"name":"cow"}}],[11,"hash","","",16,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"as_ref","","",16,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"add","","",16,null],[11,"add","","",16,null],[11,"add_assign","","",16,{"inputs":[{"name":"self"},{"name":"str"}],"output":null}],[11,"add_assign","","",16,{"inputs":[{"name":"self"},{"generics":["str"],"name":"cow"}],"output":null}],[0,"fmt","alloc","Utilities for formatting and printing `String`s.",null,null],[3,"Formatter","alloc::fmt","A struct to represent both where to emit formatting strings to and how they should be formatted. A mutable version of this is passed to all formatting traits.",null,null],[6,"Result","","The type returned by formatter methods.",null,null],[8,"Write","","A collection of methods that are required to format a message into a stream.",null,null],[10,"write_str","","Writes a slice of bytes into this writer, returning whether the write succeeded.",18,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"generics":["error"],"name":"result"}}],[11,"write_char","","Writes a [`char`] into this writer, returning whether the write succeeded.",18,{"inputs":[{"name":"self"},{"name":"char"}],"output":{"generics":["error"],"name":"result"}}],[11,"write_fmt","","Glue for usage of the [`write!`] macro with implementors of this trait.",18,{"inputs":[{"name":"self"},{"name":"arguments"}],"output":{"generics":["error"],"name":"result"}}],[8,"Binary","","`b` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",19,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"generics":["error"],"name":"result"}}],[8,"Octal","","`o` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",20,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"generics":["error"],"name":"result"}}],[8,"Debug","","`?` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",21,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"generics":["error"],"name":"result"}}],[8,"Display","","Format trait for an empty format, `{}`.",null,null],[10,"fmt","","Formats the value using the given formatter.",22,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"generics":["error"],"name":"result"}}],[8,"LowerHex","","`x` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",23,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"generics":["error"],"name":"result"}}],[8,"Pointer","","`p` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",24,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"generics":["error"],"name":"result"}}],[8,"UpperHex","","`X` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",25,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"generics":["error"],"name":"result"}}],[8,"LowerExp","","`e` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",26,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"generics":["error"],"name":"result"}}],[8,"UpperExp","","`E` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",27,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"generics":["error"],"name":"result"}}],[3,"Error","","The error type which is returned from formatting a message into a stream.",null,null],[5,"write","","The `write` function takes an output stream, and an `Arguments` struct that can be precompiled with the `format_args!` macro.",null,{"inputs":[{"name":"write"},{"name":"arguments"}],"output":{"generics":["error"],"name":"result"}}],[3,"Arguments","","This structure represents a safely precompiled version of a format string and its arguments. This cannot be generated at runtime because it cannot safely be done, so no constructors are given and the fields are private to prevent modification.",null,null],[3,"DebugList","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugMap","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugSet","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugStruct","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugTuple","","A struct to help with `fmt::Debug` implementations.",null,null],[5,"format","","The `format` function takes an [`Arguments`] struct and returns the resulting formatted string.",null,{"inputs":[{"name":"arguments"}],"output":{"name":"string"}}],[0,"linked_list","alloc","A doubly-linked list with owned nodes.",null,null],[3,"LinkedList","alloc::linked_list","A doubly-linked list with owned nodes.",null,null],[3,"Iter","","An iterator over the elements of a `LinkedList`.",null,null],[3,"IterMut","","A mutable iterator over the elements of a `LinkedList`.",null,null],[3,"IntoIter","","An owning iterator over the elements of a `LinkedList`.",null,null],[3,"DrainFilter","","An iterator produced by calling `drain_filter` on LinkedList.",null,null],[11,"fmt","","",28,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",28,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"fmt","","",29,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",30,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"fmt","","",30,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"default","","Creates an empty `LinkedList<T>`.",31,{"inputs":[],"output":{"name":"self"}}],[11,"new","","Creates an empty `LinkedList`.",31,{"inputs":[],"output":{"name":"self"}}],[11,"append","","Moves all elements from `other` to the end of the list.",31,{"inputs":[{"name":"self"},{"name":"self"}],"output":null}],[11,"iter","","Provides a forward iterator.",31,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"iter_mut","","Provides a forward iterator with mutable references.",31,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"is_empty","","Returns `true` if the `LinkedList` is empty.",31,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"len","","Returns the length of the `LinkedList`.",31,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"clear","","Removes all elements from the `LinkedList`.",31,{"inputs":[{"name":"self"}],"output":null}],[11,"contains","","Returns `true` if the `LinkedList` contains an element equal to the given value.",31,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"bool"}}],[11,"front","","Provides a reference to the front element, or `None` if the list is empty.",31,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"front_mut","","Provides a mutable reference to the front element, or `None` if the list is empty.",31,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"back","","Provides a reference to the back element, or `None` if the list is empty.",31,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"back_mut","","Provides a mutable reference to the back element, or `None` if the list is empty.",31,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"push_front","","Adds an element first in the list.",31,{"inputs":[{"name":"self"},{"name":"t"}],"output":null}],[11,"pop_front","","Removes the first element and returns it, or `None` if the list is empty.",31,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"push_back","","Appends an element to the back of a list",31,{"inputs":[{"name":"self"},{"name":"t"}],"output":null}],[11,"pop_back","","Removes the last element from a list and returns it, or `None` if it is empty.",31,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"split_off","","Splits the list into two at the given index. Returns everything after the given index, including the index.",31,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"linkedlist"}}],[11,"drain_filter","","Creates an iterator which uses a closure to determine if an element should be removed.",31,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"drainfilter"}}],[11,"drop","","",31,{"inputs":[{"name":"self"}],"output":null}],[11,"next","","",28,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",28,null],[11,"next_back","","",28,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",29,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",29,null],[11,"next_back","","",29,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"insert_next","","Inserts the given element just after the element most recently returned by `.next()`. The inserted element does not appear in the iteration.",29,{"inputs":[{"name":"self"},{"name":"t"}],"output":null}],[11,"peek_next","","Provides a reference to the next element, without changing the iterator.",29,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",32,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",32,null],[11,"drop","","",32,{"inputs":[{"name":"self"}],"output":null}],[11,"fmt","","",32,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",30,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",30,null],[11,"next_back","","",30,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"from_iter","","",31,{"inputs":[{"name":"i"}],"output":{"name":"self"}}],[11,"into_iter","","Consumes the list into an iterator yielding elements by value.",31,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"extend","","",31,{"inputs":[{"name":"self"},{"name":"i"}],"output":null}],[11,"extend","","",31,{"inputs":[{"name":"self"},{"name":"i"}],"output":null}],[11,"eq","","",31,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"bool"}}],[11,"ne","","",31,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",31,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"cmp","","",31,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"ordering"}}],[11,"clone","","",31,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"fmt","","",31,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",31,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[0,"slice","alloc","A dynamically-sized view into a contiguous sequence, `[T]`.",null,null],[3,"Chunks","alloc::slice","An iterator over a slice in (non-overlapping) chunks (`chunk_size` elements at a time).",null,null],[3,"Windows","","An iterator over overlapping subslices of length `size`.",null,null],[3,"Iter","","Immutable slice iterator",null,null],[3,"IterMut","","Mutable slice iterator.",null,null],[3,"SplitMut","","An iterator over the subslices of the vector which are separated by elements that match `pred`.",null,null],[3,"ChunksMut","","An iterator over a slice in (non-overlapping) mutable chunks (`chunk_size` elements at a time). When the slice len is not evenly divided by the chunk size, the last slice of the iteration will be the remainder.",null,null],[3,"Split","","An iterator over subslices separated by elements that match a predicate function.",null,null],[3,"SplitN","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits.",null,null],[3,"RSplitN","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits, starting from the end of the slice.",null,null],[3,"SplitNMut","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits.",null,null],[3,"RSplitNMut","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits, starting from the end of the slice.",null,null],[3,"RSplit","","An iterator over subslices separated by elements that match a predicate function, starting from the end of the slice.",null,null],[3,"RSplitMut","","An iterator over the subslices of the vector which are separated by elements that match `pred`, starting from the end of the slice.",null,null],[5,"from_raw_parts","","Forms a slice from a pointer and a length.",null,null],[5,"from_raw_parts_mut","","Performs the same functionality as `from_raw_parts`, except that a mutable slice is returned.",null,null],[5,"from_ref","","Converts a reference to T into a slice of length 1 (without copying).",null,null],[5,"from_ref_mut","","Converts a reference to T into a slice of length 1 (without copying).",null,null],[8,"SliceIndex","","A helper trait used for indexing operations.",null,null],[16,"Output","","The output type returned by methods.",33,null],[10,"get","","Returns a shared reference to the output at this location, if in bounds.",33,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"option"}}],[10,"get_mut","","Returns a mutable reference to the output at this location, if in bounds.",33,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"option"}}],[10,"get_unchecked","","Returns a shared reference to the output at this location, without performing any bounds checking.",33,null],[10,"get_unchecked_mut","","Returns a mutable reference to the output at this location, without performing any bounds checking.",33,null],[10,"index","","Returns a shared reference to the output at this location, panicking if out of bounds.",33,null],[10,"index_mut","","Returns a mutable reference to the output at this location, panicking if out of bounds.",33,null],[3,"ExactChunks","","An iterator over a slice in (non-overlapping) chunks (`chunk_size` elements at a time).",null,null],[3,"ExactChunksMut","","An iterator over a slice in (non-overlapping) mutable chunks (`chunk_size` elements at a time). When the slice len is not evenly divided by the chunk size, the last up to `chunk_size-1` elements will be omitted.",null,null],[8,"SliceConcatExt","","An extension trait for concatenating slices",null,null],[16,"Output","","The resulting type after concatenation",34,null],[10,"concat","","Flattens a slice of `T` into a single value `Self::Output`.",34,null],[10,"join","","Flattens a slice of `T` into a single value `Self::Output`, placing a given separator between each.",34,null],[10,"connect","","",34,null],[0,"str","alloc","Unicode string slices.",null,null],[8,"FromStr","alloc::str","A trait to abstract the idea of creating a new instance of a type from a string.",null,null],[16,"Err","","The associated error which can be returned from parsing.",35,null],[10,"from_str","","Parses a string `s` to return a value of this type.",35,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[3,"Utf8Error","","Errors which can occur when attempting to interpret a sequence of [`u8`] as a string.",null,null],[3,"Lines","","An iterator over the lines of a string, as string slices.",null,null],[3,"LinesAny","","Created with the method [`lines_any`].",null,null],[3,"Split","","Created with the method [`split`].",null,null],[3,"RSplit","","Created with the method [`rsplit`].",null,null],[3,"SplitN","","Created with the method [`splitn`].",null,null],[3,"RSplitN","","Created with the method [`rsplitn`].",null,null],[3,"SplitTerminator","","Created with the method [`split_terminator`].",null,null],[3,"RSplitTerminator","","Created with the method [`rsplit_terminator`].",null,null],[3,"Matches","","Created with the method [`matches`].",null,null],[3,"RMatches","","Created with the method [`rmatches`].",null,null],[3,"MatchIndices","","Created with the method [`match_indices`].",null,null],[3,"RMatchIndices","","Created with the method [`rmatch_indices`].",null,null],[5,"from_utf8","","Converts a slice of bytes to a string slice.",null,null],[5,"from_utf8_mut","","Converts a mutable slice of bytes to a mutable string slice.",null,null],[3,"Chars","","An iterator over the [`char`]s of a string slice.",null,null],[3,"CharIndices","","An iterator over the [`char`]s of a string slice, and their positions.",null,null],[3,"Bytes","","An iterator over the bytes of a string slice.",null,null],[5,"from_utf8_unchecked","","Converts a slice of bytes to a string slice without checking that the string contains valid UTF-8.",null,null],[5,"from_utf8_unchecked_mut","","Converts a slice of bytes to a string slice without checking that the string contains valid UTF-8; mutable version.",null,null],[3,"ParseBoolError","","An error returned when parsing a `bool` using [`from_str`] fails",null,null],[3,"SplitWhitespace","","An iterator over the non-whitespace substrings of a string, separated by any amount of whitespace.",null,null],[0,"pattern","","The string Pattern API.",null,null],[8,"Pattern","alloc::str::pattern","A string pattern.",null,null],[16,"Searcher","","Associated searcher for this pattern",36,null],[10,"into_searcher","","Constructs the associated searcher from `self` and the `haystack` to search in.",36,null],[11,"is_contained_in","","Checks whether the pattern matches anywhere in the haystack",36,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"is_prefix_of","","Checks whether the pattern matches at the front of the haystack",36,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"is_suffix_of","","Checks whether the pattern matches at the back of the haystack",36,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[4,"SearchStep","","Result of calling `Searcher::next()` or `ReverseSearcher::next_back()`.",null,null],[13,"Match","","Expresses that a match of the pattern has been found at `haystack[a..b]`.",37,null],[13,"Reject","","Expresses that `haystack[a..b]` has been rejected as a possible match of the pattern.",37,null],[13,"Done","","Expresses that every byte of the haystack has been visited, ending the iteration.",37,null],[8,"Searcher","","A searcher for a string pattern.",null,null],[10,"haystack","","Getter for the underlying string to be searched in",38,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[10,"next","","Performs the next search step starting from the front.",38,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match","","Find the next `Match` result. See `next()`",38,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject","","Find the next `Reject` result. See `next()` and `next_match()`",38,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[8,"ReverseSearcher","","A reverse searcher for a string pattern.",null,null],[10,"next_back","","Performs the next search step starting from the back.",39,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match_back","","Find the next `Match` result. See `next_back()`",39,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject_back","","Find the next `Reject` result. See `next_back()`",39,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[8,"DoubleEndedSearcher","","A marker trait to express that a `ReverseSearcher` can be used for a `DoubleEndedIterator` implementation.",null,null],[3,"CharSearcher","","Associated type for `<char as Pattern<'a>>::Searcher`.",null,null],[3,"CharSliceSearcher","","Associated type for `<&[char] as Pattern<'a>>::Searcher`.",null,null],[3,"CharPredicateSearcher","","Associated type for `<F as Pattern<'a>>::Searcher`.",null,null],[3,"StrSearcher","","Associated type for `<&str as Pattern<'a>>::Searcher`.",null,null],[3,"EncodeUtf16","alloc::str","An iterator of [`u16`] over the string encoded as UTF-16.",null,null],[5,"from_boxed_utf8_unchecked","","Converts a boxed slice of bytes to a boxed string slice without checking that the string contains valid UTF-8.",null,{"inputs":[{"name":"box"}],"output":{"generics":["str"],"name":"box"}}],[0,"string","alloc","A UTF-8 encoded, growable string.",null,null],[3,"String","alloc::string","A UTF-8 encoded, growable string.",null,null],[3,"FromUtf8Error","","A possible error value when converting a `String` from a UTF-8 byte vector.",null,null],[3,"FromUtf16Error","","A possible error value when converting a `String` from a UTF-16 byte slice.",null,null],[3,"Drain","","A draining iterator for `String`.",null,null],[4,"ParseError","","An error when parsing a `String`.",null,null],[8,"ToString","","A trait for converting a value to a `String`.",null,null],[10,"to_string","","Converts the given value to a `String`.",40,{"inputs":[{"name":"self"}],"output":{"name":"string"}}],[11,"partial_cmp","","",41,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",41,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"bool"}}],[11,"le","","",41,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"bool"}}],[11,"gt","","",41,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"bool"}}],[11,"ge","","",41,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"bool"}}],[11,"cmp","","",41,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"ordering"}}],[11,"fmt","","",42,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",43,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new empty `String`.",41,{"inputs":[],"output":{"name":"string"}}],[11,"with_capacity","","Creates a new empty `String` with a particular capacity.",41,{"inputs":[{"name":"usize"}],"output":{"name":"string"}}],[11,"from_utf8","","Converts a vector of bytes to a `String`.",41,{"inputs":[{"generics":["u8"],"name":"vec"}],"output":{"generics":["string","fromutf8error"],"name":"result"}}],[11,"from_utf8_lossy","","Converts a slice of bytes to a string, including invalid characters.",41,null],[11,"from_utf16","","Decode a UTF-16 encoded vector `v` into a `String`, returning [`Err`] if `v` contains any invalid data.",41,null],[11,"from_utf16_lossy","","Decode a UTF-16 encoded slice `v` into a `String`, replacing invalid data with the replacement character (U+FFFD).",41,null],[11,"from_raw_parts","","Creates a new `String` from a length, capacity, and pointer.",41,null],[11,"from_utf8_unchecked","","Converts a vector of bytes to a `String` without checking that the string contains valid UTF-8.",41,{"inputs":[{"generics":["u8"],"name":"vec"}],"output":{"name":"string"}}],[11,"into_bytes","","Converts a `String` into a byte vector.",41,{"inputs":[{"name":"self"}],"output":{"generics":["u8"],"name":"vec"}}],[11,"as_str","","Extracts a string slice containing the entire string.",41,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"as_mut_str","","Converts a `String` into a mutable string slice.",41,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"push_str","","Appends a given string slice onto the end of this `String`.",41,{"inputs":[{"name":"self"},{"name":"str"}],"output":null}],[11,"capacity","","Returns this `String`'s capacity, in bytes.",41,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"reserve","","Ensures that this `String`'s capacity is at least `additional` bytes larger than its length.",41,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"reserve_exact","","Ensures that this `String`'s capacity is `additional` bytes larger than its length.",41,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"try_reserve","","Tries to reserve capacity for at least `additional` more elements to be inserted in the given `String`. The collection may reserve more space to avoid frequent reallocations. After calling `reserve`, capacity will be greater than or equal to `self.len() + additional`. Does nothing if capacity is already sufficient.",41,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"generics":["collectionallocerr"],"name":"result"}}],[11,"try_reserve_exact","","Tries to reserves the minimum capacity for exactly `additional` more elements to be inserted in the given `String`. After calling `reserve_exact`, capacity will be greater than or equal to `self.len() + additional`. Does nothing if the capacity is already sufficient.",41,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"generics":["collectionallocerr"],"name":"result"}}],[11,"shrink_to_fit","","Shrinks the capacity of this `String` to match its length.",41,{"inputs":[{"name":"self"}],"output":null}],[11,"shrink_to","","Shrinks the capacity of this `String` with a lower bound.",41,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"push","","Appends the given [`char`] to the end of this `String`.",41,{"inputs":[{"name":"self"},{"name":"char"}],"output":null}],[11,"as_bytes","","Returns a byte slice of this `String`'s contents.",41,null],[11,"truncate","","Shortens this `String` to the specified length.",41,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"pop","","Removes the last character from the string buffer and returns it.",41,{"inputs":[{"name":"self"}],"output":{"generics":["char"],"name":"option"}}],[11,"remove","","Removes a [`char`] from this `String` at a byte position and returns it.",41,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"char"}}],[11,"retain","","Retains only the characters specified by the predicate.",41,{"inputs":[{"name":"self"},{"name":"f"}],"output":null}],[11,"insert","","Inserts a character into this `String` at a byte position.",41,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"char"}],"output":null}],[11,"insert_str","","Inserts a string slice into this `String` at a byte position.",41,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"str"}],"output":null}],[11,"as_mut_vec","","Returns a mutable reference to the contents of this `String`.",41,{"inputs":[{"name":"self"}],"output":{"name":"vec"}}],[11,"len","","Returns the length of this `String`, in bytes.",41,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","Returns `true` if this `String` has a length of zero.",41,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"split_off","","Splits the string into two at the given index.",41,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"string"}}],[11,"clear","","Truncates this `String`, removing all contents.",41,{"inputs":[{"name":"self"}],"output":null}],[11,"drain","","Creates a draining iterator that removes the specified range in the string and yields the removed chars.",41,{"inputs":[{"name":"self"},{"name":"r"}],"output":{"name":"drain"}}],[11,"replace_range","","Removes the specified range in the string, and replaces it with the given string. The given string doesn't need to be the same length as the range.",41,{"inputs":[{"name":"self"},{"name":"r"},{"name":"str"}],"output":null}],[11,"into_boxed_str","","Converts this `String` into a [`Box`]`<`[`str`]`>`.",41,{"inputs":[{"name":"self"}],"output":{"generics":["str"],"name":"box"}}],[11,"as_bytes","","Returns a slice of [`u8`]s bytes that were attempted to convert to a `String`.",42,null],[11,"into_bytes","","Returns the bytes that were attempted to convert to a `String`.",42,{"inputs":[{"name":"self"}],"output":{"generics":["u8"],"name":"vec"}}],[11,"utf8_error","","Fetch a `Utf8Error` to get more details about the conversion failure.",42,{"inputs":[{"name":"self"}],"output":{"name":"utf8error"}}],[11,"fmt","","",42,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",43,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",41,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"clone_from","","",41,{"inputs":[{"name":"self"},{"name":"self"}],"output":null}],[11,"from_iter","","",41,{"inputs":[{"name":"i"}],"output":{"name":"string"}}],[11,"from_iter","","",41,{"inputs":[{"name":"i"}],"output":{"name":"string"}}],[11,"from_iter","","",41,{"inputs":[{"name":"i"}],"output":{"name":"string"}}],[11,"from_iter","","",41,{"inputs":[{"name":"i"}],"output":{"name":"string"}}],[11,"from_iter","","",41,{"inputs":[{"name":"i"}],"output":{"name":"string"}}],[11,"extend","","",41,{"inputs":[{"name":"self"},{"name":"i"}],"output":null}],[11,"extend","","",41,{"inputs":[{"name":"self"},{"name":"i"}],"output":null}],[11,"extend","","",41,{"inputs":[{"name":"self"},{"name":"i"}],"output":null}],[11,"extend","","",41,{"inputs":[{"name":"self"},{"name":"i"}],"output":null}],[11,"extend","","",41,{"inputs":[{"name":"self"},{"name":"i"}],"output":null}],[11,"eq","","",41,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"bool"}}],[11,"ne","","",41,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"bool"}}],[11,"eq","","",41,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"ne","","",41,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"eq","","",41,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"ne","","",41,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"eq","alloc::borrow","",16,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"ne","","",16,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"eq","","",16,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"ne","","",16,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"eq","","",16,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"bool"}}],[11,"ne","","",16,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"bool"}}],[11,"eq","alloc::string","",41,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"bool"}}],[11,"ne","","",41,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"bool"}}],[11,"default","","Creates an empty `String`.",41,{"inputs":[],"output":{"name":"string"}}],[11,"fmt","","",41,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",41,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",41,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"add","","",41,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"string"}}],[11,"add_assign","","",41,{"inputs":[{"name":"self"},{"name":"str"}],"output":null}],[11,"index","","",41,{"inputs":[{"name":"self"},{"generics":["usize"],"name":"range"}],"output":{"name":"str"}}],[11,"index","","",41,{"inputs":[{"name":"self"},{"generics":["usize"],"name":"rangeto"}],"output":{"name":"str"}}],[11,"index","","",41,{"inputs":[{"name":"self"},{"generics":["usize"],"name":"rangefrom"}],"output":{"name":"str"}}],[11,"index","","",41,{"inputs":[{"name":"self"},{"name":"rangefull"}],"output":{"name":"str"}}],[11,"index","","",41,{"inputs":[{"name":"self"},{"generics":["usize"],"name":"rangeinclusive"}],"output":{"name":"str"}}],[11,"index","","",41,{"inputs":[{"name":"self"},{"generics":["usize"],"name":"rangetoinclusive"}],"output":{"name":"str"}}],[11,"index_mut","","",41,{"inputs":[{"name":"self"},{"generics":["usize"],"name":"range"}],"output":{"name":"str"}}],[11,"index_mut","","",41,{"inputs":[{"name":"self"},{"generics":["usize"],"name":"rangeto"}],"output":{"name":"str"}}],[11,"index_mut","","",41,{"inputs":[{"name":"self"},{"generics":["usize"],"name":"rangefrom"}],"output":{"name":"str"}}],[11,"index_mut","","",41,{"inputs":[{"name":"self"},{"name":"rangefull"}],"output":{"name":"str"}}],[11,"index_mut","","",41,{"inputs":[{"name":"self"},{"generics":["usize"],"name":"rangeinclusive"}],"output":{"name":"str"}}],[11,"index_mut","","",41,{"inputs":[{"name":"self"},{"generics":["usize"],"name":"rangetoinclusive"}],"output":{"name":"str"}}],[11,"deref","","",41,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"deref_mut","","",41,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"from_str","","",41,{"inputs":[{"name":"str"}],"output":{"generics":["string","parseerror"],"name":"result"}}],[11,"clone","","",44,{"inputs":[{"name":"self"}],"output":{"name":"parseerror"}}],[11,"fmt","","",44,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",44,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",44,{"inputs":[{"name":"self"},{"name":"parseerror"}],"output":{"name":"bool"}}],[11,"to_string","alloc::borrow","",16,{"inputs":[{"name":"self"}],"output":{"name":"string"}}],[11,"to_string","alloc::string","",41,{"inputs":[{"name":"self"}],"output":{"name":"string"}}],[11,"as_ref","","",41,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"as_ref","","",41,null],[11,"from","","",41,{"inputs":[{"name":"str"}],"output":{"name":"string"}}],[11,"from","","",41,{"inputs":[{"generics":["str"],"name":"box"}],"output":{"name":"string"}}],[11,"from","alloc::boxed","",2,{"inputs":[{"name":"string"}],"output":{"generics":["str"],"name":"box"}}],[11,"from","alloc::string","",41,{"inputs":[{"generics":["str"],"name":"cow"}],"output":{"name":"string"}}],[11,"from","alloc::borrow","",16,{"inputs":[{"name":"str"}],"output":{"generics":["str"],"name":"cow"}}],[11,"from","","",16,{"inputs":[{"name":"string"}],"output":{"generics":["str"],"name":"cow"}}],[11,"from_iter","","",16,{"inputs":[{"name":"i"}],"output":{"generics":["str"],"name":"cow"}}],[11,"from_iter","","",16,{"inputs":[{"name":"i"}],"output":{"generics":["str"],"name":"cow"}}],[11,"from_iter","","",16,{"inputs":[{"name":"i"}],"output":{"generics":["str"],"name":"cow"}}],[11,"write_str","alloc::string","",41,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"result"}}],[11,"write_char","","",41,{"inputs":[{"name":"self"},{"name":"char"}],"output":{"name":"result"}}],[11,"fmt","","",45,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"drop","","",45,{"inputs":[{"name":"self"}],"output":null}],[11,"next","","",45,{"inputs":[{"name":"self"}],"output":{"generics":["char"],"name":"option"}}],[11,"size_hint","","",45,null],[11,"next_back","","",45,{"inputs":[{"name":"self"}],"output":{"generics":["char"],"name":"option"}}],[0,"vec","alloc","A contiguous growable array type with heap-allocated contents, written `Vec<T>`.",null,null],[3,"Vec","alloc::vec","A contiguous growable array type, written `Vec<T>` but pronounced 'vector'.",null,null],[3,"IntoIter","","An iterator that moves out of a vector.",null,null],[3,"Drain","","A draining iterator for `Vec<T>`.",null,null],[3,"Splice","","A splicing iterator for `Vec`.",null,null],[3,"DrainFilter","","An iterator produced by calling `drain_filter` on Vec.",null,null],[11,"new","","Constructs a new, empty `Vec<T>`.",46,{"inputs":[],"output":{"name":"vec"}}],[11,"with_capacity","","Constructs a new, empty `Vec<T>` with the specified capacity.",46,{"inputs":[{"name":"usize"}],"output":{"name":"vec"}}],[11,"from_raw_parts","","Creates a `Vec<T>` directly from the raw components of another vector.",46,null],[11,"capacity","","Returns the number of elements the vector can hold without reallocating.",46,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"reserve","","Reserves capacity for at least `additional` more elements to be inserted in the given `Vec<T>`. The collection may reserve more space to avoid frequent reallocations. After calling `reserve`, capacity will be greater than or equal to `self.len() + additional`. Does nothing if capacity is already sufficient.",46,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"reserve_exact","","Reserves the minimum capacity for exactly `additional` more elements to be inserted in the given `Vec<T>`. After calling `reserve_exact`, capacity will be greater than or equal to `self.len() + additional`. Does nothing if the capacity is already sufficient.",46,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"try_reserve","","Tries to reserve capacity for at least `additional` more elements to be inserted in the given `Vec<T>`. The collection may reserve more space to avoid frequent reallocations. After calling `reserve`, capacity will be greater than or equal to `self.len() + additional`. Does nothing if capacity is already sufficient.",46,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"generics":["collectionallocerr"],"name":"result"}}],[11,"try_reserve_exact","","Tries to reserves the minimum capacity for exactly `additional` more elements to be inserted in the given `Vec<T>`. After calling `reserve_exact`, capacity will be greater than or equal to `self.len() + additional`. Does nothing if the capacity is already sufficient.",46,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"generics":["collectionallocerr"],"name":"result"}}],[11,"shrink_to_fit","","Shrinks the capacity of the vector as much as possible.",46,{"inputs":[{"name":"self"}],"output":null}],[11,"shrink_to","","Shrinks the capacity of the vector with a lower bound.",46,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"into_boxed_slice","","Converts the vector into [`Box<[T]>`][owned slice].",46,{"inputs":[{"name":"self"}],"output":{"name":"box"}}],[11,"truncate","","Shortens the vector, keeping the first `len` elements and dropping the rest.",46,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"as_slice","","Extracts a slice containing the entire vector.",46,null],[11,"as_mut_slice","","Extracts a mutable slice of the entire vector.",46,null],[11,"set_len","","Sets the length of a vector.",46,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"swap_remove","","Removes an element from the vector and returns it.",46,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"t"}}],[11,"insert","","Inserts an element at position `index` within the vector, shifting all elements after it to the right.",46,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"t"}],"output":null}],[11,"remove","","Removes and returns the element at position `index` within the vector, shifting all elements after it to the left.",46,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"t"}}],[11,"retain","","Retains only the elements specified by the predicate.",46,{"inputs":[{"name":"self"},{"name":"f"}],"output":null}],[11,"dedup_by_key","","Removes all but the first of consecutive elements in the vector that resolve to the same key.",46,{"inputs":[{"name":"self"},{"name":"f"}],"output":null}],[11,"dedup_by","","Removes all but the first of consecutive elements in the vector satisfying a given equality relation.",46,{"inputs":[{"name":"self"},{"name":"f"}],"output":null}],[11,"push","","Appends an element to the back of a collection.",46,{"inputs":[{"name":"self"},{"name":"t"}],"output":null}],[11,"pop","","Removes the last element from a vector and returns it, or [`None`] if it is empty.",46,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"append","","Moves all the elements of `other` into `Self`, leaving `other` empty.",46,{"inputs":[{"name":"self"},{"name":"self"}],"output":null}],[11,"drain","","Creates a draining iterator that removes the specified range in the vector and yields the removed items.",46,{"inputs":[{"name":"self"},{"name":"r"}],"output":{"name":"drain"}}],[11,"clear","","Clears the vector, removing all values.",46,{"inputs":[{"name":"self"}],"output":null}],[11,"len","","Returns the number of elements in the vector, also referred to as its 'length'.",46,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","Returns `true` if the vector contains no elements.",46,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"split_off","","Splits the collection into two at the given index.",46,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"self"}}],[11,"resize_with","","Resizes the `Vec` in-place so that `len` is equal to `new_len`.",46,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"f"}],"output":null}],[11,"resize","","Resizes the `Vec` in-place so that `len` is equal to `new_len`.",46,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"t"}],"output":null}],[11,"extend_from_slice","","Clones and appends all elements in a slice to the `Vec`.",46,null],[11,"resize_default","","Resizes the `Vec` in-place so that `len` is equal to `new_len`.",46,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"dedup","","Removes consecutive repeated elements in the vector.",46,{"inputs":[{"name":"self"}],"output":null}],[11,"remove_item","","Removes the first instance of `item` from the vector if the item exists.",46,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"option"}}],[11,"clone","","",46,{"inputs":[{"name":"self"}],"output":{"name":"vec"}}],[11,"clone_from","","",46,{"inputs":[{"name":"self"},{"name":"vec"}],"output":null}],[11,"hash","","",46,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"index","","",46,null],[11,"index_mut","","",46,null],[11,"deref","","",46,null],[11,"deref_mut","","",46,null],[11,"from_iter","","",46,{"inputs":[{"name":"i"}],"output":{"name":"vec"}}],[11,"into_iter","","Creates a consuming iterator, that is, one that moves each value out of the vector (from start to end). The vector cannot be used after calling this.",46,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"extend","","",46,{"inputs":[{"name":"self"},{"name":"i"}],"output":null}],[11,"splice","","Creates a splicing iterator that replaces the specified range in the vector with the given `replace_with` iterator and yields the removed items. `replace_with` does not need to be the same length as `range`.",46,{"inputs":[{"name":"self"},{"name":"r"},{"name":"i"}],"output":{"name":"splice"}}],[11,"drain_filter","","Creates an iterator which uses a closure to determine if an element should be removed.",46,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"drainfilter"}}],[11,"extend","","",46,{"inputs":[{"name":"self"},{"name":"i"}],"output":null}],[11,"eq","","",46,{"inputs":[{"name":"self"},{"name":"vec"}],"output":{"name":"bool"}}],[11,"ne","","",46,{"inputs":[{"name":"self"},{"name":"vec"}],"output":{"name":"bool"}}],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","alloc::borrow","",16,null],[11,"ne","","",16,null],[11,"eq","","",16,null],[11,"ne","","",16,null],[11,"eq","","",16,{"inputs":[{"name":"self"},{"name":"vec"}],"output":{"name":"bool"}}],[11,"ne","","",16,{"inputs":[{"name":"self"},{"name":"vec"}],"output":{"name":"bool"}}],[11,"eq","alloc::vec","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"partial_cmp","","",46,{"inputs":[{"name":"self"},{"name":"vec"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"cmp","","",46,{"inputs":[{"name":"self"},{"name":"vec"}],"output":{"name":"ordering"}}],[11,"drop","","",46,{"inputs":[{"name":"self"}],"output":null}],[11,"default","","Creates an empty `Vec<T>`.",46,{"inputs":[],"output":{"name":"vec"}}],[11,"fmt","","",46,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"as_ref","","",46,{"inputs":[{"name":"self"}],"output":{"name":"vec"}}],[11,"as_mut","","",46,{"inputs":[{"name":"self"}],"output":{"name":"vec"}}],[11,"as_ref","","",46,null],[11,"as_mut","","",46,null],[11,"from","","",46,null],[11,"from","","",46,null],[11,"from","","",46,{"inputs":[{"name":"cow"}],"output":{"name":"vec"}}],[11,"from","","",46,{"inputs":[{"name":"box"}],"output":{"name":"vec"}}],[11,"from","alloc::boxed","",2,{"inputs":[{"name":"vec"}],"output":{"name":"box"}}],[11,"from","alloc::vec","",46,{"inputs":[{"name":"str"}],"output":{"generics":["u8"],"name":"vec"}}],[11,"from","alloc::borrow","",16,null],[11,"from","","",16,{"inputs":[{"name":"vec"}],"output":{"name":"cow"}}],[11,"from_iter","","",16,{"inputs":[{"name":"i"}],"output":{"name":"cow"}}],[11,"fmt","alloc::vec","",47,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"as_slice","","Returns the remaining items of this iterator as a slice.",47,null],[11,"as_mut_slice","","Returns the remaining items of this iterator as a mutable slice.",47,null],[11,"next","","",47,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",47,null],[11,"count","","",47,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"next_back","","",47,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"is_empty","","",47,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",47,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"drop","","",47,{"inputs":[{"name":"self"}],"output":null}],[11,"fmt","","",48,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",48,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",48,null],[11,"next_back","","",48,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"drop","","",48,{"inputs":[{"name":"self"}],"output":null}],[11,"is_empty","","",48,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"fmt","","",49,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",49,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",49,null],[11,"next_back","","",49,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"drop","","",49,{"inputs":[{"name":"self"}],"output":null}],[11,"fmt","","",50,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",50,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",50,null],[11,"drop","","",50,{"inputs":[{"name":"self"}],"output":null}],[0,"vec_deque","alloc","A double-ended queue implemented with a growable ring buffer.",null,null],[3,"VecDeque","alloc::vec_deque","A double-ended queue implemented with a growable ring buffer.",null,null],[3,"Iter","","An iterator over the elements of a `VecDeque`.",null,null],[3,"IterMut","","A mutable iterator over the elements of a `VecDeque`.",null,null],[3,"IntoIter","","An owning iterator over the elements of a `VecDeque`.",null,null],[3,"Drain","","A draining iterator over the elements of a `VecDeque`.",null,null],[11,"clone","","",51,{"inputs":[{"name":"self"}],"output":{"name":"vecdeque"}}],[11,"drop","","",51,{"inputs":[{"name":"self"}],"output":null}],[11,"default","","Creates an empty `VecDeque<T>`.",51,{"inputs":[],"output":{"name":"vecdeque"}}],[11,"new","","Creates an empty `VecDeque`.",51,{"inputs":[],"output":{"name":"vecdeque"}}],[11,"with_capacity","","Creates an empty `VecDeque` with space for at least `n` elements.",51,{"inputs":[{"name":"usize"}],"output":{"name":"vecdeque"}}],[11,"get","","Retrieves an element in the `VecDeque` by index.",51,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"get_mut","","Retrieves an element in the `VecDeque` mutably by index.",51,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"swap","","Swaps elements at indices `i` and `j`.",51,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"usize"}],"output":null}],[11,"capacity","","Returns the number of elements the `VecDeque` can hold without reallocating.",51,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"reserve_exact","","Reserves the minimum capacity for exactly `additional` more elements to be inserted in the given `VecDeque`. Does nothing if the capacity is already sufficient.",51,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"reserve","","Reserves capacity for at least `additional` more elements to be inserted in the given `VecDeque`. The collection may reserve more space to avoid frequent reallocations.",51,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"try_reserve_exact","","Tries to reserves the minimum capacity for exactly `additional` more elements to be inserted in the given `VecDeque<T>`. After calling `reserve_exact`, capacity will be greater than or equal to `self.len() + additional`. Does nothing if the capacity is already sufficient.",51,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"generics":["collectionallocerr"],"name":"result"}}],[11,"try_reserve","","Tries to reserve capacity for at least `additional` more elements to be inserted in the given `VecDeque<T>`. The collection may reserve more space to avoid frequent reallocations. After calling `reserve`, capacity will be greater than or equal to `self.len() + additional`. Does nothing if capacity is already sufficient.",51,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"generics":["collectionallocerr"],"name":"result"}}],[11,"shrink_to_fit","","Shrinks the capacity of the `VecDeque` as much as possible.",51,{"inputs":[{"name":"self"}],"output":null}],[11,"shrink_to","","Shrinks the capacity of the `VecDeque` with a lower bound.",51,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"truncate","","Shortens the `VecDeque`, dropping excess elements from the back.",51,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"iter","","Returns a front-to-back iterator.",51,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"iter_mut","","Returns a front-to-back iterator that returns mutable references.",51,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"as_slices","","Returns a pair of slices which contain, in order, the contents of the `VecDeque`.",51,null],[11,"as_mut_slices","","Returns a pair of slices which contain, in order, the contents of the `VecDeque`.",51,null],[11,"len","","Returns the number of elements in the `VecDeque`.",51,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","Returns `true` if the `VecDeque` is empty.",51,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"drain","","Create a draining iterator that removes the specified range in the `VecDeque` and yields the removed items.",51,{"inputs":[{"name":"self"},{"name":"r"}],"output":{"name":"drain"}}],[11,"clear","","Clears the `VecDeque`, removing all values.",51,{"inputs":[{"name":"self"}],"output":null}],[11,"contains","","Returns `true` if the `VecDeque` contains an element equal to the given value.",51,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"bool"}}],[11,"front","","Provides a reference to the front element, or `None` if the `VecDeque` is empty.",51,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"front_mut","","Provides a mutable reference to the front element, or `None` if the `VecDeque` is empty.",51,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"back","","Provides a reference to the back element, or `None` if the `VecDeque` is empty.",51,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"back_mut","","Provides a mutable reference to the back element, or `None` if the `VecDeque` is empty.",51,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"pop_front","","Removes the first element and returns it, or `None` if the `VecDeque` is empty.",51,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"push_front","","Prepends an element to the `VecDeque`.",51,{"inputs":[{"name":"self"},{"name":"t"}],"output":null}],[11,"push_back","","Appends an element to the back of the `VecDeque`.",51,{"inputs":[{"name":"self"},{"name":"t"}],"output":null}],[11,"pop_back","","Removes the last element from the `VecDeque` and returns it, or `None` if it is empty.",51,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"swap_remove_back","","Removes an element from anywhere in the `VecDeque` and returns it, replacing it with the last element.",51,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"swap_remove_front","","Removes an element from anywhere in the `VecDeque` and returns it, replacing it with the first element.",51,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"insert","","Inserts an element at `index` within the `VecDeque`, shifting all elements with indices greater than or equal to `index` towards the back.",51,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"t"}],"output":null}],[11,"remove","","Removes and returns the element at `index` from the `VecDeque`. Whichever end is closer to the removal point will be moved to make room, and all the affected elements will be moved to new positions. Returns `None` if `index` is out of bounds.",51,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"split_off","","Splits the `VecDeque` into two at the given index.",51,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"self"}}],[11,"append","","Moves all the elements of `other` into `Self`, leaving `other` empty.",51,{"inputs":[{"name":"self"},{"name":"self"}],"output":null}],[11,"retain","","Retains only the elements specified by the predicate.",51,{"inputs":[{"name":"self"},{"name":"f"}],"output":null}],[11,"resize","","Modifies the `VecDeque` in-place so that `len()` is equal to new_len, either by removing excess elements from the back or by appending clones of `value` to the back.",51,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"t"}],"output":null}],[11,"fmt","","",52,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",52,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"next","","",52,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",52,null],[11,"fold","","",52,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"f"}],"output":{"name":"acc"}}],[11,"next_back","","",52,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"rfold","","",52,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"f"}],"output":{"name":"acc"}}],[11,"is_empty","","",52,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"fmt","","",53,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",53,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",53,null],[11,"fold","","",53,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"f"}],"output":{"name":"acc"}}],[11,"next_back","","",53,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"rfold","","",53,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"f"}],"output":{"name":"acc"}}],[11,"is_empty","","",53,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",54,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"fmt","","",54,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",54,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",54,null],[11,"next_back","","",54,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"is_empty","","",54,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"fmt","","",55,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"drop","","",55,{"inputs":[{"name":"self"}],"output":null}],[11,"next","","",55,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",55,null],[11,"next_back","","",55,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"eq","","",51,{"inputs":[{"name":"self"},{"name":"vecdeque"}],"output":{"name":"bool"}}],[11,"eq","","",51,{"inputs":[{"name":"self"},{"name":"vec"}],"output":{"name":"bool"}}],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"eq","","",51,null],[11,"partial_cmp","","",51,{"inputs":[{"name":"self"},{"name":"vecdeque"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"cmp","","",51,{"inputs":[{"name":"self"},{"name":"vecdeque"}],"output":{"name":"ordering"}}],[11,"hash","","",51,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"index","","",51,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"a"}}],[11,"index_mut","","",51,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"a"}}],[11,"from_iter","","",51,{"inputs":[{"name":"t"}],"output":{"name":"vecdeque"}}],[11,"into_iter","","Consumes the `VecDeque` into a front-to-back iterator yielding elements by value.",51,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"extend","","",51,{"inputs":[{"name":"self"},{"name":"t"}],"output":null}],[11,"extend","","",51,{"inputs":[{"name":"self"},{"name":"i"}],"output":null}],[11,"fmt","","",51,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"from","","",51,{"inputs":[{"name":"vec"}],"output":{"name":"self"}}],[11,"from","alloc::vec","",46,{"inputs":[{"name":"vecdeque"}],"output":{"name":"self"}}],[0,"btree_map","alloc","A map based on a B-Tree.",null,null],[3,"BTreeMap","alloc::btree_map","A map based on a B-Tree.",null,null],[3,"Iter","","An iterator over the entries of a `BTreeMap`.",null,null],[3,"IterMut","","A mutable iterator over the entries of a `BTreeMap`.",null,null],[3,"IntoIter","","An owning iterator over the entries of a `BTreeMap`.",null,null],[3,"Keys","","An iterator over the keys of a `BTreeMap`.",null,null],[3,"Values","","An iterator over the values of a `BTreeMap`.",null,null],[3,"ValuesMut","","A mutable iterator over the values of a `BTreeMap`.",null,null],[3,"Range","","An iterator over a sub-range of entries in a `BTreeMap`.",null,null],[3,"RangeMut","","A mutable iterator over a sub-range of entries in a `BTreeMap`.",null,null],[3,"VacantEntry","","A view into a vacant entry in a `BTreeMap`. It is part of the [`Entry`] enum.",null,null],[3,"OccupiedEntry","","A view into an occupied entry in a `BTreeMap`. It is part of the [`Entry`] enum.",null,null],[4,"Entry","","A view into a single entry in a map, which may either be vacant or occupied.",null,null],[13,"Vacant","","A vacant entry.",56,null],[13,"Occupied","","An occupied entry.",56,null],[0,"btree_set","alloc","A set based on a B-Tree.",null,null],[3,"BTreeSet","alloc::btree_set","A set based on a B-Tree.",null,null],[3,"Iter","","An iterator over the items of a `BTreeSet`.",null,null],[3,"IntoIter","","An owning iterator over the items of a `BTreeSet`.",null,null],[3,"Range","","An iterator over a sub-range of items in a `BTreeSet`.",null,null],[3,"Difference","","A lazy iterator producing elements in the difference of `BTreeSet`s.",null,null],[3,"SymmetricDifference","","A lazy iterator producing elements in the symmetric difference of `BTreeSet`s.",null,null],[3,"Intersection","","A lazy iterator producing elements in the intersection of `BTreeSet`s.",null,null],[3,"Union","","A lazy iterator producing elements in the union of `BTreeSet`s.",null,null],[14,"vec","alloc","Creates a [`Vec`] containing the arguments.",null,null],[14,"format","","Creates a `String` using interpolation of runtime expressions.",null,null],[11,"from","alloc::vec","",46,{"inputs":[{"name":"binaryheap"}],"output":{"name":"vec"}}],[11,"drop","alloc::btree_map","",57,{"inputs":[{"name":"self"}],"output":null}],[11,"clone","","",57,{"inputs":[{"name":"self"}],"output":{"name":"btreemap"}}],[11,"fmt","","",58,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",59,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",60,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",61,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",62,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",63,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",64,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",65,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",56,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",66,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",67,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Makes a new empty BTreeMap with a reasonable choice for B.",57,{"inputs":[],"output":{"name":"btreemap"}}],[11,"clear","","Clears the map, removing all values.",57,{"inputs":[{"name":"self"}],"output":null}],[11,"get","","Returns a reference to the value corresponding to the key.",57,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"option"}}],[11,"get_key_value","","Returns the key-value pair corresponding to the supplied key.",57,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"option"}}],[11,"contains_key","","Returns `true` if the map contains a value for the specified key.",57,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"bool"}}],[11,"get_mut","","Returns a mutable reference to the value corresponding to the key.",57,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"option"}}],[11,"insert","","Inserts a key-value pair into the map.",57,{"inputs":[{"name":"self"},{"name":"k"},{"name":"v"}],"output":{"name":"option"}}],[11,"remove","","Removes a key from the map, returning the value at the key if the key was previously in the map.",57,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"option"}}],[11,"append","","Moves all elements from `other` into `Self`, leaving `other` empty.",57,{"inputs":[{"name":"self"},{"name":"self"}],"output":null}],[11,"range","","Constructs a double-ended iterator over a sub-range of elements in the map. The simplest way is to use the range syntax `min..max`, thus `range(min..max)` will yield elements from min (inclusive) to max (exclusive). The range may also be entered as `(Bound<T>, Bound<T>)`, so for example `range((Excluded(4), Included(10)))` will yield a left-exclusive, right-inclusive range from 4 to 10.",57,{"inputs":[{"name":"self"},{"name":"r"}],"output":{"name":"range"}}],[11,"range_mut","","Constructs a mutable double-ended iterator over a sub-range of elements in the map. The simplest way is to use the range syntax `min..max`, thus `range(min..max)` will yield elements from min (inclusive) to max (exclusive). The range may also be entered as `(Bound<T>, Bound<T>)`, so for example `range((Excluded(4), Included(10)))` will yield a left-exclusive, right-inclusive range from 4 to 10.",57,{"inputs":[{"name":"self"},{"name":"r"}],"output":{"name":"rangemut"}}],[11,"entry","","Gets the given key's corresponding entry in the map for in-place manipulation.",57,{"inputs":[{"name":"self"},{"name":"k"}],"output":{"name":"entry"}}],[11,"split_off","","Splits the collection into two at the given key. Returns everything after the given key, including the key.",57,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"self"}}],[11,"next","","",58,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",58,null],[11,"next_back","","",58,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"len","","",58,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"clone","","",58,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"next","","",59,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",59,null],[11,"next_back","","",59,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"len","","",59,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"into_iter","","",57,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"drop","","",60,{"inputs":[{"name":"self"}],"output":null}],[11,"next","","",60,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",60,null],[11,"next_back","","",60,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"len","","",60,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"next","","",61,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",61,null],[11,"next_back","","",61,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"len","","",61,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"clone","","",61,{"inputs":[{"name":"self"}],"output":{"name":"keys"}}],[11,"next","","",62,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",62,null],[11,"next_back","","",62,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"len","","",62,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"clone","","",62,{"inputs":[{"name":"self"}],"output":{"name":"values"}}],[11,"next","","",64,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",63,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",63,null],[11,"next_back","","",63,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"len","","",63,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"next_back","","",64,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",64,{"inputs":[{"name":"self"}],"output":{"name":"range"}}],[11,"next","","",65,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",65,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"from_iter","","",57,{"inputs":[{"name":"t"}],"output":{"name":"btreemap"}}],[11,"extend","","",57,{"inputs":[{"name":"self"},{"name":"t"}],"output":null}],[11,"extend","","",57,{"inputs":[{"name":"self"},{"name":"i"}],"output":null}],[11,"hash","","",57,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"default","","Creates an empty `BTreeMap<K, V>`.",57,{"inputs":[],"output":{"name":"btreemap"}}],[11,"eq","","",57,{"inputs":[{"name":"self"},{"name":"btreemap"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",57,{"inputs":[{"name":"self"},{"name":"btreemap"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"cmp","","",57,{"inputs":[{"name":"self"},{"name":"btreemap"}],"output":{"name":"ordering"}}],[11,"fmt","","",57,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"index","","Returns a reference to the value corresponding to the supplied key.",57,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"v"}}],[11,"iter","","Gets an iterator over the entries of the map, sorted by key.",57,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"iter_mut","","Gets a mutable iterator over the entries of the map, sorted by key.",57,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"keys","","Gets an iterator over the keys of the map, in sorted order.",57,{"inputs":[{"name":"self"}],"output":{"name":"keys"}}],[11,"values","","Gets an iterator over the values of the map, in order by key.",57,{"inputs":[{"name":"self"}],"output":{"name":"values"}}],[11,"values_mut","","Gets a mutable iterator over the values of the map, in order by key.",57,{"inputs":[{"name":"self"}],"output":{"name":"valuesmut"}}],[11,"len","","Returns the number of elements in the map.",57,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","Returns `true` if the map contains no elements.",57,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"or_insert","","Ensures a value is in the entry by inserting the default if empty, and returns a mutable reference to the value in the entry.",56,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"v"}}],[11,"or_insert_with","","Ensures a value is in the entry by inserting the result of the default function if empty, and returns a mutable reference to the value in the entry.",56,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"v"}}],[11,"key","","Returns a reference to this entry's key.",56,{"inputs":[{"name":"self"}],"output":{"name":"k"}}],[11,"and_modify","","Provides in-place mutable access to an occupied entry before any potential inserts into the map.",56,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"self"}}],[11,"or_default","","Ensures a value is in the entry by inserting the default value if empty, and returns a mutable reference to the value in the entry.",56,{"inputs":[{"name":"self"}],"output":{"name":"v"}}],[11,"key","","Gets a reference to the key that would be used when inserting a value through the VacantEntry.",66,{"inputs":[{"name":"self"}],"output":{"name":"k"}}],[11,"into_key","","Take ownership of the key.",66,{"inputs":[{"name":"self"}],"output":{"name":"k"}}],[11,"insert","","Sets the value of the entry with the `VacantEntry`'s key, and returns a mutable reference to it.",66,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"v"}}],[11,"key","","Gets a reference to the key in the entry.",67,{"inputs":[{"name":"self"}],"output":{"name":"k"}}],[11,"remove_entry","","Take ownership of the key and value from the map.",67,null],[11,"get","","Gets a reference to the value in the entry.",67,{"inputs":[{"name":"self"}],"output":{"name":"v"}}],[11,"get_mut","","Gets a mutable reference to the value in the entry.",67,{"inputs":[{"name":"self"}],"output":{"name":"v"}}],[11,"into_mut","","Converts the entry into a mutable reference to its value.",67,{"inputs":[{"name":"self"}],"output":{"name":"v"}}],[11,"insert","","Sets the value of the entry with the `OccupiedEntry`'s key, and returns the entry's old value.",67,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"v"}}],[11,"remove","","Takes the value of the entry out of the map, and returns it.",67,{"inputs":[{"name":"self"}],"output":{"name":"v"}}],[11,"clone","alloc::btree_set","",68,{"inputs":[{"name":"self"}],"output":{"name":"btreeset"}}],[11,"hash","","",68,null],[11,"eq","","",68,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"ne","","",68,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"cmp","","",68,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",68,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",68,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"le","","",68,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"gt","","",68,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"ge","","",68,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"fmt","","",69,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",70,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",71,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",72,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",73,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",74,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",75,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Makes a new `BTreeSet` with a reasonable choice of B.",68,{"inputs":[],"output":{"name":"btreeset"}}],[11,"range","","Constructs a double-ended iterator over a sub-range of elements in the set. The simplest way is to use the range syntax `min..max`, thus `range(min..max)` will yield elements from min (inclusive) to max (exclusive). The range may also be entered as `(Bound<T>, Bound<T>)`, so for example `range((Excluded(4), Included(10)))` will yield a left-exclusive, right-inclusive range from 4 to 10.",68,{"inputs":[{"name":"self"},{"name":"r"}],"output":{"name":"range"}}],[11,"difference","","Visits the values representing the difference, i.e. the values that are in `self` but not in `other`, in ascending order.",68,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"difference"}}],[11,"symmetric_difference","","Visits the values representing the symmetric difference, i.e. the values that are in `self` or in `other` but not in both, in ascending order.",68,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"symmetricdifference"}}],[11,"intersection","","Visits the values representing the intersection, i.e. the values that are both in `self` and `other`, in ascending order.",68,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"intersection"}}],[11,"union","","Visits the values representing the union, i.e. all the values in `self` or `other`, without duplicates, in ascending order.",68,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"union"}}],[11,"clear","","Clears the set, removing all values.",68,{"inputs":[{"name":"self"}],"output":null}],[11,"contains","","Returns `true` if the set contains a value.",68,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"bool"}}],[11,"get","","Returns a reference to the value in the set, if any, that is equal to the given value.",68,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"option"}}],[11,"is_disjoint","","Returns `true` if `self` has no elements in common with `other`. This is equivalent to checking for an empty intersection.",68,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"is_subset","","Returns `true` if the set is a subset of another, i.e. `other` contains at least all the values in `self`.",68,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"is_superset","","Returns `true` if the set is a superset of another, i.e. `self` contains at least all the values in `other`.",68,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"insert","","Adds a value to the set.",68,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"bool"}}],[11,"replace","","Adds a value to the set, replacing the existing value, if any, that is equal to the given one. Returns the replaced value.",68,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"option"}}],[11,"remove","","Removes a value from the set. Returns `true` if the value was present in the set.",68,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"bool"}}],[11,"take","","Removes and returns the value in the set, if any, that is equal to the given one.",68,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"option"}}],[11,"append","","Moves all elements from `other` into `Self`, leaving `other` empty.",68,{"inputs":[{"name":"self"},{"name":"self"}],"output":null}],[11,"split_off","","Splits the collection into two at the given key. Returns everything after the given key, including the key.",68,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"self"}}],[11,"iter","","Gets an iterator that visits the values in the `BTreeSet` in ascending order.",68,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"len","","Returns the number of elements in the set.",68,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","Returns `true` if the set contains no elements.",68,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"from_iter","","",68,{"inputs":[{"name":"i"}],"output":{"name":"btreeset"}}],[11,"into_iter","","Gets an iterator for moving out the `BTreeSet`'s contents.",68,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"extend","","",68,{"inputs":[{"name":"self"},{"name":"iter"}],"output":null}],[11,"extend","","",68,{"inputs":[{"name":"self"},{"name":"i"}],"output":null}],[11,"default","","Makes an empty `BTreeSet<T>` with a reasonable choice of B.",68,{"inputs":[],"output":{"name":"btreeset"}}],[11,"fmt","","",68,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",69,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"next","","",69,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",69,null],[11,"next_back","","",69,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"len","","",69,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"next","","",70,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",70,null],[11,"next_back","","",70,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"len","","",70,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"clone","","",71,{"inputs":[{"name":"self"}],"output":{"name":"range"}}],[11,"next","","",71,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",71,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",72,{"inputs":[{"name":"self"}],"output":{"name":"difference"}}],[11,"next","","",72,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",72,null],[11,"clone","","",73,{"inputs":[{"name":"self"}],"output":{"name":"symmetricdifference"}}],[11,"next","","",73,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",73,null],[11,"clone","","",74,{"inputs":[{"name":"self"}],"output":{"name":"intersection"}}],[11,"next","","",74,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",74,null],[11,"clone","","",75,{"inputs":[{"name":"self"}],"output":{"name":"union"}}],[11,"next","","",75,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",75,null],[11,"next","alloc::slice","",76,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",76,null],[11,"count","","",76,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"nth","","",76,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",76,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",77,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",77,null],[11,"next","alloc::str","",78,{"inputs":[{"name":"self"}],"output":{"generics":["str"],"name":"option"}}],[11,"next","","",79,{"inputs":[{"name":"self"}],"output":{"generics":["str"],"name":"option"}}],[11,"next","alloc::slice","",80,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",80,null],[11,"next","","",81,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",81,null],[11,"count","","",81,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"nth","","",81,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",81,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"try_fold","","",81,{"inputs":[{"name":"self"},{"name":"b"},{"name":"f"}],"output":{"name":"r"}}],[11,"fold","","",81,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"acc"}}],[11,"position","","",81,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"generics":["usize"],"name":"option"}}],[11,"rposition","","",81,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"generics":["usize"],"name":"option"}}],[11,"next","","",82,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",82,null],[11,"count","","",82,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"nth","","",82,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",82,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","alloc::str","",83,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",84,{"inputs":[{"name":"self"}],"output":{"generics":["u8"],"name":"option"}}],[11,"size_hint","","",84,null],[11,"count","","",84,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"last","","",84,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"nth","","",84,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"all","","",84,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"any","","",84,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"find","","",84,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"option"}}],[11,"position","","",84,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"generics":["usize"],"name":"option"}}],[11,"rposition","","",84,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"generics":["usize"],"name":"option"}}],[11,"next","alloc::slice","",85,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",85,null],[11,"next","alloc::str","",86,{"inputs":[{"name":"self"}],"output":{"generics":["u16"],"name":"option"}}],[11,"size_hint","","",86,null],[11,"next","","",87,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",88,{"inputs":[{"name":"self"}],"output":{"generics":["str"],"name":"option"}}],[11,"size_hint","","",88,null],[11,"next","","",89,{"inputs":[{"name":"self"}],"output":{"generics":["str"],"name":"option"}}],[11,"next","alloc::slice","",90,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",90,null],[11,"next","","",91,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",91,null],[11,"next","","",92,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",92,null],[11,"next","alloc::str","",93,{"inputs":[{"name":"self"}],"output":{"generics":["char"],"name":"option"}}],[11,"count","","",93,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"size_hint","","",93,null],[11,"last","","",93,{"inputs":[{"name":"self"}],"output":{"generics":["char"],"name":"option"}}],[11,"next","alloc::slice","",94,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",94,null],[11,"count","","",94,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"nth","","",94,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",94,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",95,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",95,null],[11,"count","","",95,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"nth","","",95,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",95,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"try_fold","","",95,{"inputs":[{"name":"self"},{"name":"b"},{"name":"f"}],"output":{"name":"r"}}],[11,"fold","","",95,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"acc"}}],[11,"position","","",95,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"generics":["usize"],"name":"option"}}],[11,"rposition","","",95,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"generics":["usize"],"name":"option"}}],[11,"next","alloc::str","",96,{"inputs":[{"name":"self"}],"output":{"generics":["str"],"name":"option"}}],[11,"next","","",97,{"inputs":[{"name":"self"}],"output":{"generics":["str"],"name":"option"}}],[11,"next","","",98,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"count","","",98,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"size_hint","","",98,null],[11,"last","","",98,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",99,{"inputs":[{"name":"self"}],"output":{"generics":["str"],"name":"option"}}],[11,"next","","",100,{"inputs":[{"name":"self"}],"output":{"generics":["str"],"name":"option"}}],[11,"next","alloc::slice","",101,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",101,null],[11,"count","","",101,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"nth","","",101,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",101,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","alloc::str","",102,{"inputs":[{"name":"self"}],"output":{"generics":["str"],"name":"option"}}],[11,"size_hint","","",102,null],[11,"next","","",103,{"inputs":[{"name":"self"}],"output":{"generics":["str"],"name":"option"}}],[11,"next","alloc::slice","",104,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",104,null],[11,"count","","",104,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"nth","","",104,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",104,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",105,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",105,null],[11,"next","alloc::str","",106,{"inputs":[{"name":"self"}],"output":{"generics":["str"],"name":"option"}}],[11,"next","alloc::slice","",107,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",107,null],[11,"write_str","alloc::fmt","",108,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"generics":["error"],"name":"result"}}],[11,"write_char","","",108,{"inputs":[{"name":"self"},{"name":"char"}],"output":{"generics":["error"],"name":"result"}}],[11,"write_fmt","","",108,{"inputs":[{"name":"self"},{"name":"arguments"}],"output":{"generics":["error"],"name":"result"}}],[11,"as_ref","alloc::slice","",95,null],[11,"clone","alloc::str","",89,{"inputs":[{"name":"self"}],"output":{"name":"split"}}],[11,"clone","alloc::slice","",92,{"inputs":[{"name":"self"}],"output":{"name":"split"}}],[11,"clone","","",104,{"inputs":[{"name":"self"}],"output":{"name":"chunks"}}],[11,"clone","","",105,{"inputs":[{"name":"self"}],"output":{"name":"rsplit"}}],[11,"clone","alloc::str","",102,{"inputs":[{"name":"self"}],"output":{"name":"lines"}}],[11,"clone","alloc::str::pattern","",109,{"inputs":[{"name":"self"}],"output":{"name":"strsearcher"}}],[11,"clone","alloc::str","",87,{"inputs":[{"name":"self"}],"output":{"name":"matchindices"}}],[11,"clone","","",79,{"inputs":[{"name":"self"}],"output":{"name":"rsplit"}}],[11,"clone","alloc::slice","",76,{"inputs":[{"name":"self"}],"output":{"name":"exactchunks"}}],[11,"clone","alloc::str","",93,{"inputs":[{"name":"self"}],"output":{"name":"chars"}}],[11,"clone","alloc::slice","",94,{"inputs":[{"name":"self"}],"output":{"name":"windows"}}],[11,"clone","alloc::str","",88,{"inputs":[{"name":"self"}],"output":{"name":"linesany"}}],[11,"clone","","",100,{"inputs":[{"name":"self"}],"output":{"name":"rsplitterminator"}}],[11,"clone","","",97,{"inputs":[{"name":"self"}],"output":{"name":"splitterminator"}}],[11,"clone","alloc::str::pattern","",110,{"inputs":[{"name":"self"}],"output":{"name":"charsearcher"}}],[11,"clone","alloc::str","",99,{"inputs":[{"name":"self"}],"output":{"name":"splitn"}}],[11,"clone","","",96,{"inputs":[{"name":"self"}],"output":{"name":"splitwhitespace"}}],[11,"clone","alloc::str::pattern","",111,{"inputs":[{"name":"self"}],"output":{"name":"charpredicatesearcher"}}],[11,"clone","alloc::str","",112,{"inputs":[{"name":"self"}],"output":{"name":"utf8error"}}],[11,"clone","","",103,{"inputs":[{"name":"self"}],"output":{"name":"matches"}}],[11,"clone","alloc::str::pattern","",113,{"inputs":[{"name":"self"}],"output":{"name":"charslicesearcher"}}],[11,"clone","alloc::str","",78,{"inputs":[{"name":"self"}],"output":{"name":"rmatches"}}],[11,"clone","","",114,{"inputs":[{"name":"self"}],"output":{"name":"parseboolerror"}}],[11,"clone","","",83,{"inputs":[{"name":"self"}],"output":{"name":"rmatchindices"}}],[11,"clone","","",84,{"inputs":[{"name":"self"}],"output":{"name":"bytes"}}],[11,"clone","alloc::fmt","",115,{"inputs":[{"name":"self"}],"output":{"name":"error"}}],[11,"clone","alloc::str","",86,{"inputs":[{"name":"self"}],"output":{"name":"encodeutf16"}}],[11,"clone","","",106,{"inputs":[{"name":"self"}],"output":{"name":"rsplitn"}}],[11,"clone","","",98,{"inputs":[{"name":"self"}],"output":{"name":"charindices"}}],[11,"clone","alloc::slice","",95,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"clone","alloc::fmt","",116,{"inputs":[{"name":"self"}],"output":{"name":"arguments"}}],[11,"clone","alloc::str::pattern","",37,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"partial_cmp","alloc::fmt","",115,{"inputs":[{"name":"self"},{"name":"error"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"next_back","alloc::slice","",101,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","alloc::str","",103,{"inputs":[{"name":"self"}],"output":{"generics":["str"],"name":"option"}}],[11,"next_back","alloc::slice","",82,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","alloc::str","",78,{"inputs":[{"name":"self"}],"output":{"generics":["str"],"name":"option"}}],[11,"next_back","","",83,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","alloc::slice","",92,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",94,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","alloc::str","",102,{"inputs":[{"name":"self"}],"output":{"generics":["str"],"name":"option"}}],[11,"next_back","","",93,{"inputs":[{"name":"self"}],"output":{"generics":["char"],"name":"option"}}],[11,"next_back","","",98,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",100,{"inputs":[{"name":"self"}],"output":{"generics":["str"],"name":"option"}}],[11,"next_back","","",88,{"inputs":[{"name":"self"}],"output":{"generics":["str"],"name":"option"}}],[11,"next_back","alloc::slice","",95,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"try_rfold","","",95,{"inputs":[{"name":"self"},{"name":"b"},{"name":"f"}],"output":{"name":"r"}}],[11,"rfold","","",95,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"acc"}}],[11,"next_back","","",77,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",81,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"try_rfold","","",81,{"inputs":[{"name":"self"},{"name":"b"},{"name":"f"}],"output":{"name":"r"}}],[11,"rfold","","",81,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"acc"}}],[11,"next_back","","",105,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","alloc::str","",97,{"inputs":[{"name":"self"}],"output":{"generics":["str"],"name":"option"}}],[11,"next_back","","",96,{"inputs":[{"name":"self"}],"output":{"generics":["str"],"name":"option"}}],[11,"next_back","","",84,{"inputs":[{"name":"self"}],"output":{"generics":["u8"],"name":"option"}}],[11,"rfind","","",84,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"option"}}],[11,"next_back","","",79,{"inputs":[{"name":"self"}],"output":{"generics":["str"],"name":"option"}}],[11,"next_back","alloc::slice","",104,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","alloc::str","",87,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","alloc::slice","",80,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",76,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","alloc::str","",89,{"inputs":[{"name":"self"}],"output":{"generics":["str"],"name":"option"}}],[11,"cmp","alloc::fmt","",115,{"inputs":[{"name":"self"},{"name":"error"}],"output":{"name":"ordering"}}],[11,"hash","","",115,null],[11,"eq","","",115,{"inputs":[{"name":"self"},{"name":"error"}],"output":{"name":"bool"}}],[11,"eq","alloc::str::pattern","",37,{"inputs":[{"name":"self"},{"name":"searchstep"}],"output":{"name":"bool"}}],[11,"ne","","",37,{"inputs":[{"name":"self"},{"name":"searchstep"}],"output":{"name":"bool"}}],[11,"eq","alloc::str","",112,{"inputs":[{"name":"self"},{"name":"utf8error"}],"output":{"name":"bool"}}],[11,"ne","","",112,{"inputs":[{"name":"self"},{"name":"utf8error"}],"output":{"name":"bool"}}],[11,"eq","","",114,{"inputs":[{"name":"self"},{"name":"parseboolerror"}],"output":{"name":"bool"}}],[11,"ne","","",114,{"inputs":[{"name":"self"},{"name":"parseboolerror"}],"output":{"name":"bool"}}],[11,"next_back","alloc::str::pattern","",113,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match_back","","",113,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject_back","","",113,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",111,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match_back","","",111,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject_back","","",111,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",109,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match_back","","",109,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",110,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match_back","","",110,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"is_empty","alloc::slice","",76,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_empty","","",95,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_empty","","",101,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"len","alloc::str","",84,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","",84,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_empty","alloc::slice","",81,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"fmt","alloc::str","",112,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"generics":["error"],"name":"result"}}],[11,"fmt","alloc::fmt","",116,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"generics":["error"],"name":"result"}}],[11,"fmt","alloc::str","",114,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"generics":["error"],"name":"result"}}],[11,"fmt","alloc::fmt","",115,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"generics":["error"],"name":"result"}}],[11,"haystack","alloc::str::pattern","",110,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"next","","",110,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match","","",110,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"haystack","","",111,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"next","","",111,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match","","",111,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject","","",111,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"haystack","","",113,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"next","","",113,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match","","",113,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject","","",113,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"haystack","","",109,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"next","","",109,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match","","",109,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"default","alloc::fmt","",115,{"inputs":[],"output":{"name":"error"}}],[11,"fmt","alloc::str::pattern","",109,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"generics":["error"],"name":"result"}}],[11,"fmt","alloc::str","",100,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"generics":["error"],"name":"result"}}],[11,"fmt","","",114,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"generics":["error"],"name":"result"}}],[11,"fmt","","",103,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"generics":["error"],"name":"result"}}],[11,"fmt","","",83,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"generics":["error"],"name":"result"}}],[11,"fmt","alloc::fmt","",116,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"generics":["error"],"name":"result"}}],[11,"fmt","alloc::slice","",107,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"generics":["error"],"name":"result"}}],[11,"fmt","alloc::str","",106,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"generics":["error"],"name":"result"}}],[11,"fmt","","",86,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"generics":["error"],"name":"result"}}],[11,"fmt","alloc::fmt","",115,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"generics":["error"],"name":"result"}}],[11,"fmt","alloc::slice","",94,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"generics":["error"],"name":"result"}}],[11,"fmt","alloc::str","",112,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"generics":["error"],"name":"result"}}],[11,"fmt","alloc::slice","",80,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"generics":["error"],"name":"result"}}],[11,"fmt","","",101,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"generics":["error"],"name":"result"}}],[11,"fmt","alloc::str","",84,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"generics":["error"],"name":"result"}}],[11,"fmt","alloc::slice","",91,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"generics":["error"],"name":"result"}}],[11,"fmt","alloc::str","",89,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"generics":["error"],"name":"result"}}],[11,"fmt","alloc::slice","",81,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"generics":["error"],"name":"result"}}],[11,"fmt","alloc::str","",79,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"generics":["error"],"name":"result"}}],[11,"fmt","alloc::slice","",104,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"generics":["error"],"name":"result"}}],[11,"fmt","","",77,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"generics":["error"],"name":"result"}}],[11,"fmt","","",76,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"generics":["error"],"name":"result"}}],[11,"fmt","alloc::str","",98,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"generics":["error"],"name":"result"}}],[11,"fmt","alloc::str::pattern","",37,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"generics":["error"],"name":"result"}}],[11,"fmt","alloc::slice","",105,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"generics":["error"],"name":"result"}}],[11,"fmt","alloc::str::pattern","",111,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"generics":["error"],"name":"result"}}],[11,"fmt","alloc::slice","",90,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"generics":["error"],"name":"result"}}],[11,"fmt","alloc::str::pattern","",113,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"generics":["error"],"name":"result"}}],[11,"fmt","alloc::str","",87,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"generics":["error"],"name":"result"}}],[11,"fmt","alloc::slice","",82,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"generics":["error"],"name":"result"}}],[11,"fmt","alloc::str","",93,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"generics":["error"],"name":"result"}}],[11,"fmt","","",102,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"generics":["error"],"name":"result"}}],[11,"fmt","alloc::slice","",85,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"generics":["error"],"name":"result"}}],[11,"fmt","alloc::str","",97,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"generics":["error"],"name":"result"}}],[11,"fmt","alloc::slice","",95,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"generics":["error"],"name":"result"}}],[11,"fmt","alloc::str","",88,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"generics":["error"],"name":"result"}}],[11,"fmt","","",99,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"generics":["error"],"name":"result"}}],[11,"fmt","alloc::slice","",92,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"generics":["error"],"name":"result"}}],[11,"fmt","alloc::str","",78,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"generics":["error"],"name":"result"}}],[11,"fmt","alloc::str::pattern","",110,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"generics":["error"],"name":"result"}}],[11,"fmt","alloc::str","",96,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"generics":["error"],"name":"result"}}],[11,"pad_integral","alloc::fmt","Performs the correct padding for an integer which has already been emitted into a str. The str should not contain the sign for the integer, that will be added by this method.",108,{"inputs":[{"name":"self"},{"name":"bool"},{"name":"str"},{"name":"str"}],"output":{"generics":["error"],"name":"result"}}],[11,"pad","","This function takes a string slice and emits it to the internal buffer after applying the relevant formatting flags specified. The flags recognized for generic strings are:",108,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"generics":["error"],"name":"result"}}],[11,"write_str","","Writes some data to the underlying buffer contained within this formatter.",108,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"generics":["error"],"name":"result"}}],[11,"write_fmt","","Writes some formatted information into this instance",108,{"inputs":[{"name":"self"},{"name":"arguments"}],"output":{"generics":["error"],"name":"result"}}],[11,"flags","","Flags for formatting",108,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"fill","","Character used as 'fill' whenever there is alignment",108,{"inputs":[{"name":"self"}],"output":{"name":"char"}}],[11,"align","","Flag indicating what form of alignment was requested",108,{"inputs":[{"name":"self"}],"output":{"name":"alignment"}}],[11,"width","","Optionally specified integer width that the output should be.",108,{"inputs":[{"name":"self"}],"output":{"generics":["usize"],"name":"option"}}],[11,"precision","","Optionally specified precision for numeric types.",108,{"inputs":[{"name":"self"}],"output":{"generics":["usize"],"name":"option"}}],[11,"sign_plus","","Determines if the `+` flag was specified.",108,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"sign_minus","","Determines if the `-` flag was specified.",108,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"alternate","","Determines if the `#` flag was specified.",108,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"sign_aware_zero_pad","","Determines if the `0` flag was specified.",108,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"debug_struct","","Creates a [`DebugStruct`] builder designed to assist with creation of [`fmt::Debug`] implementations for structs.",108,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"debugstruct"}}],[11,"debug_tuple","","Creates a `DebugTuple` builder designed to assist with creation of `fmt::Debug` implementations for tuple structs.",108,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"debugtuple"}}],[11,"debug_list","","Creates a `DebugList` builder designed to assist with creation of `fmt::Debug` implementations for list-like structures.",108,{"inputs":[{"name":"self"}],"output":{"name":"debuglist"}}],[11,"debug_set","","Creates a `DebugSet` builder designed to assist with creation of `fmt::Debug` implementations for set-like structures.",108,{"inputs":[{"name":"self"}],"output":{"name":"debugset"}}],[11,"debug_map","","Creates a `DebugMap` builder designed to assist with creation of `fmt::Debug` implementations for map-like structures.",108,{"inputs":[{"name":"self"}],"output":{"name":"debugmap"}}],[11,"entry","","Adds a new entry to the list output.",117,{"inputs":[{"name":"self"},{"name":"debug"}],"output":{"name":"debuglist"}}],[11,"entries","","Adds the contents of an iterator of entries to the list output.",117,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"debuglist"}}],[11,"finish","","Finishes output and returns any error encountered.",117,{"inputs":[{"name":"self"}],"output":{"generics":["error"],"name":"result"}}],[11,"entry","","Adds a new entry to the map output.",118,{"inputs":[{"name":"self"},{"name":"debug"},{"name":"debug"}],"output":{"name":"debugmap"}}],[11,"entries","","Adds the contents of an iterator of entries to the map output.",118,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"debugmap"}}],[11,"finish","","Finishes output and returns any error encountered.",118,{"inputs":[{"name":"self"}],"output":{"generics":["error"],"name":"result"}}],[11,"entry","","Adds a new entry to the set output.",119,{"inputs":[{"name":"self"},{"name":"debug"}],"output":{"name":"debugset"}}],[11,"entries","","Adds the contents of an iterator of entries to the set output.",119,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"debugset"}}],[11,"finish","","Finishes output and returns any error encountered.",119,{"inputs":[{"name":"self"}],"output":{"generics":["error"],"name":"result"}}],[11,"field","","Adds a new field to the generated struct output.",120,{"inputs":[{"name":"self"},{"name":"str"},{"name":"debug"}],"output":{"name":"debugstruct"}}],[11,"finish","","Finishes output and returns any error encountered.",120,{"inputs":[{"name":"self"}],"output":{"generics":["error"],"name":"result"}}],[11,"field","","Adds a new field to the generated tuple struct output.",121,{"inputs":[{"name":"self"},{"name":"debug"}],"output":{"name":"debugtuple"}}],[11,"finish","","Finishes output and returns any error encountered.",121,{"inputs":[{"name":"self"}],"output":{"generics":["error"],"name":"result"}}],[11,"as_slice","alloc::slice","View the underlying data as a subslice of the original data.",95,null],[11,"into_slice","","View the underlying data as a subslice of the original data.",81,null],[11,"borrow","alloc::vec","",46,null],[11,"borrow_mut","","",46,null],[11,"valid_up_to","alloc::str","Returns the index in the given string up to which valid UTF-8 was verified.",112,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"error_len","","Provide more information about the failure:",112,{"inputs":[{"name":"self"}],"output":{"generics":["usize"],"name":"option"}}],[11,"as_str","","View the underlying data as a subslice of the original data.",93,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"as_str","","View the underlying data as a subslice of the original data.",98,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"borrow","alloc::string","",41,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"from","alloc::vec","",46,{"inputs":[{"name":"string"}],"output":{"generics":["u8"],"name":"vec"}}]],"paths":[[3,"Global"],[8,"FnBox"],[3,"Box"],[3,"PinBox"],[3,"Weak"],[3,"Arc"],[3,"Rc"],[3,"Weak"],[3,"RawVec"],[3,"PeekMut"],[3,"BinaryHeap"],[3,"Iter"],[3,"IntoIter"],[3,"Drain"],[8,"Borrow"],[8,"BorrowMut"],[4,"Cow"],[8,"ToOwned"],[8,"Write"],[8,"Binary"],[8,"Octal"],[8,"Debug"],[8,"Display"],[8,"LowerHex"],[8,"Pointer"],[8,"UpperHex"],[8,"LowerExp"],[8,"UpperExp"],[3,"Iter"],[3,"IterMut"],[3,"IntoIter"],[3,"LinkedList"],[3,"DrainFilter"],[8,"SliceIndex"],[8,"SliceConcatExt"],[8,"FromStr"],[8,"Pattern"],[4,"SearchStep"],[8,"Searcher"],[8,"ReverseSearcher"],[8,"ToString"],[3,"String"],[3,"FromUtf8Error"],[3,"FromUtf16Error"],[4,"ParseError"],[3,"Drain"],[3,"Vec"],[3,"IntoIter"],[3,"Drain"],[3,"Splice"],[3,"DrainFilter"],[3,"VecDeque"],[3,"Iter"],[3,"IterMut"],[3,"IntoIter"],[3,"Drain"],[4,"Entry"],[3,"BTreeMap"],[3,"Iter"],[3,"IterMut"],[3,"IntoIter"],[3,"Keys"],[3,"Values"],[3,"ValuesMut"],[3,"Range"],[3,"RangeMut"],[3,"VacantEntry"],[3,"OccupiedEntry"],[3,"BTreeSet"],[3,"Iter"],[3,"IntoIter"],[3,"Range"],[3,"Difference"],[3,"SymmetricDifference"],[3,"Intersection"],[3,"Union"],[3,"ExactChunks"],[3,"SplitMut"],[3,"RMatches"],[3,"RSplit"],[3,"RSplitMut"],[3,"IterMut"],[3,"ChunksMut"],[3,"RMatchIndices"],[3,"Bytes"],[3,"SplitNMut"],[3,"EncodeUtf16"],[3,"MatchIndices"],[3,"LinesAny"],[3,"Split"],[3,"RSplitNMut"],[3,"RSplitN"],[3,"Split"],[3,"Chars"],[3,"Windows"],[3,"Iter"],[3,"SplitWhitespace"],[3,"SplitTerminator"],[3,"CharIndices"],[3,"SplitN"],[3,"RSplitTerminator"],[3,"ExactChunksMut"],[3,"Lines"],[3,"Matches"],[3,"Chunks"],[3,"RSplit"],[3,"RSplitN"],[3,"SplitN"],[3,"Formatter"],[3,"StrSearcher"],[3,"CharSearcher"],[3,"CharPredicateSearcher"],[3,"Utf8Error"],[3,"CharSliceSearcher"],[3,"ParseBoolError"],[3,"Error"],[3,"Arguments"],[3,"DebugList"],[3,"DebugMap"],[3,"DebugSet"],[3,"DebugStruct"],[3,"DebugTuple"]]};
searchIndex["core"] = {"doc":"The Rust Core Library","items":[[0,"isize","core","The pointer-sized signed integer type.",null,null],[17,"MIN","core::isize","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"i8","core","The 8-bit signed integer type.",null,null],[17,"MIN","core::i8","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"i16","core","The 16-bit signed integer type.",null,null],[17,"MIN","core::i16","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"i32","core","The 32-bit signed integer type.",null,null],[17,"MIN","core::i32","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"i64","core","The 64-bit signed integer type.",null,null],[17,"MIN","core::i64","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"i128","core","The 128-bit signed integer type.",null,null],[17,"MIN","core::i128","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"usize","core","The pointer-sized unsigned integer type.",null,null],[17,"MIN","core::usize","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"u8","core","The 8-bit unsigned integer type.",null,null],[17,"MIN","core::u8","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"u16","core","The 16-bit unsigned integer type.",null,null],[17,"MIN","core::u16","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"u32","core","The 32-bit unsigned integer type.",null,null],[17,"MIN","core::u32","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"u64","core","The 64-bit unsigned integer type.",null,null],[17,"MIN","core::u64","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"u128","core","The 128-bit unsigned integer type.",null,null],[17,"MIN","core::u128","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"f32","core","This module provides constants which are specific to the implementation of the `f32` floating point data type.",null,null],[0,"consts","core::f32","Basic mathematical constants.",null,null],[17,"PI","core::f32::consts","Archimedes' constant (π)",null,null],[17,"FRAC_PI_2","","π/2",null,null],[17,"FRAC_PI_3","","π/3",null,null],[17,"FRAC_PI_4","","π/4",null,null],[17,"FRAC_PI_6","","π/6",null,null],[17,"FRAC_PI_8","","π/8",null,null],[17,"FRAC_1_PI","","1/π",null,null],[17,"FRAC_2_PI","","2/π",null,null],[17,"FRAC_2_SQRT_PI","","2/sqrt(π)",null,null],[17,"SQRT_2","","sqrt(2)",null,null],[17,"FRAC_1_SQRT_2","","1/sqrt(2)",null,null],[17,"E","","Euler's number (e)",null,null],[17,"LOG2_E","","log2(e)",null,null],[17,"LOG10_E","","log10(e)",null,null],[17,"LN_2","","ln(2)",null,null],[17,"LN_10","","ln(10)",null,null],[17,"RADIX","core::f32","The radix or base of the internal representation of `f32`.",null,null],[17,"MANTISSA_DIGITS","","Number of significant digits in base 2.",null,null],[17,"DIGITS","","Approximate number of significant digits in base 10.",null,null],[17,"EPSILON","","Difference between `1.0` and the next largest representable number.",null,null],[17,"MIN","","Smallest finite `f32` value.",null,null],[17,"MIN_POSITIVE","","Smallest positive normal `f32` value.",null,null],[17,"MAX","","Largest finite `f32` value.",null,null],[17,"MIN_EXP","","One greater than the minimum possible normal power of 2 exponent.",null,null],[17,"MAX_EXP","","Maximum possible power of 2 exponent.",null,null],[17,"MIN_10_EXP","","Minimum possible normal power of 10 exponent.",null,null],[17,"MAX_10_EXP","","Maximum possible power of 10 exponent.",null,null],[17,"NAN","","Not a Number (NaN).",null,null],[17,"INFINITY","","Infinity (∞).",null,null],[17,"NEG_INFINITY","","Negative infinity (-∞).",null,null],[0,"f64","core","This module provides constants which are specific to the implementation of the `f64` floating point data type.",null,null],[0,"consts","core::f64","Basic mathematical constants.",null,null],[17,"PI","core::f64::consts","Archimedes' constant (π)",null,null],[17,"FRAC_PI_2","","π/2",null,null],[17,"FRAC_PI_3","","π/3",null,null],[17,"FRAC_PI_4","","π/4",null,null],[17,"FRAC_PI_6","","π/6",null,null],[17,"FRAC_PI_8","","π/8",null,null],[17,"FRAC_1_PI","","1/π",null,null],[17,"FRAC_2_PI","","2/π",null,null],[17,"FRAC_2_SQRT_PI","","2/sqrt(π)",null,null],[17,"SQRT_2","","sqrt(2)",null,null],[17,"FRAC_1_SQRT_2","","1/sqrt(2)",null,null],[17,"E","","Euler's number (e)",null,null],[17,"LOG2_E","","log2(e)",null,null],[17,"LOG10_E","","log10(e)",null,null],[17,"LN_2","","ln(2)",null,null],[17,"LN_10","","ln(10)",null,null],[17,"RADIX","core::f64","The radix or base of the internal representation of `f64`.",null,null],[17,"MANTISSA_DIGITS","","Number of significant digits in base 2.",null,null],[17,"DIGITS","","Approximate number of significant digits in base 10.",null,null],[17,"EPSILON","","Difference between `1.0` and the next largest representable number.",null,null],[17,"MIN","","Smallest finite `f64` value.",null,null],[17,"MIN_POSITIVE","","Smallest positive normal `f64` value.",null,null],[17,"MAX","","Largest finite `f64` value.",null,null],[17,"MIN_EXP","","One greater than the minimum possible normal power of 2 exponent.",null,null],[17,"MAX_EXP","","Maximum possible power of 2 exponent.",null,null],[17,"MIN_10_EXP","","Minimum possible normal power of 10 exponent.",null,null],[17,"MAX_10_EXP","","Maximum possible power of 10 exponent.",null,null],[17,"NAN","","Not a Number (NaN).",null,null],[17,"INFINITY","","Infinity (∞).",null,null],[17,"NEG_INFINITY","","Negative infinity (-∞).",null,null],[0,"num","core","Numeric traits and functions for the built-in numeric types.",null,null],[3,"NonZeroU8","core::num","An integer that is known not to equal zero.",null,null],[3,"NonZeroU16","","An integer that is known not to equal zero.",null,null],[3,"NonZeroU32","","An integer that is known not to equal zero.",null,null],[3,"NonZeroU64","","An integer that is known not to equal zero.",null,null],[3,"NonZeroU128","","An integer that is known not to equal zero.",null,null],[3,"NonZeroUsize","","An integer that is known not to equal zero.",null,null],[3,"NonZeroI8","","An integer that is known not to equal zero.",null,null],[3,"NonZeroI16","","An integer that is known not to equal zero.",null,null],[3,"NonZeroI32","","An integer that is known not to equal zero.",null,null],[3,"NonZeroI64","","An integer that is known not to equal zero.",null,null],[3,"NonZeroI128","","An integer that is known not to equal zero.",null,null],[3,"NonZeroIsize","","An integer that is known not to equal zero.",null,null],[3,"Wrapping","","Provides intentionally-wrapped arithmetic on `T`.",null,null],[12,"0","","",0,null],[3,"TryFromIntError","","The error type returned when a checked integral type conversion fails.",null,null],[3,"ParseIntError","","An error which can be returned when parsing an integer.",null,null],[3,"ParseFloatError","","An error which can be returned when parsing a float.",null,null],[4,"FpCategory","","A classification of floating point numbers.",null,null],[13,"Nan","","\"Not a Number\", often obtained by dividing by zero.",1,null],[13,"Infinite","","Positive or negative infinity.",1,null],[13,"Zero","","Positive or negative zero.",1,null],[13,"Subnormal","","De-normalized floating point representation (less precise than `Normal`).",1,null],[13,"Normal","","A regular floating point number.",1,null],[11,"shl","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"generics":["u8"],"name":"wrapping"}}],[11,"shl_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shl_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shr","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"generics":["u8"],"name":"wrapping"}}],[11,"shr_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shr_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shl","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"generics":["u16"],"name":"wrapping"}}],[11,"shl_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shl_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shr","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"generics":["u16"],"name":"wrapping"}}],[11,"shr_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shr_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shl","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"generics":["u32"],"name":"wrapping"}}],[11,"shl_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shl_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shr","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"generics":["u32"],"name":"wrapping"}}],[11,"shr_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shr_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shl","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"generics":["u64"],"name":"wrapping"}}],[11,"shl_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shl_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shr","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"generics":["u64"],"name":"wrapping"}}],[11,"shr_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shr_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shl","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"generics":["usize"],"name":"wrapping"}}],[11,"shl_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shl_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shr","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"generics":["usize"],"name":"wrapping"}}],[11,"shr_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shr_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shl","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"generics":["i8"],"name":"wrapping"}}],[11,"shl_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shl_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shr","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"generics":["i8"],"name":"wrapping"}}],[11,"shr_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shr_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shl","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"generics":["i16"],"name":"wrapping"}}],[11,"shl_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shl_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shr","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"generics":["i16"],"name":"wrapping"}}],[11,"shr_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shr_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shl","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"generics":["i32"],"name":"wrapping"}}],[11,"shl_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shl_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shr","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"generics":["i32"],"name":"wrapping"}}],[11,"shr_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shr_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shl","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"generics":["i64"],"name":"wrapping"}}],[11,"shl_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shl_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shr","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"generics":["i64"],"name":"wrapping"}}],[11,"shr_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shr_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shl","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"generics":["isize"],"name":"wrapping"}}],[11,"shl_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shl_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shr","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"generics":["isize"],"name":"wrapping"}}],[11,"shr_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shr_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"add","","",0,{"inputs":[{"name":"self"},{"generics":["usize"],"name":"wrapping"}],"output":{"generics":["usize"],"name":"wrapping"}}],[11,"add","","",0,null],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"generics":["usize"],"name":"wrapping"}],"output":null}],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"sub","","",0,{"inputs":[{"name":"self"},{"generics":["usize"],"name":"wrapping"}],"output":{"generics":["usize"],"name":"wrapping"}}],[11,"sub","","",0,null],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"generics":["usize"],"name":"wrapping"}],"output":null}],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"mul","","",0,{"inputs":[{"name":"self"},{"generics":["usize"],"name":"wrapping"}],"output":{"generics":["usize"],"name":"wrapping"}}],[11,"mul","","",0,null],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"generics":["usize"],"name":"wrapping"}],"output":null}],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"div","","",0,{"inputs":[{"name":"self"},{"generics":["usize"],"name":"wrapping"}],"output":{"generics":["usize"],"name":"wrapping"}}],[11,"div","","",0,null],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"generics":["usize"],"name":"wrapping"}],"output":null}],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"rem","","",0,{"inputs":[{"name":"self"},{"generics":["usize"],"name":"wrapping"}],"output":{"generics":["usize"],"name":"wrapping"}}],[11,"rem","","",0,null],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"generics":["usize"],"name":"wrapping"}],"output":null}],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"not","","",0,{"inputs":[{"name":"self"}],"output":{"generics":["usize"],"name":"wrapping"}}],[11,"bitxor","","",0,{"inputs":[{"name":"self"},{"generics":["usize"],"name":"wrapping"}],"output":{"generics":["usize"],"name":"wrapping"}}],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"generics":["usize"],"name":"wrapping"}],"output":null}],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitor","","",0,{"inputs":[{"name":"self"},{"generics":["usize"],"name":"wrapping"}],"output":{"generics":["usize"],"name":"wrapping"}}],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"generics":["usize"],"name":"wrapping"}],"output":null}],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitand","","",0,{"inputs":[{"name":"self"},{"generics":["usize"],"name":"wrapping"}],"output":{"generics":["usize"],"name":"wrapping"}}],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"generics":["usize"],"name":"wrapping"}],"output":null}],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"neg","","",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"add","","",0,{"inputs":[{"name":"self"},{"generics":["u8"],"name":"wrapping"}],"output":{"generics":["u8"],"name":"wrapping"}}],[11,"add","","",0,null],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"generics":["u8"],"name":"wrapping"}],"output":null}],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"sub","","",0,{"inputs":[{"name":"self"},{"generics":["u8"],"name":"wrapping"}],"output":{"generics":["u8"],"name":"wrapping"}}],[11,"sub","","",0,null],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"generics":["u8"],"name":"wrapping"}],"output":null}],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"mul","","",0,{"inputs":[{"name":"self"},{"generics":["u8"],"name":"wrapping"}],"output":{"generics":["u8"],"name":"wrapping"}}],[11,"mul","","",0,null],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"generics":["u8"],"name":"wrapping"}],"output":null}],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"div","","",0,{"inputs":[{"name":"self"},{"generics":["u8"],"name":"wrapping"}],"output":{"generics":["u8"],"name":"wrapping"}}],[11,"div","","",0,null],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"generics":["u8"],"name":"wrapping"}],"output":null}],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"rem","","",0,{"inputs":[{"name":"self"},{"generics":["u8"],"name":"wrapping"}],"output":{"generics":["u8"],"name":"wrapping"}}],[11,"rem","","",0,null],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"generics":["u8"],"name":"wrapping"}],"output":null}],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"not","","",0,{"inputs":[{"name":"self"}],"output":{"generics":["u8"],"name":"wrapping"}}],[11,"bitxor","","",0,{"inputs":[{"name":"self"},{"generics":["u8"],"name":"wrapping"}],"output":{"generics":["u8"],"name":"wrapping"}}],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"generics":["u8"],"name":"wrapping"}],"output":null}],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitor","","",0,{"inputs":[{"name":"self"},{"generics":["u8"],"name":"wrapping"}],"output":{"generics":["u8"],"name":"wrapping"}}],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"generics":["u8"],"name":"wrapping"}],"output":null}],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitand","","",0,{"inputs":[{"name":"self"},{"generics":["u8"],"name":"wrapping"}],"output":{"generics":["u8"],"name":"wrapping"}}],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"generics":["u8"],"name":"wrapping"}],"output":null}],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"neg","","",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"add","","",0,{"inputs":[{"name":"self"},{"generics":["u16"],"name":"wrapping"}],"output":{"generics":["u16"],"name":"wrapping"}}],[11,"add","","",0,null],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"generics":["u16"],"name":"wrapping"}],"output":null}],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"sub","","",0,{"inputs":[{"name":"self"},{"generics":["u16"],"name":"wrapping"}],"output":{"generics":["u16"],"name":"wrapping"}}],[11,"sub","","",0,null],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"generics":["u16"],"name":"wrapping"}],"output":null}],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"mul","","",0,{"inputs":[{"name":"self"},{"generics":["u16"],"name":"wrapping"}],"output":{"generics":["u16"],"name":"wrapping"}}],[11,"mul","","",0,null],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"generics":["u16"],"name":"wrapping"}],"output":null}],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"div","","",0,{"inputs":[{"name":"self"},{"generics":["u16"],"name":"wrapping"}],"output":{"generics":["u16"],"name":"wrapping"}}],[11,"div","","",0,null],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"generics":["u16"],"name":"wrapping"}],"output":null}],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"rem","","",0,{"inputs":[{"name":"self"},{"generics":["u16"],"name":"wrapping"}],"output":{"generics":["u16"],"name":"wrapping"}}],[11,"rem","","",0,null],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"generics":["u16"],"name":"wrapping"}],"output":null}],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"not","","",0,{"inputs":[{"name":"self"}],"output":{"generics":["u16"],"name":"wrapping"}}],[11,"bitxor","","",0,{"inputs":[{"name":"self"},{"generics":["u16"],"name":"wrapping"}],"output":{"generics":["u16"],"name":"wrapping"}}],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"generics":["u16"],"name":"wrapping"}],"output":null}],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitor","","",0,{"inputs":[{"name":"self"},{"generics":["u16"],"name":"wrapping"}],"output":{"generics":["u16"],"name":"wrapping"}}],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"generics":["u16"],"name":"wrapping"}],"output":null}],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitand","","",0,{"inputs":[{"name":"self"},{"generics":["u16"],"name":"wrapping"}],"output":{"generics":["u16"],"name":"wrapping"}}],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"generics":["u16"],"name":"wrapping"}],"output":null}],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"neg","","",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"add","","",0,{"inputs":[{"name":"self"},{"generics":["u32"],"name":"wrapping"}],"output":{"generics":["u32"],"name":"wrapping"}}],[11,"add","","",0,null],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"generics":["u32"],"name":"wrapping"}],"output":null}],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"sub","","",0,{"inputs":[{"name":"self"},{"generics":["u32"],"name":"wrapping"}],"output":{"generics":["u32"],"name":"wrapping"}}],[11,"sub","","",0,null],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"generics":["u32"],"name":"wrapping"}],"output":null}],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"mul","","",0,{"inputs":[{"name":"self"},{"generics":["u32"],"name":"wrapping"}],"output":{"generics":["u32"],"name":"wrapping"}}],[11,"mul","","",0,null],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"generics":["u32"],"name":"wrapping"}],"output":null}],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"div","","",0,{"inputs":[{"name":"self"},{"generics":["u32"],"name":"wrapping"}],"output":{"generics":["u32"],"name":"wrapping"}}],[11,"div","","",0,null],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"generics":["u32"],"name":"wrapping"}],"output":null}],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"rem","","",0,{"inputs":[{"name":"self"},{"generics":["u32"],"name":"wrapping"}],"output":{"generics":["u32"],"name":"wrapping"}}],[11,"rem","","",0,null],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"generics":["u32"],"name":"wrapping"}],"output":null}],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"not","","",0,{"inputs":[{"name":"self"}],"output":{"generics":["u32"],"name":"wrapping"}}],[11,"bitxor","","",0,{"inputs":[{"name":"self"},{"generics":["u32"],"name":"wrapping"}],"output":{"generics":["u32"],"name":"wrapping"}}],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"generics":["u32"],"name":"wrapping"}],"output":null}],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitor","","",0,{"inputs":[{"name":"self"},{"generics":["u32"],"name":"wrapping"}],"output":{"generics":["u32"],"name":"wrapping"}}],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"generics":["u32"],"name":"wrapping"}],"output":null}],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitand","","",0,{"inputs":[{"name":"self"},{"generics":["u32"],"name":"wrapping"}],"output":{"generics":["u32"],"name":"wrapping"}}],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"generics":["u32"],"name":"wrapping"}],"output":null}],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"neg","","",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"add","","",0,{"inputs":[{"name":"self"},{"generics":["u64"],"name":"wrapping"}],"output":{"generics":["u64"],"name":"wrapping"}}],[11,"add","","",0,null],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"generics":["u64"],"name":"wrapping"}],"output":null}],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"sub","","",0,{"inputs":[{"name":"self"},{"generics":["u64"],"name":"wrapping"}],"output":{"generics":["u64"],"name":"wrapping"}}],[11,"sub","","",0,null],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"generics":["u64"],"name":"wrapping"}],"output":null}],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"mul","","",0,{"inputs":[{"name":"self"},{"generics":["u64"],"name":"wrapping"}],"output":{"generics":["u64"],"name":"wrapping"}}],[11,"mul","","",0,null],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"generics":["u64"],"name":"wrapping"}],"output":null}],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"div","","",0,{"inputs":[{"name":"self"},{"generics":["u64"],"name":"wrapping"}],"output":{"generics":["u64"],"name":"wrapping"}}],[11,"div","","",0,null],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"generics":["u64"],"name":"wrapping"}],"output":null}],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"rem","","",0,{"inputs":[{"name":"self"},{"generics":["u64"],"name":"wrapping"}],"output":{"generics":["u64"],"name":"wrapping"}}],[11,"rem","","",0,null],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"generics":["u64"],"name":"wrapping"}],"output":null}],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"not","","",0,{"inputs":[{"name":"self"}],"output":{"generics":["u64"],"name":"wrapping"}}],[11,"bitxor","","",0,{"inputs":[{"name":"self"},{"generics":["u64"],"name":"wrapping"}],"output":{"generics":["u64"],"name":"wrapping"}}],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"generics":["u64"],"name":"wrapping"}],"output":null}],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitor","","",0,{"inputs":[{"name":"self"},{"generics":["u64"],"name":"wrapping"}],"output":{"generics":["u64"],"name":"wrapping"}}],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"generics":["u64"],"name":"wrapping"}],"output":null}],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitand","","",0,{"inputs":[{"name":"self"},{"generics":["u64"],"name":"wrapping"}],"output":{"generics":["u64"],"name":"wrapping"}}],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"generics":["u64"],"name":"wrapping"}],"output":null}],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"neg","","",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"add","","",0,{"inputs":[{"name":"self"},{"generics":["u128"],"name":"wrapping"}],"output":{"generics":["u128"],"name":"wrapping"}}],[11,"add","","",0,null],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"generics":["u128"],"name":"wrapping"}],"output":null}],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"sub","","",0,{"inputs":[{"name":"self"},{"generics":["u128"],"name":"wrapping"}],"output":{"generics":["u128"],"name":"wrapping"}}],[11,"sub","","",0,null],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"generics":["u128"],"name":"wrapping"}],"output":null}],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"mul","","",0,{"inputs":[{"name":"self"},{"generics":["u128"],"name":"wrapping"}],"output":{"generics":["u128"],"name":"wrapping"}}],[11,"mul","","",0,null],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"generics":["u128"],"name":"wrapping"}],"output":null}],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"div","","",0,{"inputs":[{"name":"self"},{"generics":["u128"],"name":"wrapping"}],"output":{"generics":["u128"],"name":"wrapping"}}],[11,"div","","",0,null],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"generics":["u128"],"name":"wrapping"}],"output":null}],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"rem","","",0,{"inputs":[{"name":"self"},{"generics":["u128"],"name":"wrapping"}],"output":{"generics":["u128"],"name":"wrapping"}}],[11,"rem","","",0,null],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"generics":["u128"],"name":"wrapping"}],"output":null}],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"not","","",0,{"inputs":[{"name":"self"}],"output":{"generics":["u128"],"name":"wrapping"}}],[11,"bitxor","","",0,{"inputs":[{"name":"self"},{"generics":["u128"],"name":"wrapping"}],"output":{"generics":["u128"],"name":"wrapping"}}],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"generics":["u128"],"name":"wrapping"}],"output":null}],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitor","","",0,{"inputs":[{"name":"self"},{"generics":["u128"],"name":"wrapping"}],"output":{"generics":["u128"],"name":"wrapping"}}],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"generics":["u128"],"name":"wrapping"}],"output":null}],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitand","","",0,{"inputs":[{"name":"self"},{"generics":["u128"],"name":"wrapping"}],"output":{"generics":["u128"],"name":"wrapping"}}],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"generics":["u128"],"name":"wrapping"}],"output":null}],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"neg","","",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"add","","",0,{"inputs":[{"name":"self"},{"generics":["isize"],"name":"wrapping"}],"output":{"generics":["isize"],"name":"wrapping"}}],[11,"add","","",0,null],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"generics":["isize"],"name":"wrapping"}],"output":null}],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"sub","","",0,{"inputs":[{"name":"self"},{"generics":["isize"],"name":"wrapping"}],"output":{"generics":["isize"],"name":"wrapping"}}],[11,"sub","","",0,null],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"generics":["isize"],"name":"wrapping"}],"output":null}],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"mul","","",0,{"inputs":[{"name":"self"},{"generics":["isize"],"name":"wrapping"}],"output":{"generics":["isize"],"name":"wrapping"}}],[11,"mul","","",0,null],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"generics":["isize"],"name":"wrapping"}],"output":null}],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"div","","",0,{"inputs":[{"name":"self"},{"generics":["isize"],"name":"wrapping"}],"output":{"generics":["isize"],"name":"wrapping"}}],[11,"div","","",0,null],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"generics":["isize"],"name":"wrapping"}],"output":null}],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"rem","","",0,{"inputs":[{"name":"self"},{"generics":["isize"],"name":"wrapping"}],"output":{"generics":["isize"],"name":"wrapping"}}],[11,"rem","","",0,null],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"generics":["isize"],"name":"wrapping"}],"output":null}],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"not","","",0,{"inputs":[{"name":"self"}],"output":{"generics":["isize"],"name":"wrapping"}}],[11,"bitxor","","",0,{"inputs":[{"name":"self"},{"generics":["isize"],"name":"wrapping"}],"output":{"generics":["isize"],"name":"wrapping"}}],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"generics":["isize"],"name":"wrapping"}],"output":null}],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitor","","",0,{"inputs":[{"name":"self"},{"generics":["isize"],"name":"wrapping"}],"output":{"generics":["isize"],"name":"wrapping"}}],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"generics":["isize"],"name":"wrapping"}],"output":null}],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitand","","",0,{"inputs":[{"name":"self"},{"generics":["isize"],"name":"wrapping"}],"output":{"generics":["isize"],"name":"wrapping"}}],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"generics":["isize"],"name":"wrapping"}],"output":null}],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"neg","","",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"add","","",0,{"inputs":[{"name":"self"},{"generics":["i8"],"name":"wrapping"}],"output":{"generics":["i8"],"name":"wrapping"}}],[11,"add","","",0,null],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"generics":["i8"],"name":"wrapping"}],"output":null}],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"sub","","",0,{"inputs":[{"name":"self"},{"generics":["i8"],"name":"wrapping"}],"output":{"generics":["i8"],"name":"wrapping"}}],[11,"sub","","",0,null],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"generics":["i8"],"name":"wrapping"}],"output":null}],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"mul","","",0,{"inputs":[{"name":"self"},{"generics":["i8"],"name":"wrapping"}],"output":{"generics":["i8"],"name":"wrapping"}}],[11,"mul","","",0,null],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"generics":["i8"],"name":"wrapping"}],"output":null}],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"div","","",0,{"inputs":[{"name":"self"},{"generics":["i8"],"name":"wrapping"}],"output":{"generics":["i8"],"name":"wrapping"}}],[11,"div","","",0,null],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"generics":["i8"],"name":"wrapping"}],"output":null}],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"rem","","",0,{"inputs":[{"name":"self"},{"generics":["i8"],"name":"wrapping"}],"output":{"generics":["i8"],"name":"wrapping"}}],[11,"rem","","",0,null],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"generics":["i8"],"name":"wrapping"}],"output":null}],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"not","","",0,{"inputs":[{"name":"self"}],"output":{"generics":["i8"],"name":"wrapping"}}],[11,"bitxor","","",0,{"inputs":[{"name":"self"},{"generics":["i8"],"name":"wrapping"}],"output":{"generics":["i8"],"name":"wrapping"}}],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"generics":["i8"],"name":"wrapping"}],"output":null}],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitor","","",0,{"inputs":[{"name":"self"},{"generics":["i8"],"name":"wrapping"}],"output":{"generics":["i8"],"name":"wrapping"}}],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"generics":["i8"],"name":"wrapping"}],"output":null}],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitand","","",0,{"inputs":[{"name":"self"},{"generics":["i8"],"name":"wrapping"}],"output":{"generics":["i8"],"name":"wrapping"}}],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"generics":["i8"],"name":"wrapping"}],"output":null}],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"neg","","",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"add","","",0,{"inputs":[{"name":"self"},{"generics":["i16"],"name":"wrapping"}],"output":{"generics":["i16"],"name":"wrapping"}}],[11,"add","","",0,null],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"generics":["i16"],"name":"wrapping"}],"output":null}],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"sub","","",0,{"inputs":[{"name":"self"},{"generics":["i16"],"name":"wrapping"}],"output":{"generics":["i16"],"name":"wrapping"}}],[11,"sub","","",0,null],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"generics":["i16"],"name":"wrapping"}],"output":null}],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"mul","","",0,{"inputs":[{"name":"self"},{"generics":["i16"],"name":"wrapping"}],"output":{"generics":["i16"],"name":"wrapping"}}],[11,"mul","","",0,null],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"generics":["i16"],"name":"wrapping"}],"output":null}],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"div","","",0,{"inputs":[{"name":"self"},{"generics":["i16"],"name":"wrapping"}],"output":{"generics":["i16"],"name":"wrapping"}}],[11,"div","","",0,null],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"generics":["i16"],"name":"wrapping"}],"output":null}],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"rem","","",0,{"inputs":[{"name":"self"},{"generics":["i16"],"name":"wrapping"}],"output":{"generics":["i16"],"name":"wrapping"}}],[11,"rem","","",0,null],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"generics":["i16"],"name":"wrapping"}],"output":null}],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"not","","",0,{"inputs":[{"name":"self"}],"output":{"generics":["i16"],"name":"wrapping"}}],[11,"bitxor","","",0,{"inputs":[{"name":"self"},{"generics":["i16"],"name":"wrapping"}],"output":{"generics":["i16"],"name":"wrapping"}}],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"generics":["i16"],"name":"wrapping"}],"output":null}],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitor","","",0,{"inputs":[{"name":"self"},{"generics":["i16"],"name":"wrapping"}],"output":{"generics":["i16"],"name":"wrapping"}}],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"generics":["i16"],"name":"wrapping"}],"output":null}],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitand","","",0,{"inputs":[{"name":"self"},{"generics":["i16"],"name":"wrapping"}],"output":{"generics":["i16"],"name":"wrapping"}}],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"generics":["i16"],"name":"wrapping"}],"output":null}],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"neg","","",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"add","","",0,{"inputs":[{"name":"self"},{"generics":["i32"],"name":"wrapping"}],"output":{"generics":["i32"],"name":"wrapping"}}],[11,"add","","",0,null],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"generics":["i32"],"name":"wrapping"}],"output":null}],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"sub","","",0,{"inputs":[{"name":"self"},{"generics":["i32"],"name":"wrapping"}],"output":{"generics":["i32"],"name":"wrapping"}}],[11,"sub","","",0,null],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"generics":["i32"],"name":"wrapping"}],"output":null}],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"mul","","",0,{"inputs":[{"name":"self"},{"generics":["i32"],"name":"wrapping"}],"output":{"generics":["i32"],"name":"wrapping"}}],[11,"mul","","",0,null],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"generics":["i32"],"name":"wrapping"}],"output":null}],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"div","","",0,{"inputs":[{"name":"self"},{"generics":["i32"],"name":"wrapping"}],"output":{"generics":["i32"],"name":"wrapping"}}],[11,"div","","",0,null],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"generics":["i32"],"name":"wrapping"}],"output":null}],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"rem","","",0,{"inputs":[{"name":"self"},{"generics":["i32"],"name":"wrapping"}],"output":{"generics":["i32"],"name":"wrapping"}}],[11,"rem","","",0,null],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"generics":["i32"],"name":"wrapping"}],"output":null}],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"not","","",0,{"inputs":[{"name":"self"}],"output":{"generics":["i32"],"name":"wrapping"}}],[11,"bitxor","","",0,{"inputs":[{"name":"self"},{"generics":["i32"],"name":"wrapping"}],"output":{"generics":["i32"],"name":"wrapping"}}],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"generics":["i32"],"name":"wrapping"}],"output":null}],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitor","","",0,{"inputs":[{"name":"self"},{"generics":["i32"],"name":"wrapping"}],"output":{"generics":["i32"],"name":"wrapping"}}],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"generics":["i32"],"name":"wrapping"}],"output":null}],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitand","","",0,{"inputs":[{"name":"self"},{"generics":["i32"],"name":"wrapping"}],"output":{"generics":["i32"],"name":"wrapping"}}],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"generics":["i32"],"name":"wrapping"}],"output":null}],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"neg","","",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"add","","",0,{"inputs":[{"name":"self"},{"generics":["i64"],"name":"wrapping"}],"output":{"generics":["i64"],"name":"wrapping"}}],[11,"add","","",0,null],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"generics":["i64"],"name":"wrapping"}],"output":null}],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"sub","","",0,{"inputs":[{"name":"self"},{"generics":["i64"],"name":"wrapping"}],"output":{"generics":["i64"],"name":"wrapping"}}],[11,"sub","","",0,null],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"generics":["i64"],"name":"wrapping"}],"output":null}],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"mul","","",0,{"inputs":[{"name":"self"},{"generics":["i64"],"name":"wrapping"}],"output":{"generics":["i64"],"name":"wrapping"}}],[11,"mul","","",0,null],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"generics":["i64"],"name":"wrapping"}],"output":null}],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"div","","",0,{"inputs":[{"name":"self"},{"generics":["i64"],"name":"wrapping"}],"output":{"generics":["i64"],"name":"wrapping"}}],[11,"div","","",0,null],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"generics":["i64"],"name":"wrapping"}],"output":null}],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"rem","","",0,{"inputs":[{"name":"self"},{"generics":["i64"],"name":"wrapping"}],"output":{"generics":["i64"],"name":"wrapping"}}],[11,"rem","","",0,null],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"generics":["i64"],"name":"wrapping"}],"output":null}],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"not","","",0,{"inputs":[{"name":"self"}],"output":{"generics":["i64"],"name":"wrapping"}}],[11,"bitxor","","",0,{"inputs":[{"name":"self"},{"generics":["i64"],"name":"wrapping"}],"output":{"generics":["i64"],"name":"wrapping"}}],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"generics":["i64"],"name":"wrapping"}],"output":null}],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitor","","",0,{"inputs":[{"name":"self"},{"generics":["i64"],"name":"wrapping"}],"output":{"generics":["i64"],"name":"wrapping"}}],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"generics":["i64"],"name":"wrapping"}],"output":null}],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitand","","",0,{"inputs":[{"name":"self"},{"generics":["i64"],"name":"wrapping"}],"output":{"generics":["i64"],"name":"wrapping"}}],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"generics":["i64"],"name":"wrapping"}],"output":null}],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"neg","","",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"add","","",0,{"inputs":[{"name":"self"},{"generics":["i128"],"name":"wrapping"}],"output":{"generics":["i128"],"name":"wrapping"}}],[11,"add","","",0,null],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"generics":["i128"],"name":"wrapping"}],"output":null}],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"sub","","",0,{"inputs":[{"name":"self"},{"generics":["i128"],"name":"wrapping"}],"output":{"generics":["i128"],"name":"wrapping"}}],[11,"sub","","",0,null],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"generics":["i128"],"name":"wrapping"}],"output":null}],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"mul","","",0,{"inputs":[{"name":"self"},{"generics":["i128"],"name":"wrapping"}],"output":{"generics":["i128"],"name":"wrapping"}}],[11,"mul","","",0,null],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"generics":["i128"],"name":"wrapping"}],"output":null}],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"div","","",0,{"inputs":[{"name":"self"},{"generics":["i128"],"name":"wrapping"}],"output":{"generics":["i128"],"name":"wrapping"}}],[11,"div","","",0,null],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"generics":["i128"],"name":"wrapping"}],"output":null}],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"rem","","",0,{"inputs":[{"name":"self"},{"generics":["i128"],"name":"wrapping"}],"output":{"generics":["i128"],"name":"wrapping"}}],[11,"rem","","",0,null],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"generics":["i128"],"name":"wrapping"}],"output":null}],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"not","","",0,{"inputs":[{"name":"self"}],"output":{"generics":["i128"],"name":"wrapping"}}],[11,"bitxor","","",0,{"inputs":[{"name":"self"},{"generics":["i128"],"name":"wrapping"}],"output":{"generics":["i128"],"name":"wrapping"}}],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"generics":["i128"],"name":"wrapping"}],"output":null}],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitor","","",0,{"inputs":[{"name":"self"},{"generics":["i128"],"name":"wrapping"}],"output":{"generics":["i128"],"name":"wrapping"}}],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"generics":["i128"],"name":"wrapping"}],"output":null}],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitand","","",0,{"inputs":[{"name":"self"},{"generics":["i128"],"name":"wrapping"}],"output":{"generics":["i128"],"name":"wrapping"}}],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"generics":["i128"],"name":"wrapping"}],"output":null}],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"neg","","",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",0,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",0,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation of `self`.",0,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation of `self`.",0,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`, wrapping the truncated bits to the end of the resulting integer.",0,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"self"}}],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`, wrapping the truncated bits to the beginning of the resulting integer.",0,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"self"}}],[11,"swap_bytes","","Reverses the byte order of the integer.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"from_be","","Converts an integer from big endian to the target's endianness.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"from_le","","Converts an integer from little endian to the target's endianness.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"to_le","","Converts `self` to little endian from the target's endianness.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",0,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"self"}}],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",0,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",0,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation of `self`.",0,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation of `self`.",0,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`, wrapping the truncated bits to the end of the resulting integer.",0,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"self"}}],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`, wrapping the truncated bits to the beginning of the resulting integer.",0,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"self"}}],[11,"swap_bytes","","Reverses the byte order of the integer.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"from_be","","Converts an integer from big endian to the target's endianness.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"from_le","","Converts an integer from little endian to the target's endianness.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"to_le","","Converts `self` to little endian from the target's endianness.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",0,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"self"}}],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",0,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",0,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation of `self`.",0,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation of `self`.",0,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`, wrapping the truncated bits to the end of the resulting integer.",0,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"self"}}],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`, wrapping the truncated bits to the beginning of the resulting integer.",0,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"self"}}],[11,"swap_bytes","","Reverses the byte order of the integer.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"from_be","","Converts an integer from big endian to the target's endianness.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"from_le","","Converts an integer from little endian to the target's endianness.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"to_le","","Converts `self` to little endian from the target's endianness.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",0,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"self"}}],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",0,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",0,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation of `self`.",0,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation of `self`.",0,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`, wrapping the truncated bits to the end of the resulting integer.",0,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"self"}}],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`, wrapping the truncated bits to the beginning of the resulting integer.",0,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"self"}}],[11,"swap_bytes","","Reverses the byte order of the integer.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"from_be","","Converts an integer from big endian to the target's endianness.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"from_le","","Converts an integer from little endian to the target's endianness.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"to_le","","Converts `self` to little endian from the target's endianness.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",0,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"self"}}],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",0,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",0,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation of `self`.",0,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation of `self`.",0,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`, wrapping the truncated bits to the end of the resulting integer.",0,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"self"}}],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`, wrapping the truncated bits to the beginning of the resulting integer.",0,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"self"}}],[11,"swap_bytes","","Reverses the byte order of the integer.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"from_be","","Converts an integer from big endian to the target's endianness.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"from_le","","Converts an integer from little endian to the target's endianness.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"to_le","","Converts `self` to little endian from the target's endianness.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",0,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"self"}}],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",0,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",0,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation of `self`.",0,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation of `self`.",0,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`, wrapping the truncated bits to the end of the resulting integer.",0,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"self"}}],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`, wrapping the truncated bits to the beginning of the resulting integer.",0,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"self"}}],[11,"swap_bytes","","Reverses the byte order of the integer.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"from_be","","Converts an integer from big endian to the target's endianness.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"from_le","","Converts an integer from little endian to the target's endianness.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"to_le","","Converts `self` to little endian from the target's endianness.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",0,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"self"}}],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",0,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",0,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation of `self`.",0,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation of `self`.",0,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`, wrapping the truncated bits to the end of the resulting integer.",0,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"self"}}],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`, wrapping the truncated bits to the beginning of the resulting integer.",0,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"self"}}],[11,"swap_bytes","","Reverses the byte order of the integer.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"from_be","","Converts an integer from big endian to the target's endianness.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"from_le","","Converts an integer from little endian to the target's endianness.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"to_le","","Converts `self` to little endian from the target's endianness.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",0,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"self"}}],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",0,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",0,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation of `self`.",0,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation of `self`.",0,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`, wrapping the truncated bits to the end of the resulting integer.",0,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"self"}}],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`, wrapping the truncated bits to the beginning of the resulting integer.",0,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"self"}}],[11,"swap_bytes","","Reverses the byte order of the integer.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"from_be","","Converts an integer from big endian to the target's endianness.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"from_le","","Converts an integer from little endian to the target's endianness.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"to_le","","Converts `self` to little endian from the target's endianness.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",0,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"self"}}],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",0,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",0,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation of `self`.",0,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation of `self`.",0,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`, wrapping the truncated bits to the end of the resulting integer.",0,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"self"}}],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`, wrapping the truncated bits to the beginning of the resulting integer.",0,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"self"}}],[11,"swap_bytes","","Reverses the byte order of the integer.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"from_be","","Converts an integer from big endian to the target's endianness.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"from_le","","Converts an integer from little endian to the target's endianness.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"to_le","","Converts `self` to little endian from the target's endianness.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",0,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"self"}}],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",0,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",0,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation of `self`.",0,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation of `self`.",0,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`, wrapping the truncated bits to the end of the resulting integer.",0,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"self"}}],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`, wrapping the truncated bits to the beginning of the resulting integer.",0,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"self"}}],[11,"swap_bytes","","Reverses the byte order of the integer.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"from_be","","Converts an integer from big endian to the target's endianness.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"from_le","","Converts an integer from little endian to the target's endianness.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"to_le","","Converts `self` to little endian from the target's endianness.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",0,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"self"}}],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",0,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",0,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation of `self`.",0,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation of `self`.",0,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`, wrapping the truncated bits to the end of the resulting integer.",0,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"self"}}],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`, wrapping the truncated bits to the beginning of the resulting integer.",0,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"self"}}],[11,"swap_bytes","","Reverses the byte order of the integer.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"from_be","","Converts an integer from big endian to the target's endianness.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"from_le","","Converts an integer from little endian to the target's endianness.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"to_le","","Converts `self` to little endian from the target's endianness.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",0,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"self"}}],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",0,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",0,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation of `self`.",0,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation of `self`.",0,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`, wrapping the truncated bits to the end of the resulting integer.",0,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"self"}}],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`, wrapping the truncated bits to the beginning of the resulting integer.",0,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"self"}}],[11,"swap_bytes","","Reverses the byte order of the integer.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"from_be","","Converts an integer from big endian to the target's endianness.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"from_le","","Converts an integer from little endian to the target's endianness.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"to_le","","Converts `self` to little endian from the target's endianness.",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",0,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"self"}}],[11,"fmt","","",2,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",2,{"inputs":[{"name":"self"}],"output":{"name":"parsefloaterror"}}],[11,"eq","","",2,{"inputs":[{"name":"self"},{"name":"parsefloaterror"}],"output":{"name":"bool"}}],[11,"ne","","",2,{"inputs":[{"name":"self"},{"name":"parsefloaterror"}],"output":{"name":"bool"}}],[11,"fmt","","",2,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",3,{"inputs":[{"name":"self"}],"output":{"name":"nonzerou8"}}],[11,"eq","","",3,{"inputs":[{"name":"self"},{"name":"nonzerou8"}],"output":{"name":"bool"}}],[11,"ne","","",3,{"inputs":[{"name":"self"},{"name":"nonzerou8"}],"output":{"name":"bool"}}],[11,"cmp","","",3,{"inputs":[{"name":"self"},{"name":"nonzerou8"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",3,{"inputs":[{"name":"self"},{"name":"nonzerou8"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",3,{"inputs":[{"name":"self"},{"name":"nonzerou8"}],"output":{"name":"bool"}}],[11,"le","","",3,{"inputs":[{"name":"self"},{"name":"nonzerou8"}],"output":{"name":"bool"}}],[11,"gt","","",3,{"inputs":[{"name":"self"},{"name":"nonzerou8"}],"output":{"name":"bool"}}],[11,"ge","","",3,{"inputs":[{"name":"self"},{"name":"nonzerou8"}],"output":{"name":"bool"}}],[11,"hash","","",3,null],[11,"new_unchecked","","Create a non-zero without checking the value.",3,{"inputs":[{"name":"u8"}],"output":{"name":"self"}}],[11,"new","","Create a non-zero if the given value is not zero.",3,{"inputs":[{"name":"u8"}],"output":{"name":"option"}}],[11,"get","","Returns the value as a primitive type.",3,{"inputs":[{"name":"self"}],"output":{"name":"u8"}}],[11,"fmt","","",3,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",3,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",3,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",3,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",3,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",3,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",4,{"inputs":[{"name":"self"}],"output":{"name":"nonzerou16"}}],[11,"eq","","",4,{"inputs":[{"name":"self"},{"name":"nonzerou16"}],"output":{"name":"bool"}}],[11,"ne","","",4,{"inputs":[{"name":"self"},{"name":"nonzerou16"}],"output":{"name":"bool"}}],[11,"cmp","","",4,{"inputs":[{"name":"self"},{"name":"nonzerou16"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",4,{"inputs":[{"name":"self"},{"name":"nonzerou16"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",4,{"inputs":[{"name":"self"},{"name":"nonzerou16"}],"output":{"name":"bool"}}],[11,"le","","",4,{"inputs":[{"name":"self"},{"name":"nonzerou16"}],"output":{"name":"bool"}}],[11,"gt","","",4,{"inputs":[{"name":"self"},{"name":"nonzerou16"}],"output":{"name":"bool"}}],[11,"ge","","",4,{"inputs":[{"name":"self"},{"name":"nonzerou16"}],"output":{"name":"bool"}}],[11,"hash","","",4,null],[11,"new_unchecked","","Create a non-zero without checking the value.",4,{"inputs":[{"name":"u16"}],"output":{"name":"self"}}],[11,"new","","Create a non-zero if the given value is not zero.",4,{"inputs":[{"name":"u16"}],"output":{"name":"option"}}],[11,"get","","Returns the value as a primitive type.",4,{"inputs":[{"name":"self"}],"output":{"name":"u16"}}],[11,"fmt","","",4,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",4,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",4,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",4,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",4,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",4,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",5,{"inputs":[{"name":"self"}],"output":{"name":"nonzerou32"}}],[11,"eq","","",5,{"inputs":[{"name":"self"},{"name":"nonzerou32"}],"output":{"name":"bool"}}],[11,"ne","","",5,{"inputs":[{"name":"self"},{"name":"nonzerou32"}],"output":{"name":"bool"}}],[11,"cmp","","",5,{"inputs":[{"name":"self"},{"name":"nonzerou32"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",5,{"inputs":[{"name":"self"},{"name":"nonzerou32"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",5,{"inputs":[{"name":"self"},{"name":"nonzerou32"}],"output":{"name":"bool"}}],[11,"le","","",5,{"inputs":[{"name":"self"},{"name":"nonzerou32"}],"output":{"name":"bool"}}],[11,"gt","","",5,{"inputs":[{"name":"self"},{"name":"nonzerou32"}],"output":{"name":"bool"}}],[11,"ge","","",5,{"inputs":[{"name":"self"},{"name":"nonzerou32"}],"output":{"name":"bool"}}],[11,"hash","","",5,null],[11,"new_unchecked","","Create a non-zero without checking the value.",5,{"inputs":[{"name":"u32"}],"output":{"name":"self"}}],[11,"new","","Create a non-zero if the given value is not zero.",5,{"inputs":[{"name":"u32"}],"output":{"name":"option"}}],[11,"get","","Returns the value as a primitive type.",5,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"fmt","","",5,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",5,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",5,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",5,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",5,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",5,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",6,{"inputs":[{"name":"self"}],"output":{"name":"nonzerou64"}}],[11,"eq","","",6,{"inputs":[{"name":"self"},{"name":"nonzerou64"}],"output":{"name":"bool"}}],[11,"ne","","",6,{"inputs":[{"name":"self"},{"name":"nonzerou64"}],"output":{"name":"bool"}}],[11,"cmp","","",6,{"inputs":[{"name":"self"},{"name":"nonzerou64"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",6,{"inputs":[{"name":"self"},{"name":"nonzerou64"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",6,{"inputs":[{"name":"self"},{"name":"nonzerou64"}],"output":{"name":"bool"}}],[11,"le","","",6,{"inputs":[{"name":"self"},{"name":"nonzerou64"}],"output":{"name":"bool"}}],[11,"gt","","",6,{"inputs":[{"name":"self"},{"name":"nonzerou64"}],"output":{"name":"bool"}}],[11,"ge","","",6,{"inputs":[{"name":"self"},{"name":"nonzerou64"}],"output":{"name":"bool"}}],[11,"hash","","",6,null],[11,"new_unchecked","","Create a non-zero without checking the value.",6,{"inputs":[{"name":"u64"}],"output":{"name":"self"}}],[11,"new","","Create a non-zero if the given value is not zero.",6,{"inputs":[{"name":"u64"}],"output":{"name":"option"}}],[11,"get","","Returns the value as a primitive type.",6,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"fmt","","",6,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",6,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",6,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",6,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",6,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",6,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",7,{"inputs":[{"name":"self"}],"output":{"name":"nonzerou128"}}],[11,"eq","","",7,{"inputs":[{"name":"self"},{"name":"nonzerou128"}],"output":{"name":"bool"}}],[11,"ne","","",7,{"inputs":[{"name":"self"},{"name":"nonzerou128"}],"output":{"name":"bool"}}],[11,"cmp","","",7,{"inputs":[{"name":"self"},{"name":"nonzerou128"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",7,{"inputs":[{"name":"self"},{"name":"nonzerou128"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",7,{"inputs":[{"name":"self"},{"name":"nonzerou128"}],"output":{"name":"bool"}}],[11,"le","","",7,{"inputs":[{"name":"self"},{"name":"nonzerou128"}],"output":{"name":"bool"}}],[11,"gt","","",7,{"inputs":[{"name":"self"},{"name":"nonzerou128"}],"output":{"name":"bool"}}],[11,"ge","","",7,{"inputs":[{"name":"self"},{"name":"nonzerou128"}],"output":{"name":"bool"}}],[11,"hash","","",7,null],[11,"new_unchecked","","Create a non-zero without checking the value.",7,{"inputs":[{"name":"u128"}],"output":{"name":"self"}}],[11,"new","","Create a non-zero if the given value is not zero.",7,{"inputs":[{"name":"u128"}],"output":{"name":"option"}}],[11,"get","","Returns the value as a primitive type.",7,{"inputs":[{"name":"self"}],"output":{"name":"u128"}}],[11,"fmt","","",7,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",7,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",7,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",7,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",7,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",7,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",8,{"inputs":[{"name":"self"}],"output":{"name":"nonzerousize"}}],[11,"eq","","",8,{"inputs":[{"name":"self"},{"name":"nonzerousize"}],"output":{"name":"bool"}}],[11,"ne","","",8,{"inputs":[{"name":"self"},{"name":"nonzerousize"}],"output":{"name":"bool"}}],[11,"cmp","","",8,{"inputs":[{"name":"self"},{"name":"nonzerousize"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",8,{"inputs":[{"name":"self"},{"name":"nonzerousize"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",8,{"inputs":[{"name":"self"},{"name":"nonzerousize"}],"output":{"name":"bool"}}],[11,"le","","",8,{"inputs":[{"name":"self"},{"name":"nonzerousize"}],"output":{"name":"bool"}}],[11,"gt","","",8,{"inputs":[{"name":"self"},{"name":"nonzerousize"}],"output":{"name":"bool"}}],[11,"ge","","",8,{"inputs":[{"name":"self"},{"name":"nonzerousize"}],"output":{"name":"bool"}}],[11,"hash","","",8,null],[11,"new_unchecked","","Create a non-zero without checking the value.",8,{"inputs":[{"name":"usize"}],"output":{"name":"self"}}],[11,"new","","Create a non-zero if the given value is not zero.",8,{"inputs":[{"name":"usize"}],"output":{"name":"option"}}],[11,"get","","Returns the value as a primitive type.",8,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"fmt","","",8,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",8,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",8,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",8,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",8,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",8,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",9,{"inputs":[{"name":"self"}],"output":{"name":"nonzeroi8"}}],[11,"eq","","",9,{"inputs":[{"name":"self"},{"name":"nonzeroi8"}],"output":{"name":"bool"}}],[11,"ne","","",9,{"inputs":[{"name":"self"},{"name":"nonzeroi8"}],"output":{"name":"bool"}}],[11,"cmp","","",9,{"inputs":[{"name":"self"},{"name":"nonzeroi8"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",9,{"inputs":[{"name":"self"},{"name":"nonzeroi8"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",9,{"inputs":[{"name":"self"},{"name":"nonzeroi8"}],"output":{"name":"bool"}}],[11,"le","","",9,{"inputs":[{"name":"self"},{"name":"nonzeroi8"}],"output":{"name":"bool"}}],[11,"gt","","",9,{"inputs":[{"name":"self"},{"name":"nonzeroi8"}],"output":{"name":"bool"}}],[11,"ge","","",9,{"inputs":[{"name":"self"},{"name":"nonzeroi8"}],"output":{"name":"bool"}}],[11,"hash","","",9,null],[11,"new_unchecked","","Create a non-zero without checking the value.",9,{"inputs":[{"name":"i8"}],"output":{"name":"self"}}],[11,"new","","Create a non-zero if the given value is not zero.",9,{"inputs":[{"name":"i8"}],"output":{"name":"option"}}],[11,"get","","Returns the value as a primitive type.",9,{"inputs":[{"name":"self"}],"output":{"name":"i8"}}],[11,"fmt","","",9,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",9,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",9,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",9,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",9,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",9,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",10,{"inputs":[{"name":"self"}],"output":{"name":"nonzeroi16"}}],[11,"eq","","",10,{"inputs":[{"name":"self"},{"name":"nonzeroi16"}],"output":{"name":"bool"}}],[11,"ne","","",10,{"inputs":[{"name":"self"},{"name":"nonzeroi16"}],"output":{"name":"bool"}}],[11,"cmp","","",10,{"inputs":[{"name":"self"},{"name":"nonzeroi16"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",10,{"inputs":[{"name":"self"},{"name":"nonzeroi16"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",10,{"inputs":[{"name":"self"},{"name":"nonzeroi16"}],"output":{"name":"bool"}}],[11,"le","","",10,{"inputs":[{"name":"self"},{"name":"nonzeroi16"}],"output":{"name":"bool"}}],[11,"gt","","",10,{"inputs":[{"name":"self"},{"name":"nonzeroi16"}],"output":{"name":"bool"}}],[11,"ge","","",10,{"inputs":[{"name":"self"},{"name":"nonzeroi16"}],"output":{"name":"bool"}}],[11,"hash","","",10,null],[11,"new_unchecked","","Create a non-zero without checking the value.",10,{"inputs":[{"name":"i16"}],"output":{"name":"self"}}],[11,"new","","Create a non-zero if the given value is not zero.",10,{"inputs":[{"name":"i16"}],"output":{"name":"option"}}],[11,"get","","Returns the value as a primitive type.",10,{"inputs":[{"name":"self"}],"output":{"name":"i16"}}],[11,"fmt","","",10,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",10,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",10,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",10,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",10,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",10,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",11,{"inputs":[{"name":"self"}],"output":{"name":"nonzeroi32"}}],[11,"eq","","",11,{"inputs":[{"name":"self"},{"name":"nonzeroi32"}],"output":{"name":"bool"}}],[11,"ne","","",11,{"inputs":[{"name":"self"},{"name":"nonzeroi32"}],"output":{"name":"bool"}}],[11,"cmp","","",11,{"inputs":[{"name":"self"},{"name":"nonzeroi32"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",11,{"inputs":[{"name":"self"},{"name":"nonzeroi32"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",11,{"inputs":[{"name":"self"},{"name":"nonzeroi32"}],"output":{"name":"bool"}}],[11,"le","","",11,{"inputs":[{"name":"self"},{"name":"nonzeroi32"}],"output":{"name":"bool"}}],[11,"gt","","",11,{"inputs":[{"name":"self"},{"name":"nonzeroi32"}],"output":{"name":"bool"}}],[11,"ge","","",11,{"inputs":[{"name":"self"},{"name":"nonzeroi32"}],"output":{"name":"bool"}}],[11,"hash","","",11,null],[11,"new_unchecked","","Create a non-zero without checking the value.",11,{"inputs":[{"name":"i32"}],"output":{"name":"self"}}],[11,"new","","Create a non-zero if the given value is not zero.",11,{"inputs":[{"name":"i32"}],"output":{"name":"option"}}],[11,"get","","Returns the value as a primitive type.",11,{"inputs":[{"name":"self"}],"output":{"name":"i32"}}],[11,"fmt","","",11,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",11,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",11,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",11,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",11,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",11,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",12,{"inputs":[{"name":"self"}],"output":{"name":"nonzeroi64"}}],[11,"eq","","",12,{"inputs":[{"name":"self"},{"name":"nonzeroi64"}],"output":{"name":"bool"}}],[11,"ne","","",12,{"inputs":[{"name":"self"},{"name":"nonzeroi64"}],"output":{"name":"bool"}}],[11,"cmp","","",12,{"inputs":[{"name":"self"},{"name":"nonzeroi64"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",12,{"inputs":[{"name":"self"},{"name":"nonzeroi64"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",12,{"inputs":[{"name":"self"},{"name":"nonzeroi64"}],"output":{"name":"bool"}}],[11,"le","","",12,{"inputs":[{"name":"self"},{"name":"nonzeroi64"}],"output":{"name":"bool"}}],[11,"gt","","",12,{"inputs":[{"name":"self"},{"name":"nonzeroi64"}],"output":{"name":"bool"}}],[11,"ge","","",12,{"inputs":[{"name":"self"},{"name":"nonzeroi64"}],"output":{"name":"bool"}}],[11,"hash","","",12,null],[11,"new_unchecked","","Create a non-zero without checking the value.",12,{"inputs":[{"name":"i64"}],"output":{"name":"self"}}],[11,"new","","Create a non-zero if the given value is not zero.",12,{"inputs":[{"name":"i64"}],"output":{"name":"option"}}],[11,"get","","Returns the value as a primitive type.",12,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[11,"fmt","","",12,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",12,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",12,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",12,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",12,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",12,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",13,{"inputs":[{"name":"self"}],"output":{"name":"nonzeroi128"}}],[11,"eq","","",13,{"inputs":[{"name":"self"},{"name":"nonzeroi128"}],"output":{"name":"bool"}}],[11,"ne","","",13,{"inputs":[{"name":"self"},{"name":"nonzeroi128"}],"output":{"name":"bool"}}],[11,"cmp","","",13,{"inputs":[{"name":"self"},{"name":"nonzeroi128"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",13,{"inputs":[{"name":"self"},{"name":"nonzeroi128"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",13,{"inputs":[{"name":"self"},{"name":"nonzeroi128"}],"output":{"name":"bool"}}],[11,"le","","",13,{"inputs":[{"name":"self"},{"name":"nonzeroi128"}],"output":{"name":"bool"}}],[11,"gt","","",13,{"inputs":[{"name":"self"},{"name":"nonzeroi128"}],"output":{"name":"bool"}}],[11,"ge","","",13,{"inputs":[{"name":"self"},{"name":"nonzeroi128"}],"output":{"name":"bool"}}],[11,"hash","","",13,null],[11,"new_unchecked","","Create a non-zero without checking the value.",13,{"inputs":[{"name":"i128"}],"output":{"name":"self"}}],[11,"new","","Create a non-zero if the given value is not zero.",13,{"inputs":[{"name":"i128"}],"output":{"name":"option"}}],[11,"get","","Returns the value as a primitive type.",13,{"inputs":[{"name":"self"}],"output":{"name":"i128"}}],[11,"fmt","","",13,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",13,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",13,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",13,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",13,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",13,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",14,{"inputs":[{"name":"self"}],"output":{"name":"nonzeroisize"}}],[11,"eq","","",14,{"inputs":[{"name":"self"},{"name":"nonzeroisize"}],"output":{"name":"bool"}}],[11,"ne","","",14,{"inputs":[{"name":"self"},{"name":"nonzeroisize"}],"output":{"name":"bool"}}],[11,"cmp","","",14,{"inputs":[{"name":"self"},{"name":"nonzeroisize"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",14,{"inputs":[{"name":"self"},{"name":"nonzeroisize"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",14,{"inputs":[{"name":"self"},{"name":"nonzeroisize"}],"output":{"name":"bool"}}],[11,"le","","",14,{"inputs":[{"name":"self"},{"name":"nonzeroisize"}],"output":{"name":"bool"}}],[11,"gt","","",14,{"inputs":[{"name":"self"},{"name":"nonzeroisize"}],"output":{"name":"bool"}}],[11,"ge","","",14,{"inputs":[{"name":"self"},{"name":"nonzeroisize"}],"output":{"name":"bool"}}],[11,"hash","","",14,null],[11,"new_unchecked","","Create a non-zero without checking the value.",14,{"inputs":[{"name":"isize"}],"output":{"name":"self"}}],[11,"new","","Create a non-zero if the given value is not zero.",14,{"inputs":[{"name":"isize"}],"output":{"name":"option"}}],[11,"get","","Returns the value as a primitive type.",14,{"inputs":[{"name":"self"}],"output":{"name":"isize"}}],[11,"fmt","","",14,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",14,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",14,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",14,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",14,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",14,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"bool"}}],[11,"ne","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"bool"}}],[11,"le","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"bool"}}],[11,"gt","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"bool"}}],[11,"ge","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"bool"}}],[11,"cmp","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"ordering"}}],[11,"clone","","",0,{"inputs":[{"name":"self"}],"output":{"name":"wrapping"}}],[11,"default","","",0,{"inputs":[],"output":{"name":"wrapping"}}],[11,"hash","","",0,null],[11,"fmt","","",0,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",0,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",0,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",0,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",0,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",0,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",1,{"inputs":[{"name":"self"}],"output":{"name":"fpcategory"}}],[11,"eq","","",1,{"inputs":[{"name":"self"},{"name":"fpcategory"}],"output":{"name":"bool"}}],[11,"fmt","","",1,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",15,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",15,{"inputs":[{"name":"self"}],"output":{"name":"tryfrominterror"}}],[11,"fmt","","",15,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"from","","",15,null],[11,"fmt","","",16,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",16,{"inputs":[{"name":"self"}],"output":{"name":"parseinterror"}}],[11,"eq","","",16,{"inputs":[{"name":"self"},{"name":"parseinterror"}],"output":{"name":"bool"}}],[11,"ne","","",16,{"inputs":[{"name":"self"},{"name":"parseinterror"}],"output":{"name":"bool"}}],[11,"fmt","","",16,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[0,"prelude","core","The libcore prelude",null,null],[0,"v1","core::prelude","The core prelude",null,null],[0,"intrinsics","core","rustc compiler intrinsics.",null,null],[5,"atomic_cxchg","core::intrinsics","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::SeqCst` as both the `success` and `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",null,null],[5,"atomic_cxchg_acq","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::Acquire` as both the `success` and `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",null,null],[5,"atomic_cxchg_rel","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::Release` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",null,null],[5,"atomic_cxchg_acqrel","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::AcqRel` as the `success` and `Ordering::Acquire` as the `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",null,null],[5,"atomic_cxchg_relaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::Relaxed` as both the `success` and `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",null,null],[5,"atomic_cxchg_failrelaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::SeqCst` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",null,null],[5,"atomic_cxchg_failacq","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::SeqCst` as the `success` and `Ordering::Acquire` as the `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",null,null],[5,"atomic_cxchg_acq_failrelaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::Acquire` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",null,null],[5,"atomic_cxchg_acqrel_failrelaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::AcqRel` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",null,null],[5,"atomic_cxchgweak","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::SeqCst` as both the `success` and `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",null,null],[5,"atomic_cxchgweak_acq","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::Acquire` as both the `success` and `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",null,null],[5,"atomic_cxchgweak_rel","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::Release` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",null,null],[5,"atomic_cxchgweak_acqrel","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::AcqRel` as the `success` and `Ordering::Acquire` as the `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",null,null],[5,"atomic_cxchgweak_relaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::Relaxed` as both the `success` and `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",null,null],[5,"atomic_cxchgweak_failrelaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::SeqCst` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",null,null],[5,"atomic_cxchgweak_failacq","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::SeqCst` as the `success` and `Ordering::Acquire` as the `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",null,null],[5,"atomic_cxchgweak_acq_failrelaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::Acquire` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",null,null],[5,"atomic_cxchgweak_acqrel_failrelaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::AcqRel` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",null,null],[5,"atomic_load","","Loads the current value of the pointer. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `load` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::load`.",null,null],[5,"atomic_load_acq","","Loads the current value of the pointer. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `load` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicBool::load`.",null,null],[5,"atomic_load_relaxed","","Loads the current value of the pointer. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `load` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::load`.",null,null],[5,"atomic_load_unordered","","",null,null],[5,"atomic_store","","Stores the value at the specified memory location. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `store` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::store`.",null,null],[5,"atomic_store_rel","","Stores the value at the specified memory location. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `store` method by passing `Ordering::Release` as the `order`. For example, `AtomicBool::store`.",null,null],[5,"atomic_store_relaxed","","Stores the value at the specified memory location. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `store` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::store`.",null,null],[5,"atomic_store_unordered","","",null,null],[5,"atomic_xchg","","Stores the value at the specified memory location, returning the old value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `swap` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::swap`.",null,null],[5,"atomic_xchg_acq","","Stores the value at the specified memory location, returning the old value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `swap` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicBool::swap`.",null,null],[5,"atomic_xchg_rel","","Stores the value at the specified memory location, returning the old value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `swap` method by passing `Ordering::Release` as the `order`. For example, `AtomicBool::swap`.",null,null],[5,"atomic_xchg_acqrel","","Stores the value at the specified memory location, returning the old value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `swap` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicBool::swap`.",null,null],[5,"atomic_xchg_relaxed","","Stores the value at the specified memory location, returning the old value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `swap` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::swap`.",null,null],[5,"atomic_xadd","","Add to the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_add` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicIsize::fetch_add`.",null,null],[5,"atomic_xadd_acq","","Add to the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_add` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicIsize::fetch_add`.",null,null],[5,"atomic_xadd_rel","","Add to the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_add` method by passing `Ordering::Release` as the `order`. For example, `AtomicIsize::fetch_add`.",null,null],[5,"atomic_xadd_acqrel","","Add to the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_add` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicIsize::fetch_add`.",null,null],[5,"atomic_xadd_relaxed","","Add to the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_add` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicIsize::fetch_add`.",null,null],[5,"atomic_xsub","","Subtract from the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_sub` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicIsize::fetch_sub`.",null,null],[5,"atomic_xsub_acq","","Subtract from the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_sub` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicIsize::fetch_sub`.",null,null],[5,"atomic_xsub_rel","","Subtract from the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_sub` method by passing `Ordering::Release` as the `order`. For example, `AtomicIsize::fetch_sub`.",null,null],[5,"atomic_xsub_acqrel","","Subtract from the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_sub` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicIsize::fetch_sub`.",null,null],[5,"atomic_xsub_relaxed","","Subtract from the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_sub` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicIsize::fetch_sub`.",null,null],[5,"atomic_and","","Bitwise and with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_and` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::fetch_and`.",null,null],[5,"atomic_and_acq","","Bitwise and with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_and` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicBool::fetch_and`.",null,null],[5,"atomic_and_rel","","Bitwise and with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_and` method by passing `Ordering::Release` as the `order`. For example, `AtomicBool::fetch_and`.",null,null],[5,"atomic_and_acqrel","","Bitwise and with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_and` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicBool::fetch_and`.",null,null],[5,"atomic_and_relaxed","","Bitwise and with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_and` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::fetch_and`.",null,null],[5,"atomic_nand","","Bitwise nand with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic::AtomicBool` type via the `fetch_nand` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::fetch_nand`.",null,null],[5,"atomic_nand_acq","","Bitwise nand with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic::AtomicBool` type via the `fetch_nand` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicBool::fetch_nand`.",null,null],[5,"atomic_nand_rel","","Bitwise nand with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic::AtomicBool` type via the `fetch_nand` method by passing `Ordering::Release` as the `order`. For example, `AtomicBool::fetch_nand`.",null,null],[5,"atomic_nand_acqrel","","Bitwise nand with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic::AtomicBool` type via the `fetch_nand` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicBool::fetch_nand`.",null,null],[5,"atomic_nand_relaxed","","Bitwise nand with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic::AtomicBool` type via the `fetch_nand` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::fetch_nand`.",null,null],[5,"atomic_or","","Bitwise or with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_or` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::fetch_or`.",null,null],[5,"atomic_or_acq","","Bitwise or with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_or` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicBool::fetch_or`.",null,null],[5,"atomic_or_rel","","Bitwise or with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_or` method by passing `Ordering::Release` as the `order`. For example, `AtomicBool::fetch_or`.",null,null],[5,"atomic_or_acqrel","","Bitwise or with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_or` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicBool::fetch_or`.",null,null],[5,"atomic_or_relaxed","","Bitwise or with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_or` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::fetch_or`.",null,null],[5,"atomic_xor","","Bitwise xor with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_xor` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::fetch_xor`.",null,null],[5,"atomic_xor_acq","","Bitwise xor with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_xor` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicBool::fetch_xor`.",null,null],[5,"atomic_xor_rel","","Bitwise xor with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_xor` method by passing `Ordering::Release` as the `order`. For example, `AtomicBool::fetch_xor`.",null,null],[5,"atomic_xor_acqrel","","Bitwise xor with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_xor` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicBool::fetch_xor`.",null,null],[5,"atomic_xor_relaxed","","Bitwise xor with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_xor` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::fetch_xor`.",null,null],[5,"atomic_max","","",null,null],[5,"atomic_max_acq","","",null,null],[5,"atomic_max_rel","","",null,null],[5,"atomic_max_acqrel","","",null,null],[5,"atomic_max_relaxed","","",null,null],[5,"atomic_min","","",null,null],[5,"atomic_min_acq","","",null,null],[5,"atomic_min_rel","","",null,null],[5,"atomic_min_acqrel","","",null,null],[5,"atomic_min_relaxed","","",null,null],[5,"atomic_umin","","",null,null],[5,"atomic_umin_acq","","",null,null],[5,"atomic_umin_rel","","",null,null],[5,"atomic_umin_acqrel","","",null,null],[5,"atomic_umin_relaxed","","",null,null],[5,"atomic_umax","","",null,null],[5,"atomic_umax_acq","","",null,null],[5,"atomic_umax_rel","","",null,null],[5,"atomic_umax_acqrel","","",null,null],[5,"atomic_umax_relaxed","","",null,null],[5,"prefetch_read_data","","The `prefetch` intrinsic is a hint to the code generator to insert a prefetch instruction if supported; otherwise, it is a noop. Prefetches have no effect on the behavior of the program but can change its performance characteristics.",null,null],[5,"prefetch_write_data","","The `prefetch` intrinsic is a hint to the code generator to insert a prefetch instruction if supported; otherwise, it is a noop. Prefetches have no effect on the behavior of the program but can change its performance characteristics.",null,null],[5,"prefetch_read_instruction","","The `prefetch` intrinsic is a hint to the code generator to insert a prefetch instruction if supported; otherwise, it is a noop. Prefetches have no effect on the behavior of the program but can change its performance characteristics.",null,null],[5,"prefetch_write_instruction","","The `prefetch` intrinsic is a hint to the code generator to insert a prefetch instruction if supported; otherwise, it is a noop. Prefetches have no effect on the behavior of the program but can change its performance characteristics.",null,null],[5,"atomic_fence","","",null,null],[5,"atomic_fence_acq","","",null,null],[5,"atomic_fence_rel","","",null,null],[5,"atomic_fence_acqrel","","",null,null],[5,"atomic_singlethreadfence","","A compiler-only memory barrier.",null,null],[5,"atomic_singlethreadfence_acq","","",null,null],[5,"atomic_singlethreadfence_rel","","",null,null],[5,"atomic_singlethreadfence_acqrel","","",null,null],[5,"rustc_peek","","Magic intrinsic that derives its meaning from attributes attached to the function.",null,null],[5,"abort","","Aborts the execution of the process.",null,null],[5,"unreachable","","Tells LLVM that this point in the code is not reachable, enabling further optimizations.",null,null],[5,"assume","","Informs the optimizer that a condition is always true. If the condition is false, the behavior is undefined.",null,null],[5,"likely","","Hints to the compiler that branch condition is likely to be true. Returns the value passed to it.",null,null],[5,"unlikely","","Hints to the compiler that branch condition is likely to be false. Returns the value passed to it.",null,null],[5,"breakpoint","","Executes a breakpoint trap, for inspection by a debugger.",null,null],[5,"size_of","","The size of a type in bytes.",null,null],[5,"move_val_init","","Moves a value to an uninitialized memory location.",null,null],[5,"min_align_of","","",null,null],[5,"pref_align_of","","",null,null],[5,"size_of_val","","The size of the referenced value in bytes.",null,null],[5,"min_align_of_val","","",null,null],[5,"type_name","","Gets a static string slice containing the name of a type.",null,null],[5,"type_id","","Gets an identifier which is globally unique to the specified type. This function will return the same value for a type regardless of whichever crate it is invoked in.",null,null],[5,"init","","Creates a value initialized to zero.",null,null],[5,"uninit","","Creates an uninitialized value.",null,null],[5,"transmute","","Reinterprets the bits of a value of one type as another type.",null,null],[5,"needs_drop","","Returns `true` if the actual type given as `T` requires drop glue; returns `false` if the actual type provided for `T` implements `Copy`.",null,null],[5,"offset","","Calculates the offset from a pointer.",null,null],[5,"arith_offset","","Calculates the offset from a pointer, potentially wrapping.",null,null],[5,"copy_nonoverlapping","","Copies `count * size_of<T>` bytes from `src` to `dst`. The source and destination may not overlap.",null,null],[5,"copy","","Copies `count * size_of<T>` bytes from `src` to `dst`. The source and destination may overlap.",null,null],[5,"write_bytes","","Invokes memset on the specified pointer, setting `count * size_of::<T>()` bytes of memory starting at `dst` to `val`.",null,null],[5,"volatile_copy_nonoverlapping_memory","","Equivalent to the appropriate `llvm.memcpy.p0i8.0i8.*` intrinsic, with a size of `count` * `size_of::<T>()` and an alignment of `min_align_of::<T>()`",null,null],[5,"volatile_copy_memory","","Equivalent to the appropriate `llvm.memmove.p0i8.0i8.*` intrinsic, with a size of `count` * `size_of::<T>()` and an alignment of `min_align_of::<T>()`",null,null],[5,"volatile_set_memory","","Equivalent to the appropriate `llvm.memset.p0i8.*` intrinsic, with a size of `count` * `size_of::<T>()` and an alignment of `min_align_of::<T>()`.",null,null],[5,"volatile_load","","Perform a volatile load from the `src` pointer. The stabilized version of this intrinsic is `std::ptr::read_volatile`.",null,null],[5,"volatile_store","","Perform a volatile store to the `dst` pointer. The stabilized version of this intrinsic is `std::ptr::write_volatile`.",null,null],[5,"sqrtf32","","Returns the square root of an `f32`",null,null],[5,"sqrtf64","","Returns the square root of an `f64`",null,null],[5,"powif32","","Raises an `f32` to an integer power.",null,null],[5,"powif64","","Raises an `f64` to an integer power.",null,null],[5,"sinf32","","Returns the sine of an `f32`.",null,null],[5,"sinf64","","Returns the sine of an `f64`.",null,null],[5,"cosf32","","Returns the cosine of an `f32`.",null,null],[5,"cosf64","","Returns the cosine of an `f64`.",null,null],[5,"powf32","","Raises an `f32` to an `f32` power.",null,null],[5,"powf64","","Raises an `f64` to an `f64` power.",null,null],[5,"expf32","","Returns the exponential of an `f32`.",null,null],[5,"expf64","","Returns the exponential of an `f64`.",null,null],[5,"exp2f32","","Returns 2 raised to the power of an `f32`.",null,null],[5,"exp2f64","","Returns 2 raised to the power of an `f64`.",null,null],[5,"logf32","","Returns the natural logarithm of an `f32`.",null,null],[5,"logf64","","Returns the natural logarithm of an `f64`.",null,null],[5,"log10f32","","Returns the base 10 logarithm of an `f32`.",null,null],[5,"log10f64","","Returns the base 10 logarithm of an `f64`.",null,null],[5,"log2f32","","Returns the base 2 logarithm of an `f32`.",null,null],[5,"log2f64","","Returns the base 2 logarithm of an `f64`.",null,null],[5,"fmaf32","","Returns `a * b + c` for `f32` values.",null,null],[5,"fmaf64","","Returns `a * b + c` for `f64` values.",null,null],[5,"fabsf32","","Returns the absolute value of an `f32`.",null,null],[5,"fabsf64","","Returns the absolute value of an `f64`.",null,null],[5,"copysignf32","","Copies the sign from `y` to `x` for `f32` values.",null,null],[5,"copysignf64","","Copies the sign from `y` to `x` for `f64` values.",null,null],[5,"floorf32","","Returns the largest integer less than or equal to an `f32`.",null,null],[5,"floorf64","","Returns the largest integer less than or equal to an `f64`.",null,null],[5,"ceilf32","","Returns the smallest integer greater than or equal to an `f32`.",null,null],[5,"ceilf64","","Returns the smallest integer greater than or equal to an `f64`.",null,null],[5,"truncf32","","Returns the integer part of an `f32`.",null,null],[5,"truncf64","","Returns the integer part of an `f64`.",null,null],[5,"rintf32","","Returns the nearest integer to an `f32`. May raise an inexact floating-point exception if the argument is not an integer.",null,null],[5,"rintf64","","Returns the nearest integer to an `f64`. May raise an inexact floating-point exception if the argument is not an integer.",null,null],[5,"nearbyintf32","","Returns the nearest integer to an `f32`.",null,null],[5,"nearbyintf64","","Returns the nearest integer to an `f64`.",null,null],[5,"roundf32","","Returns the nearest integer to an `f32`. Rounds half-way cases away from zero.",null,null],[5,"roundf64","","Returns the nearest integer to an `f64`. Rounds half-way cases away from zero.",null,null],[5,"fadd_fast","","Float addition that allows optimizations based on algebraic rules. May assume inputs are finite.",null,null],[5,"fsub_fast","","Float subtraction that allows optimizations based on algebraic rules. May assume inputs are finite.",null,null],[5,"fmul_fast","","Float multiplication that allows optimizations based on algebraic rules. May assume inputs are finite.",null,null],[5,"fdiv_fast","","Float division that allows optimizations based on algebraic rules. May assume inputs are finite.",null,null],[5,"frem_fast","","Float remainder that allows optimizations based on algebraic rules. May assume inputs are finite.",null,null],[5,"ctpop","","Returns the number of bits set in an integer type `T`",null,null],[5,"ctlz","","Returns the number of leading unset bits (zeroes) in an integer type `T`.",null,null],[5,"ctlz_nonzero","","Like `ctlz`, but extra-unsafe as it returns `undef` when given an `x` with value `0`.",null,null],[5,"cttz","","Returns the number of trailing unset bits (zeroes) in an integer type `T`.",null,null],[5,"cttz_nonzero","","Like `cttz`, but extra-unsafe as it returns `undef` when given an `x` with value `0`.",null,null],[5,"bswap","","Reverses the bytes in an integer type `T`.",null,null],[5,"bitreverse","","Reverses the bits in an integer type `T`.",null,null],[5,"add_with_overflow","","Performs checked integer addition. The stabilized versions of this intrinsic are available on the integer primitives via the `overflowing_add` method. For example, `std::u32::overflowing_add`",null,null],[5,"sub_with_overflow","","Performs checked integer subtraction The stabilized versions of this intrinsic are available on the integer primitives via the `overflowing_sub` method. For example, `std::u32::overflowing_sub`",null,null],[5,"mul_with_overflow","","Performs checked integer multiplication The stabilized versions of this intrinsic are available on the integer primitives via the `overflowing_mul` method. For example, `std::u32::overflowing_mul`",null,null],[5,"exact_div","","Performs an exact division, resulting in undefined behavior where `x % y != 0` or `y == 0` or `x == T::min_value() && y == -1`",null,null],[5,"unchecked_div","","Performs an unchecked division, resulting in undefined behavior where y = 0 or x = `T::min_value()` and y = -1",null,null],[5,"unchecked_rem","","Returns the remainder of an unchecked division, resulting in undefined behavior where y = 0 or x = `T::min_value()` and y = -1",null,null],[5,"unchecked_shl","","Performs an unchecked left shift, resulting in undefined behavior when y < 0 or y >= N, where N is the width of T in bits.",null,null],[5,"unchecked_shr","","Performs an unchecked right shift, resulting in undefined behavior when y < 0 or y >= N, where N is the width of T in bits.",null,null],[5,"overflowing_add","","Returns (a + b) mod 2N, where N is the width of T in bits. The stabilized versions of this intrinsic are available on the integer primitives via the `wrapping_add` method. For example, `std::u32::wrapping_add`",null,null],[5,"overflowing_sub","","Returns (a - b) mod 2N, where N is the width of T in bits. The stabilized versions of this intrinsic are available on the integer primitives via the `wrapping_sub` method. For example, `std::u32::wrapping_sub`",null,null],[5,"overflowing_mul","","Returns (a * b) mod 2N, where N is the width of T in bits. The stabilized versions of this intrinsic are available on the integer primitives via the `wrapping_mul` method. For example, `std::u32::wrapping_mul`",null,null],[5,"discriminant_value","","Returns the value of the discriminant for the variant in 'v', cast to a `u64`; if `T` has no discriminant, returns 0.",null,null],[5,"try","","Rust's \"try catch\" construct which invokes the function pointer `f` with the data pointer `data`.",null,null],[5,"align_offset","","Computes the byte offset that needs to be applied to `ptr` in order to make it aligned to `align`. If it is not possible to align `ptr`, the implementation returns `usize::max_value()`.",null,null],[5,"nontemporal_store","","Emits a `!nontemporal` store according to LLVM (see their docs). Probably will never become stable.",null,null],[0,"mem","core","Basic functions for dealing with memory.",null,null],[3,"Discriminant","core::mem","Opaque type representing the discriminant of an enum.",null,null],[3,"Pin","","A pinned reference.",null,null],[19,"ManuallyDrop","","A wrapper to inhibit compiler from automatically calling `T`’s destructor.",null,null],[5,"forget","","Leaks a value: takes ownership and \"forgets\" about the value without running its destructor.",null,{"inputs":[{"name":"t"}],"output":null}],[5,"size_of","","Returns the size of a type in bytes.",null,{"inputs":[],"output":{"name":"usize"}}],[5,"size_of_val","","Returns the size of the pointed-to value in bytes.",null,{"inputs":[{"name":"t"}],"output":{"name":"usize"}}],[5,"min_align_of","","Returns the [ABI]-required minimum alignment of a type.",null,{"inputs":[],"output":{"name":"usize"}}],[5,"min_align_of_val","","Returns the [ABI]-required minimum alignment of the type of the value that `val` points to.",null,{"inputs":[{"name":"t"}],"output":{"name":"usize"}}],[5,"align_of","","Returns the [ABI]-required minimum alignment of a type.",null,{"inputs":[],"output":{"name":"usize"}}],[5,"align_of_val","","Returns the [ABI]-required minimum alignment of the type of the value that `val` points to.",null,{"inputs":[{"name":"t"}],"output":{"name":"usize"}}],[5,"needs_drop","","Returns whether dropping values of type `T` matters.",null,{"inputs":[],"output":{"name":"bool"}}],[5,"zeroed","","Creates a value whose bytes are all zero.",null,{"inputs":[],"output":{"name":"t"}}],[5,"uninitialized","","Bypasses Rust's normal memory-initialization checks by pretending to produce a value of type `T`, while doing nothing at all.",null,{"inputs":[],"output":{"name":"t"}}],[5,"swap","","Swaps the values at two mutable locations, without deinitializing either one.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":null}],[5,"replace","","Replaces the value at a mutable location with a new one, returning the old value, without deinitializing either one.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"drop","","Disposes of a value.",null,{"inputs":[{"name":"t"}],"output":null}],[5,"transmute_copy","","Interprets `src` as having type `&U`, and then reads `src` without moving the contained value.",null,{"inputs":[{"name":"t"}],"output":{"name":"u"}}],[5,"discriminant","","Returns a value uniquely identifying the enum variant in `v`.",null,{"inputs":[{"name":"t"}],"output":{"name":"discriminant"}}],[11,"clone","","",17,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"eq","","",17,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"bool"}}],[11,"hash","","",17,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"fmt","","",17,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Wrap a value to be manually dropped.",18,{"inputs":[{"name":"t"}],"output":{"name":"manuallydrop"}}],[11,"into_inner","","Extract the value from the ManuallyDrop container.",18,{"inputs":[{"name":"manuallydrop"}],"output":{"name":"t"}}],[11,"drop","","Manually drops the contained value.",18,{"inputs":[{"name":"manuallydrop"}],"output":null}],[11,"deref","","",18,null],[11,"deref_mut","","",18,null],[11,"fmt","","",18,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",18,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"clone_from","","",18,{"inputs":[{"name":"self"},{"name":"self"}],"output":null}],[11,"default","","",18,{"inputs":[],"output":{"name":"self"}}],[11,"eq","","",18,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"bool"}}],[11,"ne","","",18,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",18,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",18,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"bool"}}],[11,"le","","",18,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"bool"}}],[11,"gt","","",18,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"bool"}}],[11,"ge","","",18,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"bool"}}],[11,"cmp","","",18,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"ordering"}}],[11,"hash","","",18,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"new","","Construct a new `Pin` around a reference to some data of a type that implements `Unpin`.",19,{"inputs":[{"name":"t"}],"output":{"name":"pin"}}],[11,"new_unchecked","","Construct a new `Pin` around a reference to some data of a type that may or may not implement `Unpin`.",19,{"inputs":[{"name":"t"}],"output":{"name":"pin"}}],[11,"borrow","","Borrow a Pin for a shorter lifetime than it already has.",19,{"inputs":[{"name":"pin"}],"output":{"name":"pin"}}],[11,"get_mut","","Get a mutable reference to the data inside of this `Pin`.",19,{"inputs":[{"name":"pin"}],"output":{"name":"t"}}],[11,"map","","Construct a new pin by mapping the interior value.",19,{"inputs":[{"name":"pin"},{"name":"f"}],"output":{"name":"pin"}}],[11,"deref","","",19,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"deref_mut","","",19,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"fmt","","",19,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",19,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",19,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[0,"nonzero","core","Exposes the NonZero lang item which provides optimization hints.",null,null],[3,"NonZero","core::nonzero","A wrapper type for raw pointers and integers that will never be NULL or 0 that might allow certain optimizations.",null,null],[8,"Zeroable","","Unsafe trait to indicate what types are usable with the NonZero struct",null,null],[10,"is_zero","","Whether this value is zero",20,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",21,{"inputs":[{"name":"self"}],"output":{"name":"nonzero"}}],[11,"eq","","",21,{"inputs":[{"name":"self"},{"name":"nonzero"}],"output":{"name":"bool"}}],[11,"ne","","",21,{"inputs":[{"name":"self"},{"name":"nonzero"}],"output":{"name":"bool"}}],[11,"cmp","","",21,{"inputs":[{"name":"self"},{"name":"nonzero"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",21,{"inputs":[{"name":"self"},{"name":"nonzero"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",21,{"inputs":[{"name":"self"},{"name":"nonzero"}],"output":{"name":"bool"}}],[11,"le","","",21,{"inputs":[{"name":"self"},{"name":"nonzero"}],"output":{"name":"bool"}}],[11,"gt","","",21,{"inputs":[{"name":"self"},{"name":"nonzero"}],"output":{"name":"bool"}}],[11,"ge","","",21,{"inputs":[{"name":"self"},{"name":"nonzero"}],"output":{"name":"bool"}}],[11,"fmt","","",21,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",21,null],[11,"new_unchecked","","Creates an instance of NonZero with the provided value. You must indeed ensure that the value is actually \"non-zero\".",21,{"inputs":[{"name":"t"}],"output":{"name":"self"}}],[11,"new","","Creates an instance of NonZero with the provided value.",21,{"inputs":[{"name":"t"}],"output":{"name":"option"}}],[11,"get","","Gets the inner value.",21,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"from","","",21,{"inputs":[{"name":"t"}],"output":{"name":"self"}}],[11,"from","","",21,{"inputs":[{"name":"t"}],"output":{"name":"self"}}],[11,"from","","",21,{"inputs":[{"name":"t"}],"output":{"name":"self"}}],[0,"ptr","core","Raw, unsafe pointers, `*const T`, and `*mut T`.",null,null],[3,"NonNull","core::ptr","`*mut T` but non-zero and covariant.",null,null],[5,"drop_in_place","","Executes the destructor (if any) of the pointed-to value.",null,null],[5,"null","","Creates a null raw pointer.",null,null],[5,"null_mut","","Creates a null mutable raw pointer.",null,null],[5,"swap","","Swaps the values at two mutable locations of the same type, without deinitializing either.",null,null],[5,"swap_nonoverlapping","","Swaps a sequence of values at two mutable locations of the same type.",null,null],[5,"replace","","Replaces the value at `dest` with `src`, returning the old value, without dropping either.",null,null],[5,"read","","Reads the value from `src` without moving it. This leaves the memory in `src` unchanged.",null,null],[5,"read_unaligned","","Reads the value from `src` without moving it. This leaves the memory in `src` unchanged.",null,null],[5,"write","","Overwrites a memory location with the given value without reading or dropping the old value.",null,null],[5,"write_unaligned","","Overwrites a memory location with the given value without reading or dropping the old value.",null,null],[5,"read_volatile","","Performs a volatile read of the value from `src` without moving it. This leaves the memory in `src` unchanged.",null,null],[5,"write_volatile","","Performs a volatile write of a memory location with the given value without reading or dropping the old value.",null,null],[5,"eq","","Compare raw pointers for equality.",null,null],[11,"dangling","","Creates a new `NonNull` that is dangling, but well-aligned.",22,{"inputs":[],"output":{"name":"self"}}],[11,"new_unchecked","","Creates a new `NonNull`.",22,null],[11,"new","","Creates a new `NonNull` if `ptr` is non-null.",22,null],[11,"as_ptr","","Acquires the underlying `*mut` pointer.",22,null],[11,"as_ref","","Dereferences the content.",22,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"as_mut","","Mutably dereferences the content.",22,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"cast","","Cast to a pointer of another type",22,{"inputs":[{"name":"self"}],"output":{"name":"nonnull"}}],[11,"as_opaque","","Cast to an `Opaque` pointer",22,{"inputs":[{"name":"self"}],"output":{"generics":["opaque"],"name":"nonnull"}}],[11,"clone","","",22,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"fmt","","",22,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",22,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",22,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"bool"}}],[11,"cmp","","",22,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",22,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"hash","","",22,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"from","","",22,{"inputs":[{"name":"t"}],"output":{"name":"self"}}],[11,"from","","",22,{"inputs":[{"name":"t"}],"output":{"name":"self"}}],[0,"hint","core","Hints to compiler that affects how code should be emitted or optimized.",null,null],[5,"unreachable_unchecked","core::hint","Informs the compiler that this point in the code is not reachable, enabling further optimizations.",null,null],[0,"marker","core","Primitive traits and types representing basic properties of types.",null,null],[3,"PhantomData","core::marker","Zero-sized type used to mark things that \"act like\" they own a `T`.",null,null],[8,"Send","","Types that can be transferred across thread boundaries.",null,null],[8,"Sized","","Types with a constant size known at compile time.",null,null],[8,"Unsize","","Types that can be \"unsized\" to a dynamically-sized type.",null,null],[8,"Copy","","Types whose values can be duplicated simply by copying bits.",null,null],[8,"Sync","","Types for which it is safe to share references between threads.",null,null],[8,"Unpin","","Types which can be moved out of a `Pin`.",null,null],[11,"hash","","",23,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"eq","","",23,{"inputs":[{"name":"self"},{"name":"phantomdata"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",23,{"inputs":[{"name":"self"},{"name":"phantomdata"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"cmp","","",23,{"inputs":[{"name":"self"},{"name":"phantomdata"}],"output":{"name":"ordering"}}],[11,"clone","","",23,{"inputs":[{"name":"self"}],"output":{"name":"phantomdata"}}],[11,"default","","",23,{"inputs":[],"output":{"name":"phantomdata"}}],[0,"ops","core","Overloadable operators.",null,null],[3,"Range","core::ops","A (half-open) range bounded inclusively below and exclusively above (`start..end`).",null,null],[12,"start","","The lower bound of the range (inclusive).",24,null],[12,"end","","The upper bound of the range (exclusive).",24,null],[3,"RangeFrom","","A range only bounded inclusively below (`start..`).",null,null],[12,"start","","The lower bound of the range (inclusive).",25,null],[3,"RangeFull","","An unbounded range (`..`).",null,null],[3,"RangeTo","","A range only bounded exclusively above (`..end`).",null,null],[12,"end","","The upper bound of the range (exclusive).",26,null],[3,"RangeInclusive","","An range bounded inclusively below and above (`start..=end`).",null,null],[3,"RangeToInclusive","","A range only bounded inclusively above (`..=end`).",null,null],[12,"end","","The upper bound of the range (inclusive)",27,null],[4,"Bound","","An endpoint of a range of keys.",null,null],[13,"Included","","An inclusive bound.",28,null],[13,"Excluded","","An exclusive bound.",28,null],[13,"Unbounded","","An infinite endpoint. Indicates that there is no bound in this direction.",28,null],[4,"GeneratorState","","The result of a generator resumption.",null,null],[13,"Yielded","","The generator suspended with a value.",29,null],[13,"Complete","","The generator completed with a return value.",29,null],[11,"clone","","",29,{"inputs":[{"name":"self"}],"output":{"name":"generatorstate"}}],[11,"eq","","",29,{"inputs":[{"name":"self"},{"name":"generatorstate"}],"output":{"name":"bool"}}],[11,"ne","","",29,{"inputs":[{"name":"self"},{"name":"generatorstate"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",29,{"inputs":[{"name":"self"},{"name":"generatorstate"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",29,{"inputs":[{"name":"self"},{"name":"generatorstate"}],"output":{"name":"bool"}}],[11,"le","","",29,{"inputs":[{"name":"self"},{"name":"generatorstate"}],"output":{"name":"bool"}}],[11,"gt","","",29,{"inputs":[{"name":"self"},{"name":"generatorstate"}],"output":{"name":"bool"}}],[11,"ge","","",29,{"inputs":[{"name":"self"},{"name":"generatorstate"}],"output":{"name":"bool"}}],[11,"cmp","","",29,{"inputs":[{"name":"self"},{"name":"generatorstate"}],"output":{"name":"ordering"}}],[11,"fmt","","",29,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",29,null],[11,"clone","","",30,{"inputs":[{"name":"self"}],"output":{"name":"rangefull"}}],[11,"eq","","",30,{"inputs":[{"name":"self"},{"name":"rangefull"}],"output":{"name":"bool"}}],[11,"hash","","",30,null],[11,"fmt","","",30,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",24,{"inputs":[{"name":"self"}],"output":{"name":"range"}}],[11,"eq","","",24,{"inputs":[{"name":"self"},{"name":"range"}],"output":{"name":"bool"}}],[11,"ne","","",24,{"inputs":[{"name":"self"},{"name":"range"}],"output":{"name":"bool"}}],[11,"hash","","",24,null],[11,"fmt","","",24,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"contains","","Returns `true` if `item` is contained in the range.",24,{"inputs":[{"name":"self"},{"name":"u"}],"output":{"name":"bool"}}],[11,"is_empty","","Returns `true` if the range contains no items.",24,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",25,{"inputs":[{"name":"self"}],"output":{"name":"rangefrom"}}],[11,"eq","","",25,{"inputs":[{"name":"self"},{"name":"rangefrom"}],"output":{"name":"bool"}}],[11,"ne","","",25,{"inputs":[{"name":"self"},{"name":"rangefrom"}],"output":{"name":"bool"}}],[11,"hash","","",25,null],[11,"fmt","","",25,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"contains","","Returns `true` if `item` is contained in the range.",25,{"inputs":[{"name":"self"},{"name":"u"}],"output":{"name":"bool"}}],[11,"clone","","",26,{"inputs":[{"name":"self"}],"output":{"name":"rangeto"}}],[11,"eq","","",26,{"inputs":[{"name":"self"},{"name":"rangeto"}],"output":{"name":"bool"}}],[11,"ne","","",26,{"inputs":[{"name":"self"},{"name":"rangeto"}],"output":{"name":"bool"}}],[11,"hash","","",26,null],[11,"fmt","","",26,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"contains","","Returns `true` if `item` is contained in the range.",26,{"inputs":[{"name":"self"},{"name":"u"}],"output":{"name":"bool"}}],[11,"clone","","",31,{"inputs":[{"name":"self"}],"output":{"name":"rangeinclusive"}}],[11,"eq","","",31,{"inputs":[{"name":"self"},{"name":"rangeinclusive"}],"output":{"name":"bool"}}],[11,"ne","","",31,{"inputs":[{"name":"self"},{"name":"rangeinclusive"}],"output":{"name":"bool"}}],[11,"hash","","",31,null],[11,"new","","Creates a new inclusive range. Equivalent to writing `start..=end`.",31,{"inputs":[{"name":"idx"},{"name":"idx"}],"output":{"name":"self"}}],[11,"start","","Returns the lower bound of the range (inclusive).",31,{"inputs":[{"name":"self"}],"output":{"name":"idx"}}],[11,"end","","Returns the upper bound of the range (inclusive).",31,{"inputs":[{"name":"self"}],"output":{"name":"idx"}}],[11,"into_inner","","Destructures the `RangeInclusive` into (lower bound, upper (inclusive) bound).",31,null],[11,"fmt","","",31,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"contains","","Returns `true` if `item` is contained in the range.",31,{"inputs":[{"name":"self"},{"name":"u"}],"output":{"name":"bool"}}],[11,"is_empty","","Returns `true` if the range contains no items.",31,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",27,{"inputs":[{"name":"self"}],"output":{"name":"rangetoinclusive"}}],[11,"eq","","",27,{"inputs":[{"name":"self"},{"name":"rangetoinclusive"}],"output":{"name":"bool"}}],[11,"ne","","",27,{"inputs":[{"name":"self"},{"name":"rangetoinclusive"}],"output":{"name":"bool"}}],[11,"hash","","",27,null],[11,"fmt","","",27,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"contains","","Returns `true` if `item` is contained in the range.",27,{"inputs":[{"name":"self"},{"name":"u"}],"output":{"name":"bool"}}],[11,"clone","","",28,{"inputs":[{"name":"self"}],"output":{"name":"bound"}}],[11,"fmt","","",28,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",28,null],[11,"eq","","",28,{"inputs":[{"name":"self"},{"name":"bound"}],"output":{"name":"bool"}}],[11,"ne","","",28,{"inputs":[{"name":"self"},{"name":"bound"}],"output":{"name":"bool"}}],[11,"start","","",30,{"inputs":[{"name":"self"}],"output":{"name":"bound"}}],[11,"end","","",30,{"inputs":[{"name":"self"}],"output":{"name":"bound"}}],[11,"start","","",25,{"inputs":[{"name":"self"}],"output":{"name":"bound"}}],[11,"end","","",25,{"inputs":[{"name":"self"}],"output":{"name":"bound"}}],[11,"start","","",26,{"inputs":[{"name":"self"}],"output":{"name":"bound"}}],[11,"end","","",26,{"inputs":[{"name":"self"}],"output":{"name":"bound"}}],[11,"start","","",24,{"inputs":[{"name":"self"}],"output":{"name":"bound"}}],[11,"end","","",24,{"inputs":[{"name":"self"}],"output":{"name":"bound"}}],[11,"start","","",31,{"inputs":[{"name":"self"}],"output":{"name":"bound"}}],[11,"end","","",31,{"inputs":[{"name":"self"}],"output":{"name":"bound"}}],[11,"start","","",27,{"inputs":[{"name":"self"}],"output":{"name":"bound"}}],[11,"end","","",27,{"inputs":[{"name":"self"}],"output":{"name":"bound"}}],[11,"start","","",25,{"inputs":[{"name":"self"}],"output":{"name":"bound"}}],[11,"end","","",25,{"inputs":[{"name":"self"}],"output":{"name":"bound"}}],[11,"start","","",26,{"inputs":[{"name":"self"}],"output":{"name":"bound"}}],[11,"end","","",26,{"inputs":[{"name":"self"}],"output":{"name":"bound"}}],[11,"start","","",24,{"inputs":[{"name":"self"}],"output":{"name":"bound"}}],[11,"end","","",24,{"inputs":[{"name":"self"}],"output":{"name":"bound"}}],[11,"start","","",31,{"inputs":[{"name":"self"}],"output":{"name":"bound"}}],[11,"end","","",31,{"inputs":[{"name":"self"}],"output":{"name":"bound"}}],[11,"start","","",27,{"inputs":[{"name":"self"}],"output":{"name":"bound"}}],[11,"end","","",27,{"inputs":[{"name":"self"}],"output":{"name":"bound"}}],[8,"Add","","The addition operator `+`.",null,null],[16,"Output","","The resulting type after applying the `+` operator.",32,null],[10,"add","","Performs the `+` operation.",32,null],[8,"Sub","","The subtraction operator `-`.",null,null],[16,"Output","","The resulting type after applying the `-` operator.",33,null],[10,"sub","","Performs the `-` operation.",33,null],[8,"Mul","","The multiplication operator `*`.",null,null],[16,"Output","","The resulting type after applying the `*` operator.",34,null],[10,"mul","","Performs the `*` operation.",34,null],[8,"Div","","The division operator `/`.",null,null],[16,"Output","","The resulting type after applying the `/` operator.",35,null],[10,"div","","Performs the `/` operation.",35,null],[8,"Rem","","The remainder operator `%`.",null,null],[16,"Output","","The resulting type after applying the `%` operator.",36,null],[10,"rem","","Performs the `%` operation.",36,null],[8,"Neg","","The unary negation operator `-`.",null,null],[16,"Output","","The resulting type after applying the `-` operator.",37,null],[10,"neg","","Performs the unary `-` operation.",37,null],[8,"AddAssign","","The addition assignment operator `+=`.",null,null],[10,"add_assign","","Performs the `+=` operation.",38,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":null}],[8,"SubAssign","","The subtraction assignment operator `-=`.",null,null],[10,"sub_assign","","Performs the `-=` operation.",39,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":null}],[8,"MulAssign","","The multiplication assignment operator `*=`.",null,null],[10,"mul_assign","","Performs the `*=` operation.",40,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":null}],[8,"DivAssign","","The division assignment operator `/=`.",null,null],[10,"div_assign","","Performs the `/=` operation.",41,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":null}],[8,"RemAssign","","The remainder assignment operator `%=`.",null,null],[10,"rem_assign","","Performs the `%=` operation.",42,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":null}],[8,"Not","","The unary logical negation operator `!`.",null,null],[16,"Output","","The resulting type after applying the `!` operator.",43,null],[10,"not","","Performs the unary `!` operation.",43,null],[8,"BitAnd","","The bitwise AND operator `&`.",null,null],[16,"Output","","The resulting type after applying the `&` operator.",44,null],[10,"bitand","","Performs the `&` operation.",44,null],[8,"BitOr","","The bitwise OR operator `|`.",null,null],[16,"Output","","The resulting type after applying the `|` operator.",45,null],[10,"bitor","","Performs the `|` operation.",45,null],[8,"BitXor","","The bitwise XOR operator `^`.",null,null],[16,"Output","","The resulting type after applying the `^` operator.",46,null],[10,"bitxor","","Performs the `^` operation.",46,null],[8,"Shl","","The left shift operator `<<`. Note that because this trait is implemented for all integer types with multiple right-hand-side types, Rust's type checker has special handling for `_ << _`, setting the result type for integer operations to the type of the left-hand-side operand. This means that though `a << b` and `a.shl(b)` are one and the same from an evaluation standpoint, they are different when it comes to type inference.",null,null],[16,"Output","","The resulting type after applying the `<<` operator.",47,null],[10,"shl","","Performs the `<<` operation.",47,null],[8,"Shr","","The right shift operator `>>`. Note that because this trait is implemented for all integer types with multiple right-hand-side types, Rust's type checker has special handling for `_ >> _`, setting the result type for integer operations to the type of the left-hand-side operand. This means that though `a >> b` and `a.shr(b)` are one and the same from an evaluation standpoint, they are different when it comes to type inference.",null,null],[16,"Output","","The resulting type after applying the `>>` operator.",48,null],[10,"shr","","Performs the `>>` operation.",48,null],[8,"BitAndAssign","","The bitwise AND assignment operator `&=`.",null,null],[10,"bitand_assign","","Performs the `&=` operation.",49,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":null}],[8,"BitOrAssign","","The bitwise OR assignment operator `|=`.",null,null],[10,"bitor_assign","","Performs the `|=` operation.",50,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":null}],[8,"BitXorAssign","","The bitwise XOR assignment operator `^=`.",null,null],[10,"bitxor_assign","","Performs the `^=` operation.",51,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":null}],[8,"ShlAssign","","The left shift assignment operator `<<=`.",null,null],[10,"shl_assign","","Performs the `<<=` operation.",52,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":null}],[8,"ShrAssign","","The right shift assignment operator `>>=`.",null,null],[10,"shr_assign","","Performs the `>>=` operation.",53,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":null}],[8,"Deref","","Used for immutable dereferencing operations, like `*v`.",null,null],[16,"Target","","The resulting type after dereferencing.",54,null],[10,"deref","","Dereferences the value.",54,null],[8,"DerefMut","","Used for mutable dereferencing operations, like in `*v = 1;`.",null,null],[10,"deref_mut","","Mutably dereferences the value.",55,null],[8,"Drop","","Used to run some code when a value goes out of scope. This is sometimes called a 'destructor'.",null,null],[10,"drop","","Executes the destructor for this type.",56,{"inputs":[{"name":"self"}],"output":null}],[8,"Fn","","The version of the call operator that takes an immutable receiver.",null,null],[10,"call","","Performs the call operation.",57,null],[8,"FnMut","","The version of the call operator that takes a mutable receiver.",null,null],[10,"call_mut","","Performs the call operation.",58,null],[8,"FnOnce","","The version of the call operator that takes a by-value receiver.",null,null],[16,"Output","","The returned type after the call operator is used.",59,null],[10,"call_once","","Performs the call operation.",59,null],[8,"Index","","Used for indexing operations (`container[index]`) in immutable contexts.",null,null],[16,"Output","","The returned type after indexing.",60,null],[10,"index","","Performs the indexing (`container[index]`) operation.",60,null],[8,"IndexMut","","Used for indexing operations (`container[index]`) in mutable contexts.",null,null],[10,"index_mut","","Performs the mutable indexing (`container[index]`) operation.",61,null],[8,"RangeBounds","","`RangeBounds` is implemented by Rust's built-in range types, produced by range syntax like `..`, `a..`, `..b` or `c..d`.",null,null],[10,"start","","Start index bound.",62,{"inputs":[{"name":"self"}],"output":{"name":"bound"}}],[10,"end","","End index bound.",62,{"inputs":[{"name":"self"}],"output":{"name":"bound"}}],[11,"contains","","Returns `true` if `item` is contained in the range.",62,{"inputs":[{"name":"self"},{"name":"u"}],"output":{"name":"bool"}}],[8,"Try","","A trait for customizing the behavior of the `?` operator.",null,null],[16,"Ok","","The type of this value when viewed as successful.",63,null],[16,"Error","","The type of this value when viewed as failed.",63,null],[10,"into_result","","Applies the \"?\" operator. A return of `Ok(t)` means that the execution should continue normally, and the result of `?` is the value `t`. A return of `Err(e)` means that execution should branch to the innermost enclosing `catch`, or return from the function.",63,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[10,"from_error","","Wrap an error value to construct the composite result. For example, `Result::Err(x)` and `Result::from_error(x)` are equivalent.",63,null],[10,"from_ok","","Wrap an OK value to construct the composite result. For example, `Result::Ok(x)` and `Result::from_ok(x)` are equivalent.",63,null],[8,"Generator","","The trait implemented by builtin generator types.",null,null],[16,"Yield","","The type of value this generator yields.",64,null],[16,"Return","","The type of value this generator returns.",64,null],[10,"resume","","Resumes the execution of this generator.",64,{"inputs":[{"name":"self"}],"output":{"name":"generatorstate"}}],[8,"CoerceUnsized","","Trait that indicates that this is a pointer or a wrapper for one, where unsizing can be performed on the pointee.",null,null],[0,"cmp","core","Functionality for ordering and comparison.",null,null],[3,"Reverse","core::cmp","A helper struct for reverse ordering.",null,null],[12,"0","","",65,null],[4,"Ordering","","An `Ordering` is the result of a comparison between two values.",null,null],[13,"Less","","An ordering where a compared value is less [than another].",66,null],[13,"Equal","","An ordering where a compared value is equal [to another].",66,null],[13,"Greater","","An ordering where a compared value is greater [than another].",66,null],[5,"min","","Compares and returns the minimum of two values.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"max","","Compares and returns the maximum of two values.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[8,"PartialEq","","Trait for equality comparisons which are partial equivalence relations.",null,null],[10,"eq","","This method tests for `self` and `other` values to be equal, and is used by `==`.",67,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":{"name":"bool"}}],[11,"ne","","This method tests for `!=`.",67,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":{"name":"bool"}}],[8,"Eq","","Trait for equality comparisons which are equivalence relations.",null,null],[8,"Ord","","Trait for types that form a total order.",null,null],[10,"cmp","","This method returns an `Ordering` between `self` and `other`.",68,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"ordering"}}],[11,"max","","Compares and returns the maximum of two values.",68,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"self"}}],[11,"min","","Compares and returns the minimum of two values.",68,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"self"}}],[8,"PartialOrd","","Trait for values that can be compared for a sort-order.",null,null],[10,"partial_cmp","","This method returns an ordering between `self` and `other` values if one exists.",69,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","This method tests less than (for `self` and `other`) and is used by the `<` operator.",69,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":{"name":"bool"}}],[11,"le","","This method tests less than or equal to (for `self` and `other`) and is used by the `<=` operator.",69,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":{"name":"bool"}}],[11,"gt","","This method tests greater than (for `self` and `other`) and is used by the `>` operator.",69,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":{"name":"bool"}}],[11,"ge","","This method tests greater than or equal to (for `self` and `other`) and is used by the `>=` operator.",69,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":{"name":"bool"}}],[11,"clone","","",66,{"inputs":[{"name":"self"}],"output":{"name":"ordering"}}],[11,"eq","","",66,{"inputs":[{"name":"self"},{"name":"ordering"}],"output":{"name":"bool"}}],[11,"fmt","","",66,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",66,null],[11,"reverse","","Reverses the `Ordering`.",66,{"inputs":[{"name":"self"}],"output":{"name":"ordering"}}],[11,"then","","Chains two orderings.",66,{"inputs":[{"name":"self"},{"name":"ordering"}],"output":{"name":"ordering"}}],[11,"then_with","","Chains the ordering with the given function.",66,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"ordering"}}],[11,"eq","","",65,{"inputs":[{"name":"self"},{"name":"reverse"}],"output":{"name":"bool"}}],[11,"ne","","",65,{"inputs":[{"name":"self"},{"name":"reverse"}],"output":{"name":"bool"}}],[11,"fmt","","",65,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",65,{"inputs":[{"name":"self"}],"output":{"name":"reverse"}}],[11,"default","","",65,{"inputs":[],"output":{"name":"reverse"}}],[11,"hash","","",65,null],[11,"partial_cmp","","",65,{"inputs":[{"name":"self"},{"name":"reverse"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",65,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"bool"}}],[11,"le","","",65,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"bool"}}],[11,"ge","","",65,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"bool"}}],[11,"gt","","",65,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"bool"}}],[11,"cmp","","",65,{"inputs":[{"name":"self"},{"name":"reverse"}],"output":{"name":"ordering"}}],[11,"cmp","","",66,{"inputs":[{"name":"self"},{"name":"ordering"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",66,{"inputs":[{"name":"self"},{"name":"ordering"}],"output":{"generics":["ordering"],"name":"option"}}],[0,"clone","core","The `Clone` trait for types that cannot be 'implicitly copied'.",null,null],[8,"Clone","core::clone","A common trait for the ability to explicitly duplicate an object.",null,null],[10,"clone","","Returns a copy of the value.",70,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"clone_from","","Performs copy-assignment from `source`.",70,{"inputs":[{"name":"self"},{"name":"self"}],"output":null}],[0,"default","core","The `Default` trait for types which may have meaningful default values.",null,null],[8,"Default","core::default","A trait for giving a type a useful default value.",null,null],[10,"default","","Returns the \"default value\" for a type.",71,{"inputs":[],"output":{"name":"self"}}],[0,"convert","core","Traits for conversions between types.",null,null],[8,"AsRef","core::convert","A cheap reference-to-reference conversion. Used to convert a value to a reference value within generic code.",null,null],[10,"as_ref","","Performs the conversion.",72,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[8,"AsMut","","A cheap, mutable reference-to-mutable reference conversion.",null,null],[10,"as_mut","","Performs the conversion.",73,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[8,"Into","","A conversion that consumes `self`, which may or may not be expensive. The reciprocal of [`From`][From].",null,null],[10,"into","","Performs the conversion.",74,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[8,"From","","Simple and safe type conversions in to `Self`. It is the reciprocal of `Into`.",null,null],[10,"from","","Performs the conversion.",75,{"inputs":[{"name":"t"}],"output":{"name":"self"}}],[8,"TryInto","","An attempted conversion that consumes `self`, which may or may not be expensive.",null,null],[16,"Error","","The type returned in the event of a conversion error.",76,null],[10,"try_into","","Performs the conversion.",76,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[8,"TryFrom","","Attempt to construct `Self` via a conversion.",null,null],[16,"Error","","The type returned in the event of a conversion error.",77,null],[10,"try_from","","Performs the conversion.",77,{"inputs":[{"name":"t"}],"output":{"name":"result"}}],[0,"borrow","core","A module for working with borrowed data.",null,null],[8,"Borrow","core::borrow","A trait for borrowing data.",null,null],[10,"borrow","","Immutably borrows from an owned value.",78,{"inputs":[{"name":"self"}],"output":{"name":"borrowed"}}],[8,"BorrowMut","","A trait for mutably borrowing data.",null,null],[10,"borrow_mut","","Mutably borrows from an owned value.",79,{"inputs":[{"name":"self"}],"output":{"name":"borrowed"}}],[0,"any","core","This module implements the `Any` trait, which enables dynamic typing of any `'static` type through runtime reflection.",null,null],[3,"TypeId","core::any","A `TypeId` represents a globally unique identifier for a type.",null,null],[8,"Any","","A type to emulate dynamic typing.",null,null],[10,"get_type_id","","Gets the `TypeId` of `self`.",80,{"inputs":[{"name":"self"}],"output":{"name":"typeid"}}],[11,"fmt","","",80,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",80,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"is","","Returns `true` if the boxed type is the same as `T`.",80,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"downcast_ref","","Returns some reference to the boxed value if it is of type `T`, or `None` if it isn't.",80,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"downcast_mut","","Returns some mutable reference to the boxed value if it is of type `T`, or `None` if it isn't.",80,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"is","","Forwards to the method defined on the type `Any`.",80,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"downcast_ref","","Forwards to the method defined on the type `Any`.",80,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"downcast_mut","","Forwards to the method defined on the type `Any`.",80,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",81,{"inputs":[{"name":"self"}],"output":{"name":"typeid"}}],[11,"eq","","",81,{"inputs":[{"name":"self"},{"name":"typeid"}],"output":{"name":"bool"}}],[11,"ne","","",81,{"inputs":[{"name":"self"},{"name":"typeid"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",81,{"inputs":[{"name":"self"},{"name":"typeid"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",81,{"inputs":[{"name":"self"},{"name":"typeid"}],"output":{"name":"bool"}}],[11,"le","","",81,{"inputs":[{"name":"self"},{"name":"typeid"}],"output":{"name":"bool"}}],[11,"gt","","",81,{"inputs":[{"name":"self"},{"name":"typeid"}],"output":{"name":"bool"}}],[11,"ge","","",81,{"inputs":[{"name":"self"},{"name":"typeid"}],"output":{"name":"bool"}}],[11,"cmp","","",81,{"inputs":[{"name":"self"},{"name":"typeid"}],"output":{"name":"ordering"}}],[11,"fmt","","",81,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",81,null],[11,"of","","Returns the `TypeId` of the type this generic function has been instantiated with.",81,{"inputs":[],"output":{"name":"typeid"}}],[0,"array","core","Implementations of things like `Eq` for fixed-length arrays up to a certain length. Eventually we should able to generalize to all lengths.",null,null],[3,"TryFromSliceError","core::array","The error type returned when a conversion from a slice to an array fails.",null,null],[8,"FixedSizeArray","","Utility trait implemented only on arrays of fixed size",null,null],[10,"as_slice","","Converts the array to immutable slice",82,null],[10,"as_mut_slice","","Converts the array to mutable slice",82,null],[11,"fmt","","",83,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",83,{"inputs":[{"name":"self"}],"output":{"name":"tryfromsliceerror"}}],[11,"fmt","","",83,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[0,"ascii","core","Operations on ASCII strings and characters.",null,null],[3,"EscapeDefault","core::ascii","An iterator over the escaped version of a byte.",null,null],[5,"escape_default","","Returns an iterator that produces an escaped version of a `u8`.",null,{"inputs":[{"name":"u8"}],"output":{"name":"escapedefault"}}],[11,"next","","",84,{"inputs":[{"name":"self"}],"output":{"generics":["u8"],"name":"option"}}],[11,"size_hint","","",84,null],[11,"next_back","","",84,{"inputs":[{"name":"self"}],"output":{"generics":["u8"],"name":"option"}}],[11,"fmt","","",84,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[0,"sync","core","Synchronization primitives",null,null],[0,"atomic","core::sync","Atomic types",null,null],[3,"AtomicBool","core::sync::atomic","A boolean type which can be safely shared between threads.",null,null],[3,"AtomicPtr","","A raw pointer type which can be safely shared between threads.",null,null],[3,"AtomicI8","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicU8","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicI16","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicU16","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicI32","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicU32","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicI64","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicU64","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicIsize","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicUsize","","An integer type which can be safely shared between threads.",null,null],[4,"Ordering","","Atomic memory orderings",null,null],[13,"Relaxed","","No ordering constraints, only atomic operations.",85,null],[13,"Release","","When coupled with a store, all previous writes become visible to the other threads that perform a load with [`Acquire`] ordering on the same value.",85,null],[13,"Acquire","","When coupled with a load, all subsequent loads will see data written before a store with [`Release`] ordering on the same value in other threads.",85,null],[13,"AcqRel","","Has the effects of both [`Acquire`] and [`Release`] together.",85,null],[13,"SeqCst","","Like `AcqRel` with the additional guarantee that all threads see all sequentially consistent operations in the same order.",85,null],[5,"spin_loop_hint","","Save power or switch hyperthreads in a busy-wait spin-loop.",null,{"inputs":[],"output":null}],[5,"fence","","An atomic fence.",null,{"inputs":[{"name":"ordering"}],"output":null}],[5,"compiler_fence","","A compiler memory fence.",null,{"inputs":[{"name":"ordering"}],"output":null}],[17,"ATOMIC_BOOL_INIT","","An [`AtomicBool`] initialized to `false`.",null,null],[17,"ATOMIC_I8_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_U8_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_I16_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_U16_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_I32_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_U32_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_I64_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_U64_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_ISIZE_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_USIZE_INIT","","An atomic integer initialized to `0`.",null,null],[11,"default","","Creates an `AtomicBool` initialized to `false`.",86,{"inputs":[],"output":{"name":"self"}}],[11,"default","","Creates a null `AtomicPtr<T>`.",87,{"inputs":[],"output":{"name":"atomicptr"}}],[11,"clone","","",85,{"inputs":[{"name":"self"}],"output":{"name":"ordering"}}],[11,"fmt","","",85,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new `AtomicBool`.",86,{"inputs":[{"name":"bool"}],"output":{"name":"atomicbool"}}],[11,"get_mut","","Returns a mutable reference to the underlying [`bool`].",86,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"into_inner","","Consumes the atomic and returns the contained value.",86,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"load","","Loads a value from the bool.",86,{"inputs":[{"name":"self"},{"name":"ordering"}],"output":{"name":"bool"}}],[11,"store","","Stores a value into the bool.",86,{"inputs":[{"name":"self"},{"name":"bool"},{"name":"ordering"}],"output":null}],[11,"swap","","Stores a value into the bool, returning the previous value.",86,{"inputs":[{"name":"self"},{"name":"bool"},{"name":"ordering"}],"output":{"name":"bool"}}],[11,"compare_and_swap","","Stores a value into the [`bool`] if the current value is the same as the `current` value.",86,{"inputs":[{"name":"self"},{"name":"bool"},{"name":"bool"},{"name":"ordering"}],"output":{"name":"bool"}}],[11,"compare_exchange","","Stores a value into the [`bool`] if the current value is the same as the `current` value.",86,{"inputs":[{"name":"self"},{"name":"bool"},{"name":"bool"},{"name":"ordering"},{"name":"ordering"}],"output":{"generics":["bool","bool"],"name":"result"}}],[11,"compare_exchange_weak","","Stores a value into the [`bool`] if the current value is the same as the `current` value.",86,{"inputs":[{"name":"self"},{"name":"bool"},{"name":"bool"},{"name":"ordering"},{"name":"ordering"}],"output":{"generics":["bool","bool"],"name":"result"}}],[11,"fetch_and","","Logical \"and\" with a boolean value.",86,{"inputs":[{"name":"self"},{"name":"bool"},{"name":"ordering"}],"output":{"name":"bool"}}],[11,"fetch_nand","","Logical \"nand\" with a boolean value.",86,{"inputs":[{"name":"self"},{"name":"bool"},{"name":"ordering"}],"output":{"name":"bool"}}],[11,"fetch_or","","Logical \"or\" with a boolean value.",86,{"inputs":[{"name":"self"},{"name":"bool"},{"name":"ordering"}],"output":{"name":"bool"}}],[11,"fetch_xor","","Logical \"xor\" with a boolean value.",86,{"inputs":[{"name":"self"},{"name":"bool"},{"name":"ordering"}],"output":{"name":"bool"}}],[11,"new","","Creates a new `AtomicPtr`.",87,null],[11,"get_mut","","Returns a mutable reference to the underlying pointer.",87,null],[11,"into_inner","","Consumes the atomic and returns the contained value.",87,null],[11,"load","","Loads a value from the pointer.",87,null],[11,"store","","Stores a value into the pointer.",87,null],[11,"swap","","Stores a value into the pointer, returning the previous value.",87,null],[11,"compare_and_swap","","Stores a value into the pointer if the current value is the same as the `current` value.",87,null],[11,"compare_exchange","","Stores a value into the pointer if the current value is the same as the `current` value.",87,null],[11,"compare_exchange_weak","","Stores a value into the pointer if the current value is the same as the `current` value.",87,null],[11,"from","","",86,{"inputs":[{"name":"bool"}],"output":{"name":"self"}}],[11,"from","","",87,null],[11,"default","","",88,{"inputs":[],"output":{"name":"self"}}],[11,"from","","",88,{"inputs":[{"name":"i8"}],"output":{"name":"self"}}],[11,"fmt","","",88,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new atomic integer.",88,{"inputs":[{"name":"i8"}],"output":{"name":"self"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",88,{"inputs":[{"name":"self"}],"output":{"name":"i8"}}],[11,"into_inner","","Consumes the atomic and returns the contained value.",88,{"inputs":[{"name":"self"}],"output":{"name":"i8"}}],[11,"load","","Loads a value from the atomic integer.",88,{"inputs":[{"name":"self"},{"name":"ordering"}],"output":{"name":"i8"}}],[11,"store","","Stores a value into the atomic integer.",88,{"inputs":[{"name":"self"},{"name":"i8"},{"name":"ordering"}],"output":null}],[11,"swap","","Stores a value into the atomic integer, returning the previous value.",88,{"inputs":[{"name":"self"},{"name":"i8"},{"name":"ordering"}],"output":{"name":"i8"}}],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",88,{"inputs":[{"name":"self"},{"name":"i8"},{"name":"i8"},{"name":"ordering"}],"output":{"name":"i8"}}],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",88,{"inputs":[{"name":"self"},{"name":"i8"},{"name":"i8"},{"name":"ordering"},{"name":"ordering"}],"output":{"generics":["i8","i8"],"name":"result"}}],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",88,{"inputs":[{"name":"self"},{"name":"i8"},{"name":"i8"},{"name":"ordering"},{"name":"ordering"}],"output":{"generics":["i8","i8"],"name":"result"}}],[11,"fetch_add","","Adds to the current value, returning the previous value.",88,{"inputs":[{"name":"self"},{"name":"i8"},{"name":"ordering"}],"output":{"name":"i8"}}],[11,"fetch_sub","","Subtracts from the current value, returning the previous value.",88,{"inputs":[{"name":"self"},{"name":"i8"},{"name":"ordering"}],"output":{"name":"i8"}}],[11,"fetch_and","","Bitwise \"and\" with the current value.",88,{"inputs":[{"name":"self"},{"name":"i8"},{"name":"ordering"}],"output":{"name":"i8"}}],[11,"fetch_nand","","Bitwise \"nand\" with the current value.",88,{"inputs":[{"name":"self"},{"name":"i8"},{"name":"ordering"}],"output":{"name":"i8"}}],[11,"fetch_or","","Bitwise \"or\" with the current value.",88,{"inputs":[{"name":"self"},{"name":"i8"},{"name":"ordering"}],"output":{"name":"i8"}}],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",88,{"inputs":[{"name":"self"},{"name":"i8"},{"name":"ordering"}],"output":{"name":"i8"}}],[11,"fetch_update","","Fetches the value, and applies a function to it that returns an optional new value. Returns a `Result` of `Ok(previous_value)` if the function returned `Some(_)`, else `Err(previous_value)`.",88,{"inputs":[{"name":"self"},{"name":"f"},{"name":"ordering"},{"name":"ordering"}],"output":{"generics":["i8","i8"],"name":"result"}}],[11,"fetch_max","","Maximum with the current value.",88,{"inputs":[{"name":"self"},{"name":"i8"},{"name":"ordering"}],"output":{"name":"i8"}}],[11,"fetch_min","","Minimum with the current value.",88,{"inputs":[{"name":"self"},{"name":"i8"},{"name":"ordering"}],"output":{"name":"i8"}}],[11,"default","","",89,{"inputs":[],"output":{"name":"self"}}],[11,"from","","",89,{"inputs":[{"name":"u8"}],"output":{"name":"self"}}],[11,"fmt","","",89,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new atomic integer.",89,{"inputs":[{"name":"u8"}],"output":{"name":"self"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",89,{"inputs":[{"name":"self"}],"output":{"name":"u8"}}],[11,"into_inner","","Consumes the atomic and returns the contained value.",89,{"inputs":[{"name":"self"}],"output":{"name":"u8"}}],[11,"load","","Loads a value from the atomic integer.",89,{"inputs":[{"name":"self"},{"name":"ordering"}],"output":{"name":"u8"}}],[11,"store","","Stores a value into the atomic integer.",89,{"inputs":[{"name":"self"},{"name":"u8"},{"name":"ordering"}],"output":null}],[11,"swap","","Stores a value into the atomic integer, returning the previous value.",89,{"inputs":[{"name":"self"},{"name":"u8"},{"name":"ordering"}],"output":{"name":"u8"}}],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",89,{"inputs":[{"name":"self"},{"name":"u8"},{"name":"u8"},{"name":"ordering"}],"output":{"name":"u8"}}],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",89,{"inputs":[{"name":"self"},{"name":"u8"},{"name":"u8"},{"name":"ordering"},{"name":"ordering"}],"output":{"generics":["u8","u8"],"name":"result"}}],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",89,{"inputs":[{"name":"self"},{"name":"u8"},{"name":"u8"},{"name":"ordering"},{"name":"ordering"}],"output":{"generics":["u8","u8"],"name":"result"}}],[11,"fetch_add","","Adds to the current value, returning the previous value.",89,{"inputs":[{"name":"self"},{"name":"u8"},{"name":"ordering"}],"output":{"name":"u8"}}],[11,"fetch_sub","","Subtracts from the current value, returning the previous value.",89,{"inputs":[{"name":"self"},{"name":"u8"},{"name":"ordering"}],"output":{"name":"u8"}}],[11,"fetch_and","","Bitwise \"and\" with the current value.",89,{"inputs":[{"name":"self"},{"name":"u8"},{"name":"ordering"}],"output":{"name":"u8"}}],[11,"fetch_nand","","Bitwise \"nand\" with the current value.",89,{"inputs":[{"name":"self"},{"name":"u8"},{"name":"ordering"}],"output":{"name":"u8"}}],[11,"fetch_or","","Bitwise \"or\" with the current value.",89,{"inputs":[{"name":"self"},{"name":"u8"},{"name":"ordering"}],"output":{"name":"u8"}}],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",89,{"inputs":[{"name":"self"},{"name":"u8"},{"name":"ordering"}],"output":{"name":"u8"}}],[11,"fetch_update","","Fetches the value, and applies a function to it that returns an optional new value. Returns a `Result` of `Ok(previous_value)` if the function returned `Some(_)`, else `Err(previous_value)`.",89,{"inputs":[{"name":"self"},{"name":"f"},{"name":"ordering"},{"name":"ordering"}],"output":{"generics":["u8","u8"],"name":"result"}}],[11,"fetch_max","","Maximum with the current value.",89,{"inputs":[{"name":"self"},{"name":"u8"},{"name":"ordering"}],"output":{"name":"u8"}}],[11,"fetch_min","","Minimum with the current value.",89,{"inputs":[{"name":"self"},{"name":"u8"},{"name":"ordering"}],"output":{"name":"u8"}}],[11,"default","","",90,{"inputs":[],"output":{"name":"self"}}],[11,"from","","",90,{"inputs":[{"name":"i16"}],"output":{"name":"self"}}],[11,"fmt","","",90,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new atomic integer.",90,{"inputs":[{"name":"i16"}],"output":{"name":"self"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",90,{"inputs":[{"name":"self"}],"output":{"name":"i16"}}],[11,"into_inner","","Consumes the atomic and returns the contained value.",90,{"inputs":[{"name":"self"}],"output":{"name":"i16"}}],[11,"load","","Loads a value from the atomic integer.",90,{"inputs":[{"name":"self"},{"name":"ordering"}],"output":{"name":"i16"}}],[11,"store","","Stores a value into the atomic integer.",90,{"inputs":[{"name":"self"},{"name":"i16"},{"name":"ordering"}],"output":null}],[11,"swap","","Stores a value into the atomic integer, returning the previous value.",90,{"inputs":[{"name":"self"},{"name":"i16"},{"name":"ordering"}],"output":{"name":"i16"}}],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",90,{"inputs":[{"name":"self"},{"name":"i16"},{"name":"i16"},{"name":"ordering"}],"output":{"name":"i16"}}],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",90,{"inputs":[{"name":"self"},{"name":"i16"},{"name":"i16"},{"name":"ordering"},{"name":"ordering"}],"output":{"generics":["i16","i16"],"name":"result"}}],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",90,{"inputs":[{"name":"self"},{"name":"i16"},{"name":"i16"},{"name":"ordering"},{"name":"ordering"}],"output":{"generics":["i16","i16"],"name":"result"}}],[11,"fetch_add","","Adds to the current value, returning the previous value.",90,{"inputs":[{"name":"self"},{"name":"i16"},{"name":"ordering"}],"output":{"name":"i16"}}],[11,"fetch_sub","","Subtracts from the current value, returning the previous value.",90,{"inputs":[{"name":"self"},{"name":"i16"},{"name":"ordering"}],"output":{"name":"i16"}}],[11,"fetch_and","","Bitwise \"and\" with the current value.",90,{"inputs":[{"name":"self"},{"name":"i16"},{"name":"ordering"}],"output":{"name":"i16"}}],[11,"fetch_nand","","Bitwise \"nand\" with the current value.",90,{"inputs":[{"name":"self"},{"name":"i16"},{"name":"ordering"}],"output":{"name":"i16"}}],[11,"fetch_or","","Bitwise \"or\" with the current value.",90,{"inputs":[{"name":"self"},{"name":"i16"},{"name":"ordering"}],"output":{"name":"i16"}}],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",90,{"inputs":[{"name":"self"},{"name":"i16"},{"name":"ordering"}],"output":{"name":"i16"}}],[11,"fetch_update","","Fetches the value, and applies a function to it that returns an optional new value. Returns a `Result` of `Ok(previous_value)` if the function returned `Some(_)`, else `Err(previous_value)`.",90,{"inputs":[{"name":"self"},{"name":"f"},{"name":"ordering"},{"name":"ordering"}],"output":{"generics":["i16","i16"],"name":"result"}}],[11,"fetch_max","","Maximum with the current value.",90,{"inputs":[{"name":"self"},{"name":"i16"},{"name":"ordering"}],"output":{"name":"i16"}}],[11,"fetch_min","","Minimum with the current value.",90,{"inputs":[{"name":"self"},{"name":"i16"},{"name":"ordering"}],"output":{"name":"i16"}}],[11,"default","","",91,{"inputs":[],"output":{"name":"self"}}],[11,"from","","",91,{"inputs":[{"name":"u16"}],"output":{"name":"self"}}],[11,"fmt","","",91,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new atomic integer.",91,{"inputs":[{"name":"u16"}],"output":{"name":"self"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",91,{"inputs":[{"name":"self"}],"output":{"name":"u16"}}],[11,"into_inner","","Consumes the atomic and returns the contained value.",91,{"inputs":[{"name":"self"}],"output":{"name":"u16"}}],[11,"load","","Loads a value from the atomic integer.",91,{"inputs":[{"name":"self"},{"name":"ordering"}],"output":{"name":"u16"}}],[11,"store","","Stores a value into the atomic integer.",91,{"inputs":[{"name":"self"},{"name":"u16"},{"name":"ordering"}],"output":null}],[11,"swap","","Stores a value into the atomic integer, returning the previous value.",91,{"inputs":[{"name":"self"},{"name":"u16"},{"name":"ordering"}],"output":{"name":"u16"}}],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",91,{"inputs":[{"name":"self"},{"name":"u16"},{"name":"u16"},{"name":"ordering"}],"output":{"name":"u16"}}],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",91,{"inputs":[{"name":"self"},{"name":"u16"},{"name":"u16"},{"name":"ordering"},{"name":"ordering"}],"output":{"generics":["u16","u16"],"name":"result"}}],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",91,{"inputs":[{"name":"self"},{"name":"u16"},{"name":"u16"},{"name":"ordering"},{"name":"ordering"}],"output":{"generics":["u16","u16"],"name":"result"}}],[11,"fetch_add","","Adds to the current value, returning the previous value.",91,{"inputs":[{"name":"self"},{"name":"u16"},{"name":"ordering"}],"output":{"name":"u16"}}],[11,"fetch_sub","","Subtracts from the current value, returning the previous value.",91,{"inputs":[{"name":"self"},{"name":"u16"},{"name":"ordering"}],"output":{"name":"u16"}}],[11,"fetch_and","","Bitwise \"and\" with the current value.",91,{"inputs":[{"name":"self"},{"name":"u16"},{"name":"ordering"}],"output":{"name":"u16"}}],[11,"fetch_nand","","Bitwise \"nand\" with the current value.",91,{"inputs":[{"name":"self"},{"name":"u16"},{"name":"ordering"}],"output":{"name":"u16"}}],[11,"fetch_or","","Bitwise \"or\" with the current value.",91,{"inputs":[{"name":"self"},{"name":"u16"},{"name":"ordering"}],"output":{"name":"u16"}}],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",91,{"inputs":[{"name":"self"},{"name":"u16"},{"name":"ordering"}],"output":{"name":"u16"}}],[11,"fetch_update","","Fetches the value, and applies a function to it that returns an optional new value. Returns a `Result` of `Ok(previous_value)` if the function returned `Some(_)`, else `Err(previous_value)`.",91,{"inputs":[{"name":"self"},{"name":"f"},{"name":"ordering"},{"name":"ordering"}],"output":{"generics":["u16","u16"],"name":"result"}}],[11,"fetch_max","","Maximum with the current value.",91,{"inputs":[{"name":"self"},{"name":"u16"},{"name":"ordering"}],"output":{"name":"u16"}}],[11,"fetch_min","","Minimum with the current value.",91,{"inputs":[{"name":"self"},{"name":"u16"},{"name":"ordering"}],"output":{"name":"u16"}}],[11,"default","","",92,{"inputs":[],"output":{"name":"self"}}],[11,"from","","",92,{"inputs":[{"name":"i32"}],"output":{"name":"self"}}],[11,"fmt","","",92,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new atomic integer.",92,{"inputs":[{"name":"i32"}],"output":{"name":"self"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",92,{"inputs":[{"name":"self"}],"output":{"name":"i32"}}],[11,"into_inner","","Consumes the atomic and returns the contained value.",92,{"inputs":[{"name":"self"}],"output":{"name":"i32"}}],[11,"load","","Loads a value from the atomic integer.",92,{"inputs":[{"name":"self"},{"name":"ordering"}],"output":{"name":"i32"}}],[11,"store","","Stores a value into the atomic integer.",92,{"inputs":[{"name":"self"},{"name":"i32"},{"name":"ordering"}],"output":null}],[11,"swap","","Stores a value into the atomic integer, returning the previous value.",92,{"inputs":[{"name":"self"},{"name":"i32"},{"name":"ordering"}],"output":{"name":"i32"}}],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",92,{"inputs":[{"name":"self"},{"name":"i32"},{"name":"i32"},{"name":"ordering"}],"output":{"name":"i32"}}],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",92,{"inputs":[{"name":"self"},{"name":"i32"},{"name":"i32"},{"name":"ordering"},{"name":"ordering"}],"output":{"generics":["i32","i32"],"name":"result"}}],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",92,{"inputs":[{"name":"self"},{"name":"i32"},{"name":"i32"},{"name":"ordering"},{"name":"ordering"}],"output":{"generics":["i32","i32"],"name":"result"}}],[11,"fetch_add","","Adds to the current value, returning the previous value.",92,{"inputs":[{"name":"self"},{"name":"i32"},{"name":"ordering"}],"output":{"name":"i32"}}],[11,"fetch_sub","","Subtracts from the current value, returning the previous value.",92,{"inputs":[{"name":"self"},{"name":"i32"},{"name":"ordering"}],"output":{"name":"i32"}}],[11,"fetch_and","","Bitwise \"and\" with the current value.",92,{"inputs":[{"name":"self"},{"name":"i32"},{"name":"ordering"}],"output":{"name":"i32"}}],[11,"fetch_nand","","Bitwise \"nand\" with the current value.",92,{"inputs":[{"name":"self"},{"name":"i32"},{"name":"ordering"}],"output":{"name":"i32"}}],[11,"fetch_or","","Bitwise \"or\" with the current value.",92,{"inputs":[{"name":"self"},{"name":"i32"},{"name":"ordering"}],"output":{"name":"i32"}}],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",92,{"inputs":[{"name":"self"},{"name":"i32"},{"name":"ordering"}],"output":{"name":"i32"}}],[11,"fetch_update","","Fetches the value, and applies a function to it that returns an optional new value. Returns a `Result` of `Ok(previous_value)` if the function returned `Some(_)`, else `Err(previous_value)`.",92,{"inputs":[{"name":"self"},{"name":"f"},{"name":"ordering"},{"name":"ordering"}],"output":{"generics":["i32","i32"],"name":"result"}}],[11,"fetch_max","","Maximum with the current value.",92,{"inputs":[{"name":"self"},{"name":"i32"},{"name":"ordering"}],"output":{"name":"i32"}}],[11,"fetch_min","","Minimum with the current value.",92,{"inputs":[{"name":"self"},{"name":"i32"},{"name":"ordering"}],"output":{"name":"i32"}}],[11,"default","","",93,{"inputs":[],"output":{"name":"self"}}],[11,"from","","",93,{"inputs":[{"name":"u32"}],"output":{"name":"self"}}],[11,"fmt","","",93,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new atomic integer.",93,{"inputs":[{"name":"u32"}],"output":{"name":"self"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",93,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"into_inner","","Consumes the atomic and returns the contained value.",93,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"load","","Loads a value from the atomic integer.",93,{"inputs":[{"name":"self"},{"name":"ordering"}],"output":{"name":"u32"}}],[11,"store","","Stores a value into the atomic integer.",93,{"inputs":[{"name":"self"},{"name":"u32"},{"name":"ordering"}],"output":null}],[11,"swap","","Stores a value into the atomic integer, returning the previous value.",93,{"inputs":[{"name":"self"},{"name":"u32"},{"name":"ordering"}],"output":{"name":"u32"}}],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",93,{"inputs":[{"name":"self"},{"name":"u32"},{"name":"u32"},{"name":"ordering"}],"output":{"name":"u32"}}],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",93,{"inputs":[{"name":"self"},{"name":"u32"},{"name":"u32"},{"name":"ordering"},{"name":"ordering"}],"output":{"generics":["u32","u32"],"name":"result"}}],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",93,{"inputs":[{"name":"self"},{"name":"u32"},{"name":"u32"},{"name":"ordering"},{"name":"ordering"}],"output":{"generics":["u32","u32"],"name":"result"}}],[11,"fetch_add","","Adds to the current value, returning the previous value.",93,{"inputs":[{"name":"self"},{"name":"u32"},{"name":"ordering"}],"output":{"name":"u32"}}],[11,"fetch_sub","","Subtracts from the current value, returning the previous value.",93,{"inputs":[{"name":"self"},{"name":"u32"},{"name":"ordering"}],"output":{"name":"u32"}}],[11,"fetch_and","","Bitwise \"and\" with the current value.",93,{"inputs":[{"name":"self"},{"name":"u32"},{"name":"ordering"}],"output":{"name":"u32"}}],[11,"fetch_nand","","Bitwise \"nand\" with the current value.",93,{"inputs":[{"name":"self"},{"name":"u32"},{"name":"ordering"}],"output":{"name":"u32"}}],[11,"fetch_or","","Bitwise \"or\" with the current value.",93,{"inputs":[{"name":"self"},{"name":"u32"},{"name":"ordering"}],"output":{"name":"u32"}}],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",93,{"inputs":[{"name":"self"},{"name":"u32"},{"name":"ordering"}],"output":{"name":"u32"}}],[11,"fetch_update","","Fetches the value, and applies a function to it that returns an optional new value. Returns a `Result` of `Ok(previous_value)` if the function returned `Some(_)`, else `Err(previous_value)`.",93,{"inputs":[{"name":"self"},{"name":"f"},{"name":"ordering"},{"name":"ordering"}],"output":{"generics":["u32","u32"],"name":"result"}}],[11,"fetch_max","","Maximum with the current value.",93,{"inputs":[{"name":"self"},{"name":"u32"},{"name":"ordering"}],"output":{"name":"u32"}}],[11,"fetch_min","","Minimum with the current value.",93,{"inputs":[{"name":"self"},{"name":"u32"},{"name":"ordering"}],"output":{"name":"u32"}}],[11,"default","","",94,{"inputs":[],"output":{"name":"self"}}],[11,"from","","",94,{"inputs":[{"name":"i64"}],"output":{"name":"self"}}],[11,"fmt","","",94,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new atomic integer.",94,{"inputs":[{"name":"i64"}],"output":{"name":"self"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",94,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[11,"into_inner","","Consumes the atomic and returns the contained value.",94,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[11,"load","","Loads a value from the atomic integer.",94,{"inputs":[{"name":"self"},{"name":"ordering"}],"output":{"name":"i64"}}],[11,"store","","Stores a value into the atomic integer.",94,{"inputs":[{"name":"self"},{"name":"i64"},{"name":"ordering"}],"output":null}],[11,"swap","","Stores a value into the atomic integer, returning the previous value.",94,{"inputs":[{"name":"self"},{"name":"i64"},{"name":"ordering"}],"output":{"name":"i64"}}],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",94,{"inputs":[{"name":"self"},{"name":"i64"},{"name":"i64"},{"name":"ordering"}],"output":{"name":"i64"}}],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",94,{"inputs":[{"name":"self"},{"name":"i64"},{"name":"i64"},{"name":"ordering"},{"name":"ordering"}],"output":{"generics":["i64","i64"],"name":"result"}}],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",94,{"inputs":[{"name":"self"},{"name":"i64"},{"name":"i64"},{"name":"ordering"},{"name":"ordering"}],"output":{"generics":["i64","i64"],"name":"result"}}],[11,"fetch_add","","Adds to the current value, returning the previous value.",94,{"inputs":[{"name":"self"},{"name":"i64"},{"name":"ordering"}],"output":{"name":"i64"}}],[11,"fetch_sub","","Subtracts from the current value, returning the previous value.",94,{"inputs":[{"name":"self"},{"name":"i64"},{"name":"ordering"}],"output":{"name":"i64"}}],[11,"fetch_and","","Bitwise \"and\" with the current value.",94,{"inputs":[{"name":"self"},{"name":"i64"},{"name":"ordering"}],"output":{"name":"i64"}}],[11,"fetch_nand","","Bitwise \"nand\" with the current value.",94,{"inputs":[{"name":"self"},{"name":"i64"},{"name":"ordering"}],"output":{"name":"i64"}}],[11,"fetch_or","","Bitwise \"or\" with the current value.",94,{"inputs":[{"name":"self"},{"name":"i64"},{"name":"ordering"}],"output":{"name":"i64"}}],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",94,{"inputs":[{"name":"self"},{"name":"i64"},{"name":"ordering"}],"output":{"name":"i64"}}],[11,"fetch_update","","Fetches the value, and applies a function to it that returns an optional new value. Returns a `Result` of `Ok(previous_value)` if the function returned `Some(_)`, else `Err(previous_value)`.",94,{"inputs":[{"name":"self"},{"name":"f"},{"name":"ordering"},{"name":"ordering"}],"output":{"generics":["i64","i64"],"name":"result"}}],[11,"fetch_max","","Maximum with the current value.",94,{"inputs":[{"name":"self"},{"name":"i64"},{"name":"ordering"}],"output":{"name":"i64"}}],[11,"fetch_min","","Minimum with the current value.",94,{"inputs":[{"name":"self"},{"name":"i64"},{"name":"ordering"}],"output":{"name":"i64"}}],[11,"default","","",95,{"inputs":[],"output":{"name":"self"}}],[11,"from","","",95,{"inputs":[{"name":"u64"}],"output":{"name":"self"}}],[11,"fmt","","",95,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new atomic integer.",95,{"inputs":[{"name":"u64"}],"output":{"name":"self"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",95,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"into_inner","","Consumes the atomic and returns the contained value.",95,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"load","","Loads a value from the atomic integer.",95,{"inputs":[{"name":"self"},{"name":"ordering"}],"output":{"name":"u64"}}],[11,"store","","Stores a value into the atomic integer.",95,{"inputs":[{"name":"self"},{"name":"u64"},{"name":"ordering"}],"output":null}],[11,"swap","","Stores a value into the atomic integer, returning the previous value.",95,{"inputs":[{"name":"self"},{"name":"u64"},{"name":"ordering"}],"output":{"name":"u64"}}],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",95,{"inputs":[{"name":"self"},{"name":"u64"},{"name":"u64"},{"name":"ordering"}],"output":{"name":"u64"}}],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",95,{"inputs":[{"name":"self"},{"name":"u64"},{"name":"u64"},{"name":"ordering"},{"name":"ordering"}],"output":{"generics":["u64","u64"],"name":"result"}}],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",95,{"inputs":[{"name":"self"},{"name":"u64"},{"name":"u64"},{"name":"ordering"},{"name":"ordering"}],"output":{"generics":["u64","u64"],"name":"result"}}],[11,"fetch_add","","Adds to the current value, returning the previous value.",95,{"inputs":[{"name":"self"},{"name":"u64"},{"name":"ordering"}],"output":{"name":"u64"}}],[11,"fetch_sub","","Subtracts from the current value, returning the previous value.",95,{"inputs":[{"name":"self"},{"name":"u64"},{"name":"ordering"}],"output":{"name":"u64"}}],[11,"fetch_and","","Bitwise \"and\" with the current value.",95,{"inputs":[{"name":"self"},{"name":"u64"},{"name":"ordering"}],"output":{"name":"u64"}}],[11,"fetch_nand","","Bitwise \"nand\" with the current value.",95,{"inputs":[{"name":"self"},{"name":"u64"},{"name":"ordering"}],"output":{"name":"u64"}}],[11,"fetch_or","","Bitwise \"or\" with the current value.",95,{"inputs":[{"name":"self"},{"name":"u64"},{"name":"ordering"}],"output":{"name":"u64"}}],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",95,{"inputs":[{"name":"self"},{"name":"u64"},{"name":"ordering"}],"output":{"name":"u64"}}],[11,"fetch_update","","Fetches the value, and applies a function to it that returns an optional new value. Returns a `Result` of `Ok(previous_value)` if the function returned `Some(_)`, else `Err(previous_value)`.",95,{"inputs":[{"name":"self"},{"name":"f"},{"name":"ordering"},{"name":"ordering"}],"output":{"generics":["u64","u64"],"name":"result"}}],[11,"fetch_max","","Maximum with the current value.",95,{"inputs":[{"name":"self"},{"name":"u64"},{"name":"ordering"}],"output":{"name":"u64"}}],[11,"fetch_min","","Minimum with the current value.",95,{"inputs":[{"name":"self"},{"name":"u64"},{"name":"ordering"}],"output":{"name":"u64"}}],[11,"default","","",96,{"inputs":[],"output":{"name":"self"}}],[11,"from","","",96,{"inputs":[{"name":"isize"}],"output":{"name":"self"}}],[11,"fmt","","",96,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new atomic integer.",96,{"inputs":[{"name":"isize"}],"output":{"name":"self"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",96,{"inputs":[{"name":"self"}],"output":{"name":"isize"}}],[11,"into_inner","","Consumes the atomic and returns the contained value.",96,{"inputs":[{"name":"self"}],"output":{"name":"isize"}}],[11,"load","","Loads a value from the atomic integer.",96,{"inputs":[{"name":"self"},{"name":"ordering"}],"output":{"name":"isize"}}],[11,"store","","Stores a value into the atomic integer.",96,{"inputs":[{"name":"self"},{"name":"isize"},{"name":"ordering"}],"output":null}],[11,"swap","","Stores a value into the atomic integer, returning the previous value.",96,{"inputs":[{"name":"self"},{"name":"isize"},{"name":"ordering"}],"output":{"name":"isize"}}],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",96,{"inputs":[{"name":"self"},{"name":"isize"},{"name":"isize"},{"name":"ordering"}],"output":{"name":"isize"}}],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",96,{"inputs":[{"name":"self"},{"name":"isize"},{"name":"isize"},{"name":"ordering"},{"name":"ordering"}],"output":{"generics":["isize","isize"],"name":"result"}}],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",96,{"inputs":[{"name":"self"},{"name":"isize"},{"name":"isize"},{"name":"ordering"},{"name":"ordering"}],"output":{"generics":["isize","isize"],"name":"result"}}],[11,"fetch_add","","Adds to the current value, returning the previous value.",96,{"inputs":[{"name":"self"},{"name":"isize"},{"name":"ordering"}],"output":{"name":"isize"}}],[11,"fetch_sub","","Subtracts from the current value, returning the previous value.",96,{"inputs":[{"name":"self"},{"name":"isize"},{"name":"ordering"}],"output":{"name":"isize"}}],[11,"fetch_and","","Bitwise \"and\" with the current value.",96,{"inputs":[{"name":"self"},{"name":"isize"},{"name":"ordering"}],"output":{"name":"isize"}}],[11,"fetch_nand","","Bitwise \"nand\" with the current value.",96,{"inputs":[{"name":"self"},{"name":"isize"},{"name":"ordering"}],"output":{"name":"isize"}}],[11,"fetch_or","","Bitwise \"or\" with the current value.",96,{"inputs":[{"name":"self"},{"name":"isize"},{"name":"ordering"}],"output":{"name":"isize"}}],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",96,{"inputs":[{"name":"self"},{"name":"isize"},{"name":"ordering"}],"output":{"name":"isize"}}],[11,"fetch_update","","Fetches the value, and applies a function to it that returns an optional new value. Returns a `Result` of `Ok(previous_value)` if the function returned `Some(_)`, else `Err(previous_value)`.",96,{"inputs":[{"name":"self"},{"name":"f"},{"name":"ordering"},{"name":"ordering"}],"output":{"generics":["isize","isize"],"name":"result"}}],[11,"fetch_max","","Maximum with the current value.",96,{"inputs":[{"name":"self"},{"name":"isize"},{"name":"ordering"}],"output":{"name":"isize"}}],[11,"fetch_min","","Minimum with the current value.",96,{"inputs":[{"name":"self"},{"name":"isize"},{"name":"ordering"}],"output":{"name":"isize"}}],[11,"default","","",97,{"inputs":[],"output":{"name":"self"}}],[11,"from","","",97,{"inputs":[{"name":"usize"}],"output":{"name":"self"}}],[11,"fmt","","",97,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new atomic integer.",97,{"inputs":[{"name":"usize"}],"output":{"name":"self"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",97,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"into_inner","","Consumes the atomic and returns the contained value.",97,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"load","","Loads a value from the atomic integer.",97,{"inputs":[{"name":"self"},{"name":"ordering"}],"output":{"name":"usize"}}],[11,"store","","Stores a value into the atomic integer.",97,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"ordering"}],"output":null}],[11,"swap","","Stores a value into the atomic integer, returning the previous value.",97,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"ordering"}],"output":{"name":"usize"}}],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",97,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"usize"},{"name":"ordering"}],"output":{"name":"usize"}}],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",97,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"usize"},{"name":"ordering"},{"name":"ordering"}],"output":{"generics":["usize","usize"],"name":"result"}}],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",97,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"usize"},{"name":"ordering"},{"name":"ordering"}],"output":{"generics":["usize","usize"],"name":"result"}}],[11,"fetch_add","","Adds to the current value, returning the previous value.",97,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"ordering"}],"output":{"name":"usize"}}],[11,"fetch_sub","","Subtracts from the current value, returning the previous value.",97,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"ordering"}],"output":{"name":"usize"}}],[11,"fetch_and","","Bitwise \"and\" with the current value.",97,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"ordering"}],"output":{"name":"usize"}}],[11,"fetch_nand","","Bitwise \"nand\" with the current value.",97,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"ordering"}],"output":{"name":"usize"}}],[11,"fetch_or","","Bitwise \"or\" with the current value.",97,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"ordering"}],"output":{"name":"usize"}}],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",97,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"ordering"}],"output":{"name":"usize"}}],[11,"fetch_update","","Fetches the value, and applies a function to it that returns an optional new value. Returns a `Result` of `Ok(previous_value)` if the function returned `Some(_)`, else `Err(previous_value)`.",97,{"inputs":[{"name":"self"},{"name":"f"},{"name":"ordering"},{"name":"ordering"}],"output":{"generics":["usize","usize"],"name":"result"}}],[11,"fetch_max","","Maximum with the current value.",97,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"ordering"}],"output":{"name":"usize"}}],[11,"fetch_min","","Minimum with the current value.",97,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"ordering"}],"output":{"name":"usize"}}],[11,"fmt","","",86,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",87,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",87,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[0,"cell","core","Shareable mutable containers.",null,null],[3,"Cell","core::cell","A mutable memory location.",null,null],[3,"RefCell","","A mutable memory location with dynamically checked borrow rules",null,null],[3,"BorrowError","","An error returned by `RefCell::try_borrow`.",null,null],[3,"BorrowMutError","","An error returned by `RefCell::try_borrow_mut`.",null,null],[3,"Ref","","Wraps a borrowed reference to a value in a `RefCell` box. A wrapper type for an immutably borrowed value from a `RefCell<T>`.",null,null],[3,"RefMut","","A wrapper type for a mutably borrowed value from a `RefCell<T>`.",null,null],[3,"UnsafeCell","","The core primitive for interior mutability in Rust.",null,null],[11,"get","","Returns a copy of the contained value.",98,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"update","","Updates the contained value using a function and returns the new value.",98,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"t"}}],[11,"clone","","",98,{"inputs":[{"name":"self"}],"output":{"name":"cell"}}],[11,"default","","Creates a `Cell<T>`, with the `Default` value for T.",98,{"inputs":[],"output":{"name":"cell"}}],[11,"eq","","",98,{"inputs":[{"name":"self"},{"name":"cell"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",98,{"inputs":[{"name":"self"},{"name":"cell"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",98,{"inputs":[{"name":"self"},{"name":"cell"}],"output":{"name":"bool"}}],[11,"le","","",98,{"inputs":[{"name":"self"},{"name":"cell"}],"output":{"name":"bool"}}],[11,"gt","","",98,{"inputs":[{"name":"self"},{"name":"cell"}],"output":{"name":"bool"}}],[11,"ge","","",98,{"inputs":[{"name":"self"},{"name":"cell"}],"output":{"name":"bool"}}],[11,"cmp","","",98,{"inputs":[{"name":"self"},{"name":"cell"}],"output":{"name":"ordering"}}],[11,"from","","",98,{"inputs":[{"name":"t"}],"output":{"name":"cell"}}],[11,"new","","Creates a new `Cell` containing the given value.",98,{"inputs":[{"name":"t"}],"output":{"name":"cell"}}],[11,"as_ptr","","Returns a raw pointer to the underlying data in this cell.",98,null],[11,"get_mut","","Returns a mutable reference to the underlying data.",98,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"set","","Sets the contained value.",98,{"inputs":[{"name":"self"},{"name":"t"}],"output":null}],[11,"swap","","Swaps the values of two Cells. Difference with `std::mem::swap` is that this function doesn't require `&mut` reference.",98,{"inputs":[{"name":"self"},{"name":"self"}],"output":null}],[11,"replace","","Replaces the contained value, and returns it.",98,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"t"}}],[11,"into_inner","","Unwraps the value.",98,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"take","","Takes the value of the cell, leaving `Default::default()` in its place.",98,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"fmt","","",99,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",99,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",100,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",100,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new `RefCell` containing `value`.",101,{"inputs":[{"name":"t"}],"output":{"name":"refcell"}}],[11,"into_inner","","Consumes the `RefCell`, returning the wrapped value.",101,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"replace","","Replaces the wrapped value with a new one, returning the old value, without deinitializing either one.",101,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"t"}}],[11,"replace_with","","Replaces the wrapped value with a new one computed from `f`, returning the old value, without deinitializing either one.",101,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"t"}}],[11,"swap","","Swaps the wrapped value of `self` with the wrapped value of `other`, without deinitializing either one.",101,{"inputs":[{"name":"self"},{"name":"self"}],"output":null}],[11,"borrow","","Immutably borrows the wrapped value.",101,{"inputs":[{"name":"self"}],"output":{"name":"ref"}}],[11,"try_borrow","","Immutably borrows the wrapped value, returning an error if the value is currently mutably borrowed.",101,{"inputs":[{"name":"self"}],"output":{"generics":["ref","borrowerror"],"name":"result"}}],[11,"borrow_mut","","Mutably borrows the wrapped value.",101,{"inputs":[{"name":"self"}],"output":{"name":"refmut"}}],[11,"try_borrow_mut","","Mutably borrows the wrapped value, returning an error if the value is currently borrowed.",101,{"inputs":[{"name":"self"}],"output":{"generics":["refmut","borrowmuterror"],"name":"result"}}],[11,"as_ptr","","Returns a raw pointer to the underlying data in this cell.",101,null],[11,"get_mut","","Returns a mutable reference to the underlying data.",101,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"clone","","Panics",101,{"inputs":[{"name":"self"}],"output":{"name":"refcell"}}],[11,"default","","Creates a `RefCell<T>`, with the `Default` value for T.",101,{"inputs":[],"output":{"name":"refcell"}}],[11,"eq","","Panics",101,{"inputs":[{"name":"self"},{"name":"refcell"}],"output":{"name":"bool"}}],[11,"partial_cmp","","Panics",101,{"inputs":[{"name":"self"},{"name":"refcell"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","Panics",101,{"inputs":[{"name":"self"},{"name":"refcell"}],"output":{"name":"bool"}}],[11,"le","","Panics",101,{"inputs":[{"name":"self"},{"name":"refcell"}],"output":{"name":"bool"}}],[11,"gt","","Panics",101,{"inputs":[{"name":"self"},{"name":"refcell"}],"output":{"name":"bool"}}],[11,"ge","","Panics",101,{"inputs":[{"name":"self"},{"name":"refcell"}],"output":{"name":"bool"}}],[11,"cmp","","Panics",101,{"inputs":[{"name":"self"},{"name":"refcell"}],"output":{"name":"ordering"}}],[11,"from","","",101,{"inputs":[{"name":"t"}],"output":{"name":"refcell"}}],[11,"deref","","",102,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"clone","","Copies a `Ref`.",102,{"inputs":[{"name":"ref"}],"output":{"name":"ref"}}],[11,"map","","Make a new `Ref` for a component of the borrowed data.",102,{"inputs":[{"name":"ref"},{"name":"f"}],"output":{"name":"ref"}}],[11,"fmt","","",102,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"map","","Make a new `RefMut` for a component of the borrowed data, e.g. an enum variant.",103,{"inputs":[{"name":"refmut"},{"name":"f"}],"output":{"name":"refmut"}}],[11,"deref","","",103,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"deref_mut","","",103,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"fmt","","",103,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Constructs a new instance of `UnsafeCell` which will wrap the specified value.",104,{"inputs":[{"name":"t"}],"output":{"name":"unsafecell"}}],[11,"into_inner","","Unwraps the value.",104,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"get","","Gets a mutable pointer to the wrapped value.",104,null],[11,"default","","Creates an `UnsafeCell`, with the `Default` value for T.",104,{"inputs":[],"output":{"name":"unsafecell"}}],[11,"from","","",104,{"inputs":[{"name":"t"}],"output":{"name":"unsafecell"}}],[0,"char","core","A character type.",null,null],[3,"ParseCharError","core::char","An error which can be returned when parsing a char.",null,null],[3,"CharTryFromError","","The error type returned when a conversion from u32 to char fails.",null,null],[3,"DecodeUtf16","","An iterator that decodes UTF-16 encoded code points from an iterator of `u16`s.",null,null],[3,"DecodeUtf16Error","","An error that can be returned when decoding UTF-16 code points.",null,null],[3,"UnicodeVersion","","Represents a Unicode Version.",null,null],[12,"major","","Major version.",105,null],[12,"minor","","Minor version.",105,null],[12,"micro","","Micro (or Update) version.",105,null],[3,"DecodeUtf8","","An iterator over an iterator of bytes of the characters the bytes represent as UTF-8",null,null],[3,"InvalidSequence","","`<DecodeUtf8 as Iterator>::next` returns this for an invalid input sequence.",null,null],[3,"EscapeUnicode","","Returns an iterator that yields the hexadecimal Unicode escape of a character, as `char`s.",null,null],[3,"EscapeDefault","","An iterator that yields the literal escape code of a `char`.",null,null],[3,"EscapeDebug","","An iterator that yields the literal escape code of a `char`.",null,null],[3,"ToLowercase","","Returns an iterator that yields the lowercase equivalent of a `char`.",null,null],[3,"ToUppercase","","Returns an iterator that yields the uppercase equivalent of a `char`.",null,null],[5,"from_u32","","Converts a `u32` to a `char`.",null,{"inputs":[{"name":"u32"}],"output":{"generics":["char"],"name":"option"}}],[5,"from_digit","","Converts a digit in the given radix to a `char`.",null,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"generics":["char"],"name":"option"}}],[5,"from_u32_unchecked","","Converts a `u32` to a `char`, ignoring validity.",null,{"inputs":[{"name":"u32"}],"output":{"name":"char"}}],[5,"decode_utf16","","Create an iterator over the UTF-16 encoded code points in `iter`, returning unpaired surrogates as `Err`s.",null,{"inputs":[{"name":"i"}],"output":{"name":"decodeutf16"}}],[5,"decode_utf8","","Decodes an `Iterator` of bytes as UTF-8.",null,{"inputs":[{"name":"i"}],"output":{"name":"decodeutf8"}}],[11,"clone","","",106,{"inputs":[{"name":"self"}],"output":{"name":"parsecharerror"}}],[11,"fmt","","",106,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",106,{"inputs":[{"name":"self"},{"name":"parsecharerror"}],"output":{"name":"bool"}}],[11,"ne","","",106,{"inputs":[{"name":"self"},{"name":"parsecharerror"}],"output":{"name":"bool"}}],[11,"fmt","","",106,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",107,{"inputs":[{"name":"self"}],"output":{"name":"chartryfromerror"}}],[11,"fmt","","",107,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",107,{"inputs":[{"name":"self"},{"name":"chartryfromerror"}],"output":{"name":"bool"}}],[11,"ne","","",107,{"inputs":[{"name":"self"},{"name":"chartryfromerror"}],"output":{"name":"bool"}}],[11,"fmt","","",107,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",108,{"inputs":[{"name":"self"}],"output":{"name":"decodeutf8"}}],[11,"fmt","","",108,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",109,{"inputs":[{"name":"self"},{"name":"invalidsequence"}],"output":{"name":"bool"}}],[11,"ne","","",109,{"inputs":[{"name":"self"},{"name":"invalidsequence"}],"output":{"name":"bool"}}],[11,"fmt","","",109,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",108,{"inputs":[{"name":"self"}],"output":{"generics":["result"],"name":"option"}}],[11,"size_hint","","",108,null],[11,"clone","","",110,{"inputs":[{"name":"self"}],"output":{"name":"decodeutf16"}}],[11,"fmt","","",110,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",111,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",111,{"inputs":[{"name":"self"}],"output":{"name":"decodeutf16error"}}],[11,"eq","","",111,{"inputs":[{"name":"self"},{"name":"decodeutf16error"}],"output":{"name":"bool"}}],[11,"ne","","",111,{"inputs":[{"name":"self"},{"name":"decodeutf16error"}],"output":{"name":"bool"}}],[11,"next","","",110,{"inputs":[{"name":"self"}],"output":{"generics":["result"],"name":"option"}}],[11,"size_hint","","",110,null],[11,"unpaired_surrogate","","Returns the unpaired surrogate which caused this error.",111,{"inputs":[{"name":"self"}],"output":{"name":"u16"}}],[11,"fmt","","",111,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[17,"UNICODE_VERSION","","The version of Unicode that the Unicode parts of `char` and `str` methods are based on.",null,null],[17,"MAX","","The highest valid code point a `char` can have.",null,null],[17,"REPLACEMENT_CHARACTER","","`U+FFFD REPLACEMENT CHARACTER` (�) is used in Unicode to represent a decoding error.",null,null],[11,"clone","","",112,{"inputs":[{"name":"self"}],"output":{"name":"escapeunicode"}}],[11,"fmt","","",112,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",112,{"inputs":[{"name":"self"}],"output":{"generics":["char"],"name":"option"}}],[11,"size_hint","","",112,null],[11,"count","","",112,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"last","","",112,{"inputs":[{"name":"self"}],"output":{"generics":["char"],"name":"option"}}],[11,"len","","",112,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"fmt","","",112,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",113,{"inputs":[{"name":"self"}],"output":{"name":"escapedefault"}}],[11,"fmt","","",113,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",113,{"inputs":[{"name":"self"}],"output":{"generics":["char"],"name":"option"}}],[11,"size_hint","","",113,null],[11,"count","","",113,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"nth","","",113,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"generics":["char"],"name":"option"}}],[11,"last","","",113,{"inputs":[{"name":"self"}],"output":{"generics":["char"],"name":"option"}}],[11,"len","","",113,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"fmt","","",113,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",114,{"inputs":[{"name":"self"}],"output":{"name":"escapedebug"}}],[11,"fmt","","",114,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",114,{"inputs":[{"name":"self"}],"output":{"generics":["char"],"name":"option"}}],[11,"size_hint","","",114,null],[11,"fmt","","",114,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",115,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",115,{"inputs":[{"name":"self"}],"output":{"name":"tolowercase"}}],[11,"next","","",115,{"inputs":[{"name":"self"}],"output":{"generics":["char"],"name":"option"}}],[11,"fmt","","",116,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",116,{"inputs":[{"name":"self"}],"output":{"name":"touppercase"}}],[11,"next","","",116,{"inputs":[{"name":"self"}],"output":{"generics":["char"],"name":"option"}}],[11,"fmt","","",115,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",116,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[0,"panic","core","Panic support in the standard library.",null,null],[3,"PanicInfo","core::panic","A struct providing information about a panic.",null,null],[3,"Location","","A struct containing information about the location of a panic.",null,null],[11,"fmt","","",117,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"payload","","Returns the payload associated with the panic.",117,{"inputs":[{"name":"self"}],"output":{"name":"any"}}],[11,"message","","If the `panic!` macro from the `core` crate (not from `std`) was used with a formatting string and some additional arguments, returns that message ready to be used for example with [`fmt::write`]",117,{"inputs":[{"name":"self"}],"output":{"generics":["arguments"],"name":"option"}}],[11,"location","","Returns information about the location from which the panic originated, if available.",117,{"inputs":[{"name":"self"}],"output":{"generics":["location"],"name":"option"}}],[11,"fmt","","",117,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",118,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"file","","Returns the name of the source file from which the panic originated.",118,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"line","","Returns the line number from which the panic originated.",118,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"column","","Returns the column from which the panic originated.",118,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"fmt","","",118,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[0,"panicking","core","Panic support for libcore",null,null],[5,"panic","core::panicking","",null,null],[5,"panic_fmt","","",null,null],[0,"iter","core","Composable external iteration.",null,null],[3,"Repeat","core::iter","An iterator that repeats an element endlessly.",null,null],[3,"RepeatWith","","An iterator that repeats elements of type `A` endlessly by applying the provided closure `F: FnMut() -> A`.",null,null],[3,"Empty","","An iterator that yields nothing.",null,null],[3,"Once","","An iterator that yields an element exactly once.",null,null],[3,"Rev","","A double-ended iterator with the direction inverted.",null,null],[3,"Cloned","","An iterator that clones the elements of an underlying iterator.",null,null],[3,"Cycle","","An iterator that repeats endlessly.",null,null],[3,"StepBy","","An iterator for stepping iterators by a custom amount.",null,null],[3,"Chain","","An iterator that strings two iterators together.",null,null],[3,"Zip","","An iterator that iterates two other iterators simultaneously.",null,null],[3,"Map","","An iterator that maps the values of `iter` with `f`.",null,null],[3,"Filter","","An iterator that filters the elements of `iter` with `predicate`.",null,null],[3,"FilterMap","","An iterator that uses `f` to both filter and map elements from `iter`.",null,null],[3,"Enumerate","","An iterator that yields the current count and the element during iteration.",null,null],[3,"Peekable","","An iterator with a `peek()` that returns an optional reference to the next element.",null,null],[3,"SkipWhile","","An iterator that rejects elements while `predicate` is true.",null,null],[3,"TakeWhile","","An iterator that only accepts elements while `predicate` is true.",null,null],[3,"Skip","","An iterator that skips over `n` elements of `iter`.",null,null],[3,"Take","","An iterator that only iterates over the first `n` iterations of `iter`.",null,null],[3,"Scan","","An iterator to maintain state while iterating another iterator.",null,null],[3,"FlatMap","","An iterator that maps each element to an iterator, and yields the elements of the produced iterators.",null,null],[3,"Flatten","","An iterator that flattens one level of nesting in an iterator of things that can be turned into iterators.",null,null],[3,"Fuse","","An iterator that yields `None` forever after the underlying iterator yields `None` once.",null,null],[3,"Inspect","","An iterator that calls a function with a reference to each element before yielding it.",null,null],[5,"repeat","","Creates a new iterator that endlessly repeats a single element.",null,{"inputs":[{"name":"t"}],"output":{"name":"repeat"}}],[5,"repeat_with","","Creates a new iterator that repeats elements of type `A` endlessly by applying the provided closure, the repeater, `F: FnMut() -> A`.",null,{"inputs":[{"name":"f"}],"output":{"name":"repeatwith"}}],[5,"empty","","Creates an iterator that yields nothing.",null,{"inputs":[],"output":{"name":"empty"}}],[5,"once","","Creates an iterator that yields an element exactly once.",null,{"inputs":[{"name":"t"}],"output":{"name":"once"}}],[11,"next","core::ops","",24,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",24,null],[11,"nth","","",24,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",24,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"min","","",24,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"max","","",24,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",24,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",25,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",25,null],[11,"nth","","",25,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"next","","",31,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",31,null],[11,"nth","","",31,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",31,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"min","","",31,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"max","","",31,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"try_fold","","",31,{"inputs":[{"name":"self"},{"name":"b"},{"name":"f"}],"output":{"name":"r"}}],[11,"next_back","","",31,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"try_rfold","","",31,{"inputs":[{"name":"self"},{"name":"b"},{"name":"f"}],"output":{"name":"r"}}],[11,"clone","core::iter","",119,{"inputs":[{"name":"self"}],"output":{"name":"repeat"}}],[11,"fmt","","",119,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",119,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",119,null],[11,"next_back","","",119,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",120,{"inputs":[{"name":"self"}],"output":{"name":"repeatwith"}}],[11,"fmt","","",120,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",120,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",120,null],[11,"next_back","","",120,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",121,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",121,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",121,null],[11,"next_back","","",121,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"len","","",121,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"clone","","",121,{"inputs":[{"name":"self"}],"output":{"name":"empty"}}],[11,"default","","",121,{"inputs":[],"output":{"name":"empty"}}],[11,"clone","","",122,{"inputs":[{"name":"self"}],"output":{"name":"once"}}],[11,"fmt","","",122,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",122,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",122,null],[11,"next_back","","",122,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"len","","",122,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"sum","core::num","",0,{"inputs":[{"name":"i"}],"output":{"generics":["i8"],"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"generics":["i8"],"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"generics":["i8"],"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"generics":["i8"],"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"generics":["i16"],"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"generics":["i16"],"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"generics":["i16"],"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"generics":["i16"],"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"generics":["i32"],"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"generics":["i32"],"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"generics":["i32"],"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"generics":["i32"],"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"generics":["i64"],"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"generics":["i64"],"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"generics":["i64"],"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"generics":["i64"],"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"generics":["i128"],"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"generics":["i128"],"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"generics":["i128"],"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"generics":["i128"],"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"generics":["isize"],"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"generics":["isize"],"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"generics":["isize"],"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"generics":["isize"],"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"generics":["u8"],"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"generics":["u8"],"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"generics":["u8"],"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"generics":["u8"],"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"generics":["u16"],"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"generics":["u16"],"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"generics":["u16"],"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"generics":["u16"],"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"generics":["u32"],"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"generics":["u32"],"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"generics":["u32"],"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"generics":["u32"],"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"generics":["u64"],"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"generics":["u64"],"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"generics":["u64"],"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"generics":["u64"],"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"generics":["u128"],"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"generics":["u128"],"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"generics":["u128"],"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"generics":["u128"],"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"generics":["usize"],"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"generics":["usize"],"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"generics":["usize"],"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"generics":["usize"],"name":"wrapping"}}],[8,"Iterator","core::iter","An interface for dealing with iterators.",null,null],[16,"Item","","The type of the elements being iterated over.",123,null],[10,"next","","Advances the iterator and returns the next value.",123,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","Returns the bounds on the remaining length of the iterator.",123,null],[11,"count","","Consumes the iterator, counting the number of iterations and returning it.",123,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"last","","Consumes the iterator, returning the last element.",123,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"nth","","Returns the `n`th element of the iterator.",123,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"step_by","","Creates an iterator starting at the same point, but stepping by the given amount at each iteration.",123,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"stepby"}}],[11,"chain","","Takes two iterators and creates a new iterator over both in sequence.",123,{"inputs":[{"name":"self"},{"name":"u"}],"output":{"name":"chain"}}],[11,"zip","","'Zips up' two iterators into a single iterator of pairs.",123,{"inputs":[{"name":"self"},{"name":"u"}],"output":{"name":"zip"}}],[11,"map","","Takes a closure and creates an iterator which calls that closure on each element.",123,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"map"}}],[11,"for_each","","Calls a closure on each element of an iterator.",123,{"inputs":[{"name":"self"},{"name":"f"}],"output":null}],[11,"filter","","Creates an iterator which uses a closure to determine if an element should be yielded.",123,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"filter"}}],[11,"filter_map","","Creates an iterator that both filters and maps.",123,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"filtermap"}}],[11,"enumerate","","Creates an iterator which gives the current iteration count as well as the next value.",123,{"inputs":[{"name":"self"}],"output":{"name":"enumerate"}}],[11,"peekable","","Creates an iterator which can use `peek` to look at the next element of the iterator without consuming it.",123,{"inputs":[{"name":"self"}],"output":{"name":"peekable"}}],[11,"skip_while","","Creates an iterator that [`skip`]s elements based on a predicate.",123,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"skipwhile"}}],[11,"take_while","","Creates an iterator that yields elements based on a predicate.",123,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"takewhile"}}],[11,"skip","","Creates an iterator that skips the first `n` elements.",123,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"skip"}}],[11,"take","","Creates an iterator that yields its first `n` elements.",123,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"take"}}],[11,"scan","","An iterator adaptor similar to [`fold`] that holds internal state and produces a new iterator.",123,{"inputs":[{"name":"self"},{"name":"st"},{"name":"f"}],"output":{"name":"scan"}}],[11,"flat_map","","Creates an iterator that works like map, but flattens nested structure.",123,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"flatmap"}}],[11,"flatten","","Creates an iterator that flattens nested structure.",123,{"inputs":[{"name":"self"}],"output":{"name":"flatten"}}],[11,"fuse","","Creates an iterator which ends after the first [`None`].",123,{"inputs":[{"name":"self"}],"output":{"name":"fuse"}}],[11,"inspect","","Do something with each element of an iterator, passing the value on.",123,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"inspect"}}],[11,"by_ref","","Borrows an iterator, rather than consuming it.",123,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"collect","","Transforms an iterator into a collection.",123,{"inputs":[{"name":"self"}],"output":{"name":"b"}}],[11,"partition","","Consumes an iterator, creating two collections from it.",123,null],[11,"try_fold","","An iterator method that applies a function as long as it returns successfully, producing a single, final value.",123,{"inputs":[{"name":"self"},{"name":"b"},{"name":"f"}],"output":{"name":"r"}}],[11,"try_for_each","","An iterator method that applies a fallible function to each item in the iterator, stopping at the first error and returning that error.",123,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"r"}}],[11,"fold","","An iterator method that applies a function, producing a single, final value.",123,{"inputs":[{"name":"self"},{"name":"b"},{"name":"f"}],"output":{"name":"b"}}],[11,"all","","Tests if every element of the iterator matches a predicate.",123,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"any","","Tests if any element of the iterator matches a predicate.",123,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"find","","Searches for an element of an iterator that satisfies a predicate.",123,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"option"}}],[11,"find_map","","Applies function to the elements of iterator and returns the first non-none result.",123,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"position","","Searches for an element in an iterator, returning its index.",123,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"generics":["usize"],"name":"option"}}],[11,"rposition","","Searches for an element in an iterator from the right, returning its index.",123,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"generics":["usize"],"name":"option"}}],[11,"max","","Returns the maximum element of an iterator.",123,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"min","","Returns the minimum element of an iterator.",123,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"max_by_key","","Returns the element that gives the maximum value from the specified function.",123,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"max_by","","Returns the element that gives the maximum value with respect to the specified comparison function.",123,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"min_by_key","","Returns the element that gives the minimum value from the specified function.",123,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"min_by","","Returns the element that gives the minimum value with respect to the specified comparison function.",123,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"rev","","Reverses an iterator's direction.",123,{"inputs":[{"name":"self"}],"output":{"name":"rev"}}],[11,"unzip","","Converts an iterator of pairs into a pair of containers.",123,null],[11,"cloned","","Creates an iterator which [`clone`]s all of its elements.",123,{"inputs":[{"name":"self"}],"output":{"name":"cloned"}}],[11,"cycle","","Repeats an iterator endlessly.",123,{"inputs":[{"name":"self"}],"output":{"name":"cycle"}}],[11,"sum","","Sums the elements of an iterator.",123,{"inputs":[{"name":"self"}],"output":{"name":"s"}}],[11,"product","","Iterates over the entire iterator, multiplying all the elements",123,{"inputs":[{"name":"self"}],"output":{"name":"p"}}],[11,"cmp","","Lexicographically compares the elements of this `Iterator` with those of another.",123,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","Lexicographically compares the elements of this `Iterator` with those of another.",123,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"eq","","Determines if the elements of this `Iterator` are equal to those of another.",123,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"bool"}}],[11,"ne","","Determines if the elements of this `Iterator` are unequal to those of another.",123,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"bool"}}],[11,"lt","","Determines if the elements of this `Iterator` are lexicographically less than those of another.",123,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"bool"}}],[11,"le","","Determines if the elements of this `Iterator` are lexicographically less or equal to those of another.",123,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"bool"}}],[11,"gt","","Determines if the elements of this `Iterator` are lexicographically greater than those of another.",123,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"bool"}}],[11,"ge","","Determines if the elements of this `Iterator` are lexicographically greater than or equal to those of another.",123,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"bool"}}],[8,"Step","","Objects that can be stepped over in both directions.",null,null],[10,"steps_between","","Returns the number of steps between two step objects. The count is inclusive of `start` and exclusive of `end`.",124,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"generics":["usize"],"name":"option"}}],[10,"replace_one","","Replaces this step with `1`, returning itself",124,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[10,"replace_zero","","Replaces this step with `0`, returning itself",124,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[10,"add_one","","Adds one to this step, returning the result",124,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[10,"sub_one","","Subtracts one to this step, returning the result",124,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[10,"add_usize","","Add an usize, returning None on overflow",124,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[8,"FromIterator","","Conversion from an `Iterator`.",null,null],[10,"from_iter","","Creates a value from an iterator.",125,{"inputs":[{"name":"t"}],"output":{"name":"self"}}],[8,"IntoIterator","","Conversion into an `Iterator`.",null,null],[16,"Item","","The type of the elements being iterated over.",126,null],[16,"IntoIter","","Which kind of iterator are we turning this into?",126,null],[10,"into_iter","","Creates an iterator from a value.",126,null],[8,"DoubleEndedIterator","","An iterator able to yield elements from both ends.",null,null],[10,"next_back","","Removes and returns an element from the end of the iterator.",127,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"try_rfold","","This is the reverse version of [`try_fold()`]: it takes elements starting from the back of the iterator.",127,{"inputs":[{"name":"self"},{"name":"b"},{"name":"f"}],"output":{"name":"r"}}],[11,"rfold","","An iterator method that reduces the iterator's elements to a single, final value, starting from the back.",127,{"inputs":[{"name":"self"},{"name":"b"},{"name":"f"}],"output":{"name":"b"}}],[11,"rfind","","Searches for an element of an iterator from the back that satisfies a predicate.",127,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"option"}}],[8,"Extend","","Extend a collection with the contents of an iterator.",null,null],[10,"extend","","Extends a collection with the contents of an iterator.",128,{"inputs":[{"name":"self"},{"name":"t"}],"output":null}],[8,"ExactSizeIterator","","An iterator that knows its exact length.",null,null],[11,"len","","Returns the exact number of times the iterator will iterate.",129,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","Returns whether the iterator is empty.",129,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[8,"Sum","","Trait to represent types that can be created by summing up an iterator.",null,null],[10,"sum","","Method which takes an iterator and generates `Self` from the elements by \"summing up\" the items.",130,{"inputs":[{"name":"i"}],"output":{"name":"self"}}],[8,"Product","","Trait to represent types that can be created by multiplying elements of an iterator.",null,null],[10,"product","","Method which takes an iterator and generates `Self` from the elements by multiplying the items.",131,{"inputs":[{"name":"i"}],"output":{"name":"self"}}],[8,"FusedIterator","","An iterator that always continues to yield `None` when exhausted.",null,null],[8,"TrustedLen","","An iterator that reports an accurate length using size_hint.",null,null],[11,"clone","","",132,{"inputs":[{"name":"self"}],"output":{"name":"rev"}}],[11,"fmt","","",132,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",132,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",132,null],[11,"try_fold","","",132,{"inputs":[{"name":"self"},{"name":"b"},{"name":"f"}],"output":{"name":"r"}}],[11,"fold","","",132,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"f"}],"output":{"name":"acc"}}],[11,"find","","",132,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"option"}}],[11,"rposition","","",132,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"generics":["usize"],"name":"option"}}],[11,"next_back","","",132,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"try_rfold","","",132,{"inputs":[{"name":"self"},{"name":"b"},{"name":"f"}],"output":{"name":"r"}}],[11,"rfold","","",132,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"f"}],"output":{"name":"acc"}}],[11,"rfind","","",132,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"option"}}],[11,"len","","",132,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","",132,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",133,{"inputs":[{"name":"self"}],"output":{"name":"cloned"}}],[11,"fmt","","",133,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",133,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",133,null],[11,"try_fold","","",133,{"inputs":[{"name":"self"},{"name":"b"},{"name":"f"}],"output":{"name":"r"}}],[11,"fold","","",133,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"f"}],"output":{"name":"acc"}}],[11,"next_back","","",133,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"try_rfold","","",133,{"inputs":[{"name":"self"},{"name":"b"},{"name":"f"}],"output":{"name":"r"}}],[11,"rfold","","",133,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"f"}],"output":{"name":"acc"}}],[11,"len","","",133,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","",133,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",134,{"inputs":[{"name":"self"}],"output":{"name":"cycle"}}],[11,"fmt","","",134,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",134,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",134,null],[11,"clone","","",135,{"inputs":[{"name":"self"}],"output":{"name":"stepby"}}],[11,"fmt","","",135,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",135,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",135,null],[11,"nth","","",135,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"clone","","",136,{"inputs":[{"name":"self"}],"output":{"name":"chain"}}],[11,"fmt","","",136,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",136,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"count","","",136,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"try_fold","","",136,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"f"}],"output":{"name":"r"}}],[11,"fold","","",136,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"f"}],"output":{"name":"acc"}}],[11,"nth","","",136,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"find","","",136,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"option"}}],[11,"last","","",136,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",136,null],[11,"next_back","","",136,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"try_rfold","","",136,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"f"}],"output":{"name":"r"}}],[11,"rfold","","",136,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"f"}],"output":{"name":"acc"}}],[11,"clone","","",137,{"inputs":[{"name":"self"}],"output":{"name":"zip"}}],[11,"fmt","","",137,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",137,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",137,null],[11,"nth","","",137,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"next_back","","",137,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",138,{"inputs":[{"name":"self"}],"output":{"name":"map"}}],[11,"fmt","","",138,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",138,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",138,null],[11,"try_fold","","",138,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"g"}],"output":{"name":"r"}}],[11,"fold","","",138,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"g"}],"output":{"name":"acc"}}],[11,"next_back","","",138,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"try_rfold","","",138,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"g"}],"output":{"name":"r"}}],[11,"rfold","","",138,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"g"}],"output":{"name":"acc"}}],[11,"len","","",138,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","",138,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",139,{"inputs":[{"name":"self"}],"output":{"name":"filter"}}],[11,"fmt","","",139,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",139,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",139,null],[11,"count","","",139,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"try_fold","","",139,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"r"}}],[11,"fold","","",139,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"acc"}}],[11,"next_back","","",139,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"try_rfold","","",139,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"r"}}],[11,"rfold","","",139,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"acc"}}],[11,"clone","","",140,{"inputs":[{"name":"self"}],"output":{"name":"filtermap"}}],[11,"fmt","","",140,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",140,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",140,null],[11,"try_fold","","",140,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"r"}}],[11,"fold","","",140,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"acc"}}],[11,"next_back","","",140,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"try_rfold","","",140,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"r"}}],[11,"rfold","","",140,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"acc"}}],[11,"clone","","",141,{"inputs":[{"name":"self"}],"output":{"name":"enumerate"}}],[11,"fmt","","",141,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","Overflow Behavior",141,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",141,null],[11,"nth","","",141,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"count","","",141,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"try_fold","","",141,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"r"}}],[11,"fold","","",141,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"acc"}}],[11,"next_back","","",141,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"try_rfold","","",141,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"r"}}],[11,"rfold","","",141,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"acc"}}],[11,"len","","",141,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","",141,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",142,{"inputs":[{"name":"self"}],"output":{"name":"peekable"}}],[11,"fmt","","",142,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",142,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"count","","",142,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"nth","","",142,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",142,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",142,null],[11,"try_fold","","",142,{"inputs":[{"name":"self"},{"name":"b"},{"name":"f"}],"output":{"name":"r"}}],[11,"fold","","",142,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"acc"}}],[11,"peek","","Returns a reference to the next() value without advancing the iterator.",142,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",143,{"inputs":[{"name":"self"}],"output":{"name":"skipwhile"}}],[11,"fmt","","",143,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",143,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",143,null],[11,"try_fold","","",143,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"r"}}],[11,"fold","","",143,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"acc"}}],[11,"clone","","",144,{"inputs":[{"name":"self"}],"output":{"name":"takewhile"}}],[11,"fmt","","",144,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",144,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",144,null],[11,"try_fold","","",144,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"r"}}],[11,"clone","","",145,{"inputs":[{"name":"self"}],"output":{"name":"skip"}}],[11,"fmt","","",145,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",145,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"nth","","",145,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"count","","",145,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"last","","",145,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",145,null],[11,"try_fold","","",145,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"r"}}],[11,"fold","","",145,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"acc"}}],[11,"next_back","","",145,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"try_rfold","","",145,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"r"}}],[11,"clone","","",146,{"inputs":[{"name":"self"}],"output":{"name":"take"}}],[11,"fmt","","",146,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",146,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"nth","","",146,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"size_hint","","",146,null],[11,"try_fold","","",146,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"r"}}],[11,"clone","","",147,{"inputs":[{"name":"self"}],"output":{"name":"scan"}}],[11,"fmt","","",147,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",147,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",147,null],[11,"try_fold","","",147,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"r"}}],[11,"clone","","",148,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"fmt","","",148,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",148,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",148,null],[11,"try_fold","","",148,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"r"}}],[11,"fold","","",148,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"acc"}}],[11,"next_back","","",148,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"try_rfold","","",148,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"r"}}],[11,"rfold","","",148,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"acc"}}],[11,"fmt","","",149,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",149,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"next","","",149,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",149,null],[11,"try_fold","","",149,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"r"}}],[11,"fold","","",149,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"acc"}}],[11,"next_back","","",149,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"try_rfold","","",149,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"r"}}],[11,"rfold","","",149,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"acc"}}],[11,"clone","","",150,{"inputs":[{"name":"self"}],"output":{"name":"fuse"}}],[11,"fmt","","",150,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",150,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"nth","","",150,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",150,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"count","","",150,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"size_hint","","",150,null],[11,"try_fold","","",150,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"r"}}],[11,"fold","","",150,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"acc"}}],[11,"next_back","","",150,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"try_rfold","","",150,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"r"}}],[11,"rfold","","",150,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"acc"}}],[11,"next","","",150,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"nth","","",150,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",150,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"count","","",150,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"size_hint","","",150,null],[11,"try_fold","","",150,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"r"}}],[11,"fold","","",150,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"acc"}}],[11,"next_back","","",150,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"try_rfold","","",150,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"r"}}],[11,"rfold","","",150,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"acc"}}],[11,"len","","",150,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","",150,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",151,{"inputs":[{"name":"self"}],"output":{"name":"inspect"}}],[11,"fmt","","",151,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",151,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",151,null],[11,"try_fold","","",151,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"r"}}],[11,"fold","","",151,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"acc"}}],[11,"next_back","","",151,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"try_rfold","","",151,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"r"}}],[11,"rfold","","",151,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"acc"}}],[11,"len","","",151,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","",151,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[0,"option","core","Optional values.",null,null],[3,"Iter","core::option","An iterator over a reference to the [`Some`] variant of an [`Option`].",null,null],[3,"IterMut","","An iterator over a mutable reference to the [`Some`] variant of an [`Option`].",null,null],[3,"IntoIter","","An iterator over the value in [`Some`] variant of an [`Option`].",null,null],[3,"NoneError","","The error type that results from applying the try operator (`?`) to a `None` value. If you wish to allow `x?` (where `x` is an `Option<T>`) to be converted into your error type, you can implement `impl From<NoneError>` for `YourErrorType`. In that case, `x?` within a function that returns `Result<_, YourErrorType>` will translate a `None` value into an `Err` result.",null,null],[4,"Option","","The `Option` type. See the module level documentation for more.",null,null],[13,"None","","No value",152,null],[13,"Some","","Some value `T`",152,null],[11,"clone","","",152,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"eq","","",152,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"name":"bool"}}],[11,"ne","","",152,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",152,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",152,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"name":"bool"}}],[11,"le","","",152,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"name":"bool"}}],[11,"gt","","",152,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"name":"bool"}}],[11,"ge","","",152,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"name":"bool"}}],[11,"cmp","","",152,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"name":"ordering"}}],[11,"fmt","","",152,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",152,null],[11,"is_some","","Returns `true` if the option is a [`Some`] value.",152,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_none","","Returns `true` if the option is a [`None`] value.",152,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"as_ref","","Converts from `Option<T>` to `Option<&T>`.",152,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"as_mut","","Converts from `Option<T>` to `Option<&mut T>`.",152,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"expect","","Unwraps an option, yielding the content of a [`Some`].",152,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"t"}}],[11,"unwrap","","Moves the value `v` out of the `Option<T>` if it is [`Some(v)`].",152,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"unwrap_or","","Returns the contained value or a default.",152,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"t"}}],[11,"unwrap_or_else","","Returns the contained value or computes it from a closure.",152,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"t"}}],[11,"map","","Maps an `Option<T>` to `Option<U>` by applying a function to a contained value.",152,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"map_or","","Applies a function to the contained value (if any), or returns the provided default (if not).",152,{"inputs":[{"name":"self"},{"name":"u"},{"name":"f"}],"output":{"name":"u"}}],[11,"map_or_else","","Applies a function to the contained value (if any), or computes a default (if not).",152,{"inputs":[{"name":"self"},{"name":"d"},{"name":"f"}],"output":{"name":"u"}}],[11,"ok_or","","Transforms the `Option<T>` into a [`Result<T, E>`], mapping [`Some(v)`] to [`Ok(v)`] and [`None`] to [`Err(err)`].",152,{"inputs":[{"name":"self"},{"name":"e"}],"output":{"name":"result"}}],[11,"ok_or_else","","Transforms the `Option<T>` into a [`Result<T, E>`], mapping [`Some(v)`] to [`Ok(v)`] and [`None`] to [`Err(err())`].",152,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"result"}}],[11,"iter","","Returns an iterator over the possibly contained value.",152,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"iter_mut","","Returns a mutable iterator over the possibly contained value.",152,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"and","","Returns [`None`] if the option is [`None`], otherwise returns `optb`.",152,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"name":"option"}}],[11,"and_then","","Returns [`None`] if the option is [`None`], otherwise calls `f` with the wrapped value and returns the result.",152,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"filter","","Returns `None` if the option is `None`, otherwise calls `predicate` with the wrapped value and returns:",152,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"self"}}],[11,"or","","Returns the option if it contains a value, otherwise returns `optb`.",152,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"name":"option"}}],[11,"or_else","","Returns the option if it contains a value, otherwise calls `f` and returns the result.",152,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"get_or_insert","","Inserts `v` into the option if it is [`None`], then returns a mutable reference to the contained value.",152,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"t"}}],[11,"get_or_insert_with","","Inserts a value computed from `f` into the option if it is [`None`], then returns a mutable reference to the contained value.",152,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"t"}}],[11,"take","","Takes the value out of the option, leaving a [`None`] in its place.",152,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"cloned","","Maps an `Option<&T>` to an `Option<T>` by cloning the contents of the option.",152,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"cloned","","Maps an `Option<&mut T>` to an `Option<T>` by cloning the contents of the option.",152,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"unwrap_or_default","","Returns the contained value or a default",152,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"transpose","","Transposes an `Option` of a `Result` into a `Result` of an `Option`.",152,{"inputs":[{"name":"self"}],"output":{"generics":["option"],"name":"result"}}],[11,"default","","Returns [`None`].",152,{"inputs":[],"output":{"name":"option"}}],[11,"into_iter","","Returns a consuming iterator over the possibly contained value.",152,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"from","","",152,{"inputs":[{"name":"t"}],"output":{"name":"option"}}],[11,"fmt","","",153,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",153,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",153,null],[11,"next_back","","",153,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",153,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"fmt","","",154,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",154,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",154,null],[11,"next_back","","",154,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",155,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"fmt","","",155,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",155,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",155,null],[11,"next_back","","",155,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"from_iter","","Takes each element in the [`Iterator`]: if it is [`None`], no further elements are taken, and the [`None`] is returned. Should no [`None`] occur, a container with the values of each `Option` is returned.",152,{"inputs":[{"name":"i"}],"output":{"name":"option"}}],[11,"clone","","",156,{"inputs":[{"name":"self"}],"output":{"name":"noneerror"}}],[11,"eq","","",156,{"inputs":[{"name":"self"},{"name":"noneerror"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",156,{"inputs":[{"name":"self"},{"name":"noneerror"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"cmp","","",156,{"inputs":[{"name":"self"},{"name":"noneerror"}],"output":{"name":"ordering"}}],[11,"fmt","","",156,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",156,null],[11,"into_result","","",152,{"inputs":[{"name":"self"}],"output":{"generics":["noneerror"],"name":"result"}}],[11,"from_ok","","",152,{"inputs":[{"name":"t"}],"output":{"name":"self"}}],[11,"from_error","","",152,{"inputs":[{"name":"noneerror"}],"output":{"name":"self"}}],[0,"raw","core","Contains struct definitions for the layout of compiler built-in types.",null,null],[3,"TraitObject","core::raw","The representation of a trait object like `&SomeTrait`.",null,null],[12,"data","","",157,null],[12,"vtable","","",157,null],[11,"clone","","",157,{"inputs":[{"name":"self"}],"output":{"name":"traitobject"}}],[0,"result","core","Error handling with the `Result` type.",null,null],[3,"Iter","core::result","An iterator over a reference to the [`Ok`] variant of a [`Result`].",null,null],[3,"IterMut","","An iterator over a mutable reference to the [`Ok`] variant of a [`Result`].",null,null],[3,"IntoIter","","An iterator over the value in a [`Ok`] variant of a [`Result`].",null,null],[4,"Result","","`Result` is a type that represents either success ([`Ok`]) or failure ([`Err`]).",null,null],[13,"Ok","","Contains the success value",158,null],[13,"Err","","Contains the error value",158,null],[11,"clone","","",158,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"eq","","",158,{"inputs":[{"name":"self"},{"name":"result"}],"output":{"name":"bool"}}],[11,"ne","","",158,{"inputs":[{"name":"self"},{"name":"result"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",158,{"inputs":[{"name":"self"},{"name":"result"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",158,{"inputs":[{"name":"self"},{"name":"result"}],"output":{"name":"bool"}}],[11,"le","","",158,{"inputs":[{"name":"self"},{"name":"result"}],"output":{"name":"bool"}}],[11,"gt","","",158,{"inputs":[{"name":"self"},{"name":"result"}],"output":{"name":"bool"}}],[11,"ge","","",158,{"inputs":[{"name":"self"},{"name":"result"}],"output":{"name":"bool"}}],[11,"cmp","","",158,{"inputs":[{"name":"self"},{"name":"result"}],"output":{"name":"ordering"}}],[11,"fmt","","",158,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",158,null],[11,"is_ok","","Returns `true` if the result is [`Ok`].",158,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_err","","Returns `true` if the result is [`Err`].",158,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"ok","","Converts from `Result<T, E>` to [`Option<T>`].",158,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"err","","Converts from `Result<T, E>` to [`Option<E>`].",158,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"as_ref","","Converts from `Result<T, E>` to `Result<&T, &E>`.",158,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"as_mut","","Converts from `Result<T, E>` to `Result<&mut T, &mut E>`.",158,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"map","","Maps a `Result<T, E>` to `Result<U, E>` by applying a function to a contained [`Ok`] value, leaving an [`Err`] value untouched.",158,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"result"}}],[11,"map_err","","Maps a `Result<T, E>` to `Result<T, F>` by applying a function to a contained [`Err`] value, leaving an [`Ok`] value untouched.",158,{"inputs":[{"name":"self"},{"name":"o"}],"output":{"name":"result"}}],[11,"iter","","Returns an iterator over the possibly contained value.",158,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"iter_mut","","Returns a mutable iterator over the possibly contained value.",158,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"and","","Returns `res` if the result is [`Ok`], otherwise returns the [`Err`] value of `self`.",158,{"inputs":[{"name":"self"},{"name":"result"}],"output":{"name":"result"}}],[11,"and_then","","Calls `op` if the result is [`Ok`], otherwise returns the [`Err`] value of `self`.",158,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"result"}}],[11,"or","","Returns `res` if the result is [`Err`], otherwise returns the [`Ok`] value of `self`.",158,{"inputs":[{"name":"self"},{"name":"result"}],"output":{"name":"result"}}],[11,"or_else","","Calls `op` if the result is [`Err`], otherwise returns the [`Ok`] value of `self`.",158,{"inputs":[{"name":"self"},{"name":"o"}],"output":{"name":"result"}}],[11,"unwrap_or","","Unwraps a result, yielding the content of an [`Ok`]. Else, it returns `optb`.",158,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"t"}}],[11,"unwrap_or_else","","Unwraps a result, yielding the content of an [`Ok`]. If the value is an [`Err`] then it calls `op` with its value.",158,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"t"}}],[11,"unwrap","","Unwraps a result, yielding the content of an [`Ok`].",158,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"expect","","Unwraps a result, yielding the content of an [`Ok`].",158,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"t"}}],[11,"unwrap_err","","Unwraps a result, yielding the content of an [`Err`].",158,{"inputs":[{"name":"self"}],"output":{"name":"e"}}],[11,"expect_err","","Unwraps a result, yielding the content of an [`Err`].",158,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"e"}}],[11,"unwrap_or_default","","Returns the contained value or a default",158,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"transpose","","Transposes a `Result` of an `Option` into an `Option` of a `Result`.",158,{"inputs":[{"name":"self"}],"output":{"generics":["result"],"name":"option"}}],[11,"into_iter","","Returns a consuming iterator over the possibly contained value.",158,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"fmt","","",159,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",159,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",159,null],[11,"next_back","","",159,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",159,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"fmt","","",160,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",160,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",160,null],[11,"next_back","","",160,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",161,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"fmt","","",161,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",161,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",161,null],[11,"next_back","","",161,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"from_iter","","Takes each element in the `Iterator`: if it is an `Err`, no further elements are taken, and the `Err` is returned. Should no `Err` occur, a container with the values of each `Result` is returned.",158,{"inputs":[{"name":"i"}],"output":{"name":"result"}}],[11,"into_result","","",158,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"from_ok","","",158,{"inputs":[{"name":"t"}],"output":{"name":"self"}}],[11,"from_error","","",158,{"inputs":[{"name":"e"}],"output":{"name":"self"}}],[0,"slice","core","Slice management and manipulation",null,null],[3,"Iter","core::slice","Immutable slice iterator",null,null],[3,"IterMut","","Mutable slice iterator.",null,null],[3,"Split","","An iterator over subslices separated by elements that match a predicate function.",null,null],[3,"SplitMut","","An iterator over the subslices of the vector which are separated by elements that match `pred`.",null,null],[3,"RSplit","","An iterator over subslices separated by elements that match a predicate function, starting from the end of the slice.",null,null],[3,"RSplitMut","","An iterator over the subslices of the vector which are separated by elements that match `pred`, starting from the end of the slice.",null,null],[3,"SplitN","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits.",null,null],[3,"RSplitN","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits, starting from the end of the slice.",null,null],[3,"SplitNMut","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits.",null,null],[3,"RSplitNMut","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits, starting from the end of the slice.",null,null],[3,"Windows","","An iterator over overlapping subslices of length `size`.",null,null],[3,"Chunks","","An iterator over a slice in (non-overlapping) chunks (`chunk_size` elements at a time).",null,null],[3,"ChunksMut","","An iterator over a slice in (non-overlapping) mutable chunks (`chunk_size` elements at a time). When the slice len is not evenly divided by the chunk size, the last slice of the iteration will be the remainder.",null,null],[3,"ExactChunks","","An iterator over a slice in (non-overlapping) chunks (`chunk_size` elements at a time).",null,null],[3,"ExactChunksMut","","An iterator over a slice in (non-overlapping) mutable chunks (`chunk_size` elements at a time). When the slice len is not evenly divided by the chunk size, the last up to `chunk_size-1` elements will be omitted.",null,null],[5,"from_raw_parts","","Forms a slice from a pointer and a length.",null,null],[5,"from_raw_parts_mut","","Performs the same functionality as `from_raw_parts`, except that a mutable slice is returned.",null,null],[5,"from_ref","","Converts a reference to T into a slice of length 1 (without copying).",null,null],[5,"from_ref_mut","","Converts a reference to T into a slice of length 1 (without copying).",null,null],[0,"memchr","","Pure rust memchr implementation, taken from rust-memchr",null,null],[5,"memchr","core::slice::memchr","Return the first index matching the byte `x` in `text`.",null,null],[5,"memrchr","","Return the last index matching the byte `x` in `text`.",null,null],[8,"SliceIndex","core::slice","A helper trait used for indexing operations.",null,null],[16,"Output","","The output type returned by methods.",162,null],[10,"get","","Returns a shared reference to the output at this location, if in bounds.",162,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"option"}}],[10,"get_mut","","Returns a mutable reference to the output at this location, if in bounds.",162,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"option"}}],[10,"get_unchecked","","Returns a shared reference to the output at this location, without performing any bounds checking.",162,null],[10,"get_unchecked_mut","","Returns a mutable reference to the output at this location, without performing any bounds checking.",162,null],[10,"index","","Returns a shared reference to the output at this location, panicking if out of bounds.",162,null],[10,"index_mut","","Returns a mutable reference to the output at this location, panicking if out of bounds.",162,null],[11,"get","core::ops","",24,null],[11,"get_mut","","",24,null],[11,"get_unchecked","","",24,null],[11,"get_unchecked_mut","","",24,null],[11,"index","","",24,null],[11,"index_mut","","",24,null],[11,"get","","",26,null],[11,"get_mut","","",26,null],[11,"get_unchecked","","",26,null],[11,"get_unchecked_mut","","",26,null],[11,"index","","",26,null],[11,"index_mut","","",26,null],[11,"get","","",25,null],[11,"get_mut","","",25,null],[11,"get_unchecked","","",25,null],[11,"get_unchecked_mut","","",25,null],[11,"index","","",25,null],[11,"index_mut","","",25,null],[11,"get","","",30,null],[11,"get_mut","","",30,null],[11,"get_unchecked","","",30,null],[11,"get_unchecked_mut","","",30,null],[11,"index","","",30,null],[11,"index_mut","","",30,null],[11,"get","","",31,null],[11,"get_mut","","",31,null],[11,"get_unchecked","","",31,null],[11,"get_unchecked_mut","","",31,null],[11,"index","","",31,null],[11,"index_mut","","",31,null],[11,"get","","",27,null],[11,"get_mut","","",27,null],[11,"get_unchecked","","",27,null],[11,"get_unchecked_mut","","",27,null],[11,"index","","",27,null],[11,"index_mut","","",27,null],[11,"fmt","core::slice","",163,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"as_slice","","View the underlying data as a subslice of the original data.",163,null],[11,"next","","",163,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",163,null],[11,"count","","",163,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"nth","","",163,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",163,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"try_fold","","",163,{"inputs":[{"name":"self"},{"name":"b"},{"name":"f"}],"output":{"name":"r"}}],[11,"fold","","",163,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"acc"}}],[11,"position","","",163,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"generics":["usize"],"name":"option"}}],[11,"rposition","","",163,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"generics":["usize"],"name":"option"}}],[11,"next_back","","",163,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"try_rfold","","",163,{"inputs":[{"name":"self"},{"name":"b"},{"name":"f"}],"output":{"name":"r"}}],[11,"rfold","","",163,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"acc"}}],[11,"is_empty","","",163,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",163,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"as_ref","","",163,null],[11,"fmt","","",164,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"into_slice","","View the underlying data as a subslice of the original data.",164,null],[11,"next","","",164,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",164,null],[11,"count","","",164,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"nth","","",164,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",164,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"try_fold","","",164,{"inputs":[{"name":"self"},{"name":"b"},{"name":"f"}],"output":{"name":"r"}}],[11,"fold","","",164,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"acc"}}],[11,"position","","",164,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"generics":["usize"],"name":"option"}}],[11,"rposition","","",164,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"generics":["usize"],"name":"option"}}],[11,"next_back","","",164,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"try_rfold","","",164,{"inputs":[{"name":"self"},{"name":"b"},{"name":"f"}],"output":{"name":"r"}}],[11,"rfold","","",164,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"fold"}],"output":{"name":"acc"}}],[11,"is_empty","","",164,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"fmt","","",165,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",165,{"inputs":[{"name":"self"}],"output":{"name":"split"}}],[11,"next","","",165,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",165,null],[11,"next_back","","",165,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",166,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",166,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",166,null],[11,"next_back","","",166,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",167,{"inputs":[{"name":"self"}],"output":{"name":"rsplit"}}],[11,"fmt","","",167,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",167,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",167,null],[11,"next_back","","",167,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",168,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",168,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",168,null],[11,"next_back","","",168,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",169,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",170,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",171,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",172,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",169,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",169,null],[11,"next","","",170,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",170,null],[11,"next","","",171,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",171,null],[11,"next","","",172,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",172,null],[11,"fmt","","",173,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",173,{"inputs":[{"name":"self"}],"output":{"name":"windows"}}],[11,"next","","",173,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",173,null],[11,"count","","",173,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"nth","","",173,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",173,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",173,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",174,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",174,{"inputs":[{"name":"self"}],"output":{"name":"chunks"}}],[11,"next","","",174,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",174,null],[11,"count","","",174,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"nth","","",174,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",174,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",174,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",175,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",175,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",175,null],[11,"count","","",175,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"nth","","",175,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",175,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",175,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",176,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",176,{"inputs":[{"name":"self"}],"output":{"name":"exactchunks"}}],[11,"next","","",176,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",176,null],[11,"count","","",176,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"nth","","",176,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",176,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",176,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"is_empty","","",176,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"fmt","","",177,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",177,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",177,null],[11,"count","","",177,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"nth","","",177,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",177,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",177,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"is_empty","","",177,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[0,"str","core","String manipulation",null,null],[3,"ParseBoolError","core::str","An error returned when parsing a `bool` using [`from_str`] fails",null,null],[3,"Utf8Error","","Errors which can occur when attempting to interpret a sequence of [`u8`] as a string.",null,null],[3,"Chars","","An iterator over the [`char`]s of a string slice.",null,null],[3,"CharIndices","","An iterator over the [`char`]s of a string slice, and their positions.",null,null],[3,"Bytes","","An iterator over the bytes of a string slice.",null,null],[3,"Split","","Created with the method [`split`].",null,null],[3,"RSplit","","Created with the method [`rsplit`].",null,null],[3,"SplitTerminator","","Created with the method [`split_terminator`].",null,null],[3,"RSplitTerminator","","Created with the method [`rsplit_terminator`].",null,null],[3,"SplitN","","Created with the method [`splitn`].",null,null],[3,"RSplitN","","Created with the method [`rsplitn`].",null,null],[3,"MatchIndices","","Created with the method [`match_indices`].",null,null],[3,"RMatchIndices","","Created with the method [`rmatch_indices`].",null,null],[3,"Matches","","Created with the method [`matches`].",null,null],[3,"RMatches","","Created with the method [`rmatches`].",null,null],[3,"Lines","","An iterator over the lines of a string, as string slices.",null,null],[3,"LinesAny","","Created with the method [`lines_any`].",null,null],[3,"SplitWhitespace","","An iterator over the non-whitespace substrings of a string, separated by any amount of whitespace.",null,null],[3,"EncodeUtf16","","An iterator of [`u16`] over the string encoded as UTF-16.",null,null],[5,"from_utf8","","Converts a slice of bytes to a string slice.",null,null],[5,"from_utf8_mut","","Converts a mutable slice of bytes to a mutable string slice.",null,null],[5,"from_utf8_unchecked","","Converts a slice of bytes to a string slice without checking that the string contains valid UTF-8.",null,null],[5,"from_utf8_unchecked_mut","","Converts a slice of bytes to a string slice without checking that the string contains valid UTF-8; mutable version.",null,null],[5,"next_code_point","","Reads the next code point out of a byte iterator (assuming a UTF-8-like encoding).",null,{"inputs":[{"name":"i"}],"output":{"generics":["u32"],"name":"option"}}],[5,"utf8_char_width","","Given a first byte, determines how many bytes are in this UTF-8 character.",null,{"inputs":[{"name":"u8"}],"output":{"name":"usize"}}],[0,"pattern","","The string Pattern API.",null,null],[3,"CharSearcher","core::str::pattern","Associated type for `<char as Pattern<'a>>::Searcher`.",null,null],[3,"CharSliceSearcher","","Associated type for `<&[char] as Pattern<'a>>::Searcher`.",null,null],[3,"CharPredicateSearcher","","Associated type for `<F as Pattern<'a>>::Searcher`.",null,null],[3,"StrSearcher","","Associated type for `<&str as Pattern<'a>>::Searcher`.",null,null],[4,"SearchStep","","Result of calling `Searcher::next()` or `ReverseSearcher::next_back()`.",null,null],[13,"Match","","Expresses that a match of the pattern has been found at `haystack[a..b]`.",178,null],[13,"Reject","","Expresses that `haystack[a..b]` has been rejected as a possible match of the pattern.",178,null],[13,"Done","","Expresses that every byte of the haystack has been visited, ending the iteration.",178,null],[8,"Pattern","","A string pattern.",null,null],[16,"Searcher","","Associated searcher for this pattern",179,null],[10,"into_searcher","","Constructs the associated searcher from `self` and the `haystack` to search in.",179,null],[11,"is_contained_in","","Checks whether the pattern matches anywhere in the haystack",179,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"is_prefix_of","","Checks whether the pattern matches at the front of the haystack",179,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"is_suffix_of","","Checks whether the pattern matches at the back of the haystack",179,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[8,"Searcher","","A searcher for a string pattern.",null,null],[10,"haystack","","Getter for the underlying string to be searched in",180,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[10,"next","","Performs the next search step starting from the front.",180,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match","","Find the next `Match` result. See `next()`",180,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject","","Find the next `Reject` result. See `next()` and `next_match()`",180,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[8,"ReverseSearcher","","A reverse searcher for a string pattern.",null,null],[10,"next_back","","Performs the next search step starting from the back.",181,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match_back","","Find the next `Match` result. See `next_back()`",181,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject_back","","Find the next `Reject` result. See `next_back()`",181,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[8,"DoubleEndedSearcher","","A marker trait to express that a `ReverseSearcher` can be used for a `DoubleEndedIterator` implementation.",null,null],[11,"clone","","",178,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"eq","","",178,{"inputs":[{"name":"self"},{"name":"searchstep"}],"output":{"name":"bool"}}],[11,"ne","","",178,{"inputs":[{"name":"self"},{"name":"searchstep"}],"output":{"name":"bool"}}],[11,"fmt","","",178,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",182,{"inputs":[{"name":"self"}],"output":{"name":"charsearcher"}}],[11,"fmt","","",182,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"haystack","","",182,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"next","","",182,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match","","",182,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",182,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match_back","","",182,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",183,{"inputs":[{"name":"self"}],"output":{"name":"charslicesearcher"}}],[11,"fmt","","",183,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"haystack","","",183,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"next","","",183,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match","","",183,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject","","",183,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",183,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match_back","","",183,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject_back","","",183,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",184,{"inputs":[{"name":"self"}],"output":{"name":"charpredicatesearcher"}}],[11,"fmt","","",184,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"haystack","","",184,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"next","","",184,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match","","",184,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject","","",184,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",184,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match_back","","",184,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject_back","","",184,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",185,{"inputs":[{"name":"self"}],"output":{"name":"strsearcher"}}],[11,"fmt","","",185,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"haystack","","",185,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"next","","",185,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match","","",185,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",185,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match_back","","",185,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[0,"lossy","core::str","",null,null],[3,"Utf8Lossy","core::str::lossy","Lossy UTF-8 string.",null,null],[3,"Utf8LossyChunksIter","","Iterator over lossy UTF-8 string",null,null],[3,"Utf8LossyChunk","","",null,null],[12,"valid","","Sequence of valid chars. Can be empty between broken UTF-8 chars.",186,null],[12,"broken","","Single broken char, empty if none. Empty iff iterator item is last.",186,null],[11,"from_str","","",187,{"inputs":[{"name":"str"}],"output":{"name":"utf8lossy"}}],[11,"from_bytes","","",187,null],[11,"chunks","","",187,{"inputs":[{"name":"self"}],"output":{"name":"utf8lossychunksiter"}}],[11,"eq","","",186,{"inputs":[{"name":"self"},{"name":"utf8lossychunk"}],"output":{"name":"bool"}}],[11,"ne","","",186,{"inputs":[{"name":"self"},{"name":"utf8lossychunk"}],"output":{"name":"bool"}}],[11,"fmt","","",186,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",188,{"inputs":[{"name":"self"}],"output":{"generics":["utf8lossychunk"],"name":"option"}}],[11,"fmt","","",187,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",187,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"get","core::ops","",30,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"option"}}],[11,"get_mut","","",30,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"option"}}],[11,"get_unchecked","","",30,null],[11,"get_unchecked_mut","","",30,null],[11,"index","","",30,null],[11,"index_mut","","",30,null],[11,"get","","",24,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"option"}}],[11,"get_mut","","",24,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"option"}}],[11,"get_unchecked","","",24,null],[11,"get_unchecked_mut","","",24,null],[11,"index","","",24,null],[11,"index_mut","","",24,null],[11,"get","","",26,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"option"}}],[11,"get_mut","","",26,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"option"}}],[11,"get_unchecked","","",26,null],[11,"get_unchecked_mut","","",26,null],[11,"index","","",26,null],[11,"index_mut","","",26,null],[11,"get","","",25,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"option"}}],[11,"get_mut","","",25,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"option"}}],[11,"get_unchecked","","",25,null],[11,"get_unchecked_mut","","",25,null],[11,"index","","",25,null],[11,"index_mut","","",25,null],[11,"get","","",31,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"option"}}],[11,"get_mut","","",31,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"option"}}],[11,"get_unchecked","","",31,null],[11,"get_unchecked_mut","","",31,null],[11,"index","","",31,null],[11,"index_mut","","",31,null],[11,"get","","",27,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"option"}}],[11,"get_mut","","",27,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"option"}}],[11,"get_unchecked","","",27,null],[11,"get_unchecked_mut","","",27,null],[11,"index","","",27,null],[11,"index_mut","","",27,null],[8,"FromStr","core::str","A trait to abstract the idea of creating a new instance of a type from a string.",null,null],[16,"Err","","The associated error which can be returned from parsing.",189,null],[10,"from_str","","Parses a string `s` to return a value of this type.",189,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"fmt","","",190,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",190,{"inputs":[{"name":"self"}],"output":{"name":"parseboolerror"}}],[11,"eq","","",190,{"inputs":[{"name":"self"},{"name":"parseboolerror"}],"output":{"name":"bool"}}],[11,"ne","","",190,{"inputs":[{"name":"self"},{"name":"parseboolerror"}],"output":{"name":"bool"}}],[11,"fmt","","",190,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",191,{"inputs":[{"name":"self"},{"name":"utf8error"}],"output":{"name":"bool"}}],[11,"ne","","",191,{"inputs":[{"name":"self"},{"name":"utf8error"}],"output":{"name":"bool"}}],[11,"clone","","",191,{"inputs":[{"name":"self"}],"output":{"name":"utf8error"}}],[11,"fmt","","",191,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"valid_up_to","","Returns the index in the given string up to which valid UTF-8 was verified.",191,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"error_len","","Provide more information about the failure:",191,{"inputs":[{"name":"self"}],"output":{"generics":["usize"],"name":"option"}}],[11,"fmt","","",191,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",192,{"inputs":[{"name":"self"}],"output":{"name":"chars"}}],[11,"fmt","","",192,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",192,{"inputs":[{"name":"self"}],"output":{"generics":["char"],"name":"option"}}],[11,"count","","",192,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"size_hint","","",192,null],[11,"last","","",192,{"inputs":[{"name":"self"}],"output":{"generics":["char"],"name":"option"}}],[11,"next_back","","",192,{"inputs":[{"name":"self"}],"output":{"generics":["char"],"name":"option"}}],[11,"as_str","","View the underlying data as a subslice of the original data.",192,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"clone","","",193,{"inputs":[{"name":"self"}],"output":{"name":"charindices"}}],[11,"fmt","","",193,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",193,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"count","","",193,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"size_hint","","",193,null],[11,"last","","",193,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",193,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"as_str","","View the underlying data as a subslice of the original data.",193,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"clone","","",194,{"inputs":[{"name":"self"}],"output":{"name":"bytes"}}],[11,"fmt","","",194,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",194,{"inputs":[{"name":"self"}],"output":{"generics":["u8"],"name":"option"}}],[11,"size_hint","","",194,null],[11,"count","","",194,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"last","","",194,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"nth","","",194,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"all","","",194,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"any","","",194,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"find","","",194,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"option"}}],[11,"position","","",194,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"generics":["usize"],"name":"option"}}],[11,"rposition","","",194,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"generics":["usize"],"name":"option"}}],[11,"next_back","","",194,{"inputs":[{"name":"self"}],"output":{"generics":["u8"],"name":"option"}}],[11,"rfind","","",194,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"option"}}],[11,"len","","",194,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","",194,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"fmt","","",195,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",195,{"inputs":[{"name":"self"}],"output":{"generics":["str"],"name":"option"}}],[11,"clone","","",195,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"fmt","","",196,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",196,{"inputs":[{"name":"self"}],"output":{"generics":["str"],"name":"option"}}],[11,"clone","","",196,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"next_back","","",195,{"inputs":[{"name":"self"}],"output":{"generics":["str"],"name":"option"}}],[11,"next_back","","",196,{"inputs":[{"name":"self"}],"output":{"generics":["str"],"name":"option"}}],[11,"fmt","","",197,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",197,{"inputs":[{"name":"self"}],"output":{"generics":["str"],"name":"option"}}],[11,"clone","","",197,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"fmt","","",198,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",198,{"inputs":[{"name":"self"}],"output":{"generics":["str"],"name":"option"}}],[11,"clone","","",198,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"next_back","","",197,{"inputs":[{"name":"self"}],"output":{"generics":["str"],"name":"option"}}],[11,"next_back","","",198,{"inputs":[{"name":"self"}],"output":{"generics":["str"],"name":"option"}}],[11,"fmt","","",199,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",199,{"inputs":[{"name":"self"}],"output":{"generics":["str"],"name":"option"}}],[11,"clone","","",199,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"fmt","","",200,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",200,{"inputs":[{"name":"self"}],"output":{"generics":["str"],"name":"option"}}],[11,"clone","","",200,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"fmt","","",201,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",201,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",201,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"fmt","","",202,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",202,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",202,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"next_back","","",201,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",202,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",203,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",203,{"inputs":[{"name":"self"}],"output":{"generics":["str"],"name":"option"}}],[11,"clone","","",203,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"fmt","","",204,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",204,{"inputs":[{"name":"self"}],"output":{"generics":["str"],"name":"option"}}],[11,"clone","","",204,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"next_back","","",203,{"inputs":[{"name":"self"}],"output":{"generics":["str"],"name":"option"}}],[11,"next_back","","",204,{"inputs":[{"name":"self"}],"output":{"generics":["str"],"name":"option"}}],[11,"clone","","",205,{"inputs":[{"name":"self"}],"output":{"name":"lines"}}],[11,"fmt","","",205,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",205,{"inputs":[{"name":"self"}],"output":{"generics":["str"],"name":"option"}}],[11,"size_hint","","",205,null],[11,"next_back","","",205,{"inputs":[{"name":"self"}],"output":{"generics":["str"],"name":"option"}}],[11,"clone","","",206,{"inputs":[{"name":"self"}],"output":{"name":"linesany"}}],[11,"fmt","","",206,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",206,{"inputs":[{"name":"self"}],"output":{"generics":["str"],"name":"option"}}],[11,"size_hint","","",206,null],[11,"next_back","","",206,{"inputs":[{"name":"self"}],"output":{"generics":["str"],"name":"option"}}],[11,"clone","","",207,{"inputs":[{"name":"self"}],"output":{"name":"splitwhitespace"}}],[11,"fmt","","",207,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",207,{"inputs":[{"name":"self"}],"output":{"generics":["str"],"name":"option"}}],[11,"next_back","","",207,{"inputs":[{"name":"self"}],"output":{"generics":["str"],"name":"option"}}],[11,"clone","","",208,{"inputs":[{"name":"self"}],"output":{"name":"encodeutf16"}}],[11,"fmt","","",208,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",208,{"inputs":[{"name":"self"}],"output":{"generics":["u16"],"name":"option"}}],[11,"size_hint","","",208,null],[0,"hash","core","Generic hashing support.",null,null],[3,"SipHasher","core::hash","An implementation of SipHash 2-4.",null,null],[3,"BuildHasherDefault","","Used to create a default [`BuildHasher`] instance for types that implement [`Hasher`] and [`Default`].",null,null],[11,"fmt","","",209,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",209,{"inputs":[{"name":"self"}],"output":{"name":"siphasher"}}],[11,"default","","",209,{"inputs":[],"output":{"name":"siphasher"}}],[11,"new","","Creates a new `SipHasher` with the two initial keys set to 0.",209,{"inputs":[],"output":{"name":"siphasher"}}],[11,"new_with_keys","","Creates a `SipHasher` that is keyed off the provided keys.",209,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"siphasher"}}],[11,"write","","",209,null],[11,"finish","","",209,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[8,"Hash","","A hashable type.",null,null],[10,"hash","","Feeds this value into the given [`Hasher`].",210,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"hash_slice","","Feeds a slice of this type into the given [`Hasher`].",210,null],[8,"Hasher","","A trait for hashing an arbitrary stream of bytes.",null,null],[10,"finish","","Returns the hash value for the values written so far.",211,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[10,"write","","Writes some data into this `Hasher`.",211,null],[11,"write_u8","","Writes a single `u8` into this hasher.",211,{"inputs":[{"name":"self"},{"name":"u8"}],"output":null}],[11,"write_u16","","Writes a single `u16` into this hasher.",211,{"inputs":[{"name":"self"},{"name":"u16"}],"output":null}],[11,"write_u32","","Writes a single `u32` into this hasher.",211,{"inputs":[{"name":"self"},{"name":"u32"}],"output":null}],[11,"write_u64","","Writes a single `u64` into this hasher.",211,{"inputs":[{"name":"self"},{"name":"u64"}],"output":null}],[11,"write_u128","","Writes a single `u128` into this hasher.",211,{"inputs":[{"name":"self"},{"name":"u128"}],"output":null}],[11,"write_usize","","Writes a single `usize` into this hasher.",211,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"write_i8","","Writes a single `i8` into this hasher.",211,{"inputs":[{"name":"self"},{"name":"i8"}],"output":null}],[11,"write_i16","","Writes a single `i16` into this hasher.",211,{"inputs":[{"name":"self"},{"name":"i16"}],"output":null}],[11,"write_i32","","Writes a single `i32` into this hasher.",211,{"inputs":[{"name":"self"},{"name":"i32"}],"output":null}],[11,"write_i64","","Writes a single `i64` into this hasher.",211,{"inputs":[{"name":"self"},{"name":"i64"}],"output":null}],[11,"write_i128","","Writes a single `i128` into this hasher.",211,{"inputs":[{"name":"self"},{"name":"i128"}],"output":null}],[11,"write_isize","","Writes a single `isize` into this hasher.",211,{"inputs":[{"name":"self"},{"name":"isize"}],"output":null}],[8,"BuildHasher","","A trait for creating instances of [`Hasher`].",null,null],[16,"Hasher","","Type of the hasher that will be created.",212,null],[10,"build_hasher","","Creates a new hasher.",212,null],[11,"fmt","","",213,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"build_hasher","","",213,{"inputs":[{"name":"self"}],"output":{"name":"h"}}],[11,"clone","","",213,{"inputs":[{"name":"self"}],"output":{"name":"buildhasherdefault"}}],[11,"default","","",213,{"inputs":[],"output":{"name":"buildhasherdefault"}}],[0,"fmt","core","Utilities for formatting and printing strings.",null,null],[3,"DebugStruct","core::fmt","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugTuple","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugSet","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugList","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugMap","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"Error","","The error type which is returned from formatting a message into a stream.",null,null],[3,"Formatter","","A struct to represent both where to emit formatting strings to and how they should be formatted. A mutable version of this is passed to all formatting traits.",null,null],[3,"Arguments","","This structure represents a safely precompiled version of a format string and its arguments. This cannot be generated at runtime because it cannot safely be done, so no constructors are given and the fields are private to prevent modification.",null,null],[4,"Alignment","","Possible alignments returned by `Formatter::align`",null,null],[13,"Left","","Indication that contents should be left-aligned.",214,null],[13,"Right","","Indication that contents should be right-aligned.",214,null],[13,"Center","","Indication that contents should be center-aligned.",214,null],[13,"Unknown","","No alignment was requested.",214,null],[5,"write","","The `write` function takes an output stream, and an `Arguments` struct that can be precompiled with the `format_args!` macro.",null,{"inputs":[{"name":"write"},{"name":"arguments"}],"output":{"name":"result"}}],[11,"field","","Adds a new field to the generated struct output.",215,{"inputs":[{"name":"self"},{"name":"str"},{"name":"debug"}],"output":{"name":"debugstruct"}}],[11,"finish","","Finishes output and returns any error encountered.",215,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"field","","Adds a new field to the generated tuple struct output.",216,{"inputs":[{"name":"self"},{"name":"debug"}],"output":{"name":"debugtuple"}}],[11,"finish","","Finishes output and returns any error encountered.",216,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"entry","","Adds a new entry to the set output.",217,{"inputs":[{"name":"self"},{"name":"debug"}],"output":{"name":"debugset"}}],[11,"entries","","Adds the contents of an iterator of entries to the set output.",217,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"debugset"}}],[11,"finish","","Finishes output and returns any error encountered.",217,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"entry","","Adds a new entry to the list output.",218,{"inputs":[{"name":"self"},{"name":"debug"}],"output":{"name":"debuglist"}}],[11,"entries","","Adds the contents of an iterator of entries to the list output.",218,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"debuglist"}}],[11,"finish","","Finishes output and returns any error encountered.",218,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"entry","","Adds a new entry to the map output.",219,{"inputs":[{"name":"self"},{"name":"debug"},{"name":"debug"}],"output":{"name":"debugmap"}}],[11,"entries","","Adds the contents of an iterator of entries to the map output.",219,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"debugmap"}}],[11,"finish","","Finishes output and returns any error encountered.",219,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[6,"Result","","The type returned by formatter methods.",null,null],[8,"Write","","A collection of methods that are required to format a message into a stream.",null,null],[10,"write_str","","Writes a slice of bytes into this writer, returning whether the write succeeded.",220,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"result"}}],[11,"write_char","","Writes a [`char`] into this writer, returning whether the write succeeded.",220,{"inputs":[{"name":"self"},{"name":"char"}],"output":{"name":"result"}}],[11,"write_fmt","","Glue for usage of the [`write!`] macro with implementors of this trait.",220,{"inputs":[{"name":"self"},{"name":"arguments"}],"output":{"name":"result"}}],[8,"Debug","","`?` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",221,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"Display","","Format trait for an empty format, `{}`.",null,null],[10,"fmt","","Formats the value using the given formatter.",222,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"Octal","","`o` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",223,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"Binary","","`b` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",224,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"LowerHex","","`x` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",225,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"UpperHex","","`X` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",226,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"Pointer","","`p` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",227,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"LowerExp","","`e` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",228,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"UpperExp","","`E` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",229,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",214,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",230,{"inputs":[{"name":"self"}],"output":{"name":"error"}}],[11,"fmt","","",230,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"default","","",230,{"inputs":[],"output":{"name":"error"}}],[11,"hash","","",230,null],[11,"cmp","","",230,{"inputs":[{"name":"self"},{"name":"error"}],"output":{"name":"ordering"}}],[11,"eq","","",230,{"inputs":[{"name":"self"},{"name":"error"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",230,{"inputs":[{"name":"self"},{"name":"error"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"clone","","",231,{"inputs":[{"name":"self"}],"output":{"name":"arguments"}}],[11,"fmt","","",231,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",231,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"pad_integral","","Performs the correct padding for an integer which has already been emitted into a str. The str should not contain the sign for the integer, that will be added by this method.",232,{"inputs":[{"name":"self"},{"name":"bool"},{"name":"str"},{"name":"str"}],"output":{"name":"result"}}],[11,"pad","","This function takes a string slice and emits it to the internal buffer after applying the relevant formatting flags specified. The flags recognized for generic strings are:",232,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"result"}}],[11,"write_str","","Writes some data to the underlying buffer contained within this formatter.",232,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"result"}}],[11,"write_fmt","","Writes some formatted information into this instance",232,{"inputs":[{"name":"self"},{"name":"arguments"}],"output":{"name":"result"}}],[11,"flags","","Flags for formatting",232,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"fill","","Character used as 'fill' whenever there is alignment",232,{"inputs":[{"name":"self"}],"output":{"name":"char"}}],[11,"align","","Flag indicating what form of alignment was requested",232,{"inputs":[{"name":"self"}],"output":{"name":"alignment"}}],[11,"width","","Optionally specified integer width that the output should be.",232,{"inputs":[{"name":"self"}],"output":{"generics":["usize"],"name":"option"}}],[11,"precision","","Optionally specified precision for numeric types.",232,{"inputs":[{"name":"self"}],"output":{"generics":["usize"],"name":"option"}}],[11,"sign_plus","","Determines if the `+` flag was specified.",232,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"sign_minus","","Determines if the `-` flag was specified.",232,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"alternate","","Determines if the `#` flag was specified.",232,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"sign_aware_zero_pad","","Determines if the `0` flag was specified.",232,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"debug_struct","","Creates a [`DebugStruct`] builder designed to assist with creation of [`fmt::Debug`] implementations for structs.",232,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"debugstruct"}}],[11,"debug_tuple","","Creates a `DebugTuple` builder designed to assist with creation of `fmt::Debug` implementations for tuple structs.",232,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"debugtuple"}}],[11,"debug_list","","Creates a `DebugList` builder designed to assist with creation of `fmt::Debug` implementations for list-like structures.",232,{"inputs":[{"name":"self"}],"output":{"name":"debuglist"}}],[11,"debug_set","","Creates a `DebugSet` builder designed to assist with creation of `fmt::Debug` implementations for set-like structures.",232,{"inputs":[{"name":"self"}],"output":{"name":"debugset"}}],[11,"debug_map","","Creates a `DebugMap` builder designed to assist with creation of `fmt::Debug` implementations for map-like structures.",232,{"inputs":[{"name":"self"}],"output":{"name":"debugmap"}}],[11,"write_str","","",232,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"result"}}],[11,"write_char","","",232,{"inputs":[{"name":"self"},{"name":"char"}],"output":{"name":"result"}}],[11,"write_fmt","","",232,{"inputs":[{"name":"self"},{"name":"arguments"}],"output":{"name":"result"}}],[11,"fmt","","",230,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","core::marker","",23,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","core::cell","",98,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",101,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",102,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",103,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",104,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[0,"time","core","Temporal quantification.",null,null],[3,"Duration","core::time","A `Duration` type to represent a span of time, typically used for system timeouts.",null,null],[11,"clone","","",233,{"inputs":[{"name":"self"}],"output":{"name":"duration"}}],[11,"eq","","",233,{"inputs":[{"name":"self"},{"name":"duration"}],"output":{"name":"bool"}}],[11,"ne","","",233,{"inputs":[{"name":"self"},{"name":"duration"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",233,{"inputs":[{"name":"self"},{"name":"duration"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",233,{"inputs":[{"name":"self"},{"name":"duration"}],"output":{"name":"bool"}}],[11,"le","","",233,{"inputs":[{"name":"self"},{"name":"duration"}],"output":{"name":"bool"}}],[11,"gt","","",233,{"inputs":[{"name":"self"},{"name":"duration"}],"output":{"name":"bool"}}],[11,"ge","","",233,{"inputs":[{"name":"self"},{"name":"duration"}],"output":{"name":"bool"}}],[11,"cmp","","",233,{"inputs":[{"name":"self"},{"name":"duration"}],"output":{"name":"ordering"}}],[11,"fmt","","",233,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",233,null],[11,"default","","",233,{"inputs":[],"output":{"name":"duration"}}],[11,"new","","Creates a new `Duration` from the specified number of whole seconds and additional nanoseconds.",233,{"inputs":[{"name":"u64"},{"name":"u32"}],"output":{"name":"duration"}}],[11,"from_secs","","Creates a new `Duration` from the specified number of whole seconds.",233,{"inputs":[{"name":"u64"}],"output":{"name":"duration"}}],[11,"from_millis","","Creates a new `Duration` from the specified number of milliseconds.",233,{"inputs":[{"name":"u64"}],"output":{"name":"duration"}}],[11,"from_micros","","Creates a new `Duration` from the specified number of microseconds.",233,{"inputs":[{"name":"u64"}],"output":{"name":"duration"}}],[11,"from_nanos","","Creates a new `Duration` from the specified number of nanoseconds.",233,{"inputs":[{"name":"u64"}],"output":{"name":"duration"}}],[11,"as_secs","","Returns the number of whole seconds contained by this `Duration`.",233,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"subsec_millis","","Returns the fractional part of this `Duration`, in milliseconds.",233,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"subsec_micros","","Returns the fractional part of this `Duration`, in microseconds.",233,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"subsec_nanos","","Returns the fractional part of this `Duration`, in nanoseconds.",233,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"checked_add","","Checked `Duration` addition. Computes `self + other`, returning [`None`] if overflow occurred.",233,{"inputs":[{"name":"self"},{"name":"duration"}],"output":{"generics":["duration"],"name":"option"}}],[11,"checked_sub","","Checked `Duration` subtraction. Computes `self - other`, returning [`None`] if the result would be negative or if overflow occurred.",233,{"inputs":[{"name":"self"},{"name":"duration"}],"output":{"generics":["duration"],"name":"option"}}],[11,"checked_mul","","Checked `Duration` multiplication. Computes `self * other`, returning [`None`] if overflow occurred.",233,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"generics":["duration"],"name":"option"}}],[11,"checked_div","","Checked `Duration` division. Computes `self / other`, returning [`None`] if `other == 0`.",233,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"generics":["duration"],"name":"option"}}],[11,"add","","",233,{"inputs":[{"name":"self"},{"name":"duration"}],"output":{"name":"duration"}}],[11,"add_assign","","",233,{"inputs":[{"name":"self"},{"name":"duration"}],"output":null}],[11,"sub","","",233,{"inputs":[{"name":"self"},{"name":"duration"}],"output":{"name":"duration"}}],[11,"sub_assign","","",233,{"inputs":[{"name":"self"},{"name":"duration"}],"output":null}],[11,"mul","","",233,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"duration"}}],[11,"mul_assign","","",233,{"inputs":[{"name":"self"},{"name":"u32"}],"output":null}],[11,"div","","",233,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"duration"}}],[11,"div_assign","","",233,{"inputs":[{"name":"self"},{"name":"u32"}],"output":null}],[11,"sum","","",233,{"inputs":[{"name":"i"}],"output":{"name":"duration"}}],[11,"sum","","",233,{"inputs":[{"name":"i"}],"output":{"name":"duration"}}],[0,"unicode","core","",null,null],[11,"clone","core::char","",105,{"inputs":[{"name":"self"}],"output":{"name":"unicodeversion"}}],[11,"fmt","","",105,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"cmp","","",105,{"inputs":[{"name":"self"},{"name":"unicodeversion"}],"output":{"name":"ordering"}}],[11,"eq","","",105,{"inputs":[{"name":"self"},{"name":"unicodeversion"}],"output":{"name":"bool"}}],[11,"ne","","",105,{"inputs":[{"name":"self"},{"name":"unicodeversion"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",105,{"inputs":[{"name":"self"},{"name":"unicodeversion"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",105,{"inputs":[{"name":"self"},{"name":"unicodeversion"}],"output":{"name":"bool"}}],[11,"le","","",105,{"inputs":[{"name":"self"},{"name":"unicodeversion"}],"output":{"name":"bool"}}],[11,"gt","","",105,{"inputs":[{"name":"self"},{"name":"unicodeversion"}],"output":{"name":"bool"}}],[11,"ge","","",105,{"inputs":[{"name":"self"},{"name":"unicodeversion"}],"output":{"name":"bool"}}],[0,"derived_property","core::unicode","",null,null],[5,"Case_Ignorable","core::unicode::derived_property","",null,{"inputs":[{"name":"char"}],"output":{"name":"bool"}}],[5,"Cased","","",null,{"inputs":[{"name":"char"}],"output":{"name":"bool"}}],[0,"property","core::unicode","",null,null],[5,"Pattern_White_Space","core::unicode::property","",null,{"inputs":[{"name":"char"}],"output":{"name":"bool"}}],[0,"alloc","core","",null,null],[3,"Excess","core::alloc","Represents the combination of a starting address and a total capacity of the returned block.",null,null],[12,"0","","",234,null],[12,"1","","",234,null],[3,"Layout","","Layout of a block of memory.",null,null],[3,"LayoutErr","","The parameters given to `Layout::from_size_align` do not satisfy its documented constraints.",null,null],[3,"AllocErr","","The `AllocErr` error specifies whether an allocation failure is specifically due to resource exhaustion or if it is due to something wrong when combining the given input arguments with this allocator.",null,null],[3,"CannotReallocInPlace","","The `CannotReallocInPlace` error is used when `grow_in_place` or `shrink_in_place` were unable to reuse the given memory block for a requested layout.",null,null],[4,"CollectionAllocErr","","Augments `AllocErr` with a CapacityOverflow variant.",null,null],[13,"CapacityOverflow","","Error due to the computed capacity exceeding the collection's maximum (usually `isize::MAX` bytes).",235,null],[13,"AllocErr","","Error due to the allocator (see the `AllocErr` type's docs).",235,null],[20,"Opaque","","An opaque, unsized type. Used for pointers to allocated memory.",null,null],[8,"GlobalAlloc","","A memory allocator that can be registered to be the one backing `std::alloc::Global` though the `#[global_allocator]` attributes.",null,null],[10,"alloc","","Allocate memory as described by the given `layout`.",236,null],[10,"dealloc","","Deallocate the block of memory at the given `ptr` pointer with the given `layout`.",236,null],[11,"alloc_zeroed","","",236,null],[11,"realloc","","Shink or grow a block of memory to the given `new_size`. The block is described by the given `ptr` pointer and `layout`.",236,null],[8,"Alloc","","An implementation of `Alloc` can allocate, reallocate, and deallocate arbitrary blocks of data described via `Layout`.",null,null],[10,"alloc","","Returns a pointer meeting the size and alignment guarantees of `layout`.",237,{"inputs":[{"name":"self"},{"name":"layout"}],"output":{"generics":["nonnull","allocerr"],"name":"result"}}],[10,"dealloc","","Deallocate the memory referenced by `ptr`.",237,{"inputs":[{"name":"self"},{"generics":["opaque"],"name":"nonnull"},{"name":"layout"}],"output":null}],[11,"usable_size","","Returns bounds on the guaranteed usable size of a successful allocation created with the specified `layout`.",237,null],[11,"realloc","","Returns a pointer suitable for holding data described by a new layout with `layout`’s alginment and a size given by `new_size`. To accomplish this, this may extend or shrink the allocation referenced by `ptr` to fit the new layout.",237,{"inputs":[{"name":"self"},{"generics":["opaque"],"name":"nonnull"},{"name":"layout"},{"name":"usize"}],"output":{"generics":["nonnull","allocerr"],"name":"result"}}],[11,"alloc_zeroed","","Behaves like `alloc`, but also ensures that the contents are set to zero before being returned.",237,{"inputs":[{"name":"self"},{"name":"layout"}],"output":{"generics":["nonnull","allocerr"],"name":"result"}}],[11,"alloc_excess","","Behaves like `alloc`, but also returns the whole size of the returned block. For some `layout` inputs, like arrays, this may include extra storage usable for additional data.",237,{"inputs":[{"name":"self"},{"name":"layout"}],"output":{"generics":["excess","allocerr"],"name":"result"}}],[11,"realloc_excess","","Behaves like `realloc`, but also returns the whole size of the returned block. For some `layout` inputs, like arrays, this may include extra storage usable for additional data.",237,{"inputs":[{"name":"self"},{"generics":["opaque"],"name":"nonnull"},{"name":"layout"},{"name":"usize"}],"output":{"generics":["excess","allocerr"],"name":"result"}}],[11,"grow_in_place","","Attempts to extend the allocation referenced by `ptr` to fit `new_size`.",237,{"inputs":[{"name":"self"},{"generics":["opaque"],"name":"nonnull"},{"name":"layout"},{"name":"usize"}],"output":{"generics":["cannotreallocinplace"],"name":"result"}}],[11,"shrink_in_place","","Attempts to shrink the allocation referenced by `ptr` to fit `new_size`.",237,{"inputs":[{"name":"self"},{"generics":["opaque"],"name":"nonnull"},{"name":"layout"},{"name":"usize"}],"output":{"generics":["cannotreallocinplace"],"name":"result"}}],[11,"alloc_one","","Allocates a block suitable for holding an instance of `T`.",237,{"inputs":[{"name":"self"}],"output":{"generics":["nonnull","allocerr"],"name":"result"}}],[11,"dealloc_one","","Deallocates a block suitable for holding an instance of `T`.",237,{"inputs":[{"name":"self"},{"name":"nonnull"}],"output":null}],[11,"alloc_array","","Allocates a block suitable for holding `n` instances of `T`.",237,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"generics":["nonnull","allocerr"],"name":"result"}}],[11,"realloc_array","","Reallocates a block previously suitable for holding `n_old` instances of `T`, returning a block suitable for holding `n_new` instances of `T`.",237,{"inputs":[{"name":"self"},{"name":"nonnull"},{"name":"usize"},{"name":"usize"}],"output":{"generics":["nonnull","allocerr"],"name":"result"}}],[11,"dealloc_array","","Deallocates a block suitable for holding `n` instances of `T`.",237,{"inputs":[{"name":"self"},{"name":"nonnull"},{"name":"usize"}],"output":{"generics":["allocerr"],"name":"result"}}],[11,"null","","Similar to `std::ptr::null`, which requires `T: Sized`.",238,null],[11,"null_mut","","Similar to `std::ptr::null_mut`, which requires `T: Sized`.",238,null],[11,"fmt","","",234,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",239,{"inputs":[{"name":"self"}],"output":{"name":"layout"}}],[11,"fmt","","",239,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",239,{"inputs":[{"name":"self"},{"name":"layout"}],"output":{"name":"bool"}}],[11,"ne","","",239,{"inputs":[{"name":"self"},{"name":"layout"}],"output":{"name":"bool"}}],[11,"from_size_align","","Constructs a `Layout` from a given `size` and `align`, or returns `None` if either of the following conditions are not met:",239,{"inputs":[{"name":"usize"},{"name":"usize"}],"output":{"generics":["layouterr"],"name":"result"}}],[11,"from_size_align_unchecked","","Creates a layout, bypassing all checks.",239,{"inputs":[{"name":"usize"},{"name":"usize"}],"output":{"name":"self"}}],[11,"size","","The minimum size in bytes for a memory block of this layout.",239,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"align","","The minimum byte alignment for a memory block of this layout.",239,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"new","","Constructs a `Layout` suitable for holding a value of type `T`.",239,{"inputs":[],"output":{"name":"self"}}],[11,"for_value","","Produces layout describing a record that could be used to allocate backing structure for `T` (which could be a trait or other unsized type like a slice).",239,{"inputs":[{"name":"t"}],"output":{"name":"self"}}],[11,"align_to","","Creates a layout describing the record that can hold a value of the same layout as `self`, but that also is aligned to alignment `align` (measured in bytes).",239,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"self"}}],[11,"padding_needed_for","","Returns the amount of padding we must insert after `self` to ensure that the following address will satisfy `align` (measured in bytes).",239,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"usize"}}],[11,"repeat","","Creates a layout describing the record for `n` instances of `self`, with a suitable amount of padding between each to ensure that each instance is given its requested size and alignment. On success, returns `(k, offs)` where `k` is the layout of the array and `offs` is the distance between the start of each element in the array.",239,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"generics":["layouterr"],"name":"result"}}],[11,"extend","","Creates a layout describing the record for `self` followed by `next`, including any necessary padding to ensure that `next` will be properly aligned. Note that the result layout will satisfy the alignment properties of both `self` and `next`.",239,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"generics":["layouterr"],"name":"result"}}],[11,"repeat_packed","","Creates a layout describing the record for `n` instances of `self`, with no padding between each instance.",239,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"generics":["layouterr"],"name":"result"}}],[11,"extend_packed","","Creates a layout describing the record for `self` followed by `next` with no additional padding between the two. Since no padding is inserted, the alignment of `next` is irrelevant, and is not incorporated at all into the resulting layout.",239,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"generics":["layouterr"],"name":"result"}}],[11,"array","","Creates a layout describing the record for a `[T; n]`.",239,{"inputs":[{"name":"usize"}],"output":{"generics":["layouterr"],"name":"result"}}],[11,"clone","","",240,{"inputs":[{"name":"self"}],"output":{"name":"layouterr"}}],[11,"eq","","",240,{"inputs":[{"name":"self"},{"name":"layouterr"}],"output":{"name":"bool"}}],[11,"ne","","",240,{"inputs":[{"name":"self"},{"name":"layouterr"}],"output":{"name":"bool"}}],[11,"fmt","","",240,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",240,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",241,{"inputs":[{"name":"self"}],"output":{"name":"allocerr"}}],[11,"eq","","",241,{"inputs":[{"name":"self"},{"name":"allocerr"}],"output":{"name":"bool"}}],[11,"fmt","","",241,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",241,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",242,{"inputs":[{"name":"self"}],"output":{"name":"cannotreallocinplace"}}],[11,"eq","","",242,{"inputs":[{"name":"self"},{"name":"cannotreallocinplace"}],"output":{"name":"bool"}}],[11,"fmt","","",242,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"description","","",242,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"fmt","","",242,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",235,{"inputs":[{"name":"self"}],"output":{"name":"collectionallocerr"}}],[11,"eq","","",235,{"inputs":[{"name":"self"},{"name":"collectionallocerr"}],"output":{"name":"bool"}}],[11,"fmt","","",235,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"from","","",235,{"inputs":[{"name":"allocerr"}],"output":{"name":"self"}}],[0,"heap","core","Use the `alloc` module instead.",null,null],[0,"simd","","Platform independent SIMD vector types and operations.",null,null],[3,"i8x16","core::simd","A 128-bit vector with 16 `i8` lanes.",null,null],[3,"u8x16","","A 128-bit vector with 16 `u8` lanes.",null,null],[3,"m8x16","","A 128-bit vector mask with 16 lanes.",null,null],[3,"i16x8","","A 128-bit vector with 8 `i16` lanes.",null,null],[3,"u16x8","","A 128-bit vector with 8 `u16` lanes.",null,null],[3,"m16x8","","A 128-bit vector mask with 8 lanes.",null,null],[3,"i32x4","","A 128-bit vector with 4 `i32` lanes.",null,null],[3,"u32x4","","A 128-bit vector with 4 `u32` lanes.",null,null],[3,"f32x4","","A 128-bit vector with 4 `f32` lanes.",null,null],[3,"m32x4","","A 128-bit vector mask with 4 lanes.",null,null],[3,"i64x2","","A 128-bit vector with 2 `u64` lanes.",null,null],[3,"u64x2","","A 128-bit vector with 2 `u64` lanes.",null,null],[3,"f64x2","","A 128-bit vector with 2 `f64` lanes.",null,null],[3,"m64x2","","A 128-bit vector mask with 2 lanes.",null,null],[3,"i8x2","","A 16-bit wide vector with 2 `i8` lanes.",null,null],[3,"u8x2","","A 16-bit wide vector with 2 `u8` lanes.",null,null],[3,"m8x2","","A 16-bit wide vector mask with 2 lanes.",null,null],[3,"i8x32","","A 256-bit vector with 32 `i8` lanes.",null,null],[3,"u8x32","","A 256-bit vector with 32 `u8` lanes.",null,null],[3,"m8x32","","A 256-bit vector mask with 32 lanes.",null,null],[3,"i16x16","","A 256-bit vector with 16 `i16` lanes.",null,null],[3,"u16x16","","A 256-bit vector with 16 `u16` lanes.",null,null],[3,"m16x16","","A 256-bit vector mask with 16 lanes.",null,null],[3,"i32x8","","A 256-bit vector with 8 `i32` lanes.",null,null],[3,"u32x8","","A 256-bit vector with 8 `u32` lanes.",null,null],[3,"f32x8","","A 256-bit vector with 8 `f32` lanes.",null,null],[3,"m32x8","","A 256-bit vector mask with 8 lanes.",null,null],[3,"i64x4","","A 256-bit vector with 4 `i64` lanes.",null,null],[3,"u64x4","","A 256-bit vector with 4 `u64` lanes.",null,null],[3,"f64x4","","A 256-bit vector with 4 `f64` lanes.",null,null],[3,"m64x4","","A 256-bit vector mask with 4 lanes.",null,null],[3,"i16x2","","A 32-bit wide vector with 2 `i16` lanes.",null,null],[3,"u16x2","","A 32-bit wide vector with 2 `u16` lanes.",null,null],[3,"m16x2","","A 32-bit wide vector mask with 2 lanes.",null,null],[3,"i8x4","","A 32-bit wide vector with 4 `i8` lanes.",null,null],[3,"u8x4","","A 32-bit wide vector with 4 `u8` lanes.",null,null],[3,"m8x4","","A 32-bit wide vector mask 4 lanes.",null,null],[3,"i8x64","","A 512-bit vector with 64 `i8` lanes.",null,null],[3,"u8x64","","A 512-bit vector with 64 `u8` lanes.",null,null],[3,"m1x64","","A 64-bit vector mask with 64 lanes (FIXME: 512-bit wide).",null,null],[3,"i16x32","","A 512-bit vector with 32 `i16` lanes.",null,null],[3,"u16x32","","A 512-bit vector with 32 `u16` lanes.",null,null],[3,"m1x32","","A 32-bit vector mask with 32 lanes (FIXME: 512-bit wide).",null,null],[3,"i32x16","","A 512-bit vector with 16 `i32` lanes.",null,null],[3,"u32x16","","A 512-bit vector with 16 `u32` lanes.",null,null],[3,"f32x16","","A 512-bit vector with 16 `f32` lanes.",null,null],[3,"m1x16","","A 16-bit vector mask with 16 lanes (FIXME: 512-bit wide).",null,null],[3,"i64x8","","A 512-bit vector with 8 `i64` lanes.",null,null],[3,"u64x8","","A 512-bit vector with 8 `u64` lanes.",null,null],[3,"f64x8","","A 512-bit vector with 8 `f64` lanes.",null,null],[3,"m1x8","","A 8-bit vector mask with 8 lanes (FIXME: 512-bit wide).",null,null],[3,"i8x8","","A 64-bit vector with 8 `i8` lanes.",null,null],[3,"u8x8","","A 64-bit vector with 8 `u8` lanes.",null,null],[3,"m8x8","","A 64-bit vector mask with 8 lanes.",null,null],[3,"i16x4","","A 64-bit vector with 4 `i16` lanes.",null,null],[3,"u16x4","","A 64-bit vector with 4 `u16` lanes.",null,null],[3,"m16x4","","A 64-bit vector mask with 4 lanes.",null,null],[3,"i32x2","","A 64-bit vector with 2 `i32` lanes.",null,null],[3,"u32x2","","A 64-bit vector with 2 `u32` lanes.",null,null],[3,"m32x2","","A 64-bit vector mask with 2 lanes.",null,null],[3,"f32x2","","A 64-bit vector with 2 `f32` lanes.",null,null],[8,"FromBits","","Safe lossless bitwise conversion from `T` to `Self`.",null,null],[10,"from_bits","","Safe lossless bitwise from `T` to `Self`.",243,{"inputs":[{"name":"t"}],"output":{"name":"self"}}],[8,"IntoBits","","Safe lossless bitwise conversion from `Self` to `T`.",null,null],[10,"into_bits","","Safe lossless bitwise transmute from `self` to `T`.",244,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[0,"arch","core","Platform dependent vendor intrinsics.",null,null],[0,"x86","core::arch","Platform-specific intrinsics for the `x86` platform.",null,null],[3,"__m64","core::arch::x86","64-bit wide integer vector type, x86-specific",null,null],[3,"__m128i","","128-bit wide integer vector type, x86-specific",null,null],[3,"__m128","","128-bit wide set of four `f32` types, x86-specific",null,null],[3,"__m128d","","128-bit wide set of two `f64` types, x86-specific",null,null],[3,"__m256i","","256-bit wide integer vector type, x86-specific",null,null],[3,"__m256","","256-bit wide set of eight `f32` types, x86-specific",null,null],[3,"__m256d","","256-bit wide set of four `f64` types, x86-specific",null,null],[3,"CpuidResult","","Result of the `cpuid` instruction.",null,null],[12,"eax","","EAX register.",245,null],[12,"ebx","","EBX register.",245,null],[12,"ecx","","ECX register.",245,null],[12,"edx","","EDX register.",245,null],[5,"__readeflags","","Reads EFLAGS.",null,{"inputs":[],"output":{"name":"u64"}}],[5,"__writeeflags","","Write EFLAGS.",null,{"inputs":[{"name":"u64"}],"output":null}],[5,"_fxsave","","Saves the `x87` FPU, `MMX` technology, `XMM`, and `MXCSR` registers to the 512-byte-long 16-byte-aligned memory region `mem_addr`.",null,null],[5,"_fxrstor","","Restores the `XMM`, `MMX`, `MXCSR`, and `x87` FPU registers from the 512-byte-long 16-byte-aligned memory region `mem_addr`.",null,null],[5,"_bswap","","Return an integer with the reversed byte order of x",null,{"inputs":[{"name":"i32"}],"output":{"name":"i32"}}],[5,"_rdtsc","","Reads the current value of the processor’s time-stamp counter.",null,{"inputs":[],"output":{"name":"i64"}}],[5,"__rdtscp","","Reads the current value of the processor’s time-stamp counter and the `IA32_TSC_AUX MSR`.",null,null],[5,"__cpuid_count","","Returns the result of the `cpuid` instruction for a given `leaf` (`EAX`) and `sub_leaf` (`ECX`).",null,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"cpuidresult"}}],[5,"__cpuid","","See `__cpuid_count`.",null,{"inputs":[{"name":"u32"}],"output":{"name":"cpuidresult"}}],[5,"has_cpuid","","Does the host support the `cpuid` instruction?",null,{"inputs":[],"output":{"name":"bool"}}],[5,"__get_cpuid_max","","Returns the highest-supported `leaf` (`EAX`) and sub-leaf (`ECX`) `cpuid` values.",null,null],[5,"_xsave","","Perform a full or partial save of the enabled processor states to memory at `mem_addr`.",null,null],[5,"_xrstor","","Perform a full or partial restore of the enabled processor states using the state information stored in memory at `mem_addr`.",null,null],[5,"_xsetbv","","Copy 64-bits from `val` to the extended control register (`XCR`) specified by `a`.",null,{"inputs":[{"name":"u32"},{"name":"u64"}],"output":null}],[5,"_xgetbv","","Reads the contents of the extended control register `XCR` specified in `xcr_no`.",null,{"inputs":[{"name":"u32"}],"output":{"name":"u64"}}],[5,"_xsaveopt","","Perform a full or partial save of the enabled processor states to memory at `mem_addr`.",null,null],[5,"_xsavec","","Perform a full or partial save of the enabled processor states to memory at `mem_addr`.",null,null],[5,"_xsaves","","Perform a full or partial save of the enabled processor states to memory at `mem_addr`",null,null],[5,"_xrstors","","Perform a full or partial restore of the enabled processor states using the state information stored in memory at `mem_addr`.",null,null],[5,"_mm_add_ss","","Adds the first component of `a` and `b`, the other components are copied from `a`.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_add_ps","","Adds __m128 vectors.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_sub_ss","","Subtracts the first component of `b` from `a`, the other components are copied from `a`.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_sub_ps","","Subtracts __m128 vectors.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_mul_ss","","Multiplies the first component of `a` and `b`, the other components are copied from `a`.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_mul_ps","","Multiplies __m128 vectors.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_div_ss","","Divides the first component of `b` by `a`, the other components are copied from `a`.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_div_ps","","Divides __m128 vectors.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_sqrt_ss","","Return the square root of the first single-precision (32-bit) floating-point element in `a`, the other elements are unchanged.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_sqrt_ps","","Return the square root of packed single-precision (32-bit) floating-point elements in `a`.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_rcp_ss","","Return the approximate reciprocal of the first single-precision (32-bit) floating-point element in `a`, the other elements are unchanged.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_rcp_ps","","Return the approximate reciprocal of packed single-precision (32-bit) floating-point elements in `a`.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_rsqrt_ss","","Return the approximate reciprocal square root of the fist single-precision (32-bit) floating-point elements in `a`, the other elements are unchanged.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_rsqrt_ps","","Return the approximate reciprocal square root of packed single-precision (32-bit) floating-point elements in `a`.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_min_ss","","Compare the first single-precision (32-bit) floating-point element of `a` and `b`, and return the minimum value in the first element of the return value, the other elements are copied from `a`.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_min_ps","","Compare packed single-precision (32-bit) floating-point elements in `a` and `b`, and return the corresponding minimum values.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_max_ss","","Compare the first single-precision (32-bit) floating-point element of `a` and `b`, and return the maximum value in the first element of the return value, the other elements are copied from `a`.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_max_ps","","Compare packed single-precision (32-bit) floating-point elements in `a` and `b`, and return the corresponding maximum values.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_and_ps","","Bitwise AND of packed single-precision (32-bit) floating-point elements.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_andnot_ps","","Bitwise AND-NOT of packed single-precision (32-bit) floating-point elements.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_or_ps","","Bitwise OR of packed single-precision (32-bit) floating-point elements.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_xor_ps","","Bitwise exclusive OR of packed single-precision (32-bit) floating-point elements.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_cmpeq_ss","","Compare the lowest `f32` of both inputs for equality. The lowest 32 bits of the result will be `0xffffffff` if the two inputs are equal, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_cmplt_ss","","Compare the lowest `f32` of both inputs for less than. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is less than `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_cmple_ss","","Compare the lowest `f32` of both inputs for less than or equal. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is less than or equal `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_cmpgt_ss","","Compare the lowest `f32` of both inputs for greater than. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is greater than `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_cmpge_ss","","Compare the lowest `f32` of both inputs for greater than or equal. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is greater than or equal `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_cmpneq_ss","","Compare the lowest `f32` of both inputs for inequality. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is not equal to `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_cmpnlt_ss","","Compare the lowest `f32` of both inputs for not-less-than. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is not less than `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_cmpnle_ss","","Compare the lowest `f32` of both inputs for not-less-than-or-equal. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is not less than or equal to `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_cmpngt_ss","","Compare the lowest `f32` of both inputs for not-greater-than. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is not greater than `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_cmpnge_ss","","Compare the lowest `f32` of both inputs for not-greater-than-or-equal. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is not greater than or equal to `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_cmpord_ss","","Check if the lowest `f32` of both inputs are ordered. The lowest 32 bits of the result will be `0xffffffff` if neither of `a.extract(0)` or `b.extract(0)` is a NaN, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_cmpunord_ss","","Check if the lowest `f32` of both inputs are unordered. The lowest 32 bits of the result will be `0xffffffff` if any of `a.extract(0)` or `b.extract(0)` is a NaN, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_cmpeq_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input elements were equal, or `0` otherwise.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_cmplt_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is less than the corresponding element in `b`, or `0` otherwise.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_cmple_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is less than or equal to the corresponding element in `b`, or `0` otherwise.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_cmpgt_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is greater than the corresponding element in `b`, or `0` otherwise.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_cmpge_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is greater than or equal to the corresponding element in `b`, or `0` otherwise.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_cmpneq_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input elements are not equal, or `0` otherwise.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_cmpnlt_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is not less than the corresponding element in `b`, or `0` otherwise.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_cmpnle_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is not less than or equal to the corresponding element in `b`, or `0` otherwise.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_cmpngt_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is not greater than the corresponding element in `b`, or `0` otherwise.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_cmpnge_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is not greater than or equal to the corresponding element in `b`, or `0` otherwise.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_cmpord_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. Returns four floats that have one of two possible bit patterns. The element in the output vector will be `0xffffffff` if the input elements in `a` and `b` are ordered (i.e., neither of them is a NaN), or 0 otherwise.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_cmpunord_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. Returns four floats that have one of two possible bit patterns. The element in the output vector will be `0xffffffff` if the input elements in `a` and `b` are unordered (i.e., at least on of them is a NaN), or 0 otherwise.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_comieq_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if they are equal, or `0` otherwise.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"i32"}}],[5,"_mm_comilt_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is less than the one from `b`, or `0` otherwise.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"i32"}}],[5,"_mm_comile_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is less than or equal to the one from `b`, or `0` otherwise.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"i32"}}],[5,"_mm_comigt_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is greater than the one from `b`, or `0` otherwise.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"i32"}}],[5,"_mm_comige_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is greater than or equal to the one from `b`, or `0` otherwise.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"i32"}}],[5,"_mm_comineq_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if they are not equal, or `0` otherwise.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"i32"}}],[5,"_mm_ucomieq_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if they are equal, or `0` otherwise. This instruction will not signal an exception if either argument is a quiet NaN.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"i32"}}],[5,"_mm_ucomilt_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is less than the one from `b`, or `0` otherwise. This instruction will not signal an exception if either argument is a quiet NaN.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"i32"}}],[5,"_mm_ucomile_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is less than or equal to the one from `b`, or `0` otherwise. This instruction will not signal an exception if either argument is a quiet NaN.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"i32"}}],[5,"_mm_ucomigt_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is greater than the one from `b`, or `0` otherwise. This instruction will not signal an exception if either argument is a quiet NaN.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"i32"}}],[5,"_mm_ucomige_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is greater than or equal to the one from `b`, or `0` otherwise. This instruction will not signal an exception if either argument is a quiet NaN.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"i32"}}],[5,"_mm_ucomineq_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if they are not equal, or `0` otherwise. This instruction will not signal an exception if either argument is a quiet NaN.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"i32"}}],[5,"_mm_cvtss_si32","","Convert the lowest 32 bit float in the input vector to a 32 bit integer.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"i32"}}],[5,"_mm_cvt_ss2si","","Alias for `_mm_cvtss_si32`.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"i32"}}],[5,"_mm_cvttss_si32","","Convert the lowest 32 bit float in the input vector to a 32 bit integer with truncation.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"i32"}}],[5,"_mm_cvtt_ss2si","","Alias for `_mm_cvttss_si32`.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"i32"}}],[5,"_mm_cvtss_f32","","Extract the lowest 32 bit float from the input vector.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"f32"}}],[5,"_mm_cvtsi32_ss","","Convert a 32 bit integer to a 32 bit float. The result vector is the input vector `a` with the lowest 32 bit float replaced by the converted integer.",null,{"inputs":[{"name":"__m128"},{"name":"i32"}],"output":{"name":"__m128"}}],[5,"_mm_cvt_si2ss","","Alias for `_mm_cvtsi32_ss`.",null,{"inputs":[{"name":"__m128"},{"name":"i32"}],"output":{"name":"__m128"}}],[5,"_mm_set_ss","","Construct a `__m128` with the lowest element set to `a` and the rest set to zero.",null,{"inputs":[{"name":"f32"}],"output":{"name":"__m128"}}],[5,"_mm_set1_ps","","Construct a `__m128` with all element set to `a`.",null,{"inputs":[{"name":"f32"}],"output":{"name":"__m128"}}],[5,"_mm_set_ps1","","Alias for `_mm_set1_ps`",null,{"inputs":[{"name":"f32"}],"output":{"name":"__m128"}}],[5,"_mm_set_ps","","Construct a `__m128` from four floating point values highest to lowest.",null,{"inputs":[{"name":"f32"},{"name":"f32"},{"name":"f32"},{"name":"f32"}],"output":{"name":"__m128"}}],[5,"_mm_setr_ps","","Construct a `__m128` from four floating point values lowest to highest.",null,{"inputs":[{"name":"f32"},{"name":"f32"},{"name":"f32"},{"name":"f32"}],"output":{"name":"__m128"}}],[5,"_mm_setzero_ps","","Construct a `__m128` with all elements initialized to zero.",null,{"inputs":[],"output":{"name":"__m128"}}],[5,"_mm_shuffle_ps","","Shuffle packed single-precision (32-bit) floating-point elements in `a` and `b` using `mask`.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"},{"name":"u32"}],"output":{"name":"__m128"}}],[5,"_mm_unpackhi_ps","","Unpack and interleave single-precision (32-bit) floating-point elements from the higher half of `a` and `b`.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_unpacklo_ps","","Unpack and interleave single-precision (32-bit) floating-point elements from the lower half of `a` and `b`.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_movehl_ps","","Combine higher half of `a` and `b`. The highwe half of `b` occupies the lower half of result.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_movelh_ps","","Combine lower half of `a` and `b`. The lower half of `b` occupies the higher half of result.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_movemask_ps","","Return a mask of the most significant bit of each element in `a`.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"i32"}}],[5,"_mm_loadh_pi","","Set the upper two single-precision floating-point values with 64 bits of data loaded from the address `p`; the lower two values are passed through from `a`.",null,null],[5,"_mm_loadl_pi","","Load two floats from `p` into the lower half of a `__m128`. The upper half is copied from the upper half of `a`.",null,null],[5,"_mm_load_ss","","Construct a `__m128` with the lowest element read from `p` and the other elements set to zero.",null,null],[5,"_mm_load1_ps","","Construct a `__m128` by duplicating the value read from `p` into all elements.",null,null],[5,"_mm_load_ps1","","Alias for `_mm_load1_ps`",null,null],[5,"_mm_load_ps","","Load four `f32` values from aligned memory into a `__m128`. If the pointer is not aligned to a 128-bit boundary (16 bytes) a general protection fault will be triggered (fatal program crash).",null,null],[5,"_mm_loadu_ps","","Load four `f32` values from memory into a `__m128`. There are no restrictions on memory alignment. For aligned memory `_mm_load_ps` may be faster.",null,null],[5,"_mm_loadr_ps","","Load four `f32` values from aligned memory into a `__m128` in reverse order.",null,null],[5,"_mm_storeh_pi","","Store the upper half of `a` (64 bits) into memory.",null,null],[5,"_mm_storel_pi","","Store the lower half of `a` (64 bits) into memory.",null,null],[5,"_mm_store_ss","","Store the lowest 32 bit float of `a` into memory.",null,null],[5,"_mm_store1_ps","","Store the lowest 32 bit float of `a` repeated four times into aligned memory.",null,null],[5,"_mm_store_ps1","","Alias for `_mm_store1_ps`",null,null],[5,"_mm_store_ps","","Store four 32-bit floats into aligned memory.",null,null],[5,"_mm_storeu_ps","","Store four 32-bit floats into memory. There are no restrictions on memory alignment. For aligned memory `_mm_store_ps` may be faster.",null,null],[5,"_mm_storer_ps","","Store four 32-bit floats into aligned memory in reverse order.",null,null],[5,"_mm_move_ss","","Return a `__m128` with the first component from `b` and the remaining components from `a`.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_sfence","","Perform a serializing operation on all store-to-memory instructions that were issued prior to this instruction.",null,{"inputs":[],"output":null}],[5,"_mm_getcsr","","Get the unsigned 32-bit value of the MXCSR control and status register.",null,{"inputs":[],"output":{"name":"u32"}}],[5,"_mm_setcsr","","Set the MXCSR register with the 32-bit unsigned integer value.",null,{"inputs":[{"name":"u32"}],"output":null}],[5,"_MM_GET_EXCEPTION_MASK","","See `_mm_setcsr`",null,{"inputs":[],"output":{"name":"u32"}}],[5,"_MM_GET_EXCEPTION_STATE","","See `_mm_setcsr`",null,{"inputs":[],"output":{"name":"u32"}}],[5,"_MM_GET_FLUSH_ZERO_MODE","","See `_mm_setcsr`",null,{"inputs":[],"output":{"name":"u32"}}],[5,"_MM_GET_ROUNDING_MODE","","See `_mm_setcsr`",null,{"inputs":[],"output":{"name":"u32"}}],[5,"_MM_SET_EXCEPTION_MASK","","See `_mm_setcsr`",null,{"inputs":[{"name":"u32"}],"output":null}],[5,"_MM_SET_EXCEPTION_STATE","","See `_mm_setcsr`",null,{"inputs":[{"name":"u32"}],"output":null}],[5,"_MM_SET_FLUSH_ZERO_MODE","","See `_mm_setcsr`",null,{"inputs":[{"name":"u32"}],"output":null}],[5,"_MM_SET_ROUNDING_MODE","","See `_mm_setcsr`",null,{"inputs":[{"name":"u32"}],"output":null}],[5,"_mm_prefetch","","Fetch the cache line that contains address `p` using the given `strategy`.",null,null],[5,"_mm_undefined_ps","","Return vector of type __m128 with undefined elements.",null,{"inputs":[],"output":{"name":"__m128"}}],[5,"_MM_TRANSPOSE4_PS","","Transpose the 4x4 matrix formed by 4 rows of __m128 in place.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"},{"name":"__m128"},{"name":"__m128"}],"output":null}],[5,"_mm_stream_ps","","Stores `a` into the memory at `mem_addr` using a non-temporal memory hint.",null,null],[5,"_mm_stream_pi","","Store 64-bits of integer data from a into memory using a non-temporal memory hint.",null,null],[5,"_mm_max_pi16","","Compares the packed 16-bit signed integers of `a` and `b` writing the greatest value into the result.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_m_pmaxsw","","Compares the packed 16-bit signed integers of `a` and `b` writing the greatest value into the result.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_max_pu8","","Compares the packed 8-bit signed integers of `a` and `b` writing the greatest value into the result.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_m_pmaxub","","Compares the packed 8-bit signed integers of `a` and `b` writing the greatest value into the result.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_min_pi16","","Compares the packed 16-bit signed integers of `a` and `b` writing the smallest value into the result.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_m_pminsw","","Compares the packed 16-bit signed integers of `a` and `b` writing the smallest value into the result.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_min_pu8","","Compares the packed 8-bit signed integers of `a` and `b` writing the smallest value into the result.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_m_pminub","","Compares the packed 8-bit signed integers of `a` and `b` writing the smallest value into the result.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_mulhi_pu16","","Multiplies packed 16-bit unsigned integer values and writes the high-order 16 bits of each 32-bit product to the corresponding bits in the destination.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_m_pmulhuw","","Multiplies packed 16-bit unsigned integer values and writes the high-order 16 bits of each 32-bit product to the corresponding bits in the destination.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_avg_pu8","","Computes the rounded averages of the packed unsigned 8-bit integer values and writes the averages to the corresponding bits in the destination.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_m_pavgb","","Computes the rounded averages of the packed unsigned 8-bit integer values and writes the averages to the corresponding bits in the destination.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_avg_pu16","","Computes the rounded averages of the packed unsigned 16-bit integer values and writes the averages to the corresponding bits in the destination.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_m_pavgw","","Computes the rounded averages of the packed unsigned 16-bit integer values and writes the averages to the corresponding bits in the destination.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_sad_pu8","","Subtracts the corresponding 8-bit unsigned integer values of the two 64-bit vector operands and computes the absolute value for each of the difference. Then sum of the 8 absolute differences is written to the bits `[15:0]` of the destination; the remaining bits `[63:16]` are cleared.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_m_psadbw","","Subtracts the corresponding 8-bit unsigned integer values of the two 64-bit vector operands and computes the absolute value for each of the difference. Then sum of the 8 absolute differences is written to the bits `[15:0]` of the destination; the remaining bits `[63:16]` are cleared.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_cvtpi32_ps","","Converts two elements of a 64-bit vector of `[2 x i32]` into two floating point values and writes them to the lower 64-bits of the destination. The remaining higher order elements of the destination are copied from the corresponding elements in the first operand.",null,{"inputs":[{"name":"__m128"},{"name":"__m64"}],"output":{"name":"__m128"}}],[5,"_mm_cvt_pi2ps","","Converts two elements of a 64-bit vector of `[2 x i32]` into two floating point values and writes them to the lower 64-bits of the destination. The remaining higher order elements of the destination are copied from the corresponding elements in the first operand.",null,{"inputs":[{"name":"__m128"},{"name":"__m64"}],"output":{"name":"__m128"}}],[5,"_mm_cvtpi8_ps","","Converts the lower 4 8-bit values of `a` into a 128-bit vector of 4 `f32`s.",null,{"inputs":[{"name":"__m64"}],"output":{"name":"__m128"}}],[5,"_mm_cvtpu8_ps","","Converts the lower 4 8-bit values of `a` into a 128-bit vector of 4 `f32`s.",null,{"inputs":[{"name":"__m64"}],"output":{"name":"__m128"}}],[5,"_mm_cvtpi16_ps","","Converts a 64-bit vector of `i16`s into a 128-bit vector of 4 `f32`s.",null,{"inputs":[{"name":"__m64"}],"output":{"name":"__m128"}}],[5,"_mm_cvtpu16_ps","","Converts a 64-bit vector of `i16`s into a 128-bit vector of 4 `f32`s.",null,{"inputs":[{"name":"__m64"}],"output":{"name":"__m128"}}],[5,"_mm_cvtpi32x2_ps","","Converts the two 32-bit signed integer values from each 64-bit vector operand of `[2 x i32]` into a 128-bit vector of `[4 x float]`.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m128"}}],[5,"_mm_maskmove_si64","","Conditionally copies the values from each 8-bit element in the first 64-bit integer vector operand to the specified memory location, as specified by the most significant bit in the corresponding element in the second 64-bit integer vector operand.",null,null],[5,"_m_maskmovq","","Conditionally copies the values from each 8-bit element in the first 64-bit integer vector operand to the specified memory location, as specified by the most significant bit in the corresponding element in the second 64-bit integer vector operand.",null,null],[5,"_mm_extract_pi16","","Extracts 16-bit element from a 64-bit vector of `[4 x i16]` and returns it, as specified by the immediate integer operand.",null,{"inputs":[{"name":"__m64"},{"name":"i32"}],"output":{"name":"i32"}}],[5,"_m_pextrw","","Extracts 16-bit element from a 64-bit vector of `[4 x i16]` and returns it, as specified by the immediate integer operand.",null,{"inputs":[{"name":"__m64"},{"name":"i32"}],"output":{"name":"i32"}}],[5,"_mm_insert_pi16","","Copies data from the 64-bit vector of `[4 x i16]` to the destination, and inserts the lower 16-bits of an integer operand at the 16-bit offset specified by the immediate operand `n`.",null,{"inputs":[{"name":"__m64"},{"name":"i32"},{"name":"i32"}],"output":{"name":"__m64"}}],[5,"_m_pinsrw","","Copies data from the 64-bit vector of `[4 x i16]` to the destination, and inserts the lower 16-bits of an integer operand at the 16-bit offset specified by the immediate operand `n`.",null,{"inputs":[{"name":"__m64"},{"name":"i32"},{"name":"i32"}],"output":{"name":"__m64"}}],[5,"_mm_movemask_pi8","","Takes the most significant bit from each 8-bit element in a 64-bit integer vector to create a 16-bit mask value. Zero-extends the value to 32-bit integer and writes it to the destination.",null,{"inputs":[{"name":"__m64"}],"output":{"name":"i32"}}],[5,"_m_pmovmskb","","Takes the most significant bit from each 8-bit element in a 64-bit integer vector to create a 16-bit mask value. Zero-extends the value to 32-bit integer and writes it to the destination.",null,{"inputs":[{"name":"__m64"}],"output":{"name":"i32"}}],[5,"_mm_shuffle_pi16","","Shuffles the 4 16-bit integers from a 64-bit integer vector to the destination, as specified by the immediate value operand.",null,{"inputs":[{"name":"__m64"},{"name":"i32"}],"output":{"name":"__m64"}}],[5,"_m_pshufw","","Shuffles the 4 16-bit integers from a 64-bit integer vector to the destination, as specified by the immediate value operand.",null,{"inputs":[{"name":"__m64"},{"name":"i32"}],"output":{"name":"__m64"}}],[5,"_mm_cvttps_pi32","","Convert the two lower packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers with truncation.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"__m64"}}],[5,"_mm_cvtt_ps2pi","","Convert the two lower packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers with truncation.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"__m64"}}],[5,"_mm_cvtps_pi32","","Convert the two lower packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"__m64"}}],[5,"_mm_cvt_ps2pi","","Convert the two lower packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"__m64"}}],[5,"_mm_cvtps_pi16","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed 16-bit integers.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"__m64"}}],[5,"_mm_cvtps_pi8","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed 8-bit integers, and returns theem in the lower 4 elements of the result.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"__m64"}}],[5,"_mm_pause","","Provide a hint to the processor that the code sequence is a spin-wait loop.",null,{"inputs":[],"output":null}],[5,"_mm_clflush","","Invalidate and flush the cache line that contains `p` from all levels of the cache hierarchy.",null,null],[5,"_mm_lfence","","Perform a serializing operation on all load-from-memory instructions that were issued prior to this instruction.",null,{"inputs":[],"output":null}],[5,"_mm_mfence","","Perform a serializing operation on all load-from-memory and store-to-memory instructions that were issued prior to this instruction.",null,{"inputs":[],"output":null}],[5,"_mm_add_epi8","","Add packed 8-bit integers in `a` and `b`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_add_epi16","","Add packed 16-bit integers in `a` and `b`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_add_epi32","","Add packed 32-bit integers in `a` and `b`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_add_epi64","","Add packed 64-bit integers in `a` and \"b`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_adds_epi8","","Add packed 8-bit integers in `a` and `b` using saturation.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_adds_epi16","","Add packed 16-bit integers in `a` and `b` using saturation.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_adds_epu8","","Add packed unsigned 8-bit integers in `a` and `b` using saturation.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_adds_epu16","","Add packed unsigned 16-bit integers in `a` and `b` using saturation.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_avg_epu8","","Average packed unsigned 8-bit integers in `a` and `b`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_avg_epu16","","Average packed unsigned 16-bit integers in `a` and `b`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_madd_epi16","","Multiply and then horizontally add signed 16 bit integers in `a` and `b`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_max_epi16","","Compare packed 16-bit integers in `a` and `b`, and return the packed maximum values.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_max_epu8","","Compare packed unsigned 8-bit integers in `a` and `b`, and return the packed maximum values.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_min_epi16","","Compare packed 16-bit integers in `a` and `b`, and return the packed minimum values.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_min_epu8","","Compare packed unsigned 8-bit integers in `a` and `b`, and return the packed minimum values.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_mulhi_epi16","","Multiply the packed 16-bit integers in `a` and `b`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_mulhi_epu16","","Multiply the packed unsigned 16-bit integers in `a` and `b`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_mullo_epi16","","Multiply the packed 16-bit integers in `a` and `b`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_mul_epu32","","Multiply the low unsigned 32-bit integers from each packed 64-bit element in `a` and `b`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_sad_epu8","","Sum the absolute differences of packed unsigned 8-bit integers.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_sub_epi8","","Subtract packed 8-bit integers in `b` from packed 8-bit integers in `a`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_sub_epi16","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_sub_epi32","","Subtract packed 32-bit integers in `b` from packed 32-bit integers in `a`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_sub_epi64","","Subtract packed 64-bit integers in `b` from packed 64-bit integers in `a`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_subs_epi8","","Subtract packed 8-bit integers in `b` from packed 8-bit integers in `a` using saturation.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_subs_epi16","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a` using saturation.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_subs_epu8","","Subtract packed unsigned 8-bit integers in `b` from packed unsigned 8-bit integers in `a` using saturation.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_subs_epu16","","Subtract packed unsigned 16-bit integers in `b` from packed unsigned 16-bit integers in `a` using saturation.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_slli_si128","","Shift `a` left by `imm8` bytes while shifting in zeros.",null,{"inputs":[{"name":"__m128i"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_bslli_si128","","Shift `a` left by `imm8` bytes while shifting in zeros.",null,{"inputs":[{"name":"__m128i"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_bsrli_si128","","Shift `a` right by `imm8` bytes while shifting in zeros.",null,{"inputs":[{"name":"__m128i"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_slli_epi16","","Shift packed 16-bit integers in `a` left by `imm8` while shifting in zeros.",null,{"inputs":[{"name":"__m128i"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_sll_epi16","","Shift packed 16-bit integers in `a` left by `count` while shifting in zeros.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_slli_epi32","","Shift packed 32-bit integers in `a` left by `imm8` while shifting in zeros.",null,{"inputs":[{"name":"__m128i"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_sll_epi32","","Shift packed 32-bit integers in `a` left by `count` while shifting in zeros.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_slli_epi64","","Shift packed 64-bit integers in `a` left by `imm8` while shifting in zeros.",null,{"inputs":[{"name":"__m128i"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_sll_epi64","","Shift packed 64-bit integers in `a` left by `count` while shifting in zeros.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_srai_epi16","","Shift packed 16-bit integers in `a` right by `imm8` while shifting in sign bits.",null,{"inputs":[{"name":"__m128i"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_sra_epi16","","Shift packed 16-bit integers in `a` right by `count` while shifting in sign bits.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_srai_epi32","","Shift packed 32-bit integers in `a` right by `imm8` while shifting in sign bits.",null,{"inputs":[{"name":"__m128i"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_sra_epi32","","Shift packed 32-bit integers in `a` right by `count` while shifting in sign bits.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_srli_si128","","Shift `a` right by `imm8` bytes while shifting in zeros.",null,{"inputs":[{"name":"__m128i"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_srli_epi16","","Shift packed 16-bit integers in `a` right by `imm8` while shifting in zeros.",null,{"inputs":[{"name":"__m128i"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_srl_epi16","","Shift packed 16-bit integers in `a` right by `count` while shifting in zeros.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_srli_epi32","","Shift packed 32-bit integers in `a` right by `imm8` while shifting in zeros.",null,{"inputs":[{"name":"__m128i"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_srl_epi32","","Shift packed 32-bit integers in `a` right by `count` while shifting in zeros.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_srli_epi64","","Shift packed 64-bit integers in `a` right by `imm8` while shifting in zeros.",null,{"inputs":[{"name":"__m128i"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_srl_epi64","","Shift packed 64-bit integers in `a` right by `count` while shifting in zeros.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_and_si128","","Compute the bitwise AND of 128 bits (representing integer data) in `a` and `b`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_andnot_si128","","Compute the bitwise NOT of 128 bits (representing integer data) in `a` and then AND with `b`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_or_si128","","Compute the bitwise OR of 128 bits (representing integer data) in `a` and `b`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_xor_si128","","Compute the bitwise XOR of 128 bits (representing integer data) in `a` and `b`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_cmpeq_epi8","","Compare packed 8-bit integers in `a` and `b` for equality.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_cmpeq_epi16","","Compare packed 16-bit integers in `a` and `b` for equality.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_cmpeq_epi32","","Compare packed 32-bit integers in `a` and `b` for equality.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_cmpgt_epi8","","Compare packed 8-bit integers in `a` and `b` for greater-than.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_cmpgt_epi16","","Compare packed 16-bit integers in `a` and `b` for greater-than.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_cmpgt_epi32","","Compare packed 32-bit integers in `a` and `b` for greater-than.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_cmplt_epi8","","Compare packed 8-bit integers in `a` and `b` for less-than.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_cmplt_epi16","","Compare packed 16-bit integers in `a` and `b` for less-than.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_cmplt_epi32","","Compare packed 32-bit integers in `a` and `b` for less-than.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_cvtepi32_pd","","Convert the lower two packed 32-bit integers in `a` to packed double-precision (64-bit) floating-point elements.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m128d"}}],[5,"_mm_cvtsi32_sd","","Return `a` with its lower element replaced by `b` after converting it to an `f64`.",null,{"inputs":[{"name":"__m128d"},{"name":"i32"}],"output":{"name":"__m128d"}}],[5,"_mm_cvtepi32_ps","","Convert packed 32-bit integers in `a` to packed single-precision (32-bit) floating-point elements.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m128"}}],[5,"_mm_cvtps_epi32","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"__m128i"}}],[5,"_mm_cvtsi32_si128","","Return a vector whose lowest element is `a` and all higher elements are `0`.",null,{"inputs":[{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_cvtsi128_si32","","Return the lowest element of `a`.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"i32"}}],[5,"_mm_set_epi64x","","Set packed 64-bit integers with the supplied values, from highest to lowest.",null,{"inputs":[{"name":"i64"},{"name":"i64"}],"output":{"name":"__m128i"}}],[5,"_mm_set_epi32","","Set packed 32-bit integers with the supplied values.",null,{"inputs":[{"name":"i32"},{"name":"i32"},{"name":"i32"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_set_epi16","","Set packed 16-bit integers with the supplied values.",null,{"inputs":[{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"}],"output":{"name":"__m128i"}}],[5,"_mm_set_epi8","","Set packed 8-bit integers with the supplied values.",null,{"inputs":[{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"}],"output":{"name":"__m128i"}}],[5,"_mm_set1_epi64x","","Broadcast 64-bit integer `a` to all elements.",null,{"inputs":[{"name":"i64"}],"output":{"name":"__m128i"}}],[5,"_mm_set1_epi32","","Broadcast 32-bit integer `a` to all elements.",null,{"inputs":[{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_set1_epi16","","Broadcast 16-bit integer `a` to all elements.",null,{"inputs":[{"name":"i16"}],"output":{"name":"__m128i"}}],[5,"_mm_set1_epi8","","Broadcast 8-bit integer `a` to all elements.",null,{"inputs":[{"name":"i8"}],"output":{"name":"__m128i"}}],[5,"_mm_setr_epi32","","Set packed 32-bit integers with the supplied values in reverse order.",null,{"inputs":[{"name":"i32"},{"name":"i32"},{"name":"i32"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_setr_epi16","","Set packed 16-bit integers with the supplied values in reverse order.",null,{"inputs":[{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"}],"output":{"name":"__m128i"}}],[5,"_mm_setr_epi8","","Set packed 8-bit integers with the supplied values in reverse order.",null,{"inputs":[{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"}],"output":{"name":"__m128i"}}],[5,"_mm_setzero_si128","","Returns a vector with all elements set to zero.",null,{"inputs":[],"output":{"name":"__m128i"}}],[5,"_mm_loadl_epi64","","Load 64-bit integer from memory into first element of returned vector.",null,null],[5,"_mm_load_si128","","Load 128-bits of integer data from memory into a new vector.",null,null],[5,"_mm_loadu_si128","","Load 128-bits of integer data from memory into a new vector.",null,null],[5,"_mm_maskmoveu_si128","","Conditionally store 8-bit integer elements from `a` into memory using `mask`.",null,null],[5,"_mm_store_si128","","Store 128-bits of integer data from `a` into memory.",null,null],[5,"_mm_storeu_si128","","Store 128-bits of integer data from `a` into memory.",null,null],[5,"_mm_storel_epi64","","Store the lower 64-bit integer `a` to a memory location.",null,null],[5,"_mm_stream_si128","","Stores a 128-bit integer vector to a 128-bit aligned memory location. To minimize caching, the data is flagged as non-temporal (unlikely to be used again soon).",null,null],[5,"_mm_stream_si32","","Stores a 32-bit integer value in the specified memory location. To minimize caching, the data is flagged as non-temporal (unlikely to be used again soon).",null,null],[5,"_mm_move_epi64","","Return a vector where the low element is extracted from `a` and its upper element is zero.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_packs_epi16","","Convert packed 16-bit integers from `a` and `b` to packed 8-bit integers using signed saturation.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_packs_epi32","","Convert packed 32-bit integers from `a` and `b` to packed 16-bit integers using signed saturation.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_packus_epi16","","Convert packed 16-bit integers from `a` and `b` to packed 8-bit integers using unsigned saturation.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_extract_epi16","","Return the `imm8` element of `a`.",null,{"inputs":[{"name":"__m128i"},{"name":"i32"}],"output":{"name":"i32"}}],[5,"_mm_insert_epi16","","Return a new vector where the `imm8` element of `a` is replaced with `i`.",null,{"inputs":[{"name":"__m128i"},{"name":"i32"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_movemask_epi8","","Return a mask of the most significant bit of each element in `a`.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"i32"}}],[5,"_mm_shuffle_epi32","","Shuffle 32-bit integers in `a` using the control in `imm8`.",null,{"inputs":[{"name":"__m128i"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_shufflehi_epi16","","Shuffle 16-bit integers in the high 64 bits of `a` using the control in `imm8`.",null,{"inputs":[{"name":"__m128i"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_shufflelo_epi16","","Shuffle 16-bit integers in the low 64 bits of `a` using the control in `imm8`.",null,{"inputs":[{"name":"__m128i"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_unpackhi_epi8","","Unpack and interleave 8-bit integers from the high half of `a` and `b`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_unpackhi_epi16","","Unpack and interleave 16-bit integers from the high half of `a` and `b`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_unpackhi_epi32","","Unpack and interleave 32-bit integers from the high half of `a` and `b`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_unpackhi_epi64","","Unpack and interleave 64-bit integers from the high half of `a` and `b`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_unpacklo_epi8","","Unpack and interleave 8-bit integers from the low half of `a` and `b`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_unpacklo_epi16","","Unpack and interleave 16-bit integers from the low half of `a` and `b`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_unpacklo_epi32","","Unpack and interleave 32-bit integers from the low half of `a` and `b`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_unpacklo_epi64","","Unpack and interleave 64-bit integers from the low half of `a` and `b`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_add_sd","","Return a new vector with the low element of `a` replaced by the sum of the low elements of `a` and `b`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_add_pd","","Add packed double-precision (64-bit) floating-point elements in `a` and `b`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_div_sd","","Return a new vector with the low element of `a` replaced by the result of diving the lower element of `a` by the lower element of `b`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_div_pd","","Divide packed double-precision (64-bit) floating-point elements in `a` by packed elements in `b`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_max_sd","","Return a new vector with the low element of `a` replaced by the maximum of the lower elements of `a` and `b`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_max_pd","","Return a new vector with the maximum values from corresponding elements in `a` and `b`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_min_sd","","Return a new vector with the low element of `a` replaced by the minimum of the lower elements of `a` and `b`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_min_pd","","Return a new vector with the minimum values from corresponding elements in `a` and `b`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_mul_sd","","Return a new vector with the low element of `a` replaced by multiplying the low elements of `a` and `b`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_mul_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_sqrt_sd","","Return a new vector with the low element of `a` replaced by the square root of the lower element `b`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_sqrt_pd","","Return a new vector with the square root of each of the values in `a`.",null,{"inputs":[{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_sub_sd","","Return a new vector with the low element of `a` replaced by subtracting the low element by `b` from the low element of `a`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_sub_pd","","Subtract packed double-precision (64-bit) floating-point elements in `b` from `a`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_and_pd","","Compute the bitwise AND of packed double-precision (64-bit) floating-point elements in `a` and `b`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_andnot_pd","","Compute the bitwise NOT of `a` and then AND with `b`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_or_pd","","Compute the bitwise OR of `a` and `b`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_xor_pd","","Compute the bitwise OR of `a` and `b`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_cmpeq_sd","","Return a new vector with the low element of `a` replaced by the equality comparison of the lower elements of `a` and `b`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_cmplt_sd","","Return a new vector with the low element of `a` replaced by the less-than comparison of the lower elements of `a` and `b`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_cmple_sd","","Return a new vector with the low element of `a` replaced by the less-than-or-equal comparison of the lower elements of `a` and `b`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_cmpgt_sd","","Return a new vector with the low element of `a` replaced by the greater-than comparison of the lower elements of `a` and `b`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_cmpge_sd","","Return a new vector with the low element of `a` replaced by the greater-than-or-equal comparison of the lower elements of `a` and `b`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_cmpord_sd","","Return a new vector with the low element of `a` replaced by the result of comparing both of the lower elements of `a` and `b` to `NaN`. If neither are equal to `NaN` then `0xFFFFFFFFFFFFFFFF` is used and `0` otherwise.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_cmpunord_sd","","Return a new vector with the low element of `a` replaced by the result of comparing both of the lower elements of `a` and `b` to `NaN`. If either is equal to `NaN` then `0xFFFFFFFFFFFFFFFF` is used and `0` otherwise.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_cmpneq_sd","","Return a new vector with the low element of `a` replaced by the not-equal comparison of the lower elements of `a` and `b`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_cmpnlt_sd","","Return a new vector with the low element of `a` replaced by the not-less-than comparison of the lower elements of `a` and `b`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_cmpnle_sd","","Return a new vector with the low element of `a` replaced by the not-less-than-or-equal comparison of the lower elements of `a` and `b`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_cmpngt_sd","","Return a new vector with the low element of `a` replaced by the not-greater-than comparison of the lower elements of `a` and `b`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_cmpnge_sd","","Return a new vector with the low element of `a` replaced by the not-greater-than-or-equal comparison of the lower elements of `a` and `b`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_cmpeq_pd","","Compare corresponding elements in `a` and `b` for equality.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_cmplt_pd","","Compare corresponding elements in `a` and `b` for less-than.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_cmple_pd","","Compare corresponding elements in `a` and `b` for less-than-or-equal",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_cmpgt_pd","","Compare corresponding elements in `a` and `b` for greater-than.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_cmpge_pd","","Compare corresponding elements in `a` and `b` for greater-than-or-equal.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_cmpord_pd","","Compare corresponding elements in `a` and `b` to see if neither is `NaN`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_cmpunord_pd","","Compare corresponding elements in `a` and `b` to see if either is `NaN`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_cmpneq_pd","","Compare corresponding elements in `a` and `b` for not-equal.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_cmpnlt_pd","","Compare corresponding elements in `a` and `b` for not-less-than.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_cmpnle_pd","","Compare corresponding elements in `a` and `b` for not-less-than-or-equal.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_cmpngt_pd","","Compare corresponding elements in `a` and `b` for not-greater-than.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_cmpnge_pd","","Compare corresponding elements in `a` and `b` for not-greater-than-or-equal.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_comieq_sd","","Compare the lower element of `a` and `b` for equality.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"i32"}}],[5,"_mm_comilt_sd","","Compare the lower element of `a` and `b` for less-than.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"i32"}}],[5,"_mm_comile_sd","","Compare the lower element of `a` and `b` for less-than-or-equal.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"i32"}}],[5,"_mm_comigt_sd","","Compare the lower element of `a` and `b` for greater-than.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"i32"}}],[5,"_mm_comige_sd","","Compare the lower element of `a` and `b` for greater-than-or-equal.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"i32"}}],[5,"_mm_comineq_sd","","Compare the lower element of `a` and `b` for not-equal.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"i32"}}],[5,"_mm_ucomieq_sd","","Compare the lower element of `a` and `b` for equality.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"i32"}}],[5,"_mm_ucomilt_sd","","Compare the lower element of `a` and `b` for less-than.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"i32"}}],[5,"_mm_ucomile_sd","","Compare the lower element of `a` and `b` for less-than-or-equal.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"i32"}}],[5,"_mm_ucomigt_sd","","Compare the lower element of `a` and `b` for greater-than.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"i32"}}],[5,"_mm_ucomige_sd","","Compare the lower element of `a` and `b` for greater-than-or-equal.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"i32"}}],[5,"_mm_ucomineq_sd","","Compare the lower element of `a` and `b` for not-equal.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"i32"}}],[5,"_mm_cvtpd_ps","","Convert packed double-precision (64-bit) floating-point elements in \"a\" to packed single-precision (32-bit) floating-point elements",null,{"inputs":[{"name":"__m128d"}],"output":{"name":"__m128"}}],[5,"_mm_cvtps_pd","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed double-precision (64-bit) floating-point elements.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"__m128d"}}],[5,"_mm_cvtpd_epi32","","Convert packed double-precision (64-bit) floating-point elements in `a` to packed 32-bit integers.",null,{"inputs":[{"name":"__m128d"}],"output":{"name":"__m128i"}}],[5,"_mm_cvtsd_si32","","Convert the lower double-precision (64-bit) floating-point element in a to a 32-bit integer.",null,{"inputs":[{"name":"__m128d"}],"output":{"name":"i32"}}],[5,"_mm_cvtsd_ss","","Convert the lower double-precision (64-bit) floating-point element in `b` to a single-precision (32-bit) floating-point element, store the result in the lower element of the return value, and copy the upper element from `a` to the upper element the return value.",null,{"inputs":[{"name":"__m128"},{"name":"__m128d"}],"output":{"name":"__m128"}}],[5,"_mm_cvtsd_f64","","Return the lower double-precision (64-bit) floating-point element of \"a\".",null,{"inputs":[{"name":"__m128d"}],"output":{"name":"f64"}}],[5,"_mm_cvtss_sd","","Convert the lower single-precision (32-bit) floating-point element in `b` to a double-precision (64-bit) floating-point element, store the result in the lower element of the return value, and copy the upper element from `a` to the upper element the return value.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128"}],"output":{"name":"__m128d"}}],[5,"_mm_cvttpd_epi32","","Convert packed double-precision (64-bit) floating-point elements in `a` to packed 32-bit integers with truncation.",null,{"inputs":[{"name":"__m128d"}],"output":{"name":"__m128i"}}],[5,"_mm_cvttsd_si32","","Convert the lower double-precision (64-bit) floating-point element in `a` to a 32-bit integer with truncation.",null,{"inputs":[{"name":"__m128d"}],"output":{"name":"i32"}}],[5,"_mm_cvttps_epi32","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers with truncation.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"__m128i"}}],[5,"_mm_set_sd","","Copy double-precision (64-bit) floating-point element `a` to the lower element of the packed 64-bit return value.",null,{"inputs":[{"name":"f64"}],"output":{"name":"__m128d"}}],[5,"_mm_set1_pd","","Broadcast double-precision (64-bit) floating-point value a to all elements of the return value.",null,{"inputs":[{"name":"f64"}],"output":{"name":"__m128d"}}],[5,"_mm_set_pd1","","Broadcast double-precision (64-bit) floating-point value a to all elements of the return value.",null,{"inputs":[{"name":"f64"}],"output":{"name":"__m128d"}}],[5,"_mm_set_pd","","Set packed double-precision (64-bit) floating-point elements in the return value with the supplied values.",null,{"inputs":[{"name":"f64"},{"name":"f64"}],"output":{"name":"__m128d"}}],[5,"_mm_setr_pd","","Set packed double-precision (64-bit) floating-point elements in the return value with the supplied values in reverse order.",null,{"inputs":[{"name":"f64"},{"name":"f64"}],"output":{"name":"__m128d"}}],[5,"_mm_setzero_pd","","Returns packed double-precision (64-bit) floating-point elements with all zeros.",null,{"inputs":[],"output":{"name":"__m128d"}}],[5,"_mm_movemask_pd","","Return a mask of the most significant bit of each element in `a`.",null,{"inputs":[{"name":"__m128d"}],"output":{"name":"i32"}}],[5,"_mm_load_pd","","Load 128-bits (composed of 2 packed double-precision (64-bit) floating-point elements) from memory into the returned vector. `mem_addr` must be aligned on a 16-byte boundary or a general-protection exception may be generated.",null,null],[5,"_mm_load_sd","","Loads a 64-bit double-precision value to the low element of a 128-bit integer vector and clears the upper element.",null,null],[5,"_mm_loadh_pd","","Loads a double-precision value into the high-order bits of a 128-bit vector of `[2 x double]`. The low-order bits are copied from the low-order bits of the first operand.",null,null],[5,"_mm_loadl_pd","","Loads a double-precision value into the low-order bits of a 128-bit vector of `[2 x double]`. The high-order bits are copied from the high-order bits of the first operand.",null,null],[5,"_mm_stream_pd","","Stores a 128-bit floating point vector of `[2 x double]` to a 128-bit aligned memory location. To minimize caching, the data is flagged as non-temporal (unlikely to be used again soon).",null,null],[5,"_mm_store_sd","","Stores the lower 64 bits of a 128-bit vector of `[2 x double]` to a memory location.",null,null],[5,"_mm_store_pd","","Store 128-bits (composed of 2 packed double-precision (64-bit) floating-point elements) from `a` into memory. `mem_addr` must be aligned on a 16-byte boundary or a general-protection exception may be generated.",null,null],[5,"_mm_storeu_pd","","Store 128-bits (composed of 2 packed double-precision (64-bit) floating-point elements) from `a` into memory. `mem_addr` does not need to be aligned on any particular boundary.",null,null],[5,"_mm_store1_pd","","Store the lower double-precision (64-bit) floating-point element from `a` into 2 contiguous elements in memory. `mem_addr` must be aligned on a 16-byte boundary or a general-protection exception may be generated.",null,null],[5,"_mm_store_pd1","","Store the lower double-precision (64-bit) floating-point element from `a` into 2 contiguous elements in memory. `mem_addr` must be aligned on a 16-byte boundary or a general-protection exception may be generated.",null,null],[5,"_mm_storer_pd","","Store 2 double-precision (64-bit) floating-point elements from `a` into memory in reverse order. `mem_addr` must be aligned on a 16-byte boundary or a general-protection exception may be generated.",null,null],[5,"_mm_storeh_pd","","Stores the upper 64 bits of a 128-bit vector of `[2 x double]` to a memory location.",null,null],[5,"_mm_storel_pd","","Stores the lower 64 bits of a 128-bit vector of `[2 x double]` to a memory location.",null,null],[5,"_mm_load1_pd","","Load a double-precision (64-bit) floating-point element from memory into both elements of returned vector.",null,null],[5,"_mm_load_pd1","","Load a double-precision (64-bit) floating-point element from memory into both elements of returned vector.",null,null],[5,"_mm_loadr_pd","","Load 2 double-precision (64-bit) floating-point elements from memory into the returned vector in reverse order. `mem_addr` must be aligned on a 16-byte boundary or a general-protection exception may be generated.",null,null],[5,"_mm_loadu_pd","","Load 128-bits (composed of 2 packed double-precision (64-bit) floating-point elements) from memory into the returned vector. `mem_addr` does not need to be aligned on any particular boundary.",null,null],[5,"_mm_shuffle_pd","","Constructs a 128-bit floating-point vector of `[2 x double]` from two 128-bit vector parameters of `[2 x double]`, using the immediate-value parameter as a specifier.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"},{"name":"i32"}],"output":{"name":"__m128d"}}],[5,"_mm_move_sd","","Constructs a 128-bit floating-point vector of `[2 x double]`. The lower 64 bits are set to the lower 64 bits of the second parameter. The upper 64 bits are set to the upper 64 bits of the first parameter.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_castpd_ps","","Casts a 128-bit floating-point vector of `[2 x double]` into a 128-bit floating-point vector of `[4 x float]`.",null,{"inputs":[{"name":"__m128d"}],"output":{"name":"__m128"}}],[5,"_mm_castpd_si128","","Casts a 128-bit floating-point vector of `[2 x double]` into a 128-bit integer vector.",null,{"inputs":[{"name":"__m128d"}],"output":{"name":"__m128i"}}],[5,"_mm_castps_pd","","Casts a 128-bit floating-point vector of `[4 x float]` into a 128-bit floating-point vector of `[2 x double]`.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"__m128d"}}],[5,"_mm_castps_si128","","Casts a 128-bit floating-point vector of `[4 x float]` into a 128-bit integer vector.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"__m128i"}}],[5,"_mm_castsi128_pd","","Casts a 128-bit integer vector into a 128-bit floating-point vector of `[2 x double]`.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m128d"}}],[5,"_mm_castsi128_ps","","Casts a 128-bit integer vector into a 128-bit floating-point vector of `[4 x float]`.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m128"}}],[5,"_mm_undefined_pd","","Return vector of type __m128d with undefined elements.",null,{"inputs":[],"output":{"name":"__m128d"}}],[5,"_mm_undefined_si128","","Return vector of type __m128i with undefined elements.",null,{"inputs":[],"output":{"name":"__m128i"}}],[5,"_mm_unpackhi_pd","","The resulting `__m128d` element is composed by the low-order values of the two `__m128d` interleaved input elements, i.e.:",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_unpacklo_pd","","The resulting `__m128d` element is composed by the high-order values of the two `__m128d` interleaved input elements, i.e.:",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_add_si64","","Adds two signed or unsigned 64-bit integer values, returning the lower 64 bits of the sum.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_mul_su32","","Multiplies 32-bit unsigned integer values contained in the lower bits of the two 64-bit integer vectors and returns the 64-bit unsigned product.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_sub_si64","","Subtracts signed or unsigned 64-bit integer values and writes the difference to the corresponding bits in the destination.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_cvtpi32_pd","","Converts the two signed 32-bit integer elements of a 64-bit vector of `[2 x i32]` into two double-precision floating-point values, returned in a 128-bit vector of `[2 x double]`.",null,{"inputs":[{"name":"__m64"}],"output":{"name":"__m128d"}}],[5,"_mm_set_epi64","","Initializes both 64-bit values in a 128-bit vector of `[2 x i64]` with the specified 64-bit integer values.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m128i"}}],[5,"_mm_set1_epi64","","Initializes both values in a 128-bit vector of `[2 x i64]` with the specified 64-bit value.",null,{"inputs":[{"name":"__m64"}],"output":{"name":"__m128i"}}],[5,"_mm_setr_epi64","","Constructs a 128-bit integer vector, initialized in reverse order with the specified 64-bit integral values.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m128i"}}],[5,"_mm_movepi64_pi64","","Returns the lower 64 bits of a 128-bit integer vector as a 64-bit integer.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m64"}}],[5,"_mm_movpi64_epi64","","Moves the 64-bit operand to a 128-bit integer vector, zeroing the upper bits.",null,{"inputs":[{"name":"__m64"}],"output":{"name":"__m128i"}}],[5,"_mm_cvtpd_pi32","","Converts the two double-precision floating-point elements of a 128-bit vector of `[2 x double]` into two signed 32-bit integer values, returned in a 64-bit vector of `[2 x i32]`.",null,{"inputs":[{"name":"__m128d"}],"output":{"name":"__m64"}}],[5,"_mm_cvttpd_pi32","","Converts the two double-precision floating-point elements of a 128-bit vector of `[2 x double]` into two signed 32-bit integer values, returned in a 64-bit vector of `[2 x i32]`. If the result of either conversion is inexact, the result is truncated (rounded towards zero) regardless of the current MXCSR setting.",null,{"inputs":[{"name":"__m128d"}],"output":{"name":"__m64"}}],[5,"_mm_addsub_ps","","Alternatively add and subtract packed single-precision (32-bit) floating-point elements in `a` to/from packed elements in `b`.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_addsub_pd","","Alternatively add and subtract packed double-precision (64-bit) floating-point elements in `a` to/from packed elements in `b`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_hadd_pd","","Horizontally add adjacent pairs of double-precision (64-bit) floating-point elements in `a` and `b`, and pack the results.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_hadd_ps","","Horizontally add adjacent pairs of single-precision (32-bit) floating-point elements in `a` and `b`, and pack the results.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_hsub_pd","","Horizontally subtract adjacent pairs of double-precision (64-bit) floating-point elements in `a` and `b`, and pack the results.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_hsub_ps","","Horizontally add adjacent pairs of single-precision (32-bit) floating-point elements in `a` and `b`, and pack the results.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_lddqu_si128","","Load 128-bits of integer data from unaligned memory. This intrinsic may perform better than `_mm_loadu_si128` when the data crosses a cache line boundary.",null,null],[5,"_mm_movedup_pd","","Duplicate the low double-precision (64-bit) floating-point element from `a`.",null,{"inputs":[{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_loaddup_pd","","Load a double-precision (64-bit) floating-point element from memory into both elements of return vector.",null,null],[5,"_mm_movehdup_ps","","Duplicate odd-indexed single-precision (32-bit) floating-point elements from `a`.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_moveldup_ps","","Duplicate even-indexed single-precision (32-bit) floating-point elements from `a`.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_abs_epi8","","Compute the absolute value of packed 8-bit signed integers in `a` and return the unsigned results.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_abs_epi16","","Compute the absolute value of each of the packed 16-bit signed integers in `a` and return the 16-bit unsigned integer",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_abs_epi32","","Compute the absolute value of each of the packed 32-bit signed integers in `a` and return the 32-bit unsigned integer",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_shuffle_epi8","","Shuffle bytes from `a` according to the content of `b`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_alignr_epi8","","Concatenate 16-byte blocks in `a` and `b` into a 32-byte temporary result, shift the result right by `n` bytes, and return the low 16 bytes.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_hadd_epi16","","Horizontally add the adjacent pairs of values contained in 2 packed 128-bit vectors of `[8 x i16]`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_hadds_epi16","","Horizontally add the adjacent pairs of values contained in 2 packed 128-bit vectors of `[8 x i16]`. Positive sums greater than 7FFFh are saturated to 7FFFh. Negative sums less than 8000h are saturated to 8000h.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_hadd_epi32","","Horizontally add the adjacent pairs of values contained in 2 packed 128-bit vectors of `[4 x i32]`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_hsub_epi16","","Horizontally subtract the adjacent pairs of values contained in 2 packed 128-bit vectors of `[8 x i16]`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_hsubs_epi16","","Horizontally subtract the adjacent pairs of values contained in 2 packed 128-bit vectors of `[8 x i16]`. Positive differences greater than 7FFFh are saturated to 7FFFh. Negative differences less than 8000h are saturated to 8000h.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_hsub_epi32","","Horizontally subtract the adjacent pairs of values contained in 2 packed 128-bit vectors of `[4 x i32]`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_maddubs_epi16","","Multiply corresponding pairs of packed 8-bit unsigned integer values contained in the first source operand and packed 8-bit signed integer values contained in the second source operand, add pairs of contiguous products with signed saturation, and writes the 16-bit sums to the corresponding bits in the destination.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_mulhrs_epi16","","Multiply packed 16-bit signed integer values, truncate the 32-bit product to the 18 most significant bits by right-shifting, round the truncated value by adding 1, and write bits `[16:1]` to the destination.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_sign_epi8","","Negate packed 8-bit integers in `a` when the corresponding signed 8-bit integer in `b` is negative, and return the result. Elements in result are zeroed out when the corresponding element in `b` is zero.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_sign_epi16","","Negate packed 16-bit integers in `a` when the corresponding signed 16-bit integer in `b` is negative, and return the results. Elements in result are zeroed out when the corresponding element in `b` is zero.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_sign_epi32","","Negate packed 32-bit integers in `a` when the corresponding signed 32-bit integer in `b` is negative, and return the results. Element in result are zeroed out when the corresponding element in `b` is zero.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_abs_pi8","","Compute the absolute value of packed 8-bit integers in `a` and return the unsigned results.",null,{"inputs":[{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_abs_pi16","","Compute the absolute value of packed 8-bit integers in `a`, and return the unsigned results.",null,{"inputs":[{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_abs_pi32","","Compute the absolute value of packed 32-bit integers in `a`, and return the unsigned results.",null,{"inputs":[{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_shuffle_pi8","","Shuffle packed 8-bit integers in `a` according to shuffle control mask in the corresponding 8-bit element of `b`, and return the results",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_alignr_pi8","","Concatenates the two 64-bit integer vector operands, and right-shifts the result by the number of bytes specified in the immediate operand.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"},{"name":"i32"}],"output":{"name":"__m64"}}],[5,"_mm_hadd_pi16","","Horizontally add the adjacent pairs of values contained in 2 packed 64-bit vectors of `[4 x i16]`.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_hadd_pi32","","Horizontally add the adjacent pairs of values contained in 2 packed 64-bit vectors of `[2 x i32]`.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_hadds_pi16","","Horizontally add the adjacent pairs of values contained in 2 packed 64-bit vectors of `[4 x i16]`. Positive sums greater than 7FFFh are saturated to 7FFFh. Negative sums less than 8000h are saturated to 8000h.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_hsub_pi16","","Horizontally subtracts the adjacent pairs of values contained in 2 packed 64-bit vectors of `[4 x i16]`.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_hsub_pi32","","Horizontally subtracts the adjacent pairs of values contained in 2 packed 64-bit vectors of `[2 x i32]`.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_hsubs_pi16","","Horizontally subtracts the adjacent pairs of values contained in 2 packed 64-bit vectors of `[4 x i16]`. Positive differences greater than 7FFFh are saturated to 7FFFh. Negative differences less than 8000h are saturated to 8000h.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_maddubs_pi16","","Multiplies corresponding pairs of packed 8-bit unsigned integer values contained in the first source operand and packed 8-bit signed integer values contained in the second source operand, adds pairs of contiguous products with signed saturation, and writes the 16-bit sums to the corresponding bits in the destination.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_mulhrs_pi16","","Multiplies packed 16-bit signed integer values, truncates the 32-bit products to the 18 most significant bits by right-shifting, rounds the truncated value by adding 1, and writes bits `[16:1]` to the destination.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_sign_pi8","","Negate packed 8-bit integers in `a` when the corresponding signed 8-bit integer in `b` is negative, and return the results. Element in result are zeroed out when the corresponding element in `b` is zero.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_sign_pi16","","Negate packed 16-bit integers in `a` when the corresponding signed 16-bit integer in `b` is negative, and return the results. Element in result are zeroed out when the corresponding element in `b` is zero.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_sign_pi32","","Negate packed 32-bit integers in `a` when the corresponding signed 32-bit integer in `b` is negative, and return the results. Element in result are zeroed out when the corresponding element in `b` is zero.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_blendv_epi8","","Blend packed 8-bit integers from `a` and `b` using `mask`",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_blend_epi16","","Blend packed 16-bit integers from `a` and `b` using the mask `imm8`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_blendv_pd","","Blend packed double-precision (64-bit) floating-point elements from `a` and `b` using `mask`",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_blendv_ps","","Blend packed single-precision (32-bit) floating-point elements from `a` and `b` using `mask`",null,{"inputs":[{"name":"__m128"},{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_blend_pd","","Blend packed double-precision (64-bit) floating-point elements from `a` and `b` using control mask `imm2`",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"},{"name":"i32"}],"output":{"name":"__m128d"}}],[5,"_mm_blend_ps","","Blend packed single-precision (32-bit) floating-point elements from `a` and `b` using mask `imm4`",null,{"inputs":[{"name":"__m128"},{"name":"__m128"},{"name":"i32"}],"output":{"name":"__m128"}}],[5,"_mm_extract_ps","","Extract a single-precision (32-bit) floating-point element from `a`, selected with `imm8`",null,{"inputs":[{"name":"__m128"},{"name":"i32"}],"output":{"name":"i32"}}],[5,"_mm_extract_epi8","","Extract an 8-bit integer from `a`, selected with `imm8`. Returns a 32-bit integer containing the zero-extended integer data.",null,{"inputs":[{"name":"__m128i"},{"name":"i32"}],"output":{"name":"i32"}}],[5,"_mm_extract_epi32","","Extract an 32-bit integer from `a` selected with `imm8`",null,{"inputs":[{"name":"__m128i"},{"name":"i32"}],"output":{"name":"i32"}}],[5,"_mm_insert_ps","","Select a single value in `a` to store at some position in `b`, Then zero elements according to `imm8`.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"},{"name":"i32"}],"output":{"name":"__m128"}}],[5,"_mm_insert_epi8","","Return a copy of `a` with the 8-bit integer from `i` inserted at a location specified by `imm8`.",null,{"inputs":[{"name":"__m128i"},{"name":"i32"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_insert_epi32","","Return a copy of `a` with the 32-bit integer from `i` inserted at a location specified by `imm8`.",null,{"inputs":[{"name":"__m128i"},{"name":"i32"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_max_epi8","","Compare packed 8-bit integers in `a` and `b` and return packed maximum values in dst.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_max_epu16","","Compare packed unsigned 16-bit integers in `a` and `b`, and return packed maximum.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_max_epi32","","Compare packed 32-bit integers in `a` and `b`, and return packed maximum values.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_max_epu32","","Compare packed unsigned 32-bit integers in `a` and `b`, and return packed maximum values.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_min_epi8","","Compare packed 8-bit integers in `a` and `b` and return packed minimum values in dst.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_min_epu16","","Compare packed unsigned 16-bit integers in `a` and `b`, and return packed minimum.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_min_epi32","","Compare packed 32-bit integers in `a` and `b`, and return packed minimum values.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_min_epu32","","Compare packed unsigned 32-bit integers in `a` and `b`, and return packed minimum values.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_packus_epi32","","Convert packed 32-bit integers from `a` and `b` to packed 16-bit integers using unsigned saturation",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_cmpeq_epi64","","Compare packed 64-bit integers in `a` and `b` for equality",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_cvtepi8_epi16","","Sign extend packed 8-bit integers in `a` to packed 16-bit integers",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_cvtepi8_epi32","","Sign extend packed 8-bit integers in `a` to packed 32-bit integers",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_cvtepi8_epi64","","Sign extend packed 8-bit integers in the low 8 bytes of `a` to packed 64-bit integers",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_cvtepi16_epi32","","Sign extend packed 16-bit integers in `a` to packed 32-bit integers",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_cvtepi16_epi64","","Sign extend packed 16-bit integers in `a` to packed 64-bit integers",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_cvtepi32_epi64","","Sign extend packed 32-bit integers in `a` to packed 64-bit integers",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_cvtepu8_epi16","","Zero extend packed unsigned 8-bit integers in `a` to packed 16-bit integers",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_cvtepu8_epi32","","Zero extend packed unsigned 8-bit integers in `a` to packed 32-bit integers",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_cvtepu8_epi64","","Zero extend packed unsigned 8-bit integers in `a` to packed 64-bit integers",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_cvtepu16_epi32","","Zero extend packed unsigned 16-bit integers in `a` to packed 32-bit integers",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_cvtepu16_epi64","","Zero extend packed unsigned 16-bit integers in `a` to packed 64-bit integers",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_cvtepu32_epi64","","Zero extend packed unsigned 32-bit integers in `a` to packed 64-bit integers",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_dp_pd","","Returns the dot product of two __m128d vectors.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"},{"name":"i32"}],"output":{"name":"__m128d"}}],[5,"_mm_dp_ps","","Returns the dot product of two __m128 vectors.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"},{"name":"i32"}],"output":{"name":"__m128"}}],[5,"_mm_floor_pd","","Round the packed double-precision (64-bit) floating-point elements in `a` down to an integer value, and store the results as packed double-precision floating-point elements.",null,{"inputs":[{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_floor_ps","","Round the packed single-precision (32-bit) floating-point elements in `a` down to an integer value, and store the results as packed single-precision floating-point elements.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_floor_sd","","Round the lower double-precision (64-bit) floating-point element in `b` down to an integer value, store the result as a double-precision floating-point element in the lower element of the intrinsic result, and copy the upper element from `a` to the upper element of the intrinsic result.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_floor_ss","","Round the lower single-precision (32-bit) floating-point element in `b` down to an integer value, store the result as a single-precision floating-point element in the lower element of the intrinsic result, and copy the upper 3 packed elements from `a` to the upper elements of the intrinsic result.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_ceil_pd","","Round the packed double-precision (64-bit) floating-point elements in `a` up to an integer value, and store the results as packed double-precision floating-point elements.",null,{"inputs":[{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_ceil_ps","","Round the packed single-precision (32-bit) floating-point elements in `a` up to an integer value, and store the results as packed single-precision floating-point elements.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_ceil_sd","","Round the lower double-precision (64-bit) floating-point element in `b` up to an integer value, store the result as a double-precision floating-point element in the lower element of the intrisic result, and copy the upper element from `a` to the upper element of the intrinsic result.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_ceil_ss","","Round the lower single-precision (32-bit) floating-point element in `b` up to an integer value, store the result as a single-precision floating-point element in the lower element of the intrinsic result, and copy the upper 3 packed elements from `a` to the upper elements of the intrinsic result.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_round_pd","","Round the packed double-precision (64-bit) floating-point elements in `a` using the `rounding` parameter, and store the results as packed double-precision floating-point elements. Rounding is done according to the rounding parameter, which can be one of:",null,{"inputs":[{"name":"__m128d"},{"name":"i32"}],"output":{"name":"__m128d"}}],[5,"_mm_round_ps","","Round the packed single-precision (32-bit) floating-point elements in `a` using the `rounding` parameter, and store the results as packed single-precision floating-point elements. Rounding is done according to the rounding parameter, which can be one of:",null,{"inputs":[{"name":"__m128"},{"name":"i32"}],"output":{"name":"__m128"}}],[5,"_mm_round_sd","","Round the lower double-precision (64-bit) floating-point element in `b` using the `rounding` parameter, store the result as a double-precision floating-point element in the lower element of the intrinsic result, and copy the upper element from `a` to the upper element of the intrinsic result. Rounding is done according to the rounding parameter, which can be one of:",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"},{"name":"i32"}],"output":{"name":"__m128d"}}],[5,"_mm_round_ss","","Round the lower single-precision (32-bit) floating-point element in `b` using the `rounding` parameter, store the result as a single-precision floating-point element in the lower element of the intrinsic result, and copy the upper 3 packed elements from `a` to the upper elements of the instrinsic result. Rounding is done according to the rounding parameter, which can be one of:",null,{"inputs":[{"name":"__m128"},{"name":"__m128"},{"name":"i32"}],"output":{"name":"__m128"}}],[5,"_mm_minpos_epu16","","Finds the minimum unsigned 16-bit element in the 128-bit __m128i vector, returning a vector containing its value in its first position, and its index in its second position; all other elements are set to zero.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_mul_epi32","","Multiply the low 32-bit integers from each packed 64-bit element in `a` and `b`, and return the signed 64-bit result.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_mullo_epi32","","Multiply the packed 32-bit integers in `a` and `b`, producing intermediate 64-bit integers, and returns the lowest 32-bit, whatever they might be, reinterpreted as a signed integer. While `pmulld __m128i::splat(2), __m128i::splat(2)` returns the obvious `__m128i::splat(4)`, due to wrapping arithmetic `pmulld __m128i::splat(i32::MAX), __m128i::splat(2)` would return a negative number.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_mpsadbw_epu8","","Subtracts 8-bit unsigned integer values and computes the absolute values of the differences to the corresponding bits in the destination. Then sums of the absolute differences are returned according to the bit fields in the immediate operand.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_testz_si128","","Tests whether the specified bits in a 128-bit integer vector are all zeros.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"i32"}}],[5,"_mm_testc_si128","","Tests whether the specified bits in a 128-bit integer vector are all ones.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"i32"}}],[5,"_mm_testnzc_si128","","Tests whether the specified bits in a 128-bit integer vector are neither all zeros nor all ones.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"i32"}}],[5,"_mm_test_all_zeros","","Tests whether the specified bits in a 128-bit integer vector are all zeros.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"i32"}}],[5,"_mm_test_all_ones","","Tests whether the specified bits in `a` 128-bit integer vector are all ones.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"i32"}}],[5,"_mm_test_mix_ones_zeros","","Tests whether the specified bits in a 128-bit integer vector are neither all zeros nor all ones.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"i32"}}],[5,"_mm_cmpistrm","","Compare packed strings with implicit lengths in `a` and `b` using the control in `imm8`, and return the generated mask.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_cmpistri","","Compare packed strings with implicit lengths in `a` and `b` using the control in `imm8` and return the generated index. Similar to [`_mm_cmpestri`] with the exception that [`_mm_cmpestri`] requires the lengths of `a` and `b` to be explicitly specified.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"},{"name":"i32"}],"output":{"name":"i32"}}],[5,"_mm_cmpistrz","","Compare packed strings with implicit lengths in `a` and `b` using the control in `imm8`, and return `1` if any character in `b` was null. and `0` otherwise.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"},{"name":"i32"}],"output":{"name":"i32"}}],[5,"_mm_cmpistrc","","Compare packed strings with implicit lengths in `a` and `b` using the control in `imm8`, and return `1` if the resulting mask was non-zero, and `0` otherwise.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"},{"name":"i32"}],"output":{"name":"i32"}}],[5,"_mm_cmpistrs","","Compare packed strings with implicit lengths in `a` and `b` using the control in `imm8`, and returns `1` if any character in `a` was null, and `0` otherwise.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"},{"name":"i32"}],"output":{"name":"i32"}}],[5,"_mm_cmpistro","","Compare packed strings with implicit lengths in `a` and `b` using the control in `imm8`, and return bit `0` of the resulting bit mask.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"},{"name":"i32"}],"output":{"name":"i32"}}],[5,"_mm_cmpistra","","Compare packed strings with implicit lengths in `a` and `b` using the control in `imm8`, and return `1` if `b` did not contain a null character and the resulting mask was zero, and `0` otherwise.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"},{"name":"i32"}],"output":{"name":"i32"}}],[5,"_mm_cmpestrm","","Compare packed strings in `a` and `b` with lengths `la` and `lb` using the control in `imm8`, and return the generated mask.",null,{"inputs":[{"name":"__m128i"},{"name":"i32"},{"name":"__m128i"},{"name":"i32"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_cmpestri","","Compare packed strings `a` and `b` with lengths `la` and `lb` using the control in `imm8` and return the generated index. Similar to [`_mm_cmpistri`] with the exception that [`_mm_cmpistri`] implicitly determines the length of `a` and `b`.",null,{"inputs":[{"name":"__m128i"},{"name":"i32"},{"name":"__m128i"},{"name":"i32"},{"name":"i32"}],"output":{"name":"i32"}}],[5,"_mm_cmpestrz","","Compare packed strings in `a` and `b` with lengths `la` and `lb` using the control in `imm8`, and return `1` if any character in `b` was null, and `0` otherwise.",null,{"inputs":[{"name":"__m128i"},{"name":"i32"},{"name":"__m128i"},{"name":"i32"},{"name":"i32"}],"output":{"name":"i32"}}],[5,"_mm_cmpestrc","","Compare packed strings in `a` and `b` with lengths `la` and `lb` using the control in `imm8`, and return `1` if the resulting mask was non-zero, and `0` otherwise.",null,{"inputs":[{"name":"__m128i"},{"name":"i32"},{"name":"__m128i"},{"name":"i32"},{"name":"i32"}],"output":{"name":"i32"}}],[5,"_mm_cmpestrs","","Compare packed strings in `a` and `b` with lengths `la` and `lb` using the control in `imm8`, and return `1` if any character in a was null, and `0` otherwise.",null,{"inputs":[{"name":"__m128i"},{"name":"i32"},{"name":"__m128i"},{"name":"i32"},{"name":"i32"}],"output":{"name":"i32"}}],[5,"_mm_cmpestro","","Compare packed strings in `a` and `b` with lengths `la` and `lb` using the control in `imm8`, and return bit `0` of the resulting bit mask.",null,{"inputs":[{"name":"__m128i"},{"name":"i32"},{"name":"__m128i"},{"name":"i32"},{"name":"i32"}],"output":{"name":"i32"}}],[5,"_mm_cmpestra","","Compare packed strings in `a` and `b` with lengths `la` and `lb` using the control in `imm8`, and return `1` if `b` did not contain a null character and the resulting mask was zero, and `0` otherwise.",null,{"inputs":[{"name":"__m128i"},{"name":"i32"},{"name":"__m128i"},{"name":"i32"},{"name":"i32"}],"output":{"name":"i32"}}],[5,"_mm_crc32_u8","","Starting with the initial value in `crc`, return the accumulated CRC32 value for unsigned 8-bit integer `v`.",null,{"inputs":[{"name":"u32"},{"name":"u8"}],"output":{"name":"u32"}}],[5,"_mm_crc32_u16","","Starting with the initial value in `crc`, return the accumulated CRC32 value for unsigned 16-bit integer `v`.",null,{"inputs":[{"name":"u32"},{"name":"u16"}],"output":{"name":"u32"}}],[5,"_mm_crc32_u32","","Starting with the initial value in `crc`, return the accumulated CRC32 value for unsigned 32-bit integer `v`.",null,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"u32"}}],[5,"_mm_cmpgt_epi64","","Compare packed 64-bit integers in `a` and `b` for greater-than, return the results.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm256_add_pd","","Add packed double-precision (64-bit) floating-point elements in `a` and `b`.",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"}],"output":{"name":"__m256d"}}],[5,"_mm256_add_ps","","Add packed single-precision (32-bit) floating-point elements in `a` and `b`.",null,{"inputs":[{"name":"__m256"},{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm256_and_pd","","Compute the bitwise AND of a packed double-precision (64-bit) floating-point elements in `a` and `b`.",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"}],"output":{"name":"__m256d"}}],[5,"_mm256_and_ps","","Compute the bitwise AND of packed single-precision (32-bit) floating-point elements in `a` and `b`.",null,{"inputs":[{"name":"__m256"},{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm256_or_pd","","Compute the bitwise OR packed double-precision (64-bit) floating-point elements in `a` and `b`.",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"}],"output":{"name":"__m256d"}}],[5,"_mm256_or_ps","","Compute the bitwise OR packed single-precision (32-bit) floating-point elements in `a` and `b`.",null,{"inputs":[{"name":"__m256"},{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm256_shuffle_pd","","Shuffle double-precision (64-bit) floating-point elements within 128-bit lanes using the control in `imm8`.",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"},{"name":"i32"}],"output":{"name":"__m256d"}}],[5,"_mm256_shuffle_ps","","Shuffle single-precision (32-bit) floating-point elements in `a` within 128-bit lanes using the control in `imm8`.",null,{"inputs":[{"name":"__m256"},{"name":"__m256"},{"name":"i32"}],"output":{"name":"__m256"}}],[5,"_mm256_andnot_pd","","Compute the bitwise NOT of packed double-precision (64-bit) floating-point elements in `a` and then AND with `b`.",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"}],"output":{"name":"__m256d"}}],[5,"_mm256_andnot_ps","","Compute the bitwise NOT of packed single-precision (32-bit) floating-point elements in `a` and then AND with `b`.",null,{"inputs":[{"name":"__m256"},{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm256_max_pd","","Compare packed double-precision (64-bit) floating-point elements in `a` and `b`, and return packed maximum values",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"}],"output":{"name":"__m256d"}}],[5,"_mm256_max_ps","","Compare packed single-precision (32-bit) floating-point elements in `a` and `b`, and return packed maximum values",null,{"inputs":[{"name":"__m256"},{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm256_min_pd","","Compare packed double-precision (64-bit) floating-point elements in `a` and `b`, and return packed minimum values",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"}],"output":{"name":"__m256d"}}],[5,"_mm256_min_ps","","Compare packed single-precision (32-bit) floating-point elements in `a` and `b`, and return packed minimum values",null,{"inputs":[{"name":"__m256"},{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm256_mul_pd","","Add packed double-precision (64-bit) floating-point elements in `a` and `b`.",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"}],"output":{"name":"__m256d"}}],[5,"_mm256_mul_ps","","Add packed single-precision (32-bit) floating-point elements in `a` and `b`.",null,{"inputs":[{"name":"__m256"},{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm256_addsub_pd","","Alternatively add and subtract packed double-precision (64-bit) floating-point elements in `a` to/from packed elements in `b`.",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"}],"output":{"name":"__m256d"}}],[5,"_mm256_addsub_ps","","Alternatively add and subtract packed single-precision (32-bit) floating-point elements in `a` to/from packed elements in `b`.",null,{"inputs":[{"name":"__m256"},{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm256_sub_pd","","Subtract packed double-precision (64-bit) floating-point elements in `b` from packed elements in `a`.",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"}],"output":{"name":"__m256d"}}],[5,"_mm256_sub_ps","","Subtract packed single-precision (32-bit) floating-point elements in `b` from packed elements in `a`.",null,{"inputs":[{"name":"__m256"},{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm256_div_ps","","Compute the division of each of the 8 packed 32-bit floating-point elements in `a` by the corresponding packed elements in `b`.",null,{"inputs":[{"name":"__m256"},{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm256_div_pd","","Compute the division of each of the 4 packed 64-bit floating-point elements in `a` by the corresponding packed elements in `b`.",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"}],"output":{"name":"__m256d"}}],[5,"_mm256_round_pd","","Round packed double-precision (64-bit) floating point elements in `a` according to the flag `b`. The value of `b` may be as follows:",null,{"inputs":[{"name":"__m256d"},{"name":"i32"}],"output":{"name":"__m256d"}}],[5,"_mm256_ceil_pd","","Round packed double-precision (64-bit) floating point elements in `a` toward positive infinity.",null,{"inputs":[{"name":"__m256d"}],"output":{"name":"__m256d"}}],[5,"_mm256_floor_pd","","Round packed double-precision (64-bit) floating point elements in `a` toward negative infinity.",null,{"inputs":[{"name":"__m256d"}],"output":{"name":"__m256d"}}],[5,"_mm256_round_ps","","Round packed single-precision (32-bit) floating point elements in `a` according to the flag `b`. The value of `b` may be as follows:",null,{"inputs":[{"name":"__m256"},{"name":"i32"}],"output":{"name":"__m256"}}],[5,"_mm256_ceil_ps","","Round packed single-precision (32-bit) floating point elements in `a` toward positive infinity.",null,{"inputs":[{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm256_floor_ps","","Round packed single-precision (32-bit) floating point elements in `a` toward negative infinity.",null,{"inputs":[{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm256_sqrt_ps","","Return the square root of packed single-precision (32-bit) floating point elements in `a`.",null,{"inputs":[{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm256_sqrt_pd","","Return the square root of packed double-precision (64-bit) floating point elements in `a`.",null,{"inputs":[{"name":"__m256d"}],"output":{"name":"__m256d"}}],[5,"_mm256_blend_pd","","Blend packed double-precision (64-bit) floating-point elements from `a` and `b` using control mask `imm8`.",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"},{"name":"i32"}],"output":{"name":"__m256d"}}],[5,"_mm256_blend_ps","","Blend packed single-precision (32-bit) floating-point elements from `a` and `b` using control mask `imm8`.",null,{"inputs":[{"name":"__m256"},{"name":"__m256"},{"name":"i32"}],"output":{"name":"__m256"}}],[5,"_mm256_blendv_pd","","Blend packed double-precision (64-bit) floating-point elements from `a` and `b` using `c` as a mask.",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"},{"name":"__m256d"}],"output":{"name":"__m256d"}}],[5,"_mm256_blendv_ps","","Blend packed single-precision (32-bit) floating-point elements from `a` and `b` using `c` as a mask.",null,{"inputs":[{"name":"__m256"},{"name":"__m256"},{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm256_dp_ps","","Conditionally multiply the packed single-precision (32-bit) floating-point elements in `a` and `b` using the high 4 bits in `imm8`, sum the four products, and conditionally return the sum  using the low 4 bits of `imm8`.",null,{"inputs":[{"name":"__m256"},{"name":"__m256"},{"name":"i32"}],"output":{"name":"__m256"}}],[5,"_mm256_hadd_pd","","Horizontal addition of adjacent pairs in the two packed vectors of 4 64-bit floating points `a` and `b`. In the result, sums of elements from `a` are returned in even locations, while sums of elements from `b` are returned in odd locations.",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"}],"output":{"name":"__m256d"}}],[5,"_mm256_hadd_ps","","Horizontal addition of adjacent pairs in the two packed vectors of 8 32-bit floating points `a` and `b`. In the result, sums of elements from `a` are returned in locations of indices 0, 1, 4, 5; while sums of elements from `b` are locations 2, 3, 6, 7.",null,{"inputs":[{"name":"__m256"},{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm256_hsub_pd","","Horizontal subtraction of adjacent pairs in the two packed vectors of 4 64-bit floating points `a` and `b`. In the result, sums of elements from `a` are returned in even locations, while sums of elements from `b` are returned in odd locations.",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"}],"output":{"name":"__m256d"}}],[5,"_mm256_hsub_ps","","Horizontal subtraction of adjacent pairs in the two packed vectors of 8 32-bit floating points `a` and `b`. In the result, sums of elements from `a` are returned in locations of indices 0, 1, 4, 5; while sums of elements from `b` are locations 2, 3, 6, 7.",null,{"inputs":[{"name":"__m256"},{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm256_xor_pd","","Compute the bitwise XOR of packed double-precision (64-bit) floating-point elements in `a` and `b`.",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"}],"output":{"name":"__m256d"}}],[5,"_mm256_xor_ps","","Compute the bitwise XOR of packed single-precision (32-bit) floating-point elements in `a` and `b`.",null,{"inputs":[{"name":"__m256"},{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm_cmp_pd","","Compare packed double-precision (64-bit) floating-point elements in `a` and `b` based on the comparison operand specified by `imm8`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"},{"name":"i32"}],"output":{"name":"__m128d"}}],[5,"_mm256_cmp_pd","","Compare packed double-precision (64-bit) floating-point elements in `a` and `b` based on the comparison operand specified by `imm8`.",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"},{"name":"i32"}],"output":{"name":"__m256d"}}],[5,"_mm_cmp_ps","","Compare packed single-precision (32-bit) floating-point elements in `a` and `b` based on the comparison operand specified by `imm8`.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"},{"name":"i32"}],"output":{"name":"__m128"}}],[5,"_mm256_cmp_ps","","Compare packed single-precision (32-bit) floating-point elements in `a` and `b` based on the comparison operand specified by `imm8`.",null,{"inputs":[{"name":"__m256"},{"name":"__m256"},{"name":"i32"}],"output":{"name":"__m256"}}],[5,"_mm_cmp_sd","","Compare the lower double-precision (64-bit) floating-point element in `a` and `b` based on the comparison operand specified by `imm8`, store the result in the lower element of returned vector, and copy the upper element from `a` to the upper element of returned vector.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"},{"name":"i32"}],"output":{"name":"__m128d"}}],[5,"_mm_cmp_ss","","Compare the lower single-precision (32-bit) floating-point element in `a` and `b` based on the comparison operand specified by `imm8`, store the result in the lower element of returned vector, and copy the upper 3 packed elements from `a` to the upper elements of returned vector.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"},{"name":"i32"}],"output":{"name":"__m128"}}],[5,"_mm256_cvtepi32_pd","","Convert packed 32-bit integers in `a` to packed double-precision (64-bit) floating-point elements.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m256d"}}],[5,"_mm256_cvtepi32_ps","","Convert packed 32-bit integers in `a` to packed single-precision (32-bit) floating-point elements.",null,{"inputs":[{"name":"__m256i"}],"output":{"name":"__m256"}}],[5,"_mm256_cvtpd_ps","","Convert packed double-precision (64-bit) floating-point elements in `a` to packed single-precision (32-bit) floating-point elements.",null,{"inputs":[{"name":"__m256d"}],"output":{"name":"__m128"}}],[5,"_mm256_cvtps_epi32","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers.",null,{"inputs":[{"name":"__m256"}],"output":{"name":"__m256i"}}],[5,"_mm256_cvtps_pd","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed double-precision (64-bit) floating-point elements.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"__m256d"}}],[5,"_mm256_cvttpd_epi32","","Convert packed double-precision (64-bit) floating-point elements in `a` to packed 32-bit integers with truncation.",null,{"inputs":[{"name":"__m256d"}],"output":{"name":"__m128i"}}],[5,"_mm256_cvtpd_epi32","","Convert packed double-precision (64-bit) floating-point elements in `a` to packed 32-bit integers.",null,{"inputs":[{"name":"__m256d"}],"output":{"name":"__m128i"}}],[5,"_mm256_cvttps_epi32","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers with truncation.",null,{"inputs":[{"name":"__m256"}],"output":{"name":"__m256i"}}],[5,"_mm256_extractf128_ps","","Extract 128 bits (composed of 4 packed single-precision (32-bit) floating-point elements) from `a`, selected with `imm8`.",null,{"inputs":[{"name":"__m256"},{"name":"i32"}],"output":{"name":"__m128"}}],[5,"_mm256_extractf128_pd","","Extract 128 bits (composed of 2 packed double-precision (64-bit) floating-point elements) from `a`, selected with `imm8`.",null,{"inputs":[{"name":"__m256d"},{"name":"i32"}],"output":{"name":"__m128d"}}],[5,"_mm256_extractf128_si256","","Extract 128 bits (composed of integer data) from `a`, selected with `imm8`.",null,{"inputs":[{"name":"__m256i"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm256_zeroall","","Zero the contents of all XMM or YMM registers.",null,{"inputs":[],"output":null}],[5,"_mm256_zeroupper","","Zero the upper 128 bits of all YMM registers; the lower 128-bits of the registers are unmodified.",null,{"inputs":[],"output":null}],[5,"_mm256_permutevar_ps","","Shuffle single-precision (32-bit) floating-point elements in `a` within 128-bit lanes using the control in `b`.",null,{"inputs":[{"name":"__m256"},{"name":"__m256i"}],"output":{"name":"__m256"}}],[5,"_mm_permutevar_ps","","Shuffle single-precision (32-bit) floating-point elements in `a` using the control in `b`.",null,{"inputs":[{"name":"__m128"},{"name":"__m128i"}],"output":{"name":"__m128"}}],[5,"_mm256_permute_ps","","Shuffle single-precision (32-bit) floating-point elements in `a` within 128-bit lanes using the control in `imm8`.",null,{"inputs":[{"name":"__m256"},{"name":"i32"}],"output":{"name":"__m256"}}],[5,"_mm_permute_ps","","Shuffle single-precision (32-bit) floating-point elements in `a` using the control in `imm8`.",null,{"inputs":[{"name":"__m128"},{"name":"i32"}],"output":{"name":"__m128"}}],[5,"_mm256_permutevar_pd","","Shuffle double-precision (64-bit) floating-point elements in `a` within 256-bit lanes using the control in `b`.",null,{"inputs":[{"name":"__m256d"},{"name":"__m256i"}],"output":{"name":"__m256d"}}],[5,"_mm_permutevar_pd","","Shuffle double-precision (64-bit) floating-point elements in `a` using the control in `b`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128i"}],"output":{"name":"__m128d"}}],[5,"_mm256_permute_pd","","Shuffle double-precision (64-bit) floating-point elements in `a` within 128-bit lanes using the control in `imm8`.",null,{"inputs":[{"name":"__m256d"},{"name":"i32"}],"output":{"name":"__m256d"}}],[5,"_mm_permute_pd","","Shuffle double-precision (64-bit) floating-point elements in `a` using the control in `imm8`.",null,{"inputs":[{"name":"__m128d"},{"name":"i32"}],"output":{"name":"__m128d"}}],[5,"_mm256_permute2f128_ps","","Shuffle 256-bits (composed of 8 packed single-precision (32-bit) floating-point elements) selected by `imm8` from `a` and `b`.",null,{"inputs":[{"name":"__m256"},{"name":"__m256"},{"name":"i32"}],"output":{"name":"__m256"}}],[5,"_mm256_permute2f128_pd","","Shuffle 256-bits (composed of 4 packed double-precision (64-bit) floating-point elements) selected by `imm8` from `a` and `b`.",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"},{"name":"i32"}],"output":{"name":"__m256d"}}],[5,"_mm256_permute2f128_si256","","Shuffle 258-bits (composed of integer data) selected by `imm8` from `a` and `b`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm256_broadcast_ss","","Broadcast a single-precision (32-bit) floating-point element from memory to all elements of the returned vector.",null,{"inputs":[{"name":"f32"}],"output":{"name":"__m256"}}],[5,"_mm_broadcast_ss","","Broadcast a single-precision (32-bit) floating-point element from memory to all elements of the returned vector.",null,{"inputs":[{"name":"f32"}],"output":{"name":"__m128"}}],[5,"_mm256_broadcast_sd","","Broadcast a double-precision (64-bit) floating-point element from memory to all elements of the returned vector.",null,{"inputs":[{"name":"f64"}],"output":{"name":"__m256d"}}],[5,"_mm256_broadcast_ps","","Broadcast 128 bits from memory (composed of 4 packed single-precision (32-bit) floating-point elements) to all elements of the returned vector.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"__m256"}}],[5,"_mm256_broadcast_pd","","Broadcast 128 bits from memory (composed of 2 packed double-precision (64-bit) floating-point elements) to all elements of the returned vector.",null,{"inputs":[{"name":"__m128d"}],"output":{"name":"__m256d"}}],[5,"_mm256_insertf128_ps","","Copy `a` to result, then insert 128 bits (composed of 4 packed single-precision (32-bit) floating-point elements) from `b` into result at the location specified by `imm8`.",null,{"inputs":[{"name":"__m256"},{"name":"__m128"},{"name":"i32"}],"output":{"name":"__m256"}}],[5,"_mm256_insertf128_pd","","Copy `a` to result, then insert 128 bits (composed of 2 packed double-precision (64-bit) floating-point elements) from `b` into result at the location specified by `imm8`.",null,{"inputs":[{"name":"__m256d"},{"name":"__m128d"},{"name":"i32"}],"output":{"name":"__m256d"}}],[5,"_mm256_insertf128_si256","","Copy `a` to result, then insert 128 bits from `b` into result at the location specified by `imm8`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m128i"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm256_insert_epi8","","Copy `a` to result, and insert the 8-bit integer `i` into result at the location specified by `index`.",null,{"inputs":[{"name":"__m256i"},{"name":"i8"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm256_insert_epi16","","Copy `a` to result, and insert the 16-bit integer `i` into result at the location specified by `index`.",null,{"inputs":[{"name":"__m256i"},{"name":"i16"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm256_insert_epi32","","Copy `a` to result, and insert the 32-bit integer `i` into result at the location specified by `index`.",null,{"inputs":[{"name":"__m256i"},{"name":"i32"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm256_load_pd","","Load 256-bits (composed of 4 packed double-precision (64-bit) floating-point elements) from memory into result. `mem_addr` must be aligned on a 32-byte boundary or a general-protection exception may be generated.",null,null],[5,"_mm256_store_pd","","Store 256-bits (composed of 4 packed double-precision (64-bit) floating-point elements) from `a` into memory. `mem_addr` must be aligned on a 32-byte boundary or a general-protection exception may be generated.",null,null],[5,"_mm256_load_ps","","Load 256-bits (composed of 8 packed single-precision (32-bit) floating-point elements) from memory into result. `mem_addr` must be aligned on a 32-byte boundary or a general-protection exception may be generated.",null,null],[5,"_mm256_store_ps","","Store 256-bits (composed of 8 packed single-precision (32-bit) floating-point elements) from `a` into memory. `mem_addr` must be aligned on a 32-byte boundary or a general-protection exception may be generated.",null,null],[5,"_mm256_loadu_pd","","Load 256-bits (composed of 4 packed double-precision (64-bit) floating-point elements) from memory into result. `mem_addr` does not need to be aligned on any particular boundary.",null,null],[5,"_mm256_storeu_pd","","Store 256-bits (composed of 4 packed double-precision (64-bit) floating-point elements) from `a` into memory. `mem_addr` does not need to be aligned on any particular boundary.",null,null],[5,"_mm256_loadu_ps","","Load 256-bits (composed of 8 packed single-precision (32-bit) floating-point elements) from memory into result. `mem_addr` does not need to be aligned on any particular boundary.",null,null],[5,"_mm256_storeu_ps","","Store 256-bits (composed of 8 packed single-precision (32-bit) floating-point elements) from `a` into memory. `mem_addr` does not need to be aligned on any particular boundary.",null,null],[5,"_mm256_load_si256","","Load 256-bits of integer data from memory into result. `mem_addr` must be aligned on a 32-byte boundary or a general-protection exception may be generated.",null,null],[5,"_mm256_store_si256","","Store 256-bits of integer data from `a` into memory. `mem_addr` must be aligned on a 32-byte boundary or a general-protection exception may be generated.",null,null],[5,"_mm256_loadu_si256","","Load 256-bits of integer data from memory into result. `mem_addr` does not need to be aligned on any particular boundary.",null,null],[5,"_mm256_storeu_si256","","Store 256-bits of integer data from `a` into memory.    `mem_addr` does not need to be aligned on any particular boundary.",null,null],[5,"_mm256_maskload_pd","","Load packed double-precision (64-bit) floating-point elements from memory into result using `mask` (elements are zeroed out when the high bit of the corresponding element is not set).",null,null],[5,"_mm256_maskstore_pd","","Store packed double-precision (64-bit) floating-point elements from `a` into memory using `mask`.",null,null],[5,"_mm_maskload_pd","","Load packed double-precision (64-bit) floating-point elements from memory into result using `mask` (elements are zeroed out when the high bit of the corresponding element is not set).",null,null],[5,"_mm_maskstore_pd","","Store packed double-precision (64-bit) floating-point elements from `a` into memory using `mask`.",null,null],[5,"_mm256_maskload_ps","","Load packed single-precision (32-bit) floating-point elements from memory into result using `mask` (elements are zeroed out when the high bit of the corresponding element is not set).",null,null],[5,"_mm256_maskstore_ps","","Store packed single-precision (32-bit) floating-point elements from `a` into memory using `mask`.",null,null],[5,"_mm_maskload_ps","","Load packed single-precision (32-bit) floating-point elements from memory into result using `mask` (elements are zeroed out when the high bit of the corresponding element is not set).",null,null],[5,"_mm_maskstore_ps","","Store packed single-precision (32-bit) floating-point elements from `a` into memory using `mask`.",null,null],[5,"_mm256_movehdup_ps","","Duplicate odd-indexed single-precision (32-bit) floating-point elements from `a`, and return the results.",null,{"inputs":[{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm256_moveldup_ps","","Duplicate even-indexed single-precision (32-bit) floating-point elements from `a`, and return the results.",null,{"inputs":[{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm256_movedup_pd","","Duplicate even-indexed double-precision (64-bit) floating-point elements from \"a\", and return the results.",null,{"inputs":[{"name":"__m256d"}],"output":{"name":"__m256d"}}],[5,"_mm256_lddqu_si256","","Load 256-bits of integer data from unaligned memory into result. This intrinsic may perform better than `_mm256_loadu_si256` when the data crosses a cache line boundary.",null,null],[5,"_mm256_stream_si256","","Moves integer data from a 256-bit integer vector to a 32-byte aligned memory location. To minimize caching, the data is flagged as non-temporal (unlikely to be used again soon)",null,null],[5,"_mm256_stream_pd","","Moves double-precision values from a 256-bit vector of `[4 x double]` to a 32-byte aligned memory location. To minimize caching, the data is flagged as non-temporal (unlikely to be used again soon).",null,null],[5,"_mm256_stream_ps","","Moves single-precision floating point values from a 256-bit vector of `[8 x float]` to a 32-byte aligned memory location. To minimize caching, the data is flagged as non-temporal (unlikely to be used again soon).",null,null],[5,"_mm256_rcp_ps","","Compute the approximate reciprocal of packed single-precision (32-bit) floating-point elements in `a`, and return the results. The maximum relative error for this approximation is less than 1.5*2^-12.",null,{"inputs":[{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm256_rsqrt_ps","","Compute the approximate reciprocal square root of packed single-precision (32-bit) floating-point elements in `a`, and return the results. The maximum relative error for this approximation is less than 1.5*2^-12.",null,{"inputs":[{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm256_unpackhi_pd","","Unpack and interleave double-precision (64-bit) floating-point elements from the high half of each 128-bit lane in `a` and `b`.",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"}],"output":{"name":"__m256d"}}],[5,"_mm256_unpackhi_ps","","Unpack and interleave single-precision (32-bit) floating-point elements from the high half of each 128-bit lane in `a` and `b`.",null,{"inputs":[{"name":"__m256"},{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm256_unpacklo_pd","","Unpack and interleave double-precision (64-bit) floating-point elements from the low half of each 128-bit lane in `a` and `b`.",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"}],"output":{"name":"__m256d"}}],[5,"_mm256_unpacklo_ps","","Unpack and interleave single-precision (32-bit) floating-point elements from the low half of each 128-bit lane in `a` and `b`.",null,{"inputs":[{"name":"__m256"},{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm256_testz_si256","","Compute the bitwise AND of 256 bits (representing integer data) in `a` and `b`, and set `ZF` to 1 if the result is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, and set `CF` to 1 if the result is zero, otherwise set `CF` to 0. Return the `ZF` value.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"i32"}}],[5,"_mm256_testc_si256","","Compute the bitwise AND of 256 bits (representing integer data) in `a` and `b`, and set `ZF` to 1 if the result is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, and set `CF` to 1 if the result is zero, otherwise set `CF` to 0. Return the `CF` value.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"i32"}}],[5,"_mm256_testnzc_si256","","Compute the bitwise AND of 256 bits (representing integer data) in `a` and `b`, and set `ZF` to 1 if the result is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, and set `CF` to 1 if the result is zero, otherwise set `CF` to 0. Return 1 if both the `ZF` and `CF` values are zero, otherwise return 0.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"i32"}}],[5,"_mm256_testz_pd","","Compute the bitwise AND of 256 bits (representing double-precision (64-bit) floating-point elements) in `a` and `b`, producing an intermediate 256-bit value, and set `ZF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `ZF` value.",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"}],"output":{"name":"i32"}}],[5,"_mm256_testc_pd","","Compute the bitwise AND of 256 bits (representing double-precision (64-bit) floating-point elements) in `a` and `b`, producing an intermediate 256-bit value, and set `ZF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `CF` value.",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"}],"output":{"name":"i32"}}],[5,"_mm256_testnzc_pd","","Compute the bitwise AND of 256 bits (representing double-precision (64-bit) floating-point elements) in `a` and `b`, producing an intermediate 256-bit value, and set `ZF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return 1 if both the `ZF` and `CF` values are zero, otherwise return 0.",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"}],"output":{"name":"i32"}}],[5,"_mm_testz_pd","","Compute the bitwise AND of 128 bits (representing double-precision (64-bit) floating-point elements) in `a` and `b`, producing an intermediate 128-bit value, and set `ZF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `ZF` value.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"i32"}}],[5,"_mm_testc_pd","","Compute the bitwise AND of 128 bits (representing double-precision (64-bit) floating-point elements) in `a` and `b`, producing an intermediate 128-bit value, and set `ZF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `CF` value.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"i32"}}],[5,"_mm_testnzc_pd","","Compute the bitwise AND of 128 bits (representing double-precision (64-bit) floating-point elements) in `a` and `b`, producing an intermediate 128-bit value, and set `ZF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return 1 if both the `ZF` and `CF` values are zero, otherwise return 0.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"i32"}}],[5,"_mm256_testz_ps","","Compute the bitwise AND of 256 bits (representing single-precision (32-bit) floating-point elements) in `a` and `b`, producing an intermediate 256-bit value, and set `ZF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `ZF` value.",null,{"inputs":[{"name":"__m256"},{"name":"__m256"}],"output":{"name":"i32"}}],[5,"_mm256_testc_ps","","Compute the bitwise AND of 256 bits (representing single-precision (32-bit) floating-point elements) in `a` and `b`, producing an intermediate 256-bit value, and set `ZF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `CF` value.",null,{"inputs":[{"name":"__m256"},{"name":"__m256"}],"output":{"name":"i32"}}],[5,"_mm256_testnzc_ps","","Compute the bitwise AND of 256 bits (representing single-precision (32-bit) floating-point elements) in `a` and `b`, producing an intermediate 256-bit value, and set `ZF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return 1 if both the `ZF` and `CF` values are zero, otherwise return 0.",null,{"inputs":[{"name":"__m256"},{"name":"__m256"}],"output":{"name":"i32"}}],[5,"_mm_testz_ps","","Compute the bitwise AND of 128 bits (representing single-precision (32-bit) floating-point elements) in `a` and `b`, producing an intermediate 128-bit value, and set `ZF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `ZF` value.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"i32"}}],[5,"_mm_testc_ps","","Compute the bitwise AND of 128 bits (representing single-precision (32-bit) floating-point elements) in `a` and `b`, producing an intermediate 128-bit value, and set `ZF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `CF` value.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"i32"}}],[5,"_mm_testnzc_ps","","Compute the bitwise AND of 128 bits (representing single-precision (32-bit) floating-point elements) in `a` and `b`, producing an intermediate 128-bit value, and set `ZF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return 1 if both the `ZF` and `CF` values are zero, otherwise return 0.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"i32"}}],[5,"_mm256_movemask_pd","","Set each bit of the returned mask based on the most significant bit of the corresponding packed double-precision (64-bit) floating-point element in `a`.",null,{"inputs":[{"name":"__m256d"}],"output":{"name":"i32"}}],[5,"_mm256_movemask_ps","","Set each bit of the returned mask based on the most significant bit of the corresponding packed single-precision (32-bit) floating-point element in `a`.",null,{"inputs":[{"name":"__m256"}],"output":{"name":"i32"}}],[5,"_mm256_setzero_pd","","Return vector of type __m256d with all elements set to zero.",null,{"inputs":[],"output":{"name":"__m256d"}}],[5,"_mm256_setzero_ps","","Return vector of type __m256 with all elements set to zero.",null,{"inputs":[],"output":{"name":"__m256"}}],[5,"_mm256_setzero_si256","","Return vector of type __m256i with all elements set to zero.",null,{"inputs":[],"output":{"name":"__m256i"}}],[5,"_mm256_set_pd","","Set packed double-precision (64-bit) floating-point elements in returned vector with the supplied values.",null,{"inputs":[{"name":"f64"},{"name":"f64"},{"name":"f64"},{"name":"f64"}],"output":{"name":"__m256d"}}],[5,"_mm256_set_ps","","Set packed single-precision (32-bit) floating-point elements in returned vector with the supplied values.",null,{"inputs":[{"name":"f32"},{"name":"f32"},{"name":"f32"},{"name":"f32"},{"name":"f32"},{"name":"f32"},{"name":"f32"},{"name":"f32"}],"output":{"name":"__m256"}}],[5,"_mm256_set_epi8","","Set packed 8-bit integers in returned vector with the supplied values in reverse order.",null,{"inputs":[{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"}],"output":{"name":"__m256i"}}],[5,"_mm256_set_epi16","","Set packed 16-bit integers in returned vector with the supplied values.",null,{"inputs":[{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"}],"output":{"name":"__m256i"}}],[5,"_mm256_set_epi32","","Set packed 32-bit integers in returned vector with the supplied values.",null,{"inputs":[{"name":"i32"},{"name":"i32"},{"name":"i32"},{"name":"i32"},{"name":"i32"},{"name":"i32"},{"name":"i32"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm256_set_epi64x","","Set packed 64-bit integers in returned vector with the supplied values.",null,{"inputs":[{"name":"i64"},{"name":"i64"},{"name":"i64"},{"name":"i64"}],"output":{"name":"__m256i"}}],[5,"_mm256_setr_pd","","Set packed double-precision (64-bit) floating-point elements in returned vector with the supplied values in reverse order.",null,{"inputs":[{"name":"f64"},{"name":"f64"},{"name":"f64"},{"name":"f64"}],"output":{"name":"__m256d"}}],[5,"_mm256_setr_ps","","Set packed single-precision (32-bit) floating-point elements in returned vector with the supplied values in reverse order.",null,{"inputs":[{"name":"f32"},{"name":"f32"},{"name":"f32"},{"name":"f32"},{"name":"f32"},{"name":"f32"},{"name":"f32"},{"name":"f32"}],"output":{"name":"__m256"}}],[5,"_mm256_setr_epi8","","Set packed 8-bit integers in returned vector with the supplied values in reverse order.",null,{"inputs":[{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"}],"output":{"name":"__m256i"}}],[5,"_mm256_setr_epi16","","Set packed 16-bit integers in returned vector with the supplied values in reverse order.",null,{"inputs":[{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"}],"output":{"name":"__m256i"}}],[5,"_mm256_setr_epi32","","Set packed 32-bit integers in returned vector with the supplied values in reverse order.",null,{"inputs":[{"name":"i32"},{"name":"i32"},{"name":"i32"},{"name":"i32"},{"name":"i32"},{"name":"i32"},{"name":"i32"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm256_setr_epi64x","","Set packed 64-bit integers in returned vector with the supplied values in reverse order.",null,{"inputs":[{"name":"i64"},{"name":"i64"},{"name":"i64"},{"name":"i64"}],"output":{"name":"__m256i"}}],[5,"_mm256_set1_pd","","Broadcast double-precision (64-bit) floating-point value `a` to all elements of returned vector.",null,{"inputs":[{"name":"f64"}],"output":{"name":"__m256d"}}],[5,"_mm256_set1_ps","","Broadcast single-precision (32-bit) floating-point value `a` to all elements of returned vector.",null,{"inputs":[{"name":"f32"}],"output":{"name":"__m256"}}],[5,"_mm256_set1_epi8","","Broadcast 8-bit integer `a` to all elements of returned vector. This intrinsic may generate the `vpbroadcastb`.",null,{"inputs":[{"name":"i8"}],"output":{"name":"__m256i"}}],[5,"_mm256_set1_epi16","","Broadcast 16-bit integer `a` to all all elements of returned vector. This intrinsic may generate the `vpbroadcastw`.",null,{"inputs":[{"name":"i16"}],"output":{"name":"__m256i"}}],[5,"_mm256_set1_epi32","","Broadcast 32-bit integer `a` to all elements of returned vector. This intrinsic may generate the `vpbroadcastd`.",null,{"inputs":[{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm256_set1_epi64x","","Broadcast 64-bit integer `a` to all elements of returned vector. This intrinsic may generate the `vpbroadcastq`.",null,{"inputs":[{"name":"i64"}],"output":{"name":"__m256i"}}],[5,"_mm256_castpd_ps","","Cast vector of type __m256d to type __m256.",null,{"inputs":[{"name":"__m256d"}],"output":{"name":"__m256"}}],[5,"_mm256_castps_pd","","Cast vector of type __m256 to type __m256d.",null,{"inputs":[{"name":"__m256"}],"output":{"name":"__m256d"}}],[5,"_mm256_castps_si256","","Casts vector of type __m256 to type __m256i.",null,{"inputs":[{"name":"__m256"}],"output":{"name":"__m256i"}}],[5,"_mm256_castsi256_ps","","Casts vector of type __m256i to type __m256.",null,{"inputs":[{"name":"__m256i"}],"output":{"name":"__m256"}}],[5,"_mm256_castpd_si256","","Casts vector of type __m256d to type __m256i.",null,{"inputs":[{"name":"__m256d"}],"output":{"name":"__m256i"}}],[5,"_mm256_castsi256_pd","","Casts vector of type __m256i to type __m256d.",null,{"inputs":[{"name":"__m256i"}],"output":{"name":"__m256d"}}],[5,"_mm256_castps256_ps128","","Casts vector of type __m256 to type __m128.",null,{"inputs":[{"name":"__m256"}],"output":{"name":"__m128"}}],[5,"_mm256_castpd256_pd128","","Casts vector of type __m256d to type __m128d.",null,{"inputs":[{"name":"__m256d"}],"output":{"name":"__m128d"}}],[5,"_mm256_castsi256_si128","","Casts vector of type __m256i to type __m128i.",null,{"inputs":[{"name":"__m256i"}],"output":{"name":"__m128i"}}],[5,"_mm256_castps128_ps256","","Casts vector of type __m128 to type __m256; the upper 128 bits of the result are undefined.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"__m256"}}],[5,"_mm256_castpd128_pd256","","Casts vector of type __m128d to type __m256d; the upper 128 bits of the result are undefined.",null,{"inputs":[{"name":"__m128d"}],"output":{"name":"__m256d"}}],[5,"_mm256_castsi128_si256","","Casts vector of type __m128i to type __m256i; the upper 128 bits of the result are undefined.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm256_zextps128_ps256","","Constructs a 256-bit floating-point vector of `[8 x float]` from a 128-bit floating-point vector of `[4 x float]`. The lower 128 bits contain the value of the source vector. The upper 128 bits are set to zero.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"__m256"}}],[5,"_mm256_zextsi128_si256","","Constructs a 256-bit integer vector from a 128-bit integer vector. The lower 128 bits contain the value of the source vector. The upper 128 bits are set to zero.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm256_zextpd128_pd256","","Constructs a 256-bit floating-point vector of `[4 x double]` from a 128-bit floating-point vector of `[2 x double]`. The lower 128 bits contain the value of the source vector. The upper 128 bits are set to zero.",null,{"inputs":[{"name":"__m128d"}],"output":{"name":"__m256d"}}],[5,"_mm256_undefined_ps","","Return vector of type `__m256` with undefined elements.",null,{"inputs":[],"output":{"name":"__m256"}}],[5,"_mm256_undefined_pd","","Return vector of type `__m256d` with undefined elements.",null,{"inputs":[],"output":{"name":"__m256d"}}],[5,"_mm256_undefined_si256","","Return vector of type __m256i with undefined elements.",null,{"inputs":[],"output":{"name":"__m256i"}}],[5,"_mm256_set_m128","","Set packed __m256 returned vector with the supplied values.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m256"}}],[5,"_mm256_set_m128d","","Set packed __m256d returned vector with the supplied values.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m256d"}}],[5,"_mm256_set_m128i","","Set packed __m256i returned vector with the supplied values.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm256_setr_m128","","Set packed __m256 returned vector with the supplied values.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m256"}}],[5,"_mm256_setr_m128d","","Set packed __m256d returned vector with the supplied values.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m256d"}}],[5,"_mm256_setr_m128i","","Set packed __m256i returned vector with the supplied values.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm256_loadu2_m128","","Load two 128-bit values (composed of 4 packed single-precision (32-bit) floating-point elements) from memory, and combine them into a 256-bit value. `hiaddr` and `loaddr` do not need to be aligned on any particular boundary.",null,null],[5,"_mm256_loadu2_m128d","","Load two 128-bit values (composed of 2 packed double-precision (64-bit) floating-point elements) from memory, and combine them into a 256-bit value. `hiaddr` and `loaddr` do not need to be aligned on any particular boundary.",null,null],[5,"_mm256_loadu2_m128i","","Load two 128-bit values (composed of integer data) from memory, and combine them into a 256-bit value. `hiaddr` and `loaddr` do not need to be aligned on any particular boundary.",null,null],[5,"_mm256_storeu2_m128","","Store the high and low 128-bit halves (each composed of 4 packed single-precision (32-bit) floating-point elements) from `a` into memory two different 128-bit locations. `hiaddr` and `loaddr` do not need to be aligned on any particular boundary.",null,null],[5,"_mm256_storeu2_m128d","","Store the high and low 128-bit halves (each composed of 2 packed double-precision (64-bit) floating-point elements) from `a` into memory two different 128-bit locations. `hiaddr` and `loaddr` do not need to be aligned on any particular boundary.",null,null],[5,"_mm256_storeu2_m128i","","Store the high and low 128-bit halves (each composed of integer data) from `a` into memory two different 128-bit locations. `hiaddr` and `loaddr` do not need to be aligned on any particular boundary.",null,null],[5,"_mm256_cvtss_f32","","Returns the first element of the input vector of `[8 x float]`.",null,{"inputs":[{"name":"__m256"}],"output":{"name":"f32"}}],[5,"_mm256_abs_epi32","","Computes the absolute values of packed 32-bit integers in `a`.",null,{"inputs":[{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_abs_epi16","","Computes the absolute values of packed 16-bit integers in `a`.",null,{"inputs":[{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_abs_epi8","","Computes the absolute values of packed 8-bit integers in `a`.",null,{"inputs":[{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_add_epi64","","Add packed 64-bit integers in `a` and `b`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_add_epi32","","Add packed 32-bit integers in `a` and `b`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_add_epi16","","Add packed 16-bit integers in `a` and `b`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_add_epi8","","Add packed 8-bit integers in `a` and `b`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_adds_epi8","","Add packed 8-bit integers in `a` and `b` using saturation.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_adds_epi16","","Add packed 16-bit integers in `a` and `b` using saturation.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_adds_epu8","","Add packed unsigned 8-bit integers in `a` and `b` using saturation.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_adds_epu16","","Add packed unsigned 16-bit integers in `a` and `b` using saturation.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_alignr_epi8","","Concatenate pairs of 16-byte blocks in `a` and `b` into a 32-byte temporary result, shift the result right by `n` bytes, and return the low 16 bytes.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm256_and_si256","","Compute the bitwise AND of 256 bits (representing integer data) in `a` and `b`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_andnot_si256","","Compute the bitwise NOT of 256 bits (representing integer data) in `a` and then AND with `b`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_avg_epu16","","Average packed unsigned 16-bit integers in `a` and `b`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_avg_epu8","","Average packed unsigned 8-bit integers in `a` and `b`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm_blend_epi32","","Blend packed 32-bit integers from `a` and `b` using control mask `imm8`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm256_blend_epi32","","Blend packed 32-bit integers from `a` and `b` using control mask `imm8`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm256_blend_epi16","","Blend packed 16-bit integers from `a` and `b` using control mask `imm8`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm256_blendv_epi8","","Blend packed 8-bit integers from `a` and `b` using `mask`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm_broadcastb_epi8","","Broadcast the low packed 8-bit integer from `a` to all elements of the 128-bit returned value.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm256_broadcastb_epi8","","Broadcast the low packed 8-bit integer from `a` to all elements of the 256-bit returned value.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm_broadcastd_epi32","","Broadcast the low packed 32-bit integer from `a` to all elements of the 128-bit returned value.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm256_broadcastd_epi32","","Broadcast the low packed 32-bit integer from `a` to all elements of the 256-bit returned value.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm_broadcastq_epi64","","Broadcast the low packed 64-bit integer from `a` to all elements of the 128-bit returned value.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm256_broadcastq_epi64","","Broadcast the low packed 64-bit integer from `a` to all elements of the 256-bit returned value.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm_broadcastsd_pd","","Broadcast the low double-precision (64-bit) floating-point element from `a` to all elements of the 128-bit returned value.",null,{"inputs":[{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm256_broadcastsd_pd","","Broadcast the low double-precision (64-bit) floating-point element from `a` to all elements of the 256-bit returned value.",null,{"inputs":[{"name":"__m128d"}],"output":{"name":"__m256d"}}],[5,"_mm256_broadcastsi128_si256","","Broadcast 128 bits of integer data from a to all 128-bit lanes in the 256-bit returned value.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm_broadcastss_ps","","Broadcast the low single-precision (32-bit) floating-point element from `a` to all elements of the 128-bit returned value.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm256_broadcastss_ps","","Broadcast the low single-precision (32-bit) floating-point element from `a` to all elements of the 256-bit returned value.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"__m256"}}],[5,"_mm_broadcastw_epi16","","Broadcast the low packed 16-bit integer from a to all elements of the 128-bit returned value",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm256_broadcastw_epi16","","Broadcast the low packed 16-bit integer from a to all elements of the 256-bit returned value",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm256_cmpeq_epi64","","Compare packed 64-bit integers in `a` and `b` for equality.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_cmpeq_epi32","","Compare packed 32-bit integers in `a` and `b` for equality.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_cmpeq_epi16","","Compare packed 16-bit integers in `a` and `b` for equality.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_cmpeq_epi8","","Compare packed 8-bit integers in `a` and `b` for equality.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_cmpgt_epi64","","Compare packed 64-bit integers in `a` and `b` for greater-than.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_cmpgt_epi32","","Compare packed 32-bit integers in `a` and `b` for greater-than.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_cmpgt_epi16","","Compare packed 16-bit integers in `a` and `b` for greater-than.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_cmpgt_epi8","","Compare packed 8-bit integers in `a` and `b` for greater-than.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_cvtepi16_epi32","","Sign-extend 16-bit integers to 32-bit integers.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm256_cvtepi16_epi64","","Sign-extend 16-bit integers to 64-bit integers.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm256_cvtepi32_epi64","","Sign-extend 32-bit integers to 64-bit integers.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm256_cvtepi8_epi16","","Sign-extend 8-bit integers to 16-bit integers.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm256_cvtepi8_epi32","","Sign-extend 8-bit integers to 32-bit integers.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm256_cvtepi8_epi64","","Sign-extend 8-bit integers to 64-bit integers.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm256_cvtepu16_epi32","","Zero extend packed unsigned 16-bit integers in `a` to packed 32-bit integers, and store the results in dst.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm256_cvtepu16_epi64","","Zero-extend the lower four unsigned 16-bit integers in `a` to 64-bit integers. The upper four elements of `a` are unused.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm256_cvtepu32_epi64","","Zero-extend unsigned 32-bit integers in `a` to 64-bit integers.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm256_cvtepu8_epi16","","Zero-extend unsigned 8-bit integers in `a` to 16-bit integers.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm256_cvtepu8_epi32","","Zero-extend the lower eight unsigned 8-bit integers in `a` to 32-bit integers. The upper eight elements of `a` are unused.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm256_cvtepu8_epi64","","Zero-extend the lower four unsigned 8-bit integers in `a` to 64-bit integers. The upper twelve elements of `a` are unused.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm256_extracti128_si256","","Extract 128 bits (of integer data) from `a` selected with `imm8`.",null,{"inputs":[{"name":"__m256i"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm256_hadd_epi16","","Horizontally add adjacent pairs of 16-bit integers in `a` and `b`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_hadd_epi32","","Horizontally add adjacent pairs of 32-bit integers in `a` and `b`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_hadds_epi16","","Horizontally add adjacent pairs of 16-bit integers in `a` and `b` using saturation.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_hsub_epi16","","Horizontally subtract adjacent pairs of 16-bit integers in `a` and `b`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_hsub_epi32","","Horizontally subtract adjacent pairs of 32-bit integers in `a` and `b`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_hsubs_epi16","","Horizontally subtract adjacent pairs of 16-bit integers in `a` and `b` using saturation.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm_i32gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm_mask_i32gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm256_i32gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm256_mask_i32gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm_i32gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm_mask_i32gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm256_i32gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm256_mask_i32gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm_i32gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm_mask_i32gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm256_i32gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm256_mask_i32gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm_i32gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm_mask_i32gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm256_i32gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm256_mask_i32gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm_i64gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm_mask_i64gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm256_i64gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm256_mask_i64gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm_i64gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm_mask_i64gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm256_i64gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm256_mask_i64gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm_i64gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm_mask_i64gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm256_i64gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm256_mask_i64gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm_i64gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm_mask_i64gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm256_i64gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm256_mask_i64gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm256_inserti128_si256","","Copy `a` to `dst`, then insert 128 bits (of integer data) from `b` at the location specified by `imm8`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m128i"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm256_madd_epi16","","Multiply packed signed 16-bit integers in `a` and `b`, producing intermediate signed 32-bit integers. Horizontally add adjacent pairs of intermediate 32-bit integers.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_maddubs_epi16","","Vertically multiply each unsigned 8-bit integer from `a` with the corresponding signed 8-bit integer from `b`, producing intermediate signed 16-bit integers. Horizontally add adjacent pairs of intermediate signed 16-bit integers",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm_maskload_epi32","","Load packed 32-bit integers from memory pointed by `mem_addr` using `mask` (elements are zeroed out when the highest bit is not set in the corresponding element).",null,null],[5,"_mm256_maskload_epi32","","Load packed 32-bit integers from memory pointed by `mem_addr` using `mask` (elements are zeroed out when the highest bit is not set in the corresponding element).",null,null],[5,"_mm_maskload_epi64","","Load packed 64-bit integers from memory pointed by `mem_addr` using `mask` (elements are zeroed out when the highest bit is not set in the corresponding element).",null,null],[5,"_mm256_maskload_epi64","","Load packed 64-bit integers from memory pointed by `mem_addr` using `mask` (elements are zeroed out when the highest bit is not set in the corresponding element).",null,null],[5,"_mm_maskstore_epi32","","Store packed 32-bit integers from `a` into memory pointed by `mem_addr` using `mask` (elements are not stored when the highest bit is not set in the corresponding element).",null,null],[5,"_mm256_maskstore_epi32","","Store packed 32-bit integers from `a` into memory pointed by `mem_addr` using `mask` (elements are not stored when the highest bit is not set in the corresponding element).",null,null],[5,"_mm_maskstore_epi64","","Store packed 64-bit integers from `a` into memory pointed by `mem_addr` using `mask` (elements are not stored when the highest bit is not set in the corresponding element).",null,null],[5,"_mm256_maskstore_epi64","","Store packed 64-bit integers from `a` into memory pointed by `mem_addr` using `mask` (elements are not stored when the highest bit is not set in the corresponding element).",null,null],[5,"_mm256_max_epi16","","Compare packed 16-bit integers in `a` and `b`, and return the packed maximum values.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_max_epi32","","Compare packed 32-bit integers in `a` and `b`, and return the packed maximum values.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_max_epi8","","Compare packed 8-bit integers in `a` and `b`, and return the packed maximum values.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_max_epu16","","Compare packed unsigned 16-bit integers in `a` and `b`, and return the packed maximum values.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_max_epu32","","Compare packed unsigned 32-bit integers in `a` and `b`, and return the packed maximum values.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_max_epu8","","Compare packed unsigned 8-bit integers in `a` and `b`, and return the packed maximum values.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_min_epi16","","Compare packed 16-bit integers in `a` and `b`, and return the packed minimum values.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_min_epi32","","Compare packed 32-bit integers in `a` and `b`, and return the packed minimum values.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_min_epi8","","Compare packed 8-bit integers in `a` and `b`, and return the packed minimum values.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_min_epu16","","Compare packed unsigned 16-bit integers in `a` and `b`, and return the packed minimum values.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_min_epu32","","Compare packed unsigned 32-bit integers in `a` and `b`, and return the packed minimum values.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_min_epu8","","Compare packed unsigned 8-bit integers in `a` and `b`, and return the packed minimum values.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_movemask_epi8","","Create mask from the most significant bit of each 8-bit element in `a`, return the result.",null,{"inputs":[{"name":"__m256i"}],"output":{"name":"i32"}}],[5,"_mm256_mpsadbw_epu8","","Compute the sum of absolute differences (SADs) of quadruplets of unsigned 8-bit integers in `a` compared to those in `b`, and store the 16-bit results in dst. Eight SADs are performed for each 128-bit lane using one quadruplet from `b` and eight quadruplets from `a`. One quadruplet is selected from `b` starting at on the offset specified in `imm8`. Eight quadruplets are formed from sequential 8-bit integers selected from `a` starting at the offset specified in `imm8`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm256_mul_epi32","","Multiply the low 32-bit integers from each packed 64-bit element in `a` and `b`",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_mul_epu32","","Multiply the low unsigned 32-bit integers from each packed 64-bit element in `a` and `b`",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_mulhi_epi16","","Multiply the packed 16-bit integers in `a` and `b`, producing intermediate 32-bit integers and returning the high 16 bits of the intermediate integers.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_mulhi_epu16","","Multiply the packed unsigned 16-bit integers in `a` and `b`, producing intermediate 32-bit integers and returning the high 16 bits of the intermediate integers.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_mullo_epi16","","Multiply the packed 16-bit integers in `a` and `b`, producing intermediate 32-bit integers, and return the low 16 bits of the intermediate integers",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_mullo_epi32","","Multiply the packed 32-bit integers in `a` and `b`, producing intermediate 64-bit integers, and return the low 16 bits of the intermediate integers",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_mulhrs_epi16","","Multiply packed 16-bit integers in `a` and `b`, producing intermediate signed 32-bit integers. Truncate each intermediate integer to the 18 most significant bits, round by adding 1, and return bits `[16:1]`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_or_si256","","Compute the bitwise OR of 256 bits (representing integer data) in `a` and `b`",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_packs_epi16","","Convert packed 16-bit integers from `a` and `b` to packed 8-bit integers using signed saturation",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_packs_epi32","","Convert packed 32-bit integers from `a` and `b` to packed 16-bit integers using signed saturation",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_packus_epi16","","Convert packed 16-bit integers from `a` and `b` to packed 8-bit integers using unsigned saturation",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_packus_epi32","","Convert packed 32-bit integers from `a` and `b` to packed 16-bit integers using unsigned saturation",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_permutevar8x32_epi32","","Permutes packed 32-bit integers from `a` according to the content of `b`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_permute4x64_epi64","","Permutes 64-bit integers from `a` using control mask `imm8`.",null,{"inputs":[{"name":"__m256i"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm256_permute2x128_si256","","Shuffle 128-bits of integer data selected by `imm8` from `a` and `b`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm256_permute4x64_pd","","Shuffle 64-bit floating-point elements in `a` across lanes using the control in `imm8`.",null,{"inputs":[{"name":"__m256d"},{"name":"i32"}],"output":{"name":"__m256d"}}],[5,"_mm256_permutevar8x32_ps","","Shuffle eight 32-bit foating-point elements in `a` across lanes using the corresponding 32-bit integer index in `idx`.",null,{"inputs":[{"name":"__m256"},{"name":"__m256i"}],"output":{"name":"__m256"}}],[5,"_mm256_sad_epu8","","Compute the absolute differences of packed unsigned 8-bit integers in `a` and `b`, then horizontally sum each consecutive 8 differences to produce four unsigned 16-bit integers, and pack these unsigned 16-bit integers in the low 16 bits of the 64-bit return value",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_shuffle_epi8","","Shuffle bytes from `a` according to the content of `b`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_shuffle_epi32","","Shuffle 32-bit integers in 128-bit lanes of `a` using the control in `imm8`.",null,{"inputs":[{"name":"__m256i"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm256_shufflehi_epi16","","Shuffle 16-bit integers in the high 64 bits of 128-bit lanes of `a` using the control in `imm8`. The low 64 bits of 128-bit lanes of `a` are copied to the output.",null,{"inputs":[{"name":"__m256i"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm256_shufflelo_epi16","","Shuffle 16-bit integers in the low 64 bits of 128-bit lanes of `a` using the control in `imm8`. The high 64 bits of 128-bit lanes of `a` are copied to the output.",null,{"inputs":[{"name":"__m256i"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm256_sign_epi16","","Negate packed 16-bit integers in `a` when the corresponding signed 16-bit integer in `b` is negative, and return the results. Results are zeroed out when the corresponding element in `b` is zero.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_sign_epi32","","Negate packed 32-bit integers in `a` when the corresponding signed 32-bit integer in `b` is negative, and return the results. Results are zeroed out when the corresponding element in `b` is zero.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_sign_epi8","","Negate packed 8-bit integers in `a` when the corresponding signed 8-bit integer in `b` is negative, and return the results. Results are zeroed out when the corresponding element in `b` is zero.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_sll_epi16","","Shift packed 16-bit integers in `a` left by `count` while shifting in zeros, and return the result",null,{"inputs":[{"name":"__m256i"},{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm256_sll_epi32","","Shift packed 32-bit integers in `a` left by `count` while shifting in zeros, and return the result",null,{"inputs":[{"name":"__m256i"},{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm256_sll_epi64","","Shift packed 64-bit integers in `a` left by `count` while shifting in zeros, and return the result",null,{"inputs":[{"name":"__m256i"},{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm256_slli_epi16","","Shift packed 16-bit integers in `a` left by `imm8` while shifting in zeros, return the results;",null,{"inputs":[{"name":"__m256i"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm256_slli_epi32","","Shift packed 32-bit integers in `a` left by `imm8` while shifting in zeros, return the results;",null,{"inputs":[{"name":"__m256i"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm256_slli_epi64","","Shift packed 64-bit integers in `a` left by `imm8` while shifting in zeros, return the results;",null,{"inputs":[{"name":"__m256i"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm256_slli_si256","","Shift 128-bit lanes in `a` left by `imm8` bytes while shifting in zeros.",null,{"inputs":[{"name":"__m256i"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm256_bslli_epi128","","Shift 128-bit lanes in `a` left by `imm8` bytes while shifting in zeros.",null,{"inputs":[{"name":"__m256i"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm_sllv_epi32","","Shift packed 32-bit integers in `a` left by the amount specified by the corresponding element in `count` while shifting in zeros, and return the result.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm256_sllv_epi32","","Shift packed 32-bit integers in `a` left by the amount specified by the corresponding element in `count` while shifting in zeros, and return the result.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm_sllv_epi64","","Shift packed 64-bit integers in `a` left by the amount specified by the corresponding element in `count` while shifting in zeros, and return the result.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm256_sllv_epi64","","Shift packed 64-bit integers in `a` left by the amount specified by the corresponding element in `count` while shifting in zeros, and return the result.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_sra_epi16","","Shift packed 16-bit integers in `a` right by `count` while shifting in sign bits.",null,{"inputs":[{"name":"__m256i"},{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm256_sra_epi32","","Shift packed 32-bit integers in `a` right by `count` while shifting in sign bits.",null,{"inputs":[{"name":"__m256i"},{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm256_srai_epi16","","Shift packed 16-bit integers in `a` right by `imm8` while shifting in sign bits.",null,{"inputs":[{"name":"__m256i"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm256_srai_epi32","","Shift packed 32-bit integers in `a` right by `imm8` while shifting in sign bits.",null,{"inputs":[{"name":"__m256i"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm_srav_epi32","","Shift packed 32-bit integers in `a` right by the amount specified by the corresponding element in `count` while shifting in sign bits.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm256_srav_epi32","","Shift packed 32-bit integers in `a` right by the amount specified by the corresponding element in `count` while shifting in sign bits.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_srli_si256","","Shift 128-bit lanes in `a` right by `imm8` bytes while shifting in zeros.",null,{"inputs":[{"name":"__m256i"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm256_bsrli_epi128","","Shift 128-bit lanes in `a` right by `imm8` bytes while shifting in zeros.",null,{"inputs":[{"name":"__m256i"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm256_srl_epi16","","Shift packed 16-bit integers in `a` right by `count` while shifting in zeros.",null,{"inputs":[{"name":"__m256i"},{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm256_srl_epi32","","Shift packed 32-bit integers in `a` right by `count` while shifting in zeros.",null,{"inputs":[{"name":"__m256i"},{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm256_srl_epi64","","Shift packed 64-bit integers in `a` right by `count` while shifting in zeros.",null,{"inputs":[{"name":"__m256i"},{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm256_srli_epi16","","Shift packed 16-bit integers in `a` right by `imm8` while shifting in zeros",null,{"inputs":[{"name":"__m256i"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm256_srli_epi32","","Shift packed 32-bit integers in `a` right by `imm8` while shifting in zeros",null,{"inputs":[{"name":"__m256i"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm256_srli_epi64","","Shift packed 64-bit integers in `a` right by `imm8` while shifting in zeros",null,{"inputs":[{"name":"__m256i"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm_srlv_epi32","","Shift packed 32-bit integers in `a` right by the amount specified by the corresponding element in `count` while shifting in zeros,",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm256_srlv_epi32","","Shift packed 32-bit integers in `a` right by the amount specified by the corresponding element in `count` while shifting in zeros,",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm_srlv_epi64","","Shift packed 64-bit integers in `a` right by the amount specified by the corresponding element in `count` while shifting in zeros,",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm256_srlv_epi64","","Shift packed 64-bit integers in `a` right by the amount specified by the corresponding element in `count` while shifting in zeros,",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_sub_epi16","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a`",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_sub_epi32","","Subtract packed 32-bit integers in `b` from packed 16-bit integers in `a`",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_sub_epi64","","Subtract packed 64-bit integers in `b` from packed 16-bit integers in `a`",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_sub_epi8","","Subtract packed 8-bit integers in `b` from packed 16-bit integers in `a`",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_subs_epi16","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a` using saturation.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_subs_epi8","","Subtract packed 8-bit integers in `b` from packed 8-bit integers in `a` using saturation.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_subs_epu16","","Subtract packed unsigned 16-bit integers in `b` from packed 16-bit integers in `a` using saturation.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_subs_epu8","","Subtract packed unsigned 8-bit integers in `b` from packed 8-bit integers in `a` using saturation.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_unpackhi_epi8","","Unpack and interleave 8-bit integers from the high half of each 128-bit lane in `a` and `b`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_unpacklo_epi8","","Unpack and interleave 8-bit integers from the low half of each 128-bit lane of `a` and `b`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_unpackhi_epi16","","Unpack and interleave 16-bit integers from the high half of each 128-bit lane of `a` and `b`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_unpacklo_epi16","","Unpack and interleave 16-bit integers from the low half of each 128-bit lane of `a` and `b`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_unpackhi_epi32","","Unpack and interleave 32-bit integers from the high half of each 128-bit lane of `a` and `b`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_unpacklo_epi32","","Unpack and interleave 32-bit integers from the low half of each 128-bit lane of `a` and `b`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_unpackhi_epi64","","Unpack and interleave 64-bit integers from the high half of each 128-bit lane of `a` and `b`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_unpacklo_epi64","","Unpack and interleave 64-bit integers from the low half of each 128-bit lane of `a` and `b`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_xor_si256","","Compute the bitwise XOR of 256 bits (representing integer data) in `a` and `b`",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_extract_epi8","","Extract an 8-bit integer from `a`, selected with `imm8`. Returns a 32-bit integer containing the zero-extended integer data.",null,{"inputs":[{"name":"__m256i"},{"name":"i32"}],"output":{"name":"i8"}}],[5,"_mm256_extract_epi16","","Extract a 16-bit integer from `a`, selected with `imm8`. Returns a 32-bit integer containing the zero-extended integer data.",null,{"inputs":[{"name":"__m256i"},{"name":"i32"}],"output":{"name":"i16"}}],[5,"_mm256_extract_epi32","","Extract a 32-bit integer from `a`, selected with `imm8`.",null,{"inputs":[{"name":"__m256i"},{"name":"i32"}],"output":{"name":"i32"}}],[5,"_mm256_cvtsd_f64","","Returns the first element of the input vector of `[4 x double]`.",null,{"inputs":[{"name":"__m256d"}],"output":{"name":"f64"}}],[5,"_mm256_cvtsi256_si32","","Returns the first element of the input vector of `[8 x i32]`.",null,{"inputs":[{"name":"__m256i"}],"output":{"name":"i32"}}],[5,"_mm_fmadd_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and add the intermediate result to packed elements in `c`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm256_fmadd_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and add the intermediate result to packed elements in `c`.",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"},{"name":"__m256d"}],"output":{"name":"__m256d"}}],[5,"_mm_fmadd_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and add the intermediate result to packed elements in `c`.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm256_fmadd_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and add the intermediate result to packed elements in `c`.",null,{"inputs":[{"name":"__m256"},{"name":"__m256"},{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm_fmadd_sd","","Multiply the lower double-precision (64-bit) floating-point elements in `a` and `b`, and add the intermediate result to the lower element in `c`. Store the result in the lower element of the returned value, and copy the upper element from `a` to the upper elements of the result.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_fmadd_ss","","Multiply the lower single-precision (32-bit) floating-point elements in `a` and `b`, and add the intermediate result to the lower element in `c`. Store the result in the lower element of the returned value, and copy the 3 upper elements from `a` to the upper elements of the result.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_fmaddsub_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and alternatively add and subtract packed elements in `c` to/from the intermediate result.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm256_fmaddsub_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and alternatively add and subtract packed elements in `c` to/from the intermediate result.",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"},{"name":"__m256d"}],"output":{"name":"__m256d"}}],[5,"_mm_fmaddsub_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and alternatively add and subtract packed elements in `c` to/from the intermediate result.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm256_fmaddsub_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and alternatively add and subtract packed elements in `c` to/from the intermediate result.",null,{"inputs":[{"name":"__m256"},{"name":"__m256"},{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm_fmsub_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the intermediate result.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm256_fmsub_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the intermediate result.",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"},{"name":"__m256d"}],"output":{"name":"__m256d"}}],[5,"_mm_fmsub_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the intermediate result.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm256_fmsub_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the intermediate result.",null,{"inputs":[{"name":"__m256"},{"name":"__m256"},{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm_fmsub_sd","","Multiply the lower double-precision (64-bit) floating-point elements in `a` and `b`, and subtract the lower element in `c` from the intermediate result. Store the result in the lower element of the returned value, and copy the upper element from `a` to the upper elements of the result.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_fmsub_ss","","Multiply the lower single-precision (32-bit) floating-point elements in `a` and `b`,  and subtract the lower element in `c` from the intermediate result. Store the result in the lower element of the returned value, and copy the 3 upper elements from `a` to the upper elements of the result.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_fmsubadd_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and alternatively subtract and add packed elements in `c` from/to the intermediate result.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm256_fmsubadd_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and alternatively subtract and add packed elements in `c` from/to the intermediate result.",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"},{"name":"__m256d"}],"output":{"name":"__m256d"}}],[5,"_mm_fmsubadd_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and alternatively subtract and add packed elements in `c` from/to the intermediate result.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm256_fmsubadd_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and alternatively subtract and add packed elements in `c` from/to the intermediate result.",null,{"inputs":[{"name":"__m256"},{"name":"__m256"},{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm_fnmadd_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and add the negated intermediate result to packed elements in `c`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm256_fnmadd_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and add the negated intermediate result to packed elements in `c`.",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"},{"name":"__m256d"}],"output":{"name":"__m256d"}}],[5,"_mm_fnmadd_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and add the negated intermediate result to packed elements in `c`.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm256_fnmadd_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and add the negated intermediate result to packed elements in `c`.",null,{"inputs":[{"name":"__m256"},{"name":"__m256"},{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm_fnmadd_sd","","Multiply the lower double-precision (64-bit) floating-point elements in `a` and `b`, and add the negated intermediate result to the lower element in `c`. Store the result in the lower element of the returned value, and copy the upper element from `a` to the upper elements of the result.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_fnmadd_ss","","Multiply the lower single-precision (32-bit) floating-point elements in `a` and `b`, and add the negated intermediate result to the lower element in `c`. Store the result in the lower element of the returned value, and copy the 3 upper elements from `a` to the upper elements of the result.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_fnmsub_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the negated intermediate result.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm256_fnmsub_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the negated intermediate result.",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"},{"name":"__m256d"}],"output":{"name":"__m256d"}}],[5,"_mm_fnmsub_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the negated intermediate result.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm256_fnmsub_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the negated intermediate result.",null,{"inputs":[{"name":"__m256"},{"name":"__m256"},{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm_fnmsub_sd","","Multiply the lower double-precision (64-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the negated intermediate result. Store the result in the lower element of the returned value, and copy the upper element from `a` to the upper elements of the result.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_fnmsub_ss","","Multiply the lower single-precision (32-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the negated intermediate result. Store the result in the lower element of the returned value, and copy the 3 upper elements from `a` to the upper elements of the result.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_lzcnt_u32","","Counts the leading most significant zero bits.",null,{"inputs":[{"name":"u32"}],"output":{"name":"u32"}}],[5,"_popcnt32","","Counts the bits that are set.",null,{"inputs":[{"name":"i32"}],"output":{"name":"i32"}}],[5,"_bextr_u32","","Extracts bits in range [`start`, `start` + `length`) from `a` into the least significant bits of the result.",null,{"inputs":[{"name":"u32"},{"name":"u32"},{"name":"u32"}],"output":{"name":"u32"}}],[5,"_bextr2_u32","","Extracts bits of `a` specified by `control` into the least significant bits of the result.",null,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"u32"}}],[5,"_andn_u32","","Bitwise logical `AND` of inverted `a` with `b`.",null,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"u32"}}],[5,"_blsi_u32","","Extract lowest set isolated bit.",null,{"inputs":[{"name":"u32"}],"output":{"name":"u32"}}],[5,"_blsmsk_u32","","Get mask up to lowest set bit.",null,{"inputs":[{"name":"u32"}],"output":{"name":"u32"}}],[5,"_blsr_u32","","Resets the lowest set bit of `x`.",null,{"inputs":[{"name":"u32"}],"output":{"name":"u32"}}],[5,"_tzcnt_u32","","Counts the number of trailing least significant zero bits.",null,{"inputs":[{"name":"u32"}],"output":{"name":"u32"}}],[5,"_mm_tzcnt_32","","Counts the number of trailing least significant zero bits.",null,{"inputs":[{"name":"u32"}],"output":{"name":"i32"}}],[5,"_mulx_u32","","Unsigned multiply without affecting flags.",null,{"inputs":[{"name":"u32"},{"name":"u32"},{"name":"u32"}],"output":{"name":"u32"}}],[5,"_bzhi_u32","","Zero higher bits of `a` >= `index`.",null,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"u32"}}],[5,"_pdep_u32","","Scatter contiguous low order bits of `a` to the result at the positions specified by the `mask`.",null,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"u32"}}],[5,"_pext_u32","","Gathers the bits of `x` specified by the `mask` into the contiguous low order bit positions of the result.",null,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"u32"}}],[5,"_mm_extract_si64","","Extracts the bit range specified by `y` from the lower 64 bits of `x`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_insert_si64","","Inserts the `[length:0]` bits of `y` into `x` at `index`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_stream_sd","","Non-temporal store of `a.0` into `p`.",null,null],[5,"_mm_stream_ss","","Non-temporal store of `a.0` into `p`.",null,null],[5,"_blcfill_u32","","Clears all bits below the least significant zero bit of `x`.",null,{"inputs":[{"name":"u32"}],"output":{"name":"u32"}}],[5,"_blcfill_u64","","Clears all bits below the least significant zero bit of `x`.",null,{"inputs":[{"name":"u64"}],"output":{"name":"u64"}}],[5,"_blci_u32","","Sets all bits of `x` to 1 except for the least significant zero bit.",null,{"inputs":[{"name":"u32"}],"output":{"name":"u32"}}],[5,"_blci_u64","","Sets all bits of `x` to 1 except for the least significant zero bit.",null,{"inputs":[{"name":"u64"}],"output":{"name":"u64"}}],[5,"_blcic_u32","","Sets the least significant zero bit of `x` and clears all other bits.",null,{"inputs":[{"name":"u32"}],"output":{"name":"u32"}}],[5,"_blcic_u64","","Sets the least significant zero bit of `x` and clears all other bits.",null,{"inputs":[{"name":"u64"}],"output":{"name":"u64"}}],[5,"_blcmsk_u32","","Sets the least significant zero bit of `x` and clears all bits above that bit.",null,{"inputs":[{"name":"u32"}],"output":{"name":"u32"}}],[5,"_blcmsk_u64","","Sets the least significant zero bit of `x` and clears all bits above that bit.",null,{"inputs":[{"name":"u64"}],"output":{"name":"u64"}}],[5,"_blcs_u32","","Sets the least significant zero bit of `x`.",null,{"inputs":[{"name":"u32"}],"output":{"name":"u32"}}],[5,"_blcs_u64","","Sets the least significant zero bit of `x`.",null,{"inputs":[{"name":"u64"}],"output":{"name":"u64"}}],[5,"_blsfill_u32","","Sets all bits of `x` below the least significant one.",null,{"inputs":[{"name":"u32"}],"output":{"name":"u32"}}],[5,"_blsfill_u64","","Sets all bits of `x` below the least significant one.",null,{"inputs":[{"name":"u64"}],"output":{"name":"u64"}}],[5,"_blsic_u32","","Clears least significant bit and sets all other bits.",null,{"inputs":[{"name":"u32"}],"output":{"name":"u32"}}],[5,"_blsic_u64","","Clears least significant bit and sets all other bits.",null,{"inputs":[{"name":"u64"}],"output":{"name":"u64"}}],[5,"_t1mskc_u32","","Clears all bits below the least significant zero of `x` and sets all other bits.",null,{"inputs":[{"name":"u32"}],"output":{"name":"u32"}}],[5,"_t1mskc_u64","","Clears all bits below the least significant zero of `x` and sets all other bits.",null,{"inputs":[{"name":"u64"}],"output":{"name":"u64"}}],[5,"_tzmsk_u32","","Sets all bits below the least significant one of `x` and clears all other bits.",null,{"inputs":[{"name":"u32"}],"output":{"name":"u32"}}],[5,"_tzmsk_u64","","Sets all bits below the least significant one of `x` and clears all other bits.",null,{"inputs":[{"name":"u64"}],"output":{"name":"u64"}}],[5,"_mm_setzero_si64","","Constructs a 64-bit integer vector initialized to zero.",null,{"inputs":[],"output":{"name":"__m64"}}],[5,"_mm_add_pi8","","Add packed 8-bit integers in `a` and `b`.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_m_paddb","","Add packed 8-bit integers in `a` and `b`.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_add_pi16","","Add packed 16-bit integers in `a` and `b`.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_m_paddw","","Add packed 16-bit integers in `a` and `b`.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_add_pi32","","Add packed 32-bit integers in `a` and `b`.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_m_paddd","","Add packed 32-bit integers in `a` and `b`.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_adds_pi8","","Add packed 8-bit integers in `a` and `b` using saturation.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_m_paddsb","","Add packed 8-bit integers in `a` and `b` using saturation.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_adds_pi16","","Add packed 16-bit integers in `a` and `b` using saturation.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_m_paddsw","","Add packed 16-bit integers in `a` and `b` using saturation.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_adds_pu8","","Add packed unsigned 8-bit integers in `a` and `b` using saturation.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_m_paddusb","","Add packed unsigned 8-bit integers in `a` and `b` using saturation.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_adds_pu16","","Add packed unsigned 16-bit integers in `a` and `b` using saturation.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_m_paddusw","","Add packed unsigned 16-bit integers in `a` and `b` using saturation.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_sub_pi8","","Subtract packed 8-bit integers in `b` from packed 8-bit integers in `a`.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_m_psubb","","Subtract packed 8-bit integers in `b` from packed 8-bit integers in `a`.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_sub_pi16","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a`.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_m_psubw","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a`.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_sub_pi32","","Subtract packed 32-bit integers in `b` from packed 32-bit integers in `a`.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_m_psubd","","Subtract packed 32-bit integers in `b` from packed 32-bit integers in `a`.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_subs_pi8","","Subtract packed 8-bit integers in `b` from packed 8-bit integers in `a` using saturation.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_m_psubsb","","Subtract packed 8-bit integers in `b` from packed 8-bit integers in `a` using saturation.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_subs_pi16","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a` using saturation.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_m_psubsw","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a` using saturation.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_subs_pu8","","Subtract packed unsigned 8-bit integers in `b` from packed unsigned 8-bit integers in `a` using saturation.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_m_psubusb","","Subtract packed unsigned 8-bit integers in `b` from packed unsigned 8-bit integers in `a` using saturation.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_subs_pu16","","Subtract packed unsigned 16-bit integers in `b` from packed unsigned 16-bit integers in `a` using saturation.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_m_psubusw","","Subtract packed unsigned 16-bit integers in `b` from packed unsigned 16-bit integers in `a` using saturation.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_packs_pi16","","Convert packed 16-bit integers from `a` and `b` to packed 8-bit integers using signed saturation.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_packs_pi32","","Convert packed 32-bit integers from `a` and `b` to packed 16-bit integers using signed saturation.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_cmpgt_pi8","","Compares whether each element of `a` is greater than the corresponding element of `b` returning `0` for `false` and `-1` for `true`.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_cmpgt_pi16","","Compares whether each element of `a` is greater than the corresponding element of `b` returning `0` for `false` and `-1` for `true`.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_cmpgt_pi32","","Compares whether each element of `a` is greater than the corresponding element of `b` returning `0` for `false` and `-1` for `true`.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_unpackhi_pi16","","Unpacks the upper two elements from two `i16x4` vectors and interleaves them into the result: `[a.2, b.2, a.3, b.3]`.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_unpackhi_pi8","","Unpacks the upper four elements from two `i8x8` vectors and interleaves them into the result: `[a.4, b.4, a.5, b.5, a.6, b.6, a.7, b.7]`.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_unpacklo_pi8","","Unpacks the lower four elements from two `i8x8` vectors and interleaves them into the result: `[a.0, b.0, a.1, b.1, a.2, b.2, a.3, b.3]`.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_unpacklo_pi16","","Unpacks the lower two elements from two `i16x4` vectors and interleaves them into the result: `[a.0 b.0 a.1 b.1]`.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_unpackhi_pi32","","Unpacks the upper element from two `i32x2` vectors and interleaves them into the result: `[a.1, b.1]`.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_unpacklo_pi32","","Unpacks the lower element from two `i32x2` vectors and interleaves them into the result: `[a.0, b.0]`.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_set_pi16","","Set packed 16-bit integers in dst with the supplied values.",null,{"inputs":[{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"}],"output":{"name":"__m64"}}],[5,"_mm_set_pi32","","Set packed 32-bit integers in dst with the supplied values.",null,{"inputs":[{"name":"i32"},{"name":"i32"}],"output":{"name":"__m64"}}],[5,"_mm_set_pi8","","Set packed 8-bit integers in dst with the supplied values.",null,{"inputs":[{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"}],"output":{"name":"__m64"}}],[5,"_mm_set1_pi16","","Broadcast 16-bit integer a to all all elements of dst.",null,{"inputs":[{"name":"i16"}],"output":{"name":"__m64"}}],[5,"_mm_set1_pi32","","Broadcast 32-bit integer a to all all elements of dst.",null,{"inputs":[{"name":"i32"}],"output":{"name":"__m64"}}],[5,"_mm_set1_pi8","","Broadcast 8-bit integer a to all all elements of dst.",null,{"inputs":[{"name":"i8"}],"output":{"name":"__m64"}}],[5,"_mm_setr_pi16","","Set packed 16-bit integers in dst with the supplied values in reverse order.",null,{"inputs":[{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"}],"output":{"name":"__m64"}}],[5,"_mm_setr_pi32","","Set packed 32-bit integers in dst with the supplied values in reverse order.",null,{"inputs":[{"name":"i32"},{"name":"i32"}],"output":{"name":"__m64"}}],[5,"_mm_setr_pi8","","Set packed 8-bit integers in dst with the supplied values in reverse order.",null,{"inputs":[{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"}],"output":{"name":"__m64"}}],[5,"_mm_clmulepi64_si128","","Perform a carry-less multiplication of two 64-bit polynomials over the finite field GF(2^k).",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_aesdec_si128","","Perform one round of an AES decryption flow on data (state) in `a`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_aesdeclast_si128","","Perform the last round of an AES decryption flow on data (state) in `a`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_aesenc_si128","","Perform one round of an AES encryption flow on data (state) in `a`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_aesenclast_si128","","Perform the last round of an AES encryption flow on data (state) in `a`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_aesimc_si128","","Perform the `InvMixColumns` transformation on `a`.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_aeskeygenassist_si128","","Assist in expanding the AES cipher key.",null,{"inputs":[{"name":"__m128i"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_rdrand16_step","","Read a hardware generated 16-bit random value and store the result in val. Return 1 if a random value was generated, and 0 otherwise.",null,{"inputs":[{"name":"u16"}],"output":{"name":"i32"}}],[5,"_rdrand32_step","","Read a hardware generated 32-bit random value and store the result in val. Return 1 if a random value was generated, and 0 otherwise.",null,{"inputs":[{"name":"u32"}],"output":{"name":"i32"}}],[5,"_rdseed16_step","","Read a 16-bit NIST SP800-90B and SP800-90C compliant random value and store in val. Return 1 if a random value was generated, and 0 otherwise.",null,{"inputs":[{"name":"u16"}],"output":{"name":"i32"}}],[5,"_rdseed32_step","","Read a 32-bit NIST SP800-90B and SP800-90C compliant random value and store in val. Return 1 if a random value was generated, and 0 otherwise.",null,{"inputs":[{"name":"u32"}],"output":{"name":"i32"}}],[5,"_mm_sha1msg1_epu32","","Perform an intermediate calculation for the next four SHA1 message values (unsigned 32-bit integers) using previous message values from `a` and `b`, and returning the result.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_sha1msg2_epu32","","Perform the final calculation for the next four SHA1 message values (unsigned 32-bit integers) using the intermediate result in `a` and the previous message values in `b`, and returns the result.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_sha1nexte_epu32","","Calculate SHA1 state variable E after four rounds of operation from the current SHA1 state variable `a`, add that value to the scheduled values (unsigned 32-bit integers) in `b`, and returns the result.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_sha1rnds4_epu32","","Perform four rounds of SHA1 operation using an initial SHA1 state (A,B,C,D) from `a` and some pre-computed sum of the next 4 round message values (unsigned 32-bit integers), and state variable E from `b`, and return the updated SHA1 state (A,B,C,D). `func` contains the logic functions and round constants.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_sha256msg1_epu32","","Perform an intermediate calculation for the next four SHA256 message values (unsigned 32-bit integers) using previous message values from `a` and `b`, and return the result.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_sha256msg2_epu32","","Perform the final calculation for the next four SHA256 message values (unsigned 32-bit integers) using previous message values from `a` and `b`, and return the result.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_sha256rnds2_epu32","","Perform 2 rounds of SHA256 operation using an initial SHA256 state (C,D,G,H) from `a`, an initial SHA256 state (A,B,E,F) from `b`, and a pre-computed sum of the next 2 round message values (unsigned 32-bit integers) and the corresponding round constants from `k`, and store the updated SHA256 state (A,B,E,F) in dst.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[17,"_XCR_XFEATURE_ENABLED_MASK","","`XFEATURE_ENABLED_MASK` for `XCR`",null,null],[17,"_MM_EXCEPT_INVALID","","See `_mm_setcsr`",null,null],[17,"_MM_EXCEPT_DENORM","","See `_mm_setcsr`",null,null],[17,"_MM_EXCEPT_DIV_ZERO","","See `_mm_setcsr`",null,null],[17,"_MM_EXCEPT_OVERFLOW","","See `_mm_setcsr`",null,null],[17,"_MM_EXCEPT_UNDERFLOW","","See `_mm_setcsr`",null,null],[17,"_MM_EXCEPT_INEXACT","","See `_mm_setcsr`",null,null],[17,"_MM_EXCEPT_MASK","","See `_MM_GET_EXCEPTION_STATE`",null,null],[17,"_MM_MASK_INVALID","","See `_mm_setcsr`",null,null],[17,"_MM_MASK_DENORM","","See `_mm_setcsr`",null,null],[17,"_MM_MASK_DIV_ZERO","","See `_mm_setcsr`",null,null],[17,"_MM_MASK_OVERFLOW","","See `_mm_setcsr`",null,null],[17,"_MM_MASK_UNDERFLOW","","See `_mm_setcsr`",null,null],[17,"_MM_MASK_INEXACT","","See `_mm_setcsr`",null,null],[17,"_MM_MASK_MASK","","See `_MM_GET_EXCEPTION_MASK`",null,null],[17,"_MM_ROUND_NEAREST","","See `_mm_setcsr`",null,null],[17,"_MM_ROUND_DOWN","","See `_mm_setcsr`",null,null],[17,"_MM_ROUND_UP","","See `_mm_setcsr`",null,null],[17,"_MM_ROUND_TOWARD_ZERO","","See `_mm_setcsr`",null,null],[17,"_MM_ROUND_MASK","","See `_MM_GET_ROUNDING_MODE`",null,null],[17,"_MM_FLUSH_ZERO_MASK","","See `_MM_GET_FLUSH_ZERO_MODE`",null,null],[17,"_MM_FLUSH_ZERO_ON","","See `_mm_setcsr`",null,null],[17,"_MM_FLUSH_ZERO_OFF","","See `_mm_setcsr`",null,null],[17,"_MM_HINT_T0","","See `_mm_prefetch`.",null,null],[17,"_MM_HINT_T1","","See `_mm_prefetch`.",null,null],[17,"_MM_HINT_T2","","See `_mm_prefetch`.",null,null],[17,"_MM_HINT_NTA","","See `_mm_prefetch`.",null,null],[17,"_MM_FROUND_TO_NEAREST_INT","","round to nearest",null,null],[17,"_MM_FROUND_TO_NEG_INF","","round down",null,null],[17,"_MM_FROUND_TO_POS_INF","","round up",null,null],[17,"_MM_FROUND_TO_ZERO","","truncate",null,null],[17,"_MM_FROUND_CUR_DIRECTION","","use MXCSR.RC; see `vendor::_MM_SET_ROUNDING_MODE`",null,null],[17,"_MM_FROUND_RAISE_EXC","","do not suppress exceptions",null,null],[17,"_MM_FROUND_NO_EXC","","suppress exceptions",null,null],[17,"_MM_FROUND_NINT","","round to nearest and do not suppress exceptions",null,null],[17,"_MM_FROUND_FLOOR","","round down and do not suppress exceptions",null,null],[17,"_MM_FROUND_CEIL","","round up and do not suppress exceptions",null,null],[17,"_MM_FROUND_TRUNC","","truncate and do not suppress exceptions",null,null],[17,"_MM_FROUND_RINT","","use MXCSR.RC and do not suppress exceptions; see `vendor::_MM_SET_ROUNDING_MODE`",null,null],[17,"_MM_FROUND_NEARBYINT","","use MXCSR.RC and suppress exceptions; see `vendor::_MM_SET_ROUNDING_MODE`",null,null],[17,"_SIDD_UBYTE_OPS","","String contains unsigned 8-bit characters (Default)",null,null],[17,"_SIDD_UWORD_OPS","","String contains unsigned 16-bit characters",null,null],[17,"_SIDD_SBYTE_OPS","","String contains signed 8-bit characters",null,null],[17,"_SIDD_SWORD_OPS","","String contains unsigned 16-bit characters",null,null],[17,"_SIDD_CMP_EQUAL_ANY","","For each character in `a`, find if it is in `b` (Default)",null,null],[17,"_SIDD_CMP_RANGES","","For each character in `a`, determine if `b[0] <= c <= b[1] or b[1] <= c <= b[2]...`",null,null],[17,"_SIDD_CMP_EQUAL_EACH","","The strings defined by `a` and `b` are equal",null,null],[17,"_SIDD_CMP_EQUAL_ORDERED","","Search for the defined substring in the target",null,null],[17,"_SIDD_POSITIVE_POLARITY","","Do not negate results (Default)",null,null],[17,"_SIDD_NEGATIVE_POLARITY","","Negate results",null,null],[17,"_SIDD_MASKED_POSITIVE_POLARITY","","Do not negate results before the end of the string",null,null],[17,"_SIDD_MASKED_NEGATIVE_POLARITY","","Negate results only before the end of the string",null,null],[17,"_SIDD_LEAST_SIGNIFICANT","","Index only: return the least significant bit (Default)",null,null],[17,"_SIDD_MOST_SIGNIFICANT","","Index only: return the most significant bit",null,null],[17,"_SIDD_BIT_MASK","","Mask only: return the bit mask",null,null],[17,"_SIDD_UNIT_MASK","","Mask only: return the byte mask",null,null],[17,"_CMP_EQ_OQ","","Equal (ordered, non-signaling)",null,null],[17,"_CMP_LT_OS","","Less-than (ordered, signaling)",null,null],[17,"_CMP_LE_OS","","Less-than-or-equal (ordered, signaling)",null,null],[17,"_CMP_UNORD_Q","","Unordered (non-signaling)",null,null],[17,"_CMP_NEQ_UQ","","Not-equal (unordered, non-signaling)",null,null],[17,"_CMP_NLT_US","","Not-less-than (unordered, signaling)",null,null],[17,"_CMP_NLE_US","","Not-less-than-or-equal (unordered, signaling)",null,null],[17,"_CMP_ORD_Q","","Ordered (non-signaling)",null,null],[17,"_CMP_EQ_UQ","","Equal (unordered, non-signaling)",null,null],[17,"_CMP_NGE_US","","Not-greater-than-or-equal (unordered, signaling)",null,null],[17,"_CMP_NGT_US","","Not-greater-than (unordered, signaling)",null,null],[17,"_CMP_FALSE_OQ","","False (ordered, non-signaling)",null,null],[17,"_CMP_NEQ_OQ","","Not-equal (ordered, non-signaling)",null,null],[17,"_CMP_GE_OS","","Greater-than-or-equal (ordered, signaling)",null,null],[17,"_CMP_GT_OS","","Greater-than (ordered, signaling)",null,null],[17,"_CMP_TRUE_UQ","","True (unordered, non-signaling)",null,null],[17,"_CMP_EQ_OS","","Equal (ordered, signaling)",null,null],[17,"_CMP_LT_OQ","","Less-than (ordered, non-signaling)",null,null],[17,"_CMP_LE_OQ","","Less-than-or-equal (ordered, non-signaling)",null,null],[17,"_CMP_UNORD_S","","Unordered (signaling)",null,null],[17,"_CMP_NEQ_US","","Not-equal (unordered, signaling)",null,null],[17,"_CMP_NLT_UQ","","Not-less-than (unordered, non-signaling)",null,null],[17,"_CMP_NLE_UQ","","Not-less-than-or-equal (unordered, non-signaling)",null,null],[17,"_CMP_ORD_S","","Ordered (signaling)",null,null],[17,"_CMP_EQ_US","","Equal (unordered, signaling)",null,null],[17,"_CMP_NGE_UQ","","Not-greater-than-or-equal (unordered, non-signaling)",null,null],[17,"_CMP_NGT_UQ","","Not-greater-than (unordered, non-signaling)",null,null],[17,"_CMP_FALSE_OS","","False (ordered, signaling)",null,null],[17,"_CMP_NEQ_OS","","Not-equal (ordered, signaling)",null,null],[17,"_CMP_GE_OQ","","Greater-than-or-equal (ordered, non-signaling)",null,null],[17,"_CMP_GT_OQ","","Greater-than (ordered, non-signaling)",null,null],[17,"_CMP_TRUE_US","","True (unordered, signaling)",null,null],[0,"x86_64","core::arch","Platform-specific intrinsics for the `x86_64` platform.",null,null],[3,"__m64","core::arch::x86_64","64-bit wide integer vector type, x86-specific",null,null],[3,"__m128i","","128-bit wide integer vector type, x86-specific",null,null],[3,"__m128","","128-bit wide set of four `f32` types, x86-specific",null,null],[3,"__m128d","","128-bit wide set of two `f64` types, x86-specific",null,null],[3,"__m256i","","256-bit wide integer vector type, x86-specific",null,null],[3,"__m256","","256-bit wide set of eight `f32` types, x86-specific",null,null],[3,"__m256d","","256-bit wide set of four `f64` types, x86-specific",null,null],[3,"CpuidResult","","Result of the `cpuid` instruction.",null,null],[12,"eax","","EAX register.",245,null],[12,"ebx","","EBX register.",245,null],[12,"ecx","","ECX register.",245,null],[12,"edx","","EDX register.",245,null],[5,"__readeflags","","Reads EFLAGS.",null,{"inputs":[],"output":{"name":"u64"}}],[5,"__writeeflags","","Write EFLAGS.",null,{"inputs":[{"name":"u64"}],"output":null}],[5,"_fxsave","","Saves the `x87` FPU, `MMX` technology, `XMM`, and `MXCSR` registers to the 512-byte-long 16-byte-aligned memory region `mem_addr`.",null,null],[5,"_fxrstor","","Restores the `XMM`, `MMX`, `MXCSR`, and `x87` FPU registers from the 512-byte-long 16-byte-aligned memory region `mem_addr`.",null,null],[5,"_bswap","","Return an integer with the reversed byte order of x",null,{"inputs":[{"name":"i32"}],"output":{"name":"i32"}}],[5,"_rdtsc","","Reads the current value of the processor’s time-stamp counter.",null,{"inputs":[],"output":{"name":"i64"}}],[5,"__rdtscp","","Reads the current value of the processor’s time-stamp counter and the `IA32_TSC_AUX MSR`.",null,null],[5,"__cpuid_count","","Returns the result of the `cpuid` instruction for a given `leaf` (`EAX`) and `sub_leaf` (`ECX`).",null,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"cpuidresult"}}],[5,"__cpuid","","See `__cpuid_count`.",null,{"inputs":[{"name":"u32"}],"output":{"name":"cpuidresult"}}],[5,"has_cpuid","","Does the host support the `cpuid` instruction?",null,{"inputs":[],"output":{"name":"bool"}}],[5,"__get_cpuid_max","","Returns the highest-supported `leaf` (`EAX`) and sub-leaf (`ECX`) `cpuid` values.",null,null],[5,"_xsave","","Perform a full or partial save of the enabled processor states to memory at `mem_addr`.",null,null],[5,"_xrstor","","Perform a full or partial restore of the enabled processor states using the state information stored in memory at `mem_addr`.",null,null],[5,"_xsetbv","","Copy 64-bits from `val` to the extended control register (`XCR`) specified by `a`.",null,{"inputs":[{"name":"u32"},{"name":"u64"}],"output":null}],[5,"_xgetbv","","Reads the contents of the extended control register `XCR` specified in `xcr_no`.",null,{"inputs":[{"name":"u32"}],"output":{"name":"u64"}}],[5,"_xsaveopt","","Perform a full or partial save of the enabled processor states to memory at `mem_addr`.",null,null],[5,"_xsavec","","Perform a full or partial save of the enabled processor states to memory at `mem_addr`.",null,null],[5,"_xsaves","","Perform a full or partial save of the enabled processor states to memory at `mem_addr`",null,null],[5,"_xrstors","","Perform a full or partial restore of the enabled processor states using the state information stored in memory at `mem_addr`.",null,null],[5,"_mm_add_ss","","Adds the first component of `a` and `b`, the other components are copied from `a`.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_add_ps","","Adds __m128 vectors.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_sub_ss","","Subtracts the first component of `b` from `a`, the other components are copied from `a`.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_sub_ps","","Subtracts __m128 vectors.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_mul_ss","","Multiplies the first component of `a` and `b`, the other components are copied from `a`.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_mul_ps","","Multiplies __m128 vectors.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_div_ss","","Divides the first component of `b` by `a`, the other components are copied from `a`.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_div_ps","","Divides __m128 vectors.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_sqrt_ss","","Return the square root of the first single-precision (32-bit) floating-point element in `a`, the other elements are unchanged.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_sqrt_ps","","Return the square root of packed single-precision (32-bit) floating-point elements in `a`.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_rcp_ss","","Return the approximate reciprocal of the first single-precision (32-bit) floating-point element in `a`, the other elements are unchanged.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_rcp_ps","","Return the approximate reciprocal of packed single-precision (32-bit) floating-point elements in `a`.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_rsqrt_ss","","Return the approximate reciprocal square root of the fist single-precision (32-bit) floating-point elements in `a`, the other elements are unchanged.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_rsqrt_ps","","Return the approximate reciprocal square root of packed single-precision (32-bit) floating-point elements in `a`.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_min_ss","","Compare the first single-precision (32-bit) floating-point element of `a` and `b`, and return the minimum value in the first element of the return value, the other elements are copied from `a`.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_min_ps","","Compare packed single-precision (32-bit) floating-point elements in `a` and `b`, and return the corresponding minimum values.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_max_ss","","Compare the first single-precision (32-bit) floating-point element of `a` and `b`, and return the maximum value in the first element of the return value, the other elements are copied from `a`.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_max_ps","","Compare packed single-precision (32-bit) floating-point elements in `a` and `b`, and return the corresponding maximum values.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_and_ps","","Bitwise AND of packed single-precision (32-bit) floating-point elements.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_andnot_ps","","Bitwise AND-NOT of packed single-precision (32-bit) floating-point elements.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_or_ps","","Bitwise OR of packed single-precision (32-bit) floating-point elements.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_xor_ps","","Bitwise exclusive OR of packed single-precision (32-bit) floating-point elements.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_cmpeq_ss","","Compare the lowest `f32` of both inputs for equality. The lowest 32 bits of the result will be `0xffffffff` if the two inputs are equal, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_cmplt_ss","","Compare the lowest `f32` of both inputs for less than. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is less than `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_cmple_ss","","Compare the lowest `f32` of both inputs for less than or equal. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is less than or equal `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_cmpgt_ss","","Compare the lowest `f32` of both inputs for greater than. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is greater than `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_cmpge_ss","","Compare the lowest `f32` of both inputs for greater than or equal. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is greater than or equal `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_cmpneq_ss","","Compare the lowest `f32` of both inputs for inequality. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is not equal to `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_cmpnlt_ss","","Compare the lowest `f32` of both inputs for not-less-than. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is not less than `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_cmpnle_ss","","Compare the lowest `f32` of both inputs for not-less-than-or-equal. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is not less than or equal to `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_cmpngt_ss","","Compare the lowest `f32` of both inputs for not-greater-than. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is not greater than `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_cmpnge_ss","","Compare the lowest `f32` of both inputs for not-greater-than-or-equal. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is not greater than or equal to `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_cmpord_ss","","Check if the lowest `f32` of both inputs are ordered. The lowest 32 bits of the result will be `0xffffffff` if neither of `a.extract(0)` or `b.extract(0)` is a NaN, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_cmpunord_ss","","Check if the lowest `f32` of both inputs are unordered. The lowest 32 bits of the result will be `0xffffffff` if any of `a.extract(0)` or `b.extract(0)` is a NaN, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_cmpeq_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input elements were equal, or `0` otherwise.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_cmplt_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is less than the corresponding element in `b`, or `0` otherwise.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_cmple_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is less than or equal to the corresponding element in `b`, or `0` otherwise.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_cmpgt_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is greater than the corresponding element in `b`, or `0` otherwise.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_cmpge_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is greater than or equal to the corresponding element in `b`, or `0` otherwise.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_cmpneq_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input elements are not equal, or `0` otherwise.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_cmpnlt_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is not less than the corresponding element in `b`, or `0` otherwise.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_cmpnle_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is not less than or equal to the corresponding element in `b`, or `0` otherwise.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_cmpngt_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is not greater than the corresponding element in `b`, or `0` otherwise.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_cmpnge_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is not greater than or equal to the corresponding element in `b`, or `0` otherwise.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_cmpord_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. Returns four floats that have one of two possible bit patterns. The element in the output vector will be `0xffffffff` if the input elements in `a` and `b` are ordered (i.e., neither of them is a NaN), or 0 otherwise.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_cmpunord_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. Returns four floats that have one of two possible bit patterns. The element in the output vector will be `0xffffffff` if the input elements in `a` and `b` are unordered (i.e., at least on of them is a NaN), or 0 otherwise.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_comieq_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if they are equal, or `0` otherwise.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"i32"}}],[5,"_mm_comilt_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is less than the one from `b`, or `0` otherwise.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"i32"}}],[5,"_mm_comile_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is less than or equal to the one from `b`, or `0` otherwise.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"i32"}}],[5,"_mm_comigt_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is greater than the one from `b`, or `0` otherwise.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"i32"}}],[5,"_mm_comige_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is greater than or equal to the one from `b`, or `0` otherwise.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"i32"}}],[5,"_mm_comineq_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if they are not equal, or `0` otherwise.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"i32"}}],[5,"_mm_ucomieq_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if they are equal, or `0` otherwise. This instruction will not signal an exception if either argument is a quiet NaN.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"i32"}}],[5,"_mm_ucomilt_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is less than the one from `b`, or `0` otherwise. This instruction will not signal an exception if either argument is a quiet NaN.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"i32"}}],[5,"_mm_ucomile_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is less than or equal to the one from `b`, or `0` otherwise. This instruction will not signal an exception if either argument is a quiet NaN.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"i32"}}],[5,"_mm_ucomigt_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is greater than the one from `b`, or `0` otherwise. This instruction will not signal an exception if either argument is a quiet NaN.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"i32"}}],[5,"_mm_ucomige_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is greater than or equal to the one from `b`, or `0` otherwise. This instruction will not signal an exception if either argument is a quiet NaN.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"i32"}}],[5,"_mm_ucomineq_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if they are not equal, or `0` otherwise. This instruction will not signal an exception if either argument is a quiet NaN.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"i32"}}],[5,"_mm_cvtss_si32","","Convert the lowest 32 bit float in the input vector to a 32 bit integer.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"i32"}}],[5,"_mm_cvt_ss2si","","Alias for `_mm_cvtss_si32`.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"i32"}}],[5,"_mm_cvttss_si32","","Convert the lowest 32 bit float in the input vector to a 32 bit integer with truncation.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"i32"}}],[5,"_mm_cvtt_ss2si","","Alias for `_mm_cvttss_si32`.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"i32"}}],[5,"_mm_cvtss_f32","","Extract the lowest 32 bit float from the input vector.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"f32"}}],[5,"_mm_cvtsi32_ss","","Convert a 32 bit integer to a 32 bit float. The result vector is the input vector `a` with the lowest 32 bit float replaced by the converted integer.",null,{"inputs":[{"name":"__m128"},{"name":"i32"}],"output":{"name":"__m128"}}],[5,"_mm_cvt_si2ss","","Alias for `_mm_cvtsi32_ss`.",null,{"inputs":[{"name":"__m128"},{"name":"i32"}],"output":{"name":"__m128"}}],[5,"_mm_set_ss","","Construct a `__m128` with the lowest element set to `a` and the rest set to zero.",null,{"inputs":[{"name":"f32"}],"output":{"name":"__m128"}}],[5,"_mm_set1_ps","","Construct a `__m128` with all element set to `a`.",null,{"inputs":[{"name":"f32"}],"output":{"name":"__m128"}}],[5,"_mm_set_ps1","","Alias for `_mm_set1_ps`",null,{"inputs":[{"name":"f32"}],"output":{"name":"__m128"}}],[5,"_mm_set_ps","","Construct a `__m128` from four floating point values highest to lowest.",null,{"inputs":[{"name":"f32"},{"name":"f32"},{"name":"f32"},{"name":"f32"}],"output":{"name":"__m128"}}],[5,"_mm_setr_ps","","Construct a `__m128` from four floating point values lowest to highest.",null,{"inputs":[{"name":"f32"},{"name":"f32"},{"name":"f32"},{"name":"f32"}],"output":{"name":"__m128"}}],[5,"_mm_setzero_ps","","Construct a `__m128` with all elements initialized to zero.",null,{"inputs":[],"output":{"name":"__m128"}}],[5,"_mm_shuffle_ps","","Shuffle packed single-precision (32-bit) floating-point elements in `a` and `b` using `mask`.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"},{"name":"u32"}],"output":{"name":"__m128"}}],[5,"_mm_unpackhi_ps","","Unpack and interleave single-precision (32-bit) floating-point elements from the higher half of `a` and `b`.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_unpacklo_ps","","Unpack and interleave single-precision (32-bit) floating-point elements from the lower half of `a` and `b`.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_movehl_ps","","Combine higher half of `a` and `b`. The highwe half of `b` occupies the lower half of result.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_movelh_ps","","Combine lower half of `a` and `b`. The lower half of `b` occupies the higher half of result.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_movemask_ps","","Return a mask of the most significant bit of each element in `a`.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"i32"}}],[5,"_mm_loadh_pi","","Set the upper two single-precision floating-point values with 64 bits of data loaded from the address `p`; the lower two values are passed through from `a`.",null,null],[5,"_mm_loadl_pi","","Load two floats from `p` into the lower half of a `__m128`. The upper half is copied from the upper half of `a`.",null,null],[5,"_mm_load_ss","","Construct a `__m128` with the lowest element read from `p` and the other elements set to zero.",null,null],[5,"_mm_load1_ps","","Construct a `__m128` by duplicating the value read from `p` into all elements.",null,null],[5,"_mm_load_ps1","","Alias for `_mm_load1_ps`",null,null],[5,"_mm_load_ps","","Load four `f32` values from aligned memory into a `__m128`. If the pointer is not aligned to a 128-bit boundary (16 bytes) a general protection fault will be triggered (fatal program crash).",null,null],[5,"_mm_loadu_ps","","Load four `f32` values from memory into a `__m128`. There are no restrictions on memory alignment. For aligned memory `_mm_load_ps` may be faster.",null,null],[5,"_mm_loadr_ps","","Load four `f32` values from aligned memory into a `__m128` in reverse order.",null,null],[5,"_mm_storeh_pi","","Store the upper half of `a` (64 bits) into memory.",null,null],[5,"_mm_storel_pi","","Store the lower half of `a` (64 bits) into memory.",null,null],[5,"_mm_store_ss","","Store the lowest 32 bit float of `a` into memory.",null,null],[5,"_mm_store1_ps","","Store the lowest 32 bit float of `a` repeated four times into aligned memory.",null,null],[5,"_mm_store_ps1","","Alias for `_mm_store1_ps`",null,null],[5,"_mm_store_ps","","Store four 32-bit floats into aligned memory.",null,null],[5,"_mm_storeu_ps","","Store four 32-bit floats into memory. There are no restrictions on memory alignment. For aligned memory `_mm_store_ps` may be faster.",null,null],[5,"_mm_storer_ps","","Store four 32-bit floats into aligned memory in reverse order.",null,null],[5,"_mm_move_ss","","Return a `__m128` with the first component from `b` and the remaining components from `a`.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_sfence","","Perform a serializing operation on all store-to-memory instructions that were issued prior to this instruction.",null,{"inputs":[],"output":null}],[5,"_mm_getcsr","","Get the unsigned 32-bit value of the MXCSR control and status register.",null,{"inputs":[],"output":{"name":"u32"}}],[5,"_mm_setcsr","","Set the MXCSR register with the 32-bit unsigned integer value.",null,{"inputs":[{"name":"u32"}],"output":null}],[5,"_MM_GET_EXCEPTION_MASK","","See `_mm_setcsr`",null,{"inputs":[],"output":{"name":"u32"}}],[5,"_MM_GET_EXCEPTION_STATE","","See `_mm_setcsr`",null,{"inputs":[],"output":{"name":"u32"}}],[5,"_MM_GET_FLUSH_ZERO_MODE","","See `_mm_setcsr`",null,{"inputs":[],"output":{"name":"u32"}}],[5,"_MM_GET_ROUNDING_MODE","","See `_mm_setcsr`",null,{"inputs":[],"output":{"name":"u32"}}],[5,"_MM_SET_EXCEPTION_MASK","","See `_mm_setcsr`",null,{"inputs":[{"name":"u32"}],"output":null}],[5,"_MM_SET_EXCEPTION_STATE","","See `_mm_setcsr`",null,{"inputs":[{"name":"u32"}],"output":null}],[5,"_MM_SET_FLUSH_ZERO_MODE","","See `_mm_setcsr`",null,{"inputs":[{"name":"u32"}],"output":null}],[5,"_MM_SET_ROUNDING_MODE","","See `_mm_setcsr`",null,{"inputs":[{"name":"u32"}],"output":null}],[5,"_mm_prefetch","","Fetch the cache line that contains address `p` using the given `strategy`.",null,null],[5,"_mm_undefined_ps","","Return vector of type __m128 with undefined elements.",null,{"inputs":[],"output":{"name":"__m128"}}],[5,"_MM_TRANSPOSE4_PS","","Transpose the 4x4 matrix formed by 4 rows of __m128 in place.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"},{"name":"__m128"},{"name":"__m128"}],"output":null}],[5,"_mm_stream_ps","","Stores `a` into the memory at `mem_addr` using a non-temporal memory hint.",null,null],[5,"_mm_stream_pi","","Store 64-bits of integer data from a into memory using a non-temporal memory hint.",null,null],[5,"_mm_max_pi16","","Compares the packed 16-bit signed integers of `a` and `b` writing the greatest value into the result.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_m_pmaxsw","","Compares the packed 16-bit signed integers of `a` and `b` writing the greatest value into the result.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_max_pu8","","Compares the packed 8-bit signed integers of `a` and `b` writing the greatest value into the result.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_m_pmaxub","","Compares the packed 8-bit signed integers of `a` and `b` writing the greatest value into the result.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_min_pi16","","Compares the packed 16-bit signed integers of `a` and `b` writing the smallest value into the result.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_m_pminsw","","Compares the packed 16-bit signed integers of `a` and `b` writing the smallest value into the result.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_min_pu8","","Compares the packed 8-bit signed integers of `a` and `b` writing the smallest value into the result.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_m_pminub","","Compares the packed 8-bit signed integers of `a` and `b` writing the smallest value into the result.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_mulhi_pu16","","Multiplies packed 16-bit unsigned integer values and writes the high-order 16 bits of each 32-bit product to the corresponding bits in the destination.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_m_pmulhuw","","Multiplies packed 16-bit unsigned integer values and writes the high-order 16 bits of each 32-bit product to the corresponding bits in the destination.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_avg_pu8","","Computes the rounded averages of the packed unsigned 8-bit integer values and writes the averages to the corresponding bits in the destination.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_m_pavgb","","Computes the rounded averages of the packed unsigned 8-bit integer values and writes the averages to the corresponding bits in the destination.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_avg_pu16","","Computes the rounded averages of the packed unsigned 16-bit integer values and writes the averages to the corresponding bits in the destination.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_m_pavgw","","Computes the rounded averages of the packed unsigned 16-bit integer values and writes the averages to the corresponding bits in the destination.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_sad_pu8","","Subtracts the corresponding 8-bit unsigned integer values of the two 64-bit vector operands and computes the absolute value for each of the difference. Then sum of the 8 absolute differences is written to the bits `[15:0]` of the destination; the remaining bits `[63:16]` are cleared.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_m_psadbw","","Subtracts the corresponding 8-bit unsigned integer values of the two 64-bit vector operands and computes the absolute value for each of the difference. Then sum of the 8 absolute differences is written to the bits `[15:0]` of the destination; the remaining bits `[63:16]` are cleared.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_cvtpi32_ps","","Converts two elements of a 64-bit vector of `[2 x i32]` into two floating point values and writes them to the lower 64-bits of the destination. The remaining higher order elements of the destination are copied from the corresponding elements in the first operand.",null,{"inputs":[{"name":"__m128"},{"name":"__m64"}],"output":{"name":"__m128"}}],[5,"_mm_cvt_pi2ps","","Converts two elements of a 64-bit vector of `[2 x i32]` into two floating point values and writes them to the lower 64-bits of the destination. The remaining higher order elements of the destination are copied from the corresponding elements in the first operand.",null,{"inputs":[{"name":"__m128"},{"name":"__m64"}],"output":{"name":"__m128"}}],[5,"_mm_cvtpi8_ps","","Converts the lower 4 8-bit values of `a` into a 128-bit vector of 4 `f32`s.",null,{"inputs":[{"name":"__m64"}],"output":{"name":"__m128"}}],[5,"_mm_cvtpu8_ps","","Converts the lower 4 8-bit values of `a` into a 128-bit vector of 4 `f32`s.",null,{"inputs":[{"name":"__m64"}],"output":{"name":"__m128"}}],[5,"_mm_cvtpi16_ps","","Converts a 64-bit vector of `i16`s into a 128-bit vector of 4 `f32`s.",null,{"inputs":[{"name":"__m64"}],"output":{"name":"__m128"}}],[5,"_mm_cvtpu16_ps","","Converts a 64-bit vector of `i16`s into a 128-bit vector of 4 `f32`s.",null,{"inputs":[{"name":"__m64"}],"output":{"name":"__m128"}}],[5,"_mm_cvtpi32x2_ps","","Converts the two 32-bit signed integer values from each 64-bit vector operand of `[2 x i32]` into a 128-bit vector of `[4 x float]`.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m128"}}],[5,"_mm_maskmove_si64","","Conditionally copies the values from each 8-bit element in the first 64-bit integer vector operand to the specified memory location, as specified by the most significant bit in the corresponding element in the second 64-bit integer vector operand.",null,null],[5,"_m_maskmovq","","Conditionally copies the values from each 8-bit element in the first 64-bit integer vector operand to the specified memory location, as specified by the most significant bit in the corresponding element in the second 64-bit integer vector operand.",null,null],[5,"_mm_extract_pi16","","Extracts 16-bit element from a 64-bit vector of `[4 x i16]` and returns it, as specified by the immediate integer operand.",null,{"inputs":[{"name":"__m64"},{"name":"i32"}],"output":{"name":"i32"}}],[5,"_m_pextrw","","Extracts 16-bit element from a 64-bit vector of `[4 x i16]` and returns it, as specified by the immediate integer operand.",null,{"inputs":[{"name":"__m64"},{"name":"i32"}],"output":{"name":"i32"}}],[5,"_mm_insert_pi16","","Copies data from the 64-bit vector of `[4 x i16]` to the destination, and inserts the lower 16-bits of an integer operand at the 16-bit offset specified by the immediate operand `n`.",null,{"inputs":[{"name":"__m64"},{"name":"i32"},{"name":"i32"}],"output":{"name":"__m64"}}],[5,"_m_pinsrw","","Copies data from the 64-bit vector of `[4 x i16]` to the destination, and inserts the lower 16-bits of an integer operand at the 16-bit offset specified by the immediate operand `n`.",null,{"inputs":[{"name":"__m64"},{"name":"i32"},{"name":"i32"}],"output":{"name":"__m64"}}],[5,"_mm_movemask_pi8","","Takes the most significant bit from each 8-bit element in a 64-bit integer vector to create a 16-bit mask value. Zero-extends the value to 32-bit integer and writes it to the destination.",null,{"inputs":[{"name":"__m64"}],"output":{"name":"i32"}}],[5,"_m_pmovmskb","","Takes the most significant bit from each 8-bit element in a 64-bit integer vector to create a 16-bit mask value. Zero-extends the value to 32-bit integer and writes it to the destination.",null,{"inputs":[{"name":"__m64"}],"output":{"name":"i32"}}],[5,"_mm_shuffle_pi16","","Shuffles the 4 16-bit integers from a 64-bit integer vector to the destination, as specified by the immediate value operand.",null,{"inputs":[{"name":"__m64"},{"name":"i32"}],"output":{"name":"__m64"}}],[5,"_m_pshufw","","Shuffles the 4 16-bit integers from a 64-bit integer vector to the destination, as specified by the immediate value operand.",null,{"inputs":[{"name":"__m64"},{"name":"i32"}],"output":{"name":"__m64"}}],[5,"_mm_cvttps_pi32","","Convert the two lower packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers with truncation.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"__m64"}}],[5,"_mm_cvtt_ps2pi","","Convert the two lower packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers with truncation.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"__m64"}}],[5,"_mm_cvtps_pi32","","Convert the two lower packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"__m64"}}],[5,"_mm_cvt_ps2pi","","Convert the two lower packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"__m64"}}],[5,"_mm_cvtps_pi16","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed 16-bit integers.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"__m64"}}],[5,"_mm_cvtps_pi8","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed 8-bit integers, and returns theem in the lower 4 elements of the result.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"__m64"}}],[5,"_mm_pause","","Provide a hint to the processor that the code sequence is a spin-wait loop.",null,{"inputs":[],"output":null}],[5,"_mm_clflush","","Invalidate and flush the cache line that contains `p` from all levels of the cache hierarchy.",null,null],[5,"_mm_lfence","","Perform a serializing operation on all load-from-memory instructions that were issued prior to this instruction.",null,{"inputs":[],"output":null}],[5,"_mm_mfence","","Perform a serializing operation on all load-from-memory and store-to-memory instructions that were issued prior to this instruction.",null,{"inputs":[],"output":null}],[5,"_mm_add_epi8","","Add packed 8-bit integers in `a` and `b`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_add_epi16","","Add packed 16-bit integers in `a` and `b`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_add_epi32","","Add packed 32-bit integers in `a` and `b`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_add_epi64","","Add packed 64-bit integers in `a` and \"b`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_adds_epi8","","Add packed 8-bit integers in `a` and `b` using saturation.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_adds_epi16","","Add packed 16-bit integers in `a` and `b` using saturation.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_adds_epu8","","Add packed unsigned 8-bit integers in `a` and `b` using saturation.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_adds_epu16","","Add packed unsigned 16-bit integers in `a` and `b` using saturation.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_avg_epu8","","Average packed unsigned 8-bit integers in `a` and `b`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_avg_epu16","","Average packed unsigned 16-bit integers in `a` and `b`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_madd_epi16","","Multiply and then horizontally add signed 16 bit integers in `a` and `b`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_max_epi16","","Compare packed 16-bit integers in `a` and `b`, and return the packed maximum values.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_max_epu8","","Compare packed unsigned 8-bit integers in `a` and `b`, and return the packed maximum values.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_min_epi16","","Compare packed 16-bit integers in `a` and `b`, and return the packed minimum values.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_min_epu8","","Compare packed unsigned 8-bit integers in `a` and `b`, and return the packed minimum values.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_mulhi_epi16","","Multiply the packed 16-bit integers in `a` and `b`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_mulhi_epu16","","Multiply the packed unsigned 16-bit integers in `a` and `b`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_mullo_epi16","","Multiply the packed 16-bit integers in `a` and `b`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_mul_epu32","","Multiply the low unsigned 32-bit integers from each packed 64-bit element in `a` and `b`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_sad_epu8","","Sum the absolute differences of packed unsigned 8-bit integers.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_sub_epi8","","Subtract packed 8-bit integers in `b` from packed 8-bit integers in `a`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_sub_epi16","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_sub_epi32","","Subtract packed 32-bit integers in `b` from packed 32-bit integers in `a`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_sub_epi64","","Subtract packed 64-bit integers in `b` from packed 64-bit integers in `a`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_subs_epi8","","Subtract packed 8-bit integers in `b` from packed 8-bit integers in `a` using saturation.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_subs_epi16","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a` using saturation.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_subs_epu8","","Subtract packed unsigned 8-bit integers in `b` from packed unsigned 8-bit integers in `a` using saturation.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_subs_epu16","","Subtract packed unsigned 16-bit integers in `b` from packed unsigned 16-bit integers in `a` using saturation.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_slli_si128","","Shift `a` left by `imm8` bytes while shifting in zeros.",null,{"inputs":[{"name":"__m128i"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_bslli_si128","","Shift `a` left by `imm8` bytes while shifting in zeros.",null,{"inputs":[{"name":"__m128i"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_bsrli_si128","","Shift `a` right by `imm8` bytes while shifting in zeros.",null,{"inputs":[{"name":"__m128i"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_slli_epi16","","Shift packed 16-bit integers in `a` left by `imm8` while shifting in zeros.",null,{"inputs":[{"name":"__m128i"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_sll_epi16","","Shift packed 16-bit integers in `a` left by `count` while shifting in zeros.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_slli_epi32","","Shift packed 32-bit integers in `a` left by `imm8` while shifting in zeros.",null,{"inputs":[{"name":"__m128i"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_sll_epi32","","Shift packed 32-bit integers in `a` left by `count` while shifting in zeros.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_slli_epi64","","Shift packed 64-bit integers in `a` left by `imm8` while shifting in zeros.",null,{"inputs":[{"name":"__m128i"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_sll_epi64","","Shift packed 64-bit integers in `a` left by `count` while shifting in zeros.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_srai_epi16","","Shift packed 16-bit integers in `a` right by `imm8` while shifting in sign bits.",null,{"inputs":[{"name":"__m128i"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_sra_epi16","","Shift packed 16-bit integers in `a` right by `count` while shifting in sign bits.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_srai_epi32","","Shift packed 32-bit integers in `a` right by `imm8` while shifting in sign bits.",null,{"inputs":[{"name":"__m128i"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_sra_epi32","","Shift packed 32-bit integers in `a` right by `count` while shifting in sign bits.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_srli_si128","","Shift `a` right by `imm8` bytes while shifting in zeros.",null,{"inputs":[{"name":"__m128i"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_srli_epi16","","Shift packed 16-bit integers in `a` right by `imm8` while shifting in zeros.",null,{"inputs":[{"name":"__m128i"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_srl_epi16","","Shift packed 16-bit integers in `a` right by `count` while shifting in zeros.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_srli_epi32","","Shift packed 32-bit integers in `a` right by `imm8` while shifting in zeros.",null,{"inputs":[{"name":"__m128i"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_srl_epi32","","Shift packed 32-bit integers in `a` right by `count` while shifting in zeros.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_srli_epi64","","Shift packed 64-bit integers in `a` right by `imm8` while shifting in zeros.",null,{"inputs":[{"name":"__m128i"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_srl_epi64","","Shift packed 64-bit integers in `a` right by `count` while shifting in zeros.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_and_si128","","Compute the bitwise AND of 128 bits (representing integer data) in `a` and `b`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_andnot_si128","","Compute the bitwise NOT of 128 bits (representing integer data) in `a` and then AND with `b`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_or_si128","","Compute the bitwise OR of 128 bits (representing integer data) in `a` and `b`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_xor_si128","","Compute the bitwise XOR of 128 bits (representing integer data) in `a` and `b`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_cmpeq_epi8","","Compare packed 8-bit integers in `a` and `b` for equality.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_cmpeq_epi16","","Compare packed 16-bit integers in `a` and `b` for equality.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_cmpeq_epi32","","Compare packed 32-bit integers in `a` and `b` for equality.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_cmpgt_epi8","","Compare packed 8-bit integers in `a` and `b` for greater-than.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_cmpgt_epi16","","Compare packed 16-bit integers in `a` and `b` for greater-than.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_cmpgt_epi32","","Compare packed 32-bit integers in `a` and `b` for greater-than.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_cmplt_epi8","","Compare packed 8-bit integers in `a` and `b` for less-than.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_cmplt_epi16","","Compare packed 16-bit integers in `a` and `b` for less-than.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_cmplt_epi32","","Compare packed 32-bit integers in `a` and `b` for less-than.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_cvtepi32_pd","","Convert the lower two packed 32-bit integers in `a` to packed double-precision (64-bit) floating-point elements.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m128d"}}],[5,"_mm_cvtsi32_sd","","Return `a` with its lower element replaced by `b` after converting it to an `f64`.",null,{"inputs":[{"name":"__m128d"},{"name":"i32"}],"output":{"name":"__m128d"}}],[5,"_mm_cvtepi32_ps","","Convert packed 32-bit integers in `a` to packed single-precision (32-bit) floating-point elements.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m128"}}],[5,"_mm_cvtps_epi32","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"__m128i"}}],[5,"_mm_cvtsi32_si128","","Return a vector whose lowest element is `a` and all higher elements are `0`.",null,{"inputs":[{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_cvtsi128_si32","","Return the lowest element of `a`.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"i32"}}],[5,"_mm_set_epi64x","","Set packed 64-bit integers with the supplied values, from highest to lowest.",null,{"inputs":[{"name":"i64"},{"name":"i64"}],"output":{"name":"__m128i"}}],[5,"_mm_set_epi32","","Set packed 32-bit integers with the supplied values.",null,{"inputs":[{"name":"i32"},{"name":"i32"},{"name":"i32"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_set_epi16","","Set packed 16-bit integers with the supplied values.",null,{"inputs":[{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"}],"output":{"name":"__m128i"}}],[5,"_mm_set_epi8","","Set packed 8-bit integers with the supplied values.",null,{"inputs":[{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"}],"output":{"name":"__m128i"}}],[5,"_mm_set1_epi64x","","Broadcast 64-bit integer `a` to all elements.",null,{"inputs":[{"name":"i64"}],"output":{"name":"__m128i"}}],[5,"_mm_set1_epi32","","Broadcast 32-bit integer `a` to all elements.",null,{"inputs":[{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_set1_epi16","","Broadcast 16-bit integer `a` to all elements.",null,{"inputs":[{"name":"i16"}],"output":{"name":"__m128i"}}],[5,"_mm_set1_epi8","","Broadcast 8-bit integer `a` to all elements.",null,{"inputs":[{"name":"i8"}],"output":{"name":"__m128i"}}],[5,"_mm_setr_epi32","","Set packed 32-bit integers with the supplied values in reverse order.",null,{"inputs":[{"name":"i32"},{"name":"i32"},{"name":"i32"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_setr_epi16","","Set packed 16-bit integers with the supplied values in reverse order.",null,{"inputs":[{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"}],"output":{"name":"__m128i"}}],[5,"_mm_setr_epi8","","Set packed 8-bit integers with the supplied values in reverse order.",null,{"inputs":[{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"}],"output":{"name":"__m128i"}}],[5,"_mm_setzero_si128","","Returns a vector with all elements set to zero.",null,{"inputs":[],"output":{"name":"__m128i"}}],[5,"_mm_loadl_epi64","","Load 64-bit integer from memory into first element of returned vector.",null,null],[5,"_mm_load_si128","","Load 128-bits of integer data from memory into a new vector.",null,null],[5,"_mm_loadu_si128","","Load 128-bits of integer data from memory into a new vector.",null,null],[5,"_mm_maskmoveu_si128","","Conditionally store 8-bit integer elements from `a` into memory using `mask`.",null,null],[5,"_mm_store_si128","","Store 128-bits of integer data from `a` into memory.",null,null],[5,"_mm_storeu_si128","","Store 128-bits of integer data from `a` into memory.",null,null],[5,"_mm_storel_epi64","","Store the lower 64-bit integer `a` to a memory location.",null,null],[5,"_mm_stream_si128","","Stores a 128-bit integer vector to a 128-bit aligned memory location. To minimize caching, the data is flagged as non-temporal (unlikely to be used again soon).",null,null],[5,"_mm_stream_si32","","Stores a 32-bit integer value in the specified memory location. To minimize caching, the data is flagged as non-temporal (unlikely to be used again soon).",null,null],[5,"_mm_move_epi64","","Return a vector where the low element is extracted from `a` and its upper element is zero.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_packs_epi16","","Convert packed 16-bit integers from `a` and `b` to packed 8-bit integers using signed saturation.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_packs_epi32","","Convert packed 32-bit integers from `a` and `b` to packed 16-bit integers using signed saturation.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_packus_epi16","","Convert packed 16-bit integers from `a` and `b` to packed 8-bit integers using unsigned saturation.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_extract_epi16","","Return the `imm8` element of `a`.",null,{"inputs":[{"name":"__m128i"},{"name":"i32"}],"output":{"name":"i32"}}],[5,"_mm_insert_epi16","","Return a new vector where the `imm8` element of `a` is replaced with `i`.",null,{"inputs":[{"name":"__m128i"},{"name":"i32"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_movemask_epi8","","Return a mask of the most significant bit of each element in `a`.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"i32"}}],[5,"_mm_shuffle_epi32","","Shuffle 32-bit integers in `a` using the control in `imm8`.",null,{"inputs":[{"name":"__m128i"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_shufflehi_epi16","","Shuffle 16-bit integers in the high 64 bits of `a` using the control in `imm8`.",null,{"inputs":[{"name":"__m128i"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_shufflelo_epi16","","Shuffle 16-bit integers in the low 64 bits of `a` using the control in `imm8`.",null,{"inputs":[{"name":"__m128i"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_unpackhi_epi8","","Unpack and interleave 8-bit integers from the high half of `a` and `b`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_unpackhi_epi16","","Unpack and interleave 16-bit integers from the high half of `a` and `b`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_unpackhi_epi32","","Unpack and interleave 32-bit integers from the high half of `a` and `b`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_unpackhi_epi64","","Unpack and interleave 64-bit integers from the high half of `a` and `b`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_unpacklo_epi8","","Unpack and interleave 8-bit integers from the low half of `a` and `b`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_unpacklo_epi16","","Unpack and interleave 16-bit integers from the low half of `a` and `b`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_unpacklo_epi32","","Unpack and interleave 32-bit integers from the low half of `a` and `b`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_unpacklo_epi64","","Unpack and interleave 64-bit integers from the low half of `a` and `b`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_add_sd","","Return a new vector with the low element of `a` replaced by the sum of the low elements of `a` and `b`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_add_pd","","Add packed double-precision (64-bit) floating-point elements in `a` and `b`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_div_sd","","Return a new vector with the low element of `a` replaced by the result of diving the lower element of `a` by the lower element of `b`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_div_pd","","Divide packed double-precision (64-bit) floating-point elements in `a` by packed elements in `b`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_max_sd","","Return a new vector with the low element of `a` replaced by the maximum of the lower elements of `a` and `b`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_max_pd","","Return a new vector with the maximum values from corresponding elements in `a` and `b`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_min_sd","","Return a new vector with the low element of `a` replaced by the minimum of the lower elements of `a` and `b`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_min_pd","","Return a new vector with the minimum values from corresponding elements in `a` and `b`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_mul_sd","","Return a new vector with the low element of `a` replaced by multiplying the low elements of `a` and `b`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_mul_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_sqrt_sd","","Return a new vector with the low element of `a` replaced by the square root of the lower element `b`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_sqrt_pd","","Return a new vector with the square root of each of the values in `a`.",null,{"inputs":[{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_sub_sd","","Return a new vector with the low element of `a` replaced by subtracting the low element by `b` from the low element of `a`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_sub_pd","","Subtract packed double-precision (64-bit) floating-point elements in `b` from `a`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_and_pd","","Compute the bitwise AND of packed double-precision (64-bit) floating-point elements in `a` and `b`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_andnot_pd","","Compute the bitwise NOT of `a` and then AND with `b`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_or_pd","","Compute the bitwise OR of `a` and `b`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_xor_pd","","Compute the bitwise OR of `a` and `b`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_cmpeq_sd","","Return a new vector with the low element of `a` replaced by the equality comparison of the lower elements of `a` and `b`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_cmplt_sd","","Return a new vector with the low element of `a` replaced by the less-than comparison of the lower elements of `a` and `b`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_cmple_sd","","Return a new vector with the low element of `a` replaced by the less-than-or-equal comparison of the lower elements of `a` and `b`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_cmpgt_sd","","Return a new vector with the low element of `a` replaced by the greater-than comparison of the lower elements of `a` and `b`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_cmpge_sd","","Return a new vector with the low element of `a` replaced by the greater-than-or-equal comparison of the lower elements of `a` and `b`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_cmpord_sd","","Return a new vector with the low element of `a` replaced by the result of comparing both of the lower elements of `a` and `b` to `NaN`. If neither are equal to `NaN` then `0xFFFFFFFFFFFFFFFF` is used and `0` otherwise.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_cmpunord_sd","","Return a new vector with the low element of `a` replaced by the result of comparing both of the lower elements of `a` and `b` to `NaN`. If either is equal to `NaN` then `0xFFFFFFFFFFFFFFFF` is used and `0` otherwise.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_cmpneq_sd","","Return a new vector with the low element of `a` replaced by the not-equal comparison of the lower elements of `a` and `b`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_cmpnlt_sd","","Return a new vector with the low element of `a` replaced by the not-less-than comparison of the lower elements of `a` and `b`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_cmpnle_sd","","Return a new vector with the low element of `a` replaced by the not-less-than-or-equal comparison of the lower elements of `a` and `b`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_cmpngt_sd","","Return a new vector with the low element of `a` replaced by the not-greater-than comparison of the lower elements of `a` and `b`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_cmpnge_sd","","Return a new vector with the low element of `a` replaced by the not-greater-than-or-equal comparison of the lower elements of `a` and `b`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_cmpeq_pd","","Compare corresponding elements in `a` and `b` for equality.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_cmplt_pd","","Compare corresponding elements in `a` and `b` for less-than.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_cmple_pd","","Compare corresponding elements in `a` and `b` for less-than-or-equal",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_cmpgt_pd","","Compare corresponding elements in `a` and `b` for greater-than.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_cmpge_pd","","Compare corresponding elements in `a` and `b` for greater-than-or-equal.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_cmpord_pd","","Compare corresponding elements in `a` and `b` to see if neither is `NaN`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_cmpunord_pd","","Compare corresponding elements in `a` and `b` to see if either is `NaN`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_cmpneq_pd","","Compare corresponding elements in `a` and `b` for not-equal.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_cmpnlt_pd","","Compare corresponding elements in `a` and `b` for not-less-than.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_cmpnle_pd","","Compare corresponding elements in `a` and `b` for not-less-than-or-equal.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_cmpngt_pd","","Compare corresponding elements in `a` and `b` for not-greater-than.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_cmpnge_pd","","Compare corresponding elements in `a` and `b` for not-greater-than-or-equal.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_comieq_sd","","Compare the lower element of `a` and `b` for equality.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"i32"}}],[5,"_mm_comilt_sd","","Compare the lower element of `a` and `b` for less-than.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"i32"}}],[5,"_mm_comile_sd","","Compare the lower element of `a` and `b` for less-than-or-equal.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"i32"}}],[5,"_mm_comigt_sd","","Compare the lower element of `a` and `b` for greater-than.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"i32"}}],[5,"_mm_comige_sd","","Compare the lower element of `a` and `b` for greater-than-or-equal.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"i32"}}],[5,"_mm_comineq_sd","","Compare the lower element of `a` and `b` for not-equal.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"i32"}}],[5,"_mm_ucomieq_sd","","Compare the lower element of `a` and `b` for equality.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"i32"}}],[5,"_mm_ucomilt_sd","","Compare the lower element of `a` and `b` for less-than.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"i32"}}],[5,"_mm_ucomile_sd","","Compare the lower element of `a` and `b` for less-than-or-equal.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"i32"}}],[5,"_mm_ucomigt_sd","","Compare the lower element of `a` and `b` for greater-than.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"i32"}}],[5,"_mm_ucomige_sd","","Compare the lower element of `a` and `b` for greater-than-or-equal.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"i32"}}],[5,"_mm_ucomineq_sd","","Compare the lower element of `a` and `b` for not-equal.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"i32"}}],[5,"_mm_cvtpd_ps","","Convert packed double-precision (64-bit) floating-point elements in \"a\" to packed single-precision (32-bit) floating-point elements",null,{"inputs":[{"name":"__m128d"}],"output":{"name":"__m128"}}],[5,"_mm_cvtps_pd","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed double-precision (64-bit) floating-point elements.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"__m128d"}}],[5,"_mm_cvtpd_epi32","","Convert packed double-precision (64-bit) floating-point elements in `a` to packed 32-bit integers.",null,{"inputs":[{"name":"__m128d"}],"output":{"name":"__m128i"}}],[5,"_mm_cvtsd_si32","","Convert the lower double-precision (64-bit) floating-point element in a to a 32-bit integer.",null,{"inputs":[{"name":"__m128d"}],"output":{"name":"i32"}}],[5,"_mm_cvtsd_ss","","Convert the lower double-precision (64-bit) floating-point element in `b` to a single-precision (32-bit) floating-point element, store the result in the lower element of the return value, and copy the upper element from `a` to the upper element the return value.",null,{"inputs":[{"name":"__m128"},{"name":"__m128d"}],"output":{"name":"__m128"}}],[5,"_mm_cvtsd_f64","","Return the lower double-precision (64-bit) floating-point element of \"a\".",null,{"inputs":[{"name":"__m128d"}],"output":{"name":"f64"}}],[5,"_mm_cvtss_sd","","Convert the lower single-precision (32-bit) floating-point element in `b` to a double-precision (64-bit) floating-point element, store the result in the lower element of the return value, and copy the upper element from `a` to the upper element the return value.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128"}],"output":{"name":"__m128d"}}],[5,"_mm_cvttpd_epi32","","Convert packed double-precision (64-bit) floating-point elements in `a` to packed 32-bit integers with truncation.",null,{"inputs":[{"name":"__m128d"}],"output":{"name":"__m128i"}}],[5,"_mm_cvttsd_si32","","Convert the lower double-precision (64-bit) floating-point element in `a` to a 32-bit integer with truncation.",null,{"inputs":[{"name":"__m128d"}],"output":{"name":"i32"}}],[5,"_mm_cvttps_epi32","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers with truncation.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"__m128i"}}],[5,"_mm_set_sd","","Copy double-precision (64-bit) floating-point element `a` to the lower element of the packed 64-bit return value.",null,{"inputs":[{"name":"f64"}],"output":{"name":"__m128d"}}],[5,"_mm_set1_pd","","Broadcast double-precision (64-bit) floating-point value a to all elements of the return value.",null,{"inputs":[{"name":"f64"}],"output":{"name":"__m128d"}}],[5,"_mm_set_pd1","","Broadcast double-precision (64-bit) floating-point value a to all elements of the return value.",null,{"inputs":[{"name":"f64"}],"output":{"name":"__m128d"}}],[5,"_mm_set_pd","","Set packed double-precision (64-bit) floating-point elements in the return value with the supplied values.",null,{"inputs":[{"name":"f64"},{"name":"f64"}],"output":{"name":"__m128d"}}],[5,"_mm_setr_pd","","Set packed double-precision (64-bit) floating-point elements in the return value with the supplied values in reverse order.",null,{"inputs":[{"name":"f64"},{"name":"f64"}],"output":{"name":"__m128d"}}],[5,"_mm_setzero_pd","","Returns packed double-precision (64-bit) floating-point elements with all zeros.",null,{"inputs":[],"output":{"name":"__m128d"}}],[5,"_mm_movemask_pd","","Return a mask of the most significant bit of each element in `a`.",null,{"inputs":[{"name":"__m128d"}],"output":{"name":"i32"}}],[5,"_mm_load_pd","","Load 128-bits (composed of 2 packed double-precision (64-bit) floating-point elements) from memory into the returned vector. `mem_addr` must be aligned on a 16-byte boundary or a general-protection exception may be generated.",null,null],[5,"_mm_load_sd","","Loads a 64-bit double-precision value to the low element of a 128-bit integer vector and clears the upper element.",null,null],[5,"_mm_loadh_pd","","Loads a double-precision value into the high-order bits of a 128-bit vector of `[2 x double]`. The low-order bits are copied from the low-order bits of the first operand.",null,null],[5,"_mm_loadl_pd","","Loads a double-precision value into the low-order bits of a 128-bit vector of `[2 x double]`. The high-order bits are copied from the high-order bits of the first operand.",null,null],[5,"_mm_stream_pd","","Stores a 128-bit floating point vector of `[2 x double]` to a 128-bit aligned memory location. To minimize caching, the data is flagged as non-temporal (unlikely to be used again soon).",null,null],[5,"_mm_store_sd","","Stores the lower 64 bits of a 128-bit vector of `[2 x double]` to a memory location.",null,null],[5,"_mm_store_pd","","Store 128-bits (composed of 2 packed double-precision (64-bit) floating-point elements) from `a` into memory. `mem_addr` must be aligned on a 16-byte boundary or a general-protection exception may be generated.",null,null],[5,"_mm_storeu_pd","","Store 128-bits (composed of 2 packed double-precision (64-bit) floating-point elements) from `a` into memory. `mem_addr` does not need to be aligned on any particular boundary.",null,null],[5,"_mm_store1_pd","","Store the lower double-precision (64-bit) floating-point element from `a` into 2 contiguous elements in memory. `mem_addr` must be aligned on a 16-byte boundary or a general-protection exception may be generated.",null,null],[5,"_mm_store_pd1","","Store the lower double-precision (64-bit) floating-point element from `a` into 2 contiguous elements in memory. `mem_addr` must be aligned on a 16-byte boundary or a general-protection exception may be generated.",null,null],[5,"_mm_storer_pd","","Store 2 double-precision (64-bit) floating-point elements from `a` into memory in reverse order. `mem_addr` must be aligned on a 16-byte boundary or a general-protection exception may be generated.",null,null],[5,"_mm_storeh_pd","","Stores the upper 64 bits of a 128-bit vector of `[2 x double]` to a memory location.",null,null],[5,"_mm_storel_pd","","Stores the lower 64 bits of a 128-bit vector of `[2 x double]` to a memory location.",null,null],[5,"_mm_load1_pd","","Load a double-precision (64-bit) floating-point element from memory into both elements of returned vector.",null,null],[5,"_mm_load_pd1","","Load a double-precision (64-bit) floating-point element from memory into both elements of returned vector.",null,null],[5,"_mm_loadr_pd","","Load 2 double-precision (64-bit) floating-point elements from memory into the returned vector in reverse order. `mem_addr` must be aligned on a 16-byte boundary or a general-protection exception may be generated.",null,null],[5,"_mm_loadu_pd","","Load 128-bits (composed of 2 packed double-precision (64-bit) floating-point elements) from memory into the returned vector. `mem_addr` does not need to be aligned on any particular boundary.",null,null],[5,"_mm_shuffle_pd","","Constructs a 128-bit floating-point vector of `[2 x double]` from two 128-bit vector parameters of `[2 x double]`, using the immediate-value parameter as a specifier.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"},{"name":"i32"}],"output":{"name":"__m128d"}}],[5,"_mm_move_sd","","Constructs a 128-bit floating-point vector of `[2 x double]`. The lower 64 bits are set to the lower 64 bits of the second parameter. The upper 64 bits are set to the upper 64 bits of the first parameter.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_castpd_ps","","Casts a 128-bit floating-point vector of `[2 x double]` into a 128-bit floating-point vector of `[4 x float]`.",null,{"inputs":[{"name":"__m128d"}],"output":{"name":"__m128"}}],[5,"_mm_castpd_si128","","Casts a 128-bit floating-point vector of `[2 x double]` into a 128-bit integer vector.",null,{"inputs":[{"name":"__m128d"}],"output":{"name":"__m128i"}}],[5,"_mm_castps_pd","","Casts a 128-bit floating-point vector of `[4 x float]` into a 128-bit floating-point vector of `[2 x double]`.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"__m128d"}}],[5,"_mm_castps_si128","","Casts a 128-bit floating-point vector of `[4 x float]` into a 128-bit integer vector.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"__m128i"}}],[5,"_mm_castsi128_pd","","Casts a 128-bit integer vector into a 128-bit floating-point vector of `[2 x double]`.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m128d"}}],[5,"_mm_castsi128_ps","","Casts a 128-bit integer vector into a 128-bit floating-point vector of `[4 x float]`.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m128"}}],[5,"_mm_undefined_pd","","Return vector of type __m128d with undefined elements.",null,{"inputs":[],"output":{"name":"__m128d"}}],[5,"_mm_undefined_si128","","Return vector of type __m128i with undefined elements.",null,{"inputs":[],"output":{"name":"__m128i"}}],[5,"_mm_unpackhi_pd","","The resulting `__m128d` element is composed by the low-order values of the two `__m128d` interleaved input elements, i.e.:",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_unpacklo_pd","","The resulting `__m128d` element is composed by the high-order values of the two `__m128d` interleaved input elements, i.e.:",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_add_si64","","Adds two signed or unsigned 64-bit integer values, returning the lower 64 bits of the sum.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_mul_su32","","Multiplies 32-bit unsigned integer values contained in the lower bits of the two 64-bit integer vectors and returns the 64-bit unsigned product.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_sub_si64","","Subtracts signed or unsigned 64-bit integer values and writes the difference to the corresponding bits in the destination.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_cvtpi32_pd","","Converts the two signed 32-bit integer elements of a 64-bit vector of `[2 x i32]` into two double-precision floating-point values, returned in a 128-bit vector of `[2 x double]`.",null,{"inputs":[{"name":"__m64"}],"output":{"name":"__m128d"}}],[5,"_mm_set_epi64","","Initializes both 64-bit values in a 128-bit vector of `[2 x i64]` with the specified 64-bit integer values.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m128i"}}],[5,"_mm_set1_epi64","","Initializes both values in a 128-bit vector of `[2 x i64]` with the specified 64-bit value.",null,{"inputs":[{"name":"__m64"}],"output":{"name":"__m128i"}}],[5,"_mm_setr_epi64","","Constructs a 128-bit integer vector, initialized in reverse order with the specified 64-bit integral values.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m128i"}}],[5,"_mm_movepi64_pi64","","Returns the lower 64 bits of a 128-bit integer vector as a 64-bit integer.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m64"}}],[5,"_mm_movpi64_epi64","","Moves the 64-bit operand to a 128-bit integer vector, zeroing the upper bits.",null,{"inputs":[{"name":"__m64"}],"output":{"name":"__m128i"}}],[5,"_mm_cvtpd_pi32","","Converts the two double-precision floating-point elements of a 128-bit vector of `[2 x double]` into two signed 32-bit integer values, returned in a 64-bit vector of `[2 x i32]`.",null,{"inputs":[{"name":"__m128d"}],"output":{"name":"__m64"}}],[5,"_mm_cvttpd_pi32","","Converts the two double-precision floating-point elements of a 128-bit vector of `[2 x double]` into two signed 32-bit integer values, returned in a 64-bit vector of `[2 x i32]`. If the result of either conversion is inexact, the result is truncated (rounded towards zero) regardless of the current MXCSR setting.",null,{"inputs":[{"name":"__m128d"}],"output":{"name":"__m64"}}],[5,"_mm_addsub_ps","","Alternatively add and subtract packed single-precision (32-bit) floating-point elements in `a` to/from packed elements in `b`.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_addsub_pd","","Alternatively add and subtract packed double-precision (64-bit) floating-point elements in `a` to/from packed elements in `b`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_hadd_pd","","Horizontally add adjacent pairs of double-precision (64-bit) floating-point elements in `a` and `b`, and pack the results.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_hadd_ps","","Horizontally add adjacent pairs of single-precision (32-bit) floating-point elements in `a` and `b`, and pack the results.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_hsub_pd","","Horizontally subtract adjacent pairs of double-precision (64-bit) floating-point elements in `a` and `b`, and pack the results.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_hsub_ps","","Horizontally add adjacent pairs of single-precision (32-bit) floating-point elements in `a` and `b`, and pack the results.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_lddqu_si128","","Load 128-bits of integer data from unaligned memory. This intrinsic may perform better than `_mm_loadu_si128` when the data crosses a cache line boundary.",null,null],[5,"_mm_movedup_pd","","Duplicate the low double-precision (64-bit) floating-point element from `a`.",null,{"inputs":[{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_loaddup_pd","","Load a double-precision (64-bit) floating-point element from memory into both elements of return vector.",null,null],[5,"_mm_movehdup_ps","","Duplicate odd-indexed single-precision (32-bit) floating-point elements from `a`.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_moveldup_ps","","Duplicate even-indexed single-precision (32-bit) floating-point elements from `a`.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_abs_epi8","","Compute the absolute value of packed 8-bit signed integers in `a` and return the unsigned results.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_abs_epi16","","Compute the absolute value of each of the packed 16-bit signed integers in `a` and return the 16-bit unsigned integer",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_abs_epi32","","Compute the absolute value of each of the packed 32-bit signed integers in `a` and return the 32-bit unsigned integer",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_shuffle_epi8","","Shuffle bytes from `a` according to the content of `b`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_alignr_epi8","","Concatenate 16-byte blocks in `a` and `b` into a 32-byte temporary result, shift the result right by `n` bytes, and return the low 16 bytes.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_hadd_epi16","","Horizontally add the adjacent pairs of values contained in 2 packed 128-bit vectors of `[8 x i16]`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_hadds_epi16","","Horizontally add the adjacent pairs of values contained in 2 packed 128-bit vectors of `[8 x i16]`. Positive sums greater than 7FFFh are saturated to 7FFFh. Negative sums less than 8000h are saturated to 8000h.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_hadd_epi32","","Horizontally add the adjacent pairs of values contained in 2 packed 128-bit vectors of `[4 x i32]`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_hsub_epi16","","Horizontally subtract the adjacent pairs of values contained in 2 packed 128-bit vectors of `[8 x i16]`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_hsubs_epi16","","Horizontally subtract the adjacent pairs of values contained in 2 packed 128-bit vectors of `[8 x i16]`. Positive differences greater than 7FFFh are saturated to 7FFFh. Negative differences less than 8000h are saturated to 8000h.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_hsub_epi32","","Horizontally subtract the adjacent pairs of values contained in 2 packed 128-bit vectors of `[4 x i32]`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_maddubs_epi16","","Multiply corresponding pairs of packed 8-bit unsigned integer values contained in the first source operand and packed 8-bit signed integer values contained in the second source operand, add pairs of contiguous products with signed saturation, and writes the 16-bit sums to the corresponding bits in the destination.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_mulhrs_epi16","","Multiply packed 16-bit signed integer values, truncate the 32-bit product to the 18 most significant bits by right-shifting, round the truncated value by adding 1, and write bits `[16:1]` to the destination.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_sign_epi8","","Negate packed 8-bit integers in `a` when the corresponding signed 8-bit integer in `b` is negative, and return the result. Elements in result are zeroed out when the corresponding element in `b` is zero.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_sign_epi16","","Negate packed 16-bit integers in `a` when the corresponding signed 16-bit integer in `b` is negative, and return the results. Elements in result are zeroed out when the corresponding element in `b` is zero.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_sign_epi32","","Negate packed 32-bit integers in `a` when the corresponding signed 32-bit integer in `b` is negative, and return the results. Element in result are zeroed out when the corresponding element in `b` is zero.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_abs_pi8","","Compute the absolute value of packed 8-bit integers in `a` and return the unsigned results.",null,{"inputs":[{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_abs_pi16","","Compute the absolute value of packed 8-bit integers in `a`, and return the unsigned results.",null,{"inputs":[{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_abs_pi32","","Compute the absolute value of packed 32-bit integers in `a`, and return the unsigned results.",null,{"inputs":[{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_shuffle_pi8","","Shuffle packed 8-bit integers in `a` according to shuffle control mask in the corresponding 8-bit element of `b`, and return the results",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_alignr_pi8","","Concatenates the two 64-bit integer vector operands, and right-shifts the result by the number of bytes specified in the immediate operand.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"},{"name":"i32"}],"output":{"name":"__m64"}}],[5,"_mm_hadd_pi16","","Horizontally add the adjacent pairs of values contained in 2 packed 64-bit vectors of `[4 x i16]`.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_hadd_pi32","","Horizontally add the adjacent pairs of values contained in 2 packed 64-bit vectors of `[2 x i32]`.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_hadds_pi16","","Horizontally add the adjacent pairs of values contained in 2 packed 64-bit vectors of `[4 x i16]`. Positive sums greater than 7FFFh are saturated to 7FFFh. Negative sums less than 8000h are saturated to 8000h.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_hsub_pi16","","Horizontally subtracts the adjacent pairs of values contained in 2 packed 64-bit vectors of `[4 x i16]`.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_hsub_pi32","","Horizontally subtracts the adjacent pairs of values contained in 2 packed 64-bit vectors of `[2 x i32]`.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_hsubs_pi16","","Horizontally subtracts the adjacent pairs of values contained in 2 packed 64-bit vectors of `[4 x i16]`. Positive differences greater than 7FFFh are saturated to 7FFFh. Negative differences less than 8000h are saturated to 8000h.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_maddubs_pi16","","Multiplies corresponding pairs of packed 8-bit unsigned integer values contained in the first source operand and packed 8-bit signed integer values contained in the second source operand, adds pairs of contiguous products with signed saturation, and writes the 16-bit sums to the corresponding bits in the destination.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_mulhrs_pi16","","Multiplies packed 16-bit signed integer values, truncates the 32-bit products to the 18 most significant bits by right-shifting, rounds the truncated value by adding 1, and writes bits `[16:1]` to the destination.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_sign_pi8","","Negate packed 8-bit integers in `a` when the corresponding signed 8-bit integer in `b` is negative, and return the results. Element in result are zeroed out when the corresponding element in `b` is zero.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_sign_pi16","","Negate packed 16-bit integers in `a` when the corresponding signed 16-bit integer in `b` is negative, and return the results. Element in result are zeroed out when the corresponding element in `b` is zero.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_sign_pi32","","Negate packed 32-bit integers in `a` when the corresponding signed 32-bit integer in `b` is negative, and return the results. Element in result are zeroed out when the corresponding element in `b` is zero.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_blendv_epi8","","Blend packed 8-bit integers from `a` and `b` using `mask`",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_blend_epi16","","Blend packed 16-bit integers from `a` and `b` using the mask `imm8`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_blendv_pd","","Blend packed double-precision (64-bit) floating-point elements from `a` and `b` using `mask`",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_blendv_ps","","Blend packed single-precision (32-bit) floating-point elements from `a` and `b` using `mask`",null,{"inputs":[{"name":"__m128"},{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_blend_pd","","Blend packed double-precision (64-bit) floating-point elements from `a` and `b` using control mask `imm2`",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"},{"name":"i32"}],"output":{"name":"__m128d"}}],[5,"_mm_blend_ps","","Blend packed single-precision (32-bit) floating-point elements from `a` and `b` using mask `imm4`",null,{"inputs":[{"name":"__m128"},{"name":"__m128"},{"name":"i32"}],"output":{"name":"__m128"}}],[5,"_mm_extract_ps","","Extract a single-precision (32-bit) floating-point element from `a`, selected with `imm8`",null,{"inputs":[{"name":"__m128"},{"name":"i32"}],"output":{"name":"i32"}}],[5,"_mm_extract_epi8","","Extract an 8-bit integer from `a`, selected with `imm8`. Returns a 32-bit integer containing the zero-extended integer data.",null,{"inputs":[{"name":"__m128i"},{"name":"i32"}],"output":{"name":"i32"}}],[5,"_mm_extract_epi32","","Extract an 32-bit integer from `a` selected with `imm8`",null,{"inputs":[{"name":"__m128i"},{"name":"i32"}],"output":{"name":"i32"}}],[5,"_mm_insert_ps","","Select a single value in `a` to store at some position in `b`, Then zero elements according to `imm8`.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"},{"name":"i32"}],"output":{"name":"__m128"}}],[5,"_mm_insert_epi8","","Return a copy of `a` with the 8-bit integer from `i` inserted at a location specified by `imm8`.",null,{"inputs":[{"name":"__m128i"},{"name":"i32"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_insert_epi32","","Return a copy of `a` with the 32-bit integer from `i` inserted at a location specified by `imm8`.",null,{"inputs":[{"name":"__m128i"},{"name":"i32"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_max_epi8","","Compare packed 8-bit integers in `a` and `b` and return packed maximum values in dst.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_max_epu16","","Compare packed unsigned 16-bit integers in `a` and `b`, and return packed maximum.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_max_epi32","","Compare packed 32-bit integers in `a` and `b`, and return packed maximum values.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_max_epu32","","Compare packed unsigned 32-bit integers in `a` and `b`, and return packed maximum values.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_min_epi8","","Compare packed 8-bit integers in `a` and `b` and return packed minimum values in dst.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_min_epu16","","Compare packed unsigned 16-bit integers in `a` and `b`, and return packed minimum.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_min_epi32","","Compare packed 32-bit integers in `a` and `b`, and return packed minimum values.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_min_epu32","","Compare packed unsigned 32-bit integers in `a` and `b`, and return packed minimum values.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_packus_epi32","","Convert packed 32-bit integers from `a` and `b` to packed 16-bit integers using unsigned saturation",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_cmpeq_epi64","","Compare packed 64-bit integers in `a` and `b` for equality",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_cvtepi8_epi16","","Sign extend packed 8-bit integers in `a` to packed 16-bit integers",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_cvtepi8_epi32","","Sign extend packed 8-bit integers in `a` to packed 32-bit integers",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_cvtepi8_epi64","","Sign extend packed 8-bit integers in the low 8 bytes of `a` to packed 64-bit integers",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_cvtepi16_epi32","","Sign extend packed 16-bit integers in `a` to packed 32-bit integers",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_cvtepi16_epi64","","Sign extend packed 16-bit integers in `a` to packed 64-bit integers",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_cvtepi32_epi64","","Sign extend packed 32-bit integers in `a` to packed 64-bit integers",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_cvtepu8_epi16","","Zero extend packed unsigned 8-bit integers in `a` to packed 16-bit integers",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_cvtepu8_epi32","","Zero extend packed unsigned 8-bit integers in `a` to packed 32-bit integers",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_cvtepu8_epi64","","Zero extend packed unsigned 8-bit integers in `a` to packed 64-bit integers",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_cvtepu16_epi32","","Zero extend packed unsigned 16-bit integers in `a` to packed 32-bit integers",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_cvtepu16_epi64","","Zero extend packed unsigned 16-bit integers in `a` to packed 64-bit integers",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_cvtepu32_epi64","","Zero extend packed unsigned 32-bit integers in `a` to packed 64-bit integers",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_dp_pd","","Returns the dot product of two __m128d vectors.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"},{"name":"i32"}],"output":{"name":"__m128d"}}],[5,"_mm_dp_ps","","Returns the dot product of two __m128 vectors.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"},{"name":"i32"}],"output":{"name":"__m128"}}],[5,"_mm_floor_pd","","Round the packed double-precision (64-bit) floating-point elements in `a` down to an integer value, and store the results as packed double-precision floating-point elements.",null,{"inputs":[{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_floor_ps","","Round the packed single-precision (32-bit) floating-point elements in `a` down to an integer value, and store the results as packed single-precision floating-point elements.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_floor_sd","","Round the lower double-precision (64-bit) floating-point element in `b` down to an integer value, store the result as a double-precision floating-point element in the lower element of the intrinsic result, and copy the upper element from `a` to the upper element of the intrinsic result.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_floor_ss","","Round the lower single-precision (32-bit) floating-point element in `b` down to an integer value, store the result as a single-precision floating-point element in the lower element of the intrinsic result, and copy the upper 3 packed elements from `a` to the upper elements of the intrinsic result.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_ceil_pd","","Round the packed double-precision (64-bit) floating-point elements in `a` up to an integer value, and store the results as packed double-precision floating-point elements.",null,{"inputs":[{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_ceil_ps","","Round the packed single-precision (32-bit) floating-point elements in `a` up to an integer value, and store the results as packed single-precision floating-point elements.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_ceil_sd","","Round the lower double-precision (64-bit) floating-point element in `b` up to an integer value, store the result as a double-precision floating-point element in the lower element of the intrisic result, and copy the upper element from `a` to the upper element of the intrinsic result.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_ceil_ss","","Round the lower single-precision (32-bit) floating-point element in `b` up to an integer value, store the result as a single-precision floating-point element in the lower element of the intrinsic result, and copy the upper 3 packed elements from `a` to the upper elements of the intrinsic result.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_round_pd","","Round the packed double-precision (64-bit) floating-point elements in `a` using the `rounding` parameter, and store the results as packed double-precision floating-point elements. Rounding is done according to the rounding parameter, which can be one of:",null,{"inputs":[{"name":"__m128d"},{"name":"i32"}],"output":{"name":"__m128d"}}],[5,"_mm_round_ps","","Round the packed single-precision (32-bit) floating-point elements in `a` using the `rounding` parameter, and store the results as packed single-precision floating-point elements. Rounding is done according to the rounding parameter, which can be one of:",null,{"inputs":[{"name":"__m128"},{"name":"i32"}],"output":{"name":"__m128"}}],[5,"_mm_round_sd","","Round the lower double-precision (64-bit) floating-point element in `b` using the `rounding` parameter, store the result as a double-precision floating-point element in the lower element of the intrinsic result, and copy the upper element from `a` to the upper element of the intrinsic result. Rounding is done according to the rounding parameter, which can be one of:",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"},{"name":"i32"}],"output":{"name":"__m128d"}}],[5,"_mm_round_ss","","Round the lower single-precision (32-bit) floating-point element in `b` using the `rounding` parameter, store the result as a single-precision floating-point element in the lower element of the intrinsic result, and copy the upper 3 packed elements from `a` to the upper elements of the instrinsic result. Rounding is done according to the rounding parameter, which can be one of:",null,{"inputs":[{"name":"__m128"},{"name":"__m128"},{"name":"i32"}],"output":{"name":"__m128"}}],[5,"_mm_minpos_epu16","","Finds the minimum unsigned 16-bit element in the 128-bit __m128i vector, returning a vector containing its value in its first position, and its index in its second position; all other elements are set to zero.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_mul_epi32","","Multiply the low 32-bit integers from each packed 64-bit element in `a` and `b`, and return the signed 64-bit result.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_mullo_epi32","","Multiply the packed 32-bit integers in `a` and `b`, producing intermediate 64-bit integers, and returns the lowest 32-bit, whatever they might be, reinterpreted as a signed integer. While `pmulld __m128i::splat(2), __m128i::splat(2)` returns the obvious `__m128i::splat(4)`, due to wrapping arithmetic `pmulld __m128i::splat(i32::MAX), __m128i::splat(2)` would return a negative number.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_mpsadbw_epu8","","Subtracts 8-bit unsigned integer values and computes the absolute values of the differences to the corresponding bits in the destination. Then sums of the absolute differences are returned according to the bit fields in the immediate operand.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_testz_si128","","Tests whether the specified bits in a 128-bit integer vector are all zeros.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"i32"}}],[5,"_mm_testc_si128","","Tests whether the specified bits in a 128-bit integer vector are all ones.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"i32"}}],[5,"_mm_testnzc_si128","","Tests whether the specified bits in a 128-bit integer vector are neither all zeros nor all ones.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"i32"}}],[5,"_mm_test_all_zeros","","Tests whether the specified bits in a 128-bit integer vector are all zeros.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"i32"}}],[5,"_mm_test_all_ones","","Tests whether the specified bits in `a` 128-bit integer vector are all ones.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"i32"}}],[5,"_mm_test_mix_ones_zeros","","Tests whether the specified bits in a 128-bit integer vector are neither all zeros nor all ones.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"i32"}}],[5,"_mm_cmpistrm","","Compare packed strings with implicit lengths in `a` and `b` using the control in `imm8`, and return the generated mask.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_cmpistri","","Compare packed strings with implicit lengths in `a` and `b` using the control in `imm8` and return the generated index. Similar to [`_mm_cmpestri`] with the exception that [`_mm_cmpestri`] requires the lengths of `a` and `b` to be explicitly specified.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"},{"name":"i32"}],"output":{"name":"i32"}}],[5,"_mm_cmpistrz","","Compare packed strings with implicit lengths in `a` and `b` using the control in `imm8`, and return `1` if any character in `b` was null. and `0` otherwise.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"},{"name":"i32"}],"output":{"name":"i32"}}],[5,"_mm_cmpistrc","","Compare packed strings with implicit lengths in `a` and `b` using the control in `imm8`, and return `1` if the resulting mask was non-zero, and `0` otherwise.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"},{"name":"i32"}],"output":{"name":"i32"}}],[5,"_mm_cmpistrs","","Compare packed strings with implicit lengths in `a` and `b` using the control in `imm8`, and returns `1` if any character in `a` was null, and `0` otherwise.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"},{"name":"i32"}],"output":{"name":"i32"}}],[5,"_mm_cmpistro","","Compare packed strings with implicit lengths in `a` and `b` using the control in `imm8`, and return bit `0` of the resulting bit mask.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"},{"name":"i32"}],"output":{"name":"i32"}}],[5,"_mm_cmpistra","","Compare packed strings with implicit lengths in `a` and `b` using the control in `imm8`, and return `1` if `b` did not contain a null character and the resulting mask was zero, and `0` otherwise.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"},{"name":"i32"}],"output":{"name":"i32"}}],[5,"_mm_cmpestrm","","Compare packed strings in `a` and `b` with lengths `la` and `lb` using the control in `imm8`, and return the generated mask.",null,{"inputs":[{"name":"__m128i"},{"name":"i32"},{"name":"__m128i"},{"name":"i32"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_cmpestri","","Compare packed strings `a` and `b` with lengths `la` and `lb` using the control in `imm8` and return the generated index. Similar to [`_mm_cmpistri`] with the exception that [`_mm_cmpistri`] implicitly determines the length of `a` and `b`.",null,{"inputs":[{"name":"__m128i"},{"name":"i32"},{"name":"__m128i"},{"name":"i32"},{"name":"i32"}],"output":{"name":"i32"}}],[5,"_mm_cmpestrz","","Compare packed strings in `a` and `b` with lengths `la` and `lb` using the control in `imm8`, and return `1` if any character in `b` was null, and `0` otherwise.",null,{"inputs":[{"name":"__m128i"},{"name":"i32"},{"name":"__m128i"},{"name":"i32"},{"name":"i32"}],"output":{"name":"i32"}}],[5,"_mm_cmpestrc","","Compare packed strings in `a` and `b` with lengths `la` and `lb` using the control in `imm8`, and return `1` if the resulting mask was non-zero, and `0` otherwise.",null,{"inputs":[{"name":"__m128i"},{"name":"i32"},{"name":"__m128i"},{"name":"i32"},{"name":"i32"}],"output":{"name":"i32"}}],[5,"_mm_cmpestrs","","Compare packed strings in `a` and `b` with lengths `la` and `lb` using the control in `imm8`, and return `1` if any character in a was null, and `0` otherwise.",null,{"inputs":[{"name":"__m128i"},{"name":"i32"},{"name":"__m128i"},{"name":"i32"},{"name":"i32"}],"output":{"name":"i32"}}],[5,"_mm_cmpestro","","Compare packed strings in `a` and `b` with lengths `la` and `lb` using the control in `imm8`, and return bit `0` of the resulting bit mask.",null,{"inputs":[{"name":"__m128i"},{"name":"i32"},{"name":"__m128i"},{"name":"i32"},{"name":"i32"}],"output":{"name":"i32"}}],[5,"_mm_cmpestra","","Compare packed strings in `a` and `b` with lengths `la` and `lb` using the control in `imm8`, and return `1` if `b` did not contain a null character and the resulting mask was zero, and `0` otherwise.",null,{"inputs":[{"name":"__m128i"},{"name":"i32"},{"name":"__m128i"},{"name":"i32"},{"name":"i32"}],"output":{"name":"i32"}}],[5,"_mm_crc32_u8","","Starting with the initial value in `crc`, return the accumulated CRC32 value for unsigned 8-bit integer `v`.",null,{"inputs":[{"name":"u32"},{"name":"u8"}],"output":{"name":"u32"}}],[5,"_mm_crc32_u16","","Starting with the initial value in `crc`, return the accumulated CRC32 value for unsigned 16-bit integer `v`.",null,{"inputs":[{"name":"u32"},{"name":"u16"}],"output":{"name":"u32"}}],[5,"_mm_crc32_u32","","Starting with the initial value in `crc`, return the accumulated CRC32 value for unsigned 32-bit integer `v`.",null,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"u32"}}],[5,"_mm_cmpgt_epi64","","Compare packed 64-bit integers in `a` and `b` for greater-than, return the results.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm256_add_pd","","Add packed double-precision (64-bit) floating-point elements in `a` and `b`.",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"}],"output":{"name":"__m256d"}}],[5,"_mm256_add_ps","","Add packed single-precision (32-bit) floating-point elements in `a` and `b`.",null,{"inputs":[{"name":"__m256"},{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm256_and_pd","","Compute the bitwise AND of a packed double-precision (64-bit) floating-point elements in `a` and `b`.",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"}],"output":{"name":"__m256d"}}],[5,"_mm256_and_ps","","Compute the bitwise AND of packed single-precision (32-bit) floating-point elements in `a` and `b`.",null,{"inputs":[{"name":"__m256"},{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm256_or_pd","","Compute the bitwise OR packed double-precision (64-bit) floating-point elements in `a` and `b`.",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"}],"output":{"name":"__m256d"}}],[5,"_mm256_or_ps","","Compute the bitwise OR packed single-precision (32-bit) floating-point elements in `a` and `b`.",null,{"inputs":[{"name":"__m256"},{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm256_shuffle_pd","","Shuffle double-precision (64-bit) floating-point elements within 128-bit lanes using the control in `imm8`.",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"},{"name":"i32"}],"output":{"name":"__m256d"}}],[5,"_mm256_shuffle_ps","","Shuffle single-precision (32-bit) floating-point elements in `a` within 128-bit lanes using the control in `imm8`.",null,{"inputs":[{"name":"__m256"},{"name":"__m256"},{"name":"i32"}],"output":{"name":"__m256"}}],[5,"_mm256_andnot_pd","","Compute the bitwise NOT of packed double-precision (64-bit) floating-point elements in `a` and then AND with `b`.",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"}],"output":{"name":"__m256d"}}],[5,"_mm256_andnot_ps","","Compute the bitwise NOT of packed single-precision (32-bit) floating-point elements in `a` and then AND with `b`.",null,{"inputs":[{"name":"__m256"},{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm256_max_pd","","Compare packed double-precision (64-bit) floating-point elements in `a` and `b`, and return packed maximum values",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"}],"output":{"name":"__m256d"}}],[5,"_mm256_max_ps","","Compare packed single-precision (32-bit) floating-point elements in `a` and `b`, and return packed maximum values",null,{"inputs":[{"name":"__m256"},{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm256_min_pd","","Compare packed double-precision (64-bit) floating-point elements in `a` and `b`, and return packed minimum values",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"}],"output":{"name":"__m256d"}}],[5,"_mm256_min_ps","","Compare packed single-precision (32-bit) floating-point elements in `a` and `b`, and return packed minimum values",null,{"inputs":[{"name":"__m256"},{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm256_mul_pd","","Add packed double-precision (64-bit) floating-point elements in `a` and `b`.",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"}],"output":{"name":"__m256d"}}],[5,"_mm256_mul_ps","","Add packed single-precision (32-bit) floating-point elements in `a` and `b`.",null,{"inputs":[{"name":"__m256"},{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm256_addsub_pd","","Alternatively add and subtract packed double-precision (64-bit) floating-point elements in `a` to/from packed elements in `b`.",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"}],"output":{"name":"__m256d"}}],[5,"_mm256_addsub_ps","","Alternatively add and subtract packed single-precision (32-bit) floating-point elements in `a` to/from packed elements in `b`.",null,{"inputs":[{"name":"__m256"},{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm256_sub_pd","","Subtract packed double-precision (64-bit) floating-point elements in `b` from packed elements in `a`.",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"}],"output":{"name":"__m256d"}}],[5,"_mm256_sub_ps","","Subtract packed single-precision (32-bit) floating-point elements in `b` from packed elements in `a`.",null,{"inputs":[{"name":"__m256"},{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm256_div_ps","","Compute the division of each of the 8 packed 32-bit floating-point elements in `a` by the corresponding packed elements in `b`.",null,{"inputs":[{"name":"__m256"},{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm256_div_pd","","Compute the division of each of the 4 packed 64-bit floating-point elements in `a` by the corresponding packed elements in `b`.",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"}],"output":{"name":"__m256d"}}],[5,"_mm256_round_pd","","Round packed double-precision (64-bit) floating point elements in `a` according to the flag `b`. The value of `b` may be as follows:",null,{"inputs":[{"name":"__m256d"},{"name":"i32"}],"output":{"name":"__m256d"}}],[5,"_mm256_ceil_pd","","Round packed double-precision (64-bit) floating point elements in `a` toward positive infinity.",null,{"inputs":[{"name":"__m256d"}],"output":{"name":"__m256d"}}],[5,"_mm256_floor_pd","","Round packed double-precision (64-bit) floating point elements in `a` toward negative infinity.",null,{"inputs":[{"name":"__m256d"}],"output":{"name":"__m256d"}}],[5,"_mm256_round_ps","","Round packed single-precision (32-bit) floating point elements in `a` according to the flag `b`. The value of `b` may be as follows:",null,{"inputs":[{"name":"__m256"},{"name":"i32"}],"output":{"name":"__m256"}}],[5,"_mm256_ceil_ps","","Round packed single-precision (32-bit) floating point elements in `a` toward positive infinity.",null,{"inputs":[{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm256_floor_ps","","Round packed single-precision (32-bit) floating point elements in `a` toward negative infinity.",null,{"inputs":[{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm256_sqrt_ps","","Return the square root of packed single-precision (32-bit) floating point elements in `a`.",null,{"inputs":[{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm256_sqrt_pd","","Return the square root of packed double-precision (64-bit) floating point elements in `a`.",null,{"inputs":[{"name":"__m256d"}],"output":{"name":"__m256d"}}],[5,"_mm256_blend_pd","","Blend packed double-precision (64-bit) floating-point elements from `a` and `b` using control mask `imm8`.",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"},{"name":"i32"}],"output":{"name":"__m256d"}}],[5,"_mm256_blend_ps","","Blend packed single-precision (32-bit) floating-point elements from `a` and `b` using control mask `imm8`.",null,{"inputs":[{"name":"__m256"},{"name":"__m256"},{"name":"i32"}],"output":{"name":"__m256"}}],[5,"_mm256_blendv_pd","","Blend packed double-precision (64-bit) floating-point elements from `a` and `b` using `c` as a mask.",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"},{"name":"__m256d"}],"output":{"name":"__m256d"}}],[5,"_mm256_blendv_ps","","Blend packed single-precision (32-bit) floating-point elements from `a` and `b` using `c` as a mask.",null,{"inputs":[{"name":"__m256"},{"name":"__m256"},{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm256_dp_ps","","Conditionally multiply the packed single-precision (32-bit) floating-point elements in `a` and `b` using the high 4 bits in `imm8`, sum the four products, and conditionally return the sum  using the low 4 bits of `imm8`.",null,{"inputs":[{"name":"__m256"},{"name":"__m256"},{"name":"i32"}],"output":{"name":"__m256"}}],[5,"_mm256_hadd_pd","","Horizontal addition of adjacent pairs in the two packed vectors of 4 64-bit floating points `a` and `b`. In the result, sums of elements from `a` are returned in even locations, while sums of elements from `b` are returned in odd locations.",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"}],"output":{"name":"__m256d"}}],[5,"_mm256_hadd_ps","","Horizontal addition of adjacent pairs in the two packed vectors of 8 32-bit floating points `a` and `b`. In the result, sums of elements from `a` are returned in locations of indices 0, 1, 4, 5; while sums of elements from `b` are locations 2, 3, 6, 7.",null,{"inputs":[{"name":"__m256"},{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm256_hsub_pd","","Horizontal subtraction of adjacent pairs in the two packed vectors of 4 64-bit floating points `a` and `b`. In the result, sums of elements from `a` are returned in even locations, while sums of elements from `b` are returned in odd locations.",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"}],"output":{"name":"__m256d"}}],[5,"_mm256_hsub_ps","","Horizontal subtraction of adjacent pairs in the two packed vectors of 8 32-bit floating points `a` and `b`. In the result, sums of elements from `a` are returned in locations of indices 0, 1, 4, 5; while sums of elements from `b` are locations 2, 3, 6, 7.",null,{"inputs":[{"name":"__m256"},{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm256_xor_pd","","Compute the bitwise XOR of packed double-precision (64-bit) floating-point elements in `a` and `b`.",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"}],"output":{"name":"__m256d"}}],[5,"_mm256_xor_ps","","Compute the bitwise XOR of packed single-precision (32-bit) floating-point elements in `a` and `b`.",null,{"inputs":[{"name":"__m256"},{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm_cmp_pd","","Compare packed double-precision (64-bit) floating-point elements in `a` and `b` based on the comparison operand specified by `imm8`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"},{"name":"i32"}],"output":{"name":"__m128d"}}],[5,"_mm256_cmp_pd","","Compare packed double-precision (64-bit) floating-point elements in `a` and `b` based on the comparison operand specified by `imm8`.",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"},{"name":"i32"}],"output":{"name":"__m256d"}}],[5,"_mm_cmp_ps","","Compare packed single-precision (32-bit) floating-point elements in `a` and `b` based on the comparison operand specified by `imm8`.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"},{"name":"i32"}],"output":{"name":"__m128"}}],[5,"_mm256_cmp_ps","","Compare packed single-precision (32-bit) floating-point elements in `a` and `b` based on the comparison operand specified by `imm8`.",null,{"inputs":[{"name":"__m256"},{"name":"__m256"},{"name":"i32"}],"output":{"name":"__m256"}}],[5,"_mm_cmp_sd","","Compare the lower double-precision (64-bit) floating-point element in `a` and `b` based on the comparison operand specified by `imm8`, store the result in the lower element of returned vector, and copy the upper element from `a` to the upper element of returned vector.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"},{"name":"i32"}],"output":{"name":"__m128d"}}],[5,"_mm_cmp_ss","","Compare the lower single-precision (32-bit) floating-point element in `a` and `b` based on the comparison operand specified by `imm8`, store the result in the lower element of returned vector, and copy the upper 3 packed elements from `a` to the upper elements of returned vector.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"},{"name":"i32"}],"output":{"name":"__m128"}}],[5,"_mm256_cvtepi32_pd","","Convert packed 32-bit integers in `a` to packed double-precision (64-bit) floating-point elements.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m256d"}}],[5,"_mm256_cvtepi32_ps","","Convert packed 32-bit integers in `a` to packed single-precision (32-bit) floating-point elements.",null,{"inputs":[{"name":"__m256i"}],"output":{"name":"__m256"}}],[5,"_mm256_cvtpd_ps","","Convert packed double-precision (64-bit) floating-point elements in `a` to packed single-precision (32-bit) floating-point elements.",null,{"inputs":[{"name":"__m256d"}],"output":{"name":"__m128"}}],[5,"_mm256_cvtps_epi32","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers.",null,{"inputs":[{"name":"__m256"}],"output":{"name":"__m256i"}}],[5,"_mm256_cvtps_pd","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed double-precision (64-bit) floating-point elements.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"__m256d"}}],[5,"_mm256_cvttpd_epi32","","Convert packed double-precision (64-bit) floating-point elements in `a` to packed 32-bit integers with truncation.",null,{"inputs":[{"name":"__m256d"}],"output":{"name":"__m128i"}}],[5,"_mm256_cvtpd_epi32","","Convert packed double-precision (64-bit) floating-point elements in `a` to packed 32-bit integers.",null,{"inputs":[{"name":"__m256d"}],"output":{"name":"__m128i"}}],[5,"_mm256_cvttps_epi32","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers with truncation.",null,{"inputs":[{"name":"__m256"}],"output":{"name":"__m256i"}}],[5,"_mm256_extractf128_ps","","Extract 128 bits (composed of 4 packed single-precision (32-bit) floating-point elements) from `a`, selected with `imm8`.",null,{"inputs":[{"name":"__m256"},{"name":"i32"}],"output":{"name":"__m128"}}],[5,"_mm256_extractf128_pd","","Extract 128 bits (composed of 2 packed double-precision (64-bit) floating-point elements) from `a`, selected with `imm8`.",null,{"inputs":[{"name":"__m256d"},{"name":"i32"}],"output":{"name":"__m128d"}}],[5,"_mm256_extractf128_si256","","Extract 128 bits (composed of integer data) from `a`, selected with `imm8`.",null,{"inputs":[{"name":"__m256i"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm256_zeroall","","Zero the contents of all XMM or YMM registers.",null,{"inputs":[],"output":null}],[5,"_mm256_zeroupper","","Zero the upper 128 bits of all YMM registers; the lower 128-bits of the registers are unmodified.",null,{"inputs":[],"output":null}],[5,"_mm256_permutevar_ps","","Shuffle single-precision (32-bit) floating-point elements in `a` within 128-bit lanes using the control in `b`.",null,{"inputs":[{"name":"__m256"},{"name":"__m256i"}],"output":{"name":"__m256"}}],[5,"_mm_permutevar_ps","","Shuffle single-precision (32-bit) floating-point elements in `a` using the control in `b`.",null,{"inputs":[{"name":"__m128"},{"name":"__m128i"}],"output":{"name":"__m128"}}],[5,"_mm256_permute_ps","","Shuffle single-precision (32-bit) floating-point elements in `a` within 128-bit lanes using the control in `imm8`.",null,{"inputs":[{"name":"__m256"},{"name":"i32"}],"output":{"name":"__m256"}}],[5,"_mm_permute_ps","","Shuffle single-precision (32-bit) floating-point elements in `a` using the control in `imm8`.",null,{"inputs":[{"name":"__m128"},{"name":"i32"}],"output":{"name":"__m128"}}],[5,"_mm256_permutevar_pd","","Shuffle double-precision (64-bit) floating-point elements in `a` within 256-bit lanes using the control in `b`.",null,{"inputs":[{"name":"__m256d"},{"name":"__m256i"}],"output":{"name":"__m256d"}}],[5,"_mm_permutevar_pd","","Shuffle double-precision (64-bit) floating-point elements in `a` using the control in `b`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128i"}],"output":{"name":"__m128d"}}],[5,"_mm256_permute_pd","","Shuffle double-precision (64-bit) floating-point elements in `a` within 128-bit lanes using the control in `imm8`.",null,{"inputs":[{"name":"__m256d"},{"name":"i32"}],"output":{"name":"__m256d"}}],[5,"_mm_permute_pd","","Shuffle double-precision (64-bit) floating-point elements in `a` using the control in `imm8`.",null,{"inputs":[{"name":"__m128d"},{"name":"i32"}],"output":{"name":"__m128d"}}],[5,"_mm256_permute2f128_ps","","Shuffle 256-bits (composed of 8 packed single-precision (32-bit) floating-point elements) selected by `imm8` from `a` and `b`.",null,{"inputs":[{"name":"__m256"},{"name":"__m256"},{"name":"i32"}],"output":{"name":"__m256"}}],[5,"_mm256_permute2f128_pd","","Shuffle 256-bits (composed of 4 packed double-precision (64-bit) floating-point elements) selected by `imm8` from `a` and `b`.",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"},{"name":"i32"}],"output":{"name":"__m256d"}}],[5,"_mm256_permute2f128_si256","","Shuffle 258-bits (composed of integer data) selected by `imm8` from `a` and `b`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm256_broadcast_ss","","Broadcast a single-precision (32-bit) floating-point element from memory to all elements of the returned vector.",null,{"inputs":[{"name":"f32"}],"output":{"name":"__m256"}}],[5,"_mm_broadcast_ss","","Broadcast a single-precision (32-bit) floating-point element from memory to all elements of the returned vector.",null,{"inputs":[{"name":"f32"}],"output":{"name":"__m128"}}],[5,"_mm256_broadcast_sd","","Broadcast a double-precision (64-bit) floating-point element from memory to all elements of the returned vector.",null,{"inputs":[{"name":"f64"}],"output":{"name":"__m256d"}}],[5,"_mm256_broadcast_ps","","Broadcast 128 bits from memory (composed of 4 packed single-precision (32-bit) floating-point elements) to all elements of the returned vector.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"__m256"}}],[5,"_mm256_broadcast_pd","","Broadcast 128 bits from memory (composed of 2 packed double-precision (64-bit) floating-point elements) to all elements of the returned vector.",null,{"inputs":[{"name":"__m128d"}],"output":{"name":"__m256d"}}],[5,"_mm256_insertf128_ps","","Copy `a` to result, then insert 128 bits (composed of 4 packed single-precision (32-bit) floating-point elements) from `b` into result at the location specified by `imm8`.",null,{"inputs":[{"name":"__m256"},{"name":"__m128"},{"name":"i32"}],"output":{"name":"__m256"}}],[5,"_mm256_insertf128_pd","","Copy `a` to result, then insert 128 bits (composed of 2 packed double-precision (64-bit) floating-point elements) from `b` into result at the location specified by `imm8`.",null,{"inputs":[{"name":"__m256d"},{"name":"__m128d"},{"name":"i32"}],"output":{"name":"__m256d"}}],[5,"_mm256_insertf128_si256","","Copy `a` to result, then insert 128 bits from `b` into result at the location specified by `imm8`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m128i"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm256_insert_epi8","","Copy `a` to result, and insert the 8-bit integer `i` into result at the location specified by `index`.",null,{"inputs":[{"name":"__m256i"},{"name":"i8"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm256_insert_epi16","","Copy `a` to result, and insert the 16-bit integer `i` into result at the location specified by `index`.",null,{"inputs":[{"name":"__m256i"},{"name":"i16"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm256_insert_epi32","","Copy `a` to result, and insert the 32-bit integer `i` into result at the location specified by `index`.",null,{"inputs":[{"name":"__m256i"},{"name":"i32"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm256_load_pd","","Load 256-bits (composed of 4 packed double-precision (64-bit) floating-point elements) from memory into result. `mem_addr` must be aligned on a 32-byte boundary or a general-protection exception may be generated.",null,null],[5,"_mm256_store_pd","","Store 256-bits (composed of 4 packed double-precision (64-bit) floating-point elements) from `a` into memory. `mem_addr` must be aligned on a 32-byte boundary or a general-protection exception may be generated.",null,null],[5,"_mm256_load_ps","","Load 256-bits (composed of 8 packed single-precision (32-bit) floating-point elements) from memory into result. `mem_addr` must be aligned on a 32-byte boundary or a general-protection exception may be generated.",null,null],[5,"_mm256_store_ps","","Store 256-bits (composed of 8 packed single-precision (32-bit) floating-point elements) from `a` into memory. `mem_addr` must be aligned on a 32-byte boundary or a general-protection exception may be generated.",null,null],[5,"_mm256_loadu_pd","","Load 256-bits (composed of 4 packed double-precision (64-bit) floating-point elements) from memory into result. `mem_addr` does not need to be aligned on any particular boundary.",null,null],[5,"_mm256_storeu_pd","","Store 256-bits (composed of 4 packed double-precision (64-bit) floating-point elements) from `a` into memory. `mem_addr` does not need to be aligned on any particular boundary.",null,null],[5,"_mm256_loadu_ps","","Load 256-bits (composed of 8 packed single-precision (32-bit) floating-point elements) from memory into result. `mem_addr` does not need to be aligned on any particular boundary.",null,null],[5,"_mm256_storeu_ps","","Store 256-bits (composed of 8 packed single-precision (32-bit) floating-point elements) from `a` into memory. `mem_addr` does not need to be aligned on any particular boundary.",null,null],[5,"_mm256_load_si256","","Load 256-bits of integer data from memory into result. `mem_addr` must be aligned on a 32-byte boundary or a general-protection exception may be generated.",null,null],[5,"_mm256_store_si256","","Store 256-bits of integer data from `a` into memory. `mem_addr` must be aligned on a 32-byte boundary or a general-protection exception may be generated.",null,null],[5,"_mm256_loadu_si256","","Load 256-bits of integer data from memory into result. `mem_addr` does not need to be aligned on any particular boundary.",null,null],[5,"_mm256_storeu_si256","","Store 256-bits of integer data from `a` into memory.    `mem_addr` does not need to be aligned on any particular boundary.",null,null],[5,"_mm256_maskload_pd","","Load packed double-precision (64-bit) floating-point elements from memory into result using `mask` (elements are zeroed out when the high bit of the corresponding element is not set).",null,null],[5,"_mm256_maskstore_pd","","Store packed double-precision (64-bit) floating-point elements from `a` into memory using `mask`.",null,null],[5,"_mm_maskload_pd","","Load packed double-precision (64-bit) floating-point elements from memory into result using `mask` (elements are zeroed out when the high bit of the corresponding element is not set).",null,null],[5,"_mm_maskstore_pd","","Store packed double-precision (64-bit) floating-point elements from `a` into memory using `mask`.",null,null],[5,"_mm256_maskload_ps","","Load packed single-precision (32-bit) floating-point elements from memory into result using `mask` (elements are zeroed out when the high bit of the corresponding element is not set).",null,null],[5,"_mm256_maskstore_ps","","Store packed single-precision (32-bit) floating-point elements from `a` into memory using `mask`.",null,null],[5,"_mm_maskload_ps","","Load packed single-precision (32-bit) floating-point elements from memory into result using `mask` (elements are zeroed out when the high bit of the corresponding element is not set).",null,null],[5,"_mm_maskstore_ps","","Store packed single-precision (32-bit) floating-point elements from `a` into memory using `mask`.",null,null],[5,"_mm256_movehdup_ps","","Duplicate odd-indexed single-precision (32-bit) floating-point elements from `a`, and return the results.",null,{"inputs":[{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm256_moveldup_ps","","Duplicate even-indexed single-precision (32-bit) floating-point elements from `a`, and return the results.",null,{"inputs":[{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm256_movedup_pd","","Duplicate even-indexed double-precision (64-bit) floating-point elements from \"a\", and return the results.",null,{"inputs":[{"name":"__m256d"}],"output":{"name":"__m256d"}}],[5,"_mm256_lddqu_si256","","Load 256-bits of integer data from unaligned memory into result. This intrinsic may perform better than `_mm256_loadu_si256` when the data crosses a cache line boundary.",null,null],[5,"_mm256_stream_si256","","Moves integer data from a 256-bit integer vector to a 32-byte aligned memory location. To minimize caching, the data is flagged as non-temporal (unlikely to be used again soon)",null,null],[5,"_mm256_stream_pd","","Moves double-precision values from a 256-bit vector of `[4 x double]` to a 32-byte aligned memory location. To minimize caching, the data is flagged as non-temporal (unlikely to be used again soon).",null,null],[5,"_mm256_stream_ps","","Moves single-precision floating point values from a 256-bit vector of `[8 x float]` to a 32-byte aligned memory location. To minimize caching, the data is flagged as non-temporal (unlikely to be used again soon).",null,null],[5,"_mm256_rcp_ps","","Compute the approximate reciprocal of packed single-precision (32-bit) floating-point elements in `a`, and return the results. The maximum relative error for this approximation is less than 1.5*2^-12.",null,{"inputs":[{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm256_rsqrt_ps","","Compute the approximate reciprocal square root of packed single-precision (32-bit) floating-point elements in `a`, and return the results. The maximum relative error for this approximation is less than 1.5*2^-12.",null,{"inputs":[{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm256_unpackhi_pd","","Unpack and interleave double-precision (64-bit) floating-point elements from the high half of each 128-bit lane in `a` and `b`.",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"}],"output":{"name":"__m256d"}}],[5,"_mm256_unpackhi_ps","","Unpack and interleave single-precision (32-bit) floating-point elements from the high half of each 128-bit lane in `a` and `b`.",null,{"inputs":[{"name":"__m256"},{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm256_unpacklo_pd","","Unpack and interleave double-precision (64-bit) floating-point elements from the low half of each 128-bit lane in `a` and `b`.",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"}],"output":{"name":"__m256d"}}],[5,"_mm256_unpacklo_ps","","Unpack and interleave single-precision (32-bit) floating-point elements from the low half of each 128-bit lane in `a` and `b`.",null,{"inputs":[{"name":"__m256"},{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm256_testz_si256","","Compute the bitwise AND of 256 bits (representing integer data) in `a` and `b`, and set `ZF` to 1 if the result is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, and set `CF` to 1 if the result is zero, otherwise set `CF` to 0. Return the `ZF` value.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"i32"}}],[5,"_mm256_testc_si256","","Compute the bitwise AND of 256 bits (representing integer data) in `a` and `b`, and set `ZF` to 1 if the result is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, and set `CF` to 1 if the result is zero, otherwise set `CF` to 0. Return the `CF` value.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"i32"}}],[5,"_mm256_testnzc_si256","","Compute the bitwise AND of 256 bits (representing integer data) in `a` and `b`, and set `ZF` to 1 if the result is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, and set `CF` to 1 if the result is zero, otherwise set `CF` to 0. Return 1 if both the `ZF` and `CF` values are zero, otherwise return 0.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"i32"}}],[5,"_mm256_testz_pd","","Compute the bitwise AND of 256 bits (representing double-precision (64-bit) floating-point elements) in `a` and `b`, producing an intermediate 256-bit value, and set `ZF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `ZF` value.",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"}],"output":{"name":"i32"}}],[5,"_mm256_testc_pd","","Compute the bitwise AND of 256 bits (representing double-precision (64-bit) floating-point elements) in `a` and `b`, producing an intermediate 256-bit value, and set `ZF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `CF` value.",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"}],"output":{"name":"i32"}}],[5,"_mm256_testnzc_pd","","Compute the bitwise AND of 256 bits (representing double-precision (64-bit) floating-point elements) in `a` and `b`, producing an intermediate 256-bit value, and set `ZF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return 1 if both the `ZF` and `CF` values are zero, otherwise return 0.",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"}],"output":{"name":"i32"}}],[5,"_mm_testz_pd","","Compute the bitwise AND of 128 bits (representing double-precision (64-bit) floating-point elements) in `a` and `b`, producing an intermediate 128-bit value, and set `ZF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `ZF` value.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"i32"}}],[5,"_mm_testc_pd","","Compute the bitwise AND of 128 bits (representing double-precision (64-bit) floating-point elements) in `a` and `b`, producing an intermediate 128-bit value, and set `ZF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `CF` value.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"i32"}}],[5,"_mm_testnzc_pd","","Compute the bitwise AND of 128 bits (representing double-precision (64-bit) floating-point elements) in `a` and `b`, producing an intermediate 128-bit value, and set `ZF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return 1 if both the `ZF` and `CF` values are zero, otherwise return 0.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"i32"}}],[5,"_mm256_testz_ps","","Compute the bitwise AND of 256 bits (representing single-precision (32-bit) floating-point elements) in `a` and `b`, producing an intermediate 256-bit value, and set `ZF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `ZF` value.",null,{"inputs":[{"name":"__m256"},{"name":"__m256"}],"output":{"name":"i32"}}],[5,"_mm256_testc_ps","","Compute the bitwise AND of 256 bits (representing single-precision (32-bit) floating-point elements) in `a` and `b`, producing an intermediate 256-bit value, and set `ZF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `CF` value.",null,{"inputs":[{"name":"__m256"},{"name":"__m256"}],"output":{"name":"i32"}}],[5,"_mm256_testnzc_ps","","Compute the bitwise AND of 256 bits (representing single-precision (32-bit) floating-point elements) in `a` and `b`, producing an intermediate 256-bit value, and set `ZF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return 1 if both the `ZF` and `CF` values are zero, otherwise return 0.",null,{"inputs":[{"name":"__m256"},{"name":"__m256"}],"output":{"name":"i32"}}],[5,"_mm_testz_ps","","Compute the bitwise AND of 128 bits (representing single-precision (32-bit) floating-point elements) in `a` and `b`, producing an intermediate 128-bit value, and set `ZF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `ZF` value.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"i32"}}],[5,"_mm_testc_ps","","Compute the bitwise AND of 128 bits (representing single-precision (32-bit) floating-point elements) in `a` and `b`, producing an intermediate 128-bit value, and set `ZF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `CF` value.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"i32"}}],[5,"_mm_testnzc_ps","","Compute the bitwise AND of 128 bits (representing single-precision (32-bit) floating-point elements) in `a` and `b`, producing an intermediate 128-bit value, and set `ZF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return 1 if both the `ZF` and `CF` values are zero, otherwise return 0.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"i32"}}],[5,"_mm256_movemask_pd","","Set each bit of the returned mask based on the most significant bit of the corresponding packed double-precision (64-bit) floating-point element in `a`.",null,{"inputs":[{"name":"__m256d"}],"output":{"name":"i32"}}],[5,"_mm256_movemask_ps","","Set each bit of the returned mask based on the most significant bit of the corresponding packed single-precision (32-bit) floating-point element in `a`.",null,{"inputs":[{"name":"__m256"}],"output":{"name":"i32"}}],[5,"_mm256_setzero_pd","","Return vector of type __m256d with all elements set to zero.",null,{"inputs":[],"output":{"name":"__m256d"}}],[5,"_mm256_setzero_ps","","Return vector of type __m256 with all elements set to zero.",null,{"inputs":[],"output":{"name":"__m256"}}],[5,"_mm256_setzero_si256","","Return vector of type __m256i with all elements set to zero.",null,{"inputs":[],"output":{"name":"__m256i"}}],[5,"_mm256_set_pd","","Set packed double-precision (64-bit) floating-point elements in returned vector with the supplied values.",null,{"inputs":[{"name":"f64"},{"name":"f64"},{"name":"f64"},{"name":"f64"}],"output":{"name":"__m256d"}}],[5,"_mm256_set_ps","","Set packed single-precision (32-bit) floating-point elements in returned vector with the supplied values.",null,{"inputs":[{"name":"f32"},{"name":"f32"},{"name":"f32"},{"name":"f32"},{"name":"f32"},{"name":"f32"},{"name":"f32"},{"name":"f32"}],"output":{"name":"__m256"}}],[5,"_mm256_set_epi8","","Set packed 8-bit integers in returned vector with the supplied values in reverse order.",null,{"inputs":[{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"}],"output":{"name":"__m256i"}}],[5,"_mm256_set_epi16","","Set packed 16-bit integers in returned vector with the supplied values.",null,{"inputs":[{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"}],"output":{"name":"__m256i"}}],[5,"_mm256_set_epi32","","Set packed 32-bit integers in returned vector with the supplied values.",null,{"inputs":[{"name":"i32"},{"name":"i32"},{"name":"i32"},{"name":"i32"},{"name":"i32"},{"name":"i32"},{"name":"i32"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm256_set_epi64x","","Set packed 64-bit integers in returned vector with the supplied values.",null,{"inputs":[{"name":"i64"},{"name":"i64"},{"name":"i64"},{"name":"i64"}],"output":{"name":"__m256i"}}],[5,"_mm256_setr_pd","","Set packed double-precision (64-bit) floating-point elements in returned vector with the supplied values in reverse order.",null,{"inputs":[{"name":"f64"},{"name":"f64"},{"name":"f64"},{"name":"f64"}],"output":{"name":"__m256d"}}],[5,"_mm256_setr_ps","","Set packed single-precision (32-bit) floating-point elements in returned vector with the supplied values in reverse order.",null,{"inputs":[{"name":"f32"},{"name":"f32"},{"name":"f32"},{"name":"f32"},{"name":"f32"},{"name":"f32"},{"name":"f32"},{"name":"f32"}],"output":{"name":"__m256"}}],[5,"_mm256_setr_epi8","","Set packed 8-bit integers in returned vector with the supplied values in reverse order.",null,{"inputs":[{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"}],"output":{"name":"__m256i"}}],[5,"_mm256_setr_epi16","","Set packed 16-bit integers in returned vector with the supplied values in reverse order.",null,{"inputs":[{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"}],"output":{"name":"__m256i"}}],[5,"_mm256_setr_epi32","","Set packed 32-bit integers in returned vector with the supplied values in reverse order.",null,{"inputs":[{"name":"i32"},{"name":"i32"},{"name":"i32"},{"name":"i32"},{"name":"i32"},{"name":"i32"},{"name":"i32"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm256_setr_epi64x","","Set packed 64-bit integers in returned vector with the supplied values in reverse order.",null,{"inputs":[{"name":"i64"},{"name":"i64"},{"name":"i64"},{"name":"i64"}],"output":{"name":"__m256i"}}],[5,"_mm256_set1_pd","","Broadcast double-precision (64-bit) floating-point value `a` to all elements of returned vector.",null,{"inputs":[{"name":"f64"}],"output":{"name":"__m256d"}}],[5,"_mm256_set1_ps","","Broadcast single-precision (32-bit) floating-point value `a` to all elements of returned vector.",null,{"inputs":[{"name":"f32"}],"output":{"name":"__m256"}}],[5,"_mm256_set1_epi8","","Broadcast 8-bit integer `a` to all elements of returned vector. This intrinsic may generate the `vpbroadcastb`.",null,{"inputs":[{"name":"i8"}],"output":{"name":"__m256i"}}],[5,"_mm256_set1_epi16","","Broadcast 16-bit integer `a` to all all elements of returned vector. This intrinsic may generate the `vpbroadcastw`.",null,{"inputs":[{"name":"i16"}],"output":{"name":"__m256i"}}],[5,"_mm256_set1_epi32","","Broadcast 32-bit integer `a` to all elements of returned vector. This intrinsic may generate the `vpbroadcastd`.",null,{"inputs":[{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm256_set1_epi64x","","Broadcast 64-bit integer `a` to all elements of returned vector. This intrinsic may generate the `vpbroadcastq`.",null,{"inputs":[{"name":"i64"}],"output":{"name":"__m256i"}}],[5,"_mm256_castpd_ps","","Cast vector of type __m256d to type __m256.",null,{"inputs":[{"name":"__m256d"}],"output":{"name":"__m256"}}],[5,"_mm256_castps_pd","","Cast vector of type __m256 to type __m256d.",null,{"inputs":[{"name":"__m256"}],"output":{"name":"__m256d"}}],[5,"_mm256_castps_si256","","Casts vector of type __m256 to type __m256i.",null,{"inputs":[{"name":"__m256"}],"output":{"name":"__m256i"}}],[5,"_mm256_castsi256_ps","","Casts vector of type __m256i to type __m256.",null,{"inputs":[{"name":"__m256i"}],"output":{"name":"__m256"}}],[5,"_mm256_castpd_si256","","Casts vector of type __m256d to type __m256i.",null,{"inputs":[{"name":"__m256d"}],"output":{"name":"__m256i"}}],[5,"_mm256_castsi256_pd","","Casts vector of type __m256i to type __m256d.",null,{"inputs":[{"name":"__m256i"}],"output":{"name":"__m256d"}}],[5,"_mm256_castps256_ps128","","Casts vector of type __m256 to type __m128.",null,{"inputs":[{"name":"__m256"}],"output":{"name":"__m128"}}],[5,"_mm256_castpd256_pd128","","Casts vector of type __m256d to type __m128d.",null,{"inputs":[{"name":"__m256d"}],"output":{"name":"__m128d"}}],[5,"_mm256_castsi256_si128","","Casts vector of type __m256i to type __m128i.",null,{"inputs":[{"name":"__m256i"}],"output":{"name":"__m128i"}}],[5,"_mm256_castps128_ps256","","Casts vector of type __m128 to type __m256; the upper 128 bits of the result are undefined.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"__m256"}}],[5,"_mm256_castpd128_pd256","","Casts vector of type __m128d to type __m256d; the upper 128 bits of the result are undefined.",null,{"inputs":[{"name":"__m128d"}],"output":{"name":"__m256d"}}],[5,"_mm256_castsi128_si256","","Casts vector of type __m128i to type __m256i; the upper 128 bits of the result are undefined.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm256_zextps128_ps256","","Constructs a 256-bit floating-point vector of `[8 x float]` from a 128-bit floating-point vector of `[4 x float]`. The lower 128 bits contain the value of the source vector. The upper 128 bits are set to zero.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"__m256"}}],[5,"_mm256_zextsi128_si256","","Constructs a 256-bit integer vector from a 128-bit integer vector. The lower 128 bits contain the value of the source vector. The upper 128 bits are set to zero.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm256_zextpd128_pd256","","Constructs a 256-bit floating-point vector of `[4 x double]` from a 128-bit floating-point vector of `[2 x double]`. The lower 128 bits contain the value of the source vector. The upper 128 bits are set to zero.",null,{"inputs":[{"name":"__m128d"}],"output":{"name":"__m256d"}}],[5,"_mm256_undefined_ps","","Return vector of type `__m256` with undefined elements.",null,{"inputs":[],"output":{"name":"__m256"}}],[5,"_mm256_undefined_pd","","Return vector of type `__m256d` with undefined elements.",null,{"inputs":[],"output":{"name":"__m256d"}}],[5,"_mm256_undefined_si256","","Return vector of type __m256i with undefined elements.",null,{"inputs":[],"output":{"name":"__m256i"}}],[5,"_mm256_set_m128","","Set packed __m256 returned vector with the supplied values.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m256"}}],[5,"_mm256_set_m128d","","Set packed __m256d returned vector with the supplied values.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m256d"}}],[5,"_mm256_set_m128i","","Set packed __m256i returned vector with the supplied values.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm256_setr_m128","","Set packed __m256 returned vector with the supplied values.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m256"}}],[5,"_mm256_setr_m128d","","Set packed __m256d returned vector with the supplied values.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m256d"}}],[5,"_mm256_setr_m128i","","Set packed __m256i returned vector with the supplied values.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm256_loadu2_m128","","Load two 128-bit values (composed of 4 packed single-precision (32-bit) floating-point elements) from memory, and combine them into a 256-bit value. `hiaddr` and `loaddr` do not need to be aligned on any particular boundary.",null,null],[5,"_mm256_loadu2_m128d","","Load two 128-bit values (composed of 2 packed double-precision (64-bit) floating-point elements) from memory, and combine them into a 256-bit value. `hiaddr` and `loaddr` do not need to be aligned on any particular boundary.",null,null],[5,"_mm256_loadu2_m128i","","Load two 128-bit values (composed of integer data) from memory, and combine them into a 256-bit value. `hiaddr` and `loaddr` do not need to be aligned on any particular boundary.",null,null],[5,"_mm256_storeu2_m128","","Store the high and low 128-bit halves (each composed of 4 packed single-precision (32-bit) floating-point elements) from `a` into memory two different 128-bit locations. `hiaddr` and `loaddr` do not need to be aligned on any particular boundary.",null,null],[5,"_mm256_storeu2_m128d","","Store the high and low 128-bit halves (each composed of 2 packed double-precision (64-bit) floating-point elements) from `a` into memory two different 128-bit locations. `hiaddr` and `loaddr` do not need to be aligned on any particular boundary.",null,null],[5,"_mm256_storeu2_m128i","","Store the high and low 128-bit halves (each composed of integer data) from `a` into memory two different 128-bit locations. `hiaddr` and `loaddr` do not need to be aligned on any particular boundary.",null,null],[5,"_mm256_cvtss_f32","","Returns the first element of the input vector of `[8 x float]`.",null,{"inputs":[{"name":"__m256"}],"output":{"name":"f32"}}],[5,"_mm256_abs_epi32","","Computes the absolute values of packed 32-bit integers in `a`.",null,{"inputs":[{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_abs_epi16","","Computes the absolute values of packed 16-bit integers in `a`.",null,{"inputs":[{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_abs_epi8","","Computes the absolute values of packed 8-bit integers in `a`.",null,{"inputs":[{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_add_epi64","","Add packed 64-bit integers in `a` and `b`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_add_epi32","","Add packed 32-bit integers in `a` and `b`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_add_epi16","","Add packed 16-bit integers in `a` and `b`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_add_epi8","","Add packed 8-bit integers in `a` and `b`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_adds_epi8","","Add packed 8-bit integers in `a` and `b` using saturation.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_adds_epi16","","Add packed 16-bit integers in `a` and `b` using saturation.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_adds_epu8","","Add packed unsigned 8-bit integers in `a` and `b` using saturation.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_adds_epu16","","Add packed unsigned 16-bit integers in `a` and `b` using saturation.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_alignr_epi8","","Concatenate pairs of 16-byte blocks in `a` and `b` into a 32-byte temporary result, shift the result right by `n` bytes, and return the low 16 bytes.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm256_and_si256","","Compute the bitwise AND of 256 bits (representing integer data) in `a` and `b`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_andnot_si256","","Compute the bitwise NOT of 256 bits (representing integer data) in `a` and then AND with `b`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_avg_epu16","","Average packed unsigned 16-bit integers in `a` and `b`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_avg_epu8","","Average packed unsigned 8-bit integers in `a` and `b`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm_blend_epi32","","Blend packed 32-bit integers from `a` and `b` using control mask `imm8`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm256_blend_epi32","","Blend packed 32-bit integers from `a` and `b` using control mask `imm8`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm256_blend_epi16","","Blend packed 16-bit integers from `a` and `b` using control mask `imm8`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm256_blendv_epi8","","Blend packed 8-bit integers from `a` and `b` using `mask`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm_broadcastb_epi8","","Broadcast the low packed 8-bit integer from `a` to all elements of the 128-bit returned value.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm256_broadcastb_epi8","","Broadcast the low packed 8-bit integer from `a` to all elements of the 256-bit returned value.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm_broadcastd_epi32","","Broadcast the low packed 32-bit integer from `a` to all elements of the 128-bit returned value.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm256_broadcastd_epi32","","Broadcast the low packed 32-bit integer from `a` to all elements of the 256-bit returned value.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm_broadcastq_epi64","","Broadcast the low packed 64-bit integer from `a` to all elements of the 128-bit returned value.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm256_broadcastq_epi64","","Broadcast the low packed 64-bit integer from `a` to all elements of the 256-bit returned value.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm_broadcastsd_pd","","Broadcast the low double-precision (64-bit) floating-point element from `a` to all elements of the 128-bit returned value.",null,{"inputs":[{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm256_broadcastsd_pd","","Broadcast the low double-precision (64-bit) floating-point element from `a` to all elements of the 256-bit returned value.",null,{"inputs":[{"name":"__m128d"}],"output":{"name":"__m256d"}}],[5,"_mm256_broadcastsi128_si256","","Broadcast 128 bits of integer data from a to all 128-bit lanes in the 256-bit returned value.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm_broadcastss_ps","","Broadcast the low single-precision (32-bit) floating-point element from `a` to all elements of the 128-bit returned value.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm256_broadcastss_ps","","Broadcast the low single-precision (32-bit) floating-point element from `a` to all elements of the 256-bit returned value.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"__m256"}}],[5,"_mm_broadcastw_epi16","","Broadcast the low packed 16-bit integer from a to all elements of the 128-bit returned value",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm256_broadcastw_epi16","","Broadcast the low packed 16-bit integer from a to all elements of the 256-bit returned value",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm256_cmpeq_epi64","","Compare packed 64-bit integers in `a` and `b` for equality.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_cmpeq_epi32","","Compare packed 32-bit integers in `a` and `b` for equality.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_cmpeq_epi16","","Compare packed 16-bit integers in `a` and `b` for equality.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_cmpeq_epi8","","Compare packed 8-bit integers in `a` and `b` for equality.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_cmpgt_epi64","","Compare packed 64-bit integers in `a` and `b` for greater-than.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_cmpgt_epi32","","Compare packed 32-bit integers in `a` and `b` for greater-than.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_cmpgt_epi16","","Compare packed 16-bit integers in `a` and `b` for greater-than.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_cmpgt_epi8","","Compare packed 8-bit integers in `a` and `b` for greater-than.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_cvtepi16_epi32","","Sign-extend 16-bit integers to 32-bit integers.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm256_cvtepi16_epi64","","Sign-extend 16-bit integers to 64-bit integers.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm256_cvtepi32_epi64","","Sign-extend 32-bit integers to 64-bit integers.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm256_cvtepi8_epi16","","Sign-extend 8-bit integers to 16-bit integers.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm256_cvtepi8_epi32","","Sign-extend 8-bit integers to 32-bit integers.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm256_cvtepi8_epi64","","Sign-extend 8-bit integers to 64-bit integers.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm256_cvtepu16_epi32","","Zero extend packed unsigned 16-bit integers in `a` to packed 32-bit integers, and store the results in dst.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm256_cvtepu16_epi64","","Zero-extend the lower four unsigned 16-bit integers in `a` to 64-bit integers. The upper four elements of `a` are unused.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm256_cvtepu32_epi64","","Zero-extend unsigned 32-bit integers in `a` to 64-bit integers.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm256_cvtepu8_epi16","","Zero-extend unsigned 8-bit integers in `a` to 16-bit integers.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm256_cvtepu8_epi32","","Zero-extend the lower eight unsigned 8-bit integers in `a` to 32-bit integers. The upper eight elements of `a` are unused.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm256_cvtepu8_epi64","","Zero-extend the lower four unsigned 8-bit integers in `a` to 64-bit integers. The upper twelve elements of `a` are unused.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm256_extracti128_si256","","Extract 128 bits (of integer data) from `a` selected with `imm8`.",null,{"inputs":[{"name":"__m256i"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm256_hadd_epi16","","Horizontally add adjacent pairs of 16-bit integers in `a` and `b`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_hadd_epi32","","Horizontally add adjacent pairs of 32-bit integers in `a` and `b`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_hadds_epi16","","Horizontally add adjacent pairs of 16-bit integers in `a` and `b` using saturation.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_hsub_epi16","","Horizontally subtract adjacent pairs of 16-bit integers in `a` and `b`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_hsub_epi32","","Horizontally subtract adjacent pairs of 32-bit integers in `a` and `b`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_hsubs_epi16","","Horizontally subtract adjacent pairs of 16-bit integers in `a` and `b` using saturation.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm_i32gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm_mask_i32gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm256_i32gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm256_mask_i32gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm_i32gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm_mask_i32gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm256_i32gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm256_mask_i32gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm_i32gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm_mask_i32gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm256_i32gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm256_mask_i32gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm_i32gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm_mask_i32gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm256_i32gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm256_mask_i32gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm_i64gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm_mask_i64gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm256_i64gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm256_mask_i64gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm_i64gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm_mask_i64gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm256_i64gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm256_mask_i64gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm_i64gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm_mask_i64gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm256_i64gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm256_mask_i64gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm_i64gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm_mask_i64gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm256_i64gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm256_mask_i64gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm256_inserti128_si256","","Copy `a` to `dst`, then insert 128 bits (of integer data) from `b` at the location specified by `imm8`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m128i"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm256_madd_epi16","","Multiply packed signed 16-bit integers in `a` and `b`, producing intermediate signed 32-bit integers. Horizontally add adjacent pairs of intermediate 32-bit integers.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_maddubs_epi16","","Vertically multiply each unsigned 8-bit integer from `a` with the corresponding signed 8-bit integer from `b`, producing intermediate signed 16-bit integers. Horizontally add adjacent pairs of intermediate signed 16-bit integers",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm_maskload_epi32","","Load packed 32-bit integers from memory pointed by `mem_addr` using `mask` (elements are zeroed out when the highest bit is not set in the corresponding element).",null,null],[5,"_mm256_maskload_epi32","","Load packed 32-bit integers from memory pointed by `mem_addr` using `mask` (elements are zeroed out when the highest bit is not set in the corresponding element).",null,null],[5,"_mm_maskload_epi64","","Load packed 64-bit integers from memory pointed by `mem_addr` using `mask` (elements are zeroed out when the highest bit is not set in the corresponding element).",null,null],[5,"_mm256_maskload_epi64","","Load packed 64-bit integers from memory pointed by `mem_addr` using `mask` (elements are zeroed out when the highest bit is not set in the corresponding element).",null,null],[5,"_mm_maskstore_epi32","","Store packed 32-bit integers from `a` into memory pointed by `mem_addr` using `mask` (elements are not stored when the highest bit is not set in the corresponding element).",null,null],[5,"_mm256_maskstore_epi32","","Store packed 32-bit integers from `a` into memory pointed by `mem_addr` using `mask` (elements are not stored when the highest bit is not set in the corresponding element).",null,null],[5,"_mm_maskstore_epi64","","Store packed 64-bit integers from `a` into memory pointed by `mem_addr` using `mask` (elements are not stored when the highest bit is not set in the corresponding element).",null,null],[5,"_mm256_maskstore_epi64","","Store packed 64-bit integers from `a` into memory pointed by `mem_addr` using `mask` (elements are not stored when the highest bit is not set in the corresponding element).",null,null],[5,"_mm256_max_epi16","","Compare packed 16-bit integers in `a` and `b`, and return the packed maximum values.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_max_epi32","","Compare packed 32-bit integers in `a` and `b`, and return the packed maximum values.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_max_epi8","","Compare packed 8-bit integers in `a` and `b`, and return the packed maximum values.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_max_epu16","","Compare packed unsigned 16-bit integers in `a` and `b`, and return the packed maximum values.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_max_epu32","","Compare packed unsigned 32-bit integers in `a` and `b`, and return the packed maximum values.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_max_epu8","","Compare packed unsigned 8-bit integers in `a` and `b`, and return the packed maximum values.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_min_epi16","","Compare packed 16-bit integers in `a` and `b`, and return the packed minimum values.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_min_epi32","","Compare packed 32-bit integers in `a` and `b`, and return the packed minimum values.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_min_epi8","","Compare packed 8-bit integers in `a` and `b`, and return the packed minimum values.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_min_epu16","","Compare packed unsigned 16-bit integers in `a` and `b`, and return the packed minimum values.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_min_epu32","","Compare packed unsigned 32-bit integers in `a` and `b`, and return the packed minimum values.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_min_epu8","","Compare packed unsigned 8-bit integers in `a` and `b`, and return the packed minimum values.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_movemask_epi8","","Create mask from the most significant bit of each 8-bit element in `a`, return the result.",null,{"inputs":[{"name":"__m256i"}],"output":{"name":"i32"}}],[5,"_mm256_mpsadbw_epu8","","Compute the sum of absolute differences (SADs) of quadruplets of unsigned 8-bit integers in `a` compared to those in `b`, and store the 16-bit results in dst. Eight SADs are performed for each 128-bit lane using one quadruplet from `b` and eight quadruplets from `a`. One quadruplet is selected from `b` starting at on the offset specified in `imm8`. Eight quadruplets are formed from sequential 8-bit integers selected from `a` starting at the offset specified in `imm8`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm256_mul_epi32","","Multiply the low 32-bit integers from each packed 64-bit element in `a` and `b`",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_mul_epu32","","Multiply the low unsigned 32-bit integers from each packed 64-bit element in `a` and `b`",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_mulhi_epi16","","Multiply the packed 16-bit integers in `a` and `b`, producing intermediate 32-bit integers and returning the high 16 bits of the intermediate integers.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_mulhi_epu16","","Multiply the packed unsigned 16-bit integers in `a` and `b`, producing intermediate 32-bit integers and returning the high 16 bits of the intermediate integers.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_mullo_epi16","","Multiply the packed 16-bit integers in `a` and `b`, producing intermediate 32-bit integers, and return the low 16 bits of the intermediate integers",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_mullo_epi32","","Multiply the packed 32-bit integers in `a` and `b`, producing intermediate 64-bit integers, and return the low 16 bits of the intermediate integers",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_mulhrs_epi16","","Multiply packed 16-bit integers in `a` and `b`, producing intermediate signed 32-bit integers. Truncate each intermediate integer to the 18 most significant bits, round by adding 1, and return bits `[16:1]`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_or_si256","","Compute the bitwise OR of 256 bits (representing integer data) in `a` and `b`",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_packs_epi16","","Convert packed 16-bit integers from `a` and `b` to packed 8-bit integers using signed saturation",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_packs_epi32","","Convert packed 32-bit integers from `a` and `b` to packed 16-bit integers using signed saturation",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_packus_epi16","","Convert packed 16-bit integers from `a` and `b` to packed 8-bit integers using unsigned saturation",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_packus_epi32","","Convert packed 32-bit integers from `a` and `b` to packed 16-bit integers using unsigned saturation",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_permutevar8x32_epi32","","Permutes packed 32-bit integers from `a` according to the content of `b`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_permute4x64_epi64","","Permutes 64-bit integers from `a` using control mask `imm8`.",null,{"inputs":[{"name":"__m256i"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm256_permute2x128_si256","","Shuffle 128-bits of integer data selected by `imm8` from `a` and `b`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm256_permute4x64_pd","","Shuffle 64-bit floating-point elements in `a` across lanes using the control in `imm8`.",null,{"inputs":[{"name":"__m256d"},{"name":"i32"}],"output":{"name":"__m256d"}}],[5,"_mm256_permutevar8x32_ps","","Shuffle eight 32-bit foating-point elements in `a` across lanes using the corresponding 32-bit integer index in `idx`.",null,{"inputs":[{"name":"__m256"},{"name":"__m256i"}],"output":{"name":"__m256"}}],[5,"_mm256_sad_epu8","","Compute the absolute differences of packed unsigned 8-bit integers in `a` and `b`, then horizontally sum each consecutive 8 differences to produce four unsigned 16-bit integers, and pack these unsigned 16-bit integers in the low 16 bits of the 64-bit return value",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_shuffle_epi8","","Shuffle bytes from `a` according to the content of `b`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_shuffle_epi32","","Shuffle 32-bit integers in 128-bit lanes of `a` using the control in `imm8`.",null,{"inputs":[{"name":"__m256i"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm256_shufflehi_epi16","","Shuffle 16-bit integers in the high 64 bits of 128-bit lanes of `a` using the control in `imm8`. The low 64 bits of 128-bit lanes of `a` are copied to the output.",null,{"inputs":[{"name":"__m256i"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm256_shufflelo_epi16","","Shuffle 16-bit integers in the low 64 bits of 128-bit lanes of `a` using the control in `imm8`. The high 64 bits of 128-bit lanes of `a` are copied to the output.",null,{"inputs":[{"name":"__m256i"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm256_sign_epi16","","Negate packed 16-bit integers in `a` when the corresponding signed 16-bit integer in `b` is negative, and return the results. Results are zeroed out when the corresponding element in `b` is zero.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_sign_epi32","","Negate packed 32-bit integers in `a` when the corresponding signed 32-bit integer in `b` is negative, and return the results. Results are zeroed out when the corresponding element in `b` is zero.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_sign_epi8","","Negate packed 8-bit integers in `a` when the corresponding signed 8-bit integer in `b` is negative, and return the results. Results are zeroed out when the corresponding element in `b` is zero.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_sll_epi16","","Shift packed 16-bit integers in `a` left by `count` while shifting in zeros, and return the result",null,{"inputs":[{"name":"__m256i"},{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm256_sll_epi32","","Shift packed 32-bit integers in `a` left by `count` while shifting in zeros, and return the result",null,{"inputs":[{"name":"__m256i"},{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm256_sll_epi64","","Shift packed 64-bit integers in `a` left by `count` while shifting in zeros, and return the result",null,{"inputs":[{"name":"__m256i"},{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm256_slli_epi16","","Shift packed 16-bit integers in `a` left by `imm8` while shifting in zeros, return the results;",null,{"inputs":[{"name":"__m256i"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm256_slli_epi32","","Shift packed 32-bit integers in `a` left by `imm8` while shifting in zeros, return the results;",null,{"inputs":[{"name":"__m256i"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm256_slli_epi64","","Shift packed 64-bit integers in `a` left by `imm8` while shifting in zeros, return the results;",null,{"inputs":[{"name":"__m256i"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm256_slli_si256","","Shift 128-bit lanes in `a` left by `imm8` bytes while shifting in zeros.",null,{"inputs":[{"name":"__m256i"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm256_bslli_epi128","","Shift 128-bit lanes in `a` left by `imm8` bytes while shifting in zeros.",null,{"inputs":[{"name":"__m256i"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm_sllv_epi32","","Shift packed 32-bit integers in `a` left by the amount specified by the corresponding element in `count` while shifting in zeros, and return the result.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm256_sllv_epi32","","Shift packed 32-bit integers in `a` left by the amount specified by the corresponding element in `count` while shifting in zeros, and return the result.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm_sllv_epi64","","Shift packed 64-bit integers in `a` left by the amount specified by the corresponding element in `count` while shifting in zeros, and return the result.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm256_sllv_epi64","","Shift packed 64-bit integers in `a` left by the amount specified by the corresponding element in `count` while shifting in zeros, and return the result.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_sra_epi16","","Shift packed 16-bit integers in `a` right by `count` while shifting in sign bits.",null,{"inputs":[{"name":"__m256i"},{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm256_sra_epi32","","Shift packed 32-bit integers in `a` right by `count` while shifting in sign bits.",null,{"inputs":[{"name":"__m256i"},{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm256_srai_epi16","","Shift packed 16-bit integers in `a` right by `imm8` while shifting in sign bits.",null,{"inputs":[{"name":"__m256i"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm256_srai_epi32","","Shift packed 32-bit integers in `a` right by `imm8` while shifting in sign bits.",null,{"inputs":[{"name":"__m256i"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm_srav_epi32","","Shift packed 32-bit integers in `a` right by the amount specified by the corresponding element in `count` while shifting in sign bits.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm256_srav_epi32","","Shift packed 32-bit integers in `a` right by the amount specified by the corresponding element in `count` while shifting in sign bits.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_srli_si256","","Shift 128-bit lanes in `a` right by `imm8` bytes while shifting in zeros.",null,{"inputs":[{"name":"__m256i"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm256_bsrli_epi128","","Shift 128-bit lanes in `a` right by `imm8` bytes while shifting in zeros.",null,{"inputs":[{"name":"__m256i"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm256_srl_epi16","","Shift packed 16-bit integers in `a` right by `count` while shifting in zeros.",null,{"inputs":[{"name":"__m256i"},{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm256_srl_epi32","","Shift packed 32-bit integers in `a` right by `count` while shifting in zeros.",null,{"inputs":[{"name":"__m256i"},{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm256_srl_epi64","","Shift packed 64-bit integers in `a` right by `count` while shifting in zeros.",null,{"inputs":[{"name":"__m256i"},{"name":"__m128i"}],"output":{"name":"__m256i"}}],[5,"_mm256_srli_epi16","","Shift packed 16-bit integers in `a` right by `imm8` while shifting in zeros",null,{"inputs":[{"name":"__m256i"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm256_srli_epi32","","Shift packed 32-bit integers in `a` right by `imm8` while shifting in zeros",null,{"inputs":[{"name":"__m256i"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm256_srli_epi64","","Shift packed 64-bit integers in `a` right by `imm8` while shifting in zeros",null,{"inputs":[{"name":"__m256i"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_mm_srlv_epi32","","Shift packed 32-bit integers in `a` right by the amount specified by the corresponding element in `count` while shifting in zeros,",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm256_srlv_epi32","","Shift packed 32-bit integers in `a` right by the amount specified by the corresponding element in `count` while shifting in zeros,",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm_srlv_epi64","","Shift packed 64-bit integers in `a` right by the amount specified by the corresponding element in `count` while shifting in zeros,",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm256_srlv_epi64","","Shift packed 64-bit integers in `a` right by the amount specified by the corresponding element in `count` while shifting in zeros,",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_sub_epi16","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a`",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_sub_epi32","","Subtract packed 32-bit integers in `b` from packed 16-bit integers in `a`",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_sub_epi64","","Subtract packed 64-bit integers in `b` from packed 16-bit integers in `a`",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_sub_epi8","","Subtract packed 8-bit integers in `b` from packed 16-bit integers in `a`",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_subs_epi16","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a` using saturation.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_subs_epi8","","Subtract packed 8-bit integers in `b` from packed 8-bit integers in `a` using saturation.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_subs_epu16","","Subtract packed unsigned 16-bit integers in `b` from packed 16-bit integers in `a` using saturation.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_subs_epu8","","Subtract packed unsigned 8-bit integers in `b` from packed 8-bit integers in `a` using saturation.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_unpackhi_epi8","","Unpack and interleave 8-bit integers from the high half of each 128-bit lane in `a` and `b`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_unpacklo_epi8","","Unpack and interleave 8-bit integers from the low half of each 128-bit lane of `a` and `b`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_unpackhi_epi16","","Unpack and interleave 16-bit integers from the high half of each 128-bit lane of `a` and `b`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_unpacklo_epi16","","Unpack and interleave 16-bit integers from the low half of each 128-bit lane of `a` and `b`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_unpackhi_epi32","","Unpack and interleave 32-bit integers from the high half of each 128-bit lane of `a` and `b`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_unpacklo_epi32","","Unpack and interleave 32-bit integers from the low half of each 128-bit lane of `a` and `b`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_unpackhi_epi64","","Unpack and interleave 64-bit integers from the high half of each 128-bit lane of `a` and `b`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_unpacklo_epi64","","Unpack and interleave 64-bit integers from the low half of each 128-bit lane of `a` and `b`.",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_xor_si256","","Compute the bitwise XOR of 256 bits (representing integer data) in `a` and `b`",null,{"inputs":[{"name":"__m256i"},{"name":"__m256i"}],"output":{"name":"__m256i"}}],[5,"_mm256_extract_epi8","","Extract an 8-bit integer from `a`, selected with `imm8`. Returns a 32-bit integer containing the zero-extended integer data.",null,{"inputs":[{"name":"__m256i"},{"name":"i32"}],"output":{"name":"i8"}}],[5,"_mm256_extract_epi16","","Extract a 16-bit integer from `a`, selected with `imm8`. Returns a 32-bit integer containing the zero-extended integer data.",null,{"inputs":[{"name":"__m256i"},{"name":"i32"}],"output":{"name":"i16"}}],[5,"_mm256_extract_epi32","","Extract a 32-bit integer from `a`, selected with `imm8`.",null,{"inputs":[{"name":"__m256i"},{"name":"i32"}],"output":{"name":"i32"}}],[5,"_mm256_cvtsd_f64","","Returns the first element of the input vector of `[4 x double]`.",null,{"inputs":[{"name":"__m256d"}],"output":{"name":"f64"}}],[5,"_mm256_cvtsi256_si32","","Returns the first element of the input vector of `[8 x i32]`.",null,{"inputs":[{"name":"__m256i"}],"output":{"name":"i32"}}],[5,"_mm_fmadd_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and add the intermediate result to packed elements in `c`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm256_fmadd_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and add the intermediate result to packed elements in `c`.",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"},{"name":"__m256d"}],"output":{"name":"__m256d"}}],[5,"_mm_fmadd_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and add the intermediate result to packed elements in `c`.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm256_fmadd_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and add the intermediate result to packed elements in `c`.",null,{"inputs":[{"name":"__m256"},{"name":"__m256"},{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm_fmadd_sd","","Multiply the lower double-precision (64-bit) floating-point elements in `a` and `b`, and add the intermediate result to the lower element in `c`. Store the result in the lower element of the returned value, and copy the upper element from `a` to the upper elements of the result.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_fmadd_ss","","Multiply the lower single-precision (32-bit) floating-point elements in `a` and `b`, and add the intermediate result to the lower element in `c`. Store the result in the lower element of the returned value, and copy the 3 upper elements from `a` to the upper elements of the result.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_fmaddsub_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and alternatively add and subtract packed elements in `c` to/from the intermediate result.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm256_fmaddsub_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and alternatively add and subtract packed elements in `c` to/from the intermediate result.",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"},{"name":"__m256d"}],"output":{"name":"__m256d"}}],[5,"_mm_fmaddsub_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and alternatively add and subtract packed elements in `c` to/from the intermediate result.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm256_fmaddsub_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and alternatively add and subtract packed elements in `c` to/from the intermediate result.",null,{"inputs":[{"name":"__m256"},{"name":"__m256"},{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm_fmsub_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the intermediate result.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm256_fmsub_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the intermediate result.",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"},{"name":"__m256d"}],"output":{"name":"__m256d"}}],[5,"_mm_fmsub_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the intermediate result.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm256_fmsub_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the intermediate result.",null,{"inputs":[{"name":"__m256"},{"name":"__m256"},{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm_fmsub_sd","","Multiply the lower double-precision (64-bit) floating-point elements in `a` and `b`, and subtract the lower element in `c` from the intermediate result. Store the result in the lower element of the returned value, and copy the upper element from `a` to the upper elements of the result.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_fmsub_ss","","Multiply the lower single-precision (32-bit) floating-point elements in `a` and `b`,  and subtract the lower element in `c` from the intermediate result. Store the result in the lower element of the returned value, and copy the 3 upper elements from `a` to the upper elements of the result.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_fmsubadd_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and alternatively subtract and add packed elements in `c` from/to the intermediate result.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm256_fmsubadd_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and alternatively subtract and add packed elements in `c` from/to the intermediate result.",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"},{"name":"__m256d"}],"output":{"name":"__m256d"}}],[5,"_mm_fmsubadd_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and alternatively subtract and add packed elements in `c` from/to the intermediate result.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm256_fmsubadd_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and alternatively subtract and add packed elements in `c` from/to the intermediate result.",null,{"inputs":[{"name":"__m256"},{"name":"__m256"},{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm_fnmadd_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and add the negated intermediate result to packed elements in `c`.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm256_fnmadd_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and add the negated intermediate result to packed elements in `c`.",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"},{"name":"__m256d"}],"output":{"name":"__m256d"}}],[5,"_mm_fnmadd_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and add the negated intermediate result to packed elements in `c`.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm256_fnmadd_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and add the negated intermediate result to packed elements in `c`.",null,{"inputs":[{"name":"__m256"},{"name":"__m256"},{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm_fnmadd_sd","","Multiply the lower double-precision (64-bit) floating-point elements in `a` and `b`, and add the negated intermediate result to the lower element in `c`. Store the result in the lower element of the returned value, and copy the upper element from `a` to the upper elements of the result.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_fnmadd_ss","","Multiply the lower single-precision (32-bit) floating-point elements in `a` and `b`, and add the negated intermediate result to the lower element in `c`. Store the result in the lower element of the returned value, and copy the 3 upper elements from `a` to the upper elements of the result.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm_fnmsub_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the negated intermediate result.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm256_fnmsub_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the negated intermediate result.",null,{"inputs":[{"name":"__m256d"},{"name":"__m256d"},{"name":"__m256d"}],"output":{"name":"__m256d"}}],[5,"_mm_fnmsub_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the negated intermediate result.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_mm256_fnmsub_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the negated intermediate result.",null,{"inputs":[{"name":"__m256"},{"name":"__m256"},{"name":"__m256"}],"output":{"name":"__m256"}}],[5,"_mm_fnmsub_sd","","Multiply the lower double-precision (64-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the negated intermediate result. Store the result in the lower element of the returned value, and copy the upper element from `a` to the upper elements of the result.",null,{"inputs":[{"name":"__m128d"},{"name":"__m128d"},{"name":"__m128d"}],"output":{"name":"__m128d"}}],[5,"_mm_fnmsub_ss","","Multiply the lower single-precision (32-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the negated intermediate result. Store the result in the lower element of the returned value, and copy the 3 upper elements from `a` to the upper elements of the result.",null,{"inputs":[{"name":"__m128"},{"name":"__m128"},{"name":"__m128"}],"output":{"name":"__m128"}}],[5,"_lzcnt_u32","","Counts the leading most significant zero bits.",null,{"inputs":[{"name":"u32"}],"output":{"name":"u32"}}],[5,"_popcnt32","","Counts the bits that are set.",null,{"inputs":[{"name":"i32"}],"output":{"name":"i32"}}],[5,"_bextr_u32","","Extracts bits in range [`start`, `start` + `length`) from `a` into the least significant bits of the result.",null,{"inputs":[{"name":"u32"},{"name":"u32"},{"name":"u32"}],"output":{"name":"u32"}}],[5,"_bextr2_u32","","Extracts bits of `a` specified by `control` into the least significant bits of the result.",null,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"u32"}}],[5,"_andn_u32","","Bitwise logical `AND` of inverted `a` with `b`.",null,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"u32"}}],[5,"_blsi_u32","","Extract lowest set isolated bit.",null,{"inputs":[{"name":"u32"}],"output":{"name":"u32"}}],[5,"_blsmsk_u32","","Get mask up to lowest set bit.",null,{"inputs":[{"name":"u32"}],"output":{"name":"u32"}}],[5,"_blsr_u32","","Resets the lowest set bit of `x`.",null,{"inputs":[{"name":"u32"}],"output":{"name":"u32"}}],[5,"_tzcnt_u32","","Counts the number of trailing least significant zero bits.",null,{"inputs":[{"name":"u32"}],"output":{"name":"u32"}}],[5,"_mm_tzcnt_32","","Counts the number of trailing least significant zero bits.",null,{"inputs":[{"name":"u32"}],"output":{"name":"i32"}}],[5,"_mulx_u32","","Unsigned multiply without affecting flags.",null,{"inputs":[{"name":"u32"},{"name":"u32"},{"name":"u32"}],"output":{"name":"u32"}}],[5,"_bzhi_u32","","Zero higher bits of `a` >= `index`.",null,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"u32"}}],[5,"_pdep_u32","","Scatter contiguous low order bits of `a` to the result at the positions specified by the `mask`.",null,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"u32"}}],[5,"_pext_u32","","Gathers the bits of `x` specified by the `mask` into the contiguous low order bit positions of the result.",null,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"u32"}}],[5,"_mm_extract_si64","","Extracts the bit range specified by `y` from the lower 64 bits of `x`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_insert_si64","","Inserts the `[length:0]` bits of `y` into `x` at `index`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_stream_sd","","Non-temporal store of `a.0` into `p`.",null,null],[5,"_mm_stream_ss","","Non-temporal store of `a.0` into `p`.",null,null],[5,"_blcfill_u32","","Clears all bits below the least significant zero bit of `x`.",null,{"inputs":[{"name":"u32"}],"output":{"name":"u32"}}],[5,"_blcfill_u64","","Clears all bits below the least significant zero bit of `x`.",null,{"inputs":[{"name":"u64"}],"output":{"name":"u64"}}],[5,"_blci_u32","","Sets all bits of `x` to 1 except for the least significant zero bit.",null,{"inputs":[{"name":"u32"}],"output":{"name":"u32"}}],[5,"_blci_u64","","Sets all bits of `x` to 1 except for the least significant zero bit.",null,{"inputs":[{"name":"u64"}],"output":{"name":"u64"}}],[5,"_blcic_u32","","Sets the least significant zero bit of `x` and clears all other bits.",null,{"inputs":[{"name":"u32"}],"output":{"name":"u32"}}],[5,"_blcic_u64","","Sets the least significant zero bit of `x` and clears all other bits.",null,{"inputs":[{"name":"u64"}],"output":{"name":"u64"}}],[5,"_blcmsk_u32","","Sets the least significant zero bit of `x` and clears all bits above that bit.",null,{"inputs":[{"name":"u32"}],"output":{"name":"u32"}}],[5,"_blcmsk_u64","","Sets the least significant zero bit of `x` and clears all bits above that bit.",null,{"inputs":[{"name":"u64"}],"output":{"name":"u64"}}],[5,"_blcs_u32","","Sets the least significant zero bit of `x`.",null,{"inputs":[{"name":"u32"}],"output":{"name":"u32"}}],[5,"_blcs_u64","","Sets the least significant zero bit of `x`.",null,{"inputs":[{"name":"u64"}],"output":{"name":"u64"}}],[5,"_blsfill_u32","","Sets all bits of `x` below the least significant one.",null,{"inputs":[{"name":"u32"}],"output":{"name":"u32"}}],[5,"_blsfill_u64","","Sets all bits of `x` below the least significant one.",null,{"inputs":[{"name":"u64"}],"output":{"name":"u64"}}],[5,"_blsic_u32","","Clears least significant bit and sets all other bits.",null,{"inputs":[{"name":"u32"}],"output":{"name":"u32"}}],[5,"_blsic_u64","","Clears least significant bit and sets all other bits.",null,{"inputs":[{"name":"u64"}],"output":{"name":"u64"}}],[5,"_t1mskc_u32","","Clears all bits below the least significant zero of `x` and sets all other bits.",null,{"inputs":[{"name":"u32"}],"output":{"name":"u32"}}],[5,"_t1mskc_u64","","Clears all bits below the least significant zero of `x` and sets all other bits.",null,{"inputs":[{"name":"u64"}],"output":{"name":"u64"}}],[5,"_tzmsk_u32","","Sets all bits below the least significant one of `x` and clears all other bits.",null,{"inputs":[{"name":"u32"}],"output":{"name":"u32"}}],[5,"_tzmsk_u64","","Sets all bits below the least significant one of `x` and clears all other bits.",null,{"inputs":[{"name":"u64"}],"output":{"name":"u64"}}],[5,"_mm_setzero_si64","","Constructs a 64-bit integer vector initialized to zero.",null,{"inputs":[],"output":{"name":"__m64"}}],[5,"_mm_add_pi8","","Add packed 8-bit integers in `a` and `b`.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_m_paddb","","Add packed 8-bit integers in `a` and `b`.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_add_pi16","","Add packed 16-bit integers in `a` and `b`.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_m_paddw","","Add packed 16-bit integers in `a` and `b`.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_add_pi32","","Add packed 32-bit integers in `a` and `b`.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_m_paddd","","Add packed 32-bit integers in `a` and `b`.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_adds_pi8","","Add packed 8-bit integers in `a` and `b` using saturation.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_m_paddsb","","Add packed 8-bit integers in `a` and `b` using saturation.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_adds_pi16","","Add packed 16-bit integers in `a` and `b` using saturation.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_m_paddsw","","Add packed 16-bit integers in `a` and `b` using saturation.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_adds_pu8","","Add packed unsigned 8-bit integers in `a` and `b` using saturation.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_m_paddusb","","Add packed unsigned 8-bit integers in `a` and `b` using saturation.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_adds_pu16","","Add packed unsigned 16-bit integers in `a` and `b` using saturation.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_m_paddusw","","Add packed unsigned 16-bit integers in `a` and `b` using saturation.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_sub_pi8","","Subtract packed 8-bit integers in `b` from packed 8-bit integers in `a`.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_m_psubb","","Subtract packed 8-bit integers in `b` from packed 8-bit integers in `a`.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_sub_pi16","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a`.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_m_psubw","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a`.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_sub_pi32","","Subtract packed 32-bit integers in `b` from packed 32-bit integers in `a`.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_m_psubd","","Subtract packed 32-bit integers in `b` from packed 32-bit integers in `a`.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_subs_pi8","","Subtract packed 8-bit integers in `b` from packed 8-bit integers in `a` using saturation.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_m_psubsb","","Subtract packed 8-bit integers in `b` from packed 8-bit integers in `a` using saturation.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_subs_pi16","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a` using saturation.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_m_psubsw","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a` using saturation.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_subs_pu8","","Subtract packed unsigned 8-bit integers in `b` from packed unsigned 8-bit integers in `a` using saturation.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_m_psubusb","","Subtract packed unsigned 8-bit integers in `b` from packed unsigned 8-bit integers in `a` using saturation.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_subs_pu16","","Subtract packed unsigned 16-bit integers in `b` from packed unsigned 16-bit integers in `a` using saturation.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_m_psubusw","","Subtract packed unsigned 16-bit integers in `b` from packed unsigned 16-bit integers in `a` using saturation.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_packs_pi16","","Convert packed 16-bit integers from `a` and `b` to packed 8-bit integers using signed saturation.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_packs_pi32","","Convert packed 32-bit integers from `a` and `b` to packed 16-bit integers using signed saturation.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_cmpgt_pi8","","Compares whether each element of `a` is greater than the corresponding element of `b` returning `0` for `false` and `-1` for `true`.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_cmpgt_pi16","","Compares whether each element of `a` is greater than the corresponding element of `b` returning `0` for `false` and `-1` for `true`.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_cmpgt_pi32","","Compares whether each element of `a` is greater than the corresponding element of `b` returning `0` for `false` and `-1` for `true`.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_unpackhi_pi16","","Unpacks the upper two elements from two `i16x4` vectors and interleaves them into the result: `[a.2, b.2, a.3, b.3]`.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_unpackhi_pi8","","Unpacks the upper four elements from two `i8x8` vectors and interleaves them into the result: `[a.4, b.4, a.5, b.5, a.6, b.6, a.7, b.7]`.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_unpacklo_pi8","","Unpacks the lower four elements from two `i8x8` vectors and interleaves them into the result: `[a.0, b.0, a.1, b.1, a.2, b.2, a.3, b.3]`.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_unpacklo_pi16","","Unpacks the lower two elements from two `i16x4` vectors and interleaves them into the result: `[a.0 b.0 a.1 b.1]`.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_unpackhi_pi32","","Unpacks the upper element from two `i32x2` vectors and interleaves them into the result: `[a.1, b.1]`.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_unpacklo_pi32","","Unpacks the lower element from two `i32x2` vectors and interleaves them into the result: `[a.0, b.0]`.",null,{"inputs":[{"name":"__m64"},{"name":"__m64"}],"output":{"name":"__m64"}}],[5,"_mm_set_pi16","","Set packed 16-bit integers in dst with the supplied values.",null,{"inputs":[{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"}],"output":{"name":"__m64"}}],[5,"_mm_set_pi32","","Set packed 32-bit integers in dst with the supplied values.",null,{"inputs":[{"name":"i32"},{"name":"i32"}],"output":{"name":"__m64"}}],[5,"_mm_set_pi8","","Set packed 8-bit integers in dst with the supplied values.",null,{"inputs":[{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"}],"output":{"name":"__m64"}}],[5,"_mm_set1_pi16","","Broadcast 16-bit integer a to all all elements of dst.",null,{"inputs":[{"name":"i16"}],"output":{"name":"__m64"}}],[5,"_mm_set1_pi32","","Broadcast 32-bit integer a to all all elements of dst.",null,{"inputs":[{"name":"i32"}],"output":{"name":"__m64"}}],[5,"_mm_set1_pi8","","Broadcast 8-bit integer a to all all elements of dst.",null,{"inputs":[{"name":"i8"}],"output":{"name":"__m64"}}],[5,"_mm_setr_pi16","","Set packed 16-bit integers in dst with the supplied values in reverse order.",null,{"inputs":[{"name":"i16"},{"name":"i16"},{"name":"i16"},{"name":"i16"}],"output":{"name":"__m64"}}],[5,"_mm_setr_pi32","","Set packed 32-bit integers in dst with the supplied values in reverse order.",null,{"inputs":[{"name":"i32"},{"name":"i32"}],"output":{"name":"__m64"}}],[5,"_mm_setr_pi8","","Set packed 8-bit integers in dst with the supplied values in reverse order.",null,{"inputs":[{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"},{"name":"i8"}],"output":{"name":"__m64"}}],[5,"_mm_clmulepi64_si128","","Perform a carry-less multiplication of two 64-bit polynomials over the finite field GF(2^k).",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_aesdec_si128","","Perform one round of an AES decryption flow on data (state) in `a`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_aesdeclast_si128","","Perform the last round of an AES decryption flow on data (state) in `a`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_aesenc_si128","","Perform one round of an AES encryption flow on data (state) in `a`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_aesenclast_si128","","Perform the last round of an AES encryption flow on data (state) in `a`.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_aesimc_si128","","Perform the `InvMixColumns` transformation on `a`.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_aeskeygenassist_si128","","Assist in expanding the AES cipher key.",null,{"inputs":[{"name":"__m128i"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_rdrand16_step","","Read a hardware generated 16-bit random value and store the result in val. Return 1 if a random value was generated, and 0 otherwise.",null,{"inputs":[{"name":"u16"}],"output":{"name":"i32"}}],[5,"_rdrand32_step","","Read a hardware generated 32-bit random value and store the result in val. Return 1 if a random value was generated, and 0 otherwise.",null,{"inputs":[{"name":"u32"}],"output":{"name":"i32"}}],[5,"_rdseed16_step","","Read a 16-bit NIST SP800-90B and SP800-90C compliant random value and store in val. Return 1 if a random value was generated, and 0 otherwise.",null,{"inputs":[{"name":"u16"}],"output":{"name":"i32"}}],[5,"_rdseed32_step","","Read a 32-bit NIST SP800-90B and SP800-90C compliant random value and store in val. Return 1 if a random value was generated, and 0 otherwise.",null,{"inputs":[{"name":"u32"}],"output":{"name":"i32"}}],[5,"_mm_sha1msg1_epu32","","Perform an intermediate calculation for the next four SHA1 message values (unsigned 32-bit integers) using previous message values from `a` and `b`, and returning the result.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_sha1msg2_epu32","","Perform the final calculation for the next four SHA1 message values (unsigned 32-bit integers) using the intermediate result in `a` and the previous message values in `b`, and returns the result.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_sha1nexte_epu32","","Calculate SHA1 state variable E after four rounds of operation from the current SHA1 state variable `a`, add that value to the scheduled values (unsigned 32-bit integers) in `b`, and returns the result.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_sha1rnds4_epu32","","Perform four rounds of SHA1 operation using an initial SHA1 state (A,B,C,D) from `a` and some pre-computed sum of the next 4 round message values (unsigned 32-bit integers), and state variable E from `b`, and return the updated SHA1 state (A,B,C,D). `func` contains the logic functions and round constants.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_sha256msg1_epu32","","Perform an intermediate calculation for the next four SHA256 message values (unsigned 32-bit integers) using previous message values from `a` and `b`, and return the result.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_sha256msg2_epu32","","Perform the final calculation for the next four SHA256 message values (unsigned 32-bit integers) using previous message values from `a` and `b`, and return the result.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_mm_sha256rnds2_epu32","","Perform 2 rounds of SHA256 operation using an initial SHA256 state (C,D,G,H) from `a`, an initial SHA256 state (A,B,E,F) from `b`, and a pre-computed sum of the next 2 round message values (unsigned 32-bit integers) and the corresponding round constants from `k`, and store the updated SHA256 state (A,B,E,F) in dst.",null,{"inputs":[{"name":"__m128i"},{"name":"__m128i"},{"name":"__m128i"}],"output":{"name":"__m128i"}}],[5,"_fxsave64","","Saves the `x87` FPU, `MMX` technology, `XMM`, and `MXCSR` registers to the 512-byte-long 16-byte-aligned memory region `mem_addr`.",null,null],[5,"_fxrstor64","","Restores the `XMM`, `MMX`, `MXCSR`, and `x87` FPU registers from the 512-byte-long 16-byte-aligned memory region `mem_addr`.",null,null],[5,"_mm_cvtss_si64","","Convert the lowest 32 bit float in the input vector to a 64 bit integer.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"i64"}}],[5,"_mm_cvttss_si64","","Convert the lowest 32 bit float in the input vector to a 64 bit integer with truncation.",null,{"inputs":[{"name":"__m128"}],"output":{"name":"i64"}}],[5,"_mm_cvtsi64_ss","","Convert a 64 bit integer to a 32 bit float. The result vector is the input vector `a` with the lowest 32 bit float replaced by the converted integer.",null,{"inputs":[{"name":"__m128"},{"name":"i64"}],"output":{"name":"__m128"}}],[5,"_mm_cvtsd_si64","","Convert the lower double-precision (64-bit) floating-point element in a to a 64-bit integer.",null,{"inputs":[{"name":"__m128d"}],"output":{"name":"i64"}}],[5,"_mm_cvtsd_si64x","","Alias for `_mm_cvtsd_si64`",null,{"inputs":[{"name":"__m128d"}],"output":{"name":"i64"}}],[5,"_mm_cvttsd_si64","","Convert the lower double-precision (64-bit) floating-point element in `a` to a 64-bit integer with truncation.",null,{"inputs":[{"name":"__m128d"}],"output":{"name":"i64"}}],[5,"_mm_cvttsd_si64x","","Alias for `_mm_cvttsd_si64`",null,{"inputs":[{"name":"__m128d"}],"output":{"name":"i64"}}],[5,"_mm_stream_si64","","Stores a 64-bit integer value in the specified memory location. To minimize caching, the data is flagged as non-temporal (unlikely to be used again soon).",null,null],[5,"_mm_cvtsi64_si128","","Return a vector whose lowest element is `a` and all higher elements are `0`.",null,{"inputs":[{"name":"i64"}],"output":{"name":"__m128i"}}],[5,"_mm_cvtsi64x_si128","","Return a vector whose lowest element is `a` and all higher elements are `0`.",null,{"inputs":[{"name":"i64"}],"output":{"name":"__m128i"}}],[5,"_mm_cvtsi128_si64","","Return the lowest element of `a`.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"i64"}}],[5,"_mm_cvtsi128_si64x","","Return the lowest element of `a`.",null,{"inputs":[{"name":"__m128i"}],"output":{"name":"i64"}}],[5,"_mm_cvtsi64_sd","","Return `a` with its lower element replaced by `b` after converting it to an `f64`.",null,{"inputs":[{"name":"__m128d"},{"name":"i64"}],"output":{"name":"__m128d"}}],[5,"_mm_cvtsi64x_sd","","Return `a` with its lower element replaced by `b` after converting it to an `f64`.",null,{"inputs":[{"name":"__m128d"},{"name":"i64"}],"output":{"name":"__m128d"}}],[5,"_mm_extract_epi64","","Extract an 64-bit integer from `a` selected with `imm8`",null,{"inputs":[{"name":"__m128i"},{"name":"i32"}],"output":{"name":"i64"}}],[5,"_mm_insert_epi64","","Return a copy of `a` with the 64-bit integer from `i` inserted at a location specified by `imm8`.",null,{"inputs":[{"name":"__m128i"},{"name":"i64"},{"name":"i32"}],"output":{"name":"__m128i"}}],[5,"_mm_crc32_u64","","Starting with the initial value in `crc`, return the accumulated CRC32 value for unsigned 64-bit integer `v`.",null,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"u64"}}],[5,"_xsave64","","Perform a full or partial save of the enabled processor states to memory at `mem_addr`.",null,null],[5,"_xrstor64","","Perform a full or partial restore of the enabled processor states using the state information stored in memory at `mem_addr`.",null,null],[5,"_xsaveopt64","","Perform a full or partial save of the enabled processor states to memory at `mem_addr`.",null,null],[5,"_xsavec64","","Perform a full or partial save of the enabled processor states to memory at `mem_addr`.",null,null],[5,"_xsaves64","","Perform a full or partial save of the enabled processor states to memory at `mem_addr`",null,null],[5,"_xrstors64","","Perform a full or partial restore of the enabled processor states using the state information stored in memory at `mem_addr`.",null,null],[5,"_lzcnt_u64","","Counts the leading most significant zero bits.",null,{"inputs":[{"name":"u64"}],"output":{"name":"u64"}}],[5,"_popcnt64","","Counts the bits that are set.",null,{"inputs":[{"name":"i64"}],"output":{"name":"i32"}}],[5,"_mm256_insert_epi64","","Copy `a` to result, and insert the 64-bit integer `i` into result at the location specified by `index`.",null,{"inputs":[{"name":"__m256i"},{"name":"i64"},{"name":"i32"}],"output":{"name":"__m256i"}}],[5,"_bextr_u64","","Extracts bits in range [`start`, `start` + `length`) from `a` into the least significant bits of the result.",null,{"inputs":[{"name":"u64"},{"name":"u32"},{"name":"u32"}],"output":{"name":"u64"}}],[5,"_bextr2_u64","","Extracts bits of `a` specified by `control` into the least significant bits of the result.",null,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"u64"}}],[5,"_andn_u64","","Bitwise logical `AND` of inverted `a` with `b`.",null,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"u64"}}],[5,"_blsi_u64","","Extract lowest set isolated bit.",null,{"inputs":[{"name":"u64"}],"output":{"name":"u64"}}],[5,"_blsmsk_u64","","Get mask up to lowest set bit.",null,{"inputs":[{"name":"u64"}],"output":{"name":"u64"}}],[5,"_blsr_u64","","Resets the lowest set bit of `x`.",null,{"inputs":[{"name":"u64"}],"output":{"name":"u64"}}],[5,"_tzcnt_u64","","Counts the number of trailing least significant zero bits.",null,{"inputs":[{"name":"u64"}],"output":{"name":"u64"}}],[5,"_mm_tzcnt_64","","Counts the number of trailing least significant zero bits.",null,{"inputs":[{"name":"u64"}],"output":{"name":"i64"}}],[5,"_mulx_u64","","Unsigned multiply without affecting flags.",null,{"inputs":[{"name":"u64"},{"name":"u64"},{"name":"u64"}],"output":{"name":"u64"}}],[5,"_bzhi_u64","","Zero higher bits of `a` >= `index`.",null,{"inputs":[{"name":"u64"},{"name":"u32"}],"output":{"name":"u64"}}],[5,"_pdep_u64","","Scatter contiguous low order bits of `a` to the result at the positions specified by the `mask`.",null,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"u64"}}],[5,"_pext_u64","","Gathers the bits of `x` specified by the `mask` into the contiguous low order bit positions of the result.",null,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"u64"}}],[5,"_mm256_extract_epi64","","Extract a 64-bit integer from `a`, selected with `imm8`.",null,{"inputs":[{"name":"__m256i"},{"name":"i32"}],"output":{"name":"i64"}}],[5,"_bswap64","","Return an integer with the reversed byte order of x",null,{"inputs":[{"name":"i64"}],"output":{"name":"i64"}}],[5,"_rdrand64_step","","Read a hardware generated 64-bit random value and store the result in val. Return 1 if a random value was generated, and 0 otherwise.",null,{"inputs":[{"name":"u64"}],"output":{"name":"i32"}}],[5,"_rdseed64_step","","Read a 64-bit NIST SP800-90B and SP800-90C compliant random value and store in val. Return 1 if a random value was generated, and 0 otherwise.",null,{"inputs":[{"name":"u64"}],"output":{"name":"i32"}}],[17,"_XCR_XFEATURE_ENABLED_MASK","","`XFEATURE_ENABLED_MASK` for `XCR`",null,null],[17,"_MM_EXCEPT_INVALID","","See `_mm_setcsr`",null,null],[17,"_MM_EXCEPT_DENORM","","See `_mm_setcsr`",null,null],[17,"_MM_EXCEPT_DIV_ZERO","","See `_mm_setcsr`",null,null],[17,"_MM_EXCEPT_OVERFLOW","","See `_mm_setcsr`",null,null],[17,"_MM_EXCEPT_UNDERFLOW","","See `_mm_setcsr`",null,null],[17,"_MM_EXCEPT_INEXACT","","See `_mm_setcsr`",null,null],[17,"_MM_EXCEPT_MASK","","See `_MM_GET_EXCEPTION_STATE`",null,null],[17,"_MM_MASK_INVALID","","See `_mm_setcsr`",null,null],[17,"_MM_MASK_DENORM","","See `_mm_setcsr`",null,null],[17,"_MM_MASK_DIV_ZERO","","See `_mm_setcsr`",null,null],[17,"_MM_MASK_OVERFLOW","","See `_mm_setcsr`",null,null],[17,"_MM_MASK_UNDERFLOW","","See `_mm_setcsr`",null,null],[17,"_MM_MASK_INEXACT","","See `_mm_setcsr`",null,null],[17,"_MM_MASK_MASK","","See `_MM_GET_EXCEPTION_MASK`",null,null],[17,"_MM_ROUND_NEAREST","","See `_mm_setcsr`",null,null],[17,"_MM_ROUND_DOWN","","See `_mm_setcsr`",null,null],[17,"_MM_ROUND_UP","","See `_mm_setcsr`",null,null],[17,"_MM_ROUND_TOWARD_ZERO","","See `_mm_setcsr`",null,null],[17,"_MM_ROUND_MASK","","See `_MM_GET_ROUNDING_MODE`",null,null],[17,"_MM_FLUSH_ZERO_MASK","","See `_MM_GET_FLUSH_ZERO_MODE`",null,null],[17,"_MM_FLUSH_ZERO_ON","","See `_mm_setcsr`",null,null],[17,"_MM_FLUSH_ZERO_OFF","","See `_mm_setcsr`",null,null],[17,"_MM_HINT_T0","","See `_mm_prefetch`.",null,null],[17,"_MM_HINT_T1","","See `_mm_prefetch`.",null,null],[17,"_MM_HINT_T2","","See `_mm_prefetch`.",null,null],[17,"_MM_HINT_NTA","","See `_mm_prefetch`.",null,null],[17,"_MM_FROUND_TO_NEAREST_INT","","round to nearest",null,null],[17,"_MM_FROUND_TO_NEG_INF","","round down",null,null],[17,"_MM_FROUND_TO_POS_INF","","round up",null,null],[17,"_MM_FROUND_TO_ZERO","","truncate",null,null],[17,"_MM_FROUND_CUR_DIRECTION","","use MXCSR.RC; see `vendor::_MM_SET_ROUNDING_MODE`",null,null],[17,"_MM_FROUND_RAISE_EXC","","do not suppress exceptions",null,null],[17,"_MM_FROUND_NO_EXC","","suppress exceptions",null,null],[17,"_MM_FROUND_NINT","","round to nearest and do not suppress exceptions",null,null],[17,"_MM_FROUND_FLOOR","","round down and do not suppress exceptions",null,null],[17,"_MM_FROUND_CEIL","","round up and do not suppress exceptions",null,null],[17,"_MM_FROUND_TRUNC","","truncate and do not suppress exceptions",null,null],[17,"_MM_FROUND_RINT","","use MXCSR.RC and do not suppress exceptions; see `vendor::_MM_SET_ROUNDING_MODE`",null,null],[17,"_MM_FROUND_NEARBYINT","","use MXCSR.RC and suppress exceptions; see `vendor::_MM_SET_ROUNDING_MODE`",null,null],[17,"_SIDD_UBYTE_OPS","","String contains unsigned 8-bit characters (Default)",null,null],[17,"_SIDD_UWORD_OPS","","String contains unsigned 16-bit characters",null,null],[17,"_SIDD_SBYTE_OPS","","String contains signed 8-bit characters",null,null],[17,"_SIDD_SWORD_OPS","","String contains unsigned 16-bit characters",null,null],[17,"_SIDD_CMP_EQUAL_ANY","","For each character in `a`, find if it is in `b` (Default)",null,null],[17,"_SIDD_CMP_RANGES","","For each character in `a`, determine if `b[0] <= c <= b[1] or b[1] <= c <= b[2]...`",null,null],[17,"_SIDD_CMP_EQUAL_EACH","","The strings defined by `a` and `b` are equal",null,null],[17,"_SIDD_CMP_EQUAL_ORDERED","","Search for the defined substring in the target",null,null],[17,"_SIDD_POSITIVE_POLARITY","","Do not negate results (Default)",null,null],[17,"_SIDD_NEGATIVE_POLARITY","","Negate results",null,null],[17,"_SIDD_MASKED_POSITIVE_POLARITY","","Do not negate results before the end of the string",null,null],[17,"_SIDD_MASKED_NEGATIVE_POLARITY","","Negate results only before the end of the string",null,null],[17,"_SIDD_LEAST_SIGNIFICANT","","Index only: return the least significant bit (Default)",null,null],[17,"_SIDD_MOST_SIGNIFICANT","","Index only: return the most significant bit",null,null],[17,"_SIDD_BIT_MASK","","Mask only: return the bit mask",null,null],[17,"_SIDD_UNIT_MASK","","Mask only: return the byte mask",null,null],[17,"_CMP_EQ_OQ","","Equal (ordered, non-signaling)",null,null],[17,"_CMP_LT_OS","","Less-than (ordered, signaling)",null,null],[17,"_CMP_LE_OS","","Less-than-or-equal (ordered, signaling)",null,null],[17,"_CMP_UNORD_Q","","Unordered (non-signaling)",null,null],[17,"_CMP_NEQ_UQ","","Not-equal (unordered, non-signaling)",null,null],[17,"_CMP_NLT_US","","Not-less-than (unordered, signaling)",null,null],[17,"_CMP_NLE_US","","Not-less-than-or-equal (unordered, signaling)",null,null],[17,"_CMP_ORD_Q","","Ordered (non-signaling)",null,null],[17,"_CMP_EQ_UQ","","Equal (unordered, non-signaling)",null,null],[17,"_CMP_NGE_US","","Not-greater-than-or-equal (unordered, signaling)",null,null],[17,"_CMP_NGT_US","","Not-greater-than (unordered, signaling)",null,null],[17,"_CMP_FALSE_OQ","","False (ordered, non-signaling)",null,null],[17,"_CMP_NEQ_OQ","","Not-equal (ordered, non-signaling)",null,null],[17,"_CMP_GE_OS","","Greater-than-or-equal (ordered, signaling)",null,null],[17,"_CMP_GT_OS","","Greater-than (ordered, signaling)",null,null],[17,"_CMP_TRUE_UQ","","True (unordered, non-signaling)",null,null],[17,"_CMP_EQ_OS","","Equal (ordered, signaling)",null,null],[17,"_CMP_LT_OQ","","Less-than (ordered, non-signaling)",null,null],[17,"_CMP_LE_OQ","","Less-than-or-equal (ordered, non-signaling)",null,null],[17,"_CMP_UNORD_S","","Unordered (signaling)",null,null],[17,"_CMP_NEQ_US","","Not-equal (unordered, signaling)",null,null],[17,"_CMP_NLT_UQ","","Not-less-than (unordered, non-signaling)",null,null],[17,"_CMP_NLE_UQ","","Not-less-than-or-equal (unordered, non-signaling)",null,null],[17,"_CMP_ORD_S","","Ordered (signaling)",null,null],[17,"_CMP_EQ_US","","Equal (unordered, signaling)",null,null],[17,"_CMP_NGE_UQ","","Not-greater-than-or-equal (unordered, non-signaling)",null,null],[17,"_CMP_NGT_UQ","","Not-greater-than (unordered, non-signaling)",null,null],[17,"_CMP_FALSE_OS","","False (ordered, signaling)",null,null],[17,"_CMP_NEQ_OS","","Not-equal (ordered, signaling)",null,null],[17,"_CMP_GE_OQ","","Greater-than-or-equal (ordered, non-signaling)",null,null],[17,"_CMP_GT_OQ","","Greater-than (ordered, non-signaling)",null,null],[17,"_CMP_TRUE_US","","True (unordered, signaling)",null,null],[0,"arm","core::arch","Platform-specific intrinsics for the `arm` platform.",null,null],[3,"int8x8_t","core::arch::arm","ARM-specific 64-bit wide vector of eight packed `i8`.",null,null],[3,"uint8x8_t","","ARM-specific 64-bit wide vector of eight packed `u8`.",null,null],[3,"poly8x8_t","","ARM-specific 64-bit wide polynomial vector of eight packed `u8`.",null,null],[3,"int16x4_t","","ARM-specific 64-bit wide vector of four packed `i16`.",null,null],[3,"uint16x4_t","","ARM-specific 64-bit wide vector of four packed `u16`.",null,null],[3,"poly16x4_t","","ARM-specific 64-bit wide vector of four packed `u16`.",null,null],[3,"int32x2_t","","ARM-specific 64-bit wide vector of two packed `i32`.",null,null],[3,"uint32x2_t","","ARM-specific 64-bit wide vector of two packed `u32`.",null,null],[3,"float32x2_t","","ARM-specific 64-bit wide vector of two packed `f32`.",null,null],[3,"int64x1_t","","ARM-specific 64-bit wide vector of one packed `i64`.",null,null],[3,"uint64x1_t","","ARM-specific 64-bit wide vector of one packed `u64`.",null,null],[3,"int8x16_t","","ARM-specific 128-bit wide vector of sixteem packed `i8`.",null,null],[3,"uint8x16_t","","ARM-specific 128-bit wide vector of sixteen packed `u8`.",null,null],[3,"poly8x16_t","","ARM-specific 128-bit wide vector of sixteen packed `u8`.",null,null],[3,"int16x8_t","","ARM-specific 128-bit wide vector of eight packed `i16`.",null,null],[3,"uint16x8_t","","ARM-specific 128-bit wide vector of eight packed `u16`.",null,null],[3,"poly16x8_t","","ARM-specific 128-bit wide vector of eight packed `u16`.",null,null],[3,"int32x4_t","","ARM-specific 128-bit wide vector of four packed `i32`.",null,null],[3,"uint32x4_t","","ARM-specific 128-bit wide vector of four packed `u32`.",null,null],[3,"float32x4_t","","ARM-specific 128-bit wide vector of four packed `f32`.",null,null],[3,"int64x2_t","","ARM-specific 128-bit wide vector of two packed `i64`.",null,null],[3,"uint64x2_t","","ARM-specific 128-bit wide vector of two packed `u64`.",null,null],[5,"_rev_u16","","Reverse the order of the bytes.",null,{"inputs":[{"name":"u16"}],"output":{"name":"u16"}}],[5,"_rev_u32","","Reverse the order of the bytes.",null,{"inputs":[{"name":"u32"}],"output":{"name":"u32"}}],[5,"vadd_s8","","Vector add.",null,{"inputs":[{"name":"int8x8_t"},{"name":"int8x8_t"}],"output":{"name":"int8x8_t"}}],[5,"vaddq_s8","","Vector add.",null,{"inputs":[{"name":"int8x16_t"},{"name":"int8x16_t"}],"output":{"name":"int8x16_t"}}],[5,"vadd_s16","","Vector add.",null,{"inputs":[{"name":"int16x4_t"},{"name":"int16x4_t"}],"output":{"name":"int16x4_t"}}],[5,"vaddq_s16","","Vector add.",null,{"inputs":[{"name":"int16x8_t"},{"name":"int16x8_t"}],"output":{"name":"int16x8_t"}}],[5,"vadd_s32","","Vector add.",null,{"inputs":[{"name":"int32x2_t"},{"name":"int32x2_t"}],"output":{"name":"int32x2_t"}}],[5,"vaddq_s32","","Vector add.",null,{"inputs":[{"name":"int32x4_t"},{"name":"int32x4_t"}],"output":{"name":"int32x4_t"}}],[5,"vaddq_s64","","Vector add.",null,{"inputs":[{"name":"int64x2_t"},{"name":"int64x2_t"}],"output":{"name":"int64x2_t"}}],[5,"vadd_u8","","Vector add.",null,{"inputs":[{"name":"uint8x8_t"},{"name":"uint8x8_t"}],"output":{"name":"uint8x8_t"}}],[5,"vaddq_u8","","Vector add.",null,{"inputs":[{"name":"uint8x16_t"},{"name":"uint8x16_t"}],"output":{"name":"uint8x16_t"}}],[5,"vadd_u16","","Vector add.",null,{"inputs":[{"name":"uint16x4_t"},{"name":"uint16x4_t"}],"output":{"name":"uint16x4_t"}}],[5,"vaddq_u16","","Vector add.",null,{"inputs":[{"name":"uint16x8_t"},{"name":"uint16x8_t"}],"output":{"name":"uint16x8_t"}}],[5,"vadd_u32","","Vector add.",null,{"inputs":[{"name":"uint32x2_t"},{"name":"uint32x2_t"}],"output":{"name":"uint32x2_t"}}],[5,"vaddq_u32","","Vector add.",null,{"inputs":[{"name":"uint32x4_t"},{"name":"uint32x4_t"}],"output":{"name":"uint32x4_t"}}],[5,"vaddq_u64","","Vector add.",null,{"inputs":[{"name":"uint64x2_t"},{"name":"uint64x2_t"}],"output":{"name":"uint64x2_t"}}],[5,"vadd_f32","","Vector add.",null,{"inputs":[{"name":"float32x2_t"},{"name":"float32x2_t"}],"output":{"name":"float32x2_t"}}],[5,"vaddq_f32","","Vector add.",null,{"inputs":[{"name":"float32x4_t"},{"name":"float32x4_t"}],"output":{"name":"float32x4_t"}}],[5,"vaddl_s8","","Vector long add.",null,{"inputs":[{"name":"int8x8_t"},{"name":"int8x8_t"}],"output":{"name":"int16x8_t"}}],[5,"vaddl_s16","","Vector long add.",null,{"inputs":[{"name":"int16x4_t"},{"name":"int16x4_t"}],"output":{"name":"int32x4_t"}}],[5,"vaddl_s32","","Vector long add.",null,{"inputs":[{"name":"int32x2_t"},{"name":"int32x2_t"}],"output":{"name":"int64x2_t"}}],[5,"vaddl_u8","","Vector long add.",null,{"inputs":[{"name":"uint8x8_t"},{"name":"uint8x8_t"}],"output":{"name":"uint16x8_t"}}],[5,"vaddl_u16","","Vector long add.",null,{"inputs":[{"name":"uint16x4_t"},{"name":"uint16x4_t"}],"output":{"name":"uint32x4_t"}}],[5,"vaddl_u32","","Vector long add.",null,{"inputs":[{"name":"uint32x2_t"},{"name":"uint32x2_t"}],"output":{"name":"uint64x2_t"}}],[5,"vmovn_s16","","Vector narrow integer.",null,{"inputs":[{"name":"int16x8_t"}],"output":{"name":"int8x8_t"}}],[5,"vmovn_s32","","Vector narrow integer.",null,{"inputs":[{"name":"int32x4_t"}],"output":{"name":"int16x4_t"}}],[5,"vmovn_s64","","Vector narrow integer.",null,{"inputs":[{"name":"int64x2_t"}],"output":{"name":"int32x2_t"}}],[5,"vmovn_u16","","Vector narrow integer.",null,{"inputs":[{"name":"uint16x8_t"}],"output":{"name":"uint8x8_t"}}],[5,"vmovn_u32","","Vector narrow integer.",null,{"inputs":[{"name":"uint32x4_t"}],"output":{"name":"uint16x4_t"}}],[5,"vmovn_u64","","Vector narrow integer.",null,{"inputs":[{"name":"uint64x2_t"}],"output":{"name":"uint32x2_t"}}],[5,"vmovl_s8","","Vector long move.",null,{"inputs":[{"name":"int8x8_t"}],"output":{"name":"int16x8_t"}}],[5,"vmovl_s16","","Vector long move.",null,{"inputs":[{"name":"int16x4_t"}],"output":{"name":"int32x4_t"}}],[5,"vmovl_s32","","Vector long move.",null,{"inputs":[{"name":"int32x2_t"}],"output":{"name":"int64x2_t"}}],[5,"vmovl_u8","","Vector long move.",null,{"inputs":[{"name":"uint8x8_t"}],"output":{"name":"uint16x8_t"}}],[5,"vmovl_u16","","Vector long move.",null,{"inputs":[{"name":"uint16x4_t"}],"output":{"name":"uint32x4_t"}}],[5,"vmovl_u32","","Vector long move.",null,{"inputs":[{"name":"uint32x2_t"}],"output":{"name":"uint64x2_t"}}],[5,"vrsqrte_f32","","Reciprocal square-root estimate.",null,{"inputs":[{"name":"float32x2_t"}],"output":{"name":"float32x2_t"}}],[5,"vpmin_s8","","Folding minimum of adjacent pairs",null,{"inputs":[{"name":"int8x8_t"},{"name":"int8x8_t"}],"output":{"name":"int8x8_t"}}],[5,"vpmin_s16","","Folding minimum of adjacent pairs",null,{"inputs":[{"name":"int16x4_t"},{"name":"int16x4_t"}],"output":{"name":"int16x4_t"}}],[5,"vpmin_s32","","Folding minimum of adjacent pairs",null,{"inputs":[{"name":"int32x2_t"},{"name":"int32x2_t"}],"output":{"name":"int32x2_t"}}],[5,"vpmin_u8","","Folding minimum of adjacent pairs",null,{"inputs":[{"name":"uint8x8_t"},{"name":"uint8x8_t"}],"output":{"name":"uint8x8_t"}}],[5,"vpmin_u16","","Folding minimum of adjacent pairs",null,{"inputs":[{"name":"uint16x4_t"},{"name":"uint16x4_t"}],"output":{"name":"uint16x4_t"}}],[5,"vpmin_u32","","Folding minimum of adjacent pairs",null,{"inputs":[{"name":"uint32x2_t"},{"name":"uint32x2_t"}],"output":{"name":"uint32x2_t"}}],[5,"vpmin_f32","","Folding minimum of adjacent pairs",null,{"inputs":[{"name":"float32x2_t"},{"name":"float32x2_t"}],"output":{"name":"float32x2_t"}}],[5,"vpmax_s8","","Folding maximum of adjacent pairs",null,{"inputs":[{"name":"int8x8_t"},{"name":"int8x8_t"}],"output":{"name":"int8x8_t"}}],[5,"vpmax_s16","","Folding maximum of adjacent pairs",null,{"inputs":[{"name":"int16x4_t"},{"name":"int16x4_t"}],"output":{"name":"int16x4_t"}}],[5,"vpmax_s32","","Folding maximum of adjacent pairs",null,{"inputs":[{"name":"int32x2_t"},{"name":"int32x2_t"}],"output":{"name":"int32x2_t"}}],[5,"vpmax_u8","","Folding maximum of adjacent pairs",null,{"inputs":[{"name":"uint8x8_t"},{"name":"uint8x8_t"}],"output":{"name":"uint8x8_t"}}],[5,"vpmax_u16","","Folding maximum of adjacent pairs",null,{"inputs":[{"name":"uint16x4_t"},{"name":"uint16x4_t"}],"output":{"name":"uint16x4_t"}}],[5,"vpmax_u32","","Folding maximum of adjacent pairs",null,{"inputs":[{"name":"uint32x2_t"},{"name":"uint32x2_t"}],"output":{"name":"uint32x2_t"}}],[5,"vpmax_f32","","Folding maximum of adjacent pairs",null,{"inputs":[{"name":"float32x2_t"},{"name":"float32x2_t"}],"output":{"name":"float32x2_t"}}],[0,"aarch64","core::arch","Platform-specific intrinsics for the `aarch64` platform.",null,null],[3,"float64x1_t","core::arch::aarch64","ARM-specific 64-bit wide vector of one packed `f64`.",null,null],[3,"float64x2_t","","ARM-specific 128-bit wide vector of two packed `f64`.",null,null],[3,"int8x8_t","","ARM-specific 64-bit wide vector of eight packed `i8`.",null,null],[3,"uint8x8_t","","ARM-specific 64-bit wide vector of eight packed `u8`.",null,null],[3,"poly8x8_t","","ARM-specific 64-bit wide polynomial vector of eight packed `u8`.",null,null],[3,"int16x4_t","","ARM-specific 64-bit wide vector of four packed `i16`.",null,null],[3,"uint16x4_t","","ARM-specific 64-bit wide vector of four packed `u16`.",null,null],[3,"poly16x4_t","","ARM-specific 64-bit wide vector of four packed `u16`.",null,null],[3,"int32x2_t","","ARM-specific 64-bit wide vector of two packed `i32`.",null,null],[3,"uint32x2_t","","ARM-specific 64-bit wide vector of two packed `u32`.",null,null],[3,"float32x2_t","","ARM-specific 64-bit wide vector of two packed `f32`.",null,null],[3,"int64x1_t","","ARM-specific 64-bit wide vector of one packed `i64`.",null,null],[3,"uint64x1_t","","ARM-specific 64-bit wide vector of one packed `u64`.",null,null],[3,"int8x16_t","","ARM-specific 128-bit wide vector of sixteem packed `i8`.",null,null],[3,"uint8x16_t","","ARM-specific 128-bit wide vector of sixteen packed `u8`.",null,null],[3,"poly8x16_t","","ARM-specific 128-bit wide vector of sixteen packed `u8`.",null,null],[3,"int16x8_t","","ARM-specific 128-bit wide vector of eight packed `i16`.",null,null],[3,"uint16x8_t","","ARM-specific 128-bit wide vector of eight packed `u16`.",null,null],[3,"poly16x8_t","","ARM-specific 128-bit wide vector of eight packed `u16`.",null,null],[3,"int32x4_t","","ARM-specific 128-bit wide vector of four packed `i32`.",null,null],[3,"uint32x4_t","","ARM-specific 128-bit wide vector of four packed `u32`.",null,null],[3,"float32x4_t","","ARM-specific 128-bit wide vector of four packed `f32`.",null,null],[3,"int64x2_t","","ARM-specific 128-bit wide vector of two packed `i64`.",null,null],[3,"uint64x2_t","","ARM-specific 128-bit wide vector of two packed `u64`.",null,null],[5,"_rev_u64","","Reverse the order of the bytes.",null,{"inputs":[{"name":"u64"}],"output":{"name":"u64"}}],[5,"_clz_u64","","Count Leading Zeros.",null,{"inputs":[{"name":"u64"}],"output":{"name":"u64"}}],[5,"_rbit_u64","","Reverse the bit order.",null,{"inputs":[{"name":"u64"}],"output":{"name":"u64"}}],[5,"_cls_u32","","Counts the leading most significant bits set.",null,{"inputs":[{"name":"u32"}],"output":{"name":"u32"}}],[5,"_cls_u64","","Counts the leading most significant bits set.",null,{"inputs":[{"name":"u64"}],"output":{"name":"u64"}}],[5,"vadd_f64","","Vector add.",null,{"inputs":[{"name":"float64x1_t"},{"name":"float64x1_t"}],"output":{"name":"float64x1_t"}}],[5,"vaddq_f64","","Vector add.",null,{"inputs":[{"name":"float64x2_t"},{"name":"float64x2_t"}],"output":{"name":"float64x2_t"}}],[5,"vaddd_s64","","Vector add.",null,{"inputs":[{"name":"int64x1_t"},{"name":"int64x1_t"}],"output":{"name":"int64x1_t"}}],[5,"vaddd_u64","","Vector add.",null,{"inputs":[{"name":"uint64x1_t"},{"name":"uint64x1_t"}],"output":{"name":"uint64x1_t"}}],[5,"vmaxv_s8","","Horizontal vector max.",null,{"inputs":[{"name":"int8x8_t"}],"output":{"name":"i8"}}],[5,"vmaxvq_s8","","Horizontal vector max.",null,{"inputs":[{"name":"int8x16_t"}],"output":{"name":"i8"}}],[5,"vmaxv_s16","","Horizontal vector max.",null,{"inputs":[{"name":"int16x4_t"}],"output":{"name":"i16"}}],[5,"vmaxvq_s16","","Horizontal vector max.",null,{"inputs":[{"name":"int16x8_t"}],"output":{"name":"i16"}}],[5,"vmaxv_s32","","Horizontal vector max.",null,{"inputs":[{"name":"int32x2_t"}],"output":{"name":"i32"}}],[5,"vmaxvq_s32","","Horizontal vector max.",null,{"inputs":[{"name":"int32x4_t"}],"output":{"name":"i32"}}],[5,"vmaxv_u8","","Horizontal vector max.",null,{"inputs":[{"name":"uint8x8_t"}],"output":{"name":"u8"}}],[5,"vmaxvq_u8","","Horizontal vector max.",null,{"inputs":[{"name":"uint8x16_t"}],"output":{"name":"u8"}}],[5,"vmaxv_u16","","Horizontal vector max.",null,{"inputs":[{"name":"uint16x4_t"}],"output":{"name":"u16"}}],[5,"vmaxvq_u16","","Horizontal vector max.",null,{"inputs":[{"name":"uint16x8_t"}],"output":{"name":"u16"}}],[5,"vmaxv_u32","","Horizontal vector max.",null,{"inputs":[{"name":"uint32x2_t"}],"output":{"name":"u32"}}],[5,"vmaxvq_u32","","Horizontal vector max.",null,{"inputs":[{"name":"uint32x4_t"}],"output":{"name":"u32"}}],[5,"vmaxv_f32","","Horizontal vector max.",null,{"inputs":[{"name":"float32x2_t"}],"output":{"name":"f32"}}],[5,"vmaxvq_f32","","Horizontal vector max.",null,{"inputs":[{"name":"float32x4_t"}],"output":{"name":"f32"}}],[5,"vmaxvq_f64","","Horizontal vector max.",null,{"inputs":[{"name":"float64x2_t"}],"output":{"name":"f64"}}],[5,"vminv_s8","","Horizontal vector min.",null,{"inputs":[{"name":"int8x8_t"}],"output":{"name":"i8"}}],[5,"vminvq_s8","","Horizontal vector min.",null,{"inputs":[{"name":"int8x16_t"}],"output":{"name":"i8"}}],[5,"vminv_s16","","Horizontal vector min.",null,{"inputs":[{"name":"int16x4_t"}],"output":{"name":"i16"}}],[5,"vminvq_s16","","Horizontal vector min.",null,{"inputs":[{"name":"int16x8_t"}],"output":{"name":"i16"}}],[5,"vminv_s32","","Horizontal vector min.",null,{"inputs":[{"name":"int32x2_t"}],"output":{"name":"i32"}}],[5,"vminvq_s32","","Horizontal vector min.",null,{"inputs":[{"name":"int32x4_t"}],"output":{"name":"i32"}}],[5,"vminv_u8","","Horizontal vector min.",null,{"inputs":[{"name":"uint8x8_t"}],"output":{"name":"u8"}}],[5,"vminvq_u8","","Horizontal vector min.",null,{"inputs":[{"name":"uint8x16_t"}],"output":{"name":"u8"}}],[5,"vminv_u16","","Horizontal vector min.",null,{"inputs":[{"name":"uint16x4_t"}],"output":{"name":"u16"}}],[5,"vminvq_u16","","Horizontal vector min.",null,{"inputs":[{"name":"uint16x8_t"}],"output":{"name":"u16"}}],[5,"vminv_u32","","Horizontal vector min.",null,{"inputs":[{"name":"uint32x2_t"}],"output":{"name":"u32"}}],[5,"vminvq_u32","","Horizontal vector min.",null,{"inputs":[{"name":"uint32x4_t"}],"output":{"name":"u32"}}],[5,"vminv_f32","","Horizontal vector min.",null,{"inputs":[{"name":"float32x2_t"}],"output":{"name":"f32"}}],[5,"vminvq_f32","","Horizontal vector min.",null,{"inputs":[{"name":"float32x4_t"}],"output":{"name":"f32"}}],[5,"vminvq_f64","","Horizontal vector min.",null,{"inputs":[{"name":"float64x2_t"}],"output":{"name":"f64"}}],[5,"vpminq_s8","","Folding minimum of adjacent pairs",null,{"inputs":[{"name":"int8x16_t"},{"name":"int8x16_t"}],"output":{"name":"int8x16_t"}}],[5,"vpminq_s16","","Folding minimum of adjacent pairs",null,{"inputs":[{"name":"int16x8_t"},{"name":"int16x8_t"}],"output":{"name":"int16x8_t"}}],[5,"vpminq_s32","","Folding minimum of adjacent pairs",null,{"inputs":[{"name":"int32x4_t"},{"name":"int32x4_t"}],"output":{"name":"int32x4_t"}}],[5,"vpminq_u8","","Folding minimum of adjacent pairs",null,{"inputs":[{"name":"uint8x16_t"},{"name":"uint8x16_t"}],"output":{"name":"uint8x16_t"}}],[5,"vpminq_u16","","Folding minimum of adjacent pairs",null,{"inputs":[{"name":"uint16x8_t"},{"name":"uint16x8_t"}],"output":{"name":"uint16x8_t"}}],[5,"vpminq_u32","","Folding minimum of adjacent pairs",null,{"inputs":[{"name":"uint32x4_t"},{"name":"uint32x4_t"}],"output":{"name":"uint32x4_t"}}],[5,"vpminq_f32","","Folding minimum of adjacent pairs",null,{"inputs":[{"name":"float32x4_t"},{"name":"float32x4_t"}],"output":{"name":"float32x4_t"}}],[5,"vpminq_f64","","Folding minimum of adjacent pairs",null,{"inputs":[{"name":"float64x2_t"},{"name":"float64x2_t"}],"output":{"name":"float64x2_t"}}],[5,"vpmaxq_s8","","Folding maximum of adjacent pairs",null,{"inputs":[{"name":"int8x16_t"},{"name":"int8x16_t"}],"output":{"name":"int8x16_t"}}],[5,"vpmaxq_s16","","Folding maximum of adjacent pairs",null,{"inputs":[{"name":"int16x8_t"},{"name":"int16x8_t"}],"output":{"name":"int16x8_t"}}],[5,"vpmaxq_s32","","Folding maximum of adjacent pairs",null,{"inputs":[{"name":"int32x4_t"},{"name":"int32x4_t"}],"output":{"name":"int32x4_t"}}],[5,"vpmaxq_u8","","Folding maximum of adjacent pairs",null,{"inputs":[{"name":"uint8x16_t"},{"name":"uint8x16_t"}],"output":{"name":"uint8x16_t"}}],[5,"vpmaxq_u16","","Folding maximum of adjacent pairs",null,{"inputs":[{"name":"uint16x8_t"},{"name":"uint16x8_t"}],"output":{"name":"uint16x8_t"}}],[5,"vpmaxq_u32","","Folding maximum of adjacent pairs",null,{"inputs":[{"name":"uint32x4_t"},{"name":"uint32x4_t"}],"output":{"name":"uint32x4_t"}}],[5,"vpmaxq_f32","","Folding maximum of adjacent pairs",null,{"inputs":[{"name":"float32x4_t"},{"name":"float32x4_t"}],"output":{"name":"float32x4_t"}}],[5,"vpmaxq_f64","","Folding maximum of adjacent pairs",null,{"inputs":[{"name":"float64x2_t"},{"name":"float64x2_t"}],"output":{"name":"float64x2_t"}}],[5,"vaeseq_u8","","AES single round encryption.",null,{"inputs":[{"name":"uint8x16_t"},{"name":"uint8x16_t"}],"output":{"name":"uint8x16_t"}}],[5,"vaesdq_u8","","AES single round decryption.",null,{"inputs":[{"name":"uint8x16_t"},{"name":"uint8x16_t"}],"output":{"name":"uint8x16_t"}}],[5,"vaesmcq_u8","","AES mix columns.",null,{"inputs":[{"name":"uint8x16_t"}],"output":{"name":"uint8x16_t"}}],[5,"vaesimcq_u8","","AES inverse mix columns.",null,{"inputs":[{"name":"uint8x16_t"}],"output":{"name":"uint8x16_t"}}],[5,"vsha1h_u32","","SHA1 fixed rotate.",null,{"inputs":[{"name":"u32"}],"output":{"name":"u32"}}],[5,"vsha1cq_u32","","SHA1 hash update accelerator, choose.",null,{"inputs":[{"name":"uint32x4_t"},{"name":"u32"},{"name":"uint32x4_t"}],"output":{"name":"uint32x4_t"}}],[5,"vsha1mq_u32","","SHA1 hash update accelerator, majority.",null,{"inputs":[{"name":"uint32x4_t"},{"name":"u32"},{"name":"uint32x4_t"}],"output":{"name":"uint32x4_t"}}],[5,"vsha1pq_u32","","SHA1 hash update accelerator, parity.",null,{"inputs":[{"name":"uint32x4_t"},{"name":"u32"},{"name":"uint32x4_t"}],"output":{"name":"uint32x4_t"}}],[5,"vsha1su0q_u32","","SHA1 schedule update accelerator, first part.",null,{"inputs":[{"name":"uint32x4_t"},{"name":"uint32x4_t"},{"name":"uint32x4_t"}],"output":{"name":"uint32x4_t"}}],[5,"vsha1su1q_u32","","SHA1 schedule update accelerator, second part.",null,{"inputs":[{"name":"uint32x4_t"},{"name":"uint32x4_t"}],"output":{"name":"uint32x4_t"}}],[5,"vsha256hq_u32","","SHA256 hash update accelerator.",null,{"inputs":[{"name":"uint32x4_t"},{"name":"uint32x4_t"},{"name":"uint32x4_t"}],"output":{"name":"uint32x4_t"}}],[5,"vsha256h2q_u32","","SHA256 hash update accelerator, upper part.",null,{"inputs":[{"name":"uint32x4_t"},{"name":"uint32x4_t"},{"name":"uint32x4_t"}],"output":{"name":"uint32x4_t"}}],[5,"vsha256su0q_u32","","SHA256 schedule update accelerator, first part.",null,{"inputs":[{"name":"uint32x4_t"},{"name":"uint32x4_t"}],"output":{"name":"uint32x4_t"}}],[5,"vsha256su1q_u32","","SHA256 schedule update accelerator, second part.",null,{"inputs":[{"name":"uint32x4_t"},{"name":"uint32x4_t"},{"name":"uint32x4_t"}],"output":{"name":"uint32x4_t"}}],[5,"_rev_u16","","Reverse the order of the bytes.",null,{"inputs":[{"name":"u16"}],"output":{"name":"u16"}}],[5,"_rev_u32","","Reverse the order of the bytes.",null,{"inputs":[{"name":"u32"}],"output":{"name":"u32"}}],[5,"vadd_s8","","Vector add.",null,{"inputs":[{"name":"int8x8_t"},{"name":"int8x8_t"}],"output":{"name":"int8x8_t"}}],[5,"vaddq_s8","","Vector add.",null,{"inputs":[{"name":"int8x16_t"},{"name":"int8x16_t"}],"output":{"name":"int8x16_t"}}],[5,"vadd_s16","","Vector add.",null,{"inputs":[{"name":"int16x4_t"},{"name":"int16x4_t"}],"output":{"name":"int16x4_t"}}],[5,"vaddq_s16","","Vector add.",null,{"inputs":[{"name":"int16x8_t"},{"name":"int16x8_t"}],"output":{"name":"int16x8_t"}}],[5,"vadd_s32","","Vector add.",null,{"inputs":[{"name":"int32x2_t"},{"name":"int32x2_t"}],"output":{"name":"int32x2_t"}}],[5,"vaddq_s32","","Vector add.",null,{"inputs":[{"name":"int32x4_t"},{"name":"int32x4_t"}],"output":{"name":"int32x4_t"}}],[5,"vaddq_s64","","Vector add.",null,{"inputs":[{"name":"int64x2_t"},{"name":"int64x2_t"}],"output":{"name":"int64x2_t"}}],[5,"vadd_u8","","Vector add.",null,{"inputs":[{"name":"uint8x8_t"},{"name":"uint8x8_t"}],"output":{"name":"uint8x8_t"}}],[5,"vaddq_u8","","Vector add.",null,{"inputs":[{"name":"uint8x16_t"},{"name":"uint8x16_t"}],"output":{"name":"uint8x16_t"}}],[5,"vadd_u16","","Vector add.",null,{"inputs":[{"name":"uint16x4_t"},{"name":"uint16x4_t"}],"output":{"name":"uint16x4_t"}}],[5,"vaddq_u16","","Vector add.",null,{"inputs":[{"name":"uint16x8_t"},{"name":"uint16x8_t"}],"output":{"name":"uint16x8_t"}}],[5,"vadd_u32","","Vector add.",null,{"inputs":[{"name":"uint32x2_t"},{"name":"uint32x2_t"}],"output":{"name":"uint32x2_t"}}],[5,"vaddq_u32","","Vector add.",null,{"inputs":[{"name":"uint32x4_t"},{"name":"uint32x4_t"}],"output":{"name":"uint32x4_t"}}],[5,"vaddq_u64","","Vector add.",null,{"inputs":[{"name":"uint64x2_t"},{"name":"uint64x2_t"}],"output":{"name":"uint64x2_t"}}],[5,"vadd_f32","","Vector add.",null,{"inputs":[{"name":"float32x2_t"},{"name":"float32x2_t"}],"output":{"name":"float32x2_t"}}],[5,"vaddq_f32","","Vector add.",null,{"inputs":[{"name":"float32x4_t"},{"name":"float32x4_t"}],"output":{"name":"float32x4_t"}}],[5,"vaddl_s8","","Vector long add.",null,{"inputs":[{"name":"int8x8_t"},{"name":"int8x8_t"}],"output":{"name":"int16x8_t"}}],[5,"vaddl_s16","","Vector long add.",null,{"inputs":[{"name":"int16x4_t"},{"name":"int16x4_t"}],"output":{"name":"int32x4_t"}}],[5,"vaddl_s32","","Vector long add.",null,{"inputs":[{"name":"int32x2_t"},{"name":"int32x2_t"}],"output":{"name":"int64x2_t"}}],[5,"vaddl_u8","","Vector long add.",null,{"inputs":[{"name":"uint8x8_t"},{"name":"uint8x8_t"}],"output":{"name":"uint16x8_t"}}],[5,"vaddl_u16","","Vector long add.",null,{"inputs":[{"name":"uint16x4_t"},{"name":"uint16x4_t"}],"output":{"name":"uint32x4_t"}}],[5,"vaddl_u32","","Vector long add.",null,{"inputs":[{"name":"uint32x2_t"},{"name":"uint32x2_t"}],"output":{"name":"uint64x2_t"}}],[5,"vmovn_s16","","Vector narrow integer.",null,{"inputs":[{"name":"int16x8_t"}],"output":{"name":"int8x8_t"}}],[5,"vmovn_s32","","Vector narrow integer.",null,{"inputs":[{"name":"int32x4_t"}],"output":{"name":"int16x4_t"}}],[5,"vmovn_s64","","Vector narrow integer.",null,{"inputs":[{"name":"int64x2_t"}],"output":{"name":"int32x2_t"}}],[5,"vmovn_u16","","Vector narrow integer.",null,{"inputs":[{"name":"uint16x8_t"}],"output":{"name":"uint8x8_t"}}],[5,"vmovn_u32","","Vector narrow integer.",null,{"inputs":[{"name":"uint32x4_t"}],"output":{"name":"uint16x4_t"}}],[5,"vmovn_u64","","Vector narrow integer.",null,{"inputs":[{"name":"uint64x2_t"}],"output":{"name":"uint32x2_t"}}],[5,"vmovl_s8","","Vector long move.",null,{"inputs":[{"name":"int8x8_t"}],"output":{"name":"int16x8_t"}}],[5,"vmovl_s16","","Vector long move.",null,{"inputs":[{"name":"int16x4_t"}],"output":{"name":"int32x4_t"}}],[5,"vmovl_s32","","Vector long move.",null,{"inputs":[{"name":"int32x2_t"}],"output":{"name":"int64x2_t"}}],[5,"vmovl_u8","","Vector long move.",null,{"inputs":[{"name":"uint8x8_t"}],"output":{"name":"uint16x8_t"}}],[5,"vmovl_u16","","Vector long move.",null,{"inputs":[{"name":"uint16x4_t"}],"output":{"name":"uint32x4_t"}}],[5,"vmovl_u32","","Vector long move.",null,{"inputs":[{"name":"uint32x2_t"}],"output":{"name":"uint64x2_t"}}],[5,"vrsqrte_f32","","Reciprocal square-root estimate.",null,{"inputs":[{"name":"float32x2_t"}],"output":{"name":"float32x2_t"}}],[5,"vpmin_s8","","Folding minimum of adjacent pairs",null,{"inputs":[{"name":"int8x8_t"},{"name":"int8x8_t"}],"output":{"name":"int8x8_t"}}],[5,"vpmin_s16","","Folding minimum of adjacent pairs",null,{"inputs":[{"name":"int16x4_t"},{"name":"int16x4_t"}],"output":{"name":"int16x4_t"}}],[5,"vpmin_s32","","Folding minimum of adjacent pairs",null,{"inputs":[{"name":"int32x2_t"},{"name":"int32x2_t"}],"output":{"name":"int32x2_t"}}],[5,"vpmin_u8","","Folding minimum of adjacent pairs",null,{"inputs":[{"name":"uint8x8_t"},{"name":"uint8x8_t"}],"output":{"name":"uint8x8_t"}}],[5,"vpmin_u16","","Folding minimum of adjacent pairs",null,{"inputs":[{"name":"uint16x4_t"},{"name":"uint16x4_t"}],"output":{"name":"uint16x4_t"}}],[5,"vpmin_u32","","Folding minimum of adjacent pairs",null,{"inputs":[{"name":"uint32x2_t"},{"name":"uint32x2_t"}],"output":{"name":"uint32x2_t"}}],[5,"vpmin_f32","","Folding minimum of adjacent pairs",null,{"inputs":[{"name":"float32x2_t"},{"name":"float32x2_t"}],"output":{"name":"float32x2_t"}}],[5,"vpmax_s8","","Folding maximum of adjacent pairs",null,{"inputs":[{"name":"int8x8_t"},{"name":"int8x8_t"}],"output":{"name":"int8x8_t"}}],[5,"vpmax_s16","","Folding maximum of adjacent pairs",null,{"inputs":[{"name":"int16x4_t"},{"name":"int16x4_t"}],"output":{"name":"int16x4_t"}}],[5,"vpmax_s32","","Folding maximum of adjacent pairs",null,{"inputs":[{"name":"int32x2_t"},{"name":"int32x2_t"}],"output":{"name":"int32x2_t"}}],[5,"vpmax_u8","","Folding maximum of adjacent pairs",null,{"inputs":[{"name":"uint8x8_t"},{"name":"uint8x8_t"}],"output":{"name":"uint8x8_t"}}],[5,"vpmax_u16","","Folding maximum of adjacent pairs",null,{"inputs":[{"name":"uint16x4_t"},{"name":"uint16x4_t"}],"output":{"name":"uint16x4_t"}}],[5,"vpmax_u32","","Folding maximum of adjacent pairs",null,{"inputs":[{"name":"uint32x2_t"},{"name":"uint32x2_t"}],"output":{"name":"uint32x2_t"}}],[5,"vpmax_f32","","Folding maximum of adjacent pairs",null,{"inputs":[{"name":"float32x2_t"},{"name":"float32x2_t"}],"output":{"name":"float32x2_t"}}],[0,"mips","core::arch","Platform-specific intrinsics for the `mips` platform.",null,null],[5,"__msa_add_a_b","core::arch::mips","Vector Add Absolute Values.",null,{"inputs":[{"name":"i8x16"},{"name":"i8x16"}],"output":{"name":"i8x16"}}],[0,"mips64","core::arch","Platform-specific intrinsics for the `mips64` platform.",null,null],[5,"__msa_add_a_b","core::arch::mips64","Vector Add Absolute Values.",null,{"inputs":[{"name":"i8x16"},{"name":"i8x16"}],"output":{"name":"i8x16"}}],[14,"panic","core","Entry point of thread panic, for details, see std::macros",null,null],[14,"assert_eq","","Asserts that two expressions are equal to each other (using [`PartialEq`]).",null,null],[14,"assert_ne","","Asserts that two expressions are not equal to each other (using [`PartialEq`]).",null,null],[14,"debug_assert","","Ensure that a boolean expression is `true` at runtime.",null,null],[14,"debug_assert_eq","","Asserts that two expressions are equal to each other.",null,null],[14,"debug_assert_ne","","Asserts that two expressions are not equal to each other.",null,null],[14,"try","","Helper macro for reducing boilerplate code for matching `Result` together with converting downstream errors.",null,null],[14,"write","","Write formatted data into a buffer.",null,null],[14,"writeln","","Write formatted data into a buffer, with a newline appended.",null,null],[14,"unreachable","","A utility macro for indicating unreachable code.",null,null],[14,"unimplemented","","A standardized placeholder for marking unfinished code.",null,null],[14,"compile_error","","Unconditionally causes compilation to fail with the given error message when encountered.",null,null],[14,"format_args","","The core macro for formatted string creation & output.",null,null],[14,"env","","Inspect an environment variable at compile time.",null,null],[14,"option_env","","Optionally inspect an environment variable at compile time.",null,null],[14,"concat_idents","","Concatenate identifiers into one identifier.",null,null],[14,"concat","","Concatenates literals into a static string slice.",null,null],[14,"line","","A macro which expands to the line number on which it was invoked.",null,null],[14,"column","","A macro which expands to the column number on which it was invoked.",null,null],[14,"file","","A macro which expands to the file name from which it was invoked.",null,null],[14,"stringify","","A macro which stringifies its arguments.",null,null],[14,"include_str","","Includes a utf8-encoded file as a string.",null,null],[14,"include_bytes","","Includes a file as a reference to a byte array.",null,null],[14,"module_path","","Expands to a string that represents the current module path.",null,null],[14,"cfg","","Boolean evaluation of configuration flags, at compile-time.",null,null],[14,"include","","Parse a file as an expression or an item according to the context.",null,null],[14,"assert","","Ensure that a boolean expression is `true` at runtime.",null,null],[11,"contains","core::ops","Returns `true` if `item` is contained in the range.",62,{"inputs":[{"name":"self"},{"name":"u"}],"output":{"name":"bool"}}],[11,"size_hint","core::iter","Returns the bounds on the remaining length of the iterator.",123,null],[11,"count","","Consumes the iterator, counting the number of iterations and returning it.",123,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"last","","Consumes the iterator, returning the last element.",123,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"nth","","Returns the `n`th element of the iterator.",123,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"step_by","","Creates an iterator starting at the same point, but stepping by the given amount at each iteration.",123,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"stepby"}}],[11,"chain","","Takes two iterators and creates a new iterator over both in sequence.",123,{"inputs":[{"name":"self"},{"name":"u"}],"output":{"name":"chain"}}],[11,"zip","","'Zips up' two iterators into a single iterator of pairs.",123,{"inputs":[{"name":"self"},{"name":"u"}],"output":{"name":"zip"}}],[11,"map","","Takes a closure and creates an iterator which calls that closure on each element.",123,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"map"}}],[11,"for_each","","Calls a closure on each element of an iterator.",123,{"inputs":[{"name":"self"},{"name":"f"}],"output":null}],[11,"filter","","Creates an iterator which uses a closure to determine if an element should be yielded.",123,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"filter"}}],[11,"filter_map","","Creates an iterator that both filters and maps.",123,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"filtermap"}}],[11,"enumerate","","Creates an iterator which gives the current iteration count as well as the next value.",123,{"inputs":[{"name":"self"}],"output":{"name":"enumerate"}}],[11,"peekable","","Creates an iterator which can use `peek` to look at the next element of the iterator without consuming it.",123,{"inputs":[{"name":"self"}],"output":{"name":"peekable"}}],[11,"skip_while","","Creates an iterator that [`skip`]s elements based on a predicate.",123,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"skipwhile"}}],[11,"take_while","","Creates an iterator that yields elements based on a predicate.",123,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"takewhile"}}],[11,"skip","","Creates an iterator that skips the first `n` elements.",123,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"skip"}}],[11,"take","","Creates an iterator that yields its first `n` elements.",123,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"take"}}],[11,"scan","","An iterator adaptor similar to [`fold`] that holds internal state and produces a new iterator.",123,{"inputs":[{"name":"self"},{"name":"st"},{"name":"f"}],"output":{"name":"scan"}}],[11,"flat_map","","Creates an iterator that works like map, but flattens nested structure.",123,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"flatmap"}}],[11,"flatten","","Creates an iterator that flattens nested structure.",123,{"inputs":[{"name":"self"}],"output":{"name":"flatten"}}],[11,"fuse","","Creates an iterator which ends after the first [`None`].",123,{"inputs":[{"name":"self"}],"output":{"name":"fuse"}}],[11,"inspect","","Do something with each element of an iterator, passing the value on.",123,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"inspect"}}],[11,"by_ref","","Borrows an iterator, rather than consuming it.",123,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"collect","","Transforms an iterator into a collection.",123,{"inputs":[{"name":"self"}],"output":{"name":"b"}}],[11,"partition","","Consumes an iterator, creating two collections from it.",123,null],[11,"try_fold","","An iterator method that applies a function as long as it returns successfully, producing a single, final value.",123,{"inputs":[{"name":"self"},{"name":"b"},{"name":"f"}],"output":{"name":"r"}}],[11,"try_for_each","","An iterator method that applies a fallible function to each item in the iterator, stopping at the first error and returning that error.",123,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"r"}}],[11,"fold","","An iterator method that applies a function, producing a single, final value.",123,{"inputs":[{"name":"self"},{"name":"b"},{"name":"f"}],"output":{"name":"b"}}],[11,"all","","Tests if every element of the iterator matches a predicate.",123,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"any","","Tests if any element of the iterator matches a predicate.",123,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"find","","Searches for an element of an iterator that satisfies a predicate.",123,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"option"}}],[11,"find_map","","Applies function to the elements of iterator and returns the first non-none result.",123,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"position","","Searches for an element in an iterator, returning its index.",123,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"generics":["usize"],"name":"option"}}],[11,"rposition","","Searches for an element in an iterator from the right, returning its index.",123,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"generics":["usize"],"name":"option"}}],[11,"max","","Returns the maximum element of an iterator.",123,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"min","","Returns the minimum element of an iterator.",123,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"max_by_key","","Returns the element that gives the maximum value from the specified function.",123,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"max_by","","Returns the element that gives the maximum value with respect to the specified comparison function.",123,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"min_by_key","","Returns the element that gives the minimum value from the specified function.",123,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"min_by","","Returns the element that gives the minimum value with respect to the specifie