var searchIndex = {};
searchIndex["alloc"] = {"doc":"The Rust core allocation and collections library","items":[[0,"allocator","alloc","Use the `alloc` module instead.",null,null],[0,"alloc","","Memory allocation APIs",null,null],[3,"Excess","alloc::alloc","Represents the combination of a starting address and a total capacity of the returned block.",null,null],[12,"0","","",0,null],[12,"1","","",0,null],[3,"Layout","","Layout of a block of memory.",null,null],[3,"LayoutErr","","The parameters given to `Layout::from_size_align` or some other `Layout` constructor do not satisfy its documented constraints.",null,null],[3,"AllocErr","","The `AllocErr` error indicates an allocation failure that may be due to resource exhaustion or to something wrong when combining the given input arguments with this allocator.",null,null],[3,"CannotReallocInPlace","","The `CannotReallocInPlace` error is used when `grow_in_place` or `shrink_in_place` were unable to reuse the given memory block for a requested layout.",null,null],[4,"CollectionAllocErr","","Augments `AllocErr` with a CapacityOverflow variant.",null,null],[13,"CapacityOverflow","","Error due to the computed capacity exceeding the collection's maximum (usually `isize::MAX` bytes).",1,null],[13,"AllocErr","","Error due to the allocator (see the `AllocErr` type's docs).",1,null],[8,"GlobalAlloc","","A memory allocator that can be registered as the standard library’s default though the `#[global_allocator]` attributes.",null,null],[10,"alloc","","Allocate memory as described by the given `layout`.",2,null],[10,"dealloc","","Deallocate the block of memory at the given `ptr` pointer with the given `layout`.",2,null],[11,"alloc_zeroed","","Behaves like `alloc`, but also ensures that the contents are set to zero before being returned.",2,null],[11,"realloc","","Shink or grow a block of memory to the given `new_size`. The block is described by the given `ptr` pointer and `layout`.",2,null],[8,"Alloc","","An implementation of `Alloc` can allocate, reallocate, and deallocate arbitrary blocks of data described via `Layout`.",null,null],[10,"alloc","","Returns a pointer meeting the size and alignment guarantees of `layout`.",3,{"i":[{"n":"self"},{"n":"layout"}],"o":{"g":["nonnull","allocerr"],"n":"result"}}],[10,"dealloc","","Deallocate the memory referenced by `ptr`.",3,null],[11,"usable_size","","Returns bounds on the guaranteed usable size of a successful allocation created with the specified `layout`.",3,null],[11,"realloc","","Returns a pointer suitable for holding data described by a new layout with `layout`’s alginment and a size given by `new_size`. To accomplish this, this may extend or shrink the allocation referenced by `ptr` to fit the new layout.",3,{"i":[{"n":"self"},{"g":["u8"],"n":"nonnull"},{"n":"layout"},{"n":"usize"}],"o":{"g":["nonnull","allocerr"],"n":"result"}}],[11,"alloc_zeroed","","Behaves like `alloc`, but also ensures that the contents are set to zero before being returned.",3,{"i":[{"n":"self"},{"n":"layout"}],"o":{"g":["nonnull","allocerr"],"n":"result"}}],[11,"alloc_excess","","Behaves like `alloc`, but also returns the whole size of the returned block. For some `layout` inputs, like arrays, this may include extra storage usable for additional data.",3,{"i":[{"n":"self"},{"n":"layout"}],"o":{"g":["excess","allocerr"],"n":"result"}}],[11,"realloc_excess","","Behaves like `realloc`, but also returns the whole size of the returned block. For some `layout` inputs, like arrays, this may include extra storage usable for additional data.",3,{"i":[{"n":"self"},{"g":["u8"],"n":"nonnull"},{"n":"layout"},{"n":"usize"}],"o":{"g":["excess","allocerr"],"n":"result"}}],[11,"grow_in_place","","Attempts to extend the allocation referenced by `ptr` to fit `new_size`.",3,{"i":[{"n":"self"},{"g":["u8"],"n":"nonnull"},{"n":"layout"},{"n":"usize"}],"o":{"g":["cannotreallocinplace"],"n":"result"}}],[11,"shrink_in_place","","Attempts to shrink the allocation referenced by `ptr` to fit `new_size`.",3,{"i":[{"n":"self"},{"g":["u8"],"n":"nonnull"},{"n":"layout"},{"n":"usize"}],"o":{"g":["cannotreallocinplace"],"n":"result"}}],[11,"alloc_one","","Allocates a block suitable for holding an instance of `T`.",3,{"i":[{"n":"self"}],"o":{"g":["nonnull","allocerr"],"n":"result"}}],[11,"dealloc_one","","Deallocates a block suitable for holding an instance of `T`.",3,null],[11,"alloc_array","","Allocates a block suitable for holding `n` instances of `T`.",3,{"i":[{"n":"self"},{"n":"usize"}],"o":{"g":["nonnull","allocerr"],"n":"result"}}],[11,"realloc_array","","Reallocates a block previously suitable for holding `n_old` instances of `T`, returning a block suitable for holding `n_new` instances of `T`.",3,{"i":[{"n":"self"},{"n":"nonnull"},{"n":"usize"},{"n":"usize"}],"o":{"g":["nonnull","allocerr"],"n":"result"}}],[11,"dealloc_array","","Deallocates a block suitable for holding `n` instances of `T`.",3,{"i":[{"n":"self"},{"n":"nonnull"},{"n":"usize"}],"o":{"g":["allocerr"],"n":"result"}}],[3,"Global","","The global memory allocator.",null,null],[5,"alloc","","Allocate memory with the global allocator.",null,null],[5,"dealloc","","Deallocate memory with the global allocator.",null,null],[5,"realloc","","Reallocate memory with the global allocator.",null,null],[5,"alloc_zeroed","","Allocate zero-initialized memory with the global allocator.",null,null],[5,"handle_alloc_error","","Abort on memory allocation error or failure.",null,null],[11,"clone","","",4,{"i":[{"n":"self"}],"o":{"n":"global"}}],[11,"default","","",4,{"o":{"n":"global"}}],[11,"fmt","","",4,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"alloc","","",4,{"i":[{"n":"self"},{"n":"layout"}],"o":{"g":["nonnull","allocerr"],"n":"result"}}],[11,"dealloc","","",4,{"i":[{"n":"self"},{"g":["u8"],"n":"nonnull"},{"n":"layout"}]}],[11,"realloc","","",4,{"i":[{"n":"self"},{"g":["u8"],"n":"nonnull"},{"n":"layout"},{"n":"usize"}],"o":{"g":["nonnull","allocerr"],"n":"result"}}],[11,"alloc_zeroed","","",4,{"i":[{"n":"self"},{"n":"layout"}],"o":{"g":["nonnull","allocerr"],"n":"result"}}],[0,"task","alloc","Types and Traits for working with asynchronous tasks.",null,null],[4,"Poll","alloc::task","Indicates whether a value is available or if the current task has been scheduled to receive a wakeup instead.",null,null],[13,"Ready","","Represents that a value is immediately ready.",5,null],[13,"Pending","","Represents that a value is not ready yet.",5,null],[3,"Waker","","A `Waker` is a handle for waking up a task by notifying its executor that it is ready to be run.",null,null],[3,"LocalWaker","","A `LocalWaker` is a handle for waking up a task by notifying its executor that it is ready to be run.",null,null],[8,"UnsafeWake","","An unsafe trait for implementing custom memory management for a `Waker` or `LocalWaker`.",null,null],[10,"clone_raw","","Creates a clone of this `UnsafeWake` and stores it behind a `Waker`.",6,{"i":[{"n":"self"}],"o":{"n":"waker"}}],[10,"drop_raw","","Drops this instance of `UnsafeWake`, deallocating resources associated with it.",6,null],[10,"wake","","Indicates that the associated task is ready to make progress and should be `poll`ed.",6,null],[11,"wake_local","","Indicates that the associated task is ready to make progress and should be `poll`ed. This function is the same as `wake`, but can only be called from the thread that this `UnsafeWake` is \"local\" to. This allows for implementors to provide specialized wakeup behavior specific to the current thread. This function is called by `LocalWaker::wake`.",6,null],[3,"Context","","Information about the currently-running task.",null,null],[8,"Executor","","A task executor.",null,null],[10,"spawn_obj","","Spawn the given task, polling it until completion.",7,{"i":[{"n":"self"},{"n":"taskobj"}],"o":{"g":["spawnobjerror"],"n":"result"}}],[11,"status","","Determine whether the executor is able to spawn new tasks.",7,{"i":[{"n":"self"}],"o":{"g":["spawnerrorkind"],"n":"result"}}],[3,"TaskObj","","A custom trait object for polling tasks, roughly akin to `Box<Future<Output = ()> + Send>`.",null,null],[8,"UnsafeTask","","A custom implementation of a task trait object for `TaskObj`, providing a hand-rolled vtable.",null,null],[10,"into_raw","","Convert a owned instance into a (conceptually owned) void pointer.",8,null],[10,"poll","","Poll the task represented by the given void pointer.",8,null],[10,"drop","","Drops the task represented by the given void pointer.",8,null],[3,"SpawnErrorKind","","Provides the reason that an executor was unable to spawn.",null,null],[3,"SpawnObjError","","The result of a failed spawn",null,null],[12,"kind","","The kind of error",9,null],[12,"task","","The task for which spawning was attempted",9,null],[5,"local_waker","","Creates a `LocalWaker` from a local `wake`.",null,{"i":[{"n":"arc"}],"o":{"n":"localwaker"}}],[5,"local_waker_from_nonlocal","","Creates a `LocalWaker` from a non-local `wake`.",null,{"i":[{"n":"arc"}],"o":{"n":"localwaker"}}],[11,"from","","",10,{"i":[{"n":"arc"}],"o":{"n":"self"}}],[8,"Wake","","A way of waking up a specific task.",null,null],[10,"wake","","Indicates that the associated task is ready to make progress and should be `poll`ed.",11,{"i":[{"n":"arc"}]}],[11,"wake_local","","Indicates that the associated task is ready to make progress and should be `poll`ed. This function is like `wake`, but can only be called from the thread on which this `Wake` was created.",11,{"i":[{"n":"arc"}]}],[0,"boxed","alloc","A pointer type for heap allocation.",null,null],[3,"Box","alloc::boxed","A pointer type for heap allocation.",null,null],[3,"PinBox","","A pinned, heap allocated reference.",null,null],[8,"FnBox","","`FnBox` is a version of the `FnOnce` intended for use with boxed closure objects. The idea is that where one would normally store a `Box<FnOnce()>` in a data structure, you should use `Box<FnBox()>`. The two traits behave essentially the same, except that a `FnBox` closure can only be called if it is boxed. (Note that `FnBox` may be deprecated in the future if `Box<FnOnce()>` closures become directly usable.)",null,null],[16,"Output","","",12,null],[10,"call_box","","",12,null],[11,"new","","Allocates memory on the heap and then places `x` into it.",13,{"i":[{"n":"t"}],"o":{"n":"box"}}],[11,"from_raw","","Constructs a box from a raw pointer.",13,null],[11,"into_raw","","Consumes the `Box`, returning the wrapped raw pointer.",13,null],[11,"into_raw_non_null","","Consumes the `Box`, returning the wrapped pointer as `NonNull<T>`.",13,{"i":[{"n":"box"}],"o":{"n":"nonnull"}}],[11,"leak","","Consumes and leaks the `Box`, returning a mutable reference, `&'a mut T`. Here, the lifetime `'a` may be chosen to be `'static`.",13,{"i":[{"n":"box"}],"o":{"n":"t"}}],[11,"drop","","",13,{"i":[{"n":"self"}]}],[11,"default","","Creates a `Box<T>`, with the `Default` value for T.",13,{"o":{"n":"box"}}],[11,"default","","",13,{"o":{"n":"box"}}],[11,"default","","",13,{"o":{"g":["str"],"n":"box"}}],[11,"clone","","Returns a new box with a `clone()` of this box's contents.",13,{"i":[{"n":"self"}],"o":{"n":"box"}}],[11,"clone_from","","Copies `source`'s contents into `self` without creating a new allocation.",13,{"i":[{"n":"self"},{"n":"box"}]}],[11,"clone","","",13,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"eq","","",13,{"i":[{"n":"self"},{"n":"box"}],"o":{"n":"bool"}}],[11,"ne","","",13,{"i":[{"n":"self"},{"n":"box"}],"o":{"n":"bool"}}],[11,"partial_cmp","","",13,{"i":[{"n":"self"},{"n":"box"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",13,{"i":[{"n":"self"},{"n":"box"}],"o":{"n":"bool"}}],[11,"le","","",13,{"i":[{"n":"self"},{"n":"box"}],"o":{"n":"bool"}}],[11,"ge","","",13,{"i":[{"n":"self"},{"n":"box"}],"o":{"n":"bool"}}],[11,"gt","","",13,{"i":[{"n":"self"},{"n":"box"}],"o":{"n":"bool"}}],[11,"cmp","","",13,{"i":[{"n":"self"},{"n":"box"}],"o":{"n":"ordering"}}],[11,"hash","","",13,{"i":[{"n":"self"},{"n":"h"}]}],[11,"finish","","",13,{"i":[{"n":"self"}],"o":{"n":"u64"}}],[11,"write","","",13,null],[11,"write_u8","","",13,{"i":[{"n":"self"},{"n":"u8"}]}],[11,"write_u16","","",13,{"i":[{"n":"self"},{"n":"u16"}]}],[11,"write_u32","","",13,{"i":[{"n":"self"},{"n":"u32"}]}],[11,"write_u64","","",13,{"i":[{"n":"self"},{"n":"u64"}]}],[11,"write_u128","","",13,{"i":[{"n":"self"},{"n":"u128"}]}],[11,"write_usize","","",13,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"write_i8","","",13,{"i":[{"n":"self"},{"n":"i8"}]}],[11,"write_i16","","",13,{"i":[{"n":"self"},{"n":"i16"}]}],[11,"write_i32","","",13,{"i":[{"n":"self"},{"n":"i32"}]}],[11,"write_i64","","",13,{"i":[{"n":"self"},{"n":"i64"}]}],[11,"write_i128","","",13,{"i":[{"n":"self"},{"n":"i128"}]}],[11,"write_isize","","",13,{"i":[{"n":"self"},{"n":"isize"}]}],[11,"from","","",13,{"i":[{"n":"t"}],"o":{"n":"self"}}],[11,"from","","",13,null],[11,"from","","",13,{"i":[{"n":"str"}],"o":{"g":["str"],"n":"box"}}],[11,"from","","",13,{"i":[{"g":["str"],"n":"box"}],"o":{"n":"self"}}],[11,"downcast","","Attempt to downcast the box to a concrete type.",13,{"i":[{"n":"self"}],"o":{"g":["box","box"],"n":"result"}}],[11,"downcast","","Attempt to downcast the box to a concrete type.",13,{"i":[{"n":"self"}],"o":{"g":["box","box"],"n":"result"}}],[11,"fmt","","",13,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",13,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",13,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"deref","","",13,{"i":[{"n":"self"}],"o":{"n":"t"}}],[11,"deref_mut","","",13,{"i":[{"n":"self"}],"o":{"n":"t"}}],[11,"next","","",13,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",13,null],[11,"nth","","",13,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"option"}}],[11,"next_back","","",13,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"len","","",13,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"is_empty","","",13,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"call_once","","",13,{"i":[{"n":"self"},{"n":"a"}],"o":{"n":"r"}}],[11,"call_once","","",13,{"i":[{"n":"self"},{"n":"a"}],"o":{"n":"r"}}],[11,"clone","","",13,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"borrow","","",13,{"i":[{"n":"self"}],"o":{"n":"t"}}],[11,"borrow_mut","","",13,{"i":[{"n":"self"}],"o":{"n":"t"}}],[11,"as_ref","","",13,{"i":[{"n":"self"}],"o":{"n":"t"}}],[11,"as_mut","","",13,{"i":[{"n":"self"}],"o":{"n":"t"}}],[11,"resume","","",13,{"i":[{"n":"self"}],"o":{"n":"generatorstate"}}],[11,"new","","Allocate memory on the heap, move the data into it and pin it.",14,{"i":[{"n":"t"}],"o":{"n":"pinbox"}}],[11,"as_pin_mut","","Get a pinned reference to the data in this PinBox.",14,{"i":[{"n":"self"}],"o":{"n":"pinmut"}}],[11,"from_raw","","Constructs a `PinBox` from a raw pointer.",14,null],[11,"into_raw","","Consumes the `PinBox`, returning the wrapped raw pointer.",14,null],[11,"get_mut","","Get a mutable reference to the data inside this PinBox.",14,{"i":[{"n":"pinbox"}],"o":{"n":"t"}}],[11,"unpin","","Convert this PinBox into an unpinned Box.",14,{"i":[{"n":"pinbox"}],"o":{"n":"box"}}],[11,"from","","",14,{"i":[{"n":"box"}],"o":{"n":"pinbox"}}],[11,"from","","",13,{"i":[{"n":"pinbox"}],"o":{"n":"box"}}],[11,"deref","","",14,{"i":[{"n":"self"}],"o":{"n":"t"}}],[11,"deref_mut","","",14,{"i":[{"n":"self"}],"o":{"n":"t"}}],[11,"fmt","","",14,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",14,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",14,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"poll","","",13,{"i":[{"n":"pinmut"},{"n":"context"}],"o":{"n":"poll"}}],[11,"poll","","",14,{"i":[{"n":"pinmut"},{"n":"context"}],"o":{"n":"poll"}}],[11,"into_raw","","",14,null],[11,"poll","","",14,null],[11,"drop","","",14,null],[11,"from","alloc::task","",15,{"i":[{"n":"pinbox"}],"o":{"n":"self"}}],[11,"from","","",15,{"i":[{"n":"box"}],"o":{"n":"self"}}],[0,"arc","alloc","Thread-safe reference-counting pointers.",null,null],[3,"Arc","alloc::arc","A thread-safe reference-counting pointer. 'Arc' stands for 'Atomically Reference Counted'.",null,null],[3,"Weak","","`Weak` is a version of [`Arc`] that holds a non-owning reference to the managed value. The value is accessed by calling [`upgrade`] on the `Weak` pointer, which returns an [`Option`]`<`[`Arc`]`<T>>`.",null,null],[11,"fmt","","",16,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","Constructs a new `Arc<T>`.",17,{"i":[{"n":"t"}],"o":{"n":"arc"}}],[11,"try_unwrap","","Returns the contained value, if the `Arc` has exactly one strong reference.",17,{"i":[{"n":"self"}],"o":{"n":"result"}}],[11,"into_raw","","Consumes the `Arc`, returning the wrapped pointer.",17,null],[11,"from_raw","","Constructs an `Arc` from a raw pointer.",17,null],[11,"downgrade","","Creates a new [`Weak`][weak] pointer to this value.",17,{"i":[{"n":"self"}],"o":{"n":"weak"}}],[11,"weak_count","","Gets the number of [`Weak`][weak] pointers to this value.",17,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"strong_count","","Gets the number of strong (`Arc`) pointers to this value.",17,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"ptr_eq","","Returns true if the two `Arc`s point to the same value (not just values that compare as equal).",17,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"bool"}}],[11,"clone","","Makes a clone of the `Arc` pointer.",17,{"i":[{"n":"self"}],"o":{"n":"arc"}}],[11,"deref","","",17,{"i":[{"n":"self"}],"o":{"n":"t"}}],[11,"make_mut","","Makes a mutable reference into the given `Arc`.",17,{"i":[{"n":"self"}],"o":{"n":"t"}}],[11,"get_mut","","Returns a mutable reference to the inner value, if there are no other `Arc` or [`Weak`][weak] pointers to the same value.",17,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"drop","","Drops the `Arc`.",17,{"i":[{"n":"self"}]}],[11,"downcast","","Attempt to downcast the `Arc<Any + Send + Sync>` to a concrete type.",17,{"i":[{"n":"self"}],"o":{"g":["arc"],"n":"result"}}],[11,"new","","Constructs a new `Weak<T>`, allocating memory for `T` without initializing it. Calling [`upgrade`] on the return value always gives [`None`].",16,{"o":{"n":"weak"}}],[11,"upgrade","","Attempts to upgrade the `Weak` pointer to an [`Arc`], extending the lifetime of the value if successful.",16,{"i":[{"n":"self"}],"o":{"g":["arc"],"n":"option"}}],[11,"clone","","Makes a clone of the `Weak` pointer that points to the same value.",16,{"i":[{"n":"self"}],"o":{"n":"weak"}}],[11,"default","","Constructs a new `Weak<T>`, allocating memory for `T` without initializing it. Calling [`upgrade`] on the return value always gives [`None`].",16,{"o":{"n":"weak"}}],[11,"drop","","Drops the `Weak` pointer.",16,{"i":[{"n":"self"}]}],[11,"eq","","Equality for two `Arc`s.",17,{"i":[{"n":"self"},{"n":"arc"}],"o":{"n":"bool"}}],[11,"ne","","Inequality for two `Arc`s.",17,{"i":[{"n":"self"},{"n":"arc"}],"o":{"n":"bool"}}],[11,"partial_cmp","","Partial comparison for two `Arc`s.",17,{"i":[{"n":"self"},{"n":"arc"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","Less-than comparison for two `Arc`s.",17,{"i":[{"n":"self"},{"n":"arc"}],"o":{"n":"bool"}}],[11,"le","","'Less than or equal to' comparison for two `Arc`s.",17,{"i":[{"n":"self"},{"n":"arc"}],"o":{"n":"bool"}}],[11,"gt","","Greater-than comparison for two `Arc`s.",17,{"i":[{"n":"self"},{"n":"arc"}],"o":{"n":"bool"}}],[11,"ge","","'Greater than or equal to' comparison for two `Arc`s.",17,{"i":[{"n":"self"},{"n":"arc"}],"o":{"n":"bool"}}],[11,"cmp","","Comparison for two `Arc`s.",17,{"i":[{"n":"self"},{"n":"arc"}],"o":{"n":"ordering"}}],[11,"fmt","","",17,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",17,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",17,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"default","","Creates a new `Arc<T>`, with the `Default` value for `T`.",17,{"o":{"n":"arc"}}],[11,"hash","","",17,{"i":[{"n":"self"},{"n":"h"}]}],[11,"from","","",17,{"i":[{"n":"t"}],"o":{"n":"self"}}],[11,"from","","",17,null],[11,"from","","",17,{"i":[{"n":"str"}],"o":{"g":["str"],"n":"arc"}}],[11,"from","","",17,{"i":[{"n":"string"}],"o":{"g":["str"],"n":"arc"}}],[11,"from","","",17,{"i":[{"n":"box"}],"o":{"n":"arc"}}],[11,"from","","",17,{"i":[{"n":"vec"}],"o":{"n":"arc"}}],[11,"borrow","","",17,{"i":[{"n":"self"}],"o":{"n":"t"}}],[11,"as_ref","","",17,{"i":[{"n":"self"}],"o":{"n":"t"}}],[0,"rc","alloc","Single-threaded reference-counting pointers. 'Rc' stands for 'Reference Counted'.",null,null],[3,"Rc","alloc::rc","A single-threaded reference-counting pointer. 'Rc' stands for 'Reference Counted'.",null,null],[3,"Weak","","`Weak` is a version of [`Rc`] that holds a non-owning reference to the managed value. The value is accessed by calling [`upgrade`] on the `Weak` pointer, which returns an [`Option`]`<`[`Rc`]`<T>>`.",null,null],[11,"new","","Constructs a new `Rc<T>`.",18,{"i":[{"n":"t"}],"o":{"n":"rc"}}],[11,"try_unwrap","","Returns the contained value, if the `Rc` has exactly one strong reference.",18,{"i":[{"n":"self"}],"o":{"n":"result"}}],[11,"into_raw","","Consumes the `Rc`, returning the wrapped pointer.",18,null],[11,"from_raw","","Constructs an `Rc` from a raw pointer.",18,null],[11,"downgrade","","Creates a new [`Weak`][weak] pointer to this value.",18,{"i":[{"n":"self"}],"o":{"n":"weak"}}],[11,"weak_count","","Gets the number of [`Weak`][weak] pointers to this value.",18,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"strong_count","","Gets the number of strong (`Rc`) pointers to this value.",18,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"get_mut","","Returns a mutable reference to the inner value, if there are no other `Rc` or [`Weak`][weak] pointers to the same value.",18,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"ptr_eq","","Returns true if the two `Rc`s point to the same value (not just values that compare as equal).",18,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"bool"}}],[11,"make_mut","","Makes a mutable reference into the given `Rc`.",18,{"i":[{"n":"self"}],"o":{"n":"t"}}],[11,"downcast","","Attempt to downcast the `Rc<Any>` to a concrete type.",18,{"i":[{"n":"self"}],"o":{"g":["rc","rc"],"n":"result"}}],[11,"deref","","",18,{"i":[{"n":"self"}],"o":{"n":"t"}}],[11,"drop","","Drops the `Rc`.",18,{"i":[{"n":"self"}]}],[11,"clone","","Makes a clone of the `Rc` pointer.",18,{"i":[{"n":"self"}],"o":{"n":"rc"}}],[11,"default","","Creates a new `Rc<T>`, with the `Default` value for `T`.",18,{"o":{"n":"rc"}}],[11,"eq","","Equality for two `Rc`s.",18,{"i":[{"n":"self"},{"n":"rc"}],"o":{"n":"bool"}}],[11,"ne","","Inequality for two `Rc`s.",18,{"i":[{"n":"self"},{"n":"rc"}],"o":{"n":"bool"}}],[11,"partial_cmp","","Partial comparison for two `Rc`s.",18,{"i":[{"n":"self"},{"n":"rc"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","Less-than comparison for two `Rc`s.",18,{"i":[{"n":"self"},{"n":"rc"}],"o":{"n":"bool"}}],[11,"le","","'Less than or equal to' comparison for two `Rc`s.",18,{"i":[{"n":"self"},{"n":"rc"}],"o":{"n":"bool"}}],[11,"gt","","Greater-than comparison for two `Rc`s.",18,{"i":[{"n":"self"},{"n":"rc"}],"o":{"n":"bool"}}],[11,"ge","","'Greater than or equal to' comparison for two `Rc`s.",18,{"i":[{"n":"self"},{"n":"rc"}],"o":{"n":"bool"}}],[11,"cmp","","Comparison for two `Rc`s.",18,{"i":[{"n":"self"},{"n":"rc"}],"o":{"n":"ordering"}}],[11,"hash","","",18,{"i":[{"n":"self"},{"n":"h"}]}],[11,"fmt","","",18,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",18,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",18,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"from","","",18,{"i":[{"n":"t"}],"o":{"n":"self"}}],[11,"from","","",18,null],[11,"from","","",18,{"i":[{"n":"str"}],"o":{"g":["str"],"n":"rc"}}],[11,"from","","",18,{"i":[{"n":"string"}],"o":{"g":["str"],"n":"rc"}}],[11,"from","","",18,{"i":[{"n":"box"}],"o":{"n":"rc"}}],[11,"from","","",18,{"i":[{"n":"vec"}],"o":{"n":"rc"}}],[11,"new","","Constructs a new `Weak<T>`, allocating memory for `T` without initializing it. Calling [`upgrade`] on the return value always gives [`None`].",19,{"o":{"n":"weak"}}],[11,"upgrade","","Attempts to upgrade the `Weak` pointer to an [`Rc`], extending the lifetime of the value if successful.",19,{"i":[{"n":"self"}],"o":{"g":["rc"],"n":"option"}}],[11,"drop","","Drops the `Weak` pointer.",19,{"i":[{"n":"self"}]}],[11,"clone","","Makes a clone of the `Weak` pointer that points to the same value.",19,{"i":[{"n":"self"}],"o":{"n":"weak"}}],[11,"fmt","","",19,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"default","","Constructs a new `Weak<T>`, allocating memory for `T` without initializing it. Calling [`upgrade`] on the return value always gives [`None`].",19,{"o":{"n":"weak"}}],[11,"borrow","","",18,{"i":[{"n":"self"}],"o":{"n":"t"}}],[11,"as_ref","","",18,{"i":[{"n":"self"}],"o":{"n":"t"}}],[0,"raw_vec","alloc","",null,null],[3,"RawVec","alloc::raw_vec","A low-level utility for more ergonomically allocating, reallocating, and deallocating a buffer of memory on the heap without having to worry about all the corner cases involved. This type is excellent for building your own data structures like Vec and VecDeque. In particular:",null,null],[11,"new_in","","Like `new` but parameterized over the choice of allocator for the returned RawVec.",20,{"i":[{"n":"a"}],"o":{"n":"self"}}],[11,"with_capacity_in","","Like `with_capacity` but parameterized over the choice of allocator for the returned RawVec.",20,{"i":[{"n":"usize"},{"n":"a"}],"o":{"n":"self"}}],[11,"with_capacity_zeroed_in","","Like `with_capacity_zeroed` but parameterized over the choice of allocator for the returned RawVec.",20,{"i":[{"n":"usize"},{"n":"a"}],"o":{"n":"self"}}],[11,"new","","Creates the biggest possible RawVec (on the system heap) without allocating. If T has positive size, then this makes a RawVec with capacity 0. If T has 0 size, then it makes a RawVec with capacity `usize::MAX`. Useful for implementing delayed allocation.",20,{"o":{"n":"self"}}],[11,"with_capacity","","Creates a RawVec (on the system heap) with exactly the capacity and alignment requirements for a `[T; cap]`. This is equivalent to calling RawVec::new when `cap` is 0 or T is zero-sized. Note that if `T` is zero-sized this means you will not get a RawVec with the requested capacity!",20,{"i":[{"n":"usize"}],"o":{"n":"self"}}],[11,"with_capacity_zeroed","","Like `with_capacity` but guarantees the buffer is zeroed.",20,{"i":[{"n":"usize"}],"o":{"n":"self"}}],[11,"from_raw_parts_in","","Reconstitutes a RawVec from a pointer, capacity, and allocator.",20,null],[11,"from_raw_parts","","Reconstitutes a RawVec from a pointer, capacity.",20,null],[11,"from_box","","Converts a `Box<[T]>` into a `RawVec<T>`.",20,{"i":[{"n":"box"}],"o":{"n":"self"}}],[11,"ptr","","Gets a raw pointer to the start of the allocation. Note that this is Unique::empty() if `cap = 0` or T is zero-sized. In the former case, you must be careful.",20,null],[11,"cap","","Gets the capacity of the allocation.",20,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"alloc","","Returns a shared reference to the allocator backing this RawVec.",20,{"i":[{"n":"self"}],"o":{"n":"a"}}],[11,"alloc_mut","","Returns a mutable reference to the allocator backing this RawVec.",20,{"i":[{"n":"self"}],"o":{"n":"a"}}],[11,"double","","Doubles the size of the type's backing allocation. This is common enough to want to do that it's easiest to just have a dedicated method. Slightly more efficient logic can be provided for this than the general case.",20,{"i":[{"n":"self"}]}],[11,"double_in_place","","Attempts to double the size of the type's backing allocation in place. This is common enough to want to do that it's easiest to just have a dedicated method. Slightly more efficient logic can be provided for this than the general case.",20,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"try_reserve_exact","","The same as `reserve_exact`, but returns on errors instead of panicking or aborting.",20,{"i":[{"n":"self"},{"n":"usize"},{"n":"usize"}],"o":{"g":["collectionallocerr"],"n":"result"}}],[11,"reserve_exact","","Ensures that the buffer contains at least enough space to hold `used_cap + needed_extra_cap` elements. If it doesn't already, will reallocate the minimum possible amount of memory necessary. Generally this will be exactly the amount of memory necessary, but in principle the allocator is free to give back more than we asked for.",20,{"i":[{"n":"self"},{"n":"usize"},{"n":"usize"}]}],[11,"try_reserve","","The same as `reserve`, but returns on errors instead of panicking or aborting.",20,{"i":[{"n":"self"},{"n":"usize"},{"n":"usize"}],"o":{"g":["collectionallocerr"],"n":"result"}}],[11,"reserve","","Ensures that the buffer contains at least enough space to hold `used_cap + needed_extra_cap` elements. If it doesn't already have enough capacity, will reallocate enough space plus comfortable slack space to get amortized `O(1)` behavior. Will limit this behavior if it would needlessly cause itself to panic.",20,{"i":[{"n":"self"},{"n":"usize"},{"n":"usize"}]}],[11,"reserve_in_place","","Attempts to ensure that the buffer contains at least enough space to hold `used_cap + needed_extra_cap` elements. If it doesn't already have enough capacity, will reallocate in place enough space plus comfortable slack space to get amortized `O(1)` behavior. Will limit this behaviour if it would needlessly cause itself to panic.",20,{"i":[{"n":"self"},{"n":"usize"},{"n":"usize"}],"o":{"n":"bool"}}],[11,"shrink_to_fit","","Shrinks the allocation down to the specified amount. If the given amount is 0, actually completely deallocates.",20,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"into_box","","Converts the entire buffer into `Box<[T]>`.",20,{"i":[{"n":"self"}],"o":{"n":"box"}}],[11,"dealloc_buffer","","Frees the memory owned by the RawVec without trying to Drop its contents.",20,{"i":[{"n":"self"}]}],[11,"drop","","Frees the memory owned by the RawVec without trying to Drop its contents.",20,{"i":[{"n":"self"}]}],[0,"binary_heap","alloc","A priority queue implemented with a binary heap.",null,null],[3,"BinaryHeap","alloc::binary_heap","A priority queue implemented with a binary heap.",null,null],[3,"PeekMut","","Structure wrapping a mutable reference to the greatest item on a `BinaryHeap`.",null,null],[3,"Iter","","An iterator over the elements of a `BinaryHeap`.",null,null],[3,"IntoIter","","An owning iterator over the elements of a `BinaryHeap`.",null,null],[3,"Drain","","A draining iterator over the elements of a `BinaryHeap`.",null,null],[11,"fmt","","",21,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"drop","","",21,{"i":[{"n":"self"}]}],[11,"deref","","",21,{"i":[{"n":"self"}],"o":{"n":"t"}}],[11,"deref_mut","","",21,{"i":[{"n":"self"}],"o":{"n":"t"}}],[11,"pop","","Removes the peeked value from the heap and returns it.",21,{"i":[{"n":"peekmut"}],"o":{"n":"t"}}],[11,"clone","","",22,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"clone_from","","",22,{"i":[{"n":"self"},{"n":"self"}]}],[11,"default","","Creates an empty `BinaryHeap<T>`.",22,{"o":{"n":"binaryheap"}}],[11,"fmt","","",22,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","Creates an empty `BinaryHeap` as a max-heap.",22,{"o":{"n":"binaryheap"}}],[11,"with_capacity","","Creates an empty `BinaryHeap` with a specific capacity. This preallocates enough memory for `capacity` elements, so that the `BinaryHeap` does not have to be reallocated until it contains at least that many values.",22,{"i":[{"n":"usize"}],"o":{"n":"binaryheap"}}],[11,"iter","","Returns an iterator visiting all values in the underlying vector, in arbitrary order.",22,{"i":[{"n":"self"}],"o":{"n":"iter"}}],[11,"peek","","Returns the greatest item in the binary heap, or `None` if it is empty.",22,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"peek_mut","","Returns a mutable reference to the greatest item in the binary heap, or `None` if it is empty.",22,{"i":[{"n":"self"}],"o":{"g":["peekmut"],"n":"option"}}],[11,"capacity","","Returns the number of elements the binary heap can hold without reallocating.",22,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"reserve_exact","","Reserves the minimum capacity for exactly `additional` more elements to be inserted in the given `BinaryHeap`. Does nothing if the capacity is already sufficient.",22,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"reserve","","Reserves capacity for at least `additional` more elements to be inserted in the `BinaryHeap`. The collection may reserve more space to avoid frequent reallocations.",22,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shrink_to_fit","","Discards as much additional capacity as possible.",22,{"i":[{"n":"self"}]}],[11,"shrink_to","","Discards capacity with a lower bound.",22,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"pop","","Removes the greatest item from the binary heap and returns it, or `None` if it is empty.",22,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"push","","Pushes an item onto the binary heap.",22,{"i":[{"n":"self"},{"n":"t"}]}],[11,"into_vec","","Consumes the `BinaryHeap` and returns the underlying vector in arbitrary order.",22,{"i":[{"n":"self"}],"o":{"n":"vec"}}],[11,"into_sorted_vec","","Consumes the `BinaryHeap` and returns a vector in sorted (ascending) order.",22,{"i":[{"n":"self"}],"o":{"n":"vec"}}],[11,"len","","Returns the length of the binary heap.",22,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"is_empty","","Checks if the binary heap is empty.",22,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"drain","","Clears the binary heap, returning an iterator over the removed elements.",22,{"i":[{"n":"self"}],"o":{"n":"drain"}}],[11,"clear","","Drops all items from the binary heap.",22,{"i":[{"n":"self"}]}],[11,"append","","Moves all the elements of `other` into `self`, leaving `other` empty.",22,{"i":[{"n":"self"},{"n":"self"}]}],[11,"fmt","","",23,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",23,{"i":[{"n":"self"}],"o":{"n":"iter"}}],[11,"next","","",23,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",23,null],[11,"next_back","","",23,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"is_empty","","",23,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"clone","","",24,{"i":[{"n":"self"}],"o":{"n":"intoiter"}}],[11,"fmt","","",24,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",24,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",24,null],[11,"next_back","","",24,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"is_empty","","",24,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"fmt","","",25,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",25,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",25,null],[11,"next_back","","",25,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"is_empty","","",25,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"from","","",22,{"i":[{"n":"vec"}],"o":{"n":"binaryheap"}}],[11,"from_iter","","",22,{"i":[{"n":"i"}],"o":{"n":"binaryheap"}}],[11,"into_iter","","Creates a consuming iterator, that is, one that moves each value out of the binary heap in arbitrary order. The binary heap cannot be used after calling this.",22,{"i":[{"n":"self"}],"o":{"n":"intoiter"}}],[11,"extend","","",22,{"i":[{"n":"self"},{"n":"i"}]}],[11,"extend","","",22,{"i":[{"n":"self"},{"n":"i"}]}],[0,"borrow","alloc","A module for working with borrowed data.",null,null],[8,"Borrow","alloc::borrow","A trait for borrowing data.",null,null],[10,"borrow","","Immutably borrows from an owned value.",26,{"i":[{"n":"self"}],"o":{"n":"borrowed"}}],[8,"BorrowMut","","A trait for mutably borrowing data.",null,null],[10,"borrow_mut","","Mutably borrows from an owned value.",27,{"i":[{"n":"self"}],"o":{"n":"borrowed"}}],[4,"Cow","","A clone-on-write smart pointer.",null,null],[13,"Borrowed","","Borrowed data.",28,null],[13,"Owned","","Owned data.",28,null],[8,"ToOwned","","A generalization of `Clone` to borrowed data.",null,null],[16,"Owned","","",29,null],[10,"to_owned","","Creates owned data from borrowed data, usually by cloning.",29,null],[11,"clone_into","","Uses borrowed data to replace owned data, usually by cloning.",29,null],[11,"borrow","","",28,{"i":[{"n":"self"}],"o":{"n":"b"}}],[11,"clone","","",28,{"i":[{"n":"self"}],"o":{"n":"cow"}}],[11,"clone_from","","",28,{"i":[{"n":"self"},{"n":"cow"}]}],[11,"to_mut","","Acquires a mutable reference to the owned form of the data.",28,null],[11,"into_owned","","Extracts the owned data.",28,null],[11,"deref","","",28,{"i":[{"n":"self"}],"o":{"n":"b"}}],[11,"cmp","","",28,{"i":[{"n":"self"},{"n":"cow"}],"o":{"n":"ordering"}}],[11,"eq","","",28,{"i":[{"n":"self"},{"n":"cow"}],"o":{"n":"bool"}}],[11,"partial_cmp","","",28,{"i":[{"n":"self"},{"n":"cow"}],"o":{"g":["ordering"],"n":"option"}}],[11,"fmt","","",28,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",28,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"default","","Creates an owned Cow<'a, B> with the default value for the contained owned value.",28,{"o":{"n":"cow"}}],[11,"hash","","",28,{"i":[{"n":"self"},{"n":"h"}]}],[11,"as_ref","","",28,{"i":[{"n":"self"}],"o":{"n":"t"}}],[11,"add","","",28,null],[11,"add","","",28,null],[11,"add_assign","","",28,{"i":[{"n":"self"},{"n":"str"}]}],[11,"add_assign","","",28,{"i":[{"n":"self"},{"g":["str"],"n":"cow"}]}],[0,"fmt","alloc","Utilities for formatting and printing `String`s.",null,null],[3,"Formatter","alloc::fmt","A struct to represent both where to emit formatting strings to and how they should be formatted. A mutable version of this is passed to all formatting traits.",null,null],[6,"Result","","The type returned by formatter methods.",null,null],[8,"Write","","A collection of methods that are required to format a message into a stream.",null,null],[10,"write_str","","Writes a slice of bytes into this writer, returning whether the write succeeded.",30,{"i":[{"n":"self"},{"n":"str"}],"o":{"g":["error"],"n":"result"}}],[11,"write_char","","Writes a [`char`] into this writer, returning whether the write succeeded.",30,{"i":[{"n":"self"},{"n":"char"}],"o":{"g":["error"],"n":"result"}}],[11,"write_fmt","","Glue for usage of the [`write!`] macro with implementors of this trait.",30,{"i":[{"n":"self"},{"n":"arguments"}],"o":{"g":["error"],"n":"result"}}],[8,"Binary","","`b` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",31,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[8,"Octal","","`o` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",32,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[8,"Debug","","`?` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",33,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[8,"Display","","Format trait for an empty format, `{}`.",null,null],[10,"fmt","","Formats the value using the given formatter.",34,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[8,"LowerHex","","`x` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",35,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[8,"Pointer","","`p` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",36,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[8,"UpperHex","","`X` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",37,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[8,"LowerExp","","`e` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",38,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[8,"UpperExp","","`E` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",39,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[3,"Error","","The error type which is returned from formatting a message into a stream.",null,null],[5,"write","","The `write` function takes an output stream, and an `Arguments` struct that can be precompiled with the `format_args!` macro.",null,{"i":[{"n":"write"},{"n":"arguments"}],"o":{"g":["error"],"n":"result"}}],[3,"Arguments","","This structure represents a safely precompiled version of a format string and its arguments. This cannot be generated at runtime because it cannot safely be done, so no constructors are given and the fields are private to prevent modification.",null,null],[3,"DebugList","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugMap","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugSet","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugStruct","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugTuple","","A struct to help with `fmt::Debug` implementations.",null,null],[4,"Alignment","","Possible alignments returned by `Formatter::align`",null,null],[13,"Left","","Indication that contents should be left-aligned.",40,null],[13,"Right","","Indication that contents should be right-aligned.",40,null],[13,"Center","","Indication that contents should be center-aligned.",40,null],[5,"format","","The `format` function takes an [`Arguments`] struct and returns the resulting formatted string.",null,{"i":[{"n":"arguments"}],"o":{"n":"string"}}],[0,"linked_list","alloc","A doubly-linked list with owned nodes.",null,null],[3,"LinkedList","alloc::linked_list","A doubly-linked list with owned nodes.",null,null],[3,"Iter","","An iterator over the elements of a `LinkedList`.",null,null],[3,"IterMut","","A mutable iterator over the elements of a `LinkedList`.",null,null],[3,"IntoIter","","An owning iterator over the elements of a `LinkedList`.",null,null],[3,"DrainFilter","","An iterator produced by calling `drain_filter` on LinkedList.",null,null],[11,"fmt","","",41,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",41,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"fmt","","",42,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",43,{"i":[{"n":"self"}],"o":{"n":"intoiter"}}],[11,"fmt","","",43,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"default","","Creates an empty `LinkedList<T>`.",44,{"o":{"n":"self"}}],[11,"new","","Creates an empty `LinkedList`.",44,{"o":{"n":"self"}}],[11,"append","","Moves all elements from `other` to the end of the list.",44,{"i":[{"n":"self"},{"n":"self"}]}],[11,"iter","","Provides a forward iterator.",44,{"i":[{"n":"self"}],"o":{"n":"iter"}}],[11,"iter_mut","","Provides a forward iterator with mutable references.",44,{"i":[{"n":"self"}],"o":{"n":"itermut"}}],[11,"is_empty","","Returns `true` if the `LinkedList` is empty.",44,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"len","","Returns the length of the `LinkedList`.",44,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"clear","","Removes all elements from the `LinkedList`.",44,{"i":[{"n":"self"}]}],[11,"contains","","Returns `true` if the `LinkedList` contains an element equal to the given value.",44,{"i":[{"n":"self"},{"n":"t"}],"o":{"n":"bool"}}],[11,"front","","Provides a reference to the front element, or `None` if the list is empty.",44,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"front_mut","","Provides a mutable reference to the front element, or `None` if the list is empty.",44,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"back","","Provides a reference to the back element, or `None` if the list is empty.",44,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"back_mut","","Provides a mutable reference to the back element, or `None` if the list is empty.",44,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"push_front","","Adds an element first in the list.",44,{"i":[{"n":"self"},{"n":"t"}]}],[11,"pop_front","","Removes the first element and returns it, or `None` if the list is empty.",44,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"push_back","","Appends an element to the back of a list",44,{"i":[{"n":"self"},{"n":"t"}]}],[11,"pop_back","","Removes the last element from a list and returns it, or `None` if it is empty.",44,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"split_off","","Splits the list into two at the given index. Returns everything after the given index, including the index.",44,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"linkedlist"}}],[11,"drain_filter","","Creates an iterator which uses a closure to determine if an element should be removed.",44,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"drainfilter"}}],[11,"drop","","",44,{"i":[{"n":"self"}]}],[11,"next","","",41,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",41,null],[11,"next_back","","",41,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"next","","",42,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",42,null],[11,"next_back","","",42,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"insert_next","","Inserts the given element just after the element most recently returned by `.next()`. The inserted element does not appear in the iteration.",42,{"i":[{"n":"self"},{"n":"t"}]}],[11,"peek_next","","Provides a reference to the next element, without changing the iterator.",42,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"next","","",45,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",45,null],[11,"drop","","",45,{"i":[{"n":"self"}]}],[11,"fmt","","",45,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",43,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",43,null],[11,"next_back","","",43,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"from_iter","","",44,{"i":[{"n":"i"}],"o":{"n":"self"}}],[11,"into_iter","","Consumes the list into an iterator yielding elements by value.",44,{"i":[{"n":"self"}],"o":{"n":"intoiter"}}],[11,"extend","","",44,{"i":[{"n":"self"},{"n":"i"}]}],[11,"extend","","",44,{"i":[{"n":"self"},{"n":"i"}]}],[11,"eq","","",44,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"bool"}}],[11,"ne","","",44,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"bool"}}],[11,"partial_cmp","","",44,{"i":[{"n":"self"},{"n":"self"}],"o":{"g":["ordering"],"n":"option"}}],[11,"cmp","","",44,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"ordering"}}],[11,"clone","","",44,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"fmt","","",44,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"hash","","",44,{"i":[{"n":"self"},{"n":"h"}]}],[0,"slice","alloc","A dynamically-sized view into a contiguous sequence, `[T]`.",null,null],[3,"Chunks","alloc::slice","An iterator over a slice in (non-overlapping) chunks (`chunk_size` elements at a time).",null,null],[3,"Windows","","An iterator over overlapping subslices of length `size`.",null,null],[3,"Iter","","Immutable slice iterator",null,null],[3,"IterMut","","Mutable slice iterator.",null,null],[3,"SplitMut","","An iterator over the subslices of the vector which are separated by elements that match `pred`.",null,null],[3,"ChunksMut","","An iterator over a slice in (non-overlapping) mutable chunks (`chunk_size` elements at a time). When the slice len is not evenly divided by the chunk size, the last slice of the iteration will be the remainder.",null,null],[3,"Split","","An iterator over subslices separated by elements that match a predicate function.",null,null],[3,"SplitN","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits.",null,null],[3,"RSplitN","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits, starting from the end of the slice.",null,null],[3,"SplitNMut","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits.",null,null],[3,"RSplitNMut","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits, starting from the end of the slice.",null,null],[3,"RSplit","","An iterator over subslices separated by elements that match a predicate function, starting from the end of the slice.",null,null],[3,"RSplitMut","","An iterator over the subslices of the vector which are separated by elements that match `pred`, starting from the end of the slice.",null,null],[5,"from_raw_parts","","Forms a slice from a pointer and a length.",null,null],[5,"from_raw_parts_mut","","Performs the same functionality as `from_raw_parts`, except that a mutable slice is returned.",null,null],[5,"from_ref","","Converts a reference to T into a slice of length 1 (without copying).",null,null],[5,"from_mut","","Converts a reference to T into a slice of length 1 (without copying).",null,null],[8,"SliceIndex","","A helper trait used for indexing operations.",null,null],[16,"Output","","The output type returned by methods.",46,null],[10,"get","","Returns a shared reference to the output at this location, if in bounds.",46,{"i":[{"n":"self"},{"n":"t"}],"o":{"n":"option"}}],[10,"get_mut","","Returns a mutable reference to the output at this location, if in bounds.",46,{"i":[{"n":"self"},{"n":"t"}],"o":{"n":"option"}}],[10,"get_unchecked","","Returns a shared reference to the output at this location, without performing any bounds checking.",46,null],[10,"get_unchecked_mut","","Returns a mutable reference to the output at this location, without performing any bounds checking.",46,null],[10,"index","","Returns a shared reference to the output at this location, panicking if out of bounds.",46,null],[10,"index_mut","","Returns a mutable reference to the output at this location, panicking if out of bounds.",46,null],[3,"ExactChunks","","An iterator over a slice in (non-overlapping) chunks (`chunk_size` elements at a time).",null,null],[3,"ExactChunksMut","","An iterator over a slice in (non-overlapping) mutable chunks (`chunk_size` elements at a time). When the slice len is not evenly divided by the chunk size, the last up to `chunk_size-1` elements will be omitted.",null,null],[8,"SliceConcatExt","","An extension trait for concatenating slices",null,null],[16,"Output","","The resulting type after concatenation",47,null],[10,"concat","","Flattens a slice of `T` into a single value `Self::Output`.",47,null],[10,"join","","Flattens a slice of `T` into a single value `Self::Output`, placing a given separator between each.",47,null],[10,"connect","","",47,null],[0,"str","alloc","Unicode string slices.",null,null],[8,"FromStr","alloc::str","A trait to abstract the idea of creating a new instance of a type from a string.",null,null],[16,"Err","","The associated error which can be returned from parsing.",48,null],[10,"from_str","","Parses a string `s` to return a value of this type.",48,{"i":[{"n":"str"}],"o":{"n":"result"}}],[3,"Utf8Error","","Errors which can occur when attempting to interpret a sequence of [`u8`] as a string.",null,null],[3,"Lines","","An iterator over the lines of a string, as string slices.",null,null],[3,"LinesAny","","Created with the method [`lines_any`].",null,null],[3,"Split","","Created with the method [`split`].",null,null],[3,"RSplit","","Created with the method [`rsplit`].",null,null],[3,"SplitN","","Created with the method [`splitn`].",null,null],[3,"RSplitN","","Created with the method [`rsplitn`].",null,null],[3,"SplitTerminator","","Created with the method [`split_terminator`].",null,null],[3,"RSplitTerminator","","Created with the method [`rsplit_terminator`].",null,null],[3,"Matches","","Created with the method [`matches`].",null,null],[3,"RMatches","","Created with the method [`rmatches`].",null,null],[3,"MatchIndices","","Created with the method [`match_indices`].",null,null],[3,"RMatchIndices","","Created with the method [`rmatch_indices`].",null,null],[5,"from_utf8","","Converts a slice of bytes to a string slice.",null,null],[5,"from_utf8_mut","","Converts a mutable slice of bytes to a mutable string slice.",null,null],[3,"Chars","","An iterator over the [`char`]s of a string slice.",null,null],[3,"CharIndices","","An iterator over the [`char`]s of a string slice, and their positions.",null,null],[3,"Bytes","","An iterator over the bytes of a string slice.",null,null],[5,"from_utf8_unchecked","","Converts a slice of bytes to a string slice without checking that the string contains valid UTF-8.",null,null],[5,"from_utf8_unchecked_mut","","Converts a slice of bytes to a string slice without checking that the string contains valid UTF-8; mutable version.",null,null],[3,"ParseBoolError","","An error returned when parsing a `bool` using [`from_str`] fails",null,null],[3,"SplitWhitespace","","An iterator over the non-whitespace substrings of a string, separated by any amount of whitespace.",null,null],[0,"pattern","","The string Pattern API.",null,null],[8,"Pattern","alloc::str::pattern","A string pattern.",null,null],[16,"Searcher","","Associated searcher for this pattern",49,null],[10,"into_searcher","","Constructs the associated searcher from `self` and the `haystack` to search in.",49,null],[11,"is_contained_in","","Checks whether the pattern matches anywhere in the haystack",49,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"bool"}}],[11,"is_prefix_of","","Checks whether the pattern matches at the front of the haystack",49,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"bool"}}],[11,"is_suffix_of","","Checks whether the pattern matches at the back of the haystack",49,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"bool"}}],[4,"SearchStep","","Result of calling `Searcher::next()` or `ReverseSearcher::next_back()`.",null,null],[13,"Match","","Expresses that a match of the pattern has been found at `haystack[a..b]`.",50,null],[13,"Reject","","Expresses that `haystack[a..b]` has been rejected as a possible match of the pattern.",50,null],[13,"Done","","Expresses that every byte of the haystack has been visited, ending the iteration.",50,null],[8,"Searcher","","A searcher for a string pattern.",null,null],[10,"haystack","","Getter for the underlying string to be searched in",51,{"i":[{"n":"self"}],"o":{"n":"str"}}],[10,"next","","Performs the next search step starting from the front.",51,{"i":[{"n":"self"}],"o":{"n":"searchstep"}}],[11,"next_match","","Find the next `Match` result. See `next()`",51,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"next_reject","","Find the next `Reject` result. See `next()` and `next_match()`",51,{"i":[{"n":"self"}],"o":{"n":"option"}}],[8,"ReverseSearcher","","A reverse searcher for a string pattern.",null,null],[10,"next_back","","Performs the next search step starting from the back.",52,{"i":[{"n":"self"}],"o":{"n":"searchstep"}}],[11,"next_match_back","","Find the next `Match` result. See `next_back()`",52,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"next_reject_back","","Find the next `Reject` result. See `next_back()`",52,{"i":[{"n":"self"}],"o":{"n":"option"}}],[8,"DoubleEndedSearcher","","A marker trait to express that a `ReverseSearcher` can be used for a `DoubleEndedIterator` implementation.",null,null],[3,"CharSearcher","","Associated type for `<char as Pattern<'a>>::Searcher`.",null,null],[3,"CharSliceSearcher","","Associated type for `<&[char] as Pattern<'a>>::Searcher`.",null,null],[3,"CharPredicateSearcher","","Associated type for `<F as Pattern<'a>>::Searcher`.",null,null],[3,"StrSearcher","","Associated type for `<&str as Pattern<'a>>::Searcher`.",null,null],[3,"EncodeUtf16","alloc::str","An iterator of [`u16`] over the string encoded as UTF-16.",null,null],[5,"from_boxed_utf8_unchecked","","Converts a boxed slice of bytes to a boxed string slice without checking that the string contains valid UTF-8.",null,{"i":[{"n":"box"}],"o":{"g":["str"],"n":"box"}}],[0,"string","alloc","A UTF-8 encoded, growable string.",null,null],[3,"String","alloc::string","A UTF-8 encoded, growable string.",null,null],[3,"FromUtf8Error","","A possible error value when converting a `String` from a UTF-8 byte vector.",null,null],[3,"FromUtf16Error","","A possible error value when converting a `String` from a UTF-16 byte slice.",null,null],[3,"Drain","","A draining iterator for `String`.",null,null],[4,"ParseError","","An error when parsing a `String`.",null,null],[8,"ToString","","A trait for converting a value to a `String`.",null,null],[10,"to_string","","Converts the given value to a `String`.",53,{"i":[{"n":"self"}],"o":{"n":"string"}}],[11,"partial_cmp","","",54,{"i":[{"n":"self"},{"n":"string"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",54,{"i":[{"n":"self"},{"n":"string"}],"o":{"n":"bool"}}],[11,"le","","",54,{"i":[{"n":"self"},{"n":"string"}],"o":{"n":"bool"}}],[11,"gt","","",54,{"i":[{"n":"self"},{"n":"string"}],"o":{"n":"bool"}}],[11,"ge","","",54,{"i":[{"n":"self"},{"n":"string"}],"o":{"n":"bool"}}],[11,"cmp","","",54,{"i":[{"n":"self"},{"n":"string"}],"o":{"n":"ordering"}}],[11,"fmt","","",55,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",56,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","Creates a new empty `String`.",54,{"o":{"n":"string"}}],[11,"with_capacity","","Creates a new empty `String` with a particular capacity.",54,{"i":[{"n":"usize"}],"o":{"n":"string"}}],[11,"from_utf8","","Converts a vector of bytes to a `String`.",54,{"i":[{"g":["u8"],"n":"vec"}],"o":{"g":["string","fromutf8error"],"n":"result"}}],[11,"from_utf8_lossy","","Converts a slice of bytes to a string, including invalid characters.",54,null],[11,"from_utf16","","Decode a UTF-16 encoded vector `v` into a `String`, returning [`Err`] if `v` contains any invalid data.",54,null],[11,"from_utf16_lossy","","Decode a UTF-16 encoded slice `v` into a `String`, replacing invalid data with the replacement character (U+FFFD).",54,null],[11,"from_raw_parts","","Creates a new `String` from a length, capacity, and pointer.",54,null],[11,"from_utf8_unchecked","","Converts a vector of bytes to a `String` without checking that the string contains valid UTF-8.",54,{"i":[{"g":["u8"],"n":"vec"}],"o":{"n":"string"}}],[11,"into_bytes","","Converts a `String` into a byte vector.",54,{"i":[{"n":"self"}],"o":{"g":["u8"],"n":"vec"}}],[11,"as_str","","Extracts a string slice containing the entire string.",54,{"i":[{"n":"self"}],"o":{"n":"str"}}],[11,"as_mut_str","","Converts a `String` into a mutable string slice.",54,{"i":[{"n":"self"}],"o":{"n":"str"}}],[11,"push_str","","Appends a given string slice onto the end of this `String`.",54,{"i":[{"n":"self"},{"n":"str"}]}],[11,"capacity","","Returns this `String`'s capacity, in bytes.",54,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"reserve","","Ensures that this `String`'s capacity is at least `additional` bytes larger than its length.",54,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"reserve_exact","","Ensures that this `String`'s capacity is `additional` bytes larger than its length.",54,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"try_reserve","","Tries to reserve capacity for at least `additional` more elements to be inserted in the given `String`. The collection may reserve more space to avoid frequent reallocations. After calling `reserve`, capacity will be greater than or equal to `self.len() + additional`. Does nothing if capacity is already sufficient.",54,{"i":[{"n":"self"},{"n":"usize"}],"o":{"g":["collectionallocerr"],"n":"result"}}],[11,"try_reserve_exact","","Tries to reserves the minimum capacity for exactly `additional` more elements to be inserted in the given `String`. After calling `reserve_exact`, capacity will be greater than or equal to `self.len() + additional`. Does nothing if the capacity is already sufficient.",54,{"i":[{"n":"self"},{"n":"usize"}],"o":{"g":["collectionallocerr"],"n":"result"}}],[11,"shrink_to_fit","","Shrinks the capacity of this `String` to match its length.",54,{"i":[{"n":"self"}]}],[11,"shrink_to","","Shrinks the capacity of this `String` with a lower bound.",54,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"push","","Appends the given [`char`] to the end of this `String`.",54,{"i":[{"n":"self"},{"n":"char"}]}],[11,"as_bytes","","Returns a byte slice of this `String`'s contents.",54,null],[11,"truncate","","Shortens this `String` to the specified length.",54,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"pop","","Removes the last character from the string buffer and returns it.",54,{"i":[{"n":"self"}],"o":{"g":["char"],"n":"option"}}],[11,"remove","","Removes a [`char`] from this `String` at a byte position and returns it.",54,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"char"}}],[11,"retain","","Retains only the characters specified by the predicate.",54,{"i":[{"n":"self"},{"n":"f"}]}],[11,"insert","","Inserts a character into this `String` at a byte position.",54,{"i":[{"n":"self"},{"n":"usize"},{"n":"char"}]}],[11,"insert_str","","Inserts a string slice into this `String` at a byte position.",54,{"i":[{"n":"self"},{"n":"usize"},{"n":"str"}]}],[11,"as_mut_vec","","Returns a mutable reference to the contents of this `String`.",54,{"i":[{"n":"self"}],"o":{"n":"vec"}}],[11,"len","","Returns the length of this `String`, in bytes.",54,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"is_empty","","Returns `true` if this `String` has a length of zero.",54,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"split_off","","Splits the string into two at the given index.",54,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"string"}}],[11,"clear","","Truncates this `String`, removing all contents.",54,{"i":[{"n":"self"}]}],[11,"drain","","Creates a draining iterator that removes the specified range in the string and yields the removed chars.",54,{"i":[{"n":"self"},{"n":"r"}],"o":{"n":"drain"}}],[11,"replace_range","","Removes the specified range in the string, and replaces it with the given string. The given string doesn't need to be the same length as the range.",54,{"i":[{"n":"self"},{"n":"r"},{"n":"str"}]}],[11,"into_boxed_str","","Converts this `String` into a [`Box`]`<`[`str`]`>`.",54,{"i":[{"n":"self"}],"o":{"g":["str"],"n":"box"}}],[11,"as_bytes","","Returns a slice of [`u8`]s bytes that were attempted to convert to a `String`.",55,null],[11,"into_bytes","","Returns the bytes that were attempted to convert to a `String`.",55,{"i":[{"n":"self"}],"o":{"g":["u8"],"n":"vec"}}],[11,"utf8_error","","Fetch a `Utf8Error` to get more details about the conversion failure.",55,{"i":[{"n":"self"}],"o":{"n":"utf8error"}}],[11,"fmt","","",55,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",56,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",54,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"clone_from","","",54,{"i":[{"n":"self"},{"n":"self"}]}],[11,"from_iter","","",54,{"i":[{"n":"i"}],"o":{"n":"string"}}],[11,"from_iter","","",54,{"i":[{"n":"i"}],"o":{"n":"string"}}],[11,"from_iter","","",54,{"i":[{"n":"i"}],"o":{"n":"string"}}],[11,"from_iter","","",54,{"i":[{"n":"i"}],"o":{"n":"string"}}],[11,"from_iter","","",54,{"i":[{"n":"i"}],"o":{"n":"string"}}],[11,"extend","","",54,{"i":[{"n":"self"},{"n":"i"}]}],[11,"extend","","",54,{"i":[{"n":"self"},{"n":"i"}]}],[11,"extend","","",54,{"i":[{"n":"self"},{"n":"i"}]}],[11,"extend","","",54,{"i":[{"n":"self"},{"n":"i"}]}],[11,"extend","","",54,{"i":[{"n":"self"},{"n":"i"}]}],[11,"eq","","",54,{"i":[{"n":"self"},{"n":"string"}],"o":{"n":"bool"}}],[11,"ne","","",54,{"i":[{"n":"self"},{"n":"string"}],"o":{"n":"bool"}}],[11,"eq","","",54,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"bool"}}],[11,"ne","","",54,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"bool"}}],[11,"eq","","",54,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"bool"}}],[11,"ne","","",54,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"bool"}}],[11,"eq","alloc::borrow","",28,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"bool"}}],[11,"ne","","",28,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"bool"}}],[11,"eq","","",28,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"bool"}}],[11,"ne","","",28,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"bool"}}],[11,"eq","","",28,{"i":[{"n":"self"},{"n":"string"}],"o":{"n":"bool"}}],[11,"ne","","",28,{"i":[{"n":"self"},{"n":"string"}],"o":{"n":"bool"}}],[11,"eq","alloc::string","",54,{"i":[{"n":"self"},{"n":"cow"}],"o":{"n":"bool"}}],[11,"ne","","",54,{"i":[{"n":"self"},{"n":"cow"}],"o":{"n":"bool"}}],[11,"default","","Creates an empty `String`.",54,{"o":{"n":"string"}}],[11,"fmt","","",54,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",54,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"hash","","",54,{"i":[{"n":"self"},{"n":"h"}]}],[11,"add","","",54,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"string"}}],[11,"add_assign","","",54,{"i":[{"n":"self"},{"n":"str"}]}],[11,"index","","",54,{"i":[{"n":"self"},{"g":["usize"],"n":"range"}],"o":{"n":"str"}}],[11,"index","","",54,{"i":[{"n":"self"},{"g":["usize"],"n":"rangeto"}],"o":{"n":"str"}}],[11,"index","","",54,{"i":[{"n":"self"},{"g":["usize"],"n":"rangefrom"}],"o":{"n":"str"}}],[11,"index","","",54,{"i":[{"n":"self"},{"n":"rangefull"}],"o":{"n":"str"}}],[11,"index","","",54,{"i":[{"n":"self"},{"g":["usize"],"n":"rangeinclusive"}],"o":{"n":"str"}}],[11,"index","","",54,{"i":[{"n":"self"},{"g":["usize"],"n":"rangetoinclusive"}],"o":{"n":"str"}}],[11,"index_mut","","",54,{"i":[{"n":"self"},{"g":["usize"],"n":"range"}],"o":{"n":"str"}}],[11,"index_mut","","",54,{"i":[{"n":"self"},{"g":["usize"],"n":"rangeto"}],"o":{"n":"str"}}],[11,"index_mut","","",54,{"i":[{"n":"self"},{"g":["usize"],"n":"rangefrom"}],"o":{"n":"str"}}],[11,"index_mut","","",54,{"i":[{"n":"self"},{"n":"rangefull"}],"o":{"n":"str"}}],[11,"index_mut","","",54,{"i":[{"n":"self"},{"g":["usize"],"n":"rangeinclusive"}],"o":{"n":"str"}}],[11,"index_mut","","",54,{"i":[{"n":"self"},{"g":["usize"],"n":"rangetoinclusive"}],"o":{"n":"str"}}],[11,"deref","","",54,{"i":[{"n":"self"}],"o":{"n":"str"}}],[11,"deref_mut","","",54,{"i":[{"n":"self"}],"o":{"n":"str"}}],[11,"from_str","","",54,{"i":[{"n":"str"}],"o":{"g":["string","parseerror"],"n":"result"}}],[11,"clone","","",57,{"i":[{"n":"self"}],"o":{"n":"parseerror"}}],[11,"fmt","","",57,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",57,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"eq","","",57,{"i":[{"n":"self"},{"n":"parseerror"}],"o":{"n":"bool"}}],[11,"to_string","alloc::borrow","",28,{"i":[{"n":"self"}],"o":{"n":"string"}}],[11,"to_string","alloc::string","",54,{"i":[{"n":"self"}],"o":{"n":"string"}}],[11,"as_ref","","",54,{"i":[{"n":"self"}],"o":{"n":"str"}}],[11,"as_ref","","",54,null],[11,"from","","",54,{"i":[{"n":"str"}],"o":{"n":"string"}}],[11,"from","","",54,{"i":[{"g":["str"],"n":"box"}],"o":{"n":"string"}}],[11,"from","alloc::boxed","",13,{"i":[{"n":"string"}],"o":{"g":["str"],"n":"box"}}],[11,"from","alloc::string","",54,{"i":[{"g":["str"],"n":"cow"}],"o":{"n":"string"}}],[11,"from","alloc::borrow","",28,{"i":[{"n":"str"}],"o":{"g":["str"],"n":"cow"}}],[11,"from","","",28,{"i":[{"n":"string"}],"o":{"g":["str"],"n":"cow"}}],[11,"from","","",28,{"i":[{"n":"string"}],"o":{"g":["str"],"n":"cow"}}],[11,"from_iter","","",28,{"i":[{"n":"i"}],"o":{"g":["str"],"n":"cow"}}],[11,"from_iter","","",28,{"i":[{"n":"i"}],"o":{"g":["str"],"n":"cow"}}],[11,"from_iter","","",28,{"i":[{"n":"i"}],"o":{"g":["str"],"n":"cow"}}],[11,"write_str","alloc::string","",54,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"result"}}],[11,"write_char","","",54,{"i":[{"n":"self"},{"n":"char"}],"o":{"n":"result"}}],[11,"fmt","","",58,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"drop","","",58,{"i":[{"n":"self"}]}],[11,"next","","",58,{"i":[{"n":"self"}],"o":{"g":["char"],"n":"option"}}],[11,"size_hint","","",58,null],[11,"next_back","","",58,{"i":[{"n":"self"}],"o":{"g":["char"],"n":"option"}}],[0,"vec","alloc","A contiguous growable array type with heap-allocated contents, written `Vec<T>`.",null,null],[3,"Vec","alloc::vec","A contiguous growable array type, written `Vec<T>` but pronounced 'vector'.",null,null],[3,"IntoIter","","An iterator that moves out of a vector.",null,null],[3,"Drain","","A draining iterator for `Vec<T>`.",null,null],[3,"Splice","","A splicing iterator for `Vec`.",null,null],[3,"DrainFilter","","An iterator produced by calling `drain_filter` on Vec.",null,null],[11,"new","","Constructs a new, empty `Vec<T>`.",59,{"o":{"n":"vec"}}],[11,"with_capacity","","Constructs a new, empty `Vec<T>` with the specified capacity.",59,{"i":[{"n":"usize"}],"o":{"n":"vec"}}],[11,"from_raw_parts","","Creates a `Vec<T>` directly from the raw components of another vector.",59,null],[11,"capacity","","Returns the number of elements the vector can hold without reallocating.",59,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"reserve","","Reserves capacity for at least `additional` more elements to be inserted in the given `Vec<T>`. The collection may reserve more space to avoid frequent reallocations. After calling `reserve`, capacity will be greater than or equal to `self.len() + additional`. Does nothing if capacity is already sufficient.",59,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"reserve_exact","","Reserves the minimum capacity for exactly `additional` more elements to be inserted in the given `Vec<T>`. After calling `reserve_exact`, capacity will be greater than or equal to `self.len() + additional`. Does nothing if the capacity is already sufficient.",59,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"try_reserve","","Tries to reserve capacity for at least `additional` more elements to be inserted in the given `Vec<T>`. The collection may reserve more space to avoid frequent reallocations. After calling `reserve`, capacity will be greater than or equal to `self.len() + additional`. Does nothing if capacity is already sufficient.",59,{"i":[{"n":"self"},{"n":"usize"}],"o":{"g":["collectionallocerr"],"n":"result"}}],[11,"try_reserve_exact","","Tries to reserves the minimum capacity for exactly `additional` more elements to be inserted in the given `Vec<T>`. After calling `reserve_exact`, capacity will be greater than or equal to `self.len() + additional`. Does nothing if the capacity is already sufficient.",59,{"i":[{"n":"self"},{"n":"usize"}],"o":{"g":["collectionallocerr"],"n":"result"}}],[11,"shrink_to_fit","","Shrinks the capacity of the vector as much as possible.",59,{"i":[{"n":"self"}]}],[11,"shrink_to","","Shrinks the capacity of the vector with a lower bound.",59,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"into_boxed_slice","","Converts the vector into [`Box<[T]>`][owned slice].",59,{"i":[{"n":"self"}],"o":{"n":"box"}}],[11,"truncate","","Shortens the vector, keeping the first `len` elements and dropping the rest.",59,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"as_slice","","Extracts a slice containing the entire vector.",59,null],[11,"as_mut_slice","","Extracts a mutable slice of the entire vector.",59,null],[11,"set_len","","Sets the length of a vector.",59,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"swap_remove","","Removes an element from the vector and returns it.",59,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"t"}}],[11,"insert","","Inserts an element at position `index` within the vector, shifting all elements after it to the right.",59,{"i":[{"n":"self"},{"n":"usize"},{"n":"t"}]}],[11,"remove","","Removes and returns the element at position `index` within the vector, shifting all elements after it to the left.",59,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"t"}}],[11,"retain","","Retains only the elements specified by the predicate.",59,{"i":[{"n":"self"},{"n":"f"}]}],[11,"dedup_by_key","","Removes all but the first of consecutive elements in the vector that resolve to the same key.",59,{"i":[{"n":"self"},{"n":"f"}]}],[11,"dedup_by","","Removes all but the first of consecutive elements in the vector satisfying a given equality relation.",59,{"i":[{"n":"self"},{"n":"f"}]}],[11,"push","","Appends an element to the back of a collection.",59,{"i":[{"n":"self"},{"n":"t"}]}],[11,"pop","","Removes the last element from a vector and returns it, or [`None`] if it is empty.",59,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"append","","Moves all the elements of `other` into `Self`, leaving `other` empty.",59,{"i":[{"n":"self"},{"n":"self"}]}],[11,"drain","","Creates a draining iterator that removes the specified range in the vector and yields the removed items.",59,{"i":[{"n":"self"},{"n":"r"}],"o":{"n":"drain"}}],[11,"clear","","Clears the vector, removing all values.",59,{"i":[{"n":"self"}]}],[11,"len","","Returns the number of elements in the vector, also referred to as its 'length'.",59,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"is_empty","","Returns `true` if the vector contains no elements.",59,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"split_off","","Splits the collection into two at the given index.",59,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"self"}}],[11,"resize_with","","Resizes the `Vec` in-place so that `len` is equal to `new_len`.",59,{"i":[{"n":"self"},{"n":"usize"},{"n":"f"}]}],[11,"resize","","Resizes the `Vec` in-place so that `len` is equal to `new_len`.",59,{"i":[{"n":"self"},{"n":"usize"},{"n":"t"}]}],[11,"extend_from_slice","","Clones and appends all elements in a slice to the `Vec`.",59,null],[11,"resize_default","","Resizes the `Vec` in-place so that `len` is equal to `new_len`.",59,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"dedup","","Removes consecutive repeated elements in the vector.",59,{"i":[{"n":"self"}]}],[11,"remove_item","","Removes the first instance of `item` from the vector if the item exists.",59,{"i":[{"n":"self"},{"n":"t"}],"o":{"n":"option"}}],[11,"clone","","",59,{"i":[{"n":"self"}],"o":{"n":"vec"}}],[11,"clone_from","","",59,{"i":[{"n":"self"},{"n":"vec"}]}],[11,"hash","","",59,{"i":[{"n":"self"},{"n":"h"}]}],[11,"index","","",59,null],[11,"index_mut","","",59,null],[11,"deref","","",59,null],[11,"deref_mut","","",59,null],[11,"from_iter","","",59,{"i":[{"n":"i"}],"o":{"n":"vec"}}],[11,"into_iter","","Creates a consuming iterator, that is, one that moves each value out of the vector (from start to end). The vector cannot be used after calling this.",59,{"i":[{"n":"self"}],"o":{"n":"intoiter"}}],[11,"extend","","",59,{"i":[{"n":"self"},{"n":"i"}]}],[11,"splice","","Creates a splicing iterator that replaces the specified range in the vector with the given `replace_with` iterator and yields the removed items. `replace_with` does not need to be the same length as `range`.",59,{"i":[{"n":"self"},{"n":"r"},{"n":"i"}],"o":{"n":"splice"}}],[11,"drain_filter","","Creates an iterator which uses a closure to determine if an element should be removed.",59,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"drainfilter"}}],[11,"extend","","",59,{"i":[{"n":"self"},{"n":"i"}]}],[11,"eq","","",59,{"i":[{"n":"self"},{"n":"vec"}],"o":{"n":"bool"}}],[11,"ne","","",59,{"i":[{"n":"self"},{"n":"vec"}],"o":{"n":"bool"}}],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","alloc::borrow","",28,null],[11,"ne","","",28,null],[11,"eq","","",28,null],[11,"ne","","",28,null],[11,"eq","","",28,{"i":[{"n":"self"},{"n":"vec"}],"o":{"n":"bool"}}],[11,"ne","","",28,{"i":[{"n":"self"},{"n":"vec"}],"o":{"n":"bool"}}],[11,"eq","alloc::vec","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"eq","","",59,null],[11,"ne","","",59,null],[11,"partial_cmp","","",59,{"i":[{"n":"self"},{"n":"vec"}],"o":{"g":["ordering"],"n":"option"}}],[11,"cmp","","",59,{"i":[{"n":"self"},{"n":"vec"}],"o":{"n":"ordering"}}],[11,"drop","","",59,{"i":[{"n":"self"}]}],[11,"default","","Creates an empty `Vec<T>`.",59,{"o":{"n":"vec"}}],[11,"fmt","","",59,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"as_ref","","",59,{"i":[{"n":"self"}],"o":{"n":"vec"}}],[11,"as_mut","","",59,{"i":[{"n":"self"}],"o":{"n":"vec"}}],[11,"as_ref","","",59,null],[11,"as_mut","","",59,null],[11,"from","","",59,null],[11,"from","","",59,null],[11,"from","","",59,{"i":[{"n":"cow"}],"o":{"n":"vec"}}],[11,"from","","",59,{"i":[{"n":"box"}],"o":{"n":"vec"}}],[11,"from","alloc::boxed","",13,{"i":[{"n":"vec"}],"o":{"n":"box"}}],[11,"from","alloc::vec","",59,{"i":[{"n":"str"}],"o":{"g":["u8"],"n":"vec"}}],[11,"from","alloc::borrow","",28,null],[11,"from","","",28,{"i":[{"n":"vec"}],"o":{"n":"cow"}}],[11,"from","","",28,{"i":[{"n":"vec"}],"o":{"n":"cow"}}],[11,"from_iter","","",28,{"i":[{"n":"i"}],"o":{"n":"cow"}}],[11,"fmt","alloc::vec","",60,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"as_slice","","Returns the remaining items of this iterator as a slice.",60,null],[11,"as_mut_slice","","Returns the remaining items of this iterator as a mutable slice.",60,null],[11,"next","","",60,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",60,null],[11,"count","","",60,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"next_back","","",60,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"is_empty","","",60,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"clone","","",60,{"i":[{"n":"self"}],"o":{"n":"intoiter"}}],[11,"drop","","",60,{"i":[{"n":"self"}]}],[11,"fmt","","",61,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",61,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",61,null],[11,"next_back","","",61,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"drop","","",61,{"i":[{"n":"self"}]}],[11,"is_empty","","",61,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"fmt","","",62,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",62,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",62,null],[11,"next_back","","",62,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"drop","","",62,{"i":[{"n":"self"}]}],[11,"fmt","","",63,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",63,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",63,null],[11,"drop","","",63,{"i":[{"n":"self"}]}],[0,"vec_deque","alloc","A double-ended queue implemented with a growable ring buffer.",null,null],[3,"VecDeque","alloc::vec_deque","A double-ended queue implemented with a growable ring buffer.",null,null],[3,"Iter","","An iterator over the elements of a `VecDeque`.",null,null],[3,"IterMut","","A mutable iterator over the elements of a `VecDeque`.",null,null],[3,"IntoIter","","An owning iterator over the elements of a `VecDeque`.",null,null],[3,"Drain","","A draining iterator over the elements of a `VecDeque`.",null,null],[11,"clone","","",64,{"i":[{"n":"self"}],"o":{"n":"vecdeque"}}],[11,"drop","","",64,{"i":[{"n":"self"}]}],[11,"default","","Creates an empty `VecDeque<T>`.",64,{"o":{"n":"vecdeque"}}],[11,"new","","Creates an empty `VecDeque`.",64,{"o":{"n":"vecdeque"}}],[11,"with_capacity","","Creates an empty `VecDeque` with space for at least `n` elements.",64,{"i":[{"n":"usize"}],"o":{"n":"vecdeque"}}],[11,"get","","Retrieves an element in the `VecDeque` by index.",64,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"option"}}],[11,"get_mut","","Retrieves an element in the `VecDeque` mutably by index.",64,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"option"}}],[11,"swap","","Swaps elements at indices `i` and `j`.",64,{"i":[{"n":"self"},{"n":"usize"},{"n":"usize"}]}],[11,"capacity","","Returns the number of elements the `VecDeque` can hold without reallocating.",64,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"reserve_exact","","Reserves the minimum capacity for exactly `additional` more elements to be inserted in the given `VecDeque`. Does nothing if the capacity is already sufficient.",64,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"reserve","","Reserves capacity for at least `additional` more elements to be inserted in the given `VecDeque`. The collection may reserve more space to avoid frequent reallocations.",64,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"try_reserve_exact","","Tries to reserves the minimum capacity for exactly `additional` more elements to be inserted in the given `VecDeque<T>`. After calling `reserve_exact`, capacity will be greater than or equal to `self.len() + additional`. Does nothing if the capacity is already sufficient.",64,{"i":[{"n":"self"},{"n":"usize"}],"o":{"g":["collectionallocerr"],"n":"result"}}],[11,"try_reserve","","Tries to reserve capacity for at least `additional` more elements to be inserted in the given `VecDeque<T>`. The collection may reserve more space to avoid frequent reallocations. After calling `reserve`, capacity will be greater than or equal to `self.len() + additional`. Does nothing if capacity is already sufficient.",64,{"i":[{"n":"self"},{"n":"usize"}],"o":{"g":["collectionallocerr"],"n":"result"}}],[11,"shrink_to_fit","","Shrinks the capacity of the `VecDeque` as much as possible.",64,{"i":[{"n":"self"}]}],[11,"shrink_to","","Shrinks the capacity of the `VecDeque` with a lower bound.",64,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"truncate","","Shortens the `VecDeque`, dropping excess elements from the back.",64,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"iter","","Returns a front-to-back iterator.",64,{"i":[{"n":"self"}],"o":{"n":"iter"}}],[11,"iter_mut","","Returns a front-to-back iterator that returns mutable references.",64,{"i":[{"n":"self"}],"o":{"n":"itermut"}}],[11,"as_slices","","Returns a pair of slices which contain, in order, the contents of the `VecDeque`.",64,null],[11,"as_mut_slices","","Returns a pair of slices which contain, in order, the contents of the `VecDeque`.",64,null],[11,"len","","Returns the number of elements in the `VecDeque`.",64,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"is_empty","","Returns `true` if the `VecDeque` is empty.",64,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"drain","","Create a draining iterator that removes the specified range in the `VecDeque` and yields the removed items.",64,{"i":[{"n":"self"},{"n":"r"}],"o":{"n":"drain"}}],[11,"clear","","Clears the `VecDeque`, removing all values.",64,{"i":[{"n":"self"}]}],[11,"contains","","Returns `true` if the `VecDeque` contains an element equal to the given value.",64,{"i":[{"n":"self"},{"n":"t"}],"o":{"n":"bool"}}],[11,"front","","Provides a reference to the front element, or `None` if the `VecDeque` is empty.",64,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"front_mut","","Provides a mutable reference to the front element, or `None` if the `VecDeque` is empty.",64,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"back","","Provides a reference to the back element, or `None` if the `VecDeque` is empty.",64,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"back_mut","","Provides a mutable reference to the back element, or `None` if the `VecDeque` is empty.",64,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"pop_front","","Removes the first element and returns it, or `None` if the `VecDeque` is empty.",64,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"push_front","","Prepends an element to the `VecDeque`.",64,{"i":[{"n":"self"},{"n":"t"}]}],[11,"push_back","","Appends an element to the back of the `VecDeque`.",64,{"i":[{"n":"self"},{"n":"t"}]}],[11,"pop_back","","Removes the last element from the `VecDeque` and returns it, or `None` if it is empty.",64,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"swap_remove_back","","Removes an element from anywhere in the `VecDeque` and returns it, replacing it with the last element.",64,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"option"}}],[11,"swap_remove_front","","Removes an element from anywhere in the `VecDeque` and returns it, replacing it with the first element.",64,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"option"}}],[11,"insert","","Inserts an element at `index` within the `VecDeque`, shifting all elements with indices greater than or equal to `index` towards the back.",64,{"i":[{"n":"self"},{"n":"usize"},{"n":"t"}]}],[11,"remove","","Removes and returns the element at `index` from the `VecDeque`. Whichever end is closer to the removal point will be moved to make room, and all the affected elements will be moved to new positions. Returns `None` if `index` is out of bounds.",64,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"option"}}],[11,"split_off","","Splits the `VecDeque` into two at the given index.",64,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"self"}}],[11,"append","","Moves all the elements of `other` into `Self`, leaving `other` empty.",64,{"i":[{"n":"self"},{"n":"self"}]}],[11,"retain","","Retains only the elements specified by the predicate.",64,{"i":[{"n":"self"},{"n":"f"}]}],[11,"resize","","Modifies the `VecDeque` in-place so that `len()` is equal to new_len, either by removing excess elements from the back or by appending clones of `value` to the back.",64,{"i":[{"n":"self"},{"n":"usize"},{"n":"t"}]}],[11,"fmt","","",65,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",65,{"i":[{"n":"self"}],"o":{"n":"iter"}}],[11,"next","","",65,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",65,null],[11,"fold","","",65,{"i":[{"n":"self"},{"n":"acc"},{"n":"f"}],"o":{"n":"acc"}}],[11,"next_back","","",65,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"rfold","","",65,{"i":[{"n":"self"},{"n":"acc"},{"n":"f"}],"o":{"n":"acc"}}],[11,"is_empty","","",65,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"fmt","","",66,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",66,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",66,null],[11,"fold","","",66,{"i":[{"n":"self"},{"n":"acc"},{"n":"f"}],"o":{"n":"acc"}}],[11,"next_back","","",66,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"rfold","","",66,{"i":[{"n":"self"},{"n":"acc"},{"n":"f"}],"o":{"n":"acc"}}],[11,"is_empty","","",66,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"clone","","",67,{"i":[{"n":"self"}],"o":{"n":"intoiter"}}],[11,"fmt","","",67,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",67,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",67,null],[11,"next_back","","",67,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"is_empty","","",67,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"fmt","","",68,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"drop","","",68,{"i":[{"n":"self"}]}],[11,"next","","",68,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",68,null],[11,"next_back","","",68,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"eq","","",64,{"i":[{"n":"self"},{"n":"vecdeque"}],"o":{"n":"bool"}}],[11,"eq","","",64,{"i":[{"n":"self"},{"n":"vec"}],"o":{"n":"bool"}}],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"eq","","",64,null],[11,"partial_cmp","","",64,{"i":[{"n":"self"},{"n":"vecdeque"}],"o":{"g":["ordering"],"n":"option"}}],[11,"cmp","","",64,{"i":[{"n":"self"},{"n":"vecdeque"}],"o":{"n":"ordering"}}],[11,"hash","","",64,{"i":[{"n":"self"},{"n":"h"}]}],[11,"index","","",64,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"a"}}],[11,"index_mut","","",64,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"a"}}],[11,"from_iter","","",64,{"i":[{"n":"t"}],"o":{"n":"vecdeque"}}],[11,"into_iter","","Consumes the `VecDeque` into a front-to-back iterator yielding elements by value.",64,{"i":[{"n":"self"}],"o":{"n":"intoiter"}}],[11,"extend","","",64,{"i":[{"n":"self"},{"n":"t"}]}],[11,"extend","","",64,{"i":[{"n":"self"},{"n":"i"}]}],[11,"fmt","","",64,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"from","","",64,{"i":[{"n":"vec"}],"o":{"n":"self"}}],[11,"from","alloc::vec","",59,{"i":[{"n":"vecdeque"}],"o":{"n":"self"}}],[0,"btree_map","alloc","A map based on a B-Tree.",null,null],[3,"BTreeMap","alloc::btree_map","A map based on a B-Tree.",null,null],[3,"Iter","","An iterator over the entries of a `BTreeMap`.",null,null],[3,"IterMut","","A mutable iterator over the entries of a `BTreeMap`.",null,null],[3,"IntoIter","","An owning iterator over the entries of a `BTreeMap`.",null,null],[3,"Keys","","An iterator over the keys of a `BTreeMap`.",null,null],[3,"Values","","An iterator over the values of a `BTreeMap`.",null,null],[3,"ValuesMut","","A mutable iterator over the values of a `BTreeMap`.",null,null],[3,"Range","","An iterator over a sub-range of entries in a `BTreeMap`.",null,null],[3,"RangeMut","","A mutable iterator over a sub-range of entries in a `BTreeMap`.",null,null],[3,"VacantEntry","","A view into a vacant entry in a `BTreeMap`. It is part of the [`Entry`] enum.",null,null],[3,"OccupiedEntry","","A view into an occupied entry in a `BTreeMap`. It is part of the [`Entry`] enum.",null,null],[4,"Entry","","A view into a single entry in a map, which may either be vacant or occupied.",null,null],[13,"Vacant","","A vacant entry.",69,null],[13,"Occupied","","An occupied entry.",69,null],[0,"btree_set","alloc","A set based on a B-Tree.",null,null],[3,"BTreeSet","alloc::btree_set","A set based on a B-Tree.",null,null],[3,"Iter","","An iterator over the items of a `BTreeSet`.",null,null],[3,"IntoIter","","An owning iterator over the items of a `BTreeSet`.",null,null],[3,"Range","","An iterator over a sub-range of items in a `BTreeSet`.",null,null],[3,"Difference","","A lazy iterator producing elements in the difference of `BTreeSet`s.",null,null],[3,"SymmetricDifference","","A lazy iterator producing elements in the symmetric difference of `BTreeSet`s.",null,null],[3,"Intersection","","A lazy iterator producing elements in the intersection of `BTreeSet`s.",null,null],[3,"Union","","A lazy iterator producing elements in the union of `BTreeSet`s.",null,null],[14,"vec","alloc","Creates a [`Vec`] containing the arguments.",null,null],[14,"format","","Creates a `String` using interpolation of runtime expressions.",null,null],[11,"next_back","alloc::str::pattern","",70,{"i":[{"n":"self"}],"o":{"n":"searchstep"}}],[11,"next_match_back","","",70,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"next_reject_back","","",70,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"next_back","","",71,{"i":[{"n":"self"}],"o":{"n":"searchstep"}}],[11,"next_match_back","","",71,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"next_reject_back","","",71,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"next_back","","",72,{"i":[{"n":"self"}],"o":{"n":"searchstep"}}],[11,"next_match_back","","",72,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"next_back","","",73,{"i":[{"n":"self"}],"o":{"n":"searchstep"}}],[11,"next_match_back","","",73,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"fmt","","",72,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","alloc::str","",74,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","","",75,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","alloc::fmt","",76,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","alloc::str","",77,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","","",78,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","alloc::task","",15,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","alloc::str::pattern","",70,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","alloc::alloc","",79,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","alloc::slice","",80,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","alloc::str","",81,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","alloc::fmt","",82,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","alloc::task","",5,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","alloc::alloc","",83,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","alloc::str::pattern","",71,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","alloc::str","",84,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","alloc::task","",10,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","alloc::slice","",85,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","alloc::alloc","",1,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","alloc::slice","",86,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","","",87,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","","",88,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","","",89,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","","",90,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","alloc::str","",91,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","alloc::slice","",92,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","alloc::str","",93,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","alloc::str::pattern","",73,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","alloc::fmt","",40,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","alloc::slice","",94,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","","",95,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","alloc::str","",96,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","alloc::task","",97,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","alloc::str","",98,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","alloc::task","",99,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","alloc::slice","",100,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","","",101,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","alloc::str","",102,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","","",103,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","","",104,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","alloc::str::pattern","",50,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","alloc::task","",9,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","alloc::str","",105,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","","",106,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","","",107,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","alloc::task","",108,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","alloc::alloc","",0,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","alloc::str","",109,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","alloc::slice","",110,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","alloc::str","",111,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","","",112,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","alloc::slice","",113,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","alloc::alloc","",114,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","","",115,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","alloc::slice","",116,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"default","alloc::fmt","",82,{"o":{"n":"error"}}],[11,"next_back","alloc::slice","",94,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"next_back","","",95,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"next_back","alloc::str","",104,{"i":[{"n":"self"}],"o":{"g":["str"],"n":"option"}}],[11,"next_back","alloc::slice","",116,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"next_back","","",113,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"next_back","","",89,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"next_back","alloc::str","",96,{"i":[{"n":"self"}],"o":{"g":["str"],"n":"option"}}],[11,"next_back","alloc::slice","",90,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"next_back","alloc::str","",84,{"i":[{"n":"self"}],"o":{"g":["str"],"n":"option"}}],[11,"next_back","alloc::slice","",87,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"try_rfold","","",87,{"i":[{"n":"self"},{"n":"b"},{"n":"f"}],"o":{"n":"r"}}],[11,"rfold","","",87,{"i":[{"n":"self"},{"n":"acc"},{"n":"fold"}],"o":{"n":"acc"}}],[11,"next_back","","",80,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"next_back","","",100,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"next_back","","",110,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"next_back","","",88,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"try_rfold","","",88,{"i":[{"n":"self"},{"n":"b"},{"n":"f"}],"o":{"n":"r"}}],[11,"rfold","","",88,{"i":[{"n":"self"},{"n":"acc"},{"n":"fold"}],"o":{"n":"acc"}}],[11,"next_back","alloc::str","",81,{"i":[{"n":"self"}],"o":{"g":["str"],"n":"option"}}],[11,"next_back","","",109,{"i":[{"n":"self"}],"o":{"g":["str"],"n":"option"}}],[11,"next_back","","",112,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"next_back","","",103,{"i":[{"n":"self"}],"o":{"g":["str"],"n":"option"}}],[11,"next_back","","",91,{"i":[{"n":"self"}],"o":{"g":["char"],"n":"option"}}],[11,"next_back","","",111,{"i":[{"n":"self"}],"o":{"g":["str"],"n":"option"}}],[11,"next_back","","",106,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"next_back","","",77,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"next_back","","",78,{"i":[{"n":"self"}],"o":{"g":["str"],"n":"option"}}],[11,"next_back","","",93,{"i":[{"n":"self"}],"o":{"g":["str"],"n":"option"}}],[11,"next_back","","",75,{"i":[{"n":"self"}],"o":{"g":["u8"],"n":"option"}}],[11,"rfind","","",75,{"i":[{"n":"self"},{"n":"p"}],"o":{"n":"option"}}],[11,"write_str","alloc::fmt","",117,{"i":[{"n":"self"},{"n":"str"}],"o":{"g":["error"],"n":"result"}}],[11,"write_char","","",117,{"i":[{"n":"self"},{"n":"char"}],"o":{"g":["error"],"n":"result"}}],[11,"write_fmt","","",117,{"i":[{"n":"self"},{"n":"arguments"}],"o":{"g":["error"],"n":"result"}}],[11,"haystack","alloc::str::pattern","",72,{"i":[{"n":"self"}],"o":{"n":"str"}}],[11,"next","","",72,{"i":[{"n":"self"}],"o":{"n":"searchstep"}}],[11,"next_match","","",72,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"haystack","","",73,{"i":[{"n":"self"}],"o":{"n":"str"}}],[11,"next","","",73,{"i":[{"n":"self"}],"o":{"n":"searchstep"}}],[11,"next_match","","",73,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"haystack","","",71,{"i":[{"n":"self"}],"o":{"n":"str"}}],[11,"next","","",71,{"i":[{"n":"self"}],"o":{"n":"searchstep"}}],[11,"next_match","","",71,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"next_reject","","",71,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"haystack","","",70,{"i":[{"n":"self"}],"o":{"n":"str"}}],[11,"next","","",70,{"i":[{"n":"self"}],"o":{"n":"searchstep"}}],[11,"next_match","","",70,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"next_reject","","",70,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"from","alloc::task","",10,{"i":[{"n":"localwaker"}],"o":{"n":"waker"}}],[11,"from","alloc::alloc","",1,{"i":[{"n":"layouterr"}],"o":{"n":"collectionallocerr"}}],[11,"from","","",1,{"i":[{"n":"allocerr"}],"o":{"n":"collectionallocerr"}}],[11,"from","alloc::task","",5,{"i":[{"n":"t"}],"o":{"n":"poll"}}],[11,"as_ref","alloc::slice","",87,null],[11,"is_empty","","",110,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"is_empty","","",87,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"is_empty","","",94,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"is_empty","","",88,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"len","alloc::str","",75,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"is_empty","","",75,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"poll","alloc::task","",15,{"i":[{"g":["taskobj"],"n":"pinmut"},{"n":"context"}],"o":{"n":"poll"}}],[11,"clone","alloc::str","",109,{"i":[{"n":"self"}],"o":{"n":"rmatches"}}],[11,"clone","alloc::task","",10,{"i":[{"n":"self"}],"o":{"n":"waker"}}],[11,"clone","alloc::str","",96,{"i":[{"n":"self"}],"o":{"n":"splitterminator"}}],[11,"clone","alloc::task","",5,{"i":[{"n":"self"}],"o":{"n":"poll"}}],[11,"clone","alloc::str","",98,{"i":[{"n":"self"}],"o":{"n":"parseboolerror"}}],[11,"clone","alloc::str::pattern","",72,{"i":[{"n":"self"}],"o":{"n":"charsearcher"}}],[11,"clone","alloc::str","",75,{"i":[{"n":"self"}],"o":{"n":"bytes"}}],[11,"clone","","",106,{"i":[{"n":"self"}],"o":{"n":"matchindices"}}],[11,"clone","","",77,{"i":[{"n":"self"}],"o":{"n":"charindices"}}],[11,"clone","","",91,{"i":[{"n":"self"}],"o":{"n":"chars"}}],[11,"clone","alloc::alloc","",1,{"i":[{"n":"self"}],"o":{"n":"collectionallocerr"}}],[11,"clone","","",79,{"i":[{"n":"self"}],"o":{"n":"cannotreallocinplace"}}],[11,"clone","alloc::str","",93,{"i":[{"n":"self"}],"o":{"n":"rsplitterminator"}}],[11,"clone","","",111,{"i":[{"n":"self"}],"o":{"n":"rsplit"}}],[11,"clone","alloc::slice","",100,{"i":[{"n":"self"}],"o":{"n":"split"}}],[11,"clone","","",90,{"i":[{"n":"self"}],"o":{"n":"rsplit"}}],[11,"clone","","",87,{"i":[{"n":"self"}],"o":{"n":"iter"}}],[11,"clone","alloc::alloc","",114,{"i":[{"n":"self"}],"o":{"n":"allocerr"}}],[11,"clone","alloc::str","",81,{"i":[{"n":"self"}],"o":{"n":"lines"}}],[11,"clone","alloc::slice","",89,{"i":[{"n":"self"}],"o":{"n":"chunks"}}],[11,"clone","alloc::str","",74,{"i":[{"n":"self"}],"o":{"n":"encodeutf16"}}],[11,"clone","","",104,{"i":[{"n":"self"}],"o":{"n":"splitwhitespace"}}],[11,"clone","","",103,{"i":[{"n":"self"}],"o":{"n":"matches"}}],[11,"clone","","",102,{"i":[{"n":"self"}],"o":{"n":"splitn"}}],[11,"clone","","",112,{"i":[{"n":"self"}],"o":{"n":"rmatchindices"}}],[11,"clone","alloc::str::pattern","",50,{"i":[{"n":"self"}],"o":{"n":"searchstep"}}],[11,"clone","alloc::alloc","",115,{"i":[{"n":"self"}],"o":{"n":"layouterr"}}],[11,"clone","","",83,{"i":[{"n":"self"}],"o":{"n":"layout"}}],[11,"clone","alloc::slice","",94,{"i":[{"n":"self"}],"o":{"n":"exactchunks"}}],[11,"clone","alloc::str","",105,{"i":[{"n":"self"}],"o":{"n":"rsplitn"}}],[11,"clone","alloc::task","",108,{"i":[{"n":"self"}],"o":{"n":"localwaker"}}],[11,"clone","alloc::fmt","",82,{"i":[{"n":"self"}],"o":{"n":"error"}}],[11,"clone","alloc::str::pattern","",71,{"i":[{"n":"self"}],"o":{"n":"charpredicatesearcher"}}],[11,"clone","alloc::str","",78,{"i":[{"n":"self"}],"o":{"n":"split"}}],[11,"clone","alloc::str::pattern","",73,{"i":[{"n":"self"}],"o":{"n":"strsearcher"}}],[11,"clone","alloc::fmt","",76,{"i":[{"n":"self"}],"o":{"n":"arguments"}}],[11,"clone","alloc::str","",107,{"i":[{"n":"self"}],"o":{"n":"utf8error"}}],[11,"clone","alloc::slice","",116,{"i":[{"n":"self"}],"o":{"n":"windows"}}],[11,"clone","alloc::str","",84,{"i":[{"n":"self"}],"o":{"n":"linesany"}}],[11,"clone","alloc::str::pattern","",70,{"i":[{"n":"self"}],"o":{"n":"charslicesearcher"}}],[11,"partial_cmp","alloc::task","",5,{"i":[{"n":"self"},{"n":"poll"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",5,{"i":[{"n":"self"},{"n":"poll"}],"o":{"n":"bool"}}],[11,"le","","",5,{"i":[{"n":"self"},{"n":"poll"}],"o":{"n":"bool"}}],[11,"gt","","",5,{"i":[{"n":"self"},{"n":"poll"}],"o":{"n":"bool"}}],[11,"ge","","",5,{"i":[{"n":"self"},{"n":"poll"}],"o":{"n":"bool"}}],[11,"partial_cmp","alloc::fmt","",82,{"i":[{"n":"self"},{"n":"error"}],"o":{"g":["ordering"],"n":"option"}}],[11,"next","alloc::slice","",87,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",87,null],[11,"count","","",87,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"nth","","",87,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"option"}}],[11,"last","","",87,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"try_fold","","",87,{"i":[{"n":"self"},{"n":"b"},{"n":"f"}],"o":{"n":"r"}}],[11,"fold","","",87,{"i":[{"n":"self"},{"n":"acc"},{"n":"fold"}],"o":{"n":"acc"}}],[11,"position","","",87,{"i":[{"n":"self"},{"n":"p"}],"o":{"g":["usize"],"n":"option"}}],[11,"rposition","","",87,{"i":[{"n":"self"},{"n":"p"}],"o":{"g":["usize"],"n":"option"}}],[11,"next","alloc::str","",105,{"i":[{"n":"self"}],"o":{"g":["str"],"n":"option"}}],[11,"next","","",111,{"i":[{"n":"self"}],"o":{"g":["str"],"n":"option"}}],[11,"next","","",103,{"i":[{"n":"self"}],"o":{"g":["str"],"n":"option"}}],[11,"next","","",81,{"i":[{"n":"self"}],"o":{"g":["str"],"n":"option"}}],[11,"size_hint","","",81,null],[11,"next","alloc::slice","",92,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",92,null],[11,"next","alloc::str","",96,{"i":[{"n":"self"}],"o":{"g":["str"],"n":"option"}}],[11,"next","alloc::slice","",90,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",90,null],[11,"next","","",94,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",94,null],[11,"count","","",94,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"nth","","",94,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"option"}}],[11,"last","","",94,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"next","alloc::str","",74,{"i":[{"n":"self"}],"o":{"g":["u16"],"n":"option"}}],[11,"size_hint","","",74,null],[11,"next","","",84,{"i":[{"n":"self"}],"o":{"g":["str"],"n":"option"}}],[11,"size_hint","","",84,null],[11,"next","","",77,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"count","","",77,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"size_hint","","",77,null],[11,"last","","",77,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"next","","",93,{"i":[{"n":"self"}],"o":{"g":["str"],"n":"option"}}],[11,"next","","",91,{"i":[{"n":"self"}],"o":{"g":["char"],"n":"option"}}],[11,"count","","",91,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"size_hint","","",91,null],[11,"last","","",91,{"i":[{"n":"self"}],"o":{"g":["char"],"n":"option"}}],[11,"next","alloc::slice","",113,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",113,null],[11,"next","alloc::str","",102,{"i":[{"n":"self"}],"o":{"g":["str"],"n":"option"}}],[11,"next","alloc::slice","",100,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",100,null],[11,"next","","",85,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",85,null],[11,"next","","",86,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",86,null],[11,"next","","",116,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",116,null],[11,"count","","",116,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"nth","","",116,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"option"}}],[11,"last","","",116,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"next","alloc::str","",109,{"i":[{"n":"self"}],"o":{"g":["str"],"n":"option"}}],[11,"next","alloc::slice","",101,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",101,null],[11,"next","alloc::str","",112,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"next","","",104,{"i":[{"n":"self"}],"o":{"g":["str"],"n":"option"}}],[11,"next","alloc::slice","",88,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",88,null],[11,"count","","",88,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"nth","","",88,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"option"}}],[11,"last","","",88,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"try_fold","","",88,{"i":[{"n":"self"},{"n":"b"},{"n":"f"}],"o":{"n":"r"}}],[11,"fold","","",88,{"i":[{"n":"self"},{"n":"acc"},{"n":"fold"}],"o":{"n":"acc"}}],[11,"position","","",88,{"i":[{"n":"self"},{"n":"p"}],"o":{"g":["usize"],"n":"option"}}],[11,"rposition","","",88,{"i":[{"n":"self"},{"n":"p"}],"o":{"g":["usize"],"n":"option"}}],[11,"next","alloc::str","",78,{"i":[{"n":"self"}],"o":{"g":["str"],"n":"option"}}],[11,"next","alloc::slice","",80,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",80,null],[11,"count","","",80,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"nth","","",80,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"option"}}],[11,"last","","",80,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"next","","",89,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",89,null],[11,"count","","",89,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"nth","","",89,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"option"}}],[11,"last","","",89,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"next","alloc::str","",75,{"i":[{"n":"self"}],"o":{"g":["u8"],"n":"option"}}],[11,"size_hint","","",75,null],[11,"count","","",75,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"last","","",75,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"nth","","",75,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"option"}}],[11,"all","","",75,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"bool"}}],[11,"any","","",75,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"bool"}}],[11,"find","","",75,{"i":[{"n":"self"},{"n":"p"}],"o":{"n":"option"}}],[11,"position","","",75,{"i":[{"n":"self"},{"n":"p"}],"o":{"g":["usize"],"n":"option"}}],[11,"rposition","","",75,{"i":[{"n":"self"},{"n":"p"}],"o":{"g":["usize"],"n":"option"}}],[11,"next","alloc::slice","",110,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",110,null],[11,"count","","",110,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"nth","","",110,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"option"}}],[11,"last","","",110,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"next","","",95,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",95,null],[11,"next","alloc::str","",106,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"cmp","alloc::fmt","",82,{"i":[{"n":"self"},{"n":"error"}],"o":{"n":"ordering"}}],[11,"cmp","alloc::task","",5,{"i":[{"n":"self"},{"n":"poll"}],"o":{"n":"ordering"}}],[11,"drop","","",15,null],[11,"drop","","",108,null],[11,"drop","","",10,null],[11,"eq","alloc::alloc","",115,{"i":[{"n":"self"},{"n":"layouterr"}],"o":{"n":"bool"}}],[11,"ne","","",115,{"i":[{"n":"self"},{"n":"layouterr"}],"o":{"n":"bool"}}],[11,"eq","alloc::task","",5,{"i":[{"n":"self"},{"n":"poll"}],"o":{"n":"bool"}}],[11,"ne","","",5,{"i":[{"n":"self"},{"n":"poll"}],"o":{"n":"bool"}}],[11,"eq","alloc::str","",98,{"i":[{"n":"self"},{"n":"parseboolerror"}],"o":{"n":"bool"}}],[11,"ne","","",98,{"i":[{"n":"self"},{"n":"parseboolerror"}],"o":{"n":"bool"}}],[11,"eq","","",107,{"i":[{"n":"self"},{"n":"utf8error"}],"o":{"n":"bool"}}],[11,"ne","","",107,{"i":[{"n":"self"},{"n":"utf8error"}],"o":{"n":"bool"}}],[11,"eq","alloc::alloc","",114,{"i":[{"n":"self"},{"n":"allocerr"}],"o":{"n":"bool"}}],[11,"eq","","",83,{"i":[{"n":"self"},{"n":"layout"}],"o":{"n":"bool"}}],[11,"ne","","",83,{"i":[{"n":"self"},{"n":"layout"}],"o":{"n":"bool"}}],[11,"eq","alloc::fmt","",82,{"i":[{"n":"self"},{"n":"error"}],"o":{"n":"bool"}}],[11,"eq","alloc::alloc","",79,{"i":[{"n":"self"},{"n":"cannotreallocinplace"}],"o":{"n":"bool"}}],[11,"eq","","",1,{"i":[{"n":"self"},{"n":"collectionallocerr"}],"o":{"n":"bool"}}],[11,"eq","alloc::str::pattern","",50,{"i":[{"n":"self"},{"n":"searchstep"}],"o":{"n":"bool"}}],[11,"ne","","",50,{"i":[{"n":"self"},{"n":"searchstep"}],"o":{"n":"bool"}}],[11,"fmt","alloc::alloc","",114,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","alloc::fmt","",82,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","alloc::str","",98,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","alloc::fmt","",76,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","alloc::alloc","",115,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","","",79,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","alloc::str","",107,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"hash","alloc::task","",5,null],[11,"hash","alloc::fmt","",82,null],[11,"from_size_align","alloc::alloc","Constructs a `Layout` from a given `size` and `align`, or returns `LayoutErr` if either of the following conditions are not met:",83,{"i":[{"n":"usize"},{"n":"usize"}],"o":{"g":["layout","layouterr"],"n":"result"}}],[11,"from_size_align_unchecked","","Creates a layout, bypassing all checks.",83,{"i":[{"n":"usize"},{"n":"usize"}],"o":{"n":"layout"}}],[11,"size","","The minimum size in bytes for a memory block of this layout.",83,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"align","","The minimum byte alignment for a memory block of this layout.",83,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"new","","Constructs a `Layout` suitable for holding a value of type `T`.",83,{"o":{"n":"layout"}}],[11,"for_value","","Produces layout describing a record that could be used to allocate backing structure for `T` (which could be a trait or other unsized type like a slice).",83,{"i":[{"n":"t"}],"o":{"n":"layout"}}],[11,"align_to","","Creates a layout describing the record that can hold a value of the same layout as `self`, but that also is aligned to alignment `align` (measured in bytes).",83,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"layout"}}],[11,"padding_needed_for","","Returns the amount of padding we must insert after `self` to ensure that the following address will satisfy `align` (measured in bytes).",83,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"usize"}}],[11,"repeat","","Creates a layout describing the record for `n` instances of `self`, with a suitable amount of padding between each to ensure that each instance is given its requested size and alignment. On success, returns `(k, offs)` where `k` is the layout of the array and `offs` is the distance between the start of each element in the array.",83,{"i":[{"n":"self"},{"n":"usize"}],"o":{"g":["layouterr"],"n":"result"}}],[11,"extend","","Creates a layout describing the record for `self` followed by `next`, including any necessary padding to ensure that `next` will be properly aligned. Note that the result layout will satisfy the alignment properties of both `self` and `next`.",83,{"i":[{"n":"self"},{"n":"layout"}],"o":{"g":["layouterr"],"n":"result"}}],[11,"repeat_packed","","Creates a layout describing the record for `n` instances of `self`, with no padding between each instance.",83,{"i":[{"n":"self"},{"n":"usize"}],"o":{"g":["layout","layouterr"],"n":"result"}}],[11,"extend_packed","","Creates a layout describing the record for `self` followed by `next` with no additional padding between the two. Since no padding is inserted, the alignment of `next` is irrelevant, and is not incorporated at all into the resulting layout.",83,{"i":[{"n":"self"},{"n":"layout"}],"o":{"g":["layouterr"],"n":"result"}}],[11,"array","","Creates a layout describing the record for a `[T; n]`.",83,{"i":[{"n":"usize"}],"o":{"g":["layout","layouterr"],"n":"result"}}],[11,"description","","",79,{"i":[{"n":"self"}],"o":{"n":"str"}}],[11,"map","alloc::task","Change the ready value of this `Poll` with the closure provided",5,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"poll"}}],[11,"is_ready","","Returns whether this is `Poll::Ready`",5,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"is_pending","","Returns whether this is `Poll::Pending`",5,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"map_ok","","Change the success value of this `Poll` with the closure provided",5,{"i":[{"n":"self"},{"n":"f"}],"o":{"g":["result"],"n":"poll"}}],[11,"map_err","","Change the error value of this `Poll` with the closure provided",5,{"i":[{"n":"self"},{"n":"f"}],"o":{"g":["result"],"n":"poll"}}],[11,"new","","Constructs a new `Waker` directly.",10,{"i":[{"g":["unsafewake"],"n":"nonnull"}],"o":{"n":"waker"}}],[11,"wake","","Wake up the task associated with this `Waker`.",10,null],[11,"will_wake","","Returns whether or not this `Waker` and `other` awaken the same task.",10,{"i":[{"n":"self"},{"n":"waker"}],"o":{"n":"bool"}}],[11,"new","","Constructs a new `LocalWaker` directly.",108,{"i":[{"g":["unsafewake"],"n":"nonnull"}],"o":{"n":"localwaker"}}],[11,"wake","","Wake up the task associated with this `LocalWaker`.",108,null],[11,"will_wake","","Returns whether or not this `LocalWaker` and `other` `LocalWaker` awaken the same task.",108,{"i":[{"n":"self"},{"n":"localwaker"}],"o":{"n":"bool"}}],[11,"will_wake_nonlocal","","Returns whether or not this `LocalWaker` and `other` `Waker` awaken the same task.",108,{"i":[{"n":"self"},{"n":"waker"}],"o":{"n":"bool"}}],[11,"new","","Create a new task `Context` with the provided `local_waker`, `waker`, and `executor`.",99,{"i":[{"n":"localwaker"},{"n":"executor"}],"o":{"n":"context"}}],[11,"local_waker","","Get the `LocalWaker` associated with the current task.",99,{"i":[{"n":"self"}],"o":{"n":"localwaker"}}],[11,"waker","","Get the `Waker` associated with the current task.",99,{"i":[{"n":"self"}],"o":{"n":"waker"}}],[11,"executor","","Get the default executor associated with this task.",99,{"i":[{"n":"self"}],"o":{"n":"executor"}}],[11,"with_waker","","Produce a context like the current one, but using the given waker instead.",99,{"i":[{"n":"self"},{"n":"localwaker"}],"o":{"n":"context"}}],[11,"with_executor","","Produce a context like the current one, but using the given executor instead.",99,{"i":[{"n":"self"},{"n":"e"}],"o":{"n":"context"}}],[11,"new","","Create a `TaskObj` from a custom trait object representation.",15,{"i":[{"n":"t"}],"o":{"n":"taskobj"}}],[11,"shutdown","","Spawning is failing because the executor has been shut down.",97,{"o":{"n":"spawnerrorkind"}}],[11,"is_shutdown","","Check whether this error is the `shutdown` error.",97,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"wake_local","","Indicates that the associated task is ready to make progress and should be `poll`ed. This function is like `wake`, but can only be called from the thread on which this `Wake` was created.",11,{"i":[{"n":"arc"}]}],[11,"from","alloc::vec","",59,{"i":[{"n":"binaryheap"}],"o":{"n":"vec"}}],[11,"drop","alloc::btree_map","",118,{"i":[{"n":"self"}]}],[11,"clone","","",118,{"i":[{"n":"self"}],"o":{"n":"btreemap"}}],[11,"fmt","","",119,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",120,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",121,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",122,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",123,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",124,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",125,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",126,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",69,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",127,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",128,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","Makes a new empty BTreeMap with a reasonable choice for B.",118,{"o":{"n":"btreemap"}}],[11,"clear","","Clears the map, removing all values.",118,{"i":[{"n":"self"}]}],[11,"get","","Returns a reference to the value corresponding to the key.",118,{"i":[{"n":"self"},{"n":"q"}],"o":{"n":"option"}}],[11,"get_key_value","","Returns the key-value pair corresponding to the supplied key.",118,{"i":[{"n":"self"},{"n":"q"}],"o":{"n":"option"}}],[11,"contains_key","","Returns `true` if the map contains a value for the specified key.",118,{"i":[{"n":"self"},{"n":"q"}],"o":{"n":"bool"}}],[11,"get_mut","","Returns a mutable reference to the value corresponding to the key.",118,{"i":[{"n":"self"},{"n":"q"}],"o":{"n":"option"}}],[11,"insert","","Inserts a key-value pair into the map.",118,{"i":[{"n":"self"},{"n":"k"},{"n":"v"}],"o":{"n":"option"}}],[11,"remove","","Removes a key from the map, returning the value at the key if the key was previously in the map.",118,{"i":[{"n":"self"},{"n":"q"}],"o":{"n":"option"}}],[11,"append","","Moves all elements from `other` into `Self`, leaving `other` empty.",118,{"i":[{"n":"self"},{"n":"self"}]}],[11,"range","","Constructs a double-ended iterator over a sub-range of elements in the map. The simplest way is to use the range syntax `min..max`, thus `range(min..max)` will yield elements from min (inclusive) to max (exclusive). The range may also be entered as `(Bound<T>, Bound<T>)`, so for example `range((Excluded(4), Included(10)))` will yield a left-exclusive, right-inclusive range from 4 to 10.",118,{"i":[{"n":"self"},{"n":"r"}],"o":{"n":"range"}}],[11,"range_mut","","Constructs a mutable double-ended iterator over a sub-range of elements in the map. The simplest way is to use the range syntax `min..max`, thus `range(min..max)` will yield elements from min (inclusive) to max (exclusive). The range may also be entered as `(Bound<T>, Bound<T>)`, so for example `range((Excluded(4), Included(10)))` will yield a left-exclusive, right-inclusive range from 4 to 10.",118,{"i":[{"n":"self"},{"n":"r"}],"o":{"n":"rangemut"}}],[11,"entry","","Gets the given key's corresponding entry in the map for in-place manipulation.",118,{"i":[{"n":"self"},{"n":"k"}],"o":{"n":"entry"}}],[11,"split_off","","Splits the collection into two at the given key. Returns everything after the given key, including the key.",118,{"i":[{"n":"self"},{"n":"q"}],"o":{"n":"self"}}],[11,"next","","",119,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",119,null],[11,"next_back","","",119,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"len","","",119,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"clone","","",119,{"i":[{"n":"self"}],"o":{"n":"iter"}}],[11,"next","","",120,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",120,null],[11,"next_back","","",120,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"len","","",120,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"into_iter","","",118,{"i":[{"n":"self"}],"o":{"n":"intoiter"}}],[11,"drop","","",121,{"i":[{"n":"self"}]}],[11,"next","","",121,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",121,null],[11,"next_back","","",121,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"len","","",121,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"next","","",122,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",122,null],[11,"next_back","","",122,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"len","","",122,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"clone","","",122,{"i":[{"n":"self"}],"o":{"n":"keys"}}],[11,"next","","",123,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",123,null],[11,"next_back","","",123,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"len","","",123,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"clone","","",123,{"i":[{"n":"self"}],"o":{"n":"values"}}],[11,"next","","",125,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"next","","",124,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",124,null],[11,"next_back","","",124,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"len","","",124,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"next_back","","",125,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"clone","","",125,{"i":[{"n":"self"}],"o":{"n":"range"}}],[11,"next","","",126,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"next_back","","",126,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"from_iter","","",118,{"i":[{"n":"t"}],"o":{"n":"btreemap"}}],[11,"extend","","",118,{"i":[{"n":"self"},{"n":"t"}]}],[11,"extend","","",118,{"i":[{"n":"self"},{"n":"i"}]}],[11,"hash","","",118,{"i":[{"n":"self"},{"n":"h"}]}],[11,"default","","Creates an empty `BTreeMap<K, V>`.",118,{"o":{"n":"btreemap"}}],[11,"eq","","",118,{"i":[{"n":"self"},{"n":"btreemap"}],"o":{"n":"bool"}}],[11,"partial_cmp","","",118,{"i":[{"n":"self"},{"n":"btreemap"}],"o":{"g":["ordering"],"n":"option"}}],[11,"cmp","","",118,{"i":[{"n":"self"},{"n":"btreemap"}],"o":{"n":"ordering"}}],[11,"fmt","","",118,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"index","","Returns a reference to the value corresponding to the supplied key.",118,{"i":[{"n":"self"},{"n":"q"}],"o":{"n":"v"}}],[11,"iter","","Gets an iterator over the entries of the map, sorted by key.",118,{"i":[{"n":"self"}],"o":{"n":"iter"}}],[11,"iter_mut","","Gets a mutable iterator over the entries of the map, sorted by key.",118,{"i":[{"n":"self"}],"o":{"n":"itermut"}}],[11,"keys","","Gets an iterator over the keys of the map, in sorted order.",118,{"i":[{"n":"self"}],"o":{"n":"keys"}}],[11,"values","","Gets an iterator over the values of the map, in order by key.",118,{"i":[{"n":"self"}],"o":{"n":"values"}}],[11,"values_mut","","Gets a mutable iterator over the values of the map, in order by key.",118,{"i":[{"n":"self"}],"o":{"n":"valuesmut"}}],[11,"len","","Returns the number of elements in the map.",118,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"is_empty","","Returns `true` if the map contains no elements.",118,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"or_insert","","Ensures a value is in the entry by inserting the default if empty, and returns a mutable reference to the value in the entry.",69,{"i":[{"n":"self"},{"n":"v"}],"o":{"n":"v"}}],[11,"or_insert_with","","Ensures a value is in the entry by inserting the result of the default function if empty, and returns a mutable reference to the value in the entry.",69,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"v"}}],[11,"key","","Returns a reference to this entry's key.",69,{"i":[{"n":"self"}],"o":{"n":"k"}}],[11,"and_modify","","Provides in-place mutable access to an occupied entry before any potential inserts into the map.",69,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"self"}}],[11,"or_default","","Ensures a value is in the entry by inserting the default value if empty, and returns a mutable reference to the value in the entry.",69,{"i":[{"n":"self"}],"o":{"n":"v"}}],[11,"key","","Gets a reference to the key that would be used when inserting a value through the VacantEntry.",127,{"i":[{"n":"self"}],"o":{"n":"k"}}],[11,"into_key","","Take ownership of the key.",127,{"i":[{"n":"self"}],"o":{"n":"k"}}],[11,"insert","","Sets the value of the entry with the `VacantEntry`'s key, and returns a mutable reference to it.",127,{"i":[{"n":"self"},{"n":"v"}],"o":{"n":"v"}}],[11,"key","","Gets a reference to the key in the entry.",128,{"i":[{"n":"self"}],"o":{"n":"k"}}],[11,"remove_entry","","Take ownership of the key and value from the map.",128,null],[11,"get","","Gets a reference to the value in the entry.",128,{"i":[{"n":"self"}],"o":{"n":"v"}}],[11,"get_mut","","Gets a mutable reference to the value in the entry.",128,{"i":[{"n":"self"}],"o":{"n":"v"}}],[11,"into_mut","","Converts the entry into a mutable reference to its value.",128,{"i":[{"n":"self"}],"o":{"n":"v"}}],[11,"insert","","Sets the value of the entry with the `OccupiedEntry`'s key, and returns the entry's old value.",128,{"i":[{"n":"self"},{"n":"v"}],"o":{"n":"v"}}],[11,"remove","","Takes the value of the entry out of the map, and returns it.",128,{"i":[{"n":"self"}],"o":{"n":"v"}}],[11,"clone","alloc::btree_set","",129,{"i":[{"n":"self"}],"o":{"n":"btreeset"}}],[11,"hash","","",129,null],[11,"eq","","",129,{"i":[{"n":"self"},{"n":"btreeset"}],"o":{"n":"bool"}}],[11,"ne","","",129,{"i":[{"n":"self"},{"n":"btreeset"}],"o":{"n":"bool"}}],[11,"cmp","","",129,{"i":[{"n":"self"},{"n":"btreeset"}],"o":{"n":"ordering"}}],[11,"partial_cmp","","",129,{"i":[{"n":"self"},{"n":"btreeset"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",129,{"i":[{"n":"self"},{"n":"btreeset"}],"o":{"n":"bool"}}],[11,"le","","",129,{"i":[{"n":"self"},{"n":"btreeset"}],"o":{"n":"bool"}}],[11,"gt","","",129,{"i":[{"n":"self"},{"n":"btreeset"}],"o":{"n":"bool"}}],[11,"ge","","",129,{"i":[{"n":"self"},{"n":"btreeset"}],"o":{"n":"bool"}}],[11,"fmt","","",130,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",131,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",132,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",133,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",134,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",135,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",136,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","Makes a new `BTreeSet` with a reasonable choice of B.",129,{"o":{"n":"btreeset"}}],[11,"range","","Constructs a double-ended iterator over a sub-range of elements in the set. The simplest way is to use the range syntax `min..max`, thus `range(min..max)` will yield elements from min (inclusive) to max (exclusive). The range may also be entered as `(Bound<T>, Bound<T>)`, so for example `range((Excluded(4), Included(10)))` will yield a left-exclusive, right-inclusive range from 4 to 10.",129,{"i":[{"n":"self"},{"n":"r"}],"o":{"n":"range"}}],[11,"difference","","Visits the values representing the difference, i.e. the values that are in `self` but not in `other`, in ascending order.",129,{"i":[{"n":"self"},{"n":"btreeset"}],"o":{"n":"difference"}}],[11,"symmetric_difference","","Visits the values representing the symmetric difference, i.e. the values that are in `self` or in `other` but not in both, in ascending order.",129,{"i":[{"n":"self"},{"n":"btreeset"}],"o":{"n":"symmetricdifference"}}],[11,"intersection","","Visits the values representing the intersection, i.e. the values that are both in `self` and `other`, in ascending order.",129,{"i":[{"n":"self"},{"n":"btreeset"}],"o":{"n":"intersection"}}],[11,"union","","Visits the values representing the union, i.e. all the values in `self` or `other`, without duplicates, in ascending order.",129,{"i":[{"n":"self"},{"n":"btreeset"}],"o":{"n":"union"}}],[11,"clear","","Clears the set, removing all values.",129,{"i":[{"n":"self"}]}],[11,"contains","","Returns `true` if the set contains a value.",129,{"i":[{"n":"self"},{"n":"q"}],"o":{"n":"bool"}}],[11,"get","","Returns a reference to the value in the set, if any, that is equal to the given value.",129,{"i":[{"n":"self"},{"n":"q"}],"o":{"n":"option"}}],[11,"is_disjoint","","Returns `true` if `self` has no elements in common with `other`. This is equivalent to checking for an empty intersection.",129,{"i":[{"n":"self"},{"n":"btreeset"}],"o":{"n":"bool"}}],[11,"is_subset","","Returns `true` if the set is a subset of another, i.e. `other` contains at least all the values in `self`.",129,{"i":[{"n":"self"},{"n":"btreeset"}],"o":{"n":"bool"}}],[11,"is_superset","","Returns `true` if the set is a superset of another, i.e. `self` contains at least all the values in `other`.",129,{"i":[{"n":"self"},{"n":"btreeset"}],"o":{"n":"bool"}}],[11,"insert","","Adds a value to the set.",129,{"i":[{"n":"self"},{"n":"t"}],"o":{"n":"bool"}}],[11,"replace","","Adds a value to the set, replacing the existing value, if any, that is equal to the given one. Returns the replaced value.",129,{"i":[{"n":"self"},{"n":"t"}],"o":{"n":"option"}}],[11,"remove","","Removes a value from the set. Returns `true` if the value was present in the set.",129,{"i":[{"n":"self"},{"n":"q"}],"o":{"n":"bool"}}],[11,"take","","Removes and returns the value in the set, if any, that is equal to the given one.",129,{"i":[{"n":"self"},{"n":"q"}],"o":{"n":"option"}}],[11,"append","","Moves all elements from `other` into `Self`, leaving `other` empty.",129,{"i":[{"n":"self"},{"n":"self"}]}],[11,"split_off","","Splits the collection into two at the given key. Returns everything after the given key, including the key.",129,{"i":[{"n":"self"},{"n":"q"}],"o":{"n":"self"}}],[11,"iter","","Gets an iterator that visits the values in the `BTreeSet` in ascending order.",129,{"i":[{"n":"self"}],"o":{"n":"iter"}}],[11,"len","","Returns the number of elements in the set.",129,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"is_empty","","Returns `true` if the set contains no elements.",129,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"from_iter","","",129,{"i":[{"n":"i"}],"o":{"n":"btreeset"}}],[11,"into_iter","","Gets an iterator for moving out the `BTreeSet`'s contents.",129,{"i":[{"n":"self"}],"o":{"n":"intoiter"}}],[11,"extend","","",129,{"i":[{"n":"self"},{"n":"iter"}]}],[11,"extend","","",129,{"i":[{"n":"self"},{"n":"i"}]}],[11,"default","","Makes an empty `BTreeSet<T>` with a reasonable choice of B.",129,{"o":{"n":"btreeset"}}],[11,"fmt","","",129,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",130,{"i":[{"n":"self"}],"o":{"n":"iter"}}],[11,"next","","",130,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",130,null],[11,"next_back","","",130,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"len","","",130,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"next","","",131,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",131,null],[11,"next_back","","",131,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"len","","",131,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"clone","","",132,{"i":[{"n":"self"}],"o":{"n":"range"}}],[11,"next","","",132,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"next_back","","",132,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"clone","","",133,{"i":[{"n":"self"}],"o":{"n":"difference"}}],[11,"next","","",133,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",133,null],[11,"clone","","",134,{"i":[{"n":"self"}],"o":{"n":"symmetricdifference"}}],[11,"next","","",134,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",134,null],[11,"clone","","",135,{"i":[{"n":"self"}],"o":{"n":"intersection"}}],[11,"next","","",135,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",135,null],[11,"clone","","",136,{"i":[{"n":"self"}],"o":{"n":"union"}}],[11,"next","","",136,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",136,null],[11,"pad_integral","alloc::fmt","Performs the correct padding for an integer which has already been emitted into a str. The str should not contain the sign for the integer, that will be added by this method.",117,{"i":[{"n":"self"},{"n":"bool"},{"n":"str"},{"n":"str"}],"o":{"g":["error"],"n":"result"}}],[11,"pad","","This function takes a string slice and emits it to the internal buffer after applying the relevant formatting flags specified. The flags recognized for generic strings are:",117,{"i":[{"n":"self"},{"n":"str"}],"o":{"g":["error"],"n":"result"}}],[11,"write_str","","Writes some data to the underlying buffer contained within this formatter.",117,{"i":[{"n":"self"},{"n":"str"}],"o":{"g":["error"],"n":"result"}}],[11,"write_fmt","","Writes some formatted information into this instance.",117,{"i":[{"n":"self"},{"n":"arguments"}],"o":{"g":["error"],"n":"result"}}],[11,"flags","","Flags for formatting",117,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"fill","","Character used as 'fill' whenever there is alignment.",117,{"i":[{"n":"self"}],"o":{"n":"char"}}],[11,"align","","Flag indicating what form of alignment was requested.",117,{"i":[{"n":"self"}],"o":{"g":["alignment"],"n":"option"}}],[11,"width","","Optionally specified integer width that the output should be.",117,{"i":[{"n":"self"}],"o":{"g":["usize"],"n":"option"}}],[11,"precision","","Optionally specified precision for numeric types.",117,{"i":[{"n":"self"}],"o":{"g":["usize"],"n":"option"}}],[11,"sign_plus","","Determines if the `+` flag was specified.",117,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"sign_minus","","Determines if the `-` flag was specified.",117,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"alternate","","Determines if the `#` flag was specified.",117,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"sign_aware_zero_pad","","Determines if the `0` flag was specified.",117,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"debug_struct","","Creates a [`DebugStruct`] builder designed to assist with creation of [`fmt::Debug`] implementations for structs.",117,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"debugstruct"}}],[11,"debug_tuple","","Creates a `DebugTuple` builder designed to assist with creation of `fmt::Debug` implementations for tuple structs.",117,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"debugtuple"}}],[11,"debug_list","","Creates a `DebugList` builder designed to assist with creation of `fmt::Debug` implementations for list-like structures.",117,{"i":[{"n":"self"}],"o":{"n":"debuglist"}}],[11,"debug_set","","Creates a `DebugSet` builder designed to assist with creation of `fmt::Debug` implementations for set-like structures.",117,{"i":[{"n":"self"}],"o":{"n":"debugset"}}],[11,"debug_map","","Creates a `DebugMap` builder designed to assist with creation of `fmt::Debug` implementations for map-like structures.",117,{"i":[{"n":"self"}],"o":{"n":"debugmap"}}],[11,"entry","","Adds a new entry to the list output.",137,{"i":[{"n":"self"},{"n":"debug"}],"o":{"n":"debuglist"}}],[11,"entries","","Adds the contents of an iterator of entries to the list output.",137,{"i":[{"n":"self"},{"n":"i"}],"o":{"n":"debuglist"}}],[11,"finish","","Finishes output and returns any error encountered.",137,{"i":[{"n":"self"}],"o":{"g":["error"],"n":"result"}}],[11,"entry","","Adds a new entry to the map output.",138,{"i":[{"n":"self"},{"n":"debug"},{"n":"debug"}],"o":{"n":"debugmap"}}],[11,"entries","","Adds the contents of an iterator of entries to the map output.",138,{"i":[{"n":"self"},{"n":"i"}],"o":{"n":"debugmap"}}],[11,"finish","","Finishes output and returns any error encountered.",138,{"i":[{"n":"self"}],"o":{"g":["error"],"n":"result"}}],[11,"entry","","Adds a new entry to the set output.",139,{"i":[{"n":"self"},{"n":"debug"}],"o":{"n":"debugset"}}],[11,"entries","","Adds the contents of an iterator of entries to the set output.",139,{"i":[{"n":"self"},{"n":"i"}],"o":{"n":"debugset"}}],[11,"finish","","Finishes output and returns any error encountered.",139,{"i":[{"n":"self"}],"o":{"g":["error"],"n":"result"}}],[11,"field","","Adds a new field to the generated struct output.",140,{"i":[{"n":"self"},{"n":"str"},{"n":"debug"}],"o":{"n":"debugstruct"}}],[11,"finish","","Finishes output and returns any error encountered.",140,{"i":[{"n":"self"}],"o":{"g":["error"],"n":"result"}}],[11,"field","","Adds a new field to the generated tuple struct output.",141,{"i":[{"n":"self"},{"n":"debug"}],"o":{"n":"debugtuple"}}],[11,"finish","","Finishes output and returns any error encountered.",141,{"i":[{"n":"self"}],"o":{"g":["error"],"n":"result"}}],[11,"as_slice","alloc::slice","View the underlying data as a subslice of the original data.",87,null],[11,"into_slice","","View the underlying data as a subslice of the original data.",88,null],[11,"borrow","alloc::vec","",59,null],[11,"borrow_mut","","",59,null],[11,"valid_up_to","alloc::str","Returns the index in the given string up to which valid UTF-8 was verified.",107,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"error_len","","Provide more information about the failure:",107,{"i":[{"n":"self"}],"o":{"g":["usize"],"n":"option"}}],[11,"as_str","","View the underlying data as a subslice of the original data.",91,{"i":[{"n":"self"}],"o":{"n":"str"}}],[11,"as_str","","View the underlying data as a subslice of the original data.",77,{"i":[{"n":"self"}],"o":{"n":"str"}}],[11,"borrow","alloc::string","",54,{"i":[{"n":"self"}],"o":{"n":"str"}}],[11,"from","alloc::vec","",59,{"i":[{"n":"string"}],"o":{"g":["u8"],"n":"vec"}}]],"paths":[[3,"Excess"],[4,"CollectionAllocErr"],[8,"GlobalAlloc"],[8,"Alloc"],[3,"Global"],[4,"Poll"],[8,"UnsafeWake"],[8,"Executor"],[8,"UnsafeTask"],[3,"SpawnObjError"],[3,"Waker"],[8,"Wake"],[8,"FnBox"],[3,"Box"],[3,"PinBox"],[3,"TaskObj"],[3,"Weak"],[3,"Arc"],[3,"Rc"],[3,"Weak"],[3,"RawVec"],[3,"PeekMut"],[3,"BinaryHeap"],[3,"Iter"],[3,"IntoIter"],[3,"Drain"],[8,"Borrow"],[8,"BorrowMut"],[4,"Cow"],[8,"ToOwned"],[8,"Write"],[8,"Binary"],[8,"Octal"],[8,"Debug"],[8,"Display"],[8,"LowerHex"],[8,"Pointer"],[8,"UpperHex"],[8,"LowerExp"],[8,"UpperExp"],[4,"Alignment"],[3,"Iter"],[3,"IterMut"],[3,"IntoIter"],[3,"LinkedList"],[3,"DrainFilter"],[8,"SliceIndex"],[8,"SliceConcatExt"],[8,"FromStr"],[8,"Pattern"],[4,"SearchStep"],[8,"Searcher"],[8,"ReverseSearcher"],[8,"ToString"],[3,"String"],[3,"FromUtf8Error"],[3,"FromUtf16Error"],[4,"ParseError"],[3,"Drain"],[3,"Vec"],[3,"IntoIter"],[3,"Drain"],[3,"Splice"],[3,"DrainFilter"],[3,"VecDeque"],[3,"Iter"],[3,"IterMut"],[3,"IntoIter"],[3,"Drain"],[4,"Entry"],[3,"CharSliceSearcher"],[3,"CharPredicateSearcher"],[3,"CharSearcher"],[3,"StrSearcher"],[3,"EncodeUtf16"],[3,"Bytes"],[3,"Arguments"],[3,"CharIndices"],[3,"Split"],[3,"CannotReallocInPlace"],[3,"ChunksMut"],[3,"Lines"],[3,"Error"],[3,"Layout"],[3,"LinesAny"],[3,"RSplitNMut"],[3,"SplitNMut"],[3,"Iter"],[3,"IterMut"],[3,"Chunks"],[3,"RSplit"],[3,"Chars"],[3,"RSplitN"],[3,"RSplitTerminator"],[3,"ExactChunks"],[3,"RSplitMut"],[3,"SplitTerminator"],[3,"SpawnErrorKind"],[3,"ParseBoolError"],[3,"Context"],[3,"Split"],[3,"SplitN"],[3,"SplitN"],[3,"Matches"],[3,"SplitWhitespace"],[3,"RSplitN"],[3,"MatchIndices"],[3,"Utf8Error"],[3,"LocalWaker"],[3,"RMatches"],[3,"ExactChunksMut"],[3,"RSplit"],[3,"RMatchIndices"],[3,"SplitMut"],[3,"AllocErr"],[3,"LayoutErr"],[3,"Windows"],[3,"Formatter"],[3,"BTreeMap"],[3,"Iter"],[3,"IterMut"],[3,"IntoIter"],[3,"Keys"],[3,"Values"],[3,"ValuesMut"],[3,"Range"],[3,"RangeMut"],[3,"VacantEntry"],[3,"OccupiedEntry"],[3,"BTreeSet"],[3,"Iter"],[3,"IntoIter"],[3,"Range"],[3,"Difference"],[3,"SymmetricDifference"],[3,"Intersection"],[3,"Union"],[3,"DebugList"],[3,"DebugMap"],[3,"DebugSet"],[3,"DebugStruct"],[3,"DebugTuple"]]};
searchIndex["core"] = {"doc":"The Rust Core Library","items":[[0,"isize","core","The pointer-sized signed integer type.",null,null],[17,"MIN","core::isize","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"i8","core","The 8-bit signed integer type.",null,null],[17,"MIN","core::i8","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"i16","core","The 16-bit signed integer type.",null,null],[17,"MIN","core::i16","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"i32","core","The 32-bit signed integer type.",null,null],[17,"MIN","core::i32","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"i64","core","The 64-bit signed integer type.",null,null],[17,"MIN","core::i64","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"i128","core","The 128-bit signed integer type.",null,null],[17,"MIN","core::i128","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"usize","core","The pointer-sized unsigned integer type.",null,null],[17,"MIN","core::usize","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"u8","core","The 8-bit unsigned integer type.",null,null],[17,"MIN","core::u8","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"u16","core","The 16-bit unsigned integer type.",null,null],[17,"MIN","core::u16","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"u32","core","The 32-bit unsigned integer type.",null,null],[17,"MIN","core::u32","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"u64","core","The 64-bit unsigned integer type.",null,null],[17,"MIN","core::u64","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"u128","core","The 128-bit unsigned integer type.",null,null],[17,"MIN","core::u128","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"f32","core","This module provides constants which are specific to the implementation of the `f32` floating point data type.",null,null],[0,"consts","core::f32","Basic mathematical constants.",null,null],[17,"PI","core::f32::consts","Archimedes' constant (π)",null,null],[17,"FRAC_PI_2","","π/2",null,null],[17,"FRAC_PI_3","","π/3",null,null],[17,"FRAC_PI_4","","π/4",null,null],[17,"FRAC_PI_6","","π/6",null,null],[17,"FRAC_PI_8","","π/8",null,null],[17,"FRAC_1_PI","","1/π",null,null],[17,"FRAC_2_PI","","2/π",null,null],[17,"FRAC_2_SQRT_PI","","2/sqrt(π)",null,null],[17,"SQRT_2","","sqrt(2)",null,null],[17,"FRAC_1_SQRT_2","","1/sqrt(2)",null,null],[17,"E","","Euler's number (e)",null,null],[17,"LOG2_E","","log2(e)",null,null],[17,"LOG2_10","","log2(10)",null,null],[17,"LOG10_E","","log10(e)",null,null],[17,"LOG10_2","","log10(2)",null,null],[17,"LN_2","","ln(2)",null,null],[17,"LN_10","","ln(10)",null,null],[17,"RADIX","core::f32","The radix or base of the internal representation of `f32`.",null,null],[17,"MANTISSA_DIGITS","","Number of significant digits in base 2.",null,null],[17,"DIGITS","","Approximate number of significant digits in base 10.",null,null],[17,"EPSILON","","[Machine epsilon] value for `f32`.",null,null],[17,"MIN","","Smallest finite `f32` value.",null,null],[17,"MIN_POSITIVE","","Smallest positive normal `f32` value.",null,null],[17,"MAX","","Largest finite `f32` value.",null,null],[17,"MIN_EXP","","One greater than the minimum possible normal power of 2 exponent.",null,null],[17,"MAX_EXP","","Maximum possible power of 2 exponent.",null,null],[17,"MIN_10_EXP","","Minimum possible normal power of 10 exponent.",null,null],[17,"MAX_10_EXP","","Maximum possible power of 10 exponent.",null,null],[17,"NAN","","Not a Number (NaN).",null,null],[17,"INFINITY","","Infinity (∞).",null,null],[17,"NEG_INFINITY","","Negative infinity (-∞).",null,null],[0,"f64","core","This module provides constants which are specific to the implementation of the `f64` floating point data type.",null,null],[0,"consts","core::f64","Basic mathematical constants.",null,null],[17,"PI","core::f64::consts","Archimedes' constant (π)",null,null],[17,"FRAC_PI_2","","π/2",null,null],[17,"FRAC_PI_3","","π/3",null,null],[17,"FRAC_PI_4","","π/4",null,null],[17,"FRAC_PI_6","","π/6",null,null],[17,"FRAC_PI_8","","π/8",null,null],[17,"FRAC_1_PI","","1/π",null,null],[17,"FRAC_2_PI","","2/π",null,null],[17,"FRAC_2_SQRT_PI","","2/sqrt(π)",null,null],[17,"SQRT_2","","sqrt(2)",null,null],[17,"FRAC_1_SQRT_2","","1/sqrt(2)",null,null],[17,"E","","Euler's number (e)",null,null],[17,"LOG2_10","","log2(10)",null,null],[17,"LOG2_E","","log2(e)",null,null],[17,"LOG10_2","","log10(2)",null,null],[17,"LOG10_E","","log10(e)",null,null],[17,"LN_2","","ln(2)",null,null],[17,"LN_10","","ln(10)",null,null],[17,"RADIX","core::f64","The radix or base of the internal representation of `f64`.",null,null],[17,"MANTISSA_DIGITS","","Number of significant digits in base 2.",null,null],[17,"DIGITS","","Approximate number of significant digits in base 10.",null,null],[17,"EPSILON","","[Machine epsilon] value for `f64`.",null,null],[17,"MIN","","Smallest finite `f64` value.",null,null],[17,"MIN_POSITIVE","","Smallest positive normal `f64` value.",null,null],[17,"MAX","","Largest finite `f64` value.",null,null],[17,"MIN_EXP","","One greater than the minimum possible normal power of 2 exponent.",null,null],[17,"MAX_EXP","","Maximum possible power of 2 exponent.",null,null],[17,"MIN_10_EXP","","Minimum possible normal power of 10 exponent.",null,null],[17,"MAX_10_EXP","","Maximum possible power of 10 exponent.",null,null],[17,"NAN","","Not a Number (NaN).",null,null],[17,"INFINITY","","Infinity (∞).",null,null],[17,"NEG_INFINITY","","Negative infinity (-∞).",null,null],[0,"num","core","Numeric traits and functions for the built-in numeric types.",null,null],[3,"NonZeroU8","core::num","An integer that is known not to equal zero.",null,null],[3,"NonZeroU16","","An integer that is known not to equal zero.",null,null],[3,"NonZeroU32","","An integer that is known not to equal zero.",null,null],[3,"NonZeroU64","","An integer that is known not to equal zero.",null,null],[3,"NonZeroU128","","An integer that is known not to equal zero.",null,null],[3,"NonZeroUsize","","An integer that is known not to equal zero.",null,null],[3,"Wrapping","","Provides intentionally-wrapped arithmetic on `T`.",null,null],[12,"0","","",0,null],[3,"TryFromIntError","","The error type returned when a checked integral type conversion fails.",null,null],[3,"ParseIntError","","An error which can be returned when parsing an integer.",null,null],[3,"ParseFloatError","","An error which can be returned when parsing a float.",null,null],[4,"FpCategory","","A classification of floating point numbers.",null,null],[13,"Nan","","\"Not a Number\", often obtained by dividing by zero.",1,null],[13,"Infinite","","Positive or negative infinity.",1,null],[13,"Zero","","Positive or negative zero.",1,null],[13,"Subnormal","","De-normalized floating point representation (less precise than `Normal`).",1,null],[13,"Normal","","A regular floating point number.",1,null],[11,"fmt","","",2,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",2,{"i":[{"n":"self"}],"o":{"n":"parsefloaterror"}}],[11,"eq","","",2,{"i":[{"n":"self"},{"n":"parsefloaterror"}],"o":{"n":"bool"}}],[11,"ne","","",2,{"i":[{"n":"self"},{"n":"parsefloaterror"}],"o":{"n":"bool"}}],[11,"fmt","","",2,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"shl","","",0,{"i":[{"n":"self"},{"n":"usize"}],"o":{"g":["u8"],"n":"wrapping"}}],[11,"shl_assign","","",0,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shl_assign","","",0,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shr","","",0,{"i":[{"n":"self"},{"n":"usize"}],"o":{"g":["u8"],"n":"wrapping"}}],[11,"shr_assign","","",0,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shr_assign","","",0,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shl","","",0,{"i":[{"n":"self"},{"n":"usize"}],"o":{"g":["u16"],"n":"wrapping"}}],[11,"shl_assign","","",0,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shl_assign","","",0,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shr","","",0,{"i":[{"n":"self"},{"n":"usize"}],"o":{"g":["u16"],"n":"wrapping"}}],[11,"shr_assign","","",0,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shr_assign","","",0,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shl","","",0,{"i":[{"n":"self"},{"n":"usize"}],"o":{"g":["u32"],"n":"wrapping"}}],[11,"shl_assign","","",0,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shl_assign","","",0,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shr","","",0,{"i":[{"n":"self"},{"n":"usize"}],"o":{"g":["u32"],"n":"wrapping"}}],[11,"shr_assign","","",0,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shr_assign","","",0,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shl","","",0,{"i":[{"n":"self"},{"n":"usize"}],"o":{"g":["u64"],"n":"wrapping"}}],[11,"shl_assign","","",0,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shl_assign","","",0,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shr","","",0,{"i":[{"n":"self"},{"n":"usize"}],"o":{"g":["u64"],"n":"wrapping"}}],[11,"shr_assign","","",0,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shr_assign","","",0,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shl","","",0,{"i":[{"n":"self"},{"n":"usize"}],"o":{"g":["u128"],"n":"wrapping"}}],[11,"shl_assign","","",0,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shl_assign","","",0,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shr","","",0,{"i":[{"n":"self"},{"n":"usize"}],"o":{"g":["u128"],"n":"wrapping"}}],[11,"shr_assign","","",0,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shr_assign","","",0,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shl","","",0,{"i":[{"n":"self"},{"n":"usize"}],"o":{"g":["usize"],"n":"wrapping"}}],[11,"shl_assign","","",0,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shl_assign","","",0,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shr","","",0,{"i":[{"n":"self"},{"n":"usize"}],"o":{"g":["usize"],"n":"wrapping"}}],[11,"shr_assign","","",0,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shr_assign","","",0,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shl","","",0,{"i":[{"n":"self"},{"n":"usize"}],"o":{"g":["i8"],"n":"wrapping"}}],[11,"shl_assign","","",0,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shl_assign","","",0,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shr","","",0,{"i":[{"n":"self"},{"n":"usize"}],"o":{"g":["i8"],"n":"wrapping"}}],[11,"shr_assign","","",0,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shr_assign","","",0,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shl","","",0,{"i":[{"n":"self"},{"n":"usize"}],"o":{"g":["i16"],"n":"wrapping"}}],[11,"shl_assign","","",0,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shl_assign","","",0,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shr","","",0,{"i":[{"n":"self"},{"n":"usize"}],"o":{"g":["i16"],"n":"wrapping"}}],[11,"shr_assign","","",0,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shr_assign","","",0,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shl","","",0,{"i":[{"n":"self"},{"n":"usize"}],"o":{"g":["i32"],"n":"wrapping"}}],[11,"shl_assign","","",0,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shl_assign","","",0,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shr","","",0,{"i":[{"n":"self"},{"n":"usize"}],"o":{"g":["i32"],"n":"wrapping"}}],[11,"shr_assign","","",0,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shr_assign","","",0,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shl","","",0,{"i":[{"n":"self"},{"n":"usize"}],"o":{"g":["i64"],"n":"wrapping"}}],[11,"shl_assign","","",0,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shl_assign","","",0,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shr","","",0,{"i":[{"n":"self"},{"n":"usize"}],"o":{"g":["i64"],"n":"wrapping"}}],[11,"shr_assign","","",0,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shr_assign","","",0,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shl","","",0,{"i":[{"n":"self"},{"n":"usize"}],"o":{"g":["i128"],"n":"wrapping"}}],[11,"shl_assign","","",0,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shl_assign","","",0,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shr","","",0,{"i":[{"n":"self"},{"n":"usize"}],"o":{"g":["i128"],"n":"wrapping"}}],[11,"shr_assign","","",0,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shr_assign","","",0,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shl","","",0,{"i":[{"n":"self"},{"n":"usize"}],"o":{"g":["isize"],"n":"wrapping"}}],[11,"shl_assign","","",0,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shl_assign","","",0,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shr","","",0,{"i":[{"n":"self"},{"n":"usize"}],"o":{"g":["isize"],"n":"wrapping"}}],[11,"shr_assign","","",0,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shr_assign","","",0,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"add","","",0,{"i":[{"n":"self"},{"g":["usize"],"n":"wrapping"}],"o":{"g":["usize"],"n":"wrapping"}}],[11,"add","","",0,null],[11,"add_assign","","",0,{"i":[{"n":"self"},{"g":["usize"],"n":"wrapping"}]}],[11,"add_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"sub","","",0,{"i":[{"n":"self"},{"g":["usize"],"n":"wrapping"}],"o":{"g":["usize"],"n":"wrapping"}}],[11,"sub","","",0,null],[11,"sub_assign","","",0,{"i":[{"n":"self"},{"g":["usize"],"n":"wrapping"}]}],[11,"sub_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"mul","","",0,{"i":[{"n":"self"},{"g":["usize"],"n":"wrapping"}],"o":{"g":["usize"],"n":"wrapping"}}],[11,"mul","","",0,null],[11,"mul_assign","","",0,{"i":[{"n":"self"},{"g":["usize"],"n":"wrapping"}]}],[11,"mul_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"div","","",0,{"i":[{"n":"self"},{"g":["usize"],"n":"wrapping"}],"o":{"g":["usize"],"n":"wrapping"}}],[11,"div","","",0,null],[11,"div_assign","","",0,{"i":[{"n":"self"},{"g":["usize"],"n":"wrapping"}]}],[11,"div_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"rem","","",0,{"i":[{"n":"self"},{"g":["usize"],"n":"wrapping"}],"o":{"g":["usize"],"n":"wrapping"}}],[11,"rem","","",0,null],[11,"rem_assign","","",0,{"i":[{"n":"self"},{"g":["usize"],"n":"wrapping"}]}],[11,"rem_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"not","","",0,{"i":[{"n":"self"}],"o":{"g":["usize"],"n":"wrapping"}}],[11,"bitxor","","",0,{"i":[{"n":"self"},{"g":["usize"],"n":"wrapping"}],"o":{"g":["usize"],"n":"wrapping"}}],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,{"i":[{"n":"self"},{"g":["usize"],"n":"wrapping"}]}],[11,"bitxor_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"bitor","","",0,{"i":[{"n":"self"},{"g":["usize"],"n":"wrapping"}],"o":{"g":["usize"],"n":"wrapping"}}],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,{"i":[{"n":"self"},{"g":["usize"],"n":"wrapping"}]}],[11,"bitor_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"bitand","","",0,{"i":[{"n":"self"},{"g":["usize"],"n":"wrapping"}],"o":{"g":["usize"],"n":"wrapping"}}],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,{"i":[{"n":"self"},{"g":["usize"],"n":"wrapping"}]}],[11,"bitand_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"neg","","",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"add","","",0,{"i":[{"n":"self"},{"g":["u8"],"n":"wrapping"}],"o":{"g":["u8"],"n":"wrapping"}}],[11,"add","","",0,null],[11,"add_assign","","",0,{"i":[{"n":"self"},{"g":["u8"],"n":"wrapping"}]}],[11,"add_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"sub","","",0,{"i":[{"n":"self"},{"g":["u8"],"n":"wrapping"}],"o":{"g":["u8"],"n":"wrapping"}}],[11,"sub","","",0,null],[11,"sub_assign","","",0,{"i":[{"n":"self"},{"g":["u8"],"n":"wrapping"}]}],[11,"sub_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"mul","","",0,{"i":[{"n":"self"},{"g":["u8"],"n":"wrapping"}],"o":{"g":["u8"],"n":"wrapping"}}],[11,"mul","","",0,null],[11,"mul_assign","","",0,{"i":[{"n":"self"},{"g":["u8"],"n":"wrapping"}]}],[11,"mul_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"div","","",0,{"i":[{"n":"self"},{"g":["u8"],"n":"wrapping"}],"o":{"g":["u8"],"n":"wrapping"}}],[11,"div","","",0,null],[11,"div_assign","","",0,{"i":[{"n":"self"},{"g":["u8"],"n":"wrapping"}]}],[11,"div_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"rem","","",0,{"i":[{"n":"self"},{"g":["u8"],"n":"wrapping"}],"o":{"g":["u8"],"n":"wrapping"}}],[11,"rem","","",0,null],[11,"rem_assign","","",0,{"i":[{"n":"self"},{"g":["u8"],"n":"wrapping"}]}],[11,"rem_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"not","","",0,{"i":[{"n":"self"}],"o":{"g":["u8"],"n":"wrapping"}}],[11,"bitxor","","",0,{"i":[{"n":"self"},{"g":["u8"],"n":"wrapping"}],"o":{"g":["u8"],"n":"wrapping"}}],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,{"i":[{"n":"self"},{"g":["u8"],"n":"wrapping"}]}],[11,"bitxor_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"bitor","","",0,{"i":[{"n":"self"},{"g":["u8"],"n":"wrapping"}],"o":{"g":["u8"],"n":"wrapping"}}],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,{"i":[{"n":"self"},{"g":["u8"],"n":"wrapping"}]}],[11,"bitor_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"bitand","","",0,{"i":[{"n":"self"},{"g":["u8"],"n":"wrapping"}],"o":{"g":["u8"],"n":"wrapping"}}],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,{"i":[{"n":"self"},{"g":["u8"],"n":"wrapping"}]}],[11,"bitand_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"neg","","",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"add","","",0,{"i":[{"n":"self"},{"g":["u16"],"n":"wrapping"}],"o":{"g":["u16"],"n":"wrapping"}}],[11,"add","","",0,null],[11,"add_assign","","",0,{"i":[{"n":"self"},{"g":["u16"],"n":"wrapping"}]}],[11,"add_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"sub","","",0,{"i":[{"n":"self"},{"g":["u16"],"n":"wrapping"}],"o":{"g":["u16"],"n":"wrapping"}}],[11,"sub","","",0,null],[11,"sub_assign","","",0,{"i":[{"n":"self"},{"g":["u16"],"n":"wrapping"}]}],[11,"sub_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"mul","","",0,{"i":[{"n":"self"},{"g":["u16"],"n":"wrapping"}],"o":{"g":["u16"],"n":"wrapping"}}],[11,"mul","","",0,null],[11,"mul_assign","","",0,{"i":[{"n":"self"},{"g":["u16"],"n":"wrapping"}]}],[11,"mul_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"div","","",0,{"i":[{"n":"self"},{"g":["u16"],"n":"wrapping"}],"o":{"g":["u16"],"n":"wrapping"}}],[11,"div","","",0,null],[11,"div_assign","","",0,{"i":[{"n":"self"},{"g":["u16"],"n":"wrapping"}]}],[11,"div_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"rem","","",0,{"i":[{"n":"self"},{"g":["u16"],"n":"wrapping"}],"o":{"g":["u16"],"n":"wrapping"}}],[11,"rem","","",0,null],[11,"rem_assign","","",0,{"i":[{"n":"self"},{"g":["u16"],"n":"wrapping"}]}],[11,"rem_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"not","","",0,{"i":[{"n":"self"}],"o":{"g":["u16"],"n":"wrapping"}}],[11,"bitxor","","",0,{"i":[{"n":"self"},{"g":["u16"],"n":"wrapping"}],"o":{"g":["u16"],"n":"wrapping"}}],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,{"i":[{"n":"self"},{"g":["u16"],"n":"wrapping"}]}],[11,"bitxor_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"bitor","","",0,{"i":[{"n":"self"},{"g":["u16"],"n":"wrapping"}],"o":{"g":["u16"],"n":"wrapping"}}],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,{"i":[{"n":"self"},{"g":["u16"],"n":"wrapping"}]}],[11,"bitor_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"bitand","","",0,{"i":[{"n":"self"},{"g":["u16"],"n":"wrapping"}],"o":{"g":["u16"],"n":"wrapping"}}],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,{"i":[{"n":"self"},{"g":["u16"],"n":"wrapping"}]}],[11,"bitand_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"neg","","",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"add","","",0,{"i":[{"n":"self"},{"g":["u32"],"n":"wrapping"}],"o":{"g":["u32"],"n":"wrapping"}}],[11,"add","","",0,null],[11,"add_assign","","",0,{"i":[{"n":"self"},{"g":["u32"],"n":"wrapping"}]}],[11,"add_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"sub","","",0,{"i":[{"n":"self"},{"g":["u32"],"n":"wrapping"}],"o":{"g":["u32"],"n":"wrapping"}}],[11,"sub","","",0,null],[11,"sub_assign","","",0,{"i":[{"n":"self"},{"g":["u32"],"n":"wrapping"}]}],[11,"sub_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"mul","","",0,{"i":[{"n":"self"},{"g":["u32"],"n":"wrapping"}],"o":{"g":["u32"],"n":"wrapping"}}],[11,"mul","","",0,null],[11,"mul_assign","","",0,{"i":[{"n":"self"},{"g":["u32"],"n":"wrapping"}]}],[11,"mul_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"div","","",0,{"i":[{"n":"self"},{"g":["u32"],"n":"wrapping"}],"o":{"g":["u32"],"n":"wrapping"}}],[11,"div","","",0,null],[11,"div_assign","","",0,{"i":[{"n":"self"},{"g":["u32"],"n":"wrapping"}]}],[11,"div_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"rem","","",0,{"i":[{"n":"self"},{"g":["u32"],"n":"wrapping"}],"o":{"g":["u32"],"n":"wrapping"}}],[11,"rem","","",0,null],[11,"rem_assign","","",0,{"i":[{"n":"self"},{"g":["u32"],"n":"wrapping"}]}],[11,"rem_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"not","","",0,{"i":[{"n":"self"}],"o":{"g":["u32"],"n":"wrapping"}}],[11,"bitxor","","",0,{"i":[{"n":"self"},{"g":["u32"],"n":"wrapping"}],"o":{"g":["u32"],"n":"wrapping"}}],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,{"i":[{"n":"self"},{"g":["u32"],"n":"wrapping"}]}],[11,"bitxor_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"bitor","","",0,{"i":[{"n":"self"},{"g":["u32"],"n":"wrapping"}],"o":{"g":["u32"],"n":"wrapping"}}],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,{"i":[{"n":"self"},{"g":["u32"],"n":"wrapping"}]}],[11,"bitor_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"bitand","","",0,{"i":[{"n":"self"},{"g":["u32"],"n":"wrapping"}],"o":{"g":["u32"],"n":"wrapping"}}],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,{"i":[{"n":"self"},{"g":["u32"],"n":"wrapping"}]}],[11,"bitand_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"neg","","",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"add","","",0,{"i":[{"n":"self"},{"g":["u64"],"n":"wrapping"}],"o":{"g":["u64"],"n":"wrapping"}}],[11,"add","","",0,null],[11,"add_assign","","",0,{"i":[{"n":"self"},{"g":["u64"],"n":"wrapping"}]}],[11,"add_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"sub","","",0,{"i":[{"n":"self"},{"g":["u64"],"n":"wrapping"}],"o":{"g":["u64"],"n":"wrapping"}}],[11,"sub","","",0,null],[11,"sub_assign","","",0,{"i":[{"n":"self"},{"g":["u64"],"n":"wrapping"}]}],[11,"sub_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"mul","","",0,{"i":[{"n":"self"},{"g":["u64"],"n":"wrapping"}],"o":{"g":["u64"],"n":"wrapping"}}],[11,"mul","","",0,null],[11,"mul_assign","","",0,{"i":[{"n":"self"},{"g":["u64"],"n":"wrapping"}]}],[11,"mul_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"div","","",0,{"i":[{"n":"self"},{"g":["u64"],"n":"wrapping"}],"o":{"g":["u64"],"n":"wrapping"}}],[11,"div","","",0,null],[11,"div_assign","","",0,{"i":[{"n":"self"},{"g":["u64"],"n":"wrapping"}]}],[11,"div_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"rem","","",0,{"i":[{"n":"self"},{"g":["u64"],"n":"wrapping"}],"o":{"g":["u64"],"n":"wrapping"}}],[11,"rem","","",0,null],[11,"rem_assign","","",0,{"i":[{"n":"self"},{"g":["u64"],"n":"wrapping"}]}],[11,"rem_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"not","","",0,{"i":[{"n":"self"}],"o":{"g":["u64"],"n":"wrapping"}}],[11,"bitxor","","",0,{"i":[{"n":"self"},{"g":["u64"],"n":"wrapping"}],"o":{"g":["u64"],"n":"wrapping"}}],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,{"i":[{"n":"self"},{"g":["u64"],"n":"wrapping"}]}],[11,"bitxor_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"bitor","","",0,{"i":[{"n":"self"},{"g":["u64"],"n":"wrapping"}],"o":{"g":["u64"],"n":"wrapping"}}],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,{"i":[{"n":"self"},{"g":["u64"],"n":"wrapping"}]}],[11,"bitor_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"bitand","","",0,{"i":[{"n":"self"},{"g":["u64"],"n":"wrapping"}],"o":{"g":["u64"],"n":"wrapping"}}],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,{"i":[{"n":"self"},{"g":["u64"],"n":"wrapping"}]}],[11,"bitand_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"neg","","",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"add","","",0,{"i":[{"n":"self"},{"g":["u128"],"n":"wrapping"}],"o":{"g":["u128"],"n":"wrapping"}}],[11,"add","","",0,null],[11,"add_assign","","",0,{"i":[{"n":"self"},{"g":["u128"],"n":"wrapping"}]}],[11,"add_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"sub","","",0,{"i":[{"n":"self"},{"g":["u128"],"n":"wrapping"}],"o":{"g":["u128"],"n":"wrapping"}}],[11,"sub","","",0,null],[11,"sub_assign","","",0,{"i":[{"n":"self"},{"g":["u128"],"n":"wrapping"}]}],[11,"sub_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"mul","","",0,{"i":[{"n":"self"},{"g":["u128"],"n":"wrapping"}],"o":{"g":["u128"],"n":"wrapping"}}],[11,"mul","","",0,null],[11,"mul_assign","","",0,{"i":[{"n":"self"},{"g":["u128"],"n":"wrapping"}]}],[11,"mul_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"div","","",0,{"i":[{"n":"self"},{"g":["u128"],"n":"wrapping"}],"o":{"g":["u128"],"n":"wrapping"}}],[11,"div","","",0,null],[11,"div_assign","","",0,{"i":[{"n":"self"},{"g":["u128"],"n":"wrapping"}]}],[11,"div_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"rem","","",0,{"i":[{"n":"self"},{"g":["u128"],"n":"wrapping"}],"o":{"g":["u128"],"n":"wrapping"}}],[11,"rem","","",0,null],[11,"rem_assign","","",0,{"i":[{"n":"self"},{"g":["u128"],"n":"wrapping"}]}],[11,"rem_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"not","","",0,{"i":[{"n":"self"}],"o":{"g":["u128"],"n":"wrapping"}}],[11,"bitxor","","",0,{"i":[{"n":"self"},{"g":["u128"],"n":"wrapping"}],"o":{"g":["u128"],"n":"wrapping"}}],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,{"i":[{"n":"self"},{"g":["u128"],"n":"wrapping"}]}],[11,"bitxor_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"bitor","","",0,{"i":[{"n":"self"},{"g":["u128"],"n":"wrapping"}],"o":{"g":["u128"],"n":"wrapping"}}],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,{"i":[{"n":"self"},{"g":["u128"],"n":"wrapping"}]}],[11,"bitor_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"bitand","","",0,{"i":[{"n":"self"},{"g":["u128"],"n":"wrapping"}],"o":{"g":["u128"],"n":"wrapping"}}],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,{"i":[{"n":"self"},{"g":["u128"],"n":"wrapping"}]}],[11,"bitand_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"neg","","",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"add","","",0,{"i":[{"n":"self"},{"g":["isize"],"n":"wrapping"}],"o":{"g":["isize"],"n":"wrapping"}}],[11,"add","","",0,null],[11,"add_assign","","",0,{"i":[{"n":"self"},{"g":["isize"],"n":"wrapping"}]}],[11,"add_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"sub","","",0,{"i":[{"n":"self"},{"g":["isize"],"n":"wrapping"}],"o":{"g":["isize"],"n":"wrapping"}}],[11,"sub","","",0,null],[11,"sub_assign","","",0,{"i":[{"n":"self"},{"g":["isize"],"n":"wrapping"}]}],[11,"sub_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"mul","","",0,{"i":[{"n":"self"},{"g":["isize"],"n":"wrapping"}],"o":{"g":["isize"],"n":"wrapping"}}],[11,"mul","","",0,null],[11,"mul_assign","","",0,{"i":[{"n":"self"},{"g":["isize"],"n":"wrapping"}]}],[11,"mul_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"div","","",0,{"i":[{"n":"self"},{"g":["isize"],"n":"wrapping"}],"o":{"g":["isize"],"n":"wrapping"}}],[11,"div","","",0,null],[11,"div_assign","","",0,{"i":[{"n":"self"},{"g":["isize"],"n":"wrapping"}]}],[11,"div_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"rem","","",0,{"i":[{"n":"self"},{"g":["isize"],"n":"wrapping"}],"o":{"g":["isize"],"n":"wrapping"}}],[11,"rem","","",0,null],[11,"rem_assign","","",0,{"i":[{"n":"self"},{"g":["isize"],"n":"wrapping"}]}],[11,"rem_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"not","","",0,{"i":[{"n":"self"}],"o":{"g":["isize"],"n":"wrapping"}}],[11,"bitxor","","",0,{"i":[{"n":"self"},{"g":["isize"],"n":"wrapping"}],"o":{"g":["isize"],"n":"wrapping"}}],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,{"i":[{"n":"self"},{"g":["isize"],"n":"wrapping"}]}],[11,"bitxor_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"bitor","","",0,{"i":[{"n":"self"},{"g":["isize"],"n":"wrapping"}],"o":{"g":["isize"],"n":"wrapping"}}],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,{"i":[{"n":"self"},{"g":["isize"],"n":"wrapping"}]}],[11,"bitor_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"bitand","","",0,{"i":[{"n":"self"},{"g":["isize"],"n":"wrapping"}],"o":{"g":["isize"],"n":"wrapping"}}],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,{"i":[{"n":"self"},{"g":["isize"],"n":"wrapping"}]}],[11,"bitand_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"neg","","",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"add","","",0,{"i":[{"n":"self"},{"g":["i8"],"n":"wrapping"}],"o":{"g":["i8"],"n":"wrapping"}}],[11,"add","","",0,null],[11,"add_assign","","",0,{"i":[{"n":"self"},{"g":["i8"],"n":"wrapping"}]}],[11,"add_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"sub","","",0,{"i":[{"n":"self"},{"g":["i8"],"n":"wrapping"}],"o":{"g":["i8"],"n":"wrapping"}}],[11,"sub","","",0,null],[11,"sub_assign","","",0,{"i":[{"n":"self"},{"g":["i8"],"n":"wrapping"}]}],[11,"sub_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"mul","","",0,{"i":[{"n":"self"},{"g":["i8"],"n":"wrapping"}],"o":{"g":["i8"],"n":"wrapping"}}],[11,"mul","","",0,null],[11,"mul_assign","","",0,{"i":[{"n":"self"},{"g":["i8"],"n":"wrapping"}]}],[11,"mul_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"div","","",0,{"i":[{"n":"self"},{"g":["i8"],"n":"wrapping"}],"o":{"g":["i8"],"n":"wrapping"}}],[11,"div","","",0,null],[11,"div_assign","","",0,{"i":[{"n":"self"},{"g":["i8"],"n":"wrapping"}]}],[11,"div_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"rem","","",0,{"i":[{"n":"self"},{"g":["i8"],"n":"wrapping"}],"o":{"g":["i8"],"n":"wrapping"}}],[11,"rem","","",0,null],[11,"rem_assign","","",0,{"i":[{"n":"self"},{"g":["i8"],"n":"wrapping"}]}],[11,"rem_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"not","","",0,{"i":[{"n":"self"}],"o":{"g":["i8"],"n":"wrapping"}}],[11,"bitxor","","",0,{"i":[{"n":"self"},{"g":["i8"],"n":"wrapping"}],"o":{"g":["i8"],"n":"wrapping"}}],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,{"i":[{"n":"self"},{"g":["i8"],"n":"wrapping"}]}],[11,"bitxor_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"bitor","","",0,{"i":[{"n":"self"},{"g":["i8"],"n":"wrapping"}],"o":{"g":["i8"],"n":"wrapping"}}],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,{"i":[{"n":"self"},{"g":["i8"],"n":"wrapping"}]}],[11,"bitor_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"bitand","","",0,{"i":[{"n":"self"},{"g":["i8"],"n":"wrapping"}],"o":{"g":["i8"],"n":"wrapping"}}],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,{"i":[{"n":"self"},{"g":["i8"],"n":"wrapping"}]}],[11,"bitand_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"neg","","",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"add","","",0,{"i":[{"n":"self"},{"g":["i16"],"n":"wrapping"}],"o":{"g":["i16"],"n":"wrapping"}}],[11,"add","","",0,null],[11,"add_assign","","",0,{"i":[{"n":"self"},{"g":["i16"],"n":"wrapping"}]}],[11,"add_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"sub","","",0,{"i":[{"n":"self"},{"g":["i16"],"n":"wrapping"}],"o":{"g":["i16"],"n":"wrapping"}}],[11,"sub","","",0,null],[11,"sub_assign","","",0,{"i":[{"n":"self"},{"g":["i16"],"n":"wrapping"}]}],[11,"sub_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"mul","","",0,{"i":[{"n":"self"},{"g":["i16"],"n":"wrapping"}],"o":{"g":["i16"],"n":"wrapping"}}],[11,"mul","","",0,null],[11,"mul_assign","","",0,{"i":[{"n":"self"},{"g":["i16"],"n":"wrapping"}]}],[11,"mul_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"div","","",0,{"i":[{"n":"self"},{"g":["i16"],"n":"wrapping"}],"o":{"g":["i16"],"n":"wrapping"}}],[11,"div","","",0,null],[11,"div_assign","","",0,{"i":[{"n":"self"},{"g":["i16"],"n":"wrapping"}]}],[11,"div_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"rem","","",0,{"i":[{"n":"self"},{"g":["i16"],"n":"wrapping"}],"o":{"g":["i16"],"n":"wrapping"}}],[11,"rem","","",0,null],[11,"rem_assign","","",0,{"i":[{"n":"self"},{"g":["i16"],"n":"wrapping"}]}],[11,"rem_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"not","","",0,{"i":[{"n":"self"}],"o":{"g":["i16"],"n":"wrapping"}}],[11,"bitxor","","",0,{"i":[{"n":"self"},{"g":["i16"],"n":"wrapping"}],"o":{"g":["i16"],"n":"wrapping"}}],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,{"i":[{"n":"self"},{"g":["i16"],"n":"wrapping"}]}],[11,"bitxor_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"bitor","","",0,{"i":[{"n":"self"},{"g":["i16"],"n":"wrapping"}],"o":{"g":["i16"],"n":"wrapping"}}],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,{"i":[{"n":"self"},{"g":["i16"],"n":"wrapping"}]}],[11,"bitor_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"bitand","","",0,{"i":[{"n":"self"},{"g":["i16"],"n":"wrapping"}],"o":{"g":["i16"],"n":"wrapping"}}],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,{"i":[{"n":"self"},{"g":["i16"],"n":"wrapping"}]}],[11,"bitand_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"neg","","",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"add","","",0,{"i":[{"n":"self"},{"g":["i32"],"n":"wrapping"}],"o":{"g":["i32"],"n":"wrapping"}}],[11,"add","","",0,null],[11,"add_assign","","",0,{"i":[{"n":"self"},{"g":["i32"],"n":"wrapping"}]}],[11,"add_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"sub","","",0,{"i":[{"n":"self"},{"g":["i32"],"n":"wrapping"}],"o":{"g":["i32"],"n":"wrapping"}}],[11,"sub","","",0,null],[11,"sub_assign","","",0,{"i":[{"n":"self"},{"g":["i32"],"n":"wrapping"}]}],[11,"sub_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"mul","","",0,{"i":[{"n":"self"},{"g":["i32"],"n":"wrapping"}],"o":{"g":["i32"],"n":"wrapping"}}],[11,"mul","","",0,null],[11,"mul_assign","","",0,{"i":[{"n":"self"},{"g":["i32"],"n":"wrapping"}]}],[11,"mul_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"div","","",0,{"i":[{"n":"self"},{"g":["i32"],"n":"wrapping"}],"o":{"g":["i32"],"n":"wrapping"}}],[11,"div","","",0,null],[11,"div_assign","","",0,{"i":[{"n":"self"},{"g":["i32"],"n":"wrapping"}]}],[11,"div_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"rem","","",0,{"i":[{"n":"self"},{"g":["i32"],"n":"wrapping"}],"o":{"g":["i32"],"n":"wrapping"}}],[11,"rem","","",0,null],[11,"rem_assign","","",0,{"i":[{"n":"self"},{"g":["i32"],"n":"wrapping"}]}],[11,"rem_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"not","","",0,{"i":[{"n":"self"}],"o":{"g":["i32"],"n":"wrapping"}}],[11,"bitxor","","",0,{"i":[{"n":"self"},{"g":["i32"],"n":"wrapping"}],"o":{"g":["i32"],"n":"wrapping"}}],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,{"i":[{"n":"self"},{"g":["i32"],"n":"wrapping"}]}],[11,"bitxor_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"bitor","","",0,{"i":[{"n":"self"},{"g":["i32"],"n":"wrapping"}],"o":{"g":["i32"],"n":"wrapping"}}],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,{"i":[{"n":"self"},{"g":["i32"],"n":"wrapping"}]}],[11,"bitor_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"bitand","","",0,{"i":[{"n":"self"},{"g":["i32"],"n":"wrapping"}],"o":{"g":["i32"],"n":"wrapping"}}],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,{"i":[{"n":"self"},{"g":["i32"],"n":"wrapping"}]}],[11,"bitand_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"neg","","",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"add","","",0,{"i":[{"n":"self"},{"g":["i64"],"n":"wrapping"}],"o":{"g":["i64"],"n":"wrapping"}}],[11,"add","","",0,null],[11,"add_assign","","",0,{"i":[{"n":"self"},{"g":["i64"],"n":"wrapping"}]}],[11,"add_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"sub","","",0,{"i":[{"n":"self"},{"g":["i64"],"n":"wrapping"}],"o":{"g":["i64"],"n":"wrapping"}}],[11,"sub","","",0,null],[11,"sub_assign","","",0,{"i":[{"n":"self"},{"g":["i64"],"n":"wrapping"}]}],[11,"sub_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"mul","","",0,{"i":[{"n":"self"},{"g":["i64"],"n":"wrapping"}],"o":{"g":["i64"],"n":"wrapping"}}],[11,"mul","","",0,null],[11,"mul_assign","","",0,{"i":[{"n":"self"},{"g":["i64"],"n":"wrapping"}]}],[11,"mul_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"div","","",0,{"i":[{"n":"self"},{"g":["i64"],"n":"wrapping"}],"o":{"g":["i64"],"n":"wrapping"}}],[11,"div","","",0,null],[11,"div_assign","","",0,{"i":[{"n":"self"},{"g":["i64"],"n":"wrapping"}]}],[11,"div_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"rem","","",0,{"i":[{"n":"self"},{"g":["i64"],"n":"wrapping"}],"o":{"g":["i64"],"n":"wrapping"}}],[11,"rem","","",0,null],[11,"rem_assign","","",0,{"i":[{"n":"self"},{"g":["i64"],"n":"wrapping"}]}],[11,"rem_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"not","","",0,{"i":[{"n":"self"}],"o":{"g":["i64"],"n":"wrapping"}}],[11,"bitxor","","",0,{"i":[{"n":"self"},{"g":["i64"],"n":"wrapping"}],"o":{"g":["i64"],"n":"wrapping"}}],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,{"i":[{"n":"self"},{"g":["i64"],"n":"wrapping"}]}],[11,"bitxor_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"bitor","","",0,{"i":[{"n":"self"},{"g":["i64"],"n":"wrapping"}],"o":{"g":["i64"],"n":"wrapping"}}],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,{"i":[{"n":"self"},{"g":["i64"],"n":"wrapping"}]}],[11,"bitor_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"bitand","","",0,{"i":[{"n":"self"},{"g":["i64"],"n":"wrapping"}],"o":{"g":["i64"],"n":"wrapping"}}],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,{"i":[{"n":"self"},{"g":["i64"],"n":"wrapping"}]}],[11,"bitand_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"neg","","",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"add","","",0,{"i":[{"n":"self"},{"g":["i128"],"n":"wrapping"}],"o":{"g":["i128"],"n":"wrapping"}}],[11,"add","","",0,null],[11,"add_assign","","",0,{"i":[{"n":"self"},{"g":["i128"],"n":"wrapping"}]}],[11,"add_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"sub","","",0,{"i":[{"n":"self"},{"g":["i128"],"n":"wrapping"}],"o":{"g":["i128"],"n":"wrapping"}}],[11,"sub","","",0,null],[11,"sub_assign","","",0,{"i":[{"n":"self"},{"g":["i128"],"n":"wrapping"}]}],[11,"sub_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"mul","","",0,{"i":[{"n":"self"},{"g":["i128"],"n":"wrapping"}],"o":{"g":["i128"],"n":"wrapping"}}],[11,"mul","","",0,null],[11,"mul_assign","","",0,{"i":[{"n":"self"},{"g":["i128"],"n":"wrapping"}]}],[11,"mul_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"div","","",0,{"i":[{"n":"self"},{"g":["i128"],"n":"wrapping"}],"o":{"g":["i128"],"n":"wrapping"}}],[11,"div","","",0,null],[11,"div_assign","","",0,{"i":[{"n":"self"},{"g":["i128"],"n":"wrapping"}]}],[11,"div_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"rem","","",0,{"i":[{"n":"self"},{"g":["i128"],"n":"wrapping"}],"o":{"g":["i128"],"n":"wrapping"}}],[11,"rem","","",0,null],[11,"rem_assign","","",0,{"i":[{"n":"self"},{"g":["i128"],"n":"wrapping"}]}],[11,"rem_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"not","","",0,{"i":[{"n":"self"}],"o":{"g":["i128"],"n":"wrapping"}}],[11,"bitxor","","",0,{"i":[{"n":"self"},{"g":["i128"],"n":"wrapping"}],"o":{"g":["i128"],"n":"wrapping"}}],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,{"i":[{"n":"self"},{"g":["i128"],"n":"wrapping"}]}],[11,"bitxor_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"bitor","","",0,{"i":[{"n":"self"},{"g":["i128"],"n":"wrapping"}],"o":{"g":["i128"],"n":"wrapping"}}],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,{"i":[{"n":"self"},{"g":["i128"],"n":"wrapping"}]}],[11,"bitor_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"bitand","","",0,{"i":[{"n":"self"},{"g":["i128"],"n":"wrapping"}],"o":{"g":["i128"],"n":"wrapping"}}],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,{"i":[{"n":"self"},{"g":["i128"],"n":"wrapping"}]}],[11,"bitand_assign","","",0,{"i":[{"n":"self"},{"n":"wrapping"}]}],[11,"neg","","",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"min_value","","Returns the smallest value that can be represented by this integer type.",0,{"o":{"n":"self"}}],[11,"max_value","","Returns the largest value that can be represented by this integer type.",0,{"o":{"n":"self"}}],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",0,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",0,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation of `self`.",0,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`, wrapping the truncated bits to the end of the resulting integer.",0,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"self"}}],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`, wrapping the truncated bits to the beginning of the resulting integer.",0,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"self"}}],[11,"swap_bytes","","Reverses the byte order of the integer.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"from_be","","Converts an integer from big endian to the target's endianness.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"from_le","","Converts an integer from little endian to the target's endianness.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"to_le","","Converts `self` to little endian from the target's endianness.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",0,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"self"}}],[11,"min_value","","Returns the smallest value that can be represented by this integer type.",0,{"o":{"n":"self"}}],[11,"max_value","","Returns the largest value that can be represented by this integer type.",0,{"o":{"n":"self"}}],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",0,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",0,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation of `self`.",0,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`, wrapping the truncated bits to the end of the resulting integer.",0,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"self"}}],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`, wrapping the truncated bits to the beginning of the resulting integer.",0,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"self"}}],[11,"swap_bytes","","Reverses the byte order of the integer.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"from_be","","Converts an integer from big endian to the target's endianness.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"from_le","","Converts an integer from little endian to the target's endianness.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"to_le","","Converts `self` to little endian from the target's endianness.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",0,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"self"}}],[11,"min_value","","Returns the smallest value that can be represented by this integer type.",0,{"o":{"n":"self"}}],[11,"max_value","","Returns the largest value that can be represented by this integer type.",0,{"o":{"n":"self"}}],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",0,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",0,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation of `self`.",0,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`, wrapping the truncated bits to the end of the resulting integer.",0,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"self"}}],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`, wrapping the truncated bits to the beginning of the resulting integer.",0,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"self"}}],[11,"swap_bytes","","Reverses the byte order of the integer.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"from_be","","Converts an integer from big endian to the target's endianness.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"from_le","","Converts an integer from little endian to the target's endianness.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"to_le","","Converts `self` to little endian from the target's endianness.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",0,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"self"}}],[11,"min_value","","Returns the smallest value that can be represented by this integer type.",0,{"o":{"n":"self"}}],[11,"max_value","","Returns the largest value that can be represented by this integer type.",0,{"o":{"n":"self"}}],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",0,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",0,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation of `self`.",0,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`, wrapping the truncated bits to the end of the resulting integer.",0,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"self"}}],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`, wrapping the truncated bits to the beginning of the resulting integer.",0,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"self"}}],[11,"swap_bytes","","Reverses the byte order of the integer.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"from_be","","Converts an integer from big endian to the target's endianness.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"from_le","","Converts an integer from little endian to the target's endianness.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"to_le","","Converts `self` to little endian from the target's endianness.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",0,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"self"}}],[11,"min_value","","Returns the smallest value that can be represented by this integer type.",0,{"o":{"n":"self"}}],[11,"max_value","","Returns the largest value that can be represented by this integer type.",0,{"o":{"n":"self"}}],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",0,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",0,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation of `self`.",0,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`, wrapping the truncated bits to the end of the resulting integer.",0,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"self"}}],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`, wrapping the truncated bits to the beginning of the resulting integer.",0,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"self"}}],[11,"swap_bytes","","Reverses the byte order of the integer.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"from_be","","Converts an integer from big endian to the target's endianness.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"from_le","","Converts an integer from little endian to the target's endianness.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"to_le","","Converts `self` to little endian from the target's endianness.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",0,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"self"}}],[11,"min_value","","Returns the smallest value that can be represented by this integer type.",0,{"o":{"n":"self"}}],[11,"max_value","","Returns the largest value that can be represented by this integer type.",0,{"o":{"n":"self"}}],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",0,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",0,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation of `self`.",0,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`, wrapping the truncated bits to the end of the resulting integer.",0,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"self"}}],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`, wrapping the truncated bits to the beginning of the resulting integer.",0,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"self"}}],[11,"swap_bytes","","Reverses the byte order of the integer.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"from_be","","Converts an integer from big endian to the target's endianness.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"from_le","","Converts an integer from little endian to the target's endianness.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"to_le","","Converts `self` to little endian from the target's endianness.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",0,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"self"}}],[11,"min_value","","Returns the smallest value that can be represented by this integer type.",0,{"o":{"n":"self"}}],[11,"max_value","","Returns the largest value that can be represented by this integer type.",0,{"o":{"n":"self"}}],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",0,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",0,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation of `self`.",0,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`, wrapping the truncated bits to the end of the resulting integer.",0,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"self"}}],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`, wrapping the truncated bits to the beginning of the resulting integer.",0,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"self"}}],[11,"swap_bytes","","Reverses the byte order of the integer.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"from_be","","Converts an integer from big endian to the target's endianness.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"from_le","","Converts an integer from little endian to the target's endianness.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"to_le","","Converts `self` to little endian from the target's endianness.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",0,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"self"}}],[11,"min_value","","Returns the smallest value that can be represented by this integer type.",0,{"o":{"n":"self"}}],[11,"max_value","","Returns the largest value that can be represented by this integer type.",0,{"o":{"n":"self"}}],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",0,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",0,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation of `self`.",0,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`, wrapping the truncated bits to the end of the resulting integer.",0,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"self"}}],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`, wrapping the truncated bits to the beginning of the resulting integer.",0,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"self"}}],[11,"swap_bytes","","Reverses the byte order of the integer.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"from_be","","Converts an integer from big endian to the target's endianness.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"from_le","","Converts an integer from little endian to the target's endianness.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"to_le","","Converts `self` to little endian from the target's endianness.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",0,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"self"}}],[11,"min_value","","Returns the smallest value that can be represented by this integer type.",0,{"o":{"n":"self"}}],[11,"max_value","","Returns the largest value that can be represented by this integer type.",0,{"o":{"n":"self"}}],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",0,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",0,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation of `self`.",0,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`, wrapping the truncated bits to the end of the resulting integer.",0,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"self"}}],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`, wrapping the truncated bits to the beginning of the resulting integer.",0,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"self"}}],[11,"swap_bytes","","Reverses the byte order of the integer.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"from_be","","Converts an integer from big endian to the target's endianness.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"from_le","","Converts an integer from little endian to the target's endianness.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"to_le","","Converts `self` to little endian from the target's endianness.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",0,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"self"}}],[11,"min_value","","Returns the smallest value that can be represented by this integer type.",0,{"o":{"n":"self"}}],[11,"max_value","","Returns the largest value that can be represented by this integer type.",0,{"o":{"n":"self"}}],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",0,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",0,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation of `self`.",0,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`, wrapping the truncated bits to the end of the resulting integer.",0,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"self"}}],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`, wrapping the truncated bits to the beginning of the resulting integer.",0,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"self"}}],[11,"swap_bytes","","Reverses the byte order of the integer.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"from_be","","Converts an integer from big endian to the target's endianness.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"from_le","","Converts an integer from little endian to the target's endianness.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"to_le","","Converts `self` to little endian from the target's endianness.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",0,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"self"}}],[11,"min_value","","Returns the smallest value that can be represented by this integer type.",0,{"o":{"n":"self"}}],[11,"max_value","","Returns the largest value that can be represented by this integer type.",0,{"o":{"n":"self"}}],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",0,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",0,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation of `self`.",0,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`, wrapping the truncated bits to the end of the resulting integer.",0,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"self"}}],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`, wrapping the truncated bits to the beginning of the resulting integer.",0,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"self"}}],[11,"swap_bytes","","Reverses the byte order of the integer.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"from_be","","Converts an integer from big endian to the target's endianness.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"from_le","","Converts an integer from little endian to the target's endianness.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"to_le","","Converts `self` to little endian from the target's endianness.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",0,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"self"}}],[11,"min_value","","Returns the smallest value that can be represented by this integer type.",0,{"o":{"n":"self"}}],[11,"max_value","","Returns the largest value that can be represented by this integer type.",0,{"o":{"n":"self"}}],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",0,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",0,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation of `self`.",0,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`, wrapping the truncated bits to the end of the resulting integer.",0,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"self"}}],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`, wrapping the truncated bits to the beginning of the resulting integer.",0,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"self"}}],[11,"swap_bytes","","Reverses the byte order of the integer.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"from_be","","Converts an integer from big endian to the target's endianness.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"from_le","","Converts an integer from little endian to the target's endianness.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"to_le","","Converts `self` to little endian from the target's endianness.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",0,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"self"}}],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation of `self`.",0,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"abs","","Computes the absolute value of `self`, wrapping around at the boundary of the type.",0,{"i":[{"n":"self"}],"o":{"g":["isize"],"n":"wrapping"}}],[11,"signum","","Returns a number representing sign of `self`.",0,{"i":[{"n":"self"}],"o":{"g":["isize"],"n":"wrapping"}}],[11,"is_positive","","Returns `true` if `self` is positive and `false` if the number is zero or negative.",0,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"is_negative","","Returns `true` if `self` is negative and `false` if the number is zero or positive.",0,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation of `self`.",0,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"abs","","Computes the absolute value of `self`, wrapping around at the boundary of the type.",0,{"i":[{"n":"self"}],"o":{"g":["i8"],"n":"wrapping"}}],[11,"signum","","Returns a number representing sign of `self`.",0,{"i":[{"n":"self"}],"o":{"g":["i8"],"n":"wrapping"}}],[11,"is_positive","","Returns `true` if `self` is positive and `false` if the number is zero or negative.",0,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"is_negative","","Returns `true` if `self` is negative and `false` if the number is zero or positive.",0,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation of `self`.",0,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"abs","","Computes the absolute value of `self`, wrapping around at the boundary of the type.",0,{"i":[{"n":"self"}],"o":{"g":["i16"],"n":"wrapping"}}],[11,"signum","","Returns a number representing sign of `self`.",0,{"i":[{"n":"self"}],"o":{"g":["i16"],"n":"wrapping"}}],[11,"is_positive","","Returns `true` if `self` is positive and `false` if the number is zero or negative.",0,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"is_negative","","Returns `true` if `self` is negative and `false` if the number is zero or positive.",0,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation of `self`.",0,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"abs","","Computes the absolute value of `self`, wrapping around at the boundary of the type.",0,{"i":[{"n":"self"}],"o":{"g":["i32"],"n":"wrapping"}}],[11,"signum","","Returns a number representing sign of `self`.",0,{"i":[{"n":"self"}],"o":{"g":["i32"],"n":"wrapping"}}],[11,"is_positive","","Returns `true` if `self` is positive and `false` if the number is zero or negative.",0,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"is_negative","","Returns `true` if `self` is negative and `false` if the number is zero or positive.",0,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation of `self`.",0,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"abs","","Computes the absolute value of `self`, wrapping around at the boundary of the type.",0,{"i":[{"n":"self"}],"o":{"g":["i64"],"n":"wrapping"}}],[11,"signum","","Returns a number representing sign of `self`.",0,{"i":[{"n":"self"}],"o":{"g":["i64"],"n":"wrapping"}}],[11,"is_positive","","Returns `true` if `self` is positive and `false` if the number is zero or negative.",0,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"is_negative","","Returns `true` if `self` is negative and `false` if the number is zero or positive.",0,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation of `self`.",0,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"abs","","Computes the absolute value of `self`, wrapping around at the boundary of the type.",0,{"i":[{"n":"self"}],"o":{"g":["i128"],"n":"wrapping"}}],[11,"signum","","Returns a number representing sign of `self`.",0,{"i":[{"n":"self"}],"o":{"g":["i128"],"n":"wrapping"}}],[11,"is_positive","","Returns `true` if `self` is positive and `false` if the number is zero or negative.",0,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"is_negative","","Returns `true` if `self` is negative and `false` if the number is zero or positive.",0,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation of `self`.",0,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"is_power_of_two","","Returns `true` if and only if `self == 2^k` for some `k`.",0,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"next_power_of_two","","Returns the smallest power of two greater than or equal to `self`.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation of `self`.",0,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"is_power_of_two","","Returns `true` if and only if `self == 2^k` for some `k`.",0,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"next_power_of_two","","Returns the smallest power of two greater than or equal to `self`.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation of `self`.",0,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"is_power_of_two","","Returns `true` if and only if `self == 2^k` for some `k`.",0,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"next_power_of_two","","Returns the smallest power of two greater than or equal to `self`.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation of `self`.",0,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"is_power_of_two","","Returns `true` if and only if `self == 2^k` for some `k`.",0,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"next_power_of_two","","Returns the smallest power of two greater than or equal to `self`.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation of `self`.",0,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"is_power_of_two","","Returns `true` if and only if `self == 2^k` for some `k`.",0,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"next_power_of_two","","Returns the smallest power of two greater than or equal to `self`.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation of `self`.",0,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"is_power_of_two","","Returns `true` if and only if `self == 2^k` for some `k`.",0,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"next_power_of_two","","Returns the smallest power of two greater than or equal to `self`.",0,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"clone","","",3,{"i":[{"n":"self"}],"o":{"n":"nonzerou8"}}],[11,"eq","","",3,{"i":[{"n":"self"},{"n":"nonzerou8"}],"o":{"n":"bool"}}],[11,"ne","","",3,{"i":[{"n":"self"},{"n":"nonzerou8"}],"o":{"n":"bool"}}],[11,"cmp","","",3,{"i":[{"n":"self"},{"n":"nonzerou8"}],"o":{"n":"ordering"}}],[11,"partial_cmp","","",3,{"i":[{"n":"self"},{"n":"nonzerou8"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",3,{"i":[{"n":"self"},{"n":"nonzerou8"}],"o":{"n":"bool"}}],[11,"le","","",3,{"i":[{"n":"self"},{"n":"nonzerou8"}],"o":{"n":"bool"}}],[11,"gt","","",3,{"i":[{"n":"self"},{"n":"nonzerou8"}],"o":{"n":"bool"}}],[11,"ge","","",3,{"i":[{"n":"self"},{"n":"nonzerou8"}],"o":{"n":"bool"}}],[11,"hash","","",3,null],[11,"new_unchecked","","Create a non-zero without checking the value.",3,{"i":[{"n":"u8"}],"o":{"n":"self"}}],[11,"new","","Create a non-zero if the given value is not zero.",3,{"i":[{"n":"u8"}],"o":{"n":"option"}}],[11,"get","","Returns the value as a primitive type.",3,{"i":[{"n":"self"}],"o":{"n":"u8"}}],[11,"fmt","","",3,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",3,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",3,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",3,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",3,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",3,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",4,{"i":[{"n":"self"}],"o":{"n":"nonzerou16"}}],[11,"eq","","",4,{"i":[{"n":"self"},{"n":"nonzerou16"}],"o":{"n":"bool"}}],[11,"ne","","",4,{"i":[{"n":"self"},{"n":"nonzerou16"}],"o":{"n":"bool"}}],[11,"cmp","","",4,{"i":[{"n":"self"},{"n":"nonzerou16"}],"o":{"n":"ordering"}}],[11,"partial_cmp","","",4,{"i":[{"n":"self"},{"n":"nonzerou16"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",4,{"i":[{"n":"self"},{"n":"nonzerou16"}],"o":{"n":"bool"}}],[11,"le","","",4,{"i":[{"n":"self"},{"n":"nonzerou16"}],"o":{"n":"bool"}}],[11,"gt","","",4,{"i":[{"n":"self"},{"n":"nonzerou16"}],"o":{"n":"bool"}}],[11,"ge","","",4,{"i":[{"n":"self"},{"n":"nonzerou16"}],"o":{"n":"bool"}}],[11,"hash","","",4,null],[11,"new_unchecked","","Create a non-zero without checking the value.",4,{"i":[{"n":"u16"}],"o":{"n":"self"}}],[11,"new","","Create a non-zero if the given value is not zero.",4,{"i":[{"n":"u16"}],"o":{"n":"option"}}],[11,"get","","Returns the value as a primitive type.",4,{"i":[{"n":"self"}],"o":{"n":"u16"}}],[11,"fmt","","",4,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",4,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",4,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",4,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",4,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",4,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",5,{"i":[{"n":"self"}],"o":{"n":"nonzerou32"}}],[11,"eq","","",5,{"i":[{"n":"self"},{"n":"nonzerou32"}],"o":{"n":"bool"}}],[11,"ne","","",5,{"i":[{"n":"self"},{"n":"nonzerou32"}],"o":{"n":"bool"}}],[11,"cmp","","",5,{"i":[{"n":"self"},{"n":"nonzerou32"}],"o":{"n":"ordering"}}],[11,"partial_cmp","","",5,{"i":[{"n":"self"},{"n":"nonzerou32"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",5,{"i":[{"n":"self"},{"n":"nonzerou32"}],"o":{"n":"bool"}}],[11,"le","","",5,{"i":[{"n":"self"},{"n":"nonzerou32"}],"o":{"n":"bool"}}],[11,"gt","","",5,{"i":[{"n":"self"},{"n":"nonzerou32"}],"o":{"n":"bool"}}],[11,"ge","","",5,{"i":[{"n":"self"},{"n":"nonzerou32"}],"o":{"n":"bool"}}],[11,"hash","","",5,null],[11,"new_unchecked","","Create a non-zero without checking the value.",5,{"i":[{"n":"u32"}],"o":{"n":"self"}}],[11,"new","","Create a non-zero if the given value is not zero.",5,{"i":[{"n":"u32"}],"o":{"n":"option"}}],[11,"get","","Returns the value as a primitive type.",5,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"fmt","","",5,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",5,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",5,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",5,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",5,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",5,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",6,{"i":[{"n":"self"}],"o":{"n":"nonzerou64"}}],[11,"eq","","",6,{"i":[{"n":"self"},{"n":"nonzerou64"}],"o":{"n":"bool"}}],[11,"ne","","",6,{"i":[{"n":"self"},{"n":"nonzerou64"}],"o":{"n":"bool"}}],[11,"cmp","","",6,{"i":[{"n":"self"},{"n":"nonzerou64"}],"o":{"n":"ordering"}}],[11,"partial_cmp","","",6,{"i":[{"n":"self"},{"n":"nonzerou64"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",6,{"i":[{"n":"self"},{"n":"nonzerou64"}],"o":{"n":"bool"}}],[11,"le","","",6,{"i":[{"n":"self"},{"n":"nonzerou64"}],"o":{"n":"bool"}}],[11,"gt","","",6,{"i":[{"n":"self"},{"n":"nonzerou64"}],"o":{"n":"bool"}}],[11,"ge","","",6,{"i":[{"n":"self"},{"n":"nonzerou64"}],"o":{"n":"bool"}}],[11,"hash","","",6,null],[11,"new_unchecked","","Create a non-zero without checking the value.",6,{"i":[{"n":"u64"}],"o":{"n":"self"}}],[11,"new","","Create a non-zero if the given value is not zero.",6,{"i":[{"n":"u64"}],"o":{"n":"option"}}],[11,"get","","Returns the value as a primitive type.",6,{"i":[{"n":"self"}],"o":{"n":"u64"}}],[11,"fmt","","",6,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",6,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",6,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",6,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",6,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",6,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",7,{"i":[{"n":"self"}],"o":{"n":"nonzerou128"}}],[11,"eq","","",7,{"i":[{"n":"self"},{"n":"nonzerou128"}],"o":{"n":"bool"}}],[11,"ne","","",7,{"i":[{"n":"self"},{"n":"nonzerou128"}],"o":{"n":"bool"}}],[11,"cmp","","",7,{"i":[{"n":"self"},{"n":"nonzerou128"}],"o":{"n":"ordering"}}],[11,"partial_cmp","","",7,{"i":[{"n":"self"},{"n":"nonzerou128"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",7,{"i":[{"n":"self"},{"n":"nonzerou128"}],"o":{"n":"bool"}}],[11,"le","","",7,{"i":[{"n":"self"},{"n":"nonzerou128"}],"o":{"n":"bool"}}],[11,"gt","","",7,{"i":[{"n":"self"},{"n":"nonzerou128"}],"o":{"n":"bool"}}],[11,"ge","","",7,{"i":[{"n":"self"},{"n":"nonzerou128"}],"o":{"n":"bool"}}],[11,"hash","","",7,null],[11,"new_unchecked","","Create a non-zero without checking the value.",7,{"i":[{"n":"u128"}],"o":{"n":"self"}}],[11,"new","","Create a non-zero if the given value is not zero.",7,{"i":[{"n":"u128"}],"o":{"n":"option"}}],[11,"get","","Returns the value as a primitive type.",7,{"i":[{"n":"self"}],"o":{"n":"u128"}}],[11,"fmt","","",7,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",7,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",7,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",7,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",7,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",7,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",8,{"i":[{"n":"self"}],"o":{"n":"nonzerousize"}}],[11,"eq","","",8,{"i":[{"n":"self"},{"n":"nonzerousize"}],"o":{"n":"bool"}}],[11,"ne","","",8,{"i":[{"n":"self"},{"n":"nonzerousize"}],"o":{"n":"bool"}}],[11,"cmp","","",8,{"i":[{"n":"self"},{"n":"nonzerousize"}],"o":{"n":"ordering"}}],[11,"partial_cmp","","",8,{"i":[{"n":"self"},{"n":"nonzerousize"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",8,{"i":[{"n":"self"},{"n":"nonzerousize"}],"o":{"n":"bool"}}],[11,"le","","",8,{"i":[{"n":"self"},{"n":"nonzerousize"}],"o":{"n":"bool"}}],[11,"gt","","",8,{"i":[{"n":"self"},{"n":"nonzerousize"}],"o":{"n":"bool"}}],[11,"ge","","",8,{"i":[{"n":"self"},{"n":"nonzerousize"}],"o":{"n":"bool"}}],[11,"hash","","",8,null],[11,"new_unchecked","","Create a non-zero without checking the value.",8,{"i":[{"n":"usize"}],"o":{"n":"self"}}],[11,"new","","Create a non-zero if the given value is not zero.",8,{"i":[{"n":"usize"}],"o":{"n":"option"}}],[11,"get","","Returns the value as a primitive type.",8,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"fmt","","",8,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",8,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",8,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",8,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",8,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",8,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"eq","","",0,{"i":[{"n":"self"},{"n":"wrapping"}],"o":{"n":"bool"}}],[11,"ne","","",0,{"i":[{"n":"self"},{"n":"wrapping"}],"o":{"n":"bool"}}],[11,"partial_cmp","","",0,{"i":[{"n":"self"},{"n":"wrapping"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",0,{"i":[{"n":"self"},{"n":"wrapping"}],"o":{"n":"bool"}}],[11,"le","","",0,{"i":[{"n":"self"},{"n":"wrapping"}],"o":{"n":"bool"}}],[11,"gt","","",0,{"i":[{"n":"self"},{"n":"wrapping"}],"o":{"n":"bool"}}],[11,"ge","","",0,{"i":[{"n":"self"},{"n":"wrapping"}],"o":{"n":"bool"}}],[11,"cmp","","",0,{"i":[{"n":"self"},{"n":"wrapping"}],"o":{"n":"ordering"}}],[11,"clone","","",0,{"i":[{"n":"self"}],"o":{"n":"wrapping"}}],[11,"default","","",0,{"o":{"n":"wrapping"}}],[11,"hash","","",0,null],[11,"fmt","","",0,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",0,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",0,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",0,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",0,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",0,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",1,{"i":[{"n":"self"}],"o":{"n":"fpcategory"}}],[11,"eq","","",1,{"i":[{"n":"self"},{"n":"fpcategory"}],"o":{"n":"bool"}}],[11,"fmt","","",1,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",9,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",9,{"i":[{"n":"self"}],"o":{"n":"tryfrominterror"}}],[11,"fmt","","",9,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"from","","",9,null],[11,"fmt","","",10,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",10,{"i":[{"n":"self"}],"o":{"n":"parseinterror"}}],[11,"eq","","",10,{"i":[{"n":"self"},{"n":"parseinterror"}],"o":{"n":"bool"}}],[11,"ne","","",10,{"i":[{"n":"self"},{"n":"parseinterror"}],"o":{"n":"bool"}}],[11,"fmt","","",10,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[0,"prelude","core","The libcore prelude",null,null],[0,"v1","core::prelude","The core prelude",null,null],[0,"intrinsics","core","rustc compiler intrinsics.",null,null],[5,"atomic_cxchg","core::intrinsics","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::SeqCst` as both the `success` and `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",null,null],[5,"atomic_cxchg_acq","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::Acquire` as both the `success` and `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",null,null],[5,"atomic_cxchg_rel","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::Release` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",null,null],[5,"atomic_cxchg_acqrel","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::AcqRel` as the `success` and `Ordering::Acquire` as the `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",null,null],[5,"atomic_cxchg_relaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::Relaxed` as both the `success` and `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",null,null],[5,"atomic_cxchg_failrelaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::SeqCst` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",null,null],[5,"atomic_cxchg_failacq","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::SeqCst` as the `success` and `Ordering::Acquire` as the `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",null,null],[5,"atomic_cxchg_acq_failrelaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::Acquire` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",null,null],[5,"atomic_cxchg_acqrel_failrelaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::AcqRel` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",null,null],[5,"atomic_cxchgweak","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::SeqCst` as both the `success` and `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",null,null],[5,"atomic_cxchgweak_acq","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::Acquire` as both the `success` and `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",null,null],[5,"atomic_cxchgweak_rel","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::Release` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",null,null],[5,"atomic_cxchgweak_acqrel","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::AcqRel` as the `success` and `Ordering::Acquire` as the `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",null,null],[5,"atomic_cxchgweak_relaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::Relaxed` as both the `success` and `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",null,null],[5,"atomic_cxchgweak_failrelaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::SeqCst` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",null,null],[5,"atomic_cxchgweak_failacq","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::SeqCst` as the `success` and `Ordering::Acquire` as the `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",null,null],[5,"atomic_cxchgweak_acq_failrelaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::Acquire` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",null,null],[5,"atomic_cxchgweak_acqrel_failrelaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::AcqRel` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",null,null],[5,"atomic_load","","Loads the current value of the pointer. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `load` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::load`.",null,null],[5,"atomic_load_acq","","Loads the current value of the pointer. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `load` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicBool::load`.",null,null],[5,"atomic_load_relaxed","","Loads the current value of the pointer. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `load` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::load`.",null,null],[5,"atomic_load_unordered","","",null,null],[5,"atomic_store","","Stores the value at the specified memory location. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `store` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::store`.",null,null],[5,"atomic_store_rel","","Stores the value at the specified memory location. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `store` method by passing `Ordering::Release` as the `order`. For example, `AtomicBool::store`.",null,null],[5,"atomic_store_relaxed","","Stores the value at the specified memory location. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `store` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::store`.",null,null],[5,"atomic_store_unordered","","",null,null],[5,"atomic_xchg","","Stores the value at the specified memory location, returning the old value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `swap` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::swap`.",null,null],[5,"atomic_xchg_acq","","Stores the value at the specified memory location, returning the old value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `swap` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicBool::swap`.",null,null],[5,"atomic_xchg_rel","","Stores the value at the specified memory location, returning the old value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `swap` method by passing `Ordering::Release` as the `order`. For example, `AtomicBool::swap`.",null,null],[5,"atomic_xchg_acqrel","","Stores the value at the specified memory location, returning the old value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `swap` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicBool::swap`.",null,null],[5,"atomic_xchg_relaxed","","Stores the value at the specified memory location, returning the old value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `swap` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::swap`.",null,null],[5,"atomic_xadd","","Add to the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_add` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicIsize::fetch_add`.",null,null],[5,"atomic_xadd_acq","","Add to the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_add` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicIsize::fetch_add`.",null,null],[5,"atomic_xadd_rel","","Add to the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_add` method by passing `Ordering::Release` as the `order`. For example, `AtomicIsize::fetch_add`.",null,null],[5,"atomic_xadd_acqrel","","Add to the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_add` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicIsize::fetch_add`.",null,null],[5,"atomic_xadd_relaxed","","Add to the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_add` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicIsize::fetch_add`.",null,null],[5,"atomic_xsub","","Subtract from the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_sub` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicIsize::fetch_sub`.",null,null],[5,"atomic_xsub_acq","","Subtract from the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_sub` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicIsize::fetch_sub`.",null,null],[5,"atomic_xsub_rel","","Subtract from the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_sub` method by passing `Ordering::Release` as the `order`. For example, `AtomicIsize::fetch_sub`.",null,null],[5,"atomic_xsub_acqrel","","Subtract from the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_sub` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicIsize::fetch_sub`.",null,null],[5,"atomic_xsub_relaxed","","Subtract from the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_sub` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicIsize::fetch_sub`.",null,null],[5,"atomic_and","","Bitwise and with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_and` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::fetch_and`.",null,null],[5,"atomic_and_acq","","Bitwise and with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_and` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicBool::fetch_and`.",null,null],[5,"atomic_and_rel","","Bitwise and with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_and` method by passing `Ordering::Release` as the `order`. For example, `AtomicBool::fetch_and`.",null,null],[5,"atomic_and_acqrel","","Bitwise and with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_and` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicBool::fetch_and`.",null,null],[5,"atomic_and_relaxed","","Bitwise and with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_and` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::fetch_and`.",null,null],[5,"atomic_nand","","Bitwise nand with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic::AtomicBool` type via the `fetch_nand` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::fetch_nand`.",null,null],[5,"atomic_nand_acq","","Bitwise nand with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic::AtomicBool` type via the `fetch_nand` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicBool::fetch_nand`.",null,null],[5,"atomic_nand_rel","","Bitwise nand with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic::AtomicBool` type via the `fetch_nand` method by passing `Ordering::Release` as the `order`. For example, `AtomicBool::fetch_nand`.",null,null],[5,"atomic_nand_acqrel","","Bitwise nand with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic::AtomicBool` type via the `fetch_nand` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicBool::fetch_nand`.",null,null],[5,"atomic_nand_relaxed","","Bitwise nand with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic::AtomicBool` type via the `fetch_nand` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::fetch_nand`.",null,null],[5,"atomic_or","","Bitwise or with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_or` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::fetch_or`.",null,null],[5,"atomic_or_acq","","Bitwise or with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_or` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicBool::fetch_or`.",null,null],[5,"atomic_or_rel","","Bitwise or with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_or` method by passing `Ordering::Release` as the `order`. For example, `AtomicBool::fetch_or`.",null,null],[5,"atomic_or_acqrel","","Bitwise or with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_or` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicBool::fetch_or`.",null,null],[5,"atomic_or_relaxed","","Bitwise or with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_or` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::fetch_or`.",null,null],[5,"atomic_xor","","Bitwise xor with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_xor` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::fetch_xor`.",null,null],[5,"atomic_xor_acq","","Bitwise xor with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_xor` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicBool::fetch_xor`.",null,null],[5,"atomic_xor_rel","","Bitwise xor with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_xor` method by passing `Ordering::Release` as the `order`. For example, `AtomicBool::fetch_xor`.",null,null],[5,"atomic_xor_acqrel","","Bitwise xor with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_xor` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicBool::fetch_xor`.",null,null],[5,"atomic_xor_relaxed","","Bitwise xor with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_xor` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::fetch_xor`.",null,null],[5,"atomic_max","","",null,null],[5,"atomic_max_acq","","",null,null],[5,"atomic_max_rel","","",null,null],[5,"atomic_max_acqrel","","",null,null],[5,"atomic_max_relaxed","","",null,null],[5,"atomic_min","","",null,null],[5,"atomic_min_acq","","",null,null],[5,"atomic_min_rel","","",null,null],[5,"atomic_min_acqrel","","",null,null],[5,"atomic_min_relaxed","","",null,null],[5,"atomic_umin","","",null,null],[5,"atomic_umin_acq","","",null,null],[5,"atomic_umin_rel","","",null,null],[5,"atomic_umin_acqrel","","",null,null],[5,"atomic_umin_relaxed","","",null,null],[5,"atomic_umax","","",null,null],[5,"atomic_umax_acq","","",null,null],[5,"atomic_umax_rel","","",null,null],[5,"atomic_umax_acqrel","","",null,null],[5,"atomic_umax_relaxed","","",null,null],[5,"prefetch_read_data","","The `prefetch` intrinsic is a hint to the code generator to insert a prefetch instruction if supported; otherwise, it is a noop. Prefetches have no effect on the behavior of the program but can change its performance characteristics.",null,null],[5,"prefetch_write_data","","The `prefetch` intrinsic is a hint to the code generator to insert a prefetch instruction if supported; otherwise, it is a noop. Prefetches have no effect on the behavior of the program but can change its performance characteristics.",null,null],[5,"prefetch_read_instruction","","The `prefetch` intrinsic is a hint to the code generator to insert a prefetch instruction if supported; otherwise, it is a noop. Prefetches have no effect on the behavior of the program but can change its performance characteristics.",null,null],[5,"prefetch_write_instruction","","The `prefetch` intrinsic is a hint to the code generator to insert a prefetch instruction if supported; otherwise, it is a noop. Prefetches have no effect on the behavior of the program but can change its performance characteristics.",null,null],[5,"atomic_fence","","",null,null],[5,"atomic_fence_acq","","",null,null],[5,"atomic_fence_rel","","",null,null],[5,"atomic_fence_acqrel","","",null,null],[5,"atomic_singlethreadfence","","A compiler-only memory barrier.",null,null],[5,"atomic_singlethreadfence_acq","","",null,null],[5,"atomic_singlethreadfence_rel","","",null,null],[5,"atomic_singlethreadfence_acqrel","","",null,null],[5,"rustc_peek","","Magic intrinsic that derives its meaning from attributes attached to the function.",null,null],[5,"abort","","Aborts the execution of the process.",null,null],[5,"unreachable","","Tells LLVM that this point in the code is not reachable, enabling further optimizations.",null,null],[5,"assume","","Informs the optimizer that a condition is always true. If the condition is false, the behavior is undefined.",null,null],[5,"likely","","Hints to the compiler that branch condition is likely to be true. Returns the value passed to it.",null,null],[5,"unlikely","","Hints to the compiler that branch condition is likely to be false. Returns the value passed to it.",null,null],[5,"breakpoint","","Executes a breakpoint trap, for inspection by a debugger.",null,null],[5,"size_of","","The size of a type in bytes.",null,null],[5,"move_val_init","","Moves a value to an uninitialized memory location.",null,null],[5,"min_align_of","","",null,null],[5,"pref_align_of","","",null,null],[5,"size_of_val","","The size of the referenced value in bytes.",null,null],[5,"min_align_of_val","","",null,null],[5,"type_name","","Gets a static string slice containing the name of a type.",null,null],[5,"type_id","","Gets an identifier which is globally unique to the specified type. This function will return the same value for a type regardless of whichever crate it is invoked in.",null,null],[5,"init","","Creates a value initialized to zero.",null,null],[5,"uninit","","Creates an uninitialized value.",null,null],[5,"transmute","","Reinterprets the bits of a value of one type as another type.",null,null],[5,"needs_drop","","Returns `true` if the actual type given as `T` requires drop glue; returns `false` if the actual type provided for `T` implements `Copy`.",null,null],[5,"offset","","Calculates the offset from a pointer.",null,null],[5,"arith_offset","","Calculates the offset from a pointer, potentially wrapping.",null,null],[5,"copy_nonoverlapping","","Copies `count * size_of<T>` bytes from `src` to `dst`. The source and destination may not overlap.",null,null],[5,"copy","","Copies `count * size_of<T>` bytes from `src` to `dst`. The source and destination may overlap.",null,null],[5,"write_bytes","","Invokes memset on the specified pointer, setting `count * size_of::<T>()` bytes of memory starting at `dst` to `val`.",null,null],[5,"volatile_copy_nonoverlapping_memory","","Equivalent to the appropriate `llvm.memcpy.p0i8.0i8.*` intrinsic, with a size of `count` * `size_of::<T>()` and an alignment of `min_align_of::<T>()`",null,null],[5,"volatile_copy_memory","","Equivalent to the appropriate `llvm.memmove.p0i8.0i8.*` intrinsic, with a size of `count` * `size_of::<T>()` and an alignment of `min_align_of::<T>()`",null,null],[5,"volatile_set_memory","","Equivalent to the appropriate `llvm.memset.p0i8.*` intrinsic, with a size of `count` * `size_of::<T>()` and an alignment of `min_align_of::<T>()`.",null,null],[5,"volatile_load","","Perform a volatile load from the `src` pointer. The stabilized version of this intrinsic is `std::ptr::read_volatile`.",null,null],[5,"volatile_store","","Perform a volatile store to the `dst` pointer. The stabilized version of this intrinsic is `std::ptr::write_volatile`.",null,null],[5,"sqrtf32","","Returns the square root of an `f32`",null,null],[5,"sqrtf64","","Returns the square root of an `f64`",null,null],[5,"powif32","","Raises an `f32` to an integer power.",null,null],[5,"powif64","","Raises an `f64` to an integer power.",null,null],[5,"sinf32","","Returns the sine of an `f32`.",null,null],[5,"sinf64","","Returns the sine of an `f64`.",null,null],[5,"cosf32","","Returns the cosine of an `f32`.",null,null],[5,"cosf64","","Returns the cosine of an `f64`.",null,null],[5,"powf32","","Raises an `f32` to an `f32` power.",null,null],[5,"powf64","","Raises an `f64` to an `f64` power.",null,null],[5,"expf32","","Returns the exponential of an `f32`.",null,null],[5,"expf64","","Returns the exponential of an `f64`.",null,null],[5,"exp2f32","","Returns 2 raised to the power of an `f32`.",null,null],[5,"exp2f64","","Returns 2 raised to the power of an `f64`.",null,null],[5,"logf32","","Returns the natural logarithm of an `f32`.",null,null],[5,"logf64","","Returns the natural logarithm of an `f64`.",null,null],[5,"log10f32","","Returns the base 10 logarithm of an `f32`.",null,null],[5,"log10f64","","Returns the base 10 logarithm of an `f64`.",null,null],[5,"log2f32","","Returns the base 2 logarithm of an `f32`.",null,null],[5,"log2f64","","Returns the base 2 logarithm of an `f64`.",null,null],[5,"fmaf32","","Returns `a * b + c` for `f32` values.",null,null],[5,"fmaf64","","Returns `a * b + c` for `f64` values.",null,null],[5,"fabsf32","","Returns the absolute value of an `f32`.",null,null],[5,"fabsf64","","Returns the absolute value of an `f64`.",null,null],[5,"copysignf32","","Copies the sign from `y` to `x` for `f32` values.",null,null],[5,"copysignf64","","Copies the sign from `y` to `x` for `f64` values.",null,null],[5,"floorf32","","Returns the largest integer less than or equal to an `f32`.",null,null],[5,"floorf64","","Returns the largest integer less than or equal to an `f64`.",null,null],[5,"ceilf32","","Returns the smallest integer greater than or equal to an `f32`.",null,null],[5,"ceilf64","","Returns the smallest integer greater than or equal to an `f64`.",null,null],[5,"truncf32","","Returns the integer part of an `f32`.",null,null],[5,"truncf64","","Returns the integer part of an `f64`.",null,null],[5,"rintf32","","Returns the nearest integer to an `f32`. May raise an inexact floating-point exception if the argument is not an integer.",null,null],[5,"rintf64","","Returns the nearest integer to an `f64`. May raise an inexact floating-point exception if the argument is not an integer.",null,null],[5,"nearbyintf32","","Returns the nearest integer to an `f32`.",null,null],[5,"nearbyintf64","","Returns the nearest integer to an `f64`.",null,null],[5,"roundf32","","Returns the nearest integer to an `f32`. Rounds half-way cases away from zero.",null,null],[5,"roundf64","","Returns the nearest integer to an `f64`. Rounds half-way cases away from zero.",null,null],[5,"fadd_fast","","Float addition that allows optimizations based on algebraic rules. May assume inputs are finite.",null,null],[5,"fsub_fast","","Float subtraction that allows optimizations based on algebraic rules. May assume inputs are finite.",null,null],[5,"fmul_fast","","Float multiplication that allows optimizations based on algebraic rules. May assume inputs are finite.",null,null],[5,"fdiv_fast","","Float division that allows optimizations based on algebraic rules. May assume inputs are finite.",null,null],[5,"frem_fast","","Float remainder that allows optimizations based on algebraic rules. May assume inputs are finite.",null,null],[5,"ctpop","","Returns the number of bits set in an integer type `T`",null,null],[5,"ctlz","","Returns the number of leading unset bits (zeroes) in an integer type `T`.",null,null],[5,"ctlz_nonzero","","Like `ctlz`, but extra-unsafe as it returns `undef` when given an `x` with value `0`.",null,null],[5,"cttz","","Returns the number of trailing unset bits (zeroes) in an integer type `T`.",null,null],[5,"cttz_nonzero","","Like `cttz`, but extra-unsafe as it returns `undef` when given an `x` with value `0`.",null,null],[5,"bswap","","Reverses the bytes in an integer type `T`.",null,null],[5,"bitreverse","","Reverses the bits in an integer type `T`.",null,null],[5,"add_with_overflow","","Performs checked integer addition. The stabilized versions of this intrinsic are available on the integer primitives via the `overflowing_add` method. For example, `std::u32::overflowing_add`",null,null],[5,"sub_with_overflow","","Performs checked integer subtraction The stabilized versions of this intrinsic are available on the integer primitives via the `overflowing_sub` method. For example, `std::u32::overflowing_sub`",null,null],[5,"mul_with_overflow","","Performs checked integer multiplication The stabilized versions of this intrinsic are available on the integer primitives via the `overflowing_mul` method. For example, `std::u32::overflowing_mul`",null,null],[5,"exact_div","","Performs an exact division, resulting in undefined behavior where `x % y != 0` or `y == 0` or `x == T::min_value() && y == -1`",null,null],[5,"unchecked_div","","Performs an unchecked division, resulting in undefined behavior where y = 0 or x = `T::min_value()` and y = -1",null,null],[5,"unchecked_rem","","Returns the remainder of an unchecked division, resulting in undefined behavior where y = 0 or x = `T::min_value()` and y = -1",null,null],[5,"unchecked_shl","","Performs an unchecked left shift, resulting in undefined behavior when y < 0 or y >= N, where N is the width of T in bits.",null,null],[5,"unchecked_shr","","Performs an unchecked right shift, resulting in undefined behavior when y < 0 or y >= N, where N is the width of T in bits.",null,null],[5,"overflowing_add","","Returns (a + b) mod 2N, where N is the width of T in bits. The stabilized versions of this intrinsic are available on the integer primitives via the `wrapping_add` method. For example, `std::u32::wrapping_add`",null,null],[5,"overflowing_sub","","Returns (a - b) mod 2N, where N is the width of T in bits. The stabilized versions of this intrinsic are available on the integer primitives via the `wrapping_sub` method. For example, `std::u32::wrapping_sub`",null,null],[5,"overflowing_mul","","Returns (a * b) mod 2N, where N is the width of T in bits. The stabilized versions of this intrinsic are available on the integer primitives via the `wrapping_mul` method. For example, `std::u32::wrapping_mul`",null,null],[5,"discriminant_value","","Returns the value of the discriminant for the variant in 'v', cast to a `u64`; if `T` has no discriminant, returns 0.",null,null],[5,"try","","Rust's \"try catch\" construct which invokes the function pointer `f` with the data pointer `data`.",null,null],[5,"nontemporal_store","","Emits a `!nontemporal` store according to LLVM (see their docs). Probably will never become stable.",null,null],[0,"mem","core","Basic functions for dealing with memory.",null,null],[3,"Discriminant","core::mem","Opaque type representing the discriminant of an enum.",null,null],[3,"PinMut","","A pinned reference.",null,null],[19,"ManuallyDrop","","A wrapper to inhibit compiler from automatically calling `T`’s destructor.",null,null],[5,"forget","","Leaks a value: takes ownership and \"forgets\" about the value without running its destructor.",null,{"i":[{"n":"t"}]}],[5,"size_of","","Returns the size of a type in bytes.",null,{"o":{"n":"usize"}}],[5,"size_of_val","","Returns the size of the pointed-to value in bytes.",null,{"i":[{"n":"t"}],"o":{"n":"usize"}}],[5,"min_align_of","","Returns the [ABI]-required minimum alignment of a type.",null,{"o":{"n":"usize"}}],[5,"min_align_of_val","","Returns the [ABI]-required minimum alignment of the type of the value that `val` points to.",null,{"i":[{"n":"t"}],"o":{"n":"usize"}}],[5,"align_of","","Returns the [ABI]-required minimum alignment of a type.",null,{"o":{"n":"usize"}}],[5,"align_of_val","","Returns the [ABI]-required minimum alignment of the type of the value that `val` points to.",null,{"i":[{"n":"t"}],"o":{"n":"usize"}}],[5,"needs_drop","","Returns whether dropping values of type `T` matters.",null,{"o":{"n":"bool"}}],[5,"zeroed","","Creates a value whose bytes are all zero.",null,{"o":{"n":"t"}}],[5,"uninitialized","","Bypasses Rust's normal memory-initialization checks by pretending to produce a value of type `T`, while doing nothing at all.",null,{"o":{"n":"t"}}],[5,"swap","","Swaps the values at two mutable locations, without deinitializing either one.",null,{"i":[{"n":"t"},{"n":"t"}]}],[5,"replace","","Moves `src` into the referenced `dest`, returning the previous `dest` value.",null,{"i":[{"n":"t"},{"n":"t"}],"o":{"n":"t"}}],[5,"drop","","Disposes of a value.",null,{"i":[{"n":"t"}]}],[5,"transmute_copy","","Interprets `src` as having type `&U`, and then reads `src` without moving the contained value.",null,{"i":[{"n":"t"}],"o":{"n":"u"}}],[5,"discriminant","","Returns a value uniquely identifying the enum variant in `v`.",null,{"i":[{"n":"t"}],"o":{"n":"discriminant"}}],[11,"clone","","",11,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"eq","","",11,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"bool"}}],[11,"hash","","",11,{"i":[{"n":"self"},{"n":"h"}]}],[11,"fmt","","",11,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","Wrap a value to be manually dropped.",12,{"i":[{"n":"t"}],"o":{"n":"manuallydrop"}}],[11,"into_inner","","Extract the value from the ManuallyDrop container.",12,{"i":[{"n":"manuallydrop"}],"o":{"n":"t"}}],[11,"drop","","Manually drops the contained value.",12,{"i":[{"n":"manuallydrop"}]}],[11,"deref","","",12,null],[11,"deref_mut","","",12,null],[11,"fmt","","",12,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",12,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"clone_from","","",12,{"i":[{"n":"self"},{"n":"self"}]}],[11,"default","","",12,{"o":{"n":"self"}}],[11,"eq","","",12,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"bool"}}],[11,"ne","","",12,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"bool"}}],[11,"partial_cmp","","",12,{"i":[{"n":"self"},{"n":"self"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",12,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"bool"}}],[11,"le","","",12,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"bool"}}],[11,"gt","","",12,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"bool"}}],[11,"ge","","",12,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"bool"}}],[11,"cmp","","",12,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"ordering"}}],[11,"hash","","",12,{"i":[{"n":"self"},{"n":"h"}]}],[11,"new","","Construct a new `PinMut` around a reference to some data of a type that implements `Unpin`.",13,{"i":[{"n":"t"}],"o":{"n":"pinmut"}}],[11,"new_unchecked","","Construct a new `PinMut` around a reference to some data of a type that may or may not implement `Unpin`.",13,{"i":[{"n":"t"}],"o":{"n":"pinmut"}}],[11,"reborrow","","Reborrow a `PinMut` for a shorter lifetime.",13,{"i":[{"n":"self"}],"o":{"n":"pinmut"}}],[11,"get_mut","","Get a mutable reference to the data inside of this `PinMut`.",13,{"i":[{"n":"pinmut"}],"o":{"n":"t"}}],[11,"map","","Construct a new pin by mapping the interior value.",13,{"i":[{"n":"pinmut"},{"n":"f"}],"o":{"n":"pinmut"}}],[11,"set","","Assign a new value to the memory behind the pinned reference.",13,{"i":[{"n":"pinmut"},{"n":"t"}]}],[11,"deref","","",13,{"i":[{"n":"self"}],"o":{"n":"t"}}],[11,"deref_mut","","",13,{"i":[{"n":"self"}],"o":{"n":"t"}}],[11,"fmt","","",13,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",13,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",13,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[0,"ptr","core","Raw, unsafe pointers, `*const T`, and `*mut T`.",null,null],[3,"NonNull","core::ptr","`*mut T` but non-zero and covariant.",null,null],[5,"drop_in_place","","Executes the destructor (if any) of the pointed-to value.",null,null],[5,"null","","Creates a null raw pointer.",null,null],[5,"null_mut","","Creates a null mutable raw pointer.",null,null],[5,"swap","","Swaps the values at two mutable locations of the same type, without deinitializing either.",null,null],[5,"swap_nonoverlapping","","Swaps a sequence of values at two mutable locations of the same type.",null,null],[5,"replace","","Moves `src` into the pointed `dest`, returning the previous `dest` value.",null,null],[5,"read","","Reads the value from `src` without moving it. This leaves the memory in `src` unchanged.",null,null],[5,"read_unaligned","","Reads the value from `src` without moving it. This leaves the memory in `src` unchanged.",null,null],[5,"write","","Overwrites a memory location with the given value without reading or dropping the old value.",null,null],[5,"write_unaligned","","Overwrites a memory location with the given value without reading or dropping the old value.",null,null],[5,"read_volatile","","Performs a volatile read of the value from `src` without moving it. This leaves the memory in `src` unchanged.",null,null],[5,"write_volatile","","Performs a volatile write of a memory location with the given value without reading or dropping the old value.",null,null],[5,"eq","","Compare raw pointers for equality.",null,null],[11,"dangling","","Creates a new `NonNull` that is dangling, but well-aligned.",14,{"o":{"n":"self"}}],[11,"new_unchecked","","Creates a new `NonNull`.",14,null],[11,"new","","Creates a new `NonNull` if `ptr` is non-null.",14,null],[11,"as_ptr","","Acquires the underlying `*mut` pointer.",14,null],[11,"as_ref","","Dereferences the content.",14,{"i":[{"n":"self"}],"o":{"n":"t"}}],[11,"as_mut","","Mutably dereferences the content.",14,{"i":[{"n":"self"}],"o":{"n":"t"}}],[11,"cast","","Cast to a pointer of another type",14,{"i":[{"n":"self"}],"o":{"n":"nonnull"}}],[11,"clone","","",14,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"fmt","","",14,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",14,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"eq","","",14,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"bool"}}],[11,"cmp","","",14,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"ordering"}}],[11,"partial_cmp","","",14,{"i":[{"n":"self"},{"n":"self"}],"o":{"g":["ordering"],"n":"option"}}],[11,"hash","","",14,{"i":[{"n":"self"},{"n":"h"}]}],[11,"from","","",14,{"i":[{"n":"t"}],"o":{"n":"self"}}],[11,"from","","",14,{"i":[{"n":"t"}],"o":{"n":"self"}}],[0,"hint","core","Hints to compiler that affects how code should be emitted or optimized.",null,null],[5,"unreachable_unchecked","core::hint","Informs the compiler that this point in the code is not reachable, enabling further optimizations.",null,null],[0,"marker","core","Primitive traits and types representing basic properties of types.",null,null],[3,"PhantomData","core::marker","Zero-sized type used to mark things that \"act like\" they own a `T`.",null,null],[3,"Pinned","","A type which does not implement `Unpin`.",null,null],[8,"Send","","Types that can be transferred across thread boundaries.",null,null],[8,"Sized","","Types with a constant size known at compile time.",null,null],[8,"Unsize","","Types that can be \"unsized\" to a dynamically-sized type.",null,null],[8,"Copy","","Types whose values can be duplicated simply by copying bits.",null,null],[8,"Sync","","Types for which it is safe to share references between threads.",null,null],[8,"Unpin","","Types which can be moved out of a `PinMut`.",null,null],[11,"hash","","",15,{"i":[{"n":"self"},{"n":"h"}]}],[11,"eq","","",15,{"i":[{"n":"self"},{"n":"phantomdata"}],"o":{"n":"bool"}}],[11,"partial_cmp","","",15,{"i":[{"n":"self"},{"n":"phantomdata"}],"o":{"g":["ordering"],"n":"option"}}],[11,"cmp","","",15,{"i":[{"n":"self"},{"n":"phantomdata"}],"o":{"n":"ordering"}}],[11,"clone","","",15,{"i":[{"n":"self"}],"o":{"n":"phantomdata"}}],[11,"default","","",15,{"o":{"n":"phantomdata"}}],[11,"fmt","","",16,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",16,{"i":[{"n":"self"}],"o":{"n":"pinned"}}],[11,"eq","","",16,{"i":[{"n":"self"},{"n":"pinned"}],"o":{"n":"bool"}}],[11,"cmp","","",16,{"i":[{"n":"self"},{"n":"pinned"}],"o":{"n":"ordering"}}],[11,"partial_cmp","","",16,{"i":[{"n":"self"},{"n":"pinned"}],"o":{"g":["ordering"],"n":"option"}}],[11,"hash","","",16,null],[0,"ops","core","Overloadable operators.",null,null],[3,"Range","core::ops","A (half-open) range bounded inclusively below and exclusively above (`start..end`).",null,null],[12,"start","","The lower bound of the range (inclusive).",17,null],[12,"end","","The upper bound of the range (exclusive).",17,null],[3,"RangeFrom","","A range only bounded inclusively below (`start..`).",null,null],[12,"start","","The lower bound of the range (inclusive).",18,null],[3,"RangeFull","","An unbounded range (`..`).",null,null],[3,"RangeTo","","A range only bounded exclusively above (`..end`).",null,null],[12,"end","","The upper bound of the range (exclusive).",19,null],[3,"RangeInclusive","","An range bounded inclusively below and above (`start..=end`).",null,null],[3,"RangeToInclusive","","A range only bounded inclusively above (`..=end`).",null,null],[12,"end","","The upper bound of the range (inclusive)",20,null],[4,"Bound","","An endpoint of a range of keys.",null,null],[13,"Included","","An inclusive bound.",21,null],[13,"Excluded","","An exclusive bound.",21,null],[13,"Unbounded","","An infinite endpoint. Indicates that there is no bound in this direction.",21,null],[4,"GeneratorState","","The result of a generator resumption.",null,null],[13,"Yielded","","The generator suspended with a value.",22,null],[13,"Complete","","The generator completed with a return value.",22,null],[11,"clone","","",22,{"i":[{"n":"self"}],"o":{"n":"generatorstate"}}],[11,"eq","","",22,{"i":[{"n":"self"},{"n":"generatorstate"}],"o":{"n":"bool"}}],[11,"ne","","",22,{"i":[{"n":"self"},{"n":"generatorstate"}],"o":{"n":"bool"}}],[11,"partial_cmp","","",22,{"i":[{"n":"self"},{"n":"generatorstate"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",22,{"i":[{"n":"self"},{"n":"generatorstate"}],"o":{"n":"bool"}}],[11,"le","","",22,{"i":[{"n":"self"},{"n":"generatorstate"}],"o":{"n":"bool"}}],[11,"gt","","",22,{"i":[{"n":"self"},{"n":"generatorstate"}],"o":{"n":"bool"}}],[11,"ge","","",22,{"i":[{"n":"self"},{"n":"generatorstate"}],"o":{"n":"bool"}}],[11,"cmp","","",22,{"i":[{"n":"self"},{"n":"generatorstate"}],"o":{"n":"ordering"}}],[11,"fmt","","",22,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"hash","","",22,null],[11,"clone","","",23,{"i":[{"n":"self"}],"o":{"n":"rangefull"}}],[11,"eq","","",23,{"i":[{"n":"self"},{"n":"rangefull"}],"o":{"n":"bool"}}],[11,"hash","","",23,null],[11,"fmt","","",23,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",17,{"i":[{"n":"self"}],"o":{"n":"range"}}],[11,"eq","","",17,{"i":[{"n":"self"},{"n":"range"}],"o":{"n":"bool"}}],[11,"ne","","",17,{"i":[{"n":"self"},{"n":"range"}],"o":{"n":"bool"}}],[11,"hash","","",17,null],[11,"fmt","","",17,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"contains","","Returns `true` if `item` is contained in the range.",17,{"i":[{"n":"self"},{"n":"u"}],"o":{"n":"bool"}}],[11,"is_empty","","Returns `true` if the range contains no items.",17,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"clone","","",18,{"i":[{"n":"self"}],"o":{"n":"rangefrom"}}],[11,"eq","","",18,{"i":[{"n":"self"},{"n":"rangefrom"}],"o":{"n":"bool"}}],[11,"ne","","",18,{"i":[{"n":"self"},{"n":"rangefrom"}],"o":{"n":"bool"}}],[11,"hash","","",18,null],[11,"fmt","","",18,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"contains","","Returns `true` if `item` is contained in the range.",18,{"i":[{"n":"self"},{"n":"u"}],"o":{"n":"bool"}}],[11,"clone","","",19,{"i":[{"n":"self"}],"o":{"n":"rangeto"}}],[11,"eq","","",19,{"i":[{"n":"self"},{"n":"rangeto"}],"o":{"n":"bool"}}],[11,"ne","","",19,{"i":[{"n":"self"},{"n":"rangeto"}],"o":{"n":"bool"}}],[11,"hash","","",19,null],[11,"fmt","","",19,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"contains","","Returns `true` if `item` is contained in the range.",19,{"i":[{"n":"self"},{"n":"u"}],"o":{"n":"bool"}}],[11,"clone","","",24,{"i":[{"n":"self"}],"o":{"n":"rangeinclusive"}}],[11,"eq","","",24,{"i":[{"n":"self"},{"n":"rangeinclusive"}],"o":{"n":"bool"}}],[11,"ne","","",24,{"i":[{"n":"self"},{"n":"rangeinclusive"}],"o":{"n":"bool"}}],[11,"hash","","",24,null],[11,"new","","Creates a new inclusive range. Equivalent to writing `start..=end`.",24,{"i":[{"n":"idx"},{"n":"idx"}],"o":{"n":"self"}}],[11,"start","","Returns the lower bound of the range (inclusive).",24,{"i":[{"n":"self"}],"o":{"n":"idx"}}],[11,"end","","Returns the upper bound of the range (inclusive).",24,{"i":[{"n":"self"}],"o":{"n":"idx"}}],[11,"into_inner","","Destructures the `RangeInclusive` into (lower bound, upper (inclusive) bound).",24,null],[11,"fmt","","",24,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"contains","","Returns `true` if `item` is contained in the range.",24,{"i":[{"n":"self"},{"n":"u"}],"o":{"n":"bool"}}],[11,"is_empty","","Returns `true` if the range contains no items.",24,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"clone","","",20,{"i":[{"n":"self"}],"o":{"n":"rangetoinclusive"}}],[11,"eq","","",20,{"i":[{"n":"self"},{"n":"rangetoinclusive"}],"o":{"n":"bool"}}],[11,"ne","","",20,{"i":[{"n":"self"},{"n":"rangetoinclusive"}],"o":{"n":"bool"}}],[11,"hash","","",20,null],[11,"fmt","","",20,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"contains","","Returns `true` if `item` is contained in the range.",20,{"i":[{"n":"self"},{"n":"u"}],"o":{"n":"bool"}}],[11,"clone","","",21,{"i":[{"n":"self"}],"o":{"n":"bound"}}],[11,"fmt","","",21,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"hash","","",21,null],[11,"eq","","",21,{"i":[{"n":"self"},{"n":"bound"}],"o":{"n":"bool"}}],[11,"ne","","",21,{"i":[{"n":"self"},{"n":"bound"}],"o":{"n":"bool"}}],[11,"start_bound","","",23,{"i":[{"n":"self"}],"o":{"n":"bound"}}],[11,"end_bound","","",23,{"i":[{"n":"self"}],"o":{"n":"bound"}}],[11,"start_bound","","",18,{"i":[{"n":"self"}],"o":{"n":"bound"}}],[11,"end_bound","","",18,{"i":[{"n":"self"}],"o":{"n":"bound"}}],[11,"start_bound","","",19,{"i":[{"n":"self"}],"o":{"n":"bound"}}],[11,"end_bound","","",19,{"i":[{"n":"self"}],"o":{"n":"bound"}}],[11,"start_bound","","",17,{"i":[{"n":"self"}],"o":{"n":"bound"}}],[11,"end_bound","","",17,{"i":[{"n":"self"}],"o":{"n":"bound"}}],[11,"start_bound","","",24,{"i":[{"n":"self"}],"o":{"n":"bound"}}],[11,"end_bound","","",24,{"i":[{"n":"self"}],"o":{"n":"bound"}}],[11,"start_bound","","",20,{"i":[{"n":"self"}],"o":{"n":"bound"}}],[11,"end_bound","","",20,{"i":[{"n":"self"}],"o":{"n":"bound"}}],[11,"start_bound","","",18,{"i":[{"n":"self"}],"o":{"n":"bound"}}],[11,"end_bound","","",18,{"i":[{"n":"self"}],"o":{"n":"bound"}}],[11,"start_bound","","",19,{"i":[{"n":"self"}],"o":{"n":"bound"}}],[11,"end_bound","","",19,{"i":[{"n":"self"}],"o":{"n":"bound"}}],[11,"start_bound","","",17,{"i":[{"n":"self"}],"o":{"n":"bound"}}],[11,"end_bound","","",17,{"i":[{"n":"self"}],"o":{"n":"bound"}}],[11,"start_bound","","",24,{"i":[{"n":"self"}],"o":{"n":"bound"}}],[11,"end_bound","","",24,{"i":[{"n":"self"}],"o":{"n":"bound"}}],[11,"start_bound","","",20,{"i":[{"n":"self"}],"o":{"n":"bound"}}],[11,"end_bound","","",20,{"i":[{"n":"self"}],"o":{"n":"bound"}}],[8,"Add","","The addition operator `+`.",null,null],[16,"Output","","The resulting type after applying the `+` operator.",25,null],[10,"add","","Performs the `+` operation.",25,null],[8,"Sub","","The subtraction operator `-`.",null,null],[16,"Output","","The resulting type after applying the `-` operator.",26,null],[10,"sub","","Performs the `-` operation.",26,null],[8,"Mul","","The multiplication operator `*`.",null,null],[16,"Output","","The resulting type after applying the `*` operator.",27,null],[10,"mul","","Performs the `*` operation.",27,null],[8,"Div","","The division operator `/`.",null,null],[16,"Output","","The resulting type after applying the `/` operator.",28,null],[10,"div","","Performs the `/` operation.",28,null],[8,"Rem","","The remainder operator `%`.",null,null],[16,"Output","","The resulting type after applying the `%` operator.",29,null],[10,"rem","","Performs the `%` operation.",29,null],[8,"Neg","","The unary negation operator `-`.",null,null],[16,"Output","","The resulting type after applying the `-` operator.",30,null],[10,"neg","","Performs the unary `-` operation.",30,null],[8,"AddAssign","","The addition assignment operator `+=`.",null,null],[10,"add_assign","","Performs the `+=` operation.",31,{"i":[{"n":"self"},{"n":"rhs"}]}],[8,"SubAssign","","The subtraction assignment operator `-=`.",null,null],[10,"sub_assign","","Performs the `-=` operation.",32,{"i":[{"n":"self"},{"n":"rhs"}]}],[8,"MulAssign","","The multiplication assignment operator `*=`.",null,null],[10,"mul_assign","","Performs the `*=` operation.",33,{"i":[{"n":"self"},{"n":"rhs"}]}],[8,"DivAssign","","The division assignment operator `/=`.",null,null],[10,"div_assign","","Performs the `/=` operation.",34,{"i":[{"n":"self"},{"n":"rhs"}]}],[8,"RemAssign","","The remainder assignment operator `%=`.",null,null],[10,"rem_assign","","Performs the `%=` operation.",35,{"i":[{"n":"self"},{"n":"rhs"}]}],[8,"Not","","The unary logical negation operator `!`.",null,null],[16,"Output","","The resulting type after applying the `!` operator.",36,null],[10,"not","","Performs the unary `!` operation.",36,null],[8,"BitAnd","","The bitwise AND operator `&`.",null,null],[16,"Output","","The resulting type after applying the `&` operator.",37,null],[10,"bitand","","Performs the `&` operation.",37,null],[8,"BitOr","","The bitwise OR operator `|`.",null,null],[16,"Output","","The resulting type after applying the `|` operator.",38,null],[10,"bitor","","Performs the `|` operation.",38,null],[8,"BitXor","","The bitwise XOR operator `^`.",null,null],[16,"Output","","The resulting type after applying the `^` operator.",39,null],[10,"bitxor","","Performs the `^` operation.",39,null],[8,"Shl","","The left shift operator `<<`. Note that because this trait is implemented for all integer types with multiple right-hand-side types, Rust's type checker has special handling for `_ << _`, setting the result type for integer operations to the type of the left-hand-side operand. This means that though `a << b` and `a.shl(b)` are one and the same from an evaluation standpoint, they are different when it comes to type inference.",null,null],[16,"Output","","The resulting type after applying the `<<` operator.",40,null],[10,"shl","","Performs the `<<` operation.",40,null],[8,"Shr","","The right shift operator `>>`. Note that because this trait is implemented for all integer types with multiple right-hand-side types, Rust's type checker has special handling for `_ >> _`, setting the result type for integer operations to the type of the left-hand-side operand. This means that though `a >> b` and `a.shr(b)` are one and the same from an evaluation standpoint, they are different when it comes to type inference.",null,null],[16,"Output","","The resulting type after applying the `>>` operator.",41,null],[10,"shr","","Performs the `>>` operation.",41,null],[8,"BitAndAssign","","The bitwise AND assignment operator `&=`.",null,null],[10,"bitand_assign","","Performs the `&=` operation.",42,{"i":[{"n":"self"},{"n":"rhs"}]}],[8,"BitOrAssign","","The bitwise OR assignment operator `|=`.",null,null],[10,"bitor_assign","","Performs the `|=` operation.",43,{"i":[{"n":"self"},{"n":"rhs"}]}],[8,"BitXorAssign","","The bitwise XOR assignment operator `^=`.",null,null],[10,"bitxor_assign","","Performs the `^=` operation.",44,{"i":[{"n":"self"},{"n":"rhs"}]}],[8,"ShlAssign","","The left shift assignment operator `<<=`.",null,null],[10,"shl_assign","","Performs the `<<=` operation.",45,{"i":[{"n":"self"},{"n":"rhs"}]}],[8,"ShrAssign","","The right shift assignment operator `>>=`.",null,null],[10,"shr_assign","","Performs the `>>=` operation.",46,{"i":[{"n":"self"},{"n":"rhs"}]}],[8,"Deref","","Used for immutable dereferencing operations, like `*v`.",null,null],[16,"Target","","The resulting type after dereferencing.",47,null],[10,"deref","","Dereferences the value.",47,null],[8,"DerefMut","","Used for mutable dereferencing operations, like in `*v = 1;`.",null,null],[10,"deref_mut","","Mutably dereferences the value.",48,null],[8,"Drop","","Used to run some code when a value goes out of scope. This is sometimes called a 'destructor'.",null,null],[10,"drop","","Executes the destructor for this type.",49,{"i":[{"n":"self"}]}],[8,"Fn","","The version of the call operator that takes an immutable receiver.",null,null],[10,"call","","Performs the call operation.",50,null],[8,"FnMut","","The version of the call operator that takes a mutable receiver.",null,null],[10,"call_mut","","Performs the call operation.",51,null],[8,"FnOnce","","The version of the call operator that takes a by-value receiver.",null,null],[16,"Output","","The returned type after the call operator is used.",52,null],[10,"call_once","","Performs the call operation.",52,null],[8,"Index","","Used for indexing operations (`container[index]`) in immutable contexts.",null,null],[16,"Output","","The returned type after indexing.",53,null],[10,"index","","Performs the indexing (`container[index]`) operation.",53,null],[8,"IndexMut","","Used for indexing operations (`container[index]`) in mutable contexts.",null,null],[10,"index_mut","","Performs the mutable indexing (`container[index]`) operation.",54,null],[8,"RangeBounds","","`RangeBounds` is implemented by Rust's built-in range types, produced by range syntax like `..`, `a..`, `..b` or `c..d`.",null,null],[10,"start_bound","","Start index bound.",55,{"i":[{"n":"self"}],"o":{"n":"bound"}}],[10,"end_bound","","End index bound.",55,{"i":[{"n":"self"}],"o":{"n":"bound"}}],[11,"contains","","Returns `true` if `item` is contained in the range.",55,{"i":[{"n":"self"},{"n":"u"}],"o":{"n":"bool"}}],[8,"Try","","A trait for customizing the behavior of the `?` operator.",null,null],[16,"Ok","","The type of this value when viewed as successful.",56,null],[16,"Error","","The type of this value when viewed as failed.",56,null],[10,"into_result","","Applies the \"?\" operator. A return of `Ok(t)` means that the execution should continue normally, and the result of `?` is the value `t`. A return of `Err(e)` means that execution should branch to the innermost enclosing `catch`, or return from the function.",56,{"i":[{"n":"self"}],"o":{"n":"result"}}],[10,"from_error","","Wrap an error value to construct the composite result. For example, `Result::Err(x)` and `Result::from_error(x)` are equivalent.",56,null],[10,"from_ok","","Wrap an OK value to construct the composite result. For example, `Result::Ok(x)` and `Result::from_ok(x)` are equivalent.",56,null],[8,"Generator","","The trait implemented by builtin generator types.",null,null],[16,"Yield","","The type of value this generator yields.",57,null],[16,"Return","","The type of value this generator returns.",57,null],[10,"resume","","Resumes the execution of this generator.",57,{"i":[{"n":"self"}],"o":{"n":"generatorstate"}}],[8,"CoerceUnsized","","Trait that indicates that this is a pointer or a wrapper for one, where unsizing can be performed on the pointee.",null,null],[0,"cmp","core","Functionality for ordering and comparison.",null,null],[3,"Reverse","core::cmp","A helper struct for reverse ordering.",null,null],[12,"0","","",58,null],[4,"Ordering","","An `Ordering` is the result of a comparison between two values.",null,null],[13,"Less","","An ordering where a compared value is less [than another].",59,null],[13,"Equal","","An ordering where a compared value is equal [to another].",59,null],[13,"Greater","","An ordering where a compared value is greater [than another].",59,null],[5,"min","","Compares and returns the minimum of two values.",null,{"i":[{"n":"t"},{"n":"t"}],"o":{"n":"t"}}],[5,"max","","Compares and returns the maximum of two values.",null,{"i":[{"n":"t"},{"n":"t"}],"o":{"n":"t"}}],[8,"PartialEq","","Trait for equality comparisons which are partial equivalence relations.",null,null],[10,"eq","","This method tests for `self` and `other` values to be equal, and is used by `==`.",60,{"i":[{"n":"self"},{"n":"rhs"}],"o":{"n":"bool"}}],[11,"ne","","This method tests for `!=`.",60,{"i":[{"n":"self"},{"n":"rhs"}],"o":{"n":"bool"}}],[8,"Eq","","Trait for equality comparisons which are equivalence relations.",null,null],[8,"Ord","","Trait for types that form a total order.",null,null],[10,"cmp","","This method returns an `Ordering` between `self` and `other`.",61,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"ordering"}}],[11,"max","","Compares and returns the maximum of two values.",61,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"min","","Compares and returns the minimum of two values.",61,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[8,"PartialOrd","","Trait for values that can be compared for a sort-order.",null,null],[10,"partial_cmp","","This method returns an ordering between `self` and `other` values if one exists.",62,{"i":[{"n":"self"},{"n":"rhs"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","This method tests less than (for `self` and `other`) and is used by the `<` operator.",62,{"i":[{"n":"self"},{"n":"rhs"}],"o":{"n":"bool"}}],[11,"le","","This method tests less than or equal to (for `self` and `other`) and is used by the `<=` operator.",62,{"i":[{"n":"self"},{"n":"rhs"}],"o":{"n":"bool"}}],[11,"gt","","This method tests greater than (for `self` and `other`) and is used by the `>` operator.",62,{"i":[{"n":"self"},{"n":"rhs"}],"o":{"n":"bool"}}],[11,"ge","","This method tests greater than or equal to (for `self` and `other`) and is used by the `>=` operator.",62,{"i":[{"n":"self"},{"n":"rhs"}],"o":{"n":"bool"}}],[11,"clone","","",59,{"i":[{"n":"self"}],"o":{"n":"ordering"}}],[11,"eq","","",59,{"i":[{"n":"self"},{"n":"ordering"}],"o":{"n":"bool"}}],[11,"fmt","","",59,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"hash","","",59,null],[11,"reverse","","Reverses the `Ordering`.",59,{"i":[{"n":"self"}],"o":{"n":"ordering"}}],[11,"then","","Chains two orderings.",59,{"i":[{"n":"self"},{"n":"ordering"}],"o":{"n":"ordering"}}],[11,"then_with","","Chains the ordering with the given function.",59,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"ordering"}}],[11,"eq","","",58,{"i":[{"n":"self"},{"n":"reverse"}],"o":{"n":"bool"}}],[11,"ne","","",58,{"i":[{"n":"self"},{"n":"reverse"}],"o":{"n":"bool"}}],[11,"fmt","","",58,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",58,{"i":[{"n":"self"}],"o":{"n":"reverse"}}],[11,"default","","",58,{"o":{"n":"reverse"}}],[11,"hash","","",58,null],[11,"partial_cmp","","",58,{"i":[{"n":"self"},{"n":"reverse"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",58,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"bool"}}],[11,"le","","",58,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"bool"}}],[11,"ge","","",58,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"bool"}}],[11,"gt","","",58,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"bool"}}],[11,"cmp","","",58,{"i":[{"n":"self"},{"n":"reverse"}],"o":{"n":"ordering"}}],[11,"cmp","","",59,{"i":[{"n":"self"},{"n":"ordering"}],"o":{"n":"ordering"}}],[11,"partial_cmp","","",59,{"i":[{"n":"self"},{"n":"ordering"}],"o":{"g":["ordering"],"n":"option"}}],[0,"clone","core","The `Clone` trait for types that cannot be 'implicitly copied'.",null,null],[8,"Clone","core::clone","A common trait for the ability to explicitly duplicate an object.",null,null],[10,"clone","","Returns a copy of the value.",63,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"clone_from","","Performs copy-assignment from `source`.",63,{"i":[{"n":"self"},{"n":"self"}]}],[0,"default","core","The `Default` trait for types which may have meaningful default values.",null,null],[8,"Default","core::default","A trait for giving a type a useful default value.",null,null],[10,"default","","Returns the \"default value\" for a type.",64,{"o":{"n":"self"}}],[0,"convert","core","Traits for conversions between types.",null,null],[8,"AsRef","core::convert","A cheap reference-to-reference conversion. Used to convert a value to a reference value within generic code.",null,null],[10,"as_ref","","Performs the conversion.",65,{"i":[{"n":"self"}],"o":{"n":"t"}}],[8,"AsMut","","A cheap, mutable reference-to-mutable reference conversion.",null,null],[10,"as_mut","","Performs the conversion.",66,{"i":[{"n":"self"}],"o":{"n":"t"}}],[8,"Into","","A conversion that consumes `self`, which may or may not be expensive. The reciprocal of [`From`][From].",null,null],[10,"into","","Performs the conversion.",67,{"i":[{"n":"self"}],"o":{"n":"t"}}],[8,"From","","Simple and safe type conversions in to `Self`. It is the reciprocal of `Into`.",null,null],[10,"from","","Performs the conversion.",68,{"i":[{"n":"t"}],"o":{"n":"self"}}],[8,"TryInto","","An attempted conversion that consumes `self`, which may or may not be expensive.",null,null],[16,"Error","","The type returned in the event of a conversion error.",69,null],[10,"try_into","","Performs the conversion.",69,{"i":[{"n":"self"}],"o":{"n":"result"}}],[8,"TryFrom","","Attempt to construct `Self` via a conversion.",null,null],[16,"Error","","The type returned in the event of a conversion error.",70,null],[10,"try_from","","Performs the conversion.",70,{"i":[{"n":"t"}],"o":{"n":"result"}}],[0,"borrow","core","A module for working with borrowed data.",null,null],[8,"Borrow","core::borrow","A trait for borrowing data.",null,null],[10,"borrow","","Immutably borrows from an owned value.",71,{"i":[{"n":"self"}],"o":{"n":"borrowed"}}],[8,"BorrowMut","","A trait for mutably borrowing data.",null,null],[10,"borrow_mut","","Mutably borrows from an owned value.",72,{"i":[{"n":"self"}],"o":{"n":"borrowed"}}],[0,"any","core","This module implements the `Any` trait, which enables dynamic typing of any `'static` type through runtime reflection.",null,null],[3,"TypeId","core::any","A `TypeId` represents a globally unique identifier for a type.",null,null],[8,"Any","","A type to emulate dynamic typing.",null,null],[10,"get_type_id","","Gets the `TypeId` of `self`.",73,{"i":[{"n":"self"}],"o":{"n":"typeid"}}],[11,"fmt","","",73,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",73,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",73,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"is","","Returns `true` if the boxed type is the same as `T`.",73,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"downcast_ref","","Returns some reference to the boxed value if it is of type `T`, or `None` if it isn't.",73,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"downcast_mut","","Returns some mutable reference to the boxed value if it is of type `T`, or `None` if it isn't.",73,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"is","","Forwards to the method defined on the type `Any`.",73,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"downcast_ref","","Forwards to the method defined on the type `Any`.",73,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"downcast_mut","","Forwards to the method defined on the type `Any`.",73,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"is","","Forwards to the method defined on the type `Any`.",73,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"downcast_ref","","Forwards to the method defined on the type `Any`.",73,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"downcast_mut","","Forwards to the method defined on the type `Any`.",73,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"clone","","",74,{"i":[{"n":"self"}],"o":{"n":"typeid"}}],[11,"eq","","",74,{"i":[{"n":"self"},{"n":"typeid"}],"o":{"n":"bool"}}],[11,"ne","","",74,{"i":[{"n":"self"},{"n":"typeid"}],"o":{"n":"bool"}}],[11,"partial_cmp","","",74,{"i":[{"n":"self"},{"n":"typeid"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",74,{"i":[{"n":"self"},{"n":"typeid"}],"o":{"n":"bool"}}],[11,"le","","",74,{"i":[{"n":"self"},{"n":"typeid"}],"o":{"n":"bool"}}],[11,"gt","","",74,{"i":[{"n":"self"},{"n":"typeid"}],"o":{"n":"bool"}}],[11,"ge","","",74,{"i":[{"n":"self"},{"n":"typeid"}],"o":{"n":"bool"}}],[11,"cmp","","",74,{"i":[{"n":"self"},{"n":"typeid"}],"o":{"n":"ordering"}}],[11,"fmt","","",74,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"hash","","",74,null],[11,"of","","Returns the `TypeId` of the type this generic function has been instantiated with.",74,{"o":{"n":"typeid"}}],[0,"array","core","Implementations of things like `Eq` for fixed-length arrays up to a certain length. Eventually we should able to generalize to all lengths.",null,null],[3,"TryFromSliceError","core::array","The error type returned when a conversion from a slice to an array fails.",null,null],[8,"FixedSizeArray","","Utility trait implemented only on arrays of fixed size",null,null],[10,"as_slice","","Converts the array to immutable slice",75,null],[10,"as_mut_slice","","Converts the array to mutable slice",75,null],[11,"fmt","","",76,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",76,{"i":[{"n":"self"}],"o":{"n":"tryfromsliceerror"}}],[11,"fmt","","",76,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[0,"ascii","core","Operations on ASCII strings and characters.",null,null],[3,"EscapeDefault","core::ascii","An iterator over the escaped version of a byte.",null,null],[5,"escape_default","","Returns an iterator that produces an escaped version of a `u8`.",null,{"i":[{"n":"u8"}],"o":{"n":"escapedefault"}}],[11,"next","","",77,{"i":[{"n":"self"}],"o":{"g":["u8"],"n":"option"}}],[11,"size_hint","","",77,null],[11,"next_back","","",77,{"i":[{"n":"self"}],"o":{"g":["u8"],"n":"option"}}],[11,"fmt","","",77,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[0,"sync","core","Synchronization primitives",null,null],[0,"atomic","core::sync","Atomic types",null,null],[3,"AtomicBool","core::sync::atomic","A boolean type which can be safely shared between threads.",null,null],[3,"AtomicPtr","","A raw pointer type which can be safely shared between threads.",null,null],[3,"AtomicI8","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicU8","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicI16","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicU16","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicI32","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicU32","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicI64","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicU64","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicIsize","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicUsize","","An integer type which can be safely shared between threads.",null,null],[4,"Ordering","","Atomic memory orderings",null,null],[13,"Relaxed","","No ordering constraints, only atomic operations.",78,null],[13,"Release","","When coupled with a store, all previous writes become visible to the other threads that perform a load with [`Acquire`] ordering on the same value.",78,null],[13,"Acquire","","When coupled with a load, all subsequent loads will see data written before a store with [`Release`] ordering on the same value in other threads.",78,null],[13,"AcqRel","","Has the effects of both [`Acquire`] and [`Release`] together.",78,null],[13,"SeqCst","","Like `AcqRel` with the additional guarantee that all threads see all sequentially consistent operations in the same order.",78,null],[5,"spin_loop_hint","","Save power or switch hyperthreads in a busy-wait spin-loop.",null,{}],[5,"fence","","An atomic fence.",null,{"i":[{"n":"ordering"}]}],[5,"compiler_fence","","A compiler memory fence.",null,{"i":[{"n":"ordering"}]}],[17,"ATOMIC_BOOL_INIT","","An [`AtomicBool`] initialized to `false`.",null,null],[17,"ATOMIC_I8_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_U8_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_I16_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_U16_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_I32_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_U32_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_I64_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_U64_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_ISIZE_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_USIZE_INIT","","An atomic integer initialized to `0`.",null,null],[11,"default","","Creates an `AtomicBool` initialized to `false`.",79,{"o":{"n":"self"}}],[11,"default","","Creates a null `AtomicPtr<T>`.",80,{"o":{"n":"atomicptr"}}],[11,"clone","","",78,{"i":[{"n":"self"}],"o":{"n":"ordering"}}],[11,"fmt","","",78,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","Creates a new `AtomicBool`.",79,{"i":[{"n":"bool"}],"o":{"n":"atomicbool"}}],[11,"get_mut","","Returns a mutable reference to the underlying [`bool`].",79,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"into_inner","","Consumes the atomic and returns the contained value.",79,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"load","","Loads a value from the bool.",79,{"i":[{"n":"self"},{"n":"ordering"}],"o":{"n":"bool"}}],[11,"store","","Stores a value into the bool.",79,{"i":[{"n":"self"},{"n":"bool"},{"n":"ordering"}]}],[11,"swap","","Stores a value into the bool, returning the previous value.",79,{"i":[{"n":"self"},{"n":"bool"},{"n":"ordering"}],"o":{"n":"bool"}}],[11,"compare_and_swap","","Stores a value into the [`bool`] if the current value is the same as the `current` value.",79,{"i":[{"n":"self"},{"n":"bool"},{"n":"bool"},{"n":"ordering"}],"o":{"n":"bool"}}],[11,"compare_exchange","","Stores a value into the [`bool`] if the current value is the same as the `current` value.",79,{"i":[{"n":"self"},{"n":"bool"},{"n":"bool"},{"n":"ordering"},{"n":"ordering"}],"o":{"g":["bool","bool"],"n":"result"}}],[11,"compare_exchange_weak","","Stores a value into the [`bool`] if the current value is the same as the `current` value.",79,{"i":[{"n":"self"},{"n":"bool"},{"n":"bool"},{"n":"ordering"},{"n":"ordering"}],"o":{"g":["bool","bool"],"n":"result"}}],[11,"fetch_and","","Logical \"and\" with a boolean value.",79,{"i":[{"n":"self"},{"n":"bool"},{"n":"ordering"}],"o":{"n":"bool"}}],[11,"fetch_nand","","Logical \"nand\" with a boolean value.",79,{"i":[{"n":"self"},{"n":"bool"},{"n":"ordering"}],"o":{"n":"bool"}}],[11,"fetch_or","","Logical \"or\" with a boolean value.",79,{"i":[{"n":"self"},{"n":"bool"},{"n":"ordering"}],"o":{"n":"bool"}}],[11,"fetch_xor","","Logical \"xor\" with a boolean value.",79,{"i":[{"n":"self"},{"n":"bool"},{"n":"ordering"}],"o":{"n":"bool"}}],[11,"new","","Creates a new `AtomicPtr`.",80,null],[11,"get_mut","","Returns a mutable reference to the underlying pointer.",80,null],[11,"into_inner","","Consumes the atomic and returns the contained value.",80,null],[11,"load","","Loads a value from the pointer.",80,null],[11,"store","","Stores a value into the pointer.",80,null],[11,"swap","","Stores a value into the pointer, returning the previous value.",80,null],[11,"compare_and_swap","","Stores a value into the pointer if the current value is the same as the `current` value.",80,null],[11,"compare_exchange","","Stores a value into the pointer if the current value is the same as the `current` value.",80,null],[11,"compare_exchange_weak","","Stores a value into the pointer if the current value is the same as the `current` value.",80,null],[11,"from","","",79,{"i":[{"n":"bool"}],"o":{"n":"self"}}],[11,"from","","",80,null],[11,"default","","",81,{"o":{"n":"self"}}],[11,"from","","",81,{"i":[{"n":"i8"}],"o":{"n":"self"}}],[11,"fmt","","",81,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","Creates a new atomic integer.",81,{"i":[{"n":"i8"}],"o":{"n":"self"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",81,{"i":[{"n":"self"}],"o":{"n":"i8"}}],[11,"into_inner","","Consumes the atomic and returns the contained value.",81,{"i":[{"n":"self"}],"o":{"n":"i8"}}],[11,"load","","Loads a value from the atomic integer.",81,{"i":[{"n":"self"},{"n":"ordering"}],"o":{"n":"i8"}}],[11,"store","","Stores a value into the atomic integer.",81,{"i":[{"n":"self"},{"n":"i8"},{"n":"ordering"}]}],[11,"swap","","Stores a value into the atomic integer, returning the previous value.",81,{"i":[{"n":"self"},{"n":"i8"},{"n":"ordering"}],"o":{"n":"i8"}}],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",81,{"i":[{"n":"self"},{"n":"i8"},{"n":"i8"},{"n":"ordering"}],"o":{"n":"i8"}}],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",81,{"i":[{"n":"self"},{"n":"i8"},{"n":"i8"},{"n":"ordering"},{"n":"ordering"}],"o":{"g":["i8","i8"],"n":"result"}}],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",81,{"i":[{"n":"self"},{"n":"i8"},{"n":"i8"},{"n":"ordering"},{"n":"ordering"}],"o":{"g":["i8","i8"],"n":"result"}}],[11,"fetch_add","","Adds to the current value, returning the previous value.",81,{"i":[{"n":"self"},{"n":"i8"},{"n":"ordering"}],"o":{"n":"i8"}}],[11,"fetch_sub","","Subtracts from the current value, returning the previous value.",81,{"i":[{"n":"self"},{"n":"i8"},{"n":"ordering"}],"o":{"n":"i8"}}],[11,"fetch_and","","Bitwise \"and\" with the current value.",81,{"i":[{"n":"self"},{"n":"i8"},{"n":"ordering"}],"o":{"n":"i8"}}],[11,"fetch_nand","","Bitwise \"nand\" with the current value.",81,{"i":[{"n":"self"},{"n":"i8"},{"n":"ordering"}],"o":{"n":"i8"}}],[11,"fetch_or","","Bitwise \"or\" with the current value.",81,{"i":[{"n":"self"},{"n":"i8"},{"n":"ordering"}],"o":{"n":"i8"}}],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",81,{"i":[{"n":"self"},{"n":"i8"},{"n":"ordering"}],"o":{"n":"i8"}}],[11,"fetch_update","","Fetches the value, and applies a function to it that returns an optional new value. Returns a `Result` of `Ok(previous_value)` if the function returned `Some(_)`, else `Err(previous_value)`.",81,{"i":[{"n":"self"},{"n":"f"},{"n":"ordering"},{"n":"ordering"}],"o":{"g":["i8","i8"],"n":"result"}}],[11,"fetch_max","","Maximum with the current value.",81,{"i":[{"n":"self"},{"n":"i8"},{"n":"ordering"}],"o":{"n":"i8"}}],[11,"fetch_min","","Minimum with the current value.",81,{"i":[{"n":"self"},{"n":"i8"},{"n":"ordering"}],"o":{"n":"i8"}}],[11,"default","","",82,{"o":{"n":"self"}}],[11,"from","","",82,{"i":[{"n":"u8"}],"o":{"n":"self"}}],[11,"fmt","","",82,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","Creates a new atomic integer.",82,{"i":[{"n":"u8"}],"o":{"n":"self"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",82,{"i":[{"n":"self"}],"o":{"n":"u8"}}],[11,"into_inner","","Consumes the atomic and returns the contained value.",82,{"i":[{"n":"self"}],"o":{"n":"u8"}}],[11,"load","","Loads a value from the atomic integer.",82,{"i":[{"n":"self"},{"n":"ordering"}],"o":{"n":"u8"}}],[11,"store","","Stores a value into the atomic integer.",82,{"i":[{"n":"self"},{"n":"u8"},{"n":"ordering"}]}],[11,"swap","","Stores a value into the atomic integer, returning the previous value.",82,{"i":[{"n":"self"},{"n":"u8"},{"n":"ordering"}],"o":{"n":"u8"}}],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",82,{"i":[{"n":"self"},{"n":"u8"},{"n":"u8"},{"n":"ordering"}],"o":{"n":"u8"}}],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",82,{"i":[{"n":"self"},{"n":"u8"},{"n":"u8"},{"n":"ordering"},{"n":"ordering"}],"o":{"g":["u8","u8"],"n":"result"}}],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",82,{"i":[{"n":"self"},{"n":"u8"},{"n":"u8"},{"n":"ordering"},{"n":"ordering"}],"o":{"g":["u8","u8"],"n":"result"}}],[11,"fetch_add","","Adds to the current value, returning the previous value.",82,{"i":[{"n":"self"},{"n":"u8"},{"n":"ordering"}],"o":{"n":"u8"}}],[11,"fetch_sub","","Subtracts from the current value, returning the previous value.",82,{"i":[{"n":"self"},{"n":"u8"},{"n":"ordering"}],"o":{"n":"u8"}}],[11,"fetch_and","","Bitwise \"and\" with the current value.",82,{"i":[{"n":"self"},{"n":"u8"},{"n":"ordering"}],"o":{"n":"u8"}}],[11,"fetch_nand","","Bitwise \"nand\" with the current value.",82,{"i":[{"n":"self"},{"n":"u8"},{"n":"ordering"}],"o":{"n":"u8"}}],[11,"fetch_or","","Bitwise \"or\" with the current value.",82,{"i":[{"n":"self"},{"n":"u8"},{"n":"ordering"}],"o":{"n":"u8"}}],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",82,{"i":[{"n":"self"},{"n":"u8"},{"n":"ordering"}],"o":{"n":"u8"}}],[11,"fetch_update","","Fetches the value, and applies a function to it that returns an optional new value. Returns a `Result` of `Ok(previous_value)` if the function returned `Some(_)`, else `Err(previous_value)`.",82,{"i":[{"n":"self"},{"n":"f"},{"n":"ordering"},{"n":"ordering"}],"o":{"g":["u8","u8"],"n":"result"}}],[11,"fetch_max","","Maximum with the current value.",82,{"i":[{"n":"self"},{"n":"u8"},{"n":"ordering"}],"o":{"n":"u8"}}],[11,"fetch_min","","Minimum with the current value.",82,{"i":[{"n":"self"},{"n":"u8"},{"n":"ordering"}],"o":{"n":"u8"}}],[11,"default","","",83,{"o":{"n":"self"}}],[11,"from","","",83,{"i":[{"n":"i16"}],"o":{"n":"self"}}],[11,"fmt","","",83,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","Creates a new atomic integer.",83,{"i":[{"n":"i16"}],"o":{"n":"self"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",83,{"i":[{"n":"self"}],"o":{"n":"i16"}}],[11,"into_inner","","Consumes the atomic and returns the contained value.",83,{"i":[{"n":"self"}],"o":{"n":"i16"}}],[11,"load","","Loads a value from the atomic integer.",83,{"i":[{"n":"self"},{"n":"ordering"}],"o":{"n":"i16"}}],[11,"store","","Stores a value into the atomic integer.",83,{"i":[{"n":"self"},{"n":"i16"},{"n":"ordering"}]}],[11,"swap","","Stores a value into the atomic integer, returning the previous value.",83,{"i":[{"n":"self"},{"n":"i16"},{"n":"ordering"}],"o":{"n":"i16"}}],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",83,{"i":[{"n":"self"},{"n":"i16"},{"n":"i16"},{"n":"ordering"}],"o":{"n":"i16"}}],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",83,{"i":[{"n":"self"},{"n":"i16"},{"n":"i16"},{"n":"ordering"},{"n":"ordering"}],"o":{"g":["i16","i16"],"n":"result"}}],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",83,{"i":[{"n":"self"},{"n":"i16"},{"n":"i16"},{"n":"ordering"},{"n":"ordering"}],"o":{"g":["i16","i16"],"n":"result"}}],[11,"fetch_add","","Adds to the current value, returning the previous value.",83,{"i":[{"n":"self"},{"n":"i16"},{"n":"ordering"}],"o":{"n":"i16"}}],[11,"fetch_sub","","Subtracts from the current value, returning the previous value.",83,{"i":[{"n":"self"},{"n":"i16"},{"n":"ordering"}],"o":{"n":"i16"}}],[11,"fetch_and","","Bitwise \"and\" with the current value.",83,{"i":[{"n":"self"},{"n":"i16"},{"n":"ordering"}],"o":{"n":"i16"}}],[11,"fetch_nand","","Bitwise \"nand\" with the current value.",83,{"i":[{"n":"self"},{"n":"i16"},{"n":"ordering"}],"o":{"n":"i16"}}],[11,"fetch_or","","Bitwise \"or\" with the current value.",83,{"i":[{"n":"self"},{"n":"i16"},{"n":"ordering"}],"o":{"n":"i16"}}],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",83,{"i":[{"n":"self"},{"n":"i16"},{"n":"ordering"}],"o":{"n":"i16"}}],[11,"fetch_update","","Fetches the value, and applies a function to it that returns an optional new value. Returns a `Result` of `Ok(previous_value)` if the function returned `Some(_)`, else `Err(previous_value)`.",83,{"i":[{"n":"self"},{"n":"f"},{"n":"ordering"},{"n":"ordering"}],"o":{"g":["i16","i16"],"n":"result"}}],[11,"fetch_max","","Maximum with the current value.",83,{"i":[{"n":"self"},{"n":"i16"},{"n":"ordering"}],"o":{"n":"i16"}}],[11,"fetch_min","","Minimum with the current value.",83,{"i":[{"n":"self"},{"n":"i16"},{"n":"ordering"}],"o":{"n":"i16"}}],[11,"default","","",84,{"o":{"n":"self"}}],[11,"from","","",84,{"i":[{"n":"u16"}],"o":{"n":"self"}}],[11,"fmt","","",84,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","Creates a new atomic integer.",84,{"i":[{"n":"u16"}],"o":{"n":"self"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",84,{"i":[{"n":"self"}],"o":{"n":"u16"}}],[11,"into_inner","","Consumes the atomic and returns the contained value.",84,{"i":[{"n":"self"}],"o":{"n":"u16"}}],[11,"load","","Loads a value from the atomic integer.",84,{"i":[{"n":"self"},{"n":"ordering"}],"o":{"n":"u16"}}],[11,"store","","Stores a value into the atomic integer.",84,{"i":[{"n":"self"},{"n":"u16"},{"n":"ordering"}]}],[11,"swap","","Stores a value into the atomic integer, returning the previous value.",84,{"i":[{"n":"self"},{"n":"u16"},{"n":"ordering"}],"o":{"n":"u16"}}],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",84,{"i":[{"n":"self"},{"n":"u16"},{"n":"u16"},{"n":"ordering"}],"o":{"n":"u16"}}],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",84,{"i":[{"n":"self"},{"n":"u16"},{"n":"u16"},{"n":"ordering"},{"n":"ordering"}],"o":{"g":["u16","u16"],"n":"result"}}],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",84,{"i":[{"n":"self"},{"n":"u16"},{"n":"u16"},{"n":"ordering"},{"n":"ordering"}],"o":{"g":["u16","u16"],"n":"result"}}],[11,"fetch_add","","Adds to the current value, returning the previous value.",84,{"i":[{"n":"self"},{"n":"u16"},{"n":"ordering"}],"o":{"n":"u16"}}],[11,"fetch_sub","","Subtracts from the current value, returning the previous value.",84,{"i":[{"n":"self"},{"n":"u16"},{"n":"ordering"}],"o":{"n":"u16"}}],[11,"fetch_and","","Bitwise \"and\" with the current value.",84,{"i":[{"n":"self"},{"n":"u16"},{"n":"ordering"}],"o":{"n":"u16"}}],[11,"fetch_nand","","Bitwise \"nand\" with the current value.",84,{"i":[{"n":"self"},{"n":"u16"},{"n":"ordering"}],"o":{"n":"u16"}}],[11,"fetch_or","","Bitwise \"or\" with the current value.",84,{"i":[{"n":"self"},{"n":"u16"},{"n":"ordering"}],"o":{"n":"u16"}}],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",84,{"i":[{"n":"self"},{"n":"u16"},{"n":"ordering"}],"o":{"n":"u16"}}],[11,"fetch_update","","Fetches the value, and applies a function to it that returns an optional new value. Returns a `Result` of `Ok(previous_value)` if the function returned `Some(_)`, else `Err(previous_value)`.",84,{"i":[{"n":"self"},{"n":"f"},{"n":"ordering"},{"n":"ordering"}],"o":{"g":["u16","u16"],"n":"result"}}],[11,"fetch_max","","Maximum with the current value.",84,{"i":[{"n":"self"},{"n":"u16"},{"n":"ordering"}],"o":{"n":"u16"}}],[11,"fetch_min","","Minimum with the current value.",84,{"i":[{"n":"self"},{"n":"u16"},{"n":"ordering"}],"o":{"n":"u16"}}],[11,"default","","",85,{"o":{"n":"self"}}],[11,"from","","",85,{"i":[{"n":"i32"}],"o":{"n":"self"}}],[11,"fmt","","",85,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","Creates a new atomic integer.",85,{"i":[{"n":"i32"}],"o":{"n":"self"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",85,{"i":[{"n":"self"}],"o":{"n":"i32"}}],[11,"into_inner","","Consumes the atomic and returns the contained value.",85,{"i":[{"n":"self"}],"o":{"n":"i32"}}],[11,"load","","Loads a value from the atomic integer.",85,{"i":[{"n":"self"},{"n":"ordering"}],"o":{"n":"i32"}}],[11,"store","","Stores a value into the atomic integer.",85,{"i":[{"n":"self"},{"n":"i32"},{"n":"ordering"}]}],[11,"swap","","Stores a value into the atomic integer, returning the previous value.",85,{"i":[{"n":"self"},{"n":"i32"},{"n":"ordering"}],"o":{"n":"i32"}}],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",85,{"i":[{"n":"self"},{"n":"i32"},{"n":"i32"},{"n":"ordering"}],"o":{"n":"i32"}}],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",85,{"i":[{"n":"self"},{"n":"i32"},{"n":"i32"},{"n":"ordering"},{"n":"ordering"}],"o":{"g":["i32","i32"],"n":"result"}}],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",85,{"i":[{"n":"self"},{"n":"i32"},{"n":"i32"},{"n":"ordering"},{"n":"ordering"}],"o":{"g":["i32","i32"],"n":"result"}}],[11,"fetch_add","","Adds to the current value, returning the previous value.",85,{"i":[{"n":"self"},{"n":"i32"},{"n":"ordering"}],"o":{"n":"i32"}}],[11,"fetch_sub","","Subtracts from the current value, returning the previous value.",85,{"i":[{"n":"self"},{"n":"i32"},{"n":"ordering"}],"o":{"n":"i32"}}],[11,"fetch_and","","Bitwise \"and\" with the current value.",85,{"i":[{"n":"self"},{"n":"i32"},{"n":"ordering"}],"o":{"n":"i32"}}],[11,"fetch_nand","","Bitwise \"nand\" with the current value.",85,{"i":[{"n":"self"},{"n":"i32"},{"n":"ordering"}],"o":{"n":"i32"}}],[11,"fetch_or","","Bitwise \"or\" with the current value.",85,{"i":[{"n":"self"},{"n":"i32"},{"n":"ordering"}],"o":{"n":"i32"}}],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",85,{"i":[{"n":"self"},{"n":"i32"},{"n":"ordering"}],"o":{"n":"i32"}}],[11,"fetch_update","","Fetches the value, and applies a function to it that returns an optional new value. Returns a `Result` of `Ok(previous_value)` if the function returned `Some(_)`, else `Err(previous_value)`.",85,{"i":[{"n":"self"},{"n":"f"},{"n":"ordering"},{"n":"ordering"}],"o":{"g":["i32","i32"],"n":"result"}}],[11,"fetch_max","","Maximum with the current value.",85,{"i":[{"n":"self"},{"n":"i32"},{"n":"ordering"}],"o":{"n":"i32"}}],[11,"fetch_min","","Minimum with the current value.",85,{"i":[{"n":"self"},{"n":"i32"},{"n":"ordering"}],"o":{"n":"i32"}}],[11,"default","","",86,{"o":{"n":"self"}}],[11,"from","","",86,{"i":[{"n":"u32"}],"o":{"n":"self"}}],[11,"fmt","","",86,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","Creates a new atomic integer.",86,{"i":[{"n":"u32"}],"o":{"n":"self"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",86,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"into_inner","","Consumes the atomic and returns the contained value.",86,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"load","","Loads a value from the atomic integer.",86,{"i":[{"n":"self"},{"n":"ordering"}],"o":{"n":"u32"}}],[11,"store","","Stores a value into the atomic integer.",86,{"i":[{"n":"self"},{"n":"u32"},{"n":"ordering"}]}],[11,"swap","","Stores a value into the atomic integer, returning the previous value.",86,{"i":[{"n":"self"},{"n":"u32"},{"n":"ordering"}],"o":{"n":"u32"}}],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",86,{"i":[{"n":"self"},{"n":"u32"},{"n":"u32"},{"n":"ordering"}],"o":{"n":"u32"}}],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",86,{"i":[{"n":"self"},{"n":"u32"},{"n":"u32"},{"n":"ordering"},{"n":"ordering"}],"o":{"g":["u32","u32"],"n":"result"}}],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",86,{"i":[{"n":"self"},{"n":"u32"},{"n":"u32"},{"n":"ordering"},{"n":"ordering"}],"o":{"g":["u32","u32"],"n":"result"}}],[11,"fetch_add","","Adds to the current value, returning the previous value.",86,{"i":[{"n":"self"},{"n":"u32"},{"n":"ordering"}],"o":{"n":"u32"}}],[11,"fetch_sub","","Subtracts from the current value, returning the previous value.",86,{"i":[{"n":"self"},{"n":"u32"},{"n":"ordering"}],"o":{"n":"u32"}}],[11,"fetch_and","","Bitwise \"and\" with the current value.",86,{"i":[{"n":"self"},{"n":"u32"},{"n":"ordering"}],"o":{"n":"u32"}}],[11,"fetch_nand","","Bitwise \"nand\" with the current value.",86,{"i":[{"n":"self"},{"n":"u32"},{"n":"ordering"}],"o":{"n":"u32"}}],[11,"fetch_or","","Bitwise \"or\" with the current value.",86,{"i":[{"n":"self"},{"n":"u32"},{"n":"ordering"}],"o":{"n":"u32"}}],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",86,{"i":[{"n":"self"},{"n":"u32"},{"n":"ordering"}],"o":{"n":"u32"}}],[11,"fetch_update","","Fetches the value, and applies a function to it that returns an optional new value. Returns a `Result` of `Ok(previous_value)` if the function returned `Some(_)`, else `Err(previous_value)`.",86,{"i":[{"n":"self"},{"n":"f"},{"n":"ordering"},{"n":"ordering"}],"o":{"g":["u32","u32"],"n":"result"}}],[11,"fetch_max","","Maximum with the current value.",86,{"i":[{"n":"self"},{"n":"u32"},{"n":"ordering"}],"o":{"n":"u32"}}],[11,"fetch_min","","Minimum with the current value.",86,{"i":[{"n":"self"},{"n":"u32"},{"n":"ordering"}],"o":{"n":"u32"}}],[11,"default","","",87,{"o":{"n":"self"}}],[11,"from","","",87,{"i":[{"n":"i64"}],"o":{"n":"self"}}],[11,"fmt","","",87,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","Creates a new atomic integer.",87,{"i":[{"n":"i64"}],"o":{"n":"self"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",87,{"i":[{"n":"self"}],"o":{"n":"i64"}}],[11,"into_inner","","Consumes the atomic and returns the contained value.",87,{"i":[{"n":"self"}],"o":{"n":"i64"}}],[11,"load","","Loads a value from the atomic integer.",87,{"i":[{"n":"self"},{"n":"ordering"}],"o":{"n":"i64"}}],[11,"store","","Stores a value into the atomic integer.",87,{"i":[{"n":"self"},{"n":"i64"},{"n":"ordering"}]}],[11,"swap","","Stores a value into the atomic integer, returning the previous value.",87,{"i":[{"n":"self"},{"n":"i64"},{"n":"ordering"}],"o":{"n":"i64"}}],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",87,{"i":[{"n":"self"},{"n":"i64"},{"n":"i64"},{"n":"ordering"}],"o":{"n":"i64"}}],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",87,{"i":[{"n":"self"},{"n":"i64"},{"n":"i64"},{"n":"ordering"},{"n":"ordering"}],"o":{"g":["i64","i64"],"n":"result"}}],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",87,{"i":[{"n":"self"},{"n":"i64"},{"n":"i64"},{"n":"ordering"},{"n":"ordering"}],"o":{"g":["i64","i64"],"n":"result"}}],[11,"fetch_add","","Adds to the current value, returning the previous value.",87,{"i":[{"n":"self"},{"n":"i64"},{"n":"ordering"}],"o":{"n":"i64"}}],[11,"fetch_sub","","Subtracts from the current value, returning the previous value.",87,{"i":[{"n":"self"},{"n":"i64"},{"n":"ordering"}],"o":{"n":"i64"}}],[11,"fetch_and","","Bitwise \"and\" with the current value.",87,{"i":[{"n":"self"},{"n":"i64"},{"n":"ordering"}],"o":{"n":"i64"}}],[11,"fetch_nand","","Bitwise \"nand\" with the current value.",87,{"i":[{"n":"self"},{"n":"i64"},{"n":"ordering"}],"o":{"n":"i64"}}],[11,"fetch_or","","Bitwise \"or\" with the current value.",87,{"i":[{"n":"self"},{"n":"i64"},{"n":"ordering"}],"o":{"n":"i64"}}],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",87,{"i":[{"n":"self"},{"n":"i64"},{"n":"ordering"}],"o":{"n":"i64"}}],[11,"fetch_update","","Fetches the value, and applies a function to it that returns an optional new value. Returns a `Result` of `Ok(previous_value)` if the function returned `Some(_)`, else `Err(previous_value)`.",87,{"i":[{"n":"self"},{"n":"f"},{"n":"ordering"},{"n":"ordering"}],"o":{"g":["i64","i64"],"n":"result"}}],[11,"fetch_max","","Maximum with the current value.",87,{"i":[{"n":"self"},{"n":"i64"},{"n":"ordering"}],"o":{"n":"i64"}}],[11,"fetch_min","","Minimum with the current value.",87,{"i":[{"n":"self"},{"n":"i64"},{"n":"ordering"}],"o":{"n":"i64"}}],[11,"default","","",88,{"o":{"n":"self"}}],[11,"from","","",88,{"i":[{"n":"u64"}],"o":{"n":"self"}}],[11,"fmt","","",88,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","Creates a new atomic integer.",88,{"i":[{"n":"u64"}],"o":{"n":"self"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",88,{"i":[{"n":"self"}],"o":{"n":"u64"}}],[11,"into_inner","","Consumes the atomic and returns the contained value.",88,{"i":[{"n":"self"}],"o":{"n":"u64"}}],[11,"load","","Loads a value from the atomic integer.",88,{"i":[{"n":"self"},{"n":"ordering"}],"o":{"n":"u64"}}],[11,"store","","Stores a value into the atomic integer.",88,{"i":[{"n":"self"},{"n":"u64"},{"n":"ordering"}]}],[11,"swap","","Stores a value into the atomic integer, returning the previous value.",88,{"i":[{"n":"self"},{"n":"u64"},{"n":"ordering"}],"o":{"n":"u64"}}],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",88,{"i":[{"n":"self"},{"n":"u64"},{"n":"u64"},{"n":"ordering"}],"o":{"n":"u64"}}],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",88,{"i":[{"n":"self"},{"n":"u64"},{"n":"u64"},{"n":"ordering"},{"n":"ordering"}],"o":{"g":["u64","u64"],"n":"result"}}],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",88,{"i":[{"n":"self"},{"n":"u64"},{"n":"u64"},{"n":"ordering"},{"n":"ordering"}],"o":{"g":["u64","u64"],"n":"result"}}],[11,"fetch_add","","Adds to the current value, returning the previous value.",88,{"i":[{"n":"self"},{"n":"u64"},{"n":"ordering"}],"o":{"n":"u64"}}],[11,"fetch_sub","","Subtracts from the current value, returning the previous value.",88,{"i":[{"n":"self"},{"n":"u64"},{"n":"ordering"}],"o":{"n":"u64"}}],[11,"fetch_and","","Bitwise \"and\" with the current value.",88,{"i":[{"n":"self"},{"n":"u64"},{"n":"ordering"}],"o":{"n":"u64"}}],[11,"fetch_nand","","Bitwise \"nand\" with the current value.",88,{"i":[{"n":"self"},{"n":"u64"},{"n":"ordering"}],"o":{"n":"u64"}}],[11,"fetch_or","","Bitwise \"or\" with the current value.",88,{"i":[{"n":"self"},{"n":"u64"},{"n":"ordering"}],"o":{"n":"u64"}}],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",88,{"i":[{"n":"self"},{"n":"u64"},{"n":"ordering"}],"o":{"n":"u64"}}],[11,"fetch_update","","Fetches the value, and applies a function to it that returns an optional new value. Returns a `Result` of `Ok(previous_value)` if the function returned `Some(_)`, else `Err(previous_value)`.",88,{"i":[{"n":"self"},{"n":"f"},{"n":"ordering"},{"n":"ordering"}],"o":{"g":["u64","u64"],"n":"result"}}],[11,"fetch_max","","Maximum with the current value.",88,{"i":[{"n":"self"},{"n":"u64"},{"n":"ordering"}],"o":{"n":"u64"}}],[11,"fetch_min","","Minimum with the current value.",88,{"i":[{"n":"self"},{"n":"u64"},{"n":"ordering"}],"o":{"n":"u64"}}],[11,"default","","",89,{"o":{"n":"self"}}],[11,"from","","",89,{"i":[{"n":"isize"}],"o":{"n":"self"}}],[11,"fmt","","",89,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","Creates a new atomic integer.",89,{"i":[{"n":"isize"}],"o":{"n":"self"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",89,{"i":[{"n":"self"}],"o":{"n":"isize"}}],[11,"into_inner","","Consumes the atomic and returns the contained value.",89,{"i":[{"n":"self"}],"o":{"n":"isize"}}],[11,"load","","Loads a value from the atomic integer.",89,{"i":[{"n":"self"},{"n":"ordering"}],"o":{"n":"isize"}}],[11,"store","","Stores a value into the atomic integer.",89,{"i":[{"n":"self"},{"n":"isize"},{"n":"ordering"}]}],[11,"swap","","Stores a value into the atomic integer, returning the previous value.",89,{"i":[{"n":"self"},{"n":"isize"},{"n":"ordering"}],"o":{"n":"isize"}}],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",89,{"i":[{"n":"self"},{"n":"isize"},{"n":"isize"},{"n":"ordering"}],"o":{"n":"isize"}}],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",89,{"i":[{"n":"self"},{"n":"isize"},{"n":"isize"},{"n":"ordering"},{"n":"ordering"}],"o":{"g":["isize","isize"],"n":"result"}}],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",89,{"i":[{"n":"self"},{"n":"isize"},{"n":"isize"},{"n":"ordering"},{"n":"ordering"}],"o":{"g":["isize","isize"],"n":"result"}}],[11,"fetch_add","","Adds to the current value, returning the previous value.",89,{"i":[{"n":"self"},{"n":"isize"},{"n":"ordering"}],"o":{"n":"isize"}}],[11,"fetch_sub","","Subtracts from the current value, returning the previous value.",89,{"i":[{"n":"self"},{"n":"isize"},{"n":"ordering"}],"o":{"n":"isize"}}],[11,"fetch_and","","Bitwise \"and\" with the current value.",89,{"i":[{"n":"self"},{"n":"isize"},{"n":"ordering"}],"o":{"n":"isize"}}],[11,"fetch_nand","","Bitwise \"nand\" with the current value.",89,{"i":[{"n":"self"},{"n":"isize"},{"n":"ordering"}],"o":{"n":"isize"}}],[11,"fetch_or","","Bitwise \"or\" with the current value.",89,{"i":[{"n":"self"},{"n":"isize"},{"n":"ordering"}],"o":{"n":"isize"}}],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",89,{"i":[{"n":"self"},{"n":"isize"},{"n":"ordering"}],"o":{"n":"isize"}}],[11,"fetch_update","","Fetches the value, and applies a function to it that returns an optional new value. Returns a `Result` of `Ok(previous_value)` if the function returned `Some(_)`, else `Err(previous_value)`.",89,{"i":[{"n":"self"},{"n":"f"},{"n":"ordering"},{"n":"ordering"}],"o":{"g":["isize","isize"],"n":"result"}}],[11,"fetch_max","","Maximum with the current value.",89,{"i":[{"n":"self"},{"n":"isize"},{"n":"ordering"}],"o":{"n":"isize"}}],[11,"fetch_min","","Minimum with the current value.",89,{"i":[{"n":"self"},{"n":"isize"},{"n":"ordering"}],"o":{"n":"isize"}}],[11,"default","","",90,{"o":{"n":"self"}}],[11,"from","","",90,{"i":[{"n":"usize"}],"o":{"n":"self"}}],[11,"fmt","","",90,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","Creates a new atomic integer.",90,{"i":[{"n":"usize"}],"o":{"n":"self"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",90,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"into_inner","","Consumes the atomic and returns the contained value.",90,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"load","","Loads a value from the atomic integer.",90,{"i":[{"n":"self"},{"n":"ordering"}],"o":{"n":"usize"}}],[11,"store","","Stores a value into the atomic integer.",90,{"i":[{"n":"self"},{"n":"usize"},{"n":"ordering"}]}],[11,"swap","","Stores a value into the atomic integer, returning the previous value.",90,{"i":[{"n":"self"},{"n":"usize"},{"n":"ordering"}],"o":{"n":"usize"}}],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",90,{"i":[{"n":"self"},{"n":"usize"},{"n":"usize"},{"n":"ordering"}],"o":{"n":"usize"}}],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",90,{"i":[{"n":"self"},{"n":"usize"},{"n":"usize"},{"n":"ordering"},{"n":"ordering"}],"o":{"g":["usize","usize"],"n":"result"}}],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",90,{"i":[{"n":"self"},{"n":"usize"},{"n":"usize"},{"n":"ordering"},{"n":"ordering"}],"o":{"g":["usize","usize"],"n":"result"}}],[11,"fetch_add","","Adds to the current value, returning the previous value.",90,{"i":[{"n":"self"},{"n":"usize"},{"n":"ordering"}],"o":{"n":"usize"}}],[11,"fetch_sub","","Subtracts from the current value, returning the previous value.",90,{"i":[{"n":"self"},{"n":"usize"},{"n":"ordering"}],"o":{"n":"usize"}}],[11,"fetch_and","","Bitwise \"and\" with the current value.",90,{"i":[{"n":"self"},{"n":"usize"},{"n":"ordering"}],"o":{"n":"usize"}}],[11,"fetch_nand","","Bitwise \"nand\" with the current value.",90,{"i":[{"n":"self"},{"n":"usize"},{"n":"ordering"}],"o":{"n":"usize"}}],[11,"fetch_or","","Bitwise \"or\" with the current value.",90,{"i":[{"n":"self"},{"n":"usize"},{"n":"ordering"}],"o":{"n":"usize"}}],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",90,{"i":[{"n":"self"},{"n":"usize"},{"n":"ordering"}],"o":{"n":"usize"}}],[11,"fetch_update","","Fetches the value, and applies a function to it that returns an optional new value. Returns a `Result` of `Ok(previous_value)` if the function returned `Some(_)`, else `Err(previous_value)`.",90,{"i":[{"n":"self"},{"n":"f"},{"n":"ordering"},{"n":"ordering"}],"o":{"g":["usize","usize"],"n":"result"}}],[11,"fetch_max","","Maximum with the current value.",90,{"i":[{"n":"self"},{"n":"usize"},{"n":"ordering"}],"o":{"n":"usize"}}],[11,"fetch_min","","Minimum with the current value.",90,{"i":[{"n":"self"},{"n":"usize"},{"n":"ordering"}],"o":{"n":"usize"}}],[11,"fmt","","",79,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",80,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",80,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[0,"cell","core","Shareable mutable containers.",null,null],[3,"Cell","core::cell","A mutable memory location.",null,null],[3,"RefCell","","A mutable memory location with dynamically checked borrow rules",null,null],[3,"BorrowError","","An error returned by `RefCell::try_borrow`.",null,null],[3,"BorrowMutError","","An error returned by `RefCell::try_borrow_mut`.",null,null],[3,"Ref","","Wraps a borrowed reference to a value in a `RefCell` box. A wrapper type for an immutably borrowed value from a `RefCell<T>`.",null,null],[3,"RefMut","","A wrapper type for a mutably borrowed value from a `RefCell<T>`.",null,null],[3,"UnsafeCell","","The core primitive for interior mutability in Rust.",null,null],[11,"get","","Returns a copy of the contained value.",91,{"i":[{"n":"self"}],"o":{"n":"t"}}],[11,"update","","Updates the contained value using a function and returns the new value.",91,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"t"}}],[11,"clone","","",91,{"i":[{"n":"self"}],"o":{"n":"cell"}}],[11,"default","","Creates a `Cell<T>`, with the `Default` value for T.",91,{"o":{"n":"cell"}}],[11,"eq","","",91,{"i":[{"n":"self"},{"n":"cell"}],"o":{"n":"bool"}}],[11,"partial_cmp","","",91,{"i":[{"n":"self"},{"n":"cell"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",91,{"i":[{"n":"self"},{"n":"cell"}],"o":{"n":"bool"}}],[11,"le","","",91,{"i":[{"n":"self"},{"n":"cell"}],"o":{"n":"bool"}}],[11,"gt","","",91,{"i":[{"n":"self"},{"n":"cell"}],"o":{"n":"bool"}}],[11,"ge","","",91,{"i":[{"n":"self"},{"n":"cell"}],"o":{"n":"bool"}}],[11,"cmp","","",91,{"i":[{"n":"self"},{"n":"cell"}],"o":{"n":"ordering"}}],[11,"from","","",91,{"i":[{"n":"t"}],"o":{"n":"cell"}}],[11,"new","","Creates a new `Cell` containing the given value.",91,{"i":[{"n":"t"}],"o":{"n":"cell"}}],[11,"as_ptr","","Returns a raw pointer to the underlying data in this cell.",91,null],[11,"get_mut","","Returns a mutable reference to the underlying data.",91,{"i":[{"n":"self"}],"o":{"n":"t"}}],[11,"set","","Sets the contained value.",91,{"i":[{"n":"self"},{"n":"t"}]}],[11,"swap","","Swaps the values of two Cells. Difference with `std::mem::swap` is that this function doesn't require `&mut` reference.",91,{"i":[{"n":"self"},{"n":"self"}]}],[11,"replace","","Replaces the contained value, and returns it.",91,{"i":[{"n":"self"},{"n":"t"}],"o":{"n":"t"}}],[11,"into_inner","","Unwraps the value.",91,{"i":[{"n":"self"}],"o":{"n":"t"}}],[11,"take","","Takes the value of the cell, leaving `Default::default()` in its place.",91,{"i":[{"n":"self"}],"o":{"n":"t"}}],[11,"fmt","","",92,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",92,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",93,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",93,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","Creates a new `RefCell` containing `value`.",94,{"i":[{"n":"t"}],"o":{"n":"refcell"}}],[11,"into_inner","","Consumes the `RefCell`, returning the wrapped value.",94,{"i":[{"n":"self"}],"o":{"n":"t"}}],[11,"replace","","Replaces the wrapped value with a new one, returning the old value, without deinitializing either one.",94,{"i":[{"n":"self"},{"n":"t"}],"o":{"n":"t"}}],[11,"replace_with","","Replaces the wrapped value with a new one computed from `f`, returning the old value, without deinitializing either one.",94,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"t"}}],[11,"swap","","Swaps the wrapped value of `self` with the wrapped value of `other`, without deinitializing either one.",94,{"i":[{"n":"self"},{"n":"self"}]}],[11,"borrow","","Immutably borrows the wrapped value.",94,{"i":[{"n":"self"}],"o":{"n":"ref"}}],[11,"try_borrow","","Immutably borrows the wrapped value, returning an error if the value is currently mutably borrowed.",94,{"i":[{"n":"self"}],"o":{"g":["ref","borrowerror"],"n":"result"}}],[11,"borrow_mut","","Mutably borrows the wrapped value.",94,{"i":[{"n":"self"}],"o":{"n":"refmut"}}],[11,"try_borrow_mut","","Mutably borrows the wrapped value, returning an error if the value is currently borrowed.",94,{"i":[{"n":"self"}],"o":{"g":["refmut","borrowmuterror"],"n":"result"}}],[11,"as_ptr","","Returns a raw pointer to the underlying data in this cell.",94,null],[11,"get_mut","","Returns a mutable reference to the underlying data.",94,{"i":[{"n":"self"}],"o":{"n":"t"}}],[11,"clone","","Panics",94,{"i":[{"n":"self"}],"o":{"n":"refcell"}}],[11,"default","","Creates a `RefCell<T>`, with the `Default` value for T.",94,{"o":{"n":"refcell"}}],[11,"eq","","Panics",94,{"i":[{"n":"self"},{"n":"refcell"}],"o":{"n":"bool"}}],[11,"partial_cmp","","Panics",94,{"i":[{"n":"self"},{"n":"refcell"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","Panics",94,{"i":[{"n":"self"},{"n":"refcell"}],"o":{"n":"bool"}}],[11,"le","","Panics",94,{"i":[{"n":"self"},{"n":"refcell"}],"o":{"n":"bool"}}],[11,"gt","","Panics",94,{"i":[{"n":"self"},{"n":"refcell"}],"o":{"n":"bool"}}],[11,"ge","","Panics",94,{"i":[{"n":"self"},{"n":"refcell"}],"o":{"n":"bool"}}],[11,"cmp","","Panics",94,{"i":[{"n":"self"},{"n":"refcell"}],"o":{"n":"ordering"}}],[11,"from","","",94,{"i":[{"n":"t"}],"o":{"n":"refcell"}}],[11,"deref","","",95,{"i":[{"n":"self"}],"o":{"n":"t"}}],[11,"clone","","Copies a `Ref`.",95,{"i":[{"n":"ref"}],"o":{"n":"ref"}}],[11,"map","","Make a new `Ref` for a component of the borrowed data.",95,{"i":[{"n":"ref"},{"n":"f"}],"o":{"n":"ref"}}],[11,"map_split","","Split a `Ref` into multiple `Ref`s for different components of the borrowed data.",95,null],[11,"fmt","","",95,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"map","","Make a new `RefMut` for a component of the borrowed data, e.g. an enum variant.",96,{"i":[{"n":"refmut"},{"n":"f"}],"o":{"n":"refmut"}}],[11,"map_split","","Split a `RefMut` into multiple `RefMut`s for different components of the borrowed data.",96,null],[11,"deref","","",96,{"i":[{"n":"self"}],"o":{"n":"t"}}],[11,"deref_mut","","",96,{"i":[{"n":"self"}],"o":{"n":"t"}}],[11,"fmt","","",96,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","Constructs a new instance of `UnsafeCell` which will wrap the specified value.",97,{"i":[{"n":"t"}],"o":{"n":"unsafecell"}}],[11,"into_inner","","Unwraps the value.",97,{"i":[{"n":"self"}],"o":{"n":"t"}}],[11,"get","","Gets a mutable pointer to the wrapped value.",97,null],[11,"default","","Creates an `UnsafeCell`, with the `Default` value for T.",97,{"o":{"n":"unsafecell"}}],[11,"from","","",97,{"i":[{"n":"t"}],"o":{"n":"unsafecell"}}],[0,"char","core","A character type.",null,null],[3,"ParseCharError","core::char","An error which can be returned when parsing a char.",null,null],[3,"CharTryFromError","","The error type returned when a conversion from u32 to char fails.",null,null],[3,"DecodeUtf16","","An iterator that decodes UTF-16 encoded code points from an iterator of `u16`s.",null,null],[3,"DecodeUtf16Error","","An error that can be returned when decoding UTF-16 code points.",null,null],[3,"UnicodeVersion","","Represents a Unicode Version.",null,null],[12,"major","","Major version.",98,null],[12,"minor","","Minor version.",98,null],[12,"micro","","Micro (or Update) version.",98,null],[3,"DecodeUtf8","","An iterator over an iterator of bytes of the characters the bytes represent as UTF-8",null,null],[3,"InvalidSequence","","`<DecodeUtf8 as Iterator>::next` returns this for an invalid input sequence.",null,null],[3,"EscapeUnicode","","Returns an iterator that yields the hexadecimal Unicode escape of a character, as `char`s.",null,null],[3,"EscapeDefault","","An iterator that yields the literal escape code of a `char`.",null,null],[3,"EscapeDebug","","An iterator that yields the literal escape code of a `char`.",null,null],[3,"ToLowercase","","Returns an iterator that yields the lowercase equivalent of a `char`.",null,null],[3,"ToUppercase","","Returns an iterator that yields the uppercase equivalent of a `char`.",null,null],[5,"from_u32","","Converts a `u32` to a `char`.",null,{"i":[{"n":"u32"}],"o":{"g":["char"],"n":"option"}}],[5,"from_digit","","Converts a digit in the given radix to a `char`.",null,{"i":[{"n":"u32"},{"n":"u32"}],"o":{"g":["char"],"n":"option"}}],[5,"from_u32_unchecked","","Converts a `u32` to a `char`, ignoring validity.",null,{"i":[{"n":"u32"}],"o":{"n":"char"}}],[5,"decode_utf16","","Create an iterator over the UTF-16 encoded code points in `iter`, returning unpaired surrogates as `Err`s.",null,{"i":[{"n":"i"}],"o":{"n":"decodeutf16"}}],[5,"decode_utf8","","Decodes an `Iterator` of bytes as UTF-8.",null,{"i":[{"n":"i"}],"o":{"n":"decodeutf8"}}],[11,"clone","","",99,{"i":[{"n":"self"}],"o":{"n":"parsecharerror"}}],[11,"fmt","","",99,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"eq","","",99,{"i":[{"n":"self"},{"n":"parsecharerror"}],"o":{"n":"bool"}}],[11,"ne","","",99,{"i":[{"n":"self"},{"n":"parsecharerror"}],"o":{"n":"bool"}}],[11,"fmt","","",99,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",100,{"i":[{"n":"self"}],"o":{"n":"chartryfromerror"}}],[11,"fmt","","",100,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"eq","","",100,{"i":[{"n":"self"},{"n":"chartryfromerror"}],"o":{"n":"bool"}}],[11,"ne","","",100,{"i":[{"n":"self"},{"n":"chartryfromerror"}],"o":{"n":"bool"}}],[11,"fmt","","",100,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",101,{"i":[{"n":"self"}],"o":{"n":"decodeutf8"}}],[11,"fmt","","",101,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"eq","","",102,{"i":[{"n":"self"},{"n":"invalidsequence"}],"o":{"n":"bool"}}],[11,"ne","","",102,{"i":[{"n":"self"},{"n":"invalidsequence"}],"o":{"n":"bool"}}],[11,"fmt","","",102,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",101,{"i":[{"n":"self"}],"o":{"g":["result"],"n":"option"}}],[11,"size_hint","","",101,null],[11,"clone","","",103,{"i":[{"n":"self"}],"o":{"n":"decodeutf16"}}],[11,"fmt","","",103,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",104,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",104,{"i":[{"n":"self"}],"o":{"n":"decodeutf16error"}}],[11,"eq","","",104,{"i":[{"n":"self"},{"n":"decodeutf16error"}],"o":{"n":"bool"}}],[11,"ne","","",104,{"i":[{"n":"self"},{"n":"decodeutf16error"}],"o":{"n":"bool"}}],[11,"next","","",103,{"i":[{"n":"self"}],"o":{"g":["result"],"n":"option"}}],[11,"size_hint","","",103,null],[11,"unpaired_surrogate","","Returns the unpaired surrogate which caused this error.",104,{"i":[{"n":"self"}],"o":{"n":"u16"}}],[11,"fmt","","",104,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[17,"UNICODE_VERSION","","The version of Unicode that the Unicode parts of `char` and `str` methods are based on.",null,null],[17,"MAX","","The highest valid code point a `char` can have.",null,null],[17,"REPLACEMENT_CHARACTER","","`U+FFFD REPLACEMENT CHARACTER` (�) is used in Unicode to represent a decoding error.",null,null],[11,"clone","","",105,{"i":[{"n":"self"}],"o":{"n":"escapeunicode"}}],[11,"fmt","","",105,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",105,{"i":[{"n":"self"}],"o":{"g":["char"],"n":"option"}}],[11,"size_hint","","",105,null],[11,"count","","",105,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"last","","",105,{"i":[{"n":"self"}],"o":{"g":["char"],"n":"option"}}],[11,"len","","",105,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"fmt","","",105,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",106,{"i":[{"n":"self"}],"o":{"n":"escapedefault"}}],[11,"fmt","","",106,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",106,{"i":[{"n":"self"}],"o":{"g":["char"],"n":"option"}}],[11,"size_hint","","",106,null],[11,"count","","",106,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"nth","","",106,{"i":[{"n":"self"},{"n":"usize"}],"o":{"g":["char"],"n":"option"}}],[11,"last","","",106,{"i":[{"n":"self"}],"o":{"g":["char"],"n":"option"}}],[11,"len","","",106,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"fmt","","",106,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",107,{"i":[{"n":"self"}],"o":{"n":"escapedebug"}}],[11,"fmt","","",107,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",107,{"i":[{"n":"self"}],"o":{"g":["char"],"n":"option"}}],[11,"size_hint","","",107,null],[11,"fmt","","",107,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",108,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",108,{"i":[{"n":"self"}],"o":{"n":"tolowercase"}}],[11,"next","","",108,{"i":[{"n":"self"}],"o":{"g":["char"],"n":"option"}}],[11,"fmt","","",109,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",109,{"i":[{"n":"self"}],"o":{"n":"touppercase"}}],[11,"next","","",109,{"i":[{"n":"self"}],"o":{"g":["char"],"n":"option"}}],[11,"fmt","","",108,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",109,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[0,"panic","core","Panic support in the standard library.",null,null],[3,"PanicInfo","core::panic","A struct providing information about a panic.",null,null],[3,"Location","","A struct containing information about the location of a panic.",null,null],[11,"fmt","","",110,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"payload","","Returns the payload associated with the panic.",110,{"i":[{"n":"self"}],"o":{"n":"any"}}],[11,"message","","If the `panic!` macro from the `core` crate (not from `std`) was used with a formatting string and some additional arguments, returns that message ready to be used for example with [`fmt::write`]",110,{"i":[{"n":"self"}],"o":{"g":["arguments"],"n":"option"}}],[11,"location","","Returns information about the location from which the panic originated, if available.",110,{"i":[{"n":"self"}],"o":{"g":["location"],"n":"option"}}],[11,"fmt","","",110,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",111,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"file","","Returns the name of the source file from which the panic originated.",111,{"i":[{"n":"self"}],"o":{"n":"str"}}],[11,"line","","Returns the line number from which the panic originated.",111,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"column","","Returns the column from which the panic originated.",111,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"fmt","","",111,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[0,"panicking","core","Panic support for libcore",null,null],[5,"panic","core::panicking","",null,null],[5,"panic_fmt","","",null,null],[0,"iter","core","Composable external iteration.",null,null],[3,"Repeat","core::iter","An iterator that repeats an element endlessly.",null,null],[3,"RepeatWith","","An iterator that repeats elements of type `A` endlessly by applying the provided closure `F: FnMut() -> A`.",null,null],[3,"Empty","","An iterator that yields nothing.",null,null],[3,"Once","","An iterator that yields an element exactly once.",null,null],[3,"Rev","","A double-ended iterator with the direction inverted.",null,null],[3,"Cloned","","An iterator that clones the elements of an underlying iterator.",null,null],[3,"Cycle","","An iterator that repeats endlessly.",null,null],[3,"StepBy","","An iterator for stepping iterators by a custom amount.",null,null],[3,"Chain","","An iterator that strings two iterators together.",null,null],[3,"Zip","","An iterator that iterates two other iterators simultaneously.",null,null],[3,"Map","","An iterator that maps the values of `iter` with `f`.",null,null],[3,"Filter","","An iterator that filters the elements of `iter` with `predicate`.",null,null],[3,"FilterMap","","An iterator that uses `f` to both filter and map elements from `iter`.",null,null],[3,"Enumerate","","An iterator that yields the current count and the element during iteration.",null,null],[3,"Peekable","","An iterator with a `peek()` that returns an optional reference to the next element.",null,null],[3,"SkipWhile","","An iterator that rejects elements while `predicate` is true.",null,null],[3,"TakeWhile","","An iterator that only accepts elements while `predicate` is true.",null,null],[3,"Skip","","An iterator that skips over `n` elements of `iter`.",null,null],[3,"Take","","An iterator that only iterates over the first `n` iterations of `iter`.",null,null],[3,"Scan","","An iterator to maintain state while iterating another iterator.",null,null],[3,"FlatMap","","An iterator that maps each element to an iterator, and yields the elements of the produced iterators.",null,null],[3,"Flatten","","An iterator that flattens one level of nesting in an iterator of things that can be turned into iterators.",null,null],[3,"Fuse","","An iterator that yields `None` forever after the underlying iterator yields `None` once.",null,null],[3,"Inspect","","An iterator that calls a function with a reference to each element before yielding it.",null,null],[5,"repeat","","Creates a new iterator that endlessly repeats a single element.",null,{"i":[{"n":"t"}],"o":{"n":"repeat"}}],[5,"repeat_with","","Creates a new iterator that repeats elements of type `A` endlessly by applying the provided closure, the repeater, `F: FnMut() -> A`.",null,{"i":[{"n":"f"}],"o":{"n":"repeatwith"}}],[5,"empty","","Creates an iterator that yields nothing.",null,{"o":{"n":"empty"}}],[5,"once","","Creates an iterator that yields an element exactly once.",null,{"i":[{"n":"t"}],"o":{"n":"once"}}],[11,"next","core::ops","",17,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",17,null],[11,"nth","","",17,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"option"}}],[11,"last","","",17,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"min","","",17,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"max","","",17,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"next_back","","",17,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"next","","",18,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",18,null],[11,"nth","","",18,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"option"}}],[11,"next","","",24,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",24,null],[11,"nth","","",24,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"option"}}],[11,"last","","",24,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"min","","",24,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"max","","",24,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"try_fold","","",24,{"i":[{"n":"self"},{"n":"b"},{"n":"f"}],"o":{"n":"r"}}],[11,"next_back","","",24,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"try_rfold","","",24,{"i":[{"n":"self"},{"n":"b"},{"n":"f"}],"o":{"n":"r"}}],[11,"clone","core::iter","",112,{"i":[{"n":"self"}],"o":{"n":"repeat"}}],[11,"fmt","","",112,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",112,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",112,null],[11,"next_back","","",112,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"clone","","",113,{"i":[{"n":"self"}],"o":{"n":"repeatwith"}}],[11,"fmt","","",113,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",113,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",113,null],[11,"fmt","","",114,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",114,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",114,null],[11,"next_back","","",114,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"len","","",114,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"clone","","",114,{"i":[{"n":"self"}],"o":{"n":"empty"}}],[11,"default","","",114,{"o":{"n":"empty"}}],[11,"clone","","",115,{"i":[{"n":"self"}],"o":{"n":"once"}}],[11,"fmt","","",115,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",115,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",115,null],[11,"next_back","","",115,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"len","","",115,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"sum","core::num","",0,{"i":[{"n":"i"}],"o":{"g":["i8"],"n":"wrapping"}}],[11,"product","","",0,{"i":[{"n":"i"}],"o":{"g":["i8"],"n":"wrapping"}}],[11,"sum","","",0,{"i":[{"n":"i"}],"o":{"g":["i8"],"n":"wrapping"}}],[11,"product","","",0,{"i":[{"n":"i"}],"o":{"g":["i8"],"n":"wrapping"}}],[11,"sum","","",0,{"i":[{"n":"i"}],"o":{"g":["i16"],"n":"wrapping"}}],[11,"product","","",0,{"i":[{"n":"i"}],"o":{"g":["i16"],"n":"wrapping"}}],[11,"sum","","",0,{"i":[{"n":"i"}],"o":{"g":["i16"],"n":"wrapping"}}],[11,"product","","",0,{"i":[{"n":"i"}],"o":{"g":["i16"],"n":"wrapping"}}],[11,"sum","","",0,{"i":[{"n":"i"}],"o":{"g":["i32"],"n":"wrapping"}}],[11,"product","","",0,{"i":[{"n":"i"}],"o":{"g":["i32"],"n":"wrapping"}}],[11,"sum","","",0,{"i":[{"n":"i"}],"o":{"g":["i32"],"n":"wrapping"}}],[11,"product","","",0,{"i":[{"n":"i"}],"o":{"g":["i32"],"n":"wrapping"}}],[11,"sum","","",0,{"i":[{"n":"i"}],"o":{"g":["i64"],"n":"wrapping"}}],[11,"product","","",0,{"i":[{"n":"i"}],"o":{"g":["i64"],"n":"wrapping"}}],[11,"sum","","",0,{"i":[{"n":"i"}],"o":{"g":["i64"],"n":"wrapping"}}],[11,"product","","",0,{"i":[{"n":"i"}],"o":{"g":["i64"],"n":"wrapping"}}],[11,"sum","","",0,{"i":[{"n":"i"}],"o":{"g":["i128"],"n":"wrapping"}}],[11,"product","","",0,{"i":[{"n":"i"}],"o":{"g":["i128"],"n":"wrapping"}}],[11,"sum","","",0,{"i":[{"n":"i"}],"o":{"g":["i128"],"n":"wrapping"}}],[11,"product","","",0,{"i":[{"n":"i"}],"o":{"g":["i128"],"n":"wrapping"}}],[11,"sum","","",0,{"i":[{"n":"i"}],"o":{"g":["isize"],"n":"wrapping"}}],[11,"product","","",0,{"i":[{"n":"i"}],"o":{"g":["isize"],"n":"wrapping"}}],[11,"sum","","",0,{"i":[{"n":"i"}],"o":{"g":["isize"],"n":"wrapping"}}],[11,"product","","",0,{"i":[{"n":"i"}],"o":{"g":["isize"],"n":"wrapping"}}],[11,"sum","","",0,{"i":[{"n":"i"}],"o":{"g":["u8"],"n":"wrapping"}}],[11,"product","","",0,{"i":[{"n":"i"}],"o":{"g":["u8"],"n":"wrapping"}}],[11,"sum","","",0,{"i":[{"n":"i"}],"o":{"g":["u8"],"n":"wrapping"}}],[11,"product","","",0,{"i":[{"n":"i"}],"o":{"g":["u8"],"n":"wrapping"}}],[11,"sum","","",0,{"i":[{"n":"i"}],"o":{"g":["u16"],"n":"wrapping"}}],[11,"product","","",0,{"i":[{"n":"i"}],"o":{"g":["u16"],"n":"wrapping"}}],[11,"sum","","",0,{"i":[{"n":"i"}],"o":{"g":["u16"],"n":"wrapping"}}],[11,"product","","",0,{"i":[{"n":"i"}],"o":{"g":["u16"],"n":"wrapping"}}],[11,"sum","","",0,{"i":[{"n":"i"}],"o":{"g":["u32"],"n":"wrapping"}}],[11,"product","","",0,{"i":[{"n":"i"}],"o":{"g":["u32"],"n":"wrapping"}}],[11,"sum","","",0,{"i":[{"n":"i"}],"o":{"g":["u32"],"n":"wrapping"}}],[11,"product","","",0,{"i":[{"n":"i"}],"o":{"g":["u32"],"n":"wrapping"}}],[11,"sum","","",0,{"i":[{"n":"i"}],"o":{"g":["u64"],"n":"wrapping"}}],[11,"product","","",0,{"i":[{"n":"i"}],"o":{"g":["u64"],"n":"wrapping"}}],[11,"sum","","",0,{"i":[{"n":"i"}],"o":{"g":["u64"],"n":"wrapping"}}],[11,"product","","",0,{"i":[{"n":"i"}],"o":{"g":["u64"],"n":"wrapping"}}],[11,"sum","","",0,{"i":[{"n":"i"}],"o":{"g":["u128"],"n":"wrapping"}}],[11,"product","","",0,{"i":[{"n":"i"}],"o":{"g":["u128"],"n":"wrapping"}}],[11,"sum","","",0,{"i":[{"n":"i"}],"o":{"g":["u128"],"n":"wrapping"}}],[11,"product","","",0,{"i":[{"n":"i"}],"o":{"g":["u128"],"n":"wrapping"}}],[11,"sum","","",0,{"i":[{"n":"i"}],"o":{"g":["usize"],"n":"wrapping"}}],[11,"product","","",0,{"i":[{"n":"i"}],"o":{"g":["usize"],"n":"wrapping"}}],[11,"sum","","",0,{"i":[{"n":"i"}],"o":{"g":["usize"],"n":"wrapping"}}],[11,"product","","",0,{"i":[{"n":"i"}],"o":{"g":["usize"],"n":"wrapping"}}],[8,"Iterator","core::iter","An interface for dealing with iterators.",null,null],[16,"Item","","The type of the elements being iterated over.",116,null],[10,"next","","Advances the iterator and returns the next value.",116,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","Returns the bounds on the remaining length of the iterator.",116,null],[11,"count","","Consumes the iterator, counting the number of iterations and returning it.",116,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"last","","Consumes the iterator, returning the last element.",116,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"nth","","Returns the `n`th element of the iterator.",116,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"option"}}],[11,"step_by","","Creates an iterator starting at the same point, but stepping by the given amount at each iteration.",116,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"stepby"}}],[11,"chain","","Takes two iterators and creates a new iterator over both in sequence.",116,{"i":[{"n":"self"},{"n":"u"}],"o":{"n":"chain"}}],[11,"zip","","'Zips up' two iterators into a single iterator of pairs.",116,{"i":[{"n":"self"},{"n":"u"}],"o":{"n":"zip"}}],[11,"map","","Takes a closure and creates an iterator which calls that closure on each element.",116,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"map"}}],[11,"for_each","","Calls a closure on each element of an iterator.",116,{"i":[{"n":"self"},{"n":"f"}]}],[11,"filter","","Creates an iterator which uses a closure to determine if an element should be yielded.",116,{"i":[{"n":"self"},{"n":"p"}],"o":{"n":"filter"}}],[11,"filter_map","","Creates an iterator that both filters and maps.",116,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"filtermap"}}],[11,"enumerate","","Creates an iterator which gives the current iteration count as well as the next value.",116,{"i":[{"n":"self"}],"o":{"n":"enumerate"}}],[11,"peekable","","Creates an iterator which can use `peek` to look at the next element of the iterator without consuming it.",116,{"i":[{"n":"self"}],"o":{"n":"peekable"}}],[11,"skip_while","","Creates an iterator that [`skip`]s elements based on a predicate.",116,{"i":[{"n":"self"},{"n":"p"}],"o":{"n":"skipwhile"}}],[11,"take_while","","Creates an iterator that yields elements based on a predicate.",116,{"i":[{"n":"self"},{"n":"p"}],"o":{"n":"takewhile"}}],[11,"skip","","Creates an iterator that skips the first `n` elements.",116,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"skip"}}],[11,"take","","Creates an iterator that yields its first `n` elements.",116,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"take"}}],[11,"scan","","An iterator adaptor similar to [`fold`] that holds internal state and produces a new iterator.",116,{"i":[{"n":"self"},{"n":"st"},{"n":"f"}],"o":{"n":"scan"}}],[11,"flat_map","","Creates an iterator that works like map, but flattens nested structure.",116,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"flatmap"}}],[11,"flatten","","Creates an iterator that flattens nested structure.",116,{"i":[{"n":"self"}],"o":{"n":"flatten"}}],[11,"fuse","","Creates an iterator which ends after the first [`None`].",116,{"i":[{"n":"self"}],"o":{"n":"fuse"}}],[11,"inspect","","Do something with each element of an iterator, passing the value on.",116,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"inspect"}}],[11,"by_ref","","Borrows an iterator, rather than consuming it.",116,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"collect","","Transforms an iterator into a collection.",116,{"i":[{"n":"self"}],"o":{"n":"b"}}],[11,"partition","","Consumes an iterator, creating two collections from it.",116,null],[11,"try_fold","","An iterator method that applies a function as long as it returns successfully, producing a single, final value.",116,{"i":[{"n":"self"},{"n":"b"},{"n":"f"}],"o":{"n":"r"}}],[11,"try_for_each","","An iterator method that applies a fallible function to each item in the iterator, stopping at the first error and returning that error.",116,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"r"}}],[11,"fold","","An iterator method that applies a function, producing a single, final value.",116,{"i":[{"n":"self"},{"n":"b"},{"n":"f"}],"o":{"n":"b"}}],[11,"all","","Tests if every element of the iterator matches a predicate.",116,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"bool"}}],[11,"any","","Tests if any element of the iterator matches a predicate.",116,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"bool"}}],[11,"find","","Searches for an element of an iterator that satisfies a predicate.",116,{"i":[{"n":"self"},{"n":"p"}],"o":{"n":"option"}}],[11,"find_map","","Applies function to the elements of iterator and returns the first non-none result.",116,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"option"}}],[11,"position","","Searches for an element in an iterator, returning its index.",116,{"i":[{"n":"self"},{"n":"p"}],"o":{"g":["usize"],"n":"option"}}],[11,"rposition","","Searches for an element in an iterator from the right, returning its index.",116,{"i":[{"n":"self"},{"n":"p"}],"o":{"g":["usize"],"n":"option"}}],[11,"max","","Returns the maximum element of an iterator.",116,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"min","","Returns the minimum element of an iterator.",116,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"max_by_key","","Returns the element that gives the maximum value from the specified function.",116,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"option"}}],[11,"max_by","","Returns the element that gives the maximum value with respect to the specified comparison function.",116,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"option"}}],[11,"min_by_key","","Returns the element that gives the minimum value from the specified function.",116,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"option"}}],[11,"min_by","","Returns the element that gives the minimum value with respect to the specified comparison function.",116,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"option"}}],[11,"rev","","Reverses an iterator's direction.",116,{"i":[{"n":"self"}],"o":{"n":"rev"}}],[11,"unzip","","Converts an iterator of pairs into a pair of containers.",116,null],[11,"cloned","","Creates an iterator which [`clone`]s all of its elements.",116,{"i":[{"n":"self"}],"o":{"n":"cloned"}}],[11,"cycle","","Repeats an iterator endlessly.",116,{"i":[{"n":"self"}],"o":{"n":"cycle"}}],[11,"sum","","Sums the elements of an iterator.",116,{"i":[{"n":"self"}],"o":{"n":"s"}}],[11,"product","","Iterates over the entire iterator, multiplying all the elements",116,{"i":[{"n":"self"}],"o":{"n":"p"}}],[11,"cmp","","Lexicographically compares the elements of this `Iterator` with those of another.",116,{"i":[{"n":"self"},{"n":"i"}],"o":{"n":"ordering"}}],[11,"partial_cmp","","Lexicographically compares the elements of this `Iterator` with those of another.",116,{"i":[{"n":"self"},{"n":"i"}],"o":{"g":["ordering"],"n":"option"}}],[11,"eq","","Determines if the elements of this `Iterator` are equal to those of another.",116,{"i":[{"n":"self"},{"n":"i"}],"o":{"n":"bool"}}],[11,"ne","","Determines if the elements of this `Iterator` are unequal to those of another.",116,{"i":[{"n":"self"},{"n":"i"}],"o":{"n":"bool"}}],[11,"lt","","Determines if the elements of this `Iterator` are lexicographically less than those of another.",116,{"i":[{"n":"self"},{"n":"i"}],"o":{"n":"bool"}}],[11,"le","","Determines if the elements of this `Iterator` are lexicographically less or equal to those of another.",116,{"i":[{"n":"self"},{"n":"i"}],"o":{"n":"bool"}}],[11,"gt","","Determines if the elements of this `Iterator` are lexicographically greater than those of another.",116,{"i":[{"n":"self"},{"n":"i"}],"o":{"n":"bool"}}],[11,"ge","","Determines if the elements of this `Iterator` are lexicographically greater than or equal to those of another.",116,{"i":[{"n":"self"},{"n":"i"}],"o":{"n":"bool"}}],[8,"Step","","Objects that can be stepped over in both directions.",null,null],[10,"steps_between","","Returns the number of steps between two step objects. The count is inclusive of `start` and exclusive of `end`.",117,{"i":[{"n":"self"},{"n":"self"}],"o":{"g":["usize"],"n":"option"}}],[10,"replace_one","","Replaces this step with `1`, returning itself",117,{"i":[{"n":"self"}],"o":{"n":"self"}}],[10,"replace_zero","","Replaces this step with `0`, returning itself",117,{"i":[{"n":"self"}],"o":{"n":"self"}}],[10,"add_one","","Adds one to this step, returning the result",117,{"i":[{"n":"self"}],"o":{"n":"self"}}],[10,"sub_one","","Subtracts one to this step, returning the result",117,{"i":[{"n":"self"}],"o":{"n":"self"}}],[10,"add_usize","","Add an usize, returning None on overflow",117,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"option"}}],[8,"FromIterator","","Conversion from an `Iterator`.",null,null],[10,"from_iter","","Creates a value from an iterator.",118,{"i":[{"n":"t"}],"o":{"n":"self"}}],[8,"IntoIterator","","Conversion into an `Iterator`.",null,null],[16,"Item","","The type of the elements being iterated over.",119,null],[16,"IntoIter","","Which kind of iterator are we turning this into?",119,null],[10,"into_iter","","Creates an iterator from a value.",119,null],[8,"DoubleEndedIterator","","An iterator able to yield elements from both ends.",null,null],[10,"next_back","","Removes and returns an element from the end of the iterator.",120,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"try_rfold","","This is the reverse version of [`try_fold()`]: it takes elements starting from the back of the iterator.",120,{"i":[{"n":"self"},{"n":"b"},{"n":"f"}],"o":{"n":"r"}}],[11,"rfold","","An iterator method that reduces the iterator's elements to a single, final value, starting from the back.",120,{"i":[{"n":"self"},{"n":"b"},{"n":"f"}],"o":{"n":"b"}}],[11,"rfind","","Searches for an element of an iterator from the back that satisfies a predicate.",120,{"i":[{"n":"self"},{"n":"p"}],"o":{"n":"option"}}],[8,"Extend","","Extend a collection with the contents of an iterator.",null,null],[10,"extend","","Extends a collection with the contents of an iterator.",121,{"i":[{"n":"self"},{"n":"t"}]}],[8,"ExactSizeIterator","","An iterator that knows its exact length.",null,null],[11,"len","","Returns the exact number of times the iterator will iterate.",122,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"is_empty","","Returns whether the iterator is empty.",122,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[8,"Sum","","Trait to represent types that can be created by summing up an iterator.",null,null],[10,"sum","","Method which takes an iterator and generates `Self` from the elements by \"summing up\" the items.",123,{"i":[{"n":"i"}],"o":{"n":"self"}}],[8,"Product","","Trait to represent types that can be created by multiplying elements of an iterator.",null,null],[10,"product","","Method which takes an iterator and generates `Self` from the elements by multiplying the items.",124,{"i":[{"n":"i"}],"o":{"n":"self"}}],[8,"FusedIterator","","An iterator that always continues to yield `None` when exhausted.",null,null],[8,"TrustedLen","","An iterator that reports an accurate length using size_hint.",null,null],[11,"clone","","",125,{"i":[{"n":"self"}],"o":{"n":"rev"}}],[11,"fmt","","",125,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",125,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",125,null],[11,"try_fold","","",125,{"i":[{"n":"self"},{"n":"b"},{"n":"f"}],"o":{"n":"r"}}],[11,"fold","","",125,{"i":[{"n":"self"},{"n":"acc"},{"n":"f"}],"o":{"n":"acc"}}],[11,"find","","",125,{"i":[{"n":"self"},{"n":"p"}],"o":{"n":"option"}}],[11,"rposition","","",125,{"i":[{"n":"self"},{"n":"p"}],"o":{"g":["usize"],"n":"option"}}],[11,"next_back","","",125,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"try_rfold","","",125,{"i":[{"n":"self"},{"n":"b"},{"n":"f"}],"o":{"n":"r"}}],[11,"rfold","","",125,{"i":[{"n":"self"},{"n":"acc"},{"n":"f"}],"o":{"n":"acc"}}],[11,"rfind","","",125,{"i":[{"n":"self"},{"n":"p"}],"o":{"n":"option"}}],[11,"len","","",125,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"is_empty","","",125,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"clone","","",126,{"i":[{"n":"self"}],"o":{"n":"cloned"}}],[11,"fmt","","",126,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",126,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",126,null],[11,"try_fold","","",126,{"i":[{"n":"self"},{"n":"b"},{"n":"f"}],"o":{"n":"r"}}],[11,"fold","","",126,{"i":[{"n":"self"},{"n":"acc"},{"n":"f"}],"o":{"n":"acc"}}],[11,"next_back","","",126,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"try_rfold","","",126,{"i":[{"n":"self"},{"n":"b"},{"n":"f"}],"o":{"n":"r"}}],[11,"rfold","","",126,{"i":[{"n":"self"},{"n":"acc"},{"n":"f"}],"o":{"n":"acc"}}],[11,"len","","",126,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"is_empty","","",126,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"clone","","",127,{"i":[{"n":"self"}],"o":{"n":"cycle"}}],[11,"fmt","","",127,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",127,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",127,null],[11,"clone","","",128,{"i":[{"n":"self"}],"o":{"n":"stepby"}}],[11,"fmt","","",128,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",128,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",128,null],[11,"nth","","",128,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"option"}}],[11,"clone","","",129,{"i":[{"n":"self"}],"o":{"n":"chain"}}],[11,"fmt","","",129,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",129,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"count","","",129,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"try_fold","","",129,{"i":[{"n":"self"},{"n":"acc"},{"n":"f"}],"o":{"n":"r"}}],[11,"fold","","",129,{"i":[{"n":"self"},{"n":"acc"},{"n":"f"}],"o":{"n":"acc"}}],[11,"nth","","",129,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"option"}}],[11,"find","","",129,{"i":[{"n":"self"},{"n":"p"}],"o":{"n":"option"}}],[11,"last","","",129,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",129,null],[11,"next_back","","",129,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"try_rfold","","",129,{"i":[{"n":"self"},{"n":"acc"},{"n":"f"}],"o":{"n":"r"}}],[11,"rfold","","",129,{"i":[{"n":"self"},{"n":"acc"},{"n":"f"}],"o":{"n":"acc"}}],[11,"clone","","",130,{"i":[{"n":"self"}],"o":{"n":"zip"}}],[11,"fmt","","",130,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",130,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",130,null],[11,"nth","","",130,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"option"}}],[11,"next_back","","",130,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"clone","","",131,{"i":[{"n":"self"}],"o":{"n":"map"}}],[11,"fmt","","",131,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",131,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",131,null],[11,"try_fold","","",131,{"i":[{"n":"self"},{"n":"acc"},{"n":"g"}],"o":{"n":"r"}}],[11,"fold","","",131,{"i":[{"n":"self"},{"n":"acc"},{"n":"g"}],"o":{"n":"acc"}}],[11,"next_back","","",131,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"try_rfold","","",131,{"i":[{"n":"self"},{"n":"acc"},{"n":"g"}],"o":{"n":"r"}}],[11,"rfold","","",131,{"i":[{"n":"self"},{"n":"acc"},{"n":"g"}],"o":{"n":"acc"}}],[11,"len","","",131,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"is_empty","","",131,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"clone","","",132,{"i":[{"n":"self"}],"o":{"n":"filter"}}],[11,"fmt","","",132,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",132,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",132,null],[11,"count","","",132,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"try_fold","","",132,{"i":[{"n":"self"},{"n":"acc"},{"n":"fold"}],"o":{"n":"r"}}],[11,"fold","","",132,{"i":[{"n":"self"},{"n":"acc"},{"n":"fold"}],"o":{"n":"acc"}}],[11,"next_back","","",132,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"try_rfold","","",132,{"i":[{"n":"self"},{"n":"acc"},{"n":"fold"}],"o":{"n":"r"}}],[11,"rfold","","",132,{"i":[{"n":"self"},{"n":"acc"},{"n":"fold"}],"o":{"n":"acc"}}],[11,"clone","","",133,{"i":[{"n":"self"}],"o":{"n":"filtermap"}}],[11,"fmt","","",133,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",133,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",133,null],[11,"try_fold","","",133,{"i":[{"n":"self"},{"n":"acc"},{"n":"fold"}],"o":{"n":"r"}}],[11,"fold","","",133,{"i":[{"n":"self"},{"n":"acc"},{"n":"fold"}],"o":{"n":"acc"}}],[11,"next_back","","",133,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"try_rfold","","",133,{"i":[{"n":"self"},{"n":"acc"},{"n":"fold"}],"o":{"n":"r"}}],[11,"rfold","","",133,{"i":[{"n":"self"},{"n":"acc"},{"n":"fold"}],"o":{"n":"acc"}}],[11,"clone","","",134,{"i":[{"n":"self"}],"o":{"n":"enumerate"}}],[11,"fmt","","",134,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","Overflow Behavior",134,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",134,null],[11,"nth","","",134,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"option"}}],[11,"count","","",134,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"try_fold","","",134,{"i":[{"n":"self"},{"n":"acc"},{"n":"fold"}],"o":{"n":"r"}}],[11,"fold","","",134,{"i":[{"n":"self"},{"n":"acc"},{"n":"fold"}],"o":{"n":"acc"}}],[11,"next_back","","",134,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"try_rfold","","",134,{"i":[{"n":"self"},{"n":"acc"},{"n":"fold"}],"o":{"n":"r"}}],[11,"rfold","","",134,{"i":[{"n":"self"},{"n":"acc"},{"n":"fold"}],"o":{"n":"acc"}}],[11,"len","","",134,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"is_empty","","",134,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"clone","","",135,{"i":[{"n":"self"}],"o":{"n":"peekable"}}],[11,"fmt","","",135,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",135,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"count","","",135,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"nth","","",135,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"option"}}],[11,"last","","",135,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",135,null],[11,"try_fold","","",135,{"i":[{"n":"self"},{"n":"b"},{"n":"f"}],"o":{"n":"r"}}],[11,"fold","","",135,{"i":[{"n":"self"},{"n":"acc"},{"n":"fold"}],"o":{"n":"acc"}}],[11,"peek","","Returns a reference to the next() value without advancing the iterator.",135,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"clone","","",136,{"i":[{"n":"self"}],"o":{"n":"skipwhile"}}],[11,"fmt","","",136,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",136,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",136,null],[11,"try_fold","","",136,{"i":[{"n":"self"},{"n":"acc"},{"n":"fold"}],"o":{"n":"r"}}],[11,"fold","","",136,{"i":[{"n":"self"},{"n":"acc"},{"n":"fold"}],"o":{"n":"acc"}}],[11,"clone","","",137,{"i":[{"n":"self"}],"o":{"n":"takewhile"}}],[11,"fmt","","",137,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",137,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",137,null],[11,"try_fold","","",137,{"i":[{"n":"self"},{"n":"acc"},{"n":"fold"}],"o":{"n":"r"}}],[11,"clone","","",138,{"i":[{"n":"self"}],"o":{"n":"skip"}}],[11,"fmt","","",138,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",138,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"nth","","",138,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"option"}}],[11,"count","","",138,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"last","","",138,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",138,null],[11,"try_fold","","",138,{"i":[{"n":"self"},{"n":"acc"},{"n":"fold"}],"o":{"n":"r"}}],[11,"fold","","",138,{"i":[{"n":"self"},{"n":"acc"},{"n":"fold"}],"o":{"n":"acc"}}],[11,"next_back","","",138,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"try_rfold","","",138,{"i":[{"n":"self"},{"n":"acc"},{"n":"fold"}],"o":{"n":"r"}}],[11,"clone","","",139,{"i":[{"n":"self"}],"o":{"n":"take"}}],[11,"fmt","","",139,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",139,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"nth","","",139,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"option"}}],[11,"size_hint","","",139,null],[11,"try_fold","","",139,{"i":[{"n":"self"},{"n":"acc"},{"n":"fold"}],"o":{"n":"r"}}],[11,"clone","","",140,{"i":[{"n":"self"}],"o":{"n":"scan"}}],[11,"fmt","","",140,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",140,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",140,null],[11,"try_fold","","",140,{"i":[{"n":"self"},{"n":"acc"},{"n":"fold"}],"o":{"n":"r"}}],[11,"clone","","",141,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"fmt","","",141,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",141,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",141,null],[11,"try_fold","","",141,{"i":[{"n":"self"},{"n":"acc"},{"n":"fold"}],"o":{"n":"r"}}],[11,"fold","","",141,{"i":[{"n":"self"},{"n":"acc"},{"n":"fold"}],"o":{"n":"acc"}}],[11,"next_back","","",141,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"try_rfold","","",141,{"i":[{"n":"self"},{"n":"acc"},{"n":"fold"}],"o":{"n":"r"}}],[11,"rfold","","",141,{"i":[{"n":"self"},{"n":"acc"},{"n":"fold"}],"o":{"n":"acc"}}],[11,"fmt","","",142,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",142,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"next","","",142,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",142,null],[11,"try_fold","","",142,{"i":[{"n":"self"},{"n":"acc"},{"n":"fold"}],"o":{"n":"r"}}],[11,"fold","","",142,{"i":[{"n":"self"},{"n":"acc"},{"n":"fold"}],"o":{"n":"acc"}}],[11,"next_back","","",142,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"try_rfold","","",142,{"i":[{"n":"self"},{"n":"acc"},{"n":"fold"}],"o":{"n":"r"}}],[11,"rfold","","",142,{"i":[{"n":"self"},{"n":"acc"},{"n":"fold"}],"o":{"n":"acc"}}],[11,"clone","","",143,{"i":[{"n":"self"}],"o":{"n":"fuse"}}],[11,"fmt","","",143,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",143,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"nth","","",143,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"option"}}],[11,"last","","",143,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"count","","",143,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"size_hint","","",143,null],[11,"try_fold","","",143,{"i":[{"n":"self"},{"n":"acc"},{"n":"fold"}],"o":{"n":"r"}}],[11,"fold","","",143,{"i":[{"n":"self"},{"n":"acc"},{"n":"fold"}],"o":{"n":"acc"}}],[11,"next_back","","",143,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"try_rfold","","",143,{"i":[{"n":"self"},{"n":"acc"},{"n":"fold"}],"o":{"n":"r"}}],[11,"rfold","","",143,{"i":[{"n":"self"},{"n":"acc"},{"n":"fold"}],"o":{"n":"acc"}}],[11,"next","","",143,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"nth","","",143,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"option"}}],[11,"last","","",143,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"count","","",143,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"size_hint","","",143,null],[11,"try_fold","","",143,{"i":[{"n":"self"},{"n":"acc"},{"n":"fold"}],"o":{"n":"r"}}],[11,"fold","","",143,{"i":[{"n":"self"},{"n":"acc"},{"n":"fold"}],"o":{"n":"acc"}}],[11,"next_back","","",143,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"try_rfold","","",143,{"i":[{"n":"self"},{"n":"acc"},{"n":"fold"}],"o":{"n":"r"}}],[11,"rfold","","",143,{"i":[{"n":"self"},{"n":"acc"},{"n":"fold"}],"o":{"n":"acc"}}],[11,"len","","",143,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"is_empty","","",143,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"clone","","",144,{"i":[{"n":"self"}],"o":{"n":"inspect"}}],[11,"fmt","","",144,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",144,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",144,null],[11,"try_fold","","",144,{"i":[{"n":"self"},{"n":"acc"},{"n":"fold"}],"o":{"n":"r"}}],[11,"fold","","",144,{"i":[{"n":"self"},{"n":"acc"},{"n":"fold"}],"o":{"n":"acc"}}],[11,"next_back","","",144,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"try_rfold","","",144,{"i":[{"n":"self"},{"n":"acc"},{"n":"fold"}],"o":{"n":"r"}}],[11,"rfold","","",144,{"i":[{"n":"self"},{"n":"acc"},{"n":"fold"}],"o":{"n":"acc"}}],[11,"len","","",144,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"is_empty","","",144,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[0,"option","core","Optional values.",null,null],[3,"Iter","core::option","An iterator over a reference to the [`Some`] variant of an [`Option`].",null,null],[3,"IterMut","","An iterator over a mutable reference to the [`Some`] variant of an [`Option`].",null,null],[3,"IntoIter","","An iterator over the value in [`Some`] variant of an [`Option`].",null,null],[3,"NoneError","","The error type that results from applying the try operator (`?`) to a `None` value. If you wish to allow `x?` (where `x` is an `Option<T>`) to be converted into your error type, you can implement `impl From<NoneError>` for `YourErrorType`. In that case, `x?` within a function that returns `Result<_, YourErrorType>` will translate a `None` value into an `Err` result.",null,null],[4,"Option","","The `Option` type. See the module level documentation for more.",null,null],[13,"None","","No value",145,null],[13,"Some","","Some value `T`",145,null],[11,"clone","","",145,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"eq","","",145,{"i":[{"n":"self"},{"n":"option"}],"o":{"n":"bool"}}],[11,"ne","","",145,{"i":[{"n":"self"},{"n":"option"}],"o":{"n":"bool"}}],[11,"partial_cmp","","",145,{"i":[{"n":"self"},{"n":"option"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",145,{"i":[{"n":"self"},{"n":"option"}],"o":{"n":"bool"}}],[11,"le","","",145,{"i":[{"n":"self"},{"n":"option"}],"o":{"n":"bool"}}],[11,"gt","","",145,{"i":[{"n":"self"},{"n":"option"}],"o":{"n":"bool"}}],[11,"ge","","",145,{"i":[{"n":"self"},{"n":"option"}],"o":{"n":"bool"}}],[11,"cmp","","",145,{"i":[{"n":"self"},{"n":"option"}],"o":{"n":"ordering"}}],[11,"fmt","","",145,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"hash","","",145,null],[11,"is_some","","Returns `true` if the option is a [`Some`] value.",145,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"is_none","","Returns `true` if the option is a [`None`] value.",145,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"as_ref","","Converts from `Option<T>` to `Option<&T>`.",145,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"as_mut","","Converts from `Option<T>` to `Option<&mut T>`.",145,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"as_pin_mut","","Converts from `Option<T>` to `Option<PinMut<'_, T>>`",145,{"i":[{"n":"pinmut"}],"o":{"g":["pinmut"],"n":"option"}}],[11,"expect","","Unwraps an option, yielding the content of a [`Some`].",145,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"t"}}],[11,"unwrap","","Moves the value `v` out of the `Option<T>` if it is [`Some(v)`].",145,{"i":[{"n":"self"}],"o":{"n":"t"}}],[11,"unwrap_or","","Returns the contained value or a default.",145,{"i":[{"n":"self"},{"n":"t"}],"o":{"n":"t"}}],[11,"unwrap_or_else","","Returns the contained value or computes it from a closure.",145,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"t"}}],[11,"map","","Maps an `Option<T>` to `Option<U>` by applying a function to a contained value.",145,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"option"}}],[11,"map_or","","Applies a function to the contained value (if any), or returns the provided default (if not).",145,{"i":[{"n":"self"},{"n":"u"},{"n":"f"}],"o":{"n":"u"}}],[11,"map_or_else","","Applies a function to the contained value (if any), or computes a default (if not).",145,{"i":[{"n":"self"},{"n":"d"},{"n":"f"}],"o":{"n":"u"}}],[11,"ok_or","","Transforms the `Option<T>` into a [`Result<T, E>`], mapping [`Some(v)`] to [`Ok(v)`] and [`None`] to [`Err(err)`].",145,{"i":[{"n":"self"},{"n":"e"}],"o":{"n":"result"}}],[11,"ok_or_else","","Transforms the `Option<T>` into a [`Result<T, E>`], mapping [`Some(v)`] to [`Ok(v)`] and [`None`] to [`Err(err())`].",145,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"result"}}],[11,"iter","","Returns an iterator over the possibly contained value.",145,{"i":[{"n":"self"}],"o":{"n":"iter"}}],[11,"iter_mut","","Returns a mutable iterator over the possibly contained value.",145,{"i":[{"n":"self"}],"o":{"n":"itermut"}}],[11,"and","","Returns [`None`] if the option is [`None`], otherwise returns `optb`.",145,{"i":[{"n":"self"},{"n":"option"}],"o":{"n":"option"}}],[11,"and_then","","Returns [`None`] if the option is [`None`], otherwise calls `f` with the wrapped value and returns the result.",145,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"option"}}],[11,"filter","","Returns `None` if the option is `None`, otherwise calls `predicate` with the wrapped value and returns:",145,{"i":[{"n":"self"},{"n":"p"}],"o":{"n":"self"}}],[11,"or","","Returns the option if it contains a value, otherwise returns `optb`.",145,{"i":[{"n":"self"},{"n":"option"}],"o":{"n":"option"}}],[11,"or_else","","Returns the option if it contains a value, otherwise calls `f` and returns the result.",145,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"option"}}],[11,"xor","","Returns [`Some`] if exactly one of `self`, `optb` is [`Some`], otherwise returns `None`.",145,{"i":[{"n":"self"},{"n":"option"}],"o":{"n":"option"}}],[11,"get_or_insert","","Inserts `v` into the option if it is [`None`], then returns a mutable reference to the contained value.",145,{"i":[{"n":"self"},{"n":"t"}],"o":{"n":"t"}}],[11,"get_or_insert_with","","Inserts a value computed from `f` into the option if it is [`None`], then returns a mutable reference to the contained value.",145,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"t"}}],[11,"take","","Takes the value out of the option, leaving a [`None`] in its place.",145,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"cloned","","Maps an `Option<&T>` to an `Option<T>` by cloning the contents of the option.",145,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"cloned","","Maps an `Option<&mut T>` to an `Option<T>` by cloning the contents of the option.",145,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"unwrap_or_default","","Returns the contained value or a default",145,{"i":[{"n":"self"}],"o":{"n":"t"}}],[11,"transpose","","Transposes an `Option` of a `Result` into a `Result` of an `Option`.",145,{"i":[{"n":"self"}],"o":{"g":["option"],"n":"result"}}],[11,"default","","Returns [`None`].",145,{"o":{"n":"option"}}],[11,"into_iter","","Returns a consuming iterator over the possibly contained value.",145,{"i":[{"n":"self"}],"o":{"n":"intoiter"}}],[11,"from","","",145,{"i":[{"n":"t"}],"o":{"n":"option"}}],[11,"fmt","","",146,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",146,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",146,null],[11,"next_back","","",146,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"clone","","",146,{"i":[{"n":"self"}],"o":{"n":"iter"}}],[11,"fmt","","",147,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",147,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",147,null],[11,"next_back","","",147,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"clone","","",148,{"i":[{"n":"self"}],"o":{"n":"intoiter"}}],[11,"fmt","","",148,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",148,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",148,null],[11,"next_back","","",148,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"from_iter","","Takes each element in the [`Iterator`]: if it is [`None`], no further elements are taken, and the [`None`] is returned. Should no [`None`] occur, a container with the values of each `Option` is returned.",145,{"i":[{"n":"i"}],"o":{"n":"option"}}],[11,"clone","","",149,{"i":[{"n":"self"}],"o":{"n":"noneerror"}}],[11,"eq","","",149,{"i":[{"n":"self"},{"n":"noneerror"}],"o":{"n":"bool"}}],[11,"partial_cmp","","",149,{"i":[{"n":"self"},{"n":"noneerror"}],"o":{"g":["ordering"],"n":"option"}}],[11,"cmp","","",149,{"i":[{"n":"self"},{"n":"noneerror"}],"o":{"n":"ordering"}}],[11,"fmt","","",149,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"hash","","",149,null],[11,"into_result","","",145,{"i":[{"n":"self"}],"o":{"g":["noneerror"],"n":"result"}}],[11,"from_ok","","",145,{"i":[{"n":"t"}],"o":{"n":"self"}}],[11,"from_error","","",145,{"i":[{"n":"noneerror"}],"o":{"n":"self"}}],[0,"raw","core","Contains struct definitions for the layout of compiler built-in types.",null,null],[3,"TraitObject","core::raw","The representation of a trait object like `&SomeTrait`.",null,null],[12,"data","","",150,null],[12,"vtable","","",150,null],[11,"clone","","",150,{"i":[{"n":"self"}],"o":{"n":"traitobject"}}],[0,"result","core","Error handling with the `Result` type.",null,null],[3,"Iter","core::result","An iterator over a reference to the [`Ok`] variant of a [`Result`].",null,null],[3,"IterMut","","An iterator over a mutable reference to the [`Ok`] variant of a [`Result`].",null,null],[3,"IntoIter","","An iterator over the value in a [`Ok`] variant of a [`Result`].",null,null],[4,"Result","","`Result` is a type that represents either success ([`Ok`]) or failure ([`Err`]).",null,null],[13,"Ok","","Contains the success value",151,null],[13,"Err","","Contains the error value",151,null],[11,"clone","","",151,{"i":[{"n":"self"}],"o":{"n":"result"}}],[11,"eq","","",151,{"i":[{"n":"self"},{"n":"result"}],"o":{"n":"bool"}}],[11,"ne","","",151,{"i":[{"n":"self"},{"n":"result"}],"o":{"n":"bool"}}],[11,"partial_cmp","","",151,{"i":[{"n":"self"},{"n":"result"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",151,{"i":[{"n":"self"},{"n":"result"}],"o":{"n":"bool"}}],[11,"le","","",151,{"i":[{"n":"self"},{"n":"result"}],"o":{"n":"bool"}}],[11,"gt","","",151,{"i":[{"n":"self"},{"n":"result"}],"o":{"n":"bool"}}],[11,"ge","","",151,{"i":[{"n":"self"},{"n":"result"}],"o":{"n":"bool"}}],[11,"cmp","","",151,{"i":[{"n":"self"},{"n":"result"}],"o":{"n":"ordering"}}],[11,"fmt","","",151,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"hash","","",151,null],[11,"is_ok","","Returns `true` if the result is [`Ok`].",151,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"is_err","","Returns `true` if the result is [`Err`].",151,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"ok","","Converts from `Result<T, E>` to [`Option<T>`].",151,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"err","","Converts from `Result<T, E>` to [`Option<E>`].",151,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"as_ref","","Converts from `Result<T, E>` to `Result<&T, &E>`.",151,{"i":[{"n":"self"}],"o":{"n":"result"}}],[11,"as_mut","","Converts from `Result<T, E>` to `Result<&mut T, &mut E>`.",151,{"i":[{"n":"self"}],"o":{"n":"result"}}],[11,"map","","Maps a `Result<T, E>` to `Result<U, E>` by applying a function to a contained [`Ok`] value, leaving an [`Err`] value untouched.",151,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"result"}}],[11,"map_err","","Maps a `Result<T, E>` to `Result<T, F>` by applying a function to a contained [`Err`] value, leaving an [`Ok`] value untouched.",151,{"i":[{"n":"self"},{"n":"o"}],"o":{"n":"result"}}],[11,"iter","","Returns an iterator over the possibly contained value.",151,{"i":[{"n":"self"}],"o":{"n":"iter"}}],[11,"iter_mut","","Returns a mutable iterator over the possibly contained value.",151,{"i":[{"n":"self"}],"o":{"n":"itermut"}}],[11,"and","","Returns `res` if the result is [`Ok`], otherwise returns the [`Err`] value of `self`.",151,{"i":[{"n":"self"},{"n":"result"}],"o":{"n":"result"}}],[11,"and_then","","Calls `op` if the result is [`Ok`], otherwise returns the [`Err`] value of `self`.",151,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"result"}}],[11,"or","","Returns `res` if the result is [`Err`], otherwise returns the [`Ok`] value of `self`.",151,{"i":[{"n":"self"},{"n":"result"}],"o":{"n":"result"}}],[11,"or_else","","Calls `op` if the result is [`Err`], otherwise returns the [`Ok`] value of `self`.",151,{"i":[{"n":"self"},{"n":"o"}],"o":{"n":"result"}}],[11,"unwrap_or","","Unwraps a result, yielding the content of an [`Ok`]. Else, it returns `optb`.",151,{"i":[{"n":"self"},{"n":"t"}],"o":{"n":"t"}}],[11,"unwrap_or_else","","Unwraps a result, yielding the content of an [`Ok`]. If the value is an [`Err`] then it calls `op` with its value.",151,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"t"}}],[11,"unwrap","","Unwraps a result, yielding the content of an [`Ok`].",151,{"i":[{"n":"self"}],"o":{"n":"t"}}],[11,"expect","","Unwraps a result, yielding the content of an [`Ok`].",151,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"t"}}],[11,"unwrap_err","","Unwraps a result, yielding the content of an [`Err`].",151,{"i":[{"n":"self"}],"o":{"n":"e"}}],[11,"expect_err","","Unwraps a result, yielding the content of an [`Err`].",151,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"e"}}],[11,"unwrap_or_default","","Returns the contained value or a default",151,{"i":[{"n":"self"}],"o":{"n":"t"}}],[11,"transpose","","Transposes a `Result` of an `Option` into an `Option` of a `Result`.",151,{"i":[{"n":"self"}],"o":{"g":["result"],"n":"option"}}],[11,"into_iter","","Returns a consuming iterator over the possibly contained value.",151,{"i":[{"n":"self"}],"o":{"n":"intoiter"}}],[11,"fmt","","",152,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",152,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",152,null],[11,"next_back","","",152,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"clone","","",152,{"i":[{"n":"self"}],"o":{"n":"iter"}}],[11,"fmt","","",153,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",153,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",153,null],[11,"next_back","","",153,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"clone","","",154,{"i":[{"n":"self"}],"o":{"n":"intoiter"}}],[11,"fmt","","",154,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",154,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",154,null],[11,"next_back","","",154,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"from_iter","","Takes each element in the `Iterator`: if it is an `Err`, no further elements are taken, and the `Err` is returned. Should no `Err` occur, a container with the values of each `Result` is returned.",151,{"i":[{"n":"i"}],"o":{"n":"result"}}],[11,"into_result","","",151,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"from_ok","","",151,{"i":[{"n":"t"}],"o":{"n":"self"}}],[11,"from_error","","",151,{"i":[{"n":"e"}],"o":{"n":"self"}}],[0,"slice","core","Slice management and manipulation",null,null],[3,"Iter","core::slice","Immutable slice iterator",null,null],[3,"IterMut","","Mutable slice iterator.",null,null],[3,"Split","","An iterator over subslices separated by elements that match a predicate function.",null,null],[3,"SplitMut","","An iterator over the subslices of the vector which are separated by elements that match `pred`.",null,null],[3,"RSplit","","An iterator over subslices separated by elements that match a predicate function, starting from the end of the slice.",null,null],[3,"RSplitMut","","An iterator over the subslices of the vector which are separated by elements that match `pred`, starting from the end of the slice.",null,null],[3,"SplitN","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits.",null,null],[3,"RSplitN","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits, starting from the end of the slice.",null,null],[3,"SplitNMut","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits.",null,null],[3,"RSplitNMut","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits, starting from the end of the slice.",null,null],[3,"Windows","","An iterator over overlapping subslices of length `size`.",null,null],[3,"Chunks","","An iterator over a slice in (non-overlapping) chunks (`chunk_size` elements at a time).",null,null],[3,"ChunksMut","","An iterator over a slice in (non-overlapping) mutable chunks (`chunk_size` elements at a time). When the slice len is not evenly divided by the chunk size, the last slice of the iteration will be the remainder.",null,null],[3,"ExactChunks","","An iterator over a slice in (non-overlapping) chunks (`chunk_size` elements at a time).",null,null],[3,"ExactChunksMut","","An iterator over a slice in (non-overlapping) mutable chunks (`chunk_size` elements at a time). When the slice len is not evenly divided by the chunk size, the last up to `chunk_size-1` elements will be omitted.",null,null],[5,"from_raw_parts","","Forms a slice from a pointer and a length.",null,null],[5,"from_raw_parts_mut","","Performs the same functionality as `from_raw_parts`, except that a mutable slice is returned.",null,null],[5,"from_ref","","Converts a reference to T into a slice of length 1 (without copying).",null,null],[5,"from_mut","","Converts a reference to T into a slice of length 1 (without copying).",null,null],[0,"memchr","","Pure rust memchr implementation, taken from rust-memchr",null,null],[5,"memchr","core::slice::memchr","Return the first index matching the byte `x` in `text`.",null,null],[5,"memrchr","","Return the last index matching the byte `x` in `text`.",null,null],[8,"SliceIndex","core::slice","A helper trait used for indexing operations.",null,null],[16,"Output","","The output type returned by methods.",155,null],[10,"get","","Returns a shared reference to the output at this location, if in bounds.",155,{"i":[{"n":"self"},{"n":"t"}],"o":{"n":"option"}}],[10,"get_mut","","Returns a mutable reference to the output at this location, if in bounds.",155,{"i":[{"n":"self"},{"n":"t"}],"o":{"n":"option"}}],[10,"get_unchecked","","Returns a shared reference to the output at this location, without performing any bounds checking.",155,null],[10,"get_unchecked_mut","","Returns a mutable reference to the output at this location, without performing any bounds checking.",155,null],[10,"index","","Returns a shared reference to the output at this location, panicking if out of bounds.",155,null],[10,"index_mut","","Returns a mutable reference to the output at this location, panicking if out of bounds.",155,null],[11,"get","core::ops","",17,null],[11,"get_mut","","",17,null],[11,"get_unchecked","","",17,null],[11,"get_unchecked_mut","","",17,null],[11,"index","","",17,null],[11,"index_mut","","",17,null],[11,"get","","",19,null],[11,"get_mut","","",19,null],[11,"get_unchecked","","",19,null],[11,"get_unchecked_mut","","",19,null],[11,"index","","",19,null],[11,"index_mut","","",19,null],[11,"get","","",18,null],[11,"get_mut","","",18,null],[11,"get_unchecked","","",18,null],[11,"get_unchecked_mut","","",18,null],[11,"index","","",18,null],[11,"index_mut","","",18,null],[11,"get","","",23,null],[11,"get_mut","","",23,null],[11,"get_unchecked","","",23,null],[11,"get_unchecked_mut","","",23,null],[11,"index","","",23,null],[11,"index_mut","","",23,null],[11,"get","","",24,null],[11,"get_mut","","",24,null],[11,"get_unchecked","","",24,null],[11,"get_unchecked_mut","","",24,null],[11,"index","","",24,null],[11,"index_mut","","",24,null],[11,"get","","",20,null],[11,"get_mut","","",20,null],[11,"get_unchecked","","",20,null],[11,"get_unchecked_mut","","",20,null],[11,"index","","",20,null],[11,"index_mut","","",20,null],[11,"fmt","core::slice","",156,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"as_slice","","View the underlying data as a subslice of the original data.",156,null],[11,"next","","",156,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",156,null],[11,"count","","",156,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"nth","","",156,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"option"}}],[11,"last","","",156,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"try_fold","","",156,{"i":[{"n":"self"},{"n":"b"},{"n":"f"}],"o":{"n":"r"}}],[11,"fold","","",156,{"i":[{"n":"self"},{"n":"acc"},{"n":"fold"}],"o":{"n":"acc"}}],[11,"position","","",156,{"i":[{"n":"self"},{"n":"p"}],"o":{"g":["usize"],"n":"option"}}],[11,"rposition","","",156,{"i":[{"n":"self"},{"n":"p"}],"o":{"g":["usize"],"n":"option"}}],[11,"next_back","","",156,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"try_rfold","","",156,{"i":[{"n":"self"},{"n":"b"},{"n":"f"}],"o":{"n":"r"}}],[11,"rfold","","",156,{"i":[{"n":"self"},{"n":"acc"},{"n":"fold"}],"o":{"n":"acc"}}],[11,"is_empty","","",156,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"clone","","",156,{"i":[{"n":"self"}],"o":{"n":"iter"}}],[11,"as_ref","","",156,null],[11,"fmt","","",157,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"into_slice","","View the underlying data as a subslice of the original data.",157,null],[11,"next","","",157,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",157,null],[11,"count","","",157,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"nth","","",157,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"option"}}],[11,"last","","",157,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"try_fold","","",157,{"i":[{"n":"self"},{"n":"b"},{"n":"f"}],"o":{"n":"r"}}],[11,"fold","","",157,{"i":[{"n":"self"},{"n":"acc"},{"n":"fold"}],"o":{"n":"acc"}}],[11,"position","","",157,{"i":[{"n":"self"},{"n":"p"}],"o":{"g":["usize"],"n":"option"}}],[11,"rposition","","",157,{"i":[{"n":"self"},{"n":"p"}],"o":{"g":["usize"],"n":"option"}}],[11,"next_back","","",157,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"try_rfold","","",157,{"i":[{"n":"self"},{"n":"b"},{"n":"f"}],"o":{"n":"r"}}],[11,"rfold","","",157,{"i":[{"n":"self"},{"n":"acc"},{"n":"fold"}],"o":{"n":"acc"}}],[11,"is_empty","","",157,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"fmt","","",158,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",158,{"i":[{"n":"self"}],"o":{"n":"split"}}],[11,"next","","",158,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",158,null],[11,"next_back","","",158,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"fmt","","",159,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",159,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",159,null],[11,"next_back","","",159,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"clone","","",160,{"i":[{"n":"self"}],"o":{"n":"rsplit"}}],[11,"fmt","","",160,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",160,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",160,null],[11,"next_back","","",160,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"fmt","","",161,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",161,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",161,null],[11,"next_back","","",161,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"fmt","","",162,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",163,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",164,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",165,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",162,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",162,null],[11,"next","","",163,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",163,null],[11,"next","","",164,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",164,null],[11,"next","","",165,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",165,null],[11,"fmt","","",166,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",166,{"i":[{"n":"self"}],"o":{"n":"windows"}}],[11,"next","","",166,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",166,null],[11,"count","","",166,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"nth","","",166,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"option"}}],[11,"last","","",166,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"next_back","","",166,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"fmt","","",167,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",167,{"i":[{"n":"self"}],"o":{"n":"chunks"}}],[11,"next","","",167,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",167,null],[11,"count","","",167,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"nth","","",167,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"option"}}],[11,"last","","",167,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"next_back","","",167,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"fmt","","",168,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",168,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",168,null],[11,"count","","",168,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"nth","","",168,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"option"}}],[11,"last","","",168,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"next_back","","",168,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"fmt","","",169,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",169,{"i":[{"n":"self"}],"o":{"n":"exactchunks"}}],[11,"next","","",169,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",169,null],[11,"count","","",169,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"nth","","",169,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"option"}}],[11,"last","","",169,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"next_back","","",169,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"is_empty","","",169,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"fmt","","",170,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",170,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",170,null],[11,"count","","",170,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"nth","","",170,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"option"}}],[11,"last","","",170,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"next_back","","",170,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"is_empty","","",170,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[0,"str","core","String manipulation",null,null],[3,"ParseBoolError","core::str","An error returned when parsing a `bool` using [`from_str`] fails",null,null],[3,"Utf8Error","","Errors which can occur when attempting to interpret a sequence of [`u8`] as a string.",null,null],[3,"Chars","","An iterator over the [`char`]s of a string slice.",null,null],[3,"CharIndices","","An iterator over the [`char`]s of a string slice, and their positions.",null,null],[3,"Bytes","","An iterator over the bytes of a string slice.",null,null],[3,"Split","","Created with the method [`split`].",null,null],[3,"RSplit","","Created with the method [`rsplit`].",null,null],[3,"SplitTerminator","","Created with the method [`split_terminator`].",null,null],[3,"RSplitTerminator","","Created with the method [`rsplit_terminator`].",null,null],[3,"SplitN","","Created with the method [`splitn`].",null,null],[3,"RSplitN","","Created with the method [`rsplitn`].",null,null],[3,"MatchIndices","","Created with the method [`match_indices`].",null,null],[3,"RMatchIndices","","Created with the method [`rmatch_indices`].",null,null],[3,"Matches","","Created with the method [`matches`].",null,null],[3,"RMatches","","Created with the method [`rmatches`].",null,null],[3,"Lines","","An iterator over the lines of a string, as string slices.",null,null],[3,"LinesAny","","Created with the method [`lines_any`].",null,null],[3,"SplitWhitespace","","An iterator over the non-whitespace substrings of a string, separated by any amount of whitespace.",null,null],[3,"EncodeUtf16","","An iterator of [`u16`] over the string encoded as UTF-16.",null,null],[5,"from_utf8","","Converts a slice of bytes to a string slice.",null,null],[5,"from_utf8_mut","","Converts a mutable slice of bytes to a mutable string slice.",null,null],[5,"from_utf8_unchecked","","Converts a slice of bytes to a string slice without checking that the string contains valid UTF-8.",null,null],[5,"from_utf8_unchecked_mut","","Converts a slice of bytes to a string slice without checking that the string contains valid UTF-8; mutable version.",null,null],[5,"next_code_point","","Reads the next code point out of a byte iterator (assuming a UTF-8-like encoding).",null,{"i":[{"n":"i"}],"o":{"g":["u32"],"n":"option"}}],[5,"utf8_char_width","","Given a first byte, determines how many bytes are in this UTF-8 character.",null,{"i":[{"n":"u8"}],"o":{"n":"usize"}}],[0,"pattern","","The string Pattern API.",null,null],[3,"CharSearcher","core::str::pattern","Associated type for `<char as Pattern<'a>>::Searcher`.",null,null],[3,"CharSliceSearcher","","Associated type for `<&[char] as Pattern<'a>>::Searcher`.",null,null],[3,"CharPredicateSearcher","","Associated type for `<F as Pattern<'a>>::Searcher`.",null,null],[3,"StrSearcher","","Associated type for `<&str as Pattern<'a>>::Searcher`.",null,null],[4,"SearchStep","","Result of calling `Searcher::next()` or `ReverseSearcher::next_back()`.",null,null],[13,"Match","","Expresses that a match of the pattern has been found at `haystack[a..b]`.",171,null],[13,"Reject","","Expresses that `haystack[a..b]` has been rejected as a possible match of the pattern.",171,null],[13,"Done","","Expresses that every byte of the haystack has been visited, ending the iteration.",171,null],[8,"Pattern","","A string pattern.",null,null],[16,"Searcher","","Associated searcher for this pattern",172,null],[10,"into_searcher","","Constructs the associated searcher from `self` and the `haystack` to search in.",172,null],[11,"is_contained_in","","Checks whether the pattern matches anywhere in the haystack",172,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"bool"}}],[11,"is_prefix_of","","Checks whether the pattern matches at the front of the haystack",172,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"bool"}}],[11,"is_suffix_of","","Checks whether the pattern matches at the back of the haystack",172,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"bool"}}],[8,"Searcher","","A searcher for a string pattern.",null,null],[10,"haystack","","Getter for the underlying string to be searched in",173,{"i":[{"n":"self"}],"o":{"n":"str"}}],[10,"next","","Performs the next search step starting from the front.",173,{"i":[{"n":"self"}],"o":{"n":"searchstep"}}],[11,"next_match","","Find the next `Match` result. See `next()`",173,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"next_reject","","Find the next `Reject` result. See `next()` and `next_match()`",173,{"i":[{"n":"self"}],"o":{"n":"option"}}],[8,"ReverseSearcher","","A reverse searcher for a string pattern.",null,null],[10,"next_back","","Performs the next search step starting from the back.",174,{"i":[{"n":"self"}],"o":{"n":"searchstep"}}],[11,"next_match_back","","Find the next `Match` result. See `next_back()`",174,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"next_reject_back","","Find the next `Reject` result. See `next_back()`",174,{"i":[{"n":"self"}],"o":{"n":"option"}}],[8,"DoubleEndedSearcher","","A marker trait to express that a `ReverseSearcher` can be used for a `DoubleEndedIterator` implementation.",null,null],[11,"clone","","",171,{"i":[{"n":"self"}],"o":{"n":"searchstep"}}],[11,"eq","","",171,{"i":[{"n":"self"},{"n":"searchstep"}],"o":{"n":"bool"}}],[11,"ne","","",171,{"i":[{"n":"self"},{"n":"searchstep"}],"o":{"n":"bool"}}],[11,"fmt","","",171,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",175,{"i":[{"n":"self"}],"o":{"n":"charsearcher"}}],[11,"fmt","","",175,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"haystack","","",175,{"i":[{"n":"self"}],"o":{"n":"str"}}],[11,"next","","",175,{"i":[{"n":"self"}],"o":{"n":"searchstep"}}],[11,"next_match","","",175,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"next_back","","",175,{"i":[{"n":"self"}],"o":{"n":"searchstep"}}],[11,"next_match_back","","",175,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"clone","","",176,{"i":[{"n":"self"}],"o":{"n":"charslicesearcher"}}],[11,"fmt","","",176,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"haystack","","",176,{"i":[{"n":"self"}],"o":{"n":"str"}}],[11,"next","","",176,{"i":[{"n":"self"}],"o":{"n":"searchstep"}}],[11,"next_match","","",176,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"next_reject","","",176,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"next_back","","",176,{"i":[{"n":"self"}],"o":{"n":"searchstep"}}],[11,"next_match_back","","",176,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"next_reject_back","","",176,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"clone","","",177,{"i":[{"n":"self"}],"o":{"n":"charpredicatesearcher"}}],[11,"fmt","","",177,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"haystack","","",177,{"i":[{"n":"self"}],"o":{"n":"str"}}],[11,"next","","",177,{"i":[{"n":"self"}],"o":{"n":"searchstep"}}],[11,"next_match","","",177,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"next_reject","","",177,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"next_back","","",177,{"i":[{"n":"self"}],"o":{"n":"searchstep"}}],[11,"next_match_back","","",177,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"next_reject_back","","",177,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"clone","","",178,{"i":[{"n":"self"}],"o":{"n":"strsearcher"}}],[11,"fmt","","",178,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"haystack","","",178,{"i":[{"n":"self"}],"o":{"n":"str"}}],[11,"next","","",178,{"i":[{"n":"self"}],"o":{"n":"searchstep"}}],[11,"next_match","","",178,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"next_back","","",178,{"i":[{"n":"self"}],"o":{"n":"searchstep"}}],[11,"next_match_back","","",178,{"i":[{"n":"self"}],"o":{"n":"option"}}],[0,"lossy","core::str","",null,null],[3,"Utf8Lossy","core::str::lossy","Lossy UTF-8 string.",null,null],[3,"Utf8LossyChunksIter","","Iterator over lossy UTF-8 string",null,null],[3,"Utf8LossyChunk","","",null,null],[12,"valid","","Sequence of valid chars. Can be empty between broken UTF-8 chars.",179,null],[12,"broken","","Single broken char, empty if none. Empty iff iterator item is last.",179,null],[11,"from_str","","",180,{"i":[{"n":"str"}],"o":{"n":"utf8lossy"}}],[11,"from_bytes","","",180,null],[11,"chunks","","",180,{"i":[{"n":"self"}],"o":{"n":"utf8lossychunksiter"}}],[11,"eq","","",179,{"i":[{"n":"self"},{"n":"utf8lossychunk"}],"o":{"n":"bool"}}],[11,"ne","","",179,{"i":[{"n":"self"},{"n":"utf8lossychunk"}],"o":{"n":"bool"}}],[11,"fmt","","",179,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",181,{"i":[{"n":"self"}],"o":{"g":["utf8lossychunk"],"n":"option"}}],[11,"fmt","","",180,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",180,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"get","core::ops","",23,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"option"}}],[11,"get_mut","","",23,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"option"}}],[11,"get_unchecked","","",23,null],[11,"get_unchecked_mut","","",23,null],[11,"index","","",23,null],[11,"index_mut","","",23,null],[11,"get","","",17,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"option"}}],[11,"get_mut","","",17,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"option"}}],[11,"get_unchecked","","",17,null],[11,"get_unchecked_mut","","",17,null],[11,"index","","",17,null],[11,"index_mut","","",17,null],[11,"get","","",19,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"option"}}],[11,"get_mut","","",19,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"option"}}],[11,"get_unchecked","","",19,null],[11,"get_unchecked_mut","","",19,null],[11,"index","","",19,null],[11,"index_mut","","",19,null],[11,"get","","",18,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"option"}}],[11,"get_mut","","",18,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"option"}}],[11,"get_unchecked","","",18,null],[11,"get_unchecked_mut","","",18,null],[11,"index","","",18,null],[11,"index_mut","","",18,null],[11,"get","","",24,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"option"}}],[11,"get_mut","","",24,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"option"}}],[11,"get_unchecked","","",24,null],[11,"get_unchecked_mut","","",24,null],[11,"index","","",24,null],[11,"index_mut","","",24,null],[11,"get","","",20,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"option"}}],[11,"get_mut","","",20,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"option"}}],[11,"get_unchecked","","",20,null],[11,"get_unchecked_mut","","",20,null],[11,"index","","",20,null],[11,"index_mut","","",20,null],[8,"FromStr","core::str","A trait to abstract the idea of creating a new instance of a type from a string.",null,null],[16,"Err","","The associated error which can be returned from parsing.",182,null],[10,"from_str","","Parses a string `s` to return a value of this type.",182,{"i":[{"n":"str"}],"o":{"n":"result"}}],[11,"fmt","","",183,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",183,{"i":[{"n":"self"}],"o":{"n":"parseboolerror"}}],[11,"eq","","",183,{"i":[{"n":"self"},{"n":"parseboolerror"}],"o":{"n":"bool"}}],[11,"ne","","",183,{"i":[{"n":"self"},{"n":"parseboolerror"}],"o":{"n":"bool"}}],[11,"fmt","","",183,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"eq","","",184,{"i":[{"n":"self"},{"n":"utf8error"}],"o":{"n":"bool"}}],[11,"ne","","",184,{"i":[{"n":"self"},{"n":"utf8error"}],"o":{"n":"bool"}}],[11,"clone","","",184,{"i":[{"n":"self"}],"o":{"n":"utf8error"}}],[11,"fmt","","",184,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"valid_up_to","","Returns the index in the given string up to which valid UTF-8 was verified.",184,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"error_len","","Provide more information about the failure:",184,{"i":[{"n":"self"}],"o":{"g":["usize"],"n":"option"}}],[11,"fmt","","",184,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",185,{"i":[{"n":"self"}],"o":{"n":"chars"}}],[11,"fmt","","",185,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",185,{"i":[{"n":"self"}],"o":{"g":["char"],"n":"option"}}],[11,"count","","",185,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"size_hint","","",185,null],[11,"last","","",185,{"i":[{"n":"self"}],"o":{"g":["char"],"n":"option"}}],[11,"next_back","","",185,{"i":[{"n":"self"}],"o":{"g":["char"],"n":"option"}}],[11,"as_str","","View the underlying data as a subslice of the original data.",185,{"i":[{"n":"self"}],"o":{"n":"str"}}],[11,"clone","","",186,{"i":[{"n":"self"}],"o":{"n":"charindices"}}],[11,"fmt","","",186,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",186,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"count","","",186,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"size_hint","","",186,null],[11,"last","","",186,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"next_back","","",186,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"as_str","","View the underlying data as a subslice of the original data.",186,{"i":[{"n":"self"}],"o":{"n":"str"}}],[11,"clone","","",187,{"i":[{"n":"self"}],"o":{"n":"bytes"}}],[11,"fmt","","",187,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",187,{"i":[{"n":"self"}],"o":{"g":["u8"],"n":"option"}}],[11,"size_hint","","",187,null],[11,"count","","",187,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"last","","",187,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"nth","","",187,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"option"}}],[11,"all","","",187,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"bool"}}],[11,"any","","",187,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"bool"}}],[11,"find","","",187,{"i":[{"n":"self"},{"n":"p"}],"o":{"n":"option"}}],[11,"position","","",187,{"i":[{"n":"self"},{"n":"p"}],"o":{"g":["usize"],"n":"option"}}],[11,"rposition","","",187,{"i":[{"n":"self"},{"n":"p"}],"o":{"g":["usize"],"n":"option"}}],[11,"next_back","","",187,{"i":[{"n":"self"}],"o":{"g":["u8"],"n":"option"}}],[11,"rfind","","",187,{"i":[{"n":"self"},{"n":"p"}],"o":{"n":"option"}}],[11,"len","","",187,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"is_empty","","",187,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"fmt","","",188,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",188,{"i":[{"n":"self"}],"o":{"g":["str"],"n":"option"}}],[11,"clone","","",188,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"fmt","","",189,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",189,{"i":[{"n":"self"}],"o":{"g":["str"],"n":"option"}}],[11,"clone","","",189,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"next_back","","",188,{"i":[{"n":"self"}],"o":{"g":["str"],"n":"option"}}],[11,"next_back","","",189,{"i":[{"n":"self"}],"o":{"g":["str"],"n":"option"}}],[11,"fmt","","",190,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",190,{"i":[{"n":"self"}],"o":{"g":["str"],"n":"option"}}],[11,"clone","","",190,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"fmt","","",191,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",191,{"i":[{"n":"self"}],"o":{"g":["str"],"n":"option"}}],[11,"clone","","",191,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"next_back","","",190,{"i":[{"n":"self"}],"o":{"g":["str"],"n":"option"}}],[11,"next_back","","",191,{"i":[{"n":"self"}],"o":{"g":["str"],"n":"option"}}],[11,"fmt","","",192,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",192,{"i":[{"n":"self"}],"o":{"g":["str"],"n":"option"}}],[11,"clone","","",192,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"fmt","","",193,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",193,{"i":[{"n":"self"}],"o":{"g":["str"],"n":"option"}}],[11,"clone","","",193,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"fmt","","",194,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",194,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"clone","","",194,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"fmt","","",195,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",195,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"clone","","",195,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"next_back","","",194,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"next_back","","",195,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"fmt","","",196,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",196,{"i":[{"n":"self"}],"o":{"g":["str"],"n":"option"}}],[11,"clone","","",196,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"fmt","","",197,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",197,{"i":[{"n":"self"}],"o":{"g":["str"],"n":"option"}}],[11,"clone","","",197,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"next_back","","",196,{"i":[{"n":"self"}],"o":{"g":["str"],"n":"option"}}],[11,"next_back","","",197,{"i":[{"n":"self"}],"o":{"g":["str"],"n":"option"}}],[11,"clone","","",198,{"i":[{"n":"self"}],"o":{"n":"lines"}}],[11,"fmt","","",198,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",198,{"i":[{"n":"self"}],"o":{"g":["str"],"n":"option"}}],[11,"size_hint","","",198,null],[11,"next_back","","",198,{"i":[{"n":"self"}],"o":{"g":["str"],"n":"option"}}],[11,"clone","","",199,{"i":[{"n":"self"}],"o":{"n":"linesany"}}],[11,"fmt","","",199,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",199,{"i":[{"n":"self"}],"o":{"g":["str"],"n":"option"}}],[11,"size_hint","","",199,null],[11,"next_back","","",199,{"i":[{"n":"self"}],"o":{"g":["str"],"n":"option"}}],[11,"clone","","",200,{"i":[{"n":"self"}],"o":{"n":"splitwhitespace"}}],[11,"fmt","","",200,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",200,{"i":[{"n":"self"}],"o":{"g":["str"],"n":"option"}}],[11,"next_back","","",200,{"i":[{"n":"self"}],"o":{"g":["str"],"n":"option"}}],[11,"clone","","",201,{"i":[{"n":"self"}],"o":{"n":"encodeutf16"}}],[11,"fmt","","",201,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",201,{"i":[{"n":"self"}],"o":{"g":["u16"],"n":"option"}}],[11,"size_hint","","",201,null],[0,"hash","core","Generic hashing support.",null,null],[3,"SipHasher","core::hash","An implementation of SipHash 2-4.",null,null],[3,"BuildHasherDefault","","Used to create a default [`BuildHasher`] instance for types that implement [`Hasher`] and [`Default`].",null,null],[11,"fmt","","",202,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",202,{"i":[{"n":"self"}],"o":{"n":"siphasher"}}],[11,"default","","",202,{"o":{"n":"siphasher"}}],[11,"new","","Creates a new `SipHasher` with the two initial keys set to 0.",202,{"o":{"n":"siphasher"}}],[11,"new_with_keys","","Creates a `SipHasher` that is keyed off the provided keys.",202,{"i":[{"n":"u64"},{"n":"u64"}],"o":{"n":"siphasher"}}],[11,"write","","",202,null],[11,"finish","","",202,{"i":[{"n":"self"}],"o":{"n":"u64"}}],[8,"Hash","","A hashable type.",null,null],[10,"hash","","Feeds this value into the given [`Hasher`].",203,{"i":[{"n":"self"},{"n":"h"}]}],[11,"hash_slice","","Feeds a slice of this type into the given [`Hasher`].",203,null],[8,"Hasher","","A trait for hashing an arbitrary stream of bytes.",null,null],[10,"finish","","Returns the hash value for the values written so far.",204,{"i":[{"n":"self"}],"o":{"n":"u64"}}],[10,"write","","Writes some data into this `Hasher`.",204,null],[11,"write_u8","","Writes a single `u8` into this hasher.",204,{"i":[{"n":"self"},{"n":"u8"}]}],[11,"write_u16","","Writes a single `u16` into this hasher.",204,{"i":[{"n":"self"},{"n":"u16"}]}],[11,"write_u32","","Writes a single `u32` into this hasher.",204,{"i":[{"n":"self"},{"n":"u32"}]}],[11,"write_u64","","Writes a single `u64` into this hasher.",204,{"i":[{"n":"self"},{"n":"u64"}]}],[11,"write_u128","","Writes a single `u128` into this hasher.",204,{"i":[{"n":"self"},{"n":"u128"}]}],[11,"write_usize","","Writes a single `usize` into this hasher.",204,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"write_i8","","Writes a single `i8` into this hasher.",204,{"i":[{"n":"self"},{"n":"i8"}]}],[11,"write_i16","","Writes a single `i16` into this hasher.",204,{"i":[{"n":"self"},{"n":"i16"}]}],[11,"write_i32","","Writes a single `i32` into this hasher.",204,{"i":[{"n":"self"},{"n":"i32"}]}],[11,"write_i64","","Writes a single `i64` into this hasher.",204,{"i":[{"n":"self"},{"n":"i64"}]}],[11,"write_i128","","Writes a single `i128` into this hasher.",204,{"i":[{"n":"self"},{"n":"i128"}]}],[11,"write_isize","","Writes a single `isize` into this hasher.",204,{"i":[{"n":"self"},{"n":"isize"}]}],[8,"BuildHasher","","A trait for creating instances of [`Hasher`].",null,null],[16,"Hasher","","Type of the hasher that will be created.",205,null],[10,"build_hasher","","Creates a new hasher.",205,null],[11,"fmt","","",206,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"build_hasher","","",206,{"i":[{"n":"self"}],"o":{"n":"h"}}],[11,"clone","","",206,{"i":[{"n":"self"}],"o":{"n":"buildhasherdefault"}}],[11,"default","","",206,{"o":{"n":"buildhasherdefault"}}],[0,"fmt","core","Utilities for formatting and printing strings.",null,null],[3,"DebugStruct","core::fmt","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugTuple","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugSet","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugList","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugMap","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"Error","","The error type which is returned from formatting a message into a stream.",null,null],[3,"Formatter","","A struct to represent both where to emit formatting strings to and how they should be formatted. A mutable version of this is passed to all formatting traits.",null,null],[3,"Arguments","","This structure represents a safely precompiled version of a format string and its arguments. This cannot be generated at runtime because it cannot safely be done, so no constructors are given and the fields are private to prevent modification.",null,null],[4,"Alignment","","Possible alignments returned by `Formatter::align`",null,null],[13,"Left","","Indication that contents should be left-aligned.",207,null],[13,"Right","","Indication that contents should be right-aligned.",207,null],[13,"Center","","Indication that contents should be center-aligned.",207,null],[5,"write","","The `write` function takes an output stream, and an `Arguments` struct that can be precompiled with the `format_args!` macro.",null,{"i":[{"n":"write"},{"n":"arguments"}],"o":{"n":"result"}}],[11,"field","","Adds a new field to the generated struct output.",208,{"i":[{"n":"self"},{"n":"str"},{"n":"debug"}],"o":{"n":"debugstruct"}}],[11,"finish","","Finishes output and returns any error encountered.",208,{"i":[{"n":"self"}],"o":{"n":"result"}}],[11,"field","","Adds a new field to the generated tuple struct output.",209,{"i":[{"n":"self"},{"n":"debug"}],"o":{"n":"debugtuple"}}],[11,"finish","","Finishes output and returns any error encountered.",209,{"i":[{"n":"self"}],"o":{"n":"result"}}],[11,"entry","","Adds a new entry to the set output.",210,{"i":[{"n":"self"},{"n":"debug"}],"o":{"n":"debugset"}}],[11,"entries","","Adds the contents of an iterator of entries to the set output.",210,{"i":[{"n":"self"},{"n":"i"}],"o":{"n":"debugset"}}],[11,"finish","","Finishes output and returns any error encountered.",210,{"i":[{"n":"self"}],"o":{"n":"result"}}],[11,"entry","","Adds a new entry to the list output.",211,{"i":[{"n":"self"},{"n":"debug"}],"o":{"n":"debuglist"}}],[11,"entries","","Adds the contents of an iterator of entries to the list output.",211,{"i":[{"n":"self"},{"n":"i"}],"o":{"n":"debuglist"}}],[11,"finish","","Finishes output and returns any error encountered.",211,{"i":[{"n":"self"}],"o":{"n":"result"}}],[11,"entry","","Adds a new entry to the map output.",212,{"i":[{"n":"self"},{"n":"debug"},{"n":"debug"}],"o":{"n":"debugmap"}}],[11,"entries","","Adds the contents of an iterator of entries to the map output.",212,{"i":[{"n":"self"},{"n":"i"}],"o":{"n":"debugmap"}}],[11,"finish","","Finishes output and returns any error encountered.",212,{"i":[{"n":"self"}],"o":{"n":"result"}}],[6,"Result","","The type returned by formatter methods.",null,null],[8,"Write","","A collection of methods that are required to format a message into a stream.",null,null],[10,"write_str","","Writes a slice of bytes into this writer, returning whether the write succeeded.",213,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"result"}}],[11,"write_char","","Writes a [`char`] into this writer, returning whether the write succeeded.",213,{"i":[{"n":"self"},{"n":"char"}],"o":{"n":"result"}}],[11,"write_fmt","","Glue for usage of the [`write!`] macro with implementors of this trait.",213,{"i":[{"n":"self"},{"n":"arguments"}],"o":{"n":"result"}}],[8,"Debug","","`?` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",214,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[8,"Display","","Format trait for an empty format, `{}`.",null,null],[10,"fmt","","Formats the value using the given formatter.",215,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[8,"Octal","","`o` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",216,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[8,"Binary","","`b` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",217,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[8,"LowerHex","","`x` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",218,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[8,"UpperHex","","`X` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",219,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[8,"Pointer","","`p` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",220,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[8,"LowerExp","","`e` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",221,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[8,"UpperExp","","`E` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",222,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",207,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",223,{"i":[{"n":"self"}],"o":{"n":"error"}}],[11,"fmt","","",223,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"default","","",223,{"o":{"n":"error"}}],[11,"hash","","",223,null],[11,"cmp","","",223,{"i":[{"n":"self"},{"n":"error"}],"o":{"n":"ordering"}}],[11,"eq","","",223,{"i":[{"n":"self"},{"n":"error"}],"o":{"n":"bool"}}],[11,"partial_cmp","","",223,{"i":[{"n":"self"},{"n":"error"}],"o":{"g":["ordering"],"n":"option"}}],[11,"clone","","",224,{"i":[{"n":"self"}],"o":{"n":"arguments"}}],[11,"fmt","","",224,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",224,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"pad_integral","","Performs the correct padding for an integer which has already been emitted into a str. The str should not contain the sign for the integer, that will be added by this method.",225,{"i":[{"n":"self"},{"n":"bool"},{"n":"str"},{"n":"str"}],"o":{"n":"result"}}],[11,"pad","","This function takes a string slice and emits it to the internal buffer after applying the relevant formatting flags specified. The flags recognized for generic strings are:",225,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"result"}}],[11,"write_str","","Writes some data to the underlying buffer contained within this formatter.",225,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"result"}}],[11,"write_fmt","","Writes some formatted information into this instance.",225,{"i":[{"n":"self"},{"n":"arguments"}],"o":{"n":"result"}}],[11,"flags","","Flags for formatting",225,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"fill","","Character used as 'fill' whenever there is alignment.",225,{"i":[{"n":"self"}],"o":{"n":"char"}}],[11,"align","","Flag indicating what form of alignment was requested.",225,{"i":[{"n":"self"}],"o":{"g":["alignment"],"n":"option"}}],[11,"width","","Optionally specified integer width that the output should be.",225,{"i":[{"n":"self"}],"o":{"g":["usize"],"n":"option"}}],[11,"precision","","Optionally specified precision for numeric types.",225,{"i":[{"n":"self"}],"o":{"g":["usize"],"n":"option"}}],[11,"sign_plus","","Determines if the `+` flag was specified.",225,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"sign_minus","","Determines if the `-` flag was specified.",225,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"alternate","","Determines if the `#` flag was specified.",225,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"sign_aware_zero_pad","","Determines if the `0` flag was specified.",225,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"debug_struct","","Creates a [`DebugStruct`] builder designed to assist with creation of [`fmt::Debug`] implementations for structs.",225,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"debugstruct"}}],[11,"debug_tuple","","Creates a `DebugTuple` builder designed to assist with creation of `fmt::Debug` implementations for tuple structs.",225,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"debugtuple"}}],[11,"debug_list","","Creates a `DebugList` builder designed to assist with creation of `fmt::Debug` implementations for list-like structures.",225,{"i":[{"n":"self"}],"o":{"n":"debuglist"}}],[11,"debug_set","","Creates a `DebugSet` builder designed to assist with creation of `fmt::Debug` implementations for set-like structures.",225,{"i":[{"n":"self"}],"o":{"n":"debugset"}}],[11,"debug_map","","Creates a `DebugMap` builder designed to assist with creation of `fmt::Debug` implementations for map-like structures.",225,{"i":[{"n":"self"}],"o":{"n":"debugmap"}}],[11,"write_str","","",225,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"result"}}],[11,"write_char","","",225,{"i":[{"n":"self"},{"n":"char"}],"o":{"n":"result"}}],[11,"write_fmt","","",225,{"i":[{"n":"self"},{"n":"arguments"}],"o":{"n":"result"}}],[11,"fmt","","",223,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","core::marker","",15,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","core::cell","",91,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",94,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",95,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",96,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",97,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[0,"time","core","Temporal quantification.",null,null],[3,"Duration","core::time","A `Duration` type to represent a span of time, typically used for system timeouts.",null,null],[11,"clone","","",226,{"i":[{"n":"self"}],"o":{"n":"duration"}}],[11,"eq","","",226,{"i":[{"n":"self"},{"n":"duration"}],"o":{"n":"bool"}}],[11,"ne","","",226,{"i":[{"n":"self"},{"n":"duration"}],"o":{"n":"bool"}}],[11,"partial_cmp","","",226,{"i":[{"n":"self"},{"n":"duration"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",226,{"i":[{"n":"self"},{"n":"duration"}],"o":{"n":"bool"}}],[11,"le","","",226,{"i":[{"n":"self"},{"n":"duration"}],"o":{"n":"bool"}}],[11,"gt","","",226,{"i":[{"n":"self"},{"n":"duration"}],"o":{"n":"bool"}}],[11,"ge","","",226,{"i":[{"n":"self"},{"n":"duration"}],"o":{"n":"bool"}}],[11,"cmp","","",226,{"i":[{"n":"self"},{"n":"duration"}],"o":{"n":"ordering"}}],[11,"hash","","",226,null],[11,"default","","",226,{"o":{"n":"duration"}}],[11,"new","","Creates a new `Duration` from the specified number of whole seconds and additional nanoseconds.",226,{"i":[{"n":"u64"},{"n":"u32"}],"o":{"n":"duration"}}],[11,"from_secs","","Creates a new `Duration` from the specified number of whole seconds.",226,{"i":[{"n":"u64"}],"o":{"n":"duration"}}],[11,"from_millis","","Creates a new `Duration` from the specified number of milliseconds.",226,{"i":[{"n":"u64"}],"o":{"n":"duration"}}],[11,"from_micros","","Creates a new `Duration` from the specified number of microseconds.",226,{"i":[{"n":"u64"}],"o":{"n":"duration"}}],[11,"from_nanos","","Creates a new `Duration` from the specified number of nanoseconds.",226,{"i":[{"n":"u64"}],"o":{"n":"duration"}}],[11,"as_secs","","Returns the number of whole seconds contained by this `Duration`.",226,{"i":[{"n":"self"}],"o":{"n":"u64"}}],[11,"subsec_millis","","Returns the fractional part of this `Duration`, in milliseconds.",226,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"subsec_micros","","Returns the fractional part of this `Duration`, in microseconds.",226,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"subsec_nanos","","Returns the fractional part of this `Duration`, in nanoseconds.",226,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"as_millis","","Returns the total number of milliseconds contained by this `Duration`.",226,{"i":[{"n":"self"}],"o":{"n":"u128"}}],[11,"as_micros","","Returns the total number of microseconds contained by this `Duration`.",226,{"i":[{"n":"self"}],"o":{"n":"u128"}}],[11,"as_nanos","","Returns the total number of nanoseconds contained by this `Duration`.",226,{"i":[{"n":"self"}],"o":{"n":"u128"}}],[11,"checked_add","","Checked `Duration` addition. Computes `self + other`, returning [`None`] if overflow occurred.",226,{"i":[{"n":"self"},{"n":"duration"}],"o":{"g":["duration"],"n":"option"}}],[11,"checked_sub","","Checked `Duration` subtraction. Computes `self - other`, returning [`None`] if the result would be negative or if overflow occurred.",226,{"i":[{"n":"self"},{"n":"duration"}],"o":{"g":["duration"],"n":"option"}}],[11,"checked_mul","","Checked `Duration` multiplication. Computes `self * other`, returning [`None`] if overflow occurred.",226,{"i":[{"n":"self"},{"n":"u32"}],"o":{"g":["duration"],"n":"option"}}],[11,"checked_div","","Checked `Duration` division. Computes `self / other`, returning [`None`] if `other == 0`.",226,{"i":[{"n":"self"},{"n":"u32"}],"o":{"g":["duration"],"n":"option"}}],[11,"add","","",226,{"i":[{"n":"self"},{"n":"duration"}],"o":{"n":"duration"}}],[11,"add_assign","","",226,{"i":[{"n":"self"},{"n":"duration"}]}],[11,"sub","","",226,{"i":[{"n":"self"},{"n":"duration"}],"o":{"n":"duration"}}],[11,"sub_assign","","",226,{"i":[{"n":"self"},{"n":"duration"}]}],[11,"mul","","",226,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"duration"}}],[11,"mul_assign","","",226,{"i":[{"n":"self"},{"n":"u32"}]}],[11,"div","","",226,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"duration"}}],[11,"div_assign","","",226,{"i":[{"n":"self"},{"n":"u32"}]}],[11,"sum","","",226,{"i":[{"n":"i"}],"o":{"n":"duration"}}],[11,"sum","","",226,{"i":[{"n":"i"}],"o":{"n":"duration"}}],[11,"fmt","","",226,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[0,"unicode","core","",null,null],[11,"clone","core::char","",98,{"i":[{"n":"self"}],"o":{"n":"unicodeversion"}}],[11,"fmt","","",98,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"cmp","","",98,{"i":[{"n":"self"},{"n":"unicodeversion"}],"o":{"n":"ordering"}}],[11,"eq","","",98,{"i":[{"n":"self"},{"n":"unicodeversion"}],"o":{"n":"bool"}}],[11,"ne","","",98,{"i":[{"n":"self"},{"n":"unicodeversion"}],"o":{"n":"bool"}}],[11,"partial_cmp","","",98,{"i":[{"n":"self"},{"n":"unicodeversion"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",98,{"i":[{"n":"self"},{"n":"unicodeversion"}],"o":{"n":"bool"}}],[11,"le","","",98,{"i":[{"n":"self"},{"n":"unicodeversion"}],"o":{"n":"bool"}}],[11,"gt","","",98,{"i":[{"n":"self"},{"n":"unicodeversion"}],"o":{"n":"bool"}}],[11,"ge","","",98,{"i":[{"n":"self"},{"n":"unicodeversion"}],"o":{"n":"bool"}}],[0,"derived_property","core::unicode","",null,null],[5,"Case_Ignorable","core::unicode::derived_property","",null,{"i":[{"n":"char"}],"o":{"n":"bool"}}],[5,"Cased","","",null,{"i":[{"n":"char"}],"o":{"n":"bool"}}],[0,"property","core::unicode","",null,null],[5,"Pattern_White_Space","core::unicode::property","",null,{"i":[{"n":"char"}],"o":{"n":"bool"}}],[0,"future","core","Asynchronous values.",null,null],[8,"Future","core::future","A future represents an asychronous computation.",null,null],[16,"Output","","The result of the `Future`.",227,null],[10,"poll","","Attempt to resolve the future to a final value, registering the current task for wakeup if the value is not yet available.",227,{"i":[{"n":"pinmut"},{"n":"context"}],"o":{"n":"poll"}}],[11,"poll","core::mem","",13,{"i":[{"n":"pinmut"},{"n":"context"}],"o":{"n":"poll"}}],[0,"task","core","Types and Traits for working with asynchronous tasks.",null,null],[3,"Waker","core::task","A `Waker` is a handle for waking up a task by notifying its executor that it is ready to be run.",null,null],[3,"LocalWaker","","A `LocalWaker` is a handle for waking up a task by notifying its executor that it is ready to be run.",null,null],[3,"Context","","Information about the currently-running task.",null,null],[3,"TaskObj","","A custom trait object for polling tasks, roughly akin to `Box<Future<Output = ()> + Send>`.",null,null],[3,"SpawnErrorKind","","Provides the reason that an executor was unable to spawn.",null,null],[3,"SpawnObjError","","The result of a failed spawn",null,null],[12,"kind","","The kind of error",228,null],[12,"task","","The task for which spawning was attempted",228,null],[4,"Poll","","Indicates whether a value is available or if the current task has been scheduled to receive a wakeup instead.",null,null],[13,"Ready","","Represents that a value is immediately ready.",229,null],[13,"Pending","","Represents that a value is not ready yet.",229,null],[8,"UnsafeWake","","An unsafe trait for implementing custom memory management for a `Waker` or `LocalWaker`.",null,null],[10,"clone_raw","","Creates a clone of this `UnsafeWake` and stores it behind a `Waker`.",230,{"i":[{"n":"self"}],"o":{"n":"waker"}}],[10,"drop_raw","","Drops this instance of `UnsafeWake`, deallocating resources associated with it.",230,{"i":[{"n":"self"}]}],[10,"wake","","Indicates that the associated task is ready to make progress and should be `poll`ed.",230,{"i":[{"n":"self"}]}],[11,"wake_local","","Indicates that the associated task is ready to make progress and should be `poll`ed. This function is the same as `wake`, but can only be called from the thread that this `UnsafeWake` is \"local\" to. This allows for implementors to provide specialized wakeup behavior specific to the current thread. This function is called by `LocalWaker::wake`.",230,{"i":[{"n":"self"}]}],[8,"Executor","","A task executor.",null,null],[10,"spawn_obj","","Spawn the given task, polling it until completion.",231,{"i":[{"n":"self"},{"n":"taskobj"}],"o":{"g":["spawnobjerror"],"n":"result"}}],[11,"status","","Determine whether the executor is able to spawn new tasks.",231,{"i":[{"n":"self"}],"o":{"g":["spawnerrorkind"],"n":"result"}}],[8,"UnsafeTask","","A custom implementation of a task trait object for `TaskObj`, providing a hand-rolled vtable.",null,null],[10,"into_raw","","Convert a owned instance into a (conceptually owned) void pointer.",232,null],[10,"poll","","Poll the task represented by the given void pointer.",232,null],[10,"drop","","Drops the task represented by the given void pointer.",232,null],[11,"clone","","",229,{"i":[{"n":"self"}],"o":{"n":"poll"}}],[11,"fmt","","",229,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"eq","","",229,{"i":[{"n":"self"},{"n":"poll"}],"o":{"n":"bool"}}],[11,"ne","","",229,{"i":[{"n":"self"},{"n":"poll"}],"o":{"n":"bool"}}],[11,"cmp","","",229,{"i":[{"n":"self"},{"n":"poll"}],"o":{"n":"ordering"}}],[11,"partial_cmp","","",229,{"i":[{"n":"self"},{"n":"poll"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",229,{"i":[{"n":"self"},{"n":"poll"}],"o":{"n":"bool"}}],[11,"le","","",229,{"i":[{"n":"self"},{"n":"poll"}],"o":{"n":"bool"}}],[11,"gt","","",229,{"i":[{"n":"self"},{"n":"poll"}],"o":{"n":"bool"}}],[11,"ge","","",229,{"i":[{"n":"self"},{"n":"poll"}],"o":{"n":"bool"}}],[11,"hash","","",229,null],[11,"map","","Change the ready value of this `Poll` with the closure provided",229,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"poll"}}],[11,"is_ready","","Returns whether this is `Poll::Ready`",229,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"is_pending","","Returns whether this is `Poll::Pending`",229,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"map_ok","","Change the success value of this `Poll` with the closure provided",229,{"i":[{"n":"self"},{"n":"f"}],"o":{"g":["result"],"n":"poll"}}],[11,"map_err","","Change the error value of this `Poll` with the closure provided",229,{"i":[{"n":"self"},{"n":"f"}],"o":{"g":["result"],"n":"poll"}}],[11,"from","","",229,{"i":[{"n":"t"}],"o":{"n":"poll"}}],[11,"new","","Constructs a new `Waker` directly.",233,{"i":[{"g":["unsafewake"],"n":"nonnull"}],"o":{"n":"self"}}],[11,"wake","","Wake up the task associated with this `Waker`.",233,{"i":[{"n":"self"}]}],[11,"will_wake","","Returns whether or not this `Waker` and `other` awaken the same task.",233,{"i":[{"n":"self"},{"n":"waker"}],"o":{"n":"bool"}}],[11,"clone","","",233,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"fmt","","",233,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"drop","","",233,{"i":[{"n":"self"}]}],[11,"new","","Constructs a new `LocalWaker` directly.",234,{"i":[{"g":["unsafewake"],"n":"nonnull"}],"o":{"n":"self"}}],[11,"wake","","Wake up the task associated with this `LocalWaker`.",234,{"i":[{"n":"self"}]}],[11,"will_wake","","Returns whether or not this `LocalWaker` and `other` `LocalWaker` awaken the same task.",234,{"i":[{"n":"self"},{"n":"localwaker"}],"o":{"n":"bool"}}],[11,"will_wake_nonlocal","","Returns whether or not this `LocalWaker` and `other` `Waker` awaken the same task.",234,{"i":[{"n":"self"},{"n":"waker"}],"o":{"n":"bool"}}],[11,"from","","",233,{"i":[{"n":"localwaker"}],"o":{"n":"self"}}],[11,"clone","","",234,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"fmt","","",234,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"drop","","",234,{"i":[{"n":"self"}]}],[11,"fmt","","",235,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","Create a new task `Context` with the provided `local_waker`, `waker`, and `executor`.",235,{"i":[{"n":"localwaker"},{"n":"executor"}],"o":{"n":"context"}}],[11,"local_waker","","Get the `LocalWaker` associated with the current task.",235,{"i":[{"n":"self"}],"o":{"n":"localwaker"}}],[11,"waker","","Get the `Waker` associated with the current task.",235,{"i":[{"n":"self"}],"o":{"n":"waker"}}],[11,"executor","","Get the default executor associated with this task.",235,{"i":[{"n":"self"}],"o":{"n":"executor"}}],[11,"with_waker","","Produce a context like the current one, but using the given waker instead.",235,{"i":[{"n":"self"},{"n":"localwaker"}],"o":{"n":"context"}}],[11,"with_executor","","Produce a context like the current one, but using the given executor instead.",235,{"i":[{"n":"self"},{"n":"e"}],"o":{"n":"context"}}],[11,"fmt","","",236,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","Create a `TaskObj` from a custom trait object representation.",236,{"i":[{"n":"t"}],"o":{"n":"taskobj"}}],[11,"poll","","",236,{"i":[{"n":"pinmut"},{"n":"context"}],"o":{"n":"poll"}}],[11,"drop","","",236,{"i":[{"n":"self"}]}],[11,"fmt","","",237,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"shutdown","","Spawning is failing because the executor has been shut down.",237,{"o":{"n":"spawnerrorkind"}}],[11,"is_shutdown","","Check whether this error is the `shutdown` error.",237,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"fmt","","",228,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[0,"alloc","core","Memory allocation APIs",null,null],[3,"Excess","core::alloc","Represents the combination of a starting address and a total capacity of the returned block.",null,null],[12,"0","","",238,null],[12,"1","","",238,null],[3,"Layout","","Layout of a block of memory.",null,null],[3,"LayoutErr","","The parameters given to `Layout::from_size_align` or some other `Layout` constructor do not satisfy its documented constraints.",null,null],[3,"AllocErr","","The `AllocErr` error indicates an allocation failure that may be due to resource exhaustion or to something wrong when combining the given input arguments with this allocator.",null,null],[3,"CannotReallocInPlace","","The `CannotReallocInPlace` error is used when `grow_in_place` or `shrink_in_place` were unable to reuse the given memory block for a requested layout.",null,null],[4,"CollectionAllocErr","","Augments `AllocErr` with a CapacityOverflow variant.",null,null],[13,"CapacityOverflow","","Error due to the computed capacity exceeding the collection's maximum (usually `isize::MAX` bytes).",239,null],[13,"AllocErr","","Error due to the allocator (see the `AllocErr` type's docs).",239,null],[8,"GlobalAlloc","","A memory allocator that can be registered as the standard library’s default though the `#[global_allocator]` attributes.",null,null],[10,"alloc","","Allocate memory as described by the given `layout`.",240,null],[10,"dealloc","","Deallocate the block of memory at the given `ptr` pointer with the given `layout`.",240,null],[11,"alloc_zeroed","","Behaves like `alloc`, but also ensures that the contents are set to zero before being returned.",240,null],[11,"realloc","","Shink or grow a block of memory to the given `new_size`. The block is described by the given `ptr` pointer and `layout`.",240,null],[8,"Alloc","","An implementation of `Alloc` can allocate, reallocate, and deallocate arbitrary blocks of data described via `Layout`.",null,null],[10,"alloc","","Returns a pointer meeting the size and alignment guarantees of `layout`.",241,{"i":[{"n":"self"},{"n":"layout"}],"o":{"g":["nonnull","allocerr"],"n":"result"}}],[10,"dealloc","","Deallocate the memory referenced by `ptr`.",241,{"i":[{"n":"self"},{"g":["u8"],"n":"nonnull"},{"n":"layout"}]}],[11,"usable_size","","Returns bounds on the guaranteed usable size of a successful allocation created with the specified `layout`.",241,null],[11,"realloc","","Returns a pointer suitable for holding data described by a new layout with `layout`’s alginment and a size given by `new_size`. To accomplish this, this may extend or shrink the allocation referenced by `ptr` to fit the new layout.",241,{"i":[{"n":"self"},{"g":["u8"],"n":"nonnull"},{"n":"layout"},{"n":"usize"}],"o":{"g":["nonnull","allocerr"],"n":"result"}}],[11,"alloc_zeroed","","Behaves like `alloc`, but also ensures that the contents are set to zero before being returned.",241,{"i":[{"n":"self"},{"n":"layout"}],"o":{"g":["nonnull","allocerr"],"n":"result"}}],[11,"alloc_excess","","Behaves like `alloc`, but also returns the whole size of the returned block. For some `layout` inputs, like arrays, this may include extra storage usable for additional data.",241,{"i":[{"n":"self"},{"n":"layout"}],"o":{"g":["excess","allocerr"],"n":"result"}}],[11,"realloc_excess","","Behaves like `realloc`, but also returns the whole size of the returned block. For some `layout` inputs, like arrays, this may include extra storage usable for additional data.",241,{"i":[{"n":"self"},{"g":["u8"],"n":"nonnull"},{"n":"layout"},{"n":"usize"}],"o":{"g":["excess","allocerr"],"n":"result"}}],[11,"grow_in_place","","Attempts to extend the allocation referenced by `ptr` to fit `new_size`.",241,{"i":[{"n":"self"},{"g":["u8"],"n":"nonnull"},{"n":"layout"},{"n":"usize"}],"o":{"g":["cannotreallocinplace"],"n":"result"}}],[11,"shrink_in_place","","Attempts to shrink the allocation referenced by `ptr` to fit `new_size`.",241,{"i":[{"n":"self"},{"g":["u8"],"n":"nonnull"},{"n":"layout"},{"n":"usize"}],"o":{"g":["cannotreallocinplace"],"n":"result"}}],[11,"alloc_one","","Allocates a block suitable for holding an instance of `T`.",241,{"i":[{"n":"self"}],"o":{"g":["nonnull","allocerr"],"n":"result"}}],[11,"dealloc_one","","Deallocates a block suitable for holding an instance of `T`.",241,{"i":[{"n":"self"},{"n":"nonnull"}]}],[11,"alloc_array","","Allocates a block suitable for holding `n` instances of `T`.",241,{"i":[{"n":"self"},{"n":"usize"}],"o":{"g":["nonnull","allocerr"],"n":"result"}}],[11,"realloc_array","","Reallocates a block previously suitable for holding `n_old` instances of `T`, returning a block suitable for holding `n_new` instances of `T`.",241,{"i":[{"n":"self"},{"n":"nonnull"},{"n":"usize"},{"n":"usize"}],"o":{"g":["nonnull","allocerr"],"n":"result"}}],[11,"dealloc_array","","Deallocates a block suitable for holding `n` instances of `T`.",241,{"i":[{"n":"self"},{"n":"nonnull"},{"n":"usize"}],"o":{"g":["allocerr"],"n":"result"}}],[11,"fmt","","",238,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",242,{"i":[{"n":"self"}],"o":{"n":"layout"}}],[11,"fmt","","",242,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"eq","","",242,{"i":[{"n":"self"},{"n":"layout"}],"o":{"n":"bool"}}],[11,"ne","","",242,{"i":[{"n":"self"},{"n":"layout"}],"o":{"n":"bool"}}],[11,"from_size_align","","Constructs a `Layout` from a given `size` and `align`, or returns `LayoutErr` if either of the following conditions are not met:",242,{"i":[{"n":"usize"},{"n":"usize"}],"o":{"g":["layouterr"],"n":"result"}}],[11,"from_size_align_unchecked","","Creates a layout, bypassing all checks.",242,{"i":[{"n":"usize"},{"n":"usize"}],"o":{"n":"self"}}],[11,"size","","The minimum size in bytes for a memory block of this layout.",242,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"align","","The minimum byte alignment for a memory block of this layout.",242,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"new","","Constructs a `Layout` suitable for holding a value of type `T`.",242,{"o":{"n":"self"}}],[11,"for_value","","Produces layout describing a record that could be used to allocate backing structure for `T` (which could be a trait or other unsized type like a slice).",242,{"i":[{"n":"t"}],"o":{"n":"self"}}],[11,"align_to","","Creates a layout describing the record that can hold a value of the same layout as `self`, but that also is aligned to alignment `align` (measured in bytes).",242,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"self"}}],[11,"padding_needed_for","","Returns the amount of padding we must insert after `self` to ensure that the following address will satisfy `align` (measured in bytes).",242,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"usize"}}],[11,"repeat","","Creates a layout describing the record for `n` instances of `self`, with a suitable amount of padding between each to ensure that each instance is given its requested size and alignment. On success, returns `(k, offs)` where `k` is the layout of the array and `offs` is the distance between the start of each element in the array.",242,{"i":[{"n":"self"},{"n":"usize"}],"o":{"g":["layouterr"],"n":"result"}}],[11,"extend","","Creates a layout describing the record for `self` followed by `next`, including any necessary padding to ensure that `next` will be properly aligned. Note that the result layout will satisfy the alignment properties of both `self` and `next`.",242,{"i":[{"n":"self"},{"n":"self"}],"o":{"g":["layouterr"],"n":"result"}}],[11,"repeat_packed","","Creates a layout describing the record for `n` instances of `self`, with no padding between each instance.",242,{"i":[{"n":"self"},{"n":"usize"}],"o":{"g":["layouterr"],"n":"result"}}],[11,"extend_packed","","Creates a layout describing the record for `self` followed by `next` with no additional padding between the two. Since no padding is inserted, the alignment of `next` is irrelevant, and is not incorporated at all into the resulting layout.",242,{"i":[{"n":"self"},{"n":"self"}],"o":{"g":["layouterr"],"n":"result"}}],[11,"array","","Creates a layout describing the record for a `[T; n]`.",242,{"i":[{"n":"usize"}],"o":{"g":["layouterr"],"n":"result"}}],[11,"clone","","",243,{"i":[{"n":"self"}],"o":{"n":"layouterr"}}],[11,"eq","","",243,{"i":[{"n":"self"},{"n":"layouterr"}],"o":{"n":"bool"}}],[11,"ne","","",243,{"i":[{"n":"self"},{"n":"layouterr"}],"o":{"n":"bool"}}],[11,"fmt","","",243,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",243,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",244,{"i":[{"n":"self"}],"o":{"n":"allocerr"}}],[11,"eq","","",244,{"i":[{"n":"self"},{"n":"allocerr"}],"o":{"n":"bool"}}],[11,"fmt","","",244,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",244,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",245,{"i":[{"n":"self"}],"o":{"n":"cannotreallocinplace"}}],[11,"eq","","",245,{"i":[{"n":"self"},{"n":"cannotreallocinplace"}],"o":{"n":"bool"}}],[11,"fmt","","",245,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"description","","",245,{"i":[{"n":"self"}],"o":{"n":"str"}}],[11,"fmt","","",245,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",239,{"i":[{"n":"self"}],"o":{"n":"collectionallocerr"}}],[11,"eq","","",239,{"i":[{"n":"self"},{"n":"collectionallocerr"}],"o":{"n":"bool"}}],[11,"fmt","","",239,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"from","","",239,{"i":[{"n":"allocerr"}],"o":{"n":"self"}}],[11,"from","","",239,{"i":[{"n":"layouterr"}],"o":{"n":"self"}}],[0,"simd","core","Platform independent SIMD vector types and operations.",null,null],[3,"i8x16","core::simd","A 128-bit vector with 16 `i8` lanes.",null,null],[3,"u8x16","","A 128-bit vector with 16 `u8` lanes.",null,null],[3,"m8x16","","A 128-bit vector mask with 16 lanes.",null,null],[3,"i16x8","","A 128-bit vector with 8 `i16` lanes.",null,null],[3,"u16x8","","A 128-bit vector with 8 `u16` lanes.",null,null],[3,"m16x8","","A 128-bit vector mask with 8 lanes.",null,null],[3,"i32x4","","A 128-bit vector with 4 `i32` lanes.",null,null],[3,"u32x4","","A 128-bit vector with 4 `u32` lanes.",null,null],[3,"f32x4","","A 128-bit vector with 4 `f32` lanes.",null,null],[3,"m32x4","","A 128-bit vector mask with 4 lanes.",null,null],[3,"i64x2","","A 128-bit vector with 2 `u64` lanes.",null,null],[3,"u64x2","","A 128-bit vector with 2 `u64` lanes.",null,null],[3,"f64x2","","A 128-bit vector with 2 `f64` lanes.",null,null],[3,"m64x2","","A 128-bit vector mask with 2 lanes.",null,null],[3,"i8x2","","A 16-bit wide vector with 2 `i8` lanes.",null,null],[3,"u8x2","","A 16-bit wide vector with 2 `u8` lanes.",null,null],[3,"m8x2","","A 16-bit wide vector mask with 2 lanes.",null,null],[3,"i8x32","","A 256-bit vector with 32 `i8` lanes.",null,null],[3,"u8x32","","A 256-bit vector with 32 `u8` lanes.",null,null],[3,"m8x32","","A 256-bit vector mask with 32 lanes.",null,null],[3,"i16x16","","A 256-bit vector with 16 `i16` lanes.",null,null],[3,"u16x16","","A 256-bit vector with 16 `u16` lanes.",null,null],[3,"m16x16","","A 256-bit vector mask with 16 lanes.",null,null],[3,"i32x8","","A 256-bit vector with 8 `i32` lanes.",null,null],[3,"u32x8","","A 256-bit vector with 8 `u32` lanes.",null,null],[3,"f32x8","","A 256-bit vector with 8 `f32` lanes.",null,null],[3,"m32x8","","A 256-bit vector mask with 8 lanes.",null,null],[3,"i64x4","","A 256-bit vector with 4 `i64` lanes.",null,null],[3,"u64x4","","A 256-bit vector with 4 `u64` lanes.",null,null],[3,"f64x4","","A 256-bit vector with 4 `f64` lanes.",null,null],[3,"m64x4","","A 256-bit vector mask with 4 lanes.",null,null],[3,"i16x2","","A 32-bit wide vector with 2 `i16` lanes.",null,null],[3,"u16x2","","A 32-bit wide vector with 2 `u16` lanes.",null,null],[3,"m16x2","","A 32-bit wide vector mask with 2 lanes.",null,null],[3,"i8x4","","A 32-bit wide vector with 4 `i8` lanes.",null,null],[3,"u8x4","","A 32-bit wide vector with 4 `u8` lanes.",null,null],[3,"m8x4","","A 32-bit wide vector mask 4 lanes.",null,null],[3,"i8x64","","A 512-bit vector with 64 `i8` lanes.",null,null],[3,"u8x64","","A 512-bit vector with 64 `u8` lanes.",null,null],[3,"m1x64","","A 64-bit vector mask with 64 lanes (FIXME: 512-bit wide).",null,null],[3,"i16x32","","A 512-bit vector with 32 `i16` lanes.",null,null],[3,"u16x32","","A 512-bit vector with 32 `u16` lanes.",null,null],[3,"m1x32","","A 32-bit vector mask with 32 lanes (FIXME: 512-bit wide).",null,null],[3,"i32x16","","A 512-bit vector with 16 `i32` lanes.",null,null],[3,"u32x16","","A 512-bit vector with 16 `u32` lanes.",null,null],[3,"f32x16","","A 512-bit vector with 16 `f32` lanes.",null,null],[3,"m1x16","","A 16-bit vector mask with 16 lanes (FIXME: 512-bit wide).",null,null],[3,"i64x8","","A 512-bit vector with 8 `i64` lanes.",null,null],[3,"u64x8","","A 512-bit vector with 8 `u64` lanes.",null,null],[3,"f64x8","","A 512-bit vector with 8 `f64` lanes.",null,null],[3,"m1x8","","A 8-bit vector mask with 8 lanes (FIXME: 512-bit wide).",null,null],[3,"i8x8","","A 64-bit vector with 8 `i8` lanes.",null,null],[3,"u8x8","","A 64-bit vector with 8 `u8` lanes.",null,null],[3,"m8x8","","A 64-bit vector mask with 8 lanes.",null,null],[3,"i16x4","","A 64-bit vector with 4 `i16` lanes.",null,null],[3,"u16x4","","A 64-bit vector with 4 `u16` lanes.",null,null],[3,"m16x4","","A 64-bit vector mask with 4 lanes.",null,null],[3,"i32x2","","A 64-bit vector with 2 `i32` lanes.",null,null],[3,"u32x2","","A 64-bit vector with 2 `u32` lanes.",null,null],[3,"m32x2","","A 64-bit vector mask with 2 lanes.",null,null],[3,"f32x2","","A 64-bit vector with 2 `f32` lanes.",null,null],[8,"FromBits","","Safe lossless bitwise conversion from `T` to `Self`.",null,null],[10,"from_bits","","Safe lossless bitwise from `T` to `Self`.",246,{"i":[{"n":"t"}],"o":{"n":"self"}}],[8,"IntoBits","","Safe lossless bitwise conversion from `Self` to `T`.",null,null],[10,"into_bits","","Safe lossless bitwise transmute from `self` to `T`.",247,{"i":[{"n":"self"}],"o":{"n":"t"}}],[0,"arch","core","Platform dependent vendor intrinsics.",null,null],[0,"x86","core::arch","Platform-specific intrinsics for the `x86` platform.",null,null],[3,"__m64","core::arch::x86","64-bit wide integer vector type, x86-specific",null,null],[3,"__m128i","","128-bit wide integer vector type, x86-specific",null,null],[3,"__m128","","128-bit wide set of four `f32` types, x86-specific",null,null],[3,"__m128d","","128-bit wide set of two `f64` types, x86-specific",null,null],[3,"__m256i","","256-bit wide integer vector type, x86-specific",null,null],[3,"__m256","","256-bit wide set of eight `f32` types, x86-specific",null,null],[3,"__m256d","","256-bit wide set of four `f64` types, x86-specific",null,null],[3,"CpuidResult","","Result of the `cpuid` instruction.",null,null],[12,"eax","","EAX register.",248,null],[12,"ebx","","EBX register.",248,null],[12,"ecx","","ECX register.",248,null],[12,"edx","","EDX register.",248,null],[5,"__readeflags","","Reads EFLAGS.",null,{"o":{"n":"u64"}}],[5,"__writeeflags","","Write EFLAGS.",null,{"i":[{"n":"u64"}]}],[5,"_fxsave","","Saves the `x87` FPU, `MMX` technology, `XMM`, and `MXCSR` registers to the 512-byte-long 16-byte-aligned memory region `mem_addr`.",null,null],[5,"_fxrstor","","Restores the `XMM`, `MMX`, `MXCSR`, and `x87` FPU registers from the 512-byte-long 16-byte-aligned memory region `mem_addr`.",null,null],[5,"_bswap","","Return an integer with the reversed byte order of x",null,{"i":[{"n":"i32"}],"o":{"n":"i32"}}],[5,"_rdtsc","","Reads the current value of the processor’s time-stamp counter.",null,{"o":{"n":"i64"}}],[5,"__rdtscp","","Reads the current value of the processor’s time-stamp counter and the `IA32_TSC_AUX MSR`.",null,null],[5,"__cpuid_count","","Returns the result of the `cpuid` instruction for a given `leaf` (`EAX`) and `sub_leaf` (`ECX`).",null,{"i":[{"n":"u32"},{"n":"u32"}],"o":{"n":"cpuidresult"}}],[5,"__cpuid","","See `__cpuid_count`.",null,{"i":[{"n":"u32"}],"o":{"n":"cpuidresult"}}],[5,"has_cpuid","","Does the host support the `cpuid` instruction?",null,{"o":{"n":"bool"}}],[5,"__get_cpuid_max","","Returns the highest-supported `leaf` (`EAX`) and sub-leaf (`ECX`) `cpuid` values.",null,null],[5,"_xsave","","Perform a full or partial save of the enabled processor states to memory at `mem_addr`.",null,null],[5,"_xrstor","","Perform a full or partial restore of the enabled processor states using the state information stored in memory at `mem_addr`.",null,null],[5,"_xsetbv","","Copy 64-bits from `val` to the extended control register (`XCR`) specified by `a`.",null,{"i":[{"n":"u32"},{"n":"u64"}]}],[5,"_xgetbv","","Reads the contents of the extended control register `XCR` specified in `xcr_no`.",null,{"i":[{"n":"u32"}],"o":{"n":"u64"}}],[5,"_xsaveopt","","Perform a full or partial save of the enabled processor states to memory at `mem_addr`.",null,null],[5,"_xsavec","","Perform a full or partial save of the enabled processor states to memory at `mem_addr`.",null,null],[5,"_xsaves","","Perform a full or partial save of the enabled processor states to memory at `mem_addr`",null,null],[5,"_xrstors","","Perform a full or partial restore of the enabled processor states using the state information stored in memory at `mem_addr`.",null,null],[5,"_mm_add_ss","","Adds the first component of `a` and `b`, the other components are copied from `a`.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_add_ps","","Adds __m128 vectors.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_sub_ss","","Subtracts the first component of `b` from `a`, the other components are copied from `a`.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_sub_ps","","Subtracts __m128 vectors.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_mul_ss","","Multiplies the first component of `a` and `b`, the other components are copied from `a`.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_mul_ps","","Multiplies __m128 vectors.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_div_ss","","Divides the first component of `b` by `a`, the other components are copied from `a`.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_div_ps","","Divides __m128 vectors.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_sqrt_ss","","Return the square root of the first single-precision (32-bit) floating-point element in `a`, the other elements are unchanged.",null,{"i":[{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_sqrt_ps","","Return the square root of packed single-precision (32-bit) floating-point elements in `a`.",null,{"i":[{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_rcp_ss","","Return the approximate reciprocal of the first single-precision (32-bit) floating-point element in `a`, the other elements are unchanged.",null,{"i":[{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_rcp_ps","","Return the approximate reciprocal of packed single-precision (32-bit) floating-point elements in `a`.",null,{"i":[{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_rsqrt_ss","","Return the approximate reciprocal square root of the fist single-precision (32-bit) floating-point elements in `a`, the other elements are unchanged.",null,{"i":[{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_rsqrt_ps","","Return the approximate reciprocal square root of packed single-precision (32-bit) floating-point elements in `a`.",null,{"i":[{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_min_ss","","Compare the first single-precision (32-bit) floating-point element of `a` and `b`, and return the minimum value in the first element of the return value, the other elements are copied from `a`.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_min_ps","","Compare packed single-precision (32-bit) floating-point elements in `a` and `b`, and return the corresponding minimum values.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_max_ss","","Compare the first single-precision (32-bit) floating-point element of `a` and `b`, and return the maximum value in the first element of the return value, the other elements are copied from `a`.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_max_ps","","Compare packed single-precision (32-bit) floating-point elements in `a` and `b`, and return the corresponding maximum values.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_and_ps","","Bitwise AND of packed single-precision (32-bit) floating-point elements.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_andnot_ps","","Bitwise AND-NOT of packed single-precision (32-bit) floating-point elements.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_or_ps","","Bitwise OR of packed single-precision (32-bit) floating-point elements.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_xor_ps","","Bitwise exclusive OR of packed single-precision (32-bit) floating-point elements.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_cmpeq_ss","","Compare the lowest `f32` of both inputs for equality. The lowest 32 bits of the result will be `0xffffffff` if the two inputs are equal, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_cmplt_ss","","Compare the lowest `f32` of both inputs for less than. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is less than `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_cmple_ss","","Compare the lowest `f32` of both inputs for less than or equal. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is less than or equal `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_cmpgt_ss","","Compare the lowest `f32` of both inputs for greater than. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is greater than `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_cmpge_ss","","Compare the lowest `f32` of both inputs for greater than or equal. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is greater than or equal `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_cmpneq_ss","","Compare the lowest `f32` of both inputs for inequality. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is not equal to `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_cmpnlt_ss","","Compare the lowest `f32` of both inputs for not-less-than. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is not less than `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_cmpnle_ss","","Compare the lowest `f32` of both inputs for not-less-than-or-equal. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is not less than or equal to `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_cmpngt_ss","","Compare the lowest `f32` of both inputs for not-greater-than. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is not greater than `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_cmpnge_ss","","Compare the lowest `f32` of both inputs for not-greater-than-or-equal. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is not greater than or equal to `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_cmpord_ss","","Check if the lowest `f32` of both inputs are ordered. The lowest 32 bits of the result will be `0xffffffff` if neither of `a.extract(0)` or `b.extract(0)` is a NaN, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_cmpunord_ss","","Check if the lowest `f32` of both inputs are unordered. The lowest 32 bits of the result will be `0xffffffff` if any of `a.extract(0)` or `b.extract(0)` is a NaN, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_cmpeq_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input elements were equal, or `0` otherwise.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_cmplt_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is less than the corresponding element in `b`, or `0` otherwise.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_cmple_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is less than or equal to the corresponding element in `b`, or `0` otherwise.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_cmpgt_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is greater than the corresponding element in `b`, or `0` otherwise.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_cmpge_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is greater than or equal to the corresponding element in `b`, or `0` otherwise.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_cmpneq_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input elements are not equal, or `0` otherwise.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_cmpnlt_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is not less than the corresponding element in `b`, or `0` otherwise.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_cmpnle_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is not less than or equal to the corresponding element in `b`, or `0` otherwise.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_cmpngt_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is not greater than the corresponding element in `b`, or `0` otherwise.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_cmpnge_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is not greater than or equal to the corresponding element in `b`, or `0` otherwise.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_cmpord_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. Returns four floats that have one of two possible bit patterns. The element in the output vector will be `0xffffffff` if the input elements in `a` and `b` are ordered (i.e., neither of them is a NaN), or 0 otherwise.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_cmpunord_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. Returns four floats that have one of two possible bit patterns. The element in the output vector will be `0xffffffff` if the input elements in `a` and `b` are unordered (i.e., at least on of them is a NaN), or 0 otherwise.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_comieq_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if they are equal, or `0` otherwise.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"i32"}}],[5,"_mm_comilt_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is less than the one from `b`, or `0` otherwise.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"i32"}}],[5,"_mm_comile_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is less than or equal to the one from `b`, or `0` otherwise.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"i32"}}],[5,"_mm_comigt_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is greater than the one from `b`, or `0` otherwise.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"i32"}}],[5,"_mm_comige_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is greater than or equal to the one from `b`, or `0` otherwise.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"i32"}}],[5,"_mm_comineq_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if they are not equal, or `0` otherwise.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"i32"}}],[5,"_mm_ucomieq_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if they are equal, or `0` otherwise. This instruction will not signal an exception if either argument is a quiet NaN.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"i32"}}],[5,"_mm_ucomilt_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is less than the one from `b`, or `0` otherwise. This instruction will not signal an exception if either argument is a quiet NaN.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"i32"}}],[5,"_mm_ucomile_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is less than or equal to the one from `b`, or `0` otherwise. This instruction will not signal an exception if either argument is a quiet NaN.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"i32"}}],[5,"_mm_ucomigt_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is greater than the one from `b`, or `0` otherwise. This instruction will not signal an exception if either argument is a quiet NaN.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"i32"}}],[5,"_mm_ucomige_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is greater than or equal to the one from `b`, or `0` otherwise. This instruction will not signal an exception if either argument is a quiet NaN.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"i32"}}],[5,"_mm_ucomineq_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if they are not equal, or `0` otherwise. This instruction will not signal an exception if either argument is a quiet NaN.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"i32"}}],[5,"_mm_cvtss_si32","","Convert the lowest 32 bit float in the input vector to a 32 bit integer.",null,{"i":[{"n":"__m128"}],"o":{"n":"i32"}}],[5,"_mm_cvt_ss2si","","Alias for `_mm_cvtss_si32`.",null,{"i":[{"n":"__m128"}],"o":{"n":"i32"}}],[5,"_mm_cvttss_si32","","Convert the lowest 32 bit float in the input vector to a 32 bit integer with truncation.",null,{"i":[{"n":"__m128"}],"o":{"n":"i32"}}],[5,"_mm_cvtt_ss2si","","Alias for `_mm_cvttss_si32`.",null,{"i":[{"n":"__m128"}],"o":{"n":"i32"}}],[5,"_mm_cvtss_f32","","Extract the lowest 32 bit float from the input vector.",null,{"i":[{"n":"__m128"}],"o":{"n":"f32"}}],[5,"_mm_cvtsi32_ss","","Convert a 32 bit integer to a 32 bit float. The result vector is the input vector `a` with the lowest 32 bit float replaced by the converted integer.",null,{"i":[{"n":"__m128"},{"n":"i32"}],"o":{"n":"__m128"}}],[5,"_mm_cvt_si2ss","","Alias for `_mm_cvtsi32_ss`.",null,{"i":[{"n":"__m128"},{"n":"i32"}],"o":{"n":"__m128"}}],[5,"_mm_set_ss","","Construct a `__m128` with the lowest element set to `a` and the rest set to zero.",null,{"i":[{"n":"f32"}],"o":{"n":"__m128"}}],[5,"_mm_set1_ps","","Construct a `__m128` with all element set to `a`.",null,{"i":[{"n":"f32"}],"o":{"n":"__m128"}}],[5,"_mm_set_ps1","","Alias for `_mm_set1_ps`",null,{"i":[{"n":"f32"}],"o":{"n":"__m128"}}],[5,"_mm_set_ps","","Construct a `__m128` from four floating point values highest to lowest.",null,{"i":[{"n":"f32"},{"n":"f32"},{"n":"f32"},{"n":"f32"}],"o":{"n":"__m128"}}],[5,"_mm_setr_ps","","Construct a `__m128` from four floating point values lowest to highest.",null,{"i":[{"n":"f32"},{"n":"f32"},{"n":"f32"},{"n":"f32"}],"o":{"n":"__m128"}}],[5,"_mm_setzero_ps","","Construct a `__m128` with all elements initialized to zero.",null,{"o":{"n":"__m128"}}],[5,"_mm_shuffle_ps","","Shuffle packed single-precision (32-bit) floating-point elements in `a` and `b` using `mask`.",null,{"i":[{"n":"__m128"},{"n":"__m128"},{"n":"u32"}],"o":{"n":"__m128"}}],[5,"_mm_unpackhi_ps","","Unpack and interleave single-precision (32-bit) floating-point elements from the higher half of `a` and `b`.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_unpacklo_ps","","Unpack and interleave single-precision (32-bit) floating-point elements from the lower half of `a` and `b`.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_movehl_ps","","Combine higher half of `a` and `b`. The highwe half of `b` occupies the lower half of result.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_movelh_ps","","Combine lower half of `a` and `b`. The lower half of `b` occupies the higher half of result.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_movemask_ps","","Return a mask of the most significant bit of each element in `a`.",null,{"i":[{"n":"__m128"}],"o":{"n":"i32"}}],[5,"_mm_loadh_pi","","Set the upper two single-precision floating-point values with 64 bits of data loaded from the address `p`; the lower two values are passed through from `a`.",null,null],[5,"_mm_loadl_pi","","Load two floats from `p` into the lower half of a `__m128`. The upper half is copied from the upper half of `a`.",null,null],[5,"_mm_load_ss","","Construct a `__m128` with the lowest element read from `p` and the other elements set to zero.",null,null],[5,"_mm_load1_ps","","Construct a `__m128` by duplicating the value read from `p` into all elements.",null,null],[5,"_mm_load_ps1","","Alias for `_mm_load1_ps`",null,null],[5,"_mm_load_ps","","Load four `f32` values from aligned memory into a `__m128`. If the pointer is not aligned to a 128-bit boundary (16 bytes) a general protection fault will be triggered (fatal program crash).",null,null],[5,"_mm_loadu_ps","","Load four `f32` values from memory into a `__m128`. There are no restrictions on memory alignment. For aligned memory `_mm_load_ps` may be faster.",null,null],[5,"_mm_loadr_ps","","Load four `f32` values from aligned memory into a `__m128` in reverse order.",null,null],[5,"_mm_storeh_pi","","Store the upper half of `a` (64 bits) into memory.",null,null],[5,"_mm_storel_pi","","Store the lower half of `a` (64 bits) into memory.",null,null],[5,"_mm_store_ss","","Store the lowest 32 bit float of `a` into memory.",null,null],[5,"_mm_store1_ps","","Store the lowest 32 bit float of `a` repeated four times into aligned memory.",null,null],[5,"_mm_store_ps1","","Alias for `_mm_store1_ps`",null,null],[5,"_mm_store_ps","","Store four 32-bit floats into aligned memory.",null,null],[5,"_mm_storeu_ps","","Store four 32-bit floats into memory. There are no restrictions on memory alignment. For aligned memory `_mm_store_ps` may be faster.",null,null],[5,"_mm_storer_ps","","Store four 32-bit floats into aligned memory in reverse order.",null,null],[5,"_mm_move_ss","","Return a `__m128` with the first component from `b` and the remaining components from `a`.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_sfence","","Perform a serializing operation on all store-to-memory instructions that were issued prior to this instruction.",null,{}],[5,"_mm_getcsr","","Get the unsigned 32-bit value of the MXCSR control and status register.",null,{"o":{"n":"u32"}}],[5,"_mm_setcsr","","Set the MXCSR register with the 32-bit unsigned integer value.",null,{"i":[{"n":"u32"}]}],[5,"_MM_GET_EXCEPTION_MASK","","See `_mm_setcsr`",null,{"o":{"n":"u32"}}],[5,"_MM_GET_EXCEPTION_STATE","","See `_mm_setcsr`",null,{"o":{"n":"u32"}}],[5,"_MM_GET_FLUSH_ZERO_MODE","","See `_mm_setcsr`",null,{"o":{"n":"u32"}}],[5,"_MM_GET_ROUNDING_MODE","","See `_mm_setcsr`",null,{"o":{"n":"u32"}}],[5,"_MM_SET_EXCEPTION_MASK","","See `_mm_setcsr`",null,{"i":[{"n":"u32"}]}],[5,"_MM_SET_EXCEPTION_STATE","","See `_mm_setcsr`",null,{"i":[{"n":"u32"}]}],[5,"_MM_SET_FLUSH_ZERO_MODE","","See `_mm_setcsr`",null,{"i":[{"n":"u32"}]}],[5,"_MM_SET_ROUNDING_MODE","","See `_mm_setcsr`",null,{"i":[{"n":"u32"}]}],[5,"_mm_prefetch","","Fetch the cache line that contains address `p` using the given `strategy`.",null,null],[5,"_mm_undefined_ps","","Return vector of type __m128 with undefined elements.",null,{"o":{"n":"__m128"}}],[5,"_MM_TRANSPOSE4_PS","","Transpose the 4x4 matrix formed by 4 rows of __m128 in place.",null,{"i":[{"n":"__m128"},{"n":"__m128"},{"n":"__m128"},{"n":"__m128"}]}],[5,"_mm_stream_ps","","Stores `a` into the memory at `mem_addr` using a non-temporal memory hint.",null,null],[5,"_mm_stream_pi","","Store 64-bits of integer data from a into memory using a non-temporal memory hint.",null,null],[5,"_mm_max_pi16","","Compares the packed 16-bit signed integers of `a` and `b` writing the greatest value into the result.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_m_pmaxsw","","Compares the packed 16-bit signed integers of `a` and `b` writing the greatest value into the result.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_max_pu8","","Compares the packed 8-bit signed integers of `a` and `b` writing the greatest value into the result.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_m_pmaxub","","Compares the packed 8-bit signed integers of `a` and `b` writing the greatest value into the result.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_min_pi16","","Compares the packed 16-bit signed integers of `a` and `b` writing the smallest value into the result.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_m_pminsw","","Compares the packed 16-bit signed integers of `a` and `b` writing the smallest value into the result.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_min_pu8","","Compares the packed 8-bit signed integers of `a` and `b` writing the smallest value into the result.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_m_pminub","","Compares the packed 8-bit signed integers of `a` and `b` writing the smallest value into the result.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_mulhi_pu16","","Multiplies packed 16-bit unsigned integer values and writes the high-order 16 bits of each 32-bit product to the corresponding bits in the destination.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_m_pmulhuw","","Multiplies packed 16-bit unsigned integer values and writes the high-order 16 bits of each 32-bit product to the corresponding bits in the destination.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_avg_pu8","","Computes the rounded averages of the packed unsigned 8-bit integer values and writes the averages to the corresponding bits in the destination.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_m_pavgb","","Computes the rounded averages of the packed unsigned 8-bit integer values and writes the averages to the corresponding bits in the destination.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_avg_pu16","","Computes the rounded averages of the packed unsigned 16-bit integer values and writes the averages to the corresponding bits in the destination.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_m_pavgw","","Computes the rounded averages of the packed unsigned 16-bit integer values and writes the averages to the corresponding bits in the destination.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_sad_pu8","","Subtracts the corresponding 8-bit unsigned integer values of the two 64-bit vector operands and computes the absolute value for each of the difference. Then sum of the 8 absolute differences is written to the bits `[15:0]` of the destination; the remaining bits `[63:16]` are cleared.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_m_psadbw","","Subtracts the corresponding 8-bit unsigned integer values of the two 64-bit vector operands and computes the absolute value for each of the difference. Then sum of the 8 absolute differences is written to the bits `[15:0]` of the destination; the remaining bits `[63:16]` are cleared.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_cvtpi32_ps","","Converts two elements of a 64-bit vector of `[2 x i32]` into two floating point values and writes them to the lower 64-bits of the destination. The remaining higher order elements of the destination are copied from the corresponding elements in the first operand.",null,{"i":[{"n":"__m128"},{"n":"__m64"}],"o":{"n":"__m128"}}],[5,"_mm_cvt_pi2ps","","Converts two elements of a 64-bit vector of `[2 x i32]` into two floating point values and writes them to the lower 64-bits of the destination. The remaining higher order elements of the destination are copied from the corresponding elements in the first operand.",null,{"i":[{"n":"__m128"},{"n":"__m64"}],"o":{"n":"__m128"}}],[5,"_mm_cvtpi8_ps","","Converts the lower 4 8-bit values of `a` into a 128-bit vector of 4 `f32`s.",null,{"i":[{"n":"__m64"}],"o":{"n":"__m128"}}],[5,"_mm_cvtpu8_ps","","Converts the lower 4 8-bit values of `a` into a 128-bit vector of 4 `f32`s.",null,{"i":[{"n":"__m64"}],"o":{"n":"__m128"}}],[5,"_mm_cvtpi16_ps","","Converts a 64-bit vector of `i16`s into a 128-bit vector of 4 `f32`s.",null,{"i":[{"n":"__m64"}],"o":{"n":"__m128"}}],[5,"_mm_cvtpu16_ps","","Converts a 64-bit vector of `i16`s into a 128-bit vector of 4 `f32`s.",null,{"i":[{"n":"__m64"}],"o":{"n":"__m128"}}],[5,"_mm_cvtpi32x2_ps","","Converts the two 32-bit signed integer values from each 64-bit vector operand of `[2 x i32]` into a 128-bit vector of `[4 x float]`.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m128"}}],[5,"_mm_maskmove_si64","","Conditionally copies the values from each 8-bit element in the first 64-bit integer vector operand to the specified memory location, as specified by the most significant bit in the corresponding element in the second 64-bit integer vector operand.",null,null],[5,"_m_maskmovq","","Conditionally copies the values from each 8-bit element in the first 64-bit integer vector operand to the specified memory location, as specified by the most significant bit in the corresponding element in the second 64-bit integer vector operand.",null,null],[5,"_mm_extract_pi16","","Extracts 16-bit element from a 64-bit vector of `[4 x i16]` and returns it, as specified by the immediate integer operand.",null,{"i":[{"n":"__m64"},{"n":"i32"}],"o":{"n":"i32"}}],[5,"_m_pextrw","","Extracts 16-bit element from a 64-bit vector of `[4 x i16]` and returns it, as specified by the immediate integer operand.",null,{"i":[{"n":"__m64"},{"n":"i32"}],"o":{"n":"i32"}}],[5,"_mm_insert_pi16","","Copies data from the 64-bit vector of `[4 x i16]` to the destination, and inserts the lower 16-bits of an integer operand at the 16-bit offset specified by the immediate operand `n`.",null,{"i":[{"n":"__m64"},{"n":"i32"},{"n":"i32"}],"o":{"n":"__m64"}}],[5,"_m_pinsrw","","Copies data from the 64-bit vector of `[4 x i16]` to the destination, and inserts the lower 16-bits of an integer operand at the 16-bit offset specified by the immediate operand `n`.",null,{"i":[{"n":"__m64"},{"n":"i32"},{"n":"i32"}],"o":{"n":"__m64"}}],[5,"_mm_movemask_pi8","","Takes the most significant bit from each 8-bit element in a 64-bit integer vector to create a 16-bit mask value. Zero-extends the value to 32-bit integer and writes it to the destination.",null,{"i":[{"n":"__m64"}],"o":{"n":"i32"}}],[5,"_m_pmovmskb","","Takes the most significant bit from each 8-bit element in a 64-bit integer vector to create a 16-bit mask value. Zero-extends the value to 32-bit integer and writes it to the destination.",null,{"i":[{"n":"__m64"}],"o":{"n":"i32"}}],[5,"_mm_shuffle_pi16","","Shuffles the 4 16-bit integers from a 64-bit integer vector to the destination, as specified by the immediate value operand.",null,{"i":[{"n":"__m64"},{"n":"i32"}],"o":{"n":"__m64"}}],[5,"_m_pshufw","","Shuffles the 4 16-bit integers from a 64-bit integer vector to the destination, as specified by the immediate value operand.",null,{"i":[{"n":"__m64"},{"n":"i32"}],"o":{"n":"__m64"}}],[5,"_mm_cvttps_pi32","","Convert the two lower packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers with truncation.",null,{"i":[{"n":"__m128"}],"o":{"n":"__m64"}}],[5,"_mm_cvtt_ps2pi","","Convert the two lower packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers with truncation.",null,{"i":[{"n":"__m128"}],"o":{"n":"__m64"}}],[5,"_mm_cvtps_pi32","","Convert the two lower packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers.",null,{"i":[{"n":"__m128"}],"o":{"n":"__m64"}}],[5,"_mm_cvt_ps2pi","","Convert the two lower packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers.",null,{"i":[{"n":"__m128"}],"o":{"n":"__m64"}}],[5,"_mm_cvtps_pi16","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed 16-bit integers.",null,{"i":[{"n":"__m128"}],"o":{"n":"__m64"}}],[5,"_mm_cvtps_pi8","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed 8-bit integers, and returns theem in the lower 4 elements of the result.",null,{"i":[{"n":"__m128"}],"o":{"n":"__m64"}}],[5,"_mm_pause","","Provide a hint to the processor that the code sequence is a spin-wait loop.",null,{}],[5,"_mm_clflush","","Invalidate and flush the cache line that contains `p` from all levels of the cache hierarchy.",null,null],[5,"_mm_lfence","","Perform a serializing operation on all load-from-memory instructions that were issued prior to this instruction.",null,{}],[5,"_mm_mfence","","Perform a serializing operation on all load-from-memory and store-to-memory instructions that were issued prior to this instruction.",null,{}],[5,"_mm_add_epi8","","Add packed 8-bit integers in `a` and `b`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_add_epi16","","Add packed 16-bit integers in `a` and `b`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_add_epi32","","Add packed 32-bit integers in `a` and `b`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_add_epi64","","Add packed 64-bit integers in `a` and \"b`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_adds_epi8","","Add packed 8-bit integers in `a` and `b` using saturation.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_adds_epi16","","Add packed 16-bit integers in `a` and `b` using saturation.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_adds_epu8","","Add packed unsigned 8-bit integers in `a` and `b` using saturation.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_adds_epu16","","Add packed unsigned 16-bit integers in `a` and `b` using saturation.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_avg_epu8","","Average packed unsigned 8-bit integers in `a` and `b`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_avg_epu16","","Average packed unsigned 16-bit integers in `a` and `b`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_madd_epi16","","Multiply and then horizontally add signed 16 bit integers in `a` and `b`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_max_epi16","","Compare packed 16-bit integers in `a` and `b`, and return the packed maximum values.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_max_epu8","","Compare packed unsigned 8-bit integers in `a` and `b`, and return the packed maximum values.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_min_epi16","","Compare packed 16-bit integers in `a` and `b`, and return the packed minimum values.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_min_epu8","","Compare packed unsigned 8-bit integers in `a` and `b`, and return the packed minimum values.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_mulhi_epi16","","Multiply the packed 16-bit integers in `a` and `b`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_mulhi_epu16","","Multiply the packed unsigned 16-bit integers in `a` and `b`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_mullo_epi16","","Multiply the packed 16-bit integers in `a` and `b`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_mul_epu32","","Multiply the low unsigned 32-bit integers from each packed 64-bit element in `a` and `b`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_sad_epu8","","Sum the absolute differences of packed unsigned 8-bit integers.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_sub_epi8","","Subtract packed 8-bit integers in `b` from packed 8-bit integers in `a`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_sub_epi16","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_sub_epi32","","Subtract packed 32-bit integers in `b` from packed 32-bit integers in `a`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_sub_epi64","","Subtract packed 64-bit integers in `b` from packed 64-bit integers in `a`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_subs_epi8","","Subtract packed 8-bit integers in `b` from packed 8-bit integers in `a` using saturation.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_subs_epi16","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a` using saturation.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_subs_epu8","","Subtract packed unsigned 8-bit integers in `b` from packed unsigned 8-bit integers in `a` using saturation.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_subs_epu16","","Subtract packed unsigned 16-bit integers in `b` from packed unsigned 16-bit integers in `a` using saturation.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_slli_si128","","Shift `a` left by `imm8` bytes while shifting in zeros.",null,{"i":[{"n":"__m128i"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_bslli_si128","","Shift `a` left by `imm8` bytes while shifting in zeros.",null,{"i":[{"n":"__m128i"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_bsrli_si128","","Shift `a` right by `imm8` bytes while shifting in zeros.",null,{"i":[{"n":"__m128i"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_slli_epi16","","Shift packed 16-bit integers in `a` left by `imm8` while shifting in zeros.",null,{"i":[{"n":"__m128i"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_sll_epi16","","Shift packed 16-bit integers in `a` left by `count` while shifting in zeros.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_slli_epi32","","Shift packed 32-bit integers in `a` left by `imm8` while shifting in zeros.",null,{"i":[{"n":"__m128i"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_sll_epi32","","Shift packed 32-bit integers in `a` left by `count` while shifting in zeros.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_slli_epi64","","Shift packed 64-bit integers in `a` left by `imm8` while shifting in zeros.",null,{"i":[{"n":"__m128i"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_sll_epi64","","Shift packed 64-bit integers in `a` left by `count` while shifting in zeros.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_srai_epi16","","Shift packed 16-bit integers in `a` right by `imm8` while shifting in sign bits.",null,{"i":[{"n":"__m128i"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_sra_epi16","","Shift packed 16-bit integers in `a` right by `count` while shifting in sign bits.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_srai_epi32","","Shift packed 32-bit integers in `a` right by `imm8` while shifting in sign bits.",null,{"i":[{"n":"__m128i"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_sra_epi32","","Shift packed 32-bit integers in `a` right by `count` while shifting in sign bits.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_srli_si128","","Shift `a` right by `imm8` bytes while shifting in zeros.",null,{"i":[{"n":"__m128i"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_srli_epi16","","Shift packed 16-bit integers in `a` right by `imm8` while shifting in zeros.",null,{"i":[{"n":"__m128i"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_srl_epi16","","Shift packed 16-bit integers in `a` right by `count` while shifting in zeros.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_srli_epi32","","Shift packed 32-bit integers in `a` right by `imm8` while shifting in zeros.",null,{"i":[{"n":"__m128i"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_srl_epi32","","Shift packed 32-bit integers in `a` right by `count` while shifting in zeros.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_srli_epi64","","Shift packed 64-bit integers in `a` right by `imm8` while shifting in zeros.",null,{"i":[{"n":"__m128i"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_srl_epi64","","Shift packed 64-bit integers in `a` right by `count` while shifting in zeros.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_and_si128","","Compute the bitwise AND of 128 bits (representing integer data) in `a` and `b`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_andnot_si128","","Compute the bitwise NOT of 128 bits (representing integer data) in `a` and then AND with `b`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_or_si128","","Compute the bitwise OR of 128 bits (representing integer data) in `a` and `b`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_xor_si128","","Compute the bitwise XOR of 128 bits (representing integer data) in `a` and `b`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_cmpeq_epi8","","Compare packed 8-bit integers in `a` and `b` for equality.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_cmpeq_epi16","","Compare packed 16-bit integers in `a` and `b` for equality.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_cmpeq_epi32","","Compare packed 32-bit integers in `a` and `b` for equality.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_cmpgt_epi8","","Compare packed 8-bit integers in `a` and `b` for greater-than.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_cmpgt_epi16","","Compare packed 16-bit integers in `a` and `b` for greater-than.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_cmpgt_epi32","","Compare packed 32-bit integers in `a` and `b` for greater-than.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_cmplt_epi8","","Compare packed 8-bit integers in `a` and `b` for less-than.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_cmplt_epi16","","Compare packed 16-bit integers in `a` and `b` for less-than.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_cmplt_epi32","","Compare packed 32-bit integers in `a` and `b` for less-than.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_cvtepi32_pd","","Convert the lower two packed 32-bit integers in `a` to packed double-precision (64-bit) floating-point elements.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m128d"}}],[5,"_mm_cvtsi32_sd","","Return `a` with its lower element replaced by `b` after converting it to an `f64`.",null,{"i":[{"n":"__m128d"},{"n":"i32"}],"o":{"n":"__m128d"}}],[5,"_mm_cvtepi32_ps","","Convert packed 32-bit integers in `a` to packed single-precision (32-bit) floating-point elements.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m128"}}],[5,"_mm_cvtps_epi32","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers.",null,{"i":[{"n":"__m128"}],"o":{"n":"__m128i"}}],[5,"_mm_cvtsi32_si128","","Return a vector whose lowest element is `a` and all higher elements are `0`.",null,{"i":[{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_cvtsi128_si32","","Return the lowest element of `a`.",null,{"i":[{"n":"__m128i"}],"o":{"n":"i32"}}],[5,"_mm_set_epi64x","","Set packed 64-bit integers with the supplied values, from highest to lowest.",null,{"i":[{"n":"i64"},{"n":"i64"}],"o":{"n":"__m128i"}}],[5,"_mm_set_epi32","","Set packed 32-bit integers with the supplied values.",null,{"i":[{"n":"i32"},{"n":"i32"},{"n":"i32"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_set_epi16","","Set packed 16-bit integers with the supplied values.",null,{"i":[{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"}],"o":{"n":"__m128i"}}],[5,"_mm_set_epi8","","Set packed 8-bit integers with the supplied values.",null,{"i":[{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"}],"o":{"n":"__m128i"}}],[5,"_mm_set1_epi64x","","Broadcast 64-bit integer `a` to all elements.",null,{"i":[{"n":"i64"}],"o":{"n":"__m128i"}}],[5,"_mm_set1_epi32","","Broadcast 32-bit integer `a` to all elements.",null,{"i":[{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_set1_epi16","","Broadcast 16-bit integer `a` to all elements.",null,{"i":[{"n":"i16"}],"o":{"n":"__m128i"}}],[5,"_mm_set1_epi8","","Broadcast 8-bit integer `a` to all elements.",null,{"i":[{"n":"i8"}],"o":{"n":"__m128i"}}],[5,"_mm_setr_epi32","","Set packed 32-bit integers with the supplied values in reverse order.",null,{"i":[{"n":"i32"},{"n":"i32"},{"n":"i32"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_setr_epi16","","Set packed 16-bit integers with the supplied values in reverse order.",null,{"i":[{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"}],"o":{"n":"__m128i"}}],[5,"_mm_setr_epi8","","Set packed 8-bit integers with the supplied values in reverse order.",null,{"i":[{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"}],"o":{"n":"__m128i"}}],[5,"_mm_setzero_si128","","Returns a vector with all elements set to zero.",null,{"o":{"n":"__m128i"}}],[5,"_mm_loadl_epi64","","Load 64-bit integer from memory into first element of returned vector.",null,null],[5,"_mm_load_si128","","Load 128-bits of integer data from memory into a new vector.",null,null],[5,"_mm_loadu_si128","","Load 128-bits of integer data from memory into a new vector.",null,null],[5,"_mm_maskmoveu_si128","","Conditionally store 8-bit integer elements from `a` into memory using `mask`.",null,null],[5,"_mm_store_si128","","Store 128-bits of integer data from `a` into memory.",null,null],[5,"_mm_storeu_si128","","Store 128-bits of integer data from `a` into memory.",null,null],[5,"_mm_storel_epi64","","Store the lower 64-bit integer `a` to a memory location.",null,null],[5,"_mm_stream_si128","","Stores a 128-bit integer vector to a 128-bit aligned memory location. To minimize caching, the data is flagged as non-temporal (unlikely to be used again soon).",null,null],[5,"_mm_stream_si32","","Stores a 32-bit integer value in the specified memory location. To minimize caching, the data is flagged as non-temporal (unlikely to be used again soon).",null,null],[5,"_mm_move_epi64","","Return a vector where the low element is extracted from `a` and its upper element is zero.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_packs_epi16","","Convert packed 16-bit integers from `a` and `b` to packed 8-bit integers using signed saturation.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_packs_epi32","","Convert packed 32-bit integers from `a` and `b` to packed 16-bit integers using signed saturation.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_packus_epi16","","Convert packed 16-bit integers from `a` and `b` to packed 8-bit integers using unsigned saturation.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_extract_epi16","","Return the `imm8` element of `a`.",null,{"i":[{"n":"__m128i"},{"n":"i32"}],"o":{"n":"i32"}}],[5,"_mm_insert_epi16","","Return a new vector where the `imm8` element of `a` is replaced with `i`.",null,{"i":[{"n":"__m128i"},{"n":"i32"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_movemask_epi8","","Return a mask of the most significant bit of each element in `a`.",null,{"i":[{"n":"__m128i"}],"o":{"n":"i32"}}],[5,"_mm_shuffle_epi32","","Shuffle 32-bit integers in `a` using the control in `imm8`.",null,{"i":[{"n":"__m128i"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_shufflehi_epi16","","Shuffle 16-bit integers in the high 64 bits of `a` using the control in `imm8`.",null,{"i":[{"n":"__m128i"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_shufflelo_epi16","","Shuffle 16-bit integers in the low 64 bits of `a` using the control in `imm8`.",null,{"i":[{"n":"__m128i"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_unpackhi_epi8","","Unpack and interleave 8-bit integers from the high half of `a` and `b`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_unpackhi_epi16","","Unpack and interleave 16-bit integers from the high half of `a` and `b`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_unpackhi_epi32","","Unpack and interleave 32-bit integers from the high half of `a` and `b`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_unpackhi_epi64","","Unpack and interleave 64-bit integers from the high half of `a` and `b`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_unpacklo_epi8","","Unpack and interleave 8-bit integers from the low half of `a` and `b`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_unpacklo_epi16","","Unpack and interleave 16-bit integers from the low half of `a` and `b`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_unpacklo_epi32","","Unpack and interleave 32-bit integers from the low half of `a` and `b`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_unpacklo_epi64","","Unpack and interleave 64-bit integers from the low half of `a` and `b`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_add_sd","","Return a new vector with the low element of `a` replaced by the sum of the low elements of `a` and `b`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_add_pd","","Add packed double-precision (64-bit) floating-point elements in `a` and `b`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_div_sd","","Return a new vector with the low element of `a` replaced by the result of diving the lower element of `a` by the lower element of `b`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_div_pd","","Divide packed double-precision (64-bit) floating-point elements in `a` by packed elements in `b`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_max_sd","","Return a new vector with the low element of `a` replaced by the maximum of the lower elements of `a` and `b`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_max_pd","","Return a new vector with the maximum values from corresponding elements in `a` and `b`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_min_sd","","Return a new vector with the low element of `a` replaced by the minimum of the lower elements of `a` and `b`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_min_pd","","Return a new vector with the minimum values from corresponding elements in `a` and `b`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_mul_sd","","Return a new vector with the low element of `a` replaced by multiplying the low elements of `a` and `b`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_mul_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_sqrt_sd","","Return a new vector with the low element of `a` replaced by the square root of the lower element `b`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_sqrt_pd","","Return a new vector with the square root of each of the values in `a`.",null,{"i":[{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_sub_sd","","Return a new vector with the low element of `a` replaced by subtracting the low element by `b` from the low element of `a`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_sub_pd","","Subtract packed double-precision (64-bit) floating-point elements in `b` from `a`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_and_pd","","Compute the bitwise AND of packed double-precision (64-bit) floating-point elements in `a` and `b`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_andnot_pd","","Compute the bitwise NOT of `a` and then AND with `b`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_or_pd","","Compute the bitwise OR of `a` and `b`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_xor_pd","","Compute the bitwise OR of `a` and `b`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_cmpeq_sd","","Return a new vector with the low element of `a` replaced by the equality comparison of the lower elements of `a` and `b`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_cmplt_sd","","Return a new vector with the low element of `a` replaced by the less-than comparison of the lower elements of `a` and `b`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_cmple_sd","","Return a new vector with the low element of `a` replaced by the less-than-or-equal comparison of the lower elements of `a` and `b`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_cmpgt_sd","","Return a new vector with the low element of `a` replaced by the greater-than comparison of the lower elements of `a` and `b`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_cmpge_sd","","Return a new vector with the low element of `a` replaced by the greater-than-or-equal comparison of the lower elements of `a` and `b`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_cmpord_sd","","Return a new vector with the low element of `a` replaced by the result of comparing both of the lower elements of `a` and `b` to `NaN`. If neither are equal to `NaN` then `0xFFFFFFFFFFFFFFFF` is used and `0` otherwise.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_cmpunord_sd","","Return a new vector with the low element of `a` replaced by the result of comparing both of the lower elements of `a` and `b` to `NaN`. If either is equal to `NaN` then `0xFFFFFFFFFFFFFFFF` is used and `0` otherwise.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_cmpneq_sd","","Return a new vector with the low element of `a` replaced by the not-equal comparison of the lower elements of `a` and `b`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_cmpnlt_sd","","Return a new vector with the low element of `a` replaced by the not-less-than comparison of the lower elements of `a` and `b`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_cmpnle_sd","","Return a new vector with the low element of `a` replaced by the not-less-than-or-equal comparison of the lower elements of `a` and `b`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_cmpngt_sd","","Return a new vector with the low element of `a` replaced by the not-greater-than comparison of the lower elements of `a` and `b`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_cmpnge_sd","","Return a new vector with the low element of `a` replaced by the not-greater-than-or-equal comparison of the lower elements of `a` and `b`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_cmpeq_pd","","Compare corresponding elements in `a` and `b` for equality.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_cmplt_pd","","Compare corresponding elements in `a` and `b` for less-than.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_cmple_pd","","Compare corresponding elements in `a` and `b` for less-than-or-equal",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_cmpgt_pd","","Compare corresponding elements in `a` and `b` for greater-than.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_cmpge_pd","","Compare corresponding elements in `a` and `b` for greater-than-or-equal.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_cmpord_pd","","Compare corresponding elements in `a` and `b` to see if neither is `NaN`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_cmpunord_pd","","Compare corresponding elements in `a` and `b` to see if either is `NaN`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_cmpneq_pd","","Compare corresponding elements in `a` and `b` for not-equal.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_cmpnlt_pd","","Compare corresponding elements in `a` and `b` for not-less-than.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_cmpnle_pd","","Compare corresponding elements in `a` and `b` for not-less-than-or-equal.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_cmpngt_pd","","Compare corresponding elements in `a` and `b` for not-greater-than.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_cmpnge_pd","","Compare corresponding elements in `a` and `b` for not-greater-than-or-equal.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_comieq_sd","","Compare the lower element of `a` and `b` for equality.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"i32"}}],[5,"_mm_comilt_sd","","Compare the lower element of `a` and `b` for less-than.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"i32"}}],[5,"_mm_comile_sd","","Compare the lower element of `a` and `b` for less-than-or-equal.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"i32"}}],[5,"_mm_comigt_sd","","Compare the lower element of `a` and `b` for greater-than.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"i32"}}],[5,"_mm_comige_sd","","Compare the lower element of `a` and `b` for greater-than-or-equal.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"i32"}}],[5,"_mm_comineq_sd","","Compare the lower element of `a` and `b` for not-equal.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"i32"}}],[5,"_mm_ucomieq_sd","","Compare the lower element of `a` and `b` for equality.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"i32"}}],[5,"_mm_ucomilt_sd","","Compare the lower element of `a` and `b` for less-than.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"i32"}}],[5,"_mm_ucomile_sd","","Compare the lower element of `a` and `b` for less-than-or-equal.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"i32"}}],[5,"_mm_ucomigt_sd","","Compare the lower element of `a` and `b` for greater-than.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"i32"}}],[5,"_mm_ucomige_sd","","Compare the lower element of `a` and `b` for greater-than-or-equal.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"i32"}}],[5,"_mm_ucomineq_sd","","Compare the lower element of `a` and `b` for not-equal.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"i32"}}],[5,"_mm_cvtpd_ps","","Convert packed double-precision (64-bit) floating-point elements in \"a\" to packed single-precision (32-bit) floating-point elements",null,{"i":[{"n":"__m128d"}],"o":{"n":"__m128"}}],[5,"_mm_cvtps_pd","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed double-precision (64-bit) floating-point elements.",null,{"i":[{"n":"__m128"}],"o":{"n":"__m128d"}}],[5,"_mm_cvtpd_epi32","","Convert packed double-precision (64-bit) floating-point elements in `a` to packed 32-bit integers.",null,{"i":[{"n":"__m128d"}],"o":{"n":"__m128i"}}],[5,"_mm_cvtsd_si32","","Convert the lower double-precision (64-bit) floating-point element in a to a 32-bit integer.",null,{"i":[{"n":"__m128d"}],"o":{"n":"i32"}}],[5,"_mm_cvtsd_ss","","Convert the lower double-precision (64-bit) floating-point element in `b` to a single-precision (32-bit) floating-point element, store the result in the lower element of the return value, and copy the upper element from `a` to the upper element the return value.",null,{"i":[{"n":"__m128"},{"n":"__m128d"}],"o":{"n":"__m128"}}],[5,"_mm_cvtsd_f64","","Return the lower double-precision (64-bit) floating-point element of \"a\".",null,{"i":[{"n":"__m128d"}],"o":{"n":"f64"}}],[5,"_mm_cvtss_sd","","Convert the lower single-precision (32-bit) floating-point element in `b` to a double-precision (64-bit) floating-point element, store the result in the lower element of the return value, and copy the upper element from `a` to the upper element the return value.",null,{"i":[{"n":"__m128d"},{"n":"__m128"}],"o":{"n":"__m128d"}}],[5,"_mm_cvttpd_epi32","","Convert packed double-precision (64-bit) floating-point elements in `a` to packed 32-bit integers with truncation.",null,{"i":[{"n":"__m128d"}],"o":{"n":"__m128i"}}],[5,"_mm_cvttsd_si32","","Convert the lower double-precision (64-bit) floating-point element in `a` to a 32-bit integer with truncation.",null,{"i":[{"n":"__m128d"}],"o":{"n":"i32"}}],[5,"_mm_cvttps_epi32","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers with truncation.",null,{"i":[{"n":"__m128"}],"o":{"n":"__m128i"}}],[5,"_mm_set_sd","","Copy double-precision (64-bit) floating-point element `a` to the lower element of the packed 64-bit return value.",null,{"i":[{"n":"f64"}],"o":{"n":"__m128d"}}],[5,"_mm_set1_pd","","Broadcast double-precision (64-bit) floating-point value a to all elements of the return value.",null,{"i":[{"n":"f64"}],"o":{"n":"__m128d"}}],[5,"_mm_set_pd1","","Broadcast double-precision (64-bit) floating-point value a to all elements of the return value.",null,{"i":[{"n":"f64"}],"o":{"n":"__m128d"}}],[5,"_mm_set_pd","","Set packed double-precision (64-bit) floating-point elements in the return value with the supplied values.",null,{"i":[{"n":"f64"},{"n":"f64"}],"o":{"n":"__m128d"}}],[5,"_mm_setr_pd","","Set packed double-precision (64-bit) floating-point elements in the return value with the supplied values in reverse order.",null,{"i":[{"n":"f64"},{"n":"f64"}],"o":{"n":"__m128d"}}],[5,"_mm_setzero_pd","","Returns packed double-precision (64-bit) floating-point elements with all zeros.",null,{"o":{"n":"__m128d"}}],[5,"_mm_movemask_pd","","Return a mask of the most significant bit of each element in `a`.",null,{"i":[{"n":"__m128d"}],"o":{"n":"i32"}}],[5,"_mm_load_pd","","Load 128-bits (composed of 2 packed double-precision (64-bit) floating-point elements) from memory into the returned vector. `mem_addr` must be aligned on a 16-byte boundary or a general-protection exception may be generated.",null,null],[5,"_mm_load_sd","","Loads a 64-bit double-precision value to the low element of a 128-bit integer vector and clears the upper element.",null,null],[5,"_mm_loadh_pd","","Loads a double-precision value into the high-order bits of a 128-bit vector of `[2 x double]`. The low-order bits are copied from the low-order bits of the first operand.",null,null],[5,"_mm_loadl_pd","","Loads a double-precision value into the low-order bits of a 128-bit vector of `[2 x double]`. The high-order bits are copied from the high-order bits of the first operand.",null,null],[5,"_mm_stream_pd","","Stores a 128-bit floating point vector of `[2 x double]` to a 128-bit aligned memory location. To minimize caching, the data is flagged as non-temporal (unlikely to be used again soon).",null,null],[5,"_mm_store_sd","","Stores the lower 64 bits of a 128-bit vector of `[2 x double]` to a memory location.",null,null],[5,"_mm_store_pd","","Store 128-bits (composed of 2 packed double-precision (64-bit) floating-point elements) from `a` into memory. `mem_addr` must be aligned on a 16-byte boundary or a general-protection exception may be generated.",null,null],[5,"_mm_storeu_pd","","Store 128-bits (composed of 2 packed double-precision (64-bit) floating-point elements) from `a` into memory. `mem_addr` does not need to be aligned on any particular boundary.",null,null],[5,"_mm_store1_pd","","Store the lower double-precision (64-bit) floating-point element from `a` into 2 contiguous elements in memory. `mem_addr` must be aligned on a 16-byte boundary or a general-protection exception may be generated.",null,null],[5,"_mm_store_pd1","","Store the lower double-precision (64-bit) floating-point element from `a` into 2 contiguous elements in memory. `mem_addr` must be aligned on a 16-byte boundary or a general-protection exception may be generated.",null,null],[5,"_mm_storer_pd","","Store 2 double-precision (64-bit) floating-point elements from `a` into memory in reverse order. `mem_addr` must be aligned on a 16-byte boundary or a general-protection exception may be generated.",null,null],[5,"_mm_storeh_pd","","Stores the upper 64 bits of a 128-bit vector of `[2 x double]` to a memory location.",null,null],[5,"_mm_storel_pd","","Stores the lower 64 bits of a 128-bit vector of `[2 x double]` to a memory location.",null,null],[5,"_mm_load1_pd","","Load a double-precision (64-bit) floating-point element from memory into both elements of returned vector.",null,null],[5,"_mm_load_pd1","","Load a double-precision (64-bit) floating-point element from memory into both elements of returned vector.",null,null],[5,"_mm_loadr_pd","","Load 2 double-precision (64-bit) floating-point elements from memory into the returned vector in reverse order. `mem_addr` must be aligned on a 16-byte boundary or a general-protection exception may be generated.",null,null],[5,"_mm_loadu_pd","","Load 128-bits (composed of 2 packed double-precision (64-bit) floating-point elements) from memory into the returned vector. `mem_addr` does not need to be aligned on any particular boundary.",null,null],[5,"_mm_shuffle_pd","","Constructs a 128-bit floating-point vector of `[2 x double]` from two 128-bit vector parameters of `[2 x double]`, using the immediate-value parameter as a specifier.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"},{"n":"i32"}],"o":{"n":"__m128d"}}],[5,"_mm_move_sd","","Constructs a 128-bit floating-point vector of `[2 x double]`. The lower 64 bits are set to the lower 64 bits of the second parameter. The upper 64 bits are set to the upper 64 bits of the first parameter.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_castpd_ps","","Casts a 128-bit floating-point vector of `[2 x double]` into a 128-bit floating-point vector of `[4 x float]`.",null,{"i":[{"n":"__m128d"}],"o":{"n":"__m128"}}],[5,"_mm_castpd_si128","","Casts a 128-bit floating-point vector of `[2 x double]` into a 128-bit integer vector.",null,{"i":[{"n":"__m128d"}],"o":{"n":"__m128i"}}],[5,"_mm_castps_pd","","Casts a 128-bit floating-point vector of `[4 x float]` into a 128-bit floating-point vector of `[2 x double]`.",null,{"i":[{"n":"__m128"}],"o":{"n":"__m128d"}}],[5,"_mm_castps_si128","","Casts a 128-bit floating-point vector of `[4 x float]` into a 128-bit integer vector.",null,{"i":[{"n":"__m128"}],"o":{"n":"__m128i"}}],[5,"_mm_castsi128_pd","","Casts a 128-bit integer vector into a 128-bit floating-point vector of `[2 x double]`.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m128d"}}],[5,"_mm_castsi128_ps","","Casts a 128-bit integer vector into a 128-bit floating-point vector of `[4 x float]`.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m128"}}],[5,"_mm_undefined_pd","","Return vector of type __m128d with undefined elements.",null,{"o":{"n":"__m128d"}}],[5,"_mm_undefined_si128","","Return vector of type __m128i with undefined elements.",null,{"o":{"n":"__m128i"}}],[5,"_mm_unpackhi_pd","","The resulting `__m128d` element is composed by the low-order values of the two `__m128d` interleaved input elements, i.e.:",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_unpacklo_pd","","The resulting `__m128d` element is composed by the high-order values of the two `__m128d` interleaved input elements, i.e.:",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_add_si64","","Adds two signed or unsigned 64-bit integer values, returning the lower 64 bits of the sum.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_mul_su32","","Multiplies 32-bit unsigned integer values contained in the lower bits of the two 64-bit integer vectors and returns the 64-bit unsigned product.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_sub_si64","","Subtracts signed or unsigned 64-bit integer values and writes the difference to the corresponding bits in the destination.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_cvtpi32_pd","","Converts the two signed 32-bit integer elements of a 64-bit vector of `[2 x i32]` into two double-precision floating-point values, returned in a 128-bit vector of `[2 x double]`.",null,{"i":[{"n":"__m64"}],"o":{"n":"__m128d"}}],[5,"_mm_set_epi64","","Initializes both 64-bit values in a 128-bit vector of `[2 x i64]` with the specified 64-bit integer values.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m128i"}}],[5,"_mm_set1_epi64","","Initializes both values in a 128-bit vector of `[2 x i64]` with the specified 64-bit value.",null,{"i":[{"n":"__m64"}],"o":{"n":"__m128i"}}],[5,"_mm_setr_epi64","","Constructs a 128-bit integer vector, initialized in reverse order with the specified 64-bit integral values.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m128i"}}],[5,"_mm_movepi64_pi64","","Returns the lower 64 bits of a 128-bit integer vector as a 64-bit integer.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m64"}}],[5,"_mm_movpi64_epi64","","Moves the 64-bit operand to a 128-bit integer vector, zeroing the upper bits.",null,{"i":[{"n":"__m64"}],"o":{"n":"__m128i"}}],[5,"_mm_cvtpd_pi32","","Converts the two double-precision floating-point elements of a 128-bit vector of `[2 x double]` into two signed 32-bit integer values, returned in a 64-bit vector of `[2 x i32]`.",null,{"i":[{"n":"__m128d"}],"o":{"n":"__m64"}}],[5,"_mm_cvttpd_pi32","","Converts the two double-precision floating-point elements of a 128-bit vector of `[2 x double]` into two signed 32-bit integer values, returned in a 64-bit vector of `[2 x i32]`. If the result of either conversion is inexact, the result is truncated (rounded towards zero) regardless of the current MXCSR setting.",null,{"i":[{"n":"__m128d"}],"o":{"n":"__m64"}}],[5,"_mm_addsub_ps","","Alternatively add and subtract packed single-precision (32-bit) floating-point elements in `a` to/from packed elements in `b`.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_addsub_pd","","Alternatively add and subtract packed double-precision (64-bit) floating-point elements in `a` to/from packed elements in `b`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_hadd_pd","","Horizontally add adjacent pairs of double-precision (64-bit) floating-point elements in `a` and `b`, and pack the results.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_hadd_ps","","Horizontally add adjacent pairs of single-precision (32-bit) floating-point elements in `a` and `b`, and pack the results.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_hsub_pd","","Horizontally subtract adjacent pairs of double-precision (64-bit) floating-point elements in `a` and `b`, and pack the results.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_hsub_ps","","Horizontally add adjacent pairs of single-precision (32-bit) floating-point elements in `a` and `b`, and pack the results.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_lddqu_si128","","Load 128-bits of integer data from unaligned memory. This intrinsic may perform better than `_mm_loadu_si128` when the data crosses a cache line boundary.",null,null],[5,"_mm_movedup_pd","","Duplicate the low double-precision (64-bit) floating-point element from `a`.",null,{"i":[{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_loaddup_pd","","Load a double-precision (64-bit) floating-point element from memory into both elements of return vector.",null,null],[5,"_mm_movehdup_ps","","Duplicate odd-indexed single-precision (32-bit) floating-point elements from `a`.",null,{"i":[{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_moveldup_ps","","Duplicate even-indexed single-precision (32-bit) floating-point elements from `a`.",null,{"i":[{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_abs_epi8","","Compute the absolute value of packed 8-bit signed integers in `a` and return the unsigned results.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_abs_epi16","","Compute the absolute value of each of the packed 16-bit signed integers in `a` and return the 16-bit unsigned integer",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_abs_epi32","","Compute the absolute value of each of the packed 32-bit signed integers in `a` and return the 32-bit unsigned integer",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_shuffle_epi8","","Shuffle bytes from `a` according to the content of `b`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_alignr_epi8","","Concatenate 16-byte blocks in `a` and `b` into a 32-byte temporary result, shift the result right by `n` bytes, and return the low 16 bytes.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_hadd_epi16","","Horizontally add the adjacent pairs of values contained in 2 packed 128-bit vectors of `[8 x i16]`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_hadds_epi16","","Horizontally add the adjacent pairs of values contained in 2 packed 128-bit vectors of `[8 x i16]`. Positive sums greater than 7FFFh are saturated to 7FFFh. Negative sums less than 8000h are saturated to 8000h.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_hadd_epi32","","Horizontally add the adjacent pairs of values contained in 2 packed 128-bit vectors of `[4 x i32]`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_hsub_epi16","","Horizontally subtract the adjacent pairs of values contained in 2 packed 128-bit vectors of `[8 x i16]`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_hsubs_epi16","","Horizontally subtract the adjacent pairs of values contained in 2 packed 128-bit vectors of `[8 x i16]`. Positive differences greater than 7FFFh are saturated to 7FFFh. Negative differences less than 8000h are saturated to 8000h.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_hsub_epi32","","Horizontally subtract the adjacent pairs of values contained in 2 packed 128-bit vectors of `[4 x i32]`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_maddubs_epi16","","Multiply corresponding pairs of packed 8-bit unsigned integer values contained in the first source operand and packed 8-bit signed integer values contained in the second source operand, add pairs of contiguous products with signed saturation, and writes the 16-bit sums to the corresponding bits in the destination.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_mulhrs_epi16","","Multiply packed 16-bit signed integer values, truncate the 32-bit product to the 18 most significant bits by right-shifting, round the truncated value by adding 1, and write bits `[16:1]` to the destination.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_sign_epi8","","Negate packed 8-bit integers in `a` when the corresponding signed 8-bit integer in `b` is negative, and return the result. Elements in result are zeroed out when the corresponding element in `b` is zero.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_sign_epi16","","Negate packed 16-bit integers in `a` when the corresponding signed 16-bit integer in `b` is negative, and return the results. Elements in result are zeroed out when the corresponding element in `b` is zero.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_sign_epi32","","Negate packed 32-bit integers in `a` when the corresponding signed 32-bit integer in `b` is negative, and return the results. Element in result are zeroed out when the corresponding element in `b` is zero.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_abs_pi8","","Compute the absolute value of packed 8-bit integers in `a` and return the unsigned results.",null,{"i":[{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_abs_pi16","","Compute the absolute value of packed 8-bit integers in `a`, and return the unsigned results.",null,{"i":[{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_abs_pi32","","Compute the absolute value of packed 32-bit integers in `a`, and return the unsigned results.",null,{"i":[{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_shuffle_pi8","","Shuffle packed 8-bit integers in `a` according to shuffle control mask in the corresponding 8-bit element of `b`, and return the results",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_alignr_pi8","","Concatenates the two 64-bit integer vector operands, and right-shifts the result by the number of bytes specified in the immediate operand.",null,{"i":[{"n":"__m64"},{"n":"__m64"},{"n":"i32"}],"o":{"n":"__m64"}}],[5,"_mm_hadd_pi16","","Horizontally add the adjacent pairs of values contained in 2 packed 64-bit vectors of `[4 x i16]`.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_hadd_pi32","","Horizontally add the adjacent pairs of values contained in 2 packed 64-bit vectors of `[2 x i32]`.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_hadds_pi16","","Horizontally add the adjacent pairs of values contained in 2 packed 64-bit vectors of `[4 x i16]`. Positive sums greater than 7FFFh are saturated to 7FFFh. Negative sums less than 8000h are saturated to 8000h.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_hsub_pi16","","Horizontally subtracts the adjacent pairs of values contained in 2 packed 64-bit vectors of `[4 x i16]`.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_hsub_pi32","","Horizontally subtracts the adjacent pairs of values contained in 2 packed 64-bit vectors of `[2 x i32]`.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_hsubs_pi16","","Horizontally subtracts the adjacent pairs of values contained in 2 packed 64-bit vectors of `[4 x i16]`. Positive differences greater than 7FFFh are saturated to 7FFFh. Negative differences less than 8000h are saturated to 8000h.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_maddubs_pi16","","Multiplies corresponding pairs of packed 8-bit unsigned integer values contained in the first source operand and packed 8-bit signed integer values contained in the second source operand, adds pairs of contiguous products with signed saturation, and writes the 16-bit sums to the corresponding bits in the destination.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_mulhrs_pi16","","Multiplies packed 16-bit signed integer values, truncates the 32-bit products to the 18 most significant bits by right-shifting, rounds the truncated value by adding 1, and writes bits `[16:1]` to the destination.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_sign_pi8","","Negate packed 8-bit integers in `a` when the corresponding signed 8-bit integer in `b` is negative, and return the results. Element in result are zeroed out when the corresponding element in `b` is zero.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_sign_pi16","","Negate packed 16-bit integers in `a` when the corresponding signed 16-bit integer in `b` is negative, and return the results. Element in result are zeroed out when the corresponding element in `b` is zero.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_sign_pi32","","Negate packed 32-bit integers in `a` when the corresponding signed 32-bit integer in `b` is negative, and return the results. Element in result are zeroed out when the corresponding element in `b` is zero.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_blendv_epi8","","Blend packed 8-bit integers from `a` and `b` using `mask`",null,{"i":[{"n":"__m128i"},{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_blend_epi16","","Blend packed 16-bit integers from `a` and `b` using the mask `imm8`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_blendv_pd","","Blend packed double-precision (64-bit) floating-point elements from `a` and `b` using `mask`",null,{"i":[{"n":"__m128d"},{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_blendv_ps","","Blend packed single-precision (32-bit) floating-point elements from `a` and `b` using `mask`",null,{"i":[{"n":"__m128"},{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_blend_pd","","Blend packed double-precision (64-bit) floating-point elements from `a` and `b` using control mask `imm2`",null,{"i":[{"n":"__m128d"},{"n":"__m128d"},{"n":"i32"}],"o":{"n":"__m128d"}}],[5,"_mm_blend_ps","","Blend packed single-precision (32-bit) floating-point elements from `a` and `b` using mask `imm4`",null,{"i":[{"n":"__m128"},{"n":"__m128"},{"n":"i32"}],"o":{"n":"__m128"}}],[5,"_mm_extract_ps","","Extract a single-precision (32-bit) floating-point element from `a`, selected with `imm8`",null,{"i":[{"n":"__m128"},{"n":"i32"}],"o":{"n":"i32"}}],[5,"_mm_extract_epi8","","Extract an 8-bit integer from `a`, selected with `imm8`. Returns a 32-bit integer containing the zero-extended integer data.",null,{"i":[{"n":"__m128i"},{"n":"i32"}],"o":{"n":"i32"}}],[5,"_mm_extract_epi32","","Extract an 32-bit integer from `a` selected with `imm8`",null,{"i":[{"n":"__m128i"},{"n":"i32"}],"o":{"n":"i32"}}],[5,"_mm_insert_ps","","Select a single value in `a` to store at some position in `b`, Then zero elements according to `imm8`.",null,{"i":[{"n":"__m128"},{"n":"__m128"},{"n":"i32"}],"o":{"n":"__m128"}}],[5,"_mm_insert_epi8","","Return a copy of `a` with the 8-bit integer from `i` inserted at a location specified by `imm8`.",null,{"i":[{"n":"__m128i"},{"n":"i32"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_insert_epi32","","Return a copy of `a` with the 32-bit integer from `i` inserted at a location specified by `imm8`.",null,{"i":[{"n":"__m128i"},{"n":"i32"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_max_epi8","","Compare packed 8-bit integers in `a` and `b` and return packed maximum values in dst.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_max_epu16","","Compare packed unsigned 16-bit integers in `a` and `b`, and return packed maximum.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_max_epi32","","Compare packed 32-bit integers in `a` and `b`, and return packed maximum values.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_max_epu32","","Compare packed unsigned 32-bit integers in `a` and `b`, and return packed maximum values.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_min_epi8","","Compare packed 8-bit integers in `a` and `b` and return packed minimum values in dst.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_min_epu16","","Compare packed unsigned 16-bit integers in `a` and `b`, and return packed minimum.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_min_epi32","","Compare packed 32-bit integers in `a` and `b`, and return packed minimum values.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_min_epu32","","Compare packed unsigned 32-bit integers in `a` and `b`, and return packed minimum values.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_packus_epi32","","Convert packed 32-bit integers from `a` and `b` to packed 16-bit integers using unsigned saturation",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_cmpeq_epi64","","Compare packed 64-bit integers in `a` and `b` for equality",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_cvtepi8_epi16","","Sign extend packed 8-bit integers in `a` to packed 16-bit integers",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_cvtepi8_epi32","","Sign extend packed 8-bit integers in `a` to packed 32-bit integers",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_cvtepi8_epi64","","Sign extend packed 8-bit integers in the low 8 bytes of `a` to packed 64-bit integers",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_cvtepi16_epi32","","Sign extend packed 16-bit integers in `a` to packed 32-bit integers",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_cvtepi16_epi64","","Sign extend packed 16-bit integers in `a` to packed 64-bit integers",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_cvtepi32_epi64","","Sign extend packed 32-bit integers in `a` to packed 64-bit integers",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_cvtepu8_epi16","","Zero extend packed unsigned 8-bit integers in `a` to packed 16-bit integers",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_cvtepu8_epi32","","Zero extend packed unsigned 8-bit integers in `a` to packed 32-bit integers",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_cvtepu8_epi64","","Zero extend packed unsigned 8-bit integers in `a` to packed 64-bit integers",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_cvtepu16_epi32","","Zero extend packed unsigned 16-bit integers in `a` to packed 32-bit integers",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_cvtepu16_epi64","","Zero extend packed unsigned 16-bit integers in `a` to packed 64-bit integers",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_cvtepu32_epi64","","Zero extend packed unsigned 32-bit integers in `a` to packed 64-bit integers",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_dp_pd","","Returns the dot product of two __m128d vectors.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"},{"n":"i32"}],"o":{"n":"__m128d"}}],[5,"_mm_dp_ps","","Returns the dot product of two __m128 vectors.",null,{"i":[{"n":"__m128"},{"n":"__m128"},{"n":"i32"}],"o":{"n":"__m128"}}],[5,"_mm_floor_pd","","Round the packed double-precision (64-bit) floating-point elements in `a` down to an integer value, and store the results as packed double-precision floating-point elements.",null,{"i":[{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_floor_ps","","Round the packed single-precision (32-bit) floating-point elements in `a` down to an integer value, and store the results as packed single-precision floating-point elements.",null,{"i":[{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_floor_sd","","Round the lower double-precision (64-bit) floating-point element in `b` down to an integer value, store the result as a double-precision floating-point element in the lower element of the intrinsic result, and copy the upper element from `a` to the upper element of the intrinsic result.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_floor_ss","","Round the lower single-precision (32-bit) floating-point element in `b` down to an integer value, store the result as a single-precision floating-point element in the lower element of the intrinsic result, and copy the upper 3 packed elements from `a` to the upper elements of the intrinsic result.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_ceil_pd","","Round the packed double-precision (64-bit) floating-point elements in `a` up to an integer value, and store the results as packed double-precision floating-point elements.",null,{"i":[{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_ceil_ps","","Round the packed single-precision (32-bit) floating-point elements in `a` up to an integer value, and store the results as packed single-precision floating-point elements.",null,{"i":[{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_ceil_sd","","Round the lower double-precision (64-bit) floating-point element in `b` up to an integer value, store the result as a double-precision floating-point element in the lower element of the intrisic result, and copy the upper element from `a` to the upper element of the intrinsic result.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_ceil_ss","","Round the lower single-precision (32-bit) floating-point element in `b` up to an integer value, store the result as a single-precision floating-point element in the lower element of the intrinsic result, and copy the upper 3 packed elements from `a` to the upper elements of the intrinsic result.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_round_pd","","Round the packed double-precision (64-bit) floating-point elements in `a` using the `rounding` parameter, and store the results as packed double-precision floating-point elements. Rounding is done according to the rounding parameter, which can be one of:",null,{"i":[{"n":"__m128d"},{"n":"i32"}],"o":{"n":"__m128d"}}],[5,"_mm_round_ps","","Round the packed single-precision (32-bit) floating-point elements in `a` using the `rounding` parameter, and store the results as packed single-precision floating-point elements. Rounding is done according to the rounding parameter, which can be one of:",null,{"i":[{"n":"__m128"},{"n":"i32"}],"o":{"n":"__m128"}}],[5,"_mm_round_sd","","Round the lower double-precision (64-bit) floating-point element in `b` using the `rounding` parameter, store the result as a double-precision floating-point element in the lower element of the intrinsic result, and copy the upper element from `a` to the upper element of the intrinsic result. Rounding is done according to the rounding parameter, which can be one of:",null,{"i":[{"n":"__m128d"},{"n":"__m128d"},{"n":"i32"}],"o":{"n":"__m128d"}}],[5,"_mm_round_ss","","Round the lower single-precision (32-bit) floating-point element in `b` using the `rounding` parameter, store the result as a single-precision floating-point element in the lower element of the intrinsic result, and copy the upper 3 packed elements from `a` to the upper elements of the instrinsic result. Rounding is done according to the rounding parameter, which can be one of:",null,{"i":[{"n":"__m128"},{"n":"__m128"},{"n":"i32"}],"o":{"n":"__m128"}}],[5,"_mm_minpos_epu16","","Finds the minimum unsigned 16-bit element in the 128-bit __m128i vector, returning a vector containing its value in its first position, and its index in its second position; all other elements are set to zero.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_mul_epi32","","Multiply the low 32-bit integers from each packed 64-bit element in `a` and `b`, and return the signed 64-bit result.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_mullo_epi32","","Multiply the packed 32-bit integers in `a` and `b`, producing intermediate 64-bit integers, and returns the lowest 32-bit, whatever they might be, reinterpreted as a signed integer. While `pmulld __m128i::splat(2), __m128i::splat(2)` returns the obvious `__m128i::splat(4)`, due to wrapping arithmetic `pmulld __m128i::splat(i32::MAX), __m128i::splat(2)` would return a negative number.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_mpsadbw_epu8","","Subtracts 8-bit unsigned integer values and computes the absolute values of the differences to the corresponding bits in the destination. Then sums of the absolute differences are returned according to the bit fields in the immediate operand.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_testz_si128","","Tests whether the specified bits in a 128-bit integer vector are all zeros.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"i32"}}],[5,"_mm_testc_si128","","Tests whether the specified bits in a 128-bit integer vector are all ones.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"i32"}}],[5,"_mm_testnzc_si128","","Tests whether the specified bits in a 128-bit integer vector are neither all zeros nor all ones.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"i32"}}],[5,"_mm_test_all_zeros","","Tests whether the specified bits in a 128-bit integer vector are all zeros.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"i32"}}],[5,"_mm_test_all_ones","","Tests whether the specified bits in `a` 128-bit integer vector are all ones.",null,{"i":[{"n":"__m128i"}],"o":{"n":"i32"}}],[5,"_mm_test_mix_ones_zeros","","Tests whether the specified bits in a 128-bit integer vector are neither all zeros nor all ones.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"i32"}}],[5,"_mm_cmpistrm","","Compare packed strings with implicit lengths in `a` and `b` using the control in `imm8`, and return the generated mask.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_cmpistri","","Compare packed strings with implicit lengths in `a` and `b` using the control in `imm8` and return the generated index. Similar to [`_mm_cmpestri`] with the exception that [`_mm_cmpestri`] requires the lengths of `a` and `b` to be explicitly specified.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"},{"n":"i32"}],"o":{"n":"i32"}}],[5,"_mm_cmpistrz","","Compare packed strings with implicit lengths in `a` and `b` using the control in `imm8`, and return `1` if any character in `b` was null. and `0` otherwise.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"},{"n":"i32"}],"o":{"n":"i32"}}],[5,"_mm_cmpistrc","","Compare packed strings with implicit lengths in `a` and `b` using the control in `imm8`, and return `1` if the resulting mask was non-zero, and `0` otherwise.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"},{"n":"i32"}],"o":{"n":"i32"}}],[5,"_mm_cmpistrs","","Compare packed strings with implicit lengths in `a` and `b` using the control in `imm8`, and returns `1` if any character in `a` was null, and `0` otherwise.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"},{"n":"i32"}],"o":{"n":"i32"}}],[5,"_mm_cmpistro","","Compare packed strings with implicit lengths in `a` and `b` using the control in `imm8`, and return bit `0` of the resulting bit mask.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"},{"n":"i32"}],"o":{"n":"i32"}}],[5,"_mm_cmpistra","","Compare packed strings with implicit lengths in `a` and `b` using the control in `imm8`, and return `1` if `b` did not contain a null character and the resulting mask was zero, and `0` otherwise.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"},{"n":"i32"}],"o":{"n":"i32"}}],[5,"_mm_cmpestrm","","Compare packed strings in `a` and `b` with lengths `la` and `lb` using the control in `imm8`, and return the generated mask.",null,{"i":[{"n":"__m128i"},{"n":"i32"},{"n":"__m128i"},{"n":"i32"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_cmpestri","","Compare packed strings `a` and `b` with lengths `la` and `lb` using the control in `imm8` and return the generated index. Similar to [`_mm_cmpistri`] with the exception that [`_mm_cmpistri`] implicitly determines the length of `a` and `b`.",null,{"i":[{"n":"__m128i"},{"n":"i32"},{"n":"__m128i"},{"n":"i32"},{"n":"i32"}],"o":{"n":"i32"}}],[5,"_mm_cmpestrz","","Compare packed strings in `a` and `b` with lengths `la` and `lb` using the control in `imm8`, and return `1` if any character in `b` was null, and `0` otherwise.",null,{"i":[{"n":"__m128i"},{"n":"i32"},{"n":"__m128i"},{"n":"i32"},{"n":"i32"}],"o":{"n":"i32"}}],[5,"_mm_cmpestrc","","Compare packed strings in `a` and `b` with lengths `la` and `lb` using the control in `imm8`, and return `1` if the resulting mask was non-zero, and `0` otherwise.",null,{"i":[{"n":"__m128i"},{"n":"i32"},{"n":"__m128i"},{"n":"i32"},{"n":"i32"}],"o":{"n":"i32"}}],[5,"_mm_cmpestrs","","Compare packed strings in `a` and `b` with lengths `la` and `lb` using the control in `imm8`, and return `1` if any character in a was null, and `0` otherwise.",null,{"i":[{"n":"__m128i"},{"n":"i32"},{"n":"__m128i"},{"n":"i32"},{"n":"i32"}],"o":{"n":"i32"}}],[5,"_mm_cmpestro","","Compare packed strings in `a` and `b` with lengths `la` and `lb` using the control in `imm8`, and return bit `0` of the resulting bit mask.",null,{"i":[{"n":"__m128i"},{"n":"i32"},{"n":"__m128i"},{"n":"i32"},{"n":"i32"}],"o":{"n":"i32"}}],[5,"_mm_cmpestra","","Compare packed strings in `a` and `b` with lengths `la` and `lb` using the control in `imm8`, and return `1` if `b` did not contain a null character and the resulting mask was zero, and `0` otherwise.",null,{"i":[{"n":"__m128i"},{"n":"i32"},{"n":"__m128i"},{"n":"i32"},{"n":"i32"}],"o":{"n":"i32"}}],[5,"_mm_crc32_u8","","Starting with the initial value in `crc`, return the accumulated CRC32 value for unsigned 8-bit integer `v`.",null,{"i":[{"n":"u32"},{"n":"u8"}],"o":{"n":"u32"}}],[5,"_mm_crc32_u16","","Starting with the initial value in `crc`, return the accumulated CRC32 value for unsigned 16-bit integer `v`.",null,{"i":[{"n":"u32"},{"n":"u16"}],"o":{"n":"u32"}}],[5,"_mm_crc32_u32","","Starting with the initial value in `crc`, return the accumulated CRC32 value for unsigned 32-bit integer `v`.",null,{"i":[{"n":"u32"},{"n":"u32"}],"o":{"n":"u32"}}],[5,"_mm_cmpgt_epi64","","Compare packed 64-bit integers in `a` and `b` for greater-than, return the results.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm256_add_pd","","Add packed double-precision (64-bit) floating-point elements in `a` and `b`.",null,{"i":[{"n":"__m256d"},{"n":"__m256d"}],"o":{"n":"__m256d"}}],[5,"_mm256_add_ps","","Add packed single-precision (32-bit) floating-point elements in `a` and `b`.",null,{"i":[{"n":"__m256"},{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm256_and_pd","","Compute the bitwise AND of a packed double-precision (64-bit) floating-point elements in `a` and `b`.",null,{"i":[{"n":"__m256d"},{"n":"__m256d"}],"o":{"n":"__m256d"}}],[5,"_mm256_and_ps","","Compute the bitwise AND of packed single-precision (32-bit) floating-point elements in `a` and `b`.",null,{"i":[{"n":"__m256"},{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm256_or_pd","","Compute the bitwise OR packed double-precision (64-bit) floating-point elements in `a` and `b`.",null,{"i":[{"n":"__m256d"},{"n":"__m256d"}],"o":{"n":"__m256d"}}],[5,"_mm256_or_ps","","Compute the bitwise OR packed single-precision (32-bit) floating-point elements in `a` and `b`.",null,{"i":[{"n":"__m256"},{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm256_shuffle_pd","","Shuffle double-precision (64-bit) floating-point elements within 128-bit lanes using the control in `imm8`.",null,{"i":[{"n":"__m256d"},{"n":"__m256d"},{"n":"i32"}],"o":{"n":"__m256d"}}],[5,"_mm256_shuffle_ps","","Shuffle single-precision (32-bit) floating-point elements in `a` within 128-bit lanes using the control in `imm8`.",null,{"i":[{"n":"__m256"},{"n":"__m256"},{"n":"i32"}],"o":{"n":"__m256"}}],[5,"_mm256_andnot_pd","","Compute the bitwise NOT of packed double-precision (64-bit) floating-point elements in `a` and then AND with `b`.",null,{"i":[{"n":"__m256d"},{"n":"__m256d"}],"o":{"n":"__m256d"}}],[5,"_mm256_andnot_ps","","Compute the bitwise NOT of packed single-precision (32-bit) floating-point elements in `a` and then AND with `b`.",null,{"i":[{"n":"__m256"},{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm256_max_pd","","Compare packed double-precision (64-bit) floating-point elements in `a` and `b`, and return packed maximum values",null,{"i":[{"n":"__m256d"},{"n":"__m256d"}],"o":{"n":"__m256d"}}],[5,"_mm256_max_ps","","Compare packed single-precision (32-bit) floating-point elements in `a` and `b`, and return packed maximum values",null,{"i":[{"n":"__m256"},{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm256_min_pd","","Compare packed double-precision (64-bit) floating-point elements in `a` and `b`, and return packed minimum values",null,{"i":[{"n":"__m256d"},{"n":"__m256d"}],"o":{"n":"__m256d"}}],[5,"_mm256_min_ps","","Compare packed single-precision (32-bit) floating-point elements in `a` and `b`, and return packed minimum values",null,{"i":[{"n":"__m256"},{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm256_mul_pd","","Add packed double-precision (64-bit) floating-point elements in `a` and `b`.",null,{"i":[{"n":"__m256d"},{"n":"__m256d"}],"o":{"n":"__m256d"}}],[5,"_mm256_mul_ps","","Add packed single-precision (32-bit) floating-point elements in `a` and `b`.",null,{"i":[{"n":"__m256"},{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm256_addsub_pd","","Alternatively add and subtract packed double-precision (64-bit) floating-point elements in `a` to/from packed elements in `b`.",null,{"i":[{"n":"__m256d"},{"n":"__m256d"}],"o":{"n":"__m256d"}}],[5,"_mm256_addsub_ps","","Alternatively add and subtract packed single-precision (32-bit) floating-point elements in `a` to/from packed elements in `b`.",null,{"i":[{"n":"__m256"},{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm256_sub_pd","","Subtract packed double-precision (64-bit) floating-point elements in `b` from packed elements in `a`.",null,{"i":[{"n":"__m256d"},{"n":"__m256d"}],"o":{"n":"__m256d"}}],[5,"_mm256_sub_ps","","Subtract packed single-precision (32-bit) floating-point elements in `b` from packed elements in `a`.",null,{"i":[{"n":"__m256"},{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm256_div_ps","","Compute the division of each of the 8 packed 32-bit floating-point elements in `a` by the corresponding packed elements in `b`.",null,{"i":[{"n":"__m256"},{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm256_div_pd","","Compute the division of each of the 4 packed 64-bit floating-point elements in `a` by the corresponding packed elements in `b`.",null,{"i":[{"n":"__m256d"},{"n":"__m256d"}],"o":{"n":"__m256d"}}],[5,"_mm256_round_pd","","Round packed double-precision (64-bit) floating point elements in `a` according to the flag `b`. The value of `b` may be as follows:",null,{"i":[{"n":"__m256d"},{"n":"i32"}],"o":{"n":"__m256d"}}],[5,"_mm256_ceil_pd","","Round packed double-precision (64-bit) floating point elements in `a` toward positive infinity.",null,{"i":[{"n":"__m256d"}],"o":{"n":"__m256d"}}],[5,"_mm256_floor_pd","","Round packed double-precision (64-bit) floating point elements in `a` toward negative infinity.",null,{"i":[{"n":"__m256d"}],"o":{"n":"__m256d"}}],[5,"_mm256_round_ps","","Round packed single-precision (32-bit) floating point elements in `a` according to the flag `b`. The value of `b` may be as follows:",null,{"i":[{"n":"__m256"},{"n":"i32"}],"o":{"n":"__m256"}}],[5,"_mm256_ceil_ps","","Round packed single-precision (32-bit) floating point elements in `a` toward positive infinity.",null,{"i":[{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm256_floor_ps","","Round packed single-precision (32-bit) floating point elements in `a` toward negative infinity.",null,{"i":[{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm256_sqrt_ps","","Return the square root of packed single-precision (32-bit) floating point elements in `a`.",null,{"i":[{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm256_sqrt_pd","","Return the square root of packed double-precision (64-bit) floating point elements in `a`.",null,{"i":[{"n":"__m256d"}],"o":{"n":"__m256d"}}],[5,"_mm256_blend_pd","","Blend packed double-precision (64-bit) floating-point elements from `a` and `b` using control mask `imm8`.",null,{"i":[{"n":"__m256d"},{"n":"__m256d"},{"n":"i32"}],"o":{"n":"__m256d"}}],[5,"_mm256_blend_ps","","Blend packed single-precision (32-bit) floating-point elements from `a` and `b` using control mask `imm8`.",null,{"i":[{"n":"__m256"},{"n":"__m256"},{"n":"i32"}],"o":{"n":"__m256"}}],[5,"_mm256_blendv_pd","","Blend packed double-precision (64-bit) floating-point elements from `a` and `b` using `c` as a mask.",null,{"i":[{"n":"__m256d"},{"n":"__m256d"},{"n":"__m256d"}],"o":{"n":"__m256d"}}],[5,"_mm256_blendv_ps","","Blend packed single-precision (32-bit) floating-point elements from `a` and `b` using `c` as a mask.",null,{"i":[{"n":"__m256"},{"n":"__m256"},{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm256_dp_ps","","Conditionally multiply the packed single-precision (32-bit) floating-point elements in `a` and `b` using the high 4 bits in `imm8`, sum the four products, and conditionally return the sum  using the low 4 bits of `imm8`.",null,{"i":[{"n":"__m256"},{"n":"__m256"},{"n":"i32"}],"o":{"n":"__m256"}}],[5,"_mm256_hadd_pd","","Horizontal addition of adjacent pairs in the two packed vectors of 4 64-bit floating points `a` and `b`. In the result, sums of elements from `a` are returned in even locations, while sums of elements from `b` are returned in odd locations.",null,{"i":[{"n":"__m256d"},{"n":"__m256d"}],"o":{"n":"__m256d"}}],[5,"_mm256_hadd_ps","","Horizontal addition of adjacent pairs in the two packed vectors of 8 32-bit floating points `a` and `b`. In the result, sums of elements from `a` are returned in locations of indices 0, 1, 4, 5; while sums of elements from `b` are locations 2, 3, 6, 7.",null,{"i":[{"n":"__m256"},{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm256_hsub_pd","","Horizontal subtraction of adjacent pairs in the two packed vectors of 4 64-bit floating points `a` and `b`. In the result, sums of elements from `a` are returned in even locations, while sums of elements from `b` are returned in odd locations.",null,{"i":[{"n":"__m256d"},{"n":"__m256d"}],"o":{"n":"__m256d"}}],[5,"_mm256_hsub_ps","","Horizontal subtraction of adjacent pairs in the two packed vectors of 8 32-bit floating points `a` and `b`. In the result, sums of elements from `a` are returned in locations of indices 0, 1, 4, 5; while sums of elements from `b` are locations 2, 3, 6, 7.",null,{"i":[{"n":"__m256"},{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm256_xor_pd","","Compute the bitwise XOR of packed double-precision (64-bit) floating-point elements in `a` and `b`.",null,{"i":[{"n":"__m256d"},{"n":"__m256d"}],"o":{"n":"__m256d"}}],[5,"_mm256_xor_ps","","Compute the bitwise XOR of packed single-precision (32-bit) floating-point elements in `a` and `b`.",null,{"i":[{"n":"__m256"},{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm_cmp_pd","","Compare packed double-precision (64-bit) floating-point elements in `a` and `b` based on the comparison operand specified by `imm8`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"},{"n":"i32"}],"o":{"n":"__m128d"}}],[5,"_mm256_cmp_pd","","Compare packed double-precision (64-bit) floating-point elements in `a` and `b` based on the comparison operand specified by `imm8`.",null,{"i":[{"n":"__m256d"},{"n":"__m256d"},{"n":"i32"}],"o":{"n":"__m256d"}}],[5,"_mm_cmp_ps","","Compare packed single-precision (32-bit) floating-point elements in `a` and `b` based on the comparison operand specified by `imm8`.",null,{"i":[{"n":"__m128"},{"n":"__m128"},{"n":"i32"}],"o":{"n":"__m128"}}],[5,"_mm256_cmp_ps","","Compare packed single-precision (32-bit) floating-point elements in `a` and `b` based on the comparison operand specified by `imm8`.",null,{"i":[{"n":"__m256"},{"n":"__m256"},{"n":"i32"}],"o":{"n":"__m256"}}],[5,"_mm_cmp_sd","","Compare the lower double-precision (64-bit) floating-point element in `a` and `b` based on the comparison operand specified by `imm8`, store the result in the lower element of returned vector, and copy the upper element from `a` to the upper element of returned vector.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"},{"n":"i32"}],"o":{"n":"__m128d"}}],[5,"_mm_cmp_ss","","Compare the lower single-precision (32-bit) floating-point element in `a` and `b` based on the comparison operand specified by `imm8`, store the result in the lower element of returned vector, and copy the upper 3 packed elements from `a` to the upper elements of returned vector.",null,{"i":[{"n":"__m128"},{"n":"__m128"},{"n":"i32"}],"o":{"n":"__m128"}}],[5,"_mm256_cvtepi32_pd","","Convert packed 32-bit integers in `a` to packed double-precision (64-bit) floating-point elements.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m256d"}}],[5,"_mm256_cvtepi32_ps","","Convert packed 32-bit integers in `a` to packed single-precision (32-bit) floating-point elements.",null,{"i":[{"n":"__m256i"}],"o":{"n":"__m256"}}],[5,"_mm256_cvtpd_ps","","Convert packed double-precision (64-bit) floating-point elements in `a` to packed single-precision (32-bit) floating-point elements.",null,{"i":[{"n":"__m256d"}],"o":{"n":"__m128"}}],[5,"_mm256_cvtps_epi32","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers.",null,{"i":[{"n":"__m256"}],"o":{"n":"__m256i"}}],[5,"_mm256_cvtps_pd","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed double-precision (64-bit) floating-point elements.",null,{"i":[{"n":"__m128"}],"o":{"n":"__m256d"}}],[5,"_mm256_cvttpd_epi32","","Convert packed double-precision (64-bit) floating-point elements in `a` to packed 32-bit integers with truncation.",null,{"i":[{"n":"__m256d"}],"o":{"n":"__m128i"}}],[5,"_mm256_cvtpd_epi32","","Convert packed double-precision (64-bit) floating-point elements in `a` to packed 32-bit integers.",null,{"i":[{"n":"__m256d"}],"o":{"n":"__m128i"}}],[5,"_mm256_cvttps_epi32","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers with truncation.",null,{"i":[{"n":"__m256"}],"o":{"n":"__m256i"}}],[5,"_mm256_extractf128_ps","","Extract 128 bits (composed of 4 packed single-precision (32-bit) floating-point elements) from `a`, selected with `imm8`.",null,{"i":[{"n":"__m256"},{"n":"i32"}],"o":{"n":"__m128"}}],[5,"_mm256_extractf128_pd","","Extract 128 bits (composed of 2 packed double-precision (64-bit) floating-point elements) from `a`, selected with `imm8`.",null,{"i":[{"n":"__m256d"},{"n":"i32"}],"o":{"n":"__m128d"}}],[5,"_mm256_extractf128_si256","","Extract 128 bits (composed of integer data) from `a`, selected with `imm8`.",null,{"i":[{"n":"__m256i"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm256_zeroall","","Zero the contents of all XMM or YMM registers.",null,{}],[5,"_mm256_zeroupper","","Zero the upper 128 bits of all YMM registers; the lower 128-bits of the registers are unmodified.",null,{}],[5,"_mm256_permutevar_ps","","Shuffle single-precision (32-bit) floating-point elements in `a` within 128-bit lanes using the control in `b`.",null,{"i":[{"n":"__m256"},{"n":"__m256i"}],"o":{"n":"__m256"}}],[5,"_mm_permutevar_ps","","Shuffle single-precision (32-bit) floating-point elements in `a` using the control in `b`.",null,{"i":[{"n":"__m128"},{"n":"__m128i"}],"o":{"n":"__m128"}}],[5,"_mm256_permute_ps","","Shuffle single-precision (32-bit) floating-point elements in `a` within 128-bit lanes using the control in `imm8`.",null,{"i":[{"n":"__m256"},{"n":"i32"}],"o":{"n":"__m256"}}],[5,"_mm_permute_ps","","Shuffle single-precision (32-bit) floating-point elements in `a` using the control in `imm8`.",null,{"i":[{"n":"__m128"},{"n":"i32"}],"o":{"n":"__m128"}}],[5,"_mm256_permutevar_pd","","Shuffle double-precision (64-bit) floating-point elements in `a` within 256-bit lanes using the control in `b`.",null,{"i":[{"n":"__m256d"},{"n":"__m256i"}],"o":{"n":"__m256d"}}],[5,"_mm_permutevar_pd","","Shuffle double-precision (64-bit) floating-point elements in `a` using the control in `b`.",null,{"i":[{"n":"__m128d"},{"n":"__m128i"}],"o":{"n":"__m128d"}}],[5,"_mm256_permute_pd","","Shuffle double-precision (64-bit) floating-point elements in `a` within 128-bit lanes using the control in `imm8`.",null,{"i":[{"n":"__m256d"},{"n":"i32"}],"o":{"n":"__m256d"}}],[5,"_mm_permute_pd","","Shuffle double-precision (64-bit) floating-point elements in `a` using the control in `imm8`.",null,{"i":[{"n":"__m128d"},{"n":"i32"}],"o":{"n":"__m128d"}}],[5,"_mm256_permute2f128_ps","","Shuffle 256-bits (composed of 8 packed single-precision (32-bit) floating-point elements) selected by `imm8` from `a` and `b`.",null,{"i":[{"n":"__m256"},{"n":"__m256"},{"n":"i32"}],"o":{"n":"__m256"}}],[5,"_mm256_permute2f128_pd","","Shuffle 256-bits (composed of 4 packed double-precision (64-bit) floating-point elements) selected by `imm8` from `a` and `b`.",null,{"i":[{"n":"__m256d"},{"n":"__m256d"},{"n":"i32"}],"o":{"n":"__m256d"}}],[5,"_mm256_permute2f128_si256","","Shuffle 258-bits (composed of integer data) selected by `imm8` from `a` and `b`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm256_broadcast_ss","","Broadcast a single-precision (32-bit) floating-point element from memory to all elements of the returned vector.",null,{"i":[{"n":"f32"}],"o":{"n":"__m256"}}],[5,"_mm_broadcast_ss","","Broadcast a single-precision (32-bit) floating-point element from memory to all elements of the returned vector.",null,{"i":[{"n":"f32"}],"o":{"n":"__m128"}}],[5,"_mm256_broadcast_sd","","Broadcast a double-precision (64-bit) floating-point element from memory to all elements of the returned vector.",null,{"i":[{"n":"f64"}],"o":{"n":"__m256d"}}],[5,"_mm256_broadcast_ps","","Broadcast 128 bits from memory (composed of 4 packed single-precision (32-bit) floating-point elements) to all elements of the returned vector.",null,{"i":[{"n":"__m128"}],"o":{"n":"__m256"}}],[5,"_mm256_broadcast_pd","","Broadcast 128 bits from memory (composed of 2 packed double-precision (64-bit) floating-point elements) to all elements of the returned vector.",null,{"i":[{"n":"__m128d"}],"o":{"n":"__m256d"}}],[5,"_mm256_insertf128_ps","","Copy `a` to result, then insert 128 bits (composed of 4 packed single-precision (32-bit) floating-point elements) from `b` into result at the location specified by `imm8`.",null,{"i":[{"n":"__m256"},{"n":"__m128"},{"n":"i32"}],"o":{"n":"__m256"}}],[5,"_mm256_insertf128_pd","","Copy `a` to result, then insert 128 bits (composed of 2 packed double-precision (64-bit) floating-point elements) from `b` into result at the location specified by `imm8`.",null,{"i":[{"n":"__m256d"},{"n":"__m128d"},{"n":"i32"}],"o":{"n":"__m256d"}}],[5,"_mm256_insertf128_si256","","Copy `a` to result, then insert 128 bits from `b` into result at the location specified by `imm8`.",null,{"i":[{"n":"__m256i"},{"n":"__m128i"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm256_insert_epi8","","Copy `a` to result, and insert the 8-bit integer `i` into result at the location specified by `index`.",null,{"i":[{"n":"__m256i"},{"n":"i8"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm256_insert_epi16","","Copy `a` to result, and insert the 16-bit integer `i` into result at the location specified by `index`.",null,{"i":[{"n":"__m256i"},{"n":"i16"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm256_insert_epi32","","Copy `a` to result, and insert the 32-bit integer `i` into result at the location specified by `index`.",null,{"i":[{"n":"__m256i"},{"n":"i32"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm256_load_pd","","Load 256-bits (composed of 4 packed double-precision (64-bit) floating-point elements) from memory into result. `mem_addr` must be aligned on a 32-byte boundary or a general-protection exception may be generated.",null,null],[5,"_mm256_store_pd","","Store 256-bits (composed of 4 packed double-precision (64-bit) floating-point elements) from `a` into memory. `mem_addr` must be aligned on a 32-byte boundary or a general-protection exception may be generated.",null,null],[5,"_mm256_load_ps","","Load 256-bits (composed of 8 packed single-precision (32-bit) floating-point elements) from memory into result. `mem_addr` must be aligned on a 32-byte boundary or a general-protection exception may be generated.",null,null],[5,"_mm256_store_ps","","Store 256-bits (composed of 8 packed single-precision (32-bit) floating-point elements) from `a` into memory. `mem_addr` must be aligned on a 32-byte boundary or a general-protection exception may be generated.",null,null],[5,"_mm256_loadu_pd","","Load 256-bits (composed of 4 packed double-precision (64-bit) floating-point elements) from memory into result. `mem_addr` does not need to be aligned on any particular boundary.",null,null],[5,"_mm256_storeu_pd","","Store 256-bits (composed of 4 packed double-precision (64-bit) floating-point elements) from `a` into memory. `mem_addr` does not need to be aligned on any particular boundary.",null,null],[5,"_mm256_loadu_ps","","Load 256-bits (composed of 8 packed single-precision (32-bit) floating-point elements) from memory into result. `mem_addr` does not need to be aligned on any particular boundary.",null,null],[5,"_mm256_storeu_ps","","Store 256-bits (composed of 8 packed single-precision (32-bit) floating-point elements) from `a` into memory. `mem_addr` does not need to be aligned on any particular boundary.",null,null],[5,"_mm256_load_si256","","Load 256-bits of integer data from memory into result. `mem_addr` must be aligned on a 32-byte boundary or a general-protection exception may be generated.",null,null],[5,"_mm256_store_si256","","Store 256-bits of integer data from `a` into memory. `mem_addr` must be aligned on a 32-byte boundary or a general-protection exception may be generated.",null,null],[5,"_mm256_loadu_si256","","Load 256-bits of integer data from memory into result. `mem_addr` does not need to be aligned on any particular boundary.",null,null],[5,"_mm256_storeu_si256","","Store 256-bits of integer data from `a` into memory.    `mem_addr` does not need to be aligned on any particular boundary.",null,null],[5,"_mm256_maskload_pd","","Load packed double-precision (64-bit) floating-point elements from memory into result using `mask` (elements are zeroed out when the high bit of the corresponding element is not set).",null,null],[5,"_mm256_maskstore_pd","","Store packed double-precision (64-bit) floating-point elements from `a` into memory using `mask`.",null,null],[5,"_mm_maskload_pd","","Load packed double-precision (64-bit) floating-point elements from memory into result using `mask` (elements are zeroed out when the high bit of the corresponding element is not set).",null,null],[5,"_mm_maskstore_pd","","Store packed double-precision (64-bit) floating-point elements from `a` into memory using `mask`.",null,null],[5,"_mm256_maskload_ps","","Load packed single-precision (32-bit) floating-point elements from memory into result using `mask` (elements are zeroed out when the high bit of the corresponding element is not set).",null,null],[5,"_mm256_maskstore_ps","","Store packed single-precision (32-bit) floating-point elements from `a` into memory using `mask`.",null,null],[5,"_mm_maskload_ps","","Load packed single-precision (32-bit) floating-point elements from memory into result using `mask` (elements are zeroed out when the high bit of the corresponding element is not set).",null,null],[5,"_mm_maskstore_ps","","Store packed single-precision (32-bit) floating-point elements from `a` into memory using `mask`.",null,null],[5,"_mm256_movehdup_ps","","Duplicate odd-indexed single-precision (32-bit) floating-point elements from `a`, and return the results.",null,{"i":[{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm256_moveldup_ps","","Duplicate even-indexed single-precision (32-bit) floating-point elements from `a`, and return the results.",null,{"i":[{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm256_movedup_pd","","Duplicate even-indexed double-precision (64-bit) floating-point elements from \"a\", and return the results.",null,{"i":[{"n":"__m256d"}],"o":{"n":"__m256d"}}],[5,"_mm256_lddqu_si256","","Load 256-bits of integer data from unaligned memory into result. This intrinsic may perform better than `_mm256_loadu_si256` when the data crosses a cache line boundary.",null,null],[5,"_mm256_stream_si256","","Moves integer data from a 256-bit integer vector to a 32-byte aligned memory location. To minimize caching, the data is flagged as non-temporal (unlikely to be used again soon)",null,null],[5,"_mm256_stream_pd","","Moves double-precision values from a 256-bit vector of `[4 x double]` to a 32-byte aligned memory location. To minimize caching, the data is flagged as non-temporal (unlikely to be used again soon).",null,null],[5,"_mm256_stream_ps","","Moves single-precision floating point values from a 256-bit vector of `[8 x float]` to a 32-byte aligned memory location. To minimize caching, the data is flagged as non-temporal (unlikely to be used again soon).",null,null],[5,"_mm256_rcp_ps","","Compute the approximate reciprocal of packed single-precision (32-bit) floating-point elements in `a`, and return the results. The maximum relative error for this approximation is less than 1.5*2^-12.",null,{"i":[{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm256_rsqrt_ps","","Compute the approximate reciprocal square root of packed single-precision (32-bit) floating-point elements in `a`, and return the results. The maximum relative error for this approximation is less than 1.5*2^-12.",null,{"i":[{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm256_unpackhi_pd","","Unpack and interleave double-precision (64-bit) floating-point elements from the high half of each 128-bit lane in `a` and `b`.",null,{"i":[{"n":"__m256d"},{"n":"__m256d"}],"o":{"n":"__m256d"}}],[5,"_mm256_unpackhi_ps","","Unpack and interleave single-precision (32-bit) floating-point elements from the high half of each 128-bit lane in `a` and `b`.",null,{"i":[{"n":"__m256"},{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm256_unpacklo_pd","","Unpack and interleave double-precision (64-bit) floating-point elements from the low half of each 128-bit lane in `a` and `b`.",null,{"i":[{"n":"__m256d"},{"n":"__m256d"}],"o":{"n":"__m256d"}}],[5,"_mm256_unpacklo_ps","","Unpack and interleave single-precision (32-bit) floating-point elements from the low half of each 128-bit lane in `a` and `b`.",null,{"i":[{"n":"__m256"},{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm256_testz_si256","","Compute the bitwise AND of 256 bits (representing integer data) in `a` and `b`, and set `ZF` to 1 if the result is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, and set `CF` to 1 if the result is zero, otherwise set `CF` to 0. Return the `ZF` value.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"i32"}}],[5,"_mm256_testc_si256","","Compute the bitwise AND of 256 bits (representing integer data) in `a` and `b`, and set `ZF` to 1 if the result is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, and set `CF` to 1 if the result is zero, otherwise set `CF` to 0. Return the `CF` value.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"i32"}}],[5,"_mm256_testnzc_si256","","Compute the bitwise AND of 256 bits (representing integer data) in `a` and `b`, and set `ZF` to 1 if the result is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, and set `CF` to 1 if the result is zero, otherwise set `CF` to 0. Return 1 if both the `ZF` and `CF` values are zero, otherwise return 0.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"i32"}}],[5,"_mm256_testz_pd","","Compute the bitwise AND of 256 bits (representing double-precision (64-bit) floating-point elements) in `a` and `b`, producing an intermediate 256-bit value, and set `ZF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `ZF` value.",null,{"i":[{"n":"__m256d"},{"n":"__m256d"}],"o":{"n":"i32"}}],[5,"_mm256_testc_pd","","Compute the bitwise AND of 256 bits (representing double-precision (64-bit) floating-point elements) in `a` and `b`, producing an intermediate 256-bit value, and set `ZF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `CF` value.",null,{"i":[{"n":"__m256d"},{"n":"__m256d"}],"o":{"n":"i32"}}],[5,"_mm256_testnzc_pd","","Compute the bitwise AND of 256 bits (representing double-precision (64-bit) floating-point elements) in `a` and `b`, producing an intermediate 256-bit value, and set `ZF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return 1 if both the `ZF` and `CF` values are zero, otherwise return 0.",null,{"i":[{"n":"__m256d"},{"n":"__m256d"}],"o":{"n":"i32"}}],[5,"_mm_testz_pd","","Compute the bitwise AND of 128 bits (representing double-precision (64-bit) floating-point elements) in `a` and `b`, producing an intermediate 128-bit value, and set `ZF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `ZF` value.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"i32"}}],[5,"_mm_testc_pd","","Compute the bitwise AND of 128 bits (representing double-precision (64-bit) floating-point elements) in `a` and `b`, producing an intermediate 128-bit value, and set `ZF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `CF` value.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"i32"}}],[5,"_mm_testnzc_pd","","Compute the bitwise AND of 128 bits (representing double-precision (64-bit) floating-point elements) in `a` and `b`, producing an intermediate 128-bit value, and set `ZF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return 1 if both the `ZF` and `CF` values are zero, otherwise return 0.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"i32"}}],[5,"_mm256_testz_ps","","Compute the bitwise AND of 256 bits (representing single-precision (32-bit) floating-point elements) in `a` and `b`, producing an intermediate 256-bit value, and set `ZF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `ZF` value.",null,{"i":[{"n":"__m256"},{"n":"__m256"}],"o":{"n":"i32"}}],[5,"_mm256_testc_ps","","Compute the bitwise AND of 256 bits (representing single-precision (32-bit) floating-point elements) in `a` and `b`, producing an intermediate 256-bit value, and set `ZF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `CF` value.",null,{"i":[{"n":"__m256"},{"n":"__m256"}],"o":{"n":"i32"}}],[5,"_mm256_testnzc_ps","","Compute the bitwise AND of 256 bits (representing single-precision (32-bit) floating-point elements) in `a` and `b`, producing an intermediate 256-bit value, and set `ZF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return 1 if both the `ZF` and `CF` values are zero, otherwise return 0.",null,{"i":[{"n":"__m256"},{"n":"__m256"}],"o":{"n":"i32"}}],[5,"_mm_testz_ps","","Compute the bitwise AND of 128 bits (representing single-precision (32-bit) floating-point elements) in `a` and `b`, producing an intermediate 128-bit value, and set `ZF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `ZF` value.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"i32"}}],[5,"_mm_testc_ps","","Compute the bitwise AND of 128 bits (representing single-precision (32-bit) floating-point elements) in `a` and `b`, producing an intermediate 128-bit value, and set `ZF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `CF` value.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"i32"}}],[5,"_mm_testnzc_ps","","Compute the bitwise AND of 128 bits (representing single-precision (32-bit) floating-point elements) in `a` and `b`, producing an intermediate 128-bit value, and set `ZF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return 1 if both the `ZF` and `CF` values are zero, otherwise return 0.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"i32"}}],[5,"_mm256_movemask_pd","","Set each bit of the returned mask based on the most significant bit of the corresponding packed double-precision (64-bit) floating-point element in `a`.",null,{"i":[{"n":"__m256d"}],"o":{"n":"i32"}}],[5,"_mm256_movemask_ps","","Set each bit of the returned mask based on the most significant bit of the corresponding packed single-precision (32-bit) floating-point element in `a`.",null,{"i":[{"n":"__m256"}],"o":{"n":"i32"}}],[5,"_mm256_setzero_pd","","Return vector of type __m256d with all elements set to zero.",null,{"o":{"n":"__m256d"}}],[5,"_mm256_setzero_ps","","Return vector of type __m256 with all elements set to zero.",null,{"o":{"n":"__m256"}}],[5,"_mm256_setzero_si256","","Return vector of type __m256i with all elements set to zero.",null,{"o":{"n":"__m256i"}}],[5,"_mm256_set_pd","","Set packed double-precision (64-bit) floating-point elements in returned vector with the supplied values.",null,{"i":[{"n":"f64"},{"n":"f64"},{"n":"f64"},{"n":"f64"}],"o":{"n":"__m256d"}}],[5,"_mm256_set_ps","","Set packed single-precision (32-bit) floating-point elements in returned vector with the supplied values.",null,{"i":[{"n":"f32"},{"n":"f32"},{"n":"f32"},{"n":"f32"},{"n":"f32"},{"n":"f32"},{"n":"f32"},{"n":"f32"}],"o":{"n":"__m256"}}],[5,"_mm256_set_epi8","","Set packed 8-bit integers in returned vector with the supplied values in reverse order.",null,{"i":[{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"}],"o":{"n":"__m256i"}}],[5,"_mm256_set_epi16","","Set packed 16-bit integers in returned vector with the supplied values.",null,{"i":[{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"}],"o":{"n":"__m256i"}}],[5,"_mm256_set_epi32","","Set packed 32-bit integers in returned vector with the supplied values.",null,{"i":[{"n":"i32"},{"n":"i32"},{"n":"i32"},{"n":"i32"},{"n":"i32"},{"n":"i32"},{"n":"i32"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm256_set_epi64x","","Set packed 64-bit integers in returned vector with the supplied values.",null,{"i":[{"n":"i64"},{"n":"i64"},{"n":"i64"},{"n":"i64"}],"o":{"n":"__m256i"}}],[5,"_mm256_setr_pd","","Set packed double-precision (64-bit) floating-point elements in returned vector with the supplied values in reverse order.",null,{"i":[{"n":"f64"},{"n":"f64"},{"n":"f64"},{"n":"f64"}],"o":{"n":"__m256d"}}],[5,"_mm256_setr_ps","","Set packed single-precision (32-bit) floating-point elements in returned vector with the supplied values in reverse order.",null,{"i":[{"n":"f32"},{"n":"f32"},{"n":"f32"},{"n":"f32"},{"n":"f32"},{"n":"f32"},{"n":"f32"},{"n":"f32"}],"o":{"n":"__m256"}}],[5,"_mm256_setr_epi8","","Set packed 8-bit integers in returned vector with the supplied values in reverse order.",null,{"i":[{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"}],"o":{"n":"__m256i"}}],[5,"_mm256_setr_epi16","","Set packed 16-bit integers in returned vector with the supplied values in reverse order.",null,{"i":[{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"}],"o":{"n":"__m256i"}}],[5,"_mm256_setr_epi32","","Set packed 32-bit integers in returned vector with the supplied values in reverse order.",null,{"i":[{"n":"i32"},{"n":"i32"},{"n":"i32"},{"n":"i32"},{"n":"i32"},{"n":"i32"},{"n":"i32"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm256_setr_epi64x","","Set packed 64-bit integers in returned vector with the supplied values in reverse order.",null,{"i":[{"n":"i64"},{"n":"i64"},{"n":"i64"},{"n":"i64"}],"o":{"n":"__m256i"}}],[5,"_mm256_set1_pd","","Broadcast double-precision (64-bit) floating-point value `a` to all elements of returned vector.",null,{"i":[{"n":"f64"}],"o":{"n":"__m256d"}}],[5,"_mm256_set1_ps","","Broadcast single-precision (32-bit) floating-point value `a` to all elements of returned vector.",null,{"i":[{"n":"f32"}],"o":{"n":"__m256"}}],[5,"_mm256_set1_epi8","","Broadcast 8-bit integer `a` to all elements of returned vector. This intrinsic may generate the `vpbroadcastb`.",null,{"i":[{"n":"i8"}],"o":{"n":"__m256i"}}],[5,"_mm256_set1_epi16","","Broadcast 16-bit integer `a` to all all elements of returned vector. This intrinsic may generate the `vpbroadcastw`.",null,{"i":[{"n":"i16"}],"o":{"n":"__m256i"}}],[5,"_mm256_set1_epi32","","Broadcast 32-bit integer `a` to all elements of returned vector. This intrinsic may generate the `vpbroadcastd`.",null,{"i":[{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm256_set1_epi64x","","Broadcast 64-bit integer `a` to all elements of returned vector. This intrinsic may generate the `vpbroadcastq`.",null,{"i":[{"n":"i64"}],"o":{"n":"__m256i"}}],[5,"_mm256_castpd_ps","","Cast vector of type __m256d to type __m256.",null,{"i":[{"n":"__m256d"}],"o":{"n":"__m256"}}],[5,"_mm256_castps_pd","","Cast vector of type __m256 to type __m256d.",null,{"i":[{"n":"__m256"}],"o":{"n":"__m256d"}}],[5,"_mm256_castps_si256","","Casts vector of type __m256 to type __m256i.",null,{"i":[{"n":"__m256"}],"o":{"n":"__m256i"}}],[5,"_mm256_castsi256_ps","","Casts vector of type __m256i to type __m256.",null,{"i":[{"n":"__m256i"}],"o":{"n":"__m256"}}],[5,"_mm256_castpd_si256","","Casts vector of type __m256d to type __m256i.",null,{"i":[{"n":"__m256d"}],"o":{"n":"__m256i"}}],[5,"_mm256_castsi256_pd","","Casts vector of type __m256i to type __m256d.",null,{"i":[{"n":"__m256i"}],"o":{"n":"__m256d"}}],[5,"_mm256_castps256_ps128","","Casts vector of type __m256 to type __m128.",null,{"i":[{"n":"__m256"}],"o":{"n":"__m128"}}],[5,"_mm256_castpd256_pd128","","Casts vector of type __m256d to type __m128d.",null,{"i":[{"n":"__m256d"}],"o":{"n":"__m128d"}}],[5,"_mm256_castsi256_si128","","Casts vector of type __m256i to type __m128i.",null,{"i":[{"n":"__m256i"}],"o":{"n":"__m128i"}}],[5,"_mm256_castps128_ps256","","Casts vector of type __m128 to type __m256; the upper 128 bits of the result are undefined.",null,{"i":[{"n":"__m128"}],"o":{"n":"__m256"}}],[5,"_mm256_castpd128_pd256","","Casts vector of type __m128d to type __m256d; the upper 128 bits of the result are undefined.",null,{"i":[{"n":"__m128d"}],"o":{"n":"__m256d"}}],[5,"_mm256_castsi128_si256","","Casts vector of type __m128i to type __m256i; the upper 128 bits of the result are undefined.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm256_zextps128_ps256","","Constructs a 256-bit floating-point vector of `[8 x float]` from a 128-bit floating-point vector of `[4 x float]`. The lower 128 bits contain the value of the source vector. The upper 128 bits are set to zero.",null,{"i":[{"n":"__m128"}],"o":{"n":"__m256"}}],[5,"_mm256_zextsi128_si256","","Constructs a 256-bit integer vector from a 128-bit integer vector. The lower 128 bits contain the value of the source vector. The upper 128 bits are set to zero.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm256_zextpd128_pd256","","Constructs a 256-bit floating-point vector of `[4 x double]` from a 128-bit floating-point vector of `[2 x double]`. The lower 128 bits contain the value of the source vector. The upper 128 bits are set to zero.",null,{"i":[{"n":"__m128d"}],"o":{"n":"__m256d"}}],[5,"_mm256_undefined_ps","","Return vector of type `__m256` with undefined elements.",null,{"o":{"n":"__m256"}}],[5,"_mm256_undefined_pd","","Return vector of type `__m256d` with undefined elements.",null,{"o":{"n":"__m256d"}}],[5,"_mm256_undefined_si256","","Return vector of type __m256i with undefined elements.",null,{"o":{"n":"__m256i"}}],[5,"_mm256_set_m128","","Set packed __m256 returned vector with the supplied values.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m256"}}],[5,"_mm256_set_m128d","","Set packed __m256d returned vector with the supplied values.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m256d"}}],[5,"_mm256_set_m128i","","Set packed __m256i returned vector with the supplied values.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm256_setr_m128","","Set packed __m256 returned vector with the supplied values.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m256"}}],[5,"_mm256_setr_m128d","","Set packed __m256d returned vector with the supplied values.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m256d"}}],[5,"_mm256_setr_m128i","","Set packed __m256i returned vector with the supplied values.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm256_loadu2_m128","","Load two 128-bit values (composed of 4 packed single-precision (32-bit) floating-point elements) from memory, and combine them into a 256-bit value. `hiaddr` and `loaddr` do not need to be aligned on any particular boundary.",null,null],[5,"_mm256_loadu2_m128d","","Load two 128-bit values (composed of 2 packed double-precision (64-bit) floating-point elements) from memory, and combine them into a 256-bit value. `hiaddr` and `loaddr` do not need to be aligned on any particular boundary.",null,null],[5,"_mm256_loadu2_m128i","","Load two 128-bit values (composed of integer data) from memory, and combine them into a 256-bit value. `hiaddr` and `loaddr` do not need to be aligned on any particular boundary.",null,null],[5,"_mm256_storeu2_m128","","Store the high and low 128-bit halves (each composed of 4 packed single-precision (32-bit) floating-point elements) from `a` into memory two different 128-bit locations. `hiaddr` and `loaddr` do not need to be aligned on any particular boundary.",null,null],[5,"_mm256_storeu2_m128d","","Store the high and low 128-bit halves (each composed of 2 packed double-precision (64-bit) floating-point elements) from `a` into memory two different 128-bit locations. `hiaddr` and `loaddr` do not need to be aligned on any particular boundary.",null,null],[5,"_mm256_storeu2_m128i","","Store the high and low 128-bit halves (each composed of integer data) from `a` into memory two different 128-bit locations. `hiaddr` and `loaddr` do not need to be aligned on any particular boundary.",null,null],[5,"_mm256_cvtss_f32","","Returns the first element of the input vector of `[8 x float]`.",null,{"i":[{"n":"__m256"}],"o":{"n":"f32"}}],[5,"_mm256_abs_epi32","","Computes the absolute values of packed 32-bit integers in `a`.",null,{"i":[{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_abs_epi16","","Computes the absolute values of packed 16-bit integers in `a`.",null,{"i":[{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_abs_epi8","","Computes the absolute values of packed 8-bit integers in `a`.",null,{"i":[{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_add_epi64","","Add packed 64-bit integers in `a` and `b`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_add_epi32","","Add packed 32-bit integers in `a` and `b`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_add_epi16","","Add packed 16-bit integers in `a` and `b`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_add_epi8","","Add packed 8-bit integers in `a` and `b`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_adds_epi8","","Add packed 8-bit integers in `a` and `b` using saturation.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_adds_epi16","","Add packed 16-bit integers in `a` and `b` using saturation.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_adds_epu8","","Add packed unsigned 8-bit integers in `a` and `b` using saturation.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_adds_epu16","","Add packed unsigned 16-bit integers in `a` and `b` using saturation.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_alignr_epi8","","Concatenate pairs of 16-byte blocks in `a` and `b` into a 32-byte temporary result, shift the result right by `n` bytes, and return the low 16 bytes.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm256_and_si256","","Compute the bitwise AND of 256 bits (representing integer data) in `a` and `b`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_andnot_si256","","Compute the bitwise NOT of 256 bits (representing integer data) in `a` and then AND with `b`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_avg_epu16","","Average packed unsigned 16-bit integers in `a` and `b`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_avg_epu8","","Average packed unsigned 8-bit integers in `a` and `b`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm_blend_epi32","","Blend packed 32-bit integers from `a` and `b` using control mask `imm8`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm256_blend_epi32","","Blend packed 32-bit integers from `a` and `b` using control mask `imm8`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm256_blend_epi16","","Blend packed 16-bit integers from `a` and `b` using control mask `imm8`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm256_blendv_epi8","","Blend packed 8-bit integers from `a` and `b` using `mask`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm_broadcastb_epi8","","Broadcast the low packed 8-bit integer from `a` to all elements of the 128-bit returned value.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm256_broadcastb_epi8","","Broadcast the low packed 8-bit integer from `a` to all elements of the 256-bit returned value.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm_broadcastd_epi32","","Broadcast the low packed 32-bit integer from `a` to all elements of the 128-bit returned value.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm256_broadcastd_epi32","","Broadcast the low packed 32-bit integer from `a` to all elements of the 256-bit returned value.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm_broadcastq_epi64","","Broadcast the low packed 64-bit integer from `a` to all elements of the 128-bit returned value.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm256_broadcastq_epi64","","Broadcast the low packed 64-bit integer from `a` to all elements of the 256-bit returned value.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm_broadcastsd_pd","","Broadcast the low double-precision (64-bit) floating-point element from `a` to all elements of the 128-bit returned value.",null,{"i":[{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm256_broadcastsd_pd","","Broadcast the low double-precision (64-bit) floating-point element from `a` to all elements of the 256-bit returned value.",null,{"i":[{"n":"__m128d"}],"o":{"n":"__m256d"}}],[5,"_mm256_broadcastsi128_si256","","Broadcast 128 bits of integer data from a to all 128-bit lanes in the 256-bit returned value.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm_broadcastss_ps","","Broadcast the low single-precision (32-bit) floating-point element from `a` to all elements of the 128-bit returned value.",null,{"i":[{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm256_broadcastss_ps","","Broadcast the low single-precision (32-bit) floating-point element from `a` to all elements of the 256-bit returned value.",null,{"i":[{"n":"__m128"}],"o":{"n":"__m256"}}],[5,"_mm_broadcastw_epi16","","Broadcast the low packed 16-bit integer from a to all elements of the 128-bit returned value",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm256_broadcastw_epi16","","Broadcast the low packed 16-bit integer from a to all elements of the 256-bit returned value",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm256_cmpeq_epi64","","Compare packed 64-bit integers in `a` and `b` for equality.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_cmpeq_epi32","","Compare packed 32-bit integers in `a` and `b` for equality.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_cmpeq_epi16","","Compare packed 16-bit integers in `a` and `b` for equality.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_cmpeq_epi8","","Compare packed 8-bit integers in `a` and `b` for equality.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_cmpgt_epi64","","Compare packed 64-bit integers in `a` and `b` for greater-than.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_cmpgt_epi32","","Compare packed 32-bit integers in `a` and `b` for greater-than.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_cmpgt_epi16","","Compare packed 16-bit integers in `a` and `b` for greater-than.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_cmpgt_epi8","","Compare packed 8-bit integers in `a` and `b` for greater-than.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_cvtepi16_epi32","","Sign-extend 16-bit integers to 32-bit integers.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm256_cvtepi16_epi64","","Sign-extend 16-bit integers to 64-bit integers.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm256_cvtepi32_epi64","","Sign-extend 32-bit integers to 64-bit integers.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm256_cvtepi8_epi16","","Sign-extend 8-bit integers to 16-bit integers.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm256_cvtepi8_epi32","","Sign-extend 8-bit integers to 32-bit integers.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm256_cvtepi8_epi64","","Sign-extend 8-bit integers to 64-bit integers.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm256_cvtepu16_epi32","","Zero extend packed unsigned 16-bit integers in `a` to packed 32-bit integers, and store the results in dst.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm256_cvtepu16_epi64","","Zero-extend the lower four unsigned 16-bit integers in `a` to 64-bit integers. The upper four elements of `a` are unused.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm256_cvtepu32_epi64","","Zero-extend unsigned 32-bit integers in `a` to 64-bit integers.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm256_cvtepu8_epi16","","Zero-extend unsigned 8-bit integers in `a` to 16-bit integers.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm256_cvtepu8_epi32","","Zero-extend the lower eight unsigned 8-bit integers in `a` to 32-bit integers. The upper eight elements of `a` are unused.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm256_cvtepu8_epi64","","Zero-extend the lower four unsigned 8-bit integers in `a` to 64-bit integers. The upper twelve elements of `a` are unused.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm256_extracti128_si256","","Extract 128 bits (of integer data) from `a` selected with `imm8`.",null,{"i":[{"n":"__m256i"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm256_hadd_epi16","","Horizontally add adjacent pairs of 16-bit integers in `a` and `b`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_hadd_epi32","","Horizontally add adjacent pairs of 32-bit integers in `a` and `b`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_hadds_epi16","","Horizontally add adjacent pairs of 16-bit integers in `a` and `b` using saturation.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_hsub_epi16","","Horizontally subtract adjacent pairs of 16-bit integers in `a` and `b`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_hsub_epi32","","Horizontally subtract adjacent pairs of 32-bit integers in `a` and `b`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_hsubs_epi16","","Horizontally subtract adjacent pairs of 16-bit integers in `a` and `b` using saturation.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm_i32gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm_mask_i32gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm256_i32gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm256_mask_i32gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm_i32gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm_mask_i32gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm256_i32gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm256_mask_i32gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm_i32gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm_mask_i32gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm256_i32gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm256_mask_i32gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm_i32gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm_mask_i32gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm256_i32gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm256_mask_i32gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm_i64gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm_mask_i64gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm256_i64gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm256_mask_i64gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm_i64gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm_mask_i64gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm256_i64gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm256_mask_i64gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm_i64gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm_mask_i64gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm256_i64gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm256_mask_i64gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm_i64gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm_mask_i64gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm256_i64gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm256_mask_i64gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm256_inserti128_si256","","Copy `a` to `dst`, then insert 128 bits (of integer data) from `b` at the location specified by `imm8`.",null,{"i":[{"n":"__m256i"},{"n":"__m128i"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm256_madd_epi16","","Multiply packed signed 16-bit integers in `a` and `b`, producing intermediate signed 32-bit integers. Horizontally add adjacent pairs of intermediate 32-bit integers.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_maddubs_epi16","","Vertically multiply each unsigned 8-bit integer from `a` with the corresponding signed 8-bit integer from `b`, producing intermediate signed 16-bit integers. Horizontally add adjacent pairs of intermediate signed 16-bit integers",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm_maskload_epi32","","Load packed 32-bit integers from memory pointed by `mem_addr` using `mask` (elements are zeroed out when the highest bit is not set in the corresponding element).",null,null],[5,"_mm256_maskload_epi32","","Load packed 32-bit integers from memory pointed by `mem_addr` using `mask` (elements are zeroed out when the highest bit is not set in the corresponding element).",null,null],[5,"_mm_maskload_epi64","","Load packed 64-bit integers from memory pointed by `mem_addr` using `mask` (elements are zeroed out when the highest bit is not set in the corresponding element).",null,null],[5,"_mm256_maskload_epi64","","Load packed 64-bit integers from memory pointed by `mem_addr` using `mask` (elements are zeroed out when the highest bit is not set in the corresponding element).",null,null],[5,"_mm_maskstore_epi32","","Store packed 32-bit integers from `a` into memory pointed by `mem_addr` using `mask` (elements are not stored when the highest bit is not set in the corresponding element).",null,null],[5,"_mm256_maskstore_epi32","","Store packed 32-bit integers from `a` into memory pointed by `mem_addr` using `mask` (elements are not stored when the highest bit is not set in the corresponding element).",null,null],[5,"_mm_maskstore_epi64","","Store packed 64-bit integers from `a` into memory pointed by `mem_addr` using `mask` (elements are not stored when the highest bit is not set in the corresponding element).",null,null],[5,"_mm256_maskstore_epi64","","Store packed 64-bit integers from `a` into memory pointed by `mem_addr` using `mask` (elements are not stored when the highest bit is not set in the corresponding element).",null,null],[5,"_mm256_max_epi16","","Compare packed 16-bit integers in `a` and `b`, and return the packed maximum values.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_max_epi32","","Compare packed 32-bit integers in `a` and `b`, and return the packed maximum values.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_max_epi8","","Compare packed 8-bit integers in `a` and `b`, and return the packed maximum values.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_max_epu16","","Compare packed unsigned 16-bit integers in `a` and `b`, and return the packed maximum values.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_max_epu32","","Compare packed unsigned 32-bit integers in `a` and `b`, and return the packed maximum values.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_max_epu8","","Compare packed unsigned 8-bit integers in `a` and `b`, and return the packed maximum values.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_min_epi16","","Compare packed 16-bit integers in `a` and `b`, and return the packed minimum values.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_min_epi32","","Compare packed 32-bit integers in `a` and `b`, and return the packed minimum values.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_min_epi8","","Compare packed 8-bit integers in `a` and `b`, and return the packed minimum values.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_min_epu16","","Compare packed unsigned 16-bit integers in `a` and `b`, and return the packed minimum values.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_min_epu32","","Compare packed unsigned 32-bit integers in `a` and `b`, and return the packed minimum values.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_min_epu8","","Compare packed unsigned 8-bit integers in `a` and `b`, and return the packed minimum values.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_movemask_epi8","","Create mask from the most significant bit of each 8-bit element in `a`, return the result.",null,{"i":[{"n":"__m256i"}],"o":{"n":"i32"}}],[5,"_mm256_mpsadbw_epu8","","Compute the sum of absolute differences (SADs) of quadruplets of unsigned 8-bit integers in `a` compared to those in `b`, and store the 16-bit results in dst. Eight SADs are performed for each 128-bit lane using one quadruplet from `b` and eight quadruplets from `a`. One quadruplet is selected from `b` starting at on the offset specified in `imm8`. Eight quadruplets are formed from sequential 8-bit integers selected from `a` starting at the offset specified in `imm8`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm256_mul_epi32","","Multiply the low 32-bit integers from each packed 64-bit element in `a` and `b`",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_mul_epu32","","Multiply the low unsigned 32-bit integers from each packed 64-bit element in `a` and `b`",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_mulhi_epi16","","Multiply the packed 16-bit integers in `a` and `b`, producing intermediate 32-bit integers and returning the high 16 bits of the intermediate integers.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_mulhi_epu16","","Multiply the packed unsigned 16-bit integers in `a` and `b`, producing intermediate 32-bit integers and returning the high 16 bits of the intermediate integers.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_mullo_epi16","","Multiply the packed 16-bit integers in `a` and `b`, producing intermediate 32-bit integers, and return the low 16 bits of the intermediate integers",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_mullo_epi32","","Multiply the packed 32-bit integers in `a` and `b`, producing intermediate 64-bit integers, and return the low 16 bits of the intermediate integers",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_mulhrs_epi16","","Multiply packed 16-bit integers in `a` and `b`, producing intermediate signed 32-bit integers. Truncate each intermediate integer to the 18 most significant bits, round by adding 1, and return bits `[16:1]`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_or_si256","","Compute the bitwise OR of 256 bits (representing integer data) in `a` and `b`",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_packs_epi16","","Convert packed 16-bit integers from `a` and `b` to packed 8-bit integers using signed saturation",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_packs_epi32","","Convert packed 32-bit integers from `a` and `b` to packed 16-bit integers using signed saturation",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_packus_epi16","","Convert packed 16-bit integers from `a` and `b` to packed 8-bit integers using unsigned saturation",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_packus_epi32","","Convert packed 32-bit integers from `a` and `b` to packed 16-bit integers using unsigned saturation",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_permutevar8x32_epi32","","Permutes packed 32-bit integers from `a` according to the content of `b`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_permute4x64_epi64","","Permutes 64-bit integers from `a` using control mask `imm8`.",null,{"i":[{"n":"__m256i"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm256_permute2x128_si256","","Shuffle 128-bits of integer data selected by `imm8` from `a` and `b`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm256_permute4x64_pd","","Shuffle 64-bit floating-point elements in `a` across lanes using the control in `imm8`.",null,{"i":[{"n":"__m256d"},{"n":"i32"}],"o":{"n":"__m256d"}}],[5,"_mm256_permutevar8x32_ps","","Shuffle eight 32-bit foating-point elements in `a` across lanes using the corresponding 32-bit integer index in `idx`.",null,{"i":[{"n":"__m256"},{"n":"__m256i"}],"o":{"n":"__m256"}}],[5,"_mm256_sad_epu8","","Compute the absolute differences of packed unsigned 8-bit integers in `a` and `b`, then horizontally sum each consecutive 8 differences to produce four unsigned 16-bit integers, and pack these unsigned 16-bit integers in the low 16 bits of the 64-bit return value",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_shuffle_epi8","","Shuffle bytes from `a` according to the content of `b`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_shuffle_epi32","","Shuffle 32-bit integers in 128-bit lanes of `a` using the control in `imm8`.",null,{"i":[{"n":"__m256i"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm256_shufflehi_epi16","","Shuffle 16-bit integers in the high 64 bits of 128-bit lanes of `a` using the control in `imm8`. The low 64 bits of 128-bit lanes of `a` are copied to the output.",null,{"i":[{"n":"__m256i"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm256_shufflelo_epi16","","Shuffle 16-bit integers in the low 64 bits of 128-bit lanes of `a` using the control in `imm8`. The high 64 bits of 128-bit lanes of `a` are copied to the output.",null,{"i":[{"n":"__m256i"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm256_sign_epi16","","Negate packed 16-bit integers in `a` when the corresponding signed 16-bit integer in `b` is negative, and return the results. Results are zeroed out when the corresponding element in `b` is zero.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_sign_epi32","","Negate packed 32-bit integers in `a` when the corresponding signed 32-bit integer in `b` is negative, and return the results. Results are zeroed out when the corresponding element in `b` is zero.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_sign_epi8","","Negate packed 8-bit integers in `a` when the corresponding signed 8-bit integer in `b` is negative, and return the results. Results are zeroed out when the corresponding element in `b` is zero.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_sll_epi16","","Shift packed 16-bit integers in `a` left by `count` while shifting in zeros, and return the result",null,{"i":[{"n":"__m256i"},{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm256_sll_epi32","","Shift packed 32-bit integers in `a` left by `count` while shifting in zeros, and return the result",null,{"i":[{"n":"__m256i"},{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm256_sll_epi64","","Shift packed 64-bit integers in `a` left by `count` while shifting in zeros, and return the result",null,{"i":[{"n":"__m256i"},{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm256_slli_epi16","","Shift packed 16-bit integers in `a` left by `imm8` while shifting in zeros, return the results;",null,{"i":[{"n":"__m256i"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm256_slli_epi32","","Shift packed 32-bit integers in `a` left by `imm8` while shifting in zeros, return the results;",null,{"i":[{"n":"__m256i"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm256_slli_epi64","","Shift packed 64-bit integers in `a` left by `imm8` while shifting in zeros, return the results;",null,{"i":[{"n":"__m256i"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm256_slli_si256","","Shift 128-bit lanes in `a` left by `imm8` bytes while shifting in zeros.",null,{"i":[{"n":"__m256i"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm256_bslli_epi128","","Shift 128-bit lanes in `a` left by `imm8` bytes while shifting in zeros.",null,{"i":[{"n":"__m256i"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm_sllv_epi32","","Shift packed 32-bit integers in `a` left by the amount specified by the corresponding element in `count` while shifting in zeros, and return the result.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm256_sllv_epi32","","Shift packed 32-bit integers in `a` left by the amount specified by the corresponding element in `count` while shifting in zeros, and return the result.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm_sllv_epi64","","Shift packed 64-bit integers in `a` left by the amount specified by the corresponding element in `count` while shifting in zeros, and return the result.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm256_sllv_epi64","","Shift packed 64-bit integers in `a` left by the amount specified by the corresponding element in `count` while shifting in zeros, and return the result.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_sra_epi16","","Shift packed 16-bit integers in `a` right by `count` while shifting in sign bits.",null,{"i":[{"n":"__m256i"},{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm256_sra_epi32","","Shift packed 32-bit integers in `a` right by `count` while shifting in sign bits.",null,{"i":[{"n":"__m256i"},{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm256_srai_epi16","","Shift packed 16-bit integers in `a` right by `imm8` while shifting in sign bits.",null,{"i":[{"n":"__m256i"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm256_srai_epi32","","Shift packed 32-bit integers in `a` right by `imm8` while shifting in sign bits.",null,{"i":[{"n":"__m256i"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm_srav_epi32","","Shift packed 32-bit integers in `a` right by the amount specified by the corresponding element in `count` while shifting in sign bits.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm256_srav_epi32","","Shift packed 32-bit integers in `a` right by the amount specified by the corresponding element in `count` while shifting in sign bits.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_srli_si256","","Shift 128-bit lanes in `a` right by `imm8` bytes while shifting in zeros.",null,{"i":[{"n":"__m256i"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm256_bsrli_epi128","","Shift 128-bit lanes in `a` right by `imm8` bytes while shifting in zeros.",null,{"i":[{"n":"__m256i"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm256_srl_epi16","","Shift packed 16-bit integers in `a` right by `count` while shifting in zeros.",null,{"i":[{"n":"__m256i"},{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm256_srl_epi32","","Shift packed 32-bit integers in `a` right by `count` while shifting in zeros.",null,{"i":[{"n":"__m256i"},{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm256_srl_epi64","","Shift packed 64-bit integers in `a` right by `count` while shifting in zeros.",null,{"i":[{"n":"__m256i"},{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm256_srli_epi16","","Shift packed 16-bit integers in `a` right by `imm8` while shifting in zeros",null,{"i":[{"n":"__m256i"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm256_srli_epi32","","Shift packed 32-bit integers in `a` right by `imm8` while shifting in zeros",null,{"i":[{"n":"__m256i"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm256_srli_epi64","","Shift packed 64-bit integers in `a` right by `imm8` while shifting in zeros",null,{"i":[{"n":"__m256i"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm_srlv_epi32","","Shift packed 32-bit integers in `a` right by the amount specified by the corresponding element in `count` while shifting in zeros,",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm256_srlv_epi32","","Shift packed 32-bit integers in `a` right by the amount specified by the corresponding element in `count` while shifting in zeros,",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm_srlv_epi64","","Shift packed 64-bit integers in `a` right by the amount specified by the corresponding element in `count` while shifting in zeros,",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm256_srlv_epi64","","Shift packed 64-bit integers in `a` right by the amount specified by the corresponding element in `count` while shifting in zeros,",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_sub_epi16","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a`",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_sub_epi32","","Subtract packed 32-bit integers in `b` from packed 16-bit integers in `a`",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_sub_epi64","","Subtract packed 64-bit integers in `b` from packed 16-bit integers in `a`",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_sub_epi8","","Subtract packed 8-bit integers in `b` from packed 16-bit integers in `a`",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_subs_epi16","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a` using saturation.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_subs_epi8","","Subtract packed 8-bit integers in `b` from packed 8-bit integers in `a` using saturation.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_subs_epu16","","Subtract packed unsigned 16-bit integers in `b` from packed 16-bit integers in `a` using saturation.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_subs_epu8","","Subtract packed unsigned 8-bit integers in `b` from packed 8-bit integers in `a` using saturation.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_unpackhi_epi8","","Unpack and interleave 8-bit integers from the high half of each 128-bit lane in `a` and `b`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_unpacklo_epi8","","Unpack and interleave 8-bit integers from the low half of each 128-bit lane of `a` and `b`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_unpackhi_epi16","","Unpack and interleave 16-bit integers from the high half of each 128-bit lane of `a` and `b`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_unpacklo_epi16","","Unpack and interleave 16-bit integers from the low half of each 128-bit lane of `a` and `b`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_unpackhi_epi32","","Unpack and interleave 32-bit integers from the high half of each 128-bit lane of `a` and `b`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_unpacklo_epi32","","Unpack and interleave 32-bit integers from the low half of each 128-bit lane of `a` and `b`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_unpackhi_epi64","","Unpack and interleave 64-bit integers from the high half of each 128-bit lane of `a` and `b`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_unpacklo_epi64","","Unpack and interleave 64-bit integers from the low half of each 128-bit lane of `a` and `b`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_xor_si256","","Compute the bitwise XOR of 256 bits (representing integer data) in `a` and `b`",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_extract_epi8","","Extract an 8-bit integer from `a`, selected with `imm8`. Returns a 32-bit integer containing the zero-extended integer data.",null,{"i":[{"n":"__m256i"},{"n":"i32"}],"o":{"n":"i8"}}],[5,"_mm256_extract_epi16","","Extract a 16-bit integer from `a`, selected with `imm8`. Returns a 32-bit integer containing the zero-extended integer data.",null,{"i":[{"n":"__m256i"},{"n":"i32"}],"o":{"n":"i16"}}],[5,"_mm256_extract_epi32","","Extract a 32-bit integer from `a`, selected with `imm8`.",null,{"i":[{"n":"__m256i"},{"n":"i32"}],"o":{"n":"i32"}}],[5,"_mm256_cvtsd_f64","","Returns the first element of the input vector of `[4 x double]`.",null,{"i":[{"n":"__m256d"}],"o":{"n":"f64"}}],[5,"_mm256_cvtsi256_si32","","Returns the first element of the input vector of `[8 x i32]`.",null,{"i":[{"n":"__m256i"}],"o":{"n":"i32"}}],[5,"_mm_fmadd_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and add the intermediate result to packed elements in `c`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm256_fmadd_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and add the intermediate result to packed elements in `c`.",null,{"i":[{"n":"__m256d"},{"n":"__m256d"},{"n":"__m256d"}],"o":{"n":"__m256d"}}],[5,"_mm_fmadd_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and add the intermediate result to packed elements in `c`.",null,{"i":[{"n":"__m128"},{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm256_fmadd_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and add the intermediate result to packed elements in `c`.",null,{"i":[{"n":"__m256"},{"n":"__m256"},{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm_fmadd_sd","","Multiply the lower double-precision (64-bit) floating-point elements in `a` and `b`, and add the intermediate result to the lower element in `c`. Store the result in the lower element of the returned value, and copy the upper element from `a` to the upper elements of the result.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_fmadd_ss","","Multiply the lower single-precision (32-bit) floating-point elements in `a` and `b`, and add the intermediate result to the lower element in `c`. Store the result in the lower element of the returned value, and copy the 3 upper elements from `a` to the upper elements of the result.",null,{"i":[{"n":"__m128"},{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_fmaddsub_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and alternatively add and subtract packed elements in `c` to/from the intermediate result.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm256_fmaddsub_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and alternatively add and subtract packed elements in `c` to/from the intermediate result.",null,{"i":[{"n":"__m256d"},{"n":"__m256d"},{"n":"__m256d"}],"o":{"n":"__m256d"}}],[5,"_mm_fmaddsub_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and alternatively add and subtract packed elements in `c` to/from the intermediate result.",null,{"i":[{"n":"__m128"},{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm256_fmaddsub_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and alternatively add and subtract packed elements in `c` to/from the intermediate result.",null,{"i":[{"n":"__m256"},{"n":"__m256"},{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm_fmsub_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the intermediate result.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm256_fmsub_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the intermediate result.",null,{"i":[{"n":"__m256d"},{"n":"__m256d"},{"n":"__m256d"}],"o":{"n":"__m256d"}}],[5,"_mm_fmsub_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the intermediate result.",null,{"i":[{"n":"__m128"},{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm256_fmsub_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the intermediate result.",null,{"i":[{"n":"__m256"},{"n":"__m256"},{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm_fmsub_sd","","Multiply the lower double-precision (64-bit) floating-point elements in `a` and `b`, and subtract the lower element in `c` from the intermediate result. Store the result in the lower element of the returned value, and copy the upper element from `a` to the upper elements of the result.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_fmsub_ss","","Multiply the lower single-precision (32-bit) floating-point elements in `a` and `b`,  and subtract the lower element in `c` from the intermediate result. Store the result in the lower element of the returned value, and copy the 3 upper elements from `a` to the upper elements of the result.",null,{"i":[{"n":"__m128"},{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_fmsubadd_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and alternatively subtract and add packed elements in `c` from/to the intermediate result.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm256_fmsubadd_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and alternatively subtract and add packed elements in `c` from/to the intermediate result.",null,{"i":[{"n":"__m256d"},{"n":"__m256d"},{"n":"__m256d"}],"o":{"n":"__m256d"}}],[5,"_mm_fmsubadd_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and alternatively subtract and add packed elements in `c` from/to the intermediate result.",null,{"i":[{"n":"__m128"},{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm256_fmsubadd_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and alternatively subtract and add packed elements in `c` from/to the intermediate result.",null,{"i":[{"n":"__m256"},{"n":"__m256"},{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm_fnmadd_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and add the negated intermediate result to packed elements in `c`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm256_fnmadd_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and add the negated intermediate result to packed elements in `c`.",null,{"i":[{"n":"__m256d"},{"n":"__m256d"},{"n":"__m256d"}],"o":{"n":"__m256d"}}],[5,"_mm_fnmadd_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and add the negated intermediate result to packed elements in `c`.",null,{"i":[{"n":"__m128"},{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm256_fnmadd_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and add the negated intermediate result to packed elements in `c`.",null,{"i":[{"n":"__m256"},{"n":"__m256"},{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm_fnmadd_sd","","Multiply the lower double-precision (64-bit) floating-point elements in `a` and `b`, and add the negated intermediate result to the lower element in `c`. Store the result in the lower element of the returned value, and copy the upper element from `a` to the upper elements of the result.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_fnmadd_ss","","Multiply the lower single-precision (32-bit) floating-point elements in `a` and `b`, and add the negated intermediate result to the lower element in `c`. Store the result in the lower element of the returned value, and copy the 3 upper elements from `a` to the upper elements of the result.",null,{"i":[{"n":"__m128"},{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_fnmsub_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the negated intermediate result.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm256_fnmsub_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the negated intermediate result.",null,{"i":[{"n":"__m256d"},{"n":"__m256d"},{"n":"__m256d"}],"o":{"n":"__m256d"}}],[5,"_mm_fnmsub_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the negated intermediate result.",null,{"i":[{"n":"__m128"},{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm256_fnmsub_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the negated intermediate result.",null,{"i":[{"n":"__m256"},{"n":"__m256"},{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm_fnmsub_sd","","Multiply the lower double-precision (64-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the negated intermediate result. Store the result in the lower element of the returned value, and copy the upper element from `a` to the upper elements of the result.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_fnmsub_ss","","Multiply the lower single-precision (32-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the negated intermediate result. Store the result in the lower element of the returned value, and copy the 3 upper elements from `a` to the upper elements of the result.",null,{"i":[{"n":"__m128"},{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_lzcnt_u32","","Counts the leading most significant zero bits.",null,{"i":[{"n":"u32"}],"o":{"n":"u32"}}],[5,"_popcnt32","","Counts the bits that are set.",null,{"i":[{"n":"i32"}],"o":{"n":"i32"}}],[5,"_bextr_u32","","Extracts bits in range [`start`, `start` + `length`) from `a` into the least significant bits of the result.",null,{"i":[{"n":"u32"},{"n":"u32"},{"n":"u32"}],"o":{"n":"u32"}}],[5,"_bextr2_u32","","Extracts bits of `a` specified by `control` into the least significant bits of the result.",null,{"i":[{"n":"u32"},{"n":"u32"}],"o":{"n":"u32"}}],[5,"_andn_u32","","Bitwise logical `AND` of inverted `a` with `b`.",null,{"i":[{"n":"u32"},{"n":"u32"}],"o":{"n":"u32"}}],[5,"_blsi_u32","","Extract lowest set isolated bit.",null,{"i":[{"n":"u32"}],"o":{"n":"u32"}}],[5,"_blsmsk_u32","","Get mask up to lowest set bit.",null,{"i":[{"n":"u32"}],"o":{"n":"u32"}}],[5,"_blsr_u32","","Resets the lowest set bit of `x`.",null,{"i":[{"n":"u32"}],"o":{"n":"u32"}}],[5,"_tzcnt_u32","","Counts the number of trailing least significant zero bits.",null,{"i":[{"n":"u32"}],"o":{"n":"u32"}}],[5,"_mm_tzcnt_32","","Counts the number of trailing least significant zero bits.",null,{"i":[{"n":"u32"}],"o":{"n":"i32"}}],[5,"_mulx_u32","","Unsigned multiply without affecting flags.",null,{"i":[{"n":"u32"},{"n":"u32"},{"n":"u32"}],"o":{"n":"u32"}}],[5,"_bzhi_u32","","Zero higher bits of `a` >= `index`.",null,{"i":[{"n":"u32"},{"n":"u32"}],"o":{"n":"u32"}}],[5,"_pdep_u32","","Scatter contiguous low order bits of `a` to the result at the positions specified by the `mask`.",null,{"i":[{"n":"u32"},{"n":"u32"}],"o":{"n":"u32"}}],[5,"_pext_u32","","Gathers the bits of `x` specified by the `mask` into the contiguous low order bit positions of the result.",null,{"i":[{"n":"u32"},{"n":"u32"}],"o":{"n":"u32"}}],[5,"_mm_extract_si64","","Extracts the bit range specified by `y` from the lower 64 bits of `x`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_insert_si64","","Inserts the `[length:0]` bits of `y` into `x` at `index`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_stream_sd","","Non-temporal store of `a.0` into `p`.",null,null],[5,"_mm_stream_ss","","Non-temporal store of `a.0` into `p`.",null,null],[5,"_blcfill_u32","","Clears all bits below the least significant zero bit of `x`.",null,{"i":[{"n":"u32"}],"o":{"n":"u32"}}],[5,"_blcfill_u64","","Clears all bits below the least significant zero bit of `x`.",null,{"i":[{"n":"u64"}],"o":{"n":"u64"}}],[5,"_blci_u32","","Sets all bits of `x` to 1 except for the least significant zero bit.",null,{"i":[{"n":"u32"}],"o":{"n":"u32"}}],[5,"_blci_u64","","Sets all bits of `x` to 1 except for the least significant zero bit.",null,{"i":[{"n":"u64"}],"o":{"n":"u64"}}],[5,"_blcic_u32","","Sets the least significant zero bit of `x` and clears all other bits.",null,{"i":[{"n":"u32"}],"o":{"n":"u32"}}],[5,"_blcic_u64","","Sets the least significant zero bit of `x` and clears all other bits.",null,{"i":[{"n":"u64"}],"o":{"n":"u64"}}],[5,"_blcmsk_u32","","Sets the least significant zero bit of `x` and clears all bits above that bit.",null,{"i":[{"n":"u32"}],"o":{"n":"u32"}}],[5,"_blcmsk_u64","","Sets the least significant zero bit of `x` and clears all bits above that bit.",null,{"i":[{"n":"u64"}],"o":{"n":"u64"}}],[5,"_blcs_u32","","Sets the least significant zero bit of `x`.",null,{"i":[{"n":"u32"}],"o":{"n":"u32"}}],[5,"_blcs_u64","","Sets the least significant zero bit of `x`.",null,{"i":[{"n":"u64"}],"o":{"n":"u64"}}],[5,"_blsfill_u32","","Sets all bits of `x` below the least significant one.",null,{"i":[{"n":"u32"}],"o":{"n":"u32"}}],[5,"_blsfill_u64","","Sets all bits of `x` below the least significant one.",null,{"i":[{"n":"u64"}],"o":{"n":"u64"}}],[5,"_blsic_u32","","Clears least significant bit and sets all other bits.",null,{"i":[{"n":"u32"}],"o":{"n":"u32"}}],[5,"_blsic_u64","","Clears least significant bit and sets all other bits.",null,{"i":[{"n":"u64"}],"o":{"n":"u64"}}],[5,"_t1mskc_u32","","Clears all bits below the least significant zero of `x` and sets all other bits.",null,{"i":[{"n":"u32"}],"o":{"n":"u32"}}],[5,"_t1mskc_u64","","Clears all bits below the least significant zero of `x` and sets all other bits.",null,{"i":[{"n":"u64"}],"o":{"n":"u64"}}],[5,"_tzmsk_u32","","Sets all bits below the least significant one of `x` and clears all other bits.",null,{"i":[{"n":"u32"}],"o":{"n":"u32"}}],[5,"_tzmsk_u64","","Sets all bits below the least significant one of `x` and clears all other bits.",null,{"i":[{"n":"u64"}],"o":{"n":"u64"}}],[5,"_mm_setzero_si64","","Constructs a 64-bit integer vector initialized to zero.",null,{"o":{"n":"__m64"}}],[5,"_mm_add_pi8","","Add packed 8-bit integers in `a` and `b`.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_m_paddb","","Add packed 8-bit integers in `a` and `b`.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_add_pi16","","Add packed 16-bit integers in `a` and `b`.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_m_paddw","","Add packed 16-bit integers in `a` and `b`.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_add_pi32","","Add packed 32-bit integers in `a` and `b`.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_m_paddd","","Add packed 32-bit integers in `a` and `b`.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_adds_pi8","","Add packed 8-bit integers in `a` and `b` using saturation.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_m_paddsb","","Add packed 8-bit integers in `a` and `b` using saturation.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_adds_pi16","","Add packed 16-bit integers in `a` and `b` using saturation.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_m_paddsw","","Add packed 16-bit integers in `a` and `b` using saturation.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_adds_pu8","","Add packed unsigned 8-bit integers in `a` and `b` using saturation.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_m_paddusb","","Add packed unsigned 8-bit integers in `a` and `b` using saturation.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_adds_pu16","","Add packed unsigned 16-bit integers in `a` and `b` using saturation.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_m_paddusw","","Add packed unsigned 16-bit integers in `a` and `b` using saturation.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_sub_pi8","","Subtract packed 8-bit integers in `b` from packed 8-bit integers in `a`.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_m_psubb","","Subtract packed 8-bit integers in `b` from packed 8-bit integers in `a`.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_sub_pi16","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a`.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_m_psubw","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a`.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_sub_pi32","","Subtract packed 32-bit integers in `b` from packed 32-bit integers in `a`.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_m_psubd","","Subtract packed 32-bit integers in `b` from packed 32-bit integers in `a`.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_subs_pi8","","Subtract packed 8-bit integers in `b` from packed 8-bit integers in `a` using saturation.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_m_psubsb","","Subtract packed 8-bit integers in `b` from packed 8-bit integers in `a` using saturation.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_subs_pi16","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a` using saturation.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_m_psubsw","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a` using saturation.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_subs_pu8","","Subtract packed unsigned 8-bit integers in `b` from packed unsigned 8-bit integers in `a` using saturation.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_m_psubusb","","Subtract packed unsigned 8-bit integers in `b` from packed unsigned 8-bit integers in `a` using saturation.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_subs_pu16","","Subtract packed unsigned 16-bit integers in `b` from packed unsigned 16-bit integers in `a` using saturation.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_m_psubusw","","Subtract packed unsigned 16-bit integers in `b` from packed unsigned 16-bit integers in `a` using saturation.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_packs_pi16","","Convert packed 16-bit integers from `a` and `b` to packed 8-bit integers using signed saturation.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_packs_pi32","","Convert packed 32-bit integers from `a` and `b` to packed 16-bit integers using signed saturation.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_cmpgt_pi8","","Compares whether each element of `a` is greater than the corresponding element of `b` returning `0` for `false` and `-1` for `true`.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_cmpgt_pi16","","Compares whether each element of `a` is greater than the corresponding element of `b` returning `0` for `false` and `-1` for `true`.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_cmpgt_pi32","","Compares whether each element of `a` is greater than the corresponding element of `b` returning `0` for `false` and `-1` for `true`.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_unpackhi_pi16","","Unpacks the upper two elements from two `i16x4` vectors and interleaves them into the result: `[a.2, b.2, a.3, b.3]`.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_unpackhi_pi8","","Unpacks the upper four elements from two `i8x8` vectors and interleaves them into the result: `[a.4, b.4, a.5, b.5, a.6, b.6, a.7, b.7]`.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_unpacklo_pi8","","Unpacks the lower four elements from two `i8x8` vectors and interleaves them into the result: `[a.0, b.0, a.1, b.1, a.2, b.2, a.3, b.3]`.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_unpacklo_pi16","","Unpacks the lower two elements from two `i16x4` vectors and interleaves them into the result: `[a.0 b.0 a.1 b.1]`.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_unpackhi_pi32","","Unpacks the upper element from two `i32x2` vectors and interleaves them into the result: `[a.1, b.1]`.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_unpacklo_pi32","","Unpacks the lower element from two `i32x2` vectors and interleaves them into the result: `[a.0, b.0]`.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_set_pi16","","Set packed 16-bit integers in dst with the supplied values.",null,{"i":[{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"}],"o":{"n":"__m64"}}],[5,"_mm_set_pi32","","Set packed 32-bit integers in dst with the supplied values.",null,{"i":[{"n":"i32"},{"n":"i32"}],"o":{"n":"__m64"}}],[5,"_mm_set_pi8","","Set packed 8-bit integers in dst with the supplied values.",null,{"i":[{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"}],"o":{"n":"__m64"}}],[5,"_mm_set1_pi16","","Broadcast 16-bit integer a to all all elements of dst.",null,{"i":[{"n":"i16"}],"o":{"n":"__m64"}}],[5,"_mm_set1_pi32","","Broadcast 32-bit integer a to all all elements of dst.",null,{"i":[{"n":"i32"}],"o":{"n":"__m64"}}],[5,"_mm_set1_pi8","","Broadcast 8-bit integer a to all all elements of dst.",null,{"i":[{"n":"i8"}],"o":{"n":"__m64"}}],[5,"_mm_setr_pi16","","Set packed 16-bit integers in dst with the supplied values in reverse order.",null,{"i":[{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"}],"o":{"n":"__m64"}}],[5,"_mm_setr_pi32","","Set packed 32-bit integers in dst with the supplied values in reverse order.",null,{"i":[{"n":"i32"},{"n":"i32"}],"o":{"n":"__m64"}}],[5,"_mm_setr_pi8","","Set packed 8-bit integers in dst with the supplied values in reverse order.",null,{"i":[{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"}],"o":{"n":"__m64"}}],[5,"_mm_clmulepi64_si128","","Perform a carry-less multiplication of two 64-bit polynomials over the finite field GF(2^k).",null,{"i":[{"n":"__m128i"},{"n":"__m128i"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_aesdec_si128","","Perform one round of an AES decryption flow on data (state) in `a`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_aesdeclast_si128","","Perform the last round of an AES decryption flow on data (state) in `a`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_aesenc_si128","","Perform one round of an AES encryption flow on data (state) in `a`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_aesenclast_si128","","Perform the last round of an AES encryption flow on data (state) in `a`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_aesimc_si128","","Perform the `InvMixColumns` transformation on `a`.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_aeskeygenassist_si128","","Assist in expanding the AES cipher key.",null,{"i":[{"n":"__m128i"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_rdrand16_step","","Read a hardware generated 16-bit random value and store the result in val. Return 1 if a random value was generated, and 0 otherwise.",null,{"i":[{"n":"u16"}],"o":{"n":"i32"}}],[5,"_rdrand32_step","","Read a hardware generated 32-bit random value and store the result in val. Return 1 if a random value was generated, and 0 otherwise.",null,{"i":[{"n":"u32"}],"o":{"n":"i32"}}],[5,"_rdseed16_step","","Read a 16-bit NIST SP800-90B and SP800-90C compliant random value and store in val. Return 1 if a random value was generated, and 0 otherwise.",null,{"i":[{"n":"u16"}],"o":{"n":"i32"}}],[5,"_rdseed32_step","","Read a 32-bit NIST SP800-90B and SP800-90C compliant random value and store in val. Return 1 if a random value was generated, and 0 otherwise.",null,{"i":[{"n":"u32"}],"o":{"n":"i32"}}],[5,"_mm_sha1msg1_epu32","","Perform an intermediate calculation for the next four SHA1 message values (unsigned 32-bit integers) using previous message values from `a` and `b`, and returning the result.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_sha1msg2_epu32","","Perform the final calculation for the next four SHA1 message values (unsigned 32-bit integers) using the intermediate result in `a` and the previous message values in `b`, and returns the result.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_sha1nexte_epu32","","Calculate SHA1 state variable E after four rounds of operation from the current SHA1 state variable `a`, add that value to the scheduled values (unsigned 32-bit integers) in `b`, and returns the result.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_sha1rnds4_epu32","","Perform four rounds of SHA1 operation using an initial SHA1 state (A,B,C,D) from `a` and some pre-computed sum of the next 4 round message values (unsigned 32-bit integers), and state variable E from `b`, and return the updated SHA1 state (A,B,C,D). `func` contains the logic functions and round constants.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_sha256msg1_epu32","","Perform an intermediate calculation for the next four SHA256 message values (unsigned 32-bit integers) using previous message values from `a` and `b`, and return the result.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_sha256msg2_epu32","","Perform the final calculation for the next four SHA256 message values (unsigned 32-bit integers) using previous message values from `a` and `b`, and return the result.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_sha256rnds2_epu32","","Perform 2 rounds of SHA256 operation using an initial SHA256 state (C,D,G,H) from `a`, an initial SHA256 state (A,B,E,F) from `b`, and a pre-computed sum of the next 2 round message values (unsigned 32-bit integers) and the corresponding round constants from `k`, and store the updated SHA256 state (A,B,E,F) in dst.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[17,"_XCR_XFEATURE_ENABLED_MASK","","`XFEATURE_ENABLED_MASK` for `XCR`",null,null],[17,"_MM_EXCEPT_INVALID","","See `_mm_setcsr`",null,null],[17,"_MM_EXCEPT_DENORM","","See `_mm_setcsr`",null,null],[17,"_MM_EXCEPT_DIV_ZERO","","See `_mm_setcsr`",null,null],[17,"_MM_EXCEPT_OVERFLOW","","See `_mm_setcsr`",null,null],[17,"_MM_EXCEPT_UNDERFLOW","","See `_mm_setcsr`",null,null],[17,"_MM_EXCEPT_INEXACT","","See `_mm_setcsr`",null,null],[17,"_MM_EXCEPT_MASK","","See `_MM_GET_EXCEPTION_STATE`",null,null],[17,"_MM_MASK_INVALID","","See `_mm_setcsr`",null,null],[17,"_MM_MASK_DENORM","","See `_mm_setcsr`",null,null],[17,"_MM_MASK_DIV_ZERO","","See `_mm_setcsr`",null,null],[17,"_MM_MASK_OVERFLOW","","See `_mm_setcsr`",null,null],[17,"_MM_MASK_UNDERFLOW","","See `_mm_setcsr`",null,null],[17,"_MM_MASK_INEXACT","","See `_mm_setcsr`",null,null],[17,"_MM_MASK_MASK","","See `_MM_GET_EXCEPTION_MASK`",null,null],[17,"_MM_ROUND_NEAREST","","See `_mm_setcsr`",null,null],[17,"_MM_ROUND_DOWN","","See `_mm_setcsr`",null,null],[17,"_MM_ROUND_UP","","See `_mm_setcsr`",null,null],[17,"_MM_ROUND_TOWARD_ZERO","","See `_mm_setcsr`",null,null],[17,"_MM_ROUND_MASK","","See `_MM_GET_ROUNDING_MODE`",null,null],[17,"_MM_FLUSH_ZERO_MASK","","See `_MM_GET_FLUSH_ZERO_MODE`",null,null],[17,"_MM_FLUSH_ZERO_ON","","See `_mm_setcsr`",null,null],[17,"_MM_FLUSH_ZERO_OFF","","See `_mm_setcsr`",null,null],[17,"_MM_HINT_T0","","See `_mm_prefetch`.",null,null],[17,"_MM_HINT_T1","","See `_mm_prefetch`.",null,null],[17,"_MM_HINT_T2","","See `_mm_prefetch`.",null,null],[17,"_MM_HINT_NTA","","See `_mm_prefetch`.",null,null],[17,"_MM_FROUND_TO_NEAREST_INT","","round to nearest",null,null],[17,"_MM_FROUND_TO_NEG_INF","","round down",null,null],[17,"_MM_FROUND_TO_POS_INF","","round up",null,null],[17,"_MM_FROUND_TO_ZERO","","truncate",null,null],[17,"_MM_FROUND_CUR_DIRECTION","","use MXCSR.RC; see `vendor::_MM_SET_ROUNDING_MODE`",null,null],[17,"_MM_FROUND_RAISE_EXC","","do not suppress exceptions",null,null],[17,"_MM_FROUND_NO_EXC","","suppress exceptions",null,null],[17,"_MM_FROUND_NINT","","round to nearest and do not suppress exceptions",null,null],[17,"_MM_FROUND_FLOOR","","round down and do not suppress exceptions",null,null],[17,"_MM_FROUND_CEIL","","round up and do not suppress exceptions",null,null],[17,"_MM_FROUND_TRUNC","","truncate and do not suppress exceptions",null,null],[17,"_MM_FROUND_RINT","","use MXCSR.RC and do not suppress exceptions; see `vendor::_MM_SET_ROUNDING_MODE`",null,null],[17,"_MM_FROUND_NEARBYINT","","use MXCSR.RC and suppress exceptions; see `vendor::_MM_SET_ROUNDING_MODE`",null,null],[17,"_SIDD_UBYTE_OPS","","String contains unsigned 8-bit characters (Default)",null,null],[17,"_SIDD_UWORD_OPS","","String contains unsigned 16-bit characters",null,null],[17,"_SIDD_SBYTE_OPS","","String contains signed 8-bit characters",null,null],[17,"_SIDD_SWORD_OPS","","String contains unsigned 16-bit characters",null,null],[17,"_SIDD_CMP_EQUAL_ANY","","For each character in `a`, find if it is in `b` (Default)",null,null],[17,"_SIDD_CMP_RANGES","","For each character in `a`, determine if `b[0] <= c <= b[1] or b[1] <= c <= b[2]...`",null,null],[17,"_SIDD_CMP_EQUAL_EACH","","The strings defined by `a` and `b` are equal",null,null],[17,"_SIDD_CMP_EQUAL_ORDERED","","Search for the defined substring in the target",null,null],[17,"_SIDD_POSITIVE_POLARITY","","Do not negate results (Default)",null,null],[17,"_SIDD_NEGATIVE_POLARITY","","Negate results",null,null],[17,"_SIDD_MASKED_POSITIVE_POLARITY","","Do not negate results before the end of the string",null,null],[17,"_SIDD_MASKED_NEGATIVE_POLARITY","","Negate results only before the end of the string",null,null],[17,"_SIDD_LEAST_SIGNIFICANT","","Index only: return the least significant bit (Default)",null,null],[17,"_SIDD_MOST_SIGNIFICANT","","Index only: return the most significant bit",null,null],[17,"_SIDD_BIT_MASK","","Mask only: return the bit mask",null,null],[17,"_SIDD_UNIT_MASK","","Mask only: return the byte mask",null,null],[17,"_CMP_EQ_OQ","","Equal (ordered, non-signaling)",null,null],[17,"_CMP_LT_OS","","Less-than (ordered, signaling)",null,null],[17,"_CMP_LE_OS","","Less-than-or-equal (ordered, signaling)",null,null],[17,"_CMP_UNORD_Q","","Unordered (non-signaling)",null,null],[17,"_CMP_NEQ_UQ","","Not-equal (unordered, non-signaling)",null,null],[17,"_CMP_NLT_US","","Not-less-than (unordered, signaling)",null,null],[17,"_CMP_NLE_US","","Not-less-than-or-equal (unordered, signaling)",null,null],[17,"_CMP_ORD_Q","","Ordered (non-signaling)",null,null],[17,"_CMP_EQ_UQ","","Equal (unordered, non-signaling)",null,null],[17,"_CMP_NGE_US","","Not-greater-than-or-equal (unordered, signaling)",null,null],[17,"_CMP_NGT_US","","Not-greater-than (unordered, signaling)",null,null],[17,"_CMP_FALSE_OQ","","False (ordered, non-signaling)",null,null],[17,"_CMP_NEQ_OQ","","Not-equal (ordered, non-signaling)",null,null],[17,"_CMP_GE_OS","","Greater-than-or-equal (ordered, signaling)",null,null],[17,"_CMP_GT_OS","","Greater-than (ordered, signaling)",null,null],[17,"_CMP_TRUE_UQ","","True (unordered, non-signaling)",null,null],[17,"_CMP_EQ_OS","","Equal (ordered, signaling)",null,null],[17,"_CMP_LT_OQ","","Less-than (ordered, non-signaling)",null,null],[17,"_CMP_LE_OQ","","Less-than-or-equal (ordered, non-signaling)",null,null],[17,"_CMP_UNORD_S","","Unordered (signaling)",null,null],[17,"_CMP_NEQ_US","","Not-equal (unordered, signaling)",null,null],[17,"_CMP_NLT_UQ","","Not-less-than (unordered, non-signaling)",null,null],[17,"_CMP_NLE_UQ","","Not-less-than-or-equal (unordered, non-signaling)",null,null],[17,"_CMP_ORD_S","","Ordered (signaling)",null,null],[17,"_CMP_EQ_US","","Equal (unordered, signaling)",null,null],[17,"_CMP_NGE_UQ","","Not-greater-than-or-equal (unordered, non-signaling)",null,null],[17,"_CMP_NGT_UQ","","Not-greater-than (unordered, non-signaling)",null,null],[17,"_CMP_FALSE_OS","","False (ordered, signaling)",null,null],[17,"_CMP_NEQ_OS","","Not-equal (ordered, signaling)",null,null],[17,"_CMP_GE_OQ","","Greater-than-or-equal (ordered, non-signaling)",null,null],[17,"_CMP_GT_OQ","","Greater-than (ordered, non-signaling)",null,null],[17,"_CMP_TRUE_US","","True (unordered, signaling)",null,null],[0,"x86_64","core::arch","Platform-specific intrinsics for the `x86_64` platform.",null,null],[3,"__m64","core::arch::x86_64","64-bit wide integer vector type, x86-specific",null,null],[3,"__m128i","","128-bit wide integer vector type, x86-specific",null,null],[3,"__m128","","128-bit wide set of four `f32` types, x86-specific",null,null],[3,"__m128d","","128-bit wide set of two `f64` types, x86-specific",null,null],[3,"__m256i","","256-bit wide integer vector type, x86-specific",null,null],[3,"__m256","","256-bit wide set of eight `f32` types, x86-specific",null,null],[3,"__m256d","","256-bit wide set of four `f64` types, x86-specific",null,null],[3,"CpuidResult","","Result of the `cpuid` instruction.",null,null],[12,"eax","","EAX register.",248,null],[12,"ebx","","EBX register.",248,null],[12,"ecx","","ECX register.",248,null],[12,"edx","","EDX register.",248,null],[5,"__readeflags","","Reads EFLAGS.",null,{"o":{"n":"u64"}}],[5,"__writeeflags","","Write EFLAGS.",null,{"i":[{"n":"u64"}]}],[5,"_fxsave","","Saves the `x87` FPU, `MMX` technology, `XMM`, and `MXCSR` registers to the 512-byte-long 16-byte-aligned memory region `mem_addr`.",null,null],[5,"_fxrstor","","Restores the `XMM`, `MMX`, `MXCSR`, and `x87` FPU registers from the 512-byte-long 16-byte-aligned memory region `mem_addr`.",null,null],[5,"_bswap","","Return an integer with the reversed byte order of x",null,{"i":[{"n":"i32"}],"o":{"n":"i32"}}],[5,"_rdtsc","","Reads the current value of the processor’s time-stamp counter.",null,{"o":{"n":"i64"}}],[5,"__rdtscp","","Reads the current value of the processor’s time-stamp counter and the `IA32_TSC_AUX MSR`.",null,null],[5,"__cpuid_count","","Returns the result of the `cpuid` instruction for a given `leaf` (`EAX`) and `sub_leaf` (`ECX`).",null,{"i":[{"n":"u32"},{"n":"u32"}],"o":{"n":"cpuidresult"}}],[5,"__cpuid","","See `__cpuid_count`.",null,{"i":[{"n":"u32"}],"o":{"n":"cpuidresult"}}],[5,"has_cpuid","","Does the host support the `cpuid` instruction?",null,{"o":{"n":"bool"}}],[5,"__get_cpuid_max","","Returns the highest-supported `leaf` (`EAX`) and sub-leaf (`ECX`) `cpuid` values.",null,null],[5,"_xsave","","Perform a full or partial save of the enabled processor states to memory at `mem_addr`.",null,null],[5,"_xrstor","","Perform a full or partial restore of the enabled processor states using the state information stored in memory at `mem_addr`.",null,null],[5,"_xsetbv","","Copy 64-bits from `val` to the extended control register (`XCR`) specified by `a`.",null,{"i":[{"n":"u32"},{"n":"u64"}]}],[5,"_xgetbv","","Reads the contents of the extended control register `XCR` specified in `xcr_no`.",null,{"i":[{"n":"u32"}],"o":{"n":"u64"}}],[5,"_xsaveopt","","Perform a full or partial save of the enabled processor states to memory at `mem_addr`.",null,null],[5,"_xsavec","","Perform a full or partial save of the enabled processor states to memory at `mem_addr`.",null,null],[5,"_xsaves","","Perform a full or partial save of the enabled processor states to memory at `mem_addr`",null,null],[5,"_xrstors","","Perform a full or partial restore of the enabled processor states using the state information stored in memory at `mem_addr`.",null,null],[5,"_mm_add_ss","","Adds the first component of `a` and `b`, the other components are copied from `a`.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_add_ps","","Adds __m128 vectors.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_sub_ss","","Subtracts the first component of `b` from `a`, the other components are copied from `a`.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_sub_ps","","Subtracts __m128 vectors.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_mul_ss","","Multiplies the first component of `a` and `b`, the other components are copied from `a`.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_mul_ps","","Multiplies __m128 vectors.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_div_ss","","Divides the first component of `b` by `a`, the other components are copied from `a`.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_div_ps","","Divides __m128 vectors.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_sqrt_ss","","Return the square root of the first single-precision (32-bit) floating-point element in `a`, the other elements are unchanged.",null,{"i":[{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_sqrt_ps","","Return the square root of packed single-precision (32-bit) floating-point elements in `a`.",null,{"i":[{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_rcp_ss","","Return the approximate reciprocal of the first single-precision (32-bit) floating-point element in `a`, the other elements are unchanged.",null,{"i":[{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_rcp_ps","","Return the approximate reciprocal of packed single-precision (32-bit) floating-point elements in `a`.",null,{"i":[{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_rsqrt_ss","","Return the approximate reciprocal square root of the fist single-precision (32-bit) floating-point elements in `a`, the other elements are unchanged.",null,{"i":[{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_rsqrt_ps","","Return the approximate reciprocal square root of packed single-precision (32-bit) floating-point elements in `a`.",null,{"i":[{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_min_ss","","Compare the first single-precision (32-bit) floating-point element of `a` and `b`, and return the minimum value in the first element of the return value, the other elements are copied from `a`.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_min_ps","","Compare packed single-precision (32-bit) floating-point elements in `a` and `b`, and return the corresponding minimum values.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_max_ss","","Compare the first single-precision (32-bit) floating-point element of `a` and `b`, and return the maximum value in the first element of the return value, the other elements are copied from `a`.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_max_ps","","Compare packed single-precision (32-bit) floating-point elements in `a` and `b`, and return the corresponding maximum values.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_and_ps","","Bitwise AND of packed single-precision (32-bit) floating-point elements.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_andnot_ps","","Bitwise AND-NOT of packed single-precision (32-bit) floating-point elements.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_or_ps","","Bitwise OR of packed single-precision (32-bit) floating-point elements.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_xor_ps","","Bitwise exclusive OR of packed single-precision (32-bit) floating-point elements.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_cmpeq_ss","","Compare the lowest `f32` of both inputs for equality. The lowest 32 bits of the result will be `0xffffffff` if the two inputs are equal, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_cmplt_ss","","Compare the lowest `f32` of both inputs for less than. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is less than `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_cmple_ss","","Compare the lowest `f32` of both inputs for less than or equal. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is less than or equal `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_cmpgt_ss","","Compare the lowest `f32` of both inputs for greater than. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is greater than `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_cmpge_ss","","Compare the lowest `f32` of both inputs for greater than or equal. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is greater than or equal `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_cmpneq_ss","","Compare the lowest `f32` of both inputs for inequality. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is not equal to `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_cmpnlt_ss","","Compare the lowest `f32` of both inputs for not-less-than. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is not less than `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_cmpnle_ss","","Compare the lowest `f32` of both inputs for not-less-than-or-equal. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is not less than or equal to `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_cmpngt_ss","","Compare the lowest `f32` of both inputs for not-greater-than. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is not greater than `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_cmpnge_ss","","Compare the lowest `f32` of both inputs for not-greater-than-or-equal. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is not greater than or equal to `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_cmpord_ss","","Check if the lowest `f32` of both inputs are ordered. The lowest 32 bits of the result will be `0xffffffff` if neither of `a.extract(0)` or `b.extract(0)` is a NaN, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_cmpunord_ss","","Check if the lowest `f32` of both inputs are unordered. The lowest 32 bits of the result will be `0xffffffff` if any of `a.extract(0)` or `b.extract(0)` is a NaN, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_cmpeq_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input elements were equal, or `0` otherwise.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_cmplt_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is less than the corresponding element in `b`, or `0` otherwise.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_cmple_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is less than or equal to the corresponding element in `b`, or `0` otherwise.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_cmpgt_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is greater than the corresponding element in `b`, or `0` otherwise.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_cmpge_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is greater than or equal to the corresponding element in `b`, or `0` otherwise.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_cmpneq_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input elements are not equal, or `0` otherwise.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_cmpnlt_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is not less than the corresponding element in `b`, or `0` otherwise.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_cmpnle_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is not less than or equal to the corresponding element in `b`, or `0` otherwise.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_cmpngt_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is not greater than the corresponding element in `b`, or `0` otherwise.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_cmpnge_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is not greater than or equal to the corresponding element in `b`, or `0` otherwise.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_cmpord_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. Returns four floats that have one of two possible bit patterns. The element in the output vector will be `0xffffffff` if the input elements in `a` and `b` are ordered (i.e., neither of them is a NaN), or 0 otherwise.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_cmpunord_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. Returns four floats that have one of two possible bit patterns. The element in the output vector will be `0xffffffff` if the input elements in `a` and `b` are unordered (i.e., at least on of them is a NaN), or 0 otherwise.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_comieq_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if they are equal, or `0` otherwise.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"i32"}}],[5,"_mm_comilt_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is less than the one from `b`, or `0` otherwise.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"i32"}}],[5,"_mm_comile_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is less than or equal to the one from `b`, or `0` otherwise.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"i32"}}],[5,"_mm_comigt_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is greater than the one from `b`, or `0` otherwise.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"i32"}}],[5,"_mm_comige_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is greater than or equal to the one from `b`, or `0` otherwise.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"i32"}}],[5,"_mm_comineq_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if they are not equal, or `0` otherwise.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"i32"}}],[5,"_mm_ucomieq_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if they are equal, or `0` otherwise. This instruction will not signal an exception if either argument is a quiet NaN.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"i32"}}],[5,"_mm_ucomilt_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is less than the one from `b`, or `0` otherwise. This instruction will not signal an exception if either argument is a quiet NaN.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"i32"}}],[5,"_mm_ucomile_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is less than or equal to the one from `b`, or `0` otherwise. This instruction will not signal an exception if either argument is a quiet NaN.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"i32"}}],[5,"_mm_ucomigt_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is greater than the one from `b`, or `0` otherwise. This instruction will not signal an exception if either argument is a quiet NaN.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"i32"}}],[5,"_mm_ucomige_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is greater than or equal to the one from `b`, or `0` otherwise. This instruction will not signal an exception if either argument is a quiet NaN.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"i32"}}],[5,"_mm_ucomineq_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if they are not equal, or `0` otherwise. This instruction will not signal an exception if either argument is a quiet NaN.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"i32"}}],[5,"_mm_cvtss_si32","","Convert the lowest 32 bit float in the input vector to a 32 bit integer.",null,{"i":[{"n":"__m128"}],"o":{"n":"i32"}}],[5,"_mm_cvt_ss2si","","Alias for `_mm_cvtss_si32`.",null,{"i":[{"n":"__m128"}],"o":{"n":"i32"}}],[5,"_mm_cvttss_si32","","Convert the lowest 32 bit float in the input vector to a 32 bit integer with truncation.",null,{"i":[{"n":"__m128"}],"o":{"n":"i32"}}],[5,"_mm_cvtt_ss2si","","Alias for `_mm_cvttss_si32`.",null,{"i":[{"n":"__m128"}],"o":{"n":"i32"}}],[5,"_mm_cvtss_f32","","Extract the lowest 32 bit float from the input vector.",null,{"i":[{"n":"__m128"}],"o":{"n":"f32"}}],[5,"_mm_cvtsi32_ss","","Convert a 32 bit integer to a 32 bit float. The result vector is the input vector `a` with the lowest 32 bit float replaced by the converted integer.",null,{"i":[{"n":"__m128"},{"n":"i32"}],"o":{"n":"__m128"}}],[5,"_mm_cvt_si2ss","","Alias for `_mm_cvtsi32_ss`.",null,{"i":[{"n":"__m128"},{"n":"i32"}],"o":{"n":"__m128"}}],[5,"_mm_set_ss","","Construct a `__m128` with the lowest element set to `a` and the rest set to zero.",null,{"i":[{"n":"f32"}],"o":{"n":"__m128"}}],[5,"_mm_set1_ps","","Construct a `__m128` with all element set to `a`.",null,{"i":[{"n":"f32"}],"o":{"n":"__m128"}}],[5,"_mm_set_ps1","","Alias for `_mm_set1_ps`",null,{"i":[{"n":"f32"}],"o":{"n":"__m128"}}],[5,"_mm_set_ps","","Construct a `__m128` from four floating point values highest to lowest.",null,{"i":[{"n":"f32"},{"n":"f32"},{"n":"f32"},{"n":"f32"}],"o":{"n":"__m128"}}],[5,"_mm_setr_ps","","Construct a `__m128` from four floating point values lowest to highest.",null,{"i":[{"n":"f32"},{"n":"f32"},{"n":"f32"},{"n":"f32"}],"o":{"n":"__m128"}}],[5,"_mm_setzero_ps","","Construct a `__m128` with all elements initialized to zero.",null,{"o":{"n":"__m128"}}],[5,"_mm_shuffle_ps","","Shuffle packed single-precision (32-bit) floating-point elements in `a` and `b` using `mask`.",null,{"i":[{"n":"__m128"},{"n":"__m128"},{"n":"u32"}],"o":{"n":"__m128"}}],[5,"_mm_unpackhi_ps","","Unpack and interleave single-precision (32-bit) floating-point elements from the higher half of `a` and `b`.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_unpacklo_ps","","Unpack and interleave single-precision (32-bit) floating-point elements from the lower half of `a` and `b`.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_movehl_ps","","Combine higher half of `a` and `b`. The highwe half of `b` occupies the lower half of result.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_movelh_ps","","Combine lower half of `a` and `b`. The lower half of `b` occupies the higher half of result.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_movemask_ps","","Return a mask of the most significant bit of each element in `a`.",null,{"i":[{"n":"__m128"}],"o":{"n":"i32"}}],[5,"_mm_loadh_pi","","Set the upper two single-precision floating-point values with 64 bits of data loaded from the address `p`; the lower two values are passed through from `a`.",null,null],[5,"_mm_loadl_pi","","Load two floats from `p` into the lower half of a `__m128`. The upper half is copied from the upper half of `a`.",null,null],[5,"_mm_load_ss","","Construct a `__m128` with the lowest element read from `p` and the other elements set to zero.",null,null],[5,"_mm_load1_ps","","Construct a `__m128` by duplicating the value read from `p` into all elements.",null,null],[5,"_mm_load_ps1","","Alias for `_mm_load1_ps`",null,null],[5,"_mm_load_ps","","Load four `f32` values from aligned memory into a `__m128`. If the pointer is not aligned to a 128-bit boundary (16 bytes) a general protection fault will be triggered (fatal program crash).",null,null],[5,"_mm_loadu_ps","","Load four `f32` values from memory into a `__m128`. There are no restrictions on memory alignment. For aligned memory `_mm_load_ps` may be faster.",null,null],[5,"_mm_loadr_ps","","Load four `f32` values from aligned memory into a `__m128` in reverse order.",null,null],[5,"_mm_storeh_pi","","Store the upper half of `a` (64 bits) into memory.",null,null],[5,"_mm_storel_pi","","Store the lower half of `a` (64 bits) into memory.",null,null],[5,"_mm_store_ss","","Store the lowest 32 bit float of `a` into memory.",null,null],[5,"_mm_store1_ps","","Store the lowest 32 bit float of `a` repeated four times into aligned memory.",null,null],[5,"_mm_store_ps1","","Alias for `_mm_store1_ps`",null,null],[5,"_mm_store_ps","","Store four 32-bit floats into aligned memory.",null,null],[5,"_mm_storeu_ps","","Store four 32-bit floats into memory. There are no restrictions on memory alignment. For aligned memory `_mm_store_ps` may be faster.",null,null],[5,"_mm_storer_ps","","Store four 32-bit floats into aligned memory in reverse order.",null,null],[5,"_mm_move_ss","","Return a `__m128` with the first component from `b` and the remaining components from `a`.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_sfence","","Perform a serializing operation on all store-to-memory instructions that were issued prior to this instruction.",null,{}],[5,"_mm_getcsr","","Get the unsigned 32-bit value of the MXCSR control and status register.",null,{"o":{"n":"u32"}}],[5,"_mm_setcsr","","Set the MXCSR register with the 32-bit unsigned integer value.",null,{"i":[{"n":"u32"}]}],[5,"_MM_GET_EXCEPTION_MASK","","See `_mm_setcsr`",null,{"o":{"n":"u32"}}],[5,"_MM_GET_EXCEPTION_STATE","","See `_mm_setcsr`",null,{"o":{"n":"u32"}}],[5,"_MM_GET_FLUSH_ZERO_MODE","","See `_mm_setcsr`",null,{"o":{"n":"u32"}}],[5,"_MM_GET_ROUNDING_MODE","","See `_mm_setcsr`",null,{"o":{"n":"u32"}}],[5,"_MM_SET_EXCEPTION_MASK","","See `_mm_setcsr`",null,{"i":[{"n":"u32"}]}],[5,"_MM_SET_EXCEPTION_STATE","","See `_mm_setcsr`",null,{"i":[{"n":"u32"}]}],[5,"_MM_SET_FLUSH_ZERO_MODE","","See `_mm_setcsr`",null,{"i":[{"n":"u32"}]}],[5,"_MM_SET_ROUNDING_MODE","","See `_mm_setcsr`",null,{"i":[{"n":"u32"}]}],[5,"_mm_prefetch","","Fetch the cache line that contains address `p` using the given `strategy`.",null,null],[5,"_mm_undefined_ps","","Return vector of type __m128 with undefined elements.",null,{"o":{"n":"__m128"}}],[5,"_MM_TRANSPOSE4_PS","","Transpose the 4x4 matrix formed by 4 rows of __m128 in place.",null,{"i":[{"n":"__m128"},{"n":"__m128"},{"n":"__m128"},{"n":"__m128"}]}],[5,"_mm_stream_ps","","Stores `a` into the memory at `mem_addr` using a non-temporal memory hint.",null,null],[5,"_mm_stream_pi","","Store 64-bits of integer data from a into memory using a non-temporal memory hint.",null,null],[5,"_mm_max_pi16","","Compares the packed 16-bit signed integers of `a` and `b` writing the greatest value into the result.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_m_pmaxsw","","Compares the packed 16-bit signed integers of `a` and `b` writing the greatest value into the result.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_max_pu8","","Compares the packed 8-bit signed integers of `a` and `b` writing the greatest value into the result.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_m_pmaxub","","Compares the packed 8-bit signed integers of `a` and `b` writing the greatest value into the result.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_min_pi16","","Compares the packed 16-bit signed integers of `a` and `b` writing the smallest value into the result.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_m_pminsw","","Compares the packed 16-bit signed integers of `a` and `b` writing the smallest value into the result.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_min_pu8","","Compares the packed 8-bit signed integers of `a` and `b` writing the smallest value into the result.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_m_pminub","","Compares the packed 8-bit signed integers of `a` and `b` writing the smallest value into the result.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_mulhi_pu16","","Multiplies packed 16-bit unsigned integer values and writes the high-order 16 bits of each 32-bit product to the corresponding bits in the destination.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_m_pmulhuw","","Multiplies packed 16-bit unsigned integer values and writes the high-order 16 bits of each 32-bit product to the corresponding bits in the destination.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_avg_pu8","","Computes the rounded averages of the packed unsigned 8-bit integer values and writes the averages to the corresponding bits in the destination.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_m_pavgb","","Computes the rounded averages of the packed unsigned 8-bit integer values and writes the averages to the corresponding bits in the destination.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_avg_pu16","","Computes the rounded averages of the packed unsigned 16-bit integer values and writes the averages to the corresponding bits in the destination.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_m_pavgw","","Computes the rounded averages of the packed unsigned 16-bit integer values and writes the averages to the corresponding bits in the destination.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_sad_pu8","","Subtracts the corresponding 8-bit unsigned integer values of the two 64-bit vector operands and computes the absolute value for each of the difference. Then sum of the 8 absolute differences is written to the bits `[15:0]` of the destination; the remaining bits `[63:16]` are cleared.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_m_psadbw","","Subtracts the corresponding 8-bit unsigned integer values of the two 64-bit vector operands and computes the absolute value for each of the difference. Then sum of the 8 absolute differences is written to the bits `[15:0]` of the destination; the remaining bits `[63:16]` are cleared.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_cvtpi32_ps","","Converts two elements of a 64-bit vector of `[2 x i32]` into two floating point values and writes them to the lower 64-bits of the destination. The remaining higher order elements of the destination are copied from the corresponding elements in the first operand.",null,{"i":[{"n":"__m128"},{"n":"__m64"}],"o":{"n":"__m128"}}],[5,"_mm_cvt_pi2ps","","Converts two elements of a 64-bit vector of `[2 x i32]` into two floating point values and writes them to the lower 64-bits of the destination. The remaining higher order elements of the destination are copied from the corresponding elements in the first operand.",null,{"i":[{"n":"__m128"},{"n":"__m64"}],"o":{"n":"__m128"}}],[5,"_mm_cvtpi8_ps","","Converts the lower 4 8-bit values of `a` into a 128-bit vector of 4 `f32`s.",null,{"i":[{"n":"__m64"}],"o":{"n":"__m128"}}],[5,"_mm_cvtpu8_ps","","Converts the lower 4 8-bit values of `a` into a 128-bit vector of 4 `f32`s.",null,{"i":[{"n":"__m64"}],"o":{"n":"__m128"}}],[5,"_mm_cvtpi16_ps","","Converts a 64-bit vector of `i16`s into a 128-bit vector of 4 `f32`s.",null,{"i":[{"n":"__m64"}],"o":{"n":"__m128"}}],[5,"_mm_cvtpu16_ps","","Converts a 64-bit vector of `i16`s into a 128-bit vector of 4 `f32`s.",null,{"i":[{"n":"__m64"}],"o":{"n":"__m128"}}],[5,"_mm_cvtpi32x2_ps","","Converts the two 32-bit signed integer values from each 64-bit vector operand of `[2 x i32]` into a 128-bit vector of `[4 x float]`.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m128"}}],[5,"_mm_maskmove_si64","","Conditionally copies the values from each 8-bit element in the first 64-bit integer vector operand to the specified memory location, as specified by the most significant bit in the corresponding element in the second 64-bit integer vector operand.",null,null],[5,"_m_maskmovq","","Conditionally copies the values from each 8-bit element in the first 64-bit integer vector operand to the specified memory location, as specified by the most significant bit in the corresponding element in the second 64-bit integer vector operand.",null,null],[5,"_mm_extract_pi16","","Extracts 16-bit element from a 64-bit vector of `[4 x i16]` and returns it, as specified by the immediate integer operand.",null,{"i":[{"n":"__m64"},{"n":"i32"}],"o":{"n":"i32"}}],[5,"_m_pextrw","","Extracts 16-bit element from a 64-bit vector of `[4 x i16]` and returns it, as specified by the immediate integer operand.",null,{"i":[{"n":"__m64"},{"n":"i32"}],"o":{"n":"i32"}}],[5,"_mm_insert_pi16","","Copies data from the 64-bit vector of `[4 x i16]` to the destination, and inserts the lower 16-bits of an integer operand at the 16-bit offset specified by the immediate operand `n`.",null,{"i":[{"n":"__m64"},{"n":"i32"},{"n":"i32"}],"o":{"n":"__m64"}}],[5,"_m_pinsrw","","Copies data from the 64-bit vector of `[4 x i16]` to the destination, and inserts the lower 16-bits of an integer operand at the 16-bit offset specified by the immediate operand `n`.",null,{"i":[{"n":"__m64"},{"n":"i32"},{"n":"i32"}],"o":{"n":"__m64"}}],[5,"_mm_movemask_pi8","","Takes the most significant bit from each 8-bit element in a 64-bit integer vector to create a 16-bit mask value. Zero-extends the value to 32-bit integer and writes it to the destination.",null,{"i":[{"n":"__m64"}],"o":{"n":"i32"}}],[5,"_m_pmovmskb","","Takes the most significant bit from each 8-bit element in a 64-bit integer vector to create a 16-bit mask value. Zero-extends the value to 32-bit integer and writes it to the destination.",null,{"i":[{"n":"__m64"}],"o":{"n":"i32"}}],[5,"_mm_shuffle_pi16","","Shuffles the 4 16-bit integers from a 64-bit integer vector to the destination, as specified by the immediate value operand.",null,{"i":[{"n":"__m64"},{"n":"i32"}],"o":{"n":"__m64"}}],[5,"_m_pshufw","","Shuffles the 4 16-bit integers from a 64-bit integer vector to the destination, as specified by the immediate value operand.",null,{"i":[{"n":"__m64"},{"n":"i32"}],"o":{"n":"__m64"}}],[5,"_mm_cvttps_pi32","","Convert the two lower packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers with truncation.",null,{"i":[{"n":"__m128"}],"o":{"n":"__m64"}}],[5,"_mm_cvtt_ps2pi","","Convert the two lower packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers with truncation.",null,{"i":[{"n":"__m128"}],"o":{"n":"__m64"}}],[5,"_mm_cvtps_pi32","","Convert the two lower packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers.",null,{"i":[{"n":"__m128"}],"o":{"n":"__m64"}}],[5,"_mm_cvt_ps2pi","","Convert the two lower packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers.",null,{"i":[{"n":"__m128"}],"o":{"n":"__m64"}}],[5,"_mm_cvtps_pi16","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed 16-bit integers.",null,{"i":[{"n":"__m128"}],"o":{"n":"__m64"}}],[5,"_mm_cvtps_pi8","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed 8-bit integers, and returns theem in the lower 4 elements of the result.",null,{"i":[{"n":"__m128"}],"o":{"n":"__m64"}}],[5,"_mm_pause","","Provide a hint to the processor that the code sequence is a spin-wait loop.",null,{}],[5,"_mm_clflush","","Invalidate and flush the cache line that contains `p` from all levels of the cache hierarchy.",null,null],[5,"_mm_lfence","","Perform a serializing operation on all load-from-memory instructions that were issued prior to this instruction.",null,{}],[5,"_mm_mfence","","Perform a serializing operation on all load-from-memory and store-to-memory instructions that were issued prior to this instruction.",null,{}],[5,"_mm_add_epi8","","Add packed 8-bit integers in `a` and `b`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_add_epi16","","Add packed 16-bit integers in `a` and `b`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_add_epi32","","Add packed 32-bit integers in `a` and `b`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_add_epi64","","Add packed 64-bit integers in `a` and \"b`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_adds_epi8","","Add packed 8-bit integers in `a` and `b` using saturation.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_adds_epi16","","Add packed 16-bit integers in `a` and `b` using saturation.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_adds_epu8","","Add packed unsigned 8-bit integers in `a` and `b` using saturation.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_adds_epu16","","Add packed unsigned 16-bit integers in `a` and `b` using saturation.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_avg_epu8","","Average packed unsigned 8-bit integers in `a` and `b`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_avg_epu16","","Average packed unsigned 16-bit integers in `a` and `b`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_madd_epi16","","Multiply and then horizontally add signed 16 bit integers in `a` and `b`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_max_epi16","","Compare packed 16-bit integers in `a` and `b`, and return the packed maximum values.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_max_epu8","","Compare packed unsigned 8-bit integers in `a` and `b`, and return the packed maximum values.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_min_epi16","","Compare packed 16-bit integers in `a` and `b`, and return the packed minimum values.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_min_epu8","","Compare packed unsigned 8-bit integers in `a` and `b`, and return the packed minimum values.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_mulhi_epi16","","Multiply the packed 16-bit integers in `a` and `b`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_mulhi_epu16","","Multiply the packed unsigned 16-bit integers in `a` and `b`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_mullo_epi16","","Multiply the packed 16-bit integers in `a` and `b`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_mul_epu32","","Multiply the low unsigned 32-bit integers from each packed 64-bit element in `a` and `b`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_sad_epu8","","Sum the absolute differences of packed unsigned 8-bit integers.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_sub_epi8","","Subtract packed 8-bit integers in `b` from packed 8-bit integers in `a`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_sub_epi16","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_sub_epi32","","Subtract packed 32-bit integers in `b` from packed 32-bit integers in `a`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_sub_epi64","","Subtract packed 64-bit integers in `b` from packed 64-bit integers in `a`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_subs_epi8","","Subtract packed 8-bit integers in `b` from packed 8-bit integers in `a` using saturation.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_subs_epi16","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a` using saturation.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_subs_epu8","","Subtract packed unsigned 8-bit integers in `b` from packed unsigned 8-bit integers in `a` using saturation.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_subs_epu16","","Subtract packed unsigned 16-bit integers in `b` from packed unsigned 16-bit integers in `a` using saturation.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_slli_si128","","Shift `a` left by `imm8` bytes while shifting in zeros.",null,{"i":[{"n":"__m128i"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_bslli_si128","","Shift `a` left by `imm8` bytes while shifting in zeros.",null,{"i":[{"n":"__m128i"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_bsrli_si128","","Shift `a` right by `imm8` bytes while shifting in zeros.",null,{"i":[{"n":"__m128i"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_slli_epi16","","Shift packed 16-bit integers in `a` left by `imm8` while shifting in zeros.",null,{"i":[{"n":"__m128i"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_sll_epi16","","Shift packed 16-bit integers in `a` left by `count` while shifting in zeros.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_slli_epi32","","Shift packed 32-bit integers in `a` left by `imm8` while shifting in zeros.",null,{"i":[{"n":"__m128i"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_sll_epi32","","Shift packed 32-bit integers in `a` left by `count` while shifting in zeros.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_slli_epi64","","Shift packed 64-bit integers in `a` left by `imm8` while shifting in zeros.",null,{"i":[{"n":"__m128i"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_sll_epi64","","Shift packed 64-bit integers in `a` left by `count` while shifting in zeros.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_srai_epi16","","Shift packed 16-bit integers in `a` right by `imm8` while shifting in sign bits.",null,{"i":[{"n":"__m128i"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_sra_epi16","","Shift packed 16-bit integers in `a` right by `count` while shifting in sign bits.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_srai_epi32","","Shift packed 32-bit integers in `a` right by `imm8` while shifting in sign bits.",null,{"i":[{"n":"__m128i"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_sra_epi32","","Shift packed 32-bit integers in `a` right by `count` while shifting in sign bits.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_srli_si128","","Shift `a` right by `imm8` bytes while shifting in zeros.",null,{"i":[{"n":"__m128i"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_srli_epi16","","Shift packed 16-bit integers in `a` right by `imm8` while shifting in zeros.",null,{"i":[{"n":"__m128i"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_srl_epi16","","Shift packed 16-bit integers in `a` right by `count` while shifting in zeros.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_srli_epi32","","Shift packed 32-bit integers in `a` right by `imm8` while shifting in zeros.",null,{"i":[{"n":"__m128i"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_srl_epi32","","Shift packed 32-bit integers in `a` right by `count` while shifting in zeros.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_srli_epi64","","Shift packed 64-bit integers in `a` right by `imm8` while shifting in zeros.",null,{"i":[{"n":"__m128i"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_srl_epi64","","Shift packed 64-bit integers in `a` right by `count` while shifting in zeros.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_and_si128","","Compute the bitwise AND of 128 bits (representing integer data) in `a` and `b`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_andnot_si128","","Compute the bitwise NOT of 128 bits (representing integer data) in `a` and then AND with `b`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_or_si128","","Compute the bitwise OR of 128 bits (representing integer data) in `a` and `b`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_xor_si128","","Compute the bitwise XOR of 128 bits (representing integer data) in `a` and `b`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_cmpeq_epi8","","Compare packed 8-bit integers in `a` and `b` for equality.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_cmpeq_epi16","","Compare packed 16-bit integers in `a` and `b` for equality.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_cmpeq_epi32","","Compare packed 32-bit integers in `a` and `b` for equality.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_cmpgt_epi8","","Compare packed 8-bit integers in `a` and `b` for greater-than.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_cmpgt_epi16","","Compare packed 16-bit integers in `a` and `b` for greater-than.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_cmpgt_epi32","","Compare packed 32-bit integers in `a` and `b` for greater-than.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_cmplt_epi8","","Compare packed 8-bit integers in `a` and `b` for less-than.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_cmplt_epi16","","Compare packed 16-bit integers in `a` and `b` for less-than.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_cmplt_epi32","","Compare packed 32-bit integers in `a` and `b` for less-than.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_cvtepi32_pd","","Convert the lower two packed 32-bit integers in `a` to packed double-precision (64-bit) floating-point elements.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m128d"}}],[5,"_mm_cvtsi32_sd","","Return `a` with its lower element replaced by `b` after converting it to an `f64`.",null,{"i":[{"n":"__m128d"},{"n":"i32"}],"o":{"n":"__m128d"}}],[5,"_mm_cvtepi32_ps","","Convert packed 32-bit integers in `a` to packed single-precision (32-bit) floating-point elements.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m128"}}],[5,"_mm_cvtps_epi32","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers.",null,{"i":[{"n":"__m128"}],"o":{"n":"__m128i"}}],[5,"_mm_cvtsi32_si128","","Return a vector whose lowest element is `a` and all higher elements are `0`.",null,{"i":[{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_cvtsi128_si32","","Return the lowest element of `a`.",null,{"i":[{"n":"__m128i"}],"o":{"n":"i32"}}],[5,"_mm_set_epi64x","","Set packed 64-bit integers with the supplied values, from highest to lowest.",null,{"i":[{"n":"i64"},{"n":"i64"}],"o":{"n":"__m128i"}}],[5,"_mm_set_epi32","","Set packed 32-bit integers with the supplied values.",null,{"i":[{"n":"i32"},{"n":"i32"},{"n":"i32"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_set_epi16","","Set packed 16-bit integers with the supplied values.",null,{"i":[{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"}],"o":{"n":"__m128i"}}],[5,"_mm_set_epi8","","Set packed 8-bit integers with the supplied values.",null,{"i":[{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"}],"o":{"n":"__m128i"}}],[5,"_mm_set1_epi64x","","Broadcast 64-bit integer `a` to all elements.",null,{"i":[{"n":"i64"}],"o":{"n":"__m128i"}}],[5,"_mm_set1_epi32","","Broadcast 32-bit integer `a` to all elements.",null,{"i":[{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_set1_epi16","","Broadcast 16-bit integer `a` to all elements.",null,{"i":[{"n":"i16"}],"o":{"n":"__m128i"}}],[5,"_mm_set1_epi8","","Broadcast 8-bit integer `a` to all elements.",null,{"i":[{"n":"i8"}],"o":{"n":"__m128i"}}],[5,"_mm_setr_epi32","","Set packed 32-bit integers with the supplied values in reverse order.",null,{"i":[{"n":"i32"},{"n":"i32"},{"n":"i32"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_setr_epi16","","Set packed 16-bit integers with the supplied values in reverse order.",null,{"i":[{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"}],"o":{"n":"__m128i"}}],[5,"_mm_setr_epi8","","Set packed 8-bit integers with the supplied values in reverse order.",null,{"i":[{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"}],"o":{"n":"__m128i"}}],[5,"_mm_setzero_si128","","Returns a vector with all elements set to zero.",null,{"o":{"n":"__m128i"}}],[5,"_mm_loadl_epi64","","Load 64-bit integer from memory into first element of returned vector.",null,null],[5,"_mm_load_si128","","Load 128-bits of integer data from memory into a new vector.",null,null],[5,"_mm_loadu_si128","","Load 128-bits of integer data from memory into a new vector.",null,null],[5,"_mm_maskmoveu_si128","","Conditionally store 8-bit integer elements from `a` into memory using `mask`.",null,null],[5,"_mm_store_si128","","Store 128-bits of integer data from `a` into memory.",null,null],[5,"_mm_storeu_si128","","Store 128-bits of integer data from `a` into memory.",null,null],[5,"_mm_storel_epi64","","Store the lower 64-bit integer `a` to a memory location.",null,null],[5,"_mm_stream_si128","","Stores a 128-bit integer vector to a 128-bit aligned memory location. To minimize caching, the data is flagged as non-temporal (unlikely to be used again soon).",null,null],[5,"_mm_stream_si32","","Stores a 32-bit integer value in the specified memory location. To minimize caching, the data is flagged as non-temporal (unlikely to be used again soon).",null,null],[5,"_mm_move_epi64","","Return a vector where the low element is extracted from `a` and its upper element is zero.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_packs_epi16","","Convert packed 16-bit integers from `a` and `b` to packed 8-bit integers using signed saturation.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_packs_epi32","","Convert packed 32-bit integers from `a` and `b` to packed 16-bit integers using signed saturation.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_packus_epi16","","Convert packed 16-bit integers from `a` and `b` to packed 8-bit integers using unsigned saturation.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_extract_epi16","","Return the `imm8` element of `a`.",null,{"i":[{"n":"__m128i"},{"n":"i32"}],"o":{"n":"i32"}}],[5,"_mm_insert_epi16","","Return a new vector where the `imm8` element of `a` is replaced with `i`.",null,{"i":[{"n":"__m128i"},{"n":"i32"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_movemask_epi8","","Return a mask of the most significant bit of each element in `a`.",null,{"i":[{"n":"__m128i"}],"o":{"n":"i32"}}],[5,"_mm_shuffle_epi32","","Shuffle 32-bit integers in `a` using the control in `imm8`.",null,{"i":[{"n":"__m128i"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_shufflehi_epi16","","Shuffle 16-bit integers in the high 64 bits of `a` using the control in `imm8`.",null,{"i":[{"n":"__m128i"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_shufflelo_epi16","","Shuffle 16-bit integers in the low 64 bits of `a` using the control in `imm8`.",null,{"i":[{"n":"__m128i"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_unpackhi_epi8","","Unpack and interleave 8-bit integers from the high half of `a` and `b`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_unpackhi_epi16","","Unpack and interleave 16-bit integers from the high half of `a` and `b`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_unpackhi_epi32","","Unpack and interleave 32-bit integers from the high half of `a` and `b`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_unpackhi_epi64","","Unpack and interleave 64-bit integers from the high half of `a` and `b`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_unpacklo_epi8","","Unpack and interleave 8-bit integers from the low half of `a` and `b`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_unpacklo_epi16","","Unpack and interleave 16-bit integers from the low half of `a` and `b`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_unpacklo_epi32","","Unpack and interleave 32-bit integers from the low half of `a` and `b`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_unpacklo_epi64","","Unpack and interleave 64-bit integers from the low half of `a` and `b`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_add_sd","","Return a new vector with the low element of `a` replaced by the sum of the low elements of `a` and `b`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_add_pd","","Add packed double-precision (64-bit) floating-point elements in `a` and `b`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_div_sd","","Return a new vector with the low element of `a` replaced by the result of diving the lower element of `a` by the lower element of `b`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_div_pd","","Divide packed double-precision (64-bit) floating-point elements in `a` by packed elements in `b`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_max_sd","","Return a new vector with the low element of `a` replaced by the maximum of the lower elements of `a` and `b`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_max_pd","","Return a new vector with the maximum values from corresponding elements in `a` and `b`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_min_sd","","Return a new vector with the low element of `a` replaced by the minimum of the lower elements of `a` and `b`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_min_pd","","Return a new vector with the minimum values from corresponding elements in `a` and `b`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_mul_sd","","Return a new vector with the low element of `a` replaced by multiplying the low elements of `a` and `b`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_mul_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_sqrt_sd","","Return a new vector with the low element of `a` replaced by the square root of the lower element `b`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_sqrt_pd","","Return a new vector with the square root of each of the values in `a`.",null,{"i":[{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_sub_sd","","Return a new vector with the low element of `a` replaced by subtracting the low element by `b` from the low element of `a`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_sub_pd","","Subtract packed double-precision (64-bit) floating-point elements in `b` from `a`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_and_pd","","Compute the bitwise AND of packed double-precision (64-bit) floating-point elements in `a` and `b`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_andnot_pd","","Compute the bitwise NOT of `a` and then AND with `b`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_or_pd","","Compute the bitwise OR of `a` and `b`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_xor_pd","","Compute the bitwise OR of `a` and `b`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_cmpeq_sd","","Return a new vector with the low element of `a` replaced by the equality comparison of the lower elements of `a` and `b`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_cmplt_sd","","Return a new vector with the low element of `a` replaced by the less-than comparison of the lower elements of `a` and `b`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_cmple_sd","","Return a new vector with the low element of `a` replaced by the less-than-or-equal comparison of the lower elements of `a` and `b`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_cmpgt_sd","","Return a new vector with the low element of `a` replaced by the greater-than comparison of the lower elements of `a` and `b`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_cmpge_sd","","Return a new vector with the low element of `a` replaced by the greater-than-or-equal comparison of the lower elements of `a` and `b`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_cmpord_sd","","Return a new vector with the low element of `a` replaced by the result of comparing both of the lower elements of `a` and `b` to `NaN`. If neither are equal to `NaN` then `0xFFFFFFFFFFFFFFFF` is used and `0` otherwise.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_cmpunord_sd","","Return a new vector with the low element of `a` replaced by the result of comparing both of the lower elements of `a` and `b` to `NaN`. If either is equal to `NaN` then `0xFFFFFFFFFFFFFFFF` is used and `0` otherwise.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_cmpneq_sd","","Return a new vector with the low element of `a` replaced by the not-equal comparison of the lower elements of `a` and `b`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_cmpnlt_sd","","Return a new vector with the low element of `a` replaced by the not-less-than comparison of the lower elements of `a` and `b`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_cmpnle_sd","","Return a new vector with the low element of `a` replaced by the not-less-than-or-equal comparison of the lower elements of `a` and `b`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_cmpngt_sd","","Return a new vector with the low element of `a` replaced by the not-greater-than comparison of the lower elements of `a` and `b`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_cmpnge_sd","","Return a new vector with the low element of `a` replaced by the not-greater-than-or-equal comparison of the lower elements of `a` and `b`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_cmpeq_pd","","Compare corresponding elements in `a` and `b` for equality.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_cmplt_pd","","Compare corresponding elements in `a` and `b` for less-than.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_cmple_pd","","Compare corresponding elements in `a` and `b` for less-than-or-equal",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_cmpgt_pd","","Compare corresponding elements in `a` and `b` for greater-than.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_cmpge_pd","","Compare corresponding elements in `a` and `b` for greater-than-or-equal.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_cmpord_pd","","Compare corresponding elements in `a` and `b` to see if neither is `NaN`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_cmpunord_pd","","Compare corresponding elements in `a` and `b` to see if either is `NaN`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_cmpneq_pd","","Compare corresponding elements in `a` and `b` for not-equal.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_cmpnlt_pd","","Compare corresponding elements in `a` and `b` for not-less-than.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_cmpnle_pd","","Compare corresponding elements in `a` and `b` for not-less-than-or-equal.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_cmpngt_pd","","Compare corresponding elements in `a` and `b` for not-greater-than.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_cmpnge_pd","","Compare corresponding elements in `a` and `b` for not-greater-than-or-equal.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_comieq_sd","","Compare the lower element of `a` and `b` for equality.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"i32"}}],[5,"_mm_comilt_sd","","Compare the lower element of `a` and `b` for less-than.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"i32"}}],[5,"_mm_comile_sd","","Compare the lower element of `a` and `b` for less-than-or-equal.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"i32"}}],[5,"_mm_comigt_sd","","Compare the lower element of `a` and `b` for greater-than.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"i32"}}],[5,"_mm_comige_sd","","Compare the lower element of `a` and `b` for greater-than-or-equal.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"i32"}}],[5,"_mm_comineq_sd","","Compare the lower element of `a` and `b` for not-equal.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"i32"}}],[5,"_mm_ucomieq_sd","","Compare the lower element of `a` and `b` for equality.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"i32"}}],[5,"_mm_ucomilt_sd","","Compare the lower element of `a` and `b` for less-than.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"i32"}}],[5,"_mm_ucomile_sd","","Compare the lower element of `a` and `b` for less-than-or-equal.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"i32"}}],[5,"_mm_ucomigt_sd","","Compare the lower element of `a` and `b` for greater-than.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"i32"}}],[5,"_mm_ucomige_sd","","Compare the lower element of `a` and `b` for greater-than-or-equal.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"i32"}}],[5,"_mm_ucomineq_sd","","Compare the lower element of `a` and `b` for not-equal.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"i32"}}],[5,"_mm_cvtpd_ps","","Convert packed double-precision (64-bit) floating-point elements in \"a\" to packed single-precision (32-bit) floating-point elements",null,{"i":[{"n":"__m128d"}],"o":{"n":"__m128"}}],[5,"_mm_cvtps_pd","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed double-precision (64-bit) floating-point elements.",null,{"i":[{"n":"__m128"}],"o":{"n":"__m128d"}}],[5,"_mm_cvtpd_epi32","","Convert packed double-precision (64-bit) floating-point elements in `a` to packed 32-bit integers.",null,{"i":[{"n":"__m128d"}],"o":{"n":"__m128i"}}],[5,"_mm_cvtsd_si32","","Convert the lower double-precision (64-bit) floating-point element in a to a 32-bit integer.",null,{"i":[{"n":"__m128d"}],"o":{"n":"i32"}}],[5,"_mm_cvtsd_ss","","Convert the lower double-precision (64-bit) floating-point element in `b` to a single-precision (32-bit) floating-point element, store the result in the lower element of the return value, and copy the upper element from `a` to the upper element the return value.",null,{"i":[{"n":"__m128"},{"n":"__m128d"}],"o":{"n":"__m128"}}],[5,"_mm_cvtsd_f64","","Return the lower double-precision (64-bit) floating-point element of \"a\".",null,{"i":[{"n":"__m128d"}],"o":{"n":"f64"}}],[5,"_mm_cvtss_sd","","Convert the lower single-precision (32-bit) floating-point element in `b` to a double-precision (64-bit) floating-point element, store the result in the lower element of the return value, and copy the upper element from `a` to the upper element the return value.",null,{"i":[{"n":"__m128d"},{"n":"__m128"}],"o":{"n":"__m128d"}}],[5,"_mm_cvttpd_epi32","","Convert packed double-precision (64-bit) floating-point elements in `a` to packed 32-bit integers with truncation.",null,{"i":[{"n":"__m128d"}],"o":{"n":"__m128i"}}],[5,"_mm_cvttsd_si32","","Convert the lower double-precision (64-bit) floating-point element in `a` to a 32-bit integer with truncation.",null,{"i":[{"n":"__m128d"}],"o":{"n":"i32"}}],[5,"_mm_cvttps_epi32","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers with truncation.",null,{"i":[{"n":"__m128"}],"o":{"n":"__m128i"}}],[5,"_mm_set_sd","","Copy double-precision (64-bit) floating-point element `a` to the lower element of the packed 64-bit return value.",null,{"i":[{"n":"f64"}],"o":{"n":"__m128d"}}],[5,"_mm_set1_pd","","Broadcast double-precision (64-bit) floating-point value a to all elements of the return value.",null,{"i":[{"n":"f64"}],"o":{"n":"__m128d"}}],[5,"_mm_set_pd1","","Broadcast double-precision (64-bit) floating-point value a to all elements of the return value.",null,{"i":[{"n":"f64"}],"o":{"n":"__m128d"}}],[5,"_mm_set_pd","","Set packed double-precision (64-bit) floating-point elements in the return value with the supplied values.",null,{"i":[{"n":"f64"},{"n":"f64"}],"o":{"n":"__m128d"}}],[5,"_mm_setr_pd","","Set packed double-precision (64-bit) floating-point elements in the return value with the supplied values in reverse order.",null,{"i":[{"n":"f64"},{"n":"f64"}],"o":{"n":"__m128d"}}],[5,"_mm_setzero_pd","","Returns packed double-precision (64-bit) floating-point elements with all zeros.",null,{"o":{"n":"__m128d"}}],[5,"_mm_movemask_pd","","Return a mask of the most significant bit of each element in `a`.",null,{"i":[{"n":"__m128d"}],"o":{"n":"i32"}}],[5,"_mm_load_pd","","Load 128-bits (composed of 2 packed double-precision (64-bit) floating-point elements) from memory into the returned vector. `mem_addr` must be aligned on a 16-byte boundary or a general-protection exception may be generated.",null,null],[5,"_mm_load_sd","","Loads a 64-bit double-precision value to the low element of a 128-bit integer vector and clears the upper element.",null,null],[5,"_mm_loadh_pd","","Loads a double-precision value into the high-order bits of a 128-bit vector of `[2 x double]`. The low-order bits are copied from the low-order bits of the first operand.",null,null],[5,"_mm_loadl_pd","","Loads a double-precision value into the low-order bits of a 128-bit vector of `[2 x double]`. The high-order bits are copied from the high-order bits of the first operand.",null,null],[5,"_mm_stream_pd","","Stores a 128-bit floating point vector of `[2 x double]` to a 128-bit aligned memory location. To minimize caching, the data is flagged as non-temporal (unlikely to be used again soon).",null,null],[5,"_mm_store_sd","","Stores the lower 64 bits of a 128-bit vector of `[2 x double]` to a memory location.",null,null],[5,"_mm_store_pd","","Store 128-bits (composed of 2 packed double-precision (64-bit) floating-point elements) from `a` into memory. `mem_addr` must be aligned on a 16-byte boundary or a general-protection exception may be generated.",null,null],[5,"_mm_storeu_pd","","Store 128-bits (composed of 2 packed double-precision (64-bit) floating-point elements) from `a` into memory. `mem_addr` does not need to be aligned on any particular boundary.",null,null],[5,"_mm_store1_pd","","Store the lower double-precision (64-bit) floating-point element from `a` into 2 contiguous elements in memory. `mem_addr` must be aligned on a 16-byte boundary or a general-protection exception may be generated.",null,null],[5,"_mm_store_pd1","","Store the lower double-precision (64-bit) floating-point element from `a` into 2 contiguous elements in memory. `mem_addr` must be aligned on a 16-byte boundary or a general-protection exception may be generated.",null,null],[5,"_mm_storer_pd","","Store 2 double-precision (64-bit) floating-point elements from `a` into memory in reverse order. `mem_addr` must be aligned on a 16-byte boundary or a general-protection exception may be generated.",null,null],[5,"_mm_storeh_pd","","Stores the upper 64 bits of a 128-bit vector of `[2 x double]` to a memory location.",null,null],[5,"_mm_storel_pd","","Stores the lower 64 bits of a 128-bit vector of `[2 x double]` to a memory location.",null,null],[5,"_mm_load1_pd","","Load a double-precision (64-bit) floating-point element from memory into both elements of returned vector.",null,null],[5,"_mm_load_pd1","","Load a double-precision (64-bit) floating-point element from memory into both elements of returned vector.",null,null],[5,"_mm_loadr_pd","","Load 2 double-precision (64-bit) floating-point elements from memory into the returned vector in reverse order. `mem_addr` must be aligned on a 16-byte boundary or a general-protection exception may be generated.",null,null],[5,"_mm_loadu_pd","","Load 128-bits (composed of 2 packed double-precision (64-bit) floating-point elements) from memory into the returned vector. `mem_addr` does not need to be aligned on any particular boundary.",null,null],[5,"_mm_shuffle_pd","","Constructs a 128-bit floating-point vector of `[2 x double]` from two 128-bit vector parameters of `[2 x double]`, using the immediate-value parameter as a specifier.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"},{"n":"i32"}],"o":{"n":"__m128d"}}],[5,"_mm_move_sd","","Constructs a 128-bit floating-point vector of `[2 x double]`. The lower 64 bits are set to the lower 64 bits of the second parameter. The upper 64 bits are set to the upper 64 bits of the first parameter.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_castpd_ps","","Casts a 128-bit floating-point vector of `[2 x double]` into a 128-bit floating-point vector of `[4 x float]`.",null,{"i":[{"n":"__m128d"}],"o":{"n":"__m128"}}],[5,"_mm_castpd_si128","","Casts a 128-bit floating-point vector of `[2 x double]` into a 128-bit integer vector.",null,{"i":[{"n":"__m128d"}],"o":{"n":"__m128i"}}],[5,"_mm_castps_pd","","Casts a 128-bit floating-point vector of `[4 x float]` into a 128-bit floating-point vector of `[2 x double]`.",null,{"i":[{"n":"__m128"}],"o":{"n":"__m128d"}}],[5,"_mm_castps_si128","","Casts a 128-bit floating-point vector of `[4 x float]` into a 128-bit integer vector.",null,{"i":[{"n":"__m128"}],"o":{"n":"__m128i"}}],[5,"_mm_castsi128_pd","","Casts a 128-bit integer vector into a 128-bit floating-point vector of `[2 x double]`.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m128d"}}],[5,"_mm_castsi128_ps","","Casts a 128-bit integer vector into a 128-bit floating-point vector of `[4 x float]`.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m128"}}],[5,"_mm_undefined_pd","","Return vector of type __m128d with undefined elements.",null,{"o":{"n":"__m128d"}}],[5,"_mm_undefined_si128","","Return vector of type __m128i with undefined elements.",null,{"o":{"n":"__m128i"}}],[5,"_mm_unpackhi_pd","","The resulting `__m128d` element is composed by the low-order values of the two `__m128d` interleaved input elements, i.e.:",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_unpacklo_pd","","The resulting `__m128d` element is composed by the high-order values of the two `__m128d` interleaved input elements, i.e.:",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_add_si64","","Adds two signed or unsigned 64-bit integer values, returning the lower 64 bits of the sum.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_mul_su32","","Multiplies 32-bit unsigned integer values contained in the lower bits of the two 64-bit integer vectors and returns the 64-bit unsigned product.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_sub_si64","","Subtracts signed or unsigned 64-bit integer values and writes the difference to the corresponding bits in the destination.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_cvtpi32_pd","","Converts the two signed 32-bit integer elements of a 64-bit vector of `[2 x i32]` into two double-precision floating-point values, returned in a 128-bit vector of `[2 x double]`.",null,{"i":[{"n":"__m64"}],"o":{"n":"__m128d"}}],[5,"_mm_set_epi64","","Initializes both 64-bit values in a 128-bit vector of `[2 x i64]` with the specified 64-bit integer values.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m128i"}}],[5,"_mm_set1_epi64","","Initializes both values in a 128-bit vector of `[2 x i64]` with the specified 64-bit value.",null,{"i":[{"n":"__m64"}],"o":{"n":"__m128i"}}],[5,"_mm_setr_epi64","","Constructs a 128-bit integer vector, initialized in reverse order with the specified 64-bit integral values.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m128i"}}],[5,"_mm_movepi64_pi64","","Returns the lower 64 bits of a 128-bit integer vector as a 64-bit integer.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m64"}}],[5,"_mm_movpi64_epi64","","Moves the 64-bit operand to a 128-bit integer vector, zeroing the upper bits.",null,{"i":[{"n":"__m64"}],"o":{"n":"__m128i"}}],[5,"_mm_cvtpd_pi32","","Converts the two double-precision floating-point elements of a 128-bit vector of `[2 x double]` into two signed 32-bit integer values, returned in a 64-bit vector of `[2 x i32]`.",null,{"i":[{"n":"__m128d"}],"o":{"n":"__m64"}}],[5,"_mm_cvttpd_pi32","","Converts the two double-precision floating-point elements of a 128-bit vector of `[2 x double]` into two signed 32-bit integer values, returned in a 64-bit vector of `[2 x i32]`. If the result of either conversion is inexact, the result is truncated (rounded towards zero) regardless of the current MXCSR setting.",null,{"i":[{"n":"__m128d"}],"o":{"n":"__m64"}}],[5,"_mm_addsub_ps","","Alternatively add and subtract packed single-precision (32-bit) floating-point elements in `a` to/from packed elements in `b`.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_addsub_pd","","Alternatively add and subtract packed double-precision (64-bit) floating-point elements in `a` to/from packed elements in `b`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_hadd_pd","","Horizontally add adjacent pairs of double-precision (64-bit) floating-point elements in `a` and `b`, and pack the results.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_hadd_ps","","Horizontally add adjacent pairs of single-precision (32-bit) floating-point elements in `a` and `b`, and pack the results.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_hsub_pd","","Horizontally subtract adjacent pairs of double-precision (64-bit) floating-point elements in `a` and `b`, and pack the results.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_hsub_ps","","Horizontally add adjacent pairs of single-precision (32-bit) floating-point elements in `a` and `b`, and pack the results.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_lddqu_si128","","Load 128-bits of integer data from unaligned memory. This intrinsic may perform better than `_mm_loadu_si128` when the data crosses a cache line boundary.",null,null],[5,"_mm_movedup_pd","","Duplicate the low double-precision (64-bit) floating-point element from `a`.",null,{"i":[{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_loaddup_pd","","Load a double-precision (64-bit) floating-point element from memory into both elements of return vector.",null,null],[5,"_mm_movehdup_ps","","Duplicate odd-indexed single-precision (32-bit) floating-point elements from `a`.",null,{"i":[{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_moveldup_ps","","Duplicate even-indexed single-precision (32-bit) floating-point elements from `a`.",null,{"i":[{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_abs_epi8","","Compute the absolute value of packed 8-bit signed integers in `a` and return the unsigned results.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_abs_epi16","","Compute the absolute value of each of the packed 16-bit signed integers in `a` and return the 16-bit unsigned integer",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_abs_epi32","","Compute the absolute value of each of the packed 32-bit signed integers in `a` and return the 32-bit unsigned integer",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_shuffle_epi8","","Shuffle bytes from `a` according to the content of `b`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_alignr_epi8","","Concatenate 16-byte blocks in `a` and `b` into a 32-byte temporary result, shift the result right by `n` bytes, and return the low 16 bytes.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_hadd_epi16","","Horizontally add the adjacent pairs of values contained in 2 packed 128-bit vectors of `[8 x i16]`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_hadds_epi16","","Horizontally add the adjacent pairs of values contained in 2 packed 128-bit vectors of `[8 x i16]`. Positive sums greater than 7FFFh are saturated to 7FFFh. Negative sums less than 8000h are saturated to 8000h.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_hadd_epi32","","Horizontally add the adjacent pairs of values contained in 2 packed 128-bit vectors of `[4 x i32]`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_hsub_epi16","","Horizontally subtract the adjacent pairs of values contained in 2 packed 128-bit vectors of `[8 x i16]`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_hsubs_epi16","","Horizontally subtract the adjacent pairs of values contained in 2 packed 128-bit vectors of `[8 x i16]`. Positive differences greater than 7FFFh are saturated to 7FFFh. Negative differences less than 8000h are saturated to 8000h.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_hsub_epi32","","Horizontally subtract the adjacent pairs of values contained in 2 packed 128-bit vectors of `[4 x i32]`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_maddubs_epi16","","Multiply corresponding pairs of packed 8-bit unsigned integer values contained in the first source operand and packed 8-bit signed integer values contained in the second source operand, add pairs of contiguous products with signed saturation, and writes the 16-bit sums to the corresponding bits in the destination.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_mulhrs_epi16","","Multiply packed 16-bit signed integer values, truncate the 32-bit product to the 18 most significant bits by right-shifting, round the truncated value by adding 1, and write bits `[16:1]` to the destination.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_sign_epi8","","Negate packed 8-bit integers in `a` when the corresponding signed 8-bit integer in `b` is negative, and return the result. Elements in result are zeroed out when the corresponding element in `b` is zero.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_sign_epi16","","Negate packed 16-bit integers in `a` when the corresponding signed 16-bit integer in `b` is negative, and return the results. Elements in result are zeroed out when the corresponding element in `b` is zero.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_sign_epi32","","Negate packed 32-bit integers in `a` when the corresponding signed 32-bit integer in `b` is negative, and return the results. Element in result are zeroed out when the corresponding element in `b` is zero.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_abs_pi8","","Compute the absolute value of packed 8-bit integers in `a` and return the unsigned results.",null,{"i":[{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_abs_pi16","","Compute the absolute value of packed 8-bit integers in `a`, and return the unsigned results.",null,{"i":[{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_abs_pi32","","Compute the absolute value of packed 32-bit integers in `a`, and return the unsigned results.",null,{"i":[{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_shuffle_pi8","","Shuffle packed 8-bit integers in `a` according to shuffle control mask in the corresponding 8-bit element of `b`, and return the results",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_alignr_pi8","","Concatenates the two 64-bit integer vector operands, and right-shifts the result by the number of bytes specified in the immediate operand.",null,{"i":[{"n":"__m64"},{"n":"__m64"},{"n":"i32"}],"o":{"n":"__m64"}}],[5,"_mm_hadd_pi16","","Horizontally add the adjacent pairs of values contained in 2 packed 64-bit vectors of `[4 x i16]`.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_hadd_pi32","","Horizontally add the adjacent pairs of values contained in 2 packed 64-bit vectors of `[2 x i32]`.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_hadds_pi16","","Horizontally add the adjacent pairs of values contained in 2 packed 64-bit vectors of `[4 x i16]`. Positive sums greater than 7FFFh are saturated to 7FFFh. Negative sums less than 8000h are saturated to 8000h.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_hsub_pi16","","Horizontally subtracts the adjacent pairs of values contained in 2 packed 64-bit vectors of `[4 x i16]`.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_hsub_pi32","","Horizontally subtracts the adjacent pairs of values contained in 2 packed 64-bit vectors of `[2 x i32]`.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_hsubs_pi16","","Horizontally subtracts the adjacent pairs of values contained in 2 packed 64-bit vectors of `[4 x i16]`. Positive differences greater than 7FFFh are saturated to 7FFFh. Negative differences less than 8000h are saturated to 8000h.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_maddubs_pi16","","Multiplies corresponding pairs of packed 8-bit unsigned integer values contained in the first source operand and packed 8-bit signed integer values contained in the second source operand, adds pairs of contiguous products with signed saturation, and writes the 16-bit sums to the corresponding bits in the destination.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_mulhrs_pi16","","Multiplies packed 16-bit signed integer values, truncates the 32-bit products to the 18 most significant bits by right-shifting, rounds the truncated value by adding 1, and writes bits `[16:1]` to the destination.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_sign_pi8","","Negate packed 8-bit integers in `a` when the corresponding signed 8-bit integer in `b` is negative, and return the results. Element in result are zeroed out when the corresponding element in `b` is zero.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_sign_pi16","","Negate packed 16-bit integers in `a` when the corresponding signed 16-bit integer in `b` is negative, and return the results. Element in result are zeroed out when the corresponding element in `b` is zero.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_sign_pi32","","Negate packed 32-bit integers in `a` when the corresponding signed 32-bit integer in `b` is negative, and return the results. Element in result are zeroed out when the corresponding element in `b` is zero.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_blendv_epi8","","Blend packed 8-bit integers from `a` and `b` using `mask`",null,{"i":[{"n":"__m128i"},{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_blend_epi16","","Blend packed 16-bit integers from `a` and `b` using the mask `imm8`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_blendv_pd","","Blend packed double-precision (64-bit) floating-point elements from `a` and `b` using `mask`",null,{"i":[{"n":"__m128d"},{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_blendv_ps","","Blend packed single-precision (32-bit) floating-point elements from `a` and `b` using `mask`",null,{"i":[{"n":"__m128"},{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_blend_pd","","Blend packed double-precision (64-bit) floating-point elements from `a` and `b` using control mask `imm2`",null,{"i":[{"n":"__m128d"},{"n":"__m128d"},{"n":"i32"}],"o":{"n":"__m128d"}}],[5,"_mm_blend_ps","","Blend packed single-precision (32-bit) floating-point elements from `a` and `b` using mask `imm4`",null,{"i":[{"n":"__m128"},{"n":"__m128"},{"n":"i32"}],"o":{"n":"__m128"}}],[5,"_mm_extract_ps","","Extract a single-precision (32-bit) floating-point element from `a`, selected with `imm8`",null,{"i":[{"n":"__m128"},{"n":"i32"}],"o":{"n":"i32"}}],[5,"_mm_extract_epi8","","Extract an 8-bit integer from `a`, selected with `imm8`. Returns a 32-bit integer containing the zero-extended integer data.",null,{"i":[{"n":"__m128i"},{"n":"i32"}],"o":{"n":"i32"}}],[5,"_mm_extract_epi32","","Extract an 32-bit integer from `a` selected with `imm8`",null,{"i":[{"n":"__m128i"},{"n":"i32"}],"o":{"n":"i32"}}],[5,"_mm_insert_ps","","Select a single value in `a` to store at some position in `b`, Then zero elements according to `imm8`.",null,{"i":[{"n":"__m128"},{"n":"__m128"},{"n":"i32"}],"o":{"n":"__m128"}}],[5,"_mm_insert_epi8","","Return a copy of `a` with the 8-bit integer from `i` inserted at a location specified by `imm8`.",null,{"i":[{"n":"__m128i"},{"n":"i32"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_insert_epi32","","Return a copy of `a` with the 32-bit integer from `i` inserted at a location specified by `imm8`.",null,{"i":[{"n":"__m128i"},{"n":"i32"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_max_epi8","","Compare packed 8-bit integers in `a` and `b` and return packed maximum values in dst.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_max_epu16","","Compare packed unsigned 16-bit integers in `a` and `b`, and return packed maximum.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_max_epi32","","Compare packed 32-bit integers in `a` and `b`, and return packed maximum values.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_max_epu32","","Compare packed unsigned 32-bit integers in `a` and `b`, and return packed maximum values.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_min_epi8","","Compare packed 8-bit integers in `a` and `b` and return packed minimum values in dst.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_min_epu16","","Compare packed unsigned 16-bit integers in `a` and `b`, and return packed minimum.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_min_epi32","","Compare packed 32-bit integers in `a` and `b`, and return packed minimum values.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_min_epu32","","Compare packed unsigned 32-bit integers in `a` and `b`, and return packed minimum values.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_packus_epi32","","Convert packed 32-bit integers from `a` and `b` to packed 16-bit integers using unsigned saturation",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_cmpeq_epi64","","Compare packed 64-bit integers in `a` and `b` for equality",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_cvtepi8_epi16","","Sign extend packed 8-bit integers in `a` to packed 16-bit integers",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_cvtepi8_epi32","","Sign extend packed 8-bit integers in `a` to packed 32-bit integers",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_cvtepi8_epi64","","Sign extend packed 8-bit integers in the low 8 bytes of `a` to packed 64-bit integers",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_cvtepi16_epi32","","Sign extend packed 16-bit integers in `a` to packed 32-bit integers",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_cvtepi16_epi64","","Sign extend packed 16-bit integers in `a` to packed 64-bit integers",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_cvtepi32_epi64","","Sign extend packed 32-bit integers in `a` to packed 64-bit integers",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_cvtepu8_epi16","","Zero extend packed unsigned 8-bit integers in `a` to packed 16-bit integers",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_cvtepu8_epi32","","Zero extend packed unsigned 8-bit integers in `a` to packed 32-bit integers",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_cvtepu8_epi64","","Zero extend packed unsigned 8-bit integers in `a` to packed 64-bit integers",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_cvtepu16_epi32","","Zero extend packed unsigned 16-bit integers in `a` to packed 32-bit integers",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_cvtepu16_epi64","","Zero extend packed unsigned 16-bit integers in `a` to packed 64-bit integers",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_cvtepu32_epi64","","Zero extend packed unsigned 32-bit integers in `a` to packed 64-bit integers",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_dp_pd","","Returns the dot product of two __m128d vectors.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"},{"n":"i32"}],"o":{"n":"__m128d"}}],[5,"_mm_dp_ps","","Returns the dot product of two __m128 vectors.",null,{"i":[{"n":"__m128"},{"n":"__m128"},{"n":"i32"}],"o":{"n":"__m128"}}],[5,"_mm_floor_pd","","Round the packed double-precision (64-bit) floating-point elements in `a` down to an integer value, and store the results as packed double-precision floating-point elements.",null,{"i":[{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_floor_ps","","Round the packed single-precision (32-bit) floating-point elements in `a` down to an integer value, and store the results as packed single-precision floating-point elements.",null,{"i":[{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_floor_sd","","Round the lower double-precision (64-bit) floating-point element in `b` down to an integer value, store the result as a double-precision floating-point element in the lower element of the intrinsic result, and copy the upper element from `a` to the upper element of the intrinsic result.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_floor_ss","","Round the lower single-precision (32-bit) floating-point element in `b` down to an integer value, store the result as a single-precision floating-point element in the lower element of the intrinsic result, and copy the upper 3 packed elements from `a` to the upper elements of the intrinsic result.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_ceil_pd","","Round the packed double-precision (64-bit) floating-point elements in `a` up to an integer value, and store the results as packed double-precision floating-point elements.",null,{"i":[{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_ceil_ps","","Round the packed single-precision (32-bit) floating-point elements in `a` up to an integer value, and store the results as packed single-precision floating-point elements.",null,{"i":[{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_ceil_sd","","Round the lower double-precision (64-bit) floating-point element in `b` up to an integer value, store the result as a double-precision floating-point element in the lower element of the intrisic result, and copy the upper element from `a` to the upper element of the intrinsic result.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_ceil_ss","","Round the lower single-precision (32-bit) floating-point element in `b` up to an integer value, store the result as a single-precision floating-point element in the lower element of the intrinsic result, and copy the upper 3 packed elements from `a` to the upper elements of the intrinsic result.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_round_pd","","Round the packed double-precision (64-bit) floating-point elements in `a` using the `rounding` parameter, and store the results as packed double-precision floating-point elements. Rounding is done according to the rounding parameter, which can be one of:",null,{"i":[{"n":"__m128d"},{"n":"i32"}],"o":{"n":"__m128d"}}],[5,"_mm_round_ps","","Round the packed single-precision (32-bit) floating-point elements in `a` using the `rounding` parameter, and store the results as packed single-precision floating-point elements. Rounding is done according to the rounding parameter, which can be one of:",null,{"i":[{"n":"__m128"},{"n":"i32"}],"o":{"n":"__m128"}}],[5,"_mm_round_sd","","Round the lower double-precision (64-bit) floating-point element in `b` using the `rounding` parameter, store the result as a double-precision floating-point element in the lower element of the intrinsic result, and copy the upper element from `a` to the upper element of the intrinsic result. Rounding is done according to the rounding parameter, which can be one of:",null,{"i":[{"n":"__m128d"},{"n":"__m128d"},{"n":"i32"}],"o":{"n":"__m128d"}}],[5,"_mm_round_ss","","Round the lower single-precision (32-bit) floating-point element in `b` using the `rounding` parameter, store the result as a single-precision floating-point element in the lower element of the intrinsic result, and copy the upper 3 packed elements from `a` to the upper elements of the instrinsic result. Rounding is done according to the rounding parameter, which can be one of:",null,{"i":[{"n":"__m128"},{"n":"__m128"},{"n":"i32"}],"o":{"n":"__m128"}}],[5,"_mm_minpos_epu16","","Finds the minimum unsigned 16-bit element in the 128-bit __m128i vector, returning a vector containing its value in its first position, and its index in its second position; all other elements are set to zero.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_mul_epi32","","Multiply the low 32-bit integers from each packed 64-bit element in `a` and `b`, and return the signed 64-bit result.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_mullo_epi32","","Multiply the packed 32-bit integers in `a` and `b`, producing intermediate 64-bit integers, and returns the lowest 32-bit, whatever they might be, reinterpreted as a signed integer. While `pmulld __m128i::splat(2), __m128i::splat(2)` returns the obvious `__m128i::splat(4)`, due to wrapping arithmetic `pmulld __m128i::splat(i32::MAX), __m128i::splat(2)` would return a negative number.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_mpsadbw_epu8","","Subtracts 8-bit unsigned integer values and computes the absolute values of the differences to the corresponding bits in the destination. Then sums of the absolute differences are returned according to the bit fields in the immediate operand.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_testz_si128","","Tests whether the specified bits in a 128-bit integer vector are all zeros.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"i32"}}],[5,"_mm_testc_si128","","Tests whether the specified bits in a 128-bit integer vector are all ones.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"i32"}}],[5,"_mm_testnzc_si128","","Tests whether the specified bits in a 128-bit integer vector are neither all zeros nor all ones.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"i32"}}],[5,"_mm_test_all_zeros","","Tests whether the specified bits in a 128-bit integer vector are all zeros.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"i32"}}],[5,"_mm_test_all_ones","","Tests whether the specified bits in `a` 128-bit integer vector are all ones.",null,{"i":[{"n":"__m128i"}],"o":{"n":"i32"}}],[5,"_mm_test_mix_ones_zeros","","Tests whether the specified bits in a 128-bit integer vector are neither all zeros nor all ones.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"i32"}}],[5,"_mm_cmpistrm","","Compare packed strings with implicit lengths in `a` and `b` using the control in `imm8`, and return the generated mask.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_cmpistri","","Compare packed strings with implicit lengths in `a` and `b` using the control in `imm8` and return the generated index. Similar to [`_mm_cmpestri`] with the exception that [`_mm_cmpestri`] requires the lengths of `a` and `b` to be explicitly specified.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"},{"n":"i32"}],"o":{"n":"i32"}}],[5,"_mm_cmpistrz","","Compare packed strings with implicit lengths in `a` and `b` using the control in `imm8`, and return `1` if any character in `b` was null. and `0` otherwise.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"},{"n":"i32"}],"o":{"n":"i32"}}],[5,"_mm_cmpistrc","","Compare packed strings with implicit lengths in `a` and `b` using the control in `imm8`, and return `1` if the resulting mask was non-zero, and `0` otherwise.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"},{"n":"i32"}],"o":{"n":"i32"}}],[5,"_mm_cmpistrs","","Compare packed strings with implicit lengths in `a` and `b` using the control in `imm8`, and returns `1` if any character in `a` was null, and `0` otherwise.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"},{"n":"i32"}],"o":{"n":"i32"}}],[5,"_mm_cmpistro","","Compare packed strings with implicit lengths in `a` and `b` using the control in `imm8`, and return bit `0` of the resulting bit mask.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"},{"n":"i32"}],"o":{"n":"i32"}}],[5,"_mm_cmpistra","","Compare packed strings with implicit lengths in `a` and `b` using the control in `imm8`, and return `1` if `b` did not contain a null character and the resulting mask was zero, and `0` otherwise.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"},{"n":"i32"}],"o":{"n":"i32"}}],[5,"_mm_cmpestrm","","Compare packed strings in `a` and `b` with lengths `la` and `lb` using the control in `imm8`, and return the generated mask.",null,{"i":[{"n":"__m128i"},{"n":"i32"},{"n":"__m128i"},{"n":"i32"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_cmpestri","","Compare packed strings `a` and `b` with lengths `la` and `lb` using the control in `imm8` and return the generated index. Similar to [`_mm_cmpistri`] with the exception that [`_mm_cmpistri`] implicitly determines the length of `a` and `b`.",null,{"i":[{"n":"__m128i"},{"n":"i32"},{"n":"__m128i"},{"n":"i32"},{"n":"i32"}],"o":{"n":"i32"}}],[5,"_mm_cmpestrz","","Compare packed strings in `a` and `b` with lengths `la` and `lb` using the control in `imm8`, and return `1` if any character in `b` was null, and `0` otherwise.",null,{"i":[{"n":"__m128i"},{"n":"i32"},{"n":"__m128i"},{"n":"i32"},{"n":"i32"}],"o":{"n":"i32"}}],[5,"_mm_cmpestrc","","Compare packed strings in `a` and `b` with lengths `la` and `lb` using the control in `imm8`, and return `1` if the resulting mask was non-zero, and `0` otherwise.",null,{"i":[{"n":"__m128i"},{"n":"i32"},{"n":"__m128i"},{"n":"i32"},{"n":"i32"}],"o":{"n":"i32"}}],[5,"_mm_cmpestrs","","Compare packed strings in `a` and `b` with lengths `la` and `lb` using the control in `imm8`, and return `1` if any character in a was null, and `0` otherwise.",null,{"i":[{"n":"__m128i"},{"n":"i32"},{"n":"__m128i"},{"n":"i32"},{"n":"i32"}],"o":{"n":"i32"}}],[5,"_mm_cmpestro","","Compare packed strings in `a` and `b` with lengths `la` and `lb` using the control in `imm8`, and return bit `0` of the resulting bit mask.",null,{"i":[{"n":"__m128i"},{"n":"i32"},{"n":"__m128i"},{"n":"i32"},{"n":"i32"}],"o":{"n":"i32"}}],[5,"_mm_cmpestra","","Compare packed strings in `a` and `b` with lengths `la` and `lb` using the control in `imm8`, and return `1` if `b` did not contain a null character and the resulting mask was zero, and `0` otherwise.",null,{"i":[{"n":"__m128i"},{"n":"i32"},{"n":"__m128i"},{"n":"i32"},{"n":"i32"}],"o":{"n":"i32"}}],[5,"_mm_crc32_u8","","Starting with the initial value in `crc`, return the accumulated CRC32 value for unsigned 8-bit integer `v`.",null,{"i":[{"n":"u32"},{"n":"u8"}],"o":{"n":"u32"}}],[5,"_mm_crc32_u16","","Starting with the initial value in `crc`, return the accumulated CRC32 value for unsigned 16-bit integer `v`.",null,{"i":[{"n":"u32"},{"n":"u16"}],"o":{"n":"u32"}}],[5,"_mm_crc32_u32","","Starting with the initial value in `crc`, return the accumulated CRC32 value for unsigned 32-bit integer `v`.",null,{"i":[{"n":"u32"},{"n":"u32"}],"o":{"n":"u32"}}],[5,"_mm_cmpgt_epi64","","Compare packed 64-bit integers in `a` and `b` for greater-than, return the results.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm256_add_pd","","Add packed double-precision (64-bit) floating-point elements in `a` and `b`.",null,{"i":[{"n":"__m256d"},{"n":"__m256d"}],"o":{"n":"__m256d"}}],[5,"_mm256_add_ps","","Add packed single-precision (32-bit) floating-point elements in `a` and `b`.",null,{"i":[{"n":"__m256"},{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm256_and_pd","","Compute the bitwise AND of a packed double-precision (64-bit) floating-point elements in `a` and `b`.",null,{"i":[{"n":"__m256d"},{"n":"__m256d"}],"o":{"n":"__m256d"}}],[5,"_mm256_and_ps","","Compute the bitwise AND of packed single-precision (32-bit) floating-point elements in `a` and `b`.",null,{"i":[{"n":"__m256"},{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm256_or_pd","","Compute the bitwise OR packed double-precision (64-bit) floating-point elements in `a` and `b`.",null,{"i":[{"n":"__m256d"},{"n":"__m256d"}],"o":{"n":"__m256d"}}],[5,"_mm256_or_ps","","Compute the bitwise OR packed single-precision (32-bit) floating-point elements in `a` and `b`.",null,{"i":[{"n":"__m256"},{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm256_shuffle_pd","","Shuffle double-precision (64-bit) floating-point elements within 128-bit lanes using the control in `imm8`.",null,{"i":[{"n":"__m256d"},{"n":"__m256d"},{"n":"i32"}],"o":{"n":"__m256d"}}],[5,"_mm256_shuffle_ps","","Shuffle single-precision (32-bit) floating-point elements in `a` within 128-bit lanes using the control in `imm8`.",null,{"i":[{"n":"__m256"},{"n":"__m256"},{"n":"i32"}],"o":{"n":"__m256"}}],[5,"_mm256_andnot_pd","","Compute the bitwise NOT of packed double-precision (64-bit) floating-point elements in `a` and then AND with `b`.",null,{"i":[{"n":"__m256d"},{"n":"__m256d"}],"o":{"n":"__m256d"}}],[5,"_mm256_andnot_ps","","Compute the bitwise NOT of packed single-precision (32-bit) floating-point elements in `a` and then AND with `b`.",null,{"i":[{"n":"__m256"},{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm256_max_pd","","Compare packed double-precision (64-bit) floating-point elements in `a` and `b`, and return packed maximum values",null,{"i":[{"n":"__m256d"},{"n":"__m256d"}],"o":{"n":"__m256d"}}],[5,"_mm256_max_ps","","Compare packed single-precision (32-bit) floating-point elements in `a` and `b`, and return packed maximum values",null,{"i":[{"n":"__m256"},{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm256_min_pd","","Compare packed double-precision (64-bit) floating-point elements in `a` and `b`, and return packed minimum values",null,{"i":[{"n":"__m256d"},{"n":"__m256d"}],"o":{"n":"__m256d"}}],[5,"_mm256_min_ps","","Compare packed single-precision (32-bit) floating-point elements in `a` and `b`, and return packed minimum values",null,{"i":[{"n":"__m256"},{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm256_mul_pd","","Add packed double-precision (64-bit) floating-point elements in `a` and `b`.",null,{"i":[{"n":"__m256d"},{"n":"__m256d"}],"o":{"n":"__m256d"}}],[5,"_mm256_mul_ps","","Add packed single-precision (32-bit) floating-point elements in `a` and `b`.",null,{"i":[{"n":"__m256"},{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm256_addsub_pd","","Alternatively add and subtract packed double-precision (64-bit) floating-point elements in `a` to/from packed elements in `b`.",null,{"i":[{"n":"__m256d"},{"n":"__m256d"}],"o":{"n":"__m256d"}}],[5,"_mm256_addsub_ps","","Alternatively add and subtract packed single-precision (32-bit) floating-point elements in `a` to/from packed elements in `b`.",null,{"i":[{"n":"__m256"},{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm256_sub_pd","","Subtract packed double-precision (64-bit) floating-point elements in `b` from packed elements in `a`.",null,{"i":[{"n":"__m256d"},{"n":"__m256d"}],"o":{"n":"__m256d"}}],[5,"_mm256_sub_ps","","Subtract packed single-precision (32-bit) floating-point elements in `b` from packed elements in `a`.",null,{"i":[{"n":"__m256"},{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm256_div_ps","","Compute the division of each of the 8 packed 32-bit floating-point elements in `a` by the corresponding packed elements in `b`.",null,{"i":[{"n":"__m256"},{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm256_div_pd","","Compute the division of each of the 4 packed 64-bit floating-point elements in `a` by the corresponding packed elements in `b`.",null,{"i":[{"n":"__m256d"},{"n":"__m256d"}],"o":{"n":"__m256d"}}],[5,"_mm256_round_pd","","Round packed double-precision (64-bit) floating point elements in `a` according to the flag `b`. The value of `b` may be as follows:",null,{"i":[{"n":"__m256d"},{"n":"i32"}],"o":{"n":"__m256d"}}],[5,"_mm256_ceil_pd","","Round packed double-precision (64-bit) floating point elements in `a` toward positive infinity.",null,{"i":[{"n":"__m256d"}],"o":{"n":"__m256d"}}],[5,"_mm256_floor_pd","","Round packed double-precision (64-bit) floating point elements in `a` toward negative infinity.",null,{"i":[{"n":"__m256d"}],"o":{"n":"__m256d"}}],[5,"_mm256_round_ps","","Round packed single-precision (32-bit) floating point elements in `a` according to the flag `b`. The value of `b` may be as follows:",null,{"i":[{"n":"__m256"},{"n":"i32"}],"o":{"n":"__m256"}}],[5,"_mm256_ceil_ps","","Round packed single-precision (32-bit) floating point elements in `a` toward positive infinity.",null,{"i":[{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm256_floor_ps","","Round packed single-precision (32-bit) floating point elements in `a` toward negative infinity.",null,{"i":[{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm256_sqrt_ps","","Return the square root of packed single-precision (32-bit) floating point elements in `a`.",null,{"i":[{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm256_sqrt_pd","","Return the square root of packed double-precision (64-bit) floating point elements in `a`.",null,{"i":[{"n":"__m256d"}],"o":{"n":"__m256d"}}],[5,"_mm256_blend_pd","","Blend packed double-precision (64-bit) floating-point elements from `a` and `b` using control mask `imm8`.",null,{"i":[{"n":"__m256d"},{"n":"__m256d"},{"n":"i32"}],"o":{"n":"__m256d"}}],[5,"_mm256_blend_ps","","Blend packed single-precision (32-bit) floating-point elements from `a` and `b` using control mask `imm8`.",null,{"i":[{"n":"__m256"},{"n":"__m256"},{"n":"i32"}],"o":{"n":"__m256"}}],[5,"_mm256_blendv_pd","","Blend packed double-precision (64-bit) floating-point elements from `a` and `b` using `c` as a mask.",null,{"i":[{"n":"__m256d"},{"n":"__m256d"},{"n":"__m256d"}],"o":{"n":"__m256d"}}],[5,"_mm256_blendv_ps","","Blend packed single-precision (32-bit) floating-point elements from `a` and `b` using `c` as a mask.",null,{"i":[{"n":"__m256"},{"n":"__m256"},{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm256_dp_ps","","Conditionally multiply the packed single-precision (32-bit) floating-point elements in `a` and `b` using the high 4 bits in `imm8`, sum the four products, and conditionally return the sum  using the low 4 bits of `imm8`.",null,{"i":[{"n":"__m256"},{"n":"__m256"},{"n":"i32"}],"o":{"n":"__m256"}}],[5,"_mm256_hadd_pd","","Horizontal addition of adjacent pairs in the two packed vectors of 4 64-bit floating points `a` and `b`. In the result, sums of elements from `a` are returned in even locations, while sums of elements from `b` are returned in odd locations.",null,{"i":[{"n":"__m256d"},{"n":"__m256d"}],"o":{"n":"__m256d"}}],[5,"_mm256_hadd_ps","","Horizontal addition of adjacent pairs in the two packed vectors of 8 32-bit floating points `a` and `b`. In the result, sums of elements from `a` are returned in locations of indices 0, 1, 4, 5; while sums of elements from `b` are locations 2, 3, 6, 7.",null,{"i":[{"n":"__m256"},{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm256_hsub_pd","","Horizontal subtraction of adjacent pairs in the two packed vectors of 4 64-bit floating points `a` and `b`. In the result, sums of elements from `a` are returned in even locations, while sums of elements from `b` are returned in odd locations.",null,{"i":[{"n":"__m256d"},{"n":"__m256d"}],"o":{"n":"__m256d"}}],[5,"_mm256_hsub_ps","","Horizontal subtraction of adjacent pairs in the two packed vectors of 8 32-bit floating points `a` and `b`. In the result, sums of elements from `a` are returned in locations of indices 0, 1, 4, 5; while sums of elements from `b` are locations 2, 3, 6, 7.",null,{"i":[{"n":"__m256"},{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm256_xor_pd","","Compute the bitwise XOR of packed double-precision (64-bit) floating-point elements in `a` and `b`.",null,{"i":[{"n":"__m256d"},{"n":"__m256d"}],"o":{"n":"__m256d"}}],[5,"_mm256_xor_ps","","Compute the bitwise XOR of packed single-precision (32-bit) floating-point elements in `a` and `b`.",null,{"i":[{"n":"__m256"},{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm_cmp_pd","","Compare packed double-precision (64-bit) floating-point elements in `a` and `b` based on the comparison operand specified by `imm8`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"},{"n":"i32"}],"o":{"n":"__m128d"}}],[5,"_mm256_cmp_pd","","Compare packed double-precision (64-bit) floating-point elements in `a` and `b` based on the comparison operand specified by `imm8`.",null,{"i":[{"n":"__m256d"},{"n":"__m256d"},{"n":"i32"}],"o":{"n":"__m256d"}}],[5,"_mm_cmp_ps","","Compare packed single-precision (32-bit) floating-point elements in `a` and `b` based on the comparison operand specified by `imm8`.",null,{"i":[{"n":"__m128"},{"n":"__m128"},{"n":"i32"}],"o":{"n":"__m128"}}],[5,"_mm256_cmp_ps","","Compare packed single-precision (32-bit) floating-point elements in `a` and `b` based on the comparison operand specified by `imm8`.",null,{"i":[{"n":"__m256"},{"n":"__m256"},{"n":"i32"}],"o":{"n":"__m256"}}],[5,"_mm_cmp_sd","","Compare the lower double-precision (64-bit) floating-point element in `a` and `b` based on the comparison operand specified by `imm8`, store the result in the lower element of returned vector, and copy the upper element from `a` to the upper element of returned vector.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"},{"n":"i32"}],"o":{"n":"__m128d"}}],[5,"_mm_cmp_ss","","Compare the lower single-precision (32-bit) floating-point element in `a` and `b` based on the comparison operand specified by `imm8`, store the result in the lower element of returned vector, and copy the upper 3 packed elements from `a` to the upper elements of returned vector.",null,{"i":[{"n":"__m128"},{"n":"__m128"},{"n":"i32"}],"o":{"n":"__m128"}}],[5,"_mm256_cvtepi32_pd","","Convert packed 32-bit integers in `a` to packed double-precision (64-bit) floating-point elements.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m256d"}}],[5,"_mm256_cvtepi32_ps","","Convert packed 32-bit integers in `a` to packed single-precision (32-bit) floating-point elements.",null,{"i":[{"n":"__m256i"}],"o":{"n":"__m256"}}],[5,"_mm256_cvtpd_ps","","Convert packed double-precision (64-bit) floating-point elements in `a` to packed single-precision (32-bit) floating-point elements.",null,{"i":[{"n":"__m256d"}],"o":{"n":"__m128"}}],[5,"_mm256_cvtps_epi32","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers.",null,{"i":[{"n":"__m256"}],"o":{"n":"__m256i"}}],[5,"_mm256_cvtps_pd","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed double-precision (64-bit) floating-point elements.",null,{"i":[{"n":"__m128"}],"o":{"n":"__m256d"}}],[5,"_mm256_cvttpd_epi32","","Convert packed double-precision (64-bit) floating-point elements in `a` to packed 32-bit integers with truncation.",null,{"i":[{"n":"__m256d"}],"o":{"n":"__m128i"}}],[5,"_mm256_cvtpd_epi32","","Convert packed double-precision (64-bit) floating-point elements in `a` to packed 32-bit integers.",null,{"i":[{"n":"__m256d"}],"o":{"n":"__m128i"}}],[5,"_mm256_cvttps_epi32","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers with truncation.",null,{"i":[{"n":"__m256"}],"o":{"n":"__m256i"}}],[5,"_mm256_extractf128_ps","","Extract 128 bits (composed of 4 packed single-precision (32-bit) floating-point elements) from `a`, selected with `imm8`.",null,{"i":[{"n":"__m256"},{"n":"i32"}],"o":{"n":"__m128"}}],[5,"_mm256_extractf128_pd","","Extract 128 bits (composed of 2 packed double-precision (64-bit) floating-point elements) from `a`, selected with `imm8`.",null,{"i":[{"n":"__m256d"},{"n":"i32"}],"o":{"n":"__m128d"}}],[5,"_mm256_extractf128_si256","","Extract 128 bits (composed of integer data) from `a`, selected with `imm8`.",null,{"i":[{"n":"__m256i"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm256_zeroall","","Zero the contents of all XMM or YMM registers.",null,{}],[5,"_mm256_zeroupper","","Zero the upper 128 bits of all YMM registers; the lower 128-bits of the registers are unmodified.",null,{}],[5,"_mm256_permutevar_ps","","Shuffle single-precision (32-bit) floating-point elements in `a` within 128-bit lanes using the control in `b`.",null,{"i":[{"n":"__m256"},{"n":"__m256i"}],"o":{"n":"__m256"}}],[5,"_mm_permutevar_ps","","Shuffle single-precision (32-bit) floating-point elements in `a` using the control in `b`.",null,{"i":[{"n":"__m128"},{"n":"__m128i"}],"o":{"n":"__m128"}}],[5,"_mm256_permute_ps","","Shuffle single-precision (32-bit) floating-point elements in `a` within 128-bit lanes using the control in `imm8`.",null,{"i":[{"n":"__m256"},{"n":"i32"}],"o":{"n":"__m256"}}],[5,"_mm_permute_ps","","Shuffle single-precision (32-bit) floating-point elements in `a` using the control in `imm8`.",null,{"i":[{"n":"__m128"},{"n":"i32"}],"o":{"n":"__m128"}}],[5,"_mm256_permutevar_pd","","Shuffle double-precision (64-bit) floating-point elements in `a` within 256-bit lanes using the control in `b`.",null,{"i":[{"n":"__m256d"},{"n":"__m256i"}],"o":{"n":"__m256d"}}],[5,"_mm_permutevar_pd","","Shuffle double-precision (64-bit) floating-point elements in `a` using the control in `b`.",null,{"i":[{"n":"__m128d"},{"n":"__m128i"}],"o":{"n":"__m128d"}}],[5,"_mm256_permute_pd","","Shuffle double-precision (64-bit) floating-point elements in `a` within 128-bit lanes using the control in `imm8`.",null,{"i":[{"n":"__m256d"},{"n":"i32"}],"o":{"n":"__m256d"}}],[5,"_mm_permute_pd","","Shuffle double-precision (64-bit) floating-point elements in `a` using the control in `imm8`.",null,{"i":[{"n":"__m128d"},{"n":"i32"}],"o":{"n":"__m128d"}}],[5,"_mm256_permute2f128_ps","","Shuffle 256-bits (composed of 8 packed single-precision (32-bit) floating-point elements) selected by `imm8` from `a` and `b`.",null,{"i":[{"n":"__m256"},{"n":"__m256"},{"n":"i32"}],"o":{"n":"__m256"}}],[5,"_mm256_permute2f128_pd","","Shuffle 256-bits (composed of 4 packed double-precision (64-bit) floating-point elements) selected by `imm8` from `a` and `b`.",null,{"i":[{"n":"__m256d"},{"n":"__m256d"},{"n":"i32"}],"o":{"n":"__m256d"}}],[5,"_mm256_permute2f128_si256","","Shuffle 258-bits (composed of integer data) selected by `imm8` from `a` and `b`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm256_broadcast_ss","","Broadcast a single-precision (32-bit) floating-point element from memory to all elements of the returned vector.",null,{"i":[{"n":"f32"}],"o":{"n":"__m256"}}],[5,"_mm_broadcast_ss","","Broadcast a single-precision (32-bit) floating-point element from memory to all elements of the returned vector.",null,{"i":[{"n":"f32"}],"o":{"n":"__m128"}}],[5,"_mm256_broadcast_sd","","Broadcast a double-precision (64-bit) floating-point element from memory to all elements of the returned vector.",null,{"i":[{"n":"f64"}],"o":{"n":"__m256d"}}],[5,"_mm256_broadcast_ps","","Broadcast 128 bits from memory (composed of 4 packed single-precision (32-bit) floating-point elements) to all elements of the returned vector.",null,{"i":[{"n":"__m128"}],"o":{"n":"__m256"}}],[5,"_mm256_broadcast_pd","","Broadcast 128 bits from memory (composed of 2 packed double-precision (64-bit) floating-point elements) to all elements of the returned vector.",null,{"i":[{"n":"__m128d"}],"o":{"n":"__m256d"}}],[5,"_mm256_insertf128_ps","","Copy `a` to result, then insert 128 bits (composed of 4 packed single-precision (32-bit) floating-point elements) from `b` into result at the location specified by `imm8`.",null,{"i":[{"n":"__m256"},{"n":"__m128"},{"n":"i32"}],"o":{"n":"__m256"}}],[5,"_mm256_insertf128_pd","","Copy `a` to result, then insert 128 bits (composed of 2 packed double-precision (64-bit) floating-point elements) from `b` into result at the location specified by `imm8`.",null,{"i":[{"n":"__m256d"},{"n":"__m128d"},{"n":"i32"}],"o":{"n":"__m256d"}}],[5,"_mm256_insertf128_si256","","Copy `a` to result, then insert 128 bits from `b` into result at the location specified by `imm8`.",null,{"i":[{"n":"__m256i"},{"n":"__m128i"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm256_insert_epi8","","Copy `a` to result, and insert the 8-bit integer `i` into result at the location specified by `index`.",null,{"i":[{"n":"__m256i"},{"n":"i8"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm256_insert_epi16","","Copy `a` to result, and insert the 16-bit integer `i` into result at the location specified by `index`.",null,{"i":[{"n":"__m256i"},{"n":"i16"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm256_insert_epi32","","Copy `a` to result, and insert the 32-bit integer `i` into result at the location specified by `index`.",null,{"i":[{"n":"__m256i"},{"n":"i32"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm256_load_pd","","Load 256-bits (composed of 4 packed double-precision (64-bit) floating-point elements) from memory into result. `mem_addr` must be aligned on a 32-byte boundary or a general-protection exception may be generated.",null,null],[5,"_mm256_store_pd","","Store 256-bits (composed of 4 packed double-precision (64-bit) floating-point elements) from `a` into memory. `mem_addr` must be aligned on a 32-byte boundary or a general-protection exception may be generated.",null,null],[5,"_mm256_load_ps","","Load 256-bits (composed of 8 packed single-precision (32-bit) floating-point elements) from memory into result. `mem_addr` must be aligned on a 32-byte boundary or a general-protection exception may be generated.",null,null],[5,"_mm256_store_ps","","Store 256-bits (composed of 8 packed single-precision (32-bit) floating-point elements) from `a` into memory. `mem_addr` must be aligned on a 32-byte boundary or a general-protection exception may be generated.",null,null],[5,"_mm256_loadu_pd","","Load 256-bits (composed of 4 packed double-precision (64-bit) floating-point elements) from memory into result. `mem_addr` does not need to be aligned on any particular boundary.",null,null],[5,"_mm256_storeu_pd","","Store 256-bits (composed of 4 packed double-precision (64-bit) floating-point elements) from `a` into memory. `mem_addr` does not need to be aligned on any particular boundary.",null,null],[5,"_mm256_loadu_ps","","Load 256-bits (composed of 8 packed single-precision (32-bit) floating-point elements) from memory into result. `mem_addr` does not need to be aligned on any particular boundary.",null,null],[5,"_mm256_storeu_ps","","Store 256-bits (composed of 8 packed single-precision (32-bit) floating-point elements) from `a` into memory. `mem_addr` does not need to be aligned on any particular boundary.",null,null],[5,"_mm256_load_si256","","Load 256-bits of integer data from memory into result. `mem_addr` must be aligned on a 32-byte boundary or a general-protection exception may be generated.",null,null],[5,"_mm256_store_si256","","Store 256-bits of integer data from `a` into memory. `mem_addr` must be aligned on a 32-byte boundary or a general-protection exception may be generated.",null,null],[5,"_mm256_loadu_si256","","Load 256-bits of integer data from memory into result. `mem_addr` does not need to be aligned on any particular boundary.",null,null],[5,"_mm256_storeu_si256","","Store 256-bits of integer data from `a` into memory.    `mem_addr` does not need to be aligned on any particular boundary.",null,null],[5,"_mm256_maskload_pd","","Load packed double-precision (64-bit) floating-point elements from memory into result using `mask` (elements are zeroed out when the high bit of the corresponding element is not set).",null,null],[5,"_mm256_maskstore_pd","","Store packed double-precision (64-bit) floating-point elements from `a` into memory using `mask`.",null,null],[5,"_mm_maskload_pd","","Load packed double-precision (64-bit) floating-point elements from memory into result using `mask` (elements are zeroed out when the high bit of the corresponding element is not set).",null,null],[5,"_mm_maskstore_pd","","Store packed double-precision (64-bit) floating-point elements from `a` into memory using `mask`.",null,null],[5,"_mm256_maskload_ps","","Load packed single-precision (32-bit) floating-point elements from memory into result using `mask` (elements are zeroed out when the high bit of the corresponding element is not set).",null,null],[5,"_mm256_maskstore_ps","","Store packed single-precision (32-bit) floating-point elements from `a` into memory using `mask`.",null,null],[5,"_mm_maskload_ps","","Load packed single-precision (32-bit) floating-point elements from memory into result using `mask` (elements are zeroed out when the high bit of the corresponding element is not set).",null,null],[5,"_mm_maskstore_ps","","Store packed single-precision (32-bit) floating-point elements from `a` into memory using `mask`.",null,null],[5,"_mm256_movehdup_ps","","Duplicate odd-indexed single-precision (32-bit) floating-point elements from `a`, and return the results.",null,{"i":[{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm256_moveldup_ps","","Duplicate even-indexed single-precision (32-bit) floating-point elements from `a`, and return the results.",null,{"i":[{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm256_movedup_pd","","Duplicate even-indexed double-precision (64-bit) floating-point elements from \"a\", and return the results.",null,{"i":[{"n":"__m256d"}],"o":{"n":"__m256d"}}],[5,"_mm256_lddqu_si256","","Load 256-bits of integer data from unaligned memory into result. This intrinsic may perform better than `_mm256_loadu_si256` when the data crosses a cache line boundary.",null,null],[5,"_mm256_stream_si256","","Moves integer data from a 256-bit integer vector to a 32-byte aligned memory location. To minimize caching, the data is flagged as non-temporal (unlikely to be used again soon)",null,null],[5,"_mm256_stream_pd","","Moves double-precision values from a 256-bit vector of `[4 x double]` to a 32-byte aligned memory location. To minimize caching, the data is flagged as non-temporal (unlikely to be used again soon).",null,null],[5,"_mm256_stream_ps","","Moves single-precision floating point values from a 256-bit vector of `[8 x float]` to a 32-byte aligned memory location. To minimize caching, the data is flagged as non-temporal (unlikely to be used again soon).",null,null],[5,"_mm256_rcp_ps","","Compute the approximate reciprocal of packed single-precision (32-bit) floating-point elements in `a`, and return the results. The maximum relative error for this approximation is less than 1.5*2^-12.",null,{"i":[{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm256_rsqrt_ps","","Compute the approximate reciprocal square root of packed single-precision (32-bit) floating-point elements in `a`, and return the results. The maximum relative error for this approximation is less than 1.5*2^-12.",null,{"i":[{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm256_unpackhi_pd","","Unpack and interleave double-precision (64-bit) floating-point elements from the high half of each 128-bit lane in `a` and `b`.",null,{"i":[{"n":"__m256d"},{"n":"__m256d"}],"o":{"n":"__m256d"}}],[5,"_mm256_unpackhi_ps","","Unpack and interleave single-precision (32-bit) floating-point elements from the high half of each 128-bit lane in `a` and `b`.",null,{"i":[{"n":"__m256"},{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm256_unpacklo_pd","","Unpack and interleave double-precision (64-bit) floating-point elements from the low half of each 128-bit lane in `a` and `b`.",null,{"i":[{"n":"__m256d"},{"n":"__m256d"}],"o":{"n":"__m256d"}}],[5,"_mm256_unpacklo_ps","","Unpack and interleave single-precision (32-bit) floating-point elements from the low half of each 128-bit lane in `a` and `b`.",null,{"i":[{"n":"__m256"},{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm256_testz_si256","","Compute the bitwise AND of 256 bits (representing integer data) in `a` and `b`, and set `ZF` to 1 if the result is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, and set `CF` to 1 if the result is zero, otherwise set `CF` to 0. Return the `ZF` value.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"i32"}}],[5,"_mm256_testc_si256","","Compute the bitwise AND of 256 bits (representing integer data) in `a` and `b`, and set `ZF` to 1 if the result is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, and set `CF` to 1 if the result is zero, otherwise set `CF` to 0. Return the `CF` value.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"i32"}}],[5,"_mm256_testnzc_si256","","Compute the bitwise AND of 256 bits (representing integer data) in `a` and `b`, and set `ZF` to 1 if the result is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, and set `CF` to 1 if the result is zero, otherwise set `CF` to 0. Return 1 if both the `ZF` and `CF` values are zero, otherwise return 0.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"i32"}}],[5,"_mm256_testz_pd","","Compute the bitwise AND of 256 bits (representing double-precision (64-bit) floating-point elements) in `a` and `b`, producing an intermediate 256-bit value, and set `ZF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `ZF` value.",null,{"i":[{"n":"__m256d"},{"n":"__m256d"}],"o":{"n":"i32"}}],[5,"_mm256_testc_pd","","Compute the bitwise AND of 256 bits (representing double-precision (64-bit) floating-point elements) in `a` and `b`, producing an intermediate 256-bit value, and set `ZF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `CF` value.",null,{"i":[{"n":"__m256d"},{"n":"__m256d"}],"o":{"n":"i32"}}],[5,"_mm256_testnzc_pd","","Compute the bitwise AND of 256 bits (representing double-precision (64-bit) floating-point elements) in `a` and `b`, producing an intermediate 256-bit value, and set `ZF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return 1 if both the `ZF` and `CF` values are zero, otherwise return 0.",null,{"i":[{"n":"__m256d"},{"n":"__m256d"}],"o":{"n":"i32"}}],[5,"_mm_testz_pd","","Compute the bitwise AND of 128 bits (representing double-precision (64-bit) floating-point elements) in `a` and `b`, producing an intermediate 128-bit value, and set `ZF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `ZF` value.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"i32"}}],[5,"_mm_testc_pd","","Compute the bitwise AND of 128 bits (representing double-precision (64-bit) floating-point elements) in `a` and `b`, producing an intermediate 128-bit value, and set `ZF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `CF` value.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"i32"}}],[5,"_mm_testnzc_pd","","Compute the bitwise AND of 128 bits (representing double-precision (64-bit) floating-point elements) in `a` and `b`, producing an intermediate 128-bit value, and set `ZF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return 1 if both the `ZF` and `CF` values are zero, otherwise return 0.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"i32"}}],[5,"_mm256_testz_ps","","Compute the bitwise AND of 256 bits (representing single-precision (32-bit) floating-point elements) in `a` and `b`, producing an intermediate 256-bit value, and set `ZF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `ZF` value.",null,{"i":[{"n":"__m256"},{"n":"__m256"}],"o":{"n":"i32"}}],[5,"_mm256_testc_ps","","Compute the bitwise AND of 256 bits (representing single-precision (32-bit) floating-point elements) in `a` and `b`, producing an intermediate 256-bit value, and set `ZF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `CF` value.",null,{"i":[{"n":"__m256"},{"n":"__m256"}],"o":{"n":"i32"}}],[5,"_mm256_testnzc_ps","","Compute the bitwise AND of 256 bits (representing single-precision (32-bit) floating-point elements) in `a` and `b`, producing an intermediate 256-bit value, and set `ZF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return 1 if both the `ZF` and `CF` values are zero, otherwise return 0.",null,{"i":[{"n":"__m256"},{"n":"__m256"}],"o":{"n":"i32"}}],[5,"_mm_testz_ps","","Compute the bitwise AND of 128 bits (representing single-precision (32-bit) floating-point elements) in `a` and `b`, producing an intermediate 128-bit value, and set `ZF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `ZF` value.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"i32"}}],[5,"_mm_testc_ps","","Compute the bitwise AND of 128 bits (representing single-precision (32-bit) floating-point elements) in `a` and `b`, producing an intermediate 128-bit value, and set `ZF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `CF` value.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"i32"}}],[5,"_mm_testnzc_ps","","Compute the bitwise AND of 128 bits (representing single-precision (32-bit) floating-point elements) in `a` and `b`, producing an intermediate 128-bit value, and set `ZF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return 1 if both the `ZF` and `CF` values are zero, otherwise return 0.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"i32"}}],[5,"_mm256_movemask_pd","","Set each bit of the returned mask based on the most significant bit of the corresponding packed double-precision (64-bit) floating-point element in `a`.",null,{"i":[{"n":"__m256d"}],"o":{"n":"i32"}}],[5,"_mm256_movemask_ps","","Set each bit of the returned mask based on the most significant bit of the corresponding packed single-precision (32-bit) floating-point element in `a`.",null,{"i":[{"n":"__m256"}],"o":{"n":"i32"}}],[5,"_mm256_setzero_pd","","Return vector of type __m256d with all elements set to zero.",null,{"o":{"n":"__m256d"}}],[5,"_mm256_setzero_ps","","Return vector of type __m256 with all elements set to zero.",null,{"o":{"n":"__m256"}}],[5,"_mm256_setzero_si256","","Return vector of type __m256i with all elements set to zero.",null,{"o":{"n":"__m256i"}}],[5,"_mm256_set_pd","","Set packed double-precision (64-bit) floating-point elements in returned vector with the supplied values.",null,{"i":[{"n":"f64"},{"n":"f64"},{"n":"f64"},{"n":"f64"}],"o":{"n":"__m256d"}}],[5,"_mm256_set_ps","","Set packed single-precision (32-bit) floating-point elements in returned vector with the supplied values.",null,{"i":[{"n":"f32"},{"n":"f32"},{"n":"f32"},{"n":"f32"},{"n":"f32"},{"n":"f32"},{"n":"f32"},{"n":"f32"}],"o":{"n":"__m256"}}],[5,"_mm256_set_epi8","","Set packed 8-bit integers in returned vector with the supplied values in reverse order.",null,{"i":[{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"}],"o":{"n":"__m256i"}}],[5,"_mm256_set_epi16","","Set packed 16-bit integers in returned vector with the supplied values.",null,{"i":[{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"}],"o":{"n":"__m256i"}}],[5,"_mm256_set_epi32","","Set packed 32-bit integers in returned vector with the supplied values.",null,{"i":[{"n":"i32"},{"n":"i32"},{"n":"i32"},{"n":"i32"},{"n":"i32"},{"n":"i32"},{"n":"i32"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm256_set_epi64x","","Set packed 64-bit integers in returned vector with the supplied values.",null,{"i":[{"n":"i64"},{"n":"i64"},{"n":"i64"},{"n":"i64"}],"o":{"n":"__m256i"}}],[5,"_mm256_setr_pd","","Set packed double-precision (64-bit) floating-point elements in returned vector with the supplied values in reverse order.",null,{"i":[{"n":"f64"},{"n":"f64"},{"n":"f64"},{"n":"f64"}],"o":{"n":"__m256d"}}],[5,"_mm256_setr_ps","","Set packed single-precision (32-bit) floating-point elements in returned vector with the supplied values in reverse order.",null,{"i":[{"n":"f32"},{"n":"f32"},{"n":"f32"},{"n":"f32"},{"n":"f32"},{"n":"f32"},{"n":"f32"},{"n":"f32"}],"o":{"n":"__m256"}}],[5,"_mm256_setr_epi8","","Set packed 8-bit integers in returned vector with the supplied values in reverse order.",null,{"i":[{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"}],"o":{"n":"__m256i"}}],[5,"_mm256_setr_epi16","","Set packed 16-bit integers in returned vector with the supplied values in reverse order.",null,{"i":[{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"}],"o":{"n":"__m256i"}}],[5,"_mm256_setr_epi32","","Set packed 32-bit integers in returned vector with the supplied values in reverse order.",null,{"i":[{"n":"i32"},{"n":"i32"},{"n":"i32"},{"n":"i32"},{"n":"i32"},{"n":"i32"},{"n":"i32"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm256_setr_epi64x","","Set packed 64-bit integers in returned vector with the supplied values in reverse order.",null,{"i":[{"n":"i64"},{"n":"i64"},{"n":"i64"},{"n":"i64"}],"o":{"n":"__m256i"}}],[5,"_mm256_set1_pd","","Broadcast double-precision (64-bit) floating-point value `a` to all elements of returned vector.",null,{"i":[{"n":"f64"}],"o":{"n":"__m256d"}}],[5,"_mm256_set1_ps","","Broadcast single-precision (32-bit) floating-point value `a` to all elements of returned vector.",null,{"i":[{"n":"f32"}],"o":{"n":"__m256"}}],[5,"_mm256_set1_epi8","","Broadcast 8-bit integer `a` to all elements of returned vector. This intrinsic may generate the `vpbroadcastb`.",null,{"i":[{"n":"i8"}],"o":{"n":"__m256i"}}],[5,"_mm256_set1_epi16","","Broadcast 16-bit integer `a` to all all elements of returned vector. This intrinsic may generate the `vpbroadcastw`.",null,{"i":[{"n":"i16"}],"o":{"n":"__m256i"}}],[5,"_mm256_set1_epi32","","Broadcast 32-bit integer `a` to all elements of returned vector. This intrinsic may generate the `vpbroadcastd`.",null,{"i":[{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm256_set1_epi64x","","Broadcast 64-bit integer `a` to all elements of returned vector. This intrinsic may generate the `vpbroadcastq`.",null,{"i":[{"n":"i64"}],"o":{"n":"__m256i"}}],[5,"_mm256_castpd_ps","","Cast vector of type __m256d to type __m256.",null,{"i":[{"n":"__m256d"}],"o":{"n":"__m256"}}],[5,"_mm256_castps_pd","","Cast vector of type __m256 to type __m256d.",null,{"i":[{"n":"__m256"}],"o":{"n":"__m256d"}}],[5,"_mm256_castps_si256","","Casts vector of type __m256 to type __m256i.",null,{"i":[{"n":"__m256"}],"o":{"n":"__m256i"}}],[5,"_mm256_castsi256_ps","","Casts vector of type __m256i to type __m256.",null,{"i":[{"n":"__m256i"}],"o":{"n":"__m256"}}],[5,"_mm256_castpd_si256","","Casts vector of type __m256d to type __m256i.",null,{"i":[{"n":"__m256d"}],"o":{"n":"__m256i"}}],[5,"_mm256_castsi256_pd","","Casts vector of type __m256i to type __m256d.",null,{"i":[{"n":"__m256i"}],"o":{"n":"__m256d"}}],[5,"_mm256_castps256_ps128","","Casts vector of type __m256 to type __m128.",null,{"i":[{"n":"__m256"}],"o":{"n":"__m128"}}],[5,"_mm256_castpd256_pd128","","Casts vector of type __m256d to type __m128d.",null,{"i":[{"n":"__m256d"}],"o":{"n":"__m128d"}}],[5,"_mm256_castsi256_si128","","Casts vector of type __m256i to type __m128i.",null,{"i":[{"n":"__m256i"}],"o":{"n":"__m128i"}}],[5,"_mm256_castps128_ps256","","Casts vector of type __m128 to type __m256; the upper 128 bits of the result are undefined.",null,{"i":[{"n":"__m128"}],"o":{"n":"__m256"}}],[5,"_mm256_castpd128_pd256","","Casts vector of type __m128d to type __m256d; the upper 128 bits of the result are undefined.",null,{"i":[{"n":"__m128d"}],"o":{"n":"__m256d"}}],[5,"_mm256_castsi128_si256","","Casts vector of type __m128i to type __m256i; the upper 128 bits of the result are undefined.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm256_zextps128_ps256","","Constructs a 256-bit floating-point vector of `[8 x float]` from a 128-bit floating-point vector of `[4 x float]`. The lower 128 bits contain the value of the source vector. The upper 128 bits are set to zero.",null,{"i":[{"n":"__m128"}],"o":{"n":"__m256"}}],[5,"_mm256_zextsi128_si256","","Constructs a 256-bit integer vector from a 128-bit integer vector. The lower 128 bits contain the value of the source vector. The upper 128 bits are set to zero.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm256_zextpd128_pd256","","Constructs a 256-bit floating-point vector of `[4 x double]` from a 128-bit floating-point vector of `[2 x double]`. The lower 128 bits contain the value of the source vector. The upper 128 bits are set to zero.",null,{"i":[{"n":"__m128d"}],"o":{"n":"__m256d"}}],[5,"_mm256_undefined_ps","","Return vector of type `__m256` with undefined elements.",null,{"o":{"n":"__m256"}}],[5,"_mm256_undefined_pd","","Return vector of type `__m256d` with undefined elements.",null,{"o":{"n":"__m256d"}}],[5,"_mm256_undefined_si256","","Return vector of type __m256i with undefined elements.",null,{"o":{"n":"__m256i"}}],[5,"_mm256_set_m128","","Set packed __m256 returned vector with the supplied values.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m256"}}],[5,"_mm256_set_m128d","","Set packed __m256d returned vector with the supplied values.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m256d"}}],[5,"_mm256_set_m128i","","Set packed __m256i returned vector with the supplied values.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm256_setr_m128","","Set packed __m256 returned vector with the supplied values.",null,{"i":[{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m256"}}],[5,"_mm256_setr_m128d","","Set packed __m256d returned vector with the supplied values.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m256d"}}],[5,"_mm256_setr_m128i","","Set packed __m256i returned vector with the supplied values.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm256_loadu2_m128","","Load two 128-bit values (composed of 4 packed single-precision (32-bit) floating-point elements) from memory, and combine them into a 256-bit value. `hiaddr` and `loaddr` do not need to be aligned on any particular boundary.",null,null],[5,"_mm256_loadu2_m128d","","Load two 128-bit values (composed of 2 packed double-precision (64-bit) floating-point elements) from memory, and combine them into a 256-bit value. `hiaddr` and `loaddr` do not need to be aligned on any particular boundary.",null,null],[5,"_mm256_loadu2_m128i","","Load two 128-bit values (composed of integer data) from memory, and combine them into a 256-bit value. `hiaddr` and `loaddr` do not need to be aligned on any particular boundary.",null,null],[5,"_mm256_storeu2_m128","","Store the high and low 128-bit halves (each composed of 4 packed single-precision (32-bit) floating-point elements) from `a` into memory two different 128-bit locations. `hiaddr` and `loaddr` do not need to be aligned on any particular boundary.",null,null],[5,"_mm256_storeu2_m128d","","Store the high and low 128-bit halves (each composed of 2 packed double-precision (64-bit) floating-point elements) from `a` into memory two different 128-bit locations. `hiaddr` and `loaddr` do not need to be aligned on any particular boundary.",null,null],[5,"_mm256_storeu2_m128i","","Store the high and low 128-bit halves (each composed of integer data) from `a` into memory two different 128-bit locations. `hiaddr` and `loaddr` do not need to be aligned on any particular boundary.",null,null],[5,"_mm256_cvtss_f32","","Returns the first element of the input vector of `[8 x float]`.",null,{"i":[{"n":"__m256"}],"o":{"n":"f32"}}],[5,"_mm256_abs_epi32","","Computes the absolute values of packed 32-bit integers in `a`.",null,{"i":[{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_abs_epi16","","Computes the absolute values of packed 16-bit integers in `a`.",null,{"i":[{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_abs_epi8","","Computes the absolute values of packed 8-bit integers in `a`.",null,{"i":[{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_add_epi64","","Add packed 64-bit integers in `a` and `b`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_add_epi32","","Add packed 32-bit integers in `a` and `b`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_add_epi16","","Add packed 16-bit integers in `a` and `b`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_add_epi8","","Add packed 8-bit integers in `a` and `b`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_adds_epi8","","Add packed 8-bit integers in `a` and `b` using saturation.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_adds_epi16","","Add packed 16-bit integers in `a` and `b` using saturation.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_adds_epu8","","Add packed unsigned 8-bit integers in `a` and `b` using saturation.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_adds_epu16","","Add packed unsigned 16-bit integers in `a` and `b` using saturation.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_alignr_epi8","","Concatenate pairs of 16-byte blocks in `a` and `b` into a 32-byte temporary result, shift the result right by `n` bytes, and return the low 16 bytes.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm256_and_si256","","Compute the bitwise AND of 256 bits (representing integer data) in `a` and `b`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_andnot_si256","","Compute the bitwise NOT of 256 bits (representing integer data) in `a` and then AND with `b`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_avg_epu16","","Average packed unsigned 16-bit integers in `a` and `b`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_avg_epu8","","Average packed unsigned 8-bit integers in `a` and `b`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm_blend_epi32","","Blend packed 32-bit integers from `a` and `b` using control mask `imm8`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm256_blend_epi32","","Blend packed 32-bit integers from `a` and `b` using control mask `imm8`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm256_blend_epi16","","Blend packed 16-bit integers from `a` and `b` using control mask `imm8`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm256_blendv_epi8","","Blend packed 8-bit integers from `a` and `b` using `mask`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm_broadcastb_epi8","","Broadcast the low packed 8-bit integer from `a` to all elements of the 128-bit returned value.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm256_broadcastb_epi8","","Broadcast the low packed 8-bit integer from `a` to all elements of the 256-bit returned value.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm_broadcastd_epi32","","Broadcast the low packed 32-bit integer from `a` to all elements of the 128-bit returned value.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm256_broadcastd_epi32","","Broadcast the low packed 32-bit integer from `a` to all elements of the 256-bit returned value.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm_broadcastq_epi64","","Broadcast the low packed 64-bit integer from `a` to all elements of the 128-bit returned value.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm256_broadcastq_epi64","","Broadcast the low packed 64-bit integer from `a` to all elements of the 256-bit returned value.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm_broadcastsd_pd","","Broadcast the low double-precision (64-bit) floating-point element from `a` to all elements of the 128-bit returned value.",null,{"i":[{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm256_broadcastsd_pd","","Broadcast the low double-precision (64-bit) floating-point element from `a` to all elements of the 256-bit returned value.",null,{"i":[{"n":"__m128d"}],"o":{"n":"__m256d"}}],[5,"_mm256_broadcastsi128_si256","","Broadcast 128 bits of integer data from a to all 128-bit lanes in the 256-bit returned value.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm_broadcastss_ps","","Broadcast the low single-precision (32-bit) floating-point element from `a` to all elements of the 128-bit returned value.",null,{"i":[{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm256_broadcastss_ps","","Broadcast the low single-precision (32-bit) floating-point element from `a` to all elements of the 256-bit returned value.",null,{"i":[{"n":"__m128"}],"o":{"n":"__m256"}}],[5,"_mm_broadcastw_epi16","","Broadcast the low packed 16-bit integer from a to all elements of the 128-bit returned value",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm256_broadcastw_epi16","","Broadcast the low packed 16-bit integer from a to all elements of the 256-bit returned value",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm256_cmpeq_epi64","","Compare packed 64-bit integers in `a` and `b` for equality.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_cmpeq_epi32","","Compare packed 32-bit integers in `a` and `b` for equality.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_cmpeq_epi16","","Compare packed 16-bit integers in `a` and `b` for equality.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_cmpeq_epi8","","Compare packed 8-bit integers in `a` and `b` for equality.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_cmpgt_epi64","","Compare packed 64-bit integers in `a` and `b` for greater-than.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_cmpgt_epi32","","Compare packed 32-bit integers in `a` and `b` for greater-than.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_cmpgt_epi16","","Compare packed 16-bit integers in `a` and `b` for greater-than.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_cmpgt_epi8","","Compare packed 8-bit integers in `a` and `b` for greater-than.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_cvtepi16_epi32","","Sign-extend 16-bit integers to 32-bit integers.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm256_cvtepi16_epi64","","Sign-extend 16-bit integers to 64-bit integers.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm256_cvtepi32_epi64","","Sign-extend 32-bit integers to 64-bit integers.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm256_cvtepi8_epi16","","Sign-extend 8-bit integers to 16-bit integers.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm256_cvtepi8_epi32","","Sign-extend 8-bit integers to 32-bit integers.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm256_cvtepi8_epi64","","Sign-extend 8-bit integers to 64-bit integers.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm256_cvtepu16_epi32","","Zero extend packed unsigned 16-bit integers in `a` to packed 32-bit integers, and store the results in dst.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm256_cvtepu16_epi64","","Zero-extend the lower four unsigned 16-bit integers in `a` to 64-bit integers. The upper four elements of `a` are unused.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm256_cvtepu32_epi64","","Zero-extend unsigned 32-bit integers in `a` to 64-bit integers.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm256_cvtepu8_epi16","","Zero-extend unsigned 8-bit integers in `a` to 16-bit integers.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm256_cvtepu8_epi32","","Zero-extend the lower eight unsigned 8-bit integers in `a` to 32-bit integers. The upper eight elements of `a` are unused.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm256_cvtepu8_epi64","","Zero-extend the lower four unsigned 8-bit integers in `a` to 64-bit integers. The upper twelve elements of `a` are unused.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm256_extracti128_si256","","Extract 128 bits (of integer data) from `a` selected with `imm8`.",null,{"i":[{"n":"__m256i"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm256_hadd_epi16","","Horizontally add adjacent pairs of 16-bit integers in `a` and `b`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_hadd_epi32","","Horizontally add adjacent pairs of 32-bit integers in `a` and `b`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_hadds_epi16","","Horizontally add adjacent pairs of 16-bit integers in `a` and `b` using saturation.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_hsub_epi16","","Horizontally subtract adjacent pairs of 16-bit integers in `a` and `b`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_hsub_epi32","","Horizontally subtract adjacent pairs of 32-bit integers in `a` and `b`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_hsubs_epi16","","Horizontally subtract adjacent pairs of 16-bit integers in `a` and `b` using saturation.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm_i32gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm_mask_i32gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm256_i32gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm256_mask_i32gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm_i32gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm_mask_i32gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm256_i32gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm256_mask_i32gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm_i32gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm_mask_i32gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm256_i32gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm256_mask_i32gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm_i32gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm_mask_i32gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm256_i32gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm256_mask_i32gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm_i64gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm_mask_i64gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm256_i64gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm256_mask_i64gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm_i64gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm_mask_i64gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm256_i64gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm256_mask_i64gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm_i64gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm_mask_i64gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm256_i64gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm256_mask_i64gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm_i64gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm_mask_i64gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm256_i64gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",null,null],[5,"_mm256_mask_i64gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",null,null],[5,"_mm256_inserti128_si256","","Copy `a` to `dst`, then insert 128 bits (of integer data) from `b` at the location specified by `imm8`.",null,{"i":[{"n":"__m256i"},{"n":"__m128i"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm256_madd_epi16","","Multiply packed signed 16-bit integers in `a` and `b`, producing intermediate signed 32-bit integers. Horizontally add adjacent pairs of intermediate 32-bit integers.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_maddubs_epi16","","Vertically multiply each unsigned 8-bit integer from `a` with the corresponding signed 8-bit integer from `b`, producing intermediate signed 16-bit integers. Horizontally add adjacent pairs of intermediate signed 16-bit integers",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm_maskload_epi32","","Load packed 32-bit integers from memory pointed by `mem_addr` using `mask` (elements are zeroed out when the highest bit is not set in the corresponding element).",null,null],[5,"_mm256_maskload_epi32","","Load packed 32-bit integers from memory pointed by `mem_addr` using `mask` (elements are zeroed out when the highest bit is not set in the corresponding element).",null,null],[5,"_mm_maskload_epi64","","Load packed 64-bit integers from memory pointed by `mem_addr` using `mask` (elements are zeroed out when the highest bit is not set in the corresponding element).",null,null],[5,"_mm256_maskload_epi64","","Load packed 64-bit integers from memory pointed by `mem_addr` using `mask` (elements are zeroed out when the highest bit is not set in the corresponding element).",null,null],[5,"_mm_maskstore_epi32","","Store packed 32-bit integers from `a` into memory pointed by `mem_addr` using `mask` (elements are not stored when the highest bit is not set in the corresponding element).",null,null],[5,"_mm256_maskstore_epi32","","Store packed 32-bit integers from `a` into memory pointed by `mem_addr` using `mask` (elements are not stored when the highest bit is not set in the corresponding element).",null,null],[5,"_mm_maskstore_epi64","","Store packed 64-bit integers from `a` into memory pointed by `mem_addr` using `mask` (elements are not stored when the highest bit is not set in the corresponding element).",null,null],[5,"_mm256_maskstore_epi64","","Store packed 64-bit integers from `a` into memory pointed by `mem_addr` using `mask` (elements are not stored when the highest bit is not set in the corresponding element).",null,null],[5,"_mm256_max_epi16","","Compare packed 16-bit integers in `a` and `b`, and return the packed maximum values.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_max_epi32","","Compare packed 32-bit integers in `a` and `b`, and return the packed maximum values.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_max_epi8","","Compare packed 8-bit integers in `a` and `b`, and return the packed maximum values.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_max_epu16","","Compare packed unsigned 16-bit integers in `a` and `b`, and return the packed maximum values.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_max_epu32","","Compare packed unsigned 32-bit integers in `a` and `b`, and return the packed maximum values.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_max_epu8","","Compare packed unsigned 8-bit integers in `a` and `b`, and return the packed maximum values.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_min_epi16","","Compare packed 16-bit integers in `a` and `b`, and return the packed minimum values.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_min_epi32","","Compare packed 32-bit integers in `a` and `b`, and return the packed minimum values.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_min_epi8","","Compare packed 8-bit integers in `a` and `b`, and return the packed minimum values.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_min_epu16","","Compare packed unsigned 16-bit integers in `a` and `b`, and return the packed minimum values.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_min_epu32","","Compare packed unsigned 32-bit integers in `a` and `b`, and return the packed minimum values.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_min_epu8","","Compare packed unsigned 8-bit integers in `a` and `b`, and return the packed minimum values.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_movemask_epi8","","Create mask from the most significant bit of each 8-bit element in `a`, return the result.",null,{"i":[{"n":"__m256i"}],"o":{"n":"i32"}}],[5,"_mm256_mpsadbw_epu8","","Compute the sum of absolute differences (SADs) of quadruplets of unsigned 8-bit integers in `a` compared to those in `b`, and store the 16-bit results in dst. Eight SADs are performed for each 128-bit lane using one quadruplet from `b` and eight quadruplets from `a`. One quadruplet is selected from `b` starting at on the offset specified in `imm8`. Eight quadruplets are formed from sequential 8-bit integers selected from `a` starting at the offset specified in `imm8`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm256_mul_epi32","","Multiply the low 32-bit integers from each packed 64-bit element in `a` and `b`",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_mul_epu32","","Multiply the low unsigned 32-bit integers from each packed 64-bit element in `a` and `b`",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_mulhi_epi16","","Multiply the packed 16-bit integers in `a` and `b`, producing intermediate 32-bit integers and returning the high 16 bits of the intermediate integers.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_mulhi_epu16","","Multiply the packed unsigned 16-bit integers in `a` and `b`, producing intermediate 32-bit integers and returning the high 16 bits of the intermediate integers.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_mullo_epi16","","Multiply the packed 16-bit integers in `a` and `b`, producing intermediate 32-bit integers, and return the low 16 bits of the intermediate integers",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_mullo_epi32","","Multiply the packed 32-bit integers in `a` and `b`, producing intermediate 64-bit integers, and return the low 16 bits of the intermediate integers",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_mulhrs_epi16","","Multiply packed 16-bit integers in `a` and `b`, producing intermediate signed 32-bit integers. Truncate each intermediate integer to the 18 most significant bits, round by adding 1, and return bits `[16:1]`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_or_si256","","Compute the bitwise OR of 256 bits (representing integer data) in `a` and `b`",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_packs_epi16","","Convert packed 16-bit integers from `a` and `b` to packed 8-bit integers using signed saturation",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_packs_epi32","","Convert packed 32-bit integers from `a` and `b` to packed 16-bit integers using signed saturation",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_packus_epi16","","Convert packed 16-bit integers from `a` and `b` to packed 8-bit integers using unsigned saturation",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_packus_epi32","","Convert packed 32-bit integers from `a` and `b` to packed 16-bit integers using unsigned saturation",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_permutevar8x32_epi32","","Permutes packed 32-bit integers from `a` according to the content of `b`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_permute4x64_epi64","","Permutes 64-bit integers from `a` using control mask `imm8`.",null,{"i":[{"n":"__m256i"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm256_permute2x128_si256","","Shuffle 128-bits of integer data selected by `imm8` from `a` and `b`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm256_permute4x64_pd","","Shuffle 64-bit floating-point elements in `a` across lanes using the control in `imm8`.",null,{"i":[{"n":"__m256d"},{"n":"i32"}],"o":{"n":"__m256d"}}],[5,"_mm256_permutevar8x32_ps","","Shuffle eight 32-bit foating-point elements in `a` across lanes using the corresponding 32-bit integer index in `idx`.",null,{"i":[{"n":"__m256"},{"n":"__m256i"}],"o":{"n":"__m256"}}],[5,"_mm256_sad_epu8","","Compute the absolute differences of packed unsigned 8-bit integers in `a` and `b`, then horizontally sum each consecutive 8 differences to produce four unsigned 16-bit integers, and pack these unsigned 16-bit integers in the low 16 bits of the 64-bit return value",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_shuffle_epi8","","Shuffle bytes from `a` according to the content of `b`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_shuffle_epi32","","Shuffle 32-bit integers in 128-bit lanes of `a` using the control in `imm8`.",null,{"i":[{"n":"__m256i"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm256_shufflehi_epi16","","Shuffle 16-bit integers in the high 64 bits of 128-bit lanes of `a` using the control in `imm8`. The low 64 bits of 128-bit lanes of `a` are copied to the output.",null,{"i":[{"n":"__m256i"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm256_shufflelo_epi16","","Shuffle 16-bit integers in the low 64 bits of 128-bit lanes of `a` using the control in `imm8`. The high 64 bits of 128-bit lanes of `a` are copied to the output.",null,{"i":[{"n":"__m256i"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm256_sign_epi16","","Negate packed 16-bit integers in `a` when the corresponding signed 16-bit integer in `b` is negative, and return the results. Results are zeroed out when the corresponding element in `b` is zero.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_sign_epi32","","Negate packed 32-bit integers in `a` when the corresponding signed 32-bit integer in `b` is negative, and return the results. Results are zeroed out when the corresponding element in `b` is zero.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_sign_epi8","","Negate packed 8-bit integers in `a` when the corresponding signed 8-bit integer in `b` is negative, and return the results. Results are zeroed out when the corresponding element in `b` is zero.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_sll_epi16","","Shift packed 16-bit integers in `a` left by `count` while shifting in zeros, and return the result",null,{"i":[{"n":"__m256i"},{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm256_sll_epi32","","Shift packed 32-bit integers in `a` left by `count` while shifting in zeros, and return the result",null,{"i":[{"n":"__m256i"},{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm256_sll_epi64","","Shift packed 64-bit integers in `a` left by `count` while shifting in zeros, and return the result",null,{"i":[{"n":"__m256i"},{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm256_slli_epi16","","Shift packed 16-bit integers in `a` left by `imm8` while shifting in zeros, return the results;",null,{"i":[{"n":"__m256i"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm256_slli_epi32","","Shift packed 32-bit integers in `a` left by `imm8` while shifting in zeros, return the results;",null,{"i":[{"n":"__m256i"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm256_slli_epi64","","Shift packed 64-bit integers in `a` left by `imm8` while shifting in zeros, return the results;",null,{"i":[{"n":"__m256i"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm256_slli_si256","","Shift 128-bit lanes in `a` left by `imm8` bytes while shifting in zeros.",null,{"i":[{"n":"__m256i"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm256_bslli_epi128","","Shift 128-bit lanes in `a` left by `imm8` bytes while shifting in zeros.",null,{"i":[{"n":"__m256i"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm_sllv_epi32","","Shift packed 32-bit integers in `a` left by the amount specified by the corresponding element in `count` while shifting in zeros, and return the result.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm256_sllv_epi32","","Shift packed 32-bit integers in `a` left by the amount specified by the corresponding element in `count` while shifting in zeros, and return the result.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm_sllv_epi64","","Shift packed 64-bit integers in `a` left by the amount specified by the corresponding element in `count` while shifting in zeros, and return the result.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm256_sllv_epi64","","Shift packed 64-bit integers in `a` left by the amount specified by the corresponding element in `count` while shifting in zeros, and return the result.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_sra_epi16","","Shift packed 16-bit integers in `a` right by `count` while shifting in sign bits.",null,{"i":[{"n":"__m256i"},{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm256_sra_epi32","","Shift packed 32-bit integers in `a` right by `count` while shifting in sign bits.",null,{"i":[{"n":"__m256i"},{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm256_srai_epi16","","Shift packed 16-bit integers in `a` right by `imm8` while shifting in sign bits.",null,{"i":[{"n":"__m256i"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm256_srai_epi32","","Shift packed 32-bit integers in `a` right by `imm8` while shifting in sign bits.",null,{"i":[{"n":"__m256i"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm_srav_epi32","","Shift packed 32-bit integers in `a` right by the amount specified by the corresponding element in `count` while shifting in sign bits.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm256_srav_epi32","","Shift packed 32-bit integers in `a` right by the amount specified by the corresponding element in `count` while shifting in sign bits.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_srli_si256","","Shift 128-bit lanes in `a` right by `imm8` bytes while shifting in zeros.",null,{"i":[{"n":"__m256i"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm256_bsrli_epi128","","Shift 128-bit lanes in `a` right by `imm8` bytes while shifting in zeros.",null,{"i":[{"n":"__m256i"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm256_srl_epi16","","Shift packed 16-bit integers in `a` right by `count` while shifting in zeros.",null,{"i":[{"n":"__m256i"},{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm256_srl_epi32","","Shift packed 32-bit integers in `a` right by `count` while shifting in zeros.",null,{"i":[{"n":"__m256i"},{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm256_srl_epi64","","Shift packed 64-bit integers in `a` right by `count` while shifting in zeros.",null,{"i":[{"n":"__m256i"},{"n":"__m128i"}],"o":{"n":"__m256i"}}],[5,"_mm256_srli_epi16","","Shift packed 16-bit integers in `a` right by `imm8` while shifting in zeros",null,{"i":[{"n":"__m256i"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm256_srli_epi32","","Shift packed 32-bit integers in `a` right by `imm8` while shifting in zeros",null,{"i":[{"n":"__m256i"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm256_srli_epi64","","Shift packed 64-bit integers in `a` right by `imm8` while shifting in zeros",null,{"i":[{"n":"__m256i"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_mm_srlv_epi32","","Shift packed 32-bit integers in `a` right by the amount specified by the corresponding element in `count` while shifting in zeros,",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm256_srlv_epi32","","Shift packed 32-bit integers in `a` right by the amount specified by the corresponding element in `count` while shifting in zeros,",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm_srlv_epi64","","Shift packed 64-bit integers in `a` right by the amount specified by the corresponding element in `count` while shifting in zeros,",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm256_srlv_epi64","","Shift packed 64-bit integers in `a` right by the amount specified by the corresponding element in `count` while shifting in zeros,",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_sub_epi16","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a`",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_sub_epi32","","Subtract packed 32-bit integers in `b` from packed 16-bit integers in `a`",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_sub_epi64","","Subtract packed 64-bit integers in `b` from packed 16-bit integers in `a`",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_sub_epi8","","Subtract packed 8-bit integers in `b` from packed 16-bit integers in `a`",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_subs_epi16","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a` using saturation.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_subs_epi8","","Subtract packed 8-bit integers in `b` from packed 8-bit integers in `a` using saturation.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_subs_epu16","","Subtract packed unsigned 16-bit integers in `b` from packed 16-bit integers in `a` using saturation.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_subs_epu8","","Subtract packed unsigned 8-bit integers in `b` from packed 8-bit integers in `a` using saturation.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_unpackhi_epi8","","Unpack and interleave 8-bit integers from the high half of each 128-bit lane in `a` and `b`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_unpacklo_epi8","","Unpack and interleave 8-bit integers from the low half of each 128-bit lane of `a` and `b`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_unpackhi_epi16","","Unpack and interleave 16-bit integers from the high half of each 128-bit lane of `a` and `b`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_unpacklo_epi16","","Unpack and interleave 16-bit integers from the low half of each 128-bit lane of `a` and `b`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_unpackhi_epi32","","Unpack and interleave 32-bit integers from the high half of each 128-bit lane of `a` and `b`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_unpacklo_epi32","","Unpack and interleave 32-bit integers from the low half of each 128-bit lane of `a` and `b`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_unpackhi_epi64","","Unpack and interleave 64-bit integers from the high half of each 128-bit lane of `a` and `b`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_unpacklo_epi64","","Unpack and interleave 64-bit integers from the low half of each 128-bit lane of `a` and `b`.",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_xor_si256","","Compute the bitwise XOR of 256 bits (representing integer data) in `a` and `b`",null,{"i":[{"n":"__m256i"},{"n":"__m256i"}],"o":{"n":"__m256i"}}],[5,"_mm256_extract_epi8","","Extract an 8-bit integer from `a`, selected with `imm8`. Returns a 32-bit integer containing the zero-extended integer data.",null,{"i":[{"n":"__m256i"},{"n":"i32"}],"o":{"n":"i8"}}],[5,"_mm256_extract_epi16","","Extract a 16-bit integer from `a`, selected with `imm8`. Returns a 32-bit integer containing the zero-extended integer data.",null,{"i":[{"n":"__m256i"},{"n":"i32"}],"o":{"n":"i16"}}],[5,"_mm256_extract_epi32","","Extract a 32-bit integer from `a`, selected with `imm8`.",null,{"i":[{"n":"__m256i"},{"n":"i32"}],"o":{"n":"i32"}}],[5,"_mm256_cvtsd_f64","","Returns the first element of the input vector of `[4 x double]`.",null,{"i":[{"n":"__m256d"}],"o":{"n":"f64"}}],[5,"_mm256_cvtsi256_si32","","Returns the first element of the input vector of `[8 x i32]`.",null,{"i":[{"n":"__m256i"}],"o":{"n":"i32"}}],[5,"_mm_fmadd_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and add the intermediate result to packed elements in `c`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm256_fmadd_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and add the intermediate result to packed elements in `c`.",null,{"i":[{"n":"__m256d"},{"n":"__m256d"},{"n":"__m256d"}],"o":{"n":"__m256d"}}],[5,"_mm_fmadd_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and add the intermediate result to packed elements in `c`.",null,{"i":[{"n":"__m128"},{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm256_fmadd_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and add the intermediate result to packed elements in `c`.",null,{"i":[{"n":"__m256"},{"n":"__m256"},{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm_fmadd_sd","","Multiply the lower double-precision (64-bit) floating-point elements in `a` and `b`, and add the intermediate result to the lower element in `c`. Store the result in the lower element of the returned value, and copy the upper element from `a` to the upper elements of the result.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_fmadd_ss","","Multiply the lower single-precision (32-bit) floating-point elements in `a` and `b`, and add the intermediate result to the lower element in `c`. Store the result in the lower element of the returned value, and copy the 3 upper elements from `a` to the upper elements of the result.",null,{"i":[{"n":"__m128"},{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_fmaddsub_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and alternatively add and subtract packed elements in `c` to/from the intermediate result.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm256_fmaddsub_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and alternatively add and subtract packed elements in `c` to/from the intermediate result.",null,{"i":[{"n":"__m256d"},{"n":"__m256d"},{"n":"__m256d"}],"o":{"n":"__m256d"}}],[5,"_mm_fmaddsub_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and alternatively add and subtract packed elements in `c` to/from the intermediate result.",null,{"i":[{"n":"__m128"},{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm256_fmaddsub_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and alternatively add and subtract packed elements in `c` to/from the intermediate result.",null,{"i":[{"n":"__m256"},{"n":"__m256"},{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm_fmsub_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the intermediate result.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm256_fmsub_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the intermediate result.",null,{"i":[{"n":"__m256d"},{"n":"__m256d"},{"n":"__m256d"}],"o":{"n":"__m256d"}}],[5,"_mm_fmsub_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the intermediate result.",null,{"i":[{"n":"__m128"},{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm256_fmsub_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the intermediate result.",null,{"i":[{"n":"__m256"},{"n":"__m256"},{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm_fmsub_sd","","Multiply the lower double-precision (64-bit) floating-point elements in `a` and `b`, and subtract the lower element in `c` from the intermediate result. Store the result in the lower element of the returned value, and copy the upper element from `a` to the upper elements of the result.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_fmsub_ss","","Multiply the lower single-precision (32-bit) floating-point elements in `a` and `b`,  and subtract the lower element in `c` from the intermediate result. Store the result in the lower element of the returned value, and copy the 3 upper elements from `a` to the upper elements of the result.",null,{"i":[{"n":"__m128"},{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_fmsubadd_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and alternatively subtract and add packed elements in `c` from/to the intermediate result.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm256_fmsubadd_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and alternatively subtract and add packed elements in `c` from/to the intermediate result.",null,{"i":[{"n":"__m256d"},{"n":"__m256d"},{"n":"__m256d"}],"o":{"n":"__m256d"}}],[5,"_mm_fmsubadd_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and alternatively subtract and add packed elements in `c` from/to the intermediate result.",null,{"i":[{"n":"__m128"},{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm256_fmsubadd_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and alternatively subtract and add packed elements in `c` from/to the intermediate result.",null,{"i":[{"n":"__m256"},{"n":"__m256"},{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm_fnmadd_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and add the negated intermediate result to packed elements in `c`.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm256_fnmadd_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and add the negated intermediate result to packed elements in `c`.",null,{"i":[{"n":"__m256d"},{"n":"__m256d"},{"n":"__m256d"}],"o":{"n":"__m256d"}}],[5,"_mm_fnmadd_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and add the negated intermediate result to packed elements in `c`.",null,{"i":[{"n":"__m128"},{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm256_fnmadd_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and add the negated intermediate result to packed elements in `c`.",null,{"i":[{"n":"__m256"},{"n":"__m256"},{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm_fnmadd_sd","","Multiply the lower double-precision (64-bit) floating-point elements in `a` and `b`, and add the negated intermediate result to the lower element in `c`. Store the result in the lower element of the returned value, and copy the upper element from `a` to the upper elements of the result.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_fnmadd_ss","","Multiply the lower single-precision (32-bit) floating-point elements in `a` and `b`, and add the negated intermediate result to the lower element in `c`. Store the result in the lower element of the returned value, and copy the 3 upper elements from `a` to the upper elements of the result.",null,{"i":[{"n":"__m128"},{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm_fnmsub_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the negated intermediate result.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm256_fnmsub_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the negated intermediate result.",null,{"i":[{"n":"__m256d"},{"n":"__m256d"},{"n":"__m256d"}],"o":{"n":"__m256d"}}],[5,"_mm_fnmsub_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the negated intermediate result.",null,{"i":[{"n":"__m128"},{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_mm256_fnmsub_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the negated intermediate result.",null,{"i":[{"n":"__m256"},{"n":"__m256"},{"n":"__m256"}],"o":{"n":"__m256"}}],[5,"_mm_fnmsub_sd","","Multiply the lower double-precision (64-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the negated intermediate result. Store the result in the lower element of the returned value, and copy the upper element from `a` to the upper elements of the result.",null,{"i":[{"n":"__m128d"},{"n":"__m128d"},{"n":"__m128d"}],"o":{"n":"__m128d"}}],[5,"_mm_fnmsub_ss","","Multiply the lower single-precision (32-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the negated intermediate result. Store the result in the lower element of the returned value, and copy the 3 upper elements from `a` to the upper elements of the result.",null,{"i":[{"n":"__m128"},{"n":"__m128"},{"n":"__m128"}],"o":{"n":"__m128"}}],[5,"_lzcnt_u32","","Counts the leading most significant zero bits.",null,{"i":[{"n":"u32"}],"o":{"n":"u32"}}],[5,"_popcnt32","","Counts the bits that are set.",null,{"i":[{"n":"i32"}],"o":{"n":"i32"}}],[5,"_bextr_u32","","Extracts bits in range [`start`, `start` + `length`) from `a` into the least significant bits of the result.",null,{"i":[{"n":"u32"},{"n":"u32"},{"n":"u32"}],"o":{"n":"u32"}}],[5,"_bextr2_u32","","Extracts bits of `a` specified by `control` into the least significant bits of the result.",null,{"i":[{"n":"u32"},{"n":"u32"}],"o":{"n":"u32"}}],[5,"_andn_u32","","Bitwise logical `AND` of inverted `a` with `b`.",null,{"i":[{"n":"u32"},{"n":"u32"}],"o":{"n":"u32"}}],[5,"_blsi_u32","","Extract lowest set isolated bit.",null,{"i":[{"n":"u32"}],"o":{"n":"u32"}}],[5,"_blsmsk_u32","","Get mask up to lowest set bit.",null,{"i":[{"n":"u32"}],"o":{"n":"u32"}}],[5,"_blsr_u32","","Resets the lowest set bit of `x`.",null,{"i":[{"n":"u32"}],"o":{"n":"u32"}}],[5,"_tzcnt_u32","","Counts the number of trailing least significant zero bits.",null,{"i":[{"n":"u32"}],"o":{"n":"u32"}}],[5,"_mm_tzcnt_32","","Counts the number of trailing least significant zero bits.",null,{"i":[{"n":"u32"}],"o":{"n":"i32"}}],[5,"_mulx_u32","","Unsigned multiply without affecting flags.",null,{"i":[{"n":"u32"},{"n":"u32"},{"n":"u32"}],"o":{"n":"u32"}}],[5,"_bzhi_u32","","Zero higher bits of `a` >= `index`.",null,{"i":[{"n":"u32"},{"n":"u32"}],"o":{"n":"u32"}}],[5,"_pdep_u32","","Scatter contiguous low order bits of `a` to the result at the positions specified by the `mask`.",null,{"i":[{"n":"u32"},{"n":"u32"}],"o":{"n":"u32"}}],[5,"_pext_u32","","Gathers the bits of `x` specified by the `mask` into the contiguous low order bit positions of the result.",null,{"i":[{"n":"u32"},{"n":"u32"}],"o":{"n":"u32"}}],[5,"_mm_extract_si64","","Extracts the bit range specified by `y` from the lower 64 bits of `x`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_insert_si64","","Inserts the `[length:0]` bits of `y` into `x` at `index`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_stream_sd","","Non-temporal store of `a.0` into `p`.",null,null],[5,"_mm_stream_ss","","Non-temporal store of `a.0` into `p`.",null,null],[5,"_blcfill_u32","","Clears all bits below the least significant zero bit of `x`.",null,{"i":[{"n":"u32"}],"o":{"n":"u32"}}],[5,"_blcfill_u64","","Clears all bits below the least significant zero bit of `x`.",null,{"i":[{"n":"u64"}],"o":{"n":"u64"}}],[5,"_blci_u32","","Sets all bits of `x` to 1 except for the least significant zero bit.",null,{"i":[{"n":"u32"}],"o":{"n":"u32"}}],[5,"_blci_u64","","Sets all bits of `x` to 1 except for the least significant zero bit.",null,{"i":[{"n":"u64"}],"o":{"n":"u64"}}],[5,"_blcic_u32","","Sets the least significant zero bit of `x` and clears all other bits.",null,{"i":[{"n":"u32"}],"o":{"n":"u32"}}],[5,"_blcic_u64","","Sets the least significant zero bit of `x` and clears all other bits.",null,{"i":[{"n":"u64"}],"o":{"n":"u64"}}],[5,"_blcmsk_u32","","Sets the least significant zero bit of `x` and clears all bits above that bit.",null,{"i":[{"n":"u32"}],"o":{"n":"u32"}}],[5,"_blcmsk_u64","","Sets the least significant zero bit of `x` and clears all bits above that bit.",null,{"i":[{"n":"u64"}],"o":{"n":"u64"}}],[5,"_blcs_u32","","Sets the least significant zero bit of `x`.",null,{"i":[{"n":"u32"}],"o":{"n":"u32"}}],[5,"_blcs_u64","","Sets the least significant zero bit of `x`.",null,{"i":[{"n":"u64"}],"o":{"n":"u64"}}],[5,"_blsfill_u32","","Sets all bits of `x` below the least significant one.",null,{"i":[{"n":"u32"}],"o":{"n":"u32"}}],[5,"_blsfill_u64","","Sets all bits of `x` below the least significant one.",null,{"i":[{"n":"u64"}],"o":{"n":"u64"}}],[5,"_blsic_u32","","Clears least significant bit and sets all other bits.",null,{"i":[{"n":"u32"}],"o":{"n":"u32"}}],[5,"_blsic_u64","","Clears least significant bit and sets all other bits.",null,{"i":[{"n":"u64"}],"o":{"n":"u64"}}],[5,"_t1mskc_u32","","Clears all bits below the least significant zero of `x` and sets all other bits.",null,{"i":[{"n":"u32"}],"o":{"n":"u32"}}],[5,"_t1mskc_u64","","Clears all bits below the least significant zero of `x` and sets all other bits.",null,{"i":[{"n":"u64"}],"o":{"n":"u64"}}],[5,"_tzmsk_u32","","Sets all bits below the least significant one of `x` and clears all other bits.",null,{"i":[{"n":"u32"}],"o":{"n":"u32"}}],[5,"_tzmsk_u64","","Sets all bits below the least significant one of `x` and clears all other bits.",null,{"i":[{"n":"u64"}],"o":{"n":"u64"}}],[5,"_mm_setzero_si64","","Constructs a 64-bit integer vector initialized to zero.",null,{"o":{"n":"__m64"}}],[5,"_mm_add_pi8","","Add packed 8-bit integers in `a` and `b`.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_m_paddb","","Add packed 8-bit integers in `a` and `b`.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_add_pi16","","Add packed 16-bit integers in `a` and `b`.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_m_paddw","","Add packed 16-bit integers in `a` and `b`.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_add_pi32","","Add packed 32-bit integers in `a` and `b`.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_m_paddd","","Add packed 32-bit integers in `a` and `b`.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_adds_pi8","","Add packed 8-bit integers in `a` and `b` using saturation.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_m_paddsb","","Add packed 8-bit integers in `a` and `b` using saturation.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_adds_pi16","","Add packed 16-bit integers in `a` and `b` using saturation.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_m_paddsw","","Add packed 16-bit integers in `a` and `b` using saturation.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_adds_pu8","","Add packed unsigned 8-bit integers in `a` and `b` using saturation.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_m_paddusb","","Add packed unsigned 8-bit integers in `a` and `b` using saturation.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_adds_pu16","","Add packed unsigned 16-bit integers in `a` and `b` using saturation.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_m_paddusw","","Add packed unsigned 16-bit integers in `a` and `b` using saturation.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_sub_pi8","","Subtract packed 8-bit integers in `b` from packed 8-bit integers in `a`.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_m_psubb","","Subtract packed 8-bit integers in `b` from packed 8-bit integers in `a`.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_sub_pi16","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a`.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_m_psubw","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a`.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_sub_pi32","","Subtract packed 32-bit integers in `b` from packed 32-bit integers in `a`.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_m_psubd","","Subtract packed 32-bit integers in `b` from packed 32-bit integers in `a`.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_subs_pi8","","Subtract packed 8-bit integers in `b` from packed 8-bit integers in `a` using saturation.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_m_psubsb","","Subtract packed 8-bit integers in `b` from packed 8-bit integers in `a` using saturation.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_subs_pi16","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a` using saturation.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_m_psubsw","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a` using saturation.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_subs_pu8","","Subtract packed unsigned 8-bit integers in `b` from packed unsigned 8-bit integers in `a` using saturation.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_m_psubusb","","Subtract packed unsigned 8-bit integers in `b` from packed unsigned 8-bit integers in `a` using saturation.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_subs_pu16","","Subtract packed unsigned 16-bit integers in `b` from packed unsigned 16-bit integers in `a` using saturation.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_m_psubusw","","Subtract packed unsigned 16-bit integers in `b` from packed unsigned 16-bit integers in `a` using saturation.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_packs_pi16","","Convert packed 16-bit integers from `a` and `b` to packed 8-bit integers using signed saturation.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_packs_pi32","","Convert packed 32-bit integers from `a` and `b` to packed 16-bit integers using signed saturation.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_cmpgt_pi8","","Compares whether each element of `a` is greater than the corresponding element of `b` returning `0` for `false` and `-1` for `true`.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_cmpgt_pi16","","Compares whether each element of `a` is greater than the corresponding element of `b` returning `0` for `false` and `-1` for `true`.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_cmpgt_pi32","","Compares whether each element of `a` is greater than the corresponding element of `b` returning `0` for `false` and `-1` for `true`.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_unpackhi_pi16","","Unpacks the upper two elements from two `i16x4` vectors and interleaves them into the result: `[a.2, b.2, a.3, b.3]`.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_unpackhi_pi8","","Unpacks the upper four elements from two `i8x8` vectors and interleaves them into the result: `[a.4, b.4, a.5, b.5, a.6, b.6, a.7, b.7]`.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_unpacklo_pi8","","Unpacks the lower four elements from two `i8x8` vectors and interleaves them into the result: `[a.0, b.0, a.1, b.1, a.2, b.2, a.3, b.3]`.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_unpacklo_pi16","","Unpacks the lower two elements from two `i16x4` vectors and interleaves them into the result: `[a.0 b.0 a.1 b.1]`.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_unpackhi_pi32","","Unpacks the upper element from two `i32x2` vectors and interleaves them into the result: `[a.1, b.1]`.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_unpacklo_pi32","","Unpacks the lower element from two `i32x2` vectors and interleaves them into the result: `[a.0, b.0]`.",null,{"i":[{"n":"__m64"},{"n":"__m64"}],"o":{"n":"__m64"}}],[5,"_mm_set_pi16","","Set packed 16-bit integers in dst with the supplied values.",null,{"i":[{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"}],"o":{"n":"__m64"}}],[5,"_mm_set_pi32","","Set packed 32-bit integers in dst with the supplied values.",null,{"i":[{"n":"i32"},{"n":"i32"}],"o":{"n":"__m64"}}],[5,"_mm_set_pi8","","Set packed 8-bit integers in dst with the supplied values.",null,{"i":[{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"}],"o":{"n":"__m64"}}],[5,"_mm_set1_pi16","","Broadcast 16-bit integer a to all all elements of dst.",null,{"i":[{"n":"i16"}],"o":{"n":"__m64"}}],[5,"_mm_set1_pi32","","Broadcast 32-bit integer a to all all elements of dst.",null,{"i":[{"n":"i32"}],"o":{"n":"__m64"}}],[5,"_mm_set1_pi8","","Broadcast 8-bit integer a to all all elements of dst.",null,{"i":[{"n":"i8"}],"o":{"n":"__m64"}}],[5,"_mm_setr_pi16","","Set packed 16-bit integers in dst with the supplied values in reverse order.",null,{"i":[{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"}],"o":{"n":"__m64"}}],[5,"_mm_setr_pi32","","Set packed 32-bit integers in dst with the supplied values in reverse order.",null,{"i":[{"n":"i32"},{"n":"i32"}],"o":{"n":"__m64"}}],[5,"_mm_setr_pi8","","Set packed 8-bit integers in dst with the supplied values in reverse order.",null,{"i":[{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"}],"o":{"n":"__m64"}}],[5,"_mm_clmulepi64_si128","","Perform a carry-less multiplication of two 64-bit polynomials over the finite field GF(2^k).",null,{"i":[{"n":"__m128i"},{"n":"__m128i"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_aesdec_si128","","Perform one round of an AES decryption flow on data (state) in `a`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_aesdeclast_si128","","Perform the last round of an AES decryption flow on data (state) in `a`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_aesenc_si128","","Perform one round of an AES encryption flow on data (state) in `a`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_aesenclast_si128","","Perform the last round of an AES encryption flow on data (state) in `a`.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_aesimc_si128","","Perform the `InvMixColumns` transformation on `a`.",null,{"i":[{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_aeskeygenassist_si128","","Assist in expanding the AES cipher key.",null,{"i":[{"n":"__m128i"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_rdrand16_step","","Read a hardware generated 16-bit random value and store the result in val. Return 1 if a random value was generated, and 0 otherwise.",null,{"i":[{"n":"u16"}],"o":{"n":"i32"}}],[5,"_rdrand32_step","","Read a hardware generated 32-bit random value and store the result in val. Return 1 if a random value was generated, and 0 otherwise.",null,{"i":[{"n":"u32"}],"o":{"n":"i32"}}],[5,"_rdseed16_step","","Read a 16-bit NIST SP800-90B and SP800-90C compliant random value and store in val. Return 1 if a random value was generated, and 0 otherwise.",null,{"i":[{"n":"u16"}],"o":{"n":"i32"}}],[5,"_rdseed32_step","","Read a 32-bit NIST SP800-90B and SP800-90C compliant random value and store in val. Return 1 if a random value was generated, and 0 otherwise.",null,{"i":[{"n":"u32"}],"o":{"n":"i32"}}],[5,"_mm_sha1msg1_epu32","","Perform an intermediate calculation for the next four SHA1 message values (unsigned 32-bit integers) using previous message values from `a` and `b`, and returning the result.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_sha1msg2_epu32","","Perform the final calculation for the next four SHA1 message values (unsigned 32-bit integers) using the intermediate result in `a` and the previous message values in `b`, and returns the result.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_sha1nexte_epu32","","Calculate SHA1 state variable E after four rounds of operation from the current SHA1 state variable `a`, add that value to the scheduled values (unsigned 32-bit integers) in `b`, and returns the result.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_sha1rnds4_epu32","","Perform four rounds of SHA1 operation using an initial SHA1 state (A,B,C,D) from `a` and some pre-computed sum of the next 4 round message values (unsigned 32-bit integers), and state variable E from `b`, and return the updated SHA1 state (A,B,C,D). `func` contains the logic functions and round constants.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_sha256msg1_epu32","","Perform an intermediate calculation for the next four SHA256 message values (unsigned 32-bit integers) using previous message values from `a` and `b`, and return the result.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_sha256msg2_epu32","","Perform the final calculation for the next four SHA256 message values (unsigned 32-bit integers) using previous message values from `a` and `b`, and return the result.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_mm_sha256rnds2_epu32","","Perform 2 rounds of SHA256 operation using an initial SHA256 state (C,D,G,H) from `a`, an initial SHA256 state (A,B,E,F) from `b`, and a pre-computed sum of the next 2 round message values (unsigned 32-bit integers) and the corresponding round constants from `k`, and store the updated SHA256 state (A,B,E,F) in dst.",null,{"i":[{"n":"__m128i"},{"n":"__m128i"},{"n":"__m128i"}],"o":{"n":"__m128i"}}],[5,"_fxsave64","","Saves the `x87` FPU, `MMX` technology, `XMM`, and `MXCSR` registers to the 512-byte-long 16-byte-aligned memory region `mem_addr`.",null,null],[5,"_fxrstor64","","Restores the `XMM`, `MMX`, `MXCSR`, and `x87` FPU registers from the 512-byte-long 16-byte-aligned memory region `mem_addr`.",null,null],[5,"_mm_cvtss_si64","","Convert the lowest 32 bit float in the input vector to a 64 bit integer.",null,{"i":[{"n":"__m128"}],"o":{"n":"i64"}}],[5,"_mm_cvttss_si64","","Convert the lowest 32 bit float in the input vector to a 64 bit integer with truncation.",null,{"i":[{"n":"__m128"}],"o":{"n":"i64"}}],[5,"_mm_cvtsi64_ss","","Convert a 64 bit integer to a 32 bit float. The result vector is the input vector `a` with the lowest 32 bit float replaced by the converted integer.",null,{"i":[{"n":"__m128"},{"n":"i64"}],"o":{"n":"__m128"}}],[5,"_mm_cvtsd_si64","","Convert the lower double-precision (64-bit) floating-point element in a to a 64-bit integer.",null,{"i":[{"n":"__m128d"}],"o":{"n":"i64"}}],[5,"_mm_cvtsd_si64x","","Alias for `_mm_cvtsd_si64`",null,{"i":[{"n":"__m128d"}],"o":{"n":"i64"}}],[5,"_mm_cvttsd_si64","","Convert the lower double-precision (64-bit) floating-point element in `a` to a 64-bit integer with truncation.",null,{"i":[{"n":"__m128d"}],"o":{"n":"i64"}}],[5,"_mm_cvttsd_si64x","","Alias for `_mm_cvttsd_si64`",null,{"i":[{"n":"__m128d"}],"o":{"n":"i64"}}],[5,"_mm_stream_si64","","Stores a 64-bit integer value in the specified memory location. To minimize caching, the data is flagged as non-temporal (unlikely to be used again soon).",null,null],[5,"_mm_cvtsi64_si128","","Return a vector whose lowest element is `a` and all higher elements are `0`.",null,{"i":[{"n":"i64"}],"o":{"n":"__m128i"}}],[5,"_mm_cvtsi64x_si128","","Return a vector whose lowest element is `a` and all higher elements are `0`.",null,{"i":[{"n":"i64"}],"o":{"n":"__m128i"}}],[5,"_mm_cvtsi128_si64","","Return the lowest element of `a`.",null,{"i":[{"n":"__m128i"}],"o":{"n":"i64"}}],[5,"_mm_cvtsi128_si64x","","Return the lowest element of `a`.",null,{"i":[{"n":"__m128i"}],"o":{"n":"i64"}}],[5,"_mm_cvtsi64_sd","","Return `a` with its lower element replaced by `b` after converting it to an `f64`.",null,{"i":[{"n":"__m128d"},{"n":"i64"}],"o":{"n":"__m128d"}}],[5,"_mm_cvtsi64x_sd","","Return `a` with its lower element replaced by `b` after converting it to an `f64`.",null,{"i":[{"n":"__m128d"},{"n":"i64"}],"o":{"n":"__m128d"}}],[5,"_mm_extract_epi64","","Extract an 64-bit integer from `a` selected with `imm8`",null,{"i":[{"n":"__m128i"},{"n":"i32"}],"o":{"n":"i64"}}],[5,"_mm_insert_epi64","","Return a copy of `a` with the 64-bit integer from `i` inserted at a location specified by `imm8`.",null,{"i":[{"n":"__m128i"},{"n":"i64"},{"n":"i32"}],"o":{"n":"__m128i"}}],[5,"_mm_crc32_u64","","Starting with the initial value in `crc`, return the accumulated CRC32 value for unsigned 64-bit integer `v`.",null,{"i":[{"n":"u64"},{"n":"u64"}],"o":{"n":"u64"}}],[5,"_xsave64","","Perform a full or partial save of the enabled processor states to memory at `mem_addr`.",null,null],[5,"_xrstor64","","Perform a full or partial restore of the enabled processor states using the state information stored in memory at `mem_addr`.",null,null],[5,"_xsaveopt64","","Perform a full or partial save of the enabled processor states to memory at `mem_addr`.",null,null],[5,"_xsavec64","","Perform a full or partial save of the enabled processor states to memory at `mem_addr`.",null,null],[5,"_xsaves64","","Perform a full or partial save of the enabled processor states to memory at `mem_addr`",null,null],[5,"_xrstors64","","Perform a full or partial restore of the enabled processor states using the state information stored in memory at `mem_addr`.",null,null],[5,"_lzcnt_u64","","Counts the leading most significant zero bits.",null,{"i":[{"n":"u64"}],"o":{"n":"u64"}}],[5,"_popcnt64","","Counts the bits that are set.",null,{"i":[{"n":"i64"}],"o":{"n":"i32"}}],[5,"_mm256_insert_epi64","","Copy `a` to result, and insert the 64-bit integer `i` into result at the location specified by `index`.",null,{"i":[{"n":"__m256i"},{"n":"i64"},{"n":"i32"}],"o":{"n":"__m256i"}}],[5,"_bextr_u64","","Extracts bits in range [`start`, `start` + `length`) from `a` into the least significant bits of the result.",null,{"i":[{"n":"u64"},{"n":"u32"},{"n":"u32"}],"o":{"n":"u64"}}],[5,"_bextr2_u64","","Extracts bits of `a` specified by `control` into the least significant bits of the result.",null,{"i":[{"n":"u64"},{"n":"u64"}],"o":{"n":"u64"}}],[5,"_andn_u64","","Bitwise logical `AND` of inverted `a` with `b`.",null,{"i":[{"n":"u64"},{"n":"u64"}],"o":{"n":"u64"}}],[5,"_blsi_u64","","Extract lowest set isolated bit.",null,{"i":[{"n":"u64"}],"o":{"n":"u64"}}],[5,"_blsmsk_u64","","Get mask up to lowest set bit.",null,{"i":[{"n":"u64"}],"o":{"n":"u64"}}],[5,"_blsr_u64","","Resets the lowest set bit of `x`.",null,{"i":[{"n":"u64"}],"o":{"n":"u64"}}],[5,"_tzcnt_u64","","Counts the number of trailing least significant zero bits.",null,{"i":[{"n":"u64"}],"o":{"n":"u64"}}],[5,"_mm_tzcnt_64","","Counts the number of trailing least significant zero bits.",null,{"i":[{"n":"u64"}],"o":{"n":"i64"}}],[5,"_mulx_u64","","Unsigned multiply without affecting flags.",null,{"i":[{"n":"u64"},{"n":"u64"},{"n":"u64"}],"o":{"n":"u64"}}],[5,"_bzhi_u64","","Zero higher bits of `a` >= `index`.",null,{"i":[{"n":"u64"},{"n":"u32"}],"o":{"n":"u64"}}],[5,"_pdep_u64","","Scatter contiguous low order bits of `a` to the result at the positions specified by the `mask`.",null,{"i":[{"n":"u64"},{"n":"u64"}],"o":{"n":"u64"}}],[5,"_pext_u64","","Gathers the bits of `x` specified by the `mask` into the contiguous low order bit positions of the result.",null,{"i":[{"n":"u64"},{"n":"u64"}],"o":{"n":"u64"}}],[5,"_mm256_extract_epi64","","Extract a 64-bit integer from `a`, selected with `imm8`.",null,{"i":[{"n":"__m256i"},{"n":"i32"}],"o":{"n":"i64"}}],[5,"_bswap64","","Return an integer with the reversed byte order of x",null,{"i":[{"n":"i64"}],"o":{"n":"i64"}}],[5,"_rdrand64_step","","Read a hardware generated 64-bit random value and store the result in val. Return 1 if a random value was generated, and 0 otherwise.",null,{"i":[{"n":"u64"}],"o":{"n":"i32"}}],[5,"_rdseed64_step","","Read a 64-bit NIST SP800-90B and SP800-90C compliant random value and store in val. Return 1 if a random value was generated, and 0 otherwise.",null,{"i":[{"n":"u64"}],"o":{"n":"i32"}}],[17,"_XCR_XFEATURE_ENABLED_MASK","","`XFEATURE_ENABLED_MASK` for `XCR`",null,null],[17,"_MM_EXCEPT_INVALID","","See `_mm_setcsr`",null,null],[17,"_MM_EXCEPT_DENORM","","See `_mm_setcsr`",null,null],[17,"_MM_EXCEPT_DIV_ZERO","","See `_mm_setcsr`",null,null],[17,"_MM_EXCEPT_OVERFLOW","","See `_mm_setcsr`",null,null],[17,"_MM_EXCEPT_UNDERFLOW","","See `_mm_setcsr`",null,null],[17,"_MM_EXCEPT_INEXACT","","See `_mm_setcsr`",null,null],[17,"_MM_EXCEPT_MASK","","See `_MM_GET_EXCEPTION_STATE`",null,null],[17,"_MM_MASK_INVALID","","See `_mm_setcsr`",null,null],[17,"_MM_MASK_DENORM","","See `_mm_setcsr`",null,null],[17,"_MM_MASK_DIV_ZERO","","See `_mm_setcsr`",null,null],[17,"_MM_MASK_OVERFLOW","","See `_mm_setcsr`",null,null],[17,"_MM_MASK_UNDERFLOW","","See `_mm_setcsr`",null,null],[17,"_MM_MASK_INEXACT","","See `_mm_setcsr`",null,null],[17,"_MM_MASK_MASK","","See `_MM_GET_EXCEPTION_MASK`",null,null],[17,"_MM_ROUND_NEAREST","","See `_mm_setcsr`",null,null],[17,"_MM_ROUND_DOWN","","See `_mm_setcsr`",null,null],[17,"_MM_ROUND_UP","","See `_mm_setcsr`",null,null],[17,"_MM_ROUND_TOWARD_ZERO","","See `_mm_setcsr`",null,null],[17,"_MM_ROUND_MASK","","See `_MM_GET_ROUNDING_MODE`",null,null],[17,"_MM_FLUSH_ZERO_MASK","","See `_MM_GET_FLUSH_ZERO_MODE`",null,null],[17,"_MM_FLUSH_ZERO_ON","","See `_mm_setcsr`",null,null],[17,"_MM_FLUSH_ZERO_OFF","","See `_mm_setcsr`",null,null],[17,"_MM_HINT_T0","","See `_mm_prefetch`.",null,null],[17,"_MM_HINT_T1","","See `_mm_prefetch`.",null,null],[17,"_MM_HINT_T2","","See `_mm_prefetch`.",null,null],[17,"_MM_HINT_NTA","","See `_mm_prefetch`.",null,null],[17,"_MM_FROUND_TO_NEAREST_INT","","round to nearest",null,null],[17,"_MM_FROUND_TO_NEG_INF","","round down",null,null],[17,"_MM_FROUND_TO_POS_INF","","round up",null,null],[17,"_MM_FROUND_TO_ZERO","","truncate",null,null],[17,"_MM_FROUND_CUR_DIRECTION","","use MXCSR.RC; see `vendor::_MM_SET_ROUNDING_MODE`",null,null],[17,"_MM_FROUND_RAISE_EXC","","do not suppress exceptions",null,null],[17,"_MM_FROUND_NO_EXC","","suppress exceptions",null,null],[17,"_MM_FROUND_NINT","","round to nearest and do not suppress exceptions",null,null],[17,"_MM_FROUND_FLOOR","","round down and do not suppress exceptions",null,null],[17,"_MM_FROUND_CEIL","","round up and do not suppress exceptions",null,null],[17,"_MM_FROUND_TRUNC","","truncate and do not suppress exceptions",null,null],[17,"_MM_FROUND_RINT","","use MXCSR.RC and do not suppress exceptions; see `vendor::_MM_SET_ROUNDING_MODE`",null,null],[17,"_MM_FROUND_NEARBYINT","","use MXCSR.RC and suppress exceptions; see `vendor::_MM_SET_ROUNDING_MODE`",null,null],[17,"_SIDD_UBYTE_OPS","","String contains unsigned 8-bit characters (Default)",null,null],[17,"_SIDD_UWORD_OPS","","String contains unsigned 16-bit characters",null,null],[17,"_SIDD_SBYTE_OPS","","String contains signed 8-bit characters",null,null],[17,"_SIDD_SWORD_OPS","","String contains unsigned 16-bit characters",null,null],[17,"_SIDD_CMP_EQUAL_ANY","","For each character in `a`, find if it is in `b` (Default)",null,null],[17,"_SIDD_CMP_RANGES","","For each character in `a`, determine if `b[0] <= c <= b[1] or b[1] <= c <= b[2]...`",null,null],[17,"_SIDD_CMP_EQUAL_EACH","","The strings defined by `a` and `b` are equal",null,null],[17,"_SIDD_CMP_EQUAL_ORDERED","","Search for the defined substring in the target",null,null],[17,"_SIDD_POSITIVE_POLARITY","","Do not negate results (Default)",null,null],[17,"_SIDD_NEGATIVE_POLARITY","","Negate results",null,null],[17,"_SIDD_MASKED_POSITIVE_POLARITY","","Do not negate results before the end of the string",null,null],[17,"_SIDD_MASKED_NEGATIVE_POLARITY","","Negate results only before the end of the string",null,null],[17,"_SIDD_LEAST_SIGNIFICANT","","Index only: return the least significant bit (Default)",null,null],[17,"_SIDD_MOST_SIGNIFICANT","","Index only: return the most significant bit",null,null],[17,"_SIDD_BIT_MASK","","Mask only: return the bit mask",null,null],[17,"_SIDD_UNIT_MASK","","Mask only: return the byte mask",null,null],[17,"_CMP_EQ_OQ","","Equal (ordered, non-signaling)",null,null],[17,"_CMP_LT_OS","","Less-than (ordered, signaling)",null,null],[17,"_CMP_LE_OS","","Less-than-or-equal (ordered, signaling)",null,null],[17,"_CMP_UNORD_Q","","Unordered (non-signaling)",null,null],[17,"_CMP_NEQ_UQ","","Not-equal (unordered, non-signaling)",null,null],[17,"_CMP_NLT_US","","Not-less-than (unordered, signaling)",null,null],[17,"_CMP_NLE_US","","Not-less-than-or-equal (unordered, signaling)",null,null],[17,"_CMP_ORD_Q","","Ordered (non-signaling)",null,null],[17,"_CMP_EQ_UQ","","Equal (unordered, non-signaling)",null,null],[17,"_CMP_NGE_US","","Not-greater-than-or-equal (unordered, signaling)",null,null],[17,"_CMP_NGT_US","","Not-greater-than (unordered, signaling)",null,null],[17,"_CMP_FALSE_OQ","","False (ordered, non-signaling)",null,null],[17,"_CMP_NEQ_OQ","","Not-equal (ordered, non-signaling)",null,null],[17,"_CMP_GE_OS","","Greater-than-or-equal (ordered, signaling)",null,null],[17,"_CMP_GT_OS","","Greater-than (ordered, signaling)",null,null],[17,"_CMP_TRUE_UQ","","True (unordered, non-signaling)",null,null],[17,"_CMP_EQ_OS","","Equal (ordered, signaling)",null,null],[17,"_CMP_LT_OQ","","Less-than (ordered, non-signaling)",null,null],[17,"_CMP_LE_OQ","","Less-than-or-equal (ordered, non-signaling)",null,null],[17,"_CMP_UNORD_S","","Unordered (signaling)",null,null],[17,"_CMP_NEQ_US","","Not-equal (unordered, signaling)",null,null],[17,"_CMP_NLT_UQ","","Not-less-than (unordered, non-signaling)",null,null],[17,"_CMP_NLE_UQ","","Not-less-than-or-equal (unordered, non-signaling)",null,null],[17,"_CMP_ORD_S","","Ordered (signaling)",null,null],[17,"_CMP_EQ_US","","Equal (unordered, signaling)",null,null],[17,"_CMP_NGE_UQ","","Not-greater-than-or-equal (unordered, non-signaling)",null,null],[17,"_CMP_NGT_UQ","","Not-greater-than (unordered, non-signaling)",null,null],[17,"_CMP_FALSE_OS","","False (ordered, signaling)",null,null],[17,"_CMP_NEQ_OS","","Not-equal (ordered, signaling)",null,null],[17,"_CMP_GE_OQ","","Greater-than-or-equal (ordered, non-signaling)",null,null],[17,"_CMP_GT_OQ","","Greater-than (ordered, non-signaling)",null,null],[17,"_CMP_TRUE_US","","True (unordered, signaling)",null,null],[0,"arm","core::arch","Platform-specific intrinsics for the `arm` platform.",null,null],[3,"int8x8_t","core::arch::arm","ARM-specific 64-bit wide vector of eight packed `i8`.",null,null],[3,"uint8x8_t","","ARM-specific 64-bit wide vector of eight packed `u8`.",null,null],[3,"poly8x8_t","","ARM-specific 64-bit wide polynomial vector of eight packed `u8`.",null,null],[3,"int16x4_t","","ARM-specific 64-bit wide vector of four packed `i16`.",null,null],[3,"uint16x4_t","","ARM-specific 64-bit wide vector of four packed `u16`.",null,null],[3,"poly16x4_t","","ARM-specific 64-bit wide vector of four packed `u16`.",null,null],[3,"int32x2_t","","ARM-specific 64-bit wide vector of two packed `i32`.",null,null],[3,"uint32x2_t","","ARM-specific 64-bit wide vector of two packed `u32`.",null,null],[3,"float32x2_t","","ARM-specific 64-bit wide vector of two packed `f32`.",null,null],[3,"int64x1_t","","ARM-specific 64-bit wide vector of one packed `i64`.",null,null],[3,"uint64x1_t","","ARM-specific 64-bit wide vector of one packed `u64`.",null,null],[3,"int8x16_t","","ARM-specific 128-bit wide vector of sixteem packed `i8`.",null,null],[3,"uint8x16_t","","ARM-specific 128-bit wide vector of sixteen packed `u8`.",null,null],[3,"poly8x16_t","","ARM-specific 128-bit wide vector of sixteen packed `u8`.",null,null],[3,"int16x8_t","","ARM-specific 128-bit wide vector of eight packed `i16`.",null,null],[3,"uint16x8_t","","ARM-specific 128-bit wide vector of eight packed `u16`.",null,null],[3,"poly16x8_t","","ARM-specific 128-bit wide vector of eight packed `u16`.",null,null],[3,"int32x4_t","","ARM-specific 128-bit wide vector of four packed `i32`.",null,null],[3,"uint32x4_t","","ARM-specific 128-bit wide vector of four packed `u32`.",null,null],[3,"float32x4_t","","ARM-specific 128-bit wide vector of four packed `f32`.",null,null],[3,"int64x2_t","","ARM-specific 128-bit wide vector of two packed `i64`.",null,null],[3,"uint64x2_t","","ARM-specific 128-bit wide vector of two packed `u64`.",null,null],[5,"_rev_u16","","Reverse the order of the bytes.",null,{"i":[{"n":"u16"}],"o":{"n":"u16"}}],[5,"_rev_u32","","Reverse the order of the bytes.",null,{"i":[{"n":"u32"}],"o":{"n":"u32"}}],[5,"vadd_s8","","Vector add.",null,{"i":[{"n":"int8x8_t"},{"n":"int8x8_t"}],"o":{"n":"int8x8_t"}}],[5,"vaddq_s8","","Vector add.",null,{"i":[{"n":"int8x16_t"},{"n":"int8x16_t"}],"o":{"n":"int8x16_t"}}],[5,"vadd_s16","","Vector add.",null,{"i":[{"n":"int16x4_t"},{"n":"int16x4_t"}],"o":{"n":"int16x4_t"}}],[5,"vaddq_s16","","Vector add.",null,{"i":[{"n":"int16x8_t"},{"n":"int16x8_t"}],"o":{"n":"int16x8_t"}}],[5,"vadd_s32","","Vector add.",null,{"i":[{"n":"int32x2_t"},{"n":"int32x2_t"}],"o":{"n":"int32x2_t"}}],[5,"vaddq_s32","","Vector add.",null,{"i":[{"n":"int32x4_t"},{"n":"int32x4_t"}],"o":{"n":"int32x4_t"}}],[5,"vaddq_s64","","Vector add.",null,{"i":[{"n":"int64x2_t"},{"n":"int64x2_t"}],"o":{"n":"int64x2_t"}}],[5,"vadd_u8","","Vector add.",null,{"i":[{"n":"uint8x8_t"},{"n":"uint8x8_t"}],"o":{"n":"uint8x8_t"}}],[5,"vaddq_u8","","Vector add.",null,{"i":[{"n":"uint8x16_t"},{"n":"uint8x16_t"}],"o":{"n":"uint8x16_t"}}],[5,"vadd_u16","","Vector add.",null,{"i":[{"n":"uint16x4_t"},{"n":"uint16x4_t"}],"o":{"n":"uint16x4_t"}}],[5,"vaddq_u16","","Vector add.",null,{"i":[{"n":"uint16x8_t"},{"n":"uint16x8_t"}],"o":{"n":"uint16x8_t"}}],[5,"vadd_u32","","Vector add.",null,{"i":[{"n":"uint32x2_t"},{"n":"uint32x2_t"}],"o":{"n":"uint32x2_t"}}],[5,"vaddq_u32","","Vector add.",null,{"i":[{"n":"uint32x4_t"},{"n":"uint32x4_t"}],"o":{"n":"uint32x4_t"}}],[5,"vaddq_u64","","Vector add.",null,{"i":[{"n":"uint64x2_t"},{"n":"uint64x2_t"}],"o":{"n":"uint64x2_t"}}],[5,"vadd_f32","","Vector add.",null,{"i":[{"n":"float32x2_t"},{"n":"float32x2_t"}],"o":{"n":"float32x2_t"}}],[5,"vaddq_f32","","Vector add.",null,{"i":[{"n":"float32x4_t"},{"n":"float32x4_t"}],"o":{"n":"float32x4_t"}}],[5,"vaddl_s8","","Vector long add.",null,{"i":[{"n":"int8x8_t"},{"n":"int8x8_t"}],"o":{"n":"int16x8_t"}}],[5,"vaddl_s16","","Vector long add.",null,{"i":[{"n":"int16x4_t"},{"n":"int16x4_t"}],"o":{"n":"int32x4_t"}}],[5,"vaddl_s32","","Vector long add.",null,{"i":[{"n":"int32x2_t"},{"n":"int32x2_t"}],"o":{"n":"int64x2_t"}}],[5,"vaddl_u8","","Vector long add.",null,{"i":[{"n":"uint8x8_t"},{"n":"uint8x8_t"}],"o":{"n":"uint16x8_t"}}],[5,"vaddl_u16","","Vector long add.",null,{"i":[{"n":"uint16x4_t"},{"n":"uint16x4_t"}],"o":{"n":"uint32x4_t"}}],[5,"vaddl_u32","","Vector long add.",null,{"i":[{"n":"uint32x2_t"},{"n":"uint32x2_t"}],"o":{"n":"uint64x2_t"}}],[5,"vmovn_s16","","Vector narrow integer.",null,{"i":[{"n":"int16x8_t"}],"o":{"n":"int8x8_t"}}],[5,"vmovn_s32","","Vector narrow integer.",null,{"i":[{"n":"int32x4_t"}],"o":{"n":"int16x4_t"}}],[5,"vmovn_s64","","Vector narrow integer.",null,{"i":[{"n":"int64x2_t"}],"o":{"n":"int32x2_t"}}],[5,"vmovn_u16","","Vector narrow integer.",null,{"i":[{"n":"uint16x8_t"}],"o":{"n":"uint8x8_t"}}],[5,"vmovn_u32","","Vector narrow integer.",null,{"i":[{"n":"uint32x4_t"}],"o":{"n":"uint16x4_t"}}],[5,"vmovn_u64","","Vector narrow integer.",null,{"i":[{"n":"uint64x2_t"}],"o":{"n":"uint32x2_t"}}],[5,"vmovl_s8","","Vector long move.",null,{"i":[{"n":"int8x8_t"}],"o":{"n":"int16x8_t"}}],[5,"vmovl_s16","","Vector long move.",null,{"i":[{"n":"int16x4_t"}],"o":{"n":"int32x4_t"}}],[5,"vmovl_s32","","Vector long move.",null,{"i":[{"n":"int32x2_t"}],"o":{"n":"int64x2_t"}}],[5,"vmovl_u8","","Vector long move.",null,{"i":[{"n":"uint8x8_t"}],"o":{"n":"uint16x8_t"}}],[5,"vmovl_u16","","Vector long move.",null,{"i":[{"n":"uint16x4_t"}],"o":{"n":"uint32x4_t"}}],[5,"vmovl_u32","","Vector long move.",null,{"i":[{"n":"uint32x2_t"}],"o":{"n":"uint64x2_t"}}],[5,"vrsqrte_f32","","Reciprocal square-root estimate.",null,{"i":[{"n":"float32x2_t"}],"o":{"n":"float32x2_t"}}],[5,"vpmin_s8","","Folding minimum of adjacent pairs",null,{"i":[{"n":"int8x8_t"},{"n":"int8x8_t"}],"o":{"n":"int8x8_t"}}],[5,"vpmin_s16","","Folding minimum of adjacent pairs",null,{"i":[{"n":"int16x4_t"},{"n":"int16x4_t"}],"o":{"n":"int16x4_t"}}],[5,"vpmin_s32","","Folding minimum of adjacent pairs",null,{"i":[{"n":"int32x2_t"},{"n":"int32x2_t"}],"o":{"n":"int32x2_t"}}],[5,"vpmin_u8","","Folding minimum of adjacent pairs",null,{"i":[{"n":"uint8x8_t"},{"n":"uint8x8_t"}],"o":{"n":"uint8x8_t"}}],[5,"vpmin_u16","","Folding minimum of adjacent pairs",null,{"i":[{"n":"uint16x4_t"},{"n":"uint16x4_t"}],"o":{"n":"uint16x4_t"}}],[5,"vpmin_u32","","Folding minimum of adjacent pairs",null,{"i":[{"n":"uint32x2_t"},{"n":"uint32x2_t"}],"o":{"n":"uint32x2_t"}}],[5,"vpmin_f32","","Folding minimum of adjacent pairs",null,{"i":[{"n":"float32x2_t"},{"n":"float32x2_t"}],"o":{"n":"float32x2_t"}}],[5,"vpmax_s8","","Folding maximum of adjacent pairs",null,{"i":[{"n":"int8x8_t"},{"n":"int8x8_t"}],"o":{"n":"int8x8_t"}}],[5,"vpmax_s16","","Folding maximum of adjacent pairs",null,{"i":[{"n":"int16x4_t"},{"n":"int16x4_t"}],"o":{"n":"int16x4_t"}}],[5,"vpmax_s32","","Folding maximum of adjacent pairs",null,{"i":[{"n":"int32x2_t"},{"n":"int32x2_t"}],"o":{"n":"int32x2_t"}}],[5,"vpmax_u8","","Folding maximum of adjacent pairs",null,{"i":[{"n":"uint8x8_t"},{"n":"uint8x8_t"}],"o":{"n":"uint8x8_t"}}],[5,"vpmax_u16","","Folding maximum of adjacent pairs",null,{"i":[{"n":"uint16x4_t"},{"n":"uint16x4_t"}],"o":{"n":"uint16x4_t"}}],[5,"vpmax_u32","","Folding maximum of adjacent pairs",null,{"i":[{"n":"uint32x2_t"},{"n":"uint32x2_t"}],"o":{"n":"uint32x2_t"}}],[5,"vpmax_f32","","Folding maximum of adjacent pairs",null,{"i":[{"n":"float32x2_t"},{"n":"float32x2_t"}],"o":{"n":"float32x2_t"}}],[0,"aarch64","core::arch","Platform-specific intrinsics for the `aarch64` platform.",null,null],[3,"float64x1_t","core::arch::aarch64","ARM-specific 64-bit wide vector of one packed `f64`.",null,null],[3,"float64x2_t","","ARM-specific 128-bit wide vector of two packed `f64`.",null,null],[3,"int8x8_t","","ARM-specific 64-bit wide vector of eight packed `i8`.",null,null],[3,"uint8x8_t","","ARM-specific 64-bit wide vector of eight packed `u8`.",null,null],[3,"poly8x8_t","","ARM-specific 64-bit wide polynomial vector of eight packed `u8`.",null,null],[3,"int16x4_t","","ARM-specific 64-bit wide vector of four packed `i16`.",null,null],[3,"uint16x4_t","","ARM-specific 64-bit wide vector of four packed `u16`.",null,null],[3,"poly16x4_t","","ARM-specific 64-bit wide vector of four packed `u16`.",null,null],[3,"int32x2_t","","ARM-specific 64-bit wide vector of two packed `i32`.",null,null],[3,"uint32x2_t","","ARM-specific 64-bit wide vector of two packed `u32`.",null,null],[3,"float32x2_t","","ARM-specific 64-bit wide vector of two packed `f32`.",null,null],[3,"int64x1_t","","ARM-specific 64-bit wide vector of one packed `i64`.",null,null],[3,"uint64x1_t","","ARM-specific 64-bit wide vector of one packed `u64`.",null,null],[3,"int8x16_t","","ARM-specific 128-bit wide vector of sixteem packed `i8`.",null,null],[3,"uint8x16_t","","ARM-specific 128-bit wide vector of sixteen packed `u8`.",null,null],[3,"poly8x16_t","","ARM-specific 128-bit wide vector of sixteen packed `u8`.",null,null],[3,"int16x8_t","","ARM-specific 128-bit wide vector of eight packed `i16`.",null,null],[3,"uint16x8_t","","ARM-specific 128-bit wide vector of eight packed `u16`.",null,null],[3,"poly16x8_t","","ARM-specific 128-bit wide vector of eight packed `u16`.",null,null],[3,"int32x4_t","","ARM-specific 128-bit wide vector of four packed `i32`.",null,null],[3,"uint32x4_t","","ARM-specific 128-bit wide vector of four packed `u32`.",null,null],[3,"float32x4_t","","ARM-specific 128-bit wide vector of four packed `f32`.",null,null],[3,"int64x2_t","","ARM-specific 128-bit wide vector of two packed `i64`.",null,null],[3,"uint64x2_t","","ARM-specific 128-bit wide vector of two packed `u64`.",null,null],[5,"_rev_u64","","Reverse the order of the bytes.",null,{"i":[{"n":"u64"}],"o":{"n":"u64"}}],[5,"_clz_u64","","Count Leading Zeros.",null,{"i":[{"n":"u64"}],"o":{"n":"u64"}}],[5,"_rbit_u64","","Reverse the bit order.",null,{"i":[{"n":"u64"}],"o":{"n":"u64"}}],[5,"_cls_u32","","Counts the leading most significant bits set.",null,{"i":[{"n":"u32"}],"o":{"n":"u32"}}],[5,"_cls_u64","","Counts the leading most significant bits set.",null,{"i":[{"n":"u64"}],"o":{"n":"u64"}}],[5,"vadd_f64","","Vector add.",null,{"i":[{"n":"float64x1_t"},{"n":"float64x1_t"}],"o":{"n":"float64x1_t"}}],[5,"vaddq_f64","","Vector add.",null,{"i":[{"n":"float64x2_t"},{"n":"float64x2_t"}],"o":{"n":"float64x2_t"}}],[5,"vaddd_s64","","Vector add.",null,{"i":[{"n":"int64x1_t"},{"n":"int64x1_t"}],"o":{"n":"int64x1_t"}}],[5,"vaddd_u64","","Vector add.",null,{"i":[{"n":"uint64x1_t"},{"n":"uint64x1_t"}],"o":{"n":"uint64x1_t"}}],[5,"vmaxv_s8","","Horizontal vector max.",null,{"i":[{"n":"int8x8_t"}],"o":{"n":"i8"}}],[5,"vmaxvq_s8","","Horizontal vector max.",null,{"i":[{"n":"int8x16_t"}],"o":{"n":"i8"}}],[5,"vmaxv_s16","","Horizontal vector max.",null,{"i":[{"n":"int16x4_t"}],"o":{"n":"i16"}}],[5,"vmaxvq_s16","","Horizontal vector max.",null,{"i":[{"n":"int16x8_t"}],"o":{"n":"i16"}}],[5,"vmaxv_s32","","Horizontal vector max.",null,{"i":[{"n":"int32x2_t"}],"o":{"n":"i32"}}],[5,"vmaxvq_s32","","Horizontal vector max.",null,{"i":[{"n":"int32x4_t"}],"o":{"n":"i32"}}],[5,"vmaxv_u8","","Horizontal vector max.",null,{"i":[{"n":"uint8x8_t"}],"o":{"n":"u8"}}],[5,"vmaxvq_u8","","Horizontal vector max.",null,{"i":[{"n":"uint8x16_t"}],"o":{"n":"u8"}}],[5,"vmaxv_u16","","Horizontal vector max.",null,{"i":[{"n":"uint16x4_t"}],"o":{"n":"u16"}}],[5,"vmaxvq_u16","","Horizontal vector max.",null,{"i":[{"n":"uint16x8_t"}],"o":{"n":"u16"}}],[5,"vmaxv_u32","","Horizontal vector max.",null,{"i":[{"n":"uint32x2_t"}],"o":{"n":"u32"}}],[5,"vmaxvq_u32","","Horizontal vector max.",null,{"i":[{"n":"uint32x4_t"}],"o":{"n":"u32"}}],[5,"vmaxv_f32","","Horizontal vector max.",null,{"i":[{"n":"float32x2_t"}],"o":{"n":"f32"}}],[5,"vmaxvq_f32","","Horizontal vector max.",null,{"i":[{"n":"float32x4_t"}],"o":{"n":"f32"}}],[5,"vmaxvq_f64","","Horizontal vector max.",null,{"i":[{"n":"float64x2_t"}],"o":{"n":"f64"}}],[5,"vminv_s8","","Horizontal vector min.",null,{"i":[{"n":"int8x8_t"}],"o":{"n":"i8"}}],[5,"vminvq_s8","","Horizontal vector min.",null,{"i":[{"n":"int8x16_t"}],"o":{"n":"i8"}}],[5,"vminv_s16","","Horizontal vector min.",null,{"i":[{"n":"int16x4_t"}],"o":{"n":"i16"}}],[5,"vminvq_s16","","Horizontal vector min.",null,{"i":[{"n":"int16x8_t"}],"o":{"n":"i16"}}],[5,"vminv_s32","","Horizontal vector min.",null,{"i":[{"n":"int32x2_t"}],"o":{"n":"i32"}}],[5,"vminvq_s32","","Horizontal vector min.",null,{"i":[{"n":"int32x4_t"}],"o":{"n":"i32"}}],[5,"vminv_u8","","Horizontal vector min.",null,{"i":[{"n":"uint8x8_t"}],"o":{"n":"u8"}}],[5,"vminvq_u8","","Horizontal vector min.",null,{"i":[{"n":"uint8x16_t"}],"o":{"n":"u8"}}],[5,"vminv_u16","","Horizontal vector min.",null,{"i":[{"n":"uint16x4_t"}],"o":{"n":"u16"}}],[5,"vminvq_u16","","Horizontal vector min.",null,{"i":[{"n":"uint16x8_t"}],"o":{"n":"u16"}}],[5,"vminv_u32","","Horizontal vector min.",null,{"i":[{"n":"uint32x2_t"}],"o":{"n":"u32"}}],[5,"vminvq_u32","","Horizontal vector min.",null,{"i":[{"n":"uint32x4_t"}],"o":{"n":"u32"}}],[5,"vminv_f32","","Horizontal vector min.",null,{"i":[{"n":"float32x2_t"}],"o":{"n":"f32"}}],[5,"vminvq_f32","","Horizontal vector min.",null,{"i":[{"n":"float32x4_t"}],"o":{"n":"f32"}}],[5,"vminvq_f64","","Horizontal vector min.",null,{"i":[{"n":"float64x2_t"}],"o":{"n":"f64"}}],[5,"vpminq_s8","","Folding minimum of adjacent pairs",null,{"i":[{"n":"int8x16_t"},{"n":"int8x16_t"}],"o":{"n":"int8x16_t"}}],[5,"vpminq_s16","","Folding minimum of adjacent pairs",null,{"i":[{"n":"int16x8_t"},{"n":"int16x8_t"}],"o":{"n":"int16x8_t"}}],[5,"vpminq_s32","","Folding minimum of adjacent pairs",null,{"i":[{"n":"int32x4_t"},{"n":"int32x4_t"}],"o":{"n":"int32x4_t"}}],[5,"vpminq_u8","","Folding minimum of adjacent pairs",null,{"i":[{"n":"uint8x16_t"},{"n":"uint8x16_t"}],"o":{"n":"uint8x16_t"}}],[5,"vpminq_u16","","Folding minimum of adjacent pairs",null,{"i":[{"n":"uint16x8_t"},{"n":"uint16x8_t"}],"o":{"n":"uint16x8_t"}}],[5,"vpminq_u32","","Folding minimum of adjacent pairs",null,{"i":[{"n":"uint32x4_t"},{"n":"uint32x4_t"}],"o":{"n":"uint32x4_t"}}],[5,"vpminq_f32","","Folding minimum of adjacent pairs",null,{"i":[{"n":"float32x4_t"},{"n":"float32x4_t"}],"o":{"n":"float32x4_t"}}],[5,"vpminq_f64","","Folding minimum of adjacent pairs",null,{"i":[{"n":"float64x2_t"},{"n":"float64x2_t"}],"o":{"n":"float64x2_t"}}],[5,"vpmaxq_s8","","Folding maximum of adjacent pairs",null,{"i":[{"n":"int8x16_t"},{"n":"int8x16_t"}],"o":{"n":"int8x16_t"}}],[5,"vpmaxq_s16","","Folding maximum of adjacent pairs",null,{"i":[{"n":"int16x8_t"},{"n":"int16x8_t"}],"o":{"n":"int16x8_t"}}],[5,"vpmaxq_s32","","Folding maximum of adjacent pairs",null,{"i":[{"n":"int32x4_t"},{"n":"int32x4_t"}],"o":{"n":"int32x4_t"}}],[5,"vpmaxq_u8","","Folding maximum of adjacent pairs",null,{"i":[{"n":"uint8x16_t"},{"n":"uint8x16_t"}],"o":{"n":"uint8x16_t"}}],[5,"vpmaxq_u16","","Folding maximum of adjacent pairs",null,{"i":[{"n":"uint16x8_t"},{"n":"uint16x8_t"}],"o":{"n":"uint16x8_t"}}],[5,"vpmaxq_u32","","Folding maximum of adjacent pairs",null,{"i":[{"n":"uint32x4_t"},{"n":"uint32x4_t"}],"o":{"n":"uint32x4_t"}}],[5,"vpmaxq_f32","","Folding maximum of adjacent pairs",null,{"i":[{"n":"float32x4_t"},{"n":"float32x4_t"}],"o":{"n":"float32x4_t"}}],[5,"vpmaxq_f64","","Folding maximum of adjacent pairs",null,{"i":[{"n":"float64x2_t"},{"n":"float64x2_t"}],"o":{"n":"float64x2_t"}}],[5,"vaeseq_u8","","AES single round encryption.",null,{"i":[{"n":"uint8x16_t"},{"n":"uint8x16_t"}],"o":{"n":"uint8x16_t"}}],[5,"vaesdq_u8","","AES single round decryption.",null,{"i":[{"n":"uint8x16_t"},{"n":"uint8x16_t"}],"o":{"n":"uint8x16_t"}}],[5,"vaesmcq_u8","","AES mix columns.",null,{"i":[{"n":"uint8x16_t"}],"o":{"n":"uint8x16_t"}}],[5,"vaesimcq_u8","","AES inverse mix columns.",null,{"i":[{"n":"uint8x16_t"}],"o":{"n":"uint8x16_t"}}],[5,"vsha1h_u32","","SHA1 fixed rotate.",null,{"i":[{"n":"u32"}],"o":{"n":"u32"}}],[5,"vsha1cq_u32","","SHA1 hash update accelerator, choose.",null,{"i":[{"n":"uint32x4_t"},{"n":"u32"},{"n":"uint32x4_t"}],"o":{"n":"uint32x4_t"}}],[5,"vsha1mq_u32","","SHA1 hash update accelerator, majority.",null,{"i":[{"n":"uint32x4_t"},{"n":"u32"},{"n":"uint32x4_t"}],"o":{"n":"uint32x4_t"}}],[5,"vsha1pq_u32","","SHA1 hash update accelerator, parity.",null,{"i":[{"n":"uint32x4_t"},{"n":"u32"},{"n":"uint32x4_t"}],"o":{"n":"uint32x4_t"}}],[5,"vsha1su0q_u32","","SHA1 schedule update accelerator, first part.",null,{"i":[{"n":"uint32x4_t"},{"n":"uint32x4_t"},{"n":"uint32x4_t"}],"o":{"n":"uint32x4_t"}}],[5,"vsha1su1q_u32","","SHA1 schedule update accelerator, second part.",null,{"i":[{"n":"uint32x4_t"},{"n":"uint32x4_t"}],"o":{"n":"uint32x4_t"}}],[5,"vsha256hq_u32","","SHA256 hash update accelerator.",null,{"i":[{"n":"uint32x4_t"},{"n":"uint32x4_t"},{"n":"uint32x4_t"}],"o":{"n":"uint32x4_t"}}],[5,"vsha256h2q_u32","","SHA256 hash update accelerator, upper part.",null,{"i":[{"n":"uint32x4_t"},{"n":"uint32x4_t"},{"n":"uint32x4_t"}],"o":{"n":"uint32x4_t"}}],[5,"vsha256su0q_u32","","SHA256 schedule update accelerator, first part.",null,{"i":[{"n":"uint32x4_t"},{"n":"uint32x4_t"}],"o":{"n":"uint32x4_t"}}],[5,"vsha256su1q_u32","","SHA256 schedule update accelerator, second part.",null,{"i":[{"n":"uint32x4_t"},{"n":"uint32x4_t"},{"n":"uint32x4_t"}],"o":{"n":"uint32x4_t"}}],[5,"_rev_u16","","Reverse the order of the bytes.",null,{"i":[{"n":"u16"}],"o":{"n":"u16"}}],[5,"_rev_u32","","Reverse the order of the bytes.",null,{"i":[{"n":"u32"}],"o":{"n":"u32"}}],[5,"vadd_s8","","Vector add.",null,{"i":[{"n":"int8x8_t"},{"n":"int8x8_t"}],"o":{"n":"int8x8_t"}}],[5,"vaddq_s8","","Vector add.",null,{"i":[{"n":"int8x16_t"},{"n":"int8x16_t"}],"o":{"n":"int8x16_t"}}],[5,"vadd_s16","","Vector add.",null,{"i":[{"n":"int16x4_t"},{"n":"int16x4_t"}],"o":{"n":"int16x4_t"}}],[5,"vaddq_s16","","Vector add.",null,{"i":[{"n":"int16x8_t"},{"n":"int16x8_t"}],"o":{"n":"int16x8_t"}}],[5,"vadd_s32","","Vector add.",null,{"i":[{"n":"int32x2_t"},{"n":"int32x2_t"}],"o":{"n":"int32x2_t"}}],[5,"vaddq_s32","","Vector add.",null,{"i":[{"n":"int32x4_t"},{"n":"int32x4_t"}],"o":{"n":"int32x4_t"}}],[5,"vaddq_s64","","Vector add.",null,{"i":[{"n":"int64x2_t"},{"n":"int64x2_t"}],"o":{"n":"int64x2_t"}}],[5,"vadd_u8","","Vector add.",null,{"i":[{"n":"uint8x8_t"},{"n":"uint8x8_t"}],"o":{"n":"uint8x8_t"}}],[5,"vaddq_u8","","Vector add.",null,{"i":[{"n":"uint8x16_t"},{"n":"uint8x16_t"}],"o":{"n":"uint8x16_t"}}],[5,"vadd_u16","","Vector add.",null,{"i":[{"n":"uint16x4_t"},{"n":"uint16x4_t"}],"o":{"n":"uint16x4_t"}}],[5,"vaddq_u16","","Vector add.",null,{"i":[{"n":"uint16x8_t"},{"n":"uint16x8_t"}],"o":{"n":"uint16x8_t"}}],[5,"vadd_u32","","Vector add.",null,{"i":[{"n":"uint32x2_t"},{"n":"uint32x2_t"}],"o":{"n":"uint32x2_t"}}],[5,"vaddq_u32","","Vector add.",null,{"i":[{"n":"uint32x4_t"},{"n":"uint32x4_t"}],"o":{"n":"uint32x4_t"}}],[5,"vaddq_u64","","Vector add.",null,{"i":[{"n":"uint64x2_t"},{"n":"uint64x2_t"}],"o":{"n":"uint64x2_t"}}],[5,"vadd_f32","","Vector add.",null,{"i":[{"n":"float32x2_t"},{"n":"float32x2_t"}],"o":{"n":"float32x2_t"}}],[5,"vaddq_f32","","Vector add.",null,{"i":[{"n":"float32x4_t"},{"n":"float32x4_t"}],"o":{"n":"float32x4_t"}}],[5,"vaddl_s8","","Vector long add.",null,{"i":[{"n":"int8x8_t"},{"n":"int8x8_t"}],"o":{"n":"int16x8_t"}}],[5,"vaddl_s16","","Vector long add.",null,{"i":[{"n":"int16x4_t"},{"n":"int16x4_t"}],"o":{"n":"int32x4_t"}}],[5,"vaddl_s32","","Vector long add.",null,{"i":[{"n":"int32x2_t"},{"n":"int32x2_t"}],"o":{"n":"int64x2_t"}}],[5,"vaddl_u8","","Vector long add.",null,{"i":[{"n":"uint8x8_t"},{"n":"uint8x8_t"}],"o":{"n":"uint16x8_t"}}],[5,"vaddl_u16","","Vector long add.",null,{"i":[{"n":"uint16x4_t"},{"n":"uint16x4_t"}],"o":{"n":"uint32x4_t"}}],[5,"vaddl_u32","","Vector long add.",null,{"i":[{"n":"uint32x2_t"},{"n":"uint32x2_t"}],"o":{"n":"uint64x2_t"}}],[5,"vmovn_s16","","Vector narrow integer.",null,{"i":[{"n":"int16x8_t"}],"o":{"n":"int8x8_t"}}],[5,"vmovn_s32","","Vector narrow integer.",null,{"i":[{"n":"int32x4_t"}],"o":{"n":"int16x4_t"}}],[5,"vmovn_s64","","Vector narrow integer.",null,{"i":[{"n":"int64x2_t"}],"o":{"n":"int32x2_t"}}],[5,"vmovn_u16","","Vector narrow integer.",null,{"i":[{"n":"uint16x8_t"}],"o":{"n":"uint8x8_t"}}],[5,"vmovn_u32","","Vector narrow integer.",null,{"i":[{"n":"uint32x4_t"}],"o":{"n":"uint16x4_t"}}],[5,"vmovn_u64","","Vector narrow integer.",null,{"i":[{"n":"uint64x2_t"}],"o":{"n":"uint32x2_t"}}],[5,"vmovl_s8","","Vector long move.",null,{"i":[{"n":"int8x8_t"}],"o":{"n":"int16x8_t"}}],[5,"vmovl_s16","","Vector long move.",null,{"i":[{"n":"int16x4_t"}],"o":{"n":"int32x4_t"}}],[5,"vmovl_s32","","Vector long move.",null,{"i":[{"n":"int32x2_t"}],"o":{"n":"int64x2_t"}}],[5,"vmovl_u8","","Vector long move.",null,{"i":[{"n":"uint8x8_t"}],"o":{"n":"uint16x8_t"}}],[5,"vmovl_u16","","Vector long move.",null,{"i":[{"n":"uint16x4_t"}],"o":{"n":"uint32x4_t"}}],[5,"vmovl_u32","","Vector long move.",null,{"i":[{"n":"uint32x2_t"}],"o":{"n":"uint64x2_t"}}],[5,"vrsqrte_f32","","Reciprocal square-root estimate.",null,{"i":[{"n":"float32x2_t"}],"o":{"n":"float32x2_t"}}],[5,"vpmin_s8","","Folding minimum of adjacent pairs",null,{"i":[{"n":"int8x8_t"},{"n":"int8x8_t"}],"o":{"n":"int8x8_t"}}],[5,"vpmin_s16","","Folding minimum of adjacent pairs",null,{"i":[{"n":"int16x4_t"},{"n":"int16x4_t"}],"o":{"n":"int16x4_t"}}],[5,"vpmin_s32","","Folding minimum of adjacent pairs",null,{"i":[{"n":"int32x2_t"},{"n":"int32x2_t"}],"o":{"n":"int32x2_t"}}],[5,"vpmin_u8","","Folding minimum of adjacent pairs",null,{"i":[{"n":"uint8x8_t"},{"n":"uint8x8_t"}],"o":{"n":"uint8x8_t"}}],[5,"vpmin_u16","","Folding minimum of adjacent pairs",null,{"i":[{"n":"uint16x4_t"},{"n":"uint16x4_t"}],"o":{"n":"uint16x4_t"}}],[5,"vpmin_u32","","Folding minimum of adjacent pairs",null,{"i":[{"n":"uint32x2_t"},{"n":"uint32x2_t"}],"o":{"n":"uint32x2_t"}}],[5,"vpmin_f32","","Folding minimum of adjacent pairs",null,{"i":[{"n":"float32x2_t"},{"n":"float32x2_t"}],"o":{"n":"float32x2_t"}}],[5,"vpmax_s8","","Folding maximum of adjacent pairs",null,{"i":[{"n":"int8x8_t"},{"n":"int8x8_t"}],"o":{"n":"int8x8_t"}}],[5,"vpmax_s16","","Folding maximum of adjacent pairs",null,{"i":[{"n":"int16x4_t"},{"n":"int16x4_t"}],"o":{"n":"int16x4_t"}}],[5,"vpmax_s32","","Folding maximum of adjacent pairs",null,{"i":[{"n":"int32x2_t"},{"n":"int32x2_t"}],"o":{"n":"int32x2_t"}}],[5,"vpmax_u8","","Folding maximum of adjacent pairs",null,{"i":[{"n":"uint8x8_t"},{"n":"uint8x8_t"}],"o":{"n":"uint8x8_t"}}],[5,"vpmax_u16","","Folding maximum of adjacent pairs",null,{"i":[{"n":"uint16x4_t"},{"n":"uint16x4_t"}],"o":{"n":"uint16x4_t"}}],[5,"vpmax_u32","","Folding maximum of adjacent pairs",null,{"i":[{"n":"uint32x2_t"},{"n":"uint32x2_t"}],"o":{"n":"uint32x2_t"}}],[5,"vpmax_f32","","Folding maximum of adjacent pairs",null,{"i":[{"n":"float32x2_t"},{"n":"float32x2_t"}],"o":{"n":"float32x2_t"}}],[0,"mips","core::arch","Platform-specific intrinsics for the `mips` platform.",null,null],[5,"__msa_add_a_b","core::arch::mips","Vector Add Absolute Values.",null,{"i":[{"n":"i8x16"},{"n":"i8x16"}],"o":{"n":"i8x16"}}],[0,"mips64","core::arch","Platform-specific intrinsics for the `mips64` platform.",null,null],[5,"__msa_add_a_b","core::arch::mips64","Vector Add Absolute Values.",null,{"i":[{"n":"i8x16"},{"n":"i8x16"}],"o":{"n":"i8x16"}}],[14,"panic","core","Entry point of thread panic, for details, see std::macros",null,null],[14,"assert_eq","","Asserts that two expressions are equal to each other (using [`PartialEq`]).",null,null],[14,"assert_ne","","Asserts that two expressions are not equal to each other (using [`PartialEq`]).",null,null],[14,"debug_assert","","Ensure that a boolean expression is `true` at runtime.",null,null],[14,"debug_assert_eq","","Asserts that two expressions are equal to each other.",null,null],[14,"debug_assert_ne","","Asserts that two expressions are not equal to each other.",null,null],[14,"try","","Helper macro for reducing boilerplate code for matching `Result` together with converting downstream errors.",null,null],[14,"write","","Write formatted data into a buffer.",null,null],[14,"writeln","","Write formatted data into a buffer, with a newline appended.",null,null],[14,"unreachable","","A utility macro for indicating unreachable code.",null,null],[14,"unimplemented","","A standardized placeholder for marking unfinished code.",null,null],[14,"compile_error","","Unconditionally causes compilation to fail with the given error message when encountered.",null,null],[14,"format_args","","The core macro for formatted string creation & output.",null,null],[14,"env","","Inspect an environment variable at compile time.",null,null],[14,"option_env","","Optionally inspect an environment variable at compile time.",null,null],[14,"concat_idents","","Concatenate identifiers into one identifier.",null,null],[14,"concat","","Concatenates literals into a static string slice.",null,null],[14,"line","","A macro which expands to the line number on which it was invoked.",null,null],[14,"column","","A macro which expands to the column number on which it was invoked.",null,null],[14,"file","","A macro which expands to the file name from which it was invoked.",null,null],[14,"stringify","","A macro which stringifies its arguments.",null,null],[14,"include_str","","Includes a utf8-encoded file as a string.",null,null],[14,"include_bytes","","Includes a file as a reference to a byte array.",null,null],[14,"module_path","","Expands to a string that represents the current module path.",null,null],[14,"cfg","","Boolean evaluation of configuration flags, at compile-time.",null,null],[14,"include","","Parse a file as an expression or an item according to the context.",null,null],[14,"assert","","Ensure that a boolean expression is `true` at runtime.",null,null],[11,"contains","core::ops","Returns `true` if `item` is contained in the range.",55,{"i":[{"n":"self"},{"n":"u"}],"o":{"n":"bool"}}],[11,"size_hint","core::iter","Returns the bounds on the remaining length of the iterator.",116,null],[11,"count","","Consumes the iterator, counting the number of iterations and returning it.",116,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"last","","Consumes the iterator, returning the last element.",116,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"nth","","Returns the `n`th element of the iterator.",116,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"option"}}],[11,"step_by","","Creates an iterator starting at the same point, but stepping by the given amount at each iteration.",116,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"stepby"}}],[11,"chain","","Takes two iterators and creates a new iterator over both in sequence.",116,{"i":[{"n":"self"},{"n":"u"}],"o":{"n":"chain"}}],[11,"zip","","'Zips up' two iterators into a single iterator of pairs.",116,{"i":[{"n":"self"},{"n":"u"}],"o":{"n":"zip"}}],[11,"map","","Takes a closure and creates an iterator which calls that closure on each element.",116,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"map"}}],[11,"for_each","","Calls a closure on each element of an iterator.",116,{"i":[{"n":"self"},{"n":"f"}]}],[11,"filter","","Creates an iterator which uses a closure to determine if an element should be yielded.",116,{"i":[{"n":"self"},{"n":"p"}],"o":{"n":"filter"}}],[11,"filter_map","","Creates an iterator that both filters and maps.",116,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"filtermap"}}],[11,"enumerate","","Creates an iterator which gives the current iteration count as well as the next value.",116,{"i":[{"n":"self"}],"o":{"n":"enumerate"}}],[11,"peekable","","Creates an iterator which can use `peek` to look at the next element of the iterator without consuming it.",116,{"i":[{"n":"self"}],"o":{"n":"peekable"}}],[11,"skip_while","","Creates an iterator that [`skip`]s elements based on a predicate.",116,{"i":[{"n":"self"},{"n":"p"}],"o":{"n":"skipwhile"}}],[11,"take_while","","Creates an iterator that yields elements based on a predicate.",116,{"i":[{"n":"self"},{"n":"p"}],"o":{"n":"takewhile"}}],[11,"skip","","Creates an iterator that skips the first `n` elements.",116,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"skip"}}],[11,"take","","Creates an iterator that yields its first `n` elements.",116,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"take"}}],[11,"scan","","An iterator adaptor similar to [`fold`] that holds internal state and produces a new iterator.",116,{"i":[{"n":"self"},{"n":"st"},{"n":"f"}],"o":{"n":"scan"}}],[11,"flat_map","","Creates an iterator that works like map, but flattens nested structure.",116,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"flatmap"}}],[11,"flatten","","Creates an iterator that flattens nested structure.",116,{"i":[{"n":"self"}],"o":{"n":"flatten"}}],[11,"fuse","","Creates an iterator which ends after the first [`None`].",116,{"i":[{"n":"self"}],"o":{"n":"fuse"}}],[11,"inspect","","Do something with each element of an iterator, passing the value on.",116,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"inspect"}}],[11,"by_ref","","Borrows an iterator, rather than consuming it.",116,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"collect","","Transforms an iterator into a collection.",116,{"i":[{"n":"self"}],"o":{"n":"b"}}],[11,"partition","","Consumes an iterator, creating two collections from it.",116,null],[11,"try_fold","","An iterator method that applies a function as long as it returns successfully, producing a single, final value.",116,{"i":[{"n":"self"},{"n":"b"},{"n":"f"}],"o":{"n":"r"}}],[11,"try_for_each","","An iterator method that applies a fallible function to each item in the iterator, stopping at the first error and returning that error.",116,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"r"}}],[11,"fold","","An iterator method that applies a function, producing a single, final value.",116,{"i":[{"n":"self"},{"n":"b"},{"n":"f"}],"o":{"n":"b"}}],[11,"all","","Tests if every element of the iterator matches a predicate.",116,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"bool"}}],[11,"any","","Tests if any element of the iterator matches a predicate.",116,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"bool"}}],[11,"find","","Searches for an element of an iterator that satisfies a predicate.",116,{"i":[{"n":"self"},{"n":"p"}],"o":{"n":"option"}}],[11,"find_map","","Applies function to the elements of iterator and returns the first non-none result.",116,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"option"}}],[11,"position","","Searches for an element in an iterator, returning its index.",116,{"i":[{"n":"self"},{"n":"p"}],"o":{"g":["usize"],"n":"option"}}],[11,"rposition","","Searches for an element in an iterator from the right, returning its index.",116,{"i":[{"n":"self"},{"n":"p"}],"o":{"g":["usize"],"n":"option"}}],[11,"max","","Returns the maximum element of an iterator.",116,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"min","","Returns the minimum element of an iterator.",116,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"max_by_key","","Returns the element that gives the maximum value from the specified function.",116,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"option"}}],[11,"max_by","","Returns the element that gives the maximum value with respect to the specified comparison function.",116,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"option"}}],[11,"min_by_key","","Returns the element that gives the minimum value from the specified function.",116,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"option"}}],[11,"min_by","","Returns the element that gives the minimum value with respect to the specified comparison function.",116,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"option"}}],[11,"rev","","Reverses an iterator's direction.",116,{"i":[{"n":"self"}],"o":{"n":"rev"}}],[11,"unzip","","Converts an iterator of pairs into a pair of containers.",116,null],[11,"cloned","","Creates an iterator which [`clone`]s all of its elements.",116,{"i":[{"n":"self"}],"o":{"n":"cloned"}}],[11,"cycle","","Repeats an iterator endlessly.",116,{"i":[{"n":"self"}],"o":{"n":"cycle"}}],[11,"sum","","Sums the elements of an iterator.",116,{"i":[{"n":"self"}],"o":{"n":"s"}}],[11,"product","","Iterates over the entire iterator, multiplying all the elements",116,{"i":[{"n":"self"}],"o":{"n":"p"}}],[11,"cmp","","Lexicographically compares the elements of this `Iterator` with those of another.",116,{"i":[{"n":"self"},{"n":"i"}],"o":{"n":"ordering"}}],[11,"partial_cmp","","Lexicographically compares the elements of this `Iterator` with those of another.",116,{"i":[{"n":"self"},{"n":"i"}],"o":{"g":["ordering"],"n":"option"}}],[11,"eq","","Determines if the elements of this `Iterator` are equal to those of another.",116,{"i":[{"n":"self"},{"n":"i"}],"o":{"n":"bool"}}],[11,"ne","","Determines if the elements of this `Iterator` are unequal to those of another.",116,{"i":[{"n":"self"},{"n":"i"}],"o":{"n":"bool"}}],[11,"lt","","Determines if the elements of this `Iterator` are lexicographically less than those of another.",116,{"i":[{"n":"self"},{"n":"i"}],"o":{"n":"bool"}}],[11,"le","","Determines if the elements of this `Iterator` are lexicographically less or equal to those of another.",116,{"i":[{"n":"self"},{"n":"i"}],"o":{"n":"bool"}}],[11,"gt","","Determines if the elements of this `Iterator` are lexicographically greater than those of another.",116,{"i":[{"n":"self"},{"n":"i"}],"o":{"n":"bool"}}],[11,"ge","","Determines if the elements of this `Iterator` are lexicographically greater than or equal to those of another.",116,{"i":[{"n":"self"},{"n":"i"}],"o":{"n":"bool"}}],[11,"try_rfold","","This is the reverse version of [`try_fold()`]: it takes elements starting from the back of the iterator.",120,{"i":[{"n":"self"},{"n":"b"},{"n":"f"}],"o":{"n":"r"}}],[11,"rfold","","An iterator method that reduces the iterator's elements to a single, final value, starting from the back.",120,{"i":[{"n":"self"},{"n":"b"},{"n":"f"}],"o":{"n":"b"}}],[11,"rfind","","Searches for an element of an iterator from the back that satisfies a predicate.",120,{"i":[{"n":"self"},{"n":"p"}],"o":{"n":"option"}}],[11,"len","","Returns the exact number of times the iterator will iterate.",122,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"is_empty","","Returns whether the iterator is empty.",122,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"sum","core::result","Takes each element in the `Iterator`: if it is an `Err`, no further elements are taken, and the `Err` is returned. Should no `Err` occur, the sum of all elements is returned.",151,{"i":[{"n":"i"}],"o":{"n":"result"}}],[11,"product","","Takes each element in the `Iterator`: if it is an `Err`, no further elements are taken, and the `Err` is returned. Should no `Err` occur, the product of all elements is returned.",151,{"i":[{"n":"i"}],"o":{"n":"result"}}],[11,"clone","core::simd","",249,{"i":[{"n":"self"}],"o":{"n":"i8x16"}}],[11,"fmt","","",249,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"partial_cmp","","",249,{"i":[{"n":"self"},{"n":"i8x16"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",249,{"i":[{"n":"self"},{"n":"i8x16"}],"o":{"n":"bool"}}],[11,"le","","",249,{"i":[{"n":"self"},{"n":"i8x16"}],"o":{"n":"bool"}}],[11,"gt","","",249,{"i":[{"n":"self"},{"n":"i8x16"}],"o":{"n":"bool"}}],[11,"ge","","",249,{"i":[{"n":"self"},{"n":"i8x16"}],"o":{"n":"bool"}}],[11,"new","","Creates a new instance with each vector elements initialized with the provided values.",249,{"i":[{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"},{"n":"i8"}],"o":{"n":"self"}}],[11,"lanes","","Returns the number of vector lanes.",249,{"o":{"n":"usize"}}],[11,"splat","","Constructs a new instance with each element initialized to `value`.",249,{"i":[{"n":"i8"}],"o":{"n":"self"}}],[11,"extract","","Extracts the value at `index`.",249,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"i8"}}],[11,"extract_unchecked","","Extracts the value at `index`.",249,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"i8"}}],[11,"replace","","Returns a new vector where the value at `index` is replaced by `new_value`.",249,{"i":[{"n":"self"},{"n":"usize"},{"n":"i8"}],"o":{"n":"self"}}],[11,"replace_unchecked","","Returns a new vector where the value at `index` is replaced by `new_value`.",249,{"i":[{"n":"self"},{"n":"usize"},{"n":"i8"}],"o":{"n":"self"}}],[11,"store_aligned","","Writes the values of the vector to the `slice`.",249,null],[11,"store_unaligned","","Writes the values of the vector to the `slice`.",249,null],[11,"store_aligned_unchecked","","Writes the values of the vector to the `slice`.",249,null],[11,"store_unaligned_unchecked","","Writes the values of the vector to the `slice`.",249,null],[11,"load_aligned","","Instantiates a new vector with the values of the `slice`.",249,null],[11,"load_unaligned","","Instantiates a new vector with the values of the `slice`.",249,null],[11,"load_aligned_unchecked","","Instantiates a new vector with the values of the `slice`.",249,null],[11,"load_unaligned_unchecked","","Instantiates a new vector with the values of the `slice`.",249,null],[11,"eq","","Lane-wise equality comparison.",249,{"i":[{"n":"self"},{"n":"i8x16"}],"o":{"n":"m8x16"}}],[11,"ne","","Lane-wise inequality comparison.",249,{"i":[{"n":"self"},{"n":"i8x16"}],"o":{"n":"m8x16"}}],[11,"lt","","Lane-wise less-than comparison.",249,{"i":[{"n":"self"},{"n":"i8x16"}],"o":{"n":"m8x16"}}],[11,"le","","Lane-wise less-than-or-equals comparison.",249,{"i":[{"n":"self"},{"n":"i8x16"}],"o":{"n":"m8x16"}}],[11,"gt","","Lane-wise greater-than comparison.",249,{"i":[{"n":"self"},{"n":"i8x16"}],"o":{"n":"m8x16"}}],[11,"ge","","Lane-wise greater-than-or-equals comparison.",249,{"i":[{"n":"self"},{"n":"i8x16"}],"o":{"n":"m8x16"}}],[11,"hash","","",249,{"i":[{"n":"self"},{"n":"h"}]}],[11,"add","","",249,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"sub","","",249,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"mul","","",249,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"div","","",249,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"rem","","",249,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"add_assign","","",249,{"i":[{"n":"self"},{"n":"self"}]}],[11,"sub_assign","","",249,{"i":[{"n":"self"},{"n":"self"}]}],[11,"mul_assign","","",249,{"i":[{"n":"self"},{"n":"self"}]}],[11,"div_assign","","",249,{"i":[{"n":"self"},{"n":"self"}]}],[11,"rem_assign","","",249,{"i":[{"n":"self"},{"n":"self"}]}],[11,"add","","",249,{"i":[{"n":"self"},{"n":"i8"}],"o":{"n":"self"}}],[11,"sub","","",249,{"i":[{"n":"self"},{"n":"i8"}],"o":{"n":"self"}}],[11,"mul","","",249,{"i":[{"n":"self"},{"n":"i8"}],"o":{"n":"self"}}],[11,"div","","",249,{"i":[{"n":"self"},{"n":"i8"}],"o":{"n":"self"}}],[11,"rem","","",249,{"i":[{"n":"self"},{"n":"i8"}],"o":{"n":"self"}}],[11,"add_assign","","",249,{"i":[{"n":"self"},{"n":"i8"}]}],[11,"sub_assign","","",249,{"i":[{"n":"self"},{"n":"i8"}]}],[11,"mul_assign","","",249,{"i":[{"n":"self"},{"n":"i8"}]}],[11,"div_assign","","",249,{"i":[{"n":"self"},{"n":"i8"}]}],[11,"rem_assign","","",249,{"i":[{"n":"self"},{"n":"i8"}]}],[11,"wrapping_sum","","Horizontal sum of the vector elements.",249,{"i":[{"n":"self"}],"o":{"n":"i8"}}],[11,"wrapping_product","","Horizontal product of the vector elements.",249,{"i":[{"n":"self"}],"o":{"n":"i8"}}],[11,"max_element","","Largest vector element value.",249,{"i":[{"n":"self"}],"o":{"n":"i8"}}],[11,"min_element","","Smallest vector element value.",249,{"i":[{"n":"self"}],"o":{"n":"i8"}}],[11,"neg","","",249,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"not","","",249,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"bitxor","","",249,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"bitand","","",249,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"bitor","","",249,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"bitand_assign","","",249,{"i":[{"n":"self"},{"n":"self"}]}],[11,"bitor_assign","","",249,{"i":[{"n":"self"},{"n":"self"}]}],[11,"bitxor_assign","","",249,{"i":[{"n":"self"},{"n":"self"}]}],[11,"bitxor","","",249,{"i":[{"n":"self"},{"n":"i8"}],"o":{"n":"self"}}],[11,"bitand","","",249,{"i":[{"n":"self"},{"n":"i8"}],"o":{"n":"self"}}],[11,"bitor","","",249,{"i":[{"n":"self"},{"n":"i8"}],"o":{"n":"self"}}],[11,"bitand_assign","","",249,{"i":[{"n":"self"},{"n":"i8"}]}],[11,"bitor_assign","","",249,{"i":[{"n":"self"},{"n":"i8"}]}],[11,"bitxor_assign","","",249,{"i":[{"n":"self"},{"n":"i8"}]}],[11,"and","","Lane-wise bitwise `and` of the vector elements.",249,{"i":[{"n":"self"}],"o":{"n":"i8"}}],[11,"or","","Lane-wise bitwise `or` of the vector elements.",249,{"i":[{"n":"self"}],"o":{"n":"i8"}}],[11,"xor","","Lane-wise bitwise `xor` of the vector elements.",249,{"i":[{"n":"self"}],"o":{"n":"i8"}}],[11,"shl","","",249,{"i":[{"n":"self"},{"n":"u8"}],"o":{"n":"self"}}],[11,"shr","","",249,{"i":[{"n":"self"},{"n":"u8"}],"o":{"n":"self"}}],[11,"shl_assign","","",249,{"i":[{"n":"self"},{"n":"u8"}]}],[11,"shr_assign","","",249,{"i":[{"n":"self"},{"n":"u8"}]}],[11,"shl","","",249,{"i":[{"n":"self"},{"n":"u16"}],"o":{"n":"self"}}],[11,"shr","","",249,{"i":[{"n":"self"},{"n":"u16"}],"o":{"n":"self"}}],[11,"shl_assign","","",249,{"i":[{"n":"self"},{"n":"u16"}]}],[11,"shr_assign","","",249,{"i":[{"n":"self"},{"n":"u16"}]}],[11,"shl","","",249,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"self"}}],[11,"shr","","",249,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"self"}}],[11,"shl_assign","","",249,{"i":[{"n":"self"},{"n":"u32"}]}],[11,"shr_assign","","",249,{"i":[{"n":"self"},{"n":"u32"}]}],[11,"shl","","",249,{"i":[{"n":"self"},{"n":"u64"}],"o":{"n":"self"}}],[11,"shr","","",249,{"i":[{"n":"self"},{"n":"u64"}],"o":{"n":"self"}}],[11,"shl_assign","","",249,{"i":[{"n":"self"},{"n":"u64"}]}],[11,"shr_assign","","",249,{"i":[{"n":"self"},{"n":"u64"}]}],[11,"shl","","",249,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"self"}}],[11,"shr","","",249,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"self"}}],[11,"shl_assign","","",249,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shr_assign","","",249,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shl","","",249,{"i":[{"n":"self"},{"n":"i8"}],"o":{"n":"self"}}],[11,"shr","","",249,{"i":[{"n":"self"},{"n":"i8"}],"o":{"n":"self"}}],[11,"shl_assign","","",249,{"i":[{"n":"self"},{"n":"i8"}]}],[11,"shr_assign","","",249,{"i":[{"n":"self"},{"n":"i8"}]}],[11,"shl","","",249,{"i":[{"n":"self"},{"n":"i16"}],"o":{"n":"self"}}],[11,"shr","","",249,{"i":[{"n":"self"},{"n":"i16"}],"o":{"n":"self"}}],[11,"shl_assign","","",249,{"i":[{"n":"self"},{"n":"i16"}]}],[11,"shr_assign","","",249,{"i":[{"n":"self"},{"n":"i16"}]}],[11,"shl","","",249,{"i":[{"n":"self"},{"n":"i32"}],"o":{"n":"self"}}],[11,"shr","","",249,{"i":[{"n":"self"},{"n":"i32"}],"o":{"n":"self"}}],[11,"shl_assign","","",249,{"i":[{"n":"self"},{"n":"i32"}]}],[11,"shr_assign","","",249,{"i":[{"n":"self"},{"n":"i32"}]}],[11,"shl","","",249,{"i":[{"n":"self"},{"n":"i64"}],"o":{"n":"self"}}],[11,"shr","","",249,{"i":[{"n":"self"},{"n":"i64"}],"o":{"n":"self"}}],[11,"shl_assign","","",249,{"i":[{"n":"self"},{"n":"i64"}]}],[11,"shr_assign","","",249,{"i":[{"n":"self"},{"n":"i64"}]}],[11,"shl","","",249,{"i":[{"n":"self"},{"n":"isize"}],"o":{"n":"self"}}],[11,"shr","","",249,{"i":[{"n":"self"},{"n":"isize"}],"o":{"n":"self"}}],[11,"shl_assign","","",249,{"i":[{"n":"self"},{"n":"isize"}]}],[11,"shr_assign","","",249,{"i":[{"n":"self"},{"n":"isize"}]}],[11,"shl","","",249,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"shr","","",249,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"shl_assign","","",249,{"i":[{"n":"self"},{"n":"self"}]}],[11,"shr_assign","","",249,{"i":[{"n":"self"},{"n":"self"}]}],[11,"fmt","","",249,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",249,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",249,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",249,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"eq","","",249,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"bool"}}],[11,"ne","","",249,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"bool"}}],[11,"default","","",249,{"o":{"n":"self"}}],[11,"min","","Minimum of two vectors.",249,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"max","","Maximum of two vectors.",249,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"clone","","",250,{"i":[{"n":"self"}],"o":{"n":"u8x16"}}],[11,"fmt","","",250,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"partial_cmp","","",250,{"i":[{"n":"self"},{"n":"u8x16"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",250,{"i":[{"n":"self"},{"n":"u8x16"}],"o":{"n":"bool"}}],[11,"le","","",250,{"i":[{"n":"self"},{"n":"u8x16"}],"o":{"n":"bool"}}],[11,"gt","","",250,{"i":[{"n":"self"},{"n":"u8x16"}],"o":{"n":"bool"}}],[11,"ge","","",250,{"i":[{"n":"self"},{"n":"u8x16"}],"o":{"n":"bool"}}],[11,"new","","Creates a new instance with each vector elements initialized with the provided values.",250,{"i":[{"n":"u8"},{"n":"u8"},{"n":"u8"},{"n":"u8"},{"n":"u8"},{"n":"u8"},{"n":"u8"},{"n":"u8"},{"n":"u8"},{"n":"u8"},{"n":"u8"},{"n":"u8"},{"n":"u8"},{"n":"u8"},{"n":"u8"},{"n":"u8"}],"o":{"n":"self"}}],[11,"lanes","","Returns the number of vector lanes.",250,{"o":{"n":"usize"}}],[11,"splat","","Constructs a new instance with each element initialized to `value`.",250,{"i":[{"n":"u8"}],"o":{"n":"self"}}],[11,"extract","","Extracts the value at `index`.",250,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"u8"}}],[11,"extract_unchecked","","Extracts the value at `index`.",250,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"u8"}}],[11,"replace","","Returns a new vector where the value at `index` is replaced by `new_value`.",250,{"i":[{"n":"self"},{"n":"usize"},{"n":"u8"}],"o":{"n":"self"}}],[11,"replace_unchecked","","Returns a new vector where the value at `index` is replaced by `new_value`.",250,{"i":[{"n":"self"},{"n":"usize"},{"n":"u8"}],"o":{"n":"self"}}],[11,"store_aligned","","Writes the values of the vector to the `slice`.",250,null],[11,"store_unaligned","","Writes the values of the vector to the `slice`.",250,null],[11,"store_aligned_unchecked","","Writes the values of the vector to the `slice`.",250,null],[11,"store_unaligned_unchecked","","Writes the values of the vector to the `slice`.",250,null],[11,"load_aligned","","Instantiates a new vector with the values of the `slice`.",250,null],[11,"load_unaligned","","Instantiates a new vector with the values of the `slice`.",250,null],[11,"load_aligned_unchecked","","Instantiates a new vector with the values of the `slice`.",250,null],[11,"load_unaligned_unchecked","","Instantiates a new vector with the values of the `slice`.",250,null],[11,"eq","","Lane-wise equality comparison.",250,{"i":[{"n":"self"},{"n":"u8x16"}],"o":{"n":"m8x16"}}],[11,"ne","","Lane-wise inequality comparison.",250,{"i":[{"n":"self"},{"n":"u8x16"}],"o":{"n":"m8x16"}}],[11,"lt","","Lane-wise less-than comparison.",250,{"i":[{"n":"self"},{"n":"u8x16"}],"o":{"n":"m8x16"}}],[11,"le","","Lane-wise less-than-or-equals comparison.",250,{"i":[{"n":"self"},{"n":"u8x16"}],"o":{"n":"m8x16"}}],[11,"gt","","Lane-wise greater-than comparison.",250,{"i":[{"n":"self"},{"n":"u8x16"}],"o":{"n":"m8x16"}}],[11,"ge","","Lane-wise greater-than-or-equals comparison.",250,{"i":[{"n":"self"},{"n":"u8x16"}],"o":{"n":"m8x16"}}],[11,"hash","","",250,{"i":[{"n":"self"},{"n":"h"}]}],[11,"add","","",250,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"sub","","",250,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"mul","","",250,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"div","","",250,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"rem","","",250,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"add_assign","","",250,{"i":[{"n":"self"},{"n":"self"}]}],[11,"sub_assign","","",250,{"i":[{"n":"self"},{"n":"self"}]}],[11,"mul_assign","","",250,{"i":[{"n":"self"},{"n":"self"}]}],[11,"div_assign","","",250,{"i":[{"n":"self"},{"n":"self"}]}],[11,"rem_assign","","",250,{"i":[{"n":"self"},{"n":"self"}]}],[11,"add","","",250,{"i":[{"n":"self"},{"n":"u8"}],"o":{"n":"self"}}],[11,"sub","","",250,{"i":[{"n":"self"},{"n":"u8"}],"o":{"n":"self"}}],[11,"mul","","",250,{"i":[{"n":"self"},{"n":"u8"}],"o":{"n":"self"}}],[11,"div","","",250,{"i":[{"n":"self"},{"n":"u8"}],"o":{"n":"self"}}],[11,"rem","","",250,{"i":[{"n":"self"},{"n":"u8"}],"o":{"n":"self"}}],[11,"add_assign","","",250,{"i":[{"n":"self"},{"n":"u8"}]}],[11,"sub_assign","","",250,{"i":[{"n":"self"},{"n":"u8"}]}],[11,"mul_assign","","",250,{"i":[{"n":"self"},{"n":"u8"}]}],[11,"div_assign","","",250,{"i":[{"n":"self"},{"n":"u8"}]}],[11,"rem_assign","","",250,{"i":[{"n":"self"},{"n":"u8"}]}],[11,"wrapping_sum","","Horizontal sum of the vector elements.",250,{"i":[{"n":"self"}],"o":{"n":"u8"}}],[11,"wrapping_product","","Horizontal product of the vector elements.",250,{"i":[{"n":"self"}],"o":{"n":"u8"}}],[11,"max_element","","Largest vector element value.",250,{"i":[{"n":"self"}],"o":{"n":"u8"}}],[11,"min_element","","Smallest vector element value.",250,{"i":[{"n":"self"}],"o":{"n":"u8"}}],[11,"bitxor","","",250,{"i":[{"n":"self"},{"n":"u8"}],"o":{"n":"self"}}],[11,"bitand","","",250,{"i":[{"n":"self"},{"n":"u8"}],"o":{"n":"self"}}],[11,"bitor","","",250,{"i":[{"n":"self"},{"n":"u8"}],"o":{"n":"self"}}],[11,"bitand_assign","","",250,{"i":[{"n":"self"},{"n":"u8"}]}],[11,"bitor_assign","","",250,{"i":[{"n":"self"},{"n":"u8"}]}],[11,"bitxor_assign","","",250,{"i":[{"n":"self"},{"n":"u8"}]}],[11,"not","","",250,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"bitxor","","",250,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"bitand","","",250,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"bitor","","",250,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"bitand_assign","","",250,{"i":[{"n":"self"},{"n":"self"}]}],[11,"bitor_assign","","",250,{"i":[{"n":"self"},{"n":"self"}]}],[11,"bitxor_assign","","",250,{"i":[{"n":"self"},{"n":"self"}]}],[11,"and","","Lane-wise bitwise `and` of the vector elements.",250,{"i":[{"n":"self"}],"o":{"n":"u8"}}],[11,"or","","Lane-wise bitwise `or` of the vector elements.",250,{"i":[{"n":"self"}],"o":{"n":"u8"}}],[11,"xor","","Lane-wise bitwise `xor` of the vector elements.",250,{"i":[{"n":"self"}],"o":{"n":"u8"}}],[11,"shl","","",250,{"i":[{"n":"self"},{"n":"u8"}],"o":{"n":"self"}}],[11,"shr","","",250,{"i":[{"n":"self"},{"n":"u8"}],"o":{"n":"self"}}],[11,"shl_assign","","",250,{"i":[{"n":"self"},{"n":"u8"}]}],[11,"shr_assign","","",250,{"i":[{"n":"self"},{"n":"u8"}]}],[11,"shl","","",250,{"i":[{"n":"self"},{"n":"u16"}],"o":{"n":"self"}}],[11,"shr","","",250,{"i":[{"n":"self"},{"n":"u16"}],"o":{"n":"self"}}],[11,"shl_assign","","",250,{"i":[{"n":"self"},{"n":"u16"}]}],[11,"shr_assign","","",250,{"i":[{"n":"self"},{"n":"u16"}]}],[11,"shl","","",250,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"self"}}],[11,"shr","","",250,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"self"}}],[11,"shl_assign","","",250,{"i":[{"n":"self"},{"n":"u32"}]}],[11,"shr_assign","","",250,{"i":[{"n":"self"},{"n":"u32"}]}],[11,"shl","","",250,{"i":[{"n":"self"},{"n":"u64"}],"o":{"n":"self"}}],[11,"shr","","",250,{"i":[{"n":"self"},{"n":"u64"}],"o":{"n":"self"}}],[11,"shl_assign","","",250,{"i":[{"n":"self"},{"n":"u64"}]}],[11,"shr_assign","","",250,{"i":[{"n":"self"},{"n":"u64"}]}],[11,"shl","","",250,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"self"}}],[11,"shr","","",250,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"self"}}],[11,"shl_assign","","",250,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shr_assign","","",250,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shl","","",250,{"i":[{"n":"self"},{"n":"i8"}],"o":{"n":"self"}}],[11,"shr","","",250,{"i":[{"n":"self"},{"n":"i8"}],"o":{"n":"self"}}],[11,"shl_assign","","",250,{"i":[{"n":"self"},{"n":"i8"}]}],[11,"shr_assign","","",250,{"i":[{"n":"self"},{"n":"i8"}]}],[11,"shl","","",250,{"i":[{"n":"self"},{"n":"i16"}],"o":{"n":"self"}}],[11,"shr","","",250,{"i":[{"n":"self"},{"n":"i16"}],"o":{"n":"self"}}],[11,"shl_assign","","",250,{"i":[{"n":"self"},{"n":"i16"}]}],[11,"shr_assign","","",250,{"i":[{"n":"self"},{"n":"i16"}]}],[11,"shl","","",250,{"i":[{"n":"self"},{"n":"i32"}],"o":{"n":"self"}}],[11,"shr","","",250,{"i":[{"n":"self"},{"n":"i32"}],"o":{"n":"self"}}],[11,"shl_assign","","",250,{"i":[{"n":"self"},{"n":"i32"}]}],[11,"shr_assign","","",250,{"i":[{"n":"self"},{"n":"i32"}]}],[11,"shl","","",250,{"i":[{"n":"self"},{"n":"i64"}],"o":{"n":"self"}}],[11,"shr","","",250,{"i":[{"n":"self"},{"n":"i64"}],"o":{"n":"self"}}],[11,"shl_assign","","",250,{"i":[{"n":"self"},{"n":"i64"}]}],[11,"shr_assign","","",250,{"i":[{"n":"self"},{"n":"i64"}]}],[11,"shl","","",250,{"i":[{"n":"self"},{"n":"isize"}],"o":{"n":"self"}}],[11,"shr","","",250,{"i":[{"n":"self"},{"n":"isize"}],"o":{"n":"self"}}],[11,"shl_assign","","",250,{"i":[{"n":"self"},{"n":"isize"}]}],[11,"shr_assign","","",250,{"i":[{"n":"self"},{"n":"isize"}]}],[11,"shl","","",250,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"shr","","",250,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"shl_assign","","",250,{"i":[{"n":"self"},{"n":"self"}]}],[11,"shr_assign","","",250,{"i":[{"n":"self"},{"n":"self"}]}],[11,"fmt","","",250,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",250,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",250,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",250,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"eq","","",250,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"bool"}}],[11,"ne","","",250,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"bool"}}],[11,"default","","",250,{"o":{"n":"self"}}],[11,"min","","Minimum of two vectors.",250,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"max","","Maximum of two vectors.",250,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"clone","","",251,{"i":[{"n":"self"}],"o":{"n":"m8x16"}}],[11,"fmt","","",251,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"partial_cmp","","",251,{"i":[{"n":"self"},{"n":"m8x16"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",251,{"i":[{"n":"self"},{"n":"m8x16"}],"o":{"n":"bool"}}],[11,"le","","",251,{"i":[{"n":"self"},{"n":"m8x16"}],"o":{"n":"bool"}}],[11,"gt","","",251,{"i":[{"n":"self"},{"n":"m8x16"}],"o":{"n":"bool"}}],[11,"ge","","",251,{"i":[{"n":"self"},{"n":"m8x16"}],"o":{"n":"bool"}}],[11,"new","","Creates a new instance with each vector elements initialized with the provided values.",251,{"i":[{"n":"bool"},{"n":"bool"},{"n":"bool"},{"n":"bool"},{"n":"bool"},{"n":"bool"},{"n":"bool"},{"n":"bool"},{"n":"bool"},{"n":"bool"},{"n":"bool"},{"n":"bool"},{"n":"bool"},{"n":"bool"},{"n":"bool"},{"n":"bool"}],"o":{"n":"self"}}],[11,"lanes","","Returns the number of vector lanes.",251,{"o":{"n":"usize"}}],[11,"splat","","Constructs a new instance with each element initialized to `value`.",251,{"i":[{"n":"bool"}],"o":{"n":"self"}}],[11,"extract","","Extracts the value at `index`.",251,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"bool"}}],[11,"extract_unchecked","","Extracts the value at `index`.",251,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"bool"}}],[11,"replace","","Returns a new vector where the value at `index` is replaced by `new_value`.",251,{"i":[{"n":"self"},{"n":"usize"},{"n":"bool"}],"o":{"n":"self"}}],[11,"replace_unchecked","","Returns a new vector where the value at `index` is replaced by `new_value`.",251,{"i":[{"n":"self"},{"n":"usize"},{"n":"bool"}],"o":{"n":"self"}}],[11,"not","","",251,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"bitxor","","",251,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"bitand","","",251,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"bitor","","",251,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"bitand_assign","","",251,{"i":[{"n":"self"},{"n":"self"}]}],[11,"bitor_assign","","",251,{"i":[{"n":"self"},{"n":"self"}]}],[11,"bitxor_assign","","",251,{"i":[{"n":"self"},{"n":"self"}]}],[11,"bitxor","","",251,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"self"}}],[11,"bitand","","",251,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"self"}}],[11,"bitor","","",251,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"self"}}],[11,"bitand_assign","","",251,{"i":[{"n":"self"},{"n":"bool"}]}],[11,"bitor_assign","","",251,{"i":[{"n":"self"},{"n":"bool"}]}],[11,"bitxor_assign","","",251,{"i":[{"n":"self"},{"n":"bool"}]}],[11,"and","","Lane-wise bitwise `and` of the vector elements.",251,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"or","","Lane-wise bitwise `or` of the vector elements.",251,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"xor","","Lane-wise bitwise `xor` of the vector elements.",251,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"all","","Are `all` vector lanes `true`?",251,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"any","","Is `any` vector lanes `true`?",251,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"none","","Are `all` vector lanes `false`?",251,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"select","","Selects elements of `a` and `b` using mask.",251,{"i":[{"n":"self"},{"n":"t"},{"n":"t"}],"o":{"n":"t"}}],[11,"eq","","Lane-wise equality comparison.",251,{"i":[{"n":"self"},{"n":"m8x16"}],"o":{"n":"m8x16"}}],[11,"ne","","Lane-wise inequality comparison.",251,{"i":[{"n":"self"},{"n":"m8x16"}],"o":{"n":"m8x16"}}],[11,"lt","","Lane-wise less-than comparison.",251,{"i":[{"n":"self"},{"n":"m8x16"}],"o":{"n":"m8x16"}}],[11,"le","","Lane-wise less-than-or-equals comparison.",251,{"i":[{"n":"self"},{"n":"m8x16"}],"o":{"n":"m8x16"}}],[11,"gt","","Lane-wise greater-than comparison.",251,{"i":[{"n":"self"},{"n":"m8x16"}],"o":{"n":"m8x16"}}],[11,"ge","","Lane-wise greater-than-or-equals comparison.",251,{"i":[{"n":"self"},{"n":"m8x16"}],"o":{"n":"m8x16"}}],[11,"eq","","",251,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"bool"}}],[11,"ne","","",251,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"bool"}}],[11,"default","","",251,{"o":{"n":"self"}}],[11,"clone","","",252,{"i":[{"n":"self"}],"o":{"n":"i16x8"}}],[11,"fmt","","",252,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"partial_cmp","","",252,{"i":[{"n":"self"},{"n":"i16x8"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",252,{"i":[{"n":"self"},{"n":"i16x8"}],"o":{"n":"bool"}}],[11,"le","","",252,{"i":[{"n":"self"},{"n":"i16x8"}],"o":{"n":"bool"}}],[11,"gt","","",252,{"i":[{"n":"self"},{"n":"i16x8"}],"o":{"n":"bool"}}],[11,"ge","","",252,{"i":[{"n":"self"},{"n":"i16x8"}],"o":{"n":"bool"}}],[11,"new","","Creates a new instance with each vector elements initialized with the provided values.",252,{"i":[{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"},{"n":"i16"}],"o":{"n":"self"}}],[11,"lanes","","Returns the number of vector lanes.",252,{"o":{"n":"usize"}}],[11,"splat","","Constructs a new instance with each element initialized to `value`.",252,{"i":[{"n":"i16"}],"o":{"n":"self"}}],[11,"extract","","Extracts the value at `index`.",252,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"i16"}}],[11,"extract_unchecked","","Extracts the value at `index`.",252,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"i16"}}],[11,"replace","","Returns a new vector where the value at `index` is replaced by `new_value`.",252,{"i":[{"n":"self"},{"n":"usize"},{"n":"i16"}],"o":{"n":"self"}}],[11,"replace_unchecked","","Returns a new vector where the value at `index` is replaced by `new_value`.",252,{"i":[{"n":"self"},{"n":"usize"},{"n":"i16"}],"o":{"n":"self"}}],[11,"store_aligned","","Writes the values of the vector to the `slice`.",252,null],[11,"store_unaligned","","Writes the values of the vector to the `slice`.",252,null],[11,"store_aligned_unchecked","","Writes the values of the vector to the `slice`.",252,null],[11,"store_unaligned_unchecked","","Writes the values of the vector to the `slice`.",252,null],[11,"load_aligned","","Instantiates a new vector with the values of the `slice`.",252,null],[11,"load_unaligned","","Instantiates a new vector with the values of the `slice`.",252,null],[11,"load_aligned_unchecked","","Instantiates a new vector with the values of the `slice`.",252,null],[11,"load_unaligned_unchecked","","Instantiates a new vector with the values of the `slice`.",252,null],[11,"eq","","Lane-wise equality comparison.",252,{"i":[{"n":"self"},{"n":"i16x8"}],"o":{"n":"m16x8"}}],[11,"ne","","Lane-wise inequality comparison.",252,{"i":[{"n":"self"},{"n":"i16x8"}],"o":{"n":"m16x8"}}],[11,"lt","","Lane-wise less-than comparison.",252,{"i":[{"n":"self"},{"n":"i16x8"}],"o":{"n":"m16x8"}}],[11,"le","","Lane-wise less-than-or-equals comparison.",252,{"i":[{"n":"self"},{"n":"i16x8"}],"o":{"n":"m16x8"}}],[11,"gt","","Lane-wise greater-than comparison.",252,{"i":[{"n":"self"},{"n":"i16x8"}],"o":{"n":"m16x8"}}],[11,"ge","","Lane-wise greater-than-or-equals comparison.",252,{"i":[{"n":"self"},{"n":"i16x8"}],"o":{"n":"m16x8"}}],[11,"hash","","",252,{"i":[{"n":"self"},{"n":"h"}]}],[11,"add","","",252,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"sub","","",252,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"mul","","",252,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"div","","",252,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"rem","","",252,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"add_assign","","",252,{"i":[{"n":"self"},{"n":"self"}]}],[11,"sub_assign","","",252,{"i":[{"n":"self"},{"n":"self"}]}],[11,"mul_assign","","",252,{"i":[{"n":"self"},{"n":"self"}]}],[11,"div_assign","","",252,{"i":[{"n":"self"},{"n":"self"}]}],[11,"rem_assign","","",252,{"i":[{"n":"self"},{"n":"self"}]}],[11,"add","","",252,{"i":[{"n":"self"},{"n":"i16"}],"o":{"n":"self"}}],[11,"sub","","",252,{"i":[{"n":"self"},{"n":"i16"}],"o":{"n":"self"}}],[11,"mul","","",252,{"i":[{"n":"self"},{"n":"i16"}],"o":{"n":"self"}}],[11,"div","","",252,{"i":[{"n":"self"},{"n":"i16"}],"o":{"n":"self"}}],[11,"rem","","",252,{"i":[{"n":"self"},{"n":"i16"}],"o":{"n":"self"}}],[11,"add_assign","","",252,{"i":[{"n":"self"},{"n":"i16"}]}],[11,"sub_assign","","",252,{"i":[{"n":"self"},{"n":"i16"}]}],[11,"mul_assign","","",252,{"i":[{"n":"self"},{"n":"i16"}]}],[11,"div_assign","","",252,{"i":[{"n":"self"},{"n":"i16"}]}],[11,"rem_assign","","",252,{"i":[{"n":"self"},{"n":"i16"}]}],[11,"wrapping_sum","","Horizontal sum of the vector elements.",252,{"i":[{"n":"self"}],"o":{"n":"i16"}}],[11,"wrapping_product","","Horizontal product of the vector elements.",252,{"i":[{"n":"self"}],"o":{"n":"i16"}}],[11,"max_element","","Largest vector element value.",252,{"i":[{"n":"self"}],"o":{"n":"i16"}}],[11,"min_element","","Smallest vector element value.",252,{"i":[{"n":"self"}],"o":{"n":"i16"}}],[11,"neg","","",252,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"not","","",252,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"bitxor","","",252,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"bitand","","",252,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"bitor","","",252,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"bitand_assign","","",252,{"i":[{"n":"self"},{"n":"self"}]}],[11,"bitor_assign","","",252,{"i":[{"n":"self"},{"n":"self"}]}],[11,"bitxor_assign","","",252,{"i":[{"n":"self"},{"n":"self"}]}],[11,"bitxor","","",252,{"i":[{"n":"self"},{"n":"i16"}],"o":{"n":"self"}}],[11,"bitand","","",252,{"i":[{"n":"self"},{"n":"i16"}],"o":{"n":"self"}}],[11,"bitor","","",252,{"i":[{"n":"self"},{"n":"i16"}],"o":{"n":"self"}}],[11,"bitand_assign","","",252,{"i":[{"n":"self"},{"n":"i16"}]}],[11,"bitor_assign","","",252,{"i":[{"n":"self"},{"n":"i16"}]}],[11,"bitxor_assign","","",252,{"i":[{"n":"self"},{"n":"i16"}]}],[11,"and","","Lane-wise bitwise `and` of the vector elements.",252,{"i":[{"n":"self"}],"o":{"n":"i16"}}],[11,"or","","Lane-wise bitwise `or` of the vector elements.",252,{"i":[{"n":"self"}],"o":{"n":"i16"}}],[11,"xor","","Lane-wise bitwise `xor` of the vector elements.",252,{"i":[{"n":"self"}],"o":{"n":"i16"}}],[11,"shl","","",252,{"i":[{"n":"self"},{"n":"u8"}],"o":{"n":"self"}}],[11,"shr","","",252,{"i":[{"n":"self"},{"n":"u8"}],"o":{"n":"self"}}],[11,"shl_assign","","",252,{"i":[{"n":"self"},{"n":"u8"}]}],[11,"shr_assign","","",252,{"i":[{"n":"self"},{"n":"u8"}]}],[11,"shl","","",252,{"i":[{"n":"self"},{"n":"u16"}],"o":{"n":"self"}}],[11,"shr","","",252,{"i":[{"n":"self"},{"n":"u16"}],"o":{"n":"self"}}],[11,"shl_assign","","",252,{"i":[{"n":"self"},{"n":"u16"}]}],[11,"shr_assign","","",252,{"i":[{"n":"self"},{"n":"u16"}]}],[11,"shl","","",252,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"self"}}],[11,"shr","","",252,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"self"}}],[11,"shl_assign","","",252,{"i":[{"n":"self"},{"n":"u32"}]}],[11,"shr_assign","","",252,{"i":[{"n":"self"},{"n":"u32"}]}],[11,"shl","","",252,{"i":[{"n":"self"},{"n":"u64"}],"o":{"n":"self"}}],[11,"shr","","",252,{"i":[{"n":"self"},{"n":"u64"}],"o":{"n":"self"}}],[11,"shl_assign","","",252,{"i":[{"n":"self"},{"n":"u64"}]}],[11,"shr_assign","","",252,{"i":[{"n":"self"},{"n":"u64"}]}],[11,"shl","","",252,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"self"}}],[11,"shr","","",252,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"self"}}],[11,"shl_assign","","",252,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shr_assign","","",252,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shl","","",252,{"i":[{"n":"self"},{"n":"i8"}],"o":{"n":"self"}}],[11,"shr","","",252,{"i":[{"n":"self"},{"n":"i8"}],"o":{"n":"self"}}],[11,"shl_assign","","",252,{"i":[{"n":"self"},{"n":"i8"}]}],[11,"shr_assign","","",252,{"i":[{"n":"self"},{"n":"i8"}]}],[11,"shl","","",252,{"i":[{"n":"self"},{"n":"i16"}],"o":{"n":"self"}}],[11,"shr","","",252,{"i":[{"n":"self"},{"n":"i16"}],"o":{"n":"self"}}],[11,"shl_assign","","",252,{"i":[{"n":"self"},{"n":"i16"}]}],[11,"shr_assign","","",252,{"i":[{"n":"self"},{"n":"i16"}]}],[11,"shl","","",252,{"i":[{"n":"self"},{"n":"i32"}],"o":{"n":"self"}}],[11,"shr","","",252,{"i":[{"n":"self"},{"n":"i32"}],"o":{"n":"self"}}],[11,"shl_assign","","",252,{"i":[{"n":"self"},{"n":"i32"}]}],[11,"shr_assign","","",252,{"i":[{"n":"self"},{"n":"i32"}]}],[11,"shl","","",252,{"i":[{"n":"self"},{"n":"i64"}],"o":{"n":"self"}}],[11,"shr","","",252,{"i":[{"n":"self"},{"n":"i64"}],"o":{"n":"self"}}],[11,"shl_assign","","",252,{"i":[{"n":"self"},{"n":"i64"}]}],[11,"shr_assign","","",252,{"i":[{"n":"self"},{"n":"i64"}]}],[11,"shl","","",252,{"i":[{"n":"self"},{"n":"isize"}],"o":{"n":"self"}}],[11,"shr","","",252,{"i":[{"n":"self"},{"n":"isize"}],"o":{"n":"self"}}],[11,"shl_assign","","",252,{"i":[{"n":"self"},{"n":"isize"}]}],[11,"shr_assign","","",252,{"i":[{"n":"self"},{"n":"isize"}]}],[11,"shl","","",252,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"shr","","",252,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"shl_assign","","",252,{"i":[{"n":"self"},{"n":"self"}]}],[11,"shr_assign","","",252,{"i":[{"n":"self"},{"n":"self"}]}],[11,"fmt","","",252,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",252,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",252,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",252,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"eq","","",252,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"bool"}}],[11,"ne","","",252,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"bool"}}],[11,"default","","",252,{"o":{"n":"self"}}],[11,"min","","Minimum of two vectors.",252,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"max","","Maximum of two vectors.",252,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"clone","","",253,{"i":[{"n":"self"}],"o":{"n":"u16x8"}}],[11,"fmt","","",253,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"partial_cmp","","",253,{"i":[{"n":"self"},{"n":"u16x8"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",253,{"i":[{"n":"self"},{"n":"u16x8"}],"o":{"n":"bool"}}],[11,"le","","",253,{"i":[{"n":"self"},{"n":"u16x8"}],"o":{"n":"bool"}}],[11,"gt","","",253,{"i":[{"n":"self"},{"n":"u16x8"}],"o":{"n":"bool"}}],[11,"ge","","",253,{"i":[{"n":"self"},{"n":"u16x8"}],"o":{"n":"bool"}}],[11,"new","","Creates a new instance with each vector elements initialized with the provided values.",253,{"i":[{"n":"u16"},{"n":"u16"},{"n":"u16"},{"n":"u16"},{"n":"u16"},{"n":"u16"},{"n":"u16"},{"n":"u16"}],"o":{"n":"self"}}],[11,"lanes","","Returns the number of vector lanes.",253,{"o":{"n":"usize"}}],[11,"splat","","Constructs a new instance with each element initialized to `value`.",253,{"i":[{"n":"u16"}],"o":{"n":"self"}}],[11,"extract","","Extracts the value at `index`.",253,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"u16"}}],[11,"extract_unchecked","","Extracts the value at `index`.",253,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"u16"}}],[11,"replace","","Returns a new vector where the value at `index` is replaced by `new_value`.",253,{"i":[{"n":"self"},{"n":"usize"},{"n":"u16"}],"o":{"n":"self"}}],[11,"replace_unchecked","","Returns a new vector where the value at `index` is replaced by `new_value`.",253,{"i":[{"n":"self"},{"n":"usize"},{"n":"u16"}],"o":{"n":"self"}}],[11,"store_aligned","","Writes the values of the vector to the `slice`.",253,null],[11,"store_unaligned","","Writes the values of the vector to the `slice`.",253,null],[11,"store_aligned_unchecked","","Writes the values of the vector to the `slice`.",253,null],[11,"store_unaligned_unchecked","","Writes the values of the vector to the `slice`.",253,null],[11,"load_aligned","","Instantiates a new vector with the values of the `slice`.",253,null],[11,"load_unaligned","","Instantiates a new vector with the values of the `slice`.",253,null],[11,"load_aligned_unchecked","","Instantiates a new vector with the values of the `slice`.",253,null],[11,"load_unaligned_unchecked","","Instantiates a new vector with the values of the `slice`.",253,null],[11,"eq","","Lane-wise equality comparison.",253,{"i":[{"n":"self"},{"n":"u16x8"}],"o":{"n":"m16x8"}}],[11,"ne","","Lane-wise inequality comparison.",253,{"i":[{"n":"self"},{"n":"u16x8"}],"o":{"n":"m16x8"}}],[11,"lt","","Lane-wise less-than comparison.",253,{"i":[{"n":"self"},{"n":"u16x8"}],"o":{"n":"m16x8"}}],[11,"le","","Lane-wise less-than-or-equals comparison.",253,{"i":[{"n":"self"},{"n":"u16x8"}],"o":{"n":"m16x8"}}],[11,"gt","","Lane-wise greater-than comparison.",253,{"i":[{"n":"self"},{"n":"u16x8"}],"o":{"n":"m16x8"}}],[11,"ge","","Lane-wise greater-than-or-equals comparison.",253,{"i":[{"n":"self"},{"n":"u16x8"}],"o":{"n":"m16x8"}}],[11,"hash","","",253,{"i":[{"n":"self"},{"n":"h"}]}],[11,"add","","",253,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"sub","","",253,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"mul","","",253,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"div","","",253,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"rem","","",253,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"add_assign","","",253,{"i":[{"n":"self"},{"n":"self"}]}],[11,"sub_assign","","",253,{"i":[{"n":"self"},{"n":"self"}]}],[11,"mul_assign","","",253,{"i":[{"n":"self"},{"n":"self"}]}],[11,"div_assign","","",253,{"i":[{"n":"self"},{"n":"self"}]}],[11,"rem_assign","","",253,{"i":[{"n":"self"},{"n":"self"}]}],[11,"add","","",253,{"i":[{"n":"self"},{"n":"u16"}],"o":{"n":"self"}}],[11,"sub","","",253,{"i":[{"n":"self"},{"n":"u16"}],"o":{"n":"self"}}],[11,"mul","","",253,{"i":[{"n":"self"},{"n":"u16"}],"o":{"n":"self"}}],[11,"div","","",253,{"i":[{"n":"self"},{"n":"u16"}],"o":{"n":"self"}}],[11,"rem","","",253,{"i":[{"n":"self"},{"n":"u16"}],"o":{"n":"self"}}],[11,"add_assign","","",253,{"i":[{"n":"self"},{"n":"u16"}]}],[11,"sub_assign","","",253,{"i":[{"n":"self"},{"n":"u16"}]}],[11,"mul_assign","","",253,{"i":[{"n":"self"},{"n":"u16"}]}],[11,"div_assign","","",253,{"i":[{"n":"self"},{"n":"u16"}]}],[11,"rem_assign","","",253,{"i":[{"n":"self"},{"n":"u16"}]}],[11,"wrapping_sum","","Horizontal sum of the vector elements.",253,{"i":[{"n":"self"}],"o":{"n":"u16"}}],[11,"wrapping_product","","Horizontal product of the vector elements.",253,{"i":[{"n":"self"}],"o":{"n":"u16"}}],[11,"max_element","","Largest vector element value.",253,{"i":[{"n":"self"}],"o":{"n":"u16"}}],[11,"min_element","","Smallest vector element value.",253,{"i":[{"n":"self"}],"o":{"n":"u16"}}],[11,"bitxor","","",253,{"i":[{"n":"self"},{"n":"u16"}],"o":{"n":"self"}}],[11,"bitand","","",253,{"i":[{"n":"self"},{"n":"u16"}],"o":{"n":"self"}}],[11,"bitor","","",253,{"i":[{"n":"self"},{"n":"u16"}],"o":{"n":"self"}}],[11,"bitand_assign","","",253,{"i":[{"n":"self"},{"n":"u16"}]}],[11,"bitor_assign","","",253,{"i":[{"n":"self"},{"n":"u16"}]}],[11,"bitxor_assign","","",253,{"i":[{"n":"self"},{"n":"u16"}]}],[11,"not","","",253,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"bitxor","","",253,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"bitand","","",253,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"bitor","","",253,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"bitand_assign","","",253,{"i":[{"n":"self"},{"n":"self"}]}],[11,"bitor_assign","","",253,{"i":[{"n":"self"},{"n":"self"}]}],[11,"bitxor_assign","","",253,{"i":[{"n":"self"},{"n":"self"}]}],[11,"and","","Lane-wise bitwise `and` of the vector elements.",253,{"i":[{"n":"self"}],"o":{"n":"u16"}}],[11,"or","","Lane-wise bitwise `or` of the vector elements.",253,{"i":[{"n":"self"}],"o":{"n":"u16"}}],[11,"xor","","Lane-wise bitwise `xor` of the vector elements.",253,{"i":[{"n":"self"}],"o":{"n":"u16"}}],[11,"shl","","",253,{"i":[{"n":"self"},{"n":"u8"}],"o":{"n":"self"}}],[11,"shr","","",253,{"i":[{"n":"self"},{"n":"u8"}],"o":{"n":"self"}}],[11,"shl_assign","","",253,{"i":[{"n":"self"},{"n":"u8"}]}],[11,"shr_assign","","",253,{"i":[{"n":"self"},{"n":"u8"}]}],[11,"shl","","",253,{"i":[{"n":"self"},{"n":"u16"}],"o":{"n":"self"}}],[11,"shr","","",253,{"i":[{"n":"self"},{"n":"u16"}],"o":{"n":"self"}}],[11,"shl_assign","","",253,{"i":[{"n":"self"},{"n":"u16"}]}],[11,"shr_assign","","",253,{"i":[{"n":"self"},{"n":"u16"}]}],[11,"shl","","",253,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"self"}}],[11,"shr","","",253,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"self"}}],[11,"shl_assign","","",253,{"i":[{"n":"self"},{"n":"u32"}]}],[11,"shr_assign","","",253,{"i":[{"n":"self"},{"n":"u32"}]}],[11,"shl","","",253,{"i":[{"n":"self"},{"n":"u64"}],"o":{"n":"self"}}],[11,"shr","","",253,{"i":[{"n":"self"},{"n":"u64"}],"o":{"n":"self"}}],[11,"shl_assign","","",253,{"i":[{"n":"self"},{"n":"u64"}]}],[11,"shr_assign","","",253,{"i":[{"n":"self"},{"n":"u64"}]}],[11,"shl","","",253,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"self"}}],[11,"shr","","",253,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"self"}}],[11,"shl_assign","","",253,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shr_assign","","",253,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shl","","",253,{"i":[{"n":"self"},{"n":"i8"}],"o":{"n":"self"}}],[11,"shr","","",253,{"i":[{"n":"self"},{"n":"i8"}],"o":{"n":"self"}}],[11,"shl_assign","","",253,{"i":[{"n":"self"},{"n":"i8"}]}],[11,"shr_assign","","",253,{"i":[{"n":"self"},{"n":"i8"}]}],[11,"shl","","",253,{"i":[{"n":"self"},{"n":"i16"}],"o":{"n":"self"}}],[11,"shr","","",253,{"i":[{"n":"self"},{"n":"i16"}],"o":{"n":"self"}}],[11,"shl_assign","","",253,{"i":[{"n":"self"},{"n":"i16"}]}],[11,"shr_assign","","",253,{"i":[{"n":"self"},{"n":"i16"}]}],[11,"shl","","",253,{"i":[{"n":"self"},{"n":"i32"}],"o":{"n":"self"}}],[11,"shr","","",253,{"i":[{"n":"self"},{"n":"i32"}],"o":{"n":"self"}}],[11,"shl_assign","","",253,{"i":[{"n":"self"},{"n":"i32"}]}],[11,"shr_assign","","",253,{"i":[{"n":"self"},{"n":"i32"}]}],[11,"shl","","",253,{"i":[{"n":"self"},{"n":"i64"}],"o":{"n":"self"}}],[11,"shr","","",253,{"i":[{"n":"self"},{"n":"i64"}],"o":{"n":"self"}}],[11,"shl_assign","","",253,{"i":[{"n":"self"},{"n":"i64"}]}],[11,"shr_assign","","",253,{"i":[{"n":"self"},{"n":"i64"}]}],[11,"shl","","",253,{"i":[{"n":"self"},{"n":"isize"}],"o":{"n":"self"}}],[11,"shr","","",253,{"i":[{"n":"self"},{"n":"isize"}],"o":{"n":"self"}}],[11,"shl_assign","","",253,{"i":[{"n":"self"},{"n":"isize"}]}],[11,"shr_assign","","",253,{"i":[{"n":"self"},{"n":"isize"}]}],[11,"shl","","",253,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"shr","","",253,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"shl_assign","","",253,{"i":[{"n":"self"},{"n":"self"}]}],[11,"shr_assign","","",253,{"i":[{"n":"self"},{"n":"self"}]}],[11,"fmt","","",253,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",253,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",253,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",253,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"eq","","",253,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"bool"}}],[11,"ne","","",253,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"bool"}}],[11,"default","","",253,{"o":{"n":"self"}}],[11,"min","","Minimum of two vectors.",253,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"max","","Maximum of two vectors.",253,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"clone","","",254,{"i":[{"n":"self"}],"o":{"n":"m16x8"}}],[11,"fmt","","",254,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"partial_cmp","","",254,{"i":[{"n":"self"},{"n":"m16x8"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",254,{"i":[{"n":"self"},{"n":"m16x8"}],"o":{"n":"bool"}}],[11,"le","","",254,{"i":[{"n":"self"},{"n":"m16x8"}],"o":{"n":"bool"}}],[11,"gt","","",254,{"i":[{"n":"self"},{"n":"m16x8"}],"o":{"n":"bool"}}],[11,"ge","","",254,{"i":[{"n":"self"},{"n":"m16x8"}],"o":{"n":"bool"}}],[11,"new","","Creates a new instance with each vector elements initialized with the provided values.",254,{"i":[{"n":"bool"},{"n":"bool"},{"n":"bool"},{"n":"bool"},{"n":"bool"},{"n":"bool"},{"n":"bool"},{"n":"bool"}],"o":{"n":"self"}}],[11,"lanes","","Returns the number of vector lanes.",254,{"o":{"n":"usize"}}],[11,"splat","","Constructs a new instance with each element initialized to `value`.",254,{"i":[{"n":"bool"}],"o":{"n":"self"}}],[11,"extract","","Extracts the value at `index`.",254,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"bool"}}],[11,"extract_unchecked","","Extracts the value at `index`.",254,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"bool"}}],[11,"replace","","Returns a new vector where the value at `index` is replaced by `new_value`.",254,{"i":[{"n":"self"},{"n":"usize"},{"n":"bool"}],"o":{"n":"self"}}],[11,"replace_unchecked","","Returns a new vector where the value at `index` is replaced by `new_value`.",254,{"i":[{"n":"self"},{"n":"usize"},{"n":"bool"}],"o":{"n":"self"}}],[11,"not","","",254,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"bitxor","","",254,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"bitand","","",254,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"bitor","","",254,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"bitand_assign","","",254,{"i":[{"n":"self"},{"n":"self"}]}],[11,"bitor_assign","","",254,{"i":[{"n":"self"},{"n":"self"}]}],[11,"bitxor_assign","","",254,{"i":[{"n":"self"},{"n":"self"}]}],[11,"bitxor","","",254,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"self"}}],[11,"bitand","","",254,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"self"}}],[11,"bitor","","",254,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"self"}}],[11,"bitand_assign","","",254,{"i":[{"n":"self"},{"n":"bool"}]}],[11,"bitor_assign","","",254,{"i":[{"n":"self"},{"n":"bool"}]}],[11,"bitxor_assign","","",254,{"i":[{"n":"self"},{"n":"bool"}]}],[11,"and","","Lane-wise bitwise `and` of the vector elements.",254,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"or","","Lane-wise bitwise `or` of the vector elements.",254,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"xor","","Lane-wise bitwise `xor` of the vector elements.",254,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"all","","Are `all` vector lanes `true`?",254,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"any","","Is `any` vector lanes `true`?",254,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"none","","Are `all` vector lanes `false`?",254,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"select","","Selects elements of `a` and `b` using mask.",254,{"i":[{"n":"self"},{"n":"t"},{"n":"t"}],"o":{"n":"t"}}],[11,"eq","","Lane-wise equality comparison.",254,{"i":[{"n":"self"},{"n":"m16x8"}],"o":{"n":"m16x8"}}],[11,"ne","","Lane-wise inequality comparison.",254,{"i":[{"n":"self"},{"n":"m16x8"}],"o":{"n":"m16x8"}}],[11,"lt","","Lane-wise less-than comparison.",254,{"i":[{"n":"self"},{"n":"m16x8"}],"o":{"n":"m16x8"}}],[11,"le","","Lane-wise less-than-or-equals comparison.",254,{"i":[{"n":"self"},{"n":"m16x8"}],"o":{"n":"m16x8"}}],[11,"gt","","Lane-wise greater-than comparison.",254,{"i":[{"n":"self"},{"n":"m16x8"}],"o":{"n":"m16x8"}}],[11,"ge","","Lane-wise greater-than-or-equals comparison.",254,{"i":[{"n":"self"},{"n":"m16x8"}],"o":{"n":"m16x8"}}],[11,"eq","","",254,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"bool"}}],[11,"ne","","",254,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"bool"}}],[11,"default","","",254,{"o":{"n":"self"}}],[11,"clone","","",255,{"i":[{"n":"self"}],"o":{"n":"i32x4"}}],[11,"fmt","","",255,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"partial_cmp","","",255,{"i":[{"n":"self"},{"n":"i32x4"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",255,{"i":[{"n":"self"},{"n":"i32x4"}],"o":{"n":"bool"}}],[11,"le","","",255,{"i":[{"n":"self"},{"n":"i32x4"}],"o":{"n":"bool"}}],[11,"gt","","",255,{"i":[{"n":"self"},{"n":"i32x4"}],"o":{"n":"bool"}}],[11,"ge","","",255,{"i":[{"n":"self"},{"n":"i32x4"}],"o":{"n":"bool"}}],[11,"new","","Creates a new instance with each vector elements initialized with the provided values.",255,{"i":[{"n":"i32"},{"n":"i32"},{"n":"i32"},{"n":"i32"}],"o":{"n":"self"}}],[11,"lanes","","Returns the number of vector lanes.",255,{"o":{"n":"usize"}}],[11,"splat","","Constructs a new instance with each element initialized to `value`.",255,{"i":[{"n":"i32"}],"o":{"n":"self"}}],[11,"extract","","Extracts the value at `index`.",255,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"i32"}}],[11,"extract_unchecked","","Extracts the value at `index`.",255,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"i32"}}],[11,"replace","","Returns a new vector where the value at `index` is replaced by `new_value`.",255,{"i":[{"n":"self"},{"n":"usize"},{"n":"i32"}],"o":{"n":"self"}}],[11,"replace_unchecked","","Returns a new vector where the value at `index` is replaced by `new_value`.",255,{"i":[{"n":"self"},{"n":"usize"},{"n":"i32"}],"o":{"n":"self"}}],[11,"store_aligned","","Writes the values of the vector to the `slice`.",255,null],[11,"store_unaligned","","Writes the values of the vector to the `slice`.",255,null],[11,"store_aligned_unchecked","","Writes the values of the vector to the `slice`.",255,null],[11,"store_unaligned_unchecked","","Writes the values of the vector to the `slice`.",255,null],[11,"load_aligned","","Instantiates a new vector with the values of the `slice`.",255,null],[11,"load_unaligned","","Instantiates a new vector with the values of the `slice`.",255,null],[11,"load_aligned_unchecked","","Instantiates a new vector with the values of the `slice`.",255,null],[11,"load_unaligned_unchecked","","Instantiates a new vector with the values of the `slice`.",255,null],[11,"eq","","Lane-wise equality comparison.",255,{"i":[{"n":"self"},{"n":"i32x4"}],"o":{"n":"m32x4"}}],[11,"ne","","Lane-wise inequality comparison.",255,{"i":[{"n":"self"},{"n":"i32x4"}],"o":{"n":"m32x4"}}],[11,"lt","","Lane-wise less-than comparison.",255,{"i":[{"n":"self"},{"n":"i32x4"}],"o":{"n":"m32x4"}}],[11,"le","","Lane-wise less-than-or-equals comparison.",255,{"i":[{"n":"self"},{"n":"i32x4"}],"o":{"n":"m32x4"}}],[11,"gt","","Lane-wise greater-than comparison.",255,{"i":[{"n":"self"},{"n":"i32x4"}],"o":{"n":"m32x4"}}],[11,"ge","","Lane-wise greater-than-or-equals comparison.",255,{"i":[{"n":"self"},{"n":"i32x4"}],"o":{"n":"m32x4"}}],[11,"hash","","",255,{"i":[{"n":"self"},{"n":"h"}]}],[11,"add","","",255,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"sub","","",255,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"mul","","",255,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"div","","",255,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"rem","","",255,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"add_assign","","",255,{"i":[{"n":"self"},{"n":"self"}]}],[11,"sub_assign","","",255,{"i":[{"n":"self"},{"n":"self"}]}],[11,"mul_assign","","",255,{"i":[{"n":"self"},{"n":"self"}]}],[11,"div_assign","","",255,{"i":[{"n":"self"},{"n":"self"}]}],[11,"rem_assign","","",255,{"i":[{"n":"self"},{"n":"self"}]}],[11,"add","","",255,{"i":[{"n":"self"},{"n":"i32"}],"o":{"n":"self"}}],[11,"sub","","",255,{"i":[{"n":"self"},{"n":"i32"}],"o":{"n":"self"}}],[11,"mul","","",255,{"i":[{"n":"self"},{"n":"i32"}],"o":{"n":"self"}}],[11,"div","","",255,{"i":[{"n":"self"},{"n":"i32"}],"o":{"n":"self"}}],[11,"rem","","",255,{"i":[{"n":"self"},{"n":"i32"}],"o":{"n":"self"}}],[11,"add_assign","","",255,{"i":[{"n":"self"},{"n":"i32"}]}],[11,"sub_assign","","",255,{"i":[{"n":"self"},{"n":"i32"}]}],[11,"mul_assign","","",255,{"i":[{"n":"self"},{"n":"i32"}]}],[11,"div_assign","","",255,{"i":[{"n":"self"},{"n":"i32"}]}],[11,"rem_assign","","",255,{"i":[{"n":"self"},{"n":"i32"}]}],[11,"wrapping_sum","","Horizontal sum of the vector elements.",255,{"i":[{"n":"self"}],"o":{"n":"i32"}}],[11,"wrapping_product","","Horizontal product of the vector elements.",255,{"i":[{"n":"self"}],"o":{"n":"i32"}}],[11,"max_element","","Largest vector element value.",255,{"i":[{"n":"self"}],"o":{"n":"i32"}}],[11,"min_element","","Smallest vector element value.",255,{"i":[{"n":"self"}],"o":{"n":"i32"}}],[11,"neg","","",255,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"not","","",255,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"bitxor","","",255,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"bitand","","",255,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"bitor","","",255,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"bitand_assign","","",255,{"i":[{"n":"self"},{"n":"self"}]}],[11,"bitor_assign","","",255,{"i":[{"n":"self"},{"n":"self"}]}],[11,"bitxor_assign","","",255,{"i":[{"n":"self"},{"n":"self"}]}],[11,"bitxor","","",255,{"i":[{"n":"self"},{"n":"i32"}],"o":{"n":"self"}}],[11,"bitand","","",255,{"i":[{"n":"self"},{"n":"i32"}],"o":{"n":"self"}}],[11,"bitor","","",255,{"i":[{"n":"self"},{"n":"i32"}],"o":{"n":"self"}}],[11,"bitand_assign","","",255,{"i":[{"n":"self"},{"n":"i32"}]}],[11,"bitor_assign","","",255,{"i":[{"n":"self"},{"n":"i32"}]}],[11,"bitxor_assign","","",255,{"i":[{"n":"self"},{"n":"i32"}]}],[11,"and","","Lane-wise bitwise `and` of the vector elements.",255,{"i":[{"n":"self"}],"o":{"n":"i32"}}],[11,"or","","Lane-wise bitwise `or` of the vector elements.",255,{"i":[{"n":"self"}],"o":{"n":"i32"}}],[11,"xor","","Lane-wise bitwise `xor` of the vector elements.",255,{"i":[{"n":"self"}],"o":{"n":"i32"}}],[11,"shl","","",255,{"i":[{"n":"self"},{"n":"u8"}],"o":{"n":"self"}}],[11,"shr","","",255,{"i":[{"n":"self"},{"n":"u8"}],"o":{"n":"self"}}],[11,"shl_assign","","",255,{"i":[{"n":"self"},{"n":"u8"}]}],[11,"shr_assign","","",255,{"i":[{"n":"self"},{"n":"u8"}]}],[11,"shl","","",255,{"i":[{"n":"self"},{"n":"u16"}],"o":{"n":"self"}}],[11,"shr","","",255,{"i":[{"n":"self"},{"n":"u16"}],"o":{"n":"self"}}],[11,"shl_assign","","",255,{"i":[{"n":"self"},{"n":"u16"}]}],[11,"shr_assign","","",255,{"i":[{"n":"self"},{"n":"u16"}]}],[11,"shl","","",255,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"self"}}],[11,"shr","","",255,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"self"}}],[11,"shl_assign","","",255,{"i":[{"n":"self"},{"n":"u32"}]}],[11,"shr_assign","","",255,{"i":[{"n":"self"},{"n":"u32"}]}],[11,"shl","","",255,{"i":[{"n":"self"},{"n":"u64"}],"o":{"n":"self"}}],[11,"shr","","",255,{"i":[{"n":"self"},{"n":"u64"}],"o":{"n":"self"}}],[11,"shl_assign","","",255,{"i":[{"n":"self"},{"n":"u64"}]}],[11,"shr_assign","","",255,{"i":[{"n":"self"},{"n":"u64"}]}],[11,"shl","","",255,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"self"}}],[11,"shr","","",255,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"self"}}],[11,"shl_assign","","",255,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shr_assign","","",255,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shl","","",255,{"i":[{"n":"self"},{"n":"i8"}],"o":{"n":"self"}}],[11,"shr","","",255,{"i":[{"n":"self"},{"n":"i8"}],"o":{"n":"self"}}],[11,"shl_assign","","",255,{"i":[{"n":"self"},{"n":"i8"}]}],[11,"shr_assign","","",255,{"i":[{"n":"self"},{"n":"i8"}]}],[11,"shl","","",255,{"i":[{"n":"self"},{"n":"i16"}],"o":{"n":"self"}}],[11,"shr","","",255,{"i":[{"n":"self"},{"n":"i16"}],"o":{"n":"self"}}],[11,"shl_assign","","",255,{"i":[{"n":"self"},{"n":"i16"}]}],[11,"shr_assign","","",255,{"i":[{"n":"self"},{"n":"i16"}]}],[11,"shl","","",255,{"i":[{"n":"self"},{"n":"i32"}],"o":{"n":"self"}}],[11,"shr","","",255,{"i":[{"n":"self"},{"n":"i32"}],"o":{"n":"self"}}],[11,"shl_assign","","",255,{"i":[{"n":"self"},{"n":"i32"}]}],[11,"shr_assign","","",255,{"i":[{"n":"self"},{"n":"i32"}]}],[11,"shl","","",255,{"i":[{"n":"self"},{"n":"i64"}],"o":{"n":"self"}}],[11,"shr","","",255,{"i":[{"n":"self"},{"n":"i64"}],"o":{"n":"self"}}],[11,"shl_assign","","",255,{"i":[{"n":"self"},{"n":"i64"}]}],[11,"shr_assign","","",255,{"i":[{"n":"self"},{"n":"i64"}]}],[11,"shl","","",255,{"i":[{"n":"self"},{"n":"isize"}],"o":{"n":"self"}}],[11,"shr","","",255,{"i":[{"n":"self"},{"n":"isize"}],"o":{"n":"self"}}],[11,"shl_assign","","",255,{"i":[{"n":"self"},{"n":"isize"}]}],[11,"shr_assign","","",255,{"i":[{"n":"self"},{"n":"isize"}]}],[11,"shl","","",255,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"shr","","",255,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"shl_assign","","",255,{"i":[{"n":"self"},{"n":"self"}]}],[11,"shr_assign","","",255,{"i":[{"n":"self"},{"n":"self"}]}],[11,"fmt","","",255,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",255,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",255,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",255,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"eq","","",255,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"bool"}}],[11,"ne","","",255,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"bool"}}],[11,"default","","",255,{"o":{"n":"self"}}],[11,"min","","Minimum of two vectors.",255,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"max","","Maximum of two vectors.",255,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"clone","","",256,{"i":[{"n":"self"}],"o":{"n":"u32x4"}}],[11,"fmt","","",256,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"partial_cmp","","",256,{"i":[{"n":"self"},{"n":"u32x4"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",256,{"i":[{"n":"self"},{"n":"u32x4"}],"o":{"n":"bool"}}],[11,"le","","",256,{"i":[{"n":"self"},{"n":"u32x4"}],"o":{"n":"bool"}}],[11,"gt","","",256,{"i":[{"n":"self"},{"n":"u32x4"}],"o":{"n":"bool"}}],[11,"ge","","",256,{"i":[{"n":"self"},{"n":"u32x4"}],"o":{"n":"bool"}}],[11,"new","","Creates a new instance with each vector elements initialized with the provided values.",256,{"i":[{"n":"u32"},{"n":"u32"},{"n":"u32"},{"n":"u32"}],"o":{"n":"self"}}],[11,"lanes","","Returns the number of vector lanes.",256,{"o":{"n":"usize"}}],[11,"splat","","Constructs a new instance with each element initialized to `value`.",256,{"i":[{"n":"u32"}],"o":{"n":"self"}}],[11,"extract","","Extracts the value at `index`.",256,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"u32"}}],[11,"extract_unchecked","","Extracts the value at `index`.",256,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"u32"}}],[11,"replace","","Returns a new vector where the value at `index` is replaced by `new_value`.",256,{"i":[{"n":"self"},{"n":"usize"},{"n":"u32"}],"o":{"n":"self"}}],[11,"replace_unchecked","","Returns a new vector where the value at `index` is replaced by `new_value`.",256,{"i":[{"n":"self"},{"n":"usize"},{"n":"u32"}],"o":{"n":"self"}}],[11,"store_aligned","","Writes the values of the vector to the `slice`.",256,null],[11,"store_unaligned","","Writes the values of the vector to the `slice`.",256,null],[11,"store_aligned_unchecked","","Writes the values of the vector to the `slice`.",256,null],[11,"store_unaligned_unchecked","","Writes the values of the vector to the `slice`.",256,null],[11,"load_aligned","","Instantiates a new vector with the values of the `slice`.",256,null],[11,"load_unaligned","","Instantiates a new vector with the values of the `slice`.",256,null],[11,"load_aligned_unchecked","","Instantiates a new vector with the values of the `slice`.",256,null],[11,"load_unaligned_unchecked","","Instantiates a new vector with the values of the `slice`.",256,null],[11,"eq","","Lane-wise equality comparison.",256,{"i":[{"n":"self"},{"n":"u32x4"}],"o":{"n":"m32x4"}}],[11,"ne","","Lane-wise inequality comparison.",256,{"i":[{"n":"self"},{"n":"u32x4"}],"o":{"n":"m32x4"}}],[11,"lt","","Lane-wise less-than comparison.",256,{"i":[{"n":"self"},{"n":"u32x4"}],"o":{"n":"m32x4"}}],[11,"le","","Lane-wise less-than-or-equals comparison.",256,{"i":[{"n":"self"},{"n":"u32x4"}],"o":{"n":"m32x4"}}],[11,"gt","","Lane-wise greater-than comparison.",256,{"i":[{"n":"self"},{"n":"u32x4"}],"o":{"n":"m32x4"}}],[11,"ge","","Lane-wise greater-than-or-equals comparison.",256,{"i":[{"n":"self"},{"n":"u32x4"}],"o":{"n":"m32x4"}}],[11,"hash","","",256,{"i":[{"n":"self"},{"n":"h"}]}],[11,"add","","",256,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"sub","","",256,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"mul","","",256,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"div","","",256,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"rem","","",256,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"add_assign","","",256,{"i":[{"n":"self"},{"n":"self"}]}],[11,"sub_assign","","",256,{"i":[{"n":"self"},{"n":"self"}]}],[11,"mul_assign","","",256,{"i":[{"n":"self"},{"n":"self"}]}],[11,"div_assign","","",256,{"i":[{"n":"self"},{"n":"self"}]}],[11,"rem_assign","","",256,{"i":[{"n":"self"},{"n":"self"}]}],[11,"add","","",256,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"self"}}],[11,"sub","","",256,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"self"}}],[11,"mul","","",256,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"self"}}],[11,"div","","",256,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"self"}}],[11,"rem","","",256,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"self"}}],[11,"add_assign","","",256,{"i":[{"n":"self"},{"n":"u32"}]}],[11,"sub_assign","","",256,{"i":[{"n":"self"},{"n":"u32"}]}],[11,"mul_assign","","",256,{"i":[{"n":"self"},{"n":"u32"}]}],[11,"div_assign","","",256,{"i":[{"n":"self"},{"n":"u32"}]}],[11,"rem_assign","","",256,{"i":[{"n":"self"},{"n":"u32"}]}],[11,"wrapping_sum","","Horizontal sum of the vector elements.",256,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"wrapping_product","","Horizontal product of the vector elements.",256,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"max_element","","Largest vector element value.",256,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"min_element","","Smallest vector element value.",256,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"bitxor","","",256,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"self"}}],[11,"bitand","","",256,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"self"}}],[11,"bitor","","",256,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"self"}}],[11,"bitand_assign","","",256,{"i":[{"n":"self"},{"n":"u32"}]}],[11,"bitor_assign","","",256,{"i":[{"n":"self"},{"n":"u32"}]}],[11,"bitxor_assign","","",256,{"i":[{"n":"self"},{"n":"u32"}]}],[11,"not","","",256,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"bitxor","","",256,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"bitand","","",256,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"bitor","","",256,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"bitand_assign","","",256,{"i":[{"n":"self"},{"n":"self"}]}],[11,"bitor_assign","","",256,{"i":[{"n":"self"},{"n":"self"}]}],[11,"bitxor_assign","","",256,{"i":[{"n":"self"},{"n":"self"}]}],[11,"and","","Lane-wise bitwise `and` of the vector elements.",256,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"or","","Lane-wise bitwise `or` of the vector elements.",256,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"xor","","Lane-wise bitwise `xor` of the vector elements.",256,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"shl","","",256,{"i":[{"n":"self"},{"n":"u8"}],"o":{"n":"self"}}],[11,"shr","","",256,{"i":[{"n":"self"},{"n":"u8"}],"o":{"n":"self"}}],[11,"shl_assign","","",256,{"i":[{"n":"self"},{"n":"u8"}]}],[11,"shr_assign","","",256,{"i":[{"n":"self"},{"n":"u8"}]}],[11,"shl","","",256,{"i":[{"n":"self"},{"n":"u16"}],"o":{"n":"self"}}],[11,"shr","","",256,{"i":[{"n":"self"},{"n":"u16"}],"o":{"n":"self"}}],[11,"shl_assign","","",256,{"i":[{"n":"self"},{"n":"u16"}]}],[11,"shr_assign","","",256,{"i":[{"n":"self"},{"n":"u16"}]}],[11,"shl","","",256,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"self"}}],[11,"shr","","",256,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"self"}}],[11,"shl_assign","","",256,{"i":[{"n":"self"},{"n":"u32"}]}],[11,"shr_assign","","",256,{"i":[{"n":"self"},{"n":"u32"}]}],[11,"shl","","",256,{"i":[{"n":"self"},{"n":"u64"}],"o":{"n":"self"}}],[11,"shr","","",256,{"i":[{"n":"self"},{"n":"u64"}],"o":{"n":"self"}}],[11,"shl_assign","","",256,{"i":[{"n":"self"},{"n":"u64"}]}],[11,"shr_assign","","",256,{"i":[{"n":"self"},{"n":"u64"}]}],[11,"shl","","",256,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"self"}}],[11,"shr","","",256,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"self"}}],[11,"shl_assign","","",256,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shr_assign","","",256,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"shl","","",256,{"i":[{"n":"self"},{"n":"i8"}],"o":{"n":"self"}}],[11,"shr","","",256,{"i":[{"n":"self"},{"n":"i8"}],"o":{"n":"self"}}],[11,"shl_assign","","",256,{"i":[{"n":"self"},{"n":"i8"}]}],[11,"shr_assign","","",256,{"i":[{"n":"self"},{"n":"i8"}]}],[11,"shl","","",256,{"i":[{"n":"self"},{"n":"i16"}],"o":{"n":"self"}}],[11,"shr","","",256,{"i":[{"n":"self"},{"n":"i16"}],"o":{"n":"self"}}],[11,"shl_assign","","",256,{"i":[{"n":"self"},{"n":"i16"}]}],[11,"shr_assign","","",256,{"i":[{"n":"self"},{"n":"i16"}]}],[11,"shl","","",256,{"i":[{"n":"self"},{"n":"i32"}],"o":{"n":"self"}}],[11,"shr","","",256,{"i":[{"n":"self"},{"n":"i32"}],"o":{"n":"self"}}],[11,"shl_assign","","",256,{"i":[{"n":"self"},{"n":"i32"}]}],[11,"shr_assign","","",256,{"i":[{"n":"self"},{"n":"i32"}]}],[11,"shl","","",256,{"i":[{"n":"self"},{"n":"i64"}],"o":{"n":"self"}}],[11,"shr","","",256,{"i":[{"n":"self"},{"n":"i64"}],"o":{"n":"self"}}],[11,"shl_assign","","",256,{"i":[{"n":"self"},{"n":"i64"}]}],[11,"shr_assign","","",256,{"i":[{"n":"self"},{"n":"i64"}]}],[11,"shl","","",256,{"i":[{"n":"self"},{"n":"isize"}],"o":{"n":"self"}}],[11,"shr","","",256,{"i":[{"n":"self"},{"n":"isize"}],"o":{"n":"self"}}],[11,"shl_assign","","",256,{"i":[{"n":"self"},{"n":"isize"}]}],[11,"shr_assign","","",256,{"i":[{"n":"self"},{"n":"isize"}]}],[11,"shl","","",256,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"shr","","",256,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"shl_assign","","",256,{"i":[{"n":"self"},{"n":"self"}]}],[11,"shr_assign","","",256,{"i":[{"n":"self"},{"n":"self"}]}],[11,"fmt","","",256,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",256,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",256,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",256,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"eq","","",256,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"bool"}}],[11,"ne","","",256,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"bool"}}],[11,"default","","",256,{"o":{"n":"self"}}],[11,"min","","Minimum of two vectors.",256,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"max","","Maximum of two vectors.",256,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"clone","","",257,{"i":[{"n":"self"}],"o":{"n":"f32x4"}}],[11,"fmt","","",257,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"partial_cmp","","",257,{"i":[{"n":"self"},{"n":"f32x4"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",257,{"i":[{"n":"self"},{"n":"f32x4"}],"o":{"n":"bool"}}],[11,"le","","",257,{"i":[{"n":"self"},{"n":"f32x4"}],"o":{"n":"bool"}}],[11,"gt","","",257,{"i":[{"n":"self"},{"n":"f32x4"}],"o":{"n":"bool"}}],[11,"ge","","",257,{"i":[{"n":"self"},{"n":"f32x4"}],"o":{"n":"bool"}}],[11,"new","","Creates a new instance with each vector elements initialized with the provided values.",257,{"i":[{"n":"f32"},{"n":"f32"},{"n":"f32"},{"n":"f32"}],"o":{"n":"self"}}],[11,"lanes","","Returns the number of vector lanes.",257,{"o":{"n":"usize"}}],[11,"splat","","Constructs a new instance with each element initialized to `value`.",257,{"i":[{"n":"f32"}],"o":{"n":"self"}}],[11,"extract","","Extracts the value at `index`.",257,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"f32"}}],[11,"extract_unchecked","","Extracts the value at `index`.",257,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"f32"}}],[11,"replace","","Returns a new vector where the value at `index` is replaced by `new_value`.",257,{"i":[{"n":"self"},{"n":"usize"},{"n":"f32"}],"o":{"n":"self"}}],[11,"replace_unchecked","","Returns a new vector where the value at `index` is replaced by `new_value`.",257,{"i":[{"n":"self"},{"n":"usize"},{"n":"f32"}],"o":{"n":"self"}}],[11,"store_aligned","","Writes the values of the vector to the `slice`.",257,null],[11,"store_unaligned","","Writes the values of the vector to the `slice`.",257,null],[11,"store_aligned_unchecked","","Writes the values of the vector to the `slice`.",257,null],[11,"store_unaligned_unchecked","","Writes the values of the vector to the `slice`.",257,null],[11,"load_aligned","","Instantiates a new vector with the values of the `slice`.",257,null],[11,"load_unaligned","","Instantiates a new vector with the values of the `slice`.",257,null],[11,"load_aligned_unchecked","","Instantiates a new vector with the values of the `slice`.",257,null],[11,"load_unaligned_unchecked","","Instantiates a new vector with the values of the `slice`.",257,null],[11,"eq","","Lane-wise equality comparison.",257,{"i":[{"n":"self"},{"n":"f32x4"}],"o":{"n":"m32x4"}}],[11,"ne","","Lane-wise inequality comparison.",257,{"i":[{"n":"self"},{"n":"f32x4"}],"o":{"n":"m32x4"}}],[11,"lt","","Lane-wise less-than comparison.",257,{"i":[{"n":"self"},{"n":"f32x4"}],"o":{"n":"m32x4"}}],[11,"le","","Lane-wise less-than-or-equals comparison.",257,{"i":[{"n":"self"},{"n":"f32x4"}],"o":{"n":"m32x4"}}],[11,"gt","","Lane-wise greater-than comparison.",257,{"i":[{"n":"self"},{"n":"f32x4"}],"o":{"n":"m32x4"}}],[11,"ge","","Lane-wise greater-than-or-equals comparison.",257,{"i":[{"n":"self"},{"n":"f32x4"}],"o":{"n":"m32x4"}}],[11,"add","","",257,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"sub","","",257,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"mul","","",257,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"div","","",257,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"rem","","",257,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"add_assign","","",257,{"i":[{"n":"self"},{"n":"self"}]}],[11,"sub_assign","","",257,{"i":[{"n":"self"},{"n":"self"}]}],[11,"mul_assign","","",257,{"i":[{"n":"self"},{"n":"self"}]}],[11,"div_assign","","",257,{"i":[{"n":"self"},{"n":"self"}]}],[11,"rem_assign","","",257,{"i":[{"n":"self"},{"n":"self"}]}],[11,"add","","",257,{"i":[{"n":"self"},{"n":"f32"}],"o":{"n":"self"}}],[11,"sub","","",257,{"i":[{"n":"self"},{"n":"f32"}],"o":{"n":"self"}}],[11,"mul","","",257,{"i":[{"n":"self"},{"n":"f32"}],"o":{"n":"self"}}],[11,"div","","",257,{"i":[{"n":"self"},{"n":"f32"}],"o":{"n":"self"}}],[11,"rem","","",257,{"i":[{"n":"self"},{"n":"f32"}],"o":{"n":"self"}}],[11,"add_assign","","",257,{"i":[{"n":"self"},{"n":"f32"}]}],[11,"sub_assign","","",257,{"i":[{"n":"self"},{"n":"f32"}]}],[11,"mul_assign","","",257,{"i":[{"n":"self"},{"n":"f32"}]}],[11,"div_assign","","",257,{"i":[{"n":"self"},{"n":"f32"}]}],[11,"rem_assign","","",257,{"i":[{"n":"self"},{"n":"f32"}]}],[11,"wrapping_sum","","Horizontal sum of the vector elements.",257,{"i":[{"n":"self"}],"o":{"n":"f32"}}],[11,"wrapping_product","","Horizontal product of the vector elements.",257,{"i":[{"n":"self"}],"o":{"n":"f32"}}],[11,"max_element","","Largest vector element value.",257,{"i":[{"n":"self"}],"o":{"n":"f32"}}],[11,"min_element","","Smallest vector element value.",257,{"i":[{"n":"self"}],"o":{"n":"f32"}}],[11,"neg","","",257,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"eq","","",257,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"bool"}}],[11,"ne","","",257,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"bool"}}],[11,"default","","",257,{"o":{"n":"self"}}],[11,"min","","Minimum of two vectors.",257,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"max","","Maximum of two vectors.",257,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"clone","","",258,{"i":[{"n":"self"}],"o":{"n":"m32x4"}}],[11,"fmt","","",258,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"partial_cmp","","",258,{"i":[{"n":"self"},{"n":"m32x4"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",258,{"i":[{"n":"self"},{"n":"m32x4"}],"o":{"n":"bool"}}],[11,"le","","",258,{"i":[{"n":"self"},{"n":"m32x4"}],"o":{"n":"bool"}}],[11,"gt","","",258,{"i":[{"n":"self"},{"n":"m32x4"}],"o":{"n":"bool"}}],[11,"ge","","",258,{"i":[{"n":"self"},{"n":"m32x4"}],"o":{"n":"bool"}}],[11,"new","","Creates a new instance with each vector elements initialized with the provided values.",258,{"i":[{"n":"bool"},{"n":"bool"},{"n":"bool"},{"n":"bool"}],"o":{"n":"self"}}],[11,"lanes","","Returns the number of vector lanes.",258,{"o":{"n":"usize"}}],[11,"splat","","Constructs a new instance with each element initialized to `value`.",258,{"i":[{"n":"bool"}],"o":{"n":"self"}}],[11,"extract","","Extracts the value at `index`.",258,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"bool"}}],[11,"extract_unchecked","","Extracts the value at `index`.",258,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"bool"}}],[11,"replace","","Returns a new vector where the value at `index` is replaced by `new_value`.",258,{"i":[{"n":"self"},{"n":"usize"},{"n":"bool"}],"o":{"n":"self"}}],[11,"replace_unchecked","","Returns a new vector where the value at `index` is replaced by `new_value`.",258,{"i":[{"n":"self"},{"n":"usize"},{"n":"bool"}],"o":{"n":"self"}}],[11,"not","","",258,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"bitxor","","",258,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"bitand","","",258,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"bitor","","",258,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"bitand_assign","","",258,{"i":[{"n":"self"},{"n":"self"}]}],[11,"bitor_assign","","",258,{"i":[{"n":"self"},{"n":"self"}]}],[11,"bitxor_assign","","",258,{"i":[{"n":"self"},{"n":"self"}]}],[11,"bitxor","","",258,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"self"}}],[11,"bitand","","",258,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"self"}}],[11,"bitor","","",258,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"self"}}],[11,"bitand_assign","","",258,{"i":[{"n":"self"},{"n":"bool"}]}],[11,"bitor_assign","","",258,{"i":[{"n":"self"},{"n":"bool"}]}],[11,"bitxor_assign","","",258,{"i":[{"n":"self"},{"n":"bool"}]}],[11,"and","","Lane-wise bitwise `and` of the vector elements.",258,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"or","","Lane-wise bitwise `or` of the vector elements.",258,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"xor","","Lane-wise bitwise `xor` of the vector elements.",258,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"all","","Are `all` vector lanes `true`?",258,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"any","","Is `any` vector lanes `true`?",258,{"i":[{"n":"self"}],"o":{