var N = null;var searchIndex = {};
searchIndex["alloc"]={"doc":"The Rust core allocation and collections library","items":[[0,"alloc","alloc","Memory allocation APIs",N,N],[3,"Excess","alloc::alloc","Represents the combination of a starting address and a total capacity of the returned block.",N,N],[12,"0","","",0,N],[12,"1","","",0,N],[3,"Layout","","Layout of a block of memory.",N,N],[3,"LayoutErr","","The parameters given to `Layout::from_size_align` or some other `Layout` constructor do not satisfy its documented constraints.",N,N],[3,"AllocErr","","The `AllocErr` error indicates an allocation failure that may be due to resource exhaustion or to something wrong when combining the given input arguments with this allocator.",N,N],[3,"CannotReallocInPlace","","The `CannotReallocInPlace` error is used when `grow_in_place` or `shrink_in_place` were unable to reuse the given memory block for a requested layout.",N,N],[8,"GlobalAlloc","","A memory allocator that can be registered as the standard library’s default though the `#[global_allocator]` attributes.",N,N],[10,"alloc","","Allocate memory as described by the given `layout`.",1,N],[10,"dealloc","","Deallocate the block of memory at the given `ptr` pointer with the given `layout`.",1,N],[11,"alloc_zeroed","","Behaves like `alloc`, but also ensures that the contents are set to zero before being returned.",1,N],[11,"realloc","","Shink or grow a block of memory to the given `new_size`. The block is described by the given `ptr` pointer and `layout`.",1,N],[8,"Alloc","","An implementation of `Alloc` can allocate, reallocate, and deallocate arbitrary blocks of data described via `Layout`.",N,N],[10,"alloc","","Returns a pointer meeting the size and alignment guarantees of `layout`.",2,[[["self"],["layout"]],["result",["nonnull","allocerr"]]]],[10,"dealloc","","Deallocate the memory referenced by `ptr`.",2,N],[11,"usable_size","","Returns bounds on the guaranteed usable size of a successful allocation created with the specified `layout`.",2,N],[11,"realloc","","Returns a pointer suitable for holding data described by a new layout with `layout`’s alginment and a size given by `new_size`. To accomplish this, this may extend or shrink the allocation referenced by `ptr` to fit the new layout.",2,[[["self"],["nonnull",["u8"]],["layout"],["usize"]],["result",["nonnull","allocerr"]]]],[11,"alloc_zeroed","","Behaves like `alloc`, but also ensures that the contents are set to zero before being returned.",2,[[["self"],["layout"]],["result",["nonnull","allocerr"]]]],[11,"alloc_excess","","Behaves like `alloc`, but also returns the whole size of the returned block. For some `layout` inputs, like arrays, this may include extra storage usable for additional data.",2,[[["self"],["layout"]],["result",["excess","allocerr"]]]],[11,"realloc_excess","","Behaves like `realloc`, but also returns the whole size of the returned block. For some `layout` inputs, like arrays, this may include extra storage usable for additional data.",2,[[["self"],["nonnull",["u8"]],["layout"],["usize"]],["result",["excess","allocerr"]]]],[11,"grow_in_place","","Attempts to extend the allocation referenced by `ptr` to fit `new_size`.",2,[[["self"],["nonnull",["u8"]],["layout"],["usize"]],["result",["cannotreallocinplace"]]]],[11,"shrink_in_place","","Attempts to shrink the allocation referenced by `ptr` to fit `new_size`.",2,[[["self"],["nonnull",["u8"]],["layout"],["usize"]],["result",["cannotreallocinplace"]]]],[11,"alloc_one","","Allocates a block suitable for holding an instance of `T`.",2,[[["self"]],["result",["nonnull","allocerr"]]]],[11,"dealloc_one","","Deallocates a block suitable for holding an instance of `T`.",2,N],[11,"alloc_array","","Allocates a block suitable for holding `n` instances of `T`.",2,[[["self"],["usize"]],["result",["nonnull","allocerr"]]]],[11,"realloc_array","","Reallocates a block previously suitable for holding `n_old` instances of `T`, returning a block suitable for holding `n_new` instances of `T`.",2,[[["self"],["nonnull"],["usize"],["usize"]],["result",["nonnull","allocerr"]]]],[11,"dealloc_array","","Deallocates a block suitable for holding `n` instances of `T`.",2,[[["self"],["nonnull"],["usize"]],["result",["allocerr"]]]],[3,"Global","","The global memory allocator.",N,N],[5,"alloc","","Allocate memory with the global allocator.",N,N],[5,"dealloc","","Deallocate memory with the global allocator.",N,N],[5,"realloc","","Reallocate memory with the global allocator.",N,N],[5,"alloc_zeroed","","Allocate zero-initialized memory with the global allocator.",N,N],[5,"handle_alloc_error","","Abort on memory allocation error or failure.",N,N],[11,"clone","","",3,[[["self"]],["global"]]],[11,"default","","",3,[[],["global"]]],[11,"fmt","","",3,[[["self"],["formatter"]],["result"]]],[11,"alloc","","",3,[[["self"],["layout"]],["result",["nonnull","allocerr"]]]],[11,"dealloc","","",3,[[["self"],["nonnull",["u8"]],["layout"]]]],[11,"realloc","","",3,[[["self"],["nonnull",["u8"]],["layout"],["usize"]],["result",["nonnull","allocerr"]]]],[11,"alloc_zeroed","","",3,[[["self"],["layout"]],["result",["nonnull","allocerr"]]]],[0,"task","alloc","Types and Traits for working with asynchronous tasks.",N,N],[3,"SpawnLocalObjError","alloc::task","The result of a failed spawn",N,N],[12,"kind","","The kind of error",4,N],[12,"future","","The future for which spawning inside a task was attempted",4,N],[8,"Executor","","A task executor.",N,N],[10,"spawn_obj","","Spawns a new task with the given future. The future will be polled until completion.",5,[[["self"],["futureobj"]],["result",["spawnobjerror"]]]],[11,"status","","Determines whether the executor is able to spawn new tasks.",5,[[["self"]],["result",["spawnerrorkind"]]]],[3,"SpawnErrorKind","","Provides the reason that an executor was unable to spawn.",N,N],[3,"Waker","","A `Waker` is a handle for waking up a task by notifying its executor that it is ready to be run.",N,N],[3,"LocalWaker","","A `LocalWaker` is a handle for waking up a task by notifying its executor that it is ready to be run.",N,N],[8,"UnsafeWake","","An unsafe trait for implementing custom memory management for a `Waker` or `LocalWaker`.",N,N],[10,"clone_raw","","Creates a clone of this `UnsafeWake` and stores it behind a `Waker`.",6,[[["self"]],["waker"]]],[10,"drop_raw","","Drops this instance of `UnsafeWake`, deallocating resources associated with it.",6,N],[10,"wake","","Indicates that the associated task is ready to make progress and should be `poll`ed.",6,N],[11,"wake_local","","Indicates that the associated task is ready to make progress and should be `poll`ed. This function is the same as `wake`, but can only be called from the thread that this `UnsafeWake` is \"local\" to. This allows for implementors to provide specialized wakeup behavior specific to the current thread. This function is called by `LocalWaker::wake`.",6,N],[4,"Poll","","Indicates whether a value is available or if the current task has been scheduled to receive a wakeup instead.",N,N],[13,"Ready","","Represents that a value is immediately ready.",7,N],[13,"Pending","","Represents that a value is not ready yet.",7,N],[3,"Context","","Information about the currently-running task.",N,N],[3,"SpawnObjError","","The result of a failed spawn",N,N],[12,"kind","","The kind of error",8,N],[12,"future","","The future for which spawning inside a task was attempted",8,N],[5,"local_waker","","Creates a `LocalWaker` from a local `wake`.",N,[[["arc"]],["localwaker"]]],[5,"local_waker_from_nonlocal","","Creates a `LocalWaker` from a non-local `wake`.",N,[[["arc"]],["localwaker"]]],[11,"from","","",9,[[["arc"]],["self"]]],[8,"Wake","","A way of waking up a specific task.",N,N],[10,"wake","","Indicates that the associated task is ready to make progress and should be `poll`ed.",10,[[["arc"]]]],[11,"wake_local","","Indicates that the associated task is ready to make progress and should be `poll`ed. This function is like `wake`, but can only be called from the thread on which this `Wake` was created.",10,[[["arc"]]]],[0,"boxed","alloc","A pointer type for heap allocation.",N,N],[3,"Box","alloc::boxed","A pointer type for heap allocation.",N,N],[3,"PinBox","","A pinned, heap allocated reference.",N,N],[8,"FnBox","","`FnBox` is a version of the `FnOnce` intended for use with boxed closure objects. The idea is that where one would normally store a `Box<FnOnce()>` in a data structure, you should use `Box<FnBox()>`. The two traits behave essentially the same, except that a `FnBox` closure can only be called if it is boxed. (Note that `FnBox` may be deprecated in the future if `Box<FnOnce()>` closures become directly usable.)",N,N],[16,"Output","","",11,N],[10,"call_box","","",11,N],[11,"new","","Allocates memory on the heap and then places `x` into it.",12,[[["t"]],["box"]]],[11,"from_raw","","Constructs a box from a raw pointer.",12,N],[11,"into_raw","","Consumes the `Box`, returning the wrapped raw pointer.",12,N],[11,"into_raw_non_null","","Consumes the `Box`, returning the wrapped pointer as `NonNull<T>`.",12,[[["box"]],["nonnull"]]],[11,"leak","","Consumes and leaks the `Box`, returning a mutable reference, `&'a mut T`. Note that the type `T` must outlive the chosen lifetime `'a`. If the type has only static references, or none at all, then this may be chosen to be `'static`.",12,[[["box"]],["t"]]],[11,"drop","","",12,[[["self"]]]],[11,"default","","Creates a `Box<T>`, with the `Default` value for T.",12,[[],["box"]]],[11,"default","","",12,[[],["box"]]],[11,"default","","",12,[[],["box",["str"]]]],[11,"clone","","Returns a new box with a `clone()` of this box's contents.",12,[[["self"]],["box"]]],[11,"clone_from","","Copies `source`'s contents into `self` without creating a new allocation.",12,[[["self"],["box"]]]],[11,"clone","","",12,[[["self"]],["self"]]],[11,"eq","","",12,[[["self"],["box"]],["bool"]]],[11,"ne","","",12,[[["self"],["box"]],["bool"]]],[11,"partial_cmp","","",12,[[["self"],["box"]],["option",["ordering"]]]],[11,"lt","","",12,[[["self"],["box"]],["bool"]]],[11,"le","","",12,[[["self"],["box"]],["bool"]]],[11,"ge","","",12,[[["self"],["box"]],["bool"]]],[11,"gt","","",12,[[["self"],["box"]],["bool"]]],[11,"cmp","","",12,[[["self"],["box"]],["ordering"]]],[11,"hash","","",12,[[["self"],["h"]]]],[11,"finish","","",12,[[["self"]],["u64"]]],[11,"write","","",12,N],[11,"write_u8","","",12,[[["self"],["u8"]]]],[11,"write_u16","","",12,[[["self"],["u16"]]]],[11,"write_u32","","",12,[[["self"],["u32"]]]],[11,"write_u64","","",12,[[["self"],["u64"]]]],[11,"write_u128","","",12,[[["self"],["u128"]]]],[11,"write_usize","","",12,[[["self"],["usize"]]]],[11,"write_i8","","",12,[[["self"],["i8"]]]],[11,"write_i16","","",12,[[["self"],["i16"]]]],[11,"write_i32","","",12,[[["self"],["i32"]]]],[11,"write_i64","","",12,[[["self"],["i64"]]]],[11,"write_i128","","",12,[[["self"],["i128"]]]],[11,"write_isize","","",12,[[["self"],["isize"]]]],[11,"from","","",12,[[["t"]],["self"]]],[11,"from","","",12,N],[11,"from","","",12,[[["str"]],["box",["str"]]]],[11,"from","","",12,[[["box",["str"]]],["self"]]],[11,"downcast","","Attempt to downcast the box to a concrete type.",12,[[["self"]],["result",["box","box"]]]],[11,"downcast","","Attempt to downcast the box to a concrete type.",12,[[["self"]],["result",["box","box"]]]],[11,"fmt","","",12,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",12,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",12,[[["self"],["formatter"]],["result"]]],[11,"deref","","",12,[[["self"]],["t"]]],[11,"deref_mut","","",12,[[["self"]],["t"]]],[11,"next","","",12,[[["self"]],["option"]]],[11,"size_hint","","",12,N],[11,"nth","","",12,[[["self"],["usize"]],["option"]]],[11,"next_back","","",12,[[["self"]],["option"]]],[11,"len","","",12,[[["self"]],["usize"]]],[11,"is_empty","","",12,[[["self"]],["bool"]]],[11,"call_once","","",12,[[["self"],["a"]],["r"]]],[11,"call_once","","",12,[[["self"],["a"]],["r"]]],[11,"clone","","",12,[[["self"]],["self"]]],[11,"borrow","","",12,[[["self"]],["t"]]],[11,"borrow_mut","","",12,[[["self"]],["t"]]],[11,"as_ref","","",12,[[["self"]],["t"]]],[11,"as_mut","","",12,[[["self"]],["t"]]],[11,"resume","","",12,[[["self"]],["generatorstate"]]],[11,"new","","Allocate memory on the heap, move the data into it and pin it.",13,[[["t"]],["pinbox"]]],[11,"as_pin_mut","","Get a pinned reference to the data in this PinBox.",13,[[["self"]],["pinmut"]]],[11,"from_raw","","Constructs a `PinBox` from a raw pointer.",13,N],[11,"into_raw","","Consumes the `PinBox`, returning the wrapped raw pointer.",13,N],[11,"get_mut","","Get a mutable reference to the data inside this PinBox.",13,[[["pinbox"]],["t"]]],[11,"unpin","","Convert this PinBox into an unpinned Box.",13,[[["pinbox"]],["box"]]],[11,"from","","",13,[[["box"]],["pinbox"]]],[11,"from","","",12,[[["pinbox"]],["box"]]],[11,"deref","","",13,[[["self"]],["t"]]],[11,"deref_mut","","",13,[[["self"]],["t"]]],[11,"fmt","","",13,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",13,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",13,[[["self"],["formatter"]],["result"]]],[11,"poll","","",12,[[["pinmut"],["context"]],["poll"]]],[11,"poll","","",13,[[["pinmut"],["context"]],["poll"]]],[11,"into_raw","","",12,N],[11,"poll","","",12,N],[11,"drop","","",12,N],[11,"into_raw","","",13,N],[11,"poll","","",13,N],[11,"drop","","",13,N],[11,"spawn_obj","","",12,[[["self"],["futureobj"]],["result",["spawnobjerror"]]]],[11,"status","","",12,[[["self"]],["result",["spawnerrorkind"]]]],[0,"collections","alloc","Collection types.",N,N],[4,"CollectionAllocErr","alloc::collections","Augments `AllocErr` with a CapacityOverflow variant.",N,N],[13,"CapacityOverflow","","Error due to the computed capacity exceeding the collection's maximum (usually `isize::MAX` bytes).",14,N],[13,"AllocErr","","Error due to the allocator (see the `AllocErr` type's docs).",14,N],[0,"binary_heap","","A priority queue implemented with a binary heap.",N,N],[3,"BinaryHeap","alloc::collections::binary_heap","A priority queue implemented with a binary heap.",N,N],[3,"PeekMut","","Structure wrapping a mutable reference to the greatest item on a `BinaryHeap`.",N,N],[3,"Iter","","An iterator over the elements of a `BinaryHeap`.",N,N],[3,"IntoIter","","An owning iterator over the elements of a `BinaryHeap`.",N,N],[3,"Drain","","A draining iterator over the elements of a `BinaryHeap`.",N,N],[11,"fmt","","",15,[[["self"],["formatter"]],["result"]]],[11,"drop","","",15,[[["self"]]]],[11,"deref","","",15,[[["self"]],["t"]]],[11,"deref_mut","","",15,[[["self"]],["t"]]],[11,"pop","","Removes the peeked value from the heap and returns it.",15,[[["peekmut"]],["t"]]],[11,"clone","","",16,[[["self"]],["self"]]],[11,"clone_from","","",16,[[["self"],["self"]]]],[11,"default","","Creates an empty `BinaryHeap<T>`.",16,[[],["binaryheap"]]],[11,"fmt","","",16,[[["self"],["formatter"]],["result"]]],[11,"new","","Creates an empty `BinaryHeap` as a max-heap.",16,[[],["binaryheap"]]],[11,"with_capacity","","Creates an empty `BinaryHeap` with a specific capacity. This preallocates enough memory for `capacity` elements, so that the `BinaryHeap` does not have to be reallocated until it contains at least that many values.",16,[[["usize"]],["binaryheap"]]],[11,"iter","","Returns an iterator visiting all values in the underlying vector, in arbitrary order.",16,[[["self"]],["iter"]]],[11,"peek","","Returns the greatest item in the binary heap, or `None` if it is empty.",16,[[["self"]],["option"]]],[11,"peek_mut","","Returns a mutable reference to the greatest item in the binary heap, or `None` if it is empty.",16,[[["self"]],["option",["peekmut"]]]],[11,"capacity","","Returns the number of elements the binary heap can hold without reallocating.",16,[[["self"]],["usize"]]],[11,"reserve_exact","","Reserves the minimum capacity for exactly `additional` more elements to be inserted in the given `BinaryHeap`. Does nothing if the capacity is already sufficient.",16,[[["self"],["usize"]]]],[11,"reserve","","Reserves capacity for at least `additional` more elements to be inserted in the `BinaryHeap`. The collection may reserve more space to avoid frequent reallocations.",16,[[["self"],["usize"]]]],[11,"shrink_to_fit","","Discards as much additional capacity as possible.",16,[[["self"]]]],[11,"shrink_to","","Discards capacity with a lower bound.",16,[[["self"],["usize"]]]],[11,"pop","","Removes the greatest item from the binary heap and returns it, or `None` if it is empty.",16,[[["self"]],["option"]]],[11,"push","","Pushes an item onto the binary heap.",16,[[["self"],["t"]]]],[11,"into_vec","","Consumes the `BinaryHeap` and returns the underlying vector in arbitrary order.",16,[[["self"]],["vec"]]],[11,"into_sorted_vec","","Consumes the `BinaryHeap` and returns a vector in sorted (ascending) order.",16,[[["self"]],["vec"]]],[11,"len","","Returns the length of the binary heap.",16,[[["self"]],["usize"]]],[11,"is_empty","","Checks if the binary heap is empty.",16,[[["self"]],["bool"]]],[11,"drain","","Clears the binary heap, returning an iterator over the removed elements.",16,[[["self"]],["drain"]]],[11,"clear","","Drops all items from the binary heap.",16,[[["self"]]]],[11,"append","","Moves all the elements of `other` into `self`, leaving `other` empty.",16,[[["self"],["self"]]]],[11,"fmt","","",17,[[["self"],["formatter"]],["result"]]],[11,"clone","","",17,[[["self"]],["iter"]]],[11,"next","","",17,[[["self"]],["option"]]],[11,"size_hint","","",17,N],[11,"next_back","","",17,[[["self"]],["option"]]],[11,"is_empty","","",17,[[["self"]],["bool"]]],[11,"clone","","",18,[[["self"]],["intoiter"]]],[11,"fmt","","",18,[[["self"],["formatter"]],["result"]]],[11,"next","","",18,[[["self"]],["option"]]],[11,"size_hint","","",18,N],[11,"next_back","","",18,[[["self"]],["option"]]],[11,"is_empty","","",18,[[["self"]],["bool"]]],[11,"fmt","","",19,[[["self"],["formatter"]],["result"]]],[11,"next","","",19,[[["self"]],["option"]]],[11,"size_hint","","",19,N],[11,"next_back","","",19,[[["self"]],["option"]]],[11,"is_empty","","",19,[[["self"]],["bool"]]],[11,"from","","",16,[[["vec"]],["binaryheap"]]],[11,"from_iter","","",16,[[["i"]],["binaryheap"]]],[11,"into_iter","","Creates a consuming iterator, that is, one that moves each value out of the binary heap in arbitrary order. The binary heap cannot be used after calling this.",16,[[["self"]],["intoiter"]]],[11,"extend","","",16,[[["self"],["i"]]]],[11,"extend","","",16,[[["self"],["i"]]]],[0,"linked_list","alloc::collections","A doubly-linked list with owned nodes.",N,N],[3,"LinkedList","alloc::collections::linked_list","A doubly-linked list with owned nodes.",N,N],[3,"Iter","","An iterator over the elements of a `LinkedList`.",N,N],[3,"IterMut","","A mutable iterator over the elements of a `LinkedList`.",N,N],[3,"IntoIter","","An owning iterator over the elements of a `LinkedList`.",N,N],[3,"DrainFilter","","An iterator produced by calling `drain_filter` on LinkedList.",N,N],[11,"fmt","","",20,[[["self"],["formatter"]],["result"]]],[11,"clone","","",20,[[["self"]],["self"]]],[11,"fmt","","",21,[[["self"],["formatter"]],["result"]]],[11,"clone","","",22,[[["self"]],["intoiter"]]],[11,"fmt","","",22,[[["self"],["formatter"]],["result"]]],[11,"default","","Creates an empty `LinkedList<T>`.",23,[[],["self"]]],[11,"new","","Creates an empty `LinkedList`.",23,[[],["self"]]],[11,"append","","Moves all elements from `other` to the end of the list.",23,[[["self"],["self"]]]],[11,"iter","","Provides a forward iterator.",23,[[["self"]],["iter"]]],[11,"iter_mut","","Provides a forward iterator with mutable references.",23,[[["self"]],["itermut"]]],[11,"is_empty","","Returns `true` if the `LinkedList` is empty.",23,[[["self"]],["bool"]]],[11,"len","","Returns the length of the `LinkedList`.",23,[[["self"]],["usize"]]],[11,"clear","","Removes all elements from the `LinkedList`.",23,[[["self"]]]],[11,"contains","","Returns `true` if the `LinkedList` contains an element equal to the given value.",23,[[["self"],["t"]],["bool"]]],[11,"front","","Provides a reference to the front element, or `None` if the list is empty.",23,[[["self"]],["option"]]],[11,"front_mut","","Provides a mutable reference to the front element, or `None` if the list is empty.",23,[[["self"]],["option"]]],[11,"back","","Provides a reference to the back element, or `None` if the list is empty.",23,[[["self"]],["option"]]],[11,"back_mut","","Provides a mutable reference to the back element, or `None` if the list is empty.",23,[[["self"]],["option"]]],[11,"push_front","","Adds an element first in the list.",23,[[["self"],["t"]]]],[11,"pop_front","","Removes the first element and returns it, or `None` if the list is empty.",23,[[["self"]],["option"]]],[11,"push_back","","Appends an element to the back of a list",23,[[["self"],["t"]]]],[11,"pop_back","","Removes the last element from a list and returns it, or `None` if it is empty.",23,[[["self"]],["option"]]],[11,"split_off","","Splits the list into two at the given index. Returns everything after the given index, including the index.",23,[[["self"],["usize"]],["linkedlist"]]],[11,"drain_filter","","Creates an iterator which uses a closure to determine if an element should be removed.",23,[[["self"],["f"]],["drainfilter"]]],[11,"drop","","",23,[[["self"]]]],[11,"next","","",20,[[["self"]],["option"]]],[11,"size_hint","","",20,N],[11,"next_back","","",20,[[["self"]],["option"]]],[11,"next","","",21,[[["self"]],["option"]]],[11,"size_hint","","",21,N],[11,"next_back","","",21,[[["self"]],["option"]]],[11,"insert_next","","Inserts the given element just after the element most recently returned by `.next()`. The inserted element does not appear in the iteration.",21,[[["self"],["t"]]]],[11,"peek_next","","Provides a reference to the next element, without changing the iterator.",21,[[["self"]],["option"]]],[11,"next","","",24,[[["self"]],["option"]]],[11,"size_hint","","",24,N],[11,"drop","","",24,[[["self"]]]],[11,"fmt","","",24,[[["self"],["formatter"]],["result"]]],[11,"next","","",22,[[["self"]],["option"]]],[11,"size_hint","","",22,N],[11,"next_back","","",22,[[["self"]],["option"]]],[11,"from_iter","","",23,[[["i"]],["self"]]],[11,"into_iter","","Consumes the list into an iterator yielding elements by value.",23,[[["self"]],["intoiter"]]],[11,"extend","","",23,[[["self"],["i"]]]],[11,"extend","","",23,[[["self"],["i"]]]],[11,"eq","","",23,[[["self"],["self"]],["bool"]]],[11,"ne","","",23,[[["self"],["self"]],["bool"]]],[11,"partial_cmp","","",23,[[["self"],["self"]],["option",["ordering"]]]],[11,"cmp","","",23,[[["self"],["self"]],["ordering"]]],[11,"clone","","",23,[[["self"]],["self"]]],[11,"fmt","","",23,[[["self"],["formatter"]],["result"]]],[11,"hash","","",23,[[["self"],["h"]]]],[0,"vec_deque","alloc::collections","A double-ended queue implemented with a growable ring buffer.",N,N],[3,"VecDeque","alloc::collections::vec_deque","A double-ended queue implemented with a growable ring buffer.",N,N],[3,"Iter","","An iterator over the elements of a `VecDeque`.",N,N],[3,"IterMut","","A mutable iterator over the elements of a `VecDeque`.",N,N],[3,"IntoIter","","An owning iterator over the elements of a `VecDeque`.",N,N],[3,"Drain","","A draining iterator over the elements of a `VecDeque`.",N,N],[11,"clone","","",25,[[["self"]],["vecdeque"]]],[11,"drop","","",25,[[["self"]]]],[11,"default","","Creates an empty `VecDeque<T>`.",25,[[],["vecdeque"]]],[11,"new","","Creates an empty `VecDeque`.",25,[[],["vecdeque"]]],[11,"with_capacity","","Creates an empty `VecDeque` with space for at least `n` elements.",25,[[["usize"]],["vecdeque"]]],[11,"get","","Retrieves an element in the `VecDeque` by index.",25,[[["self"],["usize"]],["option"]]],[11,"get_mut","","Retrieves an element in the `VecDeque` mutably by index.",25,[[["self"],["usize"]],["option"]]],[11,"swap","","Swaps elements at indices `i` and `j`.",25,[[["self"],["usize"],["usize"]]]],[11,"capacity","","Returns the number of elements the `VecDeque` can hold without reallocating.",25,[[["self"]],["usize"]]],[11,"reserve_exact","","Reserves the minimum capacity for exactly `additional` more elements to be inserted in the given `VecDeque`. Does nothing if the capacity is already sufficient.",25,[[["self"],["usize"]]]],[11,"reserve","","Reserves capacity for at least `additional` more elements to be inserted in the given `VecDeque`. The collection may reserve more space to avoid frequent reallocations.",25,[[["self"],["usize"]]]],[11,"try_reserve_exact","","Tries to reserves the minimum capacity for exactly `additional` more elements to be inserted in the given `VecDeque<T>`. After calling `reserve_exact`, capacity will be greater than or equal to `self.len() + additional`. Does nothing if the capacity is already sufficient.",25,[[["self"],["usize"]],["result",["collectionallocerr"]]]],[11,"try_reserve","","Tries to reserve capacity for at least `additional` more elements to be inserted in the given `VecDeque<T>`. The collection may reserve more space to avoid frequent reallocations. After calling `reserve`, capacity will be greater than or equal to `self.len() + additional`. Does nothing if capacity is already sufficient.",25,[[["self"],["usize"]],["result",["collectionallocerr"]]]],[11,"shrink_to_fit","","Shrinks the capacity of the `VecDeque` as much as possible.",25,[[["self"]]]],[11,"shrink_to","","Shrinks the capacity of the `VecDeque` with a lower bound.",25,[[["self"],["usize"]]]],[11,"truncate","","Shortens the `VecDeque`, dropping excess elements from the back.",25,[[["self"],["usize"]]]],[11,"iter","","Returns a front-to-back iterator.",25,[[["self"]],["iter"]]],[11,"iter_mut","","Returns a front-to-back iterator that returns mutable references.",25,[[["self"]],["itermut"]]],[11,"as_slices","","Returns a pair of slices which contain, in order, the contents of the `VecDeque`.",25,N],[11,"as_mut_slices","","Returns a pair of slices which contain, in order, the contents of the `VecDeque`.",25,N],[11,"len","","Returns the number of elements in the `VecDeque`.",25,[[["self"]],["usize"]]],[11,"is_empty","","Returns `true` if the `VecDeque` is empty.",25,[[["self"]],["bool"]]],[11,"drain","","Create a draining iterator that removes the specified range in the `VecDeque` and yields the removed items.",25,[[["self"],["r"]],["drain"]]],[11,"clear","","Clears the `VecDeque`, removing all values.",25,[[["self"]]]],[11,"contains","","Returns `true` if the `VecDeque` contains an element equal to the given value.",25,[[["self"],["t"]],["bool"]]],[11,"front","","Provides a reference to the front element, or `None` if the `VecDeque` is empty.",25,[[["self"]],["option"]]],[11,"front_mut","","Provides a mutable reference to the front element, or `None` if the `VecDeque` is empty.",25,[[["self"]],["option"]]],[11,"back","","Provides a reference to the back element, or `None` if the `VecDeque` is empty.",25,[[["self"]],["option"]]],[11,"back_mut","","Provides a mutable reference to the back element, or `None` if the `VecDeque` is empty.",25,[[["self"]],["option"]]],[11,"pop_front","","Removes the first element and returns it, or `None` if the `VecDeque` is empty.",25,[[["self"]],["option"]]],[11,"push_front","","Prepends an element to the `VecDeque`.",25,[[["self"],["t"]]]],[11,"push_back","","Appends an element to the back of the `VecDeque`.",25,[[["self"],["t"]]]],[11,"pop_back","","Removes the last element from the `VecDeque` and returns it, or `None` if it is empty.",25,[[["self"]],["option"]]],[11,"swap_remove_back","","Removes an element from anywhere in the `VecDeque` and returns it, replacing it with the last element.",25,[[["self"],["usize"]],["option"]]],[11,"swap_remove_front","","Removes an element from anywhere in the `VecDeque` and returns it, replacing it with the first element.",25,[[["self"],["usize"]],["option"]]],[11,"insert","","Inserts an element at `index` within the `VecDeque`, shifting all elements with indices greater than or equal to `index` towards the back.",25,[[["self"],["usize"],["t"]]]],[11,"remove","","Removes and returns the element at `index` from the `VecDeque`. Whichever end is closer to the removal point will be moved to make room, and all the affected elements will be moved to new positions. Returns `None` if `index` is out of bounds.",25,[[["self"],["usize"]],["option"]]],[11,"split_off","","Splits the `VecDeque` into two at the given index.",25,[[["self"],["usize"]],["self"]]],[11,"append","","Moves all the elements of `other` into `Self`, leaving `other` empty.",25,[[["self"],["self"]]]],[11,"retain","","Retains only the elements specified by the predicate.",25,[[["self"],["f"]]]],[11,"resize","","Modifies the `VecDeque` in-place so that `len()` is equal to new_len, either by removing excess elements from the back or by appending clones of `value` to the back.",25,[[["self"],["usize"],["t"]]]],[11,"fmt","","",26,[[["self"],["formatter"]],["result"]]],[11,"clone","","",26,[[["self"]],["iter"]]],[11,"next","","",26,[[["self"]],["option"]]],[11,"size_hint","","",26,N],[11,"fold","","",26,[[["self"],["acc"],["f"]],["acc"]]],[11,"next_back","","",26,[[["self"]],["option"]]],[11,"rfold","","",26,[[["self"],["acc"],["f"]],["acc"]]],[11,"is_empty","","",26,[[["self"]],["bool"]]],[11,"fmt","","",27,[[["self"],["formatter"]],["result"]]],[11,"next","","",27,[[["self"]],["option"]]],[11,"size_hint","","",27,N],[11,"fold","","",27,[[["self"],["acc"],["f"]],["acc"]]],[11,"next_back","","",27,[[["self"]],["option"]]],[11,"rfold","","",27,[[["self"],["acc"],["f"]],["acc"]]],[11,"is_empty","","",27,[[["self"]],["bool"]]],[11,"clone","","",28,[[["self"]],["intoiter"]]],[11,"fmt","","",28,[[["self"],["formatter"]],["result"]]],[11,"next","","",28,[[["self"]],["option"]]],[11,"size_hint","","",28,N],[11,"next_back","","",28,[[["self"]],["option"]]],[11,"is_empty","","",28,[[["self"]],["bool"]]],[11,"fmt","","",29,[[["self"],["formatter"]],["result"]]],[11,"drop","","",29,[[["self"]]]],[11,"next","","",29,[[["self"]],["option"]]],[11,"size_hint","","",29,N],[11,"next_back","","",29,[[["self"]],["option"]]],[11,"eq","","",25,[[["self"],["vecdeque"]],["bool"]]],[11,"eq","","",25,[[["self"],["vec"]],["bool"]]],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"eq","","",25,N],[11,"partial_cmp","","",25,[[["self"],["vecdeque"]],["option",["ordering"]]]],[11,"cmp","","",25,[[["self"],["vecdeque"]],["ordering"]]],[11,"hash","","",25,[[["self"],["h"]]]],[11,"index","","",25,[[["self"],["usize"]],["a"]]],[11,"index_mut","","",25,[[["self"],["usize"]],["a"]]],[11,"from_iter","","",25,[[["t"]],["vecdeque"]]],[11,"into_iter","","Consumes the `VecDeque` into a front-to-back iterator yielding elements by value.",25,[[["self"]],["intoiter"]]],[11,"extend","","",25,[[["self"],["t"]]]],[11,"extend","","",25,[[["self"],["i"]]]],[11,"fmt","","",25,[[["self"],["formatter"]],["result"]]],[11,"from","","",25,[[["vec"]],["self"]]],[0,"btree_map","alloc::collections","A map based on a B-Tree.",N,N],[3,"BTreeMap","alloc::collections::btree_map","A map based on a B-Tree.",N,N],[3,"Iter","","An iterator over the entries of a `BTreeMap`.",N,N],[3,"IterMut","","A mutable iterator over the entries of a `BTreeMap`.",N,N],[3,"IntoIter","","An owning iterator over the entries of a `BTreeMap`.",N,N],[3,"Keys","","An iterator over the keys of a `BTreeMap`.",N,N],[3,"Values","","An iterator over the values of a `BTreeMap`.",N,N],[3,"ValuesMut","","A mutable iterator over the values of a `BTreeMap`.",N,N],[3,"Range","","An iterator over a sub-range of entries in a `BTreeMap`.",N,N],[3,"RangeMut","","A mutable iterator over a sub-range of entries in a `BTreeMap`.",N,N],[3,"VacantEntry","","A view into a vacant entry in a `BTreeMap`. It is part of the [`Entry`] enum.",N,N],[3,"OccupiedEntry","","A view into an occupied entry in a `BTreeMap`. It is part of the [`Entry`] enum.",N,N],[4,"Entry","","A view into a single entry in a map, which may either be vacant or occupied.",N,N],[13,"Vacant","","A vacant entry.",30,N],[13,"Occupied","","An occupied entry.",30,N],[0,"btree_set","alloc::collections","A set based on a B-Tree.",N,N],[3,"BTreeSet","alloc::collections::btree_set","A set based on a B-Tree.",N,N],[3,"Iter","","An iterator over the items of a `BTreeSet`.",N,N],[3,"IntoIter","","An owning iterator over the items of a `BTreeSet`.",N,N],[3,"Range","","An iterator over a sub-range of items in a `BTreeSet`.",N,N],[3,"Difference","","A lazy iterator producing elements in the difference of `BTreeSet`s.",N,N],[3,"SymmetricDifference","","A lazy iterator producing elements in the symmetric difference of `BTreeSet`s.",N,N],[3,"Intersection","","A lazy iterator producing elements in the intersection of `BTreeSet`s.",N,N],[3,"Union","","A lazy iterator producing elements in the union of `BTreeSet`s.",N,N],[11,"clone","alloc::collections","",14,[[["self"]],["collectionallocerr"]]],[11,"eq","","",14,[[["self"],["collectionallocerr"]],["bool"]]],[11,"fmt","","",14,[[["self"],["formatter"]],["result"]]],[11,"from","","",14,[[["allocerr"]],["self"]]],[11,"from","","",14,[[["layouterr"]],["self"]]],[0,"sync","alloc","Thread-safe reference-counting pointers.",N,N],[3,"Arc","alloc::sync","A thread-safe reference-counting pointer. 'Arc' stands for 'Atomically Reference Counted'.",N,N],[3,"Weak","","`Weak` is a version of [`Arc`] that holds a non-owning reference to the managed value. The value is accessed by calling [`upgrade`] on the `Weak` pointer, which returns an [`Option`]`<`[`Arc`]`<T>>`.",N,N],[11,"fmt","","",31,[[["self"],["formatter"]],["result"]]],[11,"new","","Constructs a new `Arc<T>`.",32,[[["t"]],["arc"]]],[11,"try_unwrap","","Returns the contained value, if the `Arc` has exactly one strong reference.",32,[[["self"]],["result"]]],[11,"into_raw","","Consumes the `Arc`, returning the wrapped pointer.",32,N],[11,"from_raw","","Constructs an `Arc` from a raw pointer.",32,N],[11,"downgrade","","Creates a new [`Weak`][weak] pointer to this value.",32,[[["self"]],["weak"]]],[11,"weak_count","","Gets the number of [`Weak`][weak] pointers to this value.",32,[[["self"]],["usize"]]],[11,"strong_count","","Gets the number of strong (`Arc`) pointers to this value.",32,[[["self"]],["usize"]]],[11,"ptr_eq","","Returns true if the two `Arc`s point to the same value (not just values that compare as equal).",32,[[["self"],["self"]],["bool"]]],[11,"clone","","Makes a clone of the `Arc` pointer.",32,[[["self"]],["arc"]]],[11,"deref","","",32,[[["self"]],["t"]]],[11,"make_mut","","Makes a mutable reference into the given `Arc`.",32,[[["self"]],["t"]]],[11,"get_mut","","Returns a mutable reference to the inner value, if there are no other `Arc` or [`Weak`][weak] pointers to the same value.",32,[[["self"]],["option"]]],[11,"drop","","Drops the `Arc`.",32,[[["self"]]]],[11,"downcast","","Attempt to downcast the `Arc<dyn Any + Send + Sync>` to a concrete type.",32,[[["self"]],["result",["arc"]]]],[11,"new","","Constructs a new `Weak<T>`, without allocating any memory. Calling [`upgrade`] on the return value always gives [`None`].",31,[[],["weak"]]],[11,"upgrade","","Attempts to upgrade the `Weak` pointer to an [`Arc`], extending the lifetime of the value if successful.",31,[[["self"]],["option",["arc"]]]],[11,"clone","","Makes a clone of the `Weak` pointer that points to the same value.",31,[[["self"]],["weak"]]],[11,"default","","Constructs a new `Weak<T>`, without allocating memory. Calling [`upgrade`] on the return value always gives [`None`].",31,[[],["weak"]]],[11,"drop","","Drops the `Weak` pointer.",31,[[["self"]]]],[11,"eq","","Equality for two `Arc`s.",32,[[["self"],["arc"]],["bool"]]],[11,"ne","","Inequality for two `Arc`s.",32,[[["self"],["arc"]],["bool"]]],[11,"partial_cmp","","Partial comparison for two `Arc`s.",32,[[["self"],["arc"]],["option",["ordering"]]]],[11,"lt","","Less-than comparison for two `Arc`s.",32,[[["self"],["arc"]],["bool"]]],[11,"le","","'Less than or equal to' comparison for two `Arc`s.",32,[[["self"],["arc"]],["bool"]]],[11,"gt","","Greater-than comparison for two `Arc`s.",32,[[["self"],["arc"]],["bool"]]],[11,"ge","","'Greater than or equal to' comparison for two `Arc`s.",32,[[["self"],["arc"]],["bool"]]],[11,"cmp","","Comparison for two `Arc`s.",32,[[["self"],["arc"]],["ordering"]]],[11,"fmt","","",32,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",32,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",32,[[["self"],["formatter"]],["result"]]],[11,"default","","Creates a new `Arc<T>`, with the `Default` value for `T`.",32,[[],["arc"]]],[11,"hash","","",32,[[["self"],["h"]]]],[11,"from","","",32,[[["t"]],["self"]]],[11,"from","","",32,N],[11,"from","","",32,[[["str"]],["arc",["str"]]]],[11,"from","","",32,[[["string"]],["arc",["str"]]]],[11,"from","","",32,[[["box"]],["arc"]]],[11,"from","","",32,[[["vec"]],["arc"]]],[11,"borrow","","",32,[[["self"]],["t"]]],[11,"as_ref","","",32,[[["self"]],["t"]]],[0,"rc","alloc","Single-threaded reference-counting pointers. 'Rc' stands for 'Reference Counted'.",N,N],[3,"Rc","alloc::rc","A single-threaded reference-counting pointer. 'Rc' stands for 'Reference Counted'.",N,N],[3,"Weak","","`Weak` is a version of [`Rc`] that holds a non-owning reference to the managed value. The value is accessed by calling [`upgrade`] on the `Weak` pointer, which returns an [`Option`]`<`[`Rc`]`<T>>`.",N,N],[11,"new","","Constructs a new `Rc<T>`.",33,[[["t"]],["rc"]]],[11,"try_unwrap","","Returns the contained value, if the `Rc` has exactly one strong reference.",33,[[["self"]],["result"]]],[11,"into_raw","","Consumes the `Rc`, returning the wrapped pointer.",33,N],[11,"from_raw","","Constructs an `Rc` from a raw pointer.",33,N],[11,"downgrade","","Creates a new [`Weak`][weak] pointer to this value.",33,[[["self"]],["weak"]]],[11,"weak_count","","Gets the number of [`Weak`][weak] pointers to this value.",33,[[["self"]],["usize"]]],[11,"strong_count","","Gets the number of strong (`Rc`) pointers to this value.",33,[[["self"]],["usize"]]],[11,"get_mut","","Returns a mutable reference to the inner value, if there are no other `Rc` or [`Weak`][weak] pointers to the same value.",33,[[["self"]],["option"]]],[11,"ptr_eq","","Returns true if the two `Rc`s point to the same value (not just values that compare as equal).",33,[[["self"],["self"]],["bool"]]],[11,"make_mut","","Makes a mutable reference into the given `Rc`.",33,[[["self"]],["t"]]],[11,"downcast","","Attempt to downcast the `Rc<Any>` to a concrete type.",33,[[["self"]],["result",["rc","rc"]]]],[11,"deref","","",33,[[["self"]],["t"]]],[11,"drop","","Drops the `Rc`.",33,[[["self"]]]],[11,"clone","","Makes a clone of the `Rc` pointer.",33,[[["self"]],["rc"]]],[11,"default","","Creates a new `Rc<T>`, with the `Default` value for `T`.",33,[[],["rc"]]],[11,"eq","","Equality for two `Rc`s.",33,[[["self"],["rc"]],["bool"]]],[11,"ne","","Inequality for two `Rc`s.",33,[[["self"],["rc"]],["bool"]]],[11,"partial_cmp","","Partial comparison for two `Rc`s.",33,[[["self"],["rc"]],["option",["ordering"]]]],[11,"lt","","Less-than comparison for two `Rc`s.",33,[[["self"],["rc"]],["bool"]]],[11,"le","","'Less than or equal to' comparison for two `Rc`s.",33,[[["self"],["rc"]],["bool"]]],[11,"gt","","Greater-than comparison for two `Rc`s.",33,[[["self"],["rc"]],["bool"]]],[11,"ge","","'Greater than or equal to' comparison for two `Rc`s.",33,[[["self"],["rc"]],["bool"]]],[11,"cmp","","Comparison for two `Rc`s.",33,[[["self"],["rc"]],["ordering"]]],[11,"hash","","",33,[[["self"],["h"]]]],[11,"fmt","","",33,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",33,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",33,[[["self"],["formatter"]],["result"]]],[11,"from","","",33,[[["t"]],["self"]]],[11,"from","","",33,N],[11,"from","","",33,[[["str"]],["rc",["str"]]]],[11,"from","","",33,[[["string"]],["rc",["str"]]]],[11,"from","","",33,[[["box"]],["rc"]]],[11,"from","","",33,[[["vec"]],["rc"]]],[11,"new","","Constructs a new `Weak<T>`, without allocating any memory. Calling [`upgrade`] on the return value always gives [`None`].",34,[[],["weak"]]],[11,"upgrade","","Attempts to upgrade the `Weak` pointer to an [`Rc`], extending the lifetime of the value if successful.",34,[[["self"]],["option",["rc"]]]],[11,"drop","","Drops the `Weak` pointer.",34,[[["self"]]]],[11,"clone","","Makes a clone of the `Weak` pointer that points to the same value.",34,[[["self"]],["weak"]]],[11,"fmt","","",34,[[["self"],["formatter"]],["result"]]],[11,"default","","Constructs a new `Weak<T>`, allocating memory for `T` without initializing it. Calling [`upgrade`] on the return value always gives [`None`].",34,[[],["weak"]]],[11,"borrow","","",33,[[["self"]],["t"]]],[11,"as_ref","","",33,[[["self"]],["t"]]],[0,"prelude","alloc","The alloc Prelude",N,N],[0,"borrow","","A module for working with borrowed data.",N,N],[8,"Borrow","alloc::borrow","A trait for borrowing data.",N,N],[10,"borrow","","Immutably borrows from an owned value.",35,[[["self"]],["borrowed"]]],[8,"BorrowMut","","A trait for mutably borrowing data.",N,N],[10,"borrow_mut","","Mutably borrows from an owned value.",36,[[["self"]],["borrowed"]]],[4,"Cow","","A clone-on-write smart pointer.",N,N],[13,"Borrowed","","Borrowed data.",37,N],[13,"Owned","","Owned data.",37,N],[8,"ToOwned","","A generalization of `Clone` to borrowed data.",N,N],[16,"Owned","","",38,N],[10,"to_owned","","Creates owned data from borrowed data, usually by cloning.",38,N],[11,"clone_into","","Uses borrowed data to replace owned data, usually by cloning.",38,N],[11,"borrow","","",37,[[["self"]],["b"]]],[11,"clone","","",37,[[["self"]],["cow"]]],[11,"clone_from","","",37,[[["self"],["cow"]]]],[11,"to_mut","","Acquires a mutable reference to the owned form of the data.",37,N],[11,"into_owned","","Extracts the owned data.",37,N],[11,"deref","","",37,[[["self"]],["b"]]],[11,"cmp","","",37,[[["self"],["cow"]],["ordering"]]],[11,"eq","","",37,[[["self"],["cow"]],["bool"]]],[11,"partial_cmp","","",37,[[["self"],["cow"]],["option",["ordering"]]]],[11,"fmt","","",37,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",37,[[["self"],["formatter"]],["result"]]],[11,"default","","Creates an owned Cow<'a, B> with the default value for the contained owned value.",37,[[],["cow"]]],[11,"hash","","",37,[[["self"],["h"]]]],[11,"as_ref","","",37,[[["self"]],["t"]]],[11,"add","","",37,N],[11,"add","","",37,N],[11,"add_assign","","",37,[[["self"],["str"]]]],[11,"add_assign","","",37,[[["self"],["cow",["str"]]]]],[0,"fmt","alloc","Utilities for formatting and printing `String`s.",N,N],[3,"Formatter","alloc::fmt","A struct to represent both where to emit formatting strings to and how they should be formatted. A mutable version of this is passed to all formatting traits.",N,N],[6,"Result","","The type returned by formatter methods.",N,N],[8,"Write","","A collection of methods that are required to format a message into a stream.",N,N],[10,"write_str","","Writes a slice of bytes into this writer, returning whether the write succeeded.",39,[[["self"],["str"]],["result",["error"]]]],[11,"write_char","","Writes a [`char`] into this writer, returning whether the write succeeded.",39,[[["self"],["char"]],["result",["error"]]]],[11,"write_fmt","","Glue for usage of the [`write!`] macro with implementors of this trait.",39,[[["self"],["arguments"]],["result",["error"]]]],[8,"Binary","","`b` formatting.",N,N],[10,"fmt","","Formats the value using the given formatter.",40,[[["self"],["formatter"]],["result",["error"]]]],[8,"Octal","","`o` formatting.",N,N],[10,"fmt","","Formats the value using the given formatter.",41,[[["self"],["formatter"]],["result",["error"]]]],[8,"Debug","","`?` formatting.",N,N],[10,"fmt","","Formats the value using the given formatter.",42,[[["self"],["formatter"]],["result",["error"]]]],[8,"Display","","Format trait for an empty format, `{}`.",N,N],[10,"fmt","","Formats the value using the given formatter.",43,[[["self"],["formatter"]],["result",["error"]]]],[8,"LowerHex","","`x` formatting.",N,N],[10,"fmt","","Formats the value using the given formatter.",44,[[["self"],["formatter"]],["result",["error"]]]],[8,"Pointer","","`p` formatting.",N,N],[10,"fmt","","Formats the value using the given formatter.",45,[[["self"],["formatter"]],["result",["error"]]]],[8,"UpperHex","","`X` formatting.",N,N],[10,"fmt","","Formats the value using the given formatter.",46,[[["self"],["formatter"]],["result",["error"]]]],[8,"LowerExp","","`e` formatting.",N,N],[10,"fmt","","Formats the value using the given formatter.",47,[[["self"],["formatter"]],["result",["error"]]]],[8,"UpperExp","","`E` formatting.",N,N],[10,"fmt","","Formats the value using the given formatter.",48,[[["self"],["formatter"]],["result",["error"]]]],[3,"Error","","The error type which is returned from formatting a message into a stream.",N,N],[5,"write","","The `write` function takes an output stream, and an `Arguments` struct that can be precompiled with the `format_args!` macro.",N,[[["write"],["arguments"]],["result",["error"]]]],[3,"Arguments","","This structure represents a safely precompiled version of a format string and its arguments. This cannot be generated at runtime because it cannot safely be done, so no constructors are given and the fields are private to prevent modification.",N,N],[3,"DebugList","","A struct to help with `fmt::Debug` implementations.",N,N],[3,"DebugMap","","A struct to help with `fmt::Debug` implementations.",N,N],[3,"DebugSet","","A struct to help with `fmt::Debug` implementations.",N,N],[3,"DebugStruct","","A struct to help with `fmt::Debug` implementations.",N,N],[3,"DebugTuple","","A struct to help with `fmt::Debug` implementations.",N,N],[4,"Alignment","","Possible alignments returned by `Formatter::align`",N,N],[13,"Left","","Indication that contents should be left-aligned.",49,N],[13,"Right","","Indication that contents should be right-aligned.",49,N],[13,"Center","","Indication that contents should be center-aligned.",49,N],[5,"format","","The `format` function takes an [`Arguments`] struct and returns the resulting formatted string.",N,[[["arguments"]],["string"]]],[0,"slice","alloc","A dynamically-sized view into a contiguous sequence, `[T]`.",N,N],[3,"Chunks","alloc::slice","An iterator over a slice in (non-overlapping) chunks (`chunk_size` elements at a time).",N,N],[3,"Windows","","An iterator over overlapping subslices of length `size`.",N,N],[3,"Iter","","Immutable slice iterator",N,N],[3,"IterMut","","Mutable slice iterator.",N,N],[3,"SplitMut","","An iterator over the subslices of the vector which are separated by elements that match `pred`.",N,N],[3,"ChunksMut","","An iterator over a slice in (non-overlapping) mutable chunks (`chunk_size` elements at a time). When the slice len is not evenly divided by the chunk size, the last slice of the iteration will be the remainder.",N,N],[3,"Split","","An iterator over subslices separated by elements that match a predicate function.",N,N],[3,"SplitN","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits.",N,N],[3,"RSplitN","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits, starting from the end of the slice.",N,N],[3,"SplitNMut","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits.",N,N],[3,"RSplitNMut","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits, starting from the end of the slice.",N,N],[3,"RSplit","","An iterator over subslices separated by elements that match a predicate function, starting from the end of the slice.",N,N],[3,"RSplitMut","","An iterator over the subslices of the vector which are separated by elements that match `pred`, starting from the end of the slice.",N,N],[5,"from_raw_parts","","Forms a slice from a pointer and a length.",N,N],[5,"from_raw_parts_mut","","Performs the same functionality as `from_raw_parts`, except that a mutable slice is returned.",N,N],[5,"from_ref","","Converts a reference to T into a slice of length 1 (without copying).",N,N],[5,"from_mut","","Converts a reference to T into a slice of length 1 (without copying).",N,N],[8,"SliceIndex","","A helper trait used for indexing operations.",N,N],[16,"Output","","The output type returned by methods.",50,N],[10,"get","","Returns a shared reference to the output at this location, if in bounds.",50,[[["self"],["t"]],["option"]]],[10,"get_mut","","Returns a mutable reference to the output at this location, if in bounds.",50,[[["self"],["t"]],["option"]]],[10,"get_unchecked","","Returns a shared reference to the output at this location, without performing any bounds checking.",50,N],[10,"get_unchecked_mut","","Returns a mutable reference to the output at this location, without performing any bounds checking.",50,N],[10,"index","","Returns a shared reference to the output at this location, panicking if out of bounds.",50,N],[10,"index_mut","","Returns a mutable reference to the output at this location, panicking if out of bounds.",50,N],[3,"ExactChunks","","An iterator over a slice in (non-overlapping) chunks (`chunk_size` elements at a time).",N,N],[3,"ExactChunksMut","","An iterator over a slice in (non-overlapping) mutable chunks (`chunk_size` elements at a time).",N,N],[8,"SliceConcatExt","","An extension trait for concatenating slices",N,N],[16,"Output","","The resulting type after concatenation",51,N],[10,"concat","","Flattens a slice of `T` into a single value `Self::Output`.",51,N],[10,"join","","Flattens a slice of `T` into a single value `Self::Output`, placing a given separator between each.",51,N],[10,"connect","","",51,N],[0,"str","alloc","Unicode string slices.",N,N],[8,"FromStr","alloc::str","A trait to abstract the idea of creating a new instance of a type from a string.",N,N],[16,"Err","","The associated error which can be returned from parsing.",52,N],[10,"from_str","","Parses a string `s` to return a value of this type.",52,[[["str"]],["result"]]],[3,"Utf8Error","","Errors which can occur when attempting to interpret a sequence of [`u8`] as a string.",N,N],[3,"Lines","","An iterator over the lines of a string, as string slices.",N,N],[3,"LinesAny","","Created with the method [`lines_any`].",N,N],[3,"Split","","Created with the method [`split`].",N,N],[3,"RSplit","","Created with the method [`rsplit`].",N,N],[3,"SplitN","","Created with the method [`splitn`].",N,N],[3,"RSplitN","","Created with the method [`rsplitn`].",N,N],[3,"SplitTerminator","","Created with the method [`split_terminator`].",N,N],[3,"RSplitTerminator","","Created with the method [`rsplit_terminator`].",N,N],[3,"Matches","","Created with the method [`matches`].",N,N],[3,"RMatches","","Created with the method [`rmatches`].",N,N],[3,"MatchIndices","","Created with the method [`match_indices`].",N,N],[3,"RMatchIndices","","Created with the method [`rmatch_indices`].",N,N],[5,"from_utf8","","Converts a slice of bytes to a string slice.",N,N],[5,"from_utf8_mut","","Converts a mutable slice of bytes to a mutable string slice.",N,N],[3,"Chars","","An iterator over the [`char`]s of a string slice.",N,N],[3,"CharIndices","","An iterator over the [`char`]s of a string slice, and their positions.",N,N],[3,"Bytes","","An iterator over the bytes of a string slice.",N,N],[5,"from_utf8_unchecked","","Converts a slice of bytes to a string slice without checking that the string contains valid UTF-8.",N,N],[5,"from_utf8_unchecked_mut","","Converts a slice of bytes to a string slice without checking that the string contains valid UTF-8; mutable version.",N,N],[3,"ParseBoolError","","An error returned when parsing a `bool` using [`from_str`] fails",N,N],[3,"SplitWhitespace","","An iterator over the non-whitespace substrings of a string, separated by any amount of whitespace.",N,N],[0,"pattern","","The string Pattern API.",N,N],[8,"Pattern","alloc::str::pattern","A string pattern.",N,N],[16,"Searcher","","Associated searcher for this pattern",53,N],[10,"into_searcher","","Constructs the associated searcher from `self` and the `haystack` to search in.",53,N],[11,"is_contained_in","","Checks whether the pattern matches anywhere in the haystack",53,[[["self"],["str"]],["bool"]]],[11,"is_prefix_of","","Checks whether the pattern matches at the front of the haystack",53,[[["self"],["str"]],["bool"]]],[11,"is_suffix_of","","Checks whether the pattern matches at the back of the haystack",53,[[["self"],["str"]],["bool"]]],[4,"SearchStep","","Result of calling `Searcher::next()` or `ReverseSearcher::next_back()`.",N,N],[13,"Match","","Expresses that a match of the pattern has been found at `haystack[a..b]`.",54,N],[13,"Reject","","Expresses that `haystack[a..b]` has been rejected as a possible match of the pattern.",54,N],[13,"Done","","Expresses that every byte of the haystack has been visited, ending the iteration.",54,N],[8,"Searcher","","A searcher for a string pattern.",N,N],[10,"haystack","","Getter for the underlying string to be searched in",55,[[["self"]],["str"]]],[10,"next","","Performs the next search step starting from the front.",55,[[["self"]],["searchstep"]]],[11,"next_match","","Find the next `Match` result. See `next()`",55,[[["self"]],["option"]]],[11,"next_reject","","Find the next `Reject` result. See `next()` and `next_match()`",55,[[["self"]],["option"]]],[8,"ReverseSearcher","","A reverse searcher for a string pattern.",N,N],[10,"next_back","","Performs the next search step starting from the back.",56,[[["self"]],["searchstep"]]],[11,"next_match_back","","Find the next `Match` result. See `next_back()`",56,[[["self"]],["option"]]],[11,"next_reject_back","","Find the next `Reject` result. See `next_back()`",56,[[["self"]],["option"]]],[8,"DoubleEndedSearcher","","A marker trait to express that a `ReverseSearcher` can be used for a `DoubleEndedIterator` implementation.",N,N],[3,"CharSearcher","","Associated type for `<char as Pattern<'a>>::Searcher`.",N,N],[3,"CharSliceSearcher","","Associated type for `<&[char] as Pattern<'a>>::Searcher`.",N,N],[3,"CharPredicateSearcher","","Associated type for `<F as Pattern<'a>>::Searcher`.",N,N],[3,"StrSearcher","","Associated type for `<&str as Pattern<'a>>::Searcher`.",N,N],[3,"EncodeUtf16","alloc::str","An iterator of [`u16`] over the string encoded as UTF-16.",N,N],[3,"SplitAsciiWhitespace","","An iterator over the non-ASCII-whitespace substrings of a string, separated by any amount of ASCII whitespace.",N,N],[5,"from_boxed_utf8_unchecked","","Converts a boxed slice of bytes to a boxed string slice without checking that the string contains valid UTF-8.",N,[[["box"]],["box",["str"]]]],[0,"string","alloc","A UTF-8 encoded, growable string.",N,N],[3,"String","alloc::string","A UTF-8 encoded, growable string.",N,N],[3,"FromUtf8Error","","A possible error value when converting a `String` from a UTF-8 byte vector.",N,N],[3,"FromUtf16Error","","A possible error value when converting a `String` from a UTF-16 byte slice.",N,N],[3,"Drain","","A draining iterator for `String`.",N,N],[4,"ParseError","","An error when parsing a `String`.",N,N],[8,"ToString","","A trait for converting a value to a `String`.",N,N],[10,"to_string","","Converts the given value to a `String`.",57,[[["self"]],["string"]]],[11,"partial_cmp","","",58,[[["self"],["string"]],["option",["ordering"]]]],[11,"lt","","",58,[[["self"],["string"]],["bool"]]],[11,"le","","",58,[[["self"],["string"]],["bool"]]],[11,"gt","","",58,[[["self"],["string"]],["bool"]]],[11,"ge","","",58,[[["self"],["string"]],["bool"]]],[11,"cmp","","",58,[[["self"],["string"]],["ordering"]]],[11,"fmt","","",59,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",60,[[["self"],["formatter"]],["result"]]],[11,"new","","Creates a new empty `String`.",58,[[],["string"]]],[11,"with_capacity","","Creates a new empty `String` with a particular capacity.",58,[[["usize"]],["string"]]],[11,"from_utf8","","Converts a vector of bytes to a `String`.",58,[[["vec",["u8"]]],["result",["string","fromutf8error"]]]],[11,"from_utf8_lossy","","Converts a slice of bytes to a string, including invalid characters.",58,N],[11,"from_utf16","","Decode a UTF-16 encoded vector `v` into a `String`, returning [`Err`] if `v` contains any invalid data.",58,N],[11,"from_utf16_lossy","","Decode a UTF-16 encoded slice `v` into a `String`, replacing invalid data with the replacement character (U+FFFD).",58,N],[11,"from_raw_parts","","Creates a new `String` from a length, capacity, and pointer.",58,N],[11,"from_utf8_unchecked","","Converts a vector of bytes to a `String` without checking that the string contains valid UTF-8.",58,[[["vec",["u8"]]],["string"]]],[11,"into_bytes","","Converts a `String` into a byte vector.",58,[[["self"]],["vec",["u8"]]]],[11,"as_str","","Extracts a string slice containing the entire string.",58,[[["self"]],["str"]]],[11,"as_mut_str","","Converts a `String` into a mutable string slice.",58,[[["self"]],["str"]]],[11,"push_str","","Appends a given string slice onto the end of this `String`.",58,[[["self"],["str"]]]],[11,"capacity","","Returns this `String`'s capacity, in bytes.",58,[[["self"]],["usize"]]],[11,"reserve","","Ensures that this `String`'s capacity is at least `additional` bytes larger than its length.",58,[[["self"],["usize"]]]],[11,"reserve_exact","","Ensures that this `String`'s capacity is `additional` bytes larger than its length.",58,[[["self"],["usize"]]]],[11,"try_reserve","","Tries to reserve capacity for at least `additional` more elements to be inserted in the given `String`. The collection may reserve more space to avoid frequent reallocations. After calling `reserve`, capacity will be greater than or equal to `self.len() + additional`. Does nothing if capacity is already sufficient.",58,[[["self"],["usize"]],["result",["collectionallocerr"]]]],[11,"try_reserve_exact","","Tries to reserves the minimum capacity for exactly `additional` more elements to be inserted in the given `String`. After calling `reserve_exact`, capacity will be greater than or equal to `self.len() + additional`. Does nothing if the capacity is already sufficient.",58,[[["self"],["usize"]],["result",["collectionallocerr"]]]],[11,"shrink_to_fit","","Shrinks the capacity of this `String` to match its length.",58,[[["self"]]]],[11,"shrink_to","","Shrinks the capacity of this `String` with a lower bound.",58,[[["self"],["usize"]]]],[11,"push","","Appends the given [`char`] to the end of this `String`.",58,[[["self"],["char"]]]],[11,"as_bytes","","Returns a byte slice of this `String`'s contents.",58,N],[11,"truncate","","Shortens this `String` to the specified length.",58,[[["self"],["usize"]]]],[11,"pop","","Removes the last character from the string buffer and returns it.",58,[[["self"]],["option",["char"]]]],[11,"remove","","Removes a [`char`] from this `String` at a byte position and returns it.",58,[[["self"],["usize"]],["char"]]],[11,"retain","","Retains only the characters specified by the predicate.",58,[[["self"],["f"]]]],[11,"insert","","Inserts a character into this `String` at a byte position.",58,[[["self"],["usize"],["char"]]]],[11,"insert_str","","Inserts a string slice into this `String` at a byte position.",58,[[["self"],["usize"],["str"]]]],[11,"as_mut_vec","","Returns a mutable reference to the contents of this `String`.",58,[[["self"]],["vec"]]],[11,"len","","Returns the length of this `String`, in bytes.",58,[[["self"]],["usize"]]],[11,"is_empty","","Returns `true` if this `String` has a length of zero.",58,[[["self"]],["bool"]]],[11,"split_off","","Splits the string into two at the given index.",58,[[["self"],["usize"]],["string"]]],[11,"clear","","Truncates this `String`, removing all contents.",58,[[["self"]]]],[11,"drain","","Creates a draining iterator that removes the specified range in the string and yields the removed chars.",58,[[["self"],["r"]],["drain"]]],[11,"replace_range","","Removes the specified range in the string, and replaces it with the given string. The given string doesn't need to be the same length as the range.",58,[[["self"],["r"],["str"]]]],[11,"into_boxed_str","","Converts this `String` into a [`Box`]`<`[`str`]`>`.",58,[[["self"]],["box",["str"]]]],[11,"as_bytes","","Returns a slice of [`u8`]s bytes that were attempted to convert to a `String`.",59,N],[11,"into_bytes","","Returns the bytes that were attempted to convert to a `String`.",59,[[["self"]],["vec",["u8"]]]],[11,"utf8_error","","Fetch a `Utf8Error` to get more details about the conversion failure.",59,[[["self"]],["utf8error"]]],[11,"fmt","","",59,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",60,[[["self"],["formatter"]],["result"]]],[11,"clone","","",58,[[["self"]],["self"]]],[11,"clone_from","","",58,[[["self"],["self"]]]],[11,"from_iter","","",58,[[["i"]],["string"]]],[11,"from_iter","","",58,[[["i"]],["string"]]],[11,"from_iter","","",58,[[["i"]],["string"]]],[11,"from_iter","","",58,[[["i"]],["string"]]],[11,"from_iter","","",58,[[["i"]],["string"]]],[11,"extend","","",58,[[["self"],["i"]]]],[11,"extend","","",58,[[["self"],["i"]]]],[11,"extend","","",58,[[["self"],["i"]]]],[11,"extend","","",58,[[["self"],["i"]]]],[11,"extend","","",58,[[["self"],["i"]]]],[11,"eq","","",58,[[["self"],["string"]],["bool"]]],[11,"ne","","",58,[[["self"],["string"]],["bool"]]],[11,"eq","","",58,[[["self"],["str"]],["bool"]]],[11,"ne","","",58,[[["self"],["str"]],["bool"]]],[11,"eq","","",58,[[["self"],["str"]],["bool"]]],[11,"ne","","",58,[[["self"],["str"]],["bool"]]],[11,"eq","alloc::borrow","",37,[[["self"],["str"]],["bool"]]],[11,"ne","","",37,[[["self"],["str"]],["bool"]]],[11,"eq","","",37,[[["self"],["str"]],["bool"]]],[11,"ne","","",37,[[["self"],["str"]],["bool"]]],[11,"eq","","",37,[[["self"],["string"]],["bool"]]],[11,"ne","","",37,[[["self"],["string"]],["bool"]]],[11,"eq","alloc::string","",58,[[["self"],["cow"]],["bool"]]],[11,"ne","","",58,[[["self"],["cow"]],["bool"]]],[11,"default","","Creates an empty `String`.",58,[[],["string"]]],[11,"fmt","","",58,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",58,[[["self"],["formatter"]],["result"]]],[11,"hash","","",58,[[["self"],["h"]]]],[11,"add","","",58,[[["self"],["str"]],["string"]]],[11,"add_assign","","",58,[[["self"],["str"]]]],[11,"index","","",58,[[["self"],["range",["usize"]]],["str"]]],[11,"index","","",58,[[["self"],["rangeto",["usize"]]],["str"]]],[11,"index","","",58,[[["self"],["rangefrom",["usize"]]],["str"]]],[11,"index","","",58,[[["self"],["rangefull"]],["str"]]],[11,"index","","",58,[[["self"],["rangeinclusive",["usize"]]],["str"]]],[11,"index","","",58,[[["self"],["rangetoinclusive",["usize"]]],["str"]]],[11,"index_mut","","",58,[[["self"],["range",["usize"]]],["str"]]],[11,"index_mut","","",58,[[["self"],["rangeto",["usize"]]],["str"]]],[11,"index_mut","","",58,[[["self"],["rangefrom",["usize"]]],["str"]]],[11,"index_mut","","",58,[[["self"],["rangefull"]],["str"]]],[11,"index_mut","","",58,[[["self"],["rangeinclusive",["usize"]]],["str"]]],[11,"index_mut","","",58,[[["self"],["rangetoinclusive",["usize"]]],["str"]]],[11,"deref","","",58,[[["self"]],["str"]]],[11,"deref_mut","","",58,[[["self"]],["str"]]],[11,"from_str","","",58,[[["str"]],["result",["string","parseerror"]]]],[11,"clone","","",61,[[["self"]],["parseerror"]]],[11,"fmt","","",61,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",61,[[["self"],["formatter"]],["result"]]],[11,"eq","","",61,[[["self"],["parseerror"]],["bool"]]],[11,"to_string","alloc::borrow","",37,[[["self"]],["string"]]],[11,"to_string","alloc::string","",58,[[["self"]],["string"]]],[11,"as_ref","","",58,[[["self"]],["str"]]],[11,"as_ref","","",58,N],[11,"from","","",58,[[["str"]],["string"]]],[11,"from","","",58,[[["box",["str"]]],["string"]]],[11,"from","alloc::boxed","",12,[[["string"]],["box",["str"]]]],[11,"from","alloc::string","",58,[[["cow",["str"]]],["string"]]],[11,"from","alloc::borrow","",37,[[["str"]],["cow",["str"]]]],[11,"from","","",37,[[["string"]],["cow",["str"]]]],[11,"from","","",37,[[["string"]],["cow",["str"]]]],[11,"from_iter","","",37,[[["i"]],["cow",["str"]]]],[11,"from_iter","","",37,[[["i"]],["cow",["str"]]]],[11,"from_iter","","",37,[[["i"]],["cow",["str"]]]],[11,"write_str","alloc::string","",58,[[["self"],["str"]],["result"]]],[11,"write_char","","",58,[[["self"],["char"]],["result"]]],[11,"fmt","","",62,[[["self"],["formatter"]],["result"]]],[11,"drop","","",62,[[["self"]]]],[11,"next","","",62,[[["self"]],["option",["char"]]]],[11,"size_hint","","",62,N],[11,"next_back","","",62,[[["self"]],["option",["char"]]]],[0,"vec","alloc","A contiguous growable array type with heap-allocated contents, written `Vec<T>`.",N,N],[3,"Vec","alloc::vec","A contiguous growable array type, written `Vec<T>` but pronounced 'vector'.",N,N],[3,"IntoIter","","An iterator that moves out of a vector.",N,N],[3,"Drain","","A draining iterator for `Vec<T>`.",N,N],[3,"Splice","","A splicing iterator for `Vec`.",N,N],[3,"DrainFilter","","An iterator produced by calling `drain_filter` on Vec.",N,N],[11,"new","","Constructs a new, empty `Vec<T>`.",63,[[],["vec"]]],[11,"with_capacity","","Constructs a new, empty `Vec<T>` with the specified capacity.",63,[[["usize"]],["vec"]]],[11,"from_raw_parts","","Creates a `Vec<T>` directly from the raw components of another vector.",63,N],[11,"capacity","","Returns the number of elements the vector can hold without reallocating.",63,[[["self"]],["usize"]]],[11,"reserve","","Reserves capacity for at least `additional` more elements to be inserted in the given `Vec<T>`. The collection may reserve more space to avoid frequent reallocations. After calling `reserve`, capacity will be greater than or equal to `self.len() + additional`. Does nothing if capacity is already sufficient.",63,[[["self"],["usize"]]]],[11,"reserve_exact","","Reserves the minimum capacity for exactly `additional` more elements to be inserted in the given `Vec<T>`. After calling `reserve_exact`, capacity will be greater than or equal to `self.len() + additional`. Does nothing if the capacity is already sufficient.",63,[[["self"],["usize"]]]],[11,"try_reserve","","Tries to reserve capacity for at least `additional` more elements to be inserted in the given `Vec<T>`. The collection may reserve more space to avoid frequent reallocations. After calling `reserve`, capacity will be greater than or equal to `self.len() + additional`. Does nothing if capacity is already sufficient.",63,[[["self"],["usize"]],["result",["collectionallocerr"]]]],[11,"try_reserve_exact","","Tries to reserves the minimum capacity for exactly `additional` more elements to be inserted in the given `Vec<T>`. After calling `reserve_exact`, capacity will be greater than or equal to `self.len() + additional`. Does nothing if the capacity is already sufficient.",63,[[["self"],["usize"]],["result",["collectionallocerr"]]]],[11,"shrink_to_fit","","Shrinks the capacity of the vector as much as possible.",63,[[["self"]]]],[11,"shrink_to","","Shrinks the capacity of the vector with a lower bound.",63,[[["self"],["usize"]]]],[11,"into_boxed_slice","","Converts the vector into [`Box<[T]>`][owned slice].",63,[[["self"]],["box"]]],[11,"truncate","","Shortens the vector, keeping the first `len` elements and dropping the rest.",63,[[["self"],["usize"]]]],[11,"as_slice","","Extracts a slice containing the entire vector.",63,N],[11,"as_mut_slice","","Extracts a mutable slice of the entire vector.",63,N],[11,"set_len","","Sets the length of a vector.",63,[[["self"],["usize"]]]],[11,"swap_remove","","Removes an element from the vector and returns it.",63,[[["self"],["usize"]],["t"]]],[11,"insert","","Inserts an element at position `index` within the vector, shifting all elements after it to the right.",63,[[["self"],["usize"],["t"]]]],[11,"remove","","Removes and returns the element at position `index` within the vector, shifting all elements after it to the left.",63,[[["self"],["usize"]],["t"]]],[11,"retain","","Retains only the elements specified by the predicate.",63,[[["self"],["f"]]]],[11,"dedup_by_key","","Removes all but the first of consecutive elements in the vector that resolve to the same key.",63,[[["self"],["f"]]]],[11,"dedup_by","","Removes all but the first of consecutive elements in the vector satisfying a given equality relation.",63,[[["self"],["f"]]]],[11,"push","","Appends an element to the back of a collection.",63,[[["self"],["t"]]]],[11,"pop","","Removes the last element from a vector and returns it, or [`None`] if it is empty.",63,[[["self"]],["option"]]],[11,"append","","Moves all the elements of `other` into `Self`, leaving `other` empty.",63,[[["self"],["self"]]]],[11,"drain","","Creates a draining iterator that removes the specified range in the vector and yields the removed items.",63,[[["self"],["r"]],["drain"]]],[11,"clear","","Clears the vector, removing all values.",63,[[["self"]]]],[11,"len","","Returns the number of elements in the vector, also referred to as its 'length'.",63,[[["self"]],["usize"]]],[11,"is_empty","","Returns `true` if the vector contains no elements.",63,[[["self"]],["bool"]]],[11,"split_off","","Splits the collection into two at the given index.",63,[[["self"],["usize"]],["self"]]],[11,"resize_with","","Resizes the `Vec` in-place so that `len` is equal to `new_len`.",63,[[["self"],["usize"],["f"]]]],[11,"resize","","Resizes the `Vec` in-place so that `len` is equal to `new_len`.",63,[[["self"],["usize"],["t"]]]],[11,"extend_from_slice","","Clones and appends all elements in a slice to the `Vec`.",63,N],[11,"resize_default","","Resizes the `Vec` in-place so that `len` is equal to `new_len`.",63,[[["self"],["usize"]]]],[11,"dedup","","Removes consecutive repeated elements in the vector.",63,[[["self"]]]],[11,"remove_item","","Removes the first instance of `item` from the vector if the item exists.",63,[[["self"],["t"]],["option"]]],[11,"clone","","",63,[[["self"]],["vec"]]],[11,"clone_from","","",63,[[["self"],["vec"]]]],[11,"hash","","",63,[[["self"],["h"]]]],[11,"index","","",63,N],[11,"index_mut","","",63,N],[11,"deref","","",63,N],[11,"deref_mut","","",63,N],[11,"from_iter","","",63,[[["i"]],["vec"]]],[11,"into_iter","","Creates a consuming iterator, that is, one that moves each value out of the vector (from start to end). The vector cannot be used after calling this.",63,[[["self"]],["intoiter"]]],[11,"extend","","",63,[[["self"],["i"]]]],[11,"splice","","Creates a splicing iterator that replaces the specified range in the vector with the given `replace_with` iterator and yields the removed items. `replace_with` does not need to be the same length as `range`.",63,[[["self"],["r"],["i"]],["splice"]]],[11,"drain_filter","","Creates an iterator which uses a closure to determine if an element should be removed.",63,[[["self"],["f"]],["drainfilter"]]],[11,"extend","","",63,[[["self"],["i"]]]],[11,"eq","","",63,[[["self"],["vec"]],["bool"]]],[11,"ne","","",63,[[["self"],["vec"]],["bool"]]],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","alloc::borrow","",37,N],[11,"ne","","",37,N],[11,"eq","","",37,N],[11,"ne","","",37,N],[11,"eq","","",37,[[["self"],["vec"]],["bool"]]],[11,"ne","","",37,[[["self"],["vec"]],["bool"]]],[11,"eq","alloc::vec","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"eq","","",63,N],[11,"ne","","",63,N],[11,"partial_cmp","","",63,[[["self"],["vec"]],["option",["ordering"]]]],[11,"cmp","","",63,[[["self"],["vec"]],["ordering"]]],[11,"drop","","",63,[[["self"]]]],[11,"default","","Creates an empty `Vec<T>`.",63,[[],["vec"]]],[11,"fmt","","",63,[[["self"],["formatter"]],["result"]]],[11,"as_ref","","",63,[[["self"]],["vec"]]],[11,"as_mut","","",63,[[["self"]],["vec"]]],[11,"as_ref","","",63,N],[11,"as_mut","","",63,N],[11,"from","","",63,N],[11,"from","","",63,N],[11,"from","","",63,[[["cow"]],["vec"]]],[11,"from","","",63,[[["box"]],["vec"]]],[11,"from","alloc::boxed","",12,[[["vec"]],["box"]]],[11,"from","alloc::vec","",63,[[["str"]],["vec",["u8"]]]],[11,"from","alloc::borrow","",37,N],[11,"from","","",37,[[["vec"]],["cow"]]],[11,"from","","",37,[[["vec"]],["cow"]]],[11,"from_iter","","",37,[[["i"]],["cow"]]],[11,"fmt","alloc::vec","",64,[[["self"],["formatter"]],["result"]]],[11,"as_slice","","Returns the remaining items of this iterator as a slice.",64,N],[11,"as_mut_slice","","Returns the remaining items of this iterator as a mutable slice.",64,N],[11,"next","","",64,[[["self"]],["option"]]],[11,"size_hint","","",64,N],[11,"count","","",64,[[["self"]],["usize"]]],[11,"next_back","","",64,[[["self"]],["option"]]],[11,"is_empty","","",64,[[["self"]],["bool"]]],[11,"clone","","",64,[[["self"]],["intoiter"]]],[11,"drop","","",64,[[["self"]]]],[11,"fmt","","",65,[[["self"],["formatter"]],["result"]]],[11,"next","","",65,[[["self"]],["option"]]],[11,"size_hint","","",65,N],[11,"next_back","","",65,[[["self"]],["option"]]],[11,"drop","","",65,[[["self"]]]],[11,"is_empty","","",65,[[["self"]],["bool"]]],[11,"fmt","","",66,[[["self"],["formatter"]],["result"]]],[11,"next","","",66,[[["self"]],["option"]]],[11,"size_hint","","",66,N],[11,"next_back","","",66,[[["self"]],["option"]]],[11,"drop","","",66,[[["self"]]]],[11,"fmt","","",67,[[["self"],["formatter"]],["result"]]],[11,"next","","",67,[[["self"]],["option"]]],[11,"size_hint","","",67,N],[11,"drop","","",67,[[["self"]]]],[14,"vec","alloc","Creates a [`Vec`] containing the arguments.",N,N],[14,"format","","Creates a `String` using interpolation of runtime expressions.",N,N],[11,"next","alloc::slice","",68,[[["self"]],["option"]]],[11,"size_hint","","",68,N],[11,"next","alloc::str","",69,[[["self"]],["option",["str"]]]],[11,"size_hint","","",69,N],[11,"next","","",70,[[["self"]],["option",["u16"]]]],[11,"size_hint","","",70,N],[11,"next","alloc::slice","",71,[[["self"]],["option"]]],[11,"size_hint","","",71,N],[11,"count","","",71,[[["self"]],["usize"]]],[11,"nth","","",71,[[["self"],["usize"]],["option"]]],[11,"last","","",71,[[["self"]],["option"]]],[11,"next","","",72,[[["self"]],["option"]]],[11,"size_hint","","",72,N],[11,"next","alloc::str","",73,[[["self"]],["option",["str"]]]],[11,"size_hint","","",73,N],[11,"next","","",74,[[["self"]],["option",["str"]]]],[11,"next","","",75,[[["self"]],["option",["str"]]]],[11,"next","","",76,[[["self"]],["option",["str"]]]],[11,"size_hint","","",76,N],[11,"next","alloc::slice","",77,[[["self"]],["option"]]],[11,"size_hint","","",77,N],[11,"count","","",77,[[["self"]],["usize"]]],[11,"nth","","",77,[[["self"],["usize"]],["option"]]],[11,"last","","",77,[[["self"]],["option"]]],[11,"next","alloc::str","",78,[[["self"]],["option",["char"]]]],[11,"count","","",78,[[["self"]],["usize"]]],[11,"size_hint","","",78,N],[11,"last","","",78,[[["self"]],["option",["char"]]]],[11,"next","alloc::slice","",79,[[["self"]],["option"]]],[11,"size_hint","","",79,N],[11,"count","","",79,[[["self"]],["usize"]]],[11,"nth","","",79,[[["self"],["usize"]],["option"]]],[11,"last","","",79,[[["self"]],["option"]]],[11,"next","","",80,[[["self"]],["option"]]],[11,"size_hint","","",80,N],[11,"next","","",81,[[["self"]],["option"]]],[11,"size_hint","","",81,N],[11,"next","alloc::str","",82,[[["self"]],["option"]]],[11,"count","","",82,[[["self"]],["usize"]]],[11,"size_hint","","",82,N],[11,"last","","",82,[[["self"]],["option"]]],[11,"next","","",83,[[["self"]],["option"]]],[11,"next","alloc::slice","",84,[[["self"]],["option"]]],[11,"size_hint","","",84,N],[11,"next","","",85,[[["self"]],["option"]]],[11,"size_hint","","",85,N],[11,"count","","",85,[[["self"]],["usize"]]],[11,"nth","","",85,[[["self"],["usize"]],["option"]]],[11,"last","","",85,[[["self"]],["option"]]],[11,"try_fold","","",85,[[["self"],["b"],["f"]],["r"]]],[11,"fold","","",85,[[["self"],["acc"],["fold"]],["acc"]]],[11,"position","","",85,[[["self"],["p"]],["option",["usize"]]]],[11,"rposition","","",85,[[["self"],["p"]],["option",["usize"]]]],[11,"next","","",86,[[["self"]],["option"]]],[11,"size_hint","","",86,N],[11,"count","","",86,[[["self"]],["usize"]]],[11,"nth","","",86,[[["self"],["usize"]],["option"]]],[11,"last","","",86,[[["self"]],["option"]]],[11,"next","alloc::str","",87,[[["self"]],["option"]]],[11,"next","alloc::slice","",88,[[["self"]],["option"]]],[11,"size_hint","","",88,N],[11,"next","alloc::str","",89,[[["self"]],["option",["str"]]]],[11,"next","","",90,[[["self"]],["option",["str"]]]],[11,"next","alloc::slice","",91,[[["self"]],["option"]]],[11,"size_hint","","",91,N],[11,"next","alloc::str","",92,[[["self"]],["option",["str"]]]],[11,"next","alloc::slice","",93,[[["self"]],["option"]]],[11,"size_hint","","",93,N],[11,"count","","",93,[[["self"]],["usize"]]],[11,"nth","","",93,[[["self"],["usize"]],["option"]]],[11,"last","","",93,[[["self"]],["option"]]],[11,"try_fold","","",93,[[["self"],["b"],["f"]],["r"]]],[11,"fold","","",93,[[["self"],["acc"],["fold"]],["acc"]]],[11,"position","","",93,[[["self"],["p"]],["option",["usize"]]]],[11,"rposition","","",93,[[["self"],["p"]],["option",["usize"]]]],[11,"next","alloc::str","",94,[[["self"]],["option",["str"]]]],[11,"next","","",95,[[["self"]],["option",["str"]]]],[11,"next","","",96,[[["self"]],["option",["u8"]]]],[11,"size_hint","","",96,N],[11,"count","","",96,[[["self"]],["usize"]]],[11,"last","","",96,[[["self"]],["option"]]],[11,"nth","","",96,[[["self"],["usize"]],["option"]]],[11,"all","","",96,[[["self"],["f"]],["bool"]]],[11,"any","","",96,[[["self"],["f"]],["bool"]]],[11,"find","","",96,[[["self"],["p"]],["option"]]],[11,"position","","",96,[[["self"],["p"]],["option",["usize"]]]],[11,"rposition","","",96,[[["self"],["p"]],["option",["usize"]]]],[11,"next","alloc::slice","",97,[[["self"]],["option"]]],[11,"size_hint","","",97,N],[11,"next","","",98,[[["self"]],["option"]]],[11,"size_hint","","",98,N],[11,"count","","",98,[[["self"]],["usize"]]],[11,"nth","","",98,[[["self"],["usize"]],["option"]]],[11,"last","","",98,[[["self"]],["option"]]],[11,"next","alloc::str","",99,[[["self"]],["option",["str"]]]],[11,"next","","",100,[[["self"]],["option",["str"]]]],[11,"size_hint","","",100,N],[11,"next_back","","",96,[[["self"]],["option",["u8"]]]],[11,"rfind","","",96,[[["self"],["p"]],["option"]]],[11,"next_back","alloc::slice","",98,[[["self"]],["option"]]],[11,"next_back","","",79,[[["self"]],["option"]]],[11,"next_back","alloc::str","",75,[[["self"]],["option",["str"]]]],[11,"next_back","alloc::slice","",71,[[["self"]],["option"]]],[11,"next_back","alloc::str","",100,[[["self"]],["option",["str"]]]],[11,"next_back","alloc::slice","",93,[[["self"]],["option"]]],[11,"try_rfold","","",93,[[["self"],["b"],["f"]],["r"]]],[11,"rfold","","",93,[[["self"],["acc"],["fold"]],["acc"]]],[11,"next_back","","",85,[[["self"]],["option"]]],[11,"try_rfold","","",85,[[["self"],["b"],["f"]],["r"]]],[11,"rfold","","",85,[[["self"],["acc"],["fold"]],["acc"]]],[11,"next_back","alloc::str","",69,[[["self"]],["option",["str"]]]],[11,"next_back","","",90,[[["self"]],["option",["str"]]]],[11,"next_back","","",94,[[["self"]],["option",["str"]]]],[11,"next_back","","",76,[[["self"]],["option",["str"]]]],[11,"next_back","","",89,[[["self"]],["option",["str"]]]],[11,"next_back","alloc::slice","",80,[[["self"]],["option"]]],[11,"next_back","","",86,[[["self"]],["option"]]],[11,"next_back","alloc::str","",73,[[["self"]],["option",["str"]]]],[11,"next_back","alloc::slice","",68,[[["self"]],["option"]]],[11,"next_back","","",72,[[["self"]],["option"]]],[11,"next_back","","",81,[[["self"]],["option"]]],[11,"next_back","alloc::str","",82,[[["self"]],["option"]]],[11,"next_back","","",92,[[["self"]],["option",["str"]]]],[11,"next_back","","",83,[[["self"]],["option"]]],[11,"next_back","alloc::slice","",77,[[["self"]],["option"]]],[11,"next_back","alloc::str","",78,[[["self"]],["option",["char"]]]],[11,"next_back","","",87,[[["self"]],["option"]]],[11,"next_back","","",99,[[["self"]],["option",["str"]]]],[11,"default","alloc::fmt","",101,[[],["error"]]],[11,"into_result","alloc::task","",7,[[["self"]],["result"]]],[11,"from_error","","",7,N],[11,"from_ok","","",7,N],[11,"into_result","","",7,[[["self"]],["result"]]],[11,"from_error","","",7,N],[11,"from_ok","","",7,N],[11,"eq","alloc::str","",102,[[["self"],["parseboolerror"]],["bool"]]],[11,"ne","","",102,[[["self"],["parseboolerror"]],["bool"]]],[11,"eq","alloc::alloc","",103,[[["self"],["cannotreallocinplace"]],["bool"]]],[11,"eq","alloc::fmt","",101,[[["self"],["error"]],["bool"]]],[11,"eq","alloc::str::pattern","",54,[[["self"],["searchstep"]],["bool"]]],[11,"ne","","",54,[[["self"],["searchstep"]],["bool"]]],[11,"eq","alloc::alloc","",104,[[["self"],["allocerr"]],["bool"]]],[11,"eq","alloc::task","",7,[[["self"],["poll"]],["bool"]]],[11,"ne","","",7,[[["self"],["poll"]],["bool"]]],[11,"eq","alloc::alloc","",105,[[["self"],["layout"]],["bool"]]],[11,"ne","","",105,[[["self"],["layout"]],["bool"]]],[11,"eq","","",106,[[["self"],["layouterr"]],["bool"]]],[11,"ne","","",106,[[["self"],["layouterr"]],["bool"]]],[11,"eq","alloc::str","",107,[[["self"],["utf8error"]],["bool"]]],[11,"ne","","",107,[[["self"],["utf8error"]],["bool"]]],[11,"write_str","alloc::fmt","",108,[[["self"],["str"]],["result",["error"]]]],[11,"write_char","","",108,[[["self"],["char"]],["result",["error"]]]],[11,"write_fmt","","",108,[[["self"],["arguments"]],["result",["error"]]]],[11,"cmp","","",101,[[["self"],["error"]],["ordering"]]],[11,"cmp","alloc::task","",7,[[["self"],["poll"]],["ordering"]]],[11,"partial_cmp","","",7,[[["self"],["poll"]],["option",["ordering"]]]],[11,"lt","","",7,[[["self"],["poll"]],["bool"]]],[11,"le","","",7,[[["self"],["poll"]],["bool"]]],[11,"gt","","",7,[[["self"],["poll"]],["bool"]]],[11,"ge","","",7,[[["self"],["poll"]],["bool"]]],[11,"partial_cmp","alloc::fmt","",101,[[["self"],["error"]],["option",["ordering"]]]],[11,"is_empty","alloc::slice","",98,[[["self"]],["bool"]]],[11,"is_empty","","",71,[[["self"]],["bool"]]],[11,"len","alloc::str","",96,[[["self"]],["usize"]]],[11,"is_empty","","",96,[[["self"]],["bool"]]],[11,"is_empty","alloc::slice","",85,[[["self"]],["bool"]]],[11,"is_empty","","",93,[[["self"]],["bool"]]],[11,"next_back","alloc::str::pattern","",109,[[["self"]],["searchstep"]]],[11,"next_match_back","","",109,[[["self"]],["option"]]],[11,"next_back","","",110,[[["self"]],["searchstep"]]],[11,"next_match_back","","",110,[[["self"]],["option"]]],[11,"next_reject_back","","",110,[[["self"]],["option"]]],[11,"next_back","","",111,[[["self"]],["searchstep"]]],[11,"next_match_back","","",111,[[["self"]],["option"]]],[11,"next_reject_back","","",111,[[["self"]],["option"]]],[11,"next_back","","",112,[[["self"]],["searchstep"]]],[11,"next_match_back","","",112,[[["self"]],["option"]]],[11,"drop","alloc::task","",113,N],[11,"drop","","",9,N],[11,"as_ref","alloc::slice","",85,N],[11,"hash","alloc::fmt","",101,N],[11,"hash","alloc::task","",7,N],[11,"fmt","alloc::alloc","",103,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::fmt","",101,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::str","",102,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::fmt","",114,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::alloc","",106,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","","",104,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::str","",107,[[["self"],["formatter"]],["result",["error"]]]],[11,"haystack","alloc::str::pattern","",111,[[["self"]],["str"]]],[11,"next","","",111,[[["self"]],["searchstep"]]],[11,"next_match","","",111,[[["self"]],["option"]]],[11,"next_reject","","",111,[[["self"]],["option"]]],[11,"haystack","","",112,[[["self"]],["str"]]],[11,"next","","",112,[[["self"]],["searchstep"]]],[11,"next_match","","",112,[[["self"]],["option"]]],[11,"haystack","","",110,[[["self"]],["str"]]],[11,"next","","",110,[[["self"]],["searchstep"]]],[11,"next_match","","",110,[[["self"]],["option"]]],[11,"next_reject","","",110,[[["self"]],["option"]]],[11,"haystack","","",109,[[["self"]],["str"]]],[11,"next","","",109,[[["self"]],["searchstep"]]],[11,"next_match","","",109,[[["self"]],["option"]]],[11,"clone","alloc::str","",89,[[["self"]],["rsplit"]]],[11,"clone","alloc::str::pattern","",109,[[["self"]],["strsearcher"]]],[11,"clone","alloc::str","",73,[[["self"]],["splitwhitespace"]]],[11,"clone","","",107,[[["self"]],["utf8error"]]],[11,"clone","alloc::fmt","",101,[[["self"]],["error"]]],[11,"clone","alloc::slice","",80,[[["self"]],["rsplit"]]],[11,"clone","alloc::str","",74,[[["self"]],["rsplitn"]]],[11,"clone","","",92,[[["self"]],["split"]]],[11,"clone","","",82,[[["self"]],["charindices"]]],[11,"clone","alloc::str::pattern","",111,[[["self"]],["charslicesearcher"]]],[11,"clone","alloc::task","",113,[[["self"]],["localwaker"]]],[11,"clone","alloc::slice","",86,[[["self"]],["chunks"]]],[11,"clone","alloc::str","",78,[[["self"]],["chars"]]],[11,"clone","","",83,[[["self"]],["rmatchindices"]]],[11,"clone","alloc::alloc","",104,[[["self"]],["allocerr"]]],[11,"clone","alloc::fmt","",114,[[["self"]],["arguments"]]],[11,"clone","alloc::str","",76,[[["self"]],["lines"]]],[11,"clone","alloc::str::pattern","",54,[[["self"]],["searchstep"]]],[11,"clone","alloc::task","",7,[[["self"]],["poll"]]],[11,"clone","alloc::alloc","",106,[[["self"]],["layouterr"]]],[11,"clone","alloc::str","",96,[[["self"]],["bytes"]]],[11,"clone","alloc::slice","",71,[[["self"]],["exactchunks"]]],[11,"clone","alloc::str","",87,[[["self"]],["matchindices"]]],[11,"clone","","",102,[[["self"]],["parseboolerror"]]],[11,"clone","alloc::task","",9,[[["self"]],["waker"]]],[11,"clone","alloc::str::pattern","",112,[[["self"]],["charsearcher"]]],[11,"clone","alloc::str","",94,[[["self"]],["rmatches"]]],[11,"clone","alloc::slice","",68,[[["self"]],["split"]]],[11,"clone","","",85,[[["self"]],["iter"]]],[11,"clone","alloc::str::pattern","",110,[[["self"]],["charpredicatesearcher"]]],[11,"clone","alloc::alloc","",105,[[["self"]],["layout"]]],[11,"clone","alloc::str","",99,[[["self"]],["rsplitterminator"]]],[11,"clone","","",95,[[["self"]],["splitn"]]],[11,"clone","","",90,[[["self"]],["splitterminator"]]],[11,"clone","","",69,[[["self"]],["splitasciiwhitespace"]]],[11,"clone","alloc::alloc","",103,[[["self"]],["cannotreallocinplace"]]],[11,"clone","alloc::slice","",79,[[["self"]],["windows"]]],[11,"clone","alloc::str","",70,[[["self"]],["encodeutf16"]]],[11,"clone","","",75,[[["self"]],["matches"]]],[11,"clone","","",100,[[["self"]],["linesany"]]],[11,"fmt","alloc::task","",115,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::str","",74,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::slice","",98,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","","",93,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::alloc","",106,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::task","",113,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::str::pattern","",111,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::slice","",79,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","","",68,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::task","",116,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::slice","",88,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","","",80,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::str","",100,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::task","",9,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","","",8,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::str","",95,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","","",96,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::str::pattern","",54,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::fmt","",114,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::str::pattern","",109,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::slice","",77,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","","",97,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::str","",69,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::alloc","",0,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::str","",75,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","","",90,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::slice","",91,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","","",72,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::str","",99,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::slice","",86,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","","",85,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::fmt","",101,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::slice","",71,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::task","",7,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::str","",92,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","","",82,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","","",87,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::fmt","",49,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::alloc","",103,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::str","",78,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","","",94,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","","",89,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::task","",4,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::str","",73,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::str::pattern","",112,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::slice","",84,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::str","",83,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::slice","",81,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::alloc","",105,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::str","",70,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","","",107,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::str::pattern","",110,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::str","",102,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","","",76,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::alloc","",104,[[["self"],["formatter"]],["result",["error"]]]],[11,"from","alloc::task","",7,[[["t"]],["poll"]]],[11,"from","","",9,[[["localwaker"]],["waker"]]],[11,"from_size_align","alloc::alloc","Constructs a `Layout` from a given `size` and `align`, or returns `LayoutErr` if either of the following conditions are not met:",105,[[["usize"],["usize"]],["result",["layout","layouterr"]]]],[11,"from_size_align_unchecked","","Creates a layout, bypassing all checks.",105,[[["usize"],["usize"]],["layout"]]],[11,"size","","The minimum size in bytes for a memory block of this layout.",105,[[["self"]],["usize"]]],[11,"align","","The minimum byte alignment for a memory block of this layout.",105,[[["self"]],["usize"]]],[11,"new","","Constructs a `Layout` suitable for holding a value of type `T`.",105,[[],["layout"]]],[11,"for_value","","Produces layout describing a record that could be used to allocate backing structure for `T` (which could be a trait or other unsized type like a slice).",105,[[["t"]],["layout"]]],[11,"align_to","","Creates a layout describing the record that can hold a value of the same layout as `self`, but that also is aligned to alignment `align` (measured in bytes).",105,[[["self"],["usize"]],["layout"]]],[11,"padding_needed_for","","Returns the amount of padding we must insert after `self` to ensure that the following address will satisfy `align` (measured in bytes).",105,[[["self"],["usize"]],["usize"]]],[11,"repeat","","Creates a layout describing the record for `n` instances of `self`, with a suitable amount of padding between each to ensure that each instance is given its requested size and alignment. On success, returns `(k, offs)` where `k` is the layout of the array and `offs` is the distance between the start of each element in the array.",105,[[["self"],["usize"]],["result",["layouterr"]]]],[11,"extend","","Creates a layout describing the record for `self` followed by `next`, including any necessary padding to ensure that `next` will be properly aligned. Note that the result layout will satisfy the alignment properties of both `self` and `next`.",105,[[["self"],["layout"]],["result",["layouterr"]]]],[11,"repeat_packed","","Creates a layout describing the record for `n` instances of `self`, with no padding between each instance.",105,[[["self"],["usize"]],["result",["layout","layouterr"]]]],[11,"extend_packed","","Creates a layout describing the record for `self` followed by `next` with no additional padding between the two. Since no padding is inserted, the alignment of `next` is irrelevant, and is not incorporated at all into the resulting layout.",105,[[["self"],["layout"]],["result",["layouterr"]]]],[11,"array","","Creates a layout describing the record for a `[T; n]`.",105,[[["usize"]],["result",["layout","layouterr"]]]],[11,"description","","",103,[[["self"]],["str"]]],[11,"shutdown","alloc::task","Spawning is failing because the executor has been shut down.",115,[[],["spawnerrorkind"]]],[11,"is_shutdown","","Check whether this error is the `shutdown` error.",115,[[["self"]],["bool"]]],[11,"new","","Constructs a new `Waker` directly.",9,[[["nonnull",["unsafewake"]]],["waker"]]],[11,"wake","","Wake up the task associated with this `Waker`.",9,N],[11,"will_wake","","Returns whether or not this `Waker` and `other` awaken the same task.",9,[[["self"],["waker"]],["bool"]]],[11,"new","","Constructs a new `LocalWaker` directly.",113,[[["nonnull",["unsafewake"]]],["localwaker"]]],[11,"wake","","Wake up the task associated with this `LocalWaker`.",113,N],[11,"will_wake","","Returns whether or not this `LocalWaker` and `other` `LocalWaker` awaken the same task.",113,[[["self"],["localwaker"]],["bool"]]],[11,"will_wake_nonlocal","","Returns whether or not this `LocalWaker` and `other` `Waker` awaken the same task.",113,[[["self"],["waker"]],["bool"]]],[11,"map","","Change the ready value of this `Poll` with the closure provided",7,[[["self"],["f"]],["poll"]]],[11,"is_ready","","Returns whether this is `Poll::Ready`",7,[[["self"]],["bool"]]],[11,"is_pending","","Returns whether this is `Poll::Pending`",7,[[["self"]],["bool"]]],[11,"map_ok","","Change the success value of this `Poll` with the closure provided",7,[[["self"],["f"]],["poll",["result"]]]],[11,"map_err","","Change the error value of this `Poll` with the closure provided",7,[[["self"],["f"]],["poll",["result"]]]],[11,"new","","Create a new task `Context` with the provided `local_waker`, `waker`, and `executor`.",116,[[["localwaker"],["executor"]],["context"]]],[11,"local_waker","","Get the `LocalWaker` associated with the current task.",116,[[["self"]],["localwaker"]]],[11,"waker","","Get the `Waker` associated with the current task.",116,[[["self"]],["waker"]]],[11,"executor","","Get the default executor associated with this task.",116,[[["self"]],["executor"]]],[11,"with_waker","","Produce a context like the current one, but using the given waker instead.",116,[[["self"],["localwaker"]],["context"]]],[11,"with_executor","","Produce a context like the current one, but using the given executor instead.",116,[[["self"],["e"]],["context"]]],[11,"wake_local","","Indicates that the associated task is ready to make progress and should be `poll`ed. This function is like `wake`, but can only be called from the thread on which this `Wake` was created.",10,[[["arc"]]]],[11,"from","alloc::vec","",63,[[["binaryheap"]],["vec"]]],[11,"drop","alloc::collections::btree_map","",117,[[["self"]]]],[11,"clone","","",117,[[["self"]],["btreemap"]]],[11,"fmt","","",118,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",119,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",120,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",121,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",122,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",123,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",124,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",125,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",30,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",126,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",127,[[["self"],["formatter"]],["result"]]],[11,"new","","Makes a new empty BTreeMap with a reasonable choice for B.",117,[[],["btreemap"]]],[11,"clear","","Clears the map, removing all values.",117,[[["self"]]]],[11,"get","","Returns a reference to the value corresponding to the key.",117,[[["self"],["q"]],["option"]]],[11,"get_key_value","","Returns the key-value pair corresponding to the supplied key.",117,[[["self"],["q"]],["option"]]],[11,"contains_key","","Returns `true` if the map contains a value for the specified key.",117,[[["self"],["q"]],["bool"]]],[11,"get_mut","","Returns a mutable reference to the value corresponding to the key.",117,[[["self"],["q"]],["option"]]],[11,"insert","","Inserts a key-value pair into the map.",117,[[["self"],["k"],["v"]],["option"]]],[11,"remove","","Removes a key from the map, returning the value at the key if the key was previously in the map.",117,[[["self"],["q"]],["option"]]],[11,"append","","Moves all elements from `other` into `Self`, leaving `other` empty.",117,[[["self"],["self"]]]],[11,"range","","Constructs a double-ended iterator over a sub-range of elements in the map. The simplest way is to use the range syntax `min..max`, thus `range(min..max)` will yield elements from min (inclusive) to max (exclusive). The range may also be entered as `(Bound<T>, Bound<T>)`, so for example `range((Excluded(4), Included(10)))` will yield a left-exclusive, right-inclusive range from 4 to 10.",117,[[["self"],["r"]],["range"]]],[11,"range_mut","","Constructs a mutable double-ended iterator over a sub-range of elements in the map. The simplest way is to use the range syntax `min..max`, thus `range(min..max)` will yield elements from min (inclusive) to max (exclusive). The range may also be entered as `(Bound<T>, Bound<T>)`, so for example `range((Excluded(4), Included(10)))` will yield a left-exclusive, right-inclusive range from 4 to 10.",117,[[["self"],["r"]],["rangemut"]]],[11,"entry","","Gets the given key's corresponding entry in the map for in-place manipulation.",117,[[["self"],["k"]],["entry"]]],[11,"split_off","","Splits the collection into two at the given key. Returns everything after the given key, including the key.",117,[[["self"],["q"]],["self"]]],[11,"next","","",118,[[["self"]],["option"]]],[11,"size_hint","","",118,N],[11,"next_back","","",118,[[["self"]],["option"]]],[11,"len","","",118,[[["self"]],["usize"]]],[11,"clone","","",118,[[["self"]],["iter"]]],[11,"next","","",119,[[["self"]],["option"]]],[11,"size_hint","","",119,N],[11,"next_back","","",119,[[["self"]],["option"]]],[11,"len","","",119,[[["self"]],["usize"]]],[11,"into_iter","","",117,[[["self"]],["intoiter"]]],[11,"drop","","",120,[[["self"]]]],[11,"next","","",120,[[["self"]],["option"]]],[11,"size_hint","","",120,N],[11,"next_back","","",120,[[["self"]],["option"]]],[11,"len","","",120,[[["self"]],["usize"]]],[11,"next","","",121,[[["self"]],["option"]]],[11,"size_hint","","",121,N],[11,"next_back","","",121,[[["self"]],["option"]]],[11,"len","","",121,[[["self"]],["usize"]]],[11,"clone","","",121,[[["self"]],["keys"]]],[11,"next","","",122,[[["self"]],["option"]]],[11,"size_hint","","",122,N],[11,"next_back","","",122,[[["self"]],["option"]]],[11,"len","","",122,[[["self"]],["usize"]]],[11,"clone","","",122,[[["self"]],["values"]]],[11,"next","","",124,[[["self"]],["option"]]],[11,"next","","",123,[[["self"]],["option"]]],[11,"size_hint","","",123,N],[11,"next_back","","",123,[[["self"]],["option"]]],[11,"len","","",123,[[["self"]],["usize"]]],[11,"next_back","","",124,[[["self"]],["option"]]],[11,"clone","","",124,[[["self"]],["range"]]],[11,"next","","",125,[[["self"]],["option"]]],[11,"next_back","","",125,[[["self"]],["option"]]],[11,"from_iter","","",117,[[["t"]],["btreemap"]]],[11,"extend","","",117,[[["self"],["t"]]]],[11,"extend","","",117,[[["self"],["i"]]]],[11,"hash","","",117,[[["self"],["h"]]]],[11,"default","","Creates an empty `BTreeMap<K, V>`.",117,[[],["btreemap"]]],[11,"eq","","",117,[[["self"],["btreemap"]],["bool"]]],[11,"partial_cmp","","",117,[[["self"],["btreemap"]],["option",["ordering"]]]],[11,"cmp","","",117,[[["self"],["btreemap"]],["ordering"]]],[11,"fmt","","",117,[[["self"],["formatter"]],["result"]]],[11,"index","","Returns a reference to the value corresponding to the supplied key.",117,[[["self"],["q"]],["v"]]],[11,"iter","","Gets an iterator over the entries of the map, sorted by key.",117,[[["self"]],["iter"]]],[11,"iter_mut","","Gets a mutable iterator over the entries of the map, sorted by key.",117,[[["self"]],["itermut"]]],[11,"keys","","Gets an iterator over the keys of the map, in sorted order.",117,[[["self"]],["keys"]]],[11,"values","","Gets an iterator over the values of the map, in order by key.",117,[[["self"]],["values"]]],[11,"values_mut","","Gets a mutable iterator over the values of the map, in order by key.",117,[[["self"]],["valuesmut"]]],[11,"len","","Returns the number of elements in the map.",117,[[["self"]],["usize"]]],[11,"is_empty","","Returns `true` if the map contains no elements.",117,[[["self"]],["bool"]]],[11,"or_insert","","Ensures a value is in the entry by inserting the default if empty, and returns a mutable reference to the value in the entry.",30,[[["self"],["v"]],["v"]]],[11,"or_insert_with","","Ensures a value is in the entry by inserting the result of the default function if empty, and returns a mutable reference to the value in the entry.",30,[[["self"],["f"]],["v"]]],[11,"key","","Returns a reference to this entry's key.",30,[[["self"]],["k"]]],[11,"and_modify","","Provides in-place mutable access to an occupied entry before any potential inserts into the map.",30,[[["self"],["f"]],["self"]]],[11,"or_default","","Ensures a value is in the entry by inserting the default value if empty, and returns a mutable reference to the value in the entry.",30,[[["self"]],["v"]]],[11,"key","","Gets a reference to the key that would be used when inserting a value through the VacantEntry.",126,[[["self"]],["k"]]],[11,"into_key","","Take ownership of the key.",126,[[["self"]],["k"]]],[11,"insert","","Sets the value of the entry with the `VacantEntry`'s key, and returns a mutable reference to it.",126,[[["self"],["v"]],["v"]]],[11,"key","","Gets a reference to the key in the entry.",127,[[["self"]],["k"]]],[11,"remove_entry","","Take ownership of the key and value from the map.",127,N],[11,"get","","Gets a reference to the value in the entry.",127,[[["self"]],["v"]]],[11,"get_mut","","Gets a mutable reference to the value in the entry.",127,[[["self"]],["v"]]],[11,"into_mut","","Converts the entry into a mutable reference to its value.",127,[[["self"]],["v"]]],[11,"insert","","Sets the value of the entry with the `OccupiedEntry`'s key, and returns the entry's old value.",127,[[["self"],["v"]],["v"]]],[11,"remove","","Takes the value of the entry out of the map, and returns it.",127,[[["self"]],["v"]]],[11,"clone","alloc::collections::btree_set","",128,[[["self"]],["btreeset"]]],[11,"hash","","",128,N],[11,"eq","","",128,[[["self"],["btreeset"]],["bool"]]],[11,"ne","","",128,[[["self"],["btreeset"]],["bool"]]],[11,"cmp","","",128,[[["self"],["btreeset"]],["ordering"]]],[11,"partial_cmp","","",128,[[["self"],["btreeset"]],["option",["ordering"]]]],[11,"lt","","",128,[[["self"],["btreeset"]],["bool"]]],[11,"le","","",128,[[["self"],["btreeset"]],["bool"]]],[11,"gt","","",128,[[["self"],["btreeset"]],["bool"]]],[11,"ge","","",128,[[["self"],["btreeset"]],["bool"]]],[11,"fmt","","",129,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",130,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",131,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",132,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",133,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",134,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",135,[[["self"],["formatter"]],["result"]]],[11,"new","","Makes a new `BTreeSet` with a reasonable choice of B.",128,[[],["btreeset"]]],[11,"range","","Constructs a double-ended iterator over a sub-range of elements in the set. The simplest way is to use the range syntax `min..max`, thus `range(min..max)` will yield elements from min (inclusive) to max (exclusive). The range may also be entered as `(Bound<T>, Bound<T>)`, so for example `range((Excluded(4), Included(10)))` will yield a left-exclusive, right-inclusive range from 4 to 10.",128,[[["self"],["r"]],["range"]]],[11,"difference","","Visits the values representing the difference, i.e. the values that are in `self` but not in `other`, in ascending order.",128,[[["self"],["btreeset"]],["difference"]]],[11,"symmetric_difference","","Visits the values representing the symmetric difference, i.e. the values that are in `self` or in `other` but not in both, in ascending order.",128,[[["self"],["btreeset"]],["symmetricdifference"]]],[11,"intersection","","Visits the values representing the intersection, i.e. the values that are both in `self` and `other`, in ascending order.",128,[[["self"],["btreeset"]],["intersection"]]],[11,"union","","Visits the values representing the union, i.e. all the values in `self` or `other`, without duplicates, in ascending order.",128,[[["self"],["btreeset"]],["union"]]],[11,"clear","","Clears the set, removing all values.",128,[[["self"]]]],[11,"contains","","Returns `true` if the set contains a value.",128,[[["self"],["q"]],["bool"]]],[11,"get","","Returns a reference to the value in the set, if any, that is equal to the given value.",128,[[["self"],["q"]],["option"]]],[11,"is_disjoint","","Returns `true` if `self` has no elements in common with `other`. This is equivalent to checking for an empty intersection.",128,[[["self"],["btreeset"]],["bool"]]],[11,"is_subset","","Returns `true` if the set is a subset of another, i.e. `other` contains at least all the values in `self`.",128,[[["self"],["btreeset"]],["bool"]]],[11,"is_superset","","Returns `true` if the set is a superset of another, i.e. `self` contains at least all the values in `other`.",128,[[["self"],["btreeset"]],["bool"]]],[11,"insert","","Adds a value to the set.",128,[[["self"],["t"]],["bool"]]],[11,"replace","","Adds a value to the set, replacing the existing value, if any, that is equal to the given one. Returns the replaced value.",128,[[["self"],["t"]],["option"]]],[11,"remove","","Removes a value from the set. Returns `true` if the value was present in the set.",128,[[["self"],["q"]],["bool"]]],[11,"take","","Removes and returns the value in the set, if any, that is equal to the given one.",128,[[["self"],["q"]],["option"]]],[11,"append","","Moves all elements from `other` into `Self`, leaving `other` empty.",128,[[["self"],["self"]]]],[11,"split_off","","Splits the collection into two at the given key. Returns everything after the given key, including the key.",128,[[["self"],["q"]],["self"]]],[11,"iter","","Gets an iterator that visits the values in the `BTreeSet` in ascending order.",128,[[["self"]],["iter"]]],[11,"len","","Returns the number of elements in the set.",128,[[["self"]],["usize"]]],[11,"is_empty","","Returns `true` if the set contains no elements.",128,[[["self"]],["bool"]]],[11,"from_iter","","",128,[[["i"]],["btreeset"]]],[11,"into_iter","","Gets an iterator for moving out the `BTreeSet`'s contents.",128,[[["self"]],["intoiter"]]],[11,"extend","","",128,[[["self"],["iter"]]]],[11,"extend","","",128,[[["self"],["i"]]]],[11,"default","","Makes an empty `BTreeSet<T>` with a reasonable choice of B.",128,[[],["btreeset"]]],[11,"fmt","","",128,[[["self"],["formatter"]],["result"]]],[11,"clone","","",129,[[["self"]],["iter"]]],[11,"next","","",129,[[["self"]],["option"]]],[11,"size_hint","","",129,N],[11,"next_back","","",129,[[["self"]],["option"]]],[11,"len","","",129,[[["self"]],["usize"]]],[11,"next","","",130,[[["self"]],["option"]]],[11,"size_hint","","",130,N],[11,"next_back","","",130,[[["self"]],["option"]]],[11,"len","","",130,[[["self"]],["usize"]]],[11,"clone","","",131,[[["self"]],["range"]]],[11,"next","","",131,[[["self"]],["option"]]],[11,"next_back","","",131,[[["self"]],["option"]]],[11,"clone","","",132,[[["self"]],["difference"]]],[11,"next","","",132,[[["self"]],["option"]]],[11,"size_hint","","",132,N],[11,"clone","","",133,[[["self"]],["symmetricdifference"]]],[11,"next","","",133,[[["self"]],["option"]]],[11,"size_hint","","",133,N],[11,"clone","","",134,[[["self"]],["intersection"]]],[11,"next","","",134,[[["self"]],["option"]]],[11,"size_hint","","",134,N],[11,"clone","","",135,[[["self"]],["union"]]],[11,"next","","",135,[[["self"]],["option"]]],[11,"size_hint","","",135,N],[11,"from","alloc::vec","",63,[[["vecdeque"]],["self"]]],[11,"pad_integral","alloc::fmt","Performs the correct padding for an integer which has already been emitted into a str. The str should not contain the sign for the integer, that will be added by this method.",108,[[["self"],["bool"],["str"],["str"]],["result",["error"]]]],[11,"pad","","This function takes a string slice and emits it to the internal buffer after applying the relevant formatting flags specified. The flags recognized for generic strings are:",108,[[["self"],["str"]],["result",["error"]]]],[11,"write_str","","Writes some data to the underlying buffer contained within this formatter.",108,[[["self"],["str"]],["result",["error"]]]],[11,"write_fmt","","Writes some formatted information into this instance.",108,[[["self"],["arguments"]],["result",["error"]]]],[11,"flags","","Flags for formatting",108,[[["self"]],["u32"]]],[11,"fill","","Character used as 'fill' whenever there is alignment.",108,[[["self"]],["char"]]],[11,"align","","Flag indicating what form of alignment was requested.",108,[[["self"]],["option",["alignment"]]]],[11,"width","","Optionally specified integer width that the output should be.",108,[[["self"]],["option",["usize"]]]],[11,"precision","","Optionally specified precision for numeric types.",108,[[["self"]],["option",["usize"]]]],[11,"sign_plus","","Determines if the `+` flag was specified.",108,[[["self"]],["bool"]]],[11,"sign_minus","","Determines if the `-` flag was specified.",108,[[["self"]],["bool"]]],[11,"alternate","","Determines if the `#` flag was specified.",108,[[["self"]],["bool"]]],[11,"sign_aware_zero_pad","","Determines if the `0` flag was specified.",108,[[["self"]],["bool"]]],[11,"debug_struct","","Creates a [`DebugStruct`] builder designed to assist with creation of [`fmt::Debug`] implementations for structs.",108,[[["self"],["str"]],["debugstruct"]]],[11,"debug_tuple","","Creates a `DebugTuple` builder designed to assist with creation of `fmt::Debug` implementations for tuple structs.",108,[[["self"],["str"]],["debugtuple"]]],[11,"debug_list","","Creates a `DebugList` builder designed to assist with creation of `fmt::Debug` implementations for list-like structures.",108,[[["self"]],["debuglist"]]],[11,"debug_set","","Creates a `DebugSet` builder designed to assist with creation of `fmt::Debug` implementations for set-like structures.",108,[[["self"]],["debugset"]]],[11,"debug_map","","Creates a `DebugMap` builder designed to assist with creation of `fmt::Debug` implementations for map-like structures.",108,[[["self"]],["debugmap"]]],[11,"entry","","Adds a new entry to the list output.",136,[[["self"],["debug"]],["debuglist"]]],[11,"entries","","Adds the contents of an iterator of entries to the list output.",136,[[["self"],["i"]],["debuglist"]]],[11,"finish","","Finishes output and returns any error encountered.",136,[[["self"]],["result",["error"]]]],[11,"entry","","Adds a new entry to the map output.",137,[[["self"],["debug"],["debug"]],["debugmap"]]],[11,"entries","","Adds the contents of an iterator of entries to the map output.",137,[[["self"],["i"]],["debugmap"]]],[11,"finish","","Finishes output and returns any error encountered.",137,[[["self"]],["result",["error"]]]],[11,"entry","","Adds a new entry to the set output.",138,[[["self"],["debug"]],["debugset"]]],[11,"entries","","Adds the contents of an iterator of entries to the set output.",138,[[["self"],["i"]],["debugset"]]],[11,"finish","","Finishes output and returns any error encountered.",138,[[["self"]],["result",["error"]]]],[11,"field","","Adds a new field to the generated struct output.",139,[[["self"],["str"],["debug"]],["debugstruct"]]],[11,"finish","","Finishes output and returns any error encountered.",139,[[["self"]],["result",["error"]]]],[11,"field","","Adds a new field to the generated tuple struct output.",140,[[["self"],["debug"]],["debugtuple"]]],[11,"finish","","Finishes output and returns any error encountered.",140,[[["self"]],["result",["error"]]]],[11,"as_slice","alloc::slice","View the underlying data as a subslice of the original data.",85,N],[11,"into_slice","","View the underlying data as a subslice of the original data.",93,N],[11,"remainder","","Return the remainder of the original slice that is not going to be returned by the iterator. The returned slice has at most `chunk_size-1` elements.",71,N],[11,"into_remainder","","Return the remainder of the original slice that is not going to be returned by the iterator. The returned slice has at most `chunk_size-1` elements.",98,N],[11,"borrow","alloc::vec","",63,N],[11,"borrow_mut","","",63,N],[11,"valid_up_to","alloc::str","Returns the index in the given string up to which valid UTF-8 was verified.",107,[[["self"]],["usize"]]],[11,"error_len","","Provide more information about the failure:",107,[[["self"]],["option",["usize"]]]],[11,"as_str","","View the underlying data as a subslice of the original data.",78,[[["self"]],["str"]]],[11,"as_str","","View the underlying data as a subslice of the original data.",82,[[["self"]],["str"]]],[11,"borrow","alloc::string","",58,[[["self"]],["str"]]],[11,"from","alloc::vec","",63,[[["string"]],["vec",["u8"]]]]],"paths":[[3,"Excess"],[8,"GlobalAlloc"],[8,"Alloc"],[3,"Global"],[3,"SpawnLocalObjError"],[8,"Executor"],[8,"UnsafeWake"],[4,"Poll"],[3,"SpawnObjError"],[3,"Waker"],[8,"Wake"],[8,"FnBox"],[3,"Box"],[3,"PinBox"],[4,"CollectionAllocErr"],[3,"PeekMut"],[3,"BinaryHeap"],[3,"Iter"],[3,"IntoIter"],[3,"Drain"],[3,"Iter"],[3,"IterMut"],[3,"IntoIter"],[3,"LinkedList"],[3,"DrainFilter"],[3,"VecDeque"],[3,"Iter"],[3,"IterMut"],[3,"IntoIter"],[3,"Drain"],[4,"Entry"],[3,"Weak"],[3,"Arc"],[3,"Rc"],[3,"Weak"],[8,"Borrow"],[8,"BorrowMut"],[4,"Cow"],[8,"ToOwned"],[8,"Write"],[8,"Binary"],[8,"Octal"],[8,"Debug"],[8,"Display"],[8,"LowerHex"],[8,"Pointer"],[8,"UpperHex"],[8,"LowerExp"],[8,"UpperExp"],[4,"Alignment"],[8,"SliceIndex"],[8,"SliceConcatExt"],[8,"FromStr"],[8,"Pattern"],[4,"SearchStep"],[8,"Searcher"],[8,"ReverseSearcher"],[8,"ToString"],[3,"String"],[3,"FromUtf8Error"],[3,"FromUtf16Error"],[4,"ParseError"],[3,"Drain"],[3,"Vec"],[3,"IntoIter"],[3,"Drain"],[3,"Splice"],[3,"DrainFilter"],[3,"Split"],[3,"SplitAsciiWhitespace"],[3,"EncodeUtf16"],[3,"ExactChunks"],[3,"RSplitMut"],[3,"SplitWhitespace"],[3,"RSplitN"],[3,"Matches"],[3,"Lines"],[3,"ChunksMut"],[3,"Chars"],[3,"Windows"],[3,"RSplit"],[3,"SplitMut"],[3,"CharIndices"],[3,"RMatchIndices"],[3,"RSplitN"],[3,"Iter"],[3,"Chunks"],[3,"MatchIndices"],[3,"SplitNMut"],[3,"RSplit"],[3,"SplitTerminator"],[3,"SplitN"],[3,"Split"],[3,"IterMut"],[3,"RMatches"],[3,"SplitN"],[3,"Bytes"],[3,"RSplitNMut"],[3,"ExactChunksMut"],[3,"RSplitTerminator"],[3,"LinesAny"],[3,"Error"],[3,"ParseBoolError"],[3,"CannotReallocInPlace"],[3,"AllocErr"],[3,"Layout"],[3,"LayoutErr"],[3,"Utf8Error"],[3,"Formatter"],[3,"StrSearcher"],[3,"CharPredicateSearcher"],[3,"CharSliceSearcher"],[3,"CharSearcher"],[3,"LocalWaker"],[3,"Arguments"],[3,"SpawnErrorKind"],[3,"Context"],[3,"BTreeMap"],[3,"Iter"],[3,"IterMut"],[3,"IntoIter"],[3,"Keys"],[3,"Values"],[3,"ValuesMut"],[3,"Range"],[3,"RangeMut"],[3,"VacantEntry"],[3,"OccupiedEntry"],[3,"BTreeSet"],[3,"Iter"],[3,"IntoIter"],[3,"Range"],[3,"Difference"],[3,"SymmetricDifference"],[3,"Intersection"],[3,"Union"],[3,"DebugList"],[3,"DebugMap"],[3,"DebugSet"],[3,"DebugStruct"],[3,"DebugTuple"]]};
searchIndex["core"]={"doc":"The Rust Core Library","items":[[0,"isize","core","The pointer-sized signed integer type.",N,N],[17,"MIN","core::isize","The smallest value that can be represented by this integer type.",N,N],[17,"MAX","","The largest value that can be represented by this integer type.",N,N],[0,"i8","core","The 8-bit signed integer type.",N,N],[17,"MIN","core::i8","The smallest value that can be represented by this integer type.",N,N],[17,"MAX","","The largest value that can be represented by this integer type.",N,N],[0,"i16","core","The 16-bit signed integer type.",N,N],[17,"MIN","core::i16","The smallest value that can be represented by this integer type.",N,N],[17,"MAX","","The largest value that can be represented by this integer type.",N,N],[0,"i32","core","The 32-bit signed integer type.",N,N],[17,"MIN","core::i32","The smallest value that can be represented by this integer type.",N,N],[17,"MAX","","The largest value that can be represented by this integer type.",N,N],[0,"i64","core","The 64-bit signed integer type.",N,N],[17,"MIN","core::i64","The smallest value that can be represented by this integer type.",N,N],[17,"MAX","","The largest value that can be represented by this integer type.",N,N],[0,"i128","core","The 128-bit signed integer type.",N,N],[17,"MIN","core::i128","The smallest value that can be represented by this integer type.",N,N],[17,"MAX","","The largest value that can be represented by this integer type.",N,N],[0,"usize","core","The pointer-sized unsigned integer type.",N,N],[17,"MIN","core::usize","The smallest value that can be represented by this integer type.",N,N],[17,"MAX","","The largest value that can be represented by this integer type.",N,N],[0,"u8","core","The 8-bit unsigned integer type.",N,N],[17,"MIN","core::u8","The smallest value that can be represented by this integer type.",N,N],[17,"MAX","","The largest value that can be represented by this integer type.",N,N],[0,"u16","core","The 16-bit unsigned integer type.",N,N],[17,"MIN","core::u16","The smallest value that can be represented by this integer type.",N,N],[17,"MAX","","The largest value that can be represented by this integer type.",N,N],[0,"u32","core","The 32-bit unsigned integer type.",N,N],[17,"MIN","core::u32","The smallest value that can be represented by this integer type.",N,N],[17,"MAX","","The largest value that can be represented by this integer type.",N,N],[0,"u64","core","The 64-bit unsigned integer type.",N,N],[17,"MIN","core::u64","The smallest value that can be represented by this integer type.",N,N],[17,"MAX","","The largest value that can be represented by this integer type.",N,N],[0,"u128","core","The 128-bit unsigned integer type.",N,N],[17,"MIN","core::u128","The smallest value that can be represented by this integer type.",N,N],[17,"MAX","","The largest value that can be represented by this integer type.",N,N],[0,"f32","core","This module provides constants which are specific to the implementation of the `f32` floating point data type.",N,N],[0,"consts","core::f32","Basic mathematical constants.",N,N],[17,"PI","core::f32::consts","Archimedes' constant (π)",N,N],[17,"FRAC_PI_2","","π/2",N,N],[17,"FRAC_PI_3","","π/3",N,N],[17,"FRAC_PI_4","","π/4",N,N],[17,"FRAC_PI_6","","π/6",N,N],[17,"FRAC_PI_8","","π/8",N,N],[17,"FRAC_1_PI","","1/π",N,N],[17,"FRAC_2_PI","","2/π",N,N],[17,"FRAC_2_SQRT_PI","","2/sqrt(π)",N,N],[17,"SQRT_2","","sqrt(2)",N,N],[17,"FRAC_1_SQRT_2","","1/sqrt(2)",N,N],[17,"E","","Euler's number (e)",N,N],[17,"LOG2_E","","log2(e)",N,N],[17,"LOG2_10","","log2(10)",N,N],[17,"LOG10_E","","log10(e)",N,N],[17,"LOG10_2","","log10(2)",N,N],[17,"LN_2","","ln(2)",N,N],[17,"LN_10","","ln(10)",N,N],[17,"RADIX","core::f32","The radix or base of the internal representation of `f32`.",N,N],[17,"MANTISSA_DIGITS","","Number of significant digits in base 2.",N,N],[17,"DIGITS","","Approximate number of significant digits in base 10.",N,N],[17,"EPSILON","","[Machine epsilon] value for `f32`.",N,N],[17,"MIN","","Smallest finite `f32` value.",N,N],[17,"MIN_POSITIVE","","Smallest positive normal `f32` value.",N,N],[17,"MAX","","Largest finite `f32` value.",N,N],[17,"MIN_EXP","","One greater than the minimum possible normal power of 2 exponent.",N,N],[17,"MAX_EXP","","Maximum possible power of 2 exponent.",N,N],[17,"MIN_10_EXP","","Minimum possible normal power of 10 exponent.",N,N],[17,"MAX_10_EXP","","Maximum possible power of 10 exponent.",N,N],[17,"NAN","","Not a Number (NaN).",N,N],[17,"INFINITY","","Infinity (∞).",N,N],[17,"NEG_INFINITY","","Negative infinity (-∞).",N,N],[0,"f64","core","This module provides constants which are specific to the implementation of the `f64` floating point data type.",N,N],[0,"consts","core::f64","Basic mathematical constants.",N,N],[17,"PI","core::f64::consts","Archimedes' constant (π)",N,N],[17,"FRAC_PI_2","","π/2",N,N],[17,"FRAC_PI_3","","π/3",N,N],[17,"FRAC_PI_4","","π/4",N,N],[17,"FRAC_PI_6","","π/6",N,N],[17,"FRAC_PI_8","","π/8",N,N],[17,"FRAC_1_PI","","1/π",N,N],[17,"FRAC_2_PI","","2/π",N,N],[17,"FRAC_2_SQRT_PI","","2/sqrt(π)",N,N],[17,"SQRT_2","","sqrt(2)",N,N],[17,"FRAC_1_SQRT_2","","1/sqrt(2)",N,N],[17,"E","","Euler's number (e)",N,N],[17,"LOG2_10","","log2(10)",N,N],[17,"LOG2_E","","log2(e)",N,N],[17,"LOG10_2","","log10(2)",N,N],[17,"LOG10_E","","log10(e)",N,N],[17,"LN_2","","ln(2)",N,N],[17,"LN_10","","ln(10)",N,N],[17,"RADIX","core::f64","The radix or base of the internal representation of `f64`.",N,N],[17,"MANTISSA_DIGITS","","Number of significant digits in base 2.",N,N],[17,"DIGITS","","Approximate number of significant digits in base 10.",N,N],[17,"EPSILON","","[Machine epsilon] value for `f64`.",N,N],[17,"MIN","","Smallest finite `f64` value.",N,N],[17,"MIN_POSITIVE","","Smallest positive normal `f64` value.",N,N],[17,"MAX","","Largest finite `f64` value.",N,N],[17,"MIN_EXP","","One greater than the minimum possible normal power of 2 exponent.",N,N],[17,"MAX_EXP","","Maximum possible power of 2 exponent.",N,N],[17,"MIN_10_EXP","","Minimum possible normal power of 10 exponent.",N,N],[17,"MAX_10_EXP","","Maximum possible power of 10 exponent.",N,N],[17,"NAN","","Not a Number (NaN).",N,N],[17,"INFINITY","","Infinity (∞).",N,N],[17,"NEG_INFINITY","","Negative infinity (-∞).",N,N],[0,"num","core","Numeric traits and functions for the built-in numeric types.",N,N],[3,"NonZeroU8","core::num","An integer that is known not to equal zero.",N,N],[3,"NonZeroU16","","An integer that is known not to equal zero.",N,N],[3,"NonZeroU32","","An integer that is known not to equal zero.",N,N],[3,"NonZeroU64","","An integer that is known not to equal zero.",N,N],[3,"NonZeroU128","","An integer that is known not to equal zero.",N,N],[3,"NonZeroUsize","","An integer that is known not to equal zero.",N,N],[3,"Wrapping","","Provides intentionally-wrapped arithmetic on `T`.",N,N],[12,"0","","",0,N],[3,"TryFromIntError","","The error type returned when a checked integral type conversion fails.",N,N],[3,"ParseIntError","","An error which can be returned when parsing an integer.",N,N],[3,"ParseFloatError","","An error which can be returned when parsing a float.",N,N],[4,"FpCategory","","A classification of floating point numbers.",N,N],[13,"Nan","","\"Not a Number\", often obtained by dividing by zero.",1,N],[13,"Infinite","","Positive or negative infinity.",1,N],[13,"Zero","","Positive or negative zero.",1,N],[13,"Subnormal","","De-normalized floating point representation (less precise than `Normal`).",1,N],[13,"Normal","","A regular floating point number.",1,N],[11,"fmt","","",2,[[["self"],["formatter"]],["result"]]],[11,"clone","","",2,[[["self"]],["parsefloaterror"]]],[11,"eq","","",2,[[["self"],["parsefloaterror"]],["bool"]]],[11,"ne","","",2,[[["self"],["parsefloaterror"]],["bool"]]],[11,"fmt","","",2,[[["self"],["formatter"]],["result"]]],[11,"shl","","",0,[[["self"],["usize"]],["wrapping",["u8"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shr","","",0,[[["self"],["usize"]],["wrapping",["u8"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shl","","",0,[[["self"],["usize"]],["wrapping",["u16"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shr","","",0,[[["self"],["usize"]],["wrapping",["u16"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shl","","",0,[[["self"],["usize"]],["wrapping",["u32"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shr","","",0,[[["self"],["usize"]],["wrapping",["u32"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shl","","",0,[[["self"],["usize"]],["wrapping",["u64"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shr","","",0,[[["self"],["usize"]],["wrapping",["u64"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shl","","",0,[[["self"],["usize"]],["wrapping",["u128"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shr","","",0,[[["self"],["usize"]],["wrapping",["u128"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shl","","",0,[[["self"],["usize"]],["wrapping",["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shr","","",0,[[["self"],["usize"]],["wrapping",["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shl","","",0,[[["self"],["usize"]],["wrapping",["i8"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shr","","",0,[[["self"],["usize"]],["wrapping",["i8"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shl","","",0,[[["self"],["usize"]],["wrapping",["i16"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shr","","",0,[[["self"],["usize"]],["wrapping",["i16"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shl","","",0,[[["self"],["usize"]],["wrapping",["i32"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shr","","",0,[[["self"],["usize"]],["wrapping",["i32"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shl","","",0,[[["self"],["usize"]],["wrapping",["i64"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shr","","",0,[[["self"],["usize"]],["wrapping",["i64"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shl","","",0,[[["self"],["usize"]],["wrapping",["i128"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shr","","",0,[[["self"],["usize"]],["wrapping",["i128"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shl","","",0,[[["self"],["usize"]],["wrapping",["isize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shr","","",0,[[["self"],["usize"]],["wrapping",["isize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"add","","",0,[[["self"],["wrapping",["usize"]]],["wrapping",["usize"]]]],[11,"add","","",0,N],[11,"add_assign","","",0,[[["self"],["wrapping",["usize"]]]]],[11,"add_assign","","",0,[[["self"],["wrapping"]]]],[11,"sub","","",0,[[["self"],["wrapping",["usize"]]],["wrapping",["usize"]]]],[11,"sub","","",0,N],[11,"sub_assign","","",0,[[["self"],["wrapping",["usize"]]]]],[11,"sub_assign","","",0,[[["self"],["wrapping"]]]],[11,"mul","","",0,[[["self"],["wrapping",["usize"]]],["wrapping",["usize"]]]],[11,"mul","","",0,N],[11,"mul_assign","","",0,[[["self"],["wrapping",["usize"]]]]],[11,"mul_assign","","",0,[[["self"],["wrapping"]]]],[11,"div","","",0,[[["self"],["wrapping",["usize"]]],["wrapping",["usize"]]]],[11,"div","","",0,N],[11,"div_assign","","",0,[[["self"],["wrapping",["usize"]]]]],[11,"div_assign","","",0,[[["self"],["wrapping"]]]],[11,"rem","","",0,[[["self"],["wrapping",["usize"]]],["wrapping",["usize"]]]],[11,"rem","","",0,N],[11,"rem_assign","","",0,[[["self"],["wrapping",["usize"]]]]],[11,"rem_assign","","",0,[[["self"],["wrapping"]]]],[11,"not","","",0,[[["self"]],["wrapping",["usize"]]]],[11,"bitxor","","",0,[[["self"],["wrapping",["usize"]]],["wrapping",["usize"]]]],[11,"bitxor","","",0,N],[11,"bitxor_assign","","",0,[[["self"],["wrapping",["usize"]]]]],[11,"bitxor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitor","","",0,[[["self"],["wrapping",["usize"]]],["wrapping",["usize"]]]],[11,"bitor","","",0,N],[11,"bitor_assign","","",0,[[["self"],["wrapping",["usize"]]]]],[11,"bitor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitand","","",0,[[["self"],["wrapping",["usize"]]],["wrapping",["usize"]]]],[11,"bitand","","",0,N],[11,"bitand_assign","","",0,[[["self"],["wrapping",["usize"]]]]],[11,"bitand_assign","","",0,[[["self"],["wrapping"]]]],[11,"neg","","",0,[[["self"]],["self"]]],[11,"add","","",0,[[["self"],["wrapping",["u8"]]],["wrapping",["u8"]]]],[11,"add","","",0,N],[11,"add_assign","","",0,[[["self"],["wrapping",["u8"]]]]],[11,"add_assign","","",0,[[["self"],["wrapping"]]]],[11,"sub","","",0,[[["self"],["wrapping",["u8"]]],["wrapping",["u8"]]]],[11,"sub","","",0,N],[11,"sub_assign","","",0,[[["self"],["wrapping",["u8"]]]]],[11,"sub_assign","","",0,[[["self"],["wrapping"]]]],[11,"mul","","",0,[[["self"],["wrapping",["u8"]]],["wrapping",["u8"]]]],[11,"mul","","",0,N],[11,"mul_assign","","",0,[[["self"],["wrapping",["u8"]]]]],[11,"mul_assign","","",0,[[["self"],["wrapping"]]]],[11,"div","","",0,[[["self"],["wrapping",["u8"]]],["wrapping",["u8"]]]],[11,"div","","",0,N],[11,"div_assign","","",0,[[["self"],["wrapping",["u8"]]]]],[11,"div_assign","","",0,[[["self"],["wrapping"]]]],[11,"rem","","",0,[[["self"],["wrapping",["u8"]]],["wrapping",["u8"]]]],[11,"rem","","",0,N],[11,"rem_assign","","",0,[[["self"],["wrapping",["u8"]]]]],[11,"rem_assign","","",0,[[["self"],["wrapping"]]]],[11,"not","","",0,[[["self"]],["wrapping",["u8"]]]],[11,"bitxor","","",0,[[["self"],["wrapping",["u8"]]],["wrapping",["u8"]]]],[11,"bitxor","","",0,N],[11,"bitxor_assign","","",0,[[["self"],["wrapping",["u8"]]]]],[11,"bitxor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitor","","",0,[[["self"],["wrapping",["u8"]]],["wrapping",["u8"]]]],[11,"bitor","","",0,N],[11,"bitor_assign","","",0,[[["self"],["wrapping",["u8"]]]]],[11,"bitor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitand","","",0,[[["self"],["wrapping",["u8"]]],["wrapping",["u8"]]]],[11,"bitand","","",0,N],[11,"bitand_assign","","",0,[[["self"],["wrapping",["u8"]]]]],[11,"bitand_assign","","",0,[[["self"],["wrapping"]]]],[11,"neg","","",0,[[["self"]],["self"]]],[11,"add","","",0,[[["self"],["wrapping",["u16"]]],["wrapping",["u16"]]]],[11,"add","","",0,N],[11,"add_assign","","",0,[[["self"],["wrapping",["u16"]]]]],[11,"add_assign","","",0,[[["self"],["wrapping"]]]],[11,"sub","","",0,[[["self"],["wrapping",["u16"]]],["wrapping",["u16"]]]],[11,"sub","","",0,N],[11,"sub_assign","","",0,[[["self"],["wrapping",["u16"]]]]],[11,"sub_assign","","",0,[[["self"],["wrapping"]]]],[11,"mul","","",0,[[["self"],["wrapping",["u16"]]],["wrapping",["u16"]]]],[11,"mul","","",0,N],[11,"mul_assign","","",0,[[["self"],["wrapping",["u16"]]]]],[11,"mul_assign","","",0,[[["self"],["wrapping"]]]],[11,"div","","",0,[[["self"],["wrapping",["u16"]]],["wrapping",["u16"]]]],[11,"div","","",0,N],[11,"div_assign","","",0,[[["self"],["wrapping",["u16"]]]]],[11,"div_assign","","",0,[[["self"],["wrapping"]]]],[11,"rem","","",0,[[["self"],["wrapping",["u16"]]],["wrapping",["u16"]]]],[11,"rem","","",0,N],[11,"rem_assign","","",0,[[["self"],["wrapping",["u16"]]]]],[11,"rem_assign","","",0,[[["self"],["wrapping"]]]],[11,"not","","",0,[[["self"]],["wrapping",["u16"]]]],[11,"bitxor","","",0,[[["self"],["wrapping",["u16"]]],["wrapping",["u16"]]]],[11,"bitxor","","",0,N],[11,"bitxor_assign","","",0,[[["self"],["wrapping",["u16"]]]]],[11,"bitxor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitor","","",0,[[["self"],["wrapping",["u16"]]],["wrapping",["u16"]]]],[11,"bitor","","",0,N],[11,"bitor_assign","","",0,[[["self"],["wrapping",["u16"]]]]],[11,"bitor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitand","","",0,[[["self"],["wrapping",["u16"]]],["wrapping",["u16"]]]],[11,"bitand","","",0,N],[11,"bitand_assign","","",0,[[["self"],["wrapping",["u16"]]]]],[11,"bitand_assign","","",0,[[["self"],["wrapping"]]]],[11,"neg","","",0,[[["self"]],["self"]]],[11,"add","","",0,[[["self"],["wrapping",["u32"]]],["wrapping",["u32"]]]],[11,"add","","",0,N],[11,"add_assign","","",0,[[["self"],["wrapping",["u32"]]]]],[11,"add_assign","","",0,[[["self"],["wrapping"]]]],[11,"sub","","",0,[[["self"],["wrapping",["u32"]]],["wrapping",["u32"]]]],[11,"sub","","",0,N],[11,"sub_assign","","",0,[[["self"],["wrapping",["u32"]]]]],[11,"sub_assign","","",0,[[["self"],["wrapping"]]]],[11,"mul","","",0,[[["self"],["wrapping",["u32"]]],["wrapping",["u32"]]]],[11,"mul","","",0,N],[11,"mul_assign","","",0,[[["self"],["wrapping",["u32"]]]]],[11,"mul_assign","","",0,[[["self"],["wrapping"]]]],[11,"div","","",0,[[["self"],["wrapping",["u32"]]],["wrapping",["u32"]]]],[11,"div","","",0,N],[11,"div_assign","","",0,[[["self"],["wrapping",["u32"]]]]],[11,"div_assign","","",0,[[["self"],["wrapping"]]]],[11,"rem","","",0,[[["self"],["wrapping",["u32"]]],["wrapping",["u32"]]]],[11,"rem","","",0,N],[11,"rem_assign","","",0,[[["self"],["wrapping",["u32"]]]]],[11,"rem_assign","","",0,[[["self"],["wrapping"]]]],[11,"not","","",0,[[["self"]],["wrapping",["u32"]]]],[11,"bitxor","","",0,[[["self"],["wrapping",["u32"]]],["wrapping",["u32"]]]],[11,"bitxor","","",0,N],[11,"bitxor_assign","","",0,[[["self"],["wrapping",["u32"]]]]],[11,"bitxor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitor","","",0,[[["self"],["wrapping",["u32"]]],["wrapping",["u32"]]]],[11,"bitor","","",0,N],[11,"bitor_assign","","",0,[[["self"],["wrapping",["u32"]]]]],[11,"bitor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitand","","",0,[[["self"],["wrapping",["u32"]]],["wrapping",["u32"]]]],[11,"bitand","","",0,N],[11,"bitand_assign","","",0,[[["self"],["wrapping",["u32"]]]]],[11,"bitand_assign","","",0,[[["self"],["wrapping"]]]],[11,"neg","","",0,[[["self"]],["self"]]],[11,"add","","",0,[[["self"],["wrapping",["u64"]]],["wrapping",["u64"]]]],[11,"add","","",0,N],[11,"add_assign","","",0,[[["self"],["wrapping",["u64"]]]]],[11,"add_assign","","",0,[[["self"],["wrapping"]]]],[11,"sub","","",0,[[["self"],["wrapping",["u64"]]],["wrapping",["u64"]]]],[11,"sub","","",0,N],[11,"sub_assign","","",0,[[["self"],["wrapping",["u64"]]]]],[11,"sub_assign","","",0,[[["self"],["wrapping"]]]],[11,"mul","","",0,[[["self"],["wrapping",["u64"]]],["wrapping",["u64"]]]],[11,"mul","","",0,N],[11,"mul_assign","","",0,[[["self"],["wrapping",["u64"]]]]],[11,"mul_assign","","",0,[[["self"],["wrapping"]]]],[11,"div","","",0,[[["self"],["wrapping",["u64"]]],["wrapping",["u64"]]]],[11,"div","","",0,N],[11,"div_assign","","",0,[[["self"],["wrapping",["u64"]]]]],[11,"div_assign","","",0,[[["self"],["wrapping"]]]],[11,"rem","","",0,[[["self"],["wrapping",["u64"]]],["wrapping",["u64"]]]],[11,"rem","","",0,N],[11,"rem_assign","","",0,[[["self"],["wrapping",["u64"]]]]],[11,"rem_assign","","",0,[[["self"],["wrapping"]]]],[11,"not","","",0,[[["self"]],["wrapping",["u64"]]]],[11,"bitxor","","",0,[[["self"],["wrapping",["u64"]]],["wrapping",["u64"]]]],[11,"bitxor","","",0,N],[11,"bitxor_assign","","",0,[[["self"],["wrapping",["u64"]]]]],[11,"bitxor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitor","","",0,[[["self"],["wrapping",["u64"]]],["wrapping",["u64"]]]],[11,"bitor","","",0,N],[11,"bitor_assign","","",0,[[["self"],["wrapping",["u64"]]]]],[11,"bitor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitand","","",0,[[["self"],["wrapping",["u64"]]],["wrapping",["u64"]]]],[11,"bitand","","",0,N],[11,"bitand_assign","","",0,[[["self"],["wrapping",["u64"]]]]],[11,"bitand_assign","","",0,[[["self"],["wrapping"]]]],[11,"neg","","",0,[[["self"]],["self"]]],[11,"add","","",0,[[["self"],["wrapping",["u128"]]],["wrapping",["u128"]]]],[11,"add","","",0,N],[11,"add_assign","","",0,[[["self"],["wrapping",["u128"]]]]],[11,"add_assign","","",0,[[["self"],["wrapping"]]]],[11,"sub","","",0,[[["self"],["wrapping",["u128"]]],["wrapping",["u128"]]]],[11,"sub","","",0,N],[11,"sub_assign","","",0,[[["self"],["wrapping",["u128"]]]]],[11,"sub_assign","","",0,[[["self"],["wrapping"]]]],[11,"mul","","",0,[[["self"],["wrapping",["u128"]]],["wrapping",["u128"]]]],[11,"mul","","",0,N],[11,"mul_assign","","",0,[[["self"],["wrapping",["u128"]]]]],[11,"mul_assign","","",0,[[["self"],["wrapping"]]]],[11,"div","","",0,[[["self"],["wrapping",["u128"]]],["wrapping",["u128"]]]],[11,"div","","",0,N],[11,"div_assign","","",0,[[["self"],["wrapping",["u128"]]]]],[11,"div_assign","","",0,[[["self"],["wrapping"]]]],[11,"rem","","",0,[[["self"],["wrapping",["u128"]]],["wrapping",["u128"]]]],[11,"rem","","",0,N],[11,"rem_assign","","",0,[[["self"],["wrapping",["u128"]]]]],[11,"rem_assign","","",0,[[["self"],["wrapping"]]]],[11,"not","","",0,[[["self"]],["wrapping",["u128"]]]],[11,"bitxor","","",0,[[["self"],["wrapping",["u128"]]],["wrapping",["u128"]]]],[11,"bitxor","","",0,N],[11,"bitxor_assign","","",0,[[["self"],["wrapping",["u128"]]]]],[11,"bitxor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitor","","",0,[[["self"],["wrapping",["u128"]]],["wrapping",["u128"]]]],[11,"bitor","","",0,N],[11,"bitor_assign","","",0,[[["self"],["wrapping",["u128"]]]]],[11,"bitor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitand","","",0,[[["self"],["wrapping",["u128"]]],["wrapping",["u128"]]]],[11,"bitand","","",0,N],[11,"bitand_assign","","",0,[[["self"],["wrapping",["u128"]]]]],[11,"bitand_assign","","",0,[[["self"],["wrapping"]]]],[11,"neg","","",0,[[["self"]],["self"]]],[11,"add","","",0,[[["self"],["wrapping",["isize"]]],["wrapping",["isize"]]]],[11,"add","","",0,N],[11,"add_assign","","",0,[[["self"],["wrapping",["isize"]]]]],[11,"add_assign","","",0,[[["self"],["wrapping"]]]],[11,"sub","","",0,[[["self"],["wrapping",["isize"]]],["wrapping",["isize"]]]],[11,"sub","","",0,N],[11,"sub_assign","","",0,[[["self"],["wrapping",["isize"]]]]],[11,"sub_assign","","",0,[[["self"],["wrapping"]]]],[11,"mul","","",0,[[["self"],["wrapping",["isize"]]],["wrapping",["isize"]]]],[11,"mul","","",0,N],[11,"mul_assign","","",0,[[["self"],["wrapping",["isize"]]]]],[11,"mul_assign","","",0,[[["self"],["wrapping"]]]],[11,"div","","",0,[[["self"],["wrapping",["isize"]]],["wrapping",["isize"]]]],[11,"div","","",0,N],[11,"div_assign","","",0,[[["self"],["wrapping",["isize"]]]]],[11,"div_assign","","",0,[[["self"],["wrapping"]]]],[11,"rem","","",0,[[["self"],["wrapping",["isize"]]],["wrapping",["isize"]]]],[11,"rem","","",0,N],[11,"rem_assign","","",0,[[["self"],["wrapping",["isize"]]]]],[11,"rem_assign","","",0,[[["self"],["wrapping"]]]],[11,"not","","",0,[[["self"]],["wrapping",["isize"]]]],[11,"bitxor","","",0,[[["self"],["wrapping",["isize"]]],["wrapping",["isize"]]]],[11,"bitxor","","",0,N],[11,"bitxor_assign","","",0,[[["self"],["wrapping",["isize"]]]]],[11,"bitxor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitor","","",0,[[["self"],["wrapping",["isize"]]],["wrapping",["isize"]]]],[11,"bitor","","",0,N],[11,"bitor_assign","","",0,[[["self"],["wrapping",["isize"]]]]],[11,"bitor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitand","","",0,[[["self"],["wrapping",["isize"]]],["wrapping",["isize"]]]],[11,"bitand","","",0,N],[11,"bitand_assign","","",0,[[["self"],["wrapping",["isize"]]]]],[11,"bitand_assign","","",0,[[["self"],["wrapping"]]]],[11,"neg","","",0,[[["self"]],["self"]]],[11,"add","","",0,[[["self"],["wrapping",["i8"]]],["wrapping",["i8"]]]],[11,"add","","",0,N],[11,"add_assign","","",0,[[["self"],["wrapping",["i8"]]]]],[11,"add_assign","","",0,[[["self"],["wrapping"]]]],[11,"sub","","",0,[[["self"],["wrapping",["i8"]]],["wrapping",["i8"]]]],[11,"sub","","",0,N],[11,"sub_assign","","",0,[[["self"],["wrapping",["i8"]]]]],[11,"sub_assign","","",0,[[["self"],["wrapping"]]]],[11,"mul","","",0,[[["self"],["wrapping",["i8"]]],["wrapping",["i8"]]]],[11,"mul","","",0,N],[11,"mul_assign","","",0,[[["self"],["wrapping",["i8"]]]]],[11,"mul_assign","","",0,[[["self"],["wrapping"]]]],[11,"div","","",0,[[["self"],["wrapping",["i8"]]],["wrapping",["i8"]]]],[11,"div","","",0,N],[11,"div_assign","","",0,[[["self"],["wrapping",["i8"]]]]],[11,"div_assign","","",0,[[["self"],["wrapping"]]]],[11,"rem","","",0,[[["self"],["wrapping",["i8"]]],["wrapping",["i8"]]]],[11,"rem","","",0,N],[11,"rem_assign","","",0,[[["self"],["wrapping",["i8"]]]]],[11,"rem_assign","","",0,[[["self"],["wrapping"]]]],[11,"not","","",0,[[["self"]],["wrapping",["i8"]]]],[11,"bitxor","","",0,[[["self"],["wrapping",["i8"]]],["wrapping",["i8"]]]],[11,"bitxor","","",0,N],[11,"bitxor_assign","","",0,[[["self"],["wrapping",["i8"]]]]],[11,"bitxor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitor","","",0,[[["self"],["wrapping",["i8"]]],["wrapping",["i8"]]]],[11,"bitor","","",0,N],[11,"bitor_assign","","",0,[[["self"],["wrapping",["i8"]]]]],[11,"bitor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitand","","",0,[[["self"],["wrapping",["i8"]]],["wrapping",["i8"]]]],[11,"bitand","","",0,N],[11,"bitand_assign","","",0,[[["self"],["wrapping",["i8"]]]]],[11,"bitand_assign","","",0,[[["self"],["wrapping"]]]],[11,"neg","","",0,[[["self"]],["self"]]],[11,"add","","",0,[[["self"],["wrapping",["i16"]]],["wrapping",["i16"]]]],[11,"add","","",0,N],[11,"add_assign","","",0,[[["self"],["wrapping",["i16"]]]]],[11,"add_assign","","",0,[[["self"],["wrapping"]]]],[11,"sub","","",0,[[["self"],["wrapping",["i16"]]],["wrapping",["i16"]]]],[11,"sub","","",0,N],[11,"sub_assign","","",0,[[["self"],["wrapping",["i16"]]]]],[11,"sub_assign","","",0,[[["self"],["wrapping"]]]],[11,"mul","","",0,[[["self"],["wrapping",["i16"]]],["wrapping",["i16"]]]],[11,"mul","","",0,N],[11,"mul_assign","","",0,[[["self"],["wrapping",["i16"]]]]],[11,"mul_assign","","",0,[[["self"],["wrapping"]]]],[11,"div","","",0,[[["self"],["wrapping",["i16"]]],["wrapping",["i16"]]]],[11,"div","","",0,N],[11,"div_assign","","",0,[[["self"],["wrapping",["i16"]]]]],[11,"div_assign","","",0,[[["self"],["wrapping"]]]],[11,"rem","","",0,[[["self"],["wrapping",["i16"]]],["wrapping",["i16"]]]],[11,"rem","","",0,N],[11,"rem_assign","","",0,[[["self"],["wrapping",["i16"]]]]],[11,"rem_assign","","",0,[[["self"],["wrapping"]]]],[11,"not","","",0,[[["self"]],["wrapping",["i16"]]]],[11,"bitxor","","",0,[[["self"],["wrapping",["i16"]]],["wrapping",["i16"]]]],[11,"bitxor","","",0,N],[11,"bitxor_assign","","",0,[[["self"],["wrapping",["i16"]]]]],[11,"bitxor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitor","","",0,[[["self"],["wrapping",["i16"]]],["wrapping",["i16"]]]],[11,"bitor","","",0,N],[11,"bitor_assign","","",0,[[["self"],["wrapping",["i16"]]]]],[11,"bitor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitand","","",0,[[["self"],["wrapping",["i16"]]],["wrapping",["i16"]]]],[11,"bitand","","",0,N],[11,"bitand_assign","","",0,[[["self"],["wrapping",["i16"]]]]],[11,"bitand_assign","","",0,[[["self"],["wrapping"]]]],[11,"neg","","",0,[[["self"]],["self"]]],[11,"add","","",0,[[["self"],["wrapping",["i32"]]],["wrapping",["i32"]]]],[11,"add","","",0,N],[11,"add_assign","","",0,[[["self"],["wrapping",["i32"]]]]],[11,"add_assign","","",0,[[["self"],["wrapping"]]]],[11,"sub","","",0,[[["self"],["wrapping",["i32"]]],["wrapping",["i32"]]]],[11,"sub","","",0,N],[11,"sub_assign","","",0,[[["self"],["wrapping",["i32"]]]]],[11,"sub_assign","","",0,[[["self"],["wrapping"]]]],[11,"mul","","",0,[[["self"],["wrapping",["i32"]]],["wrapping",["i32"]]]],[11,"mul","","",0,N],[11,"mul_assign","","",0,[[["self"],["wrapping",["i32"]]]]],[11,"mul_assign","","",0,[[["self"],["wrapping"]]]],[11,"div","","",0,[[["self"],["wrapping",["i32"]]],["wrapping",["i32"]]]],[11,"div","","",0,N],[11,"div_assign","","",0,[[["self"],["wrapping",["i32"]]]]],[11,"div_assign","","",0,[[["self"],["wrapping"]]]],[11,"rem","","",0,[[["self"],["wrapping",["i32"]]],["wrapping",["i32"]]]],[11,"rem","","",0,N],[11,"rem_assign","","",0,[[["self"],["wrapping",["i32"]]]]],[11,"rem_assign","","",0,[[["self"],["wrapping"]]]],[11,"not","","",0,[[["self"]],["wrapping",["i32"]]]],[11,"bitxor","","",0,[[["self"],["wrapping",["i32"]]],["wrapping",["i32"]]]],[11,"bitxor","","",0,N],[11,"bitxor_assign","","",0,[[["self"],["wrapping",["i32"]]]]],[11,"bitxor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitor","","",0,[[["self"],["wrapping",["i32"]]],["wrapping",["i32"]]]],[11,"bitor","","",0,N],[11,"bitor_assign","","",0,[[["self"],["wrapping",["i32"]]]]],[11,"bitor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitand","","",0,[[["self"],["wrapping",["i32"]]],["wrapping",["i32"]]]],[11,"bitand","","",0,N],[11,"bitand_assign","","",0,[[["self"],["wrapping",["i32"]]]]],[11,"bitand_assign","","",0,[[["self"],["wrapping"]]]],[11,"neg","","",0,[[["self"]],["self"]]],[11,"add","","",0,[[["self"],["wrapping",["i64"]]],["wrapping",["i64"]]]],[11,"add","","",0,N],[11,"add_assign","","",0,[[["self"],["wrapping",["i64"]]]]],[11,"add_assign","","",0,[[["self"],["wrapping"]]]],[11,"sub","","",0,[[["self"],["wrapping",["i64"]]],["wrapping",["i64"]]]],[11,"sub","","",0,N],[11,"sub_assign","","",0,[[["self"],["wrapping",["i64"]]]]],[11,"sub_assign","","",0,[[["self"],["wrapping"]]]],[11,"mul","","",0,[[["self"],["wrapping",["i64"]]],["wrapping",["i64"]]]],[11,"mul","","",0,N],[11,"mul_assign","","",0,[[["self"],["wrapping",["i64"]]]]],[11,"mul_assign","","",0,[[["self"],["wrapping"]]]],[11,"div","","",0,[[["self"],["wrapping",["i64"]]],["wrapping",["i64"]]]],[11,"div","","",0,N],[11,"div_assign","","",0,[[["self"],["wrapping",["i64"]]]]],[11,"div_assign","","",0,[[["self"],["wrapping"]]]],[11,"rem","","",0,[[["self"],["wrapping",["i64"]]],["wrapping",["i64"]]]],[11,"rem","","",0,N],[11,"rem_assign","","",0,[[["self"],["wrapping",["i64"]]]]],[11,"rem_assign","","",0,[[["self"],["wrapping"]]]],[11,"not","","",0,[[["self"]],["wrapping",["i64"]]]],[11,"bitxor","","",0,[[["self"],["wrapping",["i64"]]],["wrapping",["i64"]]]],[11,"bitxor","","",0,N],[11,"bitxor_assign","","",0,[[["self"],["wrapping",["i64"]]]]],[11,"bitxor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitor","","",0,[[["self"],["wrapping",["i64"]]],["wrapping",["i64"]]]],[11,"bitor","","",0,N],[11,"bitor_assign","","",0,[[["self"],["wrapping",["i64"]]]]],[11,"bitor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitand","","",0,[[["self"],["wrapping",["i64"]]],["wrapping",["i64"]]]],[11,"bitand","","",0,N],[11,"bitand_assign","","",0,[[["self"],["wrapping",["i64"]]]]],[11,"bitand_assign","","",0,[[["self"],["wrapping"]]]],[11,"neg","","",0,[[["self"]],["self"]]],[11,"add","","",0,[[["self"],["wrapping",["i128"]]],["wrapping",["i128"]]]],[11,"add","","",0,N],[11,"add_assign","","",0,[[["self"],["wrapping",["i128"]]]]],[11,"add_assign","","",0,[[["self"],["wrapping"]]]],[11,"sub","","",0,[[["self"],["wrapping",["i128"]]],["wrapping",["i128"]]]],[11,"sub","","",0,N],[11,"sub_assign","","",0,[[["self"],["wrapping",["i128"]]]]],[11,"sub_assign","","",0,[[["self"],["wrapping"]]]],[11,"mul","","",0,[[["self"],["wrapping",["i128"]]],["wrapping",["i128"]]]],[11,"mul","","",0,N],[11,"mul_assign","","",0,[[["self"],["wrapping",["i128"]]]]],[11,"mul_assign","","",0,[[["self"],["wrapping"]]]],[11,"div","","",0,[[["self"],["wrapping",["i128"]]],["wrapping",["i128"]]]],[11,"div","","",0,N],[11,"div_assign","","",0,[[["self"],["wrapping",["i128"]]]]],[11,"div_assign","","",0,[[["self"],["wrapping"]]]],[11,"rem","","",0,[[["self"],["wrapping",["i128"]]],["wrapping",["i128"]]]],[11,"rem","","",0,N],[11,"rem_assign","","",0,[[["self"],["wrapping",["i128"]]]]],[11,"rem_assign","","",0,[[["self"],["wrapping"]]]],[11,"not","","",0,[[["self"]],["wrapping",["i128"]]]],[11,"bitxor","","",0,[[["self"],["wrapping",["i128"]]],["wrapping",["i128"]]]],[11,"bitxor","","",0,N],[11,"bitxor_assign","","",0,[[["self"],["wrapping",["i128"]]]]],[11,"bitxor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitor","","",0,[[["self"],["wrapping",["i128"]]],["wrapping",["i128"]]]],[11,"bitor","","",0,N],[11,"bitor_assign","","",0,[[["self"],["wrapping",["i128"]]]]],[11,"bitor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitand","","",0,[[["self"],["wrapping",["i128"]]],["wrapping",["i128"]]]],[11,"bitand","","",0,N],[11,"bitand_assign","","",0,[[["self"],["wrapping",["i128"]]]]],[11,"bitand_assign","","",0,[[["self"],["wrapping"]]]],[11,"neg","","",0,[[["self"]],["self"]]],[11,"min_value","","Returns the smallest value that can be represented by this integer type.",0,[[],["self"]]],[11,"max_value","","Returns the largest value that can be represented by this integer type.",0,[[],["self"]]],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`, wrapping the truncated bits to the end of the resulting integer.",0,[[["self"],["u32"]],["self"]]],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`, wrapping the truncated bits to the beginning of the resulting integer.",0,[[["self"],["u32"]],["self"]]],[11,"swap_bytes","","Reverses the byte order of the integer.",0,[[["self"]],["self"]]],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,[[["self"]],["self"]]],[11,"from_be","","Converts an integer from big endian to the target's endianness.",0,[[["self"]],["self"]]],[11,"from_le","","Converts an integer from little endian to the target's endianness.",0,[[["self"]],["self"]]],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,[[["self"]],["self"]]],[11,"to_le","","Converts `self` to little endian from the target's endianness.",0,[[["self"]],["self"]]],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",0,[[["self"],["u32"]],["self"]]],[11,"min_value","","Returns the smallest value that can be represented by this integer type.",0,[[],["self"]]],[11,"max_value","","Returns the largest value that can be represented by this integer type.",0,[[],["self"]]],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`, wrapping the truncated bits to the end of the resulting integer.",0,[[["self"],["u32"]],["self"]]],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`, wrapping the truncated bits to the beginning of the resulting integer.",0,[[["self"],["u32"]],["self"]]],[11,"swap_bytes","","Reverses the byte order of the integer.",0,[[["self"]],["self"]]],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,[[["self"]],["self"]]],[11,"from_be","","Converts an integer from big endian to the target's endianness.",0,[[["self"]],["self"]]],[11,"from_le","","Converts an integer from little endian to the target's endianness.",0,[[["self"]],["self"]]],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,[[["self"]],["self"]]],[11,"to_le","","Converts `self` to little endian from the target's endianness.",0,[[["self"]],["self"]]],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",0,[[["self"],["u32"]],["self"]]],[11,"min_value","","Returns the smallest value that can be represented by this integer type.",0,[[],["self"]]],[11,"max_value","","Returns the largest value that can be represented by this integer type.",0,[[],["self"]]],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`, wrapping the truncated bits to the end of the resulting integer.",0,[[["self"],["u32"]],["self"]]],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`, wrapping the truncated bits to the beginning of the resulting integer.",0,[[["self"],["u32"]],["self"]]],[11,"swap_bytes","","Reverses the byte order of the integer.",0,[[["self"]],["self"]]],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,[[["self"]],["self"]]],[11,"from_be","","Converts an integer from big endian to the target's endianness.",0,[[["self"]],["self"]]],[11,"from_le","","Converts an integer from little endian to the target's endianness.",0,[[["self"]],["self"]]],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,[[["self"]],["self"]]],[11,"to_le","","Converts `self` to little endian from the target's endianness.",0,[[["self"]],["self"]]],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",0,[[["self"],["u32"]],["self"]]],[11,"min_value","","Returns the smallest value that can be represented by this integer type.",0,[[],["self"]]],[11,"max_value","","Returns the largest value that can be represented by this integer type.",0,[[],["self"]]],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`, wrapping the truncated bits to the end of the resulting integer.",0,[[["self"],["u32"]],["self"]]],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`, wrapping the truncated bits to the beginning of the resulting integer.",0,[[["self"],["u32"]],["self"]]],[11,"swap_bytes","","Reverses the byte order of the integer.",0,[[["self"]],["self"]]],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,[[["self"]],["self"]]],[11,"from_be","","Converts an integer from big endian to the target's endianness.",0,[[["self"]],["self"]]],[11,"from_le","","Converts an integer from little endian to the target's endianness.",0,[[["self"]],["self"]]],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,[[["self"]],["self"]]],[11,"to_le","","Converts `self` to little endian from the target's endianness.",0,[[["self"]],["self"]]],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",0,[[["self"],["u32"]],["self"]]],[11,"min_value","","Returns the smallest value that can be represented by this integer type.",0,[[],["self"]]],[11,"max_value","","Returns the largest value that can be represented by this integer type.",0,[[],["self"]]],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`, wrapping the truncated bits to the end of the resulting integer.",0,[[["self"],["u32"]],["self"]]],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`, wrapping the truncated bits to the beginning of the resulting integer.",0,[[["self"],["u32"]],["self"]]],[11,"swap_bytes","","Reverses the byte order of the integer.",0,[[["self"]],["self"]]],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,[[["self"]],["self"]]],[11,"from_be","","Converts an integer from big endian to the target's endianness.",0,[[["self"]],["self"]]],[11,"from_le","","Converts an integer from little endian to the target's endianness.",0,[[["self"]],["self"]]],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,[[["self"]],["self"]]],[11,"to_le","","Converts `self` to little endian from the target's endianness.",0,[[["self"]],["self"]]],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",0,[[["self"],["u32"]],["self"]]],[11,"min_value","","Returns the smallest value that can be represented by this integer type.",0,[[],["self"]]],[11,"max_value","","Returns the largest value that can be represented by this integer type.",0,[[],["self"]]],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`, wrapping the truncated bits to the end of the resulting integer.",0,[[["self"],["u32"]],["self"]]],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`, wrapping the truncated bits to the beginning of the resulting integer.",0,[[["self"],["u32"]],["self"]]],[11,"swap_bytes","","Reverses the byte order of the integer.",0,[[["self"]],["self"]]],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,[[["self"]],["self"]]],[11,"from_be","","Converts an integer from big endian to the target's endianness.",0,[[["self"]],["self"]]],[11,"from_le","","Converts an integer from little endian to the target's endianness.",0,[[["self"]],["self"]]],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,[[["self"]],["self"]]],[11,"to_le","","Converts `self` to little endian from the target's endianness.",0,[[["self"]],["self"]]],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",0,[[["self"],["u32"]],["self"]]],[11,"min_value","","Returns the smallest value that can be represented by this integer type.",0,[[],["self"]]],[11,"max_value","","Returns the largest value that can be represented by this integer type.",0,[[],["self"]]],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`, wrapping the truncated bits to the end of the resulting integer.",0,[[["self"],["u32"]],["self"]]],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`, wrapping the truncated bits to the beginning of the resulting integer.",0,[[["self"],["u32"]],["self"]]],[11,"swap_bytes","","Reverses the byte order of the integer.",0,[[["self"]],["self"]]],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,[[["self"]],["self"]]],[11,"from_be","","Converts an integer from big endian to the target's endianness.",0,[[["self"]],["self"]]],[11,"from_le","","Converts an integer from little endian to the target's endianness.",0,[[["self"]],["self"]]],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,[[["self"]],["self"]]],[11,"to_le","","Converts `self` to little endian from the target's endianness.",0,[[["self"]],["self"]]],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",0,[[["self"],["u32"]],["self"]]],[11,"min_value","","Returns the smallest value that can be represented by this integer type.",0,[[],["self"]]],[11,"max_value","","Returns the largest value that can be represented by this integer type.",0,[[],["self"]]],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`, wrapping the truncated bits to the end of the resulting integer.",0,[[["self"],["u32"]],["self"]]],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`, wrapping the truncated bits to the beginning of the resulting integer.",0,[[["self"],["u32"]],["self"]]],[11,"swap_bytes","","Reverses the byte order of the integer.",0,[[["self"]],["self"]]],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,[[["self"]],["self"]]],[11,"from_be","","Converts an integer from big endian to the target's endianness.",0,[[["self"]],["self"]]],[11,"from_le","","Converts an integer from little endian to the target's endianness.",0,[[["self"]],["self"]]],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,[[["self"]],["self"]]],[11,"to_le","","Converts `self` to little endian from the target's endianness.",0,[[["self"]],["self"]]],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",0,[[["self"],["u32"]],["self"]]],[11,"min_value","","Returns the smallest value that can be represented by this integer type.",0,[[],["self"]]],[11,"max_value","","Returns the largest value that can be represented by this integer type.",0,[[],["self"]]],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`, wrapping the truncated bits to the end of the resulting integer.",0,[[["self"],["u32"]],["self"]]],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`, wrapping the truncated bits to the beginning of the resulting integer.",0,[[["self"],["u32"]],["self"]]],[11,"swap_bytes","","Reverses the byte order of the integer.",0,[[["self"]],["self"]]],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,[[["self"]],["self"]]],[11,"from_be","","Converts an integer from big endian to the target's endianness.",0,[[["self"]],["self"]]],[11,"from_le","","Converts an integer from little endian to the target's endianness.",0,[[["self"]],["self"]]],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,[[["self"]],["self"]]],[11,"to_le","","Converts `self` to little endian from the target's endianness.",0,[[["self"]],["self"]]],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",0,[[["self"],["u32"]],["self"]]],[11,"min_value","","Returns the smallest value that can be represented by this integer type.",0,[[],["self"]]],[11,"max_value","","Returns the largest value that can be represented by this integer type.",0,[[],["self"]]],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`, wrapping the truncated bits to the end of the resulting integer.",0,[[["self"],["u32"]],["self"]]],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`, wrapping the truncated bits to the beginning of the resulting integer.",0,[[["self"],["u32"]],["self"]]],[11,"swap_bytes","","Reverses the byte order of the integer.",0,[[["self"]],["self"]]],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,[[["self"]],["self"]]],[11,"from_be","","Converts an integer from big endian to the target's endianness.",0,[[["self"]],["self"]]],[11,"from_le","","Converts an integer from little endian to the target's endianness.",0,[[["self"]],["self"]]],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,[[["self"]],["self"]]],[11,"to_le","","Converts `self` to little endian from the target's endianness.",0,[[["self"]],["self"]]],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",0,[[["self"],["u32"]],["self"]]],[11,"min_value","","Returns the smallest value that can be represented by this integer type.",0,[[],["self"]]],[11,"max_value","","Returns the largest value that can be represented by this integer type.",0,[[],["self"]]],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`, wrapping the truncated bits to the end of the resulting integer.",0,[[["self"],["u32"]],["self"]]],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`, wrapping the truncated bits to the beginning of the resulting integer.",0,[[["self"],["u32"]],["self"]]],[11,"swap_bytes","","Reverses the byte order of the integer.",0,[[["self"]],["self"]]],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,[[["self"]],["self"]]],[11,"from_be","","Converts an integer from big endian to the target's endianness.",0,[[["self"]],["self"]]],[11,"from_le","","Converts an integer from little endian to the target's endianness.",0,[[["self"]],["self"]]],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,[[["self"]],["self"]]],[11,"to_le","","Converts `self` to little endian from the target's endianness.",0,[[["self"]],["self"]]],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",0,[[["self"],["u32"]],["self"]]],[11,"min_value","","Returns the smallest value that can be represented by this integer type.",0,[[],["self"]]],[11,"max_value","","Returns the largest value that can be represented by this integer type.",0,[[],["self"]]],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`, wrapping the truncated bits to the end of the resulting integer.",0,[[["self"],["u32"]],["self"]]],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`, wrapping the truncated bits to the beginning of the resulting integer.",0,[[["self"],["u32"]],["self"]]],[11,"swap_bytes","","Reverses the byte order of the integer.",0,[[["self"]],["self"]]],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,[[["self"]],["self"]]],[11,"from_be","","Converts an integer from big endian to the target's endianness.",0,[[["self"]],["self"]]],[11,"from_le","","Converts an integer from little endian to the target's endianness.",0,[[["self"]],["self"]]],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,[[["self"]],["self"]]],[11,"to_le","","Converts `self` to little endian from the target's endianness.",0,[[["self"]],["self"]]],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",0,[[["self"],["u32"]],["self"]]],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"abs","","Computes the absolute value of `self`, wrapping around at the boundary of the type.",0,[[["self"]],["wrapping",["isize"]]]],[11,"signum","","Returns a number representing sign of `self`.",0,[[["self"]],["wrapping",["isize"]]]],[11,"is_positive","","Returns `true` if `self` is positive and `false` if the number is zero or negative.",0,[[["self"]],["bool"]]],[11,"is_negative","","Returns `true` if `self` is negative and `false` if the number is zero or positive.",0,[[["self"]],["bool"]]],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"abs","","Computes the absolute value of `self`, wrapping around at the boundary of the type.",0,[[["self"]],["wrapping",["i8"]]]],[11,"signum","","Returns a number representing sign of `self`.",0,[[["self"]],["wrapping",["i8"]]]],[11,"is_positive","","Returns `true` if `self` is positive and `false` if the number is zero or negative.",0,[[["self"]],["bool"]]],[11,"is_negative","","Returns `true` if `self` is negative and `false` if the number is zero or positive.",0,[[["self"]],["bool"]]],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"abs","","Computes the absolute value of `self`, wrapping around at the boundary of the type.",0,[[["self"]],["wrapping",["i16"]]]],[11,"signum","","Returns a number representing sign of `self`.",0,[[["self"]],["wrapping",["i16"]]]],[11,"is_positive","","Returns `true` if `self` is positive and `false` if the number is zero or negative.",0,[[["self"]],["bool"]]],[11,"is_negative","","Returns `true` if `self` is negative and `false` if the number is zero or positive.",0,[[["self"]],["bool"]]],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"abs","","Computes the absolute value of `self`, wrapping around at the boundary of the type.",0,[[["self"]],["wrapping",["i32"]]]],[11,"signum","","Returns a number representing sign of `self`.",0,[[["self"]],["wrapping",["i32"]]]],[11,"is_positive","","Returns `true` if `self` is positive and `false` if the number is zero or negative.",0,[[["self"]],["bool"]]],[11,"is_negative","","Returns `true` if `self` is negative and `false` if the number is zero or positive.",0,[[["self"]],["bool"]]],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"abs","","Computes the absolute value of `self`, wrapping around at the boundary of the type.",0,[[["self"]],["wrapping",["i64"]]]],[11,"signum","","Returns a number representing sign of `self`.",0,[[["self"]],["wrapping",["i64"]]]],[11,"is_positive","","Returns `true` if `self` is positive and `false` if the number is zero or negative.",0,[[["self"]],["bool"]]],[11,"is_negative","","Returns `true` if `self` is negative and `false` if the number is zero or positive.",0,[[["self"]],["bool"]]],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"abs","","Computes the absolute value of `self`, wrapping around at the boundary of the type.",0,[[["self"]],["wrapping",["i128"]]]],[11,"signum","","Returns a number representing sign of `self`.",0,[[["self"]],["wrapping",["i128"]]]],[11,"is_positive","","Returns `true` if `self` is positive and `false` if the number is zero or negative.",0,[[["self"]],["bool"]]],[11,"is_negative","","Returns `true` if `self` is negative and `false` if the number is zero or positive.",0,[[["self"]],["bool"]]],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"is_power_of_two","","Returns `true` if and only if `self == 2^k` for some `k`.",0,[[["self"]],["bool"]]],[11,"next_power_of_two","","Returns the smallest power of two greater than or equal to `self`.",0,[[["self"]],["self"]]],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"is_power_of_two","","Returns `true` if and only if `self == 2^k` for some `k`.",0,[[["self"]],["bool"]]],[11,"next_power_of_two","","Returns the smallest power of two greater than or equal to `self`.",0,[[["self"]],["self"]]],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"is_power_of_two","","Returns `true` if and only if `self == 2^k` for some `k`.",0,[[["self"]],["bool"]]],[11,"next_power_of_two","","Returns the smallest power of two greater than or equal to `self`.",0,[[["self"]],["self"]]],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"is_power_of_two","","Returns `true` if and only if `self == 2^k` for some `k`.",0,[[["self"]],["bool"]]],[11,"next_power_of_two","","Returns the smallest power of two greater than or equal to `self`.",0,[[["self"]],["self"]]],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"is_power_of_two","","Returns `true` if and only if `self == 2^k` for some `k`.",0,[[["self"]],["bool"]]],[11,"next_power_of_two","","Returns the smallest power of two greater than or equal to `self`.",0,[[["self"]],["self"]]],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"is_power_of_two","","Returns `true` if and only if `self == 2^k` for some `k`.",0,[[["self"]],["bool"]]],[11,"next_power_of_two","","Returns the smallest power of two greater than or equal to `self`.",0,[[["self"]],["self"]]],[11,"clone","","",3,[[["self"]],["nonzerou8"]]],[11,"eq","","",3,[[["self"],["nonzerou8"]],["bool"]]],[11,"ne","","",3,[[["self"],["nonzerou8"]],["bool"]]],[11,"cmp","","",3,[[["self"],["nonzerou8"]],["ordering"]]],[11,"partial_cmp","","",3,[[["self"],["nonzerou8"]],["option",["ordering"]]]],[11,"lt","","",3,[[["self"],["nonzerou8"]],["bool"]]],[11,"le","","",3,[[["self"],["nonzerou8"]],["bool"]]],[11,"gt","","",3,[[["self"],["nonzerou8"]],["bool"]]],[11,"ge","","",3,[[["self"],["nonzerou8"]],["bool"]]],[11,"hash","","",3,N],[11,"new_unchecked","","Create a non-zero without checking the value.",3,[[["u8"]],["self"]]],[11,"new","","Create a non-zero if the given value is not zero.",3,[[["u8"]],["option"]]],[11,"get","","Returns the value as a primitive type.",3,[[["self"]],["u8"]]],[11,"fmt","","",3,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",3,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",3,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",3,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",3,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",3,[[["self"],["formatter"]],["result"]]],[11,"clone","","",4,[[["self"]],["nonzerou16"]]],[11,"eq","","",4,[[["self"],["nonzerou16"]],["bool"]]],[11,"ne","","",4,[[["self"],["nonzerou16"]],["bool"]]],[11,"cmp","","",4,[[["self"],["nonzerou16"]],["ordering"]]],[11,"partial_cmp","","",4,[[["self"],["nonzerou16"]],["option",["ordering"]]]],[11,"lt","","",4,[[["self"],["nonzerou16"]],["bool"]]],[11,"le","","",4,[[["self"],["nonzerou16"]],["bool"]]],[11,"gt","","",4,[[["self"],["nonzerou16"]],["bool"]]],[11,"ge","","",4,[[["self"],["nonzerou16"]],["bool"]]],[11,"hash","","",4,N],[11,"new_unchecked","","Create a non-zero without checking the value.",4,[[["u16"]],["self"]]],[11,"new","","Create a non-zero if the given value is not zero.",4,[[["u16"]],["option"]]],[11,"get","","Returns the value as a primitive type.",4,[[["self"]],["u16"]]],[11,"fmt","","",4,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",4,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",4,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",4,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",4,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",4,[[["self"],["formatter"]],["result"]]],[11,"clone","","",5,[[["self"]],["nonzerou32"]]],[11,"eq","","",5,[[["self"],["nonzerou32"]],["bool"]]],[11,"ne","","",5,[[["self"],["nonzerou32"]],["bool"]]],[11,"cmp","","",5,[[["self"],["nonzerou32"]],["ordering"]]],[11,"partial_cmp","","",5,[[["self"],["nonzerou32"]],["option",["ordering"]]]],[11,"lt","","",5,[[["self"],["nonzerou32"]],["bool"]]],[11,"le","","",5,[[["self"],["nonzerou32"]],["bool"]]],[11,"gt","","",5,[[["self"],["nonzerou32"]],["bool"]]],[11,"ge","","",5,[[["self"],["nonzerou32"]],["bool"]]],[11,"hash","","",5,N],[11,"new_unchecked","","Create a non-zero without checking the value.",5,[[["u32"]],["self"]]],[11,"new","","Create a non-zero if the given value is not zero.",5,[[["u32"]],["option"]]],[11,"get","","Returns the value as a primitive type.",5,[[["self"]],["u32"]]],[11,"fmt","","",5,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",5,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",5,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",5,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",5,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",5,[[["self"],["formatter"]],["result"]]],[11,"clone","","",6,[[["self"]],["nonzerou64"]]],[11,"eq","","",6,[[["self"],["nonzerou64"]],["bool"]]],[11,"ne","","",6,[[["self"],["nonzerou64"]],["bool"]]],[11,"cmp","","",6,[[["self"],["nonzerou64"]],["ordering"]]],[11,"partial_cmp","","",6,[[["self"],["nonzerou64"]],["option",["ordering"]]]],[11,"lt","","",6,[[["self"],["nonzerou64"]],["bool"]]],[11,"le","","",6,[[["self"],["nonzerou64"]],["bool"]]],[11,"gt","","",6,[[["self"],["nonzerou64"]],["bool"]]],[11,"ge","","",6,[[["self"],["nonzerou64"]],["bool"]]],[11,"hash","","",6,N],[11,"new_unchecked","","Create a non-zero without checking the value.",6,[[["u64"]],["self"]]],[11,"new","","Create a non-zero if the given value is not zero.",6,[[["u64"]],["option"]]],[11,"get","","Returns the value as a primitive type.",6,[[["self"]],["u64"]]],[11,"fmt","","",6,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",6,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",6,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",6,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",6,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",6,[[["self"],["formatter"]],["result"]]],[11,"clone","","",7,[[["self"]],["nonzerou128"]]],[11,"eq","","",7,[[["self"],["nonzerou128"]],["bool"]]],[11,"ne","","",7,[[["self"],["nonzerou128"]],["bool"]]],[11,"cmp","","",7,[[["self"],["nonzerou128"]],["ordering"]]],[11,"partial_cmp","","",7,[[["self"],["nonzerou128"]],["option",["ordering"]]]],[11,"lt","","",7,[[["self"],["nonzerou128"]],["bool"]]],[11,"le","","",7,[[["self"],["nonzerou128"]],["bool"]]],[11,"gt","","",7,[[["self"],["nonzerou128"]],["bool"]]],[11,"ge","","",7,[[["self"],["nonzerou128"]],["bool"]]],[11,"hash","","",7,N],[11,"new_unchecked","","Create a non-zero without checking the value.",7,[[["u128"]],["self"]]],[11,"new","","Create a non-zero if the given value is not zero.",7,[[["u128"]],["option"]]],[11,"get","","Returns the value as a primitive type.",7,[[["self"]],["u128"]]],[11,"fmt","","",7,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",7,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",7,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",7,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",7,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",7,[[["self"],["formatter"]],["result"]]],[11,"clone","","",8,[[["self"]],["nonzerousize"]]],[11,"eq","","",8,[[["self"],["nonzerousize"]],["bool"]]],[11,"ne","","",8,[[["self"],["nonzerousize"]],["bool"]]],[11,"cmp","","",8,[[["self"],["nonzerousize"]],["ordering"]]],[11,"partial_cmp","","",8,[[["self"],["nonzerousize"]],["option",["ordering"]]]],[11,"lt","","",8,[[["self"],["nonzerousize"]],["bool"]]],[11,"le","","",8,[[["self"],["nonzerousize"]],["bool"]]],[11,"gt","","",8,[[["self"],["nonzerousize"]],["bool"]]],[11,"ge","","",8,[[["self"],["nonzerousize"]],["bool"]]],[11,"hash","","",8,N],[11,"new_unchecked","","Create a non-zero without checking the value.",8,[[["usize"]],["self"]]],[11,"new","","Create a non-zero if the given value is not zero.",8,[[["usize"]],["option"]]],[11,"get","","Returns the value as a primitive type.",8,[[["self"]],["usize"]]],[11,"fmt","","",8,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",8,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",8,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",8,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",8,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",8,[[["self"],["formatter"]],["result"]]],[11,"eq","","",0,[[["self"],["wrapping"]],["bool"]]],[11,"ne","","",0,[[["self"],["wrapping"]],["bool"]]],[11,"partial_cmp","","",0,[[["self"],["wrapping"]],["option",["ordering"]]]],[11,"lt","","",0,[[["self"],["wrapping"]],["bool"]]],[11,"le","","",0,[[["self"],["wrapping"]],["bool"]]],[11,"gt","","",0,[[["self"],["wrapping"]],["bool"]]],[11,"ge","","",0,[[["self"],["wrapping"]],["bool"]]],[11,"cmp","","",0,[[["self"],["wrapping"]],["ordering"]]],[11,"clone","","",0,[[["self"]],["wrapping"]]],[11,"default","","",0,[[],["wrapping"]]],[11,"hash","","",0,N],[11,"fmt","","",0,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",0,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",0,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",0,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",0,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",0,[[["self"],["formatter"]],["result"]]],[11,"clone","","",1,[[["self"]],["fpcategory"]]],[11,"eq","","",1,[[["self"],["fpcategory"]],["bool"]]],[11,"fmt","","",1,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",9,[[["self"],["formatter"]],["result"]]],[11,"clone","","",9,[[["self"]],["tryfrominterror"]]],[11,"fmt","","",9,[[["self"],["formatter"]],["result"]]],[11,"from","","",9,N],[11,"fmt","","",10,[[["self"],["formatter"]],["result"]]],[11,"clone","","",10,[[["self"]],["parseinterror"]]],[11,"eq","","",10,[[["self"],["parseinterror"]],["bool"]]],[11,"ne","","",10,[[["self"],["parseinterror"]],["bool"]]],[11,"fmt","","",10,[[["self"],["formatter"]],["result"]]],[0,"prelude","core","The libcore prelude",N,N],[0,"v1","core::prelude","The core prelude",N,N],[0,"intrinsics","core","rustc compiler intrinsics.",N,N],[5,"atomic_cxchg","core::intrinsics","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::SeqCst` as both the `success` and `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",N,N],[5,"atomic_cxchg_acq","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::Acquire` as both the `success` and `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",N,N],[5,"atomic_cxchg_rel","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::Release` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",N,N],[5,"atomic_cxchg_acqrel","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::AcqRel` as the `success` and `Ordering::Acquire` as the `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",N,N],[5,"atomic_cxchg_relaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::Relaxed` as both the `success` and `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",N,N],[5,"atomic_cxchg_failrelaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::SeqCst` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",N,N],[5,"atomic_cxchg_failacq","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::SeqCst` as the `success` and `Ordering::Acquire` as the `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",N,N],[5,"atomic_cxchg_acq_failrelaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::Acquire` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",N,N],[5,"atomic_cxchg_acqrel_failrelaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::AcqRel` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",N,N],[5,"atomic_cxchgweak","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::SeqCst` as both the `success` and `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",N,N],[5,"atomic_cxchgweak_acq","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::Acquire` as both the `success` and `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",N,N],[5,"atomic_cxchgweak_rel","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::Release` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",N,N],[5,"atomic_cxchgweak_acqrel","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::AcqRel` as the `success` and `Ordering::Acquire` as the `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",N,N],[5,"atomic_cxchgweak_relaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::Relaxed` as both the `success` and `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",N,N],[5,"atomic_cxchgweak_failrelaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::SeqCst` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",N,N],[5,"atomic_cxchgweak_failacq","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::SeqCst` as the `success` and `Ordering::Acquire` as the `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",N,N],[5,"atomic_cxchgweak_acq_failrelaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::Acquire` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",N,N],[5,"atomic_cxchgweak_acqrel_failrelaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::AcqRel` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",N,N],[5,"atomic_load","","Loads the current value of the pointer. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `load` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::load`.",N,N],[5,"atomic_load_acq","","Loads the current value of the pointer. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `load` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicBool::load`.",N,N],[5,"atomic_load_relaxed","","Loads the current value of the pointer. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `load` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::load`.",N,N],[5,"atomic_load_unordered","","",N,N],[5,"atomic_store","","Stores the value at the specified memory location. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `store` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::store`.",N,N],[5,"atomic_store_rel","","Stores the value at the specified memory location. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `store` method by passing `Ordering::Release` as the `order`. For example, `AtomicBool::store`.",N,N],[5,"atomic_store_relaxed","","Stores the value at the specified memory location. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `store` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::store`.",N,N],[5,"atomic_store_unordered","","",N,N],[5,"atomic_xchg","","Stores the value at the specified memory location, returning the old value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `swap` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::swap`.",N,N],[5,"atomic_xchg_acq","","Stores the value at the specified memory location, returning the old value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `swap` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicBool::swap`.",N,N],[5,"atomic_xchg_rel","","Stores the value at the specified memory location, returning the old value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `swap` method by passing `Ordering::Release` as the `order`. For example, `AtomicBool::swap`.",N,N],[5,"atomic_xchg_acqrel","","Stores the value at the specified memory location, returning the old value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `swap` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicBool::swap`.",N,N],[5,"atomic_xchg_relaxed","","Stores the value at the specified memory location, returning the old value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `swap` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::swap`.",N,N],[5,"atomic_xadd","","Add to the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_add` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicIsize::fetch_add`.",N,N],[5,"atomic_xadd_acq","","Add to the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_add` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicIsize::fetch_add`.",N,N],[5,"atomic_xadd_rel","","Add to the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_add` method by passing `Ordering::Release` as the `order`. For example, `AtomicIsize::fetch_add`.",N,N],[5,"atomic_xadd_acqrel","","Add to the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_add` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicIsize::fetch_add`.",N,N],[5,"atomic_xadd_relaxed","","Add to the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_add` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicIsize::fetch_add`.",N,N],[5,"atomic_xsub","","Subtract from the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_sub` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicIsize::fetch_sub`.",N,N],[5,"atomic_xsub_acq","","Subtract from the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_sub` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicIsize::fetch_sub`.",N,N],[5,"atomic_xsub_rel","","Subtract from the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_sub` method by passing `Ordering::Release` as the `order`. For example, `AtomicIsize::fetch_sub`.",N,N],[5,"atomic_xsub_acqrel","","Subtract from the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_sub` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicIsize::fetch_sub`.",N,N],[5,"atomic_xsub_relaxed","","Subtract from the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_sub` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicIsize::fetch_sub`.",N,N],[5,"atomic_and","","Bitwise and with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_and` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::fetch_and`.",N,N],[5,"atomic_and_acq","","Bitwise and with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_and` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicBool::fetch_and`.",N,N],[5,"atomic_and_rel","","Bitwise and with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_and` method by passing `Ordering::Release` as the `order`. For example, `AtomicBool::fetch_and`.",N,N],[5,"atomic_and_acqrel","","Bitwise and with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_and` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicBool::fetch_and`.",N,N],[5,"atomic_and_relaxed","","Bitwise and with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_and` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::fetch_and`.",N,N],[5,"atomic_nand","","Bitwise nand with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic::AtomicBool` type via the `fetch_nand` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::fetch_nand`.",N,N],[5,"atomic_nand_acq","","Bitwise nand with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic::AtomicBool` type via the `fetch_nand` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicBool::fetch_nand`.",N,N],[5,"atomic_nand_rel","","Bitwise nand with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic::AtomicBool` type via the `fetch_nand` method by passing `Ordering::Release` as the `order`. For example, `AtomicBool::fetch_nand`.",N,N],[5,"atomic_nand_acqrel","","Bitwise nand with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic::AtomicBool` type via the `fetch_nand` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicBool::fetch_nand`.",N,N],[5,"atomic_nand_relaxed","","Bitwise nand with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic::AtomicBool` type via the `fetch_nand` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::fetch_nand`.",N,N],[5,"atomic_or","","Bitwise or with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_or` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::fetch_or`.",N,N],[5,"atomic_or_acq","","Bitwise or with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_or` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicBool::fetch_or`.",N,N],[5,"atomic_or_rel","","Bitwise or with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_or` method by passing `Ordering::Release` as the `order`. For example, `AtomicBool::fetch_or`.",N,N],[5,"atomic_or_acqrel","","Bitwise or with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_or` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicBool::fetch_or`.",N,N],[5,"atomic_or_relaxed","","Bitwise or with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_or` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::fetch_or`.",N,N],[5,"atomic_xor","","Bitwise xor with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_xor` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::fetch_xor`.",N,N],[5,"atomic_xor_acq","","Bitwise xor with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_xor` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicBool::fetch_xor`.",N,N],[5,"atomic_xor_rel","","Bitwise xor with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_xor` method by passing `Ordering::Release` as the `order`. For example, `AtomicBool::fetch_xor`.",N,N],[5,"atomic_xor_acqrel","","Bitwise xor with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_xor` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicBool::fetch_xor`.",N,N],[5,"atomic_xor_relaxed","","Bitwise xor with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_xor` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::fetch_xor`.",N,N],[5,"atomic_max","","",N,N],[5,"atomic_max_acq","","",N,N],[5,"atomic_max_rel","","",N,N],[5,"atomic_max_acqrel","","",N,N],[5,"atomic_max_relaxed","","",N,N],[5,"atomic_min","","",N,N],[5,"atomic_min_acq","","",N,N],[5,"atomic_min_rel","","",N,N],[5,"atomic_min_acqrel","","",N,N],[5,"atomic_min_relaxed","","",N,N],[5,"atomic_umin","","",N,N],[5,"atomic_umin_acq","","",N,N],[5,"atomic_umin_rel","","",N,N],[5,"atomic_umin_acqrel","","",N,N],[5,"atomic_umin_relaxed","","",N,N],[5,"atomic_umax","","",N,N],[5,"atomic_umax_acq","","",N,N],[5,"atomic_umax_rel","","",N,N],[5,"atomic_umax_acqrel","","",N,N],[5,"atomic_umax_relaxed","","",N,N],[5,"prefetch_read_data","","The `prefetch` intrinsic is a hint to the code generator to insert a prefetch instruction if supported; otherwise, it is a noop. Prefetches have no effect on the behavior of the program but can change its performance characteristics.",N,N],[5,"prefetch_write_data","","The `prefetch` intrinsic is a hint to the code generator to insert a prefetch instruction if supported; otherwise, it is a noop. Prefetches have no effect on the behavior of the program but can change its performance characteristics.",N,N],[5,"prefetch_read_instruction","","The `prefetch` intrinsic is a hint to the code generator to insert a prefetch instruction if supported; otherwise, it is a noop. Prefetches have no effect on the behavior of the program but can change its performance characteristics.",N,N],[5,"prefetch_write_instruction","","The `prefetch` intrinsic is a hint to the code generator to insert a prefetch instruction if supported; otherwise, it is a noop. Prefetches have no effect on the behavior of the program but can change its performance characteristics.",N,N],[5,"atomic_fence","","",N,N],[5,"atomic_fence_acq","","",N,N],[5,"atomic_fence_rel","","",N,N],[5,"atomic_fence_acqrel","","",N,N],[5,"atomic_singlethreadfence","","A compiler-only memory barrier.",N,N],[5,"atomic_singlethreadfence_acq","","",N,N],[5,"atomic_singlethreadfence_rel","","",N,N],[5,"atomic_singlethreadfence_acqrel","","",N,N],[5,"rustc_peek","","Magic intrinsic that derives its meaning from attributes attached to the function.",N,N],[5,"abort","","Aborts the execution of the process.",N,N],[5,"unreachable","","Tells LLVM that this point in the code is not reachable, enabling further optimizations.",N,N],[5,"assume","","Informs the optimizer that a condition is always true. If the condition is false, the behavior is undefined.",N,N],[5,"likely","","Hints to the compiler that branch condition is likely to be true. Returns the value passed to it.",N,N],[5,"unlikely","","Hints to the compiler that branch condition is likely to be false. Returns the value passed to it.",N,N],[5,"breakpoint","","Executes a breakpoint trap, for inspection by a debugger.",N,N],[5,"size_of","","The size of a type in bytes.",N,N],[5,"move_val_init","","Moves a value to an uninitialized memory location.",N,N],[5,"min_align_of","","",N,N],[5,"pref_align_of","","",N,N],[5,"size_of_val","","The size of the referenced value in bytes.",N,N],[5,"min_align_of_val","","",N,N],[5,"type_name","","Gets a static string slice containing the name of a type.",N,N],[5,"type_id","","Gets an identifier which is globally unique to the specified type. This function will return the same value for a type regardless of whichever crate it is invoked in.",N,N],[5,"init","","Creates a value initialized to zero.",N,N],[5,"uninit","","Creates an uninitialized value.",N,N],[5,"transmute","","Reinterprets the bits of a value of one type as another type.",N,N],[5,"needs_drop","","Returns `true` if the actual type given as `T` requires drop glue; returns `false` if the actual type provided for `T` implements `Copy`.",N,N],[5,"offset","","Calculates the offset from a pointer.",N,N],[5,"arith_offset","","Calculates the offset from a pointer, potentially wrapping.",N,N],[5,"copy_nonoverlapping","","Copies `count * size_of<T>` bytes from `src` to `dst`. The source and destination may not overlap.",N,N],[5,"copy","","Copies `count * size_of<T>` bytes from `src` to `dst`. The source and destination may overlap.",N,N],[5,"write_bytes","","Invokes memset on the specified pointer, setting `count * size_of::<T>()` bytes of memory starting at `dst` to `val`.",N,N],[5,"volatile_copy_nonoverlapping_memory","","Equivalent to the appropriate `llvm.memcpy.p0i8.0i8.*` intrinsic, with a size of `count` * `size_of::<T>()` and an alignment of `min_align_of::<T>()`",N,N],[5,"volatile_copy_memory","","Equivalent to the appropriate `llvm.memmove.p0i8.0i8.*` intrinsic, with a size of `count` * `size_of::<T>()` and an alignment of `min_align_of::<T>()`",N,N],[5,"volatile_set_memory","","Equivalent to the appropriate `llvm.memset.p0i8.*` intrinsic, with a size of `count` * `size_of::<T>()` and an alignment of `min_align_of::<T>()`.",N,N],[5,"volatile_load","","Perform a volatile load from the `src` pointer. The stabilized version of this intrinsic is `std::ptr::read_volatile`.",N,N],[5,"volatile_store","","Perform a volatile store to the `dst` pointer. The stabilized version of this intrinsic is `std::ptr::write_volatile`.",N,N],[5,"unaligned_volatile_load","","Perform a volatile load from the `src` pointer The pointer is not required to be aligned.",N,N],[5,"unaligned_volatile_store","","Perform a volatile store to the `dst` pointer. The pointer is not required to be aligned.",N,N],[5,"sqrtf32","","Returns the square root of an `f32`",N,N],[5,"sqrtf64","","Returns the square root of an `f64`",N,N],[5,"powif32","","Raises an `f32` to an integer power.",N,N],[5,"powif64","","Raises an `f64` to an integer power.",N,N],[5,"sinf32","","Returns the sine of an `f32`.",N,N],[5,"sinf64","","Returns the sine of an `f64`.",N,N],[5,"cosf32","","Returns the cosine of an `f32`.",N,N],[5,"cosf64","","Returns the cosine of an `f64`.",N,N],[5,"powf32","","Raises an `f32` to an `f32` power.",N,N],[5,"powf64","","Raises an `f64` to an `f64` power.",N,N],[5,"expf32","","Returns the exponential of an `f32`.",N,N],[5,"expf64","","Returns the exponential of an `f64`.",N,N],[5,"exp2f32","","Returns 2 raised to the power of an `f32`.",N,N],[5,"exp2f64","","Returns 2 raised to the power of an `f64`.",N,N],[5,"logf32","","Returns the natural logarithm of an `f32`.",N,N],[5,"logf64","","Returns the natural logarithm of an `f64`.",N,N],[5,"log10f32","","Returns the base 10 logarithm of an `f32`.",N,N],[5,"log10f64","","Returns the base 10 logarithm of an `f64`.",N,N],[5,"log2f32","","Returns the base 2 logarithm of an `f32`.",N,N],[5,"log2f64","","Returns the base 2 logarithm of an `f64`.",N,N],[5,"fmaf32","","Returns `a * b + c` for `f32` values.",N,N],[5,"fmaf64","","Returns `a * b + c` for `f64` values.",N,N],[5,"fabsf32","","Returns the absolute value of an `f32`.",N,N],[5,"fabsf64","","Returns the absolute value of an `f64`.",N,N],[5,"copysignf32","","Copies the sign from `y` to `x` for `f32` values.",N,N],[5,"copysignf64","","Copies the sign from `y` to `x` for `f64` values.",N,N],[5,"floorf32","","Returns the largest integer less than or equal to an `f32`.",N,N],[5,"floorf64","","Returns the largest integer less than or equal to an `f64`.",N,N],[5,"ceilf32","","Returns the smallest integer greater than or equal to an `f32`.",N,N],[5,"ceilf64","","Returns the smallest integer greater than or equal to an `f64`.",N,N],[5,"truncf32","","Returns the integer part of an `f32`.",N,N],[5,"truncf64","","Returns the integer part of an `f64`.",N,N],[5,"rintf32","","Returns the nearest integer to an `f32`. May raise an inexact floating-point exception if the argument is not an integer.",N,N],[5,"rintf64","","Returns the nearest integer to an `f64`. May raise an inexact floating-point exception if the argument is not an integer.",N,N],[5,"nearbyintf32","","Returns the nearest integer to an `f32`.",N,N],[5,"nearbyintf64","","Returns the nearest integer to an `f64`.",N,N],[5,"roundf32","","Returns the nearest integer to an `f32`. Rounds half-way cases away from zero.",N,N],[5,"roundf64","","Returns the nearest integer to an `f64`. Rounds half-way cases away from zero.",N,N],[5,"fadd_fast","","Float addition that allows optimizations based on algebraic rules. May assume inputs are finite.",N,N],[5,"fsub_fast","","Float subtraction that allows optimizations based on algebraic rules. May assume inputs are finite.",N,N],[5,"fmul_fast","","Float multiplication that allows optimizations based on algebraic rules. May assume inputs are finite.",N,N],[5,"fdiv_fast","","Float division that allows optimizations based on algebraic rules. May assume inputs are finite.",N,N],[5,"frem_fast","","Float remainder that allows optimizations based on algebraic rules. May assume inputs are finite.",N,N],[5,"ctpop","","Returns the number of bits set in an integer type `T`",N,N],[5,"ctlz","","Returns the number of leading unset bits (zeroes) in an integer type `T`.",N,N],[5,"ctlz_nonzero","","Like `ctlz`, but extra-unsafe as it returns `undef` when given an `x` with value `0`.",N,N],[5,"cttz","","Returns the number of trailing unset bits (zeroes) in an integer type `T`.",N,N],[5,"cttz_nonzero","","Like `cttz`, but extra-unsafe as it returns `undef` when given an `x` with value `0`.",N,N],[5,"bswap","","Reverses the bytes in an integer type `T`.",N,N],[5,"bitreverse","","Reverses the bits in an integer type `T`.",N,N],[5,"add_with_overflow","","Performs checked integer addition. The stabilized versions of this intrinsic are available on the integer primitives via the `overflowing_add` method. For example, `std::u32::overflowing_add`",N,N],[5,"sub_with_overflow","","Performs checked integer subtraction The stabilized versions of this intrinsic are available on the integer primitives via the `overflowing_sub` method. For example, `std::u32::overflowing_sub`",N,N],[5,"mul_with_overflow","","Performs checked integer multiplication The stabilized versions of this intrinsic are available on the integer primitives via the `overflowing_mul` method. For example, `std::u32::overflowing_mul`",N,N],[5,"exact_div","","Performs an exact division, resulting in undefined behavior where `x % y != 0` or `y == 0` or `x == T::min_value() && y == -1`",N,N],[5,"unchecked_div","","Performs an unchecked division, resulting in undefined behavior where y = 0 or x = `T::min_value()` and y = -1",N,N],[5,"unchecked_rem","","Returns the remainder of an unchecked division, resulting in undefined behavior where y = 0 or x = `T::min_value()` and y = -1",N,N],[5,"unchecked_shl","","Performs an unchecked left shift, resulting in undefined behavior when y < 0 or y >= N, where N is the width of T in bits.",N,N],[5,"unchecked_shr","","Performs an unchecked right shift, resulting in undefined behavior when y < 0 or y >= N, where N is the width of T in bits.",N,N],[5,"overflowing_add","","Returns (a + b) mod 2N, where N is the width of T in bits. The stabilized versions of this intrinsic are available on the integer primitives via the `wrapping_add` method. For example, `std::u32::wrapping_add`",N,N],[5,"overflowing_sub","","Returns (a - b) mod 2N, where N is the width of T in bits. The stabilized versions of this intrinsic are available on the integer primitives via the `wrapping_sub` method. For example, `std::u32::wrapping_sub`",N,N],[5,"overflowing_mul","","Returns (a * b) mod 2N, where N is the width of T in bits. The stabilized versions of this intrinsic are available on the integer primitives via the `wrapping_mul` method. For example, `std::u32::wrapping_mul`",N,N],[5,"discriminant_value","","Returns the value of the discriminant for the variant in 'v', cast to a `u64`; if `T` has no discriminant, returns 0.",N,N],[5,"try","","Rust's \"try catch\" construct which invokes the function pointer `f` with the data pointer `data`.",N,N],[5,"nontemporal_store","","Emits a `!nontemporal` store according to LLVM (see their docs). Probably will never become stable.",N,N],[0,"mem","core","Basic functions for dealing with memory.",N,N],[3,"Discriminant","core::mem","Opaque type representing the discriminant of an enum.",N,N],[3,"ManuallyDrop","","A wrapper to inhibit compiler from automatically calling `T`’s destructor.",N,N],[3,"PinMut","","A pinned reference.",N,N],[5,"forget","","Leaks a value: takes ownership and \"forgets\" about the value without running its destructor.",N,[[["t"]]]],[5,"size_of","","Returns the size of a type in bytes.",N,[[],["usize"]]],[5,"size_of_val","","Returns the size of the pointed-to value in bytes.",N,[[["t"]],["usize"]]],[5,"min_align_of","","Returns the [ABI]-required minimum alignment of a type.",N,[[],["usize"]]],[5,"min_align_of_val","","Returns the [ABI]-required minimum alignment of the type of the value that `val` points to.",N,[[["t"]],["usize"]]],[5,"align_of","","Returns the [ABI]-required minimum alignment of a type.",N,[[],["usize"]]],[5,"align_of_val","","Returns the [ABI]-required minimum alignment of the type of the value that `val` points to.",N,[[["t"]],["usize"]]],[5,"needs_drop","","Returns whether dropping values of type `T` matters.",N,[[],["bool"]]],[5,"zeroed","","Creates a value whose bytes are all zero.",N,[[],["t"]]],[5,"uninitialized","","Bypasses Rust's normal memory-initialization checks by pretending to produce a value of type `T`, while doing nothing at all.",N,[[],["t"]]],[5,"swap","","Swaps the values at two mutable locations, without deinitializing either one.",N,[[["t"],["t"]]]],[5,"replace","","Moves `src` into the referenced `dest`, returning the previous `dest` value.",N,[[["t"],["t"]],["t"]]],[5,"drop","","Disposes of a value.",N,[[["t"]]]],[5,"transmute_copy","","Interprets `src` as having type `&U`, and then reads `src` without moving the contained value.",N,[[["t"]],["u"]]],[5,"discriminant","","Returns a value uniquely identifying the enum variant in `v`.",N,[[["t"]],["discriminant"]]],[11,"clone","","",11,[[["self"]],["self"]]],[11,"eq","","",11,[[["self"],["self"]],["bool"]]],[11,"hash","","",11,[[["self"],["h"]]]],[11,"fmt","","",11,[[["self"],["formatter"]],["result"]]],[11,"clone","","",12,[[["self"]],["manuallydrop"]]],[11,"fmt","","",12,[[["self"],["formatter"]],["result"]]],[11,"default","","",12,[[],["manuallydrop"]]],[11,"eq","","",12,[[["self"],["manuallydrop"]],["bool"]]],[11,"ne","","",12,[[["self"],["manuallydrop"]],["bool"]]],[11,"partial_cmp","","",12,[[["self"],["manuallydrop"]],["option",["ordering"]]]],[11,"lt","","",12,[[["self"],["manuallydrop"]],["bool"]]],[11,"le","","",12,[[["self"],["manuallydrop"]],["bool"]]],[11,"gt","","",12,[[["self"],["manuallydrop"]],["bool"]]],[11,"ge","","",12,[[["self"],["manuallydrop"]],["bool"]]],[11,"cmp","","",12,[[["self"],["manuallydrop"]],["ordering"]]],[11,"hash","","",12,N],[11,"new","","Wrap a value to be manually dropped.",12,[[["t"]],["manuallydrop"]]],[11,"into_inner","","Extract the value from the ManuallyDrop container.",12,[[["manuallydrop"]],["t"]]],[11,"drop","","Manually drops the contained value.",12,[[["manuallydrop"]]]],[11,"deref","","",12,N],[11,"deref_mut","","",12,N],[11,"new","","Construct a new `PinMut` around a reference to some data of a type that implements `Unpin`.",13,[[["t"]],["pinmut"]]],[11,"get_mut","","Get a mutable reference to the data inside of this `PinMut`.",13,[[["pinmut"]],["t"]]],[11,"new_unchecked","","Construct a new `PinMut` around a reference to some data of a type that may or may not implement `Unpin`.",13,[[["t"]],["pinmut"]]],[11,"reborrow","","Reborrow a `PinMut` for a shorter lifetime.",13,[[["self"]],["pinmut"]]],[11,"get_mut_unchecked","","Get a mutable reference to the data inside of this `PinMut`.",13,[[["pinmut"]],["t"]]],[11,"map_unchecked","","Construct a new pin by mapping the interior value.",13,[[["pinmut"],["f"]],["pinmut"]]],[11,"set","","Assign a new value to the memory behind the pinned reference.",13,[[["pinmut"],["t"]]]],[11,"deref","","",13,[[["self"]],["t"]]],[11,"deref_mut","","",13,[[["self"]],["t"]]],[11,"fmt","","",13,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",13,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",13,[[["self"],["formatter"]],["result"]]],[11,"into_raw","","",13,N],[11,"poll","","",13,N],[11,"drop","","",13,N],[0,"ptr","core","Raw, unsafe pointers, `*const T`, and `*mut T`.",N,N],[3,"NonNull","core::ptr","`*mut T` but non-zero and covariant.",N,N],[5,"drop_in_place","","Executes the destructor (if any) of the pointed-to value.",N,N],[5,"null","","Creates a null raw pointer.",N,N],[5,"null_mut","","Creates a null mutable raw pointer.",N,N],[5,"swap","","Swaps the values at two mutable locations of the same type, without deinitializing either.",N,N],[5,"swap_nonoverlapping","","Swaps a sequence of values at two mutable locations of the same type.",N,N],[5,"replace","","Moves `src` into the pointed `dest`, returning the previous `dest` value.",N,N],[5,"read","","Reads the value from `src` without moving it. This leaves the memory in `src` unchanged.",N,N],[5,"read_unaligned","","Reads the value from `src` without moving it. This leaves the memory in `src` unchanged.",N,N],[5,"write","","Overwrites a memory location with the given value without reading or dropping the old value.",N,N],[5,"write_unaligned","","Overwrites a memory location with the given value without reading or dropping the old value.",N,N],[5,"read_volatile","","Performs a volatile read of the value from `src` without moving it. This leaves the memory in `src` unchanged.",N,N],[5,"write_volatile","","Performs a volatile write of a memory location with the given value without reading or dropping the old value.",N,N],[5,"eq","","Compare raw pointers for equality.",N,N],[11,"dangling","","Creates a new `NonNull` that is dangling, but well-aligned.",14,[[],["self"]]],[11,"new_unchecked","","Creates a new `NonNull`.",14,N],[11,"new","","Creates a new `NonNull` if `ptr` is non-null.",14,N],[11,"as_ptr","","Acquires the underlying `*mut` pointer.",14,N],[11,"as_ref","","Dereferences the content.",14,[[["self"]],["t"]]],[11,"as_mut","","Mutably dereferences the content.",14,[[["self"]],["t"]]],[11,"cast","","Cast to a pointer of another type",14,[[["self"]],["nonnull"]]],[11,"clone","","",14,[[["self"]],["self"]]],[11,"fmt","","",14,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",14,[[["self"],["formatter"]],["result"]]],[11,"eq","","",14,[[["self"],["self"]],["bool"]]],[11,"cmp","","",14,[[["self"],["self"]],["ordering"]]],[11,"partial_cmp","","",14,[[["self"],["self"]],["option",["ordering"]]]],[11,"hash","","",14,[[["self"],["h"]]]],[11,"from","","",14,[[["t"]],["self"]]],[11,"from","","",14,[[["t"]],["self"]]],[0,"hint","core","Hints to compiler that affects how code should be emitted or optimized.",N,N],[5,"unreachable_unchecked","core::hint","Informs the compiler that this point in the code is not reachable, enabling further optimizations.",N,N],[0,"marker","core","Primitive traits and types representing basic properties of types.",N,N],[3,"PhantomData","core::marker","Zero-sized type used to mark things that \"act like\" they own a `T`.",N,N],[3,"Pinned","","A type which does not implement `Unpin`.",N,N],[8,"Send","","Types that can be transferred across thread boundaries.",N,N],[8,"Sized","","Types with a constant size known at compile time.",N,N],[8,"Unsize","","Types that can be \"unsized\" to a dynamically-sized type.",N,N],[8,"Copy","","Types whose values can be duplicated simply by copying bits.",N,N],[8,"Sync","","Types for which it is safe to share references between threads.",N,N],[8,"Unpin","","Types which can be moved out of a `PinMut`.",N,N],[11,"hash","","",15,[[["self"],["h"]]]],[11,"eq","","",15,[[["self"],["phantomdata"]],["bool"]]],[11,"partial_cmp","","",15,[[["self"],["phantomdata"]],["option",["ordering"]]]],[11,"cmp","","",15,[[["self"],["phantomdata"]],["ordering"]]],[11,"clone","","",15,[[["self"]],["phantomdata"]]],[11,"default","","",15,[[],["phantomdata"]]],[11,"fmt","","",16,[[["self"],["formatter"]],["result"]]],[11,"clone","","",16,[[["self"]],["pinned"]]],[11,"eq","","",16,[[["self"],["pinned"]],["bool"]]],[11,"cmp","","",16,[[["self"],["pinned"]],["ordering"]]],[11,"partial_cmp","","",16,[[["self"],["pinned"]],["option",["ordering"]]]],[11,"hash","","",16,N],[0,"ops","core","Overloadable operators.",N,N],[3,"Range","core::ops","A (half-open) range bounded inclusively below and exclusively above (`start..end`).",N,N],[12,"start","","The lower bound of the range (inclusive).",17,N],[12,"end","","The upper bound of the range (exclusive).",17,N],[3,"RangeFrom","","A range only bounded inclusively below (`start..`).",N,N],[12,"start","","The lower bound of the range (inclusive).",18,N],[3,"RangeFull","","An unbounded range (`..`).",N,N],[3,"RangeTo","","A range only bounded exclusively above (`..end`).",N,N],[12,"end","","The upper bound of the range (exclusive).",19,N],[3,"RangeInclusive","","An range bounded inclusively below and above (`start..=end`).",N,N],[3,"RangeToInclusive","","A range only bounded inclusively above (`..=end`).",N,N],[12,"end","","The upper bound of the range (inclusive)",20,N],[4,"Bound","","An endpoint of a range of keys.",N,N],[13,"Included","","An inclusive bound.",21,N],[13,"Excluded","","An exclusive bound.",21,N],[13,"Unbounded","","An infinite endpoint. Indicates that there is no bound in this direction.",21,N],[4,"GeneratorState","","The result of a generator resumption.",N,N],[13,"Yielded","","The generator suspended with a value.",22,N],[13,"Complete","","The generator completed with a return value.",22,N],[11,"clone","","",22,[[["self"]],["generatorstate"]]],[11,"eq","","",22,[[["self"],["generatorstate"]],["bool"]]],[11,"ne","","",22,[[["self"],["generatorstate"]],["bool"]]],[11,"partial_cmp","","",22,[[["self"],["generatorstate"]],["option",["ordering"]]]],[11,"lt","","",22,[[["self"],["generatorstate"]],["bool"]]],[11,"le","","",22,[[["self"],["generatorstate"]],["bool"]]],[11,"gt","","",22,[[["self"],["generatorstate"]],["bool"]]],[11,"ge","","",22,[[["self"],["generatorstate"]],["bool"]]],[11,"cmp","","",22,[[["self"],["generatorstate"]],["ordering"]]],[11,"fmt","","",22,[[["self"],["formatter"]],["result"]]],[11,"hash","","",22,N],[11,"clone","","",23,[[["self"]],["rangefull"]]],[11,"eq","","",23,[[["self"],["rangefull"]],["bool"]]],[11,"hash","","",23,N],[11,"fmt","","",23,[[["self"],["formatter"]],["result"]]],[11,"clone","","",17,[[["self"]],["range"]]],[11,"eq","","",17,[[["self"],["range"]],["bool"]]],[11,"ne","","",17,[[["self"],["range"]],["bool"]]],[11,"hash","","",17,N],[11,"fmt","","",17,[[["self"],["formatter"]],["result"]]],[11,"contains","","Returns `true` if `item` is contained in the range.",17,[[["self"],["u"]],["bool"]]],[11,"is_empty","","Returns `true` if the range contains no items.",17,[[["self"]],["bool"]]],[11,"clone","","",18,[[["self"]],["rangefrom"]]],[11,"eq","","",18,[[["self"],["rangefrom"]],["bool"]]],[11,"ne","","",18,[[["self"],["rangefrom"]],["bool"]]],[11,"hash","","",18,N],[11,"fmt","","",18,[[["self"],["formatter"]],["result"]]],[11,"contains","","Returns `true` if `item` is contained in the range.",18,[[["self"],["u"]],["bool"]]],[11,"clone","","",19,[[["self"]],["rangeto"]]],[11,"eq","","",19,[[["self"],["rangeto"]],["bool"]]],[11,"ne","","",19,[[["self"],["rangeto"]],["bool"]]],[11,"hash","","",19,N],[11,"fmt","","",19,[[["self"],["formatter"]],["result"]]],[11,"contains","","Returns `true` if `item` is contained in the range.",19,[[["self"],["u"]],["bool"]]],[11,"clone","","",24,[[["self"]],["rangeinclusive"]]],[11,"eq","","",24,[[["self"],["self"]],["bool"]]],[11,"hash","","",24,[[["self"],["h"]]]],[11,"new","","Creates a new inclusive range. Equivalent to writing `start..=end`.",24,[[["idx"],["idx"]],["self"]]],[11,"start","","Returns the lower bound of the range (inclusive).",24,[[["self"]],["idx"]]],[11,"end","","Returns the upper bound of the range (inclusive).",24,[[["self"]],["idx"]]],[11,"into_inner","","Destructures the `RangeInclusive` into (lower bound, upper (inclusive) bound).",24,N],[11,"fmt","","",24,[[["self"],["formatter"]],["result"]]],[11,"contains","","Returns `true` if `item` is contained in the range.",24,[[["self"],["u"]],["bool"]]],[11,"is_empty","","Returns `true` if the range contains no items.",24,[[["self"]],["bool"]]],[11,"clone","","",20,[[["self"]],["rangetoinclusive"]]],[11,"eq","","",20,[[["self"],["rangetoinclusive"]],["bool"]]],[11,"ne","","",20,[[["self"],["rangetoinclusive"]],["bool"]]],[11,"hash","","",20,N],[11,"fmt","","",20,[[["self"],["formatter"]],["result"]]],[11,"contains","","Returns `true` if `item` is contained in the range.",20,[[["self"],["u"]],["bool"]]],[11,"clone","","",21,[[["self"]],["bound"]]],[11,"fmt","","",21,[[["self"],["formatter"]],["result"]]],[11,"hash","","",21,N],[11,"eq","","",21,[[["self"],["bound"]],["bool"]]],[11,"ne","","",21,[[["self"],["bound"]],["bool"]]],[11,"start_bound","","",23,[[["self"]],["bound"]]],[11,"end_bound","","",23,[[["self"]],["bound"]]],[11,"start_bound","","",18,[[["self"]],["bound"]]],[11,"end_bound","","",18,[[["self"]],["bound"]]],[11,"start_bound","","",19,[[["self"]],["bound"]]],[11,"end_bound","","",19,[[["self"]],["bound"]]],[11,"start_bound","","",17,[[["self"]],["bound"]]],[11,"end_bound","","",17,[[["self"]],["bound"]]],[11,"start_bound","","",24,[[["self"]],["bound"]]],[11,"end_bound","","",24,[[["self"]],["bound"]]],[11,"start_bound","","",20,[[["self"]],["bound"]]],[11,"end_bound","","",20,[[["self"]],["bound"]]],[11,"start_bound","","",18,[[["self"]],["bound"]]],[11,"end_bound","","",18,[[["self"]],["bound"]]],[11,"start_bound","","",19,[[["self"]],["bound"]]],[11,"end_bound","","",19,[[["self"]],["bound"]]],[11,"start_bound","","",17,[[["self"]],["bound"]]],[11,"end_bound","","",17,[[["self"]],["bound"]]],[11,"start_bound","","",24,[[["self"]],["bound"]]],[11,"end_bound","","",24,[[["self"]],["bound"]]],[11,"start_bound","","",20,[[["self"]],["bound"]]],[11,"end_bound","","",20,[[["self"]],["bound"]]],[8,"Add","","The addition operator `+`.",N,N],[16,"Output","","The resulting type after applying the `+` operator.",25,N],[10,"add","","Performs the `+` operation.",25,N],[8,"Sub","","The subtraction operator `-`.",N,N],[16,"Output","","The resulting type after applying the `-` operator.",26,N],[10,"sub","","Performs the `-` operation.",26,N],[8,"Mul","","The multiplication operator `*`.",N,N],[16,"Output","","The resulting type after applying the `*` operator.",27,N],[10,"mul","","Performs the `*` operation.",27,N],[8,"Div","","The division operator `/`.",N,N],[16,"Output","","The resulting type after applying the `/` operator.",28,N],[10,"div","","Performs the `/` operation.",28,N],[8,"Rem","","The remainder operator `%`.",N,N],[16,"Output","","The resulting type after applying the `%` operator.",29,N],[10,"rem","","Performs the `%` operation.",29,N],[8,"Neg","","The unary negation operator `-`.",N,N],[16,"Output","","The resulting type after applying the `-` operator.",30,N],[10,"neg","","Performs the unary `-` operation.",30,N],[8,"AddAssign","","The addition assignment operator `+=`.",N,N],[10,"add_assign","","Performs the `+=` operation.",31,[[["self"],["rhs"]]]],[8,"SubAssign","","The subtraction assignment operator `-=`.",N,N],[10,"sub_assign","","Performs the `-=` operation.",32,[[["self"],["rhs"]]]],[8,"MulAssign","","The multiplication assignment operator `*=`.",N,N],[10,"mul_assign","","Performs the `*=` operation.",33,[[["self"],["rhs"]]]],[8,"DivAssign","","The division assignment operator `/=`.",N,N],[10,"div_assign","","Performs the `/=` operation.",34,[[["self"],["rhs"]]]],[8,"RemAssign","","The remainder assignment operator `%=`.",N,N],[10,"rem_assign","","Performs the `%=` operation.",35,[[["self"],["rhs"]]]],[8,"Not","","The unary logical negation operator `!`.",N,N],[16,"Output","","The resulting type after applying the `!` operator.",36,N],[10,"not","","Performs the unary `!` operation.",36,N],[8,"BitAnd","","The bitwise AND operator `&`.",N,N],[16,"Output","","The resulting type after applying the `&` operator.",37,N],[10,"bitand","","Performs the `&` operation.",37,N],[8,"BitOr","","The bitwise OR operator `|`.",N,N],[16,"Output","","The resulting type after applying the `|` operator.",38,N],[10,"bitor","","Performs the `|` operation.",38,N],[8,"BitXor","","The bitwise XOR operator `^`.",N,N],[16,"Output","","The resulting type after applying the `^` operator.",39,N],[10,"bitxor","","Performs the `^` operation.",39,N],[8,"Shl","","The left shift operator `<<`. Note that because this trait is implemented for all integer types with multiple right-hand-side types, Rust's type checker has special handling for `_ << _`, setting the result type for integer operations to the type of the left-hand-side operand. This means that though `a << b` and `a.shl(b)` are one and the same from an evaluation standpoint, they are different when it comes to type inference.",N,N],[16,"Output","","The resulting type after applying the `<<` operator.",40,N],[10,"shl","","Performs the `<<` operation.",40,N],[8,"Shr","","The right shift operator `>>`. Note that because this trait is implemented for all integer types with multiple right-hand-side types, Rust's type checker has special handling for `_ >> _`, setting the result type for integer operations to the type of the left-hand-side operand. This means that though `a >> b` and `a.shr(b)` are one and the same from an evaluation standpoint, they are different when it comes to type inference.",N,N],[16,"Output","","The resulting type after applying the `>>` operator.",41,N],[10,"shr","","Performs the `>>` operation.",41,N],[8,"BitAndAssign","","The bitwise AND assignment operator `&=`.",N,N],[10,"bitand_assign","","Performs the `&=` operation.",42,[[["self"],["rhs"]]]],[8,"BitOrAssign","","The bitwise OR assignment operator `|=`.",N,N],[10,"bitor_assign","","Performs the `|=` operation.",43,[[["self"],["rhs"]]]],[8,"BitXorAssign","","The bitwise XOR assignment operator `^=`.",N,N],[10,"bitxor_assign","","Performs the `^=` operation.",44,[[["self"],["rhs"]]]],[8,"ShlAssign","","The left shift assignment operator `<<=`.",N,N],[10,"shl_assign","","Performs the `<<=` operation.",45,[[["self"],["rhs"]]]],[8,"ShrAssign","","The right shift assignment operator `>>=`.",N,N],[10,"shr_assign","","Performs the `>>=` operation.",46,[[["self"],["rhs"]]]],[8,"Deref","","Used for immutable dereferencing operations, like `*v`.",N,N],[16,"Target","","The resulting type after dereferencing.",47,N],[10,"deref","","Dereferences the value.",47,N],[8,"DerefMut","","Used for mutable dereferencing operations, like in `*v = 1;`.",N,N],[10,"deref_mut","","Mutably dereferences the value.",48,N],[8,"Drop","","Used to run some code when a value goes out of scope. This is sometimes called a 'destructor'.",N,N],[10,"drop","","Executes the destructor for this type.",49,[[["self"]]]],[8,"Fn","","The version of the call operator that takes an immutable receiver.",N,N],[10,"call","","Performs the call operation.",50,N],[8,"FnMut","","The version of the call operator that takes a mutable receiver.",N,N],[10,"call_mut","","Performs the call operation.",51,N],[8,"FnOnce","","The version of the call operator that takes a by-value receiver.",N,N],[16,"Output","","The returned type after the call operator is used.",52,N],[10,"call_once","","Performs the call operation.",52,N],[8,"Index","","Used for indexing operations (`container[index]`) in immutable contexts.",N,N],[16,"Output","","The returned type after indexing.",53,N],[10,"index","","Performs the indexing (`container[index]`) operation.",53,N],[8,"IndexMut","","Used for indexing operations (`container[index]`) in mutable contexts.",N,N],[10,"index_mut","","Performs the mutable indexing (`container[index]`) operation.",54,N],[8,"RangeBounds","","`RangeBounds` is implemented by Rust's built-in range types, produced by range syntax like `..`, `a..`, `..b` or `c..d`.",N,N],[10,"start_bound","","Start index bound.",55,[[["self"]],["bound"]]],[10,"end_bound","","End index bound.",55,[[["self"]],["bound"]]],[11,"contains","","Returns `true` if `item` is contained in the range.",55,[[["self"],["u"]],["bool"]]],[8,"Try","","A trait for customizing the behavior of the `?` operator.",N,N],[16,"Ok","","The type of this value when viewed as successful.",56,N],[16,"Error","","The type of this value when viewed as failed.",56,N],[10,"into_result","","Applies the \"?\" operator. A return of `Ok(t)` means that the execution should continue normally, and the result of `?` is the value `t`. A return of `Err(e)` means that execution should branch to the innermost enclosing `catch`, or return from the function.",56,[[["self"]],["result"]]],[10,"from_error","","Wrap an error value to construct the composite result. For example, `Result::Err(x)` and `Result::from_error(x)` are equivalent.",56,N],[10,"from_ok","","Wrap an OK value to construct the composite result. For example, `Result::Ok(x)` and `Result::from_ok(x)` are equivalent.",56,N],[8,"Generator","","The trait implemented by builtin generator types.",N,N],[16,"Yield","","The type of value this generator yields.",57,N],[16,"Return","","The type of value this generator returns.",57,N],[10,"resume","","Resumes the execution of this generator.",57,[[["self"]],["generatorstate"]]],[8,"CoerceUnsized","","Trait that indicates that this is a pointer or a wrapper for one, where unsizing can be performed on the pointee.",N,N],[0,"cmp","core","Functionality for ordering and comparison.",N,N],[3,"Reverse","core::cmp","A helper struct for reverse ordering.",N,N],[12,"0","","",58,N],[4,"Ordering","","An `Ordering` is the result of a comparison between two values.",N,N],[13,"Less","","An ordering where a compared value is less [than another].",59,N],[13,"Equal","","An ordering where a compared value is equal [to another].",59,N],[13,"Greater","","An ordering where a compared value is greater [than another].",59,N],[5,"min","","Compares and returns the minimum of two values.",N,[[["t"],["t"]],["t"]]],[5,"max","","Compares and returns the maximum of two values.",N,[[["t"],["t"]],["t"]]],[8,"PartialEq","","Trait for equality comparisons which are partial equivalence relations.",N,N],[10,"eq","","This method tests for `self` and `other` values to be equal, and is used by `==`.",60,[[["self"],["rhs"]],["bool"]]],[11,"ne","","This method tests for `!=`.",60,[[["self"],["rhs"]],["bool"]]],[8,"Eq","","Trait for equality comparisons which are equivalence relations.",N,N],[8,"Ord","","Trait for types that form a total order.",N,N],[10,"cmp","","This method returns an `Ordering` between `self` and `other`.",61,[[["self"],["self"]],["ordering"]]],[11,"max","","Compares and returns the maximum of two values.",61,[[["self"],["self"]],["self"]]],[11,"min","","Compares and returns the minimum of two values.",61,[[["self"],["self"]],["self"]]],[8,"PartialOrd","","Trait for values that can be compared for a sort-order.",N,N],[10,"partial_cmp","","This method returns an ordering between `self` and `other` values if one exists.",62,[[["self"],["rhs"]],["option",["ordering"]]]],[11,"lt","","This method tests less than (for `self` and `other`) and is used by the `<` operator.",62,[[["self"],["rhs"]],["bool"]]],[11,"le","","This method tests less than or equal to (for `self` and `other`) and is used by the `<=` operator.",62,[[["self"],["rhs"]],["bool"]]],[11,"gt","","This method tests greater than (for `self` and `other`) and is used by the `>` operator.",62,[[["self"],["rhs"]],["bool"]]],[11,"ge","","This method tests greater than or equal to (for `self` and `other`) and is used by the `>=` operator.",62,[[["self"],["rhs"]],["bool"]]],[11,"clone","","",59,[[["self"]],["ordering"]]],[11,"eq","","",59,[[["self"],["ordering"]],["bool"]]],[11,"fmt","","",59,[[["self"],["formatter"]],["result"]]],[11,"hash","","",59,N],[11,"reverse","","Reverses the `Ordering`.",59,[[["self"]],["ordering"]]],[11,"then","","Chains two orderings.",59,[[["self"],["ordering"]],["ordering"]]],[11,"then_with","","Chains the ordering with the given function.",59,[[["self"],["f"]],["ordering"]]],[11,"eq","","",58,[[["self"],["reverse"]],["bool"]]],[11,"ne","","",58,[[["self"],["reverse"]],["bool"]]],[11,"fmt","","",58,[[["self"],["formatter"]],["result"]]],[11,"clone","","",58,[[["self"]],["reverse"]]],[11,"default","","",58,[[],["reverse"]]],[11,"hash","","",58,N],[11,"partial_cmp","","",58,[[["self"],["reverse"]],["option",["ordering"]]]],[11,"lt","","",58,[[["self"],["self"]],["bool"]]],[11,"le","","",58,[[["self"],["self"]],["bool"]]],[11,"ge","","",58,[[["self"],["self"]],["bool"]]],[11,"gt","","",58,[[["self"],["self"]],["bool"]]],[11,"cmp","","",58,[[["self"],["reverse"]],["ordering"]]],[11,"cmp","","",59,[[["self"],["ordering"]],["ordering"]]],[11,"partial_cmp","","",59,[[["self"],["ordering"]],["option",["ordering"]]]],[0,"clone","core","The `Clone` trait for types that cannot be 'implicitly copied'.",N,N],[8,"Clone","core::clone","A common trait for the ability to explicitly duplicate an object.",N,N],[10,"clone","","Returns a copy of the value.",63,[[["self"]],["self"]]],[11,"clone_from","","Performs copy-assignment from `source`.",63,[[["self"],["self"]]]],[0,"default","core","The `Default` trait for types which may have meaningful default values.",N,N],[8,"Default","core::default","A trait for giving a type a useful default value.",N,N],[10,"default","","Returns the \"default value\" for a type.",64,[[],["self"]]],[0,"convert","core","Traits for conversions between types.",N,N],[8,"AsRef","core::convert","A cheap reference-to-reference conversion. Used to convert a value to a reference value within generic code.",N,N],[10,"as_ref","","Performs the conversion.",65,[[["self"]],["t"]]],[8,"AsMut","","A cheap, mutable reference-to-mutable reference conversion.",N,N],[10,"as_mut","","Performs the conversion.",66,[[["self"]],["t"]]],[8,"Into","","A conversion that consumes `self`, which may or may not be expensive. The reciprocal of [`From`][From].",N,N],[10,"into","","Performs the conversion.",67,[[["self"]],["t"]]],[8,"From","","Simple and safe type conversions in to `Self`. It is the reciprocal of `Into`.",N,N],[10,"from","","Performs the conversion.",68,[[["t"]],["self"]]],[8,"TryInto","","An attempted conversion that consumes `self`, which may or may not be expensive.",N,N],[16,"Error","","The type returned in the event of a conversion error.",69,N],[10,"try_into","","Performs the conversion.",69,[[["self"]],["result"]]],[8,"TryFrom","","Attempt to construct `Self` via a conversion.",N,N],[16,"Error","","The type returned in the event of a conversion error.",70,N],[10,"try_from","","Performs the conversion.",70,[[["t"]],["result"]]],[0,"borrow","core","A module for working with borrowed data.",N,N],[8,"Borrow","core::borrow","A trait for borrowing data.",N,N],[10,"borrow","","Immutably borrows from an owned value.",71,[[["self"]],["borrowed"]]],[8,"BorrowMut","","A trait for mutably borrowing data.",N,N],[10,"borrow_mut","","Mutably borrows from an owned value.",72,[[["self"]],["borrowed"]]],[0,"any","core","This module implements the `Any` trait, which enables dynamic typing of any `'static` type through runtime reflection.",N,N],[3,"TypeId","core::any","A `TypeId` represents a globally unique identifier for a type.",N,N],[8,"Any","","A type to emulate dynamic typing.",N,N],[10,"get_type_id","","Gets the `TypeId` of `self`.",73,[[["self"]],["typeid"]]],[11,"fmt","","",73,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",73,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",73,[[["self"],["formatter"]],["result"]]],[11,"is","","Returns `true` if the boxed type is the same as `T`.",73,[[["self"]],["bool"]]],[11,"downcast_ref","","Returns some reference to the boxed value if it is of type `T`, or `None` if it isn't.",73,[[["self"]],["option"]]],[11,"downcast_mut","","Returns some mutable reference to the boxed value if it is of type `T`, or `None` if it isn't.",73,[[["self"]],["option"]]],[11,"is","","Forwards to the method defined on the type `Any`.",73,[[["self"]],["bool"]]],[11,"downcast_ref","","Forwards to the method defined on the type `Any`.",73,[[["self"]],["option"]]],[11,"downcast_mut","","Forwards to the method defined on the type `Any`.",73,[[["self"]],["option"]]],[11,"is","","Forwards to the method defined on the type `Any`.",73,[[["self"]],["bool"]]],[11,"downcast_ref","","Forwards to the method defined on the type `Any`.",73,[[["self"]],["option"]]],[11,"downcast_mut","","Forwards to the method defined on the type `Any`.",73,[[["self"]],["option"]]],[11,"clone","","",74,[[["self"]],["typeid"]]],[11,"eq","","",74,[[["self"],["typeid"]],["bool"]]],[11,"ne","","",74,[[["self"],["typeid"]],["bool"]]],[11,"partial_cmp","","",74,[[["self"],["typeid"]],["option",["ordering"]]]],[11,"lt","","",74,[[["self"],["typeid"]],["bool"]]],[11,"le","","",74,[[["self"],["typeid"]],["bool"]]],[11,"gt","","",74,[[["self"],["typeid"]],["bool"]]],[11,"ge","","",74,[[["self"],["typeid"]],["bool"]]],[11,"cmp","","",74,[[["self"],["typeid"]],["ordering"]]],[11,"fmt","","",74,[[["self"],["formatter"]],["result"]]],[11,"hash","","",74,N],[11,"of","","Returns the `TypeId` of the type this generic function has been instantiated with.",74,[[],["typeid"]]],[0,"array","core","Implementations of things like `Eq` for fixed-length arrays up to a certain length. Eventually we should able to generalize to all lengths.",N,N],[3,"TryFromSliceError","core::array","The error type returned when a conversion from a slice to an array fails.",N,N],[8,"FixedSizeArray","","Utility trait implemented only on arrays of fixed size",N,N],[10,"as_slice","","Converts the array to immutable slice",75,N],[10,"as_mut_slice","","Converts the array to mutable slice",75,N],[11,"fmt","","",76,[[["self"],["formatter"]],["result"]]],[11,"clone","","",76,[[["self"]],["tryfromsliceerror"]]],[11,"fmt","","",76,[[["self"],["formatter"]],["result"]]],[0,"ascii","core","Operations on ASCII strings and characters.",N,N],[3,"EscapeDefault","core::ascii","An iterator over the escaped version of a byte.",N,N],[5,"escape_default","","Returns an iterator that produces an escaped version of a `u8`.",N,[[["u8"]],["escapedefault"]]],[11,"next","","",77,[[["self"]],["option",["u8"]]]],[11,"size_hint","","",77,N],[11,"next_back","","",77,[[["self"]],["option",["u8"]]]],[11,"fmt","","",77,[[["self"],["formatter"]],["result"]]],[0,"sync","core","Synchronization primitives",N,N],[0,"atomic","core::sync","Atomic types",N,N],[3,"AtomicBool","core::sync::atomic","A boolean type which can be safely shared between threads.",N,N],[3,"AtomicPtr","","A raw pointer type which can be safely shared between threads.",N,N],[3,"AtomicI8","","An integer type which can be safely shared between threads.",N,N],[3,"AtomicU8","","An integer type which can be safely shared between threads.",N,N],[3,"AtomicI16","","An integer type which can be safely shared between threads.",N,N],[3,"AtomicU16","","An integer type which can be safely shared between threads.",N,N],[3,"AtomicI32","","An integer type which can be safely shared between threads.",N,N],[3,"AtomicU32","","An integer type which can be safely shared between threads.",N,N],[3,"AtomicI64","","An integer type which can be safely shared between threads.",N,N],[3,"AtomicU64","","An integer type which can be safely shared between threads.",N,N],[3,"AtomicIsize","","An integer type which can be safely shared between threads.",N,N],[3,"AtomicUsize","","An integer type which can be safely shared between threads.",N,N],[4,"Ordering","","Atomic memory orderings",N,N],[13,"Relaxed","","No ordering constraints, only atomic operations.",78,N],[13,"Release","","When coupled with a store, all previous writes become visible to the other threads that perform a load with [`Acquire`] ordering on the same value.",78,N],[13,"Acquire","","When coupled with a load, all subsequent loads will see data written before a store with [`Release`] ordering on the same value in other threads.",78,N],[13,"AcqRel","","Has the effects of both [`Acquire`] and [`Release`] together.",78,N],[13,"SeqCst","","Like `AcqRel` with the additional guarantee that all threads see all sequentially consistent operations in the same order.",78,N],[5,"spin_loop_hint","","Save power or switch hyperthreads in a busy-wait spin-loop.",N,[[]]],[5,"fence","","An atomic fence.",N,[[["ordering"]]]],[5,"compiler_fence","","A compiler memory fence.",N,[[["ordering"]]]],[17,"ATOMIC_BOOL_INIT","","An [`AtomicBool`] initialized to `false`.",N,N],[17,"ATOMIC_I8_INIT","","An atomic integer initialized to `0`.",N,N],[17,"ATOMIC_U8_INIT","","An atomic integer initialized to `0`.",N,N],[17,"ATOMIC_I16_INIT","","An atomic integer initialized to `0`.",N,N],[17,"ATOMIC_U16_INIT","","An atomic integer initialized to `0`.",N,N],[17,"ATOMIC_I32_INIT","","An atomic integer initialized to `0`.",N,N],[17,"ATOMIC_U32_INIT","","An atomic integer initialized to `0`.",N,N],[17,"ATOMIC_I64_INIT","","An atomic integer initialized to `0`.",N,N],[17,"ATOMIC_U64_INIT","","An atomic integer initialized to `0`.",N,N],[17,"ATOMIC_ISIZE_INIT","","An atomic integer initialized to `0`.",N,N],[17,"ATOMIC_USIZE_INIT","","An atomic integer initialized to `0`.",N,N],[11,"default","","Creates an `AtomicBool` initialized to `false`.",79,[[],["self"]]],[11,"default","","Creates a null `AtomicPtr<T>`.",80,[[],["atomicptr"]]],[11,"clone","","",78,[[["self"]],["ordering"]]],[11,"fmt","","",78,[[["self"],["formatter"]],["result"]]],[11,"new","","Creates a new `AtomicBool`.",79,[[["bool"]],["atomicbool"]]],[11,"get_mut","","Returns a mutable reference to the underlying [`bool`].",79,[[["self"]],["bool"]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",79,[[["self"]],["bool"]]],[11,"load","","Loads a value from the bool.",79,[[["self"],["ordering"]],["bool"]]],[11,"store","","Stores a value into the bool.",79,[[["self"],["bool"],["ordering"]]]],[11,"swap","","Stores a value into the bool, returning the previous value.",79,[[["self"],["bool"],["ordering"]],["bool"]]],[11,"compare_and_swap","","Stores a value into the [`bool`] if the current value is the same as the `current` value.",79,[[["self"],["bool"],["bool"],["ordering"]],["bool"]]],[11,"compare_exchange","","Stores a value into the [`bool`] if the current value is the same as the `current` value.",79,[[["self"],["bool"],["bool"],["ordering"],["ordering"]],["result",["bool","bool"]]]],[11,"compare_exchange_weak","","Stores a value into the [`bool`] if the current value is the same as the `current` value.",79,[[["self"],["bool"],["bool"],["ordering"],["ordering"]],["result",["bool","bool"]]]],[11,"fetch_and","","Logical \"and\" with a boolean value.",79,[[["self"],["bool"],["ordering"]],["bool"]]],[11,"fetch_nand","","Logical \"nand\" with a boolean value.",79,[[["self"],["bool"],["ordering"]],["bool"]]],[11,"fetch_or","","Logical \"or\" with a boolean value.",79,[[["self"],["bool"],["ordering"]],["bool"]]],[11,"fetch_xor","","Logical \"xor\" with a boolean value.",79,[[["self"],["bool"],["ordering"]],["bool"]]],[11,"new","","Creates a new `AtomicPtr`.",80,N],[11,"get_mut","","Returns a mutable reference to the underlying pointer.",80,N],[11,"into_inner","","Consumes the atomic and returns the contained value.",80,N],[11,"load","","Loads a value from the pointer.",80,N],[11,"store","","Stores a value into the pointer.",80,N],[11,"swap","","Stores a value into the pointer, returning the previous value.",80,N],[11,"compare_and_swap","","Stores a value into the pointer if the current value is the same as the `current` value.",80,N],[11,"compare_exchange","","Stores a value into the pointer if the current value is the same as the `current` value.",80,N],[11,"compare_exchange_weak","","Stores a value into the pointer if the current value is the same as the `current` value.",80,N],[11,"from","","",79,[[["bool"]],["self"]]],[11,"from","","",80,N],[11,"default","","",81,[[],["self"]]],[11,"from","","",81,[[["i8"]],["self"]]],[11,"fmt","","",81,[[["self"],["formatter"]],["result"]]],[11,"new","","Creates a new atomic integer.",81,[[["i8"]],["self"]]],[11,"get_mut","","Returns a mutable reference to the underlying integer.",81,[[["self"]],["i8"]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",81,[[["self"]],["i8"]]],[11,"load","","Loads a value from the atomic integer.",81,[[["self"],["ordering"]],["i8"]]],[11,"store","","Stores a value into the atomic integer.",81,[[["self"],["i8"],["ordering"]]]],[11,"swap","","Stores a value into the atomic integer, returning the previous value.",81,[[["self"],["i8"],["ordering"]],["i8"]]],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",81,[[["self"],["i8"],["i8"],["ordering"]],["i8"]]],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",81,[[["self"],["i8"],["i8"],["ordering"],["ordering"]],["result",["i8","i8"]]]],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",81,[[["self"],["i8"],["i8"],["ordering"],["ordering"]],["result",["i8","i8"]]]],[11,"fetch_add","","Adds to the current value, returning the previous value.",81,[[["self"],["i8"],["ordering"]],["i8"]]],[11,"fetch_sub","","Subtracts from the current value, returning the previous value.",81,[[["self"],["i8"],["ordering"]],["i8"]]],[11,"fetch_and","","Bitwise \"and\" with the current value.",81,[[["self"],["i8"],["ordering"]],["i8"]]],[11,"fetch_nand","","Bitwise \"nand\" with the current value.",81,[[["self"],["i8"],["ordering"]],["i8"]]],[11,"fetch_or","","Bitwise \"or\" with the current value.",81,[[["self"],["i8"],["ordering"]],["i8"]]],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",81,[[["self"],["i8"],["ordering"]],["i8"]]],[11,"fetch_update","","Fetches the value, and applies a function to it that returns an optional new value. Returns a `Result` of `Ok(previous_value)` if the function returned `Some(_)`, else `Err(previous_value)`.",81,[[["self"],["f"],["ordering"],["ordering"]],["result",["i8","i8"]]]],[11,"fetch_max","","Maximum with the current value.",81,[[["self"],["i8"],["ordering"]],["i8"]]],[11,"fetch_min","","Minimum with the current value.",81,[[["self"],["i8"],["ordering"]],["i8"]]],[11,"default","","",82,[[],["self"]]],[11,"from","","",82,[[["u8"]],["self"]]],[11,"fmt","","",82,[[["self"],["formatter"]],["result"]]],[11,"new","","Creates a new atomic integer.",82,[[["u8"]],["self"]]],[11,"get_mut","","Returns a mutable reference to the underlying integer.",82,[[["self"]],["u8"]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",82,[[["self"]],["u8"]]],[11,"load","","Loads a value from the atomic integer.",82,[[["self"],["ordering"]],["u8"]]],[11,"store","","Stores a value into the atomic integer.",82,[[["self"],["u8"],["ordering"]]]],[11,"swap","","Stores a value into the atomic integer, returning the previous value.",82,[[["self"],["u8"],["ordering"]],["u8"]]],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",82,[[["self"],["u8"],["u8"],["ordering"]],["u8"]]],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",82,[[["self"],["u8"],["u8"],["ordering"],["ordering"]],["result",["u8","u8"]]]],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",82,[[["self"],["u8"],["u8"],["ordering"],["ordering"]],["result",["u8","u8"]]]],[11,"fetch_add","","Adds to the current value, returning the previous value.",82,[[["self"],["u8"],["ordering"]],["u8"]]],[11,"fetch_sub","","Subtracts from the current value, returning the previous value.",82,[[["self"],["u8"],["ordering"]],["u8"]]],[11,"fetch_and","","Bitwise \"and\" with the current value.",82,[[["self"],["u8"],["ordering"]],["u8"]]],[11,"fetch_nand","","Bitwise \"nand\" with the current value.",82,[[["self"],["u8"],["ordering"]],["u8"]]],[11,"fetch_or","","Bitwise \"or\" with the current value.",82,[[["self"],["u8"],["ordering"]],["u8"]]],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",82,[[["self"],["u8"],["ordering"]],["u8"]]],[11,"fetch_update","","Fetches the value, and applies a function to it that returns an optional new value. Returns a `Result` of `Ok(previous_value)` if the function returned `Some(_)`, else `Err(previous_value)`.",82,[[["self"],["f"],["ordering"],["ordering"]],["result",["u8","u8"]]]],[11,"fetch_max","","Maximum with the current value.",82,[[["self"],["u8"],["ordering"]],["u8"]]],[11,"fetch_min","","Minimum with the current value.",82,[[["self"],["u8"],["ordering"]],["u8"]]],[11,"default","","",83,[[],["self"]]],[11,"from","","",83,[[["i16"]],["self"]]],[11,"fmt","","",83,[[["self"],["formatter"]],["result"]]],[11,"new","","Creates a new atomic integer.",83,[[["i16"]],["self"]]],[11,"get_mut","","Returns a mutable reference to the underlying integer.",83,[[["self"]],["i16"]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",83,[[["self"]],["i16"]]],[11,"load","","Loads a value from the atomic integer.",83,[[["self"],["ordering"]],["i16"]]],[11,"store","","Stores a value into the atomic integer.",83,[[["self"],["i16"],["ordering"]]]],[11,"swap","","Stores a value into the atomic integer, returning the previous value.",83,[[["self"],["i16"],["ordering"]],["i16"]]],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",83,[[["self"],["i16"],["i16"],["ordering"]],["i16"]]],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",83,[[["self"],["i16"],["i16"],["ordering"],["ordering"]],["result",["i16","i16"]]]],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",83,[[["self"],["i16"],["i16"],["ordering"],["ordering"]],["result",["i16","i16"]]]],[11,"fetch_add","","Adds to the current value, returning the previous value.",83,[[["self"],["i16"],["ordering"]],["i16"]]],[11,"fetch_sub","","Subtracts from the current value, returning the previous value.",83,[[["self"],["i16"],["ordering"]],["i16"]]],[11,"fetch_and","","Bitwise \"and\" with the current value.",83,[[["self"],["i16"],["ordering"]],["i16"]]],[11,"fetch_nand","","Bitwise \"nand\" with the current value.",83,[[["self"],["i16"],["ordering"]],["i16"]]],[11,"fetch_or","","Bitwise \"or\" with the current value.",83,[[["self"],["i16"],["ordering"]],["i16"]]],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",83,[[["self"],["i16"],["ordering"]],["i16"]]],[11,"fetch_update","","Fetches the value, and applies a function to it that returns an optional new value. Returns a `Result` of `Ok(previous_value)` if the function returned `Some(_)`, else `Err(previous_value)`.",83,[[["self"],["f"],["ordering"],["ordering"]],["result",["i16","i16"]]]],[11,"fetch_max","","Maximum with the current value.",83,[[["self"],["i16"],["ordering"]],["i16"]]],[11,"fetch_min","","Minimum with the current value.",83,[[["self"],["i16"],["ordering"]],["i16"]]],[11,"default","","",84,[[],["self"]]],[11,"from","","",84,[[["u16"]],["self"]]],[11,"fmt","","",84,[[["self"],["formatter"]],["result"]]],[11,"new","","Creates a new atomic integer.",84,[[["u16"]],["self"]]],[11,"get_mut","","Returns a mutable reference to the underlying integer.",84,[[["self"]],["u16"]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",84,[[["self"]],["u16"]]],[11,"load","","Loads a value from the atomic integer.",84,[[["self"],["ordering"]],["u16"]]],[11,"store","","Stores a value into the atomic integer.",84,[[["self"],["u16"],["ordering"]]]],[11,"swap","","Stores a value into the atomic integer, returning the previous value.",84,[[["self"],["u16"],["ordering"]],["u16"]]],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",84,[[["self"],["u16"],["u16"],["ordering"]],["u16"]]],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",84,[[["self"],["u16"],["u16"],["ordering"],["ordering"]],["result",["u16","u16"]]]],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",84,[[["self"],["u16"],["u16"],["ordering"],["ordering"]],["result",["u16","u16"]]]],[11,"fetch_add","","Adds to the current value, returning the previous value.",84,[[["self"],["u16"],["ordering"]],["u16"]]],[11,"fetch_sub","","Subtracts from the current value, returning the previous value.",84,[[["self"],["u16"],["ordering"]],["u16"]]],[11,"fetch_and","","Bitwise \"and\" with the current value.",84,[[["self"],["u16"],["ordering"]],["u16"]]],[11,"fetch_nand","","Bitwise \"nand\" with the current value.",84,[[["self"],["u16"],["ordering"]],["u16"]]],[11,"fetch_or","","Bitwise \"or\" with the current value.",84,[[["self"],["u16"],["ordering"]],["u16"]]],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",84,[[["self"],["u16"],["ordering"]],["u16"]]],[11,"fetch_update","","Fetches the value, and applies a function to it that returns an optional new value. Returns a `Result` of `Ok(previous_value)` if the function returned `Some(_)`, else `Err(previous_value)`.",84,[[["self"],["f"],["ordering"],["ordering"]],["result",["u16","u16"]]]],[11,"fetch_max","","Maximum with the current value.",84,[[["self"],["u16"],["ordering"]],["u16"]]],[11,"fetch_min","","Minimum with the current value.",84,[[["self"],["u16"],["ordering"]],["u16"]]],[11,"default","","",85,[[],["self"]]],[11,"from","","",85,[[["i32"]],["self"]]],[11,"fmt","","",85,[[["self"],["formatter"]],["result"]]],[11,"new","","Creates a new atomic integer.",85,[[["i32"]],["self"]]],[11,"get_mut","","Returns a mutable reference to the underlying integer.",85,[[["self"]],["i32"]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",85,[[["self"]],["i32"]]],[11,"load","","Loads a value from the atomic integer.",85,[[["self"],["ordering"]],["i32"]]],[11,"store","","Stores a value into the atomic integer.",85,[[["self"],["i32"],["ordering"]]]],[11,"swap","","Stores a value into the atomic integer, returning the previous value.",85,[[["self"],["i32"],["ordering"]],["i32"]]],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",85,[[["self"],["i32"],["i32"],["ordering"]],["i32"]]],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",85,[[["self"],["i32"],["i32"],["ordering"],["ordering"]],["result",["i32","i32"]]]],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",85,[[["self"],["i32"],["i32"],["ordering"],["ordering"]],["result",["i32","i32"]]]],[11,"fetch_add","","Adds to the current value, returning the previous value.",85,[[["self"],["i32"],["ordering"]],["i32"]]],[11,"fetch_sub","","Subtracts from the current value, returning the previous value.",85,[[["self"],["i32"],["ordering"]],["i32"]]],[11,"fetch_and","","Bitwise \"and\" with the current value.",85,[[["self"],["i32"],["ordering"]],["i32"]]],[11,"fetch_nand","","Bitwise \"nand\" with the current value.",85,[[["self"],["i32"],["ordering"]],["i32"]]],[11,"fetch_or","","Bitwise \"or\" with the current value.",85,[[["self"],["i32"],["ordering"]],["i32"]]],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",85,[[["self"],["i32"],["ordering"]],["i32"]]],[11,"fetch_update","","Fetches the value, and applies a function to it that returns an optional new value. Returns a `Result` of `Ok(previous_value)` if the function returned `Some(_)`, else `Err(previous_value)`.",85,[[["self"],["f"],["ordering"],["ordering"]],["result",["i32","i32"]]]],[11,"fetch_max","","Maximum with the current value.",85,[[["self"],["i32"],["ordering"]],["i32"]]],[11,"fetch_min","","Minimum with the current value.",85,[[["self"],["i32"],["ordering"]],["i32"]]],[11,"default","","",86,[[],["self"]]],[11,"from","","",86,[[["u32"]],["self"]]],[11,"fmt","","",86,[[["self"],["formatter"]],["result"]]],[11,"new","","Creates a new atomic integer.",86,[[["u32"]],["self"]]],[11,"get_mut","","Returns a mutable reference to the underlying integer.",86,[[["self"]],["u32"]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",86,[[["self"]],["u32"]]],[11,"load","","Loads a value from the atomic integer.",86,[[["self"],["ordering"]],["u32"]]],[11,"store","","Stores a value into the atomic integer.",86,[[["self"],["u32"],["ordering"]]]],[11,"swap","","Stores a value into the atomic integer, returning the previous value.",86,[[["self"],["u32"],["ordering"]],["u32"]]],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",86,[[["self"],["u32"],["u32"],["ordering"]],["u32"]]],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",86,[[["self"],["u32"],["u32"],["ordering"],["ordering"]],["result",["u32","u32"]]]],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",86,[[["self"],["u32"],["u32"],["ordering"],["ordering"]],["result",["u32","u32"]]]],[11,"fetch_add","","Adds to the current value, returning the previous value.",86,[[["self"],["u32"],["ordering"]],["u32"]]],[11,"fetch_sub","","Subtracts from the current value, returning the previous value.",86,[[["self"],["u32"],["ordering"]],["u32"]]],[11,"fetch_and","","Bitwise \"and\" with the current value.",86,[[["self"],["u32"],["ordering"]],["u32"]]],[11,"fetch_nand","","Bitwise \"nand\" with the current value.",86,[[["self"],["u32"],["ordering"]],["u32"]]],[11,"fetch_or","","Bitwise \"or\" with the current value.",86,[[["self"],["u32"],["ordering"]],["u32"]]],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",86,[[["self"],["u32"],["ordering"]],["u32"]]],[11,"fetch_update","","Fetches the value, and applies a function to it that returns an optional new value. Returns a `Result` of `Ok(previous_value)` if the function returned `Some(_)`, else `Err(previous_value)`.",86,[[["self"],["f"],["ordering"],["ordering"]],["result",["u32","u32"]]]],[11,"fetch_max","","Maximum with the current value.",86,[[["self"],["u32"],["ordering"]],["u32"]]],[11,"fetch_min","","Minimum with the current value.",86,[[["self"],["u32"],["ordering"]],["u32"]]],[11,"default","","",87,[[],["self"]]],[11,"from","","",87,[[["i64"]],["self"]]],[11,"fmt","","",87,[[["self"],["formatter"]],["result"]]],[11,"new","","Creates a new atomic integer.",87,[[["i64"]],["self"]]],[11,"get_mut","","Returns a mutable reference to the underlying integer.",87,[[["self"]],["i64"]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",87,[[["self"]],["i64"]]],[11,"load","","Loads a value from the atomic integer.",87,[[["self"],["ordering"]],["i64"]]],[11,"store","","Stores a value into the atomic integer.",87,[[["self"],["i64"],["ordering"]]]],[11,"swap","","Stores a value into the atomic integer, returning the previous value.",87,[[["self"],["i64"],["ordering"]],["i64"]]],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",87,[[["self"],["i64"],["i64"],["ordering"]],["i64"]]],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",87,[[["self"],["i64"],["i64"],["ordering"],["ordering"]],["result",["i64","i64"]]]],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",87,[[["self"],["i64"],["i64"],["ordering"],["ordering"]],["result",["i64","i64"]]]],[11,"fetch_add","","Adds to the current value, returning the previous value.",87,[[["self"],["i64"],["ordering"]],["i64"]]],[11,"fetch_sub","","Subtracts from the current value, returning the previous value.",87,[[["self"],["i64"],["ordering"]],["i64"]]],[11,"fetch_and","","Bitwise \"and\" with the current value.",87,[[["self"],["i64"],["ordering"]],["i64"]]],[11,"fetch_nand","","Bitwise \"nand\" with the current value.",87,[[["self"],["i64"],["ordering"]],["i64"]]],[11,"fetch_or","","Bitwise \"or\" with the current value.",87,[[["self"],["i64"],["ordering"]],["i64"]]],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",87,[[["self"],["i64"],["ordering"]],["i64"]]],[11,"fetch_update","","Fetches the value, and applies a function to it that returns an optional new value. Returns a `Result` of `Ok(previous_value)` if the function returned `Some(_)`, else `Err(previous_value)`.",87,[[["self"],["f"],["ordering"],["ordering"]],["result",["i64","i64"]]]],[11,"fetch_max","","Maximum with the current value.",87,[[["self"],["i64"],["ordering"]],["i64"]]],[11,"fetch_min","","Minimum with the current value.",87,[[["self"],["i64"],["ordering"]],["i64"]]],[11,"default","","",88,[[],["self"]]],[11,"from","","",88,[[["u64"]],["self"]]],[11,"fmt","","",88,[[["self"],["formatter"]],["result"]]],[11,"new","","Creates a new atomic integer.",88,[[["u64"]],["self"]]],[11,"get_mut","","Returns a mutable reference to the underlying integer.",88,[[["self"]],["u64"]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",88,[[["self"]],["u64"]]],[11,"load","","Loads a value from the atomic integer.",88,[[["self"],["ordering"]],["u64"]]],[11,"store","","Stores a value into the atomic integer.",88,[[["self"],["u64"],["ordering"]]]],[11,"swap","","Stores a value into the atomic integer, returning the previous value.",88,[[["self"],["u64"],["ordering"]],["u64"]]],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",88,[[["self"],["u64"],["u64"],["ordering"]],["u64"]]],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",88,[[["self"],["u64"],["u64"],["ordering"],["ordering"]],["result",["u64","u64"]]]],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",88,[[["self"],["u64"],["u64"],["ordering"],["ordering"]],["result",["u64","u64"]]]],[11,"fetch_add","","Adds to the current value, returning the previous value.",88,[[["self"],["u64"],["ordering"]],["u64"]]],[11,"fetch_sub","","Subtracts from the current value, returning the previous value.",88,[[["self"],["u64"],["ordering"]],["u64"]]],[11,"fetch_and","","Bitwise \"and\" with the current value.",88,[[["self"],["u64"],["ordering"]],["u64"]]],[11,"fetch_nand","","Bitwise \"nand\" with the current value.",88,[[["self"],["u64"],["ordering"]],["u64"]]],[11,"fetch_or","","Bitwise \"or\" with the current value.",88,[[["self"],["u64"],["ordering"]],["u64"]]],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",88,[[["self"],["u64"],["ordering"]],["u64"]]],[11,"fetch_update","","Fetches the value, and applies a function to it that returns an optional new value. Returns a `Result` of `Ok(previous_value)` if the function returned `Some(_)`, else `Err(previous_value)`.",88,[[["self"],["f"],["ordering"],["ordering"]],["result",["u64","u64"]]]],[11,"fetch_max","","Maximum with the current value.",88,[[["self"],["u64"],["ordering"]],["u64"]]],[11,"fetch_min","","Minimum with the current value.",88,[[["self"],["u64"],["ordering"]],["u64"]]],[11,"default","","",89,[[],["self"]]],[11,"from","","",89,[[["isize"]],["self"]]],[11,"fmt","","",89,[[["self"],["formatter"]],["result"]]],[11,"new","","Creates a new atomic integer.",89,[[["isize"]],["self"]]],[11,"get_mut","","Returns a mutable reference to the underlying integer.",89,[[["self"]],["isize"]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",89,[[["self"]],["isize"]]],[11,"load","","Loads a value from the atomic integer.",89,[[["self"],["ordering"]],["isize"]]],[11,"store","","Stores a value into the atomic integer.",89,[[["self"],["isize"],["ordering"]]]],[11,"swap","","Stores a value into the atomic integer, returning the previous value.",89,[[["self"],["isize"],["ordering"]],["isize"]]],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",89,[[["self"],["isize"],["isize"],["ordering"]],["isize"]]],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",89,[[["self"],["isize"],["isize"],["ordering"],["ordering"]],["result",["isize","isize"]]]],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",89,[[["self"],["isize"],["isize"],["ordering"],["ordering"]],["result",["isize","isize"]]]],[11,"fetch_add","","Adds to the current value, returning the previous value.",89,[[["self"],["isize"],["ordering"]],["isize"]]],[11,"fetch_sub","","Subtracts from the current value, returning the previous value.",89,[[["self"],["isize"],["ordering"]],["isize"]]],[11,"fetch_and","","Bitwise \"and\" with the current value.",89,[[["self"],["isize"],["ordering"]],["isize"]]],[11,"fetch_nand","","Bitwise \"nand\" with the current value.",89,[[["self"],["isize"],["ordering"]],["isize"]]],[11,"fetch_or","","Bitwise \"or\" with the current value.",89,[[["self"],["isize"],["ordering"]],["isize"]]],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",89,[[["self"],["isize"],["ordering"]],["isize"]]],[11,"fetch_update","","Fetches the value, and applies a function to it that returns an optional new value. Returns a `Result` of `Ok(previous_value)` if the function returned `Some(_)`, else `Err(previous_value)`.",89,[[["self"],["f"],["ordering"],["ordering"]],["result",["isize","isize"]]]],[11,"fetch_max","","Maximum with the current value.",89,[[["self"],["isize"],["ordering"]],["isize"]]],[11,"fetch_min","","Minimum with the current value.",89,[[["self"],["isize"],["ordering"]],["isize"]]],[11,"default","","",90,[[],["self"]]],[11,"from","","",90,[[["usize"]],["self"]]],[11,"fmt","","",90,[[["self"],["formatter"]],["result"]]],[11,"new","","Creates a new atomic integer.",90,[[["usize"]],["self"]]],[11,"get_mut","","Returns a mutable reference to the underlying integer.",90,[[["self"]],["usize"]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",90,[[["self"]],["usize"]]],[11,"load","","Loads a value from the atomic integer.",90,[[["self"],["ordering"]],["usize"]]],[11,"store","","Stores a value into the atomic integer.",90,[[["self"],["usize"],["ordering"]]]],[11,"swap","","Stores a value into the atomic integer, returning the previous value.",90,[[["self"],["usize"],["ordering"]],["usize"]]],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",90,[[["self"],["usize"],["usize"],["ordering"]],["usize"]]],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",90,[[["self"],["usize"],["usize"],["ordering"],["ordering"]],["result",["usize","usize"]]]],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",90,[[["self"],["usize"],["usize"],["ordering"],["ordering"]],["result",["usize","usize"]]]],[11,"fetch_add","","Adds to the current value, returning the previous value.",90,[[["self"],["usize"],["ordering"]],["usize"]]],[11,"fetch_sub","","Subtracts from the current value, returning the previous value.",90,[[["self"],["usize"],["ordering"]],["usize"]]],[11,"fetch_and","","Bitwise \"and\" with the current value.",90,[[["self"],["usize"],["ordering"]],["usize"]]],[11,"fetch_nand","","Bitwise \"nand\" with the current value.",90,[[["self"],["usize"],["ordering"]],["usize"]]],[11,"fetch_or","","Bitwise \"or\" with the current value.",90,[[["self"],["usize"],["ordering"]],["usize"]]],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",90,[[["self"],["usize"],["ordering"]],["usize"]]],[11,"fetch_update","","Fetches the value, and applies a function to it that returns an optional new value. Returns a `Result` of `Ok(previous_value)` if the function returned `Some(_)`, else `Err(previous_value)`.",90,[[["self"],["f"],["ordering"],["ordering"]],["result",["usize","usize"]]]],[11,"fetch_max","","Maximum with the current value.",90,[[["self"],["usize"],["ordering"]],["usize"]]],[11,"fetch_min","","Minimum with the current value.",90,[[["self"],["usize"],["ordering"]],["usize"]]],[11,"fmt","","",79,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",80,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",80,[[["self"],["formatter"]],["result"]]],[0,"cell","core","Shareable mutable containers.",N,N],[3,"Cell","core::cell","A mutable memory location.",N,N],[3,"RefCell","","A mutable memory location with dynamically checked borrow rules",N,N],[3,"BorrowError","","An error returned by `RefCell::try_borrow`.",N,N],[3,"BorrowMutError","","An error returned by `RefCell::try_borrow_mut`.",N,N],[3,"Ref","","Wraps a borrowed reference to a value in a `RefCell` box. A wrapper type for an immutably borrowed value from a `RefCell<T>`.",N,N],[3,"RefMut","","A wrapper type for a mutably borrowed value from a `RefCell<T>`.",N,N],[3,"UnsafeCell","","The core primitive for interior mutability in Rust.",N,N],[11,"get","","Returns a copy of the contained value.",91,[[["self"]],["t"]]],[11,"update","","Updates the contained value using a function and returns the new value.",91,[[["self"],["f"]],["t"]]],[11,"clone","","",91,[[["self"]],["cell"]]],[11,"default","","Creates a `Cell<T>`, with the `Default` value for T.",91,[[],["cell"]]],[11,"eq","","",91,[[["self"],["cell"]],["bool"]]],[11,"partial_cmp","","",91,[[["self"],["cell"]],["option",["ordering"]]]],[11,"lt","","",91,[[["self"],["cell"]],["bool"]]],[11,"le","","",91,[[["self"],["cell"]],["bool"]]],[11,"gt","","",91,[[["self"],["cell"]],["bool"]]],[11,"ge","","",91,[[["self"],["cell"]],["bool"]]],[11,"cmp","","",91,[[["self"],["cell"]],["ordering"]]],[11,"from","","",91,[[["t"]],["cell"]]],[11,"new","","Creates a new `Cell` containing the given value.",91,[[["t"]],["cell"]]],[11,"set","","Sets the contained value.",91,[[["self"],["t"]]]],[11,"swap","","Swaps the values of two Cells. Difference with `std::mem::swap` is that this function doesn't require `&mut` reference.",91,[[["self"],["self"]]]],[11,"replace","","Replaces the contained value, and returns it.",91,[[["self"],["t"]],["t"]]],[11,"into_inner","","Unwraps the value.",91,[[["self"]],["t"]]],[11,"as_ptr","","Returns a raw pointer to the underlying data in this cell.",91,N],[11,"get_mut","","Returns a mutable reference to the underlying data.",91,[[["self"]],["t"]]],[11,"from_mut","","Returns a `&Cell<T>` from a `&mut T`",91,[[["t"]],["cell"]]],[11,"take","","Takes the value of the cell, leaving `Default::default()` in its place.",91,[[["self"]],["t"]]],[11,"as_slice_of_cells","","Returns a `&[Cell<T>]` from a `&Cell<[T]>`",91,N],[11,"fmt","","",92,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",92,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",93,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",93,[[["self"],["formatter"]],["result"]]],[11,"new","","Creates a new `RefCell` containing `value`.",94,[[["t"]],["refcell"]]],[11,"into_inner","","Consumes the `RefCell`, returning the wrapped value.",94,[[["self"]],["t"]]],[11,"replace","","Replaces the wrapped value with a new one, returning the old value, without deinitializing either one.",94,[[["self"],["t"]],["t"]]],[11,"replace_with","","Replaces the wrapped value with a new one computed from `f`, returning the old value, without deinitializing either one.",94,[[["self"],["f"]],["t"]]],[11,"swap","","Swaps the wrapped value of `self` with the wrapped value of `other`, without deinitializing either one.",94,[[["self"],["self"]]]],[11,"borrow","","Immutably borrows the wrapped value.",94,[[["self"]],["ref"]]],[11,"try_borrow","","Immutably borrows the wrapped value, returning an error if the value is currently mutably borrowed.",94,[[["self"]],["result",["ref","borrowerror"]]]],[11,"borrow_mut","","Mutably borrows the wrapped value.",94,[[["self"]],["refmut"]]],[11,"try_borrow_mut","","Mutably borrows the wrapped value, returning an error if the value is currently borrowed.",94,[[["self"]],["result",["refmut","borrowmuterror"]]]],[11,"as_ptr","","Returns a raw pointer to the underlying data in this cell.",94,N],[11,"get_mut","","Returns a mutable reference to the underlying data.",94,[[["self"]],["t"]]],[11,"clone","","Panics",94,[[["self"]],["refcell"]]],[11,"default","","Creates a `RefCell<T>`, with the `Default` value for T.",94,[[],["refcell"]]],[11,"eq","","Panics",94,[[["self"],["refcell"]],["bool"]]],[11,"partial_cmp","","Panics",94,[[["self"],["refcell"]],["option",["ordering"]]]],[11,"lt","","Panics",94,[[["self"],["refcell"]],["bool"]]],[11,"le","","Panics",94,[[["self"],["refcell"]],["bool"]]],[11,"gt","","Panics",94,[[["self"],["refcell"]],["bool"]]],[11,"ge","","Panics",94,[[["self"],["refcell"]],["bool"]]],[11,"cmp","","Panics",94,[[["self"],["refcell"]],["ordering"]]],[11,"from","","",94,[[["t"]],["refcell"]]],[11,"deref","","",95,[[["self"]],["t"]]],[11,"clone","","Copies a `Ref`.",95,[[["ref"]],["ref"]]],[11,"map","","Make a new `Ref` for a component of the borrowed data.",95,[[["ref"],["f"]],["ref"]]],[11,"map_split","","Split a `Ref` into multiple `Ref`s for different components of the borrowed data.",95,N],[11,"fmt","","",95,[[["self"],["formatter"]],["result"]]],[11,"map","","Make a new `RefMut` for a component of the borrowed data, e.g. an enum variant.",96,[[["refmut"],["f"]],["refmut"]]],[11,"map_split","","Split a `RefMut` into multiple `RefMut`s for different components of the borrowed data.",96,N],[11,"deref","","",96,[[["self"]],["t"]]],[11,"deref_mut","","",96,[[["self"]],["t"]]],[11,"fmt","","",96,[[["self"],["formatter"]],["result"]]],[11,"new","","Constructs a new instance of `UnsafeCell` which will wrap the specified value.",97,[[["t"]],["unsafecell"]]],[11,"into_inner","","Unwraps the value.",97,[[["self"]],["t"]]],[11,"get","","Gets a mutable pointer to the wrapped value.",97,N],[11,"default","","Creates an `UnsafeCell`, with the `Default` value for T.",97,[[],["unsafecell"]]],[11,"from","","",97,[[["t"]],["unsafecell"]]],[0,"char","core","A character type.",N,N],[3,"ParseCharError","core::char","An error which can be returned when parsing a char.",N,N],[3,"CharTryFromError","","The error type returned when a conversion from u32 to char fails.",N,N],[3,"DecodeUtf16","","An iterator that decodes UTF-16 encoded code points from an iterator of `u16`s.",N,N],[3,"DecodeUtf16Error","","An error that can be returned when decoding UTF-16 code points.",N,N],[3,"UnicodeVersion","","Represents a Unicode Version.",N,N],[12,"major","","Major version.",98,N],[12,"minor","","Minor version.",98,N],[12,"micro","","Micro (or Update) version.",98,N],[3,"DecodeUtf8","","An iterator over an iterator of bytes of the characters the bytes represent as UTF-8",N,N],[3,"InvalidSequence","","`<DecodeUtf8 as Iterator>::next` returns this for an invalid input sequence.",N,N],[3,"EscapeUnicode","","Returns an iterator that yields the hexadecimal Unicode escape of a character, as `char`s.",N,N],[3,"EscapeDefault","","An iterator that yields the literal escape code of a `char`.",N,N],[3,"EscapeDebug","","An iterator that yields the literal escape code of a `char`.",N,N],[3,"ToLowercase","","Returns an iterator that yields the lowercase equivalent of a `char`.",N,N],[3,"ToUppercase","","Returns an iterator that yields the uppercase equivalent of a `char`.",N,N],[5,"from_u32","","Converts a `u32` to a `char`.",N,[[["u32"]],["option",["char"]]]],[5,"from_digit","","Converts a digit in the given radix to a `char`.",N,[[["u32"],["u32"]],["option",["char"]]]],[5,"from_u32_unchecked","","Converts a `u32` to a `char`, ignoring validity.",N,[[["u32"]],["char"]]],[5,"decode_utf16","","Create an iterator over the UTF-16 encoded code points in `iter`, returning unpaired surrogates as `Err`s.",N,[[["i"]],["decodeutf16"]]],[5,"decode_utf8","","Decodes an `Iterator` of bytes as UTF-8.",N,[[["i"]],["decodeutf8"]]],[11,"clone","","",99,[[["self"]],["parsecharerror"]]],[11,"fmt","","",99,[[["self"],["formatter"]],["result"]]],[11,"eq","","",99,[[["self"],["parsecharerror"]],["bool"]]],[11,"ne","","",99,[[["self"],["parsecharerror"]],["bool"]]],[11,"fmt","","",99,[[["self"],["formatter"]],["result"]]],[11,"clone","","",100,[[["self"]],["chartryfromerror"]]],[11,"fmt","","",100,[[["self"],["formatter"]],["result"]]],[11,"eq","","",100,[[["self"],["chartryfromerror"]],["bool"]]],[11,"ne","","",100,[[["self"],["chartryfromerror"]],["bool"]]],[11,"fmt","","",100,[[["self"],["formatter"]],["result"]]],[11,"clone","","",101,[[["self"]],["decodeutf8"]]],[11,"fmt","","",101,[[["self"],["formatter"]],["result"]]],[11,"eq","","",102,[[["self"],["invalidsequence"]],["bool"]]],[11,"ne","","",102,[[["self"],["invalidsequence"]],["bool"]]],[11,"fmt","","",102,[[["self"],["formatter"]],["result"]]],[11,"next","","",101,[[["self"]],["option",["result"]]]],[11,"size_hint","","",101,N],[11,"clone","","",103,[[["self"]],["decodeutf16"]]],[11,"fmt","","",103,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",104,[[["self"],["formatter"]],["result"]]],[11,"clone","","",104,[[["self"]],["decodeutf16error"]]],[11,"eq","","",104,[[["self"],["decodeutf16error"]],["bool"]]],[11,"ne","","",104,[[["self"],["decodeutf16error"]],["bool"]]],[11,"next","","",103,[[["self"]],["option",["result"]]]],[11,"size_hint","","",103,N],[11,"unpaired_surrogate","","Returns the unpaired surrogate which caused this error.",104,[[["self"]],["u16"]]],[11,"fmt","","",104,[[["self"],["formatter"]],["result"]]],[17,"UNICODE_VERSION","","The version of Unicode that the Unicode parts of `char` and `str` methods are based on.",N,N],[17,"MAX","","The highest valid code point a `char` can have.",N,N],[17,"REPLACEMENT_CHARACTER","","`U+FFFD REPLACEMENT CHARACTER` (�) is used in Unicode to represent a decoding error.",N,N],[11,"clone","","",105,[[["self"]],["escapeunicode"]]],[11,"fmt","","",105,[[["self"],["formatter"]],["result"]]],[11,"next","","",105,[[["self"]],["option",["char"]]]],[11,"size_hint","","",105,N],[11,"count","","",105,[[["self"]],["usize"]]],[11,"last","","",105,[[["self"]],["option",["char"]]]],[11,"len","","",105,[[["self"]],["usize"]]],[11,"fmt","","",105,[[["self"],["formatter"]],["result"]]],[11,"clone","","",106,[[["self"]],["escapedefault"]]],[11,"fmt","","",106,[[["self"],["formatter"]],["result"]]],[11,"next","","",106,[[["self"]],["option",["char"]]]],[11,"size_hint","","",106,N],[11,"count","","",106,[[["self"]],["usize"]]],[11,"nth","","",106,[[["self"],["usize"]],["option",["char"]]]],[11,"last","","",106,[[["self"]],["option",["char"]]]],[11,"len","","",106,[[["self"]],["usize"]]],[11,"fmt","","",106,[[["self"],["formatter"]],["result"]]],[11,"clone","","",107,[[["self"]],["escapedebug"]]],[11,"fmt","","",107,[[["self"],["formatter"]],["result"]]],[11,"next","","",107,[[["self"]],["option",["char"]]]],[11,"size_hint","","",107,N],[11,"fmt","","",107,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",108,[[["self"],["formatter"]],["result"]]],[11,"clone","","",108,[[["self"]],["tolowercase"]]],[11,"next","","",108,[[["self"]],["option",["char"]]]],[11,"fmt","","",109,[[["self"],["formatter"]],["result"]]],[11,"clone","","",109,[[["self"]],["touppercase"]]],[11,"next","","",109,[[["self"]],["option",["char"]]]],[11,"fmt","","",108,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",109,[[["self"],["formatter"]],["result"]]],[0,"panic","core","Panic support in the standard library.",N,N],[3,"PanicInfo","core::panic","A struct providing information about a panic.",N,N],[3,"Location","","A struct containing information about the location of a panic.",N,N],[11,"fmt","","",110,[[["self"],["formatter"]],["result"]]],[11,"payload","","Returns the payload associated with the panic.",110,[[["self"]],["any"]]],[11,"message","","If the `panic!` macro from the `core` crate (not from `std`) was used with a formatting string and some additional arguments, returns that message ready to be used for example with [`fmt::write`]",110,[[["self"]],["option",["arguments"]]]],[11,"location","","Returns information about the location from which the panic originated, if available.",110,[[["self"]],["option",["location"]]]],[11,"fmt","","",110,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",111,[[["self"],["formatter"]],["result"]]],[11,"file","","Returns the name of the source file from which the panic originated.",111,[[["self"]],["str"]]],[11,"line","","Returns the line number from which the panic originated.",111,[[["self"]],["u32"]]],[11,"column","","Returns the column from which the panic originated.",111,[[["self"]],["u32"]]],[11,"fmt","","",111,[[["self"],["formatter"]],["result"]]],[0,"panicking","core","Panic support for libcore",N,N],[5,"panic","core::panicking","",N,N],[5,"panic_fmt","","",N,N],[0,"iter","core","Composable external iteration.",N,N],[3,"Repeat","core::iter","An iterator that repeats an element endlessly.",N,N],[3,"RepeatWith","","An iterator that repeats elements of type `A` endlessly by applying the provided closure `F: FnMut() -> A`.",N,N],[3,"Empty","","An iterator that yields nothing.",N,N],[3,"Once","","An iterator that yields an element exactly once.",N,N],[3,"Rev","","A double-ended iterator with the direction inverted.",N,N],[3,"Cloned","","An iterator that clones the elements of an underlying iterator.",N,N],[3,"Cycle","","An iterator that repeats endlessly.",N,N],[3,"StepBy","","An iterator for stepping iterators by a custom amount.",N,N],[3,"Chain","","An iterator that strings two iterators together.",N,N],[3,"Zip","","An iterator that iterates two other iterators simultaneously.",N,N],[3,"Map","","An iterator that maps the values of `iter` with `f`.",N,N],[3,"Filter","","An iterator that filters the elements of `iter` with `predicate`.",N,N],[3,"FilterMap","","An iterator that uses `f` to both filter and map elements from `iter`.",N,N],[3,"Enumerate","","An iterator that yields the current count and the element during iteration.",N,N],[3,"Peekable","","An iterator with a `peek()` that returns an optional reference to the next element.",N,N],[3,"SkipWhile","","An iterator that rejects elements while `predicate` is true.",N,N],[3,"TakeWhile","","An iterator that only accepts elements while `predicate` is true.",N,N],[3,"Skip","","An iterator that skips over `n` elements of `iter`.",N,N],[3,"Take","","An iterator that only iterates over the first `n` iterations of `iter`.",N,N],[3,"Scan","","An iterator to maintain state while iterating another iterator.",N,N],[3,"FlatMap","","An iterator that maps each element to an iterator, and yields the elements of the produced iterators.",N,N],[3,"Flatten","","An iterator that flattens one level of nesting in an iterator of things that can be turned into iterators.",N,N],[3,"Fuse","","An iterator that yields `None` forever after the underlying iterator yields `None` once.",N,N],[3,"Inspect","","An iterator that calls a function with a reference to each element before yielding it.",N,N],[5,"repeat","","Creates a new iterator that endlessly repeats a single element.",N,[[["t"]],["repeat"]]],[5,"repeat_with","","Creates a new iterator that repeats elements of type `A` endlessly by applying the provided closure, the repeater, `F: FnMut() -> A`.",N,[[["f"]],["repeatwith"]]],[5,"empty","","Creates an iterator that yields nothing.",N,[[],["empty"]]],[5,"once","","Creates an iterator that yields an element exactly once.",N,[[["t"]],["once"]]],[11,"next","core::ops","",17,[[["self"]],["option"]]],[11,"size_hint","","",17,N],[11,"nth","","",17,[[["self"],["usize"]],["option"]]],[11,"last","","",17,[[["self"]],["option"]]],[11,"min","","",17,[[["self"]],["option"]]],[11,"max","","",17,[[["self"]],["option"]]],[11,"next_back","","",17,[[["self"]],["option"]]],[11,"next","","",18,[[["self"]],["option"]]],[11,"size_hint","","",18,N],[11,"nth","","",18,[[["self"],["usize"]],["option"]]],[11,"next","","",24,[[["self"]],["option"]]],[11,"size_hint","","",24,N],[11,"nth","","",24,[[["self"],["usize"]],["option"]]],[11,"last","","",24,[[["self"]],["option"]]],[11,"min","","",24,[[["self"]],["option"]]],[11,"max","","",24,[[["self"]],["option"]]],[11,"next_back","","",24,[[["self"]],["option"]]],[11,"clone","core::iter","",112,[[["self"]],["repeat"]]],[11,"fmt","","",112,[[["self"],["formatter"]],["result"]]],[11,"next","","",112,[[["self"]],["option"]]],[11,"size_hint","","",112,N],[11,"next_back","","",112,[[["self"]],["option"]]],[11,"clone","","",113,[[["self"]],["repeatwith"]]],[11,"fmt","","",113,[[["self"],["formatter"]],["result"]]],[11,"next","","",113,[[["self"]],["option"]]],[11,"size_hint","","",113,N],[11,"fmt","","",114,[[["self"],["formatter"]],["result"]]],[11,"next","","",114,[[["self"]],["option"]]],[11,"size_hint","","",114,N],[11,"next_back","","",114,[[["self"]],["option"]]],[11,"len","","",114,[[["self"]],["usize"]]],[11,"clone","","",114,[[["self"]],["empty"]]],[11,"default","","",114,[[],["empty"]]],[11,"clone","","",115,[[["self"]],["once"]]],[11,"fmt","","",115,[[["self"],["formatter"]],["result"]]],[11,"next","","",115,[[["self"]],["option"]]],[11,"size_hint","","",115,N],[11,"next_back","","",115,[[["self"]],["option"]]],[11,"len","","",115,[[["self"]],["usize"]]],[11,"sum","core::num","",0,[[["i"]],["wrapping",["i8"]]]],[11,"product","","",0,[[["i"]],["wrapping",["i8"]]]],[11,"sum","","",0,[[["i"]],["wrapping",["i8"]]]],[11,"product","","",0,[[["i"]],["wrapping",["i8"]]]],[11,"sum","","",0,[[["i"]],["wrapping",["i16"]]]],[11,"product","","",0,[[["i"]],["wrapping",["i16"]]]],[11,"sum","","",0,[[["i"]],["wrapping",["i16"]]]],[11,"product","","",0,[[["i"]],["wrapping",["i16"]]]],[11,"sum","","",0,[[["i"]],["wrapping",["i32"]]]],[11,"product","","",0,[[["i"]],["wrapping",["i32"]]]],[11,"sum","","",0,[[["i"]],["wrapping",["i32"]]]],[11,"product","","",0,[[["i"]],["wrapping",["i32"]]]],[11,"sum","","",0,[[["i"]],["wrapping",["i64"]]]],[11,"product","","",0,[[["i"]],["wrapping",["i64"]]]],[11,"sum","","",0,[[["i"]],["wrapping",["i64"]]]],[11,"product","","",0,[[["i"]],["wrapping",["i64"]]]],[11,"sum","","",0,[[["i"]],["wrapping",["i128"]]]],[11,"product","","",0,[[["i"]],["wrapping",["i128"]]]],[11,"sum","","",0,[[["i"]],["wrapping",["i128"]]]],[11,"product","","",0,[[["i"]],["wrapping",["i128"]]]],[11,"sum","","",0,[[["i"]],["wrapping",["isize"]]]],[11,"product","","",0,[[["i"]],["wrapping",["isize"]]]],[11,"sum","","",0,[[["i"]],["wrapping",["isize"]]]],[11,"product","","",0,[[["i"]],["wrapping",["isize"]]]],[11,"sum","","",0,[[["i"]],["wrapping",["u8"]]]],[11,"product","","",0,[[["i"]],["wrapping",["u8"]]]],[11,"sum","","",0,[[["i"]],["wrapping",["u8"]]]],[11,"product","","",0,[[["i"]],["wrapping",["u8"]]]],[11,"sum","","",0,[[["i"]],["wrapping",["u16"]]]],[11,"product","","",0,[[["i"]],["wrapping",["u16"]]]],[11,"sum","","",0,[[["i"]],["wrapping",["u16"]]]],[11,"product","","",0,[[["i"]],["wrapping",["u16"]]]],[11,"sum","","",0,[[["i"]],["wrapping",["u32"]]]],[11,"product","","",0,[[["i"]],["wrapping",["u32"]]]],[11,"sum","","",0,[[["i"]],["wrapping",["u32"]]]],[11,"product","","",0,[[["i"]],["wrapping",["u32"]]]],[11,"sum","","",0,[[["i"]],["wrapping",["u64"]]]],[11,"product","","",0,[[["i"]],["wrapping",["u64"]]]],[11,"sum","","",0,[[["i"]],["wrapping",["u64"]]]],[11,"product","","",0,[[["i"]],["wrapping",["u64"]]]],[11,"sum","","",0,[[["i"]],["wrapping",["u128"]]]],[11,"product","","",0,[[["i"]],["wrapping",["u128"]]]],[11,"sum","","",0,[[["i"]],["wrapping",["u128"]]]],[11,"product","","",0,[[["i"]],["wrapping",["u128"]]]],[11,"sum","","",0,[[["i"]],["wrapping",["usize"]]]],[11,"product","","",0,[[["i"]],["wrapping",["usize"]]]],[11,"sum","","",0,[[["i"]],["wrapping",["usize"]]]],[11,"product","","",0,[[["i"]],["wrapping",["usize"]]]],[8,"Iterator","core::iter","An interface for dealing with iterators.",N,N],[16,"Item","","The type of the elements being iterated over.",116,N],[10,"next","","Advances the iterator and returns the next value.",116,[[["self"]],["option"]]],[11,"size_hint","","Returns the bounds on the remaining length of the iterator.",116,N],[11,"count","","Consumes the iterator, counting the number of iterations and returning it.",116,[[["self"]],["usize"]]],[11,"last","","Consumes the iterator, returning the last element.",116,[[["self"]],["option"]]],[11,"nth","","Returns the `n`th element of the iterator.",116,[[["self"],["usize"]],["option"]]],[11,"step_by","","Creates an iterator starting at the same point, but stepping by the given amount at each iteration.",116,[[["self"],["usize"]],["stepby"]]],[11,"chain","","Takes two iterators and creates a new iterator over both in sequence.",116,[[["self"],["u"]],["chain"]]],[11,"zip","","'Zips up' two iterators into a single iterator of pairs.",116,[[["self"],["u"]],["zip"]]],[11,"map","","Takes a closure and creates an iterator which calls that closure on each element.",116,[[["self"],["f"]],["map"]]],[11,"for_each","","Calls a closure on each element of an iterator.",116,[[["self"],["f"]]]],[11,"filter","","Creates an iterator which uses a closure to determine if an element should be yielded.",116,[[["self"],["p"]],["filter"]]],[11,"filter_map","","Creates an iterator that both filters and maps.",116,[[["self"],["f"]],["filtermap"]]],[11,"enumerate","","Creates an iterator which gives the current iteration count as well as the next value.",116,[[["self"]],["enumerate"]]],[11,"peekable","","Creates an iterator which can use `peek` to look at the next element of the iterator without consuming it.",116,[[["self"]],["peekable"]]],[11,"skip_while","","Creates an iterator that [`skip`]s elements based on a predicate.",116,[[["self"],["p"]],["skipwhile"]]],[11,"take_while","","Creates an iterator that yields elements based on a predicate.",116,[[["self"],["p"]],["takewhile"]]],[11,"skip","","Creates an iterator that skips the first `n` elements.",116,[[["self"],["usize"]],["skip"]]],[11,"take","","Creates an iterator that yields its first `n` elements.",116,[[["self"],["usize"]],["take"]]],[11,"scan","","An iterator adaptor similar to [`fold`] that holds internal state and produces a new iterator.",116,[[["self"],["st"],["f"]],["scan"]]],[11,"flat_map","","Creates an iterator that works like map, but flattens nested structure.",116,[[["self"],["f"]],["flatmap"]]],[11,"flatten","","Creates an iterator that flattens nested structure.",116,[[["self"]],["flatten"]]],[11,"fuse","","Creates an iterator which ends after the first [`None`].",116,[[["self"]],["fuse"]]],[11,"inspect","","Do something with each element of an iterator, passing the value on.",116,[[["self"],["f"]],["inspect"]]],[11,"by_ref","","Borrows an iterator, rather than consuming it.",116,[[["self"]],["self"]]],[11,"collect","","Transforms an iterator into a collection.",116,[[["self"]],["b"]]],[11,"partition","","Consumes an iterator, creating two collections from it.",116,N],[11,"try_fold","","An iterator method that applies a function as long as it returns successfully, producing a single, final value.",116,[[["self"],["b"],["f"]],["r"]]],[11,"try_for_each","","An iterator method that applies a fallible function to each item in the iterator, stopping at the first error and returning that error.",116,[[["self"],["f"]],["r"]]],[11,"fold","","An iterator method that applies a function, producing a single, final value.",116,[[["self"],["b"],["f"]],["b"]]],[11,"all","","Tests if every element of the iterator matches a predicate.",116,[[["self"],["f"]],["bool"]]],[11,"any","","Tests if any element of the iterator matches a predicate.",116,[[["self"],["f"]],["bool"]]],[11,"find","","Searches for an element of an iterator that satisfies a predicate.",116,[[["self"],["p"]],["option"]]],[11,"find_map","","Applies function to the elements of iterator and returns the first non-none result.",116,[[["self"],["f"]],["option"]]],[11,"position","","Searches for an element in an iterator, returning its index.",116,[[["self"],["p"]],["option",["usize"]]]],[11,"rposition","","Searches for an element in an iterator from the right, returning its index.",116,[[["self"],["p"]],["option",["usize"]]]],[11,"max","","Returns the maximum element of an iterator.",116,[[["self"]],["option"]]],[11,"min","","Returns the minimum element of an iterator.",116,[[["self"]],["option"]]],[11,"max_by_key","","Returns the element that gives the maximum value from the specified function.",116,[[["self"],["f"]],["option"]]],[11,"max_by","","Returns the element that gives the maximum value with respect to the specified comparison function.",116,[[["self"],["f"]],["option"]]],[11,"min_by_key","","Returns the element that gives the minimum value from the specified function.",116,[[["self"],["f"]],["option"]]],[11,"min_by","","Returns the element that gives the minimum value with respect to the specified comparison function.",116,[[["self"],["f"]],["option"]]],[11,"rev","","Reverses an iterator's direction.",116,[[["self"]],["rev"]]],[11,"unzip","","Converts an iterator of pairs into a pair of containers.",116,N],[11,"cloned","","Creates an iterator which [`clone`]s all of its elements.",116,[[["self"]],["cloned"]]],[11,"cycle","","Repeats an iterator endlessly.",116,[[["self"]],["cycle"]]],[11,"sum","","Sums the elements of an iterator.",116,[[["self"]],["s"]]],[11,"product","","Iterates over the entire iterator, multiplying all the elements",116,[[["self"]],["p"]]],[11,"cmp","","Lexicographically compares the elements of this `Iterator` with those of another.",116,[[["self"],["i"]],["ordering"]]],[11,"partial_cmp","","Lexicographically compares the elements of this `Iterator` with those of another.",116,[[["self"],["i"]],["option",["ordering"]]]],[11,"eq","","Determines if the elements of this `Iterator` are equal to those of another.",116,[[["self"],["i"]],["bool"]]],[11,"ne","","Determines if the elements of this `Iterator` are unequal to those of another.",116,[[["self"],["i"]],["bool"]]],[11,"lt","","Determines if the elements of this `Iterator` are lexicographically less than those of another.",116,[[["self"],["i"]],["bool"]]],[11,"le","","Determines if the elements of this `Iterator` are lexicographically less or equal to those of another.",116,[[["self"],["i"]],["bool"]]],[11,"gt","","Determines if the elements of this `Iterator` are lexicographically greater than those of another.",116,[[["self"],["i"]],["bool"]]],[11,"ge","","Determines if the elements of this `Iterator` are lexicographically greater than or equal to those of another.",116,[[["self"],["i"]],["bool"]]],[8,"Step","","Objects that can be stepped over in both directions.",N,N],[10,"steps_between","","Returns the number of steps between two step objects. The count is inclusive of `start` and exclusive of `end`.",117,[[["self"],["self"]],["option",["usize"]]]],[10,"replace_one","","Replaces this step with `1`, returning itself",117,[[["self"]],["self"]]],[10,"replace_zero","","Replaces this step with `0`, returning itself",117,[[["self"]],["self"]]],[10,"add_one","","Adds one to this step, returning the result",117,[[["self"]],["self"]]],[10,"sub_one","","Subtracts one to this step, returning the result",117,[[["self"]],["self"]]],[10,"add_usize","","Add an usize, returning None on overflow",117,[[["self"],["usize"]],["option"]]],[8,"FromIterator","","Conversion from an `Iterator`.",N,N],[10,"from_iter","","Creates a value from an iterator.",118,[[["t"]],["self"]]],[8,"IntoIterator","","Conversion into an `Iterator`.",N,N],[16,"Item","","The type of the elements being iterated over.",119,N],[16,"IntoIter","","Which kind of iterator are we turning this into?",119,N],[10,"into_iter","","Creates an iterator from a value.",119,N],[8,"DoubleEndedIterator","","An iterator able to yield elements from both ends.",N,N],[10,"next_back","","Removes and returns an element from the end of the iterator.",120,[[["self"]],["option"]]],[11,"try_rfold","","This is the reverse version of [`try_fold()`]: it takes elements starting from the back of the iterator.",120,[[["self"],["b"],["f"]],["r"]]],[11,"rfold","","An iterator method that reduces the iterator's elements to a single, final value, starting from the back.",120,[[["self"],["b"],["f"]],["b"]]],[11,"rfind","","Searches for an element of an iterator from the back that satisfies a predicate.",120,[[["self"],["p"]],["option"]]],[8,"Extend","","Extend a collection with the contents of an iterator.",N,N],[10,"extend","","Extends a collection with the contents of an iterator.",121,[[["self"],["t"]]]],[8,"ExactSizeIterator","","An iterator that knows its exact length.",N,N],[11,"len","","Returns the exact number of times the iterator will iterate.",122,[[["self"]],["usize"]]],[11,"is_empty","","Returns whether the iterator is empty.",122,[[["self"]],["bool"]]],[8,"Sum","","Trait to represent types that can be created by summing up an iterator.",N,N],[10,"sum","","Method which takes an iterator and generates `Self` from the elements by \"summing up\" the items.",123,[[["i"]],["self"]]],[8,"Product","","Trait to represent types that can be created by multiplying elements of an iterator.",N,N],[10,"product","","Method which takes an iterator and generates `Self` from the elements by multiplying the items.",124,[[["i"]],["self"]]],[8,"FusedIterator","","An iterator that always continues to yield `None` when exhausted.",N,N],[8,"TrustedLen","","An iterator that reports an accurate length using size_hint.",N,N],[11,"clone","","",125,[[["self"]],["rev"]]],[11,"fmt","","",125,[[["self"],["formatter"]],["result"]]],[11,"next","","",125,[[["self"]],["option"]]],[11,"size_hint","","",125,N],[11,"try_fold","","",125,[[["self"],["b"],["f"]],["r"]]],[11,"fold","","",125,[[["self"],["acc"],["f"]],["acc"]]],[11,"find","","",125,[[["self"],["p"]],["option"]]],[11,"rposition","","",125,[[["self"],["p"]],["option",["usize"]]]],[11,"next_back","","",125,[[["self"]],["option"]]],[11,"try_rfold","","",125,[[["self"],["b"],["f"]],["r"]]],[11,"rfold","","",125,[[["self"],["acc"],["f"]],["acc"]]],[11,"rfind","","",125,[[["self"],["p"]],["option"]]],[11,"len","","",125,[[["self"]],["usize"]]],[11,"is_empty","","",125,[[["self"]],["bool"]]],[11,"clone","","",126,[[["self"]],["cloned"]]],[11,"fmt","","",126,[[["self"],["formatter"]],["result"]]],[11,"next","","",126,[[["self"]],["option"]]],[11,"size_hint","","",126,N],[11,"try_fold","","",126,[[["self"],["b"],["f"]],["r"]]],[11,"fold","","",126,[[["self"],["acc"],["f"]],["acc"]]],[11,"next_back","","",126,[[["self"]],["option"]]],[11,"try_rfold","","",126,[[["self"],["b"],["f"]],["r"]]],[11,"rfold","","",126,[[["self"],["acc"],["f"]],["acc"]]],[11,"len","","",126,[[["self"]],["usize"]]],[11,"is_empty","","",126,[[["self"]],["bool"]]],[11,"clone","","",127,[[["self"]],["cycle"]]],[11,"fmt","","",127,[[["self"],["formatter"]],["result"]]],[11,"next","","",127,[[["self"]],["option"]]],[11,"size_hint","","",127,N],[11,"clone","","",128,[[["self"]],["stepby"]]],[11,"fmt","","",128,[[["self"],["formatter"]],["result"]]],[11,"next","","",128,[[["self"]],["option"]]],[11,"size_hint","","",128,N],[11,"nth","","",128,[[["self"],["usize"]],["option"]]],[11,"clone","","",129,[[["self"]],["chain"]]],[11,"fmt","","",129,[[["self"],["formatter"]],["result"]]],[11,"next","","",129,[[["self"]],["option"]]],[11,"count","","",129,[[["self"]],["usize"]]],[11,"try_fold","","",129,[[["self"],["acc"],["f"]],["r"]]],[11,"fold","","",129,[[["self"],["acc"],["f"]],["acc"]]],[11,"nth","","",129,[[["self"],["usize"]],["option"]]],[11,"find","","",129,[[["self"],["p"]],["option"]]],[11,"last","","",129,[[["self"]],["option"]]],[11,"size_hint","","",129,N],[11,"next_back","","",129,[[["self"]],["option"]]],[11,"try_rfold","","",129,[[["self"],["acc"],["f"]],["r"]]],[11,"rfold","","",129,[[["self"],["acc"],["f"]],["acc"]]],[11,"clone","","",130,[[["self"]],["zip"]]],[11,"fmt","","",130,[[["self"],["formatter"]],["result"]]],[11,"next","","",130,[[["self"]],["option"]]],[11,"size_hint","","",130,N],[11,"nth","","",130,[[["self"],["usize"]],["option"]]],[11,"next_back","","",130,[[["self"]],["option"]]],[11,"clone","","",131,[[["self"]],["map"]]],[11,"fmt","","",131,[[["self"],["formatter"]],["result"]]],[11,"next","","",131,[[["self"]],["option"]]],[11,"size_hint","","",131,N],[11,"try_fold","","",131,[[["self"],["acc"],["g"]],["r"]]],[11,"fold","","",131,[[["self"],["acc"],["g"]],["acc"]]],[11,"next_back","","",131,[[["self"]],["option"]]],[11,"try_rfold","","",131,[[["self"],["acc"],["g"]],["r"]]],[11,"rfold","","",131,[[["self"],["acc"],["g"]],["acc"]]],[11,"len","","",131,[[["self"]],["usize"]]],[11,"is_empty","","",131,[[["self"]],["bool"]]],[11,"clone","","",132,[[["self"]],["filter"]]],[11,"fmt","","",132,[[["self"],["formatter"]],["result"]]],[11,"next","","",132,[[["self"]],["option"]]],[11,"size_hint","","",132,N],[11,"count","","",132,[[["self"]],["usize"]]],[11,"try_fold","","",132,[[["self"],["acc"],["fold"]],["r"]]],[11,"fold","","",132,[[["self"],["acc"],["fold"]],["acc"]]],[11,"next_back","","",132,[[["self"]],["option"]]],[11,"try_rfold","","",132,[[["self"],["acc"],["fold"]],["r"]]],[11,"rfold","","",132,[[["self"],["acc"],["fold"]],["acc"]]],[11,"clone","","",133,[[["self"]],["filtermap"]]],[11,"fmt","","",133,[[["self"],["formatter"]],["result"]]],[11,"next","","",133,[[["self"]],["option"]]],[11,"size_hint","","",133,N],[11,"try_fold","","",133,[[["self"],["acc"],["fold"]],["r"]]],[11,"fold","","",133,[[["self"],["acc"],["fold"]],["acc"]]],[11,"next_back","","",133,[[["self"]],["option"]]],[11,"try_rfold","","",133,[[["self"],["acc"],["fold"]],["r"]]],[11,"rfold","","",133,[[["self"],["acc"],["fold"]],["acc"]]],[11,"clone","","",134,[[["self"]],["enumerate"]]],[11,"fmt","","",134,[[["self"],["formatter"]],["result"]]],[11,"next","","Overflow Behavior",134,[[["self"]],["option"]]],[11,"size_hint","","",134,N],[11,"nth","","",134,[[["self"],["usize"]],["option"]]],[11,"count","","",134,[[["self"]],["usize"]]],[11,"try_fold","","",134,[[["self"],["acc"],["fold"]],["r"]]],[11,"fold","","",134,[[["self"],["acc"],["fold"]],["acc"]]],[11,"next_back","","",134,[[["self"]],["option"]]],[11,"try_rfold","","",134,[[["self"],["acc"],["fold"]],["r"]]],[11,"rfold","","",134,[[["self"],["acc"],["fold"]],["acc"]]],[11,"len","","",134,[[["self"]],["usize"]]],[11,"is_empty","","",134,[[["self"]],["bool"]]],[11,"clone","","",135,[[["self"]],["peekable"]]],[11,"fmt","","",135,[[["self"],["formatter"]],["result"]]],[11,"next","","",135,[[["self"]],["option"]]],[11,"count","","",135,[[["self"]],["usize"]]],[11,"nth","","",135,[[["self"],["usize"]],["option"]]],[11,"last","","",135,[[["self"]],["option"]]],[11,"size_hint","","",135,N],[11,"try_fold","","",135,[[["self"],["b"],["f"]],["r"]]],[11,"fold","","",135,[[["self"],["acc"],["fold"]],["acc"]]],[11,"peek","","Returns a reference to the next() value without advancing the iterator.",135,[[["self"]],["option"]]],[11,"clone","","",136,[[["self"]],["skipwhile"]]],[11,"fmt","","",136,[[["self"],["formatter"]],["result"]]],[11,"next","","",136,[[["self"]],["option"]]],[11,"size_hint","","",136,N],[11,"try_fold","","",136,[[["self"],["acc"],["fold"]],["r"]]],[11,"fold","","",136,[[["self"],["acc"],["fold"]],["acc"]]],[11,"clone","","",137,[[["self"]],["takewhile"]]],[11,"fmt","","",137,[[["self"],["formatter"]],["result"]]],[11,"next","","",137,[[["self"]],["option"]]],[11,"size_hint","","",137,N],[11,"try_fold","","",137,[[["self"],["acc"],["fold"]],["r"]]],[11,"clone","","",138,[[["self"]],["skip"]]],[11,"fmt","","",138,[[["self"],["formatter"]],["result"]]],[11,"next","","",138,[[["self"]],["option"]]],[11,"nth","","",138,[[["self"],["usize"]],["option"]]],[11,"count","","",138,[[["self"]],["usize"]]],[11,"last","","",138,[[["self"]],["option"]]],[11,"size_hint","","",138,N],[11,"try_fold","","",138,[[["self"],["acc"],["fold"]],["r"]]],[11,"fold","","",138,[[["self"],["acc"],["fold"]],["acc"]]],[11,"next_back","","",138,[[["self"]],["option"]]],[11,"try_rfold","","",138,[[["self"],["acc"],["fold"]],["r"]]],[11,"clone","","",139,[[["self"]],["take"]]],[11,"fmt","","",139,[[["self"],["formatter"]],["result"]]],[11,"next","","",139,[[["self"]],["option"]]],[11,"nth","","",139,[[["self"],["usize"]],["option"]]],[11,"size_hint","","",139,N],[11,"try_fold","","",139,[[["self"],["acc"],["fold"]],["r"]]],[11,"clone","","",140,[[["self"]],["scan"]]],[11,"fmt","","",140,[[["self"],["formatter"]],["result"]]],[11,"next","","",140,[[["self"]],["option"]]],[11,"size_hint","","",140,N],[11,"try_fold","","",140,[[["self"],["acc"],["fold"]],["r"]]],[11,"clone","","",141,[[["self"]],["self"]]],[11,"fmt","","",141,[[["self"],["formatter"]],["result"]]],[11,"next","","",141,[[["self"]],["option"]]],[11,"size_hint","","",141,N],[11,"try_fold","","",141,[[["self"],["acc"],["fold"]],["r"]]],[11,"fold","","",141,[[["self"],["acc"],["fold"]],["acc"]]],[11,"next_back","","",141,[[["self"]],["option"]]],[11,"try_rfold","","",141,[[["self"],["acc"],["fold"]],["r"]]],[11,"rfold","","",141,[[["self"],["acc"],["fold"]],["acc"]]],[11,"fmt","","",142,[[["self"],["formatter"]],["result"]]],[11,"clone","","",142,[[["self"]],["self"]]],[11,"next","","",142,[[["self"]],["option"]]],[11,"size_hint","","",142,N],[11,"try_fold","","",142,[[["self"],["acc"],["fold"]],["r"]]],[11,"fold","","",142,[[["self"],["acc"],["fold"]],["acc"]]],[11,"next_back","","",142,[[["self"]],["option"]]],[11,"try_rfold","","",142,[[["self"],["acc"],["fold"]],["r"]]],[11,"rfold","","",142,[[["self"],["acc"],["fold"]],["acc"]]],[11,"clone","","",143,[[["self"]],["fuse"]]],[11,"fmt","","",143,[[["self"],["formatter"]],["result"]]],[11,"next","","",143,[[["self"]],["option"]]],[11,"nth","","",143,[[["self"],["usize"]],["option"]]],[11,"last","","",143,[[["self"]],["option"]]],[11,"count","","",143,[[["self"]],["usize"]]],[11,"size_hint","","",143,N],[11,"try_fold","","",143,[[["self"],["acc"],["fold"]],["r"]]],[11,"fold","","",143,[[["self"],["acc"],["fold"]],["acc"]]],[11,"next_back","","",143,[[["self"]],["option"]]],[11,"try_rfold","","",143,[[["self"],["acc"],["fold"]],["r"]]],[11,"rfold","","",143,[[["self"],["acc"],["fold"]],["acc"]]],[11,"next","","",143,[[["self"]],["option"]]],[11,"nth","","",143,[[["self"],["usize"]],["option"]]],[11,"last","","",143,[[["self"]],["option"]]],[11,"count","","",143,[[["self"]],["usize"]]],[11,"size_hint","","",143,N],[11,"try_fold","","",143,[[["self"],["acc"],["fold"]],["r"]]],[11,"fold","","",143,[[["self"],["acc"],["fold"]],["acc"]]],[11,"next_back","","",143,[[["self"]],["option"]]],[11,"try_rfold","","",143,[[["self"],["acc"],["fold"]],["r"]]],[11,"rfold","","",143,[[["self"],["acc"],["fold"]],["acc"]]],[11,"len","","",143,[[["self"]],["usize"]]],[11,"is_empty","","",143,[[["self"]],["bool"]]],[11,"clone","","",144,[[["self"]],["inspect"]]],[11,"fmt","","",144,[[["self"],["formatter"]],["result"]]],[11,"next","","",144,[[["self"]],["option"]]],[11,"size_hint","","",144,N],[11,"try_fold","","",144,[[["self"],["acc"],["fold"]],["r"]]],[11,"fold","","",144,[[["self"],["acc"],["fold"]],["acc"]]],[11,"next_back","","",144,[[["self"]],["option"]]],[11,"try_rfold","","",144,[[["self"],["acc"],["fold"]],["r"]]],[11,"rfold","","",144,[[["self"],["acc"],["fold"]],["acc"]]],[11,"len","","",144,[[["self"]],["usize"]]],[11,"is_empty","","",144,[[["self"]],["bool"]]],[0,"option","core","Optional values.",N,N],[3,"Iter","core::option","An iterator over a reference to the [`Some`] variant of an [`Option`].",N,N],[3,"IterMut","","An iterator over a mutable reference to the [`Some`] variant of an [`Option`].",N,N],[3,"IntoIter","","An iterator over the value in [`Some`] variant of an [`Option`].",N,N],[3,"NoneError","","The error type that results from applying the try operator (`?`) to a `None` value. If you wish to allow `x?` (where `x` is an `Option<T>`) to be converted into your error type, you can implement `impl From<NoneError>` for `YourErrorType`. In that case, `x?` within a function that returns `Result<_, YourErrorType>` will translate a `None` value into an `Err` result.",N,N],[4,"Option","","The `Option` type. See the module level documentation for more.",N,N],[13,"None","","No value",145,N],[13,"Some","","Some value `T`",145,N],[11,"clone","","",145,[[["self"]],["option"]]],[11,"eq","","",145,[[["self"],["option"]],["bool"]]],[11,"ne","","",145,[[["self"],["option"]],["bool"]]],[11,"partial_cmp","","",145,[[["self"],["option"]],["option",["ordering"]]]],[11,"lt","","",145,[[["self"],["option"]],["bool"]]],[11,"le","","",145,[[["self"],["option"]],["bool"]]],[11,"gt","","",145,[[["self"],["option"]],["bool"]]],[11,"ge","","",145,[[["self"],["option"]],["bool"]]],[11,"cmp","","",145,[[["self"],["option"]],["ordering"]]],[11,"fmt","","",145,[[["self"],["formatter"]],["result"]]],[11,"hash","","",145,N],[11,"is_some","","Returns `true` if the option is a [`Some`] value.",145,[[["self"]],["bool"]]],[11,"is_none","","Returns `true` if the option is a [`None`] value.",145,[[["self"]],["bool"]]],[11,"as_ref","","Converts from `Option<T>` to `Option<&T>`.",145,[[["self"]],["option"]]],[11,"as_mut","","Converts from `Option<T>` to `Option<&mut T>`.",145,[[["self"]],["option"]]],[11,"as_pin_mut","","Converts from `Option<T>` to `Option<PinMut<'_, T>>`",145,[[["pinmut"]],["option",["pinmut"]]]],[11,"expect","","Unwraps an option, yielding the content of a [`Some`].",145,[[["self"],["str"]],["t"]]],[11,"unwrap","","Moves the value `v` out of the `Option<T>` if it is [`Some(v)`].",145,[[["self"]],["t"]]],[11,"unwrap_or","","Returns the contained value or a default.",145,[[["self"],["t"]],["t"]]],[11,"unwrap_or_else","","Returns the contained value or computes it from a closure.",145,[[["self"],["f"]],["t"]]],[11,"map","","Maps an `Option<T>` to `Option<U>` by applying a function to a contained value.",145,[[["self"],["f"]],["option"]]],[11,"map_or","","Applies a function to the contained value (if any), or returns the provided default (if not).",145,[[["self"],["u"],["f"]],["u"]]],[11,"map_or_else","","Applies a function to the contained value (if any), or computes a default (if not).",145,[[["self"],["d"],["f"]],["u"]]],[11,"ok_or","","Transforms the `Option<T>` into a [`Result<T, E>`], mapping [`Some(v)`] to [`Ok(v)`] and [`None`] to [`Err(err)`].",145,[[["self"],["e"]],["result"]]],[11,"ok_or_else","","Transforms the `Option<T>` into a [`Result<T, E>`], mapping [`Some(v)`] to [`Ok(v)`] and [`None`] to [`Err(err())`].",145,[[["self"],["f"]],["result"]]],[11,"iter","","Returns an iterator over the possibly contained value.",145,[[["self"]],["iter"]]],[11,"iter_mut","","Returns a mutable iterator over the possibly contained value.",145,[[["self"]],["itermut"]]],[11,"and","","Returns [`None`] if the option is [`None`], otherwise returns `optb`.",145,[[["self"],["option"]],["option"]]],[11,"and_then","","Returns [`None`] if the option is [`None`], otherwise calls `f` with the wrapped value and returns the result.",145,[[["self"],["f"]],["option"]]],[11,"filter","","Returns `None` if the option is `None`, otherwise calls `predicate` with the wrapped value and returns:",145,[[["self"],["p"]],["self"]]],[11,"or","","Returns the option if it contains a value, otherwise returns `optb`.",145,[[["self"],["option"]],["option"]]],[11,"or_else","","Returns the option if it contains a value, otherwise calls `f` and returns the result.",145,[[["self"],["f"]],["option"]]],[11,"xor","","Returns [`Some`] if exactly one of `self`, `optb` is [`Some`], otherwise returns `None`.",145,[[["self"],["option"]],["option"]]],[11,"get_or_insert","","Inserts `v` into the option if it is [`None`], then returns a mutable reference to the contained value.",145,[[["self"],["t"]],["t"]]],[11,"get_or_insert_with","","Inserts a value computed from `f` into the option if it is [`None`], then returns a mutable reference to the contained value.",145,[[["self"],["f"]],["t"]]],[11,"take","","Takes the value out of the option, leaving a [`None`] in its place.",145,[[["self"]],["option"]]],[11,"replace","","Replaces the actual value in the option by the value given in parameter, returning the old value if present, leaving a [`Some`] in its place without deinitializing either one.",145,[[["self"],["t"]],["option"]]],[11,"cloned","","Maps an `Option<&T>` to an `Option<T>` by cloning the contents of the option.",145,[[["self"]],["option"]]],[11,"cloned","","Maps an `Option<&mut T>` to an `Option<T>` by cloning the contents of the option.",145,[[["self"]],["option"]]],[11,"unwrap_or_default","","Returns the contained value or a default",145,[[["self"]],["t"]]],[11,"transpose","","Transposes an `Option` of a `Result` into a `Result` of an `Option`.",145,[[["self"]],["result",["option"]]]],[11,"default","","Returns [`None`].",145,[[],["option"]]],[11,"into_iter","","Returns a consuming iterator over the possibly contained value.",145,[[["self"]],["intoiter"]]],[11,"from","","",145,[[["t"]],["option"]]],[11,"fmt","","",146,[[["self"],["formatter"]],["result"]]],[11,"next","","",146,[[["self"]],["option"]]],[11,"size_hint","","",146,N],[11,"next_back","","",146,[[["self"]],["option"]]],[11,"clone","","",146,[[["self"]],["iter"]]],[11,"fmt","","",147,[[["self"],["formatter"]],["result"]]],[11,"next","","",147,[[["self"]],["option"]]],[11,"size_hint","","",147,N],[11,"next_back","","",147,[[["self"]],["option"]]],[11,"clone","","",148,[[["self"]],["intoiter"]]],[11,"fmt","","",148,[[["self"],["formatter"]],["result"]]],[11,"next","","",148,[[["self"]],["option"]]],[11,"size_hint","","",148,N],[11,"next_back","","",148,[[["self"]],["option"]]],[11,"from_iter","","Takes each element in the [`Iterator`]: if it is [`None`], no further elements are taken, and the [`None`] is returned. Should no [`None`] occur, a container with the values of each `Option` is returned.",145,[[["i"]],["option"]]],[11,"clone","","",149,[[["self"]],["noneerror"]]],[11,"eq","","",149,[[["self"],["noneerror"]],["bool"]]],[11,"partial_cmp","","",149,[[["self"],["noneerror"]],["option",["ordering"]]]],[11,"cmp","","",149,[[["self"],["noneerror"]],["ordering"]]],[11,"fmt","","",149,[[["self"],["formatter"]],["result"]]],[11,"hash","","",149,N],[11,"into_result","","",145,[[["self"]],["result",["noneerror"]]]],[11,"from_ok","","",145,[[["t"]],["self"]]],[11,"from_error","","",145,[[["noneerror"]],["self"]]],[0,"raw","core","Contains struct definitions for the layout of compiler built-in types.",N,N],[3,"TraitObject","core::raw","The representation of a trait object like `&SomeTrait`.",N,N],[12,"data","","",150,N],[12,"vtable","","",150,N],[11,"clone","","",150,[[["self"]],["traitobject"]]],[0,"result","core","Error handling with the `Result` type.",N,N],[3,"Iter","core::result","An iterator over a reference to the [`Ok`] variant of a [`Result`].",N,N],[3,"IterMut","","An iterator over a mutable reference to the [`Ok`] variant of a [`Result`].",N,N],[3,"IntoIter","","An iterator over the value in a [`Ok`] variant of a [`Result`].",N,N],[4,"Result","","`Result` is a type that represents either success ([`Ok`]) or failure ([`Err`]).",N,N],[13,"Ok","","Contains the success value",151,N],[13,"Err","","Contains the error value",151,N],[11,"clone","","",151,[[["self"]],["result"]]],[11,"eq","","",151,[[["self"],["result"]],["bool"]]],[11,"ne","","",151,[[["self"],["result"]],["bool"]]],[11,"partial_cmp","","",151,[[["self"],["result"]],["option",["ordering"]]]],[11,"lt","","",151,[[["self"],["result"]],["bool"]]],[11,"le","","",151,[[["self"],["result"]],["bool"]]],[11,"gt","","",151,[[["self"],["result"]],["bool"]]],[11,"ge","","",151,[[["self"],["result"]],["bool"]]],[11,"cmp","","",151,[[["self"],["result"]],["ordering"]]],[11,"fmt","","",151,[[["self"],["formatter"]],["result"]]],[11,"hash","","",151,N],[11,"is_ok","","Returns `true` if the result is [`Ok`].",151,[[["self"]],["bool"]]],[11,"is_err","","Returns `true` if the result is [`Err`].",151,[[["self"]],["bool"]]],[11,"ok","","Converts from `Result<T, E>` to [`Option<T>`].",151,[[["self"]],["option"]]],[11,"err","","Converts from `Result<T, E>` to [`Option<E>`].",151,[[["self"]],["option"]]],[11,"as_ref","","Converts from `Result<T, E>` to `Result<&T, &E>`.",151,[[["self"]],["result"]]],[11,"as_mut","","Converts from `Result<T, E>` to `Result<&mut T, &mut E>`.",151,[[["self"]],["result"]]],[11,"map","","Maps a `Result<T, E>` to `Result<U, E>` by applying a function to a contained [`Ok`] value, leaving an [`Err`] value untouched.",151,[[["self"],["f"]],["result"]]],[11,"map_err","","Maps a `Result<T, E>` to `Result<T, F>` by applying a function to a contained [`Err`] value, leaving an [`Ok`] value untouched.",151,[[["self"],["o"]],["result"]]],[11,"iter","","Returns an iterator over the possibly contained value.",151,[[["self"]],["iter"]]],[11,"iter_mut","","Returns a mutable iterator over the possibly contained value.",151,[[["self"]],["itermut"]]],[11,"and","","Returns `res` if the result is [`Ok`], otherwise returns the [`Err`] value of `self`.",151,[[["self"],["result"]],["result"]]],[11,"and_then","","Calls `op` if the result is [`Ok`], otherwise returns the [`Err`] value of `self`.",151,[[["self"],["f"]],["result"]]],[11,"or","","Returns `res` if the result is [`Err`], otherwise returns the [`Ok`] value of `self`.",151,[[["self"],["result"]],["result"]]],[11,"or_else","","Calls `op` if the result is [`Err`], otherwise returns the [`Ok`] value of `self`.",151,[[["self"],["o"]],["result"]]],[11,"unwrap_or","","Unwraps a result, yielding the content of an [`Ok`]. Else, it returns `optb`.",151,[[["self"],["t"]],["t"]]],[11,"unwrap_or_else","","Unwraps a result, yielding the content of an [`Ok`]. If the value is an [`Err`] then it calls `op` with its value.",151,[[["self"],["f"]],["t"]]],[11,"unwrap","","Unwraps a result, yielding the content of an [`Ok`].",151,[[["self"]],["t"]]],[11,"expect","","Unwraps a result, yielding the content of an [`Ok`].",151,[[["self"],["str"]],["t"]]],[11,"unwrap_err","","Unwraps a result, yielding the content of an [`Err`].",151,[[["self"]],["e"]]],[11,"expect_err","","Unwraps a result, yielding the content of an [`Err`].",151,[[["self"],["str"]],["e"]]],[11,"unwrap_or_default","","Returns the contained value or a default",151,[[["self"]],["t"]]],[11,"transpose","","Transposes a `Result` of an `Option` into an `Option` of a `Result`.",151,[[["self"]],["option",["result"]]]],[11,"into_iter","","Returns a consuming iterator over the possibly contained value.",151,[[["self"]],["intoiter"]]],[11,"fmt","","",152,[[["self"],["formatter"]],["result"]]],[11,"next","","",152,[[["self"]],["option"]]],[11,"size_hint","","",152,N],[11,"next_back","","",152,[[["self"]],["option"]]],[11,"clone","","",152,[[["self"]],["iter"]]],[11,"fmt","","",153,[[["self"],["formatter"]],["result"]]],[11,"next","","",153,[[["self"]],["option"]]],[11,"size_hint","","",153,N],[11,"next_back","","",153,[[["self"]],["option"]]],[11,"clone","","",154,[[["self"]],["intoiter"]]],[11,"fmt","","",154,[[["self"],["formatter"]],["result"]]],[11,"next","","",154,[[["self"]],["option"]]],[11,"size_hint","","",154,N],[11,"next_back","","",154,[[["self"]],["option"]]],[11,"from_iter","","Takes each element in the `Iterator`: if it is an `Err`, no further elements are taken, and the `Err` is returned. Should no `Err` occur, a container with the values of each `Result` is returned.",151,[[["i"]],["result"]]],[11,"into_result","","",151,[[["self"]],["self"]]],[11,"from_ok","","",151,[[["t"]],["self"]]],[11,"from_error","","",151,[[["e"]],["self"]]],[0,"slice","core","Slice management and manipulation",N,N],[3,"Iter","core::slice","Immutable slice iterator",N,N],[3,"IterMut","","Mutable slice iterator.",N,N],[3,"Split","","An iterator over subslices separated by elements that match a predicate function.",N,N],[3,"SplitMut","","An iterator over the subslices of the vector which are separated by elements that match `pred`.",N,N],[3,"RSplit","","An iterator over subslices separated by elements that match a predicate function, starting from the end of the slice.",N,N],[3,"RSplitMut","","An iterator over the subslices of the vector which are separated by elements that match `pred`, starting from the end of the slice.",N,N],[3,"SplitN","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits.",N,N],[3,"RSplitN","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits, starting from the end of the slice.",N,N],[3,"SplitNMut","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits.",N,N],[3,"RSplitNMut","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits, starting from the end of the slice.",N,N],[3,"Windows","","An iterator over overlapping subslices of length `size`.",N,N],[3,"Chunks","","An iterator over a slice in (non-overlapping) chunks (`chunk_size` elements at a time).",N,N],[3,"ChunksMut","","An iterator over a slice in (non-overlapping) mutable chunks (`chunk_size` elements at a time). When the slice len is not evenly divided by the chunk size, the last slice of the iteration will be the remainder.",N,N],[3,"ExactChunks","","An iterator over a slice in (non-overlapping) chunks (`chunk_size` elements at a time).",N,N],[3,"ExactChunksMut","","An iterator over a slice in (non-overlapping) mutable chunks (`chunk_size` elements at a time).",N,N],[5,"from_raw_parts","","Forms a slice from a pointer and a length.",N,N],[5,"from_raw_parts_mut","","Performs the same functionality as `from_raw_parts`, except that a mutable slice is returned.",N,N],[5,"from_ref","","Converts a reference to T into a slice of length 1 (without copying).",N,N],[5,"from_mut","","Converts a reference to T into a slice of length 1 (without copying).",N,N],[0,"memchr","","Pure rust memchr implementation, taken from rust-memchr",N,N],[5,"memchr","core::slice::memchr","Return the first index matching the byte `x` in `text`.",N,N],[5,"memrchr","","Return the last index matching the byte `x` in `text`.",N,N],[8,"SliceIndex","core::slice","A helper trait used for indexing operations.",N,N],[16,"Output","","The output type returned by methods.",155,N],[10,"get","","Returns a shared reference to the output at this location, if in bounds.",155,[[["self"],["t"]],["option"]]],[10,"get_mut","","Returns a mutable reference to the output at this location, if in bounds.",155,[[["self"],["t"]],["option"]]],[10,"get_unchecked","","Returns a shared reference to the output at this location, without performing any bounds checking.",155,N],[10,"get_unchecked_mut","","Returns a mutable reference to the output at this location, without performing any bounds checking.",155,N],[10,"index","","Returns a shared reference to the output at this location, panicking if out of bounds.",155,N],[10,"index_mut","","Returns a mutable reference to the output at this location, panicking if out of bounds.",155,N],[11,"get","core::ops","",17,N],[11,"get_mut","","",17,N],[11,"get_unchecked","","",17,N],[11,"get_unchecked_mut","","",17,N],[11,"index","","",17,N],[11,"index_mut","","",17,N],[11,"get","","",19,N],[11,"get_mut","","",19,N],[11,"get_unchecked","","",19,N],[11,"get_unchecked_mut","","",19,N],[11,"index","","",19,N],[11,"index_mut","","",19,N],[11,"get","","",18,N],[11,"get_mut","","",18,N],[11,"get_unchecked","","",18,N],[11,"get_unchecked_mut","","",18,N],[11,"index","","",18,N],[11,"index_mut","","",18,N],[11,"get","","",23,N],[11,"get_mut","","",23,N],[11,"get_unchecked","","",23,N],[11,"get_unchecked_mut","","",23,N],[11,"index","","",23,N],[11,"index_mut","","",23,N],[11,"get","","",24,N],[11,"get_mut","","",24,N],[11,"get_unchecked","","",24,N],[11,"get_unchecked_mut","","",24,N],[11,"index","","",24,N],[11,"index_mut","","",24,N],[11,"get","","",20,N],[11,"get_mut","","",20,N],[11,"get_unchecked","","",20,N],[11,"get_unchecked_mut","","",20,N],[11,"index","","",20,N],[11,"index_mut","","",20,N],[11,"fmt","core::slice","",156,[[["self"],["formatter"]],["result"]]],[11,"as_slice","","View the underlying data as a subslice of the original data.",156,N],[11,"next","","",156,[[["self"]],["option"]]],[11,"size_hint","","",156,N],[11,"count","","",156,[[["self"]],["usize"]]],[11,"nth","","",156,[[["self"],["usize"]],["option"]]],[11,"last","","",156,[[["self"]],["option"]]],[11,"try_fold","","",156,[[["self"],["b"],["f"]],["r"]]],[11,"fold","","",156,[[["self"],["acc"],["fold"]],["acc"]]],[11,"position","","",156,[[["self"],["p"]],["option",["usize"]]]],[11,"rposition","","",156,[[["self"],["p"]],["option",["usize"]]]],[11,"next_back","","",156,[[["self"]],["option"]]],[11,"try_rfold","","",156,[[["self"],["b"],["f"]],["r"]]],[11,"rfold","","",156,[[["self"],["acc"],["fold"]],["acc"]]],[11,"is_empty","","",156,[[["self"]],["bool"]]],[11,"clone","","",156,[[["self"]],["iter"]]],[11,"as_ref","","",156,N],[11,"fmt","","",157,[[["self"],["formatter"]],["result"]]],[11,"into_slice","","View the underlying data as a subslice of the original data.",157,N],[11,"next","","",157,[[["self"]],["option"]]],[11,"size_hint","","",157,N],[11,"count","","",157,[[["self"]],["usize"]]],[11,"nth","","",157,[[["self"],["usize"]],["option"]]],[11,"last","","",157,[[["self"]],["option"]]],[11,"try_fold","","",157,[[["self"],["b"],["f"]],["r"]]],[11,"fold","","",157,[[["self"],["acc"],["fold"]],["acc"]]],[11,"position","","",157,[[["self"],["p"]],["option",["usize"]]]],[11,"rposition","","",157,[[["self"],["p"]],["option",["usize"]]]],[11,"next_back","","",157,[[["self"]],["option"]]],[11,"try_rfold","","",157,[[["self"],["b"],["f"]],["r"]]],[11,"rfold","","",157,[[["self"],["acc"],["fold"]],["acc"]]],[11,"is_empty","","",157,[[["self"]],["bool"]]],[11,"fmt","","",158,[[["self"],["formatter"]],["result"]]],[11,"clone","","",158,[[["self"]],["split"]]],[11,"next","","",158,[[["self"]],["option"]]],[11,"size_hint","","",158,N],[11,"next_back","","",158,[[["self"]],["option"]]],[11,"fmt","","",159,[[["self"],["formatter"]],["result"]]],[11,"next","","",159,[[["self"]],["option"]]],[11,"size_hint","","",159,N],[11,"next_back","","",159,[[["self"]],["option"]]],[11,"clone","","",160,[[["self"]],["rsplit"]]],[11,"fmt","","",160,[[["self"],["formatter"]],["result"]]],[11,"next","","",160,[[["self"]],["option"]]],[11,"size_hint","","",160,N],[11,"next_back","","",160,[[["self"]],["option"]]],[11,"fmt","","",161,[[["self"],["formatter"]],["result"]]],[11,"next","","",161,[[["self"]],["option"]]],[11,"size_hint","","",161,N],[11,"next_back","","",161,[[["self"]],["option"]]],[11,"fmt","","",162,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",163,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",164,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",165,[[["self"],["formatter"]],["result"]]],[11,"next","","",162,[[["self"]],["option"]]],[11,"size_hint","","",162,N],[11,"next","","",163,[[["self"]],["option"]]],[11,"size_hint","","",163,N],[11,"next","","",164,[[["self"]],["option"]]],[11,"size_hint","","",164,N],[11,"next","","",165,[[["self"]],["option"]]],[11,"size_hint","","",165,N],[11,"fmt","","",166,[[["self"],["formatter"]],["result"]]],[11,"clone","","",166,[[["self"]],["windows"]]],[11,"next","","",166,[[["self"]],["option"]]],[11,"size_hint","","",166,N],[11,"count","","",166,[[["self"]],["usize"]]],[11,"nth","","",166,[[["self"],["usize"]],["option"]]],[11,"last","","",166,[[["self"]],["option"]]],[11,"next_back","","",166,[[["self"]],["option"]]],[11,"fmt","","",167,[[["self"],["formatter"]],["result"]]],[11,"clone","","",167,[[["self"]],["chunks"]]],[11,"next","","",167,[[["self"]],["option"]]],[11,"size_hint","","",167,N],[11,"count","","",167,[[["self"]],["usize"]]],[11,"nth","","",167,[[["self"],["usize"]],["option"]]],[11,"last","","",167,[[["self"]],["option"]]],[11,"next_back","","",167,[[["self"]],["option"]]],[11,"fmt","","",168,[[["self"],["formatter"]],["result"]]],[11,"next","","",168,[[["self"]],["option"]]],[11,"size_hint","","",168,N],[11,"count","","",168,[[["self"]],["usize"]]],[11,"nth","","",168,[[["self"],["usize"]],["option"]]],[11,"last","","",168,[[["self"]],["option"]]],[11,"next_back","","",168,[[["self"]],["option"]]],[11,"fmt","","",169,[[["self"],["formatter"]],["result"]]],[11,"remainder","","Return the remainder of the original slice that is not going to be returned by the iterator. The returned slice has at most `chunk_size-1` elements.",169,N],[11,"clone","","",169,[[["self"]],["exactchunks"]]],[11,"next","","",169,[[["self"]],["option"]]],[11,"size_hint","","",169,N],[11,"count","","",169,[[["self"]],["usize"]]],[11,"nth","","",169,[[["self"],["usize"]],["option"]]],[11,"last","","",169,[[["self"]],["option"]]],[11,"next_back","","",169,[[["self"]],["option"]]],[11,"is_empty","","",169,[[["self"]],["bool"]]],[11,"fmt","","",170,[[["self"],["formatter"]],["result"]]],[11,"into_remainder","","Return the remainder of the original slice that is not going to be returned by the iterator. The returned slice has at most `chunk_size-1` elements.",170,N],[11,"next","","",170,[[["self"]],["option"]]],[11,"size_hint","","",170,N],[11,"count","","",170,[[["self"]],["usize"]]],[11,"nth","","",170,[[["self"],["usize"]],["option"]]],[11,"last","","",170,[[["self"]],["option"]]],[11,"next_back","","",170,[[["self"]],["option"]]],[11,"is_empty","","",170,[[["self"]],["bool"]]],[0,"str","core","String manipulation",N,N],[3,"ParseBoolError","core::str","An error returned when parsing a `bool` using [`from_str`] fails",N,N],[3,"Utf8Error","","Errors which can occur when attempting to interpret a sequence of [`u8`] as a string.",N,N],[3,"Chars","","An iterator over the [`char`]s of a string slice.",N,N],[3,"CharIndices","","An iterator over the [`char`]s of a string slice, and their positions.",N,N],[3,"Bytes","","An iterator over the bytes of a string slice.",N,N],[3,"Split","","Created with the method [`split`].",N,N],[3,"RSplit","","Created with the method [`rsplit`].",N,N],[3,"SplitTerminator","","Created with the method [`split_terminator`].",N,N],[3,"RSplitTerminator","","Created with the method [`rsplit_terminator`].",N,N],[3,"SplitN","","Created with the method [`splitn`].",N,N],[3,"RSplitN","","Created with the method [`rsplitn`].",N,N],[3,"MatchIndices","","Created with the method [`match_indices`].",N,N],[3,"RMatchIndices","","Created with the method [`rmatch_indices`].",N,N],[3,"Matches","","Created with the method [`matches`].",N,N],[3,"RMatches","","Created with the method [`rmatches`].",N,N],[3,"Lines","","An iterator over the lines of a string, as string slices.",N,N],[3,"LinesAny","","Created with the method [`lines_any`].",N,N],[3,"SplitWhitespace","","An iterator over the non-whitespace substrings of a string, separated by any amount of whitespace.",N,N],[3,"SplitAsciiWhitespace","","An iterator over the non-ASCII-whitespace substrings of a string, separated by any amount of ASCII whitespace.",N,N],[3,"EncodeUtf16","","An iterator of [`u16`] over the string encoded as UTF-16.",N,N],[5,"from_utf8","","Converts a slice of bytes to a string slice.",N,N],[5,"from_utf8_mut","","Converts a mutable slice of bytes to a mutable string slice.",N,N],[5,"from_utf8_unchecked","","Converts a slice of bytes to a string slice without checking that the string contains valid UTF-8.",N,N],[5,"from_utf8_unchecked_mut","","Converts a slice of bytes to a string slice without checking that the string contains valid UTF-8; mutable version.",N,N],[5,"next_code_point","","Reads the next code point out of a byte iterator (assuming a UTF-8-like encoding).",N,[[["i"]],["option",["u32"]]]],[5,"utf8_char_width","","Given a first byte, determines how many bytes are in this UTF-8 character.",N,[[["u8"]],["usize"]]],[0,"pattern","","The string Pattern API.",N,N],[3,"CharSearcher","core::str::pattern","Associated type for `<char as Pattern<'a>>::Searcher`.",N,N],[3,"CharSliceSearcher","","Associated type for `<&[char] as Pattern<'a>>::Searcher`.",N,N],[3,"CharPredicateSearcher","","Associated type for `<F as Pattern<'a>>::Searcher`.",N,N],[3,"StrSearcher","","Associated type for `<&str as Pattern<'a>>::Searcher`.",N,N],[4,"SearchStep","","Result of calling `Searcher::next()` or `ReverseSearcher::next_back()`.",N,N],[13,"Match","","Expresses that a match of the pattern has been found at `haystack[a..b]`.",171,N],[13,"Reject","","Expresses that `haystack[a..b]` has been rejected as a possible match of the pattern.",171,N],[13,"Done","","Expresses that every byte of the haystack has been visited, ending the iteration.",171,N],[8,"Pattern","","A string pattern.",N,N],[16,"Searcher","","Associated searcher for this pattern",172,N],[10,"into_searcher","","Constructs the associated searcher from `self` and the `haystack` to search in.",172,N],[11,"is_contained_in","","Checks whether the pattern matches anywhere in the haystack",172,[[["self"],["str"]],["bool"]]],[11,"is_prefix_of","","Checks whether the pattern matches at the front of the haystack",172,[[["self"],["str"]],["bool"]]],[11,"is_suffix_of","","Checks whether the pattern matches at the back of the haystack",172,[[["self"],["str"]],["bool"]]],[8,"Searcher","","A searcher for a string pattern.",N,N],[10,"haystack","","Getter for the underlying string to be searched in",173,[[["self"]],["str"]]],[10,"next","","Performs the next search step starting from the front.",173,[[["self"]],["searchstep"]]],[11,"next_match","","Find the next `Match` result. See `next()`",173,[[["self"]],["option"]]],[11,"next_reject","","Find the next `Reject` result. See `next()` and `next_match()`",173,[[["self"]],["option"]]],[8,"ReverseSearcher","","A reverse searcher for a string pattern.",N,N],[10,"next_back","","Performs the next search step starting from the back.",174,[[["self"]],["searchstep"]]],[11,"next_match_back","","Find the next `Match` result. See `next_back()`",174,[[["self"]],["option"]]],[11,"next_reject_back","","Find the next `Reject` result. See `next_back()`",174,[[["self"]],["option"]]],[8,"DoubleEndedSearcher","","A marker trait to express that a `ReverseSearcher` can be used for a `DoubleEndedIterator` implementation.",N,N],[11,"clone","","",171,[[["self"]],["searchstep"]]],[11,"eq","","",171,[[["self"],["searchstep"]],["bool"]]],[11,"ne","","",171,[[["self"],["searchstep"]],["bool"]]],[11,"fmt","","",171,[[["self"],["formatter"]],["result"]]],[11,"clone","","",175,[[["self"]],["charsearcher"]]],[11,"fmt","","",175,[[["self"],["formatter"]],["result"]]],[11,"haystack","","",175,[[["self"]],["str"]]],[11,"next","","",175,[[["self"]],["searchstep"]]],[11,"next_match","","",175,[[["self"]],["option"]]],[11,"next_back","","",175,[[["self"]],["searchstep"]]],[11,"next_match_back","","",175,[[["self"]],["option"]]],[11,"clone","","",176,[[["self"]],["charslicesearcher"]]],[11,"fmt","","",176,[[["self"],["formatter"]],["result"]]],[11,"haystack","","",176,[[["self"]],["str"]]],[11,"next","","",176,[[["self"]],["searchstep"]]],[11,"next_match","","",176,[[["self"]],["option"]]],[11,"next_reject","","",176,[[["self"]],["option"]]],[11,"next_back","","",176,[[["self"]],["searchstep"]]],[11,"next_match_back","","",176,[[["self"]],["option"]]],[11,"next_reject_back","","",176,[[["self"]],["option"]]],[11,"clone","","",177,[[["self"]],["charpredicatesearcher"]]],[11,"fmt","","",177,[[["self"],["formatter"]],["result"]]],[11,"haystack","","",177,[[["self"]],["str"]]],[11,"next","","",177,[[["self"]],["searchstep"]]],[11,"next_match","","",177,[[["self"]],["option"]]],[11,"next_reject","","",177,[[["self"]],["option"]]],[11,"next_back","","",177,[[["self"]],["searchstep"]]],[11,"next_match_back","","",177,[[["self"]],["option"]]],[11,"next_reject_back","","",177,[[["self"]],["option"]]],[11,"clone","","",178,[[["self"]],["strsearcher"]]],[11,"fmt","","",178,[[["self"],["formatter"]],["result"]]],[11,"haystack","","",178,[[["self"]],["str"]]],[11,"next","","",178,[[["self"]],["searchstep"]]],[11,"next_match","","",178,[[["self"]],["option"]]],[11,"next_back","","",178,[[["self"]],["searchstep"]]],[11,"next_match_back","","",178,[[["self"]],["option"]]],[0,"lossy","core::str","",N,N],[3,"Utf8Lossy","core::str::lossy","Lossy UTF-8 string.",N,N],[3,"Utf8LossyChunksIter","","Iterator over lossy UTF-8 string",N,N],[3,"Utf8LossyChunk","","",N,N],[12,"valid","","Sequence of valid chars. Can be empty between broken UTF-8 chars.",179,N],[12,"broken","","Single broken char, empty if none. Empty iff iterator item is last.",179,N],[11,"from_str","","",180,[[["str"]],["utf8lossy"]]],[11,"from_bytes","","",180,N],[11,"chunks","","",180,[[["self"]],["utf8lossychunksiter"]]],[11,"eq","","",179,[[["self"],["utf8lossychunk"]],["bool"]]],[11,"ne","","",179,[[["self"],["utf8lossychunk"]],["bool"]]],[11,"fmt","","",179,[[["self"],["formatter"]],["result"]]],[11,"next","","",181,[[["self"]],["option",["utf8lossychunk"]]]],[11,"fmt","","",180,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",180,[[["self"],["formatter"]],["result"]]],[11,"get","core::ops","",23,[[["self"],["str"]],["option"]]],[11,"get_mut","","",23,[[["self"],["str"]],["option"]]],[11,"get_unchecked","","",23,N],[11,"get_unchecked_mut","","",23,N],[11,"index","","",23,N],[11,"index_mut","","",23,N],[11,"get","","",17,[[["self"],["str"]],["option"]]],[11,"get_mut","","",17,[[["self"],["str"]],["option"]]],[11,"get_unchecked","","",17,N],[11,"get_unchecked_mut","","",17,N],[11,"index","","",17,N],[11,"index_mut","","",17,N],[11,"get","","",19,[[["self"],["str"]],["option"]]],[11,"get_mut","","",19,[[["self"],["str"]],["option"]]],[11,"get_unchecked","","",19,N],[11,"get_unchecked_mut","","",19,N],[11,"index","","",19,N],[11,"index_mut","","",19,N],[11,"get","","",18,[[["self"],["str"]],["option"]]],[11,"get_mut","","",18,[[["self"],["str"]],["option"]]],[11,"get_unchecked","","",18,N],[11,"get_unchecked_mut","","",18,N],[11,"index","","",18,N],[11,"index_mut","","",18,N],[11,"get","","",24,[[["self"],["str"]],["option"]]],[11,"get_mut","","",24,[[["self"],["str"]],["option"]]],[11,"get_unchecked","","",24,N],[11,"get_unchecked_mut","","",24,N],[11,"index","","",24,N],[11,"index_mut","","",24,N],[11,"get","","",20,[[["self"],["str"]],["option"]]],[11,"get_mut","","",20,[[["self"],["str"]],["option"]]],[11,"get_unchecked","","",20,N],[11,"get_unchecked_mut","","",20,N],[11,"index","","",20,N],[11,"index_mut","","",20,N],[8,"FromStr","core::str","A trait to abstract the idea of creating a new instance of a type from a string.",N,N],[16,"Err","","The associated error which can be returned from parsing.",182,N],[10,"from_str","","Parses a string `s` to return a value of this type.",182,[[["str"]],["result"]]],[11,"fmt","","",183,[[["self"],["formatter"]],["result"]]],[11,"clone","","",183,[[["self"]],["parseboolerror"]]],[11,"eq","","",183,[[["self"],["parseboolerror"]],["bool"]]],[11,"ne","","",183,[[["self"],["parseboolerror"]],["bool"]]],[11,"fmt","","",183,[[["self"],["formatter"]],["result"]]],[11,"eq","","",184,[[["self"],["utf8error"]],["bool"]]],[11,"ne","","",184,[[["self"],["utf8error"]],["bool"]]],[11,"clone","","",184,[[["self"]],["utf8error"]]],[11,"fmt","","",184,[[["self"],["formatter"]],["result"]]],[11,"valid_up_to","","Returns the index in the given string up to which valid UTF-8 was verified.",184,[[["self"]],["usize"]]],[11,"error_len","","Provide more information about the failure:",184,[[["self"]],["option",["usize"]]]],[11,"fmt","","",184,[[["self"],["formatter"]],["result"]]],[11,"clone","","",185,[[["self"]],["chars"]]],[11,"fmt","","",185,[[["self"],["formatter"]],["result"]]],[11,"next","","",185,[[["self"]],["option",["char"]]]],[11,"count","","",185,[[["self"]],["usize"]]],[11,"size_hint","","",185,N],[11,"last","","",185,[[["self"]],["option",["char"]]]],[11,"next_back","","",185,[[["self"]],["option",["char"]]]],[11,"as_str","","View the underlying data as a subslice of the original data.",185,[[["self"]],["str"]]],[11,"clone","","",186,[[["self"]],["charindices"]]],[11,"fmt","","",186,[[["self"],["formatter"]],["result"]]],[11,"next","","",186,[[["self"]],["option"]]],[11,"count","","",186,[[["self"]],["usize"]]],[11,"size_hint","","",186,N],[11,"last","","",186,[[["self"]],["option"]]],[11,"next_back","","",186,[[["self"]],["option"]]],[11,"as_str","","View the underlying data as a subslice of the original data.",186,[[["self"]],["str"]]],[11,"clone","","",187,[[["self"]],["bytes"]]],[11,"fmt","","",187,[[["self"],["formatter"]],["result"]]],[11,"next","","",187,[[["self"]],["option",["u8"]]]],[11,"size_hint","","",187,N],[11,"count","","",187,[[["self"]],["usize"]]],[11,"last","","",187,[[["self"]],["option"]]],[11,"nth","","",187,[[["self"],["usize"]],["option"]]],[11,"all","","",187,[[["self"],["f"]],["bool"]]],[11,"any","","",187,[[["self"],["f"]],["bool"]]],[11,"find","","",187,[[["self"],["p"]],["option"]]],[11,"position","","",187,[[["self"],["p"]],["option",["usize"]]]],[11,"rposition","","",187,[[["self"],["p"]],["option",["usize"]]]],[11,"next_back","","",187,[[["self"]],["option",["u8"]]]],[11,"rfind","","",187,[[["self"],["p"]],["option"]]],[11,"len","","",187,[[["self"]],["usize"]]],[11,"is_empty","","",187,[[["self"]],["bool"]]],[11,"fmt","","",188,[[["self"],["formatter"]],["result"]]],[11,"next","","",188,[[["self"]],["option",["str"]]]],[11,"clone","","",188,[[["self"]],["self"]]],[11,"fmt","","",189,[[["self"],["formatter"]],["result"]]],[11,"next","","",189,[[["self"]],["option",["str"]]]],[11,"clone","","",189,[[["self"]],["self"]]],[11,"next_back","","",188,[[["self"]],["option",["str"]]]],[11,"next_back","","",189,[[["self"]],["option",["str"]]]],[11,"fmt","","",190,[[["self"],["formatter"]],["result"]]],[11,"next","","",190,[[["self"]],["option",["str"]]]],[11,"clone","","",190,[[["self"]],["self"]]],[11,"fmt","","",191,[[["self"],["formatter"]],["result"]]],[11,"next","","",191,[[["self"]],["option",["str"]]]],[11,"clone","","",191,[[["self"]],["self"]]],[11,"next_back","","",190,[[["self"]],["option",["str"]]]],[11,"next_back","","",191,[[["self"]],["option",["str"]]]],[11,"fmt","","",192,[[["self"],["formatter"]],["result"]]],[11,"next","","",192,[[["self"]],["option",["str"]]]],[11,"clone","","",192,[[["self"]],["self"]]],[11,"fmt","","",193,[[["self"],["formatter"]],["result"]]],[11,"next","","",193,[[["self"]],["option",["str"]]]],[11,"clone","","",193,[[["self"]],["self"]]],[11,"fmt","","",194,[[["self"],["formatter"]],["result"]]],[11,"next","","",194,[[["self"]],["option"]]],[11,"clone","","",194,[[["self"]],["self"]]],[11,"fmt","","",195,[[["self"],["formatter"]],["result"]]],[11,"next","","",195,[[["self"]],["option"]]],[11,"clone","","",195,[[["self"]],["self"]]],[11,"next_back","","",194,[[["self"]],["option"]]],[11,"next_back","","",195,[[["self"]],["option"]]],[11,"fmt","","",196,[[["self"],["formatter"]],["result"]]],[11,"next","","",196,[[["self"]],["option",["str"]]]],[11,"clone","","",196,[[["self"]],["self"]]],[11,"fmt","","",197,[[["self"],["formatter"]],["result"]]],[11,"next","","",197,[[["self"]],["option",["str"]]]],[11,"clone","","",197,[[["self"]],["self"]]],[11,"next_back","","",196,[[["self"]],["option",["str"]]]],[11,"next_back","","",197,[[["self"]],["option",["str"]]]],[11,"clone","","",198,[[["self"]],["lines"]]],[11,"fmt","","",198,[[["self"],["formatter"]],["result"]]],[11,"next","","",198,[[["self"]],["option",["str"]]]],[11,"size_hint","","",198,N],[11,"next_back","","",198,[[["self"]],["option",["str"]]]],[11,"clone","","",199,[[["self"]],["linesany"]]],[11,"fmt","","",199,[[["self"],["formatter"]],["result"]]],[11,"next","","",199,[[["self"]],["option",["str"]]]],[11,"size_hint","","",199,N],[11,"next_back","","",199,[[["self"]],["option",["str"]]]],[11,"clone","","",200,[[["self"]],["splitwhitespace"]]],[11,"fmt","","",200,[[["self"],["formatter"]],["result"]]],[11,"clone","","",201,[[["self"]],["splitasciiwhitespace"]]],[11,"fmt","","",201,[[["self"],["formatter"]],["result"]]],[11,"next","","",200,[[["self"]],["option",["str"]]]],[11,"size_hint","","",200,N],[11,"next_back","","",200,[[["self"]],["option",["str"]]]],[11,"next","","",201,[[["self"]],["option",["str"]]]],[11,"size_hint","","",201,N],[11,"next_back","","",201,[[["self"]],["option",["str"]]]],[11,"clone","","",202,[[["self"]],["encodeutf16"]]],[11,"fmt","","",202,[[["self"],["formatter"]],["result"]]],[11,"next","","",202,[[["self"]],["option",["u16"]]]],[11,"size_hint","","",202,N],[0,"hash","core","Generic hashing support.",N,N],[3,"SipHasher","core::hash","An implementation of SipHash 2-4.",N,N],[3,"BuildHasherDefault","","Used to create a default [`BuildHasher`] instance for types that implement [`Hasher`] and [`Default`].",N,N],[11,"fmt","","",203,[[["self"],["formatter"]],["result"]]],[11,"clone","","",203,[[["self"]],["siphasher"]]],[11,"default","","",203,[[],["siphasher"]]],[11,"new","","Creates a new `SipHasher` with the two initial keys set to 0.",203,[[],["siphasher"]]],[11,"new_with_keys","","Creates a `SipHasher` that is keyed off the provided keys.",203,[[["u64"],["u64"]],["siphasher"]]],[11,"write","","",203,N],[11,"finish","","",203,[[["self"]],["u64"]]],[8,"Hash","","A hashable type.",N,N],[10,"hash","","Feeds this value into the given [`Hasher`].",204,[[["self"],["h"]]]],[11,"hash_slice","","Feeds a slice of this type into the given [`Hasher`].",204,N],[8,"Hasher","","A trait for hashing an arbitrary stream of bytes.",N,N],[10,"finish","","Returns the hash value for the values written so far.",205,[[["self"]],["u64"]]],[10,"write","","Writes some data into this `Hasher`.",205,N],[11,"write_u8","","Writes a single `u8` into this hasher.",205,[[["self"],["u8"]]]],[11,"write_u16","","Writes a single `u16` into this hasher.",205,[[["self"],["u16"]]]],[11,"write_u32","","Writes a single `u32` into this hasher.",205,[[["self"],["u32"]]]],[11,"write_u64","","Writes a single `u64` into this hasher.",205,[[["self"],["u64"]]]],[11,"write_u128","","Writes a single `u128` into this hasher.",205,[[["self"],["u128"]]]],[11,"write_usize","","Writes a single `usize` into this hasher.",205,[[["self"],["usize"]]]],[11,"write_i8","","Writes a single `i8` into this hasher.",205,[[["self"],["i8"]]]],[11,"write_i16","","Writes a single `i16` into this hasher.",205,[[["self"],["i16"]]]],[11,"write_i32","","Writes a single `i32` into this hasher.",205,[[["self"],["i32"]]]],[11,"write_i64","","Writes a single `i64` into this hasher.",205,[[["self"],["i64"]]]],[11,"write_i128","","Writes a single `i128` into this hasher.",205,[[["self"],["i128"]]]],[11,"write_isize","","Writes a single `isize` into this hasher.",205,[[["self"],["isize"]]]],[8,"BuildHasher","","A trait for creating instances of [`Hasher`].",N,N],[16,"Hasher","","Type of the hasher that will be created.",206,N],[10,"build_hasher","","Creates a new hasher.",206,N],[11,"fmt","","",207,[[["self"],["formatter"]],["result"]]],[11,"build_hasher","","",207,[[["self"]],["h"]]],[11,"clone","","",207,[[["self"]],["buildhasherdefault"]]],[11,"default","","",207,[[],["buildhasherdefault"]]],[11,"eq","","",207,[[["self"],["buildhasherdefault"]],["bool"]]],[0,"fmt","core","Utilities for formatting and printing strings.",N,N],[3,"DebugStruct","core::fmt","A struct to help with `fmt::Debug` implementations.",N,N],[3,"DebugTuple","","A struct to help with `fmt::Debug` implementations.",N,N],[3,"DebugSet","","A struct to help with `fmt::Debug` implementations.",N,N],[3,"DebugList","","A struct to help with `fmt::Debug` implementations.",N,N],[3,"DebugMap","","A struct to help with `fmt::Debug` implementations.",N,N],[3,"Error","","The error type which is returned from formatting a message into a stream.",N,N],[3,"Formatter","","A struct to represent both where to emit formatting strings to and how they should be formatted. A mutable version of this is passed to all formatting traits.",N,N],[3,"Arguments","","This structure represents a safely precompiled version of a format string and its arguments. This cannot be generated at runtime because it cannot safely be done, so no constructors are given and the fields are private to prevent modification.",N,N],[4,"Alignment","","Possible alignments returned by `Formatter::align`",N,N],[13,"Left","","Indication that contents should be left-aligned.",208,N],[13,"Right","","Indication that contents should be right-aligned.",208,N],[13,"Center","","Indication that contents should be center-aligned.",208,N],[5,"write","","The `write` function takes an output stream, and an `Arguments` struct that can be precompiled with the `format_args!` macro.",N,[[["write"],["arguments"]],["result"]]],[11,"field","","Adds a new field to the generated struct output.",209,[[["self"],["str"],["debug"]],["debugstruct"]]],[11,"finish","","Finishes output and returns any error encountered.",209,[[["self"]],["result"]]],[11,"field","","Adds a new field to the generated tuple struct output.",210,[[["self"],["debug"]],["debugtuple"]]],[11,"finish","","Finishes output and returns any error encountered.",210,[[["self"]],["result"]]],[11,"entry","","Adds a new entry to the set output.",211,[[["self"],["debug"]],["debugset"]]],[11,"entries","","Adds the contents of an iterator of entries to the set output.",211,[[["self"],["i"]],["debugset"]]],[11,"finish","","Finishes output and returns any error encountered.",211,[[["self"]],["result"]]],[11,"entry","","Adds a new entry to the list output.",212,[[["self"],["debug"]],["debuglist"]]],[11,"entries","","Adds the contents of an iterator of entries to the list output.",212,[[["self"],["i"]],["debuglist"]]],[11,"finish","","Finishes output and returns any error encountered.",212,[[["self"]],["result"]]],[11,"entry","","Adds a new entry to the map output.",213,[[["self"],["debug"],["debug"]],["debugmap"]]],[11,"entries","","Adds the contents of an iterator of entries to the map output.",213,[[["self"],["i"]],["debugmap"]]],[11,"finish","","Finishes output and returns any error encountered.",213,[[["self"]],["result"]]],[6,"Result","","The type returned by formatter methods.",N,N],[8,"Write","","A collection of methods that are required to format a message into a stream.",N,N],[10,"write_str","","Writes a slice of bytes into this writer, returning whether the write succeeded.",214,[[["self"],["str"]],["result"]]],[11,"write_char","","Writes a [`char`] into this writer, returning whether the write succeeded.",214,[[["self"],["char"]],["result"]]],[11,"write_fmt","","Glue for usage of the [`write!`] macro with implementors of this trait.",214,[[["self"],["arguments"]],["result"]]],[8,"Debug","","`?` formatting.",N,N],[10,"fmt","","Formats the value using the given formatter.",215,[[["self"],["formatter"]],["result"]]],[8,"Display","","Format trait for an empty format, `{}`.",N,N],[10,"fmt","","Formats the value using the given formatter.",216,[[["self"],["formatter"]],["result"]]],[8,"Octal","","`o` formatting.",N,N],[10,"fmt","","Formats the value using the given formatter.",217,[[["self"],["formatter"]],["result"]]],[8,"Binary","","`b` formatting.",N,N],[10,"fmt","","Formats the value using the given formatter.",218,[[["self"],["formatter"]],["result"]]],[8,"LowerHex","","`x` formatting.",N,N],[10,"fmt","","Formats the value using the given formatter.",219,[[["self"],["formatter"]],["result"]]],[8,"UpperHex","","`X` formatting.",N,N],[10,"fmt","","Formats the value using the given formatter.",220,[[["self"],["formatter"]],["result"]]],[8,"Pointer","","`p` formatting.",N,N],[10,"fmt","","Formats the value using the given formatter.",221,[[["self"],["formatter"]],["result"]]],[8,"LowerExp","","`e` formatting.",N,N],[10,"fmt","","Formats the value using the given formatter.",222,[[["self"],["formatter"]],["result"]]],[8,"UpperExp","","`E` formatting.",N,N],[10,"fmt","","Formats the value using the given formatter.",223,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",208,[[["self"],["formatter"]],["result"]]],[11,"clone","","",224,[[["self"]],["error"]]],[11,"fmt","","",224,[[["self"],["formatter"]],["result"]]],[11,"default","","",224,[[],["error"]]],[11,"hash","","",224,N],[11,"cmp","","",224,[[["self"],["error"]],["ordering"]]],[11,"eq","","",224,[[["self"],["error"]],["bool"]]],[11,"partial_cmp","","",224,[[["self"],["error"]],["option",["ordering"]]]],[11,"clone","","",225,[[["self"]],["arguments"]]],[11,"fmt","","",225,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",225,[[["self"],["formatter"]],["result"]]],[11,"pad_integral","","Performs the correct padding for an integer which has already been emitted into a str. The str should not contain the sign for the integer, that will be added by this method.",226,[[["self"],["bool"],["str"],["str"]],["result"]]],[11,"pad","","This function takes a string slice and emits it to the internal buffer after applying the relevant formatting flags specified. The flags recognized for generic strings are:",226,[[["self"],["str"]],["result"]]],[11,"write_str","","Writes some data to the underlying buffer contained within this formatter.",226,[[["self"],["str"]],["result"]]],[11,"write_fmt","","Writes some formatted information into this instance.",226,[[["self"],["arguments"]],["result"]]],[11,"flags","","Flags for formatting",226,[[["self"]],["u32"]]],[11,"fill","","Character used as 'fill' whenever there is alignment.",226,[[["self"]],["char"]]],[11,"align","","Flag indicating what form of alignment was requested.",226,[[["self"]],["option",["alignment"]]]],[11,"width","","Optionally specified integer width that the output should be.",226,[[["self"]],["option",["usize"]]]],[11,"precision","","Optionally specified precision for numeric types.",226,[[["self"]],["option",["usize"]]]],[11,"sign_plus","","Determines if the `+` flag was specified.",226,[[["self"]],["bool"]]],[11,"sign_minus","","Determines if the `-` flag was specified.",226,[[["self"]],["bool"]]],[11,"alternate","","Determines if the `#` flag was specified.",226,[[["self"]],["bool"]]],[11,"sign_aware_zero_pad","","Determines if the `0` flag was specified.",226,[[["self"]],["bool"]]],[11,"debug_struct","","Creates a [`DebugStruct`] builder designed to assist with creation of [`fmt::Debug`] implementations for structs.",226,[[["self"],["str"]],["debugstruct"]]],[11,"debug_tuple","","Creates a `DebugTuple` builder designed to assist with creation of `fmt::Debug` implementations for tuple structs.",226,[[["self"],["str"]],["debugtuple"]]],[11,"debug_list","","Creates a `DebugList` builder designed to assist with creation of `fmt::Debug` implementations for list-like structures.",226,[[["self"]],["debuglist"]]],[11,"debug_set","","Creates a `DebugSet` builder designed to assist with creation of `fmt::Debug` implementations for set-like structures.",226,[[["self"]],["debugset"]]],[11,"debug_map","","Creates a `DebugMap` builder designed to assist with creation of `fmt::Debug` implementations for map-like structures.",226,[[["self"]],["debugmap"]]],[11,"write_str","","",226,[[["self"],["str"]],["result"]]],[11,"write_char","","",226,[[["self"],["char"]],["result"]]],[11,"write_fmt","","",226,[[["self"],["arguments"]],["result"]]],[11,"fmt","","",224,[[["self"],["formatter"]],["result"]]],[11,"fmt","core::marker","",15,[[["self"],["formatter"]],["result"]]],[11,"fmt","core::cell","",91,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",94,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",95,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",96,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",97,[[["self"],["formatter"]],["result"]]],[0,"time","core","Temporal quantification.",N,N],[3,"Duration","core::time","A `Duration` type to represent a span of time, typically used for system timeouts.",N,N],[11,"clone","","",227,[[["self"]],["duration"]]],[11,"eq","","",227,[[["self"],["duration"]],["bool"]]],[11,"ne","","",227,[[["self"],["duration"]],["bool"]]],[11,"partial_cmp","","",227,[[["self"],["duration"]],["option",["ordering"]]]],[11,"lt","","",227,[[["self"],["duration"]],["bool"]]],[11,"le","","",227,[[["self"],["duration"]],["bool"]]],[11,"gt","","",227,[[["self"],["duration"]],["bool"]]],[11,"ge","","",227,[[["self"],["duration"]],["bool"]]],[11,"cmp","","",227,[[["self"],["duration"]],["ordering"]]],[11,"hash","","",227,N],[11,"default","","",227,[[],["duration"]]],[11,"new","","Creates a new `Duration` from the specified number of whole seconds and additional nanoseconds.",227,[[["u64"],["u32"]],["duration"]]],[11,"from_secs","","Creates a new `Duration` from the specified number of whole seconds.",227,[[["u64"]],["duration"]]],[11,"from_millis","","Creates a new `Duration` from the specified number of milliseconds.",227,[[["u64"]],["duration"]]],[11,"from_micros","","Creates a new `Duration` from the specified number of microseconds.",227,[[["u64"]],["duration"]]],[11,"from_nanos","","Creates a new `Duration` from the specified number of nanoseconds.",227,[[["u64"]],["duration"]]],[11,"as_secs","","Returns the number of whole seconds contained by this `Duration`.",227,[[["self"]],["u64"]]],[11,"subsec_millis","","Returns the fractional part of this `Duration`, in whole milliseconds.",227,[[["self"]],["u32"]]],[11,"subsec_micros","","Returns the fractional part of this `Duration`, in whole microseconds.",227,[[["self"]],["u32"]]],[11,"subsec_nanos","","Returns the fractional part of this `Duration`, in nanoseconds.",227,[[["self"]],["u32"]]],[11,"as_millis","","Returns the total number of whole milliseconds contained by this `Duration`.",227,[[["self"]],["u128"]]],[11,"as_micros","","Returns the total number of whole microseconds contained by this `Duration`.",227,[[["self"]],["u128"]]],[11,"as_nanos","","Returns the total number of nanoseconds contained by this `Duration`.",227,[[["self"]],["u128"]]],[11,"checked_add","","Checked `Duration` addition. Computes `self + other`, returning [`None`] if overflow occurred.",227,[[["self"],["duration"]],["option",["duration"]]]],[11,"checked_sub","","Checked `Duration` subtraction. Computes `self - other`, returning [`None`] if the result would be negative or if overflow occurred.",227,[[["self"],["duration"]],["option",["duration"]]]],[11,"checked_mul","","Checked `Duration` multiplication. Computes `self * other`, returning [`None`] if overflow occurred.",227,[[["self"],["u32"]],["option",["duration"]]]],[11,"checked_div","","Checked `Duration` division. Computes `self / other`, returning [`None`] if `other == 0`.",227,[[["self"],["u32"]],["option",["duration"]]]],[11,"add","","",227,[[["self"],["duration"]],["duration"]]],[11,"add_assign","","",227,[[["self"],["duration"]]]],[11,"sub","","",227,[[["self"],["duration"]],["duration"]]],[11,"sub_assign","","",227,[[["self"],["duration"]]]],[11,"mul","","",227,[[["self"],["u32"]],["duration"]]],[11,"mul_assign","","",227,[[["self"],["u32"]]]],[11,"div","","",227,[[["self"],["u32"]],["duration"]]],[11,"div_assign","","",227,[[["self"],["u32"]]]],[11,"sum","","",227,[[["i"]],["duration"]]],[11,"sum","","",227,[[["i"]],["duration"]]],[11,"fmt","","",227,[[["self"],["formatter"]],["result"]]],[0,"unicode","core","",N,N],[11,"clone","core::char","",98,[[["self"]],["unicodeversion"]]],[11,"fmt","","",98,[[["self"],["formatter"]],["result"]]],[11,"cmp","","",98,[[["self"],["unicodeversion"]],["ordering"]]],[11,"eq","","",98,[[["self"],["unicodeversion"]],["bool"]]],[11,"ne","","",98,[[["self"],["unicodeversion"]],["bool"]]],[11,"partial_cmp","","",98,[[["self"],["unicodeversion"]],["option",["ordering"]]]],[11,"lt","","",98,[[["self"],["unicodeversion"]],["bool"]]],[11,"le","","",98,[[["self"],["unicodeversion"]],["bool"]]],[11,"gt","","",98,[[["self"],["unicodeversion"]],["bool"]]],[11,"ge","","",98,[[["self"],["unicodeversion"]],["bool"]]],[0,"derived_property","core::unicode","",N,N],[5,"Case_Ignorable","core::unicode::derived_property","",N,[[["char"]],["bool"]]],[5,"Cased","","",N,[[["char"]],["bool"]]],[0,"conversions","core::unicode","",N,N],[5,"to_lower","core::unicode::conversions","",N,N],[5,"to_upper","","",N,N],[0,"property","core::unicode","",N,N],[5,"Pattern_White_Space","core::unicode::property","",N,[[["char"]],["bool"]]],[0,"future","core","Asynchronous values.",N,N],[3,"FutureObj","core::future","A custom trait object for polling futures, roughly akin to `Box<dyn Future<Output = T> + Send + 'a>`.",N,N],[3,"LocalFutureObj","","A custom trait object for polling futures, roughly akin to `Box<dyn Future<Output = T> + 'a>`.",N,N],[11,"poll","core::mem","",13,[[["pinmut"],["context"]],["poll"]]],[11,"new","core::future","Create a `LocalFutureObj` from a custom trait object representation.",228,[[["f"]],["localfutureobj"]]],[11,"into_future_obj","","Converts the `LocalFutureObj` into a `FutureObj` To make this operation safe one has to ensure that the `UnsafeFutureObj` instance from which this `LocalFutureObj` was created actually implements `Send`.",228,[[["self"]],["futureobj"]]],[11,"fmt","","",228,[[["self"],["formatter"]],["result"]]],[11,"from","","",228,[[["futureobj"]],["localfutureobj"]]],[11,"poll","","",228,[[["pinmut"],["context"]],["poll"]]],[11,"drop","","",228,[[["self"]]]],[11,"new","","Create a `FutureObj` from a custom trait object representation.",229,[[["f"]],["futureobj"]]],[11,"fmt","","",229,[[["self"],["formatter"]],["result"]]],[11,"poll","","",229,[[["pinmut"],["context"]],["poll"]]],[8,"Future","","A future represents an asychronous computation.",N,N],[16,"Output","","The result of the `Future`.",230,N],[10,"poll","","Attempt to resolve the future to a final value, registering the current task for wakeup if the value is not yet available.",230,[[["pinmut"],["context"]],["poll"]]],[8,"UnsafeFutureObj","","A custom implementation of a future trait object for `FutureObj`, providing a hand-rolled vtable.",N,N],[10,"into_raw","","Convert an owned instance into a (conceptually owned) void pointer.",231,N],[10,"poll","","Poll the future represented by the given void pointer.",231,N],[10,"drop","","Drops the future represented by the given void pointer.",231,N],[0,"task","core","Types and Traits for working with asynchronous tasks.",N,N],[3,"Context","core::task","Information about the currently-running task.",N,N],[3,"SpawnErrorKind","","Provides the reason that an executor was unable to spawn.",N,N],[3,"SpawnObjError","","The result of a failed spawn",N,N],[12,"kind","","The kind of error",232,N],[12,"future","","The future for which spawning inside a task was attempted",232,N],[3,"SpawnLocalObjError","","The result of a failed spawn",N,N],[12,"kind","","The kind of error",233,N],[12,"future","","The future for which spawning inside a task was attempted",233,N],[3,"Waker","","A `Waker` is a handle for waking up a task by notifying its executor that it is ready to be run.",N,N],[3,"LocalWaker","","A `LocalWaker` is a handle for waking up a task by notifying its executor that it is ready to be run.",N,N],[4,"Poll","","Indicates whether a value is available or if the current task has been scheduled to receive a wakeup instead.",N,N],[13,"Ready","","Represents that a value is immediately ready.",234,N],[13,"Pending","","Represents that a value is not ready yet.",234,N],[11,"fmt","","",235,[[["self"],["formatter"]],["result"]]],[11,"new","","Create a new task `Context` with the provided `local_waker`, `waker`, and `executor`.",235,[[["localwaker"],["executor"]],["context"]]],[11,"local_waker","","Get the `LocalWaker` associated with the current task.",235,[[["self"]],["localwaker"]]],[11,"waker","","Get the `Waker` associated with the current task.",235,[[["self"]],["waker"]]],[11,"executor","","Get the default executor associated with this task.",235,[[["self"]],["executor"]]],[11,"with_waker","","Produce a context like the current one, but using the given waker instead.",235,[[["self"],["localwaker"]],["context"]]],[11,"with_executor","","Produce a context like the current one, but using the given executor instead.",235,[[["self"],["e"]],["context"]]],[11,"fmt","","",236,[[["self"],["formatter"]],["result"]]],[11,"shutdown","","Spawning is failing because the executor has been shut down.",236,[[],["spawnerrorkind"]]],[11,"is_shutdown","","Check whether this error is the `shutdown` error.",236,[[["self"]],["bool"]]],[11,"fmt","","",232,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",233,[[["self"],["formatter"]],["result"]]],[11,"clone","","",234,[[["self"]],["poll"]]],[11,"fmt","","",234,[[["self"],["formatter"]],["result"]]],[11,"eq","","",234,[[["self"],["poll"]],["bool"]]],[11,"ne","","",234,[[["self"],["poll"]],["bool"]]],[11,"cmp","","",234,[[["self"],["poll"]],["ordering"]]],[11,"partial_cmp","","",234,[[["self"],["poll"]],["option",["ordering"]]]],[11,"lt","","",234,[[["self"],["poll"]],["bool"]]],[11,"le","","",234,[[["self"],["poll"]],["bool"]]],[11,"gt","","",234,[[["self"],["poll"]],["bool"]]],[11,"ge","","",234,[[["self"],["poll"]],["bool"]]],[11,"hash","","",234,N],[11,"map","","Change the ready value of this `Poll` with the closure provided",234,[[["self"],["f"]],["poll"]]],[11,"is_ready","","Returns whether this is `Poll::Ready`",234,[[["self"]],["bool"]]],[11,"is_pending","","Returns whether this is `Poll::Pending`",234,[[["self"]],["bool"]]],[11,"map_ok","","Change the success value of this `Poll` with the closure provided",234,[[["self"],["f"]],["poll",["result"]]]],[11,"map_err","","Change the error value of this `Poll` with the closure provided",234,[[["self"],["f"]],["poll",["result"]]]],[11,"from","","",234,[[["t"]],["poll"]]],[11,"into_result","","",234,[[["self"]],["result"]]],[11,"from_error","","",234,N],[11,"from_ok","","",234,N],[11,"into_result","","",234,[[["self"]],["result"]]],[11,"from_error","","",234,N],[11,"from_ok","","",234,N],[11,"new","","Constructs a new `Waker` directly.",237,[[["nonnull",["unsafewake"]]],["self"]]],[11,"wake","","Wake up the task associated with this `Waker`.",237,[[["self"]]]],[11,"will_wake","","Returns whether or not this `Waker` and `other` awaken the same task.",237,[[["self"],["waker"]],["bool"]]],[11,"clone","","",237,[[["self"]],["self"]]],[11,"fmt","","",237,[[["self"],["formatter"]],["result"]]],[11,"drop","","",237,[[["self"]]]],[11,"new","","Constructs a new `LocalWaker` directly.",238,[[["nonnull",["unsafewake"]]],["self"]]],[11,"wake","","Wake up the task associated with this `LocalWaker`.",238,[[["self"]]]],[11,"will_wake","","Returns whether or not this `LocalWaker` and `other` `LocalWaker` awaken the same task.",238,[[["self"],["localwaker"]],["bool"]]],[11,"will_wake_nonlocal","","Returns whether or not this `LocalWaker` and `other` `Waker` awaken the same task.",238,[[["self"],["waker"]],["bool"]]],[11,"from","","",237,[[["localwaker"]],["self"]]],[11,"clone","","",238,[[["self"]],["self"]]],[11,"fmt","","",238,[[["self"],["formatter"]],["result"]]],[11,"drop","","",238,[[["self"]]]],[8,"Executor","","A task executor.",N,N],[10,"spawn_obj","","Spawns a new task with the given future. The future will be polled until completion.",239,[[["self"],["futureobj"]],["result",["spawnobjerror"]]]],[11,"status","","Determines whether the executor is able to spawn new tasks.",239,[[["self"]],["result",["spawnerrorkind"]]]],[8,"UnsafeWake","","An unsafe trait for implementing custom memory management for a `Waker` or `LocalWaker`.",N,N],[10,"clone_raw","","Creates a clone of this `UnsafeWake` and stores it behind a `Waker`.",240,[[["self"]],["waker"]]],[10,"drop_raw","","Drops this instance of `UnsafeWake`, deallocating resources associated with it.",240,[[["self"]]]],[10,"wake","","Indicates that the associated task is ready to make progress and should be `poll`ed.",240,[[["self"]]]],[11,"wake_local","","Indicates that the associated task is ready to make progress and should be `poll`ed. This function is the same as `wake`, but can only be called from the thread that this `UnsafeWake` is \"local\" to. This allows for implementors to provide specialized wakeup behavior specific to the current thread. This function is called by `LocalWaker::wake`.",240,[[["self"]]]],[0,"alloc","core","Memory allocation APIs",N,N],[3,"Excess","core::alloc","Represents the combination of a starting address and a total capacity of the returned block.",N,N],[12,"0","","",241,N],[12,"1","","",241,N],[3,"Layout","","Layout of a block of memory.",N,N],[3,"LayoutErr","","The parameters given to `Layout::from_size_align` or some other `Layout` constructor do not satisfy its documented constraints.",N,N],[3,"AllocErr","","The `AllocErr` error indicates an allocation failure that may be due to resource exhaustion or to something wrong when combining the given input arguments with this allocator.",N,N],[3,"CannotReallocInPlace","","The `CannotReallocInPlace` error is used when `grow_in_place` or `shrink_in_place` were unable to reuse the given memory block for a requested layout.",N,N],[8,"GlobalAlloc","","A memory allocator that can be registered as the standard library’s default though the `#[global_allocator]` attributes.",N,N],[10,"alloc","","Allocate memory as described by the given `layout`.",242,N],[10,"dealloc","","Deallocate the block of memory at the given `ptr` pointer with the given `layout`.",242,N],[11,"alloc_zeroed","","Behaves like `alloc`, but also ensures that the contents are set to zero before being returned.",242,N],[11,"realloc","","Shink or grow a block of memory to the given `new_size`. The block is described by the given `ptr` pointer and `layout`.",242,N],[8,"Alloc","","An implementation of `Alloc` can allocate, reallocate, and deallocate arbitrary blocks of data described via `Layout`.",N,N],[10,"alloc","","Returns a pointer meeting the size and alignment guarantees of `layout`.",243,[[["self"],["layout"]],["result",["nonnull","allocerr"]]]],[10,"dealloc","","Deallocate the memory referenced by `ptr`.",243,[[["self"],["nonnull",["u8"]],["layout"]]]],[11,"usable_size","","Returns bounds on the guaranteed usable size of a successful allocation created with the specified `layout`.",243,N],[11,"realloc","","Returns a pointer suitable for holding data described by a new layout with `layout`’s alginment and a size given by `new_size`. To accomplish this, this may extend or shrink the allocation referenced by `ptr` to fit the new layout.",243,[[["self"],["nonnull",["u8"]],["layout"],["usize"]],["result",["nonnull","allocerr"]]]],[11,"alloc_zeroed","","Behaves like `alloc`, but also ensures that the contents are set to zero before being returned.",243,[[["self"],["layout"]],["result",["nonnull","allocerr"]]]],[11,"alloc_excess","","Behaves like `alloc`, but also returns the whole size of the returned block. For some `layout` inputs, like arrays, this may include extra storage usable for additional data.",243,[[["self"],["layout"]],["result",["excess","allocerr"]]]],[11,"realloc_excess","","Behaves like `realloc`, but also returns the whole size of the returned block. For some `layout` inputs, like arrays, this may include extra storage usable for additional data.",243,[[["self"],["nonnull",["u8"]],["layout"],["usize"]],["result",["excess","allocerr"]]]],[11,"grow_in_place","","Attempts to extend the allocation referenced by `ptr` to fit `new_size`.",243,[[["self"],["nonnull",["u8"]],["layout"],["usize"]],["result",["cannotreallocinplace"]]]],[11,"shrink_in_place","","Attempts to shrink the allocation referenced by `ptr` to fit `new_size`.",243,[[["self"],["nonnull",["u8"]],["layout"],["usize"]],["result",["cannotreallocinplace"]]]],[11,"alloc_one","","Allocates a block suitable for holding an instance of `T`.",243,[[["self"]],["result",["nonnull","allocerr"]]]],[11,"dealloc_one","","Deallocates a block suitable for holding an instance of `T`.",243,[[["self"],["nonnull"]]]],[11,"alloc_array","","Allocates a block suitable for holding `n` instances of `T`.",243,[[["self"],["usize"]],["result",["nonnull","allocerr"]]]],[11,"realloc_array","","Reallocates a block previously suitable for holding `n_old` instances of `T`, returning a block suitable for holding `n_new` instances of `T`.",243,[[["self"],["nonnull"],["usize"],["usize"]],["result",["nonnull","allocerr"]]]],[11,"dealloc_array","","Deallocates a block suitable for holding `n` instances of `T`.",243,[[["self"],["nonnull"],["usize"]],["result",["allocerr"]]]],[11,"fmt","","",241,[[["self"],["formatter"]],["result"]]],[11,"clone","","",244,[[["self"]],["layout"]]],[11,"fmt","","",244,[[["self"],["formatter"]],["result"]]],[11,"eq","","",244,[[["self"],["layout"]],["bool"]]],[11,"ne","","",244,[[["self"],["layout"]],["bool"]]],[11,"from_size_align","","Constructs a `Layout` from a given `size` and `align`, or returns `LayoutErr` if either of the following conditions are not met:",244,[[["usize"],["usize"]],["result",["layouterr"]]]],[11,"from_size_align_unchecked","","Creates a layout, bypassing all checks.",244,[[["usize"],["usize"]],["self"]]],[11,"size","","The minimum size in bytes for a memory block of this layout.",244,[[["self"]],["usize"]]],[11,"align","","The minimum byte alignment for a memory block of this layout.",244,[[["self"]],["usize"]]],[11,"new","","Constructs a `Layout` suitable for holding a value of type `T`.",244,[[],["self"]]],[11,"for_value","","Produces layout describing a record that could be used to allocate backing structure for `T` (which could be a trait or other unsized type like a slice).",244,[[["t"]],["self"]]],[11,"align_to","","Creates a layout describing the record that can hold a value of the same layout as `self`, but that also is aligned to alignment `align` (measured in bytes).",244,[[["self"],["usize"]],["self"]]],[11,"padding_needed_for","","Returns the amount of padding we must insert after `self` to ensure that the following address will satisfy `align` (measured in bytes).",244,[[["self"],["usize"]],["usize"]]],[11,"repeat","","Creates a layout describing the record for `n` instances of `self`, with a suitable amount of padding between each to ensure that each instance is given its requested size and alignment. On success, returns `(k, offs)` where `k` is the layout of the array and `offs` is the distance between the start of each element in the array.",244,[[["self"],["usize"]],["result",["layouterr"]]]],[11,"extend","","Creates a layout describing the record for `self` followed by `next`, including any necessary padding to ensure that `next` will be properly aligned. Note that the result layout will satisfy the alignment properties of both `self` and `next`.",244,[[["self"],["self"]],["result",["layouterr"]]]],[11,"repeat_packed","","Creates a layout describing the record for `n` instances of `self`, with no padding between each instance.",244,[[["self"],["usize"]],["result",["layouterr"]]]],[11,"extend_packed","","Creates a layout describing the record for `self` followed by `next` with no additional padding between the two. Since no padding is inserted, the alignment of `next` is irrelevant, and is not incorporated at all into the resulting layout.",244,[[["self"],["self"]],["result",["layouterr"]]]],[11,"array","","Creates a layout describing the record for a `[T; n]`.",244,[[["usize"]],["result",["layouterr"]]]],[11,"clone","","",245,[[["self"]],["layouterr"]]],[11,"eq","","",245,[[["self"],["layouterr"]],["bool"]]],[11,"ne","","",245,[[["self"],["layouterr"]],["bool"]]],[11,"fmt","","",245,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",245,[[["self"],["formatter"]],["result"]]],[11,"clone","","",246,[[["self"]],["allocerr"]]],[11,"eq","","",246,[[["self"],["allocerr"]],["bool"]]],[11,"fmt","","",246,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",246,[[["self"],["formatter"]],["result"]]],[11,"clone","","",247,[[["self"]],["cannotreallocinplace"]]],[11,"eq","","",247,[[["self"],["cannotreallocinplace"]],["bool"]]],[11,"fmt","","",247,[[["self"],["formatter"]],["result"]]],[11,"description","","",247,[[["self"]],["str"]]],[11,"fmt","","",247,[[["self"],["formatter"]],["result"]]],[0,"arch","core","Platform dependent vendor intrinsics.",N,N],[0,"x86","core::arch","Platform-specific intrinsics for the `x86` platform.",N,N],[3,"__m64","core::arch::x86","64-bit wide integer vector type, x86-specific",N,N],[3,"__m128i","","128-bit wide integer vector type, x86-specific",N,N],[3,"__m128","","128-bit wide set of four `f32` types, x86-specific",N,N],[3,"__m128d","","128-bit wide set of two `f64` types, x86-specific",N,N],[3,"__m256i","","256-bit wide integer vector type, x86-specific",N,N],[3,"__m256","","256-bit wide set of eight `f32` types, x86-specific",N,N],[3,"__m256d","","256-bit wide set of four `f64` types, x86-specific",N,N],[3,"CpuidResult","","Result of the `cpuid` instruction.",N,N],[12,"eax","","EAX register.",248,N],[12,"ebx","","EBX register.",248,N],[12,"ecx","","ECX register.",248,N],[12,"edx","","EDX register.",248,N],[5,"_fxsave","","Saves the `x87` FPU, `MMX` technology, `XMM`, and `MXCSR` registers to the 512-byte-long 16-byte-aligned memory region `mem_addr`.",N,N],[5,"_fxrstor","","Restores the `XMM`, `MMX`, `MXCSR`, and `x87` FPU registers from the 512-byte-long 16-byte-aligned memory region `mem_addr`.",N,N],[5,"_bswap","","Return an integer with the reversed byte order of x",N,[[["i32"]],["i32"]]],[5,"_rdtsc","","Reads the current value of the processor’s time-stamp counter.",N,[[],["i64"]]],[5,"__rdtscp","","Reads the current value of the processor’s time-stamp counter and the `IA32_TSC_AUX MSR`.",N,N],[5,"__cpuid_count","","Returns the result of the `cpuid` instruction for a given `leaf` (`EAX`) and `sub_leaf` (`ECX`).",N,[[["u32"],["u32"]],["cpuidresult"]]],[5,"__cpuid","","See `__cpuid_count`.",N,[[["u32"]],["cpuidresult"]]],[5,"has_cpuid","","Does the host support the `cpuid` instruction?",N,[[],["bool"]]],[5,"__get_cpuid_max","","Returns the highest-supported `leaf` (`EAX`) and sub-leaf (`ECX`) `cpuid` values.",N,N],[5,"_xsave","","Perform a full or partial save of the enabled processor states to memory at `mem_addr`.",N,N],[5,"_xrstor","","Perform a full or partial restore of the enabled processor states using the state information stored in memory at `mem_addr`.",N,N],[5,"_xsetbv","","Copy 64-bits from `val` to the extended control register (`XCR`) specified by `a`.",N,[[["u32"],["u64"]]]],[5,"_xgetbv","","Reads the contents of the extended control register `XCR` specified in `xcr_no`.",N,[[["u32"]],["u64"]]],[5,"_xsaveopt","","Perform a full or partial save of the enabled processor states to memory at `mem_addr`.",N,N],[5,"_xsavec","","Perform a full or partial save of the enabled processor states to memory at `mem_addr`.",N,N],[5,"_xsaves","","Perform a full or partial save of the enabled processor states to memory at `mem_addr`",N,N],[5,"_xrstors","","Perform a full or partial restore of the enabled processor states using the state information stored in memory at `mem_addr`.",N,N],[5,"_mm_add_ss","","Adds the first component of `a` and `b`, the other components are copied from `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_add_ps","","Adds __m128 vectors.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_sub_ss","","Subtracts the first component of `b` from `a`, the other components are copied from `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_sub_ps","","Subtracts __m128 vectors.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_mul_ss","","Multiplies the first component of `a` and `b`, the other components are copied from `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_mul_ps","","Multiplies __m128 vectors.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_div_ss","","Divides the first component of `b` by `a`, the other components are copied from `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_div_ps","","Divides __m128 vectors.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_sqrt_ss","","Return the square root of the first single-precision (32-bit) floating-point element in `a`, the other elements are unchanged.",N,[[["__m128"]],["__m128"]]],[5,"_mm_sqrt_ps","","Return the square root of packed single-precision (32-bit) floating-point elements in `a`.",N,[[["__m128"]],["__m128"]]],[5,"_mm_rcp_ss","","Return the approximate reciprocal of the first single-precision (32-bit) floating-point element in `a`, the other elements are unchanged.",N,[[["__m128"]],["__m128"]]],[5,"_mm_rcp_ps","","Return the approximate reciprocal of packed single-precision (32-bit) floating-point elements in `a`.",N,[[["__m128"]],["__m128"]]],[5,"_mm_rsqrt_ss","","Return the approximate reciprocal square root of the fist single-precision (32-bit) floating-point elements in `a`, the other elements are unchanged.",N,[[["__m128"]],["__m128"]]],[5,"_mm_rsqrt_ps","","Return the approximate reciprocal square root of packed single-precision (32-bit) floating-point elements in `a`.",N,[[["__m128"]],["__m128"]]],[5,"_mm_min_ss","","Compare the first single-precision (32-bit) floating-point element of `a` and `b`, and return the minimum value in the first element of the return value, the other elements are copied from `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_min_ps","","Compare packed single-precision (32-bit) floating-point elements in `a` and `b`, and return the corresponding minimum values.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_max_ss","","Compare the first single-precision (32-bit) floating-point element of `a` and `b`, and return the maximum value in the first element of the return value, the other elements are copied from `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_max_ps","","Compare packed single-precision (32-bit) floating-point elements in `a` and `b`, and return the corresponding maximum values.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_and_ps","","Bitwise AND of packed single-precision (32-bit) floating-point elements.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_andnot_ps","","Bitwise AND-NOT of packed single-precision (32-bit) floating-point elements.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_or_ps","","Bitwise OR of packed single-precision (32-bit) floating-point elements.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_xor_ps","","Bitwise exclusive OR of packed single-precision (32-bit) floating-point elements.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpeq_ss","","Compare the lowest `f32` of both inputs for equality. The lowest 32 bits of the result will be `0xffffffff` if the two inputs are equal, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmplt_ss","","Compare the lowest `f32` of both inputs for less than. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is less than `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmple_ss","","Compare the lowest `f32` of both inputs for less than or equal. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is less than or equal `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpgt_ss","","Compare the lowest `f32` of both inputs for greater than. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is greater than `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpge_ss","","Compare the lowest `f32` of both inputs for greater than or equal. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is greater than or equal `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpneq_ss","","Compare the lowest `f32` of both inputs for inequality. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is not equal to `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpnlt_ss","","Compare the lowest `f32` of both inputs for not-less-than. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is not less than `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpnle_ss","","Compare the lowest `f32` of both inputs for not-less-than-or-equal. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is not less than or equal to `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpngt_ss","","Compare the lowest `f32` of both inputs for not-greater-than. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is not greater than `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpnge_ss","","Compare the lowest `f32` of both inputs for not-greater-than-or-equal. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is not greater than or equal to `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpord_ss","","Check if the lowest `f32` of both inputs are ordered. The lowest 32 bits of the result will be `0xffffffff` if neither of `a.extract(0)` or `b.extract(0)` is a NaN, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpunord_ss","","Check if the lowest `f32` of both inputs are unordered. The lowest 32 bits of the result will be `0xffffffff` if any of `a.extract(0)` or `b.extract(0)` is a NaN, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpeq_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input elements were equal, or `0` otherwise.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmplt_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is less than the corresponding element in `b`, or `0` otherwise.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmple_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is less than or equal to the corresponding element in `b`, or `0` otherwise.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpgt_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is greater than the corresponding element in `b`, or `0` otherwise.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpge_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is greater than or equal to the corresponding element in `b`, or `0` otherwise.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpneq_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input elements are not equal, or `0` otherwise.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpnlt_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is not less than the corresponding element in `b`, or `0` otherwise.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpnle_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is not less than or equal to the corresponding element in `b`, or `0` otherwise.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpngt_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is not greater than the corresponding element in `b`, or `0` otherwise.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpnge_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is not greater than or equal to the corresponding element in `b`, or `0` otherwise.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpord_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. Returns four floats that have one of two possible bit patterns. The element in the output vector will be `0xffffffff` if the input elements in `a` and `b` are ordered (i.e., neither of them is a NaN), or 0 otherwise.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpunord_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. Returns four floats that have one of two possible bit patterns. The element in the output vector will be `0xffffffff` if the input elements in `a` and `b` are unordered (i.e., at least on of them is a NaN), or 0 otherwise.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_comieq_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if they are equal, or `0` otherwise.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm_comilt_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is less than the one from `b`, or `0` otherwise.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm_comile_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is less than or equal to the one from `b`, or `0` otherwise.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm_comigt_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is greater than the one from `b`, or `0` otherwise.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm_comige_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is greater than or equal to the one from `b`, or `0` otherwise.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm_comineq_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if they are not equal, or `0` otherwise.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm_ucomieq_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if they are equal, or `0` otherwise. This instruction will not signal an exception if either argument is a quiet NaN.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm_ucomilt_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is less than the one from `b`, or `0` otherwise. This instruction will not signal an exception if either argument is a quiet NaN.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm_ucomile_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is less than or equal to the one from `b`, or `0` otherwise. This instruction will not signal an exception if either argument is a quiet NaN.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm_ucomigt_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is greater than the one from `b`, or `0` otherwise. This instruction will not signal an exception if either argument is a quiet NaN.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm_ucomige_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is greater than or equal to the one from `b`, or `0` otherwise. This instruction will not signal an exception if either argument is a quiet NaN.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm_ucomineq_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if they are not equal, or `0` otherwise. This instruction will not signal an exception if either argument is a quiet NaN.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm_cvtss_si32","","Convert the lowest 32 bit float in the input vector to a 32 bit integer.",N,[[["__m128"]],["i32"]]],[5,"_mm_cvt_ss2si","","Alias for `_mm_cvtss_si32`.",N,[[["__m128"]],["i32"]]],[5,"_mm_cvttss_si32","","Convert the lowest 32 bit float in the input vector to a 32 bit integer with truncation.",N,[[["__m128"]],["i32"]]],[5,"_mm_cvtt_ss2si","","Alias for `_mm_cvttss_si32`.",N,[[["__m128"]],["i32"]]],[5,"_mm_cvtss_f32","","Extract the lowest 32 bit float from the input vector.",N,[[["__m128"]],["f32"]]],[5,"_mm_cvtsi32_ss","","Convert a 32 bit integer to a 32 bit float. The result vector is the input vector `a` with the lowest 32 bit float replaced by the converted integer.",N,[[["__m128"],["i32"]],["__m128"]]],[5,"_mm_cvt_si2ss","","Alias for `_mm_cvtsi32_ss`.",N,[[["__m128"],["i32"]],["__m128"]]],[5,"_mm_set_ss","","Construct a `__m128` with the lowest element set to `a` and the rest set to zero.",N,[[["f32"]],["__m128"]]],[5,"_mm_set1_ps","","Construct a `__m128` with all element set to `a`.",N,[[["f32"]],["__m128"]]],[5,"_mm_set_ps1","","Alias for `_mm_set1_ps`",N,[[["f32"]],["__m128"]]],[5,"_mm_set_ps","","Construct a `__m128` from four floating point values highest to lowest.",N,[[["f32"],["f32"],["f32"],["f32"]],["__m128"]]],[5,"_mm_setr_ps","","Construct a `__m128` from four floating point values lowest to highest.",N,[[["f32"],["f32"],["f32"],["f32"]],["__m128"]]],[5,"_mm_setzero_ps","","Construct a `__m128` with all elements initialized to zero.",N,[[],["__m128"]]],[5,"_MM_SHUFFLE","","A utility function for creating masks to use with Intel shuffle and permute intrinsics.",N,[[["u32"],["u32"],["u32"],["u32"]],["u32"]]],[5,"_mm_shuffle_ps","","Shuffle packed single-precision (32-bit) floating-point elements in `a` and `b` using `mask`.",N,[[["__m128"],["__m128"],["u32"]],["__m128"]]],[5,"_mm_unpackhi_ps","","Unpack and interleave single-precision (32-bit) floating-point elements from the higher half of `a` and `b`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_unpacklo_ps","","Unpack and interleave single-precision (32-bit) floating-point elements from the lower half of `a` and `b`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_movehl_ps","","Combine higher half of `a` and `b`. The highwe half of `b` occupies the lower half of result.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_movelh_ps","","Combine lower half of `a` and `b`. The lower half of `b` occupies the higher half of result.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_movemask_ps","","Return a mask of the most significant bit of each element in `a`.",N,[[["__m128"]],["i32"]]],[5,"_mm_loadh_pi","","Set the upper two single-precision floating-point values with 64 bits of data loaded from the address `p`; the lower two values are passed through from `a`.",N,N],[5,"_mm_loadl_pi","","Load two floats from `p` into the lower half of a `__m128`. The upper half is copied from the upper half of `a`.",N,N],[5,"_mm_load_ss","","Construct a `__m128` with the lowest element read from `p` and the other elements set to zero.",N,N],[5,"_mm_load1_ps","","Construct a `__m128` by duplicating the value read from `p` into all elements.",N,N],[5,"_mm_load_ps1","","Alias for `_mm_load1_ps`",N,N],[5,"_mm_load_ps","","Load four `f32` values from aligned memory into a `__m128`. If the pointer is not aligned to a 128-bit boundary (16 bytes) a general protection fault will be triggered (fatal program crash).",N,N],[5,"_mm_loadu_ps","","Load four `f32` values from memory into a `__m128`. There are no restrictions on memory alignment. For aligned memory `_mm_load_ps` may be faster.",N,N],[5,"_mm_loadr_ps","","Load four `f32` values from aligned memory into a `__m128` in reverse order.",N,N],[5,"_mm_storeh_pi","","Store the upper half of `a` (64 bits) into memory.",N,N],[5,"_mm_storel_pi","","Store the lower half of `a` (64 bits) into memory.",N,N],[5,"_mm_store_ss","","Store the lowest 32 bit float of `a` into memory.",N,N],[5,"_mm_store1_ps","","Store the lowest 32 bit float of `a` repeated four times into aligned memory.",N,N],[5,"_mm_store_ps1","","Alias for `_mm_store1_ps`",N,N],[5,"_mm_store_ps","","Store four 32-bit floats into aligned memory.",N,N],[5,"_mm_storeu_ps","","Store four 32-bit floats into memory. There are no restrictions on memory alignment. For aligned memory `_mm_store_ps` may be faster.",N,N],[5,"_mm_storer_ps","","Store four 32-bit floats into aligned memory in reverse order.",N,N],[5,"_mm_move_ss","","Return a `__m128` with the first component from `b` and the remaining components from `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_sfence","","Perform a serializing operation on all store-to-memory instructions that were issued prior to this instruction.",N,[[]]],[5,"_mm_getcsr","","Get the unsigned 32-bit value of the MXCSR control and status register.",N,[[],["u32"]]],[5,"_mm_setcsr","","Set the MXCSR register with the 32-bit unsigned integer value.",N,[[["u32"]]]],[5,"_MM_GET_EXCEPTION_MASK","","See `_mm_setcsr`",N,[[],["u32"]]],[5,"_MM_GET_EXCEPTION_STATE","","See `_mm_setcsr`",N,[[],["u32"]]],[5,"_MM_GET_FLUSH_ZERO_MODE","","See `_mm_setcsr`",N,[[],["u32"]]],[5,"_MM_GET_ROUNDING_MODE","","See `_mm_setcsr`",N,[[],["u32"]]],[5,"_MM_SET_EXCEPTION_MASK","","See `_mm_setcsr`",N,[[["u32"]]]],[5,"_MM_SET_EXCEPTION_STATE","","See `_mm_setcsr`",N,[[["u32"]]]],[5,"_MM_SET_FLUSH_ZERO_MODE","","See `_mm_setcsr`",N,[[["u32"]]]],[5,"_MM_SET_ROUNDING_MODE","","See `_mm_setcsr`",N,[[["u32"]]]],[5,"_mm_prefetch","","Fetch the cache line that contains address `p` using the given `strategy`.",N,N],[5,"_mm_undefined_ps","","Return vector of type __m128 with undefined elements.",N,[[],["__m128"]]],[5,"_MM_TRANSPOSE4_PS","","Transpose the 4x4 matrix formed by 4 rows of __m128 in place.",N,[[["__m128"],["__m128"],["__m128"],["__m128"]]]],[5,"_mm_stream_ps","","Stores `a` into the memory at `mem_addr` using a non-temporal memory hint.",N,N],[5,"_mm_stream_pi","","Store 64-bits of integer data from a into memory using a non-temporal memory hint.",N,N],[5,"_mm_max_pi16","","Compares the packed 16-bit signed integers of `a` and `b` writing the greatest value into the result.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_pmaxsw","","Compares the packed 16-bit signed integers of `a` and `b` writing the greatest value into the result.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_max_pu8","","Compares the packed 8-bit signed integers of `a` and `b` writing the greatest value into the result.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_pmaxub","","Compares the packed 8-bit signed integers of `a` and `b` writing the greatest value into the result.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_min_pi16","","Compares the packed 16-bit signed integers of `a` and `b` writing the smallest value into the result.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_pminsw","","Compares the packed 16-bit signed integers of `a` and `b` writing the smallest value into the result.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_min_pu8","","Compares the packed 8-bit signed integers of `a` and `b` writing the smallest value into the result.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_pminub","","Compares the packed 8-bit signed integers of `a` and `b` writing the smallest value into the result.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_mulhi_pu16","","Multiplies packed 16-bit unsigned integer values and writes the high-order 16 bits of each 32-bit product to the corresponding bits in the destination.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_mullo_pi16","","Multiplies packed 16-bit integer values and writes the low-order 16 bits of each 32-bit product to the corresponding bits in the destination.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_pmulhuw","","Multiplies packed 16-bit unsigned integer values and writes the high-order 16 bits of each 32-bit product to the corresponding bits in the destination.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_avg_pu8","","Computes the rounded averages of the packed unsigned 8-bit integer values and writes the averages to the corresponding bits in the destination.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_pavgb","","Computes the rounded averages of the packed unsigned 8-bit integer values and writes the averages to the corresponding bits in the destination.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_avg_pu16","","Computes the rounded averages of the packed unsigned 16-bit integer values and writes the averages to the corresponding bits in the destination.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_pavgw","","Computes the rounded averages of the packed unsigned 16-bit integer values and writes the averages to the corresponding bits in the destination.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_sad_pu8","","Subtracts the corresponding 8-bit unsigned integer values of the two 64-bit vector operands and computes the absolute value for each of the difference. Then sum of the 8 absolute differences is written to the bits `[15:0]` of the destination; the remaining bits `[63:16]` are cleared.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_psadbw","","Subtracts the corresponding 8-bit unsigned integer values of the two 64-bit vector operands and computes the absolute value for each of the difference. Then sum of the 8 absolute differences is written to the bits `[15:0]` of the destination; the remaining bits `[63:16]` are cleared.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_cvtpi32_ps","","Converts two elements of a 64-bit vector of `[2 x i32]` into two floating point values and writes them to the lower 64-bits of the destination. The remaining higher order elements of the destination are copied from the corresponding elements in the first operand.",N,[[["__m128"],["__m64"]],["__m128"]]],[5,"_mm_cvt_pi2ps","","Converts two elements of a 64-bit vector of `[2 x i32]` into two floating point values and writes them to the lower 64-bits of the destination. The remaining higher order elements of the destination are copied from the corresponding elements in the first operand.",N,[[["__m128"],["__m64"]],["__m128"]]],[5,"_mm_cvtpi8_ps","","Converts the lower 4 8-bit values of `a` into a 128-bit vector of 4 `f32`s.",N,[[["__m64"]],["__m128"]]],[5,"_mm_cvtpu8_ps","","Converts the lower 4 8-bit values of `a` into a 128-bit vector of 4 `f32`s.",N,[[["__m64"]],["__m128"]]],[5,"_mm_cvtpi16_ps","","Converts a 64-bit vector of `i16`s into a 128-bit vector of 4 `f32`s.",N,[[["__m64"]],["__m128"]]],[5,"_mm_cvtpu16_ps","","Converts a 64-bit vector of `i16`s into a 128-bit vector of 4 `f32`s.",N,[[["__m64"]],["__m128"]]],[5,"_mm_cvtpi32x2_ps","","Converts the two 32-bit signed integer values from each 64-bit vector operand of `[2 x i32]` into a 128-bit vector of `[4 x float]`.",N,[[["__m64"],["__m64"]],["__m128"]]],[5,"_mm_maskmove_si64","","Conditionally copies the values from each 8-bit element in the first 64-bit integer vector operand to the specified memory location, as specified by the most significant bit in the corresponding element in the second 64-bit integer vector operand.",N,N],[5,"_m_maskmovq","","Conditionally copies the values from each 8-bit element in the first 64-bit integer vector operand to the specified memory location, as specified by the most significant bit in the corresponding element in the second 64-bit integer vector operand.",N,N],[5,"_mm_extract_pi16","","Extracts 16-bit element from a 64-bit vector of `[4 x i16]` and returns it, as specified by the immediate integer operand.",N,[[["__m64"],["i32"]],["i32"]]],[5,"_m_pextrw","","Extracts 16-bit element from a 64-bit vector of `[4 x i16]` and returns it, as specified by the immediate integer operand.",N,[[["__m64"],["i32"]],["i32"]]],[5,"_mm_insert_pi16","","Copies data from the 64-bit vector of `[4 x i16]` to the destination, and inserts the lower 16-bits of an integer operand at the 16-bit offset specified by the immediate operand `n`.",N,[[["__m64"],["i32"],["i32"]],["__m64"]]],[5,"_m_pinsrw","","Copies data from the 64-bit vector of `[4 x i16]` to the destination, and inserts the lower 16-bits of an integer operand at the 16-bit offset specified by the immediate operand `n`.",N,[[["__m64"],["i32"],["i32"]],["__m64"]]],[5,"_mm_movemask_pi8","","Takes the most significant bit from each 8-bit element in a 64-bit integer vector to create a 16-bit mask value. Zero-extends the value to 32-bit integer and writes it to the destination.",N,[[["__m64"]],["i32"]]],[5,"_m_pmovmskb","","Takes the most significant bit from each 8-bit element in a 64-bit integer vector to create a 16-bit mask value. Zero-extends the value to 32-bit integer and writes it to the destination.",N,[[["__m64"]],["i32"]]],[5,"_mm_shuffle_pi16","","Shuffles the 4 16-bit integers from a 64-bit integer vector to the destination, as specified by the immediate value operand.",N,[[["__m64"],["i32"]],["__m64"]]],[5,"_m_pshufw","","Shuffles the 4 16-bit integers from a 64-bit integer vector to the destination, as specified by the immediate value operand.",N,[[["__m64"],["i32"]],["__m64"]]],[5,"_mm_cvttps_pi32","","Convert the two lower packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers with truncation.",N,[[["__m128"]],["__m64"]]],[5,"_mm_cvtt_ps2pi","","Convert the two lower packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers with truncation.",N,[[["__m128"]],["__m64"]]],[5,"_mm_cvtps_pi32","","Convert the two lower packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers.",N,[[["__m128"]],["__m64"]]],[5,"_mm_cvt_ps2pi","","Convert the two lower packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers.",N,[[["__m128"]],["__m64"]]],[5,"_mm_cvtps_pi16","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed 16-bit integers.",N,[[["__m128"]],["__m64"]]],[5,"_mm_cvtps_pi8","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed 8-bit integers, and returns theem in the lower 4 elements of the result.",N,[[["__m128"]],["__m64"]]],[5,"_mm_pause","","Provide a hint to the processor that the code sequence is a spin-wait loop.",N,[[]]],[5,"_mm_clflush","","Invalidate and flush the cache line that contains `p` from all levels of the cache hierarchy.",N,N],[5,"_mm_lfence","","Perform a serializing operation on all load-from-memory instructions that were issued prior to this instruction.",N,[[]]],[5,"_mm_mfence","","Perform a serializing operation on all load-from-memory and store-to-memory instructions that were issued prior to this instruction.",N,[[]]],[5,"_mm_add_epi8","","Add packed 8-bit integers in `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_add_epi16","","Add packed 16-bit integers in `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_add_epi32","","Add packed 32-bit integers in `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_add_epi64","","Add packed 64-bit integers in `a` and \"b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_adds_epi8","","Add packed 8-bit integers in `a` and `b` using saturation.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_adds_epi16","","Add packed 16-bit integers in `a` and `b` using saturation.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_adds_epu8","","Add packed unsigned 8-bit integers in `a` and `b` using saturation.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_adds_epu16","","Add packed unsigned 16-bit integers in `a` and `b` using saturation.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_avg_epu8","","Average packed unsigned 8-bit integers in `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_avg_epu16","","Average packed unsigned 16-bit integers in `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_madd_epi16","","Multiply and then horizontally add signed 16 bit integers in `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_max_epi16","","Compare packed 16-bit integers in `a` and `b`, and return the packed maximum values.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_max_epu8","","Compare packed unsigned 8-bit integers in `a` and `b`, and return the packed maximum values.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_min_epi16","","Compare packed 16-bit integers in `a` and `b`, and return the packed minimum values.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_min_epu8","","Compare packed unsigned 8-bit integers in `a` and `b`, and return the packed minimum values.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_mulhi_epi16","","Multiply the packed 16-bit integers in `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_mulhi_epu16","","Multiply the packed unsigned 16-bit integers in `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_mullo_epi16","","Multiply the packed 16-bit integers in `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_mul_epu32","","Multiply the low unsigned 32-bit integers from each packed 64-bit element in `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_sad_epu8","","Sum the absolute differences of packed unsigned 8-bit integers.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_sub_epi8","","Subtract packed 8-bit integers in `b` from packed 8-bit integers in `a`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_sub_epi16","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_sub_epi32","","Subtract packed 32-bit integers in `b` from packed 32-bit integers in `a`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_sub_epi64","","Subtract packed 64-bit integers in `b` from packed 64-bit integers in `a`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_subs_epi8","","Subtract packed 8-bit integers in `b` from packed 8-bit integers in `a` using saturation.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_subs_epi16","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a` using saturation.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_subs_epu8","","Subtract packed unsigned 8-bit integers in `b` from packed unsigned 8-bit integers in `a` using saturation.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_subs_epu16","","Subtract packed unsigned 16-bit integers in `b` from packed unsigned 16-bit integers in `a` using saturation.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_slli_si128","","Shift `a` left by `imm8` bytes while shifting in zeros.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_bslli_si128","","Shift `a` left by `imm8` bytes while shifting in zeros.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_bsrli_si128","","Shift `a` right by `imm8` bytes while shifting in zeros.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_slli_epi16","","Shift packed 16-bit integers in `a` left by `imm8` while shifting in zeros.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_sll_epi16","","Shift packed 16-bit integers in `a` left by `count` while shifting in zeros.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_slli_epi32","","Shift packed 32-bit integers in `a` left by `imm8` while shifting in zeros.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_sll_epi32","","Shift packed 32-bit integers in `a` left by `count` while shifting in zeros.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_slli_epi64","","Shift packed 64-bit integers in `a` left by `imm8` while shifting in zeros.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_sll_epi64","","Shift packed 64-bit integers in `a` left by `count` while shifting in zeros.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_srai_epi16","","Shift packed 16-bit integers in `a` right by `imm8` while shifting in sign bits.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_sra_epi16","","Shift packed 16-bit integers in `a` right by `count` while shifting in sign bits.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_srai_epi32","","Shift packed 32-bit integers in `a` right by `imm8` while shifting in sign bits.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_sra_epi32","","Shift packed 32-bit integers in `a` right by `count` while shifting in sign bits.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_srli_si128","","Shift `a` right by `imm8` bytes while shifting in zeros.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_srli_epi16","","Shift packed 16-bit integers in `a` right by `imm8` while shifting in zeros.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_srl_epi16","","Shift packed 16-bit integers in `a` right by `count` while shifting in zeros.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_srli_epi32","","Shift packed 32-bit integers in `a` right by `imm8` while shifting in zeros.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_srl_epi32","","Shift packed 32-bit integers in `a` right by `count` while shifting in zeros.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_srli_epi64","","Shift packed 64-bit integers in `a` right by `imm8` while shifting in zeros.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_srl_epi64","","Shift packed 64-bit integers in `a` right by `count` while shifting in zeros.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_and_si128","","Compute the bitwise AND of 128 bits (representing integer data) in `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_andnot_si128","","Compute the bitwise NOT of 128 bits (representing integer data) in `a` and then AND with `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_or_si128","","Compute the bitwise OR of 128 bits (representing integer data) in `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_xor_si128","","Compute the bitwise XOR of 128 bits (representing integer data) in `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_cmpeq_epi8","","Compare packed 8-bit integers in `a` and `b` for equality.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_cmpeq_epi16","","Compare packed 16-bit integers in `a` and `b` for equality.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_cmpeq_epi32","","Compare packed 32-bit integers in `a` and `b` for equality.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_cmpgt_epi8","","Compare packed 8-bit integers in `a` and `b` for greater-than.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_cmpgt_epi16","","Compare packed 16-bit integers in `a` and `b` for greater-than.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_cmpgt_epi32","","Compare packed 32-bit integers in `a` and `b` for greater-than.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_cmplt_epi8","","Compare packed 8-bit integers in `a` and `b` for less-than.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_cmplt_epi16","","Compare packed 16-bit integers in `a` and `b` for less-than.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_cmplt_epi32","","Compare packed 32-bit integers in `a` and `b` for less-than.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_cvtepi32_pd","","Convert the lower two packed 32-bit integers in `a` to packed double-precision (64-bit) floating-point elements.",N,[[["__m128i"]],["__m128d"]]],[5,"_mm_cvtsi32_sd","","Return `a` with its lower element replaced by `b` after converting it to an `f64`.",N,[[["__m128d"],["i32"]],["__m128d"]]],[5,"_mm_cvtepi32_ps","","Convert packed 32-bit integers in `a` to packed single-precision (32-bit) floating-point elements.",N,[[["__m128i"]],["__m128"]]],[5,"_mm_cvtps_epi32","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers.",N,[[["__m128"]],["__m128i"]]],[5,"_mm_cvtsi32_si128","","Return a vector whose lowest element is `a` and all higher elements are `0`.",N,[[["i32"]],["__m128i"]]],[5,"_mm_cvtsi128_si32","","Return the lowest element of `a`.",N,[[["__m128i"]],["i32"]]],[5,"_mm_set_epi64x","","Set packed 64-bit integers with the supplied values, from highest to lowest.",N,[[["i64"],["i64"]],["__m128i"]]],[5,"_mm_set_epi32","","Set packed 32-bit integers with the supplied values.",N,[[["i32"],["i32"],["i32"],["i32"]],["__m128i"]]],[5,"_mm_set_epi16","","Set packed 16-bit integers with the supplied values.",N,[[["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"]],["__m128i"]]],[5,"_mm_set_epi8","","Set packed 8-bit integers with the supplied values.",N,[[["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"]],["__m128i"]]],[5,"_mm_set1_epi64x","","Broadcast 64-bit integer `a` to all elements.",N,[[["i64"]],["__m128i"]]],[5,"_mm_set1_epi32","","Broadcast 32-bit integer `a` to all elements.",N,[[["i32"]],["__m128i"]]],[5,"_mm_set1_epi16","","Broadcast 16-bit integer `a` to all elements.",N,[[["i16"]],["__m128i"]]],[5,"_mm_set1_epi8","","Broadcast 8-bit integer `a` to all elements.",N,[[["i8"]],["__m128i"]]],[5,"_mm_setr_epi32","","Set packed 32-bit integers with the supplied values in reverse order.",N,[[["i32"],["i32"],["i32"],["i32"]],["__m128i"]]],[5,"_mm_setr_epi16","","Set packed 16-bit integers with the supplied values in reverse order.",N,[[["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"]],["__m128i"]]],[5,"_mm_setr_epi8","","Set packed 8-bit integers with the supplied values in reverse order.",N,[[["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"]],["__m128i"]]],[5,"_mm_setzero_si128","","Returns a vector with all elements set to zero.",N,[[],["__m128i"]]],[5,"_mm_loadl_epi64","","Load 64-bit integer from memory into first element of returned vector.",N,N],[5,"_mm_load_si128","","Load 128-bits of integer data from memory into a new vector.",N,N],[5,"_mm_loadu_si128","","Load 128-bits of integer data from memory into a new vector.",N,N],[5,"_mm_maskmoveu_si128","","Conditionally store 8-bit integer elements from `a` into memory using `mask`.",N,N],[5,"_mm_store_si128","","Store 128-bits of integer data from `a` into memory.",N,N],[5,"_mm_storeu_si128","","Store 128-bits of integer data from `a` into memory.",N,N],[5,"_mm_storel_epi64","","Store the lower 64-bit integer `a` to a memory location.",N,N],[5,"_mm_stream_si128","","Stores a 128-bit integer vector to a 128-bit aligned memory location. To minimize caching, the data is flagged as non-temporal (unlikely to be used again soon).",N,N],[5,"_mm_stream_si32","","Stores a 32-bit integer value in the specified memory location. To minimize caching, the data is flagged as non-temporal (unlikely to be used again soon).",N,N],[5,"_mm_move_epi64","","Return a vector where the low element is extracted from `a` and its upper element is zero.",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_packs_epi16","","Convert packed 16-bit integers from `a` and `b` to packed 8-bit integers using signed saturation.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_packs_epi32","","Convert packed 32-bit integers from `a` and `b` to packed 16-bit integers using signed saturation.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_packus_epi16","","Convert packed 16-bit integers from `a` and `b` to packed 8-bit integers using unsigned saturation.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_extract_epi16","","Return the `imm8` element of `a`.",N,[[["__m128i"],["i32"]],["i32"]]],[5,"_mm_insert_epi16","","Return a new vector where the `imm8` element of `a` is replaced with `i`.",N,[[["__m128i"],["i32"],["i32"]],["__m128i"]]],[5,"_mm_movemask_epi8","","Return a mask of the most significant bit of each element in `a`.",N,[[["__m128i"]],["i32"]]],[5,"_mm_shuffle_epi32","","Shuffle 32-bit integers in `a` using the control in `imm8`.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_shufflehi_epi16","","Shuffle 16-bit integers in the high 64 bits of `a` using the control in `imm8`.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_shufflelo_epi16","","Shuffle 16-bit integers in the low 64 bits of `a` using the control in `imm8`.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_unpackhi_epi8","","Unpack and interleave 8-bit integers from the high half of `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_unpackhi_epi16","","Unpack and interleave 16-bit integers from the high half of `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_unpackhi_epi32","","Unpack and interleave 32-bit integers from the high half of `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_unpackhi_epi64","","Unpack and interleave 64-bit integers from the high half of `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_unpacklo_epi8","","Unpack and interleave 8-bit integers from the low half of `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_unpacklo_epi16","","Unpack and interleave 16-bit integers from the low half of `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_unpacklo_epi32","","Unpack and interleave 32-bit integers from the low half of `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_unpacklo_epi64","","Unpack and interleave 64-bit integers from the low half of `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_add_sd","","Return a new vector with the low element of `a` replaced by the sum of the low elements of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_add_pd","","Add packed double-precision (64-bit) floating-point elements in `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_div_sd","","Return a new vector with the low element of `a` replaced by the result of diving the lower element of `a` by the lower element of `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_div_pd","","Divide packed double-precision (64-bit) floating-point elements in `a` by packed elements in `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_max_sd","","Return a new vector with the low element of `a` replaced by the maximum of the lower elements of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_max_pd","","Return a new vector with the maximum values from corresponding elements in `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_min_sd","","Return a new vector with the low element of `a` replaced by the minimum of the lower elements of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_min_pd","","Return a new vector with the minimum values from corresponding elements in `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_mul_sd","","Return a new vector with the low element of `a` replaced by multiplying the low elements of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_mul_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_sqrt_sd","","Return a new vector with the low element of `a` replaced by the square root of the lower element `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_sqrt_pd","","Return a new vector with the square root of each of the values in `a`.",N,[[["__m128d"]],["__m128d"]]],[5,"_mm_sub_sd","","Return a new vector with the low element of `a` replaced by subtracting the low element by `b` from the low element of `a`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_sub_pd","","Subtract packed double-precision (64-bit) floating-point elements in `b` from `a`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_and_pd","","Compute the bitwise AND of packed double-precision (64-bit) floating-point elements in `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_andnot_pd","","Compute the bitwise NOT of `a` and then AND with `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_or_pd","","Compute the bitwise OR of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_xor_pd","","Compute the bitwise OR of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpeq_sd","","Return a new vector with the low element of `a` replaced by the equality comparison of the lower elements of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmplt_sd","","Return a new vector with the low element of `a` replaced by the less-than comparison of the lower elements of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmple_sd","","Return a new vector with the low element of `a` replaced by the less-than-or-equal comparison of the lower elements of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpgt_sd","","Return a new vector with the low element of `a` replaced by the greater-than comparison of the lower elements of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpge_sd","","Return a new vector with the low element of `a` replaced by the greater-than-or-equal comparison of the lower elements of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpord_sd","","Return a new vector with the low element of `a` replaced by the result of comparing both of the lower elements of `a` and `b` to `NaN`. If neither are equal to `NaN` then `0xFFFFFFFFFFFFFFFF` is used and `0` otherwise.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpunord_sd","","Return a new vector with the low element of `a` replaced by the result of comparing both of the lower elements of `a` and `b` to `NaN`. If either is equal to `NaN` then `0xFFFFFFFFFFFFFFFF` is used and `0` otherwise.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpneq_sd","","Return a new vector with the low element of `a` replaced by the not-equal comparison of the lower elements of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpnlt_sd","","Return a new vector with the low element of `a` replaced by the not-less-than comparison of the lower elements of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpnle_sd","","Return a new vector with the low element of `a` replaced by the not-less-than-or-equal comparison of the lower elements of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpngt_sd","","Return a new vector with the low element of `a` replaced by the not-greater-than comparison of the lower elements of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpnge_sd","","Return a new vector with the low element of `a` replaced by the not-greater-than-or-equal comparison of the lower elements of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpeq_pd","","Compare corresponding elements in `a` and `b` for equality.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmplt_pd","","Compare corresponding elements in `a` and `b` for less-than.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmple_pd","","Compare corresponding elements in `a` and `b` for less-than-or-equal",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpgt_pd","","Compare corresponding elements in `a` and `b` for greater-than.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpge_pd","","Compare corresponding elements in `a` and `b` for greater-than-or-equal.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpord_pd","","Compare corresponding elements in `a` and `b` to see if neither is `NaN`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpunord_pd","","Compare corresponding elements in `a` and `b` to see if either is `NaN`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpneq_pd","","Compare corresponding elements in `a` and `b` for not-equal.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpnlt_pd","","Compare corresponding elements in `a` and `b` for not-less-than.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpnle_pd","","Compare corresponding elements in `a` and `b` for not-less-than-or-equal.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpngt_pd","","Compare corresponding elements in `a` and `b` for not-greater-than.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpnge_pd","","Compare corresponding elements in `a` and `b` for not-greater-than-or-equal.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_comieq_sd","","Compare the lower element of `a` and `b` for equality.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm_comilt_sd","","Compare the lower element of `a` and `b` for less-than.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm_comile_sd","","Compare the lower element of `a` and `b` for less-than-or-equal.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm_comigt_sd","","Compare the lower element of `a` and `b` for greater-than.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm_comige_sd","","Compare the lower element of `a` and `b` for greater-than-or-equal.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm_comineq_sd","","Compare the lower element of `a` and `b` for not-equal.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm_ucomieq_sd","","Compare the lower element of `a` and `b` for equality.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm_ucomilt_sd","","Compare the lower element of `a` and `b` for less-than.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm_ucomile_sd","","Compare the lower element of `a` and `b` for less-than-or-equal.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm_ucomigt_sd","","Compare the lower element of `a` and `b` for greater-than.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm_ucomige_sd","","Compare the lower element of `a` and `b` for greater-than-or-equal.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm_ucomineq_sd","","Compare the lower element of `a` and `b` for not-equal.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm_cvtpd_ps","","Convert packed double-precision (64-bit) floating-point elements in \"a\" to packed single-precision (32-bit) floating-point elements",N,[[["__m128d"]],["__m128"]]],[5,"_mm_cvtps_pd","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed double-precision (64-bit) floating-point elements.",N,[[["__m128"]],["__m128d"]]],[5,"_mm_cvtpd_epi32","","Convert packed double-precision (64-bit) floating-point elements in `a` to packed 32-bit integers.",N,[[["__m128d"]],["__m128i"]]],[5,"_mm_cvtsd_si32","","Convert the lower double-precision (64-bit) floating-point element in a to a 32-bit integer.",N,[[["__m128d"]],["i32"]]],[5,"_mm_cvtsd_ss","","Convert the lower double-precision (64-bit) floating-point element in `b` to a single-precision (32-bit) floating-point element, store the result in the lower element of the return value, and copy the upper element from `a` to the upper element the return value.",N,[[["__m128"],["__m128d"]],["__m128"]]],[5,"_mm_cvtsd_f64","","Return the lower double-precision (64-bit) floating-point element of \"a\".",N,[[["__m128d"]],["f64"]]],[5,"_mm_cvtss_sd","","Convert the lower single-precision (32-bit) floating-point element in `b` to a double-precision (64-bit) floating-point element, store the result in the lower element of the return value, and copy the upper element from `a` to the upper element the return value.",N,[[["__m128d"],["__m128"]],["__m128d"]]],[5,"_mm_cvttpd_epi32","","Convert packed double-precision (64-bit) floating-point elements in `a` to packed 32-bit integers with truncation.",N,[[["__m128d"]],["__m128i"]]],[5,"_mm_cvttsd_si32","","Convert the lower double-precision (64-bit) floating-point element in `a` to a 32-bit integer with truncation.",N,[[["__m128d"]],["i32"]]],[5,"_mm_cvttps_epi32","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers with truncation.",N,[[["__m128"]],["__m128i"]]],[5,"_mm_set_sd","","Copy double-precision (64-bit) floating-point element `a` to the lower element of the packed 64-bit return value.",N,[[["f64"]],["__m128d"]]],[5,"_mm_set1_pd","","Broadcast double-precision (64-bit) floating-point value a to all elements of the return value.",N,[[["f64"]],["__m128d"]]],[5,"_mm_set_pd1","","Broadcast double-precision (64-bit) floating-point value a to all elements of the return value.",N,[[["f64"]],["__m128d"]]],[5,"_mm_set_pd","","Set packed double-precision (64-bit) floating-point elements in the return value with the supplied values.",N,[[["f64"],["f64"]],["__m128d"]]],[5,"_mm_setr_pd","","Set packed double-precision (64-bit) floating-point elements in the return value with the supplied values in reverse order.",N,[[["f64"],["f64"]],["__m128d"]]],[5,"_mm_setzero_pd","","Returns packed double-precision (64-bit) floating-point elements with all zeros.",N,[[],["__m128d"]]],[5,"_mm_movemask_pd","","Return a mask of the most significant bit of each element in `a`.",N,[[["__m128d"]],["i32"]]],[5,"_mm_load_pd","","Load 128-bits (composed of 2 packed double-precision (64-bit) floating-point elements) from memory into the returned vector. `mem_addr` must be aligned on a 16-byte boundary or a general-protection exception may be generated.",N,N],[5,"_mm_load_sd","","Loads a 64-bit double-precision value to the low element of a 128-bit integer vector and clears the upper element.",N,N],[5,"_mm_loadh_pd","","Loads a double-precision value into the high-order bits of a 128-bit vector of `[2 x double]`. The low-order bits are copied from the low-order bits of the first operand.",N,N],[5,"_mm_loadl_pd","","Loads a double-precision value into the low-order bits of a 128-bit vector of `[2 x double]`. The high-order bits are copied from the high-order bits of the first operand.",N,N],[5,"_mm_stream_pd","","Stores a 128-bit floating point vector of `[2 x double]` to a 128-bit aligned memory location. To minimize caching, the data is flagged as non-temporal (unlikely to be used again soon).",N,N],[5,"_mm_store_sd","","Stores the lower 64 bits of a 128-bit vector of `[2 x double]` to a memory location.",N,N],[5,"_mm_store_pd","","Store 128-bits (composed of 2 packed double-precision (64-bit) floating-point elements) from `a` into memory. `mem_addr` must be aligned on a 16-byte boundary or a general-protection exception may be generated.",N,N],[5,"_mm_storeu_pd","","Store 128-bits (composed of 2 packed double-precision (64-bit) floating-point elements) from `a` into memory. `mem_addr` does not need to be aligned on any particular boundary.",N,N],[5,"_mm_store1_pd","","Store the lower double-precision (64-bit) floating-point element from `a` into 2 contiguous elements in memory. `mem_addr` must be aligned on a 16-byte boundary or a general-protection exception may be generated.",N,N],[5,"_mm_store_pd1","","Store the lower double-precision (64-bit) floating-point element from `a` into 2 contiguous elements in memory. `mem_addr` must be aligned on a 16-byte boundary or a general-protection exception may be generated.",N,N],[5,"_mm_storer_pd","","Store 2 double-precision (64-bit) floating-point elements from `a` into memory in reverse order. `mem_addr` must be aligned on a 16-byte boundary or a general-protection exception may be generated.",N,N],[5,"_mm_storeh_pd","","Stores the upper 64 bits of a 128-bit vector of `[2 x double]` to a memory location.",N,N],[5,"_mm_storel_pd","","Stores the lower 64 bits of a 128-bit vector of `[2 x double]` to a memory location.",N,N],[5,"_mm_load1_pd","","Load a double-precision (64-bit) floating-point element from memory into both elements of returned vector.",N,N],[5,"_mm_load_pd1","","Load a double-precision (64-bit) floating-point element from memory into both elements of returned vector.",N,N],[5,"_mm_loadr_pd","","Load 2 double-precision (64-bit) floating-point elements from memory into the returned vector in reverse order. `mem_addr` must be aligned on a 16-byte boundary or a general-protection exception may be generated.",N,N],[5,"_mm_loadu_pd","","Load 128-bits (composed of 2 packed double-precision (64-bit) floating-point elements) from memory into the returned vector. `mem_addr` does not need to be aligned on any particular boundary.",N,N],[5,"_mm_shuffle_pd","","Constructs a 128-bit floating-point vector of `[2 x double]` from two 128-bit vector parameters of `[2 x double]`, using the immediate-value parameter as a specifier.",N,[[["__m128d"],["__m128d"],["i32"]],["__m128d"]]],[5,"_mm_move_sd","","Constructs a 128-bit floating-point vector of `[2 x double]`. The lower 64 bits are set to the lower 64 bits of the second parameter. The upper 64 bits are set to the upper 64 bits of the first parameter.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_castpd_ps","","Casts a 128-bit floating-point vector of `[2 x double]` into a 128-bit floating-point vector of `[4 x float]`.",N,[[["__m128d"]],["__m128"]]],[5,"_mm_castpd_si128","","Casts a 128-bit floating-point vector of `[2 x double]` into a 128-bit integer vector.",N,[[["__m128d"]],["__m128i"]]],[5,"_mm_castps_pd","","Casts a 128-bit floating-point vector of `[4 x float]` into a 128-bit floating-point vector of `[2 x double]`.",N,[[["__m128"]],["__m128d"]]],[5,"_mm_castps_si128","","Casts a 128-bit floating-point vector of `[4 x float]` into a 128-bit integer vector.",N,[[["__m128"]],["__m128i"]]],[5,"_mm_castsi128_pd","","Casts a 128-bit integer vector into a 128-bit floating-point vector of `[2 x double]`.",N,[[["__m128i"]],["__m128d"]]],[5,"_mm_castsi128_ps","","Casts a 128-bit integer vector into a 128-bit floating-point vector of `[4 x float]`.",N,[[["__m128i"]],["__m128"]]],[5,"_mm_undefined_pd","","Return vector of type __m128d with undefined elements.",N,[[],["__m128d"]]],[5,"_mm_undefined_si128","","Return vector of type __m128i with undefined elements.",N,[[],["__m128i"]]],[5,"_mm_unpackhi_pd","","The resulting `__m128d` element is composed by the low-order values of the two `__m128d` interleaved input elements, i.e.:",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_unpacklo_pd","","The resulting `__m128d` element is composed by the high-order values of the two `__m128d` interleaved input elements, i.e.:",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_add_si64","","Adds two signed or unsigned 64-bit integer values, returning the lower 64 bits of the sum.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_mul_su32","","Multiplies 32-bit unsigned integer values contained in the lower bits of the two 64-bit integer vectors and returns the 64-bit unsigned product.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_sub_si64","","Subtracts signed or unsigned 64-bit integer values and writes the difference to the corresponding bits in the destination.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_cvtpi32_pd","","Converts the two signed 32-bit integer elements of a 64-bit vector of `[2 x i32]` into two double-precision floating-point values, returned in a 128-bit vector of `[2 x double]`.",N,[[["__m64"]],["__m128d"]]],[5,"_mm_set_epi64","","Initializes both 64-bit values in a 128-bit vector of `[2 x i64]` with the specified 64-bit integer values.",N,[[["__m64"],["__m64"]],["__m128i"]]],[5,"_mm_set1_epi64","","Initializes both values in a 128-bit vector of `[2 x i64]` with the specified 64-bit value.",N,[[["__m64"]],["__m128i"]]],[5,"_mm_setr_epi64","","Constructs a 128-bit integer vector, initialized in reverse order with the specified 64-bit integral values.",N,[[["__m64"],["__m64"]],["__m128i"]]],[5,"_mm_movepi64_pi64","","Returns the lower 64 bits of a 128-bit integer vector as a 64-bit integer.",N,[[["__m128i"]],["__m64"]]],[5,"_mm_movpi64_epi64","","Moves the 64-bit operand to a 128-bit integer vector, zeroing the upper bits.",N,[[["__m64"]],["__m128i"]]],[5,"_mm_cvtpd_pi32","","Converts the two double-precision floating-point elements of a 128-bit vector of `[2 x double]` into two signed 32-bit integer values, returned in a 64-bit vector of `[2 x i32]`.",N,[[["__m128d"]],["__m64"]]],[5,"_mm_cvttpd_pi32","","Converts the two double-precision floating-point elements of a 128-bit vector of `[2 x double]` into two signed 32-bit integer values, returned in a 64-bit vector of `[2 x i32]`. If the result of either conversion is inexact, the result is truncated (rounded towards zero) regardless of the current MXCSR setting.",N,[[["__m128d"]],["__m64"]]],[5,"_mm_addsub_ps","","Alternatively add and subtract packed single-precision (32-bit) floating-point elements in `a` to/from packed elements in `b`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_addsub_pd","","Alternatively add and subtract packed double-precision (64-bit) floating-point elements in `a` to/from packed elements in `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_hadd_pd","","Horizontally add adjacent pairs of double-precision (64-bit) floating-point elements in `a` and `b`, and pack the results.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_hadd_ps","","Horizontally add adjacent pairs of single-precision (32-bit) floating-point elements in `a` and `b`, and pack the results.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_hsub_pd","","Horizontally subtract adjacent pairs of double-precision (64-bit) floating-point elements in `a` and `b`, and pack the results.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_hsub_ps","","Horizontally add adjacent pairs of single-precision (32-bit) floating-point elements in `a` and `b`, and pack the results.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_lddqu_si128","","Load 128-bits of integer data from unaligned memory. This intrinsic may perform better than `_mm_loadu_si128` when the data crosses a cache line boundary.",N,N],[5,"_mm_movedup_pd","","Duplicate the low double-precision (64-bit) floating-point element from `a`.",N,[[["__m128d"]],["__m128d"]]],[5,"_mm_loaddup_pd","","Load a double-precision (64-bit) floating-point element from memory into both elements of return vector.",N,N],[5,"_mm_movehdup_ps","","Duplicate odd-indexed single-precision (32-bit) floating-point elements from `a`.",N,[[["__m128"]],["__m128"]]],[5,"_mm_moveldup_ps","","Duplicate even-indexed single-precision (32-bit) floating-point elements from `a`.",N,[[["__m128"]],["__m128"]]],[5,"_mm_abs_epi8","","Compute the absolute value of packed 8-bit signed integers in `a` and return the unsigned results.",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_abs_epi16","","Compute the absolute value of each of the packed 16-bit signed integers in `a` and return the 16-bit unsigned integer",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_abs_epi32","","Compute the absolute value of each of the packed 32-bit signed integers in `a` and return the 32-bit unsigned integer",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_shuffle_epi8","","Shuffle bytes from `a` according to the content of `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_alignr_epi8","","Concatenate 16-byte blocks in `a` and `b` into a 32-byte temporary result, shift the result right by `n` bytes, and return the low 16 bytes.",N,[[["__m128i"],["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_hadd_epi16","","Horizontally add the adjacent pairs of values contained in 2 packed 128-bit vectors of `[8 x i16]`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_hadds_epi16","","Horizontally add the adjacent pairs of values contained in 2 packed 128-bit vectors of `[8 x i16]`. Positive sums greater than 7FFFh are saturated to 7FFFh. Negative sums less than 8000h are saturated to 8000h.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_hadd_epi32","","Horizontally add the adjacent pairs of values contained in 2 packed 128-bit vectors of `[4 x i32]`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_hsub_epi16","","Horizontally subtract the adjacent pairs of values contained in 2 packed 128-bit vectors of `[8 x i16]`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_hsubs_epi16","","Horizontally subtract the adjacent pairs of values contained in 2 packed 128-bit vectors of `[8 x i16]`. Positive differences greater than 7FFFh are saturated to 7FFFh. Negative differences less than 8000h are saturated to 8000h.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_hsub_epi32","","Horizontally subtract the adjacent pairs of values contained in 2 packed 128-bit vectors of `[4 x i32]`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_maddubs_epi16","","Multiply corresponding pairs of packed 8-bit unsigned integer values contained in the first source operand and packed 8-bit signed integer values contained in the second source operand, add pairs of contiguous products with signed saturation, and writes the 16-bit sums to the corresponding bits in the destination.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_mulhrs_epi16","","Multiply packed 16-bit signed integer values, truncate the 32-bit product to the 18 most significant bits by right-shifting, round the truncated value by adding 1, and write bits `[16:1]` to the destination.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_sign_epi8","","Negate packed 8-bit integers in `a` when the corresponding signed 8-bit integer in `b` is negative, and return the result. Elements in result are zeroed out when the corresponding element in `b` is zero.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_sign_epi16","","Negate packed 16-bit integers in `a` when the corresponding signed 16-bit integer in `b` is negative, and return the results. Elements in result are zeroed out when the corresponding element in `b` is zero.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_sign_epi32","","Negate packed 32-bit integers in `a` when the corresponding signed 32-bit integer in `b` is negative, and return the results. Element in result are zeroed out when the corresponding element in `b` is zero.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_abs_pi8","","Compute the absolute value of packed 8-bit integers in `a` and return the unsigned results.",N,[[["__m64"]],["__m64"]]],[5,"_mm_abs_pi16","","Compute the absolute value of packed 8-bit integers in `a`, and return the unsigned results.",N,[[["__m64"]],["__m64"]]],[5,"_mm_abs_pi32","","Compute the absolute value of packed 32-bit integers in `a`, and return the unsigned results.",N,[[["__m64"]],["__m64"]]],[5,"_mm_shuffle_pi8","","Shuffle packed 8-bit integers in `a` according to shuffle control mask in the corresponding 8-bit element of `b`, and return the results",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_alignr_pi8","","Concatenates the two 64-bit integer vector operands, and right-shifts the result by the number of bytes specified in the immediate operand.",N,[[["__m64"],["__m64"],["i32"]],["__m64"]]],[5,"_mm_hadd_pi16","","Horizontally add the adjacent pairs of values contained in 2 packed 64-bit vectors of `[4 x i16]`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_hadd_pi32","","Horizontally add the adjacent pairs of values contained in 2 packed 64-bit vectors of `[2 x i32]`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_hadds_pi16","","Horizontally add the adjacent pairs of values contained in 2 packed 64-bit vectors of `[4 x i16]`. Positive sums greater than 7FFFh are saturated to 7FFFh. Negative sums less than 8000h are saturated to 8000h.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_hsub_pi16","","Horizontally subtracts the adjacent pairs of values contained in 2 packed 64-bit vectors of `[4 x i16]`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_hsub_pi32","","Horizontally subtracts the adjacent pairs of values contained in 2 packed 64-bit vectors of `[2 x i32]`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_hsubs_pi16","","Horizontally subtracts the adjacent pairs of values contained in 2 packed 64-bit vectors of `[4 x i16]`. Positive differences greater than 7FFFh are saturated to 7FFFh. Negative differences less than 8000h are saturated to 8000h.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_maddubs_pi16","","Multiplies corresponding pairs of packed 8-bit unsigned integer values contained in the first source operand and packed 8-bit signed integer values contained in the second source operand, adds pairs of contiguous products with signed saturation, and writes the 16-bit sums to the corresponding bits in the destination.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_mulhrs_pi16","","Multiplies packed 16-bit signed integer values, truncates the 32-bit products to the 18 most significant bits by right-shifting, rounds the truncated value by adding 1, and writes bits `[16:1]` to the destination.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_sign_pi8","","Negate packed 8-bit integers in `a` when the corresponding signed 8-bit integer in `b` is negative, and return the results. Element in result are zeroed out when the corresponding element in `b` is zero.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_sign_pi16","","Negate packed 16-bit integers in `a` when the corresponding signed 16-bit integer in `b` is negative, and return the results. Element in result are zeroed out when the corresponding element in `b` is zero.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_sign_pi32","","Negate packed 32-bit integers in `a` when the corresponding signed 32-bit integer in `b` is negative, and return the results. Element in result are zeroed out when the corresponding element in `b` is zero.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_blendv_epi8","","Blend packed 8-bit integers from `a` and `b` using `mask`",N,[[["__m128i"],["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_blend_epi16","","Blend packed 16-bit integers from `a` and `b` using the mask `imm8`.",N,[[["__m128i"],["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_blendv_pd","","Blend packed double-precision (64-bit) floating-point elements from `a` and `b` using `mask`",N,[[["__m128d"],["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_blendv_ps","","Blend packed single-precision (32-bit) floating-point elements from `a` and `b` using `mask`",N,[[["__m128"],["__m128"],["__m128"]],["__m128"]]],[5,"_mm_blend_pd","","Blend packed double-precision (64-bit) floating-point elements from `a` and `b` using control mask `imm2`",N,[[["__m128d"],["__m128d"],["i32"]],["__m128d"]]],[5,"_mm_blend_ps","","Blend packed single-precision (32-bit) floating-point elements from `a` and `b` using mask `imm4`",N,[[["__m128"],["__m128"],["i32"]],["__m128"]]],[5,"_mm_extract_ps","","Extract a single-precision (32-bit) floating-point element from `a`, selected with `imm8`",N,[[["__m128"],["i32"]],["i32"]]],[5,"_mm_extract_epi8","","Extract an 8-bit integer from `a`, selected with `imm8`. Returns a 32-bit integer containing the zero-extended integer data.",N,[[["__m128i"],["i32"]],["i32"]]],[5,"_mm_extract_epi32","","Extract an 32-bit integer from `a` selected with `imm8`",N,[[["__m128i"],["i32"]],["i32"]]],[5,"_mm_insert_ps","","Select a single value in `a` to store at some position in `b`, Then zero elements according to `imm8`.",N,[[["__m128"],["__m128"],["i32"]],["__m128"]]],[5,"_mm_insert_epi8","","Return a copy of `a` with the 8-bit integer from `i` inserted at a location specified by `imm8`.",N,[[["__m128i"],["i32"],["i32"]],["__m128i"]]],[5,"_mm_insert_epi32","","Return a copy of `a` with the 32-bit integer from `i` inserted at a location specified by `imm8`.",N,[[["__m128i"],["i32"],["i32"]],["__m128i"]]],[5,"_mm_max_epi8","","Compare packed 8-bit integers in `a` and `b` and return packed maximum values in dst.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_max_epu16","","Compare packed unsigned 16-bit integers in `a` and `b`, and return packed maximum.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_max_epi32","","Compare packed 32-bit integers in `a` and `b`, and return packed maximum values.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_max_epu32","","Compare packed unsigned 32-bit integers in `a` and `b`, and return packed maximum values.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_min_epi8","","Compare packed 8-bit integers in `a` and `b` and return packed minimum values in dst.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_min_epu16","","Compare packed unsigned 16-bit integers in `a` and `b`, and return packed minimum.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_min_epi32","","Compare packed 32-bit integers in `a` and `b`, and return packed minimum values.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_min_epu32","","Compare packed unsigned 32-bit integers in `a` and `b`, and return packed minimum values.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_packus_epi32","","Convert packed 32-bit integers from `a` and `b` to packed 16-bit integers using unsigned saturation",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_cmpeq_epi64","","Compare packed 64-bit integers in `a` and `b` for equality",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_cvtepi8_epi16","","Sign extend packed 8-bit integers in `a` to packed 16-bit integers",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepi8_epi32","","Sign extend packed 8-bit integers in `a` to packed 32-bit integers",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepi8_epi64","","Sign extend packed 8-bit integers in the low 8 bytes of `a` to packed 64-bit integers",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepi16_epi32","","Sign extend packed 16-bit integers in `a` to packed 32-bit integers",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepi16_epi64","","Sign extend packed 16-bit integers in `a` to packed 64-bit integers",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepi32_epi64","","Sign extend packed 32-bit integers in `a` to packed 64-bit integers",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepu8_epi16","","Zero extend packed unsigned 8-bit integers in `a` to packed 16-bit integers",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepu8_epi32","","Zero extend packed unsigned 8-bit integers in `a` to packed 32-bit integers",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepu8_epi64","","Zero extend packed unsigned 8-bit integers in `a` to packed 64-bit integers",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepu16_epi32","","Zero extend packed unsigned 16-bit integers in `a` to packed 32-bit integers",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepu16_epi64","","Zero extend packed unsigned 16-bit integers in `a` to packed 64-bit integers",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepu32_epi64","","Zero extend packed unsigned 32-bit integers in `a` to packed 64-bit integers",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_dp_pd","","Returns the dot product of two __m128d vectors.",N,[[["__m128d"],["__m128d"],["i32"]],["__m128d"]]],[5,"_mm_dp_ps","","Returns the dot product of two __m128 vectors.",N,[[["__m128"],["__m128"],["i32"]],["__m128"]]],[5,"_mm_floor_pd","","Round the packed double-precision (64-bit) floating-point elements in `a` down to an integer value, and store the results as packed double-precision floating-point elements.",N,[[["__m128d"]],["__m128d"]]],[5,"_mm_floor_ps","","Round the packed single-precision (32-bit) floating-point elements in `a` down to an integer value, and store the results as packed single-precision floating-point elements.",N,[[["__m128"]],["__m128"]]],[5,"_mm_floor_sd","","Round the lower double-precision (64-bit) floating-point element in `b` down to an integer value, store the result as a double-precision floating-point element in the lower element of the intrinsic result, and copy the upper element from `a` to the upper element of the intrinsic result.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_floor_ss","","Round the lower single-precision (32-bit) floating-point element in `b` down to an integer value, store the result as a single-precision floating-point element in the lower element of the intrinsic result, and copy the upper 3 packed elements from `a` to the upper elements of the intrinsic result.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_ceil_pd","","Round the packed double-precision (64-bit) floating-point elements in `a` up to an integer value, and store the results as packed double-precision floating-point elements.",N,[[["__m128d"]],["__m128d"]]],[5,"_mm_ceil_ps","","Round the packed single-precision (32-bit) floating-point elements in `a` up to an integer value, and store the results as packed single-precision floating-point elements.",N,[[["__m128"]],["__m128"]]],[5,"_mm_ceil_sd","","Round the lower double-precision (64-bit) floating-point element in `b` up to an integer value, store the result as a double-precision floating-point element in the lower element of the intrisic result, and copy the upper element from `a` to the upper element of the intrinsic result.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_ceil_ss","","Round the lower single-precision (32-bit) floating-point element in `b` up to an integer value, store the result as a single-precision floating-point element in the lower element of the intrinsic result, and copy the upper 3 packed elements from `a` to the upper elements of the intrinsic result.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_round_pd","","Round the packed double-precision (64-bit) floating-point elements in `a` using the `rounding` parameter, and store the results as packed double-precision floating-point elements. Rounding is done according to the rounding parameter, which can be one of:",N,[[["__m128d"],["i32"]],["__m128d"]]],[5,"_mm_round_ps","","Round the packed single-precision (32-bit) floating-point elements in `a` using the `rounding` parameter, and store the results as packed single-precision floating-point elements. Rounding is done according to the rounding parameter, which can be one of:",N,[[["__m128"],["i32"]],["__m128"]]],[5,"_mm_round_sd","","Round the lower double-precision (64-bit) floating-point element in `b` using the `rounding` parameter, store the result as a double-precision floating-point element in the lower element of the intrinsic result, and copy the upper element from `a` to the upper element of the intrinsic result. Rounding is done according to the rounding parameter, which can be one of:",N,[[["__m128d"],["__m128d"],["i32"]],["__m128d"]]],[5,"_mm_round_ss","","Round the lower single-precision (32-bit) floating-point element in `b` using the `rounding` parameter, store the result as a single-precision floating-point element in the lower element of the intrinsic result, and copy the upper 3 packed elements from `a` to the upper elements of the instrinsic result. Rounding is done according to the rounding parameter, which can be one of:",N,[[["__m128"],["__m128"],["i32"]],["__m128"]]],[5,"_mm_minpos_epu16","","Finds the minimum unsigned 16-bit element in the 128-bit __m128i vector, returning a vector containing its value in its first position, and its index in its second position; all other elements are set to zero.",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_mul_epi32","","Multiply the low 32-bit integers from each packed 64-bit element in `a` and `b`, and return the signed 64-bit result.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_mullo_epi32","","Multiply the packed 32-bit integers in `a` and `b`, producing intermediate 64-bit integers, and returns the lowest 32-bit, whatever they might be, reinterpreted as a signed integer. While `pmulld __m128i::splat(2), __m128i::splat(2)` returns the obvious `__m128i::splat(4)`, due to wrapping arithmetic `pmulld __m128i::splat(i32::MAX), __m128i::splat(2)` would return a negative number.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_mpsadbw_epu8","","Subtracts 8-bit unsigned integer values and computes the absolute values of the differences to the corresponding bits in the destination. Then sums of the absolute differences are returned according to the bit fields in the immediate operand.",N,[[["__m128i"],["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_testz_si128","","Tests whether the specified bits in a 128-bit integer vector are all zeros.",N,[[["__m128i"],["__m128i"]],["i32"]]],[5,"_mm_testc_si128","","Tests whether the specified bits in a 128-bit integer vector are all ones.",N,[[["__m128i"],["__m128i"]],["i32"]]],[5,"_mm_testnzc_si128","","Tests whether the specified bits in a 128-bit integer vector are neither all zeros nor all ones.",N,[[["__m128i"],["__m128i"]],["i32"]]],[5,"_mm_test_all_zeros","","Tests whether the specified bits in a 128-bit integer vector are all zeros.",N,[[["__m128i"],["__m128i"]],["i32"]]],[5,"_mm_test_all_ones","","Tests whether the specified bits in `a` 128-bit integer vector are all ones.",N,[[["__m128i"]],["i32"]]],[5,"_mm_test_mix_ones_zeros","","Tests whether the specified bits in a 128-bit integer vector are neither all zeros nor all ones.",N,[[["__m128i"],["__m128i"]],["i32"]]],[5,"_mm_cmpistrm","","Compare packed strings with implicit lengths in `a` and `b` using the control in `imm8`, and return the generated mask.",N,[[["__m128i"],["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_cmpistri","","Compare packed strings with implicit lengths in `a` and `b` using the control in `imm8` and return the generated index. Similar to [`_mm_cmpestri`] with the exception that [`_mm_cmpestri`] requires the lengths of `a` and `b` to be explicitly specified.",N,[[["__m128i"],["__m128i"],["i32"]],["i32"]]],[5,"_mm_cmpistrz","","Compare packed strings with implicit lengths in `a` and `b` using the control in `imm8`, and return `1` if any character in `b` was null. and `0` otherwise.",N,[[["__m128i"],["__m128i"],["i32"]],["i32"]]],[5,"_mm_cmpistrc","","Compare packed strings with implicit lengths in `a` and `b` using the control in `imm8`, and return `1` if the resulting mask was non-zero, and `0` otherwise.",N,[[["__m128i"],["__m128i"],["i32"]],["i32"]]],[5,"_mm_cmpistrs","","Compare packed strings with implicit lengths in `a` and `b` using the control in `imm8`, and returns `1` if any character in `a` was null, and `0` otherwise.",N,[[["__m128i"],["__m128i"],["i32"]],["i32"]]],[5,"_mm_cmpistro","","Compare packed strings with implicit lengths in `a` and `b` using the control in `imm8`, and return bit `0` of the resulting bit mask.",N,[[["__m128i"],["__m128i"],["i32"]],["i32"]]],[5,"_mm_cmpistra","","Compare packed strings with implicit lengths in `a` and `b` using the control in `imm8`, and return `1` if `b` did not contain a null character and the resulting mask was zero, and `0` otherwise.",N,[[["__m128i"],["__m128i"],["i32"]],["i32"]]],[5,"_mm_cmpestrm","","Compare packed strings in `a` and `b` with lengths `la` and `lb` using the control in `imm8`, and return the generated mask.",N,[[["__m128i"],["i32"],["__m128i"],["i32"],["i32"]],["__m128i"]]],[5,"_mm_cmpestri","","Compare packed strings `a` and `b` with lengths `la` and `lb` using the control in `imm8` and return the generated index. Similar to [`_mm_cmpistri`] with the exception that [`_mm_cmpistri`] implicitly determines the length of `a` and `b`.",N,[[["__m128i"],["i32"],["__m128i"],["i32"],["i32"]],["i32"]]],[5,"_mm_cmpestrz","","Compare packed strings in `a` and `b` with lengths `la` and `lb` using the control in `imm8`, and return `1` if any character in `b` was null, and `0` otherwise.",N,[[["__m128i"],["i32"],["__m128i"],["i32"],["i32"]],["i32"]]],[5,"_mm_cmpestrc","","Compare packed strings in `a` and `b` with lengths `la` and `lb` using the control in `imm8`, and return `1` if the resulting mask was non-zero, and `0` otherwise.",N,[[["__m128i"],["i32"],["__m128i"],["i32"],["i32"]],["i32"]]],[5,"_mm_cmpestrs","","Compare packed strings in `a` and `b` with lengths `la` and `lb` using the control in `imm8`, and return `1` if any character in a was null, and `0` otherwise.",N,[[["__m128i"],["i32"],["__m128i"],["i32"],["i32"]],["i32"]]],[5,"_mm_cmpestro","","Compare packed strings in `a` and `b` with lengths `la` and `lb` using the control in `imm8`, and return bit `0` of the resulting bit mask.",N,[[["__m128i"],["i32"],["__m128i"],["i32"],["i32"]],["i32"]]],[5,"_mm_cmpestra","","Compare packed strings in `a` and `b` with lengths `la` and `lb` using the control in `imm8`, and return `1` if `b` did not contain a null character and the resulting mask was zero, and `0` otherwise.",N,[[["__m128i"],["i32"],["__m128i"],["i32"],["i32"]],["i32"]]],[5,"_mm_crc32_u8","","Starting with the initial value in `crc`, return the accumulated CRC32 value for unsigned 8-bit integer `v`.",N,[[["u32"],["u8"]],["u32"]]],[5,"_mm_crc32_u16","","Starting with the initial value in `crc`, return the accumulated CRC32 value for unsigned 16-bit integer `v`.",N,[[["u32"],["u16"]],["u32"]]],[5,"_mm_crc32_u32","","Starting with the initial value in `crc`, return the accumulated CRC32 value for unsigned 32-bit integer `v`.",N,[[["u32"],["u32"]],["u32"]]],[5,"_mm_cmpgt_epi64","","Compare packed 64-bit integers in `a` and `b` for greater-than, return the results.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm256_add_pd","","Add packed double-precision (64-bit) floating-point elements in `a` and `b`.",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_add_ps","","Add packed single-precision (32-bit) floating-point elements in `a` and `b`.",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_and_pd","","Compute the bitwise AND of a packed double-precision (64-bit) floating-point elements in `a` and `b`.",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_and_ps","","Compute the bitwise AND of packed single-precision (32-bit) floating-point elements in `a` and `b`.",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_or_pd","","Compute the bitwise OR packed double-precision (64-bit) floating-point elements in `a` and `b`.",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_or_ps","","Compute the bitwise OR packed single-precision (32-bit) floating-point elements in `a` and `b`.",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_shuffle_pd","","Shuffle double-precision (64-bit) floating-point elements within 128-bit lanes using the control in `imm8`.",N,[[["__m256d"],["__m256d"],["i32"]],["__m256d"]]],[5,"_mm256_shuffle_ps","","Shuffle single-precision (32-bit) floating-point elements in `a` within 128-bit lanes using the control in `imm8`.",N,[[["__m256"],["__m256"],["i32"]],["__m256"]]],[5,"_mm256_andnot_pd","","Compute the bitwise NOT of packed double-precision (64-bit) floating-point elements in `a` and then AND with `b`.",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_andnot_ps","","Compute the bitwise NOT of packed single-precision (32-bit) floating-point elements in `a` and then AND with `b`.",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_max_pd","","Compare packed double-precision (64-bit) floating-point elements in `a` and `b`, and return packed maximum values",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_max_ps","","Compare packed single-precision (32-bit) floating-point elements in `a` and `b`, and return packed maximum values",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_min_pd","","Compare packed double-precision (64-bit) floating-point elements in `a` and `b`, and return packed minimum values",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_min_ps","","Compare packed single-precision (32-bit) floating-point elements in `a` and `b`, and return packed minimum values",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_mul_pd","","Add packed double-precision (64-bit) floating-point elements in `a` and `b`.",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_mul_ps","","Add packed single-precision (32-bit) floating-point elements in `a` and `b`.",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_addsub_pd","","Alternatively add and subtract packed double-precision (64-bit) floating-point elements in `a` to/from packed elements in `b`.",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_addsub_ps","","Alternatively add and subtract packed single-precision (32-bit) floating-point elements in `a` to/from packed elements in `b`.",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_sub_pd","","Subtract packed double-precision (64-bit) floating-point elements in `b` from packed elements in `a`.",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_sub_ps","","Subtract packed single-precision (32-bit) floating-point elements in `b` from packed elements in `a`.",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_div_ps","","Compute the division of each of the 8 packed 32-bit floating-point elements in `a` by the corresponding packed elements in `b`.",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_div_pd","","Compute the division of each of the 4 packed 64-bit floating-point elements in `a` by the corresponding packed elements in `b`.",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_round_pd","","Round packed double-precision (64-bit) floating point elements in `a` according to the flag `b`. The value of `b` may be as follows:",N,[[["__m256d"],["i32"]],["__m256d"]]],[5,"_mm256_ceil_pd","","Round packed double-precision (64-bit) floating point elements in `a` toward positive infinity.",N,[[["__m256d"]],["__m256d"]]],[5,"_mm256_floor_pd","","Round packed double-precision (64-bit) floating point elements in `a` toward negative infinity.",N,[[["__m256d"]],["__m256d"]]],[5,"_mm256_round_ps","","Round packed single-precision (32-bit) floating point elements in `a` according to the flag `b`. The value of `b` may be as follows:",N,[[["__m256"],["i32"]],["__m256"]]],[5,"_mm256_ceil_ps","","Round packed single-precision (32-bit) floating point elements in `a` toward positive infinity.",N,[[["__m256"]],["__m256"]]],[5,"_mm256_floor_ps","","Round packed single-precision (32-bit) floating point elements in `a` toward negative infinity.",N,[[["__m256"]],["__m256"]]],[5,"_mm256_sqrt_ps","","Return the square root of packed single-precision (32-bit) floating point elements in `a`.",N,[[["__m256"]],["__m256"]]],[5,"_mm256_sqrt_pd","","Return the square root of packed double-precision (64-bit) floating point elements in `a`.",N,[[["__m256d"]],["__m256d"]]],[5,"_mm256_blend_pd","","Blend packed double-precision (64-bit) floating-point elements from `a` and `b` using control mask `imm8`.",N,[[["__m256d"],["__m256d"],["i32"]],["__m256d"]]],[5,"_mm256_blend_ps","","Blend packed single-precision (32-bit) floating-point elements from `a` and `b` using control mask `imm8`.",N,[[["__m256"],["__m256"],["i32"]],["__m256"]]],[5,"_mm256_blendv_pd","","Blend packed double-precision (64-bit) floating-point elements from `a` and `b` using `c` as a mask.",N,[[["__m256d"],["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_blendv_ps","","Blend packed single-precision (32-bit) floating-point elements from `a` and `b` using `c` as a mask.",N,[[["__m256"],["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_dp_ps","","Conditionally multiply the packed single-precision (32-bit) floating-point elements in `a` and `b` using the high 4 bits in `imm8`, sum the four products, and conditionally return the sum  using the low 4 bits of `imm8`.",N,[[["__m256"],["__m256"],["i32"]],["__m256"]]],[5,"_mm256_hadd_pd","","Horizontal addition of adjacent pairs in the two packed vectors of 4 64-bit floating points `a` and `b`. In the result, sums of elements from `a` are returned in even locations, while sums of elements from `b` are returned in odd locations.",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_hadd_ps","","Horizontal addition of adjacent pairs in the two packed vectors of 8 32-bit floating points `a` and `b`. In the result, sums of elements from `a` are returned in locations of indices 0, 1, 4, 5; while sums of elements from `b` are locations 2, 3, 6, 7.",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_hsub_pd","","Horizontal subtraction of adjacent pairs in the two packed vectors of 4 64-bit floating points `a` and `b`. In the result, sums of elements from `a` are returned in even locations, while sums of elements from `b` are returned in odd locations.",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_hsub_ps","","Horizontal subtraction of adjacent pairs in the two packed vectors of 8 32-bit floating points `a` and `b`. In the result, sums of elements from `a` are returned in locations of indices 0, 1, 4, 5; while sums of elements from `b` are locations 2, 3, 6, 7.",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_xor_pd","","Compute the bitwise XOR of packed double-precision (64-bit) floating-point elements in `a` and `b`.",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_xor_ps","","Compute the bitwise XOR of packed single-precision (32-bit) floating-point elements in `a` and `b`.",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm_cmp_pd","","Compare packed double-precision (64-bit) floating-point elements in `a` and `b` based on the comparison operand specified by `imm8`.",N,[[["__m128d"],["__m128d"],["i32"]],["__m128d"]]],[5,"_mm256_cmp_pd","","Compare packed double-precision (64-bit) floating-point elements in `a` and `b` based on the comparison operand specified by `imm8`.",N,[[["__m256d"],["__m256d"],["i32"]],["__m256d"]]],[5,"_mm_cmp_ps","","Compare packed single-precision (32-bit) floating-point elements in `a` and `b` based on the comparison operand specified by `imm8`.",N,[[["__m128"],["__m128"],["i32"]],["__m128"]]],[5,"_mm256_cmp_ps","","Compare packed single-precision (32-bit) floating-point elements in `a` and `b` based on the comparison operand specified by `imm8`.",N,[[["__m256"],["__m256"],["i32"]],["__m256"]]],[5,"_mm_cmp_sd","","Compare the lower double-precision (64-bit) floating-point element in `a` and `b` based on the comparison operand specified by `imm8`, store the result in the lower element of returned vector, and copy the upper element from `a` to the upper element of returned vector.",N,[[["__m128d"],["__m128d"],["i32"]],["__m128d"]]],[5,"_mm_cmp_ss","","Compare the lower single-precision (32-bit) floating-point element in `a` and `b` based on the comparison operand specified by `imm8`, store the result in the lower element of returned vector, and copy the upper 3 packed elements from `a` to the upper elements of returned vector.",N,[[["__m128"],["__m128"],["i32"]],["__m128"]]],[5,"_mm256_cvtepi32_pd","","Convert packed 32-bit integers in `a` to packed double-precision (64-bit) floating-point elements.",N,[[["__m128i"]],["__m256d"]]],[5,"_mm256_cvtepi32_ps","","Convert packed 32-bit integers in `a` to packed single-precision (32-bit) floating-point elements.",N,[[["__m256i"]],["__m256"]]],[5,"_mm256_cvtpd_ps","","Convert packed double-precision (64-bit) floating-point elements in `a` to packed single-precision (32-bit) floating-point elements.",N,[[["__m256d"]],["__m128"]]],[5,"_mm256_cvtps_epi32","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers.",N,[[["__m256"]],["__m256i"]]],[5,"_mm256_cvtps_pd","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed double-precision (64-bit) floating-point elements.",N,[[["__m128"]],["__m256d"]]],[5,"_mm256_cvttpd_epi32","","Convert packed double-precision (64-bit) floating-point elements in `a` to packed 32-bit integers with truncation.",N,[[["__m256d"]],["__m128i"]]],[5,"_mm256_cvtpd_epi32","","Convert packed double-precision (64-bit) floating-point elements in `a` to packed 32-bit integers.",N,[[["__m256d"]],["__m128i"]]],[5,"_mm256_cvttps_epi32","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers with truncation.",N,[[["__m256"]],["__m256i"]]],[5,"_mm256_extractf128_ps","","Extract 128 bits (composed of 4 packed single-precision (32-bit) floating-point elements) from `a`, selected with `imm8`.",N,[[["__m256"],["i32"]],["__m128"]]],[5,"_mm256_extractf128_pd","","Extract 128 bits (composed of 2 packed double-precision (64-bit) floating-point elements) from `a`, selected with `imm8`.",N,[[["__m256d"],["i32"]],["__m128d"]]],[5,"_mm256_extractf128_si256","","Extract 128 bits (composed of integer data) from `a`, selected with `imm8`.",N,[[["__m256i"],["i32"]],["__m128i"]]],[5,"_mm256_zeroall","","Zero the contents of all XMM or YMM registers.",N,[[]]],[5,"_mm256_zeroupper","","Zero the upper 128 bits of all YMM registers; the lower 128-bits of the registers are unmodified.",N,[[]]],[5,"_mm256_permutevar_ps","","Shuffle single-precision (32-bit) floating-point elements in `a` within 128-bit lanes using the control in `b`.",N,[[["__m256"],["__m256i"]],["__m256"]]],[5,"_mm_permutevar_ps","","Shuffle single-precision (32-bit) floating-point elements in `a` using the control in `b`.",N,[[["__m128"],["__m128i"]],["__m128"]]],[5,"_mm256_permute_ps","","Shuffle single-precision (32-bit) floating-point elements in `a` within 128-bit lanes using the control in `imm8`.",N,[[["__m256"],["i32"]],["__m256"]]],[5,"_mm_permute_ps","","Shuffle single-precision (32-bit) floating-point elements in `a` using the control in `imm8`.",N,[[["__m128"],["i32"]],["__m128"]]],[5,"_mm256_permutevar_pd","","Shuffle double-precision (64-bit) floating-point elements in `a` within 256-bit lanes using the control in `b`.",N,[[["__m256d"],["__m256i"]],["__m256d"]]],[5,"_mm_permutevar_pd","","Shuffle double-precision (64-bit) floating-point elements in `a` using the control in `b`.",N,[[["__m128d"],["__m128i"]],["__m128d"]]],[5,"_mm256_permute_pd","","Shuffle double-precision (64-bit) floating-point elements in `a` within 128-bit lanes using the control in `imm8`.",N,[[["__m256d"],["i32"]],["__m256d"]]],[5,"_mm_permute_pd","","Shuffle double-precision (64-bit) floating-point elements in `a` using the control in `imm8`.",N,[[["__m128d"],["i32"]],["__m128d"]]],[5,"_mm256_permute2f128_ps","","Shuffle 256-bits (composed of 8 packed single-precision (32-bit) floating-point elements) selected by `imm8` from `a` and `b`.",N,[[["__m256"],["__m256"],["i32"]],["__m256"]]],[5,"_mm256_permute2f128_pd","","Shuffle 256-bits (composed of 4 packed double-precision (64-bit) floating-point elements) selected by `imm8` from `a` and `b`.",N,[[["__m256d"],["__m256d"],["i32"]],["__m256d"]]],[5,"_mm256_permute2f128_si256","","Shuffle 258-bits (composed of integer data) selected by `imm8` from `a` and `b`.",N,[[["__m256i"],["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_broadcast_ss","","Broadcast a single-precision (32-bit) floating-point element from memory to all elements of the returned vector.",N,[[["f32"]],["__m256"]]],[5,"_mm_broadcast_ss","","Broadcast a single-precision (32-bit) floating-point element from memory to all elements of the returned vector.",N,[[["f32"]],["__m128"]]],[5,"_mm256_broadcast_sd","","Broadcast a double-precision (64-bit) floating-point element from memory to all elements of the returned vector.",N,[[["f64"]],["__m256d"]]],[5,"_mm256_broadcast_ps","","Broadcast 128 bits from memory (composed of 4 packed single-precision (32-bit) floating-point elements) to all elements of the returned vector.",N,[[["__m128"]],["__m256"]]],[5,"_mm256_broadcast_pd","","Broadcast 128 bits from memory (composed of 2 packed double-precision (64-bit) floating-point elements) to all elements of the returned vector.",N,[[["__m128d"]],["__m256d"]]],[5,"_mm256_insertf128_ps","","Copy `a` to result, then insert 128 bits (composed of 4 packed single-precision (32-bit) floating-point elements) from `b` into result at the location specified by `imm8`.",N,[[["__m256"],["__m128"],["i32"]],["__m256"]]],[5,"_mm256_insertf128_pd","","Copy `a` to result, then insert 128 bits (composed of 2 packed double-precision (64-bit) floating-point elements) from `b` into result at the location specified by `imm8`.",N,[[["__m256d"],["__m128d"],["i32"]],["__m256d"]]],[5,"_mm256_insertf128_si256","","Copy `a` to result, then insert 128 bits from `b` into result at the location specified by `imm8`.",N,[[["__m256i"],["__m128i"],["i32"]],["__m256i"]]],[5,"_mm256_insert_epi8","","Copy `a` to result, and insert the 8-bit integer `i` into result at the location specified by `index`.",N,[[["__m256i"],["i8"],["i32"]],["__m256i"]]],[5,"_mm256_insert_epi16","","Copy `a` to result, and insert the 16-bit integer `i` into result at the location specified by `index`.",N,[[["__m256i"],["i16"],["i32"]],["__m256i"]]],[5,"_mm256_insert_epi32","","Copy `a` to result, and insert the 32-bit integer `i` into result at the location specified by `index`.",N,[[["__m256i"],["i32"],["i32"]],["__m256i"]]],[5,"_mm256_load_pd","","Load 256-bits (composed of 4 packed double-precision (64-bit) floating-point elements) from memory into result. `mem_addr` must be aligned on a 32-byte boundary or a general-protection exception may be generated.",N,N],[5,"_mm256_store_pd","","Store 256-bits (composed of 4 packed double-precision (64-bit) floating-point elements) from `a` into memory. `mem_addr` must be aligned on a 32-byte boundary or a general-protection exception may be generated.",N,N],[5,"_mm256_load_ps","","Load 256-bits (composed of 8 packed single-precision (32-bit) floating-point elements) from memory into result. `mem_addr` must be aligned on a 32-byte boundary or a general-protection exception may be generated.",N,N],[5,"_mm256_store_ps","","Store 256-bits (composed of 8 packed single-precision (32-bit) floating-point elements) from `a` into memory. `mem_addr` must be aligned on a 32-byte boundary or a general-protection exception may be generated.",N,N],[5,"_mm256_loadu_pd","","Load 256-bits (composed of 4 packed double-precision (64-bit) floating-point elements) from memory into result. `mem_addr` does not need to be aligned on any particular boundary.",N,N],[5,"_mm256_storeu_pd","","Store 256-bits (composed of 4 packed double-precision (64-bit) floating-point elements) from `a` into memory. `mem_addr` does not need to be aligned on any particular boundary.",N,N],[5,"_mm256_loadu_ps","","Load 256-bits (composed of 8 packed single-precision (32-bit) floating-point elements) from memory into result. `mem_addr` does not need to be aligned on any particular boundary.",N,N],[5,"_mm256_storeu_ps","","Store 256-bits (composed of 8 packed single-precision (32-bit) floating-point elements) from `a` into memory. `mem_addr` does not need to be aligned on any particular boundary.",N,N],[5,"_mm256_load_si256","","Load 256-bits of integer data from memory into result. `mem_addr` must be aligned on a 32-byte boundary or a general-protection exception may be generated.",N,N],[5,"_mm256_store_si256","","Store 256-bits of integer data from `a` into memory. `mem_addr` must be aligned on a 32-byte boundary or a general-protection exception may be generated.",N,N],[5,"_mm256_loadu_si256","","Load 256-bits of integer data from memory into result. `mem_addr` does not need to be aligned on any particular boundary.",N,N],[5,"_mm256_storeu_si256","","Store 256-bits of integer data from `a` into memory.    `mem_addr` does not need to be aligned on any particular boundary.",N,N],[5,"_mm256_maskload_pd","","Load packed double-precision (64-bit) floating-point elements from memory into result using `mask` (elements are zeroed out when the high bit of the corresponding element is not set).",N,N],[5,"_mm256_maskstore_pd","","Store packed double-precision (64-bit) floating-point elements from `a` into memory using `mask`.",N,N],[5,"_mm_maskload_pd","","Load packed double-precision (64-bit) floating-point elements from memory into result using `mask` (elements are zeroed out when the high bit of the corresponding element is not set).",N,N],[5,"_mm_maskstore_pd","","Store packed double-precision (64-bit) floating-point elements from `a` into memory using `mask`.",N,N],[5,"_mm256_maskload_ps","","Load packed single-precision (32-bit) floating-point elements from memory into result using `mask` (elements are zeroed out when the high bit of the corresponding element is not set).",N,N],[5,"_mm256_maskstore_ps","","Store packed single-precision (32-bit) floating-point elements from `a` into memory using `mask`.",N,N],[5,"_mm_maskload_ps","","Load packed single-precision (32-bit) floating-point elements from memory into result using `mask` (elements are zeroed out when the high bit of the corresponding element is not set).",N,N],[5,"_mm_maskstore_ps","","Store packed single-precision (32-bit) floating-point elements from `a` into memory using `mask`.",N,N],[5,"_mm256_movehdup_ps","","Duplicate odd-indexed single-precision (32-bit) floating-point elements from `a`, and return the results.",N,[[["__m256"]],["__m256"]]],[5,"_mm256_moveldup_ps","","Duplicate even-indexed single-precision (32-bit) floating-point elements from `a`, and return the results.",N,[[["__m256"]],["__m256"]]],[5,"_mm256_movedup_pd","","Duplicate even-indexed double-precision (64-bit) floating-point elements from \"a\", and return the results.",N,[[["__m256d"]],["__m256d"]]],[5,"_mm256_lddqu_si256","","Load 256-bits of integer data from unaligned memory into result. This intrinsic may perform better than `_mm256_loadu_si256` when the data crosses a cache line boundary.",N,N],[5,"_mm256_stream_si256","","Moves integer data from a 256-bit integer vector to a 32-byte aligned memory location. To minimize caching, the data is flagged as non-temporal (unlikely to be used again soon)",N,N],[5,"_mm256_stream_pd","","Moves double-precision values from a 256-bit vector of `[4 x double]` to a 32-byte aligned memory location. To minimize caching, the data is flagged as non-temporal (unlikely to be used again soon).",N,N],[5,"_mm256_stream_ps","","Moves single-precision floating point values from a 256-bit vector of `[8 x float]` to a 32-byte aligned memory location. To minimize caching, the data is flagged as non-temporal (unlikely to be used again soon).",N,N],[5,"_mm256_rcp_ps","","Compute the approximate reciprocal of packed single-precision (32-bit) floating-point elements in `a`, and return the results. The maximum relative error for this approximation is less than 1.5*2^-12.",N,[[["__m256"]],["__m256"]]],[5,"_mm256_rsqrt_ps","","Compute the approximate reciprocal square root of packed single-precision (32-bit) floating-point elements in `a`, and return the results. The maximum relative error for this approximation is less than 1.5*2^-12.",N,[[["__m256"]],["__m256"]]],[5,"_mm256_unpackhi_pd","","Unpack and interleave double-precision (64-bit) floating-point elements from the high half of each 128-bit lane in `a` and `b`.",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_unpackhi_ps","","Unpack and interleave single-precision (32-bit) floating-point elements from the high half of each 128-bit lane in `a` and `b`.",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_unpacklo_pd","","Unpack and interleave double-precision (64-bit) floating-point elements from the low half of each 128-bit lane in `a` and `b`.",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_unpacklo_ps","","Unpack and interleave single-precision (32-bit) floating-point elements from the low half of each 128-bit lane in `a` and `b`.",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_testz_si256","","Compute the bitwise AND of 256 bits (representing integer data) in `a` and `b`, and set `ZF` to 1 if the result is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, and set `CF` to 1 if the result is zero, otherwise set `CF` to 0. Return the `ZF` value.",N,[[["__m256i"],["__m256i"]],["i32"]]],[5,"_mm256_testc_si256","","Compute the bitwise AND of 256 bits (representing integer data) in `a` and `b`, and set `ZF` to 1 if the result is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, and set `CF` to 1 if the result is zero, otherwise set `CF` to 0. Return the `CF` value.",N,[[["__m256i"],["__m256i"]],["i32"]]],[5,"_mm256_testnzc_si256","","Compute the bitwise AND of 256 bits (representing integer data) in `a` and `b`, and set `ZF` to 1 if the result is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, and set `CF` to 1 if the result is zero, otherwise set `CF` to 0. Return 1 if both the `ZF` and `CF` values are zero, otherwise return 0.",N,[[["__m256i"],["__m256i"]],["i32"]]],[5,"_mm256_testz_pd","","Compute the bitwise AND of 256 bits (representing double-precision (64-bit) floating-point elements) in `a` and `b`, producing an intermediate 256-bit value, and set `ZF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `ZF` value.",N,[[["__m256d"],["__m256d"]],["i32"]]],[5,"_mm256_testc_pd","","Compute the bitwise AND of 256 bits (representing double-precision (64-bit) floating-point elements) in `a` and `b`, producing an intermediate 256-bit value, and set `ZF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `CF` value.",N,[[["__m256d"],["__m256d"]],["i32"]]],[5,"_mm256_testnzc_pd","","Compute the bitwise AND of 256 bits (representing double-precision (64-bit) floating-point elements) in `a` and `b`, producing an intermediate 256-bit value, and set `ZF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return 1 if both the `ZF` and `CF` values are zero, otherwise return 0.",N,[[["__m256d"],["__m256d"]],["i32"]]],[5,"_mm_testz_pd","","Compute the bitwise AND of 128 bits (representing double-precision (64-bit) floating-point elements) in `a` and `b`, producing an intermediate 128-bit value, and set `ZF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `ZF` value.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm_testc_pd","","Compute the bitwise AND of 128 bits (representing double-precision (64-bit) floating-point elements) in `a` and `b`, producing an intermediate 128-bit value, and set `ZF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `CF` value.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm_testnzc_pd","","Compute the bitwise AND of 128 bits (representing double-precision (64-bit) floating-point elements) in `a` and `b`, producing an intermediate 128-bit value, and set `ZF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return 1 if both the `ZF` and `CF` values are zero, otherwise return 0.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm256_testz_ps","","Compute the bitwise AND of 256 bits (representing single-precision (32-bit) floating-point elements) in `a` and `b`, producing an intermediate 256-bit value, and set `ZF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `ZF` value.",N,[[["__m256"],["__m256"]],["i32"]]],[5,"_mm256_testc_ps","","Compute the bitwise AND of 256 bits (representing single-precision (32-bit) floating-point elements) in `a` and `b`, producing an intermediate 256-bit value, and set `ZF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `CF` value.",N,[[["__m256"],["__m256"]],["i32"]]],[5,"_mm256_testnzc_ps","","Compute the bitwise AND of 256 bits (representing single-precision (32-bit) floating-point elements) in `a` and `b`, producing an intermediate 256-bit value, and set `ZF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return 1 if both the `ZF` and `CF` values are zero, otherwise return 0.",N,[[["__m256"],["__m256"]],["i32"]]],[5,"_mm_testz_ps","","Compute the bitwise AND of 128 bits (representing single-precision (32-bit) floating-point elements) in `a` and `b`, producing an intermediate 128-bit value, and set `ZF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `ZF` value.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm_testc_ps","","Compute the bitwise AND of 128 bits (representing single-precision (32-bit) floating-point elements) in `a` and `b`, producing an intermediate 128-bit value, and set `ZF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `CF` value.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm_testnzc_ps","","Compute the bitwise AND of 128 bits (representing single-precision (32-bit) floating-point elements) in `a` and `b`, producing an intermediate 128-bit value, and set `ZF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return 1 if both the `ZF` and `CF` values are zero, otherwise return 0.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm256_movemask_pd","","Set each bit of the returned mask based on the most significant bit of the corresponding packed double-precision (64-bit) floating-point element in `a`.",N,[[["__m256d"]],["i32"]]],[5,"_mm256_movemask_ps","","Set each bit of the returned mask based on the most significant bit of the corresponding packed single-precision (32-bit) floating-point element in `a`.",N,[[["__m256"]],["i32"]]],[5,"_mm256_setzero_pd","","Return vector of type __m256d with all elements set to zero.",N,[[],["__m256d"]]],[5,"_mm256_setzero_ps","","Return vector of type __m256 with all elements set to zero.",N,[[],["__m256"]]],[5,"_mm256_setzero_si256","","Return vector of type __m256i with all elements set to zero.",N,[[],["__m256i"]]],[5,"_mm256_set_pd","","Set packed double-precision (64-bit) floating-point elements in returned vector with the supplied values.",N,[[["f64"],["f64"],["f64"],["f64"]],["__m256d"]]],[5,"_mm256_set_ps","","Set packed single-precision (32-bit) floating-point elements in returned vector with the supplied values.",N,[[["f32"],["f32"],["f32"],["f32"],["f32"],["f32"],["f32"],["f32"]],["__m256"]]],[5,"_mm256_set_epi8","","Set packed 8-bit integers in returned vector with the supplied values in reverse order.",N,[[["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"]],["__m256i"]]],[5,"_mm256_set_epi16","","Set packed 16-bit integers in returned vector with the supplied values.",N,[[["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"]],["__m256i"]]],[5,"_mm256_set_epi32","","Set packed 32-bit integers in returned vector with the supplied values.",N,[[["i32"],["i32"],["i32"],["i32"],["i32"],["i32"],["i32"],["i32"]],["__m256i"]]],[5,"_mm256_set_epi64x","","Set packed 64-bit integers in returned vector with the supplied values.",N,[[["i64"],["i64"],["i64"],["i64"]],["__m256i"]]],[5,"_mm256_setr_pd","","Set packed double-precision (64-bit) floating-point elements in returned vector with the supplied values in reverse order.",N,[[["f64"],["f64"],["f64"],["f64"]],["__m256d"]]],[5,"_mm256_setr_ps","","Set packed single-precision (32-bit) floating-point elements in returned vector with the supplied values in reverse order.",N,[[["f32"],["f32"],["f32"],["f32"],["f32"],["f32"],["f32"],["f32"]],["__m256"]]],[5,"_mm256_setr_epi8","","Set packed 8-bit integers in returned vector with the supplied values in reverse order.",N,[[["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"]],["__m256i"]]],[5,"_mm256_setr_epi16","","Set packed 16-bit integers in returned vector with the supplied values in reverse order.",N,[[["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"]],["__m256i"]]],[5,"_mm256_setr_epi32","","Set packed 32-bit integers in returned vector with the supplied values in reverse order.",N,[[["i32"],["i32"],["i32"],["i32"],["i32"],["i32"],["i32"],["i32"]],["__m256i"]]],[5,"_mm256_setr_epi64x","","Set packed 64-bit integers in returned vector with the supplied values in reverse order.",N,[[["i64"],["i64"],["i64"],["i64"]],["__m256i"]]],[5,"_mm256_set1_pd","","Broadcast double-precision (64-bit) floating-point value `a` to all elements of returned vector.",N,[[["f64"]],["__m256d"]]],[5,"_mm256_set1_ps","","Broadcast single-precision (32-bit) floating-point value `a` to all elements of returned vector.",N,[[["f32"]],["__m256"]]],[5,"_mm256_set1_epi8","","Broadcast 8-bit integer `a` to all elements of returned vector. This intrinsic may generate the `vpbroadcastb`.",N,[[["i8"]],["__m256i"]]],[5,"_mm256_set1_epi16","","Broadcast 16-bit integer `a` to all all elements of returned vector. This intrinsic may generate the `vpbroadcastw`.",N,[[["i16"]],["__m256i"]]],[5,"_mm256_set1_epi32","","Broadcast 32-bit integer `a` to all elements of returned vector. This intrinsic may generate the `vpbroadcastd`.",N,[[["i32"]],["__m256i"]]],[5,"_mm256_set1_epi64x","","Broadcast 64-bit integer `a` to all elements of returned vector. This intrinsic may generate the `vpbroadcastq`.",N,[[["i64"]],["__m256i"]]],[5,"_mm256_castpd_ps","","Cast vector of type __m256d to type __m256.",N,[[["__m256d"]],["__m256"]]],[5,"_mm256_castps_pd","","Cast vector of type __m256 to type __m256d.",N,[[["__m256"]],["__m256d"]]],[5,"_mm256_castps_si256","","Casts vector of type __m256 to type __m256i.",N,[[["__m256"]],["__m256i"]]],[5,"_mm256_castsi256_ps","","Casts vector of type __m256i to type __m256.",N,[[["__m256i"]],["__m256"]]],[5,"_mm256_castpd_si256","","Casts vector of type __m256d to type __m256i.",N,[[["__m256d"]],["__m256i"]]],[5,"_mm256_castsi256_pd","","Casts vector of type __m256i to type __m256d.",N,[[["__m256i"]],["__m256d"]]],[5,"_mm256_castps256_ps128","","Casts vector of type __m256 to type __m128.",N,[[["__m256"]],["__m128"]]],[5,"_mm256_castpd256_pd128","","Casts vector of type __m256d to type __m128d.",N,[[["__m256d"]],["__m128d"]]],[5,"_mm256_castsi256_si128","","Casts vector of type __m256i to type __m128i.",N,[[["__m256i"]],["__m128i"]]],[5,"_mm256_castps128_ps256","","Casts vector of type __m128 to type __m256; the upper 128 bits of the result are undefined.",N,[[["__m128"]],["__m256"]]],[5,"_mm256_castpd128_pd256","","Casts vector of type __m128d to type __m256d; the upper 128 bits of the result are undefined.",N,[[["__m128d"]],["__m256d"]]],[5,"_mm256_castsi128_si256","","Casts vector of type __m128i to type __m256i; the upper 128 bits of the result are undefined.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_zextps128_ps256","","Constructs a 256-bit floating-point vector of `[8 x float]` from a 128-bit floating-point vector of `[4 x float]`. The lower 128 bits contain the value of the source vector. The upper 128 bits are set to zero.",N,[[["__m128"]],["__m256"]]],[5,"_mm256_zextsi128_si256","","Constructs a 256-bit integer vector from a 128-bit integer vector. The lower 128 bits contain the value of the source vector. The upper 128 bits are set to zero.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_zextpd128_pd256","","Constructs a 256-bit floating-point vector of `[4 x double]` from a 128-bit floating-point vector of `[2 x double]`. The lower 128 bits contain the value of the source vector. The upper 128 bits are set to zero.",N,[[["__m128d"]],["__m256d"]]],[5,"_mm256_undefined_ps","","Return vector of type `__m256` with undefined elements.",N,[[],["__m256"]]],[5,"_mm256_undefined_pd","","Return vector of type `__m256d` with undefined elements.",N,[[],["__m256d"]]],[5,"_mm256_undefined_si256","","Return vector of type __m256i with undefined elements.",N,[[],["__m256i"]]],[5,"_mm256_set_m128","","Set packed __m256 returned vector with the supplied values.",N,[[["__m128"],["__m128"]],["__m256"]]],[5,"_mm256_set_m128d","","Set packed __m256d returned vector with the supplied values.",N,[[["__m128d"],["__m128d"]],["__m256d"]]],[5,"_mm256_set_m128i","","Set packed __m256i returned vector with the supplied values.",N,[[["__m128i"],["__m128i"]],["__m256i"]]],[5,"_mm256_setr_m128","","Set packed __m256 returned vector with the supplied values.",N,[[["__m128"],["__m128"]],["__m256"]]],[5,"_mm256_setr_m128d","","Set packed __m256d returned vector with the supplied values.",N,[[["__m128d"],["__m128d"]],["__m256d"]]],[5,"_mm256_setr_m128i","","Set packed __m256i returned vector with the supplied values.",N,[[["__m128i"],["__m128i"]],["__m256i"]]],[5,"_mm256_loadu2_m128","","Load two 128-bit values (composed of 4 packed single-precision (32-bit) floating-point elements) from memory, and combine them into a 256-bit value. `hiaddr` and `loaddr` do not need to be aligned on any particular boundary.",N,N],[5,"_mm256_loadu2_m128d","","Load two 128-bit values (composed of 2 packed double-precision (64-bit) floating-point elements) from memory, and combine them into a 256-bit value. `hiaddr` and `loaddr` do not need to be aligned on any particular boundary.",N,N],[5,"_mm256_loadu2_m128i","","Load two 128-bit values (composed of integer data) from memory, and combine them into a 256-bit value. `hiaddr` and `loaddr` do not need to be aligned on any particular boundary.",N,N],[5,"_mm256_storeu2_m128","","Store the high and low 128-bit halves (each composed of 4 packed single-precision (32-bit) floating-point elements) from `a` into memory two different 128-bit locations. `hiaddr` and `loaddr` do not need to be aligned on any particular boundary.",N,N],[5,"_mm256_storeu2_m128d","","Store the high and low 128-bit halves (each composed of 2 packed double-precision (64-bit) floating-point elements) from `a` into memory two different 128-bit locations. `hiaddr` and `loaddr` do not need to be aligned on any particular boundary.",N,N],[5,"_mm256_storeu2_m128i","","Store the high and low 128-bit halves (each composed of integer data) from `a` into memory two different 128-bit locations. `hiaddr` and `loaddr` do not need to be aligned on any particular boundary.",N,N],[5,"_mm256_cvtss_f32","","Returns the first element of the input vector of `[8 x float]`.",N,[[["__m256"]],["f32"]]],[5,"_mm256_abs_epi32","","Computes the absolute values of packed 32-bit integers in `a`.",N,[[["__m256i"]],["__m256i"]]],[5,"_mm256_abs_epi16","","Computes the absolute values of packed 16-bit integers in `a`.",N,[[["__m256i"]],["__m256i"]]],[5,"_mm256_abs_epi8","","Computes the absolute values of packed 8-bit integers in `a`.",N,[[["__m256i"]],["__m256i"]]],[5,"_mm256_add_epi64","","Add packed 64-bit integers in `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_add_epi32","","Add packed 32-bit integers in `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_add_epi16","","Add packed 16-bit integers in `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_add_epi8","","Add packed 8-bit integers in `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_adds_epi8","","Add packed 8-bit integers in `a` and `b` using saturation.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_adds_epi16","","Add packed 16-bit integers in `a` and `b` using saturation.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_adds_epu8","","Add packed unsigned 8-bit integers in `a` and `b` using saturation.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_adds_epu16","","Add packed unsigned 16-bit integers in `a` and `b` using saturation.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_alignr_epi8","","Concatenate pairs of 16-byte blocks in `a` and `b` into a 32-byte temporary result, shift the result right by `n` bytes, and return the low 16 bytes.",N,[[["__m256i"],["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_and_si256","","Compute the bitwise AND of 256 bits (representing integer data) in `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_andnot_si256","","Compute the bitwise NOT of 256 bits (representing integer data) in `a` and then AND with `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_avg_epu16","","Average packed unsigned 16-bit integers in `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_avg_epu8","","Average packed unsigned 8-bit integers in `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm_blend_epi32","","Blend packed 32-bit integers from `a` and `b` using control mask `imm8`.",N,[[["__m128i"],["__m128i"],["i32"]],["__m128i"]]],[5,"_mm256_blend_epi32","","Blend packed 32-bit integers from `a` and `b` using control mask `imm8`.",N,[[["__m256i"],["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_blend_epi16","","Blend packed 16-bit integers from `a` and `b` using control mask `imm8`.",N,[[["__m256i"],["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_blendv_epi8","","Blend packed 8-bit integers from `a` and `b` using `mask`.",N,[[["__m256i"],["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm_broadcastb_epi8","","Broadcast the low packed 8-bit integer from `a` to all elements of the 128-bit returned value.",N,[[["__m128i"]],["__m128i"]]],[5,"_mm256_broadcastb_epi8","","Broadcast the low packed 8-bit integer from `a` to all elements of the 256-bit returned value.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm_broadcastd_epi32","","Broadcast the low packed 32-bit integer from `a` to all elements of the 128-bit returned value.",N,[[["__m128i"]],["__m128i"]]],[5,"_mm256_broadcastd_epi32","","Broadcast the low packed 32-bit integer from `a` to all elements of the 256-bit returned value.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm_broadcastq_epi64","","Broadcast the low packed 64-bit integer from `a` to all elements of the 128-bit returned value.",N,[[["__m128i"]],["__m128i"]]],[5,"_mm256_broadcastq_epi64","","Broadcast the low packed 64-bit integer from `a` to all elements of the 256-bit returned value.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm_broadcastsd_pd","","Broadcast the low double-precision (64-bit) floating-point element from `a` to all elements of the 128-bit returned value.",N,[[["__m128d"]],["__m128d"]]],[5,"_mm256_broadcastsd_pd","","Broadcast the low double-precision (64-bit) floating-point element from `a` to all elements of the 256-bit returned value.",N,[[["__m128d"]],["__m256d"]]],[5,"_mm256_broadcastsi128_si256","","Broadcast 128 bits of integer data from a to all 128-bit lanes in the 256-bit returned value.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm_broadcastss_ps","","Broadcast the low single-precision (32-bit) floating-point element from `a` to all elements of the 128-bit returned value.",N,[[["__m128"]],["__m128"]]],[5,"_mm256_broadcastss_ps","","Broadcast the low single-precision (32-bit) floating-point element from `a` to all elements of the 256-bit returned value.",N,[[["__m128"]],["__m256"]]],[5,"_mm_broadcastw_epi16","","Broadcast the low packed 16-bit integer from a to all elements of the 128-bit returned value",N,[[["__m128i"]],["__m128i"]]],[5,"_mm256_broadcastw_epi16","","Broadcast the low packed 16-bit integer from a to all elements of the 256-bit returned value",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cmpeq_epi64","","Compare packed 64-bit integers in `a` and `b` for equality.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_cmpeq_epi32","","Compare packed 32-bit integers in `a` and `b` for equality.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_cmpeq_epi16","","Compare packed 16-bit integers in `a` and `b` for equality.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_cmpeq_epi8","","Compare packed 8-bit integers in `a` and `b` for equality.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_cmpgt_epi64","","Compare packed 64-bit integers in `a` and `b` for greater-than.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_cmpgt_epi32","","Compare packed 32-bit integers in `a` and `b` for greater-than.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_cmpgt_epi16","","Compare packed 16-bit integers in `a` and `b` for greater-than.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_cmpgt_epi8","","Compare packed 8-bit integers in `a` and `b` for greater-than.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_cvtepi16_epi32","","Sign-extend 16-bit integers to 32-bit integers.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepi16_epi64","","Sign-extend 16-bit integers to 64-bit integers.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepi32_epi64","","Sign-extend 32-bit integers to 64-bit integers.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepi8_epi16","","Sign-extend 8-bit integers to 16-bit integers.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepi8_epi32","","Sign-extend 8-bit integers to 32-bit integers.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepi8_epi64","","Sign-extend 8-bit integers to 64-bit integers.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepu16_epi32","","Zero extend packed unsigned 16-bit integers in `a` to packed 32-bit integers, and store the results in dst.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepu16_epi64","","Zero-extend the lower four unsigned 16-bit integers in `a` to 64-bit integers. The upper four elements of `a` are unused.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepu32_epi64","","Zero-extend unsigned 32-bit integers in `a` to 64-bit integers.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepu8_epi16","","Zero-extend unsigned 8-bit integers in `a` to 16-bit integers.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepu8_epi32","","Zero-extend the lower eight unsigned 8-bit integers in `a` to 32-bit integers. The upper eight elements of `a` are unused.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepu8_epi64","","Zero-extend the lower four unsigned 8-bit integers in `a` to 64-bit integers. The upper twelve elements of `a` are unused.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_extracti128_si256","","Extract 128 bits (of integer data) from `a` selected with `imm8`.",N,[[["__m256i"],["i32"]],["__m128i"]]],[5,"_mm256_hadd_epi16","","Horizontally add adjacent pairs of 16-bit integers in `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_hadd_epi32","","Horizontally add adjacent pairs of 32-bit integers in `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_hadds_epi16","","Horizontally add adjacent pairs of 16-bit integers in `a` and `b` using saturation.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_hsub_epi16","","Horizontally subtract adjacent pairs of 16-bit integers in `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_hsub_epi32","","Horizontally subtract adjacent pairs of 32-bit integers in `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_hsubs_epi16","","Horizontally subtract adjacent pairs of 16-bit integers in `a` and `b` using saturation.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm_i32gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm_mask_i32gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm256_i32gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm256_mask_i32gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm_i32gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm_mask_i32gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm256_i32gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm256_mask_i32gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm_i32gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm_mask_i32gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm256_i32gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm256_mask_i32gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm_i32gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm_mask_i32gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm256_i32gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm256_mask_i32gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm_i64gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm_mask_i64gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm256_i64gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm256_mask_i64gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm_i64gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm_mask_i64gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm256_i64gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm256_mask_i64gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm_i64gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm_mask_i64gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm256_i64gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm256_mask_i64gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm_i64gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm_mask_i64gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm256_i64gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm256_mask_i64gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm256_inserti128_si256","","Copy `a` to `dst`, then insert 128 bits (of integer data) from `b` at the location specified by `imm8`.",N,[[["__m256i"],["__m128i"],["i32"]],["__m256i"]]],[5,"_mm256_madd_epi16","","Multiply packed signed 16-bit integers in `a` and `b`, producing intermediate signed 32-bit integers. Horizontally add adjacent pairs of intermediate 32-bit integers.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_maddubs_epi16","","Vertically multiply each unsigned 8-bit integer from `a` with the corresponding signed 8-bit integer from `b`, producing intermediate signed 16-bit integers. Horizontally add adjacent pairs of intermediate signed 16-bit integers",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm_maskload_epi32","","Load packed 32-bit integers from memory pointed by `mem_addr` using `mask` (elements are zeroed out when the highest bit is not set in the corresponding element).",N,N],[5,"_mm256_maskload_epi32","","Load packed 32-bit integers from memory pointed by `mem_addr` using `mask` (elements are zeroed out when the highest bit is not set in the corresponding element).",N,N],[5,"_mm_maskload_epi64","","Load packed 64-bit integers from memory pointed by `mem_addr` using `mask` (elements are zeroed out when the highest bit is not set in the corresponding element).",N,N],[5,"_mm256_maskload_epi64","","Load packed 64-bit integers from memory pointed by `mem_addr` using `mask` (elements are zeroed out when the highest bit is not set in the corresponding element).",N,N],[5,"_mm_maskstore_epi32","","Store packed 32-bit integers from `a` into memory pointed by `mem_addr` using `mask` (elements are not stored when the highest bit is not set in the corresponding element).",N,N],[5,"_mm256_maskstore_epi32","","Store packed 32-bit integers from `a` into memory pointed by `mem_addr` using `mask` (elements are not stored when the highest bit is not set in the corresponding element).",N,N],[5,"_mm_maskstore_epi64","","Store packed 64-bit integers from `a` into memory pointed by `mem_addr` using `mask` (elements are not stored when the highest bit is not set in the corresponding element).",N,N],[5,"_mm256_maskstore_epi64","","Store packed 64-bit integers from `a` into memory pointed by `mem_addr` using `mask` (elements are not stored when the highest bit is not set in the corresponding element).",N,N],[5,"_mm256_max_epi16","","Compare packed 16-bit integers in `a` and `b`, and return the packed maximum values.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_max_epi32","","Compare packed 32-bit integers in `a` and `b`, and return the packed maximum values.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_max_epi8","","Compare packed 8-bit integers in `a` and `b`, and return the packed maximum values.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_max_epu16","","Compare packed unsigned 16-bit integers in `a` and `b`, and return the packed maximum values.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_max_epu32","","Compare packed unsigned 32-bit integers in `a` and `b`, and return the packed maximum values.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_max_epu8","","Compare packed unsigned 8-bit integers in `a` and `b`, and return the packed maximum values.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_min_epi16","","Compare packed 16-bit integers in `a` and `b`, and return the packed minimum values.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_min_epi32","","Compare packed 32-bit integers in `a` and `b`, and return the packed minimum values.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_min_epi8","","Compare packed 8-bit integers in `a` and `b`, and return the packed minimum values.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_min_epu16","","Compare packed unsigned 16-bit integers in `a` and `b`, and return the packed minimum values.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_min_epu32","","Compare packed unsigned 32-bit integers in `a` and `b`, and return the packed minimum values.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_min_epu8","","Compare packed unsigned 8-bit integers in `a` and `b`, and return the packed minimum values.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_movemask_epi8","","Create mask from the most significant bit of each 8-bit element in `a`, return the result.",N,[[["__m256i"]],["i32"]]],[5,"_mm256_mpsadbw_epu8","","Compute the sum of absolute differences (SADs) of quadruplets of unsigned 8-bit integers in `a` compared to those in `b`, and store the 16-bit results in dst. Eight SADs are performed for each 128-bit lane using one quadruplet from `b` and eight quadruplets from `a`. One quadruplet is selected from `b` starting at on the offset specified in `imm8`. Eight quadruplets are formed from sequential 8-bit integers selected from `a` starting at the offset specified in `imm8`.",N,[[["__m256i"],["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_mul_epi32","","Multiply the low 32-bit integers from each packed 64-bit element in `a` and `b`",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_mul_epu32","","Multiply the low unsigned 32-bit integers from each packed 64-bit element in `a` and `b`",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_mulhi_epi16","","Multiply the packed 16-bit integers in `a` and `b`, producing intermediate 32-bit integers and returning the high 16 bits of the intermediate integers.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_mulhi_epu16","","Multiply the packed unsigned 16-bit integers in `a` and `b`, producing intermediate 32-bit integers and returning the high 16 bits of the intermediate integers.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_mullo_epi16","","Multiply the packed 16-bit integers in `a` and `b`, producing intermediate 32-bit integers, and return the low 16 bits of the intermediate integers",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_mullo_epi32","","Multiply the packed 32-bit integers in `a` and `b`, producing intermediate 64-bit integers, and return the low 16 bits of the intermediate integers",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_mulhrs_epi16","","Multiply packed 16-bit integers in `a` and `b`, producing intermediate signed 32-bit integers. Truncate each intermediate integer to the 18 most significant bits, round by adding 1, and return bits `[16:1]`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_or_si256","","Compute the bitwise OR of 256 bits (representing integer data) in `a` and `b`",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_packs_epi16","","Convert packed 16-bit integers from `a` and `b` to packed 8-bit integers using signed saturation",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_packs_epi32","","Convert packed 32-bit integers from `a` and `b` to packed 16-bit integers using signed saturation",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_packus_epi16","","Convert packed 16-bit integers from `a` and `b` to packed 8-bit integers using unsigned saturation",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_packus_epi32","","Convert packed 32-bit integers from `a` and `b` to packed 16-bit integers using unsigned saturation",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_permutevar8x32_epi32","","Permutes packed 32-bit integers from `a` according to the content of `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_permute4x64_epi64","","Permutes 64-bit integers from `a` using control mask `imm8`.",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_permute2x128_si256","","Shuffle 128-bits of integer data selected by `imm8` from `a` and `b`.",N,[[["__m256i"],["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_permute4x64_pd","","Shuffle 64-bit floating-point elements in `a` across lanes using the control in `imm8`.",N,[[["__m256d"],["i32"]],["__m256d"]]],[5,"_mm256_permutevar8x32_ps","","Shuffle eight 32-bit foating-point elements in `a` across lanes using the corresponding 32-bit integer index in `idx`.",N,[[["__m256"],["__m256i"]],["__m256"]]],[5,"_mm256_sad_epu8","","Compute the absolute differences of packed unsigned 8-bit integers in `a` and `b`, then horizontally sum each consecutive 8 differences to produce four unsigned 16-bit integers, and pack these unsigned 16-bit integers in the low 16 bits of the 64-bit return value",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_shuffle_epi8","","Shuffle bytes from `a` according to the content of `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_shuffle_epi32","","Shuffle 32-bit integers in 128-bit lanes of `a` using the control in `imm8`.",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_shufflehi_epi16","","Shuffle 16-bit integers in the high 64 bits of 128-bit lanes of `a` using the control in `imm8`. The low 64 bits of 128-bit lanes of `a` are copied to the output.",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_shufflelo_epi16","","Shuffle 16-bit integers in the low 64 bits of 128-bit lanes of `a` using the control in `imm8`. The high 64 bits of 128-bit lanes of `a` are copied to the output.",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_sign_epi16","","Negate packed 16-bit integers in `a` when the corresponding signed 16-bit integer in `b` is negative, and return the results. Results are zeroed out when the corresponding element in `b` is zero.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_sign_epi32","","Negate packed 32-bit integers in `a` when the corresponding signed 32-bit integer in `b` is negative, and return the results. Results are zeroed out when the corresponding element in `b` is zero.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_sign_epi8","","Negate packed 8-bit integers in `a` when the corresponding signed 8-bit integer in `b` is negative, and return the results. Results are zeroed out when the corresponding element in `b` is zero.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_sll_epi16","","Shift packed 16-bit integers in `a` left by `count` while shifting in zeros, and return the result",N,[[["__m256i"],["__m128i"]],["__m256i"]]],[5,"_mm256_sll_epi32","","Shift packed 32-bit integers in `a` left by `count` while shifting in zeros, and return the result",N,[[["__m256i"],["__m128i"]],["__m256i"]]],[5,"_mm256_sll_epi64","","Shift packed 64-bit integers in `a` left by `count` while shifting in zeros, and return the result",N,[[["__m256i"],["__m128i"]],["__m256i"]]],[5,"_mm256_slli_epi16","","Shift packed 16-bit integers in `a` left by `imm8` while shifting in zeros, return the results;",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_slli_epi32","","Shift packed 32-bit integers in `a` left by `imm8` while shifting in zeros, return the results;",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_slli_epi64","","Shift packed 64-bit integers in `a` left by `imm8` while shifting in zeros, return the results;",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_slli_si256","","Shift 128-bit lanes in `a` left by `imm8` bytes while shifting in zeros.",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_bslli_epi128","","Shift 128-bit lanes in `a` left by `imm8` bytes while shifting in zeros.",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm_sllv_epi32","","Shift packed 32-bit integers in `a` left by the amount specified by the corresponding element in `count` while shifting in zeros, and return the result.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm256_sllv_epi32","","Shift packed 32-bit integers in `a` left by the amount specified by the corresponding element in `count` while shifting in zeros, and return the result.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm_sllv_epi64","","Shift packed 64-bit integers in `a` left by the amount specified by the corresponding element in `count` while shifting in zeros, and return the result.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm256_sllv_epi64","","Shift packed 64-bit integers in `a` left by the amount specified by the corresponding element in `count` while shifting in zeros, and return the result.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_sra_epi16","","Shift packed 16-bit integers in `a` right by `count` while shifting in sign bits.",N,[[["__m256i"],["__m128i"]],["__m256i"]]],[5,"_mm256_sra_epi32","","Shift packed 32-bit integers in `a` right by `count` while shifting in sign bits.",N,[[["__m256i"],["__m128i"]],["__m256i"]]],[5,"_mm256_srai_epi16","","Shift packed 16-bit integers in `a` right by `imm8` while shifting in sign bits.",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_srai_epi32","","Shift packed 32-bit integers in `a` right by `imm8` while shifting in sign bits.",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm_srav_epi32","","Shift packed 32-bit integers in `a` right by the amount specified by the corresponding element in `count` while shifting in sign bits.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm256_srav_epi32","","Shift packed 32-bit integers in `a` right by the amount specified by the corresponding element in `count` while shifting in sign bits.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_srli_si256","","Shift 128-bit lanes in `a` right by `imm8` bytes while shifting in zeros.",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_bsrli_epi128","","Shift 128-bit lanes in `a` right by `imm8` bytes while shifting in zeros.",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_srl_epi16","","Shift packed 16-bit integers in `a` right by `count` while shifting in zeros.",N,[[["__m256i"],["__m128i"]],["__m256i"]]],[5,"_mm256_srl_epi32","","Shift packed 32-bit integers in `a` right by `count` while shifting in zeros.",N,[[["__m256i"],["__m128i"]],["__m256i"]]],[5,"_mm256_srl_epi64","","Shift packed 64-bit integers in `a` right by `count` while shifting in zeros.",N,[[["__m256i"],["__m128i"]],["__m256i"]]],[5,"_mm256_srli_epi16","","Shift packed 16-bit integers in `a` right by `imm8` while shifting in zeros",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_srli_epi32","","Shift packed 32-bit integers in `a` right by `imm8` while shifting in zeros",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_srli_epi64","","Shift packed 64-bit integers in `a` right by `imm8` while shifting in zeros",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm_srlv_epi32","","Shift packed 32-bit integers in `a` right by the amount specified by the corresponding element in `count` while shifting in zeros,",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm256_srlv_epi32","","Shift packed 32-bit integers in `a` right by the amount specified by the corresponding element in `count` while shifting in zeros,",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm_srlv_epi64","","Shift packed 64-bit integers in `a` right by the amount specified by the corresponding element in `count` while shifting in zeros,",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm256_srlv_epi64","","Shift packed 64-bit integers in `a` right by the amount specified by the corresponding element in `count` while shifting in zeros,",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_sub_epi16","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a`",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_sub_epi32","","Subtract packed 32-bit integers in `b` from packed 16-bit integers in `a`",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_sub_epi64","","Subtract packed 64-bit integers in `b` from packed 16-bit integers in `a`",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_sub_epi8","","Subtract packed 8-bit integers in `b` from packed 16-bit integers in `a`",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_subs_epi16","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a` using saturation.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_subs_epi8","","Subtract packed 8-bit integers in `b` from packed 8-bit integers in `a` using saturation.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_subs_epu16","","Subtract packed unsigned 16-bit integers in `b` from packed 16-bit integers in `a` using saturation.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_subs_epu8","","Subtract packed unsigned 8-bit integers in `b` from packed 8-bit integers in `a` using saturation.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_unpackhi_epi8","","Unpack and interleave 8-bit integers from the high half of each 128-bit lane in `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_unpacklo_epi8","","Unpack and interleave 8-bit integers from the low half of each 128-bit lane of `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_unpackhi_epi16","","Unpack and interleave 16-bit integers from the high half of each 128-bit lane of `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_unpacklo_epi16","","Unpack and interleave 16-bit integers from the low half of each 128-bit lane of `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_unpackhi_epi32","","Unpack and interleave 32-bit integers from the high half of each 128-bit lane of `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_unpacklo_epi32","","Unpack and interleave 32-bit integers from the low half of each 128-bit lane of `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_unpackhi_epi64","","Unpack and interleave 64-bit integers from the high half of each 128-bit lane of `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_unpacklo_epi64","","Unpack and interleave 64-bit integers from the low half of each 128-bit lane of `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_xor_si256","","Compute the bitwise XOR of 256 bits (representing integer data) in `a` and `b`",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_extract_epi8","","Extract an 8-bit integer from `a`, selected with `imm8`. Returns a 32-bit integer containing the zero-extended integer data.",N,[[["__m256i"],["i32"]],["i8"]]],[5,"_mm256_extract_epi16","","Extract a 16-bit integer from `a`, selected with `imm8`. Returns a 32-bit integer containing the zero-extended integer data.",N,[[["__m256i"],["i32"]],["i16"]]],[5,"_mm256_extract_epi32","","Extract a 32-bit integer from `a`, selected with `imm8`.",N,[[["__m256i"],["i32"]],["i32"]]],[5,"_mm256_cvtsd_f64","","Returns the first element of the input vector of `[4 x double]`.",N,[[["__m256d"]],["f64"]]],[5,"_mm256_cvtsi256_si32","","Returns the first element of the input vector of `[8 x i32]`.",N,[[["__m256i"]],["i32"]]],[5,"_mm_fmadd_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and add the intermediate result to packed elements in `c`.",N,[[["__m128d"],["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm256_fmadd_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and add the intermediate result to packed elements in `c`.",N,[[["__m256d"],["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm_fmadd_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and add the intermediate result to packed elements in `c`.",N,[[["__m128"],["__m128"],["__m128"]],["__m128"]]],[5,"_mm256_fmadd_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and add the intermediate result to packed elements in `c`.",N,[[["__m256"],["__m256"],["__m256"]],["__m256"]]],[5,"_mm_fmadd_sd","","Multiply the lower double-precision (64-bit) floating-point elements in `a` and `b`, and add the intermediate result to the lower element in `c`. Store the result in the lower element of the returned value, and copy the upper element from `a` to the upper elements of the result.",N,[[["__m128d"],["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_fmadd_ss","","Multiply the lower single-precision (32-bit) floating-point elements in `a` and `b`, and add the intermediate result to the lower element in `c`. Store the result in the lower element of the returned value, and copy the 3 upper elements from `a` to the upper elements of the result.",N,[[["__m128"],["__m128"],["__m128"]],["__m128"]]],[5,"_mm_fmaddsub_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and alternatively add and subtract packed elements in `c` to/from the intermediate result.",N,[[["__m128d"],["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm256_fmaddsub_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and alternatively add and subtract packed elements in `c` to/from the intermediate result.",N,[[["__m256d"],["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm_fmaddsub_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and alternatively add and subtract packed elements in `c` to/from the intermediate result.",N,[[["__m128"],["__m128"],["__m128"]],["__m128"]]],[5,"_mm256_fmaddsub_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and alternatively add and subtract packed elements in `c` to/from the intermediate result.",N,[[["__m256"],["__m256"],["__m256"]],["__m256"]]],[5,"_mm_fmsub_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the intermediate result.",N,[[["__m128d"],["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm256_fmsub_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the intermediate result.",N,[[["__m256d"],["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm_fmsub_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the intermediate result.",N,[[["__m128"],["__m128"],["__m128"]],["__m128"]]],[5,"_mm256_fmsub_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the intermediate result.",N,[[["__m256"],["__m256"],["__m256"]],["__m256"]]],[5,"_mm_fmsub_sd","","Multiply the lower double-precision (64-bit) floating-point elements in `a` and `b`, and subtract the lower element in `c` from the intermediate result. Store the result in the lower element of the returned value, and copy the upper element from `a` to the upper elements of the result.",N,[[["__m128d"],["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_fmsub_ss","","Multiply the lower single-precision (32-bit) floating-point elements in `a` and `b`,  and subtract the lower element in `c` from the intermediate result. Store the result in the lower element of the returned value, and copy the 3 upper elements from `a` to the upper elements of the result.",N,[[["__m128"],["__m128"],["__m128"]],["__m128"]]],[5,"_mm_fmsubadd_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and alternatively subtract and add packed elements in `c` from/to the intermediate result.",N,[[["__m128d"],["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm256_fmsubadd_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and alternatively subtract and add packed elements in `c` from/to the intermediate result.",N,[[["__m256d"],["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm_fmsubadd_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and alternatively subtract and add packed elements in `c` from/to the intermediate result.",N,[[["__m128"],["__m128"],["__m128"]],["__m128"]]],[5,"_mm256_fmsubadd_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and alternatively subtract and add packed elements in `c` from/to the intermediate result.",N,[[["__m256"],["__m256"],["__m256"]],["__m256"]]],[5,"_mm_fnmadd_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and add the negated intermediate result to packed elements in `c`.",N,[[["__m128d"],["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm256_fnmadd_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and add the negated intermediate result to packed elements in `c`.",N,[[["__m256d"],["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm_fnmadd_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and add the negated intermediate result to packed elements in `c`.",N,[[["__m128"],["__m128"],["__m128"]],["__m128"]]],[5,"_mm256_fnmadd_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and add the negated intermediate result to packed elements in `c`.",N,[[["__m256"],["__m256"],["__m256"]],["__m256"]]],[5,"_mm_fnmadd_sd","","Multiply the lower double-precision (64-bit) floating-point elements in `a` and `b`, and add the negated intermediate result to the lower element in `c`. Store the result in the lower element of the returned value, and copy the upper element from `a` to the upper elements of the result.",N,[[["__m128d"],["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_fnmadd_ss","","Multiply the lower single-precision (32-bit) floating-point elements in `a` and `b`, and add the negated intermediate result to the lower element in `c`. Store the result in the lower element of the returned value, and copy the 3 upper elements from `a` to the upper elements of the result.",N,[[["__m128"],["__m128"],["__m128"]],["__m128"]]],[5,"_mm_fnmsub_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the negated intermediate result.",N,[[["__m128d"],["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm256_fnmsub_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the negated intermediate result.",N,[[["__m256d"],["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm_fnmsub_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the negated intermediate result.",N,[[["__m128"],["__m128"],["__m128"]],["__m128"]]],[5,"_mm256_fnmsub_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the negated intermediate result.",N,[[["__m256"],["__m256"],["__m256"]],["__m256"]]],[5,"_mm_fnmsub_sd","","Multiply the lower double-precision (64-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the negated intermediate result. Store the result in the lower element of the returned value, and copy the upper element from `a` to the upper elements of the result.",N,[[["__m128d"],["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_fnmsub_ss","","Multiply the lower single-precision (32-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the negated intermediate result. Store the result in the lower element of the returned value, and copy the 3 upper elements from `a` to the upper elements of the result.",N,[[["__m128"],["__m128"],["__m128"]],["__m128"]]],[5,"_lzcnt_u32","","Counts the leading most significant zero bits.",N,[[["u32"]],["u32"]]],[5,"_popcnt32","","Counts the bits that are set.",N,[[["i32"]],["i32"]]],[5,"_bextr_u32","","Extracts bits in range [`start`, `start` + `length`) from `a` into the least significant bits of the result.",N,[[["u32"],["u32"],["u32"]],["u32"]]],[5,"_bextr2_u32","","Extracts bits of `a` specified by `control` into the least significant bits of the result.",N,[[["u32"],["u32"]],["u32"]]],[5,"_andn_u32","","Bitwise logical `AND` of inverted `a` with `b`.",N,[[["u32"],["u32"]],["u32"]]],[5,"_blsi_u32","","Extract lowest set isolated bit.",N,[[["u32"]],["u32"]]],[5,"_blsmsk_u32","","Get mask up to lowest set bit.",N,[[["u32"]],["u32"]]],[5,"_blsr_u32","","Resets the lowest set bit of `x`.",N,[[["u32"]],["u32"]]],[5,"_tzcnt_u32","","Counts the number of trailing least significant zero bits.",N,[[["u32"]],["u32"]]],[5,"_mm_tzcnt_32","","Counts the number of trailing least significant zero bits.",N,[[["u32"]],["i32"]]],[5,"_mulx_u32","","Unsigned multiply without affecting flags.",N,[[["u32"],["u32"],["u32"]],["u32"]]],[5,"_bzhi_u32","","Zero higher bits of `a` >= `index`.",N,[[["u32"],["u32"]],["u32"]]],[5,"_pdep_u32","","Scatter contiguous low order bits of `a` to the result at the positions specified by the `mask`.",N,[[["u32"],["u32"]],["u32"]]],[5,"_pext_u32","","Gathers the bits of `x` specified by the `mask` into the contiguous low order bit positions of the result.",N,[[["u32"],["u32"]],["u32"]]],[5,"_mm_extract_si64","","Extracts the bit range specified by `y` from the lower 64 bits of `x`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_insert_si64","","Inserts the `[length:0]` bits of `y` into `x` at `index`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_stream_sd","","Non-temporal store of `a.0` into `p`.",N,N],[5,"_mm_stream_ss","","Non-temporal store of `a.0` into `p`.",N,N],[5,"_blcfill_u32","","Clears all bits below the least significant zero bit of `x`.",N,[[["u32"]],["u32"]]],[5,"_blci_u32","","Sets all bits of `x` to 1 except for the least significant zero bit.",N,[[["u32"]],["u32"]]],[5,"_blcic_u32","","Sets the least significant zero bit of `x` and clears all other bits.",N,[[["u32"]],["u32"]]],[5,"_blcmsk_u32","","Sets the least significant zero bit of `x` and clears all bits above that bit.",N,[[["u32"]],["u32"]]],[5,"_blcs_u32","","Sets the least significant zero bit of `x`.",N,[[["u32"]],["u32"]]],[5,"_blsfill_u32","","Sets all bits of `x` below the least significant one.",N,[[["u32"]],["u32"]]],[5,"_blsic_u32","","Clears least significant bit and sets all other bits.",N,[[["u32"]],["u32"]]],[5,"_t1mskc_u32","","Clears all bits below the least significant zero of `x` and sets all other bits.",N,[[["u32"]],["u32"]]],[5,"_tzmsk_u32","","Sets all bits below the least significant one of `x` and clears all other bits.",N,[[["u32"]],["u32"]]],[5,"_mm_setzero_si64","","Constructs a 64-bit integer vector initialized to zero.",N,[[],["__m64"]]],[5,"_mm_add_pi8","","Add packed 8-bit integers in `a` and `b`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_paddb","","Add packed 8-bit integers in `a` and `b`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_add_pi16","","Add packed 16-bit integers in `a` and `b`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_paddw","","Add packed 16-bit integers in `a` and `b`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_add_pi32","","Add packed 32-bit integers in `a` and `b`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_paddd","","Add packed 32-bit integers in `a` and `b`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_adds_pi8","","Add packed 8-bit integers in `a` and `b` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_paddsb","","Add packed 8-bit integers in `a` and `b` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_adds_pi16","","Add packed 16-bit integers in `a` and `b` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_paddsw","","Add packed 16-bit integers in `a` and `b` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_adds_pu8","","Add packed unsigned 8-bit integers in `a` and `b` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_paddusb","","Add packed unsigned 8-bit integers in `a` and `b` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_adds_pu16","","Add packed unsigned 16-bit integers in `a` and `b` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_paddusw","","Add packed unsigned 16-bit integers in `a` and `b` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_sub_pi8","","Subtract packed 8-bit integers in `b` from packed 8-bit integers in `a`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_psubb","","Subtract packed 8-bit integers in `b` from packed 8-bit integers in `a`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_sub_pi16","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_psubw","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_sub_pi32","","Subtract packed 32-bit integers in `b` from packed 32-bit integers in `a`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_psubd","","Subtract packed 32-bit integers in `b` from packed 32-bit integers in `a`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_subs_pi8","","Subtract packed 8-bit integers in `b` from packed 8-bit integers in `a` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_psubsb","","Subtract packed 8-bit integers in `b` from packed 8-bit integers in `a` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_subs_pi16","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_psubsw","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_subs_pu8","","Subtract packed unsigned 8-bit integers in `b` from packed unsigned 8-bit integers in `a` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_psubusb","","Subtract packed unsigned 8-bit integers in `b` from packed unsigned 8-bit integers in `a` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_subs_pu16","","Subtract packed unsigned 16-bit integers in `b` from packed unsigned 16-bit integers in `a` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_psubusw","","Subtract packed unsigned 16-bit integers in `b` from packed unsigned 16-bit integers in `a` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_packs_pi16","","Convert packed 16-bit integers from `a` and `b` to packed 8-bit integers using signed saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_packs_pi32","","Convert packed 32-bit integers from `a` and `b` to packed 16-bit integers using signed saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_cmpgt_pi8","","Compares whether each element of `a` is greater than the corresponding element of `b` returning `0` for `false` and `-1` for `true`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_cmpgt_pi16","","Compares whether each element of `a` is greater than the corresponding element of `b` returning `0` for `false` and `-1` for `true`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_cmpgt_pi32","","Compares whether each element of `a` is greater than the corresponding element of `b` returning `0` for `false` and `-1` for `true`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_unpackhi_pi16","","Unpacks the upper two elements from two `i16x4` vectors and interleaves them into the result: `[a.2, b.2, a.3, b.3]`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_unpackhi_pi8","","Unpacks the upper four elements from two `i8x8` vectors and interleaves them into the result: `[a.4, b.4, a.5, b.5, a.6, b.6, a.7, b.7]`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_unpacklo_pi8","","Unpacks the lower four elements from two `i8x8` vectors and interleaves them into the result: `[a.0, b.0, a.1, b.1, a.2, b.2, a.3, b.3]`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_unpacklo_pi16","","Unpacks the lower two elements from two `i16x4` vectors and interleaves them into the result: `[a.0 b.0 a.1 b.1]`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_unpackhi_pi32","","Unpacks the upper element from two `i32x2` vectors and interleaves them into the result: `[a.1, b.1]`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_unpacklo_pi32","","Unpacks the lower element from two `i32x2` vectors and interleaves them into the result: `[a.0, b.0]`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_set_pi16","","Set packed 16-bit integers in dst with the supplied values.",N,[[["i16"],["i16"],["i16"],["i16"]],["__m64"]]],[5,"_mm_set_pi32","","Set packed 32-bit integers in dst with the supplied values.",N,[[["i32"],["i32"]],["__m64"]]],[5,"_mm_set_pi8","","Set packed 8-bit integers in dst with the supplied values.",N,[[["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"]],["__m64"]]],[5,"_mm_set1_pi16","","Broadcast 16-bit integer a to all all elements of dst.",N,[[["i16"]],["__m64"]]],[5,"_mm_set1_pi32","","Broadcast 32-bit integer a to all all elements of dst.",N,[[["i32"]],["__m64"]]],[5,"_mm_set1_pi8","","Broadcast 8-bit integer a to all all elements of dst.",N,[[["i8"]],["__m64"]]],[5,"_mm_setr_pi16","","Set packed 16-bit integers in dst with the supplied values in reverse order.",N,[[["i16"],["i16"],["i16"],["i16"]],["__m64"]]],[5,"_mm_setr_pi32","","Set packed 32-bit integers in dst with the supplied values in reverse order.",N,[[["i32"],["i32"]],["__m64"]]],[5,"_mm_setr_pi8","","Set packed 8-bit integers in dst with the supplied values in reverse order.",N,[[["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"]],["__m64"]]],[5,"_mm_clmulepi64_si128","","Perform a carry-less multiplication of two 64-bit polynomials over the finite field GF(2^k).",N,[[["__m128i"],["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_aesdec_si128","","Perform one round of an AES decryption flow on data (state) in `a`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_aesdeclast_si128","","Perform the last round of an AES decryption flow on data (state) in `a`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_aesenc_si128","","Perform one round of an AES encryption flow on data (state) in `a`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_aesenclast_si128","","Perform the last round of an AES encryption flow on data (state) in `a`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_aesimc_si128","","Perform the `InvMixColumns` transformation on `a`.",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_aeskeygenassist_si128","","Assist in expanding the AES cipher key.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_rdrand16_step","","Read a hardware generated 16-bit random value and store the result in val. Return 1 if a random value was generated, and 0 otherwise.",N,[[["u16"]],["i32"]]],[5,"_rdrand32_step","","Read a hardware generated 32-bit random value and store the result in val. Return 1 if a random value was generated, and 0 otherwise.",N,[[["u32"]],["i32"]]],[5,"_rdseed16_step","","Read a 16-bit NIST SP800-90B and SP800-90C compliant random value and store in val. Return 1 if a random value was generated, and 0 otherwise.",N,[[["u16"]],["i32"]]],[5,"_rdseed32_step","","Read a 32-bit NIST SP800-90B and SP800-90C compliant random value and store in val. Return 1 if a random value was generated, and 0 otherwise.",N,[[["u32"]],["i32"]]],[5,"_mm_sha1msg1_epu32","","Perform an intermediate calculation for the next four SHA1 message values (unsigned 32-bit integers) using previous message values from `a` and `b`, and returning the result.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_sha1msg2_epu32","","Perform the final calculation for the next four SHA1 message values (unsigned 32-bit integers) using the intermediate result in `a` and the previous message values in `b`, and returns the result.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_sha1nexte_epu32","","Calculate SHA1 state variable E after four rounds of operation from the current SHA1 state variable `a`, add that value to the scheduled values (unsigned 32-bit integers) in `b`, and returns the result.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_sha1rnds4_epu32","","Perform four rounds of SHA1 operation using an initial SHA1 state (A,B,C,D) from `a` and some pre-computed sum of the next 4 round message values (unsigned 32-bit integers), and state variable E from `b`, and return the updated SHA1 state (A,B,C,D). `func` contains the logic functions and round constants.",N,[[["__m128i"],["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_sha256msg1_epu32","","Perform an intermediate calculation for the next four SHA256 message values (unsigned 32-bit integers) using previous message values from `a` and `b`, and return the result.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_sha256msg2_epu32","","Perform the final calculation for the next four SHA256 message values (unsigned 32-bit integers) using previous message values from `a` and `b`, and return the result.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_sha256rnds2_epu32","","Perform 2 rounds of SHA256 operation using an initial SHA256 state (C,D,G,H) from `a`, an initial SHA256 state (A,B,E,F) from `b`, and a pre-computed sum of the next 2 round message values (unsigned 32-bit integers) and the corresponding round constants from `k`, and store the updated SHA256 state (A,B,E,F) in dst.",N,[[["__m128i"],["__m128i"],["__m128i"]],["__m128i"]]],[17,"_XCR_XFEATURE_ENABLED_MASK","","`XFEATURE_ENABLED_MASK` for `XCR`",N,N],[17,"_MM_EXCEPT_INVALID","","See `_mm_setcsr`",N,N],[17,"_MM_EXCEPT_DENORM","","See `_mm_setcsr`",N,N],[17,"_MM_EXCEPT_DIV_ZERO","","See `_mm_setcsr`",N,N],[17,"_MM_EXCEPT_OVERFLOW","","See `_mm_setcsr`",N,N],[17,"_MM_EXCEPT_UNDERFLOW","","See `_mm_setcsr`",N,N],[17,"_MM_EXCEPT_INEXACT","","See `_mm_setcsr`",N,N],[17,"_MM_EXCEPT_MASK","","See `_MM_GET_EXCEPTION_STATE`",N,N],[17,"_MM_MASK_INVALID","","See `_mm_setcsr`",N,N],[17,"_MM_MASK_DENORM","","See `_mm_setcsr`",N,N],[17,"_MM_MASK_DIV_ZERO","","See `_mm_setcsr`",N,N],[17,"_MM_MASK_OVERFLOW","","See `_mm_setcsr`",N,N],[17,"_MM_MASK_UNDERFLOW","","See `_mm_setcsr`",N,N],[17,"_MM_MASK_INEXACT","","See `_mm_setcsr`",N,N],[17,"_MM_MASK_MASK","","See `_MM_GET_EXCEPTION_MASK`",N,N],[17,"_MM_ROUND_NEAREST","","See `_mm_setcsr`",N,N],[17,"_MM_ROUND_DOWN","","See `_mm_setcsr`",N,N],[17,"_MM_ROUND_UP","","See `_mm_setcsr`",N,N],[17,"_MM_ROUND_TOWARD_ZERO","","See `_mm_setcsr`",N,N],[17,"_MM_ROUND_MASK","","See `_MM_GET_ROUNDING_MODE`",N,N],[17,"_MM_FLUSH_ZERO_MASK","","See `_MM_GET_FLUSH_ZERO_MODE`",N,N],[17,"_MM_FLUSH_ZERO_ON","","See `_mm_setcsr`",N,N],[17,"_MM_FLUSH_ZERO_OFF","","See `_mm_setcsr`",N,N],[17,"_MM_HINT_T0","","See `_mm_prefetch`.",N,N],[17,"_MM_HINT_T1","","See `_mm_prefetch`.",N,N],[17,"_MM_HINT_T2","","See `_mm_prefetch`.",N,N],[17,"_MM_HINT_NTA","","See `_mm_prefetch`.",N,N],[17,"_MM_FROUND_TO_NEAREST_INT","","round to nearest",N,N],[17,"_MM_FROUND_TO_NEG_INF","","round down",N,N],[17,"_MM_FROUND_TO_POS_INF","","round up",N,N],[17,"_MM_FROUND_TO_ZERO","","truncate",N,N],[17,"_MM_FROUND_CUR_DIRECTION","","use MXCSR.RC; see `vendor::_MM_SET_ROUNDING_MODE`",N,N],[17,"_MM_FROUND_RAISE_EXC","","do not suppress exceptions",N,N],[17,"_MM_FROUND_NO_EXC","","suppress exceptions",N,N],[17,"_MM_FROUND_NINT","","round to nearest and do not suppress exceptions",N,N],[17,"_MM_FROUND_FLOOR","","round down and do not suppress exceptions",N,N],[17,"_MM_FROUND_CEIL","","round up and do not suppress exceptions",N,N],[17,"_MM_FROUND_TRUNC","","truncate and do not suppress exceptions",N,N],[17,"_MM_FROUND_RINT","","use MXCSR.RC and do not suppress exceptions; see `vendor::_MM_SET_ROUNDING_MODE`",N,N],[17,"_MM_FROUND_NEARBYINT","","use MXCSR.RC and suppress exceptions; see `vendor::_MM_SET_ROUNDING_MODE`",N,N],[17,"_SIDD_UBYTE_OPS","","String contains unsigned 8-bit characters (Default)",N,N],[17,"_SIDD_UWORD_OPS","","String contains unsigned 16-bit characters",N,N],[17,"_SIDD_SBYTE_OPS","","String contains signed 8-bit characters",N,N],[17,"_SIDD_SWORD_OPS","","String contains unsigned 16-bit characters",N,N],[17,"_SIDD_CMP_EQUAL_ANY","","For each character in `a`, find if it is in `b` (Default)",N,N],[17,"_SIDD_CMP_RANGES","","For each character in `a`, determine if `b[0] <= c <= b[1] or b[1] <= c <= b[2]...`",N,N],[17,"_SIDD_CMP_EQUAL_EACH","","The strings defined by `a` and `b` are equal",N,N],[17,"_SIDD_CMP_EQUAL_ORDERED","","Search for the defined substring in the target",N,N],[17,"_SIDD_POSITIVE_POLARITY","","Do not negate results (Default)",N,N],[17,"_SIDD_NEGATIVE_POLARITY","","Negate results",N,N],[17,"_SIDD_MASKED_POSITIVE_POLARITY","","Do not negate results before the end of the string",N,N],[17,"_SIDD_MASKED_NEGATIVE_POLARITY","","Negate results only before the end of the string",N,N],[17,"_SIDD_LEAST_SIGNIFICANT","","Index only: return the least significant bit (Default)",N,N],[17,"_SIDD_MOST_SIGNIFICANT","","Index only: return the most significant bit",N,N],[17,"_SIDD_BIT_MASK","","Mask only: return the bit mask",N,N],[17,"_SIDD_UNIT_MASK","","Mask only: return the byte mask",N,N],[17,"_CMP_EQ_OQ","","Equal (ordered, non-signaling)",N,N],[17,"_CMP_LT_OS","","Less-than (ordered, signaling)",N,N],[17,"_CMP_LE_OS","","Less-than-or-equal (ordered, signaling)",N,N],[17,"_CMP_UNORD_Q","","Unordered (non-signaling)",N,N],[17,"_CMP_NEQ_UQ","","Not-equal (unordered, non-signaling)",N,N],[17,"_CMP_NLT_US","","Not-less-than (unordered, signaling)",N,N],[17,"_CMP_NLE_US","","Not-less-than-or-equal (unordered, signaling)",N,N],[17,"_CMP_ORD_Q","","Ordered (non-signaling)",N,N],[17,"_CMP_EQ_UQ","","Equal (unordered, non-signaling)",N,N],[17,"_CMP_NGE_US","","Not-greater-than-or-equal (unordered, signaling)",N,N],[17,"_CMP_NGT_US","","Not-greater-than (unordered, signaling)",N,N],[17,"_CMP_FALSE_OQ","","False (ordered, non-signaling)",N,N],[17,"_CMP_NEQ_OQ","","Not-equal (ordered, non-signaling)",N,N],[17,"_CMP_GE_OS","","Greater-than-or-equal (ordered, signaling)",N,N],[17,"_CMP_GT_OS","","Greater-than (ordered, signaling)",N,N],[17,"_CMP_TRUE_UQ","","True (unordered, non-signaling)",N,N],[17,"_CMP_EQ_OS","","Equal (ordered, signaling)",N,N],[17,"_CMP_LT_OQ","","Less-than (ordered, non-signaling)",N,N],[17,"_CMP_LE_OQ","","Less-than-or-equal (ordered, non-signaling)",N,N],[17,"_CMP_UNORD_S","","Unordered (signaling)",N,N],[17,"_CMP_NEQ_US","","Not-equal (unordered, signaling)",N,N],[17,"_CMP_NLT_UQ","","Not-less-than (unordered, non-signaling)",N,N],[17,"_CMP_NLE_UQ","","Not-less-than-or-equal (unordered, non-signaling)",N,N],[17,"_CMP_ORD_S","","Ordered (signaling)",N,N],[17,"_CMP_EQ_US","","Equal (unordered, signaling)",N,N],[17,"_CMP_NGE_UQ","","Not-greater-than-or-equal (unordered, non-signaling)",N,N],[17,"_CMP_NGT_UQ","","Not-greater-than (unordered, non-signaling)",N,N],[17,"_CMP_FALSE_OS","","False (ordered, signaling)",N,N],[17,"_CMP_NEQ_OS","","Not-equal (ordered, signaling)",N,N],[17,"_CMP_GE_OQ","","Greater-than-or-equal (ordered, non-signaling)",N,N],[17,"_CMP_GT_OQ","","Greater-than (ordered, non-signaling)",N,N],[17,"_CMP_TRUE_US","","True (unordered, signaling)",N,N],[0,"x86_64","core::arch","Platform-specific intrinsics for the `x86_64` platform.",N,N],[3,"__m64","core::arch::x86_64","64-bit wide integer vector type, x86-specific",N,N],[3,"__m128i","","128-bit wide integer vector type, x86-specific",N,N],[3,"__m128","","128-bit wide set of four `f32` types, x86-specific",N,N],[3,"__m128d","","128-bit wide set of two `f64` types, x86-specific",N,N],[3,"__m256i","","256-bit wide integer vector type, x86-specific",N,N],[3,"__m256","","256-bit wide set of eight `f32` types, x86-specific",N,N],[3,"__m256d","","256-bit wide set of four `f64` types, x86-specific",N,N],[3,"CpuidResult","","Result of the `cpuid` instruction.",N,N],[12,"eax","","EAX register.",248,N],[12,"ebx","","EBX register.",248,N],[12,"ecx","","ECX register.",248,N],[12,"edx","","EDX register.",248,N],[5,"_fxsave","","Saves the `x87` FPU, `MMX` technology, `XMM`, and `MXCSR` registers to the 512-byte-long 16-byte-aligned memory region `mem_addr`.",N,N],[5,"_fxrstor","","Restores the `XMM`, `MMX`, `MXCSR`, and `x87` FPU registers from the 512-byte-long 16-byte-aligned memory region `mem_addr`.",N,N],[5,"_bswap","","Return an integer with the reversed byte order of x",N,[[["i32"]],["i32"]]],[5,"_rdtsc","","Reads the current value of the processor’s time-stamp counter.",N,[[],["i64"]]],[5,"__rdtscp","","Reads the current value of the processor’s time-stamp counter and the `IA32_TSC_AUX MSR`.",N,N],[5,"__cpuid_count","","Returns the result of the `cpuid` instruction for a given `leaf` (`EAX`) and `sub_leaf` (`ECX`).",N,[[["u32"],["u32"]],["cpuidresult"]]],[5,"__cpuid","","See `__cpuid_count`.",N,[[["u32"]],["cpuidresult"]]],[5,"has_cpuid","","Does the host support the `cpuid` instruction?",N,[[],["bool"]]],[5,"__get_cpuid_max","","Returns the highest-supported `leaf` (`EAX`) and sub-leaf (`ECX`) `cpuid` values.",N,N],[5,"_xsave","","Perform a full or partial save of the enabled processor states to memory at `mem_addr`.",N,N],[5,"_xrstor","","Perform a full or partial restore of the enabled processor states using the state information stored in memory at `mem_addr`.",N,N],[5,"_xsetbv","","Copy 64-bits from `val` to the extended control register (`XCR`) specified by `a`.",N,[[["u32"],["u64"]]]],[5,"_xgetbv","","Reads the contents of the extended control register `XCR` specified in `xcr_no`.",N,[[["u32"]],["u64"]]],[5,"_xsaveopt","","Perform a full or partial save of the enabled processor states to memory at `mem_addr`.",N,N],[5,"_xsavec","","Perform a full or partial save of the enabled processor states to memory at `mem_addr`.",N,N],[5,"_xsaves","","Perform a full or partial save of the enabled processor states to memory at `mem_addr`",N,N],[5,"_xrstors","","Perform a full or partial restore of the enabled processor states using the state information stored in memory at `mem_addr`.",N,N],[5,"_mm_add_ss","","Adds the first component of `a` and `b`, the other components are copied from `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_add_ps","","Adds __m128 vectors.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_sub_ss","","Subtracts the first component of `b` from `a`, the other components are copied from `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_sub_ps","","Subtracts __m128 vectors.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_mul_ss","","Multiplies the first component of `a` and `b`, the other components are copied from `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_mul_ps","","Multiplies __m128 vectors.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_div_ss","","Divides the first component of `b` by `a`, the other components are copied from `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_div_ps","","Divides __m128 vectors.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_sqrt_ss","","Return the square root of the first single-precision (32-bit) floating-point element in `a`, the other elements are unchanged.",N,[[["__m128"]],["__m128"]]],[5,"_mm_sqrt_ps","","Return the square root of packed single-precision (32-bit) floating-point elements in `a`.",N,[[["__m128"]],["__m128"]]],[5,"_mm_rcp_ss","","Return the approximate reciprocal of the first single-precision (32-bit) floating-point element in `a`, the other elements are unchanged.",N,[[["__m128"]],["__m128"]]],[5,"_mm_rcp_ps","","Return the approximate reciprocal of packed single-precision (32-bit) floating-point elements in `a`.",N,[[["__m128"]],["__m128"]]],[5,"_mm_rsqrt_ss","","Return the approximate reciprocal square root of the fist single-precision (32-bit) floating-point elements in `a`, the other elements are unchanged.",N,[[["__m128"]],["__m128"]]],[5,"_mm_rsqrt_ps","","Return the approximate reciprocal square root of packed single-precision (32-bit) floating-point elements in `a`.",N,[[["__m128"]],["__m128"]]],[5,"_mm_min_ss","","Compare the first single-precision (32-bit) floating-point element of `a` and `b`, and return the minimum value in the first element of the return value, the other elements are copied from `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_min_ps","","Compare packed single-precision (32-bit) floating-point elements in `a` and `b`, and return the corresponding minimum values.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_max_ss","","Compare the first single-precision (32-bit) floating-point element of `a` and `b`, and return the maximum value in the first element of the return value, the other elements are copied from `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_max_ps","","Compare packed single-precision (32-bit) floating-point elements in `a` and `b`, and return the corresponding maximum values.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_and_ps","","Bitwise AND of packed single-precision (32-bit) floating-point elements.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_andnot_ps","","Bitwise AND-NOT of packed single-precision (32-bit) floating-point elements.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_or_ps","","Bitwise OR of packed single-precision (32-bit) floating-point elements.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_xor_ps","","Bitwise exclusive OR of packed single-precision (32-bit) floating-point elements.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpeq_ss","","Compare the lowest `f32` of both inputs for equality. The lowest 32 bits of the result will be `0xffffffff` if the two inputs are equal, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmplt_ss","","Compare the lowest `f32` of both inputs for less than. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is less than `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmple_ss","","Compare the lowest `f32` of both inputs for less than or equal. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is less than or equal `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpgt_ss","","Compare the lowest `f32` of both inputs for greater than. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is greater than `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpge_ss","","Compare the lowest `f32` of both inputs for greater than or equal. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is greater than or equal `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpneq_ss","","Compare the lowest `f32` of both inputs for inequality. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is not equal to `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpnlt_ss","","Compare the lowest `f32` of both inputs for not-less-than. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is not less than `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpnle_ss","","Compare the lowest `f32` of both inputs for not-less-than-or-equal. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is not less than or equal to `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpngt_ss","","Compare the lowest `f32` of both inputs for not-greater-than. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is not greater than `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpnge_ss","","Compare the lowest `f32` of both inputs for not-greater-than-or-equal. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is not greater than or equal to `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpord_ss","","Check if the lowest `f32` of both inputs are ordered. The lowest 32 bits of the result will be `0xffffffff` if neither of `a.extract(0)` or `b.extract(0)` is a NaN, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpunord_ss","","Check if the lowest `f32` of both inputs are unordered. The lowest 32 bits of the result will be `0xffffffff` if any of `a.extract(0)` or `b.extract(0)` is a NaN, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpeq_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input elements were equal, or `0` otherwise.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmplt_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is less than the corresponding element in `b`, or `0` otherwise.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmple_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is less than or equal to the corresponding element in `b`, or `0` otherwise.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpgt_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is greater than the corresponding element in `b`, or `0` otherwise.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpge_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is greater than or equal to the corresponding element in `b`, or `0` otherwise.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpneq_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input elements are not equal, or `0` otherwise.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpnlt_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is not less than the corresponding element in `b`, or `0` otherwise.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpnle_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is not less than or equal to the corresponding element in `b`, or `0` otherwise.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpngt_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is not greater than the corresponding element in `b`, or `0` otherwise.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpnge_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is not greater than or equal to the corresponding element in `b`, or `0` otherwise.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpord_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. Returns four floats that have one of two possible bit patterns. The element in the output vector will be `0xffffffff` if the input elements in `a` and `b` are ordered (i.e., neither of them is a NaN), or 0 otherwise.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpunord_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. Returns four floats that have one of two possible bit patterns. The element in the output vector will be `0xffffffff` if the input elements in `a` and `b` are unordered (i.e., at least on of them is a NaN), or 0 otherwise.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_comieq_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if they are equal, or `0` otherwise.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm_comilt_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is less than the one from `b`, or `0` otherwise.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm_comile_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is less than or equal to the one from `b`, or `0` otherwise.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm_comigt_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is greater than the one from `b`, or `0` otherwise.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm_comige_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is greater than or equal to the one from `b`, or `0` otherwise.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm_comineq_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if they are not equal, or `0` otherwise.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm_ucomieq_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if they are equal, or `0` otherwise. This instruction will not signal an exception if either argument is a quiet NaN.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm_ucomilt_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is less than the one from `b`, or `0` otherwise. This instruction will not signal an exception if either argument is a quiet NaN.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm_ucomile_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is less than or equal to the one from `b`, or `0` otherwise. This instruction will not signal an exception if either argument is a quiet NaN.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm_ucomigt_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is greater than the one from `b`, or `0` otherwise. This instruction will not signal an exception if either argument is a quiet NaN.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm_ucomige_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is greater than or equal to the one from `b`, or `0` otherwise. This instruction will not signal an exception if either argument is a quiet NaN.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm_ucomineq_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if they are not equal, or `0` otherwise. This instruction will not signal an exception if either argument is a quiet NaN.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm_cvtss_si32","","Convert the lowest 32 bit float in the input vector to a 32 bit integer.",N,[[["__m128"]],["i32"]]],[5,"_mm_cvt_ss2si","","Alias for `_mm_cvtss_si32`.",N,[[["__m128"]],["i32"]]],[5,"_mm_cvttss_si32","","Convert the lowest 32 bit float in the input vector to a 32 bit integer with truncation.",N,[[["__m128"]],["i32"]]],[5,"_mm_cvtt_ss2si","","Alias for `_mm_cvttss_si32`.",N,[[["__m128"]],["i32"]]],[5,"_mm_cvtss_f32","","Extract the lowest 32 bit float from the input vector.",N,[[["__m128"]],["f32"]]],[5,"_mm_cvtsi32_ss","","Convert a 32 bit integer to a 32 bit float. The result vector is the input vector `a` with the lowest 32 bit float replaced by the converted integer.",N,[[["__m128"],["i32"]],["__m128"]]],[5,"_mm_cvt_si2ss","","Alias for `_mm_cvtsi32_ss`.",N,[[["__m128"],["i32"]],["__m128"]]],[5,"_mm_set_ss","","Construct a `__m128` with the lowest element set to `a` and the rest set to zero.",N,[[["f32"]],["__m128"]]],[5,"_mm_set1_ps","","Construct a `__m128` with all element set to `a`.",N,[[["f32"]],["__m128"]]],[5,"_mm_set_ps1","","Alias for `_mm_set1_ps`",N,[[["f32"]],["__m128"]]],[5,"_mm_set_ps","","Construct a `__m128` from four floating point values highest to lowest.",N,[[["f32"],["f32"],["f32"],["f32"]],["__m128"]]],[5,"_mm_setr_ps","","Construct a `__m128` from four floating point values lowest to highest.",N,[[["f32"],["f32"],["f32"],["f32"]],["__m128"]]],[5,"_mm_setzero_ps","","Construct a `__m128` with all elements initialized to zero.",N,[[],["__m128"]]],[5,"_MM_SHUFFLE","","A utility function for creating masks to use with Intel shuffle and permute intrinsics.",N,[[["u32"],["u32"],["u32"],["u32"]],["u32"]]],[5,"_mm_shuffle_ps","","Shuffle packed single-precision (32-bit) floating-point elements in `a` and `b` using `mask`.",N,[[["__m128"],["__m128"],["u32"]],["__m128"]]],[5,"_mm_unpackhi_ps","","Unpack and interleave single-precision (32-bit) floating-point elements from the higher half of `a` and `b`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_unpacklo_ps","","Unpack and interleave single-precision (32-bit) floating-point elements from the lower half of `a` and `b`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_movehl_ps","","Combine higher half of `a` and `b`. The highwe half of `b` occupies the lower half of result.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_movelh_ps","","Combine lower half of `a` and `b`. The lower half of `b` occupies the higher half of result.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_movemask_ps","","Return a mask of the most significant bit of each element in `a`.",N,[[["__m128"]],["i32"]]],[5,"_mm_loadh_pi","","Set the upper two single-precision floating-point values with 64 bits of data loaded from the address `p`; the lower two values are passed through from `a`.",N,N],[5,"_mm_loadl_pi","","Load two floats from `p` into the lower half of a `__m128`. The upper half is copied from the upper half of `a`.",N,N],[5,"_mm_load_ss","","Construct a `__m128` with the lowest element read from `p` and the other elements set to zero.",N,N],[5,"_mm_load1_ps","","Construct a `__m128` by duplicating the value read from `p` into all elements.",N,N],[5,"_mm_load_ps1","","Alias for `_mm_load1_ps`",N,N],[5,"_mm_load_ps","","Load four `f32` values from aligned memory into a `__m128`. If the pointer is not aligned to a 128-bit boundary (16 bytes) a general protection fault will be triggered (fatal program crash).",N,N],[5,"_mm_loadu_ps","","Load four `f32` values from memory into a `__m128`. There are no restrictions on memory alignment. For aligned memory `_mm_load_ps` may be faster.",N,N],[5,"_mm_loadr_ps","","Load four `f32` values from aligned memory into a `__m128` in reverse order.",N,N],[5,"_mm_storeh_pi","","Store the upper half of `a` (64 bits) into memory.",N,N],[5,"_mm_storel_pi","","Store the lower half of `a` (64 bits) into memory.",N,N],[5,"_mm_store_ss","","Store the lowest 32 bit float of `a` into memory.",N,N],[5,"_mm_store1_ps","","Store the lowest 32 bit float of `a` repeated four times into aligned memory.",N,N],[5,"_mm_store_ps1","","Alias for `_mm_store1_ps`",N,N],[5,"_mm_store_ps","","Store four 32-bit floats into aligned memory.",N,N],[5,"_mm_storeu_ps","","Store four 32-bit floats into memory. There are no restrictions on memory alignment. For aligned memory `_mm_store_ps` may be faster.",N,N],[5,"_mm_storer_ps","","Store four 32-bit floats into aligned memory in reverse order.",N,N],[5,"_mm_move_ss","","Return a `__m128` with the first component from `b` and the remaining components from `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_sfence","","Perform a serializing operation on all store-to-memory instructions that were issued prior to this instruction.",N,[[]]],[5,"_mm_getcsr","","Get the unsigned 32-bit value of the MXCSR control and status register.",N,[[],["u32"]]],[5,"_mm_setcsr","","Set the MXCSR register with the 32-bit unsigned integer value.",N,[[["u32"]]]],[5,"_MM_GET_EXCEPTION_MASK","","See `_mm_setcsr`",N,[[],["u32"]]],[5,"_MM_GET_EXCEPTION_STATE","","See `_mm_setcsr`",N,[[],["u32"]]],[5,"_MM_GET_FLUSH_ZERO_MODE","","See `_mm_setcsr`",N,[[],["u32"]]],[5,"_MM_GET_ROUNDING_MODE","","See `_mm_setcsr`",N,[[],["u32"]]],[5,"_MM_SET_EXCEPTION_MASK","","See `_mm_setcsr`",N,[[["u32"]]]],[5,"_MM_SET_EXCEPTION_STATE","","See `_mm_setcsr`",N,[[["u32"]]]],[5,"_MM_SET_FLUSH_ZERO_MODE","","See `_mm_setcsr`",N,[[["u32"]]]],[5,"_MM_SET_ROUNDING_MODE","","See `_mm_setcsr`",N,[[["u32"]]]],[5,"_mm_prefetch","","Fetch the cache line that contains address `p` using the given `strategy`.",N,N],[5,"_mm_undefined_ps","","Return vector of type __m128 with undefined elements.",N,[[],["__m128"]]],[5,"_MM_TRANSPOSE4_PS","","Transpose the 4x4 matrix formed by 4 rows of __m128 in place.",N,[[["__m128"],["__m128"],["__m128"],["__m128"]]]],[5,"_mm_stream_ps","","Stores `a` into the memory at `mem_addr` using a non-temporal memory hint.",N,N],[5,"_mm_stream_pi","","Store 64-bits of integer data from a into memory using a non-temporal memory hint.",N,N],[5,"_mm_max_pi16","","Compares the packed 16-bit signed integers of `a` and `b` writing the greatest value into the result.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_pmaxsw","","Compares the packed 16-bit signed integers of `a` and `b` writing the greatest value into the result.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_max_pu8","","Compares the packed 8-bit signed integers of `a` and `b` writing the greatest value into the result.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_pmaxub","","Compares the packed 8-bit signed integers of `a` and `b` writing the greatest value into the result.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_min_pi16","","Compares the packed 16-bit signed integers of `a` and `b` writing the smallest value into the result.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_pminsw","","Compares the packed 16-bit signed integers of `a` and `b` writing the smallest value into the result.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_min_pu8","","Compares the packed 8-bit signed integers of `a` and `b` writing the smallest value into the result.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_pminub","","Compares the packed 8-bit signed integers of `a` and `b` writing the smallest value into the result.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_mulhi_pu16","","Multiplies packed 16-bit unsigned integer values and writes the high-order 16 bits of each 32-bit product to the corresponding bits in the destination.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_mullo_pi16","","Multiplies packed 16-bit integer values and writes the low-order 16 bits of each 32-bit product to the corresponding bits in the destination.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_pmulhuw","","Multiplies packed 16-bit unsigned integer values and writes the high-order 16 bits of each 32-bit product to the corresponding bits in the destination.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_avg_pu8","","Computes the rounded averages of the packed unsigned 8-bit integer values and writes the averages to the corresponding bits in the destination.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_pavgb","","Computes the rounded averages of the packed unsigned 8-bit integer values and writes the averages to the corresponding bits in the destination.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_avg_pu16","","Computes the rounded averages of the packed unsigned 16-bit integer values and writes the averages to the corresponding bits in the destination.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_pavgw","","Computes the rounded averages of the packed unsigned 16-bit integer values and writes the averages to the corresponding bits in the destination.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_sad_pu8","","Subtracts the corresponding 8-bit unsigned integer values of the two 64-bit vector operands and computes the absolute value for each of the difference. Then sum of the 8 absolute differences is written to the bits `[15:0]` of the destination; the remaining bits `[63:16]` are cleared.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_psadbw","","Subtracts the corresponding 8-bit unsigned integer values of the two 64-bit vector operands and computes the absolute value for each of the difference. Then sum of the 8 absolute differences is written to the bits `[15:0]` of the destination; the remaining bits `[63:16]` are cleared.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_cvtpi32_ps","","Converts two elements of a 64-bit vector of `[2 x i32]` into two floating point values and writes them to the lower 64-bits of the destination. The remaining higher order elements of the destination are copied from the corresponding elements in the first operand.",N,[[["__m128"],["__m64"]],["__m128"]]],[5,"_mm_cvt_pi2ps","","Converts two elements of a 64-bit vector of `[2 x i32]` into two floating point values and writes them to the lower 64-bits of the destination. The remaining higher order elements of the destination are copied from the corresponding elements in the first operand.",N,[[["__m128"],["__m64"]],["__m128"]]],[5,"_mm_cvtpi8_ps","","Converts the lower 4 8-bit values of `a` into a 128-bit vector of 4 `f32`s.",N,[[["__m64"]],["__m128"]]],[5,"_mm_cvtpu8_ps","","Converts the lower 4 8-bit values of `a` into a 128-bit vector of 4 `f32`s.",N,[[["__m64"]],["__m128"]]],[5,"_mm_cvtpi16_ps","","Converts a 64-bit vector of `i16`s into a 128-bit vector of 4 `f32`s.",N,[[["__m64"]],["__m128"]]],[5,"_mm_cvtpu16_ps","","Converts a 64-bit vector of `i16`s into a 128-bit vector of 4 `f32`s.",N,[[["__m64"]],["__m128"]]],[5,"_mm_cvtpi32x2_ps","","Converts the two 32-bit signed integer values from each 64-bit vector operand of `[2 x i32]` into a 128-bit vector of `[4 x float]`.",N,[[["__m64"],["__m64"]],["__m128"]]],[5,"_mm_maskmove_si64","","Conditionally copies the values from each 8-bit element in the first 64-bit integer vector operand to the specified memory location, as specified by the most significant bit in the corresponding element in the second 64-bit integer vector operand.",N,N],[5,"_m_maskmovq","","Conditionally copies the values from each 8-bit element in the first 64-bit integer vector operand to the specified memory location, as specified by the most significant bit in the corresponding element in the second 64-bit integer vector operand.",N,N],[5,"_mm_extract_pi16","","Extracts 16-bit element from a 64-bit vector of `[4 x i16]` and returns it, as specified by the immediate integer operand.",N,[[["__m64"],["i32"]],["i32"]]],[5,"_m_pextrw","","Extracts 16-bit element from a 64-bit vector of `[4 x i16]` and returns it, as specified by the immediate integer operand.",N,[[["__m64"],["i32"]],["i32"]]],[5,"_mm_insert_pi16","","Copies data from the 64-bit vector of `[4 x i16]` to the destination, and inserts the lower 16-bits of an integer operand at the 16-bit offset specified by the immediate operand `n`.",N,[[["__m64"],["i32"],["i32"]],["__m64"]]],[5,"_m_pinsrw","","Copies data from the 64-bit vector of `[4 x i16]` to the destination, and inserts the lower 16-bits of an integer operand at the 16-bit offset specified by the immediate operand `n`.",N,[[["__m64"],["i32"],["i32"]],["__m64"]]],[5,"_mm_movemask_pi8","","Takes the most significant bit from each 8-bit element in a 64-bit integer vector to create a 16-bit mask value. Zero-extends the value to 32-bit integer and writes it to the destination.",N,[[["__m64"]],["i32"]]],[5,"_m_pmovmskb","","Takes the most significant bit from each 8-bit element in a 64-bit integer vector to create a 16-bit mask value. Zero-extends the value to 32-bit integer and writes it to the destination.",N,[[["__m64"]],["i32"]]],[5,"_mm_shuffle_pi16","","Shuffles the 4 16-bit integers from a 64-bit integer vector to the destination, as specified by the immediate value operand.",N,[[["__m64"],["i32"]],["__m64"]]],[5,"_m_pshufw","","Shuffles the 4 16-bit integers from a 64-bit integer vector to the destination, as specified by the immediate value operand.",N,[[["__m64"],["i32"]],["__m64"]]],[5,"_mm_cvttps_pi32","","Convert the two lower packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers with truncation.",N,[[["__m128"]],["__m64"]]],[5,"_mm_cvtt_ps2pi","","Convert the two lower packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers with truncation.",N,[[["__m128"]],["__m64"]]],[5,"_mm_cvtps_pi32","","Convert the two lower packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers.",N,[[["__m128"]],["__m64"]]],[5,"_mm_cvt_ps2pi","","Convert the two lower packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers.",N,[[["__m128"]],["__m64"]]],[5,"_mm_cvtps_pi16","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed 16-bit integers.",N,[[["__m128"]],["__m64"]]],[5,"_mm_cvtps_pi8","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed 8-bit integers, and returns theem in the lower 4 elements of the result.",N,[[["__m128"]],["__m64"]]],[5,"_mm_pause","","Provide a hint to the processor that the code sequence is a spin-wait loop.",N,[[]]],[5,"_mm_clflush","","Invalidate and flush the cache line that contains `p` from all levels of the cache hierarchy.",N,N],[5,"_mm_lfence","","Perform a serializing operation on all load-from-memory instructions that were issued prior to this instruction.",N,[[]]],[5,"_mm_mfence","","Perform a serializing operation on all load-from-memory and store-to-memory instructions that were issued prior to this instruction.",N,[[]]],[5,"_mm_add_epi8","","Add packed 8-bit integers in `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_add_epi16","","Add packed 16-bit integers in `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_add_epi32","","Add packed 32-bit integers in `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_add_epi64","","Add packed 64-bit integers in `a` and \"b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_adds_epi8","","Add packed 8-bit integers in `a` and `b` using saturation.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_adds_epi16","","Add packed 16-bit integers in `a` and `b` using saturation.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_adds_epu8","","Add packed unsigned 8-bit integers in `a` and `b` using saturation.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_adds_epu16","","Add packed unsigned 16-bit integers in `a` and `b` using saturation.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_avg_epu8","","Average packed unsigned 8-bit integers in `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_avg_epu16","","Average packed unsigned 16-bit integers in `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_madd_epi16","","Multiply and then horizontally add signed 16 bit integers in `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_max_epi16","","Compare packed 16-bit integers in `a` and `b`, and return the packed maximum values.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_max_epu8","","Compare packed unsigned 8-bit integers in `a` and `b`, and return the packed maximum values.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_min_epi16","","Compare packed 16-bit integers in `a` and `b`, and return the packed minimum values.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_min_epu8","","Compare packed unsigned 8-bit integers in `a` and `b`, and return the packed minimum values.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_mulhi_epi16","","Multiply the packed 16-bit integers in `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_mulhi_epu16","","Multiply the packed unsigned 16-bit integers in `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_mullo_epi16","","Multiply the packed 16-bit integers in `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_mul_epu32","","Multiply the low unsigned 32-bit integers from each packed 64-bit element in `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_sad_epu8","","Sum the absolute differences of packed unsigned 8-bit integers.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_sub_epi8","","Subtract packed 8-bit integers in `b` from packed 8-bit integers in `a`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_sub_epi16","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_sub_epi32","","Subtract packed 32-bit integers in `b` from packed 32-bit integers in `a`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_sub_epi64","","Subtract packed 64-bit integers in `b` from packed 64-bit integers in `a`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_subs_epi8","","Subtract packed 8-bit integers in `b` from packed 8-bit integers in `a` using saturation.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_subs_epi16","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a` using saturation.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_subs_epu8","","Subtract packed unsigned 8-bit integers in `b` from packed unsigned 8-bit integers in `a` using saturation.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_subs_epu16","","Subtract packed unsigned 16-bit integers in `b` from packed unsigned 16-bit integers in `a` using saturation.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_slli_si128","","Shift `a` left by `imm8` bytes while shifting in zeros.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_bslli_si128","","Shift `a` left by `imm8` bytes while shifting in zeros.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_bsrli_si128","","Shift `a` right by `imm8` bytes while shifting in zeros.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_slli_epi16","","Shift packed 16-bit integers in `a` left by `imm8` while shifting in zeros.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_sll_epi16","","Shift packed 16-bit integers in `a` left by `count` while shifting in zeros.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_slli_epi32","","Shift packed 32-bit integers in `a` left by `imm8` while shifting in zeros.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_sll_epi32","","Shift packed 32-bit integers in `a` left by `count` while shifting in zeros.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_slli_epi64","","Shift packed 64-bit integers in `a` left by `imm8` while shifting in zeros.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_sll_epi64","","Shift packed 64-bit integers in `a` left by `count` while shifting in zeros.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_srai_epi16","","Shift packed 16-bit integers in `a` right by `imm8` while shifting in sign bits.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_sra_epi16","","Shift packed 16-bit integers in `a` right by `count` while shifting in sign bits.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_srai_epi32","","Shift packed 32-bit integers in `a` right by `imm8` while shifting in sign bits.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_sra_epi32","","Shift packed 32-bit integers in `a` right by `count` while shifting in sign bits.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_srli_si128","","Shift `a` right by `imm8` bytes while shifting in zeros.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_srli_epi16","","Shift packed 16-bit integers in `a` right by `imm8` while shifting in zeros.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_srl_epi16","","Shift packed 16-bit integers in `a` right by `count` while shifting in zeros.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_srli_epi32","","Shift packed 32-bit integers in `a` right by `imm8` while shifting in zeros.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_srl_epi32","","Shift packed 32-bit integers in `a` right by `count` while shifting in zeros.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_srli_epi64","","Shift packed 64-bit integers in `a` right by `imm8` while shifting in zeros.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_srl_epi64","","Shift packed 64-bit integers in `a` right by `count` while shifting in zeros.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_and_si128","","Compute the bitwise AND of 128 bits (representing integer data) in `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_andnot_si128","","Compute the bitwise NOT of 128 bits (representing integer data) in `a` and then AND with `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_or_si128","","Compute the bitwise OR of 128 bits (representing integer data) in `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_xor_si128","","Compute the bitwise XOR of 128 bits (representing integer data) in `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_cmpeq_epi8","","Compare packed 8-bit integers in `a` and `b` for equality.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_cmpeq_epi16","","Compare packed 16-bit integers in `a` and `b` for equality.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_cmpeq_epi32","","Compare packed 32-bit integers in `a` and `b` for equality.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_cmpgt_epi8","","Compare packed 8-bit integers in `a` and `b` for greater-than.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_cmpgt_epi16","","Compare packed 16-bit integers in `a` and `b` for greater-than.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_cmpgt_epi32","","Compare packed 32-bit integers in `a` and `b` for greater-than.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_cmplt_epi8","","Compare packed 8-bit integers in `a` and `b` for less-than.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_cmplt_epi16","","Compare packed 16-bit integers in `a` and `b` for less-than.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_cmplt_epi32","","Compare packed 32-bit integers in `a` and `b` for less-than.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_cvtepi32_pd","","Convert the lower two packed 32-bit integers in `a` to packed double-precision (64-bit) floating-point elements.",N,[[["__m128i"]],["__m128d"]]],[5,"_mm_cvtsi32_sd","","Return `a` with its lower element replaced by `b` after converting it to an `f64`.",N,[[["__m128d"],["i32"]],["__m128d"]]],[5,"_mm_cvtepi32_ps","","Convert packed 32-bit integers in `a` to packed single-precision (32-bit) floating-point elements.",N,[[["__m128i"]],["__m128"]]],[5,"_mm_cvtps_epi32","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers.",N,[[["__m128"]],["__m128i"]]],[5,"_mm_cvtsi32_si128","","Return a vector whose lowest element is `a` and all higher elements are `0`.",N,[[["i32"]],["__m128i"]]],[5,"_mm_cvtsi128_si32","","Return the lowest element of `a`.",N,[[["__m128i"]],["i32"]]],[5,"_mm_set_epi64x","","Set packed 64-bit integers with the supplied values, from highest to lowest.",N,[[["i64"],["i64"]],["__m128i"]]],[5,"_mm_set_epi32","","Set packed 32-bit integers with the supplied values.",N,[[["i32"],["i32"],["i32"],["i32"]],["__m128i"]]],[5,"_mm_set_epi16","","Set packed 16-bit integers with the supplied values.",N,[[["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"]],["__m128i"]]],[5,"_mm_set_epi8","","Set packed 8-bit integers with the supplied values.",N,[[["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"]],["__m128i"]]],[5,"_mm_set1_epi64x","","Broadcast 64-bit integer `a` to all elements.",N,[[["i64"]],["__m128i"]]],[5,"_mm_set1_epi32","","Broadcast 32-bit integer `a` to all elements.",N,[[["i32"]],["__m128i"]]],[5,"_mm_set1_epi16","","Broadcast 16-bit integer `a` to all elements.",N,[[["i16"]],["__m128i"]]],[5,"_mm_set1_epi8","","Broadcast 8-bit integer `a` to all elements.",N,[[["i8"]],["__m128i"]]],[5,"_mm_setr_epi32","","Set packed 32-bit integers with the supplied values in reverse order.",N,[[["i32"],["i32"],["i32"],["i32"]],["__m128i"]]],[5,"_mm_setr_epi16","","Set packed 16-bit integers with the supplied values in reverse order.",N,[[["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"]],["__m128i"]]],[5,"_mm_setr_epi8","","Set packed 8-bit integers with the supplied values in reverse order.",N,[[["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"]],["__m128i"]]],[5,"_mm_setzero_si128","","Returns a vector with all elements set to zero.",N,[[],["__m128i"]]],[5,"_mm_loadl_epi64","","Load 64-bit integer from memory into first element of returned vector.",N,N],[5,"_mm_load_si128","","Load 128-bits of integer data from memory into a new vector.",N,N],[5,"_mm_loadu_si128","","Load 128-bits of integer data from memory into a new vector.",N,N],[5,"_mm_maskmoveu_si128","","Conditionally store 8-bit integer elements from `a` into memory using `mask`.",N,N],[5,"_mm_store_si128","","Store 128-bits of integer data from `a` into memory.",N,N],[5,"_mm_storeu_si128","","Store 128-bits of integer data from `a` into memory.",N,N],[5,"_mm_storel_epi64","","Store the lower 64-bit integer `a` to a memory location.",N,N],[5,"_mm_stream_si128","","Stores a 128-bit integer vector to a 128-bit aligned memory location. To minimize caching, the data is flagged as non-temporal (unlikely to be used again soon).",N,N],[5,"_mm_stream_si32","","Stores a 32-bit integer value in the specified memory location. To minimize caching, the data is flagged as non-temporal (unlikely to be used again soon).",N,N],[5,"_mm_move_epi64","","Return a vector where the low element is extracted from `a` and its upper element is zero.",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_packs_epi16","","Convert packed 16-bit integers from `a` and `b` to packed 8-bit integers using signed saturation.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_packs_epi32","","Convert packed 32-bit integers from `a` and `b` to packed 16-bit integers using signed saturation.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_packus_epi16","","Convert packed 16-bit integers from `a` and `b` to packed 8-bit integers using unsigned saturation.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_extract_epi16","","Return the `imm8` element of `a`.",N,[[["__m128i"],["i32"]],["i32"]]],[5,"_mm_insert_epi16","","Return a new vector where the `imm8` element of `a` is replaced with `i`.",N,[[["__m128i"],["i32"],["i32"]],["__m128i"]]],[5,"_mm_movemask_epi8","","Return a mask of the most significant bit of each element in `a`.",N,[[["__m128i"]],["i32"]]],[5,"_mm_shuffle_epi32","","Shuffle 32-bit integers in `a` using the control in `imm8`.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_shufflehi_epi16","","Shuffle 16-bit integers in the high 64 bits of `a` using the control in `imm8`.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_shufflelo_epi16","","Shuffle 16-bit integers in the low 64 bits of `a` using the control in `imm8`.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_unpackhi_epi8","","Unpack and interleave 8-bit integers from the high half of `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_unpackhi_epi16","","Unpack and interleave 16-bit integers from the high half of `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_unpackhi_epi32","","Unpack and interleave 32-bit integers from the high half of `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_unpackhi_epi64","","Unpack and interleave 64-bit integers from the high half of `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_unpacklo_epi8","","Unpack and interleave 8-bit integers from the low half of `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_unpacklo_epi16","","Unpack and interleave 16-bit integers from the low half of `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_unpacklo_epi32","","Unpack and interleave 32-bit integers from the low half of `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_unpacklo_epi64","","Unpack and interleave 64-bit integers from the low half of `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_add_sd","","Return a new vector with the low element of `a` replaced by the sum of the low elements of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_add_pd","","Add packed double-precision (64-bit) floating-point elements in `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_div_sd","","Return a new vector with the low element of `a` replaced by the result of diving the lower element of `a` by the lower element of `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_div_pd","","Divide packed double-precision (64-bit) floating-point elements in `a` by packed elements in `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_max_sd","","Return a new vector with the low element of `a` replaced by the maximum of the lower elements of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_max_pd","","Return a new vector with the maximum values from corresponding elements in `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_min_sd","","Return a new vector with the low element of `a` replaced by the minimum of the lower elements of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_min_pd","","Return a new vector with the minimum values from corresponding elements in `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_mul_sd","","Return a new vector with the low element of `a` replaced by multiplying the low elements of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_mul_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_sqrt_sd","","Return a new vector with the low element of `a` replaced by the square root of the lower element `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_sqrt_pd","","Return a new vector with the square root of each of the values in `a`.",N,[[["__m128d"]],["__m128d"]]],[5,"_mm_sub_sd","","Return a new vector with the low element of `a` replaced by subtracting the low element by `b` from the low element of `a`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_sub_pd","","Subtract packed double-precision (64-bit) floating-point elements in `b` from `a`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_and_pd","","Compute the bitwise AND of packed double-precision (64-bit) floating-point elements in `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_andnot_pd","","Compute the bitwise NOT of `a` and then AND with `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_or_pd","","Compute the bitwise OR of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_xor_pd","","Compute the bitwise OR of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpeq_sd","","Return a new vector with the low element of `a` replaced by the equality comparison of the lower elements of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmplt_sd","","Return a new vector with the low element of `a` replaced by the less-than comparison of the lower elements of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmple_sd","","Return a new vector with the low element of `a` replaced by the less-than-or-equal comparison of the lower elements of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpgt_sd","","Return a new vector with the low element of `a` replaced by the greater-than comparison of the lower elements of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpge_sd","","Return a new vector with the low element of `a` replaced by the greater-than-or-equal comparison of the lower elements of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpord_sd","","Return a new vector with the low element of `a` replaced by the result of comparing both of the lower elements of `a` and `b` to `NaN`. If neither are equal to `NaN` then `0xFFFFFFFFFFFFFFFF` is used and `0` otherwise.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpunord_sd","","Return a new vector with the low element of `a` replaced by the result of comparing both of the lower elements of `a` and `b` to `NaN`. If either is equal to `NaN` then `0xFFFFFFFFFFFFFFFF` is used and `0` otherwise.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpneq_sd","","Return a new vector with the low element of `a` replaced by the not-equal comparison of the lower elements of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpnlt_sd","","Return a new vector with the low element of `a` replaced by the not-less-than comparison of the lower elements of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpnle_sd","","Return a new vector with the low element of `a` replaced by the not-less-than-or-equal comparison of the lower elements of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpngt_sd","","Return a new vector with the low element of `a` replaced by the not-greater-than comparison of the lower elements of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpnge_sd","","Return a new vector with the low element of `a` replaced by the not-greater-than-or-equal comparison of the lower elements of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpeq_pd","","Compare corresponding elements in `a` and `b` for equality.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmplt_pd","","Compare corresponding elements in `a` and `b` for less-than.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmple_pd","","Compare corresponding elements in `a` and `b` for less-than-or-equal",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpgt_pd","","Compare corresponding elements in `a` and `b` for greater-than.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpge_pd","","Compare corresponding elements in `a` and `b` for greater-than-or-equal.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpord_pd","","Compare corresponding elements in `a` and `b` to see if neither is `NaN`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpunord_pd","","Compare corresponding elements in `a` and `b` to see if either is `NaN`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpneq_pd","","Compare corresponding elements in `a` and `b` for not-equal.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpnlt_pd","","Compare corresponding elements in `a` and `b` for not-less-than.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpnle_pd","","Compare corresponding elements in `a` and `b` for not-less-than-or-equal.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpngt_pd","","Compare corresponding elements in `a` and `b` for not-greater-than.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpnge_pd","","Compare corresponding elements in `a` and `b` for not-greater-than-or-equal.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_comieq_sd","","Compare the lower element of `a` and `b` for equality.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm_comilt_sd","","Compare the lower element of `a` and `b` for less-than.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm_comile_sd","","Compare the lower element of `a` and `b` for less-than-or-equal.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm_comigt_sd","","Compare the lower element of `a` and `b` for greater-than.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm_comige_sd","","Compare the lower element of `a` and `b` for greater-than-or-equal.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm_comineq_sd","","Compare the lower element of `a` and `b` for not-equal.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm_ucomieq_sd","","Compare the lower element of `a` and `b` for equality.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm_ucomilt_sd","","Compare the lower element of `a` and `b` for less-than.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm_ucomile_sd","","Compare the lower element of `a` and `b` for less-than-or-equal.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm_ucomigt_sd","","Compare the lower element of `a` and `b` for greater-than.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm_ucomige_sd","","Compare the lower element of `a` and `b` for greater-than-or-equal.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm_ucomineq_sd","","Compare the lower element of `a` and `b` for not-equal.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm_cvtpd_ps","","Convert packed double-precision (64-bit) floating-point elements in \"a\" to packed single-precision (32-bit) floating-point elements",N,[[["__m128d"]],["__m128"]]],[5,"_mm_cvtps_pd","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed double-precision (64-bit) floating-point elements.",N,[[["__m128"]],["__m128d"]]],[5,"_mm_cvtpd_epi32","","Convert packed double-precision (64-bit) floating-point elements in `a` to packed 32-bit integers.",N,[[["__m128d"]],["__m128i"]]],[5,"_mm_cvtsd_si32","","Convert the lower double-precision (64-bit) floating-point element in a to a 32-bit integer.",N,[[["__m128d"]],["i32"]]],[5,"_mm_cvtsd_ss","","Convert the lower double-precision (64-bit) floating-point element in `b` to a single-precision (32-bit) floating-point element, store the result in the lower element of the return value, and copy the upper element from `a` to the upper element the return value.",N,[[["__m128"],["__m128d"]],["__m128"]]],[5,"_mm_cvtsd_f64","","Return the lower double-precision (64-bit) floating-point element of \"a\".",N,[[["__m128d"]],["f64"]]],[5,"_mm_cvtss_sd","","Convert the lower single-precision (32-bit) floating-point element in `b` to a double-precision (64-bit) floating-point element, store the result in the lower element of the return value, and copy the upper element from `a` to the upper element the return value.",N,[[["__m128d"],["__m128"]],["__m128d"]]],[5,"_mm_cvttpd_epi32","","Convert packed double-precision (64-bit) floating-point elements in `a` to packed 32-bit integers with truncation.",N,[[["__m128d"]],["__m128i"]]],[5,"_mm_cvttsd_si32","","Convert the lower double-precision (64-bit) floating-point element in `a` to a 32-bit integer with truncation.",N,[[["__m128d"]],["i32"]]],[5,"_mm_cvttps_epi32","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers with truncation.",N,[[["__m128"]],["__m128i"]]],[5,"_mm_set_sd","","Copy double-precision (64-bit) floating-point element `a` to the lower element of the packed 64-bit return value.",N,[[["f64"]],["__m128d"]]],[5,"_mm_set1_pd","","Broadcast double-precision (64-bit) floating-point value a to all elements of the return value.",N,[[["f64"]],["__m128d"]]],[5,"_mm_set_pd1","","Broadcast double-precision (64-bit) floating-point value a to all elements of the return value.",N,[[["f64"]],["__m128d"]]],[5,"_mm_set_pd","","Set packed double-precision (64-bit) floating-point elements in the return value with the supplied values.",N,[[["f64"],["f64"]],["__m128d"]]],[5,"_mm_setr_pd","","Set packed double-precision (64-bit) floating-point elements in the return value with the supplied values in reverse order.",N,[[["f64"],["f64"]],["__m128d"]]],[5,"_mm_setzero_pd","","Returns packed double-precision (64-bit) floating-point elements with all zeros.",N,[[],["__m128d"]]],[5,"_mm_movemask_pd","","Return a mask of the most significant bit of each element in `a`.",N,[[["__m128d"]],["i32"]]],[5,"_mm_load_pd","","Load 128-bits (composed of 2 packed double-precision (64-bit) floating-point elements) from memory into the returned vector. `mem_addr` must be aligned on a 16-byte boundary or a general-protection exception may be generated.",N,N],[5,"_mm_load_sd","","Loads a 64-bit double-precision value to the low element of a 128-bit integer vector and clears the upper element.",N,N],[5,"_mm_loadh_pd","","Loads a double-precision value into the high-order bits of a 128-bit vector of `[2 x double]`. The low-order bits are copied from the low-order bits of the first operand.",N,N],[5,"_mm_loadl_pd","","Loads a double-precision value into the low-order bits of a 128-bit vector of `[2 x double]`. The high-order bits are copied from the high-order bits of the first operand.",N,N],[5,"_mm_stream_pd","","Stores a 128-bit floating point vector of `[2 x double]` to a 128-bit aligned memory location. To minimize caching, the data is flagged as non-temporal (unlikely to be used again soon).",N,N],[5,"_mm_store_sd","","Stores the lower 64 bits of a 128-bit vector of `[2 x double]` to a memory location.",N,N],[5,"_mm_store_pd","","Store 128-bits (composed of 2 packed double-precision (64-bit) floating-point elements) from `a` into memory. `mem_addr` must be aligned on a 16-byte boundary or a general-protection exception may be generated.",N,N],[5,"_mm_storeu_pd","","Store 128-bits (composed of 2 packed double-precision (64-bit) floating-point elements) from `a` into memory. `mem_addr` does not need to be aligned on any particular boundary.",N,N],[5,"_mm_store1_pd","","Store the lower double-precision (64-bit) floating-point element from `a` into 2 contiguous elements in memory. `mem_addr` must be aligned on a 16-byte boundary or a general-protection exception may be generated.",N,N],[5,"_mm_store_pd1","","Store the lower double-precision (64-bit) floating-point element from `a` into 2 contiguous elements in memory. `mem_addr` must be aligned on a 16-byte boundary or a general-protection exception may be generated.",N,N],[5,"_mm_storer_pd","","Store 2 double-precision (64-bit) floating-point elements from `a` into memory in reverse order. `mem_addr` must be aligned on a 16-byte boundary or a general-protection exception may be generated.",N,N],[5,"_mm_storeh_pd","","Stores the upper 64 bits of a 128-bit vector of `[2 x double]` to a memory location.",N,N],[5,"_mm_storel_pd","","Stores the lower 64 bits of a 128-bit vector of `[2 x double]` to a memory location.",N,N],[5,"_mm_load1_pd","","Load a double-precision (64-bit) floating-point element from memory into both elements of returned vector.",N,N],[5,"_mm_load_pd1","","Load a double-precision (64-bit) floating-point element from memory into both elements of returned vector.",N,N],[5,"_mm_loadr_pd","","Load 2 double-precision (64-bit) floating-point elements from memory into the returned vector in reverse order. `mem_addr` must be aligned on a 16-byte boundary or a general-protection exception may be generated.",N,N],[5,"_mm_loadu_pd","","Load 128-bits (composed of 2 packed double-precision (64-bit) floating-point elements) from memory into the returned vector. `mem_addr` does not need to be aligned on any particular boundary.",N,N],[5,"_mm_shuffle_pd","","Constructs a 128-bit floating-point vector of `[2 x double]` from two 128-bit vector parameters of `[2 x double]`, using the immediate-value parameter as a specifier.",N,[[["__m128d"],["__m128d"],["i32"]],["__m128d"]]],[5,"_mm_move_sd","","Constructs a 128-bit floating-point vector of `[2 x double]`. The lower 64 bits are set to the lower 64 bits of the second parameter. The upper 64 bits are set to the upper 64 bits of the first parameter.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_castpd_ps","","Casts a 128-bit floating-point vector of `[2 x double]` into a 128-bit floating-point vector of `[4 x float]`.",N,[[["__m128d"]],["__m128"]]],[5,"_mm_castpd_si128","","Casts a 128-bit floating-point vector of `[2 x double]` into a 128-bit integer vector.",N,[[["__m128d"]],["__m128i"]]],[5,"_mm_castps_pd","","Casts a 128-bit floating-point vector of `[4 x float]` into a 128-bit floating-point vector of `[2 x double]`.",N,[[["__m128"]],["__m128d"]]],[5,"_mm_castps_si128","","Casts a 128-bit floating-point vector of `[4 x float]` into a 128-bit integer vector.",N,[[["__m128"]],["__m128i"]]],[5,"_mm_castsi128_pd","","Casts a 128-bit integer vector into a 128-bit floating-point vector of `[2 x double]`.",N,[[["__m128i"]],["__m128d"]]],[5,"_mm_castsi128_ps","","Casts a 128-bit integer vector into a 128-bit floating-point vector of `[4 x float]`.",N,[[["__m128i"]],["__m128"]]],[5,"_mm_undefined_pd","","Return vector of type __m128d with undefined elements.",N,[[],["__m128d"]]],[5,"_mm_undefined_si128","","Return vector of type __m128i with undefined elements.",N,[[],["__m128i"]]],[5,"_mm_unpackhi_pd","","The resulting `__m128d` element is composed by the low-order values of the two `__m128d` interleaved input elements, i.e.:",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_unpacklo_pd","","The resulting `__m128d` element is composed by the high-order values of the two `__m128d` interleaved input elements, i.e.:",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_add_si64","","Adds two signed or unsigned 64-bit integer values, returning the lower 64 bits of the sum.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_mul_su32","","Multiplies 32-bit unsigned integer values contained in the lower bits of the two 64-bit integer vectors and returns the 64-bit unsigned product.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_sub_si64","","Subtracts signed or unsigned 64-bit integer values and writes the difference to the corresponding bits in the destination.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_cvtpi32_pd","","Converts the two signed 32-bit integer elements of a 64-bit vector of `[2 x i32]` into two double-precision floating-point values, returned in a 128-bit vector of `[2 x double]`.",N,[[["__m64"]],["__m128d"]]],[5,"_mm_set_epi64","","Initializes both 64-bit values in a 128-bit vector of `[2 x i64]` with the specified 64-bit integer values.",N,[[["__m64"],["__m64"]],["__m128i"]]],[5,"_mm_set1_epi64","","Initializes both values in a 128-bit vector of `[2 x i64]` with the specified 64-bit value.",N,[[["__m64"]],["__m128i"]]],[5,"_mm_setr_epi64","","Constructs a 128-bit integer vector, initialized in reverse order with the specified 64-bit integral values.",N,[[["__m64"],["__m64"]],["__m128i"]]],[5,"_mm_movepi64_pi64","","Returns the lower 64 bits of a 128-bit integer vector as a 64-bit integer.",N,[[["__m128i"]],["__m64"]]],[5,"_mm_movpi64_epi64","","Moves the 64-bit operand to a 128-bit integer vector, zeroing the upper bits.",N,[[["__m64"]],["__m128i"]]],[5,"_mm_cvtpd_pi32","","Converts the two double-precision floating-point elements of a 128-bit vector of `[2 x double]` into two signed 32-bit integer values, returned in a 64-bit vector of `[2 x i32]`.",N,[[["__m128d"]],["__m64"]]],[5,"_mm_cvttpd_pi32","","Converts the two double-precision floating-point elements of a 128-bit vector of `[2 x double]` into two signed 32-bit integer values, returned in a 64-bit vector of `[2 x i32]`. If the result of either conversion is inexact, the result is truncated (rounded towards zero) regardless of the current MXCSR setting.",N,[[["__m128d"]],["__m64"]]],[5,"_mm_addsub_ps","","Alternatively add and subtract packed single-precision (32-bit) floating-point elements in `a` to/from packed elements in `b`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_addsub_pd","","Alternatively add and subtract packed double-precision (64-bit) floating-point elements in `a` to/from packed elements in `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_hadd_pd","","Horizontally add adjacent pairs of double-precision (64-bit) floating-point elements in `a` and `b`, and pack the results.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_hadd_ps","","Horizontally add adjacent pairs of single-precision (32-bit) floating-point elements in `a` and `b`, and pack the results.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_hsub_pd","","Horizontally subtract adjacent pairs of double-precision (64-bit) floating-point elements in `a` and `b`, and pack the results.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_hsub_ps","","Horizontally add adjacent pairs of single-precision (32-bit) floating-point elements in `a` and `b`, and pack the results.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_lddqu_si128","","Load 128-bits of integer data from unaligned memory. This intrinsic may perform better than `_mm_loadu_si128` when the data crosses a cache line boundary.",N,N],[5,"_mm_movedup_pd","","Duplicate the low double-precision (64-bit) floating-point element from `a`.",N,[[["__m128d"]],["__m128d"]]],[5,"_mm_loaddup_pd","","Load a double-precision (64-bit) floating-point element from memory into both elements of return vector.",N,N],[5,"_mm_movehdup_ps","","Duplicate odd-indexed single-precision (32-bit) floating-point elements from `a`.",N,[[["__m128"]],["__m128"]]],[5,"_mm_moveldup_ps","","Duplicate even-indexed single-precision (32-bit) floating-point elements from `a`.",N,[[["__m128"]],["__m128"]]],[5,"_mm_abs_epi8","","Compute the absolute value of packed 8-bit signed integers in `a` and return the unsigned results.",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_abs_epi16","","Compute the absolute value of each of the packed 16-bit signed integers in `a` and return the 16-bit unsigned integer",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_abs_epi32","","Compute the absolute value of each of the packed 32-bit signed integers in `a` and return the 32-bit unsigned integer",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_shuffle_epi8","","Shuffle bytes from `a` according to the content of `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_alignr_epi8","","Concatenate 16-byte blocks in `a` and `b` into a 32-byte temporary result, shift the result right by `n` bytes, and return the low 16 bytes.",N,[[["__m128i"],["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_hadd_epi16","","Horizontally add the adjacent pairs of values contained in 2 packed 128-bit vectors of `[8 x i16]`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_hadds_epi16","","Horizontally add the adjacent pairs of values contained in 2 packed 128-bit vectors of `[8 x i16]`. Positive sums greater than 7FFFh are saturated to 7FFFh. Negative sums less than 8000h are saturated to 8000h.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_hadd_epi32","","Horizontally add the adjacent pairs of values contained in 2 packed 128-bit vectors of `[4 x i32]`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_hsub_epi16","","Horizontally subtract the adjacent pairs of values contained in 2 packed 128-bit vectors of `[8 x i16]`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_hsubs_epi16","","Horizontally subtract the adjacent pairs of values contained in 2 packed 128-bit vectors of `[8 x i16]`. Positive differences greater than 7FFFh are saturated to 7FFFh. Negative differences less than 8000h are saturated to 8000h.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_hsub_epi32","","Horizontally subtract the adjacent pairs of values contained in 2 packed 128-bit vectors of `[4 x i32]`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_maddubs_epi16","","Multiply corresponding pairs of packed 8-bit unsigned integer values contained in the first source operand and packed 8-bit signed integer values contained in the second source operand, add pairs of contiguous products with signed saturation, and writes the 16-bit sums to the corresponding bits in the destination.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_mulhrs_epi16","","Multiply packed 16-bit signed integer values, truncate the 32-bit product to the 18 most significant bits by right-shifting, round the truncated value by adding 1, and write bits `[16:1]` to the destination.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_sign_epi8","","Negate packed 8-bit integers in `a` when the corresponding signed 8-bit integer in `b` is negative, and return the result. Elements in result are zeroed out when the corresponding element in `b` is zero.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_sign_epi16","","Negate packed 16-bit integers in `a` when the corresponding signed 16-bit integer in `b` is negative, and return the results. Elements in result are zeroed out when the corresponding element in `b` is zero.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_sign_epi32","","Negate packed 32-bit integers in `a` when the corresponding signed 32-bit integer in `b` is negative, and return the results. Element in result are zeroed out when the corresponding element in `b` is zero.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_abs_pi8","","Compute the absolute value of packed 8-bit integers in `a` and return the unsigned results.",N,[[["__m64"]],["__m64"]]],[5,"_mm_abs_pi16","","Compute the absolute value of packed 8-bit integers in `a`, and return the unsigned results.",N,[[["__m64"]],["__m64"]]],[5,"_mm_abs_pi32","","Compute the absolute value of packed 32-bit integers in `a`, and return the unsigned results.",N,[[["__m64"]],["__m64"]]],[5,"_mm_shuffle_pi8","","Shuffle packed 8-bit integers in `a` according to shuffle control mask in the corresponding 8-bit element of `b`, and return the results",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_alignr_pi8","","Concatenates the two 64-bit integer vector operands, and right-shifts the result by the number of bytes specified in the immediate operand.",N,[[["__m64"],["__m64"],["i32"]],["__m64"]]],[5,"_mm_hadd_pi16","","Horizontally add the adjacent pairs of values contained in 2 packed 64-bit vectors of `[4 x i16]`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_hadd_pi32","","Horizontally add the adjacent pairs of values contained in 2 packed 64-bit vectors of `[2 x i32]`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_hadds_pi16","","Horizontally add the adjacent pairs of values contained in 2 packed 64-bit vectors of `[4 x i16]`. Positive sums greater than 7FFFh are saturated to 7FFFh. Negative sums less than 8000h are saturated to 8000h.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_hsub_pi16","","Horizontally subtracts the adjacent pairs of values contained in 2 packed 64-bit vectors of `[4 x i16]`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_hsub_pi32","","Horizontally subtracts the adjacent pairs of values contained in 2 packed 64-bit vectors of `[2 x i32]`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_hsubs_pi16","","Horizontally subtracts the adjacent pairs of values contained in 2 packed 64-bit vectors of `[4 x i16]`. Positive differences greater than 7FFFh are saturated to 7FFFh. Negative differences less than 8000h are saturated to 8000h.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_maddubs_pi16","","Multiplies corresponding pairs of packed 8-bit unsigned integer values contained in the first source operand and packed 8-bit signed integer values contained in the second source operand, adds pairs of contiguous products with signed saturation, and writes the 16-bit sums to the corresponding bits in the destination.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_mulhrs_pi16","","Multiplies packed 16-bit signed integer values, truncates the 32-bit products to the 18 most significant bits by right-shifting, rounds the truncated value by adding 1, and writes bits `[16:1]` to the destination.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_sign_pi8","","Negate packed 8-bit integers in `a` when the corresponding signed 8-bit integer in `b` is negative, and return the results. Element in result are zeroed out when the corresponding element in `b` is zero.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_sign_pi16","","Negate packed 16-bit integers in `a` when the corresponding signed 16-bit integer in `b` is negative, and return the results. Element in result are zeroed out when the corresponding element in `b` is zero.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_sign_pi32","","Negate packed 32-bit integers in `a` when the corresponding signed 32-bit integer in `b` is negative, and return the results. Element in result are zeroed out when the corresponding element in `b` is zero.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_blendv_epi8","","Blend packed 8-bit integers from `a` and `b` using `mask`",N,[[["__m128i"],["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_blend_epi16","","Blend packed 16-bit integers from `a` and `b` using the mask `imm8`.",N,[[["__m128i"],["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_blendv_pd","","Blend packed double-precision (64-bit) floating-point elements from `a` and `b` using `mask`",N,[[["__m128d"],["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_blendv_ps","","Blend packed single-precision (32-bit) floating-point elements from `a` and `b` using `mask`",N,[[["__m128"],["__m128"],["__m128"]],["__m128"]]],[5,"_mm_blend_pd","","Blend packed double-precision (64-bit) floating-point elements from `a` and `b` using control mask `imm2`",N,[[["__m128d"],["__m128d"],["i32"]],["__m128d"]]],[5,"_mm_blend_ps","","Blend packed single-precision (32-bit) floating-point elements from `a` and `b` using mask `imm4`",N,[[["__m128"],["__m128"],["i32"]],["__m128"]]],[5,"_mm_extract_ps","","Extract a single-precision (32-bit) floating-point element from `a`, selected with `imm8`",N,[[["__m128"],["i32"]],["i32"]]],[5,"_mm_extract_epi8","","Extract an 8-bit integer from `a`, selected with `imm8`. Returns a 32-bit integer containing the zero-extended integer data.",N,[[["__m128i"],["i32"]],["i32"]]],[5,"_mm_extract_epi32","","Extract an 32-bit integer from `a` selected with `imm8`",N,[[["__m128i"],["i32"]],["i32"]]],[5,"_mm_insert_ps","","Select a single value in `a` to store at some position in `b`, Then zero elements according to `imm8`.",N,[[["__m128"],["__m128"],["i32"]],["__m128"]]],[5,"_mm_insert_epi8","","Return a copy of `a` with the 8-bit integer from `i` inserted at a location specified by `imm8`.",N,[[["__m128i"],["i32"],["i32"]],["__m128i"]]],[5,"_mm_insert_epi32","","Return a copy of `a` with the 32-bit integer from `i` inserted at a location specified by `imm8`.",N,[[["__m128i"],["i32"],["i32"]],["__m128i"]]],[5,"_mm_max_epi8","","Compare packed 8-bit integers in `a` and `b` and return packed maximum values in dst.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_max_epu16","","Compare packed unsigned 16-bit integers in `a` and `b`, and return packed maximum.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_max_epi32","","Compare packed 32-bit integers in `a` and `b`, and return packed maximum values.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_max_epu32","","Compare packed unsigned 32-bit integers in `a` and `b`, and return packed maximum values.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_min_epi8","","Compare packed 8-bit integers in `a` and `b` and return packed minimum values in dst.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_min_epu16","","Compare packed unsigned 16-bit integers in `a` and `b`, and return packed minimum.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_min_epi32","","Compare packed 32-bit integers in `a` and `b`, and return packed minimum values.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_min_epu32","","Compare packed unsigned 32-bit integers in `a` and `b`, and return packed minimum values.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_packus_epi32","","Convert packed 32-bit integers from `a` and `b` to packed 16-bit integers using unsigned saturation",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_cmpeq_epi64","","Compare packed 64-bit integers in `a` and `b` for equality",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_cvtepi8_epi16","","Sign extend packed 8-bit integers in `a` to packed 16-bit integers",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepi8_epi32","","Sign extend packed 8-bit integers in `a` to packed 32-bit integers",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepi8_epi64","","Sign extend packed 8-bit integers in the low 8 bytes of `a` to packed 64-bit integers",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepi16_epi32","","Sign extend packed 16-bit integers in `a` to packed 32-bit integers",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepi16_epi64","","Sign extend packed 16-bit integers in `a` to packed 64-bit integers",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepi32_epi64","","Sign extend packed 32-bit integers in `a` to packed 64-bit integers",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepu8_epi16","","Zero extend packed unsigned 8-bit integers in `a` to packed 16-bit integers",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepu8_epi32","","Zero extend packed unsigned 8-bit integers in `a` to packed 32-bit integers",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepu8_epi64","","Zero extend packed unsigned 8-bit integers in `a` to packed 64-bit integers",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepu16_epi32","","Zero extend packed unsigned 16-bit integers in `a` to packed 32-bit integers",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepu16_epi64","","Zero extend packed unsigned 16-bit integers in `a` to packed 64-bit integers",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepu32_epi64","","Zero extend packed unsigned 32-bit integers in `a` to packed 64-bit integers",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_dp_pd","","Returns the dot product of two __m128d vectors.",N,[[["__m128d"],["__m128d"],["i32"]],["__m128d"]]],[5,"_mm_dp_ps","","Returns the dot product of two __m128 vectors.",N,[[["__m128"],["__m128"],["i32"]],["__m128"]]],[5,"_mm_floor_pd","","Round the packed double-precision (64-bit) floating-point elements in `a` down to an integer value, and store the results as packed double-precision floating-point elements.",N,[[["__m128d"]],["__m128d"]]],[5,"_mm_floor_ps","","Round the packed single-precision (32-bit) floating-point elements in `a` down to an integer value, and store the results as packed single-precision floating-point elements.",N,[[["__m128"]],["__m128"]]],[5,"_mm_floor_sd","","Round the lower double-precision (64-bit) floating-point element in `b` down to an integer value, store the result as a double-precision floating-point element in the lower element of the intrinsic result, and copy the upper element from `a` to the upper element of the intrinsic result.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_floor_ss","","Round the lower single-precision (32-bit) floating-point element in `b` down to an integer value, store the result as a single-precision floating-point element in the lower element of the intrinsic result, and copy the upper 3 packed elements from `a` to the upper elements of the intrinsic result.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_ceil_pd","","Round the packed double-precision (64-bit) floating-point elements in `a` up to an integer value, and store the results as packed double-precision floating-point elements.",N,[[["__m128d"]],["__m128d"]]],[5,"_mm_ceil_ps","","Round the packed single-precision (32-bit) floating-point elements in `a` up to an integer value, and store the results as packed single-precision floating-point elements.",N,[[["__m128"]],["__m128"]]],[5,"_mm_ceil_sd","","Round the lower double-precision (64-bit) floating-point element in `b` up to an integer value, store the result as a double-precision floating-point element in the lower element of the intrisic result, and copy the upper element from `a` to the upper element of the intrinsic result.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_ceil_ss","","Round the lower single-precision (32-bit) floating-point element in `b` up to an integer value, store the result as a single-precision floating-point element in the lower element of the intrinsic result, and copy the upper 3 packed elements from `a` to the upper elements of the intrinsic result.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_round_pd","","Round the packed double-precision (64-bit) floating-point elements in `a` using the `rounding` parameter, and store the results as packed double-precision floating-point elements. Rounding is done according to the rounding parameter, which can be one of:",N,[[["__m128d"],["i32"]],["__m128d"]]],[5,"_mm_round_ps","","Round the packed single-precision (32-bit) floating-point elements in `a` using the `rounding` parameter, and store the results as packed single-precision floating-point elements. Rounding is done according to the rounding parameter, which can be one of:",N,[[["__m128"],["i32"]],["__m128"]]],[5,"_mm_round_sd","","Round the lower double-precision (64-bit) floating-point element in `b` using the `rounding` parameter, store the result as a double-precision floating-point element in the lower element of the intrinsic result, and copy the upper element from `a` to the upper element of the intrinsic result. Rounding is done according to the rounding parameter, which can be one of:",N,[[["__m128d"],["__m128d"],["i32"]],["__m128d"]]],[5,"_mm_round_ss","","Round the lower single-precision (32-bit) floating-point element in `b` using the `rounding` parameter, store the result as a single-precision floating-point element in the lower element of the intrinsic result, and copy the upper 3 packed elements from `a` to the upper elements of the instrinsic result. Rounding is done according to the rounding parameter, which can be one of:",N,[[["__m128"],["__m128"],["i32"]],["__m128"]]],[5,"_mm_minpos_epu16","","Finds the minimum unsigned 16-bit element in the 128-bit __m128i vector, returning a vector containing its value in its first position, and its index in its second position; all other elements are set to zero.",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_mul_epi32","","Multiply the low 32-bit integers from each packed 64-bit element in `a` and `b`, and return the signed 64-bit result.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_mullo_epi32","","Multiply the packed 32-bit integers in `a` and `b`, producing intermediate 64-bit integers, and returns the lowest 32-bit, whatever they might be, reinterpreted as a signed integer. While `pmulld __m128i::splat(2), __m128i::splat(2)` returns the obvious `__m128i::splat(4)`, due to wrapping arithmetic `pmulld __m128i::splat(i32::MAX), __m128i::splat(2)` would return a negative number.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_mpsadbw_epu8","","Subtracts 8-bit unsigned integer values and computes the absolute values of the differences to the corresponding bits in the destination. Then sums of the absolute differences are returned according to the bit fields in the immediate operand.",N,[[["__m128i"],["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_testz_si128","","Tests whether the specified bits in a 128-bit integer vector are all zeros.",N,[[["__m128i"],["__m128i"]],["i32"]]],[5,"_mm_testc_si128","","Tests whether the specified bits in a 128-bit integer vector are all ones.",N,[[["__m128i"],["__m128i"]],["i32"]]],[5,"_mm_testnzc_si128","","Tests whether the specified bits in a 128-bit integer vector are neither all zeros nor all ones.",N,[[["__m128i"],["__m128i"]],["i32"]]],[5,"_mm_test_all_zeros","","Tests whether the specified bits in a 128-bit integer vector are all zeros.",N,[[["__m128i"],["__m128i"]],["i32"]]],[5,"_mm_test_all_ones","","Tests whether the specified bits in `a` 128-bit integer vector are all ones.",N,[[["__m128i"]],["i32"]]],[5,"_mm_test_mix_ones_zeros","","Tests whether the specified bits in a 128-bit integer vector are neither all zeros nor all ones.",N,[[["__m128i"],["__m128i"]],["i32"]]],[5,"_mm_cmpistrm","","Compare packed strings with implicit lengths in `a` and `b` using the control in `imm8`, and return the generated mask.",N,[[["__m128i"],["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_cmpistri","","Compare packed strings with implicit lengths in `a` and `b` using the control in `imm8` and return the generated index. Similar to [`_mm_cmpestri`] with the exception that [`_mm_cmpestri`] requires the lengths of `a` and `b` to be explicitly specified.",N,[[["__m128i"],["__m128i"],["i32"]],["i32"]]],[5,"_mm_cmpistrz","","Compare packed strings with implicit lengths in `a` and `b` using the control in `imm8`, and return `1` if any character in `b` was null. and `0` otherwise.",N,[[["__m128i"],["__m128i"],["i32"]],["i32"]]],[5,"_mm_cmpistrc","","Compare packed strings with implicit lengths in `a` and `b` using the control in `imm8`, and return `1` if the resulting mask was non-zero, and `0` otherwise.",N,[[["__m128i"],["__m128i"],["i32"]],["i32"]]],[5,"_mm_cmpistrs","","Compare packed strings with implicit lengths in `a` and `b` using the control in `imm8`, and returns `1` if any character in `a` was null, and `0` otherwise.",N,[[["__m128i"],["__m128i"],["i32"]],["i32"]]],[5,"_mm_cmpistro","","Compare packed strings with implicit lengths in `a` and `b` using the control in `imm8`, and return bit `0` of the resulting bit mask.",N,[[["__m128i"],["__m128i"],["i32"]],["i32"]]],[5,"_mm_cmpistra","","Compare packed strings with implicit lengths in `a` and `b` using the control in `imm8`, and return `1` if `b` did not contain a null character and the resulting mask was zero, and `0` otherwise.",N,[[["__m128i"],["__m128i"],["i32"]],["i32"]]],[5,"_mm_cmpestrm","","Compare packed strings in `a` and `b` with lengths `la` and `lb` using the control in `imm8`, and return the generated mask.",N,[[["__m128i"],["i32"],["__m128i"],["i32"],["i32"]],["__m128i"]]],[5,"_mm_cmpestri","","Compare packed strings `a` and `b` with lengths `la` and `lb` using the control in `imm8` and return the generated index. Similar to [`_mm_cmpistri`] with the exception that [`_mm_cmpistri`] implicitly determines the length of `a` and `b`.",N,[[["__m128i"],["i32"],["__m128i"],["i32"],["i32"]],["i32"]]],[5,"_mm_cmpestrz","","Compare packed strings in `a` and `b` with lengths `la` and `lb` using the control in `imm8`, and return `1` if any character in `b` was null, and `0` otherwise.",N,[[["__m128i"],["i32"],["__m128i"],["i32"],["i32"]],["i32"]]],[5,"_mm_cmpestrc","","Compare packed strings in `a` and `b` with lengths `la` and `lb` using the control in `imm8`, and return `1` if the resulting mask was non-zero, and `0` otherwise.",N,[[["__m128i"],["i32"],["__m128i"],["i32"],["i32"]],["i32"]]],[5,"_mm_cmpestrs","","Compare packed strings in `a` and `b` with lengths `la` and `lb` using the control in `imm8`, and return `1` if any character in a was null, and `0` otherwise.",N,[[["__m128i"],["i32"],["__m128i"],["i32"],["i32"]],["i32"]]],[5,"_mm_cmpestro","","Compare packed strings in `a` and `b` with lengths `la` and `lb` using the control in `imm8`, and return bit `0` of the resulting bit mask.",N,[[["__m128i"],["i32"],["__m128i"],["i32"],["i32"]],["i32"]]],[5,"_mm_cmpestra","","Compare packed strings in `a` and `b` with lengths `la` and `lb` using the control in `imm8`, and return `1` if `b` did not contain a null character and the resulting mask was zero, and `0` otherwise.",N,[[["__m128i"],["i32"],["__m128i"],["i32"],["i32"]],["i32"]]],[5,"_mm_crc32_u8","","Starting with the initial value in `crc`, return the accumulated CRC32 value for unsigned 8-bit integer `v`.",N,[[["u32"],["u8"]],["u32"]]],[5,"_mm_crc32_u16","","Starting with the initial value in `crc`, return the accumulated CRC32 value for unsigned 16-bit integer `v`.",N,[[["u32"],["u16"]],["u32"]]],[5,"_mm_crc32_u32","","Starting with the initial value in `crc`, return the accumulated CRC32 value for unsigned 32-bit integer `v`.",N,[[["u32"],["u32"]],["u32"]]],[5,"_mm_cmpgt_epi64","","Compare packed 64-bit integers in `a` and `b` for greater-than, return the results.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm256_add_pd","","Add packed double-precision (64-bit) floating-point elements in `a` and `b`.",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_add_ps","","Add packed single-precision (32-bit) floating-point elements in `a` and `b`.",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_and_pd","","Compute the bitwise AND of a packed double-precision (64-bit) floating-point elements in `a` and `b`.",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_and_ps","","Compute the bitwise AND of packed single-precision (32-bit) floating-point elements in `a` and `b`.",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_or_pd","","Compute the bitwise OR packed double-precision (64-bit) floating-point elements in `a` and `b`.",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_or_ps","","Compute the bitwise OR packed single-precision (32-bit) floating-point elements in `a` and `b`.",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_shuffle_pd","","Shuffle double-precision (64-bit) floating-point elements within 128-bit lanes using the control in `imm8`.",N,[[["__m256d"],["__m256d"],["i32"]],["__m256d"]]],[5,"_mm256_shuffle_ps","","Shuffle single-precision (32-bit) floating-point elements in `a` within 128-bit lanes using the control in `imm8`.",N,[[["__m256"],["__m256"],["i32"]],["__m256"]]],[5,"_mm256_andnot_pd","","Compute the bitwise NOT of packed double-precision (64-bit) floating-point elements in `a` and then AND with `b`.",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_andnot_ps","","Compute the bitwise NOT of packed single-precision (32-bit) floating-point elements in `a` and then AND with `b`.",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_max_pd","","Compare packed double-precision (64-bit) floating-point elements in `a` and `b`, and return packed maximum values",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_max_ps","","Compare packed single-precision (32-bit) floating-point elements in `a` and `b`, and return packed maximum values",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_min_pd","","Compare packed double-precision (64-bit) floating-point elements in `a` and `b`, and return packed minimum values",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_min_ps","","Compare packed single-precision (32-bit) floating-point elements in `a` and `b`, and return packed minimum values",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_mul_pd","","Add packed double-precision (64-bit) floating-point elements in `a` and `b`.",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_mul_ps","","Add packed single-precision (32-bit) floating-point elements in `a` and `b`.",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_addsub_pd","","Alternatively add and subtract packed double-precision (64-bit) floating-point elements in `a` to/from packed elements in `b`.",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_addsub_ps","","Alternatively add and subtract packed single-precision (32-bit) floating-point elements in `a` to/from packed elements in `b`.",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_sub_pd","","Subtract packed double-precision (64-bit) floating-point elements in `b` from packed elements in `a`.",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_sub_ps","","Subtract packed single-precision (32-bit) floating-point elements in `b` from packed elements in `a`.",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_div_ps","","Compute the division of each of the 8 packed 32-bit floating-point elements in `a` by the corresponding packed elements in `b`.",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_div_pd","","Compute the division of each of the 4 packed 64-bit floating-point elements in `a` by the corresponding packed elements in `b`.",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_round_pd","","Round packed double-precision (64-bit) floating point elements in `a` according to the flag `b`. The value of `b` may be as follows:",N,[[["__m256d"],["i32"]],["__m256d"]]],[5,"_mm256_ceil_pd","","Round packed double-precision (64-bit) floating point elements in `a` toward positive infinity.",N,[[["__m256d"]],["__m256d"]]],[5,"_mm256_floor_pd","","Round packed double-precision (64-bit) floating point elements in `a` toward negative infinity.",N,[[["__m256d"]],["__m256d"]]],[5,"_mm256_round_ps","","Round packed single-precision (32-bit) floating point elements in `a` according to the flag `b`. The value of `b` may be as follows:",N,[[["__m256"],["i32"]],["__m256"]]],[5,"_mm256_ceil_ps","","Round packed single-precision (32-bit) floating point elements in `a` toward positive infinity.",N,[[["__m256"]],["__m256"]]],[5,"_mm256_floor_ps","","Round packed single-precision (32-bit) floating point elements in `a` toward negative infinity.",N,[[["__m256"]],["__m256"]]],[5,"_mm256_sqrt_ps","","Return the square root of packed single-precision (32-bit) floating point elements in `a`.",N,[[["__m256"]],["__m256"]]],[5,"_mm256_sqrt_pd","","Return the square root of packed double-precision (64-bit) floating point elements in `a`.",N,[[["__m256d"]],["__m256d"]]],[5,"_mm256_blend_pd","","Blend packed double-precision (64-bit) floating-point elements from `a` and `b` using control mask `imm8`.",N,[[["__m256d"],["__m256d"],["i32"]],["__m256d"]]],[5,"_mm256_blend_ps","","Blend packed single-precision (32-bit) floating-point elements from `a` and `b` using control mask `imm8`.",N,[[["__m256"],["__m256"],["i32"]],["__m256"]]],[5,"_mm256_blendv_pd","","Blend packed double-precision (64-bit) floating-point elements from `a` and `b` using `c` as a mask.",N,[[["__m256d"],["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_blendv_ps","","Blend packed single-precision (32-bit) floating-point elements from `a` and `b` using `c` as a mask.",N,[[["__m256"],["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_dp_ps","","Conditionally multiply the packed single-precision (32-bit) floating-point elements in `a` and `b` using the high 4 bits in `imm8`, sum the four products, and conditionally return the sum  using the low 4 bits of `imm8`.",N,[[["__m256"],["__m256"],["i32"]],["__m256"]]],[5,"_mm256_hadd_pd","","Horizontal addition of adjacent pairs in the two packed vectors of 4 64-bit floating points `a` and `b`. In the result, sums of elements from `a` are returned in even locations, while sums of elements from `b` are returned in odd locations.",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_hadd_ps","","Horizontal addition of adjacent pairs in the two packed vectors of 8 32-bit floating points `a` and `b`. In the result, sums of elements from `a` are returned in locations of indices 0, 1, 4, 5; while sums of elements from `b` are locations 2, 3, 6, 7.",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_hsub_pd","","Horizontal subtraction of adjacent pairs in the two packed vectors of 4 64-bit floating points `a` and `b`. In the result, sums of elements from `a` are returned in even locations, while sums of elements from `b` are returned in odd locations.",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_hsub_ps","","Horizontal subtraction of adjacent pairs in the two packed vectors of 8 32-bit floating points `a` and `b`. In the result, sums of elements from `a` are returned in locations of indices 0, 1, 4, 5; while sums of elements from `b` are locations 2, 3, 6, 7.",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_xor_pd","","Compute the bitwise XOR of packed double-precision (64-bit) floating-point elements in `a` and `b`.",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_xor_ps","","Compute the bitwise XOR of packed single-precision (32-bit) floating-point elements in `a` and `b`.",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm_cmp_pd","","Compare packed double-precision (64-bit) floating-point elements in `a` and `b` based on the comparison operand specified by `imm8`.",N,[[["__m128d"],["__m128d"],["i32"]],["__m128d"]]],[5,"_mm256_cmp_pd","","Compare packed double-precision (64-bit) floating-point elements in `a` and `b` based on the comparison operand specified by `imm8`.",N,[[["__m256d"],["__m256d"],["i32"]],["__m256d"]]],[5,"_mm_cmp_ps","","Compare packed single-precision (32-bit) floating-point elements in `a` and `b` based on the comparison operand specified by `imm8`.",N,[[["__m128"],["__m128"],["i32"]],["__m128"]]],[5,"_mm256_cmp_ps","","Compare packed single-precision (32-bit) floating-point elements in `a` and `b` based on the comparison operand specified by `imm8`.",N,[[["__m256"],["__m256"],["i32"]],["__m256"]]],[5,"_mm_cmp_sd","","Compare the lower double-precision (64-bit) floating-point element in `a` and `b` based on the comparison operand specified by `imm8`, store the result in the lower element of returned vector, and copy the upper element from `a` to the upper element of returned vector.",N,[[["__m128d"],["__m128d"],["i32"]],["__m128d"]]],[5,"_mm_cmp_ss","","Compare the lower single-precision (32-bit) floating-point element in `a` and `b` based on the comparison operand specified by `imm8`, store the result in the lower element of returned vector, and copy the upper 3 packed elements from `a` to the upper elements of returned vector.",N,[[["__m128"],["__m128"],["i32"]],["__m128"]]],[5,"_mm256_cvtepi32_pd","","Convert packed 32-bit integers in `a` to packed double-precision (64-bit) floating-point elements.",N,[[["__m128i"]],["__m256d"]]],[5,"_mm256_cvtepi32_ps","","Convert packed 32-bit integers in `a` to packed single-precision (32-bit) floating-point elements.",N,[[["__m256i"]],["__m256"]]],[5,"_mm256_cvtpd_ps","","Convert packed double-precision (64-bit) floating-point elements in `a` to packed single-precision (32-bit) floating-point elements.",N,[[["__m256d"]],["__m128"]]],[5,"_mm256_cvtps_epi32","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers.",N,[[["__m256"]],["__m256i"]]],[5,"_mm256_cvtps_pd","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed double-precision (64-bit) floating-point elements.",N,[[["__m128"]],["__m256d"]]],[5,"_mm256_cvttpd_epi32","","Convert packed double-precision (64-bit) floating-point elements in `a` to packed 32-bit integers with truncation.",N,[[["__m256d"]],["__m128i"]]],[5,"_mm256_cvtpd_epi32","","Convert packed double-precision (64-bit) floating-point elements in `a` to packed 32-bit integers.",N,[[["__m256d"]],["__m128i"]]],[5,"_mm256_cvttps_epi32","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers with truncation.",N,[[["__m256"]],["__m256i"]]],[5,"_mm256_extractf128_ps","","Extract 128 bits (composed of 4 packed single-precision (32-bit) floating-point elements) from `a`, selected with `imm8`.",N,[[["__m256"],["i32"]],["__m128"]]],[5,"_mm256_extractf128_pd","","Extract 128 bits (composed of 2 packed double-precision (64-bit) floating-point elements) from `a`, selected with `imm8`.",N,[[["__m256d"],["i32"]],["__m128d"]]],[5,"_mm256_extractf128_si256","","Extract 128 bits (composed of integer data) from `a`, selected with `imm8`.",N,[[["__m256i"],["i32"]],["__m128i"]]],[5,"_mm256_zeroall","","Zero the contents of all XMM or YMM registers.",N,[[]]],[5,"_mm256_zeroupper","","Zero the upper 128 bits of all YMM registers; the lower 128-bits of the registers are unmodified.",N,[[]]],[5,"_mm256_permutevar_ps","","Shuffle single-precision (32-bit) floating-point elements in `a` within 128-bit lanes using the control in `b`.",N,[[["__m256"],["__m256i"]],["__m256"]]],[5,"_mm_permutevar_ps","","Shuffle single-precision (32-bit) floating-point elements in `a` using the control in `b`.",N,[[["__m128"],["__m128i"]],["__m128"]]],[5,"_mm256_permute_ps","","Shuffle single-precision (32-bit) floating-point elements in `a` within 128-bit lanes using the control in `imm8`.",N,[[["__m256"],["i32"]],["__m256"]]],[5,"_mm_permute_ps","","Shuffle single-precision (32-bit) floating-point elements in `a` using the control in `imm8`.",N,[[["__m128"],["i32"]],["__m128"]]],[5,"_mm256_permutevar_pd","","Shuffle double-precision (64-bit) floating-point elements in `a` within 256-bit lanes using the control in `b`.",N,[[["__m256d"],["__m256i"]],["__m256d"]]],[5,"_mm_permutevar_pd","","Shuffle double-precision (64-bit) floating-point elements in `a` using the control in `b`.",N,[[["__m128d"],["__m128i"]],["__m128d"]]],[5,"_mm256_permute_pd","","Shuffle double-precision (64-bit) floating-point elements in `a` within 128-bit lanes using the control in `imm8`.",N,[[["__m256d"],["i32"]],["__m256d"]]],[5,"_mm_permute_pd","","Shuffle double-precision (64-bit) floating-point elements in `a` using the control in `imm8`.",N,[[["__m128d"],["i32"]],["__m128d"]]],[5,"_mm256_permute2f128_ps","","Shuffle 256-bits (composed of 8 packed single-precision (32-bit) floating-point elements) selected by `imm8` from `a` and `b`.",N,[[["__m256"],["__m256"],["i32"]],["__m256"]]],[5,"_mm256_permute2f128_pd","","Shuffle 256-bits (composed of 4 packed double-precision (64-bit) floating-point elements) selected by `imm8` from `a` and `b`.",N,[[["__m256d"],["__m256d"],["i32"]],["__m256d"]]],[5,"_mm256_permute2f128_si256","","Shuffle 258-bits (composed of integer data) selected by `imm8` from `a` and `b`.",N,[[["__m256i"],["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_broadcast_ss","","Broadcast a single-precision (32-bit) floating-point element from memory to all elements of the returned vector.",N,[[["f32"]],["__m256"]]],[5,"_mm_broadcast_ss","","Broadcast a single-precision (32-bit) floating-point element from memory to all elements of the returned vector.",N,[[["f32"]],["__m128"]]],[5,"_mm256_broadcast_sd","","Broadcast a double-precision (64-bit) floating-point element from memory to all elements of the returned vector.",N,[[["f64"]],["__m256d"]]],[5,"_mm256_broadcast_ps","","Broadcast 128 bits from memory (composed of 4 packed single-precision (32-bit) floating-point elements) to all elements of the returned vector.",N,[[["__m128"]],["__m256"]]],[5,"_mm256_broadcast_pd","","Broadcast 128 bits from memory (composed of 2 packed double-precision (64-bit) floating-point elements) to all elements of the returned vector.",N,[[["__m128d"]],["__m256d"]]],[5,"_mm256_insertf128_ps","","Copy `a` to result, then insert 128 bits (composed of 4 packed single-precision (32-bit) floating-point elements) from `b` into result at the location specified by `imm8`.",N,[[["__m256"],["__m128"],["i32"]],["__m256"]]],[5,"_mm256_insertf128_pd","","Copy `a` to result, then insert 128 bits (composed of 2 packed double-precision (64-bit) floating-point elements) from `b` into result at the location specified by `imm8`.",N,[[["__m256d"],["__m128d"],["i32"]],["__m256d"]]],[5,"_mm256_insertf128_si256","","Copy `a` to result, then insert 128 bits from `b` into result at the location specified by `imm8`.",N,[[["__m256i"],["__m128i"],["i32"]],["__m256i"]]],[5,"_mm256_insert_epi8","","Copy `a` to result, and insert the 8-bit integer `i` into result at the location specified by `index`.",N,[[["__m256i"],["i8"],["i32"]],["__m256i"]]],[5,"_mm256_insert_epi16","","Copy `a` to result, and insert the 16-bit integer `i` into result at the location specified by `index`.",N,[[["__m256i"],["i16"],["i32"]],["__m256i"]]],[5,"_mm256_insert_epi32","","Copy `a` to result, and insert the 32-bit integer `i` into result at the location specified by `index`.",N,[[["__m256i"],["i32"],["i32"]],["__m256i"]]],[5,"_mm256_load_pd","","Load 256-bits (composed of 4 packed double-precision (64-bit) floating-point elements) from memory into result. `mem_addr` must be aligned on a 32-byte boundary or a general-protection exception may be generated.",N,N],[5,"_mm256_store_pd","","Store 256-bits (composed of 4 packed double-precision (64-bit) floating-point elements) from `a` into memory. `mem_addr` must be aligned on a 32-byte boundary or a general-protection exception may be generated.",N,N],[5,"_mm256_load_ps","","Load 256-bits (composed of 8 packed single-precision (32-bit) floating-point elements) from memory into result. `mem_addr` must be aligned on a 32-byte boundary or a general-protection exception may be generated.",N,N],[5,"_mm256_store_ps","","Store 256-bits (composed of 8 packed single-precision (32-bit) floating-point elements) from `a` into memory. `mem_addr` must be aligned on a 32-byte boundary or a general-protection exception may be generated.",N,N],[5,"_mm256_loadu_pd","","Load 256-bits (composed of 4 packed double-precision (64-bit) floating-point elements) from memory into result. `mem_addr` does not need to be aligned on any particular boundary.",N,N],[5,"_mm256_storeu_pd","","Store 256-bits (composed of 4 packed double-precision (64-bit) floating-point elements) from `a` into memory. `mem_addr` does not need to be aligned on any particular boundary.",N,N],[5,"_mm256_loadu_ps","","Load 256-bits (composed of 8 packed single-precision (32-bit) floating-point elements) from memory into result. `mem_addr` does not need to be aligned on any particular boundary.",N,N],[5,"_mm256_storeu_ps","","Store 256-bits (composed of 8 packed single-precision (32-bit) floating-point elements) from `a` into memory. `mem_addr` does not need to be aligned on any particular boundary.",N,N],[5,"_mm256_load_si256","","Load 256-bits of integer data from memory into result. `mem_addr` must be aligned on a 32-byte boundary or a general-protection exception may be generated.",N,N],[5,"_mm256_store_si256","","Store 256-bits of integer data from `a` into memory. `mem_addr` must be aligned on a 32-byte boundary or a general-protection exception may be generated.",N,N],[5,"_mm256_loadu_si256","","Load 256-bits of integer data from memory into result. `mem_addr` does not need to be aligned on any particular boundary.",N,N],[5,"_mm256_storeu_si256","","Store 256-bits of integer data from `a` into memory.    `mem_addr` does not need to be aligned on any particular boundary.",N,N],[5,"_mm256_maskload_pd","","Load packed double-precision (64-bit) floating-point elements from memory into result using `mask` (elements are zeroed out when the high bit of the corresponding element is not set).",N,N],[5,"_mm256_maskstore_pd","","Store packed double-precision (64-bit) floating-point elements from `a` into memory using `mask`.",N,N],[5,"_mm_maskload_pd","","Load packed double-precision (64-bit) floating-point elements from memory into result using `mask` (elements are zeroed out when the high bit of the corresponding element is not set).",N,N],[5,"_mm_maskstore_pd","","Store packed double-precision (64-bit) floating-point elements from `a` into memory using `mask`.",N,N],[5,"_mm256_maskload_ps","","Load packed single-precision (32-bit) floating-point elements from memory into result using `mask` (elements are zeroed out when the high bit of the corresponding element is not set).",N,N],[5,"_mm256_maskstore_ps","","Store packed single-precision (32-bit) floating-point elements from `a` into memory using `mask`.",N,N],[5,"_mm_maskload_ps","","Load packed single-precision (32-bit) floating-point elements from memory into result using `mask` (elements are zeroed out when the high bit of the corresponding element is not set).",N,N],[5,"_mm_maskstore_ps","","Store packed single-precision (32-bit) floating-point elements from `a` into memory using `mask`.",N,N],[5,"_mm256_movehdup_ps","","Duplicate odd-indexed single-precision (32-bit) floating-point elements from `a`, and return the results.",N,[[["__m256"]],["__m256"]]],[5,"_mm256_moveldup_ps","","Duplicate even-indexed single-precision (32-bit) floating-point elements from `a`, and return the results.",N,[[["__m256"]],["__m256"]]],[5,"_mm256_movedup_pd","","Duplicate even-indexed double-precision (64-bit) floating-point elements from \"a\", and return the results.",N,[[["__m256d"]],["__m256d"]]],[5,"_mm256_lddqu_si256","","Load 256-bits of integer data from unaligned memory into result. This intrinsic may perform better than `_mm256_loadu_si256` when the data crosses a cache line boundary.",N,N],[5,"_mm256_stream_si256","","Moves integer data from a 256-bit integer vector to a 32-byte aligned memory location. To minimize caching, the data is flagged as non-temporal (unlikely to be used again soon)",N,N],[5,"_mm256_stream_pd","","Moves double-precision values from a 256-bit vector of `[4 x double]` to a 32-byte aligned memory location. To minimize caching, the data is flagged as non-temporal (unlikely to be used again soon).",N,N],[5,"_mm256_stream_ps","","Moves single-precision floating point values from a 256-bit vector of `[8 x float]` to a 32-byte aligned memory location. To minimize caching, the data is flagged as non-temporal (unlikely to be used again soon).",N,N],[5,"_mm256_rcp_ps","","Compute the approximate reciprocal of packed single-precision (32-bit) floating-point elements in `a`, and return the results. The maximum relative error for this approximation is less than 1.5*2^-12.",N,[[["__m256"]],["__m256"]]],[5,"_mm256_rsqrt_ps","","Compute the approximate reciprocal square root of packed single-precision (32-bit) floating-point elements in `a`, and return the results. The maximum relative error for this approximation is less than 1.5*2^-12.",N,[[["__m256"]],["__m256"]]],[5,"_mm256_unpackhi_pd","","Unpack and interleave double-precision (64-bit) floating-point elements from the high half of each 128-bit lane in `a` and `b`.",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_unpackhi_ps","","Unpack and interleave single-precision (32-bit) floating-point elements from the high half of each 128-bit lane in `a` and `b`.",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_unpacklo_pd","","Unpack and interleave double-precision (64-bit) floating-point elements from the low half of each 128-bit lane in `a` and `b`.",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_unpacklo_ps","","Unpack and interleave single-precision (32-bit) floating-point elements from the low half of each 128-bit lane in `a` and `b`.",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_testz_si256","","Compute the bitwise AND of 256 bits (representing integer data) in `a` and `b`, and set `ZF` to 1 if the result is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, and set `CF` to 1 if the result is zero, otherwise set `CF` to 0. Return the `ZF` value.",N,[[["__m256i"],["__m256i"]],["i32"]]],[5,"_mm256_testc_si256","","Compute the bitwise AND of 256 bits (representing integer data) in `a` and `b`, and set `ZF` to 1 if the result is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, and set `CF` to 1 if the result is zero, otherwise set `CF` to 0. Return the `CF` value.",N,[[["__m256i"],["__m256i"]],["i32"]]],[5,"_mm256_testnzc_si256","","Compute the bitwise AND of 256 bits (representing integer data) in `a` and `b`, and set `ZF` to 1 if the result is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, and set `CF` to 1 if the result is zero, otherwise set `CF` to 0. Return 1 if both the `ZF` and `CF` values are zero, otherwise return 0.",N,[[["__m256i"],["__m256i"]],["i32"]]],[5,"_mm256_testz_pd","","Compute the bitwise AND of 256 bits (representing double-precision (64-bit) floating-point elements) in `a` and `b`, producing an intermediate 256-bit value, and set `ZF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `ZF` value.",N,[[["__m256d"],["__m256d"]],["i32"]]],[5,"_mm256_testc_pd","","Compute the bitwise AND of 256 bits (representing double-precision (64-bit) floating-point elements) in `a` and `b`, producing an intermediate 256-bit value, and set `ZF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `CF` value.",N,[[["__m256d"],["__m256d"]],["i32"]]],[5,"_mm256_testnzc_pd","","Compute the bitwise AND of 256 bits (representing double-precision (64-bit) floating-point elements) in `a` and `b`, producing an intermediate 256-bit value, and set `ZF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return 1 if both the `ZF` and `CF` values are zero, otherwise return 0.",N,[[["__m256d"],["__m256d"]],["i32"]]],[5,"_mm_testz_pd","","Compute the bitwise AND of 128 bits (representing double-precision (64-bit) floating-point elements) in `a` and `b`, producing an intermediate 128-bit value, and set `ZF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `ZF` value.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm_testc_pd","","Compute the bitwise AND of 128 bits (representing double-precision (64-bit) floating-point elements) in `a` and `b`, producing an intermediate 128-bit value, and set `ZF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `CF` value.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm_testnzc_pd","","Compute the bitwise AND of 128 bits (representing double-precision (64-bit) floating-point elements) in `a` and `b`, producing an intermediate 128-bit value, and set `ZF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return 1 if both the `ZF` and `CF` values are zero, otherwise return 0.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm256_testz_ps","","Compute the bitwise AND of 256 bits (representing single-precision (32-bit) floating-point elements) in `a` and `b`, producing an intermediate 256-bit value, and set `ZF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `ZF` value.",N,[[["__m256"],["__m256"]],["i32"]]],[5,"_mm256_testc_ps","","Compute the bitwise AND of 256 bits (representing single-precision (32-bit) floating-point elements) in `a` and `b`, producing an intermediate 256-bit value, and set `ZF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `CF` value.",N,[[["__m256"],["__m256"]],["i32"]]],[5,"_mm256_testnzc_ps","","Compute the bitwise AND of 256 bits (representing single-precision (32-bit) floating-point elements) in `a` and `b`, producing an intermediate 256-bit value, and set `ZF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return 1 if both the `ZF` and `CF` values are zero, otherwise return 0.",N,[[["__m256"],["__m256"]],["i32"]]],[5,"_mm_testz_ps","","Compute the bitwise AND of 128 bits (representing single-precision (32-bit) floating-point elements) in `a` and `b`, producing an intermediate 128-bit value, and set `ZF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `ZF` value.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm_testc_ps","","Compute the bitwise AND of 128 bits (representing single-precision (32-bit) floating-point elements) in `a` and `b`, producing an intermediate 128-bit value, and set `ZF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `CF` value.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm_testnzc_ps","","Compute the bitwise AND of 128 bits (representing single-precision (32-bit) floating-point elements) in `a` and `b`, producing an intermediate 128-bit value, and set `ZF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return 1 if both the `ZF` and `CF` values are zero, otherwise return 0.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm256_movemask_pd","","Set each bit of the returned mask based on the most significant bit of the corresponding packed double-precision (64-bit) floating-point element in `a`.",N,[[["__m256d"]],["i32"]]],[5,"_mm256_movemask_ps","","Set each bit of the returned mask based on the most significant bit of the corresponding packed single-precision (32-bit) floating-point element in `a`.",N,[[["__m256"]],["i32"]]],[5,"_mm256_setzero_pd","","Return vector of type __m256d with all elements set to zero.",N,[[],["__m256d"]]],[5,"_mm256_setzero_ps","","Return vector of type __m256 with all elements set to zero.",N,[[],["__m256"]]],[5,"_mm256_setzero_si256","","Return vector of type __m256i with all elements set to zero.",N,[[],["__m256i"]]],[5,"_mm256_set_pd","","Set packed double-precision (64-bit) floating-point elements in returned vector with the supplied values.",N,[[["f64"],["f64"],["f64"],["f64"]],["__m256d"]]],[5,"_mm256_set_ps","","Set packed single-precision (32-bit) floating-point elements in returned vector with the supplied values.",N,[[["f32"],["f32"],["f32"],["f32"],["f32"],["f32"],["f32"],["f32"]],["__m256"]]],[5,"_mm256_set_epi8","","Set packed 8-bit integers in returned vector with the supplied values in reverse order.",N,[[["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"]],["__m256i"]]],[5,"_mm256_set_epi16","","Set packed 16-bit integers in returned vector with the supplied values.",N,[[["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"]],["__m256i"]]],[5,"_mm256_set_epi32","","Set packed 32-bit integers in returned vector with the supplied values.",N,[[["i32"],["i32"],["i32"],["i32"],["i32"],["i32"],["i32"],["i32"]],["__m256i"]]],[5,"_mm256_set_epi64x","","Set packed 64-bit integers in returned vector with the supplied values.",N,[[["i64"],["i64"],["i64"],["i64"]],["__m256i"]]],[5,"_mm256_setr_pd","","Set packed double-precision (64-bit) floating-point elements in returned vector with the supplied values in reverse order.",N,[[["f64"],["f64"],["f64"],["f64"]],["__m256d"]]],[5,"_mm256_setr_ps","","Set packed single-precision (32-bit) floating-point elements in returned vector with the supplied values in reverse order.",N,[[["f32"],["f32"],["f32"],["f32"],["f32"],["f32"],["f32"],["f32"]],["__m256"]]],[5,"_mm256_setr_epi8","","Set packed 8-bit integers in returned vector with the supplied values in reverse order.",N,[[["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"]],["__m256i"]]],[5,"_mm256_setr_epi16","","Set packed 16-bit integers in returned vector with the supplied values in reverse order.",N,[[["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"]],["__m256i"]]],[5,"_mm256_setr_epi32","","Set packed 32-bit integers in returned vector with the supplied values in reverse order.",N,[[["i32"],["i32"],["i32"],["i32"],["i32"],["i32"],["i32"],["i32"]],["__m256i"]]],[5,"_mm256_setr_epi64x","","Set packed 64-bit integers in returned vector with the supplied values in reverse order.",N,[[["i64"],["i64"],["i64"],["i64"]],["__m256i"]]],[5,"_mm256_set1_pd","","Broadcast double-precision (64-bit) floating-point value `a` to all elements of returned vector.",N,[[["f64"]],["__m256d"]]],[5,"_mm256_set1_ps","","Broadcast single-precision (32-bit) floating-point value `a` to all elements of returned vector.",N,[[["f32"]],["__m256"]]],[5,"_mm256_set1_epi8","","Broadcast 8-bit integer `a` to all elements of returned vector. This intrinsic may generate the `vpbroadcastb`.",N,[[["i8"]],["__m256i"]]],[5,"_mm256_set1_epi16","","Broadcast 16-bit integer `a` to all all elements of returned vector. This intrinsic may generate the `vpbroadcastw`.",N,[[["i16"]],["__m256i"]]],[5,"_mm256_set1_epi32","","Broadcast 32-bit integer `a` to all elements of returned vector. This intrinsic may generate the `vpbroadcastd`.",N,[[["i32"]],["__m256i"]]],[5,"_mm256_set1_epi64x","","Broadcast 64-bit integer `a` to all elements of returned vector. This intrinsic may generate the `vpbroadcastq`.",N,[[["i64"]],["__m256i"]]],[5,"_mm256_castpd_ps","","Cast vector of type __m256d to type __m256.",N,[[["__m256d"]],["__m256"]]],[5,"_mm256_castps_pd","","Cast vector of type __m256 to type __m256d.",N,[[["__m256"]],["__m256d"]]],[5,"_mm256_castps_si256","","Casts vector of type __m256 to type __m256i.",N,[[["__m256"]],["__m256i"]]],[5,"_mm256_castsi256_ps","","Casts vector of type __m256i to type __m256.",N,[[["__m256i"]],["__m256"]]],[5,"_mm256_castpd_si256","","Casts vector of type __m256d to type __m256i.",N,[[["__m256d"]],["__m256i"]]],[5,"_mm256_castsi256_pd","","Casts vector of type __m256i to type __m256d.",N,[[["__m256i"]],["__m256d"]]],[5,"_mm256_castps256_ps128","","Casts vector of type __m256 to type __m128.",N,[[["__m256"]],["__m128"]]],[5,"_mm256_castpd256_pd128","","Casts vector of type __m256d to type __m128d.",N,[[["__m256d"]],["__m128d"]]],[5,"_mm256_castsi256_si128","","Casts vector of type __m256i to type __m128i.",N,[[["__m256i"]],["__m128i"]]],[5,"_mm256_castps128_ps256","","Casts vector of type __m128 to type __m256; the upper 128 bits of the result are undefined.",N,[[["__m128"]],["__m256"]]],[5,"_mm256_castpd128_pd256","","Casts vector of type __m128d to type __m256d; the upper 128 bits of the result are undefined.",N,[[["__m128d"]],["__m256d"]]],[5,"_mm256_castsi128_si256","","Casts vector of type __m128i to type __m256i; the upper 128 bits of the result are undefined.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_zextps128_ps256","","Constructs a 256-bit floating-point vector of `[8 x float]` from a 128-bit floating-point vector of `[4 x float]`. The lower 128 bits contain the value of the source vector. The upper 128 bits are set to zero.",N,[[["__m128"]],["__m256"]]],[5,"_mm256_zextsi128_si256","","Constructs a 256-bit integer vector from a 128-bit integer vector. The lower 128 bits contain the value of the source vector. The upper 128 bits are set to zero.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_zextpd128_pd256","","Constructs a 256-bit floating-point vector of `[4 x double]` from a 128-bit floating-point vector of `[2 x double]`. The lower 128 bits contain the value of the source vector. The upper 128 bits are set to zero.",N,[[["__m128d"]],["__m256d"]]],[5,"_mm256_undefined_ps","","Return vector of type `__m256` with undefined elements.",N,[[],["__m256"]]],[5,"_mm256_undefined_pd","","Return vector of type `__m256d` with undefined elements.",N,[[],["__m256d"]]],[5,"_mm256_undefined_si256","","Return vector of type __m256i with undefined elements.",N,[[],["__m256i"]]],[5,"_mm256_set_m128","","Set packed __m256 returned vector with the supplied values.",N,[[["__m128"],["__m128"]],["__m256"]]],[5,"_mm256_set_m128d","","Set packed __m256d returned vector with the supplied values.",N,[[["__m128d"],["__m128d"]],["__m256d"]]],[5,"_mm256_set_m128i","","Set packed __m256i returned vector with the supplied values.",N,[[["__m128i"],["__m128i"]],["__m256i"]]],[5,"_mm256_setr_m128","","Set packed __m256 returned vector with the supplied values.",N,[[["__m128"],["__m128"]],["__m256"]]],[5,"_mm256_setr_m128d","","Set packed __m256d returned vector with the supplied values.",N,[[["__m128d"],["__m128d"]],["__m256d"]]],[5,"_mm256_setr_m128i","","Set packed __m256i returned vector with the supplied values.",N,[[["__m128i"],["__m128i"]],["__m256i"]]],[5,"_mm256_loadu2_m128","","Load two 128-bit values (composed of 4 packed single-precision (32-bit) floating-point elements) from memory, and combine them into a 256-bit value. `hiaddr` and `loaddr` do not need to be aligned on any particular boundary.",N,N],[5,"_mm256_loadu2_m128d","","Load two 128-bit values (composed of 2 packed double-precision (64-bit) floating-point elements) from memory, and combine them into a 256-bit value. `hiaddr` and `loaddr` do not need to be aligned on any particular boundary.",N,N],[5,"_mm256_loadu2_m128i","","Load two 128-bit values (composed of integer data) from memory, and combine them into a 256-bit value. `hiaddr` and `loaddr` do not need to be aligned on any particular boundary.",N,N],[5,"_mm256_storeu2_m128","","Store the high and low 128-bit halves (each composed of 4 packed single-precision (32-bit) floating-point elements) from `a` into memory two different 128-bit locations. `hiaddr` and `loaddr` do not need to be aligned on any particular boundary.",N,N],[5,"_mm256_storeu2_m128d","","Store the high and low 128-bit halves (each composed of 2 packed double-precision (64-bit) floating-point elements) from `a` into memory two different 128-bit locations. `hiaddr` and `loaddr` do not need to be aligned on any particular boundary.",N,N],[5,"_mm256_storeu2_m128i","","Store the high and low 128-bit halves (each composed of integer data) from `a` into memory two different 128-bit locations. `hiaddr` and `loaddr` do not need to be aligned on any particular boundary.",N,N],[5,"_mm256_cvtss_f32","","Returns the first element of the input vector of `[8 x float]`.",N,[[["__m256"]],["f32"]]],[5,"_mm256_abs_epi32","","Computes the absolute values of packed 32-bit integers in `a`.",N,[[["__m256i"]],["__m256i"]]],[5,"_mm256_abs_epi16","","Computes the absolute values of packed 16-bit integers in `a`.",N,[[["__m256i"]],["__m256i"]]],[5,"_mm256_abs_epi8","","Computes the absolute values of packed 8-bit integers in `a`.",N,[[["__m256i"]],["__m256i"]]],[5,"_mm256_add_epi64","","Add packed 64-bit integers in `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_add_epi32","","Add packed 32-bit integers in `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_add_epi16","","Add packed 16-bit integers in `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_add_epi8","","Add packed 8-bit integers in `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_adds_epi8","","Add packed 8-bit integers in `a` and `b` using saturation.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_adds_epi16","","Add packed 16-bit integers in `a` and `b` using saturation.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_adds_epu8","","Add packed unsigned 8-bit integers in `a` and `b` using saturation.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_adds_epu16","","Add packed unsigned 16-bit integers in `a` and `b` using saturation.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_alignr_epi8","","Concatenate pairs of 16-byte blocks in `a` and `b` into a 32-byte temporary result, shift the result right by `n` bytes, and return the low 16 bytes.",N,[[["__m256i"],["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_and_si256","","Compute the bitwise AND of 256 bits (representing integer data) in `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_andnot_si256","","Compute the bitwise NOT of 256 bits (representing integer data) in `a` and then AND with `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_avg_epu16","","Average packed unsigned 16-bit integers in `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_avg_epu8","","Average packed unsigned 8-bit integers in `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm_blend_epi32","","Blend packed 32-bit integers from `a` and `b` using control mask `imm8`.",N,[[["__m128i"],["__m128i"],["i32"]],["__m128i"]]],[5,"_mm256_blend_epi32","","Blend packed 32-bit integers from `a` and `b` using control mask `imm8`.",N,[[["__m256i"],["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_blend_epi16","","Blend packed 16-bit integers from `a` and `b` using control mask `imm8`.",N,[[["__m256i"],["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_blendv_epi8","","Blend packed 8-bit integers from `a` and `b` using `mask`.",N,[[["__m256i"],["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm_broadcastb_epi8","","Broadcast the low packed 8-bit integer from `a` to all elements of the 128-bit returned value.",N,[[["__m128i"]],["__m128i"]]],[5,"_mm256_broadcastb_epi8","","Broadcast the low packed 8-bit integer from `a` to all elements of the 256-bit returned value.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm_broadcastd_epi32","","Broadcast the low packed 32-bit integer from `a` to all elements of the 128-bit returned value.",N,[[["__m128i"]],["__m128i"]]],[5,"_mm256_broadcastd_epi32","","Broadcast the low packed 32-bit integer from `a` to all elements of the 256-bit returned value.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm_broadcastq_epi64","","Broadcast the low packed 64-bit integer from `a` to all elements of the 128-bit returned value.",N,[[["__m128i"]],["__m128i"]]],[5,"_mm256_broadcastq_epi64","","Broadcast the low packed 64-bit integer from `a` to all elements of the 256-bit returned value.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm_broadcastsd_pd","","Broadcast the low double-precision (64-bit) floating-point element from `a` to all elements of the 128-bit returned value.",N,[[["__m128d"]],["__m128d"]]],[5,"_mm256_broadcastsd_pd","","Broadcast the low double-precision (64-bit) floating-point element from `a` to all elements of the 256-bit returned value.",N,[[["__m128d"]],["__m256d"]]],[5,"_mm256_broadcastsi128_si256","","Broadcast 128 bits of integer data from a to all 128-bit lanes in the 256-bit returned value.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm_broadcastss_ps","","Broadcast the low single-precision (32-bit) floating-point element from `a` to all elements of the 128-bit returned value.",N,[[["__m128"]],["__m128"]]],[5,"_mm256_broadcastss_ps","","Broadcast the low single-precision (32-bit) floating-point element from `a` to all elements of the 256-bit returned value.",N,[[["__m128"]],["__m256"]]],[5,"_mm_broadcastw_epi16","","Broadcast the low packed 16-bit integer from a to all elements of the 128-bit returned value",N,[[["__m128i"]],["__m128i"]]],[5,"_mm256_broadcastw_epi16","","Broadcast the low packed 16-bit integer from a to all elements of the 256-bit returned value",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cmpeq_epi64","","Compare packed 64-bit integers in `a` and `b` for equality.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_cmpeq_epi32","","Compare packed 32-bit integers in `a` and `b` for equality.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_cmpeq_epi16","","Compare packed 16-bit integers in `a` and `b` for equality.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_cmpeq_epi8","","Compare packed 8-bit integers in `a` and `b` for equality.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_cmpgt_epi64","","Compare packed 64-bit integers in `a` and `b` for greater-than.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_cmpgt_epi32","","Compare packed 32-bit integers in `a` and `b` for greater-than.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_cmpgt_epi16","","Compare packed 16-bit integers in `a` and `b` for greater-than.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_cmpgt_epi8","","Compare packed 8-bit integers in `a` and `b` for greater-than.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_cvtepi16_epi32","","Sign-extend 16-bit integers to 32-bit integers.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepi16_epi64","","Sign-extend 16-bit integers to 64-bit integers.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepi32_epi64","","Sign-extend 32-bit integers to 64-bit integers.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepi8_epi16","","Sign-extend 8-bit integers to 16-bit integers.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepi8_epi32","","Sign-extend 8-bit integers to 32-bit integers.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepi8_epi64","","Sign-extend 8-bit integers to 64-bit integers.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepu16_epi32","","Zero extend packed unsigned 16-bit integers in `a` to packed 32-bit integers, and store the results in dst.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepu16_epi64","","Zero-extend the lower four unsigned 16-bit integers in `a` to 64-bit integers. The upper four elements of `a` are unused.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepu32_epi64","","Zero-extend unsigned 32-bit integers in `a` to 64-bit integers.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepu8_epi16","","Zero-extend unsigned 8-bit integers in `a` to 16-bit integers.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepu8_epi32","","Zero-extend the lower eight unsigned 8-bit integers in `a` to 32-bit integers. The upper eight elements of `a` are unused.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepu8_epi64","","Zero-extend the lower four unsigned 8-bit integers in `a` to 64-bit integers. The upper twelve elements of `a` are unused.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_extracti128_si256","","Extract 128 bits (of integer data) from `a` selected with `imm8`.",N,[[["__m256i"],["i32"]],["__m128i"]]],[5,"_mm256_hadd_epi16","","Horizontally add adjacent pairs of 16-bit integers in `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_hadd_epi32","","Horizontally add adjacent pairs of 32-bit integers in `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_hadds_epi16","","Horizontally add adjacent pairs of 16-bit integers in `a` and `b` using saturation.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_hsub_epi16","","Horizontally subtract adjacent pairs of 16-bit integers in `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_hsub_epi32","","Horizontally subtract adjacent pairs of 32-bit integers in `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_hsubs_epi16","","Horizontally subtract adjacent pairs of 16-bit integers in `a` and `b` using saturation.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm_i32gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm_mask_i32gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm256_i32gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm256_mask_i32gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm_i32gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm_mask_i32gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm256_i32gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm256_mask_i32gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm_i32gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm_mask_i32gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm256_i32gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm256_mask_i32gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm_i32gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm_mask_i32gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm256_i32gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm256_mask_i32gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm_i64gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm_mask_i64gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm256_i64gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm256_mask_i64gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm_i64gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm_mask_i64gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm256_i64gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm256_mask_i64gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm_i64gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm_mask_i64gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm256_i64gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm256_mask_i64gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm_i64gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm_mask_i64gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm256_i64gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm256_mask_i64gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm256_inserti128_si256","","Copy `a` to `dst`, then insert 128 bits (of integer data) from `b` at the location specified by `imm8`.",N,[[["__m256i"],["__m128i"],["i32"]],["__m256i"]]],[5,"_mm256_madd_epi16","","Multiply packed signed 16-bit integers in `a` and `b`, producing intermediate signed 32-bit integers. Horizontally add adjacent pairs of intermediate 32-bit integers.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_maddubs_epi16","","Vertically multiply each unsigned 8-bit integer from `a` with the corresponding signed 8-bit integer from `b`, producing intermediate signed 16-bit integers. Horizontally add adjacent pairs of intermediate signed 16-bit integers",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm_maskload_epi32","","Load packed 32-bit integers from memory pointed by `mem_addr` using `mask` (elements are zeroed out when the highest bit is not set in the corresponding element).",N,N],[5,"_mm256_maskload_epi32","","Load packed 32-bit integers from memory pointed by `mem_addr` using `mask` (elements are zeroed out when the highest bit is not set in the corresponding element).",N,N],[5,"_mm_maskload_epi64","","Load packed 64-bit integers from memory pointed by `mem_addr` using `mask` (elements are zeroed out when the highest bit is not set in the corresponding element).",N,N],[5,"_mm256_maskload_epi64","","Load packed 64-bit integers from memory pointed by `mem_addr` using `mask` (elements are zeroed out when the highest bit is not set in the corresponding element).",N,N],[5,"_mm_maskstore_epi32","","Store packed 32-bit integers from `a` into memory pointed by `mem_addr` using `mask` (elements are not stored when the highest bit is not set in the corresponding element).",N,N],[5,"_mm256_maskstore_epi32","","Store packed 32-bit integers from `a` into memory pointed by `mem_addr` using `mask` (elements are not stored when the highest bit is not set in the corresponding element).",N,N],[5,"_mm_maskstore_epi64","","Store packed 64-bit integers from `a` into memory pointed by `mem_addr` using `mask` (elements are not stored when the highest bit is not set in the corresponding element).",N,N],[5,"_mm256_maskstore_epi64","","Store packed 64-bit integers from `a` into memory pointed by `mem_addr` using `mask` (elements are not stored when the highest bit is not set in the corresponding element).",N,N],[5,"_mm256_max_epi16","","Compare packed 16-bit integers in `a` and `b`, and return the packed maximum values.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_max_epi32","","Compare packed 32-bit integers in `a` and `b`, and return the packed maximum values.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_max_epi8","","Compare packed 8-bit integers in `a` and `b`, and return the packed maximum values.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_max_epu16","","Compare packed unsigned 16-bit integers in `a` and `b`, and return the packed maximum values.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_max_epu32","","Compare packed unsigned 32-bit integers in `a` and `b`, and return the packed maximum values.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_max_epu8","","Compare packed unsigned 8-bit integers in `a` and `b`, and return the packed maximum values.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_min_epi16","","Compare packed 16-bit integers in `a` and `b`, and return the packed minimum values.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_min_epi32","","Compare packed 32-bit integers in `a` and `b`, and return the packed minimum values.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_min_epi8","","Compare packed 8-bit integers in `a` and `b`, and return the packed minimum values.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_min_epu16","","Compare packed unsigned 16-bit integers in `a` and `b`, and return the packed minimum values.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_min_epu32","","Compare packed unsigned 32-bit integers in `a` and `b`, and return the packed minimum values.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_min_epu8","","Compare packed unsigned 8-bit integers in `a` and `b`, and return the packed minimum values.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_movemask_epi8","","Create mask from the most significant bit of each 8-bit element in `a`, return the result.",N,[[["__m256i"]],["i32"]]],[5,"_mm256_mpsadbw_epu8","","Compute the sum of absolute differences (SADs) of quadruplets of unsigned 8-bit integers in `a` compared to those in `b`, and store the 16-bit results in dst. Eight SADs are performed for each 128-bit lane using one quadruplet from `b` and eight quadruplets from `a`. One quadruplet is selected from `b` starting at on the offset specified in `imm8`. Eight quadruplets are formed from sequential 8-bit integers selected from `a` starting at the offset specified in `imm8`.",N,[[["__m256i"],["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_mul_epi32","","Multiply the low 32-bit integers from each packed 64-bit element in `a` and `b`",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_mul_epu32","","Multiply the low unsigned 32-bit integers from each packed 64-bit element in `a` and `b`",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_mulhi_epi16","","Multiply the packed 16-bit integers in `a` and `b`, producing intermediate 32-bit integers and returning the high 16 bits of the intermediate integers.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_mulhi_epu16","","Multiply the packed unsigned 16-bit integers in `a` and `b`, producing intermediate 32-bit integers and returning the high 16 bits of the intermediate integers.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_mullo_epi16","","Multiply the packed 16-bit integers in `a` and `b`, producing intermediate 32-bit integers, and return the low 16 bits of the intermediate integers",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_mullo_epi32","","Multiply the packed 32-bit integers in `a` and `b`, producing intermediate 64-bit integers, and return the low 16 bits of the intermediate integers",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_mulhrs_epi16","","Multiply packed 16-bit integers in `a` and `b`, producing intermediate signed 32-bit integers. Truncate each intermediate integer to the 18 most significant bits, round by adding 1, and return bits `[16:1]`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_or_si256","","Compute the bitwise OR of 256 bits (representing integer data) in `a` and `b`",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_packs_epi16","","Convert packed 16-bit integers from `a` and `b` to packed 8-bit integers using signed saturation",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_packs_epi32","","Convert packed 32-bit integers from `a` and `b` to packed 16-bit integers using signed saturation",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_packus_epi16","","Convert packed 16-bit integers from `a` and `b` to packed 8-bit integers using unsigned saturation",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_packus_epi32","","Convert packed 32-bit integers from `a` and `b` to packed 16-bit integers using unsigned saturation",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_permutevar8x32_epi32","","Permutes packed 32-bit integers from `a` according to the content of `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_permute4x64_epi64","","Permutes 64-bit integers from `a` using control mask `imm8`.",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_permute2x128_si256","","Shuffle 128-bits of integer data selected by `imm8` from `a` and `b`.",N,[[["__m256i"],["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_permute4x64_pd","","Shuffle 64-bit floating-point elements in `a` across lanes using the control in `imm8`.",N,[[["__m256d"],["i32"]],["__m256d"]]],[5,"_mm256_permutevar8x32_ps","","Shuffle eight 32-bit foating-point elements in `a` across lanes using the corresponding 32-bit integer index in `idx`.",N,[[["__m256"],["__m256i"]],["__m256"]]],[5,"_mm256_sad_epu8","","Compute the absolute differences of packed unsigned 8-bit integers in `a` and `b`, then horizontally sum each consecutive 8 differences to produce four unsigned 16-bit integers, and pack these unsigned 16-bit integers in the low 16 bits of the 64-bit return value",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_shuffle_epi8","","Shuffle bytes from `a` according to the content of `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_shuffle_epi32","","Shuffle 32-bit integers in 128-bit lanes of `a` using the control in `imm8`.",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_shufflehi_epi16","","Shuffle 16-bit integers in the high 64 bits of 128-bit lanes of `a` using the control in `imm8`. The low 64 bits of 128-bit lanes of `a` are copied to the output.",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_shufflelo_epi16","","Shuffle 16-bit integers in the low 64 bits of 128-bit lanes of `a` using the control in `imm8`. The high 64 bits of 128-bit lanes of `a` are copied to the output.",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_sign_epi16","","Negate packed 16-bit integers in `a` when the corresponding signed 16-bit integer in `b` is negative, and return the results. Results are zeroed out when the corresponding element in `b` is zero.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_sign_epi32","","Negate packed 32-bit integers in `a` when the corresponding signed 32-bit integer in `b` is negative, and return the results. Results are zeroed out when the corresponding element in `b` is zero.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_sign_epi8","","Negate packed 8-bit integers in `a` when the corresponding signed 8-bit integer in `b` is negative, and return the results. Results are zeroed out when the corresponding element in `b` is zero.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_sll_epi16","","Shift packed 16-bit integers in `a` left by `count` while shifting in zeros, and return the result",N,[[["__m256i"],["__m128i"]],["__m256i"]]],[5,"_mm256_sll_epi32","","Shift packed 32-bit integers in `a` left by `count` while shifting in zeros, and return the result",N,[[["__m256i"],["__m128i"]],["__m256i"]]],[5,"_mm256_sll_epi64","","Shift packed 64-bit integers in `a` left by `count` while shifting in zeros, and return the result",N,[[["__m256i"],["__m128i"]],["__m256i"]]],[5,"_mm256_slli_epi16","","Shift packed 16-bit integers in `a` left by `imm8` while shifting in zeros, return the results;",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_slli_epi32","","Shift packed 32-bit integers in `a` left by `imm8` while shifting in zeros, return the results;",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_slli_epi64","","Shift packed 64-bit integers in `a` left by `imm8` while shifting in zeros, return the results;",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_slli_si256","","Shift 128-bit lanes in `a` left by `imm8` bytes while shifting in zeros.",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_bslli_epi128","","Shift 128-bit lanes in `a` left by `imm8` bytes while shifting in zeros.",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm_sllv_epi32","","Shift packed 32-bit integers in `a` left by the amount specified by the corresponding element in `count` while shifting in zeros, and return the result.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm256_sllv_epi32","","Shift packed 32-bit integers in `a` left by the amount specified by the corresponding element in `count` while shifting in zeros, and return the result.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm_sllv_epi64","","Shift packed 64-bit integers in `a` left by the amount specified by the corresponding element in `count` while shifting in zeros, and return the result.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm256_sllv_epi64","","Shift packed 64-bit integers in `a` left by the amount specified by the corresponding element in `count` while shifting in zeros, and return the result.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_sra_epi16","","Shift packed 16-bit integers in `a` right by `count` while shifting in sign bits.",N,[[["__m256i"],["__m128i"]],["__m256i"]]],[5,"_mm256_sra_epi32","","Shift packed 32-bit integers in `a` right by `count` while shifting in sign bits.",N,[[["__m256i"],["__m128i"]],["__m256i"]]],[5,"_mm256_srai_epi16","","Shift packed 16-bit integers in `a` right by `imm8` while shifting in sign bits.",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_srai_epi32","","Shift packed 32-bit integers in `a` right by `imm8` while shifting in sign bits.",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm_srav_epi32","","Shift packed 32-bit integers in `a` right by the amount specified by the corresponding element in `count` while shifting in sign bits.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm256_srav_epi32","","Shift packed 32-bit integers in `a` right by the amount specified by the corresponding element in `count` while shifting in sign bits.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_srli_si256","","Shift 128-bit lanes in `a` right by `imm8` bytes while shifting in zeros.",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_bsrli_epi128","","Shift 128-bit lanes in `a` right by `imm8` bytes while shifting in zeros.",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_srl_epi16","","Shift packed 16-bit integers in `a` right by `count` while shifting in zeros.",N,[[["__m256i"],["__m128i"]],["__m256i"]]],[5,"_mm256_srl_epi32","","Shift packed 32-bit integers in `a` right by `count` while shifting in zeros.",N,[[["__m256i"],["__m128i"]],["__m256i"]]],[5,"_mm256_srl_epi64","","Shift packed 64-bit integers in `a` right by `count` while shifting in zeros.",N,[[["__m256i"],["__m128i"]],["__m256i"]]],[5,"_mm256_srli_epi16","","Shift packed 16-bit integers in `a` right by `imm8` while shifting in zeros",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_srli_epi32","","Shift packed 32-bit integers in `a` right by `imm8` while shifting in zeros",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_srli_epi64","","Shift packed 64-bit integers in `a` right by `imm8` while shifting in zeros",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm_srlv_epi32","","Shift packed 32-bit integers in `a` right by the amount specified by the corresponding element in `count` while shifting in zeros,",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm256_srlv_epi32","","Shift packed 32-bit integers in `a` right by the amount specified by the corresponding element in `count` while shifting in zeros,",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm_srlv_epi64","","Shift packed 64-bit integers in `a` right by the amount specified by the corresponding element in `count` while shifting in zeros,",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm256_srlv_epi64","","Shift packed 64-bit integers in `a` right by the amount specified by the corresponding element in `count` while shifting in zeros,",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_sub_epi16","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a`",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_sub_epi32","","Subtract packed 32-bit integers in `b` from packed 16-bit integers in `a`",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_sub_epi64","","Subtract packed 64-bit integers in `b` from packed 16-bit integers in `a`",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_sub_epi8","","Subtract packed 8-bit integers in `b` from packed 16-bit integers in `a`",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_subs_epi16","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a` using saturation.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_subs_epi8","","Subtract packed 8-bit integers in `b` from packed 8-bit integers in `a` using saturation.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_subs_epu16","","Subtract packed unsigned 16-bit integers in `b` from packed 16-bit integers in `a` using saturation.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_subs_epu8","","Subtract packed unsigned 8-bit integers in `b` from packed 8-bit integers in `a` using saturation.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_unpackhi_epi8","","Unpack and interleave 8-bit integers from the high half of each 128-bit lane in `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_unpacklo_epi8","","Unpack and interleave 8-bit integers from the low half of each 128-bit lane of `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_unpackhi_epi16","","Unpack and interleave 16-bit integers from the high half of each 128-bit lane of `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_unpacklo_epi16","","Unpack and interleave 16-bit integers from the low half of each 128-bit lane of `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_unpackhi_epi32","","Unpack and interleave 32-bit integers from the high half of each 128-bit lane of `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_unpacklo_epi32","","Unpack and interleave 32-bit integers from the low half of each 128-bit lane of `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_unpackhi_epi64","","Unpack and interleave 64-bit integers from the high half of each 128-bit lane of `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_unpacklo_epi64","","Unpack and interleave 64-bit integers from the low half of each 128-bit lane of `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_xor_si256","","Compute the bitwise XOR of 256 bits (representing integer data) in `a` and `b`",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_extract_epi8","","Extract an 8-bit integer from `a`, selected with `imm8`. Returns a 32-bit integer containing the zero-extended integer data.",N,[[["__m256i"],["i32"]],["i8"]]],[5,"_mm256_extract_epi16","","Extract a 16-bit integer from `a`, selected with `imm8`. Returns a 32-bit integer containing the zero-extended integer data.",N,[[["__m256i"],["i32"]],["i16"]]],[5,"_mm256_extract_epi32","","Extract a 32-bit integer from `a`, selected with `imm8`.",N,[[["__m256i"],["i32"]],["i32"]]],[5,"_mm256_cvtsd_f64","","Returns the first element of the input vector of `[4 x double]`.",N,[[["__m256d"]],["f64"]]],[5,"_mm256_cvtsi256_si32","","Returns the first element of the input vector of `[8 x i32]`.",N,[[["__m256i"]],["i32"]]],[5,"_mm_fmadd_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and add the intermediate result to packed elements in `c`.",N,[[["__m128d"],["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm256_fmadd_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and add the intermediate result to packed elements in `c`.",N,[[["__m256d"],["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm_fmadd_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and add the intermediate result to packed elements in `c`.",N,[[["__m128"],["__m128"],["__m128"]],["__m128"]]],[5,"_mm256_fmadd_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and add the intermediate result to packed elements in `c`.",N,[[["__m256"],["__m256"],["__m256"]],["__m256"]]],[5,"_mm_fmadd_sd","","Multiply the lower double-precision (64-bit) floating-point elements in `a` and `b`, and add the intermediate result to the lower element in `c`. Store the result in the lower element of the returned value, and copy the upper element from `a` to the upper elements of the result.",N,[[["__m128d"],["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_fmadd_ss","","Multiply the lower single-precision (32-bit) floating-point elements in `a` and `b`, and add the intermediate result to the lower element in `c`. Store the result in the lower element of the returned value, and copy the 3 upper elements from `a` to the upper elements of the result.",N,[[["__m128"],["__m128"],["__m128"]],["__m128"]]],[5,"_mm_fmaddsub_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and alternatively add and subtract packed elements in `c` to/from the intermediate result.",N,[[["__m128d"],["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm256_fmaddsub_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and alternatively add and subtract packed elements in `c` to/from the intermediate result.",N,[[["__m256d"],["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm_fmaddsub_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and alternatively add and subtract packed elements in `c` to/from the intermediate result.",N,[[["__m128"],["__m128"],["__m128"]],["__m128"]]],[5,"_mm256_fmaddsub_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and alternatively add and subtract packed elements in `c` to/from the intermediate result.",N,[[["__m256"],["__m256"],["__m256"]],["__m256"]]],[5,"_mm_fmsub_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the intermediate result.",N,[[["__m128d"],["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm256_fmsub_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the intermediate result.",N,[[["__m256d"],["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm_fmsub_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the intermediate result.",N,[[["__m128"],["__m128"],["__m128"]],["__m128"]]],[5,"_mm256_fmsub_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the intermediate result.",N,[[["__m256"],["__m256"],["__m256"]],["__m256"]]],[5,"_mm_fmsub_sd","","Multiply the lower double-precision (64-bit) floating-point elements in `a` and `b`, and subtract the lower element in `c` from the intermediate result. Store the result in the lower element of the returned value, and copy the upper element from `a` to the upper elements of the result.",N,[[["__m128d"],["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_fmsub_ss","","Multiply the lower single-precision (32-bit) floating-point elements in `a` and `b`,  and subtract the lower element in `c` from the intermediate result. Store the result in the lower element of the returned value, and copy the 3 upper elements from `a` to the upper elements of the result.",N,[[["__m128"],["__m128"],["__m128"]],["__m128"]]],[5,"_mm_fmsubadd_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and alternatively subtract and add packed elements in `c` from/to the intermediate result.",N,[[["__m128d"],["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm256_fmsubadd_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and alternatively subtract and add packed elements in `c` from/to the intermediate result.",N,[[["__m256d"],["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm_fmsubadd_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and alternatively subtract and add packed elements in `c` from/to the intermediate result.",N,[[["__m128"],["__m128"],["__m128"]],["__m128"]]],[5,"_mm256_fmsubadd_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and alternatively subtract and add packed elements in `c` from/to the intermediate result.",N,[[["__m256"],["__m256"],["__m256"]],["__m256"]]],[5,"_mm_fnmadd_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and add the negated intermediate result to packed elements in `c`.",N,[[["__m128d"],["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm256_fnmadd_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and add the negated intermediate result to packed elements in `c`.",N,[[["__m256d"],["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm_fnmadd_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and add the negated intermediate result to packed elements in `c`.",N,[[["__m128"],["__m128"],["__m128"]],["__m128"]]],[5,"_mm256_fnmadd_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and add the negated intermediate result to packed elements in `c`.",N,[[["__m256"],["__m256"],["__m256"]],["__m256"]]],[5,"_mm_fnmadd_sd","","Multiply the lower double-precision (64-bit) floating-point elements in `a` and `b`, and add the negated intermediate result to the lower element in `c`. Store the result in the lower element of the returned value, and copy the upper element from `a` to the upper elements of the result.",N,[[["__m128d"],["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_fnmadd_ss","","Multiply the lower single-precision (32-bit) floating-point elements in `a` and `b`, and add the negated intermediate result to the lower element in `c`. Store the result in the lower element of the returned value, and copy the 3 upper elements from `a` to the upper elements of the result.",N,[[["__m128"],["__m128"],["__m128"]],["__m128"]]],[5,"_mm_fnmsub_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the negated intermediate result.",N,[[["__m128d"],["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm256_fnmsub_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the negated intermediate result.",N,[[["__m256d"],["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm_fnmsub_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the negated intermediate result.",N,[[["__m128"],["__m128"],["__m128"]],["__m128"]]],[5,"_mm256_fnmsub_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the negated intermediate result.",N,[[["__m256"],["__m256"],["__m256"]],["__m256"]]],[5,"_mm_fnmsub_sd","","Multiply the lower double-precision (64-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the negated intermediate result. Store the result in the lower element of the returned value, and copy the upper element from `a` to the upper elements of the result.",N,[[["__m128d"],["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_fnmsub_ss","","Multiply the lower single-precision (32-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the negated intermediate result. Store the result in the lower element of the returned value, and copy the 3 upper elements from `a` to the upper elements of the result.",N,[[["__m128"],["__m128"],["__m128"]],["__m128"]]],[5,"_lzcnt_u32","","Counts the leading most significant zero bits.",N,[[["u32"]],["u32"]]],[5,"_popcnt32","","Counts the bits that are set.",N,[[["i32"]],["i32"]]],[5,"_bextr_u32","","Extracts bits in range [`start`, `start` + `length`) from `a` into the least significant bits of the result.",N,[[["u32"],["u32"],["u32"]],["u32"]]],[5,"_bextr2_u32","","Extracts bits of `a` specified by `control` into the least significant bits of the result.",N,[[["u32"],["u32"]],["u32"]]],[5,"_andn_u32","","Bitwise logical `AND` of inverted `a` with `b`.",N,[[["u32"],["u32"]],["u32"]]],[5,"_blsi_u32","","Extract lowest set isolated bit.",N,[[["u32"]],["u32"]]],[5,"_blsmsk_u32","","Get mask up to lowest set bit.",N,[[["u32"]],["u32"]]],[5,"_blsr_u32","","Resets the lowest set bit of `x`.",N,[[["u32"]],["u32"]]],[5,"_tzcnt_u32","","Counts the number of trailing least significant zero bits.",N,[[["u32"]],["u32"]]],[5,"_mm_tzcnt_32","","Counts the number of trailing least significant zero bits.",N,[[["u32"]],["i32"]]],[5,"_mulx_u32","","Unsigned multiply without affecting flags.",N,[[["u32"],["u32"],["u32"]],["u32"]]],[5,"_bzhi_u32","","Zero higher bits of `a` >= `index`.",N,[[["u32"],["u32"]],["u32"]]],[5,"_pdep_u32","","Scatter contiguous low order bits of `a` to the result at the positions specified by the `mask`.",N,[[["u32"],["u32"]],["u32"]]],[5,"_pext_u32","","Gathers the bits of `x` specified by the `mask` into the contiguous low order bit positions of the result.",N,[[["u32"],["u32"]],["u32"]]],[5,"_mm_extract_si64","","Extracts the bit range specified by `y` from the lower 64 bits of `x`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_insert_si64","","Inserts the `[length:0]` bits of `y` into `x` at `index`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_stream_sd","","Non-temporal store of `a.0` into `p`.",N,N],[5,"_mm_stream_ss","","Non-temporal store of `a.0` into `p`.",N,N],[5,"_blcfill_u32","","Clears all bits below the least significant zero bit of `x`.",N,[[["u32"]],["u32"]]],[5,"_blci_u32","","Sets all bits of `x` to 1 except for the least significant zero bit.",N,[[["u32"]],["u32"]]],[5,"_blcic_u32","","Sets the least significant zero bit of `x` and clears all other bits.",N,[[["u32"]],["u32"]]],[5,"_blcmsk_u32","","Sets the least significant zero bit of `x` and clears all bits above that bit.",N,[[["u32"]],["u32"]]],[5,"_blcs_u32","","Sets the least significant zero bit of `x`.",N,[[["u32"]],["u32"]]],[5,"_blsfill_u32","","Sets all bits of `x` below the least significant one.",N,[[["u32"]],["u32"]]],[5,"_blsic_u32","","Clears least significant bit and sets all other bits.",N,[[["u32"]],["u32"]]],[5,"_t1mskc_u32","","Clears all bits below the least significant zero of `x` and sets all other bits.",N,[[["u32"]],["u32"]]],[5,"_tzmsk_u32","","Sets all bits below the least significant one of `x` and clears all other bits.",N,[[["u32"]],["u32"]]],[5,"_mm_setzero_si64","","Constructs a 64-bit integer vector initialized to zero.",N,[[],["__m64"]]],[5,"_mm_add_pi8","","Add packed 8-bit integers in `a` and `b`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_paddb","","Add packed 8-bit integers in `a` and `b`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_add_pi16","","Add packed 16-bit integers in `a` and `b`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_paddw","","Add packed 16-bit integers in `a` and `b`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_add_pi32","","Add packed 32-bit integers in `a` and `b`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_paddd","","Add packed 32-bit integers in `a` and `b`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_adds_pi8","","Add packed 8-bit integers in `a` and `b` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_paddsb","","Add packed 8-bit integers in `a` and `b` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_adds_pi16","","Add packed 16-bit integers in `a` and `b` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_paddsw","","Add packed 16-bit integers in `a` and `b` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_adds_pu8","","Add packed unsigned 8-bit integers in `a` and `b` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_paddusb","","Add packed unsigned 8-bit integers in `a` and `b` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_adds_pu16","","Add packed unsigned 16-bit integers in `a` and `b` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_paddusw","","Add packed unsigned 16-bit integers in `a` and `b` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_sub_pi8","","Subtract packed 8-bit integers in `b` from packed 8-bit integers in `a`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_psubb","","Subtract packed 8-bit integers in `b` from packed 8-bit integers in `a`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_sub_pi16","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_psubw","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_sub_pi32","","Subtract packed 32-bit integers in `b` from packed 32-bit integers in `a`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_psubd","","Subtract packed 32-bit integers in `b` from packed 32-bit integers in `a`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_subs_pi8","","Subtract packed 8-bit integers in `b` from packed 8-bit integers in `a` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_psubsb","","Subtract packed 8-bit integers in `b` from packed 8-bit integers in `a` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_subs_pi16","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_psubsw","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_subs_pu8","","Subtract packed unsigned 8-bit integers in `b` from packed unsigned 8-bit integers in `a` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_psubusb","","Subtract packed unsigned 8-bit integers in `b` from packed unsigned 8-bit integers in `a` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_subs_pu16","","Subtract packed unsigned 16-bit integers in `b` from packed unsigned 16-bit integers in `a` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_psubusw","","Subtract packed unsigned 16-bit integers in `b` from packed unsigned 16-bit integers in `a` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_packs_pi16","","Convert packed 16-bit integers from `a` and `b` to packed 8-bit integers using signed saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_packs_pi32","","Convert packed 32-bit integers from `a` and `b` to packed 16-bit integers using signed saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_cmpgt_pi8","","Compares whether each element of `a` is greater than the corresponding element of `b` returning `0` for `false` and `-1` for `true`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_cmpgt_pi16","","Compares whether each element of `a` is greater than the corresponding element of `b` returning `0` for `false` and `-1` for `true`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_cmpgt_pi32","","Compares whether each element of `a` is greater than the corresponding element of `b` returning `0` for `false` and `-1` for `true`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_unpackhi_pi16","","Unpacks the upper two elements from two `i16x4` vectors and interleaves them into the result: `[a.2, b.2, a.3, b.3]`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_unpackhi_pi8","","Unpacks the upper four elements from two `i8x8` vectors and interleaves them into the result: `[a.4, b.4, a.5, b.5, a.6, b.6, a.7, b.7]`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_unpacklo_pi8","","Unpacks the lower four elements from two `i8x8` vectors and interleaves them into the result: `[a.0, b.0, a.1, b.1, a.2, b.2, a.3, b.3]`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_unpacklo_pi16","","Unpacks the lower two elements from two `i16x4` vectors and interleaves them into the result: `[a.0 b.0 a.1 b.1]`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_unpackhi_pi32","","Unpacks the upper element from two `i32x2` vectors and interleaves them into the result: `[a.1, b.1]`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_unpacklo_pi32","","Unpacks the lower element from two `i32x2` vectors and interleaves them into the result: `[a.0, b.0]`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_set_pi16","","Set packed 16-bit integers in dst with the supplied values.",N,[[["i16"],["i16"],["i16"],["i16"]],["__m64"]]],[5,"_mm_set_pi32","","Set packed 32-bit integers in dst with the supplied values.",N,[[["i32"],["i32"]],["__m64"]]],[5,"_mm_set_pi8","","Set packed 8-bit integers in dst with the supplied values.",N,[[["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"]],["__m64"]]],[5,"_mm_set1_pi16","","Broadcast 16-bit integer a to all all elements of dst.",N,[[["i16"]],["__m64"]]],[5,"_mm_set1_pi32","","Broadcast 32-bit integer a to all all elements of dst.",N,[[["i32"]],["__m64"]]],[5,"_mm_set1_pi8","","Broadcast 8-bit integer a to all all elements of dst.",N,[[["i8"]],["__m64"]]],[5,"_mm_setr_pi16","","Set packed 16-bit integers in dst with the supplied values in reverse order.",N,[[["i16"],["i16"],["i16"],["i16"]],["__m64"]]],[5,"_mm_setr_pi32","","Set packed 32-bit integers in dst with the supplied values in reverse order.",N,[[["i32"],["i32"]],["__m64"]]],[5,"_mm_setr_pi8","","Set packed 8-bit integers in dst with the supplied values in reverse order.",N,[[["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"]],["__m64"]]],[5,"_mm_clmulepi64_si128","","Perform a carry-less multiplication of two 64-bit polynomials over the finite field GF(2^k).",N,[[["__m128i"],["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_aesdec_si128","","Perform one round of an AES decryption flow on data (state) in `a`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_aesdeclast_si128","","Perform the last round of an AES decryption flow on data (state) in `a`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_aesenc_si128","","Perform one round of an AES encryption flow on data (state) in `a`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_aesenclast_si128","","Perform the last round of an AES encryption flow on data (state) in `a`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_aesimc_si128","","Perform the `InvMixColumns` transformation on `a`.",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_aeskeygenassist_si128","","Assist in expanding the AES cipher key.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_rdrand16_step","","Read a hardware generated 16-bit random value and store the result in val. Return 1 if a random value was generated, and 0 otherwise.",N,[[["u16"]],["i32"]]],[5,"_rdrand32_step","","Read a hardware generated 32-bit random value and store the result in val. Return 1 if a random value was generated, and 0 otherwise.",N,[[["u32"]],["i32"]]],[5,"_rdseed16_step","","Read a 16-bit NIST SP800-90B and SP800-90C compliant random value and store in val. Return 1 if a random value was generated, and 0 otherwise.",N,[[["u16"]],["i32"]]],[5,"_rdseed32_step","","Read a 32-bit NIST SP800-90B and SP800-90C compliant random value and store in val. Return 1 if a random value was generated, and 0 otherwise.",N,[[["u32"]],["i32"]]],[5,"_mm_sha1msg1_epu32","","Perform an intermediate calculation for the next four SHA1 message values (unsigned 32-bit integers) using previous message values from `a` and `b`, and returning the result.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_sha1msg2_epu32","","Perform the final calculation for the next four SHA1 message values (unsigned 32-bit integers) using the intermediate result in `a` and the previous message values in `b`, and returns the result.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_sha1nexte_epu32","","Calculate SHA1 state variable E after four rounds of operation from the current SHA1 state variable `a`, add that value to the scheduled values (unsigned 32-bit integers) in `b`, and returns the result.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_sha1rnds4_epu32","","Perform four rounds of SHA1 operation using an initial SHA1 state (A,B,C,D) from `a` and some pre-computed sum of the next 4 round message values (unsigned 32-bit integers), and state variable E from `b`, and return the updated SHA1 state (A,B,C,D). `func` contains the logic functions and round constants.",N,[[["__m128i"],["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_sha256msg1_epu32","","Perform an intermediate calculation for the next four SHA256 message values (unsigned 32-bit integers) using previous message values from `a` and `b`, and return the result.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_sha256msg2_epu32","","Perform the final calculation for the next four SHA256 message values (unsigned 32-bit integers) using previous message values from `a` and `b`, and return the result.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_sha256rnds2_epu32","","Perform 2 rounds of SHA256 operation using an initial SHA256 state (C,D,G,H) from `a`, an initial SHA256 state (A,B,E,F) from `b`, and a pre-computed sum of the next 2 round message values (unsigned 32-bit integers) and the corresponding round constants from `k`, and store the updated SHA256 state (A,B,E,F) in dst.",N,[[["__m128i"],["__m128i"],["__m128i"]],["__m128i"]]],[5,"_fxsave64","","Saves the `x87` FPU, `MMX` technology, `XMM`, and `MXCSR` registers to the 512-byte-long 16-byte-aligned memory region `mem_addr`.",N,N],[5,"_fxrstor64","","Restores the `XMM`, `MMX`, `MXCSR`, and `x87` FPU registers from the 512-byte-long 16-byte-aligned memory region `mem_addr`.",N,N],[5,"_mm_cvtss_si64","","Convert the lowest 32 bit float in the input vector to a 64 bit integer.",N,[[["__m128"]],["i64"]]],[5,"_mm_cvttss_si64","","Convert the lowest 32 bit float in the input vector to a 64 bit integer with truncation.",N,[[["__m128"]],["i64"]]],[5,"_mm_cvtsi64_ss","","Convert a 64 bit integer to a 32 bit float. The result vector is the input vector `a` with the lowest 32 bit float replaced by the converted integer.",N,[[["__m128"],["i64"]],["__m128"]]],[5,"_mm_cvtsd_si64","","Convert the lower double-precision (64-bit) floating-point element in a to a 64-bit integer.",N,[[["__m128d"]],["i64"]]],[5,"_mm_cvtsd_si64x","","Alias for `_mm_cvtsd_si64`",N,[[["__m128d"]],["i64"]]],[5,"_mm_cvttsd_si64","","Convert the lower double-precision (64-bit) floating-point element in `a` to a 64-bit integer with truncation.",N,[[["__m128d"]],["i64"]]],[5,"_mm_cvttsd_si64x","","Alias for `_mm_cvttsd_si64`",N,[[["__m128d"]],["i64"]]],[5,"_mm_stream_si64","","Stores a 64-bit integer value in the specified memory location. To minimize caching, the data is flagged as non-temporal (unlikely to be used again soon).",N,N],[5,"_mm_cvtsi64_si128","","Return a vector whose lowest element is `a` and all higher elements are `0`.",N,[[["i64"]],["__m128i"]]],[5,"_mm_cvtsi64x_si128","","Return a vector whose lowest element is `a` and all higher elements are `0`.",N,[[["i64"]],["__m128i"]]],[5,"_mm_cvtsi128_si64","","Return the lowest element of `a`.",N,[[["__m128i"]],["i64"]]],[5,"_mm_cvtsi128_si64x","","Return the lowest element of `a`.",N,[[["__m128i"]],["i64"]]],[5,"_mm_cvtsi64_sd","","Return `a` with its lower element replaced by `b` after converting it to an `f64`.",N,[[["__m128d"],["i64"]],["__m128d"]]],[5,"_mm_cvtsi64x_sd","","Return `a` with its lower element replaced by `b` after converting it to an `f64`.",N,[[["__m128d"],["i64"]],["__m128d"]]],[5,"_mm_extract_epi64","","Extract an 64-bit integer from `a` selected with `imm8`",N,[[["__m128i"],["i32"]],["i64"]]],[5,"_mm_insert_epi64","","Return a copy of `a` with the 64-bit integer from `i` inserted at a location specified by `imm8`.",N,[[["__m128i"],["i64"],["i32"]],["__m128i"]]],[5,"_mm_crc32_u64","","Starting with the initial value in `crc`, return the accumulated CRC32 value for unsigned 64-bit integer `v`.",N,[[["u64"],["u64"]],["u64"]]],[5,"_xsave64","","Perform a full or partial save of the enabled processor states to memory at `mem_addr`.",N,N],[5,"_xrstor64","","Perform a full or partial restore of the enabled processor states using the state information stored in memory at `mem_addr`.",N,N],[5,"_xsaveopt64","","Perform a full or partial save of the enabled processor states to memory at `mem_addr`.",N,N],[5,"_xsavec64","","Perform a full or partial save of the enabled processor states to memory at `mem_addr`.",N,N],[5,"_xsaves64","","Perform a full or partial save of the enabled processor states to memory at `mem_addr`",N,N],[5,"_xrstors64","","Perform a full or partial restore of the enabled processor states using the state information stored in memory at `mem_addr`.",N,N],[5,"_lzcnt_u64","","Counts the leading most significant zero bits.",N,[[["u64"]],["u64"]]],[5,"_popcnt64","","Counts the bits that are set.",N,[[["i64"]],["i32"]]],[5,"_mm256_insert_epi64","","Copy `a` to result, and insert the 64-bit integer `i` into result at the location specified by `index`.",N,[[["__m256i"],["i64"],["i32"]],["__m256i"]]],[5,"_andn_u64","","Bitwise logical `AND` of inverted `a` with `b`.",N,[[["u64"],["u64"]],["u64"]]],[5,"_tzcnt_u64","","Counts the number of trailing least significant zero bits.",N,[[["u64"]],["u64"]]],[5,"_mm_tzcnt_64","","Counts the number of trailing least significant zero bits.",N,[[["u64"]],["i64"]]],[5,"_mm256_extract_epi64","","Extract a 64-bit integer from `a`, selected with `imm8`.",N,[[["__m256i"],["i32"]],["i64"]]],[5,"_bswap64","","Return an integer with the reversed byte order of x",N,[[["i64"]],["i64"]]],[5,"_rdrand64_step","","Read a hardware generated 64-bit random value and store the result in val. Return 1 if a random value was generated, and 0 otherwise.",N,[[["u64"]],["i32"]]],[5,"_rdseed64_step","","Read a 64-bit NIST SP800-90B and SP800-90C compliant random value and store in val. Return 1 if a random value was generated, and 0 otherwise.",N,[[["u64"]],["i32"]]],[17,"_XCR_XFEATURE_ENABLED_MASK","","`XFEATURE_ENABLED_MASK` for `XCR`",N,N],[17,"_MM_EXCEPT_INVALID","","See `_mm_setcsr`",N,N],[17,"_MM_EXCEPT_DENORM","","See `_mm_setcsr`",N,N],[17,"_MM_EXCEPT_DIV_ZERO","","See `_mm_setcsr`",N,N],[17,"_MM_EXCEPT_OVERFLOW","","See `_mm_setcsr`",N,N],[17,"_MM_EXCEPT_UNDERFLOW","","See `_mm_setcsr`",N,N],[17,"_MM_EXCEPT_INEXACT","","See `_mm_setcsr`",N,N],[17,"_MM_EXCEPT_MASK","","See `_MM_GET_EXCEPTION_STATE`",N,N],[17,"_MM_MASK_INVALID","","See `_mm_setcsr`",N,N],[17,"_MM_MASK_DENORM","","See `_mm_setcsr`",N,N],[17,"_MM_MASK_DIV_ZERO","","See `_mm_setcsr`",N,N],[17,"_MM_MASK_OVERFLOW","","See `_mm_setcsr`",N,N],[17,"_MM_MASK_UNDERFLOW","","See `_mm_setcsr`",N,N],[17,"_MM_MASK_INEXACT","","See `_mm_setcsr`",N,N],[17,"_MM_MASK_MASK","","See `_MM_GET_EXCEPTION_MASK`",N,N],[17,"_MM_ROUND_NEAREST","","See `_mm_setcsr`",N,N],[17,"_MM_ROUND_DOWN","","See `_mm_setcsr`",N,N],[17,"_MM_ROUND_UP","","See `_mm_setcsr`",N,N],[17,"_MM_ROUND_TOWARD_ZERO","","See `_mm_setcsr`",N,N],[17,"_MM_ROUND_MASK","","See `_MM_GET_ROUNDING_MODE`",N,N],[17,"_MM_FLUSH_ZERO_MASK","","See `_MM_GET_FLUSH_ZERO_MODE`",N,N],[17,"_MM_FLUSH_ZERO_ON","","See `_mm_setcsr`",N,N],[17,"_MM_FLUSH_ZERO_OFF","","See `_mm_setcsr`",N,N],[17,"_MM_HINT_T0","","See `_mm_prefetch`.",N,N],[17,"_MM_HINT_T1","","See `_mm_prefetch`.",N,N],[17,"_MM_HINT_T2","","See `_mm_prefetch`.",N,N],[17,"_MM_HINT_NTA","","See `_mm_prefetch`.",N,N],[17,"_MM_FROUND_TO_NEAREST_INT","","round to nearest",N,N],[17,"_MM_FROUND_TO_NEG_INF","","round down",N,N],[17,"_MM_FROUND_TO_POS_INF","","round up",N,N],[17,"_MM_FROUND_TO_ZERO","","truncate",N,N],[17,"_MM_FROUND_CUR_DIRECTION","","use MXCSR.RC; see `vendor::_MM_SET_ROUNDING_MODE`",N,N],[17,"_MM_FROUND_RAISE_EXC","","do not suppress exceptions",N,N],[17,"_MM_FROUND_NO_EXC","","suppress exceptions",N,N],[17,"_MM_FROUND_NINT","","round to nearest and do not suppress exceptions",N,N],[17,"_MM_FROUND_FLOOR","","round down and do not suppress exceptions",N,N],[17,"_MM_FROUND_CEIL","","round up and do not suppress exceptions",N,N],[17,"_MM_FROUND_TRUNC","","truncate and do not suppress exceptions",N,N],[17,"_MM_FROUND_RINT","","use MXCSR.RC and do not suppress exceptions; see `vendor::_MM_SET_ROUNDING_MODE`",N,N],[17,"_MM_FROUND_NEARBYINT","","use MXCSR.RC and suppress exceptions; see `vendor::_MM_SET_ROUNDING_MODE`",N,N],[17,"_SIDD_UBYTE_OPS","","String contains unsigned 8-bit characters (Default)",N,N],[17,"_SIDD_UWORD_OPS","","String contains unsigned 16-bit characters",N,N],[17,"_SIDD_SBYTE_OPS","","String contains signed 8-bit characters",N,N],[17,"_SIDD_SWORD_OPS","","String contains unsigned 16-bit characters",N,N],[17,"_SIDD_CMP_EQUAL_ANY","","For each character in `a`, find if it is in `b` (Default)",N,N],[17,"_SIDD_CMP_RANGES","","For each character in `a`, determine if `b[0] <= c <= b[1] or b[1] <= c <= b[2]...`",N,N],[17,"_SIDD_CMP_EQUAL_EACH","","The strings defined by `a` and `b` are equal",N,N],[17,"_SIDD_CMP_EQUAL_ORDERED","","Search for the defined substring in the target",N,N],[17,"_SIDD_POSITIVE_POLARITY","","Do not negate results (Default)",N,N],[17,"_SIDD_NEGATIVE_POLARITY","","Negate results",N,N],[17,"_SIDD_MASKED_POSITIVE_POLARITY","","Do not negate results before the end of the string",N,N],[17,"_SIDD_MASKED_NEGATIVE_POLARITY","","Negate results only before the end of the string",N,N],[17,"_SIDD_LEAST_SIGNIFICANT","","Index only: return the least significant bit (Default)",N,N],[17,"_SIDD_MOST_SIGNIFICANT","","Index only: return the most significant bit",N,N],[17,"_SIDD_BIT_MASK","","Mask only: return the bit mask",N,N],[17,"_SIDD_UNIT_MASK","","Mask only: return the byte mask",N,N],[17,"_CMP_EQ_OQ","","Equal (ordered, non-signaling)",N,N],[17,"_CMP_LT_OS","","Less-than (ordered, signaling)",N,N],[17,"_CMP_LE_OS","","Less-than-or-equal (ordered, signaling)",N,N],[17,"_CMP_UNORD_Q","","Unordered (non-signaling)",N,N],[17,"_CMP_NEQ_UQ","","Not-equal (unordered, non-signaling)",N,N],[17,"_CMP_NLT_US","","Not-less-than (unordered, signaling)",N,N],[17,"_CMP_NLE_US","","Not-less-than-or-equal (unordered, signaling)",N,N],[17,"_CMP_ORD_Q","","Ordered (non-signaling)",N,N],[17,"_CMP_EQ_UQ","","Equal (unordered, non-signaling)",N,N],[17,"_CMP_NGE_US","","Not-greater-than-or-equal (unordered, signaling)",N,N],[17,"_CMP_NGT_US","","Not-greater-than (unordered, signaling)",N,N],[17,"_CMP_FALSE_OQ","","False (ordered, non-signaling)",N,N],[17,"_CMP_NEQ_OQ","","Not-equal (ordered, non-signaling)",N,N],[17,"_CMP_GE_OS","","Greater-than-or-equal (ordered, signaling)",N,N],[17,"_CMP_GT_OS","","Greater-than (ordered, signaling)",N,N],[17,"_CMP_TRUE_UQ","","True (unordered, non-signaling)",N,N],[17,"_CMP_EQ_OS","","Equal (ordered, signaling)",N,N],[17,"_CMP_LT_OQ","","Less-than (ordered, non-signaling)",N,N],[17,"_CMP_LE_OQ","","Less-than-or-equal (ordered, non-signaling)",N,N],[17,"_CMP_UNORD_S","","Unordered (signaling)",N,N],[17,"_CMP_NEQ_US","","Not-equal (unordered, signaling)",N,N],[17,"_CMP_NLT_UQ","","Not-less-than (unordered, non-signaling)",N,N],[17,"_CMP_NLE_UQ","","Not-less-than-or-equal (unordered, non-signaling)",N,N],[17,"_CMP_ORD_S","","Ordered (signaling)",N,N],[17,"_CMP_EQ_US","","Equal (unordered, signaling)",N,N],[17,"_CMP_NGE_UQ","","Not-greater-than-or-equal (unordered, non-signaling)",N,N],[17,"_CMP_NGT_UQ","","Not-greater-than (unordered, non-signaling)",N,N],[17,"_CMP_FALSE_OS","","False (ordered, signaling)",N,N],[17,"_CMP_NEQ_OS","","Not-equal (ordered, signaling)",N,N],[17,"_CMP_GE_OQ","","Greater-than-or-equal (ordered, non-signaling)",N,N],[17,"_CMP_GT_OQ","","Greater-than (ordered, non-signaling)",N,N],[17,"_CMP_TRUE_US","","True (unordered, signaling)",N,N],[0,"arm","core::arch","Platform-specific intrinsics for the `arm` platform.",N,N],[3,"int8x4_t","core::arch::arm","ARM-specific 32-bit wide vector of four packed `i8`.",N,N],[3,"uint8x4_t","","ARM-specific 32-bit wide vector of four packed `u8`.",N,N],[3,"int16x2_t","","ARM-specific 32-bit wide vector of two packed `i16`.",N,N],[3,"uint16x2_t","","ARM-specific 32-bit wide vector of two packed `u16`.",N,N],[3,"int8x8_t","","ARM-specific 64-bit wide vector of eight packed `i8`.",N,N],[3,"uint8x8_t","","ARM-specific 64-bit wide vector of eight packed `u8`.",N,N],[3,"poly8x8_t","","ARM-specific 64-bit wide polynomial vector of eight packed `u8`.",N,N],[3,"int16x4_t","","ARM-specific 64-bit wide vector of four packed `i16`.",N,N],[3,"uint16x4_t","","ARM-specific 64-bit wide vector of four packed `u16`.",N,N],[3,"poly16x4_t","","ARM-specific 64-bit wide vector of four packed `u16`.",N,N],[3,"int32x2_t","","ARM-specific 64-bit wide vector of two packed `i32`.",N,N],[3,"uint32x2_t","","ARM-specific 64-bit wide vector of two packed `u32`.",N,N],[3,"float32x2_t","","ARM-specific 64-bit wide vector of two packed `f32`.",N,N],[3,"int64x1_t","","ARM-specific 64-bit wide vector of one packed `i64`.",N,N],[3,"uint64x1_t","","ARM-specific 64-bit wide vector of one packed `u64`.",N,N],[3,"int8x16_t","","ARM-specific 128-bit wide vector of sixteen packed `i8`.",N,N],[3,"uint8x16_t","","ARM-specific 128-bit wide vector of sixteen packed `u8`.",N,N],[3,"poly8x16_t","","ARM-specific 128-bit wide vector of sixteen packed `u8`.",N,N],[3,"int16x8_t","","ARM-specific 128-bit wide vector of eight packed `i16`.",N,N],[3,"uint16x8_t","","ARM-specific 128-bit wide vector of eight packed `u16`.",N,N],[3,"poly16x8_t","","ARM-specific 128-bit wide vector of eight packed `u16`.",N,N],[3,"int32x4_t","","ARM-specific 128-bit wide vector of four packed `i32`.",N,N],[3,"uint32x4_t","","ARM-specific 128-bit wide vector of four packed `u32`.",N,N],[3,"float32x4_t","","ARM-specific 128-bit wide vector of four packed `f32`.",N,N],[3,"int64x2_t","","ARM-specific 128-bit wide vector of two packed `i64`.",N,N],[3,"uint64x2_t","","ARM-specific 128-bit wide vector of two packed `u64`.",N,N],[5,"__enable_irq","","Enable IRQ Interrupts",N,[[]]],[5,"__disable_irq","","Disable IRQ Interrupts",N,[[]]],[5,"__get_CONTROL","","Get Control Register",N,[[],["u32"]]],[5,"__set_CONTROL","","Set Control Register",N,[[["u32"]]]],[5,"__get_IPSR","","Get IPSR Register",N,[[],["u32"]]],[5,"__get_APSR","","Get APSR Register",N,[[],["u32"]]],[5,"__get_xPSR","","Get xPSR Register",N,[[],["u32"]]],[5,"__get_PSP","","Get Process Stack Pointer",N,[[],["u32"]]],[5,"__set_PSP","","Set Process Stack Pointer",N,[[["u32"]]]],[5,"__get_MSP","","Get Main Stack Pointer",N,[[],["u32"]]],[5,"__set_MSP","","Set Main Stack Pointer",N,[[["u32"]]]],[5,"__get_PRIMASK","","Get Priority Mask",N,[[],["u32"]]],[5,"__set_PRIMASK","","Set Priority Mask",N,[[["u32"]]]],[5,"__enable_fault_irq","","Enable FIQ",N,[[]]],[5,"__disable_fault_irq","","Disable FIQ",N,[[]]],[5,"__get_BASEPRI","","Get Base Priority",N,[[],["u32"]]],[5,"__set_BASEPRI","","Set Base Priority",N,[[["u32"]]]],[5,"__set_BASEPRI_MAX","","Set Base Priority with condition",N,[[["u32"]]]],[5,"__get_FAULTMASK","","Get Fault Mask",N,[[],["u32"]]],[5,"__set_FAULTMASK","","Set Fault Mask",N,[[["u32"]]]],[5,"__NOP","","No Operation",N,[[]]],[5,"__WFI","","Wait For Interrupt",N,[[]]],[5,"__WFE","","Wait For Event",N,[[]]],[5,"__SEV","","Send Event",N,[[]]],[5,"__ISB","","Instruction Synchronization Barrier",N,[[]]],[5,"__DSB","","Data Synchronization Barrier",N,[[]]],[5,"__DMB","","Data Memory Barrier",N,[[]]],[5,"_rev_u16","","Reverse the order of the bytes.",N,[[["u16"]],["u16"]]],[5,"_rev_u32","","Reverse the order of the bytes.",N,[[["u32"]],["u32"]]],[5,"qadd","","Signed saturating addition",N,[[["i32"],["i32"]],["i32"]]],[5,"qsub","","Signed saturating subtraction",N,[[["i32"],["i32"]],["i32"]]],[5,"qadd8","","Saturating four 8-bit integer additions",N,[[["int8x4_t"],["int8x4_t"]],["int8x4_t"]]],[5,"qsub8","","Saturating two 8-bit integer subtraction",N,[[["int8x4_t"],["int8x4_t"]],["int8x4_t"]]],[5,"qsub16","","Saturating two 16-bit integer subtraction",N,[[["int16x2_t"],["int16x2_t"]],["int16x2_t"]]],[5,"qadd16","","Saturating two 16-bit integer additions",N,[[["int16x2_t"],["int16x2_t"]],["int16x2_t"]]],[5,"qasx","","Returns the 16-bit signed saturated equivalent of",N,[[["int16x2_t"],["int16x2_t"]],["int16x2_t"]]],[5,"qsax","","Returns the 16-bit signed saturated equivalent of",N,[[["int16x2_t"],["int16x2_t"]],["int16x2_t"]]],[5,"sadd16","","Returns the 16-bit signed saturated equivalent of",N,[[["int16x2_t"],["int16x2_t"]],["int16x2_t"]]],[5,"sadd8","","Returns the 8-bit signed saturated equivalent of",N,[[["int8x4_t"],["int8x4_t"]],["int8x4_t"]]],[5,"sasx","","Returns the 16-bit signed equivalent of",N,[[["int16x2_t"],["int16x2_t"]],["int16x2_t"]]],[5,"sel","","Returns the equivalent of",N,[[["int8x4_t"],["int8x4_t"]],["int8x4_t"]]],[5,"shadd8","","Signed halving parallel byte-wise addition.",N,[[["int8x4_t"],["int8x4_t"]],["int8x4_t"]]],[5,"shadd16","","Signed halving parallel halfword-wise addition.",N,[[["int16x2_t"],["int16x2_t"]],["int16x2_t"]]],[5,"shsub8","","Signed halving parallel byte-wise subtraction.",N,[[["int8x4_t"],["int8x4_t"]],["int8x4_t"]]],[5,"shsub16","","Signed halving parallel halfword-wise subtraction.",N,[[["int16x2_t"],["int16x2_t"]],["int16x2_t"]]],[5,"smuad","","Signed Dual Multiply Add.",N,[[["int16x2_t"],["int16x2_t"]],["i32"]]],[5,"smuadx","","Signed Dual Multiply Add Reversed.",N,[[["int16x2_t"],["int16x2_t"]],["i32"]]],[5,"smusd","","Signed Dual Multiply Subtract.",N,[[["int16x2_t"],["int16x2_t"]],["i32"]]],[5,"smusdx","","Signed Dual Multiply Subtract Reversed.",N,[[["int16x2_t"],["int16x2_t"]],["i32"]]],[5,"vadd_s8","","Vector add.",N,[[["int8x8_t"],["int8x8_t"]],["int8x8_t"]]],[5,"vaddq_s8","","Vector add.",N,[[["int8x16_t"],["int8x16_t"]],["int8x16_t"]]],[5,"vadd_s16","","Vector add.",N,[[["int16x4_t"],["int16x4_t"]],["int16x4_t"]]],[5,"vaddq_s16","","Vector add.",N,[[["int16x8_t"],["int16x8_t"]],["int16x8_t"]]],[5,"vadd_s32","","Vector add.",N,[[["int32x2_t"],["int32x2_t"]],["int32x2_t"]]],[5,"vaddq_s32","","Vector add.",N,[[["int32x4_t"],["int32x4_t"]],["int32x4_t"]]],[5,"vaddq_s64","","Vector add.",N,[[["int64x2_t"],["int64x2_t"]],["int64x2_t"]]],[5,"vadd_u8","","Vector add.",N,[[["uint8x8_t"],["uint8x8_t"]],["uint8x8_t"]]],[5,"vaddq_u8","","Vector add.",N,[[["uint8x16_t"],["uint8x16_t"]],["uint8x16_t"]]],[5,"vadd_u16","","Vector add.",N,[[["uint16x4_t"],["uint16x4_t"]],["uint16x4_t"]]],[5,"vaddq_u16","","Vector add.",N,[[["uint16x8_t"],["uint16x8_t"]],["uint16x8_t"]]],[5,"vadd_u32","","Vector add.",N,[[["uint32x2_t"],["uint32x2_t"]],["uint32x2_t"]]],[5,"vaddq_u32","","Vector add.",N,[[["uint32x4_t"],["uint32x4_t"]],["uint32x4_t"]]],[5,"vaddq_u64","","Vector add.",N,[[["uint64x2_t"],["uint64x2_t"]],["uint64x2_t"]]],[5,"vadd_f32","","Vector add.",N,[[["float32x2_t"],["float32x2_t"]],["float32x2_t"]]],[5,"vaddq_f32","","Vector add.",N,[[["float32x4_t"],["float32x4_t"]],["float32x4_t"]]],[5,"vaddl_s8","","Vector long add.",N,[[["int8x8_t"],["int8x8_t"]],["int16x8_t"]]],[5,"vaddl_s16","","Vector long add.",N,[[["int16x4_t"],["int16x4_t"]],["int32x4_t"]]],[5,"vaddl_s32","","Vector long add.",N,[[["int32x2_t"],["int32x2_t"]],["int64x2_t"]]],[5,"vaddl_u8","","Vector long add.",N,[[["uint8x8_t"],["uint8x8_t"]],["uint16x8_t"]]],[5,"vaddl_u16","","Vector long add.",N,[[["uint16x4_t"],["uint16x4_t"]],["uint32x4_t"]]],[5,"vaddl_u32","","Vector long add.",N,[[["uint32x2_t"],["uint32x2_t"]],["uint64x2_t"]]],[5,"vmovn_s16","","Vector narrow integer.",N,[[["int16x8_t"]],["int8x8_t"]]],[5,"vmovn_s32","","Vector narrow integer.",N,[[["int32x4_t"]],["int16x4_t"]]],[5,"vmovn_s64","","Vector narrow integer.",N,[[["int64x2_t"]],["int32x2_t"]]],[5,"vmovn_u16","","Vector narrow integer.",N,[[["uint16x8_t"]],["uint8x8_t"]]],[5,"vmovn_u32","","Vector narrow integer.",N,[[["uint32x4_t"]],["uint16x4_t"]]],[5,"vmovn_u64","","Vector narrow integer.",N,[[["uint64x2_t"]],["uint32x2_t"]]],[5,"vmovl_s8","","Vector long move.",N,[[["int8x8_t"]],["int16x8_t"]]],[5,"vmovl_s16","","Vector long move.",N,[[["int16x4_t"]],["int32x4_t"]]],[5,"vmovl_s32","","Vector long move.",N,[[["int32x2_t"]],["int64x2_t"]]],[5,"vmovl_u8","","Vector long move.",N,[[["uint8x8_t"]],["uint16x8_t"]]],[5,"vmovl_u16","","Vector long move.",N,[[["uint16x4_t"]],["uint32x4_t"]]],[5,"vmovl_u32","","Vector long move.",N,[[["uint32x2_t"]],["uint64x2_t"]]],[5,"vrsqrte_f32","","Reciprocal square-root estimate.",N,[[["float32x2_t"]],["float32x2_t"]]],[5,"vpmin_s8","","Folding minimum of adjacent pairs",N,[[["int8x8_t"],["int8x8_t"]],["int8x8_t"]]],[5,"vpmin_s16","","Folding minimum of adjacent pairs",N,[[["int16x4_t"],["int16x4_t"]],["int16x4_t"]]],[5,"vpmin_s32","","Folding minimum of adjacent pairs",N,[[["int32x2_t"],["int32x2_t"]],["int32x2_t"]]],[5,"vpmin_u8","","Folding minimum of adjacent pairs",N,[[["uint8x8_t"],["uint8x8_t"]],["uint8x8_t"]]],[5,"vpmin_u16","","Folding minimum of adjacent pairs",N,[[["uint16x4_t"],["uint16x4_t"]],["uint16x4_t"]]],[5,"vpmin_u32","","Folding minimum of adjacent pairs",N,[[["uint32x2_t"],["uint32x2_t"]],["uint32x2_t"]]],[5,"vpmin_f32","","Folding minimum of adjacent pairs",N,[[["float32x2_t"],["float32x2_t"]],["float32x2_t"]]],[5,"vpmax_s8","","Folding maximum of adjacent pairs",N,[[["int8x8_t"],["int8x8_t"]],["int8x8_t"]]],[5,"vpmax_s16","","Folding maximum of adjacent pairs",N,[[["int16x4_t"],["int16x4_t"]],["int16x4_t"]]],[5,"vpmax_s32","","Folding maximum of adjacent pairs",N,[[["int32x2_t"],["int32x2_t"]],["int32x2_t"]]],[5,"vpmax_u8","","Folding maximum of adjacent pairs",N,[[["uint8x8_t"],["uint8x8_t"]],["uint8x8_t"]]],[5,"vpmax_u16","","Folding maximum of adjacent pairs",N,[[["uint16x4_t"],["uint16x4_t"]],["uint16x4_t"]]],[5,"vpmax_u32","","Folding maximum of adjacent pairs",N,[[["uint32x2_t"],["uint32x2_t"]],["uint32x2_t"]]],[5,"vpmax_f32","","Folding maximum of adjacent pairs",N,[[["float32x2_t"],["float32x2_t"]],["float32x2_t"]]],[0,"aarch64","core::arch","Platform-specific intrinsics for the `aarch64` platform.",N,N],[3,"float64x1_t","core::arch::aarch64","ARM-specific 64-bit wide vector of one packed `f64`.",N,N],[3,"float64x2_t","","ARM-specific 128-bit wide vector of two packed `f64`.",N,N],[3,"int8x4_t","","ARM-specific 32-bit wide vector of four packed `i8`.",N,N],[3,"uint8x4_t","","ARM-specific 32-bit wide vector of four packed `u8`.",N,N],[3,"int16x2_t","","ARM-specific 32-bit wide vector of two packed `i16`.",N,N],[3,"uint16x2_t","","ARM-specific 32-bit wide vector of two packed `u16`.",N,N],[3,"int8x8_t","","ARM-specific 64-bit wide vector of eight packed `i8`.",N,N],[3,"uint8x8_t","","ARM-specific 64-bit wide vector of eight packed `u8`.",N,N],[3,"poly8x8_t","","ARM-specific 64-bit wide polynomial vector of eight packed `u8`.",N,N],[3,"int16x4_t","","ARM-specific 64-bit wide vector of four packed `i16`.",N,N],[3,"uint16x4_t","","ARM-specific 64-bit wide vector of four packed `u16`.",N,N],[3,"poly16x4_t","","ARM-specific 64-bit wide vector of four packed `u16`.",N,N],[3,"int32x2_t","","ARM-specific 64-bit wide vector of two packed `i32`.",N,N],[3,"uint32x2_t","","ARM-specific 64-bit wide vector of two packed `u32`.",N,N],[3,"float32x2_t","","ARM-specific 64-bit wide vector of two packed `f32`.",N,N],[3,"int64x1_t","","ARM-specific 64-bit wide vector of one packed `i64`.",N,N],[3,"uint64x1_t","","ARM-specific 64-bit wide vector of one packed `u64`.",N,N],[3,"int8x16_t","","ARM-specific 128-bit wide vector of sixteen packed `i8`.",N,N],[3,"uint8x16_t","","ARM-specific 128-bit wide vector of sixteen packed `u8`.",N,N],[3,"poly8x16_t","","ARM-specific 128-bit wide vector of sixteen packed `u8`.",N,N],[3,"int16x8_t","","ARM-specific 128-bit wide vector of eight packed `i16`.",N,N],[3,"uint16x8_t","","ARM-specific 128-bit wide vector of eight packed `u16`.",N,N],[3,"poly16x8_t","","ARM-specific 128-bit wide vector of eight packed `u16`.",N,N],[3,"int32x4_t","","ARM-specific 128-bit wide vector of four packed `i32`.",N,N],[3,"uint32x4_t","","ARM-specific 128-bit wide vector of four packed `u32`.",N,N],[3,"float32x4_t","","ARM-specific 128-bit wide vector of four packed `f32`.",N,N],[3,"int64x2_t","","ARM-specific 128-bit wide vector of two packed `i64`.",N,N],[3,"uint64x2_t","","ARM-specific 128-bit wide vector of two packed `u64`.",N,N],[5,"_rev_u64","","Reverse the order of the bytes.",N,[[["u64"]],["u64"]]],[5,"_clz_u64","","Count Leading Zeros.",N,[[["u64"]],["u64"]]],[5,"_rbit_u64","","Reverse the bit order.",N,[[["u64"]],["u64"]]],[5,"_cls_u32","","Counts the leading most significant bits set.",N,[[["u32"]],["u32"]]],[5,"_cls_u64","","Counts the leading most significant bits set.",N,[[["u64"]],["u64"]]],[5,"vadd_f64","","Vector add.",N,[[["float64x1_t"],["float64x1_t"]],["float64x1_t"]]],[5,"vaddq_f64","","Vector add.",N,[[["float64x2_t"],["float64x2_t"]],["float64x2_t"]]],[5,"vaddd_s64","","Vector add.",N,[[["int64x1_t"],["int64x1_t"]],["int64x1_t"]]],[5,"vaddd_u64","","Vector add.",N,[[["uint64x1_t"],["uint64x1_t"]],["uint64x1_t"]]],[5,"vmaxv_s8","","Horizontal vector max.",N,[[["int8x8_t"]],["i8"]]],[5,"vmaxvq_s8","","Horizontal vector max.",N,[[["int8x16_t"]],["i8"]]],[5,"vmaxv_s16","","Horizontal vector max.",N,[[["int16x4_t"]],["i16"]]],[5,"vmaxvq_s16","","Horizontal vector max.",N,[[["int16x8_t"]],["i16"]]],[5,"vmaxv_s32","","Horizontal vector max.",N,[[["int32x2_t"]],["i32"]]],[5,"vmaxvq_s32","","Horizontal vector max.",N,[[["int32x4_t"]],["i32"]]],[5,"vmaxv_u8","","Horizontal vector max.",N,[[["uint8x8_t"]],["u8"]]],[5,"vmaxvq_u8","","Horizontal vector max.",N,[[["uint8x16_t"]],["u8"]]],[5,"vmaxv_u16","","Horizontal vector max.",N,[[["uint16x4_t"]],["u16"]]],[5,"vmaxvq_u16","","Horizontal vector max.",N,[[["uint16x8_t"]],["u16"]]],[5,"vmaxv_u32","","Horizontal vector max.",N,[[["uint32x2_t"]],["u32"]]],[5,"vmaxvq_u32","","Horizontal vector max.",N,[[["uint32x4_t"]],["u32"]]],[5,"vmaxv_f32","","Horizontal vector max.",N,[[["float32x2_t"]],["f32"]]],[5,"vmaxvq_f32","","Horizontal vector max.",N,[[["float32x4_t"]],["f32"]]],[5,"vmaxvq_f64","","Horizontal vector max.",N,[[["float64x2_t"]],["f64"]]],[5,"vminv_s8","","Horizontal vector min.",N,[[["int8x8_t"]],["i8"]]],[5,"vminvq_s8","","Horizontal vector min.",N,[[["int8x16_t"]],["i8"]]],[5,"vminv_s16","","Horizontal vector min.",N,[[["int16x4_t"]],["i16"]]],[5,"vminvq_s16","","Horizontal vector min.",N,[[["int16x8_t"]],["i16"]]],[5,"vminv_s32","","Horizontal vector min.",N,[[["int32x2_t"]],["i32"]]],[5,"vminvq_s32","","Horizontal vector min.",N,[[["int32x4_t"]],["i32"]]],[5,"vminv_u8","","Horizontal vector min.",N,[[["uint8x8_t"]],["u8"]]],[5,"vminvq_u8","","Horizontal vector min.",N,[[["uint8x16_t"]],["u8"]]],[5,"vminv_u16","","Horizontal vector min.",N,[[["uint16x4_t"]],["u16"]]],[5,"vminvq_u16","","Horizontal vector min.",N,[[["uint16x8_t"]],["u16"]]],[5,"vminv_u32","","Horizontal vector min.",N,[[["uint32x2_t"]],["u32"]]],[5,"vminvq_u32","","Horizontal vector min.",N,[[["uint32x4_t"]],["u32"]]],[5,"vminv_f32","","Horizontal vector min.",N,[[["float32x2_t"]],["f32"]]],[5,"vminvq_f32","","Horizontal vector min.",N,[[["float32x4_t"]],["f32"]]],[5,"vminvq_f64","","Horizontal vector min.",N,[[["float64x2_t"]],["f64"]]],[5,"vpminq_s8","","Folding minimum of adjacent pairs",N,[[["int8x16_t"],["int8x16_t"]],["int8x16_t"]]],[5,"vpminq_s16","","Folding minimum of adjacent pairs",N,[[["int16x8_t"],["int16x8_t"]],["int16x8_t"]]],[5,"vpminq_s32","","Folding minimum of adjacent pairs",N,[[["int32x4_t"],["int32x4_t"]],["int32x4_t"]]],[5,"vpminq_u8","","Folding minimum of adjacent pairs",N,[[["uint8x16_t"],["uint8x16_t"]],["uint8x16_t"]]],[5,"vpminq_u16","","Folding minimum of adjacent pairs",N,[[["uint16x8_t"],["uint16x8_t"]],["uint16x8_t"]]],[5,"vpminq_u32","","Folding minimum of adjacent pairs",N,[[["uint32x4_t"],["uint32x4_t"]],["uint32x4_t"]]],[5,"vpminq_f32","","Folding minimum of adjacent pairs",N,[[["float32x4_t"],["float32x4_t"]],["float32x4_t"]]],[5,"vpminq_f64","","Folding minimum of adjacent pairs",N,[[["float64x2_t"],["float64x2_t"]],["float64x2_t"]]],[5,"vpmaxq_s8","","Folding maximum of adjacent pairs",N,[[["int8x16_t"],["int8x16_t"]],["int8x16_t"]]],[5,"vpmaxq_s16","","Folding maximum of adjacent pairs",N,[[["int16x8_t"],["int16x8_t"]],["int16x8_t"]]],[5,"vpmaxq_s32","","Folding maximum of adjacent pairs",N,[[["int32x4_t"],["int32x4_t"]],["int32x4_t"]]],[5,"vpmaxq_u8","","Folding maximum of adjacent pairs",N,[[["uint8x16_t"],["uint8x16_t"]],["uint8x16_t"]]],[5,"vpmaxq_u16","","Folding maximum of adjacent pairs",N,[[["uint16x8_t"],["uint16x8_t"]],["uint16x8_t"]]],[5,"vpmaxq_u32","","Folding maximum of adjacent pairs",N,[[["uint32x4_t"],["uint32x4_t"]],["uint32x4_t"]]],[5,"vpmaxq_f32","","Folding maximum of adjacent pairs",N,[[["float32x4_t"],["float32x4_t"]],["float32x4_t"]]],[5,"vpmaxq_f64","","Folding maximum of adjacent pairs",N,[[["float64x2_t"],["float64x2_t"]],["float64x2_t"]]],[5,"vaeseq_u8","","AES single round encryption.",N,[[["uint8x16_t"],["uint8x16_t"]],["uint8x16_t"]]],[5,"vaesdq_u8","","AES single round decryption.",N,[[["uint8x16_t"],["uint8x16_t"]],["uint8x16_t"]]],[5,"vaesmcq_u8","","AES mix columns.",N,[[["uint8x16_t"]],["uint8x16_t"]]],[5,"vaesimcq_u8","","AES inverse mix columns.",N,[[["uint8x16_t"]],["uint8x16_t"]]],[5,"vsha1h_u32","","SHA1 fixed rotate.",N,[[["u32"]],["u32"]]],[5,"vsha1cq_u32","","SHA1 hash update accelerator, choose.",N,[[["uint32x4_t"],["u32"],["uint32x4_t"]],["uint32x4_t"]]],[5,"vsha1mq_u32","","SHA1 hash update accelerator, majority.",N,[[["uint32x4_t"],["u32"],["uint32x4_t"]],["uint32x4_t"]]],[5,"vsha1pq_u32","","SHA1 hash update accelerator, parity.",N,[[["uint32x4_t"],["u32"],["uint32x4_t"]],["uint32x4_t"]]],[5,"vsha1su0q_u32","","SHA1 schedule update accelerator, first part.",N,[[["uint32x4_t"],["uint32x4_t"],["uint32x4_t"]],["uint32x4_t"]]],[5,"vsha1su1q_u32","","SHA1 schedule update accelerator, second part.",N,[[["uint32x4_t"],["uint32x4_t"]],["uint32x4_t"]]],[5,"vsha256hq_u32","","SHA256 hash update accelerator.",N,[[["uint32x4_t"],["uint32x4_t"],["uint32x4_t"]],["uint32x4_t"]]],[5,"vsha256h2q_u32","","SHA256 hash update accelerator, upper part.",N,[[["uint32x4_t"],["uint32x4_t"],["uint32x4_t"]],["uint32x4_t"]]],[5,"vsha256su0q_u32","","SHA256 schedule update accelerator, first part.",N,[[["uint32x4_t"],["uint32x4_t"]],["uint32x4_t"]]],[5,"vsha256su1q_u32","","SHA256 schedule update accelerator, second part.",N,[[["uint32x4_t"],["uint32x4_t"],["uint32x4_t"]],["uint32x4_t"]]],[5,"__enable_irq","","Enable IRQ Interrupts",N,[[]]],[5,"__disable_irq","","Disable IRQ Interrupts",N,[[]]],[5,"__get_CONTROL","","Get Control Register",N,[[],["u32"]]],[5,"__set_CONTROL","","Set Control Register",N,[[["u32"]]]],[5,"__get_IPSR","","Get IPSR Register",N,[[],["u32"]]],[5,"__get_APSR","","Get APSR Register",N,[[],["u32"]]],[5,"__get_xPSR","","Get xPSR Register",N,[[],["u32"]]],[5,"__get_PSP","","Get Process Stack Pointer",N,[[],["u32"]]],[5,"__set_PSP","","Set Process Stack Pointer",N,[[["u32"]]]],[5,"__get_MSP","","Get Main Stack Pointer",N,[[],["u32"]]],[5,"__set_MSP","","Set Main Stack Pointer",N,[[["u32"]]]],[5,"__get_PRIMASK","","Get Priority Mask",N,[[],["u32"]]],[5,"__set_PRIMASK","","Set Priority Mask",N,[[["u32"]]]],[5,"__enable_fault_irq","","Enable FIQ",N,[[]]],[5,"__disable_fault_irq","","Disable FIQ",N,[[]]],[5,"__get_BASEPRI","","Get Base Priority",N,[[],["u32"]]],[5,"__set_BASEPRI","","Set Base Priority",N,[[["u32"]]]],[5,"__set_BASEPRI_MAX","","Set Base Priority with condition",N,[[["u32"]]]],[5,"__get_FAULTMASK","","Get Fault Mask",N,[[],["u32"]]],[5,"__set_FAULTMASK","","Set Fault Mask",N,[[["u32"]]]],[5,"__NOP","","No Operation",N,[[]]],[5,"__WFI","","Wait For Interrupt",N,[[]]],[5,"__WFE","","Wait For Event",N,[[]]],[5,"__SEV","","Send Event",N,[[]]],[5,"__ISB","","Instruction Synchronization Barrier",N,[[]]],[5,"__DSB","","Data Synchronization Barrier",N,[[]]],[5,"__DMB","","Data Memory Barrier",N,[[]]],[5,"_rev_u16","","Reverse the order of the bytes.",N,[[["u16"]],["u16"]]],[5,"_rev_u32","","Reverse the order of the bytes.",N,[[["u32"]],["u32"]]],[5,"qadd","","Signed saturating addition",N,[[["i32"],["i32"]],["i32"]]],[5,"qsub","","Signed saturating subtraction",N,[[["i32"],["i32"]],["i32"]]],[5,"qadd8","","Saturating four 8-bit integer additions",N,[[["int8x4_t"],["int8x4_t"]],["int8x4_t"]]],[5,"qsub8","","Saturating two 8-bit integer subtraction",N,[[["int8x4_t"],["int8x4_t"]],["int8x4_t"]]],[5,"qsub16","","Saturating two 16-bit integer subtraction",N,[[["int16x2_t"],["int16x2_t"]],["int16x2_t"]]],[5,"qadd16","","Saturating two 16-bit integer additions",N,[[["int16x2_t"],["int16x2_t"]],["int16x2_t"]]],[5,"qasx","","Returns the 16-bit signed saturated equivalent of",N,[[["int16x2_t"],["int16x2_t"]],["int16x2_t"]]],[5,"qsax","","Returns the 16-bit signed saturated equivalent of",N,[[["int16x2_t"],["int16x2_t"]],["int16x2_t"]]],[5,"sadd16","","Returns the 16-bit signed saturated equivalent of",N,[[["int16x2_t"],["int16x2_t"]],["int16x2_t"]]],[5,"sadd8","","Returns the 8-bit signed saturated equivalent of",N,[[["int8x4_t"],["int8x4_t"]],["int8x4_t"]]],[5,"sasx","","Returns the 16-bit signed equivalent of",N,[[["int16x2_t"],["int16x2_t"]],["int16x2_t"]]],[5,"sel","","Returns the equivalent of",N,[[["int8x4_t"],["int8x4_t"]],["int8x4_t"]]],[5,"shadd8","","Signed halving parallel byte-wise addition.",N,[[["int8x4_t"],["int8x4_t"]],["int8x4_t"]]],[5,"shadd16","","Signed halving parallel halfword-wise addition.",N,[[["int16x2_t"],["int16x2_t"]],["int16x2_t"]]],[5,"shsub8","","Signed halving parallel byte-wise subtraction.",N,[[["int8x4_t"],["int8x4_t"]],["int8x4_t"]]],[5,"shsub16","","Signed halving parallel halfword-wise subtraction.",N,[[["int16x2_t"],["int16x2_t"]],["int16x2_t"]]],[5,"smuad","","Signed Dual Multiply Add.",N,[[["int16x2_t"],["int16x2_t"]],["i32"]]],[5,"smuadx","","Signed Dual Multiply Add Reversed.",N,[[["int16x2_t"],["int16x2_t"]],["i32"]]],[5,"smusd","","Signed Dual Multiply Subtract.",N,[[["int16x2_t"],["int16x2_t"]],["i32"]]],[5,"smusdx","","Signed Dual Multiply Subtract Reversed.",N,[[["int16x2_t"],["int16x2_t"]],["i32"]]],[5,"vadd_s8","","Vector add.",N,[[["int8x8_t"],["int8x8_t"]],["int8x8_t"]]],[5,"vaddq_s8","","Vector add.",N,[[["int8x16_t"],["int8x16_t"]],["int8x16_t"]]],[5,"vadd_s16","","Vector add.",N,[[["int16x4_t"],["int16x4_t"]],["int16x4_t"]]],[5,"vaddq_s16","","Vector add.",N,[[["int16x8_t"],["int16x8_t"]],["int16x8_t"]]],[5,"vadd_s32","","Vector add.",N,[[["int32x2_t"],["int32x2_t"]],["int32x2_t"]]],[5,"vaddq_s32","","Vector add.",N,[[["int32x4_t"],["int32x4_t"]],["int32x4_t"]]],[5,"vaddq_s64","","Vector add.",N,[[["int64x2_t"],["int64x2_t"]],["int64x2_t"]]],[5,"vadd_u8","","Vector add.",N,[[["uint8x8_t"],["uint8x8_t"]],["uint8x8_t"]]],[5,"vaddq_u8","","Vector add.",N,[[["uint8x16_t"],["uint8x16_t"]],["uint8x16_t"]]],[5,"vadd_u16","","Vector add.",N,[[["uint16x4_t"],["uint16x4_t"]],["uint16x4_t"]]],[5,"vaddq_u16","","Vector add.",N,[[["uint16x8_t"],["uint16x8_t"]],["uint16x8_t"]]],[5,"vadd_u32","","Vector add.",N,[[["uint32x2_t"],["uint32x2_t"]],["uint32x2_t"]]],[5,"vaddq_u32","","Vector add.",N,[[["uint32x4_t"],["uint32x4_t"]],["uint32x4_t"]]],[5,"vaddq_u64","","Vector add.",N,[[["uint64x2_t"],["uint64x2_t"]],["uint64x2_t"]]],[5,"vadd_f32","","Vector add.",N,[[["float32x2_t"],["float32x2_t"]],["float32x2_t"]]],[5,"vaddq_f32","","Vector add.",N,[[["float32x4_t"],["float32x4_t"]],["float32x4_t"]]],[5,"vaddl_s8","","Vector long add.",N,[[["int8x8_t"],["int8x8_t"]],["int16x8_t"]]],[5,"vaddl_s16","","Vector long add.",N,[[["int16x4_t"],["int16x4_t"]],["int32x4_t"]]],[5,"vaddl_s32","","Vector long add.",N,[[["int32x2_t"],["int32x2_t"]],["int64x2_t"]]],[5,"vaddl_u8","","Vector long add.",N,[[["uint8x8_t"],["uint8x8_t"]],["uint16x8_t"]]],[5,"vaddl_u16","","Vector long add.",N,[[["uint16x4_t"],["uint16x4_t"]],["uint32x4_t"]]],[5,"vaddl_u32","","Vector long add.",N,[[["uint32x2_t"],["uint32x2_t"]],["uint64x2_t"]]],[5,"vmovn_s16","","Vector narrow integer.",N,[[["int16x8_t"]],["int8x8_t"]]],[5,"vmovn_s32","","Vector narrow integer.",N,[[["int32x4_t"]],["int16x4_t"]]],[5,"vmovn_s64","","Vector narrow integer.",N,[[["int64x2_t"]],["int32x2_t"]]],[5,"vmovn_u16","","Vector narrow integer.",N,[[["uint16x8_t"]],["uint8x8_t"]]],[5,"vmovn_u32","","Vector narrow integer.",N,[[["uint32x4_t"]],["uint16x4_t"]]],[5,"vmovn_u64","","Vector narrow integer.",N,[[["uint64x2_t"]],["uint32x2_t"]]],[5,"vmovl_s8","","Vector long move.",N,[[["int8x8_t"]],["int16x8_t"]]],[5,"vmovl_s16","","Vector long move.",N,[[["int16x4_t"]],["int32x4_t"]]],[5,"vmovl_s32","","Vector long move.",N,[[["int32x2_t"]],["int64x2_t"]]],[5,"vmovl_u8","","Vector long move.",N,[[["uint8x8_t"]],["uint16x8_t"]]],[5,"vmovl_u16","","Vector long move.",N,[[["uint16x4_t"]],["uint32x4_t"]]],[5,"vmovl_u32","","Vector long move.",N,[[["uint32x2_t"]],["uint64x2_t"]]],[5,"vrsqrte_f32","","Reciprocal square-root estimate.",N,[[["float32x2_t"]],["float32x2_t"]]],[5,"vpmin_s8","","Folding minimum of adjacent pairs",N,[[["int8x8_t"],["int8x8_t"]],["int8x8_t"]]],[5,"vpmin_s16","","Folding minimum of adjacent pairs",N,[[["int16x4_t"],["int16x4_t"]],["int16x4_t"]]],[5,"vpmin_s32","","Folding minimum of adjacent pairs",N,[[["int32x2_t"],["int32x2_t"]],["int32x2_t"]]],[5,"vpmin_u8","","Folding minimum of adjacent pairs",N,[[["uint8x8_t"],["uint8x8_t"]],["uint8x8_t"]]],[5,"vpmin_u16","","Folding minimum of adjacent pairs",N,[[["uint16x4_t"],["uint16x4_t"]],["uint16x4_t"]]],[5,"vpmin_u32","","Folding minimum of adjacent pairs",N,[[["uint32x2_t"],["uint32x2_t"]],["uint32x2_t"]]],[5,"vpmin_f32","","Folding minimum of adjacent pairs",N,[[["float32x2_t"],["float32x2_t"]],["float32x2_t"]]],[5,"vpmax_s8","","Folding maximum of adjacent pairs",N,[[["int8x8_t"],["int8x8_t"]],["int8x8_t"]]],[5,"vpmax_s16","","Folding maximum of adjacent pairs",N,[[["int16x4_t"],["int16x4_t"]],["int16x4_t"]]],[5,"vpmax_s32","","Folding maximum of adjacent pairs",N,[[["int32x2_t"],["int32x2_t"]],["int32x2_t"]]],[5,"vpmax_u8","","Folding maximum of adjacent pairs",N,[[["uint8x8_t"],["uint8x8_t"]],["uint8x8_t"]]],[5,"vpmax_u16","","Folding maximum of adjacent pairs",N,[[["uint16x4_t"],["uint16x4_t"]],["uint16x4_t"]]],[5,"vpmax_u32","","Folding maximum of adjacent pairs",N,[[["uint32x2_t"],["uint32x2_t"]],["uint32x2_t"]]],[5,"vpmax_f32","","Folding maximum of adjacent pairs",N,[[["float32x2_t"],["float32x2_t"]],["float32x2_t"]]],[0,"mips","core::arch","Platform-specific intrinsics for the `mips` platform.",N,N],[3,"i8x16","core::arch::mips","MIPS-specific 128-bit wide vector of 16 packed `i8`.",N,N],[5,"__msa_add_a_b","","Vector Add Absolute Values.",N,[[["i8x16"],["i8x16"]],["i8x16"]]],[0,"mips64","core::arch","Platform-specific intrinsics for the `mips64` platform.",N,N],[3,"i8x16","core::arch::mips64","MIPS-specific 128-bit wide vector of 16 packed `i8`.",N,N],[5,"__msa_add_a_b","","Vector Add Absolute Values.",N,[[["i8x16"],["i8x16"]],["i8x16"]]],[0,"powerpc","core::arch","Platform-specific intrinsics for the `PowerPC` platform.",N,N],[0,"powerpc64","","Platform-specific intrinsics for the `PowerPC64` platform.",N,N],[3,"vector_signed_long","core::arch::powerpc64","PowerPC-specific 128-bit wide vector of two packed `i64`",N,N],[3,"vector_unsigned_long","","PowerPC-specific 128-bit wide vector of two packed `u64`",N,N],[3,"vector_bool_long","","PowerPC-specific 128-bit wide vector mask of two elements",N,N],[3,"vector_double","","PowerPC-specific 128-bit wide vector of two packed `f64`",N,N],[5,"vec_xxpermdi","","Vector permute.",N,[[["t"],["t"],["u8"]],["t"]]],[14,"panic","core","Entry point of thread panic, for details, see std::macros",N,N],[14,"assert_eq","","Asserts that two expressions are equal to each other (using [`PartialEq`]).",N,N],[14,"assert_ne","","Asserts that two expressions are not equal to each other (using [`PartialEq`]).",N,N],[14,"debug_assert","","Ensure that a boolean expression is `true` at runtime.",N,N],[14,"debug_assert_eq","","Asserts that two expressions are equal to each other.",N,N],[14,"debug_assert_ne","","Asserts that two expressions are not equal to each other.",N,N],[14,"try","","Helper macro for reducing boilerplate code for matching `Result` together with converting downstream errors.",N,N],[14,"write","","Write formatted data into a buffer.",N,N],[14,"writeln","","Write formatted data into a buffer, with a newline appended.",N,N],[14,"unreachable","","A utility macro for indicating unreachable code.",N,N],[14,"unimplemented","","A standardized placeholder for marking unfinished code.",N,N],[14,"compile_error","","Unconditionally causes compilation to fail with the given error message when encountered.",N,N],[14,"format_args","","The core macro for formatted string creation & output.",N,N],[14,"env","","Inspect an environment variable at compile time.",N,N],[14,"option_env","","Optionally inspect an environment variable at compile time.",N,N],[14,"concat_idents","","Concatenate identifiers into one identifier.",N,N],[14,"concat","","Concatenates literals into a static string slice.",N,N],[14,"line","","A macro which expands to the line number on which it was invoked.",N,N],[14,"column","","A macro which expands to the column number on which it was invoked.",N,N],[14,"file","","A macro which expands to the file name from which it was invoked.",N,N],[14,"stringify","","A macro which stringifies its arguments.",N,N],[14,"include_str","","Includes a utf8-encoded file as a string.",N,N],[14,"include_bytes","","Includes a file as a reference to a byte array.",N,N],[14,"module_path","","Expands to a string that represents the current module path.",N,N],[14,"cfg","","Boolean evaluation of configuration flags, at compile-time.",N,N],[14,"include","","Parse a file as an expression or an item according to the context.",N,N],[14,"assert","","Ensure that a boolean expression is `true` at runtime.",N,N],[11,"contains","core::ops","Returns `true` if `item` is contained in the range.",55,[[["self"],["u"]],["bool"]]],[11,"size_hint","core::iter","Returns the bounds on the remaining length of the iterator.",116,N],[11,"count","","Consumes the iterator, counting the number of iterations and returning it.",116,[[["self"]],["usize"]]],[11,"last","","Consumes the iterator, returning the last element.",116,[[["self"]],["option"]]],[11,"nth","","Returns the `n`th element of the iterator.",116,[[["self"],["usize"]],["option"]]],[11,"step_by","","Creates an iterator starting at the same point, but stepping by the given amount at each iteration.",116,[[["self"],["usize"]],["stepby"]]],[11,"chain","","Takes two iterators and creates a new iterator over both in sequence.",116,[[["self"],["u"]],["chain"]]],[11,"zip","","'Zips up' two iterators into a single iterator of pairs.",116,[[["self"],["u"]],["zip"]]],[11,"map","","Takes a closure and creates an iterator which calls that closure on each element.",116,[[["self"],["f"]],["map"]]],[11,"for_each","","Calls a closure on each element of an iterator.",116,[[["self"],["f"]]]],[11,"filter","","Creates an iterator which uses a closure to determine if an element should be yielded.",116,[[["self"],["p"]],["filter"]]],[11,"filter_map","","Creates an iterator that both filters and maps.",116,[[["self"],["f"]],["filtermap"]]],[11,"enumerate","","Creates an iterator which gives the current iteration count as well as the next value.",116,[[["self"]],["enumerate"]]],[11,"peekable","","Creates an iterator which can use `peek` to look at the next element of the iterator without consuming it.",116,[[["self"]],["peekable"]]],[11,"skip_while","","Creates an iterator that [`skip`]s elements based on a predicate.",116,[[["self"],["p"]],["skipwhile"]]],[11,"take_while","","Creates an iterator that yields elements based on a predicate.",116,[[["self"],["p"]],["takewhile"]]],[11,"skip","","Creates an iterator that skips the first `n` elements.",116,[[["self"],["usize"]],["skip"]]],[11,"take","","Creates an iterator that yields its first `n` elements.",116,[[["self"],["usize"]],["take"]]],[11,"scan","","An iterator adaptor similar to [`fold`] that holds internal state and produces a new iterator.",116,[[["self"],["st"],["f"]],["scan"]]],[11,"flat_map","","Creates an iterator that works like map, but flattens nested structure.",116,[[["self"],["f"]],["flatmap"]]],[11,"flatten","","Creates an iterator that flattens nested structure.",116,[[["self"]],["flatten"]]],[11,"fuse","","Creates an iterator which ends after the first [`None`].",116,[[["self"]],["fuse"]]],[11,"inspect","","Do something with each element of an iterator, passing the value on.",116,[[["self"],["f"]],["inspect"]]],[11,"by_ref","","Borrows an iterator, rather than consuming it.",116,[[["self"]],["self"]]],[11,"collect","","Transforms an iterator into a collection.",116,[[["self"]],["b"]]],[11,"partition","","Consumes an iterator, creating two collections from it.",116,N],[11,"try_fold","","An iterator method that applies a function as long as it returns successfully, producing a single, final value.",116,[[["self"],["b"],["f"]],["r"]]],[11,"try_for_each","","An iterator method that applies a fallible function to each item in the iterator, stopping at the first error and returning that error.",116,[[["self"],["f"]],["r"]]],[11,"fold","","An iterator method that applies a function, producing a single, final value.",116,[[["self"],["b"],["f"]],["b"]]],[11,"all","","Tests if every element of the iterator matches a predicate.",116,[[["self"],["f"]],["bool"]]],[11,"any","","Tests if any element of the iterator matches a predicate.",116,[[["self"],["f"]],["bool"]]],[11,"find","","Searches for an element of an iterator that satisfies a predicate.",116,[[["self"],["p"]],["option"]]],[11,"find_map","","Applies function to the elements of iterator and returns the first non-none result.",116,[[["self"],["f"]],["option"]]],[11,"position","","Searches for an element in an iterator, returning its index.",116,[[["self"],["p"]],["option",["usize"]]]],[11,"rposition","","Searches for an element in an iterator from the right, returning its index.",116,[[["self"],["p"]],["option",["usize"]]]],[11,"max","","Returns the maximum element of an iterator.",116,[[["self"]],["option"]]],[11,"min","","Returns the minimum element of an iterator.",116,[[["self"]],["option"]]],[11,"max_by_key","","Returns the element that gives the maximum value from the specified function.",116,[[["self"],["f"]],["option"]]],[11,"max_by","","Returns the element that gives the maximum value with respect to the specified comparison function.",116,[[["self"],["f"]],["option"]]],[11,"min_by_key","","Returns the element that gives the minimum value from the specified function.",116,[[["self"],["f"]],["option"]]],[11,"min_by","","Returns the element that gives the minimum value with respect to the specified comparison function.",116,[[["self"],["f"]],["option"]]],[11,"rev","","Reverses an iterator's direction.",116,[[["self"]],["rev"]]],[11,"unzip","","Converts an iterator of pairs into a pair of containers.",116,N],[11,"cloned","","Creates an iterator which [`clone`]s all of its elements.",116,[[["self"]],["cloned"]]],[11,"cycle","","Repeats an iterator endlessly.",116,[[["self"]],["cycle"]]],[11,"sum","","Sums the elements of an iterator.",116,[[["self"]],["s"]]],[11,"product","","Iterates over the entire iterator, multiplying all the elements",116,[[["self"]],["p"]]],[11,"cmp","","Lexicographically compares the elements of this `Iterator` with those of another.",116,[[["self"],["i"]],["ordering"]]],[11,"partial_cmp","","Lexicographically compares the elements of this `Iterator` with those of another.",116,[[["self"],["i"]],["option",["ordering"]]]],[11,"eq","","Determines if the elements of this `Iterator` are equal to those of another.",116,[[["self"],["i"]],["bool"]]],[11,"ne","","Determines if the elements of this `Iterator` are unequal to those of another.",116,[[["self"],["i"]],["bool"]]],[11,"lt","","Determines if the elements of this `Iterator` are lexicographically less than those of another.",116,[[["self"],["i"]],["bool"]]],[11,"le","","Determines if the elements of this `Iterator` are lexicographically less or equal to those of another.",116,[[["self"],["i"]],["bool"]]],[11,"gt","","Determines if the elements of this `Iterator` are lexicographically greater than those of another.",116,[[["self"],["i"]],["bool"]]],[11,"ge","","Determines if the elements of this `Iterator` are lexicographically greater than or equal to those of another.",116,[[["self"],["i"]],["bool"]]],[11,"try_rfold","","This is the reverse version of [`try_fold()`]: it takes elements starting from the back of the iterator.",120,[[["self"],["b"],["f"]],["r"]]],[11,"rfold","","An iterator method that reduces the iterator's elements to a single, final value, starting from the back.",120,[[["self"],["b"],["f"]],["b"]]],[11,"rfind","","Searches for an element of an iterator from the back that satisfies a predicate.",120,[[["self"],["p"]],["option"]]],[11,"len","","Returns the exact number of times the iterator will iterate.",122,[[["self"]],["usize"]]],[11,"is_empty","","Returns whether the iterator is empty.",122,[[["self"]],["bool"]]],[11,"sum","core::result","Takes each element in the `Iterator`: if it is an `Err`, no further elements are taken, and the `Err` is returned. Should no `Err` occur, the sum of all elements is returned.",151,[[["i"]],["result"]]],[11,"product","","Takes each element in the `Iterator`: if it is an `Err`, no further elements are taken, and the `Err` is returned. Should no `Err` occur, the product of all elements is returned.",151,[[["i"]],["result"]]],[11,"status","core::task","Determines whether the executor is able to spawn new tasks.",239,[[["self"]],["result",["spawnerrorkind"]]]],[11,"wake_local","","Indicates that the associated task is ready to make progress and should be `poll`ed. This function is the same as `wake`, but can only be called from the thread that this `UnsafeWake` is \"local\" to. This allows for implementors to provide specialized wakeup behavior specific to the current thread. This function is called by `LocalWaker::wake`.",240,[[["self"]]]],[11,"clone","core::arch::x86","",248,[[["self"]],["cpuidresult"]]],[11,"cmp","","",248,[[["self"],["cpuidresult"]],["ordering"]]],[11,"eq","","",248,[[["self"],["cpuidresult"]],["bool"]]],[11,"ne","","",248,[[["self"],["cpuidresult"]],["bool"]]],[11,"partial_cmp","","",248,[[["self"],["cpuidresult"]],["option",["ordering"]]]],[11,"lt","","",248,[[["self"],["cpuidresult"]],["bool"]]],[11,"le","","",248,[[["self"],["cpuidresult"]],["bool"]]],[11,"gt","","",248,[[["self"],["cpuidresult"]],["bool"]]],[11,"ge","","",248,[[["self"],["cpuidresult"]],["bool"]]],[11,"clone","","",249,[[["self"]],["__m64"]]],[11,"fmt","","",249,[[["self"],["formatter"]],["result"]]],[11,"clone","","",250,[[["self"]],["__m128i"]]],[11,"fmt","","",250,[[["self"],["formatter"]],["result"]]],[11,"clone","","",251,[[["self"]],["__m128"]]],[11,"fmt","","",251,[[["self"],["formatter"]],["result"]]],[11,"clone","","",252,[[["self"]],["__m128d"]]],[11,"fmt","","",252,[[["self"],["formatter"]],["result"]]],[11,"clone","","",253,[[["self"]],["__m256i"]]],[11,"fmt","","",253,[[["self"],["formatter"]],["result"]]],[11,"clone","","",254,[[["self"]],["__m256"]]],[11,"fmt","","",254,[[["self"],["formatter"]],["result"]]],[11,"clone","","",255,[[["self"]],["__m256d"]]],[11,"fmt","","",255,[[["self"],["formatter"]],["result"]]],[11,"clone","core::arch::aarch64","",256,[[["self"]],["float64x1_t"]]],[11,"fmt","","",256,[[["self"],["formatter"]],["result"]]],[11,"clone","","",257,[[["self"]],["float64x2_t"]]],[11,"fmt","","",257,[[["self"],["formatter"]],["result"]]],[11,"clone","core::arch::arm","",258,[[["self"]],["int8x4_t"]]],[11,"fmt","","",258,[[["self"],["formatter"]],["result"]]],[11,"clone","","",259,[[["self"]],["uint8x4_t"]]],[11,"fmt","","",259,[[["self"],["formatter"]],["result"]]],[11,"clone","","",260,[[["self"]],["int16x2_t"]]],[11,"fmt","","",260,[[["self"],["formatter"]],["result"]]],[11,"clone","","",261,[[["self"]],["uint16x2_t"]]],[11,"fmt","","",261,[[["self"],["formatter"]],["result"]]],[11,"clone","","",262,[[["self"]],["int8x8_t"]]],[11,"fmt","","",262,[[["self"],["formatter"]],["result"]]],[11,"clone","","",263,[[["self"]],["uint8x8_t"]]],[11,"fmt","","",263,[[["self"],["formatter"]],["result"]]],[11,"clone","","",264,[[["self"]],["poly8x8_t"]]],[11,"fmt","","",264,[[["self"],["formatter"]],["result"]]],[11,"clone","","",265,[[["self"]],["int16x4_t"]]],[11,"fmt","","",265,[[["self"],["formatter"]],["result"]]],[11,"clone","","",266,[[["self"]],["uint16x4_t"]]],[11,"fmt","","",266,[[["self"],["formatter"]],["result"]]],[11,"clone","","",267,[[["self"]],["poly16x4_t"]]],[11,"fmt","","",267,[[["self"],["formatter"]],["result"]]],[11,"clone","","",268,[[["self"]],["int32x2_t"]]],[11,"fmt","","",268,[[["self"],["formatter"]],["result"]]],[11,"clone","","",269,[[["self"]],["uint32x2_t"]]],[11,"fmt","","",269,[[["self"],["formatter"]],["result"]]],[11,"clone","","",270,[[["self"]],["float32x2_t"]]],[11,"fmt","","",270,[[["self"],["formatter"]],["result"]]],[11,"clone","","",271,[[["self"]],["int64x1_t"]]],[11,"fmt","","",271,[[["self"],["formatter"]],["result"]]],[11,"clone","","",272,[[["self"]],["uint64x1_t"]]],[11,"fmt","","",272,[[["self"],["formatter"]],["result"]]],[11,"clone","","",273,[[["self"]],["int8x16_t"]]],[11,"fmt","","",273,[[["self"],["formatter"]],["result"]]],[11,"clone","","",274,[[["self"]],["uint8x16_t"]]],[11,"fmt","","",274,[[["self"],["formatter"]],["result"]]],[11,"clone","","",275,[[["self"]],["poly8x16_t"]]],[11,"fmt","","",275,[[["self"],["formatter"]],["result"]]],[11,"clone","","",276,[[["self"]],["int16x8_t"]]],[11,"fmt","","",276,[[["self"],["formatter"]],["result"]]],[11,"clone","","",277,[[["self"]],["uint16x8_t"]]],[11,"fmt","","",277,[[["self"],["formatter"]],["result"]]],[11,"clone","","",278,[[["self"]],["poly16x8_t"]]],[11,"fmt","","",278,[[["self"],["formatter"]],["result"]]],[11,"clone","","",279,[[["self"]],["int32x4_t"]]],[11,"fmt","","",279,[[["self"],["formatter"]],["result"]]],[11,"clone","","",280,[[["self"]],["uint32x4_t"]]],[11,"fmt","","",280,[[["self"],["formatter"]],["result"]]],[11,"clone","","",281,[[["self"]],["float32x4_t"]]],[11,"fmt","","",281,[[["self"],["formatter"]],["result"]]],[11,"clone","","",282,[[["self"]],["int64x2_t"]]],[11,"fmt","","",282,[[["self"],["formatter"]],["result"]]],[11,"clone","","",283,[[["self"]],["uint64x2_t"]]],[11,"fmt","","",283,[[["self"],["formatter"]],["result"]]],[11,"clone","core::arch::mips","",284,[[["self"]],["i8x16"]]],[11,"fmt","","",284,[[["self"],["formatter"]],["result"]]],[11,"clone","core::arch::powerpc64","",285,[[["self"]],["vector_signed_long"]]],[11,"fmt","","",285,[[["self"],["formatter"]],["result"]]],[11,"clone","","",286,[[["self"]],["vector_unsigned_long"]]],[11,"fmt","","",286,[[["self"],["formatter"]],["result"]]],[11,"clone","","",287,[[["self"]],["vector_bool_long"]]],[11,"fmt","","",287,[[["self"],["formatter"]],["result"]]],[11,"clone","","",288,[[["self"]],["vector_double"]]],[11,"fmt","","",288,[[["self"],["formatter"]],["result"]]]],"paths":[[3,"Wrapping"],[4,"FpCategory"],[3,"ParseFloatError"],[3,"NonZeroU8"],[3,"NonZeroU16"],[3,"NonZeroU32"],[3,"NonZeroU64"],[3,"NonZeroU128"],[3,"NonZeroUsize"],[3,"TryFromIntError"],[3,"ParseIntError"],[3,"Discriminant"],[3,"ManuallyDrop"],[3,"PinMut"],[3,"NonNull"],[3,"PhantomData"],[3,"Pinned"],[3,"Range"],[3,"RangeFrom"],[3,"RangeTo"],[3,"RangeToInclusive"],[4,"Bound"],[4,"GeneratorState"],[3,"RangeFull"],[3,"RangeInclusive"],[8,"Add"],[8,"Sub"],[8,"Mul"],[8,"Div"],[8,"Rem"],[8,"Neg"],[8,"AddAssign"],[8,"SubAssign"],[8,"MulAssign"],[8,"DivAssign"],[8,"RemAssign"],[8,"Not"],[8,"BitAnd"],[8,"BitOr"],[8,"BitXor"],[8,"Shl"],[8,"Shr"],[8,"BitAndAssign"],[8,"BitOrAssign"],[8,"BitXorAssign"],[8,"ShlAssign"],[8,"ShrAssign"],[8,"Deref"],[8,"DerefMut"],[8,"Drop"],[8,"Fn"],[8,"FnMut"],[8,"FnOnce"],[8,"Index"],[8,"IndexMut"],[8,"RangeBounds"],[8,"Try"],[8,"Generator"],[3,"Reverse"],[4,"Ordering"],[8,"PartialEq"],[8,"Ord"],[8,"PartialOrd"],[8,"Clone"],[8,"Default"],[8,"AsRef"],[8,"AsMut"],[8,"Into"],[8,"From"],[8,"TryInto"],[8,"TryFrom"],[8,"Borrow"],[8,"BorrowMut"],[8,"Any"],[3,"TypeId"],[8,"FixedSizeArray"],[3,"TryFromSliceError"],[3,"EscapeDefault"],[4,"Ordering"],[3,"AtomicBool"],[3,"AtomicPtr"],[3,"AtomicI8"],[3,"AtomicU8"],[3,"AtomicI16"],[3,"AtomicU16"],[3,"AtomicI32"],[3,"AtomicU32"],[3,"AtomicI64"],[3,"AtomicU64"],[3,"AtomicIsize"],[3,"AtomicUsize"],[3,"Cell"],[3,"BorrowError"],[3,"BorrowMutError"],[3,"RefCell"],[3,"Ref"],[3,"RefMut"],[3,"UnsafeCell"],[3,"UnicodeVersion"],[3,"ParseCharError"],[3,"CharTryFromError"],[3,"DecodeUtf8"],[3,"InvalidSequence"],[3,"DecodeUtf16"],[3,"DecodeUtf16Error"],[3,"EscapeUnicode"],[3,"EscapeDefault"],[3,"EscapeDebug"],[3,"ToLowercase"],[3,"ToUppercase"],[3,"PanicInfo"],[3,"Location"],[3,"Repeat"],[3,"RepeatWith"],[3,"Empty"],[3,"Once"],[8,"Iterator"],[8,"Step"],[8,"FromIterator"],[8,"IntoIterator"],[8,"DoubleEndedIterator"],[8,"Extend"],[8,"ExactSizeIterator"],[8,"Sum"],[8,"Product"],[3,"Rev"],[3,"Cloned"],[3,"Cycle"],[3,"StepBy"],[3,"Chain"],[3,"Zip"],[3,"Map"],[3,"Filter"],[3,"FilterMap"],[3,"Enumerate"],[3,"Peekable"],[3,"SkipWhile"],[3,"TakeWhile"],[3,"Skip"],[3,"Take"],[3,"Scan"],[3,"FlatMap"],[3,"Flatten"],[3,"Fuse"],[3,"Inspect"],[4,"Option"],[3,"Iter"],[3,"IterMut"],[3,"IntoIter"],[3,"NoneError"],[3,"TraitObject"],[4,"Result"],[3,"Iter"],[3,"IterMut"],[3,"IntoIter"],[8,"SliceIndex"],[3,"Iter"],[3,"IterMut"],[3,"Split"],[3,"SplitMut"],[3,"RSplit"],[3,"RSplitMut"],[3,"SplitN"],[3,"RSplitN"],[3,"SplitNMut"],[3,"RSplitNMut"],[3,"Windows"],[3,"Chunks"],[3,"ChunksMut"],[3,"ExactChunks"],[3,"ExactChunksMut"],[4,"SearchStep"],[8,"Pattern"],[8,"Searcher"],[8,"ReverseSearcher"],[3,"CharSearcher"],[3,"CharSliceSearcher"],[3,"CharPredicateSearcher"],[3,"StrSearcher"],[3,"Utf8LossyChunk"],[3,"Utf8Lossy"],[3,"Utf8LossyChunksIter"],[8,"FromStr"],[3,"ParseBoolError"],[3,"Utf8Error"],[3,"Chars"],[3,"CharIndices"],[3,"Bytes"],[3,"Split"],[3,"RSplit"],[3,"SplitTerminator"],[3,"RSplitTerminator"],[3,"SplitN"],[3,"RSplitN"],[3,"MatchIndices"],[3,"RMatchIndices"],[3,"Matches"],[3,"RMatches"],[3,"Lines"],[3,"LinesAny"],[3,"SplitWhitespace"],[3,"SplitAsciiWhitespace"],[3,"EncodeUtf16"],[3,"SipHasher"],[8,"Hash"],[8,"Hasher"],[8,"BuildHasher"],[3,"BuildHasherDefault"],[4,"Alignment"],[3,"DebugStruct"],[3,"DebugTuple"],[3,"DebugSet"],[3,"DebugList"],[3,"DebugMap"],[8,"Write"],[8,"Debug"],[8,"Display"],[8,"Octal"],[8,"Binary"],[8,"LowerHex"],[8,"UpperHex"],[8,"Pointer"],[8,"LowerExp"],[8,"UpperExp"],[3,"Error"],[3,"Arguments"],[3,"Formatter"],[3,"Duration"],[3,"LocalFutureObj"],[3,"FutureObj"],[8,"Future"],[8,"UnsafeFutureObj"],[3,"SpawnObjError"],[3,"SpawnLocalObjError"],[4,"Poll"],[3,"Context"],[3,"SpawnErrorKind"],[3,"Waker"],[3,"LocalWaker"],[8,"Executor"],[8,"UnsafeWake"],[3,"Excess"],[8,"GlobalAlloc"],[8,"Alloc"],[3,"Layout"],[3,"LayoutErr"],[3,"AllocErr"],[3,"CannotReallocInPlace"],[3,"CpuidResult"],[3,"__m64"],[3,"__m128i"],[3,"__m128"],[3,"__m128d"],[3,"__m256i"],[3,"__m256"],[3,"__m256d"],[3,"float64x1_t"],[3,"float64x2_t"],[3,"int8x4_t"],[3,"uint8x4_t"],[3,"int16x2_t"],[3,"uint16x2_t"],[3,"int8x8_t"],[3,"uint8x8_t"],[3,"poly8x8_t"],[3,"int16x4_t"],[3,"uint16x4_t"],[3,"poly16x4_t"],[3,"int32x2_t"],[3,"uint32x2_t"],[3,"float32x2_t"],[3,"int64x1_t"],[3,"uint64x1_t"],[3,"int8x16_t"],[3,"uint8x16_t"],[3,"poly8x16_t"],[3,"int16x8_t"],[3,"uint16x8_t"],[3,"poly16x8_t"],[3,"int32x4_t"],[3,"uint32x4_t"],[3,"float32x4_t"],[3,"int64x2_t"],[3,"uint64x2_t"],[3,"i8x16"],[3,"vector_signed_long"],[3,"vector_unsigned_long"],[3,"vector_bool_long"],[3,"vector_double"]]};
searchIndex["proc_macro"]={"doc":"A support library for macro authors when defining new macros.","items":[[3,"Diagnostic","proc_macro","A structure representing a diagnostic message and associated children messages.",N,N],[3,"TokenStream","","The main type provided by this crate, representing an abstract stream of tokens, or, more specifically, a sequence of token trees. The type provide interfaces for iterating over those token trees and, conversely, collecting a number of token trees into one stream.",N,N],[3,"LexError","","Error returned from `TokenStream::from_str`.",N,N],[3,"Span","","A region of source code, along with macro expansion information.",N,N],[3,"LineColumn","","A line-column pair representing the start or end of a `Span`.",N,N],[12,"line","","The 1-indexed line in the source file on which the span starts or ends (inclusive).",0,N],[12,"column","","The 0-indexed column (in UTF-8 characters) in the source file on which the span starts or ends (inclusive).",0,N],[3,"SourceFile","","The source file of a given `Span`.",N,N],[3,"Group","","A delimited token stream.",N,N],[3,"Punct","","An `Punct` is an single punctuation character like `+`, `-` or `#`.",N,N],[3,"Ident","","An identifier (`ident`).",N,N],[3,"Literal","","A literal string (`\"hello\"`), byte string (`b\"hello\"`), character (`'a'`), byte character (`b'a'`), an integer or floating point number with or without a suffix (`1`, `1u8`, `2.3`, `2.3f32`). Boolean literals like `true` and `false` do not belong here, they are `Ident`s.",N,N],[4,"Level","","An enum representing a diagnostic level.",N,N],[13,"Error","","An error.",1,N],[13,"Warning","","A warning.",1,N],[13,"Note","","A note.",1,N],[13,"Help","","A help message.",1,N],[4,"TokenTree","","A single token or a delimited sequence of token trees (e.g. `[1, (), ..]`).",N,N],[13,"Group","","A token stream surrounded by bracket delimiters.",2,N],[13,"Ident","","An identifier.",2,N],[13,"Punct","","A single punctuation character (`+`, `,`, `$`, etc.).",2,N],[13,"Literal","","A literal character (`'a'`), string (`\"hello\"`), number (`2.3`), etc.",2,N],[4,"Delimiter","","Describes how a sequence of token trees is delimited.",N,N],[13,"Parenthesis","","`( ... )`",3,N],[13,"Brace","","`{ ... }`",3,N],[13,"Bracket","","`[ ... ]`",3,N],[13,"None","","`Ø ... Ø` An implicit delimiter, that may, for example, appear around tokens coming from a \"macro variable\" `$var`. It is important to preserve operator priorities in cases like `$var * 3` where `$var` is `1 + 2`. Implicit delimiters may not survive roundtrip of a token stream through a string.",3,N],[4,"Spacing","","Whether an `Punct` is followed immediately by another `Punct` or followed by another token or whitespace.",N,N],[13,"Alone","","E.g. `+` is `Alone` in `+ =`, `+ident` or `+()`.",4,N],[13,"Joint","","E.g. `+` is `Joint` in `+=` or `'#`. Additionally, single quote `'` can join with identifiers to form lifetimes `'ident`.",4,N],[5,"quote","","Quote a `TokenStream` into a `TokenStream`. This is the actual `quote!()` proc macro.",N,[[["tokenstream"]],["tokenstream"]]],[5,"quote_span","","Quote a `Span` into a `TokenStream`. This is needed to implement a custom quoter.",N,[[["span"]],["tokenstream"]]],[11,"clone","","",1,[[["self"]],["level"]]],[11,"fmt","","",1,[[["self"],["formatter"]],["result"]]],[11,"clone","","",5,[[["self"]],["diagnostic"]]],[11,"fmt","","",5,[[["self"],["formatter"]],["result"]]],[11,"new","","Create a new diagnostic with the given `level` and `message`.",5,[[["level"],["t"]],["diagnostic"]]],[11,"spanned","","Create a new diagnostic with the given `level` and `message` pointing to the given `span`.",5,[[["span"],["level"],["t"]],["diagnostic"]]],[11,"span_error","","Add a new child diagnostic message to `self` with the level identified by this methods name with the given `span` and `message`.",5,[[["self"],["span"],["t"]],["diagnostic"]]],[11,"error","","Add a new child diagnostic message to `self` with the level identified by this method's name with the given `message`.",5,[[["self"],["t"]],["diagnostic"]]],[11,"span_warning","","Add a new child diagnostic message to `self` with the level identified by this methods name with the given `span` and `message`.",5,[[["self"],["span"],["t"]],["diagnostic"]]],[11,"warning","","Add a new child diagnostic message to `self` with the level identified by this method's name with the given `message`.",5,[[["self"],["t"]],["diagnostic"]]],[11,"span_note","","Add a new child diagnostic message to `self` with the level identified by this methods name with the given `span` and `message`.",5,[[["self"],["span"],["t"]],["diagnostic"]]],[11,"note","","Add a new child diagnostic message to `self` with the level identified by this method's name with the given `message`.",5,[[["self"],["t"]],["diagnostic"]]],[11,"span_help","","Add a new child diagnostic message to `self` with the level identified by this methods name with the given `span` and `message`.",5,[[["self"],["span"],["t"]],["diagnostic"]]],[11,"help","","Add a new child diagnostic message to `self` with the level identified by this method's name with the given `message`.",5,[[["self"],["t"]],["diagnostic"]]],[11,"level","","Returns the diagnostic `level` for `self`.",5,[[["self"]],["level"]]],[11,"emit","","Emit the diagnostic.",5,[[["self"]]]],[0,"token_stream","","Public implementation details for the `TokenStream` type, such as iterators.",N,N],[3,"IntoIter","proc_macro::token_stream","An iterator over `TokenStream`'s `TokenTree`s. The iteration is \"shallow\", e.g. the iterator doesn't recurse into delimited groups, and returns whole groups as token trees.",N,N],[11,"clone","","",6,[[["self"]],["intoiter"]]],[11,"next","","",6,[[["self"]],["option",["tokentree"]]]],[11,"into_iter","proc_macro","",7,[[["self"]],["intoiter"]]],[11,"clone","","",7,[[["self"]],["tokenstream"]]],[11,"fmt","","",8,[[["self"],["formatter"]],["result"]]],[11,"new","","Returns an empty `TokenStream` containing no token trees.",7,[[],["tokenstream"]]],[11,"is_empty","","Checks if this `TokenStream` is empty.",7,[[["self"]],["bool"]]],[11,"from_str","","",7,[[["str"]],["result",["tokenstream","lexerror"]]]],[11,"fmt","","",7,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",7,[[["self"],["formatter"]],["result"]]],[11,"from","","",7,[[["tokentree"]],["tokenstream"]]],[11,"from_iter","","",7,[[["i"]],["self"]]],[11,"from_iter","","",7,[[["i"]],["self"]]],[11,"clone","","",9,[[["self"]],["span"]]],[11,"def_site","","A span that resolves at the macro definition site.",9,[[],["span"]]],[11,"call_site","","The span of the invocation of the current procedural macro. Identifiers created with this span will be resolved as if they were written directly at the macro call location (call-site hygiene) and other code at the macro call site will be able to refer to them as well.",9,[[],["span"]]],[11,"source_file","","The original source file into which this span points.",9,[[["self"]],["sourcefile"]]],[11,"parent","","The `Span` for the tokens in the previous macro expansion from which `self` was generated from, if any.",9,[[["self"]],["option",["span"]]]],[11,"source","","The span for the origin source code that `self` was generated from. If this `Span` wasn't generated from other macro expansions then the return value is the same as `*self`.",9,[[["self"]],["span"]]],[11,"start","","Get the starting line/column in the source file for this span.",9,[[["self"]],["linecolumn"]]],[11,"end","","Get the ending line/column in the source file for this span.",9,[[["self"]],["linecolumn"]]],[11,"join","","Create a new span encompassing `self` and `other`.",9,[[["self"],["span"]],["option",["span"]]]],[11,"resolved_at","","Creates a new span with the same line/column information as `self` but that resolves symbols as though it were at `other`.",9,[[["self"],["span"]],["span"]]],[11,"located_at","","Creates a new span with the same name resolution behavior as `self` but with the line/column information of `other`.",9,[[["self"],["span"]],["span"]]],[11,"eq","","Compares to spans to see if they're equal.",9,[[["self"],["span"]],["bool"]]],[11,"error","","Create a new `Diagnostic` with the given `message` at the span `self`.",9,[[["self"],["t"]],["diagnostic"]]],[11,"warning","","Create a new `Diagnostic` with the given `message` at the span `self`.",9,[[["self"],["t"]],["diagnostic"]]],[11,"note","","Create a new `Diagnostic` with the given `message` at the span `self`.",9,[[["self"],["t"]],["diagnostic"]]],[11,"help","","Create a new `Diagnostic` with the given `message` at the span `self`.",9,[[["self"],["t"]],["diagnostic"]]],[11,"fmt","","",9,[[["self"],["formatter"]],["result"]]],[11,"clone","","",0,[[["self"]],["linecolumn"]]],[11,"fmt","","",0,[[["self"],["formatter"]],["result"]]],[11,"eq","","",0,[[["self"],["linecolumn"]],["bool"]]],[11,"ne","","",0,[[["self"],["linecolumn"]],["bool"]]],[11,"clone","","",10,[[["self"]],["sourcefile"]]],[11,"path","","Get the path to this source file.",10,[[["self"]],["pathbuf"]]],[11,"is_real","","Returns `true` if this source file is a real source file, and not generated by an external macro's expansion.",10,[[["self"]],["bool"]]],[11,"fmt","","",10,[[["self"],["formatter"]],["result"]]],[11,"eq","","",10,[[["self"],["self"]],["bool"]]],[11,"clone","","",2,[[["self"]],["tokentree"]]],[11,"span","","Returns the span of this tree, delegating to the `span` method of the contained token or a delimited stream.",2,[[["self"]],["span"]]],[11,"set_span","","Configures the span for only this token.",2,[[["self"],["span"]]]],[11,"fmt","","",2,[[["self"],["formatter"]],["result"]]],[11,"from","","",2,[[["group"]],["tokentree"]]],[11,"from","","",2,[[["ident"]],["tokentree"]]],[11,"from","","",2,[[["punct"]],["tokentree"]]],[11,"from","","",2,[[["literal"]],["tokentree"]]],[11,"fmt","","",2,[[["self"],["formatter"]],["result"]]],[11,"clone","","",11,[[["self"]],["group"]]],[11,"clone","","",3,[[["self"]],["delimiter"]]],[11,"fmt","","",3,[[["self"],["formatter"]],["result"]]],[11,"eq","","",3,[[["self"],["delimiter"]],["bool"]]],[11,"new","","Creates a new `Group` with the given delimiter and token stream.",11,[[["delimiter"],["tokenstream"]],["group"]]],[11,"delimiter","","Returns the delimiter of this `Group`",11,[[["self"]],["delimiter"]]],[11,"stream","","Returns the `TokenStream` of tokens that are delimited in this `Group`.",11,[[["self"]],["tokenstream"]]],[11,"span","","Returns the span for the delimiters of this token stream, spanning the entire `Group`.",11,[[["self"]],["span"]]],[11,"set_span","","Configures the span for this `Group`'s delimiters, but not its internal tokens.",11,[[["self"],["span"]]]],[11,"fmt","","",11,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",11,[[["self"],["formatter"]],["result"]]],[11,"clone","","",12,[[["self"]],["punct"]]],[11,"clone","","",4,[[["self"]],["spacing"]]],[11,"fmt","","",4,[[["self"],["formatter"]],["result"]]],[11,"eq","","",4,[[["self"],["spacing"]],["bool"]]],[11,"new","","Creates a new `Punct` from the given character and spacing. The `ch` argument must be a valid punctuation character permitted by the language, otherwise the function will panic.",12,[[["char"],["spacing"]],["punct"]]],[11,"as_char","","Returns the value of this punctuation character as `char`.",12,[[["self"]],["char"]]],[11,"spacing","","Returns the spacing of this punctuation character, indicating whether it's immediately followed by another `Punct` in the token stream, so they can potentially be combined into a multicharacter operator (`Joint`), or it's followed by some other token or whitespace (`Alone`) so the operator has certainly ended.",12,[[["self"]],["spacing"]]],[11,"span","","Returns the span for this punctuation character.",12,[[["self"]],["span"]]],[11,"set_span","","Configure the span for this punctuation character.",12,[[["self"],["span"]]]],[11,"fmt","","",12,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",12,[[["self"],["formatter"]],["result"]]],[11,"clone","","",13,[[["self"]],["ident"]]],[11,"new","","Creates a new `Ident` with the given `string` as well as the specified `span`. The `string` argument must be a valid identifier permitted by the language, otherwise the function will panic.",13,[[["str"],["span"]],["ident"]]],[11,"new_raw","","Same as `Ident::new`, but creates a raw identifier (`r#ident`).",13,[[["str"],["span"]],["ident"]]],[11,"span","","Returns the span of this `Ident`, encompassing the entire string returned by `as_str`.",13,[[["self"]],["span"]]],[11,"set_span","","Configures the span of this `Ident`, possibly changing its hygiene context.",13,[[["self"],["span"]]]],[11,"fmt","","",13,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",13,[[["self"],["formatter"]],["result"]]],[11,"clone","","",14,[[["self"]],["literal"]]],[11,"fmt","","",14,[[["self"],["formatter"]],["result"]]],[11,"u8_suffixed","","Creates a new suffixed integer literal with the specified value.",14,[[["u8"]],["literal"]]],[11,"u16_suffixed","","Creates a new suffixed integer literal with the specified value.",14,[[["u16"]],["literal"]]],[11,"u32_suffixed","","Creates a new suffixed integer literal with the specified value.",14,[[["u32"]],["literal"]]],[11,"u64_suffixed","","Creates a new suffixed integer literal with the specified value.",14,[[["u64"]],["literal"]]],[11,"u128_suffixed","","Creates a new suffixed integer literal with the specified value.",14,[[["u128"]],["literal"]]],[11,"usize_suffixed","","Creates a new suffixed integer literal with the specified value.",14,[[["usize"]],["literal"]]],[11,"i8_suffixed","","Creates a new suffixed integer literal with the specified value.",14,[[["i8"]],["literal"]]],[11,"i16_suffixed","","Creates a new suffixed integer literal with the specified value.",14,[[["i16"]],["literal"]]],[11,"i32_suffixed","","Creates a new suffixed integer literal with the specified value.",14,[[["i32"]],["literal"]]],[11,"i64_suffixed","","Creates a new suffixed integer literal with the specified value.",14,[[["i64"]],["literal"]]],[11,"i128_suffixed","","Creates a new suffixed integer literal with the specified value.",14,[[["i128"]],["literal"]]],[11,"isize_suffixed","","Creates a new suffixed integer literal with the specified value.",14,[[["isize"]],["literal"]]],[11,"u8_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",14,[[["u8"]],["literal"]]],[11,"u16_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",14,[[["u16"]],["literal"]]],[11,"u32_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",14,[[["u32"]],["literal"]]],[11,"u64_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",14,[[["u64"]],["literal"]]],[11,"u128_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",14,[[["u128"]],["literal"]]],[11,"usize_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",14,[[["usize"]],["literal"]]],[11,"i8_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",14,[[["i8"]],["literal"]]],[11,"i16_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",14,[[["i16"]],["literal"]]],[11,"i32_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",14,[[["i32"]],["literal"]]],[11,"i64_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",14,[[["i64"]],["literal"]]],[11,"i128_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",14,[[["i128"]],["literal"]]],[11,"isize_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",14,[[["isize"]],["literal"]]],[11,"f32_unsuffixed","","Creates a new unsuffixed floating-point literal.",14,[[["f32"]],["literal"]]],[11,"f32_suffixed","","Creates a new suffixed floating-point literal.",14,[[["f32"]],["literal"]]],[11,"f64_unsuffixed","","Creates a new unsuffixed floating-point literal.",14,[[["f64"]],["literal"]]],[11,"f64_suffixed","","Creates a new suffixed floating-point literal.",14,[[["f64"]],["literal"]]],[11,"string","","String literal.",14,[[["str"]],["literal"]]],[11,"character","","Character literal.",14,[[["char"]],["literal"]]],[11,"byte_string","","Byte string literal.",14,N],[11,"span","","Returns the span encompassing this literal.",14,[[["self"]],["span"]]],[11,"set_span","","Configures the span associated for this literal.",14,[[["self"],["span"]]]],[11,"fmt","","",14,[[["self"],["formatter"]],["result"]]],[14,"quote","","`quote!(..)` accepts arbitrary tokens and expands into a `TokenStream` describing the input. For example, `quote!(a + b)` will produce a expression, that, when evaluated, constructs the `TokenStream` `[Ident(\"a\"), Punct('+', Alone), Ident(\"b\")]`.",N,N]],"paths":[[3,"LineColumn"],[4,"Level"],[4,"TokenTree"],[4,"Delimiter"],[4,"Spacing"],[3,"Diagnostic"],[3,"IntoIter"],[3,"TokenStream"],[3,"LexError"],[3,"Span"],[3,"SourceFile"],[3,"Group"],[3,"Punct"],[3,"Ident"],[3,"Literal"]]};
searchIndex["std"]={"doc":"The Rust Standard Library","items":[[14,"assert_eq","std","Asserts that two expressions are equal to each other (using [`PartialEq`]).",N,N],[14,"assert_ne","","Asserts that two expressions are not equal to each other (using [`PartialEq`]).",N,N],[14,"debug_assert","","Ensure that a boolean expression is `true` at runtime.",N,N],[14,"debug_assert_eq","","Asserts that two expressions are equal to each other.",N,N],[14,"debug_assert_ne","","Asserts that two expressions are not equal to each other.",N,N],[14,"unreachable","","A utility macro for indicating unreachable code.",N,N],[14,"unimplemented","","A standardized placeholder for marking unfinished code.",N,N],[14,"write","","Write formatted data into a buffer.",N,N],[14,"writeln","","Write formatted data into a buffer, with a newline appended.",N,N],[14,"try","","Helper macro for reducing boilerplate code for matching `Result` together with converting downstream errors.",N,N],[0,"any","","This module implements the `Any` trait, which enables dynamic typing of any `'static` type through runtime reflection.",N,N],[8,"Any","std::any","A type to emulate dynamic typing.",N,N],[10,"get_type_id","","Gets the `TypeId` of `self`.",0,[[["self"]],["typeid"]]],[3,"TypeId","","A `TypeId` represents a globally unique identifier for a type.",N,N],[0,"cell","std","Shareable mutable containers.",N,N],[3,"Cell","std::cell","A mutable memory location.",N,N],[3,"RefCell","","A mutable memory location with dynamically checked borrow rules",N,N],[3,"BorrowError","","An error returned by `RefCell::try_borrow`.",N,N],[3,"BorrowMutError","","An error returned by `RefCell::try_borrow_mut`.",N,N],[3,"Ref","","Wraps a borrowed reference to a value in a `RefCell` box. A wrapper type for an immutably borrowed value from a `RefCell<T>`.",N,N],[3,"RefMut","","A wrapper type for a mutably borrowed value from a `RefCell<T>`.",N,N],[3,"UnsafeCell","","The core primitive for interior mutability in Rust.",N,N],[0,"clone","std","The `Clone` trait for types that cannot be 'implicitly copied'.",N,N],[8,"Clone","std::clone","A common trait for the ability to explicitly duplicate an object.",N,N],[10,"clone","","Returns a copy of the value.",1,[[["self"]],["self"]]],[11,"clone_from","","Performs copy-assignment from `source`.",1,N],[0,"cmp","std","Functionality for ordering and comparison.",N,N],[8,"PartialEq","std::cmp","Trait for equality comparisons which are partial equivalence relations.",N,N],[10,"eq","","This method tests for `self` and `other` values to be equal, and is used by `==`.",2,[[["self"],["rhs"]],["bool"]]],[11,"ne","","This method tests for `!=`.",2,[[["self"],["rhs"]],["bool"]]],[8,"Eq","","Trait for equality comparisons which are equivalence relations.",N,N],[4,"Ordering","","An `Ordering` is the result of a comparison between two values.",N,N],[13,"Less","","An ordering where a compared value is less [than another].",3,N],[13,"Equal","","An ordering where a compared value is equal [to another].",3,N],[13,"Greater","","An ordering where a compared value is greater [than another].",3,N],[3,"Reverse","","A helper struct for reverse ordering.",N,N],[12,"0","","",4,N],[8,"Ord","","Trait for types that form a total order.",N,N],[10,"cmp","","This method returns an `Ordering` between `self` and `other`.",5,[[["self"],["self"]],["ordering"]]],[11,"max","","Compares and returns the maximum of two values.",5,[[["self"],["self"]],["self"]]],[11,"min","","Compares and returns the minimum of two values.",5,[[["self"],["self"]],["self"]]],[8,"PartialOrd","","Trait for values that can be compared for a sort-order.",N,N],[10,"partial_cmp","","This method returns an ordering between `self` and `other` values if one exists.",6,[[["self"],["rhs"]],["option",["ordering"]]]],[11,"lt","","This method tests less than (for `self` and `other`) and is used by the `<` operator.",6,[[["self"],["rhs"]],["bool"]]],[11,"le","","This method tests less than or equal to (for `self` and `other`) and is used by the `<=` operator.",6,[[["self"],["rhs"]],["bool"]]],[11,"gt","","This method tests greater than (for `self` and `other`) and is used by the `>` operator.",6,[[["self"],["rhs"]],["bool"]]],[11,"ge","","This method tests greater than or equal to (for `self` and `other`) and is used by the `>=` operator.",6,[[["self"],["rhs"]],["bool"]]],[5,"min","","Compares and returns the minimum of two values.",N,[[["t"],["t"]],["t"]]],[5,"max","","Compares and returns the maximum of two values.",N,[[["t"],["t"]],["t"]]],[0,"convert","std","Traits for conversions between types.",N,N],[8,"AsRef","std::convert","A cheap reference-to-reference conversion. Used to convert a value to a reference value within generic code.",N,N],[10,"as_ref","","Performs the conversion.",7,[[["self"]],["t"]]],[8,"AsMut","","A cheap, mutable reference-to-mutable reference conversion.",N,N],[10,"as_mut","","Performs the conversion.",8,[[["self"]],["t"]]],[8,"Into","","A conversion that consumes `self`, which may or may not be expensive. The reciprocal of [`From`][From].",N,N],[10,"into","","Performs the conversion.",9,[[["self"]],["t"]]],[8,"From","","Simple and safe type conversions in to `Self`. It is the reciprocal of `Into`.",N,N],[10,"from","","Performs the conversion.",10,[[["t"]],["self"]]],[8,"TryInto","","An attempted conversion that consumes `self`, which may or may not be expensive.",N,N],[16,"Error","","The type returned in the event of a conversion error.",11,N],[10,"try_into","","Performs the conversion.",11,[[["self"]],["result"]]],[8,"TryFrom","","Attempt to construct `Self` via a conversion.",N,N],[16,"Error","","The type returned in the event of a conversion error.",12,N],[10,"try_from","","Performs the conversion.",12,[[["t"]],["result"]]],[0,"default","std","The `Default` trait for types which may have meaningful default values.",N,N],[8,"Default","std::default","A trait for giving a type a useful default value.",N,N],[10,"default","","Returns the \"default value\" for a type.",13,[[],["self"]]],[0,"hash","std","Generic hashing support.",N,N],[8,"Hash","std::hash","A hashable type.",N,N],[10,"hash","","Feeds this value into the given [`Hasher`].",14,N],[11,"hash_slice","","Feeds a slice of this type into the given [`Hasher`].",14,N],[8,"Hasher","","A trait for hashing an arbitrary stream of bytes.",N,N],[10,"finish","","Returns the hash value for the values written so far.",15,[[["self"]],["u64"]]],[10,"write","","Writes some data into this `Hasher`.",15,N],[11,"write_u8","","Writes a single `u8` into this hasher.",15,N],[11,"write_u16","","Writes a single `u16` into this hasher.",15,N],[11,"write_u32","","Writes a single `u32` into this hasher.",15,N],[11,"write_u64","","Writes a single `u64` into this hasher.",15,N],[11,"write_u128","","Writes a single `u128` into this hasher.",15,N],[11,"write_usize","","Writes a single `usize` into this hasher.",15,N],[11,"write_i8","","Writes a single `i8` into this hasher.",15,N],[11,"write_i16","","Writes a single `i16` into this hasher.",15,N],[11,"write_i32","","Writes a single `i32` into this hasher.",15,N],[11,"write_i64","","Writes a single `i64` into this hasher.",15,N],[11,"write_i128","","Writes a single `i128` into this hasher.",15,N],[11,"write_isize","","Writes a single `isize` into this hasher.",15,N],[8,"BuildHasher","","A trait for creating instances of [`Hasher`].",N,N],[16,"Hasher","","Type of the hasher that will be created.",16,N],[10,"build_hasher","","Creates a new hasher.",16,N],[3,"BuildHasherDefault","","Used to create a default [`BuildHasher`] instance for types that implement [`Hasher`] and [`Default`].",N,N],[3,"SipHasher","","An implementation of SipHash 2-4.",N,N],[0,"intrinsics","std","rustc compiler intrinsics.",N,N],[5,"atomic_cxchg","std::intrinsics","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::SeqCst` as both the `success` and `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",N,N],[5,"atomic_cxchg_acq","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::Acquire` as both the `success` and `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",N,N],[5,"atomic_cxchg_rel","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::Release` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",N,N],[5,"atomic_cxchg_acqrel","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::AcqRel` as the `success` and `Ordering::Acquire` as the `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",N,N],[5,"atomic_cxchg_relaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::Relaxed` as both the `success` and `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",N,N],[5,"atomic_cxchg_failrelaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::SeqCst` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",N,N],[5,"atomic_cxchg_failacq","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::SeqCst` as the `success` and `Ordering::Acquire` as the `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",N,N],[5,"atomic_cxchg_acq_failrelaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::Acquire` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",N,N],[5,"atomic_cxchg_acqrel_failrelaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::AcqRel` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",N,N],[5,"atomic_cxchgweak","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::SeqCst` as both the `success` and `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",N,N],[5,"atomic_cxchgweak_acq","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::Acquire` as both the `success` and `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",N,N],[5,"atomic_cxchgweak_rel","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::Release` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",N,N],[5,"atomic_cxchgweak_acqrel","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::AcqRel` as the `success` and `Ordering::Acquire` as the `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",N,N],[5,"atomic_cxchgweak_relaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::Relaxed` as both the `success` and `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",N,N],[5,"atomic_cxchgweak_failrelaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::SeqCst` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",N,N],[5,"atomic_cxchgweak_failacq","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::SeqCst` as the `success` and `Ordering::Acquire` as the `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",N,N],[5,"atomic_cxchgweak_acq_failrelaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::Acquire` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",N,N],[5,"atomic_cxchgweak_acqrel_failrelaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::AcqRel` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",N,N],[5,"atomic_load","","Loads the current value of the pointer. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `load` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::load`.",N,N],[5,"atomic_load_acq","","Loads the current value of the pointer. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `load` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicBool::load`.",N,N],[5,"atomic_load_relaxed","","Loads the current value of the pointer. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `load` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::load`.",N,N],[5,"atomic_load_unordered","","",N,N],[5,"atomic_store","","Stores the value at the specified memory location. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `store` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::store`.",N,N],[5,"atomic_store_rel","","Stores the value at the specified memory location. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `store` method by passing `Ordering::Release` as the `order`. For example, `AtomicBool::store`.",N,N],[5,"atomic_store_relaxed","","Stores the value at the specified memory location. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `store` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::store`.",N,N],[5,"atomic_store_unordered","","",N,N],[5,"atomic_xchg","","Stores the value at the specified memory location, returning the old value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `swap` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::swap`.",N,N],[5,"atomic_xchg_acq","","Stores the value at the specified memory location, returning the old value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `swap` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicBool::swap`.",N,N],[5,"atomic_xchg_rel","","Stores the value at the specified memory location, returning the old value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `swap` method by passing `Ordering::Release` as the `order`. For example, `AtomicBool::swap`.",N,N],[5,"atomic_xchg_acqrel","","Stores the value at the specified memory location, returning the old value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `swap` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicBool::swap`.",N,N],[5,"atomic_xchg_relaxed","","Stores the value at the specified memory location, returning the old value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `swap` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::swap`.",N,N],[5,"atomic_xadd","","Add to the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_add` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicIsize::fetch_add`.",N,N],[5,"atomic_xadd_acq","","Add to the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_add` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicIsize::fetch_add`.",N,N],[5,"atomic_xadd_rel","","Add to the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_add` method by passing `Ordering::Release` as the `order`. For example, `AtomicIsize::fetch_add`.",N,N],[5,"atomic_xadd_acqrel","","Add to the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_add` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicIsize::fetch_add`.",N,N],[5,"atomic_xadd_relaxed","","Add to the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_add` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicIsize::fetch_add`.",N,N],[5,"atomic_xsub","","Subtract from the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_sub` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicIsize::fetch_sub`.",N,N],[5,"atomic_xsub_acq","","Subtract from the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_sub` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicIsize::fetch_sub`.",N,N],[5,"atomic_xsub_rel","","Subtract from the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_sub` method by passing `Ordering::Release` as the `order`. For example, `AtomicIsize::fetch_sub`.",N,N],[5,"atomic_xsub_acqrel","","Subtract from the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_sub` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicIsize::fetch_sub`.",N,N],[5,"atomic_xsub_relaxed","","Subtract from the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_sub` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicIsize::fetch_sub`.",N,N],[5,"atomic_and","","Bitwise and with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_and` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::fetch_and`.",N,N],[5,"atomic_and_acq","","Bitwise and with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_and` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicBool::fetch_and`.",N,N],[5,"atomic_and_rel","","Bitwise and with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_and` method by passing `Ordering::Release` as the `order`. For example, `AtomicBool::fetch_and`.",N,N],[5,"atomic_and_acqrel","","Bitwise and with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_and` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicBool::fetch_and`.",N,N],[5,"atomic_and_relaxed","","Bitwise and with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_and` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::fetch_and`.",N,N],[5,"atomic_nand","","Bitwise nand with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic::AtomicBool` type via the `fetch_nand` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::fetch_nand`.",N,N],[5,"atomic_nand_acq","","Bitwise nand with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic::AtomicBool` type via the `fetch_nand` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicBool::fetch_nand`.",N,N],[5,"atomic_nand_rel","","Bitwise nand with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic::AtomicBool` type via the `fetch_nand` method by passing `Ordering::Release` as the `order`. For example, `AtomicBool::fetch_nand`.",N,N],[5,"atomic_nand_acqrel","","Bitwise nand with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic::AtomicBool` type via the `fetch_nand` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicBool::fetch_nand`.",N,N],[5,"atomic_nand_relaxed","","Bitwise nand with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic::AtomicBool` type via the `fetch_nand` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::fetch_nand`.",N,N],[5,"atomic_or","","Bitwise or with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_or` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::fetch_or`.",N,N],[5,"atomic_or_acq","","Bitwise or with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_or` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicBool::fetch_or`.",N,N],[5,"atomic_or_rel","","Bitwise or with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_or` method by passing `Ordering::Release` as the `order`. For example, `AtomicBool::fetch_or`.",N,N],[5,"atomic_or_acqrel","","Bitwise or with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_or` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicBool::fetch_or`.",N,N],[5,"atomic_or_relaxed","","Bitwise or with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_or` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::fetch_or`.",N,N],[5,"atomic_xor","","Bitwise xor with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_xor` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::fetch_xor`.",N,N],[5,"atomic_xor_acq","","Bitwise xor with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_xor` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicBool::fetch_xor`.",N,N],[5,"atomic_xor_rel","","Bitwise xor with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_xor` method by passing `Ordering::Release` as the `order`. For example, `AtomicBool::fetch_xor`.",N,N],[5,"atomic_xor_acqrel","","Bitwise xor with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_xor` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicBool::fetch_xor`.",N,N],[5,"atomic_xor_relaxed","","Bitwise xor with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_xor` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::fetch_xor`.",N,N],[5,"atomic_max","","",N,N],[5,"atomic_max_acq","","",N,N],[5,"atomic_max_rel","","",N,N],[5,"atomic_max_acqrel","","",N,N],[5,"atomic_max_relaxed","","",N,N],[5,"atomic_min","","",N,N],[5,"atomic_min_acq","","",N,N],[5,"atomic_min_rel","","",N,N],[5,"atomic_min_acqrel","","",N,N],[5,"atomic_min_relaxed","","",N,N],[5,"atomic_umin","","",N,N],[5,"atomic_umin_acq","","",N,N],[5,"atomic_umin_rel","","",N,N],[5,"atomic_umin_acqrel","","",N,N],[5,"atomic_umin_relaxed","","",N,N],[5,"atomic_umax","","",N,N],[5,"atomic_umax_acq","","",N,N],[5,"atomic_umax_rel","","",N,N],[5,"atomic_umax_acqrel","","",N,N],[5,"atomic_umax_relaxed","","",N,N],[5,"prefetch_read_data","","The `prefetch` intrinsic is a hint to the code generator to insert a prefetch instruction if supported; otherwise, it is a noop. Prefetches have no effect on the behavior of the program but can change its performance characteristics.",N,N],[5,"prefetch_write_data","","The `prefetch` intrinsic is a hint to the code generator to insert a prefetch instruction if supported; otherwise, it is a noop. Prefetches have no effect on the behavior of the program but can change its performance characteristics.",N,N],[5,"prefetch_read_instruction","","The `prefetch` intrinsic is a hint to the code generator to insert a prefetch instruction if supported; otherwise, it is a noop. Prefetches have no effect on the behavior of the program but can change its performance characteristics.",N,N],[5,"prefetch_write_instruction","","The `prefetch` intrinsic is a hint to the code generator to insert a prefetch instruction if supported; otherwise, it is a noop. Prefetches have no effect on the behavior of the program but can change its performance characteristics.",N,N],[5,"atomic_fence","","",N,N],[5,"atomic_fence_acq","","",N,N],[5,"atomic_fence_rel","","",N,N],[5,"atomic_fence_acqrel","","",N,N],[5,"atomic_singlethreadfence","","A compiler-only memory barrier.",N,N],[5,"atomic_singlethreadfence_acq","","",N,N],[5,"atomic_singlethreadfence_rel","","",N,N],[5,"atomic_singlethreadfence_acqrel","","",N,N],[5,"rustc_peek","","Magic intrinsic that derives its meaning from attributes attached to the function.",N,[[["t"]],["t"]]],[5,"abort","","Aborts the execution of the process.",N,N],[5,"unreachable","","Tells LLVM that this point in the code is not reachable, enabling further optimizations.",N,N],[5,"assume","","Informs the optimizer that a condition is always true. If the condition is false, the behavior is undefined.",N,N],[5,"likely","","Hints to the compiler that branch condition is likely to be true. Returns the value passed to it.",N,[[["bool"]],["bool"]]],[5,"unlikely","","Hints to the compiler that branch condition is likely to be false. Returns the value passed to it.",N,[[["bool"]],["bool"]]],[5,"breakpoint","","Executes a breakpoint trap, for inspection by a debugger.",N,N],[5,"size_of","","The size of a type in bytes.",N,[[],["usize"]]],[5,"move_val_init","","Moves a value to an uninitialized memory location.",N,N],[5,"min_align_of","","",N,[[],["usize"]]],[5,"pref_align_of","","",N,[[],["usize"]]],[5,"size_of_val","","The size of the referenced value in bytes.",N,[[["t"]],["usize"]]],[5,"min_align_of_val","","",N,[[["t"]],["usize"]]],[5,"type_name","","Gets a static string slice containing the name of a type.",N,[[],["str"]]],[5,"type_id","","Gets an identifier which is globally unique to the specified type. This function will return the same value for a type regardless of whichever crate it is invoked in.",N,[[],["u64"]]],[5,"init","","Creates a value initialized to zero.",N,[[],["t"]]],[5,"uninit","","Creates an uninitialized value.",N,[[],["t"]]],[5,"transmute","","Reinterprets the bits of a value of one type as another type.",N,[[["t"]],["u"]]],[5,"needs_drop","","Returns `true` if the actual type given as `T` requires drop glue; returns `false` if the actual type provided for `T` implements `Copy`.",N,[[],["bool"]]],[5,"offset","","Calculates the offset from a pointer.",N,N],[5,"arith_offset","","Calculates the offset from a pointer, potentially wrapping.",N,N],[5,"copy_nonoverlapping","","Copies `count * size_of<T>` bytes from `src` to `dst`. The source and destination may not overlap.",N,N],[5,"copy","","Copies `count * size_of<T>` bytes from `src` to `dst`. The source and destination may overlap.",N,N],[5,"write_bytes","","Invokes memset on the specified pointer, setting `count * size_of::<T>()` bytes of memory starting at `dst` to `val`.",N,N],[5,"volatile_copy_nonoverlapping_memory","","Equivalent to the appropriate `llvm.memcpy.p0i8.0i8.*` intrinsic, with a size of `count` * `size_of::<T>()` and an alignment of `min_align_of::<T>()`",N,N],[5,"volatile_copy_memory","","Equivalent to the appropriate `llvm.memmove.p0i8.0i8.*` intrinsic, with a size of `count` * `size_of::<T>()` and an alignment of `min_align_of::<T>()`",N,N],[5,"volatile_set_memory","","Equivalent to the appropriate `llvm.memset.p0i8.*` intrinsic, with a size of `count` * `size_of::<T>()` and an alignment of `min_align_of::<T>()`.",N,N],[5,"volatile_load","","Perform a volatile load from the `src` pointer. The stabilized version of this intrinsic is `std::ptr::read_volatile`.",N,N],[5,"volatile_store","","Perform a volatile store to the `dst` pointer. The stabilized version of this intrinsic is `std::ptr::write_volatile`.",N,N],[5,"unaligned_volatile_load","","Perform a volatile load from the `src` pointer The pointer is not required to be aligned.",N,N],[5,"unaligned_volatile_store","","Perform a volatile store to the `dst` pointer. The pointer is not required to be aligned.",N,N],[5,"sqrtf32","","Returns the square root of an `f32`",N,[[["f32"]],["f32"]]],[5,"sqrtf64","","Returns the square root of an `f64`",N,[[["f64"]],["f64"]]],[5,"powif32","","Raises an `f32` to an integer power.",N,[[["f32"],["i32"]],["f32"]]],[5,"powif64","","Raises an `f64` to an integer power.",N,[[["f64"],["i32"]],["f64"]]],[5,"sinf32","","Returns the sine of an `f32`.",N,[[["f32"]],["f32"]]],[5,"sinf64","","Returns the sine of an `f64`.",N,[[["f64"]],["f64"]]],[5,"cosf32","","Returns the cosine of an `f32`.",N,[[["f32"]],["f32"]]],[5,"cosf64","","Returns the cosine of an `f64`.",N,[[["f64"]],["f64"]]],[5,"powf32","","Raises an `f32` to an `f32` power.",N,[[["f32"],["f32"]],["f32"]]],[5,"powf64","","Raises an `f64` to an `f64` power.",N,[[["f64"],["f64"]],["f64"]]],[5,"expf32","","Returns the exponential of an `f32`.",N,[[["f32"]],["f32"]]],[5,"expf64","","Returns the exponential of an `f64`.",N,[[["f64"]],["f64"]]],[5,"exp2f32","","Returns 2 raised to the power of an `f32`.",N,[[["f32"]],["f32"]]],[5,"exp2f64","","Returns 2 raised to the power of an `f64`.",N,[[["f64"]],["f64"]]],[5,"logf32","","Returns the natural logarithm of an `f32`.",N,[[["f32"]],["f32"]]],[5,"logf64","","Returns the natural logarithm of an `f64`.",N,[[["f64"]],["f64"]]],[5,"log10f32","","Returns the base 10 logarithm of an `f32`.",N,[[["f32"]],["f32"]]],[5,"log10f64","","Returns the base 10 logarithm of an `f64`.",N,[[["f64"]],["f64"]]],[5,"log2f32","","Returns the base 2 logarithm of an `f32`.",N,[[["f32"]],["f32"]]],[5,"log2f64","","Returns the base 2 logarithm of an `f64`.",N,[[["f64"]],["f64"]]],[5,"fmaf32","","Returns `a * b + c` for `f32` values.",N,[[["f32"],["f32"],["f32"]],["f32"]]],[5,"fmaf64","","Returns `a * b + c` for `f64` values.",N,[[["f64"],["f64"],["f64"]],["f64"]]],[5,"fabsf32","","Returns the absolute value of an `f32`.",N,[[["f32"]],["f32"]]],[5,"fabsf64","","Returns the absolute value of an `f64`.",N,[[["f64"]],["f64"]]],[5,"copysignf32","","Copies the sign from `y` to `x` for `f32` values.",N,[[["f32"],["f32"]],["f32"]]],[5,"copysignf64","","Copies the sign from `y` to `x` for `f64` values.",N,[[["f64"],["f64"]],["f64"]]],[5,"floorf32","","Returns the largest integer less than or equal to an `f32`.",N,[[["f32"]],["f32"]]],[5,"floorf64","","Returns the largest integer less than or equal to an `f64`.",N,[[["f64"]],["f64"]]],[5,"ceilf32","","Returns the smallest integer greater than or equal to an `f32`.",N,[[["f32"]],["f32"]]],[5,"ceilf64","","Returns the smallest integer greater than or equal to an `f64`.",N,[[["f64"]],["f64"]]],[5,"truncf32","","Returns the integer part of an `f32`.",N,[[["f32"]],["f32"]]],[5,"truncf64","","Returns the integer part of an `f64`.",N,[[["f64"]],["f64"]]],[5,"rintf32","","Returns the nearest integer to an `f32`. May raise an inexact floating-point exception if the argument is not an integer.",N,[[["f32"]],["f32"]]],[5,"rintf64","","Returns the nearest integer to an `f64`. May raise an inexact floating-point exception if the argument is not an integer.",N,[[["f64"]],["f64"]]],[5,"nearbyintf32","","Returns the nearest integer to an `f32`.",N,[[["f32"]],["f32"]]],[5,"nearbyintf64","","Returns the nearest integer to an `f64`.",N,[[["f64"]],["f64"]]],[5,"roundf32","","Returns the nearest integer to an `f32`. Rounds half-way cases away from zero.",N,[[["f32"]],["f32"]]],[5,"roundf64","","Returns the nearest integer to an `f64`. Rounds half-way cases away from zero.",N,[[["f64"]],["f64"]]],[5,"fadd_fast","","Float addition that allows optimizations based on algebraic rules. May assume inputs are finite.",N,[[["t"],["t"]],["t"]]],[5,"fsub_fast","","Float subtraction that allows optimizations based on algebraic rules. May assume inputs are finite.",N,[[["t"],["t"]],["t"]]],[5,"fmul_fast","","Float multiplication that allows optimizations based on algebraic rules. May assume inputs are finite.",N,[[["t"],["t"]],["t"]]],[5,"fdiv_fast","","Float division that allows optimizations based on algebraic rules. May assume inputs are finite.",N,[[["t"],["t"]],["t"]]],[5,"frem_fast","","Float remainder that allows optimizations based on algebraic rules. May assume inputs are finite.",N,[[["t"],["t"]],["t"]]],[5,"ctpop","","Returns the number of bits set in an integer type `T`",N,[[["t"]],["t"]]],[5,"ctlz","","Returns the number of leading unset bits (zeroes) in an integer type `T`.",N,[[["t"]],["t"]]],[5,"ctlz_nonzero","","Like `ctlz`, but extra-unsafe as it returns `undef` when given an `x` with value `0`.",N,[[["t"]],["t"]]],[5,"cttz","","Returns the number of trailing unset bits (zeroes) in an integer type `T`.",N,[[["t"]],["t"]]],[5,"cttz_nonzero","","Like `cttz`, but extra-unsafe as it returns `undef` when given an `x` with value `0`.",N,[[["t"]],["t"]]],[5,"bswap","","Reverses the bytes in an integer type `T`.",N,[[["t"]],["t"]]],[5,"bitreverse","","Reverses the bits in an integer type `T`.",N,[[["t"]],["t"]]],[5,"add_with_overflow","","Performs checked integer addition. The stabilized versions of this intrinsic are available on the integer primitives via the `overflowing_add` method. For example, `std::u32::overflowing_add`",N,N],[5,"sub_with_overflow","","Performs checked integer subtraction The stabilized versions of this intrinsic are available on the integer primitives via the `overflowing_sub` method. For example, `std::u32::overflowing_sub`",N,N],[5,"mul_with_overflow","","Performs checked integer multiplication The stabilized versions of this intrinsic are available on the integer primitives via the `overflowing_mul` method. For example, `std::u32::overflowing_mul`",N,N],[5,"exact_div","","Performs an exact division, resulting in undefined behavior where `x % y != 0` or `y == 0` or `x == T::min_value() && y == -1`",N,[[["t"],["t"]],["t"]]],[5,"unchecked_div","","Performs an unchecked division, resulting in undefined behavior where y = 0 or x = `T::min_value()` and y = -1",N,[[["t"],["t"]],["t"]]],[5,"unchecked_rem","","Returns the remainder of an unchecked division, resulting in undefined behavior where y = 0 or x = `T::min_value()` and y = -1",N,[[["t"],["t"]],["t"]]],[5,"unchecked_shl","","Performs an unchecked left shift, resulting in undefined behavior when y < 0 or y >= N, where N is the width of T in bits.",N,[[["t"],["t"]],["t"]]],[5,"unchecked_shr","","Performs an unchecked right shift, resulting in undefined behavior when y < 0 or y >= N, where N is the width of T in bits.",N,[[["t"],["t"]],["t"]]],[5,"overflowing_add","","Returns (a + b) mod 2N, where N is the width of T in bits. The stabilized versions of this intrinsic are available on the integer primitives via the `wrapping_add` method. For example, `std::u32::wrapping_add`",N,[[["t"],["t"]],["t"]]],[5,"overflowing_sub","","Returns (a - b) mod 2N, where N is the width of T in bits. The stabilized versions of this intrinsic are available on the integer primitives via the `wrapping_sub` method. For example, `std::u32::wrapping_sub`",N,[[["t"],["t"]],["t"]]],[5,"overflowing_mul","","Returns (a * b) mod 2N, where N is the width of T in bits. The stabilized versions of this intrinsic are available on the integer primitives via the `wrapping_mul` method. For example, `std::u32::wrapping_mul`",N,[[["t"],["t"]],["t"]]],[5,"discriminant_value","","Returns the value of the discriminant for the variant in 'v', cast to a `u64`; if `T` has no discriminant, returns 0.",N,[[["t"]],["u64"]]],[5,"try","","Rust's \"try catch\" construct which invokes the function pointer `f` with the data pointer `data`.",N,N],[5,"nontemporal_store","","Emits a `!nontemporal` store according to LLVM (see their docs). Probably will never become stable.",N,N],[5,"drop_in_place","","Executes the destructor (if any) of the pointed-to value.",N,N],[0,"iter","std","Composable external iteration.",N,N],[3,"Rev","std::iter","A double-ended iterator with the direction inverted.",N,N],[3,"Cloned","","An iterator that clones the elements of an underlying iterator.",N,N],[3,"Cycle","","An iterator that repeats endlessly.",N,N],[3,"StepBy","","An iterator for stepping iterators by a custom amount.",N,N],[3,"Chain","","An iterator that strings two iterators together.",N,N],[3,"Zip","","An iterator that iterates two other iterators simultaneously.",N,N],[3,"Map","","An iterator that maps the values of `iter` with `f`.",N,N],[3,"Filter","","An iterator that filters the elements of `iter` with `predicate`.",N,N],[3,"FilterMap","","An iterator that uses `f` to both filter and map elements from `iter`.",N,N],[3,"Enumerate","","An iterator that yields the current count and the element during iteration.",N,N],[3,"Peekable","","An iterator with a `peek()` that returns an optional reference to the next element.",N,N],[3,"SkipWhile","","An iterator that rejects elements while `predicate` is true.",N,N],[3,"TakeWhile","","An iterator that only accepts elements while `predicate` is true.",N,N],[3,"Skip","","An iterator that skips over `n` elements of `iter`.",N,N],[3,"Take","","An iterator that only iterates over the first `n` iterations of `iter`.",N,N],[3,"Scan","","An iterator to maintain state while iterating another iterator.",N,N],[3,"FlatMap","","An iterator that maps each element to an iterator, and yields the elements of the produced iterators.",N,N],[3,"Flatten","","An iterator that flattens one level of nesting in an iterator of things that can be turned into iterators.",N,N],[3,"Fuse","","An iterator that yields `None` forever after the underlying iterator yields `None` once.",N,N],[3,"Inspect","","An iterator that calls a function with a reference to each element before yielding it.",N,N],[3,"RepeatWith","","An iterator that repeats elements of type `A` endlessly by applying the provided closure `F: FnMut() -> A`.",N,N],[8,"Step","","Objects that can be stepped over in both directions.",N,N],[10,"steps_between","","Returns the number of steps between two step objects. The count is inclusive of `start` and exclusive of `end`.",17,[[["self"],["self"]],["option",["usize"]]]],[10,"replace_one","","Replaces this step with `1`, returning itself",17,[[["self"]],["self"]]],[10,"replace_zero","","Replaces this step with `0`, returning itself",17,[[["self"]],["self"]]],[10,"add_one","","Adds one to this step, returning the result",17,[[["self"]],["self"]]],[10,"sub_one","","Subtracts one to this step, returning the result",17,[[["self"]],["self"]]],[10,"add_usize","","Add an usize, returning None on overflow",17,[[["self"],["usize"]],["option"]]],[3,"Repeat","","An iterator that repeats an element endlessly.",N,N],[5,"repeat","","Creates a new iterator that endlessly repeats a single element.",N,[[["t"]],["repeat"]]],[8,"TrustedLen","","An iterator that reports an accurate length using size_hint.",N,N],[8,"Extend","","Extend a collection with the contents of an iterator.",N,N],[10,"extend","","Extends a collection with the contents of an iterator.",18,N],[8,"Sum","","Trait to represent types that can be created by summing up an iterator.",N,N],[10,"sum","","Method which takes an iterator and generates `Self` from the elements by \"summing up\" the items.",19,[[["i"]],["self"]]],[8,"FusedIterator","","An iterator that always continues to yield `None` when exhausted.",N,N],[8,"Product","","Trait to represent types that can be created by multiplying elements of an iterator.",N,N],[10,"product","","Method which takes an iterator and generates `Self` from the elements by multiplying the items.",20,[[["i"]],["self"]]],[8,"Iterator","","An interface for dealing with iterators.",N,N],[16,"Item","","The type of the elements being iterated over.",21,N],[10,"next","","Advances the iterator and returns the next value.",21,[[["self"]],["option"]]],[11,"size_hint","","Returns the bounds on the remaining length of the iterator.",21,N],[11,"count","","Consumes the iterator, counting the number of iterations and returning it.",21,[[["self"]],["usize"]]],[11,"last","","Consumes the iterator, returning the last element.",21,[[["self"]],["option"]]],[11,"nth","","Returns the `n`th element of the iterator.",21,[[["self"],["usize"]],["option"]]],[11,"step_by","","Creates an iterator starting at the same point, but stepping by the given amount at each iteration.",21,[[["self"],["usize"]],["stepby"]]],[11,"chain","","Takes two iterators and creates a new iterator over both in sequence.",21,[[["self"],["u"]],["chain"]]],[11,"zip","","'Zips up' two iterators into a single iterator of pairs.",21,[[["self"],["u"]],["zip"]]],[11,"map","","Takes a closure and creates an iterator which calls that closure on each element.",21,[[["self"],["f"]],["map"]]],[11,"for_each","","Calls a closure on each element of an iterator.",21,N],[11,"filter","","Creates an iterator which uses a closure to determine if an element should be yielded.",21,[[["self"],["p"]],["filter"]]],[11,"filter_map","","Creates an iterator that both filters and maps.",21,[[["self"],["f"]],["filtermap"]]],[11,"enumerate","","Creates an iterator which gives the current iteration count as well as the next value.",21,[[["self"]],["enumerate"]]],[11,"peekable","","Creates an iterator which can use `peek` to look at the next element of the iterator without consuming it.",21,[[["self"]],["peekable"]]],[11,"skip_while","","Creates an iterator that [`skip`]s elements based on a predicate.",21,[[["self"],["p"]],["skipwhile"]]],[11,"take_while","","Creates an iterator that yields elements based on a predicate.",21,[[["self"],["p"]],["takewhile"]]],[11,"skip","","Creates an iterator that skips the first `n` elements.",21,[[["self"],["usize"]],["skip"]]],[11,"take","","Creates an iterator that yields its first `n` elements.",21,[[["self"],["usize"]],["take"]]],[11,"scan","","An iterator adaptor similar to [`fold`] that holds internal state and produces a new iterator.",21,[[["self"],["st"],["f"]],["scan"]]],[11,"flat_map","","Creates an iterator that works like map, but flattens nested structure.",21,[[["self"],["f"]],["flatmap"]]],[11,"flatten","","Creates an iterator that flattens nested structure.",21,[[["self"]],["flatten"]]],[11,"fuse","","Creates an iterator which ends after the first [`None`].",21,[[["self"]],["fuse"]]],[11,"inspect","","Do something with each element of an iterator, passing the value on.",21,[[["self"],["f"]],["inspect"]]],[11,"by_ref","","Borrows an iterator, rather than consuming it.",21,[[["self"]],["self"]]],[11,"collect","","Transforms an iterator into a collection.",21,[[["self"]],["b"]]],[11,"partition","","Consumes an iterator, creating two collections from it.",21,N],[11,"try_fold","","An iterator method that applies a function as long as it returns successfully, producing a single, final value.",21,[[["self"],["b"],["f"]],["r"]]],[11,"try_for_each","","An iterator method that applies a fallible function to each item in the iterator, stopping at the first error and returning that error.",21,[[["self"],["f"]],["r"]]],[11,"fold","","An iterator method that applies a function, producing a single, final value.",21,[[["self"],["b"],["f"]],["b"]]],[11,"all","","Tests if every element of the iterator matches a predicate.",21,[[["self"],["f"]],["bool"]]],[11,"any","","Tests if any element of the iterator matches a predicate.",21,[[["self"],["f"]],["bool"]]],[11,"find","","Searches for an element of an iterator that satisfies a predicate.",21,[[["self"],["p"]],["option"]]],[11,"find_map","","Applies function to the elements of iterator and returns the first non-none result.",21,[[["self"],["f"]],["option"]]],[11,"position","","Searches for an element in an iterator, returning its index.",21,[[["self"],["p"]],["option",["usize"]]]],[11,"rposition","","Searches for an element in an iterator from the right, returning its index.",21,[[["self"],["p"]],["option",["usize"]]]],[11,"max","","Returns the maximum element of an iterator.",21,[[["self"]],["option"]]],[11,"min","","Returns the minimum element of an iterator.",21,[[["self"]],["option"]]],[11,"max_by_key","","Returns the element that gives the maximum value from the specified function.",21,[[["self"],["f"]],["option"]]],[11,"max_by","","Returns the element that gives the maximum value with respect to the specified comparison function.",21,[[["self"],["f"]],["option"]]],[11,"min_by_key","","Returns the element that gives the minimum value from the specified function.",21,[[["self"],["f"]],["option"]]],[11,"min_by","","Returns the element that gives the minimum value with respect to the specified comparison function.",21,[[["self"],["f"]],["option"]]],[11,"rev","","Reverses an iterator's direction.",21,[[["self"]],["rev"]]],[11,"unzip","","Converts an iterator of pairs into a pair of containers.",21,N],[11,"cloned","","Creates an iterator which [`clone`]s all of its elements.",21,[[["self"]],["cloned"]]],[11,"cycle","","Repeats an iterator endlessly.",21,[[["self"]],["cycle"]]],[11,"sum","","Sums the elements of an iterator.",21,[[["self"]],["s"]]],[11,"product","","Iterates over the entire iterator, multiplying all the elements",21,[[["self"]],["p"]]],[11,"cmp","","Lexicographically compares the elements of this `Iterator` with those of another.",21,[[["self"],["i"]],["ordering"]]],[11,"partial_cmp","","Lexicographically compares the elements of this `Iterator` with those of another.",21,[[["self"],["i"]],["option",["ordering"]]]],[11,"eq","","Determines if the elements of this `Iterator` are equal to those of another.",21,[[["self"],["i"]],["bool"]]],[11,"ne","","Determines if the elements of this `Iterator` are unequal to those of another.",21,[[["self"],["i"]],["bool"]]],[11,"lt","","Determines if the elements of this `Iterator` are lexicographically less than those of another.",21,[[["self"],["i"]],["bool"]]],[11,"le","","Determines if the elements of this `Iterator` are lexicographically less or equal to those of another.",21,[[["self"],["i"]],["bool"]]],[11,"gt","","Determines if the elements of this `Iterator` are lexicographically greater than those of another.",21,[[["self"],["i"]],["bool"]]],[11,"ge","","Determines if the elements of this `Iterator` are lexicographically greater than or equal to those of another.",21,[[["self"],["i"]],["bool"]]],[3,"Empty","","An iterator that yields nothing.",N,N],[8,"IntoIterator","","Conversion into an `Iterator`.",N,N],[16,"Item","","The type of the elements being iterated over.",22,N],[16,"IntoIter","","Which kind of iterator are we turning this into?",22,N],[10,"into_iter","","Creates an iterator from a value.",22,N],[3,"Once","","An iterator that yields an element exactly once.",N,N],[5,"empty","","Creates an iterator that yields nothing.",N,[[],["empty"]]],[8,"FromIterator","","Conversion from an `Iterator`.",N,N],[10,"from_iter","","Creates a value from an iterator.",23,[[["t"]],["self"]]],[8,"ExactSizeIterator","","An iterator that knows its exact length.",N,N],[11,"len","","Returns the exact number of times the iterator will iterate.",24,[[["self"]],["usize"]]],[11,"is_empty","","Returns whether the iterator is empty.",24,[[["self"]],["bool"]]],[5,"once","","Creates an iterator that yields an element exactly once.",N,[[["t"]],["once"]]],[8,"DoubleEndedIterator","","An iterator able to yield elements from both ends.",N,N],[10,"next_back","","Removes and returns an element from the end of the iterator.",25,[[["self"]],["option"]]],[11,"try_rfold","","This is the reverse version of [`try_fold()`]: it takes elements starting from the back of the iterator.",25,[[["self"],["b"],["f"]],["r"]]],[11,"rfold","","An iterator method that reduces the iterator's elements to a single, final value, starting from the back.",25,[[["self"],["b"],["f"]],["b"]]],[11,"rfind","","Searches for an element of an iterator from the back that satisfies a predicate.",25,[[["self"],["p"]],["option"]]],[5,"repeat_with","","Creates a new iterator that repeats elements of type `A` endlessly by applying the provided closure, the repeater, `F: FnMut() -> A`.",N,[[["f"]],["repeatwith"]]],[0,"marker","std","Primitive traits and types representing basic properties of types.",N,N],[8,"Send","std::marker","Types that can be transferred across thread boundaries.",N,N],[8,"Sized","","Types with a constant size known at compile time.",N,N],[8,"Unsize","","Types that can be \"unsized\" to a dynamically-sized type.",N,N],[8,"Copy","","Types whose values can be duplicated simply by copying bits.",N,N],[8,"Sync","","Types for which it is safe to share references between threads.",N,N],[3,"PhantomData","","Zero-sized type used to mark things that \"act like\" they own a `T`.",N,N],[8,"Unpin","","Types which can be moved out of a `PinMut`.",N,N],[3,"Pinned","","A type which does not implement `Unpin`.",N,N],[0,"mem","std","Basic functions for dealing with memory.",N,N],[5,"forget","std::mem","Leaks a value: takes ownership and \"forgets\" about the value without running its destructor.",N,N],[5,"size_of","","Returns the size of a type in bytes.",N,[[],["usize"]]],[5,"size_of_val","","Returns the size of the pointed-to value in bytes.",N,[[["t"]],["usize"]]],[5,"min_align_of","","Returns the [ABI]-required minimum alignment of a type.",N,[[],["usize"]]],[5,"min_align_of_val","","Returns the [ABI]-required minimum alignment of the type of the value that `val` points to.",N,[[["t"]],["usize"]]],[5,"align_of","","Returns the [ABI]-required minimum alignment of a type.",N,[[],["usize"]]],[5,"align_of_val","","Returns the [ABI]-required minimum alignment of the type of the value that `val` points to.",N,[[["t"]],["usize"]]],[5,"needs_drop","","Returns whether dropping values of type `T` matters.",N,[[],["bool"]]],[5,"zeroed","","Creates a value whose bytes are all zero.",N,[[],["t"]]],[5,"uninitialized","","Bypasses Rust's normal memory-initialization checks by pretending to produce a value of type `T`, while doing nothing at all.",N,[[],["t"]]],[5,"swap","","Swaps the values at two mutable locations, without deinitializing either one.",N,N],[5,"replace","","Moves `src` into the referenced `dest`, returning the previous `dest` value.",N,[[["t"],["t"]],["t"]]],[5,"drop","","Disposes of a value.",N,N],[5,"transmute_copy","","Interprets `src` as having type `&U`, and then reads `src` without moving the contained value.",N,[[["t"]],["u"]]],[3,"Discriminant","","Opaque type representing the discriminant of an enum.",N,N],[5,"discriminant","","Returns a value uniquely identifying the enum variant in `v`.",N,[[["t"]],["discriminant"]]],[3,"ManuallyDrop","","A wrapper to inhibit compiler from automatically calling `T`’s destructor.",N,N],[3,"PinMut","","A pinned reference.",N,N],[5,"transmute","","Reinterprets the bits of a value of one type as another type.",N,[[["t"]],["u"]]],[0,"ops","std","Overloadable operators.",N,N],[8,"MulAssign","std::ops","The multiplication assignment operator `*=`.",N,N],[10,"mul_assign","","Performs the `*=` operation.",26,N],[8,"AddAssign","","The addition assignment operator `+=`.",N,N],[10,"add_assign","","Performs the `+=` operation.",27,N],[8,"Index","","Used for indexing operations (`container[index]`) in immutable contexts.",N,N],[16,"Output","","The returned type after indexing.",28,N],[10,"index","","Performs the indexing (`container[index]`) operation.",28,N],[8,"Sub","","The subtraction operator `-`.",N,N],[16,"Output","","The resulting type after applying the `-` operator.",29,N],[10,"sub","","Performs the `-` operation.",29,N],[3,"RangeFrom","","A range only bounded inclusively below (`start..`).",N,N],[12,"start","","The lower bound of the range (inclusive).",30,N],[3,"Range","","A (half-open) range bounded inclusively below and exclusively above (`start..end`).",N,N],[12,"start","","The lower bound of the range (inclusive).",31,N],[12,"end","","The upper bound of the range (exclusive).",31,N],[3,"RangeFull","","An unbounded range (`..`).",N,N],[3,"RangeTo","","A range only bounded exclusively above (`..end`).",N,N],[12,"end","","The upper bound of the range (exclusive).",32,N],[8,"Try","","A trait for customizing the behavior of the `?` operator.",N,N],[16,"Ok","","The type of this value when viewed as successful.",33,N],[16,"Error","","The type of this value when viewed as failed.",33,N],[10,"into_result","","Applies the \"?\" operator. A return of `Ok(t)` means that the execution should continue normally, and the result of `?` is the value `t`. A return of `Err(e)` means that execution should branch to the innermost enclosing `catch`, or return from the function.",33,[[["self"]],["result"]]],[10,"from_error","","Wrap an error value to construct the composite result. For example, `Result::Err(x)` and `Result::from_error(x)` are equivalent.",33,N],[10,"from_ok","","Wrap an OK value to construct the composite result. For example, `Result::Ok(x)` and `Result::from_ok(x)` are equivalent.",33,N],[8,"Deref","","Used for immutable dereferencing operations, like `*v`.",N,N],[16,"Target","","The resulting type after dereferencing.",34,N],[10,"deref","","Dereferences the value.",34,N],[8,"DerefMut","","Used for mutable dereferencing operations, like in `*v = 1;`.",N,N],[10,"deref_mut","","Mutably dereferences the value.",35,N],[8,"BitXor","","The bitwise XOR operator `^`.",N,N],[16,"Output","","The resulting type after applying the `^` operator.",36,N],[10,"bitxor","","Performs the `^` operation.",36,N],[8,"Neg","","The unary negation operator `-`.",N,N],[16,"Output","","The resulting type after applying the `-` operator.",37,N],[10,"neg","","Performs the unary `-` operation.",37,N],[8,"Div","","The division operator `/`.",N,N],[16,"Output","","The resulting type after applying the `/` operator.",38,N],[10,"div","","Performs the `/` operation.",38,N],[8,"Drop","","Used to run some code when a value goes out of scope. This is sometimes called a 'destructor'.",N,N],[10,"drop","","Executes the destructor for this type.",39,N],[4,"GeneratorState","","The result of a generator resumption.",N,N],[13,"Yielded","","The generator suspended with a value.",40,N],[13,"Complete","","The generator completed with a return value.",40,N],[8,"FnOnce","","The version of the call operator that takes a by-value receiver.",N,N],[16,"Output","","The returned type after the call operator is used.",41,N],[10,"call_once","","Performs the call operation.",41,N],[8,"SubAssign","","The subtraction assignment operator `-=`.",N,N],[10,"sub_assign","","Performs the `-=` operation.",42,N],[8,"Rem","","The remainder operator `%`.",N,N],[16,"Output","","The resulting type after applying the `%` operator.",43,N],[10,"rem","","Performs the `%` operation.",43,N],[8,"BitXorAssign","","The bitwise XOR assignment operator `^=`.",N,N],[10,"bitxor_assign","","Performs the `^=` operation.",44,N],[8,"RemAssign","","The remainder assignment operator `%=`.",N,N],[10,"rem_assign","","Performs the `%=` operation.",45,N],[8,"Not","","The unary logical negation operator `!`.",N,N],[16,"Output","","The resulting type after applying the `!` operator.",46,N],[10,"not","","Performs the unary `!` operation.",46,N],[8,"Shl","","The left shift operator `<<`. Note that because this trait is implemented for all integer types with multiple right-hand-side types, Rust's type checker has special handling for `_ << _`, setting the result type for integer operations to the type of the left-hand-side operand. This means that though `a << b` and `a.shl(b)` are one and the same from an evaluation standpoint, they are different when it comes to type inference.",N,N],[16,"Output","","The resulting type after applying the `<<` operator.",47,N],[10,"shl","","Performs the `<<` operation.",47,N],[8,"BitAnd","","The bitwise AND operator `&`.",N,N],[16,"Output","","The resulting type after applying the `&` operator.",48,N],[10,"bitand","","Performs the `&` operation.",48,N],[8,"Add","","The addition operator `+`.",N,N],[16,"Output","","The resulting type after applying the `+` operator.",49,N],[10,"add","","Performs the `+` operation.",49,N],[8,"BitAndAssign","","The bitwise AND assignment operator `&=`.",N,N],[10,"bitand_assign","","Performs the `&=` operation.",50,N],[8,"ShrAssign","","The right shift assignment operator `>>=`.",N,N],[10,"shr_assign","","Performs the `>>=` operation.",51,N],[8,"IndexMut","","Used for indexing operations (`container[index]`) in mutable contexts.",N,N],[10,"index_mut","","Performs the mutable indexing (`container[index]`) operation.",52,N],[8,"FnMut","","The version of the call operator that takes a mutable receiver.",N,N],[10,"call_mut","","Performs the call operation.",53,N],[8,"DivAssign","","The division assignment operator `/=`.",N,N],[10,"div_assign","","Performs the `/=` operation.",54,N],[8,"Mul","","The multiplication operator `*`.",N,N],[16,"Output","","The resulting type after applying the `*` operator.",55,N],[10,"mul","","Performs the `*` operation.",55,N],[3,"RangeInclusive","","An range bounded inclusively below and above (`start..=end`).",N,N],[3,"RangeToInclusive","","A range only bounded inclusively above (`..=end`).",N,N],[12,"end","","The upper bound of the range (inclusive)",56,N],[8,"RangeBounds","","`RangeBounds` is implemented by Rust's built-in range types, produced by range syntax like `..`, `a..`, `..b` or `c..d`.",N,N],[10,"start_bound","","Start index bound.",57,[[["self"]],["bound"]]],[10,"end_bound","","End index bound.",57,[[["self"]],["bound"]]],[11,"contains","","Returns `true` if `item` is contained in the range.",57,[[["self"],["u"]],["bool"]]],[4,"Bound","","An endpoint of a range of keys.",N,N],[13,"Included","","An inclusive bound.",58,N],[13,"Excluded","","An exclusive bound.",58,N],[13,"Unbounded","","An infinite endpoint. Indicates that there is no bound in this direction.",58,N],[8,"Fn","","The version of the call operator that takes an immutable receiver.",N,N],[10,"call","","Performs the call operation.",59,N],[8,"CoerceUnsized","","Trait that indicates that this is a pointer or a wrapper for one, where unsizing can be performed on the pointee.",N,N],[8,"Generator","","The trait implemented by builtin generator types.",N,N],[16,"Yield","","The type of value this generator yields.",60,N],[16,"Return","","The type of value this generator returns.",60,N],[10,"resume","","Resumes the execution of this generator.",60,[[["self"]],["generatorstate"]]],[8,"BitOr","","The bitwise OR operator `|`.",N,N],[16,"Output","","The resulting type after applying the `|` operator.",61,N],[10,"bitor","","Performs the `|` operation.",61,N],[8,"ShlAssign","","The left shift assignment operator `<<=`.",N,N],[10,"shl_assign","","Performs the `<<=` operation.",62,N],[8,"BitOrAssign","","The bitwise OR assignment operator `|=`.",N,N],[10,"bitor_assign","","Performs the `|=` operation.",63,N],[8,"Shr","","The right shift operator `>>`. Note that because this trait is implemented for all integer types with multiple right-hand-side types, Rust's type checker has special handling for `_ >> _`, setting the result type for integer operations to the type of the left-hand-side operand. This means that though `a >> b` and `a.shr(b)` are one and the same from an evaluation standpoint, they are different when it comes to type inference.",N,N],[16,"Output","","The resulting type after applying the `>>` operator.",64,N],[10,"shr","","Performs the `>>` operation.",64,N],[0,"ptr","std","Raw, unsafe pointers, `*const T`, and `*mut T`.",N,N],[5,"drop_in_place","std::ptr","Executes the destructor (if any) of the pointed-to value.",N,N],[5,"null","","Creates a null raw pointer.",N,N],[5,"null_mut","","Creates a null mutable raw pointer.",N,N],[5,"swap","","Swaps the values at two mutable locations of the same type, without deinitializing either.",N,N],[5,"swap_nonoverlapping","","Swaps a sequence of values at two mutable locations of the same type.",N,N],[5,"replace","","Moves `src` into the pointed `dest`, returning the previous `dest` value.",N,N],[5,"read","","Reads the value from `src` without moving it. This leaves the memory in `src` unchanged.",N,N],[5,"read_unaligned","","Reads the value from `src` without moving it. This leaves the memory in `src` unchanged.",N,N],[5,"write","","Overwrites a memory location with the given value without reading or dropping the old value.",N,N],[5,"write_unaligned","","Overwrites a memory location with the given value without reading or dropping the old value.",N,N],[5,"read_volatile","","Performs a volatile read of the value from `src` without moving it. This leaves the memory in `src` unchanged.",N,N],[5,"write_volatile","","Performs a volatile write of a memory location with the given value without reading or dropping the old value.",N,N],[5,"eq","","Compare raw pointers for equality.",N,N],[3,"NonNull","","`*mut T` but non-zero and covariant.",N,N],[5,"copy_nonoverlapping","","Copies `count * size_of<T>` bytes from `src` to `dst`. The source and destination may not overlap.",N,N],[5,"copy","","Copies `count * size_of<T>` bytes from `src` to `dst`. The source and destination may overlap.",N,N],[5,"write_bytes","","Invokes memset on the specified pointer, setting `count * size_of::<T>()` bytes of memory starting at `dst` to `val`.",N,N],[0,"raw","std","Contains struct definitions for the layout of compiler built-in types.",N,N],[3,"TraitObject","std::raw","The representation of a trait object like `&SomeTrait`.",N,N],[12,"data","","",65,N],[12,"vtable","","",65,N],[0,"result","std","Error handling with the `Result` type.",N,N],[4,"Result","std::result","`Result` is a type that represents either success ([`Ok`]) or failure ([`Err`]).",N,N],[13,"Ok","","Contains the success value",66,N],[13,"Err","","Contains the error value",66,N],[3,"Iter","","An iterator over a reference to the [`Ok`] variant of a [`Result`].",N,N],[3,"IterMut","","An iterator over a mutable reference to the [`Ok`] variant of a [`Result`].",N,N],[3,"IntoIter","","An iterator over the value in a [`Ok`] variant of a [`Result`].",N,N],[0,"option","std","Optional values.",N,N],[4,"Option","std::option","The `Option` type. See the module level documentation for more.",N,N],[13,"None","","No value",67,N],[13,"Some","","Some value `T`",67,N],[3,"Iter","","An iterator over a reference to the [`Some`] variant of an [`Option`].",N,N],[3,"IterMut","","An iterator over a mutable reference to the [`Some`] variant of an [`Option`].",N,N],[3,"IntoIter","","An iterator over the value in [`Some`] variant of an [`Option`].",N,N],[3,"NoneError","","The error type that results from applying the try operator (`?`) to a `None` value. If you wish to allow `x?` (where `x` is an `Option<T>`) to be converted into your error type, you can implement `impl From<NoneError>` for `YourErrorType`. In that case, `x?` within a function that returns `Result<_, YourErrorType>` will translate a `None` value into an `Err` result.",N,N],[0,"isize","std","The pointer-sized signed integer type.",N,N],[17,"MIN","std::isize","The smallest value that can be represented by this integer type.",N,N],[17,"MAX","","The largest value that can be represented by this integer type.",N,N],[0,"i8","std","The 8-bit signed integer type.",N,N],[17,"MIN","std::i8","The smallest value that can be represented by this integer type.",N,N],[17,"MAX","","The largest value that can be represented by this integer type.",N,N],[0,"i16","std","The 16-bit signed integer type.",N,N],[17,"MIN","std::i16","The smallest value that can be represented by this integer type.",N,N],[17,"MAX","","The largest value that can be represented by this integer type.",N,N],[0,"i32","std","The 32-bit signed integer type.",N,N],[17,"MIN","std::i32","The smallest value that can be represented by this integer type.",N,N],[17,"MAX","","The largest value that can be represented by this integer type.",N,N],[0,"i64","std","The 64-bit signed integer type.",N,N],[17,"MIN","std::i64","The smallest value that can be represented by this integer type.",N,N],[17,"MAX","","The largest value that can be represented by this integer type.",N,N],[0,"i128","std","The 128-bit signed integer type.",N,N],[17,"MIN","std::i128","The smallest value that can be represented by this integer type.",N,N],[17,"MAX","","The largest value that can be represented by this integer type.",N,N],[0,"usize","std","The pointer-sized unsigned integer type.",N,N],[17,"MIN","std::usize","The smallest value that can be represented by this integer type.",N,N],[17,"MAX","","The largest value that can be represented by this integer type.",N,N],[0,"u8","std","The 8-bit unsigned integer type.",N,N],[17,"MIN","std::u8","The smallest value that can be represented by this integer type.",N,N],[17,"MAX","","The largest value that can be represented by this integer type.",N,N],[0,"u16","std","The 16-bit unsigned integer type.",N,N],[17,"MIN","std::u16","The smallest value that can be represented by this integer type.",N,N],[17,"MAX","","The largest value that can be represented by this integer type.",N,N],[0,"u32","std","The 32-bit unsigned integer type.",N,N],[17,"MIN","std::u32","The smallest value that can be represented by this integer type.",N,N],[17,"MAX","","The largest value that can be represented by this integer type.",N,N],[0,"u64","std","The 64-bit unsigned integer type.",N,N],[17,"MIN","std::u64","The smallest value that can be represented by this integer type.",N,N],[17,"MAX","","The largest value that can be represented by this integer type.",N,N],[0,"boxed","std","A pointer type for heap allocation.",N,N],[3,"Box","std::boxed","A pointer type for heap allocation.",N,N],[8,"FnBox","","`FnBox` is a version of the `FnOnce` intended for use with boxed closure objects. The idea is that where one would normally store a `Box<FnOnce()>` in a data structure, you should use `Box<FnBox()>`. The two traits behave essentially the same, except that a `FnBox` closure can only be called if it is boxed. (Note that `FnBox` may be deprecated in the future if `Box<FnOnce()>` closures become directly usable.)",N,N],[16,"Output","","",68,N],[10,"call_box","","",68,N],[3,"PinBox","","A pinned, heap allocated reference.",N,N],[0,"rc","std","Single-threaded reference-counting pointers. 'Rc' stands for 'Reference Counted'.",N,N],[3,"Rc","std::rc","A single-threaded reference-counting pointer. 'Rc' stands for 'Reference Counted'.",N,N],[3,"Weak","","`Weak` is a version of [`Rc`] that holds a non-owning reference to the managed value. The value is accessed by calling [`upgrade`] on the `Weak` pointer, which returns an [`Option`]`<`[`Rc`]`<T>>`.",N,N],[0,"borrow","std","A module for working with borrowed data.",N,N],[8,"ToOwned","std::borrow","A generalization of `Clone` to borrowed data.",N,N],[16,"Owned","","",69,N],[10,"to_owned","","Creates owned data from borrowed data, usually by cloning.",69,N],[11,"clone_into","","Uses borrowed data to replace owned data, usually by cloning.",69,N],[4,"Cow","","A clone-on-write smart pointer.",N,N],[13,"Borrowed","","Borrowed data.",70,N],[13,"Owned","","Owned data.",70,N],[8,"BorrowMut","","A trait for mutably borrowing data.",N,N],[10,"borrow_mut","","Mutably borrows from an owned value.",71,[[["self"]],["borrowed"]]],[8,"Borrow","","A trait for borrowing data.",N,N],[10,"borrow","","Immutably borrows from an owned value.",72,[[["self"]],["borrowed"]]],[0,"fmt","std","Utilities for formatting and printing `String`s.",N,N],[5,"format","std::fmt","The `format` function takes an [`Arguments`] struct and returns the resulting formatted string.",N,[[["arguments"]],["string"]]],[3,"Arguments","","This structure represents a safely precompiled version of a format string and its arguments. This cannot be generated at runtime because it cannot safely be done, so no constructors are given and the fields are private to prevent modification.",N,N],[8,"Binary","","`b` formatting.",N,N],[10,"fmt","","Formats the value using the given formatter.",73,[[["self"],["formatter"]],["result",["error"]]]],[8,"Write","","A collection of methods that are required to format a message into a stream.",N,N],[10,"write_str","","Writes a slice of bytes into this writer, returning whether the write succeeded.",74,[[["self"],["str"]],["result",["error"]]]],[11,"write_char","","Writes a [`char`] into this writer, returning whether the write succeeded.",74,[[["self"],["char"]],["result",["error"]]]],[11,"write_fmt","","Glue for usage of the [`write!`] macro with implementors of this trait.",74,[[["self"],["arguments"]],["result",["error"]]]],[6,"Result","","The type returned by formatter methods.",N,N],[8,"UpperHex","","`X` formatting.",N,N],[10,"fmt","","Formats the value using the given formatter.",75,[[["self"],["formatter"]],["result",["error"]]]],[8,"LowerExp","","`e` formatting.",N,N],[10,"fmt","","Formats the value using the given formatter.",76,[[["self"],["formatter"]],["result",["error"]]]],[3,"Error","","The error type which is returned from formatting a message into a stream.",N,N],[8,"UpperExp","","`E` formatting.",N,N],[10,"fmt","","Formats the value using the given formatter.",77,[[["self"],["formatter"]],["result",["error"]]]],[3,"DebugMap","","A struct to help with `fmt::Debug` implementations.",N,N],[3,"DebugSet","","A struct to help with `fmt::Debug` implementations.",N,N],[8,"Octal","","`o` formatting.",N,N],[10,"fmt","","Formats the value using the given formatter.",78,[[["self"],["formatter"]],["result",["error"]]]],[8,"LowerHex","","`x` formatting.",N,N],[10,"fmt","","Formats the value using the given formatter.",79,[[["self"],["formatter"]],["result",["error"]]]],[3,"DebugTuple","","A struct to help with `fmt::Debug` implementations.",N,N],[3,"DebugStruct","","A struct to help with `fmt::Debug` implementations.",N,N],[3,"DebugList","","A struct to help with `fmt::Debug` implementations.",N,N],[4,"Alignment","","Possible alignments returned by `Formatter::align`",N,N],[13,"Left","","Indication that contents should be left-aligned.",80,N],[13,"Right","","Indication that contents should be right-aligned.",80,N],[13,"Center","","Indication that contents should be center-aligned.",80,N],[8,"Display","","Format trait for an empty format, `{}`.",N,N],[10,"fmt","","Formats the value using the given formatter.",81,[[["self"],["formatter"]],["result",["error"]]]],[3,"Formatter","","A struct to represent both where to emit formatting strings to and how they should be formatted. A mutable version of this is passed to all formatting traits.",N,N],[8,"Debug","","`?` formatting.",N,N],[10,"fmt","","Formats the value using the given formatter.",82,[[["self"],["formatter"]],["result",["error"]]]],[8,"Pointer","","`p` formatting.",N,N],[10,"fmt","","Formats the value using the given formatter.",83,[[["self"],["formatter"]],["result",["error"]]]],[5,"write","","The `write` function takes an output stream, and an `Arguments` struct that can be precompiled with the `format_args!` macro.",N,[[["write"],["arguments"]],["result",["error"]]]],[14,"format","std","Creates a `String` using interpolation of runtime expressions.",N,N],[0,"slice","","A dynamically-sized view into a contiguous sequence, `[T]`.",N,N],[8,"SliceConcatExt","std::slice","An extension trait for concatenating slices",N,N],[16,"Output","","The resulting type after concatenation",84,N],[10,"concat","","Flattens a slice of `T` into a single value `Self::Output`.",84,N],[10,"join","","Flattens a slice of `T` into a single value `Self::Output`, placing a given separator between each.",84,N],[10,"connect","","",84,N],[5,"from_ref","","Converts a reference to T into a slice of length 1 (without copying).",N,N],[3,"Chunks","","An iterator over a slice in (non-overlapping) chunks (`chunk_size` elements at a time).",N,N],[3,"RSplitN","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits, starting from the end of the slice.",N,N],[3,"RSplitMut","","An iterator over the subslices of the vector which are separated by elements that match `pred`, starting from the end of the slice.",N,N],[3,"SplitNMut","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits.",N,N],[3,"RSplitNMut","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits, starting from the end of the slice.",N,N],[3,"ExactChunksMut","","An iterator over a slice in (non-overlapping) mutable chunks (`chunk_size` elements at a time).",N,N],[5,"from_raw_parts","","Forms a slice from a pointer and a length.",N,N],[3,"IterMut","","Mutable slice iterator.",N,N],[3,"Windows","","An iterator over overlapping subslices of length `size`.",N,N],[3,"SplitMut","","An iterator over the subslices of the vector which are separated by elements that match `pred`.",N,N],[3,"Split","","An iterator over subslices separated by elements that match a predicate function.",N,N],[3,"SplitN","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits.",N,N],[3,"ChunksMut","","An iterator over a slice in (non-overlapping) mutable chunks (`chunk_size` elements at a time). When the slice len is not evenly divided by the chunk size, the last slice of the iteration will be the remainder.",N,N],[3,"RSplit","","An iterator over subslices separated by elements that match a predicate function, starting from the end of the slice.",N,N],[3,"ExactChunks","","An iterator over a slice in (non-overlapping) chunks (`chunk_size` elements at a time).",N,N],[5,"from_raw_parts_mut","","Performs the same functionality as `from_raw_parts`, except that a mutable slice is returned.",N,N],[8,"SliceIndex","","A helper trait used for indexing operations.",N,N],[16,"Output","","The output type returned by methods.",85,N],[10,"get","","Returns a shared reference to the output at this location, if in bounds.",85,[[["self"],["t"]],["option"]]],[10,"get_mut","","Returns a mutable reference to the output at this location, if in bounds.",85,[[["self"],["t"]],["option"]]],[10,"get_unchecked","","Returns a shared reference to the output at this location, without performing any bounds checking.",85,N],[10,"get_unchecked_mut","","Returns a mutable reference to the output at this location, without performing any bounds checking.",85,N],[10,"index","","Returns a shared reference to the output at this location, panicking if out of bounds.",85,N],[10,"index_mut","","Returns a mutable reference to the output at this location, panicking if out of bounds.",85,N],[3,"Iter","","Immutable slice iterator",N,N],[5,"from_mut","","Converts a reference to T into a slice of length 1 (without copying).",N,N],[0,"str","std","Unicode string slices.",N,N],[5,"from_boxed_utf8_unchecked","std::str","Converts a boxed slice of bytes to a boxed string slice without checking that the string contains valid UTF-8.",N,[[["box"]],["box",["str"]]]],[3,"Lines","","An iterator over the lines of a string, as string slices.",N,N],[3,"SplitTerminator","","Created with the method [`split_terminator`].",N,N],[3,"RSplitN","","Created with the method [`rsplitn`].",N,N],[5,"from_utf8","","Converts a slice of bytes to a string slice.",N,N],[3,"Chars","","An iterator over the [`char`]s of a string slice.",N,N],[3,"CharIndices","","An iterator over the [`char`]s of a string slice, and their positions.",N,N],[3,"Bytes","","An iterator over the bytes of a string slice.",N,N],[3,"SplitAsciiWhitespace","","An iterator over the non-ASCII-whitespace substrings of a string, separated by any amount of ASCII whitespace.",N,N],[3,"EncodeUtf16","","An iterator of [`u16`] over the string encoded as UTF-16.",N,N],[3,"Matches","","Created with the method [`matches`].",N,N],[3,"RMatches","","Created with the method [`rmatches`].",N,N],[3,"MatchIndices","","Created with the method [`match_indices`].",N,N],[3,"RMatchIndices","","Created with the method [`rmatch_indices`].",N,N],[5,"from_utf8_mut","","Converts a mutable slice of bytes to a mutable string slice.",N,N],[3,"Split","","Created with the method [`split`].",N,N],[3,"SplitN","","Created with the method [`splitn`].",N,N],[3,"LinesAny","","Created with the method [`lines_any`].",N,N],[3,"RSplitTerminator","","Created with the method [`rsplit_terminator`].",N,N],[3,"RSplit","","Created with the method [`rsplit`].",N,N],[3,"ParseBoolError","","An error returned when parsing a `bool` using [`from_str`] fails",N,N],[3,"SplitWhitespace","","An iterator over the non-whitespace substrings of a string, separated by any amount of whitespace.",N,N],[5,"from_utf8_unchecked","","Converts a slice of bytes to a string slice without checking that the string contains valid UTF-8.",N,N],[5,"from_utf8_unchecked_mut","","Converts a slice of bytes to a string slice without checking that the string contains valid UTF-8; mutable version.",N,N],[0,"pattern","","The string Pattern API.",N,N],[8,"Pattern","std::str::pattern","A string pattern.",N,N],[16,"Searcher","","Associated searcher for this pattern",86,N],[10,"into_searcher","","Constructs the associated searcher from `self` and the `haystack` to search in.",86,N],[11,"is_contained_in","","Checks whether the pattern matches anywhere in the haystack",86,[[["self"],["str"]],["bool"]]],[11,"is_prefix_of","","Checks whether the pattern matches at the front of the haystack",86,[[["self"],["str"]],["bool"]]],[11,"is_suffix_of","","Checks whether the pattern matches at the back of the haystack",86,[[["self"],["str"]],["bool"]]],[4,"SearchStep","","Result of calling `Searcher::next()` or `ReverseSearcher::next_back()`.",N,N],[13,"Match","","Expresses that a match of the pattern has been found at `haystack[a..b]`.",87,N],[13,"Reject","","Expresses that `haystack[a..b]` has been rejected as a possible match of the pattern.",87,N],[13,"Done","","Expresses that every byte of the haystack has been visited, ending the iteration.",87,N],[8,"Searcher","","A searcher for a string pattern.",N,N],[10,"haystack","","Getter for the underlying string to be searched in",88,[[["self"]],["str"]]],[10,"next","","Performs the next search step starting from the front.",88,[[["self"]],["searchstep"]]],[11,"next_match","","Find the next `Match` result. See `next()`",88,[[["self"]],["option"]]],[11,"next_reject","","Find the next `Reject` result. See `next()` and `next_match()`",88,[[["self"]],["option"]]],[8,"ReverseSearcher","","A reverse searcher for a string pattern.",N,N],[10,"next_back","","Performs the next search step starting from the back.",89,[[["self"]],["searchstep"]]],[11,"next_match_back","","Find the next `Match` result. See `next_back()`",89,[[["self"]],["option"]]],[11,"next_reject_back","","Find the next `Reject` result. See `next_back()`",89,[[["self"]],["option"]]],[8,"DoubleEndedSearcher","","A marker trait to express that a `ReverseSearcher` can be used for a `DoubleEndedIterator` implementation.",N,N],[3,"CharSearcher","","Associated type for `<char as Pattern<'a>>::Searcher`.",N,N],[3,"CharSliceSearcher","","Associated type for `<&[char] as Pattern<'a>>::Searcher`.",N,N],[3,"CharPredicateSearcher","","Associated type for `<F as Pattern<'a>>::Searcher`.",N,N],[3,"StrSearcher","","Associated type for `<&str as Pattern<'a>>::Searcher`.",N,N],[8,"FromStr","std::str","A trait to abstract the idea of creating a new instance of a type from a string.",N,N],[16,"Err","","The associated error which can be returned from parsing.",90,N],[10,"from_str","","Parses a string `s` to return a value of this type.",90,[[["str"]],["result"]]],[3,"Utf8Error","","Errors which can occur when attempting to interpret a sequence of [`u8`] as a string.",N,N],[0,"string","std","A UTF-8 encoded, growable string.",N,N],[3,"String","std::string","A UTF-8 encoded, growable string.",N,N],[3,"FromUtf8Error","","A possible error value when converting a `String` from a UTF-8 byte vector.",N,N],[3,"FromUtf16Error","","A possible error value when converting a `String` from a UTF-16 byte slice.",N,N],[4,"ParseError","","An error when parsing a `String`.",N,N],[8,"ToString","","A trait for converting a value to a `String`.",N,N],[10,"to_string","","Converts the given value to a `String`.",91,[[["self"]],["string"]]],[3,"Drain","","A draining iterator for `String`.",N,N],[0,"vec","std","A contiguous growable array type with heap-allocated contents, written `Vec<T>`.",N,N],[3,"Vec","std::vec","A contiguous growable array type, written `Vec<T>` but pronounced 'vector'.",N,N],[3,"IntoIter","","An iterator that moves out of a vector.",N,N],[3,"Drain","","A draining iterator for `Vec<T>`.",N,N],[3,"Splice","","A splicing iterator for `Vec`.",N,N],[3,"DrainFilter","","An iterator produced by calling `drain_filter` on Vec.",N,N],[14,"vec","std","Creates a [`Vec`] containing the arguments.",N,N],[0,"char","","A character type.",N,N],[17,"MAX","std::char","The highest valid code point a `char` can have.",N,N],[17,"REPLACEMENT_CHARACTER","","`U+FFFD REPLACEMENT CHARACTER` (�) is used in Unicode to represent a decoding error.",N,N],[3,"EscapeUnicode","","Returns an iterator that yields the hexadecimal Unicode escape of a character, as `char`s.",N,N],[3,"EscapeDefault","","An iterator that yields the literal escape code of a `char`.",N,N],[3,"EscapeDebug","","An iterator that yields the literal escape code of a `char`.",N,N],[3,"ToLowercase","","Returns an iterator that yields the lowercase equivalent of a `char`.",N,N],[3,"ToUppercase","","Returns an iterator that yields the uppercase equivalent of a `char`.",N,N],[5,"from_digit","","Converts a digit in the given radix to a `char`.",N,[[["u32"],["u32"]],["option",["char"]]]],[3,"DecodeUtf16Error","","An error that can be returned when decoding UTF-16 code points.",N,N],[3,"DecodeUtf16","","An iterator that decodes UTF-16 encoded code points from an iterator of `u16`s.",N,N],[5,"from_u32","","Converts a `u32` to a `char`.",N,[[["u32"]],["option",["char"]]]],[5,"decode_utf16","","Create an iterator over the UTF-16 encoded code points in `iter`, returning unpaired surrogates as `Err`s.",N,[[["i"]],["decodeutf16"]]],[5,"from_u32_unchecked","","Converts a `u32` to a `char`, ignoring validity.",N,[[["u32"]],["char"]]],[5,"decode_utf8","","Decodes an `Iterator` of bytes as UTF-8.",N,[[["i"]],["decodeutf8"]]],[3,"CharTryFromError","","The error type returned when a conversion from u32 to char fails.",N,N],[17,"UNICODE_VERSION","","The version of Unicode that the Unicode parts of `char` and `str` methods are based on.",N,N],[3,"ParseCharError","","An error which can be returned when parsing a char.",N,N],[3,"UnicodeVersion","","Represents a Unicode Version.",N,N],[12,"major","","Major version.",92,N],[12,"minor","","Minor version.",92,N],[12,"micro","","Micro (or Update) version.",92,N],[3,"DecodeUtf8","","An iterator over an iterator of bytes of the characters the bytes represent as UTF-8",N,N],[3,"InvalidSequence","","`<DecodeUtf8 as Iterator>::next` returns this for an invalid input sequence.",N,N],[0,"u128","std","The 128-bit unsigned integer type.",N,N],[17,"MIN","std::u128","The smallest value that can be represented by this integer type.",N,N],[17,"MAX","","The largest value that can be represented by this integer type.",N,N],[0,"hint","std","Hints to compiler that affects how code should be emitted or optimized.",N,N],[5,"unreachable_unchecked","std::hint","Informs the compiler that this point in the code is not reachable, enabling further optimizations.",N,N],[0,"prelude","std","The Rust Prelude.",N,N],[0,"v1","std::prelude","The first version of the prelude of The Rust Standard Library.",N,N],[0,"f32","std","This module provides constants which are specific to the implementation of the `f32` floating point data type.",N,N],[17,"RADIX","std::f32","The radix or base of the internal representation of `f32`.",N,N],[17,"MANTISSA_DIGITS","","Number of significant digits in base 2.",N,N],[17,"DIGITS","","Approximate number of significant digits in base 10.",N,N],[17,"EPSILON","","[Machine epsilon] value for `f32`.",N,N],[17,"MIN_EXP","","One greater than the minimum possible normal power of 2 exponent.",N,N],[17,"MAX_EXP","","Maximum possible power of 2 exponent.",N,N],[17,"MIN_10_EXP","","Minimum possible normal power of 10 exponent.",N,N],[17,"MAX_10_EXP","","Maximum possible power of 10 exponent.",N,N],[17,"NAN","","Not a Number (NaN).",N,N],[17,"INFINITY","","Infinity (∞).",N,N],[17,"NEG_INFINITY","","Negative infinity (-∞).",N,N],[17,"MIN","","Smallest finite `f32` value.",N,N],[17,"MIN_POSITIVE","","Smallest positive normal `f32` value.",N,N],[17,"MAX","","Largest finite `f32` value.",N,N],[0,"consts","","Basic mathematical constants.",N,N],[17,"PI","std::f32::consts","Archimedes' constant (π)",N,N],[17,"FRAC_PI_2","","π/2",N,N],[17,"FRAC_PI_3","","π/3",N,N],[17,"FRAC_PI_4","","π/4",N,N],[17,"FRAC_PI_6","","π/6",N,N],[17,"FRAC_PI_8","","π/8",N,N],[17,"FRAC_1_PI","","1/π",N,N],[17,"FRAC_2_PI","","2/π",N,N],[17,"FRAC_2_SQRT_PI","","2/sqrt(π)",N,N],[17,"SQRT_2","","sqrt(2)",N,N],[17,"FRAC_1_SQRT_2","","1/sqrt(2)",N,N],[17,"E","","Euler's number (e)",N,N],[17,"LOG2_E","","log2(e)",N,N],[17,"LOG2_10","","log2(10)",N,N],[17,"LOG10_E","","log10(e)",N,N],[17,"LOG10_2","","log10(2)",N,N],[17,"LN_2","","ln(2)",N,N],[17,"LN_10","","ln(10)",N,N],[0,"f64","std","This module provides constants which are specific to the implementation of the `f64` floating point data type.",N,N],[17,"RADIX","std::f64","The radix or base of the internal representation of `f64`.",N,N],[17,"MANTISSA_DIGITS","","Number of significant digits in base 2.",N,N],[17,"DIGITS","","Approximate number of significant digits in base 10.",N,N],[17,"EPSILON","","[Machine epsilon] value for `f64`.",N,N],[17,"MIN_EXP","","One greater than the minimum possible normal power of 2 exponent.",N,N],[17,"MAX_EXP","","Maximum possible power of 2 exponent.",N,N],[17,"MIN_10_EXP","","Minimum possible normal power of 10 exponent.",N,N],[17,"MAX_10_EXP","","Maximum possible power of 10 exponent.",N,N],[17,"NAN","","Not a Number (NaN).",N,N],[17,"INFINITY","","Infinity (∞).",N,N],[17,"NEG_INFINITY","","Negative infinity (-∞).",N,N],[17,"MIN","","Smallest finite `f64` value.",N,N],[17,"MIN_POSITIVE","","Smallest positive normal `f64` value.",N,N],[17,"MAX","","Largest finite `f64` value.",N,N],[0,"consts","","Basic mathematical constants.",N,N],[17,"PI","std::f64::consts","Archimedes' constant (π)",N,N],[17,"FRAC_PI_2","","π/2",N,N],[17,"FRAC_PI_3","","π/3",N,N],[17,"FRAC_PI_4","","π/4",N,N],[17,"FRAC_PI_6","","π/6",N,N],[17,"FRAC_PI_8","","π/8",N,N],[17,"FRAC_1_PI","","1/π",N,N],[17,"FRAC_2_PI","","2/π",N,N],[17,"FRAC_2_SQRT_PI","","2/sqrt(π)",N,N],[17,"SQRT_2","","sqrt(2)",N,N],[17,"FRAC_1_SQRT_2","","1/sqrt(2)",N,N],[17,"E","","Euler's number (e)",N,N],[17,"LOG2_10","","log2(10)",N,N],[17,"LOG2_E","","log2(e)",N,N],[17,"LOG10_2","","log10(2)",N,N],[17,"LOG10_E","","log10(e)",N,N],[17,"LN_2","","ln(2)",N,N],[17,"LN_10","","ln(10)",N,N],[0,"thread","std","Native threads.",N,N],[3,"LocalKey","std::thread","A thread local storage key which owns its contents.",N,N],[3,"AccessError","","An error returned by `LocalKey::try_with`.",N,N],[3,"Builder","","Thread factory, which can be used in order to configure the properties of a new thread.",N,N],[3,"ThreadId","","A unique identifier for a running thread.",N,N],[3,"Thread","","A handle to a thread.",N,N],[3,"JoinHandle","","An owned permission to join on a thread (block on its termination).",N,N],[5,"spawn","","Spawns a new thread, returning a [`JoinHandle`] for it.",N,[[["f"]],["joinhandle"]]],[5,"current","","Gets a handle to the thread that invokes it.",N,[[],["thread"]]],[5,"yield_now","","Cooperatively gives up a timeslice to the OS scheduler.",N,[[]]],[5,"panicking","","Determines whether the current thread is unwinding because of panic.",N,[[],["bool"]]],[5,"sleep_ms","","Puts the current thread to sleep for the specified amount of time.",N,[[["u32"]]]],[5,"sleep","","Puts the current thread to sleep for the specified amount of time.",N,[[["duration"]]]],[5,"park","","Blocks unless or until the current thread's token is made available.",N,[[]]],[5,"park_timeout_ms","","Use [`park_timeout`].",N,[[["u32"]]]],[5,"park_timeout","","Blocks unless or until the current thread's token is made available or the specified duration has been reached (may wake spuriously).",N,[[["duration"]]]],[11,"fmt","","",93,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",94,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",94,[[["self"],["formatter"]],["result"]]],[11,"with","","Acquires a reference to the value in this TLS key.",93,[[["self"],["f"]],["r"]]],[11,"try_with","","Acquires a reference to the value in this TLS key.",93,[[["self"],["f"]],["result",["accesserror"]]]],[6,"Result","","A specialized [`Result`] type for threads.",N,N],[11,"fmt","","",95,[[["self"],["formatter"]],["result"]]],[11,"new","","Generates the base configuration for spawning a thread, from which configuration methods can be chained.",95,[[],["builder"]]],[11,"name","","Names the thread-to-be. Currently the name is used for identification only in panic messages.",95,[[["self"],["string"]],["builder"]]],[11,"stack_size","","Sets the size of the stack (in bytes) for the new thread.",95,[[["self"],["usize"]],["builder"]]],[11,"spawn","","Spawns a new thread by taking ownership of the `Builder`, and returns an [`io::Result`] to its [`JoinHandle`].",95,[[["self"],["f"]],["result",["joinhandle"]]]],[11,"eq","","",96,[[["self"],["threadid"]],["bool"]]],[11,"ne","","",96,[[["self"],["threadid"]],["bool"]]],[11,"clone","","",96,[[["self"]],["threadid"]]],[11,"hash","","",96,N],[11,"fmt","","",96,[[["self"],["formatter"]],["result"]]],[11,"clone","","",97,[[["self"]],["thread"]]],[11,"unpark","","Atomically makes the handle's token available if it is not already.",97,[[["self"]]]],[11,"id","","Gets the thread's unique identifier.",97,[[["self"]],["threadid"]]],[11,"name","","Gets the thread's name.",97,[[["self"]],["option",["str"]]]],[11,"fmt","","",97,[[["self"],["formatter"]],["result"]]],[11,"thread","","Extracts a handle to the underlying thread.",98,[[["self"]],["thread"]]],[11,"join","","Waits for the associated thread to finish.",98,[[["self"]],["result"]]],[11,"fmt","","",98,[[["self"],["formatter"]],["result"]]],[0,"ascii","std","Operations on ASCII strings and characters.",N,N],[3,"EscapeDefault","std::ascii","An iterator over the escaped version of a byte.",N,N],[5,"escape_default","","Returns an iterator that produces an escaped version of a `u8`.",N,[[["u8"]],["escapedefault"]]],[8,"AsciiExt","","Extension methods for ASCII-subset only operations.",N,N],[16,"Owned","","Container type for copied ASCII characters.",99,N],[10,"is_ascii","","Checks if the value is within the ASCII range.",99,[[["self"]],["bool"]]],[10,"to_ascii_uppercase","","Makes a copy of the value in its ASCII upper case equivalent.",99,N],[10,"to_ascii_lowercase","","Makes a copy of the value in its ASCII lower case equivalent.",99,N],[10,"eq_ignore_ascii_case","","Checks that two values are an ASCII case-insensitive match.",99,[[["self"],["self"]],["bool"]]],[10,"make_ascii_uppercase","","Converts this type to its ASCII upper case equivalent in-place.",99,[[["self"]]]],[10,"make_ascii_lowercase","","Converts this type to its ASCII lower case equivalent in-place.",99,[[["self"]]]],[11,"is_ascii_alphabetic","","Checks if the value is an ASCII alphabetic character: U+0041 'A' ... U+005A 'Z' or U+0061 'a' ... U+007A 'z'. For strings, true if all characters in the string are ASCII alphabetic.",99,[[["self"]],["bool"]]],[11,"is_ascii_uppercase","","Checks if the value is an ASCII uppercase character: U+0041 'A' ... U+005A 'Z'. For strings, true if all characters in the string are ASCII uppercase.",99,[[["self"]],["bool"]]],[11,"is_ascii_lowercase","","Checks if the value is an ASCII lowercase character: U+0061 'a' ... U+007A 'z'. For strings, true if all characters in the string are ASCII lowercase.",99,[[["self"]],["bool"]]],[11,"is_ascii_alphanumeric","","Checks if the value is an ASCII alphanumeric character: U+0041 'A' ... U+005A 'Z', U+0061 'a' ... U+007A 'z', or U+0030 '0' ... U+0039 '9'. For strings, true if all characters in the string are ASCII alphanumeric.",99,[[["self"]],["bool"]]],[11,"is_ascii_digit","","Checks if the value is an ASCII decimal digit: U+0030 '0' ... U+0039 '9'. For strings, true if all characters in the string are ASCII digits.",99,[[["self"]],["bool"]]],[11,"is_ascii_hexdigit","","Checks if the value is an ASCII hexadecimal digit: U+0030 '0' ... U+0039 '9', U+0041 'A' ... U+0046 'F', or U+0061 'a' ... U+0066 'f'. For strings, true if all characters in the string are ASCII hex digits.",99,[[["self"]],["bool"]]],[11,"is_ascii_punctuation","","Checks if the value is an ASCII punctuation character:",99,[[["self"]],["bool"]]],[11,"is_ascii_graphic","","Checks if the value is an ASCII graphic character: U+0021 '!' ... U+007E '~'. For strings, true if all characters in the string are ASCII graphic characters.",99,[[["self"]],["bool"]]],[11,"is_ascii_whitespace","","Checks if the value is an ASCII whitespace character: U+0020 SPACE, U+0009 HORIZONTAL TAB, U+000A LINE FEED, U+000C FORM FEED, or U+000D CARRIAGE RETURN. For strings, true if all characters in the string are ASCII whitespace.",99,[[["self"]],["bool"]]],[11,"is_ascii_control","","Checks if the value is an ASCII control character: U+0000 NUL ... U+001F UNIT SEPARATOR, or U+007F DELETE. Note that most ASCII whitespace characters are control characters, but SPACE is not.",99,[[["self"]],["bool"]]],[0,"collections","std","Collection types.",N,N],[3,"BinaryHeap","std::collections","A priority queue implemented with a binary heap.",N,N],[3,"BTreeMap","","A map based on a B-Tree.",N,N],[3,"BTreeSet","","A set based on a B-Tree.",N,N],[3,"LinkedList","","A doubly-linked list with owned nodes.",N,N],[3,"VecDeque","","A double-ended queue implemented with a growable ring buffer.",N,N],[0,"binary_heap","","A priority queue implemented with a binary heap.",N,N],[3,"BinaryHeap","std::collections::binary_heap","A priority queue implemented with a binary heap.",N,N],[3,"PeekMut","","Structure wrapping a mutable reference to the greatest item on a `BinaryHeap`.",N,N],[3,"Iter","","An iterator over the elements of a `BinaryHeap`.",N,N],[3,"IntoIter","","An owning iterator over the elements of a `BinaryHeap`.",N,N],[3,"Drain","","A draining iterator over the elements of a `BinaryHeap`.",N,N],[0,"btree_map","std::collections","A map based on a B-Tree.",N,N],[3,"IntoIter","std::collections::btree_map","An owning iterator over the entries of a `BTreeMap`.",N,N],[3,"VacantEntry","","A view into a vacant entry in a `BTreeMap`. It is part of the [`Entry`] enum.",N,N],[3,"Iter","","An iterator over the entries of a `BTreeMap`.",N,N],[3,"Range","","An iterator over a sub-range of entries in a `BTreeMap`.",N,N],[3,"RangeMut","","A mutable iterator over a sub-range of entries in a `BTreeMap`.",N,N],[3,"IterMut","","A mutable iterator over the entries of a `BTreeMap`.",N,N],[4,"Entry","","A view into a single entry in a map, which may either be vacant or occupied.",N,N],[13,"Vacant","","A vacant entry.",100,N],[13,"Occupied","","An occupied entry.",100,N],[3,"Values","","An iterator over the values of a `BTreeMap`.",N,N],[3,"Keys","","An iterator over the keys of a `BTreeMap`.",N,N],[3,"BTreeMap","","A map based on a B-Tree.",N,N],[3,"OccupiedEntry","","A view into an occupied entry in a `BTreeMap`. It is part of the [`Entry`] enum.",N,N],[3,"ValuesMut","","A mutable iterator over the values of a `BTreeMap`.",N,N],[0,"btree_set","std::collections","A set based on a B-Tree.",N,N],[3,"SymmetricDifference","std::collections::btree_set","A lazy iterator producing elements in the symmetric difference of `BTreeSet`s.",N,N],[3,"Difference","","A lazy iterator producing elements in the difference of `BTreeSet`s.",N,N],[3,"IntoIter","","An owning iterator over the items of a `BTreeSet`.",N,N],[3,"BTreeSet","","A set based on a B-Tree.",N,N],[3,"Iter","","An iterator over the items of a `BTreeSet`.",N,N],[3,"Range","","An iterator over a sub-range of items in a `BTreeSet`.",N,N],[3,"Union","","A lazy iterator producing elements in the union of `BTreeSet`s.",N,N],[3,"Intersection","","A lazy iterator producing elements in the intersection of `BTreeSet`s.",N,N],[0,"linked_list","std::collections","A doubly-linked list with owned nodes.",N,N],[3,"LinkedList","std::collections::linked_list","A doubly-linked list with owned nodes.",N,N],[3,"Iter","","An iterator over the elements of a `LinkedList`.",N,N],[3,"IterMut","","A mutable iterator over the elements of a `LinkedList`.",N,N],[3,"IntoIter","","An owning iterator over the elements of a `LinkedList`.",N,N],[3,"DrainFilter","","An iterator produced by calling `drain_filter` on LinkedList.",N,N],[0,"vec_deque","std::collections","A double-ended queue implemented with a growable ring buffer.",N,N],[3,"VecDeque","std::collections::vec_deque","A double-ended queue implemented with a growable ring buffer.",N,N],[3,"Iter","","An iterator over the elements of a `VecDeque`.",N,N],[3,"IterMut","","A mutable iterator over the elements of a `VecDeque`.",N,N],[3,"IntoIter","","An owning iterator over the elements of a `VecDeque`.",N,N],[3,"Drain","","A draining iterator over the elements of a `VecDeque`.",N,N],[4,"CollectionAllocErr","std::collections","Augments `AllocErr` with a CapacityOverflow variant.",N,N],[13,"CapacityOverflow","","Error due to the computed capacity exceeding the collection's maximum (usually `isize::MAX` bytes).",101,N],[13,"AllocErr","","Error due to the allocator (see the `AllocErr` type's docs).",101,N],[3,"HashMap","","A hash map implemented with linear probing and Robin Hood bucket stealing.",N,N],[3,"HashSet","","A hash set implemented as a `HashMap` where the value is `()`.",N,N],[11,"clone","","",102,[[["self"]],["hashmap"]]],[11,"new","","Creates an empty `HashMap`.",102,[[],["hashmap",["randomstate"]]]],[11,"with_capacity","","Creates an empty `HashMap` with the specified capacity.",102,[[["usize"]],["hashmap",["randomstate"]]]],[11,"with_hasher","","Creates an empty `HashMap` which will use the given hash builder to hash keys.",102,[[["s"]],["hashmap"]]],[11,"with_capacity_and_hasher","","Creates an empty `HashMap` with the specified capacity, using `hash_builder` to hash the keys.",102,[[["usize"],["s"]],["hashmap"]]],[11,"hasher","","Returns a reference to the map's [`BuildHasher`].",102,[[["self"]],["s"]]],[11,"capacity","","Returns the number of elements the map can hold without reallocating.",102,[[["self"]],["usize"]]],[11,"reserve","","Reserves capacity for at least `additional` more elements to be inserted in the `HashMap`. The collection may reserve more space to avoid frequent reallocations.",102,[[["self"],["usize"]]]],[11,"try_reserve","","Tries to reserve capacity for at least `additional` more elements to be inserted in the given `HashMap<K,V>`. The collection may reserve more space to avoid frequent reallocations.",102,[[["self"],["usize"]],["result",["collectionallocerr"]]]],[11,"shrink_to_fit","","Shrinks the capacity of the map as much as possible. It will drop down as much as possible while maintaining the internal rules and possibly leaving some space in accordance with the resize policy.",102,[[["self"]]]],[11,"shrink_to","","Shrinks the capacity of the map with a lower limit. It will drop down no lower than the supplied limit while maintaining the internal rules and possibly leaving some space in accordance with the resize policy.",102,[[["self"],["usize"]]]],[11,"keys","","An iterator visiting all keys in arbitrary order. The iterator element type is `&'a K`.",102,[[["self"]],["keys"]]],[11,"values","","An iterator visiting all values in arbitrary order. The iterator element type is `&'a V`.",102,[[["self"]],["values"]]],[11,"values_mut","","An iterator visiting all values mutably in arbitrary order. The iterator element type is `&'a mut V`.",102,[[["self"]],["valuesmut"]]],[11,"iter","","An iterator visiting all key-value pairs in arbitrary order. The iterator element type is `(&'a K, &'a V)`.",102,[[["self"]],["iter"]]],[11,"iter_mut","","An iterator visiting all key-value pairs in arbitrary order, with mutable references to the values. The iterator element type is `(&'a K, &'a mut V)`.",102,[[["self"]],["itermut"]]],[11,"entry","","Gets the given key's corresponding entry in the map for in-place manipulation.",102,[[["self"],["k"]],["entry"]]],[11,"len","","Returns the number of elements in the map.",102,[[["self"]],["usize"]]],[11,"is_empty","","Returns true if the map contains no elements.",102,[[["self"]],["bool"]]],[11,"drain","","Clears the map, returning all key-value pairs as an iterator. Keeps the allocated memory for reuse.",102,[[["self"]],["drain"]]],[11,"clear","","Clears the map, removing all key-value pairs. Keeps the allocated memory for reuse.",102,[[["self"]]]],[11,"get","","Returns a reference to the value corresponding to the key.",102,[[["self"],["q"]],["option"]]],[11,"get_key_value","","Returns the key-value pair corresponding to the supplied key.",102,[[["self"],["q"]],["option"]]],[11,"contains_key","","Returns true if the map contains a value for the specified key.",102,[[["self"],["q"]],["bool"]]],[11,"get_mut","","Returns a mutable reference to the value corresponding to the key.",102,[[["self"],["q"]],["option"]]],[11,"insert","","Inserts a key-value pair into the map.",102,[[["self"],["k"],["v"]],["option"]]],[11,"remove","","Removes a key from the map, returning the value at the key if the key was previously in the map.",102,[[["self"],["q"]],["option"]]],[11,"remove_entry","","Removes a key from the map, returning the stored key and value if the key was previously in the map.",102,[[["self"],["q"]],["option"]]],[11,"retain","","Retains only the elements specified by the predicate.",102,[[["self"],["f"]]]],[11,"eq","","",102,[[["self"],["hashmap"]],["bool"]]],[11,"fmt","","",102,[[["self"],["formatter"]],["result"]]],[11,"default","","Creates an empty `HashMap<K, V, S>`, with the `Default` value for the hasher.",102,[[],["hashmap"]]],[11,"index","","Returns a reference to the value corresponding to the supplied key.",102,[[["self"],["q"]],["v"]]],[11,"into_iter","","Creates a consuming iterator, that is, one that moves each key-value pair out of the map in arbitrary order. The map cannot be used after calling this.",102,[[["self"]],["intoiter"]]],[11,"from_iter","","",102,[[["t"]],["hashmap"]]],[11,"extend","","",102,[[["self"],["t"]]]],[11,"extend","","",102,[[["self"],["t"]]]],[11,"clone","","",103,[[["self"]],["hashset"]]],[11,"new","","Creates an empty `HashSet`.",103,[[],["hashset",["randomstate"]]]],[11,"with_capacity","","Creates an empty `HashSet` with the specified capacity.",103,[[["usize"]],["hashset",["randomstate"]]]],[11,"with_hasher","","Creates a new empty hash set which will use the given hasher to hash keys.",103,[[["s"]],["hashset"]]],[11,"with_capacity_and_hasher","","Creates an empty `HashSet` with with the specified capacity, using `hasher` to hash the keys.",103,[[["usize"],["s"]],["hashset"]]],[11,"hasher","","Returns a reference to the set's [`BuildHasher`].",103,[[["self"]],["s"]]],[11,"capacity","","Returns the number of elements the set can hold without reallocating.",103,[[["self"]],["usize"]]],[11,"reserve","","Reserves capacity for at least `additional` more elements to be inserted in the `HashSet`. The collection may reserve more space to avoid frequent reallocations.",103,[[["self"],["usize"]]]],[11,"shrink_to_fit","","Shrinks the capacity of the set as much as possible. It will drop down as much as possible while maintaining the internal rules and possibly leaving some space in accordance with the resize policy.",103,[[["self"]]]],[11,"shrink_to","","Shrinks the capacity of the set with a lower limit. It will drop down no lower than the supplied limit while maintaining the internal rules and possibly leaving some space in accordance with the resize policy.",103,[[["self"],["usize"]]]],[11,"iter","","An iterator visiting all elements in arbitrary order. The iterator element type is `&'a T`.",103,[[["self"]],["iter"]]],[11,"difference","","Visits the values representing the difference, i.e. the values that are in `self` but not in `other`.",103,[[["self"],["hashset"]],["difference"]]],[11,"symmetric_difference","","Visits the values representing the symmetric difference, i.e. the values that are in `self` or in `other` but not in both.",103,[[["self"],["hashset"]],["symmetricdifference"]]],[11,"intersection","","Visits the values representing the intersection, i.e. the values that are both in `self` and `other`.",103,[[["self"],["hashset"]],["intersection"]]],[11,"union","","Visits the values representing the union, i.e. all the values in `self` or `other`, without duplicates.",103,[[["self"],["hashset"]],["union"]]],[11,"len","","Returns the number of elements in the set.",103,[[["self"]],["usize"]]],[11,"is_empty","","Returns true if the set contains no elements.",103,[[["self"]],["bool"]]],[11,"drain","","Clears the set, returning all elements in an iterator.",103,[[["self"]],["drain"]]],[11,"clear","","Clears the set, removing all values.",103,[[["self"]]]],[11,"contains","","Returns `true` if the set contains a value.",103,[[["self"],["q"]],["bool"]]],[11,"get","","Returns a reference to the value in the set, if any, that is equal to the given value.",103,[[["self"],["q"]],["option"]]],[11,"is_disjoint","","Returns `true` if `self` has no elements in common with `other`. This is equivalent to checking for an empty intersection.",103,[[["self"],["hashset"]],["bool"]]],[11,"is_subset","","Returns `true` if the set is a subset of another, i.e. `other` contains at least all the values in `self`.",103,[[["self"],["hashset"]],["bool"]]],[11,"is_superset","","Returns `true` if the set is a superset of another, i.e. `self` contains at least all the values in `other`.",103,[[["self"],["hashset"]],["bool"]]],[11,"insert","","Adds a value to the set.",103,[[["self"],["t"]],["bool"]]],[11,"replace","","Adds a value to the set, replacing the existing value, if any, that is equal to the given one. Returns the replaced value.",103,[[["self"],["t"]],["option"]]],[11,"remove","","Removes a value from the set. Returns `true` if the value was present in the set.",103,[[["self"],["q"]],["bool"]]],[11,"take","","Removes and returns the value in the set, if any, that is equal to the given one.",103,[[["self"],["q"]],["option"]]],[11,"retain","","Retains only the elements specified by the predicate.",103,[[["self"],["f"]]]],[11,"eq","","",103,[[["self"],["hashset"]],["bool"]]],[11,"fmt","","",103,[[["self"],["formatter"]],["result"]]],[11,"from_iter","","",103,[[["i"]],["hashset"]]],[11,"extend","","",103,[[["self"],["i"]]]],[11,"extend","","",103,[[["self"],["i"]]]],[11,"default","","Creates an empty `HashSet<T, S>` with the `Default` value for the hasher.",103,[[],["hashset"]]],[11,"into_iter","","Creates a consuming iterator, that is, one that moves each value out of the set in arbitrary order. The set cannot be used after calling this.",103,[[["self"]],["intoiter"]]],[0,"hash_map","","A hash map implemented with linear probing and Robin Hood bucket stealing.",N,N],[3,"HashMap","std::collections::hash_map","A hash map implemented with linear probing and Robin Hood bucket stealing.",N,N],[3,"Iter","","An iterator over the entries of a `HashMap`.",N,N],[3,"IterMut","","A mutable iterator over the entries of a `HashMap`.",N,N],[3,"IntoIter","","An owning iterator over the entries of a `HashMap`.",N,N],[3,"Keys","","An iterator over the keys of a `HashMap`.",N,N],[3,"Values","","An iterator over the values of a `HashMap`.",N,N],[3,"Drain","","A draining iterator over the entries of a `HashMap`.",N,N],[3,"ValuesMut","","A mutable iterator over the values of a `HashMap`.",N,N],[3,"OccupiedEntry","","A view into an occupied entry in a `HashMap`. It is part of the [`Entry`] enum.",N,N],[3,"VacantEntry","","A view into a vacant entry in a `HashMap`. It is part of the [`Entry`] enum.",N,N],[3,"RandomState","","`RandomState` is the default state for [`HashMap`] types.",N,N],[3,"DefaultHasher","","The default [`Hasher`] used by [`RandomState`].",N,N],[4,"Entry","","A view into a single entry in a map, which may either be vacant or occupied.",N,N],[13,"Occupied","","An occupied entry.",104,N],[13,"Vacant","","A vacant entry.",104,N],[0,"hash_set","std::collections","A hash set implemented as a `HashMap` where the value is `()`.",N,N],[3,"HashSet","std::collections::hash_set","A hash set implemented as a `HashMap` where the value is `()`.",N,N],[3,"Iter","","An iterator over the items of a `HashSet`.",N,N],[3,"IntoIter","","An owning iterator over the items of a `HashSet`.",N,N],[3,"Drain","","A draining iterator over the items of a `HashSet`.",N,N],[3,"Intersection","","A lazy iterator producing elements in the intersection of `HashSet`s.",N,N],[3,"Difference","","A lazy iterator producing elements in the difference of `HashSet`s.",N,N],[3,"SymmetricDifference","","A lazy iterator producing elements in the symmetric difference of `HashSet`s.",N,N],[3,"Union","","A lazy iterator producing elements in the union of `HashSet`s.",N,N],[0,"env","std","Inspection and manipulation of the process's environment.",N,N],[3,"Vars","std::env","An iterator over a snapshot of the environment variables of this process.",N,N],[3,"VarsOs","","An iterator over a snapshot of the environment variables of this process.",N,N],[3,"SplitPaths","","An iterator that splits an environment variable into paths according to platform-specific conventions.",N,N],[3,"JoinPathsError","","The error type for operations on the `PATH` variable. Possibly returned from the [`env::join_paths`] function.",N,N],[3,"Args","","An iterator over the arguments of a process, yielding a [`String`] value for each argument.",N,N],[3,"ArgsOs","","An iterator over the arguments of a process, yielding an [`OsString`] value for each argument.",N,N],[4,"VarError","","The error type for operations interacting with environment variables. Possibly returned from the [`env::var`] function.",N,N],[13,"NotPresent","","The specified environment variable was not present in the current process's environment.",105,N],[13,"NotUnicode","","The specified environment variable was found, but it did not contain valid unicode data. The found data is returned as a payload of this variant.",105,N],[5,"current_dir","","Returns the current working directory as a [`PathBuf`].",N,[[],["result",["pathbuf"]]]],[5,"set_current_dir","","Changes the current working directory to the specified path.",N,[[["p"]],["result"]]],[5,"vars","","Returns an iterator of (variable, value) pairs of strings, for all the environment variables of the current process.",N,[[],["vars"]]],[5,"vars_os","","Returns an iterator of (variable, value) pairs of OS strings, for all the environment variables of the current process.",N,[[],["varsos"]]],[5,"var","","Fetches the environment variable `key` from the current process.",N,[[["k"]],["result",["string","varerror"]]]],[5,"var_os","","Fetches the environment variable `key` from the current process, returning [`None`] if the variable isn't set.",N,[[["k"]],["option",["osstring"]]]],[5,"set_var","","Sets the environment variable `k` to the value `v` for the currently running process.",N,[[["k"],["v"]]]],[5,"remove_var","","Removes an environment variable from the environment of the currently running process.",N,[[["k"]]]],[5,"split_paths","","Parses input according to platform conventions for the `PATH` environment variable.",N,[[["t"]],["splitpaths"]]],[5,"join_paths","","Joins a collection of [`Path`]s appropriately for the `PATH` environment variable.",N,[[["i"]],["result",["osstring","joinpathserror"]]]],[5,"home_dir","","Returns the path of the current user's home directory if known.",N,[[],["option",["pathbuf"]]]],[5,"temp_dir","","Returns the path of a temporary directory.",N,[[],["pathbuf"]]],[5,"current_exe","","Returns the full filesystem path of the current running executable.",N,[[],["result",["pathbuf"]]]],[5,"args","","Returns the arguments which this program was started with (normally passed via the command line).",N,[[],["args"]]],[5,"args_os","","Returns the arguments which this program was started with (normally passed via the command line).",N,[[],["argsos"]]],[0,"consts","","Constants associated with the current target",N,N],[17,"ARCH","std::env::consts","A string describing the architecture of the CPU that is currently in use.",N,N],[17,"FAMILY","","The family of the operating system. Example value is `unix`.",N,N],[17,"OS","","A string describing the specific operating system in use. Example value is `linux`.",N,N],[17,"DLL_PREFIX","","Specifies the filename prefix used for shared libraries on this platform. Example value is `lib`.",N,N],[17,"DLL_SUFFIX","","Specifies the filename suffix used for shared libraries on this platform. Example value is `.so`.",N,N],[17,"DLL_EXTENSION","","Specifies the file extension used for shared libraries on this platform that goes after the dot. Example value is `so`.",N,N],[17,"EXE_SUFFIX","","Specifies the filename suffix used for executable binaries on this platform. Example value is `.exe`.",N,N],[17,"EXE_EXTENSION","","Specifies the file extension, if any, used for executable binaries on this platform. Example value is `exe`.",N,N],[11,"next","std::env","",106,[[["self"]],["option"]]],[11,"size_hint","","",106,N],[11,"fmt","","",106,[[["self"],["formatter"]],["result"]]],[11,"next","","",107,[[["self"]],["option"]]],[11,"size_hint","","",107,N],[11,"fmt","","",107,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",105,[[["self"],["formatter"]],["result"]]],[11,"eq","","",105,[[["self"],["varerror"]],["bool"]]],[11,"ne","","",105,[[["self"],["varerror"]],["bool"]]],[11,"clone","","",105,[[["self"]],["varerror"]]],[11,"fmt","","",105,[[["self"],["formatter"]],["result"]]],[11,"description","","",105,[[["self"]],["str"]]],[11,"next","","",108,[[["self"]],["option",["pathbuf"]]]],[11,"size_hint","","",108,N],[11,"fmt","","",108,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",109,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",109,[[["self"],["formatter"]],["result"]]],[11,"description","","",109,[[["self"]],["str"]]],[11,"next","","",110,[[["self"]],["option",["string"]]]],[11,"size_hint","","",110,N],[11,"len","","",110,[[["self"]],["usize"]]],[11,"is_empty","","",110,[[["self"]],["bool"]]],[11,"next_back","","",110,[[["self"]],["option",["string"]]]],[11,"fmt","","",110,[[["self"],["formatter"]],["result"]]],[11,"next","","",111,[[["self"]],["option",["osstring"]]]],[11,"size_hint","","",111,N],[11,"len","","",111,[[["self"]],["usize"]]],[11,"is_empty","","",111,[[["self"]],["bool"]]],[11,"next_back","","",111,[[["self"]],["option",["osstring"]]]],[11,"fmt","","",111,[[["self"],["formatter"]],["result"]]],[0,"error","std","Traits for working with Errors.",N,N],[8,"Error","std::error","`Error` is a trait representing the basic expectations for error values, i.e. values of type `E` in [`Result<T, E>`]. Errors must describe themselves through the [`Display`] and [`Debug`] traits, and may provide cause chain information:",N,N],[11,"description","","This method is soft-deprecated.",112,[[["self"]],["str"]]],[11,"cause","","The lower-level cause of this error, if any.",112,[[["self"]],["option",["error"]]]],[11,"from","std::boxed","",113,[[["e"]],["box",["error"]]]],[11,"from","","",113,[[["e"]],["box",["error"]]]],[11,"from","","",113,[[["string"]],["box",["error"]]]],[11,"from","","",113,[[["string"]],["box",["error"]]]],[11,"from","","",113,[[["str"]],["box",["error"]]]],[11,"from","","",113,[[["str"]],["box",["error"]]]],[11,"from","","",113,[[["cow",["str"]]],["box",["error"]]]],[11,"from","","",113,[[["cow",["str"]]],["box",["error"]]]],[11,"description","std::str","",114,[[["self"]],["str"]]],[11,"description","","",115,[[["self"]],["str"]]],[11,"description","std::string","",116,[[["self"]],["str"]]],[11,"description","","",117,[[["self"]],["str"]]],[11,"description","","",118,[[["self"]],["str"]]],[11,"description","std::char","",119,[[["self"]],["str"]]],[11,"description","std::boxed","",113,[[["self"]],["str"]]],[11,"cause","","",113,[[["self"]],["option",["error"]]]],[11,"description","std::fmt","",120,[[["self"]],["str"]]],[11,"description","std::cell","",121,[[["self"]],["str"]]],[11,"description","","",122,[[["self"]],["str"]]],[11,"description","std::char","",123,[[["self"]],["str"]]],[11,"description","","",124,[[["self"]],["str"]]],[11,"is","std::error","Returns true if the boxed type is the same as `T`",112,[[["self"]],["bool"]]],[11,"downcast_ref","","Returns some reference to the boxed value if it is of type `T`, or `None` if it isn't.",112,[[["self"]],["option"]]],[11,"downcast_mut","","Returns some mutable reference to the boxed value if it is of type `T`, or `None` if it isn't.",112,[[["self"]],["option"]]],[11,"is","","Forwards to the method defined on the type `Any`.",112,[[["self"]],["bool"]]],[11,"downcast_ref","","Forwards to the method defined on the type `Any`.",112,[[["self"]],["option"]]],[11,"downcast_mut","","Forwards to the method defined on the type `Any`.",112,[[["self"]],["option"]]],[11,"is","","Forwards to the method defined on the type `Any`.",112,[[["self"]],["bool"]]],[11,"downcast_ref","","Forwards to the method defined on the type `Any`.",112,[[["self"]],["option"]]],[11,"downcast_mut","","Forwards to the method defined on the type `Any`.",112,[[["self"]],["option"]]],[11,"downcast","","Attempt to downcast the box to a concrete type.",112,[[["box"]],["result",["box","box"]]]],[11,"downcast","","Attempt to downcast the box to a concrete type.",112,[[["box"]],["result",["box","box"]]]],[11,"downcast","","Attempt to downcast the box to a concrete type.",112,[[["box"]],["result",["box","box"]]]],[0,"ffi","std","Utilities related to FFI bindings.",N,N],[3,"CString","std::ffi","A type representing an owned, C-compatible, nul-terminated string with no nul bytes in the middle.",N,N],[3,"CStr","","Representation of a borrowed C string.",N,N],[3,"NulError","","An error indicating that an interior nul byte was found.",N,N],[3,"IntoStringError","","An error indicating invalid UTF-8 when converting a [`CString`] into a [`String`].",N,N],[3,"FromBytesWithNulError","","An error indicating that a nul byte was not in the expected position.",N,N],[3,"OsString","","A type that can represent owned, mutable platform-native strings, but is cheaply inter-convertible with Rust strings.",N,N],[3,"OsStr","","Borrowed reference to an OS string (see [`OsString`]).",N,N],[11,"eq","","",125,[[["self"],["cstring"]],["bool"]]],[11,"ne","","",125,[[["self"],["cstring"]],["bool"]]],[11,"partial_cmp","","",125,[[["self"],["cstring"]],["option",["ordering"]]]],[11,"lt","","",125,[[["self"],["cstring"]],["bool"]]],[11,"le","","",125,[[["self"],["cstring"]],["bool"]]],[11,"gt","","",125,[[["self"],["cstring"]],["bool"]]],[11,"ge","","",125,[[["self"],["cstring"]],["bool"]]],[11,"cmp","","",125,[[["self"],["cstring"]],["ordering"]]],[11,"hash","","",125,N],[11,"clone","","",125,[[["self"]],["cstring"]]],[11,"hash","","",126,N],[11,"clone","","",127,[[["self"]],["nulerror"]]],[11,"eq","","",127,[[["self"],["nulerror"]],["bool"]]],[11,"ne","","",127,[[["self"],["nulerror"]],["bool"]]],[11,"fmt","","",127,[[["self"],["formatter"]],["result"]]],[11,"clone","","",128,[[["self"]],["frombyteswithnulerror"]]],[11,"eq","","",128,[[["self"],["frombyteswithnulerror"]],["bool"]]],[11,"ne","","",128,[[["self"],["frombyteswithnulerror"]],["bool"]]],[11,"fmt","","",128,[[["self"],["formatter"]],["result"]]],[11,"clone","","",129,[[["self"]],["intostringerror"]]],[11,"eq","","",129,[[["self"],["intostringerror"]],["bool"]]],[11,"ne","","",129,[[["self"],["intostringerror"]],["bool"]]],[11,"fmt","","",129,[[["self"],["formatter"]],["result"]]],[11,"new","","Creates a new C-compatible string from a container of bytes.",125,[[["t"]],["result",["cstring","nulerror"]]]],[11,"from_vec_unchecked","","Creates a C-compatible string by consuming a byte vector, without checking for interior 0 bytes.",125,[[["vec",["u8"]]],["cstring"]]],[11,"from_raw","","Retakes ownership of a `CString` that was transferred to C via [`into_raw`].",125,N],[11,"into_raw","","Consumes the `CString` and transfers ownership of the string to a C caller.",125,N],[11,"into_string","","Converts the `CString` into a [`String`] if it contains valid UTF-8 data.",125,[[["self"]],["result",["string","intostringerror"]]]],[11,"into_bytes","","Consumes the `CString` and returns the underlying byte buffer.",125,[[["self"]],["vec",["u8"]]]],[11,"into_bytes_with_nul","","Equivalent to the [`into_bytes`] function except that the returned vector includes the trailing nul terminator.",125,[[["self"]],["vec",["u8"]]]],[11,"as_bytes","","Returns the contents of this `CString` as a slice of bytes.",125,N],[11,"as_bytes_with_nul","","Equivalent to the [`as_bytes`] function except that the returned slice includes the trailing nul terminator.",125,N],[11,"as_c_str","","Extracts a [`CStr`] slice containing the entire string.",125,[[["self"]],["cstr"]]],[11,"into_boxed_c_str","","Converts this `CString` into a boxed [`CStr`].",125,[[["self"]],["box",["cstr"]]]],[11,"drop","","",125,[[["self"]]]],[11,"deref","","",125,[[["self"]],["cstr"]]],[11,"fmt","","",125,[[["self"],["formatter"]],["result"]]],[11,"from","std::vec","",130,[[["cstring"]],["vec",["u8"]]]],[11,"fmt","std::ffi","",126,[[["self"],["formatter"]],["result"]]],[11,"default","","Creates an empty `CString`.",125,[[],["cstring"]]],[11,"borrow","","",125,[[["self"]],["cstr"]]],[11,"from","","",125,[[["cow",["cstr"]]],["self"]]],[11,"from","std::boxed","",113,[[["cstr"]],["box",["cstr"]]]],[11,"from","std::ffi","",125,[[["box",["cstr"]]],["cstring"]]],[11,"clone","std::boxed","",113,[[["self"]],["self"]]],[11,"from","","",113,[[["cstring"]],["box",["cstr"]]]],[11,"from","std::borrow","",70,[[["cstring"]],["cow",["cstr"]]]],[11,"from","","",70,[[["cstr"]],["cow",["cstr"]]]],[11,"from","","",70,[[["cstring"]],["cow",["cstr"]]]],[11,"from","std::rc","",131,[[["cstring"]],["rc",["cstr"]]]],[11,"from","","",131,[[["cstr"]],["rc",["cstr"]]]],[11,"default","std::boxed","",113,[[],["box",["cstr"]]]],[11,"nul_position","std::ffi","Returns the position of the nul byte in the slice that caused [`CString::new`] to fail.",127,[[["self"]],["usize"]]],[11,"into_vec","","Consumes this error, returning the underlying vector of bytes which generated the error in the first place.",127,[[["self"]],["vec",["u8"]]]],[11,"description","","",127,[[["self"]],["str"]]],[11,"fmt","","",127,[[["self"],["formatter"]],["result"]]],[11,"description","","",128,[[["self"]],["str"]]],[11,"fmt","","",128,[[["self"],["formatter"]],["result"]]],[11,"into_cstring","","Consumes this error, returning original [`CString`] which generated the error.",129,[[["self"]],["cstring"]]],[11,"utf8_error","","Access the underlying UTF-8 error that was the cause of this error.",129,[[["self"]],["utf8error"]]],[11,"description","","",129,[[["self"]],["str"]]],[11,"cause","","",129,[[["self"]],["option",["error"]]]],[11,"fmt","","",129,[[["self"],["formatter"]],["result"]]],[11,"from_ptr","","Wraps a raw C string with a safe C string wrapper.",126,N],[11,"from_bytes_with_nul","","Creates a C string wrapper from a byte slice.",126,N],[11,"from_bytes_with_nul_unchecked","","Unsafely creates a C string wrapper from a byte slice.",126,N],[11,"as_ptr","","Returns the inner pointer to this C string.",126,N],[11,"to_bytes","","Converts this C string to a byte slice.",126,N],[11,"to_bytes_with_nul","","Converts this C string to a byte slice containing the trailing 0 byte.",126,N],[11,"to_str","","Yields a [`&str`] slice if the `CStr` contains valid UTF-8.",126,[[["self"]],["result",["str","utf8error"]]]],[11,"to_string_lossy","","Converts a `CStr` into a [`Cow`]`<`[`str`]`>`.",126,[[["self"]],["cow",["str"]]]],[11,"into_c_string","","Converts a [`Box`]`<CStr>` into a [`CString`] without copying or allocating.",126,[[["box",["cstr"]]],["cstring"]]],[11,"eq","","",126,[[["self"],["cstr"]],["bool"]]],[11,"partial_cmp","","",126,[[["self"],["cstr"]],["option",["ordering"]]]],[11,"cmp","","",126,[[["self"],["cstr"]],["ordering"]]],[11,"to_owned","","",126,[[["self"]],["cstring"]]],[11,"from","","",125,[[["cstr"]],["cstring"]]],[11,"index","","",125,[[["self"],["rangefull"]],["cstr"]]],[11,"as_ref","","",126,[[["self"]],["cstr"]]],[11,"as_ref","","",125,[[["self"]],["cstr"]]],[11,"clone","","",132,[[["self"]],["osstring"]]],[11,"new","","Constructs a new empty `OsString`.",132,[[],["osstring"]]],[11,"as_os_str","","Converts to an [`OsStr`] slice.",132,[[["self"]],["osstr"]]],[11,"into_string","","Converts the `OsString` into a [`String`] if it contains valid Unicode data.",132,[[["self"]],["result",["string","osstring"]]]],[11,"push","","Extends the string with the given [`&OsStr`] slice.",132,[[["self"],["t"]]]],[11,"with_capacity","","Creates a new `OsString` with the given capacity.",132,[[["usize"]],["osstring"]]],[11,"clear","","Truncates the `OsString` to zero length.",132,[[["self"]]]],[11,"capacity","","Returns the capacity this `OsString` can hold without reallocating.",132,[[["self"]],["usize"]]],[11,"reserve","","Reserves capacity for at least `additional` more capacity to be inserted in the given `OsString`.",132,[[["self"],["usize"]]]],[11,"reserve_exact","","Reserves the minimum capacity for exactly `additional` more capacity to be inserted in the given `OsString`. Does nothing if the capacity is already sufficient.",132,[[["self"],["usize"]]]],[11,"shrink_to_fit","","Shrinks the capacity of the `OsString` to match its length.",132,[[["self"]]]],[11,"shrink_to","","Shrinks the capacity of the `OsString` with a lower bound.",132,[[["self"],["usize"]]]],[11,"into_boxed_os_str","","Converts this `OsString` into a boxed [`OsStr`].",132,[[["self"]],["box",["osstr"]]]],[11,"from","","",132,[[["string"]],["osstring"]]],[11,"from","","",132,[[["t"]],["osstring"]]],[11,"index","","",132,[[["self"],["rangefull"]],["osstr"]]],[11,"deref","","",132,[[["self"]],["osstr"]]],[11,"default","","Constructs an empty `OsString`.",132,[[],["osstring"]]],[11,"fmt","","",132,[[["self"],["formatter"]],["result"]]],[11,"eq","","",132,[[["self"],["osstring"]],["bool"]]],[11,"eq","","",132,[[["self"],["str"]],["bool"]]],[11,"eq","","",132,[[["self"],["str"]],["bool"]]],[11,"partial_cmp","","",132,[[["self"],["osstring"]],["option",["ordering"]]]],[11,"lt","","",132,[[["self"],["osstring"]],["bool"]]],[11,"le","","",132,[[["self"],["osstring"]],["bool"]]],[11,"gt","","",132,[[["self"],["osstring"]],["bool"]]],[11,"ge","","",132,[[["self"],["osstring"]],["bool"]]],[11,"partial_cmp","","",132,[[["self"],["str"]],["option",["ordering"]]]],[11,"cmp","","",132,[[["self"],["osstring"]],["ordering"]]],[11,"hash","","",132,[[["self"],["h"]]]],[11,"new","","Coerces into an `OsStr` slice.",133,[[["s"]],["osstr"]]],[11,"to_str","","Yields a [`&str`] slice if the `OsStr` is valid Unicode.",133,[[["self"]],["option",["str"]]]],[11,"to_string_lossy","","Converts an `OsStr` to a [`Cow`]`<`[`str`]`>`.",133,[[["self"]],["cow",["str"]]]],[11,"to_os_string","","Copies the slice into an owned [`OsString`].",133,[[["self"]],["osstring"]]],[11,"is_empty","","Checks whether the `OsStr` is empty.",133,[[["self"]],["bool"]]],[11,"len","","Returns the length of this `OsStr`.",133,[[["self"]],["usize"]]],[11,"into_os_string","","Converts a [`Box`]`<OsStr>` into an [`OsString`] without copying or allocating.",133,[[["box",["osstr"]]],["osstring"]]],[11,"from","std::boxed","",113,[[["osstr"]],["box",["osstr"]]]],[11,"from","std::ffi","",132,[[["box",["osstr"]]],["osstring"]]],[11,"from","std::boxed","",113,[[["osstring"]],["box",["osstr"]]]],[11,"clone","","",113,[[["self"]],["self"]]],[11,"from","std::rc","",131,[[["osstring"]],["rc",["osstr"]]]],[11,"from","","",131,[[["osstr"]],["rc",["osstr"]]]],[11,"from","std::borrow","",70,[[["osstring"]],["cow",["osstr"]]]],[11,"from","","",70,[[["osstr"]],["cow",["osstr"]]]],[11,"from","","",70,[[["osstring"]],["cow",["osstr"]]]],[11,"from","std::ffi","",132,[[["cow",["osstr"]]],["self"]]],[11,"default","std::boxed","",113,[[],["box",["osstr"]]]],[11,"eq","std::ffi","",133,[[["self"],["osstr"]],["bool"]]],[11,"eq","","",133,[[["self"],["str"]],["bool"]]],[11,"partial_cmp","","",133,[[["self"],["osstr"]],["option",["ordering"]]]],[11,"lt","","",133,[[["self"],["osstr"]],["bool"]]],[11,"le","","",133,[[["self"],["osstr"]],["bool"]]],[11,"gt","","",133,[[["self"],["osstr"]],["bool"]]],[11,"ge","","",133,[[["self"],["osstr"]],["bool"]]],[11,"partial_cmp","","",133,[[["self"],["str"]],["option",["ordering"]]]],[11,"cmp","","",133,[[["self"],["osstr"]],["ordering"]]],[11,"eq","","",132,[[["self"],["osstr"]],["bool"]]],[11,"eq","","",133,[[["self"],["osstring"]],["bool"]]],[11,"partial_cmp","","",132,[[["self"],["osstr"]],["option",["ordering"]]]],[11,"partial_cmp","","",133,[[["self"],["osstring"]],["option",["ordering"]]]],[11,"eq","","",132,[[["self"],["osstr"]],["bool"]]],[11,"partial_cmp","","",132,[[["self"],["osstr"]],["option",["ordering"]]]],[11,"eq","std::borrow","",70,[[["self"],["osstr"]],["bool"]]],[11,"eq","std::ffi","",133,[[["self"],["cow"]],["bool"]]],[11,"partial_cmp","std::borrow","",70,[[["self"],["osstr"]],["option",["ordering"]]]],[11,"partial_cmp","std::ffi","",133,[[["self"],["cow"]],["option",["ordering"]]]],[11,"eq","std::borrow","",70,[[["self"],["osstr"]],["bool"]]],[11,"partial_cmp","","",70,[[["self"],["osstr"]],["option",["ordering"]]]],[11,"eq","","",70,[[["self"],["osstring"]],["bool"]]],[11,"eq","std::ffi","",132,[[["self"],["cow"]],["bool"]]],[11,"partial_cmp","std::borrow","",70,[[["self"],["osstring"]],["option",["ordering"]]]],[11,"partial_cmp","std::ffi","",132,[[["self"],["cow"]],["option",["ordering"]]]],[11,"hash","","",133,[[["self"],["h"]]]],[11,"fmt","","",133,[[["self"],["formatter"]],["result"]]],[11,"borrow","","",132,[[["self"]],["osstr"]]],[11,"to_owned","","",133,[[["self"]],["osstring"]]],[11,"clone_into","","",133,[[["self"],["osstring"]]]],[11,"as_ref","","",133,[[["self"]],["osstr"]]],[11,"as_ref","","",132,[[["self"]],["osstr"]]],[11,"as_ref","std::string","",134,[[["self"]],["osstr"]]],[0,"fs","std","Filesystem manipulation operations.",N,N],[3,"File","std::fs","A reference to an open file on the filesystem.",N,N],[3,"Metadata","","Metadata information about a file.",N,N],[3,"ReadDir","","Iterator over the entries in a directory.",N,N],[3,"DirEntry","","Entries returned by the [`ReadDir`] iterator.",N,N],[3,"OpenOptions","","Options and flags which can be used to configure how a file is opened.",N,N],[3,"Permissions","","Representation of the various permissions on a file.",N,N],[3,"FileType","","A structure representing a type of file with accessors for each file type. It is returned by [`Metadata::file_type`] method.",N,N],[3,"DirBuilder","","A builder used to create directories in various manners.",N,N],[5,"read","","Read the entire contents of a file into a bytes vector.",N,[[["p"]],["result",["vec"]]]],[5,"read_to_string","","Read the entire contents of a file into a string.",N,[[["p"]],["result",["string"]]]],[5,"write","","Write a slice as the entire contents of a file.",N,[[["p"],["c"]],["result"]]],[5,"remove_file","","Removes a file from the filesystem.",N,[[["p"]],["result"]]],[5,"metadata","","Given a path, query the file system to get information about a file, directory, etc.",N,[[["p"]],["result",["metadata"]]]],[5,"symlink_metadata","","Query the metadata about a file without following symlinks.",N,[[["p"]],["result",["metadata"]]]],[5,"rename","","Rename a file or directory to a new name, replacing the original file if `to` already exists.",N,[[["p"],["q"]],["result"]]],[5,"copy","","Copies the contents of one file to another. This function will also copy the permission bits of the original file to the destination file.",N,[[["p"],["q"]],["result",["u64"]]]],[5,"hard_link","","Creates a new hard link on the filesystem.",N,[[["p"],["q"]],["result"]]],[5,"soft_link","","Creates a new symbolic link on the filesystem.",N,[[["p"],["q"]],["result"]]],[5,"read_link","","Reads a symbolic link, returning the file that the link points to.",N,[[["p"]],["result",["pathbuf"]]]],[5,"canonicalize","","Returns the canonical, absolute form of a path with all intermediate components normalized and symbolic links resolved.",N,[[["p"]],["result",["pathbuf"]]]],[5,"create_dir","","Creates a new, empty directory at the provided path",N,[[["p"]],["result"]]],[5,"create_dir_all","","Recursively create a directory and all of its parent components if they are missing.",N,[[["p"]],["result"]]],[5,"remove_dir","","Removes an existing, empty directory.",N,[[["p"]],["result"]]],[5,"remove_dir_all","","Removes a directory at this path, after removing all its contents. Use carefully!",N,[[["p"]],["result"]]],[5,"read_dir","","Returns an iterator over the entries within a directory.",N,[[["p"]],["result",["readdir"]]]],[5,"set_permissions","","Changes the permissions found on a file or a directory.",N,[[["p"],["permissions"]],["result"]]],[11,"clone","","",135,[[["self"]],["metadata"]]],[11,"fmt","","",136,[[["self"],["formatter"]],["result"]]],[11,"clone","","",137,[[["self"]],["openoptions"]]],[11,"fmt","","",137,[[["self"],["formatter"]],["result"]]],[11,"clone","","",138,[[["self"]],["permissions"]]],[11,"eq","","",138,[[["self"],["permissions"]],["bool"]]],[11,"ne","","",138,[[["self"],["permissions"]],["bool"]]],[11,"fmt","","",138,[[["self"],["formatter"]],["result"]]],[11,"clone","","",139,[[["self"]],["filetype"]]],[11,"eq","","",139,[[["self"],["filetype"]],["bool"]]],[11,"ne","","",139,[[["self"],["filetype"]],["bool"]]],[11,"hash","","",139,N],[11,"fmt","","",139,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",140,[[["self"],["formatter"]],["result"]]],[11,"open","","Attempts to open a file in read-only mode.",141,[[["p"]],["result",["file"]]]],[11,"create","","Opens a file in write-only mode.",141,[[["p"]],["result",["file"]]]],[11,"sync_all","","Attempts to sync all OS-internal metadata to disk.",141,[[["self"]],["result"]]],[11,"sync_data","","This function is similar to [`sync_all`], except that it may not synchronize file metadata to the filesystem.",141,[[["self"]],["result"]]],[11,"set_len","","Truncates or extends the underlying file, updating the size of this file to become `size`.",141,[[["self"],["u64"]],["result"]]],[11,"metadata","","Queries metadata about the underlying file.",141,[[["self"]],["result",["metadata"]]]],[11,"try_clone","","Create a new `File` instance that shares the same underlying file handle as the existing `File` instance. Reads, writes, and seeks will affect both `File` instances simultaneously.",141,[[["self"]],["result",["file"]]]],[11,"set_permissions","","Changes the permissions on the underlying file.",141,[[["self"],["permissions"]],["result"]]],[11,"fmt","","",141,[[["self"],["formatter"]],["result"]]],[11,"read","","",141,N],[11,"initializer","","",141,[[["self"]],["initializer"]]],[11,"write","","",141,N],[11,"flush","","",141,[[["self"]],["result"]]],[11,"seek","","",141,[[["self"],["seekfrom"]],["result",["u64"]]]],[11,"new","","Creates a blank new set of options ready for configuration.",137,[[],["openoptions"]]],[11,"read","","Sets the option for read access.",137,[[["self"],["bool"]],["openoptions"]]],[11,"write","","Sets the option for write access.",137,[[["self"],["bool"]],["openoptions"]]],[11,"append","","Sets the option for the append mode.",137,[[["self"],["bool"]],["openoptions"]]],[11,"truncate","","Sets the option for truncating a previous file.",137,[[["self"],["bool"]],["openoptions"]]],[11,"create","","Sets the option for creating a new file.",137,[[["self"],["bool"]],["openoptions"]]],[11,"create_new","","Sets the option to always create a new file.",137,[[["self"],["bool"]],["openoptions"]]],[11,"open","","Opens a file at `path` with the options specified by `self`.",137,[[["self"],["p"]],["result",["file"]]]],[11,"file_type","","Returns the file type for this metadata.",135,[[["self"]],["filetype"]]],[11,"is_dir","","Returns whether this metadata is for a directory. The result is mutually exclusive to the result of [`is_file`], and will be false for symlink metadata obtained from [`symlink_metadata`].",135,[[["self"]],["bool"]]],[11,"is_file","","Returns whether this metadata is for a regular file. The result is mutually exclusive to the result of [`is_dir`], and will be false for symlink metadata obtained from [`symlink_metadata`].",135,[[["self"]],["bool"]]],[11,"len","","Returns the size of the file, in bytes, this metadata is for.",135,[[["self"]],["u64"]]],[11,"permissions","","Returns the permissions of the file this metadata is for.",135,[[["self"]],["permissions"]]],[11,"modified","","Returns the last modification time listed in this metadata.",135,[[["self"]],["result",["systemtime"]]]],[11,"accessed","","Returns the last access time of this metadata.",135,[[["self"]],["result",["systemtime"]]]],[11,"created","","Returns the creation time listed in this metadata.",135,[[["self"]],["result",["systemtime"]]]],[11,"fmt","","",135,[[["self"],["formatter"]],["result"]]],[11,"readonly","","Returns whether these permissions describe a readonly (unwritable) file.",138,[[["self"]],["bool"]]],[11,"set_readonly","","Modifies the readonly flag for this set of permissions. If the `readonly` argument is `true`, using the resulting `Permission` will update file permissions to forbid writing. Conversely, if it's `false`, using the resulting `Permission` will update file permissions to allow writing.",138,[[["self"],["bool"]]]],[11,"is_dir","","Test whether this file type represents a directory. The result is mutually exclusive to the results of [`is_file`] and [`is_symlink`]; only zero or one of these tests may pass.",139,[[["self"]],["bool"]]],[11,"is_file","","Test whether this file type represents a regular file. The result is  mutually exclusive to the results of [`is_dir`] and [`is_symlink`]; only zero or one of these tests may pass.",139,[[["self"]],["bool"]]],[11,"is_symlink","","Test whether this file type represents a symbolic link. The result is mutually exclusive to the results of [`is_dir`] and [`is_file`]; only zero or one of these tests may pass.",139,[[["self"]],["bool"]]],[11,"next","","",136,[[["self"]],["option",["result"]]]],[11,"path","","Returns the full path to the file that this entry represents.",142,[[["self"]],["pathbuf"]]],[11,"metadata","","Return the metadata for the file that this entry points at.",142,[[["self"]],["result",["metadata"]]]],[11,"file_type","","Return the file type for the file that this entry points at.",142,[[["self"]],["result",["filetype"]]]],[11,"file_name","","Returns the bare file name of this directory entry without any other leading path component.",142,[[["self"]],["osstring"]]],[11,"fmt","","",142,[[["self"],["formatter"]],["result"]]],[11,"new","","Creates a new set of options with default mode/security settings for all platforms and also non-recursive.",140,[[],["dirbuilder"]]],[11,"recursive","","Indicates that directories should be created recursively, creating all parent directories. Parents that do not exist are created with the same security and permissions settings.",140,[[["self"],["bool"]],["self"]]],[11,"create","","Create the specified directory with the options configured in this builder.",140,[[["self"],["p"]],["result"]]],[0,"io","std","Traits, helpers, and type definitions for core I/O functionality.",N,N],[3,"BufReader","std::io","The `BufReader` struct adds buffering to any reader.",N,N],[3,"BufWriter","","Wraps a writer and buffers its output.",N,N],[3,"LineWriter","","Wraps a writer and buffers output to it, flushing whenever a newline (`0x0a`, `'\\n'`) is detected.",N,N],[3,"IntoInnerError","","An error returned by `into_inner` which combines an error that happened while writing out the buffer, and the buffered writer object which may be used to recover from the condition.",N,N],[3,"Cursor","","A `Cursor` wraps an in-memory buffer and provides it with a [`Seek`] implementation.",N,N],[3,"Error","","The error type for I/O operations of the [`Read`], [`Write`], [`Seek`], and associated traits.",N,N],[3,"Sink","","A writer which will move data into the void.",N,N],[3,"Empty","","A reader which is always at EOF.",N,N],[3,"Repeat","","A reader which yields one byte over and over and over and over and over and...",N,N],[3,"Stdin","","A handle to the standard input stream of a process.",N,N],[3,"Stdout","","A handle to the global standard output stream of the current process.",N,N],[3,"Stderr","","A handle to the standard error stream of a process.",N,N],[3,"StdoutLock","","A locked reference to the `Stdout` handle.",N,N],[3,"StderrLock","","A locked reference to the `Stderr` handle.",N,N],[3,"StdinLock","","A locked reference to the `Stdin` handle.",N,N],[3,"Initializer","","A type used to conditionally initialize buffers passed to `Read` methods.",N,N],[3,"Chain","","Adaptor to chain together two readers.",N,N],[3,"Take","","Reader adaptor which limits the bytes read from an underlying reader.",N,N],[3,"Bytes","","An iterator over `u8` values of a reader.",N,N],[3,"Chars","","An iterator over the `char`s of a reader.",N,N],[3,"Split","","An iterator over the contents of an instance of `BufRead` split on a particular byte.",N,N],[3,"Lines","","An iterator over the lines of an instance of `BufRead`.",N,N],[4,"ErrorKind","","A list specifying general categories of I/O error.",N,N],[13,"NotFound","","An entity was not found, often a file.",143,N],[13,"PermissionDenied","","The operation lacked the necessary privileges to complete.",143,N],[13,"ConnectionRefused","","The connection was refused by the remote server.",143,N],[13,"ConnectionReset","","The connection was reset by the remote server.",143,N],[13,"ConnectionAborted","","The connection was aborted (terminated) by the remote server.",143,N],[13,"NotConnected","","The network operation failed because it was not connected yet.",143,N],[13,"AddrInUse","","A socket address could not be bound because the address is already in use elsewhere.",143,N],[13,"AddrNotAvailable","","A nonexistent interface was requested or the requested address was not local.",143,N],[13,"BrokenPipe","","The operation failed because a pipe was closed.",143,N],[13,"AlreadyExists","","An entity already exists, often a file.",143,N],[13,"WouldBlock","","The operation needs to block to complete, but the blocking operation was requested to not occur.",143,N],[13,"InvalidInput","","A parameter was incorrect.",143,N],[13,"InvalidData","","Data not valid for the operation were encountered.",143,N],[13,"TimedOut","","The I/O operation's timeout expired, causing it to be canceled.",143,N],[13,"WriteZero","","An error returned when an operation could not be completed because a call to [`write`] returned [`Ok(0)`].",143,N],[13,"Interrupted","","This operation was interrupted.",143,N],[13,"Other","","Any I/O error not part of this list.",143,N],[13,"UnexpectedEof","","An error returned when an operation could not be completed because an \"end of file\" was reached prematurely.",143,N],[4,"SeekFrom","","Enumeration of possible methods to seek within an I/O object.",N,N],[13,"Start","","Set the offset to the provided number of bytes.",144,N],[13,"End","","Set the offset to the size of this object plus the specified number of bytes.",144,N],[13,"Current","","Set the offset to the current position plus the specified number of bytes.",144,N],[4,"CharsError","","An enumeration of possible errors that can be generated from the `Chars` adapter.",N,N],[13,"NotUtf8","","Variant representing that the underlying stream was read successfully but it did not contain valid utf8 data.",145,N],[13,"Other","","Variant representing that an I/O error occurred.",145,N],[5,"copy","","Copies the entire contents of a reader into a writer.",N,[[["r"],["w"]],["result",["u64"]]]],[5,"sink","","Creates an instance of a writer which will successfully consume all data.",N,[[],["sink"]]],[5,"empty","","Constructs a new handle to an empty reader.",N,[[],["empty"]]],[5,"repeat","","Creates an instance of a reader that infinitely repeats one byte.",N,[[["u8"]],["repeat"]]],[5,"stdin","","Constructs a new handle to the standard input of the current process.",N,[[],["stdin"]]],[5,"stdout","","Constructs a new handle to the standard output of the current process.",N,[[],["stdout"]]],[5,"stderr","","Constructs a new handle to the standard error of the current process.",N,[[],["stderr"]]],[0,"prelude","","The I/O Prelude",N,N],[11,"new","","Creates a new `BufReader` with a default buffer capacity. The default is currently 8 KB, but may change in the future.",146,[[["r"]],["bufreader"]]],[11,"with_capacity","","Creates a new `BufReader` with the specified buffer capacity.",146,[[["usize"],["r"]],["bufreader"]]],[11,"get_ref","","Gets a reference to the underlying reader.",146,[[["self"]],["r"]]],[11,"get_mut","","Gets a mutable reference to the underlying reader.",146,[[["self"]],["r"]]],[11,"is_empty","","Returns `true` if there are no bytes in the internal buffer.",146,[[["self"]],["bool"]]],[11,"buffer","","Returns a reference to the internally buffered data.",146,N],[11,"into_inner","","Unwraps this `BufReader`, returning the underlying reader.",146,[[["self"]],["r"]]],[11,"seek_relative","","Seeks relative to the current position. If the new position lies within the buffer, the buffer will not be flushed, allowing for more efficient seeks. This method does not return the location of the underlying reader, so the caller must track this information themselves if it is required.",146,[[["self"],["i64"]],["result"]]],[11,"read","","",146,N],[11,"initializer","","",146,[[["self"]],["initializer"]]],[11,"fill_buf","","",146,[[["self"]],["result"]]],[11,"consume","","",146,[[["self"],["usize"]]]],[11,"fmt","","",146,[[["self"],["formatter"]],["result"]]],[11,"seek","","Seek to an offset, in bytes, in the underlying reader.",146,[[["self"],["seekfrom"]],["result",["u64"]]]],[11,"fmt","","",147,[[["self"],["formatter"]],["result"]]],[11,"new","","Creates a new `BufWriter` with a default buffer capacity. The default is currently 8 KB, but may change in the future.",148,[[["w"]],["bufwriter"]]],[11,"with_capacity","","Creates a new `BufWriter` with the specified buffer capacity.",148,[[["usize"],["w"]],["bufwriter"]]],[11,"get_ref","","Gets a reference to the underlying writer.",148,[[["self"]],["w"]]],[11,"get_mut","","Gets a mutable reference to the underlying writer.",148,[[["self"]],["w"]]],[11,"into_inner","","Unwraps this `BufWriter`, returning the underlying writer.",148,[[["self"]],["result",["intoinnererror"]]]],[11,"write","","",148,N],[11,"flush","","",148,[[["self"]],["result"]]],[11,"fmt","","",148,[[["self"],["formatter"]],["result"]]],[11,"seek","","Seek to the offset, in bytes, in the underlying writer.",148,[[["self"],["seekfrom"]],["result",["u64"]]]],[11,"drop","","",148,[[["self"]]]],[11,"error","","Returns the error which caused the call to `into_inner()` to fail.",147,[[["self"]],["error"]]],[11,"into_inner","","Returns the buffered writer instance which generated the error.",147,[[["self"]],["w"]]],[11,"from","","",149,[[["intoinnererror"]],["error"]]],[11,"description","","",147,[[["self"]],["str"]]],[11,"fmt","","",147,[[["self"],["formatter"]],["result"]]],[11,"new","","Creates a new `LineWriter`.",150,[[["w"]],["linewriter"]]],[11,"with_capacity","","Creates a new `LineWriter` with a specified capacity for the internal buffer.",150,[[["usize"],["w"]],["linewriter"]]],[11,"get_ref","","Gets a reference to the underlying writer.",150,[[["self"]],["w"]]],[11,"get_mut","","Gets a mutable reference to the underlying writer.",150,[[["self"]],["w"]]],[11,"into_inner","","Unwraps this `LineWriter`, returning the underlying writer.",150,[[["self"]],["result",["intoinnererror"]]]],[11,"write","","",150,N],[11,"flush","","",150,[[["self"]],["result"]]],[11,"fmt","","",150,[[["self"],["formatter"]],["result"]]],[11,"clone","","",151,[[["self"]],["cursor"]]],[11,"fmt","","",151,[[["self"],["formatter"]],["result"]]],[11,"new","","Creates a new cursor wrapping the provided underlying in-memory buffer.",151,[[["t"]],["cursor"]]],[11,"into_inner","","Consumes this cursor, returning the underlying value.",151,[[["self"]],["t"]]],[11,"get_ref","","Gets a reference to the underlying value in this cursor.",151,[[["self"]],["t"]]],[11,"get_mut","","Gets a mutable reference to the underlying value in this cursor.",151,[[["self"]],["t"]]],[11,"position","","Returns the current position of this cursor.",151,[[["self"]],["u64"]]],[11,"set_position","","Sets the position of this cursor.",151,[[["self"],["u64"]]]],[11,"seek","","",151,[[["self"],["seekfrom"]],["result",["u64"]]]],[11,"read","","",151,N],[11,"read_exact","","",151,N],[11,"initializer","","",151,[[["self"]],["initializer"]]],[11,"fill_buf","","",151,[[["self"]],["result"]]],[11,"consume","","",151,[[["self"],["usize"]]]],[11,"write","","",151,N],[11,"flush","","",151,[[["self"]],["result"]]],[11,"write","","",151,N],[11,"flush","","",151,[[["self"]],["result"]]],[11,"write","","",151,N],[11,"flush","","",151,[[["self"]],["result"]]],[11,"write","","",151,N],[11,"flush","","",151,[[["self"]],["result"]]],[11,"fmt","","",149,[[["self"],["formatter"]],["result"]]],[11,"clone","","",143,[[["self"]],["errorkind"]]],[11,"fmt","","",143,[[["self"],["formatter"]],["result"]]],[11,"hash","","",143,N],[11,"cmp","","",143,[[["self"],["errorkind"]],["ordering"]]],[11,"eq","","",143,[[["self"],["errorkind"]],["bool"]]],[11,"partial_cmp","","",143,[[["self"],["errorkind"]],["option",["ordering"]]]],[11,"from","","",149,[[["errorkind"]],["error"]]],[11,"new","","Creates a new I/O error from a known kind of error as well as an arbitrary error payload.",149,[[["errorkind"],["e"]],["error"]]],[11,"last_os_error","","Returns an error representing the last OS error which occurred.",149,[[],["error"]]],[11,"from_raw_os_error","","Creates a new instance of an `Error` from a particular OS error code.",149,[[["i32"]],["error"]]],[11,"raw_os_error","","Returns the OS error that this error represents (if any).",149,[[["self"]],["option",["i32"]]]],[11,"get_ref","","Returns a reference to the inner error wrapped by this error (if any).",149,[[["self"]],["option",["error"]]]],[11,"get_mut","","Returns a mutable reference to the inner error wrapped by this error (if any).",149,[[["self"]],["option",["error"]]]],[11,"into_inner","","Consumes the `Error`, returning its inner error (if any).",149,[[["self"]],["option",["box"]]]],[11,"kind","","Returns the corresponding `ErrorKind` for this error.",149,[[["self"]],["errorkind"]]],[11,"fmt","","",149,[[["self"],["formatter"]],["result"]]],[11,"description","","",149,[[["self"]],["str"]]],[11,"cause","","",149,[[["self"]],["option",["error"]]]],[11,"read","std::boxed","",113,N],[11,"initializer","","",113,[[["self"]],["initializer"]]],[11,"read_to_end","","",113,[[["self"],["vec"]],["result",["usize"]]]],[11,"read_to_string","","",113,[[["self"],["string"]],["result",["usize"]]]],[11,"read_exact","","",113,N],[11,"write","","",113,N],[11,"flush","","",113,[[["self"]],["result"]]],[11,"write_all","","",113,N],[11,"write_fmt","","",113,[[["self"],["arguments"]],["result"]]],[11,"seek","","",113,[[["self"],["seekfrom"]],["result",["u64"]]]],[11,"fill_buf","","",113,[[["self"]],["result"]]],[11,"consume","","",113,[[["self"],["usize"]]]],[11,"read_until","","",113,[[["self"],["u8"],["vec"]],["result",["usize"]]]],[11,"read_line","","",113,[[["self"],["string"]],["result",["usize"]]]],[11,"write","std::vec","",130,N],[11,"write_all","","",130,N],[11,"flush","","",130,[[["self"]],["result"]]],[11,"read","std::io","",152,N],[11,"initializer","","",152,[[["self"]],["initializer"]]],[11,"fill_buf","","",152,[[["self"]],["result"]]],[11,"consume","","",152,[[["self"],["usize"]]]],[11,"fmt","","",152,[[["self"],["formatter"]],["result"]]],[11,"read","","",153,N],[11,"initializer","","",153,[[["self"]],["initializer"]]],[11,"fmt","","",153,[[["self"],["formatter"]],["result"]]],[11,"write","","",154,N],[11,"flush","","",154,[[["self"]],["result"]]],[11,"fmt","","",154,[[["self"],["formatter"]],["result"]]],[11,"lock","","Locks this handle to the standard input stream, returning a readable guard.",155,[[["self"]],["stdinlock"]]],[11,"read_line","","Locks this handle and reads a line of input into the specified buffer.",155,[[["self"],["string"]],["result",["usize"]]]],[11,"fmt","","",155,[[["self"],["formatter"]],["result"]]],[11,"read","","",155,N],[11,"initializer","","",155,[[["self"]],["initializer"]]],[11,"read_to_end","","",155,[[["self"],["vec"]],["result",["usize"]]]],[11,"read_to_string","","",155,[[["self"],["string"]],["result",["usize"]]]],[11,"read_exact","","",155,N],[11,"read","","",156,N],[11,"initializer","","",156,[[["self"]],["initializer"]]],[11,"fill_buf","","",156,[[["self"]],["result"]]],[11,"consume","","",156,[[["self"],["usize"]]]],[11,"fmt","","",156,[[["self"],["formatter"]],["result"]]],[11,"lock","","Locks this handle to the standard output stream, returning a writable guard.",157,[[["self"]],["stdoutlock"]]],[11,"fmt","","",157,[[["self"],["formatter"]],["result"]]],[11,"write","","",157,N],[11,"flush","","",157,[[["self"]],["result"]]],[11,"write_all","","",157,N],[11,"write_fmt","","",157,[[["self"],["arguments"]],["result"]]],[11,"write","","",158,N],[11,"flush","","",158,[[["self"]],["result"]]],[11,"fmt","","",158,[[["self"],["formatter"]],["result"]]],[11,"lock","","Locks this handle to the standard error stream, returning a writable guard.",159,[[["self"]],["stderrlock"]]],[11,"fmt","","",159,[[["self"],["formatter"]],["result"]]],[11,"write","","",159,N],[11,"flush","","",159,[[["self"]],["result"]]],[11,"write_all","","",159,N],[11,"write_fmt","","",159,[[["self"],["arguments"]],["result"]]],[11,"write","","",160,N],[11,"flush","","",160,[[["self"]],["result"]]],[11,"fmt","","",160,[[["self"],["formatter"]],["result"]]],[6,"Result","","A specialized `Result` type for I/O operations.",N,N],[8,"Read","","The `Read` trait allows for reading bytes from a source.",N,N],[10,"read","","Pull some bytes from this source into the specified buffer, returning how many bytes were read.",161,N],[11,"initializer","","Determines if this `Read`er can work with buffers of uninitialized memory.",161,[[["self"]],["initializer"]]],[11,"read_to_end","","Read all bytes until EOF in this source, placing them into `buf`.",161,[[["self"],["vec"]],["result",["usize"]]]],[11,"read_to_string","","Read all bytes until EOF in this source, appending them to `buf`.",161,[[["self"],["string"]],["result",["usize"]]]],[11,"read_exact","","Read the exact number of bytes required to fill `buf`.",161,N],[11,"by_ref","","Creates a \"by reference\" adaptor for this instance of `Read`.",161,[[["self"]],["self"]]],[11,"bytes","","Transforms this `Read` instance to an [`Iterator`] over its bytes.",161,[[["self"]],["bytes"]]],[11,"chars","","Transforms this `Read` instance to an [`Iterator`] over [`char`]s.",161,[[["self"]],["chars"]]],[11,"chain","","Creates an adaptor which will chain this stream with another.",161,[[["self"],["r"]],["chain"]]],[11,"take","","Creates an adaptor which will read at most `limit` bytes from it.",161,[[["self"],["u64"]],["take"]]],[8,"Write","","A trait for objects which are byte-oriented sinks.",N,N],[10,"write","","Write a buffer into this object, returning how many bytes were written.",162,N],[10,"flush","","Flush this output stream, ensuring that all intermediately buffered contents reach their destination.",162,[[["self"]],["result"]]],[11,"write_all","","Attempts to write an entire buffer into this write.",162,N],[11,"write_fmt","","Writes a formatted string into this writer, returning any error encountered.",162,[[["self"],["arguments"]],["result"]]],[11,"by_ref","","Creates a \"by reference\" adaptor for this instance of `Write`.",162,[[["self"]],["self"]]],[8,"Seek","","The `Seek` trait provides a cursor which can be moved within a stream of bytes.",N,N],[10,"seek","","Seek to an offset, in bytes, in a stream.",163,[[["self"],["seekfrom"]],["result",["u64"]]]],[8,"BufRead","","A `BufRead` is a type of `Read`er which has an internal buffer, allowing it to perform extra ways of reading.",N,N],[10,"fill_buf","","Fills the internal buffer of this object, returning the buffer contents.",164,[[["self"]],["result"]]],[10,"consume","","Tells this buffer that `amt` bytes have been consumed from the buffer, so they should no longer be returned in calls to `read`.",164,[[["self"],["usize"]]]],[11,"read_until","","Read all bytes into `buf` until the delimiter `byte` or EOF is reached.",164,[[["self"],["u8"],["vec"]],["result",["usize"]]]],[11,"read_line","","Read all bytes until a newline (the 0xA byte) is reached, and append them to the provided buffer.",164,[[["self"],["string"]],["result",["usize"]]]],[11,"split","","Returns an iterator over the contents of this reader split on the byte `byte`.",164,[[["self"],["u8"]],["split"]]],[11,"lines","","Returns an iterator over the lines of this reader.",164,[[["self"]],["lines"]]],[11,"fmt","","",165,[[["self"],["formatter"]],["result"]]],[11,"zeroing","","Returns a new `Initializer` which will zero out buffers.",165,[[],["initializer"]]],[11,"nop","","Returns a new `Initializer` which will not zero out buffers.",165,[[],["initializer"]]],[11,"should_initialize","","Indicates if a buffer should be initialized.",165,[[["self"]],["bool"]]],[11,"initialize","","Initializes a buffer if necessary.",165,N],[11,"eq","","",144,[[["self"],["seekfrom"]],["bool"]]],[11,"ne","","",144,[[["self"],["seekfrom"]],["bool"]]],[11,"clone","","",144,[[["self"]],["seekfrom"]]],[11,"fmt","","",144,[[["self"],["formatter"]],["result"]]],[11,"into_inner","","Consumes the `Chain`, returning the wrapped readers.",166,N],[11,"get_ref","","Gets references to the underlying readers in this `Chain`.",166,N],[11,"get_mut","","Gets mutable references to the underlying readers in this `Chain`.",166,N],[11,"fmt","","",166,[[["self"],["formatter"]],["result"]]],[11,"read","","",166,N],[11,"initializer","","",166,[[["self"]],["initializer"]]],[11,"fill_buf","","",166,[[["self"]],["result"]]],[11,"consume","","",166,[[["self"],["usize"]]]],[11,"fmt","","",167,[[["self"],["formatter"]],["result"]]],[11,"limit","","Returns the number of bytes that can be read before this instance will return EOF.",167,[[["self"]],["u64"]]],[11,"set_limit","","Sets the number of bytes that can be read before this instance will return EOF. This is the same as constructing a new `Take` instance, so the amount of bytes read and the previous limit value don't matter when calling this method.",167,[[["self"],["u64"]]]],[11,"into_inner","","Consumes the `Take`, returning the wrapped reader.",167,[[["self"]],["t"]]],[11,"get_ref","","Gets a reference to the underlying reader.",167,[[["self"]],["t"]]],[11,"get_mut","","Gets a mutable reference to the underlying reader.",167,[[["self"]],["t"]]],[11,"read","","",167,N],[11,"initializer","","",167,[[["self"]],["initializer"]]],[11,"fill_buf","","",167,[[["self"]],["result"]]],[11,"consume","","",167,[[["self"],["usize"]]]],[11,