var searchIndex = {};
searchIndex['syntax'] = {"items":[[0,"","syntax","The Rust parser and macro expander."],[0,"util","",""],[0,"interner","syntax::util","An \"interner\" is a data structure that associates values with uint tags and\nallows bidirectional lookup; i.e. given a value, one can easily find the\ntype, and vice versa."],[1,"Interner","syntax::util::interner",""],[1,"RcStr","",""],[1,"StrInterner","","A StrInterner differs from Interner<String> in that it accepts\n&str rather than RcStr, resulting in less allocation."],[10,"new","","",0],[10,"prefill","","",0],[10,"intern","","",0],[10,"gensym","","",0],[10,"get","","",0],[10,"len","","",0],[10,"find","","",0],[10,"clear","","",0],[10,"partial_cmp","","",1],[10,"lt","","",1],[10,"le","","",1],[10,"gt","","",1],[10,"ge","","",1],[10,"hash","","",1],[10,"eq","","",1],[10,"ne","","",1],[10,"clone","","",1],[10,"new","","",1],[10,"cmp","","",1],[10,"fmt","","",1],[10,"deref","","",1],[10,"new","","",2],[10,"prefill","","",2],[10,"intern","","",2],[10,"gensym","","",2],[10,"gensym_copy","","Create a gensym with the same name as an existing\nentry.",2],[10,"get","","",2],[10,"len","","",2],[10,"find","","",2],[10,"clear","","",2],[10,"reset","","",2],[0,"small_vector","syntax::util",""],[1,"SmallVector","syntax::util::small_vector","A vector type optimized for cases where the size is almost always 0 or 1"],[1,"IntoIter","",""],[10,"from_iter","","",3],[10,"extend","","",3],[10,"zero","","",3],[10,"one","","",3],[10,"many","","",3],[10,"as_slice","","",3],[10,"push","","",3],[10,"push_all","","",3],[10,"get","","",3],[10,"expect_one","","",3],[10,"move_iter","","Deprecated: use `into_iter`.",3],[10,"into_iter","","",3],[10,"len","","",3],[10,"is_empty","","",3],[10,"next","","",4],[10,"size_hint","","",4],[10,"move_map","","",3],[0,"diagnostics","syntax",""],[0,"plugin","syntax::diagnostics",""],[3,"expand_diagnostic_used","syntax::diagnostics::plugin",""],[3,"expand_register_diagnostic","",""],[3,"expand_build_diagnostic_array","",""],[0,"registry","syntax::diagnostics",""],[1,"Registry","syntax::diagnostics::registry",""],[10,"new","","",5],[10,"find_description","","",5],[0,"syntax","syntax",""],[0,"abi","",""],[1,"AbiData","syntax::abi",""],[2,"Os","",""],[12,"OsWindows","","",6],[12,"OsMacos","","",6],[12,"OsLinux","","",6],[12,"OsAndroid","","",6],[12,"OsFreebsd","","",6],[12,"OsiOS","","",6],[12,"OsDragonfly","","",6],[2,"Abi","",""],[12,"Cdecl","","",7],[12,"Stdcall","","",7],[12,"Fastcall","","",7],[12,"Aapcs","","",7],[12,"Win64","","",7],[12,"Rust","","",7],[12,"C","","",7],[12,"System","","",7],[12,"RustIntrinsic","","",7],[12,"RustCall","","",7],[2,"Architecture","",""],[12,"X86","","",8],[12,"X86_64","","",8],[12,"Arm","","",8],[12,"Mips","","",8],[12,"Mipsel","","",8],[2,"AbiArchitecture","",""],[12,"RustArch","","Not a real ABI (e.g., intrinsic)",9],[12,"AllArch","","An ABI that specifies cross-platform defaults (e.g., \"C\")",9],[12,"Archs","","Multiple architectures (bitset)",9],[3,"lookup","","Returns the ABI with the given name (if any)."],[3,"all_names","",""],[10,"eq","","",6],[10,"ne","","",6],[10,"clone","","",7],[10,"decode","","",7],[10,"encode","","",7],[10,"hash","","",7],[10,"eq","","",7],[10,"ne","","",7],[10,"eq","","",8],[10,"ne","","",8],[10,"index","","",7],[10,"data","","",7],[10,"name","","",7],[10,"fmt","","",7],[10,"fmt","","",6],[0,"ast","syntax",""],[1,"Ident","syntax::ast","An identifier contains a Name (index into the interner\ntable) and a SyntaxContext to track renaming and\nmacro expansion per Flatt et al., \"Macros\nThat Work Together\""],[11,"name","","",10],[11,"ctxt","","",10],[1,"Name","","A name is a part of an identifier, representing a string or gensym. It's\nthe result of interning."],[1,"Lifetime","",""],[11,"id","","",11],[11,"span","","",11],[11,"name","","",11],[1,"LifetimeDef","",""],[11,"lifetime","","",12],[11,"bounds","","",12],[1,"Path","","A \"Path\" is essentially Rust's notion of a name; for instance:\nstd::cmp::PartialEq  .  It's represented as a sequence of identifiers,\nalong with a bunch of supporting information."],[11,"span","","",13],[11,"global","","A `::foo` path, is relative to the crate root rather than current\nmodule (like paths in an import).",13],[11,"segments","","The segments in the path: the things separated by `::`.",13],[1,"PathSegment","","A segment of a path: an identifier, an optional lifetime, and a set of\ntypes."],[11,"identifier","","The identifier portion of this path segment.",14],[11,"parameters","","Type/lifetime parameters attached to this path. They come in\ntwo flavors: `Path<A,B,C>` and `Path(A,B) -> C`. Note that\nthis is more than just simple syntactic sugar; the use of\nparens affects the region binding rules, so we preserve the\ndistinction.",14],[1,"AngleBracketedParameterData","","A path like `Foo<'a, T>`"],[11,"lifetimes","","The lifetime parameters for this path segment.",15],[11,"types","","The type parameters for this path segment, if present.",15],[11,"bindings","","Bindings (equality constraints) on associated types, if present.\nE.g., `Foo<A=Bar>`.",15],[1,"ParenthesizedParameterData","","A path like `Foo(A,B) -> C`"],[11,"inputs","","`(A,B)`",16],[11,"output","","`C`",16],[1,"DefId","",""],[11,"krate","","",17],[11,"node","","",17],[1,"TyParam","",""],[11,"ident","","",18],[11,"id","","",18],[11,"bounds","","",18],[11,"default","","",18],[11,"span","","",18],[1,"Generics","","Represents lifetimes and type parameters attached to a declaration\nof a function, enum, trait, etc."],[11,"lifetimes","","",19],[11,"ty_params","","",19],[11,"where_clause","","",19],[1,"WhereClause","",""],[11,"id","","",20],[11,"predicates","","",20],[1,"WhereBoundPredicate","",""],[11,"span","","",21],[11,"bounded_ty","","",21],[11,"bounds","","",21],[1,"WhereRegionPredicate","",""],[11,"span","","",22],[11,"lifetime","","",22],[11,"bounds","","",22],[1,"WhereEqPredicate","",""],[11,"id","","",23],[11,"span","","",23],[11,"path","","",23],[11,"ty","","",23],[1,"Crate","",""],[11,"module","","",24],[11,"attrs","","",24],[11,"config","","",24],[11,"span","","",24],[11,"exported_macros","","",24],[1,"Block","",""],[11,"view_items","","",25],[11,"stmts","","",25],[11,"expr","","",25],[11,"id","","",25],[11,"rules","","",25],[11,"span","","",25],[1,"Pat","",""],[11,"id","","",26],[11,"node","","",26],[11,"span","","",26],[1,"FieldPat","",""],[11,"ident","","",27],[11,"pat","","",27],[11,"is_shorthand","","",27],[1,"Local","","Local represents a `let` statement, e.g., `let <pat>:<ty> = <expr>;`"],[11,"ty","","",28],[11,"pat","","",28],[11,"init","","",28],[11,"id","","",28],[11,"span","","",28],[11,"source","","",28],[1,"Arm","","represents one arm of a 'match'"],[11,"attrs","","",29],[11,"pats","","",29],[11,"guard","","",29],[11,"body","","",29],[1,"Field","",""],[11,"ident","","",30],[11,"expr","","",30],[11,"span","","",30],[1,"Expr","",""],[11,"id","","",31],[11,"node","","",31],[11,"span","","",31],[1,"QPath","","A \"qualified path\":"],[11,"self_type","","",32],[11,"trait_ref","","",32],[11,"item_name","","",32],[1,"Delimited","","A delimited sequence of token trees"],[11,"delim","","The type of delimiter",33],[11,"open_span","","The span covering the opening delimiter",33],[11,"tts","","The delimited sequence of token trees",33],[11,"close_span","","The span covering the closing delimiter",33],[1,"SequenceRepetition","","A sequence of token treesee"],[11,"tts","","The sequence of token trees",34],[11,"separator","","The optional separator",34],[11,"op","","Whether the sequence can be repeated zero (*), or one or more times (+)",34],[11,"num_captures","","The number of `MatchNt`s that appear in the sequence (and subsequences)",34],[1,"MutTy","",""],[11,"ty","","",35],[11,"mutbl","","",35],[1,"TypeField","",""],[11,"ident","","",36],[11,"mt","","",36],[11,"span","","",36],[1,"TypeMethod","","Represents a required method in a trait declaration,\none without a default implementation"],[11,"ident","","",37],[11,"attrs","","",37],[11,"unsafety","","",37],[11,"abi","","",37],[11,"decl","","",37],[11,"generics","","",37],[11,"explicit_self","","",37],[11,"id","","",37],[11,"span","","",37],[11,"vis","","",37],[1,"AssociatedType","",""],[11,"attrs","","",38],[11,"ty_param","","",38],[1,"Typedef","",""],[11,"id","","",39],[11,"span","","",39],[11,"ident","","",39],[11,"vis","","",39],[11,"attrs","","",39],[11,"typ","","",39],[1,"TypeBinding","",""],[11,"id","","",40],[11,"ident","","",40],[11,"ty","","",40],[11,"span","","",40],[1,"Ty","",""],[11,"id","","",41],[11,"node","","",41],[11,"span","","",41],[1,"ClosureTy","","Represents the type of a closure"],[11,"lifetimes","","",42],[11,"unsafety","","",42],[11,"onceness","","",42],[11,"decl","","",42],[11,"bounds","","",42],[1,"BareFnTy","",""],[11,"unsafety","","",43],[11,"abi","","",43],[11,"lifetimes","","",43],[11,"decl","","",43],[1,"InlineAsm","",""],[11,"asm","","",44],[11,"asm_str_style","","",44],[11,"outputs","","",44],[11,"inputs","","",44],[11,"clobbers","","",44],[11,"volatile","","",44],[11,"alignstack","","",44],[11,"dialect","","",44],[11,"expn_id","","",44],[1,"Arg","","represents an argument in a function header"],[11,"ty","","",45],[11,"pat","","",45],[11,"id","","",45],[1,"FnDecl","","represents the header (not the body) of a function declaration"],[11,"inputs","","",46],[11,"output","","",46],[11,"variadic","","",46],[1,"Method","",""],[11,"attrs","","",47],[11,"id","","",47],[11,"span","","",47],[11,"node","","",47],[1,"Mod","",""],[11,"inner","","A span from the first token past `{` to the last token until `}`.\nFor `mod foo;`, the inner span ranges from the first token\nto the last token in the external file.",48],[11,"view_items","","",48],[11,"items","","",48],[1,"ForeignMod","",""],[11,"abi","","",49],[11,"view_items","","",49],[11,"items","","",49],[1,"VariantArg","",""],[11,"ty","","",50],[11,"id","","",50],[1,"EnumDef","",""],[11,"variants","","",51],[1,"Variant_","",""],[11,"name","","",52],[11,"attrs","","",52],[11,"kind","","",52],[11,"id","","",52],[11,"disr_expr","","",52],[11,"vis","","",52],[1,"ViewItem","",""],[11,"node","","",53],[11,"attrs","","",53],[11,"vis","","",53],[11,"span","","",53],[1,"AttrId","",""],[1,"Attribute_","","Doc-comments are promoted to attributes that have is_sugared_doc = true"],[11,"id","","",54],[11,"style","","",54],[11,"value","","",54],[11,"is_sugared_doc","","",54],[1,"TraitRef","","TraitRef's appear in impls.\nresolve maps each TraitRef's ref_id to its defining trait; that's all\nthat the ref_id is for. The impl_id maps to the \"self type\" of this impl.\nIf this impl is an ItemImpl, the impl_id is redundant (it could be the\nsame as the impl's node id)."],[11,"path","","",55],[11,"ref_id","","",55],[1,"PolyTraitRef","",""],[11,"bound_lifetimes","","The `'a` in `<'a> Foo<&'a T>`",56],[11,"trait_ref","","The `Foo<&'a T>` in `<'a> Foo<&'a T>`",56],[1,"StructField_","",""],[11,"kind","","",57],[11,"id","","",57],[11,"ty","","",57],[11,"attrs","","",57],[1,"StructDef","",""],[11,"fields","","Fields, not including ctor",58],[11,"ctor_id","","ID of the constructor. This is only used for tuple- or enum-like\nstructs.",58],[1,"Item","",""],[11,"ident","","",59],[11,"attrs","","",59],[11,"id","","",59],[11,"node","","",59],[11,"vis","","",59],[11,"span","","",59],[1,"ForeignItem","",""],[11,"ident","","",60],[11,"attrs","","",60],[11,"node","","",60],[11,"id","","",60],[11,"span","","",60],[11,"vis","","",60],[2,"PathParameters","",""],[12,"AngleBracketedParameters","","",61],[12,"ParenthesizedParameters","","",61],[2,"TyParamBound","","The AST represents all type param bounds as types.\ntypeck::collect::compute_bounds matches these against\nthe \"special\" built-in traits (see middle::lang_items) and\ndetects Copy, Send and Sync."],[12,"TraitTyParamBound","","",62],[12,"RegionTyParamBound","","",62],[2,"TraitBoundModifier","","A modifier on a bound, currently this is only used for `?Sized`, where the\nmodifier is `Maybe`. Negative bounds should also be handled here."],[12,"None","","",63],[12,"Maybe","","",63],[2,"WherePredicate","",""],[12,"BoundPredicate","","",64],[12,"RegionPredicate","","",64],[12,"EqPredicate","","",64],[2,"MetaItem_","",""],[12,"MetaWord","","",65],[12,"MetaList","","",65],[12,"MetaNameValue","","",65],[2,"BindingMode","",""],[12,"BindByRef","","",66],[12,"BindByValue","","",66],[2,"PatWildKind","",""],[12,"PatWildSingle","","Represents the wildcard pattern `_`",67],[12,"PatWildMulti","","Represents the wildcard pattern `..`",67],[2,"Pat_","",""],[12,"PatWild","","Represents a wildcard pattern (either `_` or `..`)",68],[12,"PatIdent","","A PatIdent may either be a new bound variable,\nor a nullary enum (in which case the third field\nis None).\nIn the nullary enum case, the parser can't determine\nwhich it is. The resolver determines this, and\nrecords this pattern's NodeId in an auxiliary\nset (of \"PatIdents that refer to nullary enums\")",68],[12,"PatEnum","","\"None\" means a * pattern where we don't bind the fields to names.",68],[12,"PatStruct","","",68],[12,"PatTup","","",68],[12,"PatBox","","",68],[12,"PatRegion","","",68],[12,"PatLit","","",68],[12,"PatRange","","",68],[12,"PatVec","","[a, b, ..i, y, z] is represented as:\nPatVec(box [a, b], Some(i), box [y, z])",68],[12,"PatMac","","",68],[2,"Mutability","",""],[12,"MutMutable","","",69],[12,"MutImmutable","","",69],[2,"BinOp","",""],[12,"BiAdd","","",70],[12,"BiSub","","",70],[12,"BiMul","","",70],[12,"BiDiv","","",70],[12,"BiRem","","",70],[12,"BiAnd","","",70],[12,"BiOr","","",70],[12,"BiBitXor","","",70],[12,"BiBitAnd","","",70],[12,"BiBitOr","","",70],[12,"BiShl","","",70],[12,"BiShr","","",70],[12,"BiEq","","",70],[12,"BiLt","","",70],[12,"BiLe","","",70],[12,"BiNe","","",70],[12,"BiGe","","",70],[12,"BiGt","","",70],[2,"UnOp","",""],[12,"UnUniq","","",71],[12,"UnDeref","","",71],[12,"UnNot","","",71],[12,"UnNeg","","",71],[2,"Stmt_","",""],[12,"StmtDecl","","Could be an item or a local (let) binding:",72],[12,"StmtExpr","","Expr without trailing semi-colon (must have unit type):",72],[12,"StmtSemi","","Expr with trailing semi-colon (may have any type):",72],[12,"StmtMac","","",72],[2,"MacStmtStyle","",""],[12,"MacStmtWithSemicolon","","The macro statement had a trailing semicolon, e.g. `foo! { ... };`\n`foo!(...);`, `foo![...];`",73],[12,"MacStmtWithBraces","","The macro statement had braces; e.g. foo! { ... }",73],[12,"MacStmtWithoutBraces","","The macro statement had parentheses or brackets and no semicolon; e.g.\n`foo!(...)`. All of these will end up being converted into macro\nexpressions.",73],[2,"LocalSource","","Where a local declaration came from: either a true `let ... =\n...;`, or one desugared from the pattern of a for loop."],[12,"LocalLet","","",74],[12,"LocalFor","","",74],[2,"Decl_","",""],[12,"DeclLocal","","A local (let) binding:",75],[12,"DeclItem","","An item binding:",75],[2,"BlockCheckMode","",""],[12,"DefaultBlock","","",76],[12,"UnsafeBlock","","",76],[2,"UnsafeSource","",""],[12,"CompilerGenerated","","",77],[12,"UserProvided","","",77],[2,"Expr_","",""],[12,"ExprBox","","First expr is the place; second expr is the value.",78],[12,"ExprVec","","",78],[12,"ExprCall","","",78],[12,"ExprMethodCall","","",78],[12,"ExprTup","","",78],[12,"ExprBinary","","",78],[12,"ExprUnary","","",78],[12,"ExprLit","","",78],[12,"ExprCast","","",78],[12,"ExprIf","","",78],[12,"ExprIfLet","","",78],[12,"ExprWhile","","",78],[12,"ExprWhileLet","","",78],[12,"ExprForLoop","","",78],[12,"ExprLoop","","",78],[12,"ExprMatch","","",78],[12,"ExprClosure","","",78],[12,"ExprBlock","","",78],[12,"ExprAssign","","",78],[12,"ExprAssignOp","","",78],[12,"ExprField","","",78],[12,"ExprTupField","","",78],[12,"ExprIndex","","",78],[12,"ExprRange","","",78],[12,"ExprPath","","Variable reference, possibly containing `::` and/or\ntype parameters, e.g. foo::bar::<baz>",78],[12,"ExprAddrOf","","",78],[12,"ExprBreak","","",78],[12,"ExprAgain","","",78],[12,"ExprRet","","",78],[12,"ExprInlineAsm","","",78],[12,"ExprMac","","",78],[12,"ExprStruct","","A struct literal expression.",78],[12,"ExprRepeat","","A vector literal constructed from one repeated element.",78],[12,"ExprParen","","No-op: used solely so we can pretty-print faithfully",78],[2,"MatchSource","",""],[12,"Normal","","",79],[12,"IfLetDesugar","","",79],[11,"contains_else_clause","syntax::ast::MatchSource","",79],[12,"WhileLetDesugar","syntax::ast","",79],[2,"CaptureClause","",""],[12,"CaptureByValue","","",80],[12,"CaptureByRef","","",80],[2,"KleeneOp","","A Kleene-style [repetition operator](http://en.wikipedia.org/wiki/Kleene_star)\nfor token sequences."],[12,"ZeroOrMore","","",81],[12,"OneOrMore","","",81],[2,"TokenTree","","When the main rust parser encounters a syntax-extension invocation, it\n parses the arguments to the invocation as a token-tree. This is a very\n loose structure, such that all sorts of different AST-fragments can\n be passed to syntax extensions using a uniform type."],[12,"TtToken","","A single token",82],[12,"TtDelimited","","A delimited sequence of token trees",82],[12,"TtSequence","","A kleene-style repetition sequence with a span",82],[2,"Mac_","","Represents a macro invocation. The Path indicates which macro\nis being invoked, and the vector of token-trees contains the source\nof the macro invocation.\nThere's only one flavor, now, so this could presumably be simplified."],[12,"MacInvocTT","","",83],[2,"StrStyle","",""],[12,"CookedStr","","",84],[12,"RawStr","","",84],[2,"Sign","",""],[12,"Minus","","",85],[12,"Plus","","",85],[2,"LitIntType","",""],[12,"SignedIntLit","","",86],[12,"UnsignedIntLit","","",86],[12,"UnsuffixedIntLit","","",86],[2,"Lit_","",""],[12,"LitStr","","",87],[12,"LitBinary","","",87],[12,"LitByte","","",87],[12,"LitChar","","",87],[12,"LitInt","","",87],[12,"LitFloat","","",87],[12,"LitFloatUnsuffixed","","",87],[12,"LitBool","","",87],[2,"TraitItem","","Represents a method declaration in a trait declaration, possibly including\na default implementation A trait method is either required (meaning it\ndoesn't have an implementation, just a signature) or provided (meaning it\nhas a default implementation)."],[12,"RequiredMethod","","",88],[12,"ProvidedMethod","","",88],[12,"TypeTraitItem","","",88],[2,"ImplItem","",""],[12,"MethodImplItem","","",89],[12,"TypeImplItem","","",89],[2,"IntTy","",""],[12,"TyI","","",90],[12,"TyI8","","",90],[12,"TyI16","","",90],[12,"TyI32","","",90],[12,"TyI64","","",90],[2,"UintTy","",""],[12,"TyU","","",91],[12,"TyU8","","",91],[12,"TyU16","","",91],[12,"TyU32","","",91],[12,"TyU64","","",91],[2,"FloatTy","",""],[12,"TyF32","","",92],[12,"TyF64","","",92],[2,"PrimTy","","Not represented directly in the AST, referred to by name through a ty_path."],[12,"TyInt","","",93],[12,"TyUint","","",93],[12,"TyFloat","","",93],[12,"TyStr","","",93],[12,"TyBool","","",93],[12,"TyChar","","",93],[2,"Onceness","",""],[12,"Once","","",94],[12,"Many","","",94],[2,"Ty_","","The different kinds of types recognized by the compiler"],[12,"TyVec","","",95],[12,"TyFixedLengthVec","","A fixed length array (`[T, ..n]`)",95],[12,"TyPtr","","A raw pointer (`*const T` or `*mut T`)",95],[12,"TyRptr","","A reference (`&'a T` or `&'a mut T`)",95],[12,"TyClosure","","A closure (e.g. `|uint| -> bool`)",95],[12,"TyBareFn","","A bare function (e.g. `fn(uint) -> bool`)",95],[12,"TyTup","","A tuple (`(A, B, C, D,...)`)",95],[12,"TyPath","","A path (`module::module::...::Type`) or primitive",95],[12,"TyObjectSum","","Something like `A+B`. Note that `B` must always be a path.",95],[12,"TyPolyTraitRef","","A type like `for<'a> Foo<&'a Bar>`",95],[12,"TyQPath","","A \"qualified path\", e.g. `<Vec<T> as SomeTrait>::SomeType`",95],[12,"TyParen","","No-op; kept solely so that we can pretty-print faithfully",95],[12,"TyTypeof","","Unused for now",95],[12,"TyInfer","","TyInfer means the type should be inferred instead of it having been\nspecified. This can appear anywhere in a type.",95],[2,"AsmDialect","",""],[12,"AsmAtt","","",96],[12,"AsmIntel","","",96],[2,"Unsafety","",""],[12,"Unsafe","","",97],[12,"Normal","","",97],[2,"FunctionRetTy","",""],[12,"NoReturn","","Functions with return type ! that always\nraise an error or exit (i.e. never return to the caller)",98],[12,"Return","","Everything else",98],[2,"ExplicitSelf_","","Represents the kind of 'self' associated with a method"],[12,"SelfStatic","","No self",99],[12,"SelfValue","","`self`",99],[12,"SelfRegion","","`&'lt self`, `&'lt mut self`",99],[12,"SelfExplicit","","`self: TYPE`",99],[2,"Method_","",""],[12,"MethDecl","","Represents a method declaration",100],[12,"MethMac","","Represents a macro in method position",100],[2,"VariantKind","",""],[12,"TupleVariantKind","","",101],[12,"StructVariantKind","","",101],[2,"PathListItem_","",""],[12,"PathListIdent","","",102],[11,"name","syntax::ast::PathListItem_","",102],[11,"id","","",102],[12,"PathListMod","syntax::ast","",102],[11,"id","syntax::ast::PathListItem_","",102],[2,"ViewPath_","syntax::ast",""],[12,"ViewPathSimple","","`foo::bar::baz as quux`",103],[12,"ViewPathGlob","","`foo::bar::*`",103],[12,"ViewPathList","","`foo::bar::{a,b,c}`",103],[2,"ViewItem_","",""],[12,"ViewItemExternCrate","","Ident: name used to refer to this crate in the code\noptional (InternedString,StrStyle): if present, this is a location\n(containing arbitrary characters) from which to fetch the crate sources\nFor example, extern crate whatever = \"github.com/rust-lang/rust\"",104],[12,"ViewItemUse","","",104],[2,"AttrStyle","","Distinguishes between Attributes that decorate items and Attributes that\nare contained as statements within items. These two cases need to be\ndistinguished for pretty-printing."],[12,"AttrOuter","","",105],[12,"AttrInner","","",105],[2,"Visibility","",""],[12,"Public","","",106],[12,"Inherited","","",106],[2,"StructFieldKind","",""],[12,"NamedField","","",107],[12,"UnnamedField","","Element of a tuple-like struct",107],[2,"Item_","",""],[12,"ItemStatic","","",108],[12,"ItemConst","","",108],[12,"ItemFn","","",108],[12,"ItemMod","","",108],[12,"ItemForeignMod","","",108],[12,"ItemTy","","",108],[12,"ItemEnum","","",108],[12,"ItemStruct","","",108],[12,"ItemTrait","","Represents a Trait Declaration",108],[12,"ItemImpl","","",108],[12,"ItemMac","","A macro invocation (which includes macro definition)",108],[2,"ForeignItem_","",""],[12,"ForeignItemFn","","",109],[12,"ForeignItemStatic","","",109],[2,"UnboxedClosureKind","",""],[12,"FnUnboxedClosureKind","","",110],[12,"FnMutUnboxedClosureKind","","",110],[12,"FnOnceUnboxedClosureKind","","",110],[2,"InlinedItem","","The data we save and restore about an inlined item or method.  This is not\npart of the AST that we parse from a file, but it becomes part of the tree\nthat we trans."],[12,"IIItem","","",111],[12,"IITraitItem","","",111],[12,"IIImplItem","","",111],[12,"IIForeign","","",111],[4,"SyntaxContext","","A SyntaxContext represents a chain of macro-expandings\nand renamings. Each macro expansion corresponds to\na fresh uint"],[4,"Mrk","","A mark represents a unique id associated with a macro expansion"],[4,"FnIdent","","Function name (not all functions have names)"],[4,"CrateNum","",""],[4,"NodeId","",""],[4,"TyParamBounds","",""],[4,"CrateConfig","","The set of MetaItems that define the compilation environment of the crate,\nused to drive conditional compilation"],[4,"MetaItem","",""],[4,"Stmt","",""],[4,"Decl","",""],[4,"SpannedIdent","",""],[4,"Mac","",""],[4,"Lit","",""],[4,"ExplicitSelf","",""],[4,"Variant","",""],[4,"PathListItem","",""],[4,"ViewPath","",""],[4,"Attribute","","Meta-data associated with an item"],[4,"StructField","",""],[18,"EMPTY_CTXT","",""],[18,"ILLEGAL_CTXT","",""],[18,"LOCAL_CRATE","","Item definitions in the currently-compiled crate would have the CrateNum\nLOCAL_CRATE in their DefId."],[18,"CRATE_NODE_ID","",""],[18,"DUMMY_NODE_ID","","When parsing and doing expansions, we initially give all AST nodes this AST\nnode value. Then later, in the renumber pass, we renumber them to have\nsmall, positive ids."],[10,"cmp","","",10],[10,"partial_cmp","","",10],[10,"lt","","",10],[10,"le","","",10],[10,"gt","","",10],[10,"ge","","",10],[10,"hash","","",10],[10,"clone","","",10],[10,"new","","Construct an identifier with the given name and an empty context:",10],[10,"as_str","","",10],[10,"encode_with_hygiene","","",10],[10,"fmt","","",10],[10,"fmt","","",112],[10,"eq","","",10],[10,"ne","","",10],[10,"clone","","",112],[10,"decode","","",112],[10,"encode","","",112],[10,"hash","","",112],[10,"partial_cmp","","",112],[10,"lt","","",112],[10,"le","","",112],[10,"gt","","",112],[10,"ge","","",112],[10,"eq","","",112],[10,"ne","","",112],[10,"cmp","","",112],[10,"as_str","","",112],[10,"uint","","",112],[10,"ident","","",112],[10,"encode","","",10],[10,"decode","","",10],[10,"fmt","","",11],[10,"hash","","",11],[10,"decode","","",11],[10,"encode","","",11],[10,"eq","","",11],[10,"ne","","",11],[10,"clone","","",11],[10,"fmt","","",12],[10,"hash","","",12],[10,"decode","","",12],[10,"encode","","",12],[10,"eq","","",12],[10,"ne","","",12],[10,"clone","","",12],[10,"fmt","","",13],[10,"hash","","",13],[10,"decode","","",13],[10,"encode","","",13],[10,"eq","","",13],[10,"ne","","",13],[10,"clone","","",13],[10,"fmt","","",14],[10,"hash","","",14],[10,"decode","","",14],[10,"encode","","",14],[10,"eq","","",14],[10,"ne","","",14],[10,"clone","","",14],[10,"fmt","","",61],[10,"hash","","",61],[10,"decode","","",61],[10,"encode","","",61],[10,"eq","","",61],[10,"ne","","",61],[10,"clone","","",61],[10,"none","","",61],[10,"is_empty","","",61],[10,"has_lifetimes","","",61],[10,"has_types","","",61],[10,"types","","Returns the types that the user wrote. Note that these do not necessarily map to the type\nparameters in the parenthesized case.",61],[10,"lifetimes","","",61],[10,"bindings","","",61],[10,"fmt","","",15],[10,"hash","","",15],[10,"decode","","",15],[10,"encode","","",15],[10,"eq","","",15],[10,"ne","","",15],[10,"clone","","",15],[10,"fmt","","",16],[10,"hash","","",16],[10,"decode","","",16],[10,"encode","","",16],[10,"eq","","",16],[10,"ne","","",16],[10,"clone","","",16],[10,"fmt","","",17],[10,"hash","","",17],[10,"decode","","",17],[10,"encode","","",17],[10,"eq","","",17],[10,"ne","","",17],[10,"partial_cmp","","",17],[10,"lt","","",17],[10,"le","","",17],[10,"gt","","",17],[10,"ge","","",17],[10,"cmp","","",17],[10,"clone","","",17],[10,"fmt","","",62],[10,"hash","","",62],[10,"decode","","",62],[10,"encode","","",62],[10,"eq","","",62],[10,"ne","","",62],[10,"clone","","",62],[10,"fmt","","",63],[10,"hash","","",63],[10,"decode","","",63],[10,"encode","","",63],[10,"eq","","",63],[10,"ne","","",63],[10,"clone","","",63],[10,"fmt","","",18],[10,"hash","","",18],[10,"decode","","",18],[10,"encode","","",18],[10,"eq","","",18],[10,"ne","","",18],[10,"clone","","",18],[10,"fmt","","",19],[10,"hash","","",19],[10,"decode","","",19],[10,"encode","","",19],[10,"eq","","",19],[10,"ne","","",19],[10,"clone","","",19],[10,"is_parameterized","","",19],[10,"is_lt_parameterized","","",19],[10,"is_type_parameterized","","",19],[10,"fmt","","",20],[10,"hash","","",20],[10,"decode","","",20],[10,"encode","","",20],[10,"eq","","",20],[10,"ne","","",20],[10,"clone","","",20],[10,"fmt","","",64],[10,"hash","","",64],[10,"decode","","",64],[10,"encode","","",64],[10,"eq","","",64],[10,"ne","","",64],[10,"clone","","",64],[10,"fmt","","",21],[10,"hash","","",21],[10,"decode","","",21],[10,"encode","","",21],[10,"eq","","",21],[10,"ne","","",21],[10,"clone","","",21],[10,"fmt","","",22],[10,"hash","","",22],[10,"decode","","",22],[10,"encode","","",22],[10,"eq","","",22],[10,"ne","","",22],[10,"clone","","",22],[10,"fmt","","",23],[10,"hash","","",23],[10,"decode","","",23],[10,"encode","","",23],[10,"eq","","",23],[10,"ne","","",23],[10,"clone","","",23],[10,"fmt","","",24],[10,"hash","","",24],[10,"decode","","",24],[10,"encode","","",24],[10,"eq","","",24],[10,"ne","","",24],[10,"clone","","",24],[10,"fmt","","",65],[10,"hash","","",65],[10,"decode","","",65],[10,"encode","","",65],[10,"clone","","",65],[10,"eq","","",65],[10,"fmt","","",25],[10,"hash","","",25],[10,"decode","","",25],[10,"encode","","",25],[10,"eq","","",25],[10,"ne","","",25],[10,"clone","","",25],[10,"fmt","","",26],[10,"hash","","",26],[10,"decode","","",26],[10,"encode","","",26],[10,"eq","","",26],[10,"ne","","",26],[10,"clone","","",26],[10,"fmt","","",27],[10,"hash","","",27],[10,"decode","","",27],[10,"encode","","",27],[10,"eq","","",27],[10,"ne","","",27],[10,"clone","","",27],[10,"fmt","","",66],[10,"hash","","",66],[10,"decode","","",66],[10,"encode","","",66],[10,"eq","","",66],[10,"ne","","",66],[10,"clone","","",66],[10,"fmt","","",67],[10,"hash","","",67],[10,"decode","","",67],[10,"encode","","",67],[10,"eq","","",67],[10,"ne","","",67],[10,"clone","","",67],[10,"fmt","","",68],[10,"hash","","",68],[10,"decode","","",68],[10,"encode","","",68],[10,"eq","","",68],[10,"ne","","",68],[10,"clone","","",68],[10,"fmt","","",69],[10,"hash","","",69],[10,"decode","","",69],[10,"encode","","",69],[10,"eq","","",69],[10,"ne","","",69],[10,"clone","","",69],[10,"fmt","","",70],[10,"hash","","",70],[10,"decode","","",70],[10,"encode","","",70],[10,"eq","","",70],[10,"ne","","",70],[10,"clone","","",70],[10,"fmt","","",71],[10,"hash","","",71],[10,"decode","","",71],[10,"encode","","",71],[10,"eq","","",71],[10,"ne","","",71],[10,"clone","","",71],[10,"fmt","","",72],[10,"hash","","",72],[10,"decode","","",72],[10,"encode","","",72],[10,"eq","","",72],[10,"ne","","",72],[10,"clone","","",72],[10,"fmt","","",73],[10,"hash","","",73],[10,"decode","","",73],[10,"encode","","",73],[10,"eq","","",73],[10,"ne","","",73],[10,"clone","","",73],[10,"fmt","","",74],[10,"hash","","",74],[10,"decode","","",74],[10,"encode","","",74],[10,"eq","","",74],[10,"ne","","",74],[10,"clone","","",74],[10,"fmt","","",28],[10,"hash","","",28],[10,"decode","","",28],[10,"encode","","",28],[10,"eq","","",28],[10,"ne","","",28],[10,"clone","","",28],[10,"fmt","","",75],[10,"hash","","",75],[10,"decode","","",75],[10,"encode","","",75],[10,"eq","","",75],[10,"ne","","",75],[10,"clone","","",75],[10,"fmt","","",29],[10,"hash","","",29],[10,"decode","","",29],[10,"encode","","",29],[10,"eq","","",29],[10,"ne","","",29],[10,"clone","","",29],[10,"fmt","","",30],[10,"hash","","",30],[10,"decode","","",30],[10,"encode","","",30],[10,"eq","","",30],[10,"ne","","",30],[10,"clone","","",30],[10,"fmt","","",76],[10,"hash","","",76],[10,"decode","","",76],[10,"encode","","",76],[10,"eq","","",76],[10,"ne","","",76],[10,"clone","","",76],[10,"fmt","","",77],[10,"hash","","",77],[10,"decode","","",77],[10,"encode","","",77],[10,"eq","","",77],[10,"ne","","",77],[10,"clone","","",77],[10,"fmt","","",31],[10,"hash","","",31],[10,"decode","","",31],[10,"encode","","",31],[10,"eq","","",31],[10,"ne","","",31],[10,"clone","","",31],[10,"fmt","","",78],[10,"hash","","",78],[10,"decode","","",78],[10,"encode","","",78],[10,"eq","","",78],[10,"ne","","",78],[10,"clone","","",78],[10,"fmt","","",32],[10,"hash","","",32],[10,"decode","","",32],[10,"encode","","",32],[10,"eq","","",32],[10,"ne","","",32],[10,"clone","","",32],[10,"fmt","","",79],[10,"hash","","",79],[10,"decode","","",79],[10,"encode","","",79],[10,"eq","","",79],[10,"ne","","",79],[10,"clone","","",79],[10,"fmt","","",80],[10,"hash","","",80],[10,"decode","","",80],[10,"encode","","",80],[10,"eq","","",80],[10,"ne","","",80],[10,"clone","","",80],[10,"fmt","","",33],[10,"hash","","",33],[10,"decode","","",33],[10,"encode","","",33],[10,"eq","","",33],[10,"ne","","",33],[10,"clone","","",33],[10,"open_token","","Returns the opening delimiter as a token.",33],[10,"close_token","","Returns the closing delimiter as a token.",33],[10,"open_tt","","Returns the opening delimiter as a token tree.",33],[10,"close_tt","","Returns the closing delimiter as a token tree.",33],[10,"fmt","","",34],[10,"hash","","",34],[10,"decode","","",34],[10,"encode","","",34],[10,"eq","","",34],[10,"ne","","",34],[10,"clone","","",34],[10,"fmt","","",81],[10,"hash","","",81],[10,"decode","","",81],[10,"encode","","",81],[10,"eq","","",81],[10,"ne","","",81],[10,"clone","","",81],[10,"fmt","","",82],[10,"hash","","",82],[10,"decode","","",82],[10,"encode","","",82],[10,"eq","","",82],[10,"ne","","",82],[10,"clone","","",82],[10,"len","","",82],[10,"get_tt","","",82],[10,"get_span","","Returns the `Span` corresponding to this token tree.",82],[10,"fmt","","",83],[10,"hash","","",83],[10,"decode","","",83],[10,"encode","","",83],[10,"eq","","",83],[10,"ne","","",83],[10,"clone","","",83],[10,"fmt","","",84],[10,"hash","","",84],[10,"decode","","",84],[10,"encode","","",84],[10,"eq","","",84],[10,"ne","","",84],[10,"clone","","",84],[10,"fmt","","",85],[10,"hash","","",85],[10,"decode","","",85],[10,"encode","","",85],[10,"eq","","",85],[10,"ne","","",85],[10,"clone","","",85],[10,"new","","",85],[10,"fmt","","",86],[10,"hash","","",86],[10,"decode","","",86],[10,"encode","","",86],[10,"eq","","",86],[10,"ne","","",86],[10,"clone","","",86],[10,"suffix_len","","",86],[10,"fmt","","",87],[10,"hash","","",87],[10,"decode","","",87],[10,"encode","","",87],[10,"eq","","",87],[10,"ne","","",87],[10,"clone","","",87],[10,"fmt","","",35],[10,"hash","","",35],[10,"decode","","",35],[10,"encode","","",35],[10,"eq","","",35],[10,"ne","","",35],[10,"clone","","",35],[10,"fmt","","",36],[10,"hash","","",36],[10,"decode","","",36],[10,"encode","","",36],[10,"eq","","",36],[10,"ne","","",36],[10,"clone","","",36],[10,"fmt","","",37],[10,"hash","","",37],[10,"decode","","",37],[10,"encode","","",37],[10,"eq","","",37],[10,"ne","","",37],[10,"clone","","",37],[10,"fmt","","",88],[10,"hash","","",88],[10,"decode","","",88],[10,"encode","","",88],[10,"eq","","",88],[10,"ne","","",88],[10,"clone","","",88],[10,"fmt","","",89],[10,"hash","","",89],[10,"decode","","",89],[10,"encode","","",89],[10,"eq","","",89],[10,"ne","","",89],[10,"clone","","",89],[10,"fmt","","",38],[10,"hash","","",38],[10,"decode","","",38],[10,"encode","","",38],[10,"eq","","",38],[10,"ne","","",38],[10,"clone","","",38],[10,"fmt","","",39],[10,"hash","","",39],[10,"decode","","",39],[10,"encode","","",39],[10,"eq","","",39],[10,"ne","","",39],[10,"clone","","",39],[10,"hash","","",90],[10,"decode","","",90],[10,"encode","","",90],[10,"eq","","",90],[10,"ne","","",90],[10,"clone","","",90],[10,"fmt","","",90],[10,"suffix_len","","",90],[10,"hash","","",91],[10,"decode","","",91],[10,"encode","","",91],[10,"eq","","",91],[10,"ne","","",91],[10,"clone","","",91],[10,"suffix_len","","",91],[10,"fmt","","",91],[10,"hash","","",92],[10,"decode","","",92],[10,"encode","","",92],[10,"eq","","",92],[10,"ne","","",92],[10,"clone","","",92],[10,"fmt","","",92],[10,"suffix_len","","",92],[10,"fmt","","",40],[10,"hash","","",40],[10,"decode","","",40],[10,"encode","","",40],[10,"eq","","",40],[10,"ne","","",40],[10,"clone","","",40],[10,"fmt","","",41],[10,"hash","","",41],[10,"decode","","",41],[10,"encode","","",41],[10,"eq","","",41],[10,"ne","","",41],[10,"clone","","",41],[10,"fmt","","",93],[10,"hash","","",93],[10,"decode","","",93],[10,"encode","","",93],[10,"eq","","",93],[10,"ne","","",93],[10,"clone","","",93],[10,"hash","","",94],[10,"decode","","",94],[10,"encode","","",94],[10,"eq","","",94],[10,"ne","","",94],[10,"clone","","",94],[10,"fmt","","",94],[10,"fmt","","",42],[10,"hash","","",42],[10,"decode","","",42],[10,"encode","","",42],[10,"eq","","",42],[10,"ne","","",42],[10,"clone","","",42],[10,"fmt","","",43],[10,"hash","","",43],[10,"decode","","",43],[10,"encode","","",43],[10,"eq","","",43],[10,"ne","","",43],[10,"clone","","",43],[10,"fmt","","",95],[10,"hash","","",95],[10,"decode","","",95],[10,"encode","","",95],[10,"eq","","",95],[10,"ne","","",95],[10,"clone","","",95],[10,"fmt","","",96],[10,"hash","","",96],[10,"decode","","",96],[10,"encode","","",96],[10,"eq","","",96],[10,"ne","","",96],[10,"clone","","",96],[10,"fmt","","",44],[10,"hash","","",44],[10,"decode","","",44],[10,"encode","","",44],[10,"eq","","",44],[10,"ne","","",44],[10,"clone","","",44],[10,"fmt","","",45],[10,"hash","","",45],[10,"decode","","",45],[10,"encode","","",45],[10,"eq","","",45],[10,"ne","","",45],[10,"clone","","",45],[10,"new_self","","",45],[10,"fmt","","",46],[10,"hash","","",46],[10,"decode","","",46],[10,"encode","","",46],[10,"eq","","",46],[10,"ne","","",46],[10,"clone","","",46],[10,"hash","","",97],[10,"decode","","",97],[10,"encode","","",97],[10,"eq","","",97],[10,"ne","","",97],[10,"clone","","",97],[10,"fmt","","",97],[10,"fmt","","",98],[10,"hash","","",98],[10,"decode","","",98],[10,"encode","","",98],[10,"eq","","",98],[10,"ne","","",98],[10,"clone","","",98],[10,"span","","",98],[10,"fmt","","",99],[10,"hash","","",99],[10,"decode","","",99],[10,"encode","","",99],[10,"eq","","",99],[10,"ne","","",99],[10,"clone","","",99],[10,"fmt","","",47],[10,"hash","","",47],[10,"decode","","",47],[10,"encode","","",47],[10,"eq","","",47],[10,"ne","","",47],[10,"clone","","",47],[10,"fmt","","",100],[10,"hash","","",100],[10,"decode","","",100],[10,"encode","","",100],[10,"eq","","",100],[10,"ne","","",100],[10,"clone","","",100],[10,"fmt","","",48],[10,"hash","","",48],[10,"decode","","",48],[10,"encode","","",48],[10,"eq","","",48],[10,"ne","","",48],[10,"clone","","",48],[10,"fmt","","",49],[10,"hash","","",49],[10,"decode","","",49],[10,"encode","","",49],[10,"eq","","",49],[10,"ne","","",49],[10,"clone","","",49],[10,"fmt","","",50],[10,"hash","","",50],[10,"decode","","",50],[10,"encode","","",50],[10,"eq","","",50],[10,"ne","","",50],[10,"clone","","",50],[10,"fmt","","",101],[10,"hash","","",101],[10,"decode","","",101],[10,"encode","","",101],[10,"eq","","",101],[10,"ne","","",101],[10,"clone","","",101],[10,"fmt","","",51],[10,"hash","","",51],[10,"decode","","",51],[10,"encode","","",51],[10,"eq","","",51],[10,"ne","","",51],[10,"clone","","",51],[10,"fmt","","",52],[10,"hash","","",52],[10,"decode","","",52],[10,"encode","","",52],[10,"eq","","",52],[10,"ne","","",52],[10,"clone","","",52],[10,"fmt","","",102],[10,"hash","","",102],[10,"decode","","",102],[10,"encode","","",102],[10,"eq","","",102],[10,"ne","","",102],[10,"clone","","",102],[10,"id","","",102],[10,"fmt","","",103],[10,"hash","","",103],[10,"decode","","",103],[10,"encode","","",103],[10,"eq","","",103],[10,"ne","","",103],[10,"clone","","",103],[10,"fmt","","",53],[10,"hash","","",53],[10,"decode","","",53],[10,"encode","","",53],[10,"eq","","",53],[10,"ne","","",53],[10,"clone","","",53],[10,"fmt","","",104],[10,"hash","","",104],[10,"decode","","",104],[10,"encode","","",104],[10,"eq","","",104],[10,"ne","","",104],[10,"clone","","",104],[10,"fmt","","",105],[10,"hash","","",105],[10,"decode","","",105],[10,"encode","","",105],[10,"eq","","",105],[10,"ne","","",105],[10,"clone","","",105],[10,"fmt","","",113],[10,"hash","","",113],[10,"decode","","",113],[10,"encode","","",113],[10,"eq","","",113],[10,"ne","","",113],[10,"clone","","",113],[10,"fmt","","",54],[10,"hash","","",54],[10,"decode","","",54],[10,"encode","","",54],[10,"eq","","",54],[10,"ne","","",54],[10,"clone","","",54],[10,"fmt","","",55],[10,"hash","","",55],[10,"decode","","",55],[10,"encode","","",55],[10,"eq","","",55],[10,"ne","","",55],[10,"clone","","",55],[10,"fmt","","",56],[10,"hash","","",56],[10,"decode","","",56],[10,"encode","","",56],[10,"eq","","",56],[10,"ne","","",56],[10,"clone","","",56],[10,"fmt","","",106],[10,"hash","","",106],[10,"decode","","",106],[10,"encode","","",106],[10,"eq","","",106],[10,"ne","","",106],[10,"clone","","",106],[10,"inherit_from","","",106],[10,"fmt","","",57],[10,"hash","","",57],[10,"decode","","",57],[10,"encode","","",57],[10,"eq","","",57],[10,"ne","","",57],[10,"clone","","",57],[10,"ident","","",57],[10,"fmt","","",107],[10,"hash","","",107],[10,"decode","","",107],[10,"encode","","",107],[10,"eq","","",107],[10,"ne","","",107],[10,"clone","","",107],[10,"is_unnamed","","",107],[10,"fmt","","",58],[10,"hash","","",58],[10,"decode","","",58],[10,"encode","","",58],[10,"eq","","",58],[10,"ne","","",58],[10,"clone","","",58],[10,"fmt","","",59],[10,"hash","","",59],[10,"decode","","",59],[10,"encode","","",59],[10,"eq","","",59],[10,"ne","","",59],[10,"clone","","",59],[10,"fmt","","",108],[10,"hash","","",108],[10,"decode","","",108],[10,"encode","","",108],[10,"eq","","",108],[10,"ne","","",108],[10,"clone","","",108],[10,"descriptive_variant","","",108],[10,"fmt","","",60],[10,"hash","","",60],[10,"decode","","",60],[10,"encode","","",60],[10,"eq","","",60],[10,"ne","","",60],[10,"clone","","",60],[10,"fmt","","",109],[10,"hash","","",109],[10,"decode","","",109],[10,"encode","","",109],[10,"eq","","",109],[10,"ne","","",109],[10,"clone","","",109],[10,"descriptive_variant","","",109],[10,"fmt","","",110],[10,"hash","","",110],[10,"decode","","",110],[10,"encode","","",110],[10,"eq","","",110],[10,"ne","","",110],[10,"clone","","",110],[10,"fmt","","",111],[10,"hash","","",111],[10,"decode","","",111],[10,"encode","","",111],[10,"eq","","",111],[10,"ne","","",111],[10,"clone","","",111],[0,"ast_map","syntax",""],[1,"Values","syntax::ast_map",""],[1,"Forest","","Stores a crate and any number of inlined items from other crates."],[1,"Map","","Represents a mapping from Node IDs to AST elements and their parent\nNode IDs"],[1,"NodesMatchingSuffix","",""],[2,"PathElem","",""],[12,"PathMod","","",114],[12,"PathName","","",114],[2,"Node","",""],[12,"NodeItem","","",115],[12,"NodeForeignItem","","",115],[12,"NodeTraitItem","","",115],[12,"NodeImplItem","","",115],[12,"NodeVariant","","",115],[12,"NodeExpr","","",115],[12,"NodeStmt","","",115],[12,"NodeArg","","",115],[12,"NodeLocal","","",115],[12,"NodePat","","",115],[12,"NodeBlock","","",115],[12,"NodeStructCtor","","NodeStructCtor represents a tuple struct.",115],[12,"NodeLifetime","","",115],[3,"path_to_string","",""],[3,"map_crate","",""],[3,"map_decoded_item","","Used for items loaded from external crate that are being inlined into this\ncrate.  The `path` should be the path to the item but should not include\nthe item itself."],[0,"blocks","","This module provides a simplified abstraction for working with\ncode blocks identified by their integer node-id.  In particular,\nit captures a common set of attributes that all \"function-like\nthings\" (represented by `FnLike` instances) share.  For example,\nall `FnLike` instances have a type signature (be it explicit or\ninferred).  And all `FnLike` instances have a body, i.e. the code\nthat is run when the function-like thing it represents is invoked."],[1,"FnLikeNode","syntax::ast_map::blocks","An FnLikeNode is a Node that is like a fn, in that it has a decl\nand a body (as well as a NodeId, a span, etc)."],[1,"FnParts","","Components shared by fn-like things (fn items, methods, closures)."],[11,"decl","","",116],[11,"body","","",116],[11,"kind","","",116],[11,"span","","",116],[11,"id","","",116],[2,"Code","","Carries either an FnLikeNode or a Block, as these are the two\nconstructs that correspond to \"code\" (as in, something from which\nwe can construct a control-flow graph)."],[12,"FnLikeCode","","",117],[12,"BlockCode","","",117],[6,"MaybeFnLike","","MaybeFnLike wraps a method that indicates if an object\ncorresponds to some FnLikeNode."],[9,"is_fn_like","","",118],[10,"is_fn_like","syntax::ast","",59],[10,"is_fn_like","","",88],[10,"is_fn_like","","",31],[10,"id","syntax::ast_map::blocks","",117],[10,"from_node","","Attempts to construct a Code from presumed FnLike or Block node input.",117],[10,"to_fn_parts","","",119],[10,"body","","",119],[10,"decl","","",119],[10,"span","","",119],[10,"id","","",119],[10,"kind","","",119],[4,"PathElems","syntax::ast_map","The type of the iterator used by with_path."],[6,"FoldOps","",""],[10,"new_id","","",120],[10,"new_def_id","","",120],[10,"new_span","","",120],[6,"NodePrinter","",""],[9,"print_node","","",121],[10,"eq","","",114],[10,"ne","","",114],[10,"clone","","",114],[10,"name","","",114],[10,"fmt","","",114],[10,"clone","","",122],[10,"next","","",122],[10,"fmt","","",115],[10,"new","","",123],[10,"krate","","",123],[10,"krate","","",124],[10,"get","","Retrieve the Node corresponding to `id`, panicking if it cannot\nbe found.",124],[10,"find","","Retrieve the Node corresponding to `id`, returning None if\ncannot be found.",124],[10,"get_parent","","Retrieve the parent NodeId for `id`, or `id` itself if no\nparent is registered in this map.",124],[10,"get_parent_did","","",124],[10,"get_foreign_abi","","",124],[10,"get_foreign_vis","","",124],[10,"expect_item","","",124],[10,"expect_struct","","",124],[10,"expect_variant","","",124],[10,"expect_foreign_item","","",124],[10,"expect_expr","","",124],[10,"get_path_elem","","returns the name associated with the given NodeId's AST",124],[10,"with_path","","",124],[10,"path_to_string","","",124],[10,"with_attrs","","Given a node ID and a closure, apply the closure to the array\nof attributes associated with the AST corresponding to the Node ID",124],[10,"nodes_matching_suffix","","Returns an iterator that yields the node id's with paths that\nmatch `parts`.  (Requires `parts` is non-empty.)",124],[10,"opt_span","","",124],[10,"span","","",124],[10,"def_id_span","","",124],[10,"node_to_string","","",124],[10,"node_to_user_string","","",124],[10,"next","","",125],[0,"ast_util","syntax",""],[1,"IdRange","syntax::ast_util",""],[11,"min","","",126],[11,"max","","",126],[1,"IdVisitor","","A visitor that applies its operation to all of the node IDs\nin a visitable thing."],[11,"operation","","",127],[11,"pass_through_items","","",127],[11,"visited_outermost","","",127],[3,"path_name_i","",""],[3,"local_def","",""],[3,"is_local","",""],[3,"stmt_id","",""],[3,"binop_to_string","",""],[3,"lazy_binop","",""],[3,"is_shift_binop","",""],[3,"is_by_value_binop","","Returns `true` if the binary operator takes its arguments by value"],[3,"is_by_value_unop","","Returns `true` if the unary operator takes its argument by value"],[3,"unop_to_string","",""],[3,"is_path","",""],[3,"int_ty_to_string","","Get a string representation of a signed int type, with its value.\nWe want to avoid \"45int\" and \"-3int\" in favor of \"45\" and \"-3\""],[3,"int_ty_max","",""],[3,"uint_ty_to_string","","Get a string representation of an unsigned int type, with its value.\nWe want to avoid \"42uint\" in favor of \"42u\""],[3,"uint_ty_max","",""],[3,"float_ty_to_string","",""],[3,"ident_to_path","",""],[3,"path_to_ident","",""],[3,"ident_to_pat","",""],[3,"name_to_dummy_lifetime","",""],[3,"impl_pretty_name","","Generate a \"pretty\" name for an `impl` from its type and trait.\nThis is designed so that symbols of `impl`'d methods give some\nhint of where they came from, (previously they would all just be\nlisted as `__extensions__::method_name::hash`, with no indication\nof the type)."],[3,"trait_method_to_ty_method","",""],[3,"trait_item_to_ty_method","","extract a TypeMethod from a TraitItem. if the TraitItem is\na default, pull out the useful fields to make a TypeMethod"],[3,"split_trait_methods","",""],[3,"struct_field_visibility","",""],[3,"operator_prec","","Maps a binary operator to its precedence"],[3,"empty_generics","",""],[3,"visit_ids_for_inlined_item","",""],[3,"compute_id_range_for_inlined_item","",""],[3,"compute_id_range_for_fn_body","","Computes the id range for a single fn body, ignoring nested items."],[3,"walk_pat","",""],[3,"view_path_id","",""],[3,"struct_def_is_tuple_like","","Returns true if the given struct def is tuple-like; i.e. that its fields\nare unnamed."],[3,"pat_is_ident","","Returns true if the given pattern consists solely of an identifier\nand false otherwise."],[3,"path_name_eq","",""],[3,"segments_name_eq","",""],[3,"lit_is_str","","Returns true if this literal is a string and false otherwise."],[5,"as_prec","","Precedence of the `as` operator, which is a binary operator\nnot appearing in the prior table."],[6,"IdVisitingOperation","",""],[9,"visit_id","","",128],[6,"EachViewItem","",""],[9,"each_view_item","","",129],[6,"PostExpansionMethod","","Macro invocations are guaranteed not to occur after expansion is complete.\nExtracting fields of a method requires a dynamic check to make sure that it's\nnot a macro invocation. This check is guaranteed to succeed, assuming\nthat the invocations are indeed gone."],[9,"pe_ident","","",130],[9,"pe_generics","","",130],[9,"pe_abi","","",130],[9,"pe_explicit_self","","",130],[9,"pe_unsafety","","",130],[9,"pe_fn_decl","","",130],[9,"pe_body","","",130],[9,"pe_vis","","",130],[10,"fmt","","",126],[10,"decode","","",126],[10,"encode","","",126],[10,"max","","",126],[10,"empty","","",126],[10,"add","","",126],[10,"visit_mod","","",127],[10,"visit_view_item","","",127],[10,"visit_foreign_item","","",127],[10,"visit_item","","",127],[10,"visit_local","","",127],[10,"visit_block","","",127],[10,"visit_stmt","","",127],[10,"visit_pat","","",127],[10,"visit_expr","","",127],[10,"visit_ty","","",127],[10,"visit_generics","","",127],[10,"visit_fn","","",127],[10,"visit_struct_field","","",127],[10,"visit_struct_def","","",127],[10,"visit_trait_item","","",127],[10,"visit_lifetime_ref","","",127],[10,"visit_lifetime_def","","",127],[10,"each_view_item","syntax::ast","",24],[10,"pe_ident","","",47],[10,"pe_generics","","",47],[10,"pe_abi","","",47],[10,"pe_explicit_self","","",47],[10,"pe_unsafety","","",47],[10,"pe_fn_decl","","",47],[10,"pe_body","","",47],[10,"pe_vis","","",47],[0,"attr","syntax",""],[1,"Stability","syntax::attr","Represents the #[deprecated=\"foo\"] and friends attributes."],[11,"level","","",131],[11,"text","","",131],[2,"InlineAttr","",""],[12,"InlineNone","","",132],[12,"InlineHint","","",132],[12,"InlineAlways","","",132],[12,"InlineNever","","",132],[2,"StabilityLevel","","The available stability levels."],[12,"Deprecated","","",133],[12,"Experimental","","",133],[12,"Unstable","","",133],[12,"Stable","","",133],[12,"Frozen","","",133],[12,"Locked","","",133],[2,"ReprAttr","",""],[12,"ReprAny","","",134],[12,"ReprInt","","",134],[12,"ReprExtern","","",134],[12,"ReprPacked","","",134],[2,"IntType","",""],[12,"SignedInt","","",135],[12,"UnsignedInt","","",135],[3,"mark_used","",""],[3,"is_used","",""],[3,"mk_name_value_item_str","",""],[3,"mk_name_value_item","",""],[3,"mk_list_item","",""],[3,"mk_word_item","",""],[3,"mk_attr_id","",""],[3,"mk_attr_inner","","Returns an inner attribute with the given value."],[3,"mk_attr_outer","","Returns an outer attribute with the given value."],[3,"mk_sugared_doc_attr","",""],[3,"contains","","Check if `needle` occurs in `haystack` by a structural\ncomparison. This is slightly subtle, and relies on ignoring the\nspan included in the `==` comparison a plain MetaItem."],[3,"contains_name","",""],[3,"first_attr_value_str_by_name","",""],[3,"last_meta_item_value_str_by_name","",""],[3,"sort_meta_items","",""],[3,"find_crate_name","",""],[3,"find_inline_attr","","Determine what `#[inline]` attribute is present in `attrs`, if any."],[3,"requests_inline","","True if `#[inline]` or `#[inline(always)]` is present in `attrs`."],[3,"cfg_matches","","Tests if a cfg-pattern matches the cfg set"],[3,"find_stability_generic","",""],[3,"find_stability","","Find the first stability attribute. `None` if none exists."],[3,"require_unique_names","",""],[3,"find_repr_attrs","","Parse #[repr(...)] forms."],[6,"AttrMetaMethods","",""],[10,"check_name","","",136],[9,"name","","Retrieve the name of the meta item, e.g. `foo` in `#[foo]`,\n`#[foo=\"bar\"]` and `#[foo(bar)]`",136],[9,"value_str","","Gets the string value if self is a MetaNameValue variant\ncontaining a string, otherwise None.",136],[9,"meta_item_list","","Gets a list of inner meta items from a list MetaItem type.",136],[6,"AttributeMethods","",""],[9,"meta","","",137],[9,"with_desugared_doc","","",137],[10,"check_name","","",138],[10,"name","","",138],[10,"value_str","","",138],[10,"meta_item_list","","",138],[10,"name","","",139],[10,"value_str","","",139],[10,"meta_item_list","","",139],[10,"meta","","Extract the MetaItem from inside this Attribute.",138],[10,"with_desugared_doc","","Convert self to a normal #[doc=\"foo\"] comment, if it is a\ncomment like `///` or `/** */`. (Returns self unchanged for\nnon-sugared doc attributes.)",138],[10,"eq","","",132],[10,"ne","","",132],[10,"fmt","","",131],[10,"clone","","",131],[10,"decode","","",131],[10,"encode","","",131],[10,"fmt","","",133],[10,"clone","","",133],[10,"partial_cmp","","",133],[10,"lt","","",133],[10,"le","","",133],[10,"gt","","",133],[10,"ge","","",133],[10,"eq","","",133],[10,"ne","","",133],[10,"decode","","",133],[10,"encode","","",133],[10,"decode","","",134],[10,"encode","","",134],[10,"fmt","","",134],[10,"eq","","",134],[10,"ne","","",134],[10,"is_ffi_safe","","",134],[10,"decode","","",135],[10,"encode","","",135],[10,"fmt","","",135],[10,"eq","","",135],[10,"ne","","",135],[10,"hash","","",135],[10,"is_signed","","",135],[0,"codemap","syntax","The CodeMap tracks all the source code used within a single crate, mapping from integer byte\npositions to the original source code location. Each bit of source parsed during crate parsing\n(typically files, in-memory strings, or various bits of macro expansion) cover a continuous\nrange of bytes in the CodeMap and are represented by FileMaps. Byte positions are stored in\n`spans` and used pervasively in the compiler. They are absolute positions within the CodeMap,\nwhich upon request can be converted to line and column information, source code snippets, etc."],[1,"BytePos","syntax::codemap","A byte offset. Keep this small (currently 32-bits), as AST contains\na lot of them."],[1,"CharPos","","A character offset. Because of multibyte utf8 characters, a byte offset\nis not equivalent to a character offset. The CodeMap will convert BytePos\nvalues to CharPos values as necessary."],[1,"Span","","Spans represent a region of code, used for error reporting. Positions in spans\nare *absolute* positions from the beginning of the codemap, not positions\nrelative to FileMaps. Methods on the CodeMap can be used to relate spans back\nto the original source."],[11,"lo","","",140],[11,"hi","","",140],[11,"expn_id","","Information about where the macro came from, if this piece of\ncode was created by a macro expansion.",140],[1,"Spanned","",""],[11,"node","","",141],[11,"span","","",141],[1,"Loc","","A source code location used for error reporting"],[11,"file","","Information about the original source",142],[11,"line","","The (1-based) line number",142],[11,"col","","The (0-based) column offset",142],[1,"LocWithOpt","","A source code location used as the result of lookup_char_pos_adj"],[11,"filename","","",143],[11,"line","","",143],[11,"col","","",143],[11,"file","","",143],[1,"FileMapAndLine","",""],[11,"fm","","",144],[11,"line","","",144],[1,"FileMapAndBytePos","",""],[11,"fm","","",145],[11,"pos","","",145],[1,"NameAndSpan","",""],[11,"name","","The name of the macro that was invoked to create the thing\nwith this Span.",146],[11,"format","","The format with which the macro was invoked.",146],[11,"span","","The span of the macro definition itself. The macro may not\nhave a sensible definition span (e.g. something defined\ncompletely inside libsyntax) in which case this is None.",146],[1,"ExpnInfo","","Extra information for tracking macro expansion of spans"],[11,"call_site","","The location of the actual macro invocation, e.g. `let x =\nfoo!();`",147],[11,"callee","","Information about the macro and its definition.",147],[1,"ExpnId","",""],[1,"FileLines","",""],[11,"file","","",148],[11,"lines","","",148],[1,"MultiByteChar","","Identifies an offset of a multi-byte character in a FileMap"],[11,"pos","","The absolute offset of the character in the CodeMap",149],[11,"bytes","","The number of bytes, >=2",149],[1,"FileMap","","A single source in the CodeMap"],[11,"name","","The name of the file that the source came from, source that doesn't\noriginate from files has names between angle brackets by convention,\ne.g. `<anon>`",150],[11,"src","","The complete source code",150],[11,"start_pos","","The start position of this source in the CodeMap",150],[11,"lines","","Locations of lines beginnings in the source code",150],[11,"multibyte_chars","","Locations of multi-byte characters in the source code",150],[1,"CodeMap","",""],[11,"files","","",151],[2,"MacroFormat","","The syntax with which a macro was invoked."],[12,"MacroAttribute","","e.g. #[deriving(...)] <item>",152],[12,"MacroBang","","e.g. `format!()`",152],[3,"spanned","",""],[3,"respan","",""],[3,"dummy_spanned","",""],[3,"mk_sp","",""],[3,"original_sp","","Return the span itself if it doesn't come from a macro expansion,\notherwise return the call site span up to the `enclosing_sp` by\nfollowing the `expn_info` chain."],[4,"FileName","",""],[18,"DUMMY_SP","",""],[18,"NO_EXPANSION","",""],[6,"Pos","",""],[9,"from_uint","","",153],[9,"to_uint","","",153],[10,"fmt","","",154],[10,"partial_cmp","","",154],[10,"lt","","",154],[10,"le","","",154],[10,"gt","","",154],[10,"ge","","",154],[10,"hash","","",154],[10,"eq","","",154],[10,"ne","","",154],[10,"clone","","",154],[10,"fmt","","",155],[10,"partial_cmp","","",155],[10,"lt","","",155],[10,"le","","",155],[10,"gt","","",155],[10,"ge","","",155],[10,"hash","","",155],[10,"eq","","",155],[10,"ne","","",155],[10,"from_uint","","",154],[10,"to_uint","","",154],[10,"add","","",154],[10,"sub","","",154],[10,"from_uint","","",155],[10,"to_uint","","",155],[10,"add","","",155],[10,"sub","","",155],[10,"hash","","",140],[10,"fmt","","",140],[10,"clone","","",140],[10,"fmt","","",141],[10,"hash","","",141],[10,"decode","","",141],[10,"encode","","",141],[10,"eq","","",141],[10,"ne","","",141],[10,"clone","","",141],[10,"eq","","",140],[10,"ne","","",140],[10,"encode","","",140],[10,"decode","","",140],[10,"fmt","","",152],[10,"hash","","",152],[10,"clone","","",152],[10,"fmt","","",146],[10,"hash","","",146],[10,"clone","","",146],[10,"fmt","","",147],[10,"hash","","",147],[10,"decode","","",156],[10,"encode","","",156],[10,"hash","","",156],[10,"fmt","","",156],[10,"clone","","",156],[10,"eq","","",156],[10,"ne","","",156],[10,"from_llvm_cookie","","",156],[10,"to_llvm_cookie","","",156],[10,"next_line","","EFFECT: register a start-of-line offset in the\ntable of line-beginnings.\nUNCHECKED INVARIANT: these offsets must be added in the right\norder and must be in the right places; there is shared knowledge\nabout what ends a line between this file and parse.rs\nWARNING: pos param here is the offset relative to start of CodeMap,\nand CodeMap will append a newline when adding a filemap without a newline at the end,\nso the safe way to call this is with value calculated as\nfilemap.start_pos + newline_offset_relative_to_the_start_of_filemap.",150],[10,"get_line","","get a line from the list of pre-computed line-beginnings\n",150],[10,"record_multibyte_char","","",150],[10,"is_real_file","","",150],[10,"new","","",151],[10,"new_filemap","","",151],[10,"mk_substr_filename","","",151],[10,"lookup_char_pos","","Lookup source information about a BytePos",151],[10,"lookup_char_pos_adj","","",151],[10,"span_to_string","","",151],[10,"span_to_filename","","",151],[10,"span_to_lines","","",151],[10,"span_to_snippet","","",151],[10,"get_filemap","","",151],[10,"lookup_byte_offset","","",151],[10,"bytepos_to_file_charpos","","Converts an absolute BytePos to a CharPos relative to the filemap and above.",151],[10,"record_expansion","","",151],[10,"with_expn_info","","",151],[10,"span_is_internal","","Check if a span is \"internal\" to a macro. This means that it is entirely generated by a\nmacro expansion and contains no code that was passed in as an argument.",151],[0,"config","syntax",""],[3,"strip_unconfigured_items","syntax::config",""],[3,"strip_items","",""],[0,"diagnostic","syntax",""],[1,"FatalError","syntax::diagnostic","This structure is used to signify that a task has panicked with a fatal error\nfrom the diagnostics. You can use this with the `Any` trait to figure out\nhow a rustc task died (if so desired)."],[1,"ExplicitBug","","Signifies that the compiler died with an explicit call to `.bug`\nor `.span_bug` rather than a failed assertion, etc."],[1,"SpanHandler","","A span-handler is like a handler but also\naccepts span information for source-location\nreporting."],[11,"handler","","",157],[11,"cm","","",157],[1,"Handler","","A handler deals with errors; certain errors\n(fatal, bug, unimpl) may cause immediate exit,\nothers log errors for later reporting."],[1,"EmitterWriter","",""],[2,"RenderSpan","",""],[12,"FullSpan","","A FullSpan renders with both with an initial line for the\nmessage, prefixed by file:linenum, followed by a summary of\nthe source code covered by the span.",158],[12,"FileLine","","A FileLine renders with just a line for the message prefixed\nby file:linenum.",158],[2,"ColorConfig","",""],[12,"Auto","","",159],[12,"Always","","",159],[12,"Never","","",159],[2,"Level","",""],[12,"Bug","","",160],[12,"Fatal","","",160],[12,"Error","","",160],[12,"Warning","","",160],[12,"Note","","",160],[12,"Help","","",160],[3,"mk_span_handler","",""],[3,"default_handler","",""],[3,"mk_handler","",""],[3,"expect","",""],[6,"Emitter","",""],[9,"emit","","",161],[9,"custom_emit","","",161],[10,"clone","","",158],[10,"clone","","",159],[10,"span_fatal","","",157],[10,"span_err","","",157],[10,"span_err_with_code","","",157],[10,"span_warn","","",157],[10,"span_warn_with_code","","",157],[10,"span_note","","",157],[10,"span_end_note","","",157],[10,"span_help","","",157],[10,"fileline_note","","",157],[10,"span_bug","","",157],[10,"span_unimpl","","",157],[10,"handler","","",157],[10,"fatal","","",162],[10,"err","","",162],[10,"bump_err_count","","",162],[10,"err_count","","",162],[10,"has_errors","","",162],[10,"abort_if_errors","","",162],[10,"warn","","",162],[10,"note","","",162],[10,"help","","",162],[10,"bug","","",162],[10,"unimpl","","",162],[10,"emit","","",162],[10,"emit_with_code","","",162],[10,"custom_emit","","",162],[10,"clone","","",160],[10,"eq","","",160],[10,"ne","","",160],[10,"fmt","","",160],[10,"stderr","","",163],[10,"new","","",163],[10,"emit","","",163],[10,"custom_emit","","",163],[0,"feature_gate","syntax","Feature gating"],[1,"Features","syntax::feature_gate","A set of features to be used by later passes."],[11,"default_type_params","","",164],[11,"unboxed_closures","","",164],[11,"rustc_diagnostic_macros","","",164],[11,"import_shadowing","","",164],[11,"visible_private_types","","",164],[11,"quote","","",164],[11,"opt_out_copy","","",164],[3,"check_crate_macros","",""],[3,"check_crate","",""],[10,"new","","",164],[0,"fold","syntax","A Folder represents an AST->AST fold; it accepts an AST piece,\nand returns a piece of the same type. So, for instance, macro\nexpansion is a Folder that walks over an AST and produces another\nAST."],[3,"noop_fold_meta_items","syntax::fold",""],[3,"noop_fold_view_path","",""],[3,"noop_fold_arm","",""],[3,"noop_fold_decl","",""],[3,"noop_fold_ty_binding","",""],[3,"noop_fold_ty","",""],[3,"noop_fold_qpath","",""],[3,"noop_fold_foreign_mod","",""],[3,"noop_fold_variant","",""],[3,"noop_fold_ident","",""],[3,"noop_fold_uint","",""],[3,"noop_fold_path","",""],[3,"noop_fold_path_parameters","",""],[3,"noop_fold_angle_bracketed_parameter_data","",""],[3,"noop_fold_parenthesized_parameter_data","",""],[3,"noop_fold_local","",""],[3,"noop_fold_attribute","",""],[3,"noop_fold_explicit_self_underscore","",""],[3,"noop_fold_explicit_self","",""],[3,"noop_fold_mac","",""],[3,"noop_fold_meta_item","",""],[3,"noop_fold_arg","",""],[3,"noop_fold_tt","",""],[3,"noop_fold_tts","",""],[3,"noop_fold_token","",""],[3,"noop_fold_interpolated","","apply folder to elements of interpolated nodes"],[3,"noop_fold_fn_decl","",""],[3,"noop_fold_ty_param_bound","",""],[3,"noop_fold_ty_param","",""],[3,"noop_fold_ty_params","",""],[3,"noop_fold_lifetime","",""],[3,"noop_fold_lifetime_def","",""],[3,"noop_fold_lifetimes","",""],[3,"noop_fold_lifetime_defs","",""],[3,"noop_fold_opt_lifetime","",""],[3,"noop_fold_generics","",""],[3,"noop_fold_where_clause","",""],[3,"noop_fold_where_predicate","",""],[3,"noop_fold_typedef","",""],[3,"noop_fold_associated_type","",""],[3,"noop_fold_struct_def","",""],[3,"noop_fold_trait_ref","",""],[3,"noop_fold_poly_trait_ref","",""],[3,"noop_fold_struct_field","",""],[3,"noop_fold_field","",""],[3,"noop_fold_mt","",""],[3,"noop_fold_opt_bounds","",""],[3,"noop_fold_view_item","",""],[3,"noop_fold_block","",""],[3,"noop_fold_item_underscore","",""],[3,"noop_fold_type_method","",""],[3,"noop_fold_mod","",""],[3,"noop_fold_crate","",""],[3,"noop_fold_item","",""],[3,"noop_fold_item_simple","",""],[3,"noop_fold_foreign_item","",""],[3,"noop_fold_method","",""],[3,"noop_fold_pat","",""],[3,"noop_fold_expr","",""],[3,"noop_fold_stmt","",""],[6,"MoveMap","",""],[9,"move_map","","",165],[6,"Folder","",""],[10,"fold_crate","","",166],[10,"fold_meta_items","","",166],[10,"fold_meta_item","","",166],[10,"fold_view_path","","",166],[10,"fold_view_item","","",166],[10,"fold_foreign_item","","",166],[10,"fold_item","","",166],[10,"fold_item_simple","","",166],[10,"fold_struct_field","","",166],[10,"fold_item_underscore","","",166],[10,"fold_fn_decl","","",166],[10,"fold_type_method","","",166],[10,"fold_method","","",166],[10,"fold_block","","",166],[10,"fold_stmt","","",166],[10,"fold_arm","","",166],[10,"fold_pat","","",166],[10,"fold_decl","","",166],[10,"fold_expr","","",166],[10,"fold_ty","","",166],[10,"fold_qpath","","",166],[10,"fold_ty_binding","","",166],[10,"fold_mod","","",166],[10,"fold_foreign_mod","","",166],[10,"fold_variant","","",166],[10,"fold_ident","","",166],[10,"fold_uint","","",166],[10,"fold_path","","",166],[10,"fold_path_parameters","","",166],[10,"fold_angle_bracketed_parameter_data","","",166],[10,"fold_parenthesized_parameter_data","","",166],[10,"fold_local","","",166],[10,"fold_mac","","",166],[10,"fold_explicit_self","","",166],[10,"fold_explicit_self_underscore","","",166],[10,"fold_lifetime","","",166],[10,"fold_lifetime_def","","",166],[10,"fold_attribute","","",166],[10,"fold_arg","","",166],[10,"fold_generics","","",166],[10,"fold_trait_ref","","",166],[10,"fold_poly_trait_ref","","",166],[10,"fold_struct_def","","",166],[10,"fold_lifetimes","","",166],[10,"fold_lifetime_defs","","",166],[10,"fold_ty_param","","",166],[10,"fold_ty_params","","",166],[10,"fold_tt","","",166],[10,"fold_tts","","",166],[10,"fold_token","","",166],[10,"fold_interpolated","","",166],[10,"fold_opt_lifetime","","",166],[10,"fold_variant_arg","","",166],[10,"fold_opt_bounds","","",166],[10,"fold_bounds","","",166],[10,"fold_ty_param_bound","","",166],[10,"fold_mt","","",166],[10,"fold_field","","",166],[10,"fold_where_clause","","",166],[10,"fold_where_predicate","","",166],[10,"fold_typedef","","",166],[10,"fold_associated_type","","",166],[10,"new_id","","",166],[10,"new_span","","",166],[10,"move_map","collections::vec","",167],[0,"owned_slice","syntax",""],[1,"OwnedSlice","syntax::owned_slice","A non-growable owned slice. This is a separate type to allow the\nrepresentation to change."],[10,"cmp","","",168],[10,"partial_cmp","","",168],[10,"lt","","",168],[10,"le","","",168],[10,"gt","","",168],[10,"ge","","",168],[10,"eq","","",168],[10,"ne","","",168],[10,"hash","","",168],[10,"fmt","","",168],[10,"empty","","",168],[10,"from_vec","","",168],[10,"into_vec","","",168],[10,"as_slice","","",168],[10,"move_iter","","",168],[10,"map","","",168],[10,"deref","","",168],[10,"default","","",168],[10,"clone","","",168],[10,"from_iter","","",168],[10,"encode","","",168],[10,"decode","","",168],[0,"parse","syntax","The main parser interface"],[1,"ParseSess","syntax::parse","Info about a parsing session."],[11,"span_diagnostic","","",169],[11,"node_id","","",169],[3,"new_parse_sess","",""],[3,"new_parse_sess_special_handler","",""],[3,"parse_crate_from_file","",""],[3,"parse_crate_attrs_from_file","",""],[3,"parse_crate_from_source_str","",""],[3,"parse_crate_attrs_from_source_str","",""],[3,"parse_expr_from_source_str","",""],[3,"parse_item_from_source_str","",""],[3,"parse_meta_from_source_str","",""],[3,"parse_stmt_from_source_str","",""],[3,"parse_tts_from_source_str","",""],[3,"new_parser_from_source_str","",""],[3,"new_parser_from_file","","Create a new parser, handling errors as appropriate\nif the file doesn't exist"],[3,"new_sub_parser_from_file","","Given a session, a crate config, a path, and a span, add\nthe file at the given path to the codemap, and return a parser.\nOn an error, use the given span as the source of the problem."],[3,"filemap_to_parser","","Given a filemap and config, return a parser"],[3,"new_parser_from_tts","",""],[3,"file_to_filemap","","Given a session and a path and an optional span (for error reporting),\nadd the path to the session's codemap and return the new filemap."],[3,"string_to_filemap","","Given a session and a string, add the string to\nthe session's codemap and return the new filemap"],[3,"filemap_to_tts","","Given a filemap, produce a sequence of token-trees"],[3,"tts_to_parser","","Given tts and cfg, produce a parser"],[3,"maybe_aborted","","Abort if necessary"],[3,"char_lit","","Parse a string representing a character literal into its final form.\nRather than just accepting/rejecting a given literal, unescapes it as\nwell. Can take any slice prefixed by a character escape. Returns the\ncharacter and the number of characters consumed."],[3,"str_lit","","Parse a string representing a string literal into its final form. Does\nunescaping."],[3,"raw_str_lit","","Parse a string representing a raw string literal into its final form. The\nonly operation this does is convert embedded CRLF into a single LF."],[3,"float_lit","",""],[3,"byte_lit","","Parse a string representing a byte literal into its final form. Similar to `char_lit`"],[3,"binary_lit","",""],[3,"integer_lit","",""],[0,"lexer","",""],[1,"TokenAndSpan","syntax::parse::lexer",""],[11,"tok","","",170],[11,"sp","","",170],[1,"StringReader","",""],[11,"span_diagnostic","","",171],[11,"pos","","The absolute offset within the codemap of the next character to read",171],[11,"last_pos","","The absolute offset within the codemap of the last character read(curr)",171],[11,"col","","The column of the next character to read",171],[11,"curr","","The last character to be read",171],[11,"filemap","","",171],[11,"peek_tok","","",171],[11,"peek_span","","",171],[3,"make_reader_with_embedded_idents","",""],[3,"is_whitespace","",""],[3,"is_doc_comment","",""],[3,"is_block_doc_comment","",""],[0,"comments","",""],[1,"Comment","syntax::parse::lexer::comments",""],[11,"style","","",172],[11,"lines","","",172],[11,"pos","","",172],[1,"Literal","",""],[11,"lit","","",173],[11,"pos","","",173],[2,"CommentStyle","",""],[12,"Isolated","","No code on either side of each line of the comment",174],[12,"Trailing","","Code exists to the left of the comment",174],[12,"Mixed","","Code before /* foo */ and after the comment",174],[12,"BlankLine","","Just a manual blank line \"\\n\\n\", for layout",174],[3,"is_doc_comment","",""],[3,"doc_comment_style","",""],[3,"strip_doc_comment_decoration","",""],[3,"gather_comments_and_literals","",""],[10,"eq","","",174],[10,"ne","","",174],[10,"clone","","",174],[10,"clone","","",172],[10,"clone","","",173],[6,"Reader","syntax::parse::lexer",""],[9,"is_eof","","",175],[9,"next_token","","",175],[9,"fatal","","Report a fatal error with the current span.",175],[9,"err","","Report a non-fatal error with the current span.",175],[9,"peek","","",175],[10,"real_token","","Get a token the parser cares about.",175],[10,"fmt","","",170],[10,"eq","","",170],[10,"ne","","",170],[10,"clone","","",170],[10,"is_eof","","",171],[10,"next_token","","Return the next token. EFFECT: advances the string_reader.",171],[10,"fatal","","",171],[10,"err","","",171],[10,"peek","","",171],[10,"new_raw","","For comments.rs, which hackily pokes into pos and curr",171],[10,"new","","",171],[10,"curr_is","","",171],[10,"fatal_span","","Report a fatal lexical error with a given span.",171],[10,"err_span","","Report a lexical error with a given span.",171],[10,"with_str_from","","Calls `f` with a string slice of the source text spanning from `start`\nup to but excluding `self.last_pos`, meaning the slice does not include\nthe character `self.curr`.",171],[10,"name_from","","Create a Name from a given offset to the current offset, each\nadjusted 1 towards each other (assumes that on either side there is a\nsingle-byte delimiter).",171],[10,"name_from_to","","As name_from, with an explicit endpoint.",171],[10,"bump","","Advance the StringReader by one character. If a newline is\ndiscovered, add it to the FileMap's list of line start offsets.",171],[10,"nextch","","",171],[10,"nextch_is","","",171],[10,"nextnextch","","",171],[10,"nextnextch_is","","",171],[0,"parser","syntax::parse",""],[1,"Restrictions","syntax::parse::parser",""],[1,"Parser","",""],[11,"sess","","",176],[11,"token","","the current token:",176],[11,"span","","the span of the current token:",176],[11,"last_span","","the span of the prior token:",176],[11,"cfg","","",176],[11,"last_token","","the previous token or None (only stashed sometimes).",176],[11,"buffer","","",176],[11,"buffer_start","","",176],[11,"buffer_end","","",176],[11,"tokens_consumed","","",176],[11,"restrictions","","",176],[11,"quote_depth","","",176],[11,"reader","","",176],[11,"interner","","",176],[11,"obsolete_set","","The set of seen errors about obsolete syntax. Used to suppress\nextra detail when the same error is seen twice",176],[11,"mod_path_stack","","Used to determine the path to externally loaded source files",176],[11,"open_braces","","Stack of spans of open delimiters. Used for error message.",176],[11,"owns_directory","","Flag if this parser \"owns\" the directory that it is currently parsing\nin. This will affect how nested files are looked up.",176],[11,"root_module_name","","Name of the root module this parser originated from. If `None`, then the\nname is not known. This does not change while the parser is descending\ninto modules, and sub-parsers have new values for this name.",176],[11,"expected_tokens","","",176],[2,"PathParsingMode","","How to parse a path. There are four different kinds of paths, all of which\nare parsed somewhat differently."],[12,"NoTypesAllowed","","A path with no type parameters; e.g. `foo::bar::Baz`",177],[12,"LifetimeAndTypesWithoutColons","","A path with a lifetime and type parameters, with no double colons\nbefore the type parameters; e.g. `foo::bar<'a>::Baz<T>`",177],[12,"LifetimeAndTypesWithColons","","A path with a lifetime and type parameters with double colons before\nthe type parameters; e.g. `foo::bar::<'a>::Baz::<T>`",177],[2,"BoundParsingMode","","How to parse a bound, whether to allow bound modifiers such as `?`."],[12,"Bare","","",178],[12,"Modified","","",178],[2,"TokenType","",""],[12,"Token","","",179],[12,"Operator","","",179],[18,"UNRESTRICTED","",""],[18,"RESTRICTION_STMT_EXPR","",""],[18,"RESTRICTION_NO_BAR_OP","",""],[18,"RESTRICTION_NO_STRUCT_LITERAL","",""],[18,"RESTRICTION_NO_DOTS","",""],[10,"hash","","",180],[10,"cmp","","",180],[10,"partial_cmp","","",180],[10,"lt","","",180],[10,"le","","",180],[10,"gt","","",180],[10,"ge","","",180],[10,"clone","","",180],[10,"eq","","",180],[10,"ne","","",180],[10,"empty","","Returns an empty set of flags.",180],[10,"all","","Returns the set containing all flags.",180],[10,"bits","","Returns the raw value of the flags currently stored.",180],[10,"from_bits","","Convert from underlying bit representation, unless that\nrepresentation contains bits that do not correspond to a flag.",180],[10,"from_bits_truncate","","Convert from underlying bit representation, dropping any bits\nthat do not correspond to flags.",180],[10,"is_empty","","Returns `true` if no flags are currently stored.",180],[10,"is_all","","Returns `true` if all flags are currently set.",180],[10,"intersects","","Returns `true` if there are flags common to both `self` and `other`.",180],[10,"contains","","Returns `true` all of the flags in `other` are contained within `self`.",180],[10,"insert","","Inserts the specified flags in-place.",180],[10,"remove","","Removes the specified flags in-place.",180],[10,"toggle","","Toggles the specified flags in-place.",180],[10,"bitor","","Returns the union of the two sets of flags.",180],[10,"bitxor","","Returns the left flags, but with all the right flags toggled.",180],[10,"bitand","","Returns the intersection between the two sets of flags.",180],[10,"sub","","Returns the set difference of the two sets of flags.",180],[10,"not","","Returns the complement of this set of flags.",180],[10,"eq","","",177],[10,"ne","","",177],[10,"eq","","",178],[10,"ne","","",178],[10,"clone","","",179],[10,"eq","","",179],[10,"ne","","",179],[10,"new","","",176],[10,"token_to_string","","Convert a token to a string using self's reader",176],[10,"this_token_to_string","","Convert the current token to a string using self's reader",176],[10,"unexpected_last","","",176],[10,"unexpected","","",176],[10,"expect","","Expect and consume the token t. Signal an error if\nthe next token is not t.",176],[10,"expect_one_of","","Expect next token to be edible or inedible token.  If edible,\nthen consume it; if inedible, then return without consuming\nanything.  Signal a fatal error if next token is unexpected.",176],[10,"check_for_erroneous_unit_struct_expecting","","Check for erroneous `ident { }`; if matches, signal error and\nrecover (without consuming any expected input token).  Returns\ntrue if and only if input was consumed for recovery.",176],[10,"commit_expr","","Commit to parsing a complete expression `e` expected to be\nfollowed by some token from the set edible + inedible.  Recover\nfrom anticipated input errors, discarding erroneous characters.",176],[10,"commit_expr_expecting","","",176],[10,"commit_stmt","","Commit to parsing a complete statement `s`, which expects to be\nfollowed by some token from the set edible + inedible.  Check\nfor recoverable input errors, discarding erroneous characters.",176],[10,"commit_stmt_expecting","","",176],[10,"parse_ident","","",176],[10,"parse_path_list_item","","",176],[10,"check","","Check if the next token is `tok`, and return `true` if so.",176],[10,"eat","","Consume token 'tok' if it exists. Returns true if the given\ntoken was present, false otherwise.",176],[10,"eat_keyword","","If the next token is the given keyword, eat it and return\ntrue. Otherwise, return false.",176],[10,"expect_keyword","","If the given word is not a keyword, signal an error.\nIf the next token is not the given word, signal an error.\nOtherwise, eat it.",176],[10,"check_strict_keywords","","Signal an error if the given string is a strict keyword",176],[10,"check_reserved_keywords","","Signal an error if the current token is a reserved keyword",176],[10,"expect_no_suffix","","",176],[10,"expect_gt","","Expect and consume a GT. if a >> is seen, replace it\nwith a single > and continue. If a GT is not seen,\nsignal an error.",176],[10,"parse_seq_to_before_gt_or_return","","",176],[10,"parse_seq_to_before_gt","","Parse a sequence bracketed by '<' and '>', stopping\nbefore the '>'.",176],[10,"parse_seq_to_gt","","",176],[10,"parse_seq_to_gt_or_return","","",176],[10,"parse_seq_to_end","","Parse a sequence, including the closing delimiter. The function\nf must consume tokens until reaching the next separator or\nclosing bracket.",176],[10,"parse_seq_to_before_end","","Parse a sequence, not including the closing delimiter. The function\nf must consume tokens until reaching the next separator or\nclosing bracket.",176],[10,"parse_unspanned_seq","","Parse a sequence, including the closing delimiter. The function\nf must consume tokens until reaching the next separator or\nclosing bracket.",176],[10,"parse_enum_variant_seq","","Parse a sequence parameter of enum variant. For consistency purposes,\nthese should not be empty.",176],[10,"parse_seq","","",176],[10,"bump","","Advance the parser by one token",176],[10,"bump_and_get","","Advance the parser by one token and return the bumped token.",176],[10,"replace_token","","EFFECT: replace the current token and span with the given one",176],[10,"buffer_length","","",176],[10,"look_ahead","","",176],[10,"fatal","","",176],[10,"span_fatal","","",176],[10,"span_fatal_help","","",176],[10,"span_note","","",176],[10,"span_help","","",176],[10,"bug","","",176],[10,"warn","","",176],[10,"span_warn","","",176],[10,"span_err","","",176],[10,"span_bug","","",176],[10,"abort_if_errors","","",176],[10,"id_to_interned_str","","",176],[10,"token_is_bare_fn_keyword","","Is the current token one of the keywords that signals a bare function\ntype?",176],[10,"token_is_closure_keyword","","Is the current token one of the keywords that signals a closure type?",176],[10,"get_lifetime","","",176],[10,"parse_for_in_type","","",176],[10,"parse_ty_path","","",176],[10,"parse_ty_bare_fn","","parse a TyBareFn type:",176],[10,"parse_proc_type","","Parses a procedure type (`proc`). The initial `proc` keyword must\nalready have been parsed.",176],[10,"parse_optional_unboxed_closure_kind","","Parses an optional unboxed closure kind (`&:`, `&mut:`, or `:`).",176],[10,"parse_ty_bare_fn_or_ty_closure","","",176],[10,"parse_ty_closure","","Parse a TyClosure type",176],[10,"parse_unsafety","","",176],[10,"parse_trait_items","","Parse the items in a trait declaration",176],[10,"parse_mt","","Parse a possibly mutable type",176],[10,"parse_ty_field","","Parse [mut/const/imm] ID : TY\nnow used only by obsolete record syntax parser...",176],[10,"parse_ret_ty","","Parse optional return type [ -> TY ] in function decl",176],[10,"parse_ty_sum","","Parse a type in a context where `T1+T2` is allowed.",176],[10,"parse_ty","","Parse a type.",176],[10,"parse_borrowed_pointee","","",176],[10,"parse_ptr","","",176],[10,"is_named_argument","","",176],[10,"parse_arg_general","","This version of parse arg doesn't necessarily require\nidentifier names.",176],[10,"parse_arg","","Parse a single function argument",176],[10,"parse_fn_block_arg","","Parse an argument in a lambda header e.g. |arg, arg|",176],[10,"maybe_parse_fixed_length_of_vec","","",176],[10,"lit_from_token","","Matches token_lit = LIT_INTEGER | ...",176],[10,"parse_lit","","Matches lit = true | false | token_lit",176],[10,"parse_literal_maybe_minus","","matches '-' lit | lit",176],[10,"parse_path","","Parses a path and optional type parameter bounds, depending on the\nmode. The `mode` parameter determines whether lifetimes, types, and/or\nbounds are permitted and whether `::` must precede type parameter\ngroups.",176],[10,"parse_path_segments_without_colons","","Examples:\n- `a::b<T,U>::c<V,W>`\n- `a::b<T,U>::c(V) -> W`\n- `a::b<T,U>::c(V)`",176],[10,"parse_path_segments_with_colons","","Examples:\n- `a::b::<T,U>::c`",176],[10,"parse_path_segments_without_types","","Examples:\n- `a::b::c`",176],[10,"parse_opt_lifetime","","parses 0 or 1 lifetime",176],[10,"parse_lifetime","","Parses a single lifetime\nMatches lifetime = LIFETIME",176],[10,"parse_lifetime_defs","","Parses `lifetime_defs = [ lifetime_defs { ',' lifetime_defs } ]` where `lifetime_def  =\nlifetime [':' lifetimes]`",176],[10,"parse_lifetimes","","matches lifetimes = ( lifetime ) | ( lifetime , lifetimes ) actually, it matches the empty\none too, but putting that in there messes up the grammar....",176],[10,"parse_mutability","","Parse mutability declaration (mut/const/imm)",176],[10,"parse_field","","Parse ident COLON expr",176],[10,"mk_expr","","",176],[10,"mk_unary","","",176],[10,"mk_binary","","",176],[10,"mk_call","","",176],[10,"mk_index","","",176],[10,"mk_slice","","",176],[10,"mk_range","","",176],[10,"mk_field","","",176],[10,"mk_tup_field","","",176],[10,"mk_assign_op","","",176],[10,"mk_mac_expr","","",176],[10,"mk_lit_u32","","",176],[10,"parse_bottom_expr","","At the bottom (top?) of the precedence hierarchy,\nparse things like parenthesized exprs,\nmacros, return, etc.",176],[10,"parse_block_expr","","Parse a block or unsafe block",176],[10,"parse_dot_or_call_expr","","parse a.b or a(13) or a[4] or just a",176],[10,"parse_dot_or_call_expr_with","","",176],[10,"parse_sep_and_kleene_op","","Parse an optional separator followed by a Kleene-style\nrepetition token (+ or *).",176],[10,"parse_token_tree","","parse a single token tree from the input.",176],[10,"parse_all_token_trees","","",176],[10,"parse_prefix_expr","","Parse a prefix-operator expr",176],[10,"parse_binops","","Parse an expression of binops",176],[10,"parse_more_binops","","Parse an expression of binops of at least min_prec precedence",176],[10,"parse_assign_expr","","Parse an assignment expression....\nactually, this seems to be the main entry point for\nparsing an arbitrary expression.",176],[10,"parse_if_expr","","Parse an 'if' or 'if let' expression ('if' token already eaten)",176],[10,"parse_if_let_expr","","Parse an 'if let' expression ('if' token already eaten)",176],[10,"parse_lambda_expr","","",176],[10,"parse_else_expr","","",176],[10,"parse_for_expr","","Parse a 'for' .. 'in' expression ('for' token already eaten)",176],[10,"parse_while_expr","","Parse a 'while' or 'while let' expression ('while' token already eaten)",176],[10,"parse_while_let_expr","","Parse a 'while let' expression ('while' token already eaten)",176],[10,"parse_loop_expr","","",176],[10,"parse_arm","","",176],[10,"parse_expr","","Parse an expression",176],[10,"parse_expr_res","","Parse an expression, subject to the given restrictions",176],[10,"parse_pat","","Parse a pattern.",176],[10,"parse_stmt","","Parse a statement. may include decl.\nPrecondition: any attributes are parsed already",176],[10,"parse_block","","Parse a block. No inner attrs are allowed.",176],[10,"parse_generics","","Parse a set of optional generic type parameter declarations. Where\nclauses are not parsed here, and must be added later via\n`parse_where_clause()`.",176],[10,"parse_fn_decl","","Parse the argument list and result type of a function declaration",176],[10,"parse_method_with_outer_attributes","","Parse a method in a trait impl",176],[10,"parse_method","","Parse a method in a trait impl, starting with `attrs` attributes.",176],[10,"parse_single_struct_field","","Parse a structure field declaration",176],[10,"parse_item_with_outer_attributes","","",176],[10,"parse_item","","",176],[10,"parse_view_item","","Parse a ViewItem, e.g. `use foo::bar` or `extern crate foo`",176],[10,"parse_crate_mod","","Parses a source module as a crate. This is the main\nentry point for the parser.",176],[10,"parse_optional_str","","",176],[10,"parse_str","","",176],[0,"token","syntax::parse",""],[1,"InternedString","syntax::parse::token","Represents a string stored in the task-local interner. Because the\ninterner lives for the life of the task, this can be safely treated as an\nimmortal string, as long as it never crosses between tasks."],[2,"BinOpToken","",""],[12,"Plus","","",181],[12,"Minus","","",181],[12,"Star","","",181],[12,"Slash","","",181],[12,"Percent","","",181],[12,"Caret","","",181],[12,"And","","",181],[12,"Or","","",181],[12,"Shl","","",181],[12,"Shr","","",181],[2,"DelimToken","","A delimeter token"],[12,"Paren","","A round parenthesis: `(` or `)`",182],[12,"Bracket","","A square bracket: `[` or `]`",182],[12,"Brace","","A curly brace: `{` or `}`",182],[2,"IdentStyle","",""],[12,"ModName","","`::` follows the identifier with no whitespace in-between.",183],[12,"Plain","","",183],[2,"Lit","",""],[12,"Byte","","",184],[12,"Char","","",184],[12,"Integer","","",184],[12,"Float","","",184],[12,"Str_","","",184],[12,"StrRaw","","",184],[12,"Binary","","",184],[12,"BinaryRaw","","",184],[2,"Token","",""],[12,"Eq","","",185],[12,"Lt","","",185],[12,"Le","","",185],[12,"EqEq","","",185],[12,"Ne","","",185],[12,"Ge","","",185],[12,"Gt","","",185],[12,"AndAnd","","",185],[12,"OrOr","","",185],[12,"Not","","",185],[12,"Tilde","","",185],[12,"BinOp","","",185],[12,"BinOpEq","","",185],[12,"At","","",185],[12,"Dot","","",185],[12,"DotDot","","",185],[12,"DotDotDot","","",185],[12,"Comma","","",185],[12,"Semi","","",185],[12,"Colon","","",185],[12,"ModSep","","",185],[12,"RArrow","","",185],[12,"LArrow","","",185],[12,"FatArrow","","",185],[12,"Pound","","",185],[12,"Dollar","","",185],[12,"Question","","",185],[12,"OpenDelim","","An opening delimeter, eg. `{`",185],[12,"CloseDelim","","A closing delimeter, eg. `}`",185],[12,"Literal","","",185],[12,"Ident","","",185],[12,"Underscore","","",185],[12,"Lifetime","","",185],[12,"Interpolated","","",185],[12,"DocComment","","Doc comment",185],[12,"MatchNt","","Parse a nonterminal (name to bind, name of NT, styles of their idents)",185],[12,"SubstNt","","A syntactic variable that will be filled in by macro expansion.",185],[12,"Whitespace","","Whitespace",185],[12,"Comment","","Comment",185],[12,"Shebang","","",185],[12,"Eof","","",185],[2,"Nonterminal","","For interpolation during macro expansion."],[12,"NtItem","","",186],[12,"NtBlock","","",186],[12,"NtStmt","","",186],[12,"NtPat","","",186],[12,"NtExpr","","",186],[12,"NtTy","","",186],[12,"NtIdent","","",186],[12,"NtMeta","","Stuff inside brackets for attributes",186],[12,"NtPath","","",186],[12,"NtTT","","",186],[3,"get_ident_interner","",""],[3,"reset_ident_interner","","Reset the ident interner to its initial state."],[3,"get_name","","Returns the string contents of a name, using the task-local interner."],[3,"get_ident","","Returns the string contents of an identifier, using the task-local\ninterner."],[3,"intern_and_get_ident","","Interns and returns the string contents of an identifier, using the\ntask-local interner."],[3,"intern","","Maps a string to its interned representation."],[3,"gensym","","gensym's a new uint, using the current interner."],[3,"str_to_ident","","Maps a string to an identifier with an empty syntax context."],[3,"gensym_ident","","Maps a string to a gensym'ed identifier."],[3,"fresh_name","",""],[3,"fresh_mark","",""],[0,"special_idents","",""],[18,"invalid","syntax::parse::token::special_idents",""],[18,"self_","",""],[18,"statik","",""],[18,"super_","",""],[18,"static_lifetime","",""],[18,"tt","",""],[18,"matchers","",""],[18,"clownshoe_abi","",""],[18,"opaque","",""],[18,"unnamed_field","",""],[18,"type_self","",""],[18,"prelude_import","",""],[0,"special_names","syntax::parse::token",""],[18,"invalid","syntax::parse::token::special_names",""],[18,"self_","",""],[18,"statik","",""],[18,"super_","",""],[18,"static_lifetime","",""],[18,"tt","",""],[18,"matchers","",""],[18,"clownshoe_abi","",""],[18,"opaque","",""],[18,"unnamed_field","",""],[18,"type_self","",""],[18,"prelude_import","",""],[0,"keywords","syntax::parse::token","All the valid words that have meaning in the Rust language."],[2,"Keyword","syntax::parse::token::keywords",""],[12,"As","","",187],[12,"Break","","",187],[12,"Crate","","",187],[12,"Else","","",187],[12,"Enum","","",187],[12,"Extern","","",187],[12,"False","","",187],[12,"Fn","","",187],[12,"For","","",187],[12,"If","","",187],[12,"Impl","","",187],[12,"In","","",187],[12,"Let","","",187],[12,"Loop","","",187],[12,"Match","","",187],[12,"Mod","","",187],[12,"Move","","",187],[12,"Mut","","",187],[12,"Pub","","",187],[12,"Ref","","",187],[12,"Return","","",187],[12,"Static","","",187],[12,"Self","","",187],[12,"Struct","","",187],[12,"Super","","",187],[12,"True","","",187],[12,"Trait","","",187],[12,"Type","","",187],[12,"Unsafe","","",187],[12,"Use","","",187],[12,"Virtual","","",187],[12,"While","","",187],[12,"Continue","","",187],[12,"Proc","","",187],[12,"Box","","",187],[12,"Const","","",187],[12,"Where","","",187],[12,"Alignof","","",187],[12,"Be","","",187],[12,"Offsetof","","",187],[12,"Priv","","",187],[12,"Pure","","",187],[12,"Sizeof","","",187],[12,"Typeof","","",187],[12,"Unsized","","",187],[12,"Yield","","",187],[12,"Do","","",187],[12,"Abstract","","",187],[12,"Final","","",187],[12,"Override","","",187],[10,"to_name","","",187],[4,"IdentInterner","syntax::parse::token",""],[18,"SELF_KEYWORD_NAME","",""],[18,"SELF_KEYWORD_NAME_NUM","",""],[10,"fmt","","",181],[10,"hash","","",181],[10,"eq","","",181],[10,"ne","","",181],[10,"decode","","",181],[10,"encode","","",181],[10,"clone","","",181],[10,"fmt","","",182],[10,"hash","","",182],[10,"eq","","",182],[10,"ne","","",182],[10,"decode","","",182],[10,"encode","","",182],[10,"clone","","",182],[10,"fmt","","",183],[10,"hash","","",183],[10,"eq","","",183],[10,"ne","","",183],[10,"decode","","",183],[10,"encode","","",183],[10,"clone","","",183],[10,"fmt","","",184],[10,"hash","","",184],[10,"eq","","",184],[10,"ne","","",184],[10,"decode","","",184],[10,"encode","","",184],[10,"clone","","",184],[10,"short_name","","",184],[10,"fmt","","",185],[10,"hash","","",185],[10,"eq","","",185],[10,"ne","","",185],[10,"decode","","",185],[10,"encode","","",185],[10,"clone","","",185],[10,"can_begin_expr","","Returns `true` if the token can appear at the start of an expression.",185],[10,"is_lit","","Returns `true` if the token is any literal",185],[10,"is_ident","","Returns `true` if the token is an identifier.",185],[10,"is_path","","Returns `true` if the token is an interpolated path.",185],[10,"is_plain_ident","","Returns `true` if the token is a path that is not followed by a `::`\ntoken.",185],[10,"is_lifetime","","Returns `true` if the token is a lifetime.",185],[10,"is_mutability","","Returns `true` if the token is either the `mut` or `const` keyword.",185],[10,"to_binop","","Maps a token to its corresponding binary operator.",185],[10,"is_keyword","","Returns `true` if the token is a given keyword, `kw`.",185],[10,"is_any_keyword","","Returns `true` if the token is either a special identifier, or a strict\nor reserved keyword.",185],[10,"is_strict_keyword","","Returns `true` if the token may not appear as an identifier.",185],[10,"is_reserved_keyword","","Returns `true` if the token is a keyword that has been reserved for\npossible future use.",185],[10,"mtwt_eq","","Hygienic identifier equality comparison.",185],[10,"hash","","",186],[10,"eq","","",186],[10,"ne","","",186],[10,"decode","","",186],[10,"encode","","",186],[10,"clone","","",186],[10,"fmt","","",186],[10,"cmp","","",188],[10,"partial_cmp","","",188],[10,"lt","","",188],[10,"le","","",188],[10,"gt","","",188],[10,"ge","","",188],[10,"hash","","",188],[10,"eq","","",188],[10,"ne","","",188],[10,"clone","","",188],[10,"new","","",188],[10,"get","","",188],[10,"deref","","",188],[10,"container_as_bytes","","",188],[10,"fmt","","",188],[10,"equiv","","",188],[10,"eq","","",188],[10,"ne","","",188],[10,"decode","","",188],[10,"encode","","",188],[0,"attr","syntax::parse",""],[6,"ParserAttr","syntax::parse::attr","A parser that can parse attributes."],[9,"parse_outer_attributes","","",189],[9,"parse_attribute","","",189],[9,"parse_inner_attrs_and_next","","",189],[9,"parse_meta_item","","",189],[9,"parse_meta_seq","","",189],[9,"parse_optional_meta","","",189],[10,"parse_outer_attributes","syntax::parse::parser","Parse attributes that appear before an item",176],[10,"parse_attribute","","Matches `attribute = # ! [ meta_item ]`",176],[10,"parse_inner_attrs_and_next","","Parse attributes that appear after the opening of an item. These should\nbe preceded by an exclamation mark, but we accept and warn about one\nterminated by a semicolon. In addition to a vector of inner attributes,\nthis function also returns a vector that may contain the first outer\nattribute of the next item (since we can't know whether the attribute\nis an inner attribute of the containing item or an outer attribute of\nthe first contained item until we see the semi).\nmatches inner_attrs* outer_attr?\nyou can make the 'next' field an Option, but the result is going to be\nmore useful as a vector.",176],[10,"parse_meta_item","","matches meta_item = IDENT\n| IDENT = lit\n| IDENT meta_seq",176],[10,"parse_meta_seq","","matches meta_seq = ( COMMASEP(meta_item) )",176],[10,"parse_optional_meta","","",176],[0,"common","syntax::parse","Common routines shared by parser mods"],[1,"SeqSep","syntax::parse::common","SeqSep : a sequence separator (token)\nand whether a trailing separator is allowed."],[11,"sep","","",190],[11,"trailing_sep_allowed","","",190],[3,"seq_sep_trailing_allowed","",""],[3,"seq_sep_none","",""],[0,"classify","syntax::parse","Routines the parser uses to classify AST nodes"],[3,"expr_requires_semi_to_be_stmt","syntax::parse::classify","Does this expression require a semicolon to be treated\nas a statement? The negation of this: 'can this expression\nbe used as a statement without a semicolon' -- is used\nas an early-bail-out in the parser so that, for instance,\n    if true {...} else {...}\n     |x| 5\nisn't parsed as (if true {...} else {...} | x) | 5"],[3,"expr_is_simple_block","",""],[3,"stmt_ends_with_semi","","this statement requires a semicolon after it.\nnote that in one case (stmt_semi), we've already\nseen the semicolon, and thus don't need another."],[0,"obsolete","syntax::parse","Support for parsing unsupported, old syntaxes, for the purpose of reporting errors. Parsing of\nthese syntaxes is tested by compile-test/obsolete-syntax.rs."],[2,"ObsoleteSyntax","syntax::parse::obsolete","The specific types of unsupported syntax"],[12,"ObsoleteOwnedType","","",191],[12,"ObsoleteOwnedExpr","","",191],[12,"ObsoleteOwnedPattern","","",191],[12,"ObsoleteOwnedVector","","",191],[12,"ObsoleteOwnedSelf","","",191],[12,"ObsoleteImportRenaming","","",191],[12,"ObsoleteSubsliceMatch","","",191],[12,"ObsoleteExternCrateRenaming","","",191],[12,"ObsoleteProcType","","",191],[12,"ObsoleteProcExpr","","",191],[6,"ParserObsoleteMethods","",""],[9,"obsolete","","Reports an obsolete syntax non-fatal error.",192],[9,"obsolete_expr","","Reports an obsolete syntax non-fatal error, and returns\na placeholder expression",192],[9,"report","","",192],[9,"is_obsolete_ident","","",192],[9,"eat_obsolete_ident","","",192],[10,"hash","","",191],[10,"eq","","",191],[10,"ne","","",191],[10,"obsolete","syntax::parse::parser","Reports an obsolete syntax non-fatal error.",176],[10,"obsolete_expr","","Reports an obsolete syntax non-fatal error, and returns\na placeholder expression",176],[10,"report","","",176],[10,"is_obsolete_ident","","",176],[10,"eat_obsolete_ident","","",176],[0,"with_hygiene","syntax::parse",""],[3,"parse_tts_from_source_str","syntax::parse::with_hygiene",""],[10,"next_node_id","syntax::parse","",169],[10,"reserve_node_ids","","",169],[0,"ptr","syntax","The AST pointer"],[1,"P","syntax::ptr","An owned smart pointer."],[3,"P","","Construct a `P<T>` from a `T` value."],[10,"and_then","","Move out of the pointer.\nIntended for chaining transformations not covered by `map`.",193],[10,"map","","Transform the inner value, consuming `self` and producing a new `P<T>`.",193],[10,"deref","","",193],[10,"clone","","",193],[10,"eq","","",193],[10,"fmt","","",193],[10,"hash","","",193],[10,"decode","","",193],[10,"encode","","",193],[0,"show_span","syntax","Span debugger"],[3,"run","syntax::show_span",""],[0,"std_inject","syntax",""],[3,"maybe_inject_crates_ref","syntax::std_inject",""],[3,"maybe_inject_prelude","",""],[0,"test","syntax",""],[3,"modify_for_testing","syntax::test",""],[0,"visit","syntax","AST walker. Each overridden visit method has full control over what\nhappens with its node, it can do its own traversal of the node's children,\ncall `visit::walk_*` to apply the default traversal algorithm, or prevent\ndeeper traversal by doing nothing."],[2,"FnKind","syntax::visit",""],[12,"FkItemFn","","fn foo() or extern \"Abi\" fn foo()",194],[12,"FkMethod","","fn foo(&self)",194],[12,"FkFnBlock","","|x, y| ...\nproc(x, y) ...",194],[3,"walk_inlined_item","",""],[3,"walk_crate","",""],[3,"walk_mod","",""],[3,"walk_view_item","",""],[3,"walk_local","",""],[3,"walk_lifetime_def","",""],[3,"walk_lifetime_bound","",""],[3,"walk_lifetime_ref","",""],[3,"walk_explicit_self","",""],[3,"walk_poly_trait_ref","","Like with walk_method_helper this doesn't correspond to a method\nin Visitor, and so it gets a _helper suffix."],[3,"walk_trait_ref","","Like with walk_method_helper this doesn't correspond to a method\nin Visitor, and so it gets a _helper suffix."],[3,"walk_item","",""],[3,"walk_enum_def","",""],[3,"walk_variant","",""],[3,"skip_ty","",""],[3,"walk_ty","",""],[3,"walk_lifetime_decls_helper","",""],[3,"walk_path","",""],[3,"walk_path_segment","",""],[3,"walk_path_parameters","",""],[3,"walk_assoc_type_binding","",""],[3,"walk_pat","",""],[3,"walk_foreign_item","",""],[3,"walk_ty_param_bounds_helper","",""],[3,"walk_ty_param_bound","",""],[3,"walk_ty_param","",""],[3,"walk_generics","",""],[3,"walk_fn_ret_ty","",""],[3,"walk_fn_decl","",""],[3,"walk_method_helper","",""],[3,"walk_fn","",""],[3,"walk_ty_method","",""],[3,"walk_trait_item","",""],[3,"walk_struct_def","",""],[3,"walk_struct_field","",""],[3,"walk_block","",""],[3,"walk_stmt","",""],[3,"walk_decl","",""],[3,"walk_expr_opt","",""],[3,"walk_exprs","",""],[3,"walk_mac","",""],[3,"walk_expr","",""],[3,"walk_arm","",""],[6,"Visitor","","Each method of the Visitor trait is a hook to be potentially\noverridden.  Each method's default implementation recursively visits\nthe substructure of the input via the corresponding `walk` method;\ne.g. the `visit_mod` method by default calls `visit::walk_mod`."],[10,"visit_name","","",195],[10,"visit_ident","","",195],[10,"visit_mod","","",195],[10,"visit_view_item","","",195],[10,"visit_foreign_item","","",195],[10,"visit_item","","",195],[10,"visit_local","","",195],[10,"visit_block","","",195],[10,"visit_stmt","","",195],[10,"visit_arm","","",195],[10,"visit_pat","","",195],[10,"visit_decl","","",195],[10,"visit_expr","","",195],[10,"visit_expr_post","","",195],[10,"visit_ty","","",195],[10,"visit_generics","","",195],[10,"visit_fn","","",195],[10,"visit_ty_method","","",195],[10,"visit_trait_item","","",195],[10,"visit_trait_ref","","",195],[10,"visit_ty_param_bound","","",195],[10,"visit_poly_trait_ref","","",195],[10,"visit_struct_def","","",195],[10,"visit_struct_field","","",195],[10,"visit_variant","","",195],[10,"visit_opt_lifetime_ref","","Visits an optional reference to a lifetime. The `span` is the span of some surrounding\nreference should opt_lifetime be None.",195],[10,"visit_lifetime_bound","","",195],[10,"visit_lifetime_ref","","",195],[10,"visit_lifetime_def","","",195],[10,"visit_explicit_self","","",195],[10,"visit_mac","","",195],[10,"visit_path","","",195],[10,"visit_path_segment","","",195],[10,"visit_path_parameters","","",195],[10,"visit_assoc_type_binding","","",195],[10,"visit_attribute","","",195],[0,"print","syntax",""],[0,"pp","syntax::print","This pretty-printer is a direct reimplementation of Philip Karlton's\nMesa pretty-printer, as described in appendix A of"],[1,"BreakToken","syntax::print::pp",""],[1,"BeginToken","",""],[1,"PrintStackElem","",""],[1,"Printer","","In case you do not have the paper, here is an explanation of what's going\non."],[11,"out","","",196],[2,"Breaks","",""],[12,"Consistent","","",197],[12,"Inconsistent","","",197],[2,"Token","",""],[12,"String","","",198],[12,"Break","","",198],[12,"Begin","","",198],[12,"End","","",198],[12,"Eof","","",198],[2,"PrintStackBreak","",""],[12,"Fits","","",199],[12,"Broken","","",199],[3,"tok_str","",""],[3,"buf_str","",""],[3,"mk_printer","",""],[3,"rbox","",""],[3,"ibox","",""],[3,"cbox","",""],[3,"break_offset","",""],[3,"end","",""],[3,"eof","",""],[3,"word","",""],[3,"huge_word","",""],[3,"zero_word","",""],[3,"spaces","",""],[3,"zerobreak","",""],[3,"space","",""],[3,"hardbreak","",""],[3,"hardbreak_tok_offset","",""],[3,"hardbreak_tok","",""],[10,"eq","","",197],[10,"ne","","",197],[10,"clone","","",197],[10,"clone","","",200],[10,"clone","","",201],[10,"clone","","",198],[10,"is_eof","","",198],[10,"is_hardbreak_tok","","",198],[10,"last_token","","",196],[10,"replace_last_token","","",196],[10,"pretty_print","","",196],[10,"check_stream","","",196],[10,"scan_push","","",196],[10,"scan_pop","","",196],[10,"scan_top","","",196],[10,"scan_pop_bottom","","",196],[10,"advance_right","","",196],[10,"advance_left","","",196],[10,"check_stack","","",196],[10,"print_newline","","",196],[10,"indent","","",196],[10,"get_top","","",196],[10,"print_str","","",196],[10,"print","","",196],[0,"pprust","syntax::print",""],[1,"NoAnn","syntax::print::pprust",""],[1,"CurrentCommentAndLiteral","",""],[1,"State","",""],[11,"s","","",202],[2,"AnnNode","",""],[12,"NodeIdent","","",203],[12,"NodeName","","",203],[12,"NodeBlock","","",203],[12,"NodeItem","","",203],[12,"NodeExpr","","",203],[12,"NodePat","","",203],[3,"rust_printer","",""],[3,"rust_printer_annotated","",""],[3,"print_crate","","Requires you to pass an input filename and reader so that\nit can scan the input text for comments and literals to\ncopy forward."],[3,"to_string","",""],[3,"binop_to_string","",""],[3,"token_to_string","",""],[3,"ty_to_string","",""],[3,"bounds_to_string","",""],[3,"pat_to_string","",""],[3,"arm_to_string","",""],[3,"expr_to_string","",""],[3,"lifetime_to_string","",""],[3,"tt_to_string","",""],[3,"tts_to_string","",""],[3,"stmt_to_string","",""],[3,"item_to_string","",""],[3,"view_item_to_string","",""],[3,"generics_to_string","",""],[3,"ty_method_to_string","",""],[3,"method_to_string","",""],[3,"fn_block_to_string","",""],[3,"path_to_string","",""],[3,"ident_to_string","",""],[3,"fun_to_string","",""],[3,"block_to_string","",""],[3,"meta_item_to_string","",""],[3,"attribute_to_string","",""],[3,"lit_to_string","",""],[3,"explicit_self_to_string","",""],[3,"variant_to_string","",""],[3,"arg_to_string","",""],[3,"mac_to_string","",""],[3,"visibility_qualified","",""],[0,"with_hygiene","",""],[3,"to_string_hyg","syntax::print::pprust::with_hygiene",""],[3,"ty_to_string","",""],[3,"bounds_to_string","",""],[3,"pat_to_string","",""],[3,"arm_to_string","",""],[3,"expr_to_string","",""],[3,"lifetime_to_string","",""],[3,"tt_to_string","",""],[3,"tts_to_string","",""],[3,"stmt_to_string","",""],[3,"item_to_string","",""],[3,"view_item_to_string","",""],[3,"generics_to_string","",""],[3,"ty_method_to_string","",""],[3,"method_to_string","",""],[3,"fn_block_to_string","",""],[3,"path_to_string","",""],[3,"ident_to_string","",""],[3,"fun_to_string","",""],[3,"block_to_string","",""],[3,"meta_item_to_string","",""],[3,"attribute_to_string","",""],[3,"lit_to_string","",""],[3,"explicit_self_to_string","",""],[3,"variant_to_string","",""],[3,"arg_to_string","",""],[3,"mac_to_string","",""],[18,"indent_unit","syntax::print::pprust",""],[18,"default_columns","",""],[6,"PpAnn","",""],[10,"pre","","",204],[10,"post","","",204],[10,"new_from_input","","",202],[10,"new","","",202],[10,"ibox","","",202],[10,"end","","",202],[10,"cbox","","",202],[10,"rbox","","",202],[10,"nbsp","","",202],[10,"word_nbsp","","",202],[10,"word_space","","",202],[10,"popen","","",202],[10,"pclose","","",202],[10,"head","","",202],[10,"bopen","","",202],[10,"bclose_","","",202],[10,"bclose_maybe_open","","",202],[10,"bclose","","",202],[10,"is_begin","","",202],[10,"is_end","","",202],[10,"is_bol","","",202],[10,"in_cbox","","",202],[10,"hardbreak_if_not_bol","","",202],[10,"space_if_not_bol","","",202],[10,"break_offset_if_not_bol","","",202],[10,"synth_comment","","",202],[10,"commasep","","",202],[10,"commasep_cmnt","","",202],[10,"commasep_exprs","","",202],[10,"print_mod","","",202],[10,"print_foreign_mod","","",202],[10,"print_opt_lifetime","","",202],[10,"print_type","","",202],[10,"print_foreign_item","","",202],[10,"print_item","","Pretty-print an item",202],[10,"print_enum_def","","",202],[10,"print_variants","","",202],[10,"print_visibility","","",202],[10,"print_struct","","",202],[10,"print_tt","","This doesn't deserve to be called \"pretty\" printing, but it should be\nmeaning-preserving. A quick hack that might help would be to look at the\nspans embedded in the TTs to decide where to put spaces and newlines.\nBut it'd be better to parse these according to the grammar of the\nappropriate macro, transcribe back into the grammar we just parsed from,\nand then pretty-print the resulting AST nodes (so, e.g., we print\nexpression arguments as expressions). It can be done! I think.",202],[10,"print_tts","","",202],[10,"print_variant","","",202],[10,"print_ty_method","","",202],[10,"print_trait_method","","",202],[10,"print_impl_item","","",202],[10,"print_method","","",202],[10,"print_outer_attributes","","",202],[10,"print_inner_attributes","","",202],[10,"print_attribute","","",202],[10,"print_stmt","","",202],[10,"print_block","","",202],[10,"print_block_unclosed","","",202],[10,"print_block_unclosed_indent","","",202],[10,"print_block_with_attrs","","",202],[10,"print_block_maybe_unclosed","","",202],[10,"print_if","","",202],[10,"print_if_let","","",202],[10,"print_mac","","",202],[10,"print_expr_maybe_paren","","",202],[10,"print_expr","","",202],[10,"print_local_decl","","",202],[10,"print_decl","","",202],[10,"print_ident","","",202],[10,"print_uint","","",202],[10,"print_name","","",202],[10,"print_for_decl","","",202],[10,"print_pat","","",202],[10,"print_fn","","",202],[10,"print_fn_args","","",202],[10,"print_fn_args_and_ret","","",202],[10,"print_fn_block_args","","",202],[10,"print_capture_clause","","",202],[10,"print_proc_args","","",202],[10,"print_bounds","","",202],[10,"print_lifetime","","",202],[10,"print_lifetime_def","","",202],[10,"print_generics","","",202],[10,"print_ty_param","","",202],[10,"print_where_clause","","",202],[10,"print_meta_item","","",202],[10,"print_view_path","","",202],[10,"print_view_item","","",202],[10,"print_mutability","","",202],[10,"print_mt","","",202],[10,"print_arg","","",202],[10,"print_fn_output","","",202],[10,"print_ty_fn","","",202],[10,"maybe_print_trailing_comment","","",202],[10,"print_remaining_comments","","",202],[10,"print_literal","","",202],[10,"next_lit","","",202],[10,"maybe_print_comment","","",202],[10,"print_comment","","",202],[10,"print_string","","",202],[10,"next_comment","","",202],[10,"print_opt_unsafety","","",202],[10,"print_opt_abi_and_extern_if_nondefault","","",202],[10,"print_extern_opt_abi","","",202],[10,"print_fn_header_info","","",202],[10,"print_unsafety","","",202],[0,"ext","syntax",""],[0,"asm","syntax::ext",""],[3,"expand_asm","syntax::ext::asm",""],[0,"base","syntax::ext",""],[1,"MacroDef","syntax::ext::base",""],[11,"name","","",205],[11,"ext","","",205],[1,"MacExpr","","A convenience type for macros that return a single expression."],[1,"MacPat","","A convenience type for macros that return a single pattern."],[1,"MacItems","","A type for macros that return multiple items."],[1,"DummyResult","","Fill-in macro expansion result, to allow compilation to continue\nafter hitting errors."],[1,"BlockInfo","",""],[11,"macros_escape","","Should macros escape from this scope?",206],[11,"pending_renames","","What are the pending renames?",206],[1,"ExtCtxt","","One of these is made during expansion and incrementally updated as we go;\nwhen a macro expansion occurs, the resulting nodes have the backtrace()\n-> expn_info of their expansion context stored into their span."],[11,"parse_sess","","",207],[11,"cfg","","",207],[11,"backtrace","","",207],[11,"ecfg","","",207],[11,"mod_path","","",207],[11,"trace_mac","","",207],[11,"exported_macros","","",207],[11,"syntax_env","","",207],[11,"recursion_count","","",207],[1,"SyntaxEnv","","In order to have some notion of scoping for macros,\nwe want to implement the notion of a transformation\nenvironment."],[2,"SyntaxExtension","","An enum representing the different kinds of syntax extensions."],[12,"Decorator","","A syntax extension that is attached to an item and creates new items\nbased upon it.",208],[12,"Modifier","","A syntax extension that is attached to an item and modifies it\nin-place.",208],[12,"NormalTT","","A normal, function-like syntax extension.",208],[12,"IdentTT","","A function-like syntax extension that has an extra ident before\nthe block.\n",208],[12,"LetSyntaxTT","","An ident macro that has two properties:\n- it adds a macro definition to the environment, and\n- the definition it adds doesn't introduce any new\n  identifiers.",208],[3,"expr_to_string","","Extract a string literal from the macro expanded version of `expr`,\nemitting `err_msg` if `expr` is not a string literal. This does not stop\ncompilation on error, merely emits a non-fatal error and returns None."],[3,"check_zero_tts","","Non-fatally assert that `tts` is empty. Note that this function\nreturns even when `tts` is non-empty, macros that *need* to stop\ncompilation should call\n`cx.parse_sess.span_diagnostic.abort_if_errors()` (this should be\ndone as rarely as possible)."],[3,"get_single_str_from_tts","","Extract the string literal from the first token of `tts`. If this\nis not a string literal, emit an error and return None."],[3,"get_exprs_from_tts","","Extract comma-separated expressions from `tts`. If there is a\nparsing error, emit a non-fatal error and return None."],[4,"MacroExpanderFn","",""],[4,"IdentMacroExpanderFn","",""],[4,"NamedSyntaxExtension","",""],[6,"ItemDecorator","",""],[9,"expand","","",209],[6,"ItemModifier","",""],[9,"expand","","",210],[6,"TTMacroExpander","","Represents a thing that maps token trees to Macro Results"],[9,"expand","","",211],[6,"IdentMacroExpander","",""],[9,"expand","","",212],[6,"MacResult","","The result of a macro expansion. The return values of the various\nmethods are spliced into the AST at the callsite of the macro (or\njust into the compiler's internal macro table, for `make_def`)."],[10,"make_def","","Attempt to define a new macro.",213],[10,"make_expr","","Create an expression.",213],[10,"make_items","","Create zero or more items.",213],[10,"make_methods","","Create zero or more methods.",213],[10,"make_pat","","Create a pattern.",213],[10,"make_stmt","","Create a statement.",213],[10,"new","","",214],[10,"make_expr","","",214],[10,"make_pat","","",214],[10,"new","","",215],[10,"make_pat","","",215],[10,"new","","",216],[10,"make_items","","",216],[10,"any","","Create a default MacResult that can be anything.",217],[10,"expr","","Create a default MacResult that can only be an expression.",217],[10,"raw_expr","","A plain dummy expression.",217],[10,"raw_pat","","A plain dummy pattern.",217],[10,"make_expr","","",217],[10,"make_pat","","",217],[10,"make_items","","",217],[10,"make_methods","","",217],[10,"make_stmt","","",217],[10,"new","","",206],[10,"new","","",207],[10,"expand_expr","","",207],[10,"expander","","Returns a `Folder` for deeply expanding all macros in a AST node.",207],[10,"new_parser_from_tts","","",207],[10,"codemap","","",207],[10,"parse_sess","","",207],[10,"cfg","","",207],[10,"call_site","","",207],[10,"print_backtrace","","",207],[10,"backtrace","","",207],[10,"original_span","","",207],[10,"original_span_in_file","","",207],[10,"mod_push","","",207],[10,"mod_pop","","",207],[10,"mod_path","","",207],[10,"bt_push","","",207],[10,"bt_pop","","",207],[10,"span_fatal","","Emit `msg` attached to `sp`, and stop compilation immediately.",207],[10,"span_err","","Emit `msg` attached to `sp`, without immediately stopping\ncompilation.",207],[10,"span_warn","","",207],[10,"span_unimpl","","",207],[10,"span_bug","","",207],[10,"span_note","","",207],[10,"span_help","","",207],[10,"bug","","",207],[10,"trace_macros","","",207],[10,"set_trace_macros","","",207],[10,"ident_of","","",207],[10,"name_of","","",207],[10,"push_frame","","",218],[10,"pop_frame","","",218],[10,"find","","",218],[10,"insert","","",218],[10,"info","","",218],[0,"build","syntax::ext",""],[6,"AstBuilder","syntax::ext::build",""],[9,"path","","",219],[9,"path_ident","","",219],[9,"path_global","","",219],[9,"path_all","","",219],[9,"ty_mt","","",219],[9,"ty","","",219],[9,"ty_path","","",219],[9,"ty_sum","","",219],[9,"ty_ident","","",219],[9,"ty_rptr","","",219],[9,"ty_ptr","","",219],[9,"ty_option","","",219],[9,"ty_infer","","",219],[9,"ty_vars","","",219],[9,"ty_vars_global","","",219],[9,"ty_field_imm","","",219],[9,"typaram","","",219],[9,"trait_ref","","",219],[9,"poly_trait_ref","","",219],[9,"typarambound","","",219],[9,"lifetime","","",219],[9,"lifetime_def","","",219],[9,"stmt_expr","","",219],[9,"stmt_let","","",219],[9,"stmt_let_typed","","",219],[9,"stmt_item","","",219],[9,"block","","",219],[9,"block_expr","","",219],[9,"block_all","","",219],[9,"expr","","",219],[9,"expr_path","","",219],[9,"expr_ident","","",219],[9,"expr_self","","",219],[9,"expr_binary","","",219],[9,"expr_deref","","",219],[9,"expr_unary","","",219],[9,"expr_addr_of","","",219],[9,"expr_mut_addr_of","","",219],[9,"expr_field_access","","",219],[9,"expr_tup_field_access","","",219],[9,"expr_call","","",219],[9,"expr_call_ident","","",219],[9,"expr_call_global","","",219],[9,"expr_method_call","","",219],[9,"expr_block","","",219],[9,"expr_cast","","",219],[9,"field_imm","","",219],[9,"expr_struct","","",219],[9,"expr_struct_ident","","",219],[9,"expr_lit","","",219],[9,"expr_uint","","",219],[9,"expr_int","","",219],[9,"expr_u8","","",219],[9,"expr_bool","","",219],[9,"expr_vec","","",219],[9,"expr_vec_ng","","",219],[9,"expr_vec_slice","","",219],[9,"expr_str","","",219],[9,"expr_some","","",219],[9,"expr_none","","",219],[9,"expr_break","","",219],[9,"expr_tuple","","",219],[9,"expr_fail","","",219],[9,"expr_unreachable","","",219],[9,"expr_ok","","",219],[9,"expr_err","","",219],[9,"expr_try","","",219],[9,"pat","","",219],[9,"pat_wild","","",219],[9,"pat_lit","","",219],[9,"pat_ident","","",219],[9,"pat_ident_binding_mode","","",219],[9,"pat_enum","","",219],[9,"pat_struct","","",219],[9,"pat_tuple","","",219],[9,"pat_some","","",219],[9,"pat_none","","",219],[9,"pat_ok","","",219],[9,"pat_err","","",219],[9,"arm","","",219],[9,"arm_unreachable","","",219],[9,"expr_match","","",219],[9,"expr_if","","",219],[9,"expr_loop","","",219],[9,"lambda_fn_decl","","",219],[9,"lambda","","",219],[9,"lambda0","","",219],[9,"lambda1","","",219],[9,"lambda_expr","","",219],[9,"lambda_expr_0","","",219],[9,"lambda_expr_1","","",219],[9,"lambda_stmts","","",219],[9,"lambda_stmts_0","","",219],[9,"lambda_stmts_1","","",219],[9,"item","","",219],[9,"arg","","",219],[9,"fn_decl","","",219],[9,"item_fn_poly","","",219],[9,"item_fn","","",219],[9,"variant","","",219],[9,"item_enum_poly","","",219],[9,"item_enum","","",219],[9,"item_struct_poly","","",219],[9,"item_struct","","",219],[9,"item_mod","","",219],[9,"item_static","","",219],[9,"item_const","","",219],[9,"item_ty_poly","","",219],[9,"item_ty","","",219],[9,"attribute","","",219],[9,"meta_word","","",219],[9,"meta_list","","",219],[9,"meta_name_value","","",219],[9,"view_use","","",219],[9,"view_use_simple","","",219],[9,"view_use_simple_","","",219],[9,"view_use_list","","",219],[9,"view_use_glob","","",219],[10,"path","syntax::ext::base","",207],[10,"path_ident","","",207],[10,"path_global","","",207],[10,"path_all","","",207],[10,"ty_mt","","",207],[10,"ty","","",207],[10,"ty_path","","",207],[10,"ty_sum","","",207],[10,"ty_ident","","",207],[10,"ty_rptr","","",207],[10,"ty_ptr","","",207],[10,"ty_option","","",207],[10,"ty_field_imm","","",207],[10,"ty_infer","","",207],[10,"typaram","","",207],[10,"ty_vars","","",207],[10,"ty_vars_global","","",207],[10,"trait_ref","","",207],[10,"poly_trait_ref","","",207],[10,"typarambound","","",207],[10,"lifetime","","",207],[10,"lifetime_def","","",207],[10,"stmt_expr","","",207],[10,"stmt_let","","",207],[10,"stmt_let_typed","","",207],[10,"block","","",207],[10,"stmt_item","","",207],[10,"block_expr","","",207],[10,"block_all","","",207],[10,"expr","","",207],[10,"expr_path","","",207],[10,"expr_ident","","",207],[10,"expr_self","","",207],[10,"expr_binary","","",207],[10,"expr_deref","","",207],[10,"expr_unary","","",207],[10,"expr_field_access","","",207],[10,"expr_tup_field_access","","",207],[10,"expr_addr_of","","",207],[10,"expr_mut_addr_of","","",207],[10,"expr_call","","",207],[10,"expr_call_ident","","",207],[10,"expr_call_global","","",207],[10,"expr_method_call","","",207],[10,"expr_block","","",207],[10,"field_imm","","",207],[10,"expr_struct","","",207],[10,"expr_struct_ident","","",207],[10,"expr_lit","","",207],[10,"expr_uint","","",207],[10,"expr_int","","",207],[10,"expr_u8","","",207],[10,"expr_bool","","",207],[10,"expr_vec","","",207],[10,"expr_vec_ng","","",207],[10,"expr_vec_slice","","",207],[10,"expr_str","","",207],[10,"expr_cast","","",207],[10,"expr_some","","",207],[10,"expr_none","","",207],[10,"expr_break","","",207],[10,"expr_tuple","","",207],[10,"expr_fail","","",207],[10,"expr_unreachable","","",207],[10,"expr_ok","","",207],[10,"expr_err","","",207],[10,"expr_try","","",207],[10,"pat","","",207],[10,"pat_wild","","",207],[10,"pat_lit","","",207],[10,"pat_ident","","",207],[10,"pat_ident_binding_mode","","",207],[10,"pat_enum","","",207],[10,"pat_struct","","",207],[10,"pat_tuple","","",207],[10,"pat_some","","",207],[10,"pat_none","","",207],[10,"pat_ok","","",207],[10,"pat_err","","",207],[10,"arm","","",207],[10,"arm_unreachable","","",207],[10,"expr_match","","",207],[10,"expr_if","","",207],[10,"expr_loop","","",207],[10,"lambda_fn_decl","","",207],[10,"lambda","","",207],[10,"lambda0","","",207],[10,"lambda1","","",207],[10,"lambda_expr","","",207],[10,"lambda_expr_0","","",207],[10,"lambda_expr_1","","",207],[10,"lambda_stmts","","",207],[10,"lambda_stmts_0","","",207],[10,"lambda_stmts_1","","",207],[10,"arg","","",207],[10,"fn_decl","","",207],[10,"item","","",207],[10,"item_fn_poly","","",207],[10,"item_fn","","",207],[10,"variant","","",207],[10,"item_enum_poly","","",207],[10,"item_enum","","",207],[10,"item_struct","","",207],[10,"item_struct_poly","","",207],[10,"item_mod","","",207],[10,"item_static","","",207],[10,"item_const","","",207],[10,"item_ty_poly","","",207],[10,"item_ty","","",207],[10,"attribute","","",207],[10,"meta_word","","",207],[10,"meta_list","","",207],[10,"meta_name_value","","",207],[10,"view_use","","",207],[10,"view_use_simple","","",207],[10,"view_use_simple_","","",207],[10,"view_use_list","","",207],[10,"view_use_glob","","",207],[0,"bytes","syntax::ext",""],[3,"expand_syntax_ext","syntax::ext::bytes",""],[0,"cfg","syntax::ext",""],[3,"expand_cfg","syntax::ext::cfg",""],[0,"cfg_attr","syntax::ext",""],[3,"expand","syntax::ext::cfg_attr",""],[0,"concat","syntax::ext",""],[3,"expand_syntax_ext","syntax::ext::concat",""],[0,"concat_idents","syntax::ext",""],[3,"expand_syntax_ext","syntax::ext::concat_idents",""],[0,"deriving","syntax::ext","The compiler code necessary to implement the `#[deriving]` extensions."],[3,"expand_meta_deriving","syntax::ext::deriving",""],[0,"bounds","",""],[3,"expand_deriving_bound","syntax::ext::deriving::bounds",""],[0,"clone","syntax::ext::deriving",""],[3,"expand_deriving_clone","syntax::ext::deriving::clone",""],[0,"encodable","syntax::ext::deriving","The compiler code necessary to implement the `#[deriving(Encodable)]`\n(and `Decodable`, in decodable.rs) extension.  The idea here is that\ntype-defining items may be tagged with `#[deriving(Encodable, Decodable)]`."],[3,"expand_deriving_rustc_encodable","syntax::ext::deriving::encodable",""],[3,"expand_deriving_encodable","",""],[0,"decodable","syntax::ext::deriving","The compiler code necessary for `#[deriving(Decodable)]`. See encodable.rs for more."],[3,"expand_deriving_rustc_decodable","syntax::ext::deriving::decodable",""],[3,"expand_deriving_decodable","",""],[0,"hash","syntax::ext::deriving",""],[3,"expand_deriving_hash","syntax::ext::deriving::hash",""],[0,"rand","syntax::ext::deriving",""],[3,"expand_deriving_rand","syntax::ext::deriving::rand",""],[0,"show","syntax::ext::deriving",""],[3,"expand_deriving_show","syntax::ext::deriving::show",""],[0,"zero","syntax::ext::deriving",""],[3,"expand_deriving_zero","syntax::ext::deriving::zero",""],[0,"default","syntax::ext::deriving",""],[3,"expand_deriving_default","syntax::ext::deriving::default",""],[0,"primitive","syntax::ext::deriving",""],[3,"expand_deriving_from_primitive","syntax::ext::deriving::primitive",""],[0,"eq","syntax::ext::deriving",""],[3,"expand_deriving_eq","syntax::ext::deriving::eq",""],[0,"totaleq","syntax::ext::deriving",""],[3,"expand_deriving_totaleq","syntax::ext::deriving::totaleq",""],[0,"ord","syntax::ext::deriving",""],[2,"OrderingOp","syntax::ext::deriving::ord",""],[12,"PartialCmpOp","","",220],[12,"LtOp","","",220],[12,"LeOp","","",220],[12,"GtOp","","",220],[12,"GeOp","","",220],[3,"expand_deriving_ord","",""],[3,"some_ordering_collapsed","",""],[3,"cs_partial_cmp","",""],[0,"totalord","syntax::ext::deriving",""],[3,"expand_deriving_totalord","syntax::ext::deriving::totalord",""],[3,"ordering_collapsed","",""],[3,"cs_cmp","",""],[0,"generic","syntax::ext::deriving","Some code that abstracts away much of the boilerplate of writing\n`deriving` instances for traits. Among other things it manages getting\naccess to the fields of the 4 different sorts of structs and enum\nvariants, as well as creating the method and impl ast instances."],[1,"TraitDef","syntax::ext::deriving::generic",""],[11,"span","","The span for the current #[deriving(Foo)] header.",221],[11,"attributes","","",221],[11,"path","","Path of the trait, including any type parameters",221],[11,"additional_bounds","","Additional bounds required of any type parameters of the type,\nother than the current trait",221],[11,"generics","","Any extra lifetimes and/or bounds, e.g. `D: serialize::Decoder`",221],[11,"methods","","",221],[1,"MethodDef","",""],[11,"name","","name of the method",222],[11,"generics","","List of generics, e.g. `R: rand::Rng`",222],[11,"explicit_self","","Whether there is a self argument (outer Option) i.e. whether\nthis is a static function, and whether it is a pointer (inner\nOption)",222],[11,"args","","Arguments other than the self argument",222],[11,"ret_ty","","Return type",222],[11,"attributes","","",222],[11,"combine_substructure","","",222],[1,"Substructure","","All the data about the data structure/method being derived upon."],[11,"type_ident","","ident of self",223],[11,"method_ident","","ident of the method",223],[11,"self_args","","dereferenced access to any `Self` or `Ptr(Self, _)` arguments",223],[11,"nonself_args","","verbatim access to any other arguments",223],[11,"fields","","",223],[1,"FieldInfo","","Summary of the relevant parts of a struct/enum field."],[11,"span","","",224],[11,"name","","None for tuple structs/normal enum variants, Some for normal\nstructs/struct enum variants.",224],[11,"self_","","The expression corresponding to this field of `self`\n(specifically, a reference to it).",224],[11,"other","","The expressions corresponding to references to this field in\nthe other `Self` arguments.",224],[2,"StaticFields","","Fields for a static method"],[12,"Unnamed","","Tuple structs/enum variants like this.",225],[12,"Named","","Normal structs/struct variants.",225],[2,"SubstructureFields","","A summary of the possible sets of fields."],[12,"Struct","","",226],[12,"EnumMatching","","Matching variants of the enum: variant index, ast::Variant,\nfields: the field name is only non-`None` in the case of a struct\nvariant.",226],[12,"EnumNonMatchingCollapsed","","Non-matching variants of the enum, but with all state hidden from\nthe consequent code.  The first component holds `Ident`s for all of\nthe `Self` arguments; the second component is a slice of all of the\nvariants for the enum itself, and the third component is a list of\n`Ident`s bound to the variant index values for each of the actual\ninput `Self` arguments.",226],[12,"StaticStruct","","A static method where `Self` is a struct.",226],[12,"StaticEnum","","A static method where `Self` is an enum.",226],[3,"combine_substructure","",""],[3,"cs_fold","","Fold the fields. `use_foldl` controls whether this is done\nleft-to-right (`true`) or right-to-left (`false`)."],[3,"cs_same_method","","Call the method that is being derived on all the fields, and then\nprocess the collected results. i.e."],[3,"cs_same_method_fold","","Fold together the results of calling the derived method on all the\nfields. `use_foldl` controls whether this is done left-to-right\n(`true`) or right-to-left (`false`)."],[3,"cs_binop","","Use a given binop to combine the result of calling the derived method\non all the fields."],[3,"cs_or","","cs_binop with binop == or"],[3,"cs_and","","cs_binop with binop == and"],[0,"ty","","A mini version of ast::Ty, which is easier to use, and features an explicit `Self` type to use\nwhen specifying impls to be derived."],[1,"Path","syntax::ext::deriving::generic::ty","A path, e.g. `::std::option::Option::<int>` (global). Has support\nfor type parameters and a lifetime."],[11,"path","","",227],[11,"lifetime","","",227],[11,"params","","",227],[11,"global","","",227],[1,"LifetimeBounds","","Lifetimes and bounds on type parameters"],[11,"lifetimes","","",228],[11,"bounds","","",228],[2,"PtrTy","","The types of pointers"],[12,"Borrowed","","&'lifetime mut",229],[12,"Raw","","*mut",229],[2,"Ty","","A type. Supports pointers, Self, and literals"],[12,"Self","","",230],[12,"Ptr","","&/Box/ Ty",230],[12,"Literal","","mod::mod::Type<[lifetime], [Params...]>, including a plain type\nparameter, and things like `int`",230],[12,"Tuple","","includes unit",230],[3,"borrowed_ptrty","",""],[3,"borrowed","",""],[3,"borrowed_explicit_self","",""],[3,"borrowed_self","",""],[3,"nil_ty","",""],[3,"get_explicit_self","",""],[10,"clone","","",229],[10,"clone","","",227],[10,"new","","",227],[10,"new_local","","",227],[10,"new_","","",227],[10,"to_ty","","",227],[10,"to_path","","",227],[10,"clone","","",230],[10,"to_ty","","",230],[10,"to_path","","",230],[10,"clone","","",228],[10,"empty","","",228],[10,"to_generics","","",228],[4,"CombineSubstructureFunc","syntax::ext::deriving::generic","Combine the values of all the fields together. The last argument is\nall the fields of all the structures."],[4,"EnumNonMatchCollapsedFunc","","Deal with non-matching enum variants.  The tuple is a list of\nidentifiers (one for each `Self` argument, which could be any of the\nvariants since they have been collapsed together) and the identifiers\nholding the variant index value for each of the `Self` arguments.  The\nlast argument is all the non-`Self` args of the method being derived."],[10,"expand","","",221],[0,"env","syntax::ext",""],[3,"expand_option_env","syntax::ext::env",""],[3,"expand_env","",""],[0,"expand","syntax::ext",""],[1,"IdentRenamer","syntax::ext::expand","A tree-folder that applies every rename in its (mutable) list\nto every identifier, including both bindings and varrefs\n(and lots of things that will turn out to be neither)"],[1,"PatIdentRenamer","","A tree-folder that applies every rename in its list to\nthe idents that are in PatIdent patterns. This is more narrowly\nfocused than IdentRenamer, and is needed for FnDecl,\nwhere we want to rename the args but not the fn name or the generics etc."],[1,"MacroExpander","","A tree-folder that performs macro expansion"],[11,"cx","","",231],[1,"ExpansionConfig","",""],[11,"crate_name","","",232],[11,"deriving_hash_type_parameter","","",232],[11,"enable_quotes","","",232],[11,"recursion_limit","","",232],[1,"ExportedMacros","",""],[11,"crate_name","","",233],[11,"macros","","",233],[3,"expand_type","",""],[3,"expand_expr","",""],[3,"expand_item","",""],[3,"expand_item_mac","",""],[3,"expand_block","",""],[3,"expand_block_elts","",""],[3,"expand_crate","",""],[3,"check_for_macros","","Check that there are no macro invocations left in the AST:"],[10,"fold_ident","","",234],[10,"fold_mac","","",234],[10,"fold_pat","","",235],[10,"fold_mac","","",235],[10,"new","","",231],[10,"fold_expr","","",231],[10,"fold_pat","","",231],[10,"fold_item","","",231],[10,"fold_item_underscore","","",231],[10,"fold_stmt","","",231],[10,"fold_block","","",231],[10,"fold_arm","","",231],[10,"fold_method","","",231],[10,"fold_ty","","",231],[10,"new_span","","",231],[10,"default","","",232],[0,"fmt","syntax::ext",""],[3,"expand_syntax_ext","syntax::ext::fmt",""],[0,"format","syntax::ext",""],[3,"expand_format_args","syntax::ext::format",""],[3,"expand_preparsed_format_args","","Take the various parts of `format_args!(efmt, args..., name=names...)`\nand construct the appropriate formatting expression."],[0,"log_syntax","syntax::ext",""],[3,"expand_syntax_ext","syntax::ext::log_syntax",""],[0,"mtwt","syntax::ext","Machinery for hygienic macros, as described in the MTWT[1] paper."],[1,"SCTable","syntax::ext::mtwt","The SCTable contains a table of SyntaxContext_'s. It\nrepresents a flattened tree structure, to avoid having\nmanaged pointers everywhere (that caused an ICE).\nthe mark_memo and rename_memo fields are side-tables\nthat ensure that adding the same mark to the same context\ngives you back the same context as before. This shouldn't\nchange the semantics--everything here is immutable--but\nit should cut down on memory use *a lot*; applying a mark\nto a tree containing 50 identifiers would otherwise generate\n50 new contexts"],[2,"SyntaxContext_","",""],[12,"EmptyCtxt","","",236],[12,"Mark","","",236],[12,"Rename","","flattening the name and syntaxcontext into the rename...\nHIDDEN INVARIANTS:\n1) the first name in a Rename node\ncan only be a programmer-supplied name.\n2) Every Rename node with a given Name in the\n\"to\" slot must have the same name and context\nin the \"from\" slot. In essence, they're all\npointers to a single \"rename\" event node.",236],[12,"IllegalCtxt","","actually, IllegalCtxt may not be necessary.",236],[3,"apply_mark","","Extend a syntax context with a given mark"],[3,"apply_rename","","Extend a syntax context with a given rename"],[3,"apply_renames","","Apply a list of renamings to a context"],[3,"with_sctable","","Fetch the SCTable from TLS, create one if it doesn't yet exist."],[3,"display_sctable","","Print out an SCTable for debugging"],[3,"clear_tables","","Clear the tables from TLD to reclaim memory."],[3,"reset_tables","","Reset the tables to their initial state"],[3,"resolve","","Resolve a syntax object to a name, per MTWT."],[3,"marksof","","Compute the marks associated with a syntax context."],[3,"outer_mark","","Return the outer mark for a context with a mark at the outside.\nFAILS when outside is not a mark."],[4,"RenameList","","A list of ident->name renamings"],[10,"fmt","","",236],[10,"hash","","",236],[10,"decode","","",236],[10,"encode","","",236],[10,"eq","","",236],[10,"ne","","",236],[0,"quote","syntax::ext",""],[3,"expand_quote_tokens","syntax::ext::quote",""],[3,"expand_quote_expr","",""],[3,"expand_quote_item","",""],[3,"expand_quote_pat","",""],[3,"expand_quote_arm","",""],[3,"expand_quote_ty","",""],[3,"expand_quote_method","",""],[3,"expand_quote_stmt","",""],[0,"rt","","Quasiquoting works via token trees."],[6,"ToTokens","syntax::ext::quote::rt",""],[9,"to_tokens","","",237],[6,"ToSource","",""],[9,"to_source","","",238],[6,"ExtParseUtils","",""],[9,"parse_item","","",239],[9,"parse_expr","","",239],[9,"parse_stmt","","",239],[9,"parse_tts","","",239],[10,"to_tokens","syntax::ast","",82],[10,"to_tokens","collections::vec","",167],[10,"to_tokens","syntax::codemap","",141],[10,"to_tokens","core::option","",240],[10,"to_source","syntax::ast","",10],[10,"to_source","","",41],[10,"to_source","","",25],[10,"to_source","","",45],[10,"to_source","","",19],[10,"to_source","syntax::ptr","",193],[10,"to_source","","",193],[10,"to_source","","",193],[10,"to_source","","",193],[10,"to_source","","",193],[10,"to_source","syntax::ast","",29],[10,"to_source","","",54],[10,"to_tokens","","",10],[10,"to_tokens","syntax::ptr","",193],[10,"to_tokens","","",193],[10,"to_tokens","syntax::ast","",29],[10,"to_tokens","syntax::ptr","",193],[10,"to_tokens","syntax::ast","",41],[10,"to_tokens","","",19],[10,"to_tokens","syntax::ptr","",193],[10,"to_tokens","","",193],[10,"to_tokens","syntax::ast","",25],[10,"to_tokens","","",45],[10,"to_tokens","","",54],[10,"parse_item","syntax::ext::base","",207],[10,"parse_stmt","","",207],[10,"parse_expr","","",207],[10,"parse_tts","","",207],[0,"source_util","syntax::ext",""],[3,"expand_line","syntax::ext::source_util","line!(): expands to the current line number"],[3,"expand_column","",""],[3,"expand_file","","file!(): expands to the current filename */\nThe filemap (`loc.file`) contains a bunch more information we could spit\nout if we wanted."],[3,"expand_stringify","",""],[3,"expand_mod","",""],[3,"expand_include","","include! : parse the given file as an expr\nThis is generally a bad idea because it's going to behave\nunhygienically."],[3,"expand_include_str","",""],[3,"expand_include_bin","",""],[3,"expand_include_bytes","",""],[0,"trace_macros","syntax::ext",""],[3,"expand_trace_macros","syntax::ext::trace_macros",""],[0,"tt","syntax::ext",""],[0,"transcribe","syntax::ext::tt",""],[1,"TtReader","syntax::ext::tt::transcribe",""],[11,"sp_diag","","",241],[11,"cur_tok","","",241],[11,"cur_span","","",241],[11,"desugar_doc_comments","","Transform doc comments. Only useful in macro invocations",241],[3,"new_tt_reader","","This can do Macro-By-Example transcription. On the other hand, if\n`src` contains no `TtSequence`s and `TtNonterminal`s, `interp` can (and\nshould) be none."],[3,"tt_next_token","","Return the next token from the TtReader.\nEFFECT: advances the reader's token field"],[10,"clone","","",241],[0,"macro_parser","syntax::ext::tt","This is an Earley-like parser, without support for in-grammar nonterminals,\nonly by calling out to the main rust parser for named nonterminals (which it\ncommits to fully when it hits one in a grammar). This means that there are no\ncompleter or predictor rules, and therefore no need to store one column per\ntoken: instead, there's a set of current Earley items and a set of next\nones. Instead of NTs, we have a special case for Kleene star. The big-O, in\npathological cases, is worse than traditional Earley parsing, but it's an\neasier fit for Macro-by-Example-style rules, and I think the overhead is\nlower. (In order to prevent the pathological case, we'd need to lazily\nconstruct the resulting `NamedMatch`es at the very end. It'd be a pain,\nand require more memory to keep around old items, but it would also save\noverhead)"],[1,"MatcherPos","syntax::ext::tt::macro_parser",""],[2,"NamedMatch","","NamedMatch is a pattern-match result for a single token::MATCH_NONTERMINAL:\nso it is associated with a single ident in a parse, and all\n`MatchedNonterminal`s in the NamedMatch have the same nonterminal type\n(expr, item, etc). Each leaf in a single NamedMatch corresponds to a\nsingle token::MATCH_NONTERMINAL in the TokenTree that produced it."],[12,"MatchedSeq","","",242],[12,"MatchedNonterminal","","",242],[2,"ParseResult","",""],[12,"Success","","",243],[12,"Failure","","",243],[12,"Error","","",243],[3,"count_names","",""],[3,"initial_matcher_pos","",""],[3,"nameize","",""],[3,"parse_or_else","",""],[3,"token_name_eq","","Perform a token equality check, ignoring syntax context (that is, an\nunhygienic comparison)"],[3,"parse","",""],[3,"parse_nt","",""],[10,"clone","","",244],[0,"macro_rules","syntax::ext::tt",""],[3,"add_new_extension","syntax::ext::tt::macro_rules","This procedure performs the expansion of the\nmacro_rules! macro. It parses the RHS and adds\nan extension to the current context."],[15,"register_diagnostic!","syntax",""],[15,"span_err!","",""],[15,"span_warn!","",""],[15,"span_note!","",""],[15,"span_help!","",""],[15,"register_diagnostics!","",""],[10,"print_node","syntax::print::pprust","",202],[10,"name","syntax::ptr","",193],[10,"value_str","","",193],[10,"meta_item_list","","",193],[10,"move_map","syntax::owned_slice","",168],[10,"is_eof","syntax::ext::tt::transcribe","",241],[10,"next_token","","",241],[10,"fatal","","",241],[10,"err","","",241],[10,"peek","","",241]],"paths":[[1,"Interner"],[1,"RcStr"],[1,"StrInterner"],[1,"SmallVector"],[1,"IntoIter"],[1,"Registry"],[2,"Os"],[2,"Abi"],[2,"Architecture"],[2,"AbiArchitecture"],[1,"Ident"],[1,"Lifetime"],[1,"LifetimeDef"],[1,"Path"],[1,"PathSegment"],[1,"AngleBracketedParameterData"],[1,"ParenthesizedParameterData"],[1,"DefId"],[1,"TyParam"],[1,"Generics"],[1,"WhereClause"],[1,"WhereBoundPredicate"],[1,"WhereRegionPredicate"],[1,"WhereEqPredicate"],[1,"Crate"],[1,"Block"],[1,"Pat"],[1,"FieldPat"],[1,"Local"],[1,"Arm"],[1,"Field"],[1,"Expr"],[1,"QPath"],[1,"Delimited"],[1,"SequenceRepetition"],[1,"MutTy"],[1,"TypeField"],[1,"TypeMethod"],[1,"AssociatedType"],[1,"Typedef"],[1,"TypeBinding"],[1,"Ty"],[1,"ClosureTy"],[1,"BareFnTy"],[1,"InlineAsm"],[1,"Arg"],[1,"FnDecl"],[1,"Method"],[1,"Mod"],[1,"ForeignMod"],[1,"VariantArg"],[1,"EnumDef"],[1,"Variant_"],[1,"ViewItem"],[1,"Attribute_"],[1,"TraitRef"],[1,"PolyTraitRef"],[1,"StructField_"],[1,"StructDef"],[1,"Item"],[1,"ForeignItem"],[2,"PathParameters"],[2,"TyParamBound"],[2,"TraitBoundModifier"],[2,"WherePredicate"],[2,"MetaItem_"],[2,"BindingMode"],[2,"PatWildKind"],[2,"Pat_"],[2,"Mutability"],[2,"BinOp"],[2,"UnOp"],[2,"Stmt_"],[2,"MacStmtStyle"],[2,"LocalSource"],[2,"Decl_"],[2,"BlockCheckMode"],[2,"UnsafeSource"],[2,"Expr_"],[2,"MatchSource"],[2,"CaptureClause"],[2,"KleeneOp"],[2,"TokenTree"],[2,"Mac_"],[2,"StrStyle"],[2,"Sign"],[2,"LitIntType"],[2,"Lit_"],[2,"TraitItem"],[2,"ImplItem"],[2,"IntTy"],[2,"UintTy"],[2,"FloatTy"],[2,"PrimTy"],[2,"Onceness"],[2,"Ty_"],[2,"AsmDialect"],[2,"Unsafety"],[2,"FunctionRetTy"],[2,"ExplicitSelf_"],[2,"Method_"],[2,"VariantKind"],[2,"PathListItem_"],[2,"ViewPath_"],[2,"ViewItem_"],[2,"AttrStyle"],[2,"Visibility"],[2,"StructFieldKind"],[2,"Item_"],[2,"ForeignItem_"],[2,"UnboxedClosureKind"],[2,"InlinedItem"],[1,"Name"],[1,"AttrId"],[2,"PathElem"],[2,"Node"],[1,"FnParts"],[2,"Code"],[6,"MaybeFnLike"],[1,"FnLikeNode"],[6,"FoldOps"],[6,"NodePrinter"],[1,"Values"],[1,"Forest"],[1,"Map"],[1,"NodesMatchingSuffix"],[1,"IdRange"],[1,"IdVisitor"],[6,"IdVisitingOperation"],[6,"EachViewItem"],[6,"PostExpansionMethod"],[1,"Stability"],[2,"InlineAttr"],[2,"StabilityLevel"],[2,"ReprAttr"],[2,"IntType"],[6,"AttrMetaMethods"],[6,"AttributeMethods"],[4,"Attribute"],[4,"MetaItem"],[1,"Span"],[1,"Spanned"],[1,"Loc"],[1,"LocWithOpt"],[1,"FileMapAndLine"],[1,"FileMapAndBytePos"],[1,"NameAndSpan"],[1,"ExpnInfo"],[1,"FileLines"],[1,"MultiByteChar"],[1,"FileMap"],[1,"CodeMap"],[2,"MacroFormat"],[6,"Pos"],[1,"BytePos"],[1,"CharPos"],[1,"ExpnId"],[1,"SpanHandler"],[2,"RenderSpan"],[2,"ColorConfig"],[2,"Level"],[6,"Emitter"],[1,"Handler"],[1,"EmitterWriter"],[1,"Features"],[6,"MoveMap"],[6,"Folder"],[1,"Vec"],[1,"OwnedSlice"],[1,"ParseSess"],[1,"TokenAndSpan"],[1,"StringReader"],[1,"Comment"],[1,"Literal"],[2,"CommentStyle"],[6,"Reader"],[1,"Parser"],[2,"PathParsingMode"],[2,"BoundParsingMode"],[2,"TokenType"],[1,"Restrictions"],[2,"BinOpToken"],[2,"DelimToken"],[2,"IdentStyle"],[2,"Lit"],[2,"Token"],[2,"Nonterminal"],[2,"Keyword"],[1,"InternedString"],[6,"ParserAttr"],[1,"SeqSep"],[2,"ObsoleteSyntax"],[6,"ParserObsoleteMethods"],[1,"P"],[2,"FnKind"],[6,"Visitor"],[1,"Printer"],[2,"Breaks"],[2,"Token"],[2,"PrintStackBreak"],[1,"BreakToken"],[1,"BeginToken"],[1,"State"],[2,"AnnNode"],[6,"PpAnn"],[1,"MacroDef"],[1,"BlockInfo"],[1,"ExtCtxt"],[2,"SyntaxExtension"],[6,"ItemDecorator"],[6,"ItemModifier"],[6,"TTMacroExpander"],[6,"IdentMacroExpander"],[6,"MacResult"],[1,"MacExpr"],[1,"MacPat"],[1,"MacItems"],[1,"DummyResult"],[1,"SyntaxEnv"],[6,"AstBuilder"],[2,"OrderingOp"],[1,"TraitDef"],[1,"MethodDef"],[1,"Substructure"],[1,"FieldInfo"],[2,"StaticFields"],[2,"SubstructureFields"],[1,"Path"],[1,"LifetimeBounds"],[2,"PtrTy"],[2,"Ty"],[1,"MacroExpander"],[1,"ExpansionConfig"],[1,"ExportedMacros"],[1,"IdentRenamer"],[1,"PatIdentRenamer"],[2,"SyntaxContext_"],[6,"ToTokens"],[6,"ToSource"],[6,"ExtParseUtils"],[2,"Option"],[1,"TtReader"],[2,"NamedMatch"],[2,"ParseResult"],[1,"MatcherPos"]]};
searchIndex['rustc_driver'] = {"items":[[0,"","rustc_driver","The Rust compiler."],[3,"run","",""],[3,"release_str","","Returns a version string such as \"0.12.0-dev\"."],[3,"commit_hash_str","","Returns the full SHA1 hash of HEAD of the Git repo from which rustc was built."],[3,"commit_date_str","","Returns the \"commit date\" of HEAD of the Git repo from which rustc was built as a static string."],[3,"version","","Prints version information and returns None on success or an error\nmessage on panic."],[3,"handle_options","","Process command line options. Emits messages as appropriate. If compilation\nshould continue, returns a getopts::Matches object parsed from args, otherwise\nreturns None."],[3,"list_metadata","",""],[3,"monitor","","Run a procedure which will detect panics in the compiler and print nicer\nerror messages rather than just failing the test."],[3,"main","",""],[0,"driver","",""],[3,"compile_input","rustc_driver::driver",""],[3,"anon_src","","The name used for source code that doesn't originate in a file\n(e.g. source from stdin or a string)"],[3,"source_name","",""],[3,"phase_1_parse_input","",""],[3,"phase_2_configure_and_expand","","Run the \"early phases\" of the compiler: initial `cfg` processing,\nloading compiler plugins (including those from `addl_plugins`),\nsyntax expansion, secondary `cfg` expansion, synthesis of a test\nharness if one is to be provided and injection of a dependency on the\nstandard library and prelude."],[3,"assign_node_ids_and_map","",""],[3,"phase_3_run_analysis_passes","","Run the resolution, typechecking, region checking and other\nmiscellaneous analysis passes on the crate. Return various\nstructures carrying the results of the analysis."],[3,"phase_save_analysis","",""],[3,"phase_4_translate_to_llvm","","Run the translation phase to LLVM, after which the AST and analysis can\nbe discarded."],[3,"phase_5_run_llvm_passes","","Run LLVM itself, producing a bitcode file, assembly file or object file\nas a side effect."],[3,"phase_6_link_output","","Run the linker on any artifacts that resulted from the LLVM run.\nThis should produce either a finished executable or library."],[3,"stop_after_phase_3","",""],[3,"stop_after_phase_1","",""],[3,"stop_after_phase_2","",""],[3,"stop_after_phase_5","",""],[3,"collect_crate_types","",""],[3,"collect_crate_metadata","",""],[3,"build_output_filenames","",""],[0,"pretty","rustc_driver","The various pretty print routines."],[2,"PpSourceMode","rustc_driver::pretty",""],[12,"PpmNormal","","",0],[12,"PpmEveryBodyLoops","","",0],[12,"PpmExpanded","","",0],[12,"PpmTyped","","",0],[12,"PpmIdentified","","",0],[12,"PpmExpandedIdentified","","",0],[12,"PpmExpandedHygiene","","",0],[2,"PpMode","",""],[12,"PpmSource","","",1],[12,"PpmFlowGraph","","",1],[2,"UserIdentifiedItem","",""],[12,"ItemViaNode","","",2],[12,"ItemViaPath","","",2],[3,"parse_pretty","",""],[3,"pretty_print_input","",""],[10,"fmt","","",0],[10,"eq","","",0],[10,"ne","","",0],[10,"fmt","","",1],[10,"eq","","",1],[10,"ne","","",1],[10,"fmt","","",2],[10,"clone","","",2],[10,"from_str","","",2],[0,"diagnostic","rustc_driver",""],[10,"new","syntax::util::interner","",3],[10,"prefill","","",3],[10,"intern","","",3],[10,"gensym","","",3],[10,"get","","",3],[10,"len","","",3],[10,"find","","",3],[10,"clear","","",3],[10,"partial_cmp","","",4],[10,"lt","","",4],[10,"le","","",4],[10,"gt","","",4],[10,"ge","","",4],[10,"lt","","",4],[10,"le","","",4],[10,"gt","","",4],[10,"ge","","",4],[10,"hash","","",4],[10,"eq","","",4],[10,"ne","","",4],[10,"ne","","",4],[10,"clone","","",4],[10,"clone_from","","",4],[10,"new","","",4],[10,"assert_receiver_is_total_eq","","",4],[10,"cmp","","",4],[10,"fmt","","",4],[10,"deref","","",4],[10,"new","","",5],[10,"prefill","","",5],[10,"intern","","",5],[10,"gensym","","",5],[10,"gensym_copy","","Create a gensym with the same name as an existing\nentry.",5],[10,"get","","",5],[10,"len","","",5],[10,"find","","",5],[10,"clear","","",5],[10,"reset","","",5],[10,"from_iter","syntax::util::small_vector","",6],[10,"extend","","",6],[10,"zero","","",6],[10,"one","","",6],[10,"many","","",6],[10,"as_slice","","",6],[10,"push","","",6],[10,"push_all","","",6],[10,"get","","",6],[10,"expect_one","","",6],[10,"move_iter","","Deprecated: use `into_iter`.",6],[10,"into_iter","","",6],[10,"len","","",6],[10,"is_empty","","",6],[10,"next","","",7],[10,"size_hint","","",7],[10,"size_hint","","",7],[10,"move_map","","",6],[10,"new","syntax::diagnostics::registry","",8],[10,"find_description","","",8],[10,"new","syntax::ext::base","",9],[10,"make_expr","","",9],[10,"make_pat","","",9],[10,"make_def","","",9],[10,"make_expr","","",9],[10,"make_items","","",9],[10,"make_methods","","",9],[10,"make_pat","","",9],[10,"make_stmt","","",9],[10,"new","","",10],[10,"make_pat","","",10],[10,"make_def","","",10],[10,"make_expr","","",10],[10,"make_items","","",10],[10,"make_methods","","",10],[10,"make_pat","","",10],[10,"make_stmt","","",10],[10,"new","","",11],[10,"make_items","","",11],[10,"make_def","","",11],[10,"make_expr","","",11],[10,"make_items","","",11],[10,"make_methods","","",11],[10,"make_pat","","",11],[10,"make_stmt","","",11],[10,"any","","Create a default MacResult that can be anything.",12],[10,"expr","","Create a default MacResult that can only be an expression.",12],[10,"raw_expr","","A plain dummy expression.",12],[10,"raw_pat","","A plain dummy pattern.",12],[10,"make_expr","","",12],[10,"make_pat","","",12],[10,"make_items","","",12],[10,"make_methods","","",12],[10,"make_stmt","","",12],[10,"make_def","","",12],[10,"make_expr","","",12],[10,"make_items","","",12],[10,"make_methods","","",12],[10,"make_pat","","",12],[10,"make_stmt","","",12],[10,"new","","",13],[10,"new","","",14],[10,"expand_expr","","",14],[10,"expander","","Returns a `Folder` for deeply expanding all macros in a AST node.",14],[10,"new_parser_from_tts","","",14],[10,"codemap","","",14],[10,"parse_sess","","",14],[10,"cfg","","",14],[10,"call_site","","",14],[10,"print_backtrace","","",14],[10,"backtrace","","",14],[10,"original_span","","",14],[10,"original_span_in_file","","",14],[10,"mod_push","","",14],[10,"mod_pop","","",14],[10,"mod_path","","",14],[10,"bt_push","","",14],[10,"bt_pop","","",14],[10,"span_fatal","","Emit `msg` attached to `sp`, and stop compilation immediately.",14],[10,"span_err","","Emit `msg` attached to `sp`, without immediately stopping\ncompilation.",14],[10,"span_warn","","",14],[10,"span_unimpl","","",14],[10,"span_bug","","",14],[10,"span_note","","",14],[10,"span_help","","",14],[10,"bug","","",14],[10,"trace_macros","","",14],[10,"set_trace_macros","","",14],[10,"ident_of","","",14],[10,"name_of","","",14],[10,"push_frame","","",15],[10,"pop_frame","","",15],[10,"find","","",15],[10,"insert","","",15],[10,"info","","",15],[10,"path","","",14],[10,"path_ident","","",14],[10,"path_global","","",14],[10,"path_all","","",14],[10,"ty_mt","","",14],[10,"ty","","",14],[10,"ty_path","","",14],[10,"ty_sum","","",14],[10,"ty_ident","","",14],[10,"ty_rptr","","",14],[10,"ty_ptr","","",14],[10,"ty_option","","",14],[10,"ty_field_imm","","",14],[10,"ty_infer","","",14],[10,"typaram","","",14],[10,"ty_vars","","",14],[10,"ty_vars_global","","",14],[10,"trait_ref","","",14],[10,"poly_trait_ref","","",14],[10,"typarambound","","",14],[10,"lifetime","","",14],[10,"lifetime_def","","",14],[10,"stmt_expr","","",14],[10,"stmt_let","","",14],[10,"stmt_let_typed","","",14],[10,"block","","",14],[10,"stmt_item","","",14],[10,"block_expr","","",14],[10,"block_all","","",14],[10,"expr","","",14],[10,"expr_path","","",14],[10,"expr_ident","","",14],[10,"expr_self","","",14],[10,"expr_binary","","",14],[10,"expr_deref","","",14],[10,"expr_unary","","",14],[10,"expr_field_access","","",14],[10,"expr_tup_field_access","","",14],[10,"expr_addr_of","","",14],[10,"expr_mut_addr_of","","",14],[10,"expr_call","","",14],[10,"expr_call_ident","","",14],[10,"expr_call_global","","",14],[10,"expr_method_call","","",14],[10,"expr_block","","",14],[10,"field_imm","","",14],[10,"expr_struct","","",14],[10,"expr_struct_ident","","",14],[10,"expr_lit","","",14],[10,"expr_uint","","",14],[10,"expr_int","","",14],[10,"expr_u8","","",14],[10,"expr_bool","","",14],[10,"expr_vec","","",14],[10,"expr_vec_ng","","",14],[10,"expr_vec_slice","","",14],[10,"expr_str","","",14],[10,"expr_cast","","",14],[10,"expr_some","","",14],[10,"expr_none","","",14],[10,"expr_break","","",14],[10,"expr_tuple","","",14],[10,"expr_fail","","",14],[10,"expr_unreachable","","",14],[10,"expr_ok","","",14],[10,"expr_err","","",14],[10,"expr_try","","",14],[10,"pat","","",14],[10,"pat_wild","","",14],[10,"pat_lit","","",14],[10,"pat_ident","","",14],[10,"pat_ident_binding_mode","","",14],[10,"pat_enum","","",14],[10,"pat_struct","","",14],[10,"pat_tuple","","",14],[10,"pat_some","","",14],[10,"pat_none","","",14],[10,"pat_ok","","",14],[10,"pat_err","","",14],[10,"arm","","",14],[10,"arm_unreachable","","",14],[10,"expr_match","","",14],[10,"expr_if","","",14],[10,"expr_loop","","",14],[10,"lambda_fn_decl","","",14],[10,"lambda","","",14],[10,"lambda0","","",14],[10,"lambda1","","",14],[10,"lambda_expr","","",14],[10,"lambda_expr_0","","",14],[10,"lambda_expr_1","","",14],[10,"lambda_stmts","","",14],[10,"lambda_stmts_0","","",14],[10,"lambda_stmts_1","","",14],[10,"arg","","",14],[10,"fn_decl","","",14],[10,"item","","",14],[10,"item_fn_poly","","",14],[10,"item_fn","","",14],[10,"variant","","",14],[10,"item_enum_poly","","",14],[10,"item_enum","","",14],[10,"item_struct","","",14],[10,"item_struct_poly","","",14],[10,"item_mod","","",14],[10,"item_static","","",14],[10,"item_const","","",14],[10,"item_ty_poly","","",14],[10,"item_ty","","",14],[10,"attribute","","",14],[10,"meta_word","","",14],[10,"meta_list","","",14],[10,"meta_name_value","","",14],[10,"view_use","","",14],[10,"view_use_simple","","",14],[10,"view_use_simple_","","",14],[10,"view_use_list","","",14],[10,"view_use_glob","","",14],[10,"clone","syntax::ext::deriving::generic::ty","",16],[10,"clone_from","","",16],[10,"clone","","",17],[10,"clone_from","","",17],[10,"new","","",17],[10,"new_local","","",17],[10,"new_","","",17],[10,"to_ty","","",17],[10,"to_path","","",17],[10,"clone","","",18],[10,"clone_from","","",18],[10,"to_ty","","",18],[10,"to_path","","",18],[10,"clone","","",19],[10,"clone_from","","",19],[10,"empty","","",19],[10,"to_generics","","",19],[10,"expand","syntax::ext::deriving::generic","",20],[10,"eq","","",21],[10,"ne","","",21],[10,"ne","","",21],[10,"clone","syntax::ext::expand","",22],[10,"clone_from","","",22],[10,"visit_pat","","",22],[10,"visit_name","","",22],[10,"visit_ident","","",22],[10,"visit_mod","","",22],[10,"visit_view_item","","",22],[10,"visit_foreign_item","","",22],[10,"visit_item","","",22],[10,"visit_local","","",22],[10,"visit_block","","",22],[10,"visit_stmt","","",22],[10,"visit_arm","","",22],[10,"visit_pat","","",22],[10,"visit_decl","","",22],[10,"visit_expr","","",22],[10,"visit_expr_post","","",22],[10,"visit_ty","","",22],[10,"visit_generics","","",22],[10,"visit_fn","","",22],[10,"visit_ty_method","","",22],[10,"visit_trait_item","","",22],[10,"visit_trait_ref","","",22],[10,"visit_ty_param_bound","","",22],[10,"visit_poly_trait_ref","","",22],[10,"visit_struct_def","","",22],[10,"visit_struct_field","","",22],[10,"visit_variant","","",22],[10,"visit_opt_lifetime_ref","","",22],[10,"visit_lifetime_bound","","",22],[10,"visit_lifetime_ref","","",22],[10,"visit_lifetime_def","","",22],[10,"visit_explicit_self","","",22],[10,"visit_mac","","",22],[10,"visit_path","","",22],[10,"visit_path_segment","","",22],[10,"visit_path_parameters","","",22],[10,"visit_assoc_type_binding","","",22],[10,"visit_attribute","","",22],[10,"fold_ident","","",23],[10,"fold_mac","","",23],[10,"fold_crate","","",23],[10,"fold_meta_items","","",23],[10,"fold_meta_item","","",23],[10,"fold_view_path","","",23],[10,"fold_view_item","","",23],[10,"fold_foreign_item","","",23],[10,"fold_item","","",23],[10,"fold_item_simple","","",23],[10,"fold_struct_field","","",23],[10,"fold_item_underscore","","",23],[10,"fold_fn_decl","","",23],[10,"fold_type_method","","",23],[10,"fold_method","","",23],[10,"fold_block","","",23],[10,"fold_stmt","","",23],[10,"fold_arm","","",23],[10,"fold_pat","","",23],[10,"fold_decl","","",23],[10,"fold_expr","","",23],[10,"fold_ty","","",23],[10,"fold_qpath","","",23],[10,"fold_ty_binding","","",23],[10,"fold_mod","","",23],[10,"fold_foreign_mod","","",23],[10,"fold_variant","","",23],[10,"fold_ident","","",23],[10,"fold_uint","","",23],[10,"fold_path","","",23],[10,"fold_path_parameters","","",23],[10,"fold_angle_bracketed_parameter_data","","",23],[10,"fold_parenthesized_parameter_data","","",23],[10,"fold_local","","",23],[10,"fold_mac","","",23],[10,"fold_explicit_self","","",23],[10,"fold_explicit_self_underscore","","",23],[10,"fold_lifetime","","",23],[10,"fold_lifetime_def","","",23],[10,"fold_attribute","","",23],[10,"fold_arg","","",23],[10,"fold_generics","","",23],[10,"fold_trait_ref","","",23],[10,"fold_poly_trait_ref","","",23],[10,"fold_struct_def","","",23],[10,"fold_lifetimes","","",23],[10,"fold_lifetime_defs","","",23],[10,"fold_ty_param","","",23],[10,"fold_ty_params","","",23],[10,"fold_tt","","",23],[10,"fold_tts","","",23],[10,"fold_token","","",23],[10,"fold_interpolated","","",23],[10,"fold_opt_lifetime","","",23],[10,"fold_variant_arg","","",23],[10,"fold_opt_bounds","","",23],[10,"fold_bounds","","",23],[10,"fold_ty_param_bound","","",23],[10,"fold_mt","","",23],[10,"fold_field","","",23],[10,"fold_where_clause","","",23],[10,"fold_where_predicate","","",23],[10,"fold_typedef","","",23],[10,"fold_associated_type","","",23],[10,"new_id","","",23],[10,"new_span","","",23],[10,"fold_pat","","",24],[10,"fold_mac","","",24],[10,"fold_crate","","",24],[10,"fold_meta_items","","",24],[10,"fold_meta_item","","",24],[10,"fold_view_path","","",24],[10,"fold_view_item","","",24],[10,"fold_foreign_item","","",24],[10,"fold_item","","",24],[10,"fold_item_simple","","",24],[10,"fold_struct_field","","",24],[10,"fold_item_underscore","","",24],[10,"fold_fn_decl","","",24],[10,"fold_type_method","","",24],[10,"fold_method","","",24],[10,"fold_block","","",24],[10,"fold_stmt","","",24],[10,"fold_arm","","",24],[10,"fold_pat","","",24],[10,"fold_decl","","",24],[10,"fold_expr","","",24],[10,"fold_ty","","",24],[10,"fold_qpath","","",24],[10,"fold_ty_binding","","",24],[10,"fold_mod","","",24],[10,"fold_foreign_mod","","",24],[10,"fold_variant","","",24],[10,"fold_ident","","",24],[10,"fold_uint","","",24],[10,"fold_path","","",24],[10,"fold_path_parameters","","",24],[10,"fold_angle_bracketed_parameter_data","","",24],[10,"fold_parenthesized_parameter_data","","",24],[10,"fold_local","","",24],[10,"fold_mac","","",24],[10,"fold_explicit_self","","",24],[10,"fold_explicit_self_underscore","","",24],[10,"fold_lifetime","","",24],[10,"fold_lifetime_def","","",24],[10,"fold_attribute","","",24],[10,"fold_arg","","",24],[10,"fold_generics","","",24],[10,"fold_trait_ref","","",24],[10,"fold_poly_trait_ref","","",24],[10,"fold_struct_def","","",24],[10,"fold_lifetimes","","",24],[10,"fold_lifetime_defs","","",24],[10,"fold_ty_param","","",24],[10,"fold_ty_params","","",24],[10,"fold_tt","","",24],[10,"fold_tts","","",24],[10,"fold_token","","",24],[10,"fold_interpolated","","",24],[10,"fold_opt_lifetime","","",24],[10,"fold_variant_arg","","",24],[10,"fold_opt_bounds","","",24],[10,"fold_bounds","","",24],[10,"fold_ty_param_bound","","",24],[10,"fold_mt","","",24],[10,"fold_field","","",24],[10,"fold_where_clause","","",24],[10,"fold_where_predicate","","",24],[10,"fold_typedef","","",24],[10,"fold_associated_type","","",24],[10,"new_id","","",24],[10,"new_span","","",24],[10,"new","","",25],[10,"fold_expr","","",25],[10,"fold_pat","","",25],[10,"fold_item","","",25],[10,"fold_item_underscore","","",25],[10,"fold_stmt","","",25],[10,"fold_block","","",25],[10,"fold_arm","","",25],[10,"fold_method","","",25],[10,"fold_ty","","",25],[10,"new_span","","",25],[10,"fold_crate","","",25],[10,"fold_meta_items","","",25],[10,"fold_meta_item","","",25],[10,"fold_view_path","","",25],[10,"fold_view_item","","",25],[10,"fold_foreign_item","","",25],[10,"fold_item","","",25],[10,"fold_item_simple","","",25],[10,"fold_struct_field","","",25],[10,"fold_item_underscore","","",25],[10,"fold_fn_decl","","",25],[10,"fold_type_method","","",25],[10,"fold_method","","",25],[10,"fold_block","","",25],[10,"fold_stmt","","",25],[10,"fold_arm","","",25],[10,"fold_pat","","",25],[10,"fold_decl","","",25],[10,"fold_expr","","",25],[10,"fold_ty","","",25],[10,"fold_qpath","","",25],[10,"fold_ty_binding","","",25],[10,"fold_mod","","",25],[10,"fold_foreign_mod","","",25],[10,"fold_variant","","",25],[10,"fold_ident","","",25],[10,"fold_uint","","",25],[10,"fold_path","","",25],[10,"fold_path_parameters","","",25],[10,"fold_angle_bracketed_parameter_data","","",25],[10,"fold_parenthesized_parameter_data","","",25],[10,"fold_local","","",25],[10,"fold_mac","","",25],[10,"fold_explicit_self","","",25],[10,"fold_explicit_self_underscore","","",25],[10,"fold_lifetime","","",25],[10,"fold_lifetime_def","","",25],[10,"fold_attribute","","",25],[10,"fold_arg","","",25],[10,"fold_generics","","",25],[10,"fold_trait_ref","","",25],[10,"fold_poly_trait_ref","","",25],[10,"fold_struct_def","","",25],[10,"fold_lifetimes","","",25],[10,"fold_lifetime_defs","","",25],[10,"fold_ty_param","","",25],[10,"fold_ty_params","","",25],[10,"fold_tt","","",25],[10,"fold_tts","","",25],[10,"fold_token","","",25],[10,"fold_interpolated","","",25],[10,"fold_opt_lifetime","","",25],[10,"fold_variant_arg","","",25],[10,"fold_opt_bounds","","",25],[10,"fold_bounds","","",25],[10,"fold_ty_param_bound","","",25],[10,"fold_mt","","",25],[10,"fold_field","","",25],[10,"fold_where_clause","","",25],[10,"fold_where_predicate","","",25],[10,"fold_typedef","","",25],[10,"fold_associated_type","","",25],[10,"new_id","","",25],[10,"new_span","","",25],[10,"default","","",26],[10,"fold_ident","","",27],[10,"fold_mac","","",27],[10,"fold_crate","","",27],[10,"fold_meta_items","","",27],[10,"fold_meta_item","","",27],[10,"fold_view_path","","",27],[10,"fold_view_item","","",27],[10,"fold_foreign_item","","",27],[10,"fold_item","","",27],[10,"fold_item_simple","","",27],[10,"fold_struct_field","","",27],[10,"fold_item_underscore","","",27],[10,"fold_fn_decl","","",27],[10,"fold_type_method","","",27],[10,"fold_method","","",27],[10,"fold_block","","",27],[10,"fold_stmt","","",27],[10,"fold_arm","","",27],[10,"fold_pat","","",27],[10,"fold_decl","","",27],[10,"fold_expr","","",27],[10,"fold_ty","","",27],[10,"fold_qpath","","",27],[10,"fold_ty_binding","","",27],[10,"fold_mod","","",27],[10,"fold_foreign_mod","","",27],[10,"fold_variant","","",27],[10,"fold_ident","","",27],[10,"fold_uint","","",27],[10,"fold_path","","",27],[10,"fold_path_parameters","","",27],[10,"fold_angle_bracketed_parameter_data","","",27],[10,"fold_parenthesized_parameter_data","","",27],[10,"fold_local","","",27],[10,"fold_mac","","",27],[10,"fold_explicit_self","","",27],[10,"fold_explicit_self_underscore","","",27],[10,"fold_lifetime","","",27],[10,"fold_lifetime_def","","",27],[10,"fold_attribute","","",27],[10,"fold_arg","","",27],[10,"fold_generics","","",27],[10,"fold_trait_ref","","",27],[10,"fold_poly_trait_ref","","",27],[10,"fold_struct_def","","",27],[10,"fold_lifetimes","","",27],[10,"fold_lifetime_defs","","",27],[10,"fold_ty_param","","",27],[10,"fold_ty_params","","",27],[10,"fold_tt","","",27],[10,"fold_tts","","",27],[10,"fold_token","","",27],[10,"fold_interpolated","","",27],[10,"fold_opt_lifetime","","",27],[10,"fold_variant_arg","","",27],[10,"fold_opt_bounds","","",27],[10,"fold_bounds","","",27],[10,"fold_ty_param_bound","","",27],[10,"fold_mt","","",27],[10,"fold_field","","",27],[10,"fold_where_clause","","",27],[10,"fold_where_predicate","","",27],[10,"fold_typedef","","",27],[10,"fold_associated_type","","",27],[10,"new_id","","",27],[10,"new_span","","",27],[10,"visit_mac","","",28],[10,"visit_name","","",28],[10,"visit_ident","","",28],[10,"visit_mod","","",28],[10,"visit_view_item","","",28],[10,"visit_foreign_item","","",28],[10,"visit_item","","",28],[10,"visit_local","","",28],[10,"visit_block","","",28],[10,"visit_stmt","","",28],[10,"visit_arm","","",28],[10,"visit_pat","","",28],[10,"visit_decl","","",28],[10,"visit_expr","","",28],[10,"visit_expr_post","","",28],[10,"visit_ty","","",28],[10,"visit_generics","","",28],[10,"visit_fn","","",28],[10,"visit_ty_method","","",28],[10,"visit_trait_item","","",28],[10,"visit_trait_ref","","",28],[10,"visit_ty_param_bound","","",28],[10,"visit_poly_trait_ref","","",28],[10,"visit_struct_def","","",28],[10,"visit_struct_field","","",28],[10,"visit_variant","","",28],[10,"visit_opt_lifetime_ref","","",28],[10,"visit_lifetime_bound","","",28],[10,"visit_lifetime_ref","","",28],[10,"visit_lifetime_def","","",28],[10,"visit_explicit_self","","",28],[10,"visit_mac","","",28],[10,"visit_path","","",28],[10,"visit_path_segment","","",28],[10,"visit_path_parameters","","",28],[10,"visit_assoc_type_binding","","",28],[10,"visit_attribute","","",28],[10,"eq","syntax::ext::format","",29],[10,"ne","","",29],[10,"ne","","",29],[10,"fmt","syntax::ext::mtwt","",30],[10,"hash","","",30],[10,"decode","","",30],[10,"encode","","",30],[10,"eq","","",30],[10,"ne","","",30],[10,"ne","","",30],[10,"to_tokens","syntax::ast","",31],[10,"to_tokens","collections::vec","",32],[10,"to_tokens","syntax::codemap","",33],[10,"to_tokens","core::option","",34],[10,"to_source","syntax::ast","",35],[10,"to_source_with_hygiene","","",35],[10,"to_source","","",36],[10,"to_source_with_hygiene","","",36],[10,"to_source","","",37],[10,"to_source_with_hygiene","","",37],[10,"to_source","","",38],[10,"to_source_with_hygiene","","",38],[10,"to_source","","",39],[10,"to_source_with_hygiene","","",39],[10,"to_source","syntax::ptr","",40],[10,"to_source_with_hygiene","","",40],[10,"to_source","","",40],[10,"to_source_with_hygiene","","",40],[10,"to_source","","",40],[10,"to_source_with_hygiene","","",40],[10,"to_source","","",40],[10,"to_source_with_hygiene","","",40],[10,"to_source","","",40],[10,"to_source_with_hygiene","","",40],[10,"to_source","syntax::ast","",41],[10,"to_source_with_hygiene","","",41],[10,"to_source","","",42],[10,"to_source_with_hygiene","","",42],[10,"to_tokens","","",35],[10,"to_tokens","syntax::ptr","",40],[10,"to_tokens","","",40],[10,"to_tokens","syntax::ast","",41],[10,"to_tokens","syntax::ptr","",40],[10,"to_tokens","syntax::ast","",36],[10,"to_tokens","","",39],[10,"to_tokens","syntax::ptr","",40],[10,"to_tokens","","",40],[10,"to_tokens","syntax::ast","",37],[10,"to_tokens","","",38],[10,"to_tokens","","",42],[10,"parse_item","syntax::ext::base","",14],[10,"parse_stmt","","",14],[10,"parse_expr","","",14],[10,"parse_tts","","",14],[10,"parse_tts_with_hygiene","","",14],[10,"clone","syntax::ext::tt::transcribe","",43],[10,"clone_from","","",43],[10,"clone","","",44],[10,"clone_from","","",44],[10,"clone","","",45],[10,"clone_from","","",45],[10,"add","","",45],[10,"clone","syntax::ext::tt::macro_parser","",46],[10,"clone_from","","",46],[10,"clone","","",47],[10,"clone_from","","",47],[10,"clone","","",48],[10,"clone_from","","",48],[10,"make_expr","syntax::ext::tt::macro_rules","",49],[10,"make_pat","","",49],[10,"make_items","","",49],[10,"make_methods","","",49],[10,"make_stmt","","",49],[10,"make_def","","",49],[10,"make_expr","","",49],[10,"make_items","","",49],[10,"make_methods","","",49],[10,"make_pat","","",49],[10,"make_stmt","","",49],[10,"expand","","",50],[10,"make_def","","",51],[10,"make_def","","",51],[10,"make_expr","","",51],[10,"make_items","","",51],[10,"make_methods","","",51],[10,"make_pat","","",51],[10,"make_stmt","","",51],[10,"eq","syntax::parse::lexer::comments","",52],[10,"ne","","",52],[10,"ne","","",52],[10,"clone","","",52],[10,"clone_from","","",52],[10,"clone","","",53],[10,"clone_from","","",53],[10,"clone","","",54],[10,"clone_from","","",54],[10,"fmt","syntax::parse::lexer","",55],[10,"assert_receiver_is_total_eq","","",55],[10,"eq","","",55],[10,"ne","","",55],[10,"ne","","",55],[10,"clone","","",55],[10,"clone_from","","",55],[10,"is_eof","","",56],[10,"next_token","","Return the next token. EFFECT: advances the string_reader.",56],[10,"fatal","","",56],[10,"err","","",56],[10,"peek","","",56],[10,"real_token","","",56],[10,"is_eof","syntax::ext::tt::transcribe","",44],[10,"next_token","","",44],[10,"fatal","","",44],[10,"err","","",44],[10,"peek","","",44],[10,"real_token","","",44],[10,"new_raw","syntax::parse::lexer","For comments.rs, which hackily pokes into pos and curr",56],[10,"new","","",56],[10,"curr_is","","",56],[10,"fatal_span","","Report a fatal lexical error with a given span.",56],[10,"err_span","","Report a lexical error with a given span.",56],[10,"with_str_from","","Calls `f` with a string slice of the source text spanning from `start`\nup to but excluding `self.last_pos`, meaning the slice does not include\nthe character `self.curr`.",56],[10,"name_from","","Create a Name from a given offset to the current offset, each\nadjusted 1 towards each other (assumes that on either side there is a\nsingle-byte delimiter).",56],[10,"name_from_to","","As name_from, with an explicit endpoint.",56],[10,"bump","","Advance the StringReader by one character. If a newline is\ndiscovered, add it to the FileMap's list of line start offsets.",56],[10,"nextch","","",56],[10,"nextch_is","","",56],[10,"nextnextch","","",56],[10,"nextnextch_is","","",56],[10,"hash","syntax::parse::parser","",57],[10,"cmp","","",57],[10,"partial_cmp","","",57],[10,"lt","","",57],[10,"le","","",57],[10,"gt","","",57],[10,"ge","","",57],[10,"lt","","",57],[10,"le","","",57],[10,"gt","","",57],[10,"ge","","",57],[10,"clone","","",57],[10,"clone_from","","",57],[10,"assert_receiver_is_total_eq","","",57],[10,"eq","","",57],[10,"ne","","",57],[10,"ne","","",57],[10,"empty","","Returns an empty set of flags.",57],[10,"all","","Returns the set containing all flags.",57],[10,"bits","","Returns the raw value of the flags currently stored.",57],[10,"from_bits","","Convert from underlying bit representation, unless that\nrepresentation contains bits that do not correspond to a flag.",57],[10,"from_bits_truncate","","Convert from underlying bit representation, dropping any bits\nthat do not correspond to flags.",57],[10,"is_empty","","Returns `true` if no flags are currently stored.",57],[10,"is_all","","Returns `true` if all flags are currently set.",57],[10,"intersects","","Returns `true` if there are flags common to both `self` and `other`.",57],[10,"contains","","Returns `true` all of the flags in `other` are contained within `self`.",57],[10,"insert","","Inserts the specified flags in-place.",57],[10,"remove","","Removes the specified flags in-place.",57],[10,"toggle","","Toggles the specified flags in-place.",57],[10,"bitor","","Returns the union of the two sets of flags.",57],[10,"bitxor","","Returns the left flags, but with all the right flags toggled.",57],[10,"bitand","","Returns the intersection between the two sets of flags.",57],[10,"sub","","Returns the set difference of the two sets of flags.",57],[10,"not","","Returns the complement of this set of flags.",57],[10,"eq","","",58],[10,"ne","","",58],[10,"ne","","",58],[10,"eq","","",59],[10,"ne","","",59],[10,"ne","","",59],[10,"clone","","",60],[10,"clone_from","","",60],[10,"assert_receiver_is_total_eq","","",60],[10,"eq","","",60],[10,"ne","","",60],[10,"ne","","",60],[10,"new","","",61],[10,"token_to_string","","Convert a token to a string using self's reader",61],[10,"this_token_to_string","","Convert the current token to a string using self's reader",61],[10,"unexpected_last","","",61],[10,"unexpected","","",61],[10,"expect","","Expect and consume the token t. Signal an error if\nthe next token is not t.",61],[10,"expect_one_of","","Expect next token to be edible or inedible token.  If edible,\nthen consume it; if inedible, then return without consuming\nanything.  Signal a fatal error if next token is unexpected.",61],[10,"check_for_erroneous_unit_struct_expecting","","Check for erroneous `ident { }`; if matches, signal error and\nrecover (without consuming any expected input token).  Returns\ntrue if and only if input was consumed for recovery.",61],[10,"commit_expr","","Commit to parsing a complete expression `e` expected to be\nfollowed by some token from the set edible + inedible.  Recover\nfrom anticipated input errors, discarding erroneous characters.",61],[10,"commit_expr_expecting","","",61],[10,"commit_stmt","","Commit to parsing a complete statement `s`, which expects to be\nfollowed by some token from the set edible + inedible.  Check\nfor recoverable input errors, discarding erroneous characters.",61],[10,"commit_stmt_expecting","","",61],[10,"parse_ident","","",61],[10,"parse_path_list_item","","",61],[10,"check","","Check if the next token is `tok`, and return `true` if so.",61],[10,"eat","","Consume token 'tok' if it exists. Returns true if the given\ntoken was present, false otherwise.",61],[10,"eat_keyword","","If the next token is the given keyword, eat it and return\ntrue. Otherwise, return false.",61],[10,"expect_keyword","","If the given word is not a keyword, signal an error.\nIf the next token is not the given word, signal an error.\nOtherwise, eat it.",61],[10,"check_strict_keywords","","Signal an error if the given string is a strict keyword",61],[10,"check_reserved_keywords","","Signal an error if the current token is a reserved keyword",61],[10,"expect_no_suffix","","",61],[10,"expect_gt","","Expect and consume a GT. if a >> is seen, replace it\nwith a single > and continue. If a GT is not seen,\nsignal an error.",61],[10,"parse_seq_to_before_gt_or_return","","",61],[10,"parse_seq_to_before_gt","","Parse a sequence bracketed by '<' and '>', stopping\nbefore the '>'.",61],[10,"parse_seq_to_gt","","",61],[10,"parse_seq_to_gt_or_return","","",61],[10,"parse_seq_to_end","","Parse a sequence, including the closing delimiter. The function\nf must consume tokens until reaching the next separator or\nclosing bracket.",61],[10,"parse_seq_to_before_end","","Parse a sequence, not including the closing delimiter. The function\nf must consume tokens until reaching the next separator or\nclosing bracket.",61],[10,"parse_unspanned_seq","","Parse a sequence, including the closing delimiter. The function\nf must consume tokens until reaching the next separator or\nclosing bracket.",61],[10,"parse_enum_variant_seq","","Parse a sequence parameter of enum variant. For consistency purposes,\nthese should not be empty.",61],[10,"parse_seq","","",61],[10,"bump","","Advance the parser by one token",61],[10,"bump_and_get","","Advance the parser by one token and return the bumped token.",61],[10,"replace_token","","EFFECT: replace the current token and span with the given one",61],[10,"buffer_length","","",61],[10,"look_ahead","","",61],[10,"fatal","","",61],[10,"span_fatal","","",61],[10,"span_fatal_help","","",61],[10,"span_note","","",61],[10,"span_help","","",61],[10,"bug","","",61],[10,"warn","","",61],[10,"span_warn","","",61],[10,"span_err","","",61],[10,"span_bug","","",61],[10,"abort_if_errors","","",61],[10,"id_to_interned_str","","",61],[10,"token_is_bare_fn_keyword","","Is the current token one of the keywords that signals a bare function\ntype?",61],[10,"token_is_closure_keyword","","Is the current token one of the keywords that signals a closure type?",61],[10,"get_lifetime","","",61],[10,"parse_for_in_type","","",61],[10,"parse_ty_path","","",61],[10,"parse_ty_bare_fn","","parse a TyBareFn type:",61],[10,"parse_proc_type","","Parses a procedure type (`proc`). The initial `proc` keyword must\nalready have been parsed.",61],[10,"parse_optional_unboxed_closure_kind","","Parses an optional unboxed closure kind (`&:`, `&mut:`, or `:`).",61],[10,"parse_ty_bare_fn_or_ty_closure","","",61],[10,"parse_ty_closure","","Parse a TyClosure type",61],[10,"parse_unsafety","","",61],[10,"parse_trait_items","","Parse the items in a trait declaration",61],[10,"parse_mt","","Parse a possibly mutable type",61],[10,"parse_ty_field","","Parse [mut/const/imm] ID : TY\nnow used only by obsolete record syntax parser...",61],[10,"parse_ret_ty","","Parse optional return type [ -> TY ] in function decl",61],[10,"parse_ty_sum","","Parse a type in a context where `T1+T2` is allowed.",61],[10,"parse_ty","","Parse a type.",61],[10,"parse_borrowed_pointee","","",61],[10,"parse_ptr","","",61],[10,"is_named_argument","","",61],[10,"parse_arg_general","","This version of parse arg doesn't necessarily require\nidentifier names.",61],[10,"parse_arg","","Parse a single function argument",61],[10,"parse_fn_block_arg","","Parse an argument in a lambda header e.g. |arg, arg|",61],[10,"maybe_parse_fixed_length_of_vec","","",61],[10,"lit_from_token","","Matches token_lit = LIT_INTEGER | ...",61],[10,"parse_lit","","Matches lit = true | false | token_lit",61],[10,"parse_literal_maybe_minus","","matches '-' lit | lit",61],[10,"parse_path","","Parses a path and optional type parameter bounds, depending on the\nmode. The `mode` parameter determines whether lifetimes, types, and/or\nbounds are permitted and whether `::` must precede type parameter\ngroups.",61],[10,"parse_path_segments_without_colons","","Examples:\n- `a::b<T,U>::c<V,W>`\n- `a::b<T,U>::c(V) -> W`\n- `a::b<T,U>::c(V)`",61],[10,"parse_path_segments_with_colons","","Examples:\n- `a::b::<T,U>::c`",61],[10,"parse_path_segments_without_types","","Examples:\n- `a::b::c`",61],[10,"parse_opt_lifetime","","parses 0 or 1 lifetime",61],[10,"parse_lifetime","","Parses a single lifetime\nMatches lifetime = LIFETIME",61],[10,"parse_lifetime_defs","","Parses `lifetime_defs = [ lifetime_defs { ',' lifetime_defs } ]` where `lifetime_def  =\nlifetime [':' lifetimes]`",61],[10,"parse_lifetimes","","matches lifetimes = ( lifetime ) | ( lifetime , lifetimes ) actually, it matches the empty\none too, but putting that in there messes up the grammar....",61],[10,"parse_mutability","","Parse mutability declaration (mut/const/imm)",61],[10,"parse_field","","Parse ident COLON expr",61],[10,"mk_expr","","",61],[10,"mk_unary","","",61],[10,"mk_binary","","",61],[10,"mk_call","","",61],[10,"mk_index","","",61],[10,"mk_slice","","",61],[10,"mk_range","","",61],[10,"mk_field","","",61],[10,"mk_tup_field","","",61],[10,"mk_assign_op","","",61],[10,"mk_mac_expr","","",61],[10,"mk_lit_u32","","",61],[10,"parse_bottom_expr","","At the bottom (top?) of the precedence hierarchy,\nparse things like parenthesized exprs,\nmacros, return, etc.",61],[10,"parse_block_expr","","Parse a block or unsafe block",61],[10,"parse_dot_or_call_expr","","parse a.b or a(13) or a[4] or just a",61],[10,"parse_dot_or_call_expr_with","","",61],[10,"parse_sep_and_kleene_op","","Parse an optional separator followed by a Kleene-style\nrepetition token (+ or *).",61],[10,"parse_token_tree","","parse a single token tree from the input.",61],[10,"parse_all_token_trees","","",61],[10,"parse_prefix_expr","","Parse a prefix-operator expr",61],[10,"parse_binops","","Parse an expression of binops",61],[10,"parse_more_binops","","Parse an expression of binops of at least min_prec precedence",61],[10,"parse_assign_expr","","Parse an assignment expression....\nactually, this seems to be the main entry point for\nparsing an arbitrary expression.",61],[10,"parse_if_expr","","Parse an 'if' or 'if let' expression ('if' token already eaten)",61],[10,"parse_if_let_expr","","Parse an 'if let' expression ('if' token already eaten)",61],[10,"parse_lambda_expr","","",61],[10,"parse_else_expr","","",61],[10,"parse_for_expr","","Parse a 'for' .. 'in' expression ('for' token already eaten)",61],[10,"parse_while_expr","","Parse a 'while' or 'while let' expression ('while' token already eaten)",61],[10,"parse_while_let_expr","","Parse a 'while let' expression ('while' token already eaten)",61],[10,"parse_loop_expr","","",61],[10,"parse_arm","","",61],[10,"parse_expr","","Parse an expression",61],[10,"parse_expr_res","","Parse an expression, subject to the given restrictions",61],[10,"parse_pat","","Parse a pattern.",61],[10,"parse_stmt","","Parse a statement. may include decl.\nPrecondition: any attributes are parsed already",61],[10,"parse_block","","Parse a block. No inner attrs are allowed.",61],[10,"parse_generics","","Parse a set of optional generic type parameter declarations. Where\nclauses are not parsed here, and must be added later via\n`parse_where_clause()`.",61],[10,"parse_fn_decl","","Parse the argument list and result type of a function declaration",61],[10,"parse_method_with_outer_attributes","","Parse a method in a trait impl",61],[10,"parse_method","","Parse a method in a trait impl, starting with `attrs` attributes.",61],[10,"parse_single_struct_field","","Parse a structure field declaration",61],[10,"parse_item_with_outer_attributes","","",61],[10,"parse_item","","",61],[10,"parse_view_item","","Parse a ViewItem, e.g. `use foo::bar` or `extern crate foo`",61],[10,"parse_crate_mod","","Parses a source module as a crate. This is the main\nentry point for the parser.",61],[10,"parse_optional_str","","",61],[10,"parse_str","","",61],[10,"fmt","syntax::parse::token","",62],[10,"hash","","",62],[10,"assert_receiver_is_total_eq","","",62],[10,"eq","","",62],[10,"ne","","",62],[10,"ne","","",62],[10,"decode","","",62],[10,"encode","","",62],[10,"clone","","",62],[10,"clone_from","","",62],[10,"fmt","","",63],[10,"hash","","",63],[10,"assert_receiver_is_total_eq","","",63],[10,"eq","","",63],[10,"ne","","",63],[10,"ne","","",63],[10,"decode","","",63],[10,"encode","","",63],[10,"clone","","",63],[10,"clone_from","","",63],[10,"fmt","","",64],[10,"hash","","",64],[10,"assert_receiver_is_total_eq","","",64],[10,"eq","","",64],[10,"ne","","",64],[10,"ne","","",64],[10,"decode","","",64],[10,"encode","","",64],[10,"clone","","",64],[10,"clone_from","","",64],[10,"fmt","","",65],[10,"hash","","",65],[10,"assert_receiver_is_total_eq","","",65],[10,"eq","","",65],[10,"ne","","",65],[10,"ne","","",65],[10,"decode","","",65],[10,"encode","","",65],[10,"clone","","",65],[10,"clone_from","","",65],[10,"short_name","","",65],[10,"fmt","","",66],[10,"hash","","",66],[10,"assert_receiver_is_total_eq","","",66],[10,"eq","","",66],[10,"ne","","",66],[10,"ne","","",66],[10,"decode","","",66],[10,"encode","","",66],[10,"clone","","",66],[10,"clone_from","","",66],[10,"can_begin_expr","","Returns `true` if the token can appear at the start of an expression.",66],[10,"is_lit","","Returns `true` if the token is any literal",66],[10,"is_ident","","Returns `true` if the token is an identifier.",66],[10,"is_path","","Returns `true` if the token is an interpolated path.",66],[10,"is_plain_ident","","Returns `true` if the token is a path that is not followed by a `::`\ntoken.",66],[10,"is_lifetime","","Returns `true` if the token is a lifetime.",66],[10,"is_mutability","","Returns `true` if the token is either the `mut` or `const` keyword.",66],[10,"to_binop","","Maps a token to its corresponding binary operator.",66],[10,"is_keyword","","Returns `true` if the token is a given keyword, `kw`.",66],[10,"is_any_keyword","","Returns `true` if the token is either a special identifier, or a strict\nor reserved keyword.",66],[10,"is_strict_keyword","","Returns `true` if the token may not appear as an identifier.",66],[10,"is_reserved_keyword","","Returns `true` if the token is a keyword that has been reserved for\npossible future use.",66],[10,"mtwt_eq","","Hygienic identifier equality comparison.",66],[10,"hash","","",67],[10,"assert_receiver_is_total_eq","","",67],[10,"eq","","",67],[10,"ne","","",67],[10,"ne","","",67],[10,"decode","","",67],[10,"encode","","",67],[10,"clone","","",67],[10,"clone_from","","",67],[10,"fmt","","",67],[10,"to_name","syntax::parse::token::keywords","",68],[10,"cmp","syntax::parse::token","",69],[10,"assert_receiver_is_total_eq","","",69],[10,"partial_cmp","","",69],[10,"lt","","",69],[10,"le","","",69],[10,"gt","","",69],[10,"ge","","",69],[10,"lt","","",69],[10,"le","","",69],[10,"gt","","",69],[10,"ge","","",69],[10,"hash","","",69],[10,"eq","","",69],[10,"ne","","",69],[10,"ne","","",69],[10,"clone","","",69],[10,"clone_from","","",69],[10,"new","","",69],[10,"get","","",69],[10,"deref","","",69],[10,"container_as_bytes","","",69],[10,"container_as_str","","",69],[10,"is_str","","",69],[10,"fmt","","",69],[10,"equiv","","",69],[10,"eq","","",69],[10,"ne","","",69],[10,"ne","","",69],[10,"decode","","",69],[10,"encode","","",69],[10,"parse_outer_attributes","syntax::parse::parser","Parse attributes that appear before an item",61],[10,"parse_attribute","","Matches `attribute = # ! [ meta_item ]`",61],[10,"parse_inner_attrs_and_next","","Parse attributes that appear after the opening of an item. These should\nbe preceded by an exclamation mark, but we accept and warn about one\nterminated by a semicolon. In addition to a vector of inner attributes,\nthis function also returns a vector that may contain the first outer\nattribute of the next item (since we can't know whether the attribute\nis an inner attribute of the containing item or an outer attribute of\nthe first contained item until we see the semi).\nmatches inner_attrs* outer_attr?\nyou can make the 'next' field an Option, but the result is going to be\nmore useful as a vector.",61],[10,"parse_meta_item","","matches meta_item = IDENT\n| IDENT = lit\n| IDENT meta_seq",61],[10,"parse_meta_seq","","matches meta_seq = ( COMMASEP(meta_item) )",61],[10,"parse_optional_meta","","",61],[10,"hash","syntax::parse::obsolete","",70],[10,"assert_receiver_is_total_eq","","",70],[10,"eq","","",70],[10,"ne","","",70],[10,"ne","","",70],[10,"obsolete","syntax::parse::parser","Reports an obsolete syntax non-fatal error.",61],[10,"obsolete_expr","","Reports an obsolete syntax non-fatal error, and returns\na placeholder expression",61],[10,"report","","",61],[10,"is_obsolete_ident","","",61],[10,"eat_obsolete_ident","","",61],[10,"next_node_id","syntax::parse","",71],[10,"reserve_node_ids","","",71],[10,"cmp","syntax::ast","",35],[10,"assert_receiver_is_total_eq","","",35],[10,"partial_cmp","","",35],[10,"lt","","",35],[10,"le","","",35],[10,"gt","","",35],[10,"ge","","",35],[10,"lt","","",35],[10,"le","","",35],[10,"gt","","",35],[10,"ge","","",35],[10,"hash","","",35],[10,"clone","","",35],[10,"clone_from","","",35],[10,"new","","Construct an identifier with the given name and an empty context:",35],[10,"as_str","","",35],[10,"encode_with_hygiene","","",35],[10,"fmt","","",35],[10,"fmt","","",72],[10,"eq","","",35],[10,"ne","","",35],[10,"ne","","",35],[10,"clone","","",72],[10,"clone_from","","",72],[10,"decode","","",72],[10,"encode","","",72],[10,"hash","","",72],[10,"partial_cmp","","",72],[10,"lt","","",72],[10,"le","","",72],[10,"gt","","",72],[10,"ge","","",72],[10,"lt","","",72],[10,"le","","",72],[10,"gt","","",72],[10,"ge","","",72],[10,"eq","","",72],[10,"ne","","",72],[10,"ne","","",72],[10,"cmp","","",72],[10,"assert_receiver_is_total_eq","","",72],[10,"as_str","","",72],[10,"uint","","",72],[10,"ident","","",72],[10,"encode","","",35],[10,"decode","","",35],[10,"fmt","","",73],[10,"hash","","",73],[10,"decode","","",73],[10,"encode","","",73],[10,"assert_receiver_is_total_eq","","",73],[10,"eq","","",73],[10,"ne","","",73],[10,"ne","","",73],[10,"clone","","",73],[10,"clone_from","","",73],[10,"fmt","","",74],[10,"hash","","",74],[10,"decode","","",74],[10,"encode","","",74],[10,"assert_receiver_is_total_eq","","",74],[10,"eq","","",74],[10,"ne","","",74],[10,"ne","","",74],[10,"clone","","",74],[10,"clone_from","","",74],[10,"fmt","","",75],[10,"hash","","",75],[10,"decode","","",75],[10,"encode","","",75],[10,"assert_receiver_is_total_eq","","",75],[10,"eq","","",75],[10,"ne","","",75],[10,"ne","","",75],[10,"clone","","",75],[10,"clone_from","","",75],[10,"fmt","","",76],[10,"hash","","",76],[10,"decode","","",76],[10,"encode","","",76],[10,"assert_receiver_is_total_eq","","",76],[10,"eq","","",76],[10,"ne","","",76],[10,"ne","","",76],[10,"clone","","",76],[10,"clone_from","","",76],[10,"fmt","","",77],[10,"hash","","",77],[10,"decode","","",77],[10,"encode","","",77],[10,"assert_receiver_is_total_eq","","",77],[10,"eq","","",77],[10,"ne","","",77],[10,"ne","","",77],[10,"clone","","",77],[10,"clone_from","","",77],[10,"none","","",77],[10,"is_empty","","",77],[10,"has_lifetimes","","",77],[10,"has_types","","",77],[10,"types","","Returns the types that the user wrote. Note that these do not necessarily map to the type\nparameters in the parenthesized case.",77],[10,"lifetimes","","",77],[10,"bindings","","",77],[10,"fmt","","",78],[10,"hash","","",78],[10,"decode","","",78],[10,"encode","","",78],[10,"assert_receiver_is_total_eq","","",78],[10,"eq","","",78],[10,"ne","","",78],[10,"ne","","",78],[10,"clone","","",78],[10,"clone_from","","",78],[10,"fmt","","",79],[10,"hash","","",79],[10,"decode","","",79],[10,"encode","","",79],[10,"assert_receiver_is_total_eq","","",79],[10,"eq","","",79],[10,"ne","","",79],[10,"ne","","",79],[10,"clone","","",79],[10,"clone_from","","",79],[10,"fmt","","",80],[10,"hash","","",80],[10,"decode","","",80],[10,"encode","","",80],[10,"eq","","",80],[10,"ne","","",80],[10,"ne","","",80],[10,"partial_cmp","","",80],[10,"lt","","",80],[10,"le","","",80],[10,"gt","","",80],[10,"ge","","",80],[10,"lt","","",80],[10,"le","","",80],[10,"gt","","",80],[10,"ge","","",80],[10,"cmp","","",80],[10,"assert_receiver_is_total_eq","","",80],[10,"clone","","",80],[10,"clone_from","","",80],[10,"fmt","","",81],[10,"hash","","",81],[10,"decode","","",81],[10,"encode","","",81],[10,"assert_receiver_is_total_eq","","",81],[10,"eq","","",81],[10,"ne","","",81],[10,"ne","","",81],[10,"clone","","",81],[10,"clone_from","","",81],[10,"fmt","","",82],[10,"hash","","",82],[10,"decode","","",82],[10,"encode","","",82],[10,"assert_receiver_is_total_eq","","",82],[10,"eq","","",82],[10,"ne","","",82],[10,"ne","","",82],[10,"clone","","",82],[10,"clone_from","","",82],[10,"fmt","","",83],[10,"hash","","",83],[10,"decode","","",83],[10,"encode","","",83],[10,"assert_receiver_is_total_eq","","",83],[10,"eq","","",83],[10,"ne","","",83],[10,"ne","","",83],[10,"clone","","",83],[10,"clone_from","","",83],[10,"fmt","","",39],[10,"hash","","",39],[10,"decode","","",39],[10,"encode","","",39],[10,"assert_receiver_is_total_eq","","",39],[10,"eq","","",39],[10,"ne","","",39],[10,"ne","","",39],[10,"clone","","",39],[10,"clone_from","","",39],[10,"is_parameterized","","",39],[10,"is_lt_parameterized","","",39],[10,"is_type_parameterized","","",39],[10,"fmt","","",84],[10,"hash","","",84],[10,"decode","","",84],[10,"encode","","",84],[10,"assert_receiver_is_total_eq","","",84],[10,"eq","","",84],[10,"ne","","",84],[10,"ne","","",84],[10,"clone","","",84],[10,"clone_from","","",84],[10,"fmt","","",85],[10,"hash","","",85],[10,"decode","","",85],[10,"encode","","",85],[10,"assert_receiver_is_total_eq","","",85],[10,"eq","","",85],[10,"ne","","",85],[10,"ne","","",85],[10,"clone","","",85],[10,"clone_from","","",85],[10,"fmt","","",86],[10,"hash","","",86],[10,"decode","","",86],[10,"encode","","",86],[10,"assert_receiver_is_total_eq","","",86],[10,"eq","","",86],[10,"ne","","",86],[10,"ne","","",86],[10,"clone","","",86],[10,"clone_from","","",86],[10,"fmt","","",87],[10,"hash","","",87],[10,"decode","","",87],[10,"encode","","",87],[10,"assert_receiver_is_total_eq","","",87],[10,"eq","","",87],[10,"ne","","",87],[10,"ne","","",87],[10,"clone","","",87],[10,"clone_from","","",87],[10,"fmt","","",88],[10,"hash","","",88],[10,"decode","","",88],[10,"encode","","",88],[10,"assert_receiver_is_total_eq","","",88],[10,"eq","","",88],[10,"ne","","",88],[10,"ne","","",88],[10,"clone","","",88],[10,"clone_from","","",88],[10,"fmt","","",89],[10,"hash","","",89],[10,"decode","","",89],[10,"encode","","",89],[10,"assert_receiver_is_total_eq","","",89],[10,"eq","","",89],[10,"ne","","",89],[10,"ne","","",89],[10,"clone","","",89],[10,"clone_from","","",89],[10,"fmt","","",90],[10,"hash","","",90],[10,"decode","","",90],[10,"encode","","",90],[10,"assert_receiver_is_total_eq","","",90],[10,"clone","","",90],[10,"clone_from","","",90],[10,"eq","","",90],[10,"ne","","",90],[10,"fmt","","",37],[10,"hash","","",37],[10,"decode","","",37],[10,"encode","","",37],[10,"assert_receiver_is_total_eq","","",37],[10,"eq","","",37],[10,"ne","","",37],[10,"ne","","",37],[10,"clone","","",37],[10,"clone_from","","",37],[10,"fmt","","",91],[10,"hash","","",91],[10,"decode","","",91],[10,"encode","","",91],[10,"assert_receiver_is_total_eq","","",91],[10,"eq","","",91],[10,"ne","","",91],[10,"ne","","",91],[10,"clone","","",91],[10,"clone_from","","",91],[10,"fmt","","",92],[10,"hash","","",92],[10,"decode","","",92],[10,"encode","","",92],[10,"assert_receiver_is_total_eq","","",92],[10,"eq","","",92],[10,"ne","","",92],[10,"ne","","",92],[10,"clone","","",92],[10,"clone_from","","",92],[10,"fmt","","",93],[10,"hash","","",93],[10,"decode","","",93],[10,"encode","","",93],[10,"assert_receiver_is_total_eq","","",93],[10,"eq","","",93],[10,"ne","","",93],[10,"ne","","",93],[10,"clone","","",93],[10,"clone_from","","",93],[10,"fmt","","",94],[10,"hash","","",94],[10,"decode","","",94],[10,"encode","","",94],[10,"assert_receiver_is_total_eq","","",94],[10,"eq","","",94],[10,"ne","","",94],[10,"ne","","",94],[10,"clone","","",94],[10,"clone_from","","",94],[10,"fmt","","",95],[10,"hash","","",95],[10,"decode","","",95],[10,"encode","","",95],[10,"assert_receiver_is_total_eq","","",95],[10,"eq","","",95],[10,"ne","","",95],[10,"ne","","",95],[10,"clone","","",95],[10,"clone_from","","",95],[10,"fmt","","",96],[10,"hash","","",96],[10,"decode","","",96],[10,"encode","","",96],[10,"assert_receiver_is_total_eq","","",96],[10,"eq","","",96],[10,"ne","","",96],[10,"ne","","",96],[10,"clone","","",96],[10,"clone_from","","",96],[10,"fmt","","",97],[10,"hash","","",97],[10,"decode","","",97],[10,"encode","","",97],[10,"assert_receiver_is_total_eq","","",97],[10,"eq","","",97],[10,"ne","","",97],[10,"ne","","",97],[10,"clone","","",97],[10,"clone_from","","",97],[10,"fmt","","",98],[10,"hash","","",98],[10,"decode","","",98],[10,"encode","","",98],[10,"assert_receiver_is_total_eq","","",98],[10,"eq","","",98],[10,"ne","","",98],[10,"ne","","",98],[10,"clone","","",98],[10,"clone_from","","",98],[10,"fmt","","",99],[10,"hash","","",99],[10,"decode","","",99],[10,"encode","","",99],[10,"assert_receiver_is_total_eq","","",99],[10,"eq","","",99],[10,"ne","","",99],[10,"ne","","",99],[10,"clone","","",99],[10,"clone_from","","",99],[10,"fmt","","",100],[10,"hash","","",100],[10,"decode","","",100],[10,"encode","","",100],[10,"assert_receiver_is_total_eq","","",100],[10,"eq","","",100],[10,"ne","","",100],[10,"ne","","",100],[10,"clone","","",100],[10,"clone_from","","",100],[10,"fmt","","",101],[10,"hash","","",101],[10,"decode","","",101],[10,"encode","","",101],[10,"assert_receiver_is_total_eq","","",101],[10,"eq","","",101],[10,"ne","","",101],[10,"ne","","",101],[10,"clone","","",101],[10,"clone_from","","",101],[10,"fmt","","",102],[10,"hash","","",102],[10,"decode","","",102],[10,"encode","","",102],[10,"assert_receiver_is_total_eq","","",102],[10,"eq","","",102],[10,"ne","","",102],[10,"ne","","",102],[10,"clone","","",102],[10,"clone_from","","",102],[10,"fmt","","",103],[10,"hash","","",103],[10,"decode","","",103],[10,"encode","","",103],[10,"assert_receiver_is_total_eq","","",103],[10,"eq","","",103],[10,"ne","","",103],[10,"ne","","",103],[10,"clone","","",103],[10,"clone_from","","",103],[10,"fmt","","",41],[10,"hash","","",41],[10,"decode","","",41],[10,"encode","","",41],[10,"assert_receiver_is_total_eq","","",41],[10,"eq","","",41],[10,"ne","","",41],[10,"ne","","",41],[10,"clone","","",41],[10,"clone_from","","",41],[10,"fmt","","",104],[10,"hash","","",104],[10,"decode","","",104],[10,"encode","","",104],[10,"assert_receiver_is_total_eq","","",104],[10,"eq","","",104],[10,"ne","","",104],[10,"ne","","",104],[10,"clone","","",104],[10,"clone_from","","",104],[10,"fmt","","",105],[10,"hash","","",105],[10,"decode","","",105],[10,"encode","","",105],[10,"assert_receiver_is_total_eq","","",105],[10,"eq","","",105],[10,"ne","","",105],[10,"ne","","",105],[10,"clone","","",105],[10,"clone_from","","",105],[10,"fmt","","",106],[10,"hash","","",106],[10,"decode","","",106],[10,"encode","","",106],[10,"assert_receiver_is_total_eq","","",106],[10,"eq","","",106],[10,"ne","","",106],[10,"ne","","",106],[10,"clone","","",106],[10,"clone_from","","",106],[10,"fmt","","",107],[10,"hash","","",107],[10,"decode","","",107],[10,"encode","","",107],[10,"assert_receiver_is_total_eq","","",107],[10,"eq","","",107],[10,"ne","","",107],[10,"ne","","",107],[10,"clone","","",107],[10,"clone_from","","",107],[10,"fmt","","",108],[10,"hash","","",108],[10,"decode","","",108],[10,"encode","","",108],[10,"assert_receiver_is_total_eq","","",108],[10,"eq","","",108],[10,"ne","","",108],[10,"ne","","",108],[10,"clone","","",108],[10,"clone_from","","",108],[10,"fmt","","",109],[10,"hash","","",109],[10,"decode","","",109],[10,"encode","","",109],[10,"assert_receiver_is_total_eq","","",109],[10,"eq","","",109],[10,"ne","","",109],[10,"ne","","",109],[10,"clone","","",109],[10,"clone_from","","",109],[10,"fmt","","",110],[10,"hash","","",110],[10,"decode","","",110],[10,"encode","","",110],[10,"assert_receiver_is_total_eq","","",110],[10,"eq","","",110],[10,"ne","","",110],[10,"ne","","",110],[10,"clone","","",110],[10,"clone_from","","",110],[10,"fmt","","",111],[10,"hash","","",111],[10,"decode","","",111],[10,"encode","","",111],[10,"assert_receiver_is_total_eq","","",111],[10,"eq","","",111],[10,"ne","","",111],[10,"ne","","",111],[10,"clone","","",111],[10,"clone_from","","",111],[10,"fmt","","",112],[10,"hash","","",112],[10,"decode","","",112],[10,"encode","","",112],[10,"assert_receiver_is_total_eq","","",112],[10,"eq","","",112],[10,"ne","","",112],[10,"ne","","",112],[10,"clone","","",112],[10,"clone_from","","",112],[10,"open_token","","Returns the opening delimiter as a token.",112],[10,"close_token","","Returns the closing delimiter as a token.",112],[10,"open_tt","","Returns the opening delimiter as a token tree.",112],[10,"close_tt","","Returns the closing delimiter as a token tree.",112],[10,"fmt","","",113],[10,"hash","","",113],[10,"decode","","",113],[10,"encode","","",113],[10,"assert_receiver_is_total_eq","","",113],[10,"eq","","",113],[10,"ne","","",113],[10,"ne","","",113],[10,"clone","","",113],[10,"clone_from","","",113],[10,"fmt","","",114],[10,"hash","","",114],[10,"decode","","",114],[10,"encode","","",114],[10,"assert_receiver_is_total_eq","","",114],[10,"eq","","",114],[10,"ne","","",114],[10,"ne","","",114],[10,"clone","","",114],[10,"clone_from","","",114],[10,"fmt","","",31],[10,"hash","","",31],[10,"decode","","",31],[10,"encode","","",31],[10,"assert_receiver_is_total_eq","","",31],[10,"eq","","",31],[10,"ne","","",31],[10,"ne","","",31],[10,"clone","","",31],[10,"clone_from","","",31],[10,"len","","",31],[10,"get_tt","","",31],[10,"get_span","","Returns the `Span` corresponding to this token tree.",31],[10,"fmt","","",115],[10,"hash","","",115],[10,"decode","","",115],[10,"encode","","",115],[10,"assert_receiver_is_total_eq","","",115],[10,"eq","","",115],[10,"ne","","",115],[10,"ne","","",115],[10,"clone","","",115],[10,"clone_from","","",115],[10,"fmt","","",116],[10,"hash","","",116],[10,"decode","","",116],[10,"encode","","",116],[10,"assert_receiver_is_total_eq","","",116],[10,"eq","","",116],[10,"ne","","",116],[10,"ne","","",116],[10,"clone","","",116],[10,"clone_from","","",116],[10,"fmt","","",117],[10,"hash","","",117],[10,"decode","","",117],[10,"encode","","",117],[10,"assert_receiver_is_total_eq","","",117],[10,"eq","","",117],[10,"ne","","",117],[10,"ne","","",117],[10,"clone","","",117],[10,"clone_from","","",117],[10,"new","","",117],[10,"fmt","","",118],[10,"hash","","",118],[10,"decode","","",118],[10,"encode","","",118],[10,"assert_receiver_is_total_eq","","",118],[10,"eq","","",118],[10,"ne","","",118],[10,"ne","","",118],[10,"clone","","",118],[10,"clone_from","","",118],[10,"suffix_len","","",118],[10,"fmt","","",119],[10,"hash","","",119],[10,"decode","","",119],[10,"encode","","",119],[10,"assert_receiver_is_total_eq","","",119],[10,"eq","","",119],[10,"ne","","",119],[10,"ne","","",119],[10,"clone","","",119],[10,"clone_from","","",119],[10,"fmt","","",120],[10,"hash","","",120],[10,"decode","","",120],[10,"encode","","",120],[10,"assert_receiver_is_total_eq","","",120],[10,"eq","","",120],[10,"ne","","",120],[10,"ne","","",120],[10,"clone","","",120],[10,"clone_from","","",120],[10,"fmt","","",121],[10,"hash","","",121],[10,"decode","","",121],[10,"encode","","",121],[10,"assert_receiver_is_total_eq","","",121],[10,"eq","","",121],[10,"ne","","",121],[10,"ne","","",121],[10,"clone","","",121],[10,"clone_from","","",121],[10,"fmt","","",122],[10,"hash","","",122],[10,"decode","","",122],[10,"encode","","",122],[10,"assert_receiver_is_total_eq","","",122],[10,"eq","","",122],[10,"ne","","",122],[10,"ne","","",122],[10,"clone","","",122],[10,"clone_from","","",122],[10,"fmt","","",123],[10,"hash","","",123],[10,"decode","","",123],[10,"encode","","",123],[10,"assert_receiver_is_total_eq","","",123],[10,"eq","","",123],[10,"ne","","",123],[10,"ne","","",123],[10,"clone","","",123],[10,"clone_from","","",123],[10,"fmt","","",124],[10,"hash","","",124],[10,"decode","","",124],[10,"encode","","",124],[10,"assert_receiver_is_total_eq","","",124],[10,"eq","","",124],[10,"ne","","",124],[10,"ne","","",124],[10,"clone","","",124],[10,"clone_from","","",124],[10,"fmt","","",125],[10,"hash","","",125],[10,"decode","","",125],[10,"encode","","",125],[10,"assert_receiver_is_total_eq","","",125],[10,"eq","","",125],[10,"ne","","",125],[10,"ne","","",125],[10,"clone","","",125],[10,"clone_from","","",125],[10,"fmt","","",126],[10,"hash","","",126],[10,"decode","","",126],[10,"encode","","",126],[10,"assert_receiver_is_total_eq","","",126],[10,"eq","","",126],[10,"ne","","",126],[10,"ne","","",126],[10,"clone","","",126],[10,"clone_from","","",126],[10,"hash","","",127],[10,"decode","","",127],[10,"encode","","",127],[10,"assert_receiver_is_total_eq","","",127],[10,"eq","","",127],[10,"ne","","",127],[10,"ne","","",127],[10,"clone","","",127],[10,"clone_from","","",127],[10,"fmt","","",127],[10,"suffix_len","","",127],[10,"hash","","",128],[10,"decode","","",128],[10,"encode","","",128],[10,"assert_receiver_is_total_eq","","",128],[10,"eq","","",128],[10,"ne","","",128],[10,"ne","","",128],[10,"clone","","",128],[10,"clone_from","","",128],[10,"suffix_len","","",128],[10,"fmt","","",128],[10,"hash","","",129],[10,"decode","","",129],[10,"encode","","",129],[10,"assert_receiver_is_total_eq","","",129],[10,"eq","","",129],[10,"ne","","",129],[10,"ne","","",129],[10,"clone","","",129],[10,"clone_from","","",129],[10,"fmt","","",129],[10,"suffix_len","","",129],[10,"fmt","","",130],[10,"hash","","",130],[10,"decode","","",130],[10,"encode","","",130],[10,"assert_receiver_is_total_eq","","",130],[10,"eq","","",130],[10,"ne","","",130],[10,"ne","","",130],[10,"clone","","",130],[10,"clone_from","","",130],[10,"fmt","","",36],[10,"hash","","",36],[10,"decode","","",36],[10,"encode","","",36],[10,"assert_receiver_is_total_eq","","",36],[10,"eq","","",36],[10,"ne","","",36],[10,"ne","","",36],[10,"clone","","",36],[10,"clone_from","","",36],[10,"fmt","","",131],[10,"hash","","",131],[10,"decode","","",131],[10,"encode","","",131],[10,"assert_receiver_is_total_eq","","",131],[10,"eq","","",131],[10,"ne","","",131],[10,"ne","","",131],[10,"clone","","",131],[10,"clone_from","","",131],[10,"hash","","",132],[10,"decode","","",132],[10,"encode","","",132],[10,"assert_receiver_is_total_eq","","",132],[10,"eq","","",132],[10,"ne","","",132],[10,"ne","","",132],[10,"clone","","",132],[10,"clone_from","","",132],[10,"fmt","","",132],[10,"fmt","","",133],[10,"hash","","",133],[10,"decode","","",133],[10,"encode","","",133],[10,"assert_receiver_is_total_eq","","",133],[10,"eq","","",133],[10,"ne","","",133],[10,"ne","","",133],[10,"clone","","",133],[10,"clone_from","","",133],[10,"fmt","","",134],[10,"hash","","",134],[10,"decode","","",134],[10,"encode","","",134],[10,"assert_receiver_is_total_eq","","",134],[10,"eq","","",134],[10,"ne","","",134],[10,"ne","","",134],[10,"clone","","",134],[10,"clone_from","","",134],[10,"fmt","","",135],[10,"hash","","",135],[10,"decode","","",135],[10,"encode","","",135],[10,"assert_receiver_is_total_eq","","",135],[10,"eq","","",135],[10,"ne","","",135],[10,"ne","","",135],[10,"clone","","",135],[10,"clone_from","","",135],[10,"fmt","","",136],[10,"hash","","",136],[10,"decode","","",136],[10,"encode","","",136],[10,"assert_receiver_is_total_eq","","",136],[10,"eq","","",136],[10,"ne","","",136],[10,"ne","","",136],[10,"clone","","",136],[10,"clone_from","","",136],[10,"fmt","","",137],[10,"hash","","",137],[10,"decode","","",137],[10,"encode","","",137],[10,"assert_receiver_is_total_eq","","",137],[10,"eq","","",137],[10,"ne","","",137],[10,"ne","","",137],[10,"clone","","",137],[10,"clone_from","","",137],[10,"fmt","","",38],[10,"hash","","",38],[10,"decode","","",38],[10,"encode","","",38],[10,"assert_receiver_is_total_eq","","",38],[10,"eq","","",38],[10,"ne","","",38],[10,"ne","","",38],[10,"clone","","",38],[10,"clone_from","","",38],[10,"new_self","","",38],[10,"fmt","","",138],[10,"hash","","",138],[10,"decode","","",138],[10,"encode","","",138],[10,"assert_receiver_is_total_eq","","",138],[10,"eq","","",138],[10,"ne","","",138],[10,"ne","","",138],[10,"clone","","",138],[10,"clone_from","","",138],[10,"hash","","",139],[10,"decode","","",139],[10,"encode","","",139],[10,"assert_receiver_is_total_eq","","",139],[10,"eq","","",139],[10,"ne","","",139],[10,"ne","","",139],[10,"clone","","",139],[10,"clone_from","","",139],[10,"fmt","","",139],[10,"fmt","","",140],[10,"hash","","",140],[10,"decode","","",140],[10,"encode","","",140],[10,"assert_receiver_is_total_eq","","",140],[10,"eq","","",140],[10,"ne","","",140],[10,"ne","","",140],[10,"clone","","",140],[10,"clone_from","","",140],[10,"span","","",140],[10,"fmt","","",141],[10,"hash","","",141],[10,"decode","","",141],[10,"encode","","",141],[10,"assert_receiver_is_total_eq","","",141],[10,"eq","","",141],[10,"ne","","",141],[10,"ne","","",141],[10,"clone","","",141],[10,"clone_from","","",141],[10,"fmt","","",142],[10,"hash","","",142],[10,"decode","","",142],[10,"encode","","",142],[10,"assert_receiver_is_total_eq","","",142],[10,"eq","","",142],[10,"ne","","",142],[10,"ne","","",142],[10,"clone","","",142],[10,"clone_from","","",142],[10,"fmt","","",143],[10,"hash","","",143],[10,"decode","","",143],[10,"encode","","",143],[10,"assert_receiver_is_total_eq","","",143],[10,"eq","","",143],[10,"ne","","",143],[10,"ne","","",143],[10,"clone","","",143],[10,"clone_from","","",143],[10,"fmt","","",144],[10,"hash","","",144],[10,"decode","","",144],[10,"encode","","",144],[10,"assert_receiver_is_total_eq","","",144],[10,"eq","","",144],[10,"ne","","",144],[10,"ne","","",144],[10,"clone","","",144],[10,"clone_from","","",144],[10,"fmt","","",145],[10,"hash","","",145],[10,"decode","","",145],[10,"encode","","",145],[10,"assert_receiver_is_total_eq","","",145],[10,"eq","","",145],[10,"ne","","",145],[10,"ne","","",145],[10,"clone","","",145],[10,"clone_from","","",145],[10,"fmt","","",146],[10,"hash","","",146],[10,"decode","","",146],[10,"encode","","",146],[10,"assert_receiver_is_total_eq","","",146],[10,"eq","","",146],[10,"ne","","",146],[10,"ne","","",146],[10,"clone","","",146],[10,"clone_from","","",146],[10,"fmt","","",147],[10,"hash","","",147],[10,"decode","","",147],[10,"encode","","",147],[10,"assert_receiver_is_total_eq","","",147],[10,"eq","","",147],[10,"ne","","",147],[10,"ne","","",147],[10,"clone","","",147],[10,"clone_from","","",147],[10,"fmt","","",148],[10,"hash","","",148],[10,"decode","","",148],[10,"encode","","",148],[10,"assert_receiver_is_total_eq","","",148],[10,"eq","","",148],[10,"ne","","",148],[10,"ne","","",148],[10,"clone","","",148],[10,"clone_from","","",148],[10,"fmt","","",149],[10,"hash","","",149],[10,"decode","","",149],[10,"encode","","",149],[10,"assert_receiver_is_total_eq","","",149],[10,"eq","","",149],[10,"ne","","",149],[10,"ne","","",149],[10,"clone","","",149],[10,"clone_from","","",149],[10,"fmt","","",150],[10,"hash","","",150],[10,"decode","","",150],[10,"encode","","",150],[10,"assert_receiver_is_total_eq","","",150],[10,"eq","","",150],[10,"ne","","",150],[10,"ne","","",150],[10,"clone","","",150],[10,"clone_from","","",150],[10,"id","","",150],[10,"fmt","","",151],[10,"hash","","",151],[10,"decode","","",151],[10,"encode","","",151],[10,"assert_receiver_is_total_eq","","",151],[10,"eq","","",151],[10,"ne","","",151],[10,"ne","","",151],[10,"clone","","",151],[10,"clone_from","","",151],[10,"fmt","","",152],[10,"hash","","",152],[10,"decode","","",152],[10,"encode","","",152],[10,"assert_receiver_is_total_eq","","",152],[10,"eq","","",152],[10,"ne","","",152],[10,"ne","","",152],[10,"clone","","",152],[10,"clone_from","","",152],[10,"fmt","","",153],[10,"hash","","",153],[10,"decode","","",153],[10,"encode","","",153],[10,"assert_receiver_is_total_eq","","",153],[10,"eq","","",153],[10,"ne","","",153],[10,"ne","","",153],[10,"clone","","",153],[10,"clone_from","","",153],[10,"fmt","","",154],[10,"hash","","",154],[10,"decode","","",154],[10,"encode","","",154],[10,"assert_receiver_is_total_eq","","",154],[10,"eq","","",154],[10,"ne","","",154],[10,"ne","","",154],[10,"clone","","",154],[10,"clone_from","","",154],[10,"fmt","","",155],[10,"hash","","",155],[10,"decode","","",155],[10,"encode","","",155],[10,"assert_receiver_is_total_eq","","",155],[10,"eq","","",155],[10,"ne","","",155],[10,"ne","","",155],[10,"clone","","",155],[10,"clone_from","","",155],[10,"fmt","","",42],[10,"hash","","",42],[10,"decode","","",42],[10,"encode","","",42],[10,"assert_receiver_is_total_eq","","",42],[10,"eq","","",42],[10,"ne","","",42],[10,"ne","","",42],[10,"clone","","",42],[10,"clone_from","","",42],[10,"fmt","","",156],[10,"hash","","",156],[10,"decode","","",156],[10,"encode","","",156],[10,"assert_receiver_is_total_eq","","",156],[10,"eq","","",156],[10,"ne","","",156],[10,"ne","","",156],[10,"clone","","",156],[10,"clone_from","","",156],[10,"fmt","","",157],[10,"hash","","",157],[10,"decode","","",157],[10,"encode","","",157],[10,"assert_receiver_is_total_eq","","",157],[10,"eq","","",157],[10,"ne","","",157],[10,"ne","","",157],[10,"clone","","",157],[10,"clone_from","","",157],[10,"fmt","","",158],[10,"hash","","",158],[10,"decode","","",158],[10,"encode","","",158],[10,"assert_receiver_is_total_eq","","",158],[10,"eq","","",158],[10,"ne","","",158],[10,"ne","","",158],[10,"clone","","",158],[10,"clone_from","","",158],[10,"inherit_from","","",158],[10,"fmt","","",159],[10,"hash","","",159],[10,"decode","","",159],[10,"encode","","",159],[10,"assert_receiver_is_total_eq","","",159],[10,"eq","","",159],[10,"ne","","",159],[10,"ne","","",159],[10,"clone","","",159],[10,"clone_from","","",159],[10,"ident","","",159],[10,"fmt","","",160],[10,"hash","","",160],[10,"decode","","",160],[10,"encode","","",160],[10,"assert_receiver_is_total_eq","","",160],[10,"eq","","",160],[10,"ne","","",160],[10,"ne","","",160],[10,"clone","","",160],[10,"clone_from","","",160],[10,"is_unnamed","","",160],[10,"fmt","","",161],[10,"hash","","",161],[10,"decode","","",161],[10,"encode","","",161],[10,"assert_receiver_is_total_eq","","",161],[10,"eq","","",161],[10,"ne","","",161],[10,"ne","","",161],[10,"clone","","",161],[10,"clone_from","","",161],[10,"fmt","","",162],[10,"hash","","",162],[10,"decode","","",162],[10,"encode","","",162],[10,"assert_receiver_is_total_eq","","",162],[10,"eq","","",162],[10,"ne","","",162],[10,"ne","","",162],[10,"clone","","",162],[10,"clone_from","","",162],[10,"fmt","","",163],[10,"hash","","",163],[10,"decode","","",163],[10,"encode","","",163],[10,"assert_receiver_is_total_eq","","",163],[10,"eq","","",163],[10,"ne","","",163],[10,"ne","","",163],[10,"clone","","",163],[10,"clone_from","","",163],[10,"descriptive_variant","","",163],[10,"fmt","","",164],[10,"hash","","",164],[10,"decode","","",164],[10,"encode","","",164],[10,"assert_receiver_is_total_eq","","",164],[10,"eq","","",164],[10,"ne","","",164],[10,"ne","","",164],[10,"clone","","",164],[10,"clone_from","","",164],[10,"fmt","","",165],[10,"hash","","",165],[10,"decode","","",165],[10,"encode","","",165],[10,"assert_receiver_is_total_eq","","",165],[10,"eq","","",165],[10,"ne","","",165],[10,"ne","","",165],[10,"clone","","",165],[10,"clone_from","","",165],[10,"descriptive_variant","","",165],[10,"fmt","","",166],[10,"hash","","",166],[10,"decode","","",166],[10,"encode","","",166],[10,"assert_receiver_is_total_eq","","",166],[10,"eq","","",166],[10,"ne","","",166],[10,"ne","","",166],[10,"clone","","",166],[10,"clone_from","","",166],[10,"fmt","","",167],[10,"hash","","",167],[10,"decode","","",167],[10,"encode","","",167],[10,"assert_receiver_is_total_eq","","",167],[10,"eq","","",167],[10,"ne","","",167],[10,"ne","","",167],[10,"clone","","",167],[10,"clone_from","","",167],[10,"eq","syntax::abi","",168],[10,"ne","","",168],[10,"ne","","",168],[10,"clone","","",169],[10,"clone_from","","",169],[10,"decode","","",169],[10,"encode","","",169],[10,"hash","","",169],[10,"assert_receiver_is_total_eq","","",169],[10,"eq","","",169],[10,"ne","","",169],[10,"ne","","",169],[10,"eq","","",170],[10,"ne","","",170],[10,"ne","","",170],[10,"index","","",169],[10,"data","","",169],[10,"name","","",169],[10,"fmt","","",169],[10,"fmt","","",168],[10,"is_fn_like","syntax::ast","",162],[10,"is_fn_like","","",123],[10,"is_fn_like","","",107],[10,"id","syntax::ast_map::blocks","",171],[10,"from_node","","Attempts to construct a Code from presumed FnLike or Block node input.",171],[10,"to_fn_parts","","",172],[10,"body","","",172],[10,"decl","","",172],[10,"span","","",172],[10,"id","","",172],[10,"kind","","",172],[10,"eq","syntax::ast_map","",173],[10,"ne","","",173],[10,"ne","","",173],[10,"clone","","",173],[10,"clone_from","","",173],[10,"name","","",173],[10,"fmt","","",173],[10,"clone","","",174],[10,"clone_from","","",174],[10,"next","core::option","",34],[10,"size_hint","","",34],[10,"clone","syntax::ast_map","",175],[10,"clone_from","","",175],[10,"next","","",175],[10,"size_hint","","",175],[10,"fmt","","",176],[10,"fmt","","",177],[10,"clone","","",177],[10,"clone_from","","",177],[10,"fmt","","",178],[10,"new","","",179],[10,"krate","","",179],[10,"krate","","",180],[10,"get","","Retrieve the Node corresponding to `id`, panicking if it cannot\nbe found.",180],[10,"find","","Retrieve the Node corresponding to `id`, returning None if\ncannot be found.",180],[10,"get_parent","","Retrieve the parent NodeId for `id`, or `id` itself if no\nparent is registered in this map.",180],[10,"get_parent_did","","",180],[10,"get_foreign_abi","","",180],[10,"get_foreign_vis","","",180],[10,"expect_item","","",180],[10,"expect_struct","","",180],[10,"expect_variant","","",180],[10,"expect_foreign_item","","",180],[10,"expect_expr","","",180],[10,"get_path_elem","","returns the name associated with the given NodeId's AST",180],[10,"with_path","","",180],[10,"path_to_string","","",180],[10,"with_attrs","","Given a node ID and a closure, apply the closure to the array\nof attributes associated with the AST corresponding to the Node ID",180],[10,"nodes_matching_suffix","","Returns an iterator that yields the node id's with paths that\nmatch `parts`.  (Requires `parts` is non-empty.)",180],[10,"opt_span","","",180],[10,"span","","",180],[10,"def_id_span","","",180],[10,"node_to_string","","",180],[10,"node_to_user_string","","",180],[10,"next","","",181],[10,"size_hint","","",181],[10,"name","syntax::codemap","",33],[10,"name","syntax::ast","",162],[10,"name","","",164],[10,"name","","",149],[10,"name","","",123],[10,"name","","",124],[10,"name","","",142],[10,"new_id","syntax::ast_map","",182],[10,"new_span","","",182],[10,"fold_crate","","",182],[10,"fold_meta_items","","",182],[10,"fold_meta_item","","",182],[10,"fold_view_path","","",182],[10,"fold_view_item","","",182],[10,"fold_foreign_item","","",182],[10,"fold_item","","",182],[10,"fold_item_simple","","",182],[10,"fold_struct_field","","",182],[10,"fold_item_underscore","","",182],[10,"fold_fn_decl","","",182],[10,"fold_type_method","","",182],[10,"fold_method","","",182],[10,"fold_block","","",182],[10,"fold_stmt","","",182],[10,"fold_arm","","",182],[10,"fold_pat","","",182],[10,"fold_decl","","",182],[10,"fold_expr","","",182],[10,"fold_ty","","",182],[10,"fold_qpath","","",182],[10,"fold_ty_binding","","",182],[10,"fold_mod","","",182],[10,"fold_foreign_mod","","",182],[10,"fold_variant","","",182],[10,"fold_ident","","",182],[10,"fold_uint","","",182],[10,"fold_path","","",182],[10,"fold_path_parameters","","",182],[10,"fold_angle_bracketed_parameter_data","","",182],[10,"fold_parenthesized_parameter_data","","",182],[10,"fold_local","","",182],[10,"fold_mac","","",182],[10,"fold_explicit_self","","",182],[10,"fold_explicit_self_underscore","","",182],[10,"fold_lifetime","","",182],[10,"fold_lifetime_def","","",182],[10,"fold_attribute","","",182],[10,"fold_arg","","",182],[10,"fold_generics","","",182],[10,"fold_trait_ref","","",182],[10,"fold_poly_trait_ref","","",182],[10,"fold_struct_def","","",182],[10,"fold_lifetimes","","",182],[10,"fold_lifetime_defs","","",182],[10,"fold_ty_param","","",182],[10,"fold_ty_params","","",182],[10,"fold_tt","","",182],[10,"fold_tts","","",182],[10,"fold_token","","",182],[10,"fold_interpolated","","",182],[10,"fold_opt_lifetime","","",182],[10,"fold_variant_arg","","",182],[10,"fold_opt_bounds","","",182],[10,"fold_bounds","","",182],[10,"fold_ty_param_bound","","",182],[10,"fold_mt","","",182],[10,"fold_field","","",182],[10,"fold_where_clause","","",182],[10,"fold_where_predicate","","",182],[10,"fold_typedef","","",182],[10,"fold_associated_type","","",182],[10,"new_id","","",182],[10,"new_span","","",182],[10,"visit_item","","",183],[10,"visit_pat","","",183],[10,"visit_expr","","",183],[10,"visit_stmt","","",183],[10,"visit_ty_method","","",183],[10,"visit_fn","","",183],[10,"visit_ty","","",183],[10,"visit_block","","",183],[10,"visit_lifetime_ref","","",183],[10,"visit_lifetime_def","","",183],[10,"visit_name","","",183],[10,"visit_ident","","",183],[10,"visit_mod","","",183],[10,"visit_view_item","","",183],[10,"visit_foreign_item","","",183],[10,"visit_item","","",183],[10,"visit_local","","",183],[10,"visit_block","","",183],[10,"visit_stmt","","",183],[10,"visit_arm","","",183],[10,"visit_pat","","",183],[10,"visit_decl","","",183],[10,"visit_expr","","",183],[10,"visit_expr_post","","",183],[10,"visit_ty","","",183],[10,"visit_generics","","",183],[10,"visit_fn","","",183],[10,"visit_ty_method","","",183],[10,"visit_trait_item","","",183],[10,"visit_trait_ref","","",183],[10,"visit_ty_param_bound","","",183],[10,"visit_poly_trait_ref","","",183],[10,"visit_struct_def","","",183],[10,"visit_struct_field","","",183],[10,"visit_variant","","",183],[10,"visit_opt_lifetime_ref","","",183],[10,"visit_lifetime_bound","","",183],[10,"visit_lifetime_ref","","",183],[10,"visit_lifetime_def","","",183],[10,"visit_explicit_self","","",183],[10,"visit_mac","","",183],[10,"visit_path","","",183],[10,"visit_path_segment","","",183],[10,"visit_path_parameters","","",183],[10,"visit_assoc_type_binding","","",183],[10,"visit_attribute","","",183],[10,"print_node","syntax::print::pprust","",184],[10,"fmt","syntax::ast_util","",185],[10,"decode","","",185],[10,"encode","","",185],[10,"max","","",185],[10,"empty","","",185],[10,"add","","",185],[10,"visit_mod","","",186],[10,"visit_view_item","","",186],[10,"visit_foreign_item","","",186],[10,"visit_item","","",186],[10,"visit_local","","",186],[10,"visit_block","","",186],[10,"visit_stmt","","",186],[10,"visit_pat","","",186],[10,"visit_expr","","",186],[10,"visit_ty","","",186],[10,"visit_generics","","",186],[10,"visit_fn","","",186],[10,"visit_struct_field","","",186],[10,"visit_struct_def","","",186],[10,"visit_trait_item","","",186],[10,"visit_lifetime_ref","","",186],[10,"visit_lifetime_def","","",186],[10,"visit_name","","",186],[10,"visit_ident","","",186],[10,"visit_mod","","",186],[10,"visit_view_item","","",186],[10,"visit_foreign_item","","",186],[10,"visit_item","","",186],[10,"visit_local","","",186],[10,"visit_block","","",186],[10,"visit_stmt","","",186],[10,"visit_arm","","",186],[10,"visit_pat","","",186],[10,"visit_decl","","",186],[10,"visit_expr","","",186],[10,"visit_expr_post","","",186],[10,"visit_ty","","",186],[10,"visit_generics","","",186],[10,"visit_fn","","",186],[10,"visit_ty_method","","",186],[10,"visit_trait_item","","",186],[10,"visit_trait_ref","","",186],[10,"visit_ty_param_bound","","",186],[10,"visit_poly_trait_ref","","",186],[10,"visit_struct_def","","",186],[10,"visit_struct_field","","",186],[10,"visit_variant","","",186],[10,"visit_opt_lifetime_ref","","",186],[10,"visit_lifetime_bound","","",186],[10,"visit_lifetime_ref","","",186],[10,"visit_lifetime_def","","",186],[10,"visit_explicit_self","","",186],[10,"visit_mac","","",186],[10,"visit_path","","",186],[10,"visit_path_segment","","",186],[10,"visit_path_parameters","","",186],[10,"visit_assoc_type_binding","","",186],[10,"visit_attribute","","",186],[10,"visit_id","","",187],[10,"visit_view_item","","",188],[10,"visit_name","","",188],[10,"visit_ident","","",188],[10,"visit_mod","","",188],[10,"visit_view_item","","",188],[10,"visit_foreign_item","","",188],[10,"visit_item","","",188],[10,"visit_local","","",188],[10,"visit_block","","",188],[10,"visit_stmt","","",188],[10,"visit_arm","","",188],[10,"visit_pat","","",188],[10,"visit_decl","","",188],[10,"visit_expr","","",188],[10,"visit_expr_post","","",188],[10,"visit_ty","","",188],[10,"visit_generics","","",188],[10,"visit_fn","","",188],[10,"visit_ty_method","","",188],[10,"visit_trait_item","","",188],[10,"visit_trait_ref","","",188],[10,"visit_ty_param_bound","","",188],[10,"visit_poly_trait_ref","","",188],[10,"visit_struct_def","","",188],[10,"visit_struct_field","","",188],[10,"visit_variant","","",188],[10,"visit_opt_lifetime_ref","","",188],[10,"visit_lifetime_bound","","",188],[10,"visit_lifetime_ref","","",188],[10,"visit_lifetime_def","","",188],[10,"visit_explicit_self","","",188],[10,"visit_mac","","",188],[10,"visit_path","","",188],[10,"visit_path_segment","","",188],[10,"visit_path_parameters","","",188],[10,"visit_assoc_type_binding","","",188],[10,"visit_attribute","","",188],[10,"each_view_item","syntax::ast","",89],[10,"pe_ident","","",142],[10,"pe_generics","","",142],[10,"pe_abi","","",142],[10,"pe_explicit_self","","",142],[10,"pe_unsafety","","",142],[10,"pe_fn_decl","","",142],[10,"pe_body","","",142],[10,"pe_vis","","",142],[10,"check_name","syntax::codemap","",33],[10,"name","","",33],[10,"value_str","","",33],[10,"meta_item_list","","",33],[10,"check_name","","",33],[10,"name","","",33],[10,"value_str","","",33],[10,"meta_item_list","","",33],[10,"check_name","","",33],[10,"name","syntax::ptr","",40],[10,"value_str","","",40],[10,"meta_item_list","","",40],[10,"check_name","","",40],[10,"meta","syntax::codemap","Extract the MetaItem from inside this Attribute.",33],[10,"with_desugared_doc","","Convert self to a normal #[doc=\"foo\"] comment, if it is a\ncomment like `///` or `/** */`. (Returns self unchanged for\nnon-sugared doc attributes.)",33],[10,"eq","syntax::attr","",189],[10,"ne","","",189],[10,"ne","","",189],[10,"fmt","","",190],[10,"clone","","",190],[10,"clone_from","","",190],[10,"decode","","",190],[10,"encode","","",190],[10,"fmt","","",191],[10,"clone","","",191],[10,"clone_from","","",191],[10,"partial_cmp","","",191],[10,"lt","","",191],[10,"le","","",191],[10,"gt","","",191],[10,"ge","","",191],[10,"lt","","",191],[10,"le","","",191],[10,"gt","","",191],[10,"ge","","",191],[10,"eq","","",191],[10,"ne","","",191],[10,"ne","","",191],[10,"decode","","",191],[10,"encode","","",191],[10,"decode","","",192],[10,"encode","","",192],[10,"fmt","","",192],[10,"eq","","",192],[10,"ne","","",192],[10,"ne","","",192],[10,"is_ffi_safe","","",192],[10,"decode","","",193],[10,"encode","","",193],[10,"fmt","","",193],[10,"eq","","",193],[10,"ne","","",193],[10,"ne","","",193],[10,"hash","","",193],[10,"assert_receiver_is_total_eq","","",193],[10,"is_signed","","",193],[10,"fmt","syntax::codemap","",194],[10,"partial_cmp","","",194],[10,"lt","","",194],[10,"le","","",194],[10,"gt","","",194],[10,"ge","","",194],[10,"lt","","",194],[10,"le","","",194],[10,"gt","","",194],[10,"ge","","",194],[10,"hash","","",194],[10,"assert_receiver_is_total_eq","","",194],[10,"eq","","",194],[10,"ne","","",194],[10,"ne","","",194],[10,"clone","","",194],[10,"clone_from","","",194],[10,"fmt","","",195],[10,"partial_cmp","","",195],[10,"lt","","",195],[10,"le","","",195],[10,"gt","","",195],[10,"ge","","",195],[10,"lt","","",195],[10,"le","","",195],[10,"gt","","",195],[10,"ge","","",195],[10,"hash","","",195],[10,"eq","","",195],[10,"ne","","",195],[10,"ne","","",195],[10,"from_uint","","",194],[10,"to_uint","","",194],[10,"add","","",194],[10,"sub","","",194],[10,"from_uint","","",195],[10,"to_uint","","",195],[10,"add","","",195],[10,"sub","","",195],[10,"hash","","",196],[10,"fmt","","",196],[10,"clone","","",196],[10,"clone_from","","",196],[10,"fmt","","",33],[10,"hash","","",33],[10,"decode","","",33],[10,"encode","","",33],[10,"assert_receiver_is_total_eq","","",33],[10,"eq","","",33],[10,"ne","","",33],[10,"ne","","",33],[10,"clone","","",33],[10,"clone_from","","",33],[10,"eq","","",196],[10,"ne","","",196],[10,"ne","","",196],[10,"assert_receiver_is_total_eq","","",196],[10,"encode","","",196],[10,"decode","","",196],[10,"fmt","","",197],[10,"hash","","",197],[10,"clone","","",197],[10,"clone_from","","",197],[10,"fmt","","",198],[10,"hash","","",198],[10,"clone","","",198],[10,"clone_from","","",198],[10,"fmt","","",199],[10,"hash","","",199],[10,"decode","","",200],[10,"encode","","",200],[10,"hash","","",200],[10,"fmt","","",200],[10,"clone","","",200],[10,"clone_from","","",200],[10,"assert_receiver_is_total_eq","","",200],[10,"eq","","",200],[10,"ne","","",200],[10,"ne","","",200],[10,"from_llvm_cookie","","",200],[10,"to_llvm_cookie","","",200],[10,"next_line","","EFFECT: register a start-of-line offset in the\ntable of line-beginnings.\nUNCHECKED INVARIANT: these offsets must be added in the right\norder and must be in the right places; there is shared knowledge\nabout what ends a line between this file and parse.rs\nWARNING: pos param here is the offset relative to start of CodeMap,\nand CodeMap will append a newline when adding a filemap without a newline at the end,\nso the safe way to call this is with value calculated as\nfilemap.start_pos + newline_offset_relative_to_the_start_of_filemap.",201],[10,"get_line","","get a line from the list of pre-computed line-beginnings\n",201],[10,"record_multibyte_char","","",201],[10,"is_real_file","","",201],[10,"new","","",202],[10,"new_filemap","","",202],[10,"mk_substr_filename","","",202],[10,"lookup_char_pos","","Lookup source information about a BytePos",202],[10,"lookup_char_pos_adj","","",202],[10,"span_to_string","","",202],[10,"span_to_filename","","",202],[10,"span_to_lines","","",202],[10,"span_to_snippet","","",202],[10,"get_filemap","","",202],[10,"lookup_byte_offset","","",202],[10,"bytepos_to_file_charpos","","Converts an absolute BytePos to a CharPos relative to the filemap and above.",202],[10,"record_expansion","","",202],[10,"with_expn_info","","",202],[10,"span_is_internal","","Check if a span is \"internal\" to a macro. This means that it is entirely generated by a\nmacro expansion and contains no code that was passed in as an argument.",202],[10,"fold_mod","syntax::config","",203],[10,"fold_block","","",203],[10,"fold_foreign_mod","","",203],[10,"fold_item_underscore","","",203],[10,"fold_expr","","",203],[10,"fold_mac","","",203],[10,"fold_item","","",203],[10,"fold_crate","","",203],[10,"fold_meta_items","","",203],[10,"fold_meta_item","","",203],[10,"fold_view_path","","",203],[10,"fold_view_item","","",203],[10,"fold_foreign_item","","",203],[10,"fold_item","","",203],[10,"fold_item_simple","","",203],[10,"fold_struct_field","","",203],[10,"fold_item_underscore","","",203],[10,"fold_fn_decl","","",203],[10,"fold_type_method","","",203],[10,"fold_method","","",203],[10,"fold_block","","",203],[10,"fold_stmt","","",203],[10,"fold_arm","","",203],[10,"fold_pat","","",203],[10,"fold_decl","","",203],[10,"fold_expr","","",203],[10,"fold_ty","","",203],[10,"fold_qpath","","",203],[10,"fold_ty_binding","","",203],[10,"fold_mod","","",203],[10,"fold_foreign_mod","","",203],[10,"fold_variant","","",203],[10,"fold_ident","","",203],[10,"fold_uint","","",203],[10,"fold_path","","",203],[10,"fold_path_parameters","","",203],[10,"fold_angle_bracketed_parameter_data","","",203],[10,"fold_parenthesized_parameter_data","","",203],[10,"fold_local","","",203],[10,"fold_mac","","",203],[10,"fold_explicit_self","","",203],[10,"fold_explicit_self_underscore","","",203],[10,"fold_lifetime","","",203],[10,"fold_lifetime_def","","",203],[10,"fold_attribute","","",203],[10,"fold_arg","","",203],[10,"fold_generics","","",203],[10,"fold_trait_ref","","",203],[10,"fold_poly_trait_ref","","",203],[10,"fold_struct_def","","",203],[10,"fold_lifetimes","","",203],[10,"fold_lifetime_defs","","",203],[10,"fold_ty_param","","",203],[10,"fold_ty_params","","",203],[10,"fold_tt","","",203],[10,"fold_tts","","",203],[10,"fold_token","","",203],[10,"fold_interpolated","","",203],[10,"fold_opt_lifetime","","",203],[10,"fold_variant_arg","","",203],[10,"fold_opt_bounds","","",203],[10,"fold_bounds","","",203],[10,"fold_ty_param_bound","","",203],[10,"fold_mt","","",203],[10,"fold_field","","",203],[10,"fold_where_clause","","",203],[10,"fold_where_predicate","","",203],[10,"fold_typedef","","",203],[10,"fold_associated_type","","",203],[10,"new_id","","",203],[10,"new_span","","",203],[10,"clone","syntax::diagnostic","",204],[10,"clone_from","","",204],[10,"clone","","",205],[10,"clone_from","","",205],[10,"span_fatal","","",206],[10,"span_err","","",206],[10,"span_err_with_code","","",206],[10,"span_warn","","",206],[10,"span_warn_with_code","","",206],[10,"span_note","","",206],[10,"span_end_note","","",206],[10,"span_help","","",206],[10,"fileline_note","","",206],[10,"span_bug","","",206],[10,"span_unimpl","","",206],[10,"handler","","",206],[10,"fatal","","",207],[10,"err","","",207],[10,"bump_err_count","","",207],[10,"err_count","","",207],[10,"has_errors","","",207],[10,"abort_if_errors","","",207],[10,"warn","","",207],[10,"note","","",207],[10,"help","","",207],[10,"bug","","",207],[10,"unimpl","","",207],[10,"emit","","",207],[10,"emit_with_code","","",207],[10,"custom_emit","","",207],[10,"clone","","",208],[10,"clone_from","","",208],[10,"eq","","",208],[10,"ne","","",208],[10,"ne","","",208],[10,"fmt","","",208],[10,"stderr","","",209],[10,"new","","",209],[10,"write","","",210],[10,"flush","","",210],[10,"write_fmt","","",210],[10,"write_str","","",210],[10,"write_line","","",210],[10,"write_char","","",210],[10,"write_int","","",210],[10,"write_uint","","",210],[10,"write_le_uint","","",210],[10,"write_le_int","","",210],[10,"write_be_uint","","",210],[10,"write_be_int","","",210],[10,"write_be_u64","","",210],[10,"write_be_u32","","",210],[10,"write_be_u16","","",210],[10,"write_be_i64","","",210],[10,"write_be_i32","","",210],[10,"write_be_i16","","",210],[10,"write_be_f64","","",210],[10,"write_be_f32","","",210],[10,"write_le_u64","","",210],[10,"write_le_u32","","",210],[10,"write_le_u16","","",210],[10,"write_le_i64","","",210],[10,"write_le_i32","","",210],[10,"write_le_i16","","",210],[10,"write_le_f64","","",210],[10,"write_le_f32","","",210],[10,"write_u8","","",210],[10,"write_i8","","",210],[10,"emit","","",209],[10,"custom_emit","","",209],[10,"new","syntax::feature_gate","",211],[10,"visit_view_item","","",212],[10,"visit_mac","","",212],[10,"visit_name","","",212],[10,"visit_ident","","",212],[10,"visit_mod","","",212],[10,"visit_view_item","","",212],[10,"visit_foreign_item","","",212],[10,"visit_item","","",212],[10,"visit_local","","",212],[10,"visit_block","","",212],[10,"visit_stmt","","",212],[10,"visit_arm","","",212],[10,"visit_pat","","",212],[10,"visit_decl","","",212],[10,"visit_expr","","",212],[10,"visit_expr_post","","",212],[10,"visit_ty","","",212],[10,"visit_generics","","",212],[10,"visit_fn","","",212],[10,"visit_ty_method","","",212],[10,"visit_trait_item","","",212],[10,"visit_trait_ref","","",212],[10,"visit_ty_param_bound","","",212],[10,"visit_poly_trait_ref","","",212],[10,"visit_struct_def","","",212],[10,"visit_struct_field","","",212],[10,"visit_variant","","",212],[10,"visit_opt_lifetime_ref","","",212],[10,"visit_lifetime_bound","","",212],[10,"visit_lifetime_ref","","",212],[10,"visit_lifetime_def","","",212],[10,"visit_explicit_self","","",212],[10,"visit_mac","","",212],[10,"visit_path","","",212],[10,"visit_path_segment","","",212],[10,"visit_path_parameters","","",212],[10,"visit_assoc_type_binding","","",212],[10,"visit_attribute","","",212],[10,"visit_name","","",213],[10,"visit_view_item","","",213],[10,"visit_item","","",213],[10,"visit_trait_item","","",213],[10,"visit_foreign_item","","",213],[10,"visit_ty","","",213],[10,"visit_expr","","",213],[10,"visit_generics","","",213],[10,"visit_attribute","","",213],[10,"visit_pat","","",213],[10,"visit_fn","","",213],[10,"visit_name","","",213],[10,"visit_ident","","",213],[10,"visit_mod","","",213],[10,"visit_view_item","","",213],[10,"visit_foreign_item","","",213],[10,"visit_item","","",213],[10,"visit_local","","",213],[10,"visit_block","","",213],[10,"visit_stmt","","",213],[10,"visit_arm","","",213],[10,"visit_pat","","",213],[10,"visit_decl","","",213],[10,"visit_expr","","",213],[10,"visit_expr_post","","",213],[10,"visit_ty","","",213],[10,"visit_generics","","",213],[10,"visit_fn","","",213],[10,"visit_ty_method","","",213],[10,"visit_trait_item","","",213],[10,"visit_trait_ref","","",213],[10,"visit_ty_param_bound","","",213],[10,"visit_poly_trait_ref","","",213],[10,"visit_struct_def","","",213],[10,"visit_struct_field","","",213],[10,"visit_variant","","",213],[10,"visit_opt_lifetime_ref","","",213],[10,"visit_lifetime_bound","","",213],[10,"visit_lifetime_ref","","",213],[10,"visit_lifetime_def","","",213],[10,"visit_explicit_self","","",213],[10,"visit_mac","","",213],[10,"visit_path","","",213],[10,"visit_path_segment","","",213],[10,"visit_path_parameters","","",213],[10,"visit_assoc_type_binding","","",213],[10,"visit_attribute","","",213],[10,"move_map","collections::vec","",32],[10,"move_map","syntax::owned_slice","",214],[10,"cmp","","",214],[10,"partial_cmp","","",214],[10,"lt","","",214],[10,"le","","",214],[10,"gt","","",214],[10,"ge","","",214],[10,"lt","","",214],[10,"le","","",214],[10,"gt","","",214],[10,"ge","","",214],[10,"assert_receiver_is_total_eq","","",214],[10,"eq","","",214],[10,"ne","","",214],[10,"ne","","",214],[10,"hash","","",214],[10,"fmt","","",214],[10,"empty","","",214],[10,"from_vec","","",214],[10,"into_vec","","",214],[10,"as_slice","","",214],[10,"move_iter","","",214],[10,"map","","",214],[10,"deref","","",214],[10,"default","","",214],[10,"clone","","",214],[10,"clone_from","","",214],[10,"from_iter","","",214],[10,"encode","","",214],[10,"decode","","",214],[10,"and_then","syntax::ptr","Move out of the pointer.\nIntended for chaining transformations not covered by `map`.",40],[10,"map","","Transform the inner value, consuming `self` and producing a new `P<T>`.",40],[10,"deref","","",40],[10,"clone","","",40],[10,"clone_from","","",40],[10,"eq","","",40],[10,"ne","","",40],[10,"assert_receiver_is_total_eq","","",40],[10,"fmt","","",40],[10,"hash","","",40],[10,"decode","","",40],[10,"encode","","",40],[10,"visit_expr","syntax::show_span","",215],[10,"visit_mac","","",215],[10,"visit_name","","",215],[10,"visit_ident","","",215],[10,"visit_mod","","",215],[10,"visit_view_item","","",215],[10,"visit_foreign_item","","",215],[10,"visit_item","","",215],[10,"visit_local","","",215],[10,"visit_block","","",215],[10,"visit_stmt","","",215],[10,"visit_arm","","",215],[10,"visit_pat","","",215],[10,"visit_decl","","",215],[10,"visit_expr","","",215],[10,"visit_expr_post","","",215],[10,"visit_ty","","",215],[10,"visit_generics","","",215],[10,"visit_fn","","",215],[10,"visit_ty_method","","",215],[10,"visit_trait_item","","",215],[10,"visit_trait_ref","","",215],[10,"visit_ty_param_bound","","",215],[10,"visit_poly_trait_ref","","",215],[10,"visit_struct_def","","",215],[10,"visit_struct_field","","",215],[10,"visit_variant","","",215],[10,"visit_opt_lifetime_ref","","",215],[10,"visit_lifetime_bound","","",215],[10,"visit_lifetime_ref","","",215],[10,"visit_lifetime_def","","",215],[10,"visit_explicit_self","","",215],[10,"visit_mac","","",215],[10,"visit_path","","",215],[10,"visit_path_segment","","",215],[10,"visit_path_parameters","","",215],[10,"visit_assoc_type_binding","","",215],[10,"visit_attribute","","",215],[10,"fold_crate","syntax::std_inject","",216],[10,"fold_crate","","",216],[10,"fold_meta_items","","",216],[10,"fold_meta_item","","",216],[10,"fold_view_path","","",216],[10,"fold_view_item","","",216],[10,"fold_foreign_item","","",216],[10,"fold_item","","",216],[10,"fold_item_simple","","",216],[10,"fold_struct_field","","",216],[10,"fold_item_underscore","","",216],[10,"fold_fn_decl","","",216],[10,"fold_type_method","","",216],[10,"fold_method","","",216],[10,"fold_block","","",216],[10,"fold_stmt","","",216],[10,"fold_arm","","",216],[10,"fold_pat","","",216],[10,"fold_decl","","",216],[10,"fold_expr","","",216],[10,"fold_ty","","",216],[10,"fold_qpath","","",216],[10,"fold_ty_binding","","",216],[10,"fold_mod","","",216],[10,"fold_foreign_mod","","",216],[10,"fold_variant","","",216],[10,"fold_ident","","",216],[10,"fold_uint","","",216],[10,"fold_path","","",216],[10,"fold_path_parameters","","",216],[10,"fold_angle_bracketed_parameter_data","","",216],[10,"fold_parenthesized_parameter_data","","",216],[10,"fold_local","","",216],[10,"fold_mac","","",216],[10,"fold_explicit_self","","",216],[10,"fold_explicit_self_underscore","","",216],[10,"fold_lifetime","","",216],[10,"fold_lifetime_def","","",216],[10,"fold_attribute","","",216],[10,"fold_arg","","",216],[10,"fold_generics","","",216],[10,"fold_trait_ref","","",216],[10,"fold_poly_trait_ref","","",216],[10,"fold_struct_def","","",216],[10,"fold_lifetimes","","",216],[10,"fold_lifetime_defs","","",216],[10,"fold_ty_param","","",216],[10,"fold_ty_params","","",216],[10,"fold_tt","","",216],[10,"fold_tts","","",216],[10,"fold_token","","",216],[10,"fold_interpolated","","",216],[10,"fold_opt_lifetime","","",216],[10,"fold_variant_arg","","",216],[10,"fold_opt_bounds","","",216],[10,"fold_bounds","","",216],[10,"fold_ty_param_bound","","",216],[10,"fold_mt","","",216],[10,"fold_field","","",216],[10,"fold_where_clause","","",216],[10,"fold_where_predicate","","",216],[10,"fold_typedef","","",216],[10,"fold_associated_type","","",216],[10,"new_id","","",216],[10,"new_span","","",216],[10,"fold_crate","","",217],[10,"fold_item","","",217],[10,"fold_mod","","",217],[10,"fold_crate","","",217],[10,"fold_meta_items","","",217],[10,"fold_meta_item","","",217],[10,"fold_view_path","","",217],[10,"fold_view_item","","",217],[10,"fold_foreign_item","","",217],[10,"fold_item","","",217],[10,"fold_item_simple","","",217],[10,"fold_struct_field","","",217],[10,"fold_item_underscore","","",217],[10,"fold_fn_decl","","",217],[10,"fold_type_method","","",217],[10,"fold_method","","",217],[10,"fold_block","","",217],[10,"fold_stmt","","",217],[10,"fold_arm","","",217],[10,"fold_pat","","",217],[10,"fold_decl","","",217],[10,"fold_expr","","",217],[10,"fold_ty","","",217],[10,"fold_qpath","","",217],[10,"fold_ty_binding","","",217],[10,"fold_mod","","",217],[10,"fold_foreign_mod","","",217],[10,"fold_variant","","",217],[10,"fold_ident","","",217],[10,"fold_uint","","",217],[10,"fold_path","","",217],[10,"fold_path_parameters","","",217],[10,"fold_angle_bracketed_parameter_data","","",217],[10,"fold_parenthesized_parameter_data","","",217],[10,"fold_local","","",217],[10,"fold_mac","","",217],[10,"fold_explicit_self","","",217],[10,"fold_explicit_self_underscore","","",217],[10,"fold_lifetime","","",217],[10,"fold_lifetime_def","","",217],[10,"fold_attribute","","",217],[10,"fold_arg","","",217],[10,"fold_generics","","",217],[10,"fold_trait_ref","","",217],[10,"fold_poly_trait_ref","","",217],[10,"fold_struct_def","","",217],[10,"fold_lifetimes","","",217],[10,"fold_lifetime_defs","","",217],[10,"fold_ty_param","","",217],[10,"fold_ty_params","","",217],[10,"fold_tt","","",217],[10,"fold_tts","","",217],[10,"fold_token","","",217],[10,"fold_interpolated","","",217],[10,"fold_opt_lifetime","","",217],[10,"fold_variant_arg","","",217],[10,"fold_opt_bounds","","",217],[10,"fold_bounds","","",217],[10,"fold_ty_param_bound","","",217],[10,"fold_mt","","",217],[10,"fold_field","","",217],[10,"fold_where_clause","","",217],[10,"fold_where_predicate","","",217],[10,"fold_typedef","","",217],[10,"fold_associated_type","","",217],[10,"new_id","","",217],[10,"new_span","","",217],[10,"fold_crate","syntax::test","",218],[10,"fold_item","","",218],[10,"fold_mod","","",218],[10,"fold_crate","","",218],[10,"fold_meta_items","","",218],[10,"fold_meta_item","","",218],[10,"fold_view_path","","",218],[10,"fold_view_item","","",218],[10,"fold_foreign_item","","",218],[10,"fold_item","","",218],[10,"fold_item_simple","","",218],[10,"fold_struct_field","","",218],[10,"fold_item_underscore","","",218],[10,"fold_fn_decl","","",218],[10,"fold_type_method","","",218],[10,"fold_method","","",218],[10,"fold_block","","",218],[10,"fold_stmt","","",218],[10,"fold_arm","","",218],[10,"fold_pat","","",218],[10,"fold_decl","","",218],[10,"fold_expr","","",218],[10,"fold_ty","","",218],[10,"fold_qpath","","",218],[10,"fold_ty_binding","","",218],[10,"fold_mod","","",218],[10,"fold_foreign_mod","","",218],[10,"fold_variant","","",218],[10,"fold_ident","","",218],[10,"fold_uint","","",218],[10,"fold_path","","",218],[10,"fold_path_parameters","","",218],[10,"fold_angle_bracketed_parameter_data","","",218],[10,"fold_parenthesized_parameter_data","","",218],[10,"fold_local","","",218],[10,"fold_mac","","",218],[10,"fold_explicit_self","","",218],[10,"fold_explicit_self_underscore","","",218],[10,"fold_lifetime","","",218],[10,"fold_lifetime_def","","",218],[10,"fold_attribute","","",218],[10,"fold_arg","","",218],[10,"fold_generics","","",218],[10,"fold_trait_ref","","",218],[10,"fold_poly_trait_ref","","",218],[10,"fold_struct_def","","",218],[10,"fold_lifetimes","","",218],[10,"fold_lifetime_defs","","",218],[10,"fold_ty_param","","",218],[10,"fold_ty_params","","",218],[10,"fold_tt","","",218],[10,"fold_tts","","",218],[10,"fold_token","","",218],[10,"fold_interpolated","","",218],[10,"fold_opt_lifetime","","",218],[10,"fold_variant_arg","","",218],[10,"fold_opt_bounds","","",218],[10,"fold_bounds","","",218],[10,"fold_ty_param_bound","","",218],[10,"fold_mt","","",218],[10,"fold_field","","",218],[10,"fold_where_clause","","",218],[10,"fold_where_predicate","","",218],[10,"fold_typedef","","",218],[10,"fold_associated_type","","",218],[10,"new_id","","",218],[10,"new_span","","",218],[10,"eq","","",219],[10,"ne","","",219],[10,"ne","","",219],[10,"eq","syntax::print::pp","",220],[10,"ne","","",220],[10,"ne","","",220],[10,"clone","","",220],[10,"clone_from","","",220],[10,"clone","","",221],[10,"clone_from","","",221],[10,"clone","","",222],[10,"clone_from","","",222],[10,"clone","","",223],[10,"clone_from","","",223],[10,"is_eof","","",223],[10,"is_hardbreak_tok","","",223],[10,"last_token","","",224],[10,"replace_last_token","","",224],[10,"pretty_print","","",224],[10,"check_stream","","",224],[10,"scan_push","","",224],[10,"scan_pop","","",224],[10,"scan_top","","",224],[10,"scan_pop_bottom","","",224],[10,"advance_right","","",224],[10,"advance_left","","",224],[10,"check_stack","","",224],[10,"print_newline","","",224],[10,"indent","","",224],[10,"get_top","","",224],[10,"print_str","","",224],[10,"print","","",224],[10,"pre","syntax::print::pprust","",225],[10,"post","","",225],[10,"new_from_input","","",184],[10,"new","","",184],[10,"ibox","","",184],[10,"end","","",184],[10,"cbox","","",184],[10,"rbox","","",184],[10,"nbsp","","",184],[10,"word_nbsp","","",184],[10,"word_space","","",184],[10,"popen","","",184],[10,"pclose","","",184],[10,"head","","",184],[10,"bopen","","",184],[10,"bclose_","","",184],[10,"bclose_maybe_open","","",184],[10,"bclose","","",184],[10,"is_begin","","",184],[10,"is_end","","",184],[10,"is_bol","","",184],[10,"in_cbox","","",184],[10,"hardbreak_if_not_bol","","",184],[10,"space_if_not_bol","","",184],[10,"break_offset_if_not_bol","","",184],[10,"synth_comment","","",184],[10,"commasep","","",184],[10,"commasep_cmnt","","",184],[10,"commasep_exprs","","",184],[10,"print_mod","","",184],[10,"print_foreign_mod","","",184],[10,"print_opt_lifetime","","",184],[10,"print_type","","",184],[10,"print_foreign_item","","",184],[10,"print_item","","Pretty-print an item",184],[10,"print_enum_def","","",184],[10,"print_variants","","",184],[10,"print_visibility","","",184],[10,"print_struct","","",184],[10,"print_tt","","This doesn't deserve to be called \"pretty\" printing, but it should be\nmeaning-preserving. A quick hack that might help would be to look at the\nspans embedded in the TTs to decide where to put spaces and newlines.\nBut it'd be better to parse these according to the grammar of the\nappropriate macro, transcribe back into the grammar we just parsed from,\nand then pretty-print the resulting AST nodes (so, e.g., we print\nexpression arguments as expressions). It can be done! I think.",184],[10,"print_tts","","",184],[10,"print_variant","","",184],[10,"print_ty_method","","",184],[10,"print_trait_method","","",184],[10,"print_impl_item","","",184],[10,"print_method","","",184],[10,"print_outer_attributes","","",184],[10,"print_inner_attributes","","",184],[10,"print_attribute","","",184],[10,"print_stmt","","",184],[10,"print_block","","",184],[10,"print_block_unclosed","","",184],[10,"print_block_unclosed_indent","","",184],[10,"print_block_with_attrs","","",184],[10,"print_block_maybe_unclosed","","",184],[10,"print_if","","",184],[10,"print_if_let","","",184],[10,"print_mac","","",184],[10,"print_expr_maybe_paren","","",184],[10,"print_expr","","",184],[10,"print_local_decl","","",184],[10,"print_decl","","",184],[10,"print_ident","","",184],[10,"print_uint","","",184],[10,"print_name","","",184],[10,"print_for_decl","","",184],[10,"print_pat","","",184],[10,"print_fn","","",184],[10,"print_fn_args","","",184],[10,"print_fn_args_and_ret","","",184],[10,"print_fn_block_args","","",184],[10,"print_capture_clause","","",184],[10,"print_proc_args","","",184],[10,"print_bounds","","",184],[10,"print_lifetime","","",184],[10,"print_lifetime_def","","",184],[10,"print_generics","","",184],[10,"print_ty_param","","",184],[10,"print_where_clause","","",184],[10,"print_meta_item","","",184],[10,"print_view_path","","",184],[10,"print_view_item","","",184],[10,"print_mutability","","",184],[10,"print_mt","","",184],[10,"print_arg","","",184],[10,"print_fn_output","","",184],[10,"print_ty_fn","","",184],[10,"maybe_print_trailing_comment","","",184],[10,"print_remaining_comments","","",184],[10,"print_literal","","",184],[10,"next_lit","","",184],[10,"maybe_print_comment","","",184],[10,"print_comment","","",184],[10,"print_string","","",184],[10,"next_comment","","",184],[10,"print_opt_unsafety","","",184],[10,"print_opt_abi_and_extern_if_nondefault","","",184],[10,"print_extern_opt_abi","","",184],[10,"print_fn_header_info","","",184],[10,"print_unsafety","","",184],[2,"RenderSpan","rustc_driver::diagnostic",""],[12,"FullSpan","","A FullSpan renders with both with an initial line for the\nmessage, prefixed by file:linenum, followed by a summary of\nthe source code covered by the span.",204],[12,"FileLine","","A FileLine renders with just a line for the message prefixed\nby file:linenum.",204],[2,"ColorConfig","",""],[12,"Auto","","",205],[12,"Always","","",205],[12,"Never","","",205],[6,"Emitter","",""],[9,"emit","","",226],[9,"custom_emit","","",226],[1,"FatalError","","This structure is used to signify that a task has panicked with a fatal error\nfrom the diagnostics. You can use this with the `Any` trait to figure out\nhow a rustc task died (if so desired)."],[1,"ExplicitBug","","Signifies that the compiler died with an explicit call to `.bug`\nor `.span_bug` rather than a failed assertion, etc."],[1,"SpanHandler","","A span-handler is like a handler but also\naccepts span information for source-location\nreporting."],[11,"handler","","",206],[11,"cm","","",206],[1,"Handler","","A handler deals with errors; certain errors\n(fatal, bug, unimpl) may cause immediate exit,\nothers log errors for later reporting."],[3,"mk_span_handler","",""],[3,"default_handler","",""],[3,"mk_handler","",""],[2,"Level","",""],[12,"Bug","","",208],[12,"Fatal","","",208],[12,"Error","","",208],[12,"Warning","","",208],[12,"Note","","",208],[12,"Help","","",208],[1,"EmitterWriter","",""],[3,"expect","",""]],"paths":[[2,"PpSourceMode"],[2,"PpMode"],[2,"UserIdentifiedItem"],[1,"Interner"],[1,"RcStr"],[1,"StrInterner"],[1,"SmallVector"],[1,"IntoIter"],[1,"Registry"],[1,"MacExpr"],[1,"MacPat"],[1,"MacItems"],[1,"DummyResult"],[1,"BlockInfo"],[1,"ExtCtxt"],[1,"SyntaxEnv"],[2,"PtrTy"],[1,"Path"],[2,"Ty"],[1,"LifetimeBounds"],[1,"TraitDef"],[2,"StructType"],[1,"PatIdentFinder"],[1,"IdentRenamer"],[1,"PatIdentRenamer"],[1,"MacroExpander"],[1,"ExpansionConfig"],[1,"Marker"],[1,"MacroExterminator"],[2,"ArgumentType"],[2,"SyntaxContext_"],[2,"TokenTree"],[1,"Vec"],[1,"Spanned"],[2,"Option"],[1,"Ident"],[1,"Ty"],[1,"Block"],[1,"Arg"],[1,"Generics"],[1,"P"],[1,"Arm"],[1,"Attribute_"],[1,"TtFrame"],[1,"TtReader"],[2,"LockstepIterSize"],[2,"TokenTreeOrTokenTreeVec"],[1,"MatcherTtFrame"],[1,"MatcherPos"],[1,"ParserAnyMacro"],[1,"MacroRulesMacroExpander"],[1,"MacroRulesDefiner"],[2,"CommentStyle"],[1,"Comment"],[1,"Literal"],[1,"TokenAndSpan"],[1,"StringReader"],[1,"Restrictions"],[2,"PathParsingMode"],[2,"BoundParsingMode"],[2,"TokenType"],[1,"Parser"],[2,"BinOpToken"],[2,"DelimToken"],[2,"IdentStyle"],[2,"Lit"],[2,"Token"],[2,"Nonterminal"],[2,"Keyword"],[1,"InternedString"],[2,"ObsoleteSyntax"],[1,"ParseSess"],[1,"Name"],[1,"Lifetime"],[1,"LifetimeDef"],[1,"Path"],[1,"PathSegment"],[2,"PathParameters"],[1,"AngleBracketedParameterData"],[1,"ParenthesizedParameterData"],[1,"DefId"],[2,"TyParamBound"],[2,"TraitBoundModifier"],[1,"TyParam"],[1,"WhereClause"],[2,"WherePredicate"],[1,"WhereBoundPredicate"],[1,"WhereRegionPredicate"],[1,"WhereEqPredicate"],[1,"Crate"],[2,"MetaItem_"],[1,"Pat"],[1,"FieldPat"],[2,"BindingMode"],[2,"PatWildKind"],[2,"Pat_"],[2,"Mutability"],[2,"BinOp"],[2,"UnOp"],[2,"Stmt_"],[2,"MacStmtStyle"],[2,"LocalSource"],[1,"Local"],[2,"Decl_"],[1,"Field"],[2,"BlockCheckMode"],[2,"UnsafeSource"],[1,"Expr"],[2,"Expr_"],[1,"QPath"],[2,"MatchSource"],[2,"CaptureClause"],[1,"Delimited"],[1,"SequenceRepetition"],[2,"KleeneOp"],[2,"Mac_"],[2,"StrStyle"],[2,"Sign"],[2,"LitIntType"],[2,"Lit_"],[1,"MutTy"],[1,"TypeField"],[1,"TypeMethod"],[2,"TraitItem"],[2,"ImplItem"],[1,"AssociatedType"],[1,"Typedef"],[2,"IntTy"],[2,"UintTy"],[2,"FloatTy"],[1,"TypeBinding"],[2,"PrimTy"],[2,"Onceness"],[1,"ClosureTy"],[1,"BareFnTy"],[2,"Ty_"],[2,"AsmDialect"],[1,"InlineAsm"],[1,"FnDecl"],[2,"Unsafety"],[2,"FunctionRetTy"],[2,"ExplicitSelf_"],[1,"Method"],[2,"Method_"],[1,"Mod"],[1,"ForeignMod"],[1,"VariantArg"],[2,"VariantKind"],[1,"EnumDef"],[1,"Variant_"],[2,"PathListItem_"],[2,"ViewPath_"],[1,"ViewItem"],[2,"ViewItem_"],[2,"AttrStyle"],[1,"AttrId"],[1,"TraitRef"],[1,"PolyTraitRef"],[2,"Visibility"],[1,"StructField_"],[2,"StructFieldKind"],[1,"StructDef"],[1,"Item"],[2,"Item_"],[1,"ForeignItem"],[2,"ForeignItem_"],[2,"UnboxedClosureKind"],[2,"InlinedItem"],[2,"Os"],[2,"Abi"],[2,"Architecture"],[2,"Code"],[1,"FnLikeNode"],[2,"PathElem"],[1,"LinkedPathNode"],[1,"Values"],[2,"Node"],[2,"MapEntry"],[1,"InlinedParent"],[1,"Forest"],[1,"Map"],[1,"NodesMatchingSuffix"],[1,"IdAndSpanUpdater"],[1,"NodeCollector"],[1,"State"],[1,"IdRange"],[1,"IdVisitor"],[1,"IdRangeComputingVisitor"],[1,"EachViewItemData"],[2,"InlineAttr"],[1,"Stability"],[2,"StabilityLevel"],[2,"ReprAttr"],[2,"IntType"],[1,"BytePos"],[1,"CharPos"],[1,"Span"],[2,"MacroFormat"],[1,"NameAndSpan"],[1,"ExpnInfo"],[1,"ExpnId"],[1,"FileMap"],[1,"CodeMap"],[1,"Context"],[2,"RenderSpan"],[2,"ColorConfig"],[1,"SpanHandler"],[1,"Handler"],[2,"Level"],[1,"EmitterWriter"],[2,"Destination"],[1,"Features"],[1,"MacroVisitor"],[1,"PostExpansionVisitor"],[1,"OwnedSlice"],[1,"ShowSpanVisitor"],[1,"StandardLibraryInjector"],[1,"PreludeInjector"],[1,"TestHarnessGenerator"],[2,"HasTestSignature"],[2,"Breaks"],[1,"BreakToken"],[1,"BeginToken"],[2,"Token"],[1,"Printer"],[1,"NoAnn"],[6,"Emitter"]]};

searchIndex['rustc_typeck'] = {"items":[[0,"","rustc_typeck","typeck.rs, an introduction"],[3,"check_crate","",""],[0,"lint","","Lints, aka compiler warnings."],[10,"name_lower","rustc::lint","Get the lint's name, with ASCII letters converted to lowercase.",0],[10,"open","rustc_back::archive","Opens an existing static archive",1],[10,"remove_file","","Removes a file from this archive",1],[10,"files","","Lists all files in an archive",1],[10,"extend","","Creates an `ArchiveBuilder` for adding files to this archive.",1],[10,"create","","Create a new static archive, ready for adding files.",2],[10,"add_native_library","","Adds all of the contents of a native library to this archive. This will\nsearch in the relevant locations for a library named `name`.",2],[10,"add_rlib","","Adds all of the contents of the rlib at the specified path to this\narchive.",2],[10,"add_file","","Adds an arbitrary file to this archive",2],[10,"update_symbols","","Indicate that the next call to `build` should updates all symbols in\nthe archive (run 'ar s' over it).",2],[10,"build","","Combine the provided files, rlibs, and native libraries into a single\n`Archive`.",2],[10,"eq","rustc_back::svh","",3],[10,"ne","","",3],[10,"ne","","",3],[10,"clone","","",3],[10,"clone_from","","",3],[10,"new","","",3],[10,"as_str","","",3],[10,"calculate","","",3],[10,"fmt","","",3],[10,"hash","rustc_back::svh::svh_visitor","",4],[10,"hash","","",5],[10,"hash","","",6],[10,"get_content","syntax::ast","",7],[10,"get_content","","",8],[10,"visit_mac","rustc_back::svh::svh_visitor","",9],[10,"visit_struct_def","","",9],[10,"visit_variant","","",9],[10,"visit_opt_lifetime_ref","","",9],[10,"visit_ident","","",9],[10,"visit_lifetime_ref","","",9],[10,"visit_lifetime_def","","",9],[10,"visit_expr","","",9],[10,"visit_stmt","","",9],[10,"visit_view_item","","",9],[10,"visit_foreign_item","","",9],[10,"visit_item","","",9],[10,"visit_mod","","",9],[10,"visit_decl","","",9],[10,"visit_ty","","",9],[10,"visit_generics","","",9],[10,"visit_fn","","",9],[10,"visit_ty_method","","",9],[10,"visit_trait_item","","",9],[10,"visit_struct_field","","",9],[10,"visit_explicit_self","","",9],[10,"visit_path","","",9],[10,"visit_block","","",9],[10,"visit_pat","","",9],[10,"visit_local","","",9],[10,"visit_arm","","",9],[10,"visit_name","","",9],[10,"visit_ident","","",9],[10,"visit_mod","","",9],[10,"visit_view_item","","",9],[10,"visit_foreign_item","","",9],[10,"visit_item","","",9],[10,"visit_local","","",9],[10,"visit_block","","",9],[10,"visit_stmt","","",9],[10,"visit_arm","","",9],[10,"visit_pat","","",9],[10,"visit_decl","","",9],[10,"visit_expr","","",9],[10,"visit_expr_post","","",9],[10,"visit_ty","","",9],[10,"visit_generics","","",9],[10,"visit_fn","","",9],[10,"visit_ty_method","","",9],[10,"visit_trait_item","","",9],[10,"visit_trait_ref","","",9],[10,"visit_ty_param_bound","","",9],[10,"visit_poly_trait_ref","","",9],[10,"visit_struct_def","","",9],[10,"visit_struct_field","","",9],[10,"visit_variant","","",9],[10,"visit_opt_lifetime_ref","","",9],[10,"visit_lifetime_bound","","",9],[10,"visit_lifetime_ref","","",9],[10,"visit_lifetime_def","","",9],[10,"visit_explicit_self","","",9],[10,"visit_mac","","",9],[10,"visit_path","","",9],[10,"visit_path_segment","","",9],[10,"visit_path_parameters","","",9],[10,"visit_assoc_type_binding","","",9],[10,"visit_attribute","","",9],[10,"tr_id","rustc::middle::astencode","Translates an internal id, meaning a node id that is known to refer to some part of the\nitem currently being inlined, such as a local variable or argument.  All naked node-ids\nthat appear in types have this property, since if something might refer to an external item\nwe would use a def-id to allow for the possibility that the item resides in another crate.",10],[10,"tr_def_id","","Translates an EXTERNAL def-id, converting the crate number from the one used in the encoded\ndata to the current crate numbers..  By external, I mean that it be translated to a\nreference to the item in its original crate, as opposed to being translated to a reference\nto the inlined version of the item.  This is typically, but not always, what you want,\nbecause most def-ids refer to external things like types or other fns that may or may not\nbe inlined.  Note that even when the inlined function is referencing itself recursively, we\nwould want `tr_def_id` for that reference--- conceptually the function calls the original,\nnon-inlined version, and trans deals with linking that recursive call to the inlined copy.",10],[10,"tr_intern_def_id","","Translates an INTERNAL def-id, meaning a def-id that is\nknown to refer to some part of the item currently being\ninlined.  In that case, we want to convert the def-id to\nrefer to the current crate and to the new, inlined node-id.",10],[10,"tr_span","","",10],[10,"tr_intern","syntax::ast","",11],[10,"tr","","",11],[10,"tr","core::option","",12],[10,"tr","syntax::codemap","",13],[10,"fold_block","rustc::middle::astencode","",14],[10,"fold_crate","","",14],[10,"fold_meta_items","","",14],[10,"fold_meta_item","","",14],[10,"fold_view_path","","",14],[10,"fold_view_item","","",14],[10,"fold_foreign_item","","",14],[10,"fold_item","","",14],[10,"fold_item_simple","","",14],[10,"fold_struct_field","","",14],[10,"fold_item_underscore","","",14],[10,"fold_fn_decl","","",14],[10,"fold_type_method","","",14],[10,"fold_method","","",14],[10,"fold_block","","",14],[10,"fold_stmt","","",14],[10,"fold_arm","","",14],[10,"fold_pat","","",14],[10,"fold_decl","","",14],[10,"fold_expr","","",14],[10,"fold_ty","","",14],[10,"fold_qpath","","",14],[10,"fold_ty_binding","","",14],[10,"fold_mod","","",14],[10,"fold_foreign_mod","","",14],[10,"fold_variant","","",14],[10,"fold_ident","","",14],[10,"fold_uint","","",14],[10,"fold_path","","",14],[10,"fold_path_parameters","","",14],[10,"fold_angle_bracketed_parameter_data","","",14],[10,"fold_parenthesized_parameter_data","","",14],[10,"fold_local","","",14],[10,"fold_mac","","",14],[10,"fold_explicit_self","","",14],[10,"fold_explicit_self_underscore","","",14],[10,"fold_lifetime","","",14],[10,"fold_lifetime_def","","",14],[10,"fold_attribute","","",14],[10,"fold_arg","","",14],[10,"fold_generics","","",14],[10,"fold_trait_ref","","",14],[10,"fold_poly_trait_ref","","",14],[10,"fold_struct_def","","",14],[10,"fold_lifetimes","","",14],[10,"fold_lifetime_defs","","",14],[10,"fold_ty_param","","",14],[10,"fold_ty_params","","",14],[10,"fold_tt","","",14],[10,"fold_tts","","",14],[10,"fold_token","","",14],[10,"fold_interpolated","","",14],[10,"fold_opt_lifetime","","",14],[10,"fold_variant_arg","","",14],[10,"fold_opt_bounds","","",14],[10,"fold_bounds","","",14],[10,"fold_ty_param_bound","","",14],[10,"fold_mt","","",14],[10,"fold_field","","",14],[10,"fold_where_clause","","",14],[10,"fold_where_predicate","","",14],[10,"fold_typedef","","",14],[10,"fold_associated_type","","",14],[10,"new_id","","",14],[10,"new_span","","",14],[10,"tr","rustc::middle::def","",15],[10,"tr","rustc::middle::ty","",16],[10,"tr","","",17],[10,"tr","rustc::middle::region","",18],[10,"tr","rustc::middle::ty","",19],[10,"tr","","",20],[10,"read_freevar_entry","rbml::reader","",21],[10,"read_capture_mode","","",21],[10,"tr","rustc::middle::ty","",22],[10,"tr","","",23],[10,"read_method_callee","rbml::reader","",21],[10,"tr","rustc::middle::ty","",24],[10,"read_vec_per_param_space","rbml::reader","",21],[10,"read_vtable_res_with_key","","",21],[10,"read_vtable_res","","",21],[10,"read_vtable_param_res","","",21],[10,"read_vtable_origin","","",21],[10,"ty_str_ctxt","rustc::metadata::encoder","",25],[10,"emit_closure_type","rbml::writer","",26],[10,"emit_method_origin","","",26],[10,"emit_ty","","",26],[10,"emit_tys","","",26],[10,"emit_trait_ref","","",26],[10,"emit_type_param_def","","",26],[10,"emit_predicate","","",26],[10,"emit_type_scheme","","",26],[10,"emit_existential_bounds","","",26],[10,"emit_builtin_bounds","","",26],[10,"emit_substs","","",26],[10,"emit_auto_adjustment","","",26],[10,"emit_autoref","","",26],[10,"emit_auto_deref_ref","","",26],[10,"emit_unsize_kind","","",26],[10,"tag","","",26],[10,"id","","",26],[10,"visit_id","rustc::middle::astencode","",27],[10,"as_int","rbml","",28],[10,"opt_child","","",28],[10,"read_ty_nodcx","rbml::reader","",21],[10,"read_tys_nodcx","","",21],[10,"read_substs_nodcx","","",21],[10,"read_method_origin","","",21],[10,"read_ty","","",21],[10,"read_tys","","",21],[10,"read_trait_ref","","",21],[10,"read_poly_trait_ref","","",21],[10,"read_type_param_def","","",21],[10,"read_predicate","","",21],[10,"read_type_scheme","","",21],[10,"read_existential_bounds","","",21],[10,"read_substs","","",21],[10,"read_auto_adjustment","","",21],[10,"read_auto_deref_ref","","",21],[10,"read_autoref","","",21],[10,"read_unsize_kind","","",21],[10,"read_unboxed_closure","","",21],[10,"convert_def_id","","Converts a def-id that appears in a type.  The correct\ntranslation will depend on what kind of def-id this is.\nThis is a subtle point: type definitions are not\ninlined into the current crate, so if the def-id names\na nominal type or type alias, then it should be\ntranslated to refer to the source crate.",21],[10,"graph_id","rustc::middle::cfg::graphviz","",29],[10,"node_id","","",29],[10,"node_label","","",29],[10,"edge_label","","",29],[10,"node_label","","",29],[10,"edge_label","","",29],[10,"nodes","","",29],[10,"edges","","",29],[10,"source","","",29],[10,"target","","",29],[10,"new","rustc::middle::cfg","",30],[10,"node_is_reachable","","",30],[10,"visit_item","rustc::middle::check_const","",31],[10,"visit_pat","","",31],[10,"visit_expr","","",31],[10,"visit_name","","",31],[10,"visit_ident","","",31],[10,"visit_mod","","",31],[10,"visit_view_item","","",31],[10,"visit_foreign_item","","",31],[10,"visit_item","","",31],[10,"visit_local","","",31],[10,"visit_block","","",31],[10,"visit_stmt","","",31],[10,"visit_arm","","",31],[10,"visit_pat","","",31],[10,"visit_decl","","",31],[10,"visit_expr","","",31],[10,"visit_expr_post","","",31],[10,"visit_ty","","",31],[10,"visit_generics","","",31],[10,"visit_fn","","",31],[10,"visit_ty_method","","",31],[10,"visit_trait_item","","",31],[10,"visit_trait_ref","","",31],[10,"visit_ty_param_bound","","",31],[10,"visit_poly_trait_ref","","",31],[10,"visit_struct_def","","",31],[10,"visit_struct_field","","",31],[10,"visit_variant","","",31],[10,"visit_opt_lifetime_ref","","",31],[10,"visit_lifetime_bound","","",31],[10,"visit_lifetime_ref","","",31],[10,"visit_lifetime_def","","",31],[10,"visit_explicit_self","","",31],[10,"visit_mac","","",31],[10,"visit_path","","",31],[10,"visit_path_segment","","",31],[10,"visit_path_parameters","","",31],[10,"visit_assoc_type_binding","","",31],[10,"visit_attribute","","",31],[10,"visit_item","rustc::middle::check_static_recursion","",32],[10,"visit_name","","",32],[10,"visit_ident","","",32],[10,"visit_mod","","",32],[10,"visit_view_item","","",32],[10,"visit_foreign_item","","",32],[10,"visit_item","","",32],[10,"visit_local","","",32],[10,"visit_block","","",32],[10,"visit_stmt","","",32],[10,"visit_arm","","",32],[10,"visit_pat","","",32],[10,"visit_decl","","",32],[10,"visit_expr","","",32],[10,"visit_expr_post","","",32],[10,"visit_ty","","",32],[10,"visit_generics","","",32],[10,"visit_fn","","",32],[10,"visit_ty_method","","",32],[10,"visit_trait_item","","",32],[10,"visit_trait_ref","","",32],[10,"visit_ty_param_bound","","",32],[10,"visit_poly_trait_ref","","",32],[10,"visit_struct_def","","",32],[10,"visit_struct_field","","",32],[10,"visit_variant","","",32],[10,"visit_opt_lifetime_ref","","",32],[10,"visit_lifetime_bound","","",32],[10,"visit_lifetime_ref","","",32],[10,"visit_lifetime_def","","",32],[10,"visit_explicit_self","","",32],[10,"visit_mac","","",32],[10,"visit_path","","",32],[10,"visit_path_segment","","",32],[10,"visit_path_parameters","","",32],[10,"visit_assoc_type_binding","","",32],[10,"visit_attribute","","",32],[10,"visit_item","","",33],[10,"visit_expr","","",33],[10,"visit_name","","",33],[10,"visit_ident","","",33],[10,"visit_mod","","",33],[10,"visit_view_item","","",33],[10,"visit_foreign_item","","",33],[10,"visit_item","","",33],[10,"visit_local","","",33],[10,"visit_block","","",33],[10,"visit_stmt","","",33],[10,"visit_arm","","",33],[10,"visit_pat","","",33],[10,"visit_decl","","",33],[10,"visit_expr","","",33],[10,"visit_expr_post","","",33],[10,"visit_ty","","",33],[10,"visit_generics","","",33],[10,"visit_fn","","",33],[10,"visit_ty_method","","",33],[10,"visit_trait_item","","",33],[10,"visit_trait_ref","","",33],[10,"visit_ty_param_bound","","",33],[10,"visit_poly_trait_ref","","",33],[10,"visit_struct_def","","",33],[10,"visit_struct_field","","",33],[10,"visit_variant","","",33],[10,"visit_opt_lifetime_ref","","",33],[10,"visit_lifetime_bound","","",33],[10,"visit_lifetime_ref","","",33],[10,"visit_lifetime_def","","",33],[10,"visit_explicit_self","","",33],[10,"visit_mac","","",33],[10,"visit_path","","",33],[10,"visit_path_segment","","",33],[10,"visit_path_parameters","","",33],[10,"visit_assoc_type_binding","","",33],[10,"visit_attribute","","",33],[10,"eq","rustc::middle::check_loop","",34],[10,"ne","","",34],[10,"ne","","",34],[10,"clone","","",34],[10,"clone_from","","",34],[10,"visit_item","","",35],[10,"visit_expr","","",35],[10,"visit_name","","",35],[10,"visit_ident","","",35],[10,"visit_mod","","",35],[10,"visit_view_item","","",35],[10,"visit_foreign_item","","",35],[10,"visit_item","","",35],[10,"visit_local","","",35],[10,"visit_block","","",35],[10,"visit_stmt","","",35],[10,"visit_arm","","",35],[10,"visit_pat","","",35],[10,"visit_decl","","",35],[10,"visit_expr","","",35],[10,"visit_expr_post","","",35],[10,"visit_ty","","",35],[10,"visit_generics","","",35],[10,"visit_fn","","",35],[10,"visit_ty_method","","",35],[10,"visit_trait_item","","",35],[10,"visit_trait_ref","","",35],[10,"visit_ty_param_bound","","",35],[10,"visit_poly_trait_ref","","",35],[10,"visit_struct_def","","",35],[10,"visit_struct_field","","",35],[10,"visit_variant","","",35],[10,"visit_opt_lifetime_ref","","",35],[10,"visit_lifetime_bound","","",35],[10,"visit_lifetime_ref","","",35],[10,"visit_lifetime_def","","",35],[10,"visit_explicit_self","","",35],[10,"visit_mac","","",35],[10,"visit_path","","",35],[10,"visit_path_segment","","",35],[10,"visit_path_parameters","","",35],[10,"visit_assoc_type_binding","","",35],[10,"visit_attribute","","",35],[10,"fmt","rustc::middle::check_match","",36],[10,"from_iter","","",36],[10,"eq","","",37],[10,"ne","","",37],[10,"ne","","",37],[10,"clone","","",37],[10,"clone_from","","",37],[10,"eq","","",38],[10,"ne","","",38],[10,"ne","","",38],[10,"clone","","",38],[10,"clone_from","","",38],[10,"visit_expr","","",39],[10,"visit_local","","",39],[10,"visit_fn","","",39],[10,"visit_name","","",39],[10,"visit_ident","","",39],[10,"visit_mod","","",39],[10,"visit_view_item","","",39],[10,"visit_foreign_item","","",39],[10,"visit_item","","",39],[10,"visit_local","","",39],[10,"visit_block","","",39],[10,"visit_stmt","","",39],[10,"visit_arm","","",39],[10,"visit_pat","","",39],[10,"visit_decl","","",39],[10,"visit_expr","","",39],[10,"visit_expr_post","","",39],[10,"visit_ty","","",39],[10,"visit_generics","","",39],[10,"visit_fn","","",39],[10,"visit_ty_method","","",39],[10,"visit_trait_item","","",39],[10,"visit_trait_ref","","",39],[10,"visit_ty_param_bound","","",39],[10,"visit_poly_trait_ref","","",39],[10,"visit_struct_def","","",39],[10,"visit_struct_field","","",39],[10,"visit_variant","","",39],[10,"visit_opt_lifetime_ref","","",39],[10,"visit_lifetime_bound","","",39],[10,"visit_lifetime_ref","","",39],[10,"visit_lifetime_def","","",39],[10,"visit_explicit_self","","",39],[10,"visit_mac","","",39],[10,"visit_path","","",39],[10,"visit_path_segment","","",39],[10,"visit_path_parameters","","",39],[10,"visit_assoc_type_binding","","",39],[10,"visit_attribute","","",39],[10,"new","","",40],[10,"fold_pat","","",40],[10,"fold_crate","","",40],[10,"fold_meta_items","","",40],[10,"fold_meta_item","","",40],[10,"fold_view_path","","",40],[10,"fold_view_item","","",40],[10,"fold_foreign_item","","",40],[10,"fold_item","","",40],[10,"fold_item_simple","","",40],[10,"fold_struct_field","","",40],[10,"fold_item_underscore","","",40],[10,"fold_fn_decl","","",40],[10,"fold_type_method","","",40],[10,"fold_method","","",40],[10,"fold_block","","",40],[10,"fold_stmt","","",40],[10,"fold_arm","","",40],[10,"fold_pat","","",40],[10,"fold_decl","","",40],[10,"fold_expr","","",40],[10,"fold_ty","","",40],[10,"fold_qpath","","",40],[10,"fold_ty_binding","","",40],[10,"fold_mod","","",40],[10,"fold_foreign_mod","","",40],[10,"fold_variant","","",40],[10,"fold_ident","","",40],[10,"fold_uint","","",40],[10,"fold_path","","",40],[10,"fold_path_parameters","","",40],[10,"fold_angle_bracketed_parameter_data","","",40],[10,"fold_parenthesized_parameter_data","","",40],[10,"fold_local","","",40],[10,"fold_mac","","",40],[10,"fold_explicit_self","","",40],[10,"fold_explicit_self_underscore","","",40],[10,"fold_lifetime","","",40],[10,"fold_lifetime_def","","",40],[10,"fold_attribute","","",40],[10,"fold_arg","","",40],[10,"fold_generics","","",40],[10,"fold_trait_ref","","",40],[10,"fold_poly_trait_ref","","",40],[10,"fold_struct_def","","",40],[10,"fold_lifetimes","","",40],[10,"fold_lifetime_defs","","",40],[10,"fold_ty_param","","",40],[10,"fold_ty_params","","",40],[10,"fold_tt","","",40],[10,"fold_tts","","",40],[10,"fold_token","","",40],[10,"fold_interpolated","","",40],[10,"fold_opt_lifetime","","",40],[10,"fold_variant_arg","","",40],[10,"fold_opt_bounds","","",40],[10,"fold_bounds","","",40],[10,"fold_ty_param_bound","","",40],[10,"fold_mt","","",40],[10,"fold_field","","",40],[10,"fold_where_clause","","",40],[10,"fold_where_predicate","","",40],[10,"fold_typedef","","",40],[10,"fold_associated_type","","",40],[10,"new_id","","",40],[10,"new_span","","",40],[10,"matched_pat","","",41],[10,"consume","","",41],[10,"consume_pat","","",41],[10,"borrow","","",41],[10,"decl_without_init","","",41],[10,"mutate","","",41],[10,"visit_pat","","",42],[10,"visit_name","","",42],[10,"visit_ident","","",42],[10,"visit_mod","","",42],[10,"visit_view_item","","",42],[10,"visit_foreign_item","","",42],[10,"visit_item","","",42],[10,"visit_local","","",42],[10,"visit_block","","",42],[10,"visit_stmt","","",42],[10,"visit_arm","","",42],[10,"visit_pat","","",42],[10,"visit_decl","","",42],[10,"visit_expr","","",42],[10,"visit_expr_post","","",42],[10,"visit_ty","","",42],[10,"visit_generics","","",42],[10,"visit_fn","","",42],[10,"visit_ty_method","","",42],[10,"visit_trait_item","","",42],[10,"visit_trait_ref","","",42],[10,"visit_ty_param_bound","","",42],[10,"visit_poly_trait_ref","","",42],[10,"visit_struct_def","","",42],[10,"visit_struct_field","","",42],[10,"visit_variant","","",42],[10,"visit_opt_lifetime_ref","","",42],[10,"visit_lifetime_bound","","",42],[10,"visit_lifetime_ref","","",42],[10,"visit_lifetime_def","","",42],[10,"visit_explicit_self","","",42],[10,"visit_mac","","",42],[10,"visit_path","","",42],[10,"visit_path_segment","","",42],[10,"visit_path_parameters","","",42],[10,"visit_assoc_type_binding","","",42],[10,"visit_attribute","","",42],[10,"visit_fn","rustc::middle::check_rvalues","",43],[10,"visit_name","","",43],[10,"visit_ident","","",43],[10,"visit_mod","","",43],[10,"visit_view_item","","",43],[10,"visit_foreign_item","","",43],[10,"visit_item","","",43],[10,"visit_local","","",43],[10,"visit_block","","",43],[10,"visit_stmt","","",43],[10,"visit_arm","","",43],[10,"visit_pat","","",43],[10,"visit_decl","","",43],[10,"visit_expr","","",43],[10,"visit_expr_post","","",43],[10,"visit_ty","","",43],[10,"visit_generics","","",43],[10,"visit_fn","","",43],[10,"visit_ty_method","","",43],[10,"visit_trait_item","","",43],[10,"visit_trait_ref","","",43],[10,"visit_ty_param_bound","","",43],[10,"visit_poly_trait_ref","","",43],[10,"visit_struct_def","","",43],[10,"visit_struct_field","","",43],[10,"visit_variant","","",43],[10,"visit_opt_lifetime_ref","","",43],[10,"visit_lifetime_bound","","",43],[10,"visit_lifetime_ref","","",43],[10,"visit_lifetime_def","","",43],[10,"visit_explicit_self","","",43],[10,"visit_mac","","",43],[10,"visit_path","","",43],[10,"visit_path_segment","","",43],[10,"visit_path_parameters","","",43],[10,"visit_assoc_type_binding","","",43],[10,"visit_attribute","","",43],[10,"consume","","",44],[10,"matched_pat","","",44],[10,"consume_pat","","",44],[10,"borrow","","",44],[10,"decl_without_init","","",44],[10,"mutate","","",44],[10,"eq","rustc::middle::check_static","",45],[10,"ne","","",45],[10,"ne","","",45],[10,"assert_receiver_is_total_eq","","",45],[10,"visit_item","","",46],[10,"visit_expr","","This method is used to enforce the constraints on\nimmutable static items. It walks through the *value*\nof the item walking down the expression and evaluating\nevery nested expression. if the expression is not part\nof a static item, this method does nothing but walking\ndown through it.",46],[10,"visit_name","","",46],[10,"visit_ident","","",46],[10,"visit_mod","","",46],[10,"visit_view_item","","",46],[10,"visit_foreign_item","","",46],[10,"visit_item","","",46],[10,"visit_local","","",46],[10,"visit_block","","",46],[10,"visit_stmt","","",46],[10,"visit_arm","","",46],[10,"visit_pat","","",46],[10,"visit_decl","","",46],[10,"visit_expr","","",46],[10,"visit_expr_post","","",46],[10,"visit_ty","","",46],[10,"visit_generics","","",46],[10,"visit_fn","","",46],[10,"visit_ty_method","","",46],[10,"visit_trait_item","","",46],[10,"visit_trait_ref","","",46],[10,"visit_ty_param_bound","","",46],[10,"visit_poly_trait_ref","","",46],[10,"visit_struct_def","","",46],[10,"visit_struct_field","","",46],[10,"visit_variant","","",46],[10,"visit_opt_lifetime_ref","","",46],[10,"visit_lifetime_bound","","",46],[10,"visit_lifetime_ref","","",46],[10,"visit_lifetime_def","","",46],[10,"visit_explicit_self","","",46],[10,"visit_mac","","",46],[10,"visit_path","","",46],[10,"visit_path_segment","","",46],[10,"visit_path_parameters","","",46],[10,"visit_assoc_type_binding","","",46],[10,"visit_attribute","","",46],[10,"visit_item","","",47],[10,"visit_name","","",47],[10,"visit_ident","","",47],[10,"visit_mod","","",47],[10,"visit_view_item","","",47],[10,"visit_foreign_item","","",47],[10,"visit_item","","",47],[10,"visit_local","","",47],[10,"visit_block","","",47],[10,"visit_stmt","","",47],[10,"visit_arm","","",47],[10,"visit_pat","","",47],[10,"visit_decl","","",47],[10,"visit_expr","","",47],[10,"visit_expr_post","","",47],[10,"visit_ty","","",47],[10,"visit_generics","","",47],[10,"visit_fn","","",47],[10,"visit_ty_method","","",47],[10,"visit_trait_item","","",47],[10,"visit_trait_ref","","",47],[10,"visit_ty_param_bound","","",47],[10,"visit_poly_trait_ref","","",47],[10,"visit_struct_def","","",47],[10,"visit_struct_field","","",47],[10,"visit_variant","","",47],[10,"visit_opt_lifetime_ref","","",47],[10,"visit_lifetime_bound","","",47],[10,"visit_lifetime_ref","","",47],[10,"visit_lifetime_def","","",47],[10,"visit_explicit_self","","",47],[10,"visit_mac","","",47],[10,"visit_path","","",47],[10,"visit_path_segment","","",47],[10,"visit_path_parameters","","",47],[10,"visit_assoc_type_binding","","",47],[10,"visit_attribute","","",47],[10,"consume","","",48],[10,"borrow","","",48],[10,"decl_without_init","","",48],[10,"mutate","","",48],[10,"matched_pat","","",48],[10,"consume_pat","","",48],[10,"visit_expr_post","rustc::middle::const_eval","",49],[10,"visit_name","","",49],[10,"visit_ident","","",49],[10,"visit_mod","","",49],[10,"visit_view_item","","",49],[10,"visit_foreign_item","","",49],[10,"visit_item","","",49],[10,"visit_local","","",49],[10,"visit_block","","",49],[10,"visit_stmt","","",49],[10,"visit_arm","","",49],[10,"visit_pat","","",49],[10,"visit_decl","","",49],[10,"visit_expr","","",49],[10,"visit_expr_post","","",49],[10,"visit_ty","","",49],[10,"visit_generics","","",49],[10,"visit_fn","","",49],[10,"visit_ty_method","","",49],[10,"visit_trait_item","","",49],[10,"visit_trait_ref","","",49],[10,"visit_ty_param_bound","","",49],[10,"visit_poly_trait_ref","","",49],[10,"visit_struct_def","","",49],[10,"visit_struct_field","","",49],[10,"visit_variant","","",49],[10,"visit_opt_lifetime_ref","","",49],[10,"visit_lifetime_bound","","",49],[10,"visit_lifetime_ref","","",49],[10,"visit_lifetime_def","","",49],[10,"visit_explicit_self","","",49],[10,"visit_mac","","",49],[10,"visit_path","","",49],[10,"visit_path_segment","","",49],[10,"visit_path_parameters","","",49],[10,"visit_assoc_type_binding","","",49],[10,"visit_attribute","","",49],[10,"eq","","",50],[10,"ne","","",50],[10,"ne","","",50],[10,"clone","","",50],[10,"clone_from","","",50],[10,"fmt","rustc::middle::dataflow","",51],[10,"clone","","",52],[10,"clone_from","","",52],[10,"pre","","",52],[10,"pre","","",52],[10,"post","","",52],[10,"new","","",52],[10,"add_gen","","Indicates that `id` generates `bit`",52],[10,"add_kill","","Indicates that `id` kills `bit`",52],[10,"each_bit_on_entry","","Iterates through each bit that is set on entry to `id`.\nOnly useful after `propagate()` has been called.",52],[10,"each_bit_for_node","","Iterates through each bit that is set on entry/exit to `cfgidx`.\nOnly useful after `propagate()` has been called.",52],[10,"each_gen_bit","","Iterates through each bit in the gen set for `id`.",52],[10,"add_kills_from_flow_exits","","Whenever you have a `break` or `continue` statement, flow\nexits through any number of enclosing scopes on its way to\nthe new destination. This function infers the kill bits of\nthose control operators based on the kill bits associated\nwith those scopes.",52],[10,"propagate","","Performs the data flow analysis.",52],[10,"join","","",53],[10,"join","","",54],[10,"visit_struct_def","rustc::middle::dead","",55],[10,"visit_expr","","",55],[10,"visit_pat","","",55],[10,"visit_path","","",55],[10,"visit_item","","",55],[10,"visit_name","","",55],[10,"visit_ident","","",55],[10,"visit_mod","","",55],[10,"visit_view_item","","",55],[10,"visit_foreign_item","","",55],[10,"visit_item","","",55],[10,"visit_local","","",55],[10,"visit_block","","",55],[10,"visit_stmt","","",55],[10,"visit_arm","","",55],[10,"visit_pat","","",55],[10,"visit_decl","","",55],[10,"visit_expr","","",55],[10,"visit_expr_post","","",55],[10,"visit_ty","","",55],[10,"visit_generics","","",55],[10,"visit_fn","","",55],[10,"visit_ty_method","","",55],[10,"visit_trait_item","","",55],[10,"visit_trait_ref","","",55],[10,"visit_ty_param_bound","","",55],[10,"visit_poly_trait_ref","","",55],[10,"visit_struct_def","","",55],[10,"visit_struct_field","","",55],[10,"visit_variant","","",55],[10,"visit_opt_lifetime_ref","","",55],[10,"visit_lifetime_bound","","",55],[10,"visit_lifetime_ref","","",55],[10,"visit_lifetime_def","","",55],[10,"visit_explicit_self","","",55],[10,"visit_mac","","",55],[10,"visit_path","","",55],[10,"visit_path_segment","","",55],[10,"visit_path_parameters","","",55],[10,"visit_assoc_type_binding","","",55],[10,"visit_attribute","","",55],[10,"visit_item","","",56],[10,"visit_fn","","",56],[10,"visit_name","","",56],[10,"visit_ident","","",56],[10,"visit_mod","","",56],[10,"visit_view_item","","",56],[10,"visit_foreign_item","","",56],[10,"visit_item","","",56],[10,"visit_local","","",56],[10,"visit_block","","",56],[10,"visit_stmt","","",56],[10,"visit_arm","","",56],[10,"visit_pat","","",56],[10,"visit_decl","","",56],[10,"visit_expr","","",56],[10,"visit_expr_post","","",56],[10,"visit_ty","","",56],[10,"visit_generics","","",56],[10,"visit_fn","","",56],[10,"visit_ty_method","","",56],[10,"visit_trait_item","","",56],[10,"visit_trait_ref","","",56],[10,"visit_ty_param_bound","","",56],[10,"visit_poly_trait_ref","","",56],[10,"visit_struct_def","","",56],[10,"visit_struct_field","","",56],[10,"visit_variant","","",56],[10,"visit_opt_lifetime_ref","","",56],[10,"visit_lifetime_bound","","",56],[10,"visit_lifetime_ref","","",56],[10,"visit_lifetime_def","","",56],[10,"visit_explicit_self","","",56],[10,"visit_mac","","",56],[10,"visit_path","","",56],[10,"visit_path_segment","","",56],[10,"visit_path_parameters","","",56],[10,"visit_assoc_type_binding","","",56],[10,"visit_attribute","","",56],[10,"visit_item","","",57],[10,"visit_foreign_item","","",57],[10,"visit_fn","","",57],[10,"visit_struct_field","","",57],[10,"visit_trait_item","","",57],[10,"visit_name","","",57],[10,"visit_ident","","",57],[10,"visit_mod","","",57],[10,"visit_view_item","","",57],[10,"visit_foreign_item","","",57],[10,"visit_item","","",57],[10,"visit_local","","",57],[10,"visit_block","","",57],[10,"visit_stmt","","",57],[10,"visit_arm","","",57],[10,"visit_pat","","",57],[10,"visit_decl","","",57],[10,"visit_expr","","",57],[10,"visit_expr_post","","",57],[10,"visit_ty","","",57],[10,"visit_generics","","",57],[10,"visit_fn","","",57],[10,"visit_ty_method","","",57],[10,"visit_trait_item","","",57],[10,"visit_trait_ref","","",57],[10,"visit_ty_param_bound","","",57],[10,"visit_poly_trait_ref","","",57],[10,"visit_struct_def","","",57],[10,"visit_struct_field","","",57],[10,"visit_variant","","",57],[10,"visit_opt_lifetime_ref","","",57],[10,"visit_lifetime_bound","","",57],[10,"visit_lifetime_ref","","",57],[10,"visit_lifetime_def","","",57],[10,"visit_explicit_self","","",57],[10,"visit_mac","","",57],[10,"visit_path","","",57],[10,"visit_path_segment","","",57],[10,"visit_path_parameters","","",57],[10,"visit_assoc_type_binding","","",57],[10,"visit_attribute","","",57],[10,"fmt","rustc::middle::def","",15],[10,"hash","","",15],[10,"decode","","",15],[10,"encode","","",15],[10,"assert_receiver_is_total_eq","","",15],[10,"eq","","",15],[10,"ne","","",15],[10,"ne","","",15],[10,"clone","","",15],[10,"clone_from","","",15],[10,"fmt","","",58],[10,"hash","","",58],[10,"decode","","",58],[10,"encode","","",58],[10,"assert_receiver_is_total_eq","","",58],[10,"eq","","",58],[10,"ne","","",58],[10,"ne","","",58],[10,"clone","","",58],[10,"clone_from","","",58],[10,"fmt","","",59],[10,"hash","","",59],[10,"decode","","",59],[10,"encode","","",59],[10,"assert_receiver_is_total_eq","","",59],[10,"eq","","",59],[10,"ne","","",59],[10,"ne","","",59],[10,"clone","","",59],[10,"clone_from","","",59],[10,"map","","",58],[10,"def_id","","",59],[10,"eq","","",60],[10,"ne","","",60],[10,"ne","","",60],[10,"assert_receiver_is_total_eq","","",60],[10,"clone","","",60],[10,"clone_from","","",60],[10,"from_explicit_self_category","","",60],[10,"def_id","","",15],[10,"variant_def_ids","","",15],[10,"eq","rustc::middle::effect","",61],[10,"ne","","",61],[10,"ne","","",61],[10,"visit_fn","","",62],[10,"visit_block","","",62],[10,"visit_expr","","",62],[10,"visit_name","","",62],[10,"visit_ident","","",62],[10,"visit_mod","","",62],[10,"visit_view_item","","",62],[10,"visit_foreign_item","","",62],[10,"visit_item","","",62],[10,"visit_local","","",62],[10,"visit_block","","",62],[10,"visit_stmt","","",62],[10,"visit_arm","","",62],[10,"visit_pat","","",62],[10,"visit_decl","","",62],[10,"visit_expr","","",62],[10,"visit_expr_post","","",62],[10,"visit_ty","","",62],[10,"visit_generics","","",62],[10,"visit_fn","","",62],[10,"visit_ty_method","","",62],[10,"visit_trait_item","","",62],[10,"visit_trait_ref","","",62],[10,"visit_ty_param_bound","","",62],[10,"visit_poly_trait_ref","","",62],[10,"visit_struct_def","","",62],[10,"visit_struct_field","","",62],[10,"visit_variant","","",62],[10,"visit_opt_lifetime_ref","","",62],[10,"visit_lifetime_bound","","",62],[10,"visit_lifetime_ref","","",62],[10,"visit_lifetime_def","","",62],[10,"visit_explicit_self","","",62],[10,"visit_mac","","",62],[10,"visit_path","","",62],[10,"visit_path_segment","","",62],[10,"visit_path_parameters","","",62],[10,"visit_assoc_type_binding","","",62],[10,"visit_attribute","","",62],[10,"visit_item","rustc::middle::entry","",63],[10,"visit_name","","",63],[10,"visit_ident","","",63],[10,"visit_mod","","",63],[10,"visit_view_item","","",63],[10,"visit_foreign_item","","",63],[10,"visit_item","","",63],[10,"visit_local","","",63],[10,"visit_block","","",63],[10,"visit_stmt","","",63],[10,"visit_arm","","",63],[10,"visit_pat","","",63],[10,"visit_decl","","",63],[10,"visit_expr","","",63],[10,"visit_expr_post","","",63],[10,"visit_ty","","",63],[10,"visit_generics","","",63],[10,"visit_fn","","",63],[10,"visit_ty_method","","",63],[10,"visit_trait_item","","",63],[10,"visit_trait_ref","","",63],[10,"visit_ty_param_bound","","",63],[10,"visit_poly_trait_ref","","",63],[10,"visit_struct_def","","",63],[10,"visit_struct_field","","",63],[10,"visit_variant","","",63],[10,"visit_opt_lifetime_ref","","",63],[10,"visit_lifetime_bound","","",63],[10,"visit_lifetime_ref","","",63],[10,"visit_lifetime_def","","",63],[10,"visit_explicit_self","","",63],[10,"visit_mac","","",63],[10,"visit_path","","",63],[10,"visit_path_segment","","",63],[10,"visit_path_parameters","","",63],[10,"visit_assoc_type_binding","","",63],[10,"visit_attribute","","",63],[10,"fmt","rustc::middle::expr_use_visitor","",64],[10,"eq","","",64],[10,"ne","","",64],[10,"ne","","",64],[10,"fmt","","",65],[10,"eq","","",65],[10,"ne","","",65],[10,"ne","","",65],[10,"fmt","","",66],[10,"eq","","",66],[10,"ne","","",66],[10,"ne","","",66],[10,"fmt","","",67],[10,"eq","","",67],[10,"ne","","",67],[10,"ne","","",67],[10,"fmt","","",68],[10,"eq","","",68],[10,"ne","","",68],[10,"ne","","",68],[10,"fmt","","",69],[10,"eq","","",69],[10,"ne","","",69],[10,"ne","","",69],[10,"new","","",70],[10,"walk_fn","","",70],[10,"consume_expr","","",70],[10,"walk_expr","","",70],[10,"hash","rustc::middle::fast_reject","",71],[10,"assert_receiver_is_total_eq","","",71],[10,"eq","","",71],[10,"ne","","",71],[10,"ne","","",71],[10,"clone","","",71],[10,"clone_from","","",71],[10,"fmt","rustc::middle::graph","",72],[10,"fmt","","",73],[10,"eq","","",73],[10,"ne","","",73],[10,"ne","","",73],[10,"clone","","",73],[10,"clone_from","","",73],[10,"fmt","","",74],[10,"eq","","",74],[10,"ne","","",74],[10,"ne","","",74],[10,"fmt","","",75],[10,"node_id","","Returns unique id (unique with respect to the graph holding associated node).",73],[10,"edge_id","","Returns unique id (unique with respect to the graph holding associated edge).",74],[10,"new","","",76],[10,"with_capacity","","",76],[10,"all_nodes","","",76],[10,"all_edges","","",76],[10,"next_node_index","","",76],[10,"add_node","","",76],[10,"mut_node_data","","",76],[10,"node_data","","",76],[10,"node","","",76],[10,"next_edge_index","","",76],[10,"add_edge","","",76],[10,"mut_edge_data","","",76],[10,"edge_data","","",76],[10,"edge","","",76],[10,"first_adjacent","","Accesses the index of the first edge adjacent to `node`.\nThis is useful if you wish to modify the graph while walking\nthe linked list of edges.",76],[10,"next_adjacent","","Accesses the next edge in a given direction.\nThis is useful if you wish to modify the graph while walking\nthe linked list of edges.",76],[10,"each_node","","Iterates over all edges defined in the graph.",76],[10,"each_edge","","Iterates over all edges defined in the graph",76],[10,"each_outgoing_edge","","Iterates over all outgoing edges from the node `from`",76],[10,"each_incoming_edge","","Iterates over all incoming edges to the node `target`",76],[10,"each_adjacent_edge","","Iterates over all edges adjacent to the node `node`\nin the direction `dir` (either `Outgoing` or `Incoming)",76],[10,"iterate_until_fixed_point","","",76],[10,"depth_traverse","","",76],[10,"next","","",77],[10,"size_hint","","",77],[10,"source","","",72],[10,"target","","",72],[10,"visit_fn","rustc::middle::intrinsicck","",78],[10,"visit_expr","","",78],[10,"visit_name","","",78],[10,"visit_ident","","",78],[10,"visit_mod","","",78],[10,"visit_view_item","","",78],[10,"visit_foreign_item","","",78],[10,"visit_item","","",78],[10,"visit_local","","",78],[10,"visit_block","","",78],[10,"visit_stmt","","",78],[10,"visit_arm","","",78],[10,"visit_pat","","",78],[10,"visit_decl","","",78],[10,"visit_expr","","",78],[10,"visit_expr_post","","",78],[10,"visit_ty","","",78],[10,"visit_generics","","",78],[10,"visit_fn","","",78],[10,"visit_ty_method","","",78],[10,"visit_trait_item","","",78],[10,"visit_trait_ref","","",78],[10,"visit_ty_param_bound","","",78],[10,"visit_poly_trait_ref","","",78],[10,"visit_struct_def","","",78],[10,"visit_struct_field","","",78],[10,"visit_variant","","",78],[10,"visit_opt_lifetime_ref","","",78],[10,"visit_lifetime_bound","","",78],[10,"visit_lifetime_ref","","",78],[10,"visit_lifetime_def","","",78],[10,"visit_explicit_self","","",78],[10,"visit_mac","","",78],[10,"visit_path","","",78],[10,"visit_path_segment","","",78],[10,"visit_path_parameters","","",78],[10,"visit_assoc_type_binding","","",78],[10,"visit_attribute","","",78],[10,"repr","rustc::middle::ty","",79],[10,"get_ref","rustc::middle::infer::coercion","",80],[10,"tys","","",80],[10,"subtype","","",80],[10,"unpack_actual_value","","",80],[10,"coerce_borrowed_pointer","","",80],[10,"coerce_borrowed_fn","","",80],[10,"coerce_unsafe_ptr","","",80],[10,"combine","alloc::rc","",81],[10,"combine","rustc::middle::ty","",82],[10,"combine","","",83],[10,"combine","","",84],[10,"clone","rustc::middle::infer::combine","",85],[10,"clone_from","","",85],[10,"switch_expected","","",85],[10,"instantiate","","",85],[10,"tcx","","",86],[10,"fold_ty","","",86],[10,"fold_region","","",86],[10,"enter_region_binder","","",86],[10,"exit_region_binder","","",86],[10,"fold_ty","","",86],[10,"fold_mt","","",86],[10,"fold_trait_ref","","",86],[10,"fold_substs","","",86],[10,"fold_fn_sig","","",86],[10,"fold_output","","",86],[10,"fold_bare_fn_ty","","",86],[10,"fold_closure_ty","","",86],[10,"fold_region","","",86],[10,"fold_trait_store","","",86],[10,"fold_existential_bounds","","",86],[10,"fold_autoref","","",86],[10,"fold_item_substs","","",86],[10,"infcx","rustc::middle::infer::equate","",87],[10,"tag","","",87],[10,"a_is_expected","","",87],[10,"trace","","",87],[10,"equate","","",87],[10,"sub","","",87],[10,"lub","","",87],[10,"glb","","",87],[10,"contratys","","",87],[10,"contraregions","","",87],[10,"regions","","",87],[10,"mts","","",87],[10,"unsafeties","","",87],[10,"oncenesses","","",87],[10,"builtin_bounds","","",87],[10,"tys","","",87],[10,"binders","","",87],[10,"tcx","","",87],[10,"tps","","",87],[10,"substs","","",87],[10,"substs_variances","","",87],[10,"bare_fn_tys","","",87],[10,"closure_tys","","",87],[10,"fn_sigs","","",87],[10,"args","","",87],[10,"abi","","",87],[10,"projection_tys","","",87],[10,"projection_predicates","","",87],[10,"projection_bounds","","",87],[10,"existential_bounds","","",87],[10,"trait_stores","","",87],[10,"trait_refs","","",87],[10,"report_region_errors","rustc::middle::infer","",88],[10,"process_errors","","",88],[10,"report_type_error","","",88],[10,"report_and_explain_type_error","","",88],[10,"values_str","","Returns a string of the form \"expected `{}`, found `{}`\", or None if this is a derived\nerror.",88],[10,"expected_found_str","","",88],[10,"report_param_bound_failure","","",88],[10,"report_concrete_failure","","",88],[10,"report_sub_sup_conflict","","",88],[10,"report_sup_sup_conflict","","",88],[10,"report_processed_errors","","",88],[10,"give_suggestion","","",88],[10,"give_expl_lifetime_param","","",88],[10,"report_inference_failure","","",88],[10,"note_region_origin","","",88],[10,"resolve","alloc::rc","",81],[10,"contains_error","","",81],[10,"resolve","rustc::middle::ty","",89],[10,"contains_error","","",89],[10,"infcx","rustc::middle::infer::glb","",90],[10,"tag","","",90],[10,"a_is_expected","","",90],[10,"trace","","",90],[10,"equate","","",90],[10,"sub","","",90],[10,"lub","","",90],[10,"glb","","",90],[10,"mts","","",90],[10,"contratys","","",90],[10,"unsafeties","","",90],[10,"oncenesses","","",90],[10,"builtin_bounds","","",90],[10,"regions","","",90],[10,"contraregions","","",90],[10,"tys","","",90],[10,"binders","","",90],[10,"tcx","","",90],[10,"tps","","",90],[10,"substs","","",90],[10,"substs_variances","","",90],[10,"bare_fn_tys","","",90],[10,"closure_tys","","",90],[10,"fn_sigs","","",90],[10,"args","","",90],[10,"abi","","",90],[10,"projection_tys","","",90],[10,"projection_predicates","","",90],[10,"projection_bounds","","",90],[10,"existential_bounds","","",90],[10,"trait_stores","","",90],[10,"trait_refs","","",90],[10,"tainted_regions","rustc::middle::infer","",88],[10,"region_vars_confined_to_snapshot","","Returns the set of region variables that do not affect any\ntypes/regions which existed before `snapshot` was\nstarted. This is used in the sub/lub/glb computations. The\nidea here is that when we are computing lub/glb of two\nregions, we sometimes create intermediate region variables.\nThose region variables may touch some of the skolemized or\nother \"forbidden\" regions we created to replace bound\nregions, but they don't really represent an \"external\"\nconstraint.",88],[10,"relate_bound","rustc::middle::infer::lub","",91],[10,"relate_bound","rustc::middle::infer::glb","",90],[10,"infcx","rustc::middle::infer::lub","",91],[10,"tag","","",91],[10,"a_is_expected","","",91],[10,"trace","","",91],[10,"equate","","",91],[10,"sub","","",91],[10,"lub","","",91],[10,"glb","","",91],[10,"mts","","",91],[10,"contratys","","",91],[10,"unsafeties","","",91],[10,"oncenesses","","",91],[10,"builtin_bounds","","",91],[10,"contraregions","","",91],[10,"regions","","",91],[10,"tys","","",91],[10,"binders","","",91],[10,"tcx","","",91],[10,"tps","","",91],[10,"substs","","",91],[10,"substs_variances","","",91],[10,"bare_fn_tys","","",91],[10,"closure_tys","","",91],[10,"fn_sigs","","",91],[10,"args","","",91],[10,"abi","","",91],[10,"projection_tys","","",91],[10,"projection_predicates","","",91],[10,"projection_bounds","","",91],[10,"existential_bounds","","",91],[10,"trait_stores","","",91],[10,"trait_refs","","",91],[10,"fmt","rustc::middle::infer::region_inference::graphviz","",92],[10,"assert_receiver_is_total_eq","","",92],[10,"eq","","",92],[10,"ne","","",92],[10,"ne","","",92],[10,"hash","","",92],[10,"clone","","",92],[10,"clone_from","","",92],[10,"graph_id","","",93],[10,"node_id","","",93],[10,"node_label","","",93],[10,"edge_label","","",93],[10,"node_label","","",93],[10,"edge_label","","",93],[10,"nodes","","",93],[10,"edges","","",93],[10,"source","","",93],[10,"target","","",93],[10,"fmt","rustc::middle::infer::region_inference","",94],[10,"hash","","",94],[10,"assert_receiver_is_total_eq","","",94],[10,"eq","","",94],[10,"ne","","",94],[10,"ne","","",94],[10,"clone","","",94],[10,"clone_from","","",94],[10,"hash","","",95],[10,"assert_receiver_is_total_eq","","",95],[10,"eq","","",95],[10,"ne","","",95],[10,"ne","","",95],[10,"eq","","",96],[10,"ne","","",96],[10,"ne","","",96],[10,"eq","","",97],[10,"ne","","",97],[10,"ne","","",97],[10,"fmt","","",98],[10,"clone","","",98],[10,"clone_from","","",98],[10,"fmt","","",99],[10,"clone","","",99],[10,"clone_from","","",99],[10,"contains","","",99],[10,"push","","",99],[10,"fmt","","",100],[10,"new","","",101],[10,"start_snapshot","","",101],[10,"commit","","",101],[10,"rollback_to","","",101],[10,"num_vars","","",101],[10,"new_region_var","","",101],[10,"new_skolemized","","Creates a new skolemized region. Skolemized regions are fresh\nregions used when performing higher-ranked computations. They\nmust be used in a very particular way and are never supposed\nto \"escape\" out into error messages or the code at large.",101],[10,"new_bound","","",101],[10,"add_given","","",101],[10,"make_eqregion","","",101],[10,"make_subregion","","",101],[10,"verify_param_bound","","",101],[10,"lub_regions","","",101],[10,"glb_regions","","",101],[10,"resolve_var","","",101],[10,"combine_vars","","",101],[10,"vars_created_since_snapshot","","",101],[10,"tainted","","Computes all regions that have been related to `r0` in any way since the mark `mark` was\nmade---`r0` itself will be the first entry. This is used when checking whether skolemized\nregions are being improperly related to other regions.",101],[10,"resolve_regions","","This function performs the actual region resolution.  It must be\ncalled after all constraints have been added.  It performs a\nfixed-point iteration to find region values which satisfy all\nconstraints, assuming such values can be found; if they cannot,\nerrors are reported.",101],[10,"fmt","","",102],[10,"eq","","",102],[10,"ne","","",102],[10,"ne","","",102],[10,"repr","","",94],[10,"repr","","",103],[10,"repr","","",104],[10,"repr","","",105],[10,"new","rustc::middle::infer::resolve","",106],[10,"tcx","","",106],[10,"fold_ty","","",106],[10,"enter_region_binder","","",106],[10,"exit_region_binder","","",106],[10,"fold_ty","","",106],[10,"fold_mt","","",106],[10,"fold_trait_ref","","",106],[10,"fold_substs","","",106],[10,"fold_fn_sig","","",106],[10,"fold_output","","",106],[10,"fold_bare_fn_ty","","",106],[10,"fold_closure_ty","","",106],[10,"fold_region","","",106],[10,"fold_trait_store","","",106],[10,"fold_existential_bounds","","",106],[10,"fold_autoref","","",106],[10,"fold_item_substs","","",106],[10,"tcx","","",107],[10,"fold_ty","","",107],[10,"fold_region","","",107],[10,"enter_region_binder","","",107],[10,"exit_region_binder","","",107],[10,"fold_ty","","",107],[10,"fold_mt","","",107],[10,"fold_trait_ref","","",107],[10,"fold_substs","","",107],[10,"fold_fn_sig","","",107],[10,"fold_output","","",107],[10,"fold_bare_fn_ty","","",107],[10,"fold_closure_ty","","",107],[10,"fold_region","","",107],[10,"fold_trait_store","","",107],[10,"fold_existential_bounds","","",107],[10,"fold_autoref","","",107],[10,"fold_item_substs","","",107],[10,"new","rustc::middle::infer::freshen","",108],[10,"tcx","","",108],[10,"fold_region","","",108],[10,"fold_ty","","",108],[10,"enter_region_binder","","",108],[10,"exit_region_binder","","",108],[10,"fold_ty","","",108],[10,"fold_mt","","",108],[10,"fold_trait_ref","","",108],[10,"fold_substs","","",108],[10,"fold_fn_sig","","",108],[10,"fold_output","","",108],[10,"fold_bare_fn_ty","","",108],[10,"fold_closure_ty","","",108],[10,"fold_region","","",108],[10,"fold_trait_store","","",108],[10,"fold_existential_bounds","","",108],[10,"fold_autoref","","",108],[10,"fold_item_substs","","",108],[10,"infcx","rustc::middle::infer::sub","",109],[10,"tag","","",109],[10,"a_is_expected","","",109],[10,"trace","","",109],[10,"equate","","",109],[10,"sub","","",109],[10,"lub","","",109],[10,"glb","","",109],[10,"contratys","","",109],[10,"contraregions","","",109],[10,"regions","","",109],[10,"mts","","",109],[10,"unsafeties","","",109],[10,"oncenesses","","",109],[10,"builtin_bounds","","",109],[10,"tys","","",109],[10,"binders","","",109],[10,"tcx","","",109],[10,"tps","","",109],[10,"substs","","",109],[10,"substs_variances","","",109],[10,"bare_fn_tys","","",109],[10,"closure_tys","","",109],[10,"fn_sigs","","",109],[10,"args","","",109],[10,"abi","","",109],[10,"projection_tys","","",109],[10,"projection_predicates","","",109],[10,"projection_bounds","","",109],[10,"existential_bounds","","",109],[10,"trait_stores","","",109],[10,"trait_refs","","",109],[10,"fmt","rustc::middle::infer::type_variable","",110],[10,"eq","","",110],[10,"ne","","",110],[10,"ne","","",110],[10,"new","","",111],[10,"var_diverges","","",111],[10,"relate_vars","","Records that `a <: b`, `a :> b`, or `a == b`, depending on `dir`.",111],[10,"instantiate_and_push","","Instantiates `vid` with the type `ty` and then pushes an entry onto `stack` for each of the\nrelations of `vid` to other variables. The relations will have the form `(ty, dir, vid1)`\nwhere `vid1` is some other variable id.",111],[10,"new_var","","",111],[10,"probe","","",111],[10,"replace_if_possible","","",111],[10,"snapshot","","",111],[10,"rollback_to","","",111],[10,"commit","","",111],[10,"types_escaping_snapshot","","Find the set of type variables that existed *before* `s`\nbut which have only been unified since `s` started, and\nreturn the types with which they were unified. So if we had\na type variable `V0`, then we started the snapshot, then we\ncreated a type variable `V1`, unifed `V0` with `T0`, and\nunified `V1` with `T1`, this function would return `{T0}`.",111],[10,"reverse","","",112],[10,"clone","rustc::middle::infer::unify","",113],[10,"clone_from","","",113],[10,"eq","","",113],[10,"ne","","",113],[10,"ne","","",113],[10,"new","","",114],[10,"snapshot","","Starts a new snapshot. Each snapshot must be either\nrolled back or committed in a \"LIFO\" (stack) order.",114],[10,"rollback_to","","Reverses all changes since the last snapshot. Also\nremoves any keys that have been created since then.",114],[10,"commit","","Commits all changes since the last snapshot. Of course, they\ncan still be undone if there is a snapshot further out.",114],[10,"new_key","","",114],[10,"get","","Find the root node for `vid`. This uses the standard union-find algorithm with path\ncompression: http://en.wikipedia.org/wiki/Disjoint-set_data_structure",114],[10,"set","","Sets the value for `vid` to `new_value`. `vid` MUST be a root node! Also, we must be in the\nmiddle of a snapshot.",114],[10,"unify","","Either redirects node_a to node_b or vice versa, depending on the relative rank. Returns\nthe new root and rank. You should then update the value of the new root to something\nsuitable.",114],[10,"reverse","","",115],[10,"simple_vars","rustc::middle::infer","Unifies two simple keys. Because simple keys do not have any subtyping relationships, if\nboth keys have already been associated with a value, then those two values must be the\nsame.",88],[10,"simple_var_t","","Sets the value of the key `a_id` to `b`. Because simple keys do not have any subtyping\nrelationships, if `a_id` already has a value, it must be the same as `b`.",88],[10,"probe_var","","",88],[10,"index","rustc::middle::ty","",116],[10,"from_index","","",116],[10,"unification_table","","",116],[10,"tag","","",116],[10,"to_type","","",117],[10,"to_type_err","","",117],[10,"index","","",118],[10,"from_index","","",118],[10,"unification_table","","",118],[10,"tag","","",118],[10,"to_type","syntax::ast","",119],[10,"to_type_err","","",119],[10,"repr","rustc::middle::infer::unify","",113],[10,"fmt","rustc::middle::infer","",120],[10,"clone","","",120],[10,"clone_from","","",120],[10,"fmt","","",121],[10,"clone","","",121],[10,"clone_from","","",121],[10,"fmt","","",122],[10,"clone","","",122],[10,"clone_from","","",122],[10,"fmt","","",123],[10,"clone","","",123],[10,"clone_from","","",123],[10,"fmt","","",124],[10,"clone","","",124],[10,"clone_from","","",124],[10,"fmt","","",125],[10,"clone","","",125],[10,"clone_from","","",125],[10,"fmt","","",126],[10,"then","core::result","",127],[10,"to_ures","","",127],[10,"compare","","",127],[10,"freshen","rustc::middle::infer","",88],[10,"type_var_diverges","","",88],[10,"freshener","","",88],[10,"combine_fields","","",88],[10,"equate","","",88],[10,"sub","","",88],[10,"lub","","",88],[10,"commit_unconditionally","","Execute `f` and commit the bindings",88],[10,"commit_if_ok","","Execute `f` and commit the bindings if successful",88],[10,"try","","Execute `f`, unroll bindings on panic",88],[10,"probe","","Execute `f` then unroll any bindings it creates",88],[10,"add_given","","",88],[10,"sub_types","","",88],[10,"eq_types","","",88],[10,"sub_trait_refs","","",88],[10,"sub_poly_trait_refs","","",88],[10,"skolemize_late_bound_regions","","See `higher_ranked::skolemize_late_bound_regions`",88],[10,"leak_check","","See `higher_ranked::leak_check`",88],[10,"plug_leaks","","See `higher_ranked::plug_leaks`",88],[10,"equality_predicate","","",88],[10,"region_outlives_predicate","","",88],[10,"next_ty_var_id","","",88],[10,"next_ty_var","","",88],[10,"next_diverging_ty_var","","",88],[10,"next_ty_vars","","",88],[10,"next_int_var_id","","",88],[10,"next_float_var_id","","",88],[10,"next_region_var","","",88],[10,"region_vars_for_defs","","",88],[10,"fresh_substs_for_generics","","Given a set of generics defined on a type or impl, returns a substitution mapping each\ntype/region parameter to a fresh inference variable.",88],[10,"fresh_substs_for_trait","","Given a set of generics defined on a trait, returns a substitution mapping each output\ntype/region parameter to a fresh inference variable, and mapping the self type to\n`self_ty`.",88],[10,"fresh_bound_region","","",88],[10,"resolve_regions_and_report_errors","","",88],[10,"ty_to_string","","",88],[10,"tys_to_string","","",88],[10,"trait_ref_to_string","","",88],[10,"shallow_resolve","","",88],[10,"resolve_type_vars_if_possible","","Where possible, replaces type/int/float variables in\n`value` with their final value. Note that region variables\nare unaffected. If a type variable has not been unified, it\nis left as is.  This is an idempotent operation that does\nnot affect inference state in any way and so you can do it\nat will.",88],[10,"fully_resolve","","Attempts to resolve all type/region variables in\n`value`. Region inference must have been run already (e.g.,\nby calling `resolve_regions_and_report_errors`).  If some\nvariable was never unified, an `Err` results.",88],[10,"type_error_message_str","","",88],[10,"type_error_message_str_with_expected","","",88],[10,"type_error_message","","",88],[10,"report_mismatched_types","","",88],[10,"replace_late_bound_regions_with_fresh_var","","",88],[10,"span","","",122],[10,"dummy","","",122],[10,"repr","","",122],[10,"span","","",120],[10,"repr","","",120],[10,"span","","",123],[10,"repr","","",123],[10,"span","","",125],[10,"repr","","",125],[10,"hash","rustc::middle::lang_items","",128],[10,"assert_receiver_is_total_eq","","",128],[10,"eq","","",128],[10,"ne","","",128],[10,"ne","","",128],[10,"from_i64","","",128],[10,"from_u64","","",128],[10,"from_int","","",128],[10,"from_i8","","",128],[10,"from_i16","","",128],[10,"from_i32","","",128],[10,"from_uint","","",128],[10,"from_u8","","",128],[10,"from_u16","","",128],[10,"from_u32","","",128],[10,"from_f32","","",128],[10,"from_f64","","",128],[10,"new","","",129],[10,"items","","",129],[10,"item_name","","",129],[10,"require","","",129],[10,"from_builtin_kind","","",129],[10,"to_builtin_kind","","",129],[10,"fn_trait_kind","","",129],[10,"send_trait","","",129],[10,"sized_trait","","",129],[10,"copy_trait","","",129],[10,"sync_trait","","",129],[10,"drop_trait","","",129],[10,"add_trait","","",129],[10,"sub_trait","","",129],[10,"mul_trait","","",129],[10,"div_trait","","",129],[10,"rem_trait","","",129],[10,"neg_trait","","",129],[10,"not_trait","","",129],[10,"bitxor_trait","","",129],[10,"bitand_trait","","",129],[10,"bitor_trait","","",129],[10,"shl_trait","","",129],[10,"shr_trait","","",129],[10,"index_trait","","",129],[10,"index_mut_trait","","",129],[10,"slice_trait","","",129],[10,"slice_mut_trait","","",129],[10,"range_struct","","",129],[10,"range_from_struct","","",129],[10,"range_to_struct","","",129],[10,"full_range_struct","","",129],[10,"unsafe_type","","",129],[10,"deref_trait","","",129],[10,"deref_mut_trait","","",129],[10,"fn_trait","","",129],[10,"fn_mut_trait","","",129],[10,"fn_once_trait","","",129],[10,"eq_trait","","",129],[10,"ord_trait","","",129],[10,"str_eq_fn","","",129],[10,"panic_fn","","",129],[10,"panic_bounds_check_fn","","",129],[10,"panic_fmt","","",129],[10,"exchange_malloc_fn","","",129],[10,"exchange_free_fn","","",129],[10,"strdup_uniq_fn","","",129],[10,"start_fn","","",129],[10,"ty_desc","","",129],[10,"opaque","","",129],[10,"type_id","","",129],[10,"eh_personality","","",129],[10,"exchange_heap","","",129],[10,"owned_box","","",129],[10,"covariant_type","","",129],[10,"contravariant_type","","",129],[10,"invariant_type","","",129],[10,"covariant_lifetime","","",129],[10,"contravariant_lifetime","","",129],[10,"invariant_lifetime","","",129],[10,"no_send_bound","","",129],[10,"no_copy_bound","","",129],[10,"no_sync_bound","","",129],[10,"managed_bound","","",129],[10,"non_zero","","",129],[10,"iterator","","",129],[10,"stack_exhausted","","",129],[10,"visit_item","","",130],[10,"visit_name","","",130],[10,"visit_ident","","",130],[10,"visit_mod","","",130],[10,"visit_view_item","","",130],[10,"visit_foreign_item","","",130],[10,"visit_item","","",130],[10,"visit_local","","",130],[10,"visit_block","","",130],[10,"visit_stmt","","",130],[10,"visit_arm","","",130],[10,"visit_pat","","",130],[10,"visit_decl","","",130],[10,"visit_expr","","",130],[10,"visit_expr_post","","",130],[10,"visit_ty","","",130],[10,"visit_generics","","",130],[10,"visit_fn","","",130],[10,"visit_ty_method","","",130],[10,"visit_trait_item","","",130],[10,"visit_trait_ref","","",130],[10,"visit_ty_param_bound","","",130],[10,"visit_poly_trait_ref","","",130],[10,"visit_struct_def","","",130],[10,"visit_struct_field","","",130],[10,"visit_variant","","",130],[10,"visit_opt_lifetime_ref","","",130],[10,"visit_lifetime_bound","","",130],[10,"visit_lifetime_ref","","",130],[10,"visit_lifetime_def","","",130],[10,"visit_explicit_self","","",130],[10,"visit_mac","","",130],[10,"visit_path","","",130],[10,"visit_path_segment","","",130],[10,"visit_path_parameters","","",130],[10,"visit_assoc_type_binding","","",130],[10,"visit_attribute","","",130],[10,"new","","",130],[10,"collect_item","","",130],[10,"collect_local_language_items","","",130],[10,"collect_external_language_items","","",130],[10,"collect","","",130],[10,"eq","rustc::middle::liveness","",131],[10,"ne","","",131],[10,"ne","","",131],[10,"eq","","",132],[10,"ne","","",132],[10,"ne","","",132],[10,"clone","","",132],[10,"clone_from","","",132],[10,"fmt","","",133],[10,"eq","","",133],[10,"ne","","",133],[10,"ne","","",133],[10,"visit_fn","","",134],[10,"visit_local","","",134],[10,"visit_expr","","",134],[10,"visit_arm","","",134],[10,"visit_name","","",134],[10,"visit_ident","","",134],[10,"visit_mod","","",134],[10,"visit_view_item","","",134],[10,"visit_foreign_item","","",134],[10,"visit_item","","",134],[10,"visit_local","","",134],[10,"visit_block","","",134],[10,"visit_stmt","","",134],[10,"visit_arm","","",134],[10,"visit_pat","","",134],[10,"visit_decl","","",134],[10,"visit_expr","","",134],[10,"visit_expr_post","","",134],[10,"visit_ty","","",134],[10,"visit_generics","","",134],[10,"visit_fn","","",134],[10,"visit_ty_method","","",134],[10,"visit_trait_item","","",134],[10,"visit_trait_ref","","",134],[10,"visit_ty_param_bound","","",134],[10,"visit_poly_trait_ref","","",134],[10,"visit_struct_def","","",134],[10,"visit_struct_field","","",134],[10,"visit_variant","","",134],[10,"visit_opt_lifetime_ref","","",134],[10,"visit_lifetime_bound","","",134],[10,"visit_lifetime_ref","","",134],[10,"visit_lifetime_def","","",134],[10,"visit_explicit_self","","",134],[10,"visit_mac","","",134],[10,"visit_path","","",134],[10,"visit_path_segment","","",134],[10,"visit_path_parameters","","",134],[10,"visit_assoc_type_binding","","",134],[10,"visit_attribute","","",134],[10,"fmt","","",132],[10,"fmt","","",131],[10,"fmt","","",135],[10,"fmt","","",136],[10,"visit_fn","","",137],[10,"visit_local","","",137],[10,"visit_expr","","",137],[10,"visit_arm","","",137],[10,"visit_name","","",137],[10,"visit_ident","","",137],[10,"visit_mod","","",137],[10,"visit_view_item","","",137],[10,"visit_foreign_item","","",137],[10,"visit_item","","",137],[10,"visit_local","","",137],[10,"visit_block","","",137],[10,"visit_stmt","","",137],[10,"visit_arm","","",137],[10,"visit_pat","","",137],[10,"visit_decl","","",137],[10,"visit_expr","","",137],[10,"visit_expr_post","","",137],[10,"visit_ty","","",137],[10,"visit_generics","","",137],[10,"visit_fn","","",137],[10,"visit_ty_method","","",137],[10,"visit_trait_item","","",137],[10,"visit_trait_ref","","",137],[10,"visit_ty_param_bound","","",137],[10,"visit_poly_trait_ref","","",137],[10,"visit_struct_def","","",137],[10,"visit_struct_field","","",137],[10,"visit_variant","","",137],[10,"visit_opt_lifetime_ref","","",137],[10,"visit_lifetime_bound","","",137],[10,"visit_lifetime_ref","","",137],[10,"visit_lifetime_def","","",137],[10,"visit_explicit_self","","",137],[10,"visit_mac","","",137],[10,"visit_path","","",137],[10,"visit_path_segment","","",137],[10,"visit_path_parameters","","",137],[10,"visit_assoc_type_binding","","",137],[10,"visit_attribute","","",137],[10,"clone","","",138],[10,"clone_from","","",138],[10,"fmt","rustc::middle::mem_categorization","",139],[10,"eq","","",139],[10,"ne","","",139],[10,"ne","","",139],[10,"clone","","",139],[10,"clone_from","","",139],[10,"fmt","","",140],[10,"eq","","",140],[10,"ne","","",140],[10,"ne","","",140],[10,"clone","","",140],[10,"clone_from","","",140],[10,"fmt","","",141],[10,"hash","","",141],[10,"assert_receiver_is_total_eq","","",141],[10,"eq","","",141],[10,"ne","","",141],[10,"ne","","",141],[10,"clone","","",141],[10,"clone_from","","",141],[10,"fmt","","",142],[10,"hash","","",142],[10,"assert_receiver_is_total_eq","","",142],[10,"eq","","",142],[10,"ne","","",142],[10,"ne","","",142],[10,"clone","","",142],[10,"clone_from","","",142],[10,"fmt","","",143],[10,"hash","","",143],[10,"assert_receiver_is_total_eq","","",143],[10,"eq","","",143],[10,"ne","","",143],[10,"ne","","",143],[10,"clone","","",143],[10,"clone_from","","",143],[10,"fmt","","",144],[10,"hash","","",144],[10,"assert_receiver_is_total_eq","","",144],[10,"eq","","",144],[10,"ne","","",144],[10,"ne","","",144],[10,"clone","","",144],[10,"clone_from","","",144],[10,"fmt","","",145],[10,"hash","","",145],[10,"assert_receiver_is_total_eq","","",145],[10,"eq","","",145],[10,"ne","","",145],[10,"ne","","",145],[10,"clone","","",145],[10,"clone_from","","",145],[10,"fmt","","",146],[10,"eq","","",146],[10,"ne","","",146],[10,"ne","","",146],[10,"clone","","",146],[10,"clone_from","","",146],[10,"fmt","","",147],[10,"eq","","",147],[10,"ne","","",147],[10,"ne","","",147],[10,"clone","","",147],[10,"clone_from","","",147],[10,"id","syntax::ast","",148],[10,"span","","",148],[10,"id","","",149],[10,"span","","",149],[10,"from_mutbl","rustc::middle::mem_categorization","",145],[10,"from_borrow_kind","","",145],[10,"from_pointer_kind","","",145],[10,"inherit","","",145],[10,"is_mutable","","",145],[10,"is_immutable","","",145],[10,"to_user_str","","",145],[10,"new","","",150],[10,"cat_expr","","",150],[10,"cat_expr_autoderefd","","",150],[10,"cat_expr_unadjusted","","",150],[10,"cat_def","","",150],[10,"cat_rvalue_node","","",150],[10,"cat_rvalue","","",150],[10,"cat_field","","",150],[10,"cat_tup_field","","",150],[10,"cat_index","","Creates a cmt for an indexing operation (`[]`).",150],[10,"cat_slice_pattern","","Given a pattern P like: `[_, ..Q, _]`, where `vec_cmt` is the cmt for `P`, `slice_pat` is\nthe pattern `Q`, returns:",150],[10,"cat_imm_interior","","",150],[10,"cat_downcast","","",150],[10,"cat_pattern","","",150],[10,"cmt_to_string","","",150],[10,"guarantor","","Returns `self` after stripping away any owned pointer derefs or\ninterior content. The return value is basically the `cmt` which\ndetermines how long the value in `self` remains live.",147],[10,"freely_aliasable","","Returns `Some(_)` if this lvalue represents a freely aliasable pointer type.",147],[10,"upvar","","",147],[10,"repr","","",147],[10,"repr","","",139],[10,"repr","","",142],[10,"fmt","rustc::middle::privacy","",151],[10,"fmt","","",152],[10,"fmt","","",153],[10,"eq","","",153],[10,"ne","","",153],[10,"ne","","",153],[10,"or","","",151],[10,"visit_item","","",154],[10,"visit_foreign_item","","",154],[10,"visit_fn","","",154],[10,"visit_struct_def","","",154],[10,"visit_name","","",154],[10,"visit_ident","","",154],[10,"visit_mod","","",154],[10,"visit_view_item","","",154],[10,"visit_foreign_item","","",154],[10,"visit_item","","",154],[10,"visit_local","","",154],[10,"visit_block","","",154],[10,"visit_stmt","","",154],[10,"visit_arm","","",154],[10,"visit_pat","","",154],[10,"visit_decl","","",154],[10,"visit_expr","","",154],[10,"visit_expr_post","","",154],[10,"visit_ty","","",154],[10,"visit_generics","","",154],[10,"visit_fn","","",154],[10,"visit_ty_method","","",154],[10,"visit_trait_item","","",154],[10,"visit_trait_ref","","",154],[10,"visit_ty_param_bound","","",154],[10,"visit_poly_trait_ref","","",154],[10,"visit_struct_def","","",154],[10,"visit_struct_field","","",154],[10,"visit_variant","","",154],[10,"visit_opt_lifetime_ref","","",154],[10,"visit_lifetime_bound","","",154],[10,"visit_lifetime_ref","","",154],[10,"visit_lifetime_def","","",154],[10,"visit_explicit_self","","",154],[10,"visit_mac","","",154],[10,"visit_path","","",154],[10,"visit_path_segment","","",154],[10,"visit_path_parameters","","",154],[10,"visit_assoc_type_binding","","",154],[10,"visit_attribute","","",154],[10,"visit_item","","",155],[10,"visit_foreign_item","","",155],[10,"visit_mod","","",155],[10,"visit_name","","",155],[10,"visit_ident","","",155],[10,"visit_mod","","",155],[10,"visit_view_item","","",155],[10,"visit_foreign_item","","",155],[10,"visit_item","","",155],[10,"visit_local","","",155],[10,"visit_block","","",155],[10,"visit_stmt","","",155],[10,"visit_arm","","",155],[10,"visit_pat","","",155],[10,"visit_decl","","",155],[10,"visit_expr","","",155],[10,"visit_expr_post","","",155],[10,"visit_ty","","",155],[10,"visit_generics","","",155],[10,"visit_fn","","",155],[10,"visit_ty_method","","",155],[10,"visit_trait_item","","",155],[10,"visit_trait_ref","","",155],[10,"visit_ty_param_bound","","",155],[10,"visit_poly_trait_ref","","",155],[10,"visit_struct_def","","",155],[10,"visit_struct_field","","",155],[10,"visit_variant","","",155],[10,"visit_opt_lifetime_ref","","",155],[10,"visit_lifetime_bound","","",155],[10,"visit_lifetime_ref","","",155],[10,"visit_lifetime_def","","",155],[10,"visit_explicit_self","","",155],[10,"visit_mac","","",155],[10,"visit_path","","",155],[10,"visit_path_segment","","",155],[10,"visit_path_parameters","","",155],[10,"visit_assoc_type_binding","","",155],[10,"visit_attribute","","",155],[10,"visit_item","","",156],[10,"visit_expr","","",156],[10,"visit_view_item","","",156],[10,"visit_pat","","",156],[10,"visit_foreign_item","","",156],[10,"visit_path","","",156],[10,"visit_name","","",156],[10,"visit_ident","","",156],[10,"visit_mod","","",156],[10,"visit_view_item","","",156],[10,"visit_foreign_item","","",156],[10,"visit_item","","",156],[10,"visit_local","","",156],[10,"visit_block","","",156],[10,"visit_stmt","","",156],[10,"visit_arm","","",156],[10,"visit_pat","","",156],[10,"visit_decl","","",156],[10,"visit_expr","","",156],[10,"visit_expr_post","","",156],[10,"visit_ty","","",156],[10,"visit_generics","","",156],[10,"visit_fn","","",156],[10,"visit_ty_method","","",156],[10,"visit_trait_item","","",156],[10,"visit_trait_ref","","",156],[10,"visit_ty_param_bound","","",156],[10,"visit_poly_trait_ref","","",156],[10,"visit_struct_def","","",156],[10,"visit_struct_field","","",156],[10,"visit_variant","","",156],[10,"visit_opt_lifetime_ref","","",156],[10,"visit_lifetime_bound","","",156],[10,"visit_lifetime_ref","","",156],[10,"visit_lifetime_def","","",156],[10,"visit_explicit_self","","",156],[10,"visit_mac","","",156],[10,"visit_path","","",156],[10,"visit_path_segment","","",156],[10,"visit_path_parameters","","",156],[10,"visit_assoc_type_binding","","",156],[10,"visit_attribute","","",156],[10,"visit_item","","",157],[10,"visit_fn","","",157],[10,"visit_view_item","","",157],[10,"visit_name","","",157],[10,"visit_ident","","",157],[10,"visit_mod","","",157],[10,"visit_view_item","","",157],[10,"visit_foreign_item","","",157],[10,"visit_item","","",157],[10,"visit_local","","",157],[10,"visit_block","","",157],[10,"visit_stmt","","",157],[10,"visit_arm","","",157],[10,"visit_pat","","",157],[10,"visit_decl","","",157],[10,"visit_expr","","",157],[10,"visit_expr_post","","",157],[10,"visit_ty","","",157],[10,"visit_generics","","",157],[10,"visit_fn","","",157],[10,"visit_ty_method","","",157],[10,"visit_trait_item","","",157],[10,"visit_trait_ref","","",157],[10,"visit_ty_param_bound","","",157],[10,"visit_poly_trait_ref","","",157],[10,"visit_struct_def","","",157],[10,"visit_struct_field","","",157],[10,"visit_variant","","",157],[10,"visit_opt_lifetime_ref","","",157],[10,"visit_lifetime_bound","","",157],[10,"visit_lifetime_ref","","",157],[10,"visit_lifetime_def","","",157],[10,"visit_explicit_self","","",157],[10,"visit_mac","","",157],[10,"visit_path","","",157],[10,"visit_path_segment","","",157],[10,"visit_path_parameters","","",157],[10,"visit_assoc_type_binding","","",157],[10,"visit_attribute","","",157],[10,"visit_ty","","",158],[10,"visit_expr","","",158],[10,"visit_name","","",158],[10,"visit_ident","","",158],[10,"visit_mod","","",158],[10,"visit_view_item","","",158],[10,"visit_foreign_item","","",158],[10,"visit_item","","",158],[10,"visit_local","","",158],[10,"visit_block","","",158],[10,"visit_stmt","","",158],[10,"visit_arm","","",158],[10,"visit_pat","","",158],[10,"visit_decl","","",158],[10,"visit_expr","","",158],[10,"visit_expr_post","","",158],[10,"visit_ty","","",158],[10,"visit_generics","","",158],[10,"visit_fn","","",158],[10,"visit_ty_method","","",158],[10,"visit_trait_item","","",158],[10,"visit_trait_ref","","",158],[10,"visit_ty_param_bound","","",158],[10,"visit_poly_trait_ref","","",158],[10,"visit_struct_def","","",158],[10,"visit_struct_field","","",158],[10,"visit_variant","","",158],[10,"visit_opt_lifetime_ref","","",158],[10,"visit_lifetime_bound","","",158],[10,"visit_lifetime_ref","","",158],[10,"visit_lifetime_def","","",158],[10,"visit_explicit_self","","",158],[10,"visit_mac","","",158],[10,"visit_path","","",158],[10,"visit_path_segment","","",158],[10,"visit_path_parameters","","",158],[10,"visit_assoc_type_binding","","",158],[10,"visit_attribute","","",158],[10,"visit_item","","",159],[10,"visit_generics","","",159],[10,"visit_foreign_item","","",159],[10,"visit_fn","","",159],[10,"visit_ty","","",159],[10,"visit_variant","","",159],[10,"visit_struct_field","","",159],[10,"visit_view_item","","",159],[10,"visit_block","","",159],[10,"visit_expr","","",159],[10,"visit_name","","",159],[10,"visit_ident","","",159],[10,"visit_mod","","",159],[10,"visit_view_item","","",159],[10,"visit_foreign_item","","",159],[10,"visit_item","","",159],[10,"visit_local","","",159],[10,"visit_block","","",159],[10,"visit_stmt","","",159],[10,"visit_arm","","",159],[10,"visit_pat","","",159],[10,"visit_decl","","",159],[10,"visit_expr","","",159],[10,"visit_expr_post","","",159],[10,"visit_ty","","",159],[10,"visit_generics","","",159],[10,"visit_fn","","",159],[10,"visit_ty_method","","",159],[10,"visit_trait_item","","",159],[10,"visit_trait_ref","","",159],[10,"visit_ty_param_bound","","",159],[10,"visit_poly_trait_ref","","",159],[10,"visit_struct_def","","",159],[10,"visit_struct_field","","",159],[10,"visit_variant","","",159],[10,"visit_opt_lifetime_ref","","",159],[10,"visit_lifetime_bound","","",159],[10,"visit_lifetime_ref","","",159],[10,"visit_lifetime_def","","",159],[10,"visit_explicit_self","","",159],[10,"visit_mac","","",159],[10,"visit_path","","",159],[10,"visit_path_segment","","",159],[10,"visit_path_parameters","","",159],[10,"visit_assoc_type_binding","","",159],[10,"visit_attribute","","",159],[10,"visit_expr","rustc::middle::reachable","",160],[10,"visit_item","","",160],[10,"visit_name","","",160],[10,"visit_ident","","",160],[10,"visit_mod","","",160],[10,"visit_view_item","","",160],[10,"visit_foreign_item","","",160],[10,"visit_item","","",160],[10,"visit_local","","",160],[10,"visit_block","","",160],[10,"visit_stmt","","",160],[10,"visit_arm","","",160],[10,"visit_pat","","",160],[10,"visit_decl","","",160],[10,"visit_expr","","",160],[10,"visit_expr_post","","",160],[10,"visit_ty","","",160],[10,"visit_generics","","",160],[10,"visit_fn","","",160],[10,"visit_ty_method","","",160],[10,"visit_trait_item","","",160],[10,"visit_trait_ref","","",160],[10,"visit_ty_param_bound","","",160],[10,"visit_poly_trait_ref","","",160],[10,"visit_struct_def","","",160],[10,"visit_struct_field","","",160],[10,"visit_variant","","",160],[10,"visit_opt_lifetime_ref","","",160],[10,"visit_lifetime_bound","","",160],[10,"visit_lifetime_ref","","",160],[10,"visit_lifetime_def","","",160],[10,"visit_explicit_self","","",160],[10,"visit_mac","","",160],[10,"visit_path","","",160],[10,"visit_path_segment","","",160],[10,"visit_path_parameters","","",160],[10,"visit_assoc_type_binding","","",160],[10,"visit_attribute","","",160],[10,"fmt","rustc::middle::region","",18],[10,"decode","","",18],[10,"encode","","",18],[10,"hash","","",18],[10,"cmp","","",18],[10,"assert_receiver_is_total_eq","","",18],[10,"partial_cmp","","",18],[10,"lt","","",18],[10,"le","","",18],[10,"gt","","",18],[10,"ge","","",18],[10,"lt","","",18],[10,"le","","",18],[10,"gt","","",18],[10,"ge","","",18],[10,"eq","","",18],[10,"ne","","",18],[10,"ne","","",18],[10,"clone","","",18],[10,"clone_from","","",18],[10,"from_node_id","","Creates a scope that represents the dynamic extent associated\nwith `node_id`.",18],[10,"node_id","","Returns a node id associated with this scope.",18],[10,"map_id","","Maps this scope to a potentially new one according to the\nNodeId transformer `f_id`.",18],[10,"relate_free_regions","","",161],[10,"record_encl_scope","","",161],[10,"record_var_scope","","",161],[10,"record_rvalue_scope","","",161],[10,"mark_as_terminating_scope","","Records that a scope is a TERMINATING SCOPE. Whenever we create automatic temporaries --\ne.g. by an expression like `a().f` -- they will be freed within the innermost terminating\nscope.",161],[10,"opt_encl_scope","","Returns the narrowest scope that encloses `id`, if any.",161],[10,"encl_scope","","Returns the narrowest scope that encloses `id`, if any.",161],[10,"var_scope","","Returns the lifetime of the local variable `var_id`",161],[10,"temporary_scope","","Returns the scope when temp created by expr_id will be cleaned up",161],[10,"var_region","","Returns the lifetime of the variable `id`.",161],[10,"scopes_intersect","","",161],[10,"is_subscope_of","","Returns true if `subscope` is equal to or is lexically nested inside `superscope` and false\notherwise.",161],[10,"sub_free_region","","Determines whether two free regions have a subregion relationship\nby walking the graph encoded in `free_region_map`.  Note that\nit is possible that `sub != sup` and `sub <= sup` and `sup <= sub`\n(that is, the user can give two different names to the same lifetime).",161],[10,"is_subregion_of","","Determines whether one region is a subregion of another.  This is intended to run *after\ninference* and sadly the logic is somewhat duplicated with the code in infer.rs.",161],[10,"nearest_common_ancestor","","Finds the nearest common ancestor (if any) of two scopes.  That is, finds the smallest\nscope which is greater than or equal to both `scope_a` and `scope_b`.",161],[10,"visit_block","","",162],[10,"visit_item","","",162],[10,"visit_fn","","",162],[10,"visit_arm","","",162],[10,"visit_pat","","",162],[10,"visit_stmt","","",162],[10,"visit_expr","","",162],[10,"visit_local","","",162],[10,"visit_name","","",162],[10,"visit_ident","","",162],[10,"visit_mod","","",162],[10,"visit_view_item","","",162],[10,"visit_foreign_item","","",162],[10,"visit_item","","",162],[10,"visit_local","","",162],[10,"visit_block","","",162],[10,"visit_stmt","","",162],[10,"visit_arm","","",162],[10,"visit_pat","","",162],[10,"visit_decl","","",162],[10,"visit_expr","","",162],[10,"visit_expr_post","","",162],[10,"visit_ty","","",162],[10,"visit_generics","","",162],[10,"visit_fn","","",162],[10,"visit_ty_method","","",162],[10,"visit_trait_item","","",162],[10,"visit_trait_ref","","",162],[10,"visit_ty_param_bound","","",162],[10,"visit_poly_trait_ref","","",162],[10,"visit_struct_def","","",162],[10,"visit_struct_field","","",162],[10,"visit_variant","","",162],[10,"visit_opt_lifetime_ref","","",162],[10,"visit_lifetime_bound","","",162],[10,"visit_lifetime_ref","","",162],[10,"visit_lifetime_def","","",162],[10,"visit_explicit_self","","",162],[10,"visit_mac","","",162],[10,"visit_path","","",162],[10,"visit_path_segment","","",162],[10,"visit_path_parameters","","",162],[10,"visit_assoc_type_binding","","",162],[10,"visit_attribute","","",162],[10,"fmt","rustc::middle::resolve_lifetime","",163],[10,"decode","","",163],[10,"encode","","",163],[10,"hash","","",163],[10,"assert_receiver_is_total_eq","","",163],[10,"eq","","",163],[10,"ne","","",163],[10,"ne","","",163],[10,"clone","","",163],[10,"clone_from","","",163],[10,"visit_item","","",164],[10,"visit_fn","","",164],[10,"visit_ty","","",164],[10,"visit_ty_method","","",164],[10,"visit_block","","",164],[10,"visit_lifetime_ref","","",164],[10,"visit_generics","","",164],[10,"visit_poly_trait_ref","","",164],[10,"visit_trait_ref","","",164],[10,"visit_name","","",164],[10,"visit_ident","","",164],[10,"visit_mod","","",164],[10,"visit_view_item","","",164],[10,"visit_foreign_item","","",164],[10,"visit_item","","",164],[10,"visit_local","","",164],[10,"visit_block","","",164],[10,"visit_stmt","","",164],[10,"visit_arm","","",164],[10,"visit_pat","","",164],[10,"visit_decl","","",164],[10,"visit_expr","","",164],[10,"visit_expr_post","","",164],[10,"visit_ty","","",164],[10,"visit_generics","","",164],[10,"visit_fn","","",164],[10,"visit_ty_method","","",164],[10,"visit_trait_item","","",164],[10,"visit_trait_ref","","",164],[10,"visit_ty_param_bound","","",164],[10,"visit_poly_trait_ref","","",164],[10,"visit_struct_def","","",164],[10,"visit_struct_field","","",164],[10,"visit_variant","","",164],[10,"visit_opt_lifetime_ref","","",164],[10,"visit_lifetime_bound","","",164],[10,"visit_lifetime_ref","","",164],[10,"visit_lifetime_def","","",164],[10,"visit_explicit_self","","",164],[10,"visit_mac","","",164],[10,"visit_path","","",164],[10,"visit_path_segment","","",164],[10,"visit_path_parameters","","",164],[10,"visit_assoc_type_binding","","",164],[10,"visit_attribute","","",164],[10,"fmt","","",165],[10,"visit_item","rustc::middle::stability","",166],[10,"visit_fn","","",166],[10,"visit_trait_item","","",166],[10,"visit_variant","","",166],[10,"visit_struct_field","","",166],[10,"visit_foreign_item","","",166],[10,"visit_name","","",166],[10,"visit_ident","","",166],[10,"visit_mod","","",166],[10,"visit_view_item","","",166],[10,"visit_foreign_item","","",166],[10,"visit_item","","",166],[10,"visit_local","","",166],[10,"visit_block","","",166],[10,"visit_stmt","","",166],[10,"visit_arm","","",166],[10,"visit_pat","","",166],[10,"visit_decl","","",166],[10,"visit_expr","","",166],[10,"visit_expr_post","","",166],[10,"visit_ty","","",166],[10,"visit_generics","","",166],[10,"visit_fn","","",166],[10,"visit_ty_method","","",166],[10,"visit_trait_item","","",166],[10,"visit_trait_ref","","",166],[10,"visit_ty_param_bound","","",166],[10,"visit_poly_trait_ref","","",166],[10,"visit_struct_def","","",166],[10,"visit_struct_field","","",166],[10,"visit_variant","","",166],[10,"visit_opt_lifetime_ref","","",166],[10,"visit_lifetime_bound","","",166],[10,"visit_lifetime_ref","","",166],[10,"visit_lifetime_def","","",166],[10,"visit_explicit_self","","",166],[10,"visit_mac","","",166],[10,"visit_path","","",166],[10,"visit_path_segment","","",166],[10,"visit_path_parameters","","",166],[10,"visit_assoc_type_binding","","",166],[10,"visit_attribute","","",166],[10,"build","","Construct the stability index for a crate being compiled.",167],[10,"fmt","rustc::middle::subst","",168],[10,"hash","","",168],[10,"assert_receiver_is_total_eq","","",168],[10,"eq","","",168],[10,"ne","","",168],[10,"ne","","",168],[10,"clone","","",168],[10,"clone_from","","",168],[10,"fmt","","",169],[10,"hash","","",169],[10,"assert_receiver_is_total_eq","","",169],[10,"eq","","",169],[10,"ne","","",169],[10,"ne","","",169],[10,"clone","","",169],[10,"clone_from","","",169],[10,"new","","",168],[10,"new_type","","",168],[10,"new_trait","","",168],[10,"erased","","",168],[10,"empty","","",168],[10,"trans_empty","","",168],[10,"is_noop","","",168],[10,"type_for_def","","",168],[10,"has_regions_escaping_depth","","",168],[10,"self_ty","","",168],[10,"with_self_ty","","",168],[10,"erase_regions","","",168],[10,"regions","","Since ErasedRegions are only to be used in trans, most of the compiler can use this method\nto easily access the set of region substitutions.",168],[10,"mut_regions","","Since ErasedRegions are only to be used in trans, most of the compiler can use this method\nto easily access the set of region substitutions.",168],[10,"with_method","","",168],[10,"is_erased","","",169],[10,"fmt","","",170],[10,"decode","","",170],[10,"encode","","",170],[10,"hash","","",170],[10,"clone","","",170],[10,"clone_from","","",170],[10,"assert_receiver_is_total_eq","","",170],[10,"eq","","",170],[10,"ne","","",170],[10,"ne","","",170],[10,"cmp","","",170],[10,"partial_cmp","","",170],[10,"lt","","",170],[10,"le","","",170],[10,"gt","","",170],[10,"ge","","",170],[10,"lt","","",170],[10,"le","","",170],[10,"gt","","",170],[10,"ge","","",170],[10,"all","","",170],[10,"to_uint","","",170],[10,"from_uint","","",170],[10,"decode","","",171],[10,"encode","","",171],[10,"hash","","",171],[10,"clone","","",171],[10,"clone_from","","",171],[10,"assert_receiver_is_total_eq","","",171],[10,"eq","","",171],[10,"ne","","",171],[10,"ne","","",171],[10,"fmt","","",171],[10,"empty","","",171],[10,"params_from_type","","",171],[10,"new","","`t` is the type space.\n`s` is the self space.\n`a` is the assoc space.\n`f` is the fn space.",171],[10,"push","","Appends `value` to the vector associated with `space`.",171],[10,"pop","","",171],[10,"truncate","","",171],[10,"replace","","",171],[10,"get_self","","",171],[10,"len","","",171],[10,"is_empty_in","","",171],[10,"get_slice","","",171],[10,"get_mut_slice","","",171],[10,"opt_get","","",171],[10,"get","","",171],[10,"iter","","",171],[10,"iter_enumerated","","",171],[10,"as_slice","","",171],[10,"to_vec","","",171],[10,"all_vecs","","",171],[10,"all","","",171],[10,"any","","",171],[10,"is_empty","","",171],[10,"map","","",171],[10,"map_enumerated","","",171],[10,"map_move","","",171],[10,"split","","",171],[10,"with_vec","","",171],[10,"clone","","",172],[10,"clone_from","","",172],[10,"next","","",172],[10,"size_hint","","",172],[10,"tcx","","",173],[10,"enter_region_binder","","",173],[10,"exit_region_binder","","",173],[10,"fold_region","","",173],[10,"fold_ty","","",173],[10,"enter_region_binder","","",173],[10,"exit_region_binder","","",173],[10,"fold_ty","","",173],[10,"fold_mt","","",173],[10,"fold_trait_ref","","",173],[10,"fold_substs","","",173],[10,"fold_fn_sig","","",173],[10,"fold_output","","",173],[10,"fold_bare_fn_ty","","",173],[10,"fold_closure_ty","","",173],[10,"fold_region","","",173],[10,"fold_trait_store","","",173],[10,"fold_existential_bounds","","",173],[10,"fold_autoref","","",173],[10,"fold_item_substs","","",173],[10,"new","rustc::middle::traits::fulfill","",174],[10,"normalize_projection_type","","\"Normalize\" a projection type `<SomeType as SomeTrait>::X` by\ncreating a fresh type variable `$0` as well as a projection\npredicate `<SomeType as SomeTrait>::X == $0`. When the\ninference engine runs, it will attempt to find an impl of\n`SomeTrait` or a where clause that lets us unify `$0` with\nsomething concrete. If this fails, we'll unify `$0` with\n`projection_ty` again.",174],[10,"register_builtin_bound","","",174],[10,"register_region_obligation","","",174],[10,"register_predicate_obligation","","",174],[10,"region_obligations","","",174],[10,"select_all_or_error","","",174],[10,"select_new_obligations","","Attempts to select obligations that were registered since the call to a selection routine.\nThis is used by the type checker to eagerly attempt to resolve obligations in hopes of\ngaining type information. It'd be equally valid to use `select_where_possible` but it\nresults in `O(n^2)` performance (#18208).",174],[10,"select_where_possible","","",174],[10,"pending_obligations","","",174],[10,"repr","","",175],[10,"clone","rustc::middle::traits::project","",176],[10,"clone_from","","",176],[10,"tcx","","",177],[10,"fold_ty","","",177],[10,"enter_region_binder","","",177],[10,"exit_region_binder","","",177],[10,"fold_ty","","",177],[10,"fold_mt","","",177],[10,"fold_trait_ref","","",177],[10,"fold_substs","","",177],[10,"fold_fn_sig","","",177],[10,"fold_output","","",177],[10,"fold_bare_fn_ty","","",177],[10,"fold_closure_ty","","",177],[10,"fold_region","","",177],[10,"fold_trait_store","","",177],[10,"fold_existential_bounds","","",177],[10,"fold_autoref","","",177],[10,"fold_item_substs","","",177],[10,"repr","","",178],[10,"repr","","",179],[10,"clone","rustc::middle::traits::select","",180],[10,"clone_from","","",180],[10,"fmt","","",181],[10,"clone","","",182],[10,"clone_from","","",182],[10,"fmt","","",182],[10,"assert_receiver_is_total_eq","","",182],[10,"eq","","",182],[10,"ne","","",182],[10,"ne","","",182],[10,"fmt","","",183],[10,"new","","",184],[10,"intercrate","","",184],[10,"infcx","","",184],[10,"param_env","","",184],[10,"tcx","","",184],[10,"select","","Evaluates whether the obligation can be satisfied. Returns an indication of whether the\nobligation can be satisfied and, if so, by what means. Never affects surrounding typing\nenvironment.",184],[10,"evaluate_obligation","","Evaluates whether the obligation `obligation` can be satisfied (by any means).",184],[10,"evaluate_impl","","Evaluates whether the impl with id `impl_def_id` could be applied to the self type\n`obligation_self_ty`. This can be used either for trait or inherent impls.",184],[10,"repr","","",182],[10,"new","","",180],[10,"next","core::option","",12],[10,"size_hint","","",12],[10,"repr","rustc::middle::traits::select","",185],[10,"may_apply","","",186],[10,"filter_to_traits","rustc::middle::traits::util","",187],[10,"next","","",187],[10,"size_hint","","",187],[10,"next","","",188],[10,"size_hint","","",188],[10,"fmt","rustc::middle::traits","",189],[10,"repr","","",190],[10,"repr","","",191],[10,"repr","","",189],[10,"repr","","",192],[10,"repr","","",193],[10,"repr","","",194],[10,"repr","","",195],[10,"fmt","","",195],[10,"repr","rustc::middle::traits::project","",176],[10,"fmt","","",176],[10,"clone","rustc::middle::traits","",190],[10,"clone_from","","",190],[10,"clone","","",196],[10,"clone_from","","",196],[10,"clone","","",197],[10,"clone_from","","",197],[10,"clone","","",198],[10,"clone_from","","",198],[10,"fmt","","",193],[10,"clone","","",193],[10,"clone_from","","",193],[10,"clone","","",195],[10,"clone_from","","",195],[10,"clone","","",191],[10,"clone_from","","",191],[10,"fmt","","",191],[10,"clone","","",189],[10,"clone_from","","",189],[10,"clone","","",192],[10,"clone_from","","",192],[10,"fmt","","",192],[10,"new","","",190],[10,"misc","","",190],[10,"with","","",190],[10,"new","","",196],[10,"misc","","",196],[10,"dummy","","",196],[10,"iter_nested","","",191],[10,"map_nested","","",191],[10,"map_move_nested","","",191],[10,"iter_nested","","",189],[10,"map_nested","","",189],[10,"map_move_nested","","",189],[10,"iter_nested","","",192],[10,"map_nested","","",192],[10,"map_move_nested","","",192],[10,"is_overflow","","",194],[10,"hash","rustc::middle::ty","",199],[10,"assert_receiver_is_total_eq","","",199],[10,"eq","","",199],[10,"ne","","",199],[10,"ne","","",199],[10,"fmt","","",200],[10,"clone","","",200],[10,"clone_from","","",200],[10,"id","","",200],[10,"clone","","",201],[10,"clone_from","","",201],[10,"def_id","","",201],[10,"name","","",201],[10,"container","","",201],[10,"as_opt_method","","",201],[10,"clone","","",202],[10,"clone_from","","",202],[10,"def_id","","",202],[10,"fmt","","",203],[10,"clone","","",203],[10,"clone_from","","",203],[10,"new","","",203],[10,"container_id","","",203],[10,"clone","","",204],[10,"clone_from","","",204],[10,"fmt","","",205],[10,"hash","","",205],[10,"assert_receiver_is_total_eq","","",205],[10,"eq","","",205],[10,"ne","","",205],[10,"ne","","",205],[10,"clone","","",205],[10,"clone_from","","",205],[10,"fmt","","",20],[10,"decode","","",20],[10,"encode","","",20],[10,"hash","","",20],[10,"assert_receiver_is_total_eq","","",20],[10,"eq","","",20],[10,"ne","","",20],[10,"ne","","",20],[10,"clone","","",20],[10,"clone_from","","",20],[10,"fmt","","",206],[10,"clone","","",206],[10,"clone_from","","",206],[10,"hash","","",207],[10,"assert_receiver_is_total_eq","","",207],[10,"eq","","",207],[10,"ne","","",207],[10,"ne","","",207],[10,"encode","","",208],[10,"decode","","",208],[10,"eq","","",208],[10,"ne","","",208],[10,"ne","","",208],[10,"clone","","",208],[10,"clone_from","","",208],[10,"fmt","","",209],[10,"encode","","",209],[10,"decode","","",209],[10,"eq","","",209],[10,"ne","","",209],[10,"ne","","",209],[10,"clone","","",209],[10,"clone_from","","",209],[10,"fmt","","",210],[10,"clone","","",210],[10,"clone_from","","",210],[10,"fmt","","",211],[10,"eq","","",211],[10,"ne","","",211],[10,"ne","","",211],[10,"clone","","",211],[10,"clone_from","","",211],[10,"fmt","","",212],[10,"clone","","",212],[10,"clone_from","","",212],[10,"fmt","","",213],[10,"eq","","",213],[10,"ne","","",213],[10,"ne","","",213],[10,"clone","","",213],[10,"clone_from","","",213],[10,"fmt","","",214],[10,"partial_cmp","","",214],[10,"lt","","",214],[10,"le","","",214],[10,"gt","","",214],[10,"ge","","",214],[10,"lt","","",214],[10,"le","","",214],[10,"gt","","",214],[10,"ge","","",214],[10,"eq","","",214],[10,"ne","","",214],[10,"ne","","",214],[10,"decode","","",214],[10,"encode","","",214],[10,"clone","","",214],[10,"clone_from","","",214],[10,"fmt","","",24],[10,"clone","","",24],[10,"clone_from","","",24],[10,"fmt","","",215],[10,"clone","","",215],[10,"clone_from","","",215],[10,"fmt","","",216],[10,"clone","","",216],[10,"clone_from","","",216],[10,"clone","","",217],[10,"clone_from","","",217],[10,"fmt","","",218],[10,"hash","","",218],[10,"assert_receiver_is_total_eq","","",218],[10,"eq","","",218],[10,"ne","","",218],[10,"ne","","",218],[10,"clone","","",218],[10,"clone_from","","",218],[10,"decode","","",219],[10,"encode","","",219],[10,"fmt","","",219],[10,"hash","","",219],[10,"assert_receiver_is_total_eq","","",219],[10,"eq","","",219],[10,"ne","","",219],[10,"ne","","",219],[10,"clone","","",219],[10,"clone_from","","",219],[10,"expr","","",218],[10,"autoobject","","",218],[10,"autoderef","","",218],[10,"clone","","",220],[10,"clone_from","","",220],[10,"new","","",221],[10,"hash","","",222],[10,"cmp","","",222],[10,"partial_cmp","","",222],[10,"lt","","",222],[10,"le","","",222],[10,"gt","","",222],[10,"ge","","",222],[10,"lt","","",222],[10,"le","","",222],[10,"gt","","",222],[10,"ge","","",222],[10,"clone","","",222],[10,"clone_from","","",222],[10,"assert_receiver_is_total_eq","","",222],[10,"eq","","",222],[10,"ne","","",222],[10,"ne","","",222],[10,"empty","","Returns an empty set of flags.",222],[10,"all","","Returns the set containing all flags.",222],[10,"bits","","Returns the raw value of the flags currently stored.",222],[10,"from_bits","","Convert from underlying bit representation, unless that\nrepresentation contains bits that do not correspond to a flag.",222],[10,"from_bits_truncate","","Convert from underlying bit representation, dropping any bits\nthat do not correspond to flags.",222],[10,"is_empty","","Returns `true` if no flags are currently stored.",222],[10,"is_all","","Returns `true` if all flags are currently set.",222],[10,"intersects","","Returns `true` if there are flags common to both `self` and `other`.",222],[10,"contains","","Returns `true` all of the flags in `other` are contained within `self`.",222],[10,"insert","","Inserts the specified flags in-place.",222],[10,"remove","","Removes the specified flags in-place.",222],[10,"toggle","","Toggles the specified flags in-place.",222],[10,"bitor","","Returns the union of the two sets of flags.",222],[10,"bitxor","","Returns the left flags, but with all the right flags toggled.",222],[10,"bitand","","Returns the intersection between the two sets of flags.",222],[10,"sub","","Returns the set difference of the two sets of flags.",222],[10,"not","","Returns the complement of this set of flags.",222],[10,"print_debug_stats","","",223],[10,"fmt","","",224],[10,"fmt","","",222],[10,"eq","","",224],[10,"ne","","",224],[10,"assert_receiver_is_total_eq","","",224],[10,"hash","","",224],[10,"eq","","",225],[10,"ne","","",225],[10,"assert_receiver_is_total_eq","","",225],[10,"hash","","",225],[10,"borrow_from","","",226],[10,"fmt","","",227],[10,"hash","","",227],[10,"assert_receiver_is_total_eq","","",227],[10,"eq","","",227],[10,"ne","","",227],[10,"ne","","",227],[10,"clone","","",227],[10,"clone_from","","",227],[10,"fmt","","",228],[10,"hash","","",228],[10,"assert_receiver_is_total_eq","","",228],[10,"eq","","",228],[10,"ne","","",228],[10,"ne","","",228],[10,"clone","","",228],[10,"clone_from","","",228],[10,"hash","","",229],[10,"assert_receiver_is_total_eq","","",229],[10,"eq","","",229],[10,"ne","","",229],[10,"ne","","",229],[10,"clone","","",229],[10,"clone_from","","",229],[10,"unwrap","","",229],[10,"hash","","",84],[10,"assert_receiver_is_total_eq","","",84],[10,"eq","","",84],[10,"ne","","",84],[10,"ne","","",84],[10,"clone","","",84],[10,"clone_from","","",84],[10,"fmt","","",230],[10,"hash","","",230],[10,"assert_receiver_is_total_eq","","",230],[10,"eq","","",230],[10,"ne","","",230],[10,"ne","","",230],[10,"clone","","",230],[10,"clone_from","","",230],[10,"fmt","","",231],[10,"decode","","",231],[10,"encode","","",231],[10,"hash","","",231],[10,"assert_receiver_is_total_eq","","",231],[10,"eq","","",231],[10,"ne","","",231],[10,"ne","","",231],[10,"clone","","",231],[10,"clone_from","","",231],[10,"fmt","","",16],[10,"decode","","",16],[10,"encode","","",16],[10,"hash","","",16],[10,"assert_receiver_is_total_eq","","",16],[10,"eq","","",16],[10,"ne","","",16],[10,"ne","","",16],[10,"clone","","",16],[10,"clone_from","","",16],[10,"fmt","","",232],[10,"hash","","",232],[10,"assert_receiver_is_total_eq","","",232],[10,"eq","","",232],[10,"ne","","",232],[10,"ne","","",232],[10,"clone","","",232],[10,"clone_from","","",232],[10,"decode","","",233],[10,"encode","","",233],[10,"fmt","","",233],[10,"hash","","",233],[10,"assert_receiver_is_total_eq","","",233],[10,"eq","","",233],[10,"ne","","",233],[10,"ne","","",233],[10,"clone","","",233],[10,"clone_from","","",233],[10,"fmt","","",23],[10,"decode","","",23],[10,"encode","","",23],[10,"clone","","",23],[10,"clone_from","","",23],[10,"eq","","",23],[10,"ne","","",23],[10,"ne","","",23],[10,"is_bound","","",16],[10,"escapes_depth","","",16],[10,"fmt","","",17],[10,"decode","","",17],[10,"encode","","",17],[10,"hash","","",17],[10,"cmp","","",17],[10,"assert_receiver_is_total_eq","","",17],[10,"partial_cmp","","",17],[10,"lt","","",17],[10,"le","","",17],[10,"gt","","",17],[10,"ge","","",17],[10,"lt","","",17],[10,"le","","",17],[10,"gt","","",17],[10,"ge","","",17],[10,"eq","","",17],[10,"ne","","",17],[10,"ne","","",17],[10,"clone","","",17],[10,"clone_from","","",17],[10,"fmt","","",19],[10,"decode","","",19],[10,"encode","","",19],[10,"hash","","",19],[10,"cmp","","",19],[10,"assert_receiver_is_total_eq","","",19],[10,"partial_cmp","","",19],[10,"lt","","",19],[10,"le","","",19],[10,"gt","","",19],[10,"ge","","",19],[10,"lt","","",19],[10,"le","","",19],[10,"gt","","",19],[10,"ge","","",19],[10,"eq","","",19],[10,"ne","","",19],[10,"ne","","",19],[10,"clone","","",19],[10,"clone_from","","",19],[10,"fmt","","",226],[10,"hash","","",226],[10,"assert_receiver_is_total_eq","","",226],[10,"eq","","",226],[10,"ne","","",226],[10,"ne","","",226],[10,"clone","","",226],[10,"clone_from","","",226],[10,"fmt","","",234],[10,"hash","","",234],[10,"assert_receiver_is_total_eq","","",234],[10,"eq","","",234],[10,"ne","","",234],[10,"ne","","",234],[10,"clone","","",234],[10,"clone_from","","",234],[10,"principal_def_id","","",234],[10,"principal_trait_ref_with_self_ty","","Object types don't have a self-type specified. Therefore, when\nwe convert the principal trait-ref into a normal trait-ref,\nyou must give *some* self-type. A common choice is `mk_err()`\nor some skolemized type.",234],[10,"projection_bounds_with_self_ty","","",234],[10,"fmt","","",82],[10,"hash","","",82],[10,"assert_receiver_is_total_eq","","",82],[10,"eq","","",82],[10,"ne","","",82],[10,"ne","","",82],[10,"clone","","",82],[10,"clone_from","","",82],[10,"self_ty","","",89],[10,"def_id","","",89],[10,"substs","","",89],[10,"input_types","","",89],[10,"to_poly_trait_predicate","","",89],[10,"fmt","","",89],[10,"hash","","",89],[10,"assert_receiver_is_total_eq","","",89],[10,"eq","","",89],[10,"ne","","",89],[10,"ne","","",89],[10,"clone","","",89],[10,"clone_from","","",89],[10,"eq","","",117],[10,"ne","","",117],[10,"ne","","",117],[10,"clone","","",117],[10,"clone_from","","",117],[10,"fmt","","",235],[10,"clone","","",235],[10,"clone_from","","",235],[10,"fmt","","",236],[10,"clone","","",236],[10,"clone_from","","",236],[10,"fmt","","",237],[10,"clone","","",237],[10,"clone_from","","",237],[10,"fmt","","",238],[10,"clone","","",238],[10,"clone_from","","",238],[10,"hash","","",238],[10,"assert_receiver_is_total_eq","","",238],[10,"eq","","",238],[10,"ne","","",238],[10,"ne","","",238],[10,"fmt","","",239],[10,"clone","","",239],[10,"clone_from","","",239],[10,"hash","","",239],[10,"assert_receiver_is_total_eq","","",239],[10,"eq","","",239],[10,"ne","","",239],[10,"ne","","",239],[10,"fmt","","",240],[10,"hash","","",240],[10,"decode","","",240],[10,"assert_receiver_is_total_eq","","",240],[10,"eq","","",240],[10,"ne","","",240],[10,"ne","","",240],[10,"encode","","",240],[10,"clone","","",240],[10,"clone_from","","",240],[10,"to_uint","","",240],[10,"from_uint","","",240],[10,"hash","","",241],[10,"assert_receiver_is_total_eq","","",241],[10,"eq","","",241],[10,"ne","","",241],[10,"ne","","",241],[10,"clone","","",241],[10,"clone_from","","",241],[10,"hash","","",116],[10,"assert_receiver_is_total_eq","","",116],[10,"eq","","",116],[10,"ne","","",116],[10,"ne","","",116],[10,"clone","","",116],[10,"clone_from","","",116],[10,"hash","","",118],[10,"assert_receiver_is_total_eq","","",118],[10,"eq","","",118],[10,"ne","","",118],[10,"ne","","",118],[10,"clone","","",118],[10,"clone_from","","",118],[10,"hash","","",242],[10,"decode","","",242],[10,"encode","","",242],[10,"assert_receiver_is_total_eq","","",242],[10,"eq","","",242],[10,"ne","","",242],[10,"ne","","",242],[10,"clone","","",242],[10,"clone_from","","",242],[10,"hash","","",243],[10,"assert_receiver_is_total_eq","","",243],[10,"eq","","",243],[10,"ne","","",243],[10,"ne","","",243],[10,"clone","","",243],[10,"clone_from","","",243],[10,"fmt","","",244],[10,"hash","","",244],[10,"assert_receiver_is_total_eq","","",244],[10,"decode","","",244],[10,"encode","","",244],[10,"clone","","",244],[10,"clone_from","","",244],[10,"eq","","",244],[10,"ne","","",244],[10,"ne","","",244],[10,"fmt","","",241],[10,"fmt","","",116],[10,"fmt","","",118],[10,"fmt","","",242],[10,"fmt","","",84],[10,"fmt","","",243],[10,"fmt","","",117],[10,"fmt","","",245],[10,"clone","","",245],[10,"clone_from","","",245],[10,"fmt","","",246],[10,"clone","","",246],[10,"clone_from","","",246],[10,"decode","","",246],[10,"encode","","",246],[10,"to_early_bound_region","","",246],[10,"fmt","","",247],[10,"clone","","",247],[10,"clone_from","","",247],[10,"empty","","",247],[10,"has_type_params","","",247],[10,"has_region_params","","",247],[10,"to_bounds","","",247],[10,"fmt","","",248],[10,"hash","","",248],[10,"assert_receiver_is_total_eq","","",248],[10,"eq","","",248],[10,"ne","","",248],[10,"ne","","",248],[10,"clone","","",248],[10,"clone_from","","",248],[10,"fmt","","",249],[10,"hash","","",249],[10,"assert_receiver_is_total_eq","","",249],[10,"eq","","",249],[10,"ne","","",249],[10,"ne","","",249],[10,"clone","","",249],[10,"clone_from","","",249],[10,"def_id","","",249],[10,"input_types","","",249],[10,"self_ty","","",249],[10,"def_id","","",89],[10,"fmt","","",250],[10,"hash","","",250],[10,"assert_receiver_is_total_eq","","",250],[10,"eq","","",250],[10,"ne","","",250],[10,"ne","","",250],[10,"clone","","",250],[10,"clone_from","","",250],[10,"fmt","","",251],[10,"hash","","",251],[10,"assert_receiver_is_total_eq","","",251],[10,"eq","","",251],[10,"ne","","",251],[10,"ne","","",251],[10,"clone","","",251],[10,"clone_from","","",251],[10,"fmt","","",83],[10,"hash","","",83],[10,"assert_receiver_is_total_eq","","",83],[10,"eq","","",83],[10,"ne","","",83],[10,"ne","","",83],[10,"clone","","",83],[10,"clone_from","","",83],[10,"sort_key","","",89],[10,"fmt","","",252],[10,"hash","","",252],[10,"assert_receiver_is_total_eq","","",252],[10,"eq","","",252],[10,"ne","","",252],[10,"ne","","",252],[10,"clone","","",252],[10,"clone_from","","",252],[10,"sort_key","","",252],[10,"to_poly_trait_ref","alloc::rc","",81],[10,"to_poly_trait_ref","rustc::middle::ty","",89],[10,"to_poly_trait_ref","","",89],[10,"as_predicate","alloc::rc","",81],[10,"as_predicate","rustc::middle::ty","",89],[10,"as_predicate","","",89],[10,"as_predicate","","",89],[10,"as_predicate","","",89],[10,"as_predicate","","",89],[10,"has_escaping_regions","","",248],[10,"to_opt_poly_trait_ref","","",248],[10,"fmt","","",253],[10,"clone","","",253],[10,"clone_from","","",253],[10,"empty","","",253],[10,"has_escaping_regions","","",253],[10,"is_empty","","",253],[10,"new","","",82],[10,"self_ty","","",82],[10,"input_types","","",82],[10,"clone","","",254],[10,"clone_from","","",254],[10,"for_item","","",254],[10,"fmt","","",255],[10,"clone","","",255],[10,"clone_from","","",255],[10,"clone","","",256],[10,"clone_from","","",256],[10,"clone","","",257],[10,"clone_from","","",257],[10,"fmt","","",258],[10,"assert_receiver_is_total_eq","","",258],[10,"eq","","",258],[10,"ne","","",258],[10,"ne","","",258],[10,"clone","","",258],[10,"clone_from","","",258],[10,"trait_did","","",258],[10,"mk_substs","","",223],[10,"mk_bare_fn","","",223],[10,"mk_region","","",223],[10,"new","","",230],[10,"for_self","","",230],[10,"for_def","","",230],[10,"to_ty","","",230],[10,"is_self","","",230],[10,"empty","","",256],[10,"is_noop","","",256],[10,"empty","","",238],[10,"clone","","",259],[10,"clone_from","","",259],[10,"when","","",259],[10,"intersects","","",259],[10,"owns_managed","","",259],[10,"owns_owned","","",259],[10,"is_sized","","",259],[10,"interior_param","","",259],[10,"interior_unsafe","","",259],[10,"interior_unsized","","",259],[10,"needs_drop","","",259],[10,"owned_pointer","","Includes only those bits that still apply when indirected through a `Box` pointer",259],[10,"reference","","Includes only those bits that still apply when indirected through a reference (`&`)",259],[10,"managed_pointer","","Includes only those bits that still apply when indirected through a managed pointer (`@`)",259],[10,"unsafe_pointer","","Includes only those bits that still apply when indirected through an unsafe pointer (`*`)",259],[10,"union","","",259],[10,"has_dtor","","",259],[10,"bitor","","",259],[10,"bitand","","",259],[10,"sub","","",259],[10,"fmt","","",259],[10,"fmt","","",260],[10,"eq","","",260],[10,"ne","","",260],[10,"ne","","",260],[10,"assert_receiver_is_total_eq","","",260],[10,"cmp","","",260],[10,"partial_cmp","","",260],[10,"lt","","",260],[10,"le","","",260],[10,"gt","","",260],[10,"ge","","",260],[10,"lt","","",260],[10,"le","","",260],[10,"gt","","",260],[10,"ge","","",260],[10,"repr","","",237],[10,"assert_receiver_is_total_eq","","",261],[10,"eq","","",261],[10,"ne","","",261],[10,"ne","","",261],[10,"partial_cmp","","",261],[10,"lt","","",261],[10,"le","","",261],[10,"gt","","",261],[10,"ge","","",261],[10,"cmp","","",261],[10,"clone","","",262],[10,"clone_from","","",262],[10,"from_ast_variant","","Creates a new VariantInfo from the corresponding ast representation.",262],[10,"is_present","","",263],[10,"has_drop_flag","","",263],[10,"to_string","","",209],[10,"from_mutbl","","",233],[10,"to_mutbl_lossy","","Returns a mutability `m` such that an `&m T` pointer could be used to obtain this borrow\nkind. Because borrow kinds are richer than mutabilities, we sometimes have to pick a\nmutability that is stronger than necessary so that it at least *would permit* the borrow in\nquestion.",233],[10,"to_user_str","","",233],[10,"tcx","","",223],[10,"node_ty","","",223],[10,"expr_ty_adjusted","","",223],[10,"node_method_ty","","",223],[10,"node_method_origin","","",223],[10,"adjustments","","",223],[10,"is_method_call","","",223],[10,"temporary_scope","","",223],[10,"upvar_borrow","","",223],[10,"capture_mode","","",223],[10,"unboxed_closures","","",223],[10,"fmt","","",264],[10,"eq","","",264],[10,"ne","","",264],[10,"ne","","",264],[10,"assert_receiver_is_total_eq","","",264],[10,"clone","","",264],[10,"clone_from","","",264],[10,"decode","","",22],[10,"encode","","",22],[10,"is_identity","","",210],[10,"is_identity","","",212],[10,"new","","",231],[10,"shifted","","",231],[10,"repr","","",210],[10,"repr","","",211],[10,"repr","","",212],[10,"repr","","",213],[10,"repr","","",234],[10,"repr","","",248],[10,"repr","","",220],[10,"has_regions_escaping_depth","rustc::middle::subst","",171],[10,"has_escaping_regions","","",171],[10,"has_regions_escaping_depth","rustc::middle::ty","",255],[10,"has_escaping_regions","","",255],[10,"has_regions_escaping_depth","","",16],[10,"has_escaping_regions","","",16],[10,"has_regions_escaping_depth","","",247],[10,"has_escaping_regions","","",247],[10,"has_regions_escaping_depth","","",248],[10,"has_escaping_regions","","",248],[10,"has_regions_escaping_depth","","",82],[10,"has_escaping_regions","","",82],[10,"has_regions_escaping_depth","rustc::middle::subst","",169],[10,"has_escaping_regions","","",169],[10,"has_regions_escaping_depth","rustc::middle::ty","",89],[10,"has_escaping_regions","","",89],[10,"has_regions_escaping_depth","","",250],[10,"has_escaping_regions","","",250],[10,"has_regions_escaping_depth","","",249],[10,"has_escaping_regions","","",249],[10,"has_regions_escaping_depth","","",251],[10,"has_escaping_regions","","",251],[10,"has_regions_escaping_depth","","",83],[10,"has_escaping_regions","","",83],[10,"has_regions_escaping_depth","","",252],[10,"has_escaping_regions","","",252],[10,"repr","","",83],[10,"has_projection_types","rustc::middle::subst","",171],[10,"has_projection_types","rustc::middle::ty","",253],[10,"has_projection_types","","",248],[10,"has_projection_types","","",249],[10,"has_projection_types","","",250],[10,"has_projection_types","","",16],[10,"has_projection_types","","",251],[10,"has_projection_types","","",83],[10,"has_projection_types","","",252],[10,"has_projection_types","","",82],[10,"has_projection_types","rustc::middle::subst","",168],[10,"has_projection_types","core::option","",12],[10,"has_projection_types","alloc::rc","",81],[10,"has_projection_types","alloc::boxed","",265],[10,"has_projection_types","rustc::middle::ty","",89],[10,"has_projection_types","","",229],[10,"has_projection_types","","",84],[10,"has_projection_types","","",227],[10,"references_error","","",89],[10,"references_error","alloc::rc","",81],[10,"references_error","rustc::middle::ty","",249],[10,"references_error","","",83],[10,"references_error","","",82],[10,"references_error","","",248],[10,"references_error","","",251],[10,"references_error","","",250],[10,"references_error","","",16],[10,"fold_with","core::option","",12],[10,"fold_with","alloc::rc","",81],[10,"fold_with","alloc::boxed","",265],[10,"fold_with","collections::vec","",266],[10,"fold_with","rustc::middle::ty","",89],[10,"fold_with","syntax::owned_slice","",267],[10,"fold_with","rustc::middle::subst","",171],[10,"fold_with","rustc::middle::ty","",20],[10,"fold_with","","",227],[10,"fold_with","","",228],[10,"fold_with","","",205],[10,"fold_with","","",229],[10,"fold_with","","",84],[10,"fold_with","","",82],[10,"fold_with","","",16],[10,"fold_with","rustc::middle::subst","",168],[10,"fold_with","rustc::middle::ty","",256],[10,"fold_with","","",213],[10,"fold_with","","",24],[10,"fold_with","","",220],[10,"fold_with","collections::enum_set","",268],[10,"fold_with","rustc::middle::ty","",239],[10,"fold_with","","",238],[10,"fold_with","","",245],[10,"fold_with","","",246],[10,"fold_with","","",247],[10,"fold_with","","",248],[10,"fold_with","","",83],[10,"fold_with","","",252],[10,"fold_with","","",253],[10,"fold_with","","",211],[10,"fold_with","rustc::middle::traits","",190],[10,"fold_with","","",189],[10,"fold_with","","",192],[10,"fold_with","","",191],[10,"fold_with","rustc::middle::ty","",250],[10,"fold_with","","",249],[10,"fold_with","","",251],[10,"tcx","rustc::middle::ty_fold","",269],[10,"fold_ty","","",269],[10,"enter_region_binder","","",269],[10,"exit_region_binder","","",269],[10,"fold_ty","","",269],[10,"fold_mt","","",269],[10,"fold_trait_ref","","",269],[10,"fold_substs","","",269],[10,"fold_fn_sig","","",269],[10,"fold_output","","",269],[10,"fold_bare_fn_ty","","",269],[10,"fold_closure_ty","","",269],[10,"fold_region","","",269],[10,"fold_trait_store","","",269],[10,"fold_existential_bounds","","",269],[10,"fold_autoref","","",269],[10,"fold_item_substs","","",269],[10,"new","","",270],[10,"tcx","","",270],[10,"enter_region_binder","","",270],[10,"exit_region_binder","","",270],[10,"fold_region","","",270],[10,"enter_region_binder","","",270],[10,"exit_region_binder","","",270],[10,"fold_ty","","",270],[10,"fold_mt","","",270],[10,"fold_trait_ref","","",270],[10,"fold_substs","","",270],[10,"fold_fn_sig","","",270],[10,"fold_output","","",270],[10,"fold_bare_fn_ty","","",270],[10,"fold_closure_ty","","",270],[10,"fold_region","","",270],[10,"fold_trait_store","","",270],[10,"fold_existential_bounds","","",270],[10,"fold_autoref","","",270],[10,"fold_item_substs","","",270],[10,"tcx","","",271],[10,"fold_region","","",271],[10,"enter_region_binder","","",271],[10,"exit_region_binder","","",271],[10,"fold_ty","","",271],[10,"fold_mt","","",271],[10,"fold_trait_ref","","",271],[10,"fold_substs","","",271],[10,"fold_fn_sig","","",271],[10,"fold_output","","",271],[10,"fold_bare_fn_ty","","",271],[10,"fold_closure_ty","","",271],[10,"fold_region","","",271],[10,"fold_trait_store","","",271],[10,"fold_existential_bounds","","",271],[10,"fold_autoref","","",271],[10,"fold_item_substs","","",271],[10,"visit_foreign_item","rustc::middle::weak_lang_items","",272],[10,"visit_name","","",272],[10,"visit_ident","","",272],[10,"visit_mod","","",272],[10,"visit_view_item","","",272],[10,"visit_foreign_item","","",272],[10,"visit_item","","",272],[10,"visit_local","","",272],[10,"visit_block","","",272],[10,"visit_stmt","","",272],[10,"visit_arm","","",272],[10,"visit_pat","","",272],[10,"visit_decl","","",272],[10,"visit_expr","","",272],[10,"visit_expr_post","","",272],[10,"visit_ty","","",272],[10,"visit_generics","","",272],[10,"visit_fn","","",272],[10,"visit_ty_method","","",272],[10,"visit_trait_item","","",272],[10,"visit_trait_ref","","",272],[10,"visit_ty_param_bound","","",272],[10,"visit_poly_trait_ref","","",272],[10,"visit_struct_def","","",272],[10,"visit_struct_field","","",272],[10,"visit_variant","","",272],[10,"visit_opt_lifetime_ref","","",272],[10,"visit_lifetime_bound","","",272],[10,"visit_lifetime_ref","","",272],[10,"visit_lifetime_def","","",272],[10,"visit_explicit_self","","",272],[10,"visit_mac","","",272],[10,"visit_path","","",272],[10,"visit_path_segment","","",272],[10,"visit_path_parameters","","",272],[10,"visit_assoc_type_binding","","",272],[10,"visit_attribute","","",272],[10,"eq","rustc::metadata::common","",273],[10,"ne","","",273],[10,"ne","","",273],[10,"from_uint","","",273],[10,"fmt","","",274],[10,"clone","","",274],[10,"clone_from","","",274],[10,"fmt","rustc::metadata::tydecode","",275],[10,"clone","rustc::metadata::encoder","",276],[10,"clone_from","","",276],[10,"visit_expr","","",277],[10,"visit_item","","",277],[10,"visit_foreign_item","","",277],[10,"visit_name","","",277],[10,"visit_ident","","",277],[10,"visit_mod","","",277],[10,"visit_view_item","","",277],[10,"visit_foreign_item","","",277],[10,"visit_item","","",277],[10,"visit_local","","",277],[10,"visit_block","","",277],[10,"visit_stmt","","",277],[10,"visit_arm","","",277],[10,"visit_pat","","",277],[10,"visit_decl","","",277],[10,"visit_expr","","",277],[10,"visit_expr_post","","",277],[10,"visit_ty","","",277],[10,"visit_generics","","",277],[10,"visit_fn","","",277],[10,"visit_ty_method","","",277],[10,"visit_trait_item","","",277],[10,"visit_trait_ref","","",277],[10,"visit_ty_param_bound","","",277],[10,"visit_poly_trait_ref","","",277],[10,"visit_struct_def","","",277],[10,"visit_struct_field","","",277],[10,"visit_variant","","",277],[10,"visit_opt_lifetime_ref","","",277],[10,"visit_lifetime_bound","","",277],[10,"visit_lifetime_ref","","",277],[10,"visit_lifetime_def","","",277],[10,"visit_explicit_self","","",277],[10,"visit_mac","","",277],[10,"visit_path","","",277],[10,"visit_path_segment","","",277],[10,"visit_path_parameters","","",277],[10,"visit_assoc_type_binding","","",277],[10,"visit_attribute","","",277],[10,"visit_item","","",278],[10,"visit_name","","",278],[10,"visit_ident","","",278],[10,"visit_mod","","",278],[10,"visit_view_item","","",278],[10,"visit_foreign_item","","",278],[10,"visit_item","","",278],[10,"visit_local","","",278],[10,"visit_block","","",278],[10,"visit_stmt","","",278],[10,"visit_arm","","",278],[10,"visit_pat","","",278],[10,"visit_decl","","",278],[10,"visit_expr","","",278],[10,"visit_expr_post","","",278],[10,"visit_ty","","",278],[10,"visit_generics","","",278],[10,"visit_fn","","",278],[10,"visit_ty_method","","",278],[10,"visit_trait_item","","",278],[10,"visit_trait_ref","","",278],[10,"visit_ty_param_bound","","",278],[10,"visit_poly_trait_ref","","",278],[10,"visit_struct_def","","",278],[10,"visit_struct_field","","",278],[10,"visit_variant","","",278],[10,"visit_opt_lifetime_ref","","",278],[10,"visit_lifetime_bound","","",278],[10,"visit_lifetime_ref","","",278],[10,"visit_lifetime_def","","",278],[10,"visit_explicit_self","","",278],[10,"visit_mac","","",278],[10,"visit_path","","",278],[10,"visit_path_segment","","",278],[10,"visit_path_parameters","","",278],[10,"visit_assoc_type_binding","","",278],[10,"visit_attribute","","",278],[10,"eq","rustc::metadata::decoder","",279],[10,"ne","","",279],[10,"ne","","",279],[10,"fmt","","",280],[10,"clone","","",280],[10,"clone_from","","",280],[10,"clone","","",281],[10,"clone_from","","",281],[10,"visit_view_item","rustc::metadata::creader","",282],[10,"visit_item","","",282],[10,"visit_name","","",282],[10,"visit_ident","","",282],[10,"visit_mod","","",282],[10,"visit_view_item","","",282],[10,"visit_foreign_item","","",282],[10,"visit_item","","",282],[10,"visit_local","","",282],[10,"visit_block","","",282],[10,"visit_stmt","","",282],[10,"visit_arm","","",282],[10,"visit_pat","","",282],[10,"visit_decl","","",282],[10,"visit_expr","","",282],[10,"visit_expr_post","","",282],[10,"visit_ty","","",282],[10,"visit_generics","","",282],[10,"visit_fn","","",282],[10,"visit_ty_method","","",282],[10,"visit_trait_item","","",282],[10,"visit_trait_ref","","",282],[10,"visit_ty_param_bound","","",282],[10,"visit_poly_trait_ref","","",282],[10,"visit_struct_def","","",282],[10,"visit_struct_field","","",282],[10,"visit_variant","","",282],[10,"visit_opt_lifetime_ref","","",282],[10,"visit_lifetime_bound","","",282],[10,"visit_lifetime_ref","","",282],[10,"visit_lifetime_def","","",282],[10,"visit_explicit_self","","",282],[10,"visit_mac","","",282],[10,"visit_path","","",282],[10,"visit_path_segment","","",282],[10,"visit_path_parameters","","",282],[10,"visit_assoc_type_binding","","",282],[10,"visit_attribute","","",282],[10,"new","","",283],[10,"read_plugin_metadata","","",283],[10,"clone","rustc::metadata::cstore","",284],[10,"clone_from","","",284],[10,"eq","","",284],[10,"ne","","",284],[10,"ne","","",284],[10,"fmt","","",284],[10,"from_i64","","",285],[10,"from_u64","","",285],[10,"from_int","","",285],[10,"from_i8","","",285],[10,"from_i16","","",285],[10,"from_i32","","",285],[10,"from_uint","","",285],[10,"from_u8","","",285],[10,"from_u16","","",285],[10,"from_u32","","",285],[10,"from_f32","","",285],[10,"from_f64","","",285],[10,"eq","","",285],[10,"ne","","",285],[10,"ne","","",285],[10,"clone","","",285],[10,"clone_from","","",285],[10,"clone","","",286],[10,"clone_from","","",286],[10,"eq","","",286],[10,"ne","","",286],[10,"ne","","",286],[10,"new","","",287],[10,"next_crate_num","","",287],[10,"get_crate_data","","",287],[10,"get_crate_hash","","",287],[10,"set_crate_data","","",287],[10,"iter_crate_data","","",287],[10,"iter_crate_data_origins","","Like `iter_crate_data`, but passes source paths (if available) as well.",287],[10,"add_used_crate_source","","",287],[10,"get_used_crate_source","","",287],[10,"reset","","",287],[10,"get_used_crates","","",287],[10,"add_used_library","","",287],[10,"get_used_libraries","","",287],[10,"add_used_link_args","","",287],[10,"get_used_link_args","","",287],[10,"add_extern_mod_stmt_cnum","","",287],[10,"find_extern_mod_stmt_cnum","","",287],[10,"data","","",288],[10,"name","","",288],[10,"hash","","",288],[10,"as_slice","","",289],[10,"maybe_load_library_crate","rustc::metadata::loader","",290],[10,"load_library_crate","","",290],[10,"report_load_errs","","",290],[10,"as_slice","","",291],[10,"for_each_lib_search_path","rustc::metadata::filesearch","",292],[10,"get_lib_path","","",292],[10,"search","","",292],[10,"new","","",292],[10,"get_dylib_search_paths","","",292],[10,"get_tools_search_paths","","",292],[10,"eq","rustc::session::config","",293],[10,"ne","","",293],[10,"ne","","",293],[10,"clone","","",293],[10,"clone_from","","",293],[10,"eq","","",294],[10,"ne","","",294],[10,"ne","","",294],[10,"clone","","",294],[10,"clone_from","","",294],[10,"assert_receiver_is_total_eq","","",295],[10,"cmp","","",295],[10,"partial_cmp","","",295],[10,"lt","","",295],[10,"le","","",295],[10,"gt","","",295],[10,"ge","","",295],[10,"lt","","",295],[10,"le","","",295],[10,"gt","","",295],[10,"ge","","",295],[10,"eq","","",295],[10,"ne","","",295],[10,"ne","","",295],[10,"clone","","",295],[10,"clone_from","","",295],[10,"clone","","",296],[10,"clone_from","","",296],[10,"assert_receiver_is_total_eq","","",297],[10,"eq","","",297],[10,"ne","","",297],[10,"ne","","",297],[10,"clone","","",297],[10,"clone_from","","",297],[10,"filestem","","",298],[10,"clone","","",299],[10,"clone_from","","",299],[10,"path","","",299],[10,"temp_path","","",299],[10,"with_extension","","",299],[10,"filestem","","",299],[10,"eq","","",300],[10,"ne","","",300],[10,"ne","","",300],[10,"hash","","",301],[10,"assert_receiver_is_total_eq","","",301],[10,"cmp","","",301],[10,"clone","","",301],[10,"clone_from","","",301],[10,"partial_cmp","","",301],[10,"lt","","",301],[10,"le","","",301],[10,"gt","","",301],[10,"ge","","",301],[10,"lt","","",301],[10,"le","","",301],[10,"gt","","",301],[10,"ge","","",301],[10,"eq","","",301],[10,"ne","","",301],[10,"ne","","",301],[10,"clone","","",302],[10,"clone_from","","",302],[10,"is_empty","","",302],[10,"clone","","",303],[10,"clone_from","","",303],[10,"fmt","","",304],[10,"assert_receiver_is_total_eq","","",304],[10,"eq","","",304],[10,"ne","","",304],[10,"ne","","",304],[10,"clone","","",304],[10,"clone_from","","",304],[10,"assert_receiver_is_total_eq","","",305],[10,"eq","","",305],[10,"ne","","",305],[10,"ne","","",305],[10,"clone","","",305],[10,"clone_from","","",305],[10,"is_stable","","",305],[10,"fmt","","",301],[10,"clone","rustc::session::search_paths","",306],[10,"clone_from","","",306],[10,"clone","","",307],[10,"clone_from","","",307],[10,"eq","","",307],[10,"ne","","",307],[10,"ne","","",307],[10,"assert_receiver_is_total_eq","","",307],[10,"new","","",306],[10,"add_path","","",306],[10,"iter","","",306],[10,"next","","",308],[10,"size_hint","","",308],[10,"span_fatal","rustc::session","",309],[10,"fatal","","",309],[10,"span_err","","",309],[10,"span_err_with_code","","",309],[10,"err","","",309],[10,"err_count","","",309],[10,"has_errors","","",309],[10,"abort_if_errors","","",309],[10,"span_warn","","",309],[10,"span_warn_with_code","","",309],[10,"warn","","",309],[10,"opt_span_warn","","",309],[10,"span_note","","",309],[10,"span_end_note","","",309],[10,"span_help","","",309],[10,"fileline_note","","",309],[10,"note","","",309],[10,"help","","",309],[10,"opt_span_bug","","",309],[10,"span_bug","","",309],[10,"bug","","",309],[10,"span_unimpl","","",309],[10,"unimpl","","",309],[10,"add_lint","","",309],[10,"next_node_id","","",309],[10,"reserve_node_ids","","",309],[10,"diagnostic","","",309],[10,"debugging_opt","","",309],[10,"codemap","","",309],[10,"impossible_case","","",309],[10,"verbose","","",309],[10,"time_passes","","",309],[10,"count_llvm_insns","","",309],[10,"count_type_sizes","","",309],[10,"time_llvm_passes","","",309],[10,"trans_stats","","",309],[10,"meta_stats","","",309],[10,"asm_comments","","",309],[10,"no_verify","","",309],[10,"borrowck_stats","","",309],[10,"print_llvm_passes","","",309],[10,"lto","","",309],[10,"no_landing_pads","","",309],[10,"show_span","","",309],[10,"print_enum_sizes","","",309],[10,"sysroot","","",309],[10,"target_filesearch","","",309],[10,"host_filesearch","","",309],[10,"register_syntax_extension","rustc::plugin::registry","Register a syntax extension of any kind.",310],[10,"register_macro","","Register a macro of the usual kind.",310],[10,"register_lint_pass","","Register a compiler lint pass.",310],[10,"register_lint_group","","Register a lint group.",310],[10,"visit_view_item","rustc::plugin::load","",311],[10,"visit_mac","","",311],[10,"visit_name","","",311],[10,"visit_ident","","",311],[10,"visit_mod","","",311],[10,"visit_view_item","","",311],[10,"visit_foreign_item","","",311],[10,"visit_item","","",311],[10,"visit_local","","",311],[10,"visit_block","","",311],[10,"visit_stmt","","",311],[10,"visit_arm","","",311],[10,"visit_pat","","",311],[10,"visit_decl","","",311],[10,"visit_expr","","",311],[10,"visit_expr_post","","",311],[10,"visit_ty","","",311],[10,"visit_generics","","",311],[10,"visit_fn","","",311],[10,"visit_ty_method","","",311],[10,"visit_trait_item","","",311],[10,"visit_trait_ref","","",311],[10,"visit_ty_param_bound","","",311],[10,"visit_poly_trait_ref","","",311],[10,"visit_struct_def","","",311],[10,"visit_struct_field","","",311],[10,"visit_variant","","",311],[10,"visit_opt_lifetime_ref","","",311],[10,"visit_lifetime_bound","","",311],[10,"visit_lifetime_ref","","",311],[10,"visit_lifetime_def","","",311],[10,"visit_explicit_self","","",311],[10,"visit_mac","","",311],[10,"visit_path","","",311],[10,"visit_path_segment","","",311],[10,"visit_path_parameters","","",311],[10,"visit_assoc_type_binding","","",311],[10,"visit_attribute","","",311],[10,"visit_item","rustc::plugin::build","",312],[10,"visit_name","","",312],[10,"visit_ident","","",312],[10,"visit_mod","","",312],[10,"visit_view_item","","",312],[10,"visit_foreign_item","","",312],[10,"visit_item","","",312],[10,"visit_local","","",312],[10,"visit_block","","",312],[10,"visit_stmt","","",312],[10,"visit_arm","","",312],[10,"visit_pat","","",312],[10,"visit_decl","","",312],[10,"visit_expr","","",312],[10,"visit_expr_post","","",312],[10,"visit_ty","","",312],[10,"visit_generics","","",312],[10,"visit_fn","","",312],[10,"visit_ty_method","","",312],[10,"visit_trait_item","","",312],[10,"visit_trait_ref","","",312],[10,"visit_ty_param_bound","","",312],[10,"visit_poly_trait_ref","","",312],[10,"visit_struct_def","","",312],[10,"visit_struct_field","","",312],[10,"visit_variant","","",312],[10,"visit_opt_lifetime_ref","","",312],[10,"visit_lifetime_bound","","",312],[10,"visit_lifetime_ref","","",312],[10,"visit_lifetime_def","","",312],[10,"visit_explicit_self","","",312],[10,"visit_mac","","",312],[10,"visit_path","","",312],[10,"visit_path_segment","","",312],[10,"visit_path_parameters","","",312],[10,"visit_assoc_type_binding","","",312],[10,"visit_attribute","","",312],[10,"clone","rustc::lint","",313],[10,"clone_from","","",313],[10,"eq","","",313],[10,"ne","","",313],[10,"assert_receiver_is_total_eq","","",313],[10,"hash","","",313],[10,"of","","Get the `LintId` for a `Lint`.",313],[10,"as_str","","Get the name of the lint.",313],[10,"cmp","","",314],[10,"assert_receiver_is_total_eq","","",314],[10,"partial_cmp","","",314],[10,"lt","","",314],[10,"le","","",314],[10,"gt","","",314],[10,"ge","","",314],[10,"lt","","",314],[10,"le","","",314],[10,"gt","","",314],[10,"ge","","",314],[10,"eq","","",314],[10,"ne","","",314],[10,"ne","","",314],[10,"clone","","",314],[10,"clone_from","","",314],[10,"as_str","","Convert a level to a lower-case string.",314],[10,"from_str","","Convert a lower-case string to a level.",314],[10,"assert_receiver_is_total_eq","","",315],[10,"eq","","",315],[10,"ne","","",315],[10,"ne","","",315],[10,"clone","","",315],[10,"clone_from","","",315],[10,"get_lints","rustc::lint::builtin","",316],[10,"check_expr","","",316],[10,"check_crate","","",316],[10,"check_ident","","",316],[10,"check_mod","","",316],[10,"check_view_item","","",316],[10,"check_foreign_item","","",316],[10,"check_item","","",316],[10,"check_local","","",316],[10,"check_block","","",316],[10,"check_stmt","","",316],[10,"check_arm","","",316],[10,"check_pat","","",316],[10,"check_decl","","",316],[10,"check_expr","","",316],[10,"check_expr_post","","",316],[10,"check_ty","","",316],[10,"check_generics","","",316],[10,"check_fn","","",316],[10,"check_ty_method","","",316],[10,"check_trait_method","","",316],[10,"check_struct_def","","",316],[10,"check_struct_def_post","","",316],[10,"check_struct_field","","",316],[10,"check_variant","","",316],[10,"check_variant_post","","",316],[10,"check_opt_lifetime_ref","","",316],[10,"check_lifetime_ref","","",316],[10,"check_lifetime_def","","",316],[10,"check_explicit_self","","",316],[10,"check_mac","","",316],[10,"check_path","","",316],[10,"check_attribute","","",316],[10,"enter_lint_attrs","","",316],[10,"exit_lint_attrs","","",316],[10,"get_lints","","",317],[10,"check_expr","","",317],[10,"check_crate","","",317],[10,"check_ident","","",317],[10,"check_mod","","",317],[10,"check_view_item","","",317],[10,"check_foreign_item","","",317],[10,"check_item","","",317],[10,"check_local","","",317],[10,"check_block","","",317],[10,"check_stmt","","",317],[10,"check_arm","","",317],[10,"check_pat","","",317],[10,"check_decl","","",317],[10,"check_expr","","",317],[10,"check_expr_post","","",317],[10,"check_ty","","",317],[10,"check_generics","","",317],[10,"check_fn","","",317],[10,"check_ty_method","","",317],[10,"check_trait_method","","",317],[10,"check_struct_def","","",317],[10,"check_struct_def_post","","",317],[10,"check_struct_field","","",317],[10,"check_variant","","",317],[10,"check_variant_post","","",317],[10,"check_opt_lifetime_ref","","",317],[10,"check_lifetime_ref","","",317],[10,"check_lifetime_def","","",317],[10,"check_explicit_self","","",317],[10,"check_mac","","",317],[10,"check_path","","",317],[10,"check_attribute","","",317],[10,"enter_lint_attrs","","",317],[10,"exit_lint_attrs","","",317],[10,"new","","",318],[10,"get_lints","","",318],[10,"check_expr","","",318],[10,"check_crate","","",318],[10,"check_ident","","",318],[10,"check_mod","","",318],[10,"check_view_item","","",318],[10,"check_foreign_item","","",318],[10,"check_item","","",318],[10,"check_local","","",318],[10,"check_block","","",318],[10,"check_stmt","","",318],[10,"check_arm","","",318],[10,"check_pat","","",318],[10,"check_decl","","",318],[10,"check_expr","","",318],[10,"check_expr_post","","",318],[10,"check_ty","","",318],[10,"check_generics","","",318],[10,"check_fn","","",318],[10,"check_ty_method","","",318],[10,"check_trait_method","","",318],[10,"check_struct_def","","",318],[10,"check_struct_def_post","","",318],[10,"check_struct_field","","",318],[10,"check_variant","","",318],[10,"check_variant_post","","",318],[10,"check_opt_lifetime_ref","","",318],[10,"check_lifetime_ref","","",318],[10,"check_lifetime_def","","",318],[10,"check_explicit_self","","",318],[10,"check_mac","","",318],[10,"check_path","","",318],[10,"check_attribute","","",318],[10,"enter_lint_attrs","","",318],[10,"exit_lint_attrs","","",318],[10,"visit_ty","","",319],[10,"visit_name","","",319],[10,"visit_ident","","",319],[10,"visit_mod","","",319],[10,"visit_view_item","","",319],[10,"visit_foreign_item","","",319],[10,"visit_item","","",319],[10,"visit_local","","",319],[10,"visit_block","","",319],[10,"visit_stmt","","",319],[10,"visit_arm","","",319],[10,"visit_pat","","",319],[10,"visit_decl","","",319],[10,"visit_expr","","",319],[10,"visit_expr_post","","",319],[10,"visit_ty","","",319],[10,"visit_generics","","",319],[10,"visit_fn","","",319],[10,"visit_ty_method","","",319],[10,"visit_trait_item","","",319],[10,"visit_trait_ref","","",319],[10,"visit_ty_param_bound","","",319],[10,"visit_poly_trait_ref","","",319],[10,"visit_struct_def","","",319],[10,"visit_struct_field","","",319],[10,"visit_variant","","",319],[10,"visit_opt_lifetime_ref","","",319],[10,"visit_lifetime_bound","","",319],[10,"visit_lifetime_ref","","",319],[10,"visit_lifetime_def","","",319],[10,"visit_explicit_self","","",319],[10,"visit_mac","","",319],[10,"visit_path","","",319],[10,"visit_path_segment","","",319],[10,"visit_path_parameters","","",319],[10,"visit_assoc_type_binding","","",319],[10,"visit_attribute","","",319],[10,"get_lints","","",320],[10,"check_item","","",320],[10,"check_crate","","",320],[10,"check_ident","","",320],[10,"check_mod","","",320],[10,"check_view_item","","",320],[10,"check_foreign_item","","",320],[10,"check_item","","",320],[10,"check_local","","",320],[10,"check_block","","",320],[10,"check_stmt","","",320],[10,"check_arm","","",320],[10,"check_pat","","",320],[10,"check_decl","","",320],[10,"check_expr","","",320],[10,"check_expr_post","","",320],[10,"check_ty","","",320],[10,"check_generics","","",320],[10,"check_fn","","",320],[10,"check_ty_method","","",320],[10,"check_trait_method","","",320],[10,"check_struct_def","","",320],[10,"check_struct_def_post","","",320],[10,"check_struct_field","","",320],[10,"check_variant","","",320],[10,"check_variant_post","","",320],[10,"check_opt_lifetime_ref","","",320],[10,"check_lifetime_ref","","",320],[10,"check_lifetime_def","","",320],[10,"check_explicit_self","","",320],[10,"check_mac","","",320],[10,"check_path","","",320],[10,"check_attribute","","",320],[10,"enter_lint_attrs","","",320],[10,"exit_lint_attrs","","",320],[10,"get_lints","","",321],[10,"check_item","","",321],[10,"check_expr","","",321],[10,"check_crate","","",321],[10,"check_ident","","",321],[10,"check_mod","","",321],[10,"check_view_item","","",321],[10,"check_foreign_item","","",321],[10,"check_item","","",321],[10,"check_local","","",321],[10,"check_block","","",321],[10,"check_stmt","","",321],[10,"check_arm","","",321],[10,"check_pat","","",321],[10,"check_decl","","",321],[10,"check_expr","","",321],[10,"check_expr_post","","",321],[10,"check_ty","","",321],[10,"check_generics","","",321],[10,"check_fn","","",321],[10,"check_ty_method","","",321],[10,"check_trait_method","","",321],[10,"check_struct_def","","",321],[10,"check_struct_def_post","","",321],[10,"check_struct_field","","",321],[10,"check_variant","","",321],[10,"check_variant_post","","",321],[10,"check_opt_lifetime_ref","","",321],[10,"check_lifetime_ref","","",321],[10,"check_lifetime_def","","",321],[10,"check_explicit_self","","",321],[10,"check_mac","","",321],[10,"check_path","","",321],[10,"check_attribute","","",321],[10,"enter_lint_attrs","","",321],[10,"exit_lint_attrs","","",321],[10,"visit_ty","","",322],[10,"visit_expr","","",322],[10,"visit_block","","",322],[10,"visit_name","","",322],[10,"visit_ident","","",322],[10,"visit_mod","","",322],[10,"visit_view_item","","",322],[10,"visit_foreign_item","","",322],[10,"visit_item","","",322],[10,"visit_local","","",322],[10,"visit_block","","",322],[10,"visit_stmt","","",322],[10,"visit_arm","","",322],[10,"visit_pat","","",322],[10,"visit_decl","","",322],[10,"visit_expr","","",322],[10,"visit_expr_post","","",322],[10,"visit_ty","","",322],[10,"visit_generics","","",322],[10,"visit_fn","","",322],[10,"visit_ty_method","","",322],[10,"visit_trait_item","","",322],[10,"visit_trait_ref","","",322],[10,"visit_ty_param_bound","","",322],[10,"visit_poly_trait_ref","","",322],[10,"visit_struct_def","","",322],[10,"visit_struct_field","","",322],[10,"visit_variant","","",322],[10,"visit_opt_lifetime_ref","","",322],[10,"visit_lifetime_bound","","",322],[10,"visit_lifetime_ref","","",322],[10,"visit_lifetime_def","","",322],[10,"visit_explicit_self","","",322],[10,"visit_mac","","",322],[10,"visit_path","","",322],[10,"visit_path_segment","","",322],[10,"visit_path_parameters","","",322],[10,"visit_assoc_type_binding","","",322],[10,"visit_attribute","","",322],[10,"new","","",323],[10,"get_lints","","",323],[10,"check_item","","",323],[10,"check_crate","","",323],[10,"check_ident","","",323],[10,"check_mod","","",323],[10,"check_view_item","","",323],[10,"check_foreign_item","","",323],[10,"check_item","","",323],[10,"check_local","","",323],[10,"check_block","","",323],[10,"check_stmt","","",323],[10,"check_arm","","",323],[10,"check_pat","","",323],[10,"check_decl","","",323],[10,"check_expr","","",323],[10,"check_expr_post","","",323],[10,"check_ty","","",323],[10,"check_generics","","",323],[10,"check_fn","","",323],[10,"check_ty_method","","",323],[10,"check_trait_method","","",323],[10,"check_struct_def","","",323],[10,"check_struct_def_post","","",323],[10,"check_struct_field","","",323],[10,"check_variant","","",323],[10,"check_variant_post","","",323],[10,"check_opt_lifetime_ref","","",323],[10,"check_lifetime_ref","","",323],[10,"check_lifetime_def","","",323],[10,"check_explicit_self","","",323],[10,"check_mac","","",323],[10,"check_path","","",323],[10,"check_attribute","","",323],[10,"enter_lint_attrs","","",323],[10,"exit_lint_attrs","","",323],[10,"get_lints","","",324],[10,"check_attribute","","",324],[10,"check_crate","","",324],[10,"check_ident","","",324],[10,"check_mod","","",324],[10,"check_view_item","","",324],[10,"check_foreign_item","","",324],[10,"check_item","","",324],[10,"check_local","","",324],[10,"check_block","","",324],[10,"check_stmt","","",324],[10,"check_arm","","",324],[10,"check_pat","","",324],[10,"check_decl","","",324],[10,"check_expr","","",324],[10,"check_expr_post","","",324],[10,"check_ty","","",324],[10,"check_generics","","",324],[10,"check_fn","","",324],[10,"check_ty_method","","",324],[10,"check_trait_method","","",324],[10,"check_struct_def","","",324],[10,"check_struct_def_post","","",324],[10,"check_struct_field","","",324],[10,"check_variant","","",324],[10,"check_variant_post","","",324],[10,"check_opt_lifetime_ref","","",324],[10,"check_lifetime_ref","","",324],[10,"check_lifetime_def","","",324],[10,"check_explicit_self","","",324],[10,"check_mac","","",324],[10,"check_path","","",324],[10,"check_attribute","","",324],[10,"enter_lint_attrs","","",324],[10,"exit_lint_attrs","","",324],[10,"get_lints","","",325],[10,"check_stmt","","",325],[10,"check_crate","","",325],[10,"check_ident","","",325],[10,"check_mod","","",325],[10,"check_view_item","","",325],[10,"check_foreign_item","","",325],[10,"check_item","","",325],[10,"check_local","","",325],[10,"check_block","","",325],[10,"check_stmt","","",325],[10,"check_arm","","",325],[10,"check_pat","","",325],[10,"check_decl","","",325],[10,"check_expr","","",325],[10,"check_expr_post","","",325],[10,"check_ty","","",325],[10,"check_generics","","",325],[10,"check_fn","","",325],[10,"check_ty_method","","",325],[10,"check_trait_method","","",325],[10,"check_struct_def","","",325],[10,"check_struct_def_post","","",325],[10,"check_struct_field","","",325],[10,"check_variant","","",325],[10,"check_variant_post","","",325],[10,"check_opt_lifetime_ref","","",325],[10,"check_lifetime_ref","","",325],[10,"check_lifetime_def","","",325],[10,"check_explicit_self","","",325],[10,"check_mac","","",325],[10,"check_path","","",325],[10,"check_attribute","","",325],[10,"enter_lint_attrs","","",325],[10,"exit_lint_attrs","","",325],[10,"get_lints","","",326],[10,"check_stmt","","",326],[10,"check_crate","","",326],[10,"check_ident","","",326],[10,"check_mod","","",326],[10,"check_view_item","","",326],[10,"check_foreign_item","","",326],[10,"check_item","","",326],[10,"check_local","","",326],[10,"check_block","","",326],[10,"check_stmt","","",326],[10,"check_arm","","",326],[10,"check_pat","","",326],[10,"check_decl","","",326],[10,"check_expr","","",326],[10,"check_expr_post","","",326],[10,"check_ty","","",326],[10,"check_generics","","",326],[10,"check_fn","","",326],[10,"check_ty_method","","",326],[10,"check_trait_method","","",326],[10,"check_struct_def","","",326],[10,"check_struct_def_post","","",326],[10,"check_struct_field","","",326],[10,"check_variant","","",326],[10,"check_variant_post","","",326],[10,"check_opt_lifetime_ref","","",326],[10,"check_lifetime_ref","","",326],[10,"check_lifetime_def","","",326],[10,"check_explicit_self","","",326],[10,"check_mac","","",326],[10,"check_path","","",326],[10,"check_attribute","","",326],[10,"enter_lint_attrs","","",326],[10,"exit_lint_attrs","","",326],[10,"get_lints","","",327],[10,"check_item","","",327],[10,"check_generics","","",327],[10,"check_crate","","",327],[10,"check_ident","","",327],[10,"check_mod","","",327],[10,"check_view_item","","",327],[10,"check_foreign_item","","",327],[10,"check_item","","",327],[10,"check_local","","",327],[10,"check_block","","",327],[10,"check_stmt","","",327],[10,"check_arm","","",327],[10,"check_pat","","",327],[10,"check_decl","","",327],[10,"check_expr","","",327],[10,"check_expr_post","","",327],[10,"check_ty","","",327],[10,"check_generics","","",327],[10,"check_fn","","",327],[10,"check_ty_method","","",327],[10,"check_trait_method","","",327],[10,"check_struct_def","","",327],[10,"check_struct_def_post","","",327],[10,"check_struct_field","","",327],[10,"check_variant","","",327],[10,"check_variant_post","","",327],[10,"check_opt_lifetime_ref","","",327],[10,"check_lifetime_ref","","",327],[10,"check_lifetime_def","","",327],[10,"check_explicit_self","","",327],[10,"check_mac","","",327],[10,"check_path","","",327],[10,"check_attribute","","",327],[10,"enter_lint_attrs","","",327],[10,"exit_lint_attrs","","",327],[10,"eq","","",328],[10,"ne","","",328],[10,"ne","","",328],[10,"get_lints","","",329],[10,"check_fn","","",329],[10,"check_item","","",329],[10,"check_ty_method","","",329],[10,"check_lifetime_def","","",329],[10,"check_pat","","",329],[10,"check_struct_def","","",329],[10,"check_crate","","",329],[10,"check_ident","","",329],[10,"check_mod","","",329],[10,"check_view_item","","",329],[10,"check_foreign_item","","",329],[10,"check_item","","",329],[10,"check_local","","",329],[10,"check_block","","",329],[10,"check_stmt","","",329],[10,"check_arm","","",329],[10,"check_pat","","",329],[10,"check_decl","","",329],[10,"check_expr","","",329],[10,"check_expr_post","","",329],[10,"check_ty","","",329],[10,"check_generics","","",329],[10,"check_fn","","",329],[10,"check_ty_method","","",329],[10,"check_trait_method","","",329],[10,"check_struct_def","","",329],[10,"check_struct_def_post","","",329],[10,"check_struct_field","","",329],[10,"check_variant","","",329],[10,"check_variant_post","","",329],[10,"check_opt_lifetime_ref","","",329],[10,"check_lifetime_ref","","",329],[10,"check_lifetime_def","","",329],[10,"check_explicit_self","","",329],[10,"check_mac","","",329],[10,"check_path","","",329],[10,"check_attribute","","",329],[10,"enter_lint_attrs","","",329],[10,"exit_lint_attrs","","",329],[10,"get_lints","","",330],[10,"check_item","","",330],[10,"check_pat","","",330],[10,"check_crate","","",330],[10,"check_ident","","",330],[10,"check_mod","","",330],[10,"check_view_item","","",330],[10,"check_foreign_item","","",330],[10,"check_item","","",330],[10,"check_local","","",330],[10,"check_block","","",330],[10,"check_stmt","","",330],[10,"check_arm","","",330],[10,"check_pat","","",330],[10,"check_decl","","",330],[10,"check_expr","","",330],[10,"check_expr_post","","",330],[10,"check_ty","","",330],[10,"check_generics","","",330],[10,"check_fn","","",330],[10,"check_ty_method","","",330],[10,"check_trait_method","","",330],[10,"check_struct_def","","",330],[10,"check_struct_def_post","","",330],[10,"check_struct_field","","",330],[10,"check_variant","","",330],[10,"check_variant_post","","",330],[10,"check_opt_lifetime_ref","","",330],[10,"check_lifetime_ref","","",330],[10,"check_lifetime_def","","",330],[10,"check_explicit_self","","",330],[10,"check_mac","","",330],[10,"check_path","","",330],[10,"check_attribute","","",330],[10,"enter_lint_attrs","","",330],[10,"exit_lint_attrs","","",330],[10,"get_lints","","",331],[10,"check_expr","","",331],[10,"check_stmt","","",331],[10,"check_crate","","",331],[10,"check_ident","","",331],[10,"check_mod","","",331],[10,"check_view_item","","",331],[10,"check_foreign_item","","",331],[10,"check_item","","",331],[10,"check_local","","",331],[10,"check_block","","",331],[10,"check_stmt","","",331],[10,"check_arm","","",331],[10,"check_pat","","",331],[10,"check_decl","","",331],[10,"check_expr","","",331],[10,"check_expr_post","","",331],[10,"check_ty","","",331],[10,"check_generics","","",331],[10,"check_fn","","",331],[10,"check_ty_method","","",331],[10,"check_trait_method","","",331],[10,"check_struct_def","","",331],[10,"check_struct_def_post","","",331],[10,"check_struct_field","","",331],[10,"check_variant","","",331],[10,"check_variant_post","","",331],[10,"check_opt_lifetime_ref","","",331],[10,"check_lifetime_ref","","",331],[10,"check_lifetime_def","","",331],[10,"check_explicit_self","","",331],[10,"check_mac","","",331],[10,"check_path","","",331],[10,"check_attribute","","",331],[10,"enter_lint_attrs","","",331],[10,"exit_lint_attrs","","",331],[10,"get_lints","","",332],[10,"check_view_item","","",332],[10,"check_crate","","",332],[10,"check_ident","","",332],[10,"check_mod","","",332],[10,"check_view_item","","",332],[10,"check_foreign_item","","",332],[10,"check_item","","",332],[10,"check_local","","",332],[10,"check_block","","",332],[10,"check_stmt","","",332],[10,"check_arm","","",332],[10,"check_pat","","",332],[10,"check_decl","","",332],[10,"check_expr","","",332],[10,"check_expr_post","","",332],[10,"check_ty","","",332],[10,"check_generics","","",332],[10,"check_fn","","",332],[10,"check_ty_method","","",332],[10,"check_trait_method","","",332],[10,"check_struct_def","","",332],[10,"check_struct_def_post","","",332],[10,"check_struct_field","","",332],[10,"check_variant","","",332],[10,"check_variant_post","","",332],[10,"check_opt_lifetime_ref","","",332],[10,"check_lifetime_ref","","",332],[10,"check_lifetime_def","","",332],[10,"check_explicit_self","","",332],[10,"check_mac","","",332],[10,"check_path","","",332],[10,"check_attribute","","",332],[10,"enter_lint_attrs","","",332],[10,"exit_lint_attrs","","",332],[10,"get_lints","","",333],[10,"check_pat","","",333],[10,"check_crate","","",333],[10,"check_ident","","",333],[10,"check_mod","","",333],[10,"check_view_item","","",333],[10,"check_foreign_item","","",333],[10,"check_item","","",333],[10,"check_local","","",333],[10,"check_block","","",333],[10,"check_stmt","","",333],[10,"check_arm","","",333],[10,"check_pat","","",333],[10,"check_decl","","",333],[10,"check_expr","","",333],[10,"check_expr_post","","",333],[10,"check_ty","","",333],[10,"check_generics","","",333],[10,"check_fn","","",333],[10,"check_ty_method","","",333],[10,"check_trait_method","","",333],[10,"check_struct_def","","",333],[10,"check_struct_def_post","","",333],[10,"check_struct_field","","",333],[10,"check_variant","","",333],[10,"check_variant_post","","",333],[10,"check_opt_lifetime_ref","","",333],[10,"check_lifetime_ref","","",333],[10,"check_lifetime_def","","",333],[10,"check_explicit_self","","",333],[10,"check_mac","","",333],[10,"check_path","","",333],[10,"check_attribute","","",333],[10,"enter_lint_attrs","","",333],[10,"exit_lint_attrs","","",333],[10,"get_lints","","",334],[10,"check_expr","","",334],[10,"check_crate","","",334],[10,"check_ident","","",334],[10,"check_mod","","",334],[10,"check_view_item","","",334],[10,"check_foreign_item","","",334],[10,"check_item","","",334],[10,"check_local","","",334],[10,"check_block","","",334],[10,"check_stmt","","",334],[10,"check_arm","","",334],[10,"check_pat","","",334],[10,"check_decl","","",334],[10,"check_expr","","",334],[10,"check_expr_post","","",334],[10,"check_ty","","",334],[10,"check_generics","","",334],[10,"check_fn","","",334],[10,"check_ty_method","","",334],[10,"check_trait_method","","",334],[10,"check_struct_def","","",334],[10,"check_struct_def_post","","",334],[10,"check_struct_field","","",334],[10,"check_variant","","",334],[10,"check_variant_post","","",334],[10,"check_opt_lifetime_ref","","",334],[10,"check_lifetime_ref","","",334],[10,"check_lifetime_def","","",334],[10,"check_explicit_self","","",334],[10,"check_mac","","",334],[10,"check_path","","",334],[10,"check_attribute","","",334],[10,"enter_lint_attrs","","",334],[10,"exit_lint_attrs","","",334],[10,"get_lints","","",335],[10,"check_expr","","",335],[10,"check_crate","","",335],[10,"check_ident","","",335],[10,"check_mod","","",335],[10,"check_view_item","","",335],[10,"check_foreign_item","","",335],[10,"check_item","","",335],[10,"check_local","","",335],[10,"check_block","","",335],[10,"check_stmt","","",335],[10,"check_arm","","",335],[10,"check_pat","","",335],[10,"check_decl","","",335],[10,"check_expr","","",335],[10,"check_expr_post","","",335],[10,"check_ty","","",335],[10,"check_generics","","",335],[10,"check_fn","","",335],[10,"check_ty_method","","",335],[10,"check_trait_method","","",335],[10,"check_struct_def","","",335],[10,"check_struct_def_post","","",335],[10,"check_struct_field","","",335],[10,"check_variant","","",335],[10,"check_variant_post","","",335],[10,"check_opt_lifetime_ref","","",335],[10,"check_lifetime_ref","","",335],[10,"check_lifetime_def","","",335],[10,"check_explicit_self","","",335],[10,"check_mac","","",335],[10,"check_path","","",335],[10,"check_attribute","","",335],[10,"enter_lint_attrs","","",335],[10,"exit_lint_attrs","","",335],[10,"get_lints","","",336],[10,"check_expr","","",336],[10,"check_stmt","","",336],[10,"check_fn","","",336],[10,"check_crate","","",336],[10,"check_ident","","",336],[10,"check_mod","","",336],[10,"check_view_item","","",336],[10,"check_foreign_item","","",336],[10,"check_item","","",336],[10,"check_local","","",336],[10,"check_block","","",336],[10,"check_stmt","","",336],[10,"check_arm","","",336],[10,"check_pat","","",336],[10,"check_decl","","",336],[10,"check_expr","","",336],[10,"check_expr_post","","",336],[10,"check_ty","","",336],[10,"check_generics","","",336],[10,"check_fn","","",336],[10,"check_ty_method","","",336],[10,"check_trait_method","","",336],[10,"check_struct_def","","",336],[10,"check_struct_def_post","","",336],[10,"check_struct_field","","",336],[10,"check_variant","","",336],[10,"check_variant_post","","",336],[10,"check_opt_lifetime_ref","","",336],[10,"check_lifetime_ref","","",336],[10,"check_lifetime_def","","",336],[10,"check_explicit_self","","",336],[10,"check_mac","","",336],[10,"check_path","","",336],[10,"check_attribute","","",336],[10,"enter_lint_attrs","","",336],[10,"exit_lint_attrs","","",336],[10,"get_lints","","",337],[10,"check_expr","","",337],[10,"check_crate","","",337],[10,"check_ident","","",337],[10,"check_mod","","",337],[10,"check_view_item","","",337],[10,"check_foreign_item","","",337],[10,"check_item","","",337],[10,"check_local","","",337],[10,"check_block","","",337],[10,"check_stmt","","",337],[10,"check_arm","","",337],[10,"check_pat","","",337],[10,"check_decl","","",337],[10,"check_expr","","",337],[10,"check_expr_post","","",337],[10,"check_ty","","",337],[10,"check_generics","","",337],[10,"check_fn","","",337],[10,"check_ty_method","","",337],[10,"check_trait_method","","",337],[10,"check_struct_def","","",337],[10,"check_struct_def_post","","",337],[10,"check_struct_field","","",337],[10,"check_variant","","",337],[10,"check_variant_post","","",337],[10,"check_opt_lifetime_ref","","",337],[10,"check_lifetime_ref","","",337],[10,"check_lifetime_def","","",337],[10,"check_explicit_self","","",337],[10,"check_mac","","",337],[10,"check_path","","",337],[10,"check_attribute","","",337],[10,"enter_lint_attrs","","",337],[10,"exit_lint_attrs","","",337],[10,"new","","",338],[10,"get_lints","","",338],[10,"enter_lint_attrs","","",338],[10,"exit_lint_attrs","","",338],[10,"check_struct_def","","",338],[10,"check_struct_def_post","","",338],[10,"check_crate","","",338],[10,"check_item","","",338],[10,"check_fn","","",338],[10,"check_ty_method","","",338],[10,"check_struct_field","","",338],[10,"check_variant","","",338],[10,"check_variant_post","","",338],[10,"check_crate","","",338],[10,"check_ident","","",338],[10,"check_mod","","",338],[10,"check_view_item","","",338],[10,"check_foreign_item","","",338],[10,"check_item","","",338],[10,"check_local","","",338],[10,"check_block","","",338],[10,"check_stmt","","",338],[10,"check_arm","","",338],[10,"check_pat","","",338],[10,"check_decl","","",338],[10,"check_expr","","",338],[10,"check_expr_post","","",338],[10,"check_ty","","",338],[10,"check_generics","","",338],[10,"check_fn","","",338],[10,"check_ty_method","","",338],[10,"check_trait_method","","",338],[10,"check_struct_def","","",338],[10,"check_struct_def_post","","",338],[10,"check_struct_field","","",338],[10,"check_variant","","",338],[10,"check_variant_post","","",338],[10,"check_opt_lifetime_ref","","",338],[10,"check_lifetime_ref","","",338],[10,"check_lifetime_def","","",338],[10,"check_explicit_self","","",338],[10,"check_mac","","",338],[10,"check_path","","",338],[10,"check_attribute","","",338],[10,"enter_lint_attrs","","",338],[10,"exit_lint_attrs","","",338],[10,"get_lints","","",339],[10,"check_item","","",339],[10,"check_crate","","",339],[10,"check_ident","","",339],[10,"check_mod","","",339],[10,"check_view_item","","",339],[10,"check_foreign_item","","",339],[10,"check_item","","",339],[10,"check_local","","",339],[10,"check_block","","",339],[10,"check_stmt","","",339],[10,"check_arm","","",339],[10,"check_pat","","",339],[10,"check_decl","","",339],[10,"check_expr","","",339],[10,"check_expr_post","","",339],[10,"check_ty","","",339],[10,"check_generics","","",339],[10,"check_fn","","",339],[10,"check_ty_method","","",339],[10,"check_trait_method","","",339],[10,"check_struct_def","","",339],[10,"check_struct_def_post","","",339],[10,"check_struct_field","","",339],[10,"check_variant","","",339],[10,"check_variant_post","","",339],[10,"check_opt_lifetime_ref","","",339],[10,"check_lifetime_ref","","",339],[10,"check_lifetime_def","","",339],[10,"check_explicit_self","","",339],[10,"check_mac","","",339],[10,"check_path","","",339],[10,"check_attribute","","",339],[10,"enter_lint_attrs","","",339],[10,"exit_lint_attrs","","",339],[10,"get_lints","","",340],[10,"check_view_item","","",340],[10,"check_expr","","",340],[10,"check_item","","",340],[10,"check_crate","","",340],[10,"check_ident","","",340],[10,"check_mod","","",340],[10,"check_view_item","","",340],[10,"check_foreign_item","","",340],[10,"check_item","","",340],[10,"check_local","","",340],[10,"check_block","","",340],[10,"check_stmt","","",340],[10,"check_arm","","",340],[10,"check_pat","","",340],[10,"check_decl","","",340],[10,"check_expr","","",340],[10,"check_expr_post","","",340],[10,"check_ty","","",340],[10,"check_generics","","",340],[10,"check_fn","","",340],[10,"check_ty_method","","",340],[10,"check_trait_method","","",340],[10,"check_struct_def","","",340],[10,"check_struct_def_post","","",340],[10,"check_struct_field","","",340],[10,"check_variant","","",340],[10,"check_variant_post","","",340],[10,"check_opt_lifetime_ref","","",340],[10,"check_lifetime_ref","","",340],[10,"check_lifetime_def","","",340],[10,"check_explicit_self","","",340],[10,"check_mac","","",340],[10,"check_path","","",340],[10,"check_attribute","","",340],[10,"enter_lint_attrs","","",340],[10,"exit_lint_attrs","","",340],[10,"get_lints","","",341],[10,"check_crate","","",341],[10,"check_ident","","",341],[10,"check_mod","","",341],[10,"check_view_item","","",341],[10,"check_foreign_item","","",341],[10,"check_item","","",341],[10,"check_local","","",341],[10,"check_block","","",341],[10,"check_stmt","","",341],[10,"check_arm","","",341],[10,"check_pat","","",341],[10,"check_decl","","",341],[10,"check_expr","","",341],[10,"check_expr_post","","",341],[10,"check_ty","","",341],[10,"check_generics","","",341],[10,"check_fn","","",341],[10,"check_ty_method","","",341],[10,"check_trait_method","","",341],[10,"check_struct_def","","",341],[10,"check_struct_def_post","","",341],[10,"check_struct_field","","",341],[10,"check_variant","","",341],[10,"check_variant_post","","",341],[10,"check_opt_lifetime_ref","","",341],[10,"check_lifetime_ref","","",341],[10,"check_lifetime_def","","",341],[10,"check_explicit_self","","",341],[10,"check_mac","","",341],[10,"check_path","","",341],[10,"check_attribute","","",341],[10,"enter_lint_attrs","","",341],[10,"exit_lint_attrs","","",341],[10,"new","rustc::lint::context","",342],[10,"get_lints","","",342],[10,"get_lint_groups","","",342],[10,"register_pass","","",342],[10,"register_group","","",342],[10,"register_builtin","","",342],[10,"process_command_line","","",342],[10,"sess","","Get the overall compiler `Session` object.",343],[10,"current_level","","Get the level of `lint` at the current position of the lint\ntraversal.",343],[10,"lint","","Emit a lint at the appropriate level, with no associated span.",343],[10,"span_lint","","Emit a lint at the appropriate level, for a particular span.",343],[10,"visit_item","","",343],[10,"visit_foreign_item","","",343],[10,"visit_view_item","","",343],[10,"visit_pat","","",343],[10,"visit_expr","","",343],[10,"visit_stmt","","",343],[10,"visit_fn","","",343],[10,"visit_ty_method","","",343],[10,"visit_struct_def","","",343],[10,"visit_struct_field","","",343],[10,"visit_variant","","",343],[10,"visit_ty","","",343],[10,"visit_ident","","",343],[10,"visit_mod","","",343],[10,"visit_local","","",343],[10,"visit_block","","",343],[10,"visit_arm","","",343],[10,"visit_decl","","",343],[10,"visit_expr_post","","",343],[10,"visit_generics","","",343],[10,"visit_trait_item","","",343],[10,"visit_opt_lifetime_ref","","",343],[10,"visit_lifetime_ref","","",343],[10,"visit_lifetime_def","","",343],[10,"visit_explicit_self","","",343],[10,"visit_mac","","",343],[10,"visit_path","","",343],[10,"visit_attribute","","",343],[10,"visit_name","","",343],[10,"visit_ident","","",343],[10,"visit_mod","","",343],[10,"visit_view_item","","",343],[10,"visit_foreign_item","","",343],[10,"visit_item","","",343],[10,"visit_local","","",343],[10,"visit_block","","",343],[10,"visit_stmt","","",343],[10,"visit_arm","","",343],[10,"visit_pat","","",343],[10,"visit_decl","","",343],[10,"visit_expr","","",343],[10,"visit_expr_post","","",343],[10,"visit_ty","","",343],[10,"visit_generics","","",343],[10,"visit_fn","","",343],[10,"visit_ty_method","","",343],[10,"visit_trait_item","","",343],[10,"visit_trait_ref","","",343],[10,"visit_ty_param_bound","","",343],[10,"visit_poly_trait_ref","","",343],[10,"visit_struct_def","","",343],[10,"visit_struct_field","","",343],[10,"visit_variant","","",343],[10,"visit_opt_lifetime_ref","","",343],[10,"visit_lifetime_bound","","",343],[10,"visit_lifetime_ref","","",343],[10,"visit_lifetime_def","","",343],[10,"visit_explicit_self","","",343],[10,"visit_mac","","",343],[10,"visit_path","","",343],[10,"visit_path_segment","","",343],[10,"visit_path_parameters","","",343],[10,"visit_assoc_type_binding","","",343],[10,"visit_attribute","","",343],[10,"visit_id","","",343],[10,"get_lints","","",344],[10,"check_item","","",344],[10,"check_crate","","",344],[10,"check_ident","","",344],[10,"check_mod","","",344],[10,"check_view_item","","",344],[10,"check_foreign_item","","",344],[10,"check_item","","",344],[10,"check_local","","",344],[10,"check_block","","",344],[10,"check_stmt","","",344],[10,"check_arm","","",344],[10,"check_pat","","",344],[10,"check_decl","","",344],[10,"check_expr","","",344],[10,"check_expr_post","","",344],[10,"check_ty","","",344],[10,"check_generics","","",344],[10,"check_fn","","",344],[10,"check_ty_method","","",344],[10,"check_trait_method","","",344],[10,"check_struct_def","","",344],[10,"check_struct_def_post","","",344],[10,"check_struct_field","","",344],[10,"check_variant","","",344],[10,"check_variant_post","","",344],[10,"check_opt_lifetime_ref","","",344],[10,"check_lifetime_ref","","",344],[10,"check_lifetime_def","","",344],[10,"check_explicit_self","","",344],[10,"check_mac","","",344],[10,"check_path","","",344],[10,"check_attribute","","",344],[10,"enter_lint_attrs","","",344],[10,"exit_lint_attrs","","",344],[10,"fmt","rustc::util::common","",345],[10,"clone","","",345],[10,"clone_from","","",345],[10,"drop","","",346],[10,"visit_expr","","",347],[10,"visit_name","","",347],[10,"visit_ident","","",347],[10,"visit_mod","","",347],[10,"visit_view_item","","",347],[10,"visit_foreign_item","","",347],[10,"visit_item","","",347],[10,"visit_local","","",347],[10,"visit_block","","",347],[10,"visit_stmt","","",347],[10,"visit_arm","","",347],[10,"visit_pat","","",347],[10,"visit_decl","","",347],[10,"visit_expr","","",347],[10,"visit_expr_post","","",347],[10,"visit_ty","","",347],[10,"visit_generics","","",347],[10,"visit_fn","","",347],[10,"visit_ty_method","","",347],[10,"visit_trait_item","","",347],[10,"visit_trait_ref","","",347],[10,"visit_ty_param_bound","","",347],[10,"visit_poly_trait_ref","","",347],[10,"visit_struct_def","","",347],[10,"visit_struct_field","","",347],[10,"visit_variant","","",347],[10,"visit_opt_lifetime_ref","","",347],[10,"visit_lifetime_bound","","",347],[10,"visit_lifetime_ref","","",347],[10,"visit_lifetime_def","","",347],[10,"visit_explicit_self","","",347],[10,"visit_mac","","",347],[10,"visit_path","","",347],[10,"visit_path_segment","","",347],[10,"visit_path_parameters","","",347],[10,"visit_assoc_type_binding","","",347],[10,"visit_attribute","","",347],[10,"visit_expr","","",348],[10,"visit_name","","",348],[10,"visit_ident","","",348],[10,"visit_mod","","",348],[10,"visit_view_item","","",348],[10,"visit_foreign_item","","",348],[10,"visit_item","","",348],[10,"visit_local","","",348],[10,"visit_block","","",348],[10,"visit_stmt","","",348],[10,"visit_arm","","",348],[10,"visit_pat","","",348],[10,"visit_decl","","",348],[10,"visit_expr","","",348],[10,"visit_expr_post","","",348],[10,"visit_ty","","",348],[10,"visit_generics","","",348],[10,"visit_fn","","",348],[10,"visit_ty_method","","",348],[10,"visit_trait_item","","",348],[10,"visit_trait_ref","","",348],[10,"visit_ty_param_bound","","",348],[10,"visit_poly_trait_ref","","",348],[10,"visit_struct_def","","",348],[10,"visit_struct_field","","",348],[10,"visit_variant","","",348],[10,"visit_opt_lifetime_ref","","",348],[10,"visit_lifetime_bound","","",348],[10,"visit_lifetime_ref","","",348],[10,"visit_lifetime_def","","",348],[10,"visit_explicit_self","","",348],[10,"visit_mac","","",348],[10,"visit_path","","",348],[10,"visit_path_segment","","",348],[10,"visit_path_parameters","","",348],[10,"visit_assoc_type_binding","","",348],[10,"visit_attribute","","",348],[10,"repr","core::option","",12],[10,"repr","syntax::ptr","",349],[10,"repr","core::result","",127],[10,"repr","alloc::rc","",81],[10,"repr","alloc::boxed","",265],[10,"repr","syntax::owned_slice","",267],[10,"repr","collections::vec","",266],[10,"user_string","","",266],[10,"repr","rustc::middle::def","",15],[10,"repr","rustc::middle::ty","",245],[10,"repr","","",246],[10,"repr","","",224],[10,"repr","","",205],[10,"repr","rustc::middle::subst","",168],[10,"repr","","",171],[10,"repr","rustc::middle::ty","",256],[10,"repr","rustc::middle::subst","",169],[10,"repr","collections::enum_set","",268],[10,"repr","rustc::middle::ty","",239],[10,"repr","","",238],[10,"repr","","",82],[10,"repr","","",350],[10,"repr","syntax::ast","",351],[10,"repr","","",148],[10,"repr","","",352],[10,"user_string","","",352],[10,"repr","","",353],[10,"repr","","",354],[10,"repr","","",355],[10,"repr","syntax::codemap","",356],[10,"repr","syntax::ast","",149],[10,"repr","rustc::middle::ty","",19],[10,"repr","","",16],[10,"user_string","","",16],[10,"repr","","",17],[10,"repr","syntax::ast","",11],[10,"repr","rustc::middle::ty","",255],[10,"repr","","",247],[10,"repr","","",253],[10,"repr","","",208],[10,"repr","","",209],[10,"repr","","",203],[10,"repr","syntax::ast","",8],[10,"user_string","","",8],[10,"repr","","",7],[10,"repr","","",357],[10,"repr","","",358],[10,"repr","rustc::middle::ty","",227],[10,"repr","","",84],[10,"repr","","",229],[10,"repr","","",217],[10,"repr","","",24],[10,"repr","","",215],[10,"repr","","",216],[10,"repr","","",20],[10,"repr","","",240],[10,"user_string","","",240],[10,"repr","syntax::codemap","",13],[10,"user_string","alloc::rc","",81],[10,"user_string","rustc::middle::ty","",238],[10,"user_string","","",239],[10,"user_string","collections::enum_set","",268],[10,"user_string","rustc::middle::ty","",89],[10,"user_string","","",82],[10,"user_string","syntax::ast","",7],[10,"repr","syntax::abi","",359],[10,"user_string","","",359],[10,"repr","rustc::middle::ty","",232],[10,"repr","syntax::ast","",360],[10,"repr","rustc::middle::ty","",233],[10,"repr","","",23],[10,"repr","","",116],[10,"repr","","",118],[10,"repr","","",242],[10,"repr","","",241],[10,"repr","","",117],[10,"repr","syntax::ast","",361],[10,"repr","","",362],[10,"repr","","",119],[10,"repr","rustc::middle::ty","",264],[10,"user_string","","",230],[10,"repr","","",230],[10,"repr","","",89],[10,"repr","std::collections::hash::map","",363],[10,"repr","rustc::middle::ty","",251],[10,"user_string","","",251],[10,"repr","","",250],[10,"user_string","","",250],[10,"repr","","",249],[10,"user_string","","",249],[10,"user_string","","",83],[10,"repr","","",252],[10,"user_string","","",252],[10,"user_string","","",248],[10,"default","rustc::util::nodemap","",364],[10,"clone","","",364],[10,"clone_from","","",364],[10,"hash","","",364],[10,"write","","",365],[10,"eq","rustc::util::snapshot_vec","",366],[10,"ne","","",366],[10,"ne","","",366],[10,"new","","",367],[10,"record","","",367],[10,"push","","",367],[10,"get","","",367],[10,"get_mut","","Returns a mutable pointer into the vec; whatever changes you make here cannot be undone\nautomatically, so you should be sure call `record()` with some sort of suitable undo\naction.",367],[10,"set","","Updates the element at the given index. The old value will saved (and perhaps restored) if\na snapshot is active.",367],[10,"start_snapshot","","",367],[10,"actions_since_snapshot","","",367],[10,"rollback_to","","",367],[10,"commit","","Commits all changes since the last snapshot. Of course, they\ncan still be undone if there is a snapshot further out.",367],[10,"input","rustc_back::sha2","",368],[10,"reset","","",368],[10,"zero_until","","",368],[10,"next","","",368],[10,"full_buffer","","",368],[10,"position","","",368],[10,"remaining","","",368],[10,"size","","",368],[10,"new","","Construct a new instance of a SHA-256 digest.",369],[10,"input","","",369],[10,"result","","",369],[10,"reset","","",369],[10,"output_bits","","",369],[10,"input_str","","",369],[10,"result_bytes","","",369],[10,"result_str","","",369],[10,"open","rustc_llvm::archive_ro","Opens a static archive for read-only purposes. This is more optimized\nthan the `open` method because it uses LLVM's internal `Archive` class\nrather than shelling out to `ar` for everything.",370],[10,"read","","Reads a file in the archive",370],[10,"drop","","",370],[10,"describe","rustc_llvm::diagnostic","",371],[10,"unpack","","",372],[10,"eq","rustc_llvm","",373],[10,"ne","","",373],[10,"ne","","",373],[10,"fmt","","",374],[10,"hash","","",375],[10,"cmp","","",375],[10,"partial_cmp","","",375],[10,"lt","","",375],[10,"le","","",375],[10,"gt","","",375],[10,"ge","","",375],[10,"lt","","",375],[10,"le","","",375],[10,"gt","","",375],[10,"ge","","",375],[10,"clone","","",375],[10,"clone_from","","",375],[10,"assert_receiver_is_total_eq","","",375],[10,"eq","","",375],[10,"ne","","",375],[10,"ne","","",375],[10,"empty","","Returns an empty set of flags.",375],[10,"all","","Returns the set containing all flags.",375],[10,"bits","","Returns the raw value of the flags currently stored.",375],[10,"from_bits","","Convert from underlying bit representation, unless that\nrepresentation contains bits that do not correspond to a flag.",375],[10,"from_bits_truncate","","Convert from underlying bit representation, dropping any bits\nthat do not correspond to flags.",375],[10,"is_empty","","Returns `true` if no flags are currently stored.",375],[10,"is_all","","Returns `true` if all flags are currently set.",375],[10,"intersects","","Returns `true` if there are flags common to both `self` and `other`.",375],[10,"contains","","Returns `true` all of the flags in `other` are contained within `self`.",375],[10,"insert","","Inserts the specified flags in-place.",375],[10,"remove","","Removes the specified flags in-place.",375],[10,"toggle","","Toggles the specified flags in-place.",375],[10,"bitor","","Returns the union of the two sets of flags.",375],[10,"bitxor","","Returns the left flags, but with all the right flags toggled.",375],[10,"bitand","","Returns the intersection between the two sets of flags.",375],[10,"sub","","Returns the set difference of the two sets of flags.",375],[10,"not","","Returns the complement of this set of flags.",375],[10,"apply_llfn","","",375],[10,"apply_callsite","","",375],[10,"apply_llfn","","",376],[10,"apply_callsite","","",376],[10,"apply_llfn","","",377],[10,"apply_callsite","","",377],[10,"new","","",378],[10,"arg","","",378],[10,"ret","","",378],[10,"apply_llfn","","",378],[10,"apply_callsite","","",378],[10,"eq","","",379],[10,"ne","","",379],[10,"ne","","",379],[10,"clone","","",380],[10,"clone_from","","",380],[10,"eq","","",380],[10,"ne","","",380],[10,"ne","","",380],[10,"eq","","",381],[10,"ne","","",381],[10,"ne","","",381],[10,"drop","","",382],[10,"new","","",383],[10,"drop","","",383],[10,"drop","","",384],[1,"Lint","rustc_typeck::lint","Specification of a single lint."],[11,"name","","A string identifier for the lint.",0],[11,"default_level","","Default level for the lint.",0],[11,"desc","","Description of the lint or the issue it detects.",0],[4,"LintArray","",""],[6,"LintPass","","Trait for types providing lint checks."],[9,"get_lints","","Get descriptions of the lints this `LintPass` object can emit.",385],[9,"check_crate","","",385],[9,"check_ident","","",385],[9,"check_mod","","",385],[9,"check_view_item","","",385],[9,"check_foreign_item","","",385],[9,"check_item","","",385],[9,"check_local","","",385],[9,"check_block","","",385],[9,"check_stmt","","",385],[9,"check_arm","","",385],[9,"check_pat","","",385],[9,"check_decl","","",385],[9,"check_expr","","",385],[9,"check_expr_post","","",385],[9,"check_ty","","",385],[9,"check_generics","","",385],[9,"check_fn","","",385],[9,"check_ty_method","","",385],[9,"check_trait_method","","",385],[9,"check_struct_def","","",385],[9,"check_struct_def_post","","",385],[9,"check_struct_field","","",385],[9,"check_variant","","",385],[9,"check_variant_post","","",385],[9,"check_opt_lifetime_ref","","",385],[9,"check_lifetime_ref","","",385],[9,"check_lifetime_def","","",385],[9,"check_explicit_self","","",385],[9,"check_mac","","",385],[9,"check_path","","",385],[9,"check_attribute","","",385],[9,"enter_lint_attrs","","Called when entering a syntax node that can have lint attributes such\nas `#[allow(...)]`. Called with *all* the attributes of that node.",385],[9,"exit_lint_attrs","","Counterpart to `enter_lint_attrs`.",385],[4,"LintPassObject","",""],[1,"LintId","","Identifies a lint known to the compiler."],[2,"Level","","Setting for how to handle a lint."],[12,"Allow","","",314],[12,"Warn","","",314],[12,"Deny","","",314],[12,"Forbid","","",314],[2,"LintSource","","How a lint level was set."],[12,"Default","","Lint is at the default level as declared\nin rustc or a plugin.",315],[12,"Node","","Lint level was set by an attribute.",315],[12,"CommandLine","","Lint level was set by a command-line flag.",315],[4,"LevelSource","",""],[0,"builtin","","Lints built in to rustc."],[1,"WhileTrue","rustc_typeck::lint::builtin",""],[1,"UnusedCasts","",""],[1,"TypeLimits","",""],[1,"ImproperCTypes","",""],[1,"BoxPointers","",""],[1,"RawPointerDeriving","",""],[1,"UnusedAttributes","",""],[5,"PATH_STATEMENTS","",""],[1,"PathStatements","",""],[5,"UNUSED_MUST_USE","",""],[5,"UNUSED_RESULTS","",""],[1,"UnusedResults","",""],[5,"NON_CAMEL_CASE_TYPES","",""],[1,"NonCamelCaseTypes","",""],[5,"NON_SNAKE_CASE","",""],[1,"NonSnakeCase","",""],[5,"NON_UPPER_CASE_GLOBALS","",""],[1,"NonUpperCaseGlobals","",""],[1,"UnusedParens","",""],[1,"UnusedImportBraces","",""],[1,"NonShorthandFieldPatterns","",""],[5,"UNUSED_UNSAFE","",""],[1,"UnusedUnsafe","",""],[1,"UnsafeBlocks","",""],[5,"UNUSED_MUT","",""],[1,"UnusedMut","",""],[1,"UnusedAllocation","",""],[1,"MissingDoc","",""],[1,"MissingCopyImplementations","",""],[1,"Stability","","Checks for use of items with `#[deprecated]`, `#[experimental]` and\n`#[unstable]` attributes, or no stability attribute."],[5,"UNUSED_IMPORTS","",""],[5,"UNUSED_EXTERN_CRATES","",""],[5,"UNUSED_QUALIFICATIONS","",""],[5,"UNKNOWN_LINTS","",""],[5,"UNUSED_VARIABLES","",""],[5,"UNUSED_ASSIGNMENTS","",""],[5,"DEAD_CODE","",""],[5,"UNREACHABLE_CODE","",""],[5,"WARNINGS","",""],[5,"UNKNOWN_FEATURES","",""],[5,"UNKNOWN_CRATE_TYPES","",""],[5,"VARIANT_SIZE_DIFFERENCES","",""],[5,"FAT_PTR_TRANSMUTES","",""],[5,"MISSING_COPY_IMPLEMENTATIONS","",""],[1,"HardwiredLints","","Does nothing as a lint pass, but registers some `Lint`s\nwhich are used by other parts of the compiler."],[1,"LintStore","rustc_typeck::lint","Information about the registered lints."],[3,"check_crate","","Perform lint checking on a crate."],[3,"gather_attrs","","Parse the lint attributes into a vector, with `Err`s for malformed lint\nattributes. Writing this as an iterator is an enormous mess."],[3,"from_str","","A utility function that just calls FromStr::from_str"],[1,"Context","","Context for lint checking."],[11,"tcx","","Type context we're checking in.",343],[11,"krate","","The crate being checked.",343],[11,"exported_items","","Items exported from the crate being checked.",343],[3,"raw_emit_lint","","Emit a lint as a warning or an error (or not at all)\naccording to `level`."],[0,"metadata","rustc_typeck",""],[0,"common","rustc_typeck::metadata",""],[18,"tag_items","rustc_typeck::metadata::common",""],[18,"tag_paths_data_name","",""],[18,"tag_def_id","",""],[18,"tag_items_data","",""],[18,"tag_items_data_item","",""],[18,"tag_items_data_item_family","",""],[18,"tag_items_data_item_type","",""],[18,"tag_items_data_item_symbol","",""],[18,"tag_items_data_item_variant","",""],[18,"tag_items_data_parent_item","",""],[18,"tag_items_data_item_is_tuple_struct_ctor","",""],[18,"tag_index","",""],[18,"tag_index_buckets","",""],[18,"tag_index_buckets_bucket","",""],[18,"tag_index_buckets_bucket_elt","",""],[18,"tag_index_table","",""],[18,"tag_meta_item_name_value","",""],[18,"tag_meta_item_name","",""],[18,"tag_meta_item_value","",""],[18,"tag_attributes","",""],[18,"tag_attribute","",""],[18,"tag_meta_item_word","",""],[18,"tag_meta_item_list","",""],[18,"tag_crate_deps","",""],[18,"tag_crate_dep","",""],[18,"tag_crate_hash","",""],[18,"tag_crate_crate_name","",""],[18,"tag_crate_dep_crate_name","",""],[18,"tag_crate_dep_hash","",""],[18,"tag_mod_impl","",""],[18,"tag_item_trait_item","",""],[18,"tag_item_trait_ref","",""],[18,"tag_item_super_trait_ref","",""],[18,"tag_disr_val","",""],[18,"tag_path","",""],[18,"tag_path_len","",""],[18,"tag_path_elem_mod","",""],[18,"tag_path_elem_name","",""],[18,"tag_item_field","",""],[18,"tag_item_field_origin","",""],[18,"tag_item_variances","",""],[18,"tag_item_impl_item","",""],[18,"tag_item_trait_method_explicit_self","",""],[18,"tag_items_data_item_reexport","",""],[18,"tag_items_data_item_reexport_def_id","",""],[18,"tag_items_data_item_reexport_name","",""],[2,"astencode_tag","",""],[12,"tag_ast","","",273],[12,"tag_tree","","",273],[12,"tag_id_range","","",273],[12,"tag_table","","",273],[12,"tag_table_id","","",273],[12,"tag_table_val","","",273],[12,"tag_table_def","","",273],[12,"tag_table_node_type","","",273],[12,"tag_table_item_subst","","",273],[12,"tag_table_freevars","","",273],[12,"tag_table_tcache","","",273],[12,"tag_table_param_defs","","",273],[12,"tag_table_mutbl","","",273],[12,"tag_table_last_use","","",273],[12,"tag_table_spill","","",273],[12,"tag_table_method_map","","",273],[12,"tag_table_vtable_map","","",273],[12,"tag_table_adjustments","","",273],[12,"tag_table_moves_map","","",273],[12,"tag_table_capture_map","","",273],[12,"tag_table_unboxed_closures","","",273],[12,"tag_table_upvar_borrow_map","","",273],[12,"tag_table_capture_modes","","",273],[12,"tag_table_object_cast_map","","",273],[18,"tag_item_trait_item_sort","",""],[18,"tag_item_trait_parent_sort","",""],[18,"tag_item_impl_type_basename","",""],[18,"tag_crate_triple","",""],[18,"tag_dylib_dependency_formats","",""],[18,"tag_lang_items","",""],[18,"tag_lang_items_item","",""],[18,"tag_lang_items_item_id","",""],[18,"tag_lang_items_item_node_id","",""],[18,"tag_lang_items_missing","",""],[18,"tag_item_unnamed_field","",""],[18,"tag_items_data_item_visibility","",""],[18,"tag_item_method_tps","",""],[18,"tag_item_method_fty","",""],[18,"tag_mod_child","",""],[18,"tag_misc_info","",""],[18,"tag_misc_info_crate_items","",""],[18,"tag_item_method_provided_source","",""],[18,"tag_item_impl_vtables","",""],[18,"tag_impls","",""],[18,"tag_impls_impl","",""],[18,"tag_items_data_item_inherent_impl","",""],[18,"tag_items_data_item_extension_impl","",""],[18,"tag_native_libraries","",""],[18,"tag_native_libraries_lib","",""],[18,"tag_native_libraries_name","",""],[18,"tag_native_libraries_kind","",""],[18,"tag_plugin_registrar_fn","",""],[18,"tag_exported_macros","",""],[18,"tag_macro_def","",""],[18,"tag_method_argument_names","",""],[18,"tag_method_argument_name","",""],[18,"tag_reachable_extern_fns","",""],[18,"tag_reachable_extern_fn_id","",""],[18,"tag_items_data_item_stability","",""],[18,"tag_items_data_item_repr","",""],[1,"LinkMeta","",""],[11,"crate_name","","",274],[11,"crate_hash","","",274],[18,"tag_unboxed_closures","",""],[18,"tag_unboxed_closure","",""],[18,"tag_unboxed_closure_type","",""],[18,"tag_unboxed_closure_kind","",""],[18,"tag_struct_fields","",""],[18,"tag_struct_field","",""],[18,"tag_struct_field_id","",""],[18,"tag_attribute_is_sugared_doc","",""],[18,"tag_trait_def_bounds","",""],[18,"tag_items_data_region","",""],[18,"tag_region_param_def","",""],[18,"tag_region_param_def_ident","",""],[18,"tag_region_param_def_def_id","",""],[18,"tag_region_param_def_space","",""],[18,"tag_region_param_def_index","",""],[18,"tag_type_param_def","",""],[18,"tag_item_generics","",""],[18,"tag_method_ty_generics","",""],[18,"tag_predicate","",""],[18,"tag_predicate_space","",""],[18,"tag_predicate_data","",""],[18,"tag_unsafety","",""],[18,"tag_associated_type_names","",""],[18,"tag_associated_type_name","",""],[0,"tyencode","rustc_typeck::metadata",""],[1,"ctxt","rustc_typeck::metadata::tyencode",""],[11,"diag","","",386],[11,"ds","","",386],[11,"tcx","","",386],[11,"abbrevs","","",386],[1,"ty_abbrev","",""],[4,"abbrev_map","",""],[3,"enc_ty","",""],[3,"enc_substs","",""],[3,"enc_region","",""],[3,"enc_trait_ref","",""],[3,"enc_trait_store","",""],[3,"enc_bare_fn_ty","",""],[3,"enc_closure_ty","",""],[3,"enc_builtin_bounds","",""],[3,"enc_existential_bounds","",""],[3,"enc_bounds","",""],[3,"enc_type_param_def","",""],[3,"enc_predicate","",""],[0,"tydecode","rustc_typeck::metadata",""],[2,"DefIdSource","rustc_typeck::metadata::tydecode",""],[12,"NominalType","","",275],[12,"TypeWithId","","",275],[12,"TypeParameter","","",275],[12,"RegionParameter","","",275],[12,"UnboxedClosureSource","","",275],[4,"conv_did","",""],[1,"PState","",""],[3,"parse_ident","",""],[3,"parse_name","",""],[3,"parse_state_from_data","",""],[3,"parse_ty_closure_data","",""],[3,"parse_ty_data","",""],[3,"parse_region_data","",""],[3,"parse_bare_fn_ty_data","",""],[3,"parse_trait_ref_data","",""],[3,"parse_substs_data","",""],[3,"parse_bounds_data","",""],[3,"parse_existential_bounds_data","",""],[3,"parse_builtin_bounds_data","",""],[3,"parse_def_id","",""],[3,"parse_predicate_data","",""],[3,"parse_predicate","",""],[3,"parse_type_param_def_data","",""],[0,"encoder","rustc_typeck::metadata",""],[2,"InlinedItemRef","rustc_typeck::metadata::encoder","A borrowed version of `ast::InlinedItem`."],[12,"IIItemRef","","",387],[12,"IITraitItemRef","","",387],[12,"IIImplItemRef","","",387],[12,"IIForeignRef","","",387],[4,"Encoder","",""],[4,"EncodeInlinedItem","",""],[1,"EncodeParams","",""],[11,"diag","","",388],[11,"tcx","","",388],[11,"reexports","","",388],[11,"item_symbols","","",388],[11,"link_meta","","",388],[11,"cstore","","",388],[11,"encode_inlined_item","","",388],[11,"reachable","","",388],[1,"EncodeContext","",""],[11,"diag","","",25],[11,"tcx","","",25],[11,"reexports","","",25],[11,"item_symbols","","",25],[11,"link_meta","","",25],[11,"cstore","","",25],[11,"encode_inlined_item","","",25],[11,"type_abbrevs","","",25],[11,"reachable","","",25],[3,"encode_def_id","",""],[3,"def_to_string","",""],[3,"write_closure_type","",""],[3,"write_type","",""],[3,"write_trait_ref","",""],[3,"write_region","",""],[18,"metadata_encoding_version","",""],[3,"encode_metadata","",""],[3,"encoded_ty","",""],[0,"decoder","rustc_typeck::metadata",""],[4,"Cmd","rustc_typeck::metadata::decoder",""],[3,"maybe_find_item","",""],[3,"item_type","",""],[3,"get_trait_def","",""],[3,"get_type","",""],[3,"get_stability","",""],[3,"get_repr_attrs","",""],[3,"get_impl_trait","",""],[3,"get_impl_vtables","",""],[3,"get_symbol","",""],[2,"DefLike","",""],[12,"DlDef","","",280],[12,"DlImpl","","",280],[12,"DlField","","",280],[3,"each_lang_item","","Iterates over the language items in the given crate."],[3,"each_child_of_item","","Iterates over each child of the given item."],[3,"each_top_level_item_of_crate","","Iterates over all the top-level crate items."],[3,"get_item_path","",""],[4,"DecodeInlinedItem","",""],[3,"maybe_get_item_ast","",""],[3,"get_enum_variant_defs","",""],[3,"get_enum_variants","",""],[3,"get_impl_items","","Returns the def IDs of all the items in the given implementation."],[3,"get_trait_name","",""],[3,"get_trait_item_name_and_kind","",""],[3,"get_impl_or_trait_item","",""],[3,"get_trait_item_def_ids","",""],[3,"get_item_variances","",""],[3,"get_provided_trait_methods","",""],[3,"get_supertraits","","Returns the supertraits of the given trait."],[3,"get_type_name_if_impl","",""],[3,"get_methods_if_impl","",""],[3,"get_tuple_struct_definition_if_ctor","","If node_id is the constructor of a tuple struct, retrieve the NodeId of\nthe actual type definition, otherwise, return None"],[3,"get_item_attrs","",""],[3,"get_struct_field_attrs","",""],[3,"get_struct_fields","",""],[3,"get_crate_attributes","",""],[1,"CrateDep","",""],[11,"cnum","","",281],[11,"name","","",281],[11,"hash","","",281],[3,"get_crate_deps","",""],[3,"maybe_get_crate_hash","",""],[3,"get_crate_hash","",""],[3,"maybe_get_crate_name","",""],[3,"get_crate_triple","",""],[3,"get_crate_name","",""],[3,"list_crate_metadata","",""],[3,"translate_def_id","",""],[3,"each_impl","",""],[3,"each_implementation_for_type","",""],[3,"each_implementation_for_trait","",""],[3,"get_trait_of_item","",""],[3,"get_native_libraries","",""],[3,"get_plugin_registrar_fn","",""],[3,"get_exported_macros","",""],[3,"get_dylib_dependency_formats","",""],[3,"get_missing_lang_items","",""],[3,"get_method_arg_names","",""],[3,"get_reachable_extern_fns","",""],[3,"is_typedef","",""],[3,"is_associated_type","",""],[0,"creader","rustc_typeck::metadata","Validates all used crates and extern libraries and loads their metadata"],[3,"read_crates","rustc_typeck::metadata::creader",""],[3,"validate_crate_name","",""],[1,"PluginMetadataReader","",""],[0,"cstore","rustc_typeck::metadata",""],[4,"cnum_map","rustc_typeck::metadata::cstore",""],[2,"MetadataBlob","",""],[12,"MetadataVec","","",289],[12,"MetadataArchive","","",289],[1,"crate_metadata","",""],[11,"name","","",288],[11,"data","","",288],[11,"cnum_map","","",288],[11,"cnum","","",288],[11,"span","","",288],[2,"LinkagePreference","",""],[12,"RequireDynamic","","",284],[12,"RequireStatic","","",284],[2,"NativeLibraryKind","",""],[12,"NativeStatic","","",285],[12,"NativeFramework","","",285],[12,"NativeUnknown","","",285],[1,"CrateSource","",""],[11,"dylib","","",286],[11,"rlib","","",286],[11,"cnum","","",286],[1,"CStore","",""],[11,"intr","","",287],[0,"csearch","rustc_typeck::metadata",""],[1,"MethodInfo","rustc_typeck::metadata::csearch",""],[11,"name","","",389],[11,"def_id","","",389],[11,"vis","","",389],[3,"get_symbol","",""],[3,"each_lang_item","","Iterates over all the language items in the given crate."],[3,"each_child_of_item","","Iterates over each child of the given item."],[3,"each_top_level_item_of_crate","","Iterates over each top-level crate item."],[3,"get_item_path","",""],[2,"found_ast","",""],[12,"found","","",390],[12,"found_parent","","",390],[12,"not_found","","",390],[3,"maybe_get_item_ast","",""],[3,"get_enum_variant_defs","",""],[3,"get_enum_variants","",""],[3,"get_impl_items","","Returns information about the given implementation."],[3,"get_impl_or_trait_item","",""],[3,"get_trait_name","",""],[3,"get_trait_item_name_and_kind","",""],[3,"get_trait_item_def_ids","",""],[3,"get_item_variances","",""],[3,"get_provided_trait_methods","",""],[3,"get_supertraits","",""],[3,"get_type_name_if_impl","",""],[3,"get_methods_if_impl","",""],[3,"get_item_attrs","",""],[3,"get_struct_fields","",""],[3,"get_struct_field_attrs","",""],[3,"get_type","",""],[3,"get_trait_def","",""],[3,"get_field_type","",""],[3,"get_impl_trait","",""],[3,"get_impl_vtables","",""],[3,"get_native_libraries","",""],[3,"each_impl","",""],[3,"each_implementation_for_type","",""],[3,"each_implementation_for_trait","",""],[3,"get_trait_of_item","","If the given def ID describes an item belonging to a trait (either a\ndefault method or an implementation of a trait method), returns the ID of\nthe trait that the method belongs to. Otherwise, returns `None`."],[3,"get_tuple_struct_definition_if_ctor","",""],[3,"get_dylib_dependency_formats","",""],[3,"get_missing_lang_items","",""],[3,"get_method_arg_names","",""],[3,"get_reachable_extern_fns","",""],[3,"is_typedef","",""],[3,"get_stability","",""],[3,"get_repr_attrs","",""],[3,"is_associated_type","",""],[0,"loader","rustc_typeck::metadata","Finds crate binaries and loads their metadata"],[1,"CrateMismatch","rustc_typeck::metadata::loader",""],[1,"Context","",""],[11,"sess","","",290],[11,"span","","",290],[11,"ident","","",290],[11,"crate_name","","",290],[11,"hash","","",290],[11,"triple","","",290],[11,"filesearch","","",290],[11,"root","","",290],[11,"rejected_via_hash","","",290],[11,"rejected_via_triple","","",290],[11,"should_match_name","","",290],[1,"Library","",""],[11,"dylib","","",391],[11,"rlib","","",391],[11,"metadata","","",391],[1,"ArchiveMetadata","",""],[1,"CratePaths","",""],[11,"ident","","",392],[11,"dylib","","",392],[11,"rlib","","",392],[3,"note_crate_name","",""],[3,"meta_section_name","",""],[3,"read_meta_section_name","",""],[3,"list_file_metadata","",""],[0,"filesearch","rustc_typeck::metadata",""],[2,"FileMatch","rustc_typeck::metadata::filesearch",""],[12,"FileMatches","","",393],[12,"FileDoesntMatch","","",393],[1,"FileSearch","",""],[11,"sysroot","","",292],[11,"search_paths","","",292],[11,"triple","","",292],[11,"kind","","",292],[3,"relative_target_lib_path","",""],[3,"get_or_default_sysroot","",""],[3,"get_rust_path","","Returns RUST_PATH as a string, without default paths added"],[3,"rust_path","","Returns the value of RUST_PATH, as a list\nof Paths. Includes default entries for, if they exist:\n$HOME/.rust\nDIR/.rust for any DIR that's the current working directory\nor an ancestor of it"],[3,"rustlibdir","",""],[0,"middle","rustc_typeck",""],[0,"astconv_util","rustc_typeck::middle","This module contains a simple utility routine\nused by both `typeck` and `const_eval`.\nAlmost certainly this could (and should) be refactored out of existence."],[18,"NO_REGIONS","rustc_typeck::middle::astconv_util",""],[18,"NO_TPS","",""],[3,"check_path_args","",""],[3,"ast_ty_to_prim_ty","",""],[0,"astencode","rustc_typeck::middle",""],[4,"Encoder","rustc_typeck::middle::astencode",""],[3,"encode_inlined_item","",""],[3,"decode_inlined_item","",""],[3,"encode_unboxed_closure_kind","",""],[6,"vtable_decoder_helpers","",""],[9,"read_vec_per_param_space","","",394],[9,"read_vtable_res_with_key","","",394],[9,"read_vtable_res","","",394],[9,"read_vtable_param_res","","",394],[9,"read_vtable_origin","","",394],[0,"cfg","rustc_typeck::middle","Module that constructs a control-flow graph representing an item.\nUses `Graph` as the underlying representation."],[0,"graphviz","rustc_typeck::middle::cfg",""],[4,"Node","rustc_typeck::middle::cfg::graphviz",""],[4,"Edge","",""],[1,"LabelledCFG","",""],[11,"ast_map","","",29],[11,"cfg","","",29],[11,"name","","",29],[1,"CFG","rustc_typeck::middle::cfg",""],[11,"exit_map","","",30],[11,"graph","","",30],[11,"entry","","",30],[11,"exit","","",30],[1,"CFGNodeData","",""],[11,"id","","",395],[1,"CFGEdgeData","",""],[11,"exiting_scopes","","",396],[4,"CFGIndex","",""],[4,"CFGGraph","",""],[4,"CFGNode","",""],[4,"CFGEdge","",""],[0,"check_const","rustc_typeck::middle",""],[3,"check_crate","rustc_typeck::middle::check_const",""],[0,"check_static_recursion","rustc_typeck::middle",""],[3,"check_crate","rustc_typeck::middle::check_static_recursion",""],[3,"check_item_recursion","",""],[0,"check_loop","rustc_typeck::middle",""],[3,"check_crate","rustc_typeck::middle::check_loop",""],[0,"check_match","rustc_typeck::middle",""],[18,"DUMMY_WILD_PAT","rustc_typeck::middle::check_match",""],[1,"MatchCheckCtxt","",""],[11,"tcx","","",39],[11,"param_env","","",39],[2,"Constructor","",""],[12,"Single","","The constructor of all patterns that don't vary by constructor,\ne.g. struct patterns and fixed-length arrays.",37],[12,"Variant","","Enum variants.",37],[12,"ConstantValue","","Literal values.",37],[12,"ConstantRange","","Ranges of literal values (2..5).",37],[12,"Slice","","Array patterns of length n.",37],[12,"SliceWithSubslice","","Array patterns with a subslice.",37],[3,"check_crate","",""],[1,"StaticInliner","",""],[11,"tcx","","",40],[11,"failed","","",40],[3,"constructor_arity","","This computes the arity of a constructor. The arity of a constructor\nis how many subpattern patterns of that constructor should be expanded to."],[3,"specialize","","This is the main specialization step. It expands the first pattern in the given row\ninto `arity` patterns based on the constructor. For most patterns, the step is trivial,\nfor instance tuple patterns are flattened and box patterns expand into their inner pattern."],[0,"check_rvalues","rustc_typeck::middle",""],[3,"check_crate","rustc_typeck::middle::check_rvalues",""],[0,"check_static","rustc_typeck::middle",""],[3,"check_crate","rustc_typeck::middle::check_static",""],[0,"const_eval","rustc_typeck::middle",""],[2,"constness","rustc_typeck::middle::const_eval",""],[12,"integral_const","","",397],[12,"general_const","","",397],[12,"non_const","","",397],[3,"join","",""],[3,"join_all","",""],[3,"lookup_const_by_id","",""],[3,"process_crate","",""],[2,"const_val","",""],[12,"const_float","","",50],[12,"const_int","","",50],[12,"const_uint","","",50],[12,"const_str","","",50],[12,"const_binary","","",50],[12,"const_bool","","",50],[3,"const_expr_to_pat","",""],[3,"eval_const_expr","",""],[3,"eval_const_expr_partial","",""],[3,"lit_to_const","",""],[3,"compare_const_vals","",""],[3,"compare_lit_exprs","",""],[0,"dataflow","rustc_typeck::middle","A module for propagating forward dataflow information. The analysis\nassumes that the items to be propagated can be represented as bits\nand thus uses bitvectors. Your job is simply to specify the so-called\nGEN and KILL bits for each expression."],[2,"EntryOrExit","rustc_typeck::middle::dataflow",""],[12,"Entry","","",51],[12,"Exit","","",51],[1,"DataFlowContext","",""],[6,"BitwiseOperator","",""],[9,"join","","Joins two predecessor bits together, typically either `|` or `&`",398],[6,"DataFlowOperator","","Parameterization for the precise form of data flow that is used."],[9,"initial_value","","Specifies the initial value for each bit in the `on_entry` set",399],[0,"dead","rustc_typeck::middle",""],[3,"check_crate","rustc_typeck::middle::dead",""],[0,"def","rustc_typeck::middle",""],[2,"Def","rustc_typeck::middle::def",""],[12,"DefFn","","",15],[12,"DefStaticMethod","","",15],[12,"DefSelfTy","","",15],[12,"DefMod","","",15],[12,"DefForeignMod","","",15],[12,"DefStatic","","",15],[12,"DefConst","","",15],[12,"DefLocal","","",15],[12,"DefVariant","","",15],[12,"DefTy","","",15],[12,"DefAssociatedTy","","",15],[12,"DefAssociatedPath","","",15],[12,"DefTrait","","",15],[12,"DefPrimTy","","",15],[12,"DefTyParam","","",15],[12,"DefUse","","",15],[12,"DefUpvar","","",15],[12,"DefStruct","","Note that if it's a tuple struct's definition, the node id of the ast::DefId\nmay either refer to the item definition's id or the StructDef.ctor_id.",15],[12,"DefTyParamBinder","","",15],[12,"DefRegion","","",15],[12,"DefLabel","","",15],[12,"DefMethod","","",15],[4,"DefMap","",""],[4,"ExportMap","",""],[1,"Export","",""],[11,"name","","",400],[11,"def_id","","",400],[2,"MethodProvenance","",""],[12,"FromTrait","","",58],[12,"FromImpl","","",58],[2,"TyParamProvenance","",""],[12,"FromSelf","","",59],[12,"FromParam","","",59],[2,"TraitItemKind","",""],[12,"NonstaticMethodTraitItemKind","","",60],[12,"StaticMethodTraitItemKind","","",60],[12,"TypeTraitItemKind","","",60],[0,"dependency_format","rustc_typeck::middle","Resolution of mixing rlibs and dylibs"],[4,"DependencyList","rustc_typeck::middle::dependency_format",""],[4,"Dependencies","",""],[3,"calculate","",""],[0,"effect","rustc_typeck::middle","Enforces the Rust effect system. Currently there is just one effect,"],[3,"check_crate","rustc_typeck::middle::effect",""],[0,"entry","rustc_typeck::middle",""],[3,"find_entry_point","rustc_typeck::middle::entry",""],[0,"expr_use_visitor","rustc_typeck::middle","A different sort of visitor for walking fn bodies.  Unlike the\nnormal visitor, which just walks the entire body in one shot, the\n`ExprUseVisitor` determines how expressions are being used."],[6,"Delegate","rustc_typeck::middle::expr_use_visitor","This trait defines the callbacks you can expect to receive when\nemploying the ExprUseVisitor."],[9,"consume","","",401],[9,"matched_pat","","",401],[9,"consume_pat","","",401],[9,"borrow","","",401],[9,"decl_without_init","","",401],[9,"mutate","","",401],[2,"LoanCause","",""],[12,"ClosureCapture","","",64],[12,"AddrOf","","",64],[12,"AutoRef","","",64],[12,"RefBinding","","",64],[12,"OverloadedOperator","","",64],[12,"ClosureInvocation","","",64],[12,"ForLoop","","",64],[12,"MatchDiscriminant","","",64],[2,"ConsumeMode","",""],[12,"Copy","","",65],[12,"Move","","",65],[2,"MoveReason","",""],[12,"DirectRefMove","","",66],[12,"PatBindingMove","","",66],[12,"CaptureMove","","",66],[2,"MatchMode","",""],[12,"NonBindingMatch","","",67],[12,"BorrowingMatch","","",67],[12,"CopyingMatch","","",67],[12,"MovingMatch","","",67],[2,"MutateMode","",""],[12,"Init","","",69],[12,"JustWrite","","",69],[12,"WriteAndRead","","",69],[1,"ExprUseVisitor","",""],[0,"fast_reject","rustc_typeck::middle",""],[2,"SimplifiedType","rustc_typeck::middle::fast_reject","See `simplify_type"],[12,"BoolSimplifiedType","","",71],[12,"CharSimplifiedType","","",71],[12,"IntSimplifiedType","","",71],[12,"UintSimplifiedType","","",71],[12,"FloatSimplifiedType","","",71],[12,"EnumSimplifiedType","","",71],[12,"StrSimplifiedType","","",71],[12,"VecSimplifiedType","","",71],[12,"PtrSimplifiedType","","",71],[12,"TupleSimplifiedType","","",71],[12,"TraitSimplifiedType","","",71],[12,"StructSimplifiedType","","",71],[12,"UnboxedClosureSimplifiedType","","",71],[12,"FunctionSimplifiedType","","",71],[12,"ParameterSimplifiedType","","",71],[3,"simplify_type","","Tries to simplify a type by dropping type parameters, deref'ing away any reference types, etc.\nThe idea is to get something simple that we can use to quickly decide if two types could unify\nduring method lookup."],[0,"graph","rustc_typeck::middle","A graph module for use in dataflow, region resolution, and elsewhere."],[1,"Graph","rustc_typeck::middle::graph",""],[1,"Node","",""],[11,"data","","",402],[1,"Edge","",""],[11,"data","","",72],[1,"NodeIndex","",""],[18,"InvalidNodeIndex","",""],[1,"EdgeIndex","",""],[18,"InvalidEdgeIndex","",""],[1,"Direction","",""],[18,"Outgoing","",""],[18,"Incoming","",""],[1,"DepthFirstTraversal","",""],[3,"each_edge_index","",""],[0,"intrinsicck","rustc_typeck::middle",""],[3,"check_crate","rustc_typeck::middle::intrinsicck",""],[0,"infer","rustc_typeck::middle","See doc.rs for documentation"],[0,"coercion","rustc_typeck::middle::infer","# Type Coercion"],[1,"Coerce","rustc_typeck::middle::infer::coercion",""],[0,"combine","rustc_typeck::middle::infer",""],[6,"Combine","rustc_typeck::middle::infer::combine",""],[9,"infcx","","",403],[9,"tcx","","",403],[9,"tag","","",403],[9,"a_is_expected","","",403],[9,"trace","","",403],[9,"equate","","",403],[9,"sub","","",403],[9,"lub","","",403],[9,"glb","","",403],[9,"mts","","",403],[9,"contratys","","",403],[9,"tys","","",403],[9,"tps","","",403],[9,"substs","","",403],[9,"substs_variances","","",403],[9,"bare_fn_tys","","",403],[9,"closure_tys","","",403],[9,"fn_sigs","","",403],[9,"args","","",403],[9,"unsafeties","","",403],[9,"abi","","",403],[9,"oncenesses","","",403],[9,"projection_tys","","",403],[9,"projection_predicates","","",403],[9,"projection_bounds","","",403],[9,"existential_bounds","","",403],[9,"builtin_bounds","","",403],[9,"contraregions","","",403],[9,"regions","","",403],[9,"trait_stores","","",403],[9,"trait_refs","","",403],[9,"binders","","",403],[6,"Combineable","",""],[9,"combine","","",404],[1,"CombineFields","",""],[11,"infcx","","",85],[11,"a_is_expected","","",85],[11,"trace","","",85],[3,"expected_found","",""],[3,"super_tys","",""],[0,"doc","rustc_typeck::middle::infer","# Type inference engine"],[0,"equate","",""],[1,"Equate","rustc_typeck::middle::infer::equate",""],[3,"Equate","",""],[0,"error_reporting","rustc_typeck::middle::infer","Error Reporting Code for the inference engine"],[6,"ErrorReporting","rustc_typeck::middle::infer::error_reporting",""],[9,"report_region_errors","","",405],[9,"process_errors","","",405],[9,"report_type_error","","",405],[9,"report_and_explain_type_error","","",405],[9,"values_str","","",405],[9,"expected_found_str","","",405],[9,"report_concrete_failure","","",405],[9,"report_param_bound_failure","","",405],[9,"report_sub_sup_conflict","","",405],[9,"report_sup_sup_conflict","","",405],[9,"report_processed_errors","","",405],[9,"give_suggestion","","",405],[6,"Resolvable","",""],[9,"resolve","","",406],[9,"contains_error","","",406],[0,"glb","rustc_typeck::middle::infer",""],[1,"Glb","rustc_typeck::middle::infer::glb","\"Greatest lower bound\" (common subtype)"],[3,"Glb","",""],[0,"lattice","rustc_typeck::middle::infer","# Lattice Variables"],[6,"LatticeDir","rustc_typeck::middle::infer::lattice",""],[9,"relate_bound","","",407],[3,"super_lattice_tys","",""],[0,"lub","rustc_typeck::middle::infer",""],[1,"Lub","rustc_typeck::middle::infer::lub","\"Least upper bound\" (common supertype)"],[3,"Lub","",""],[0,"region_inference","rustc_typeck::middle::infer","See doc.rs"],[2,"Constraint","rustc_typeck::middle::infer::region_inference",""],[12,"ConstrainVarSubVar","","",94],[12,"ConstrainRegSubVar","","",94],[12,"ConstrainVarSubReg","","",94],[2,"Verify","",""],[12,"VerifyRegSubReg","","",103],[12,"VerifyParamBound","","",103],[1,"TwoRegions","",""],[2,"UndoLogEntry","",""],[12,"OpenSnapshot","","",96],[12,"CommitedSnapshot","","",96],[12,"AddVar","","",96],[12,"AddConstraint","","",96],[12,"AddVerify","","",96],[12,"AddGiven","","",96],[12,"AddCombination","","",96],[2,"CombineMapType","",""],[12,"Lub","","",97],[12,"Glb","","",97],[2,"RegionResolutionError","",""],[12,"ConcreteFailure","","`ConcreteFailure(o, a, b)`:",98],[12,"ParamBoundFailure","","`ParamBoundFailure(p, s, a, bs)",98],[12,"SubSupConflict","","`SubSupConflict(v, sub_origin, sub_r, sup_origin, sup_r)`:",98],[12,"SupSupConflict","","`SupSupConflict(v, origin1, r1, origin2, r2)`:",98],[12,"ProcessedErrors","","For subsets of `ConcreteFailure` and `SubSupConflict`, we can derive\nmore specific errors message by suggesting to the user where they\nshould put a lifetime. In those cases we process and put those errors\ninto `ProcessedErrors` before we do any reporting.",98],[1,"SameRegions","","SameRegions is used to group regions that we think are the same and would\nlike to indicate so to the user.\nFor example, the following function\n```\nstruct Foo { bar: int }\nfn foo2<'a, 'b>(x: &'a Foo) -> &'b int {\n   &x.bar\n}\n```\nwould report an error because we expect 'a and 'b to match, and so we group\n'a and 'b together inside a SameRegions struct"],[11,"scope_id","","",99],[11,"regions","","",99],[4,"CombineMap","",""],[1,"RegionVarBindings","",""],[1,"RegionSnapshot","",""],[2,"VarValue","",""],[12,"NoValue","","",104],[12,"Value","","",104],[12,"ErrorValue","","",104],[0,"resolve","rustc_typeck::middle::infer",""],[1,"OpportunisticTypeResolver","rustc_typeck::middle::infer::resolve","The opportunistic type resolver can be used at any time. It simply replaces\ntype variables that have been unified with the things they have\nbeen unified with (similar to `shallow_resolve`, but deep). This is\nuseful for printing messages etc but also required at various\npoints for correctness."],[3,"fully_resolve","","Full type resolution replaces all type and region variables with\ntheir concrete results. If any variable cannot be replaced (never unified, etc)\nthen an `Err` result is returned."],[0,"sub","rustc_typeck::middle::infer",""],[1,"Sub","rustc_typeck::middle::infer::sub","\"Greatest lower bound\" (common subtype)"],[3,"Sub","",""],[0,"type_variable","rustc_typeck::middle::infer",""],[1,"TypeVariableTable","rustc_typeck::middle::infer::type_variable",""],[1,"Snapshot","",""],[2,"RelationDir","",""],[12,"SubtypeOf","","",110],[12,"SupertypeOf","","",110],[12,"EqTo","","",110],[0,"unify","rustc_typeck::middle::infer",""],[6,"UnifyKey","rustc_typeck::middle::infer::unify","This trait is implemented by any type that can serve as a type\nvariable. We call such variables *unification keys*. For example,\nthis trait is implemented by `IntVid`, which represents integral\nvariables."],[9,"index","","",408],[9,"from_index","","",408],[9,"unification_table","","",408],[9,"tag","","",408],[6,"UnifyValue","","Trait for valid types that a type variable can be set to. Note that\nthis is typically not the end type that the value will take on, but\nrather an `Option` wrapper (where `None` represents a variable\nwhose value is not yet set)."],[2,"VarValue","","Value of a unification key. We implement Tarjan's union-find\nalgorithm: when two keys are unified, one of them is converted\ninto a \"redirect\" pointing at the other. These redirects form a\nDAG: the roots of the DAG (nodes that are not redirected) are each\nassociated with a value of type `V` and a rank. The rank is used\nto keep the DAG relatively balanced, which helps keep the running\ntime of the algorithm under control. For more information, see\n<http://en.wikipedia.org/wiki/Disjoint-set_data_structure>."],[12,"Redirect","","",113],[12,"Root","","",113],[1,"UnificationTable","","Table of unification keys and their values."],[1,"Snapshot","","At any time, users may snapshot a unification table.  The changes\nmade during the snapshot may either be *committed* or *rolled back*."],[1,"Node","","Internal type used to represent the result of a `get()` operation.\nConveys the current root and value of the key."],[11,"key","","",409],[11,"value","","",409],[11,"rank","","",409],[1,"Delegate","",""],[6,"SimplyUnifiable","","Indicates a type that does not have any kind of subtyping\nrelationship."],[9,"to_type","","",410],[9,"to_type_err","","",410],[3,"err","",""],[6,"InferCtxtMethodsForSimplyUnifiableTypes","",""],[9,"simple_vars","","",411],[9,"simple_var_t","","",411],[9,"probe_var","","",411],[4,"Bound","rustc_typeck::middle::infer",""],[4,"cres","",""],[4,"ures","",""],[4,"fres","",""],[4,"CoerceResult","",""],[1,"InferCtxt","",""],[11,"tcx","","",88],[4,"SkolemizationMap","",""],[2,"TypeOrigin","","Why did we require that the two types be related?"],[12,"Misc","","",120],[12,"MethodCompatCheck","","",120],[12,"ExprAssignable","","",120],[12,"RelateTraitRefs","","",120],[12,"RelateSelfType","","",120],[12,"RelateOutputImplTypes","","",120],[12,"MatchExpressionArm","","",120],[12,"IfExpression","","",120],[12,"IfExpressionWithNoElse","","",120],[12,"RangeExpression","","",120],[12,"EquatePredicate","","",120],[2,"ValuePairs","","See `error_reporting.rs` for more details"],[12,"Types","","",121],[12,"TraitRefs","","",121],[12,"PolyTraitRefs","","",121],[1,"TypeTrace","","The trace designates the path through inference that we took to\nencounter an error or subtyping constraint."],[2,"SubregionOrigin","","The origin of a `r1 <= r2` constraint."],[12,"Subtype","","",123],[12,"InfStackClosure","","",123],[12,"InvokeClosure","","",123],[12,"DerefPointer","","",123],[12,"FreeVariable","","",123],[12,"IndexSlice","","",123],[12,"RelateObjectBound","","",123],[12,"RelateParamBound","","",123],[12,"RelateRegionParamBound","","",123],[12,"RelateDefaultParamBound","","",123],[12,"Reborrow","","",123],[12,"ReborrowUpvar","","",123],[12,"ReferenceOutlivesReferent","","",123],[12,"ExprTypeIsNotInScope","","",123],[12,"BindingTypeIsNotValidAtDecl","","",123],[12,"CallRcvr","","",123],[12,"CallArg","","",123],[12,"CallReturn","","",123],[12,"AddrOf","","",123],[12,"AutoBorrow","","",123],[2,"LateBoundRegionConversionTime","","Times when we replace late-bound regions with variables:"],[12,"FnCall","","when a fn is called",124],[12,"HigherRankedType","","when two higher-ranked types are compared",124],[12,"AssocTypeProjection","","when projecting an associated type",124],[2,"RegionVariableOrigin","","Reasons to create a region inference variable"],[12,"MiscVariable","","",125],[12,"PatternRegion","","",125],[12,"AddrOfRegion","","",125],[12,"AddrOfSlice","","",125],[12,"Autoref","","",125],[12,"Coercion","","",125],[12,"EarlyBoundRegion","","",125],[12,"LateBoundRegion","","",125],[12,"UpvarRegion","","",125],[12,"BoundRegionInCoherence","","",125],[2,"fixup_err","",""],[12,"unresolved_int_ty","","",126],[12,"unresolved_float_ty","","",126],[12,"unresolved_ty","","",126],[3,"fixup_err_to_string","",""],[3,"new_infer_ctxt","",""],[3,"common_supertype","","Computes the least upper-bound of `a` and `b`. If this is not possible, reports an error and\nreturns ty::err."],[3,"mk_subty","",""],[3,"can_mk_subty","",""],[3,"can_mk_eqty","",""],[3,"mk_subr","",""],[3,"verify_param_bound","",""],[3,"mk_eqty","",""],[3,"mk_sub_poly_trait_refs","",""],[3,"mk_coercety","",""],[3,"uok","",""],[1,"CombinedSnapshot","",""],[1,"TypeFreshener","",""],[2,"IntVarValue","",""],[12,"IntType","","",117],[12,"UintType","","",117],[0,"lang_items","rustc_typeck::middle",""],[2,"LangItem","rustc_typeck::middle::lang_items",""],[12,"SendTraitLangItem","","",128],[12,"SizedTraitLangItem","","",128],[12,"CopyTraitLangItem","","",128],[12,"SyncTraitLangItem","","",128],[12,"DropTraitLangItem","","",128],[12,"AddTraitLangItem","","",128],[12,"SubTraitLangItem","","",128],[12,"MulTraitLangItem","","",128],[12,"DivTraitLangItem","","",128],[12,"RemTraitLangItem","","",128],[12,"NegTraitLangItem","","",128],[12,"NotTraitLangItem","","",128],[12,"BitXorTraitLangItem","","",128],[12,"BitAndTraitLangItem","","",128],[12,"BitOrTraitLangItem","","",128],[12,"ShlTraitLangItem","","",128],[12,"ShrTraitLangItem","","",128],[12,"IndexTraitLangItem","","",128],[12,"IndexMutTraitLangItem","","",128],[12,"SliceTraitLangItem","","",128],[12,"SliceMutTraitLangItem","","",128],[12,"RangeStructLangItem","","",128],[12,"RangeFromStructLangItem","","",128],[12,"RangeToStructLangItem","","",128],[12,"FullRangeStructLangItem","","",128],[12,"UnsafeTypeLangItem","","",128],[12,"DerefTraitLangItem","","",128],[12,"DerefMutTraitLangItem","","",128],[12,"FnTraitLangItem","","",128],[12,"FnMutTraitLangItem","","",128],[12,"FnOnceTraitLangItem","","",128],[12,"EqTraitLangItem","","",128],[12,"OrdTraitLangItem","","",128],[12,"StrEqFnLangItem","","",128],[12,"PanicFnLangItem","","",128],[12,"PanicBoundsCheckFnLangItem","","",128],[12,"PanicFmtLangItem","","",128],[12,"ExchangeMallocFnLangItem","","",128],[12,"ExchangeFreeFnLangItem","","",128],[12,"StrDupUniqFnLangItem","","",128],[12,"StartFnLangItem","","",128],[12,"TyDescStructLangItem","","",128],[12,"OpaqueStructLangItem","","",128],[12,"TypeIdLangItem","","",128],[12,"EhPersonalityLangItem","","",128],[12,"ExchangeHeapLangItem","","",128],[12,"OwnedBoxLangItem","","",128],[12,"CovariantTypeItem","","",128],[12,"ContravariantTypeItem","","",128],[12,"InvariantTypeItem","","",128],[12,"CovariantLifetimeItem","","",128],[12,"ContravariantLifetimeItem","","",128],[12,"InvariantLifetimeItem","","",128],[12,"NoSendItem","","",128],[12,"NoCopyItem","","",128],[12,"NoSyncItem","","",128],[12,"ManagedItem","","",128],[12,"NonZeroItem","","",128],[12,"IteratorItem","","",128],[12,"StackExhaustedLangItem","","",128],[1,"LanguageItems","",""],[11,"items","","",129],[11,"missing","","",129],[3,"extract","",""],[3,"collect_language_items","",""],[0,"liveness","rustc_typeck::middle","A classic liveness analysis based on dataflow over the AST.  Computes,\nfor each local variable in a function, whether that variable is live\nat a given point.  Program execution points are identified by their\nid."],[3,"check_crate","rustc_typeck::middle::liveness",""],[0,"mem_categorization","rustc_typeck::middle","# Categorization"],[2,"categorization","rustc_typeck::middle::mem_categorization",""],[12,"cat_rvalue","","",139],[12,"cat_static_item","","",139],[12,"cat_upvar","","",139],[12,"cat_local","","",139],[12,"cat_deref","","",139],[12,"cat_interior","","",139],[12,"cat_downcast","","",139],[1,"Upvar","",""],[11,"id","","",140],[11,"kind","","",140],[11,"is_unboxed","","",140],[2,"PointerKind","",""],[12,"Unique","","",141],[12,"BorrowedPtr","","",141],[12,"Implicit","","",141],[12,"UnsafePtr","","",141],[2,"InteriorKind","",""],[12,"InteriorField","","",142],[12,"InteriorElement","","",142],[2,"FieldName","",""],[12,"NamedField","","",143],[12,"PositionalField","","",143],[2,"ElementKind","",""],[12,"VecElement","","",144],[12,"OtherElement","","",144],[2,"MutabilityCategory","",""],[12,"McImmutable","","",145],[12,"McDeclared","","",145],[12,"McInherited","","",145],[2,"Note","",""],[12,"NoteClosureEnv","","",146],[12,"NoteUpvarRef","","",146],[12,"NoteNone","","",146],[1,"cmt_","",""],[11,"id","","",147],[11,"span","","",147],[11,"cat","","",147],[11,"mutbl","","",147],[11,"ty","","",147],[11,"note","","",147],[4,"cmt","",""],[2,"deref_kind","",""],[12,"deref_ptr","","",412],[12,"deref_interior","","",412],[3,"opt_deref_kind","",""],[3,"deref_kind","",""],[6,"ast_node","",""],[9,"id","","",413],[9,"span","","",413],[1,"MemCategorizationContext","",""],[6,"Typer","","The `Typer` trait provides the interface for the mem-categorization\nmodule to the results of the type check. It can be used to query\nthe type assigned to an expression node, to inquire after adjustments,\nand so on."],[9,"tcx","","",414],[9,"node_ty","","",414],[9,"expr_ty_adjusted","","",414],[9,"node_method_ty","","",414],[9,"node_method_origin","","",414],[9,"adjustments","","",414],[9,"is_method_call","","",414],[9,"temporary_scope","","",414],[9,"upvar_borrow","","",414],[9,"capture_mode","","",414],[9,"unboxed_closures","","",414],[2,"InteriorSafety","",""],[12,"InteriorUnsafe","","",415],[12,"InteriorSafe","","",415],[2,"AliasableReason","",""],[12,"AliasableBorrowed","","",416],[12,"AliasableClosure","","",416],[12,"AliasableOther","","",416],[12,"AliasableStatic","","",416],[12,"AliasableStaticMut","","",416],[3,"ptr_sigil","",""],[0,"pat_util","rustc_typeck::middle",""],[4,"PatIdMap","rustc_typeck::middle::pat_util",""],[3,"pat_id_map","",""],[3,"pat_is_refutable","",""],[3,"pat_is_variant_or_struct","",""],[3,"pat_is_const","",""],[3,"pat_is_binding","",""],[3,"pat_is_binding_or_wild","",""],[3,"pat_bindings","","Call `it` on every \"binding\" in a pattern, e.g., on `a` in\n`match foo() { Some(a) => (), None => () }`"],[3,"pat_contains_bindings","","Checks if the pattern contains any patterns that bind something to\nan ident, e.g. `foo`, or `Foo(foo)` or `foo @ Bar(..)`."],[3,"simple_identifier","",""],[3,"def_to_path","",""],[0,"privacy","rustc_typeck::middle","A pass that checks to make sure private fields and methods aren't used\noutside their scopes. This pass will also generate a set of exported items\nwhich are available for use externally when compiled as a library."],[4,"ExportedItems","rustc_typeck::middle::privacy",""],[4,"ExternalExports","",""],[4,"PublicItems","",""],[4,"LastPrivateMap","",""],[2,"LastPrivate","",""],[12,"LastMod","","",151],[12,"LastImport","","",151],[11,"value_priv","rustc_typeck::middle::privacy::LastPrivate","",151],[11,"value_used","","",151],[11,"type_priv","","",151],[11,"type_used","","",151],[2,"PrivateDep","rustc_typeck::middle::privacy",""],[12,"AllPublic","","",152],[12,"DependsOn","","",152],[2,"ImportUse","",""],[12,"Unused","","",153],[12,"Used","","",153],[3,"check_crate","",""],[0,"reachable","rustc_typeck::middle",""],[3,"find_reachable","rustc_typeck::middle::reachable",""],[0,"region","rustc_typeck::middle","This file actually contains two passes related to regions.  The first\npass builds up the `scope_map`, which describes the parent links in\nthe region hierarchy.  The second pass infers which types must be\nregion parameterized."],[2,"CodeExtent","rustc_typeck::middle::region","CodeExtent represents a statically-describable extent that can be\nused to bound the lifetime/region for values."],[12,"Misc","","",18],[1,"RegionMaps","","The region maps encode information about region relationships."],[1,"Context","",""],[3,"resolve_crate","",""],[3,"resolve_inlined_item","",""],[0,"recursion_limit","rustc_typeck::middle",""],[3,"update_recursion_limit","rustc_typeck::middle::recursion_limit",""],[0,"resolve_lifetime","rustc_typeck::middle","Name resolution for lifetimes."],[2,"DefRegion","rustc_typeck::middle::resolve_lifetime",""],[12,"DefStaticRegion","","",163],[12,"DefEarlyBoundRegion","","",163],[12,"DefLateBoundRegion","","",163],[12,"DefFreeRegion","","",163],[4,"NamedRegionMap","",""],[3,"krate","",""],[3,"early_bound_lifetimes","",""],[0,"stability","rustc_typeck::middle","A pass that annotates every item and method with its stability level,\npropagating default levels lexically from parent to children ast nodes."],[1,"Index","rustc_typeck::middle::stability","A stability index, giving the stability level for items and methods."],[3,"lookup","","Lookup the stability for a node, loading external crate\nmetadata as necessary."],[0,"subst","rustc_typeck::middle",""],[1,"Substs","rustc_typeck::middle::subst","A substitution mapping type/region parameters to new values. We\nidentify each in-scope parameter by an *index* and a *parameter\nspace* (which indices where the parameter is defined; see\n`ParamSpace`)."],[11,"types","","",168],[11,"regions","","",168],[2,"RegionSubsts","","Represents the values to use when substituting lifetime parameters.\nIf the value is `ErasedRegions`, then this subst is occurring during\ntrans, and all region parameters will be replaced with `ty::ReStatic`."],[12,"ErasedRegions","","",169],[12,"NonerasedRegions","","",169],[2,"ParamSpace","",""],[12,"TypeSpace","","",170],[12,"SelfSpace","","",170],[12,"FnSpace","","",170],[1,"VecPerParamSpace","","Vector of things sorted by param space. Used to keep\nthe set of things declared on the type, self, or method\ndistinct."],[1,"SeparateVecsPerParamSpace","","The `split` function converts one `VecPerParamSpace` into this\n`SeparateVecsPerParamSpace` structure."],[11,"types","","",417],[11,"selfs","","",417],[11,"fns","","",417],[1,"EnumeratedItems","",""],[6,"Subst","",""],[9,"subst","","",418],[9,"subst_spanned","","",418],[0,"traits","rustc_typeck::middle","Trait Resolution. See doc.rs."],[1,"Obligation","rustc_typeck::middle::traits","An `Obligation` represents some trait reference (e.g. `int:Eq`) for\nwhich the vtable must be found.  The process of finding a vtable is\ncalled \"resolving\" the `Obligation`. This process consists of\neither identifying an `impl` (e.g., `impl Eq for int`) that\nprovides the required vtable, or else finding a bound that is in\nscope. The eventual result is usually a `Selection` (defined below)."],[11,"cause","","",190],[11,"recursion_depth","","",190],[11,"predicate","","",190],[4,"PredicateObligation","",""],[4,"TraitObligation","",""],[1,"ObligationCause","","Why did we incur this obligation? Used for error reporting."],[11,"span","","",196],[11,"body_id","","",196],[11,"code","","",196],[2,"ObligationCauseCode","",""],[12,"MiscObligation","","Not well classified or should be obvious from span.",197],[12,"ItemObligation","","In an impl of trait X for type Y, type Y must\nalso implement all supertraits of X.",197],[12,"ObjectCastObligation","","Obligation incurred due to an object cast.",197],[12,"AssignmentLhsSized","","Various cases where expressions must be sized/copy/etc:",197],[12,"StructInitializerSized","","",197],[12,"VariableType","","",197],[12,"ReturnType","","",197],[12,"RepeatVec","","",197],[12,"ClosureCapture","","",197],[12,"FieldSized","","",197],[12,"ObjectSized","","",197],[12,"SharedStatic","","",197],[12,"BuiltinDerivedObligation","","",197],[12,"ImplDerivedObligation","","",197],[1,"DerivedObligationCause","",""],[4,"Obligations","",""],[4,"PredicateObligations","",""],[4,"TraitObligations","",""],[4,"Selection","",""],[2,"SelectionError","",""],[12,"Unimplemented","","",193],[12,"Overflow","","",193],[12,"OutputTypeParameterMismatch","","",193],[1,"FulfillmentError","",""],[11,"obligation","","",194],[11,"code","","",194],[2,"FulfillmentErrorCode","",""],[12,"CodeSelectionError","","",195],[12,"CodeProjectionError","","",195],[12,"CodeAmbiguity","","",195],[4,"SelectionResult","",""],[2,"Vtable","","Given the successful resolution of an obligation, the `Vtable`\nindicates where the vtable comes from. Note that while we call this\na \"vtable\", it does not necessarily indicate dynamic dispatch at\nruntime. `Vtable` instances just tell the compiler where to find\nmethods, but in generic code those methods are typically statically\ndispatched -- only when an object is constructed is a `Vtable`\ninstance reified into an actual vtable."],[12,"VtableImpl","","Vtable identifying a particular impl.",191],[12,"VtableParam","","Successful resolution to an obligation provided by the caller\nfor some type parameter.",191],[12,"VtableBuiltin","","Successful resolution for a builtin trait.",191],[12,"VtableUnboxedClosure","","Vtable automatically generated for an unboxed closure. The def\nID is the ID of the closure expression. This is a `VtableImpl`\nin spirit, but the impl is generated by the compiler and does\nnot appear in the source.",191],[12,"VtableFnPointer","","Same as above, but for a fn pointer type with the given signature.",191],[1,"VtableImplData","","Identifies a particular impl in the source, along with a set of\nsubstitutions from the impl's type/lifetime parameters. The\n`nested` vector corresponds to the nested obligations attached to\nthe impl's type parameters."],[11,"impl_def_id","","",189],[11,"substs","","",189],[11,"nested","","",189],[1,"VtableBuiltinData","",""],[11,"nested","","",192],[3,"is_orphan_impl","","True if neither the trait nor self type is local. Note that `impl_def_id` must refer to an impl\nof a trait, not an inherent impl."],[3,"overlapping_impls","","True if there exist types that satisfy both of the two given impls."],[3,"predicates_for_generics","","Creates predicate obligations from the generic bounds."],[3,"type_known_to_meet_builtin_bound","","Determines whether the type `ty` is known to meet `bound` and\nreturns true if so. Returns false if `ty` either does not meet\n`bound` or is not known to meet bound (note that this is\nconservative towards *no impl*, which is the opposite of the\n`evaluate` methods)."],[3,"trait_ref_for_builtin_bound","",""],[1,"Normalized","",""],[11,"value","","",419],[11,"obligations","","",419],[1,"MismatchedProjectionTypes","",""],[11,"err","","",176],[3,"normalize","",""],[3,"supertraits","",""],[3,"report_fulfillment_errors","",""],[2,"MethodMatchedData","",""],[12,"PreciseMethodMatch","","",181],[12,"CoerciveMethodMatch","","",181],[2,"MethodMatchResult","",""],[12,"MethodMatched","","",186],[12,"MethodAmbiguous","","",186],[12,"MethodDidNotMatch","","",186],[3,"transitive_bounds","",""],[1,"RegionObligation","",""],[11,"sub_region","","",175],[11,"sup_type","","",175],[11,"cause","","",175],[1,"SelectionContext","",""],[1,"Supertraits","","A filter around the `Elaborator` that just yields up supertrait references,\nnot other kinds of predicates."],[3,"elaborate_predicates","",""],[1,"SelectionCache","",""],[1,"FulfillmentContext","","The fulfillment context is used to drive trait resolution.  It\nconsists of a list of obligations that must be (eventually)\nsatisfied. The job is to track which are satisfied, which yielded\nerrors, and which are still pending. At any point, users can call\n`select_where_possible`, and the fulfilment context will try to do\nselection, retaining only those obligations that remain\nambiguous. This may be helpful in pushing type inference\nalong. Once all type inference constraints have been generated, the\nmethod `select_all_or_error` can be used to report any remaining\nambiguous cases as errors."],[0,"ty","rustc_typeck::middle",""],[4,"Disr","rustc_typeck::middle::ty",""],[18,"INITIAL_DISCRIMINANT_VALUE","",""],[1,"CrateAnalysis","","The complete set of all analyses described in this module. This is\nproduced by the driver and fed to trans and later passes."],[11,"export_map","","",420],[11,"exported_items","","",420],[11,"public_items","","",420],[11,"ty_cx","","",420],[11,"reachable","","",420],[11,"name","","",420],[11,"glob_map","","",420],[1,"field","",""],[11,"name","","",199],[11,"mt","","",199],[2,"ImplOrTraitItemContainer","",""],[12,"TraitContainer","","",200],[12,"ImplContainer","","",200],[2,"ImplOrTraitItem","",""],[12,"MethodTraitItem","","",201],[12,"TypeTraitItem","","",201],[2,"ImplOrTraitItemId","",""],[12,"MethodTraitItemId","","",202],[12,"TypeTraitItemId","","",202],[1,"Method","",""],[11,"name","","",203],[11,"generics","","",203],[11,"fty","","",203],[11,"explicit_self","","",203],[11,"vis","","",203],[11,"def_id","","",203],[11,"container","","",203],[11,"provided_source","","",203],[1,"AssociatedType","",""],[11,"name","","",204],[11,"vis","","",204],[11,"def_id","","",204],[11,"container","","",204],[1,"mt","",""],[11,"ty","","",205],[11,"mutbl","","",205],[2,"TraitStore","",""],[12,"UniqTraitStore","","Box<Trait>",20],[12,"RegionTraitStore","","&Trait and &mut Trait",20],[1,"field_ty","",""],[11,"name","","",206],[11,"id","","",206],[11,"vis","","",206],[11,"origin","","",206],[1,"creader_cache_key","",""],[11,"cnum","","",207],[11,"pos","","",207],[11,"len","","",207],[2,"ast_ty_to_ty_cache_entry","",""],[12,"atttce_unresolved","","",421],[12,"atttce_resolved","","",421],[1,"ItemVariances","",""],[11,"types","","",208],[11,"regions","","",208],[2,"Variance","",""],[12,"Covariant","","",209],[12,"Invariant","","",209],[12,"Contravariant","","",209],[12,"Bivariant","","",209],[2,"AutoAdjustment","",""],[12,"AdjustAddEnv","","",210],[12,"AdjustReifyFnPointer","","",210],[12,"AdjustDerefRef","","",210],[2,"UnsizeKind","",""],[12,"UnsizeLength","","",211],[12,"UnsizeStruct","","",211],[12,"UnsizeVtable","","",211],[1,"AutoDerefRef","",""],[11,"autoderefs","","",212],[11,"autoref","","",212],[2,"AutoRef","",""],[12,"AutoPtr","","Convert from T to &T\nThe third field allows us to wrap other AutoRef adjustments.",213],[12,"AutoUnsize","","Convert [T, ..n] to [T] (or similar, depending on the kind)",213],[12,"AutoUnsizeUniq","","Convert Box<[T, ..n]> to Box<[T]> or something similar in a Box.\nWith DST and Box a library type, this should be replaced by UnsizeStruct.",213],[12,"AutoUnsafe","","Convert from T to *T\nValue to thin pointer\nThe second field allows us to wrap other AutoRef adjustments.",213],[3,"adjusted_object_region","",""],[3,"adjust_is_object","",""],[3,"type_of_adjust","",""],[1,"param_index","",""],[11,"space","","",214],[11,"index","","",214],[2,"MethodOrigin","",""],[12,"MethodStatic","","",24],[12,"MethodStaticUnboxedClosure","","",24],[12,"MethodTypeParam","","",24],[12,"MethodTraitObject","","",24],[1,"MethodParam","",""],[11,"trait_ref","","",215],[11,"method_num","","",215],[1,"MethodObject","",""],[11,"trait_ref","","",216],[11,"object_trait_id","","",216],[11,"method_num","","",216],[11,"real_index","","",216],[1,"MethodCallee","",""],[11,"origin","","",217],[11,"ty","","",217],[11,"substs","","",217],[1,"MethodCall","","With method calls, we store some extra information in\nside tables (i.e method_map). We use\nMethodCall as a key to index into these tables instead of\njust directly using the expression's NodeId. The reason\nfor this being that we may apply adjustments (coercions)\nwith the resulting expression also needing to use the\nside tables. The problem with this is that we don't\nassign a separate NodeId to this new expression\nand so it would clash with the base expression if both\nneeded to add to the side tables. Thus to disambiguate\nwe also keep track of whether there's an adjustment in\nour key."],[11,"expr_id","","",218],[11,"adjustment","","",218],[2,"ExprAdjustment","",""],[12,"NoAdjustment","","",219],[12,"AutoDeref","","",219],[12,"AutoObject","","",219],[4,"MethodMap","",""],[4,"vtable_param_res","",""],[4,"vtable_res","",""],[2,"vtable_origin","",""],[12,"vtable_static","","",220],[12,"vtable_param","","",220],[12,"vtable_unboxed_closure","","",220],[12,"vtable_error","","",220],[4,"ObjectCastMap","",""],[1,"TransmuteRestriction","","A restriction that certain types must be the same size. The use of\n`transmute` gives rise to these restrictions. These generally\ncannot be checked until trans; therefore, each call to `transmute`\nwill push one or more such restriction into the\n`transmute_restrictions` vector during `intrinsicck`. They are\nthen checked during `trans` by the fn `check_intrinsics`."],[11,"span","","The span whence the restriction comes.",79],[11,"original_from","","The type being transmuted from.",79],[11,"original_to","","The type being transmuted to.",79],[11,"substituted_from","","The type being transmuted from, with all type parameters\nsubstituted for an arbitrary representative. Not to be shown\nto the end user.",79],[11,"substituted_to","","The type being transmuted to, with all type parameters\nsubstituted for an arbitrary representative. Not to be shown\nto the end user.",79],[11,"id","","NodeId of the transmute intrinsic.",79],[1,"CtxtArenas","","Internal storage"],[1,"CommonTypes","",""],[11,"bool","","",422],[11,"char","","",422],[11,"int","","",422],[11,"i8","","",422],[11,"i16","","",422],[11,"i32","","",422],[11,"i64","","",422],[11,"uint","","",422],[11,"u8","","",422],[11,"u16","","",422],[11,"u32","","",422],[11,"u64","","",422],[11,"f32","","",422],[11,"f64","","",422],[11,"err","","",422],[1,"ctxt","","The data structure to keep track of all the information that typechecker\ngenerates so that so that it can be reused and doesn't have to be redone\nlater on."],[11,"types","","Common types, pre-interned for your convenience.",223],[11,"sess","","",223],[11,"def_map","","",223],[11,"named_region_map","","",223],[11,"region_maps","","",223],[11,"node_types","","Stores the types for various nodes in the AST.  Note that this table\nis not guaranteed to be populated until after typeck.  See\ntypeck::check::fn_ctxt for details.",223],[11,"item_substs","","Stores the type parameters which were substituted to obtain the type\nof this node.  This only applies to nodes that refer to entities\nparameterized by type parameters, such as generic fns, types, or\nother items.",223],[11,"impl_or_trait_items","","Maps from a trait item to the trait item \"descriptor\"",223],[11,"trait_item_def_ids","","Maps from a trait def-id to a list of the def-ids of its trait items",223],[11,"trait_items_cache","","A cache for the trait_items() routine",223],[11,"impl_trait_cache","","",223],[11,"trait_refs","","",223],[11,"trait_defs","","",223],[11,"object_cast_map","","Maps from node-id of a trait object cast (like `foo as\nBox<Trait>`) to the trait reference.",223],[11,"map","","",223],[11,"intrinsic_defs","","",223],[11,"freevars","","",223],[11,"tcache","","",223],[11,"rcache","","",223],[11,"short_names_cache","","",223],[11,"tc_cache","","",223],[11,"ast_ty_to_ty_cache","","",223],[11,"enum_var_cache","","",223],[11,"ty_param_defs","","",223],[11,"adjustments","","",223],[11,"normalized_cache","","",223],[11,"lang_items","","",223],[11,"provided_method_sources","","A mapping of fake provided method def_ids to the default implementation",223],[11,"struct_fields","","",223],[11,"item_variance_map","","Maps from def-id of a type or region parameter to its\n(inferred) variance.",223],[11,"variance_computed","","True if the variance has been computed yet; false otherwise.",223],[11,"destructor_for_type","","A mapping from the def ID of an enum or struct type to the def ID\nof the method that implements its destructor. If the type is not\npresent in this map, it does not have a destructor. This map is\npopulated during the coherence phase of typechecking.",223],[11,"destructors","","A method will be in this list if and only if it is a destructor.",223],[11,"trait_impls","","Maps a trait onto a list of impls of that trait.",223],[11,"inherent_impls","","Maps a DefId of a type to a list of its inherent impls.\nContains implementations of methods that are inherent to a type.\nMethods in these implementations don't need to be exported.",223],[11,"impl_items","","Maps a DefId of an impl to a list of its items.\nNote that this contains all of the impls that we know about,\nincluding ones in other crates. It's not clear that this is the best\nway to do it.",223],[11,"used_unsafe","","Set of used unsafe nodes (functions or blocks). Unsafe nodes not\npresent in this set can be warned about.",223],[11,"used_mut_nodes","","Set of nodes which mark locals as mutable which end up getting used at\nsome point. Local variable definitions not in this set can be warned\nabout.",223],[11,"populated_external_types","","The set of external nominal types whose implementations have been read.\nThis is used for lazy resolution of methods.",223],[11,"populated_external_traits","","The set of external traits whose implementations have been read. This\nis used for lazy resolution of traits.",223],[11,"upvar_borrow_map","","Borrows",223],[11,"extern_const_statics","","These two caches are used by const_eval when decoding external statics\nand variants that are found.",223],[11,"extern_const_variants","","",223],[11,"method_map","","",223],[11,"dependency_formats","","",223],[11,"unboxed_closures","","Records the type of each unboxed closure. The def ID is the ID of the\nexpression defining the unboxed closure.",223],[11,"node_lint_levels","","",223],[11,"transmute_restrictions","","The types that must be asserted to be the same size for `transmute`\nto be valid. We gather up these restrictions in the intrinsicck pass\nand check them in trans.",223],[11,"stability","","Maps any item's def-id to its stability index.",223],[11,"capture_modes","","Maps closures to their capture clauses.",223],[11,"associated_types","","Maps def IDs to true if and only if they're associated types.",223],[11,"selection_cache","","Caches the results of trait selection. This cache is used\nfor things that do not have to do with the parameters in scope.",223],[11,"repr_hint_cache","","Caches the representation hints for struct definitions.",223],[11,"type_impls_copy_cache","","Caches whether types are known to impl Copy. Note that type\nparameters are never placed into this cache, because their\nresults are dependent on the parameter environment.",223],[11,"type_impls_sized_cache","","Caches whether types are known to impl Sized. Note that type\nparameters are never placed into this cache, because their\nresults are dependent on the parameter environment.",223],[1,"TypeFlags","",""],[18,"NO_TYPE_FLAGS","",""],[18,"HAS_PARAMS","",""],[18,"HAS_SELF","",""],[18,"HAS_TY_INFER","",""],[18,"HAS_RE_INFER","",""],[18,"HAS_RE_LATE_BOUND","",""],[18,"HAS_REGIONS","",""],[18,"HAS_TY_ERR","",""],[18,"HAS_PROJECTION","",""],[18,"NEEDS_SUBST","",""],[1,"TyS","",""],[11,"sty","","",224],[11,"flags","","",224],[4,"Ty","",""],[1,"InternedTy","","An entry in the type interner."],[3,"type_has_params","",""],[3,"type_has_self","",""],[3,"type_has_ty_infer","",""],[3,"type_needs_infer","",""],[3,"type_has_projection","",""],[3,"type_has_late_bound_regions","",""],[3,"type_has_escaping_regions","","An \"escaping region\" is a bound region whose binder is not part of `t`."],[3,"type_escapes_depth","",""],[1,"BareFnTy","",""],[11,"unsafety","","",227],[11,"abi","","",227],[11,"sig","","",227],[1,"ClosureTy","",""],[11,"unsafety","","",228],[11,"onceness","","",228],[11,"store","","",228],[11,"bounds","","",228],[11,"sig","","",228],[11,"abi","","",228],[2,"FnOutput","",""],[12,"FnConverging","","",229],[12,"FnDiverging","","",229],[1,"FnSig","","Signature of a function type, which I have arbitrarily\ndecided to use to refer to the input/output types."],[11,"inputs","","",84],[11,"output","","",84],[11,"variadic","","",84],[4,"PolyFnSig","",""],[1,"ParamTy","",""],[11,"space","","",230],[11,"idx","","",230],[11,"name","","",230],[1,"DebruijnIndex","","A [De Bruijn index][dbi] is a standard means of representing\nregions (and perhaps later types) in a higher-ranked setting. In\nparticular, imagine a type like this:"],[11,"depth","","",231],[2,"Region","","Representation of regions:"],[12,"ReEarlyBound","","",16],[12,"ReLateBound","","",16],[12,"ReFree","","When checking a function body, the types of all arguments and so forth\nthat refer to bound region parameters are modified to refer to free\nregion parameters.",16],[12,"ReScope","","A concrete region naming some expression within the current function.",16],[12,"ReStatic","","Static data that has an \"infinite\" lifetime. Top in the region lattice.",16],[12,"ReInfer","","A region variable.  Should not exist after typeck.",16],[12,"ReEmpty","","Empty lifetime is for data that is never accessed.\nBottom in the region lattice. We treat ReEmpty somewhat\nspecially; at least right now, we do not generate instances of\nit during the GLB computations, but rather\ngenerate an error instead. This is to improve error messages.\nThe only way to get an instance of ReEmpty is to have a region\nvariable with no constraints.",16],[1,"UpvarId","","Upvars do not get their own node-id. Instead, we use the pair of\nthe original var id (that is, the root variable that is referenced\nby the upvar) and the id of the closure expression."],[11,"var_id","","",232],[11,"closure_expr_id","","",232],[2,"BorrowKind","",""],[12,"ImmBorrow","","Data must be immutable and is aliasable.",233],[12,"UniqueImmBorrow","","Data must be immutable but not aliasable.  This kind of borrow\ncannot currently be expressed by the user and is used only in\nimplicit closure bindings. It is needed when you the closure\nis borrowing or mutating a mutable referent, e.g.:",233],[12,"MutBorrow","","Data is mutable and not aliasable.",233],[1,"UpvarBorrow","","Information describing the borrowing of an upvar. This is computed\nduring `typeck`, specifically by `regionck`. The general idea is\nthat the compiler analyses treat closures like:"],[11,"kind","","",23],[11,"region","","",23],[4,"UpvarBorrowMap","",""],[1,"FreeRegion","","A \"free\" region `fr` can be interpreted as \"some region\nat least as big as the scope `fr.scope`\"."],[11,"scope","","",17],[11,"bound_region","","",17],[2,"BoundRegion","",""],[12,"BrAnon","","An anonymous region parameter for a given fn (&T)",19],[12,"BrNamed","","Named region parameters for functions (a in &'a T)",19],[12,"BrFresh","","Fresh bound identifiers created during GLB computations.",19],[12,"BrEnv","","",19],[2,"sty","",""],[12,"ty_bool","","",226],[12,"ty_char","","",226],[12,"ty_int","","",226],[12,"ty_uint","","",226],[12,"ty_float","","",226],[12,"ty_enum","","Substs here, possibly against intuition, *may* contain `ty_param`s.\nThat is, even after substitution it is possible that there are type\nvariables. This happens when the `ty_enum` corresponds to an enum\ndefinition and not a concrete use of it. To get the correct `ty_enum`\nfrom the tcx, use the `NodeId` from the `ast::Ty` and look it up in\nthe `ast_ty_to_ty_cache`. This is probably true for `ty_struct` as\nwell.`",226],[12,"ty_uniq","","",226],[12,"ty_str","","",226],[12,"ty_vec","","",226],[12,"ty_ptr","","",226],[12,"ty_rptr","","",226],[12,"ty_bare_fn","","",226],[12,"ty_closure","","",226],[12,"ty_trait","","",226],[12,"ty_struct","","",226],[12,"ty_unboxed_closure","","",226],[12,"ty_tup","","",226],[12,"ty_projection","","",226],[12,"ty_param","","",226],[12,"ty_open","","",226],[12,"ty_infer","","",226],[12,"ty_err","","",226],[1,"TyTrait","",""],[11,"principal","","",234],[11,"bounds","","",234],[1,"TraitRef","","A complete reference to a trait. These take numerous guises in syntax,\nbut perhaps the most recognizable form is in a where clause:"],[11,"def_id","","",82],[11,"substs","","",82],[4,"PolyTraitRef","",""],[1,"Binder","","Binder is a binder for higher-ranked lifetimes. It is part of the\ncompiler's representation for things like `for<'a> Fn(&'a int)`\n(which would be represented by the type `PolyTraitRef ==\nBinder<TraitRef>`). Note that when we skolemize, instantiate,\nerase, or otherwise \"discharge\" these bound reons, we change the\ntype from `Binder<T>` to just `T` (see\ne.g. `liberate_late_bound_regions`)."],[2,"IntVarValue","",""],[12,"IntType","","",117],[12,"UintType","","",117],[2,"terr_vstore_kind","",""],[12,"terr_vec","","",235],[12,"terr_str","","",235],[12,"terr_fn","","",235],[12,"terr_trait","","",235],[1,"expected_found","",""],[11,"expected","","",236],[11,"found","","",236],[2,"type_err","",""],[12,"terr_mismatch","","",237],[12,"terr_unsafety_mismatch","","",237],[12,"terr_onceness_mismatch","","",237],[12,"terr_abi_mismatch","","",237],[12,"terr_mutability","","",237],[12,"terr_sigil_mismatch","","",237],[12,"terr_box_mutability","","",237],[12,"terr_ptr_mutability","","",237],[12,"terr_ref_mutability","","",237],[12,"terr_vec_mutability","","",237],[12,"terr_tuple_size","","",237],[12,"terr_fixed_array_size","","",237],[12,"terr_ty_param_size","","",237],[12,"terr_arg_count","","",237],[12,"terr_regions_does_not_outlive","","",237],[12,"terr_regions_not_same","","",237],[12,"terr_regions_no_overlap","","",237],[12,"terr_regions_insufficiently_polymorphic","","",237],[12,"terr_regions_overly_polymorphic","","",237],[12,"terr_trait_stores_differ","","",237],[12,"terr_sorts","","",237],[12,"terr_integer_as_char","","",237],[12,"terr_int_mismatch","","",237],[12,"terr_float_mismatch","","",237],[12,"terr_traits","","",237],[12,"terr_builtin_bounds","","",237],[12,"terr_variadic_mismatch","","",237],[12,"terr_cyclic_ty","","",237],[12,"terr_convergence_mismatch","","",237],[12,"terr_projection_name_mismatched","","",237],[12,"terr_projection_bounds_length","","",237],[1,"ParamBounds","","Bounds suitable for a named type parameter like `A` in `fn foo<A>`\nas well as the existential type parameter in an object type."],[11,"region_bounds","","",238],[11,"builtin_bounds","","",238],[11,"trait_bounds","","",238],[11,"projection_bounds","","",238],[1,"ExistentialBounds","","Bounds suitable for an existentially quantified type parameter\nsuch as those that appear in object types or closure types. The\nmajor difference between this case and `ParamBounds` is that\ngeneral purpose trait bounds are omitted and there must be\n*exactly one* region."],[11,"region_bound","","",239],[11,"builtin_bounds","","",239],[11,"projection_bounds","","",239],[4,"BuiltinBounds","",""],[2,"BuiltinBound","",""],[12,"BoundSend","","",240],[12,"BoundSized","","",240],[12,"BoundCopy","","",240],[12,"BoundSync","","",240],[3,"empty_builtin_bounds","",""],[3,"all_builtin_bounds","",""],[3,"region_existential_bound","","An existential bound that does not implement any traits."],[1,"TyVid","",""],[11,"index","","",241],[1,"IntVid","",""],[11,"index","","",116],[1,"FloatVid","",""],[11,"index","","",118],[1,"RegionVid","",""],[11,"index","","",242],[2,"InferTy","",""],[12,"TyVar","","",243],[12,"IntVar","","",243],[12,"FloatVar","","",243],[12,"FreshTy","","A `FreshTy` is one that is generated as a replacement for an\nunbound type variable. This is convenient for caching etc. See\n`middle::infer::freshen` for more details.",243],[12,"FreshIntTy","","",243],[2,"InferRegion","",""],[12,"ReVar","","",244],[12,"ReSkolemized","","",244],[1,"TypeParameterDef","",""],[11,"name","","",245],[11,"def_id","","",245],[11,"space","","",245],[11,"index","","",245],[11,"bounds","","",245],[11,"default","","",245],[1,"RegionParameterDef","",""],[11,"name","","",246],[11,"def_id","","",246],[11,"space","","",246],[11,"index","","",246],[11,"bounds","","",246],[1,"Generics","","Information about the formal type/lifetime parameters associated\nwith an item or method. Analogous to ast::Generics."],[11,"types","","",247],[11,"regions","","",247],[11,"predicates","","",247],[2,"Predicate","",""],[12,"Trait","","Corresponds to `where Foo : Bar<A,B,C>`. `Foo` here would be\nthe `Self` type of the trait reference and `A`, `B`, and `C`\nwould be the parameters in the `TypeSpace`.",248],[12,"Equate","","where `T1 == T2`.",248],[12,"RegionOutlives","","where 'a : 'b",248],[12,"TypeOutlives","","where T : 'a",248],[12,"Projection","","where <T as TraitRef>::Name == X, approximately.\nSee `ProjectionPredicate` struct for details.",248],[1,"TraitPredicate","",""],[11,"trait_ref","","",249],[4,"PolyTraitPredicate","",""],[1,"EquatePredicate","",""],[4,"PolyEquatePredicate","",""],[1,"OutlivesPredicate","",""],[4,"PolyOutlivesPredicate","",""],[4,"PolyRegionOutlivesPredicate","",""],[4,"PolyTypeOutlivesPredicate","",""],[1,"ProjectionPredicate","","This kind of predicate has no *direct* correspondent in the\nsyntax, but it roughly corresponds to the syntactic forms:"],[11,"projection_ty","","",83],[11,"ty","","",83],[4,"PolyProjectionPredicate","",""],[1,"ProjectionTy","","Represents the projection of an associated type. In explicit UFCS\nform this would be written `<T as Trait<..>>::N`."],[11,"trait_ref","","The trait reference `T as Trait<..>`.",252],[11,"item_name","","The name `N` of the associated type.",252],[6,"ToPolyTraitRef","",""],[9,"to_poly_trait_ref","","",423],[6,"AsPredicate","",""],[9,"as_predicate","","",424],[1,"GenericBounds","","Represents the bounds declared on a particular set of type\nparameters.  Should eventually be generalized into a flag list of\nwhere clauses.  You can obtain a `GenericBounds` list from a\n`Generics` by using the `to_bounds` method. Note that this method\nreflects an important semantic invariant of `GenericBounds`: while\nthe bounds in a `Generics` are expressed in terms of the bound type\nparameters of the impl/trait/whatever, a `GenericBounds` instance\nrepresented a set of bounds for some particular instantiation,\nmeaning that the generic parameters have been substituted with\ntheir values."],[11,"predicates","","",253],[1,"ParameterEnvironment","","When type checking, we use the `ParameterEnvironment` to track\ndetails about the type/lifetime parameters that are in scope.\nIt primarily stores the bounds information."],[11,"free_substs","","A substitution that can be applied to move from\nthe \"outer\" view of a type or method to the \"inner\" view.\nIn general, this means converting from bound parameters to\nfree parameters. Since we currently represent bound/free type\nparameters in the same way, this only has an effect on regions.",254],[11,"implicit_region_bound","","Each type parameter has an implicit region bound that\nindicates it must outlive at least the function body (the user\nmay specify stronger requirements). This field indicates the\nregion of the callee.",254],[11,"caller_bounds","","Obligations that the caller must satisfy. This is basically\nthe set of bounds on the in-scope type parameters, translated\ninto Obligations.",254],[11,"selection_cache","","Caches the results of trait selection. This cache is used\nfor things that have to do with the parameters in scope.",254],[1,"TypeScheme","","A \"type scheme\", in ML terminology, is a type combined with some\nset of generic types that the type is, well, generic over. In Rust\nterms, it is the \"type\" of a fn item or struct -- this type will\ninclude various generic parameters that must be substituted when\nthe item/struct is referenced. That is called converting the type\nscheme to a monotype."],[11,"generics","","",255],[11,"ty","","",255],[1,"TraitDef","","As `TypeScheme` but for a trait ref."],[11,"unsafety","","",350],[11,"generics","","Generic type definitions. Note that `Self` is listed in here\nas having a single bound, the trait itself (e.g., in the trait\n`Eq`, there is a single bound `Self : Eq`). This is so that\ndefault methods get to assume that the `Self` parameters\nimplements the trait.",350],[11,"bounds","","The \"supertrait\" bounds.",350],[11,"trait_ref","","",350],[11,"associated_type_names","","A list of the associated types defined in this trait. Useful\nfor resolving `X::Foo` type markers.",350],[1,"ItemSubsts","","Records the substitutions used to translate the polytype for an\nitem into the monotype of an item reference."],[11,"substs","","",256],[1,"UnboxedClosure","","Records information about each unboxed closure."],[11,"closure_type","","The type of the unboxed closure.",257],[11,"kind","","The kind of unboxed closure this is.",257],[2,"UnboxedClosureKind","",""],[12,"FnUnboxedClosureKind","","",258],[12,"FnMutUnboxedClosureKind","","",258],[12,"FnOnceUnboxedClosureKind","","",258],[3,"mk_ctxt","",""],[3,"mk_t","",""],[3,"mk_mach_int","",""],[3,"mk_mach_uint","",""],[3,"mk_mach_float","",""],[3,"mk_str","",""],[3,"mk_str_slice","",""],[3,"mk_enum","",""],[3,"mk_uniq","",""],[3,"mk_ptr","",""],[3,"mk_rptr","",""],[3,"mk_mut_rptr","",""],[3,"mk_imm_rptr","",""],[3,"mk_mut_ptr","",""],[3,"mk_imm_ptr","",""],[3,"mk_nil_ptr","",""],[3,"mk_vec","",""],[3,"mk_slice","",""],[3,"mk_tup","",""],[3,"mk_nil","",""],[3,"mk_closure","",""],[3,"mk_bare_fn","",""],[3,"mk_ctor_fn","",""],[3,"mk_trait","",""],[3,"sort_bounds_list","",""],[3,"mk_projection","",""],[3,"mk_struct","",""],[3,"mk_unboxed_closure","",""],[3,"mk_var","",""],[3,"mk_int_var","",""],[3,"mk_float_var","",""],[3,"mk_infer","",""],[3,"mk_param","",""],[3,"mk_self_type","",""],[3,"mk_param_from_def","",""],[3,"mk_open","",""],[3,"walk_ty","",""],[3,"maybe_walk_ty","",""],[3,"fold_ty","",""],[3,"type_is_nil","",""],[3,"type_is_error","",""],[3,"type_needs_subst","",""],[3,"trait_ref_contains_error","",""],[3,"type_is_ty_var","",""],[3,"type_is_bool","",""],[3,"type_is_self","",""],[3,"type_is_vec","",""],[3,"type_is_structural","",""],[3,"type_is_simd","",""],[3,"sequence_element_type","",""],[3,"simd_type","",""],[3,"simd_size","",""],[3,"type_is_region_ptr","",""],[3,"type_is_unsafe_ptr","",""],[3,"type_is_unique","",""],[3,"type_is_scalar","",""],[3,"type_is_floating_point","","Returns true if this type is a floating point type and false otherwise."],[1,"TypeContents","","Type contents is how the type checker reasons about kinds.\nThey track what kinds of things are found within a type.  You can\nthink of them as kind of an \"anti-kind\".  They track the kinds of values\nand thinks that are contained in types.  Having a larger contents for\na type tends to rule that type *out* from various kinds.  For example,\na type that contains a reference is not sendable."],[11,"bits","","",259],[3,"type_interior_is_unsafe","",""],[3,"type_contents","",""],[3,"type_moves_by_default","",""],[3,"type_is_sized","",""],[3,"is_ffi_safe","",""],[3,"is_instantiable","",""],[2,"Representability","","Describes whether a type is representable. For types that are not\nrepresentable, 'SelfRecursive' and 'ContainsRecursive' are used to\ndistinguish between types that are recursive with themselves and types that\ncontain a different recursive type. These cases can therefore be treated\ndifferently when reporting errors."],[12,"Representable","","",260],[12,"ContainsRecursive","","",260],[12,"SelfRecursive","","",260],[3,"is_type_representable","","Check whether a type is representable. This means it cannot contain unboxed\nstructural recursion. This check is needed for structs and enums."],[3,"type_is_trait","",""],[3,"type_trait_info","",""],[3,"type_is_integral","",""],[3,"type_is_fresh","",""],[3,"type_is_uint","",""],[3,"type_is_char","",""],[3,"type_is_bare_fn","",""],[3,"type_is_bare_fn_item","",""],[3,"type_is_fp","",""],[3,"type_is_numeric","",""],[3,"type_is_signed","",""],[3,"type_is_machine","",""],[3,"type_is_c_like_enum","",""],[3,"deref","",""],[3,"close_type","",""],[3,"type_content","",""],[3,"unopen_type","",""],[3,"index","",""],[3,"array_element_ty","",""],[3,"positional_element_ty","","Returns the type of element at index `i` in tuple or tuple-like type `t`.\nFor an enum `t`, `variant` is None only if `t` is a univariant enum."],[3,"named_element_ty","","Returns the type of element at field `n` in struct or struct-like type `t`.\nFor an enum `t`, `variant` must be some def id."],[3,"node_id_to_trait_ref","",""],[3,"try_node_id_to_type","",""],[3,"node_id_to_type","",""],[3,"node_id_to_type_opt","",""],[3,"node_id_item_substs","",""],[3,"fn_is_variadic","",""],[3,"ty_fn_sig","",""],[3,"ty_fn_abi","","Returns the ABI of the given function."],[3,"ty_fn_args","",""],[3,"ty_closure_store","",""],[3,"ty_fn_ret","",""],[3,"is_fn_ty","",""],[3,"ty_region","",""],[3,"free_region_from_def","",""],[3,"pat_ty","",""],[3,"expr_ty","",""],[3,"expr_ty_opt","",""],[3,"expr_ty_adjusted","","Returns the type of `expr`, considering any `AutoAdjustment`\nentry recorded for that expression."],[3,"expr_span","",""],[3,"local_var_name_str","",""],[3,"adjust_ty","","See `expr_ty_adjusted`"],[3,"adjust_ty_for_autoref","",""],[3,"unsize_ty","",""],[3,"resolve_expr","",""],[3,"expr_is_lval","",""],[2,"ExprKind","","We categorize expressions into three kinds.  The distinction between\nlvalue/rvalue is fundamental to the language.  The distinction between the\ntwo kinds of rvalues is an artifact of trans which reflects how we will\ngenerate code for that kind of expression.  See trans/expr.rs for more\ninformation."],[12,"LvalueExpr","","",425],[12,"RvalueDpsExpr","","",425],[12,"RvalueDatumExpr","","",425],[12,"RvalueStmtExpr","","",425],[3,"expr_kind","",""],[3,"stmt_node_id","",""],[3,"field_idx_strict","",""],[3,"impl_or_trait_item_idx","",""],[3,"ty_sort_string","",""],[3,"type_err_to_str","","Explains the source of a type err in a short, human readable way. This is meant to be placed\nin parentheses after some larger message. You should also invoke `note_and_explain_type_err()`\nafterwards to present additional details, particularly when it comes to lifetime-related\nerrors."],[3,"note_and_explain_type_err","",""],[3,"provided_source","",""],[3,"provided_trait_methods","",""],[3,"trait_item","",""],[3,"trait_items","",""],[3,"impl_or_trait_item","",""],[3,"is_associated_type","","Returns true if the given ID refers to an associated type and false if it\nrefers to anything else."],[3,"associated_type_parameter_index","","Returns the parameter index that the given associated type corresponds to."],[1,"AssociatedTypeInfo","",""],[11,"def_id","","",261],[11,"index","","",261],[11,"name","","",261],[3,"trait_item_def_ids","",""],[3,"impl_trait_ref","",""],[3,"trait_ref_to_def_id","",""],[3,"try_add_builtin_trait","","Checks whether `trait_ref` refers to one of the builtin\ntraits, like `Send`, and adds the corresponding\nbound to the set `builtin_bounds` if so. Returns true if `trait_ref`\nis a builtin trait."],[3,"ty_to_def_id","",""],[1,"VariantInfo","",""],[11,"args","","",262],[11,"arg_names","","",262],[11,"ctor_ty","","",262],[11,"name","","",262],[11,"id","","",262],[11,"disr_val","","",262],[11,"vis","","",262],[3,"substd_enum_variants","",""],[3,"item_path_str","",""],[2,"DtorKind","",""],[12,"NoDtor","","",263],[12,"TraitDtor","","",263],[3,"ty_dtor","",""],[3,"has_dtor","",""],[3,"with_path","",""],[3,"enum_is_univariant","",""],[3,"type_is_empty","",""],[3,"enum_variants","",""],[3,"enum_variant_with_id","",""],[3,"lookup_item_type","",""],[3,"lookup_trait_def","","Given the did of a trait, returns its canonical trait ref."],[3,"predicates_for_trait_ref","","Given a reference to a trait, returns the \"superbounds\" declared\non the trait, with appropriate substitutions applied. Basically,\nthis applies a filter to the where clauses on the trait, returning\nthose that have the form:"],[3,"predicates","",""],[3,"each_attr","","Iterate over attributes of a definition."],[3,"has_attr","","Determine whether an item is annotated with an attribute"],[3,"lookup_packed","","Determine whether an item is annotated with `#[repr(packed)]`"],[3,"lookup_simd","","Determine whether an item is annotated with `#[simd]`"],[3,"lookup_repr_hints","","Obtain the representation annotation for a struct definition."],[3,"lookup_field_type","",""],[3,"lookup_struct_fields","",""],[3,"is_tuple_struct","",""],[3,"struct_fields","",""],[3,"tup_fields","",""],[1,"UnboxedClosureUpvar","",""],[11,"def","","",426],[11,"span","","",426],[11,"ty","","",426],[3,"unboxed_closure_upvars","",""],[3,"is_binopable","",""],[3,"normalize_ty","","Returns an equivalent type with all the typedefs and self regions removed."],[3,"eval_repeat_count","",""],[3,"each_bound_trait_and_supertraits","",""],[3,"object_region_bounds","",""],[3,"required_region_bounds","","Given a set of predicates that apply to an object type, returns\nthe region bounds that the (erased) `Self` type must\noutlive. Precisely *because* the `Self` type is erased, the\nparameter `erased_self_ty` must be supplied to indicate what type\nhas been used to represent `Self` in the predicates\nthemselves. This should really be a unique type; `FreshTy(0)` is a\npopular choice (see `object_region_bounds` above)."],[3,"get_tydesc_ty","",""],[3,"item_variances","",""],[3,"record_trait_implementation","","Records a trait-to-implementation mapping."],[3,"populate_implementations_for_type_if_necessary","","Populates the type context with all the implementations for the given type\nif necessary."],[3,"populate_implementations_for_trait_if_necessary","","Populates the type context with all the implementations for the given\ntrait if necessary."],[3,"trait_id_of_impl","","Given the def_id of an impl, return the def_id of the trait it implements.\nIf it implements no trait, return `None`."],[3,"impl_of_method","","If the given def ID describes a method belonging to an impl, return the\nID of the impl that the method belongs to. Otherwise, return `None`."],[3,"trait_of_item","","If the given def ID describes an item belonging to a trait (either a\ndefault method or an implementation of a trait method), return the ID of\nthe trait that the method belongs to. Otherwise, return `None`."],[3,"trait_item_of_item","","If the given def ID describes an item belonging to a trait, (either a\ndefault method or an implementation of a trait method), return the ID of\nthe method inside trait definition (this means that if the given def ID\nis already that of the original trait method, then the return value is\nthe same).\nOtherwise, return `None`."],[3,"hash_crate_independent","","Creates a hash of the type `Ty` which will be the same no matter what crate\ncontext it's calculated within. This is used by the `type_id` intrinsic."],[3,"empty_parameter_environment","","Construct a parameter environment suitable for static contexts or other contexts where there\nare no free type/lifetime parameters in scope."],[3,"construct_parameter_environment","","See `ParameterEnvironment` struct def'n for details"],[2,"ExplicitSelfCategory","","The category of explicit self."],[12,"StaticExplicitSelfCategory","","",264],[12,"ByValueExplicitSelfCategory","","",264],[12,"ByReferenceExplicitSelfCategory","","",264],[12,"ByBoxExplicitSelfCategory","","",264],[3,"accumulate_lifetimes_in_type","","Pushes all the lifetimes in the given type onto the given list. A\n\"lifetime in a type\" is a lifetime specified by a reference or a lifetime\nin a list of type substitutions. This does *not* traverse into nominal\ntypes, nor does it resolve fictitious types."],[1,"Freevar","","A free variable referred to in a function."],[11,"def","","The variable being accessed free.",22],[11,"span","","",22],[4,"FreevarMap","",""],[4,"CaptureModeMap","",""],[4,"TraitMap","",""],[4,"GlobMap","",""],[3,"with_freevars","",""],[3,"liberate_late_bound_regions","","Replace any late-bound regions bound in `value` with free variants attached to scope-id\n`scope_id`."],[3,"count_late_bound_regions","",""],[3,"binds_late_bound_regions","",""],[3,"erase_late_bound_regions","","Replace any late-bound regions bound in `value` with `'static`. Useful in trans but also\nmethod lookup and a few other places where precise region relationships are not required."],[3,"anonymize_late_bound_regions","","Rewrite any late-bound regions so that they are anonymous.  Region numbers are\nassigned starting at 1 and increasing monotonically in the order traversed\nby the fold operation."],[3,"replace_late_bound_regions","","Replaces the late-bound-regions in `value` that are bound by `value`."],[3,"make_substs_for_receiver_types","","Substitutes the values for the receiver's type parameters\nthat are found in method, leaving the method's type parameters\nintact."],[2,"CopyImplementationError","",""],[12,"FieldDoesNotImplementCopy","","",427],[12,"VariantDoesNotImplementCopy","","",427],[12,"TypeIsStructural","","",427],[3,"can_type_implement_copy","",""],[6,"RegionEscape","",""],[9,"has_escaping_regions","","",428],[9,"has_regions_escaping_depth","","",428],[6,"HasProjectionTypes","",""],[9,"has_projection_types","","",429],[6,"ReferencesError","",""],[9,"references_error","","",430],[0,"ty_fold","rustc_typeck::middle","Generalized type folding mechanism. The setup is a bit convoluted\nbut allows for convenient usage. Let T be an instance of some\n\"foldable type\" (one which implements `TypeFoldable`) and F be an\ninstance of a \"folder\" (a type which implements `TypeFolder`). Then\nthe setup is intended to be:"],[6,"TypeFoldable","rustc_typeck::middle::ty_fold","The TypeFoldable trait is implemented for every type that can be folded.\nBasically, every type that has a corresponding method in TypeFolder."],[9,"fold_with","","",431],[6,"TypeFolder","","The TypeFolder trait defines the actual *folding*. There is a\nmethod defined for every foldable type. Each of these has a\ndefault implementation that does an \"identity\" fold. Within each\nidentity fold, it should invoke `foo.fold_with(self)` to fold each\nsub-item."],[9,"tcx","","",432],[9,"enter_region_binder","","Invoked by the `super_*` routines when we enter a region\nbinding level (for example, when entering a function\nsignature). This is used by clients that want to track the\nDebruijn index nesting level.",432],[9,"exit_region_binder","","Invoked by the `super_*` routines when we exit a region\nbinding level. This is used by clients that want to\ntrack the Debruijn index nesting level.",432],[9,"fold_ty","","",432],[9,"fold_mt","","",432],[9,"fold_trait_ref","","",432],[9,"fold_substs","","",432],[9,"fold_fn_sig","","",432],[9,"fold_output","","",432],[9,"fold_bare_fn_ty","","",432],[9,"fold_closure_ty","","",432],[9,"fold_region","","",432],[9,"fold_trait_store","","",432],[9,"fold_existential_bounds","","",432],[9,"fold_autoref","","",432],[9,"fold_item_substs","","",432],[3,"super_fold_ty","",""],[3,"super_fold_substs","",""],[3,"super_fold_fn_sig","",""],[3,"super_fold_output","",""],[3,"super_fold_bare_fn_ty","",""],[3,"super_fold_closure_ty","",""],[3,"super_fold_trait_ref","",""],[3,"super_fold_mt","",""],[3,"super_fold_trait_store","",""],[3,"super_fold_existential_bounds","",""],[3,"super_fold_autoref","",""],[3,"super_fold_item_substs","",""],[1,"BottomUpFolder","",""],[11,"tcx","","",269],[11,"fldop","","",269],[1,"RegionFolder","","Folds over the substructure of a type, visiting its component\ntypes and all regions that occur *free* within it."],[3,"collect_regions","",""],[3,"fold_regions","",""],[1,"RegionEraser","",""],[3,"erase_regions","",""],[3,"shift_region","",""],[3,"shift_regions","",""],[0,"weak_lang_items","rustc_typeck::middle","Validity checking for weak lang items"],[3,"check_crate","rustc_typeck::middle::weak_lang_items","Checks the crate for usage of weak lang items, returning a vector of all the\nlanguage items required by this crate, but not defined yet."],[3,"link_name","",""],[0,"session","rustc_typeck",""],[0,"config","rustc_typeck::session","Contains infrastructure for configuring the compiler, including parsing\ncommand line options."],[1,"Config","rustc_typeck::session::config",""],[11,"target","","",433],[11,"int_type","","",433],[11,"uint_type","","",433],[2,"OptLevel","",""],[12,"No","","",293],[12,"Less","","",293],[12,"Default","","",293],[12,"Aggressive","","",293],[2,"DebugInfoLevel","",""],[12,"NoDebugInfo","","",294],[12,"LimitedDebugInfo","","",294],[12,"FullDebugInfo","","",294],[2,"OutputType","",""],[12,"OutputTypeBitcode","","",295],[12,"OutputTypeAssembly","","",295],[12,"OutputTypeLlvmAssembly","","",295],[12,"OutputTypeObject","","",295],[12,"OutputTypeExe","","",295],[12,"OutputTypeDepInfo","","",295],[1,"Options","",""],[11,"crate_types","","",296],[11,"gc","","",296],[11,"optimize","","",296],[11,"debuginfo","","",296],[11,"lint_opts","","",296],[11,"describe_lints","","",296],[11,"output_types","","",296],[11,"search_paths","","",296],[11,"libs","","",296],[11,"maybe_sysroot","","",296],[11,"target_triple","","",296],[11,"cfg","","",296],[11,"test","","",296],[11,"parse_only","","",296],[11,"no_trans","","",296],[11,"no_analysis","","",296],[11,"debugging_opts","","",296],[11,"write_dependency_info","","Whether to write dependency files. It's (enabled, optional filename).",296],[11,"prints","","",296],[11,"cg","","",296],[11,"color","","",296],[11,"externs","","",296],[11,"crate_name","","",296],[11,"alt_std_name","","An optional name to use as the crate for std during std injection,\nwritten `extern crate std = \"name\"`. Default to \"std\". Used by\nout-of-tree drivers.",296],[2,"PrintRequest","",""],[12,"FileNames","","",297],[12,"Sysroot","","",297],[12,"CrateName","","",297],[2,"Input","",""],[12,"File","","Load source from file",298],[12,"Str","","The string is the source",298],[1,"OutputFilenames","",""],[11,"out_directory","","",299],[11,"out_filestem","","",299],[11,"single_output_file","","",299],[11,"extra","","",299],[3,"host_triple","",""],[3,"basic_options","","Some reasonable defaults"],[2,"EntryFnType","",""],[12,"EntryMain","","",300],[12,"EntryStart","","",300],[12,"EntryNone","","",300],[2,"CrateType","",""],[12,"CrateTypeExecutable","","",301],[12,"CrateTypeDylib","","",301],[12,"CrateTypeRlib","","",301],[12,"CrateTypeStaticlib","","",301],[18,"VERBOSE","",""],[18,"TIME_PASSES","",""],[18,"COUNT_LLVM_INSNS","",""],[18,"TIME_LLVM_PASSES","",""],[18,"TRANS_STATS","",""],[18,"ASM_COMMENTS","",""],[18,"NO_VERIFY","",""],[18,"BORROWCK_STATS","",""],[18,"NO_LANDING_PADS","",""],[18,"DEBUG_LLVM","",""],[18,"SHOW_SPAN","",""],[18,"COUNT_TYPE_SIZES","",""],[18,"META_STATS","",""],[18,"GC","",""],[18,"PRINT_LINK_ARGS","",""],[18,"PRINT_LLVM_PASSES","",""],[18,"AST_JSON","",""],[18,"AST_JSON_NOEXPAND","",""],[18,"LS","",""],[18,"SAVE_ANALYSIS","",""],[18,"PRINT_MOVE_FRAGMENTS","",""],[18,"FLOWGRAPH_PRINT_LOANS","",""],[18,"FLOWGRAPH_PRINT_MOVES","",""],[18,"FLOWGRAPH_PRINT_ASSIGNS","",""],[18,"FLOWGRAPH_PRINT_ALL","",""],[18,"PRINT_REGION_GRAPH","",""],[18,"PARSE_ONLY","",""],[18,"NO_TRANS","",""],[18,"NO_ANALYSIS","",""],[18,"UNSTABLE_OPTIONS","",""],[18,"PRINT_ENUM_SIZES","",""],[3,"debugging_opts_map","",""],[2,"Passes","",""],[12,"SomePasses","","",302],[12,"AllPasses","","",302],[1,"CodegenOptions","",""],[11,"ar","","",303],[11,"linker","","",303],[11,"link_args","","",303],[11,"lto","","",303],[11,"target_cpu","","",303],[11,"target_feature","","",303],[11,"passes","","",303],[11,"llvm_args","","",303],[11,"save_temps","","",303],[11,"rpath","","",303],[11,"no_prepopulate_passes","","",303],[11,"no_vectorize_loops","","",303],[11,"no_vectorize_slp","","",303],[11,"soft_float","","",303],[11,"prefer_dynamic","","",303],[11,"no_integrated_as","","",303],[11,"no_redzone","","",303],[11,"relocation_model","","",303],[11,"code_model","","",303],[11,"metadata","","",303],[11,"extra_filename","","",303],[11,"codegen_units","","",303],[11,"remark","","",303],[11,"no_stack_check","","",303],[11,"debuginfo","","",303],[11,"opt_level","","",303],[3,"basic_codegen_options","",""],[4,"CodegenSetter","",""],[18,"CG_OPTIONS","",""],[3,"build_codegen_options","",""],[3,"default_lib_output","",""],[3,"default_configuration","",""],[3,"append_configuration","",""],[3,"build_configuration","",""],[3,"build_target_config","",""],[3,"short_optgroups","","Returns the \"short\" subset of the stable rustc command line options."],[3,"optgroups","","Returns all of the stable rustc command line options."],[2,"OptionStability","",""],[12,"Stable","","",304],[12,"Unstable","","",304],[1,"RustcOptGroup","",""],[11,"opt_group","","",305],[11,"stability","","",305],[3,"rustc_short_optgroups","","Returns the \"short\" subset of the rustc command line options,\nincluding metadata for each option, such as whether the option is\npart of the stable long-term interface for rustc."],[3,"rustc_optgroups","","Returns all rustc command line options, including metadata for\neach option, such as whether the option is part of the stable\nlong-term interface for rustc."],[3,"parse_cfgspecs","",""],[3,"build_session_options","",""],[3,"parse_crate_types_from_list","",""],[0,"search_paths","rustc_typeck::session",""],[1,"SearchPaths","rustc_typeck::session::search_paths",""],[1,"Iter","",""],[2,"PathKind","",""],[12,"Native","","",307],[12,"Crate","","",307],[12,"Dependency","","",307],[12,"All","","",307],[1,"Session","rustc_typeck::session",""],[11,"target","","",309],[11,"opts","","",309],[11,"cstore","","",309],[11,"parse_sess","","",309],[11,"entry_fn","","",309],[11,"entry_type","","",309],[11,"plugin_registrar_fn","","",309],[11,"default_sysroot","","",309],[11,"local_crate_source_file","","",309],[11,"working_dir","","",309],[11,"lint_store","","",309],[11,"lints","","",309],[11,"crate_types","","",309],[11,"crate_metadata","","",309],[11,"features","","",309],[11,"recursion_limit","","The maximum recursion limit for potentially infinitely recursive\noperations such as auto-dereference and monomorphization.",309],[11,"can_print_warnings","","",309],[3,"build_session","",""],[3,"build_session_","",""],[3,"expect","",""],[3,"early_error","",""],[3,"early_warn","",""],[0,"util","rustc_typeck",""],[0,"common","rustc_typeck::util",""],[1,"ErrorReported","rustc_typeck::util::common",""],[3,"time","",""],[3,"indent","",""],[1,"Indenter","",""],[3,"indenter","",""],[3,"loop_query","",""],[3,"block_query","",""],[3,"can_reach","","K: Eq + Hash<S>, V, S, H: Hasher<S>"],[3,"memoized","","Memoizes a one-argument closure using the given RefCell containing\na type implementing MutableMap to serve as a cache."],[0,"ppaux","rustc_typeck::util",""],[6,"Repr","rustc_typeck::util::ppaux","Produces a string suitable for debugging output."],[9,"repr","","",434],[6,"UserString","","Produces a string suitable for showing to the user."],[9,"user_string","","",435],[3,"note_and_explain_region","",""],[3,"explain_region_and_span","",""],[3,"bound_region_ptr_to_string","",""],[3,"bound_region_to_string","",""],[3,"region_ptr_to_string","",""],[3,"region_to_string","",""],[3,"mutability_to_string","",""],[3,"mt_to_string","",""],[3,"trait_store_to_string","",""],[3,"vec_map_to_string","",""],[3,"ty_to_string","",""],[3,"explicit_self_category_to_str","",""],[3,"parameterized","",""],[3,"ty_to_short_str","",""],[0,"nodemap","rustc_typeck::util","An efficient hash map for node IDs"],[4,"FnvHashMap","rustc_typeck::util::nodemap",""],[4,"FnvHashSet","",""],[4,"NodeMap","",""],[4,"DefIdMap","",""],[4,"NodeSet","",""],[4,"DefIdSet","",""],[0,"FnvHashMap","",""],[3,"new","rustc_typeck::util::nodemap::FnvHashMap",""],[0,"FnvHashSet","rustc_typeck::util::nodemap",""],[3,"new","rustc_typeck::util::nodemap::FnvHashSet",""],[0,"NodeMap","rustc_typeck::util::nodemap",""],[3,"new","rustc_typeck::util::nodemap::NodeMap",""],[0,"DefIdMap","rustc_typeck::util::nodemap",""],[3,"new","rustc_typeck::util::nodemap::DefIdMap",""],[0,"NodeSet","rustc_typeck::util::nodemap",""],[3,"new","rustc_typeck::util::nodemap::NodeSet",""],[0,"DefIdSet","rustc_typeck::util::nodemap",""],[3,"new","rustc_typeck::util::nodemap::DefIdSet",""],[1,"FnvHasher","rustc_typeck::util::nodemap","A speedy hash algorithm for node ids and def ids. The hashmap in\nlibcollections by default uses SipHash which isn't quite as speedy as we\nwant. In the compiler we're not really worried about DOS attempts, so we\njust default to a non-cryptographic hash."],[1,"FnvState","",""],[0,"snapshot_vec","rustc_typeck::util","A utility class for implementing \"snapshottable\" things; a snapshottable data structure permits\nyou to take a snapshot (via `start_snapshot`) and then, after making some changes, elect either\nto rollback to the start of the snapshot or commit those changes."],[2,"UndoLog","rustc_typeck::util::snapshot_vec",""],[12,"OpenSnapshot","","Indicates where a snapshot started.",366],[12,"CommittedSnapshot","","Indicates a snapshot that has been committed.",366],[12,"NewElem","","New variable with given index was created.",366],[12,"SetElem","","Variable with given index was changed *from* the given value.",366],[12,"Other","","Extensible set of actions",366],[1,"SnapshotVec","",""],[1,"Snapshot","",""],[6,"SnapshotVecDelegate","",""],[9,"reverse","","",436],[0,"lev_distance","rustc_typeck::util",""],[3,"lev_distance","rustc_typeck::util::lev_distance",""],[0,"fs","rustc_typeck::util",""],[3,"realpath","rustc_typeck::util::fs","Returns an absolute path in the filesystem that `path` points to. The\nreturned path does not contain any symlinks in its hierarchy."],[0,"sha2","rustc_typeck::util","This module implements only the Sha256 function since that is all that is needed for internal\nuse. This implementation is not intended for external use or for any use where security is\nimportant."],[6,"Digest","rustc_typeck::util::sha2","The Digest trait specifies an interface common to digest functions, such as SHA-1 and the SHA-2\nfamily of digest functions."],[9,"input","","Provide message data.",437],[9,"result","","Retrieve the digest result. This method may be called multiple times.",437],[9,"reset","","Reset the digest. This method must be called after result() and before supplying more\ndata.",437],[9,"output_bits","","Get the output size in bits.",437],[9,"input_str","","Convenience function that feeds a string into a digest.",437],[9,"result_bytes","","Convenience function that retrieves the result of a digest as a\nnewly allocated vec of bytes.",437],[9,"result_str","","Convenience function that retrieves the result of a digest as a\nString in hexadecimal format.",437],[10,"fmt","rustc_back::target","",438],[10,"clone","","",438],[10,"clone_from","","",438],[10,"fmt","","",439],[10,"clone","","",439],[10,"clone_from","","",439],[10,"default","","Create a set of \"sane defaults\" for any target. This is still incomplete, and if used for\ncompilation, will certainly not work.",439],[10,"adjust_abi","","Given a function ABI, turn \"System\" into the correct ABI for this target.",438],[10,"from_json","","Load a target descriptor from a JSON object.",438],[10,"search","","Search RUST_TARGET_PATH for a JSON file specifying the given target triple. Note that it\ncould also just be a bare filename already, so also check for that. If one of the hardcoded\ntargets we know about, just return it directly.",438],[1,"Sha256","rustc_typeck::util::sha2","The SHA-256 hash algorithm"]],"paths":[[1,"Lint"],[1,"Archive"],[1,"ArchiveBuilder"],[1,"Svh"],[2,"SawAbiComponent"],[2,"SawExprComponent"],[2,"SawStmtComponent"],[1,"Ident"],[1,"Name"],[1,"StrictVersionHashVisitor"],[1,"DecodeContext"],[1,"DefId"],[2,"Option"],[1,"Span"],[1,"NestedItemsDropper"],[2,"Def"],[2,"Region"],[1,"FreeRegion"],[2,"CodeExtent"],[2,"BoundRegion"],[2,"TraitStore"],[1,"Decoder"],[1,"Freevar"],[1,"UpvarBorrow"],[2,"MethodOrigin"],[1,"EncodeContext"],[1,"Encoder"],[1,"SideTableEncodingIdVisitor"],[1,"Doc"],[1,"LabelledCFG"],[1,"CFG"],[1,"CheckCrateVisitor"],[1,"CheckCrateVisitor"],[1,"CheckItemRecursionVisitor"],[2,"Context"],[1,"CheckLoopVisitor"],[1,"Matrix"],[2,"Constructor"],[2,"Usefulness"],[1,"MatchCheckCtxt"],[1,"StaticInliner"],[1,"MutationChecker"],[1,"AtBindingPatternVisitor"],[1,"RvalueContext"],[1,"RvalueContextDelegate"],[2,"Mode"],[1,"CheckStaticVisitor"],[1,"GlobalVisitor"],[1,"GlobalChecker"],[1,"ConstEvalVisitor"],[2,"const_val"],[2,"EntryOrExit"],[1,"DataFlowContext"],[1,"Union"],[1,"Subtract"],[1,"MarkSymbolVisitor"],[1,"LifeSeeder"],[1,"DeadVisitor"],[2,"MethodProvenance"],[2,"TyParamProvenance"],[2,"TraitItemKind"],[2,"UnsafeContext"],[1,"EffectCheckVisitor"],[1,"EntryContext"],[2,"LoanCause"],[2,"ConsumeMode"],[2,"MoveReason"],[2,"MatchMode"],[2,"TrackMatchMode"],[2,"MutateMode"],[1,"ExprUseVisitor"],[2,"SimplifiedType"],[1,"Edge"],[1,"NodeIndex"],[1,"EdgeIndex"],[1,"Direction"],[1,"Graph"],[1,"DepthFirstTraversal"],[1,"IntrinsicCheckingVisitor"],[1,"TransmuteRestriction"],[1,"Coerce"],[1,"Rc"],[1,"TraitRef"],[1,"ProjectionPredicate"],[1,"FnSig"],[1,"CombineFields"],[1,"Generalizer"],[1,"Equate"],[1,"InferCtxt"],[1,"Binder"],[1,"Glb"],[1,"Lub"],[2,"Node"],[1,"ConstraintGraph"],[2,"Constraint"],[1,"TwoRegions"],[2,"UndoLogEntry"],[2,"CombineMapType"],[2,"RegionResolutionError"],[1,"SameRegions"],[1,"RegionSnapshot"],[1,"RegionVarBindings"],[2,"Classification"],[2,"Verify"],[2,"VarValue"],[1,"RegionAndOrigin"],[1,"OpportunisticTypeResolver"],[1,"FullTypeResolver"],[1,"TypeFreshener"],[1,"Sub"],[2,"RelationDir"],[1,"TypeVariableTable"],[1,"Delegate"],[2,"VarValue"],[1,"UnificationTable"],[1,"Delegate"],[1,"IntVid"],[2,"IntVarValue"],[1,"FloatVid"],[2,"FloatTy"],[2,"TypeOrigin"],[2,"ValuePairs"],[1,"TypeTrace"],[2,"SubregionOrigin"],[2,"LateBoundRegionConversionTime"],[2,"RegionVariableOrigin"],[2,"fixup_err"],[2,"Result"],[2,"LangItem"],[1,"LanguageItems"],[1,"LanguageItemCollector"],[1,"Variable"],[1,"LiveNode"],[2,"LiveNodeKind"],[1,"IrMaps"],[1,"LocalInfo"],[2,"VarKind"],[1,"Liveness"],[1,"Users"],[2,"categorization"],[1,"Upvar"],[2,"PointerKind"],[2,"InteriorKind"],[2,"FieldName"],[2,"ElementKind"],[2,"MutabilityCategory"],[2,"Note"],[1,"cmt_"],[1,"Expr"],[1,"Pat"],[1,"MemCategorizationContext"],[2,"LastPrivate"],[2,"PrivateDep"],[2,"ImportUse"],[1,"ParentVisitor"],[1,"EmbargoVisitor"],[1,"PrivacyVisitor"],[1,"SanePrivacyVisitor"],[1,"CheckTypeForPrivatenessVisitor"],[1,"VisiblePrivateTypesVisitor"],[1,"ReachableContext"],[1,"RegionMaps"],[1,"RegionResolutionVisitor"],[2,"DefRegion"],[1,"LifetimeContext"],[2,"ScopeChain"],[1,"Annotator"],[1,"Index"],[1,"Substs"],[2,"RegionSubsts"],[2,"ParamSpace"],[1,"VecPerParamSpace"],[1,"EnumeratedItems"],[1,"SubstFolder"],[1,"FulfillmentContext"],[1,"RegionObligation"],[1,"MismatchedProjectionTypes"],[1,"AssociatedTypeNormalizer"],[2,"ProjectionTyError"],[2,"ProjectionTyCandidate"],[1,"SelectionCache"],[2,"MethodMatchedData"],[2,"SelectionCandidate"],[2,"EvaluationResult"],[1,"SelectionContext"],[1,"TraitObligationStack"],[2,"MethodMatchResult"],[1,"Elaborator"],[1,"Supertraits"],[1,"VtableImplData"],[1,"Obligation"],[2,"Vtable"],[1,"VtableBuiltinData"],[2,"SelectionError"],[1,"FulfillmentError"],[2,"FulfillmentErrorCode"],[1,"ObligationCause"],[2,"ObligationCauseCode"],[1,"DerivedObligationCause"],[1,"field"],[2,"ImplOrTraitItemContainer"],[2,"ImplOrTraitItem"],[2,"ImplOrTraitItemId"],[1,"Method"],[1,"AssociatedType"],[1,"mt"],[1,"field_ty"],[1,"creader_cache_key"],[1,"ItemVariances"],[2,"Variance"],[2,"AutoAdjustment"],[2,"UnsizeKind"],[1,"AutoDerefRef"],[2,"AutoRef"],[1,"param_index"],[1,"MethodParam"],[1,"MethodObject"],[1,"MethodCallee"],[1,"MethodCall"],[2,"ExprAdjustment"],[2,"vtable_origin"],[1,"CtxtArenas"],[1,"TypeFlags"],[1,"ctxt"],[1,"TyS"],[1,"InternedTy"],[2,"sty"],[1,"BareFnTy"],[1,"ClosureTy"],[2,"FnOutput"],[1,"ParamTy"],[1,"DebruijnIndex"],[1,"UpvarId"],[2,"BorrowKind"],[1,"TyTrait"],[2,"terr_vstore_kind"],[1,"expected_found"],[2,"type_err"],[1,"ParamBounds"],[1,"ExistentialBounds"],[2,"BuiltinBound"],[1,"TyVid"],[1,"RegionVid"],[2,"InferTy"],[2,"InferRegion"],[1,"TypeParameterDef"],[1,"RegionParameterDef"],[1,"Generics"],[2,"Predicate"],[1,"TraitPredicate"],[1,"EquatePredicate"],[1,"OutlivesPredicate"],[1,"ProjectionTy"],[1,"GenericBounds"],[1,"ParameterEnvironment"],[1,"TypeScheme"],[1,"ItemSubsts"],[1,"UnboxedClosure"],[2,"UnboxedClosureKind"],[1,"TypeContents"],[2,"Representability"],[1,"AssociatedTypeInfo"],[1,"VariantInfo"],[2,"DtorKind"],[2,"ExplicitSelfCategory"],[1,"Box"],[1,"Vec"],[1,"OwnedSlice"],[1,"EnumSet"],[1,"BottomUpFolder"],[1,"RegionFolder"],[1,"RegionEraser"],[1,"Context"],[2,"astencode_tag"],[1,"LinkMeta"],[2,"DefIdSource"],[1,"entry"],[1,"EncodeVisitor"],[1,"ImplVisitor"],[2,"Family"],[2,"DefLike"],[1,"CrateDep"],[1,"Env"],[1,"PluginMetadataReader"],[2,"LinkagePreference"],[2,"NativeLibraryKind"],[1,"CrateSource"],[1,"CStore"],[1,"crate_metadata"],[2,"MetadataBlob"],[1,"Context"],[1,"ArchiveMetadata"],[1,"FileSearch"],[2,"OptLevel"],[2,"DebugInfoLevel"],[2,"OutputType"],[1,"Options"],[2,"PrintRequest"],[2,"Input"],[1,"OutputFilenames"],[2,"EntryFnType"],[2,"CrateType"],[2,"Passes"],[1,"CodegenOptions"],[2,"OptionStability"],[1,"RustcOptGroup"],[1,"SearchPaths"],[2,"PathKind"],[1,"Iter"],[1,"Session"],[1,"Registry"],[1,"PluginLoader"],[1,"RegistrarFinder"],[1,"LintId"],[2,"Level"],[2,"LintSource"],[1,"WhileTrue"],[1,"UnusedCasts"],[1,"TypeLimits"],[1,"ImproperCTypesVisitor"],[1,"ImproperCTypes"],[1,"BoxPointers"],[1,"RawPtrDerivingVisitor"],[1,"RawPointerDeriving"],[1,"UnusedAttributes"],[1,"PathStatements"],[1,"UnusedResults"],[1,"NonCamelCaseTypes"],[2,"MethodContext"],[1,"NonSnakeCase"],[1,"NonUpperCaseGlobals"],[1,"UnusedParens"],[1,"UnusedImportBraces"],[1,"NonShorthandFieldPatterns"],[1,"UnusedUnsafe"],[1,"UnsafeBlocks"],[1,"UnusedMut"],[1,"UnusedAllocation"],[1,"MissingDoc"],[1,"MissingCopyImplementations"],[1,"Stability"],[1,"HardwiredLints"],[1,"LintStore"],[1,"Context"],[1,"GatherNodeLevels"],[1,"ErrorReported"],[1,"Indenter"],[1,"LoopQueryVisitor"],[1,"BlockQueryVisitor"],[1,"P"],[1,"TraitDef"],[2,"TraitItem"],[1,"Path"],[1,"Ty"],[1,"Item"],[1,"Lifetime"],[1,"Spanned"],[2,"ExplicitSelf_"],[2,"Visibility"],[2,"Abi"],[2,"Mutability"],[2,"IntTy"],[2,"UintTy"],[1,"HashMap"],[1,"FnvHasher"],[1,"FnvState"],[2,"UndoLog"],[1,"SnapshotVec"],[1,"FixedBuffer64"],[1,"Sha256"],[1,"ArchiveRO"],[2,"OptimizationDiagnosticKind"],[2,"Diagnostic"],[2,"CallConv"],[2,"DiagnosticSeverity"],[1,"Attribute"],[2,"OtherAttribute"],[2,"SpecialAttribute"],[1,"AttrBuilder"],[2,"TypeKind"],[2,"CodeGenOptLevel"],[2,"RelocMode"],[1,"TargetData"],[1,"ObjectFile"],[1,"SectionIter"],[6,"LintPass"],[1,"ctxt"],[2,"InlinedItemRef"],[1,"EncodeParams"],[1,"MethodInfo"],[2,"found_ast"],[1,"Library"],[1,"CratePaths"],[2,"FileMatch"],[6,"vtable_decoder_helpers"],[1,"CFGNodeData"],[1,"CFGEdgeData"],[2,"constness"],[6,"BitwiseOperator"],[6,"DataFlowOperator"],[1,"Export"],[6,"Delegate"],[1,"Node"],[6,"Combine"],[6,"Combineable"],[6,"ErrorReporting"],[6,"Resolvable"],[6,"LatticeDir"],[6,"UnifyKey"],[1,"Node"],[6,"SimplyUnifiable"],[6,"InferCtxtMethodsForSimplyUnifiableTypes"],[2,"deref_kind"],[6,"ast_node"],[6,"Typer"],[2,"InteriorSafety"],[2,"AliasableReason"],[1,"SeparateVecsPerParamSpace"],[6,"Subst"],[1,"Normalized"],[1,"CrateAnalysis"],[2,"ast_ty_to_ty_cache_entry"],[1,"CommonTypes"],[6,"ToPolyTraitRef"],[6,"AsPredicate"],[2,"ExprKind"],[1,"UnboxedClosureUpvar"],[2,"CopyImplementationError"],[6,"RegionEscape"],[6,"HasProjectionTypes"],[6,"ReferencesError"],[6,"TypeFoldable"],[6,"TypeFolder"],[1,"Config"],[6,"Repr"],[6,"UserString"],[6,"SnapshotVecDelegate"],[6,"Digest"],[1,"Target"],[1,"TargetOptions"]]};

searchIndex['rustc_resolve'] = {"items":[[0,"","rustc_resolve",""],[1,"DefModifiers","",""],[1,"CrateMap","",""],[11,"def_map","","",0],[11,"freevars","","",0],[11,"capture_mode_map","","",0],[11,"export_map","","",0],[11,"trait_map","","",0],[11,"external_exports","","",0],[11,"last_private_map","","",0],[11,"glob_map","","",0],[2,"MakeGlobMap","",""],[12,"Yes","","",1],[12,"No","","",1],[3,"resolve_crate","","Entry point to crate resolution."],[18,"PUBLIC","",""],[18,"IMPORTABLE","",""],[10,"hash","","",2],[10,"cmp","","",2],[10,"partial_cmp","","",2],[10,"lt","","",2],[10,"le","","",2],[10,"gt","","",2],[10,"ge","","",2],[10,"clone","","",2],[10,"eq","","",2],[10,"ne","","",2],[10,"fmt","","",2],[10,"empty","","Returns an empty set of flags.",2],[10,"all","","Returns the set containing all flags.",2],[10,"bits","","Returns the raw value of the flags currently stored.",2],[10,"from_bits","","Convert from underlying bit representation, unless that\nrepresentation contains bits that do not correspond to a flag.",2],[10,"from_bits_truncate","","Convert from underlying bit representation, dropping any bits\nthat do not correspond to flags.",2],[10,"is_empty","","Returns `true` if no flags are currently stored.",2],[10,"is_all","","Returns `true` if all flags are currently set.",2],[10,"intersects","","Returns `true` if there are flags common to both `self` and `other`.",2],[10,"contains","","Returns `true` all of the flags in `other` are contained within `self`.",2],[10,"insert","","Inserts the specified flags in-place.",2],[10,"remove","","Removes the specified flags in-place.",2],[10,"toggle","","Toggles the specified flags in-place.",2],[10,"bitor","","Returns the union of the two sets of flags.",2],[10,"bitxor","","Returns the left flags, but with all the right flags toggled.",2],[10,"bitand","","Returns the intersection between the two sets of flags.",2],[10,"sub","","Returns the set difference of the two sets of flags.",2],[10,"not","","Returns the complement of this set of flags.",2],[10,"eq","","",1],[10,"ne","","",1]],"paths":[[1,"CrateMap"],[2,"MakeGlobMap"],[1,"DefModifiers"]]};

searchIndex['rustc_borrowck'] = {"items":[[0,"","rustc_borrowck",""],[1,"FnPartsWithCFG","","This and a `ty::ctxt` is all you need to run the dataflow analyses\nused in the borrow checker."],[11,"fn_parts","","",0],[11,"cfg","","",0],[3,"check_crate","",""],[3,"build_borrowck_dataflow_data_for_fn","","Accessor for introspective clients inspecting `AnalysisData` and\nthe `BorrowckCtxt` itself , e.g. the flowgraph visualizer."],[10,"from_fn_like","","",0],[0,"graphviz","","This module provides linkage between rustc::middle::graph and\nlibgraphviz traits, specialized to attaching borrowck analysis\ndata to rendered labels."],[1,"DataflowLabeller","rustc_borrowck::graphviz",""],[11,"inner","","",1],[11,"variants","","",1],[11,"borrowck_ctxt","","",1],[11,"analysis_data","","",1],[2,"Variant","",""],[12,"Loans","","",2],[12,"Moves","","",2],[12,"Assigns","","",2],[10,"fmt","","",2],[10,"short_name","","",2],[10,"graph_id","","",1],[10,"node_id","","",1],[10,"node_label","","",1],[10,"edge_label","","",1],[10,"nodes","","",1],[10,"edges","","",1],[10,"source","","",1],[10,"target","","",1],[10,"open","rustc_back::archive","Opens an existing static archive",3],[10,"remove_file","","Removes a file from this archive",3],[10,"files","","Lists all files in an archive",3],[10,"extend","","Creates an `ArchiveBuilder` for adding files to this archive.",3],[10,"create","","Create a new static archive, ready for adding files.",4],[10,"add_native_library","","Adds all of the contents of a native library to this archive. This will\nsearch in the relevant locations for a library named `name`.",4],[10,"add_rlib","","Adds all of the contents of the rlib at the specified path to this\narchive.",4],[10,"add_file","","Adds an arbitrary file to this archive",4],[10,"update_symbols","","Indicate that the next call to `build` should updates all symbols in\nthe archive (run 'ar s' over it).",4],[10,"build","","Combine the provided files, rlibs, and native libraries into a single\n`Archive`.",4],[10,"eq","rustc_back::svh","",5],[10,"ne","","",5],[10,"ne","","",5],[10,"clone","","",5],[10,"clone_from","","",5],[10,"new","","",5],[10,"as_str","","",5],[10,"calculate","","",5],[10,"fmt","","",5],[10,"hash","rustc_back::svh::svh_visitor","",6],[10,"hash","","",7],[10,"hash","","",8],[10,"get_content","syntax::ast","",9],[10,"get_content","","",10],[10,"visit_mac","rustc_back::svh::svh_visitor","",11],[10,"visit_struct_def","","",11],[10,"visit_variant","","",11],[10,"visit_opt_lifetime_ref","","",11],[10,"visit_ident","","",11],[10,"visit_lifetime_ref","","",11],[10,"visit_lifetime_def","","",11],[10,"visit_expr","","",11],[10,"visit_stmt","","",11],[10,"visit_view_item","","",11],[10,"visit_foreign_item","","",11],[10,"visit_item","","",11],[10,"visit_mod","","",11],[10,"visit_decl","","",11],[10,"visit_ty","","",11],[10,"visit_generics","","",11],[10,"visit_fn","","",11],[10,"visit_ty_method","","",11],[10,"visit_trait_item","","",11],[10,"visit_struct_field","","",11],[10,"visit_explicit_self","","",11],[10,"visit_path","","",11],[10,"visit_block","","",11],[10,"visit_pat","","",11],[10,"visit_local","","",11],[10,"visit_arm","","",11],[10,"visit_name","","",11],[10,"visit_ident","","",11],[10,"visit_mod","","",11],[10,"visit_view_item","","",11],[10,"visit_foreign_item","","",11],[10,"visit_item","","",11],[10,"visit_local","","",11],[10,"visit_block","","",11],[10,"visit_stmt","","",11],[10,"visit_arm","","",11],[10,"visit_pat","","",11],[10,"visit_decl","","",11],[10,"visit_expr","","",11],[10,"visit_expr_post","","",11],[10,"visit_ty","","",11],[10,"visit_generics","","",11],[10,"visit_fn","","",11],[10,"visit_ty_method","","",11],[10,"visit_trait_item","","",11],[10,"visit_trait_ref","","",11],[10,"visit_ty_param_bound","","",11],[10,"visit_poly_trait_ref","","",11],[10,"visit_struct_def","","",11],[10,"visit_struct_field","","",11],[10,"visit_variant","","",11],[10,"visit_opt_lifetime_ref","","",11],[10,"visit_lifetime_bound","","",11],[10,"visit_lifetime_ref","","",11],[10,"visit_lifetime_def","","",11],[10,"visit_explicit_self","","",11],[10,"visit_mac","","",11],[10,"visit_path","","",11],[10,"visit_path_segment","","",11],[10,"visit_path_parameters","","",11],[10,"visit_assoc_type_binding","","",11],[10,"visit_attribute","","",11],[10,"tr_id","rustc::middle::astencode","Translates an internal id, meaning a node id that is known to refer to some part of the\nitem currently being inlined, such as a local variable or argument.  All naked node-ids\nthat appear in types have this property, since if something might refer to an external item\nwe would use a def-id to allow for the possibility that the item resides in another crate.",12],[10,"tr_def_id","","Translates an EXTERNAL def-id, converting the crate number from the one used in the encoded\ndata to the current crate numbers..  By external, I mean that it be translated to a\nreference to the item in its original crate, as opposed to being translated to a reference\nto the inlined version of the item.  This is typically, but not always, what you want,\nbecause most def-ids refer to external things like types or other fns that may or may not\nbe inlined.  Note that even when the inlined function is referencing itself recursively, we\nwould want `tr_def_id` for that reference--- conceptually the function calls the original,\nnon-inlined version, and trans deals with linking that recursive call to the inlined copy.",12],[10,"tr_intern_def_id","","Translates an INTERNAL def-id, meaning a def-id that is\nknown to refer to some part of the item currently being\ninlined.  In that case, we want to convert the def-id to\nrefer to the current crate and to the new, inlined node-id.",12],[10,"tr_span","","",12],[10,"tr_intern","syntax::ast","",13],[10,"tr","","",13],[10,"tr","core::option","",14],[10,"tr","syntax::codemap","",15],[10,"fold_block","rustc::middle::astencode","",16],[10,"fold_crate","","",16],[10,"fold_meta_items","","",16],[10,"fold_meta_item","","",16],[10,"fold_view_path","","",16],[10,"fold_view_item","","",16],[10,"fold_foreign_item","","",16],[10,"fold_item","","",16],[10,"fold_item_simple","","",16],[10,"fold_struct_field","","",16],[10,"fold_item_underscore","","",16],[10,"fold_fn_decl","","",16],[10,"fold_type_method","","",16],[10,"fold_method","","",16],[10,"fold_block","","",16],[10,"fold_stmt","","",16],[10,"fold_arm","","",16],[10,"fold_pat","","",16],[10,"fold_decl","","",16],[10,"fold_expr","","",16],[10,"fold_ty","","",16],[10,"fold_qpath","","",16],[10,"fold_ty_binding","","",16],[10,"fold_mod","","",16],[10,"fold_foreign_mod","","",16],[10,"fold_variant","","",16],[10,"fold_ident","","",16],[10,"fold_uint","","",16],[10,"fold_path","","",16],[10,"fold_path_parameters","","",16],[10,"fold_angle_bracketed_parameter_data","","",16],[10,"fold_parenthesized_parameter_data","","",16],[10,"fold_local","","",16],[10,"fold_mac","","",16],[10,"fold_explicit_self","","",16],[10,"fold_explicit_self_underscore","","",16],[10,"fold_lifetime","","",16],[10,"fold_lifetime_def","","",16],[10,"fold_attribute","","",16],[10,"fold_arg","","",16],[10,"fold_generics","","",16],[10,"fold_trait_ref","","",16],[10,"fold_poly_trait_ref","","",16],[10,"fold_struct_def","","",16],[10,"fold_lifetimes","","",16],[10,"fold_lifetime_defs","","",16],[10,"fold_ty_param","","",16],[10,"fold_ty_params","","",16],[10,"fold_tt","","",16],[10,"fold_tts","","",16],[10,"fold_token","","",16],[10,"fold_interpolated","","",16],[10,"fold_opt_lifetime","","",16],[10,"fold_variant_arg","","",16],[10,"fold_opt_bounds","","",16],[10,"fold_bounds","","",16],[10,"fold_ty_param_bound","","",16],[10,"fold_mt","","",16],[10,"fold_field","","",16],[10,"fold_where_clause","","",16],[10,"fold_where_predicate","","",16],[10,"fold_typedef","","",16],[10,"fold_associated_type","","",16],[10,"new_id","","",16],[10,"new_span","","",16],[10,"tr","rustc::middle::def","",17],[10,"tr","rustc::middle::ty","",18],[10,"tr","","",19],[10,"tr","rustc::middle::region","",20],[10,"tr","rustc::middle::ty","",21],[10,"tr","","",22],[10,"read_freevar_entry","rbml::reader","",23],[10,"read_capture_mode","","",23],[10,"tr","rustc::middle::ty","",24],[10,"tr","","",25],[10,"read_method_callee","rbml::reader","",23],[10,"tr","rustc::middle::ty","",26],[10,"read_vec_per_param_space","rbml::reader","",23],[10,"read_vtable_res_with_key","","",23],[10,"read_vtable_res","","",23],[10,"read_vtable_param_res","","",23],[10,"read_vtable_origin","","",23],[10,"ty_str_ctxt","rustc::metadata::encoder","",27],[10,"emit_closure_type","rbml::writer","",28],[10,"emit_method_origin","","",28],[10,"emit_ty","","",28],[10,"emit_tys","","",28],[10,"emit_trait_ref","","",28],[10,"emit_type_param_def","","",28],[10,"emit_predicate","","",28],[10,"emit_type_scheme","","",28],[10,"emit_existential_bounds","","",28],[10,"emit_builtin_bounds","","",28],[10,"emit_substs","","",28],[10,"emit_auto_adjustment","","",28],[10,"emit_autoref","","",28],[10,"emit_auto_deref_ref","","",28],[10,"emit_unsize_kind","","",28],[10,"tag","","",28],[10,"id","","",28],[10,"visit_id","rustc::middle::astencode","",29],[10,"as_int","rbml","",30],[10,"opt_child","","",30],[10,"read_ty_nodcx","rbml::reader","",23],[10,"read_tys_nodcx","","",23],[10,"read_substs_nodcx","","",23],[10,"read_method_origin","","",23],[10,"read_ty","","",23],[10,"read_tys","","",23],[10,"read_trait_ref","","",23],[10,"read_poly_trait_ref","","",23],[10,"read_type_param_def","","",23],[10,"read_predicate","","",23],[10,"read_type_scheme","","",23],[10,"read_existential_bounds","","",23],[10,"read_substs","","",23],[10,"read_auto_adjustment","","",23],[10,"read_auto_deref_ref","","",23],[10,"read_autoref","","",23],[10,"read_unsize_kind","","",23],[10,"read_unboxed_closure","","",23],[10,"convert_def_id","","Converts a def-id that appears in a type.  The correct\ntranslation will depend on what kind of def-id this is.\nThis is a subtle point: type definitions are not\ninlined into the current crate, so if the def-id names\na nominal type or type alias, then it should be\ntranslated to refer to the source crate.",23],[10,"graph_id","rustc::middle::cfg::graphviz","",31],[10,"node_id","","",31],[10,"node_label","","",31],[10,"edge_label","","",31],[10,"node_label","","",31],[10,"edge_label","","",31],[10,"nodes","","",31],[10,"edges","","",31],[10,"source","","",31],[10,"target","","",31],[10,"new","rustc::middle::cfg","",32],[10,"node_is_reachable","","",32],[10,"visit_item","rustc::middle::check_const","",33],[10,"visit_pat","","",33],[10,"visit_expr","","",33],[10,"visit_name","","",33],[10,"visit_ident","","",33],[10,"visit_mod","","",33],[10,"visit_view_item","","",33],[10,"visit_foreign_item","","",33],[10,"visit_item","","",33],[10,"visit_local","","",33],[10,"visit_block","","",33],[10,"visit_stmt","","",33],[10,"visit_arm","","",33],[10,"visit_pat","","",33],[10,"visit_decl","","",33],[10,"visit_expr","","",33],[10,"visit_expr_post","","",33],[10,"visit_ty","","",33],[10,"visit_generics","","",33],[10,"visit_fn","","",33],[10,"visit_ty_method","","",33],[10,"visit_trait_item","","",33],[10,"visit_trait_ref","","",33],[10,"visit_ty_param_bound","","",33],[10,"visit_poly_trait_ref","","",33],[10,"visit_struct_def","","",33],[10,"visit_struct_field","","",33],[10,"visit_variant","","",33],[10,"visit_opt_lifetime_ref","","",33],[10,"visit_lifetime_bound","","",33],[10,"visit_lifetime_ref","","",33],[10,"visit_lifetime_def","","",33],[10,"visit_explicit_self","","",33],[10,"visit_mac","","",33],[10,"visit_path","","",33],[10,"visit_path_segment","","",33],[10,"visit_path_parameters","","",33],[10,"visit_assoc_type_binding","","",33],[10,"visit_attribute","","",33],[10,"visit_item","rustc::middle::check_static_recursion","",34],[10,"visit_name","","",34],[10,"visit_ident","","",34],[10,"visit_mod","","",34],[10,"visit_view_item","","",34],[10,"visit_foreign_item","","",34],[10,"visit_item","","",34],[10,"visit_local","","",34],[10,"visit_block","","",34],[10,"visit_stmt","","",34],[10,"visit_arm","","",34],[10,"visit_pat","","",34],[10,"visit_decl","","",34],[10,"visit_expr","","",34],[10,"visit_expr_post","","",34],[10,"visit_ty","","",34],[10,"visit_generics","","",34],[10,"visit_fn","","",34],[10,"visit_ty_method","","",34],[10,"visit_trait_item","","",34],[10,"visit_trait_ref","","",34],[10,"visit_ty_param_bound","","",34],[10,"visit_poly_trait_ref","","",34],[10,"visit_struct_def","","",34],[10,"visit_struct_field","","",34],[10,"visit_variant","","",34],[10,"visit_opt_lifetime_ref","","",34],[10,"visit_lifetime_bound","","",34],[10,"visit_lifetime_ref","","",34],[10,"visit_lifetime_def","","",34],[10,"visit_explicit_self","","",34],[10,"visit_mac","","",34],[10,"visit_path","","",34],[10,"visit_path_segment","","",34],[10,"visit_path_parameters","","",34],[10,"visit_assoc_type_binding","","",34],[10,"visit_attribute","","",34],[10,"visit_item","","",35],[10,"visit_expr","","",35],[10,"visit_name","","",35],[10,"visit_ident","","",35],[10,"visit_mod","","",35],[10,"visit_view_item","","",35],[10,"visit_foreign_item","","",35],[10,"visit_item","","",35],[10,"visit_local","","",35],[10,"visit_block","","",35],[10,"visit_stmt","","",35],[10,"visit_arm","","",35],[10,"visit_pat","","",35],[10,"visit_decl","","",35],[10,"visit_expr","","",35],[10,"visit_expr_post","","",35],[10,"visit_ty","","",35],[10,"visit_generics","","",35],[10,"visit_fn","","",35],[10,"visit_ty_method","","",35],[10,"visit_trait_item","","",35],[10,"visit_trait_ref","","",35],[10,"visit_ty_param_bound","","",35],[10,"visit_poly_trait_ref","","",35],[10,"visit_struct_def","","",35],[10,"visit_struct_field","","",35],[10,"visit_variant","","",35],[10,"visit_opt_lifetime_ref","","",35],[10,"visit_lifetime_bound","","",35],[10,"visit_lifetime_ref","","",35],[10,"visit_lifetime_def","","",35],[10,"visit_explicit_self","","",35],[10,"visit_mac","","",35],[10,"visit_path","","",35],[10,"visit_path_segment","","",35],[10,"visit_path_parameters","","",35],[10,"visit_assoc_type_binding","","",35],[10,"visit_attribute","","",35],[10,"eq","rustc::middle::check_loop","",36],[10,"ne","","",36],[10,"ne","","",36],[10,"clone","","",36],[10,"clone_from","","",36],[10,"visit_item","","",37],[10,"visit_expr","","",37],[10,"visit_name","","",37],[10,"visit_ident","","",37],[10,"visit_mod","","",37],[10,"visit_view_item","","",37],[10,"visit_foreign_item","","",37],[10,"visit_item","","",37],[10,"visit_local","","",37],[10,"visit_block","","",37],[10,"visit_stmt","","",37],[10,"visit_arm","","",37],[10,"visit_pat","","",37],[10,"visit_decl","","",37],[10,"visit_expr","","",37],[10,"visit_expr_post","","",37],[10,"visit_ty","","",37],[10,"visit_generics","","",37],[10,"visit_fn","","",37],[10,"visit_ty_method","","",37],[10,"visit_trait_item","","",37],[10,"visit_trait_ref","","",37],[10,"visit_ty_param_bound","","",37],[10,"visit_poly_trait_ref","","",37],[10,"visit_struct_def","","",37],[10,"visit_struct_field","","",37],[10,"visit_variant","","",37],[10,"visit_opt_lifetime_ref","","",37],[10,"visit_lifetime_bound","","",37],[10,"visit_lifetime_ref","","",37],[10,"visit_lifetime_def","","",37],[10,"visit_explicit_self","","",37],[10,"visit_mac","","",37],[10,"visit_path","","",37],[10,"visit_path_segment","","",37],[10,"visit_path_parameters","","",37],[10,"visit_assoc_type_binding","","",37],[10,"visit_attribute","","",37],[10,"fmt","rustc::middle::check_match","",38],[10,"from_iter","","",38],[10,"eq","","",39],[10,"ne","","",39],[10,"ne","","",39],[10,"clone","","",39],[10,"clone_from","","",39],[10,"eq","","",40],[10,"ne","","",40],[10,"ne","","",40],[10,"clone","","",40],[10,"clone_from","","",40],[10,"visit_expr","","",41],[10,"visit_local","","",41],[10,"visit_fn","","",41],[10,"visit_name","","",41],[10,"visit_ident","","",41],[10,"visit_mod","","",41],[10,"visit_view_item","","",41],[10,"visit_foreign_item","","",41],[10,"visit_item","","",41],[10,"visit_local","","",41],[10,"visit_block","","",41],[10,"visit_stmt","","",41],[10,"visit_arm","","",41],[10,"visit_pat","","",41],[10,"visit_decl","","",41],[10,"visit_expr","","",41],[10,"visit_expr_post","","",41],[10,"visit_ty","","",41],[10,"visit_generics","","",41],[10,"visit_fn","","",41],[10,"visit_ty_method","","",41],[10,"visit_trait_item","","",41],[10,"visit_trait_ref","","",41],[10,"visit_ty_param_bound","","",41],[10,"visit_poly_trait_ref","","",41],[10,"visit_struct_def","","",41],[10,"visit_struct_field","","",41],[10,"visit_variant","","",41],[10,"visit_opt_lifetime_ref","","",41],[10,"visit_lifetime_bound","","",41],[10,"visit_lifetime_ref","","",41],[10,"visit_lifetime_def","","",41],[10,"visit_explicit_self","","",41],[10,"visit_mac","","",41],[10,"visit_path","","",41],[10,"visit_path_segment","","",41],[10,"visit_path_parameters","","",41],[10,"visit_assoc_type_binding","","",41],[10,"visit_attribute","","",41],[10,"new","","",42],[10,"fold_pat","","",42],[10,"fold_crate","","",42],[10,"fold_meta_items","","",42],[10,"fold_meta_item","","",42],[10,"fold_view_path","","",42],[10,"fold_view_item","","",42],[10,"fold_foreign_item","","",42],[10,"fold_item","","",42],[10,"fold_item_simple","","",42],[10,"fold_struct_field","","",42],[10,"fold_item_underscore","","",42],[10,"fold_fn_decl","","",42],[10,"fold_type_method","","",42],[10,"fold_method","","",42],[10,"fold_block","","",42],[10,"fold_stmt","","",42],[10,"fold_arm","","",42],[10,"fold_pat","","",42],[10,"fold_decl","","",42],[10,"fold_expr","","",42],[10,"fold_ty","","",42],[10,"fold_qpath","","",42],[10,"fold_ty_binding","","",42],[10,"fold_mod","","",42],[10,"fold_foreign_mod","","",42],[10,"fold_variant","","",42],[10,"fold_ident","","",42],[10,"fold_uint","","",42],[10,"fold_path","","",42],[10,"fold_path_parameters","","",42],[10,"fold_angle_bracketed_parameter_data","","",42],[10,"fold_parenthesized_parameter_data","","",42],[10,"fold_local","","",42],[10,"fold_mac","","",42],[10,"fold_explicit_self","","",42],[10,"fold_explicit_self_underscore","","",42],[10,"fold_lifetime","","",42],[10,"fold_lifetime_def","","",42],[10,"fold_attribute","","",42],[10,"fold_arg","","",42],[10,"fold_generics","","",42],[10,"fold_trait_ref","","",42],[10,"fold_poly_trait_ref","","",42],[10,"fold_struct_def","","",42],[10,"fold_lifetimes","","",42],[10,"fold_lifetime_defs","","",42],[10,"fold_ty_param","","",42],[10,"fold_ty_params","","",42],[10,"fold_tt","","",42],[10,"fold_tts","","",42],[10,"fold_token","","",42],[10,"fold_interpolated","","",42],[10,"fold_opt_lifetime","","",42],[10,"fold_variant_arg","","",42],[10,"fold_opt_bounds","","",42],[10,"fold_bounds","","",42],[10,"fold_ty_param_bound","","",42],[10,"fold_mt","","",42],[10,"fold_field","","",42],[10,"fold_where_clause","","",42],[10,"fold_where_predicate","","",42],[10,"fold_typedef","","",42],[10,"fold_associated_type","","",42],[10,"new_id","","",42],[10,"new_span","","",42],[10,"matched_pat","","",43],[10,"consume","","",43],[10,"consume_pat","","",43],[10,"borrow","","",43],[10,"decl_without_init","","",43],[10,"mutate","","",43],[10,"visit_pat","","",44],[10,"visit_name","","",44],[10,"visit_ident","","",44],[10,"visit_mod","","",44],[10,"visit_view_item","","",44],[10,"visit_foreign_item","","",44],[10,"visit_item","","",44],[10,"visit_local","","",44],[10,"visit_block","","",44],[10,"visit_stmt","","",44],[10,"visit_arm","","",44],[10,"visit_pat","","",44],[10,"visit_decl","","",44],[10,"visit_expr","","",44],[10,"visit_expr_post","","",44],[10,"visit_ty","","",44],[10,"visit_generics","","",44],[10,"visit_fn","","",44],[10,"visit_ty_method","","",44],[10,"visit_trait_item","","",44],[10,"visit_trait_ref","","",44],[10,"visit_ty_param_bound","","",44],[10,"visit_poly_trait_ref","","",44],[10,"visit_struct_def","","",44],[10,"visit_struct_field","","",44],[10,"visit_variant","","",44],[10,"visit_opt_lifetime_ref","","",44],[10,"visit_lifetime_bound","","",44],[10,"visit_lifetime_ref","","",44],[10,"visit_lifetime_def","","",44],[10,"visit_explicit_self","","",44],[10,"visit_mac","","",44],[10,"visit_path","","",44],[10,"visit_path_segment","","",44],[10,"visit_path_parameters","","",44],[10,"visit_assoc_type_binding","","",44],[10,"visit_attribute","","",44],[10,"visit_fn","rustc::middle::check_rvalues","",45],[10,"visit_name","","",45],[10,"visit_ident","","",45],[10,"visit_mod","","",45],[10,"visit_view_item","","",45],[10,"visit_foreign_item","","",45],[10,"visit_item","","",45],[10,"visit_local","","",45],[10,"visit_block","","",45],[10,"visit_stmt","","",45],[10,"visit_arm","","",45],[10,"visit_pat","","",45],[10,"visit_decl","","",45],[10,"visit_expr","","",45],[10,"visit_expr_post","","",45],[10,"visit_ty","","",45],[10,"visit_generics","","",45],[10,"visit_fn","","",45],[10,"visit_ty_method","","",45],[10,"visit_trait_item","","",45],[10,"visit_trait_ref","","",45],[10,"visit_ty_param_bound","","",45],[10,"visit_poly_trait_ref","","",45],[10,"visit_struct_def","","",45],[10,"visit_struct_field","","",45],[10,"visit_variant","","",45],[10,"visit_opt_lifetime_ref","","",45],[10,"visit_lifetime_bound","","",45],[10,"visit_lifetime_ref","","",45],[10,"visit_lifetime_def","","",45],[10,"visit_explicit_self","","",45],[10,"visit_mac","","",45],[10,"visit_path","","",45],[10,"visit_path_segment","","",45],[10,"visit_path_parameters","","",45],[10,"visit_assoc_type_binding","","",45],[10,"visit_attribute","","",45],[10,"consume","","",46],[10,"matched_pat","","",46],[10,"consume_pat","","",46],[10,"borrow","","",46],[10,"decl_without_init","","",46],[10,"mutate","","",46],[10,"eq","rustc::middle::check_static","",47],[10,"ne","","",47],[10,"ne","","",47],[10,"assert_receiver_is_total_eq","","",47],[10,"visit_item","","",48],[10,"visit_expr","","This method is used to enforce the constraints on\nimmutable static items. It walks through the *value*\nof the item walking down the expression and evaluating\nevery nested expression. if the expression is not part\nof a static item, this method does nothing but walking\ndown through it.",48],[10,"visit_name","","",48],[10,"visit_ident","","",48],[10,"visit_mod","","",48],[10,"visit_view_item","","",48],[10,"visit_foreign_item","","",48],[10,"visit_item","","",48],[10,"visit_local","","",48],[10,"visit_block","","",48],[10,"visit_stmt","","",48],[10,"visit_arm","","",48],[10,"visit_pat","","",48],[10,"visit_decl","","",48],[10,"visit_expr","","",48],[10,"visit_expr_post","","",48],[10,"visit_ty","","",48],[10,"visit_generics","","",48],[10,"visit_fn","","",48],[10,"visit_ty_method","","",48],[10,"visit_trait_item","","",48],[10,"visit_trait_ref","","",48],[10,"visit_ty_param_bound","","",48],[10,"visit_poly_trait_ref","","",48],[10,"visit_struct_def","","",48],[10,"visit_struct_field","","",48],[10,"visit_variant","","",48],[10,"visit_opt_lifetime_ref","","",48],[10,"visit_lifetime_bound","","",48],[10,"visit_lifetime_ref","","",48],[10,"visit_lifetime_def","","",48],[10,"visit_explicit_self","","",48],[10,"visit_mac","","",48],[10,"visit_path","","",48],[10,"visit_path_segment","","",48],[10,"visit_path_parameters","","",48],[10,"visit_assoc_type_binding","","",48],[10,"visit_attribute","","",48],[10,"visit_item","","",49],[10,"visit_name","","",49],[10,"visit_ident","","",49],[10,"visit_mod","","",49],[10,"visit_view_item","","",49],[10,"visit_foreign_item","","",49],[10,"visit_item","","",49],[10,"visit_local","","",49],[10,"visit_block","","",49],[10,"visit_stmt","","",49],[10,"visit_arm","","",49],[10,"visit_pat","","",49],[10,"visit_decl","","",49],[10,"visit_expr","","",49],[10,"visit_expr_post","","",49],[10,"visit_ty","","",49],[10,"visit_generics","","",49],[10,"visit_fn","","",49],[10,"visit_ty_method","","",49],[10,"visit_trait_item","","",49],[10,"visit_trait_ref","","",49],[10,"visit_ty_param_bound","","",49],[10,"visit_poly_trait_ref","","",49],[10,"visit_struct_def","","",49],[10,"visit_struct_field","","",49],[10,"visit_variant","","",49],[10,"visit_opt_lifetime_ref","","",49],[10,"visit_lifetime_bound","","",49],[10,"visit_lifetime_ref","","",49],[10,"visit_lifetime_def","","",49],[10,"visit_explicit_self","","",49],[10,"visit_mac","","",49],[10,"visit_path","","",49],[10,"visit_path_segment","","",49],[10,"visit_path_parameters","","",49],[10,"visit_assoc_type_binding","","",49],[10,"visit_attribute","","",49],[10,"consume","","",50],[10,"borrow","","",50],[10,"decl_without_init","","",50],[10,"mutate","","",50],[10,"matched_pat","","",50],[10,"consume_pat","","",50],[10,"visit_expr_post","rustc::middle::const_eval","",51],[10,"visit_name","","",51],[10,"visit_ident","","",51],[10,"visit_mod","","",51],[10,"visit_view_item","","",51],[10,"visit_foreign_item","","",51],[10,"visit_item","","",51],[10,"visit_local","","",51],[10,"visit_block","","",51],[10,"visit_stmt","","",51],[10,"visit_arm","","",51],[10,"visit_pat","","",51],[10,"visit_decl","","",51],[10,"visit_expr","","",51],[10,"visit_expr_post","","",51],[10,"visit_ty","","",51],[10,"visit_generics","","",51],[10,"visit_fn","","",51],[10,"visit_ty_method","","",51],[10,"visit_trait_item","","",51],[10,"visit_trait_ref","","",51],[10,"visit_ty_param_bound","","",51],[10,"visit_poly_trait_ref","","",51],[10,"visit_struct_def","","",51],[10,"visit_struct_field","","",51],[10,"visit_variant","","",51],[10,"visit_opt_lifetime_ref","","",51],[10,"visit_lifetime_bound","","",51],[10,"visit_lifetime_ref","","",51],[10,"visit_lifetime_def","","",51],[10,"visit_explicit_self","","",51],[10,"visit_mac","","",51],[10,"visit_path","","",51],[10,"visit_path_segment","","",51],[10,"visit_path_parameters","","",51],[10,"visit_assoc_type_binding","","",51],[10,"visit_attribute","","",51],[10,"eq","","",52],[10,"ne","","",52],[10,"ne","","",52],[10,"clone","","",52],[10,"clone_from","","",52],[10,"fmt","rustc::middle::dataflow","",53],[10,"clone","","",54],[10,"clone_from","","",54],[10,"pre","","",54],[10,"pre","","",54],[10,"post","","",54],[10,"new","","",54],[10,"add_gen","","Indicates that `id` generates `bit`",54],[10,"add_kill","","Indicates that `id` kills `bit`",54],[10,"each_bit_on_entry","","Iterates through each bit that is set on entry to `id`.\nOnly useful after `propagate()` has been called.",54],[10,"each_bit_for_node","","Iterates through each bit that is set on entry/exit to `cfgidx`.\nOnly useful after `propagate()` has been called.",54],[10,"each_gen_bit","","Iterates through each bit in the gen set for `id`.",54],[10,"add_kills_from_flow_exits","","Whenever you have a `break` or `continue` statement, flow\nexits through any number of enclosing scopes on its way to\nthe new destination. This function infers the kill bits of\nthose control operators based on the kill bits associated\nwith those scopes.",54],[10,"propagate","","Performs the data flow analysis.",54],[10,"join","","",55],[10,"join","","",56],[10,"visit_struct_def","rustc::middle::dead","",57],[10,"visit_expr","","",57],[10,"visit_pat","","",57],[10,"visit_path","","",57],[10,"visit_item","","",57],[10,"visit_name","","",57],[10,"visit_ident","","",57],[10,"visit_mod","","",57],[10,"visit_view_item","","",57],[10,"visit_foreign_item","","",57],[10,"visit_item","","",57],[10,"visit_local","","",57],[10,"visit_block","","",57],[10,"visit_stmt","","",57],[10,"visit_arm","","",57],[10,"visit_pat","","",57],[10,"visit_decl","","",57],[10,"visit_expr","","",57],[10,"visit_expr_post","","",57],[10,"visit_ty","","",57],[10,"visit_generics","","",57],[10,"visit_fn","","",57],[10,"visit_ty_method","","",57],[10,"visit_trait_item","","",57],[10,"visit_trait_ref","","",57],[10,"visit_ty_param_bound","","",57],[10,"visit_poly_trait_ref","","",57],[10,"visit_struct_def","","",57],[10,"visit_struct_field","","",57],[10,"visit_variant","","",57],[10,"visit_opt_lifetime_ref","","",57],[10,"visit_lifetime_bound","","",57],[10,"visit_lifetime_ref","","",57],[10,"visit_lifetime_def","","",57],[10,"visit_explicit_self","","",57],[10,"visit_mac","","",57],[10,"visit_path","","",57],[10,"visit_path_segment","","",57],[10,"visit_path_parameters","","",57],[10,"visit_assoc_type_binding","","",57],[10,"visit_attribute","","",57],[10,"visit_item","","",58],[10,"visit_fn","","",58],[10,"visit_name","","",58],[10,"visit_ident","","",58],[10,"visit_mod","","",58],[10,"visit_view_item","","",58],[10,"visit_foreign_item","","",58],[10,"visit_item","","",58],[10,"visit_local","","",58],[10,"visit_block","","",58],[10,"visit_stmt","","",58],[10,"visit_arm","","",58],[10,"visit_pat","","",58],[10,"visit_decl","","",58],[10,"visit_expr","","",58],[10,"visit_expr_post","","",58],[10,"visit_ty","","",58],[10,"visit_generics","","",58],[10,"visit_fn","","",58],[10,"visit_ty_method","","",58],[10,"visit_trait_item","","",58],[10,"visit_trait_ref","","",58],[10,"visit_ty_param_bound","","",58],[10,"visit_poly_trait_ref","","",58],[10,"visit_struct_def","","",58],[10,"visit_struct_field","","",58],[10,"visit_variant","","",58],[10,"visit_opt_lifetime_ref","","",58],[10,"visit_lifetime_bound","","",58],[10,"visit_lifetime_ref","","",58],[10,"visit_lifetime_def","","",58],[10,"visit_explicit_self","","",58],[10,"visit_mac","","",58],[10,"visit_path","","",58],[10,"visit_path_segment","","",58],[10,"visit_path_parameters","","",58],[10,"visit_assoc_type_binding","","",58],[10,"visit_attribute","","",58],[10,"visit_item","","",59],[10,"visit_foreign_item","","",59],[10,"visit_fn","","",59],[10,"visit_struct_field","","",59],[10,"visit_trait_item","","",59],[10,"visit_name","","",59],[10,"visit_ident","","",59],[10,"visit_mod","","",59],[10,"visit_view_item","","",59],[10,"visit_foreign_item","","",59],[10,"visit_item","","",59],[10,"visit_local","","",59],[10,"visit_block","","",59],[10,"visit_stmt","","",59],[10,"visit_arm","","",59],[10,"visit_pat","","",59],[10,"visit_decl","","",59],[10,"visit_expr","","",59],[10,"visit_expr_post","","",59],[10,"visit_ty","","",59],[10,"visit_generics","","",59],[10,"visit_fn","","",59],[10,"visit_ty_method","","",59],[10,"visit_trait_item","","",59],[10,"visit_trait_ref","","",59],[10,"visit_ty_param_bound","","",59],[10,"visit_poly_trait_ref","","",59],[10,"visit_struct_def","","",59],[10,"visit_struct_field","","",59],[10,"visit_variant","","",59],[10,"visit_opt_lifetime_ref","","",59],[10,"visit_lifetime_bound","","",59],[10,"visit_lifetime_ref","","",59],[10,"visit_lifetime_def","","",59],[10,"visit_explicit_self","","",59],[10,"visit_mac","","",59],[10,"visit_path","","",59],[10,"visit_path_segment","","",59],[10,"visit_path_parameters","","",59],[10,"visit_assoc_type_binding","","",59],[10,"visit_attribute","","",59],[10,"fmt","rustc::middle::def","",17],[10,"hash","","",17],[10,"decode","","",17],[10,"encode","","",17],[10,"assert_receiver_is_total_eq","","",17],[10,"eq","","",17],[10,"ne","","",17],[10,"ne","","",17],[10,"clone","","",17],[10,"clone_from","","",17],[10,"fmt","","",60],[10,"hash","","",60],[10,"decode","","",60],[10,"encode","","",60],[10,"assert_receiver_is_total_eq","","",60],[10,"eq","","",60],[10,"ne","","",60],[10,"ne","","",60],[10,"clone","","",60],[10,"clone_from","","",60],[10,"fmt","","",61],[10,"hash","","",61],[10,"decode","","",61],[10,"encode","","",61],[10,"assert_receiver_is_total_eq","","",61],[10,"eq","","",61],[10,"ne","","",61],[10,"ne","","",61],[10,"clone","","",61],[10,"clone_from","","",61],[10,"map","","",60],[10,"def_id","","",61],[10,"eq","","",62],[10,"ne","","",62],[10,"ne","","",62],[10,"assert_receiver_is_total_eq","","",62],[10,"clone","","",62],[10,"clone_from","","",62],[10,"from_explicit_self_category","","",62],[10,"def_id","","",17],[10,"variant_def_ids","","",17],[10,"eq","rustc::middle::effect","",63],[10,"ne","","",63],[10,"ne","","",63],[10,"visit_fn","","",64],[10,"visit_block","","",64],[10,"visit_expr","","",64],[10,"visit_name","","",64],[10,"visit_ident","","",64],[10,"visit_mod","","",64],[10,"visit_view_item","","",64],[10,"visit_foreign_item","","",64],[10,"visit_item","","",64],[10,"visit_local","","",64],[10,"visit_block","","",64],[10,"visit_stmt","","",64],[10,"visit_arm","","",64],[10,"visit_pat","","",64],[10,"visit_decl","","",64],[10,"visit_expr","","",64],[10,"visit_expr_post","","",64],[10,"visit_ty","","",64],[10,"visit_generics","","",64],[10,"visit_fn","","",64],[10,"visit_ty_method","","",64],[10,"visit_trait_item","","",64],[10,"visit_trait_ref","","",64],[10,"visit_ty_param_bound","","",64],[10,"visit_poly_trait_ref","","",64],[10,"visit_struct_def","","",64],[10,"visit_struct_field","","",64],[10,"visit_variant","","",64],[10,"visit_opt_lifetime_ref","","",64],[10,"visit_lifetime_bound","","",64],[10,"visit_lifetime_ref","","",64],[10,"visit_lifetime_def","","",64],[10,"visit_explicit_self","","",64],[10,"visit_mac","","",64],[10,"visit_path","","",64],[10,"visit_path_segment","","",64],[10,"visit_path_parameters","","",64],[10,"visit_assoc_type_binding","","",64],[10,"visit_attribute","","",64],[10,"visit_item","rustc::middle::entry","",65],[10,"visit_name","","",65],[10,"visit_ident","","",65],[10,"visit_mod","","",65],[10,"visit_view_item","","",65],[10,"visit_foreign_item","","",65],[10,"visit_item","","",65],[10,"visit_local","","",65],[10,"visit_block","","",65],[10,"visit_stmt","","",65],[10,"visit_arm","","",65],[10,"visit_pat","","",65],[10,"visit_decl","","",65],[10,"visit_expr","","",65],[10,"visit_expr_post","","",65],[10,"visit_ty","","",65],[10,"visit_generics","","",65],[10,"visit_fn","","",65],[10,"visit_ty_method","","",65],[10,"visit_trait_item","","",65],[10,"visit_trait_ref","","",65],[10,"visit_ty_param_bound","","",65],[10,"visit_poly_trait_ref","","",65],[10,"visit_struct_def","","",65],[10,"visit_struct_field","","",65],[10,"visit_variant","","",65],[10,"visit_opt_lifetime_ref","","",65],[10,"visit_lifetime_bound","","",65],[10,"visit_lifetime_ref","","",65],[10,"visit_lifetime_def","","",65],[10,"visit_explicit_self","","",65],[10,"visit_mac","","",65],[10,"visit_path","","",65],[10,"visit_path_segment","","",65],[10,"visit_path_parameters","","",65],[10,"visit_assoc_type_binding","","",65],[10,"visit_attribute","","",65],[10,"fmt","rustc::middle::expr_use_visitor","",66],[10,"eq","","",66],[10,"ne","","",66],[10,"ne","","",66],[10,"fmt","","",67],[10,"eq","","",67],[10,"ne","","",67],[10,"ne","","",67],[10,"fmt","","",68],[10,"eq","","",68],[10,"ne","","",68],[10,"ne","","",68],[10,"fmt","","",69],[10,"eq","","",69],[10,"ne","","",69],[10,"ne","","",69],[10,"fmt","","",70],[10,"eq","","",70],[10,"ne","","",70],[10,"ne","","",70],[10,"fmt","","",71],[10,"eq","","",71],[10,"ne","","",71],[10,"ne","","",71],[10,"new","","",72],[10,"walk_fn","","",72],[10,"consume_expr","","",72],[10,"walk_expr","","",72],[10,"hash","rustc::middle::fast_reject","",73],[10,"assert_receiver_is_total_eq","","",73],[10,"eq","","",73],[10,"ne","","",73],[10,"ne","","",73],[10,"clone","","",73],[10,"clone_from","","",73],[10,"fmt","rustc::middle::graph","",74],[10,"fmt","","",75],[10,"eq","","",75],[10,"ne","","",75],[10,"ne","","",75],[10,"clone","","",75],[10,"clone_from","","",75],[10,"fmt","","",76],[10,"eq","","",76],[10,"ne","","",76],[10,"ne","","",76],[10,"fmt","","",77],[10,"node_id","","Returns unique id (unique with respect to the graph holding associated node).",75],[10,"edge_id","","Returns unique id (unique with respect to the graph holding associated edge).",76],[10,"new","","",78],[10,"with_capacity","","",78],[10,"all_nodes","","",78],[10,"all_edges","","",78],[10,"next_node_index","","",78],[10,"add_node","","",78],[10,"mut_node_data","","",78],[10,"node_data","","",78],[10,"node","","",78],[10,"next_edge_index","","",78],[10,"add_edge","","",78],[10,"mut_edge_data","","",78],[10,"edge_data","","",78],[10,"edge","","",78],[10,"first_adjacent","","Accesses the index of the first edge adjacent to `node`.\nThis is useful if you wish to modify the graph while walking\nthe linked list of edges.",78],[10,"next_adjacent","","Accesses the next edge in a given direction.\nThis is useful if you wish to modify the graph while walking\nthe linked list of edges.",78],[10,"each_node","","Iterates over all edges defined in the graph.",78],[10,"each_edge","","Iterates over all edges defined in the graph",78],[10,"each_outgoing_edge","","Iterates over all outgoing edges from the node `from`",78],[10,"each_incoming_edge","","Iterates over all incoming edges to the node `target`",78],[10,"each_adjacent_edge","","Iterates over all edges adjacent to the node `node`\nin the direction `dir` (either `Outgoing` or `Incoming)",78],[10,"iterate_until_fixed_point","","",78],[10,"depth_traverse","","",78],[10,"next","","",79],[10,"size_hint","","",79],[10,"source","","",74],[10,"target","","",74],[10,"visit_fn","rustc::middle::intrinsicck","",80],[10,"visit_expr","","",80],[10,"visit_name","","",80],[10,"visit_ident","","",80],[10,"visit_mod","","",80],[10,"visit_view_item","","",80],[10,"visit_foreign_item","","",80],[10,"visit_item","","",80],[10,"visit_local","","",80],[10,"visit_block","","",80],[10,"visit_stmt","","",80],[10,"visit_arm","","",80],[10,"visit_pat","","",80],[10,"visit_decl","","",80],[10,"visit_expr","","",80],[10,"visit_expr_post","","",80],[10,"visit_ty","","",80],[10,"visit_generics","","",80],[10,"visit_fn","","",80],[10,"visit_ty_method","","",80],[10,"visit_trait_item","","",80],[10,"visit_trait_ref","","",80],[10,"visit_ty_param_bound","","",80],[10,"visit_poly_trait_ref","","",80],[10,"visit_struct_def","","",80],[10,"visit_struct_field","","",80],[10,"visit_variant","","",80],[10,"visit_opt_lifetime_ref","","",80],[10,"visit_lifetime_bound","","",80],[10,"visit_lifetime_ref","","",80],[10,"visit_lifetime_def","","",80],[10,"visit_explicit_self","","",80],[10,"visit_mac","","",80],[10,"visit_path","","",80],[10,"visit_path_segment","","",80],[10,"visit_path_parameters","","",80],[10,"visit_assoc_type_binding","","",80],[10,"visit_attribute","","",80],[10,"repr","rustc::middle::ty","",81],[10,"get_ref","rustc::middle::infer::coercion","",82],[10,"tys","","",82],[10,"subtype","","",82],[10,"unpack_actual_value","","",82],[10,"coerce_borrowed_pointer","","",82],[10,"coerce_borrowed_fn","","",82],[10,"coerce_unsafe_ptr","","",82],[10,"combine","alloc::rc","",83],[10,"combine","rustc::middle::ty","",84],[10,"combine","","",85],[10,"combine","","",86],[10,"clone","rustc::middle::infer::combine","",87],[10,"clone_from","","",87],[10,"switch_expected","","",87],[10,"instantiate","","",87],[10,"tcx","","",88],[10,"fold_ty","","",88],[10,"fold_region","","",88],[10,"enter_region_binder","","",88],[10,"exit_region_binder","","",88],[10,"fold_ty","","",88],[10,"fold_mt","","",88],[10,"fold_trait_ref","","",88],[10,"fold_substs","","",88],[10,"fold_fn_sig","","",88],[10,"fold_output","","",88],[10,"fold_bare_fn_ty","","",88],[10,"fold_closure_ty","","",88],[10,"fold_region","","",88],[10,"fold_trait_store","","",88],[10,"fold_existential_bounds","","",88],[10,"fold_autoref","","",88],[10,"fold_item_substs","","",88],[10,"infcx","rustc::middle::infer::equate","",89],[10,"tag","","",89],[10,"a_is_expected","","",89],[10,"trace","","",89],[10,"equate","","",89],[10,"sub","","",89],[10,"lub","","",89],[10,"glb","","",89],[10,"contratys","","",89],[10,"contraregions","","",89],[10,"regions","","",89],[10,"mts","","",89],[10,"unsafeties","","",89],[10,"oncenesses","","",89],[10,"builtin_bounds","","",89],[10,"tys","","",89],[10,"binders","","",89],[10,"tcx","","",89],[10,"tps","","",89],[10,"substs","","",89],[10,"substs_variances","","",89],[10,"bare_fn_tys","","",89],[10,"closure_tys","","",89],[10,"fn_sigs","","",89],[10,"args","","",89],[10,"abi","","",89],[10,"projection_tys","","",89],[10,"projection_predicates","","",89],[10,"projection_bounds","","",89],[10,"existential_bounds","","",89],[10,"trait_stores","","",89],[10,"trait_refs","","",89],[10,"report_region_errors","rustc::middle::infer","",90],[10,"process_errors","","",90],[10,"report_type_error","","",90],[10,"report_and_explain_type_error","","",90],[10,"values_str","","Returns a string of the form \"expected `{}`, found `{}`\", or None if this is a derived\nerror.",90],[10,"expected_found_str","","",90],[10,"report_param_bound_failure","","",90],[10,"report_concrete_failure","","",90],[10,"report_sub_sup_conflict","","",90],[10,"report_sup_sup_conflict","","",90],[10,"report_processed_errors","","",90],[10,"give_suggestion","","",90],[10,"give_expl_lifetime_param","","",90],[10,"report_inference_failure","","",90],[10,"note_region_origin","","",90],[10,"resolve","alloc::rc","",83],[10,"contains_error","","",83],[10,"resolve","rustc::middle::ty","",91],[10,"contains_error","","",91],[10,"infcx","rustc::middle::infer::glb","",92],[10,"tag","","",92],[10,"a_is_expected","","",92],[10,"trace","","",92],[10,"equate","","",92],[10,"sub","","",92],[10,"lub","","",92],[10,"glb","","",92],[10,"mts","","",92],[10,"contratys","","",92],[10,"unsafeties","","",92],[10,"oncenesses","","",92],[10,"builtin_bounds","","",92],[10,"regions","","",92],[10,"contraregions","","",92],[10,"tys","","",92],[10,"binders","","",92],[10,"tcx","","",92],[10,"tps","","",92],[10,"substs","","",92],[10,"substs_variances","","",92],[10,"bare_fn_tys","","",92],[10,"closure_tys","","",92],[10,"fn_sigs","","",92],[10,"args","","",92],[10,"abi","","",92],[10,"projection_tys","","",92],[10,"projection_predicates","","",92],[10,"projection_bounds","","",92],[10,"existential_bounds","","",92],[10,"trait_stores","","",92],[10,"trait_refs","","",92],[10,"tainted_regions","rustc::middle::infer","",90],[10,"region_vars_confined_to_snapshot","","Returns the set of region variables that do not affect any\ntypes/regions which existed before `snapshot` was\nstarted. This is used in the sub/lub/glb computations. The\nidea here is that when we are computing lub/glb of two\nregions, we sometimes create intermediate region variables.\nThose region variables may touch some of the skolemized or\nother \"forbidden\" regions we created to replace bound\nregions, but they don't really represent an \"external\"\nconstraint.",90],[10,"relate_bound","rustc::middle::infer::lub","",93],[10,"relate_bound","rustc::middle::infer::glb","",92],[10,"infcx","rustc::middle::infer::lub","",93],[10,"tag","","",93],[10,"a_is_expected","","",93],[10,"trace","","",93],[10,"equate","","",93],[10,"sub","","",93],[10,"lub","","",93],[10,"glb","","",93],[10,"mts","","",93],[10,"contratys","","",93],[10,"unsafeties","","",93],[10,"oncenesses","","",93],[10,"builtin_bounds","","",93],[10,"contraregions","","",93],[10,"regions","","",93],[10,"tys","","",93],[10,"binders","","",93],[10,"tcx","","",93],[10,"tps","","",93],[10,"substs","","",93],[10,"substs_variances","","",93],[10,"bare_fn_tys","","",93],[10,"closure_tys","","",93],[10,"fn_sigs","","",93],[10,"args","","",93],[10,"abi","","",93],[10,"projection_tys","","",93],[10,"projection_predicates","","",93],[10,"projection_bounds","","",93],[10,"existential_bounds","","",93],[10,"trait_stores","","",93],[10,"trait_refs","","",93],[10,"fmt","rustc::middle::infer::region_inference::graphviz","",94],[10,"assert_receiver_is_total_eq","","",94],[10,"eq","","",94],[10,"ne","","",94],[10,"ne","","",94],[10,"hash","","",94],[10,"clone","","",94],[10,"clone_from","","",94],[10,"graph_id","","",95],[10,"node_id","","",95],[10,"node_label","","",95],[10,"edge_label","","",95],[10,"node_label","","",95],[10,"edge_label","","",95],[10,"nodes","","",95],[10,"edges","","",95],[10,"source","","",95],[10,"target","","",95],[10,"fmt","rustc::middle::infer::region_inference","",96],[10,"hash","","",96],[10,"assert_receiver_is_total_eq","","",96],[10,"eq","","",96],[10,"ne","","",96],[10,"ne","","",96],[10,"clone","","",96],[10,"clone_from","","",96],[10,"hash","","",97],[10,"assert_receiver_is_total_eq","","",97],[10,"eq","","",97],[10,"ne","","",97],[10,"ne","","",97],[10,"eq","","",98],[10,"ne","","",98],[10,"ne","","",98],[10,"eq","","",99],[10,"ne","","",99],[10,"ne","","",99],[10,"fmt","","",100],[10,"clone","","",100],[10,"clone_from","","",100],[10,"fmt","","",101],[10,"clone","","",101],[10,"clone_from","","",101],[10,"contains","","",101],[10,"push","","",101],[10,"fmt","","",102],[10,"new","","",103],[10,"start_snapshot","","",103],[10,"commit","","",103],[10,"rollback_to","","",103],[10,"num_vars","","",103],[10,"new_region_var","","",103],[10,"new_skolemized","","Creates a new skolemized region. Skolemized regions are fresh\nregions used when performing higher-ranked computations. They\nmust be used in a very particular way and are never supposed\nto \"escape\" out into error messages or the code at large.",103],[10,"new_bound","","",103],[10,"add_given","","",103],[10,"make_eqregion","","",103],[10,"make_subregion","","",103],[10,"verify_param_bound","","",103],[10,"lub_regions","","",103],[10,"glb_regions","","",103],[10,"resolve_var","","",103],[10,"combine_vars","","",103],[10,"vars_created_since_snapshot","","",103],[10,"tainted","","Computes all regions that have been related to `r0` in any way since the mark `mark` was\nmade---`r0` itself will be the first entry. This is used when checking whether skolemized\nregions are being improperly related to other regions.",103],[10,"resolve_regions","","This function performs the actual region resolution.  It must be\ncalled after all constraints have been added.  It performs a\nfixed-point iteration to find region values which satisfy all\nconstraints, assuming such values can be found; if they cannot,\nerrors are reported.",103],[10,"fmt","","",104],[10,"eq","","",104],[10,"ne","","",104],[10,"ne","","",104],[10,"repr","","",96],[10,"repr","","",105],[10,"repr","","",106],[10,"repr","","",107],[10,"new","rustc::middle::infer::resolve","",108],[10,"tcx","","",108],[10,"fold_ty","","",108],[10,"enter_region_binder","","",108],[10,"exit_region_binder","","",108],[10,"fold_ty","","",108],[10,"fold_mt","","",108],[10,"fold_trait_ref","","",108],[10,"fold_substs","","",108],[10,"fold_fn_sig","","",108],[10,"fold_output","","",108],[10,"fold_bare_fn_ty","","",108],[10,"fold_closure_ty","","",108],[10,"fold_region","","",108],[10,"fold_trait_store","","",108],[10,"fold_existential_bounds","","",108],[10,"fold_autoref","","",108],[10,"fold_item_substs","","",108],[10,"tcx","","",109],[10,"fold_ty","","",109],[10,"fold_region","","",109],[10,"enter_region_binder","","",109],[10,"exit_region_binder","","",109],[10,"fold_ty","","",109],[10,"fold_mt","","",109],[10,"fold_trait_ref","","",109],[10,"fold_substs","","",109],[10,"fold_fn_sig","","",109],[10,"fold_output","","",109],[10,"fold_bare_fn_ty","","",109],[10,"fold_closure_ty","","",109],[10,"fold_region","","",109],[10,"fold_trait_store","","",109],[10,"fold_existential_bounds","","",109],[10,"fold_autoref","","",109],[10,"fold_item_substs","","",109],[10,"new","rustc::middle::infer::freshen","",110],[10,"tcx","","",110],[10,"fold_region","","",110],[10,"fold_ty","","",110],[10,"enter_region_binder","","",110],[10,"exit_region_binder","","",110],[10,"fold_ty","","",110],[10,"fold_mt","","",110],[10,"fold_trait_ref","","",110],[10,"fold_substs","","",110],[10,"fold_fn_sig","","",110],[10,"fold_output","","",110],[10,"fold_bare_fn_ty","","",110],[10,"fold_closure_ty","","",110],[10,"fold_region","","",110],[10,"fold_trait_store","","",110],[10,"fold_existential_bounds","","",110],[10,"fold_autoref","","",110],[10,"fold_item_substs","","",110],[10,"infcx","rustc::middle::infer::sub","",111],[10,"tag","","",111],[10,"a_is_expected","","",111],[10,"trace","","",111],[10,"equate","","",111],[10,"sub","","",111],[10,"lub","","",111],[10,"glb","","",111],[10,"contratys","","",111],[10,"contraregions","","",111],[10,"regions","","",111],[10,"mts","","",111],[10,"unsafeties","","",111],[10,"oncenesses","","",111],[10,"builtin_bounds","","",111],[10,"tys","","",111],[10,"binders","","",111],[10,"tcx","","",111],[10,"tps","","",111],[10,"substs","","",111],[10,"substs_variances","","",111],[10,"bare_fn_tys","","",111],[10,"closure_tys","","",111],[10,"fn_sigs","","",111],[10,"args","","",111],[10,"abi","","",111],[10,"projection_tys","","",111],[10,"projection_predicates","","",111],[10,"projection_bounds","","",111],[10,"existential_bounds","","",111],[10,"trait_stores","","",111],[10,"trait_refs","","",111],[10,"fmt","rustc::middle::infer::type_variable","",112],[10,"eq","","",112],[10,"ne","","",112],[10,"ne","","",112],[10,"new","","",113],[10,"var_diverges","","",113],[10,"relate_vars","","Records that `a <: b`, `a :> b`, or `a == b`, depending on `dir`.",113],[10,"instantiate_and_push","","Instantiates `vid` with the type `ty` and then pushes an entry onto `stack` for each of the\nrelations of `vid` to other variables. The relations will have the form `(ty, dir, vid1)`\nwhere `vid1` is some other variable id.",113],[10,"new_var","","",113],[10,"probe","","",113],[10,"replace_if_possible","","",113],[10,"snapshot","","",113],[10,"rollback_to","","",113],[10,"commit","","",113],[10,"types_escaping_snapshot","","Find the set of type variables that existed *before* `s`\nbut which have only been unified since `s` started, and\nreturn the types with which they were unified. So if we had\na type variable `V0`, then we started the snapshot, then we\ncreated a type variable `V1`, unifed `V0` with `T0`, and\nunified `V1` with `T1`, this function would return `{T0}`.",113],[10,"reverse","","",114],[10,"clone","rustc::middle::infer::unify","",115],[10,"clone_from","","",115],[10,"eq","","",115],[10,"ne","","",115],[10,"ne","","",115],[10,"new","","",116],[10,"snapshot","","Starts a new snapshot. Each snapshot must be either\nrolled back or committed in a \"LIFO\" (stack) order.",116],[10,"rollback_to","","Reverses all changes since the last snapshot. Also\nremoves any keys that have been created since then.",116],[10,"commit","","Commits all changes since the last snapshot. Of course, they\ncan still be undone if there is a snapshot further out.",116],[10,"new_key","","",116],[10,"get","","Find the root node for `vid`. This uses the standard union-find algorithm with path\ncompression: http://en.wikipedia.org/wiki/Disjoint-set_data_structure",116],[10,"set","","Sets the value for `vid` to `new_value`. `vid` MUST be a root node! Also, we must be in the\nmiddle of a snapshot.",116],[10,"unify","","Either redirects node_a to node_b or vice versa, depending on the relative rank. Returns\nthe new root and rank. You should then update the value of the new root to something\nsuitable.",116],[10,"reverse","","",117],[10,"simple_vars","rustc::middle::infer","Unifies two simple keys. Because simple keys do not have any subtyping relationships, if\nboth keys have already been associated with a value, then those two values must be the\nsame.",90],[10,"simple_var_t","","Sets the value of the key `a_id` to `b`. Because simple keys do not have any subtyping\nrelationships, if `a_id` already has a value, it must be the same as `b`.",90],[10,"probe_var","","",90],[10,"index","rustc::middle::ty","",118],[10,"from_index","","",118],[10,"unification_table","","",118],[10,"tag","","",118],[10,"to_type","","",119],[10,"to_type_err","","",119],[10,"index","","",120],[10,"from_index","","",120],[10,"unification_table","","",120],[10,"tag","","",120],[10,"to_type","syntax::ast","",121],[10,"to_type_err","","",121],[10,"repr","rustc::middle::infer::unify","",115],[10,"fmt","rustc::middle::infer","",122],[10,"clone","","",122],[10,"clone_from","","",122],[10,"fmt","","",123],[10,"clone","","",123],[10,"clone_from","","",123],[10,"fmt","","",124],[10,"clone","","",124],[10,"clone_from","","",124],[10,"fmt","","",125],[10,"clone","","",125],[10,"clone_from","","",125],[10,"fmt","","",126],[10,"clone","","",126],[10,"clone_from","","",126],[10,"fmt","","",127],[10,"clone","","",127],[10,"clone_from","","",127],[10,"fmt","","",128],[10,"then","core::result","",129],[10,"to_ures","","",129],[10,"compare","","",129],[10,"freshen","rustc::middle::infer","",90],[10,"type_var_diverges","","",90],[10,"freshener","","",90],[10,"combine_fields","","",90],[10,"equate","","",90],[10,"sub","","",90],[10,"lub","","",90],[10,"commit_unconditionally","","Execute `f` and commit the bindings",90],[10,"commit_if_ok","","Execute `f` and commit the bindings if successful",90],[10,"try","","Execute `f`, unroll bindings on panic",90],[10,"probe","","Execute `f` then unroll any bindings it creates",90],[10,"add_given","","",90],[10,"sub_types","","",90],[10,"eq_types","","",90],[10,"sub_trait_refs","","",90],[10,"sub_poly_trait_refs","","",90],[10,"skolemize_late_bound_regions","","See `higher_ranked::skolemize_late_bound_regions`",90],[10,"leak_check","","See `higher_ranked::leak_check`",90],[10,"plug_leaks","","See `higher_ranked::plug_leaks`",90],[10,"equality_predicate","","",90],[10,"region_outlives_predicate","","",90],[10,"next_ty_var_id","","",90],[10,"next_ty_var","","",90],[10,"next_diverging_ty_var","","",90],[10,"next_ty_vars","","",90],[10,"next_int_var_id","","",90],[10,"next_float_var_id","","",90],[10,"next_region_var","","",90],[10,"region_vars_for_defs","","",90],[10,"fresh_substs_for_generics","","Given a set of generics defined on a type or impl, returns a substitution mapping each\ntype/region parameter to a fresh inference variable.",90],[10,"fresh_substs_for_trait","","Given a set of generics defined on a trait, returns a substitution mapping each output\ntype/region parameter to a fresh inference variable, and mapping the self type to\n`self_ty`.",90],[10,"fresh_bound_region","","",90],[10,"resolve_regions_and_report_errors","","",90],[10,"ty_to_string","","",90],[10,"tys_to_string","","",90],[10,"trait_ref_to_string","","",90],[10,"shallow_resolve","","",90],[10,"resolve_type_vars_if_possible","","Where possible, replaces type/int/float variables in\n`value` with their final value. Note that region variables\nare unaffected. If a type variable has not been unified, it\nis left as is.  This is an idempotent operation that does\nnot affect inference state in any way and so you can do it\nat will.",90],[10,"fully_resolve","","Attempts to resolve all type/region variables in\n`value`. Region inference must have been run already (e.g.,\nby calling `resolve_regions_and_report_errors`).  If some\nvariable was never unified, an `Err` results.",90],[10,"type_error_message_str","","",90],[10,"type_error_message_str_with_expected","","",90],[10,"type_error_message","","",90],[10,"report_mismatched_types","","",90],[10,"replace_late_bound_regions_with_fresh_var","","",90],[10,"span","","",124],[10,"dummy","","",124],[10,"repr","","",124],[10,"span","","",122],[10,"repr","","",122],[10,"span","","",125],[10,"repr","","",125],[10,"span","","",127],[10,"repr","","",127],[10,"hash","rustc::middle::lang_items","",130],[10,"assert_receiver_is_total_eq","","",130],[10,"eq","","",130],[10,"ne","","",130],[10,"ne","","",130],[10,"from_i64","","",130],[10,"from_u64","","",130],[10,"from_int","","",130],[10,"from_i8","","",130],[10,"from_i16","","",130],[10,"from_i32","","",130],[10,"from_uint","","",130],[10,"from_u8","","",130],[10,"from_u16","","",130],[10,"from_u32","","",130],[10,"from_f32","","",130],[10,"from_f64","","",130],[10,"new","","",131],[10,"items","","",131],[10,"item_name","","",131],[10,"require","","",131],[10,"from_builtin_kind","","",131],[10,"to_builtin_kind","","",131],[10,"fn_trait_kind","","",131],[10,"send_trait","","",131],[10,"sized_trait","","",131],[10,"copy_trait","","",131],[10,"sync_trait","","",131],[10,"drop_trait","","",131],[10,"add_trait","","",131],[10,"sub_trait","","",131],[10,"mul_trait","","",131],[10,"div_trait","","",131],[10,"rem_trait","","",131],[10,"neg_trait","","",131],[10,"not_trait","","",131],[10,"bitxor_trait","","",131],[10,"bitand_trait","","",131],[10,"bitor_trait","","",131],[10,"shl_trait","","",131],[10,"shr_trait","","",131],[10,"index_trait","","",131],[10,"index_mut_trait","","",131],[10,"slice_trait","","",131],[10,"slice_mut_trait","","",131],[10,"range_struct","","",131],[10,"range_from_struct","","",131],[10,"range_to_struct","","",131],[10,"full_range_struct","","",131],[10,"unsafe_type","","",131],[10,"deref_trait","","",131],[10,"deref_mut_trait","","",131],[10,"fn_trait","","",131],[10,"fn_mut_trait","","",131],[10,"fn_once_trait","","",131],[10,"eq_trait","","",131],[10,"ord_trait","","",131],[10,"str_eq_fn","","",131],[10,"panic_fn","","",131],[10,"panic_bounds_check_fn","","",131],[10,"panic_fmt","","",131],[10,"exchange_malloc_fn","","",131],[10,"exchange_free_fn","","",131],[10,"strdup_uniq_fn","","",131],[10,"start_fn","","",131],[10,"ty_desc","","",131],[10,"opaque","","",131],[10,"type_id","","",131],[10,"eh_personality","","",131],[10,"exchange_heap","","",131],[10,"owned_box","","",131],[10,"covariant_type","","",131],[10,"contravariant_type","","",131],[10,"invariant_type","","",131],[10,"covariant_lifetime","","",131],[10,"contravariant_lifetime","","",131],[10,"invariant_lifetime","","",131],[10,"no_send_bound","","",131],[10,"no_copy_bound","","",131],[10,"no_sync_bound","","",131],[10,"managed_bound","","",131],[10,"non_zero","","",131],[10,"iterator","","",131],[10,"stack_exhausted","","",131],[10,"visit_item","","",132],[10,"visit_name","","",132],[10,"visit_ident","","",132],[10,"visit_mod","","",132],[10,"visit_view_item","","",132],[10,"visit_foreign_item","","",132],[10,"visit_item","","",132],[10,"visit_local","","",132],[10,"visit_block","","",132],[10,"visit_stmt","","",132],[10,"visit_arm","","",132],[10,"visit_pat","","",132],[10,"visit_decl","","",132],[10,"visit_expr","","",132],[10,"visit_expr_post","","",132],[10,"visit_ty","","",132],[10,"visit_generics","","",132],[10,"visit_fn","","",132],[10,"visit_ty_method","","",132],[10,"visit_trait_item","","",132],[10,"visit_trait_ref","","",132],[10,"visit_ty_param_bound","","",132],[10,"visit_poly_trait_ref","","",132],[10,"visit_struct_def","","",132],[10,"visit_struct_field","","",132],[10,"visit_variant","","",132],[10,"visit_opt_lifetime_ref","","",132],[10,"visit_lifetime_bound","","",132],[10,"visit_lifetime_ref","","",132],[10,"visit_lifetime_def","","",132],[10,"visit_explicit_self","","",132],[10,"visit_mac","","",132],[10,"visit_path","","",132],[10,"visit_path_segment","","",132],[10,"visit_path_parameters","","",132],[10,"visit_assoc_type_binding","","",132],[10,"visit_attribute","","",132],[10,"new","","",132],[10,"collect_item","","",132],[10,"collect_local_language_items","","",132],[10,"collect_external_language_items","","",132],[10,"collect","","",132],[10,"eq","rustc::middle::liveness","",133],[10,"ne","","",133],[10,"ne","","",133],[10,"eq","","",134],[10,"ne","","",134],[10,"ne","","",134],[10,"clone","","",134],[10,"clone_from","","",134],[10,"fmt","","",135],[10,"eq","","",135],[10,"ne","","",135],[10,"ne","","",135],[10,"visit_fn","","",136],[10,"visit_local","","",136],[10,"visit_expr","","",136],[10,"visit_arm","","",136],[10,"visit_name","","",136],[10,"visit_ident","","",136],[10,"visit_mod","","",136],[10,"visit_view_item","","",136],[10,"visit_foreign_item","","",136],[10,"visit_item","","",136],[10,"visit_local","","",136],[10,"visit_block","","",136],[10,"visit_stmt","","",136],[10,"visit_arm","","",136],[10,"visit_pat","","",136],[10,"visit_decl","","",136],[10,"visit_expr","","",136],[10,"visit_expr_post","","",136],[10,"visit_ty","","",136],[10,"visit_generics","","",136],[10,"visit_fn","","",136],[10,"visit_ty_method","","",136],[10,"visit_trait_item","","",136],[10,"visit_trait_ref","","",136],[10,"visit_ty_param_bound","","",136],[10,"visit_poly_trait_ref","","",136],[10,"visit_struct_def","","",136],[10,"visit_struct_field","","",136],[10,"visit_variant","","",136],[10,"visit_opt_lifetime_ref","","",136],[10,"visit_lifetime_bound","","",136],[10,"visit_lifetime_ref","","",136],[10,"visit_lifetime_def","","",136],[10,"visit_explicit_self","","",136],[10,"visit_mac","","",136],[10,"visit_path","","",136],[10,"visit_path_segment","","",136],[10,"visit_path_parameters","","",136],[10,"visit_assoc_type_binding","","",136],[10,"visit_attribute","","",136],[10,"fmt","","",134],[10,"fmt","","",133],[10,"fmt","","",137],[10,"fmt","","",138],[10,"visit_fn","","",139],[10,"visit_local","","",139],[10,"visit_expr","","",139],[10,"visit_arm","","",139],[10,"visit_name","","",139],[10,"visit_ident","","",139],[10,"visit_mod","","",139],[10,"visit_view_item","","",139],[10,"visit_foreign_item","","",139],[10,"visit_item","","",139],[10,"visit_local","","",139],[10,"visit_block","","",139],[10,"visit_stmt","","",139],[10,"visit_arm","","",139],[10,"visit_pat","","",139],[10,"visit_decl","","",139],[10,"visit_expr","","",139],[10,"visit_expr_post","","",139],[10,"visit_ty","","",139],[10,"visit_generics","","",139],[10,"visit_fn","","",139],[10,"visit_ty_method","","",139],[10,"visit_trait_item","","",139],[10,"visit_trait_ref","","",139],[10,"visit_ty_param_bound","","",139],[10,"visit_poly_trait_ref","","",139],[10,"visit_struct_def","","",139],[10,"visit_struct_field","","",139],[10,"visit_variant","","",139],[10,"visit_opt_lifetime_ref","","",139],[10,"visit_lifetime_bound","","",139],[10,"visit_lifetime_ref","","",139],[10,"visit_lifetime_def","","",139],[10,"visit_explicit_self","","",139],[10,"visit_mac","","",139],[10,"visit_path","","",139],[10,"visit_path_segment","","",139],[10,"visit_path_parameters","","",139],[10,"visit_assoc_type_binding","","",139],[10,"visit_attribute","","",139],[10,"clone","","",140],[10,"clone_from","","",140],[10,"fmt","rustc::middle::mem_categorization","",141],[10,"eq","","",141],[10,"ne","","",141],[10,"ne","","",141],[10,"clone","","",141],[10,"clone_from","","",141],[10,"fmt","","",142],[10,"eq","","",142],[10,"ne","","",142],[10,"ne","","",142],[10,"clone","","",142],[10,"clone_from","","",142],[10,"fmt","","",143],[10,"hash","","",143],[10,"assert_receiver_is_total_eq","","",143],[10,"eq","","",143],[10,"ne","","",143],[10,"ne","","",143],[10,"clone","","",143],[10,"clone_from","","",143],[10,"fmt","","",144],[10,"hash","","",144],[10,"assert_receiver_is_total_eq","","",144],[10,"eq","","",144],[10,"ne","","",144],[10,"ne","","",144],[10,"clone","","",144],[10,"clone_from","","",144],[10,"fmt","","",145],[10,"hash","","",145],[10,"assert_receiver_is_total_eq","","",145],[10,"eq","","",145],[10,"ne","","",145],[10,"ne","","",145],[10,"clone","","",145],[10,"clone_from","","",145],[10,"fmt","","",146],[10,"hash","","",146],[10,"assert_receiver_is_total_eq","","",146],[10,"eq","","",146],[10,"ne","","",146],[10,"ne","","",146],[10,"clone","","",146],[10,"clone_from","","",146],[10,"fmt","","",147],[10,"hash","","",147],[10,"assert_receiver_is_total_eq","","",147],[10,"eq","","",147],[10,"ne","","",147],[10,"ne","","",147],[10,"clone","","",147],[10,"clone_from","","",147],[10,"fmt","","",148],[10,"eq","","",148],[10,"ne","","",148],[10,"ne","","",148],[10,"clone","","",148],[10,"clone_from","","",148],[10,"fmt","","",149],[10,"eq","","",149],[10,"ne","","",149],[10,"ne","","",149],[10,"clone","","",149],[10,"clone_from","","",149],[10,"id","syntax::ast","",150],[10,"span","","",150],[10,"id","","",151],[10,"span","","",151],[10,"from_mutbl","rustc::middle::mem_categorization","",147],[10,"from_borrow_kind","","",147],[10,"from_pointer_kind","","",147],[10,"inherit","","",147],[10,"is_mutable","","",147],[10,"is_immutable","","",147],[10,"to_user_str","","",147],[10,"new","","",152],[10,"cat_expr","","",152],[10,"cat_expr_autoderefd","","",152],[10,"cat_expr_unadjusted","","",152],[10,"cat_def","","",152],[10,"cat_rvalue_node","","",152],[10,"cat_rvalue","","",152],[10,"cat_field","","",152],[10,"cat_tup_field","","",152],[10,"cat_index","","Creates a cmt for an indexing operation (`[]`).",152],[10,"cat_slice_pattern","","Given a pattern P like: `[_, ..Q, _]`, where `vec_cmt` is the cmt for `P`, `slice_pat` is\nthe pattern `Q`, returns:",152],[10,"cat_imm_interior","","",152],[10,"cat_downcast","","",152],[10,"cat_pattern","","",152],[10,"cmt_to_string","","",152],[10,"guarantor","","Returns `self` after stripping away any owned pointer derefs or\ninterior content. The return value is basically the `cmt` which\ndetermines how long the value in `self` remains live.",149],[10,"freely_aliasable","","Returns `Some(_)` if this lvalue represents a freely aliasable pointer type.",149],[10,"upvar","","",149],[10,"repr","","",149],[10,"repr","","",141],[10,"repr","","",144],[10,"fmt","rustc::middle::privacy","",153],[10,"fmt","","",154],[10,"fmt","","",155],[10,"eq","","",155],[10,"ne","","",155],[10,"ne","","",155],[10,"or","","",153],[10,"visit_item","","",156],[10,"visit_foreign_item","","",156],[10,"visit_fn","","",156],[10,"visit_struct_def","","",156],[10,"visit_name","","",156],[10,"visit_ident","","",156],[10,"visit_mod","","",156],[10,"visit_view_item","","",156],[10,"visit_foreign_item","","",156],[10,"visit_item","","",156],[10,"visit_local","","",156],[10,"visit_block","","",156],[10,"visit_stmt","","",156],[10,"visit_arm","","",156],[10,"visit_pat","","",156],[10,"visit_decl","","",156],[10,"visit_expr","","",156],[10,"visit_expr_post","","",156],[10,"visit_ty","","",156],[10,"visit_generics","","",156],[10,"visit_fn","","",156],[10,"visit_ty_method","","",156],[10,"visit_trait_item","","",156],[10,"visit_trait_ref","","",156],[10,"visit_ty_param_bound","","",156],[10,"visit_poly_trait_ref","","",156],[10,"visit_struct_def","","",156],[10,"visit_struct_field","","",156],[10,"visit_variant","","",156],[10,"visit_opt_lifetime_ref","","",156],[10,"visit_lifetime_bound","","",156],[10,"visit_lifetime_ref","","",156],[10,"visit_lifetime_def","","",156],[10,"visit_explicit_self","","",156],[10,"visit_mac","","",156],[10,"visit_path","","",156],[10,"visit_path_segment","","",156],[10,"visit_path_parameters","","",156],[10,"visit_assoc_type_binding","","",156],[10,"visit_attribute","","",156],[10,"visit_item","","",157],[10,"visit_foreign_item","","",157],[10,"visit_mod","","",157],[10,"visit_name","","",157],[10,"visit_ident","","",157],[10,"visit_mod","","",157],[10,"visit_view_item","","",157],[10,"visit_foreign_item","","",157],[10,"visit_item","","",157],[10,"visit_local","","",157],[10,"visit_block","","",157],[10,"visit_stmt","","",157],[10,"visit_arm","","",157],[10,"visit_pat","","",157],[10,"visit_decl","","",157],[10,"visit_expr","","",157],[10,"visit_expr_post","","",157],[10,"visit_ty","","",157],[10,"visit_generics","","",157],[10,"visit_fn","","",157],[10,"visit_ty_method","","",157],[10,"visit_trait_item","","",157],[10,"visit_trait_ref","","",157],[10,"visit_ty_param_bound","","",157],[10,"visit_poly_trait_ref","","",157],[10,"visit_struct_def","","",157],[10,"visit_struct_field","","",157],[10,"visit_variant","","",157],[10,"visit_opt_lifetime_ref","","",157],[10,"visit_lifetime_bound","","",157],[10,"visit_lifetime_ref","","",157],[10,"visit_lifetime_def","","",157],[10,"visit_explicit_self","","",157],[10,"visit_mac","","",157],[10,"visit_path","","",157],[10,"visit_path_segment","","",157],[10,"visit_path_parameters","","",157],[10,"visit_assoc_type_binding","","",157],[10,"visit_attribute","","",157],[10,"visit_item","","",158],[10,"visit_expr","","",158],[10,"visit_view_item","","",158],[10,"visit_pat","","",158],[10,"visit_foreign_item","","",158],[10,"visit_path","","",158],[10,"visit_name","","",158],[10,"visit_ident","","",158],[10,"visit_mod","","",158],[10,"visit_view_item","","",158],[10,"visit_foreign_item","","",158],[10,"visit_item","","",158],[10,"visit_local","","",158],[10,"visit_block","","",158],[10,"visit_stmt","","",158],[10,"visit_arm","","",158],[10,"visit_pat","","",158],[10,"visit_decl","","",158],[10,"visit_expr","","",158],[10,"visit_expr_post","","",158],[10,"visit_ty","","",158],[10,"visit_generics","","",158],[10,"visit_fn","","",158],[10,"visit_ty_method","","",158],[10,"visit_trait_item","","",158],[10,"visit_trait_ref","","",158],[10,"visit_ty_param_bound","","",158],[10,"visit_poly_trait_ref","","",158],[10,"visit_struct_def","","",158],[10,"visit_struct_field","","",158],[10,"visit_variant","","",158],[10,"visit_opt_lifetime_ref","","",158],[10,"visit_lifetime_bound","","",158],[10,"visit_lifetime_ref","","",158],[10,"visit_lifetime_def","","",158],[10,"visit_explicit_self","","",158],[10,"visit_mac","","",158],[10,"visit_path","","",158],[10,"visit_path_segment","","",158],[10,"visit_path_parameters","","",158],[10,"visit_assoc_type_binding","","",158],[10,"visit_attribute","","",158],[10,"visit_item","","",159],[10,"visit_fn","","",159],[10,"visit_view_item","","",159],[10,"visit_name","","",159],[10,"visit_ident","","",159],[10,"visit_mod","","",159],[10,"visit_view_item","","",159],[10,"visit_foreign_item","","",159],[10,"visit_item","","",159],[10,"visit_local","","",159],[10,"visit_block","","",159],[10,"visit_stmt","","",159],[10,"visit_arm","","",159],[10,"visit_pat","","",159],[10,"visit_decl","","",159],[10,"visit_expr","","",159],[10,"visit_expr_post","","",159],[10,"visit_ty","","",159],[10,"visit_generics","","",159],[10,"visit_fn","","",159],[10,"visit_ty_method","","",159],[10,"visit_trait_item","","",159],[10,"visit_trait_ref","","",159],[10,"visit_ty_param_bound","","",159],[10,"visit_poly_trait_ref","","",159],[10,"visit_struct_def","","",159],[10,"visit_struct_field","","",159],[10,"visit_variant","","",159],[10,"visit_opt_lifetime_ref","","",159],[10,"visit_lifetime_bound","","",159],[10,"visit_lifetime_ref","","",159],[10,"visit_lifetime_def","","",159],[10,"visit_explicit_self","","",159],[10,"visit_mac","","",159],[10,"visit_path","","",159],[10,"visit_path_segment","","",159],[10,"visit_path_parameters","","",159],[10,"visit_assoc_type_binding","","",159],[10,"visit_attribute","","",159],[10,"visit_ty","","",160],[10,"visit_expr","","",160],[10,"visit_name","","",160],[10,"visit_ident","","",160],[10,"visit_mod","","",160],[10,"visit_view_item","","",160],[10,"visit_foreign_item","","",160],[10,"visit_item","","",160],[10,"visit_local","","",160],[10,"visit_block","","",160],[10,"visit_stmt","","",160],[10,"visit_arm","","",160],[10,"visit_pat","","",160],[10,"visit_decl","","",160],[10,"visit_expr","","",160],[10,"visit_expr_post","","",160],[10,"visit_ty","","",160],[10,"visit_generics","","",160],[10,"visit_fn","","",160],[10,"visit_ty_method","","",160],[10,"visit_trait_item","","",160],[10,"visit_trait_ref","","",160],[10,"visit_ty_param_bound","","",160],[10,"visit_poly_trait_ref","","",160],[10,"visit_struct_def","","",160],[10,"visit_struct_field","","",160],[10,"visit_variant","","",160],[10,"visit_opt_lifetime_ref","","",160],[10,"visit_lifetime_bound","","",160],[10,"visit_lifetime_ref","","",160],[10,"visit_lifetime_def","","",160],[10,"visit_explicit_self","","",160],[10,"visit_mac","","",160],[10,"visit_path","","",160],[10,"visit_path_segment","","",160],[10,"visit_path_parameters","","",160],[10,"visit_assoc_type_binding","","",160],[10,"visit_attribute","","",160],[10,"visit_item","","",161],[10,"visit_generics","","",161],[10,"visit_foreign_item","","",161],[10,"visit_fn","","",161],[10,"visit_ty","","",161],[10,"visit_variant","","",161],[10,"visit_struct_field","","",161],[10,"visit_view_item","","",161],[10,"visit_block","","",161],[10,"visit_expr","","",161],[10,"visit_name","","",161],[10,"visit_ident","","",161],[10,"visit_mod","","",161],[10,"visit_view_item","","",161],[10,"visit_foreign_item","","",161],[10,"visit_item","","",161],[10,"visit_local","","",161],[10,"visit_block","","",161],[10,"visit_stmt","","",161],[10,"visit_arm","","",161],[10,"visit_pat","","",161],[10,"visit_decl","","",161],[10,"visit_expr","","",161],[10,"visit_expr_post","","",161],[10,"visit_ty","","",161],[10,"visit_generics","","",161],[10,"visit_fn","","",161],[10,"visit_ty_method","","",161],[10,"visit_trait_item","","",161],[10,"visit_trait_ref","","",161],[10,"visit_ty_param_bound","","",161],[10,"visit_poly_trait_ref","","",161],[10,"visit_struct_def","","",161],[10,"visit_struct_field","","",161],[10,"visit_variant","","",161],[10,"visit_opt_lifetime_ref","","",161],[10,"visit_lifetime_bound","","",161],[10,"visit_lifetime_ref","","",161],[10,"visit_lifetime_def","","",161],[10,"visit_explicit_self","","",161],[10,"visit_mac","","",161],[10,"visit_path","","",161],[10,"visit_path_segment","","",161],[10,"visit_path_parameters","","",161],[10,"visit_assoc_type_binding","","",161],[10,"visit_attribute","","",161],[10,"visit_expr","rustc::middle::reachable","",162],[10,"visit_item","","",162],[10,"visit_name","","",162],[10,"visit_ident","","",162],[10,"visit_mod","","",162],[10,"visit_view_item","","",162],[10,"visit_foreign_item","","",162],[10,"visit_item","","",162],[10,"visit_local","","",162],[10,"visit_block","","",162],[10,"visit_stmt","","",162],[10,"visit_arm","","",162],[10,"visit_pat","","",162],[10,"visit_decl","","",162],[10,"visit_expr","","",162],[10,"visit_expr_post","","",162],[10,"visit_ty","","",162],[10,"visit_generics","","",162],[10,"visit_fn","","",162],[10,"visit_ty_method","","",162],[10,"visit_trait_item","","",162],[10,"visit_trait_ref","","",162],[10,"visit_ty_param_bound","","",162],[10,"visit_poly_trait_ref","","",162],[10,"visit_struct_def","","",162],[10,"visit_struct_field","","",162],[10,"visit_variant","","",162],[10,"visit_opt_lifetime_ref","","",162],[10,"visit_lifetime_bound","","",162],[10,"visit_lifetime_ref","","",162],[10,"visit_lifetime_def","","",162],[10,"visit_explicit_self","","",162],[10,"visit_mac","","",162],[10,"visit_path","","",162],[10,"visit_path_segment","","",162],[10,"visit_path_parameters","","",162],[10,"visit_assoc_type_binding","","",162],[10,"visit_attribute","","",162],[10,"fmt","rustc::middle::region","",20],[10,"decode","","",20],[10,"encode","","",20],[10,"hash","","",20],[10,"cmp","","",20],[10,"assert_receiver_is_total_eq","","",20],[10,"partial_cmp","","",20],[10,"lt","","",20],[10,"le","","",20],[10,"gt","","",20],[10,"ge","","",20],[10,"lt","","",20],[10,"le","","",20],[10,"gt","","",20],[10,"ge","","",20],[10,"eq","","",20],[10,"ne","","",20],[10,"ne","","",20],[10,"clone","","",20],[10,"clone_from","","",20],[10,"from_node_id","","Creates a scope that represents the dynamic extent associated\nwith `node_id`.",20],[10,"node_id","","Returns a node id associated with this scope.",20],[10,"map_id","","Maps this scope to a potentially new one according to the\nNodeId transformer `f_id`.",20],[10,"relate_free_regions","","",163],[10,"record_encl_scope","","",163],[10,"record_var_scope","","",163],[10,"record_rvalue_scope","","",163],[10,"mark_as_terminating_scope","","Records that a scope is a TERMINATING SCOPE. Whenever we create automatic temporaries --\ne.g. by an expression like `a().f` -- they will be freed within the innermost terminating\nscope.",163],[10,"opt_encl_scope","","Returns the narrowest scope that encloses `id`, if any.",163],[10,"encl_scope","","Returns the narrowest scope that encloses `id`, if any.",163],[10,"var_scope","","Returns the lifetime of the local variable `var_id`",163],[10,"temporary_scope","","Returns the scope when temp created by expr_id will be cleaned up",163],[10,"var_region","","Returns the lifetime of the variable `id`.",163],[10,"scopes_intersect","","",163],[10,"is_subscope_of","","Returns true if `subscope` is equal to or is lexically nested inside `superscope` and false\notherwise.",163],[10,"sub_free_region","","Determines whether two free regions have a subregion relationship\nby walking the graph encoded in `free_region_map`.  Note that\nit is possible that `sub != sup` and `sub <= sup` and `sup <= sub`\n(that is, the user can give two different names to the same lifetime).",163],[10,"is_subregion_of","","Determines whether one region is a subregion of another.  This is intended to run *after\ninference* and sadly the logic is somewhat duplicated with the code in infer.rs.",163],[10,"nearest_common_ancestor","","Finds the nearest common ancestor (if any) of two scopes.  That is, finds the smallest\nscope which is greater than or equal to both `scope_a` and `scope_b`.",163],[10,"visit_block","","",164],[10,"visit_item","","",164],[10,"visit_fn","","",164],[10,"visit_arm","","",164],[10,"visit_pat","","",164],[10,"visit_stmt","","",164],[10,"visit_expr","","",164],[10,"visit_local","","",164],[10,"visit_name","","",164],[10,"visit_ident","","",164],[10,"visit_mod","","",164],[10,"visit_view_item","","",164],[10,"visit_foreign_item","","",164],[10,"visit_item","","",164],[10,"visit_local","","",164],[10,"visit_block","","",164],[10,"visit_stmt","","",164],[10,"visit_arm","","",164],[10,"visit_pat","","",164],[10,"visit_decl","","",164],[10,"visit_expr","","",164],[10,"visit_expr_post","","",164],[10,"visit_ty","","",164],[10,"visit_generics","","",164],[10,"visit_fn","","",164],[10,"visit_ty_method","","",164],[10,"visit_trait_item","","",164],[10,"visit_trait_ref","","",164],[10,"visit_ty_param_bound","","",164],[10,"visit_poly_trait_ref","","",164],[10,"visit_struct_def","","",164],[10,"visit_struct_field","","",164],[10,"visit_variant","","",164],[10,"visit_opt_lifetime_ref","","",164],[10,"visit_lifetime_bound","","",164],[10,"visit_lifetime_ref","","",164],[10,"visit_lifetime_def","","",164],[10,"visit_explicit_self","","",164],[10,"visit_mac","","",164],[10,"visit_path","","",164],[10,"visit_path_segment","","",164],[10,"visit_path_parameters","","",164],[10,"visit_assoc_type_binding","","",164],[10,"visit_attribute","","",164],[10,"fmt","rustc::middle::resolve_lifetime","",165],[10,"decode","","",165],[10,"encode","","",165],[10,"hash","","",165],[10,"assert_receiver_is_total_eq","","",165],[10,"eq","","",165],[10,"ne","","",165],[10,"ne","","",165],[10,"clone","","",165],[10,"clone_from","","",165],[10,"visit_item","","",166],[10,"visit_fn","","",166],[10,"visit_ty","","",166],[10,"visit_ty_method","","",166],[10,"visit_block","","",166],[10,"visit_lifetime_ref","","",166],[10,"visit_generics","","",166],[10,"visit_poly_trait_ref","","",166],[10,"visit_trait_ref","","",166],[10,"visit_name","","",166],[10,"visit_ident","","",166],[10,"visit_mod","","",166],[10,"visit_view_item","","",166],[10,"visit_foreign_item","","",166],[10,"visit_item","","",166],[10,"visit_local","","",166],[10,"visit_block","","",166],[10,"visit_stmt","","",166],[10,"visit_arm","","",166],[10,"visit_pat","","",166],[10,"visit_decl","","",166],[10,"visit_expr","","",166],[10,"visit_expr_post","","",166],[10,"visit_ty","","",166],[10,"visit_generics","","",166],[10,"visit_fn","","",166],[10,"visit_ty_method","","",166],[10,"visit_trait_item","","",166],[10,"visit_trait_ref","","",166],[10,"visit_ty_param_bound","","",166],[10,"visit_poly_trait_ref","","",166],[10,"visit_struct_def","","",166],[10,"visit_struct_field","","",166],[10,"visit_variant","","",166],[10,"visit_opt_lifetime_ref","","",166],[10,"visit_lifetime_bound","","",166],[10,"visit_lifetime_ref","","",166],[10,"visit_lifetime_def","","",166],[10,"visit_explicit_self","","",166],[10,"visit_mac","","",166],[10,"visit_path","","",166],[10,"visit_path_segment","","",166],[10,"visit_path_parameters","","",166],[10,"visit_assoc_type_binding","","",166],[10,"visit_attribute","","",166],[10,"fmt","","",167],[10,"visit_item","rustc::middle::stability","",168],[10,"visit_fn","","",168],[10,"visit_trait_item","","",168],[10,"visit_variant","","",168],[10,"visit_struct_field","","",168],[10,"visit_foreign_item","","",168],[10,"visit_name","","",168],[10,"visit_ident","","",168],[10,"visit_mod","","",168],[10,"visit_view_item","","",168],[10,"visit_foreign_item","","",168],[10,"visit_item","","",168],[10,"visit_local","","",168],[10,"visit_block","","",168],[10,"visit_stmt","","",168],[10,"visit_arm","","",168],[10,"visit_pat","","",168],[10,"visit_decl","","",168],[10,"visit_expr","","",168],[10,"visit_expr_post","","",168],[10,"visit_ty","","",168],[10,"visit_generics","","",168],[10,"visit_fn","","",168],[10,"visit_ty_method","","",168],[10,"visit_trait_item","","",168],[10,"visit_trait_ref","","",168],[10,"visit_ty_param_bound","","",168],[10,"visit_poly_trait_ref","","",168],[10,"visit_struct_def","","",168],[10,"visit_struct_field","","",168],[10,"visit_variant","","",168],[10,"visit_opt_lifetime_ref","","",168],[10,"visit_lifetime_bound","","",168],[10,"visit_lifetime_ref","","",168],[10,"visit_lifetime_def","","",168],[10,"visit_explicit_self","","",168],[10,"visit_mac","","",168],[10,"visit_path","","",168],[10,"visit_path_segment","","",168],[10,"visit_path_parameters","","",168],[10,"visit_assoc_type_binding","","",168],[10,"visit_attribute","","",168],[10,"build","","Construct the stability index for a crate being compiled.",169],[10,"fmt","rustc::middle::subst","",170],[10,"hash","","",170],[10,"assert_receiver_is_total_eq","","",170],[10,"eq","","",170],[10,"ne","","",170],[10,"ne","","",170],[10,"clone","","",170],[10,"clone_from","","",170],[10,"fmt","","",171],[10,"hash","","",171],[10,"assert_receiver_is_total_eq","","",171],[10,"eq","","",171],[10,"ne","","",171],[10,"ne","","",171],[10,"clone","","",171],[10,"clone_from","","",171],[10,"new","","",170],[10,"new_type","","",170],[10,"new_trait","","",170],[10,"erased","","",170],[10,"empty","","",170],[10,"trans_empty","","",170],[10,"is_noop","","",170],[10,"type_for_def","","",170],[10,"has_regions_escaping_depth","","",170],[10,"self_ty","","",170],[10,"with_self_ty","","",170],[10,"erase_regions","","",170],[10,"regions","","Since ErasedRegions are only to be used in trans, most of the compiler can use this method\nto easily access the set of region substitutions.",170],[10,"mut_regions","","Since ErasedRegions are only to be used in trans, most of the compiler can use this method\nto easily access the set of region substitutions.",170],[10,"with_method","","",170],[10,"is_erased","","",171],[10,"fmt","","",172],[10,"decode","","",172],[10,"encode","","",172],[10,"hash","","",172],[10,"clone","","",172],[10,"clone_from","","",172],[10,"assert_receiver_is_total_eq","","",172],[10,"eq","","",172],[10,"ne","","",172],[10,"ne","","",172],[10,"cmp","","",172],[10,"partial_cmp","","",172],[10,"lt","","",172],[10,"le","","",172],[10,"gt","","",172],[10,"ge","","",172],[10,"lt","","",172],[10,"le","","",172],[10,"gt","","",172],[10,"ge","","",172],[10,"all","","",172],[10,"to_uint","","",172],[10,"from_uint","","",172],[10,"decode","","",173],[10,"encode","","",173],[10,"hash","","",173],[10,"clone","","",173],[10,"clone_from","","",173],[10,"assert_receiver_is_total_eq","","",173],[10,"eq","","",173],[10,"ne","","",173],[10,"ne","","",173],[10,"fmt","","",173],[10,"empty","","",173],[10,"params_from_type","","",173],[10,"new","","`t` is the type space.\n`s` is the self space.\n`a` is the assoc space.\n`f` is the fn space.",173],[10,"push","","Appends `value` to the vector associated with `space`.",173],[10,"pop","","",173],[10,"truncate","","",173],[10,"replace","","",173],[10,"get_self","","",173],[10,"len","","",173],[10,"is_empty_in","","",173],[10,"get_slice","","",173],[10,"get_mut_slice","","",173],[10,"opt_get","","",173],[10,"get","","",173],[10,"iter","","",173],[10,"iter_enumerated","","",173],[10,"as_slice","","",173],[10,"to_vec","","",173],[10,"all_vecs","","",173],[10,"all","","",173],[10,"any","","",173],[10,"is_empty","","",173],[10,"map","","",173],[10,"map_enumerated","","",173],[10,"map_move","","",173],[10,"split","","",173],[10,"with_vec","","",173],[10,"clone","","",174],[10,"clone_from","","",174],[10,"next","","",174],[10,"size_hint","","",174],[10,"tcx","","",175],[10,"enter_region_binder","","",175],[10,"exit_region_binder","","",175],[10,"fold_region","","",175],[10,"fold_ty","","",175],[10,"enter_region_binder","","",175],[10,"exit_region_binder","","",175],[10,"fold_ty","","",175],[10,"fold_mt","","",175],[10,"fold_trait_ref","","",175],[10,"fold_substs","","",175],[10,"fold_fn_sig","","",175],[10,"fold_output","","",175],[10,"fold_bare_fn_ty","","",175],[10,"fold_closure_ty","","",175],[10,"fold_region","","",175],[10,"fold_trait_store","","",175],[10,"fold_existential_bounds","","",175],[10,"fold_autoref","","",175],[10,"fold_item_substs","","",175],[10,"new","rustc::middle::traits::fulfill","",176],[10,"normalize_projection_type","","\"Normalize\" a projection type `<SomeType as SomeTrait>::X` by\ncreating a fresh type variable `$0` as well as a projection\npredicate `<SomeType as SomeTrait>::X == $0`. When the\ninference engine runs, it will attempt to find an impl of\n`SomeTrait` or a where clause that lets us unify `$0` with\nsomething concrete. If this fails, we'll unify `$0` with\n`projection_ty` again.",176],[10,"register_builtin_bound","","",176],[10,"register_region_obligation","","",176],[10,"register_predicate_obligation","","",176],[10,"region_obligations","","",176],[10,"select_all_or_error","","",176],[10,"select_new_obligations","","Attempts to select obligations that were registered since the call to a selection routine.\nThis is used by the type checker to eagerly attempt to resolve obligations in hopes of\ngaining type information. It'd be equally valid to use `select_where_possible` but it\nresults in `O(n^2)` performance (#18208).",176],[10,"select_where_possible","","",176],[10,"pending_obligations","","",176],[10,"repr","","",177],[10,"clone","rustc::middle::traits::project","",178],[10,"clone_from","","",178],[10,"tcx","","",179],[10,"fold_ty","","",179],[10,"enter_region_binder","","",179],[10,"exit_region_binder","","",179],[10,"fold_ty","","",179],[10,"fold_mt","","",179],[10,"fold_trait_ref","","",179],[10,"fold_substs","","",179],[10,"fold_fn_sig","","",179],[10,"fold_output","","",179],[10,"fold_bare_fn_ty","","",179],[10,"fold_closure_ty","","",179],[10,"fold_region","","",179],[10,"fold_trait_store","","",179],[10,"fold_existential_bounds","","",179],[10,"fold_autoref","","",179],[10,"fold_item_substs","","",179],[10,"repr","","",180],[10,"repr","","",181],[10,"clone","rustc::middle::traits::select","",182],[10,"clone_from","","",182],[10,"fmt","","",183],[10,"clone","","",184],[10,"clone_from","","",184],[10,"fmt","","",184],[10,"assert_receiver_is_total_eq","","",184],[10,"eq","","",184],[10,"ne","","",184],[10,"ne","","",184],[10,"fmt","","",185],[10,"new","","",186],[10,"intercrate","","",186],[10,"infcx","","",186],[10,"param_env","","",186],[10,"tcx","","",186],[10,"select","","Evaluates whether the obligation can be satisfied. Returns an indication of whether the\nobligation can be satisfied and, if so, by what means. Never affects surrounding typing\nenvironment.",186],[10,"evaluate_obligation","","Evaluates whether the obligation `obligation` can be satisfied (by any means).",186],[10,"evaluate_impl","","Evaluates whether the impl with id `impl_def_id` could be applied to the self type\n`obligation_self_ty`. This can be used either for trait or inherent impls.",186],[10,"repr","","",184],[10,"new","","",182],[10,"next","core::option","",14],[10,"size_hint","","",14],[10,"repr","rustc::middle::traits::select","",187],[10,"may_apply","","",188],[10,"filter_to_traits","rustc::middle::traits::util","",189],[10,"next","","",189],[10,"size_hint","","",189],[10,"next","","",190],[10,"size_hint","","",190],[10,"fmt","rustc::middle::traits","",191],[10,"repr","","",192],[10,"repr","","",193],[10,"repr","","",191],[10,"repr","","",194],[10,"repr","","",195],[10,"repr","","",196],[10,"repr","","",197],[10,"fmt","","",197],[10,"repr","rustc::middle::traits::project","",178],[10,"fmt","","",178],[10,"clone","rustc::middle::traits","",192],[10,"clone_from","","",192],[10,"clone","","",198],[10,"clone_from","","",198],[10,"clone","","",199],[10,"clone_from","","",199],[10,"clone","","",200],[10,"clone_from","","",200],[10,"fmt","","",195],[10,"clone","","",195],[10,"clone_from","","",195],[10,"clone","","",197],[10,"clone_from","","",197],[10,"clone","","",193],[10,"clone_from","","",193],[10,"fmt","","",193],[10,"clone","","",191],[10,"clone_from","","",191],[10,"clone","","",194],[10,"clone_from","","",194],[10,"fmt","","",194],[10,"new","","",192],[10,"misc","","",192],[10,"with","","",192],[10,"new","","",198],[10,"misc","","",198],[10,"dummy","","",198],[10,"iter_nested","","",193],[10,"map_nested","","",193],[10,"map_move_nested","","",193],[10,"iter_nested","","",191],[10,"map_nested","","",191],[10,"map_move_nested","","",191],[10,"iter_nested","","",194],[10,"map_nested","","",194],[10,"map_move_nested","","",194],[10,"is_overflow","","",196],[10,"hash","rustc::middle::ty","",201],[10,"assert_receiver_is_total_eq","","",201],[10,"eq","","",201],[10,"ne","","",201],[10,"ne","","",201],[10,"fmt","","",202],[10,"clone","","",202],[10,"clone_from","","",202],[10,"id","","",202],[10,"clone","","",203],[10,"clone_from","","",203],[10,"def_id","","",203],[10,"name","","",203],[10,"container","","",203],[10,"as_opt_method","","",203],[10,"clone","","",204],[10,"clone_from","","",204],[10,"def_id","","",204],[10,"fmt","","",205],[10,"clone","","",205],[10,"clone_from","","",205],[10,"new","","",205],[10,"container_id","","",205],[10,"clone","","",206],[10,"clone_from","","",206],[10,"fmt","","",207],[10,"hash","","",207],[10,"assert_receiver_is_total_eq","","",207],[10,"eq","","",207],[10,"ne","","",207],[10,"ne","","",207],[10,"clone","","",207],[10,"clone_from","","",207],[10,"fmt","","",22],[10,"decode","","",22],[10,"encode","","",22],[10,"hash","","",22],[10,"assert_receiver_is_total_eq","","",22],[10,"eq","","",22],[10,"ne","","",22],[10,"ne","","",22],[10,"clone","","",22],[10,"clone_from","","",22],[10,"fmt","","",208],[10,"clone","","",208],[10,"clone_from","","",208],[10,"hash","","",209],[10,"assert_receiver_is_total_eq","","",209],[10,"eq","","",209],[10,"ne","","",209],[10,"ne","","",209],[10,"encode","","",210],[10,"decode","","",210],[10,"eq","","",210],[10,"ne","","",210],[10,"ne","","",210],[10,"clone","","",210],[10,"clone_from","","",210],[10,"fmt","","",211],[10,"encode","","",211],[10,"decode","","",211],[10,"eq","","",211],[10,"ne","","",211],[10,"ne","","",211],[10,"clone","","",211],[10,"clone_from","","",211],[10,"fmt","","",212],[10,"clone","","",212],[10,"clone_from","","",212],[10,"fmt","","",213],[10,"eq","","",213],[10,"ne","","",213],[10,"ne","","",213],[10,"clone","","",213],[10,"clone_from","","",213],[10,"fmt","","",214],[10,"clone","","",214],[10,"clone_from","","",214],[10,"fmt","","",215],[10,"eq","","",215],[10,"ne","","",215],[10,"ne","","",215],[10,"clone","","",215],[10,"clone_from","","",215],[10,"fmt","","",216],[10,"partial_cmp","","",216],[10,"lt","","",216],[10,"le","","",216],[10,"gt","","",216],[10,"ge","","",216],[10,"lt","","",216],[10,"le","","",216],[10,"gt","","",216],[10,"ge","","",216],[10,"eq","","",216],[10,"ne","","",216],[10,"ne","","",216],[10,"decode","","",216],[10,"encode","","",216],[10,"clone","","",216],[10,"clone_from","","",216],[10,"fmt","","",26],[10,"clone","","",26],[10,"clone_from","","",26],[10,"fmt","","",217],[10,"clone","","",217],[10,"clone_from","","",217],[10,"fmt","","",218],[10,"clone","","",218],[10,"clone_from","","",218],[10,"clone","","",219],[10,"clone_from","","",219],[10,"fmt","","",220],[10,"hash","","",220],[10,"assert_receiver_is_total_eq","","",220],[10,"eq","","",220],[10,"ne","","",220],[10,"ne","","",220],[10,"clone","","",220],[10,"clone_from","","",220],[10,"decode","","",221],[10,"encode","","",221],[10,"fmt","","",221],[10,"hash","","",221],[10,"assert_receiver_is_total_eq","","",221],[10,"eq","","",221],[10,"ne","","",221],[10,"ne","","",221],[10,"clone","","",221],[10,"clone_from","","",221],[10,"expr","","",220],[10,"autoobject","","",220],[10,"autoderef","","",220],[10,"clone","","",222],[10,"clone_from","","",222],[10,"new","","",223],[10,"hash","","",224],[10,"cmp","","",224],[10,"partial_cmp","","",224],[10,"lt","","",224],[10,"le","","",224],[10,"gt","","",224],[10,"ge","","",224],[10,"lt","","",224],[10,"le","","",224],[10,"gt","","",224],[10,"ge","","",224],[10,"clone","","",224],[10,"clone_from","","",224],[10,"assert_receiver_is_total_eq","","",224],[10,"eq","","",224],[10,"ne","","",224],[10,"ne","","",224],[10,"empty","","Returns an empty set of flags.",224],[10,"all","","Returns the set containing all flags.",224],[10,"bits","","Returns the raw value of the flags currently stored.",224],[10,"from_bits","","Convert from underlying bit representation, unless that\nrepresentation contains bits that do not correspond to a flag.",224],[10,"from_bits_truncate","","Convert from underlying bit representation, dropping any bits\nthat do not correspond to flags.",224],[10,"is_empty","","Returns `true` if no flags are currently stored.",224],[10,"is_all","","Returns `true` if all flags are currently set.",224],[10,"intersects","","Returns `true` if there are flags common to both `self` and `other`.",224],[10,"contains","","Returns `true` all of the flags in `other` are contained within `self`.",224],[10,"insert","","Inserts the specified flags in-place.",224],[10,"remove","","Removes the specified flags in-place.",224],[10,"toggle","","Toggles the specified flags in-place.",224],[10,"bitor","","Returns the union of the two sets of flags.",224],[10,"bitxor","","Returns the left flags, but with all the right flags toggled.",224],[10,"bitand","","Returns the intersection between the two sets of flags.",224],[10,"sub","","Returns the set difference of the two sets of flags.",224],[10,"not","","Returns the complement of this set of flags.",224],[10,"print_debug_stats","","",225],[10,"fmt","","",226],[10,"fmt","","",224],[10,"eq","","",226],[10,"ne","","",226],[10,"assert_receiver_is_total_eq","","",226],[10,"hash","","",226],[10,"eq","","",227],[10,"ne","","",227],[10,"assert_receiver_is_total_eq","","",227],[10,"hash","","",227],[10,"borrow_from","","",228],[10,"fmt","","",229],[10,"hash","","",229],[10,"assert_receiver_is_total_eq","","",229],[10,"eq","","",229],[10,"ne","","",229],[10,"ne","","",229],[10,"clone","","",229],[10,"clone_from","","",229],[10,"fmt","","",230],[10,"hash","","",230],[10,"assert_receiver_is_total_eq","","",230],[10,"eq","","",230],[10,"ne","","",230],[10,"ne","","",230],[10,"clone","","",230],[10,"clone_from","","",230],[10,"hash","","",231],[10,"assert_receiver_is_total_eq","","",231],[10,"eq","","",231],[10,"ne","","",231],[10,"ne","","",231],[10,"clone","","",231],[10,"clone_from","","",231],[10,"unwrap","","",231],[10,"hash","","",86],[10,"assert_receiver_is_total_eq","","",86],[10,"eq","","",86],[10,"ne","","",86],[10,"ne","","",86],[10,"clone","","",86],[10,"clone_from","","",86],[10,"fmt","","",232],[10,"hash","","",232],[10,"assert_receiver_is_total_eq","","",232],[10,"eq","","",232],[10,"ne","","",232],[10,"ne","","",232],[10,"clone","","",232],[10,"clone_from","","",232],[10,"fmt","","",233],[10,"decode","","",233],[10,"encode","","",233],[10,"hash","","",233],[10,"assert_receiver_is_total_eq","","",233],[10,"eq","","",233],[10,"ne","","",233],[10,"ne","","",233],[10,"clone","","",233],[10,"clone_from","","",233],[10,"fmt","","",18],[10,"decode","","",18],[10,"encode","","",18],[10,"hash","","",18],[10,"assert_receiver_is_total_eq","","",18],[10,"eq","","",18],[10,"ne","","",18],[10,"ne","","",18],[10,"clone","","",18],[10,"clone_from","","",18],[10,"fmt","","",234],[10,"hash","","",234],[10,"assert_receiver_is_total_eq","","",234],[10,"eq","","",234],[10,"ne","","",234],[10,"ne","","",234],[10,"clone","","",234],[10,"clone_from","","",234],[10,"decode","","",235],[10,"encode","","",235],[10,"fmt","","",235],[10,"hash","","",235],[10,"assert_receiver_is_total_eq","","",235],[10,"eq","","",235],[10,"ne","","",235],[10,"ne","","",235],[10,"clone","","",235],[10,"clone_from","","",235],[10,"fmt","","",25],[10,"decode","","",25],[10,"encode","","",25],[10,"clone","","",25],[10,"clone_from","","",25],[10,"eq","","",25],[10,"ne","","",25],[10,"ne","","",25],[10,"is_bound","","",18],[10,"escapes_depth","","",18],[10,"fmt","","",19],[10,"decode","","",19],[10,"encode","","",19],[10,"hash","","",19],[10,"cmp","","",19],[10,"assert_receiver_is_total_eq","","",19],[10,"partial_cmp","","",19],[10,"lt","","",19],[10,"le","","",19],[10,"gt","","",19],[10,"ge","","",19],[10,"lt","","",19],[10,"le","","",19],[10,"gt","","",19],[10,"ge","","",19],[10,"eq","","",19],[10,"ne","","",19],[10,"ne","","",19],[10,"clone","","",19],[10,"clone_from","","",19],[10,"fmt","","",21],[10,"decode","","",21],[10,"encode","","",21],[10,"hash","","",21],[10,"cmp","","",21],[10,"assert_receiver_is_total_eq","","",21],[10,"partial_cmp","","",21],[10,"lt","","",21],[10,"le","","",21],[10,"gt","","",21],[10,"ge","","",21],[10,"lt","","",21],[10,"le","","",21],[10,"gt","","",21],[10,"ge","","",21],[10,"eq","","",21],[10,"ne","","",21],[10,"ne","","",21],[10,"clone","","",21],[10,"clone_from","","",21],[10,"fmt","","",228],[10,"hash","","",228],[10,"assert_receiver_is_total_eq","","",228],[10,"eq","","",228],[10,"ne","","",228],[10,"ne","","",228],[10,"clone","","",228],[10,"clone_from","","",228],[10,"fmt","","",236],[10,"hash","","",236],[10,"assert_receiver_is_total_eq","","",236],[10,"eq","","",236],[10,"ne","","",236],[10,"ne","","",236],[10,"clone","","",236],[10,"clone_from","","",236],[10,"principal_def_id","","",236],[10,"principal_trait_ref_with_self_ty","","Object types don't have a self-type specified. Therefore, when\nwe convert the principal trait-ref into a normal trait-ref,\nyou must give *some* self-type. A common choice is `mk_err()`\nor some skolemized type.",236],[10,"projection_bounds_with_self_ty","","",236],[10,"fmt","","",84],[10,"hash","","",84],[10,"assert_receiver_is_total_eq","","",84],[10,"eq","","",84],[10,"ne","","",84],[10,"ne","","",84],[10,"clone","","",84],[10,"clone_from","","",84],[10,"self_ty","","",91],[10,"def_id","","",91],[10,"substs","","",91],[10,"input_types","","",91],[10,"to_poly_trait_predicate","","",91],[10,"fmt","","",91],[10,"hash","","",91],[10,"assert_receiver_is_total_eq","","",91],[10,"eq","","",91],[10,"ne","","",91],[10,"ne","","",91],[10,"clone","","",91],[10,"clone_from","","",91],[10,"eq","","",119],[10,"ne","","",119],[10,"ne","","",119],[10,"clone","","",119],[10,"clone_from","","",119],[10,"fmt","","",237],[10,"clone","","",237],[10,"clone_from","","",237],[10,"fmt","","",238],[10,"clone","","",238],[10,"clone_from","","",238],[10,"fmt","","",239],[10,"clone","","",239],[10,"clone_from","","",239],[10,"fmt","","",240],[10,"clone","","",240],[10,"clone_from","","",240],[10,"hash","","",240],[10,"assert_receiver_is_total_eq","","",240],[10,"eq","","",240],[10,"ne","","",240],[10,"ne","","",240],[10,"fmt","","",241],[10,"clone","","",241],[10,"clone_from","","",241],[10,"hash","","",241],[10,"assert_receiver_is_total_eq","","",241],[10,"eq","","",241],[10,"ne","","",241],[10,"ne","","",241],[10,"fmt","","",242],[10,"hash","","",242],[10,"decode","","",242],[10,"assert_receiver_is_total_eq","","",242],[10,"eq","","",242],[10,"ne","","",242],[10,"ne","","",242],[10,"encode","","",242],[10,"clone","","",242],[10,"clone_from","","",242],[10,"to_uint","","",242],[10,"from_uint","","",242],[10,"hash","","",243],[10,"assert_receiver_is_total_eq","","",243],[10,"eq","","",243],[10,"ne","","",243],[10,"ne","","",243],[10,"clone","","",243],[10,"clone_from","","",243],[10,"hash","","",118],[10,"assert_receiver_is_total_eq","","",118],[10,"eq","","",118],[10,"ne","","",118],[10,"ne","","",118],[10,"clone","","",118],[10,"clone_from","","",118],[10,"hash","","",120],[10,"assert_receiver_is_total_eq","","",120],[10,"eq","","",120],[10,"ne","","",120],[10,"ne","","",120],[10,"clone","","",120],[10,"clone_from","","",120],[10,"hash","","",244],[10,"decode","","",244],[10,"encode","","",244],[10,"assert_receiver_is_total_eq","","",244],[10,"eq","","",244],[10,"ne","","",244],[10,"ne","","",244],[10,"clone","","",244],[10,"clone_from","","",244],[10,"hash","","",245],[10,"assert_receiver_is_total_eq","","",245],[10,"eq","","",245],[10,"ne","","",245],[10,"ne","","",245],[10,"clone","","",245],[10,"clone_from","","",245],[10,"fmt","","",246],[10,"hash","","",246],[10,"assert_receiver_is_total_eq","","",246],[10,"decode","","",246],[10,"encode","","",246],[10,"clone","","",246],[10,"clone_from","","",246],[10,"eq","","",246],[10,"ne","","",246],[10,"ne","","",246],[10,"fmt","","",243],[10,"fmt","","",118],[10,"fmt","","",120],[10,"fmt","","",244],[10,"fmt","","",86],[10,"fmt","","",245],[10,"fmt","","",119],[10,"fmt","","",247],[10,"clone","","",247],[10,"clone_from","","",247],[10,"fmt","","",248],[10,"clone","","",248],[10,"clone_from","","",248],[10,"decode","","",248],[10,"encode","","",248],[10,"to_early_bound_region","","",248],[10,"fmt","","",249],[10,"clone","","",249],[10,"clone_from","","",249],[10,"empty","","",249],[10,"has_type_params","","",249],[10,"has_region_params","","",249],[10,"to_bounds","","",249],[10,"fmt","","",250],[10,"hash","","",250],[10,"assert_receiver_is_total_eq","","",250],[10,"eq","","",250],[10,"ne","","",250],[10,"ne","","",250],[10,"clone","","",250],[10,"clone_from","","",250],[10,"fmt","","",251],[10,"hash","","",251],[10,"assert_receiver_is_total_eq","","",251],[10,"eq","","",251],[10,"ne","","",251],[10,"ne","","",251],[10,"clone","","",251],[10,"clone_from","","",251],[10,"def_id","","",251],[10,"input_types","","",251],[10,"self_ty","","",251],[10,"def_id","","",91],[10,"fmt","","",252],[10,"hash","","",252],[10,"assert_receiver_is_total_eq","","",252],[10,"eq","","",252],[10,"ne","","",252],[10,"ne","","",252],[10,"clone","","",252],[10,"clone_from","","",252],[10,"fmt","","",253],[10,"hash","","",253],[10,"assert_receiver_is_total_eq","","",253],[10,"eq","","",253],[10,"ne","","",253],[10,"ne","","",253],[10,"clone","","",253],[10,"clone_from","","",253],[10,"fmt","","",85],[10,"hash","","",85],[10,"assert_receiver_is_total_eq","","",85],[10,"eq","","",85],[10,"ne","","",85],[10,"ne","","",85],[10,"clone","","",85],[10,"clone_from","","",85],[10,"sort_key","","",91],[10,"fmt","","",254],[10,"hash","","",254],[10,"assert_receiver_is_total_eq","","",254],[10,"eq","","",254],[10,"ne","","",254],[10,"ne","","",254],[10,"clone","","",254],[10,"clone_from","","",254],[10,"sort_key","","",254],[10,"to_poly_trait_ref","alloc::rc","",83],[10,"to_poly_trait_ref","rustc::middle::ty","",91],[10,"to_poly_trait_ref","","",91],[10,"as_predicate","alloc::rc","",83],[10,"as_predicate","rustc::middle::ty","",91],[10,"as_predicate","","",91],[10,"as_predicate","","",91],[10,"as_predicate","","",91],[10,"as_predicate","","",91],[10,"has_escaping_regions","","",250],[10,"to_opt_poly_trait_ref","","",250],[10,"fmt","","",255],[10,"clone","","",255],[10,"clone_from","","",255],[10,"empty","","",255],[10,"has_escaping_regions","","",255],[10,"is_empty","","",255],[10,"new","","",84],[10,"self_ty","","",84],[10,"input_types","","",84],[10,"clone","","",256],[10,"clone_from","","",256],[10,"for_item","","",256],[10,"fmt","","",257],[10,"clone","","",257],[10,"clone_from","","",257],[10,"clone","","",258],[10,"clone_from","","",258],[10,"clone","","",259],[10,"clone_from","","",259],[10,"fmt","","",260],[10,"assert_receiver_is_total_eq","","",260],[10,"eq","","",260],[10,"ne","","",260],[10,"ne","","",260],[10,"clone","","",260],[10,"clone_from","","",260],[10,"trait_did","","",260],[10,"mk_substs","","",225],[10,"mk_bare_fn","","",225],[10,"mk_region","","",225],[10,"new","","",232],[10,"for_self","","",232],[10,"for_def","","",232],[10,"to_ty","","",232],[10,"is_self","","",232],[10,"empty","","",258],[10,"is_noop","","",258],[10,"empty","","",240],[10,"clone","","",261],[10,"clone_from","","",261],[10,"when","","",261],[10,"intersects","","",261],[10,"owns_managed","","",261],[10,"owns_owned","","",261],[10,"is_sized","","",261],[10,"interior_param","","",261],[10,"interior_unsafe","","",261],[10,"interior_unsized","","",261],[10,"needs_drop","","",261],[10,"owned_pointer","","Includes only those bits that still apply when indirected through a `Box` pointer",261],[10,"reference","","Includes only those bits that still apply when indirected through a reference (`&`)",261],[10,"managed_pointer","","Includes only those bits that still apply when indirected through a managed pointer (`@`)",261],[10,"unsafe_pointer","","Includes only those bits that still apply when indirected through an unsafe pointer (`*`)",261],[10,"union","","",261],[10,"has_dtor","","",261],[10,"bitor","","",261],[10,"bitand","","",261],[10,"sub","","",261],[10,"fmt","","",261],[10,"fmt","","",262],[10,"eq","","",262],[10,"ne","","",262],[10,"ne","","",262],[10,"assert_receiver_is_total_eq","","",262],[10,"cmp","","",262],[10,"partial_cmp","","",262],[10,"lt","","",262],[10,"le","","",262],[10,"gt","","",262],[10,"ge","","",262],[10,"lt","","",262],[10,"le","","",262],[10,"gt","","",262],[10,"ge","","",262],[10,"repr","","",239],[10,"assert_receiver_is_total_eq","","",263],[10,"eq","","",263],[10,"ne","","",263],[10,"ne","","",263],[10,"partial_cmp","","",263],[10,"lt","","",263],[10,"le","","",263],[10,"gt","","",263],[10,"ge","","",263],[10,"cmp","","",263],[10,"clone","","",264],[10,"clone_from","","",264],[10,"from_ast_variant","","Creates a new VariantInfo from the corresponding ast representation.",264],[10,"is_present","","",265],[10,"has_drop_flag","","",265],[10,"to_string","","",211],[10,"from_mutbl","","",235],[10,"to_mutbl_lossy","","Returns a mutability `m` such that an `&m T` pointer could be used to obtain this borrow\nkind. Because borrow kinds are richer than mutabilities, we sometimes have to pick a\nmutability that is stronger than necessary so that it at least *would permit* the borrow in\nquestion.",235],[10,"to_user_str","","",235],[10,"tcx","","",225],[10,"node_ty","","",225],[10,"expr_ty_adjusted","","",225],[10,"node_method_ty","","",225],[10,"node_method_origin","","",225],[10,"adjustments","","",225],[10,"is_method_call","","",225],[10,"temporary_scope","","",225],[10,"upvar_borrow","","",225],[10,"capture_mode","","",225],[10,"unboxed_closures","","",225],[10,"fmt","","",266],[10,"eq","","",266],[10,"ne","","",266],[10,"ne","","",266],[10,"assert_receiver_is_total_eq","","",266],[10,"clone","","",266],[10,"clone_from","","",266],[10,"decode","","",24],[10,"encode","","",24],[10,"is_identity","","",212],[10,"is_identity","","",214],[10,"new","","",233],[10,"shifted","","",233],[10,"repr","","",212],[10,"repr","","",213],[10,"repr","","",214],[10,"repr","","",215],[10,"repr","","",236],[10,"repr","","",250],[10,"repr","","",222],[10,"has_regions_escaping_depth","rustc::middle::subst","",173],[10,"has_escaping_regions","","",173],[10,"has_regions_escaping_depth","rustc::middle::ty","",257],[10,"has_escaping_regions","","",257],[10,"has_regions_escaping_depth","","",18],[10,"has_escaping_regions","","",18],[10,"has_regions_escaping_depth","","",249],[10,"has_escaping_regions","","",249],[10,"has_regions_escaping_depth","","",250],[10,"has_escaping_regions","","",250],[10,"has_regions_escaping_depth","","",84],[10,"has_escaping_regions","","",84],[10,"has_regions_escaping_depth","rustc::middle::subst","",171],[10,"has_escaping_regions","","",171],[10,"has_regions_escaping_depth","rustc::middle::ty","",91],[10,"has_escaping_regions","","",91],[10,"has_regions_escaping_depth","","",252],[10,"has_escaping_regions","","",252],[10,"has_regions_escaping_depth","","",251],[10,"has_escaping_regions","","",251],[10,"has_regions_escaping_depth","","",253],[10,"has_escaping_regions","","",253],[10,"has_regions_escaping_depth","","",85],[10,"has_escaping_regions","","",85],[10,"has_regions_escaping_depth","","",254],[10,"has_escaping_regions","","",254],[10,"repr","","",85],[10,"has_projection_types","rustc::middle::subst","",173],[10,"has_projection_types","rustc::middle::ty","",255],[10,"has_projection_types","","",250],[10,"has_projection_types","","",251],[10,"has_projection_types","","",252],[10,"has_projection_types","","",18],[10,"has_projection_types","","",253],[10,"has_projection_types","","",85],[10,"has_projection_types","","",254],[10,"has_projection_types","","",84],[10,"has_projection_types","rustc::middle::subst","",170],[10,"has_projection_types","core::option","",14],[10,"has_projection_types","alloc::rc","",83],[10,"has_projection_types","alloc::boxed","",267],[10,"has_projection_types","rustc::middle::ty","",91],[10,"has_projection_types","","",231],[10,"has_projection_types","","",86],[10,"has_projection_types","","",229],[10,"references_error","","",91],[10,"references_error","alloc::rc","",83],[10,"references_error","rustc::middle::ty","",251],[10,"references_error","","",85],[10,"references_error","","",84],[10,"references_error","","",250],[10,"references_error","","",253],[10,"references_error","","",252],[10,"references_error","","",18],[10,"fold_with","core::option","",14],[10,"fold_with","alloc::rc","",83],[10,"fold_with","alloc::boxed","",267],[10,"fold_with","collections::vec","",268],[10,"fold_with","rustc::middle::ty","",91],[10,"fold_with","syntax::owned_slice","",269],[10,"fold_with","rustc::middle::subst","",173],[10,"fold_with","rustc::middle::ty","",22],[10,"fold_with","","",229],[10,"fold_with","","",230],[10,"fold_with","","",207],[10,"fold_with","","",231],[10,"fold_with","","",86],[10,"fold_with","","",84],[10,"fold_with","","",18],[10,"fold_with","rustc::middle::subst","",170],[10,"fold_with","rustc::middle::ty","",258],[10,"fold_with","","",215],[10,"fold_with","","",26],[10,"fold_with","","",222],[10,"fold_with","collections::enum_set","",270],[10,"fold_with","rustc::middle::ty","",241],[10,"fold_with","","",240],[10,"fold_with","","",247],[10,"fold_with","","",248],[10,"fold_with","","",249],[10,"fold_with","","",250],[10,"fold_with","","",85],[10,"fold_with","","",254],[10,"fold_with","","",255],[10,"fold_with","","",213],[10,"fold_with","rustc::middle::traits","",192],[10,"fold_with","","",191],[10,"fold_with","","",194],[10,"fold_with","","",193],[10,"fold_with","rustc::middle::ty","",252],[10,"fold_with","","",251],[10,"fold_with","","",253],[10,"tcx","rustc::middle::ty_fold","",271],[10,"fold_ty","","",271],[10,"enter_region_binder","","",271],[10,"exit_region_binder","","",271],[10,"fold_ty","","",271],[10,"fold_mt","","",271],[10,"fold_trait_ref","","",271],[10,"fold_substs","","",271],[10,"fold_fn_sig","","",271],[10,"fold_output","","",271],[10,"fold_bare_fn_ty","","",271],[10,"fold_closure_ty","","",271],[10,"fold_region","","",271],[10,"fold_trait_store","","",271],[10,"fold_existential_bounds","","",271],[10,"fold_autoref","","",271],[10,"fold_item_substs","","",271],[10,"new","","",272],[10,"tcx","","",272],[10,"enter_region_binder","","",272],[10,"exit_region_binder","","",272],[10,"fold_region","","",272],[10,"enter_region_binder","","",272],[10,"exit_region_binder","","",272],[10,"fold_ty","","",272],[10,"fold_mt","","",272],[10,"fold_trait_ref","","",272],[10,"fold_substs","","",272],[10,"fold_fn_sig","","",272],[10,"fold_output","","",272],[10,"fold_bare_fn_ty","","",272],[10,"fold_closure_ty","","",272],[10,"fold_region","","",272],[10,"fold_trait_store","","",272],[10,"fold_existential_bounds","","",272],[10,"fold_autoref","","",272],[10,"fold_item_substs","","",272],[10,"tcx","","",273],[10,"fold_region","","",273],[10,"enter_region_binder","","",273],[10,"exit_region_binder","","",273],[10,"fold_ty","","",273],[10,"fold_mt","","",273],[10,"fold_trait_ref","","",273],[10,"fold_substs","","",273],[10,"fold_fn_sig","","",273],[10,"fold_output","","",273],[10,"fold_bare_fn_ty","","",273],[10,"fold_closure_ty","","",273],[10,"fold_region","","",273],[10,"fold_trait_store","","",273],[10,"fold_existential_bounds","","",273],[10,"fold_autoref","","",273],[10,"fold_item_substs","","",273],[10,"visit_foreign_item","rustc::middle::weak_lang_items","",274],[10,"visit_name","","",274],[10,"visit_ident","","",274],[10,"visit_mod","","",274],[10,"visit_view_item","","",274],[10,"visit_foreign_item","","",274],[10,"visit_item","","",274],[10,"visit_local","","",274],[10,"visit_block","","",274],[10,"visit_stmt","","",274],[10,"visit_arm","","",274],[10,"visit_pat","","",274],[10,"visit_decl","","",274],[10,"visit_expr","","",274],[10,"visit_expr_post","","",274],[10,"visit_ty","","",274],[10,"visit_generics","","",274],[10,"visit_fn","","",274],[10,"visit_ty_method","","",274],[10,"visit_trait_item","","",274],[10,"visit_trait_ref","","",274],[10,"visit_ty_param_bound","","",274],[10,"visit_poly_trait_ref","","",274],[10,"visit_struct_def","","",274],[10,"visit_struct_field","","",274],[10,"visit_variant","","",274],[10,"visit_opt_lifetime_ref","","",274],[10,"visit_lifetime_bound","","",274],[10,"visit_lifetime_ref","","",274],[10,"visit_lifetime_def","","",274],[10,"visit_explicit_self","","",274],[10,"visit_mac","","",274],[10,"visit_path","","",274],[10,"visit_path_segment","","",274],[10,"visit_path_parameters","","",274],[10,"visit_assoc_type_binding","","",274],[10,"visit_attribute","","",274],[10,"eq","rustc::metadata::common","",275],[10,"ne","","",275],[10,"ne","","",275],[10,"from_uint","","",275],[10,"fmt","","",276],[10,"clone","","",276],[10,"clone_from","","",276],[10,"fmt","rustc::metadata::tydecode","",277],[10,"clone","rustc::metadata::encoder","",278],[10,"clone_from","","",278],[10,"visit_expr","","",279],[10,"visit_item","","",279],[10,"visit_foreign_item","","",279],[10,"visit_name","","",279],[10,"visit_ident","","",279],[10,"visit_mod","","",279],[10,"visit_view_item","","",279],[10,"visit_foreign_item","","",279],[10,"visit_item","","",279],[10,"visit_local","","",279],[10,"visit_block","","",279],[10,"visit_stmt","","",279],[10,"visit_arm","","",279],[10,"visit_pat","","",279],[10,"visit_decl","","",279],[10,"visit_expr","","",279],[10,"visit_expr_post","","",279],[10,"visit_ty","","",279],[10,"visit_generics","","",279],[10,"visit_fn","","",279],[10,"visit_ty_method","","",279],[10,"visit_trait_item","","",279],[10,"visit_trait_ref","","",279],[10,"visit_ty_param_bound","","",279],[10,"visit_poly_trait_ref","","",279],[10,"visit_struct_def","","",279],[10,"visit_struct_field","","",279],[10,"visit_variant","","",279],[10,"visit_opt_lifetime_ref","","",279],[10,"visit_lifetime_bound","","",279],[10,"visit_lifetime_ref","","",279],[10,"visit_lifetime_def","","",279],[10,"visit_explicit_self","","",279],[10,"visit_mac","","",279],[10,"visit_path","","",279],[10,"visit_path_segment","","",279],[10,"visit_path_parameters","","",279],[10,"visit_assoc_type_binding","","",279],[10,"visit_attribute","","",279],[10,"visit_item","","",280],[10,"visit_name","","",280],[10,"visit_ident","","",280],[10,"visit_mod","","",280],[10,"visit_view_item","","",280],[10,"visit_foreign_item","","",280],[10,"visit_item","","",280],[10,"visit_local","","",280],[10,"visit_block","","",280],[10,"visit_stmt","","",280],[10,"visit_arm","","",280],[10,"visit_pat","","",280],[10,"visit_decl","","",280],[10,"visit_expr","","",280],[10,"visit_expr_post","","",280],[10,"visit_ty","","",280],[10,"visit_generics","","",280],[10,"visit_fn","","",280],[10,"visit_ty_method","","",280],[10,"visit_trait_item","","",280],[10,"visit_trait_ref","","",280],[10,"visit_ty_param_bound","","",280],[10,"visit_poly_trait_ref","","",280],[10,"visit_struct_def","","",280],[10,"visit_struct_field","","",280],[10,"visit_variant","","",280],[10,"visit_opt_lifetime_ref","","",280],[10,"visit_lifetime_bound","","",280],[10,"visit_lifetime_ref","","",280],[10,"visit_lifetime_def","","",280],[10,"visit_explicit_self","","",280],[10,"visit_mac","","",280],[10,"visit_path","","",280],[10,"visit_path_segment","","",280],[10,"visit_path_parameters","","",280],[10,"visit_assoc_type_binding","","",280],[10,"visit_attribute","","",280],[10,"eq","rustc::metadata::decoder","",281],[10,"ne","","",281],[10,"ne","","",281],[10,"fmt","","",282],[10,"clone","","",282],[10,"clone_from","","",282],[10,"clone","","",283],[10,"clone_from","","",283],[10,"visit_view_item","rustc::metadata::creader","",284],[10,"visit_item","","",284],[10,"visit_name","","",284],[10,"visit_ident","","",284],[10,"visit_mod","","",284],[10,"visit_view_item","","",284],[10,"visit_foreign_item","","",284],[10,"visit_item","","",284],[10,"visit_local","","",284],[10,"visit_block","","",284],[10,"visit_stmt","","",284],[10,"visit_arm","","",284],[10,"visit_pat","","",284],[10,"visit_decl","","",284],[10,"visit_expr","","",284],[10,"visit_expr_post","","",284],[10,"visit_ty","","",284],[10,"visit_generics","","",284],[10,"visit_fn","","",284],[10,"visit_ty_method","","",284],[10,"visit_trait_item","","",284],[10,"visit_trait_ref","","",284],[10,"visit_ty_param_bound","","",284],[10,"visit_poly_trait_ref","","",284],[10,"visit_struct_def","","",284],[10,"visit_struct_field","","",284],[10,"visit_variant","","",284],[10,"visit_opt_lifetime_ref","","",284],[10,"visit_lifetime_bound","","",284],[10,"visit_lifetime_ref","","",284],[10,"visit_lifetime_def","","",284],[10,"visit_explicit_self","","",284],[10,"visit_mac","","",284],[10,"visit_path","","",284],[10,"visit_path_segment","","",284],[10,"visit_path_parameters","","",284],[10,"visit_assoc_type_binding","","",284],[10,"visit_attribute","","",284],[10,"new","","",285],[10,"read_plugin_metadata","","",285],[10,"clone","rustc::metadata::cstore","",286],[10,"clone_from","","",286],[10,"eq","","",286],[10,"ne","","",286],[10,"ne","","",286],[10,"fmt","","",286],[10,"from_i64","","",287],[10,"from_u64","","",287],[10,"from_int","","",287],[10,"from_i8","","",287],[10,"from_i16","","",287],[10,"from_i32","","",287],[10,"from_uint","","",287],[10,"from_u8","","",287],[10,"from_u16","","",287],[10,"from_u32","","",287],[10,"from_f32","","",287],[10,"from_f64","","",287],[10,"eq","","",287],[10,"ne","","",287],[10,"ne","","",287],[10,"clone","","",287],[10,"clone_from","","",287],[10,"clone","","",288],[10,"clone_from","","",288],[10,"eq","","",288],[10,"ne","","",288],[10,"ne","","",288],[10,"new","","",289],[10,"next_crate_num","","",289],[10,"get_crate_data","","",289],[10,"get_crate_hash","","",289],[10,"set_crate_data","","",289],[10,"iter_crate_data","","",289],[10,"iter_crate_data_origins","","Like `iter_crate_data`, but passes source paths (if available) as well.",289],[10,"add_used_crate_source","","",289],[10,"get_used_crate_source","","",289],[10,"reset","","",289],[10,"get_used_crates","","",289],[10,"add_used_library","","",289],[10,"get_used_libraries","","",289],[10,"add_used_link_args","","",289],[10,"get_used_link_args","","",289],[10,"add_extern_mod_stmt_cnum","","",289],[10,"find_extern_mod_stmt_cnum","","",289],[10,"data","","",290],[10,"name","","",290],[10,"hash","","",290],[10,"as_slice","","",291],[10,"maybe_load_library_crate","rustc::metadata::loader","",292],[10,"load_library_crate","","",292],[10,"report_load_errs","","",292],[10,"as_slice","","",293],[10,"for_each_lib_search_path","rustc::metadata::filesearch","",294],[10,"get_lib_path","","",294],[10,"search","","",294],[10,"new","","",294],[10,"get_dylib_search_paths","","",294],[10,"get_tools_search_paths","","",294],[10,"eq","rustc::session::config","",295],[10,"ne","","",295],[10,"ne","","",295],[10,"clone","","",295],[10,"clone_from","","",295],[10,"eq","","",296],[10,"ne","","",296],[10,"ne","","",296],[10,"clone","","",296],[10,"clone_from","","",296],[10,"assert_receiver_is_total_eq","","",297],[10,"cmp","","",297],[10,"partial_cmp","","",297],[10,"lt","","",297],[10,"le","","",297],[10,"gt","","",297],[10,"ge","","",297],[10,"lt","","",297],[10,"le","","",297],[10,"gt","","",297],[10,"ge","","",297],[10,"eq","","",297],[10,"ne","","",297],[10,"ne","","",297],[10,"clone","","",297],[10,"clone_from","","",297],[10,"clone","","",298],[10,"clone_from","","",298],[10,"assert_receiver_is_total_eq","","",299],[10,"eq","","",299],[10,"ne","","",299],[10,"ne","","",299],[10,"clone","","",299],[10,"clone_from","","",299],[10,"filestem","","",300],[10,"clone","","",301],[10,"clone_from","","",301],[10,"path","","",301],[10,"temp_path","","",301],[10,"with_extension","","",301],[10,"filestem","","",301],[10,"eq","","",302],[10,"ne","","",302],[10,"ne","","",302],[10,"hash","","",303],[10,"assert_receiver_is_total_eq","","",303],[10,"cmp","","",303],[10,"clone","","",303],[10,"clone_from","","",303],[10,"partial_cmp","","",303],[10,"lt","","",303],[10,"le","","",303],[10,"gt","","",303],[10,"ge","","",303],[10,"lt","","",303],[10,"le","","",303],[10,"gt","","",303],[10,"ge","","",303],[10,"eq","","",303],[10,"ne","","",303],[10,"ne","","",303],[10,"clone","","",304],[10,"clone_from","","",304],[10,"is_empty","","",304],[10,"clone","","",305],[10,"clone_from","","",305],[10,"fmt","","",306],[10,"assert_receiver_is_total_eq","","",306],[10,"eq","","",306],[10,"ne","","",306],[10,"ne","","",306],[10,"clone","","",306],[10,"clone_from","","",306],[10,"assert_receiver_is_total_eq","","",307],[10,"eq","","",307],[10,"ne","","",307],[10,"ne","","",307],[10,"clone","","",307],[10,"clone_from","","",307],[10,"is_stable","","",307],[10,"fmt","","",303],[10,"clone","rustc::session::search_paths","",308],[10,"clone_from","","",308],[10,"clone","","",309],[10,"clone_from","","",309],[10,"eq","","",309],[10,"ne","","",309],[10,"ne","","",309],[10,"assert_receiver_is_total_eq","","",309],[10,"new","","",308],[10,"add_path","","",308],[10,"iter","","",308],[10,"next","","",310],[10,"size_hint","","",310],[10,"span_fatal","rustc::session","",311],[10,"fatal","","",311],[10,"span_err","","",311],[10,"span_err_with_code","","",311],[10,"err","","",311],[10,"err_count","","",311],[10,"has_errors","","",311],[10,"abort_if_errors","","",311],[10,"span_warn","","",311],[10,"span_warn_with_code","","",311],[10,"warn","","",311],[10,"opt_span_warn","","",311],[10,"span_note","","",311],[10,"span_end_note","","",311],[10,"span_help","","",311],[10,"fileline_note","","",311],[10,"note","","",311],[10,"help","","",311],[10,"opt_span_bug","","",311],[10,"span_bug","","",311],[10,"bug","","",311],[10,"span_unimpl","","",311],[10,"unimpl","","",311],[10,"add_lint","","",311],[10,"next_node_id","","",311],[10,"reserve_node_ids","","",311],[10,"diagnostic","","",311],[10,"debugging_opt","","",311],[10,"codemap","","",311],[10,"impossible_case","","",311],[10,"verbose","","",311],[10,"time_passes","","",311],[10,"count_llvm_insns","","",311],[10,"count_type_sizes","","",311],[10,"time_llvm_passes","","",311],[10,"trans_stats","","",311],[10,"meta_stats","","",311],[10,"asm_comments","","",311],[10,"no_verify","","",311],[10,"borrowck_stats","","",311],[10,"print_llvm_passes","","",311],[10,"lto","","",311],[10,"no_landing_pads","","",311],[10,"show_span","","",311],[10,"print_enum_sizes","","",311],[10,"sysroot","","",311],[10,"target_filesearch","","",311],[10,"host_filesearch","","",311],[10,"register_syntax_extension","rustc::plugin::registry","Register a syntax extension of any kind.",312],[10,"register_macro","","Register a macro of the usual kind.",312],[10,"register_lint_pass","","Register a compiler lint pass.",312],[10,"register_lint_group","","Register a lint group.",312],[10,"visit_view_item","rustc::plugin::load","",313],[10,"visit_mac","","",313],[10,"visit_name","","",313],[10,"visit_ident","","",313],[10,"visit_mod","","",313],[10,"visit_view_item","","",313],[10,"visit_foreign_item","","",313],[10,"visit_item","","",313],[10,"visit_local","","",313],[10,"visit_block","","",313],[10,"visit_stmt","","",313],[10,"visit_arm","","",313],[10,"visit_pat","","",313],[10,"visit_decl","","",313],[10,"visit_expr","","",313],[10,"visit_expr_post","","",313],[10,"visit_ty","","",313],[10,"visit_generics","","",313],[10,"visit_fn","","",313],[10,"visit_ty_method","","",313],[10,"visit_trait_item","","",313],[10,"visit_trait_ref","","",313],[10,"visit_ty_param_bound","","",313],[10,"visit_poly_trait_ref","","",313],[10,"visit_struct_def","","",313],[10,"visit_struct_field","","",313],[10,"visit_variant","","",313],[10,"visit_opt_lifetime_ref","","",313],[10,"visit_lifetime_bound","","",313],[10,"visit_lifetime_ref","","",313],[10,"visit_lifetime_def","","",313],[10,"visit_explicit_self","","",313],[10,"visit_mac","","",313],[10,"visit_path","","",313],[10,"visit_path_segment","","",313],[10,"visit_path_parameters","","",313],[10,"visit_assoc_type_binding","","",313],[10,"visit_attribute","","",313],[10,"visit_item","rustc::plugin::build","",314],[10,"visit_name","","",314],[10,"visit_ident","","",314],[10,"visit_mod","","",314],[10,"visit_view_item","","",314],[10,"visit_foreign_item","","",314],[10,"visit_item","","",314],[10,"visit_local","","",314],[10,"visit_block","","",314],[10,"visit_stmt","","",314],[10,"visit_arm","","",314],[10,"visit_pat","","",314],[10,"visit_decl","","",314],[10,"visit_expr","","",314],[10,"visit_expr_post","","",314],[10,"visit_ty","","",314],[10,"visit_generics","","",314],[10,"visit_fn","","",314],[10,"visit_ty_method","","",314],[10,"visit_trait_item","","",314],[10,"visit_trait_ref","","",314],[10,"visit_ty_param_bound","","",314],[10,"visit_poly_trait_ref","","",314],[10,"visit_struct_def","","",314],[10,"visit_struct_field","","",314],[10,"visit_variant","","",314],[10,"visit_opt_lifetime_ref","","",314],[10,"visit_lifetime_bound","","",314],[10,"visit_lifetime_ref","","",314],[10,"visit_lifetime_def","","",314],[10,"visit_explicit_self","","",314],[10,"visit_mac","","",314],[10,"visit_path","","",314],[10,"visit_path_segment","","",314],[10,"visit_path_parameters","","",314],[10,"visit_assoc_type_binding","","",314],[10,"visit_attribute","","",314],[10,"name_lower","rustc::lint","Get the lint's name, with ASCII letters converted to lowercase.",315],[10,"clone","","",316],[10,"clone_from","","",316],[10,"eq","","",316],[10,"ne","","",316],[10,"assert_receiver_is_total_eq","","",316],[10,"hash","","",316],[10,"of","","Get the `LintId` for a `Lint`.",316],[10,"as_str","","Get the name of the lint.",316],[10,"cmp","","",317],[10,"assert_receiver_is_total_eq","","",317],[10,"partial_cmp","","",317],[10,"lt","","",317],[10,"le","","",317],[10,"gt","","",317],[10,"ge","","",317],[10,"lt","","",317],[10,"le","","",317],[10,"gt","","",317],[10,"ge","","",317],[10,"eq","","",317],[10,"ne","","",317],[10,"ne","","",317],[10,"clone","","",317],[10,"clone_from","","",317],[10,"as_str","","Convert a level to a lower-case string.",317],[10,"from_str","","Convert a lower-case string to a level.",317],[10,"assert_receiver_is_total_eq","","",318],[10,"eq","","",318],[10,"ne","","",318],[10,"ne","","",318],[10,"clone","","",318],[10,"clone_from","","",318],[10,"get_lints","rustc::lint::builtin","",319],[10,"check_expr","","",319],[10,"check_crate","","",319],[10,"check_ident","","",319],[10,"check_mod","","",319],[10,"check_view_item","","",319],[10,"check_foreign_item","","",319],[10,"check_item","","",319],[10,"check_local","","",319],[10,"check_block","","",319],[10,"check_stmt","","",319],[10,"check_arm","","",319],[10,"check_pat","","",319],[10,"check_decl","","",319],[10,"check_expr","","",319],[10,"check_expr_post","","",319],[10,"check_ty","","",319],[10,"check_generics","","",319],[10,"check_fn","","",319],[10,"check_ty_method","","",319],[10,"check_trait_method","","",319],[10,"check_struct_def","","",319],[10,"check_struct_def_post","","",319],[10,"check_struct_field","","",319],[10,"check_variant","","",319],[10,"check_variant_post","","",319],[10,"check_opt_lifetime_ref","","",319],[10,"check_lifetime_ref","","",319],[10,"check_lifetime_def","","",319],[10,"check_explicit_self","","",319],[10,"check_mac","","",319],[10,"check_path","","",319],[10,"check_attribute","","",319],[10,"enter_lint_attrs","","",319],[10,"exit_lint_attrs","","",319],[10,"get_lints","","",320],[10,"check_expr","","",320],[10,"check_crate","","",320],[10,"check_ident","","",320],[10,"check_mod","","",320],[10,"check_view_item","","",320],[10,"check_foreign_item","","",320],[10,"check_item","","",320],[10,"check_local","","",320],[10,"check_block","","",320],[10,"check_stmt","","",320],[10,"check_arm","","",320],[10,"check_pat","","",320],[10,"check_decl","","",320],[10,"check_expr","","",320],[10,"check_expr_post","","",320],[10,"check_ty","","",320],[10,"check_generics","","",320],[10,"check_fn","","",320],[10,"check_ty_method","","",320],[10,"check_trait_method","","",320],[10,"check_struct_def","","",320],[10,"check_struct_def_post","","",320],[10,"check_struct_field","","",320],[10,"check_variant","","",320],[10,"check_variant_post","","",320],[10,"check_opt_lifetime_ref","","",320],[10,"check_lifetime_ref","","",320],[10,"check_lifetime_def","","",320],[10,"check_explicit_self","","",320],[10,"check_mac","","",320],[10,"check_path","","",320],[10,"check_attribute","","",320],[10,"enter_lint_attrs","","",320],[10,"exit_lint_attrs","","",320],[10,"new","","",321],[10,"get_lints","","",321],[10,"check_expr","","",321],[10,"check_crate","","",321],[10,"check_ident","","",321],[10,"check_mod","","",321],[10,"check_view_item","","",321],[10,"check_foreign_item","","",321],[10,"check_item","","",321],[10,"check_local","","",321],[10,"check_block","","",321],[10,"check_stmt","","",321],[10,"check_arm","","",321],[10,"check_pat","","",321],[10,"check_decl","","",321],[10,"check_expr","","",321],[10,"check_expr_post","","",321],[10,"check_ty","","",321],[10,"check_generics","","",321],[10,"check_fn","","",321],[10,"check_ty_method","","",321],[10,"check_trait_method","","",321],[10,"check_struct_def","","",321],[10,"check_struct_def_post","","",321],[10,"check_struct_field","","",321],[10,"check_variant","","",321],[10,"check_variant_post","","",321],[10,"check_opt_lifetime_ref","","",321],[10,"check_lifetime_ref","","",321],[10,"check_lifetime_def","","",321],[10,"check_explicit_self","","",321],[10,"check_mac","","",321],[10,"check_path","","",321],[10,"check_attribute","","",321],[10,"enter_lint_attrs","","",321],[10,"exit_lint_attrs","","",321],[10,"visit_ty","","",322],[10,"visit_name","","",322],[10,"visit_ident","","",322],[10,"visit_mod","","",322],[10,"visit_view_item","","",322],[10,"visit_foreign_item","","",322],[10,"visit_item","","",322],[10,"visit_local","","",322],[10,"visit_block","","",322],[10,"visit_stmt","","",322],[10,"visit_arm","","",322],[10,"visit_pat","","",322],[10,"visit_decl","","",322],[10,"visit_expr","","",322],[10,"visit_expr_post","","",322],[10,"visit_ty","","",322],[10,"visit_generics","","",322],[10,"visit_fn","","",322],[10,"visit_ty_method","","",322],[10,"visit_trait_item","","",322],[10,"visit_trait_ref","","",322],[10,"visit_ty_param_bound","","",322],[10,"visit_poly_trait_ref","","",322],[10,"visit_struct_def","","",322],[10,"visit_struct_field","","",322],[10,"visit_variant","","",322],[10,"visit_opt_lifetime_ref","","",322],[10,"visit_lifetime_bound","","",322],[10,"visit_lifetime_ref","","",322],[10,"visit_lifetime_def","","",322],[10,"visit_explicit_self","","",322],[10,"visit_mac","","",322],[10,"visit_path","","",322],[10,"visit_path_segment","","",322],[10,"visit_path_parameters","","",322],[10,"visit_assoc_type_binding","","",322],[10,"visit_attribute","","",322],[10,"get_lints","","",323],[10,"check_item","","",323],[10,"check_crate","","",323],[10,"check_ident","","",323],[10,"check_mod","","",323],[10,"check_view_item","","",323],[10,"check_foreign_item","","",323],[10,"check_item","","",323],[10,"check_local","","",323],[10,"check_block","","",323],[10,"check_stmt","","",323],[10,"check_arm","","",323],[10,"check_pat","","",323],[10,"check_decl","","",323],[10,"check_expr","","",323],[10,"check_expr_post","","",323],[10,"check_ty","","",323],[10,"check_generics","","",323],[10,"check_fn","","",323],[10,"check_ty_method","","",323],[10,"check_trait_method","","",323],[10,"check_struct_def","","",323],[10,"check_struct_def_post","","",323],[10,"check_struct_field","","",323],[10,"check_variant","","",323],[10,"check_variant_post","","",323],[10,"check_opt_lifetime_ref","","",323],[10,"check_lifetime_ref","","",323],[10,"check_lifetime_def","","",323],[10,"check_explicit_self","","",323],[10,"check_mac","","",323],[10,"check_path","","",323],[10,"check_attribute","","",323],[10,"enter_lint_attrs","","",323],[10,"exit_lint_attrs","","",323],[10,"get_lints","","",324],[10,"check_item","","",324],[10,"check_expr","","",324],[10,"check_crate","","",324],[10,"check_ident","","",324],[10,"check_mod","","",324],[10,"check_view_item","","",324],[10,"check_foreign_item","","",324],[10,"check_item","","",324],[10,"check_local","","",324],[10,"check_block","","",324],[10,"check_stmt","","",324],[10,"check_arm","","",324],[10,"check_pat","","",324],[10,"check_decl","","",324],[10,"check_expr","","",324],[10,"check_expr_post","","",324],[10,"check_ty","","",324],[10,"check_generics","","",324],[10,"check_fn","","",324],[10,"check_ty_method","","",324],[10,"check_trait_method","","",324],[10,"check_struct_def","","",324],[10,"check_struct_def_post","","",324],[10,"check_struct_field","","",324],[10,"check_variant","","",324],[10,"check_variant_post","","",324],[10,"check_opt_lifetime_ref","","",324],[10,"check_lifetime_ref","","",324],[10,"check_lifetime_def","","",324],[10,"check_explicit_self","","",324],[10,"check_mac","","",324],[10,"check_path","","",324],[10,"check_attribute","","",324],[10,"enter_lint_attrs","","",324],[10,"exit_lint_attrs","","",324],[10,"visit_ty","","",325],[10,"visit_expr","","",325],[10,"visit_block","","",325],[10,"visit_name","","",325],[10,"visit_ident","","",325],[10,"visit_mod","","",325],[10,"visit_view_item","","",325],[10,"visit_foreign_item","","",325],[10,"visit_item","","",325],[10,"visit_local","","",325],[10,"visit_block","","",325],[10,"visit_stmt","","",325],[10,"visit_arm","","",325],[10,"visit_pat","","",325],[10,"visit_decl","","",325],[10,"visit_expr","","",325],[10,"visit_expr_post","","",325],[10,"visit_ty","","",325],[10,"visit_generics","","",325],[10,"visit_fn","","",325],[10,"visit_ty_method","","",325],[10,"visit_trait_item","","",325],[10,"visit_trait_ref","","",325],[10,"visit_ty_param_bound","","",325],[10,"visit_poly_trait_ref","","",325],[10,"visit_struct_def","","",325],[10,"visit_struct_field","","",325],[10,"visit_variant","","",325],[10,"visit_opt_lifetime_ref","","",325],[10,"visit_lifetime_bound","","",325],[10,"visit_lifetime_ref","","",325],[10,"visit_lifetime_def","","",325],[10,"visit_explicit_self","","",325],[10,"visit_mac","","",325],[10,"visit_path","","",325],[10,"visit_path_segment","","",325],[10,"visit_path_parameters","","",325],[10,"visit_assoc_type_binding","","",325],[10,"visit_attribute","","",325],[10,"new","","",326],[10,"get_lints","","",326],[10,"check_item","","",326],[10,"check_crate","","",326],[10,"check_ident","","",326],[10,"check_mod","","",326],[10,"check_view_item","","",326],[10,"check_foreign_item","","",326],[10,"check_item","","",326],[10,"check_local","","",326],[10,"check_block","","",326],[10,"check_stmt","","",326],[10,"check_arm","","",326],[10,"check_pat","","",326],[10,"check_decl","","",326],[10,"check_expr","","",326],[10,"check_expr_post","","",326],[10,"check_ty","","",326],[10,"check_generics","","",326],[10,"check_fn","","",326],[10,"check_ty_method","","",326],[10,"check_trait_method","","",326],[10,"check_struct_def","","",326],[10,"check_struct_def_post","","",326],[10,"check_struct_field","","",326],[10,"check_variant","","",326],[10,"check_variant_post","","",326],[10,"check_opt_lifetime_ref","","",326],[10,"check_lifetime_ref","","",326],[10,"check_lifetime_def","","",326],[10,"check_explicit_self","","",326],[10,"check_mac","","",326],[10,"check_path","","",326],[10,"check_attribute","","",326],[10,"enter_lint_attrs","","",326],[10,"exit_lint_attrs","","",326],[10,"get_lints","","",327],[10,"check_attribute","","",327],[10,"check_crate","","",327],[10,"check_ident","","",327],[10,"check_mod","","",327],[10,"check_view_item","","",327],[10,"check_foreign_item","","",327],[10,"check_item","","",327],[10,"check_local","","",327],[10,"check_block","","",327],[10,"check_stmt","","",327],[10,"check_arm","","",327],[10,"check_pat","","",327],[10,"check_decl","","",327],[10,"check_expr","","",327],[10,"check_expr_post","","",327],[10,"check_ty","","",327],[10,"check_generics","","",327],[10,"check_fn","","",327],[10,"check_ty_method","","",327],[10,"check_trait_method","","",327],[10,"check_struct_def","","",327],[10,"check_struct_def_post","","",327],[10,"check_struct_field","","",327],[10,"check_variant","","",327],[10,"check_variant_post","","",327],[10,"check_opt_lifetime_ref","","",327],[10,"check_lifetime_ref","","",327],[10,"check_lifetime_def","","",327],[10,"check_explicit_self","","",327],[10,"check_mac","","",327],[10,"check_path","","",327],[10,"check_attribute","","",327],[10,"enter_lint_attrs","","",327],[10,"exit_lint_attrs","","",327],[10,"get_lints","","",328],[10,"check_stmt","","",328],[10,"check_crate","","",328],[10,"check_ident","","",328],[10,"check_mod","","",328],[10,"check_view_item","","",328],[10,"check_foreign_item","","",328],[10,"check_item","","",328],[10,"check_local","","",328],[10,"check_block","","",328],[10,"check_stmt","","",328],[10,"check_arm","","",328],[10,"check_pat","","",328],[10,"check_decl","","",328],[10,"check_expr","","",328],[10,"check_expr_post","","",328],[10,"check_ty","","",328],[10,"check_generics","","",328],[10,"check_fn","","",328],[10,"check_ty_method","","",328],[10,"check_trait_method","","",328],[10,"check_struct_def","","",328],[10,"check_struct_def_post","","",328],[10,"check_struct_field","","",328],[10,"check_variant","","",328],[10,"check_variant_post","","",328],[10,"check_opt_lifetime_ref","","",328],[10,"check_lifetime_ref","","",328],[10,"check_lifetime_def","","",328],[10,"check_explicit_self","","",328],[10,"check_mac","","",328],[10,"check_path","","",328],[10,"check_attribute","","",328],[10,"enter_lint_attrs","","",328],[10,"exit_lint_attrs","","",328],[10,"get_lints","","",329],[10,"check_stmt","","",329],[10,"check_crate","","",329],[10,"check_ident","","",329],[10,"check_mod","","",329],[10,"check_view_item","","",329],[10,"check_foreign_item","","",329],[10,"check_item","","",329],[10,"check_local","","",329],[10,"check_block","","",329],[10,"check_stmt","","",329],[10,"check_arm","","",329],[10,"check_pat","","",329],[10,"check_decl","","",329],[10,"check_expr","","",329],[10,"check_expr_post","","",329],[10,"check_ty","","",329],[10,"check_generics","","",329],[10,"check_fn","","",329],[10,"check_ty_method","","",329],[10,"check_trait_method","","",329],[10,"check_struct_def","","",329],[10,"check_struct_def_post","","",329],[10,"check_struct_field","","",329],[10,"check_variant","","",329],[10,"check_variant_post","","",329],[10,"check_opt_lifetime_ref","","",329],[10,"check_lifetime_ref","","",329],[10,"check_lifetime_def","","",329],[10,"check_explicit_self","","",329],[10,"check_mac","","",329],[10,"check_path","","",329],[10,"check_attribute","","",329],[10,"enter_lint_attrs","","",329],[10,"exit_lint_attrs","","",329],[10,"get_lints","","",330],[10,"check_item","","",330],[10,"check_generics","","",330],[10,"check_crate","","",330],[10,"check_ident","","",330],[10,"check_mod","","",330],[10,"check_view_item","","",330],[10,"check_foreign_item","","",330],[10,"check_item","","",330],[10,"check_local","","",330],[10,"check_block","","",330],[10,"check_stmt","","",330],[10,"check_arm","","",330],[10,"check_pat","","",330],[10,"check_decl","","",330],[10,"check_expr","","",330],[10,"check_expr_post","","",330],[10,"check_ty","","",330],[10,"check_generics","","",330],[10,"check_fn","","",330],[10,"check_ty_method","","",330],[10,"check_trait_method","","",330],[10,"check_struct_def","","",330],[10,"check_struct_def_post","","",330],[10,"check_struct_field","","",330],[10,"check_variant","","",330],[10,"check_variant_post","","",330],[10,"check_opt_lifetime_ref","","",330],[10,"check_lifetime_ref","","",330],[10,"check_lifetime_def","","",330],[10,"check_explicit_self","","",330],[10,"check_mac","","",330],[10,"check_path","","",330],[10,"check_attribute","","",330],[10,"enter_lint_attrs","","",330],[10,"exit_lint_attrs","","",330],[10,"eq","","",331],[10,"ne","","",331],[10,"ne","","",331],[10,"get_lints","","",332],[10,"check_fn","","",332],[10,"check_item","","",332],[10,"check_ty_method","","",332],[10,"check_lifetime_def","","",332],[10,"check_pat","","",332],[10,"check_struct_def","","",332],[10,"check_crate","","",332],[10,"check_ident","","",332],[10,"check_mod","","",332],[10,"check_view_item","","",332],[10,"check_foreign_item","","",332],[10,"check_item","","",332],[10,"check_local","","",332],[10,"check_block","","",332],[10,"check_stmt","","",332],[10,"check_arm","","",332],[10,"check_pat","","",332],[10,"check_decl","","",332],[10,"check_expr","","",332],[10,"check_expr_post","","",332],[10,"check_ty","","",332],[10,"check_generics","","",332],[10,"check_fn","","",332],[10,"check_ty_method","","",332],[10,"check_trait_method","","",332],[10,"check_struct_def","","",332],[10,"check_struct_def_post","","",332],[10,"check_struct_field","","",332],[10,"check_variant","","",332],[10,"check_variant_post","","",332],[10,"check_opt_lifetime_ref","","",332],[10,"check_lifetime_ref","","",332],[10,"check_lifetime_def","","",332],[10,"check_explicit_self","","",332],[10,"check_mac","","",332],[10,"check_path","","",332],[10,"check_attribute","","",332],[10,"enter_lint_attrs","","",332],[10,"exit_lint_attrs","","",332],[10,"get_lints","","",333],[10,"check_item","","",333],[10,"check_pat","","",333],[10,"check_crate","","",333],[10,"check_ident","","",333],[10,"check_mod","","",333],[10,"check_view_item","","",333],[10,"check_foreign_item","","",333],[10,"check_item","","",333],[10,"check_local","","",333],[10,"check_block","","",333],[10,"check_stmt","","",333],[10,"check_arm","","",333],[10,"check_pat","","",333],[10,"check_decl","","",333],[10,"check_expr","","",333],[10,"check_expr_post","","",333],[10,"check_ty","","",333],[10,"check_generics","","",333],[10,"check_fn","","",333],[10,"check_ty_method","","",333],[10,"check_trait_method","","",333],[10,"check_struct_def","","",333],[10,"check_struct_def_post","","",333],[10,"check_struct_field","","",333],[10,"check_variant","","",333],[10,"check_variant_post","","",333],[10,"check_opt_lifetime_ref","","",333],[10,"check_lifetime_ref","","",333],[10,"check_lifetime_def","","",333],[10,"check_explicit_self","","",333],[10,"check_mac","","",333],[10,"check_path","","",333],[10,"check_attribute","","",333],[10,"enter_lint_attrs","","",333],[10,"exit_lint_attrs","","",333],[10,"get_lints","","",334],[10,"check_expr","","",334],[10,"check_stmt","","",334],[10,"check_crate","","",334],[10,"check_ident","","",334],[10,"check_mod","","",334],[10,"check_view_item","","",334],[10,"check_foreign_item","","",334],[10,"check_item","","",334],[10,"check_local","","",334],[10,"check_block","","",334],[10,"check_stmt","","",334],[10,"check_arm","","",334],[10,"check_pat","","",334],[10,"check_decl","","",334],[10,"check_expr","","",334],[10,"check_expr_post","","",334],[10,"check_ty","","",334],[10,"check_generics","","",334],[10,"check_fn","","",334],[10,"check_ty_method","","",334],[10,"check_trait_method","","",334],[10,"check_struct_def","","",334],[10,"check_struct_def_post","","",334],[10,"check_struct_field","","",334],[10,"check_variant","","",334],[10,"check_variant_post","","",334],[10,"check_opt_lifetime_ref","","",334],[10,"check_lifetime_ref","","",334],[10,"check_lifetime_def","","",334],[10,"check_explicit_self","","",334],[10,"check_mac","","",334],[10,"check_path","","",334],[10,"check_attribute","","",334],[10,"enter_lint_attrs","","",334],[10,"exit_lint_attrs","","",334],[10,"get_lints","","",335],[10,"check_view_item","","",335],[10,"check_crate","","",335],[10,"check_ident","","",335],[10,"check_mod","","",335],[10,"check_view_item","","",335],[10,"check_foreign_item","","",335],[10,"check_item","","",335],[10,"check_local","","",335],[10,"check_block","","",335],[10,"check_stmt","","",335],[10,"check_arm","","",335],[10,"check_pat","","",335],[10,"check_decl","","",335],[10,"check_expr","","",335],[10,"check_expr_post","","",335],[10,"check_ty","","",335],[10,"check_generics","","",335],[10,"check_fn","","",335],[10,"check_ty_method","","",335],[10,"check_trait_method","","",335],[10,"check_struct_def","","",335],[10,"check_struct_def_post","","",335],[10,"check_struct_field","","",335],[10,"check_variant","","",335],[10,"check_variant_post","","",335],[10,"check_opt_lifetime_ref","","",335],[10,"check_lifetime_ref","","",335],[10,"check_lifetime_def","","",335],[10,"check_explicit_self","","",335],[10,"check_mac","","",335],[10,"check_path","","",335],[10,"check_attribute","","",335],[10,"enter_lint_attrs","","",335],[10,"exit_lint_attrs","","",335],[10,"get_lints","","",336],[10,"check_pat","","",336],[10,"check_crate","","",336],[10,"check_ident","","",336],[10,"check_mod","","",336],[10,"check_view_item","","",336],[10,"check_foreign_item","","",336],[10,"check_item","","",336],[10,"check_local","","",336],[10,"check_block","","",336],[10,"check_stmt","","",336],[10,"check_arm","","",336],[10,"check_pat","","",336],[10,"check_decl","","",336],[10,"check_expr","","",336],[10,"check_expr_post","","",336],[10,"check_ty","","",336],[10,"check_generics","","",336],[10,"check_fn","","",336],[10,"check_ty_method","","",336],[10,"check_trait_method","","",336],[10,"check_struct_def","","",336],[10,"check_struct_def_post","","",336],[10,"check_struct_field","","",336],[10,"check_variant","","",336],[10,"check_variant_post","","",336],[10,"check_opt_lifetime_ref","","",336],[10,"check_lifetime_ref","","",336],[10,"check_lifetime_def","","",336],[10,"check_explicit_self","","",336],[10,"check_mac","","",336],[10,"check_path","","",336],[10,"check_attribute","","",336],[10,"enter_lint_attrs","","",336],[10,"exit_lint_attrs","","",336],[10,"get_lints","","",337],[10,"check_expr","","",337],[10,"check_crate","","",337],[10,"check_ident","","",337],[10,"check_mod","","",337],[10,"check_view_item","","",337],[10,"check_foreign_item","","",337],[10,"check_item","","",337],[10,"check_local","","",337],[10,"check_block","","",337],[10,"check_stmt","","",337],[10,"check_arm","","",337],[10,"check_pat","","",337],[10,"check_decl","","",337],[10,"check_expr","","",337],[10,"check_expr_post","","",337],[10,"check_ty","","",337],[10,"check_generics","","",337],[10,"check_fn","","",337],[10,"check_ty_method","","",337],[10,"check_trait_method","","",337],[10,"check_struct_def","","",337],[10,"check_struct_def_post","","",337],[10,"check_struct_field","","",337],[10,"check_variant","","",337],[10,"check_variant_post","","",337],[10,"check_opt_lifetime_ref","","",337],[10,"check_lifetime_ref","","",337],[10,"check_lifetime_def","","",337],[10,"check_explicit_self","","",337],[10,"check_mac","","",337],[10,"check_path","","",337],[10,"check_attribute","","",337],[10,"enter_lint_attrs","","",337],[10,"exit_lint_attrs","","",337],[10,"get_lints","","",338],[10,"check_expr","","",338],[10,"check_crate","","",338],[10,"check_ident","","",338],[10,"check_mod","","",338],[10,"check_view_item","","",338],[10,"check_foreign_item","","",338],[10,"check_item","","",338],[10,"check_local","","",338],[10,"check_block","","",338],[10,"check_stmt","","",338],[10,"check_arm","","",338],[10,"check_pat","","",338],[10,"check_decl","","",338],[10,"check_expr","","",338],[10,"check_expr_post","","",338],[10,"check_ty","","",338],[10,"check_generics","","",338],[10,"check_fn","","",338],[10,"check_ty_method","","",338],[10,"check_trait_method","","",338],[10,"check_struct_def","","",338],[10,"check_struct_def_post","","",338],[10,"check_struct_field","","",338],[10,"check_variant","","",338],[10,"check_variant_post","","",338],[10,"check_opt_lifetime_ref","","",338],[10,"check_lifetime_ref","","",338],[10,"check_lifetime_def","","",338],[10,"check_explicit_self","","",338],[10,"check_mac","","",338],[10,"check_path","","",338],[10,"check_attribute","","",338],[10,"enter_lint_attrs","","",338],[10,"exit_lint_attrs","","",338],[10,"get_lints","","",339],[10,"check_expr","","",339],[10,"check_stmt","","",339],[10,"check_fn","","",339],[10,"check_crate","","",339],[10,"check_ident","","",339],[10,"check_mod","","",339],[10,"check_view_item","","",339],[10,"check_foreign_item","","",339],[10,"check_item","","",339],[10,"check_local","","",339],[10,"check_block","","",339],[10,"check_stmt","","",339],[10,"check_arm","","",339],[10,"check_pat","","",339],[10,"check_decl","","",339],[10,"check_expr","","",339],[10,"check_expr_post","","",339],[10,"check_ty","","",339],[10,"check_generics","","",339],[10,"check_fn","","",339],[10,"check_ty_method","","",339],[10,"check_trait_method","","",339],[10,"check_struct_def","","",339],[10,"check_struct_def_post","","",339],[10,"check_struct_field","","",339],[10,"check_variant","","",339],[10,"check_variant_post","","",339],[10,"check_opt_lifetime_ref","","",339],[10,"check_lifetime_ref","","",339],[10,"check_lifetime_def","","",339],[10,"check_explicit_self","","",339],[10,"check_mac","","",339],[10,"check_path","","",339],[10,"check_attribute","","",339],[10,"enter_lint_attrs","","",339],[10,"exit_lint_attrs","","",339],[10,"get_lints","","",340],[10,"check_expr","","",340],[10,"check_crate","","",340],[10,"check_ident","","",340],[10,"check_mod","","",340],[10,"check_view_item","","",340],[10,"check_foreign_item","","",340],[10,"check_item","","",340],[10,"check_local","","",340],[10,"check_block","","",340],[10,"check_stmt","","",340],[10,"check_arm","","",340],[10,"check_pat","","",340],[10,"check_decl","","",340],[10,"check_expr","","",340],[10,"check_expr_post","","",340],[10,"check_ty","","",340],[10,"check_generics","","",340],[10,"check_fn","","",340],[10,"check_ty_method","","",340],[10,"check_trait_method","","",340],[10,"check_struct_def","","",340],[10,"check_struct_def_post","","",340],[10,"check_struct_field","","",340],[10,"check_variant","","",340],[10,"check_variant_post","","",340],[10,"check_opt_lifetime_ref","","",340],[10,"check_lifetime_ref","","",340],[10,"check_lifetime_def","","",340],[10,"check_explicit_self","","",340],[10,"check_mac","","",340],[10,"check_path","","",340],[10,"check_attribute","","",340],[10,"enter_lint_attrs","","",340],[10,"exit_lint_attrs","","",340],[10,"new","","",341],[10,"get_lints","","",341],[10,"enter_lint_attrs","","",341],[10,"exit_lint_attrs","","",341],[10,"check_struct_def","","",341],[10,"check_struct_def_post","","",341],[10,"check_crate","","",341],[10,"check_item","","",341],[10,"check_fn","","",341],[10,"check_ty_method","","",341],[10,"check_struct_field","","",341],[10,"check_variant","","",341],[10,"check_variant_post","","",341],[10,"check_crate","","",341],[10,"check_ident","","",341],[10,"check_mod","","",341],[10,"check_view_item","","",341],[10,"check_foreign_item","","",341],[10,"check_item","","",341],[10,"check_local","","",341],[10,"check_block","","",341],[10,"check_stmt","","",341],[10,"check_arm","","",341],[10,"check_pat","","",341],[10,"check_decl","","",341],[10,"check_expr","","",341],[10,"check_expr_post","","",341],[10,"check_ty","","",341],[10,"check_generics","","",341],[10,"check_fn","","",341],[10,"check_ty_method","","",341],[10,"check_trait_method","","",341],[10,"check_struct_def","","",341],[10,"check_struct_def_post","","",341],[10,"check_struct_field","","",341],[10,"check_variant","","",341],[10,"check_variant_post","","",341],[10,"check_opt_lifetime_ref","","",341],[10,"check_lifetime_ref","","",341],[10,"check_lifetime_def","","",341],[10,"check_explicit_self","","",341],[10,"check_mac","","",341],[10,"check_path","","",341],[10,"check_attribute","","",341],[10,"enter_lint_attrs","","",341],[10,"exit_lint_attrs","","",341],[10,"get_lints","","",342],[10,"check_item","","",342],[10,"check_crate","","",342],[10,"check_ident","","",342],[10,"check_mod","","",342],[10,"check_view_item","","",342],[10,"check_foreign_item","","",342],[10,"check_item","","",342],[10,"check_local","","",342],[10,"check_block","","",342],[10,"check_stmt","","",342],[10,"check_arm","","",342],[10,"check_pat","","",342],[10,"check_decl","","",342],[10,"check_expr","","",342],[10,"check_expr_post","","",342],[10,"check_ty","","",342],[10,"check_generics","","",342],[10,"check_fn","","",342],[10,"check_ty_method","","",342],[10,"check_trait_method","","",342],[10,"check_struct_def","","",342],[10,"check_struct_def_post","","",342],[10,"check_struct_field","","",342],[10,"check_variant","","",342],[10,"check_variant_post","","",342],[10,"check_opt_lifetime_ref","","",342],[10,"check_lifetime_ref","","",342],[10,"check_lifetime_def","","",342],[10,"check_explicit_self","","",342],[10,"check_mac","","",342],[10,"check_path","","",342],[10,"check_attribute","","",342],[10,"enter_lint_attrs","","",342],[10,"exit_lint_attrs","","",342],[10,"get_lints","","",343],[10,"check_view_item","","",343],[10,"check_expr","","",343],[10,"check_item","","",343],[10,"check_crate","","",343],[10,"check_ident","","",343],[10,"check_mod","","",343],[10,"check_view_item","","",343],[10,"check_foreign_item","","",343],[10,"check_item","","",343],[10,"check_local","","",343],[10,"check_block","","",343],[10,"check_stmt","","",343],[10,"check_arm","","",343],[10,"check_pat","","",343],[10,"check_decl","","",343],[10,"check_expr","","",343],[10,"check_expr_post","","",343],[10,"check_ty","","",343],[10,"check_generics","","",343],[10,"check_fn","","",343],[10,"check_ty_method","","",343],[10,"check_trait_method","","",343],[10,"check_struct_def","","",343],[10,"check_struct_def_post","","",343],[10,"check_struct_field","","",343],[10,"check_variant","","",343],[10,"check_variant_post","","",343],[10,"check_opt_lifetime_ref","","",343],[10,"check_lifetime_ref","","",343],[10,"check_lifetime_def","","",343],[10,"check_explicit_self","","",343],[10,"check_mac","","",343],[10,"check_path","","",343],[10,"check_attribute","","",343],[10,"enter_lint_attrs","","",343],[10,"exit_lint_attrs","","",343],[10,"get_lints","","",344],[10,"check_crate","","",344],[10,"check_ident","","",344],[10,"check_mod","","",344],[10,"check_view_item","","",344],[10,"check_foreign_item","","",344],[10,"check_item","","",344],[10,"check_local","","",344],[10,"check_block","","",344],[10,"check_stmt","","",344],[10,"check_arm","","",344],[10,"check_pat","","",344],[10,"check_decl","","",344],[10,"check_expr","","",344],[10,"check_expr_post","","",344],[10,"check_ty","","",344],[10,"check_generics","","",344],[10,"check_fn","","",344],[10,"check_ty_method","","",344],[10,"check_trait_method","","",344],[10,"check_struct_def","","",344],[10,"check_struct_def_post","","",344],[10,"check_struct_field","","",344],[10,"check_variant","","",344],[10,"check_variant_post","","",344],[10,"check_opt_lifetime_ref","","",344],[10,"check_lifetime_ref","","",344],[10,"check_lifetime_def","","",344],[10,"check_explicit_self","","",344],[10,"check_mac","","",344],[10,"check_path","","",344],[10,"check_attribute","","",344],[10,"enter_lint_attrs","","",344],[10,"exit_lint_attrs","","",344],[10,"new","rustc::lint::context","",345],[10,"get_lints","","",345],[10,"get_lint_groups","","",345],[10,"register_pass","","",345],[10,"register_group","","",345],[10,"register_builtin","","",345],[10,"process_command_line","","",345],[10,"sess","","Get the overall compiler `Session` object.",346],[10,"current_level","","Get the level of `lint` at the current position of the lint\ntraversal.",346],[10,"lint","","Emit a lint at the appropriate level, with no associated span.",346],[10,"span_lint","","Emit a lint at the appropriate level, for a particular span.",346],[10,"visit_item","","",346],[10,"visit_foreign_item","","",346],[10,"visit_view_item","","",346],[10,"visit_pat","","",346],[10,"visit_expr","","",346],[10,"visit_stmt","","",346],[10,"visit_fn","","",346],[10,"visit_ty_method","","",346],[10,"visit_struct_def","","",346],[10,"visit_struct_field","","",346],[10,"visit_variant","","",346],[10,"visit_ty","","",346],[10,"visit_ident","","",346],[10,"visit_mod","","",346],[10,"visit_local","","",346],[10,"visit_block","","",346],[10,"visit_arm","","",346],[10,"visit_decl","","",346],[10,"visit_expr_post","","",346],[10,"visit_generics","","",346],[10,"visit_trait_item","","",346],[10,"visit_opt_lifetime_ref","","",346],[10,"visit_lifetime_ref","","",346],[10,"visit_lifetime_def","","",346],[10,"visit_explicit_self","","",346],[10,"visit_mac","","",346],[10,"visit_path","","",346],[10,"visit_attribute","","",346],[10,"visit_name","","",346],[10,"visit_ident","","",346],[10,"visit_mod","","",346],[10,"visit_view_item","","",346],[10,"visit_foreign_item","","",346],[10,"visit_item","","",346],[10,"visit_local","","",346],[10,"visit_block","","",346],[10,"visit_stmt","","",346],[10,"visit_arm","","",346],[10,"visit_pat","","",346],[10,"visit_decl","","",346],[10,"visit_expr","","",346],[10,"visit_expr_post","","",346],[10,"visit_ty","","",346],[10,"visit_generics","","",346],[10,"visit_fn","","",346],[10,"visit_ty_method","","",346],[10,"visit_trait_item","","",346],[10,"visit_trait_ref","","",346],[10,"visit_ty_param_bound","","",346],[10,"visit_poly_trait_ref","","",346],[10,"visit_struct_def","","",346],[10,"visit_struct_field","","",346],[10,"visit_variant","","",346],[10,"visit_opt_lifetime_ref","","",346],[10,"visit_lifetime_bound","","",346],[10,"visit_lifetime_ref","","",346],[10,"visit_lifetime_def","","",346],[10,"visit_explicit_self","","",346],[10,"visit_mac","","",346],[10,"visit_path","","",346],[10,"visit_path_segment","","",346],[10,"visit_path_parameters","","",346],[10,"visit_assoc_type_binding","","",346],[10,"visit_attribute","","",346],[10,"visit_id","","",346],[10,"get_lints","","",347],[10,"check_item","","",347],[10,"check_crate","","",347],[10,"check_ident","","",347],[10,"check_mod","","",347],[10,"check_view_item","","",347],[10,"check_foreign_item","","",347],[10,"check_item","","",347],[10,"check_local","","",347],[10,"check_block","","",347],[10,"check_stmt","","",347],[10,"check_arm","","",347],[10,"check_pat","","",347],[10,"check_decl","","",347],[10,"check_expr","","",347],[10,"check_expr_post","","",347],[10,"check_ty","","",347],[10,"check_generics","","",347],[10,"check_fn","","",347],[10,"check_ty_method","","",347],[10,"check_trait_method","","",347],[10,"check_struct_def","","",347],[10,"check_struct_def_post","","",347],[10,"check_struct_field","","",347],[10,"check_variant","","",347],[10,"check_variant_post","","",347],[10,"check_opt_lifetime_ref","","",347],[10,"check_lifetime_ref","","",347],[10,"check_lifetime_def","","",347],[10,"check_explicit_self","","",347],[10,"check_mac","","",347],[10,"check_path","","",347],[10,"check_attribute","","",347],[10,"enter_lint_attrs","","",347],[10,"exit_lint_attrs","","",347],[10,"fmt","rustc::util::common","",348],[10,"clone","","",348],[10,"clone_from","","",348],[10,"drop","","",349],[10,"visit_expr","","",350],[10,"visit_name","","",350],[10,"visit_ident","","",350],[10,"visit_mod","","",350],[10,"visit_view_item","","",350],[10,"visit_foreign_item","","",350],[10,"visit_item","","",350],[10,"visit_local","","",350],[10,"visit_block","","",350],[10,"visit_stmt","","",350],[10,"visit_arm","","",350],[10,"visit_pat","","",350],[10,"visit_decl","","",350],[10,"visit_expr","","",350],[10,"visit_expr_post","","",350],[10,"visit_ty","","",350],[10,"visit_generics","","",350],[10,"visit_fn","","",350],[10,"visit_ty_method","","",350],[10,"visit_trait_item","","",350],[10,"visit_trait_ref","","",350],[10,"visit_ty_param_bound","","",350],[10,"visit_poly_trait_ref","","",350],[10,"visit_struct_def","","",350],[10,"visit_struct_field","","",350],[10,"visit_variant","","",350],[10,"visit_opt_lifetime_ref","","",350],[10,"visit_lifetime_bound","","",350],[10,"visit_lifetime_ref","","",350],[10,"visit_lifetime_def","","",350],[10,"visit_explicit_self","","",350],[10,"visit_mac","","",350],[10,"visit_path","","",350],[10,"visit_path_segment","","",350],[10,"visit_path_parameters","","",350],[10,"visit_assoc_type_binding","","",350],[10,"visit_attribute","","",350],[10,"visit_expr","","",351],[10,"visit_name","","",351],[10,"visit_ident","","",351],[10,"visit_mod","","",351],[10,"visit_view_item","","",351],[10,"visit_foreign_item","","",351],[10,"visit_item","","",351],[10,"visit_local","","",351],[10,"visit_block","","",351],[10,"visit_stmt","","",351],[10,"visit_arm","","",351],[10,"visit_pat","","",351],[10,"visit_decl","","",351],[10,"visit_expr","","",351],[10,"visit_expr_post","","",351],[10,"visit_ty","","",351],[10,"visit_generics","","",351],[10,"visit_fn","","",351],[10,"visit_ty_method","","",351],[10,"visit_trait_item","","",351],[10,"visit_trait_ref","","",351],[10,"visit_ty_param_bound","","",351],[10,"visit_poly_trait_ref","","",351],[10,"visit_struct_def","","",351],[10,"visit_struct_field","","",351],[10,"visit_variant","","",351],[10,"visit_opt_lifetime_ref","","",351],[10,"visit_lifetime_bound","","",351],[10,"visit_lifetime_ref","","",351],[10,"visit_lifetime_def","","",351],[10,"visit_explicit_self","","",351],[10,"visit_mac","","",351],[10,"visit_path","","",351],[10,"visit_path_segment","","",351],[10,"visit_path_parameters","","",351],[10,"visit_assoc_type_binding","","",351],[10,"visit_attribute","","",351],[10,"repr","core::option","",14],[10,"repr","syntax::ptr","",352],[10,"repr","core::result","",129],[10,"repr","alloc::rc","",83],[10,"repr","alloc::boxed","",267],[10,"repr","syntax::owned_slice","",269],[10,"repr","collections::vec","",268],[10,"user_string","","",268],[10,"repr","rustc::middle::def","",17],[10,"repr","rustc::middle::ty","",247],[10,"repr","","",248],[10,"repr","","",226],[10,"repr","","",207],[10,"repr","rustc::middle::subst","",170],[10,"repr","","",173],[10,"repr","rustc::middle::ty","",258],[10,"repr","rustc::middle::subst","",171],[10,"repr","collections::enum_set","",270],[10,"repr","rustc::middle::ty","",241],[10,"repr","","",240],[10,"repr","","",84],[10,"repr","","",353],[10,"repr","syntax::ast","",354],[10,"repr","","",150],[10,"repr","","",355],[10,"user_string","","",355],[10,"repr","","",356],[10,"repr","","",357],[10,"repr","","",358],[10,"repr","syntax::codemap","",359],[10,"repr","syntax::ast","",151],[10,"repr","rustc::middle::ty","",21],[10,"repr","","",18],[10,"user_string","","",18],[10,"repr","","",19],[10,"repr","syntax::ast","",13],[10,"repr","rustc::middle::ty","",257],[10,"repr","","",249],[10,"repr","","",255],[10,"repr","","",210],[10,"repr","","",211],[10,"repr","","",205],[10,"repr","syntax::ast","",10],[10,"user_string","","",10],[10,"repr","","",9],[10,"repr","","",360],[10,"repr","","",361],[10,"repr","rustc::middle::ty","",229],[10,"repr","","",86],[10,"repr","","",231],[10,"repr","","",219],[10,"repr","","",26],[10,"repr","","",217],[10,"repr","","",218],[10,"repr","","",22],[10,"repr","","",242],[10,"user_string","","",242],[10,"repr","syntax::codemap","",15],[10,"user_string","alloc::rc","",83],[10,"user_string","rustc::middle::ty","",240],[10,"user_string","","",241],[10,"user_string","collections::enum_set","",270],[10,"user_string","rustc::middle::ty","",91],[10,"user_string","","",84],[10,"user_string","syntax::ast","",9],[10,"repr","syntax::abi","",362],[10,"user_string","","",362],[10,"repr","rustc::middle::ty","",234],[10,"repr","syntax::ast","",363],[10,"repr","rustc::middle::ty","",235],[10,"repr","","",25],[10,"repr","","",118],[10,"repr","","",120],[10,"repr","","",244],[10,"repr","","",243],[10,"repr","","",119],[10,"repr","syntax::ast","",364],[10,"repr","","",365],[10,"repr","","",121],[10,"repr","rustc::middle::ty","",266],[10,"user_string","","",232],[10,"repr","","",232],[10,"repr","","",91],[10,"repr","std::collections::hash::map","",366],[10,"repr","rustc::middle::ty","",253],[10,"user_string","","",253],[10,"repr","","",252],[10,"user_string","","",252],[10,"repr","","",251],[10,"user_string","","",251],[10,"user_string","","",85],[10,"repr","","",254],[10,"user_string","","",254],[10,"user_string","","",250],[10,"default","rustc::util::nodemap","",367],[10,"clone","","",367],[10,"clone_from","","",367],[10,"hash","","",367],[10,"write","","",368],[10,"eq","rustc::util::snapshot_vec","",369],[10,"ne","","",369],[10,"ne","","",369],[10,"new","","",370],[10,"record","","",370],[10,"push","","",370],[10,"get","","",370],[10,"get_mut","","Returns a mutable pointer into the vec; whatever changes you make here cannot be undone\nautomatically, so you should be sure call `record()` with some sort of suitable undo\naction.",370],[10,"set","","Updates the element at the given index. The old value will saved (and perhaps restored) if\na snapshot is active.",370],[10,"start_snapshot","","",370],[10,"actions_since_snapshot","","",370],[10,"rollback_to","","",370],[10,"commit","","Commits all changes since the last snapshot. Of course, they\ncan still be undone if there is a snapshot further out.",370],[10,"input","rustc_back::sha2","",371],[10,"reset","","",371],[10,"zero_until","","",371],[10,"next","","",371],[10,"full_buffer","","",371],[10,"position","","",371],[10,"remaining","","",371],[10,"size","","",371],[10,"new","","Construct a new instance of a SHA-256 digest.",372],[10,"input","","",372],[10,"result","","",372],[10,"reset","","",372],[10,"output_bits","","",372],[10,"input_str","","",372],[10,"result_bytes","","",372],[10,"result_str","","",372],[10,"open","rustc_llvm::archive_ro","Opens a static archive for read-only purposes. This is more optimized\nthan the `open` method because it uses LLVM's internal `Archive` class\nrather than shelling out to `ar` for everything.",373],[10,"read","","Reads a file in the archive",373],[10,"drop","","",373],[10,"describe","rustc_llvm::diagnostic","",374],[10,"unpack","","",375],[10,"eq","rustc_llvm","",376],[10,"ne","","",376],[10,"ne","","",376],[10,"fmt","","",377],[10,"hash","","",378],[10,"cmp","","",378],[10,"partial_cmp","","",378],[10,"lt","","",378],[10,"le","","",378],[10,"gt","","",378],[10,"ge","","",378],[10,"lt","","",378],[10,"le","","",378],[10,"gt","","",378],[10,"ge","","",378],[10,"clone","","",378],[10,"clone_from","","",378],[10,"assert_receiver_is_total_eq","","",378],[10,"eq","","",378],[10,"ne","","",378],[10,"ne","","",378],[10,"empty","","Returns an empty set of flags.",378],[10,"all","","Returns the set containing all flags.",378],[10,"bits","","Returns the raw value of the flags currently stored.",378],[10,"from_bits","","Convert from underlying bit representation, unless that\nrepresentation contains bits that do not correspond to a flag.",378],[10,"from_bits_truncate","","Convert from underlying bit representation, dropping any bits\nthat do not correspond to flags.",378],[10,"is_empty","","Returns `true` if no flags are currently stored.",378],[10,"is_all","","Returns `true` if all flags are currently set.",378],[10,"intersects","","Returns `true` if there are flags common to both `self` and `other`.",378],[10,"contains","","Returns `true` all of the flags in `other` are contained within `self`.",378],[10,"insert","","Inserts the specified flags in-place.",378],[10,"remove","","Removes the specified flags in-place.",378],[10,"toggle","","Toggles the specified flags in-place.",378],[10,"bitor","","Returns the union of the two sets of flags.",378],[10,"bitxor","","Returns the left flags, but with all the right flags toggled.",378],[10,"bitand","","Returns the intersection between the two sets of flags.",378],[10,"sub","","Returns the set difference of the two sets of flags.",378],[10,"not","","Returns the complement of this set of flags.",378],[10,"apply_llfn","","",378],[10,"apply_callsite","","",378],[10,"apply_llfn","","",379],[10,"apply_callsite","","",379],[10,"apply_llfn","","",380],[10,"apply_callsite","","",380],[10,"new","","",381],[10,"arg","","",381],[10,"ret","","",381],[10,"apply_llfn","","",381],[10,"apply_callsite","","",381],[10,"eq","","",382],[10,"ne","","",382],[10,"ne","","",382],[10,"clone","","",383],[10,"clone_from","","",383],[10,"eq","","",383],[10,"ne","","",383],[10,"ne","","",383],[10,"eq","","",384],[10,"ne","","",384],[10,"ne","","",384],[10,"drop","","",385],[10,"new","","",386],[10,"drop","","",386],[10,"drop","","",387],[4,"Node","rustc_borrowck::graphviz",""],[4,"Edge","",""]],"paths":[[1,"FnPartsWithCFG"],[1,"DataflowLabeller"],[2,"Variant"],[1,"Archive"],[1,"ArchiveBuilder"],[1,"Svh"],[2,"SawAbiComponent"],[2,"SawExprComponent"],[2,"SawStmtComponent"],[1,"Ident"],[1,"Name"],[1,"StrictVersionHashVisitor"],[1,"DecodeContext"],[1,"DefId"],[2,"Option"],[1,"Span"],[1,"NestedItemsDropper"],[2,"Def"],[2,"Region"],[1,"FreeRegion"],[2,"CodeExtent"],[2,"BoundRegion"],[2,"TraitStore"],[1,"Decoder"],[1,"Freevar"],[1,"UpvarBorrow"],[2,"MethodOrigin"],[1,"EncodeContext"],[1,"Encoder"],[1,"SideTableEncodingIdVisitor"],[1,"Doc"],[1,"LabelledCFG"],[1,"CFG"],[1,"CheckCrateVisitor"],[1,"CheckCrateVisitor"],[1,"CheckItemRecursionVisitor"],[2,"Context"],[1,"CheckLoopVisitor"],[1,"Matrix"],[2,"Constructor"],[2,"Usefulness"],[1,"MatchCheckCtxt"],[1,"StaticInliner"],[1,"MutationChecker"],[1,"AtBindingPatternVisitor"],[1,"RvalueContext"],[1,"RvalueContextDelegate"],[2,"Mode"],[1,"CheckStaticVisitor"],[1,"GlobalVisitor"],[1,"GlobalChecker"],[1,"ConstEvalVisitor"],[2,"const_val"],[2,"EntryOrExit"],[1,"DataFlowContext"],[1,"Union"],[1,"Subtract"],[1,"MarkSymbolVisitor"],[1,"LifeSeeder"],[1,"DeadVisitor"],[2,"MethodProvenance"],[2,"TyParamProvenance"],[2,"TraitItemKind"],[2,"UnsafeContext"],[1,"EffectCheckVisitor"],[1,"EntryContext"],[2,"LoanCause"],[2,"ConsumeMode"],[2,"MoveReason"],[2,"MatchMode"],[2,"TrackMatchMode"],[2,"MutateMode"],[1,"ExprUseVisitor"],[2,"SimplifiedType"],[1,"Edge"],[1,"NodeIndex"],[1,"EdgeIndex"],[1,"Direction"],[1,"Graph"],[1,"DepthFirstTraversal"],[1,"IntrinsicCheckingVisitor"],[1,"TransmuteRestriction"],[1,"Coerce"],[1,"Rc"],[1,"TraitRef"],[1,"ProjectionPredicate"],[1,"FnSig"],[1,"CombineFields"],[1,"Generalizer"],[1,"Equate"],[1,"InferCtxt"],[1,"Binder"],[1,"Glb"],[1,"Lub"],[2,"Node"],[1,"ConstraintGraph"],[2,"Constraint"],[1,"TwoRegions"],[2,"UndoLogEntry"],[2,"CombineMapType"],[2,"RegionResolutionError"],[1,"SameRegions"],[1,"RegionSnapshot"],[1,"RegionVarBindings"],[2,"Classification"],[2,"Verify"],[2,"VarValue"],[1,"RegionAndOrigin"],[1,"OpportunisticTypeResolver"],[1,"FullTypeResolver"],[1,"TypeFreshener"],[1,"Sub"],[2,"RelationDir"],[1,"TypeVariableTable"],[1,"Delegate"],[2,"VarValue"],[1,"UnificationTable"],[1,"Delegate"],[1,"IntVid"],[2,"IntVarValue"],[1,"FloatVid"],[2,"FloatTy"],[2,"TypeOrigin"],[2,"ValuePairs"],[1,"TypeTrace"],[2,"SubregionOrigin"],[2,"LateBoundRegionConversionTime"],[2,"RegionVariableOrigin"],[2,"fixup_err"],[2,"Result"],[2,"LangItem"],[1,"LanguageItems"],[1,"LanguageItemCollector"],[1,"Variable"],[1,"LiveNode"],[2,"LiveNodeKind"],[1,"IrMaps"],[1,"LocalInfo"],[2,"VarKind"],[1,"Liveness"],[1,"Users"],[2,"categorization"],[1,"Upvar"],[2,"PointerKind"],[2,"InteriorKind"],[2,"FieldName"],[2,"ElementKind"],[2,"MutabilityCategory"],[2,"Note"],[1,"cmt_"],[1,"Expr"],[1,"Pat"],[1,"MemCategorizationContext"],[2,"LastPrivate"],[2,"PrivateDep"],[2,"ImportUse"],[1,"ParentVisitor"],[1,"EmbargoVisitor"],[1,"PrivacyVisitor"],[1,"SanePrivacyVisitor"],[1,"CheckTypeForPrivatenessVisitor"],[1,"VisiblePrivateTypesVisitor"],[1,"ReachableContext"],[1,"RegionMaps"],[1,"RegionResolutionVisitor"],[2,"DefRegion"],[1,"LifetimeContext"],[2,"ScopeChain"],[1,"Annotator"],[1,"Index"],[1,"Substs"],[2,"RegionSubsts"],[2,"ParamSpace"],[1,"VecPerParamSpace"],[1,"EnumeratedItems"],[1,"SubstFolder"],[1,"FulfillmentContext"],[1,"RegionObligation"],[1,"MismatchedProjectionTypes"],[1,"AssociatedTypeNormalizer"],[2,"ProjectionTyError"],[2,"ProjectionTyCandidate"],[1,"SelectionCache"],[2,"MethodMatchedData"],[2,"SelectionCandidate"],[2,"EvaluationResult"],[1,"SelectionContext"],[1,"TraitObligationStack"],[2,"MethodMatchResult"],[1,"Elaborator"],[1,"Supertraits"],[1,"VtableImplData"],[1,"Obligation"],[2,"Vtable"],[1,"VtableBuiltinData"],[2,"SelectionError"],[1,"FulfillmentError"],[2,"FulfillmentErrorCode"],[1,"ObligationCause"],[2,"ObligationCauseCode"],[1,"DerivedObligationCause"],[1,"field"],[2,"ImplOrTraitItemContainer"],[2,"ImplOrTraitItem"],[2,"ImplOrTraitItemId"],[1,"Method"],[1,"AssociatedType"],[1,"mt"],[1,"field_ty"],[1,"creader_cache_key"],[1,"ItemVariances"],[2,"Variance"],[2,"AutoAdjustment"],[2,"UnsizeKind"],[1,"AutoDerefRef"],[2,"AutoRef"],[1,"param_index"],[1,"MethodParam"],[1,"MethodObject"],[1,"MethodCallee"],[1,"MethodCall"],[2,"ExprAdjustment"],[2,"vtable_origin"],[1,"CtxtArenas"],[1,"TypeFlags"],[1,"ctxt"],[1,"TyS"],[1,"InternedTy"],[2,"sty"],[1,"BareFnTy"],[1,"ClosureTy"],[2,"FnOutput"],[1,"ParamTy"],[1,"DebruijnIndex"],[1,"UpvarId"],[2,"BorrowKind"],[1,"TyTrait"],[2,"terr_vstore_kind"],[1,"expected_found"],[2,"type_err"],[1,"ParamBounds"],[1,"ExistentialBounds"],[2,"BuiltinBound"],[1,"TyVid"],[1,"RegionVid"],[2,"InferTy"],[2,"InferRegion"],[1,"TypeParameterDef"],[1,"RegionParameterDef"],[1,"Generics"],[2,"Predicate"],[1,"TraitPredicate"],[1,"EquatePredicate"],[1,"OutlivesPredicate"],[1,"ProjectionTy"],[1,"GenericBounds"],[1,"ParameterEnvironment"],[1,"TypeScheme"],[1,"ItemSubsts"],[1,"UnboxedClosure"],[2,"UnboxedClosureKind"],[1,"TypeContents"],[2,"Representability"],[1,"AssociatedTypeInfo"],[1,"VariantInfo"],[2,"DtorKind"],[2,"ExplicitSelfCategory"],[1,"Box"],[1,"Vec"],[1,"OwnedSlice"],[1,"EnumSet"],[1,"BottomUpFolder"],[1,"RegionFolder"],[1,"RegionEraser"],[1,"Context"],[2,"astencode_tag"],[1,"LinkMeta"],[2,"DefIdSource"],[1,"entry"],[1,"EncodeVisitor"],[1,"ImplVisitor"],[2,"Family"],[2,"DefLike"],[1,"CrateDep"],[1,"Env"],[1,"PluginMetadataReader"],[2,"LinkagePreference"],[2,"NativeLibraryKind"],[1,"CrateSource"],[1,"CStore"],[1,"crate_metadata"],[2,"MetadataBlob"],[1,"Context"],[1,"ArchiveMetadata"],[1,"FileSearch"],[2,"OptLevel"],[2,"DebugInfoLevel"],[2,"OutputType"],[1,"Options"],[2,"PrintRequest"],[2,"Input"],[1,"OutputFilenames"],[2,"EntryFnType"],[2,"CrateType"],[2,"Passes"],[1,"CodegenOptions"],[2,"OptionStability"],[1,"RustcOptGroup"],[1,"SearchPaths"],[2,"PathKind"],[1,"Iter"],[1,"Session"],[1,"Registry"],[1,"PluginLoader"],[1,"RegistrarFinder"],[1,"Lint"],[1,"LintId"],[2,"Level"],[2,"LintSource"],[1,"WhileTrue"],[1,"UnusedCasts"],[1,"TypeLimits"],[1,"ImproperCTypesVisitor"],[1,"ImproperCTypes"],[1,"BoxPointers"],[1,"RawPtrDerivingVisitor"],[1,"RawPointerDeriving"],[1,"UnusedAttributes"],[1,"PathStatements"],[1,"UnusedResults"],[1,"NonCamelCaseTypes"],[2,"MethodContext"],[1,"NonSnakeCase"],[1,"NonUpperCaseGlobals"],[1,"UnusedParens"],[1,"UnusedImportBraces"],[1,"NonShorthandFieldPatterns"],[1,"UnusedUnsafe"],[1,"UnsafeBlocks"],[1,"UnusedMut"],[1,"UnusedAllocation"],[1,"MissingDoc"],[1,"MissingCopyImplementations"],[1,"Stability"],[1,"HardwiredLints"],[1,"LintStore"],[1,"Context"],[1,"GatherNodeLevels"],[1,"ErrorReported"],[1,"Indenter"],[1,"LoopQueryVisitor"],[1,"BlockQueryVisitor"],[1,"P"],[1,"TraitDef"],[2,"TraitItem"],[1,"Path"],[1,"Ty"],[1,"Item"],[1,"Lifetime"],[1,"Spanned"],[2,"ExplicitSelf_"],[2,"Visibility"],[2,"Abi"],[2,"Mutability"],[2,"IntTy"],[2,"UintTy"],[1,"HashMap"],[1,"FnvHasher"],[1,"FnvState"],[2,"UndoLog"],[1,"SnapshotVec"],[1,"FixedBuffer64"],[1,"Sha256"],[1,"ArchiveRO"],[2,"OptimizationDiagnosticKind"],[2,"Diagnostic"],[2,"CallConv"],[2,"DiagnosticSeverity"],[1,"Attribute"],[2,"OtherAttribute"],[2,"SpecialAttribute"],[1,"AttrBuilder"],[2,"TypeKind"],[2,"CodeGenOptLevel"],[2,"RelocMode"],[1,"TargetData"],[1,"ObjectFile"],[1,"SectionIter"]]};

searchIndex['rustc_trans'] = {"items":[[0,"","rustc_trans","The Rust compiler."],[0,"back","",""],[0,"link","rustc_trans::back",""],[3,"find_crate_name","rustc_trans::back::link",""],[3,"build_link_meta","",""],[3,"sanitize","",""],[3,"mangle","",""],[3,"exported_name","",""],[3,"mangle_exported_name","",""],[3,"mangle_internal_name_by_type_and_seq","",""],[3,"mangle_internal_name_by_path_and_seq","",""],[3,"get_cc_prog","",""],[3,"remove","",""],[3,"link_binary","","Perform the linkage portion of the compilation phase. This will generate all\nof the requested outputs for this compilation session."],[3,"default_output_for_target","","Returns default crate type for target"],[3,"invalid_output_for_target","","Checks if target supports crate_type as output"],[3,"filename_for_input","",""],[18,"RLIB_BYTECODE_OBJECT_MAGIC","",""],[18,"RLIB_BYTECODE_OBJECT_VERSION","",""],[18,"RLIB_BYTECODE_OBJECT_VERSION_OFFSET","",""],[18,"RLIB_BYTECODE_OBJECT_V1_DATASIZE_OFFSET","",""],[18,"RLIB_BYTECODE_OBJECT_V1_DATA_OFFSET","",""],[0,"lto","rustc_trans::back",""],[3,"run","rustc_trans::back::lto",""],[0,"write","rustc_trans::back",""],[2,"OutputType","rustc_trans::back::write",""],[12,"OutputTypeBitcode","","",0],[12,"OutputTypeAssembly","","",0],[12,"OutputTypeLlvmAssembly","","",0],[12,"OutputTypeObject","","",0],[12,"OutputTypeExe","","",0],[3,"llvm_err","",""],[3,"write_output_file","",""],[3,"run_passes","",""],[3,"run_assembler","",""],[10,"cmp","","",0],[10,"partial_cmp","","",0],[10,"lt","","",0],[10,"le","","",0],[10,"gt","","",0],[10,"ge","","",0],[10,"eq","","",0],[10,"ne","","",0],[10,"clone","","",0],[0,"abi","rustc_trans::back",""],[18,"BOX_FIELD_DROP_GLUE","rustc_trans::back::abi",""],[18,"BOX_FIELD_BODY","",""],[18,"FAT_PTR_ADDR","","The first half of a fat pointer.\n- For a closure, this is the code address.\n- For an object or trait instance, this is the address of the box.\n- For a slice, this is the base address."],[18,"FAT_PTR_EXTRA","","The second half of a fat pointer.\n- For a closure, this is the address of the environment.\n- For an object or trait instance, this is the address of the vtable.\n- For a slice, this is the length."],[0,"archive","rustc_trans::back","A helper class for dealing with static archives"],[5,"METADATA_FILENAME","rustc_trans::back::archive",""],[10,"open","rustc_back::archive","Opens an existing static archive",1],[10,"remove_file","","Removes a file from this archive",1],[10,"files","","Lists all files in an archive",1],[10,"extend","","Creates an `ArchiveBuilder` for adding files to this archive.",1],[10,"create","","Create a new static archive, ready for adding files.",2],[10,"add_native_library","","Adds all of the contents of a native library to this archive. This will\nsearch in the relevant locations for a library named `name`.",2],[10,"add_rlib","","Adds all of the contents of the rlib at the specified path to this\narchive.",2],[10,"add_file","","Adds an arbitrary file to this archive",2],[10,"update_symbols","","Indicate that the next call to `build` should updates all symbols in\nthe archive (run 'ar s' over it).",2],[10,"build","","Combine the provided files, rlibs, and native libraries into a single\n`Archive`.",2],[10,"input","rustc_back::sha2","",3],[10,"reset","","",3],[10,"zero_until","","",3],[10,"next","","",3],[10,"full_buffer","","",3],[10,"position","","",3],[10,"remaining","","",3],[10,"size","","",3],[10,"new","","Construct a new instance of a SHA-256 digest.",4],[10,"input","","",4],[10,"result","","",4],[10,"reset","","",4],[10,"output_bits","","",4],[10,"input_str","","",4],[10,"result_bytes","","",4],[10,"result_str","","",4],[10,"eq","rustc_back::svh","",5],[10,"ne","","",5],[10,"ne","","",5],[10,"clone","","",5],[10,"clone_from","","",5],[10,"new","","",5],[10,"as_str","","",5],[10,"calculate","","",5],[10,"fmt","","",5],[10,"hash","rustc_back::svh::svh_visitor","",6],[10,"hash","","",7],[10,"hash","","",8],[10,"get_content","syntax::ast","",9],[10,"get_content","","",10],[10,"visit_mac","rustc_back::svh::svh_visitor","",11],[10,"visit_struct_def","","",11],[10,"visit_variant","","",11],[10,"visit_opt_lifetime_ref","","",11],[10,"visit_ident","","",11],[10,"visit_lifetime_ref","","",11],[10,"visit_lifetime_def","","",11],[10,"visit_expr","","",11],[10,"visit_stmt","","",11],[10,"visit_view_item","","",11],[10,"visit_foreign_item","","",11],[10,"visit_item","","",11],[10,"visit_mod","","",11],[10,"visit_decl","","",11],[10,"visit_ty","","",11],[10,"visit_generics","","",11],[10,"visit_fn","","",11],[10,"visit_ty_method","","",11],[10,"visit_trait_item","","",11],[10,"visit_struct_field","","",11],[10,"visit_explicit_self","","",11],[10,"visit_path","","",11],[10,"visit_block","","",11],[10,"visit_pat","","",11],[10,"visit_local","","",11],[10,"visit_arm","","",11],[10,"visit_name","","",11],[10,"visit_ident","","",11],[10,"visit_mod","","",11],[10,"visit_view_item","","",11],[10,"visit_foreign_item","","",11],[10,"visit_item","","",11],[10,"visit_local","","",11],[10,"visit_block","","",11],[10,"visit_stmt","","",11],[10,"visit_arm","","",11],[10,"visit_pat","","",11],[10,"visit_decl","","",11],[10,"visit_expr","","",11],[10,"visit_expr_post","","",11],[10,"visit_ty","","",11],[10,"visit_generics","","",11],[10,"visit_fn","","",11],[10,"visit_ty_method","","",11],[10,"visit_trait_item","","",11],[10,"visit_trait_ref","","",11],[10,"visit_ty_param_bound","","",11],[10,"visit_poly_trait_ref","","",11],[10,"visit_struct_def","","",11],[10,"visit_struct_field","","",11],[10,"visit_variant","","",11],[10,"visit_opt_lifetime_ref","","",11],[10,"visit_lifetime_bound","","",11],[10,"visit_lifetime_ref","","",11],[10,"visit_lifetime_def","","",11],[10,"visit_explicit_self","","",11],[10,"visit_mac","","",11],[10,"visit_path","","",11],[10,"visit_path_segment","","",11],[10,"visit_path_parameters","","",11],[10,"visit_assoc_type_binding","","",11],[10,"visit_attribute","","",11],[10,"fmt","rustc_back::target","",12],[10,"clone","","",12],[10,"clone_from","","",12],[10,"fmt","","",13],[10,"clone","","",13],[10,"clone_from","","",13],[10,"default","","Create a set of \"sane defaults\" for any target. This is still incomplete, and if used for\ncompilation, will certainly not work.",13],[10,"adjust_abi","","Given a function ABI, turn \"System\" into the correct ABI for this target.",12],[10,"from_json","","Load a target descriptor from a JSON object.",12],[10,"search","","Search RUST_TARGET_PATH for a JSON file specifying the given target triple. Note that it\ncould also just be a bare filename already, so also check for that. If one of the hardcoded\ntargets we know about, just return it directly.",12],[1,"ArchiveConfig","rustc_trans::back::archive",""],[11,"handler","","",14],[11,"dst","","",14],[11,"lib_search_paths","","",14],[11,"slib_prefix","","",14],[11,"slib_suffix","","",14],[11,"maybe_ar_prog","","",14],[1,"Archive","",""],[1,"ArchiveBuilder","","Helper for adding many files to an archive with a single invocation of\n`ar`."],[3,"find_library","",""],[0,"arm","rustc_trans::back",""],[3,"get_target_strs","rustc_trans::back::arm",""],[0,"mips","rustc_trans::back",""],[3,"get_target_strs","rustc_trans::back::mips",""],[0,"mipsel","rustc_trans::back",""],[3,"get_target_strs","rustc_trans::back::mipsel",""],[0,"rpath","rustc_trans::back",""],[1,"RPathConfig","rustc_trans::back::rpath",""],[11,"used_crates","","",15],[11,"out_filename","","",15],[11,"is_like_osx","","",15],[11,"has_rpath","","",15],[11,"get_install_prefix_lib_path","","",15],[11,"realpath","","",15],[3,"get_rpath_flags","",""],[0,"svh","rustc_trans::back","Calculation and management of a Strict Version Hash for crates"],[1,"Svh","rustc_trans::back::svh",""],[0,"target_strs","rustc_trans::back",""],[1,"t","rustc_trans::back::target_strs",""],[11,"module_asm","","",16],[11,"data_layout","","",16],[11,"target_triple","","",16],[11,"cc_args","","",16],[0,"x86","rustc_trans::back",""],[3,"get_target_strs","rustc_trans::back::x86",""],[0,"x86_64","rustc_trans::back",""],[3,"get_target_strs","rustc_trans::back::x86_64",""],[0,"trans","rustc_trans",""],[1,"CrateContext","rustc_trans::trans",""],[1,"ModuleTranslation","",""],[11,"llcx","","",17],[11,"llmod","","",17],[1,"CrateTranslation","",""],[11,"modules","","",18],[11,"metadata_module","","",18],[11,"link","","",18],[11,"metadata","","",18],[11,"reachable","","",18],[11,"crate_formats","","",18],[11,"no_builtins","","",18],[3,"trans_crate","",""],[3,"gensym_name","","Generates a unique symbol based off the name given. This is used to create\nunique symbols for things like closures."],[10,"shared","","",19],[10,"local","","",19],[10,"rotate","","Get a (possibly) different `CrateContext` from the same\n`SharedCrateContext`.",19],[10,"maybe_iter","","Either iterate over only `self`, or iterate over all `CrateContext`s in\nthe `SharedCrateContext`.  The iterator produces `(ccx, is_origin)`\npairs, where `is_origin` is `true` if `ccx` is `self` and `false`\notherwise.  This method is useful for avoiding code duplication in\ncases where it may or may not be necessary to translate code into every\ncontext.",19],[10,"tcx","","",19],[10,"sess","","",19],[10,"builder","","",19],[10,"raw_builder","","",19],[10,"tydesc_type","","",19],[10,"get_intrinsic","","",19],[10,"is_split_stack_supported","","",19],[10,"llmod","","",19],[10,"llcx","","",19],[10,"td","","",19],[10,"tn","","",19],[10,"externs","","",19],[10,"item_vals","","",19],[10,"export_map","","",19],[10,"reachable","","",19],[10,"item_symbols","","",19],[10,"link_meta","","",19],[10,"needs_unwind_cleanup_cache","","",19],[10,"fn_pointer_shims","","",19],[10,"drop_glues","","",19],[10,"tydescs","","",19],[10,"finished_tydescs","","",19],[10,"external","","",19],[10,"external_srcs","","",19],[10,"monomorphized","","",19],[10,"monomorphizing","","",19],[10,"vtables","","",19],[10,"const_cstr_cache","","",19],[10,"const_globals","","",19],[10,"const_values","","",19],[10,"static_values","","",19],[10,"extern_const_values","","",19],[10,"impl_method_cache","","",19],[10,"closure_bare_wrapper_cache","","",19],[10,"lltypes","","",19],[10,"llsizingtypes","","",19],[10,"adt_reprs","","",19],[10,"symbol_hasher","","",19],[10,"type_hashcodes","","",19],[10,"all_llvm_symbols","","",19],[10,"stats","","",19],[10,"available_monomorphizations","","",19],[10,"available_drop_glues","","",19],[10,"int_type","","",19],[10,"opaque_vec_type","","",19],[10,"unboxed_closure_vals","","",19],[10,"dbg_cx","","",19],[10,"eh_personality","","",19],[10,"count_llvm_insn","","",19],[10,"trait_cache","","",19],[10,"obj_size_bound","","Return exclusive upper bound on object size.",19],[10,"report_overbig_object","","",19],[10,"llrepr","rustc_trans::trans::llrepr","",20],[0,"save","rustc_trans","Output a CSV file containing the output from rustc's analysis. The data is\nprimarily designed to be used as input to the DXR tool, specifically its\nRust plugin. It could also be used by IDEs or other code browsing, search, or\ncross-referencing tools."],[3,"process_crate","rustc_trans::save",""],[0,"lib","rustc_trans",""],[0,"llvm","rustc_trans::lib",""],[0,"archive_ro","rustc_trans::lib::llvm","A wrapper around LLVM's archive (.a) code"],[10,"open","rustc_llvm::archive_ro","Opens a static archive for read-only purposes. This is more optimized\nthan the `open` method because it uses LLVM's internal `Archive` class\nrather than shelling out to `ar` for everything.",21],[10,"read","","Reads a file in the archive",21],[10,"drop","","",21],[10,"describe","rustc_llvm::diagnostic","",22],[10,"unpack","","",23],[10,"eq","rustc_llvm","",24],[10,"ne","","",24],[10,"ne","","",24],[10,"fmt","","",25],[10,"hash","","",26],[10,"cmp","","",26],[10,"partial_cmp","","",26],[10,"lt","","",26],[10,"le","","",26],[10,"gt","","",26],[10,"ge","","",26],[10,"lt","","",26],[10,"le","","",26],[10,"gt","","",26],[10,"ge","","",26],[10,"clone","","",26],[10,"clone_from","","",26],[10,"assert_receiver_is_total_eq","","",26],[10,"eq","","",26],[10,"ne","","",26],[10,"ne","","",26],[10,"empty","","Returns an empty set of flags.",26],[10,"all","","Returns the set containing all flags.",26],[10,"bits","","Returns the raw value of the flags currently stored.",26],[10,"from_bits","","Convert from underlying bit representation, unless that\nrepresentation contains bits that do not correspond to a flag.",26],[10,"from_bits_truncate","","Convert from underlying bit representation, dropping any bits\nthat do not correspond to flags.",26],[10,"is_empty","","Returns `true` if no flags are currently stored.",26],[10,"is_all","","Returns `true` if all flags are currently set.",26],[10,"intersects","","Returns `true` if there are flags common to both `self` and `other`.",26],[10,"contains","","Returns `true` all of the flags in `other` are contained within `self`.",26],[10,"insert","","Inserts the specified flags in-place.",26],[10,"remove","","Removes the specified flags in-place.",26],[10,"toggle","","Toggles the specified flags in-place.",26],[10,"bitor","","Returns the union of the two sets of flags.",26],[10,"bitxor","","Returns the left flags, but with all the right flags toggled.",26],[10,"bitand","","Returns the intersection between the two sets of flags.",26],[10,"sub","","Returns the set difference of the two sets of flags.",26],[10,"not","","Returns the complement of this set of flags.",26],[10,"apply_llfn","","",26],[10,"apply_callsite","","",26],[10,"apply_llfn","","",27],[10,"apply_callsite","","",27],[10,"apply_llfn","","",28],[10,"apply_callsite","","",28],[10,"new","","",29],[10,"arg","","",29],[10,"ret","","",29],[10,"apply_llfn","","",29],[10,"apply_callsite","","",29],[10,"eq","","",30],[10,"ne","","",30],[10,"ne","","",30],[10,"clone","","",31],[10,"clone_from","","",31],[10,"eq","","",31],[10,"ne","","",31],[10,"ne","","",31],[10,"eq","","",32],[10,"ne","","",32],[10,"ne","","",32],[10,"drop","","",33],[10,"new","","",34],[10,"drop","","",34],[10,"drop","","",35],[1,"ArchiveRO","rustc_trans::lib::llvm::archive_ro",""],[0,"diagnostic","rustc_trans::lib::llvm","LLVM diagnostic reports."],[2,"OptimizationDiagnosticKind","rustc_trans::lib::llvm::diagnostic",""],[12,"OptimizationRemark","","",22],[12,"OptimizationMissed","","",22],[12,"OptimizationAnalysis","","",22],[12,"OptimizationFailure","","",22],[1,"OptimizationDiagnostic","",""],[11,"kind","","",36],[11,"pass_name","","",36],[11,"function","","",36],[11,"debug_loc","","",36],[11,"message","","",36],[2,"Diagnostic","",""],[12,"Optimization","","",23],[12,"UnknownDiagnostic","","LLVM has other types that we do not wrap here.",23],[4,"Opcode","rustc_trans::lib::llvm",""],[4,"Bool","",""],[18,"True","",""],[18,"False","",""],[2,"CallConv","",""],[12,"CCallConv","","",24],[12,"FastCallConv","","",24],[12,"ColdCallConv","","",24],[12,"X86StdcallCallConv","","",24],[12,"X86FastcallCallConv","","",24],[12,"X86_64_Win64","","",24],[2,"Visibility","",""],[12,"LLVMDefaultVisibility","","",37],[12,"HiddenVisibility","","",37],[12,"ProtectedVisibility","","",37],[2,"Linkage","",""],[12,"ExternalLinkage","","",38],[12,"AvailableExternallyLinkage","","",38],[12,"LinkOnceAnyLinkage","","",38],[12,"LinkOnceODRLinkage","","",38],[12,"WeakAnyLinkage","","",38],[12,"WeakODRLinkage","","",38],[12,"AppendingLinkage","","",38],[12,"InternalLinkage","","",38],[12,"PrivateLinkage","","",38],[12,"ExternalWeakLinkage","","",38],[12,"CommonLinkage","","",38],[2,"DiagnosticSeverity","",""],[12,"Error","","",25],[12,"Warning","","",25],[12,"Remark","","",25],[12,"Note","","",25],[1,"Attribute","",""],[18,"ZExtAttribute","",""],[18,"SExtAttribute","",""],[18,"NoReturnAttribute","",""],[18,"InRegAttribute","",""],[18,"StructRetAttribute","",""],[18,"NoUnwindAttribute","",""],[18,"NoAliasAttribute","",""],[18,"ByValAttribute","",""],[18,"NestAttribute","",""],[18,"ReadNoneAttribute","",""],[18,"ReadOnlyAttribute","",""],[18,"NoInlineAttribute","",""],[18,"AlwaysInlineAttribute","",""],[18,"OptimizeForSizeAttribute","",""],[18,"StackProtectAttribute","",""],[18,"StackProtectReqAttribute","",""],[18,"AlignmentAttribute","",""],[18,"NoCaptureAttribute","",""],[18,"NoRedZoneAttribute","",""],[18,"NoImplicitFloatAttribute","",""],[18,"NakedAttribute","",""],[18,"InlineHintAttribute","",""],[18,"StackAttribute","",""],[18,"ReturnsTwiceAttribute","",""],[18,"UWTableAttribute","",""],[18,"NonLazyBindAttribute","",""],[2,"OtherAttribute","",""],[12,"SanitizeAddressAttribute","","",27],[12,"MinSizeAttribute","","",27],[12,"NoDuplicateAttribute","","",27],[12,"StackProtectStrongAttribute","","",27],[12,"SanitizeThreadAttribute","","",27],[12,"SanitizeMemoryAttribute","","",27],[12,"NoBuiltinAttribute","","",27],[12,"ReturnedAttribute","","",27],[12,"ColdAttribute","","",27],[12,"BuiltinAttribute","","",27],[12,"OptimizeNoneAttribute","","",27],[12,"InAllocaAttribute","","",27],[12,"NonNullAttribute","","",27],[2,"SpecialAttribute","",""],[12,"DereferenceableAttribute","","",28],[2,"AttributeSet","",""],[12,"ReturnIndex","","",39],[12,"FunctionIndex","","",39],[6,"AttrHelper","",""],[9,"apply_llfn","","",40],[9,"apply_callsite","","",40],[1,"AttrBuilder","",""],[2,"IntPredicate","",""],[12,"IntEQ","","",41],[12,"IntNE","","",41],[12,"IntUGT","","",41],[12,"IntUGE","","",41],[12,"IntULT","","",41],[12,"IntULE","","",41],[12,"IntSGT","","",41],[12,"IntSGE","","",41],[12,"IntSLT","","",41],[12,"IntSLE","","",41],[2,"RealPredicate","",""],[12,"RealPredicateFalse","","",42],[12,"RealOEQ","","",42],[12,"RealOGT","","",42],[12,"RealOGE","","",42],[12,"RealOLT","","",42],[12,"RealOLE","","",42],[12,"RealONE","","",42],[12,"RealORD","","",42],[12,"RealUNO","","",42],[12,"RealUEQ","","",42],[12,"RealUGT","","",42],[12,"RealUGE","","",42],[12,"RealULT","","",42],[12,"RealULE","","",42],[12,"RealUNE","","",42],[12,"RealPredicateTrue","","",42],[2,"TypeKind","",""],[12,"Void","","",30],[12,"Half","","",30],[12,"Float","","",30],[12,"Double","","",30],[12,"X86_FP80","","",30],[12,"FP128","","",30],[12,"PPC_FP128","","",30],[12,"Label","","",30],[12,"Integer","","",30],[12,"Function","","",30],[12,"Struct","","",30],[12,"Array","","",30],[12,"Pointer","","",30],[12,"Vector","","",30],[12,"Metadata","","",30],[12,"X86_MMX","","",30],[2,"AtomicBinOp","",""],[12,"AtomicXchg","","",43],[12,"AtomicAdd","","",43],[12,"AtomicSub","","",43],[12,"AtomicAnd","","",43],[12,"AtomicNand","","",43],[12,"AtomicOr","","",43],[12,"AtomicXor","","",43],[12,"AtomicMax","","",43],[12,"AtomicMin","","",43],[12,"AtomicUMax","","",43],[12,"AtomicUMin","","",43],[2,"AtomicOrdering","",""],[12,"NotAtomic","","",44],[12,"Unordered","","",44],[12,"Monotonic","","",44],[12,"Acquire","","",44],[12,"Release","","",44],[12,"AcquireRelease","","",44],[12,"SequentiallyConsistent","","",44],[2,"FileType","",""],[12,"AssemblyFileType","","",45],[12,"ObjectFileType","","",45],[2,"MetadataType","",""],[12,"MD_dbg","","",46],[12,"MD_tbaa","","",46],[12,"MD_prof","","",46],[12,"MD_fpmath","","",46],[12,"MD_range","","",46],[12,"MD_tbaa_struct","","",46],[2,"AsmDialect","",""],[12,"AD_ATT","","",47],[12,"AD_Intel","","",47],[2,"CodeGenOptLevel","",""],[12,"CodeGenLevelNone","","",31],[12,"CodeGenLevelLess","","",31],[12,"CodeGenLevelDefault","","",31],[12,"CodeGenLevelAggressive","","",31],[2,"RelocMode","",""],[12,"RelocDefault","","",32],[12,"RelocStatic","","",32],[12,"RelocPIC","","",32],[12,"RelocDynamicNoPic","","",32],[2,"CodeGenModel","",""],[12,"CodeModelDefault","","",48],[12,"CodeModelJITDefault","","",48],[12,"CodeModelSmall","","",48],[12,"CodeModelKernel","","",48],[12,"CodeModelMedium","","",48],[12,"CodeModelLarge","","",48],[2,"DiagnosticKind","",""],[12,"DK_InlineAsm","","",49],[12,"DK_StackSize","","",49],[12,"DK_DebugMetadataVersion","","",49],[12,"DK_SampleProfile","","",49],[12,"DK_OptimizationRemark","","",49],[12,"DK_OptimizationRemarkMissed","","",49],[12,"DK_OptimizationRemarkAnalysis","","",49],[12,"DK_OptimizationFailure","","",49],[2,"Module_opaque","",""],[4,"ModuleRef","",""],[2,"Context_opaque","",""],[4,"ContextRef","",""],[2,"Type_opaque","",""],[4,"TypeRef","",""],[2,"Value_opaque","",""],[4,"ValueRef","",""],[2,"BasicBlock_opaque","",""],[4,"BasicBlockRef","",""],[2,"Builder_opaque","",""],[4,"BuilderRef","",""],[2,"ExecutionEngine_opaque","",""],[4,"ExecutionEngineRef","",""],[2,"RustJITMemoryManager_opaque","",""],[4,"RustJITMemoryManagerRef","",""],[2,"MemoryBuffer_opaque","",""],[4,"MemoryBufferRef","",""],[2,"PassManager_opaque","",""],[4,"PassManagerRef","",""],[2,"PassManagerBuilder_opaque","",""],[4,"PassManagerBuilderRef","",""],[2,"Use_opaque","",""],[4,"UseRef","",""],[2,"TargetData_opaque","",""],[4,"TargetDataRef","",""],[2,"ObjectFile_opaque","",""],[4,"ObjectFileRef","",""],[2,"SectionIterator_opaque","",""],[4,"SectionIteratorRef","",""],[2,"Pass_opaque","",""],[4,"PassRef","",""],[2,"TargetMachine_opaque","",""],[4,"TargetMachineRef","",""],[2,"Archive_opaque","",""],[4,"ArchiveRef","",""],[2,"Twine_opaque","",""],[4,"TwineRef","",""],[2,"DiagnosticInfo_opaque","",""],[4,"DiagnosticInfoRef","",""],[2,"DebugLoc_opaque","",""],[4,"DebugLocRef","",""],[2,"SMDiagnostic_opaque","",""],[4,"SMDiagnosticRef","",""],[4,"DiagnosticHandler","",""],[4,"InlineAsmDiagHandler","",""],[0,"debuginfo","",""],[2,"DIBuilder_opaque","rustc_trans::lib::llvm::debuginfo",""],[4,"DIBuilderRef","",""],[4,"DIDescriptor","",""],[4,"DIScope","",""],[4,"DILocation","",""],[4,"DIFile","",""],[4,"DILexicalBlock","",""],[4,"DISubprogram","",""],[4,"DIType","",""],[4,"DIBasicType","",""],[4,"DIDerivedType","",""],[4,"DICompositeType","",""],[4,"DIVariable","",""],[4,"DIGlobalVariable","",""],[4,"DIArray","",""],[4,"DISubrange","",""],[2,"DIDescriptorFlags","",""],[12,"FlagPrivate","","",50],[12,"FlagProtected","","",50],[12,"FlagFwdDecl","","",50],[12,"FlagAppleBlock","","",50],[12,"FlagBlockByrefStruct","","",50],[12,"FlagVirtual","","",50],[12,"FlagArtificial","","",50],[12,"FlagExplicit","","",50],[12,"FlagPrototyped","","",50],[12,"FlagObjcClassComplete","","",50],[12,"FlagObjectPointer","","",50],[12,"FlagVector","","",50],[12,"FlagStaticMember","","",50],[12,"FlagIndirectVariable","","",50],[12,"FlagLValueReference","","",50],[12,"FlagRValueReference","","",50],[3,"LLVMContextCreate","rustc_trans::lib::llvm",""],[3,"LLVMContextDispose","",""],[3,"LLVMGetMDKindIDInContext","",""],[3,"LLVMModuleCreateWithNameInContext","",""],[3,"LLVMGetModuleContext","",""],[3,"LLVMDisposeModule","",""],[3,"LLVMGetDataLayout","","Data layout. See Module::getDataLayout."],[3,"LLVMSetDataLayout","",""],[3,"LLVMGetTarget","","Target triple. See Module::getTargetTriple."],[3,"LLVMSetTarget","",""],[3,"LLVMDumpModule","","See Module::dump."],[3,"LLVMSetModuleInlineAsm","","See Module::setModuleInlineAsm."],[3,"LLVMGetTypeKind","","See llvm::LLVMTypeKind::getTypeID."],[3,"LLVMGetTypeContext","","See llvm::LLVMType::getContext."],[3,"LLVMInt1TypeInContext","",""],[3,"LLVMInt8TypeInContext","",""],[3,"LLVMInt16TypeInContext","",""],[3,"LLVMInt32TypeInContext","",""],[3,"LLVMInt64TypeInContext","",""],[3,"LLVMIntTypeInContext","",""],[3,"LLVMGetIntTypeWidth","",""],[3,"LLVMFloatTypeInContext","",""],[3,"LLVMDoubleTypeInContext","",""],[3,"LLVMX86FP80TypeInContext","",""],[3,"LLVMFP128TypeInContext","",""],[3,"LLVMPPCFP128TypeInContext","",""],[3,"LLVMFunctionType","",""],[3,"LLVMIsFunctionVarArg","",""],[3,"LLVMGetReturnType","",""],[3,"LLVMCountParamTypes","",""],[3,"LLVMGetParamTypes","",""],[3,"LLVMStructTypeInContext","",""],[3,"LLVMCountStructElementTypes","",""],[3,"LLVMGetStructElementTypes","",""],[3,"LLVMIsPackedStruct","",""],[3,"LLVMRustArrayType","",""],[3,"LLVMPointerType","",""],[3,"LLVMVectorType","",""],[3,"LLVMGetElementType","",""],[3,"LLVMGetArrayLength","",""],[3,"LLVMGetPointerAddressSpace","",""],[3,"LLVMGetPointerToGlobal","",""],[3,"LLVMGetVectorSize","",""],[3,"LLVMVoidTypeInContext","",""],[3,"LLVMLabelTypeInContext","",""],[3,"LLVMMetadataTypeInContext","",""],[3,"LLVMTypeOf","",""],[3,"LLVMGetValueName","",""],[3,"LLVMSetValueName","",""],[3,"LLVMDumpValue","",""],[3,"LLVMReplaceAllUsesWith","",""],[3,"LLVMHasMetadata","",""],[3,"LLVMGetMetadata","",""],[3,"LLVMSetMetadata","",""],[3,"LLVMGetFirstUse","",""],[3,"LLVMGetNextUse","",""],[3,"LLVMGetUser","",""],[3,"LLVMGetUsedValue","",""],[3,"LLVMGetNumOperands","",""],[3,"LLVMGetOperand","",""],[3,"LLVMSetOperand","",""],[3,"LLVMConstNull","",""],[3,"LLVMConstAllOnes","",""],[3,"LLVMConstICmp","",""],[3,"LLVMConstFCmp","",""],[3,"LLVMGetUndef","",""],[3,"LLVMIsConstant","",""],[3,"LLVMIsNull","",""],[3,"LLVMIsUndef","",""],[3,"LLVMConstPointerNull","",""],[3,"LLVMMDStringInContext","",""],[3,"LLVMMDNodeInContext","",""],[3,"LLVMAddNamedMetadataOperand","",""],[3,"LLVMConstInt","",""],[3,"LLVMConstIntOfString","",""],[3,"LLVMConstIntOfStringAndSize","",""],[3,"LLVMConstReal","",""],[3,"LLVMConstRealOfString","",""],[3,"LLVMConstRealOfStringAndSize","",""],[3,"LLVMConstIntGetZExtValue","",""],[3,"LLVMConstIntGetSExtValue","",""],[3,"LLVMConstStringInContext","",""],[3,"LLVMConstStructInContext","",""],[3,"LLVMConstArray","",""],[3,"LLVMConstVector","",""],[3,"LLVMAlignOf","",""],[3,"LLVMSizeOf","",""],[3,"LLVMConstNeg","",""],[3,"LLVMConstNSWNeg","",""],[3,"LLVMConstNUWNeg","",""],[3,"LLVMConstFNeg","",""],[3,"LLVMConstNot","",""],[3,"LLVMConstAdd","",""],[3,"LLVMConstNSWAdd","",""],[3,"LLVMConstNUWAdd","",""],[3,"LLVMConstFAdd","",""],[3,"LLVMConstSub","",""],[3,"LLVMConstNSWSub","",""],[3,"LLVMConstNUWSub","",""],[3,"LLVMConstFSub","",""],[3,"LLVMConstMul","",""],[3,"LLVMConstNSWMul","",""],[3,"LLVMConstNUWMul","",""],[3,"LLVMConstFMul","",""],[3,"LLVMConstUDiv","",""],[3,"LLVMConstSDiv","",""],[3,"LLVMConstExactSDiv","",""],[3,"LLVMConstFDiv","",""],[3,"LLVMConstURem","",""],[3,"LLVMConstSRem","",""],[3,"LLVMConstFRem","",""],[3,"LLVMConstAnd","",""],[3,"LLVMConstOr","",""],[3,"LLVMConstXor","",""],[3,"LLVMConstShl","",""],[3,"LLVMConstLShr","",""],[3,"LLVMConstAShr","",""],[3,"LLVMConstGEP","",""],[3,"LLVMConstInBoundsGEP","",""],[3,"LLVMConstTrunc","",""],[3,"LLVMConstSExt","",""],[3,"LLVMConstZExt","",""],[3,"LLVMConstFPTrunc","",""],[3,"LLVMConstFPExt","",""],[3,"LLVMConstUIToFP","",""],[3,"LLVMConstSIToFP","",""],[3,"LLVMConstFPToUI","",""],[3,"LLVMConstFPToSI","",""],[3,"LLVMConstPtrToInt","",""],[3,"LLVMConstIntToPtr","",""],[3,"LLVMConstBitCast","",""],[3,"LLVMConstZExtOrBitCast","",""],[3,"LLVMConstSExtOrBitCast","",""],[3,"LLVMConstTruncOrBitCast","",""],[3,"LLVMConstPointerCast","",""],[3,"LLVMConstIntCast","",""],[3,"LLVMConstFPCast","",""],[3,"LLVMConstSelect","",""],[3,"LLVMConstExtractElement","",""],[3,"LLVMConstInsertElement","",""],[3,"LLVMConstShuffleVector","",""],[3,"LLVMConstExtractValue","",""],[3,"LLVMConstInsertValue","",""],[3,"LLVMConstInlineAsm","",""],[3,"LLVMBlockAddress","",""],[3,"LLVMGetGlobalParent","",""],[3,"LLVMIsDeclaration","",""],[3,"LLVMGetLinkage","",""],[3,"LLVMSetLinkage","",""],[3,"LLVMGetSection","",""],[3,"LLVMSetSection","",""],[3,"LLVMGetVisibility","",""],[3,"LLVMSetVisibility","",""],[3,"LLVMGetAlignment","",""],[3,"LLVMSetAlignment","",""],[3,"LLVMAddGlobal","",""],[3,"LLVMAddGlobalInAddressSpace","",""],[3,"LLVMGetNamedGlobal","",""],[3,"LLVMGetFirstGlobal","",""],[3,"LLVMGetLastGlobal","",""],[3,"LLVMGetNextGlobal","",""],[3,"LLVMGetPreviousGlobal","",""],[3,"LLVMDeleteGlobal","",""],[3,"LLVMGetInitializer","",""],[3,"LLVMSetInitializer","",""],[3,"LLVMIsThreadLocal","",""],[3,"LLVMSetThreadLocal","",""],[3,"LLVMIsGlobalConstant","",""],[3,"LLVMSetGlobalConstant","",""],[3,"LLVMAddAlias","",""],[3,"LLVMAddFunction","",""],[3,"LLVMGetNamedFunction","",""],[3,"LLVMGetFirstFunction","",""],[3,"LLVMGetLastFunction","",""],[3,"LLVMGetNextFunction","",""],[3,"LLVMGetPreviousFunction","",""],[3,"LLVMDeleteFunction","",""],[3,"LLVMGetOrInsertFunction","",""],[3,"LLVMGetIntrinsicID","",""],[3,"LLVMGetFunctionCallConv","",""],[3,"LLVMSetFunctionCallConv","",""],[3,"LLVMGetGC","",""],[3,"LLVMSetGC","",""],[3,"LLVMAddDereferenceableAttr","",""],[3,"LLVMAddFunctionAttribute","",""],[3,"LLVMAddFunctionAttrString","",""],[3,"LLVMRemoveFunctionAttrString","",""],[3,"LLVMGetFunctionAttr","",""],[3,"LLVMCountParams","",""],[3,"LLVMGetParams","",""],[3,"LLVMGetParam","",""],[3,"LLVMGetParamParent","",""],[3,"LLVMGetFirstParam","",""],[3,"LLVMGetLastParam","",""],[3,"LLVMGetNextParam","",""],[3,"LLVMGetPreviousParam","",""],[3,"LLVMAddAttribute","",""],[3,"LLVMRemoveAttribute","",""],[3,"LLVMGetAttribute","",""],[3,"LLVMSetParamAlignment","",""],[3,"LLVMBasicBlockAsValue","",""],[3,"LLVMValueIsBasicBlock","",""],[3,"LLVMValueAsBasicBlock","",""],[3,"LLVMGetBasicBlockParent","",""],[3,"LLVMCountBasicBlocks","",""],[3,"LLVMGetBasicBlocks","",""],[3,"LLVMGetFirstBasicBlock","",""],[3,"LLVMGetLastBasicBlock","",""],[3,"LLVMGetNextBasicBlock","",""],[3,"LLVMGetPreviousBasicBlock","",""],[3,"LLVMGetEntryBasicBlock","",""],[3,"LLVMAppendBasicBlockInContext","",""],[3,"LLVMInsertBasicBlockInContext","",""],[3,"LLVMDeleteBasicBlock","",""],[3,"LLVMMoveBasicBlockAfter","",""],[3,"LLVMMoveBasicBlockBefore","",""],[3,"LLVMGetInstructionParent","",""],[3,"LLVMGetFirstInstruction","",""],[3,"LLVMGetLastInstruction","",""],[3,"LLVMGetNextInstruction","",""],[3,"LLVMGetPreviousInstruction","",""],[3,"LLVMInstructionEraseFromParent","",""],[3,"LLVMSetInstructionCallConv","",""],[3,"LLVMGetInstructionCallConv","",""],[3,"LLVMAddInstrAttribute","",""],[3,"LLVMRemoveInstrAttribute","",""],[3,"LLVMSetInstrParamAlignment","",""],[3,"LLVMAddCallSiteAttribute","",""],[3,"LLVMAddDereferenceableCallSiteAttr","",""],[3,"LLVMIsTailCall","",""],[3,"LLVMSetTailCall","",""],[3,"LLVMGetVolatile","",""],[3,"LLVMSetVolatile","",""],[3,"LLVMAddIncoming","",""],[3,"LLVMCountIncoming","",""],[3,"LLVMGetIncomingValue","",""],[3,"LLVMGetIncomingBlock","",""],[3,"LLVMCreateBuilderInContext","",""],[3,"LLVMPositionBuilder","",""],[3,"LLVMPositionBuilderBefore","",""],[3,"LLVMPositionBuilderAtEnd","",""],[3,"LLVMGetInsertBlock","",""],[3,"LLVMClearInsertionPosition","",""],[3,"LLVMInsertIntoBuilder","",""],[3,"LLVMInsertIntoBuilderWithName","",""],[3,"LLVMDisposeBuilder","",""],[3,"LLVMRustCreateJITMemoryManager","",""],[3,"LLVMBuildExecutionEngine","",""],[3,"LLVMDisposeExecutionEngine","",""],[3,"LLVMExecutionEngineFinalizeObject","",""],[3,"LLVMRustLoadDynamicLibrary","",""],[3,"LLVMExecutionEngineAddModule","",""],[3,"LLVMExecutionEngineRemoveModule","",""],[3,"LLVMSetCurrentDebugLocation","",""],[3,"LLVMGetCurrentDebugLocation","",""],[3,"LLVMSetInstDebugLocation","",""],[3,"LLVMBuildRetVoid","",""],[3,"LLVMBuildRet","",""],[3,"LLVMBuildAggregateRet","",""],[3,"LLVMBuildBr","",""],[3,"LLVMBuildCondBr","",""],[3,"LLVMBuildSwitch","",""],[3,"LLVMBuildIndirectBr","",""],[3,"LLVMBuildInvoke","",""],[3,"LLVMBuildLandingPad","",""],[3,"LLVMBuildResume","",""],[3,"LLVMBuildUnreachable","",""],[3,"LLVMAddCase","",""],[3,"LLVMAddDestination","",""],[3,"LLVMAddClause","",""],[3,"LLVMSetCleanup","",""],[3,"LLVMBuildAdd","",""],[3,"LLVMBuildNSWAdd","",""],[3,"LLVMBuildNUWAdd","",""],[3,"LLVMBuildFAdd","",""],[3,"LLVMBuildSub","",""],[3,"LLVMBuildNSWSub","",""],[3,"LLVMBuildNUWSub","",""],[3,"LLVMBuildFSub","",""],[3,"LLVMBuildMul","",""],[3,"LLVMBuildNSWMul","",""],[3,"LLVMBuildNUWMul","",""],[3,"LLVMBuildFMul","",""],[3,"LLVMBuildUDiv","",""],[3,"LLVMBuildSDiv","",""],[3,"LLVMBuildExactSDiv","",""],[3,"LLVMBuildFDiv","",""],[3,"LLVMBuildURem","",""],[3,"LLVMBuildSRem","",""],[3,"LLVMBuildFRem","",""],[3,"LLVMBuildShl","",""],[3,"LLVMBuildLShr","",""],[3,"LLVMBuildAShr","",""],[3,"LLVMBuildAnd","",""],[3,"LLVMBuildOr","",""],[3,"LLVMBuildXor","",""],[3,"LLVMBuildBinOp","",""],[3,"LLVMBuildNeg","",""],[3,"LLVMBuildNSWNeg","",""],[3,"LLVMBuildNUWNeg","",""],[3,"LLVMBuildFNeg","",""],[3,"LLVMBuildNot","",""],[3,"LLVMBuildMalloc","",""],[3,"LLVMBuildArrayMalloc","",""],[3,"LLVMBuildAlloca","",""],[3,"LLVMBuildArrayAlloca","",""],[3,"LLVMBuildFree","",""],[3,"LLVMBuildLoad","",""],[3,"LLVMBuildStore","",""],[3,"LLVMBuildGEP","",""],[3,"LLVMBuildInBoundsGEP","",""],[3,"LLVMBuildStructGEP","",""],[3,"LLVMBuildGlobalString","",""],[3,"LLVMBuildGlobalStringPtr","",""],[3,"LLVMBuildTrunc","",""],[3,"LLVMBuildZExt","",""],[3,"LLVMBuildSExt","",""],[3,"LLVMBuildFPToUI","",""],[3,"LLVMBuildFPToSI","",""],[3,"LLVMBuildUIToFP","",""],[3,"LLVMBuildSIToFP","",""],[3,"LLVMBuildFPTrunc","",""],[3,"LLVMBuildFPExt","",""],[3,"LLVMBuildPtrToInt","",""],[3,"LLVMBuildIntToPtr","",""],[3,"LLVMBuildBitCast","",""],[3,"LLVMBuildZExtOrBitCast","",""],[3,"LLVMBuildSExtOrBitCast","",""],[3,"LLVMBuildTruncOrBitCast","",""],[3,"LLVMBuildCast","",""],[3,"LLVMBuildPointerCast","",""],[3,"LLVMBuildIntCast","",""],[3,"LLVMBuildFPCast","",""],[3,"LLVMBuildICmp","",""],[3,"LLVMBuildFCmp","",""],[3,"LLVMBuildPhi","",""],[3,"LLVMBuildCall","",""],[3,"LLVMBuildSelect","",""],[3,"LLVMBuildVAArg","",""],[3,"LLVMBuildExtractElement","",""],[3,"LLVMBuildInsertElement","",""],[3,"LLVMBuildShuffleVector","",""],[3,"LLVMBuildExtractValue","",""],[3,"LLVMBuildInsertValue","",""],[3,"LLVMBuildIsNull","",""],[3,"LLVMBuildIsNotNull","",""],[3,"LLVMBuildPtrDiff","",""],[3,"LLVMBuildAtomicLoad","",""],[3,"LLVMBuildAtomicStore","",""],[3,"LLVMBuildAtomicCmpXchg","",""],[3,"LLVMBuildAtomicRMW","",""],[3,"LLVMBuildAtomicFence","",""],[3,"LLVMIsATerminatorInst","",""],[3,"LLVMIsAStoreInst","",""],[3,"LLVMWriteBitcodeToFile","","Writes a module to the specified path. Returns 0 on success."],[3,"LLVMCreateTargetData","","Creates target data from a target layout string."],[3,"LLVMAddTargetData","","Adds the target data to the given pass manager. The pass manager\nreferences the target data only weakly."],[3,"LLVMStoreSizeOfType","","Number of bytes clobbered when doing a Store to *T."],[3,"LLVMSizeOfTypeInBits","","Number of bytes clobbered when doing a Store to *T."],[3,"LLVMABISizeOfType","","Distance between successive elements in an array of T. Includes ABI padding."],[3,"LLVMPreferredAlignmentOfType","","Returns the preferred alignment of a type."],[3,"LLVMABIAlignmentOfType","","Returns the minimum alignment of a type."],[3,"LLVMOffsetOfElement","","Computes the byte offset of the indexed struct element for a\ntarget."],[3,"LLVMCallFrameAlignmentOfType","","Returns the minimum alignment of a type when part of a call frame."],[3,"LLVMDisposeTargetData","","Disposes target data."],[3,"LLVMCreatePassManager","","Creates a pass manager."],[3,"LLVMCreateFunctionPassManagerForModule","","Creates a function-by-function pass manager"],[3,"LLVMDisposePassManager","","Disposes a pass manager."],[3,"LLVMRunPassManager","","Runs a pass manager on a module."],[3,"LLVMRunFunctionPassManager","","Runs the function passes on the provided function."],[3,"LLVMInitializeFunctionPassManager","","Initializes all the function passes scheduled in the manager"],[3,"LLVMFinalizeFunctionPassManager","","Finalizes all the function passes scheduled in the manager"],[3,"LLVMInitializePasses","",""],[3,"LLVMAddVerifierPass","","Adds a verification pass."],[3,"LLVMAddGlobalOptimizerPass","",""],[3,"LLVMAddIPSCCPPass","",""],[3,"LLVMAddDeadArgEliminationPass","",""],[3,"LLVMAddInstructionCombiningPass","",""],[3,"LLVMAddCFGSimplificationPass","",""],[3,"LLVMAddFunctionInliningPass","",""],[3,"LLVMAddFunctionAttrsPass","",""],[3,"LLVMAddScalarReplAggregatesPass","",""],[3,"LLVMAddScalarReplAggregatesPassSSA","",""],[3,"LLVMAddJumpThreadingPass","",""],[3,"LLVMAddConstantPropagationPass","",""],[3,"LLVMAddReassociatePass","",""],[3,"LLVMAddLoopRotatePass","",""],[3,"LLVMAddLICMPass","",""],[3,"LLVMAddLoopUnswitchPass","",""],[3,"LLVMAddLoopDeletionPass","",""],[3,"LLVMAddLoopUnrollPass","",""],[3,"LLVMAddGVNPass","",""],[3,"LLVMAddMemCpyOptPass","",""],[3,"LLVMAddSCCPPass","",""],[3,"LLVMAddDeadStoreEliminationPass","",""],[3,"LLVMAddStripDeadPrototypesPass","",""],[3,"LLVMAddConstantMergePass","",""],[3,"LLVMAddArgumentPromotionPass","",""],[3,"LLVMAddTailCallEliminationPass","",""],[3,"LLVMAddIndVarSimplifyPass","",""],[3,"LLVMAddAggressiveDCEPass","",""],[3,"LLVMAddGlobalDCEPass","",""],[3,"LLVMAddCorrelatedValuePropagationPass","",""],[3,"LLVMAddPruneEHPass","",""],[3,"LLVMAddSimplifyLibCallsPass","",""],[3,"LLVMAddLoopIdiomPass","",""],[3,"LLVMAddEarlyCSEPass","",""],[3,"LLVMAddTypeBasedAliasAnalysisPass","",""],[3,"LLVMAddBasicAliasAnalysisPass","",""],[3,"LLVMPassManagerBuilderCreate","",""],[3,"LLVMPassManagerBuilderDispose","",""],[3,"LLVMPassManagerBuilderSetOptLevel","",""],[3,"LLVMPassManagerBuilderSetSizeLevel","",""],[3,"LLVMPassManagerBuilderSetDisableUnitAtATime","",""],[3,"LLVMPassManagerBuilderSetDisableUnrollLoops","",""],[3,"LLVMPassManagerBuilderSetDisableSimplifyLibCalls","",""],[3,"LLVMPassManagerBuilderUseInlinerWithThreshold","",""],[3,"LLVMPassManagerBuilderPopulateModulePassManager","",""],[3,"LLVMPassManagerBuilderPopulateFunctionPassManager","",""],[3,"LLVMPassManagerBuilderPopulateLTOPassManager","",""],[3,"LLVMDisposeMemoryBuffer","","Destroys a memory buffer."],[3,"LLVMCreateObjectFile","","Opens an object file."],[3,"LLVMDisposeObjectFile","","Closes an object file."],[3,"LLVMGetSections","","Enumerates the sections in an object file."],[3,"LLVMDisposeSectionIterator","","Destroys a section iterator."],[3,"LLVMIsSectionIteratorAtEnd","","Returns true if the section iterator is at the end of the section\nlist:"],[3,"LLVMMoveToNextSection","","Moves the section iterator to point to the next section."],[3,"LLVMGetSectionSize","","Returns the current section size."],[3,"LLVMGetSectionContents","","Returns the current section contents as a string buffer."],[3,"LLVMRustCreateMemoryBufferWithContentsOfFile","","Reads the given file and returns it as a memory buffer. Use\nLLVMDisposeMemoryBuffer() to get rid of it."],[3,"LLVMCreateMemoryBufferWithMemoryRange","","Borrows the contents of the memory buffer (doesn't copy it)"],[3,"LLVMCreateMemoryBufferWithMemoryRangeCopy","",""],[3,"LLVMIsMultithreaded","",""],[3,"LLVMStartMultithreaded","",""],[3,"LLVMRustGetLastError","","Returns a string describing the last error caused by an LLVMRust* call."],[3,"LLVMRustPrintPassTimings","","Print the pass timings since static dtors aren't picking them up."],[3,"LLVMStructCreateNamed","",""],[3,"LLVMStructSetBody","",""],[3,"LLVMConstNamedStruct","",""],[3,"LLVMSetDebug","","Enables LLVM debug output."],[3,"LLVMInlineAsm","","Prepares inline assembly."],[5,"LLVMRustDebugMetadataVersion","",""],[3,"LLVMRustAddModuleFlag","",""],[3,"LLVMDIBuilderCreate","",""],[3,"LLVMDIBuilderDispose","",""],[3,"LLVMDIBuilderFinalize","",""],[3,"LLVMDIBuilderCreateCompileUnit","",""],[3,"LLVMDIBuilderCreateFile","",""],[3,"LLVMDIBuilderCreateSubroutineType","",""],[3,"LLVMDIBuilderCreateFunction","",""],[3,"LLVMDIBuilderCreateBasicType","",""],[3,"LLVMDIBuilderCreatePointerType","",""],[3,"LLVMDIBuilderCreateStructType","",""],[3,"LLVMDIBuilderCreateMemberType","",""],[3,"LLVMDIBuilderCreateLexicalBlock","",""],[3,"LLVMDIBuilderCreateStaticVariable","",""],[3,"LLVMDIBuilderCreateLocalVariable","",""],[3,"LLVMDIBuilderCreateArrayType","",""],[3,"LLVMDIBuilderCreateVectorType","",""],[3,"LLVMDIBuilderGetOrCreateSubrange","",""],[3,"LLVMDIBuilderGetOrCreateArray","",""],[3,"LLVMDIBuilderInsertDeclareAtEnd","",""],[3,"LLVMDIBuilderInsertDeclareBefore","",""],[3,"LLVMDIBuilderCreateEnumerator","",""],[3,"LLVMDIBuilderCreateEnumerationType","",""],[3,"LLVMDIBuilderCreateUnionType","",""],[3,"LLVMSetUnnamedAddr","",""],[3,"LLVMDIBuilderCreateTemplateTypeParameter","",""],[3,"LLVMDIBuilderCreateOpDeref","",""],[3,"LLVMDIBuilderCreateOpPlus","",""],[3,"LLVMDIBuilderCreateComplexVariable","",""],[3,"LLVMDIBuilderCreateNameSpace","",""],[3,"LLVMDICompositeTypeSetTypeArray","",""],[3,"LLVMWriteTypeToString","",""],[3,"LLVMWriteValueToString","",""],[3,"LLVMIsAArgument","",""],[3,"LLVMIsAAllocaInst","",""],[3,"LLVMInitializeX86TargetInfo","",""],[3,"LLVMInitializeX86Target","",""],[3,"LLVMInitializeX86TargetMC","",""],[3,"LLVMInitializeX86AsmPrinter","",""],[3,"LLVMInitializeX86AsmParser","",""],[3,"LLVMInitializeARMTargetInfo","",""],[3,"LLVMInitializeARMTarget","",""],[3,"LLVMInitializeARMTargetMC","",""],[3,"LLVMInitializeARMAsmPrinter","",""],[3,"LLVMInitializeARMAsmParser","",""],[3,"LLVMInitializeMipsTargetInfo","",""],[3,"LLVMInitializeMipsTarget","",""],[3,"LLVMInitializeMipsTargetMC","",""],[3,"LLVMInitializeMipsAsmPrinter","",""],[3,"LLVMInitializeMipsAsmParser","",""],[3,"LLVMRustAddPass","",""],[3,"LLVMRustCreateTargetMachine","",""],[3,"LLVMRustDisposeTargetMachine","",""],[3,"LLVMRustAddAnalysisPasses","",""],[3,"LLVMRustAddBuilderLibraryInfo","",""],[3,"LLVMRustAddLibraryInfo","",""],[3,"LLVMRustRunFunctionPassManager","",""],[3,"LLVMRustWriteOutputFile","",""],[3,"LLVMRustPrintModule","",""],[3,"LLVMRustSetLLVMOptions","",""],[3,"LLVMRustPrintPasses","",""],[3,"LLVMRustSetNormalizedTarget","",""],[3,"LLVMRustAddAlwaysInlinePass","",""],[3,"LLVMRustLinkInExternalBitcode","",""],[3,"LLVMRustRunRestrictionPass","",""],[3,"LLVMRustMarkAllFunctionsNounwind","",""],[3,"LLVMRustOpenArchive","",""],[3,"LLVMRustArchiveReadSection","",""],[3,"LLVMRustDestroyArchive","",""],[3,"LLVMRustSetDLLExportStorageClass","",""],[3,"LLVMVersionMajor","",""],[3,"LLVMVersionMinor","",""],[3,"LLVMRustGetSectionName","",""],[3,"LLVMWriteTwineToString","",""],[3,"LLVMContextSetDiagnosticHandler","",""],[3,"LLVMUnpackOptimizationDiagnostic","",""],[3,"LLVMWriteDiagnosticInfoToString","",""],[3,"LLVMGetDiagInfoSeverity","",""],[3,"LLVMGetDiagInfoKind","",""],[3,"LLVMWriteDebugLocToString","",""],[3,"LLVMSetInlineAsmDiagnosticHandler","",""],[3,"LLVMWriteSMDiagnosticToString","",""],[3,"SetInstructionCallConv","",""],[3,"SetFunctionCallConv","",""],[3,"SetLinkage","",""],[3,"SetUnnamedAddr","",""],[3,"set_thread_local","",""],[3,"ConstICmp","",""],[3,"ConstFCmp","",""],[3,"SetFunctionAttribute","",""],[1,"TargetData","",""],[11,"lltd","","",33],[3,"mk_target_data","",""],[1,"ObjectFile","",""],[11,"llof","","",34],[1,"SectionIter","",""],[11,"llsi","","",35],[3,"mk_section_iter","",""],[3,"get_param","","Safe wrapper around `LLVMGetParam`, because segfaults are no fun."],[2,"RustString_opaque","",""],[4,"RustStringRef","",""],[3,"rust_llvm_string_write_impl","","Appending to a Rust string -- used by raw_rust_string_ostream."],[3,"build_string","",""],[3,"twine_to_string","",""],[3,"debug_loc_to_string","",""],[3,"static_link_hack_this_sucks","",""],[0,"session","rustc_trans",""],[0,"config","rustc_trans::session","Contains infrastructure for configuring the compiler, including parsing\ncommand line options."],[10,"tr_id","rustc::middle::astencode","Translates an internal id, meaning a node id that is known to refer to some part of the\nitem currently being inlined, such as a local variable or argument.  All naked node-ids\nthat appear in types have this property, since if something might refer to an external item\nwe would use a def-id to allow for the possibility that the item resides in another crate.",51],[10,"tr_def_id","","Translates an EXTERNAL def-id, converting the crate number from the one used in the encoded\ndata to the current crate numbers..  By external, I mean that it be translated to a\nreference to the item in its original crate, as opposed to being translated to a reference\nto the inlined version of the item.  This is typically, but not always, what you want,\nbecause most def-ids refer to external things like types or other fns that may or may not\nbe inlined.  Note that even when the inlined function is referencing itself recursively, we\nwould want `tr_def_id` for that reference--- conceptually the function calls the original,\nnon-inlined version, and trans deals with linking that recursive call to the inlined copy.",51],[10,"tr_intern_def_id","","Translates an INTERNAL def-id, meaning a def-id that is\nknown to refer to some part of the item currently being\ninlined.  In that case, we want to convert the def-id to\nrefer to the current crate and to the new, inlined node-id.",51],[10,"tr_span","","",51],[10,"tr_intern","syntax::ast","",52],[10,"tr","","",52],[10,"tr","core::option","",53],[10,"tr","syntax::codemap","",54],[10,"fold_block","rustc::middle::astencode","",55],[10,"fold_crate","","",55],[10,"fold_meta_items","","",55],[10,"fold_meta_item","","",55],[10,"fold_view_path","","",55],[10,"fold_view_item","","",55],[10,"fold_foreign_item","","",55],[10,"fold_item","","",55],[10,"fold_item_simple","","",55],[10,"fold_struct_field","","",55],[10,"fold_item_underscore","","",55],[10,"fold_fn_decl","","",55],[10,"fold_type_method","","",55],[10,"fold_method","","",55],[10,"fold_block","","",55],[10,"fold_stmt","","",55],[10,"fold_arm","","",55],[10,"fold_pat","","",55],[10,"fold_decl","","",55],[10,"fold_expr","","",55],[10,"fold_ty","","",55],[10,"fold_qpath","","",55],[10,"fold_ty_binding","","",55],[10,"fold_mod","","",55],[10,"fold_foreign_mod","","",55],[10,"fold_variant","","",55],[10,"fold_ident","","",55],[10,"fold_uint","","",55],[10,"fold_path","","",55],[10,"fold_path_parameters","","",55],[10,"fold_angle_bracketed_parameter_data","","",55],[10,"fold_parenthesized_parameter_data","","",55],[10,"fold_local","","",55],[10,"fold_mac","","",55],[10,"fold_explicit_self","","",55],[10,"fold_explicit_self_underscore","","",55],[10,"fold_lifetime","","",55],[10,"fold_lifetime_def","","",55],[10,"fold_attribute","","",55],[10,"fold_arg","","",55],[10,"fold_generics","","",55],[10,"fold_trait_ref","","",55],[10,"fold_poly_trait_ref","","",55],[10,"fold_struct_def","","",55],[10,"fold_lifetimes","","",55],[10,"fold_lifetime_defs","","",55],[10,"fold_ty_param","","",55],[10,"fold_ty_params","","",55],[10,"fold_tt","","",55],[10,"fold_tts","","",55],[10,"fold_token","","",55],[10,"fold_interpolated","","",55],[10,"fold_opt_lifetime","","",55],[10,"fold_variant_arg","","",55],[10,"fold_opt_bounds","","",55],[10,"fold_bounds","","",55],[10,"fold_ty_param_bound","","",55],[10,"fold_mt","","",55],[10,"fold_field","","",55],[10,"fold_where_clause","","",55],[10,"fold_where_predicate","","",55],[10,"fold_typedef","","",55],[10,"fold_associated_type","","",55],[10,"new_id","","",55],[10,"new_span","","",55],[10,"tr","rustc::middle::def","",56],[10,"tr","rustc::middle::ty","",57],[10,"tr","","",58],[10,"tr","rustc::middle::region","",59],[10,"tr","rustc::middle::ty","",60],[10,"tr","","",61],[10,"read_freevar_entry","rbml::reader","",62],[10,"read_capture_mode","","",62],[10,"tr","rustc::middle::ty","",63],[10,"tr","","",64],[10,"read_method_callee","rbml::reader","",62],[10,"tr","rustc::middle::ty","",65],[10,"read_vec_per_param_space","rbml::reader","",62],[10,"read_vtable_res_with_key","","",62],[10,"read_vtable_res","","",62],[10,"read_vtable_param_res","","",62],[10,"read_vtable_origin","","",62],[10,"ty_str_ctxt","rustc::metadata::encoder","",66],[10,"emit_closure_type","rbml::writer","",67],[10,"emit_method_origin","","",67],[10,"emit_ty","","",67],[10,"emit_tys","","",67],[10,"emit_trait_ref","","",67],[10,"emit_type_param_def","","",67],[10,"emit_predicate","","",67],[10,"emit_type_scheme","","",67],[10,"emit_existential_bounds","","",67],[10,"emit_builtin_bounds","","",67],[10,"emit_substs","","",67],[10,"emit_auto_adjustment","","",67],[10,"emit_autoref","","",67],[10,"emit_auto_deref_ref","","",67],[10,"emit_unsize_kind","","",67],[10,"tag","","",67],[10,"id","","",67],[10,"visit_id","rustc::middle::astencode","",68],[10,"as_int","rbml","",69],[10,"opt_child","","",69],[10,"read_ty_nodcx","rbml::reader","",62],[10,"read_tys_nodcx","","",62],[10,"read_substs_nodcx","","",62],[10,"read_method_origin","","",62],[10,"read_ty","","",62],[10,"read_tys","","",62],[10,"read_trait_ref","","",62],[10,"read_poly_trait_ref","","",62],[10,"read_type_param_def","","",62],[10,"read_predicate","","",62],[10,"read_type_scheme","","",62],[10,"read_existential_bounds","","",62],[10,"read_substs","","",62],[10,"read_auto_adjustment","","",62],[10,"read_auto_deref_ref","","",62],[10,"read_autoref","","",62],[10,"read_unsize_kind","","",62],[10,"read_unboxed_closure","","",62],[10,"convert_def_id","","Converts a def-id that appears in a type.  The correct\ntranslation will depend on what kind of def-id this is.\nThis is a subtle point: type definitions are not\ninlined into the current crate, so if the def-id names\na nominal type or type alias, then it should be\ntranslated to refer to the source crate.",62],[10,"graph_id","rustc::middle::cfg::graphviz","",70],[10,"node_id","","",70],[10,"node_label","","",70],[10,"edge_label","","",70],[10,"node_label","","",70],[10,"edge_label","","",70],[10,"nodes","","",70],[10,"edges","","",70],[10,"source","","",70],[10,"target","","",70],[10,"new","rustc::middle::cfg","",71],[10,"node_is_reachable","","",71],[10,"visit_item","rustc::middle::check_const","",72],[10,"visit_pat","","",72],[10,"visit_expr","","",72],[10,"visit_name","","",72],[10,"visit_ident","","",72],[10,"visit_mod","","",72],[10,"visit_view_item","","",72],[10,"visit_foreign_item","","",72],[10,"visit_item","","",72],[10,"visit_local","","",72],[10,"visit_block","","",72],[10,"visit_stmt","","",72],[10,"visit_arm","","",72],[10,"visit_pat","","",72],[10,"visit_decl","","",72],[10,"visit_expr","","",72],[10,"visit_expr_post","","",72],[10,"visit_ty","","",72],[10,"visit_generics","","",72],[10,"visit_fn","","",72],[10,"visit_ty_method","","",72],[10,"visit_trait_item","","",72],[10,"visit_trait_ref","","",72],[10,"visit_ty_param_bound","","",72],[10,"visit_poly_trait_ref","","",72],[10,"visit_struct_def","","",72],[10,"visit_struct_field","","",72],[10,"visit_variant","","",72],[10,"visit_opt_lifetime_ref","","",72],[10,"visit_lifetime_bound","","",72],[10,"visit_lifetime_ref","","",72],[10,"visit_lifetime_def","","",72],[10,"visit_explicit_self","","",72],[10,"visit_mac","","",72],[10,"visit_path","","",72],[10,"visit_path_segment","","",72],[10,"visit_path_parameters","","",72],[10,"visit_assoc_type_binding","","",72],[10,"visit_attribute","","",72],[10,"visit_item","rustc::middle::check_static_recursion","",73],[10,"visit_name","","",73],[10,"visit_ident","","",73],[10,"visit_mod","","",73],[10,"visit_view_item","","",73],[10,"visit_foreign_item","","",73],[10,"visit_item","","",73],[10,"visit_local","","",73],[10,"visit_block","","",73],[10,"visit_stmt","","",73],[10,"visit_arm","","",73],[10,"visit_pat","","",73],[10,"visit_decl","","",73],[10,"visit_expr","","",73],[10,"visit_expr_post","","",73],[10,"visit_ty","","",73],[10,"visit_generics","","",73],[10,"visit_fn","","",73],[10,"visit_ty_method","","",73],[10,"visit_trait_item","","",73],[10,"visit_trait_ref","","",73],[10,"visit_ty_param_bound","","",73],[10,"visit_poly_trait_ref","","",73],[10,"visit_struct_def","","",73],[10,"visit_struct_field","","",73],[10,"visit_variant","","",73],[10,"visit_opt_lifetime_ref","","",73],[10,"visit_lifetime_bound","","",73],[10,"visit_lifetime_ref","","",73],[10,"visit_lifetime_def","","",73],[10,"visit_explicit_self","","",73],[10,"visit_mac","","",73],[10,"visit_path","","",73],[10,"visit_path_segment","","",73],[10,"visit_path_parameters","","",73],[10,"visit_assoc_type_binding","","",73],[10,"visit_attribute","","",73],[10,"visit_item","","",74],[10,"visit_expr","","",74],[10,"visit_name","","",74],[10,"visit_ident","","",74],[10,"visit_mod","","",74],[10,"visit_view_item","","",74],[10,"visit_foreign_item","","",74],[10,"visit_item","","",74],[10,"visit_local","","",74],[10,"visit_block","","",74],[10,"visit_stmt","","",74],[10,"visit_arm","","",74],[10,"visit_pat","","",74],[10,"visit_decl","","",74],[10,"visit_expr","","",74],[10,"visit_expr_post","","",74],[10,"visit_ty","","",74],[10,"visit_generics","","",74],[10,"visit_fn","","",74],[10,"visit_ty_method","","",74],[10,"visit_trait_item","","",74],[10,"visit_trait_ref","","",74],[10,"visit_ty_param_bound","","",74],[10,"visit_poly_trait_ref","","",74],[10,"visit_struct_def","","",74],[10,"visit_struct_field","","",74],[10,"visit_variant","","",74],[10,"visit_opt_lifetime_ref","","",74],[10,"visit_lifetime_bound","","",74],[10,"visit_lifetime_ref","","",74],[10,"visit_lifetime_def","","",74],[10,"visit_explicit_self","","",74],[10,"visit_mac","","",74],[10,"visit_path","","",74],[10,"visit_path_segment","","",74],[10,"visit_path_parameters","","",74],[10,"visit_assoc_type_binding","","",74],[10,"visit_attribute","","",74],[10,"eq","rustc::middle::check_loop","",75],[10,"ne","","",75],[10,"ne","","",75],[10,"clone","","",75],[10,"clone_from","","",75],[10,"visit_item","","",76],[10,"visit_expr","","",76],[10,"visit_name","","",76],[10,"visit_ident","","",76],[10,"visit_mod","","",76],[10,"visit_view_item","","",76],[10,"visit_foreign_item","","",76],[10,"visit_item","","",76],[10,"visit_local","","",76],[10,"visit_block","","",76],[10,"visit_stmt","","",76],[10,"visit_arm","","",76],[10,"visit_pat","","",76],[10,"visit_decl","","",76],[10,"visit_expr","","",76],[10,"visit_expr_post","","",76],[10,"visit_ty","","",76],[10,"visit_generics","","",76],[10,"visit_fn","","",76],[10,"visit_ty_method","","",76],[10,"visit_trait_item","","",76],[10,"visit_trait_ref","","",76],[10,"visit_ty_param_bound","","",76],[10,"visit_poly_trait_ref","","",76],[10,"visit_struct_def","","",76],[10,"visit_struct_field","","",76],[10,"visit_variant","","",76],[10,"visit_opt_lifetime_ref","","",76],[10,"visit_lifetime_bound","","",76],[10,"visit_lifetime_ref","","",76],[10,"visit_lifetime_def","","",76],[10,"visit_explicit_self","","",76],[10,"visit_mac","","",76],[10,"visit_path","","",76],[10,"visit_path_segment","","",76],[10,"visit_path_parameters","","",76],[10,"visit_assoc_type_binding","","",76],[10,"visit_attribute","","",76],[10,"fmt","rustc::middle::check_match","",77],[10,"from_iter","","",77],[10,"eq","","",78],[10,"ne","","",78],[10,"ne","","",78],[10,"clone","","",78],[10,"clone_from","","",78],[10,"eq","","",79],[10,"ne","","",79],[10,"ne","","",79],[10,"clone","","",79],[10,"clone_from","","",79],[10,"visit_expr","","",80],[10,"visit_local","","",80],[10,"visit_fn","","",80],[10,"visit_name","","",80],[10,"visit_ident","","",80],[10,"visit_mod","","",80],[10,"visit_view_item","","",80],[10,"visit_foreign_item","","",80],[10,"visit_item","","",80],[10,"visit_local","","",80],[10,"visit_block","","",80],[10,"visit_stmt","","",80],[10,"visit_arm","","",80],[10,"visit_pat","","",80],[10,"visit_decl","","",80],[10,"visit_expr","","",80],[10,"visit_expr_post","","",80],[10,"visit_ty","","",80],[10,"visit_generics","","",80],[10,"visit_fn","","",80],[10,"visit_ty_method","","",80],[10,"visit_trait_item","","",80],[10,"visit_trait_ref","","",80],[10,"visit_ty_param_bound","","",80],[10,"visit_poly_trait_ref","","",80],[10,"visit_struct_def","","",80],[10,"visit_struct_field","","",80],[10,"visit_variant","","",80],[10,"visit_opt_lifetime_ref","","",80],[10,"visit_lifetime_bound","","",80],[10,"visit_lifetime_ref","","",80],[10,"visit_lifetime_def","","",80],[10,"visit_explicit_self","","",80],[10,"visit_mac","","",80],[10,"visit_path","","",80],[10,"visit_path_segment","","",80],[10,"visit_path_parameters","","",80],[10,"visit_assoc_type_binding","","",80],[10,"visit_attribute","","",80],[10,"new","","",81],[10,"fold_pat","","",81],[10,"fold_crate","","",81],[10,"fold_meta_items","","",81],[10,"fold_meta_item","","",81],[10,"fold_view_path","","",81],[10,"fold_view_item","","",81],[10,"fold_foreign_item","","",81],[10,"fold_item","","",81],[10,"fold_item_simple","","",81],[10,"fold_struct_field","","",81],[10,"fold_item_underscore","","",81],[10,"fold_fn_decl","","",81],[10,"fold_type_method","","",81],[10,"fold_method","","",81],[10,"fold_block","","",81],[10,"fold_stmt","","",81],[10,"fold_arm","","",81],[10,"fold_pat","","",81],[10,"fold_decl","","",81],[10,"fold_expr","","",81],[10,"fold_ty","","",81],[10,"fold_qpath","","",81],[10,"fold_ty_binding","","",81],[10,"fold_mod","","",81],[10,"fold_foreign_mod","","",81],[10,"fold_variant","","",81],[10,"fold_ident","","",81],[10,"fold_uint","","",81],[10,"fold_path","","",81],[10,"fold_path_parameters","","",81],[10,"fold_angle_bracketed_parameter_data","","",81],[10,"fold_parenthesized_parameter_data","","",81],[10,"fold_local","","",81],[10,"fold_mac","","",81],[10,"fold_explicit_self","","",81],[10,"fold_explicit_self_underscore","","",81],[10,"fold_lifetime","","",81],[10,"fold_lifetime_def","","",81],[10,"fold_attribute","","",81],[10,"fold_arg","","",81],[10,"fold_generics","","",81],[10,"fold_trait_ref","","",81],[10,"fold_poly_trait_ref","","",81],[10,"fold_struct_def","","",81],[10,"fold_lifetimes","","",81],[10,"fold_lifetime_defs","","",81],[10,"fold_ty_param","","",81],[10,"fold_ty_params","","",81],[10,"fold_tt","","",81],[10,"fold_tts","","",81],[10,"fold_token","","",81],[10,"fold_interpolated","","",81],[10,"fold_opt_lifetime","","",81],[10,"fold_variant_arg","","",81],[10,"fold_opt_bounds","","",81],[10,"fold_bounds","","",81],[10,"fold_ty_param_bound","","",81],[10,"fold_mt","","",81],[10,"fold_field","","",81],[10,"fold_where_clause","","",81],[10,"fold_where_predicate","","",81],[10,"fold_typedef","","",81],[10,"fold_associated_type","","",81],[10,"new_id","","",81],[10,"new_span","","",81],[10,"matched_pat","","",82],[10,"consume","","",82],[10,"consume_pat","","",82],[10,"borrow","","",82],[10,"decl_without_init","","",82],[10,"mutate","","",82],[10,"visit_pat","","",83],[10,"visit_name","","",83],[10,"visit_ident","","",83],[10,"visit_mod","","",83],[10,"visit_view_item","","",83],[10,"visit_foreign_item","","",83],[10,"visit_item","","",83],[10,"visit_local","","",83],[10,"visit_block","","",83],[10,"visit_stmt","","",83],[10,"visit_arm","","",83],[10,"visit_pat","","",83],[10,"visit_decl","","",83],[10,"visit_expr","","",83],[10,"visit_expr_post","","",83],[10,"visit_ty","","",83],[10,"visit_generics","","",83],[10,"visit_fn","","",83],[10,"visit_ty_method","","",83],[10,"visit_trait_item","","",83],[10,"visit_trait_ref","","",83],[10,"visit_ty_param_bound","","",83],[10,"visit_poly_trait_ref","","",83],[10,"visit_struct_def","","",83],[10,"visit_struct_field","","",83],[10,"visit_variant","","",83],[10,"visit_opt_lifetime_ref","","",83],[10,"visit_lifetime_bound","","",83],[10,"visit_lifetime_ref","","",83],[10,"visit_lifetime_def","","",83],[10,"visit_explicit_self","","",83],[10,"visit_mac","","",83],[10,"visit_path","","",83],[10,"visit_path_segment","","",83],[10,"visit_path_parameters","","",83],[10,"visit_assoc_type_binding","","",83],[10,"visit_attribute","","",83],[10,"visit_fn","rustc::middle::check_rvalues","",84],[10,"visit_name","","",84],[10,"visit_ident","","",84],[10,"visit_mod","","",84],[10,"visit_view_item","","",84],[10,"visit_foreign_item","","",84],[10,"visit_item","","",84],[10,"visit_local","","",84],[10,"visit_block","","",84],[10,"visit_stmt","","",84],[10,"visit_arm","","",84],[10,"visit_pat","","",84],[10,"visit_decl","","",84],[10,"visit_expr","","",84],[10,"visit_expr_post","","",84],[10,"visit_ty","","",84],[10,"visit_generics","","",84],[10,"visit_fn","","",84],[10,"visit_ty_method","","",84],[10,"visit_trait_item","","",84],[10,"visit_trait_ref","","",84],[10,"visit_ty_param_bound","","",84],[10,"visit_poly_trait_ref","","",84],[10,"visit_struct_def","","",84],[10,"visit_struct_field","","",84],[10,"visit_variant","","",84],[10,"visit_opt_lifetime_ref","","",84],[10,"visit_lifetime_bound","","",84],[10,"visit_lifetime_ref","","",84],[10,"visit_lifetime_def","","",84],[10,"visit_explicit_self","","",84],[10,"visit_mac","","",84],[10,"visit_path","","",84],[10,"visit_path_segment","","",84],[10,"visit_path_parameters","","",84],[10,"visit_assoc_type_binding","","",84],[10,"visit_attribute","","",84],[10,"consume","","",85],[10,"matched_pat","","",85],[10,"consume_pat","","",85],[10,"borrow","","",85],[10,"decl_without_init","","",85],[10,"mutate","","",85],[10,"eq","rustc::middle::check_static","",86],[10,"ne","","",86],[10,"ne","","",86],[10,"assert_receiver_is_total_eq","","",86],[10,"visit_item","","",87],[10,"visit_expr","","This method is used to enforce the constraints on\nimmutable static items. It walks through the *value*\nof the item walking down the expression and evaluating\nevery nested expression. if the expression is not part\nof a static item, this method does nothing but walking\ndown through it.",87],[10,"visit_name","","",87],[10,"visit_ident","","",87],[10,"visit_mod","","",87],[10,"visit_view_item","","",87],[10,"visit_foreign_item","","",87],[10,"visit_item","","",87],[10,"visit_local","","",87],[10,"visit_block","","",87],[10,"visit_stmt","","",87],[10,"visit_arm","","",87],[10,"visit_pat","","",87],[10,"visit_decl","","",87],[10,"visit_expr","","",87],[10,"visit_expr_post","","",87],[10,"visit_ty","","",87],[10,"visit_generics","","",87],[10,"visit_fn","","",87],[10,"visit_ty_method","","",87],[10,"visit_trait_item","","",87],[10,"visit_trait_ref","","",87],[10,"visit_ty_param_bound","","",87],[10,"visit_poly_trait_ref","","",87],[10,"visit_struct_def","","",87],[10,"visit_struct_field","","",87],[10,"visit_variant","","",87],[10,"visit_opt_lifetime_ref","","",87],[10,"visit_lifetime_bound","","",87],[10,"visit_lifetime_ref","","",87],[10,"visit_lifetime_def","","",87],[10,"visit_explicit_self","","",87],[10,"visit_mac","","",87],[10,"visit_path","","",87],[10,"visit_path_segment","","",87],[10,"visit_path_parameters","","",87],[10,"visit_assoc_type_binding","","",87],[10,"visit_attribute","","",87],[10,"visit_item","","",88],[10,"visit_name","","",88],[10,"visit_ident","","",88],[10,"visit_mod","","",88],[10,"visit_view_item","","",88],[10,"visit_foreign_item","","",88],[10,"visit_item","","",88],[10,"visit_local","","",88],[10,"visit_block","","",88],[10,"visit_stmt","","",88],[10,"visit_arm","","",88],[10,"visit_pat","","",88],[10,"visit_decl","","",88],[10,"visit_expr","","",88],[10,"visit_expr_post","","",88],[10,"visit_ty","","",88],[10,"visit_generics","","",88],[10,"visit_fn","","",88],[10,"visit_ty_method","","",88],[10,"visit_trait_item","","",88],[10,"visit_trait_ref","","",88],[10,"visit_ty_param_bound","","",88],[10,"visit_poly_trait_ref","","",88],[10,"visit_struct_def","","",88],[10,"visit_struct_field","","",88],[10,"visit_variant","","",88],[10,"visit_opt_lifetime_ref","","",88],[10,"visit_lifetime_bound","","",88],[10,"visit_lifetime_ref","","",88],[10,"visit_lifetime_def","","",88],[10,"visit_explicit_self","","",88],[10,"visit_mac","","",88],[10,"visit_path","","",88],[10,"visit_path_segment","","",88],[10,"visit_path_parameters","","",88],[10,"visit_assoc_type_binding","","",88],[10,"visit_attribute","","",88],[10,"consume","","",89],[10,"borrow","","",89],[10,"decl_without_init","","",89],[10,"mutate","","",89],[10,"matched_pat","","",89],[10,"consume_pat","","",89],[10,"visit_expr_post","rustc::middle::const_eval","",90],[10,"visit_name","","",90],[10,"visit_ident","","",90],[10,"visit_mod","","",90],[10,"visit_view_item","","",90],[10,"visit_foreign_item","","",90],[10,"visit_item","","",90],[10,"visit_local","","",90],[10,"visit_block","","",90],[10,"visit_stmt","","",90],[10,"visit_arm","","",90],[10,"visit_pat","","",90],[10,"visit_decl","","",90],[10,"visit_expr","","",90],[10,"visit_expr_post","","",90],[10,"visit_ty","","",90],[10,"visit_generics","","",90],[10,"visit_fn","","",90],[10,"visit_ty_method","","",90],[10,"visit_trait_item","","",90],[10,"visit_trait_ref","","",90],[10,"visit_ty_param_bound","","",90],[10,"visit_poly_trait_ref","","",90],[10,"visit_struct_def","","",90],[10,"visit_struct_field","","",90],[10,"visit_variant","","",90],[10,"visit_opt_lifetime_ref","","",90],[10,"visit_lifetime_bound","","",90],[10,"visit_lifetime_ref","","",90],[10,"visit_lifetime_def","","",90],[10,"visit_explicit_self","","",90],[10,"visit_mac","","",90],[10,"visit_path","","",90],[10,"visit_path_segment","","",90],[10,"visit_path_parameters","","",90],[10,"visit_assoc_type_binding","","",90],[10,"visit_attribute","","",90],[10,"eq","","",91],[10,"ne","","",91],[10,"ne","","",91],[10,"clone","","",91],[10,"clone_from","","",91],[10,"fmt","rustc::middle::dataflow","",92],[10,"clone","","",93],[10,"clone_from","","",93],[10,"pre","","",93],[10,"pre","","",93],[10,"post","","",93],[10,"new","","",93],[10,"add_gen","","Indicates that `id` generates `bit`",93],[10,"add_kill","","Indicates that `id` kills `bit`",93],[10,"each_bit_on_entry","","Iterates through each bit that is set on entry to `id`.\nOnly useful after `propagate()` has been called.",93],[10,"each_bit_for_node","","Iterates through each bit that is set on entry/exit to `cfgidx`.\nOnly useful after `propagate()` has been called.",93],[10,"each_gen_bit","","Iterates through each bit in the gen set for `id`.",93],[10,"add_kills_from_flow_exits","","Whenever you have a `break` or `continue` statement, flow\nexits through any number of enclosing scopes on its way to\nthe new destination. This function infers the kill bits of\nthose control operators based on the kill bits associated\nwith those scopes.",93],[10,"propagate","","Performs the data flow analysis.",93],[10,"join","","",94],[10,"join","","",95],[10,"visit_struct_def","rustc::middle::dead","",96],[10,"visit_expr","","",96],[10,"visit_pat","","",96],[10,"visit_path","","",96],[10,"visit_item","","",96],[10,"visit_name","","",96],[10,"visit_ident","","",96],[10,"visit_mod","","",96],[10,"visit_view_item","","",96],[10,"visit_foreign_item","","",96],[10,"visit_item","","",96],[10,"visit_local","","",96],[10,"visit_block","","",96],[10,"visit_stmt","","",96],[10,"visit_arm","","",96],[10,"visit_pat","","",96],[10,"visit_decl","","",96],[10,"visit_expr","","",96],[10,"visit_expr_post","","",96],[10,"visit_ty","","",96],[10,"visit_generics","","",96],[10,"visit_fn","","",96],[10,"visit_ty_method","","",96],[10,"visit_trait_item","","",96],[10,"visit_trait_ref","","",96],[10,"visit_ty_param_bound","","",96],[10,"visit_poly_trait_ref","","",96],[10,"visit_struct_def","","",96],[10,"visit_struct_field","","",96],[10,"visit_variant","","",96],[10,"visit_opt_lifetime_ref","","",96],[10,"visit_lifetime_bound","","",96],[10,"visit_lifetime_ref","","",96],[10,"visit_lifetime_def","","",96],[10,"visit_explicit_self","","",96],[10,"visit_mac","","",96],[10,"visit_path","","",96],[10,"visit_path_segment","","",96],[10,"visit_path_parameters","","",96],[10,"visit_assoc_type_binding","","",96],[10,"visit_attribute","","",96],[10,"visit_item","","",97],[10,"visit_fn","","",97],[10,"visit_name","","",97],[10,"visit_ident","","",97],[10,"visit_mod","","",97],[10,"visit_view_item","","",97],[10,"visit_foreign_item","","",97],[10,"visit_item","","",97],[10,"visit_local","","",97],[10,"visit_block","","",97],[10,"visit_stmt","","",97],[10,"visit_arm","","",97],[10,"visit_pat","","",97],[10,"visit_decl","","",97],[10,"visit_expr","","",97],[10,"visit_expr_post","","",97],[10,"visit_ty","","",97],[10,"visit_generics","","",97],[10,"visit_fn","","",97],[10,"visit_ty_method","","",97],[10,"visit_trait_item","","",97],[10,"visit_trait_ref","","",97],[10,"visit_ty_param_bound","","",97],[10,"visit_poly_trait_ref","","",97],[10,"visit_struct_def","","",97],[10,"visit_struct_field","","",97],[10,"visit_variant","","",97],[10,"visit_opt_lifetime_ref","","",97],[10,"visit_lifetime_bound","","",97],[10,"visit_lifetime_ref","","",97],[10,"visit_lifetime_def","","",97],[10,"visit_explicit_self","","",97],[10,"visit_mac","","",97],[10,"visit_path","","",97],[10,"visit_path_segment","","",97],[10,"visit_path_parameters","","",97],[10,"visit_assoc_type_binding","","",97],[10,"visit_attribute","","",97],[10,"visit_item","","",98],[10,"visit_foreign_item","","",98],[10,"visit_fn","","",98],[10,"visit_struct_field","","",98],[10,"visit_trait_item","","",98],[10,"visit_name","","",98],[10,"visit_ident","","",98],[10,"visit_mod","","",98],[10,"visit_view_item","","",98],[10,"visit_foreign_item","","",98],[10,"visit_item","","",98],[10,"visit_local","","",98],[10,"visit_block","","",98],[10,"visit_stmt","","",98],[10,"visit_arm","","",98],[10,"visit_pat","","",98],[10,"visit_decl","","",98],[10,"visit_expr","","",98],[10,"visit_expr_post","","",98],[10,"visit_ty","","",98],[10,"visit_generics","","",98],[10,"visit_fn","","",98],[10,"visit_ty_method","","",98],[10,"visit_trait_item","","",98],[10,"visit_trait_ref","","",98],[10,"visit_ty_param_bound","","",98],[10,"visit_poly_trait_ref","","",98],[10,"visit_struct_def","","",98],[10,"visit_struct_field","","",98],[10,"visit_variant","","",98],[10,"visit_opt_lifetime_ref","","",98],[10,"visit_lifetime_bound","","",98],[10,"visit_lifetime_ref","","",98],[10,"visit_lifetime_def","","",98],[10,"visit_explicit_self","","",98],[10,"visit_mac","","",98],[10,"visit_path","","",98],[10,"visit_path_segment","","",98],[10,"visit_path_parameters","","",98],[10,"visit_assoc_type_binding","","",98],[10,"visit_attribute","","",98],[10,"fmt","rustc::middle::def","",56],[10,"hash","","",56],[10,"decode","","",56],[10,"encode","","",56],[10,"assert_receiver_is_total_eq","","",56],[10,"eq","","",56],[10,"ne","","",56],[10,"ne","","",56],[10,"clone","","",56],[10,"clone_from","","",56],[10,"fmt","","",99],[10,"hash","","",99],[10,"decode","","",99],[10,"encode","","",99],[10,"assert_receiver_is_total_eq","","",99],[10,"eq","","",99],[10,"ne","","",99],[10,"ne","","",99],[10,"clone","","",99],[10,"clone_from","","",99],[10,"fmt","","",100],[10,"hash","","",100],[10,"decode","","",100],[10,"encode","","",100],[10,"assert_receiver_is_total_eq","","",100],[10,"eq","","",100],[10,"ne","","",100],[10,"ne","","",100],[10,"clone","","",100],[10,"clone_from","","",100],[10,"map","","",99],[10,"def_id","","",100],[10,"eq","","",101],[10,"ne","","",101],[10,"ne","","",101],[10,"assert_receiver_is_total_eq","","",101],[10,"clone","","",101],[10,"clone_from","","",101],[10,"from_explicit_self_category","","",101],[10,"def_id","","",56],[10,"variant_def_ids","","",56],[10,"eq","rustc::middle::effect","",102],[10,"ne","","",102],[10,"ne","","",102],[10,"visit_fn","","",103],[10,"visit_block","","",103],[10,"visit_expr","","",103],[10,"visit_name","","",103],[10,"visit_ident","","",103],[10,"visit_mod","","",103],[10,"visit_view_item","","",103],[10,"visit_foreign_item","","",103],[10,"visit_item","","",103],[10,"visit_local","","",103],[10,"visit_block","","",103],[10,"visit_stmt","","",103],[10,"visit_arm","","",103],[10,"visit_pat","","",103],[10,"visit_decl","","",103],[10,"visit_expr","","",103],[10,"visit_expr_post","","",103],[10,"visit_ty","","",103],[10,"visit_generics","","",103],[10,"visit_fn","","",103],[10,"visit_ty_method","","",103],[10,"visit_trait_item","","",103],[10,"visit_trait_ref","","",103],[10,"visit_ty_param_bound","","",103],[10,"visit_poly_trait_ref","","",103],[10,"visit_struct_def","","",103],[10,"visit_struct_field","","",103],[10,"visit_variant","","",103],[10,"visit_opt_lifetime_ref","","",103],[10,"visit_lifetime_bound","","",103],[10,"visit_lifetime_ref","","",103],[10,"visit_lifetime_def","","",103],[10,"visit_explicit_self","","",103],[10,"visit_mac","","",103],[10,"visit_path","","",103],[10,"visit_path_segment","","",103],[10,"visit_path_parameters","","",103],[10,"visit_assoc_type_binding","","",103],[10,"visit_attribute","","",103],[10,"visit_item","rustc::middle::entry","",104],[10,"visit_name","","",104],[10,"visit_ident","","",104],[10,"visit_mod","","",104],[10,"visit_view_item","","",104],[10,"visit_foreign_item","","",104],[10,"visit_item","","",104],[10,"visit_local","","",104],[10,"visit_block","","",104],[10,"visit_stmt","","",104],[10,"visit_arm","","",104],[10,"visit_pat","","",104],[10,"visit_decl","","",104],[10,"visit_expr","","",104],[10,"visit_expr_post","","",104],[10,"visit_ty","","",104],[10,"visit_generics","","",104],[10,"visit_fn","","",104],[10,"visit_ty_method","","",104],[10,"visit_trait_item","","",104],[10,"visit_trait_ref","","",104],[10,"visit_ty_param_bound","","",104],[10,"visit_poly_trait_ref","","",104],[10,"visit_struct_def","","",104],[10,"visit_struct_field","","",104],[10,"visit_variant","","",104],[10,"visit_opt_lifetime_ref","","",104],[10,"visit_lifetime_bound","","",104],[10,"visit_lifetime_ref","","",104],[10,"visit_lifetime_def","","",104],[10,"visit_explicit_self","","",104],[10,"visit_mac","","",104],[10,"visit_path","","",104],[10,"visit_path_segment","","",104],[10,"visit_path_parameters","","",104],[10,"visit_assoc_type_binding","","",104],[10,"visit_attribute","","",104],[10,"fmt","rustc::middle::expr_use_visitor","",105],[10,"eq","","",105],[10,"ne","","",105],[10,"ne","","",105],[10,"fmt","","",106],[10,"eq","","",106],[10,"ne","","",106],[10,"ne","","",106],[10,"fmt","","",107],[10,"eq","","",107],[10,"ne","","",107],[10,"ne","","",107],[10,"fmt","","",108],[10,"eq","","",108],[10,"ne","","",108],[10,"ne","","",108],[10,"fmt","","",109],[10,"eq","","",109],[10,"ne","","",109],[10,"ne","","",109],[10,"fmt","","",110],[10,"eq","","",110],[10,"ne","","",110],[10,"ne","","",110],[10,"new","","",111],[10,"walk_fn","","",111],[10,"consume_expr","","",111],[10,"walk_expr","","",111],[10,"hash","rustc::middle::fast_reject","",112],[10,"assert_receiver_is_total_eq","","",112],[10,"eq","","",112],[10,"ne","","",112],[10,"ne","","",112],[10,"clone","","",112],[10,"clone_from","","",112],[10,"fmt","rustc::middle::graph","",113],[10,"fmt","","",114],[10,"eq","","",114],[10,"ne","","",114],[10,"ne","","",114],[10,"clone","","",114],[10,"clone_from","","",114],[10,"fmt","","",115],[10,"eq","","",115],[10,"ne","","",115],[10,"ne","","",115],[10,"fmt","","",116],[10,"node_id","","Returns unique id (unique with respect to the graph holding associated node).",114],[10,"edge_id","","Returns unique id (unique with respect to the graph holding associated edge).",115],[10,"new","","",117],[10,"with_capacity","","",117],[10,"all_nodes","","",117],[10,"all_edges","","",117],[10,"next_node_index","","",117],[10,"add_node","","",117],[10,"mut_node_data","","",117],[10,"node_data","","",117],[10,"node","","",117],[10,"next_edge_index","","",117],[10,"add_edge","","",117],[10,"mut_edge_data","","",117],[10,"edge_data","","",117],[10,"edge","","",117],[10,"first_adjacent","","Accesses the index of the first edge adjacent to `node`.\nThis is useful if you wish to modify the graph while walking\nthe linked list of edges.",117],[10,"next_adjacent","","Accesses the next edge in a given direction.\nThis is useful if you wish to modify the graph while walking\nthe linked list of edges.",117],[10,"each_node","","Iterates over all edges defined in the graph.",117],[10,"each_edge","","Iterates over all edges defined in the graph",117],[10,"each_outgoing_edge","","Iterates over all outgoing edges from the node `from`",117],[10,"each_incoming_edge","","Iterates over all incoming edges to the node `target`",117],[10,"each_adjacent_edge","","Iterates over all edges adjacent to the node `node`\nin the direction `dir` (either `Outgoing` or `Incoming)",117],[10,"iterate_until_fixed_point","","",117],[10,"depth_traverse","","",117],[10,"next","","",118],[10,"size_hint","","",118],[10,"source","","",113],[10,"target","","",113],[10,"visit_fn","rustc::middle::intrinsicck","",119],[10,"visit_expr","","",119],[10,"visit_name","","",119],[10,"visit_ident","","",119],[10,"visit_mod","","",119],[10,"visit_view_item","","",119],[10,"visit_foreign_item","","",119],[10,"visit_item","","",119],[10,"visit_local","","",119],[10,"visit_block","","",119],[10,"visit_stmt","","",119],[10,"visit_arm","","",119],[10,"visit_pat","","",119],[10,"visit_decl","","",119],[10,"visit_expr","","",119],[10,"visit_expr_post","","",119],[10,"visit_ty","","",119],[10,"visit_generics","","",119],[10,"visit_fn","","",119],[10,"visit_ty_method","","",119],[10,"visit_trait_item","","",119],[10,"visit_trait_ref","","",119],[10,"visit_ty_param_bound","","",119],[10,"visit_poly_trait_ref","","",119],[10,"visit_struct_def","","",119],[10,"visit_struct_field","","",119],[10,"visit_variant","","",119],[10,"visit_opt_lifetime_ref","","",119],[10,"visit_lifetime_bound","","",119],[10,"visit_lifetime_ref","","",119],[10,"visit_lifetime_def","","",119],[10,"visit_explicit_self","","",119],[10,"visit_mac","","",119],[10,"visit_path","","",119],[10,"visit_path_segment","","",119],[10,"visit_path_parameters","","",119],[10,"visit_assoc_type_binding","","",119],[10,"visit_attribute","","",119],[10,"repr","rustc::middle::ty","",120],[10,"get_ref","rustc::middle::infer::coercion","",121],[10,"tys","","",121],[10,"subtype","","",121],[10,"unpack_actual_value","","",121],[10,"coerce_borrowed_pointer","","",121],[10,"coerce_borrowed_fn","","",121],[10,"coerce_unsafe_ptr","","",121],[10,"combine","alloc::rc","",122],[10,"combine","rustc::middle::ty","",123],[10,"combine","","",124],[10,"combine","","",125],[10,"clone","rustc::middle::infer::combine","",126],[10,"clone_from","","",126],[10,"switch_expected","","",126],[10,"instantiate","","",126],[10,"tcx","","",127],[10,"fold_ty","","",127],[10,"fold_region","","",127],[10,"enter_region_binder","","",127],[10,"exit_region_binder","","",127],[10,"fold_ty","","",127],[10,"fold_mt","","",127],[10,"fold_trait_ref","","",127],[10,"fold_substs","","",127],[10,"fold_fn_sig","","",127],[10,"fold_output","","",127],[10,"fold_bare_fn_ty","","",127],[10,"fold_closure_ty","","",127],[10,"fold_region","","",127],[10,"fold_trait_store","","",127],[10,"fold_existential_bounds","","",127],[10,"fold_autoref","","",127],[10,"fold_item_substs","","",127],[10,"infcx","rustc::middle::infer::equate","",128],[10,"tag","","",128],[10,"a_is_expected","","",128],[10,"trace","","",128],[10,"equate","","",128],[10,"sub","","",128],[10,"lub","","",128],[10,"glb","","",128],[10,"contratys","","",128],[10,"contraregions","","",128],[10,"regions","","",128],[10,"mts","","",128],[10,"unsafeties","","",128],[10,"oncenesses","","",128],[10,"builtin_bounds","","",128],[10,"tys","","",128],[10,"binders","","",128],[10,"tcx","","",128],[10,"tps","","",128],[10,"substs","","",128],[10,"substs_variances","","",128],[10,"bare_fn_tys","","",128],[10,"closure_tys","","",128],[10,"fn_sigs","","",128],[10,"args","","",128],[10,"abi","","",128],[10,"projection_tys","","",128],[10,"projection_predicates","","",128],[10,"projection_bounds","","",128],[10,"existential_bounds","","",128],[10,"trait_stores","","",128],[10,"trait_refs","","",128],[10,"report_region_errors","rustc::middle::infer","",129],[10,"process_errors","","",129],[10,"report_type_error","","",129],[10,"report_and_explain_type_error","","",129],[10,"values_str","","Returns a string of the form \"expected `{}`, found `{}`\", or None if this is a derived\nerror.",129],[10,"expected_found_str","","",129],[10,"report_param_bound_failure","","",129],[10,"report_concrete_failure","","",129],[10,"report_sub_sup_conflict","","",129],[10,"report_sup_sup_conflict","","",129],[10,"report_processed_errors","","",129],[10,"give_suggestion","","",129],[10,"give_expl_lifetime_param","","",129],[10,"report_inference_failure","","",129],[10,"note_region_origin","","",129],[10,"resolve","alloc::rc","",122],[10,"contains_error","","",122],[10,"resolve","rustc::middle::ty","",130],[10,"contains_error","","",130],[10,"infcx","rustc::middle::infer::glb","",131],[10,"tag","","",131],[10,"a_is_expected","","",131],[10,"trace","","",131],[10,"equate","","",131],[10,"sub","","",131],[10,"lub","","",131],[10,"glb","","",131],[10,"mts","","",131],[10,"contratys","","",131],[10,"unsafeties","","",131],[10,"oncenesses","","",131],[10,"builtin_bounds","","",131],[10,"regions","","",131],[10,"contraregions","","",131],[10,"tys","","",131],[10,"binders","","",131],[10,"tcx","","",131],[10,"tps","","",131],[10,"substs","","",131],[10,"substs_variances","","",131],[10,"bare_fn_tys","","",131],[10,"closure_tys","","",131],[10,"fn_sigs","","",131],[10,"args","","",131],[10,"abi","","",131],[10,"projection_tys","","",131],[10,"projection_predicates","","",131],[10,"projection_bounds","","",131],[10,"existential_bounds","","",131],[10,"trait_stores","","",131],[10,"trait_refs","","",131],[10,"tainted_regions","rustc::middle::infer","",129],[10,"region_vars_confined_to_snapshot","","Returns the set of region variables that do not affect any\ntypes/regions which existed before `snapshot` was\nstarted. This is used in the sub/lub/glb computations. The\nidea here is that when we are computing lub/glb of two\nregions, we sometimes create intermediate region variables.\nThose region variables may touch some of the skolemized or\nother \"forbidden\" regions we created to replace bound\nregions, but they don't really represent an \"external\"\nconstraint.",129],[10,"relate_bound","rustc::middle::infer::lub","",132],[10,"relate_bound","rustc::middle::infer::glb","",131],[10,"infcx","rustc::middle::infer::lub","",132],[10,"tag","","",132],[10,"a_is_expected","","",132],[10,"trace","","",132],[10,"equate","","",132],[10,"sub","","",132],[10,"lub","","",132],[10,"glb","","",132],[10,"mts","","",132],[10,"contratys","","",132],[10,"unsafeties","","",132],[10,"oncenesses","","",132],[10,"builtin_bounds","","",132],[10,"contraregions","","",132],[10,"regions","","",132],[10,"tys","","",132],[10,"binders","","",132],[10,"tcx","","",132],[10,"tps","","",132],[10,"substs","","",132],[10,"substs_variances","","",132],[10,"bare_fn_tys","","",132],[10,"closure_tys","","",132],[10,"fn_sigs","","",132],[10,"args","","",132],[10,"abi","","",132],[10,"projection_tys","","",132],[10,"projection_predicates","","",132],[10,"projection_bounds","","",132],[10,"existential_bounds","","",132],[10,"trait_stores","","",132],[10,"trait_refs","","",132],[10,"fmt","rustc::middle::infer::region_inference::graphviz","",133],[10,"assert_receiver_is_total_eq","","",133],[10,"eq","","",133],[10,"ne","","",133],[10,"ne","","",133],[10,"hash","","",133],[10,"clone","","",133],[10,"clone_from","","",133],[10,"graph_id","","",134],[10,"node_id","","",134],[10,"node_label","","",134],[10,"edge_label","","",134],[10,"node_label","","",134],[10,"edge_label","","",134],[10,"nodes","","",134],[10,"edges","","",134],[10,"source","","",134],[10,"target","","",134],[10,"fmt","rustc::middle::infer::region_inference","",135],[10,"hash","","",135],[10,"assert_receiver_is_total_eq","","",135],[10,"eq","","",135],[10,"ne","","",135],[10,"ne","","",135],[10,"clone","","",135],[10,"clone_from","","",135],[10,"hash","","",136],[10,"assert_receiver_is_total_eq","","",136],[10,"eq","","",136],[10,"ne","","",136],[10,"ne","","",136],[10,"eq","","",137],[10,"ne","","",137],[10,"ne","","",137],[10,"eq","","",138],[10,"ne","","",138],[10,"ne","","",138],[10,"fmt","","",139],[10,"clone","","",139],[10,"clone_from","","",139],[10,"fmt","","",140],[10,"clone","","",140],[10,"clone_from","","",140],[10,"contains","","",140],[10,"push","","",140],[10,"fmt","","",141],[10,"new","","",142],[10,"start_snapshot","","",142],[10,"commit","","",142],[10,"rollback_to","","",142],[10,"num_vars","","",142],[10,"new_region_var","","",142],[10,"new_skolemized","","Creates a new skolemized region. Skolemized regions are fresh\nregions used when performing higher-ranked computations. They\nmust be used in a very particular way and are never supposed\nto \"escape\" out into error messages or the code at large.",142],[10,"new_bound","","",142],[10,"add_given","","",142],[10,"make_eqregion","","",142],[10,"make_subregion","","",142],[10,"verify_param_bound","","",142],[10,"lub_regions","","",142],[10,"glb_regions","","",142],[10,"resolve_var","","",142],[10,"combine_vars","","",142],[10,"vars_created_since_snapshot","","",142],[10,"tainted","","Computes all regions that have been related to `r0` in any way since the mark `mark` was\nmade---`r0` itself will be the first entry. This is used when checking whether skolemized\nregions are being improperly related to other regions.",142],[10,"resolve_regions","","This function performs the actual region resolution.  It must be\ncalled after all constraints have been added.  It performs a\nfixed-point iteration to find region values which satisfy all\nconstraints, assuming such values can be found; if they cannot,\nerrors are reported.",142],[10,"fmt","","",143],[10,"eq","","",143],[10,"ne","","",143],[10,"ne","","",143],[10,"repr","","",135],[10,"repr","","",144],[10,"repr","","",145],[10,"repr","","",146],[10,"new","rustc::middle::infer::resolve","",147],[10,"tcx","","",147],[10,"fold_ty","","",147],[10,"enter_region_binder","","",147],[10,"exit_region_binder","","",147],[10,"fold_ty","","",147],[10,"fold_mt","","",147],[10,"fold_trait_ref","","",147],[10,"fold_substs","","",147],[10,"fold_fn_sig","","",147],[10,"fold_output","","",147],[10,"fold_bare_fn_ty","","",147],[10,"fold_closure_ty","","",147],[10,"fold_region","","",147],[10,"fold_trait_store","","",147],[10,"fold_existential_bounds","","",147],[10,"fold_autoref","","",147],[10,"fold_item_substs","","",147],[10,"tcx","","",148],[10,"fold_ty","","",148],[10,"fold_region","","",148],[10,"enter_region_binder","","",148],[10,"exit_region_binder","","",148],[10,"fold_ty","","",148],[10,"fold_mt","","",148],[10,"fold_trait_ref","","",148],[10,"fold_substs","","",148],[10,"fold_fn_sig","","",148],[10,"fold_output","","",148],[10,"fold_bare_fn_ty","","",148],[10,"fold_closure_ty","","",148],[10,"fold_region","","",148],[10,"fold_trait_store","","",148],[10,"fold_existential_bounds","","",148],[10,"fold_autoref","","",148],[10,"fold_item_substs","","",148],[10,"new","rustc::middle::infer::freshen","",149],[10,"tcx","","",149],[10,"fold_region","","",149],[10,"fold_ty","","",149],[10,"enter_region_binder","","",149],[10,"exit_region_binder","","",149],[10,"fold_ty","","",149],[10,"fold_mt","","",149],[10,"fold_trait_ref","","",149],[10,"fold_substs","","",149],[10,"fold_fn_sig","","",149],[10,"fold_output","","",149],[10,"fold_bare_fn_ty","","",149],[10,"fold_closure_ty","","",149],[10,"fold_region","","",149],[10,"fold_trait_store","","",149],[10,"fold_existential_bounds","","",149],[10,"fold_autoref","","",149],[10,"fold_item_substs","","",149],[10,"infcx","rustc::middle::infer::sub","",150],[10,"tag","","",150],[10,"a_is_expected","","",150],[10,"trace","","",150],[10,"equate","","",150],[10,"sub","","",150],[10,"lub","","",150],[10,"glb","","",150],[10,"contratys","","",150],[10,"contraregions","","",150],[10,"regions","","",150],[10,"mts","","",150],[10,"unsafeties","","",150],[10,"oncenesses","","",150],[10,"builtin_bounds","","",150],[10,"tys","","",150],[10,"binders","","",150],[10,"tcx","","",150],[10,"tps","","",150],[10,"substs","","",150],[10,"substs_variances","","",150],[10,"bare_fn_tys","","",150],[10,"closure_tys","","",150],[10,"fn_sigs","","",150],[10,"args","","",150],[10,"abi","","",150],[10,"projection_tys","","",150],[10,"projection_predicates","","",150],[10,"projection_bounds","","",150],[10,"existential_bounds","","",150],[10,"trait_stores","","",150],[10,"trait_refs","","",150],[10,"fmt","rustc::middle::infer::type_variable","",151],[10,"eq","","",151],[10,"ne","","",151],[10,"ne","","",151],[10,"new","","",152],[10,"var_diverges","","",152],[10,"relate_vars","","Records that `a <: b`, `a :> b`, or `a == b`, depending on `dir`.",152],[10,"instantiate_and_push","","Instantiates `vid` with the type `ty` and then pushes an entry onto `stack` for each of the\nrelations of `vid` to other variables. The relations will have the form `(ty, dir, vid1)`\nwhere `vid1` is some other variable id.",152],[10,"new_var","","",152],[10,"probe","","",152],[10,"replace_if_possible","","",152],[10,"snapshot","","",152],[10,"rollback_to","","",152],[10,"commit","","",152],[10,"types_escaping_snapshot","","Find the set of type variables that existed *before* `s`\nbut which have only been unified since `s` started, and\nreturn the types with which they were unified. So if we had\na type variable `V0`, then we started the snapshot, then we\ncreated a type variable `V1`, unifed `V0` with `T0`, and\nunified `V1` with `T1`, this function would return `{T0}`.",152],[10,"reverse","","",153],[10,"clone","rustc::middle::infer::unify","",154],[10,"clone_from","","",154],[10,"eq","","",154],[10,"ne","","",154],[10,"ne","","",154],[10,"new","","",155],[10,"snapshot","","Starts a new snapshot. Each snapshot must be either\nrolled back or committed in a \"LIFO\" (stack) order.",155],[10,"rollback_to","","Reverses all changes since the last snapshot. Also\nremoves any keys that have been created since then.",155],[10,"commit","","Commits all changes since the last snapshot. Of course, they\ncan still be undone if there is a snapshot further out.",155],[10,"new_key","","",155],[10,"get","","Find the root node for `vid`. This uses the standard union-find algorithm with path\ncompression: http://en.wikipedia.org/wiki/Disjoint-set_data_structure",155],[10,"set","","Sets the value for `vid` to `new_value`. `vid` MUST be a root node! Also, we must be in the\nmiddle of a snapshot.",155],[10,"unify","","Either redirects node_a to node_b or vice versa, depending on the relative rank. Returns\nthe new root and rank. You should then update the value of the new root to something\nsuitable.",155],[10,"reverse","","",156],[10,"simple_vars","rustc::middle::infer","Unifies two simple keys. Because simple keys do not have any subtyping relationships, if\nboth keys have already been associated with a value, then those two values must be the\nsame.",129],[10,"simple_var_t","","Sets the value of the key `a_id` to `b`. Because simple keys do not have any subtyping\nrelationships, if `a_id` already has a value, it must be the same as `b`.",129],[10,"probe_var","","",129],[10,"index","rustc::middle::ty","",157],[10,"from_index","","",157],[10,"unification_table","","",157],[10,"tag","","",157],[10,"to_type","","",158],[10,"to_type_err","","",158],[10,"index","","",159],[10,"from_index","","",159],[10,"unification_table","","",159],[10,"tag","","",159],[10,"to_type","syntax::ast","",160],[10,"to_type_err","","",160],[10,"repr","rustc::middle::infer::unify","",154],[10,"fmt","rustc::middle::infer","",161],[10,"clone","","",161],[10,"clone_from","","",161],[10,"fmt","","",162],[10,"clone","","",162],[10,"clone_from","","",162],[10,"fmt","","",163],[10,"clone","","",163],[10,"clone_from","","",163],[10,"fmt","","",164],[10,"clone","","",164],[10,"clone_from","","",164],[10,"fmt","","",165],[10,"clone","","",165],[10,"clone_from","","",165],[10,"fmt","","",166],[10,"clone","","",166],[10,"clone_from","","",166],[10,"fmt","","",167],[10,"then","core::result","",168],[10,"to_ures","","",168],[10,"compare","","",168],[10,"freshen","rustc::middle::infer","",129],[10,"type_var_diverges","","",129],[10,"freshener","","",129],[10,"combine_fields","","",129],[10,"equate","","",129],[10,"sub","","",129],[10,"lub","","",129],[10,"commit_unconditionally","","Execute `f` and commit the bindings",129],[10,"commit_if_ok","","Execute `f` and commit the bindings if successful",129],[10,"try","","Execute `f`, unroll bindings on panic",129],[10,"probe","","Execute `f` then unroll any bindings it creates",129],[10,"add_given","","",129],[10,"sub_types","","",129],[10,"eq_types","","",129],[10,"sub_trait_refs","","",129],[10,"sub_poly_trait_refs","","",129],[10,"skolemize_late_bound_regions","","See `higher_ranked::skolemize_late_bound_regions`",129],[10,"leak_check","","See `higher_ranked::leak_check`",129],[10,"plug_leaks","","See `higher_ranked::plug_leaks`",129],[10,"equality_predicate","","",129],[10,"region_outlives_predicate","","",129],[10,"next_ty_var_id","","",129],[10,"next_ty_var","","",129],[10,"next_diverging_ty_var","","",129],[10,"next_ty_vars","","",129],[10,"next_int_var_id","","",129],[10,"next_float_var_id","","",129],[10,"next_region_var","","",129],[10,"region_vars_for_defs","","",129],[10,"fresh_substs_for_generics","","Given a set of generics defined on a type or impl, returns a substitution mapping each\ntype/region parameter to a fresh inference variable.",129],[10,"fresh_substs_for_trait","","Given a set of generics defined on a trait, returns a substitution mapping each output\ntype/region parameter to a fresh inference variable, and mapping the self type to\n`self_ty`.",129],[10,"fresh_bound_region","","",129],[10,"resolve_regions_and_report_errors","","",129],[10,"ty_to_string","","",129],[10,"tys_to_string","","",129],[10,"trait_ref_to_string","","",129],[10,"shallow_resolve","","",129],[10,"resolve_type_vars_if_possible","","Where possible, replaces type/int/float variables in\n`value` with their final value. Note that region variables\nare unaffected. If a type variable has not been unified, it\nis left as is.  This is an idempotent operation that does\nnot affect inference state in any way and so you can do it\nat will.",129],[10,"fully_resolve","","Attempts to resolve all type/region variables in\n`value`. Region inference must have been run already (e.g.,\nby calling `resolve_regions_and_report_errors`).  If some\nvariable was never unified, an `Err` results.",129],[10,"type_error_message_str","","",129],[10,"type_error_message_str_with_expected","","",129],[10,"type_error_message","","",129],[10,"report_mismatched_types","","",129],[10,"replace_late_bound_regions_with_fresh_var","","",129],[10,"span","","",163],[10,"dummy","","",163],[10,"repr","","",163],[10,"span","","",161],[10,"repr","","",161],[10,"span","","",164],[10,"repr","","",164],[10,"span","","",166],[10,"repr","","",166],[10,"hash","rustc::middle::lang_items","",169],[10,"assert_receiver_is_total_eq","","",169],[10,"eq","","",169],[10,"ne","","",169],[10,"ne","","",169],[10,"from_i64","","",169],[10,"from_u64","","",169],[10,"from_int","","",169],[10,"from_i8","","",169],[10,"from_i16","","",169],[10,"from_i32","","",169],[10,"from_uint","","",169],[10,"from_u8","","",169],[10,"from_u16","","",169],[10,"from_u32","","",169],[10,"from_f32","","",169],[10,"from_f64","","",169],[10,"new","","",170],[10,"items","","",170],[10,"item_name","","",170],[10,"require","","",170],[10,"from_builtin_kind","","",170],[10,"to_builtin_kind","","",170],[10,"fn_trait_kind","","",170],[10,"send_trait","","",170],[10,"sized_trait","","",170],[10,"copy_trait","","",170],[10,"sync_trait","","",170],[10,"drop_trait","","",170],[10,"add_trait","","",170],[10,"sub_trait","","",170],[10,"mul_trait","","",170],[10,"div_trait","","",170],[10,"rem_trait","","",170],[10,"neg_trait","","",170],[10,"not_trait","","",170],[10,"bitxor_trait","","",170],[10,"bitand_trait","","",170],[10,"bitor_trait","","",170],[10,"shl_trait","","",170],[10,"shr_trait","","",170],[10,"index_trait","","",170],[10,"index_mut_trait","","",170],[10,"slice_trait","","",170],[10,"slice_mut_trait","","",170],[10,"range_struct","","",170],[10,"range_from_struct","","",170],[10,"range_to_struct","","",170],[10,"full_range_struct","","",170],[10,"unsafe_type","","",170],[10,"deref_trait","","",170],[10,"deref_mut_trait","","",170],[10,"fn_trait","","",170],[10,"fn_mut_trait","","",170],[10,"fn_once_trait","","",170],[10,"eq_trait","","",170],[10,"ord_trait","","",170],[10,"str_eq_fn","","",170],[10,"panic_fn","","",170],[10,"panic_bounds_check_fn","","",170],[10,"panic_fmt","","",170],[10,"exchange_malloc_fn","","",170],[10,"exchange_free_fn","","",170],[10,"strdup_uniq_fn","","",170],[10,"start_fn","","",170],[10,"ty_desc","","",170],[10,"opaque","","",170],[10,"type_id","","",170],[10,"eh_personality","","",170],[10,"exchange_heap","","",170],[10,"owned_box","","",170],[10,"covariant_type","","",170],[10,"contravariant_type","","",170],[10,"invariant_type","","",170],[10,"covariant_lifetime","","",170],[10,"contravariant_lifetime","","",170],[10,"invariant_lifetime","","",170],[10,"no_send_bound","","",170],[10,"no_copy_bound","","",170],[10,"no_sync_bound","","",170],[10,"managed_bound","","",170],[10,"non_zero","","",170],[10,"iterator","","",170],[10,"stack_exhausted","","",170],[10,"visit_item","","",171],[10,"visit_name","","",171],[10,"visit_ident","","",171],[10,"visit_mod","","",171],[10,"visit_view_item","","",171],[10,"visit_foreign_item","","",171],[10,"visit_item","","",171],[10,"visit_local","","",171],[10,"visit_block","","",171],[10,"visit_stmt","","",171],[10,"visit_arm","","",171],[10,"visit_pat","","",171],[10,"visit_decl","","",171],[10,"visit_expr","","",171],[10,"visit_expr_post","","",171],[10,"visit_ty","","",171],[10,"visit_generics","","",171],[10,"visit_fn","","",171],[10,"visit_ty_method","","",171],[10,"visit_trait_item","","",171],[10,"visit_trait_ref","","",171],[10,"visit_ty_param_bound","","",171],[10,"visit_poly_trait_ref","","",171],[10,"visit_struct_def","","",171],[10,"visit_struct_field","","",171],[10,"visit_variant","","",171],[10,"visit_opt_lifetime_ref","","",171],[10,"visit_lifetime_bound","","",171],[10,"visit_lifetime_ref","","",171],[10,"visit_lifetime_def","","",171],[10,"visit_explicit_self","","",171],[10,"visit_mac","","",171],[10,"visit_path","","",171],[10,"visit_path_segment","","",171],[10,"visit_path_parameters","","",171],[10,"visit_assoc_type_binding","","",171],[10,"visit_attribute","","",171],[10,"new","","",171],[10,"collect_item","","",171],[10,"collect_local_language_items","","",171],[10,"collect_external_language_items","","",171],[10,"collect","","",171],[10,"eq","rustc::middle::liveness","",172],[10,"ne","","",172],[10,"ne","","",172],[10,"eq","","",173],[10,"ne","","",173],[10,"ne","","",173],[10,"clone","","",173],[10,"clone_from","","",173],[10,"fmt","","",174],[10,"eq","","",174],[10,"ne","","",174],[10,"ne","","",174],[10,"visit_fn","","",175],[10,"visit_local","","",175],[10,"visit_expr","","",175],[10,"visit_arm","","",175],[10,"visit_name","","",175],[10,"visit_ident","","",175],[10,"visit_mod","","",175],[10,"visit_view_item","","",175],[10,"visit_foreign_item","","",175],[10,"visit_item","","",175],[10,"visit_local","","",175],[10,"visit_block","","",175],[10,"visit_stmt","","",175],[10,"visit_arm","","",175],[10,"visit_pat","","",175],[10,"visit_decl","","",175],[10,"visit_expr","","",175],[10,"visit_expr_post","","",175],[10,"visit_ty","","",175],[10,"visit_generics","","",175],[10,"visit_fn","","",175],[10,"visit_ty_method","","",175],[10,"visit_trait_item","","",175],[10,"visit_trait_ref","","",175],[10,"visit_ty_param_bound","","",175],[10,"visit_poly_trait_ref","","",175],[10,"visit_struct_def","","",175],[10,"visit_struct_field","","",175],[10,"visit_variant","","",175],[10,"visit_opt_lifetime_ref","","",175],[10,"visit_lifetime_bound","","",175],[10,"visit_lifetime_ref","","",175],[10,"visit_lifetime_def","","",175],[10,"visit_explicit_self","","",175],[10,"visit_mac","","",175],[10,"visit_path","","",175],[10,"visit_path_segment","","",175],[10,"visit_path_parameters","","",175],[10,"visit_assoc_type_binding","","",175],[10,"visit_attribute","","",175],[10,"fmt","","",173],[10,"fmt","","",172],[10,"fmt","","",176],[10,"fmt","","",177],[10,"visit_fn","","",178],[10,"visit_local","","",178],[10,"visit_expr","","",178],[10,"visit_arm","","",178],[10,"visit_name","","",178],[10,"visit_ident","","",178],[10,"visit_mod","","",178],[10,"visit_view_item","","",178],[10,"visit_foreign_item","","",178],[10,"visit_item","","",178],[10,"visit_local","","",178],[10,"visit_block","","",178],[10,"visit_stmt","","",178],[10,"visit_arm","","",178],[10,"visit_pat","","",178],[10,"visit_decl","","",178],[10,"visit_expr","","",178],[10,"visit_expr_post","","",178],[10,"visit_ty","","",178],[10,"visit_generics","","",178],[10,"visit_fn","","",178],[10,"visit_ty_method","","",178],[10,"visit_trait_item","","",178],[10,"visit_trait_ref","","",178],[10,"visit_ty_param_bound","","",178],[10,"visit_poly_trait_ref","","",178],[10,"visit_struct_def","","",178],[10,"visit_struct_field","","",178],[10,"visit_variant","","",178],[10,"visit_opt_lifetime_ref","","",178],[10,"visit_lifetime_bound","","",178],[10,"visit_lifetime_ref","","",178],[10,"visit_lifetime_def","","",178],[10,"visit_explicit_self","","",178],[10,"visit_mac","","",178],[10,"visit_path","","",178],[10,"visit_path_segment","","",178],[10,"visit_path_parameters","","",178],[10,"visit_assoc_type_binding","","",178],[10,"visit_attribute","","",178],[10,"clone","","",179],[10,"clone_from","","",179],[10,"fmt","rustc::middle::mem_categorization","",180],[10,"eq","","",180],[10,"ne","","",180],[10,"ne","","",180],[10,"clone","","",180],[10,"clone_from","","",180],[10,"fmt","","",181],[10,"eq","","",181],[10,"ne","","",181],[10,"ne","","",181],[10,"clone","","",181],[10,"clone_from","","",181],[10,"fmt","","",182],[10,"hash","","",182],[10,"assert_receiver_is_total_eq","","",182],[10,"eq","","",182],[10,"ne","","",182],[10,"ne","","",182],[10,"clone","","",182],[10,"clone_from","","",182],[10,"fmt","","",183],[10,"hash","","",183],[10,"assert_receiver_is_total_eq","","",183],[10,"eq","","",183],[10,"ne","","",183],[10,"ne","","",183],[10,"clone","","",183],[10,"clone_from","","",183],[10,"fmt","","",184],[10,"hash","","",184],[10,"assert_receiver_is_total_eq","","",184],[10,"eq","","",184],[10,"ne","","",184],[10,"ne","","",184],[10,"clone","","",184],[10,"clone_from","","",184],[10,"fmt","","",185],[10,"hash","","",185],[10,"assert_receiver_is_total_eq","","",185],[10,"eq","","",185],[10,"ne","","",185],[10,"ne","","",185],[10,"clone","","",185],[10,"clone_from","","",185],[10,"fmt","","",186],[10,"hash","","",186],[10,"assert_receiver_is_total_eq","","",186],[10,"eq","","",186],[10,"ne","","",186],[10,"ne","","",186],[10,"clone","","",186],[10,"clone_from","","",186],[10,"fmt","","",187],[10,"eq","","",187],[10,"ne","","",187],[10,"ne","","",187],[10,"clone","","",187],[10,"clone_from","","",187],[10,"fmt","","",188],[10,"eq","","",188],[10,"ne","","",188],[10,"ne","","",188],[10,"clone","","",188],[10,"clone_from","","",188],[10,"id","syntax::ast","",189],[10,"span","","",189],[10,"id","","",190],[10,"span","","",190],[10,"from_mutbl","rustc::middle::mem_categorization","",186],[10,"from_borrow_kind","","",186],[10,"from_pointer_kind","","",186],[10,"inherit","","",186],[10,"is_mutable","","",186],[10,"is_immutable","","",186],[10,"to_user_str","","",186],[10,"new","","",191],[10,"cat_expr","","",191],[10,"cat_expr_autoderefd","","",191],[10,"cat_expr_unadjusted","","",191],[10,"cat_def","","",191],[10,"cat_rvalue_node","","",191],[10,"cat_rvalue","","",191],[10,"cat_field","","",191],[10,"cat_tup_field","","",191],[10,"cat_index","","Creates a cmt for an indexing operation (`[]`).",191],[10,"cat_slice_pattern","","Given a pattern P like: `[_, ..Q, _]`, where `vec_cmt` is the cmt for `P`, `slice_pat` is\nthe pattern `Q`, returns:",191],[10,"cat_imm_interior","","",191],[10,"cat_downcast","","",191],[10,"cat_pattern","","",191],[10,"cmt_to_string","","",191],[10,"guarantor","","Returns `self` after stripping away any owned pointer derefs or\ninterior content. The return value is basically the `cmt` which\ndetermines how long the value in `self` remains live.",188],[10,"freely_aliasable","","Returns `Some(_)` if this lvalue represents a freely aliasable pointer type.",188],[10,"upvar","","",188],[10,"repr","","",188],[10,"repr","","",180],[10,"repr","","",183],[10,"fmt","rustc::middle::privacy","",192],[10,"fmt","","",193],[10,"fmt","","",194],[10,"eq","","",194],[10,"ne","","",194],[10,"ne","","",194],[10,"or","","",192],[10,"visit_item","","",195],[10,"visit_foreign_item","","",195],[10,"visit_fn","","",195],[10,"visit_struct_def","","",195],[10,"visit_name","","",195],[10,"visit_ident","","",195],[10,"visit_mod","","",195],[10,"visit_view_item","","",195],[10,"visit_foreign_item","","",195],[10,"visit_item","","",195],[10,"visit_local","","",195],[10,"visit_block","","",195],[10,"visit_stmt","","",195],[10,"visit_arm","","",195],[10,"visit_pat","","",195],[10,"visit_decl","","",195],[10,"visit_expr","","",195],[10,"visit_expr_post","","",195],[10,"visit_ty","","",195],[10,"visit_generics","","",195],[10,"visit_fn","","",195],[10,"visit_ty_method","","",195],[10,"visit_trait_item","","",195],[10,"visit_trait_ref","","",195],[10,"visit_ty_param_bound","","",195],[10,"visit_poly_trait_ref","","",195],[10,"visit_struct_def","","",195],[10,"visit_struct_field","","",195],[10,"visit_variant","","",195],[10,"visit_opt_lifetime_ref","","",195],[10,"visit_lifetime_bound","","",195],[10,"visit_lifetime_ref","","",195],[10,"visit_lifetime_def","","",195],[10,"visit_explicit_self","","",195],[10,"visit_mac","","",195],[10,"visit_path","","",195],[10,"visit_path_segment","","",195],[10,"visit_path_parameters","","",195],[10,"visit_assoc_type_binding","","",195],[10,"visit_attribute","","",195],[10,"visit_item","","",196],[10,"visit_foreign_item","","",196],[10,"visit_mod","","",196],[10,"visit_name","","",196],[10,"visit_ident","","",196],[10,"visit_mod","","",196],[10,"visit_view_item","","",196],[10,"visit_foreign_item","","",196],[10,"visit_item","","",196],[10,"visit_local","","",196],[10,"visit_block","","",196],[10,"visit_stmt","","",196],[10,"visit_arm","","",196],[10,"visit_pat","","",196],[10,"visit_decl","","",196],[10,"visit_expr","","",196],[10,"visit_expr_post","","",196],[10,"visit_ty","","",196],[10,"visit_generics","","",196],[10,"visit_fn","","",196],[10,"visit_ty_method","","",196],[10,"visit_trait_item","","",196],[10,"visit_trait_ref","","",196],[10,"visit_ty_param_bound","","",196],[10,"visit_poly_trait_ref","","",196],[10,"visit_struct_def","","",196],[10,"visit_struct_field","","",196],[10,"visit_variant","","",196],[10,"visit_opt_lifetime_ref","","",196],[10,"visit_lifetime_bound","","",196],[10,"visit_lifetime_ref","","",196],[10,"visit_lifetime_def","","",196],[10,"visit_explicit_self","","",196],[10,"visit_mac","","",196],[10,"visit_path","","",196],[10,"visit_path_segment","","",196],[10,"visit_path_parameters","","",196],[10,"visit_assoc_type_binding","","",196],[10,"visit_attribute","","",196],[10,"visit_item","","",197],[10,"visit_expr","","",197],[10,"visit_view_item","","",197],[10,"visit_pat","","",197],[10,"visit_foreign_item","","",197],[10,"visit_path","","",197],[10,"visit_name","","",197],[10,"visit_ident","","",197],[10,"visit_mod","","",197],[10,"visit_view_item","","",197],[10,"visit_foreign_item","","",197],[10,"visit_item","","",197],[10,"visit_local","","",197],[10,"visit_block","","",197],[10,"visit_stmt","","",197],[10,"visit_arm","","",197],[10,"visit_pat","","",197],[10,"visit_decl","","",197],[10,"visit_expr","","",197],[10,"visit_expr_post","","",197],[10,"visit_ty","","",197],[10,"visit_generics","","",197],[10,"visit_fn","","",197],[10,"visit_ty_method","","",197],[10,"visit_trait_item","","",197],[10,"visit_trait_ref","","",197],[10,"visit_ty_param_bound","","",197],[10,"visit_poly_trait_ref","","",197],[10,"visit_struct_def","","",197],[10,"visit_struct_field","","",197],[10,"visit_variant","","",197],[10,"visit_opt_lifetime_ref","","",197],[10,"visit_lifetime_bound","","",197],[10,"visit_lifetime_ref","","",197],[10,"visit_lifetime_def","","",197],[10,"visit_explicit_self","","",197],[10,"visit_mac","","",197],[10,"visit_path","","",197],[10,"visit_path_segment","","",197],[10,"visit_path_parameters","","",197],[10,"visit_assoc_type_binding","","",197],[10,"visit_attribute","","",197],[10,"visit_item","","",198],[10,"visit_fn","","",198],[10,"visit_view_item","","",198],[10,"visit_name","","",198],[10,"visit_ident","","",198],[10,"visit_mod","","",198],[10,"visit_view_item","","",198],[10,"visit_foreign_item","","",198],[10,"visit_item","","",198],[10,"visit_local","","",198],[10,"visit_block","","",198],[10,"visit_stmt","","",198],[10,"visit_arm","","",198],[10,"visit_pat","","",198],[10,"visit_decl","","",198],[10,"visit_expr","","",198],[10,"visit_expr_post","","",198],[10,"visit_ty","","",198],[10,"visit_generics","","",198],[10,"visit_fn","","",198],[10,"visit_ty_method","","",198],[10,"visit_trait_item","","",198],[10,"visit_trait_ref","","",198],[10,"visit_ty_param_bound","","",198],[10,"visit_poly_trait_ref","","",198],[10,"visit_struct_def","","",198],[10,"visit_struct_field","","",198],[10,"visit_variant","","",198],[10,"visit_opt_lifetime_ref","","",198],[10,"visit_lifetime_bound","","",198],[10,"visit_lifetime_ref","","",198],[10,"visit_lifetime_def","","",198],[10,"visit_explicit_self","","",198],[10,"visit_mac","","",198],[10,"visit_path","","",198],[10,"visit_path_segment","","",198],[10,"visit_path_parameters","","",198],[10,"visit_assoc_type_binding","","",198],[10,"visit_attribute","","",198],[10,"visit_ty","","",199],[10,"visit_expr","","",199],[10,"visit_name","","",199],[10,"visit_ident","","",199],[10,"visit_mod","","",199],[10,"visit_view_item","","",199],[10,"visit_foreign_item","","",199],[10,"visit_item","","",199],[10,"visit_local","","",199],[10,"visit_block","","",199],[10,"visit_stmt","","",199],[10,"visit_arm","","",199],[10,"visit_pat","","",199],[10,"visit_decl","","",199],[10,"visit_expr","","",199],[10,"visit_expr_post","","",199],[10,"visit_ty","","",199],[10,"visit_generics","","",199],[10,"visit_fn","","",199],[10,"visit_ty_method","","",199],[10,"visit_trait_item","","",199],[10,"visit_trait_ref","","",199],[10,"visit_ty_param_bound","","",199],[10,"visit_poly_trait_ref","","",199],[10,"visit_struct_def","","",199],[10,"visit_struct_field","","",199],[10,"visit_variant","","",199],[10,"visit_opt_lifetime_ref","","",199],[10,"visit_lifetime_bound","","",199],[10,"visit_lifetime_ref","","",199],[10,"visit_lifetime_def","","",199],[10,"visit_explicit_self","","",199],[10,"visit_mac","","",199],[10,"visit_path","","",199],[10,"visit_path_segment","","",199],[10,"visit_path_parameters","","",199],[10,"visit_assoc_type_binding","","",199],[10,"visit_attribute","","",199],[10,"visit_item","","",200],[10,"visit_generics","","",200],[10,"visit_foreign_item","","",200],[10,"visit_fn","","",200],[10,"visit_ty","","",200],[10,"visit_variant","","",200],[10,"visit_struct_field","","",200],[10,"visit_view_item","","",200],[10,"visit_block","","",200],[10,"visit_expr","","",200],[10,"visit_name","","",200],[10,"visit_ident","","",200],[10,"visit_mod","","",200],[10,"visit_view_item","","",200],[10,"visit_foreign_item","","",200],[10,"visit_item","","",200],[10,"visit_local","","",200],[10,"visit_block","","",200],[10,"visit_stmt","","",200],[10,"visit_arm","","",200],[10,"visit_pat","","",200],[10,"visit_decl","","",200],[10,"visit_expr","","",200],[10,"visit_expr_post","","",200],[10,"visit_ty","","",200],[10,"visit_generics","","",200],[10,"visit_fn","","",200],[10,"visit_ty_method","","",200],[10,"visit_trait_item","","",200],[10,"visit_trait_ref","","",200],[10,"visit_ty_param_bound","","",200],[10,"visit_poly_trait_ref","","",200],[10,"visit_struct_def","","",200],[10,"visit_struct_field","","",200],[10,"visit_variant","","",200],[10,"visit_opt_lifetime_ref","","",200],[10,"visit_lifetime_bound","","",200],[10,"visit_lifetime_ref","","",200],[10,"visit_lifetime_def","","",200],[10,"visit_explicit_self","","",200],[10,"visit_mac","","",200],[10,"visit_path","","",200],[10,"visit_path_segment","","",200],[10,"visit_path_parameters","","",200],[10,"visit_assoc_type_binding","","",200],[10,"visit_attribute","","",200],[10,"visit_expr","rustc::middle::reachable","",201],[10,"visit_item","","",201],[10,"visit_name","","",201],[10,"visit_ident","","",201],[10,"visit_mod","","",201],[10,"visit_view_item","","",201],[10,"visit_foreign_item","","",201],[10,"visit_item","","",201],[10,"visit_local","","",201],[10,"visit_block","","",201],[10,"visit_stmt","","",201],[10,"visit_arm","","",201],[10,"visit_pat","","",201],[10,"visit_decl","","",201],[10,"visit_expr","","",201],[10,"visit_expr_post","","",201],[10,"visit_ty","","",201],[10,"visit_generics","","",201],[10,"visit_fn","","",201],[10,"visit_ty_method","","",201],[10,"visit_trait_item","","",201],[10,"visit_trait_ref","","",201],[10,"visit_ty_param_bound","","",201],[10,"visit_poly_trait_ref","","",201],[10,"visit_struct_def","","",201],[10,"visit_struct_field","","",201],[10,"visit_variant","","",201],[10,"visit_opt_lifetime_ref","","",201],[10,"visit_lifetime_bound","","",201],[10,"visit_lifetime_ref","","",201],[10,"visit_lifetime_def","","",201],[10,"visit_explicit_self","","",201],[10,"visit_mac","","",201],[10,"visit_path","","",201],[10,"visit_path_segment","","",201],[10,"visit_path_parameters","","",201],[10,"visit_assoc_type_binding","","",201],[10,"visit_attribute","","",201],[10,"fmt","rustc::middle::region","",59],[10,"decode","","",59],[10,"encode","","",59],[10,"hash","","",59],[10,"cmp","","",59],[10,"assert_receiver_is_total_eq","","",59],[10,"partial_cmp","","",59],[10,"lt","","",59],[10,"le","","",59],[10,"gt","","",59],[10,"ge","","",59],[10,"lt","","",59],[10,"le","","",59],[10,"gt","","",59],[10,"ge","","",59],[10,"eq","","",59],[10,"ne","","",59],[10,"ne","","",59],[10,"clone","","",59],[10,"clone_from","","",59],[10,"from_node_id","","Creates a scope that represents the dynamic extent associated\nwith `node_id`.",59],[10,"node_id","","Returns a node id associated with this scope.",59],[10,"map_id","","Maps this scope to a potentially new one according to the\nNodeId transformer `f_id`.",59],[10,"relate_free_regions","","",202],[10,"record_encl_scope","","",202],[10,"record_var_scope","","",202],[10,"record_rvalue_scope","","",202],[10,"mark_as_terminating_scope","","Records that a scope is a TERMINATING SCOPE. Whenever we create automatic temporaries --\ne.g. by an expression like `a().f` -- they will be freed within the innermost terminating\nscope.",202],[10,"opt_encl_scope","","Returns the narrowest scope that encloses `id`, if any.",202],[10,"encl_scope","","Returns the narrowest scope that encloses `id`, if any.",202],[10,"var_scope","","Returns the lifetime of the local variable `var_id`",202],[10,"temporary_scope","","Returns the scope when temp created by expr_id will be cleaned up",202],[10,"var_region","","Returns the lifetime of the variable `id`.",202],[10,"scopes_intersect","","",202],[10,"is_subscope_of","","Returns true if `subscope` is equal to or is lexically nested inside `superscope` and false\notherwise.",202],[10,"sub_free_region","","Determines whether two free regions have a subregion relationship\nby walking the graph encoded in `free_region_map`.  Note that\nit is possible that `sub != sup` and `sub <= sup` and `sup <= sub`\n(that is, the user can give two different names to the same lifetime).",202],[10,"is_subregion_of","","Determines whether one region is a subregion of another.  This is intended to run *after\ninference* and sadly the logic is somewhat duplicated with the code in infer.rs.",202],[10,"nearest_common_ancestor","","Finds the nearest common ancestor (if any) of two scopes.  That is, finds the smallest\nscope which is greater than or equal to both `scope_a` and `scope_b`.",202],[10,"visit_block","","",203],[10,"visit_item","","",203],[10,"visit_fn","","",203],[10,"visit_arm","","",203],[10,"visit_pat","","",203],[10,"visit_stmt","","",203],[10,"visit_expr","","",203],[10,"visit_local","","",203],[10,"visit_name","","",203],[10,"visit_ident","","",203],[10,"visit_mod","","",203],[10,"visit_view_item","","",203],[10,"visit_foreign_item","","",203],[10,"visit_item","","",203],[10,"visit_local","","",203],[10,"visit_block","","",203],[10,"visit_stmt","","",203],[10,"visit_arm","","",203],[10,"visit_pat","","",203],[10,"visit_decl","","",203],[10,"visit_expr","","",203],[10,"visit_expr_post","","",203],[10,"visit_ty","","",203],[10,"visit_generics","","",203],[10,"visit_fn","","",203],[10,"visit_ty_method","","",203],[10,"visit_trait_item","","",203],[10,"visit_trait_ref","","",203],[10,"visit_ty_param_bound","","",203],[10,"visit_poly_trait_ref","","",203],[10,"visit_struct_def","","",203],[10,"visit_struct_field","","",203],[10,"visit_variant","","",203],[10,"visit_opt_lifetime_ref","","",203],[10,"visit_lifetime_bound","","",203],[10,"visit_lifetime_ref","","",203],[10,"visit_lifetime_def","","",203],[10,"visit_explicit_self","","",203],[10,"visit_mac","","",203],[10,"visit_path","","",203],[10,"visit_path_segment","","",203],[10,"visit_path_parameters","","",203],[10,"visit_assoc_type_binding","","",203],[10,"visit_attribute","","",203],[10,"fmt","rustc::middle::resolve_lifetime","",204],[10,"decode","","",204],[10,"encode","","",204],[10,"hash","","",204],[10,"assert_receiver_is_total_eq","","",204],[10,"eq","","",204],[10,"ne","","",204],[10,"ne","","",204],[10,"clone","","",204],[10,"clone_from","","",204],[10,"visit_item","","",205],[10,"visit_fn","","",205],[10,"visit_ty","","",205],[10,"visit_ty_method","","",205],[10,"visit_block","","",205],[10,"visit_lifetime_ref","","",205],[10,"visit_generics","","",205],[10,"visit_poly_trait_ref","","",205],[10,"visit_trait_ref","","",205],[10,"visit_name","","",205],[10,"visit_ident","","",205],[10,"visit_mod","","",205],[10,"visit_view_item","","",205],[10,"visit_foreign_item","","",205],[10,"visit_item","","",205],[10,"visit_local","","",205],[10,"visit_block","","",205],[10,"visit_stmt","","",205],[10,"visit_arm","","",205],[10,"visit_pat","","",205],[10,"visit_decl","","",205],[10,"visit_expr","","",205],[10,"visit_expr_post","","",205],[10,"visit_ty","","",205],[10,"visit_generics","","",205],[10,"visit_fn","","",205],[10,"visit_ty_method","","",205],[10,"visit_trait_item","","",205],[10,"visit_trait_ref","","",205],[10,"visit_ty_param_bound","","",205],[10,"visit_poly_trait_ref","","",205],[10,"visit_struct_def","","",205],[10,"visit_struct_field","","",205],[10,"visit_variant","","",205],[10,"visit_opt_lifetime_ref","","",205],[10,"visit_lifetime_bound","","",205],[10,"visit_lifetime_ref","","",205],[10,"visit_lifetime_def","","",205],[10,"visit_explicit_self","","",205],[10,"visit_mac","","",205],[10,"visit_path","","",205],[10,"visit_path_segment","","",205],[10,"visit_path_parameters","","",205],[10,"visit_assoc_type_binding","","",205],[10,"visit_attribute","","",205],[10,"fmt","","",206],[10,"visit_item","rustc::middle::stability","",207],[10,"visit_fn","","",207],[10,"visit_trait_item","","",207],[10,"visit_variant","","",207],[10,"visit_struct_field","","",207],[10,"visit_foreign_item","","",207],[10,"visit_name","","",207],[10,"visit_ident","","",207],[10,"visit_mod","","",207],[10,"visit_view_item","","",207],[10,"visit_foreign_item","","",207],[10,"visit_item","","",207],[10,"visit_local","","",207],[10,"visit_block","","",207],[10,"visit_stmt","","",207],[10,"visit_arm","","",207],[10,"visit_pat","","",207],[10,"visit_decl","","",207],[10,"visit_expr","","",207],[10,"visit_expr_post","","",207],[10,"visit_ty","","",207],[10,"visit_generics","","",207],[10,"visit_fn","","",207],[10,"visit_ty_method","","",207],[10,"visit_trait_item","","",207],[10,"visit_trait_ref","","",207],[10,"visit_ty_param_bound","","",207],[10,"visit_poly_trait_ref","","",207],[10,"visit_struct_def","","",207],[10,"visit_struct_field","","",207],[10,"visit_variant","","",207],[10,"visit_opt_lifetime_ref","","",207],[10,"visit_lifetime_bound","","",207],[10,"visit_lifetime_ref","","",207],[10,"visit_lifetime_def","","",207],[10,"visit_explicit_self","","",207],[10,"visit_mac","","",207],[10,"visit_path","","",207],[10,"visit_path_segment","","",207],[10,"visit_path_parameters","","",207],[10,"visit_assoc_type_binding","","",207],[10,"visit_attribute","","",207],[10,"build","","Construct the stability index for a crate being compiled.",208],[10,"fmt","rustc::middle::subst","",209],[10,"hash","","",209],[10,"assert_receiver_is_total_eq","","",209],[10,"eq","","",209],[10,"ne","","",209],[10,"ne","","",209],[10,"clone","","",209],[10,"clone_from","","",209],[10,"fmt","","",210],[10,"hash","","",210],[10,"assert_receiver_is_total_eq","","",210],[10,"eq","","",210],[10,"ne","","",210],[10,"ne","","",210],[10,"clone","","",210],[10,"clone_from","","",210],[10,"new","","",209],[10,"new_type","","",209],[10,"new_trait","","",209],[10,"erased","","",209],[10,"empty","","",209],[10,"trans_empty","","",209],[10,"is_noop","","",209],[10,"type_for_def","","",209],[10,"has_regions_escaping_depth","","",209],[10,"self_ty","","",209],[10,"with_self_ty","","",209],[10,"erase_regions","","",209],[10,"regions","","Since ErasedRegions are only to be used in trans, most of the compiler can use this method\nto easily access the set of region substitutions.",209],[10,"mut_regions","","Since ErasedRegions are only to be used in trans, most of the compiler can use this method\nto easily access the set of region substitutions.",209],[10,"with_method","","",209],[10,"is_erased","","",210],[10,"fmt","","",211],[10,"decode","","",211],[10,"encode","","",211],[10,"hash","","",211],[10,"clone","","",211],[10,"clone_from","","",211],[10,"assert_receiver_is_total_eq","","",211],[10,"eq","","",211],[10,"ne","","",211],[10,"ne","","",211],[10,"cmp","","",211],[10,"partial_cmp","","",211],[10,"lt","","",211],[10,"le","","",211],[10,"gt","","",211],[10,"ge","","",211],[10,"lt","","",211],[10,"le","","",211],[10,"gt","","",211],[10,"ge","","",211],[10,"all","","",211],[10,"to_uint","","",211],[10,"from_uint","","",211],[10,"decode","","",212],[10,"encode","","",212],[10,"hash","","",212],[10,"clone","","",212],[10,"clone_from","","",212],[10,"assert_receiver_is_total_eq","","",212],[10,"eq","","",212],[10,"ne","","",212],[10,"ne","","",212],[10,"fmt","","",212],[10,"empty","","",212],[10,"params_from_type","","",212],[10,"new","","`t` is the type space.\n`s` is the self space.\n`a` is the assoc space.\n`f` is the fn space.",212],[10,"push","","Appends `value` to the vector associated with `space`.",212],[10,"pop","","",212],[10,"truncate","","",212],[10,"replace","","",212],[10,"get_self","","",212],[10,"len","","",212],[10,"is_empty_in","","",212],[10,"get_slice","","",212],[10,"get_mut_slice","","",212],[10,"opt_get","","",212],[10,"get","","",212],[10,"iter","","",212],[10,"iter_enumerated","","",212],[10,"as_slice","","",212],[10,"to_vec","","",212],[10,"all_vecs","","",212],[10,"all","","",212],[10,"any","","",212],[10,"is_empty","","",212],[10,"map","","",212],[10,"map_enumerated","","",212],[10,"map_move","","",212],[10,"split","","",212],[10,"with_vec","","",212],[10,"clone","","",213],[10,"clone_from","","",213],[10,"next","","",213],[10,"size_hint","","",213],[10,"tcx","","",214],[10,"enter_region_binder","","",214],[10,"exit_region_binder","","",214],[10,"fold_region","","",214],[10,"fold_ty","","",214],[10,"enter_region_binder","","",214],[10,"exit_region_binder","","",214],[10,"fold_ty","","",214],[10,"fold_mt","","",214],[10,"fold_trait_ref","","",214],[10,"fold_substs","","",214],[10,"fold_fn_sig","","",214],[10,"fold_output","","",214],[10,"fold_bare_fn_ty","","",214],[10,"fold_closure_ty","","",214],[10,"fold_region","","",214],[10,"fold_trait_store","","",214],[10,"fold_existential_bounds","","",214],[10,"fold_autoref","","",214],[10,"fold_item_substs","","",214],[10,"new","rustc::middle::traits::fulfill","",215],[10,"normalize_projection_type","","\"Normalize\" a projection type `<SomeType as SomeTrait>::X` by\ncreating a fresh type variable `$0` as well as a projection\npredicate `<SomeType as SomeTrait>::X == $0`. When the\ninference engine runs, it will attempt to find an impl of\n`SomeTrait` or a where clause that lets us unify `$0` with\nsomething concrete. If this fails, we'll unify `$0` with\n`projection_ty` again.",215],[10,"register_builtin_bound","","",215],[10,"register_region_obligation","","",215],[10,"register_predicate_obligation","","",215],[10,"region_obligations","","",215],[10,"select_all_or_error","","",215],[10,"select_new_obligations","","Attempts to select obligations that were registered since the call to a selection routine.\nThis is used by the type checker to eagerly attempt to resolve obligations in hopes of\ngaining type information. It'd be equally valid to use `select_where_possible` but it\nresults in `O(n^2)` performance (#18208).",215],[10,"select_where_possible","","",215],[10,"pending_obligations","","",215],[10,"repr","","",216],[10,"clone","rustc::middle::traits::project","",217],[10,"clone_from","","",217],[10,"tcx","","",218],[10,"fold_ty","","",218],[10,"enter_region_binder","","",218],[10,"exit_region_binder","","",218],[10,"fold_ty","","",218],[10,"fold_mt","","",218],[10,"fold_trait_ref","","",218],[10,"fold_substs","","",218],[10,"fold_fn_sig","","",218],[10,"fold_output","","",218],[10,"fold_bare_fn_ty","","",218],[10,"fold_closure_ty","","",218],[10,"fold_region","","",218],[10,"fold_trait_store","","",218],[10,"fold_existential_bounds","","",218],[10,"fold_autoref","","",218],[10,"fold_item_substs","","",218],[10,"repr","","",219],[10,"repr","","",220],[10,"clone","rustc::middle::traits::select","",221],[10,"clone_from","","",221],[10,"fmt","","",222],[10,"clone","","",223],[10,"clone_from","","",223],[10,"fmt","","",223],[10,"assert_receiver_is_total_eq","","",223],[10,"eq","","",223],[10,"ne","","",223],[10,"ne","","",223],[10,"fmt","","",224],[10,"new","","",225],[10,"intercrate","","",225],[10,"infcx","","",225],[10,"param_env","","",225],[10,"tcx","","",225],[10,"select","","Evaluates whether the obligation can be satisfied. Returns an indication of whether the\nobligation can be satisfied and, if so, by what means. Never affects surrounding typing\nenvironment.",225],[10,"evaluate_obligation","","Evaluates whether the obligation `obligation` can be satisfied (by any means).",225],[10,"evaluate_impl","","Evaluates whether the impl with id `impl_def_id` could be applied to the self type\n`obligation_self_ty`. This can be used either for trait or inherent impls.",225],[10,"repr","","",223],[10,"new","","",221],[10,"next","core::option","",53],[10,"size_hint","","",53],[10,"repr","rustc::middle::traits::select","",226],[10,"may_apply","","",227],[10,"filter_to_traits","rustc::middle::traits::util","",228],[10,"next","","",228],[10,"size_hint","","",228],[10,"next","","",229],[10,"size_hint","","",229],[10,"fmt","rustc::middle::traits","",230],[10,"repr","","",231],[10,"repr","","",232],[10,"repr","","",230],[10,"repr","","",233],[10,"repr","","",234],[10,"repr","","",235],[10,"repr","","",236],[10,"fmt","","",236],[10,"repr","rustc::middle::traits::project","",217],[10,"fmt","","",217],[10,"clone","rustc::middle::traits","",231],[10,"clone_from","","",231],[10,"clone","","",237],[10,"clone_from","","",237],[10,"clone","","",238],[10,"clone_from","","",238],[10,"clone","","",239],[10,"clone_from","","",239],[10,"fmt","","",234],[10,"clone","","",234],[10,"clone_from","","",234],[10,"clone","","",236],[10,"clone_from","","",236],[10,"clone","","",232],[10,"clone_from","","",232],[10,"fmt","","",232],[10,"clone","","",230],[10,"clone_from","","",230],[10,"clone","","",233],[10,"clone_from","","",233],[10,"fmt","","",233],[10,"new","","",231],[10,"misc","","",231],[10,"with","","",231],[10,"new","","",237],[10,"misc","","",237],[10,"dummy","","",237],[10,"iter_nested","","",232],[10,"map_nested","","",232],[10,"map_move_nested","","",232],[10,"iter_nested","","",230],[10,"map_nested","","",230],[10,"map_move_nested","","",230],[10,"iter_nested","","",233],[10,"map_nested","","",233],[10,"map_move_nested","","",233],[10,"is_overflow","","",235],[10,"hash","rustc::middle::ty","",240],[10,"assert_receiver_is_total_eq","","",240],[10,"eq","","",240],[10,"ne","","",240],[10,"ne","","",240],[10,"fmt","","",241],[10,"clone","","",241],[10,"clone_from","","",241],[10,"id","","",241],[10,"clone","","",242],[10,"clone_from","","",242],[10,"def_id","","",242],[10,"name","","",242],[10,"container","","",242],[10,"as_opt_method","","",242],[10,"clone","","",243],[10,"clone_from","","",243],[10,"def_id","","",243],[10,"fmt","","",244],[10,"clone","","",244],[10,"clone_from","","",244],[10,"new","","",244],[10,"container_id","","",244],[10,"clone","","",245],[10,"clone_from","","",245],[10,"fmt","","",246],[10,"hash","","",246],[10,"assert_receiver_is_total_eq","","",246],[10,"eq","","",246],[10,"ne","","",246],[10,"ne","","",246],[10,"clone","","",246],[10,"clone_from","","",246],[10,"fmt","","",61],[10,"decode","","",61],[10,"encode","","",61],[10,"hash","","",61],[10,"assert_receiver_is_total_eq","","",61],[10,"eq","","",61],[10,"ne","","",61],[10,"ne","","",61],[10,"clone","","",61],[10,"clone_from","","",61],[10,"fmt","","",247],[10,"clone","","",247],[10,"clone_from","","",247],[10,"hash","","",248],[10,"assert_receiver_is_total_eq","","",248],[10,"eq","","",248],[10,"ne","","",248],[10,"ne","","",248],[10,"encode","","",249],[10,"decode","","",249],[10,"eq","","",249],[10,"ne","","",249],[10,"ne","","",249],[10,"clone","","",249],[10,"clone_from","","",249],[10,"fmt","","",250],[10,"encode","","",250],[10,"decode","","",250],[10,"eq","","",250],[10,"ne","","",250],[10,"ne","","",250],[10,"clone","","",250],[10,"clone_from","","",250],[10,"fmt","","",251],[10,"clone","","",251],[10,"clone_from","","",251],[10,"fmt","","",252],[10,"eq","","",252],[10,"ne","","",252],[10,"ne","","",252],[10,"clone","","",252],[10,"clone_from","","",252],[10,"fmt","","",253],[10,"clone","","",253],[10,"clone_from","","",253],[10,"fmt","","",254],[10,"eq","","",254],[10,"ne","","",254],[10,"ne","","",254],[10,"clone","","",254],[10,"clone_from","","",254],[10,"fmt","","",255],[10,"partial_cmp","","",255],[10,"lt","","",255],[10,"le","","",255],[10,"gt","","",255],[10,"ge","","",255],[10,"lt","","",255],[10,"le","","",255],[10,"gt","","",255],[10,"ge","","",255],[10,"eq","","",255],[10,"ne","","",255],[10,"ne","","",255],[10,"decode","","",255],[10,"encode","","",255],[10,"clone","","",255],[10,"clone_from","","",255],[10,"fmt","","",65],[10,"clone","","",65],[10,"clone_from","","",65],[10,"fmt","","",256],[10,"clone","","",256],[10,"clone_from","","",256],[10,"fmt","","",257],[10,"clone","","",257],[10,"clone_from","","",257],[10,"clone","","",258],[10,"clone_from","","",258],[10,"fmt","","",259],[10,"hash","","",259],[10,"assert_receiver_is_total_eq","","",259],[10,"eq","","",259],[10,"ne","","",259],[10,"ne","","",259],[10,"clone","","",259],[10,"clone_from","","",259],[10,"decode","","",260],[10,"encode","","",260],[10,"fmt","","",260],[10,"hash","","",260],[10,"assert_receiver_is_total_eq","","",260],[10,"eq","","",260],[10,"ne","","",260],[10,"ne","","",260],[10,"clone","","",260],[10,"clone_from","","",260],[10,"expr","","",259],[10,"autoobject","","",259],[10,"autoderef","","",259],[10,"clone","","",261],[10,"clone_from","","",261],[10,"new","","",262],[10,"hash","","",263],[10,"cmp","","",263],[10,"partial_cmp","","",263],[10,"lt","","",263],[10,"le","","",263],[10,"gt","","",263],[10,"ge","","",263],[10,"lt","","",263],[10,"le","","",263],[10,"gt","","",263],[10,"ge","","",263],[10,"clone","","",263],[10,"clone_from","","",263],[10,"assert_receiver_is_total_eq","","",263],[10,"eq","","",263],[10,"ne","","",263],[10,"ne","","",263],[10,"empty","","Returns an empty set of flags.",263],[10,"all","","Returns the set containing all flags.",263],[10,"bits","","Returns the raw value of the flags currently stored.",263],[10,"from_bits","","Convert from underlying bit representation, unless that\nrepresentation contains bits that do not correspond to a flag.",263],[10,"from_bits_truncate","","Convert from underlying bit representation, dropping any bits\nthat do not correspond to flags.",263],[10,"is_empty","","Returns `true` if no flags are currently stored.",263],[10,"is_all","","Returns `true` if all flags are currently set.",263],[10,"intersects","","Returns `true` if there are flags common to both `self` and `other`.",263],[10,"contains","","Returns `true` all of the flags in `other` are contained within `self`.",263],[10,"insert","","Inserts the specified flags in-place.",263],[10,"remove","","Removes the specified flags in-place.",263],[10,"toggle","","Toggles the specified flags in-place.",263],[10,"bitor","","Returns the union of the two sets of flags.",263],[10,"bitxor","","Returns the left flags, but with all the right flags toggled.",263],[10,"bitand","","Returns the intersection between the two sets of flags.",263],[10,"sub","","Returns the set difference of the two sets of flags.",263],[10,"not","","Returns the complement of this set of flags.",263],[10,"print_debug_stats","","",264],[10,"fmt","","",265],[10,"fmt","","",263],[10,"eq","","",265],[10,"ne","","",265],[10,"assert_receiver_is_total_eq","","",265],[10,"hash","","",265],[10,"eq","","",266],[10,"ne","","",266],[10,"assert_receiver_is_total_eq","","",266],[10,"hash","","",266],[10,"borrow_from","","",267],[10,"fmt","","",268],[10,"hash","","",268],[10,"assert_receiver_is_total_eq","","",268],[10,"eq","","",268],[10,"ne","","",268],[10,"ne","","",268],[10,"clone","","",268],[10,"clone_from","","",268],[10,"fmt","","",269],[10,"hash","","",269],[10,"assert_receiver_is_total_eq","","",269],[10,"eq","","",269],[10,"ne","","",269],[10,"ne","","",269],[10,"clone","","",269],[10,"clone_from","","",269],[10,"hash","","",270],[10,"assert_receiver_is_total_eq","","",270],[10,"eq","","",270],[10,"ne","","",270],[10,"ne","","",270],[10,"clone","","",270],[10,"clone_from","","",270],[10,"unwrap","","",270],[10,"hash","","",125],[10,"assert_receiver_is_total_eq","","",125],[10,"eq","","",125],[10,"ne","","",125],[10,"ne","","",125],[10,"clone","","",125],[10,"clone_from","","",125],[10,"fmt","","",271],[10,"hash","","",271],[10,"assert_receiver_is_total_eq","","",271],[10,"eq","","",271],[10,"ne","","",271],[10,"ne","","",271],[10,"clone","","",271],[10,"clone_from","","",271],[10,"fmt","","",272],[10,"decode","","",272],[10,"encode","","",272],[10,"hash","","",272],[10,"assert_receiver_is_total_eq","","",272],[10,"eq","","",272],[10,"ne","","",272],[10,"ne","","",272],[10,"clone","","",272],[10,"clone_from","","",272],[10,"fmt","","",57],[10,"decode","","",57],[10,"encode","","",57],[10,"hash","","",57],[10,"assert_receiver_is_total_eq","","",57],[10,"eq","","",57],[10,"ne","","",57],[10,"ne","","",57],[10,"clone","","",57],[10,"clone_from","","",57],[10,"fmt","","",273],[10,"hash","","",273],[10,"assert_receiver_is_total_eq","","",273],[10,"eq","","",273],[10,"ne","","",273],[10,"ne","","",273],[10,"clone","","",273],[10,"clone_from","","",273],[10,"decode","","",274],[10,"encode","","",274],[10,"fmt","","",274],[10,"hash","","",274],[10,"assert_receiver_is_total_eq","","",274],[10,"eq","","",274],[10,"ne","","",274],[10,"ne","","",274],[10,"clone","","",274],[10,"clone_from","","",274],[10,"fmt","","",64],[10,"decode","","",64],[10,"encode","","",64],[10,"clone","","",64],[10,"clone_from","","",64],[10,"eq","","",64],[10,"ne","","",64],[10,"ne","","",64],[10,"is_bound","","",57],[10,"escapes_depth","","",57],[10,"fmt","","",58],[10,"decode","","",58],[10,"encode","","",58],[10,"hash","","",58],[10,"cmp","","",58],[10,"assert_receiver_is_total_eq","","",58],[10,"partial_cmp","","",58],[10,"lt","","",58],[10,"le","","",58],[10,"gt","","",58],[10,"ge","","",58],[10,"lt","","",58],[10,"le","","",58],[10,"gt","","",58],[10,"ge","","",58],[10,"eq","","",58],[10,"ne","","",58],[10,"ne","","",58],[10,"clone","","",58],[10,"clone_from","","",58],[10,"fmt","","",60],[10,"decode","","",60],[10,"encode","","",60],[10,"hash","","",60],[10,"cmp","","",60],[10,"assert_receiver_is_total_eq","","",60],[10,"partial_cmp","","",60],[10,"lt","","",60],[10,"le","","",60],[10,"gt","","",60],[10,"ge","","",60],[10,"lt","","",60],[10,"le","","",60],[10,"gt","","",60],[10,"ge","","",60],[10,"eq","","",60],[10,"ne","","",60],[10,"ne","","",60],[10,"clone","","",60],[10,"clone_from","","",60],[10,"fmt","","",267],[10,"hash","","",267],[10,"assert_receiver_is_total_eq","","",267],[10,"eq","","",267],[10,"ne","","",267],[10,"ne","","",267],[10,"clone","","",267],[10,"clone_from","","",267],[10,"fmt","","",275],[10,"hash","","",275],[10,"assert_receiver_is_total_eq","","",275],[10,"eq","","",275],[10,"ne","","",275],[10,"ne","","",275],[10,"clone","","",275],[10,"clone_from","","",275],[10,"principal_def_id","","",275],[10,"principal_trait_ref_with_self_ty","","Object types don't have a self-type specified. Therefore, when\nwe convert the principal trait-ref into a normal trait-ref,\nyou must give *some* self-type. A common choice is `mk_err()`\nor some skolemized type.",275],[10,"projection_bounds_with_self_ty","","",275],[10,"fmt","","",123],[10,"hash","","",123],[10,"assert_receiver_is_total_eq","","",123],[10,"eq","","",123],[10,"ne","","",123],[10,"ne","","",123],[10,"clone","","",123],[10,"clone_from","","",123],[10,"self_ty","","",130],[10,"def_id","","",130],[10,"substs","","",130],[10,"input_types","","",130],[10,"to_poly_trait_predicate","","",130],[10,"fmt","","",130],[10,"hash","","",130],[10,"assert_receiver_is_total_eq","","",130],[10,"eq","","",130],[10,"ne","","",130],[10,"ne","","",130],[10,"clone","","",130],[10,"clone_from","","",130],[10,"eq","","",158],[10,"ne","","",158],[10,"ne","","",158],[10,"clone","","",158],[10,"clone_from","","",158],[10,"fmt","","",276],[10,"clone","","",276],[10,"clone_from","","",276],[10,"fmt","","",277],[10,"clone","","",277],[10,"clone_from","","",277],[10,"fmt","","",278],[10,"clone","","",278],[10,"clone_from","","",278],[10,"fmt","","",279],[10,"clone","","",279],[10,"clone_from","","",279],[10,"hash","","",279],[10,"assert_receiver_is_total_eq","","",279],[10,"eq","","",279],[10,"ne","","",279],[10,"ne","","",279],[10,"fmt","","",280],[10,"clone","","",280],[10,"clone_from","","",280],[10,"hash","","",280],[10,"assert_receiver_is_total_eq","","",280],[10,"eq","","",280],[10,"ne","","",280],[10,"ne","","",280],[10,"fmt","","",281],[10,"hash","","",281],[10,"decode","","",281],[10,"assert_receiver_is_total_eq","","",281],[10,"eq","","",281],[10,"ne","","",281],[10,"ne","","",281],[10,"encode","","",281],[10,"clone","","",281],[10,"clone_from","","",281],[10,"to_uint","","",281],[10,"from_uint","","",281],[10,"hash","","",282],[10,"assert_receiver_is_total_eq","","",282],[10,"eq","","",282],[10,"ne","","",282],[10,"ne","","",282],[10,"clone","","",282],[10,"clone_from","","",282],[10,"hash","","",157],[10,"assert_receiver_is_total_eq","","",157],[10,"eq","","",157],[10,"ne","","",157],[10,"ne","","",157],[10,"clone","","",157],[10,"clone_from","","",157],[10,"hash","","",159],[10,"assert_receiver_is_total_eq","","",159],[10,"eq","","",159],[10,"ne","","",159],[10,"ne","","",159],[10,"clone","","",159],[10,"clone_from","","",159],[10,"hash","","",283],[10,"decode","","",283],[10,"encode","","",283],[10,"assert_receiver_is_total_eq","","",283],[10,"eq","","",283],[10,"ne","","",283],[10,"ne","","",283],[10,"clone","","",283],[10,"clone_from","","",283],[10,"hash","","",284],[10,"assert_receiver_is_total_eq","","",284],[10,"eq","","",284],[10,"ne","","",284],[10,"ne","","",284],[10,"clone","","",284],[10,"clone_from","","",284],[10,"fmt","","",285],[10,"hash","","",285],[10,"assert_receiver_is_total_eq","","",285],[10,"decode","","",285],[10,"encode","","",285],[10,"clone","","",285],[10,"clone_from","","",285],[10,"eq","","",285],[10,"ne","","",285],[10,"ne","","",285],[10,"fmt","","",282],[10,"fmt","","",157],[10,"fmt","","",159],[10,"fmt","","",283],[10,"fmt","","",125],[10,"fmt","","",284],[10,"fmt","","",158],[10,"fmt","","",286],[10,"clone","","",286],[10,"clone_from","","",286],[10,"fmt","","",287],[10,"clone","","",287],[10,"clone_from","","",287],[10,"decode","","",287],[10,"encode","","",287],[10,"to_early_bound_region","","",287],[10,"fmt","","",288],[10,"clone","","",288],[10,"clone_from","","",288],[10,"empty","","",288],[10,"has_type_params","","",288],[10,"has_region_params","","",288],[10,"to_bounds","","",288],[10,"fmt","","",289],[10,"hash","","",289],[10,"assert_receiver_is_total_eq","","",289],[10,"eq","","",289],[10,"ne","","",289],[10,"ne","","",289],[10,"clone","","",289],[10,"clone_from","","",289],[10,"fmt","","",290],[10,"hash","","",290],[10,"assert_receiver_is_total_eq","","",290],[10,"eq","","",290],[10,"ne","","",290],[10,"ne","","",290],[10,"clone","","",290],[10,"clone_from","","",290],[10,"def_id","","",290],[10,"input_types","","",290],[10,"self_ty","","",290],[10,"def_id","","",130],[10,"fmt","","",291],[10,"hash","","",291],[10,"assert_receiver_is_total_eq","","",291],[10,"eq","","",291],[10,"ne","","",291],[10,"ne","","",291],[10,"clone","","",291],[10,"clone_from","","",291],[10,"fmt","","",292],[10,"hash","","",292],[10,"assert_receiver_is_total_eq","","",292],[10,"eq","","",292],[10,"ne","","",292],[10,"ne","","",292],[10,"clone","","",292],[10,"clone_from","","",292],[10,"fmt","","",124],[10,"hash","","",124],[10,"assert_receiver_is_total_eq","","",124],[10,"eq","","",124],[10,"ne","","",124],[10,"ne","","",124],[10,"clone","","",124],[10,"clone_from","","",124],[10,"sort_key","","",130],[10,"fmt","","",293],[10,"hash","","",293],[10,"assert_receiver_is_total_eq","","",293],[10,"eq","","",293],[10,"ne","","",293],[10,"ne","","",293],[10,"clone","","",293],[10,"clone_from","","",293],[10,"sort_key","","",293],[10,"to_poly_trait_ref","alloc::rc","",122],[10,"to_poly_trait_ref","rustc::middle::ty","",130],[10,"to_poly_trait_ref","","",130],[10,"as_predicate","alloc::rc","",122],[10,"as_predicate","rustc::middle::ty","",130],[10,"as_predicate","","",130],[10,"as_predicate","","",130],[10,"as_predicate","","",130],[10,"as_predicate","","",130],[10,"has_escaping_regions","","",289],[10,"to_opt_poly_trait_ref","","",289],[10,"fmt","","",294],[10,"clone","","",294],[10,"clone_from","","",294],[10,"empty","","",294],[10,"has_escaping_regions","","",294],[10,"is_empty","","",294],[10,"new","","",123],[10,"self_ty","","",123],[10,"input_types","","",123],[10,"clone","","",295],[10,"clone_from","","",295],[10,"for_item","","",295],[10,"fmt","","",296],[10,"clone","","",296],[10,"clone_from","","",296],[10,"clone","","",297],[10,"clone_from","","",297],[10,"clone","","",298],[10,"clone_from","","",298],[10,"fmt","","",299],[10,"assert_receiver_is_total_eq","","",299],[10,"eq","","",299],[10,"ne","","",299],[10,"ne","","",299],[10,"clone","","",299],[10,"clone_from","","",299],[10,"trait_did","","",299],[10,"mk_substs","","",264],[10,"mk_bare_fn","","",264],[10,"mk_region","","",264],[10,"new","","",271],[10,"for_self","","",271],[10,"for_def","","",271],[10,"to_ty","","",271],[10,"is_self","","",271],[10,"empty","","",297],[10,"is_noop","","",297],[10,"empty","","",279],[10,"clone","","",300],[10,"clone_from","","",300],[10,"when","","",300],[10,"intersects","","",300],[10,"owns_managed","","",300],[10,"owns_owned","","",300],[10,"is_sized","","",300],[10,"interior_param","","",300],[10,"interior_unsafe","","",300],[10,"interior_unsized","","",300],[10,"needs_drop","","",300],[10,"owned_pointer","","Includes only those bits that still apply when indirected through a `Box` pointer",300],[10,"reference","","Includes only those bits that still apply when indirected through a reference (`&`)",300],[10,"managed_pointer","","Includes only those bits that still apply when indirected through a managed pointer (`@`)",300],[10,"unsafe_pointer","","Includes only those bits that still apply when indirected through an unsafe pointer (`*`)",300],[10,"union","","",300],[10,"has_dtor","","",300],[10,"bitor","","",300],[10,"bitand","","",300],[10,"sub","","",300],[10,"fmt","","",300],[10,"fmt","","",301],[10,"eq","","",301],[10,"ne","","",301],[10,"ne","","",301],[10,"assert_receiver_is_total_eq","","",301],[10,"cmp","","",301],[10,"partial_cmp","","",301],[10,"lt","","",301],[10,"le","","",301],[10,"gt","","",301],[10,"ge","","",301],[10,"lt","","",301],[10,"le","","",301],[10,"gt","","",301],[10,"ge","","",301],[10,"repr","","",278],[10,"assert_receiver_is_total_eq","","",302],[10,"eq","","",302],[10,"ne","","",302],[10,"ne","","",302],[10,"partial_cmp","","",302],[10,"lt","","",302],[10,"le","","",302],[10,"gt","","",302],[10,"ge","","",302],[10,"cmp","","",302],[10,"clone","","",303],[10,"clone_from","","",303],[10,"from_ast_variant","","Creates a new VariantInfo from the corresponding ast representation.",303],[10,"is_present","","",304],[10,"has_drop_flag","","",304],[10,"to_string","","",250],[10,"from_mutbl","","",274],[10,"to_mutbl_lossy","","Returns a mutability `m` such that an `&m T` pointer could be used to obtain this borrow\nkind. Because borrow kinds are richer than mutabilities, we sometimes have to pick a\nmutability that is stronger than necessary so that it at least *would permit* the borrow in\nquestion.",274],[10,"to_user_str","","",274],[10,"tcx","","",264],[10,"node_ty","","",264],[10,"expr_ty_adjusted","","",264],[10,"node_method_ty","","",264],[10,"node_method_origin","","",264],[10,"adjustments","","",264],[10,"is_method_call","","",264],[10,"temporary_scope","","",264],[10,"upvar_borrow","","",264],[10,"capture_mode","","",264],[10,"unboxed_closures","","",264],[10,"fmt","","",305],[10,"eq","","",305],[10,"ne","","",305],[10,"ne","","",305],[10,"assert_receiver_is_total_eq","","",305],[10,"clone","","",305],[10,"clone_from","","",305],[10,"decode","","",63],[10,"encode","","",63],[10,"is_identity","","",251],[10,"is_identity","","",253],[10,"new","","",272],[10,"shifted","","",272],[10,"repr","","",251],[10,"repr","","",252],[10,"repr","","",253],[10,"repr","","",254],[10,"repr","","",275],[10,"repr","","",289],[10,"repr","","",261],[10,"has_regions_escaping_depth","rustc::middle::subst","",212],[10,"has_escaping_regions","","",212],[10,"has_regions_escaping_depth","rustc::middle::ty","",296],[10,"has_escaping_regions","","",296],[10,"has_regions_escaping_depth","","",57],[10,"has_escaping_regions","","",57],[10,"has_regions_escaping_depth","","",288],[10,"has_escaping_regions","","",288],[10,"has_regions_escaping_depth","","",289],[10,"has_escaping_regions","","",289],[10,"has_regions_escaping_depth","","",123],[10,"has_escaping_regions","","",123],[10,"has_regions_escaping_depth","rustc::middle::subst","",210],[10,"has_escaping_regions","","",210],[10,"has_regions_escaping_depth","rustc::middle::ty","",130],[10,"has_escaping_regions","","",130],[10,"has_regions_escaping_depth","","",291],[10,"has_escaping_regions","","",291],[10,"has_regions_escaping_depth","","",290],[10,"has_escaping_regions","","",290],[10,"has_regions_escaping_depth","","",292],[10,"has_escaping_regions","","",292],[10,"has_regions_escaping_depth","","",124],[10,"has_escaping_regions","","",124],[10,"has_regions_escaping_depth","","",293],[10,"has_escaping_regions","","",293],[10,"repr","","",124],[10,"has_projection_types","rustc::middle::subst","",212],[10,"has_projection_types","rustc::middle::ty","",294],[10,"has_projection_types","","",289],[10,"has_projection_types","","",290],[10,"has_projection_types","","",291],[10,"has_projection_types","","",57],[10,"has_projection_types","","",292],[10,"has_projection_types","","",124],[10,"has_projection_types","","",293],[10,"has_projection_types","","",123],[10,"has_projection_types","rustc::middle::subst","",209],[10,"has_projection_types","core::option","",53],[10,"has_projection_types","alloc::rc","",122],[10,"has_projection_types","alloc::boxed","",306],[10,"has_projection_types","rustc::middle::ty","",130],[10,"has_projection_types","","",270],[10,"has_projection_types","","",125],[10,"has_projection_types","","",268],[10,"references_error","","",130],[10,"references_error","alloc::rc","",122],[10,"references_error","rustc::middle::ty","",290],[10,"references_error","","",124],[10,"references_error","","",123],[10,"references_error","","",289],[10,"references_error","","",292],[10,"references_error","","",291],[10,"references_error","","",57],[10,"fold_with","core::option","",53],[10,"fold_with","alloc::rc","",122],[10,"fold_with","alloc::boxed","",306],[10,"fold_with","collections::vec","",307],[10,"fold_with","rustc::middle::ty","",130],[10,"fold_with","syntax::owned_slice","",308],[10,"fold_with","rustc::middle::subst","",212],[10,"fold_with","rustc::middle::ty","",61],[10,"fold_with","","",268],[10,"fold_with","","",269],[10,"fold_with","","",246],[10,"fold_with","","",270],[10,"fold_with","","",125],[10,"fold_with","","",123],[10,"fold_with","","",57],[10,"fold_with","rustc::middle::subst","",209],[10,"fold_with","rustc::middle::ty","",297],[10,"fold_with","","",254],[10,"fold_with","","",65],[10,"fold_with","","",261],[10,"fold_with","collections::enum_set","",309],[10,"fold_with","rustc::middle::ty","",280],[10,"fold_with","","",279],[10,"fold_with","","",286],[10,"fold_with","","",287],[10,"fold_with","","",288],[10,"fold_with","","",289],[10,"fold_with","","",124],[10,"fold_with","","",293],[10,"fold_with","","",294],[10,"fold_with","","",252],[10,"fold_with","rustc::middle::traits","",231],[10,"fold_with","","",230],[10,"fold_with","","",233],[10,"fold_with","","",232],[10,"fold_with","rustc::middle::ty","",291],[10,"fold_with","","",290],[10,"fold_with","","",292],[10,"tcx","rustc::middle::ty_fold","",310],[10,"fold_ty","","",310],[10,"enter_region_binder","","",310],[10,"exit_region_binder","","",310],[10,"fold_ty","","",310],[10,"fold_mt","","",310],[10,"fold_trait_ref","","",310],[10,"fold_substs","","",310],[10,"fold_fn_sig","","",310],[10,"fold_output","","",310],[10,"fold_bare_fn_ty","","",310],[10,"fold_closure_ty","","",310],[10,"fold_region","","",310],[10,"fold_trait_store","","",310],[10,"fold_existential_bounds","","",310],[10,"fold_autoref","","",310],[10,"fold_item_substs","","",310],[10,"new","","",311],[10,"tcx","","",311],[10,"enter_region_binder","","",311],[10,"exit_region_binder","","",311],[10,"fold_region","","",311],[10,"enter_region_binder","","",311],[10,"exit_region_binder","","",311],[10,"fold_ty","","",311],[10,"fold_mt","","",311],[10,"fold_trait_ref","","",311],[10,"fold_substs","","",311],[10,"fold_fn_sig","","",311],[10,"fold_output","","",311],[10,"fold_bare_fn_ty","","",311],[10,"fold_closure_ty","","",311],[10,"fold_region","","",311],[10,"fold_trait_store","","",311],[10,"fold_existential_bounds","","",311],[10,"fold_autoref","","",311],[10,"fold_item_substs","","",311],[10,"tcx","","",312],[10,"fold_region","","",312],[10,"enter_region_binder","","",312],[10,"exit_region_binder","","",312],[10,"fold_ty","","",312],[10,"fold_mt","","",312],[10,"fold_trait_ref","","",312],[10,"fold_substs","","",312],[10,"fold_fn_sig","","",312],[10,"fold_output","","",312],[10,"fold_bare_fn_ty","","",312],[10,"fold_closure_ty","","",312],[10,"fold_region","","",312],[10,"fold_trait_store","","",312],[10,"fold_existential_bounds","","",312],[10,"fold_autoref","","",312],[10,"fold_item_substs","","",312],[10,"visit_foreign_item","rustc::middle::weak_lang_items","",313],[10,"visit_name","","",313],[10,"visit_ident","","",313],[10,"visit_mod","","",313],[10,"visit_view_item","","",313],[10,"visit_foreign_item","","",313],[10,"visit_item","","",313],[10,"visit_local","","",313],[10,"visit_block","","",313],[10,"visit_stmt","","",313],[10,"visit_arm","","",313],[10,"visit_pat","","",313],[10,"visit_decl","","",313],[10,"visit_expr","","",313],[10,"visit_expr_post","","",313],[10,"visit_ty","","",313],[10,"visit_generics","","",313],[10,"visit_fn","","",313],[10,"visit_ty_method","","",313],[10,"visit_trait_item","","",313],[10,"visit_trait_ref","","",313],[10,"visit_ty_param_bound","","",313],[10,"visit_poly_trait_ref","","",313],[10,"visit_struct_def","","",313],[10,"visit_struct_field","","",313],[10,"visit_variant","","",313],[10,"visit_opt_lifetime_ref","","",313],[10,"visit_lifetime_bound","","",313],[10,"visit_lifetime_ref","","",313],[10,"visit_lifetime_def","","",313],[10,"visit_explicit_self","","",313],[10,"visit_mac","","",313],[10,"visit_path","","",313],[10,"visit_path_segment","","",313],[10,"visit_path_parameters","","",313],[10,"visit_assoc_type_binding","","",313],[10,"visit_attribute","","",313],[10,"eq","rustc::metadata::common","",314],[10,"ne","","",314],[10,"ne","","",314],[10,"from_uint","","",314],[10,"fmt","","",315],[10,"clone","","",315],[10,"clone_from","","",315],[10,"fmt","rustc::metadata::tydecode","",316],[10,"clone","rustc::metadata::encoder","",317],[10,"clone_from","","",317],[10,"visit_expr","","",318],[10,"visit_item","","",318],[10,"visit_foreign_item","","",318],[10,"visit_name","","",318],[10,"visit_ident","","",318],[10,"visit_mod","","",318],[10,"visit_view_item","","",318],[10,"visit_foreign_item","","",318],[10,"visit_item","","",318],[10,"visit_local","","",318],[10,"visit_block","","",318],[10,"visit_stmt","","",318],[10,"visit_arm","","",318],[10,"visit_pat","","",318],[10,"visit_decl","","",318],[10,"visit_expr","","",318],[10,"visit_expr_post","","",318],[10,"visit_ty","","",318],[10,"visit_generics","","",318],[10,"visit_fn","","",318],[10,"visit_ty_method","","",318],[10,"visit_trait_item","","",318],[10,"visit_trait_ref","","",318],[10,"visit_ty_param_bound","","",318],[10,"visit_poly_trait_ref","","",318],[10,"visit_struct_def","","",318],[10,"visit_struct_field","","",318],[10,"visit_variant","","",318],[10,"visit_opt_lifetime_ref","","",318],[10,"visit_lifetime_bound","","",318],[10,"visit_lifetime_ref","","",318],[10,"visit_lifetime_def","","",318],[10,"visit_explicit_self","","",318],[10,"visit_mac","","",318],[10,"visit_path","","",318],[10,"visit_path_segment","","",318],[10,"visit_path_parameters","","",318],[10,"visit_assoc_type_binding","","",318],[10,"visit_attribute","","",318],[10,"visit_item","","",319],[10,"visit_name","","",319],[10,"visit_ident","","",319],[10,"visit_mod","","",319],[10,"visit_view_item","","",319],[10,"visit_foreign_item","","",319],[10,"visit_item","","",319],[10,"visit_local","","",319],[10,"visit_block","","",319],[10,"visit_stmt","","",319],[10,"visit_arm","","",319],[10,"visit_pat","","",319],[10,"visit_decl","","",319],[10,"visit_expr","","",319],[10,"visit_expr_post","","",319],[10,"visit_ty","","",319],[10,"visit_generics","","",319],[10,"visit_fn","","",319],[10,"visit_ty_method","","",319],[10,"visit_trait_item","","",319],[10,"visit_trait_ref","","",319],[10,"visit_ty_param_bound","","",319],[10,"visit_poly_trait_ref","","",319],[10,"visit_struct_def","","",319],[10,"visit_struct_field","","",319],[10,"visit_variant","","",319],[10,"visit_opt_lifetime_ref","","",319],[10,"visit_lifetime_bound","","",319],[10,"visit_lifetime_ref","","",319],[10,"visit_lifetime_def","","",319],[10,"visit_explicit_self","","",319],[10,"visit_mac","","",319],[10,"visit_path","","",319],[10,"visit_path_segment","","",319],[10,"visit_path_parameters","","",319],[10,"visit_assoc_type_binding","","",319],[10,"visit_attribute","","",319],[10,"eq","rustc::metadata::decoder","",320],[10,"ne","","",320],[10,"ne","","",320],[10,"fmt","","",321],[10,"clone","","",321],[10,"clone_from","","",321],[10,"clone","","",322],[10,"clone_from","","",322],[10,"visit_view_item","rustc::metadata::creader","",323],[10,"visit_item","","",323],[10,"visit_name","","",323],[10,"visit_ident","","",323],[10,"visit_mod","","",323],[10,"visit_view_item","","",323],[10,"visit_foreign_item","","",323],[10,"visit_item","","",323],[10,"visit_local","","",323],[10,"visit_block","","",323],[10,"visit_stmt","","",323],[10,"visit_arm","","",323],[10,"visit_pat","","",323],[10,"visit_decl","","",323],[10,"visit_expr","","",323],[10,"visit_expr_post","","",323],[10,"visit_ty","","",323],[10,"visit_generics","","",323],[10,"visit_fn","","",323],[10,"visit_ty_method","","",323],[10,"visit_trait_item","","",323],[10,"visit_trait_ref","","",323],[10,"visit_ty_param_bound","","",323],[10,"visit_poly_trait_ref","","",323],[10,"visit_struct_def","","",323],[10,"visit_struct_field","","",323],[10,"visit_variant","","",323],[10,"visit_opt_lifetime_ref","","",323],[10,"visit_lifetime_bound","","",323],[10,"visit_lifetime_ref","","",323],[10,"visit_lifetime_def","","",323],[10,"visit_explicit_self","","",323],[10,"visit_mac","","",323],[10,"visit_path","","",323],[10,"visit_path_segment","","",323],[10,"visit_path_parameters","","",323],[10,"visit_assoc_type_binding","","",323],[10,"visit_attribute","","",323],[10,"new","","",324],[10,"read_plugin_metadata","","",324],[10,"clone","rustc::metadata::cstore","",325],[10,"clone_from","","",325],[10,"eq","","",325],[10,"ne","","",325],[10,"ne","","",325],[10,"fmt","","",325],[10,"from_i64","","",326],[10,"from_u64","","",326],[10,"from_int","","",326],[10,"from_i8","","",326],[10,"from_i16","","",326],[10,"from_i32","","",326],[10,"from_uint","","",326],[10,"from_u8","","",326],[10,"from_u16","","",326],[10,"from_u32","","",326],[10,"from_f32","","",326],[10,"from_f64","","",326],[10,"eq","","",326],[10,"ne","","",326],[10,"ne","","",326],[10,"clone","","",326],[10,"clone_from","","",326],[10,"clone","","",327],[10,"clone_from","","",327],[10,"eq","","",327],[10,"ne","","",327],[10,"ne","","",327],[10,"new","","",328],[10,"next_crate_num","","",328],[10,"get_crate_data","","",328],[10,"get_crate_hash","","",328],[10,"set_crate_data","","",328],[10,"iter_crate_data","","",328],[10,"iter_crate_data_origins","","Like `iter_crate_data`, but passes source paths (if available) as well.",328],[10,"add_used_crate_source","","",328],[10,"get_used_crate_source","","",328],[10,"reset","","",328],[10,"get_used_crates","","",328],[10,"add_used_library","","",328],[10,"get_used_libraries","","",328],[10,"add_used_link_args","","",328],[10,"get_used_link_args","","",328],[10,"add_extern_mod_stmt_cnum","","",328],[10,"find_extern_mod_stmt_cnum","","",328],[10,"data","","",329],[10,"name","","",329],[10,"hash","","",329],[10,"as_slice","","",330],[10,"maybe_load_library_crate","rustc::metadata::loader","",331],[10,"load_library_crate","","",331],[10,"report_load_errs","","",331],[10,"as_slice","","",332],[10,"for_each_lib_search_path","rustc::metadata::filesearch","",333],[10,"get_lib_path","","",333],[10,"search","","",333],[10,"new","","",333],[10,"get_dylib_search_paths","","",333],[10,"get_tools_search_paths","","",333],[10,"eq","rustc::session::config","",334],[10,"ne","","",334],[10,"ne","","",334],[10,"clone","","",334],[10,"clone_from","","",334],[10,"eq","","",335],[10,"ne","","",335],[10,"ne","","",335],[10,"clone","","",335],[10,"clone_from","","",335],[10,"assert_receiver_is_total_eq","","",336],[10,"cmp","","",336],[10,"partial_cmp","","",336],[10,"lt","","",336],[10,"le","","",336],[10,"gt","","",336],[10,"ge","","",336],[10,"lt","","",336],[10,"le","","",336],[10,"gt","","",336],[10,"ge","","",336],[10,"eq","","",336],[10,"ne","","",336],[10,"ne","","",336],[10,"clone","","",336],[10,"clone_from","","",336],[10,"clone","","",337],[10,"clone_from","","",337],[10,"assert_receiver_is_total_eq","","",338],[10,"eq","","",338],[10,"ne","","",338],[10,"ne","","",338],[10,"clone","","",338],[10,"clone_from","","",338],[10,"filestem","","",339],[10,"clone","","",340],[10,"clone_from","","",340],[10,"path","","",340],[10,"temp_path","","",340],[10,"with_extension","","",340],[10,"filestem","","",340],[10,"eq","","",341],[10,"ne","","",341],[10,"ne","","",341],[10,"hash","","",342],[10,"assert_receiver_is_total_eq","","",342],[10,"cmp","","",342],[10,"clone","","",342],[10,"clone_from","","",342],[10,"partial_cmp","","",342],[10,"lt","","",342],[10,"le","","",342],[10,"gt","","",342],[10,"ge","","",342],[10,"lt","","",342],[10,"le","","",342],[10,"gt","","",342],[10,"ge","","",342],[10,"eq","","",342],[10,"ne","","",342],[10,"ne","","",342],[10,"clone","","",343],[10,"clone_from","","",343],[10,"is_empty","","",343],[10,"clone","","",344],[10,"clone_from","","",344],[10,"fmt","","",345],[10,"assert_receiver_is_total_eq","","",345],[10,"eq","","",345],[10,"ne","","",345],[10,"ne","","",345],[10,"clone","","",345],[10,"clone_from","","",345],[10,"assert_receiver_is_total_eq","","",346],[10,"eq","","",346],[10,"ne","","",346],[10,"ne","","",346],[10,"clone","","",346],[10,"clone_from","","",346],[10,"is_stable","","",346],[10,"fmt","","",342],[10,"clone","rustc::session::search_paths","",347],[10,"clone_from","","",347],[10,"clone","","",348],[10,"clone_from","","",348],[10,"eq","","",348],[10,"ne","","",348],[10,"ne","","",348],[10,"assert_receiver_is_total_eq","","",348],[10,"new","","",347],[10,"add_path","","",347],[10,"iter","","",347],[10,"next","","",349],[10,"size_hint","","",349],[10,"span_fatal","rustc::session","",350],[10,"fatal","","",350],[10,"span_err","","",350],[10,"span_err_with_code","","",350],[10,"err","","",350],[10,"err_count","","",350],[10,"has_errors","","",350],[10,"abort_if_errors","","",350],[10,"span_warn","","",350],[10,"span_warn_with_code","","",350],[10,"warn","","",350],[10,"opt_span_warn","","",350],[10,"span_note","","",350],[10,"span_end_note","","",350],[10,"span_help","","",350],[10,"fileline_note","","",350],[10,"note","","",350],[10,"help","","",350],[10,"opt_span_bug","","",350],[10,"span_bug","","",350],[10,"bug","","",350],[10,"span_unimpl","","",350],[10,"unimpl","","",350],[10,"add_lint","","",350],[10,"next_node_id","","",350],[10,"reserve_node_ids","","",350],[10,"diagnostic","","",350],[10,"debugging_opt","","",350],[10,"codemap","","",350],[10,"impossible_case","","",350],[10,"verbose","","",350],[10,"time_passes","","",350],[10,"count_llvm_insns","","",350],[10,"count_type_sizes","","",350],[10,"time_llvm_passes","","",350],[10,"trans_stats","","",350],[10,"meta_stats","","",350],[10,"asm_comments","","",350],[10,"no_verify","","",350],[10,"borrowck_stats","","",350],[10,"print_llvm_passes","","",350],[10,"lto","","",350],[10,"no_landing_pads","","",350],[10,"show_span","","",350],[10,"print_enum_sizes","","",350],[10,"sysroot","","",350],[10,"target_filesearch","","",350],[10,"host_filesearch","","",350],[10,"register_syntax_extension","rustc::plugin::registry","Register a syntax extension of any kind.",351],[10,"register_macro","","Register a macro of the usual kind.",351],[10,"register_lint_pass","","Register a compiler lint pass.",351],[10,"register_lint_group","","Register a lint group.",351],[10,"visit_view_item","rustc::plugin::load","",352],[10,"visit_mac","","",352],[10,"visit_name","","",352],[10,"visit_ident","","",352],[10,"visit_mod","","",352],[10,"visit_view_item","","",352],[10,"visit_foreign_item","","",352],[10,"visit_item","","",352],[10,"visit_local","","",352],[10,"visit_block","","",352],[10,"visit_stmt","","",352],[10,"visit_arm","","",352],[10,"visit_pat","","",352],[10,"visit_decl","","",352],[10,"visit_expr","","",352],[10,"visit_expr_post","","",352],[10,"visit_ty","","",352],[10,"visit_generics","","",352],[10,"visit_fn","","",352],[10,"visit_ty_method","","",352],[10,"visit_trait_item","","",352],[10,"visit_trait_ref","","",352],[10,"visit_ty_param_bound","","",352],[10,"visit_poly_trait_ref","","",352],[10,"visit_struct_def","","",352],[10,"visit_struct_field","","",352],[10,"visit_variant","","",352],[10,"visit_opt_lifetime_ref","","",352],[10,"visit_lifetime_bound","","",352],[10,"visit_lifetime_ref","","",352],[10,"visit_lifetime_def","","",352],[10,"visit_explicit_self","","",352],[10,"visit_mac","","",352],[10,"visit_path","","",352],[10,"visit_path_segment","","",352],[10,"visit_path_parameters","","",352],[10,"visit_assoc_type_binding","","",352],[10,"visit_attribute","","",352],[10,"visit_item","rustc::plugin::build","",353],[10,"visit_name","","",353],[10,"visit_ident","","",353],[10,"visit_mod","","",353],[10,"visit_view_item","","",353],[10,"visit_foreign_item","","",353],[10,"visit_item","","",353],[10,"visit_local","","",353],[10,"visit_block","","",353],[10,"visit_stmt","","",353],[10,"visit_arm","","",353],[10,"visit_pat","","",353],[10,"visit_decl","","",353],[10,"visit_expr","","",353],[10,"visit_expr_post","","",353],[10,"visit_ty","","",353],[10,"visit_generics","","",353],[10,"visit_fn","","",353],[10,"visit_ty_method","","",353],[10,"visit_trait_item","","",353],[10,"visit_trait_ref","","",353],[10,"visit_ty_param_bound","","",353],[10,"visit_poly_trait_ref","","",353],[10,"visit_struct_def","","",353],[10,"visit_struct_field","","",353],[10,"visit_variant","","",353],[10,"visit_opt_lifetime_ref","","",353],[10,"visit_lifetime_bound","","",353],[10,"visit_lifetime_ref","","",353],[10,"visit_lifetime_def","","",353],[10,"visit_explicit_self","","",353],[10,"visit_mac","","",353],[10,"visit_path","","",353],[10,"visit_path_segment","","",353],[10,"visit_path_parameters","","",353],[10,"visit_assoc_type_binding","","",353],[10,"visit_attribute","","",353],[10,"name_lower","rustc::lint","Get the lint's name, with ASCII letters converted to lowercase.",354],[10,"clone","","",355],[10,"clone_from","","",355],[10,"eq","","",355],[10,"ne","","",355],[10,"assert_receiver_is_total_eq","","",355],[10,"hash","","",355],[10,"of","","Get the `LintId` for a `Lint`.",355],[10,"as_str","","Get the name of the lint.",355],[10,"cmp","","",356],[10,"assert_receiver_is_total_eq","","",356],[10,"partial_cmp","","",356],[10,"lt","","",356],[10,"le","","",356],[10,"gt","","",356],[10,"ge","","",356],[10,"lt","","",356],[10,"le","","",356],[10,"gt","","",356],[10,"ge","","",356],[10,"eq","","",356],[10,"ne","","",356],[10,"ne","","",356],[10,"clone","","",356],[10,"clone_from","","",356],[10,"as_str","","Convert a level to a lower-case string.",356],[10,"from_str","","Convert a lower-case string to a level.",356],[10,"assert_receiver_is_total_eq","","",357],[10,"eq","","",357],[10,"ne","","",357],[10,"ne","","",357],[10,"clone","","",357],[10,"clone_from","","",357],[10,"get_lints","rustc::lint::builtin","",358],[10,"check_expr","","",358],[10,"check_crate","","",358],[10,"check_ident","","",358],[10,"check_mod","","",358],[10,"check_view_item","","",358],[10,"check_foreign_item","","",358],[10,"check_item","","",358],[10,"check_local","","",358],[10,"check_block","","",358],[10,"check_stmt","","",358],[10,"check_arm","","",358],[10,"check_pat","","",358],[10,"check_decl","","",358],[10,"check_expr","","",358],[10,"check_expr_post","","",358],[10,"check_ty","","",358],[10,"check_generics","","",358],[10,"check_fn","","",358],[10,"check_ty_method","","",358],[10,"check_trait_method","","",358],[10,"check_struct_def","","",358],[10,"check_struct_def_post","","",358],[10,"check_struct_field","","",358],[10,"check_variant","","",358],[10,"check_variant_post","","",358],[10,"check_opt_lifetime_ref","","",358],[10,"check_lifetime_ref","","",358],[10,"check_lifetime_def","","",358],[10,"check_explicit_self","","",358],[10,"check_mac","","",358],[10,"check_path","","",358],[10,"check_attribute","","",358],[10,"enter_lint_attrs","","",358],[10,"exit_lint_attrs","","",358],[10,"get_lints","","",359],[10,"check_expr","","",359],[10,"check_crate","","",359],[10,"check_ident","","",359],[10,"check_mod","","",359],[10,"check_view_item","","",359],[10,"check_foreign_item","","",359],[10,"check_item","","",359],[10,"check_local","","",359],[10,"check_block","","",359],[10,"check_stmt","","",359],[10,"check_arm","","",359],[10,"check_pat","","",359],[10,"check_decl","","",359],[10,"check_expr","","",359],[10,"check_expr_post","","",359],[10,"check_ty","","",359],[10,"check_generics","","",359],[10,"check_fn","","",359],[10,"check_ty_method","","",359],[10,"check_trait_method","","",359],[10,"check_struct_def","","",359],[10,"check_struct_def_post","","",359],[10,"check_struct_field","","",359],[10,"check_variant","","",359],[10,"check_variant_post","","",359],[10,"check_opt_lifetime_ref","","",359],[10,"check_lifetime_ref","","",359],[10,"check_lifetime_def","","",359],[10,"check_explicit_self","","",359],[10,"check_mac","","",359],[10,"check_path","","",359],[10,"check_attribute","","",359],[10,"enter_lint_attrs","","",359],[10,"exit_lint_attrs","","",359],[10,"new","","",360],[10,"get_lints","","",360],[10,"check_expr","","",360],[10,"check_crate","","",360],[10,"check_ident","","",360],[10,"check_mod","","",360],[10,"check_view_item","","",360],[10,"check_foreign_item","","",360],[10,"check_item","","",360],[10,"check_local","","",360],[10,"check_block","","",360],[10,"check_stmt","","",360],[10,"check_arm","","",360],[10,"check_pat","","",360],[10,"check_decl","","",360],[10,"check_expr","","",360],[10,"check_expr_post","","",360],[10,"check_ty","","",360],[10,"check_generics","","",360],[10,"check_fn","","",360],[10,"check_ty_method","","",360],[10,"check_trait_method","","",360],[10,"check_struct_def","","",360],[10,"check_struct_def_post","","",360],[10,"check_struct_field","","",360],[10,"check_variant","","",360],[10,"check_variant_post","","",360],[10,"check_opt_lifetime_ref","","",360],[10,"check_lifetime_ref","","",360],[10,"check_lifetime_def","","",360],[10,"check_explicit_self","","",360],[10,"check_mac","","",360],[10,"check_path","","",360],[10,"check_attribute","","",360],[10,"enter_lint_attrs","","",360],[10,"exit_lint_attrs","","",360],[10,"visit_ty","","",361],[10,"visit_name","","",361],[10,"visit_ident","","",361],[10,"visit_mod","","",361],[10,"visit_view_item","","",361],[10,"visit_foreign_item","","",361],[10,"visit_item","","",361],[10,"visit_local","","",361],[10,"visit_block","","",361],[10,"visit_stmt","","",361],[10,"visit_arm","","",361],[10,"visit_pat","","",361],[10,"visit_decl","","",361],[10,"visit_expr","","",361],[10,"visit_expr_post","","",361],[10,"visit_ty","","",361],[10,"visit_generics","","",361],[10,"visit_fn","","",361],[10,"visit_ty_method","","",361],[10,"visit_trait_item","","",361],[10,"visit_trait_ref","","",361],[10,"visit_ty_param_bound","","",361],[10,"visit_poly_trait_ref","","",361],[10,"visit_struct_def","","",361],[10,"visit_struct_field","","",361],[10,"visit_variant","","",361],[10,"visit_opt_lifetime_ref","","",361],[10,"visit_lifetime_bound","","",361],[10,"visit_lifetime_ref","","",361],[10,"visit_lifetime_def","","",361],[10,"visit_explicit_self","","",361],[10,"visit_mac","","",361],[10,"visit_path","","",361],[10,"visit_path_segment","","",361],[10,"visit_path_parameters","","",361],[10,"visit_assoc_type_binding","","",361],[10,"visit_attribute","","",361],[10,"get_lints","","",362],[10,"check_item","","",362],[10,"check_crate","","",362],[10,"check_ident","","",362],[10,"check_mod","","",362],[10,"check_view_item","","",362],[10,"check_foreign_item","","",362],[10,"check_item","","",362],[10,"check_local","","",362],[10,"check_block","","",362],[10,"check_stmt","","",362],[10,"check_arm","","",362],[10,"check_pat","","",362],[10,"check_decl","","",362],[10,"check_expr","","",362],[10,"check_expr_post","","",362],[10,"check_ty","","",362],[10,"check_generics","","",362],[10,"check_fn","","",362],[10,"check_ty_method","","",362],[10,"check_trait_method","","",362],[10,"check_struct_def","","",362],[10,"check_struct_def_post","","",362],[10,"check_struct_field","","",362],[10,"check_variant","","",362],[10,"check_variant_post","","",362],[10,"check_opt_lifetime_ref","","",362],[10,"check_lifetime_ref","","",362],[10,"check_lifetime_def","","",362],[10,"check_explicit_self","","",362],[10,"check_mac","","",362],[10,"check_path","","",362],[10,"check_attribute","","",362],[10,"enter_lint_attrs","","",362],[10,"exit_lint_attrs","","",362],[10,"get_lints","","",363],[10,"check_item","","",363],[10,"check_expr","","",363],[10,"check_crate","","",363],[10,"check_ident","","",363],[10,"check_mod","","",363],[10,"check_view_item","","",363],[10,"check_foreign_item","","",363],[10,"check_item","","",363],[10,"check_local","","",363],[10,"check_block","","",363],[10,"check_stmt","","",363],[10,"check_arm","","",363],[10,"check_pat","","",363],[10,"check_decl","","",363],[10,"check_expr","","",363],[10,"check_expr_post","","",363],[10,"check_ty","","",363],[10,"check_generics","","",363],[10,"check_fn","","",363],[10,"check_ty_method","","",363],[10,"check_trait_method","","",363],[10,"check_struct_def","","",363],[10,"check_struct_def_post","","",363],[10,"check_struct_field","","",363],[10,"check_variant","","",363],[10,"check_variant_post","","",363],[10,"check_opt_lifetime_ref","","",363],[10,"check_lifetime_ref","","",363],[10,"check_lifetime_def","","",363],[10,"check_explicit_self","","",363],[10,"check_mac","","",363],[10,"check_path","","",363],[10,"check_attribute","","",363],[10,"enter_lint_attrs","","",363],[10,"exit_lint_attrs","","",363],[10,"visit_ty","","",364],[10,"visit_expr","","",364],[10,"visit_block","","",364],[10,"visit_name","","",364],[10,"visit_ident","","",364],[10,"visit_mod","","",364],[10,"visit_view_item","","",364],[10,"visit_foreign_item","","",364],[10,"visit_item","","",364],[10,"visit_local","","",364],[10,"visit_block","","",364],[10,"visit_stmt","","",364],[10,"visit_arm","","",364],[10,"visit_pat","","",364],[10,"visit_decl","","",364],[10,"visit_expr","","",364],[10,"visit_expr_post","","",364],[10,"visit_ty","","",364],[10,"visit_generics","","",364],[10,"visit_fn","","",364],[10,"visit_ty_method","","",364],[10,"visit_trait_item","","",364],[10,"visit_trait_ref","","",364],[10,"visit_ty_param_bound","","",364],[10,"visit_poly_trait_ref","","",364],[10,"visit_struct_def","","",364],[10,"visit_struct_field","","",364],[10,"visit_variant","","",364],[10,"visit_opt_lifetime_ref","","",364],[10,"visit_lifetime_bound","","",364],[10,"visit_lifetime_ref","","",364],[10,"visit_lifetime_def","","",364],[10,"visit_explicit_self","","",364],[10,"visit_mac","","",364],[10,"visit_path","","",364],[10,"visit_path_segment","","",364],[10,"visit_path_parameters","","",364],[10,"visit_assoc_type_binding","","",364],[10,"visit_attribute","","",364],[10,"new","","",365],[10,"get_lints","","",365],[10,"check_item","","",365],[10,"check_crate","","",365],[10,"check_ident","","",365],[10,"check_mod","","",365],[10,"check_view_item","","",365],[10,"check_foreign_item","","",365],[10,"check_item","","",365],[10,"check_local","","",365],[10,"check_block","","",365],[10,"check_stmt","","",365],[10,"check_arm","","",365],[10,"check_pat","","",365],[10,"check_decl","","",365],[10,"check_expr","","",365],[10,"check_expr_post","","",365],[10,"check_ty","","",365],[10,"check_generics","","",365],[10,"check_fn","","",365],[10,"check_ty_method","","",365],[10,"check_trait_method","","",365],[10,"check_struct_def","","",365],[10,"check_struct_def_post","","",365],[10,"check_struct_field","","",365],[10,"check_variant","","",365],[10,"check_variant_post","","",365],[10,"check_opt_lifetime_ref","","",365],[10,"check_lifetime_ref","","",365],[10,"check_lifetime_def","","",365],[10,"check_explicit_self","","",365],[10,"check_mac","","",365],[10,"check_path","","",365],[10,"check_attribute","","",365],[10,"enter_lint_attrs","","",365],[10,"exit_lint_attrs","","",365],[10,"get_lints","","",366],[10,"check_attribute","","",366],[10,"check_crate","","",366],[10,"check_ident","","",366],[10,"check_mod","","",366],[10,"check_view_item","","",366],[10,"check_foreign_item","","",366],[10,"check_item","","",366],[10,"check_local","","",366],[10,"check_block","","",366],[10,"check_stmt","","",366],[10,"check_arm","","",366],[10,"check_pat","","",366],[10,"check_decl","","",366],[10,"check_expr","","",366],[10,"check_expr_post","","",366],[10,"check_ty","","",366],[10,"check_generics","","",366],[10,"check_fn","","",366],[10,"check_ty_method","","",366],[10,"check_trait_method","","",366],[10,"check_struct_def","","",366],[10,"check_struct_def_post","","",366],[10,"check_struct_field","","",366],[10,"check_variant","","",366],[10,"check_variant_post","","",366],[10,"check_opt_lifetime_ref","","",366],[10,"check_lifetime_ref","","",366],[10,"check_lifetime_def","","",366],[10,"check_explicit_self","","",366],[10,"check_mac","","",366],[10,"check_path","","",366],[10,"check_attribute","","",366],[10,"enter_lint_attrs","","",366],[10,"exit_lint_attrs","","",366],[10,"get_lints","","",367],[10,"check_stmt","","",367],[10,"check_crate","","",367],[10,"check_ident","","",367],[10,"check_mod","","",367],[10,"check_view_item","","",367],[10,"check_foreign_item","","",367],[10,"check_item","","",367],[10,"check_local","","",367],[10,"check_block","","",367],[10,"check_stmt","","",367],[10,"check_arm","","",367],[10,"check_pat","","",367],[10,"check_decl","","",367],[10,"check_expr","","",367],[10,"check_expr_post","","",367],[10,"check_ty","","",367],[10,"check_generics","","",367],[10,"check_fn","","",367],[10,"check_ty_method","","",367],[10,"check_trait_method","","",367],[10,"check_struct_def","","",367],[10,"check_struct_def_post","","",367],[10,"check_struct_field","","",367],[10,"check_variant","","",367],[10,"check_variant_post","","",367],[10,"check_opt_lifetime_ref","","",367],[10,"check_lifetime_ref","","",367],[10,"check_lifetime_def","","",367],[10,"check_explicit_self","","",367],[10,"check_mac","","",367],[10,"check_path","","",367],[10,"check_attribute","","",367],[10,"enter_lint_attrs","","",367],[10,"exit_lint_attrs","","",367],[10,"get_lints","","",368],[10,"check_stmt","","",368],[10,"check_crate","","",368],[10,"check_ident","","",368],[10,"check_mod","","",368],[10,"check_view_item","","",368],[10,"check_foreign_item","","",368],[10,"check_item","","",368],[10,"check_local","","",368],[10,"check_block","","",368],[10,"check_stmt","","",368],[10,"check_arm","","",368],[10,"check_pat","","",368],[10,"check_decl","","",368],[10,"check_expr","","",368],[10,"check_expr_post","","",368],[10,"check_ty","","",368],[10,"check_generics","","",368],[10,"check_fn","","",368],[10,"check_ty_method","","",368],[10,"check_trait_method","","",368],[10,"check_struct_def","","",368],[10,"check_struct_def_post","","",368],[10,"check_struct_field","","",368],[10,"check_variant","","",368],[10,"check_variant_post","","",368],[10,"check_opt_lifetime_ref","","",368],[10,"check_lifetime_ref","","",368],[10,"check_lifetime_def","","",368],[10,"check_explicit_self","","",368],[10,"check_mac","","",368],[10,"check_path","","",368],[10,"check_attribute","","",368],[10,"enter_lint_attrs","","",368],[10,"exit_lint_attrs","","",368],[10,"get_lints","","",369],[10,"check_item","","",369],[10,"check_generics","","",369],[10,"check_crate","","",369],[10,"check_ident","","",369],[10,"check_mod","","",369],[10,"check_view_item","","",369],[10,"check_foreign_item","","",369],[10,"check_item","","",369],[10,"check_local","","",369],[10,"check_block","","",369],[10,"check_stmt","","",369],[10,"check_arm","","",369],[10,"check_pat","","",369],[10,"check_decl","","",369],[10,"check_expr","","",369],[10,"check_expr_post","","",369],[10,"check_ty","","",369],[10,"check_generics","","",369],[10,"check_fn","","",369],[10,"check_ty_method","","",369],[10,"check_trait_method","","",369],[10,"check_struct_def","","",369],[10,"check_struct_def_post","","",369],[10,"check_struct_field","","",369],[10,"check_variant","","",369],[10,"check_variant_post","","",369],[10,"check_opt_lifetime_ref","","",369],[10,"check_lifetime_ref","","",369],[10,"check_lifetime_def","","",369],[10,"check_explicit_self","","",369],[10,"check_mac","","",369],[10,"check_path","","",369],[10,"check_attribute","","",369],[10,"enter_lint_attrs","","",369],[10,"exit_lint_attrs","","",369],[10,"eq","","",370],[10,"ne","","",370],[10,"ne","","",370],[10,"get_lints","","",371],[10,"check_fn","","",371],[10,"check_item","","",371],[10,"check_ty_method","","",371],[10,"check_lifetime_def","","",371],[10,"check_pat","","",371],[10,"check_struct_def","","",371],[10,"check_crate","","",371],[10,"check_ident","","",371],[10,"check_mod","","",371],[10,"check_view_item","","",371],[10,"check_foreign_item","","",371],[10,"check_item","","",371],[10,"check_local","","",371],[10,"check_block","","",371],[10,"check_stmt","","",371],[10,"check_arm","","",371],[10,"check_pat","","",371],[10,"check_decl","","",371],[10,"check_expr","","",371],[10,"check_expr_post","","",371],[10,"check_ty","","",371],[10,"check_generics","","",371],[10,"check_fn","","",371],[10,"check_ty_method","","",371],[10,"check_trait_method","","",371],[10,"check_struct_def","","",371],[10,"check_struct_def_post","","",371],[10,"check_struct_field","","",371],[10,"check_variant","","",371],[10,"check_variant_post","","",371],[10,"check_opt_lifetime_ref","","",371],[10,"check_lifetime_ref","","",371],[10,"check_lifetime_def","","",371],[10,"check_explicit_self","","",371],[10,"check_mac","","",371],[10,"check_path","","",371],[10,"check_attribute","","",371],[10,"enter_lint_attrs","","",371],[10,"exit_lint_attrs","","",371],[10,"get_lints","","",372],[10,"check_item","","",372],[10,"check_pat","","",372],[10,"check_crate","","",372],[10,"check_ident","","",372],[10,"check_mod","","",372],[10,"check_view_item","","",372],[10,"check_foreign_item","","",372],[10,"check_item","","",372],[10,"check_local","","",372],[10,"check_block","","",372],[10,"check_stmt","","",372],[10,"check_arm","","",372],[10,"check_pat","","",372],[10,"check_decl","","",372],[10,"check_expr","","",372],[10,"check_expr_post","","",372],[10,"check_ty","","",372],[10,"check_generics","","",372],[10,"check_fn","","",372],[10,"check_ty_method","","",372],[10,"check_trait_method","","",372],[10,"check_struct_def","","",372],[10,"check_struct_def_post","","",372],[10,"check_struct_field","","",372],[10,"check_variant","","",372],[10,"check_variant_post","","",372],[10,"check_opt_lifetime_ref","","",372],[10,"check_lifetime_ref","","",372],[10,"check_lifetime_def","","",372],[10,"check_explicit_self","","",372],[10,"check_mac","","",372],[10,"check_path","","",372],[10,"check_attribute","","",372],[10,"enter_lint_attrs","","",372],[10,"exit_lint_attrs","","",372],[10,"get_lints","","",373],[10,"check_expr","","",373],[10,"check_stmt","","",373],[10,"check_crate","","",373],[10,"check_ident","","",373],[10,"check_mod","","",373],[10,"check_view_item","","",373],[10,"check_foreign_item","","",373],[10,"check_item","","",373],[10,"check_local","","",373],[10,"check_block","","",373],[10,"check_stmt","","",373],[10,"check_arm","","",373],[10,"check_pat","","",373],[10,"check_decl","","",373],[10,"check_expr","","",373],[10,"check_expr_post","","",373],[10,"check_ty","","",373],[10,"check_generics","","",373],[10,"check_fn","","",373],[10,"check_ty_method","","",373],[10,"check_trait_method","","",373],[10,"check_struct_def","","",373],[10,"check_struct_def_post","","",373],[10,"check_struct_field","","",373],[10,"check_variant","","",373],[10,"check_variant_post","","",373],[10,"check_opt_lifetime_ref","","",373],[10,"check_lifetime_ref","","",373],[10,"check_lifetime_def","","",373],[10,"check_explicit_self","","",373],[10,"check_mac","","",373],[10,"check_path","","",373],[10,"check_attribute","","",373],[10,"enter_lint_attrs","","",373],[10,"exit_lint_attrs","","",373],[10,"get_lints","","",374],[10,"check_view_item","","",374],[10,"check_crate","","",374],[10,"check_ident","","",374],[10,"check_mod","","",374],[10,"check_view_item","","",374],[10,"check_foreign_item","","",374],[10,"check_item","","",374],[10,"check_local","","",374],[10,"check_block","","",374],[10,"check_stmt","","",374],[10,"check_arm","","",374],[10,"check_pat","","",374],[10,"check_decl","","",374],[10,"check_expr","","",374],[10,"check_expr_post","","",374],[10,"check_ty","","",374],[10,"check_generics","","",374],[10,"check_fn","","",374],[10,"check_ty_method","","",374],[10,"check_trait_method","","",374],[10,"check_struct_def","","",374],[10,"check_struct_def_post","","",374],[10,"check_struct_field","","",374],[10,"check_variant","","",374],[10,"check_variant_post","","",374],[10,"check_opt_lifetime_ref","","",374],[10,"check_lifetime_ref","","",374],[10,"check_lifetime_def","","",374],[10,"check_explicit_self","","",374],[10,"check_mac","","",374],[10,"check_path","","",374],[10,"check_attribute","","",374],[10,"enter_lint_attrs","","",374],[10,"exit_lint_attrs","","",374],[10,"get_lints","","",375],[10,"check_pat","","",375],[10,"check_crate","","",375],[10,"check_ident","","",375],[10,"check_mod","","",375],[10,"check_view_item","","",375],[10,"check_foreign_item","","",375],[10,"check_item","","",375],[10,"check_local","","",375],[10,"check_block","","",375],[10,"check_stmt","","",375],[10,"check_arm","","",375],[10,"check_pat","","",375],[10,"check_decl","","",375],[10,"check_expr","","",375],[10,"check_expr_post","","",375],[10,"check_ty","","",375],[10,"check_generics","","",375],[10,"check_fn","","",375],[10,"check_ty_method","","",375],[10,"check_trait_method","","",375],[10,"check_struct_def","","",375],[10,"check_struct_def_post","","",375],[10,"check_struct_field","","",375],[10,"check_variant","","",375],[10,"check_variant_post","","",375],[10,"check_opt_lifetime_ref","","",375],[10,"check_lifetime_ref","","",375],[10,"check_lifetime_def","","",375],[10,"check_explicit_self","","",375],[10,"check_mac","","",375],[10,"check_path","","",375],[10,"check_attribute","","",375],[10,"enter_lint_attrs","","",375],[10,"exit_lint_attrs","","",375],[10,"get_lints","","",376],[10,"check_expr","","",376],[10,"check_crate","","",376],[10,"check_ident","","",376],[10,"check_mod","","",376],[10,"check_view_item","","",376],[10,"check_foreign_item","","",376],[10,"check_item","","",376],[10,"check_local","","",376],[10,"check_block","","",376],[10,"check_stmt","","",376],[10,"check_arm","","",376],[10,"check_pat","","",376],[10,"check_decl","","",376],[10,"check_expr","","",376],[10,"check_expr_post","","",376],[10,"check_ty","","",376],[10,"check_generics","","",376],[10,"check_fn","","",376],[10,"check_ty_method","","",376],[10,"check_trait_method","","",376],[10,"check_struct_def","","",376],[10,"check_struct_def_post","","",376],[10,"check_struct_field","","",376],[10,"check_variant","","",376],[10,"check_variant_post","","",376],[10,"check_opt_lifetime_ref","","",376],[10,"check_lifetime_ref","","",376],[10,"check_lifetime_def","","",376],[10,"check_explicit_self","","",376],[10,"check_mac","","",376],[10,"check_path","","",376],[10,"check_attribute","","",376],[10,"enter_lint_attrs","","",376],[10,"exit_lint_attrs","","",376],[10,"get_lints","","",377],[10,"check_expr","","",377],[10,"check_crate","","",377],[10,"check_ident","","",377],[10,"check_mod","","",377],[10,"check_view_item","","",377],[10,"check_foreign_item","","",377],[10,"check_item","","",377],[10,"check_local","","",377],[10,"check_block","","",377],[10,"check_stmt","","",377],[10,"check_arm","","",377],[10,"check_pat","","",377],[10,"check_decl","","",377],[10,"check_expr","","",377],[10,"check_expr_post","","",377],[10,"check_ty","","",377],[10,"check_generics","","",377],[10,"check_fn","","",377],[10,"check_ty_method","","",377],[10,"check_trait_method","","",377],[10,"check_struct_def","","",377],[10,"check_struct_def_post","","",377],[10,"check_struct_field","","",377],[10,"check_variant","","",377],[10,"check_variant_post","","",377],[10,"check_opt_lifetime_ref","","",377],[10,"check_lifetime_ref","","",377],[10,"check_lifetime_def","","",377],[10,"check_explicit_self","","",377],[10,"check_mac","","",377],[10,"check_path","","",377],[10,"check_attribute","","",377],[10,"enter_lint_attrs","","",377],[10,"exit_lint_attrs","","",377],[10,"get_lints","","",378],[10,"check_expr","","",378],[10,"check_stmt","","",378],[10,"check_fn","","",378],[10,"check_crate","","",378],[10,"check_ident","","",378],[10,"check_mod","","",378],[10,"check_view_item","","",378],[10,"check_foreign_item","","",378],[10,"check_item","","",378],[10,"check_local","","",378],[10,"check_block","","",378],[10,"check_stmt","","",378],[10,"check_arm","","",378],[10,"check_pat","","",378],[10,"check_decl","","",378],[10,"check_expr","","",378],[10,"check_expr_post","","",378],[10,"check_ty","","",378],[10,"check_generics","","",378],[10,"check_fn","","",378],[10,"check_ty_method","","",378],[10,"check_trait_method","","",378],[10,"check_struct_def","","",378],[10,"check_struct_def_post","","",378],[10,"check_struct_field","","",378],[10,"check_variant","","",378],[10,"check_variant_post","","",378],[10,"check_opt_lifetime_ref","","",378],[10,"check_lifetime_ref","","",378],[10,"check_lifetime_def","","",378],[10,"check_explicit_self","","",378],[10,"check_mac","","",378],[10,"check_path","","",378],[10,"check_attribute","","",378],[10,"enter_lint_attrs","","",378],[10,"exit_lint_attrs","","",378],[10,"get_lints","","",379],[10,"check_expr","","",379],[10,"check_crate","","",379],[10,"check_ident","","",379],[10,"check_mod","","",379],[10,"check_view_item","","",379],[10,"check_foreign_item","","",379],[10,"check_item","","",379],[10,"check_local","","",379],[10,"check_block","","",379],[10,"check_stmt","","",379],[10,"check_arm","","",379],[10,"check_pat","","",379],[10,"check_decl","","",379],[10,"check_expr","","",379],[10,"check_expr_post","","",379],[10,"check_ty","","",379],[10,"check_generics","","",379],[10,"check_fn","","",379],[10,"check_ty_method","","",379],[10,"check_trait_method","","",379],[10,"check_struct_def","","",379],[10,"check_struct_def_post","","",379],[10,"check_struct_field","","",379],[10,"check_variant","","",379],[10,"check_variant_post","","",379],[10,"check_opt_lifetime_ref","","",379],[10,"check_lifetime_ref","","",379],[10,"check_lifetime_def","","",379],[10,"check_explicit_self","","",379],[10,"check_mac","","",379],[10,"check_path","","",379],[10,"check_attribute","","",379],[10,"enter_lint_attrs","","",379],[10,"exit_lint_attrs","","",379],[10,"new","","",380],[10,"get_lints","","",380],[10,"enter_lint_attrs","","",380],[10,"exit_lint_attrs","","",380],[10,"check_struct_def","","",380],[10,"check_struct_def_post","","",380],[10,"check_crate","","",380],[10,"check_item","","",380],[10,"check_fn","","",380],[10,"check_ty_method","","",380],[10,"check_struct_field","","",380],[10,"check_variant","","",380],[10,"check_variant_post","","",380],[10,"check_crate","","",380],[10,"check_ident","","",380],[10,"check_mod","","",380],[10,"check_view_item","","",380],[10,"check_foreign_item","","",380],[10,"check_item","","",380],[10,"check_local","","",380],[10,"check_block","","",380],[10,"check_stmt","","",380],[10,"check_arm","","",380],[10,"check_pat","","",380],[10,"check_decl","","",380],[10,"check_expr","","",380],[10,"check_expr_post","","",380],[10,"check_ty","","",380],[10,"check_generics","","",380],[10,"check_fn","","",380],[10,"check_ty_method","","",380],[10,"check_trait_method","","",380],[10,"check_struct_def","","",380],[10,"check_struct_def_post","","",380],[10,"check_struct_field","","",380],[10,"check_variant","","",380],[10,"check_variant_post","","",380],[10,"check_opt_lifetime_ref","","",380],[10,"check_lifetime_ref","","",380],[10,"check_lifetime_def","","",380],[10,"check_explicit_self","","",380],[10,"check_mac","","",380],[10,"check_path","","",380],[10,"check_attribute","","",380],[10,"enter_lint_attrs","","",380],[10,"exit_lint_attrs","","",380],[10,"get_lints","","",381],[10,"check_item","","",381],[10,"check_crate","","",381],[10,"check_ident","","",381],[10,"check_mod","","",381],[10,"check_view_item","","",381],[10,"check_foreign_item","","",381],[10,"check_item","","",381],[10,"check_local","","",381],[10,"check_block","","",381],[10,"check_stmt","","",381],[10,"check_arm","","",381],[10,"check_pat","","",381],[10,"check_decl","","",381],[10,"check_expr","","",381],[10,"check_expr_post","","",381],[10,"check_ty","","",381],[10,"check_generics","","",381],[10,"check_fn","","",381],[10,"check_ty_method","","",381],[10,"check_trait_method","","",381],[10,"check_struct_def","","",381],[10,"check_struct_def_post","","",381],[10,"check_struct_field","","",381],[10,"check_variant","","",381],[10,"check_variant_post","","",381],[10,"check_opt_lifetime_ref","","",381],[10,"check_lifetime_ref","","",381],[10,"check_lifetime_def","","",381],[10,"check_explicit_self","","",381],[10,"check_mac","","",381],[10,"check_path","","",381],[10,"check_attribute","","",381],[10,"enter_lint_attrs","","",381],[10,"exit_lint_attrs","","",381],[10,"get_lints","","",382],[10,"check_view_item","","",382],[10,"check_expr","","",382],[10,"check_item","","",382],[10,"check_crate","","",382],[10,"check_ident","","",382],[10,"check_mod","","",382],[10,"check_view_item","","",382],[10,"check_foreign_item","","",382],[10,"check_item","","",382],[10,"check_local","","",382],[10,"check_block","","",382],[10,"check_stmt","","",382],[10,"check_arm","","",382],[10,"check_pat","","",382],[10,"check_decl","","",382],[10,"check_expr","","",382],[10,"check_expr_post","","",382],[10,"check_ty","","",382],[10,"check_generics","","",382],[10,"check_fn","","",382],[10,"check_ty_method","","",382],[10,"check_trait_method","","",382],[10,"check_struct_def","","",382],[10,"check_struct_def_post","","",382],[10,"check_struct_field","","",382],[10,"check_variant","","",382],[10,"check_variant_post","","",382],[10,"check_opt_lifetime_ref","","",382],[10,"check_lifetime_ref","","",382],[10,"check_lifetime_def","","",382],[10,"check_explicit_self","","",382],[10,"check_mac","","",382],[10,"check_path","","",382],[10,"check_attribute","","",382],[10,"enter_lint_attrs","","",382],[10,"exit_lint_attrs","","",382],[10,"get_lints","","",383],[10,"check_crate","","",383],[10,"check_ident","","",383],[10,"check_mod","","",383],[10,"check_view_item","","",383],[10,"check_foreign_item","","",383],[10,"check_item","","",383],[10,"check_local","","",383],[10,"check_block","","",383],[10,"check_stmt","","",383],[10,"check_arm","","",383],[10,"check_pat","","",383],[10,"check_decl","","",383],[10,"check_expr","","",383],[10,"check_expr_post","","",383],[10,"check_ty","","",383],[10,"check_generics","","",383],[10,"check_fn","","",383],[10,"check_ty_method","","",383],[10,"check_trait_method","","",383],[10,"check_struct_def","","",383],[10,"check_struct_def_post","","",383],[10,"check_struct_field","","",383],[10,"check_variant","","",383],[10,"check_variant_post","","",383],[10,"check_opt_lifetime_ref","","",383],[10,"check_lifetime_ref","","",383],[10,"check_lifetime_def","","",383],[10,"check_explicit_self","","",383],[10,"check_mac","","",383],[10,"check_path","","",383],[10,"check_attribute","","",383],[10,"enter_lint_attrs","","",383],[10,"exit_lint_attrs","","",383],[10,"new","rustc::lint::context","",384],[10,"get_lints","","",384],[10,"get_lint_groups","","",384],[10,"register_pass","","",384],[10,"register_group","","",384],[10,"register_builtin","","",384],[10,"process_command_line","","",384],[10,"sess","","Get the overall compiler `Session` object.",385],[10,"current_level","","Get the level of `lint` at the current position of the lint\ntraversal.",385],[10,"lint","","Emit a lint at the appropriate level, with no associated span.",385],[10,"span_lint","","Emit a lint at the appropriate level, for a particular span.",385],[10,"visit_item","","",385],[10,"visit_foreign_item","","",385],[10,"visit_view_item","","",385],[10,"visit_pat","","",385],[10,"visit_expr","","",385],[10,"visit_stmt","","",385],[10,"visit_fn","","",385],[10,"visit_ty_method","","",385],[10,"visit_struct_def","","",385],[10,"visit_struct_field","","",385],[10,"visit_variant","","",385],[10,"visit_ty","","",385],[10,"visit_ident","","",385],[10,"visit_mod","","",385],[10,"visit_local","","",385],[10,"visit_block","","",385],[10,"visit_arm","","",385],[10,"visit_decl","","",385],[10,"visit_expr_post","","",385],[10,"visit_generics","","",385],[10,"visit_trait_item","","",385],[10,"visit_opt_lifetime_ref","","",385],[10,"visit_lifetime_ref","","",385],[10,"visit_lifetime_def","","",385],[10,"visit_explicit_self","","",385],[10,"visit_mac","","",385],[10,"visit_path","","",385],[10,"visit_attribute","","",385],[10,"visit_name","","",385],[10,"visit_ident","","",385],[10,"visit_mod","","",385],[10,"visit_view_item","","",385],[10,"visit_foreign_item","","",385],[10,"visit_item","","",385],[10,"visit_local","","",385],[10,"visit_block","","",385],[10,"visit_stmt","","",385],[10,"visit_arm","","",385],[10,"visit_pat","","",385],[10,"visit_decl","","",385],[10,"visit_expr","","",385],[10,"visit_expr_post","","",385],[10,"visit_ty","","",385],[10,"visit_generics","","",385],[10,"visit_fn","","",385],[10,"visit_ty_method","","",385],[10,"visit_trait_item","","",385],[10,"visit_trait_ref","","",385],[10,"visit_ty_param_bound","","",385],[10,"visit_poly_trait_ref","","",385],[10,"visit_struct_def","","",385],[10,"visit_struct_field","","",385],[10,"visit_variant","","",385],[10,"visit_opt_lifetime_ref","","",385],[10,"visit_lifetime_bound","","",385],[10,"visit_lifetime_ref","","",385],[10,"visit_lifetime_def","","",385],[10,"visit_explicit_self","","",385],[10,"visit_mac","","",385],[10,"visit_path","","",385],[10,"visit_path_segment","","",385],[10,"visit_path_parameters","","",385],[10,"visit_assoc_type_binding","","",385],[10,"visit_attribute","","",385],[10,"visit_id","","",385],[10,"get_lints","","",386],[10,"check_item","","",386],[10,"check_crate","","",386],[10,"check_ident","","",386],[10,"check_mod","","",386],[10,"check_view_item","","",386],[10,"check_foreign_item","","",386],[10,"check_item","","",386],[10,"check_local","","",386],[10,"check_block","","",386],[10,"check_stmt","","",386],[10,"check_arm","","",386],[10,"check_pat","","",386],[10,"check_decl","","",386],[10,"check_expr","","",386],[10,"check_expr_post","","",386],[10,"check_ty","","",386],[10,"check_generics","","",386],[10,"check_fn","","",386],[10,"check_ty_method","","",386],[10,"check_trait_method","","",386],[10,"check_struct_def","","",386],[10,"check_struct_def_post","","",386],[10,"check_struct_field","","",386],[10,"check_variant","","",386],[10,"check_variant_post","","",386],[10,"check_opt_lifetime_ref","","",386],[10,"check_lifetime_ref","","",386],[10,"check_lifetime_def","","",386],[10,"check_explicit_self","","",386],[10,"check_mac","","",386],[10,"check_path","","",386],[10,"check_attribute","","",386],[10,"enter_lint_attrs","","",386],[10,"exit_lint_attrs","","",386],[10,"fmt","rustc::util::common","",387],[10,"clone","","",387],[10,"clone_from","","",387],[10,"drop","","",388],[10,"visit_expr","","",389],[10,"visit_name","","",389],[10,"visit_ident","","",389],[10,"visit_mod","","",389],[10,"visit_view_item","","",389],[10,"visit_foreign_item","","",389],[10,"visit_item","","",389],[10,"visit_local","","",389],[10,"visit_block","","",389],[10,"visit_stmt","","",389],[10,"visit_arm","","",389],[10,"visit_pat","","",389],[10,"visit_decl","","",389],[10,"visit_expr","","",389],[10,"visit_expr_post","","",389],[10,"visit_ty","","",389],[10,"visit_generics","","",389],[10,"visit_fn","","",389],[10,"visit_ty_method","","",389],[10,"visit_trait_item","","",389],[10,"visit_trait_ref","","",389],[10,"visit_ty_param_bound","","",389],[10,"visit_poly_trait_ref","","",389],[10,"visit_struct_def","","",389],[10,"visit_struct_field","","",389],[10,"visit_variant","","",389],[10,"visit_opt_lifetime_ref","","",389],[10,"visit_lifetime_bound","","",389],[10,"visit_lifetime_ref","","",389],[10,"visit_lifetime_def","","",389],[10,"visit_explicit_self","","",389],[10,"visit_mac","","",389],[10,"visit_path","","",389],[10,"visit_path_segment","","",389],[10,"visit_path_parameters","","",389],[10,"visit_assoc_type_binding","","",389],[10,"visit_attribute","","",389],[10,"visit_expr","","",390],[10,"visit_name","","",390],[10,"visit_ident","","",390],[10,"visit_mod","","",390],[10,"visit_view_item","","",390],[10,"visit_foreign_item","","",390],[10,"visit_item","","",390],[10,"visit_local","","",390],[10,"visit_block","","",390],[10,"visit_stmt","","",390],[10,"visit_arm","","",390],[10,"visit_pat","","",390],[10,"visit_decl","","",390],[10,"visit_expr","","",390],[10,"visit_expr_post","","",390],[10,"visit_ty","","",390],[10,"visit_generics","","",390],[10,"visit_fn","","",390],[10,"visit_ty_method","","",390],[10,"visit_trait_item","","",390],[10,"visit_trait_ref","","",390],[10,"visit_ty_param_bound","","",390],[10,"visit_poly_trait_ref","","",390],[10,"visit_struct_def","","",390],[10,"visit_struct_field","","",390],[10,"visit_variant","","",390],[10,"visit_opt_lifetime_ref","","",390],[10,"visit_lifetime_bound","","",390],[10,"visit_lifetime_ref","","",390],[10,"visit_lifetime_def","","",390],[10,"visit_explicit_self","","",390],[10,"visit_mac","","",390],[10,"visit_path","","",390],[10,"visit_path_segment","","",390],[10,"visit_path_parameters","","",390],[10,"visit_assoc_type_binding","","",390],[10,"visit_attribute","","",390],[10,"repr","core::option","",53],[10,"repr","syntax::ptr","",391],[10,"repr","core::result","",168],[10,"repr","alloc::rc","",122],[10,"repr","alloc::boxed","",306],[10,"repr","syntax::owned_slice","",308],[10,"repr","collections::vec","",307],[10,"user_string","","",307],[10,"repr","rustc::middle::def","",56],[10,"repr","rustc::middle::ty","",286],[10,"repr","","",287],[10,"repr","","",265],[10,"repr","","",246],[10,"repr","rustc::middle::subst","",209],[10,"repr","","",212],[10,"repr","rustc::middle::ty","",297],[10,"repr","rustc::middle::subst","",210],[10,"repr","collections::enum_set","",309],[10,"repr","rustc::middle::ty","",280],[10,"repr","","",279],[10,"repr","","",123],[10,"repr","","",392],[10,"repr","syntax::ast","",393],[10,"repr","","",189],[10,"repr","","",394],[10,"user_string","","",394],[10,"repr","","",395],[10,"repr","","",396],[10,"repr","","",397],[10,"repr","syntax::codemap","",398],[10,"repr","syntax::ast","",190],[10,"repr","rustc::middle::ty","",60],[10,"repr","","",57],[10,"user_string","","",57],[10,"repr","","",58],[10,"repr","syntax::ast","",52],[10,"repr","rustc::middle::ty","",296],[10,"repr","","",288],[10,"repr","","",294],[10,"repr","","",249],[10,"repr","","",250],[10,"repr","","",244],[10,"repr","syntax::ast","",10],[10,"user_string","","",10],[10,"repr","","",9],[10,"repr","","",399],[10,"repr","","",400],[10,"repr","rustc::middle::ty","",268],[10,"repr","","",125],[10,"repr","","",270],[10,"repr","","",258],[10,"repr","","",65],[10,"repr","","",256],[10,"repr","","",257],[10,"repr","","",61],[10,"repr","","",281],[10,"user_string","","",281],[10,"repr","syntax::codemap","",54],[10,"user_string","alloc::rc","",122],[10,"user_string","rustc::middle::ty","",279],[10,"user_string","","",280],[10,"user_string","collections::enum_set","",309],[10,"user_string","rustc::middle::ty","",130],[10,"user_string","","",123],[10,"user_string","syntax::ast","",9],[10,"repr","syntax::abi","",401],[10,"user_string","","",401],[10,"repr","rustc::middle::ty","",273],[10,"repr","syntax::ast","",402],[10,"repr","rustc::middle::ty","",274],[10,"repr","","",64],[10,"repr","","",157],[10,"repr","","",159],[10,"repr","","",283],[10,"repr","","",282],[10,"repr","","",158],[10,"repr","syntax::ast","",403],[10,"repr","","",404],[10,"repr","","",160],[10,"repr","rustc::middle::ty","",305],[10,"user_string","","",271],[10,"repr","","",271],[10,"repr","","",130],[10,"repr","std::collections::hash::map","",405],[10,"repr","rustc::middle::ty","",292],[10,"user_string","","",292],[10,"repr","","",291],[10,"user_string","","",291],[10,"repr","","",290],[10,"user_string","","",290],[10,"user_string","","",124],[10,"repr","","",293],[10,"user_string","","",293],[10,"user_string","","",289],[10,"default","rustc::util::nodemap","",406],[10,"clone","","",406],[10,"clone_from","","",406],[10,"hash","","",406],[10,"write","","",407],[10,"eq","rustc::util::snapshot_vec","",408],[10,"ne","","",408],[10,"ne","","",408],[10,"new","","",409],[10,"record","","",409],[10,"push","","",409],[10,"get","","",409],[10,"get_mut","","Returns a mutable pointer into the vec; whatever changes you make here cannot be undone\nautomatically, so you should be sure call `record()` with some sort of suitable undo\naction.",409],[10,"set","","Updates the element at the given index. The old value will saved (and perhaps restored) if\na snapshot is active.",409],[10,"start_snapshot","","",409],[10,"actions_since_snapshot","","",409],[10,"rollback_to","","",409],[10,"commit","","Commits all changes since the last snapshot. Of course, they\ncan still be undone if there is a snapshot further out.",409],[1,"Config","rustc_trans::session::config",""],[11,"target","","",410],[11,"int_type","","",410],[11,"uint_type","","",410],[2,"OptLevel","",""],[12,"No","","",334],[12,"Less","","",334],[12,"Default","","",334],[12,"Aggressive","","",334],[2,"DebugInfoLevel","",""],[12,"NoDebugInfo","","",335],[12,"LimitedDebugInfo","","",335],[12,"FullDebugInfo","","",335],[2,"OutputType","",""],[12,"OutputTypeBitcode","","",336],[12,"OutputTypeAssembly","","",336],[12,"OutputTypeLlvmAssembly","","",336],[12,"OutputTypeObject","","",336],[12,"OutputTypeExe","","",336],[12,"OutputTypeDepInfo","","",336],[1,"Options","",""],[11,"crate_types","","",337],[11,"gc","","",337],[11,"optimize","","",337],[11,"debuginfo","","",337],[11,"lint_opts","","",337],[11,"describe_lints","","",337],[11,"output_types","","",337],[11,"search_paths","","",337],[11,"libs","","",337],[11,"maybe_sysroot","","",337],[11,"target_triple","","",337],[11,"cfg","","",337],[11,"test","","",337],[11,"parse_only","","",337],[11,"no_trans","","",337],[11,"no_analysis","","",337],[11,"debugging_opts","","",337],[11,"write_dependency_info","","Whether to write dependency files. It's (enabled, optional filename).",337],[11,"prints","","",337],[11,"cg","","",337],[11,"color","","",337],[11,"externs","","",337],[11,"crate_name","","",337],[11,"alt_std_name","","An optional name to use as the crate for std during std injection,\nwritten `extern crate std = \"name\"`. Default to \"std\". Used by\nout-of-tree drivers.",337],[2,"PrintRequest","",""],[12,"FileNames","","",338],[12,"Sysroot","","",338],[12,"CrateName","","",338],[2,"Input","",""],[12,"File","","Load source from file",339],[12,"Str","","The string is the source",339],[1,"OutputFilenames","",""],[11,"out_directory","","",340],[11,"out_filestem","","",340],[11,"single_output_file","","",340],[11,"extra","","",340],[3,"host_triple","",""],[3,"basic_options","","Some reasonable defaults"],[2,"EntryFnType","",""],[12,"EntryMain","","",341],[12,"EntryStart","","",341],[12,"EntryNone","","",341],[2,"CrateType","",""],[12,"CrateTypeExecutable","","",342],[12,"CrateTypeDylib","","",342],[12,"CrateTypeRlib","","",342],[12,"CrateTypeStaticlib","","",342],[18,"VERBOSE","",""],[18,"TIME_PASSES","",""],[18,"COUNT_LLVM_INSNS","",""],[18,"TIME_LLVM_PASSES","",""],[18,"TRANS_STATS","",""],[18,"ASM_COMMENTS","",""],[18,"NO_VERIFY","",""],[18,"BORROWCK_STATS","",""],[18,"NO_LANDING_PADS","",""],[18,"DEBUG_LLVM","",""],[18,"SHOW_SPAN","",""],[18,"COUNT_TYPE_SIZES","",""],[18,"META_STATS","",""],[18,"GC","",""],[18,"PRINT_LINK_ARGS","",""],[18,"PRINT_LLVM_PASSES","",""],[18,"AST_JSON","",""],[18,"AST_JSON_NOEXPAND","",""],[18,"LS","",""],[18,"SAVE_ANALYSIS","",""],[18,"PRINT_MOVE_FRAGMENTS","",""],[18,"FLOWGRAPH_PRINT_LOANS","",""],[18,"FLOWGRAPH_PRINT_MOVES","",""],[18,"FLOWGRAPH_PRINT_ASSIGNS","",""],[18,"FLOWGRAPH_PRINT_ALL","",""],[18,"PRINT_REGION_GRAPH","",""],[18,"PARSE_ONLY","",""],[18,"NO_TRANS","",""],[18,"NO_ANALYSIS","",""],[18,"UNSTABLE_OPTIONS","",""],[18,"PRINT_ENUM_SIZES","",""],[3,"debugging_opts_map","",""],[2,"Passes","",""],[12,"SomePasses","","",343],[12,"AllPasses","","",343],[1,"CodegenOptions","",""],[11,"ar","","",344],[11,"linker","","",344],[11,"link_args","","",344],[11,"lto","","",344],[11,"target_cpu","","",344],[11,"target_feature","","",344],[11,"passes","","",344],[11,"llvm_args","","",344],[11,"save_temps","","",344],[11,"rpath","","",344],[11,"no_prepopulate_passes","","",344],[11,"no_vectorize_loops","","",344],[11,"no_vectorize_slp","","",344],[11,"soft_float","","",344],[11,"prefer_dynamic","","",344],[11,"no_integrated_as","","",344],[11,"no_redzone","","",344],[11,"relocation_model","","",344],[11,"code_model","","",344],[11,"metadata","","",344],[11,"extra_filename","","",344],[11,"codegen_units","","",344],[11,"remark","","",344],[11,"no_stack_check","","",344],[11,"debuginfo","","",344],[11,"opt_level","","",344],[3,"basic_codegen_options","",""],[4,"CodegenSetter","",""],[18,"CG_OPTIONS","",""],[3,"build_codegen_options","",""],[3,"default_lib_output","",""],[3,"default_configuration","",""],[3,"append_configuration","",""],[3,"build_configuration","",""],[3,"build_target_config","",""],[3,"short_optgroups","","Returns the \"short\" subset of the stable rustc command line options."],[3,"optgroups","","Returns all of the stable rustc command line options."],[2,"OptionStability","",""],[12,"Stable","","",345],[12,"Unstable","","",345],[1,"RustcOptGroup","",""],[11,"opt_group","","",346],[11,"stability","","",346],[3,"rustc_short_optgroups","","Returns the \"short\" subset of the rustc command line options,\nincluding metadata for each option, such as whether the option is\npart of the stable long-term interface for rustc."],[3,"rustc_optgroups","","Returns all rustc command line options, including metadata for\neach option, such as whether the option is part of the stable\nlong-term interface for rustc."],[3,"parse_cfgspecs","",""],[3,"build_session_options","",""],[3,"parse_crate_types_from_list","",""],[0,"search_paths","rustc_trans::session",""],[1,"SearchPaths","rustc_trans::session::search_paths",""],[1,"Iter","",""],[2,"PathKind","",""],[12,"Native","","",348],[12,"Crate","","",348],[12,"Dependency","","",348],[12,"All","","",348],[1,"Session","rustc_trans::session",""],[11,"target","","",350],[11,"opts","","",350],[11,"cstore","","",350],[11,"parse_sess","","",350],[11,"entry_fn","","",350],[11,"entry_type","","",350],[11,"plugin_registrar_fn","","",350],[11,"default_sysroot","","",350],[11,"local_crate_source_file","","",350],[11,"working_dir","","",350],[11,"lint_store","","",350],[11,"lints","","",350],[11,"crate_types","","",350],[11,"crate_metadata","","",350],[11,"features","","",350],[11,"recursion_limit","","The maximum recursion limit for potentially infinitely recursive\noperations such as auto-dereference and monomorphization.",350],[11,"can_print_warnings","","",350],[3,"build_session","",""],[3,"build_session_","",""],[3,"expect","",""],[3,"early_error","",""],[3,"early_warn","",""],[0,"metadata","rustc_trans",""],[0,"common","rustc_trans::metadata",""],[18,"tag_items","rustc_trans::metadata::common",""],[18,"tag_paths_data_name","",""],[18,"tag_def_id","",""],[18,"tag_items_data","",""],[18,"tag_items_data_item","",""],[18,"tag_items_data_item_family","",""],[18,"tag_items_data_item_type","",""],[18,"tag_items_data_item_symbol","",""],[18,"tag_items_data_item_variant","",""],[18,"tag_items_data_parent_item","",""],[18,"tag_items_data_item_is_tuple_struct_ctor","",""],[18,"tag_index","",""],[18,"tag_index_buckets","",""],[18,"tag_index_buckets_bucket","",""],[18,"tag_index_buckets_bucket_elt","",""],[18,"tag_index_table","",""],[18,"tag_meta_item_name_value","",""],[18,"tag_meta_item_name","",""],[18,"tag_meta_item_value","",""],[18,"tag_attributes","",""],[18,"tag_attribute","",""],[18,"tag_meta_item_word","",""],[18,"tag_meta_item_list","",""],[18,"tag_crate_deps","",""],[18,"tag_crate_dep","",""],[18,"tag_crate_hash","",""],[18,"tag_crate_crate_name","",""],[18,"tag_crate_dep_crate_name","",""],[18,"tag_crate_dep_hash","",""],[18,"tag_mod_impl","",""],[18,"tag_item_trait_item","",""],[18,"tag_item_trait_ref","",""],[18,"tag_item_super_trait_ref","",""],[18,"tag_disr_val","",""],[18,"tag_path","",""],[18,"tag_path_len","",""],[18,"tag_path_elem_mod","",""],[18,"tag_path_elem_name","",""],[18,"tag_item_field","",""],[18,"tag_item_field_origin","",""],[18,"tag_item_variances","",""],[18,"tag_item_impl_item","",""],[18,"tag_item_trait_method_explicit_self","",""],[18,"tag_items_data_item_reexport","",""],[18,"tag_items_data_item_reexport_def_id","",""],[18,"tag_items_data_item_reexport_name","",""],[2,"astencode_tag","",""],[12,"tag_ast","","",314],[12,"tag_tree","","",314],[12,"tag_id_range","","",314],[12,"tag_table","","",314],[12,"tag_table_id","","",314],[12,"tag_table_val","","",314],[12,"tag_table_def","","",314],[12,"tag_table_node_type","","",314],[12,"tag_table_item_subst","","",314],[12,"tag_table_freevars","","",314],[12,"tag_table_tcache","","",314],[12,"tag_table_param_defs","","",314],[12,"tag_table_mutbl","","",314],[12,"tag_table_last_use","","",314],[12,"tag_table_spill","","",314],[12,"tag_table_method_map","","",314],[12,"tag_table_vtable_map","","",314],[12,"tag_table_adjustments","","",314],[12,"tag_table_moves_map","","",314],[12,"tag_table_capture_map","","",314],[12,"tag_table_unboxed_closures","","",314],[12,"tag_table_upvar_borrow_map","","",314],[12,"tag_table_capture_modes","","",314],[12,"tag_table_object_cast_map","","",314],[18,"tag_item_trait_item_sort","",""],[18,"tag_item_trait_parent_sort","",""],[18,"tag_item_impl_type_basename","",""],[18,"tag_crate_triple","",""],[18,"tag_dylib_dependency_formats","",""],[18,"tag_lang_items","",""],[18,"tag_lang_items_item","",""],[18,"tag_lang_items_item_id","",""],[18,"tag_lang_items_item_node_id","",""],[18,"tag_lang_items_missing","",""],[18,"tag_item_unnamed_field","",""],[18,"tag_items_data_item_visibility","",""],[18,"tag_item_method_tps","",""],[18,"tag_item_method_fty","",""],[18,"tag_mod_child","",""],[18,"tag_misc_info","",""],[18,"tag_misc_info_crate_items","",""],[18,"tag_item_method_provided_source","",""],[18,"tag_item_impl_vtables","",""],[18,"tag_impls","",""],[18,"tag_impls_impl","",""],[18,"tag_items_data_item_inherent_impl","",""],[18,"tag_items_data_item_extension_impl","",""],[18,"tag_native_libraries","",""],[18,"tag_native_libraries_lib","",""],[18,"tag_native_libraries_name","",""],[18,"tag_native_libraries_kind","",""],[18,"tag_plugin_registrar_fn","",""],[18,"tag_exported_macros","",""],[18,"tag_macro_def","",""],[18,"tag_method_argument_names","",""],[18,"tag_method_argument_name","",""],[18,"tag_reachable_extern_fns","",""],[18,"tag_reachable_extern_fn_id","",""],[18,"tag_items_data_item_stability","",""],[18,"tag_items_data_item_repr","",""],[1,"LinkMeta","",""],[11,"crate_name","","",315],[11,"crate_hash","","",315],[18,"tag_unboxed_closures","",""],[18,"tag_unboxed_closure","",""],[18,"tag_unboxed_closure_type","",""],[18,"tag_unboxed_closure_kind","",""],[18,"tag_struct_fields","",""],[18,"tag_struct_field","",""],[18,"tag_struct_field_id","",""],[18,"tag_attribute_is_sugared_doc","",""],[18,"tag_trait_def_bounds","",""],[18,"tag_items_data_region","",""],[18,"tag_region_param_def","",""],[18,"tag_region_param_def_ident","",""],[18,"tag_region_param_def_def_id","",""],[18,"tag_region_param_def_space","",""],[18,"tag_region_param_def_index","",""],[18,"tag_type_param_def","",""],[18,"tag_item_generics","",""],[18,"tag_method_ty_generics","",""],[18,"tag_predicate","",""],[18,"tag_predicate_space","",""],[18,"tag_predicate_data","",""],[18,"tag_unsafety","",""],[18,"tag_associated_type_names","",""],[18,"tag_associated_type_name","",""],[0,"tyencode","rustc_trans::metadata",""],[1,"ctxt","rustc_trans::metadata::tyencode",""],[11,"diag","","",411],[11,"ds","","",411],[11,"tcx","","",411],[11,"abbrevs","","",411],[1,"ty_abbrev","",""],[4,"abbrev_map","",""],[3,"enc_ty","",""],[3,"enc_substs","",""],[3,"enc_region","",""],[3,"enc_trait_ref","",""],[3,"enc_trait_store","",""],[3,"enc_bare_fn_ty","",""],[3,"enc_closure_ty","",""],[3,"enc_builtin_bounds","",""],[3,"enc_existential_bounds","",""],[3,"enc_bounds","",""],[3,"enc_type_param_def","",""],[3,"enc_predicate","",""],[0,"tydecode","rustc_trans::metadata",""],[2,"DefIdSource","rustc_trans::metadata::tydecode",""],[12,"NominalType","","",316],[12,"TypeWithId","","",316],[12,"TypeParameter","","",316],[12,"RegionParameter","","",316],[12,"UnboxedClosureSource","","",316],[4,"conv_did","",""],[1,"PState","",""],[3,"parse_ident","",""],[3,"parse_name","",""],[3,"parse_state_from_data","",""],[3,"parse_ty_closure_data","",""],[3,"parse_ty_data","",""],[3,"parse_region_data","",""],[3,"parse_bare_fn_ty_data","",""],[3,"parse_trait_ref_data","",""],[3,"parse_substs_data","",""],[3,"parse_bounds_data","",""],[3,"parse_existential_bounds_data","",""],[3,"parse_builtin_bounds_data","",""],[3,"parse_def_id","",""],[3,"parse_predicate_data","",""],[3,"parse_predicate","",""],[3,"parse_type_param_def_data","",""],[0,"encoder","rustc_trans::metadata",""],[2,"InlinedItemRef","rustc_trans::metadata::encoder","A borrowed version of `ast::InlinedItem`."],[12,"IIItemRef","","",412],[12,"IITraitItemRef","","",412],[12,"IIImplItemRef","","",412],[12,"IIForeignRef","","",412],[4,"Encoder","",""],[4,"EncodeInlinedItem","",""],[1,"EncodeParams","",""],[11,"diag","","",413],[11,"tcx","","",413],[11,"reexports","","",413],[11,"item_symbols","","",413],[11,"link_meta","","",413],[11,"cstore","","",413],[11,"encode_inlined_item","","",413],[11,"reachable","","",413],[1,"EncodeContext","",""],[11,"diag","","",66],[11,"tcx","","",66],[11,"reexports","","",66],[11,"item_symbols","","",66],[11,"link_meta","","",66],[11,"cstore","","",66],[11,"encode_inlined_item","","",66],[11,"type_abbrevs","","",66],[11,"reachable","","",66],[3,"encode_def_id","",""],[3,"def_to_string","",""],[3,"write_closure_type","",""],[3,"write_type","",""],[3,"write_trait_ref","",""],[3,"write_region","",""],[18,"metadata_encoding_version","",""],[3,"encode_metadata","",""],[3,"encoded_ty","",""],[0,"decoder","rustc_trans::metadata",""],[4,"Cmd","rustc_trans::metadata::decoder",""],[3,"maybe_find_item","",""],[3,"item_type","",""],[3,"get_trait_def","",""],[3,"get_type","",""],[3,"get_stability","",""],[3,"get_repr_attrs","",""],[3,"get_impl_trait","",""],[3,"get_impl_vtables","",""],[3,"get_symbol","",""],[2,"DefLike","",""],[12,"DlDef","","",321],[12,"DlImpl","","",321],[12,"DlField","","",321],[3,"each_lang_item","","Iterates over the language items in the given crate."],[3,"each_child_of_item","","Iterates over each child of the given item."],[3,"each_top_level_item_of_crate","","Iterates over all the top-level crate items."],[3,"get_item_path","",""],[4,"DecodeInlinedItem","",""],[3,"maybe_get_item_ast","",""],[3,"get_enum_variant_defs","",""],[3,"get_enum_variants","",""],[3,"get_impl_items","","Returns the def IDs of all the items in the given implementation."],[3,"get_trait_name","",""],[3,"get_trait_item_name_and_kind","",""],[3,"get_impl_or_trait_item","",""],[3,"get_trait_item_def_ids","",""],[3,"get_item_variances","",""],[3,"get_provided_trait_methods","",""],[3,"get_supertraits","","Returns the supertraits of the given trait."],[3,"get_type_name_if_impl","",""],[3,"get_methods_if_impl","",""],[3,"get_tuple_struct_definition_if_ctor","","If node_id is the constructor of a tuple struct, retrieve the NodeId of\nthe actual type definition, otherwise, return None"],[3,"get_item_attrs","",""],[3,"get_struct_field_attrs","",""],[3,"get_struct_fields","",""],[3,"get_crate_attributes","",""],[1,"CrateDep","",""],[11,"cnum","","",322],[11,"name","","",322],[11,"hash","","",322],[3,"get_crate_deps","",""],[3,"maybe_get_crate_hash","",""],[3,"get_crate_hash","",""],[3,"maybe_get_crate_name","",""],[3,"get_crate_triple","",""],[3,"get_crate_name","",""],[3,"list_crate_metadata","",""],[3,"translate_def_id","",""],[3,"each_impl","",""],[3,"each_implementation_for_type","",""],[3,"each_implementation_for_trait","",""],[3,"get_trait_of_item","",""],[3,"get_native_libraries","",""],[3,"get_plugin_registrar_fn","",""],[3,"get_exported_macros","",""],[3,"get_dylib_dependency_formats","",""],[3,"get_missing_lang_items","",""],[3,"get_method_arg_names","",""],[3,"get_reachable_extern_fns","",""],[3,"is_typedef","",""],[3,"is_associated_type","",""],[0,"creader","rustc_trans::metadata","Validates all used crates and extern libraries and loads their metadata"],[3,"read_crates","rustc_trans::metadata::creader",""],[3,"validate_crate_name","",""],[1,"PluginMetadataReader","",""],[0,"cstore","rustc_trans::metadata",""],[4,"cnum_map","rustc_trans::metadata::cstore",""],[2,"MetadataBlob","",""],[12,"MetadataVec","","",330],[12,"MetadataArchive","","",330],[1,"crate_metadata","",""],[11,"name","","",329],[11,"data","","",329],[11,"cnum_map","","",329],[11,"cnum","","",329],[11,"span","","",329],[2,"LinkagePreference","",""],[12,"RequireDynamic","","",325],[12,"RequireStatic","","",325],[2,"NativeLibraryKind","",""],[12,"NativeStatic","","",326],[12,"NativeFramework","","",326],[12,"NativeUnknown","","",326],[1,"CrateSource","",""],[11,"dylib","","",327],[11,"rlib","","",327],[11,"cnum","","",327],[1,"CStore","",""],[11,"intr","","",328],[0,"csearch","rustc_trans::metadata",""],[1,"MethodInfo","rustc_trans::metadata::csearch",""],[11,"name","","",414],[11,"def_id","","",414],[11,"vis","","",414],[3,"get_symbol","",""],[3,"each_lang_item","","Iterates over all the language items in the given crate."],[3,"each_child_of_item","","Iterates over each child of the given item."],[3,"each_top_level_item_of_crate","","Iterates over each top-level crate item."],[3,"get_item_path","",""],[2,"found_ast","",""],[12,"found","","",415],[12,"found_parent","","",415],[12,"not_found","","",415],[3,"maybe_get_item_ast","",""],[3,"get_enum_variant_defs","",""],[3,"get_enum_variants","",""],[3,"get_impl_items","","Returns information about the given implementation."],[3,"get_impl_or_trait_item","",""],[3,"get_trait_name","",""],[3,"get_trait_item_name_and_kind","",""],[3,"get_trait_item_def_ids","",""],[3,"get_item_variances","",""],[3,"get_provided_trait_methods","",""],[3,"get_supertraits","",""],[3,"get_type_name_if_impl","",""],[3,"get_methods_if_impl","",""],[3,"get_item_attrs","",""],[3,"get_struct_fields","",""],[3,"get_struct_field_attrs","",""],[3,"get_type","",""],[3,"get_trait_def","",""],[3,"get_field_type","",""],[3,"get_impl_trait","",""],[3,"get_impl_vtables","",""],[3,"get_native_libraries","",""],[3,"each_impl","",""],[3,"each_implementation_for_type","",""],[3,"each_implementation_for_trait","",""],[3,"get_trait_of_item","","If the given def ID describes an item belonging to a trait (either a\ndefault method or an implementation of a trait method), returns the ID of\nthe trait that the method belongs to. Otherwise, returns `None`."],[3,"get_tuple_struct_definition_if_ctor","",""],[3,"get_dylib_dependency_formats","",""],[3,"get_missing_lang_items","",""],[3,"get_method_arg_names","",""],[3,"get_reachable_extern_fns","",""],[3,"is_typedef","",""],[3,"get_stability","",""],[3,"get_repr_attrs","",""],[3,"is_associated_type","",""],[0,"loader","rustc_trans::metadata","Finds crate binaries and loads their metadata"],[1,"CrateMismatch","rustc_trans::metadata::loader",""],[1,"Context","",""],[11,"sess","","",331],[11,"span","","",331],[11,"ident","","",331],[11,"crate_name","","",331],[11,"hash","","",331],[11,"triple","","",331],[11,"filesearch","","",331],[11,"root","","",331],[11,"rejected_via_hash","","",331],[11,"rejected_via_triple","","",331],[11,"should_match_name","","",331],[1,"Library","",""],[11,"dylib","","",416],[11,"rlib","","",416],[11,"metadata","","",416],[1,"ArchiveMetadata","",""],[1,"CratePaths","",""],[11,"ident","","",417],[11,"dylib","","",417],[11,"rlib","","",417],[3,"note_crate_name","",""],[3,"meta_section_name","",""],[3,"read_meta_section_name","",""],[3,"list_file_metadata","",""],[0,"filesearch","rustc_trans::metadata",""],[2,"FileMatch","rustc_trans::metadata::filesearch",""],[12,"FileMatches","","",418],[12,"FileDoesntMatch","","",418],[1,"FileSearch","",""],[11,"sysroot","","",333],[11,"search_paths","","",333],[11,"triple","","",333],[11,"kind","","",333],[3,"relative_target_lib_path","",""],[3,"get_or_default_sysroot","",""],[3,"get_rust_path","","Returns RUST_PATH as a string, without default paths added"],[3,"rust_path","","Returns the value of RUST_PATH, as a list\nof Paths. Includes default entries for, if they exist:\n$HOME/.rust\nDIR/.rust for any DIR that's the current working directory\nor an ancestor of it"],[3,"rustlibdir","",""],[0,"middle","rustc_trans",""],[0,"astconv_util","rustc_trans::middle","This module contains a simple utility routine\nused by both `typeck` and `const_eval`.\nAlmost certainly this could (and should) be refactored out of existence."],[18,"NO_REGIONS","rustc_trans::middle::astconv_util",""],[18,"NO_TPS","",""],[3,"check_path_args","",""],[3,"ast_ty_to_prim_ty","",""],[0,"astencode","rustc_trans::middle",""],[4,"Encoder","rustc_trans::middle::astencode",""],[3,"encode_inlined_item","",""],[3,"decode_inlined_item","",""],[3,"encode_unboxed_closure_kind","",""],[6,"vtable_decoder_helpers","",""],[9,"read_vec_per_param_space","","",419],[9,"read_vtable_res_with_key","","",419],[9,"read_vtable_res","","",419],[9,"read_vtable_param_res","","",419],[9,"read_vtable_origin","","",419],[0,"cfg","rustc_trans::middle","Module that constructs a control-flow graph representing an item.\nUses `Graph` as the underlying representation."],[0,"graphviz","rustc_trans::middle::cfg",""],[4,"Node","rustc_trans::middle::cfg::graphviz",""],[4,"Edge","",""],[1,"LabelledCFG","",""],[11,"ast_map","","",70],[11,"cfg","","",70],[11,"name","","",70],[1,"CFG","rustc_trans::middle::cfg",""],[11,"exit_map","","",71],[11,"graph","","",71],[11,"entry","","",71],[11,"exit","","",71],[1,"CFGNodeData","",""],[11,"id","","",420],[1,"CFGEdgeData","",""],[11,"exiting_scopes","","",421],[4,"CFGIndex","",""],[4,"CFGGraph","",""],[4,"CFGNode","",""],[4,"CFGEdge","",""],[0,"check_const","rustc_trans::middle",""],[3,"check_crate","rustc_trans::middle::check_const",""],[0,"check_static_recursion","rustc_trans::middle",""],[3,"check_crate","rustc_trans::middle::check_static_recursion",""],[3,"check_item_recursion","",""],[0,"check_loop","rustc_trans::middle",""],[3,"check_crate","rustc_trans::middle::check_loop",""],[0,"check_match","rustc_trans::middle",""],[18,"DUMMY_WILD_PAT","rustc_trans::middle::check_match",""],[1,"MatchCheckCtxt","",""],[11,"tcx","","",80],[11,"param_env","","",80],[2,"Constructor","",""],[12,"Single","","The constructor of all patterns that don't vary by constructor,\ne.g. struct patterns and fixed-length arrays.",78],[12,"Variant","","Enum variants.",78],[12,"ConstantValue","","Literal values.",78],[12,"ConstantRange","","Ranges of literal values (2..5).",78],[12,"Slice","","Array patterns of length n.",78],[12,"SliceWithSubslice","","Array patterns with a subslice.",78],[3,"check_crate","",""],[1,"StaticInliner","",""],[11,"tcx","","",81],[11,"failed","","",81],[3,"constructor_arity","","This computes the arity of a constructor. The arity of a constructor\nis how many subpattern patterns of that constructor should be expanded to."],[3,"specialize","","This is the main specialization step. It expands the first pattern in the given row\ninto `arity` patterns based on the constructor. For most patterns, the step is trivial,\nfor instance tuple patterns are flattened and box patterns expand into their inner pattern."],[0,"check_rvalues","rustc_trans::middle",""],[3,"check_crate","rustc_trans::middle::check_rvalues",""],[0,"check_static","rustc_trans::middle",""],[3,"check_crate","rustc_trans::middle::check_static",""],[0,"const_eval","rustc_trans::middle",""],[2,"constness","rustc_trans::middle::const_eval",""],[12,"integral_const","","",422],[12,"general_const","","",422],[12,"non_const","","",422],[3,"join","",""],[3,"join_all","",""],[3,"lookup_const_by_id","",""],[3,"process_crate","",""],[2,"const_val","",""],[12,"const_float","","",91],[12,"const_int","","",91],[12,"const_uint","","",91],[12,"const_str","","",91],[12,"const_binary","","",91],[12,"const_bool","","",91],[3,"const_expr_to_pat","",""],[3,"eval_const_expr","",""],[3,"eval_const_expr_partial","",""],[3,"lit_to_const","",""],[3,"compare_const_vals","",""],[3,"compare_lit_exprs","",""],[0,"dataflow","rustc_trans::middle","A module for propagating forward dataflow information. The analysis\nassumes that the items to be propagated can be represented as bits\nand thus uses bitvectors. Your job is simply to specify the so-called\nGEN and KILL bits for each expression."],[2,"EntryOrExit","rustc_trans::middle::dataflow",""],[12,"Entry","","",92],[12,"Exit","","",92],[1,"DataFlowContext","",""],[6,"BitwiseOperator","",""],[9,"join","","Joins two predecessor bits together, typically either `|` or `&`",423],[6,"DataFlowOperator","","Parameterization for the precise form of data flow that is used."],[9,"initial_value","","Specifies the initial value for each bit in the `on_entry` set",424],[0,"dead","rustc_trans::middle",""],[3,"check_crate","rustc_trans::middle::dead",""],[0,"def","rustc_trans::middle",""],[2,"Def","rustc_trans::middle::def",""],[12,"DefFn","","",56],[12,"DefStaticMethod","","",56],[12,"DefSelfTy","","",56],[12,"DefMod","","",56],[12,"DefForeignMod","","",56],[12,"DefStatic","","",56],[12,"DefConst","","",56],[12,"DefLocal","","",56],[12,"DefVariant","","",56],[12,"DefTy","","",56],[12,"DefAssociatedTy","","",56],[12,"DefAssociatedPath","","",56],[12,"DefTrait","","",56],[12,"DefPrimTy","","",56],[12,"DefTyParam","","",56],[12,"DefUse","","",56],[12,"DefUpvar","","",56],[12,"DefStruct","","Note that if it's a tuple struct's definition, the node id of the ast::DefId\nmay either refer to the item definition's id or the StructDef.ctor_id.",56],[12,"DefTyParamBinder","","",56],[12,"DefRegion","","",56],[12,"DefLabel","","",56],[12,"DefMethod","","",56],[4,"DefMap","",""],[4,"ExportMap","",""],[1,"Export","",""],[11,"name","","",425],[11,"def_id","","",425],[2,"MethodProvenance","",""],[12,"FromTrait","","",99],[12,"FromImpl","","",99],[2,"TyParamProvenance","",""],[12,"FromSelf","","",100],[12,"FromParam","","",100],[2,"TraitItemKind","",""],[12,"NonstaticMethodTraitItemKind","","",101],[12,"StaticMethodTraitItemKind","","",101],[12,"TypeTraitItemKind","","",101],[0,"dependency_format","rustc_trans::middle","Resolution of mixing rlibs and dylibs"],[4,"DependencyList","rustc_trans::middle::dependency_format",""],[4,"Dependencies","",""],[3,"calculate","",""],[0,"effect","rustc_trans::middle","Enforces the Rust effect system. Currently there is just one effect,"],[3,"check_crate","rustc_trans::middle::effect",""],[0,"entry","rustc_trans::middle",""],[3,"find_entry_point","rustc_trans::middle::entry",""],[0,"expr_use_visitor","rustc_trans::middle","A different sort of visitor for walking fn bodies.  Unlike the\nnormal visitor, which just walks the entire body in one shot, the\n`ExprUseVisitor` determines how expressions are being used."],[6,"Delegate","rustc_trans::middle::expr_use_visitor","This trait defines the callbacks you can expect to receive when\nemploying the ExprUseVisitor."],[9,"consume","","",426],[9,"matched_pat","","",426],[9,"consume_pat","","",426],[9,"borrow","","",426],[9,"decl_without_init","","",426],[9,"mutate","","",426],[2,"LoanCause","",""],[12,"ClosureCapture","","",105],[12,"AddrOf","","",105],[12,"AutoRef","","",105],[12,"RefBinding","","",105],[12,"OverloadedOperator","","",105],[12,"ClosureInvocation","","",105],[12,"ForLoop","","",105],[12,"MatchDiscriminant","","",105],[2,"ConsumeMode","",""],[12,"Copy","","",106],[12,"Move","","",106],[2,"MoveReason","",""],[12,"DirectRefMove","","",107],[12,"PatBindingMove","","",107],[12,"CaptureMove","","",107],[2,"MatchMode","",""],[12,"NonBindingMatch","","",108],[12,"BorrowingMatch","","",108],[12,"CopyingMatch","","",108],[12,"MovingMatch","","",108],[2,"MutateMode","",""],[12,"Init","","",110],[12,"JustWrite","","",110],[12,"WriteAndRead","","",110],[1,"ExprUseVisitor","",""],[0,"fast_reject","rustc_trans::middle",""],[2,"SimplifiedType","rustc_trans::middle::fast_reject","See `simplify_type"],[12,"BoolSimplifiedType","","",112],[12,"CharSimplifiedType","","",112],[12,"IntSimplifiedType","","",112],[12,"UintSimplifiedType","","",112],[12,"FloatSimplifiedType","","",112],[12,"EnumSimplifiedType","","",112],[12,"StrSimplifiedType","","",112],[12,"VecSimplifiedType","","",112],[12,"PtrSimplifiedType","","",112],[12,"TupleSimplifiedType","","",112],[12,"TraitSimplifiedType","","",112],[12,"StructSimplifiedType","","",112],[12,"UnboxedClosureSimplifiedType","","",112],[12,"FunctionSimplifiedType","","",112],[12,"ParameterSimplifiedType","","",112],[3,"simplify_type","","Tries to simplify a type by dropping type parameters, deref'ing away any reference types, etc.\nThe idea is to get something simple that we can use to quickly decide if two types could unify\nduring method lookup."],[0,"graph","rustc_trans::middle","A graph module for use in dataflow, region resolution, and elsewhere."],[1,"Graph","rustc_trans::middle::graph",""],[1,"Node","",""],[11,"data","","",427],[1,"Edge","",""],[11,"data","","",113],[1,"NodeIndex","",""],[18,"InvalidNodeIndex","",""],[1,"EdgeIndex","",""],[18,"InvalidEdgeIndex","",""],[1,"Direction","",""],[18,"Outgoing","",""],[18,"Incoming","",""],[1,"DepthFirstTraversal","",""],[3,"each_edge_index","",""],[0,"intrinsicck","rustc_trans::middle",""],[3,"check_crate","rustc_trans::middle::intrinsicck",""],[0,"infer","rustc_trans::middle","See doc.rs for documentation"],[0,"coercion","rustc_trans::middle::infer","# Type Coercion"],[1,"Coerce","rustc_trans::middle::infer::coercion",""],[0,"combine","rustc_trans::middle::infer",""],[6,"Combine","rustc_trans::middle::infer::combine",""],[9,"infcx","","",428],[9,"tcx","","",428],[9,"tag","","",428],[9,"a_is_expected","","",428],[9,"trace","","",428],[9,"equate","","",428],[9,"sub","","",428],[9,"lub","","",428],[9,"glb","","",428],[9,"mts","","",428],[9,"contratys","","",428],[9,"tys","","",428],[9,"tps","","",428],[9,"substs","","",428],[9,"substs_variances","","",428],[9,"bare_fn_tys","","",428],[9,"closure_tys","","",428],[9,"fn_sigs","","",428],[9,"args","","",428],[9,"unsafeties","","",428],[9,"abi","","",428],[9,"oncenesses","","",428],[9,"projection_tys","","",428],[9,"projection_predicates","","",428],[9,"projection_bounds","","",428],[9,"existential_bounds","","",428],[9,"builtin_bounds","","",428],[9,"contraregions","","",428],[9,"regions","","",428],[9,"trait_stores","","",428],[9,"trait_refs","","",428],[9,"binders","","",428],[6,"Combineable","",""],[9,"combine","","",429],[1,"CombineFields","",""],[11,"infcx","","",126],[11,"a_is_expected","","",126],[11,"trace","","",126],[3,"expected_found","",""],[3,"super_tys","",""],[0,"doc","rustc_trans::middle::infer","# Type inference engine"],[0,"equate","",""],[1,"Equate","rustc_trans::middle::infer::equate",""],[3,"Equate","",""],[0,"error_reporting","rustc_trans::middle::infer","Error Reporting Code for the inference engine"],[6,"ErrorReporting","rustc_trans::middle::infer::error_reporting",""],[9,"report_region_errors","","",430],[9,"process_errors","","",430],[9,"report_type_error","","",430],[9,"report_and_explain_type_error","","",430],[9,"values_str","","",430],[9,"expected_found_str","","",430],[9,"report_concrete_failure","","",430],[9,"report_param_bound_failure","","",430],[9,"report_sub_sup_conflict","","",430],[9,"report_sup_sup_conflict","","",430],[9,"report_processed_errors","","",430],[9,"give_suggestion","","",430],[6,"Resolvable","",""],[9,"resolve","","",431],[9,"contains_error","","",431],[0,"glb","rustc_trans::middle::infer",""],[1,"Glb","rustc_trans::middle::infer::glb","\"Greatest lower bound\" (common subtype)"],[3,"Glb","",""],[0,"lattice","rustc_trans::middle::infer","# Lattice Variables"],[6,"LatticeDir","rustc_trans::middle::infer::lattice",""],[9,"relate_bound","","",432],[3,"super_lattice_tys","",""],[0,"lub","rustc_trans::middle::infer",""],[1,"Lub","rustc_trans::middle::infer::lub","\"Least upper bound\" (common supertype)"],[3,"Lub","",""],[0,"region_inference","rustc_trans::middle::infer","See doc.rs"],[2,"Constraint","rustc_trans::middle::infer::region_inference",""],[12,"ConstrainVarSubVar","","",135],[12,"ConstrainRegSubVar","","",135],[12,"ConstrainVarSubReg","","",135],[2,"Verify","",""],[12,"VerifyRegSubReg","","",144],[12,"VerifyParamBound","","",144],[1,"TwoRegions","",""],[2,"UndoLogEntry","",""],[12,"OpenSnapshot","","",137],[12,"CommitedSnapshot","","",137],[12,"AddVar","","",137],[12,"AddConstraint","","",137],[12,"AddVerify","","",137],[12,"AddGiven","","",137],[12,"AddCombination","","",137],[2,"CombineMapType","",""],[12,"Lub","","",138],[12,"Glb","","",138],[2,"RegionResolutionError","",""],[12,"ConcreteFailure","","`ConcreteFailure(o, a, b)`:",139],[12,"ParamBoundFailure","","`ParamBoundFailure(p, s, a, bs)",139],[12,"SubSupConflict","","`SubSupConflict(v, sub_origin, sub_r, sup_origin, sup_r)`:",139],[12,"SupSupConflict","","`SupSupConflict(v, origin1, r1, origin2, r2)`:",139],[12,"ProcessedErrors","","For subsets of `ConcreteFailure` and `SubSupConflict`, we can derive\nmore specific errors message by suggesting to the user where they\nshould put a lifetime. In those cases we process and put those errors\ninto `ProcessedErrors` before we do any reporting.",139],[1,"SameRegions","","SameRegions is used to group regions that we think are the same and would\nlike to indicate so to the user.\nFor example, the following function\n```\nstruct Foo { bar: int }\nfn foo2<'a, 'b>(x: &'a Foo) -> &'b int {\n   &x.bar\n}\n```\nwould report an error because we expect 'a and 'b to match, and so we group\n'a and 'b together inside a SameRegions struct"],[11,"scope_id","","",140],[11,"regions","","",140],[4,"CombineMap","",""],[1,"RegionVarBindings","",""],[1,"RegionSnapshot","",""],[2,"VarValue","",""],[12,"NoValue","","",145],[12,"Value","","",145],[12,"ErrorValue","","",145],[0,"resolve","rustc_trans::middle::infer",""],[1,"OpportunisticTypeResolver","rustc_trans::middle::infer::resolve","The opportunistic type resolver can be used at any time. It simply replaces\ntype variables that have been unified with the things they have\nbeen unified with (similar to `shallow_resolve`, but deep). This is\nuseful for printing messages etc but also required at various\npoints for correctness."],[3,"fully_resolve","","Full type resolution replaces all type and region variables with\ntheir concrete results. If any variable cannot be replaced (never unified, etc)\nthen an `Err` result is returned."],[0,"sub","rustc_trans::middle::infer",""],[1,"Sub","rustc_trans::middle::infer::sub","\"Greatest lower bound\" (common subtype)"],[3,"Sub","",""],[0,"type_variable","rustc_trans::middle::infer",""],[1,"TypeVariableTable","rustc_trans::middle::infer::type_variable",""],[1,"Snapshot","",""],[2,"RelationDir","",""],[12,"SubtypeOf","","",151],[12,"SupertypeOf","","",151],[12,"EqTo","","",151],[0,"unify","rustc_trans::middle::infer",""],[6,"UnifyKey","rustc_trans::middle::infer::unify","This trait is implemented by any type that can serve as a type\nvariable. We call such variables *unification keys*. For example,\nthis trait is implemented by `IntVid`, which represents integral\nvariables."],[9,"index","","",433],[9,"from_index","","",433],[9,"unification_table","","",433],[9,"tag","","",433],[6,"UnifyValue","","Trait for valid types that a type variable can be set to. Note that\nthis is typically not the end type that the value will take on, but\nrather an `Option` wrapper (where `None` represents a variable\nwhose value is not yet set)."],[2,"VarValue","","Value of a unification key. We implement Tarjan's union-find\nalgorithm: when two keys are unified, one of them is converted\ninto a \"redirect\" pointing at the other. These redirects form a\nDAG: the roots of the DAG (nodes that are not redirected) are each\nassociated with a value of type `V` and a rank. The rank is used\nto keep the DAG relatively balanced, which helps keep the running\ntime of the algorithm under control. For more information, see\n<http://en.wikipedia.org/wiki/Disjoint-set_data_structure>."],[12,"Redirect","","",154],[12,"Root","","",154],[1,"UnificationTable","","Table of unification keys and their values."],[1,"Snapshot","","At any time, users may snapshot a unification table.  The changes\nmade during the snapshot may either be *committed* or *rolled back*."],[1,"Node","","Internal type used to represent the result of a `get()` operation.\nConveys the current root and value of the key."],[11,"key","","",434],[11,"value","","",434],[11,"rank","","",434],[1,"Delegate","",""],[6,"SimplyUnifiable","","Indicates a type that does not have any kind of subtyping\nrelationship."],[9,"to_type","","",435],[9,"to_type_err","","",435],[3,"err","",""],[6,"InferCtxtMethodsForSimplyUnifiableTypes","",""],[9,"simple_vars","","",436],[9,"simple_var_t","","",436],[9,"probe_var","","",436],[4,"Bound","rustc_trans::middle::infer",""],[4,"cres","",""],[4,"ures","",""],[4,"fres","",""],[4,"CoerceResult","",""],[1,"InferCtxt","",""],[11,"tcx","","",129],[4,"SkolemizationMap","",""],[2,"TypeOrigin","","Why did we require that the two types be related?"],[12,"Misc","","",161],[12,"MethodCompatCheck","","",161],[12,"ExprAssignable","","",161],[12,"RelateTraitRefs","","",161],[12,"RelateSelfType","","",161],[12,"RelateOutputImplTypes","","",161],[12,"MatchExpressionArm","","",161],[12,"IfExpression","","",161],[12,"IfExpressionWithNoElse","","",161],[12,"RangeExpression","","",161],[12,"EquatePredicate","","",161],[2,"ValuePairs","","See `error_reporting.rs` for more details"],[12,"Types","","",162],[12,"TraitRefs","","",162],[12,"PolyTraitRefs","","",162],[1,"TypeTrace","","The trace designates the path through inference that we took to\nencounter an error or subtyping constraint."],[2,"SubregionOrigin","","The origin of a `r1 <= r2` constraint."],[12,"Subtype","","",164],[12,"InfStackClosure","","",164],[12,"InvokeClosure","","",164],[12,"DerefPointer","","",164],[12,"FreeVariable","","",164],[12,"IndexSlice","","",164],[12,"RelateObjectBound","","",164],[12,"RelateParamBound","","",164],[12,"RelateRegionParamBound","","",164],[12,"RelateDefaultParamBound","","",164],[12,"Reborrow","","",164],[12,"ReborrowUpvar","","",164],[12,"ReferenceOutlivesReferent","","",164],[12,"ExprTypeIsNotInScope","","",164],[12,"BindingTypeIsNotValidAtDecl","","",164],[12,"CallRcvr","","",164],[12,"CallArg","","",164],[12,"CallReturn","","",164],[12,"AddrOf","","",164],[12,"AutoBorrow","","",164],[2,"LateBoundRegionConversionTime","","Times when we replace late-bound regions with variables:"],[12,"FnCall","","when a fn is called",165],[12,"HigherRankedType","","when two higher-ranked types are compared",165],[12,"AssocTypeProjection","","when projecting an associated type",165],[2,"RegionVariableOrigin","","Reasons to create a region inference variable"],[12,"MiscVariable","","",166],[12,"PatternRegion","","",166],[12,"AddrOfRegion","","",166],[12,"AddrOfSlice","","",166],[12,"Autoref","","",166],[12,"Coercion","","",166],[12,"EarlyBoundRegion","","",166],[12,"LateBoundRegion","","",166],[12,"UpvarRegion","","",166],[12,"BoundRegionInCoherence","","",166],[2,"fixup_err","",""],[12,"unresolved_int_ty","","",167],[12,"unresolved_float_ty","","",167],[12,"unresolved_ty","","",167],[3,"fixup_err_to_string","",""],[3,"new_infer_ctxt","",""],[3,"common_supertype","","Computes the least upper-bound of `a` and `b`. If this is not possible, reports an error and\nreturns ty::err."],[3,"mk_subty","",""],[3,"can_mk_subty","",""],[3,"can_mk_eqty","",""],[3,"mk_subr","",""],[3,"verify_param_bound","",""],[3,"mk_eqty","",""],[3,"mk_sub_poly_trait_refs","",""],[3,"mk_coercety","",""],[3,"uok","",""],[1,"CombinedSnapshot","",""],[1,"TypeFreshener","",""],[2,"IntVarValue","",""],[12,"IntType","","",158],[12,"UintType","","",158],[0,"lang_items","rustc_trans::middle",""],[2,"LangItem","rustc_trans::middle::lang_items",""],[12,"SendTraitLangItem","","",169],[12,"SizedTraitLangItem","","",169],[12,"CopyTraitLangItem","","",169],[12,"SyncTraitLangItem","","",169],[12,"DropTraitLangItem","","",169],[12,"AddTraitLangItem","","",169],[12,"SubTraitLangItem","","",169],[12,"MulTraitLangItem","","",169],[12,"DivTraitLangItem","","",169],[12,"RemTraitLangItem","","",169],[12,"NegTraitLangItem","","",169],[12,"NotTraitLangItem","","",169],[12,"BitXorTraitLangItem","","",169],[12,"BitAndTraitLangItem","","",169],[12,"BitOrTraitLangItem","","",169],[12,"ShlTraitLangItem","","",169],[12,"ShrTraitLangItem","","",169],[12,"IndexTraitLangItem","","",169],[12,"IndexMutTraitLangItem","","",169],[12,"SliceTraitLangItem","","",169],[12,"SliceMutTraitLangItem","","",169],[12,"RangeStructLangItem","","",169],[12,"RangeFromStructLangItem","","",169],[12,"RangeToStructLangItem","","",169],[12,"FullRangeStructLangItem","","",169],[12,"UnsafeTypeLangItem","","",169],[12,"DerefTraitLangItem","","",169],[12,"DerefMutTraitLangItem","","",169],[12,"FnTraitLangItem","","",169],[12,"FnMutTraitLangItem","","",169],[12,"FnOnceTraitLangItem","","",169],[12,"EqTraitLangItem","","",169],[12,"OrdTraitLangItem","","",169],[12,"StrEqFnLangItem","","",169],[12,"PanicFnLangItem","","",169],[12,"PanicBoundsCheckFnLangItem","","",169],[12,"PanicFmtLangItem","","",169],[12,"ExchangeMallocFnLangItem","","",169],[12,"ExchangeFreeFnLangItem","","",169],[12,"StrDupUniqFnLangItem","","",169],[12,"StartFnLangItem","","",169],[12,"TyDescStructLangItem","","",169],[12,"OpaqueStructLangItem","","",169],[12,"TypeIdLangItem","","",169],[12,"EhPersonalityLangItem","","",169],[12,"ExchangeHeapLangItem","","",169],[12,"OwnedBoxLangItem","","",169],[12,"CovariantTypeItem","","",169],[12,"ContravariantTypeItem","","",169],[12,"InvariantTypeItem","","",169],[12,"CovariantLifetimeItem","","",169],[12,"ContravariantLifetimeItem","","",169],[12,"InvariantLifetimeItem","","",169],[12,"NoSendItem","","",169],[12,"NoCopyItem","","",169],[12,"NoSyncItem","","",169],[12,"ManagedItem","","",169],[12,"NonZeroItem","","",169],[12,"IteratorItem","","",169],[12,"StackExhaustedLangItem","","",169],[1,"LanguageItems","",""],[11,"items","","",170],[11,"missing","","",170],[3,"extract","",""],[3,"collect_language_items","",""],[0,"liveness","rustc_trans::middle","A classic liveness analysis based on dataflow over the AST.  Computes,\nfor each local variable in a function, whether that variable is live\nat a given point.  Program execution points are identified by their\nid."],[3,"check_crate","rustc_trans::middle::liveness",""],[0,"mem_categorization","rustc_trans::middle","# Categorization"],[2,"categorization","rustc_trans::middle::mem_categorization",""],[12,"cat_rvalue","","",180],[12,"cat_static_item","","",180],[12,"cat_upvar","","",180],[12,"cat_local","","",180],[12,"cat_deref","","",180],[12,"cat_interior","","",180],[12,"cat_downcast","","",180],[1,"Upvar","",""],[11,"id","","",181],[11,"kind","","",181],[11,"is_unboxed","","",181],[2,"PointerKind","",""],[12,"Unique","","",182],[12,"BorrowedPtr","","",182],[12,"Implicit","","",182],[12,"UnsafePtr","","",182],[2,"InteriorKind","",""],[12,"InteriorField","","",183],[12,"InteriorElement","","",183],[2,"FieldName","",""],[12,"NamedField","","",184],[12,"PositionalField","","",184],[2,"ElementKind","",""],[12,"VecElement","","",185],[12,"OtherElement","","",185],[2,"MutabilityCategory","",""],[12,"McImmutable","","",186],[12,"McDeclared","","",186],[12,"McInherited","","",186],[2,"Note","",""],[12,"NoteClosureEnv","","",187],[12,"NoteUpvarRef","","",187],[12,"NoteNone","","",187],[1,"cmt_","",""],[11,"id","","",188],[11,"span","","",188],[11,"cat","","",188],[11,"mutbl","","",188],[11,"ty","","",188],[11,"note","","",188],[4,"cmt","",""],[2,"deref_kind","",""],[12,"deref_ptr","","",437],[12,"deref_interior","","",437],[3,"opt_deref_kind","",""],[3,"deref_kind","",""],[6,"ast_node","",""],[9,"id","","",438],[9,"span","","",438],[1,"MemCategorizationContext","",""],[6,"Typer","","The `Typer` trait provides the interface for the mem-categorization\nmodule to the results of the type check. It can be used to query\nthe type assigned to an expression node, to inquire after adjustments,\nand so on."],[9,"tcx","","",439],[9,"node_ty","","",439],[9,"expr_ty_adjusted","","",439],[9,"node_method_ty","","",439],[9,"node_method_origin","","",439],[9,"adjustments","","",439],[9,"is_method_call","","",439],[9,"temporary_scope","","",439],[9,"upvar_borrow","","",439],[9,"capture_mode","","",439],[9,"unboxed_closures","","",439],[2,"InteriorSafety","",""],[12,"InteriorUnsafe","","",440],[12,"InteriorSafe","","",440],[2,"AliasableReason","",""],[12,"AliasableBorrowed","","",441],[12,"AliasableClosure","","",441],[12,"AliasableOther","","",441],[12,"AliasableStatic","","",441],[12,"AliasableStaticMut","","",441],[3,"ptr_sigil","",""],[0,"pat_util","rustc_trans::middle",""],[4,"PatIdMap","rustc_trans::middle::pat_util",""],[3,"pat_id_map","",""],[3,"pat_is_refutable","",""],[3,"pat_is_variant_or_struct","",""],[3,"pat_is_const","",""],[3,"pat_is_binding","",""],[3,"pat_is_binding_or_wild","",""],[3,"pat_bindings","","Call `it` on every \"binding\" in a pattern, e.g., on `a` in\n`match foo() { Some(a) => (), None => () }`"],[3,"pat_contains_bindings","","Checks if the pattern contains any patterns that bind something to\nan ident, e.g. `foo`, or `Foo(foo)` or `foo @ Bar(..)`."],[3,"simple_identifier","",""],[3,"def_to_path","",""],[0,"privacy","rustc_trans::middle","A pass that checks to make sure private fields and methods aren't used\noutside their scopes. This pass will also generate a set of exported items\nwhich are available for use externally when compiled as a library."],[4,"ExportedItems","rustc_trans::middle::privacy",""],[4,"ExternalExports","",""],[4,"PublicItems","",""],[4,"LastPrivateMap","",""],[2,"LastPrivate","",""],[12,"LastMod","","",192],[12,"LastImport","","",192],[11,"value_priv","rustc_trans::middle::privacy::LastPrivate","",192],[11,"value_used","","",192],[11,"type_priv","","",192],[11,"type_used","","",192],[2,"PrivateDep","rustc_trans::middle::privacy",""],[12,"AllPublic","","",193],[12,"DependsOn","","",193],[2,"ImportUse","",""],[12,"Unused","","",194],[12,"Used","","",194],[3,"check_crate","",""],[0,"reachable","rustc_trans::middle",""],[3,"find_reachable","rustc_trans::middle::reachable",""],[0,"region","rustc_trans::middle","This file actually contains two passes related to regions.  The first\npass builds up the `scope_map`, which describes the parent links in\nthe region hierarchy.  The second pass infers which types must be\nregion parameterized."],[2,"CodeExtent","rustc_trans::middle::region","CodeExtent represents a statically-describable extent that can be\nused to bound the lifetime/region for values."],[12,"Misc","","",59],[1,"RegionMaps","","The region maps encode information about region relationships."],[1,"Context","",""],[3,"resolve_crate","",""],[3,"resolve_inlined_item","",""],[0,"recursion_limit","rustc_trans::middle",""],[3,"update_recursion_limit","rustc_trans::middle::recursion_limit",""],[0,"resolve_lifetime","rustc_trans::middle","Name resolution for lifetimes."],[2,"DefRegion","rustc_trans::middle::resolve_lifetime",""],[12,"DefStaticRegion","","",204],[12,"DefEarlyBoundRegion","","",204],[12,"DefLateBoundRegion","","",204],[12,"DefFreeRegion","","",204],[4,"NamedRegionMap","",""],[3,"krate","",""],[3,"early_bound_lifetimes","",""],[0,"stability","rustc_trans::middle","A pass that annotates every item and method with its stability level,\npropagating default levels lexically from parent to children ast nodes."],[1,"Index","rustc_trans::middle::stability","A stability index, giving the stability level for items and methods."],[3,"lookup","","Lookup the stability for a node, loading external crate\nmetadata as necessary."],[0,"subst","rustc_trans::middle",""],[1,"Substs","rustc_trans::middle::subst","A substitution mapping type/region parameters to new values. We\nidentify each in-scope parameter by an *index* and a *parameter\nspace* (which indices where the parameter is defined; see\n`ParamSpace`)."],[11,"types","","",209],[11,"regions","","",209],[2,"RegionSubsts","","Represents the values to use when substituting lifetime parameters.\nIf the value is `ErasedRegions`, then this subst is occurring during\ntrans, and all region parameters will be replaced with `ty::ReStatic`."],[12,"ErasedRegions","","",210],[12,"NonerasedRegions","","",210],[2,"ParamSpace","",""],[12,"TypeSpace","","",211],[12,"SelfSpace","","",211],[12,"FnSpace","","",211],[1,"VecPerParamSpace","","Vector of things sorted by param space. Used to keep\nthe set of things declared on the type, self, or method\ndistinct."],[1,"SeparateVecsPerParamSpace","","The `split` function converts one `VecPerParamSpace` into this\n`SeparateVecsPerParamSpace` structure."],[11,"types","","",442],[11,"selfs","","",442],[11,"fns","","",442],[1,"EnumeratedItems","",""],[6,"Subst","",""],[9,"subst","","",443],[9,"subst_spanned","","",443],[0,"traits","rustc_trans::middle","Trait Resolution. See doc.rs."],[1,"Obligation","rustc_trans::middle::traits","An `Obligation` represents some trait reference (e.g. `int:Eq`) for\nwhich the vtable must be found.  The process of finding a vtable is\ncalled \"resolving\" the `Obligation`. This process consists of\neither identifying an `impl` (e.g., `impl Eq for int`) that\nprovides the required vtable, or else finding a bound that is in\nscope. The eventual result is usually a `Selection` (defined below)."],[11,"cause","","",231],[11,"recursion_depth","","",231],[11,"predicate","","",231],[4,"PredicateObligation","",""],[4,"TraitObligation","",""],[1,"ObligationCause","","Why did we incur this obligation? Used for error reporting."],[11,"span","","",237],[11,"body_id","","",237],[11,"code","","",237],[2,"ObligationCauseCode","",""],[12,"MiscObligation","","Not well classified or should be obvious from span.",238],[12,"ItemObligation","","In an impl of trait X for type Y, type Y must\nalso implement all supertraits of X.",238],[12,"ObjectCastObligation","","Obligation incurred due to an object cast.",238],[12,"AssignmentLhsSized","","Various cases where expressions must be sized/copy/etc:",238],[12,"StructInitializerSized","","",238],[12,"VariableType","","",238],[12,"ReturnType","","",238],[12,"RepeatVec","","",238],[12,"ClosureCapture","","",238],[12,"FieldSized","","",238],[12,"ObjectSized","","",238],[12,"SharedStatic","","",238],[12,"BuiltinDerivedObligation","","",238],[12,"ImplDerivedObligation","","",238],[1,"DerivedObligationCause","",""],[4,"Obligations","",""],[4,"PredicateObligations","",""],[4,"TraitObligations","",""],[4,"Selection","",""],[2,"SelectionError","",""],[12,"Unimplemented","","",234],[12,"Overflow","","",234],[12,"OutputTypeParameterMismatch","","",234],[1,"FulfillmentError","",""],[11,"obligation","","",235],[11,"code","","",235],[2,"FulfillmentErrorCode","",""],[12,"CodeSelectionError","","",236],[12,"CodeProjectionError","","",236],[12,"CodeAmbiguity","","",236],[4,"SelectionResult","",""],[2,"Vtable","","Given the successful resolution of an obligation, the `Vtable`\nindicates where the vtable comes from. Note that while we call this\na \"vtable\", it does not necessarily indicate dynamic dispatch at\nruntime. `Vtable` instances just tell the compiler where to find\nmethods, but in generic code those methods are typically statically\ndispatched -- only when an object is constructed is a `Vtable`\ninstance reified into an actual vtable."],[12,"VtableImpl","","Vtable identifying a particular impl.",232],[12,"VtableParam","","Successful resolution to an obligation provided by the caller\nfor some type parameter.",232],[12,"VtableBuiltin","","Successful resolution for a builtin trait.",232],[12,"VtableUnboxedClosure","","Vtable automatically generated for an unboxed closure. The def\nID is the ID of the closure expression. This is a `VtableImpl`\nin spirit, but the impl is generated by the compiler and does\nnot appear in the source.",232],[12,"VtableFnPointer","","Same as above, but for a fn pointer type with the given signature.",232],[1,"VtableImplData","","Identifies a particular impl in the source, along with a set of\nsubstitutions from the impl's type/lifetime parameters. The\n`nested` vector corresponds to the nested obligations attached to\nthe impl's type parameters."],[11,"impl_def_id","","",230],[11,"substs","","",230],[11,"nested","","",230],[1,"VtableBuiltinData","",""],[11,"nested","","",233],[3,"is_orphan_impl","","True if neither the trait nor self type is local. Note that `impl_def_id` must refer to an impl\nof a trait, not an inherent impl."],[3,"overlapping_impls","","True if there exist types that satisfy both of the two given impls."],[3,"predicates_for_generics","","Creates predicate obligations from the generic bounds."],[3,"type_known_to_meet_builtin_bound","","Determines whether the type `ty` is known to meet `bound` and\nreturns true if so. Returns false if `ty` either does not meet\n`bound` or is not known to meet bound (note that this is\nconservative towards *no impl*, which is the opposite of the\n`evaluate` methods)."],[3,"trait_ref_for_builtin_bound","",""],[1,"Normalized","",""],[11,"value","","",444],[11,"obligations","","",444],[1,"MismatchedProjectionTypes","",""],[11,"err","","",217],[3,"normalize","",""],[3,"supertraits","",""],[3,"report_fulfillment_errors","",""],[2,"MethodMatchedData","",""],[12,"PreciseMethodMatch","","",222],[12,"CoerciveMethodMatch","","",222],[2,"MethodMatchResult","",""],[12,"MethodMatched","","",227],[12,"MethodAmbiguous","","",227],[12,"MethodDidNotMatch","","",227],[3,"transitive_bounds","",""],[1,"RegionObligation","",""],[11,"sub_region","","",216],[11,"sup_type","","",216],[11,"cause","","",216],[1,"SelectionContext","",""],[1,"Supertraits","","A filter around the `Elaborator` that just yields up supertrait references,\nnot other kinds of predicates."],[3,"elaborate_predicates","",""],[1,"SelectionCache","",""],[1,"FulfillmentContext","","The fulfillment context is used to drive trait resolution.  It\nconsists of a list of obligations that must be (eventually)\nsatisfied. The job is to track which are satisfied, which yielded\nerrors, and which are still pending. At any point, users can call\n`select_where_possible`, and the fulfilment context will try to do\nselection, retaining only those obligations that remain\nambiguous. This may be helpful in pushing type inference\nalong. Once all type inference constraints have been generated, the\nmethod `select_all_or_error` can be used to report any remaining\nambiguous cases as errors."],[0,"ty","rustc_trans::middle",""],[4,"Disr","rustc_trans::middle::ty",""],[18,"INITIAL_DISCRIMINANT_VALUE","",""],[1,"CrateAnalysis","","The complete set of all analyses described in this module. This is\nproduced by the driver and fed to trans and later passes."],[11,"export_map","","",445],[11,"exported_items","","",445],[11,"public_items","","",445],[11,"ty_cx","","",445],[11,"reachable","","",445],[11,"name","","",445],[11,"glob_map","","",445],[1,"field","",""],[11,"name","","",240],[11,"mt","","",240],[2,"ImplOrTraitItemContainer","",""],[12,"TraitContainer","","",241],[12,"ImplContainer","","",241],[2,"ImplOrTraitItem","",""],[12,"MethodTraitItem","","",242],[12,"TypeTraitItem","","",242],[2,"ImplOrTraitItemId","",""],[12,"MethodTraitItemId","","",243],[12,"TypeTraitItemId","","",243],[1,"Method","",""],[11,"name","","",244],[11,"generics","","",244],[11,"fty","","",244],[11,"explicit_self","","",244],[11,"vis","","",244],[11,"def_id","","",244],[11,"container","","",244],[11,"provided_source","","",244],[1,"AssociatedType","",""],[11,"name","","",245],[11,"vis","","",245],[11,"def_id","","",245],[11,"container","","",245],[1,"mt","",""],[11,"ty","","",246],[11,"mutbl","","",246],[2,"TraitStore","",""],[12,"UniqTraitStore","","Box<Trait>",61],[12,"RegionTraitStore","","&Trait and &mut Trait",61],[1,"field_ty","",""],[11,"name","","",247],[11,"id","","",247],[11,"vis","","",247],[11,"origin","","",247],[1,"creader_cache_key","",""],[11,"cnum","","",248],[11,"pos","","",248],[11,"len","","",248],[2,"ast_ty_to_ty_cache_entry","",""],[12,"atttce_unresolved","","",446],[12,"atttce_resolved","","",446],[1,"ItemVariances","",""],[11,"types","","",249],[11,"regions","","",249],[2,"Variance","",""],[12,"Covariant","","",250],[12,"Invariant","","",250],[12,"Contravariant","","",250],[12,"Bivariant","","",250],[2,"AutoAdjustment","",""],[12,"AdjustAddEnv","","",251],[12,"AdjustReifyFnPointer","","",251],[12,"AdjustDerefRef","","",251],[2,"UnsizeKind","",""],[12,"UnsizeLength","","",252],[12,"UnsizeStruct","","",252],[12,"UnsizeVtable","","",252],[1,"AutoDerefRef","",""],[11,"autoderefs","","",253],[11,"autoref","","",253],[2,"AutoRef","",""],[12,"AutoPtr","","Convert from T to &T\nThe third field allows us to wrap other AutoRef adjustments.",254],[12,"AutoUnsize","","Convert [T, ..n] to [T] (or similar, depending on the kind)",254],[12,"AutoUnsizeUniq","","Convert Box<[T, ..n]> to Box<[T]> or something similar in a Box.\nWith DST and Box a library type, this should be replaced by UnsizeStruct.",254],[12,"AutoUnsafe","","Convert from T to *T\nValue to thin pointer\nThe second field allows us to wrap other AutoRef adjustments.",254],[3,"adjusted_object_region","",""],[3,"adjust_is_object","",""],[3,"type_of_adjust","",""],[1,"param_index","",""],[11,"space","","",255],[11,"index","","",255],[2,"MethodOrigin","",""],[12,"MethodStatic","","",65],[12,"MethodStaticUnboxedClosure","","",65],[12,"MethodTypeParam","","",65],[12,"MethodTraitObject","","",65],[1,"MethodParam","",""],[11,"trait_ref","","",256],[11,"method_num","","",256],[1,"MethodObject","",""],[11,"trait_ref","","",257],[11,"object_trait_id","","",257],[11,"method_num","","",257],[11,"real_index","","",257],[1,"MethodCallee","",""],[11,"origin","","",258],[11,"ty","","",258],[11,"substs","","",258],[1,"MethodCall","","With method calls, we store some extra information in\nside tables (i.e method_map). We use\nMethodCall as a key to index into these tables instead of\njust directly using the expression's NodeId. The reason\nfor this being that we may apply adjustments (coercions)\nwith the resulting expression also needing to use the\nside tables. The problem with this is that we don't\nassign a separate NodeId to this new expression\nand so it would clash with the base expression if both\nneeded to add to the side tables. Thus to disambiguate\nwe also keep track of whether there's an adjustment in\nour key."],[11,"expr_id","","",259],[11,"adjustment","","",259],[2,"ExprAdjustment","",""],[12,"NoAdjustment","","",260],[12,"AutoDeref","","",260],[12,"AutoObject","","",260],[4,"MethodMap","",""],[4,"vtable_param_res","",""],[4,"vtable_res","",""],[2,"vtable_origin","",""],[12,"vtable_static","","",261],[12,"vtable_param","","",261],[12,"vtable_unboxed_closure","","",261],[12,"vtable_error","","",261],[4,"ObjectCastMap","",""],[1,"TransmuteRestriction","","A restriction that certain types must be the same size. The use of\n`transmute` gives rise to these restrictions. These generally\ncannot be checked until trans; therefore, each call to `transmute`\nwill push one or more such restriction into the\n`transmute_restrictions` vector during `intrinsicck`. They are\nthen checked during `trans` by the fn `check_intrinsics`."],[11,"span","","The span whence the restriction comes.",120],[11,"original_from","","The type being transmuted from.",120],[11,"original_to","","The type being transmuted to.",120],[11,"substituted_from","","The type being transmuted from, with all type parameters\nsubstituted for an arbitrary representative. Not to be shown\nto the end user.",120],[11,"substituted_to","","The type being transmuted to, with all type parameters\nsubstituted for an arbitrary representative. Not to be shown\nto the end user.",120],[11,"id","","NodeId of the transmute intrinsic.",120],[1,"CtxtArenas","","Internal storage"],[1,"CommonTypes","",""],[11,"bool","","",447],[11,"char","","",447],[11,"int","","",447],[11,"i8","","",447],[11,"i16","","",447],[11,"i32","","",447],[11,"i64","","",447],[11,"uint","","",447],[11,"u8","","",447],[11,"u16","","",447],[11,"u32","","",447],[11,"u64","","",447],[11,"f32","","",447],[11,"f64","","",447],[11,"err","","",447],[1,"ctxt","","The data structure to keep track of all the information that typechecker\ngenerates so that so that it can be reused and doesn't have to be redone\nlater on."],[11,"types","","Common types, pre-interned for your convenience.",264],[11,"sess","","",264],[11,"def_map","","",264],[11,"named_region_map","","",264],[11,"region_maps","","",264],[11,"node_types","","Stores the types for various nodes in the AST.  Note that this table\nis not guaranteed to be populated until after typeck.  See\ntypeck::check::fn_ctxt for details.",264],[11,"item_substs","","Stores the type parameters which were substituted to obtain the type\nof this node.  This only applies to nodes that refer to entities\nparameterized by type parameters, such as generic fns, types, or\nother items.",264],[11,"impl_or_trait_items","","Maps from a trait item to the trait item \"descriptor\"",264],[11,"trait_item_def_ids","","Maps from a trait def-id to a list of the def-ids of its trait items",264],[11,"trait_items_cache","","A cache for the trait_items() routine",264],[11,"impl_trait_cache","","",264],[11,"trait_refs","","",264],[11,"trait_defs","","",264],[11,"object_cast_map","","Maps from node-id of a trait object cast (like `foo as\nBox<Trait>`) to the trait reference.",264],[11,"map","","",264],[11,"intrinsic_defs","","",264],[11,"freevars","","",264],[11,"tcache","","",264],[11,"rcache","","",264],[11,"short_names_cache","","",264],[11,"tc_cache","","",264],[11,"ast_ty_to_ty_cache","","",264],[11,"enum_var_cache","","",264],[11,"ty_param_defs","","",264],[11,"adjustments","","",264],[11,"normalized_cache","","",264],[11,"lang_items","","",264],[11,"provided_method_sources","","A mapping of fake provided method def_ids to the default implementation",264],[11,"struct_fields","","",264],[11,"item_variance_map","","Maps from def-id of a type or region parameter to its\n(inferred) variance.",264],[11,"variance_computed","","True if the variance has been computed yet; false otherwise.",264],[11,"destructor_for_type","","A mapping from the def ID of an enum or struct type to the def ID\nof the method that implements its destructor. If the type is not\npresent in this map, it does not have a destructor. This map is\npopulated during the coherence phase of typechecking.",264],[11,"destructors","","A method will be in this list if and only if it is a destructor.",264],[11,"trait_impls","","Maps a trait onto a list of impls of that trait.",264],[11,"inherent_impls","","Maps a DefId of a type to a list of its inherent impls.\nContains implementations of methods that are inherent to a type.\nMethods in these implementations don't need to be exported.",264],[11,"impl_items","","Maps a DefId of an impl to a list of its items.\nNote that this contains all of the impls that we know about,\nincluding ones in other crates. It's not clear that this is the best\nway to do it.",264],[11,"used_unsafe","","Set of used unsafe nodes (functions or blocks). Unsafe nodes not\npresent in this set can be warned about.",264],[11,"used_mut_nodes","","Set of nodes which mark locals as mutable which end up getting used at\nsome point. Local variable definitions not in this set can be warned\nabout.",264],[11,"populated_external_types","","The set of external nominal types whose implementations have been read.\nThis is used for lazy resolution of methods.",264],[11,"populated_external_traits","","The set of external traits whose implementations have been read. This\nis used for lazy resolution of traits.",264],[11,"upvar_borrow_map","","Borrows",264],[11,"extern_const_statics","","These two caches are used by const_eval when decoding external statics\nand variants that are found.",264],[11,"extern_const_variants","","",264],[11,"method_map","","",264],[11,"dependency_formats","","",264],[11,"unboxed_closures","","Records the type of each unboxed closure. The def ID is the ID of the\nexpression defining the unboxed closure.",264],[11,"node_lint_levels","","",264],[11,"transmute_restrictions","","The types that must be asserted to be the same size for `transmute`\nto be valid. We gather up these restrictions in the intrinsicck pass\nand check them in trans.",264],[11,"stability","","Maps any item's def-id to its stability index.",264],[11,"capture_modes","","Maps closures to their capture clauses.",264],[11,"associated_types","","Maps def IDs to true if and only if they're associated types.",264],[11,"selection_cache","","Caches the results of trait selection. This cache is used\nfor things that do not have to do with the parameters in scope.",264],[11,"repr_hint_cache","","Caches the representation hints for struct definitions.",264],[11,"type_impls_copy_cache","","Caches whether types are known to impl Copy. Note that type\nparameters are never placed into this cache, because their\nresults are dependent on the parameter environment.",264],[11,"type_impls_sized_cache","","Caches whether types are known to impl Sized. Note that type\nparameters are never placed into this cache, because their\nresults are dependent on the parameter environment.",264],[1,"TypeFlags","",""],[18,"NO_TYPE_FLAGS","",""],[18,"HAS_PARAMS","",""],[18,"HAS_SELF","",""],[18,"HAS_TY_INFER","",""],[18,"HAS_RE_INFER","",""],[18,"HAS_RE_LATE_BOUND","",""],[18,"HAS_REGIONS","",""],[18,"HAS_TY_ERR","",""],[18,"HAS_PROJECTION","",""],[18,"NEEDS_SUBST","",""],[1,"TyS","",""],[11,"sty","","",265],[11,"flags","","",265],[4,"Ty","",""],[1,"InternedTy","","An entry in the type interner."],[3,"type_has_params","",""],[3,"type_has_self","",""],[3,"type_has_ty_infer","",""],[3,"type_needs_infer","",""],[3,"type_has_projection","",""],[3,"type_has_late_bound_regions","",""],[3,"type_has_escaping_regions","","An \"escaping region\" is a bound region whose binder is not part of `t`."],[3,"type_escapes_depth","",""],[1,"BareFnTy","",""],[11,"unsafety","","",268],[11,"abi","","",268],[11,"sig","","",268],[1,"ClosureTy","",""],[11,"unsafety","","",269],[11,"onceness","","",269],[11,"store","","",269],[11,"bounds","","",269],[11,"sig","","",269],[11,"abi","","",269],[2,"FnOutput","",""],[12,"FnConverging","","",270],[12,"FnDiverging","","",270],[1,"FnSig","","Signature of a function type, which I have arbitrarily\ndecided to use to refer to the input/output types."],[11,"inputs","","",125],[11,"output","","",125],[11,"variadic","","",125],[4,"PolyFnSig","",""],[1,"ParamTy","",""],[11,"space","","",271],[11,"idx","","",271],[11,"name","","",271],[1,"DebruijnIndex","","A [De Bruijn index][dbi] is a standard means of representing\nregions (and perhaps later types) in a higher-ranked setting. In\nparticular, imagine a type like this:"],[11,"depth","","",272],[2,"Region","","Representation of regions:"],[12,"ReEarlyBound","","",57],[12,"ReLateBound","","",57],[12,"ReFree","","When checking a function body, the types of all arguments and so forth\nthat refer to bound region parameters are modified to refer to free\nregion parameters.",57],[12,"ReScope","","A concrete region naming some expression within the current function.",57],[12,"ReStatic","","Static data that has an \"infinite\" lifetime. Top in the region lattice.",57],[12,"ReInfer","","A region variable.  Should not exist after typeck.",57],[12,"ReEmpty","","Empty lifetime is for data that is never accessed.\nBottom in the region lattice. We treat ReEmpty somewhat\nspecially; at least right now, we do not generate instances of\nit during the GLB computations, but rather\ngenerate an error instead. This is to improve error messages.\nThe only way to get an instance of ReEmpty is to have a region\nvariable with no constraints.",57],[1,"UpvarId","","Upvars do not get their own node-id. Instead, we use the pair of\nthe original var id (that is, the root variable that is referenced\nby the upvar) and the id of the closure expression."],[11,"var_id","","",273],[11,"closure_expr_id","","",273],[2,"BorrowKind","",""],[12,"ImmBorrow","","Data must be immutable and is aliasable.",274],[12,"UniqueImmBorrow","","Data must be immutable but not aliasable.  This kind of borrow\ncannot currently be expressed by the user and is used only in\nimplicit closure bindings. It is needed when you the closure\nis borrowing or mutating a mutable referent, e.g.:",274],[12,"MutBorrow","","Data is mutable and not aliasable.",274],[1,"UpvarBorrow","","Information describing the borrowing of an upvar. This is computed\nduring `typeck`, specifically by `regionck`. The general idea is\nthat the compiler analyses treat closures like:"],[11,"kind","","",64],[11,"region","","",64],[4,"UpvarBorrowMap","",""],[1,"FreeRegion","","A \"free\" region `fr` can be interpreted as \"some region\nat least as big as the scope `fr.scope`\"."],[11,"scope","","",58],[11,"bound_region","","",58],[2,"BoundRegion","",""],[12,"BrAnon","","An anonymous region parameter for a given fn (&T)",60],[12,"BrNamed","","Named region parameters for functions (a in &'a T)",60],[12,"BrFresh","","Fresh bound identifiers created during GLB computations.",60],[12,"BrEnv","","",60],[2,"sty","",""],[12,"ty_bool","","",267],[12,"ty_char","","",267],[12,"ty_int","","",267],[12,"ty_uint","","",267],[12,"ty_float","","",267],[12,"ty_enum","","Substs here, possibly against intuition, *may* contain `ty_param`s.\nThat is, even after substitution it is possible that there are type\nvariables. This happens when the `ty_enum` corresponds to an enum\ndefinition and not a concrete use of it. To get the correct `ty_enum`\nfrom the tcx, use the `NodeId` from the `ast::Ty` and look it up in\nthe `ast_ty_to_ty_cache`. This is probably true for `ty_struct` as\nwell.`",267],[12,"ty_uniq","","",267],[12,"ty_str","","",267],[12,"ty_vec","","",267],[12,"ty_ptr","","",267],[12,"ty_rptr","","",267],[12,"ty_bare_fn","","",267],[12,"ty_closure","","",267],[12,"ty_trait","","",267],[12,"ty_struct","","",267],[12,"ty_unboxed_closure","","",267],[12,"ty_tup","","",267],[12,"ty_projection","","",267],[12,"ty_param","","",267],[12,"ty_open","","",267],[12,"ty_infer","","",267],[12,"ty_err","","",267],[1,"TyTrait","",""],[11,"principal","","",275],[11,"bounds","","",275],[1,"TraitRef","","A complete reference to a trait. These take numerous guises in syntax,\nbut perhaps the most recognizable form is in a where clause:"],[11,"def_id","","",123],[11,"substs","","",123],[4,"PolyTraitRef","",""],[1,"Binder","","Binder is a binder for higher-ranked lifetimes. It is part of the\ncompiler's representation for things like `for<'a> Fn(&'a int)`\n(which would be represented by the type `PolyTraitRef ==\nBinder<TraitRef>`). Note that when we skolemize, instantiate,\nerase, or otherwise \"discharge\" these bound reons, we change the\ntype from `Binder<T>` to just `T` (see\ne.g. `liberate_late_bound_regions`)."],[2,"IntVarValue","",""],[12,"IntType","","",158],[12,"UintType","","",158],[2,"terr_vstore_kind","",""],[12,"terr_vec","","",276],[12,"terr_str","","",276],[12,"terr_fn","","",276],[12,"terr_trait","","",276],[1,"expected_found","",""],[11,"expected","","",277],[11,"found","","",277],[2,"type_err","",""],[12,"terr_mismatch","","",278],[12,"terr_unsafety_mismatch","","",278],[12,"terr_onceness_mismatch","","",278],[12,"terr_abi_mismatch","","",278],[12,"terr_mutability","","",278],[12,"terr_sigil_mismatch","","",278],[12,"terr_box_mutability","","",278],[12,"terr_ptr_mutability","","",278],[12,"terr_ref_mutability","","",278],[12,"terr_vec_mutability","","",278],[12,"terr_tuple_size","","",278],[12,"terr_fixed_array_size","","",278],[12,"terr_ty_param_size","","",278],[12,"terr_arg_count","","",278],[12,"terr_regions_does_not_outlive","","",278],[12,"terr_regions_not_same","","",278],[12,"terr_regions_no_overlap","","",278],[12,"terr_regions_insufficiently_polymorphic","","",278],[12,"terr_regions_overly_polymorphic","","",278],[12,"terr_trait_stores_differ","","",278],[12,"terr_sorts","","",278],[12,"terr_integer_as_char","","",278],[12,"terr_int_mismatch","","",278],[12,"terr_float_mismatch","","",278],[12,"terr_traits","","",278],[12,"terr_builtin_bounds","","",278],[12,"terr_variadic_mismatch","","",278],[12,"terr_cyclic_ty","","",278],[12,"terr_convergence_mismatch","","",278],[12,"terr_projection_name_mismatched","","",278],[12,"terr_projection_bounds_length","","",278],[1,"ParamBounds","","Bounds suitable for a named type parameter like `A` in `fn foo<A>`\nas well as the existential type parameter in an object type."],[11,"region_bounds","","",279],[11,"builtin_bounds","","",279],[11,"trait_bounds","","",279],[11,"projection_bounds","","",279],[1,"ExistentialBounds","","Bounds suitable for an existentially quantified type parameter\nsuch as those that appear in object types or closure types. The\nmajor difference between this case and `ParamBounds` is that\ngeneral purpose trait bounds are omitted and there must be\n*exactly one* region."],[11,"region_bound","","",280],[11,"builtin_bounds","","",280],[11,"projection_bounds","","",280],[4,"BuiltinBounds","",""],[2,"BuiltinBound","",""],[12,"BoundSend","","",281],[12,"BoundSized","","",281],[12,"BoundCopy","","",281],[12,"BoundSync","","",281],[3,"empty_builtin_bounds","",""],[3,"all_builtin_bounds","",""],[3,"region_existential_bound","","An existential bound that does not implement any traits."],[1,"TyVid","",""],[11,"index","","",282],[1,"IntVid","",""],[11,"index","","",157],[1,"FloatVid","",""],[11,"index","","",159],[1,"RegionVid","",""],[11,"index","","",283],[2,"InferTy","",""],[12,"TyVar","","",284],[12,"IntVar","","",284],[12,"FloatVar","","",284],[12,"FreshTy","","A `FreshTy` is one that is generated as a replacement for an\nunbound type variable. This is convenient for caching etc. See\n`middle::infer::freshen` for more details.",284],[12,"FreshIntTy","","",284],[2,"InferRegion","",""],[12,"ReVar","","",285],[12,"ReSkolemized","","",285],[1,"TypeParameterDef","",""],[11,"name","","",286],[11,"def_id","","",286],[11,"space","","",286],[11,"index","","",286],[11,"bounds","","",286],[11,"default","","",286],[1,"RegionParameterDef","",""],[11,"name","","",287],[11,"def_id","","",287],[11,"space","","",287],[11,"index","","",287],[11,"bounds","","",287],[1,"Generics","","Information about the formal type/lifetime parameters associated\nwith an item or method. Analogous to ast::Generics."],[11,"types","","",288],[11,"regions","","",288],[11,"predicates","","",288],[2,"Predicate","",""],[12,"Trait","","Corresponds to `where Foo : Bar<A,B,C>`. `Foo` here would be\nthe `Self` type of the trait reference and `A`, `B`, and `C`\nwould be the parameters in the `TypeSpace`.",289],[12,"Equate","","where `T1 == T2`.",289],[12,"RegionOutlives","","where 'a : 'b",289],[12,"TypeOutlives","","where T : 'a",289],[12,"Projection","","where <T as TraitRef>::Name == X, approximately.\nSee `ProjectionPredicate` struct for details.",289],[1,"TraitPredicate","",""],[11,"trait_ref","","",290],[4,"PolyTraitPredicate","",""],[1,"EquatePredicate","",""],[4,"PolyEquatePredicate","",""],[1,"OutlivesPredicate","",""],[4,"PolyOutlivesPredicate","",""],[4,"PolyRegionOutlivesPredicate","",""],[4,"PolyTypeOutlivesPredicate","",""],[1,"ProjectionPredicate","","This kind of predicate has no *direct* correspondent in the\nsyntax, but it roughly corresponds to the syntactic forms:"],[11,"projection_ty","","",124],[11,"ty","","",124],[4,"PolyProjectionPredicate","",""],[1,"ProjectionTy","","Represents the projection of an associated type. In explicit UFCS\nform this would be written `<T as Trait<..>>::N`."],[11,"trait_ref","","The trait reference `T as Trait<..>`.",293],[11,"item_name","","The name `N` of the associated type.",293],[6,"ToPolyTraitRef","",""],[9,"to_poly_trait_ref","","",448],[6,"AsPredicate","",""],[9,"as_predicate","","",449],[1,"GenericBounds","","Represents the bounds declared on a particular set of type\nparameters.  Should eventually be generalized into a flag list of\nwhere clauses.  You can obtain a `GenericBounds` list from a\n`Generics` by using the `to_bounds` method. Note that this method\nreflects an important semantic invariant of `GenericBounds`: while\nthe bounds in a `Generics` are expressed in terms of the bound type\nparameters of the impl/trait/whatever, a `GenericBounds` instance\nrepresented a set of bounds for some particular instantiation,\nmeaning that the generic parameters have been substituted with\ntheir values."],[11,"predicates","","",294],[1,"ParameterEnvironment","","When type checking, we use the `ParameterEnvironment` to track\ndetails about the type/lifetime parameters that are in scope.\nIt primarily stores the bounds information."],[11,"free_substs","","A substitution that can be applied to move from\nthe \"outer\" view of a type or method to the \"inner\" view.\nIn general, this means converting from bound parameters to\nfree parameters. Since we currently represent bound/free type\nparameters in the same way, this only has an effect on regions.",295],[11,"implicit_region_bound","","Each type parameter has an implicit region bound that\nindicates it must outlive at least the function body (the user\nmay specify stronger requirements). This field indicates the\nregion of the callee.",295],[11,"caller_bounds","","Obligations that the caller must satisfy. This is basically\nthe set of bounds on the in-scope type parameters, translated\ninto Obligations.",295],[11,"selection_cache","","Caches the results of trait selection. This cache is used\nfor things that have to do with the parameters in scope.",295],[1,"TypeScheme","","A \"type scheme\", in ML terminology, is a type combined with some\nset of generic types that the type is, well, generic over. In Rust\nterms, it is the \"type\" of a fn item or struct -- this type will\ninclude various generic parameters that must be substituted when\nthe item/struct is referenced. That is called converting the type\nscheme to a monotype."],[11,"generics","","",296],[11,"ty","","",296],[1,"TraitDef","","As `TypeScheme` but for a trait ref."],[11,"unsafety","","",392],[11,"generics","","Generic type definitions. Note that `Self` is listed in here\nas having a single bound, the trait itself (e.g., in the trait\n`Eq`, there is a single bound `Self : Eq`). This is so that\ndefault methods get to assume that the `Self` parameters\nimplements the trait.",392],[11,"bounds","","The \"supertrait\" bounds.",392],[11,"trait_ref","","",392],[11,"associated_type_names","","A list of the associated types defined in this trait. Useful\nfor resolving `X::Foo` type markers.",392],[1,"ItemSubsts","","Records the substitutions used to translate the polytype for an\nitem into the monotype of an item reference."],[11,"substs","","",297],[1,"UnboxedClosure","","Records information about each unboxed closure."],[11,"closure_type","","The type of the unboxed closure.",298],[11,"kind","","The kind of unboxed closure this is.",298],[2,"UnboxedClosureKind","",""],[12,"FnUnboxedClosureKind","","",299],[12,"FnMutUnboxedClosureKind","","",299],[12,"FnOnceUnboxedClosureKind","","",299],[3,"mk_ctxt","",""],[3,"mk_t","",""],[3,"mk_mach_int","",""],[3,"mk_mach_uint","",""],[3,"mk_mach_float","",""],[3,"mk_str","",""],[3,"mk_str_slice","",""],[3,"mk_enum","",""],[3,"mk_uniq","",""],[3,"mk_ptr","",""],[3,"mk_rptr","",""],[3,"mk_mut_rptr","",""],[3,"mk_imm_rptr","",""],[3,"mk_mut_ptr","",""],[3,"mk_imm_ptr","",""],[3,"mk_nil_ptr","",""],[3,"mk_vec","",""],[3,"mk_slice","",""],[3,"mk_tup","",""],[3,"mk_nil","",""],[3,"mk_closure","",""],[3,"mk_bare_fn","",""],[3,"mk_ctor_fn","",""],[3,"mk_trait","",""],[3,"sort_bounds_list","",""],[3,"mk_projection","",""],[3,"mk_struct","",""],[3,"mk_unboxed_closure","",""],[3,"mk_var","",""],[3,"mk_int_var","",""],[3,"mk_float_var","",""],[3,"mk_infer","",""],[3,"mk_param","",""],[3,"mk_self_type","",""],[3,"mk_param_from_def","",""],[3,"mk_open","",""],[3,"walk_ty","",""],[3,"maybe_walk_ty","",""],[3,"fold_ty","",""],[3,"type_is_nil","",""],[3,"type_is_error","",""],[3,"type_needs_subst","",""],[3,"trait_ref_contains_error","",""],[3,"type_is_ty_var","",""],[3,"type_is_bool","",""],[3,"type_is_self","",""],[3,"type_is_vec","",""],[3,"type_is_structural","",""],[3,"type_is_simd","",""],[3,"sequence_element_type","",""],[3,"simd_type","",""],[3,"simd_size","",""],[3,"type_is_region_ptr","",""],[3,"type_is_unsafe_ptr","",""],[3,"type_is_unique","",""],[3,"type_is_scalar","",""],[3,"type_is_floating_point","","Returns true if this type is a floating point type and false otherwise."],[1,"TypeContents","","Type contents is how the type checker reasons about kinds.\nThey track what kinds of things are found within a type.  You can\nthink of them as kind of an \"anti-kind\".  They track the kinds of values\nand thinks that are contained in types.  Having a larger contents for\na type tends to rule that type *out* from various kinds.  For example,\na type that contains a reference is not sendable."],[11,"bits","","",300],[3,"type_interior_is_unsafe","",""],[3,"type_contents","",""],[3,"type_moves_by_default","",""],[3,"type_is_sized","",""],[3,"is_ffi_safe","",""],[3,"is_instantiable","",""],[2,"Representability","","Describes whether a type is representable. For types that are not\nrepresentable, 'SelfRecursive' and 'ContainsRecursive' are used to\ndistinguish between types that are recursive with themselves and types that\ncontain a different recursive type. These cases can therefore be treated\ndifferently when reporting errors."],[12,"Representable","","",301],[12,"ContainsRecursive","","",301],[12,"SelfRecursive","","",301],[3,"is_type_representable","","Check whether a type is representable. This means it cannot contain unboxed\nstructural recursion. This check is needed for structs and enums."],[3,"type_is_trait","",""],[3,"type_trait_info","",""],[3,"type_is_integral","",""],[3,"type_is_fresh","",""],[3,"type_is_uint","",""],[3,"type_is_char","",""],[3,"type_is_bare_fn","",""],[3,"type_is_bare_fn_item","",""],[3,"type_is_fp","",""],[3,"type_is_numeric","",""],[3,"type_is_signed","",""],[3,"type_is_machine","",""],[3,"type_is_c_like_enum","",""],[3,"deref","",""],[3,"close_type","",""],[3,"type_content","",""],[3,"unopen_type","",""],[3,"index","",""],[3,"array_element_ty","",""],[3,"positional_element_ty","","Returns the type of element at index `i` in tuple or tuple-like type `t`.\nFor an enum `t`, `variant` is None only if `t` is a univariant enum."],[3,"named_element_ty","","Returns the type of element at field `n` in struct or struct-like type `t`.\nFor an enum `t`, `variant` must be some def id."],[3,"node_id_to_trait_ref","",""],[3,"try_node_id_to_type","",""],[3,"node_id_to_type","",""],[3,"node_id_to_type_opt","",""],[3,"node_id_item_substs","",""],[3,"fn_is_variadic","",""],[3,"ty_fn_sig","",""],[3,"ty_fn_abi","","Returns the ABI of the given function."],[3,"ty_fn_args","",""],[3,"ty_closure_store","",""],[3,"ty_fn_ret","",""],[3,"is_fn_ty","",""],[3,"ty_region","",""],[3,"free_region_from_def","",""],[3,"pat_ty","",""],[3,"expr_ty","",""],[3,"expr_ty_opt","",""],[3,"expr_ty_adjusted","","Returns the type of `expr`, considering any `AutoAdjustment`\nentry recorded for that expression."],[3,"expr_span","",""],[3,"local_var_name_str","",""],[3,"adjust_ty","","See `expr_ty_adjusted`"],[3,"adjust_ty_for_autoref","",""],[3,"unsize_ty","",""],[3,"resolve_expr","",""],[3,"expr_is_lval","",""],[2,"ExprKind","","We categorize expressions into three kinds.  The distinction between\nlvalue/rvalue is fundamental to the language.  The distinction between the\ntwo kinds of rvalues is an artifact of trans which reflects how we will\ngenerate code for that kind of expression.  See trans/expr.rs for more\ninformation."],[12,"LvalueExpr","","",450],[12,"RvalueDpsExpr","","",450],[12,"RvalueDatumExpr","","",450],[12,"RvalueStmtExpr","","",450],[3,"expr_kind","",""],[3,"stmt_node_id","",""],[3,"field_idx_strict","",""],[3,"impl_or_trait_item_idx","",""],[3,"ty_sort_string","",""],[3,"type_err_to_str","","Explains the source of a type err in a short, human readable way. This is meant to be placed\nin parentheses after some larger message. You should also invoke `note_and_explain_type_err()`\nafterwards to present additional details, particularly when it comes to lifetime-related\nerrors."],[3,"note_and_explain_type_err","",""],[3,"provided_source","",""],[3,"provided_trait_methods","",""],[3,"trait_item","",""],[3,"trait_items","",""],[3,"impl_or_trait_item","",""],[3,"is_associated_type","","Returns true if the given ID refers to an associated type and false if it\nrefers to anything else."],[3,"associated_type_parameter_index","","Returns the parameter index that the given associated type corresponds to."],[1,"AssociatedTypeInfo","",""],[11,"def_id","","",302],[11,"index","","",302],[11,"name","","",302],[3,"trait_item_def_ids","",""],[3,"impl_trait_ref","",""],[3,"trait_ref_to_def_id","",""],[3,"try_add_builtin_trait","","Checks whether `trait_ref` refers to one of the builtin\ntraits, like `Send`, and adds the corresponding\nbound to the set `builtin_bounds` if so. Returns true if `trait_ref`\nis a builtin trait."],[3,"ty_to_def_id","",""],[1,"VariantInfo","",""],[11,"args","","",303],[11,"arg_names","","",303],[11,"ctor_ty","","",303],[11,"name","","",303],[11,"id","","",303],[11,"disr_val","","",303],[11,"vis","","",303],[3,"substd_enum_variants","",""],[3,"item_path_str","",""],[2,"DtorKind","",""],[12,"NoDtor","","",304],[12,"TraitDtor","","",304],[3,"ty_dtor","",""],[3,"has_dtor","",""],[3,"with_path","",""],[3,"enum_is_univariant","",""],[3,"type_is_empty","",""],[3,"enum_variants","",""],[3,"enum_variant_with_id","",""],[3,"lookup_item_type","",""],[3,"lookup_trait_def","","Given the did of a trait, returns its canonical trait ref."],[3,"predicates_for_trait_ref","","Given a reference to a trait, returns the \"superbounds\" declared\non the trait, with appropriate substitutions applied. Basically,\nthis applies a filter to the where clauses on the trait, returning\nthose that have the form:"],[3,"predicates","",""],[3,"each_attr","","Iterate over attributes of a definition."],[3,"has_attr","","Determine whether an item is annotated with an attribute"],[3,"lookup_packed","","Determine whether an item is annotated with `#[repr(packed)]`"],[3,"lookup_simd","","Determine whether an item is annotated with `#[simd]`"],[3,"lookup_repr_hints","","Obtain the representation annotation for a struct definition."],[3,"lookup_field_type","",""],[3,"lookup_struct_fields","",""],[3,"is_tuple_struct","",""],[3,"struct_fields","",""],[3,"tup_fields","",""],[1,"UnboxedClosureUpvar","",""],[11,"def","","",451],[11,"span","","",451],[11,"ty","","",451],[3,"unboxed_closure_upvars","",""],[3,"is_binopable","",""],[3,"normalize_ty","","Returns an equivalent type with all the typedefs and self regions removed."],[3,"eval_repeat_count","",""],[3,"each_bound_trait_and_supertraits","",""],[3,"object_region_boun