var searchIndex = {};
searchIndex["alloc"] = {"doc":"The Rust core allocation library","items":[[0,"heap","alloc","",null,null],[5,"allocate","alloc::heap","Return a pointer to `size` bytes of memory aligned to `align`.",null,null],[5,"reallocate","","Resize the allocation referenced by `ptr` to `size` bytes.",null,null],[5,"reallocate_inplace","","Resize the allocation referenced by `ptr` to `size` bytes.",null,null],[5,"deallocate","","Deallocates the memory referenced by `ptr`.",null,null],[5,"usable_size","","Returns the usable size of an allocation created with the specified the `size` and `align`.",null,{"inputs":[{"name":"usize"},{"name":"usize"}],"output":{"name":"usize"}}],[17,"EMPTY","","An arbitrary non-null address to represent zero-size allocations.",null,null],[0,"boxed","alloc","A pointer type for heap allocation.",null,null],[3,"ExchangeHeapSingleton","alloc::boxed","This the singleton type used solely for `boxed::HEAP`.",null,null],[3,"Box","","A pointer type for heap allocation.",null,null],[3,"IntermediateBox","","`IntermediateBox` represents uninitialized backing storage for `Box`.",null,null],[17,"HEAP","","A value that represents the heap. This is the default place that the `box` keyword allocates into when no place is supplied.",null,null],[8,"FnBox","","`FnBox` is a version of the `FnOnce` intended for use with boxed closure objects. The idea is that where one would normally store a `Box<FnOnce()>` in a data structure, you should use `Box<FnBox()>`. The two traits behave essentially the same, except that a `FnBox` closure can only be called if it is boxed. (Note that `FnBox` may be deprecated in the future if `Box<FnOnce()>` closures become directly usable.)",null,null],[16,"Output","","",0,null],[10,"call_box","","",0,null],[11,"clone","","",1,{"inputs":[{"name":"self"}],"output":{"name":"exchangeheapsingleton"}}],[11,"pointer","","",2,null],[11,"make_place","","",2,{"inputs":[],"output":{"name":"intermediatebox"}}],[11,"finalize","","",2,{"inputs":[{"name":"self"}],"output":{"name":"box"}}],[11,"finalize","","",3,{"inputs":[{"name":"intermediatebox"}],"output":{"name":"box"}}],[11,"make_place","","",1,{"inputs":[{"name":"self"}],"output":{"name":"intermediatebox"}}],[11,"drop","","",2,{"inputs":[{"name":"self"}],"output":null}],[11,"new","","Allocates memory on the heap and then places `x` into it.",3,{"inputs":[{"name":"t"}],"output":{"name":"box"}}],[11,"from_raw","","Constructs a box from a raw pointer.",3,null],[11,"into_raw","","Consumes the `Box`, returning the wrapped raw pointer.",3,null],[11,"drop","","",3,{"inputs":[{"name":"self"}],"output":null}],[11,"default","","Creates a `Box<T>`, with the `Default` value for T.",3,{"inputs":[],"output":{"name":"box"}}],[11,"default","","",3,{"inputs":[],"output":{"name":"box"}}],[11,"default","","",3,{"inputs":[],"output":{"name":"box"}}],[11,"clone","","Returns a new box with a `clone()` of this box's contents.",3,{"inputs":[{"name":"self"}],"output":{"name":"box"}}],[11,"clone_from","","Copies `source`'s contents into `self` without creating a new allocation.",3,{"inputs":[{"name":"self"},{"name":"box"}],"output":null}],[11,"clone","","",3,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"eq","","",3,{"inputs":[{"name":"self"},{"name":"box"}],"output":{"name":"bool"}}],[11,"ne","","",3,{"inputs":[{"name":"self"},{"name":"box"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",3,{"inputs":[{"name":"self"},{"name":"box"}],"output":{"name":"option"}}],[11,"lt","","",3,{"inputs":[{"name":"self"},{"name":"box"}],"output":{"name":"bool"}}],[11,"le","","",3,{"inputs":[{"name":"self"},{"name":"box"}],"output":{"name":"bool"}}],[11,"ge","","",3,{"inputs":[{"name":"self"},{"name":"box"}],"output":{"name":"bool"}}],[11,"gt","","",3,{"inputs":[{"name":"self"},{"name":"box"}],"output":{"name":"bool"}}],[11,"cmp","","",3,{"inputs":[{"name":"self"},{"name":"box"}],"output":{"name":"ordering"}}],[11,"hash","","",3,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"from","","",3,{"inputs":[{"name":"t"}],"output":{"name":"self"}}],[11,"from","","",3,null],[11,"from","","",3,{"inputs":[{"name":"str"}],"output":{"name":"box"}}],[11,"downcast","","Attempt to downcast the box to a concrete type.",3,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"downcast","","Attempt to downcast the box to a concrete type.",3,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"fmt","","",3,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",3,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",3,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"deref","","",3,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"deref_mut","","",3,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"next","","",3,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",3,null],[11,"nth","","",3,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"next_back","","",3,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"len","","",3,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","",3,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"call_once","","",3,{"inputs":[{"name":"self"},{"name":"a"}],"output":{"name":"r"}}],[11,"call_once","","",3,{"inputs":[{"name":"self"},{"name":"a"}],"output":{"name":"r"}}],[11,"clone","","",3,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"borrow","","",3,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"borrow_mut","","",3,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"as_ref","","",3,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"as_mut","","",3,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[0,"arc","alloc","Thread-safe reference-counting pointers.",null,null],[3,"Arc","alloc::arc","A thread-safe reference-counting pointer.",null,null],[3,"Weak","","A weak version of [`Arc`][arc].",null,null],[11,"fmt","","",4,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Constructs a new `Arc<T>`.",5,{"inputs":[{"name":"t"}],"output":{"name":"arc"}}],[11,"try_unwrap","","Returns the contained value, if the `Arc` has exactly one strong reference.",5,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"into_raw","","Consumes the `Arc`, returning the wrapped pointer.",5,null],[11,"from_raw","","Constructs an `Arc` from a raw pointer.",5,null],[11,"downgrade","","Creates a new [`Weak`][weak] pointer to this value.",5,{"inputs":[{"name":"self"}],"output":{"name":"weak"}}],[11,"weak_count","","Gets the number of [`Weak`][weak] pointers to this value.",5,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"strong_count","","Gets the number of strong (`Arc`) pointers to this value.",5,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"ptr_eq","","Returns true if the two `Arc`s point to the same value (not just values that compare as equal).",5,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","Makes a clone of the `Arc` pointer.",5,{"inputs":[{"name":"self"}],"output":{"name":"arc"}}],[11,"deref","","",5,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"make_mut","","Makes a mutable reference into the given `Arc`.",5,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"get_mut","","Returns a mutable reference to the inner value, if there are no other `Arc` or [`Weak`][weak] pointers to the same value.",5,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"drop","","Drops the `Arc`.",5,{"inputs":[{"name":"self"}],"output":null}],[11,"new","","Constructs a new `Weak<T>`, without an accompanying instance of `T`.",4,{"inputs":[],"output":{"name":"weak"}}],[11,"upgrade","","Upgrades the `Weak` pointer to an [`Arc`][arc], if possible.",4,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","Makes a clone of the `Weak` pointer.",4,{"inputs":[{"name":"self"}],"output":{"name":"weak"}}],[11,"default","","Constructs a new `Weak<T>`, without an accompanying instance of `T`.",4,{"inputs":[],"output":{"name":"weak"}}],[11,"drop","","Drops the `Weak` pointer.",4,{"inputs":[{"name":"self"}],"output":null}],[11,"eq","","Equality for two `Arc`s.",5,{"inputs":[{"name":"self"},{"name":"arc"}],"output":{"name":"bool"}}],[11,"ne","","Inequality for two `Arc`s.",5,{"inputs":[{"name":"self"},{"name":"arc"}],"output":{"name":"bool"}}],[11,"partial_cmp","","Partial comparison for two `Arc`s.",5,{"inputs":[{"name":"self"},{"name":"arc"}],"output":{"name":"option"}}],[11,"lt","","Less-than comparison for two `Arc`s.",5,{"inputs":[{"name":"self"},{"name":"arc"}],"output":{"name":"bool"}}],[11,"le","","'Less than or equal to' comparison for two `Arc`s.",5,{"inputs":[{"name":"self"},{"name":"arc"}],"output":{"name":"bool"}}],[11,"gt","","Greater-than comparison for two `Arc`s.",5,{"inputs":[{"name":"self"},{"name":"arc"}],"output":{"name":"bool"}}],[11,"ge","","'Greater than or equal to' comparison for two `Arc`s.",5,{"inputs":[{"name":"self"},{"name":"arc"}],"output":{"name":"bool"}}],[11,"cmp","","Comparison for two `Arc`s.",5,{"inputs":[{"name":"self"},{"name":"arc"}],"output":{"name":"ordering"}}],[11,"fmt","","",5,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",5,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",5,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"default","","Creates a new `Arc<T>`, with the `Default` value for `T`.",5,{"inputs":[],"output":{"name":"arc"}}],[11,"hash","","",5,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"from","","",5,{"inputs":[{"name":"t"}],"output":{"name":"self"}}],[11,"borrow","","",5,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"as_ref","","",5,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[0,"rc","alloc","Single-threaded reference-counting pointers.",null,null],[3,"Rc","alloc::rc","A single-threaded reference-counting pointer.",null,null],[3,"Weak","","A weak version of [`Rc`][rc].",null,null],[11,"new","","Constructs a new `Rc<T>`.",6,{"inputs":[{"name":"t"}],"output":{"name":"rc"}}],[11,"try_unwrap","","Returns the contained value, if the `Rc` has exactly one strong reference.",6,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"would_unwrap","","Checks whether [`Rc::try_unwrap`][try_unwrap] would return [`Ok`].",6,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"into_raw","","Consumes the `Rc`, returning the wrapped pointer.",6,null],[11,"from_raw","","Constructs an `Rc` from a raw pointer.",6,null],[11,"downgrade","","Creates a new [`Weak`][weak] pointer to this value.",6,{"inputs":[{"name":"self"}],"output":{"name":"weak"}}],[11,"weak_count","","Gets the number of [`Weak`][weak] pointers to this value.",6,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"strong_count","","Gets the number of strong (`Rc`) pointers to this value.",6,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_unique","","Returns true if there are no other `Rc` or [`Weak`][weak] pointers to this inner value.",6,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"get_mut","","Returns a mutable reference to the inner value, if there are no other `Rc` or [`Weak`][weak] pointers to the same value.",6,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"ptr_eq","","Returns true if the two `Rc`s point to the same value (not just values that compare as equal).",6,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"bool"}}],[11,"make_mut","","Makes a mutable reference into the given `Rc`.",6,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"deref","","",6,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"drop","","Drops the `Rc`.",6,{"inputs":[{"name":"self"}],"output":null}],[11,"clone","","Makes a clone of the `Rc` pointer.",6,{"inputs":[{"name":"self"}],"output":{"name":"rc"}}],[11,"default","","Creates a new `Rc<T>`, with the `Default` value for `T`.",6,{"inputs":[],"output":{"name":"rc"}}],[11,"eq","","Equality for two `Rc`s.",6,{"inputs":[{"name":"self"},{"name":"rc"}],"output":{"name":"bool"}}],[11,"ne","","Inequality for two `Rc`s.",6,{"inputs":[{"name":"self"},{"name":"rc"}],"output":{"name":"bool"}}],[11,"partial_cmp","","Partial comparison for two `Rc`s.",6,{"inputs":[{"name":"self"},{"name":"rc"}],"output":{"name":"option"}}],[11,"lt","","Less-than comparison for two `Rc`s.",6,{"inputs":[{"name":"self"},{"name":"rc"}],"output":{"name":"bool"}}],[11,"le","","'Less than or equal to' comparison for two `Rc`s.",6,{"inputs":[{"name":"self"},{"name":"rc"}],"output":{"name":"bool"}}],[11,"gt","","Greater-than comparison for two `Rc`s.",6,{"inputs":[{"name":"self"},{"name":"rc"}],"output":{"name":"bool"}}],[11,"ge","","'Greater than or equal to' comparison for two `Rc`s.",6,{"inputs":[{"name":"self"},{"name":"rc"}],"output":{"name":"bool"}}],[11,"cmp","","Comparison for two `Rc`s.",6,{"inputs":[{"name":"self"},{"name":"rc"}],"output":{"name":"ordering"}}],[11,"hash","","",6,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"fmt","","",6,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",6,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",6,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"from","","",6,{"inputs":[{"name":"t"}],"output":{"name":"self"}}],[11,"new","","Constructs a new `Weak<T>`, without an accompanying instance of `T`.",7,{"inputs":[],"output":{"name":"weak"}}],[11,"upgrade","","Upgrades the `Weak` pointer to an [`Rc`][rc], if possible.",7,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"drop","","Drops the `Weak` pointer.",7,{"inputs":[{"name":"self"}],"output":null}],[11,"clone","","Makes a clone of the `Weak` pointer.",7,{"inputs":[{"name":"self"}],"output":{"name":"weak"}}],[11,"fmt","","",7,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"default","","Constructs a new `Weak<T>`, without an accompanying instance of `T`.",7,{"inputs":[],"output":{"name":"weak"}}],[11,"borrow","","",6,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"as_ref","","",6,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[0,"raw_vec","alloc","",null,null],[3,"RawVec","alloc::raw_vec","A low-level utility for more ergonomically allocating, reallocating, and deallocating a buffer of memory on the heap without having to worry about all the corner cases involved. This type is excellent for building your own data structures like Vec and VecDeque. In particular:",null,null],[11,"new","","Creates the biggest possible RawVec without allocating. If T has positive size, then this makes a RawVec with capacity 0. If T has 0 size, then it it makes a RawVec with capacity `usize::MAX`. Useful for implementing delayed allocation.",8,{"inputs":[],"output":{"name":"self"}}],[11,"with_capacity","","Creates a RawVec with exactly the capacity and alignment requirements for a `[T; cap]`. This is equivalent to calling RawVec::new when `cap` is 0 or T is zero-sized. Note that if `T` is zero-sized this means you will *not* get a RawVec with the requested capacity!",8,{"inputs":[{"name":"usize"}],"output":{"name":"self"}}],[11,"from_raw_parts","","Reconstitutes a RawVec from a pointer and capacity.",8,null],[11,"from_box","","Converts a `Box<[T]>` into a `RawVec<T>`.",8,{"inputs":[{"name":"box"}],"output":{"name":"self"}}],[11,"ptr","","Gets a raw pointer to the start of the allocation. Note that this is heap::EMPTY if `cap = 0` or T is zero-sized. In the former case, you must be careful.",8,null],[11,"cap","","Gets the capacity of the allocation.",8,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"double","","Doubles the size of the type's backing allocation. This is common enough to want to do that it's easiest to just have a dedicated method. Slightly more efficient logic can be provided for this than the general case.",8,{"inputs":[{"name":"self"}],"output":null}],[11,"double_in_place","","Attempts to double the size of the type's backing allocation in place. This is common enough to want to do that it's easiest to just have a dedicated method. Slightly more efficient logic can be provided for this than the general case.",8,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"reserve_exact","","Ensures that the buffer contains at least enough space to hold `used_cap + needed_extra_cap` elements. If it doesn't already, will reallocate the minimum possible amount of memory necessary. Generally this will be exactly the amount of memory necessary, but in principle the allocator is free to give back more than we asked for.",8,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"usize"}],"output":null}],[11,"reserve","","Ensures that the buffer contains at least enough space to hold `used_cap + needed_extra_cap` elements. If it doesn't already have enough capacity, will reallocate enough space plus comfortable slack space to get amortized `O(1)` behavior. Will limit this behavior if it would needlessly cause itself to panic.",8,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"usize"}],"output":null}],[11,"reserve_in_place","","Attempts to ensure that the buffer contains at least enough space to hold `used_cap + needed_extra_cap` elements. If it doesn't already have enough capacity, will reallocate in place enough space plus comfortable slack space to get amortized `O(1)` behaviour. Will limit this behaviour if it would needlessly cause itself to panic.",8,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"usize"}],"output":{"name":"bool"}}],[11,"shrink_to_fit","","Shrinks the allocation down to the specified amount. If the given amount is 0, actually completely deallocates.",8,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"into_box","","Converts the entire buffer into `Box<[T]>`.",8,{"inputs":[{"name":"self"}],"output":{"name":"box"}}],[11,"drop","","Frees the memory owned by the RawVec *without* trying to Drop its contents.",8,{"inputs":[{"name":"self"}],"output":null}],[0,"oom","alloc","",null,null],[5,"set_oom_handler","alloc::oom","Set a custom handler for out-of-memory conditions",null,null],[5,"oom","","Common out-of-memory routine",null,null]],"paths":[[8,"FnBox"],[3,"ExchangeHeapSingleton"],[3,"IntermediateBox"],[3,"Box"],[3,"Weak"],[3,"Arc"],[3,"Rc"],[3,"Weak"],[3,"RawVec"]]};
searchIndex["collections"] = {"doc":"Collection types.","items":[[0,"boxed","collections","A pointer type for heap allocation.",null,null],[17,"HEAP","collections::boxed","A value that represents the heap. This is the default place that the `box` keyword allocates into when no place is supplied.",null,null],[3,"ExchangeHeapSingleton","","This the singleton type used solely for `boxed::HEAP`.",null,null],[3,"Box","","A pointer type for heap allocation.",null,null],[3,"IntermediateBox","","`IntermediateBox` represents uninitialized backing storage for `Box`.",null,null],[8,"FnBox","","`FnBox` is a version of the `FnOnce` intended for use with boxed closure objects. The idea is that where one would normally store a `Box<FnOnce()>` in a data structure, you should use `Box<FnBox()>`. The two traits behave essentially the same, except that a `FnBox` closure can only be called if it is boxed. (Note that `FnBox` may be deprecated in the future if `Box<FnOnce()>` closures become directly usable.)",null,null],[16,"Output","","",0,null],[10,"call_box","","",0,null],[4,"Bound","collections","An endpoint of a range of keys.",null,null],[13,"Included","","An inclusive bound.",1,null],[13,"Excluded","","An exclusive bound.",1,null],[13,"Unbounded","","An infinite endpoint. Indicates that there is no bound in this direction.",1,null],[0,"binary_heap","","A priority queue implemented with a binary heap.",null,null],[3,"BinaryHeap","collections::binary_heap","A priority queue implemented with a binary heap.",null,null],[3,"PeekMut","","A container object that represents the result of the [`peek_mut()`] method on `BinaryHeap`. See its documentation for details.",null,null],[3,"Iter","","`BinaryHeap` iterator.",null,null],[3,"IntoIter","","An iterator that moves out of a `BinaryHeap`.",null,null],[3,"Drain","","An iterator that drains a `BinaryHeap`.",null,null],[3,"BinaryHeapPlace","","",null,null],[11,"fmt","","",2,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"drop","","",2,{"inputs":[{"name":"self"}],"output":null}],[11,"deref","","",2,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"deref_mut","","",2,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"pop","","Removes the peeked value from the heap and returns it.",2,{"inputs":[{"name":"peekmut"}],"output":{"name":"t"}}],[11,"clone","","",3,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"clone_from","","",3,{"inputs":[{"name":"self"},{"name":"self"}],"output":null}],[11,"default","","Creates an empty `BinaryHeap<T>`.",3,{"inputs":[],"output":{"name":"binaryheap"}}],[11,"fmt","","",3,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates an empty `BinaryHeap` as a max-heap.",3,{"inputs":[],"output":{"name":"binaryheap"}}],[11,"with_capacity","","Creates an empty `BinaryHeap` with a specific capacity. This preallocates enough memory for `capacity` elements, so that the `BinaryHeap` does not have to be reallocated until it contains at least that many values.",3,{"inputs":[{"name":"usize"}],"output":{"name":"binaryheap"}}],[11,"iter","","Returns an iterator visiting all values in the underlying vector, in arbitrary order.",3,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"peek","","Returns the greatest item in the binary heap, or `None` if it is empty.",3,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"peek_mut","","Returns a mutable reference to the greatest item in the binary heap, or `None` if it is empty.",3,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"capacity","","Returns the number of elements the binary heap can hold without reallocating.",3,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"reserve_exact","","Reserves the minimum capacity for exactly `additional` more elements to be inserted in the given `BinaryHeap`. Does nothing if the capacity is already sufficient.",3,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"reserve","","Reserves capacity for at least `additional` more elements to be inserted in the `BinaryHeap`. The collection may reserve more space to avoid frequent reallocations.",3,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shrink_to_fit","","Discards as much additional capacity as possible.",3,{"inputs":[{"name":"self"}],"output":null}],[11,"pop","","Removes the greatest item from the binary heap and returns it, or `None` if it is empty.",3,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"push","","Pushes an item onto the binary heap.",3,{"inputs":[{"name":"self"},{"name":"t"}],"output":null}],[11,"push_pop","","Pushes an item onto the binary heap, then pops the greatest item off the queue in an optimized fashion.",3,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"t"}}],[11,"replace","","Pops the greatest item off the binary heap, then pushes an item onto the queue in an optimized fashion. The push is done regardless of whether the binary heap was empty.",3,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"option"}}],[11,"into_vec","","Consumes the `BinaryHeap` and returns the underlying vector in arbitrary order.",3,{"inputs":[{"name":"self"}],"output":{"name":"vec"}}],[11,"into_sorted_vec","","Consumes the `BinaryHeap` and returns a vector in sorted (ascending) order.",3,{"inputs":[{"name":"self"}],"output":{"name":"vec"}}],[11,"len","","Returns the length of the binary heap.",3,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","Checks if the binary heap is empty.",3,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"drain","","Clears the binary heap, returning an iterator over the removed elements.",3,{"inputs":[{"name":"self"}],"output":{"name":"drain"}}],[11,"clear","","Drops all items from the binary heap.",3,{"inputs":[{"name":"self"}],"output":null}],[11,"append","","Moves all the elements of `other` into `self`, leaving `other` empty.",3,{"inputs":[{"name":"self"},{"name":"self"}],"output":null}],[11,"fmt","","",4,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",4,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"next","","",4,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",4,null],[11,"next_back","","",4,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"is_empty","","",4,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",5,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"fmt","","",5,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",5,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",5,null],[11,"next_back","","",5,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"is_empty","","",5,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"fmt","","",6,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",6,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",6,null],[11,"next_back","","",6,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"is_empty","","",6,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"from","","",3,{"inputs":[{"name":"vec"}],"output":{"name":"binaryheap"}}],[11,"from_iter","","",3,{"inputs":[{"name":"i"}],"output":{"name":"binaryheap"}}],[11,"into_iter","","Creates a consuming iterator, that is, one that moves each value out of the binary heap in arbitrary order. The binary heap cannot be used after calling this.",3,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"extend","","",3,{"inputs":[{"name":"self"},{"name":"i"}],"output":null}],[11,"extend","","",3,{"inputs":[{"name":"self"},{"name":"i"}],"output":null}],[11,"fmt","","",7,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"pointer","","",7,null],[11,"finalize","","",7,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[0,"borrow","collections","A module for working with borrowed data.",null,null],[8,"Borrow","collections::borrow","A trait for borrowing data.",null,null],[10,"borrow","","Immutably borrows from an owned value.",8,{"inputs":[{"name":"self"}],"output":{"name":"borrowed"}}],[8,"BorrowMut","","A trait for mutably borrowing data.",null,null],[10,"borrow_mut","","Mutably borrows from an owned value.",9,{"inputs":[{"name":"self"}],"output":{"name":"borrowed"}}],[4,"Cow","","A clone-on-write smart pointer.",null,null],[13,"Borrowed","","Borrowed data.",10,null],[13,"Owned","","Owned data.",10,null],[8,"ToOwned","","A generalization of `Clone` to borrowed data.",null,null],[16,"Owned","","",11,null],[10,"to_owned","","Creates owned data from borrowed data, usually by cloning.",11,null],[11,"borrow","","",10,{"inputs":[{"name":"self"}],"output":{"name":"b"}}],[11,"clone","","",10,{"inputs":[{"name":"self"}],"output":{"name":"cow"}}],[11,"to_mut","","Acquires a mutable reference to the owned form of the data.",10,null],[11,"into_owned","","Extracts the owned data.",10,null],[11,"deref","","",10,{"inputs":[{"name":"self"}],"output":{"name":"b"}}],[11,"cmp","","",10,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"ordering"}}],[11,"eq","","",10,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",10,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"option"}}],[11,"fmt","","",10,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",10,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"default","","Creates an owned Cow<'a, B> with the default value for the contained owned value.",10,{"inputs":[],"output":{"name":"cow"}}],[11,"hash","","",10,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"as_ref","","",10,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"add","","",10,null],[11,"add","","",10,null],[11,"add_assign","","",10,{"inputs":[{"name":"self"},{"name":"str"}],"output":null}],[11,"add_assign","","",10,{"inputs":[{"name":"self"},{"name":"cow"}],"output":null}],[0,"enum_set","collections","A structure for holding a set of enum variants.",null,null],[3,"EnumSet","collections::enum_set","A specialized set implementation to use enum types.",null,null],[3,"Iter","","An iterator over an EnumSet",null,null],[8,"CLike","","An interface for casting C-like enum to usize and back. A typically implementation is as below.",null,null],[10,"to_usize","","Converts a C-like enum to a `usize`.",12,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[10,"from_usize","","Converts a `usize` to a C-like enum.",12,{"inputs":[{"name":"usize"}],"output":{"name":"self"}}],[11,"eq","","",13,{"inputs":[{"name":"self"},{"name":"enumset"}],"output":{"name":"bool"}}],[11,"ne","","",13,{"inputs":[{"name":"self"},{"name":"enumset"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",13,{"inputs":[{"name":"self"},{"name":"enumset"}],"output":{"name":"option"}}],[11,"lt","","",13,{"inputs":[{"name":"self"},{"name":"enumset"}],"output":{"name":"bool"}}],[11,"le","","",13,{"inputs":[{"name":"self"},{"name":"enumset"}],"output":{"name":"bool"}}],[11,"gt","","",13,{"inputs":[{"name":"self"},{"name":"enumset"}],"output":{"name":"bool"}}],[11,"ge","","",13,{"inputs":[{"name":"self"},{"name":"enumset"}],"output":{"name":"bool"}}],[11,"cmp","","",13,{"inputs":[{"name":"self"},{"name":"enumset"}],"output":{"name":"ordering"}}],[11,"hash","","",13,null],[11,"clone","","",13,{"inputs":[{"name":"self"}],"output":{"name":"enumset"}}],[11,"fmt","","",13,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Returns an empty `EnumSet`.",13,{"inputs":[],"output":{"name":"enumset"}}],[11,"len","","Returns the number of elements in the given `EnumSet`.",13,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","Returns true if the `EnumSet` is empty.",13,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clear","","",13,{"inputs":[{"name":"self"}],"output":null}],[11,"is_disjoint","","Returns `false` if the `EnumSet` contains any enum of the given `EnumSet`.",13,{"inputs":[{"name":"self"},{"name":"enumset"}],"output":{"name":"bool"}}],[11,"is_superset","","Returns `true` if a given `EnumSet` is included in this `EnumSet`.",13,{"inputs":[{"name":"self"},{"name":"enumset"}],"output":{"name":"bool"}}],[11,"is_subset","","Returns `true` if this `EnumSet` is included in the given `EnumSet`.",13,{"inputs":[{"name":"self"},{"name":"enumset"}],"output":{"name":"bool"}}],[11,"union","","Returns the union of both `EnumSets`.",13,{"inputs":[{"name":"self"},{"name":"enumset"}],"output":{"name":"enumset"}}],[11,"intersection","","Returns the intersection of both `EnumSets`.",13,{"inputs":[{"name":"self"},{"name":"enumset"}],"output":{"name":"enumset"}}],[11,"insert","","Adds an enum to the `EnumSet`, and returns `true` if it wasn't there before",13,{"inputs":[{"name":"self"},{"name":"e"}],"output":{"name":"bool"}}],[11,"remove","","Removes an enum from the EnumSet",13,{"inputs":[{"name":"self"},{"name":"e"}],"output":{"name":"bool"}}],[11,"contains","","Returns `true` if an `EnumSet` contains a given enum.",13,{"inputs":[{"name":"self"},{"name":"e"}],"output":{"name":"bool"}}],[11,"iter","","Returns an iterator over an `EnumSet`.",13,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"sub","","",13,{"inputs":[{"name":"self"},{"name":"enumset"}],"output":{"name":"enumset"}}],[11,"bitor","","",13,{"inputs":[{"name":"self"},{"name":"enumset"}],"output":{"name":"enumset"}}],[11,"bitand","","",13,{"inputs":[{"name":"self"},{"name":"enumset"}],"output":{"name":"enumset"}}],[11,"bitxor","","",13,{"inputs":[{"name":"self"},{"name":"enumset"}],"output":{"name":"enumset"}}],[11,"fmt","","",14,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",14,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"next","","",14,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",14,null],[11,"from_iter","","",13,{"inputs":[{"name":"i"}],"output":{"name":"enumset"}}],[11,"extend","","",13,{"inputs":[{"name":"self"},{"name":"i"}],"output":null}],[11,"extend","","",13,{"inputs":[{"name":"self"},{"name":"i"}],"output":null}],[0,"fmt","collections","Utilities for formatting and printing `String`s",null,null],[3,"Formatter","collections::fmt","A struct to represent both where to emit formatting strings to and how they should be formatted. A mutable version of this is passed to all formatting traits.",null,null],[6,"Result","","The type returned by formatter methods.",null,null],[8,"Write","","A collection of methods that are required to format a message into a stream.",null,null],[10,"write_str","","Writes a slice of bytes into this writer, returning whether the write succeeded.",15,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"result"}}],[11,"write_char","","Writes a [`char`] into this writer, returning whether the write succeeded.",15,{"inputs":[{"name":"self"},{"name":"char"}],"output":{"name":"result"}}],[11,"write_fmt","","Glue for usage of the [`write!`] macro with implementors of this trait.",15,{"inputs":[{"name":"self"},{"name":"arguments"}],"output":{"name":"result"}}],[8,"Octal","","Format trait for the `o` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",16,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"Binary","","Format trait for the `b` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",17,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"Display","","Format trait for an empty format, `{}`.",null,null],[10,"fmt","","Formats the value using the given formatter.",18,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"Debug","","Format trait for the `?` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",19,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"LowerHex","","Format trait for the `x` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",20,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"UpperHex","","Format trait for the `X` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",21,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"Pointer","","Format trait for the `p` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",22,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"LowerExp","","Format trait for the `e` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",23,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"UpperExp","","Format trait for the `E` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",24,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"Error","","The error type which is returned from formatting a message into a stream.",null,null],[3,"Arguments","","This structure represents a safely precompiled version of a format string and its arguments. This cannot be generated at runtime because it cannot safely be done, so no constructors are given and the fields are private to prevent modification.",null,null],[5,"write","","The `write` function takes an output stream, a precompiled format string, and a list of arguments. The arguments will be formatted according to the specified format string into the output stream provided.",null,{"inputs":[{"name":"write"},{"name":"arguments"}],"output":{"name":"result"}}],[3,"DebugList","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugMap","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugSet","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugStruct","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugTuple","","A struct to help with `fmt::Debug` implementations.",null,null],[5,"format","","The format function takes a precompiled format string and a list of arguments, to return the resulting formatted string.",null,{"inputs":[{"name":"arguments"}],"output":{"name":"string"}}],[0,"linked_list","collections","A doubly-linked list with owned nodes.",null,null],[3,"LinkedList","collections::linked_list","A doubly-linked list with owned nodes.",null,null],[3,"Iter","","An iterator over references to the elements of a `LinkedList`.",null,null],[3,"IterMut","","An iterator over mutable references to the elements of a `LinkedList`.",null,null],[3,"IntoIter","","An iterator over the elements of a `LinkedList`.",null,null],[3,"FrontPlace","","A place for insertion at the front of a `LinkedList`.",null,null],[3,"BackPlace","","A place for insertion at the back of a `LinkedList`.",null,null],[11,"fmt","","",25,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",25,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"fmt","","",26,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",27,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"fmt","","",27,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"default","","Creates an empty `LinkedList<T>`.",28,{"inputs":[],"output":{"name":"self"}}],[11,"new","","Creates an empty `LinkedList`.",28,{"inputs":[],"output":{"name":"self"}}],[11,"append","","Moves all elements from `other` to the end of the list.",28,{"inputs":[{"name":"self"},{"name":"self"}],"output":null}],[11,"iter","","Provides a forward iterator.",28,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"iter_mut","","Provides a forward iterator with mutable references.",28,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"is_empty","","Returns `true` if the `LinkedList` is empty.",28,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"len","","Returns the length of the `LinkedList`.",28,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"clear","","Removes all elements from the `LinkedList`.",28,{"inputs":[{"name":"self"}],"output":null}],[11,"contains","","Returns `true` if the `LinkedList` contains an element equal to the given value.",28,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"bool"}}],[11,"front","","Provides a reference to the front element, or `None` if the list is empty.",28,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"front_mut","","Provides a mutable reference to the front element, or `None` if the list is empty.",28,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"back","","Provides a reference to the back element, or `None` if the list is empty.",28,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"back_mut","","Provides a mutable reference to the back element, or `None` if the list is empty.",28,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"push_front","","Adds an element first in the list.",28,{"inputs":[{"name":"self"},{"name":"t"}],"output":null}],[11,"pop_front","","Removes the first element and returns it, or `None` if the list is empty.",28,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"push_back","","Appends an element to the back of a list",28,{"inputs":[{"name":"self"},{"name":"t"}],"output":null}],[11,"pop_back","","Removes the last element from a list and returns it, or `None` if it is empty.",28,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"split_off","","Splits the list into two at the given index. Returns everything after the given index, including the index.",28,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"linkedlist"}}],[11,"front_place","","Returns a place for insertion at the front of the list.",28,{"inputs":[{"name":"self"}],"output":{"name":"frontplace"}}],[11,"back_place","","Returns a place for insertion at the back of the list.",28,{"inputs":[{"name":"self"}],"output":{"name":"backplace"}}],[11,"drop","","",28,{"inputs":[{"name":"self"}],"output":null}],[11,"next","","",25,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",25,null],[11,"next_back","","",25,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",26,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",26,null],[11,"next_back","","",26,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"insert_next","","Inserts the given element just after the element most recently returned by `.next()`. The inserted element does not appear in the iteration.",26,{"inputs":[{"name":"self"},{"name":"t"}],"output":null}],[11,"peek_next","","Provides a reference to the next element, without changing the iterator.",26,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",27,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",27,null],[11,"next_back","","",27,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"from_iter","","",28,{"inputs":[{"name":"i"}],"output":{"name":"self"}}],[11,"into_iter","","Consumes the list into an iterator yielding elements by value.",28,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"extend","","",28,{"inputs":[{"name":"self"},{"name":"i"}],"output":null}],[11,"extend","","",28,{"inputs":[{"name":"self"},{"name":"i"}],"output":null}],[11,"eq","","",28,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"bool"}}],[11,"ne","","",28,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",28,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"option"}}],[11,"cmp","","",28,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"ordering"}}],[11,"clone","","",28,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"fmt","","",28,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",28,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"fmt","","",29,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"make_place","","",29,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"pointer","","",29,null],[11,"finalize","","",29,{"inputs":[{"name":"self"}],"output":null}],[11,"fmt","","",30,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"make_place","","",30,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"pointer","","",30,null],[11,"finalize","","",30,{"inputs":[{"name":"self"}],"output":null}],[0,"range","collections","Range syntax.",null,null],[8,"RangeArgument","collections::range","**RangeArgument** is implemented by Rust's built-in range types, produced by range syntax like `..`, `a..`, `..b` or `c..d`.",null,null],[10,"start","","Start index bound",31,{"inputs":[{"name":"self"}],"output":{"name":"bound"}}],[10,"end","","End index bound",31,{"inputs":[{"name":"self"}],"output":{"name":"bound"}}],[0,"slice","collections","A dynamically-sized view into a contiguous sequence, `[T]`.",null,null],[3,"Chunks","collections::slice","An iterator over a slice in (non-overlapping) chunks (`size` elements at a time).",null,null],[3,"Windows","","An iterator over overlapping subslices of length `size`.",null,null],[3,"Iter","","Immutable slice iterator",null,null],[3,"IterMut","","Mutable slice iterator.",null,null],[3,"SplitMut","","An iterator over the subslices of the vector which are separated by elements that match `pred`.",null,null],[3,"ChunksMut","","An iterator over a slice in (non-overlapping) mutable chunks (`size` elements at a time). When the slice len is not evenly divided by the chunk size, the last slice of the iteration will be the remainder.",null,null],[3,"Split","","An iterator over subslices separated by elements that match a predicate function.",null,null],[3,"SplitN","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits.",null,null],[3,"RSplitN","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits, starting from the end of the slice.",null,null],[3,"SplitNMut","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits.",null,null],[3,"RSplitNMut","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits, starting from the end of the slice.",null,null],[5,"from_raw_parts","","Forms a slice from a pointer and a length.",null,null],[5,"from_raw_parts_mut","","Performs the same functionality as `from_raw_parts`, except that a mutable slice is returned.",null,null],[8,"SliceIndex","","A helper trait used for indexing operations.",null,null],[16,"Output","","The output type returned by methods.",32,null],[10,"get","","Returns a shared reference to the output at this location, if in bounds.",32,null],[10,"get_mut","","Returns a mutable reference to the output at this location, if in bounds.",32,null],[10,"get_unchecked","","Returns a shared reference to the output at this location, without performing any bounds checking.",32,null],[10,"get_unchecked_mut","","Returns a mutable reference to the output at this location, without performing any bounds checking.",32,null],[10,"index","","Returns a shared reference to the output at this location, panicking if out of bounds.",32,null],[10,"index_mut","","Returns a mutable reference to the output at this location, panicking if out of bounds.",32,null],[8,"SliceConcatExt","","An extension trait for concatenating slices",null,null],[16,"Output","","The resulting type after concatenation",33,null],[10,"concat","","Flattens a slice of `T` into a single value `Self::Output`.",33,null],[10,"join","","Flattens a slice of `T` into a single value `Self::Output`, placing a given separator between each.",33,null],[10,"connect","","",33,null],[0,"str","collections","Unicode string slices.",null,null],[8,"FromStr","collections::str","A trait to abstract the idea of creating a new instance of a type from a string.",null,null],[16,"Err","","The associated error which can be returned from parsing.",34,null],[10,"from_str","","Parses a string `s` to return a value of this type.",34,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[3,"Utf8Error","","Errors which can occur when attempting to interpret a sequence of `u8` as a string.",null,null],[3,"Lines","","Created with the method [`lines()`].",null,null],[3,"LinesAny","","Created with the method [`lines_any()`].",null,null],[3,"Split","","Created with the method [`split()`].",null,null],[3,"RSplit","","Created with the method [`rsplit()`].",null,null],[3,"SplitN","","Created with the method [`splitn()`].",null,null],[3,"RSplitN","","Created with the method [`rsplitn()`].",null,null],[3,"SplitTerminator","","Created with the method [`split_terminator()`].",null,null],[3,"RSplitTerminator","","Created with the method [`rsplit_terminator()`].",null,null],[3,"Matches","","Created with the method [`matches()`].",null,null],[3,"RMatches","","Created with the method [`rmatches()`].",null,null],[3,"MatchIndices","","Created with the method [`match_indices()`].",null,null],[3,"RMatchIndices","","Created with the method [`rmatch_indices()`].",null,null],[5,"from_utf8","","Converts a slice of bytes to a string slice.",null,null],[3,"Chars","","Iterator for the char (representing *Unicode Scalar Values*) of a string",null,null],[3,"CharIndices","","Iterator for a string's characters and their byte offsets.",null,null],[3,"Bytes","","External iterator for a string's bytes. Use with the `std::iter` module.",null,null],[5,"from_utf8_unchecked","","Converts a slice of bytes to a string slice without checking that the string contains valid UTF-8.",null,null],[3,"ParseBoolError","","An error returned when parsing a `bool` from a string fails.",null,null],[3,"SplitWhitespace","","An iterator over the non-whitespace substrings of a string, separated by any amount of whitespace.",null,null],[0,"pattern","","The string Pattern API.",null,null],[8,"Pattern","collections::str::pattern","A string pattern.",null,null],[16,"Searcher","","Associated searcher for this pattern",35,null],[10,"into_searcher","","Constructs the associated searcher from `self` and the `haystack` to search in.",35,null],[11,"is_contained_in","","Checks whether the pattern matches anywhere in the haystack",35,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"is_prefix_of","","Checks whether the pattern matches at the front of the haystack",35,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"is_suffix_of","","Checks whether the pattern matches at the back of the haystack",35,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[4,"SearchStep","","Result of calling `Searcher::next()` or `ReverseSearcher::next_back()`.",null,null],[13,"Match","","Expresses that a match of the pattern has been found at `haystack[a..b]`.",36,null],[13,"Reject","","Expresses that `haystack[a..b]` has been rejected as a possible match of the pattern.",36,null],[13,"Done","","Expresses that every byte of the haystack has been visted, ending the iteration.",36,null],[8,"Searcher","","A searcher for a string pattern.",null,null],[10,"haystack","","Getter for the underlaying string to be searched in",37,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[10,"next","","Performs the next search step starting from the front.",37,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match","","Find the next `Match` result. See `next()`",37,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject","","Find the next `Reject` result. See `next()`",37,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[8,"ReverseSearcher","","A reverse searcher for a string pattern.",null,null],[10,"next_back","","Performs the next search step starting from the back.",38,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match_back","","Find the next `Match` result. See `next_back()`",38,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject_back","","Find the next `Reject` result. See `next_back()`",38,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[8,"DoubleEndedSearcher","","A marker trait to express that a `ReverseSearcher` can be used for a `DoubleEndedIterator` implementation.",null,null],[3,"CharSearcher","","Associated type for `<char as Pattern<'a>>::Searcher`.",null,null],[3,"CharSliceSearcher","","Associated type for `<&[char] as Pattern<'a>>::Searcher`.",null,null],[3,"CharPredicateSearcher","","Associated type for `<F as Pattern<'a>>::Searcher`.",null,null],[3,"StrSearcher","","Associated type for `<&str as Pattern<'a>>::Searcher`.",null,null],[3,"EncodeUtf16","collections::str","External iterator for a string's UTF-16 code units.",null,null],[11,"clone","","",39,{"inputs":[{"name":"self"}],"output":{"name":"encodeutf16"}}],[11,"fmt","","",39,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",39,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",39,null],[0,"string","collections","A UTF-8 encoded, growable string.",null,null],[3,"String","collections::string","A UTF-8 encoded, growable string.",null,null],[3,"FromUtf8Error","","A possible error value when converting a `String` from a UTF-8 byte vector.",null,null],[3,"FromUtf16Error","","A possible error value when converting a `String` from a UTF-16 byte slice.",null,null],[3,"Drain","","A draining iterator for `String`.",null,null],[4,"ParseError","","An error when parsing a `String`.",null,null],[8,"ToString","","A trait for converting a value to a `String`.",null,null],[10,"to_string","","Converts the given value to a `String`.",40,{"inputs":[{"name":"self"}],"output":{"name":"string"}}],[11,"partial_cmp","","",41,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"option"}}],[11,"lt","","",41,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"bool"}}],[11,"le","","",41,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"bool"}}],[11,"gt","","",41,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"bool"}}],[11,"ge","","",41,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"bool"}}],[11,"cmp","","",41,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"ordering"}}],[11,"fmt","","",42,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",43,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new empty `String`.",41,{"inputs":[],"output":{"name":"string"}}],[11,"with_capacity","","Creates a new empty `String` with a particular capacity.",41,{"inputs":[{"name":"usize"}],"output":{"name":"string"}}],[11,"from_utf8","","Converts a vector of bytes to a `String`.",41,{"inputs":[{"name":"vec"}],"output":{"name":"result"}}],[11,"from_utf8_lossy","","Converts a slice of bytes to a string, including invalid characters.",41,null],[11,"from_utf16","","Decode a UTF-16 encoded vector `v` into a `String`, returning `Err` if `v` contains any invalid data.",41,null],[11,"from_utf16_lossy","","Decode a UTF-16 encoded vector `v` into a string, replacing invalid data with the replacement character (U+FFFD).",41,null],[11,"from_raw_parts","","Creates a new `String` from a length, capacity, and pointer.",41,null],[11,"from_utf8_unchecked","","Converts a vector of bytes to a `String` without checking that the string contains valid UTF-8.",41,{"inputs":[{"name":"vec"}],"output":{"name":"string"}}],[11,"into_bytes","","Converts a `String` into a byte vector.",41,{"inputs":[{"name":"self"}],"output":{"name":"vec"}}],[11,"as_str","","Extracts a string slice containing the entire string.",41,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"as_mut_str","","Extracts a string slice containing the entire string.",41,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"push_str","","Appends a given string slice onto the end of this `String`.",41,{"inputs":[{"name":"self"},{"name":"str"}],"output":null}],[11,"capacity","","Returns this `String`'s capacity, in bytes.",41,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"reserve","","Ensures that this `String`'s capacity is at least `additional` bytes larger than its length.",41,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"reserve_exact","","Ensures that this `String`'s capacity is `additional` bytes larger than its length.",41,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shrink_to_fit","","Shrinks the capacity of this `String` to match its length.",41,{"inputs":[{"name":"self"}],"output":null}],[11,"push","","Appends the given `char` to the end of this `String`.",41,{"inputs":[{"name":"self"},{"name":"char"}],"output":null}],[11,"as_bytes","","Returns a byte slice of this `String`'s contents.",41,null],[11,"truncate","","Shortens this `String` to the specified length.",41,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"pop","","Removes the last character from the string buffer and returns it.",41,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"remove","","Removes a `char` from this `String` at a byte position and returns it.",41,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"char"}}],[11,"insert","","Inserts a character into this `String` at a byte position.",41,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"char"}],"output":null}],[11,"insert_str","","Inserts a string slice into this `String` at a byte position.",41,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"str"}],"output":null}],[11,"as_mut_vec","","Returns a mutable reference to the contents of this `String`.",41,{"inputs":[{"name":"self"}],"output":{"name":"vec"}}],[11,"len","","Returns the length of this `String`, in bytes.",41,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","Returns `true` if this `String` has a length of zero.",41,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"split_off","","Splits the string into two at the given index.",41,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"string"}}],[11,"clear","","Truncates this `String`, removing all contents.",41,{"inputs":[{"name":"self"}],"output":null}],[11,"drain","","Create a draining iterator that removes the specified range in the string and yields the removed chars.",41,{"inputs":[{"name":"self"},{"name":"r"}],"output":{"name":"drain"}}],[11,"into_boxed_str","","Converts this `String` into a `Box<str>`.",41,{"inputs":[{"name":"self"}],"output":{"name":"box"}}],[11,"into_bytes","","Returns the bytes that were attempted to convert to a `String`.",42,{"inputs":[{"name":"self"}],"output":{"name":"vec"}}],[11,"utf8_error","","Fetch a `Utf8Error` to get more details about the conversion failure.",42,{"inputs":[{"name":"self"}],"output":{"name":"utf8error"}}],[11,"fmt","","",42,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",43,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",41,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"clone_from","","",41,{"inputs":[{"name":"self"},{"name":"self"}],"output":null}],[11,"from_iter","","",41,{"inputs":[{"name":"i"}],"output":{"name":"string"}}],[11,"from_iter","","",41,{"inputs":[{"name":"i"}],"output":{"name":"string"}}],[11,"from_iter","","",41,{"inputs":[{"name":"i"}],"output":{"name":"string"}}],[11,"from_iter","","",41,{"inputs":[{"name":"i"}],"output":{"name":"string"}}],[11,"extend","","",41,{"inputs":[{"name":"self"},{"name":"i"}],"output":null}],[11,"extend","","",41,{"inputs":[{"name":"self"},{"name":"i"}],"output":null}],[11,"extend","","",41,{"inputs":[{"name":"self"},{"name":"i"}],"output":null}],[11,"extend","","",41,{"inputs":[{"name":"self"},{"name":"i"}],"output":null}],[11,"eq","","",41,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"bool"}}],[11,"ne","","",41,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"bool"}}],[11,"eq","","",41,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"ne","","",41,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"eq","","",41,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"ne","","",41,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"eq","collections::borrow","",10,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"ne","","",10,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"eq","","",10,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"ne","","",10,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"eq","","",10,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"bool"}}],[11,"ne","","",10,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"bool"}}],[11,"eq","collections::string","",41,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"bool"}}],[11,"ne","","",41,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"bool"}}],[11,"default","","Creates an empty `String`.",41,{"inputs":[],"output":{"name":"string"}}],[11,"fmt","","",41,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",41,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",41,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"add","","",41,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"string"}}],[11,"add_assign","","",41,{"inputs":[{"name":"self"},{"name":"str"}],"output":null}],[11,"index","","",41,{"inputs":[{"name":"self"},{"name":"range"}],"output":{"name":"str"}}],[11,"index","","",41,{"inputs":[{"name":"self"},{"name":"rangeto"}],"output":{"name":"str"}}],[11,"index","","",41,{"inputs":[{"name":"self"},{"name":"rangefrom"}],"output":{"name":"str"}}],[11,"index","","",41,{"inputs":[{"name":"self"},{"name":"rangefull"}],"output":{"name":"str"}}],[11,"index","","",41,{"inputs":[{"name":"self"},{"name":"rangeinclusive"}],"output":{"name":"str"}}],[11,"index","","",41,{"inputs":[{"name":"self"},{"name":"rangetoinclusive"}],"output":{"name":"str"}}],[11,"index_mut","","",41,{"inputs":[{"name":"self"},{"name":"range"}],"output":{"name":"str"}}],[11,"index_mut","","",41,{"inputs":[{"name":"self"},{"name":"rangeto"}],"output":{"name":"str"}}],[11,"index_mut","","",41,{"inputs":[{"name":"self"},{"name":"rangefrom"}],"output":{"name":"str"}}],[11,"index_mut","","",41,{"inputs":[{"name":"self"},{"name":"rangefull"}],"output":{"name":"str"}}],[11,"index_mut","","",41,{"inputs":[{"name":"self"},{"name":"rangeinclusive"}],"output":{"name":"str"}}],[11,"index_mut","","",41,{"inputs":[{"name":"self"},{"name":"rangetoinclusive"}],"output":{"name":"str"}}],[11,"deref","","",41,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"deref_mut","","",41,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"from_str","","",41,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"clone","","",44,{"inputs":[{"name":"self"}],"output":{"name":"parseerror"}}],[11,"fmt","","",44,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",44,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",44,{"inputs":[{"name":"self"},{"name":"parseerror"}],"output":{"name":"bool"}}],[11,"to_string","collections::borrow","",10,{"inputs":[{"name":"self"}],"output":{"name":"string"}}],[11,"to_string","collections::string","",41,{"inputs":[{"name":"self"}],"output":{"name":"string"}}],[11,"as_ref","","",41,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"as_ref","","",41,null],[11,"from","","",41,{"inputs":[{"name":"str"}],"output":{"name":"string"}}],[11,"from","","",41,{"inputs":[{"name":"cow"}],"output":{"name":"string"}}],[11,"from","collections::borrow","",10,{"inputs":[{"name":"str"}],"output":{"name":"cow"}}],[11,"from","","",10,{"inputs":[{"name":"string"}],"output":{"name":"cow"}}],[11,"from_iter","","",10,{"inputs":[{"name":"i"}],"output":{"name":"cow"}}],[11,"from_iter","","",10,{"inputs":[{"name":"i"}],"output":{"name":"cow"}}],[11,"from_iter","","",10,{"inputs":[{"name":"i"}],"output":{"name":"cow"}}],[11,"write_str","collections::string","",41,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"result"}}],[11,"write_char","","",41,{"inputs":[{"name":"self"},{"name":"char"}],"output":{"name":"result"}}],[11,"fmt","","",45,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"drop","","",45,{"inputs":[{"name":"self"}],"output":null}],[11,"next","","",45,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",45,null],[11,"next_back","","",45,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[0,"vec","collections","A contiguous growable array type with heap-allocated contents, written `Vec<T>` but pronounced 'vector.'",null,null],[3,"Vec","collections::vec","A contiguous growable array type, written `Vec<T>` but pronounced 'vector'.",null,null],[3,"IntoIter","","An iterator that moves out of a vector.",null,null],[3,"Drain","","A draining iterator for `Vec<T>`.",null,null],[3,"PlaceBack","","A place for insertion at the back of a `Vec`.",null,null],[11,"new","","Constructs a new, empty `Vec<T>`.",46,{"inputs":[],"output":{"name":"vec"}}],[11,"with_capacity","","Constructs a new, empty `Vec<T>` with the specified capacity.",46,{"inputs":[{"name":"usize"}],"output":{"name":"vec"}}],[11,"from_raw_parts","","Creates a `Vec<T>` directly from the raw components of another vector.",46,null],[11,"capacity","","Returns the number of elements the vector can hold without reallocating.",46,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"reserve","","Reserves capacity for at least `additional` more elements to be inserted in the given `Vec<T>`. The collection may reserve more space to avoid frequent reallocations. After calling `reserve`, capacity will be greater than or equal to `self.len() + additional`. Does nothing if capacity is already sufficient.",46,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"reserve_exact","","Reserves the minimum capacity for exactly `additional` more elements to be inserted in the given `Vec<T>`. After calling `reserve_exact`, capacity will be greater than or equal to `self.len() + additional`. Does nothing if the capacity is already sufficient.",46,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shrink_to_fit","","Shrinks the capacity of the vector as much as possible.",46,{"inputs":[{"name":"self"}],"output":null}],[11,"into_boxed_slice","","Converts the vector into [`Box<[T]>`][owned slice].",46,{"inputs":[{"name":"self"}],"output":{"name":"box"}}],[11,"truncate","","Shortens the vector, keeping the first `len` elements and dropping the rest.",46,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"as_slice","","Extracts a slice containing the entire vector.",46,null],[11,"as_mut_slice","","Extracts a mutable slice of the entire vector.",46,null],[11,"set_len","","Sets the length of a vector.",46,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"swap_remove","","Removes an element from anywhere in the vector and return it, replacing it with the last element.",46,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"t"}}],[11,"insert","","Inserts an element at position `index` within the vector, shifting all elements after it to the right.",46,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"t"}],"output":null}],[11,"remove","","Removes and returns the element at position `index` within the vector, shifting all elements after it to the left.",46,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"t"}}],[11,"retain","","Retains only the elements specified by the predicate.",46,{"inputs":[{"name":"self"},{"name":"f"}],"output":null}],[11,"dedup_by_key","","Removes consecutive elements in the vector that resolve to the same key.",46,{"inputs":[{"name":"self"},{"name":"f"}],"output":null}],[11,"dedup_by","","Removes consecutive elements in the vector that resolve to the same key.",46,{"inputs":[{"name":"self"},{"name":"f"}],"output":null}],[11,"push","","Appends an element to the back of a collection.",46,{"inputs":[{"name":"self"},{"name":"t"}],"output":null}],[11,"pop","","Removes the last element from a vector and returns it, or [`None`] if it is empty.",46,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"append","","Moves all the elements of `other` into `Self`, leaving `other` empty.",46,{"inputs":[{"name":"self"},{"name":"self"}],"output":null}],[11,"drain","","Create a draining iterator that removes the specified range in the vector and yields the removed items.",46,{"inputs":[{"name":"self"},{"name":"r"}],"output":{"name":"drain"}}],[11,"clear","","Clears the vector, removing all values.",46,{"inputs":[{"name":"self"}],"output":null}],[11,"len","","Returns the number of elements in the vector.",46,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","Returns `true` if the vector contains no elements.",46,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"split_off","","Splits the collection into two at the given index.",46,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"self"}}],[11,"resize","","Resizes the `Vec` in-place so that `len()` is equal to `new_len`.",46,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"t"}],"output":null}],[11,"extend_from_slice","","Clones and appends all elements in a slice to the `Vec`.",46,null],[11,"place_back","","Returns a place for insertion at the back of the `Vec`.",46,{"inputs":[{"name":"self"}],"output":{"name":"placeback"}}],[11,"dedup","","Removes consecutive repeated elements in the vector.",46,{"inputs":[{"name":"self"}],"output":null}],[11,"remove_item","","Removes the first instance of `item` from the vector if the item exists.",46,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"option"}}],[11,"clone","","",46,{"inputs":[{"name":"self"}],"output":{"name":"vec"}}],[11,"clone_from","","",46,{"inputs":[{"name":"self"},{"name":"vec"}],"output":null}],[11,"hash","","",46,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"index","","",46,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"t"}}],[11,"index_mut","","",46,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"t"}}],[11,"index","","",46,null],[11,"index","","",46,null],[11,"index","","",46,null],[11,"index","","",46,null],[11,"index","","",46,null],[11,"index","","",46,null],[11,"index_mut","","",46,null],[11,"index_mut","","",46,null],[11,"index_mut","","",46,null],[11,"index_mut","","",46,null],[11,"index_mut","","",46,null],[11,"index_mut","","",46,null],[11,"deref","","",46,null],[11,"deref_mut","","",46,null],[11,"from_iter","","",46,{"inputs":[{"name":"i"}],"output":{"name":"vec"}}],[11,"into_iter","","Creates a consuming iterator, that is, one that moves each value out of the vector (from start to end). The vector cannot be used after calling this.",46,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"extend","","",46,{"inputs":[{"name":"self"},{"name":"i"}],"output":null}],[11,"extend","","",46,{"inputs":[{"name":"self"},{"name":"i"}],"output":null}],[11,"eq","","",46,{"inputs":[{"name":"self"},{"name":"vec"}],"output":{"name":"bool"}}],[11,"ne","","",46,{"inputs":[{"name":"self"},{"name":"vec"}],"output":{"name":"bool"}}],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","collections::borrow","",10,null],[11,"ne","","",10,null],[11,"eq","","",10,null],[11,"ne","","",10,null],[11,"eq","","",10,{"inputs":[{"name":"self"},{"name":"vec"}],"output":{"name":"bool"}}],[11,"ne","","",10,{"inputs":[{"name":"self"},{"name":"vec"}],"output":{"name":"bool"}}],[11,"eq","collections::vec","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"eq","","",46,null],[11,"ne","","",46,null],[11,"partial_cmp","","",46,{"inputs":[{"name":"self"},{"name":"vec"}],"output":{"name":"option"}}],[11,"cmp","","",46,{"inputs":[{"name":"self"},{"name":"vec"}],"output":{"name":"ordering"}}],[11,"drop","","",46,{"inputs":[{"name":"self"}],"output":null}],[11,"default","","Creates an empty `Vec<T>`.",46,{"inputs":[],"output":{"name":"vec"}}],[11,"fmt","","",46,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"as_ref","","",46,{"inputs":[{"name":"self"}],"output":{"name":"vec"}}],[11,"as_mut","","",46,{"inputs":[{"name":"self"}],"output":{"name":"vec"}}],[11,"as_ref","","",46,null],[11,"as_mut","","",46,null],[11,"from","","",46,null],[11,"from","","",46,{"inputs":[{"name":"cow"}],"output":{"name":"vec"}}],[11,"from","","",46,{"inputs":[{"name":"str"}],"output":{"name":"vec"}}],[11,"from","collections::borrow","",10,null],[11,"from","","",10,{"inputs":[{"name":"vec"}],"output":{"name":"cow"}}],[11,"from_iter","","",10,{"inputs":[{"name":"i"}],"output":{"name":"cow"}}],[11,"fmt","collections::vec","",47,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"as_slice","","Returns the remaining items of this iterator as a slice.",47,null],[11,"as_mut_slice","","Returns the remaining items of this iterator as a mutable slice.",47,null],[11,"next","","",47,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",47,null],[11,"count","","",47,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"next_back","","",47,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"is_empty","","",47,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",47,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"drop","","",47,{"inputs":[{"name":"self"}],"output":null}],[11,"fmt","","",48,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",48,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",48,null],[11,"next_back","","",48,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"drop","","",48,{"inputs":[{"name":"self"}],"output":null}],[11,"is_empty","","",48,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"fmt","","",49,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"make_place","","",49,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"pointer","","",49,null],[11,"finalize","","",49,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[0,"vec_deque","collections","VecDeque is a double-ended queue, which is implemented with the help of a growing ring buffer.",null,null],[3,"VecDeque","collections::vec_deque","`VecDeque` is a growable ring buffer, which can be used as a double-ended queue efficiently.",null,null],[3,"Iter","","`VecDeque` iterator.",null,null],[3,"IterMut","","`VecDeque` mutable iterator.",null,null],[3,"IntoIter","","A by-value VecDeque iterator",null,null],[3,"Drain","","A draining VecDeque iterator",null,null],[3,"PlaceBack","","A place for insertion at the back of a `VecDeque`.",null,null],[3,"PlaceFront","","A place for insertion at the front of a `VecDeque`.",null,null],[11,"clone","","",50,{"inputs":[{"name":"self"}],"output":{"name":"vecdeque"}}],[11,"drop","","",50,{"inputs":[{"name":"self"}],"output":null}],[11,"default","","Creates an empty `VecDeque<T>`.",50,{"inputs":[],"output":{"name":"vecdeque"}}],[11,"new","","Creates an empty `VecDeque`.",50,{"inputs":[],"output":{"name":"vecdeque"}}],[11,"with_capacity","","Creates an empty `VecDeque` with space for at least `n` elements.",50,{"inputs":[{"name":"usize"}],"output":{"name":"vecdeque"}}],[11,"get","","Retrieves an element in the `VecDeque` by index.",50,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"get_mut","","Retrieves an element in the `VecDeque` mutably by index.",50,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"swap","","Swaps elements at indices `i` and `j`.",50,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"usize"}],"output":null}],[11,"capacity","","Returns the number of elements the `VecDeque` can hold without reallocating.",50,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"reserve_exact","","Reserves the minimum capacity for exactly `additional` more elements to be inserted in the given `VecDeque`. Does nothing if the capacity is already sufficient.",50,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"reserve","","Reserves capacity for at least `additional` more elements to be inserted in the given `VecDeque`. The collection may reserve more space to avoid frequent reallocations.",50,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shrink_to_fit","","Shrinks the capacity of the `VecDeque` as much as possible.",50,{"inputs":[{"name":"self"}],"output":null}],[11,"truncate","","Shortens a `VecDeque`, dropping excess elements from the back.",50,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"iter","","Returns a front-to-back iterator.",50,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"iter_mut","","Returns a front-to-back iterator that returns mutable references.",50,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"as_slices","","Returns a pair of slices which contain, in order, the contents of the `VecDeque`.",50,null],[11,"as_mut_slices","","Returns a pair of slices which contain, in order, the contents of the `VecDeque`.",50,null],[11,"len","","Returns the number of elements in the `VecDeque`.",50,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","Returns true if the buffer contains no elements",50,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"drain","","Create a draining iterator that removes the specified range in the `VecDeque` and yields the removed items.",50,{"inputs":[{"name":"self"},{"name":"r"}],"output":{"name":"drain"}}],[11,"clear","","Clears the buffer, removing all values.",50,{"inputs":[{"name":"self"}],"output":null}],[11,"contains","","Returns `true` if the `VecDeque` contains an element equal to the given value.",50,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"bool"}}],[11,"front","","Provides a reference to the front element, or `None` if the sequence is empty.",50,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"front_mut","","Provides a mutable reference to the front element, or `None` if the sequence is empty.",50,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"back","","Provides a reference to the back element, or `None` if the sequence is empty.",50,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"back_mut","","Provides a mutable reference to the back element, or `None` if the sequence is empty.",50,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"pop_front","","Removes the first element and returns it, or `None` if the sequence is empty.",50,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"push_front","","Inserts an element first in the sequence.",50,{"inputs":[{"name":"self"},{"name":"t"}],"output":null}],[11,"push_back","","Appends an element to the back of a buffer",50,{"inputs":[{"name":"self"},{"name":"t"}],"output":null}],[11,"pop_back","","Removes the last element from a buffer and returns it, or `None` if it is empty.",50,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"swap_remove_back","","Removes an element from anywhere in the `VecDeque` and returns it, replacing it with the last element.",50,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"swap_remove_front","","Removes an element from anywhere in the `VecDeque` and returns it, replacing it with the first element.",50,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"insert","","Inserts an element at `index` within the `VecDeque`, shifting all elements with indices greater than or equal to `index` towards the back.",50,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"t"}],"output":null}],[11,"remove","","Removes and returns the element at `index` from the `VecDeque`. Whichever end is closer to the removal point will be moved to make room, and all the affected elements will be moved to new positions. Returns `None` if `index` is out of bounds.",50,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"split_off","","Splits the collection into two at the given index.",50,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"self"}}],[11,"append","","Moves all the elements of `other` into `Self`, leaving `other` empty.",50,{"inputs":[{"name":"self"},{"name":"self"}],"output":null}],[11,"retain","","Retains only the elements specified by the predicate.",50,{"inputs":[{"name":"self"},{"name":"f"}],"output":null}],[11,"place_back","","Returns a place for insertion at the back of the `VecDeque`.",50,{"inputs":[{"name":"self"}],"output":{"name":"placeback"}}],[11,"place_front","","Returns a place for insertion at the front of the `VecDeque`.",50,{"inputs":[{"name":"self"}],"output":{"name":"placefront"}}],[11,"resize","","Modifies the `VecDeque` in-place so that `len()` is equal to new_len, either by removing excess elements or by appending clones of `value` to the back.",50,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"t"}],"output":null}],[11,"fmt","","",51,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",51,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"next","","",51,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",51,null],[11,"fold","","",51,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"f"}],"output":{"name":"acc"}}],[11,"next_back","","",51,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"is_empty","","",51,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"fmt","","",52,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",52,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",52,null],[11,"fold","","",52,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"f"}],"output":{"name":"acc"}}],[11,"next_back","","",52,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"is_empty","","",52,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",53,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"fmt","","",53,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",53,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",53,null],[11,"next_back","","",53,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"is_empty","","",53,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"fmt","","",54,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"drop","","",54,{"inputs":[{"name":"self"}],"output":null}],[11,"next","","",54,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",54,null],[11,"next_back","","",54,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"eq","","",50,{"inputs":[{"name":"self"},{"name":"vecdeque"}],"output":{"name":"bool"}}],[11,"eq","","",50,{"inputs":[{"name":"self"},{"name":"vec"}],"output":{"name":"bool"}}],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"eq","","",50,null],[11,"partial_cmp","","",50,{"inputs":[{"name":"self"},{"name":"vecdeque"}],"output":{"name":"option"}}],[11,"cmp","","",50,{"inputs":[{"name":"self"},{"name":"vecdeque"}],"output":{"name":"ordering"}}],[11,"hash","","",50,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"index","","",50,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"a"}}],[11,"index_mut","","",50,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"a"}}],[11,"from_iter","","",50,{"inputs":[{"name":"t"}],"output":{"name":"vecdeque"}}],[11,"into_iter","","Consumes the list into a front-to-back iterator yielding elements by value.",50,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"extend","","",50,{"inputs":[{"name":"self"},{"name":"t"}],"output":null}],[11,"extend","","",50,{"inputs":[{"name":"self"},{"name":"i"}],"output":null}],[11,"fmt","","",50,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"from","","",50,{"inputs":[{"name":"vec"}],"output":{"name":"self"}}],[11,"from","collections::vec","",46,{"inputs":[{"name":"vecdeque"}],"output":{"name":"self"}}],[11,"fmt","collections::vec_deque","",55,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"make_place","","",55,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"pointer","","",55,null],[11,"finalize","","",55,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"fmt","","",56,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"make_place","","",56,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"pointer","","",56,null],[11,"finalize","","",56,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[0,"btree_map","collections","A map based on a B-Tree.",null,null],[3,"BTreeMap","collections::btree_map","A map based on a B-Tree.",null,null],[3,"Iter","","An iterator over a BTreeMap's entries.",null,null],[3,"IterMut","","A mutable iterator over a BTreeMap's entries.",null,null],[3,"IntoIter","","An owning iterator over a BTreeMap's entries.",null,null],[3,"Keys","","An iterator over a BTreeMap's keys.",null,null],[3,"Values","","An iterator over a BTreeMap's values.",null,null],[3,"ValuesMut","","A mutable iterator over a BTreeMap's values.",null,null],[3,"Range","","An iterator over a sub-range of BTreeMap's entries.",null,null],[3,"RangeMut","","A mutable iterator over a sub-range of BTreeMap's entries.",null,null],[3,"VacantEntry","","A vacant Entry. It is part of the [`Entry`] enum.",null,null],[3,"OccupiedEntry","","An occupied Entry. It is part of the [`Entry`] enum.",null,null],[4,"Entry","","A view into a single entry in a map, which may either be vacant or occupied. This enum is constructed from the [`entry`] method on [`BTreeMap`].",null,null],[13,"Vacant","","A vacant Entry",57,null],[13,"Occupied","","An occupied Entry",57,null],[0,"btree_set","collections","A set based on a B-Tree.",null,null],[3,"BTreeSet","collections::btree_set","A set based on a B-Tree.",null,null],[3,"Iter","","An iterator over a `BTreeSet`'s items.",null,null],[3,"IntoIter","","An owning iterator over a `BTreeSet`'s items.",null,null],[3,"Range","","An iterator over a sub-range of `BTreeSet`'s items.",null,null],[3,"Difference","","A lazy iterator producing elements in the set difference (in-order).",null,null],[3,"SymmetricDifference","","A lazy iterator producing elements in the set symmetric difference (in-order).",null,null],[3,"Intersection","","A lazy iterator producing elements in the set intersection (in-order).",null,null],[3,"Union","","A lazy iterator producing elements in the set union (in-order).",null,null],[11,"clone","collections","",1,{"inputs":[{"name":"self"}],"output":{"name":"bound"}}],[11,"fmt","","",1,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",1,null],[11,"eq","","",1,{"inputs":[{"name":"self"},{"name":"bound"}],"output":{"name":"bool"}}],[11,"ne","","",1,{"inputs":[{"name":"self"},{"name":"bound"}],"output":{"name":"bool"}}],[14,"vec","","Creates a `Vec` containing the arguments.",null,null],[14,"format","","Use the syntax described in `std::fmt` to create a value of type `String`. See [`std::fmt`][fmt] for more information.",null,null],[11,"next","collections::str","",58,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",58,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"eq","collections::str::pattern","",36,{"inputs":[{"name":"self"},{"name":"searchstep"}],"output":{"name":"bool"}}],[11,"ne","","",36,{"inputs":[{"name":"self"},{"name":"searchstep"}],"output":{"name":"bool"}}],[11,"eq","collections::str","",59,{"inputs":[{"name":"self"},{"name":"parseboolerror"}],"output":{"name":"bool"}}],[11,"ne","","",59,{"inputs":[{"name":"self"},{"name":"parseboolerror"}],"output":{"name":"bool"}}],[11,"eq","","",60,{"inputs":[{"name":"self"},{"name":"utf8error"}],"output":{"name":"bool"}}],[11,"ne","","",60,{"inputs":[{"name":"self"},{"name":"utf8error"}],"output":{"name":"bool"}}],[11,"eq","collections::fmt","",61,{"inputs":[{"name":"self"},{"name":"error"}],"output":{"name":"bool"}}],[11,"is_empty","collections::slice","",62,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_empty","","",63,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"len","collections::str","",64,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","",64,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"fmt","","",59,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",60,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::fmt","",65,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",61,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"haystack","collections::str::pattern","",66,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"next","","",66,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match","","",66,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject","","",66,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"haystack","","",67,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"next","","",67,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match","","",67,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject","","",67,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"haystack","","",68,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"next","","",68,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match","","",68,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject","","",68,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"haystack","","",69,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"next","","",69,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match","","",69,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","collections::slice","",70,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",70,null],[11,"next","","",71,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",71,null],[11,"next","","",72,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",72,null],[11,"count","","",72,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"nth","","",72,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",72,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",73,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",73,null],[11,"count","","",73,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"nth","","",73,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",73,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",74,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",74,null],[11,"count","","",74,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"nth","","",74,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",74,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","collections::str","",75,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"count","","",75,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"size_hint","","",75,null],[11,"last","","",75,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",76,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"count","","",76,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"size_hint","","",76,null],[11,"last","","",76,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",64,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",64,null],[11,"count","","",64,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"last","","",64,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"nth","","",64,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"next","","",77,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",77,null],[11,"next","","",78,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",78,null],[11,"next","collections::slice","",62,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",62,null],[11,"count","","",62,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"nth","","",62,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",62,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"all","","",62,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"any","","",62,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"find","","",62,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"position","","",62,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"rposition","","",62,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"next","","",63,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",63,null],[11,"count","","",63,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"nth","","",63,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",63,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"all","","",63,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"any","","",63,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"find","","",63,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"position","","",63,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"rposition","","",63,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"next","","",79,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",79,null],[11,"next","","",80,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",80,null],[11,"next","","",81,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",81,null],[11,"next","","",82,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",82,null],[11,"next","collections::str","",83,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",84,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",85,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",86,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",87,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",88,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",89,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",90,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",91,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",92,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"as_ref","collections::slice","",62,null],[11,"fmt","","",62,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",63,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",70,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",71,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",79,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",80,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",81,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",82,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::str::pattern","",68,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::fmt","",65,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::slice","",72,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",73,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",74,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::str::pattern","",36,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",66,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",67,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",69,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::str","",59,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",60,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",75,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",76,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",64,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",83,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",84,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",85,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",86,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",87,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",88,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",89,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",90,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",91,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",92,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",77,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",78,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","collections::fmt","",61,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next_back","collections::str::pattern","",66,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match_back","","",66,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject_back","","",66,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",67,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match_back","","",67,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject_back","","",67,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",68,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match_back","","",68,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject_back","","",68,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",69,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match_back","","",69,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"cmp","collections::fmt","",61,{"inputs":[{"name":"self"},{"name":"error"}],"output":{"name":"ordering"}}],[11,"clone","collections::slice","",62,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"clone","","",70,{"inputs":[{"name":"self"}],"output":{"name":"split"}}],[11,"clone","","",72,{"inputs":[{"name":"self"}],"output":{"name":"windows"}}],[11,"clone","","",73,{"inputs":[{"name":"self"}],"output":{"name":"chunks"}}],[11,"clone","collections::str::pattern","",36,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"clone","","",66,{"inputs":[{"name":"self"}],"output":{"name":"charsearcher"}}],[11,"clone","","",67,{"inputs":[{"name":"self"}],"output":{"name":"charslicesearcher"}}],[11,"clone","","",68,{"inputs":[{"name":"self"}],"output":{"name":"charpredicatesearcher"}}],[11,"clone","","",69,{"inputs":[{"name":"self"}],"output":{"name":"strsearcher"}}],[11,"clone","collections::str","",59,{"inputs":[{"name":"self"}],"output":{"name":"parseboolerror"}}],[11,"clone","","",60,{"inputs":[{"name":"self"}],"output":{"name":"utf8error"}}],[11,"clone","","",75,{"inputs":[{"name":"self"}],"output":{"name":"chars"}}],[11,"clone","","",76,{"inputs":[{"name":"self"}],"output":{"name":"charindices"}}],[11,"clone","","",64,{"inputs":[{"name":"self"}],"output":{"name":"bytes"}}],[11,"clone","","",83,{"inputs":[{"name":"self"}],"output":{"name":"split"}}],[11,"clone","","",84,{"inputs":[{"name":"self"}],"output":{"name":"rsplit"}}],[11,"clone","","",85,{"inputs":[{"name":"self"}],"output":{"name":"splitterminator"}}],[11,"clone","","",86,{"inputs":[{"name":"self"}],"output":{"name":"rsplitterminator"}}],[11,"clone","","",87,{"inputs":[{"name":"self"}],"output":{"name":"splitn"}}],[11,"clone","","",88,{"inputs":[{"name":"self"}],"output":{"name":"rsplitn"}}],[11,"clone","","",89,{"inputs":[{"name":"self"}],"output":{"name":"matchindices"}}],[11,"clone","","",90,{"inputs":[{"name":"self"}],"output":{"name":"rmatchindices"}}],[11,"clone","","",91,{"inputs":[{"name":"self"}],"output":{"name":"matches"}}],[11,"clone","","",92,{"inputs":[{"name":"self"}],"output":{"name":"rmatches"}}],[11,"clone","","",77,{"inputs":[{"name":"self"}],"output":{"name":"lines"}}],[11,"clone","","",78,{"inputs":[{"name":"self"}],"output":{"name":"linesany"}}],[11,"clone","collections::fmt","",61,{"inputs":[{"name":"self"}],"output":{"name":"error"}}],[11,"clone","","",65,{"inputs":[{"name":"self"}],"output":{"name":"arguments"}}],[11,"hash","","",61,null],[11,"write_str","","",93,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"result"}}],[11,"write_char","","",93,{"inputs":[{"name":"self"},{"name":"char"}],"output":{"name":"result"}}],[11,"write_fmt","","",93,{"inputs":[{"name":"self"},{"name":"arguments"}],"output":{"name":"result"}}],[11,"default","","",61,{"inputs":[],"output":{"name":"error"}}],[11,"partial_cmp","","",61,{"inputs":[{"name":"self"},{"name":"error"}],"output":{"name":"option"}}],[11,"next_back","collections::slice","",70,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",71,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",72,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",73,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",74,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","collections::str","",75,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",76,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",64,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",77,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",78,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","collections::slice","",62,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",63,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","collections::str","",83,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",84,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",85,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",86,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",89,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",90,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",91,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",92,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"as_mut","collections::boxed","",94,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"make_place","","",95,{"inputs":[],"output":{"name":"intermediatebox"}}],[11,"make_place","","",96,{"inputs":[{"name":"self"}],"output":{"name":"intermediatebox"}}],[11,"borrow_mut","","",94,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"fmt","","",94,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"cmp","","",94,{"inputs":[{"name":"self"},{"name":"box"}],"output":{"name":"ordering"}}],[11,"clone","","Returns a new box with a `clone()` of this box's contents.",94,{"inputs":[{"name":"self"}],"output":{"name":"box"}}],[11,"clone_from","","Copies `source`'s contents into `self` without creating a new allocation.",94,null],[11,"clone","","",94,{"inputs":[{"name":"self"}],"output":{"name":"box"}}],[11,"clone","","",94,{"inputs":[{"name":"self"}],"output":{"name":"box"}}],[11,"clone","","",96,{"inputs":[{"name":"self"}],"output":{"name":"exchangeheapsingleton"}}],[11,"next_back","","",94,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"hash","","",94,null],[11,"finalize","","",95,{"inputs":[{"name":"self"}],"output":{"name":"box"}}],[11,"deref","","",94,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"eq","","",94,{"inputs":[{"name":"self"},{"name":"box"}],"output":{"name":"bool"}}],[11,"ne","","",94,{"inputs":[{"name":"self"},{"name":"box"}],"output":{"name":"bool"}}],[11,"pointer","","",95,null],[11,"default","","Creates a `Box<T>`, with the `Default` value for T.",94,{"inputs":[],"output":{"name":"box"}}],[11,"default","","",94,{"inputs":[],"output":{"name":"box"}}],[11,"default","","",94,{"inputs":[],"output":{"name":"box"}}],[11,"partial_cmp","","",94,{"inputs":[{"name":"self"},{"name":"box"}],"output":{"name":"option"}}],[11,"lt","","",94,{"inputs":[{"name":"self"},{"name":"box"}],"output":{"name":"bool"}}],[11,"le","","",94,{"inputs":[{"name":"self"},{"name":"box"}],"output":{"name":"bool"}}],[11,"ge","","",94,{"inputs":[{"name":"self"},{"name":"box"}],"output":{"name":"bool"}}],[11,"gt","","",94,{"inputs":[{"name":"self"},{"name":"box"}],"output":{"name":"bool"}}],[11,"borrow","","",94,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"as_ref","","",94,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"fmt","","",94,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",94,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"deref_mut","","",94,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"finalize","","",94,{"inputs":[{"name":"intermediatebox"}],"output":{"name":"box"}}],[11,"from","","",94,{"inputs":[{"name":"t"}],"output":{"name":"box"}}],[11,"from","","",94,null],[11,"from","","",94,{"inputs":[{"name":"str"}],"output":{"name":"box"}}],[11,"next","","",94,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",94,null],[11,"nth","","",94,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"len","","",94,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","",94,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"call_once","","",94,{"inputs":[{"name":"self"},{"name":"a"}],"output":{"name":"r"}}],[11,"call_once","","",94,{"inputs":[{"name":"self"},{"name":"a"}],"output":{"name":"r"}}],[11,"drop","","",95,null],[11,"drop","","",94,null],[11,"new","","Allocates memory on the heap and then places `x` into it.",94,{"inputs":[{"name":"t"}],"output":{"name":"box"}}],[11,"from_raw","","Constructs a box from a raw pointer.",94,null],[11,"into_raw","","Consumes the `Box`, returning the wrapped raw pointer.",94,null],[11,"downcast","","Attempt to downcast the box to a concrete type.",94,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"downcast","","Attempt to downcast the box to a concrete type.",94,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"from","collections::vec","",46,{"inputs":[{"name":"binaryheap"}],"output":{"name":"vec"}}],[11,"drop","collections::btree_map","",97,{"inputs":[{"name":"self"}],"output":null}],[11,"clone","","",97,{"inputs":[{"name":"self"}],"output":{"name":"btreemap"}}],[11,"fmt","","",98,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",99,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",100,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",101,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",102,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",103,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",104,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",105,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",57,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",106,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",107,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Makes a new empty BTreeMap with a reasonable choice for B.",97,{"inputs":[],"output":{"name":"btreemap"}}],[11,"clear","","Clears the map, removing all values.",97,{"inputs":[{"name":"self"}],"output":null}],[11,"get","","Returns a reference to the value corresponding to the key.",97,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"option"}}],[11,"contains_key","","Returns true if the map contains a value for the specified key.",97,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"bool"}}],[11,"get_mut","","Returns a mutable reference to the value corresponding to the key.",97,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"option"}}],[11,"insert","","Inserts a key-value pair into the map.",97,{"inputs":[{"name":"self"},{"name":"k"},{"name":"v"}],"output":{"name":"option"}}],[11,"remove","","Removes a key from the map, returning the value at the key if the key was previously in the map.",97,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"option"}}],[11,"append","","Moves all elements from `other` into `Self`, leaving `other` empty.",97,{"inputs":[{"name":"self"},{"name":"self"}],"output":null}],[11,"range","","Constructs a double-ended iterator over a sub-range of elements in the map. The simplest way is to use the range syntax `min..max`, thus `range(min..max)` will yield elements from min (inclusive) to max (exclusive). The range may also be entered as `(Bound<T>, Bound<T>)`, so for example `range((Excluded(4), Included(10)))` will yield a left-exclusive, right-inclusive range from 4 to 10.",97,{"inputs":[{"name":"self"},{"name":"r"}],"output":{"name":"range"}}],[11,"range_mut","","Constructs a mutable double-ended iterator over a sub-range of elements in the map. The simplest way is to use the range syntax `min..max`, thus `range(min..max)` will yield elements from min (inclusive) to max (exclusive). The range may also be entered as `(Bound<T>, Bound<T>)`, so for example `range((Excluded(4), Included(10)))` will yield a left-exclusive, right-inclusive range from 4 to 10.",97,{"inputs":[{"name":"self"},{"name":"r"}],"output":{"name":"rangemut"}}],[11,"entry","","Gets the given key's corresponding entry in the map for in-place manipulation.",97,{"inputs":[{"name":"self"},{"name":"k"}],"output":{"name":"entry"}}],[11,"split_off","","Splits the collection into two at the given key. Returns everything after the given key, including the key.",97,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"self"}}],[11,"next","","",98,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",98,null],[11,"next_back","","",98,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"len","","",98,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"clone","","",98,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"next","","",99,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",99,null],[11,"next_back","","",99,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"len","","",99,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"into_iter","","",97,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"drop","","",100,{"inputs":[{"name":"self"}],"output":null}],[11,"next","","",100,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",100,null],[11,"next_back","","",100,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"len","","",100,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"next","","",101,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",101,null],[11,"next_back","","",101,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"len","","",101,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"clone","","",101,{"inputs":[{"name":"self"}],"output":{"name":"keys"}}],[11,"next","","",102,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",102,null],[11,"next_back","","",102,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"len","","",102,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"clone","","",102,{"inputs":[{"name":"self"}],"output":{"name":"values"}}],[11,"next","","",104,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",103,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",103,null],[11,"next_back","","",103,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"len","","",103,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"next_back","","",104,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",104,{"inputs":[{"name":"self"}],"output":{"name":"range"}}],[11,"next","","",105,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",105,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"from_iter","","",97,{"inputs":[{"name":"t"}],"output":{"name":"btreemap"}}],[11,"extend","","",97,{"inputs":[{"name":"self"},{"name":"t"}],"output":null}],[11,"extend","","",97,{"inputs":[{"name":"self"},{"name":"i"}],"output":null}],[11,"hash","","",97,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"default","","Creates an empty `BTreeMap<K, V>`.",97,{"inputs":[],"output":{"name":"btreemap"}}],[11,"eq","","",97,{"inputs":[{"name":"self"},{"name":"btreemap"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",97,{"inputs":[{"name":"self"},{"name":"btreemap"}],"output":{"name":"option"}}],[11,"cmp","","",97,{"inputs":[{"name":"self"},{"name":"btreemap"}],"output":{"name":"ordering"}}],[11,"fmt","","",97,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"index","","",97,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"v"}}],[11,"iter","","Gets an iterator over the entries of the map, sorted by key.",97,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"iter_mut","","Gets a mutable iterator over the entries of the map, sorted by key.",97,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"keys","","Gets an iterator over the keys of the map, in sorted order.",97,{"inputs":[{"name":"self"}],"output":{"name":"keys"}}],[11,"values","","Gets an iterator over the values of the map, in order by key.",97,{"inputs":[{"name":"self"}],"output":{"name":"values"}}],[11,"values_mut","","Gets a mutable iterator over the values of the map, in order by key.",97,{"inputs":[{"name":"self"}],"output":{"name":"valuesmut"}}],[11,"len","","Returns the number of elements in the map.",97,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","Returns true if the map contains no elements.",97,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"or_insert","","Ensures a value is in the entry by inserting the default if empty, and returns a mutable reference to the value in the entry.",57,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"v"}}],[11,"or_insert_with","","Ensures a value is in the entry by inserting the result of the default function if empty, and returns a mutable reference to the value in the entry.",57,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"v"}}],[11,"key","","Returns a reference to this entry's key.",57,{"inputs":[{"name":"self"}],"output":{"name":"k"}}],[11,"key","","Gets a reference to the key that would be used when inserting a value through the VacantEntry.",106,{"inputs":[{"name":"self"}],"output":{"name":"k"}}],[11,"into_key","","Take ownership of the key.",106,{"inputs":[{"name":"self"}],"output":{"name":"k"}}],[11,"insert","","Sets the value of the entry with the `VacantEntry`'s key, and returns a mutable reference to it.",106,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"v"}}],[11,"key","","Gets a reference to the key in the entry.",107,{"inputs":[{"name":"self"}],"output":{"name":"k"}}],[11,"remove_pair","","Deprecated, renamed to `remove_entry`",107,null],[11,"remove_entry","","Take ownership of the key and value from the map.",107,null],[11,"get","","Gets a reference to the value in the entry.",107,{"inputs":[{"name":"self"}],"output":{"name":"v"}}],[11,"get_mut","","Gets a mutable reference to the value in the entry.",107,{"inputs":[{"name":"self"}],"output":{"name":"v"}}],[11,"into_mut","","Converts the entry into a mutable reference to its value.",107,{"inputs":[{"name":"self"}],"output":{"name":"v"}}],[11,"insert","","Sets the value of the entry with the `OccupiedEntry`'s key, and returns the entry's old value.",107,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"v"}}],[11,"remove","","Takes the value of the entry out of the map, and returns it.",107,{"inputs":[{"name":"self"}],"output":{"name":"v"}}],[11,"clone","collections::btree_set","",108,{"inputs":[{"name":"self"}],"output":{"name":"btreeset"}}],[11,"hash","","",108,null],[11,"eq","","",108,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"ne","","",108,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"cmp","","",108,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",108,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"option"}}],[11,"lt","","",108,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"le","","",108,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"gt","","",108,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"ge","","",108,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"fmt","","",109,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",110,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",111,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",112,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",113,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",114,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",115,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Makes a new `BTreeSet` with a reasonable choice of B.",108,{"inputs":[],"output":{"name":"btreeset"}}],[11,"iter","","Gets an iterator that visits the values in the `BTreeSet` in ascending order.",108,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"range","","Constructs a double-ended iterator over a sub-range of elements in the set. The simplest way is to use the range syntax `min..max`, thus `range(min..max)` will yield elements from min (inclusive) to max (exclusive). The range may also be entered as `(Bound<T>, Bound<T>)`, so for example `range((Excluded(4), Included(10)))` will yield a left-exclusive, right-inclusive range from 4 to 10.",108,{"inputs":[{"name":"self"},{"name":"r"}],"output":{"name":"range"}}],[11,"difference","","Visits the values representing the difference, i.e. the values that are in `self` but not in `other`, in ascending order.",108,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"difference"}}],[11,"symmetric_difference","","Visits the values representing the symmetric difference, i.e. the values that are in `self` or in `other` but not in both, in ascending order.",108,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"symmetricdifference"}}],[11,"intersection","","Visits the values representing the intersection, i.e. the values that are both in `self` and `other`, in ascending order.",108,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"intersection"}}],[11,"union","","Visits the values representing the union, i.e. all the values in `self` or `other`, without duplicates, in ascending order.",108,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"union"}}],[11,"len","","Returns the number of elements in the set.",108,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","Returns true if the set contains no elements.",108,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clear","","Clears the set, removing all values.",108,{"inputs":[{"name":"self"}],"output":null}],[11,"contains","","Returns `true` if the set contains a value.",108,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"bool"}}],[11,"get","","Returns a reference to the value in the set, if any, that is equal to the given value.",108,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"option"}}],[11,"is_disjoint","","Returns `true` if `self` has no elements in common with `other`. This is equivalent to checking for an empty intersection.",108,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"is_subset","","Returns `true` if the set is a subset of another, i.e. `other` contains at least all the values in `self`.",108,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"is_superset","","Returns `true` if the set is a superset of another, i.e. `self` contains at least all the values in `other`.",108,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"insert","","Adds a value to the set.",108,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"bool"}}],[11,"replace","","Adds a value to the set, replacing the existing value, if any, that is equal to the given one. Returns the replaced value.",108,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"option"}}],[11,"remove","","Removes a value from the set. Returns `true` if the value was present in the set.",108,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"bool"}}],[11,"take","","Removes and returns the value in the set, if any, that is equal to the given one.",108,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"option"}}],[11,"append","","Moves all elements from `other` into `Self`, leaving `other` empty.",108,{"inputs":[{"name":"self"},{"name":"self"}],"output":null}],[11,"split_off","","Splits the collection into two at the given key. Returns everything after the given key, including the key.",108,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"self"}}],[11,"from_iter","","",108,{"inputs":[{"name":"i"}],"output":{"name":"btreeset"}}],[11,"into_iter","","Gets an iterator for moving out the BtreeSet's contents.",108,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"extend","","",108,{"inputs":[{"name":"self"},{"name":"iter"}],"output":null}],[11,"extend","","",108,{"inputs":[{"name":"self"},{"name":"i"}],"output":null}],[11,"default","","Makes an empty `BTreeSet<T>` with a reasonable choice of B.",108,{"inputs":[],"output":{"name":"btreeset"}}],[11,"fmt","","",108,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",109,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"next","","",109,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",109,null],[11,"next_back","","",109,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"len","","",109,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"next","","",110,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",110,null],[11,"next_back","","",110,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"len","","",110,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"clone","","",111,{"inputs":[{"name":"self"}],"output":{"name":"range"}}],[11,"next","","",111,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",111,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",112,{"inputs":[{"name":"self"}],"output":{"name":"difference"}}],[11,"next","","",112,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",112,null],[11,"clone","","",113,{"inputs":[{"name":"self"}],"output":{"name":"symmetricdifference"}}],[11,"next","","",113,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",113,null],[11,"clone","","",114,{"inputs":[{"name":"self"}],"output":{"name":"intersection"}}],[11,"next","","",114,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",114,null],[11,"clone","","",115,{"inputs":[{"name":"self"}],"output":{"name":"union"}}],[11,"next","","",115,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",115,null],[11,"pad_integral","collections::fmt","Performs the correct padding for an integer which has already been emitted into a str. The str should *not* contain the sign for the integer, that will be added by this method.",93,{"inputs":[{"name":"self"},{"name":"bool"},{"name":"str"},{"name":"str"}],"output":{"name":"result"}}],[11,"pad","","This function takes a string slice and emits it to the internal buffer after applying the relevant formatting flags specified. The flags recognized for generic strings are:",93,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"result"}}],[11,"write_str","","Writes some data to the underlying buffer contained within this formatter.",93,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"result"}}],[11,"write_fmt","","Writes some formatted information into this instance",93,{"inputs":[{"name":"self"},{"name":"arguments"}],"output":{"name":"result"}}],[11,"flags","","Flags for formatting (packed version of rt::Flag)",93,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"fill","","Character used as 'fill' whenever there is alignment",93,{"inputs":[{"name":"self"}],"output":{"name":"char"}}],[11,"align","","Flag indicating what form of alignment was requested",93,{"inputs":[{"name":"self"}],"output":{"name":"alignment"}}],[11,"width","","Optionally specified integer width that the output should be",93,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"precision","","Optionally specified precision for numeric types",93,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"sign_plus","","Determines if the `+` flag was specified.",93,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"sign_minus","","Determines if the `-` flag was specified.",93,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"alternate","","Determines if the `#` flag was specified.",93,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"sign_aware_zero_pad","","Determines if the `0` flag was specified.",93,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"debug_struct","","Creates a `DebugStruct` builder designed to assist with creation of `fmt::Debug` implementations for structs.",93,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"debugstruct"}}],[11,"debug_tuple","","Creates a `DebugTuple` builder designed to assist with creation of `fmt::Debug` implementations for tuple structs.",93,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"debugtuple"}}],[11,"debug_list","","Creates a `DebugList` builder designed to assist with creation of `fmt::Debug` implementations for list-like structures.",93,{"inputs":[{"name":"self"}],"output":{"name":"debuglist"}}],[11,"debug_set","","Creates a `DebugSet` builder designed to assist with creation of `fmt::Debug` implementations for set-like structures.",93,{"inputs":[{"name":"self"}],"output":{"name":"debugset"}}],[11,"debug_map","","Creates a `DebugMap` builder designed to assist with creation of `fmt::Debug` implementations for map-like structures.",93,{"inputs":[{"name":"self"}],"output":{"name":"debugmap"}}],[11,"entry","","Adds a new entry to the list output.",116,{"inputs":[{"name":"self"},{"name":"debug"}],"output":{"name":"debuglist"}}],[11,"entries","","Adds the contents of an iterator of entries to the list output.",116,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"debuglist"}}],[11,"finish","","Finishes output and returns any error encountered.",116,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"entry","","Adds a new entry to the map output.",117,{"inputs":[{"name":"self"},{"name":"debug"},{"name":"debug"}],"output":{"name":"debugmap"}}],[11,"entries","","Adds the contents of an iterator of entries to the map output.",117,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"debugmap"}}],[11,"finish","","Finishes output and returns any error encountered.",117,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"entry","","Adds a new entry to the set output.",118,{"inputs":[{"name":"self"},{"name":"debug"}],"output":{"name":"debugset"}}],[11,"entries","","Adds the contents of an iterator of entries to the set output.",118,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"debugset"}}],[11,"finish","","Finishes output and returns any error encountered.",118,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"field","","Adds a new field to the generated struct output.",119,{"inputs":[{"name":"self"},{"name":"str"},{"name":"debug"}],"output":{"name":"debugstruct"}}],[11,"finish","","Finishes output and returns any error encountered.",119,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"field","","Adds a new field to the generated tuple struct output.",120,{"inputs":[{"name":"self"},{"name":"debug"}],"output":{"name":"debugtuple"}}],[11,"finish","","Finishes output and returns any error encountered.",120,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"as_slice","collections::slice","View the underlying data as a subslice of the original data.",62,null],[11,"into_slice","","View the underlying data as a subslice of the original data.",63,null],[11,"borrow","collections::vec","",46,null],[11,"borrow_mut","","",46,null],[11,"valid_up_to","collections::str","Returns the index in the given string up to which valid UTF-8 was verified.",60,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"as_str","","View the underlying data as a subslice of the original data.",75,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"as_str","","View the underlying data as a subslice of the original data.",76,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"borrow","collections::string","",41,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"from","collections::vec","",46,{"inputs":[{"name":"string"}],"output":{"name":"vec"}}]],"paths":[[8,"FnBox"],[4,"Bound"],[3,"PeekMut"],[3,"BinaryHeap"],[3,"Iter"],[3,"IntoIter"],[3,"Drain"],[3,"BinaryHeapPlace"],[8,"Borrow"],[8,"BorrowMut"],[4,"Cow"],[8,"ToOwned"],[8,"CLike"],[3,"EnumSet"],[3,"Iter"],[8,"Write"],[8,"Octal"],[8,"Binary"],[8,"Display"],[8,"Debug"],[8,"LowerHex"],[8,"UpperHex"],[8,"Pointer"],[8,"LowerExp"],[8,"UpperExp"],[3,"Iter"],[3,"IterMut"],[3,"IntoIter"],[3,"LinkedList"],[3,"FrontPlace"],[3,"BackPlace"],[8,"RangeArgument"],[8,"SliceIndex"],[8,"SliceConcatExt"],[8,"FromStr"],[8,"Pattern"],[4,"SearchStep"],[8,"Searcher"],[8,"ReverseSearcher"],[3,"EncodeUtf16"],[8,"ToString"],[3,"String"],[3,"FromUtf8Error"],[3,"FromUtf16Error"],[4,"ParseError"],[3,"Drain"],[3,"Vec"],[3,"IntoIter"],[3,"Drain"],[3,"PlaceBack"],[3,"VecDeque"],[3,"Iter"],[3,"IterMut"],[3,"IntoIter"],[3,"Drain"],[3,"PlaceBack"],[3,"PlaceFront"],[4,"Entry"],[3,"SplitWhitespace"],[3,"ParseBoolError"],[3,"Utf8Error"],[3,"Error"],[3,"Iter"],[3,"IterMut"],[3,"Bytes"],[3,"Arguments"],[3,"CharSearcher"],[3,"CharSliceSearcher"],[3,"CharPredicateSearcher"],[3,"StrSearcher"],[3,"Split"],[3,"SplitMut"],[3,"Windows"],[3,"Chunks"],[3,"ChunksMut"],[3,"Chars"],[3,"CharIndices"],[3,"Lines"],[3,"LinesAny"],[3,"SplitN"],[3,"RSplitN"],[3,"SplitNMut"],[3,"RSplitNMut"],[3,"Split"],[3,"RSplit"],[3,"SplitTerminator"],[3,"RSplitTerminator"],[3,"SplitN"],[3,"RSplitN"],[3,"MatchIndices"],[3,"RMatchIndices"],[3,"Matches"],[3,"RMatches"],[3,"Formatter"],[3,"Box"],[3,"IntermediateBox"],[3,"ExchangeHeapSingleton"],[3,"BTreeMap"],[3,"Iter"],[3,"IterMut"],[3,"IntoIter"],[3,"Keys"],[3,"Values"],[3,"ValuesMut"],[3,"Range"],[3,"RangeMut"],[3,"VacantEntry"],[3,"OccupiedEntry"],[3,"BTreeSet"],[3,"Iter"],[3,"IntoIter"],[3,"Range"],[3,"Difference"],[3,"SymmetricDifference"],[3,"Intersection"],[3,"Union"],[3,"DebugList"],[3,"DebugMap"],[3,"DebugSet"],[3,"DebugStruct"],[3,"DebugTuple"]]};
searchIndex["core"] = {"doc":"The Rust Core Library","items":[[0,"isize","core","The pointer-sized signed integer type.",null,null],[17,"MIN","core::isize","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"i8","core","The 8-bit signed integer type.",null,null],[17,"MIN","core::i8","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"i16","core","The 16-bit signed integer type.",null,null],[17,"MIN","core::i16","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"i32","core","The 32-bit signed integer type.",null,null],[17,"MIN","core::i32","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"i64","core","The 64-bit signed integer type.",null,null],[17,"MIN","core::i64","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"i128","core","The 128-bit signed integer type.",null,null],[17,"MIN","core::i128","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"usize","core","The pointer-sized unsigned integer type.",null,null],[17,"MIN","core::usize","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"u8","core","The 8-bit unsigned integer type.",null,null],[17,"MIN","core::u8","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"u16","core","The 16-bit unsigned integer type.",null,null],[17,"MIN","core::u16","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"u32","core","The 32-bit unsigned integer type.",null,null],[17,"MIN","core::u32","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"u64","core","The 64-bit unsigned integer type.",null,null],[17,"MIN","core::u64","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"u128","core","The 128-bit unsigned integer type.",null,null],[17,"MIN","core::u128","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"f32","core","Operations and constants for 32-bits floats (`f32` type)",null,null],[0,"consts","core::f32","Basic mathematical constants.",null,null],[17,"PI","core::f32::consts","Archimedes' constant (π)",null,null],[17,"FRAC_PI_2","","π/2",null,null],[17,"FRAC_PI_3","","π/3",null,null],[17,"FRAC_PI_4","","π/4",null,null],[17,"FRAC_PI_6","","π/6",null,null],[17,"FRAC_PI_8","","π/8",null,null],[17,"FRAC_1_PI","","1/π",null,null],[17,"FRAC_2_PI","","2/π",null,null],[17,"FRAC_2_SQRT_PI","","2/sqrt(π)",null,null],[17,"SQRT_2","","sqrt(2)",null,null],[17,"FRAC_1_SQRT_2","","1/sqrt(2)",null,null],[17,"E","","Euler's number (e)",null,null],[17,"LOG2_E","","log<sub>2</sub>(e)",null,null],[17,"LOG10_E","","log<sub>10</sub>(e)",null,null],[17,"LN_2","","ln(2)",null,null],[17,"LN_10","","ln(10)",null,null],[17,"RADIX","core::f32","The radix or base of the internal representation of `f32`.",null,null],[17,"MANTISSA_DIGITS","","Number of significant digits in base 2.",null,null],[17,"DIGITS","","Approximate number of significant digits in base 10.",null,null],[17,"EPSILON","","Difference between `1.0` and the next largest representable number.",null,null],[17,"MIN","","Smallest finite `f32` value.",null,null],[17,"MIN_POSITIVE","","Smallest positive normal `f32` value.",null,null],[17,"MAX","","Largest finite `f32` value.",null,null],[17,"MIN_EXP","","One greater than the minimum possible normal power of 2 exponent.",null,null],[17,"MAX_EXP","","Maximum possible power of 2 exponent.",null,null],[17,"MIN_10_EXP","","Minimum possible normal power of 10 exponent.",null,null],[17,"MAX_10_EXP","","Maximum possible power of 10 exponent.",null,null],[17,"NAN","","Not a Number (NaN).",null,null],[17,"INFINITY","","Infinity (∞).",null,null],[17,"NEG_INFINITY","","Negative infinity (-∞).",null,null],[0,"f64","core","Operations and constants for 64-bits floats (`f64` type)",null,null],[0,"consts","core::f64","Basic mathematical constants.",null,null],[17,"PI","core::f64::consts","Archimedes' constant (π)",null,null],[17,"FRAC_PI_2","","π/2",null,null],[17,"FRAC_PI_3","","π/3",null,null],[17,"FRAC_PI_4","","π/4",null,null],[17,"FRAC_PI_6","","π/6",null,null],[17,"FRAC_PI_8","","π/8",null,null],[17,"FRAC_1_PI","","1/π",null,null],[17,"FRAC_2_PI","","2/π",null,null],[17,"FRAC_2_SQRT_PI","","2/sqrt(π)",null,null],[17,"SQRT_2","","sqrt(2)",null,null],[17,"FRAC_1_SQRT_2","","1/sqrt(2)",null,null],[17,"E","","Euler's number (e)",null,null],[17,"LOG2_E","","log<sub>2</sub>(e)",null,null],[17,"LOG10_E","","log<sub>10</sub>(e)",null,null],[17,"LN_2","","ln(2)",null,null],[17,"LN_10","","ln(10)",null,null],[17,"RADIX","core::f64","The radix or base of the internal representation of `f64`.",null,null],[17,"MANTISSA_DIGITS","","Number of significant digits in base 2.",null,null],[17,"DIGITS","","Approximate number of significant digits in base 10.",null,null],[17,"EPSILON","","Difference between `1.0` and the next largest representable number.",null,null],[17,"MIN","","Smallest finite `f64` value.",null,null],[17,"MIN_POSITIVE","","Smallest positive normal `f64` value.",null,null],[17,"MAX","","Largest finite `f64` value.",null,null],[17,"MIN_EXP","","One greater than the minimum possible normal power of 2 exponent.",null,null],[17,"MAX_EXP","","Maximum possible power of 2 exponent.",null,null],[17,"MIN_10_EXP","","Minimum possible normal power of 10 exponent.",null,null],[17,"MAX_10_EXP","","Maximum possible power of 10 exponent.",null,null],[17,"NAN","","Not a Number (NaN).",null,null],[17,"INFINITY","","Infinity (∞).",null,null],[17,"NEG_INFINITY","","Negative infinity (-∞).",null,null],[0,"num","core","Numeric traits and functions for the built-in numeric types.",null,null],[3,"Wrapping","core::num","Provides intentionally-wrapped arithmetic on `T`.",null,null],[12,"0","","",0,null],[3,"TryFromIntError","","The error type returned when a checked integral type conversion fails.",null,null],[3,"ParseIntError","","An error which can be returned when parsing an integer.",null,null],[3,"ParseFloatError","","An error which can be returned when parsing a float.",null,null],[4,"FpCategory","","A classification of floating point numbers.",null,null],[13,"Nan","","\"Not a Number\", often obtained by dividing by zero.",1,null],[13,"Infinite","","Positive or negative infinity.",1,null],[13,"Zero","","Positive or negative zero.",1,null],[13,"Subnormal","","De-normalized floating point representation (less precise than `Normal`).",1,null],[13,"Normal","","A regular floating point number.",1,null],[11,"shl","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shl_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shr","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shr_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shl","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shl_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shr","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shr_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shl","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shl_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shr","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shr_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shl","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shl_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shr","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shr_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shl","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shl_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shr","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shr_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shl","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shl_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shr","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shr_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shl","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shl_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shr","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shr_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shl","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shl_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shr","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shr_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shl","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shl_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shr","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shr_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shl","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shl_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shr","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shr_assign","","",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"add","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add","","",0,null],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"sub","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"sub","","",0,null],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"mul","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul","","",0,null],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"div","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"div","","",0,null],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"rem","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"rem","","",0,null],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"not","","",0,{"inputs":[{"name":"self"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitor","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitand","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"neg","","",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"add","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add","","",0,null],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"sub","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"sub","","",0,null],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"mul","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul","","",0,null],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"div","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"div","","",0,null],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"rem","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"rem","","",0,null],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"not","","",0,{"inputs":[{"name":"self"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitor","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitand","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"neg","","",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"add","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add","","",0,null],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"sub","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"sub","","",0,null],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"mul","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul","","",0,null],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"div","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"div","","",0,null],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"rem","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"rem","","",0,null],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"not","","",0,{"inputs":[{"name":"self"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitor","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitand","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"neg","","",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"add","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add","","",0,null],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"sub","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"sub","","",0,null],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"mul","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul","","",0,null],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"div","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"div","","",0,null],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"rem","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"rem","","",0,null],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"not","","",0,{"inputs":[{"name":"self"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitor","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitand","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"neg","","",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"add","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add","","",0,null],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"sub","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"sub","","",0,null],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"mul","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul","","",0,null],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"div","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"div","","",0,null],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"rem","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"rem","","",0,null],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"not","","",0,{"inputs":[{"name":"self"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitor","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitand","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"neg","","",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"add","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add","","",0,null],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"sub","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"sub","","",0,null],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"mul","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul","","",0,null],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"div","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"div","","",0,null],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"rem","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"rem","","",0,null],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"not","","",0,{"inputs":[{"name":"self"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitor","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitand","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"neg","","",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"add","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add","","",0,null],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"sub","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"sub","","",0,null],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"mul","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul","","",0,null],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"div","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"div","","",0,null],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"rem","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"rem","","",0,null],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"not","","",0,{"inputs":[{"name":"self"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitor","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitand","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"neg","","",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"add","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add","","",0,null],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"sub","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"sub","","",0,null],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"mul","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul","","",0,null],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"div","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"div","","",0,null],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"rem","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"rem","","",0,null],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"not","","",0,{"inputs":[{"name":"self"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitor","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitand","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"neg","","",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"add","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add","","",0,null],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"sub","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"sub","","",0,null],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"mul","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul","","",0,null],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"div","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"div","","",0,null],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"rem","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"rem","","",0,null],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"not","","",0,{"inputs":[{"name":"self"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitor","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitand","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"neg","","",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"add","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add","","",0,null],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"sub","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"sub","","",0,null],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"mul","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul","","",0,null],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"div","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"div","","",0,null],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"rem","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"rem","","",0,null],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"not","","",0,{"inputs":[{"name":"self"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitor","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitand","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"neg","","",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"add","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add","","",0,null],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"sub","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"sub","","",0,null],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"mul","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul","","",0,null],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"div","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"div","","",0,null],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"rem","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"rem","","",0,null],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"not","","",0,{"inputs":[{"name":"self"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitor","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitand","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"neg","","",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"add","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add","","",0,null],[11,"add_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"sub","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"sub","","",0,null],[11,"sub_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"mul","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul","","",0,null],[11,"mul_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"div","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"div","","",0,null],[11,"div_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"rem","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"rem","","",0,null],[11,"rem_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"not","","",0,{"inputs":[{"name":"self"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitor","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"bitand","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":null}],[11,"neg","","",0,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"fmt","","",2,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",2,{"inputs":[{"name":"self"}],"output":{"name":"parsefloaterror"}}],[11,"eq","","",2,{"inputs":[{"name":"self"},{"name":"parsefloaterror"}],"output":{"name":"bool"}}],[11,"ne","","",2,{"inputs":[{"name":"self"},{"name":"parsefloaterror"}],"output":{"name":"bool"}}],[11,"fmt","","",2,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"Zero","","Types that have a \"zero\" value.",null,null],[10,"zero","","The \"zero\" (usually, additive identity) for this type.",3,{"inputs":[],"output":{"name":"self"}}],[8,"One","","Types that have a \"one\" value.",null,null],[10,"one","","The \"one\" (usually, multiplicative identity) for this type.",4,{"inputs":[],"output":{"name":"self"}}],[11,"eq","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"bool"}}],[11,"ne","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"option"}}],[11,"lt","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"bool"}}],[11,"le","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"bool"}}],[11,"gt","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"bool"}}],[11,"ge","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"bool"}}],[11,"cmp","","",0,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"ordering"}}],[11,"clone","","",0,{"inputs":[{"name":"self"}],"output":{"name":"wrapping"}}],[11,"default","","",0,{"inputs":[],"output":{"name":"wrapping"}}],[11,"hash","","",0,null],[11,"fmt","","",0,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",0,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",0,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",0,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",0,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",0,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",1,{"inputs":[{"name":"self"}],"output":{"name":"fpcategory"}}],[11,"eq","","",1,{"inputs":[{"name":"self"},{"name":"fpcategory"}],"output":{"name":"bool"}}],[11,"fmt","","",1,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",5,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",5,{"inputs":[{"name":"self"}],"output":{"name":"tryfrominterror"}}],[11,"fmt","","",5,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",6,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",6,{"inputs":[{"name":"self"}],"output":{"name":"parseinterror"}}],[11,"eq","","",6,{"inputs":[{"name":"self"},{"name":"parseinterror"}],"output":{"name":"bool"}}],[11,"ne","","",6,{"inputs":[{"name":"self"},{"name":"parseinterror"}],"output":{"name":"bool"}}],[11,"fmt","","",6,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[0,"prelude","core","The libcore prelude",null,null],[0,"v1","core::prelude","The core prelude",null,null],[0,"intrinsics","core","rustc compiler intrinsics.",null,null],[5,"atomic_cxchg","core::intrinsics","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::SeqCst` as both the `success` and `failure` parameters. For example, `AtomicBool::compare_exchange`.",null,null],[5,"atomic_cxchg_acq","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::Acquire` as both the `success` and `failure` parameters. For example, `AtomicBool::compare_exchange`.",null,null],[5,"atomic_cxchg_rel","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::Release` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, `AtomicBool::compare_exchange`.",null,null],[5,"atomic_cxchg_acqrel","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::AcqRel` as the `success` and `Ordering::Acquire` as the `failure` parameters. For example, `AtomicBool::compare_exchange`.",null,null],[5,"atomic_cxchg_relaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::Relaxed` as both the `success` and `failure` parameters. For example, `AtomicBool::compare_exchange`.",null,null],[5,"atomic_cxchg_failrelaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::SeqCst` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, `AtomicBool::compare_exchange`.",null,null],[5,"atomic_cxchg_failacq","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::SeqCst` as the `success` and `Ordering::Acquire` as the `failure` parameters. For example, `AtomicBool::compare_exchange`.",null,null],[5,"atomic_cxchg_acq_failrelaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::Acquire` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, `AtomicBool::compare_exchange`.",null,null],[5,"atomic_cxchg_acqrel_failrelaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::AcqRel` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, `AtomicBool::compare_exchange`.",null,null],[5,"atomic_cxchgweak","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::SeqCst` as both the `success` and `failure` parameters. For example, `AtomicBool::compare_exchange_weak`.",null,null],[5,"atomic_cxchgweak_acq","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::Acquire` as both the `success` and `failure` parameters. For example, `AtomicBool::compare_exchange_weak`.",null,null],[5,"atomic_cxchgweak_rel","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::Release` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, `AtomicBool::compare_exchange_weak`.",null,null],[5,"atomic_cxchgweak_acqrel","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::AcqRel` as the `success` and `Ordering::Acquire` as the `failure` parameters. For example, `AtomicBool::compare_exchange_weak`.",null,null],[5,"atomic_cxchgweak_relaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::Relaxed` as both the `success` and `failure` parameters. For example, `AtomicBool::compare_exchange_weak`.",null,null],[5,"atomic_cxchgweak_failrelaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::SeqCst` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, `AtomicBool::compare_exchange_weak`.",null,null],[5,"atomic_cxchgweak_failacq","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::SeqCst` as the `success` and `Ordering::Acquire` as the `failure` parameters. For example, `AtomicBool::compare_exchange_weak`.",null,null],[5,"atomic_cxchgweak_acq_failrelaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::Acquire` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, `AtomicBool::compare_exchange_weak`.",null,null],[5,"atomic_cxchgweak_acqrel_failrelaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::AcqRel` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, `AtomicBool::compare_exchange_weak`.",null,null],[5,"atomic_load","","Loads the current value of the pointer. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `load` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::load`.",null,null],[5,"atomic_load_acq","","Loads the current value of the pointer. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `load` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicBool::load`.",null,null],[5,"atomic_load_relaxed","","Loads the current value of the pointer. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `load` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::load`.",null,null],[5,"atomic_load_unordered","","",null,null],[5,"atomic_store","","Stores the value at the specified memory location. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `store` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::store`.",null,null],[5,"atomic_store_rel","","Stores the value at the specified memory location. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `store` method by passing `Ordering::Release` as the `order`. For example, `AtomicBool::store`.",null,null],[5,"atomic_store_relaxed","","Stores the value at the specified memory location. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `store` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::store`.",null,null],[5,"atomic_store_unordered","","",null,null],[5,"atomic_xchg","","Stores the value at the specified memory location, returning the old value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `swap` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::swap`.",null,null],[5,"atomic_xchg_acq","","Stores the value at the specified memory location, returning the old value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `swap` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicBool::swap`.",null,null],[5,"atomic_xchg_rel","","Stores the value at the specified memory location, returning the old value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `swap` method by passing `Ordering::Release` as the `order`. For example, `AtomicBool::swap`.",null,null],[5,"atomic_xchg_acqrel","","Stores the value at the specified memory location, returning the old value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `swap` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicBool::swap`.",null,null],[5,"atomic_xchg_relaxed","","Stores the value at the specified memory location, returning the old value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `swap` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::swap`.",null,null],[5,"atomic_xadd","","Add to the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_add` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicIsize::fetch_add`.",null,null],[5,"atomic_xadd_acq","","Add to the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_add` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicIsize::fetch_add`.",null,null],[5,"atomic_xadd_rel","","Add to the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_add` method by passing `Ordering::Release` as the `order`. For example, `AtomicIsize::fetch_add`.",null,null],[5,"atomic_xadd_acqrel","","Add to the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_add` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicIsize::fetch_add`.",null,null],[5,"atomic_xadd_relaxed","","Add to the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_add` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicIsize::fetch_add`.",null,null],[5,"atomic_xsub","","Subtract from the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_sub` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicIsize::fetch_sub`.",null,null],[5,"atomic_xsub_acq","","Subtract from the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_sub` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicIsize::fetch_sub`.",null,null],[5,"atomic_xsub_rel","","Subtract from the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_sub` method by passing `Ordering::Release` as the `order`. For example, `AtomicIsize::fetch_sub`.",null,null],[5,"atomic_xsub_acqrel","","Subtract from the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_sub` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicIsize::fetch_sub`.",null,null],[5,"atomic_xsub_relaxed","","Subtract from the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_sub` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicIsize::fetch_sub`.",null,null],[5,"atomic_and","","Bitwise and with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_and` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::fetch_and`.",null,null],[5,"atomic_and_acq","","Bitwise and with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_and` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicBool::fetch_and`.",null,null],[5,"atomic_and_rel","","Bitwise and with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_and` method by passing `Ordering::Release` as the `order`. For example, `AtomicBool::fetch_and`.",null,null],[5,"atomic_and_acqrel","","Bitwise and with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_and` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicBool::fetch_and`.",null,null],[5,"atomic_and_relaxed","","Bitwise and with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_and` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::fetch_and`.",null,null],[5,"atomic_nand","","Bitwise nand with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic::AtomicBool` type via the `fetch_nand` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::fetch_nand`.",null,null],[5,"atomic_nand_acq","","Bitwise nand with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic::AtomicBool` type via the `fetch_nand` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicBool::fetch_nand`.",null,null],[5,"atomic_nand_rel","","Bitwise nand with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic::AtomicBool` type via the `fetch_nand` method by passing `Ordering::Release` as the `order`. For example, `AtomicBool::fetch_nand`.",null,null],[5,"atomic_nand_acqrel","","Bitwise nand with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic::AtomicBool` type via the `fetch_nand` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicBool::fetch_nand`.",null,null],[5,"atomic_nand_relaxed","","Bitwise nand with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic::AtomicBool` type via the `fetch_nand` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::fetch_nand`.",null,null],[5,"atomic_or","","Bitwise or with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_or` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::fetch_or`.",null,null],[5,"atomic_or_acq","","Bitwise or with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_or` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicBool::fetch_or`.",null,null],[5,"atomic_or_rel","","Bitwise or with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_or` method by passing `Ordering::Release` as the `order`. For example, `AtomicBool::fetch_or`.",null,null],[5,"atomic_or_acqrel","","Bitwise or with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_or` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicBool::fetch_or`.",null,null],[5,"atomic_or_relaxed","","Bitwise or with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_or` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::fetch_or`.",null,null],[5,"atomic_xor","","Bitwise xor with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_xor` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::fetch_xor`.",null,null],[5,"atomic_xor_acq","","Bitwise xor with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_xor` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicBool::fetch_xor`.",null,null],[5,"atomic_xor_rel","","Bitwise xor with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_xor` method by passing `Ordering::Release` as the `order`. For example, `AtomicBool::fetch_xor`.",null,null],[5,"atomic_xor_acqrel","","Bitwise xor with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_xor` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicBool::fetch_xor`.",null,null],[5,"atomic_xor_relaxed","","Bitwise xor with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_xor` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::fetch_xor`.",null,null],[5,"atomic_max","","",null,null],[5,"atomic_max_acq","","",null,null],[5,"atomic_max_rel","","",null,null],[5,"atomic_max_acqrel","","",null,null],[5,"atomic_max_relaxed","","",null,null],[5,"atomic_min","","",null,null],[5,"atomic_min_acq","","",null,null],[5,"atomic_min_rel","","",null,null],[5,"atomic_min_acqrel","","",null,null],[5,"atomic_min_relaxed","","",null,null],[5,"atomic_umin","","",null,null],[5,"atomic_umin_acq","","",null,null],[5,"atomic_umin_rel","","",null,null],[5,"atomic_umin_acqrel","","",null,null],[5,"atomic_umin_relaxed","","",null,null],[5,"atomic_umax","","",null,null],[5,"atomic_umax_acq","","",null,null],[5,"atomic_umax_rel","","",null,null],[5,"atomic_umax_acqrel","","",null,null],[5,"atomic_umax_relaxed","","",null,null],[5,"atomic_fence","","",null,null],[5,"atomic_fence_acq","","",null,null],[5,"atomic_fence_rel","","",null,null],[5,"atomic_fence_acqrel","","",null,null],[5,"atomic_singlethreadfence","","A compiler-only memory barrier.",null,null],[5,"atomic_singlethreadfence_acq","","",null,null],[5,"atomic_singlethreadfence_rel","","",null,null],[5,"atomic_singlethreadfence_acqrel","","",null,null],[5,"rustc_peek","","Magic intrinsic that derives its meaning from attributes attached to the function.",null,null],[5,"abort","","Aborts the execution of the process.",null,null],[5,"unreachable","","Tells LLVM that this point in the code is not reachable, enabling further optimizations.",null,null],[5,"assume","","Informs the optimizer that a condition is always true. If the condition is false, the behavior is undefined.",null,null],[5,"likely","","Hints to the compiler that branch condition is likely to be true. Returns the value passed to it.",null,null],[5,"unlikely","","Hints to the compiler that branch condition is likely to be false. Returns the value passed to it.",null,null],[5,"breakpoint","","Executes a breakpoint trap, for inspection by a debugger.",null,null],[5,"size_of","","The size of a type in bytes.",null,null],[5,"move_val_init","","Moves a value to an uninitialized memory location.",null,null],[5,"min_align_of","","",null,null],[5,"pref_align_of","","",null,null],[5,"size_of_val","","",null,null],[5,"min_align_of_val","","",null,null],[5,"drop_in_place","","Executes the destructor (if any) of the pointed-to value.",null,null],[5,"type_name","","Gets a static string slice containing the name of a type.",null,null],[5,"type_id","","Gets an identifier which is globally unique to the specified type. This function will return the same value for a type regardless of whichever crate it is invoked in.",null,null],[5,"init","","Creates a value initialized to zero.",null,null],[5,"uninit","","Creates an uninitialized value.",null,null],[5,"forget","","Moves a value out of scope without running drop glue.",null,null],[5,"transmute","","Reinterprets the bits of a value of one type as another type.",null,null],[5,"needs_drop","","Returns `true` if the actual type given as `T` requires drop glue; returns `false` if the actual type provided for `T` implements `Copy`.",null,null],[5,"offset","","Calculates the offset from a pointer.",null,null],[5,"arith_offset","","Calculates the offset from a pointer, potentially wrapping.",null,null],[5,"copy_nonoverlapping","","Copies `count * size_of<T>` bytes from `src` to `dst`. The source and destination may *not* overlap.",null,null],[5,"copy","","Copies `count * size_of<T>` bytes from `src` to `dst`. The source and destination may overlap.",null,null],[5,"write_bytes","","Invokes memset on the specified pointer, setting `count * size_of::<T>()` bytes of memory starting at `dst` to `val`.",null,null],[5,"volatile_copy_nonoverlapping_memory","","Equivalent to the appropriate `llvm.memcpy.p0i8.0i8.*` intrinsic, with a size of `count` * `size_of::<T>()` and an alignment of `min_align_of::<T>()`",null,null],[5,"volatile_copy_memory","","Equivalent to the appropriate `llvm.memmove.p0i8.0i8.*` intrinsic, with a size of `count` * `size_of::<T>()` and an alignment of `min_align_of::<T>()`",null,null],[5,"volatile_set_memory","","Equivalent to the appropriate `llvm.memset.p0i8.*` intrinsic, with a size of `count` * `size_of::<T>()` and an alignment of `min_align_of::<T>()`.",null,null],[5,"volatile_load","","Perform a volatile load from the `src` pointer. The stabilized version of this intrinsic is `std::ptr::read_volatile`.",null,null],[5,"volatile_store","","Perform a volatile store to the `dst` pointer. The stabilized version of this intrinsic is `std::ptr::write_volatile`.",null,null],[5,"sqrtf32","","Returns the square root of an `f32`",null,null],[5,"sqrtf64","","Returns the square root of an `f64`",null,null],[5,"powif32","","Raises an `f32` to an integer power.",null,null],[5,"powif64","","Raises an `f64` to an integer power.",null,null],[5,"sinf32","","Returns the sine of an `f32`.",null,null],[5,"sinf64","","Returns the sine of an `f64`.",null,null],[5,"cosf32","","Returns the cosine of an `f32`.",null,null],[5,"cosf64","","Returns the cosine of an `f64`.",null,null],[5,"powf32","","Raises an `f32` to an `f32` power.",null,null],[5,"powf64","","Raises an `f64` to an `f64` power.",null,null],[5,"expf32","","Returns the exponential of an `f32`.",null,null],[5,"expf64","","Returns the exponential of an `f64`.",null,null],[5,"exp2f32","","Returns 2 raised to the power of an `f32`.",null,null],[5,"exp2f64","","Returns 2 raised to the power of an `f64`.",null,null],[5,"logf32","","Returns the natural logarithm of an `f32`.",null,null],[5,"logf64","","Returns the natural logarithm of an `f64`.",null,null],[5,"log10f32","","Returns the base 10 logarithm of an `f32`.",null,null],[5,"log10f64","","Returns the base 10 logarithm of an `f64`.",null,null],[5,"log2f32","","Returns the base 2 logarithm of an `f32`.",null,null],[5,"log2f64","","Returns the base 2 logarithm of an `f64`.",null,null],[5,"fmaf32","","Returns `a * b + c` for `f32` values.",null,null],[5,"fmaf64","","Returns `a * b + c` for `f64` values.",null,null],[5,"fabsf32","","Returns the absolute value of an `f32`.",null,null],[5,"fabsf64","","Returns the absolute value of an `f64`.",null,null],[5,"copysignf32","","Copies the sign from `y` to `x` for `f32` values.",null,null],[5,"copysignf64","","Copies the sign from `y` to `x` for `f64` values.",null,null],[5,"floorf32","","Returns the largest integer less than or equal to an `f32`.",null,null],[5,"floorf64","","Returns the largest integer less than or equal to an `f64`.",null,null],[5,"ceilf32","","Returns the smallest integer greater than or equal to an `f32`.",null,null],[5,"ceilf64","","Returns the smallest integer greater than or equal to an `f64`.",null,null],[5,"truncf32","","Returns the integer part of an `f32`.",null,null],[5,"truncf64","","Returns the integer part of an `f64`.",null,null],[5,"rintf32","","Returns the nearest integer to an `f32`. May raise an inexact floating-point exception if the argument is not an integer.",null,null],[5,"rintf64","","Returns the nearest integer to an `f64`. May raise an inexact floating-point exception if the argument is not an integer.",null,null],[5,"nearbyintf32","","Returns the nearest integer to an `f32`.",null,null],[5,"nearbyintf64","","Returns the nearest integer to an `f64`.",null,null],[5,"roundf32","","Returns the nearest integer to an `f32`. Rounds half-way cases away from zero.",null,null],[5,"roundf64","","Returns the nearest integer to an `f64`. Rounds half-way cases away from zero.",null,null],[5,"fadd_fast","","Float addition that allows optimizations based on algebraic rules. May assume inputs are finite.",null,null],[5,"fsub_fast","","Float subtraction that allows optimizations based on algebraic rules. May assume inputs are finite.",null,null],[5,"fmul_fast","","Float multiplication that allows optimizations based on algebraic rules. May assume inputs are finite.",null,null],[5,"fdiv_fast","","Float division that allows optimizations based on algebraic rules. May assume inputs are finite.",null,null],[5,"frem_fast","","Float remainder that allows optimizations based on algebraic rules. May assume inputs are finite.",null,null],[5,"ctpop","","Returns the number of bits set in an integer type `T`",null,null],[5,"ctlz","","Returns the number of leading unset bits (zeroes) in an integer type `T`.",null,null],[5,"cttz","","Returns the number of trailing unset bits (zeroes) in an integer type `T`.",null,null],[5,"bswap","","Reverses the bytes in an integer type `T`.",null,null],[5,"add_with_overflow","","Performs checked integer addition. The stabilized versions of this intrinsic are available on the integer primitives via the `overflowing_add` method. For example, `std::u32::overflowing_add`",null,null],[5,"sub_with_overflow","","Performs checked integer subtraction The stabilized versions of this intrinsic are available on the integer primitives via the `overflowing_sub` method. For example, `std::u32::overflowing_sub`",null,null],[5,"mul_with_overflow","","Performs checked integer multiplication The stabilized versions of this intrinsic are available on the integer primitives via the `overflowing_mul` method. For example, `std::u32::overflowing_mul`",null,null],[5,"unchecked_div","","Performs an unchecked division, resulting in undefined behavior where y = 0 or x = `T::min_value()` and y = -1",null,null],[5,"unchecked_rem","","Returns the remainder of an unchecked division, resulting in undefined behavior where y = 0 or x = `T::min_value()` and y = -1",null,null],[5,"overflowing_add","","Returns (a + b) mod 2^N, where N is the width of T in bits. The stabilized versions of this intrinsic are available on the integer primitives via the `wrapping_add` method. For example, `std::u32::wrapping_add`",null,null],[5,"overflowing_sub","","Returns (a - b) mod 2^N, where N is the width of T in bits. The stabilized versions of this intrinsic are available on the integer primitives via the `wrapping_sub` method. For example, `std::u32::wrapping_sub`",null,null],[5,"overflowing_mul","","Returns (a * b) mod 2^N, where N is the width of T in bits. The stabilized versions of this intrinsic are available on the integer primitives via the `wrapping_mul` method. For example, `std::u32::wrapping_mul`",null,null],[5,"discriminant_value","","Returns the value of the discriminant for the variant in 'v', cast to a `u64`; if `T` has no discriminant, returns 0.",null,null],[5,"try","","Rust's \"try catch\" construct which invokes the function pointer `f` with the data pointer `data`.",null,null],[0,"mem","core","Basic functions for dealing with memory.",null,null],[3,"Discriminant","core::mem","Opaque type representing the discriminant of an enum.",null,null],[5,"forget","","Leaks a value: takes ownership and \"forgets\" about the value **without running its destructor**.",null,{"inputs":[{"name":"t"}],"output":null}],[5,"size_of","","Returns the size of a type in bytes.",null,{"inputs":[],"output":{"name":"usize"}}],[5,"size_of_val","","Returns the size of the pointed-to value in bytes.",null,{"inputs":[{"name":"t"}],"output":{"name":"usize"}}],[5,"min_align_of","","Returns the [ABI]-required minimum alignment of a type.",null,{"inputs":[],"output":{"name":"usize"}}],[5,"min_align_of_val","","Returns the [ABI]-required minimum alignment of the type of the value that `val` points to.",null,{"inputs":[{"name":"t"}],"output":{"name":"usize"}}],[5,"align_of","","Returns the [ABI]-required minimum alignment of a type.",null,{"inputs":[],"output":{"name":"usize"}}],[5,"align_of_val","","Returns the [ABI]-required minimum alignment of the type of the value that `val` points to.",null,{"inputs":[{"name":"t"}],"output":{"name":"usize"}}],[5,"zeroed","","Creates a value whose bytes are all zero.",null,{"inputs":[],"output":{"name":"t"}}],[5,"uninitialized","","Bypasses Rust's normal memory-initialization checks by pretending to produce a value of type `T`, while doing nothing at all.",null,{"inputs":[],"output":{"name":"t"}}],[5,"swap","","Swaps the values at two mutable locations, without deinitializing either one.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":null}],[5,"replace","","Replaces the value at a mutable location with a new one, returning the old value, without deinitializing either one.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"drop","","Disposes of a value.",null,{"inputs":[{"name":"t"}],"output":null}],[5,"transmute_copy","","Interprets `src` as having type `&U`, and then reads `src` without moving the contained value.",null,{"inputs":[{"name":"t"}],"output":{"name":"u"}}],[5,"discriminant","","Returns a value uniquely identifying the enum variant in `v`.",null,{"inputs":[{"name":"t"}],"output":{"name":"discriminant"}}],[11,"clone","","",7,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"eq","","",7,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"bool"}}],[11,"hash","","",7,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"fmt","","",7,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[0,"nonzero","core","Exposes the NonZero lang item which provides optimization hints.",null,null],[3,"NonZero","core::nonzero","A wrapper type for raw pointers and integers that will never be NULL or 0 that might allow certain optimizations.",null,null],[8,"Zeroable","","Unsafe trait to indicate what types are usable with the NonZero struct",null,null],[11,"clone","","",8,{"inputs":[{"name":"self"}],"output":{"name":"nonzero"}}],[11,"eq","","",8,{"inputs":[{"name":"self"},{"name":"nonzero"}],"output":{"name":"bool"}}],[11,"ne","","",8,{"inputs":[{"name":"self"},{"name":"nonzero"}],"output":{"name":"bool"}}],[11,"cmp","","",8,{"inputs":[{"name":"self"},{"name":"nonzero"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",8,{"inputs":[{"name":"self"},{"name":"nonzero"}],"output":{"name":"option"}}],[11,"lt","","",8,{"inputs":[{"name":"self"},{"name":"nonzero"}],"output":{"name":"bool"}}],[11,"le","","",8,{"inputs":[{"name":"self"},{"name":"nonzero"}],"output":{"name":"bool"}}],[11,"gt","","",8,{"inputs":[{"name":"self"},{"name":"nonzero"}],"output":{"name":"bool"}}],[11,"ge","","",8,{"inputs":[{"name":"self"},{"name":"nonzero"}],"output":{"name":"bool"}}],[11,"fmt","","",8,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",8,null],[11,"new","","Creates an instance of NonZero with the provided value. You must indeed ensure that the value is actually \"non-zero\".",8,{"inputs":[{"name":"t"}],"output":{"name":"nonzero"}}],[11,"deref","","",8,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[0,"ptr","core","Raw, unsafe pointers, `*const T`, and `*mut T`.",null,null],[3,"Unique","core::ptr","A wrapper around a raw non-null `*mut T` that indicates that the possessor of this wrapper owns the referent. This in turn implies that the `Unique<T>` is `Send`/`Sync` if `T` is `Send`/`Sync`, unlike a raw `*mut T` (which conveys no particular ownership semantics).  It also implies that the referent of the pointer should not be modified without a unique path to the `Unique` reference. Useful for building abstractions like `Vec<T>` or `Box<T>`, which internally use raw pointers to manage the memory that they own.",null,null],[3,"Shared","","A wrapper around a raw non-null `*mut T` that indicates that the possessor of this wrapper has shared ownership of the referent. Useful for building abstractions like `Rc<T>` or `Arc<T>`, which internally use raw pointers to manage the memory that they own.",null,null],[5,"null","","Creates a null raw pointer.",null,null],[5,"null_mut","","Creates a null mutable raw pointer.",null,null],[5,"swap","","Swaps the values at two mutable locations of the same type, without deinitializing either. They may overlap, unlike `mem::swap` which is otherwise equivalent.",null,null],[5,"replace","","Replaces the value at `dest` with `src`, returning the old value, without dropping either.",null,null],[5,"read","","Reads the value from `src` without moving it. This leaves the memory in `src` unchanged.",null,null],[5,"read_unaligned","","Reads the value from `src` without moving it. This leaves the memory in `src` unchanged.",null,null],[5,"write","","Overwrites a memory location with the given value without reading or dropping the old value.",null,null],[5,"write_unaligned","","Overwrites a memory location with the given value without reading or dropping the old value.",null,null],[5,"read_volatile","","Performs a volatile read of the value from `src` without moving it. This leaves the memory in `src` unchanged.",null,null],[5,"write_volatile","","Performs a volatile write of a memory location with the given value without reading or dropping the old value.",null,null],[5,"eq","","Compare raw pointers for equality.",null,null],[11,"new","","Creates a new `Unique`.",9,null],[11,"get","","Dereferences the content.",9,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"get_mut","","Mutably dereferences the content.",9,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"deref","","",9,null],[11,"fmt","","",9,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new `Shared`.",10,null],[11,"clone","","",10,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"deref","","",10,null],[11,"fmt","","",10,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[0,"marker","core","Primitive traits and types representing basic properties of types.",null,null],[3,"PhantomData","core::marker","Zero-sized type used to mark things that \"act like\" they own a `T`.",null,null],[8,"Send","","Types that can be transferred across thread boundaries.",null,null],[8,"Sized","","Types with a constant size known at compile time.",null,null],[8,"Unsize","","Types that can be \"unsized\" to a dynamically-sized type.",null,null],[8,"Copy","","Types whose values can be duplicated simply by copying bits.",null,null],[8,"Sync","","Types for which it is safe to share references between threads.",null,null],[11,"hash","","",11,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"eq","","",11,{"inputs":[{"name":"self"},{"name":"phantomdata"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",11,{"inputs":[{"name":"self"},{"name":"phantomdata"}],"output":{"name":"option"}}],[11,"cmp","","",11,{"inputs":[{"name":"self"},{"name":"phantomdata"}],"output":{"name":"ordering"}}],[11,"clone","","",11,{"inputs":[{"name":"self"}],"output":{"name":"phantomdata"}}],[11,"default","","",11,{"inputs":[],"output":{"name":"phantomdata"}}],[0,"ops","core","Overloadable operators.",null,null],[3,"RangeFull","core::ops","An unbounded range. Use `..` (two dots) for its shorthand.",null,null],[3,"Range","","A (half-open) range which is bounded at both ends: { x | start <= x < end }. Use `start..end` (two dots) for its shorthand.",null,null],[12,"start","","The lower bound of the range (inclusive).",12,null],[12,"end","","The upper bound of the range (exclusive).",12,null],[3,"RangeFrom","","A range which is only bounded below: { x | start <= x }. Use `start..` for its shorthand.",null,null],[12,"start","","The lower bound of the range (inclusive).",13,null],[3,"RangeTo","","A range which is only bounded above: { x | x < end }. Use `..end` (two dots) for its shorthand.",null,null],[12,"end","","The upper bound of the range (exclusive).",14,null],[3,"RangeToInclusive","","An inclusive range which is only bounded above: { x | x <= end }. Use `...end` (three dots) for its shorthand.",null,null],[12,"end","","The upper bound of the range (inclusive)",15,null],[4,"RangeInclusive","","An inclusive range which is bounded at both ends: { x | start <= x <= end }. Use `start...end` (three dots) for its shorthand.",null,null],[13,"Empty","","Empty range (iteration has finished)",16,null],[12,"at","core::ops::RangeInclusive","The point at which iteration finished",16,null],[13,"NonEmpty","core::ops","Non-empty range (iteration will yield value(s))",16,null],[12,"start","core::ops::RangeInclusive","The lower bound of the range (inclusive).",16,null],[12,"end","","The upper bound of the range (inclusive).",16,null],[8,"Drop","core::ops","The `Drop` trait is used to run some code when a value goes out of scope. This is sometimes called a 'destructor'.",null,null],[10,"drop","","A method called when the value goes out of scope.",17,{"inputs":[{"name":"self"}],"output":null}],[8,"Add","","The `Add` trait is used to specify the functionality of `+`.",null,null],[16,"Output","","The resulting type after applying the `+` operator",18,null],[10,"add","","The method for the `+` operator",18,null],[8,"Sub","","The `Sub` trait is used to specify the functionality of `-`.",null,null],[16,"Output","","The resulting type after applying the `-` operator",19,null],[10,"sub","","The method for the `-` operator",19,null],[8,"Mul","","The `Mul` trait is used to specify the functionality of `*`.",null,null],[16,"Output","","The resulting type after applying the `*` operator",20,null],[10,"mul","","The method for the `*` operator",20,null],[8,"Div","","The `Div` trait is used to specify the functionality of `/`.",null,null],[16,"Output","","The resulting type after applying the `/` operator",21,null],[10,"div","","The method for the `/` operator",21,null],[8,"Rem","","The `Rem` trait is used to specify the functionality of `%`.",null,null],[16,"Output","","The resulting type after applying the `%` operator",22,null],[10,"rem","","The method for the `%` operator",22,null],[8,"Neg","","The `Neg` trait is used to specify the functionality of unary `-`.",null,null],[16,"Output","","The resulting type after applying the `-` operator",23,null],[10,"neg","","The method for the unary `-` operator",23,null],[8,"Not","","The `Not` trait is used to specify the functionality of unary `!`.",null,null],[16,"Output","","The resulting type after applying the `!` operator",24,null],[10,"not","","The method for the unary `!` operator",24,null],[8,"BitAnd","","The `BitAnd` trait is used to specify the functionality of `&`.",null,null],[16,"Output","","The resulting type after applying the `&` operator",25,null],[10,"bitand","","The method for the `&` operator",25,null],[8,"BitOr","","The `BitOr` trait is used to specify the functionality of `|`.",null,null],[16,"Output","","The resulting type after applying the `|` operator",26,null],[10,"bitor","","The method for the `|` operator",26,null],[8,"BitXor","","The `BitXor` trait is used to specify the functionality of `^`.",null,null],[16,"Output","","The resulting type after applying the `^` operator",27,null],[10,"bitxor","","The method for the `^` operator",27,null],[8,"Shl","","The `Shl` trait is used to specify the functionality of `<<`.",null,null],[16,"Output","","The resulting type after applying the `<<` operator",28,null],[10,"shl","","The method for the `<<` operator",28,null],[8,"Shr","","The `Shr` trait is used to specify the functionality of `>>`.",null,null],[16,"Output","","The resulting type after applying the `>>` operator",29,null],[10,"shr","","The method for the `>>` operator",29,null],[8,"AddAssign","","The `AddAssign` trait is used to specify the functionality of `+=`.",null,null],[10,"add_assign","","The method for the `+=` operator",30,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":null}],[8,"SubAssign","","The `SubAssign` trait is used to specify the functionality of `-=`.",null,null],[10,"sub_assign","","The method for the `-=` operator",31,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":null}],[8,"MulAssign","","The `MulAssign` trait is used to specify the functionality of `*=`.",null,null],[10,"mul_assign","","The method for the `*=` operator",32,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":null}],[8,"DivAssign","","The `DivAssign` trait is used to specify the functionality of `/=`.",null,null],[10,"div_assign","","The method for the `/=` operator",33,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":null}],[8,"RemAssign","","The `RemAssign` trait is used to specify the functionality of `%=`.",null,null],[10,"rem_assign","","The method for the `%=` operator",34,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":null}],[8,"BitAndAssign","","The `BitAndAssign` trait is used to specify the functionality of `&=`.",null,null],[10,"bitand_assign","","The method for the `&=` operator",35,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":null}],[8,"BitOrAssign","","The `BitOrAssign` trait is used to specify the functionality of `|=`.",null,null],[10,"bitor_assign","","The method for the `|=` operator",36,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":null}],[8,"BitXorAssign","","The `BitXorAssign` trait is used to specify the functionality of `^=`.",null,null],[10,"bitxor_assign","","The method for the `^=` operator",37,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":null}],[8,"ShlAssign","","The `ShlAssign` trait is used to specify the functionality of `<<=`.",null,null],[10,"shl_assign","","The method for the `<<=` operator",38,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":null}],[8,"ShrAssign","","The `ShrAssign` trait is used to specify the functionality of `>>=`.",null,null],[10,"shr_assign","","The method for the `>>=` operator",39,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":null}],[8,"Index","","The `Index` trait is used to specify the functionality of indexing operations like `container[index]` when used in an immutable context.",null,null],[16,"Output","","The returned type after indexing",40,null],[10,"index","","The method for the indexing (`container[index]`) operation",40,null],[8,"IndexMut","","The `IndexMut` trait is used to specify the functionality of indexing operations like `container[index]` when used in a mutable context.",null,null],[10,"index_mut","","The method for the mutable indexing (`container[index]`) operation",41,null],[8,"Deref","","The `Deref` trait is used to specify the functionality of dereferencing operations, like `*v`.",null,null],[16,"Target","","The resulting type after dereferencing",42,null],[10,"deref","","The method called to dereference a value",42,null],[8,"DerefMut","","The `DerefMut` trait is used to specify the functionality of dereferencing mutably like `*v = 1;`",null,null],[10,"deref_mut","","The method called to mutably dereference a value",43,null],[8,"Fn","","A version of the call operator that takes an immutable receiver.",null,null],[10,"call","","This is called when the call operator is used.",44,null],[8,"FnMut","","A version of the call operator that takes a mutable receiver.",null,null],[10,"call_mut","","This is called when the call operator is used.",45,null],[8,"FnOnce","","A version of the call operator that takes a by-value receiver.",null,null],[16,"Output","","The returned type after the call operator is used.",46,null],[10,"call_once","","This is called when the call operator is used.",46,null],[8,"CoerceUnsized","","Trait that indicates that this is a pointer or a wrapper for one, where unsizing can be performed on the pointee.",null,null],[8,"Place","","Both `PLACE <- EXPR` and `box EXPR` desugar into expressions that allocate an intermediate \"place\" that holds uninitialized state.  The desugaring evaluates EXPR, and writes the result at the address returned by the `pointer` method of this trait.",null,null],[10,"pointer","","Returns the address where the input value will be written. Note that the data at this address is generally uninitialized, and thus one should use `ptr::write` for initializing it.",47,null],[8,"Placer","","Interface to implementations of  `PLACE <- EXPR`.",null,null],[16,"Place","","`Place` is the intermedate agent guarding the uninitialized state for `Data`.",48,null],[10,"make_place","","Creates a fresh place from `self`.",48,null],[8,"InPlace","","Specialization of `Place` trait supporting `PLACE <- EXPR`.",null,null],[16,"Owner","","`Owner` is the type of the end value of `PLACE <- EXPR`",49,null],[10,"finalize","","Converts self into the final value, shifting deallocation/cleanup responsibilities (if any remain), over to the returned instance of `Owner` and forgetting self.",49,null],[8,"Boxed","","Core trait for the `box EXPR` form.",null,null],[16,"Data","","The kind of data that is stored in this kind of box.",50,null],[16,"Place","","The place that will negotiate the storage of the data.",50,null],[10,"finalize","","Converts filled place into final owning value, shifting deallocation/cleanup responsibilities (if any remain), over to returned instance of `Self` and forgetting `filled`.",50,null],[8,"BoxPlace","","Specialization of `Place` trait supporting `box EXPR`.",null,null],[10,"make_place","","Creates a globally fresh place.",51,{"inputs":[],"output":{"name":"self"}}],[8,"Carrier","","A trait for types which have success and error states and are meant to work with the question mark operator. When the `?` operator is used with a value, whether the value is in the success or error state is determined by calling `translate`.",null,null],[16,"Success","","The type of the value when computation succeeds.",52,null],[16,"Error","","The type of the value when computation errors out.",52,null],[10,"from_success","","Create a `Carrier` from a success value.",52,null],[10,"from_error","","Create a `Carrier` from an error value.",52,null],[10,"translate","","Translate this `Carrier` to another implementation of `Carrier` with the same associated types.",52,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"clone","","",53,{"inputs":[{"name":"self"}],"output":{"name":"rangefull"}}],[11,"eq","","",53,{"inputs":[{"name":"self"},{"name":"rangefull"}],"output":{"name":"bool"}}],[11,"hash","","",53,null],[11,"fmt","","",53,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",12,{"inputs":[{"name":"self"}],"output":{"name":"range"}}],[11,"eq","","",12,{"inputs":[{"name":"self"},{"name":"range"}],"output":{"name":"bool"}}],[11,"ne","","",12,{"inputs":[{"name":"self"},{"name":"range"}],"output":{"name":"bool"}}],[11,"hash","","",12,null],[11,"fmt","","",12,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"contains","","Examples",12,{"inputs":[{"name":"self"},{"name":"idx"}],"output":{"name":"bool"}}],[11,"clone","","",13,{"inputs":[{"name":"self"}],"output":{"name":"rangefrom"}}],[11,"eq","","",13,{"inputs":[{"name":"self"},{"name":"rangefrom"}],"output":{"name":"bool"}}],[11,"ne","","",13,{"inputs":[{"name":"self"},{"name":"rangefrom"}],"output":{"name":"bool"}}],[11,"hash","","",13,null],[11,"fmt","","",13,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"contains","","Examples",13,{"inputs":[{"name":"self"},{"name":"idx"}],"output":{"name":"bool"}}],[11,"clone","","",14,{"inputs":[{"name":"self"}],"output":{"name":"rangeto"}}],[11,"eq","","",14,{"inputs":[{"name":"self"},{"name":"rangeto"}],"output":{"name":"bool"}}],[11,"ne","","",14,{"inputs":[{"name":"self"},{"name":"rangeto"}],"output":{"name":"bool"}}],[11,"hash","","",14,null],[11,"fmt","","",14,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"contains","","Examples",14,{"inputs":[{"name":"self"},{"name":"idx"}],"output":{"name":"bool"}}],[11,"clone","","",16,{"inputs":[{"name":"self"}],"output":{"name":"rangeinclusive"}}],[11,"eq","","",16,{"inputs":[{"name":"self"},{"name":"rangeinclusive"}],"output":{"name":"bool"}}],[11,"ne","","",16,{"inputs":[{"name":"self"},{"name":"rangeinclusive"}],"output":{"name":"bool"}}],[11,"hash","","",16,null],[11,"fmt","","",16,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"contains","","Examples",16,{"inputs":[{"name":"self"},{"name":"idx"}],"output":{"name":"bool"}}],[11,"clone","","",15,{"inputs":[{"name":"self"}],"output":{"name":"rangetoinclusive"}}],[11,"eq","","",15,{"inputs":[{"name":"self"},{"name":"rangetoinclusive"}],"output":{"name":"bool"}}],[11,"ne","","",15,{"inputs":[{"name":"self"},{"name":"rangetoinclusive"}],"output":{"name":"bool"}}],[11,"hash","","",15,null],[11,"fmt","","",15,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"contains","","Examples",15,{"inputs":[{"name":"self"},{"name":"idx"}],"output":{"name":"bool"}}],[0,"cmp","core","Functionality for ordering and comparison.",null,null],[4,"Ordering","core::cmp","An `Ordering` is the result of a comparison between two values.",null,null],[13,"Less","","An ordering where a compared value is less [than another].",54,null],[13,"Equal","","An ordering where a compared value is equal [to another].",54,null],[13,"Greater","","An ordering where a compared value is greater [than another].",54,null],[5,"min","","Compare and return the minimum of two values.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"max","","Compare and return the maximum of two values.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[8,"PartialEq","","Trait for equality comparisons which are partial equivalence relations.",null,null],[10,"eq","","This method tests for `self` and `other` values to be equal, and is used by `==`.",55,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":{"name":"bool"}}],[11,"ne","","This method tests for `!=`.",55,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":{"name":"bool"}}],[8,"Eq","","Trait for equality comparisons which are equivalence relations.",null,null],[8,"Ord","","Trait for types that form a total order.",null,null],[10,"cmp","","This method returns an `Ordering` between `self` and `other`.",56,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"ordering"}}],[8,"PartialOrd","","Trait for values that can be compared for a sort-order.",null,null],[10,"partial_cmp","","This method returns an ordering between `self` and `other` values if one exists.",57,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":{"name":"option"}}],[11,"lt","","This method tests less than (for `self` and `other`) and is used by the `<` operator.",57,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":{"name":"bool"}}],[11,"le","","This method tests less than or equal to (for `self` and `other`) and is used by the `<=` operator.",57,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":{"name":"bool"}}],[11,"gt","","This method tests greater than (for `self` and `other`) and is used by the `>` operator.",57,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":{"name":"bool"}}],[11,"ge","","This method tests greater than or equal to (for `self` and `other`) and is used by the `>=` operator.",57,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":{"name":"bool"}}],[11,"clone","","",54,{"inputs":[{"name":"self"}],"output":{"name":"ordering"}}],[11,"eq","","",54,{"inputs":[{"name":"self"},{"name":"ordering"}],"output":{"name":"bool"}}],[11,"fmt","","",54,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",54,null],[11,"reverse","","Reverse the `Ordering`.",54,{"inputs":[{"name":"self"}],"output":{"name":"ordering"}}],[11,"then","","Chains two orderings.",54,{"inputs":[{"name":"self"},{"name":"ordering"}],"output":{"name":"ordering"}}],[11,"then_with","","Chains the ordering with the given function.",54,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"ordering"}}],[11,"cmp","","",54,{"inputs":[{"name":"self"},{"name":"ordering"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",54,{"inputs":[{"name":"self"},{"name":"ordering"}],"output":{"name":"option"}}],[0,"clone","core","The `Clone` trait for types that cannot be 'implicitly copied'.",null,null],[8,"Clone","core::clone","A common trait for the ability to explicitly duplicate an object.",null,null],[10,"clone","","Returns a copy of the value.",58,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"clone_from","","Performs copy-assignment from `source`.",58,{"inputs":[{"name":"self"},{"name":"self"}],"output":null}],[0,"default","core","The `Default` trait for types which may have meaningful default values.",null,null],[8,"Default","core::default","A trait for giving a type a useful default value.",null,null],[10,"default","","Returns the \"default value\" for a type.",59,{"inputs":[],"output":{"name":"self"}}],[0,"convert","core","Traits for conversions between types.",null,null],[8,"AsRef","core::convert","A cheap, reference-to-reference conversion.",null,null],[10,"as_ref","","Performs the conversion.",60,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[8,"AsMut","","A cheap, mutable reference-to-mutable reference conversion.",null,null],[10,"as_mut","","Performs the conversion.",61,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[8,"Into","","A conversion that consumes `self`, which may or may not be expensive.",null,null],[10,"into","","Performs the conversion.",62,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[8,"From","","Construct `Self` via a conversion.",null,null],[10,"from","","Performs the conversion.",63,{"inputs":[{"name":"t"}],"output":{"name":"self"}}],[8,"TryInto","","An attempted conversion that consumes `self`, which may or may not be expensive.",null,null],[16,"Err","","The type returned in the event of a conversion error.",64,null],[10,"try_into","","Performs the conversion.",64,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[8,"TryFrom","","Attempt to construct `Self` via a conversion.",null,null],[16,"Err","","The type returned in the event of a conversion error.",65,null],[10,"try_from","","Performs the conversion.",65,{"inputs":[{"name":"t"}],"output":{"name":"result"}}],[0,"borrow","core","A module for working with borrowed data.",null,null],[8,"Borrow","core::borrow","A trait for borrowing data.",null,null],[10,"borrow","","Immutably borrows from an owned value.",66,{"inputs":[{"name":"self"}],"output":{"name":"borrowed"}}],[8,"BorrowMut","","A trait for mutably borrowing data.",null,null],[10,"borrow_mut","","Mutably borrows from an owned value.",67,{"inputs":[{"name":"self"}],"output":{"name":"borrowed"}}],[0,"any","core","This module implements the `Any` trait, which enables dynamic typing of any `'static` type through runtime reflection.",null,null],[3,"TypeId","core::any","A `TypeId` represents a globally unique identifier for a type.",null,null],[8,"Any","","A type to emulate dynamic typing.",null,null],[10,"get_type_id","","Gets the `TypeId` of `self`.",68,{"inputs":[{"name":"self"}],"output":{"name":"typeid"}}],[11,"fmt","","",68,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",68,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"is","","Returns true if the boxed type is the same as `T`.",68,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"downcast_ref","","Returns some reference to the boxed value if it is of type `T`, or `None` if it isn't.",68,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"downcast_mut","","Returns some mutable reference to the boxed value if it is of type `T`, or `None` if it isn't.",68,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"is","","Forwards to the method defined on the type `Any`.",68,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"downcast_ref","","Forwards to the method defined on the type `Any`.",68,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"downcast_mut","","Forwards to the method defined on the type `Any`.",68,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",69,{"inputs":[{"name":"self"}],"output":{"name":"typeid"}}],[11,"eq","","",69,{"inputs":[{"name":"self"},{"name":"typeid"}],"output":{"name":"bool"}}],[11,"ne","","",69,{"inputs":[{"name":"self"},{"name":"typeid"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",69,{"inputs":[{"name":"self"},{"name":"typeid"}],"output":{"name":"option"}}],[11,"lt","","",69,{"inputs":[{"name":"self"},{"name":"typeid"}],"output":{"name":"bool"}}],[11,"le","","",69,{"inputs":[{"name":"self"},{"name":"typeid"}],"output":{"name":"bool"}}],[11,"gt","","",69,{"inputs":[{"name":"self"},{"name":"typeid"}],"output":{"name":"bool"}}],[11,"ge","","",69,{"inputs":[{"name":"self"},{"name":"typeid"}],"output":{"name":"bool"}}],[11,"cmp","","",69,{"inputs":[{"name":"self"},{"name":"typeid"}],"output":{"name":"ordering"}}],[11,"fmt","","",69,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",69,null],[11,"of","","Returns the `TypeId` of the type this generic function has been instantiated with.",69,{"inputs":[],"output":{"name":"typeid"}}],[0,"array","core","Implementations of things like `Eq` for fixed-length arrays up to a certain length. Eventually we should able to generalize to all lengths.",null,null],[8,"FixedSizeArray","core::array","Utility trait implemented only on arrays of fixed size",null,null],[10,"as_slice","","Converts the array to immutable slice",70,null],[10,"as_mut_slice","","Converts the array to mutable slice",70,null],[0,"sync","core","Synchronization primitives",null,null],[0,"atomic","core::sync","Atomic types",null,null],[3,"AtomicBool","core::sync::atomic","A boolean type which can be safely shared between threads.",null,null],[3,"AtomicPtr","","A raw pointer type which can be safely shared between threads.",null,null],[3,"AtomicI8","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicU8","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicI16","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicU16","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicI32","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicU32","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicI64","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicU64","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicIsize","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicUsize","","An integer type which can be safely shared between threads.",null,null],[4,"Ordering","","Atomic memory orderings",null,null],[13,"Relaxed","","No ordering constraints, only atomic operations. Corresponds to LLVM's `Monotonic` ordering.",71,null],[13,"Release","","When coupled with a store, all previous writes become visible to the other threads that perform a load with `Acquire` ordering on the same value.",71,null],[13,"Acquire","","When coupled with a load, all subsequent loads will see data written before a store with `Release` ordering on the same value in other threads.",71,null],[13,"AcqRel","","When coupled with a load, uses `Acquire` ordering, and with a store `Release` ordering.",71,null],[13,"SeqCst","","Like `AcqRel` with the additional guarantee that all threads see all sequentially consistent operations in the same order.",71,null],[5,"fence","","An atomic fence.",null,{"inputs":[{"name":"ordering"}],"output":null}],[17,"ATOMIC_BOOL_INIT","","An `AtomicBool` initialized to `false`.",null,null],[17,"ATOMIC_I8_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_U8_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_I16_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_U16_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_I32_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_U32_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_I64_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_U64_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_ISIZE_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_USIZE_INIT","","An atomic integer initialized to `0`.",null,null],[11,"default","","Creates an `AtomicBool` initialized to `false`.",72,{"inputs":[],"output":{"name":"self"}}],[11,"default","","Creates a null `AtomicPtr<T>`.",73,{"inputs":[],"output":{"name":"atomicptr"}}],[11,"clone","","",71,{"inputs":[{"name":"self"}],"output":{"name":"ordering"}}],[11,"fmt","","",71,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new `AtomicBool`.",72,{"inputs":[{"name":"bool"}],"output":{"name":"atomicbool"}}],[11,"get_mut","","Returns a mutable reference to the underlying `bool`.",72,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"into_inner","","Consumes the atomic and returns the contained value.",72,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"load","","Loads a value from the bool.",72,{"inputs":[{"name":"self"},{"name":"ordering"}],"output":{"name":"bool"}}],[11,"store","","Stores a value into the bool.",72,{"inputs":[{"name":"self"},{"name":"bool"},{"name":"ordering"}],"output":null}],[11,"swap","","Stores a value into the bool, returning the old value.",72,{"inputs":[{"name":"self"},{"name":"bool"},{"name":"ordering"}],"output":{"name":"bool"}}],[11,"compare_and_swap","","Stores a value into the `bool` if the current value is the same as the `current` value.",72,{"inputs":[{"name":"self"},{"name":"bool"},{"name":"bool"},{"name":"ordering"}],"output":{"name":"bool"}}],[11,"compare_exchange","","Stores a value into the `bool` if the current value is the same as the `current` value.",72,{"inputs":[{"name":"self"},{"name":"bool"},{"name":"bool"},{"name":"ordering"},{"name":"ordering"}],"output":{"name":"result"}}],[11,"compare_exchange_weak","","Stores a value into the `bool` if the current value is the same as the `current` value.",72,{"inputs":[{"name":"self"},{"name":"bool"},{"name":"bool"},{"name":"ordering"},{"name":"ordering"}],"output":{"name":"result"}}],[11,"fetch_and","","Logical \"and\" with a boolean value.",72,{"inputs":[{"name":"self"},{"name":"bool"},{"name":"ordering"}],"output":{"name":"bool"}}],[11,"fetch_nand","","Logical \"nand\" with a boolean value.",72,{"inputs":[{"name":"self"},{"name":"bool"},{"name":"ordering"}],"output":{"name":"bool"}}],[11,"fetch_or","","Logical \"or\" with a boolean value.",72,{"inputs":[{"name":"self"},{"name":"bool"},{"name":"ordering"}],"output":{"name":"bool"}}],[11,"fetch_xor","","Logical \"xor\" with a boolean value.",72,{"inputs":[{"name":"self"},{"name":"bool"},{"name":"ordering"}],"output":{"name":"bool"}}],[11,"new","","Creates a new `AtomicPtr`.",73,null],[11,"get_mut","","Returns a mutable reference to the underlying pointer.",73,null],[11,"into_inner","","Consumes the atomic and returns the contained value.",73,null],[11,"load","","Loads a value from the pointer.",73,null],[11,"store","","Stores a value into the pointer.",73,null],[11,"swap","","Stores a value into the pointer, returning the old value.",73,null],[11,"compare_and_swap","","Stores a value into the pointer if the current value is the same as the `current` value.",73,null],[11,"compare_exchange","","Stores a value into the pointer if the current value is the same as the `current` value.",73,null],[11,"compare_exchange_weak","","Stores a value into the pointer if the current value is the same as the `current` value.",73,null],[11,"default","","",74,{"inputs":[],"output":{"name":"self"}}],[11,"fmt","","",74,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new atomic integer.",74,{"inputs":[{"name":"i8"}],"output":{"name":"self"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",74,{"inputs":[{"name":"self"}],"output":{"name":"i8"}}],[11,"into_inner","","Consumes the atomic and returns the contained value.",74,{"inputs":[{"name":"self"}],"output":{"name":"i8"}}],[11,"load","","Loads a value from the atomic integer.",74,{"inputs":[{"name":"self"},{"name":"ordering"}],"output":{"name":"i8"}}],[11,"store","","Stores a value into the atomic integer.",74,{"inputs":[{"name":"self"},{"name":"i8"},{"name":"ordering"}],"output":null}],[11,"swap","","Stores a value into the atomic integer, returning the old value.",74,{"inputs":[{"name":"self"},{"name":"i8"},{"name":"ordering"}],"output":{"name":"i8"}}],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",74,{"inputs":[{"name":"self"},{"name":"i8"},{"name":"i8"},{"name":"ordering"}],"output":{"name":"i8"}}],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",74,{"inputs":[{"name":"self"},{"name":"i8"},{"name":"i8"},{"name":"ordering"},{"name":"ordering"}],"output":{"name":"result"}}],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",74,{"inputs":[{"name":"self"},{"name":"i8"},{"name":"i8"},{"name":"ordering"},{"name":"ordering"}],"output":{"name":"result"}}],[11,"fetch_add","","Add to the current value, returning the previous value.",74,{"inputs":[{"name":"self"},{"name":"i8"},{"name":"ordering"}],"output":{"name":"i8"}}],[11,"fetch_sub","","Subtract from the current value, returning the previous value.",74,{"inputs":[{"name":"self"},{"name":"i8"},{"name":"ordering"}],"output":{"name":"i8"}}],[11,"fetch_and","","Bitwise and with the current value, returning the previous value.",74,{"inputs":[{"name":"self"},{"name":"i8"},{"name":"ordering"}],"output":{"name":"i8"}}],[11,"fetch_or","","Bitwise or with the current value, returning the previous value.",74,{"inputs":[{"name":"self"},{"name":"i8"},{"name":"ordering"}],"output":{"name":"i8"}}],[11,"fetch_xor","","Bitwise xor with the current value, returning the previous value.",74,{"inputs":[{"name":"self"},{"name":"i8"},{"name":"ordering"}],"output":{"name":"i8"}}],[11,"default","","",75,{"inputs":[],"output":{"name":"self"}}],[11,"fmt","","",75,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new atomic integer.",75,{"inputs":[{"name":"u8"}],"output":{"name":"self"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",75,{"inputs":[{"name":"self"}],"output":{"name":"u8"}}],[11,"into_inner","","Consumes the atomic and returns the contained value.",75,{"inputs":[{"name":"self"}],"output":{"name":"u8"}}],[11,"load","","Loads a value from the atomic integer.",75,{"inputs":[{"name":"self"},{"name":"ordering"}],"output":{"name":"u8"}}],[11,"store","","Stores a value into the atomic integer.",75,{"inputs":[{"name":"self"},{"name":"u8"},{"name":"ordering"}],"output":null}],[11,"swap","","Stores a value into the atomic integer, returning the old value.",75,{"inputs":[{"name":"self"},{"name":"u8"},{"name":"ordering"}],"output":{"name":"u8"}}],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",75,{"inputs":[{"name":"self"},{"name":"u8"},{"name":"u8"},{"name":"ordering"}],"output":{"name":"u8"}}],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",75,{"inputs":[{"name":"self"},{"name":"u8"},{"name":"u8"},{"name":"ordering"},{"name":"ordering"}],"output":{"name":"result"}}],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",75,{"inputs":[{"name":"self"},{"name":"u8"},{"name":"u8"},{"name":"ordering"},{"name":"ordering"}],"output":{"name":"result"}}],[11,"fetch_add","","Add to the current value, returning the previous value.",75,{"inputs":[{"name":"self"},{"name":"u8"},{"name":"ordering"}],"output":{"name":"u8"}}],[11,"fetch_sub","","Subtract from the current value, returning the previous value.",75,{"inputs":[{"name":"self"},{"name":"u8"},{"name":"ordering"}],"output":{"name":"u8"}}],[11,"fetch_and","","Bitwise and with the current value, returning the previous value.",75,{"inputs":[{"name":"self"},{"name":"u8"},{"name":"ordering"}],"output":{"name":"u8"}}],[11,"fetch_or","","Bitwise or with the current value, returning the previous value.",75,{"inputs":[{"name":"self"},{"name":"u8"},{"name":"ordering"}],"output":{"name":"u8"}}],[11,"fetch_xor","","Bitwise xor with the current value, returning the previous value.",75,{"inputs":[{"name":"self"},{"name":"u8"},{"name":"ordering"}],"output":{"name":"u8"}}],[11,"default","","",76,{"inputs":[],"output":{"name":"self"}}],[11,"fmt","","",76,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new atomic integer.",76,{"inputs":[{"name":"i16"}],"output":{"name":"self"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",76,{"inputs":[{"name":"self"}],"output":{"name":"i16"}}],[11,"into_inner","","Consumes the atomic and returns the contained value.",76,{"inputs":[{"name":"self"}],"output":{"name":"i16"}}],[11,"load","","Loads a value from the atomic integer.",76,{"inputs":[{"name":"self"},{"name":"ordering"}],"output":{"name":"i16"}}],[11,"store","","Stores a value into the atomic integer.",76,{"inputs":[{"name":"self"},{"name":"i16"},{"name":"ordering"}],"output":null}],[11,"swap","","Stores a value into the atomic integer, returning the old value.",76,{"inputs":[{"name":"self"},{"name":"i16"},{"name":"ordering"}],"output":{"name":"i16"}}],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",76,{"inputs":[{"name":"self"},{"name":"i16"},{"name":"i16"},{"name":"ordering"}],"output":{"name":"i16"}}],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",76,{"inputs":[{"name":"self"},{"name":"i16"},{"name":"i16"},{"name":"ordering"},{"name":"ordering"}],"output":{"name":"result"}}],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",76,{"inputs":[{"name":"self"},{"name":"i16"},{"name":"i16"},{"name":"ordering"},{"name":"ordering"}],"output":{"name":"result"}}],[11,"fetch_add","","Add to the current value, returning the previous value.",76,{"inputs":[{"name":"self"},{"name":"i16"},{"name":"ordering"}],"output":{"name":"i16"}}],[11,"fetch_sub","","Subtract from the current value, returning the previous value.",76,{"inputs":[{"name":"self"},{"name":"i16"},{"name":"ordering"}],"output":{"name":"i16"}}],[11,"fetch_and","","Bitwise and with the current value, returning the previous value.",76,{"inputs":[{"name":"self"},{"name":"i16"},{"name":"ordering"}],"output":{"name":"i16"}}],[11,"fetch_or","","Bitwise or with the current value, returning the previous value.",76,{"inputs":[{"name":"self"},{"name":"i16"},{"name":"ordering"}],"output":{"name":"i16"}}],[11,"fetch_xor","","Bitwise xor with the current value, returning the previous value.",76,{"inputs":[{"name":"self"},{"name":"i16"},{"name":"ordering"}],"output":{"name":"i16"}}],[11,"default","","",77,{"inputs":[],"output":{"name":"self"}}],[11,"fmt","","",77,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new atomic integer.",77,{"inputs":[{"name":"u16"}],"output":{"name":"self"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",77,{"inputs":[{"name":"self"}],"output":{"name":"u16"}}],[11,"into_inner","","Consumes the atomic and returns the contained value.",77,{"inputs":[{"name":"self"}],"output":{"name":"u16"}}],[11,"load","","Loads a value from the atomic integer.",77,{"inputs":[{"name":"self"},{"name":"ordering"}],"output":{"name":"u16"}}],[11,"store","","Stores a value into the atomic integer.",77,{"inputs":[{"name":"self"},{"name":"u16"},{"name":"ordering"}],"output":null}],[11,"swap","","Stores a value into the atomic integer, returning the old value.",77,{"inputs":[{"name":"self"},{"name":"u16"},{"name":"ordering"}],"output":{"name":"u16"}}],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",77,{"inputs":[{"name":"self"},{"name":"u16"},{"name":"u16"},{"name":"ordering"}],"output":{"name":"u16"}}],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",77,{"inputs":[{"name":"self"},{"name":"u16"},{"name":"u16"},{"name":"ordering"},{"name":"ordering"}],"output":{"name":"result"}}],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",77,{"inputs":[{"name":"self"},{"name":"u16"},{"name":"u16"},{"name":"ordering"},{"name":"ordering"}],"output":{"name":"result"}}],[11,"fetch_add","","Add to the current value, returning the previous value.",77,{"inputs":[{"name":"self"},{"name":"u16"},{"name":"ordering"}],"output":{"name":"u16"}}],[11,"fetch_sub","","Subtract from the current value, returning the previous value.",77,{"inputs":[{"name":"self"},{"name":"u16"},{"name":"ordering"}],"output":{"name":"u16"}}],[11,"fetch_and","","Bitwise and with the current value, returning the previous value.",77,{"inputs":[{"name":"self"},{"name":"u16"},{"name":"ordering"}],"output":{"name":"u16"}}],[11,"fetch_or","","Bitwise or with the current value, returning the previous value.",77,{"inputs":[{"name":"self"},{"name":"u16"},{"name":"ordering"}],"output":{"name":"u16"}}],[11,"fetch_xor","","Bitwise xor with the current value, returning the previous value.",77,{"inputs":[{"name":"self"},{"name":"u16"},{"name":"ordering"}],"output":{"name":"u16"}}],[11,"default","","",78,{"inputs":[],"output":{"name":"self"}}],[11,"fmt","","",78,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new atomic integer.",78,{"inputs":[{"name":"i32"}],"output":{"name":"self"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",78,{"inputs":[{"name":"self"}],"output":{"name":"i32"}}],[11,"into_inner","","Consumes the atomic and returns the contained value.",78,{"inputs":[{"name":"self"}],"output":{"name":"i32"}}],[11,"load","","Loads a value from the atomic integer.",78,{"inputs":[{"name":"self"},{"name":"ordering"}],"output":{"name":"i32"}}],[11,"store","","Stores a value into the atomic integer.",78,{"inputs":[{"name":"self"},{"name":"i32"},{"name":"ordering"}],"output":null}],[11,"swap","","Stores a value into the atomic integer, returning the old value.",78,{"inputs":[{"name":"self"},{"name":"i32"},{"name":"ordering"}],"output":{"name":"i32"}}],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",78,{"inputs":[{"name":"self"},{"name":"i32"},{"name":"i32"},{"name":"ordering"}],"output":{"name":"i32"}}],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",78,{"inputs":[{"name":"self"},{"name":"i32"},{"name":"i32"},{"name":"ordering"},{"name":"ordering"}],"output":{"name":"result"}}],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",78,{"inputs":[{"name":"self"},{"name":"i32"},{"name":"i32"},{"name":"ordering"},{"name":"ordering"}],"output":{"name":"result"}}],[11,"fetch_add","","Add to the current value, returning the previous value.",78,{"inputs":[{"name":"self"},{"name":"i32"},{"name":"ordering"}],"output":{"name":"i32"}}],[11,"fetch_sub","","Subtract from the current value, returning the previous value.",78,{"inputs":[{"name":"self"},{"name":"i32"},{"name":"ordering"}],"output":{"name":"i32"}}],[11,"fetch_and","","Bitwise and with the current value, returning the previous value.",78,{"inputs":[{"name":"self"},{"name":"i32"},{"name":"ordering"}],"output":{"name":"i32"}}],[11,"fetch_or","","Bitwise or with the current value, returning the previous value.",78,{"inputs":[{"name":"self"},{"name":"i32"},{"name":"ordering"}],"output":{"name":"i32"}}],[11,"fetch_xor","","Bitwise xor with the current value, returning the previous value.",78,{"inputs":[{"name":"self"},{"name":"i32"},{"name":"ordering"}],"output":{"name":"i32"}}],[11,"default","","",79,{"inputs":[],"output":{"name":"self"}}],[11,"fmt","","",79,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new atomic integer.",79,{"inputs":[{"name":"u32"}],"output":{"name":"self"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",79,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"into_inner","","Consumes the atomic and returns the contained value.",79,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"load","","Loads a value from the atomic integer.",79,{"inputs":[{"name":"self"},{"name":"ordering"}],"output":{"name":"u32"}}],[11,"store","","Stores a value into the atomic integer.",79,{"inputs":[{"name":"self"},{"name":"u32"},{"name":"ordering"}],"output":null}],[11,"swap","","Stores a value into the atomic integer, returning the old value.",79,{"inputs":[{"name":"self"},{"name":"u32"},{"name":"ordering"}],"output":{"name":"u32"}}],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",79,{"inputs":[{"name":"self"},{"name":"u32"},{"name":"u32"},{"name":"ordering"}],"output":{"name":"u32"}}],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",79,{"inputs":[{"name":"self"},{"name":"u32"},{"name":"u32"},{"name":"ordering"},{"name":"ordering"}],"output":{"name":"result"}}],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",79,{"inputs":[{"name":"self"},{"name":"u32"},{"name":"u32"},{"name":"ordering"},{"name":"ordering"}],"output":{"name":"result"}}],[11,"fetch_add","","Add to the current value, returning the previous value.",79,{"inputs":[{"name":"self"},{"name":"u32"},{"name":"ordering"}],"output":{"name":"u32"}}],[11,"fetch_sub","","Subtract from the current value, returning the previous value.",79,{"inputs":[{"name":"self"},{"name":"u32"},{"name":"ordering"}],"output":{"name":"u32"}}],[11,"fetch_and","","Bitwise and with the current value, returning the previous value.",79,{"inputs":[{"name":"self"},{"name":"u32"},{"name":"ordering"}],"output":{"name":"u32"}}],[11,"fetch_or","","Bitwise or with the current value, returning the previous value.",79,{"inputs":[{"name":"self"},{"name":"u32"},{"name":"ordering"}],"output":{"name":"u32"}}],[11,"fetch_xor","","Bitwise xor with the current value, returning the previous value.",79,{"inputs":[{"name":"self"},{"name":"u32"},{"name":"ordering"}],"output":{"name":"u32"}}],[11,"default","","",80,{"inputs":[],"output":{"name":"self"}}],[11,"fmt","","",80,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new atomic integer.",80,{"inputs":[{"name":"i64"}],"output":{"name":"self"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",80,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[11,"into_inner","","Consumes the atomic and returns the contained value.",80,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[11,"load","","Loads a value from the atomic integer.",80,{"inputs":[{"name":"self"},{"name":"ordering"}],"output":{"name":"i64"}}],[11,"store","","Stores a value into the atomic integer.",80,{"inputs":[{"name":"self"},{"name":"i64"},{"name":"ordering"}],"output":null}],[11,"swap","","Stores a value into the atomic integer, returning the old value.",80,{"inputs":[{"name":"self"},{"name":"i64"},{"name":"ordering"}],"output":{"name":"i64"}}],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",80,{"inputs":[{"name":"self"},{"name":"i64"},{"name":"i64"},{"name":"ordering"}],"output":{"name":"i64"}}],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",80,{"inputs":[{"name":"self"},{"name":"i64"},{"name":"i64"},{"name":"ordering"},{"name":"ordering"}],"output":{"name":"result"}}],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",80,{"inputs":[{"name":"self"},{"name":"i64"},{"name":"i64"},{"name":"ordering"},{"name":"ordering"}],"output":{"name":"result"}}],[11,"fetch_add","","Add to the current value, returning the previous value.",80,{"inputs":[{"name":"self"},{"name":"i64"},{"name":"ordering"}],"output":{"name":"i64"}}],[11,"fetch_sub","","Subtract from the current value, returning the previous value.",80,{"inputs":[{"name":"self"},{"name":"i64"},{"name":"ordering"}],"output":{"name":"i64"}}],[11,"fetch_and","","Bitwise and with the current value, returning the previous value.",80,{"inputs":[{"name":"self"},{"name":"i64"},{"name":"ordering"}],"output":{"name":"i64"}}],[11,"fetch_or","","Bitwise or with the current value, returning the previous value.",80,{"inputs":[{"name":"self"},{"name":"i64"},{"name":"ordering"}],"output":{"name":"i64"}}],[11,"fetch_xor","","Bitwise xor with the current value, returning the previous value.",80,{"inputs":[{"name":"self"},{"name":"i64"},{"name":"ordering"}],"output":{"name":"i64"}}],[11,"default","","",81,{"inputs":[],"output":{"name":"self"}}],[11,"fmt","","",81,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new atomic integer.",81,{"inputs":[{"name":"u64"}],"output":{"name":"self"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",81,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"into_inner","","Consumes the atomic and returns the contained value.",81,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"load","","Loads a value from the atomic integer.",81,{"inputs":[{"name":"self"},{"name":"ordering"}],"output":{"name":"u64"}}],[11,"store","","Stores a value into the atomic integer.",81,{"inputs":[{"name":"self"},{"name":"u64"},{"name":"ordering"}],"output":null}],[11,"swap","","Stores a value into the atomic integer, returning the old value.",81,{"inputs":[{"name":"self"},{"name":"u64"},{"name":"ordering"}],"output":{"name":"u64"}}],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",81,{"inputs":[{"name":"self"},{"name":"u64"},{"name":"u64"},{"name":"ordering"}],"output":{"name":"u64"}}],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",81,{"inputs":[{"name":"self"},{"name":"u64"},{"name":"u64"},{"name":"ordering"},{"name":"ordering"}],"output":{"name":"result"}}],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",81,{"inputs":[{"name":"self"},{"name":"u64"},{"name":"u64"},{"name":"ordering"},{"name":"ordering"}],"output":{"name":"result"}}],[11,"fetch_add","","Add to the current value, returning the previous value.",81,{"inputs":[{"name":"self"},{"name":"u64"},{"name":"ordering"}],"output":{"name":"u64"}}],[11,"fetch_sub","","Subtract from the current value, returning the previous value.",81,{"inputs":[{"name":"self"},{"name":"u64"},{"name":"ordering"}],"output":{"name":"u64"}}],[11,"fetch_and","","Bitwise and with the current value, returning the previous value.",81,{"inputs":[{"name":"self"},{"name":"u64"},{"name":"ordering"}],"output":{"name":"u64"}}],[11,"fetch_or","","Bitwise or with the current value, returning the previous value.",81,{"inputs":[{"name":"self"},{"name":"u64"},{"name":"ordering"}],"output":{"name":"u64"}}],[11,"fetch_xor","","Bitwise xor with the current value, returning the previous value.",81,{"inputs":[{"name":"self"},{"name":"u64"},{"name":"ordering"}],"output":{"name":"u64"}}],[11,"default","","",82,{"inputs":[],"output":{"name":"self"}}],[11,"fmt","","",82,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new atomic integer.",82,{"inputs":[{"name":"isize"}],"output":{"name":"self"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",82,{"inputs":[{"name":"self"}],"output":{"name":"isize"}}],[11,"into_inner","","Consumes the atomic and returns the contained value.",82,{"inputs":[{"name":"self"}],"output":{"name":"isize"}}],[11,"load","","Loads a value from the atomic integer.",82,{"inputs":[{"name":"self"},{"name":"ordering"}],"output":{"name":"isize"}}],[11,"store","","Stores a value into the atomic integer.",82,{"inputs":[{"name":"self"},{"name":"isize"},{"name":"ordering"}],"output":null}],[11,"swap","","Stores a value into the atomic integer, returning the old value.",82,{"inputs":[{"name":"self"},{"name":"isize"},{"name":"ordering"}],"output":{"name":"isize"}}],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",82,{"inputs":[{"name":"self"},{"name":"isize"},{"name":"isize"},{"name":"ordering"}],"output":{"name":"isize"}}],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",82,{"inputs":[{"name":"self"},{"name":"isize"},{"name":"isize"},{"name":"ordering"},{"name":"ordering"}],"output":{"name":"result"}}],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",82,{"inputs":[{"name":"self"},{"name":"isize"},{"name":"isize"},{"name":"ordering"},{"name":"ordering"}],"output":{"name":"result"}}],[11,"fetch_add","","Add to the current value, returning the previous value.",82,{"inputs":[{"name":"self"},{"name":"isize"},{"name":"ordering"}],"output":{"name":"isize"}}],[11,"fetch_sub","","Subtract from the current value, returning the previous value.",82,{"inputs":[{"name":"self"},{"name":"isize"},{"name":"ordering"}],"output":{"name":"isize"}}],[11,"fetch_and","","Bitwise and with the current value, returning the previous value.",82,{"inputs":[{"name":"self"},{"name":"isize"},{"name":"ordering"}],"output":{"name":"isize"}}],[11,"fetch_or","","Bitwise or with the current value, returning the previous value.",82,{"inputs":[{"name":"self"},{"name":"isize"},{"name":"ordering"}],"output":{"name":"isize"}}],[11,"fetch_xor","","Bitwise xor with the current value, returning the previous value.",82,{"inputs":[{"name":"self"},{"name":"isize"},{"name":"ordering"}],"output":{"name":"isize"}}],[11,"default","","",83,{"inputs":[],"output":{"name":"self"}}],[11,"fmt","","",83,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new atomic integer.",83,{"inputs":[{"name":"usize"}],"output":{"name":"self"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",83,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"into_inner","","Consumes the atomic and returns the contained value.",83,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"load","","Loads a value from the atomic integer.",83,{"inputs":[{"name":"self"},{"name":"ordering"}],"output":{"name":"usize"}}],[11,"store","","Stores a value into the atomic integer.",83,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"ordering"}],"output":null}],[11,"swap","","Stores a value into the atomic integer, returning the old value.",83,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"ordering"}],"output":{"name":"usize"}}],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",83,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"usize"},{"name":"ordering"}],"output":{"name":"usize"}}],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",83,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"usize"},{"name":"ordering"},{"name":"ordering"}],"output":{"name":"result"}}],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",83,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"usize"},{"name":"ordering"},{"name":"ordering"}],"output":{"name":"result"}}],[11,"fetch_add","","Add to the current value, returning the previous value.",83,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"ordering"}],"output":{"name":"usize"}}],[11,"fetch_sub","","Subtract from the current value, returning the previous value.",83,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"ordering"}],"output":{"name":"usize"}}],[11,"fetch_and","","Bitwise and with the current value, returning the previous value.",83,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"ordering"}],"output":{"name":"usize"}}],[11,"fetch_or","","Bitwise or with the current value, returning the previous value.",83,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"ordering"}],"output":{"name":"usize"}}],[11,"fetch_xor","","Bitwise xor with the current value, returning the previous value.",83,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"ordering"}],"output":{"name":"usize"}}],[11,"fmt","","",72,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",73,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[0,"cell","core","Shareable mutable containers.",null,null],[3,"Cell","core::cell","A mutable memory location.",null,null],[3,"RefCell","","A mutable memory location with dynamically checked borrow rules",null,null],[3,"BorrowError","","An error returned by `RefCell::try_borrow`.",null,null],[3,"BorrowMutError","","An error returned by `RefCell::try_borrow_mut`.",null,null],[3,"Ref","","Wraps a borrowed reference to a value in a `RefCell` box. A wrapper type for an immutably borrowed value from a `RefCell<T>`.",null,null],[3,"RefMut","","A wrapper type for a mutably borrowed value from a `RefCell<T>`.",null,null],[3,"UnsafeCell","","The core primitive for interior mutability in Rust.",null,null],[4,"BorrowState","","An enumeration of values returned from the `state` method on a `RefCell<T>`.",null,null],[13,"Reading","","The cell is currently being read, there is at least one active `borrow`.",84,null],[13,"Writing","","The cell is currently being written to, there is an active `borrow_mut`.",84,null],[13,"Unused","","There are no outstanding borrows on this cell.",84,null],[11,"get","","Returns a copy of the contained value.",85,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"clone","","",85,{"inputs":[{"name":"self"}],"output":{"name":"cell"}}],[11,"default","","Creates a `Cell<T>`, with the `Default` value for T.",85,{"inputs":[],"output":{"name":"cell"}}],[11,"eq","","",85,{"inputs":[{"name":"self"},{"name":"cell"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",85,{"inputs":[{"name":"self"},{"name":"cell"}],"output":{"name":"option"}}],[11,"lt","","",85,{"inputs":[{"name":"self"},{"name":"cell"}],"output":{"name":"bool"}}],[11,"le","","",85,{"inputs":[{"name":"self"},{"name":"cell"}],"output":{"name":"bool"}}],[11,"gt","","",85,{"inputs":[{"name":"self"},{"name":"cell"}],"output":{"name":"bool"}}],[11,"ge","","",85,{"inputs":[{"name":"self"},{"name":"cell"}],"output":{"name":"bool"}}],[11,"cmp","","",85,{"inputs":[{"name":"self"},{"name":"cell"}],"output":{"name":"ordering"}}],[11,"from","","",85,{"inputs":[{"name":"t"}],"output":{"name":"cell"}}],[11,"new","","Creates a new `Cell` containing the given value.",85,{"inputs":[{"name":"t"}],"output":{"name":"cell"}}],[11,"as_unsafe_cell","","Returns a reference to the underlying `UnsafeCell`.",85,{"inputs":[{"name":"self"}],"output":{"name":"unsafecell"}}],[11,"as_ptr","","Returns a raw pointer to the underlying data in this cell.",85,null],[11,"get_mut","","Returns a mutable reference to the underlying data.",85,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"set","","Sets the contained value.",85,{"inputs":[{"name":"self"},{"name":"t"}],"output":null}],[11,"swap","","Swaps the values of two Cells. Difference with `std::mem::swap` is that this function doesn't require `&mut` reference.",85,{"inputs":[{"name":"self"},{"name":"self"}],"output":null}],[11,"replace","","Replaces the contained value.",85,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"t"}}],[11,"into_inner","","Unwraps the value.",85,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"take","","Takes the value of the cell, leaving `Default::default()` in its place.",85,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"clone","","",84,{"inputs":[{"name":"self"}],"output":{"name":"borrowstate"}}],[11,"eq","","",84,{"inputs":[{"name":"self"},{"name":"borrowstate"}],"output":{"name":"bool"}}],[11,"fmt","","",84,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",86,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",86,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",87,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",87,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new `RefCell` containing `value`.",88,{"inputs":[{"name":"t"}],"output":{"name":"refcell"}}],[11,"into_inner","","Consumes the `RefCell`, returning the wrapped value.",88,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"borrow_state","","Query the current state of this `RefCell`",88,{"inputs":[{"name":"self"}],"output":{"name":"borrowstate"}}],[11,"borrow","","Immutably borrows the wrapped value.",88,{"inputs":[{"name":"self"}],"output":{"name":"ref"}}],[11,"try_borrow","","Immutably borrows the wrapped value, returning an error if the value is currently mutably borrowed.",88,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"borrow_mut","","Mutably borrows the wrapped value.",88,{"inputs":[{"name":"self"}],"output":{"name":"refmut"}}],[11,"try_borrow_mut","","Mutably borrows the wrapped value, returning an error if the value is currently borrowed.",88,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"as_unsafe_cell","","Returns a reference to the underlying `UnsafeCell`.",88,{"inputs":[{"name":"self"}],"output":{"name":"unsafecell"}}],[11,"as_ptr","","Returns a raw pointer to the underlying data in this cell.",88,null],[11,"get_mut","","Returns a mutable reference to the underlying data.",88,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"clone","","",88,{"inputs":[{"name":"self"}],"output":{"name":"refcell"}}],[11,"default","","Creates a `RefCell<T>`, with the `Default` value for T.",88,{"inputs":[],"output":{"name":"refcell"}}],[11,"eq","","",88,{"inputs":[{"name":"self"},{"name":"refcell"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",88,{"inputs":[{"name":"self"},{"name":"refcell"}],"output":{"name":"option"}}],[11,"lt","","",88,{"inputs":[{"name":"self"},{"name":"refcell"}],"output":{"name":"bool"}}],[11,"le","","",88,{"inputs":[{"name":"self"},{"name":"refcell"}],"output":{"name":"bool"}}],[11,"gt","","",88,{"inputs":[{"name":"self"},{"name":"refcell"}],"output":{"name":"bool"}}],[11,"ge","","",88,{"inputs":[{"name":"self"},{"name":"refcell"}],"output":{"name":"bool"}}],[11,"cmp","","",88,{"inputs":[{"name":"self"},{"name":"refcell"}],"output":{"name":"ordering"}}],[11,"from","","",88,{"inputs":[{"name":"t"}],"output":{"name":"refcell"}}],[11,"deref","","",89,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"clone","","Copies a `Ref`.",89,{"inputs":[{"name":"ref"}],"output":{"name":"ref"}}],[11,"map","","Make a new `Ref` for a component of the borrowed data.",89,{"inputs":[{"name":"ref"},{"name":"f"}],"output":{"name":"ref"}}],[11,"map","","Make a new `RefMut` for a component of the borrowed data, e.g. an enum variant.",90,{"inputs":[{"name":"refmut"},{"name":"f"}],"output":{"name":"refmut"}}],[11,"deref","","",90,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"deref_mut","","",90,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"new","","Constructs a new instance of `UnsafeCell` which will wrap the specified value.",91,{"inputs":[{"name":"t"}],"output":{"name":"unsafecell"}}],[11,"into_inner","","Unwraps the value.",91,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"get","","Gets a mutable pointer to the wrapped value.",91,null],[11,"default","","Creates an `UnsafeCell`, with the `Default` value for T.",91,{"inputs":[],"output":{"name":"unsafecell"}}],[11,"from","","",91,{"inputs":[{"name":"t"}],"output":{"name":"unsafecell"}}],[0,"char","core","Character manipulation.",null,null],[3,"CharTryFromError","core::char","The error type returned when a conversion from u32 to char fails.",null,null],[3,"EscapeUnicode","","Returns an iterator that yields the hexadecimal Unicode escape of a character, as `char`s.",null,null],[3,"EscapeDefault","","An iterator that yields the literal escape code of a `char`.",null,null],[3,"EscapeDebug","","An iterator that yields the literal escape code of a `char`.",null,null],[3,"DecodeUtf8","","An iterator over an iterator of bytes of the characters the bytes represent as UTF-8",null,null],[3,"InvalidSequence","","`<DecodeUtf8 as Iterator>::next` returns this for an invalid input sequence.",null,null],[5,"from_u32","","Converts a `u32` to a `char`.",null,{"inputs":[{"name":"u32"}],"output":{"name":"option"}}],[5,"from_u32_unchecked","","Converts a `u32` to a `char`, ignoring validity.",null,{"inputs":[{"name":"u32"}],"output":{"name":"char"}}],[5,"from_digit","","Converts a digit in the given radix to a `char`.",null,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"option"}}],[5,"decode_utf8","","Decodes an `Iterator` of bytes as UTF-8.",null,{"inputs":[{"name":"i"}],"output":{"name":"decodeutf8"}}],[17,"MAX","","The highest valid code point a `char` can have.",null,null],[11,"clone","","",92,{"inputs":[{"name":"self"}],"output":{"name":"chartryfromerror"}}],[11,"fmt","","",92,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",92,{"inputs":[{"name":"self"},{"name":"chartryfromerror"}],"output":{"name":"bool"}}],[11,"ne","","",92,{"inputs":[{"name":"self"},{"name":"chartryfromerror"}],"output":{"name":"bool"}}],[11,"fmt","","",92,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",93,{"inputs":[{"name":"self"}],"output":{"name":"escapeunicode"}}],[11,"fmt","","",93,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",93,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",93,null],[11,"count","","",93,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"last","","",93,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"len","","",93,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"fmt","","",93,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",94,{"inputs":[{"name":"self"}],"output":{"name":"escapedefault"}}],[11,"fmt","","",94,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",94,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",94,null],[11,"count","","",94,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"nth","","",94,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",94,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"len","","",94,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"fmt","","",94,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",95,{"inputs":[{"name":"self"}],"output":{"name":"escapedebug"}}],[11,"fmt","","",95,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",95,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",95,null],[11,"fmt","","",95,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",96,{"inputs":[{"name":"self"}],"output":{"name":"decodeutf8"}}],[11,"fmt","","",96,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",97,{"inputs":[{"name":"self"},{"name":"invalidsequence"}],"output":{"name":"bool"}}],[11,"ne","","",97,{"inputs":[{"name":"self"},{"name":"invalidsequence"}],"output":{"name":"bool"}}],[11,"fmt","","",97,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",96,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[0,"panicking","core","Panic support for libcore",null,null],[5,"panic","core::panicking","",null,null],[5,"panic_fmt","","",null,null],[0,"iter","core","Composable external iteration.",null,null],[3,"StepBy","core::iter","An adapter for stepping range iterators by a custom amount.",null,null],[3,"Repeat","","An iterator that repeats an element endlessly.",null,null],[3,"Empty","","An iterator that yields nothing.",null,null],[3,"Once","","An iterator that yields an element exactly once.",null,null],[3,"Rev","","A double-ended iterator with the direction inverted.",null,null],[3,"Cloned","","An iterator that clones the elements of an underlying iterator.",null,null],[3,"Cycle","","An iterator that repeats endlessly.",null,null],[3,"Chain","","An iterator that strings two iterators together.",null,null],[3,"Zip","","An iterator that iterates two other iterators simultaneously.",null,null],[3,"Map","","An iterator that maps the values of `iter` with `f`.",null,null],[3,"Filter","","An iterator that filters the elements of `iter` with `predicate`.",null,null],[3,"FilterMap","","An iterator that uses `f` to both filter and map elements from `iter`.",null,null],[3,"Enumerate","","An iterator that yields the current count and the element during iteration.",null,null],[3,"Peekable","","An iterator with a `peek()` that returns an optional reference to the next element.",null,null],[3,"SkipWhile","","An iterator that rejects elements while `predicate` is true.",null,null],[3,"TakeWhile","","An iterator that only accepts elements while `predicate` is true.",null,null],[3,"Skip","","An iterator that skips over `n` elements of `iter`.",null,null],[3,"Take","","An iterator that only iterates over the first `n` iterations of `iter`.",null,null],[3,"Scan","","An iterator to maintain state while iterating another iterator.",null,null],[3,"FlatMap","","An iterator that maps each element to an iterator, and yields the elements of the produced iterators.",null,null],[3,"Fuse","","An iterator that yields `None` forever after the underlying iterator yields `None` once.",null,null],[3,"Inspect","","An iterator that calls a function with a reference to each element before yielding it.",null,null],[5,"repeat","","Creates a new iterator that endlessly repeats a single element.",null,{"inputs":[{"name":"t"}],"output":{"name":"repeat"}}],[5,"empty","","Creates an iterator that yields nothing.",null,{"inputs":[],"output":{"name":"empty"}}],[5,"once","","Creates an iterator that yields an element exactly once.",null,{"inputs":[{"name":"t"}],"output":{"name":"once"}}],[11,"clone","","",98,{"inputs":[{"name":"self"}],"output":{"name":"stepby"}}],[11,"fmt","","",98,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"step_by","core::ops","Creates an iterator starting at the same point, but stepping by the given amount at each iteration.",13,{"inputs":[{"name":"self"},{"name":"a"}],"output":{"name":"stepby"}}],[11,"step_by","","Creates an iterator with the same range, but stepping by the given amount at each iteration.",12,{"inputs":[{"name":"self"},{"name":"a"}],"output":{"name":"stepby"}}],[11,"step_by","","Creates an iterator with the same range, but stepping by the given amount at each iteration.",16,{"inputs":[{"name":"self"},{"name":"a"}],"output":{"name":"stepby"}}],[11,"next","core::iter","",98,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",98,null],[11,"next","","",98,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",98,null],[11,"next","","",98,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",98,null],[11,"next","core::ops","",12,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",12,null],[11,"next_back","","",12,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",13,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",16,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",16,null],[11,"next_back","","",16,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","core::iter","",99,{"inputs":[{"name":"self"}],"output":{"name":"repeat"}}],[11,"fmt","","",99,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",99,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",99,null],[11,"next_back","","",99,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",100,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",100,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",100,null],[11,"next_back","","",100,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"len","","",100,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"clone","","",100,{"inputs":[{"name":"self"}],"output":{"name":"empty"}}],[11,"default","","",100,{"inputs":[],"output":{"name":"empty"}}],[11,"clone","","",101,{"inputs":[{"name":"self"}],"output":{"name":"once"}}],[11,"fmt","","",101,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",101,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",101,null],[11,"next_back","","",101,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"len","","",101,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"sum","core::num","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[8,"Iterator","core::iter","An interface for dealing with iterators.",null,null],[16,"Item","","The type of the elements being iterated over.",102,null],[10,"next","","Advances the iterator and returns the next value.",102,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","Returns the bounds on the remaining length of the iterator.",102,null],[11,"count","","Consumes the iterator, counting the number of iterations and returning it.",102,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"last","","Consumes the iterator, returning the last element.",102,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"nth","","Returns the `n`th element of the iterator.",102,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"chain","","Takes two iterators and creates a new iterator over both in sequence.",102,{"inputs":[{"name":"self"},{"name":"u"}],"output":{"name":"chain"}}],[11,"zip","","'Zips up' two iterators into a single iterator of pairs.",102,{"inputs":[{"name":"self"},{"name":"u"}],"output":{"name":"zip"}}],[11,"map","","Takes a closure and creates an iterator which calls that closure on each element.",102,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"map"}}],[11,"filter","","Creates an iterator which uses a closure to determine if an element should be yielded.",102,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"filter"}}],[11,"filter_map","","Creates an iterator that both filters and maps.",102,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"filtermap"}}],[11,"enumerate","","Creates an iterator which gives the current iteration count as well as the next value.",102,{"inputs":[{"name":"self"}],"output":{"name":"enumerate"}}],[11,"peekable","","Creates an iterator which can use `peek` to look at the next element of the iterator without consuming it.",102,{"inputs":[{"name":"self"}],"output":{"name":"peekable"}}],[11,"skip_while","","Creates an iterator that [`skip()`]s elements based on a predicate.",102,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"skipwhile"}}],[11,"take_while","","Creates an iterator that yields elements based on a predicate.",102,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"takewhile"}}],[11,"skip","","Creates an iterator that skips the first `n` elements.",102,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"skip"}}],[11,"take","","Creates an iterator that yields its first `n` elements.",102,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"take"}}],[11,"scan","","An iterator adaptor similar to [`fold()`] that holds internal state and produces a new iterator.",102,{"inputs":[{"name":"self"},{"name":"st"},{"name":"f"}],"output":{"name":"scan"}}],[11,"flat_map","","Creates an iterator that works like map, but flattens nested structure.",102,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"flatmap"}}],[11,"fuse","","Creates an iterator which ends after the first [`None`].",102,{"inputs":[{"name":"self"}],"output":{"name":"fuse"}}],[11,"inspect","","Do something with each element of an iterator, passing the value on.",102,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"inspect"}}],[11,"by_ref","","Borrows an iterator, rather than consuming it.",102,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"collect","","Transforms an iterator into a collection.",102,{"inputs":[{"name":"self"}],"output":{"name":"b"}}],[11,"partition","","Consumes an iterator, creating two collections from it.",102,null],[11,"fold","","An iterator adaptor that applies a function, producing a single, final value.",102,{"inputs":[{"name":"self"},{"name":"b"},{"name":"f"}],"output":{"name":"b"}}],[11,"all","","Tests if every element of the iterator matches a predicate.",102,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"any","","Tests if any element of the iterator matches a predicate.",102,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"find","","Searches for an element of an iterator that satisfies a predicate.",102,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"option"}}],[11,"position","","Searches for an element in an iterator, returning its index.",102,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"option"}}],[11,"rposition","","Searches for an element in an iterator from the right, returning its index.",102,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"option"}}],[11,"max","","Returns the maximum element of an iterator.",102,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"min","","Returns the minimum element of an iterator.",102,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"max_by_key","","Returns the element that gives the maximum value from the specified function.",102,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"max_by","","Returns the element that gives the maximum value with respect to the specified comparison function.",102,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"min_by_key","","Returns the element that gives the minimum value from the specified function.",102,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"min_by","","Returns the element that gives the minimum value with respect to the specified comparison function.",102,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"rev","","Reverses an iterator's direction.",102,{"inputs":[{"name":"self"}],"output":{"name":"rev"}}],[11,"unzip","","Converts an iterator of pairs into a pair of containers.",102,null],[11,"cloned","","Creates an iterator which [`clone()`]s all of its elements.",102,{"inputs":[{"name":"self"}],"output":{"name":"cloned"}}],[11,"cycle","","Repeats an iterator endlessly.",102,{"inputs":[{"name":"self"}],"output":{"name":"cycle"}}],[11,"sum","","Sums the elements of an iterator.",102,{"inputs":[{"name":"self"}],"output":{"name":"s"}}],[11,"product","","Iterates over the entire iterator, multiplying all the elements",102,{"inputs":[{"name":"self"}],"output":{"name":"p"}}],[11,"cmp","","Lexicographically compares the elements of this `Iterator` with those of another.",102,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","Lexicographically compares the elements of this `Iterator` with those of another.",102,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"option"}}],[11,"eq","","Determines if the elements of this `Iterator` are equal to those of another.",102,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"bool"}}],[11,"ne","","Determines if the elements of this `Iterator` are unequal to those of another.",102,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"bool"}}],[11,"lt","","Determines if the elements of this `Iterator` are lexicographically less than those of another.",102,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"bool"}}],[11,"le","","Determines if the elements of this `Iterator` are lexicographically less or equal to those of another.",102,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"bool"}}],[11,"gt","","Determines if the elements of this `Iterator` are lexicographically greater than those of another.",102,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"bool"}}],[11,"ge","","Determines if the elements of this `Iterator` are lexicographically greater than or equal to those of another.",102,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"bool"}}],[8,"Step","","Objects that can be stepped over in both directions.",null,null],[10,"step","","Steps `self` if possible.",103,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"option"}}],[10,"steps_between","","Returns the number of steps between two step objects. The count is inclusive of `start` and exclusive of `end`.",103,{"inputs":[{"name":"self"},{"name":"self"},{"name":"self"}],"output":{"name":"option"}}],[10,"steps_between_by_one","","Same as `steps_between`, but with a `by` of 1",103,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"option"}}],[10,"is_negative","","Tests whether this step is negative or not (going backwards)",103,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[10,"replace_one","","Replaces this step with `1`, returning itself",103,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[10,"replace_zero","","Replaces this step with `0`, returning itself",103,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[10,"add_one","","Adds one to this step, returning the result",103,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[10,"sub_one","","Subtracts one to this step, returning the result",103,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[8,"FromIterator","","Conversion from an `Iterator`.",null,null],[10,"from_iter","","Creates a value from an iterator.",104,{"inputs":[{"name":"t"}],"output":{"name":"self"}}],[8,"IntoIterator","","Conversion into an `Iterator`.",null,null],[16,"Item","","The type of the elements being iterated over.",105,null],[16,"IntoIter","","Which kind of iterator are we turning this into?",105,null],[10,"into_iter","","Creates an iterator from a value.",105,null],[8,"DoubleEndedIterator","","An iterator able to yield elements from both ends.",null,null],[10,"next_back","","Removes and returns an element from the end of the iterator.",106,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"rfind","","Searches for an element of an iterator from the right that satisfies a predicate.",106,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"option"}}],[8,"Extend","","Extend a collection with the contents of an iterator.",null,null],[10,"extend","","Extends a collection with the contents of an iterator.",107,{"inputs":[{"name":"self"},{"name":"t"}],"output":null}],[8,"ExactSizeIterator","","An iterator that knows its exact length.",null,null],[11,"len","","Returns the exact number of times the iterator will iterate.",108,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","Returns whether the iterator is empty.",108,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[8,"Sum","","Trait to represent types that can be created by summing up an iterator.",null,null],[10,"sum","","Method which takes an iterator and generates `Self` from the elements by \"summing up\" the items.",109,{"inputs":[{"name":"i"}],"output":{"name":"self"}}],[8,"Product","","Trait to represent types that can be created by multiplying elements of an iterator.",null,null],[10,"product","","Method which takes an iterator and generates `Self` from the elements by multiplying the items.",110,{"inputs":[{"name":"i"}],"output":{"name":"self"}}],[8,"FusedIterator","","An iterator that always continues to yield `None` when exhausted.",null,null],[8,"TrustedLen","","An iterator that reports an accurate length using size_hint.",null,null],[11,"clone","","",111,{"inputs":[{"name":"self"}],"output":{"name":"rev"}}],[11,"fmt","","",111,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",111,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",111,null],[11,"next_back","","",111,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"len","","",111,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","",111,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",112,{"inputs":[{"name":"self"}],"output":{"name":"cloned"}}],[11,"fmt","","",112,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",112,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",112,null],[11,"fold","","",112,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"f"}],"output":{"name":"acc"}}],[11,"next_back","","",112,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"len","","",112,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","",112,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",113,{"inputs":[{"name":"self"}],"output":{"name":"cycle"}}],[11,"fmt","","",113,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",113,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",113,null],[11,"clone","","",114,{"inputs":[{"name":"self"}],"output":{"name":"chain"}}],[11,"fmt","","",114,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",114,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"count","","",114,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"fold","","",114,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"f"}],"output":{"name":"acc"}}],[11,"nth","","",114,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"find","","",114,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"option"}}],[11,"last","","",114,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",114,null],[11,"next_back","","",114,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",115,{"inputs":[{"name":"self"}],"output":{"name":"zip"}}],[11,"fmt","","",115,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",115,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",115,null],[11,"next_back","","",115,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",116,{"inputs":[{"name":"self"}],"output":{"name":"map"}}],[11,"fmt","","",116,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",116,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",116,null],[11,"fold","","",116,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"g"}],"output":{"name":"acc"}}],[11,"next_back","","",116,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"len","","",116,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","",116,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",117,{"inputs":[{"name":"self"}],"output":{"name":"filter"}}],[11,"fmt","","",117,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",117,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",117,null],[11,"count","","",117,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"next_back","","",117,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",118,{"inputs":[{"name":"self"}],"output":{"name":"filtermap"}}],[11,"fmt","","",118,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",118,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",118,null],[11,"next_back","","",118,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",119,{"inputs":[{"name":"self"}],"output":{"name":"enumerate"}}],[11,"fmt","","",119,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","Overflow Behavior",119,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",119,null],[11,"nth","","",119,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"count","","",119,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"next_back","","",119,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"len","","",119,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","",119,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",120,{"inputs":[{"name":"self"}],"output":{"name":"peekable"}}],[11,"fmt","","",120,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",120,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"count","","",120,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"nth","","",120,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",120,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",120,null],[11,"peek","","Returns a reference to the next() value without advancing the iterator.",120,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",121,{"inputs":[{"name":"self"}],"output":{"name":"skipwhile"}}],[11,"fmt","","",121,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",121,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",121,null],[11,"clone","","",122,{"inputs":[{"name":"self"}],"output":{"name":"takewhile"}}],[11,"fmt","","",122,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",122,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",122,null],[11,"clone","","",123,{"inputs":[{"name":"self"}],"output":{"name":"skip"}}],[11,"fmt","","",123,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",123,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"nth","","",123,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"count","","",123,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"last","","",123,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",123,null],[11,"next_back","","",123,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",124,{"inputs":[{"name":"self"}],"output":{"name":"take"}}],[11,"fmt","","",124,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",124,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"nth","","",124,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"size_hint","","",124,null],[11,"clone","","",125,{"inputs":[{"name":"self"}],"output":{"name":"scan"}}],[11,"fmt","","",125,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",125,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",125,null],[11,"clone","","",126,{"inputs":[{"name":"self"}],"output":{"name":"flatmap"}}],[11,"fmt","","",126,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",126,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",126,null],[11,"next_back","","",126,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",127,{"inputs":[{"name":"self"}],"output":{"name":"fuse"}}],[11,"fmt","","",127,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",127,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"nth","","",127,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",127,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"count","","",127,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"size_hint","","",127,null],[11,"next_back","","",127,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",127,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"nth","","",127,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",127,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"count","","",127,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"size_hint","","",127,null],[11,"next_back","","",127,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"len","","",127,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","",127,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",128,{"inputs":[{"name":"self"}],"output":{"name":"inspect"}}],[11,"fmt","","",128,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",128,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",128,null],[11,"next_back","","",128,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"len","","",128,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","",128,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[0,"option","core","Optional values.",null,null],[3,"Iter","core::option","An iterator over a reference of the contained item in an [`Option`].",null,null],[3,"IterMut","","An iterator over a mutable reference of the contained item in an [`Option`].",null,null],[3,"IntoIter","","An iterator over the item contained inside an [`Option`].",null,null],[4,"Option","","The `Option` type. See the module level documentation for more.",null,null],[13,"None","","No value",129,null],[13,"Some","","Some value `T`",129,null],[11,"clone","","",129,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"eq","","",129,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"name":"bool"}}],[11,"ne","","",129,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",129,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"name":"option"}}],[11,"lt","","",129,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"name":"bool"}}],[11,"le","","",129,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"name":"bool"}}],[11,"gt","","",129,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"name":"bool"}}],[11,"ge","","",129,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"name":"bool"}}],[11,"cmp","","",129,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"name":"ordering"}}],[11,"fmt","","",129,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",129,null],[11,"is_some","","Returns `true` if the option is a `Some` value.",129,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_none","","Returns `true` if the option is a `None` value.",129,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"as_ref","","Converts from `Option<T>` to `Option<&T>`.",129,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"as_mut","","Converts from `Option<T>` to `Option<&mut T>`.",129,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"expect","","Unwraps an option, yielding the content of a `Some`.",129,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"t"}}],[11,"unwrap","","Moves the value `v` out of the `Option<T>` if it is `Some(v)`.",129,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"unwrap_or","","Returns the contained value or a default.",129,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"t"}}],[11,"unwrap_or_else","","Returns the contained value or computes it from a closure.",129,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"t"}}],[11,"map","","Maps an `Option<T>` to `Option<U>` by applying a function to a contained value.",129,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"map_or","","Applies a function to the contained value (if any), or returns a `default` (if not).",129,{"inputs":[{"name":"self"},{"name":"u"},{"name":"f"}],"output":{"name":"u"}}],[11,"map_or_else","","Applies a function to the contained value (if any), or computes a `default` (if not).",129,{"inputs":[{"name":"self"},{"name":"d"},{"name":"f"}],"output":{"name":"u"}}],[11,"ok_or","","Transforms the `Option<T>` into a [`Result<T, E>`], mapping `Some(v)` to [`Ok(v)`] and `None` to [`Err(err)`][Err].",129,{"inputs":[{"name":"self"},{"name":"e"}],"output":{"name":"result"}}],[11,"ok_or_else","","Transforms the `Option<T>` into a [`Result<T, E>`], mapping `Some(v)` to [`Ok(v)`] and `None` to [`Err(err())`][Err].",129,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"result"}}],[11,"iter","","Returns an iterator over the possibly contained value.",129,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"iter_mut","","Returns a mutable iterator over the possibly contained value.",129,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"and","","Returns `None` if the option is `None`, otherwise returns `optb`.",129,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"name":"option"}}],[11,"and_then","","Returns `None` if the option is `None`, otherwise calls `f` with the wrapped value and returns the result.",129,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"or","","Returns the option if it contains a value, otherwise returns `optb`.",129,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"name":"option"}}],[11,"or_else","","Returns the option if it contains a value, otherwise calls `f` and returns the result.",129,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"get_or_insert","","Inserts `v` into the option if it is `None`, then returns a mutable reference to the contained value.",129,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"t"}}],[11,"get_or_insert_with","","Inserts a value computed from `f` into the option if it is `None`, then returns a mutable reference to the contained value.",129,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"t"}}],[11,"take","","Takes the value out of the option, leaving a `None` in its place.",129,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"cloned","","Maps an `Option<&T>` to an `Option<T>` by cloning the contents of the option.",129,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"unwrap_or_default","","Returns the contained value or a default",129,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"default","","Returns None.",129,{"inputs":[],"output":{"name":"option"}}],[11,"into_iter","","Returns a consuming iterator over the possibly contained value.",129,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"from","","",129,{"inputs":[{"name":"t"}],"output":{"name":"option"}}],[11,"fmt","","",130,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",130,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",130,null],[11,"next_back","","",130,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",130,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"fmt","","",131,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",131,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",131,null],[11,"next_back","","",131,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",132,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"fmt","","",132,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",132,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",132,null],[11,"next_back","","",132,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"from_iter","","Takes each element in the `Iterator`: if it is `None`, no further elements are taken, and the `None` is returned. Should no `None` occur, a container with the values of each `Option` is returned.",129,{"inputs":[{"name":"i"}],"output":{"name":"option"}}],[0,"raw","core","Contains struct definitions for the layout of compiler built-in types.",null,null],[3,"TraitObject","core::raw","The representation of a trait object like `&SomeTrait`.",null,null],[12,"data","","",133,null],[12,"vtable","","",133,null],[11,"clone","","",133,{"inputs":[{"name":"self"}],"output":{"name":"traitobject"}}],[0,"result","core","Error handling with the `Result` type.",null,null],[3,"Iter","core::result","An iterator over a reference to the [`Ok`] variant of a [`Result`].",null,null],[3,"IterMut","","An iterator over a mutable reference to the [`Ok`] variant of a [`Result`].",null,null],[3,"IntoIter","","An iterator over the value in a [`Ok`] variant of a [`Result`].",null,null],[4,"Result","","`Result` is a type that represents either success (`Ok`) or failure (`Err`).",null,null],[13,"Ok","","Contains the success value",134,null],[13,"Err","","Contains the error value",134,null],[11,"clone","","",134,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"eq","","",134,{"inputs":[{"name":"self"},{"name":"result"}],"output":{"name":"bool"}}],[11,"ne","","",134,{"inputs":[{"name":"self"},{"name":"result"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",134,{"inputs":[{"name":"self"},{"name":"result"}],"output":{"name":"option"}}],[11,"lt","","",134,{"inputs":[{"name":"self"},{"name":"result"}],"output":{"name":"bool"}}],[11,"le","","",134,{"inputs":[{"name":"self"},{"name":"result"}],"output":{"name":"bool"}}],[11,"gt","","",134,{"inputs":[{"name":"self"},{"name":"result"}],"output":{"name":"bool"}}],[11,"ge","","",134,{"inputs":[{"name":"self"},{"name":"result"}],"output":{"name":"bool"}}],[11,"cmp","","",134,{"inputs":[{"name":"self"},{"name":"result"}],"output":{"name":"ordering"}}],[11,"fmt","","",134,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",134,null],[11,"is_ok","","Returns true if the result is `Ok`.",134,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_err","","Returns true if the result is `Err`.",134,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"ok","","Converts from `Result<T, E>` to [`Option<T>`].",134,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"err","","Converts from `Result<T, E>` to [`Option<E>`].",134,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"as_ref","","Converts from `Result<T, E>` to `Result<&T, &E>`.",134,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"as_mut","","Converts from `Result<T, E>` to `Result<&mut T, &mut E>`.",134,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"map","","Maps a `Result<T, E>` to `Result<U, E>` by applying a function to a contained `Ok` value, leaving an `Err` value untouched.",134,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"result"}}],[11,"map_err","","Maps a `Result<T, E>` to `Result<T, F>` by applying a function to a contained `Err` value, leaving an `Ok` value untouched.",134,{"inputs":[{"name":"self"},{"name":"o"}],"output":{"name":"result"}}],[11,"iter","","Returns an iterator over the possibly contained value.",134,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"iter_mut","","Returns a mutable iterator over the possibly contained value.",134,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"and","","Returns `res` if the result is `Ok`, otherwise returns the `Err` value of `self`.",134,{"inputs":[{"name":"self"},{"name":"result"}],"output":{"name":"result"}}],[11,"and_then","","Calls `op` if the result is `Ok`, otherwise returns the `Err` value of `self`.",134,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"result"}}],[11,"or","","Returns `res` if the result is `Err`, otherwise returns the `Ok` value of `self`.",134,{"inputs":[{"name":"self"},{"name":"result"}],"output":{"name":"result"}}],[11,"or_else","","Calls `op` if the result is `Err`, otherwise returns the `Ok` value of `self`.",134,{"inputs":[{"name":"self"},{"name":"o"}],"output":{"name":"result"}}],[11,"unwrap_or","","Unwraps a result, yielding the content of an `Ok`. Else, it returns `optb`.",134,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"t"}}],[11,"unwrap_or_else","","Unwraps a result, yielding the content of an `Ok`. If the value is an `Err` then it calls `op` with its value.",134,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"t"}}],[11,"unwrap","","Unwraps a result, yielding the content of an `Ok`.",134,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"expect","","Unwraps a result, yielding the content of an `Ok`.",134,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"t"}}],[11,"unwrap_err","","Unwraps a result, yielding the content of an `Err`.",134,{"inputs":[{"name":"self"}],"output":{"name":"e"}}],[11,"expect_err","","Unwraps a result, yielding the content of an `Err`.",134,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"e"}}],[11,"unwrap_or_default","","Returns the contained value or a default",134,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"into_iter","","Returns a consuming iterator over the possibly contained value.",134,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"fmt","","",135,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",135,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",135,null],[11,"next_back","","",135,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",135,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"fmt","","",136,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",136,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",136,null],[11,"next_back","","",136,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",137,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",137,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",137,null],[11,"next_back","","",137,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"from_iter","","Takes each element in the `Iterator`: if it is an `Err`, no further elements are taken, and the `Err` is returned. Should no `Err` occur, a container with the values of each `Result` is returned.",134,{"inputs":[{"name":"i"}],"output":{"name":"result"}}],[0,"slice","core","Slice management and manipulation",null,null],[3,"Iter","core::slice","Immutable slice iterator",null,null],[3,"IterMut","","Mutable slice iterator.",null,null],[3,"Split","","An iterator over subslices separated by elements that match a predicate function.",null,null],[3,"SplitMut","","An iterator over the subslices of the vector which are separated by elements that match `pred`.",null,null],[3,"SplitN","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits.",null,null],[3,"RSplitN","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits, starting from the end of the slice.",null,null],[3,"SplitNMut","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits.",null,null],[3,"RSplitNMut","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits, starting from the end of the slice.",null,null],[3,"Windows","","An iterator over overlapping subslices of length `size`.",null,null],[3,"Chunks","","An iterator over a slice in (non-overlapping) chunks (`size` elements at a time).",null,null],[3,"ChunksMut","","An iterator over a slice in (non-overlapping) mutable chunks (`size` elements at a time). When the slice len is not evenly divided by the chunk size, the last slice of the iteration will be the remainder.",null,null],[5,"from_raw_parts","","Forms a slice from a pointer and a length.",null,null],[5,"from_raw_parts_mut","","Performs the same functionality as `from_raw_parts`, except that a mutable slice is returned.",null,null],[8,"SliceExt","","Extension methods for slices.",null,null],[16,"Item","","",138,null],[10,"split_at","","",138,null],[10,"iter","","",138,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[10,"split","","",138,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"split"}}],[10,"splitn","","",138,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"p"}],"output":{"name":"splitn"}}],[10,"rsplitn","","",138,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"p"}],"output":{"name":"rsplitn"}}],[10,"windows","","",138,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"windows"}}],[10,"chunks","","",138,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"chunks"}}],[10,"get","","",138,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"option"}}],[10,"first","","",138,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[10,"split_first","","",138,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[10,"split_last","","",138,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[10,"last","","",138,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[10,"get_unchecked","","",138,null],[10,"as_ptr","","",138,null],[10,"binary_search","","",138,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"result"}}],[10,"binary_search_by","","",138,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"result"}}],[10,"binary_search_by_key","","",138,{"inputs":[{"name":"self"},{"name":"q"},{"name":"f"}],"output":{"name":"result"}}],[10,"len","","",138,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","",138,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[10,"get_mut","","",138,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"option"}}],[10,"iter_mut","","",138,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[10,"first_mut","","",138,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[10,"split_first_mut","","",138,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[10,"split_last_mut","","",138,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[10,"last_mut","","",138,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[10,"split_mut","","",138,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"splitmut"}}],[10,"splitn_mut","","",138,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"p"}],"output":{"name":"splitnmut"}}],[10,"rsplitn_mut","","",138,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"p"}],"output":{"name":"rsplitnmut"}}],[10,"chunks_mut","","",138,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"chunksmut"}}],[10,"swap","","",138,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"usize"}],"output":null}],[10,"split_at_mut","","",138,null],[10,"reverse","","",138,{"inputs":[{"name":"self"}],"output":null}],[10,"get_unchecked_mut","","",138,null],[10,"as_mut_ptr","","",138,null],[10,"contains","","",138,null],[10,"starts_with","","",138,null],[10,"ends_with","","",138,null],[10,"clone_from_slice","","",138,null],[10,"copy_from_slice","","",138,null],[8,"SliceIndex","","A helper trait used for indexing operations.",null,null],[16,"Output","","The output type returned by methods.",139,null],[10,"get","","Returns a shared reference to the output at this location, if in bounds.",139,null],[10,"get_mut","","Returns a mutable reference to the output at this location, if in bounds.",139,null],[10,"get_unchecked","","Returns a shared reference to the output at this location, without performing any bounds checking.",139,null],[10,"get_unchecked_mut","","Returns a mutable reference to the output at this location, without performing any bounds checking.",139,null],[10,"index","","Returns a shared reference to the output at this location, panicking if out of bounds.",139,null],[10,"index_mut","","Returns a mutable reference to the output at this location, panicking if out of bounds.",139,null],[11,"get","core::ops","",12,null],[11,"get_mut","","",12,null],[11,"get_unchecked","","",12,null],[11,"get_unchecked_mut","","",12,null],[11,"index","","",12,null],[11,"index_mut","","",12,null],[11,"get","","",14,null],[11,"get_mut","","",14,null],[11,"get_unchecked","","",14,null],[11,"get_unchecked_mut","","",14,null],[11,"index","","",14,null],[11,"index_mut","","",14,null],[11,"get","","",13,null],[11,"get_mut","","",13,null],[11,"get_unchecked","","",13,null],[11,"get_unchecked_mut","","",13,null],[11,"index","","",13,null],[11,"index_mut","","",13,null],[11,"get","","",53,null],[11,"get_mut","","",53,null],[11,"get_unchecked","","",53,null],[11,"get_unchecked_mut","","",53,null],[11,"index","","",53,null],[11,"index_mut","","",53,null],[11,"get","","",16,null],[11,"get_mut","","",16,null],[11,"get_unchecked","","",16,null],[11,"get_unchecked_mut","","",16,null],[11,"index","","",16,null],[11,"index_mut","","",16,null],[11,"get","","",15,null],[11,"get_mut","","",15,null],[11,"get_unchecked","","",15,null],[11,"get_unchecked_mut","","",15,null],[11,"index","","",15,null],[11,"index_mut","","",15,null],[11,"fmt","core::slice","",140,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"as_slice","","View the underlying data as a subslice of the original data.",140,null],[11,"next","","",140,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",140,null],[11,"count","","",140,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"nth","","",140,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",140,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"all","","",140,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"any","","",140,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"find","","",140,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"position","","",140,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"rposition","","",140,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"next_back","","",140,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"is_empty","","",140,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",140,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"as_ref","","",140,null],[11,"fmt","","",141,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"into_slice","","View the underlying data as a subslice of the original data.",141,null],[11,"next","","",141,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",141,null],[11,"count","","",141,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"nth","","",141,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",141,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"all","","",141,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"any","","",141,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"find","","",141,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"position","","",141,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"rposition","","",141,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"next_back","","",141,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"is_empty","","",141,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"fmt","","",142,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",142,{"inputs":[{"name":"self"}],"output":{"name":"split"}}],[11,"next","","",142,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",142,null],[11,"next_back","","",142,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",143,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",143,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",143,null],[11,"next_back","","",143,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",144,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",145,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",146,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",147,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",144,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",144,null],[11,"next","","",145,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",145,null],[11,"next","","",146,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",146,null],[11,"next","","",147,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",147,null],[11,"fmt","","",148,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",148,{"inputs":[{"name":"self"}],"output":{"name":"windows"}}],[11,"next","","",148,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",148,null],[11,"count","","",148,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"nth","","",148,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",148,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",148,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",149,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",149,{"inputs":[{"name":"self"}],"output":{"name":"chunks"}}],[11,"next","","",149,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",149,null],[11,"count","","",149,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"nth","","",149,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",149,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",149,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",150,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",150,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",150,null],[11,"count","","",150,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"nth","","",150,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",150,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",150,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[0,"str","core","String manipulation",null,null],[3,"ParseBoolError","core::str","An error returned when parsing a `bool` from a string fails.",null,null],[3,"Utf8Error","","Errors which can occur when attempting to interpret a sequence of `u8` as a string.",null,null],[3,"Chars","","Iterator for the char (representing *Unicode Scalar Values*) of a string",null,null],[3,"CharIndices","","Iterator for a string's characters and their byte offsets.",null,null],[3,"Bytes","","External iterator for a string's bytes. Use with the `std::iter` module.",null,null],[3,"Split","","Created with the method [`split()`].",null,null],[3,"RSplit","","Created with the method [`rsplit()`].",null,null],[3,"SplitTerminator","","Created with the method [`split_terminator()`].",null,null],[3,"RSplitTerminator","","Created with the method [`rsplit_terminator()`].",null,null],[3,"SplitN","","Created with the method [`splitn()`].",null,null],[3,"RSplitN","","Created with the method [`rsplitn()`].",null,null],[3,"MatchIndices","","Created with the method [`match_indices()`].",null,null],[3,"RMatchIndices","","Created with the method [`rmatch_indices()`].",null,null],[3,"Matches","","Created with the method [`matches()`].",null,null],[3,"RMatches","","Created with the method [`rmatches()`].",null,null],[3,"Lines","","Created with the method [`lines()`].",null,null],[3,"LinesAny","","Created with the method [`lines_any()`].",null,null],[5,"from_utf8","","Converts a slice of bytes to a string slice.",null,null],[5,"from_utf8_unchecked","","Converts a slice of bytes to a string slice without checking that the string contains valid UTF-8.",null,null],[5,"next_code_point","","Reads the next code point out of a byte iterator (assuming a UTF-8-like encoding).",null,{"inputs":[{"name":"i"}],"output":{"name":"option"}}],[5,"utf8_char_width","","Given a first byte, determine how many bytes are in this UTF-8 character",null,{"inputs":[{"name":"u8"}],"output":{"name":"usize"}}],[0,"pattern","","The string Pattern API.",null,null],[3,"CharSearcher","core::str::pattern","Associated type for `<char as Pattern<'a>>::Searcher`.",null,null],[3,"CharSliceSearcher","","Associated type for `<&[char] as Pattern<'a>>::Searcher`.",null,null],[3,"CharPredicateSearcher","","Associated type for `<F as Pattern<'a>>::Searcher`.",null,null],[3,"StrSearcher","","Associated type for `<&str as Pattern<'a>>::Searcher`.",null,null],[4,"SearchStep","","Result of calling `Searcher::next()` or `ReverseSearcher::next_back()`.",null,null],[13,"Match","","Expresses that a match of the pattern has been found at `haystack[a..b]`.",151,null],[13,"Reject","","Expresses that `haystack[a..b]` has been rejected as a possible match of the pattern.",151,null],[13,"Done","","Expresses that every byte of the haystack has been visted, ending the iteration.",151,null],[8,"Pattern","","A string pattern.",null,null],[16,"Searcher","","Associated searcher for this pattern",152,null],[10,"into_searcher","","Constructs the associated searcher from `self` and the `haystack` to search in.",152,null],[11,"is_contained_in","","Checks whether the pattern matches anywhere in the haystack",152,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"is_prefix_of","","Checks whether the pattern matches at the front of the haystack",152,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"is_suffix_of","","Checks whether the pattern matches at the back of the haystack",152,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[8,"Searcher","","A searcher for a string pattern.",null,null],[10,"haystack","","Getter for the underlaying string to be searched in",153,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[10,"next","","Performs the next search step starting from the front.",153,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match","","Find the next `Match` result. See `next()`",153,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject","","Find the next `Reject` result. See `next()`",153,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[8,"ReverseSearcher","","A reverse searcher for a string pattern.",null,null],[10,"next_back","","Performs the next search step starting from the back.",154,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match_back","","Find the next `Match` result. See `next_back()`",154,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject_back","","Find the next `Reject` result. See `next_back()`",154,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[8,"DoubleEndedSearcher","","A marker trait to express that a `ReverseSearcher` can be used for a `DoubleEndedIterator` implementation.",null,null],[11,"clone","","",151,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"eq","","",151,{"inputs":[{"name":"self"},{"name":"searchstep"}],"output":{"name":"bool"}}],[11,"ne","","",151,{"inputs":[{"name":"self"},{"name":"searchstep"}],"output":{"name":"bool"}}],[11,"fmt","","",151,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",155,{"inputs":[{"name":"self"}],"output":{"name":"charsearcher"}}],[11,"fmt","","",155,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"haystack","","",155,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"next","","",155,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match","","",155,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject","","",155,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",155,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match_back","","",155,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject_back","","",155,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",156,{"inputs":[{"name":"self"}],"output":{"name":"charslicesearcher"}}],[11,"fmt","","",156,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"haystack","","",156,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"next","","",156,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match","","",156,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject","","",156,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",156,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match_back","","",156,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject_back","","",156,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",157,{"inputs":[{"name":"self"}],"output":{"name":"charpredicatesearcher"}}],[11,"fmt","","",157,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"haystack","","",157,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"next","","",157,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match","","",157,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject","","",157,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",157,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match_back","","",157,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject_back","","",157,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",158,{"inputs":[{"name":"self"}],"output":{"name":"strsearcher"}}],[11,"fmt","","",158,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"haystack","","",158,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"next","","",158,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match","","",158,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",158,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match_back","","",158,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[8,"FromStr","core::str","A trait to abstract the idea of creating a new instance of a type from a string.",null,null],[16,"Err","","The associated error which can be returned from parsing.",159,null],[10,"from_str","","Parses a string `s` to return a value of this type.",159,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"fmt","","",160,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",160,{"inputs":[{"name":"self"}],"output":{"name":"parseboolerror"}}],[11,"eq","","",160,{"inputs":[{"name":"self"},{"name":"parseboolerror"}],"output":{"name":"bool"}}],[11,"ne","","",160,{"inputs":[{"name":"self"},{"name":"parseboolerror"}],"output":{"name":"bool"}}],[11,"fmt","","",160,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",161,{"inputs":[{"name":"self"},{"name":"utf8error"}],"output":{"name":"bool"}}],[11,"ne","","",161,{"inputs":[{"name":"self"},{"name":"utf8error"}],"output":{"name":"bool"}}],[11,"clone","","",161,{"inputs":[{"name":"self"}],"output":{"name":"utf8error"}}],[11,"fmt","","",161,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"valid_up_to","","Returns the index in the given string up to which valid UTF-8 was verified.",161,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"fmt","","",161,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",162,{"inputs":[{"name":"self"}],"output":{"name":"chars"}}],[11,"fmt","","",162,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",162,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"count","","",162,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"size_hint","","",162,null],[11,"last","","",162,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",162,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"as_str","","View the underlying data as a subslice of the original data.",162,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"clone","","",163,{"inputs":[{"name":"self"}],"output":{"name":"charindices"}}],[11,"fmt","","",163,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",163,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"count","","",163,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"size_hint","","",163,null],[11,"last","","",163,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",163,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"as_str","","View the underlying data as a subslice of the original data.",163,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"clone","","",164,{"inputs":[{"name":"self"}],"output":{"name":"bytes"}}],[11,"fmt","","",164,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",164,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",164,null],[11,"count","","",164,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"last","","",164,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"nth","","",164,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"next_back","","",164,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"len","","",164,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","",164,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"fmt","","",165,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",165,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",165,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"fmt","","",166,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",166,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",166,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"next_back","","",165,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",166,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",167,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",167,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",167,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"fmt","","",168,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",168,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",168,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"next_back","","",167,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",168,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",169,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",169,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",169,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"fmt","","",170,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",170,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",170,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"fmt","","",171,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",171,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",171,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"fmt","","",172,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",172,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",172,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"next_back","","",171,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",172,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",173,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",173,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",173,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"fmt","","",174,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",174,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",174,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"next_back","","",173,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",174,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",175,{"inputs":[{"name":"self"}],"output":{"name":"lines"}}],[11,"fmt","","",175,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",175,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",175,null],[11,"next_back","","",175,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",176,{"inputs":[{"name":"self"}],"output":{"name":"linesany"}}],[11,"fmt","","",176,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",176,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",176,null],[11,"next_back","","",176,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[0,"hash","core","Generic hashing support.",null,null],[3,"SipHasher","core::hash","An implementation of SipHash 2-4.",null,null],[3,"SipHasher13","","An implementation of SipHash 1-3.",null,null],[3,"SipHasher24","","An implementation of SipHash 2-4.",null,null],[3,"BuildHasherDefault","","The `BuildHasherDefault` structure is used in scenarios where one has a type that implements [`Hasher`] and [`Default`], but needs that type to implement [`BuildHasher`].",null,null],[11,"fmt","","",177,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",177,{"inputs":[{"name":"self"}],"output":{"name":"siphasher13"}}],[11,"default","","",177,{"inputs":[],"output":{"name":"siphasher13"}}],[11,"fmt","","",178,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",178,{"inputs":[{"name":"self"}],"output":{"name":"siphasher24"}}],[11,"default","","",178,{"inputs":[],"output":{"name":"siphasher24"}}],[11,"fmt","","",179,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",179,{"inputs":[{"name":"self"}],"output":{"name":"siphasher"}}],[11,"default","","",179,{"inputs":[],"output":{"name":"siphasher"}}],[11,"new","","Creates a new `SipHasher` with the two initial keys set to 0.",179,{"inputs":[],"output":{"name":"siphasher"}}],[11,"new_with_keys","","Creates a `SipHasher` that is keyed off the provided keys.",179,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"siphasher"}}],[11,"new","","Creates a new `SipHasher13` with the two initial keys set to 0.",177,{"inputs":[],"output":{"name":"siphasher13"}}],[11,"new_with_keys","","Creates a `SipHasher13` that is keyed off the provided keys.",177,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"siphasher13"}}],[11,"new","","Creates a new `SipHasher24` with the two initial keys set to 0.",178,{"inputs":[],"output":{"name":"siphasher24"}}],[11,"new_with_keys","","Creates a `SipHasher24` that is keyed off the provided keys.",178,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"siphasher24"}}],[11,"write","","",179,null],[11,"finish","","",179,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"write","","",177,null],[11,"finish","","",177,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"write","","",178,null],[11,"finish","","",178,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[8,"Hash","","A hashable type.",null,null],[10,"hash","","Feeds this value into the state given, updating the hasher as necessary.",180,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"hash_slice","","Feeds a slice of this type into the state provided.",180,null],[8,"Hasher","","A trait which represents the ability to hash an arbitrary stream of bytes.",null,null],[10,"finish","","Completes a round of hashing, producing the output hash generated.",181,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[10,"write","","Writes some data into this `Hasher`.",181,null],[11,"write_u8","","Write a single `u8` into this hasher.",181,{"inputs":[{"name":"self"},{"name":"u8"}],"output":null}],[11,"write_u16","","Writes a single `u16` into this hasher.",181,{"inputs":[{"name":"self"},{"name":"u16"}],"output":null}],[11,"write_u32","","Writes a single `u32` into this hasher.",181,{"inputs":[{"name":"self"},{"name":"u32"}],"output":null}],[11,"write_u64","","Writes a single `u64` into this hasher.",181,{"inputs":[{"name":"self"},{"name":"u64"}],"output":null}],[11,"write_u128","","Writes a single `u128` into this hasher.",181,{"inputs":[{"name":"self"},{"name":"u128"}],"output":null}],[11,"write_usize","","Writes a single `usize` into this hasher.",181,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"write_i8","","Writes a single `i8` into this hasher.",181,{"inputs":[{"name":"self"},{"name":"i8"}],"output":null}],[11,"write_i16","","Writes a single `i16` into this hasher.",181,{"inputs":[{"name":"self"},{"name":"i16"}],"output":null}],[11,"write_i32","","Writes a single `i32` into this hasher.",181,{"inputs":[{"name":"self"},{"name":"i32"}],"output":null}],[11,"write_i64","","Writes a single `i64` into this hasher.",181,{"inputs":[{"name":"self"},{"name":"i64"}],"output":null}],[11,"write_i128","","Writes a single `i128` into this hasher.",181,{"inputs":[{"name":"self"},{"name":"i128"}],"output":null}],[11,"write_isize","","Writes a single `isize` into this hasher.",181,{"inputs":[{"name":"self"},{"name":"isize"}],"output":null}],[8,"BuildHasher","","A `BuildHasher` is typically used as a factory for instances of `Hasher` which a `HashMap` can then use to hash keys independently.",null,null],[16,"Hasher","","Type of the hasher that will be created.",182,null],[10,"build_hasher","","Creates a new hasher.",182,null],[11,"fmt","","",183,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"build_hasher","","",183,{"inputs":[{"name":"self"}],"output":{"name":"h"}}],[11,"clone","","",183,{"inputs":[{"name":"self"}],"output":{"name":"buildhasherdefault"}}],[11,"default","","",183,{"inputs":[],"output":{"name":"buildhasherdefault"}}],[0,"fmt","core","Utilities for formatting and printing strings.",null,null],[3,"DebugStruct","core::fmt","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugTuple","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugSet","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugList","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugMap","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"Error","","The error type which is returned from formatting a message into a stream.",null,null],[3,"Formatter","","A struct to represent both where to emit formatting strings to and how they should be formatted. A mutable version of this is passed to all formatting traits.",null,null],[3,"Arguments","","This structure represents a safely precompiled version of a format string and its arguments. This cannot be generated at runtime because it cannot safely be done, so no constructors are given and the fields are private to prevent modification.",null,null],[4,"Alignment","","Possible alignments returned by `Formatter::align`",null,null],[13,"Left","","Indication that contents should be left-aligned.",184,null],[13,"Right","","Indication that contents should be right-aligned.",184,null],[13,"Center","","Indication that contents should be center-aligned.",184,null],[13,"Unknown","","No alignment was requested.",184,null],[5,"write","","The `write` function takes an output stream, a precompiled format string, and a list of arguments. The arguments will be formatted according to the specified format string into the output stream provided.",null,{"inputs":[{"name":"write"},{"name":"arguments"}],"output":{"name":"result"}}],[11,"field","","Adds a new field to the generated struct output.",185,{"inputs":[{"name":"self"},{"name":"str"},{"name":"debug"}],"output":{"name":"debugstruct"}}],[11,"finish","","Finishes output and returns any error encountered.",185,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"field","","Adds a new field to the generated tuple struct output.",186,{"inputs":[{"name":"self"},{"name":"debug"}],"output":{"name":"debugtuple"}}],[11,"finish","","Finishes output and returns any error encountered.",186,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"entry","","Adds a new entry to the set output.",187,{"inputs":[{"name":"self"},{"name":"debug"}],"output":{"name":"debugset"}}],[11,"entries","","Adds the contents of an iterator of entries to the set output.",187,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"debugset"}}],[11,"finish","","Finishes output and returns any error encountered.",187,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"entry","","Adds a new entry to the list output.",188,{"inputs":[{"name":"self"},{"name":"debug"}],"output":{"name":"debuglist"}}],[11,"entries","","Adds the contents of an iterator of entries to the list output.",188,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"debuglist"}}],[11,"finish","","Finishes output and returns any error encountered.",188,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"entry","","Adds a new entry to the map output.",189,{"inputs":[{"name":"self"},{"name":"debug"},{"name":"debug"}],"output":{"name":"debugmap"}}],[11,"entries","","Adds the contents of an iterator of entries to the map output.",189,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"debugmap"}}],[11,"finish","","Finishes output and returns any error encountered.",189,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[6,"Result","","The type returned by formatter methods.",null,null],[8,"Write","","A collection of methods that are required to format a message into a stream.",null,null],[10,"write_str","","Writes a slice of bytes into this writer, returning whether the write succeeded.",190,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"result"}}],[11,"write_char","","Writes a [`char`] into this writer, returning whether the write succeeded.",190,{"inputs":[{"name":"self"},{"name":"char"}],"output":{"name":"result"}}],[11,"write_fmt","","Glue for usage of the [`write!`] macro with implementors of this trait.",190,{"inputs":[{"name":"self"},{"name":"arguments"}],"output":{"name":"result"}}],[8,"Debug","","Format trait for the `?` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",191,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"Display","","Format trait for an empty format, `{}`.",null,null],[10,"fmt","","Formats the value using the given formatter.",192,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"Octal","","Format trait for the `o` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",193,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"Binary","","Format trait for the `b` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",194,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"LowerHex","","Format trait for the `x` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",195,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"UpperHex","","Format trait for the `X` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",196,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"Pointer","","Format trait for the `p` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",197,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"LowerExp","","Format trait for the `e` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",198,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"UpperExp","","Format trait for the `E` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",199,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",184,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",200,{"inputs":[{"name":"self"}],"output":{"name":"error"}}],[11,"fmt","","",200,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"default","","",200,{"inputs":[],"output":{"name":"error"}}],[11,"hash","","",200,null],[11,"cmp","","",200,{"inputs":[{"name":"self"},{"name":"error"}],"output":{"name":"ordering"}}],[11,"eq","","",200,{"inputs":[{"name":"self"},{"name":"error"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",200,{"inputs":[{"name":"self"},{"name":"error"}],"output":{"name":"option"}}],[11,"clone","","",201,{"inputs":[{"name":"self"}],"output":{"name":"arguments"}}],[11,"fmt","","",201,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",201,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"pad_integral","","Performs the correct padding for an integer which has already been emitted into a str. The str should *not* contain the sign for the integer, that will be added by this method.",202,{"inputs":[{"name":"self"},{"name":"bool"},{"name":"str"},{"name":"str"}],"output":{"name":"result"}}],[11,"pad","","This function takes a string slice and emits it to the internal buffer after applying the relevant formatting flags specified. The flags recognized for generic strings are:",202,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"result"}}],[11,"write_str","","Writes some data to the underlying buffer contained within this formatter.",202,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"result"}}],[11,"write_fmt","","Writes some formatted information into this instance",202,{"inputs":[{"name":"self"},{"name":"arguments"}],"output":{"name":"result"}}],[11,"flags","","Flags for formatting (packed version of rt::Flag)",202,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"fill","","Character used as 'fill' whenever there is alignment",202,{"inputs":[{"name":"self"}],"output":{"name":"char"}}],[11,"align","","Flag indicating what form of alignment was requested",202,{"inputs":[{"name":"self"}],"output":{"name":"alignment"}}],[11,"width","","Optionally specified integer width that the output should be",202,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"precision","","Optionally specified precision for numeric types",202,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"sign_plus","","Determines if the `+` flag was specified.",202,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"sign_minus","","Determines if the `-` flag was specified.",202,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"alternate","","Determines if the `#` flag was specified.",202,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"sign_aware_zero_pad","","Determines if the `0` flag was specified.",202,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"debug_struct","","Creates a `DebugStruct` builder designed to assist with creation of `fmt::Debug` implementations for structs.",202,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"debugstruct"}}],[11,"debug_tuple","","Creates a `DebugTuple` builder designed to assist with creation of `fmt::Debug` implementations for tuple structs.",202,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"debugtuple"}}],[11,"debug_list","","Creates a `DebugList` builder designed to assist with creation of `fmt::Debug` implementations for list-like structures.",202,{"inputs":[{"name":"self"}],"output":{"name":"debuglist"}}],[11,"debug_set","","Creates a `DebugSet` builder designed to assist with creation of `fmt::Debug` implementations for set-like structures.",202,{"inputs":[{"name":"self"}],"output":{"name":"debugset"}}],[11,"debug_map","","Creates a `DebugMap` builder designed to assist with creation of `fmt::Debug` implementations for map-like structures.",202,{"inputs":[{"name":"self"}],"output":{"name":"debugmap"}}],[11,"write_str","","",202,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"result"}}],[11,"write_char","","",202,{"inputs":[{"name":"self"},{"name":"char"}],"output":{"name":"result"}}],[11,"write_fmt","","",202,{"inputs":[{"name":"self"},{"name":"arguments"}],"output":{"name":"result"}}],[11,"fmt","","",200,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","core::marker","",11,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","core::cell","",85,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",88,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",89,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",90,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",91,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[14,"panic","core","Entry point of thread panic, for details, see std::macros",null,null],[14,"assert","","Ensure that a boolean expression is `true` at runtime.",null,null],[14,"assert_eq","","Asserts that two expressions are equal to each other.",null,null],[14,"assert_ne","","Asserts that two expressions are not equal to each other.",null,null],[14,"debug_assert","","Ensure that a boolean expression is `true` at runtime.",null,null],[14,"debug_assert_eq","","Asserts that two expressions are equal to each other.",null,null],[14,"debug_assert_ne","","Asserts that two expressions are not equal to each other.",null,null],[14,"try","","Helper macro for reducing boilerplate code for matching `Result` together with converting downstream errors.",null,null],[14,"write","","Write formatted data into a buffer",null,null],[14,"writeln","","Write formatted data into a buffer, with a newline appended.",null,null],[14,"unreachable","","A utility macro for indicating unreachable code.",null,null],[14,"unimplemented","","A standardized placeholder for marking unfinished code. It panics with the message `\"not yet implemented\"` when executed.",null,null],[14,"format_args","","The core macro for formatted string creation & output.",null,null],[14,"env","","Inspect an environment variable at compile time.",null,null],[14,"option_env","","Optionally inspect an environment variable at compile time.",null,null],[14,"concat_idents","","Concatenate identifiers into one identifier.",null,null],[14,"concat","","Concatenates literals into a static string slice.",null,null],[14,"line","","A macro which expands to the line number on which it was invoked.",null,null],[14,"column","","A macro which expands to the column number on which it was invoked.",null,null],[14,"file","","A macro which expands to the file name from which it was invoked.",null,null],[14,"stringify","","A macro which stringifies its argument.",null,null],[14,"include_str","","Includes a utf8-encoded file as a string.",null,null],[14,"include_bytes","","Includes a file as a reference to a byte array.",null,null],[14,"module_path","","Expands to a string that represents the current module path.",null,null],[14,"cfg","","Boolean evaluation of configuration flags.",null,null],[14,"include","","Parse a file as an expression or an item according to the context.",null,null],[11,"from_success","core::result","",134,{"inputs":[{"name":"u"}],"output":{"name":"result"}}],[11,"from_error","","",134,{"inputs":[{"name":"v"}],"output":{"name":"result"}}],[11,"translate","","",134,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"size_hint","core::iter","Returns the bounds on the remaining length of the iterator.",102,null],[11,"count","","Consumes the iterator, counting the number of iterations and returning it.",102,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"last","","Consumes the iterator, returning the last element.",102,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"nth","","Returns the `n`th element of the iterator.",102,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"chain","","Takes two iterators and creates a new iterator over both in sequence.",102,{"inputs":[{"name":"self"},{"name":"u"}],"output":{"name":"chain"}}],[11,"zip","","'Zips up' two iterators into a single iterator of pairs.",102,{"inputs":[{"name":"self"},{"name":"u"}],"output":{"name":"zip"}}],[11,"map","","Takes a closure and creates an iterator which calls that closure on each element.",102,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"map"}}],[11,"filter","","Creates an iterator which uses a closure to determine if an element should be yielded.",102,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"filter"}}],[11,"filter_map","","Creates an iterator that both filters and maps.",102,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"filtermap"}}],[11,"enumerate","","Creates an iterator which gives the current iteration count as well as the next value.",102,{"inputs":[{"name":"self"}],"output":{"name":"enumerate"}}],[11,"peekable","","Creates an iterator which can use `peek` to look at the next element of the iterator without consuming it.",102,{"inputs":[{"name":"self"}],"output":{"name":"peekable"}}],[11,"skip_while","","Creates an iterator that [`skip()`]s elements based on a predicate.",102,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"skipwhile"}}],[11,"take_while","","Creates an iterator that yields elements based on a predicate.",102,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"takewhile"}}],[11,"skip","","Creates an iterator that skips the first `n` elements.",102,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"skip"}}],[11,"take","","Creates an iterator that yields its first `n` elements.",102,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"take"}}],[11,"scan","","An iterator adaptor similar to [`fold()`] that holds internal state and produces a new iterator.",102,{"inputs":[{"name":"self"},{"name":"st"},{"name":"f"}],"output":{"name":"scan"}}],[11,"flat_map","","Creates an iterator that works like map, but flattens nested structure.",102,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"flatmap"}}],[11,"fuse","","Creates an iterator which ends after the first [`None`].",102,{"inputs":[{"name":"self"}],"output":{"name":"fuse"}}],[11,"inspect","","Do something with each element of an iterator, passing the value on.",102,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"inspect"}}],[11,"by_ref","","Borrows an iterator, rather than consuming it.",102,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"collect","","Transforms an iterator into a collection.",102,{"inputs":[{"name":"self"}],"output":{"name":"b"}}],[11,"partition","","Consumes an iterator, creating two collections from it.",102,null],[11,"fold","","An iterator adaptor that applies a function, producing a single, final value.",102,{"inputs":[{"name":"self"},{"name":"b"},{"name":"f"}],"output":{"name":"b"}}],[11,"all","","Tests if every element of the iterator matches a predicate.",102,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"any","","Tests if any element of the iterator matches a predicate.",102,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"find","","Searches for an element of an iterator that satisfies a predicate.",102,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"option"}}],[11,"position","","Searches for an element in an iterator, returning its index.",102,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"option"}}],[11,"rposition","","Searches for an element in an iterator from the right, returning its index.",102,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"option"}}],[11,"max","","Returns the maximum element of an iterator.",102,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"min","","Returns the minimum element of an iterator.",102,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"max_by_key","","Returns the element that gives the maximum value from the specified function.",102,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"max_by","","Returns the element that gives the maximum value with respect to the specified comparison function.",102,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"min_by_key","","Returns the element that gives the minimum value from the specified function.",102,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"min_by","","Returns the element that gives the minimum value with respect to the specified comparison function.",102,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"rev","","Reverses an iterator's direction.",102,{"inputs":[{"name":"self"}],"output":{"name":"rev"}}],[11,"unzip","","Converts an iterator of pairs into a pair of containers.",102,null],[11,"cloned","","Creates an iterator which [`clone()`]s all of its elements.",102,{"inputs":[{"name":"self"}],"output":{"name":"cloned"}}],[11,"cycle","","Repeats an iterator endlessly.",102,{"inputs":[{"name":"self"}],"output":{"name":"cycle"}}],[11,"sum","","Sums the elements of an iterator.",102,{"inputs":[{"name":"self"}],"output":{"name":"s"}}],[11,"product","","Iterates over the entire iterator, multiplying all the elements",102,{"inputs":[{"name":"self"}],"output":{"name":"p"}}],[11,"cmp","","Lexicographically compares the elements of this `Iterator` with those of another.",102,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","Lexicographically compares the elements of this `Iterator` with those of another.",102,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"option"}}],[11,"eq","","Determines if the elements of this `Iterator` are equal to those of another.",102,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"bool"}}],[11,"ne","","Determines if the elements of this `Iterator` are unequal to those of another.",102,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"bool"}}],[11,"lt","","Determines if the elements of this `Iterator` are lexicographically less than those of another.",102,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"bool"}}],[11,"le","","Determines if the elements of this `Iterator` are lexicographically less or equal to those of another.",102,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"bool"}}],[11,"gt","","Determines if the elements of this `Iterator` are lexicographically greater than those of another.",102,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"bool"}}],[11,"ge","","Determines if the elements of this `Iterator` are lexicographically greater than or equal to those of another.",102,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"bool"}}],[11,"rfind","","Searches for an element of an iterator from the right that satisfies a predicate.",106,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"option"}}],[11,"len","","Returns the exact number of times the iterator will iterate.",108,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","Returns whether the iterator is empty.",108,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"sum","core::result","",134,{"inputs":[{"name":"i"}],"output":{"name":"result"}}],[11,"product","","",134,{"inputs":[{"name":"i"}],"output":{"name":"result"}}]],"paths":[[3,"Wrapping"],[4,"FpCategory"],[3,"ParseFloatError"],[8,"Zero"],[8,"One"],[3,"TryFromIntError"],[3,"ParseIntError"],[3,"Discriminant"],[3,"NonZero"],[3,"Unique"],[3,"Shared"],[3,"PhantomData"],[3,"Range"],[3,"RangeFrom"],[3,"RangeTo"],[3,"RangeToInclusive"],[4,"RangeInclusive"],[8,"Drop"],[8,"Add"],[8,"Sub"],[8,"Mul"],[8,"Div"],[8,"Rem"],[8,"Neg"],[8,"Not"],[8,"BitAnd"],[8,"BitOr"],[8,"BitXor"],[8,"Shl"],[8,"Shr"],[8,"AddAssign"],[8,"SubAssign"],[8,"MulAssign"],[8,"DivAssign"],[8,"RemAssign"],[8,"BitAndAssign"],[8,"BitOrAssign"],[8,"BitXorAssign"],[8,"ShlAssign"],[8,"ShrAssign"],[8,"Index"],[8,"IndexMut"],[8,"Deref"],[8,"DerefMut"],[8,"Fn"],[8,"FnMut"],[8,"FnOnce"],[8,"Place"],[8,"Placer"],[8,"InPlace"],[8,"Boxed"],[8,"BoxPlace"],[8,"Carrier"],[3,"RangeFull"],[4,"Ordering"],[8,"PartialEq"],[8,"Ord"],[8,"PartialOrd"],[8,"Clone"],[8,"Default"],[8,"AsRef"],[8,"AsMut"],[8,"Into"],[8,"From"],[8,"TryInto"],[8,"TryFrom"],[8,"Borrow"],[8,"BorrowMut"],[8,"Any"],[3,"TypeId"],[8,"FixedSizeArray"],[4,"Ordering"],[3,"AtomicBool"],[3,"AtomicPtr"],[3,"AtomicI8"],[3,"AtomicU8"],[3,"AtomicI16"],[3,"AtomicU16"],[3,"AtomicI32"],[3,"AtomicU32"],[3,"AtomicI64"],[3,"AtomicU64"],[3,"AtomicIsize"],[3,"AtomicUsize"],[4,"BorrowState"],[3,"Cell"],[3,"BorrowError"],[3,"BorrowMutError"],[3,"RefCell"],[3,"Ref"],[3,"RefMut"],[3,"UnsafeCell"],[3,"CharTryFromError"],[3,"EscapeUnicode"],[3,"EscapeDefault"],[3,"EscapeDebug"],[3,"DecodeUtf8"],[3,"InvalidSequence"],[3,"StepBy"],[3,"Repeat"],[3,"Empty"],[3,"Once"],[8,"Iterator"],[8,"Step"],[8,"FromIterator"],[8,"IntoIterator"],[8,"DoubleEndedIterator"],[8,"Extend"],[8,"ExactSizeIterator"],[8,"Sum"],[8,"Product"],[3,"Rev"],[3,"Cloned"],[3,"Cycle"],[3,"Chain"],[3,"Zip"],[3,"Map"],[3,"Filter"],[3,"FilterMap"],[3,"Enumerate"],[3,"Peekable"],[3,"SkipWhile"],[3,"TakeWhile"],[3,"Skip"],[3,"Take"],[3,"Scan"],[3,"FlatMap"],[3,"Fuse"],[3,"Inspect"],[4,"Option"],[3,"Iter"],[3,"IterMut"],[3,"IntoIter"],[3,"TraitObject"],[4,"Result"],[3,"Iter"],[3,"IterMut"],[3,"IntoIter"],[8,"SliceExt"],[8,"SliceIndex"],[3,"Iter"],[3,"IterMut"],[3,"Split"],[3,"SplitMut"],[3,"SplitN"],[3,"RSplitN"],[3,"SplitNMut"],[3,"RSplitNMut"],[3,"Windows"],[3,"Chunks"],[3,"ChunksMut"],[4,"SearchStep"],[8,"Pattern"],[8,"Searcher"],[8,"ReverseSearcher"],[3,"CharSearcher"],[3,"CharSliceSearcher"],[3,"CharPredicateSearcher"],[3,"StrSearcher"],[8,"FromStr"],[3,"ParseBoolError"],[3,"Utf8Error"],[3,"Chars"],[3,"CharIndices"],[3,"Bytes"],[3,"Split"],[3,"RSplit"],[3,"SplitTerminator"],[3,"RSplitTerminator"],[3,"SplitN"],[3,"RSplitN"],[3,"MatchIndices"],[3,"RMatchIndices"],[3,"Matches"],[3,"RMatches"],[3,"Lines"],[3,"LinesAny"],[3,"SipHasher13"],[3,"SipHasher24"],[3,"SipHasher"],[8,"Hash"],[8,"Hasher"],[8,"BuildHasher"],[3,"BuildHasherDefault"],[4,"Alignment"],[3,"DebugStruct"],[3,"DebugTuple"],[3,"DebugSet"],[3,"DebugList"],[3,"DebugMap"],[8,"Write"],[8,"Debug"],[8,"Display"],[8,"Octal"],[8,"Binary"],[8,"LowerHex"],[8,"UpperHex"],[8,"Pointer"],[8,"LowerExp"],[8,"UpperExp"],[3,"Error"],[3,"Arguments"],[3,"Formatter"]]};
searchIndex["proc_macro"] = {"doc":"A support library for macro authors when defining new macros.","items":[[3,"TokenStream","proc_macro","The main type provided by this crate, representing an abstract stream of tokens.",null,null],[3,"LexError","","Error returned from `TokenStream::from_str`.",null,null],[11,"fmt","","",0,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"from_str","","",1,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"fmt","","",1,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}]],"paths":[[3,"LexError"],[3,"TokenStream"]]};
searchIndex["std"] = {"doc":"The Rust Standard Library","items":[[0,"any","std","This module implements the `Any` trait, which enables dynamic typing of any `'static` type through runtime reflection.",null,null],[8,"Any","std::any","A type to emulate dynamic typing.",null,null],[10,"get_type_id","","Gets the `TypeId` of `self`.",0,{"inputs":[{"name":"self"}],"output":{"name":"typeid"}}],[3,"TypeId","","A `TypeId` represents a globally unique identifier for a type.",null,null],[0,"cell","std","Shareable mutable containers.",null,null],[3,"Cell","std::cell","A mutable memory location.",null,null],[3,"RefCell","","A mutable memory location with dynamically checked borrow rules",null,null],[4,"BorrowState","","An enumeration of values returned from the `state` method on a `RefCell<T>`.",null,null],[13,"Reading","","The cell is currently being read, there is at least one active `borrow`.",1,null],[13,"Writing","","The cell is currently being written to, there is an active `borrow_mut`.",1,null],[13,"Unused","","There are no outstanding borrows on this cell.",1,null],[3,"BorrowError","","An error returned by `RefCell::try_borrow`.",null,null],[3,"BorrowMutError","","An error returned by `RefCell::try_borrow_mut`.",null,null],[3,"Ref","","Wraps a borrowed reference to a value in a `RefCell` box. A wrapper type for an immutably borrowed value from a `RefCell<T>`.",null,null],[3,"RefMut","","A wrapper type for a mutably borrowed value from a `RefCell<T>`.",null,null],[3,"UnsafeCell","","The core primitive for interior mutability in Rust.",null,null],[0,"clone","std","The `Clone` trait for types that cannot be 'implicitly copied'.",null,null],[8,"Clone","std::clone","A common trait for the ability to explicitly duplicate an object.",null,null],[10,"clone","","Returns a copy of the value.",2,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"clone_from","","Performs copy-assignment from `source`.",2,null],[0,"cmp","std","Functionality for ordering and comparison.",null,null],[8,"PartialEq","std::cmp","Trait for equality comparisons which are partial equivalence relations.",null,null],[10,"eq","","This method tests for `self` and `other` values to be equal, and is used by `==`.",3,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":{"name":"bool"}}],[11,"ne","","This method tests for `!=`.",3,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":{"name":"bool"}}],[8,"Eq","","Trait for equality comparisons which are equivalence relations.",null,null],[4,"Ordering","","An `Ordering` is the result of a comparison between two values.",null,null],[13,"Less","","An ordering where a compared value is less [than another].",4,null],[13,"Equal","","An ordering where a compared value is equal [to another].",4,null],[13,"Greater","","An ordering where a compared value is greater [than another].",4,null],[8,"Ord","","Trait for types that form a total order.",null,null],[10,"cmp","","This method returns an `Ordering` between `self` and `other`.",5,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"ordering"}}],[8,"PartialOrd","","Trait for values that can be compared for a sort-order.",null,null],[10,"partial_cmp","","This method returns an ordering between `self` and `other` values if one exists.",6,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":{"name":"option"}}],[11,"lt","","This method tests less than (for `self` and `other`) and is used by the `<` operator.",6,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":{"name":"bool"}}],[11,"le","","This method tests less than or equal to (for `self` and `other`) and is used by the `<=` operator.",6,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":{"name":"bool"}}],[11,"gt","","This method tests greater than (for `self` and `other`) and is used by the `>` operator.",6,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":{"name":"bool"}}],[11,"ge","","This method tests greater than or equal to (for `self` and `other`) and is used by the `>=` operator.",6,{"inputs":[{"name":"self"},{"name":"rhs"}],"output":{"name":"bool"}}],[5,"min","","Compare and return the minimum of two values.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"max","","Compare and return the maximum of two values.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[0,"convert","std","Traits for conversions between types.",null,null],[8,"AsRef","std::convert","A cheap, reference-to-reference conversion.",null,null],[10,"as_ref","","Performs the conversion.",7,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[8,"AsMut","","A cheap, mutable reference-to-mutable reference conversion.",null,null],[10,"as_mut","","Performs the conversion.",8,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[8,"Into","","A conversion that consumes `self`, which may or may not be expensive.",null,null],[10,"into","","Performs the conversion.",9,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[8,"From","","Construct `Self` via a conversion.",null,null],[10,"from","","Performs the conversion.",10,{"inputs":[{"name":"t"}],"output":{"name":"self"}}],[8,"TryInto","","An attempted conversion that consumes `self`, which may or may not be expensive.",null,null],[16,"Err","","The type returned in the event of a conversion error.",11,null],[10,"try_into","","Performs the conversion.",11,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[8,"TryFrom","","Attempt to construct `Self` via a conversion.",null,null],[16,"Err","","The type returned in the event of a conversion error.",12,null],[10,"try_from","","Performs the conversion.",12,{"inputs":[{"name":"t"}],"output":{"name":"result"}}],[0,"default","std","The `Default` trait for types which may have meaningful default values.",null,null],[8,"Default","std::default","A trait for giving a type a useful default value.",null,null],[10,"default","","Returns the \"default value\" for a type.",13,{"inputs":[],"output":{"name":"self"}}],[0,"hash","std","Generic hashing support.",null,null],[8,"Hash","std::hash","A hashable type.",null,null],[10,"hash","","Feeds this value into the state given, updating the hasher as necessary.",14,null],[11,"hash_slice","","Feeds a slice of this type into the state provided.",14,null],[8,"Hasher","","A trait which represents the ability to hash an arbitrary stream of bytes.",null,null],[10,"finish","","Completes a round of hashing, producing the output hash generated.",15,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[10,"write","","Writes some data into this `Hasher`.",15,null],[11,"write_u8","","Write a single `u8` into this hasher.",15,null],[11,"write_u16","","Writes a single `u16` into this hasher.",15,null],[11,"write_u32","","Writes a single `u32` into this hasher.",15,null],[11,"write_u64","","Writes a single `u64` into this hasher.",15,null],[11,"write_u128","","Writes a single `u128` into this hasher.",15,null],[11,"write_usize","","Writes a single `usize` into this hasher.",15,null],[11,"write_i8","","Writes a single `i8` into this hasher.",15,null],[11,"write_i16","","Writes a single `i16` into this hasher.",15,null],[11,"write_i32","","Writes a single `i32` into this hasher.",15,null],[11,"write_i64","","Writes a single `i64` into this hasher.",15,null],[11,"write_i128","","Writes a single `i128` into this hasher.",15,null],[11,"write_isize","","Writes a single `isize` into this hasher.",15,null],[8,"BuildHasher","","A `BuildHasher` is typically used as a factory for instances of `Hasher` which a `HashMap` can then use to hash keys independently.",null,null],[16,"Hasher","","Type of the hasher that will be created.",16,null],[10,"build_hasher","","Creates a new hasher.",16,null],[3,"BuildHasherDefault","","The `BuildHasherDefault` structure is used in scenarios where one has a type that implements [`Hasher`] and [`Default`], but needs that type to implement [`BuildHasher`].",null,null],[3,"SipHasher13","","An implementation of SipHash 1-3.",null,null],[3,"SipHasher","","An implementation of SipHash 2-4.",null,null],[3,"SipHasher24","","An implementation of SipHash 2-4.",null,null],[0,"intrinsics","std","rustc compiler intrinsics.",null,null],[5,"atomic_cxchg","std::intrinsics","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::SeqCst` as both the `success` and `failure` parameters. For example, `AtomicBool::compare_exchange`.",null,null],[5,"atomic_cxchg_acq","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::Acquire` as both the `success` and `failure` parameters. For example, `AtomicBool::compare_exchange`.",null,null],[5,"atomic_cxchg_rel","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::Release` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, `AtomicBool::compare_exchange`.",null,null],[5,"atomic_cxchg_acqrel","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::AcqRel` as the `success` and `Ordering::Acquire` as the `failure` parameters. For example, `AtomicBool::compare_exchange`.",null,null],[5,"atomic_cxchg_relaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::Relaxed` as both the `success` and `failure` parameters. For example, `AtomicBool::compare_exchange`.",null,null],[5,"atomic_cxchg_failrelaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::SeqCst` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, `AtomicBool::compare_exchange`.",null,null],[5,"atomic_cxchg_failacq","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::SeqCst` as the `success` and `Ordering::Acquire` as the `failure` parameters. For example, `AtomicBool::compare_exchange`.",null,null],[5,"atomic_cxchg_acq_failrelaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::Acquire` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, `AtomicBool::compare_exchange`.",null,null],[5,"atomic_cxchg_acqrel_failrelaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::AcqRel` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, `AtomicBool::compare_exchange`.",null,null],[5,"atomic_cxchgweak","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::SeqCst` as both the `success` and `failure` parameters. For example, `AtomicBool::compare_exchange_weak`.",null,null],[5,"atomic_cxchgweak_acq","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::Acquire` as both the `success` and `failure` parameters. For example, `AtomicBool::compare_exchange_weak`.",null,null],[5,"atomic_cxchgweak_rel","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::Release` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, `AtomicBool::compare_exchange_weak`.",null,null],[5,"atomic_cxchgweak_acqrel","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::AcqRel` as the `success` and `Ordering::Acquire` as the `failure` parameters. For example, `AtomicBool::compare_exchange_weak`.",null,null],[5,"atomic_cxchgweak_relaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::Relaxed` as both the `success` and `failure` parameters. For example, `AtomicBool::compare_exchange_weak`.",null,null],[5,"atomic_cxchgweak_failrelaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::SeqCst` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, `AtomicBool::compare_exchange_weak`.",null,null],[5,"atomic_cxchgweak_failacq","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::SeqCst` as the `success` and `Ordering::Acquire` as the `failure` parameters. For example, `AtomicBool::compare_exchange_weak`.",null,null],[5,"atomic_cxchgweak_acq_failrelaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::Acquire` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, `AtomicBool::compare_exchange_weak`.",null,null],[5,"atomic_cxchgweak_acqrel_failrelaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::AcqRel` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, `AtomicBool::compare_exchange_weak`.",null,null],[5,"atomic_load","","Loads the current value of the pointer. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `load` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::load`.",null,null],[5,"atomic_load_acq","","Loads the current value of the pointer. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `load` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicBool::load`.",null,null],[5,"atomic_load_relaxed","","Loads the current value of the pointer. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `load` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::load`.",null,null],[5,"atomic_load_unordered","","",null,null],[5,"atomic_store","","Stores the value at the specified memory location. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `store` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::store`.",null,null],[5,"atomic_store_rel","","Stores the value at the specified memory location. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `store` method by passing `Ordering::Release` as the `order`. For example, `AtomicBool::store`.",null,null],[5,"atomic_store_relaxed","","Stores the value at the specified memory location. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `store` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::store`.",null,null],[5,"atomic_store_unordered","","",null,null],[5,"atomic_xchg","","Stores the value at the specified memory location, returning the old value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `swap` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::swap`.",null,null],[5,"atomic_xchg_acq","","Stores the value at the specified memory location, returning the old value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `swap` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicBool::swap`.",null,null],[5,"atomic_xchg_rel","","Stores the value at the specified memory location, returning the old value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `swap` method by passing `Ordering::Release` as the `order`. For example, `AtomicBool::swap`.",null,null],[5,"atomic_xchg_acqrel","","Stores the value at the specified memory location, returning the old value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `swap` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicBool::swap`.",null,null],[5,"atomic_xchg_relaxed","","Stores the value at the specified memory location, returning the old value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `swap` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::swap`.",null,null],[5,"atomic_xadd","","Add to the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_add` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicIsize::fetch_add`.",null,null],[5,"atomic_xadd_acq","","Add to the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_add` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicIsize::fetch_add`.",null,null],[5,"atomic_xadd_rel","","Add to the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_add` method by passing `Ordering::Release` as the `order`. For example, `AtomicIsize::fetch_add`.",null,null],[5,"atomic_xadd_acqrel","","Add to the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_add` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicIsize::fetch_add`.",null,null],[5,"atomic_xadd_relaxed","","Add to the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_add` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicIsize::fetch_add`.",null,null],[5,"atomic_xsub","","Subtract from the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_sub` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicIsize::fetch_sub`.",null,null],[5,"atomic_xsub_acq","","Subtract from the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_sub` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicIsize::fetch_sub`.",null,null],[5,"atomic_xsub_rel","","Subtract from the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_sub` method by passing `Ordering::Release` as the `order`. For example, `AtomicIsize::fetch_sub`.",null,null],[5,"atomic_xsub_acqrel","","Subtract from the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_sub` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicIsize::fetch_sub`.",null,null],[5,"atomic_xsub_relaxed","","Subtract from the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_sub` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicIsize::fetch_sub`.",null,null],[5,"atomic_and","","Bitwise and with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_and` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::fetch_and`.",null,null],[5,"atomic_and_acq","","Bitwise and with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_and` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicBool::fetch_and`.",null,null],[5,"atomic_and_rel","","Bitwise and with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_and` method by passing `Ordering::Release` as the `order`. For example, `AtomicBool::fetch_and`.",null,null],[5,"atomic_and_acqrel","","Bitwise and with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_and` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicBool::fetch_and`.",null,null],[5,"atomic_and_relaxed","","Bitwise and with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_and` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::fetch_and`.",null,null],[5,"atomic_nand","","Bitwise nand with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic::AtomicBool` type via the `fetch_nand` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::fetch_nand`.",null,null],[5,"atomic_nand_acq","","Bitwise nand with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic::AtomicBool` type via the `fetch_nand` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicBool::fetch_nand`.",null,null],[5,"atomic_nand_rel","","Bitwise nand with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic::AtomicBool` type via the `fetch_nand` method by passing `Ordering::Release` as the `order`. For example, `AtomicBool::fetch_nand`.",null,null],[5,"atomic_nand_acqrel","","Bitwise nand with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic::AtomicBool` type via the `fetch_nand` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicBool::fetch_nand`.",null,null],[5,"atomic_nand_relaxed","","Bitwise nand with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic::AtomicBool` type via the `fetch_nand` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::fetch_nand`.",null,null],[5,"atomic_or","","Bitwise or with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_or` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::fetch_or`.",null,null],[5,"atomic_or_acq","","Bitwise or with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_or` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicBool::fetch_or`.",null,null],[5,"atomic_or_rel","","Bitwise or with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_or` method by passing `Ordering::Release` as the `order`. For example, `AtomicBool::fetch_or`.",null,null],[5,"atomic_or_acqrel","","Bitwise or with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_or` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicBool::fetch_or`.",null,null],[5,"atomic_or_relaxed","","Bitwise or with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_or` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::fetch_or`.",null,null],[5,"atomic_xor","","Bitwise xor with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_xor` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::fetch_xor`.",null,null],[5,"atomic_xor_acq","","Bitwise xor with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_xor` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicBool::fetch_xor`.",null,null],[5,"atomic_xor_rel","","Bitwise xor with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_xor` method by passing `Ordering::Release` as the `order`. For example, `AtomicBool::fetch_xor`.",null,null],[5,"atomic_xor_acqrel","","Bitwise xor with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_xor` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicBool::fetch_xor`.",null,null],[5,"atomic_xor_relaxed","","Bitwise xor with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_xor` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::fetch_xor`.",null,null],[5,"atomic_max","","",null,null],[5,"atomic_max_acq","","",null,null],[5,"atomic_max_rel","","",null,null],[5,"atomic_max_acqrel","","",null,null],[5,"atomic_max_relaxed","","",null,null],[5,"atomic_min","","",null,null],[5,"atomic_min_acq","","",null,null],[5,"atomic_min_rel","","",null,null],[5,"atomic_min_acqrel","","",null,null],[5,"atomic_min_relaxed","","",null,null],[5,"atomic_umin","","",null,null],[5,"atomic_umin_acq","","",null,null],[5,"atomic_umin_rel","","",null,null],[5,"atomic_umin_acqrel","","",null,null],[5,"atomic_umin_relaxed","","",null,null],[5,"atomic_umax","","",null,null],[5,"atomic_umax_acq","","",null,null],[5,"atomic_umax_rel","","",null,null],[5,"atomic_umax_acqrel","","",null,null],[5,"atomic_umax_relaxed","","",null,null],[5,"atomic_fence","","",null,null],[5,"atomic_fence_acq","","",null,null],[5,"atomic_fence_rel","","",null,null],[5,"atomic_fence_acqrel","","",null,null],[5,"atomic_singlethreadfence","","A compiler-only memory barrier.",null,null],[5,"atomic_singlethreadfence_acq","","",null,null],[5,"atomic_singlethreadfence_rel","","",null,null],[5,"atomic_singlethreadfence_acqrel","","",null,null],[5,"rustc_peek","","Magic intrinsic that derives its meaning from attributes attached to the function.",null,{"inputs":[{"name":"t"}],"output":{"name":"t"}}],[5,"abort","","Aborts the execution of the process.",null,null],[5,"unreachable","","Tells LLVM that this point in the code is not reachable, enabling further optimizations.",null,null],[5,"assume","","Informs the optimizer that a condition is always true. If the condition is false, the behavior is undefined.",null,null],[5,"likely","","Hints to the compiler that branch condition is likely to be true. Returns the value passed to it.",null,{"inputs":[{"name":"bool"}],"output":{"name":"bool"}}],[5,"unlikely","","Hints to the compiler that branch condition is likely to be false. Returns the value passed to it.",null,{"inputs":[{"name":"bool"}],"output":{"name":"bool"}}],[5,"breakpoint","","Executes a breakpoint trap, for inspection by a debugger.",null,null],[5,"size_of","","The size of a type in bytes.",null,{"inputs":[],"output":{"name":"usize"}}],[5,"move_val_init","","Moves a value to an uninitialized memory location.",null,null],[5,"min_align_of","","",null,{"inputs":[],"output":{"name":"usize"}}],[5,"pref_align_of","","",null,{"inputs":[],"output":{"name":"usize"}}],[5,"size_of_val","","",null,{"inputs":[{"name":"t"}],"output":{"name":"usize"}}],[5,"min_align_of_val","","",null,{"inputs":[{"name":"t"}],"output":{"name":"usize"}}],[5,"drop_in_place","","Executes the destructor (if any) of the pointed-to value.",null,null],[5,"type_name","","Gets a static string slice containing the name of a type.",null,{"inputs":[],"output":{"name":"str"}}],[5,"type_id","","Gets an identifier which is globally unique to the specified type. This function will return the same value for a type regardless of whichever crate it is invoked in.",null,{"inputs":[],"output":{"name":"u64"}}],[5,"init","","Creates a value initialized to zero.",null,{"inputs":[],"output":{"name":"t"}}],[5,"uninit","","Creates an uninitialized value.",null,{"inputs":[],"output":{"name":"t"}}],[5,"forget","","Moves a value out of scope without running drop glue.",null,null],[5,"transmute","","Reinterprets the bits of a value of one type as another type.",null,{"inputs":[{"name":"t"}],"output":{"name":"u"}}],[5,"needs_drop","","Returns `true` if the actual type given as `T` requires drop glue; returns `false` if the actual type provided for `T` implements `Copy`.",null,{"inputs":[],"output":{"name":"bool"}}],[5,"offset","","Calculates the offset from a pointer.",null,null],[5,"arith_offset","","Calculates the offset from a pointer, potentially wrapping.",null,null],[5,"copy_nonoverlapping","","Copies `count * size_of<T>` bytes from `src` to `dst`. The source and destination may *not* overlap.",null,null],[5,"copy","","Copies `count * size_of<T>` bytes from `src` to `dst`. The source and destination may overlap.",null,null],[5,"write_bytes","","Invokes memset on the specified pointer, setting `count * size_of::<T>()` bytes of memory starting at `dst` to `val`.",null,null],[5,"volatile_copy_nonoverlapping_memory","","Equivalent to the appropriate `llvm.memcpy.p0i8.0i8.*` intrinsic, with a size of `count` * `size_of::<T>()` and an alignment of `min_align_of::<T>()`",null,null],[5,"volatile_copy_memory","","Equivalent to the appropriate `llvm.memmove.p0i8.0i8.*` intrinsic, with a size of `count` * `size_of::<T>()` and an alignment of `min_align_of::<T>()`",null,null],[5,"volatile_set_memory","","Equivalent to the appropriate `llvm.memset.p0i8.*` intrinsic, with a size of `count` * `size_of::<T>()` and an alignment of `min_align_of::<T>()`.",null,null],[5,"volatile_load","","Perform a volatile load from the `src` pointer. The stabilized version of this intrinsic is `std::ptr::read_volatile`.",null,null],[5,"volatile_store","","Perform a volatile store to the `dst` pointer. The stabilized version of this intrinsic is `std::ptr::write_volatile`.",null,null],[5,"sqrtf32","","Returns the square root of an `f32`",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"sqrtf64","","Returns the square root of an `f64`",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"powif32","","Raises an `f32` to an integer power.",null,{"inputs":[{"name":"f32"},{"name":"i32"}],"output":{"name":"f32"}}],[5,"powif64","","Raises an `f64` to an integer power.",null,{"inputs":[{"name":"f64"},{"name":"i32"}],"output":{"name":"f64"}}],[5,"sinf32","","Returns the sine of an `f32`.",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"sinf64","","Returns the sine of an `f64`.",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"cosf32","","Returns the cosine of an `f32`.",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"cosf64","","Returns the cosine of an `f64`.",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"powf32","","Raises an `f32` to an `f32` power.",null,{"inputs":[{"name":"f32"},{"name":"f32"}],"output":{"name":"f32"}}],[5,"powf64","","Raises an `f64` to an `f64` power.",null,{"inputs":[{"name":"f64"},{"name":"f64"}],"output":{"name":"f64"}}],[5,"expf32","","Returns the exponential of an `f32`.",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"expf64","","Returns the exponential of an `f64`.",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"exp2f32","","Returns 2 raised to the power of an `f32`.",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"exp2f64","","Returns 2 raised to the power of an `f64`.",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"logf32","","Returns the natural logarithm of an `f32`.",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"logf64","","Returns the natural logarithm of an `f64`.",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"log10f32","","Returns the base 10 logarithm of an `f32`.",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"log10f64","","Returns the base 10 logarithm of an `f64`.",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"log2f32","","Returns the base 2 logarithm of an `f32`.",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"log2f64","","Returns the base 2 logarithm of an `f64`.",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"fmaf32","","Returns `a * b + c` for `f32` values.",null,{"inputs":[{"name":"f32"},{"name":"f32"},{"name":"f32"}],"output":{"name":"f32"}}],[5,"fmaf64","","Returns `a * b + c` for `f64` values.",null,{"inputs":[{"name":"f64"},{"name":"f64"},{"name":"f64"}],"output":{"name":"f64"}}],[5,"fabsf32","","Returns the absolute value of an `f32`.",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"fabsf64","","Returns the absolute value of an `f64`.",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"copysignf32","","Copies the sign from `y` to `x` for `f32` values.",null,{"inputs":[{"name":"f32"},{"name":"f32"}],"output":{"name":"f32"}}],[5,"copysignf64","","Copies the sign from `y` to `x` for `f64` values.",null,{"inputs":[{"name":"f64"},{"name":"f64"}],"output":{"name":"f64"}}],[5,"floorf32","","Returns the largest integer less than or equal to an `f32`.",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"floorf64","","Returns the largest integer less than or equal to an `f64`.",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"ceilf32","","Returns the smallest integer greater than or equal to an `f32`.",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"ceilf64","","Returns the smallest integer greater than or equal to an `f64`.",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"truncf32","","Returns the integer part of an `f32`.",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"truncf64","","Returns the integer part of an `f64`.",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"rintf32","","Returns the nearest integer to an `f32`. May raise an inexact floating-point exception if the argument is not an integer.",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"rintf64","","Returns the nearest integer to an `f64`. May raise an inexact floating-point exception if the argument is not an integer.",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"nearbyintf32","","Returns the nearest integer to an `f32`.",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"nearbyintf64","","Returns the nearest integer to an `f64`.",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"roundf32","","Returns the nearest integer to an `f32`. Rounds half-way cases away from zero.",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"roundf64","","Returns the nearest integer to an `f64`. Rounds half-way cases away from zero.",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"fadd_fast","","Float addition that allows optimizations based on algebraic rules. May assume inputs are finite.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"fsub_fast","","Float subtraction that allows optimizations based on algebraic rules. May assume inputs are finite.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"fmul_fast","","Float multiplication that allows optimizations based on algebraic rules. May assume inputs are finite.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"fdiv_fast","","Float division that allows optimizations based on algebraic rules. May assume inputs are finite.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"frem_fast","","Float remainder that allows optimizations based on algebraic rules. May assume inputs are finite.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"ctpop","","Returns the number of bits set in an integer type `T`",null,{"inputs":[{"name":"t"}],"output":{"name":"t"}}],[5,"ctlz","","Returns the number of leading unset bits (zeroes) in an integer type `T`.",null,{"inputs":[{"name":"t"}],"output":{"name":"t"}}],[5,"cttz","","Returns the number of trailing unset bits (zeroes) in an integer type `T`.",null,{"inputs":[{"name":"t"}],"output":{"name":"t"}}],[5,"bswap","","Reverses the bytes in an integer type `T`.",null,{"inputs":[{"name":"t"}],"output":{"name":"t"}}],[5,"add_with_overflow","","Performs checked integer addition. The stabilized versions of this intrinsic are available on the integer primitives via the `overflowing_add` method. For example, `std::u32::overflowing_add`",null,null],[5,"sub_with_overflow","","Performs checked integer subtraction The stabilized versions of this intrinsic are available on the integer primitives via the `overflowing_sub` method. For example, `std::u32::overflowing_sub`",null,null],[5,"mul_with_overflow","","Performs checked integer multiplication The stabilized versions of this intrinsic are available on the integer primitives via the `overflowing_mul` method. For example, `std::u32::overflowing_mul`",null,null],[5,"unchecked_div","","Performs an unchecked division, resulting in undefined behavior where y = 0 or x = `T::min_value()` and y = -1",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"unchecked_rem","","Returns the remainder of an unchecked division, resulting in undefined behavior where y = 0 or x = `T::min_value()` and y = -1",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"overflowing_add","","Returns (a + b) mod 2^N, where N is the width of T in bits. The stabilized versions of this intrinsic are available on the integer primitives via the `wrapping_add` method. For example, `std::u32::wrapping_add`",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"overflowing_sub","","Returns (a - b) mod 2^N, where N is the width of T in bits. The stabilized versions of this intrinsic are available on the integer primitives via the `wrapping_sub` method. For example, `std::u32::wrapping_sub`",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"overflowing_mul","","Returns (a * b) mod 2^N, where N is the width of T in bits. The stabilized versions of this intrinsic are available on the integer primitives via the `wrapping_mul` method. For example, `std::u32::wrapping_mul`",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"discriminant_value","","Returns the value of the discriminant for the variant in 'v', cast to a `u64`; if `T` has no discriminant, returns 0.",null,{"inputs":[{"name":"t"}],"output":{"name":"u64"}}],[5,"try","","Rust's \"try catch\" construct which invokes the function pointer `f` with the data pointer `data`.",null,null],[0,"iter","std","Composable external iteration.",null,null],[3,"Rev","std::iter","A double-ended iterator with the direction inverted.",null,null],[3,"Cloned","","An iterator that clones the elements of an underlying iterator.",null,null],[3,"Cycle","","An iterator that repeats endlessly.",null,null],[3,"Chain","","An iterator that strings two iterators together.",null,null],[3,"Zip","","An iterator that iterates two other iterators simultaneously.",null,null],[3,"Map","","An iterator that maps the values of `iter` with `f`.",null,null],[3,"Filter","","An iterator that filters the elements of `iter` with `predicate`.",null,null],[3,"FilterMap","","An iterator that uses `f` to both filter and map elements from `iter`.",null,null],[3,"Enumerate","","An iterator that yields the current count and the element during iteration.",null,null],[3,"Peekable","","An iterator with a `peek()` that returns an optional reference to the next element.",null,null],[3,"SkipWhile","","An iterator that rejects elements while `predicate` is true.",null,null],[3,"TakeWhile","","An iterator that only accepts elements while `predicate` is true.",null,null],[3,"Skip","","An iterator that skips over `n` elements of `iter`.",null,null],[3,"Take","","An iterator that only iterates over the first `n` iterations of `iter`.",null,null],[3,"Scan","","An iterator to maintain state while iterating another iterator.",null,null],[3,"FlatMap","","An iterator that maps each element to an iterator, and yields the elements of the produced iterators.",null,null],[3,"Fuse","","An iterator that yields `None` forever after the underlying iterator yields `None` once.",null,null],[3,"Inspect","","An iterator that calls a function with a reference to each element before yielding it.",null,null],[8,"Extend","","Extend a collection with the contents of an iterator.",null,null],[10,"extend","","Extends a collection with the contents of an iterator.",17,null],[3,"Empty","","An iterator that yields nothing.",null,null],[3,"StepBy","","An adapter for stepping range iterators by a custom amount.",null,null],[8,"Product","","Trait to represent types that can be created by multiplying elements of an iterator.",null,null],[10,"product","","Method which takes an iterator and generates `Self` from the elements by multiplying the items.",18,{"inputs":[{"name":"i"}],"output":{"name":"self"}}],[5,"once","","Creates an iterator that yields an element exactly once.",null,{"inputs":[{"name":"t"}],"output":{"name":"once"}}],[8,"Iterator","","An interface for dealing with iterators.",null,null],[16,"Item","","The type of the elements being iterated over.",19,null],[10,"next","","Advances the iterator and returns the next value.",19,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","Returns the bounds on the remaining length of the iterator.",19,null],[11,"count","","Consumes the iterator, counting the number of iterations and returning it.",19,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"last","","Consumes the iterator, returning the last element.",19,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"nth","","Returns the `n`th element of the iterator.",19,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"chain","","Takes two iterators and creates a new iterator over both in sequence.",19,{"inputs":[{"name":"self"},{"name":"u"}],"output":{"name":"chain"}}],[11,"zip","","'Zips up' two iterators into a single iterator of pairs.",19,{"inputs":[{"name":"self"},{"name":"u"}],"output":{"name":"zip"}}],[11,"map","","Takes a closure and creates an iterator which calls that closure on each element.",19,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"map"}}],[11,"filter","","Creates an iterator which uses a closure to determine if an element should be yielded.",19,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"filter"}}],[11,"filter_map","","Creates an iterator that both filters and maps.",19,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"filtermap"}}],[11,"enumerate","","Creates an iterator which gives the current iteration count as well as the next value.",19,{"inputs":[{"name":"self"}],"output":{"name":"enumerate"}}],[11,"peekable","","Creates an iterator which can use `peek` to look at the next element of the iterator without consuming it.",19,{"inputs":[{"name":"self"}],"output":{"name":"peekable"}}],[11,"skip_while","","Creates an iterator that [`skip()`]s elements based on a predicate.",19,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"skipwhile"}}],[11,"take_while","","Creates an iterator that yields elements based on a predicate.",19,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"takewhile"}}],[11,"skip","","Creates an iterator that skips the first `n` elements.",19,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"skip"}}],[11,"take","","Creates an iterator that yields its first `n` elements.",19,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"take"}}],[11,"scan","","An iterator adaptor similar to [`fold()`] that holds internal state and produces a new iterator.",19,{"inputs":[{"name":"self"},{"name":"st"},{"name":"f"}],"output":{"name":"scan"}}],[11,"flat_map","","Creates an iterator that works like map, but flattens nested structure.",19,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"flatmap"}}],[11,"fuse","","Creates an iterator which ends after the first [`None`].",19,{"inputs":[{"name":"self"}],"output":{"name":"fuse"}}],[11,"inspect","","Do something with each element of an iterator, passing the value on.",19,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"inspect"}}],[11,"by_ref","","Borrows an iterator, rather than consuming it.",19,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"collect","","Transforms an iterator into a collection.",19,{"inputs":[{"name":"self"}],"output":{"name":"b"}}],[11,"partition","","Consumes an iterator, creating two collections from it.",19,null],[11,"fold","","An iterator adaptor that applies a function, producing a single, final value.",19,{"inputs":[{"name":"self"},{"name":"b"},{"name":"f"}],"output":{"name":"b"}}],[11,"all","","Tests if every element of the iterator matches a predicate.",19,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"any","","Tests if any element of the iterator matches a predicate.",19,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"find","","Searches for an element of an iterator that satisfies a predicate.",19,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"option"}}],[11,"position","","Searches for an element in an iterator, returning its index.",19,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"option"}}],[11,"rposition","","Searches for an element in an iterator from the right, returning its index.",19,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"option"}}],[11,"max","","Returns the maximum element of an iterator.",19,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"min","","Returns the minimum element of an iterator.",19,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"max_by_key","","Returns the element that gives the maximum value from the specified function.",19,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"max_by","","Returns the element that gives the maximum value with respect to the specified comparison function.",19,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"min_by_key","","Returns the element that gives the minimum value from the specified function.",19,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"min_by","","Returns the element that gives the minimum value with respect to the specified comparison function.",19,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"rev","","Reverses an iterator's direction.",19,{"inputs":[{"name":"self"}],"output":{"name":"rev"}}],[11,"unzip","","Converts an iterator of pairs into a pair of containers.",19,null],[11,"cloned","","Creates an iterator which [`clone()`]s all of its elements.",19,{"inputs":[{"name":"self"}],"output":{"name":"cloned"}}],[11,"cycle","","Repeats an iterator endlessly.",19,{"inputs":[{"name":"self"}],"output":{"name":"cycle"}}],[11,"sum","","Sums the elements of an iterator.",19,{"inputs":[{"name":"self"}],"output":{"name":"s"}}],[11,"product","","Iterates over the entire iterator, multiplying all the elements",19,{"inputs":[{"name":"self"}],"output":{"name":"p"}}],[11,"cmp","","Lexicographically compares the elements of this `Iterator` with those of another.",19,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","Lexicographically compares the elements of this `Iterator` with those of another.",19,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"option"}}],[11,"eq","","Determines if the elements of this `Iterator` are equal to those of another.",19,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"bool"}}],[11,"ne","","Determines if the elements of this `Iterator` are unequal to those of another.",19,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"bool"}}],[11,"lt","","Determines if the elements of this `Iterator` are lexicographically less than those of another.",19,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"bool"}}],[11,"le","","Determines if the elements of this `Iterator` are lexicographically less or equal to those of another.",19,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"bool"}}],[11,"gt","","Determines if the elements of this `Iterator` are lexicographically greater than those of another.",19,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"bool"}}],[11,"ge","","Determines if the elements of this `Iterator` are lexicographically greater than or equal to those of another.",19,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"bool"}}],[5,"empty","","Creates an iterator that yields nothing.",null,{"inputs":[],"output":{"name":"empty"}}],[8,"FusedIterator","","An iterator that always continues to yield `None` when exhausted.",null,null],[3,"Once","","An iterator that yields an element exactly once.",null,null],[8,"Sum","","Trait to represent types that can be created by summing up an iterator.",null,null],[10,"sum","","Method which takes an iterator and generates `Self` from the elements by \"summing up\" the items.",20,{"inputs":[{"name":"i"}],"output":{"name":"self"}}],[8,"ExactSizeIterator","","An iterator that knows its exact length.",null,null],[11,"len","","Returns the exact number of times the iterator will iterate.",21,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","Returns whether the iterator is empty.",21,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[5,"repeat","","Creates a new iterator that endlessly repeats a single element.",null,{"inputs":[{"name":"t"}],"output":{"name":"repeat"}}],[8,"IntoIterator","","Conversion into an `Iterator`.",null,null],[16,"Item","","The type of the elements being iterated over.",22,null],[16,"IntoIter","","Which kind of iterator are we turning this into?",22,null],[10,"into_iter","","Creates an iterator from a value.",22,null],[8,"TrustedLen","","An iterator that reports an accurate length using size_hint.",null,null],[8,"DoubleEndedIterator","","An iterator able to yield elements from both ends.",null,null],[10,"next_back","","Removes and returns an element from the end of the iterator.",23,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"rfind","","Searches for an element of an iterator from the right that satisfies a predicate.",23,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"option"}}],[3,"Repeat","","An iterator that repeats an element endlessly.",null,null],[8,"FromIterator","","Conversion from an `Iterator`.",null,null],[10,"from_iter","","Creates a value from an iterator.",24,{"inputs":[{"name":"t"}],"output":{"name":"self"}}],[8,"Step","","Objects that can be stepped over in both directions.",null,null],[10,"step","","Steps `self` if possible.",25,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"option"}}],[10,"steps_between","","Returns the number of steps between two step objects. The count is inclusive of `start` and exclusive of `end`.",25,{"inputs":[{"name":"self"},{"name":"self"},{"name":"self"}],"output":{"name":"option"}}],[10,"steps_between_by_one","","Same as `steps_between`, but with a `by` of 1",25,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"option"}}],[10,"is_negative","","Tests whether this step is negative or not (going backwards)",25,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[10,"replace_one","","Replaces this step with `1`, returning itself",25,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[10,"replace_zero","","Replaces this step with `0`, returning itself",25,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[10,"add_one","","Adds one to this step, returning the result",25,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[10,"sub_one","","Subtracts one to this step, returning the result",25,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[0,"marker","std","Primitive traits and types representing basic properties of types.",null,null],[8,"Send","std::marker","Types that can be transferred across thread boundaries.",null,null],[8,"Sized","","Types with a constant size known at compile time.",null,null],[8,"Unsize","","Types that can be \"unsized\" to a dynamically-sized type.",null,null],[8,"Copy","","Types whose values can be duplicated simply by copying bits.",null,null],[8,"Sync","","Types for which it is safe to share references between threads.",null,null],[3,"PhantomData","","Zero-sized type used to mark things that \"act like\" they own a `T`.",null,null],[0,"mem","std","Basic functions for dealing with memory.",null,null],[5,"forget","std::mem","Leaks a value: takes ownership and \"forgets\" about the value **without running its destructor**.",null,null],[5,"size_of","","Returns the size of a type in bytes.",null,{"inputs":[],"output":{"name":"usize"}}],[5,"size_of_val","","Returns the size of the pointed-to value in bytes.",null,{"inputs":[{"name":"t"}],"output":{"name":"usize"}}],[5,"min_align_of","","Returns the [ABI]-required minimum alignment of a type.",null,{"inputs":[],"output":{"name":"usize"}}],[5,"min_align_of_val","","Returns the [ABI]-required minimum alignment of the type of the value that `val` points to.",null,{"inputs":[{"name":"t"}],"output":{"name":"usize"}}],[5,"align_of","","Returns the [ABI]-required minimum alignment of a type.",null,{"inputs":[],"output":{"name":"usize"}}],[5,"align_of_val","","Returns the [ABI]-required minimum alignment of the type of the value that `val` points to.",null,{"inputs":[{"name":"t"}],"output":{"name":"usize"}}],[5,"zeroed","","Creates a value whose bytes are all zero.",null,{"inputs":[],"output":{"name":"t"}}],[5,"uninitialized","","Bypasses Rust's normal memory-initialization checks by pretending to produce a value of type `T`, while doing nothing at all.",null,{"inputs":[],"output":{"name":"t"}}],[5,"swap","","Swaps the values at two mutable locations, without deinitializing either one.",null,null],[5,"replace","","Replaces the value at a mutable location with a new one, returning the old value, without deinitializing either one.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"drop","","Disposes of a value.",null,null],[5,"transmute_copy","","Interprets `src` as having type `&U`, and then reads `src` without moving the contained value.",null,{"inputs":[{"name":"t"}],"output":{"name":"u"}}],[3,"Discriminant","","Opaque type representing the discriminant of an enum.",null,null],[5,"discriminant","","Returns a value uniquely identifying the enum variant in `v`.",null,{"inputs":[{"name":"t"}],"output":{"name":"discriminant"}}],[5,"transmute","","Reinterprets the bits of a value of one type as another type.",null,{"inputs":[{"name":"t"}],"output":{"name":"u"}}],[0,"ops","std","Overloadable operators.",null,null],[8,"Drop","std::ops","The `Drop` trait is used to run some code when a value goes out of scope. This is sometimes called a 'destructor'.",null,null],[10,"drop","","A method called when the value goes out of scope.",26,null],[8,"Add","","The `Add` trait is used to specify the functionality of `+`.",null,null],[16,"Output","","The resulting type after applying the `+` operator",27,null],[10,"add","","The method for the `+` operator",27,null],[8,"Sub","","The `Sub` trait is used to specify the functionality of `-`.",null,null],[16,"Output","","The resulting type after applying the `-` operator",28,null],[10,"sub","","The method for the `-` operator",28,null],[8,"Mul","","The `Mul` trait is used to specify the functionality of `*`.",null,null],[16,"Output","","The resulting type after applying the `*` operator",29,null],[10,"mul","","The method for the `*` operator",29,null],[8,"Div","","The `Div` trait is used to specify the functionality of `/`.",null,null],[16,"Output","","The resulting type after applying the `/` operator",30,null],[10,"div","","The method for the `/` operator",30,null],[8,"Rem","","The `Rem` trait is used to specify the functionality of `%`.",null,null],[16,"Output","","The resulting type after applying the `%` operator",31,null],[10,"rem","","The method for the `%` operator",31,null],[8,"Neg","","The `Neg` trait is used to specify the functionality of unary `-`.",null,null],[16,"Output","","The resulting type after applying the `-` operator",32,null],[10,"neg","","The method for the unary `-` operator",32,null],[8,"Not","","The `Not` trait is used to specify the functionality of unary `!`.",null,null],[16,"Output","","The resulting type after applying the `!` operator",33,null],[10,"not","","The method for the unary `!` operator",33,null],[8,"BitAnd","","The `BitAnd` trait is used to specify the functionality of `&`.",null,null],[16,"Output","","The resulting type after applying the `&` operator",34,null],[10,"bitand","","The method for the `&` operator",34,null],[8,"BitOr","","The `BitOr` trait is used to specify the functionality of `|`.",null,null],[16,"Output","","The resulting type after applying the `|` operator",35,null],[10,"bitor","","The method for the `|` operator",35,null],[8,"BitXor","","The `BitXor` trait is used to specify the functionality of `^`.",null,null],[16,"Output","","The resulting type after applying the `^` operator",36,null],[10,"bitxor","","The method for the `^` operator",36,null],[8,"Shl","","The `Shl` trait is used to specify the functionality of `<<`.",null,null],[16,"Output","","The resulting type after applying the `<<` operator",37,null],[10,"shl","","The method for the `<<` operator",37,null],[8,"Shr","","The `Shr` trait is used to specify the functionality of `>>`.",null,null],[16,"Output","","The resulting type after applying the `>>` operator",38,null],[10,"shr","","The method for the `>>` operator",38,null],[8,"AddAssign","","The `AddAssign` trait is used to specify the functionality of `+=`.",null,null],[10,"add_assign","","The method for the `+=` operator",39,null],[8,"SubAssign","","The `SubAssign` trait is used to specify the functionality of `-=`.",null,null],[10,"sub_assign","","The method for the `-=` operator",40,null],[8,"MulAssign","","The `MulAssign` trait is used to specify the functionality of `*=`.",null,null],[10,"mul_assign","","The method for the `*=` operator",41,null],[8,"DivAssign","","The `DivAssign` trait is used to specify the functionality of `/=`.",null,null],[10,"div_assign","","The method for the `/=` operator",42,null],[8,"RemAssign","","The `RemAssign` trait is used to specify the functionality of `%=`.",null,null],[10,"rem_assign","","The method for the `%=` operator",43,null],[8,"BitAndAssign","","The `BitAndAssign` trait is used to specify the functionality of `&=`.",null,null],[10,"bitand_assign","","The method for the `&=` operator",44,null],[8,"BitOrAssign","","The `BitOrAssign` trait is used to specify the functionality of `|=`.",null,null],[10,"bitor_assign","","The method for the `|=` operator",45,null],[8,"BitXorAssign","","The `BitXorAssign` trait is used to specify the functionality of `^=`.",null,null],[10,"bitxor_assign","","The method for the `^=` operator",46,null],[8,"ShlAssign","","The `ShlAssign` trait is used to specify the functionality of `<<=`.",null,null],[10,"shl_assign","","The method for the `<<=` operator",47,null],[8,"ShrAssign","","The `ShrAssign` trait is used to specify the functionality of `>>=`.",null,null],[10,"shr_assign","","The method for the `>>=` operator",48,null],[8,"Index","","The `Index` trait is used to specify the functionality of indexing operations like `container[index]` when used in an immutable context.",null,null],[16,"Output","","The returned type after indexing",49,null],[10,"index","","The method for the indexing (`container[index]`) operation",49,null],[8,"IndexMut","","The `IndexMut` trait is used to specify the functionality of indexing operations like `container[index]` when used in a mutable context.",null,null],[10,"index_mut","","The method for the mutable indexing (`container[index]`) operation",50,null],[3,"RangeFull","","An unbounded range. Use `..` (two dots) for its shorthand.",null,null],[3,"Range","","A (half-open) range which is bounded at both ends: { x | start <= x < end }. Use `start..end` (two dots) for its shorthand.",null,null],[12,"start","","The lower bound of the range (inclusive).",51,null],[12,"end","","The upper bound of the range (exclusive).",51,null],[3,"RangeFrom","","A range which is only bounded below: { x | start <= x }. Use `start..` for its shorthand.",null,null],[12,"start","","The lower bound of the range (inclusive).",52,null],[3,"RangeTo","","A range which is only bounded above: { x | x < end }. Use `..end` (two dots) for its shorthand.",null,null],[12,"end","","The upper bound of the range (exclusive).",53,null],[4,"RangeInclusive","","An inclusive range which is bounded at both ends: { x | start <= x <= end }. Use `start...end` (three dots) for its shorthand.",null,null],[13,"Empty","","Empty range (iteration has finished)",54,null],[12,"at","std::ops::RangeInclusive","The point at which iteration finished",54,null],[13,"NonEmpty","std::ops","Non-empty range (iteration will yield value(s))",54,null],[12,"start","std::ops::RangeInclusive","The lower bound of the range (inclusive).",54,null],[12,"end","","The upper bound of the range (inclusive).",54,null],[3,"RangeToInclusive","std::ops","An inclusive range which is only bounded above: { x | x <= end }. Use `...end` (three dots) for its shorthand.",null,null],[12,"end","","The upper bound of the range (inclusive)",55,null],[8,"Deref","","The `Deref` trait is used to specify the functionality of dereferencing operations, like `*v`.",null,null],[16,"Target","","The resulting type after dereferencing",56,null],[10,"deref","","The method called to dereference a value",56,null],[8,"DerefMut","","The `DerefMut` trait is used to specify the functionality of dereferencing mutably like `*v = 1;`",null,null],[10,"deref_mut","","The method called to mutably dereference a value",57,null],[8,"Fn","","A version of the call operator that takes an immutable receiver.",null,null],[10,"call","","This is called when the call operator is used.",58,null],[8,"FnMut","","A version of the call operator that takes a mutable receiver.",null,null],[10,"call_mut","","This is called when the call operator is used.",59,null],[8,"FnOnce","","A version of the call operator that takes a by-value receiver.",null,null],[16,"Output","","The returned type after the call operator is used.",60,null],[10,"call_once","","This is called when the call operator is used.",60,null],[8,"CoerceUnsized","","Trait that indicates that this is a pointer or a wrapper for one, where unsizing can be performed on the pointee.",null,null],[8,"Place","","Both `PLACE <- EXPR` and `box EXPR` desugar into expressions that allocate an intermediate \"place\" that holds uninitialized state.  The desugaring evaluates EXPR, and writes the result at the address returned by the `pointer` method of this trait.",null,null],[10,"pointer","","Returns the address where the input value will be written. Note that the data at this address is generally uninitialized, and thus one should use `ptr::write` for initializing it.",61,null],[8,"Placer","","Interface to implementations of  `PLACE <- EXPR`.",null,null],[16,"Place","","`Place` is the intermedate agent guarding the uninitialized state for `Data`.",62,null],[10,"make_place","","Creates a fresh place from `self`.",62,null],[8,"InPlace","","Specialization of `Place` trait supporting `PLACE <- EXPR`.",null,null],[16,"Owner","","`Owner` is the type of the end value of `PLACE <- EXPR`",63,null],[10,"finalize","","Converts self into the final value, shifting deallocation/cleanup responsibilities (if any remain), over to the returned instance of `Owner` and forgetting self.",63,null],[8,"Boxed","","Core trait for the `box EXPR` form.",null,null],[16,"Data","","The kind of data that is stored in this kind of box.",64,null],[16,"Place","","The place that will negotiate the storage of the data.",64,null],[10,"finalize","","Converts filled place into final owning value, shifting deallocation/cleanup responsibilities (if any remain), over to returned instance of `Self` and forgetting `filled`.",64,null],[8,"BoxPlace","","Specialization of `Place` trait supporting `box EXPR`.",null,null],[10,"make_place","","Creates a globally fresh place.",65,{"inputs":[],"output":{"name":"self"}}],[8,"Carrier","","A trait for types which have success and error states and are meant to work with the question mark operator. When the `?` operator is used with a value, whether the value is in the success or error state is determined by calling `translate`.",null,null],[16,"Success","","The type of the value when computation succeeds.",66,null],[16,"Error","","The type of the value when computation errors out.",66,null],[10,"from_success","","Create a `Carrier` from a success value.",66,null],[10,"from_error","","Create a `Carrier` from an error value.",66,null],[10,"translate","","Translate this `Carrier` to another implementation of `Carrier` with the same associated types.",66,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[0,"ptr","std","Raw, unsafe pointers, `*const T`, and `*mut T`.",null,null],[5,"null","std::ptr","Creates a null raw pointer.",null,null],[5,"null_mut","","Creates a null mutable raw pointer.",null,null],[5,"swap","","Swaps the values at two mutable locations of the same type, without deinitializing either. They may overlap, unlike `mem::swap` which is otherwise equivalent.",null,null],[5,"replace","","Replaces the value at `dest` with `src`, returning the old value, without dropping either.",null,null],[5,"read","","Reads the value from `src` without moving it. This leaves the memory in `src` unchanged.",null,null],[5,"read_unaligned","","Reads the value from `src` without moving it. This leaves the memory in `src` unchanged.",null,null],[5,"write","","Overwrites a memory location with the given value without reading or dropping the old value.",null,null],[5,"write_unaligned","","Overwrites a memory location with the given value without reading or dropping the old value.",null,null],[5,"read_volatile","","Performs a volatile read of the value from `src` without moving it. This leaves the memory in `src` unchanged.",null,null],[5,"write_volatile","","Performs a volatile write of a memory location with the given value without reading or dropping the old value.",null,null],[5,"eq","","Compare raw pointers for equality.",null,null],[3,"Unique","","A wrapper around a raw non-null `*mut T` that indicates that the possessor of this wrapper owns the referent. This in turn implies that the `Unique<T>` is `Send`/`Sync` if `T` is `Send`/`Sync`, unlike a raw `*mut T` (which conveys no particular ownership semantics).  It also implies that the referent of the pointer should not be modified without a unique path to the `Unique` reference. Useful for building abstractions like `Vec<T>` or `Box<T>`, which internally use raw pointers to manage the memory that they own.",null,null],[3,"Shared","","A wrapper around a raw non-null `*mut T` that indicates that the possessor of this wrapper has shared ownership of the referent. Useful for building abstractions like `Rc<T>` or `Arc<T>`, which internally use raw pointers to manage the memory that they own.",null,null],[5,"write_bytes","","Invokes memset on the specified pointer, setting `count * size_of::<T>()` bytes of memory starting at `dst` to `val`.",null,null],[5,"copy","","Copies `count * size_of<T>` bytes from `src` to `dst`. The source and destination may overlap.",null,null],[5,"copy_nonoverlapping","","Copies `count * size_of<T>` bytes from `src` to `dst`. The source and destination may *not* overlap.",null,null],[5,"drop_in_place","","Executes the destructor (if any) of the pointed-to value.",null,null],[0,"raw","std","Contains struct definitions for the layout of compiler built-in types.",null,null],[3,"TraitObject","std::raw","The representation of a trait object like `&SomeTrait`.",null,null],[12,"data","","",67,null],[12,"vtable","","",67,null],[0,"result","std","Error handling with the `Result` type.",null,null],[4,"Result","std::result","`Result` is a type that represents either success (`Ok`) or failure (`Err`).",null,null],[13,"Ok","","Contains the success value",68,null],[13,"Err","","Contains the error value",68,null],[3,"Iter","","An iterator over a reference to the [`Ok`] variant of a [`Result`].",null,null],[3,"IterMut","","An iterator over a mutable reference to the [`Ok`] variant of a [`Result`].",null,null],[3,"IntoIter","","An iterator over the value in a [`Ok`] variant of a [`Result`].",null,null],[0,"option","std","Optional values.",null,null],[4,"Option","std::option","The `Option` type. See the module level documentation for more.",null,null],[13,"None","","No value",69,null],[13,"Some","","Some value `T`",69,null],[3,"Iter","","An iterator over a reference of the contained item in an [`Option`].",null,null],[3,"IterMut","","An iterator over a mutable reference of the contained item in an [`Option`].",null,null],[3,"IntoIter","","An iterator over the item contained inside an [`Option`].",null,null],[0,"isize","std","The pointer-sized signed integer type.",null,null],[17,"MIN","std::isize","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"i8","std","The 8-bit signed integer type.",null,null],[17,"MIN","std::i8","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"i16","std","The 16-bit signed integer type.",null,null],[17,"MIN","std::i16","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"i32","std","The 32-bit signed integer type.",null,null],[17,"MIN","std::i32","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"i64","std","The 64-bit signed integer type.",null,null],[17,"MIN","std::i64","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"i128","std","The 128-bit signed integer type.",null,null],[17,"MIN","std::i128","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"usize","std","The pointer-sized unsigned integer type.",null,null],[17,"MIN","std::usize","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"u8","std","The 8-bit unsigned integer type.",null,null],[17,"MIN","std::u8","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"u16","std","The 16-bit unsigned integer type.",null,null],[17,"MIN","std::u16","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"u32","std","The 32-bit unsigned integer type.",null,null],[17,"MIN","std::u32","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"u64","std","The 64-bit unsigned integer type.",null,null],[17,"MIN","std::u64","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"boxed","std","A pointer type for heap allocation.",null,null],[17,"HEAP","std::boxed","A value that represents the heap. This is the default place that the `box` keyword allocates into when no place is supplied.",null,null],[3,"ExchangeHeapSingleton","","This the singleton type used solely for `boxed::HEAP`.",null,null],[3,"Box","","A pointer type for heap allocation.",null,null],[3,"IntermediateBox","","`IntermediateBox` represents uninitialized backing storage for `Box`.",null,null],[8,"FnBox","","`FnBox` is a version of the `FnOnce` intended for use with boxed closure objects. The idea is that where one would normally store a `Box<FnOnce()>` in a data structure, you should use `Box<FnBox()>`. The two traits behave essentially the same, except that a `FnBox` closure can only be called if it is boxed. (Note that `FnBox` may be deprecated in the future if `Box<FnOnce()>` closures become directly usable.)",null,null],[16,"Output","","",70,null],[10,"call_box","","",70,null],[0,"rc","std","Single-threaded reference-counting pointers.",null,null],[3,"Rc","std::rc","A single-threaded reference-counting pointer.",null,null],[3,"Weak","","A weak version of [`Rc`][rc].",null,null],[0,"borrow","std","A module for working with borrowed data.",null,null],[8,"ToOwned","std::borrow","A generalization of `Clone` to borrowed data.",null,null],[16,"Owned","","",71,null],[10,"to_owned","","Creates owned data from borrowed data, usually by cloning.",71,null],[4,"Cow","","A clone-on-write smart pointer.",null,null],[13,"Borrowed","","Borrowed data.",72,null],[13,"Owned","","Owned data.",72,null],[8,"Borrow","","A trait for borrowing data.",null,null],[10,"borrow","","Immutably borrows from an owned value.",73,{"inputs":[{"name":"self"}],"output":{"name":"borrowed"}}],[8,"BorrowMut","","A trait for mutably borrowing data.",null,null],[10,"borrow_mut","","Mutably borrows from an owned value.",74,{"inputs":[{"name":"self"}],"output":{"name":"borrowed"}}],[0,"fmt","std","Utilities for formatting and printing `String`s",null,null],[5,"format","std::fmt","The format function takes a precompiled format string and a list of arguments, to return the resulting formatted string.",null,{"inputs":[{"name":"arguments"}],"output":{"name":"string"}}],[8,"Octal","","Format trait for the `o` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",75,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"Pointer","","Format trait for the `p` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",76,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"UpperExp","","Format trait for the `E` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",77,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"Formatter","","A struct to represent both where to emit formatting strings to and how they should be formatted. A mutable version of this is passed to all formatting traits.",null,null],[8,"Display","","Format trait for an empty format, `{}`.",null,null],[10,"fmt","","Formats the value using the given formatter.",78,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"DebugList","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugSet","","A struct to help with `fmt::Debug` implementations.",null,null],[8,"Write","","A collection of methods that are required to format a message into a stream.",null,null],[10,"write_str","","Writes a slice of bytes into this writer, returning whether the write succeeded.",79,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"result"}}],[11,"write_char","","Writes a [`char`] into this writer, returning whether the write succeeded.",79,{"inputs":[{"name":"self"},{"name":"char"}],"output":{"name":"result"}}],[11,"write_fmt","","Glue for usage of the [`write!`] macro with implementors of this trait.",79,{"inputs":[{"name":"self"},{"name":"arguments"}],"output":{"name":"result"}}],[8,"Binary","","Format trait for the `b` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",80,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[5,"write","","The `write` function takes an output stream, a precompiled format string, and a list of arguments. The arguments will be formatted according to the specified format string into the output stream provided.",null,{"inputs":[{"name":"write"},{"name":"arguments"}],"output":{"name":"result"}}],[8,"LowerExp","","Format trait for the `e` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",81,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[8,"UpperHex","","Format trait for the `X` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",82,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"Arguments","","This structure represents a safely precompiled version of a format string and its arguments. This cannot be generated at runtime because it cannot safely be done, so no constructors are given and the fields are private to prevent modification.",null,null],[8,"Debug","","Format trait for the `?` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",83,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[3,"Error","","The error type which is returned from formatting a message into a stream.",null,null],[6,"Result","","The type returned by formatter methods.",null,null],[3,"DebugTuple","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugMap","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugStruct","","A struct to help with `fmt::Debug` implementations.",null,null],[8,"LowerHex","","Format trait for the `x` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",84,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[0,"slice","std","A dynamically-sized view into a contiguous sequence, `[T]`.",null,null],[8,"SliceConcatExt","std::slice","An extension trait for concatenating slices",null,null],[16,"Output","","The resulting type after concatenation",85,null],[10,"concat","","Flattens a slice of `T` into a single value `Self::Output`.",85,null],[10,"join","","Flattens a slice of `T` into a single value `Self::Output`, placing a given separator between each.",85,null],[10,"connect","","",85,null],[3,"RSplitNMut","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits, starting from the end of the slice.",null,null],[3,"SplitMut","","An iterator over the subslices of the vector which are separated by elements that match `pred`.",null,null],[8,"SliceIndex","","A helper trait used for indexing operations.",null,null],[16,"Output","","The output type returned by methods.",86,null],[10,"get","","Returns a shared reference to the output at this location, if in bounds.",86,null],[10,"get_mut","","Returns a mutable reference to the output at this location, if in bounds.",86,null],[10,"get_unchecked","","Returns a shared reference to the output at this location, without performing any bounds checking.",86,null],[10,"get_unchecked_mut","","Returns a mutable reference to the output at this location, without performing any bounds checking.",86,null],[10,"index","","Returns a shared reference to the output at this location, panicking if out of bounds.",86,null],[10,"index_mut","","Returns a mutable reference to the output at this location, panicking if out of bounds.",86,null],[5,"from_raw_parts_mut","","Performs the same functionality as `from_raw_parts`, except that a mutable slice is returned.",null,null],[5,"from_raw_parts","","Forms a slice from a pointer and a length.",null,null],[3,"SplitN","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits.",null,null],[3,"ChunksMut","","An iterator over a slice in (non-overlapping) mutable chunks (`size` elements at a time). When the slice len is not evenly divided by the chunk size, the last slice of the iteration will be the remainder.",null,null],[3,"Windows","","An iterator over overlapping subslices of length `size`.",null,null],[3,"Split","","An iterator over subslices separated by elements that match a predicate function.",null,null],[3,"IterMut","","Mutable slice iterator.",null,null],[3,"SplitNMut","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits.",null,null],[3,"Chunks","","An iterator over a slice in (non-overlapping) chunks (`size` elements at a time).",null,null],[3,"Iter","","Immutable slice iterator",null,null],[3,"RSplitN","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits, starting from the end of the slice.",null,null],[0,"str","std","Unicode string slices.",null,null],[3,"EncodeUtf16","std::str","External iterator for a string's UTF-16 code units.",null,null],[3,"CharIndices","","Iterator for a string's characters and their byte offsets.",null,null],[3,"SplitWhitespace","","An iterator over the non-whitespace substrings of a string, separated by any amount of whitespace.",null,null],[3,"SplitN","","Created with the method [`splitn()`].",null,null],[3,"RSplit","","Created with the method [`rsplit()`].",null,null],[3,"RMatches","","Created with the method [`rmatches()`].",null,null],[3,"Chars","","Iterator for the char (representing *Unicode Scalar Values*) of a string",null,null],[5,"from_utf8","","Converts a slice of bytes to a string slice.",null,null],[3,"ParseBoolError","","An error returned when parsing a `bool` from a string fails.",null,null],[3,"LinesAny","","Created with the method [`lines_any()`].",null,null],[8,"FromStr","","A trait to abstract the idea of creating a new instance of a type from a string.",null,null],[16,"Err","","The associated error which can be returned from parsing.",87,null],[10,"from_str","","Parses a string `s` to return a value of this type.",87,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[3,"Matches","","Created with the method [`matches()`].",null,null],[3,"Lines","","Created with the method [`lines()`].",null,null],[3,"RSplitTerminator","","Created with the method [`rsplit_terminator()`].",null,null],[3,"Split","","Created with the method [`split()`].",null,null],[3,"RMatchIndices","","Created with the method [`rmatch_indices()`].",null,null],[5,"from_utf8_unchecked","","Converts a slice of bytes to a string slice without checking that the string contains valid UTF-8.",null,null],[3,"Bytes","","External iterator for a string's bytes. Use with the `std::iter` module.",null,null],[3,"Utf8Error","","Errors which can occur when attempting to interpret a sequence of `u8` as a string.",null,null],[3,"SplitTerminator","","Created with the method [`split_terminator()`].",null,null],[0,"pattern","","The string Pattern API.",null,null],[8,"Pattern","std::str::pattern","A string pattern.",null,null],[16,"Searcher","","Associated searcher for this pattern",88,null],[10,"into_searcher","","Constructs the associated searcher from `self` and the `haystack` to search in.",88,null],[11,"is_contained_in","","Checks whether the pattern matches anywhere in the haystack",88,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"is_prefix_of","","Checks whether the pattern matches at the front of the haystack",88,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"is_suffix_of","","Checks whether the pattern matches at the back of the haystack",88,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[4,"SearchStep","","Result of calling `Searcher::next()` or `ReverseSearcher::next_back()`.",null,null],[13,"Match","","Expresses that a match of the pattern has been found at `haystack[a..b]`.",89,null],[13,"Reject","","Expresses that `haystack[a..b]` has been rejected as a possible match of the pattern.",89,null],[13,"Done","","Expresses that every byte of the haystack has been visted, ending the iteration.",89,null],[8,"Searcher","","A searcher for a string pattern.",null,null],[10,"haystack","","Getter for the underlaying string to be searched in",90,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[10,"next","","Performs the next search step starting from the front.",90,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match","","Find the next `Match` result. See `next()`",90,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject","","Find the next `Reject` result. See `next()`",90,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[8,"ReverseSearcher","","A reverse searcher for a string pattern.",null,null],[10,"next_back","","Performs the next search step starting from the back.",91,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match_back","","Find the next `Match` result. See `next_back()`",91,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject_back","","Find the next `Reject` result. See `next_back()`",91,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[8,"DoubleEndedSearcher","","A marker trait to express that a `ReverseSearcher` can be used for a `DoubleEndedIterator` implementation.",null,null],[3,"CharSearcher","","Associated type for `<char as Pattern<'a>>::Searcher`.",null,null],[3,"CharSliceSearcher","","Associated type for `<&[char] as Pattern<'a>>::Searcher`.",null,null],[3,"CharPredicateSearcher","","Associated type for `<F as Pattern<'a>>::Searcher`.",null,null],[3,"StrSearcher","","Associated type for `<&str as Pattern<'a>>::Searcher`.",null,null],[3,"MatchIndices","std::str","Created with the method [`match_indices()`].",null,null],[3,"RSplitN","","Created with the method [`rsplitn()`].",null,null],[0,"string","std","A UTF-8 encoded, growable string.",null,null],[3,"String","std::string","A UTF-8 encoded, growable string.",null,null],[3,"FromUtf8Error","","A possible error value when converting a `String` from a UTF-8 byte vector.",null,null],[3,"FromUtf16Error","","A possible error value when converting a `String` from a UTF-16 byte slice.",null,null],[4,"ParseError","","An error when parsing a `String`.",null,null],[8,"ToString","","A trait for converting a value to a `String`.",null,null],[10,"to_string","","Converts the given value to a `String`.",92,{"inputs":[{"name":"self"}],"output":{"name":"string"}}],[3,"Drain","","A draining iterator for `String`.",null,null],[0,"vec","std","A contiguous growable array type with heap-allocated contents, written `Vec<T>` but pronounced 'vector.'",null,null],[3,"Vec","std::vec","A contiguous growable array type, written `Vec<T>` but pronounced 'vector'.",null,null],[3,"IntoIter","","An iterator that moves out of a vector.",null,null],[3,"Drain","","A draining iterator for `Vec<T>`.",null,null],[3,"PlaceBack","","A place for insertion at the back of a `Vec`.",null,null],[0,"char","std","A character type.",null,null],[3,"ToLowercase","std::char","Returns an iterator that yields the lowercase equivalent of a `char`.",null,null],[3,"ToUppercase","","Returns an iterator that yields the uppercase equivalent of a `char`.",null,null],[3,"DecodeUtf16","","An iterator that decodes UTF-16 encoded code points from an iterator of `u16`s.",null,null],[3,"DecodeUtf16Error","","An iterator that decodes UTF-16 encoded code points from an iterator of `u16`s.",null,null],[5,"decode_utf16","","Create an iterator over the UTF-16 encoded code points in `iter`, returning unpaired surrogates as `Err`s.",null,{"inputs":[{"name":"i"}],"output":{"name":"decodeutf16"}}],[17,"REPLACEMENT_CHARACTER","","`U+FFFD REPLACEMENT CHARACTER` (�) is used in Unicode to represent a decoding error.",null,null],[3,"CharTryFromError","","The error type returned when a conversion from u32 to char fails.",null,null],[3,"DecodeUtf8","","An iterator over an iterator of bytes of the characters the bytes represent as UTF-8",null,null],[3,"EscapeDefault","","An iterator that yields the literal escape code of a `char`.",null,null],[5,"from_digit","","Converts a digit in the given radix to a `char`.",null,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"option"}}],[17,"UNICODE_VERSION","","The version of Unicode that the unicode parts of `CharExt` and `UnicodeStrPrelude` traits are based on.",null,null],[17,"MAX","","The highest valid code point a `char` can have.",null,null],[5,"decode_utf8","","Decodes an `Iterator` of bytes as UTF-8.",null,{"inputs":[{"name":"i"}],"output":{"name":"decodeutf8"}}],[5,"from_u32_unchecked","","Converts a `u32` to a `char`, ignoring validity.",null,{"inputs":[{"name":"u32"}],"output":{"name":"char"}}],[3,"EscapeUnicode","","Returns an iterator that yields the hexadecimal Unicode escape of a character, as `char`s.",null,null],[3,"EscapeDebug","","An iterator that yields the literal escape code of a `char`.",null,null],[5,"from_u32","","Converts a `u32` to a `char`.",null,{"inputs":[{"name":"u32"}],"output":{"name":"option"}}],[0,"u128","std","The 128-bit unsigned integer type.",null,null],[17,"MIN","std::u128","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"prelude","std","The Rust Prelude.",null,null],[0,"v1","std::prelude","The first version of the prelude of The Rust Standard Library.",null,null],[0,"f32","std","The 32-bit floating point type.",null,null],[17,"RADIX","std::f32","The radix or base of the internal representation of `f32`.",null,null],[17,"MANTISSA_DIGITS","","Number of significant digits in base 2.",null,null],[17,"DIGITS","","Approximate number of significant digits in base 10.",null,null],[17,"EPSILON","","Difference between `1.0` and the next largest representable number.",null,null],[17,"MIN_EXP","","One greater than the minimum possible normal power of 2 exponent.",null,null],[17,"MAX_EXP","","Maximum possible power of 2 exponent.",null,null],[17,"MIN_10_EXP","","Minimum possible normal power of 10 exponent.",null,null],[17,"MAX_10_EXP","","Maximum possible power of 10 exponent.",null,null],[17,"NAN","","Not a Number (NaN).",null,null],[17,"INFINITY","","Infinity (∞).",null,null],[17,"NEG_INFINITY","","Negative infinity (-∞).",null,null],[17,"MIN","","Smallest finite `f32` value.",null,null],[17,"MIN_POSITIVE","","Smallest positive normal `f32` value.",null,null],[17,"MAX","","Largest finite `f32` value.",null,null],[0,"consts","","Basic mathematical constants.",null,null],[17,"PI","std::f32::consts","Archimedes' constant (π)",null,null],[17,"FRAC_PI_2","","π/2",null,null],[17,"FRAC_PI_3","","π/3",null,null],[17,"FRAC_PI_4","","π/4",null,null],[17,"FRAC_PI_6","","π/6",null,null],[17,"FRAC_PI_8","","π/8",null,null],[17,"FRAC_1_PI","","1/π",null,null],[17,"FRAC_2_PI","","2/π",null,null],[17,"FRAC_2_SQRT_PI","","2/sqrt(π)",null,null],[17,"SQRT_2","","sqrt(2)",null,null],[17,"FRAC_1_SQRT_2","","1/sqrt(2)",null,null],[17,"E","","Euler's number (e)",null,null],[17,"LOG2_E","","log<sub>2</sub>(e)",null,null],[17,"LOG10_E","","log<sub>10</sub>(e)",null,null],[17,"LN_2","","ln(2)",null,null],[17,"LN_10","","ln(10)",null,null],[0,"f64","std","The 64-bit floating point type.",null,null],[17,"RADIX","std::f64","The radix or base of the internal representation of `f64`.",null,null],[17,"MANTISSA_DIGITS","","Number of significant digits in base 2.",null,null],[17,"DIGITS","","Approximate number of significant digits in base 10.",null,null],[17,"EPSILON","","Difference between `1.0` and the next largest representable number.",null,null],[17,"MIN_EXP","","One greater than the minimum possible normal power of 2 exponent.",null,null],[17,"MAX_EXP","","Maximum possible power of 2 exponent.",null,null],[17,"MIN_10_EXP","","Minimum possible normal power of 10 exponent.",null,null],[17,"MAX_10_EXP","","Maximum possible power of 10 exponent.",null,null],[17,"NAN","","Not a Number (NaN).",null,null],[17,"INFINITY","","Infinity (∞).",null,null],[17,"NEG_INFINITY","","Negative infinity (-∞).",null,null],[17,"MIN","","Smallest finite `f64` value.",null,null],[17,"MIN_POSITIVE","","Smallest positive normal `f64` value.",null,null],[17,"MAX","","Largest finite `f64` value.",null,null],[0,"consts","","Basic mathematical constants.",null,null],[17,"PI","std::f64::consts","Archimedes' constant (π)",null,null],[17,"FRAC_PI_2","","π/2",null,null],[17,"FRAC_PI_3","","π/3",null,null],[17,"FRAC_PI_4","","π/4",null,null],[17,"FRAC_PI_6","","π/6",null,null],[17,"FRAC_PI_8","","π/8",null,null],[17,"FRAC_1_PI","","1/π",null,null],[17,"FRAC_2_PI","","2/π",null,null],[17,"FRAC_2_SQRT_PI","","2/sqrt(π)",null,null],[17,"SQRT_2","","sqrt(2)",null,null],[17,"FRAC_1_SQRT_2","","1/sqrt(2)",null,null],[17,"E","","Euler's number (e)",null,null],[17,"LOG2_E","","log<sub>2</sub>(e)",null,null],[17,"LOG10_E","","log<sub>10</sub>(e)",null,null],[17,"LN_2","","ln(2)",null,null],[17,"LN_10","","ln(10)",null,null],[0,"thread","std","Native threads.",null,null],[3,"LocalKey","std::thread","A thread local storage key which owns its contents.",null,null],[3,"Builder","","Thread configuration. Provides detailed control over the properties and behavior of new threads.",null,null],[3,"ThreadId","","A unique identifier for a running thread.",null,null],[3,"Thread","","A handle to a thread.",null,null],[3,"JoinHandle","","An owned permission to join on a thread (block on its termination).",null,null],[4,"LocalKeyState","","Indicator of the state of a thread local storage key.",null,null],[13,"Uninitialized","","All keys are in this state whenever a thread starts. Keys will transition to the `Valid` state once the first call to `with` happens and the initialization expression succeeds.",93,null],[13,"Valid","","Once a key has been accessed successfully, it will enter the `Valid` state. Keys in the `Valid` state will remain so until the thread exits, at which point the destructor will be run and the key will enter the `Destroyed` state.",93,null],[13,"Destroyed","","When a thread exits, the destructors for keys will be run (if necessary). While a destructor is running, and possibly after a destructor has run, a key is in the `Destroyed` state.",93,null],[5,"spawn","","Spawns a new thread, returning a [`JoinHandle`] for it.",null,{"inputs":[{"name":"f"}],"output":{"name":"joinhandle"}}],[5,"current","","Gets a handle to the thread that invokes it.",null,{"inputs":[],"output":{"name":"thread"}}],[5,"yield_now","","Cooperatively gives up a timeslice to the OS scheduler.",null,{"inputs":[],"output":null}],[5,"panicking","","Determines whether the current thread is unwinding because of panic.",null,{"inputs":[],"output":{"name":"bool"}}],[5,"sleep_ms","","Puts the current thread to sleep for the specified amount of time.",null,{"inputs":[{"name":"u32"}],"output":null}],[5,"sleep","","Puts the current thread to sleep for the specified amount of time.",null,{"inputs":[{"name":"duration"}],"output":null}],[5,"park","","Blocks unless or until the current thread's token is made available.",null,{"inputs":[],"output":null}],[5,"park_timeout_ms","","Use [park_timeout].",null,{"inputs":[{"name":"u32"}],"output":null}],[5,"park_timeout","","Blocks unless or until the current thread's token is made available or the specified duration has been reached (may wake spuriously).",null,{"inputs":[{"name":"duration"}],"output":null}],[11,"fmt","","",94,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",93,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",93,{"inputs":[{"name":"self"},{"name":"localkeystate"}],"output":{"name":"bool"}}],[11,"clone","","",93,{"inputs":[{"name":"self"}],"output":{"name":"localkeystate"}}],[11,"with","","Acquires a reference to the value in this TLS key.",94,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"r"}}],[11,"state","","Query the current state of this key.",94,{"inputs":[{"name":"self"}],"output":{"name":"localkeystate"}}],[6,"Result","","Indicates the manner in which a thread exited.",null,null],[11,"fmt","","",95,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Generates the base configuration for spawning a thread, from which configuration methods can be chained.",95,{"inputs":[],"output":{"name":"builder"}}],[11,"name","","Names the thread-to-be. Currently the name is used for identification only in panic messages.",95,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"builder"}}],[11,"stack_size","","Sets the size of the stack (in bytes) for the new thread.",95,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"builder"}}],[11,"spawn","","Spawns a new thread, and returns a join handle for it.",95,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"result"}}],[11,"eq","","",96,{"inputs":[{"name":"self"},{"name":"threadid"}],"output":{"name":"bool"}}],[11,"ne","","",96,{"inputs":[{"name":"self"},{"name":"threadid"}],"output":{"name":"bool"}}],[11,"clone","","",96,{"inputs":[{"name":"self"}],"output":{"name":"threadid"}}],[11,"fmt","","",96,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",97,{"inputs":[{"name":"self"}],"output":{"name":"thread"}}],[11,"unpark","","Atomically makes the handle's token available if it is not already.",97,{"inputs":[{"name":"self"}],"output":null}],[11,"id","","Gets the thread's unique identifier.",97,{"inputs":[{"name":"self"}],"output":{"name":"threadid"}}],[11,"name","","Gets the thread's name.",97,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",97,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"thread","","Extracts a handle to the underlying thread.",98,{"inputs":[{"name":"self"}],"output":{"name":"thread"}}],[11,"join","","Waits for the associated thread to finish.",98,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"fmt","","",98,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[0,"ascii","std","Operations on ASCII strings and characters.",null,null],[3,"EscapeDefault","std::ascii","An iterator over the escaped version of a byte, constructed via `std::ascii::escape_default`.",null,null],[5,"escape_default","","Returns an iterator that produces an escaped version of a `u8`.",null,{"inputs":[{"name":"u8"}],"output":{"name":"escapedefault"}}],[8,"AsciiExt","","Extension methods for ASCII-subset only operations on string slices.",null,null],[16,"Owned","","Container type for copied ASCII characters.",99,null],[10,"is_ascii","","Checks if the value is within the ASCII range.",99,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[10,"to_ascii_uppercase","","Makes a copy of the string in ASCII upper case.",99,null],[10,"to_ascii_lowercase","","Makes a copy of the string in ASCII lower case.",99,null],[10,"eq_ignore_ascii_case","","Checks that two strings are an ASCII case-insensitive match.",99,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"bool"}}],[10,"make_ascii_uppercase","","Converts this type to its ASCII upper case equivalent in-place.",99,{"inputs":[{"name":"self"}],"output":null}],[10,"make_ascii_lowercase","","Converts this type to its ASCII lower case equivalent in-place.",99,{"inputs":[{"name":"self"}],"output":null}],[11,"is_ascii_alphabetic","","Checks if the value is an ASCII alphabetic character: U+0041 'A' ... U+005A 'Z' or U+0061 'a' ... U+007A 'z'. For strings, true if all characters in the string are ASCII alphabetic.",99,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_ascii_uppercase","","Checks if the value is an ASCII uppercase character: U+0041 'A' ... U+005A 'Z'. For strings, true if all characters in the string are ASCII uppercase.",99,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_ascii_lowercase","","Checks if the value is an ASCII lowercase character: U+0061 'a' ... U+007A 'z'. For strings, true if all characters in the string are ASCII lowercase.",99,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_ascii_alphanumeric","","Checks if the value is an ASCII alphanumeric character: U+0041 'A' ... U+005A 'Z', U+0061 'a' ... U+007A 'z', or U+0030 '0' ... U+0039 '9'. For strings, true if all characters in the string are ASCII alphanumeric.",99,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_ascii_digit","","Checks if the value is an ASCII decimal digit: U+0030 '0' ... U+0039 '9'. For strings, true if all characters in the string are ASCII digits.",99,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_ascii_hexdigit","","Checks if the value is an ASCII hexadecimal digit: U+0030 '0' ... U+0039 '9', U+0041 'A' ... U+0046 'F', or U+0061 'a' ... U+0066 'f'. For strings, true if all characters in the string are ASCII hex digits.",99,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_ascii_punctuation","","Checks if the value is an ASCII punctuation character: U+0021 ... U+002F `! \" # $ % & ' ( ) * + , - . /` U+003A ... U+0040 `: ; < = > ? @` U+005B ... U+0060 `[ \\ ] ^ _ `` U+007B ... U+007E `{ | } ~` For strings, true if all characters in the string are ASCII punctuation.",99,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_ascii_graphic","","Checks if the value is an ASCII graphic character: U+0021 '@' ... U+007E '~'. For strings, true if all characters in the string are ASCII punctuation.",99,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_ascii_whitespace","","Checks if the value is an ASCII whitespace character: U+0020 SPACE, U+0009 HORIZONTAL TAB, U+000A LINE FEED, U+000C FORM FEED, or U+000D CARRIAGE RETURN. For strings, true if all characters in the string are ASCII whitespace.",99,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_ascii_control","","Checks if the value is an ASCII control character: U+0000 NUL ... U+001F UNIT SEPARATOR, or U+007F DELETE. Note that most ASCII whitespace characters are control characters, but SPACE is not.",99,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"next","","",100,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",100,null],[11,"next_back","","",100,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",100,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[0,"collections","std","Collection types.",null,null],[4,"Bound","std::collections","An endpoint of a range of keys.",null,null],[13,"Included","","An inclusive bound.",101,null],[13,"Excluded","","An exclusive bound.",101,null],[13,"Unbounded","","An infinite endpoint. Indicates that there is no bound in this direction.",101,null],[3,"BinaryHeap","","A priority queue implemented with a binary heap.",null,null],[3,"BTreeMap","","A map based on a B-Tree.",null,null],[3,"BTreeSet","","A set based on a B-Tree.",null,null],[3,"LinkedList","","A doubly-linked list with owned nodes.",null,null],[3,"VecDeque","","`VecDeque` is a growable ring buffer, which can be used as a double-ended queue efficiently.",null,null],[0,"binary_heap","","A priority queue implemented with a binary heap.",null,null],[3,"BinaryHeap","std::collections::binary_heap","A priority queue implemented with a binary heap.",null,null],[3,"PeekMut","","A container object that represents the result of the [`peek_mut()`] method on `BinaryHeap`. See its documentation for details.",null,null],[3,"Iter","","`BinaryHeap` iterator.",null,null],[3,"IntoIter","","An iterator that moves out of a `BinaryHeap`.",null,null],[3,"Drain","","An iterator that drains a `BinaryHeap`.",null,null],[3,"BinaryHeapPlace","","",null,null],[0,"btree_map","std::collections","A map based on a B-Tree.",null,null],[3,"Values","std::collections::btree_map","An iterator over a BTreeMap's values.",null,null],[3,"RangeMut","","A mutable iterator over a sub-range of BTreeMap's entries.",null,null],[3,"Range","","An iterator over a sub-range of BTreeMap's entries.",null,null],[3,"IterMut","","A mutable iterator over a BTreeMap's entries.",null,null],[4,"Entry","","A view into a single entry in a map, which may either be vacant or occupied. This enum is constructed from the [`entry`] method on [`BTreeMap`].",null,null],[13,"Vacant","","A vacant Entry",102,null],[13,"Occupied","","An occupied Entry",102,null],[3,"BTreeMap","","A map based on a B-Tree.",null,null],[3,"IntoIter","","An owning iterator over a BTreeMap's entries.",null,null],[3,"VacantEntry","","A vacant Entry. It is part of the [`Entry`] enum.",null,null],[3,"Iter","","An iterator over a BTreeMap's entries.",null,null],[3,"ValuesMut","","A mutable iterator over a BTreeMap's values.",null,null],[3,"Keys","","An iterator over a BTreeMap's keys.",null,null],[3,"OccupiedEntry","","An occupied Entry. It is part of the [`Entry`] enum.",null,null],[0,"btree_set","std::collections","A set based on a B-Tree.",null,null],[3,"Intersection","std::collections::btree_set","A lazy iterator producing elements in the set intersection (in-order).",null,null],[3,"Range","","An iterator over a sub-range of `BTreeSet`'s items.",null,null],[3,"Difference","","A lazy iterator producing elements in the set difference (in-order).",null,null],[3,"Union","","A lazy iterator producing elements in the set union (in-order).",null,null],[3,"IntoIter","","An owning iterator over a `BTreeSet`'s items.",null,null],[3,"Iter","","An iterator over a `BTreeSet`'s items.",null,null],[3,"BTreeSet","","A set based on a B-Tree.",null,null],[3,"SymmetricDifference","","A lazy iterator producing elements in the set symmetric difference (in-order).",null,null],[0,"linked_list","std::collections","A doubly-linked list with owned nodes.",null,null],[3,"LinkedList","std::collections::linked_list","A doubly-linked list with owned nodes.",null,null],[3,"Iter","","An iterator over references to the elements of a `LinkedList`.",null,null],[3,"IterMut","","An iterator over mutable references to the elements of a `LinkedList`.",null,null],[3,"IntoIter","","An iterator over the elements of a `LinkedList`.",null,null],[3,"FrontPlace","","A place for insertion at the front of a `LinkedList`.",null,null],[3,"BackPlace","","A place for insertion at the back of a `LinkedList`.",null,null],[0,"vec_deque","std::collections","VecDeque is a double-ended queue, which is implemented with the help of a growing ring buffer.",null,null],[3,"VecDeque","std::collections::vec_deque","`VecDeque` is a growable ring buffer, which can be used as a double-ended queue efficiently.",null,null],[3,"Iter","","`VecDeque` iterator.",null,null],[3,"IterMut","","`VecDeque` mutable iterator.",null,null],[3,"IntoIter","","A by-value VecDeque iterator",null,null],[3,"Drain","","A draining VecDeque iterator",null,null],[3,"PlaceBack","","A place for insertion at the back of a `VecDeque`.",null,null],[3,"PlaceFront","","A place for insertion at the front of a `VecDeque`.",null,null],[0,"range","std::collections","Range syntax.",null,null],[8,"RangeArgument","std::collections::range","**RangeArgument** is implemented by Rust's built-in range types, produced by range syntax like `..`, `a..`, `..b` or `c..d`.",null,null],[10,"start","","Start index bound",103,{"inputs":[{"name":"self"}],"output":{"name":"bound"}}],[10,"end","","End index bound",103,{"inputs":[{"name":"self"}],"output":{"name":"bound"}}],[3,"HashMap","std::collections","A hash map implementation which uses linear probing with Robin Hood bucket stealing.",null,null],[3,"HashSet","","An implementation of a hash set using the underlying representation of a HashMap where the value is ().",null,null],[11,"clone","","",104,{"inputs":[{"name":"self"}],"output":{"name":"hashmap"}}],[11,"new","","Creates an empty `HashMap`.",104,{"inputs":[],"output":{"name":"hashmap"}}],[11,"with_capacity","","Creates an empty `HashMap` with the specified capacity.",104,{"inputs":[{"name":"usize"}],"output":{"name":"hashmap"}}],[11,"with_hasher","","Creates an empty `HashMap` which will use the given hash builder to hash keys.",104,{"inputs":[{"name":"s"}],"output":{"name":"hashmap"}}],[11,"with_capacity_and_hasher","","Creates an empty `HashMap` with the specified capacity, using `hasher` to hash the keys.",104,{"inputs":[{"name":"usize"},{"name":"s"}],"output":{"name":"hashmap"}}],[11,"hasher","","Returns a reference to the map's hasher.",104,{"inputs":[{"name":"self"}],"output":{"name":"s"}}],[11,"capacity","","Returns the number of elements the map can hold without reallocating.",104,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"reserve","","Reserves capacity for at least `additional` more elements to be inserted in the `HashMap`. The collection may reserve more space to avoid frequent reallocations.",104,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shrink_to_fit","","Shrinks the capacity of the map as much as possible. It will drop down as much as possible while maintaining the internal rules and possibly leaving some space in accordance with the resize policy.",104,{"inputs":[{"name":"self"}],"output":null}],[11,"keys","","An iterator visiting all keys in arbitrary order. Iterator element type is `&'a K`.",104,{"inputs":[{"name":"self"}],"output":{"name":"keys"}}],[11,"values","","An iterator visiting all values in arbitrary order. Iterator element type is `&'a V`.",104,{"inputs":[{"name":"self"}],"output":{"name":"values"}}],[11,"values_mut","","An iterator visiting all values mutably in arbitrary order. Iterator element type is `&'a mut V`.",104,{"inputs":[{"name":"self"}],"output":{"name":"valuesmut"}}],[11,"iter","","An iterator visiting all key-value pairs in arbitrary order. Iterator element type is `(&'a K, &'a V)`.",104,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"iter_mut","","An iterator visiting all key-value pairs in arbitrary order, with mutable references to the values. Iterator element type is `(&'a K, &'a mut V)`.",104,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"entry","","Gets the given key's corresponding entry in the map for in-place manipulation.",104,{"inputs":[{"name":"self"},{"name":"k"}],"output":{"name":"entry"}}],[11,"len","","Returns the number of elements in the map.",104,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","Returns true if the map contains no elements.",104,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"drain","","Clears the map, returning all key-value pairs as an iterator. Keeps the allocated memory for reuse.",104,{"inputs":[{"name":"self"}],"output":{"name":"drain"}}],[11,"clear","","Clears the map, removing all key-value pairs. Keeps the allocated memory for reuse.",104,{"inputs":[{"name":"self"}],"output":null}],[11,"get","","Returns a reference to the value corresponding to the key.",104,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"option"}}],[11,"contains_key","","Returns true if the map contains a value for the specified key.",104,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"bool"}}],[11,"get_mut","","Returns a mutable reference to the value corresponding to the key.",104,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"option"}}],[11,"insert","","Inserts a key-value pair into the map.",104,{"inputs":[{"name":"self"},{"name":"k"},{"name":"v"}],"output":{"name":"option"}}],[11,"remove","","Removes a key from the map, returning the value at the key if the key was previously in the map.",104,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"option"}}],[11,"retain","","Retains only the elements specified by the predicate.",104,{"inputs":[{"name":"self"},{"name":"f"}],"output":null}],[11,"eq","","",104,{"inputs":[{"name":"self"},{"name":"hashmap"}],"output":{"name":"bool"}}],[11,"fmt","","",104,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"default","","Creates an empty `HashMap<K, V, S>`, with the `Default` value for the hasher.",104,{"inputs":[],"output":{"name":"hashmap"}}],[11,"index","","",104,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"v"}}],[11,"into_iter","","Creates a consuming iterator, that is, one that moves each key-value pair out of the map in arbitrary order. The map cannot be used after calling this.",104,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"from_iter","","",104,{"inputs":[{"name":"t"}],"output":{"name":"hashmap"}}],[11,"extend","","",104,{"inputs":[{"name":"self"},{"name":"t"}],"output":null}],[11,"extend","","",104,{"inputs":[{"name":"self"},{"name":"t"}],"output":null}],[11,"clone","","",105,{"inputs":[{"name":"self"}],"output":{"name":"hashset"}}],[11,"new","","Creates an empty HashSet.",105,{"inputs":[],"output":{"name":"hashset"}}],[11,"with_capacity","","Creates an empty `HashSet` with the specified capacity.",105,{"inputs":[{"name":"usize"}],"output":{"name":"hashset"}}],[11,"with_hasher","","Creates a new empty hash set which will use the given hasher to hash keys.",105,{"inputs":[{"name":"s"}],"output":{"name":"hashset"}}],[11,"with_capacity_and_hasher","","Creates an empty HashSet with with the specified capacity, using `hasher` to hash the keys.",105,{"inputs":[{"name":"usize"},{"name":"s"}],"output":{"name":"hashset"}}],[11,"hasher","","Returns a reference to the set's hasher.",105,{"inputs":[{"name":"self"}],"output":{"name":"s"}}],[11,"capacity","","Returns the number of elements the set can hold without reallocating.",105,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"reserve","","Reserves capacity for at least `additional` more elements to be inserted in the `HashSet`. The collection may reserve more space to avoid frequent reallocations.",105,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shrink_to_fit","","Shrinks the capacity of the set as much as possible. It will drop down as much as possible while maintaining the internal rules and possibly leaving some space in accordance with the resize policy.",105,{"inputs":[{"name":"self"}],"output":null}],[11,"iter","","An iterator visiting all elements in arbitrary order. Iterator element type is &'a T.",105,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"difference","","Visit the values representing the difference, i.e. the values that are in `self` but not in `other`.",105,{"inputs":[{"name":"self"},{"name":"hashset"}],"output":{"name":"difference"}}],[11,"symmetric_difference","","Visit the values representing the symmetric difference, i.e. the values that are in `self` or in `other` but not in both.",105,{"inputs":[{"name":"self"},{"name":"hashset"}],"output":{"name":"symmetricdifference"}}],[11,"intersection","","Visit the values representing the intersection, i.e. the values that are both in `self` and `other`.",105,{"inputs":[{"name":"self"},{"name":"hashset"}],"output":{"name":"intersection"}}],[11,"union","","Visit the values representing the union, i.e. all the values in `self` or `other`, without duplicates.",105,{"inputs":[{"name":"self"},{"name":"hashset"}],"output":{"name":"union"}}],[11,"len","","Returns the number of elements in the set.",105,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","Returns true if the set contains no elements.",105,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"drain","","Clears the set, returning all elements in an iterator.",105,{"inputs":[{"name":"self"}],"output":{"name":"drain"}}],[11,"clear","","Clears the set, removing all values.",105,{"inputs":[{"name":"self"}],"output":null}],[11,"contains","","Returns `true` if the set contains a value.",105,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"bool"}}],[11,"get","","Returns a reference to the value in the set, if any, that is equal to the given value.",105,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"option"}}],[11,"is_disjoint","","Returns `true` if `self` has no elements in common with `other`. This is equivalent to checking for an empty intersection.",105,{"inputs":[{"name":"self"},{"name":"hashset"}],"output":{"name":"bool"}}],[11,"is_subset","","Returns `true` if the set is a subset of another, i.e. `other` contains at least all the values in `self`.",105,{"inputs":[{"name":"self"},{"name":"hashset"}],"output":{"name":"bool"}}],[11,"is_superset","","Returns `true` if the set is a superset of another, i.e. `self` contains at least all the values in `other`.",105,{"inputs":[{"name":"self"},{"name":"hashset"}],"output":{"name":"bool"}}],[11,"insert","","Adds a value to the set.",105,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"bool"}}],[11,"replace","","Adds a value to the set, replacing the existing value, if any, that is equal to the given one. Returns the replaced value.",105,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"option"}}],[11,"remove","","Removes a value from the set. Returns `true` if the value was present in the set.",105,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"bool"}}],[11,"take","","Removes and returns the value in the set, if any, that is equal to the given one.",105,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"option"}}],[11,"retain","","Retains only the elements specified by the predicate.",105,{"inputs":[{"name":"self"},{"name":"f"}],"output":null}],[11,"eq","","",105,{"inputs":[{"name":"self"},{"name":"hashset"}],"output":{"name":"bool"}}],[11,"fmt","","",105,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"from_iter","","",105,{"inputs":[{"name":"i"}],"output":{"name":"hashset"}}],[11,"extend","","",105,{"inputs":[{"name":"self"},{"name":"i"}],"output":null}],[11,"extend","","",105,{"inputs":[{"name":"self"},{"name":"i"}],"output":null}],[11,"default","","Creates an empty `HashSet<T, S>` with the `Default` value for the hasher.",105,{"inputs":[],"output":{"name":"hashset"}}],[11,"into_iter","","Creates a consuming iterator, that is, one that moves each value out of the set in arbitrary order. The set cannot be used after calling this.",105,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[0,"hash_map","","A hash map implementation which uses linear probing with Robin Hood bucket stealing.",null,null],[3,"HashMap","std::collections::hash_map","A hash map implementation which uses linear probing with Robin Hood bucket stealing.",null,null],[3,"Iter","","HashMap iterator.",null,null],[3,"IterMut","","HashMap mutable values iterator.",null,null],[3,"IntoIter","","HashMap move iterator.",null,null],[3,"Keys","","HashMap keys iterator.",null,null],[3,"Values","","HashMap values iterator.",null,null],[3,"Drain","","HashMap drain iterator.",null,null],[3,"ValuesMut","","Mutable HashMap values iterator.",null,null],[3,"OccupiedEntry","","A view into a single occupied location in a HashMap. It is part of the [`Entry`] enum.",null,null],[3,"VacantEntry","","A view into a single empty location in a HashMap. It is part of the [`Entry`] enum.",null,null],[3,"EntryPlace","","A place for insertion to a `Entry`.",null,null],[3,"RandomState","","`RandomState` is the default state for [`HashMap`] types.",null,null],[3,"DefaultHasher","","The default [`Hasher`] used by [`RandomState`].",null,null],[4,"Entry","","A view into a single location in a map, which may be vacant or occupied. This enum is constructed from the [`entry`] method on [`HashMap`].",null,null],[13,"Occupied","","An occupied Entry.",106,null],[13,"Vacant","","A vacant Entry.",106,null],[0,"hash_set","std::collections","An implementation of a hash set using the underlying representation of a HashMap where the value is ().",null,null],[3,"HashSet","std::collections::hash_set","An implementation of a hash set using the underlying representation of a HashMap where the value is ().",null,null],[3,"Iter","","HashSet iterator",null,null],[3,"IntoIter","","HashSet move iterator",null,null],[3,"Drain","","HashSet drain iterator",null,null],[3,"Intersection","","Intersection iterator",null,null],[3,"Difference","","Difference iterator",null,null],[3,"SymmetricDifference","","Symmetric difference iterator.",null,null],[3,"Union","","Set union iterator.",null,null],[0,"env","std","Inspection and manipulation of the process's environment.",null,null],[3,"Vars","std::env","An iterator over a snapshot of the environment variables of this process.",null,null],[3,"VarsOs","","An iterator over a snapshot of the environment variables of this process.",null,null],[3,"SplitPaths","","An iterator over `PathBuf` instances for parsing an environment variable according to platform-specific conventions.",null,null],[3,"JoinPathsError","","Error type returned from `std::env::join_paths` when paths fail to be joined.",null,null],[3,"Args","","An iterator over the arguments of a process, yielding a [`String`] value for each argument.",null,null],[3,"ArgsOs","","An iterator over the arguments of a process, yielding an [`OsString`] value for each argument.",null,null],[4,"VarError","","Possible errors from the [`env::var`] function.",null,null],[13,"NotPresent","","The specified environment variable was not present in the current process's environment.",107,null],[13,"NotUnicode","","The specified environment variable was found, but it did not contain valid unicode data. The found data is returned as a payload of this variant.",107,null],[5,"current_dir","","Returns the current working directory as a [`PathBuf`].",null,{"inputs":[],"output":{"name":"result"}}],[5,"set_current_dir","","Changes the current working directory to the specified path, returning whether the change was completed successfully or not.",null,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[5,"vars","","Returns an iterator of (variable, value) pairs of strings, for all the environment variables of the current process.",null,{"inputs":[],"output":{"name":"vars"}}],[5,"vars_os","","Returns an iterator of (variable, value) pairs of OS strings, for all the environment variables of the current process.",null,{"inputs":[],"output":{"name":"varsos"}}],[5,"var","","Fetches the environment variable `key` from the current process.",null,{"inputs":[{"name":"k"}],"output":{"name":"result"}}],[5,"var_os","","Fetches the environment variable `key` from the current process, returning [`None`] if the variable isn't set.",null,{"inputs":[{"name":"k"}],"output":{"name":"option"}}],[5,"set_var","","Sets the environment variable `k` to the value `v` for the currently running process.",null,{"inputs":[{"name":"k"},{"name":"v"}],"output":null}],[5,"remove_var","","Removes an environment variable from the environment of the currently running process.",null,{"inputs":[{"name":"k"}],"output":null}],[5,"split_paths","","Parses input according to platform conventions for the `PATH` environment variable.",null,{"inputs":[{"name":"t"}],"output":{"name":"splitpaths"}}],[5,"join_paths","","Joins a collection of [`Path`]s appropriately for the `PATH` environment variable.",null,{"inputs":[{"name":"i"}],"output":{"name":"result"}}],[5,"home_dir","","Returns the path of the current user's home directory if known.",null,{"inputs":[],"output":{"name":"option"}}],[5,"temp_dir","","Returns the path of a temporary directory.",null,{"inputs":[],"output":{"name":"pathbuf"}}],[5,"current_exe","","Returns the full filesystem path of the current running executable.",null,{"inputs":[],"output":{"name":"result"}}],[5,"args","","Returns the arguments which this program was started with (normally passed via the command line).",null,{"inputs":[],"output":{"name":"args"}}],[5,"args_os","","Returns the arguments which this program was started with (normally passed via the command line).",null,{"inputs":[],"output":{"name":"argsos"}}],[0,"consts","","Constants associated with the current target",null,null],[17,"ARCH","std::env::consts","A string describing the architecture of the CPU that is currently in use.",null,null],[17,"FAMILY","","The family of the operating system. Example value is `unix`.",null,null],[17,"OS","","A string describing the specific operating system in use. Example value is `linux`.",null,null],[17,"DLL_PREFIX","","Specifies the filename prefix used for shared libraries on this platform. Example value is `lib`.",null,null],[17,"DLL_SUFFIX","","Specifies the filename suffix used for shared libraries on this platform. Example value is `.so`.",null,null],[17,"DLL_EXTENSION","","Specifies the file extension used for shared libraries on this platform that goes after the dot. Example value is `so`.",null,null],[17,"EXE_SUFFIX","","Specifies the filename suffix used for executable binaries on this platform. Example value is `.exe`.",null,null],[17,"EXE_EXTENSION","","Specifies the file extension, if any, used for executable binaries on this platform. Example value is `exe`.",null,null],[11,"next","std::env","",108,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",108,null],[11,"fmt","","",108,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",109,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",109,null],[11,"fmt","","",109,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",107,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",107,{"inputs":[{"name":"self"},{"name":"varerror"}],"output":{"name":"bool"}}],[11,"ne","","",107,{"inputs":[{"name":"self"},{"name":"varerror"}],"output":{"name":"bool"}}],[11,"clone","","",107,{"inputs":[{"name":"self"}],"output":{"name":"varerror"}}],[11,"fmt","","",107,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"description","","",107,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"next","","",110,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",110,null],[11,"fmt","","",110,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",111,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",111,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"description","","",111,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"next","","",112,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",112,null],[11,"len","","",112,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","",112,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"next_back","","",112,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",112,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",113,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",113,null],[11,"len","","",113,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","",113,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"next_back","","",113,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",113,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[0,"error","std","Traits for working with Errors.",null,null],[8,"Error","std::error","Base functionality for all errors in Rust.",null,null],[10,"description","","A short description of the error.",114,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"cause","","The lower-level cause of this error, if any.",114,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"from","std::boxed","",115,{"inputs":[{"name":"e"}],"output":{"name":"box"}}],[11,"from","","",115,{"inputs":[{"name":"e"}],"output":{"name":"box"}}],[11,"from","","",115,{"inputs":[{"name":"string"}],"output":{"name":"box"}}],[11,"from","","",115,{"inputs":[{"name":"string"}],"output":{"name":"box"}}],[11,"from","","",115,{"inputs":[{"name":"str"}],"output":{"name":"box"}}],[11,"from","","",115,{"inputs":[{"name":"str"}],"output":{"name":"box"}}],[11,"description","std::str","",116,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"description","","",117,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"description","std::string","",118,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"description","","",119,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"description","","",120,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"description","std::char","",121,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"description","std::boxed","",115,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"cause","","",115,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"description","std::fmt","",122,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"description","std::cell","",123,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"description","","",124,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"description","std::char","",125,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"is","std::error","Returns true if the boxed type is the same as `T`",114,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"downcast_ref","","Returns some reference to the boxed value if it is of type `T`, or `None` if it isn't.",114,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"downcast_mut","","Returns some mutable reference to the boxed value if it is of type `T`, or `None` if it isn't.",114,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"is","","Forwards to the method defined on the type `Any`.",114,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"downcast_ref","","Forwards to the method defined on the type `Any`.",114,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"downcast_mut","","Forwards to the method defined on the type `Any`.",114,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"is","","Forwards to the method defined on the type `Any`.",114,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"downcast_ref","","Forwards to the method defined on the type `Any`.",114,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"downcast_mut","","Forwards to the method defined on the type `Any`.",114,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"downcast","","Attempt to downcast the box to a concrete type.",114,{"inputs":[{"name":"box"}],"output":{"name":"result"}}],[11,"downcast","","Attempt to downcast the box to a concrete type.",114,{"inputs":[{"name":"box"}],"output":{"name":"result"}}],[11,"downcast","","Attempt to downcast the box to a concrete type.",114,{"inputs":[{"name":"box"}],"output":{"name":"result"}}],[0,"ffi","std","Utilities related to FFI bindings.",null,null],[3,"CString","std::ffi","A type representing an owned C-compatible string",null,null],[3,"CStr","","Representation of a borrowed C string.",null,null],[3,"NulError","","An error returned from `CString::new` to indicate that a nul byte was found in the vector provided.",null,null],[3,"IntoStringError","","An error returned from `CString::into_string` to indicate that a UTF-8 error was encountered during the conversion.",null,null],[3,"FromBytesWithNulError","","An error returned from `CStr::from_bytes_with_nul` to indicate that a nul byte was found too early in the slice provided or one wasn't found at all.",null,null],[3,"OsString","","A type that can represent owned, mutable platform-native strings, but is cheaply inter-convertible with Rust strings.",null,null],[3,"OsStr","","Slices into OS strings (see [`OsString`]).",null,null],[11,"eq","","",126,{"inputs":[{"name":"self"},{"name":"cstring"}],"output":{"name":"bool"}}],[11,"ne","","",126,{"inputs":[{"name":"self"},{"name":"cstring"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",126,{"inputs":[{"name":"self"},{"name":"cstring"}],"output":{"name":"option"}}],[11,"lt","","",126,{"inputs":[{"name":"self"},{"name":"cstring"}],"output":{"name":"bool"}}],[11,"le","","",126,{"inputs":[{"name":"self"},{"name":"cstring"}],"output":{"name":"bool"}}],[11,"gt","","",126,{"inputs":[{"name":"self"},{"name":"cstring"}],"output":{"name":"bool"}}],[11,"ge","","",126,{"inputs":[{"name":"self"},{"name":"cstring"}],"output":{"name":"bool"}}],[11,"cmp","","",126,{"inputs":[{"name":"self"},{"name":"cstring"}],"output":{"name":"ordering"}}],[11,"hash","","",126,null],[11,"clone","","",126,{"inputs":[{"name":"self"}],"output":{"name":"cstring"}}],[11,"hash","","",127,null],[11,"clone","","",128,{"inputs":[{"name":"self"}],"output":{"name":"nulerror"}}],[11,"eq","","",128,{"inputs":[{"name":"self"},{"name":"nulerror"}],"output":{"name":"bool"}}],[11,"ne","","",128,{"inputs":[{"name":"self"},{"name":"nulerror"}],"output":{"name":"bool"}}],[11,"fmt","","",128,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",129,{"inputs":[{"name":"self"}],"output":{"name":"frombyteswithnulerror"}}],[11,"eq","","",129,{"inputs":[{"name":"self"},{"name":"frombyteswithnulerror"}],"output":{"name":"bool"}}],[11,"ne","","",129,{"inputs":[{"name":"self"},{"name":"frombyteswithnulerror"}],"output":{"name":"bool"}}],[11,"fmt","","",129,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",130,{"inputs":[{"name":"self"}],"output":{"name":"intostringerror"}}],[11,"eq","","",130,{"inputs":[{"name":"self"},{"name":"intostringerror"}],"output":{"name":"bool"}}],[11,"ne","","",130,{"inputs":[{"name":"self"},{"name":"intostringerror"}],"output":{"name":"bool"}}],[11,"fmt","","",130,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new C-compatible string from a container of bytes.",126,{"inputs":[{"name":"t"}],"output":{"name":"result"}}],[11,"from_vec_unchecked","","Creates a C-compatible string from a byte vector without checking for interior 0 bytes.",126,{"inputs":[{"name":"vec"}],"output":{"name":"cstring"}}],[11,"from_raw","","Retakes ownership of a `CString` that was transferred to C.",126,null],[11,"into_raw","","Transfers ownership of the string to a C caller.",126,null],[11,"into_string","","Converts the `CString` into a `String` if it contains valid Unicode data.",126,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"into_bytes","","Returns the underlying byte buffer.",126,{"inputs":[{"name":"self"}],"output":{"name":"vec"}}],[11,"into_bytes_with_nul","","Equivalent to the `into_bytes` function except that the returned vector includes the trailing nul byte.",126,{"inputs":[{"name":"self"}],"output":{"name":"vec"}}],[11,"as_bytes","","Returns the contents of this `CString` as a slice of bytes.",126,null],[11,"as_bytes_with_nul","","Equivalent to the `as_bytes` function except that the returned slice includes the trailing nul byte.",126,null],[11,"into_boxed_c_str","","Converts this `CString` into a boxed `CStr`.",126,{"inputs":[{"name":"self"}],"output":{"name":"box"}}],[11,"drop","","",126,{"inputs":[{"name":"self"}],"output":null}],[11,"deref","","",126,{"inputs":[{"name":"self"}],"output":{"name":"cstr"}}],[11,"fmt","","",126,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"from","std::vec","",131,{"inputs":[{"name":"cstring"}],"output":{"name":"vec"}}],[11,"fmt","std::ffi","",127,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"default","","Creates an empty `CString`.",126,{"inputs":[],"output":{"name":"cstring"}}],[11,"borrow","","",126,{"inputs":[{"name":"self"}],"output":{"name":"cstr"}}],[11,"from","std::boxed","",115,{"inputs":[{"name":"cstr"}],"output":{"name":"box"}}],[11,"default","","",115,{"inputs":[],"output":{"name":"box"}}],[11,"nul_position","std::ffi","Returns the position of the nul byte in the slice that was provided to `CString::new`.",128,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"into_vec","","Consumes this error, returning the underlying vector of bytes which generated the error in the first place.",128,{"inputs":[{"name":"self"}],"output":{"name":"vec"}}],[11,"description","","",128,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"fmt","","",128,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"description","","",129,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"fmt","","",129,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"into_cstring","","Consumes this error, returning original `CString` which generated the error.",130,{"inputs":[{"name":"self"}],"output":{"name":"cstring"}}],[11,"utf8_error","","Access the underlying UTF-8 error that was the cause of this error.",130,{"inputs":[{"name":"self"}],"output":{"name":"utf8error"}}],[11,"description","","",130,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"cause","","",130,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",130,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"from_ptr","","Casts a raw C string to a safe C string wrapper.",127,null],[11,"from_bytes_with_nul","","Creates a C string wrapper from a byte slice.",127,null],[11,"from_bytes_with_nul_unchecked","","Unsafely creates a C string wrapper from a byte slice.",127,null],[11,"as_ptr","","Returns the inner pointer to this C string.",127,null],[11,"to_bytes","","Converts this C string to a byte slice.",127,null],[11,"to_bytes_with_nul","","Converts this C string to a byte slice containing the trailing 0 byte.",127,null],[11,"to_str","","Yields a `&str` slice if the `CStr` contains valid UTF-8.",127,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"to_string_lossy","","Converts a `CStr` into a `Cow<str>`.",127,{"inputs":[{"name":"self"}],"output":{"name":"cow"}}],[11,"eq","","",127,{"inputs":[{"name":"self"},{"name":"cstr"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",127,{"inputs":[{"name":"self"},{"name":"cstr"}],"output":{"name":"option"}}],[11,"cmp","","",127,{"inputs":[{"name":"self"},{"name":"cstr"}],"output":{"name":"ordering"}}],[11,"to_owned","","",127,{"inputs":[{"name":"self"}],"output":{"name":"cstring"}}],[11,"from","","",126,{"inputs":[{"name":"cstr"}],"output":{"name":"cstring"}}],[11,"index","","",126,{"inputs":[{"name":"self"},{"name":"rangefull"}],"output":{"name":"cstr"}}],[11,"as_ref","","",127,{"inputs":[{"name":"self"}],"output":{"name":"cstr"}}],[11,"as_ref","","",126,{"inputs":[{"name":"self"}],"output":{"name":"cstr"}}],[11,"clone","","",132,{"inputs":[{"name":"self"}],"output":{"name":"osstring"}}],[11,"new","","Constructs a new empty `OsString`.",132,{"inputs":[],"output":{"name":"osstring"}}],[11,"as_os_str","","Converts to an [`OsStr`] slice.",132,{"inputs":[{"name":"self"}],"output":{"name":"osstr"}}],[11,"into_string","","Converts the `OsString` into a [`String`] if it contains valid Unicode data.",132,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"push","","Extends the string with the given [`&OsStr`] slice.",132,{"inputs":[{"name":"self"},{"name":"t"}],"output":null}],[11,"with_capacity","","Creates a new `OsString` with the given capacity.",132,{"inputs":[{"name":"usize"}],"output":{"name":"osstring"}}],[11,"clear","","Truncates the `OsString` to zero length.",132,{"inputs":[{"name":"self"}],"output":null}],[11,"capacity","","Returns the capacity this `OsString` can hold without reallocating.",132,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"reserve","","Reserves capacity for at least `additional` more capacity to be inserted in the given `OsString`.",132,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"reserve_exact","","Reserves the minimum capacity for exactly `additional` more capacity to be inserted in the given `OsString`. Does nothing if the capacity is already sufficient.",132,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"shrink_to_fit","","Shrinks the capacity of the `OsString` to match its length.",132,{"inputs":[{"name":"self"}],"output":null}],[11,"into_boxed_os_str","","Converts this `OsString` into a boxed `OsStr`.",132,{"inputs":[{"name":"self"}],"output":{"name":"box"}}],[11,"from","","",132,{"inputs":[{"name":"string"}],"output":{"name":"osstring"}}],[11,"from","","",132,{"inputs":[{"name":"t"}],"output":{"name":"osstring"}}],[11,"index","","",132,{"inputs":[{"name":"self"},{"name":"rangefull"}],"output":{"name":"osstr"}}],[11,"deref","","",132,{"inputs":[{"name":"self"}],"output":{"name":"osstr"}}],[11,"default","","Constructs an empty `OsString`.",132,{"inputs":[],"output":{"name":"osstring"}}],[11,"fmt","","",132,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",132,{"inputs":[{"name":"self"},{"name":"osstring"}],"output":{"name":"bool"}}],[11,"eq","","",132,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",132,{"inputs":[{"name":"self"},{"name":"osstring"}],"output":{"name":"option"}}],[11,"lt","","",132,{"inputs":[{"name":"self"},{"name":"osstring"}],"output":{"name":"bool"}}],[11,"le","","",132,{"inputs":[{"name":"self"},{"name":"osstring"}],"output":{"name":"bool"}}],[11,"gt","","",132,{"inputs":[{"name":"self"},{"name":"osstring"}],"output":{"name":"bool"}}],[11,"ge","","",132,{"inputs":[{"name":"self"},{"name":"osstring"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",132,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"option"}}],[11,"cmp","","",132,{"inputs":[{"name":"self"},{"name":"osstring"}],"output":{"name":"ordering"}}],[11,"hash","","",132,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"new","","Coerces into an `OsStr` slice.",133,{"inputs":[{"name":"s"}],"output":{"name":"osstr"}}],[11,"to_str","","Yields a [`&str`] slice if the `OsStr` is valid Unicode.",133,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"to_string_lossy","","Converts an `OsStr` to a [`Cow`]`<`[`str`]`>`.",133,{"inputs":[{"name":"self"}],"output":{"name":"cow"}}],[11,"to_os_string","","Copies the slice into an owned [`OsString`].",133,{"inputs":[{"name":"self"}],"output":{"name":"osstring"}}],[11,"is_empty","","Checks whether the `OsStr` is empty.",133,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"len","","Returns the length of this `OsStr`.",133,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"from","std::boxed","",115,{"inputs":[{"name":"osstr"}],"output":{"name":"box"}}],[11,"default","","",115,{"inputs":[],"output":{"name":"box"}}],[11,"eq","std::ffi","",133,{"inputs":[{"name":"self"},{"name":"osstr"}],"output":{"name":"bool"}}],[11,"eq","","",133,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",133,{"inputs":[{"name":"self"},{"name":"osstr"}],"output":{"name":"option"}}],[11,"lt","","",133,{"inputs":[{"name":"self"},{"name":"osstr"}],"output":{"name":"bool"}}],[11,"le","","",133,{"inputs":[{"name":"self"},{"name":"osstr"}],"output":{"name":"bool"}}],[11,"gt","","",133,{"inputs":[{"name":"self"},{"name":"osstr"}],"output":{"name":"bool"}}],[11,"ge","","",133,{"inputs":[{"name":"self"},{"name":"osstr"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",133,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"option"}}],[11,"cmp","","",133,{"inputs":[{"name":"self"},{"name":"osstr"}],"output":{"name":"ordering"}}],[11,"eq","","",132,{"inputs":[{"name":"self"},{"name":"osstr"}],"output":{"name":"bool"}}],[11,"eq","","",133,{"inputs":[{"name":"self"},{"name":"osstring"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",132,{"inputs":[{"name":"self"},{"name":"osstr"}],"output":{"name":"option"}}],[11,"partial_cmp","","",133,{"inputs":[{"name":"self"},{"name":"osstring"}],"output":{"name":"option"}}],[11,"eq","","",132,{"inputs":[{"name":"self"},{"name":"osstr"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",132,{"inputs":[{"name":"self"},{"name":"osstr"}],"output":{"name":"option"}}],[11,"eq","std::borrow","",72,{"inputs":[{"name":"self"},{"name":"osstr"}],"output":{"name":"bool"}}],[11,"eq","std::ffi","",133,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"bool"}}],[11,"partial_cmp","std::borrow","",72,{"inputs":[{"name":"self"},{"name":"osstr"}],"output":{"name":"option"}}],[11,"partial_cmp","std::ffi","",133,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"option"}}],[11,"eq","std::borrow","",72,{"inputs":[{"name":"self"},{"name":"osstr"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",72,{"inputs":[{"name":"self"},{"name":"osstr"}],"output":{"name":"option"}}],[11,"eq","","",72,{"inputs":[{"name":"self"},{"name":"osstring"}],"output":{"name":"bool"}}],[11,"eq","std::ffi","",132,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"bool"}}],[11,"partial_cmp","std::borrow","",72,{"inputs":[{"name":"self"},{"name":"osstring"}],"output":{"name":"option"}}],[11,"partial_cmp","std::ffi","",132,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"option"}}],[11,"hash","","",133,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"fmt","","",133,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"borrow","","",132,{"inputs":[{"name":"self"}],"output":{"name":"osstr"}}],[11,"to_owned","","",133,{"inputs":[{"name":"self"}],"output":{"name":"osstring"}}],[11,"as_ref","","",133,{"inputs":[{"name":"self"}],"output":{"name":"osstr"}}],[11,"as_ref","","",132,{"inputs":[{"name":"self"}],"output":{"name":"osstr"}}],[11,"as_ref","std::string","",134,{"inputs":[{"name":"self"}],"output":{"name":"osstr"}}],[0,"fs","std","Filesystem manipulation operations.",null,null],[3,"File","std::fs","A reference to an open file on the filesystem.",null,null],[3,"Metadata","","Metadata information about a file.",null,null],[3,"ReadDir","","Iterator over the entries in a directory.",null,null],[3,"DirEntry","","Entries returned by the [`ReadDir`] iterator.",null,null],[3,"OpenOptions","","Options and flags which can be used to configure how a file is opened.",null,null],[3,"Permissions","","Representation of the various permissions on a file.",null,null],[3,"FileType","","A structure representing a type of file with accessors for each file type. It is returned by [`Metadata::file_type`] method.",null,null],[3,"DirBuilder","","A builder used to create directories in various manners.",null,null],[5,"remove_file","","Removes a file from the filesystem.",null,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[5,"metadata","","Given a path, query the file system to get information about a file, directory, etc.",null,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[5,"symlink_metadata","","Query the metadata about a file without following symlinks.",null,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[5,"rename","","Rename a file or directory to a new name, replacing the original file if `to` already exists.",null,{"inputs":[{"name":"p"},{"name":"q"}],"output":{"name":"result"}}],[5,"copy","","Copies the contents of one file to another. This function will also copy the permission bits of the original file to the destination file.",null,{"inputs":[{"name":"p"},{"name":"q"}],"output":{"name":"result"}}],[5,"hard_link","","Creates a new hard link on the filesystem.",null,{"inputs":[{"name":"p"},{"name":"q"}],"output":{"name":"result"}}],[5,"soft_link","","Creates a new symbolic link on the filesystem.",null,{"inputs":[{"name":"p"},{"name":"q"}],"output":{"name":"result"}}],[5,"read_link","","Reads a symbolic link, returning the file that the link points to.",null,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[5,"canonicalize","","Returns the canonical form of a path with all intermediate components normalized and symbolic links resolved.",null,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[5,"create_dir","","Creates a new, empty directory at the provided path",null,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[5,"create_dir_all","","Recursively create a directory and all of its parent components if they are missing.",null,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[5,"remove_dir","","Removes an existing, empty directory.",null,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[5,"remove_dir_all","","Removes a directory at this path, after removing all its contents. Use carefully!",null,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[5,"read_dir","","Returns an iterator over the entries within a directory.",null,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[5,"set_permissions","","Changes the permissions found on a file or a directory.",null,{"inputs":[{"name":"p"},{"name":"permissions"}],"output":{"name":"result"}}],[11,"clone","","",135,{"inputs":[{"name":"self"}],"output":{"name":"metadata"}}],[11,"fmt","","",136,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",137,{"inputs":[{"name":"self"}],"output":{"name":"openoptions"}}],[11,"fmt","","",137,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",138,{"inputs":[{"name":"self"}],"output":{"name":"permissions"}}],[11,"eq","","",138,{"inputs":[{"name":"self"},{"name":"permissions"}],"output":{"name":"bool"}}],[11,"ne","","",138,{"inputs":[{"name":"self"},{"name":"permissions"}],"output":{"name":"bool"}}],[11,"fmt","","",138,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",139,{"inputs":[{"name":"self"}],"output":{"name":"filetype"}}],[11,"eq","","",139,{"inputs":[{"name":"self"},{"name":"filetype"}],"output":{"name":"bool"}}],[11,"ne","","",139,{"inputs":[{"name":"self"},{"name":"filetype"}],"output":{"name":"bool"}}],[11,"hash","","",139,null],[11,"fmt","","",139,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",140,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"open","","Attempts to open a file in read-only mode.",141,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[11,"create","","Opens a file in write-only mode.",141,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[11,"sync_all","","Attempts to sync all OS-internal metadata to disk.",141,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"sync_data","","This function is similar to [`sync_all`], except that it may not synchronize file metadata to the filesystem.",141,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"set_len","","Truncates or extends the underlying file, updating the size of this file to become `size`.",141,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"result"}}],[11,"metadata","","Queries metadata about the underlying file.",141,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"try_clone","","Creates a new independently owned handle to the underlying file.",141,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"set_permissions","","Changes the permissions on the underlying file.",141,{"inputs":[{"name":"self"},{"name":"permissions"}],"output":{"name":"result"}}],[11,"fmt","","",141,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"read","","",141,null],[11,"read_to_end","","",141,{"inputs":[{"name":"self"},{"name":"vec"}],"output":{"name":"result"}}],[11,"write","","",141,null],[11,"flush","","",141,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"seek","","",141,{"inputs":[{"name":"self"},{"name":"seekfrom"}],"output":{"name":"result"}}],[11,"new","","Creates a blank new set of options ready for configuration.",137,{"inputs":[],"output":{"name":"openoptions"}}],[11,"read","","Sets the option for read access.",137,{"inputs":[{"name":"self"},{"name":"bool"}],"output":{"name":"openoptions"}}],[11,"write","","Sets the option for write access.",137,{"inputs":[{"name":"self"},{"name":"bool"}],"output":{"name":"openoptions"}}],[11,"append","","Sets the option for the append mode.",137,{"inputs":[{"name":"self"},{"name":"bool"}],"output":{"name":"openoptions"}}],[11,"truncate","","Sets the option for truncating a previous file.",137,{"inputs":[{"name":"self"},{"name":"bool"}],"output":{"name":"openoptions"}}],[11,"create","","Sets the option for creating a new file.",137,{"inputs":[{"name":"self"},{"name":"bool"}],"output":{"name":"openoptions"}}],[11,"create_new","","Sets the option to always create a new file.",137,{"inputs":[{"name":"self"},{"name":"bool"}],"output":{"name":"openoptions"}}],[11,"open","","Opens a file at `path` with the options specified by `self`.",137,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"result"}}],[11,"file_type","","Returns the file type for this metadata.",135,{"inputs":[{"name":"self"}],"output":{"name":"filetype"}}],[11,"is_dir","","Returns whether this metadata is for a directory.",135,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_file","","Returns whether this metadata is for a regular file.",135,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"len","","Returns the size of the file, in bytes, this metadata is for.",135,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"permissions","","Returns the permissions of the file this metadata is for.",135,{"inputs":[{"name":"self"}],"output":{"name":"permissions"}}],[11,"modified","","Returns the last modification time listed in this metadata.",135,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"accessed","","Returns the last access time of this metadata.",135,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"created","","Returns the creation time listed in the this metadata.",135,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"fmt","","",135,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"readonly","","Returns whether these permissions describe a readonly file.",138,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"set_readonly","","Modifies the readonly flag for this set of permissions.",138,{"inputs":[{"name":"self"},{"name":"bool"}],"output":null}],[11,"is_dir","","Test whether this file type represents a directory.",139,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_file","","Test whether this file type represents a regular file.",139,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_symlink","","Test whether this file type represents a symbolic link.",139,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"next","","",136,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"path","","Returns the full path to the file that this entry represents.",142,{"inputs":[{"name":"self"}],"output":{"name":"pathbuf"}}],[11,"metadata","","Return the metadata for the file that this entry points at.",142,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"file_type","","Return the file type for the file that this entry points at.",142,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"file_name","","Returns the bare file name of this directory entry without any other leading path component.",142,{"inputs":[{"name":"self"}],"output":{"name":"osstring"}}],[11,"fmt","","",142,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new set of options with default mode/security settings for all platforms and also non-recursive.",140,{"inputs":[],"output":{"name":"dirbuilder"}}],[11,"recursive","","Indicate that directories create should be created recursively, creating all parent directories if they do not exist with the same security and permissions settings.",140,{"inputs":[{"name":"self"},{"name":"bool"}],"output":{"name":"self"}}],[11,"create","","Create the specified directory with the options configured in this builder.",140,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"result"}}],[0,"io","std","Traits, helpers, and type definitions for core I/O functionality.",null,null],[3,"BufReader","std::io","The `BufReader` struct adds buffering to any reader.",null,null],[3,"BufWriter","","Wraps a writer and buffers its output.",null,null],[3,"LineWriter","","Wraps a writer and buffers output to it, flushing whenever a newline (`0x0a`, `'\\n'`) is detected.",null,null],[3,"IntoInnerError","","An error returned by `into_inner` which combines an error that happened while writing out the buffer, and the buffered writer object which may be used to recover from the condition.",null,null],[3,"Cursor","","A `Cursor` wraps another type and provides it with a [`Seek`] implementation.",null,null],[3,"Error","","The error type for I/O operations of the `Read`, `Write`, `Seek`, and associated traits.",null,null],[3,"Sink","","A writer which will move data into the void.",null,null],[3,"Empty","","A reader which is always at EOF.",null,null],[3,"Repeat","","A reader which yields one byte over and over and over and over and over and...",null,null],[3,"Stdin","","A handle to the standard input stream of a process.",null,null],[3,"Stdout","","A handle to the global standard output stream of the current process.",null,null],[3,"Stderr","","A handle to the standard error stream of a process.",null,null],[3,"StdoutLock","","A locked reference to the `Stdout` handle.",null,null],[3,"StderrLock","","A locked reference to the `Stderr` handle.",null,null],[3,"StdinLock","","A locked reference to the `Stdin` handle.",null,null],[3,"Chain","","Adaptor to chain together two readers.",null,null],[3,"Take","","Reader adaptor which limits the bytes read from an underlying reader.",null,null],[3,"Bytes","","An iterator over `u8` values of a reader.",null,null],[3,"Chars","","An iterator over the `char`s of a reader.",null,null],[3,"Split","","An iterator over the contents of an instance of `BufRead` split on a particular byte.",null,null],[3,"Lines","","An iterator over the lines of an instance of `BufRead`.",null,null],[4,"ErrorKind","","A list specifying general categories of I/O error.",null,null],[13,"NotFound","","An entity was not found, often a file.",143,null],[13,"PermissionDenied","","The operation lacked the necessary privileges to complete.",143,null],[13,"ConnectionRefused","","The connection was refused by the remote server.",143,null],[13,"ConnectionReset","","The connection was reset by the remote server.",143,null],[13,"ConnectionAborted","","The connection was aborted (terminated) by the remote server.",143,null],[13,"NotConnected","","The network operation failed because it was not connected yet.",143,null],[13,"AddrInUse","","A socket address could not be bound because the address is already in use elsewhere.",143,null],[13,"AddrNotAvailable","","A nonexistent interface was requested or the requested address was not local.",143,null],[13,"BrokenPipe","","The operation failed because a pipe was closed.",143,null],[13,"AlreadyExists","","An entity already exists, often a file.",143,null],[13,"WouldBlock","","The operation needs to block to complete, but the blocking operation was requested to not occur.",143,null],[13,"InvalidInput","","A parameter was incorrect.",143,null],[13,"InvalidData","","Data not valid for the operation were encountered.",143,null],[13,"TimedOut","","The I/O operation's timeout expired, causing it to be canceled.",143,null],[13,"WriteZero","","An error returned when an operation could not be completed because a call to [`write()`] returned [`Ok(0)`].",143,null],[13,"Interrupted","","This operation was interrupted.",143,null],[13,"Other","","Any I/O error not part of this list.",143,null],[13,"UnexpectedEof","","An error returned when an operation could not be completed because an \"end of file\" was reached prematurely.",143,null],[4,"SeekFrom","","Enumeration of possible methods to seek within an I/O object.",null,null],[13,"Start","","Set the offset to the provided number of bytes.",144,null],[13,"End","","Set the offset to the size of this object plus the specified number of bytes.",144,null],[13,"Current","","Set the offset to the current position plus the specified number of bytes.",144,null],[4,"CharsError","","An enumeration of possible errors that can be generated from the `Chars` adapter.",null,null],[13,"NotUtf8","","Variant representing that the underlying stream was read successfully but it did not contain valid utf8 data.",145,null],[13,"Other","","Variant representing that an I/O error occurred.",145,null],[5,"copy","","Copies the entire contents of a reader into a writer.",null,{"inputs":[{"name":"r"},{"name":"w"}],"output":{"name":"result"}}],[5,"sink","","Creates an instance of a writer which will successfully consume all data.",null,{"inputs":[],"output":{"name":"sink"}}],[5,"empty","","Constructs a new handle to an empty reader.",null,{"inputs":[],"output":{"name":"empty"}}],[5,"repeat","","Creates an instance of a reader that infinitely repeats one byte.",null,{"inputs":[{"name":"u8"}],"output":{"name":"repeat"}}],[5,"stdin","","Constructs a new handle to the standard input of the current process.",null,{"inputs":[],"output":{"name":"stdin"}}],[5,"stdout","","Constructs a new handle to the standard output of the current process.",null,{"inputs":[],"output":{"name":"stdout"}}],[5,"stderr","","Constructs a new handle to the standard error of the current process.",null,{"inputs":[],"output":{"name":"stderr"}}],[0,"prelude","","The I/O Prelude",null,null],[11,"new","","Creates a new `BufReader` with a default buffer capacity.",146,{"inputs":[{"name":"r"}],"output":{"name":"bufreader"}}],[11,"with_capacity","","Creates a new `BufReader` with the specified buffer capacity.",146,{"inputs":[{"name":"usize"},{"name":"r"}],"output":{"name":"bufreader"}}],[11,"get_ref","","Gets a reference to the underlying reader.",146,{"inputs":[{"name":"self"}],"output":{"name":"r"}}],[11,"get_mut","","Gets a mutable reference to the underlying reader.",146,{"inputs":[{"name":"self"}],"output":{"name":"r"}}],[11,"into_inner","","Unwraps this `BufReader`, returning the underlying reader.",146,{"inputs":[{"name":"self"}],"output":{"name":"r"}}],[11,"read","","",146,null],[11,"fill_buf","","",146,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"consume","","",146,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"fmt","","",146,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"seek","","Seek to an offset, in bytes, in the underlying reader.",146,{"inputs":[{"name":"self"},{"name":"seekfrom"}],"output":{"name":"result"}}],[11,"fmt","","",147,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new `BufWriter` with a default buffer capacity.",148,{"inputs":[{"name":"w"}],"output":{"name":"bufwriter"}}],[11,"with_capacity","","Creates a new `BufWriter` with the specified buffer capacity.",148,{"inputs":[{"name":"usize"},{"name":"w"}],"output":{"name":"bufwriter"}}],[11,"get_ref","","Gets a reference to the underlying writer.",148,{"inputs":[{"name":"self"}],"output":{"name":"w"}}],[11,"get_mut","","Gets a mutable reference to the underlying writer.",148,{"inputs":[{"name":"self"}],"output":{"name":"w"}}],[11,"into_inner","","Unwraps this `BufWriter`, returning the underlying writer.",148,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"write","","",148,null],[11,"flush","","",148,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"fmt","","",148,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"seek","","Seek to the offset, in bytes, in the underlying writer.",148,{"inputs":[{"name":"self"},{"name":"seekfrom"}],"output":{"name":"result"}}],[11,"drop","","",148,{"inputs":[{"name":"self"}],"output":null}],[11,"error","","Returns the error which caused the call to `into_inner()` to fail.",147,{"inputs":[{"name":"self"}],"output":{"name":"error"}}],[11,"into_inner","","Returns the buffered writer instance which generated the error.",147,{"inputs":[{"name":"self"}],"output":{"name":"w"}}],[11,"from","","",149,{"inputs":[{"name":"intoinnererror"}],"output":{"name":"error"}}],[11,"description","","",147,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"fmt","","",147,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new `LineWriter`.",150,{"inputs":[{"name":"w"}],"output":{"name":"linewriter"}}],[11,"with_capacity","","Creates a new `LineWriter` with a specified capacity for the internal buffer.",150,{"inputs":[{"name":"usize"},{"name":"w"}],"output":{"name":"linewriter"}}],[11,"get_ref","","Gets a reference to the underlying writer.",150,{"inputs":[{"name":"self"}],"output":{"name":"w"}}],[11,"get_mut","","Gets a mutable reference to the underlying writer.",150,{"inputs":[{"name":"self"}],"output":{"name":"w"}}],[11,"into_inner","","Unwraps this `LineWriter`, returning the underlying writer.",150,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"write","","",150,null],[11,"flush","","",150,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"fmt","","",150,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",151,{"inputs":[{"name":"self"}],"output":{"name":"cursor"}}],[11,"fmt","","",151,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new cursor wrapping the provided underlying I/O object.",151,{"inputs":[{"name":"t"}],"output":{"name":"cursor"}}],[11,"into_inner","","Consumes this cursor, returning the underlying value.",151,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"get_ref","","Gets a reference to the underlying value in this cursor.",151,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"get_mut","","Gets a mutable reference to the underlying value in this cursor.",151,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"position","","Returns the current position of this cursor.",151,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"set_position","","Sets the position of this cursor.",151,{"inputs":[{"name":"self"},{"name":"u64"}],"output":null}],[11,"seek","","",151,{"inputs":[{"name":"self"},{"name":"seekfrom"}],"output":{"name":"result"}}],[11,"read","","",151,null],[11,"fill_buf","","",151,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"consume","","",151,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"write","","",151,null],[11,"flush","","",151,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"write","","",151,null],[11,"flush","","",151,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"write","","",151,null],[11,"flush","","",151,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"fmt","","",149,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",143,{"inputs":[{"name":"self"}],"output":{"name":"errorkind"}}],[11,"fmt","","",143,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",143,null],[11,"cmp","","",143,{"inputs":[{"name":"self"},{"name":"errorkind"}],"output":{"name":"ordering"}}],[11,"eq","","",143,{"inputs":[{"name":"self"},{"name":"errorkind"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",143,{"inputs":[{"name":"self"},{"name":"errorkind"}],"output":{"name":"option"}}],[11,"from","","",149,{"inputs":[{"name":"errorkind"}],"output":{"name":"error"}}],[11,"new","","Creates a new I/O error from a known kind of error as well as an arbitrary error payload.",149,{"inputs":[{"name":"errorkind"},{"name":"e"}],"output":{"name":"error"}}],[11,"last_os_error","","Returns an error representing the last OS error which occurred.",149,{"inputs":[],"output":{"name":"error"}}],[11,"from_raw_os_error","","Creates a new instance of an `Error` from a particular OS error code.",149,{"inputs":[{"name":"i32"}],"output":{"name":"error"}}],[11,"raw_os_error","","Returns the OS error that this error represents (if any).",149,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"get_ref","","Returns a reference to the inner error wrapped by this error (if any).",149,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"get_mut","","Returns a mutable reference to the inner error wrapped by this error (if any).",149,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"into_inner","","Consumes the `Error`, returning its inner error (if any).",149,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"kind","","Returns the corresponding `ErrorKind` for this error.",149,{"inputs":[{"name":"self"}],"output":{"name":"errorkind"}}],[11,"fmt","","",149,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"description","","",149,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"cause","","",149,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"read","std::boxed","",115,null],[11,"read_to_end","","",115,{"inputs":[{"name":"self"},{"name":"vec"}],"output":{"name":"result"}}],[11,"read_to_string","","",115,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"result"}}],[11,"read_exact","","",115,null],[11,"write","","",115,null],[11,"flush","","",115,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"write_all","","",115,null],[11,"write_fmt","","",115,{"inputs":[{"name":"self"},{"name":"arguments"}],"output":{"name":"result"}}],[11,"seek","","",115,{"inputs":[{"name":"self"},{"name":"seekfrom"}],"output":{"name":"result"}}],[11,"fill_buf","","",115,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"consume","","",115,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"read_until","","",115,{"inputs":[{"name":"self"},{"name":"u8"},{"name":"vec"}],"output":{"name":"result"}}],[11,"read_line","","",115,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"result"}}],[11,"write","std::vec","",131,null],[11,"write_all","","",131,null],[11,"flush","","",131,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"read","std::io","",152,null],[11,"fill_buf","","",152,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"consume","","",152,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"fmt","","",152,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"read","","",153,null],[11,"fmt","","",153,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"write","","",154,null],[11,"flush","","",154,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"fmt","","",154,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"lock","","Locks this handle to the standard input stream, returning a readable guard.",155,{"inputs":[{"name":"self"}],"output":{"name":"stdinlock"}}],[11,"read_line","","Locks this handle and reads a line of input into the specified buffer.",155,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"result"}}],[11,"fmt","","",155,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"read","","",155,null],[11,"read_to_end","","",155,{"inputs":[{"name":"self"},{"name":"vec"}],"output":{"name":"result"}}],[11,"read_to_string","","",155,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"result"}}],[11,"read_exact","","",155,null],[11,"read","","",156,null],[11,"read_to_end","","",156,{"inputs":[{"name":"self"},{"name":"vec"}],"output":{"name":"result"}}],[11,"fill_buf","","",156,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"consume","","",156,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"fmt","","",156,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"lock","","Locks this handle to the standard output stream, returning a writable guard.",157,{"inputs":[{"name":"self"}],"output":{"name":"stdoutlock"}}],[11,"fmt","","",157,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"write","","",157,null],[11,"flush","","",157,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"write_all","","",157,null],[11,"write_fmt","","",157,{"inputs":[{"name":"self"},{"name":"arguments"}],"output":{"name":"result"}}],[11,"write","","",158,null],[11,"flush","","",158,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"fmt","","",158,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"lock","","Locks this handle to the standard error stream, returning a writable guard.",159,{"inputs":[{"name":"self"}],"output":{"name":"stderrlock"}}],[11,"fmt","","",159,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"write","","",159,null],[11,"flush","","",159,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"write_all","","",159,null],[11,"write_fmt","","",159,{"inputs":[{"name":"self"},{"name":"arguments"}],"output":{"name":"result"}}],[11,"write","","",160,null],[11,"flush","","",160,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"fmt","","",160,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[6,"Result","","A specialized `Result` type for I/O operations.",null,null],[8,"Read","","The `Read` trait allows for reading bytes from a source.",null,null],[10,"read","","Pull some bytes from this source into the specified buffer, returning how many bytes were read.",161,null],[11,"read_to_end","","Read all bytes until EOF in this source, placing them into `buf`.",161,{"inputs":[{"name":"self"},{"name":"vec"}],"output":{"name":"result"}}],[11,"read_to_string","","Read all bytes until EOF in this source, placing them into `buf`.",161,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"result"}}],[11,"read_exact","","Read the exact number of bytes required to fill `buf`.",161,null],[11,"by_ref","","Creates a \"by reference\" adaptor for this instance of `Read`.",161,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"bytes","","Transforms this `Read` instance to an `Iterator` over its bytes.",161,{"inputs":[{"name":"self"}],"output":{"name":"bytes"}}],[11,"chars","","Transforms this `Read` instance to an `Iterator` over `char`s.",161,{"inputs":[{"name":"self"}],"output":{"name":"chars"}}],[11,"chain","","Creates an adaptor which will chain this stream with another.",161,{"inputs":[{"name":"self"},{"name":"r"}],"output":{"name":"chain"}}],[11,"take","","Creates an adaptor which will read at most `limit` bytes from it.",161,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"take"}}],[8,"Write","","A trait for objects which are byte-oriented sinks.",null,null],[10,"write","","Write a buffer into this object, returning how many bytes were written.",162,null],[10,"flush","","Flush this output stream, ensuring that all intermediately buffered contents reach their destination.",162,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"write_all","","Attempts to write an entire buffer into this write.",162,null],[11,"write_fmt","","Writes a formatted string into this writer, returning any error encountered.",162,{"inputs":[{"name":"self"},{"name":"arguments"}],"output":{"name":"result"}}],[11,"by_ref","","Creates a \"by reference\" adaptor for this instance of `Write`.",162,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[8,"Seek","","The `Seek` trait provides a cursor which can be moved within a stream of bytes.",null,null],[10,"seek","","Seek to an offset, in bytes, in a stream.",163,{"inputs":[{"name":"self"},{"name":"seekfrom"}],"output":{"name":"result"}}],[8,"BufRead","","A `BufRead` is a type of `Read`er which has an internal buffer, allowing it to perform extra ways of reading.",null,null],[10,"fill_buf","","Fills the internal buffer of this object, returning the buffer contents.",164,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[10,"consume","","Tells this buffer that `amt` bytes have been consumed from the buffer, so they should no longer be returned in calls to `read`.",164,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"read_until","","Read all bytes into `buf` until the delimiter `byte` or EOF is reached.",164,{"inputs":[{"name":"self"},{"name":"u8"},{"name":"vec"}],"output":{"name":"result"}}],[11,"read_line","","Read all bytes until a newline (the 0xA byte) is reached, and append them to the provided buffer.",164,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"result"}}],[11,"split","","Returns an iterator over the contents of this reader split on the byte `byte`.",164,{"inputs":[{"name":"self"},{"name":"u8"}],"output":{"name":"split"}}],[11,"lines","","Returns an iterator over the lines of this reader.",164,{"inputs":[{"name":"self"}],"output":{"name":"lines"}}],[11,"eq","","",144,{"inputs":[{"name":"self"},{"name":"seekfrom"}],"output":{"name":"bool"}}],[11,"ne","","",144,{"inputs":[{"name":"self"},{"name":"seekfrom"}],"output":{"name":"bool"}}],[11,"clone","","",144,{"inputs":[{"name":"self"}],"output":{"name":"seekfrom"}}],[11,"fmt","","",144,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",165,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"read","","",165,null],[11,"fill_buf","","",165,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"consume","","",165,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"fmt","","",166,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"limit","","Returns the number of bytes that can be read before this instance will return EOF.",166,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"into_inner","","Consumes the `Take`, returning the wrapped reader.",166,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"read","","",166,null],[11,"fill_buf","","",166,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"consume","","",166,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"fmt","","",167,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",167,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",168,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",145,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",168,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"description","","",145,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"cause","","",145,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",145,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",169,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",169,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",170,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",170,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[0,"net","std","Networking primitives for TCP/UDP communication.",null,null],[3,"Ipv4Addr","std::net","Representation of an IPv4 address.",null,null],[3,"Ipv6Addr","","Representation of an IPv6 address.",null,null],[3,"SocketAddrV4","","An IPv4 socket address which is a (ip, port) combination.",null,null],[3,"SocketAddrV6","","An IPv6 socket address.",null,null],[3,"TcpStream","","A structure which represents a TCP stream between a local socket and a remote socket.",null,null],[3,"TcpListener","","A structure representing a socket server.",null,null],[3,"Incoming","","An infinite iterator over the connections from a `TcpListener`.",null,null],[3,"UdpSocket","","A User Datagram Protocol socket.",null,null],[3,"AddrParseError","","An error returned when parsing an IP address or a socket address.",null,null],[3,"LookupHost","","An iterator over `SocketAddr` values returned from a host lookup operation.",null,null],[4,"IpAddr","","An IP address, either an IPv4 or IPv6 address.",null,null],[13,"V4","","Representation of an IPv4 address.",171,null],[13,"V6","","Representation of an IPv6 address.",171,null],[4,"Ipv6MulticastScope","","",null,null],[13,"InterfaceLocal","","",172,null],[13,"LinkLocal","","",172,null],[13,"RealmLocal","","",172,null],[13,"AdminLocal","","",172,null],[13,"SiteLocal","","",172,null],[13,"OrganizationLocal","","",172,null],[13,"Global","","",172,null],[4,"SocketAddr","","Representation of a socket address for networking applications.",null,null],[13,"V4","","An IPv4 socket address which is a (ip, port) combination.",173,null],[13,"V6","","An IPv6 socket address.",173,null],[4,"Shutdown","","Possible values which can be passed to the [`shutdown`] method of [`TcpStream`].",null,null],[13,"Read","","Indicates that the reading portion of this stream/socket should be shut down. All currently blocked and future reads will return `Ok(0)`.",174,null],[13,"Write","","Indicates that the writing portion of this stream/socket should be shut down. All currently blocked and future writes will return an error.",174,null],[13,"Both","","Shut down both the reading and writing portions of this stream.",174,null],[5,"lookup_host","","Resolve the host specified by `host` as a number of `SocketAddr` instances.",null,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"clone","","",171,{"inputs":[{"name":"self"}],"output":{"name":"ipaddr"}}],[11,"eq","","",171,{"inputs":[{"name":"self"},{"name":"ipaddr"}],"output":{"name":"bool"}}],[11,"ne","","",171,{"inputs":[{"name":"self"},{"name":"ipaddr"}],"output":{"name":"bool"}}],[11,"fmt","","",171,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",171,null],[11,"partial_cmp","","",171,{"inputs":[{"name":"self"},{"name":"ipaddr"}],"output":{"name":"option"}}],[11,"lt","","",171,{"inputs":[{"name":"self"},{"name":"ipaddr"}],"output":{"name":"bool"}}],[11,"le","","",171,{"inputs":[{"name":"self"},{"name":"ipaddr"}],"output":{"name":"bool"}}],[11,"gt","","",171,{"inputs":[{"name":"self"},{"name":"ipaddr"}],"output":{"name":"bool"}}],[11,"ge","","",171,{"inputs":[{"name":"self"},{"name":"ipaddr"}],"output":{"name":"bool"}}],[11,"cmp","","",171,{"inputs":[{"name":"self"},{"name":"ipaddr"}],"output":{"name":"ordering"}}],[11,"eq","","",172,{"inputs":[{"name":"self"},{"name":"ipv6multicastscope"}],"output":{"name":"bool"}}],[11,"clone","","",172,{"inputs":[{"name":"self"}],"output":{"name":"ipv6multicastscope"}}],[11,"hash","","",172,null],[11,"fmt","","",172,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"is_unspecified","","Returns true for the special 'unspecified' address ([IPv4], [IPv6]).",171,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_loopback","","Returns true if this is a loopback address ([IPv4], [IPv6]).",171,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_global","","Returns true if the address appears to be globally routable ([IPv4], [IPv6]).",171,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_multicast","","Returns true if this is a multicast address ([IPv4], [IPv6]).",171,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_documentation","","Returns true if this address is in a range designated for documentation ([IPv4], [IPv6]).",171,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_ipv4","","Returns true if this address is a valid IPv4 address, false if it's a valid IPv6 address.",171,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_ipv6","","Returns true if this address is a valid IPv6 address, false if it's a valid IPv4 address.",171,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"new","","Creates a new IPv4 address from four eight-bit octets.",175,{"inputs":[{"name":"u8"},{"name":"u8"},{"name":"u8"},{"name":"u8"}],"output":{"name":"ipv4addr"}}],[11,"octets","","Returns the four eight-bit integers that make up this address.",175,null],[11,"is_unspecified","","Returns true for the special 'unspecified' address (0.0.0.0).",175,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_loopback","","Returns true if this is a loopback address (127.0.0.0/8).",175,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_private","","Returns true if this is a private address.",175,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_link_local","","Returns true if the address is link-local (169.254.0.0/16).",175,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_global","","Returns true if the address appears to be globally routable. See [iana-ipv4-special-registry][ipv4-sr].",175,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_multicast","","Returns true if this is a multicast address (224.0.0.0/4).",175,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_broadcast","","Returns true if this is a broadcast address (255.255.255.255).",175,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_documentation","","Returns true if this address is in a range designated for documentation.",175,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"to_ipv6_compatible","","Converts this address to an IPv4-compatible IPv6 address.",175,{"inputs":[{"name":"self"}],"output":{"name":"ipv6addr"}}],[11,"to_ipv6_mapped","","Converts this address to an IPv4-mapped IPv6 address.",175,{"inputs":[{"name":"self"}],"output":{"name":"ipv6addr"}}],[11,"fmt","","",171,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"from","","",171,{"inputs":[{"name":"ipv4addr"}],"output":{"name":"ipaddr"}}],[11,"from","","",171,{"inputs":[{"name":"ipv6addr"}],"output":{"name":"ipaddr"}}],[11,"fmt","","",175,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",175,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",175,{"inputs":[{"name":"self"}],"output":{"name":"ipv4addr"}}],[11,"eq","","",175,{"inputs":[{"name":"self"},{"name":"ipv4addr"}],"output":{"name":"bool"}}],[11,"eq","","",171,{"inputs":[{"name":"self"},{"name":"ipv4addr"}],"output":{"name":"bool"}}],[11,"eq","","",175,{"inputs":[{"name":"self"},{"name":"ipaddr"}],"output":{"name":"bool"}}],[11,"hash","","",175,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"partial_cmp","","",175,{"inputs":[{"name":"self"},{"name":"ipv4addr"}],"output":{"name":"option"}}],[11,"partial_cmp","","",171,{"inputs":[{"name":"self"},{"name":"ipv4addr"}],"output":{"name":"option"}}],[11,"partial_cmp","","",175,{"inputs":[{"name":"self"},{"name":"ipaddr"}],"output":{"name":"option"}}],[11,"cmp","","",175,{"inputs":[{"name":"self"},{"name":"ipv4addr"}],"output":{"name":"ordering"}}],[11,"from","","",175,{"inputs":[{"name":"u32"}],"output":{"name":"ipv4addr"}}],[11,"from","","",175,null],[11,"from","","",171,null],[11,"new","","Creates a new IPv6 address from eight 16-bit segments.",176,{"inputs":[{"name":"u16"},{"name":"u16"},{"name":"u16"},{"name":"u16"},{"name":"u16"},{"name":"u16"},{"name":"u16"},{"name":"u16"}],"output":{"name":"ipv6addr"}}],[11,"segments","","Returns the eight 16-bit segments that make up this address.",176,null],[11,"is_unspecified","","Returns true for the special 'unspecified' address (::).",176,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_loopback","","Returns true if this is a loopback address (::1).",176,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_global","","Returns true if the address appears to be globally routable.",176,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_unique_local","","Returns true if this is a unique local address (fc00::/7).",176,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_unicast_link_local","","Returns true if the address is unicast and link-local (fe80::/10).",176,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_unicast_site_local","","Returns true if this is a deprecated unicast site-local address (fec0::/10).",176,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_documentation","","Returns true if this is an address reserved for documentation (2001:db8::/32).",176,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_unicast_global","","Returns true if the address is a globally routable unicast address.",176,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"multicast_scope","","Returns the address's multicast scope if the address is multicast.",176,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"is_multicast","","Returns true if this is a multicast address (ff00::/8).",176,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"to_ipv4","","Converts this address to an IPv4 address. Returns None if this address is neither IPv4-compatible or IPv4-mapped.",176,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"octets","","Returns the sixteen eight-bit integers the IPv6 address consists of.",176,null],[11,"fmt","","",176,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",176,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",176,{"inputs":[{"name":"self"}],"output":{"name":"ipv6addr"}}],[11,"eq","","",176,{"inputs":[{"name":"self"},{"name":"ipv6addr"}],"output":{"name":"bool"}}],[11,"eq","","",176,{"inputs":[{"name":"self"},{"name":"ipaddr"}],"output":{"name":"bool"}}],[11,"eq","","",171,{"inputs":[{"name":"self"},{"name":"ipv6addr"}],"output":{"name":"bool"}}],[11,"hash","","",176,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"partial_cmp","","",176,{"inputs":[{"name":"self"},{"name":"ipv6addr"}],"output":{"name":"option"}}],[11,"partial_cmp","","",171,{"inputs":[{"name":"self"},{"name":"ipv6addr"}],"output":{"name":"option"}}],[11,"partial_cmp","","",176,{"inputs":[{"name":"self"},{"name":"ipaddr"}],"output":{"name":"option"}}],[11,"cmp","","",176,{"inputs":[{"name":"self"},{"name":"ipv6addr"}],"output":{"name":"ordering"}}],[11,"from","","",176,{"inputs":[{"name":"u128"}],"output":{"name":"ipv6addr"}}],[11,"from","","",176,null],[11,"from","","",176,null],[11,"from","","",171,null],[11,"from","","",171,null],[11,"clone","","",173,{"inputs":[{"name":"self"}],"output":{"name":"socketaddr"}}],[11,"eq","","",173,{"inputs":[{"name":"self"},{"name":"socketaddr"}],"output":{"name":"bool"}}],[11,"ne","","",173,{"inputs":[{"name":"self"},{"name":"socketaddr"}],"output":{"name":"bool"}}],[11,"hash","","",173,null],[11,"fmt","","",173,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new socket address from the (ip, port) pair.",173,{"inputs":[{"name":"ipaddr"},{"name":"u16"}],"output":{"name":"socketaddr"}}],[11,"ip","","Returns the IP address associated with this socket address.",173,{"inputs":[{"name":"self"}],"output":{"name":"ipaddr"}}],[11,"set_ip","","Change the IP address associated with this socket address.",173,{"inputs":[{"name":"self"},{"name":"ipaddr"}],"output":null}],[11,"port","","Returns the port number associated with this socket address.",173,{"inputs":[{"name":"self"}],"output":{"name":"u16"}}],[11,"set_port","","Change the port number associated with this socket address.",173,{"inputs":[{"name":"self"},{"name":"u16"}],"output":null}],[11,"is_ipv4","","Returns true if the IP in this `SocketAddr` is a valid IPv4 address, false if it's a valid IPv6 address.",173,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_ipv6","","Returns true if the IP in this `SocketAddr` is a valid IPv6 address, false if it's a valid IPv4 address.",173,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"new","","Creates a new socket address from the (ip, port) pair.",177,{"inputs":[{"name":"ipv4addr"},{"name":"u16"}],"output":{"name":"socketaddrv4"}}],[11,"ip","","Returns the IP address associated with this socket address.",177,{"inputs":[{"name":"self"}],"output":{"name":"ipv4addr"}}],[11,"set_ip","","Change the IP address associated with this socket address.",177,{"inputs":[{"name":"self"},{"name":"ipv4addr"}],"output":null}],[11,"port","","Returns the port number associated with this socket address.",177,{"inputs":[{"name":"self"}],"output":{"name":"u16"}}],[11,"set_port","","Change the port number associated with this socket address.",177,{"inputs":[{"name":"self"},{"name":"u16"}],"output":null}],[11,"new","","Creates a new socket address from the ip/port/flowinfo/scope_id components.",178,{"inputs":[{"name":"ipv6addr"},{"name":"u16"},{"name":"u32"},{"name":"u32"}],"output":{"name":"socketaddrv6"}}],[11,"ip","","Returns the IP address associated with this socket address.",178,{"inputs":[{"name":"self"}],"output":{"name":"ipv6addr"}}],[11,"set_ip","","Change the IP address associated with this socket address.",178,{"inputs":[{"name":"self"},{"name":"ipv6addr"}],"output":null}],[11,"port","","Returns the port number associated with this socket address.",178,{"inputs":[{"name":"self"}],"output":{"name":"u16"}}],[11,"set_port","","Change the port number associated with this socket address.",178,{"inputs":[{"name":"self"},{"name":"u16"}],"output":null}],[11,"flowinfo","","Returns the flow information associated with this address, corresponding to the `sin6_flowinfo` field in C.",178,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"set_flowinfo","","Change the flow information associated with this socket address.",178,{"inputs":[{"name":"self"},{"name":"u32"}],"output":null}],[11,"scope_id","","Returns the scope ID associated with this address, corresponding to the `sin6_scope_id` field in C.",178,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"set_scope_id","","Change the scope ID associated with this socket address.",178,{"inputs":[{"name":"self"},{"name":"u32"}],"output":null}],[11,"from","","",173,{"inputs":[{"name":"socketaddrv4"}],"output":{"name":"socketaddr"}}],[11,"from","","",173,{"inputs":[{"name":"socketaddrv6"}],"output":{"name":"socketaddr"}}],[11,"from","","",173,null],[11,"fmt","","",173,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",177,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",177,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",178,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",178,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",177,{"inputs":[{"name":"self"}],"output":{"name":"socketaddrv4"}}],[11,"clone","","",178,{"inputs":[{"name":"self"}],"output":{"name":"socketaddrv6"}}],[11,"eq","","",177,{"inputs":[{"name":"self"},{"name":"socketaddrv4"}],"output":{"name":"bool"}}],[11,"eq","","",178,{"inputs":[{"name":"self"},{"name":"socketaddrv6"}],"output":{"name":"bool"}}],[11,"hash","","",177,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"hash","","",178,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"to_socket_addrs","","",173,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"to_socket_addrs","","",177,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"to_socket_addrs","","",178,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"to_socket_addrs","std::string","",134,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"fmt","std::net","",179,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"connect","","Opens a TCP connection to a remote host.",180,{"inputs":[{"name":"a"}],"output":{"name":"result"}}],[11,"peer_addr","","Returns the socket address of the remote peer of this TCP connection.",180,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"local_addr","","Returns the socket address of the local half of this TCP connection.",180,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"shutdown","","Shuts down the read, write, or both halves of this connection.",180,{"inputs":[{"name":"self"},{"name":"shutdown"}],"output":{"name":"result"}}],[11,"try_clone","","Creates a new independently owned handle to the underlying socket.",180,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"set_read_timeout","","Sets the read timeout to the timeout specified.",180,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"name":"result"}}],[11,"set_write_timeout","","Sets the write timeout to the timeout specified.",180,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"name":"result"}}],[11,"read_timeout","","Returns the read timeout of this socket.",180,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"write_timeout","","Returns the write timeout of this socket.",180,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"peek","","Receives data on the socket from the remote adress to which it is connected, without removing that data from the queue. On success, returns the number of bytes peeked.",180,null],[11,"set_nodelay","","Sets the value of the `TCP_NODELAY` option on this socket.",180,{"inputs":[{"name":"self"},{"name":"bool"}],"output":{"name":"result"}}],[11,"nodelay","","Gets the value of the `TCP_NODELAY` option on this socket.",180,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"set_ttl","","Sets the value for the `IP_TTL` option on this socket.",180,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"result"}}],[11,"ttl","","Gets the value of the `IP_TTL` option for this socket.",180,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"take_error","","Get the value of the `SO_ERROR` option on this socket.",180,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"set_nonblocking","","Moves this TCP stream into or out of nonblocking mode.",180,{"inputs":[{"name":"self"},{"name":"bool"}],"output":{"name":"result"}}],[11,"read","","",180,null],[11,"read_to_end","","",180,{"inputs":[{"name":"self"},{"name":"vec"}],"output":{"name":"result"}}],[11,"write","","",180,null],[11,"flush","","",180,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"fmt","","",180,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"bind","","Creates a new `TcpListener` which will be bound to the specified address.",181,{"inputs":[{"name":"a"}],"output":{"name":"result"}}],[11,"local_addr","","Returns the local socket address of this listener.",181,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"try_clone","","Creates a new independently owned handle to the underlying socket.",181,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"accept","","Accept a new incoming connection from this listener.",181,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"incoming","","Returns an iterator over the connections being received on this listener.",181,{"inputs":[{"name":"self"}],"output":{"name":"incoming"}}],[11,"set_ttl","","Sets the value for the `IP_TTL` option on this socket.",181,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"result"}}],[11,"ttl","","Gets the value of the `IP_TTL` option for this socket.",181,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"set_only_v6","","",181,{"inputs":[{"name":"self"},{"name":"bool"}],"output":{"name":"result"}}],[11,"only_v6","","",181,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"take_error","","Get the value of the `SO_ERROR` option on this socket.",181,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"set_nonblocking","","Moves this TCP stream into or out of nonblocking mode.",181,{"inputs":[{"name":"self"},{"name":"bool"}],"output":{"name":"result"}}],[11,"next","","",179,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",181,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"bind","","Creates a UDP socket from the given address.",182,{"inputs":[{"name":"a"}],"output":{"name":"result"}}],[11,"recv_from","","Receives data from the socket. On success, returns the number of bytes read and the address from whence the data came.",182,null],[11,"peek_from","","Receives data from the socket, without removing it from the queue.",182,null],[11,"send_to","","Sends data on the socket to the given address. On success, returns the number of bytes written.",182,null],[11,"local_addr","","Returns the socket address that this socket was created from.",182,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"try_clone","","Creates a new independently owned handle to the underlying socket.",182,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"set_read_timeout","","Sets the read timeout to the timeout specified.",182,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"name":"result"}}],[11,"set_write_timeout","","Sets the write timeout to the timeout specified.",182,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"name":"result"}}],[11,"read_timeout","","Returns the read timeout of this socket.",182,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"write_timeout","","Returns the write timeout of this socket.",182,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"set_broadcast","","Sets the value of the `SO_BROADCAST` option for this socket.",182,{"inputs":[{"name":"self"},{"name":"bool"}],"output":{"name":"result"}}],[11,"broadcast","","Gets the value of the `SO_BROADCAST` option for this socket.",182,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"set_multicast_loop_v4","","Sets the value of the `IP_MULTICAST_LOOP` option for this socket.",182,{"inputs":[{"name":"self"},{"name":"bool"}],"output":{"name":"result"}}],[11,"multicast_loop_v4","","Gets the value of the `IP_MULTICAST_LOOP` option for this socket.",182,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"set_multicast_ttl_v4","","Sets the value of the `IP_MULTICAST_TTL` option for this socket.",182,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"result"}}],[11,"multicast_ttl_v4","","Gets the value of the `IP_MULTICAST_TTL` option for this socket.",182,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"set_multicast_loop_v6","","Sets the value of the `IPV6_MULTICAST_LOOP` option for this socket.",182,{"inputs":[{"name":"self"},{"name":"bool"}],"output":{"name":"result"}}],[11,"multicast_loop_v6","","Gets the value of the `IPV6_MULTICAST_LOOP` option for this socket.",182,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"set_ttl","","Sets the value for the `IP_TTL` option on this socket.",182,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"result"}}],[11,"ttl","","Gets the value of the `IP_TTL` option for this socket.",182,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"join_multicast_v4","","Executes an operation of the `IP_ADD_MEMBERSHIP` type.",182,{"inputs":[{"name":"self"},{"name":"ipv4addr"},{"name":"ipv4addr"}],"output":{"name":"result"}}],[11,"join_multicast_v6","","Executes an operation of the `IPV6_ADD_MEMBERSHIP` type.",182,{"inputs":[{"name":"self"},{"name":"ipv6addr"},{"name":"u32"}],"output":{"name":"result"}}],[11,"leave_multicast_v4","","Executes an operation of the `IP_DROP_MEMBERSHIP` type.",182,{"inputs":[{"name":"self"},{"name":"ipv4addr"},{"name":"ipv4addr"}],"output":{"name":"result"}}],[11,"leave_multicast_v6","","Executes an operation of the `IPV6_DROP_MEMBERSHIP` type.",182,{"inputs":[{"name":"self"},{"name":"ipv6addr"},{"name":"u32"}],"output":{"name":"result"}}],[11,"take_error","","Get the value of the `SO_ERROR` option on this socket.",182,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"connect","","Connects this UDP socket to a remote address, allowing the `send` and `recv` syscalls to be used to send data and also applies filters to only receive data from the specified address.",182,{"inputs":[{"name":"self"},{"name":"a"}],"output":{"name":"result"}}],[11,"send","","Sends data on the socket to the remote address to which it is connected.",182,null],[11,"recv","","Receives data on the socket from the remote address to which it is connected.",182,null],[11,"peek","","Receives data on the socket from the remote adress to which it is connected, without removing that data from the queue. On success, returns the number of bytes peeked.",182,null],[11,"set_nonblocking","","Moves this UDP socket into or out of nonblocking mode.",182,{"inputs":[{"name":"self"},{"name":"bool"}],"output":{"name":"result"}}],[11,"fmt","","",182,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"from_str","","",171,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",175,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",176,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",177,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",178,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",173,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"fmt","","",183,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",183,{"inputs":[{"name":"self"}],"output":{"name":"addrparseerror"}}],[11,"eq","","",183,{"inputs":[{"name":"self"},{"name":"addrparseerror"}],"output":{"name":"bool"}}],[11,"ne","","",183,{"inputs":[{"name":"self"},{"name":"addrparseerror"}],"output":{"name":"bool"}}],[11,"fmt","","",183,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"description","","",183,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[8,"ToSocketAddrs","","A trait for objects which can be converted or resolved to one or more `SocketAddr` values.",null,null],[16,"Iter","","Returned iterator over socket addresses which this type may correspond to.",184,null],[10,"to_socket_addrs","","Converts this object to an iterator of resolved `SocketAddr`s.",184,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"clone","","",174,{"inputs":[{"name":"self"}],"output":{"name":"shutdown"}}],[11,"eq","","",174,{"inputs":[{"name":"self"},{"name":"shutdown"}],"output":{"name":"bool"}}],[11,"fmt","","",174,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",185,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",185,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[0,"num","std","Additional functionality for numerics.",null,null],[8,"Zero","std::num","Types that have a \"zero\" value.",null,null],[10,"zero","","The \"zero\" (usually, additive identity) for this type.",186,{"inputs":[],"output":{"name":"self"}}],[8,"One","","Types that have a \"one\" value.",null,null],[10,"one","","The \"one\" (usually, multiplicative identity) for this type.",187,{"inputs":[],"output":{"name":"self"}}],[4,"FpCategory","","A classification of floating point numbers.",null,null],[13,"Nan","","\"Not a Number\", often obtained by dividing by zero.",188,null],[13,"Infinite","","Positive or negative infinity.",188,null],[13,"Zero","","Positive or negative zero.",188,null],[13,"Subnormal","","De-normalized floating point representation (less precise than `Normal`).",188,null],[13,"Normal","","A regular floating point number.",188,null],[3,"ParseIntError","","An error which can be returned when parsing an integer.",null,null],[3,"ParseFloatError","","An error which can be returned when parsing a float.",null,null],[3,"TryFromIntError","","The error type returned when a checked integral type conversion fails.",null,null],[3,"Wrapping","","Provides intentionally-wrapped arithmetic on `T`.",null,null],[12,"0","","",189,null],[0,"os","std","OS-specific functionality.",null,null],[0,"unix","std::os","Experimental extensions to `std` for Unix platforms.",null,null],[0,"io","std::os::unix","Unix-specific extensions to general I/O primitives",null,null],[6,"RawFd","std::os::unix::io","Raw file descriptors.",null,null],[8,"AsRawFd","","A trait to extract the raw unix file descriptor from an underlying object.",null,null],[10,"as_raw_fd","","Extracts the raw file descriptor.",190,{"inputs":[{"name":"self"}],"output":{"name":"rawfd"}}],[8,"FromRawFd","","A trait to express the ability to construct an object from a raw file descriptor.",null,null],[10,"from_raw_fd","","Constructs a new instance of `Self` from the given raw file descriptor.",191,{"inputs":[{"name":"rawfd"}],"output":{"name":"self"}}],[8,"IntoRawFd","","A trait to express the ability to consume an object and acquire ownership of its raw file descriptor.",null,null],[10,"into_raw_fd","","Consumes this object, returning the raw underlying file descriptor.",192,{"inputs":[{"name":"self"}],"output":{"name":"rawfd"}}],[0,"ffi","std::os::unix","Unix-specific extension to the primitives in the `std::ffi` module",null,null],[8,"OsStringExt","std::os::unix::ffi","Unix-specific extensions to `OsString`.",null,null],[10,"from_vec","","Creates an [`OsString`] from a byte vector.",193,{"inputs":[{"name":"vec"}],"output":{"name":"self"}}],[10,"into_vec","","Yields the underlying byte vector of this [`OsString`].",193,{"inputs":[{"name":"self"}],"output":{"name":"vec"}}],[8,"OsStrExt","","Unix-specific extensions to `OsStr`.",null,null],[10,"from_bytes","","Creates an [`OsStr`] from a byte slice.",194,null],[10,"as_bytes","","Gets the underlying byte view of the [`OsStr`] slice.",194,null],[0,"fs","std::os::unix","Unix-specific extensions to primitives in the `std::fs` module.",null,null],[5,"symlink","std::os::unix::fs","Creates a new symbolic link on the filesystem.",null,{"inputs":[{"name":"p"},{"name":"q"}],"output":{"name":"result"}}],[8,"FileExt","","Unix-specific extensions to `File`",null,null],[10,"read_at","","Reads a number of bytes starting from a given offset.",195,null],[10,"write_at","","Writes a number of bytes starting from a given offset.",195,null],[8,"PermissionsExt","","Unix-specific extensions to `Permissions`",null,null],[10,"mode","","Returns the underlying raw `mode_t` bits that are the standard Unix permissions for this file.",196,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[10,"set_mode","","Sets the underlying raw bits for this set of permissions.",196,{"inputs":[{"name":"self"},{"name":"u32"}],"output":null}],[10,"from_mode","","Creates a new instance of `Permissions` from the given set of Unix permission bits.",196,{"inputs":[{"name":"u32"}],"output":{"name":"self"}}],[8,"OpenOptionsExt","","Unix-specific extensions to `OpenOptions`",null,null],[10,"mode","","Sets the mode bits that a new file will be created with.",197,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"self"}}],[10,"custom_flags","","Pass custom flags to the `flags` agument of `open`.",197,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"self"}}],[8,"MetadataExt","","",null,null],[10,"dev","","",198,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[10,"ino","","",198,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[10,"mode","","",198,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[10,"nlink","","",198,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[10,"uid","","",198,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[10,"gid","","",198,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[10,"rdev","","",198,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[10,"size","","",198,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[10,"atime","","",198,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[10,"atime_nsec","","",198,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[10,"mtime","","",198,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[10,"mtime_nsec","","",198,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[10,"ctime","","",198,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[10,"ctime_nsec","","",198,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[10,"blksize","","",198,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[10,"blocks","","",198,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[8,"FileTypeExt","","Add special unix types (block/char device, fifo and socket)",null,null],[10,"is_block_device","","Returns whether this file type is a block device.",199,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[10,"is_char_device","","Returns whether this file type is a char device.",199,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[10,"is_fifo","","Returns whether this file type is a fifo.",199,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[10,"is_socket","","Returns whether this file type is a socket.",199,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[8,"DirEntryExt","","Unix-specific extension methods for `fs::DirEntry`",null,null],[10,"ino","","Returns the underlying `d_ino` field in the contained `dirent` structure.",200,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[8,"DirBuilderExt","","An extension trait for `fs::DirBuilder` for unix-specific options.",null,null],[10,"mode","","Sets the mode to create new directories with. This option defaults to 0o777.",201,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"self"}}],[0,"process","std::os::unix","Unix-specific extensions to primitives in the `std::process` module.",null,null],[8,"CommandExt","std::os::unix::process","Unix-specific extensions to the `std::process::Command` builder",null,null],[10,"uid","","Sets the child process's user id. This translates to a `setuid` call in the child process. Failure in the `setuid` call will cause the spawn to fail.",202,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"command"}}],[10,"gid","","Similar to `uid`, but sets the group id of the child process. This has the same semantics as the `uid` field.",202,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"command"}}],[10,"before_exec","","Schedules a closure to be run just before the `exec` function is invoked.",202,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"command"}}],[10,"exec","","Performs all the required setup by this `Command`, followed by calling the `execvp` syscall.",202,{"inputs":[{"name":"self"}],"output":{"name":"error"}}],[8,"ExitStatusExt","","Unix-specific extensions to `std::process::ExitStatus`",null,null],[10,"from_raw","","Creates a new `ExitStatus` from the raw underlying `i32` return value of a process.",203,{"inputs":[{"name":"i32"}],"output":{"name":"self"}}],[10,"signal","","If the process was terminated by a signal, returns that signal.",203,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[0,"raw","std::os::unix","Unix-specific primitives available on all unix platforms",null,null],[6,"uid_t","std::os::unix::raw","",null,null],[6,"gid_t","","",null,null],[6,"pid_t","","",null,null],[6,"pthread_t","","",null,null],[6,"dev_t","","",null,null],[6,"ino_t","","",null,null],[6,"mode_t","","",null,null],[6,"nlink_t","","",null,null],[6,"off_t","","",null,null],[6,"blksize_t","","",null,null],[6,"blkcnt_t","","",null,null],[6,"time_t","","",null,null],[0,"thread","std::os::unix","Unix-specific extensions to primitives in the `std::thread` module.",null,null],[6,"RawPthread","std::os::unix::thread","",null,null],[8,"JoinHandleExt","","Unix-specific extensions to `std::thread::JoinHandle`",null,null],[10,"as_pthread_t","","Extracts the raw pthread_t without taking ownership",204,{"inputs":[{"name":"self"}],"output":{"name":"rawpthread"}}],[10,"into_pthread_t","","Consumes the thread, returning the raw pthread_t",204,{"inputs":[{"name":"self"}],"output":{"name":"rawpthread"}}],[0,"net","std::os::unix","Unix-specific networking functionality",null,null],[3,"SocketAddr","std::os::unix::net","An address associated with a Unix socket.",null,null],[3,"UnixStream","","A Unix stream socket.",null,null],[3,"UnixListener","","A structure representing a Unix domain socket server.",null,null],[3,"Incoming","","An iterator over incoming connections to a [`UnixListener`].",null,null],[3,"UnixDatagram","","A Unix datagram socket.",null,null],[0,"prelude","std::os::unix","A prelude for conveniently writing platform-specific code.",null,null],[0,"freebsd","std::os","FreeBSD-specific definitions",null,null],[0,"raw","std::os::freebsd","FreeBSD-specific raw type definitions",null,null],[3,"stat","std::os::freebsd::raw","",null,null],[12,"st_dev","","",205,null],[12,"st_ino","","",205,null],[12,"st_mode","","",205,null],[12,"st_nlink","","",205,null],[12,"st_uid","","",205,null],[12,"st_gid","","",205,null],[12,"st_rdev","","",205,null],[12,"st_atime","","",205,null],[12,"st_atime_nsec","","",205,null],[12,"st_mtime","","",205,null],[12,"st_mtime_nsec","","",205,null],[12,"st_ctime","","",205,null],[12,"st_ctime_nsec","","",205,null],[12,"st_size","","",205,null],[12,"st_blocks","","",205,null],[12,"st_blksize","","",205,null],[12,"st_flags","","",205,null],[12,"st_gen","","",205,null],[12,"st_lspare","","",205,null],[12,"st_birthtime","","",205,null],[12,"st_birthtime_nsec","","",205,null],[12,"__unused","","",205,null],[6,"blkcnt_t","","",null,null],[6,"blksize_t","","",null,null],[6,"dev_t","","",null,null],[6,"fflags_t","","",null,null],[6,"ino_t","","",null,null],[6,"mode_t","","",null,null],[6,"nlink_t","","",null,null],[6,"off_t","","",null,null],[6,"time_t","","",null,null],[6,"pthread_t","","",null,null],[11,"clone","","",205,{"inputs":[{"name":"self"}],"output":{"name":"stat"}}],[0,"fs","std::os::freebsd","",null,null],[8,"MetadataExt","std::os::freebsd::fs","OS-specific extension methods for `fs::Metadata`",null,null],[10,"as_raw_stat","","Gain a reference to the underlying `stat` structure which contains the raw information returned by the OS.",206,{"inputs":[{"name":"self"}],"output":{"name":"stat"}}],[10,"st_dev","","",206,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[10,"st_ino","","",206,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[10,"st_mode","","",206,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[10,"st_nlink","","",206,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[10,"st_uid","","",206,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[10,"st_gid","","",206,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[10,"st_rdev","","",206,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[10,"st_size","","",206,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[10,"st_atime","","",206,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[10,"st_atime_nsec","","",206,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[10,"st_mtime","","",206,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[10,"st_mtime_nsec","","",206,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[10,"st_ctime","","",206,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[10,"st_ctime_nsec","","",206,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[10,"st_birthtime","","",206,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[10,"st_birthtime_nsec","","",206,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[10,"st_blksize","","",206,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[10,"st_blocks","","",206,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[10,"st_flags","","",206,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[10,"st_gen","","",206,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[10,"st_lspare","","",206,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"as_raw_stat","std::fs","",135,{"inputs":[{"name":"self"}],"output":{"name":"stat"}}],[11,"st_dev","","",135,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"st_ino","","",135,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"st_mode","","",135,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"st_nlink","","",135,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"st_uid","","",135,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"st_gid","","",135,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"st_rdev","","",135,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"st_size","","",135,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"st_atime","","",135,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[11,"st_atime_nsec","","",135,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[11,"st_mtime","","",135,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[11,"st_mtime_nsec","","",135,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[11,"st_ctime","","",135,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[11,"st_ctime_nsec","","",135,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[11,"st_birthtime","","",135,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[11,"st_birthtime_nsec","","",135,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[11,"st_blksize","","",135,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"st_blocks","","",135,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"st_gen","","",135,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"st_flags","","",135,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"st_lspare","","",135,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[0,"raw","std::os","Raw OS-specific types for the current platform/architecture",null,null],[4,"c_void","std::os::raw","Type used to construct void pointers for use with C.",null,null],[6,"c_char","","",null,null],[6,"c_schar","","",null,null],[6,"c_uchar","","",null,null],[6,"c_short","","",null,null],[6,"c_ushort","","",null,null],[6,"c_int","","",null,null],[6,"c_uint","","",null,null],[6,"c_long","","",null,null],[6,"c_ulong","","",null,null],[6,"c_longlong","","",null,null],[6,"c_ulonglong","","",null,null],[6,"c_float","","",null,null],[6,"c_double","","",null,null],[11,"fmt","","",207,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[0,"panic","std","Panic support in the standard library",null,null],[3,"PanicInfo","std::panic","A struct providing information about a panic.",null,null],[3,"Location","","A struct containing information about the location of a panic.",null,null],[3,"AssertUnwindSafe","","A simple wrapper around a type to assert that it is unwind safe.",null,null],[12,"0","","",208,null],[5,"take_hook","","Unregisters the current panic hook, returning it.",null,{"inputs":[],"output":{"name":"box"}}],[5,"set_hook","","Registers a custom panic hook, replacing any that was previously registered.",null,{"inputs":[{"name":"box"}],"output":null}],[5,"catch_unwind","","Invokes a closure, capturing the cause of an unwinding panic if one occurs.",null,{"inputs":[{"name":"f"}],"output":{"name":"result"}}],[5,"resume_unwind","","Triggers a panic without invoking the panic hook.",null,null],[8,"UnwindSafe","","A marker trait which represents \"panic safe\" types in Rust.",null,null],[8,"RefUnwindSafe","","A marker trait representing types where a shared reference is considered unwind safe.",null,null],[11,"deref","","",208,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"deref_mut","","",208,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"call_once","","",208,null],[11,"fmt","","",208,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[0,"path","std","Cross-platform path manipulation.",null,null],[3,"PrefixComponent","std::path","A Windows path prefix, e.g. `C:` or `\\server\\share`.",null,null],[3,"Components","","The core iterator giving the components of a path.",null,null],[3,"Iter","","An iterator over the components of a path, as [`OsStr`] slices.",null,null],[3,"PathBuf","","An owned, mutable path (akin to [`String`]).",null,null],[3,"Path","","A slice of a path (akin to [`str`]).",null,null],[3,"StripPrefixError","","An error returned from the [`Path::strip_prefix`] method indicating that the prefix was not found in `self`.",null,null],[3,"Display","","Helper struct for safely printing paths with `format!()` and `{}`",null,null],[4,"Prefix","","Path prefixes (Windows only).",null,null],[13,"Verbatim","","Prefix `\\?`, together with the given component immediately following it.",209,null],[13,"VerbatimUNC","","Prefix `\\?\\UNC`, with the \"server\" and \"share\" components following it.",209,null],[13,"VerbatimDisk","","Prefix like `\\?\\C:`, for the given drive letter",209,null],[13,"DeviceNS","","Prefix `\\.`, together with the given component immediately following it.",209,null],[13,"UNC","","Prefix `\\server\\share`, with the given \"server\" and \"share\" components.",209,null],[13,"Disk","","Prefix `C:` for the given disk drive.",209,null],[4,"Component","","A single component of a path.",null,null],[13,"Prefix","","A Windows path prefix, e.g. `C:` or `\\server\\share`.",210,null],[13,"RootDir","","The root directory component, appears after any prefix and before anything else",210,null],[13,"CurDir","","A reference to the current directory, i.e. `.`",210,null],[13,"ParentDir","","A reference to the parent directory, i.e. `..`",210,null],[13,"Normal","","A normal component, i.e. `a` and `b` in `a/b`",210,null],[5,"is_separator","","Determines whether the character is one of the permitted path separators for the current platform.",null,{"inputs":[{"name":"char"}],"output":{"name":"bool"}}],[17,"MAIN_SEPARATOR","","The primary separator of path components for the current platform.",null,null],[11,"clone","","",209,{"inputs":[{"name":"self"}],"output":{"name":"prefix"}}],[11,"fmt","","",209,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",209,null],[11,"partial_cmp","","",209,{"inputs":[{"name":"self"},{"name":"prefix"}],"output":{"name":"option"}}],[11,"lt","","",209,{"inputs":[{"name":"self"},{"name":"prefix"}],"output":{"name":"bool"}}],[11,"le","","",209,{"inputs":[{"name":"self"},{"name":"prefix"}],"output":{"name":"bool"}}],[11,"gt","","",209,{"inputs":[{"name":"self"},{"name":"prefix"}],"output":{"name":"bool"}}],[11,"ge","","",209,{"inputs":[{"name":"self"},{"name":"prefix"}],"output":{"name":"bool"}}],[11,"cmp","","",209,{"inputs":[{"name":"self"},{"name":"prefix"}],"output":{"name":"ordering"}}],[11,"eq","","",209,{"inputs":[{"name":"self"},{"name":"prefix"}],"output":{"name":"bool"}}],[11,"ne","","",209,{"inputs":[{"name":"self"},{"name":"prefix"}],"output":{"name":"bool"}}],[11,"is_verbatim","","Determines if the prefix is verbatim, i.e. begins with `\\?`.",209,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",211,{"inputs":[{"name":"self"}],"output":{"name":"prefixcomponent"}}],[11,"fmt","","",211,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"kind","","The parsed prefix data.",211,{"inputs":[{"name":"self"}],"output":{"name":"prefix"}}],[11,"as_os_str","","The raw `OsStr` slice for this prefix.",211,{"inputs":[{"name":"self"}],"output":{"name":"osstr"}}],[11,"eq","","",211,{"inputs":[{"name":"self"},{"name":"prefixcomponent"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",211,{"inputs":[{"name":"self"},{"name":"prefixcomponent"}],"output":{"name":"option"}}],[11,"cmp","","",211,{"inputs":[{"name":"self"},{"name":"prefixcomponent"}],"output":{"name":"ordering"}}],[11,"hash","","",211,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"clone","","",210,{"inputs":[{"name":"self"}],"output":{"name":"component"}}],[11,"eq","","",210,{"inputs":[{"name":"self"},{"name":"component"}],"output":{"name":"bool"}}],[11,"ne","","",210,{"inputs":[{"name":"self"},{"name":"component"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",210,{"inputs":[{"name":"self"},{"name":"component"}],"output":{"name":"option"}}],[11,"lt","","",210,{"inputs":[{"name":"self"},{"name":"component"}],"output":{"name":"bool"}}],[11,"le","","",210,{"inputs":[{"name":"self"},{"name":"component"}],"output":{"name":"bool"}}],[11,"gt","","",210,{"inputs":[{"name":"self"},{"name":"component"}],"output":{"name":"bool"}}],[11,"ge","","",210,{"inputs":[{"name":"self"},{"name":"component"}],"output":{"name":"bool"}}],[11,"cmp","","",210,{"inputs":[{"name":"self"},{"name":"component"}],"output":{"name":"ordering"}}],[11,"hash","","",210,null],[11,"fmt","","",210,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"as_os_str","","Extracts the underlying `OsStr` slice.",210,{"inputs":[{"name":"self"}],"output":{"name":"osstr"}}],[11,"as_ref","","",210,{"inputs":[{"name":"self"}],"output":{"name":"osstr"}}],[11,"clone","","",212,{"inputs":[{"name":"self"}],"output":{"name":"components"}}],[11,"clone","","",213,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"fmt","","",212,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"as_path","","Extracts a slice corresponding to the portion of the path remaining for iteration.",212,{"inputs":[{"name":"self"}],"output":{"name":"path"}}],[11,"as_ref","","",212,{"inputs":[{"name":"self"}],"output":{"name":"path"}}],[11,"as_ref","","",212,{"inputs":[{"name":"self"}],"output":{"name":"osstr"}}],[11,"fmt","","",213,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"as_path","","Extracts a slice corresponding to the portion of the path remaining for iteration.",213,{"inputs":[{"name":"self"}],"output":{"name":"path"}}],[11,"as_ref","","",213,{"inputs":[{"name":"self"}],"output":{"name":"path"}}],[11,"as_ref","","",213,{"inputs":[{"name":"self"}],"output":{"name":"osstr"}}],[11,"next","","",213,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",213,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",212,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",212,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"eq","","",212,{"inputs":[{"name":"self"},{"name":"components"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",212,{"inputs":[{"name":"self"},{"name":"components"}],"output":{"name":"option"}}],[11,"cmp","","",212,{"inputs":[{"name":"self"},{"name":"components"}],"output":{"name":"ordering"}}],[11,"clone","","",214,{"inputs":[{"name":"self"}],"output":{"name":"pathbuf"}}],[11,"new","","Allocates an empty `PathBuf`.",214,{"inputs":[],"output":{"name":"pathbuf"}}],[11,"as_path","","Coerces to a [`Path`] slice.",214,{"inputs":[{"name":"self"}],"output":{"name":"path"}}],[11,"push","","Extends `self` with `path`.",214,{"inputs":[{"name":"self"},{"name":"p"}],"output":null}],[11,"pop","","Truncate `self` to [`self.parent()`].",214,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"set_file_name","","Updates [`self.file_name()`] to `file_name`.",214,{"inputs":[{"name":"self"},{"name":"s"}],"output":null}],[11,"set_extension","","Updates [`self.extension()`] to `extension`.",214,{"inputs":[{"name":"self"},{"name":"s"}],"output":{"name":"bool"}}],[11,"into_os_string","","Consumes the `PathBuf`, yielding its internal [`OsString`] storage.",214,{"inputs":[{"name":"self"}],"output":{"name":"osstring"}}],[11,"into_boxed_path","","Converts this `PathBuf` into a boxed `Path`.",214,{"inputs":[{"name":"self"}],"output":{"name":"box"}}],[11,"from","std::boxed","",115,{"inputs":[{"name":"path"}],"output":{"name":"box"}}],[11,"default","","",115,{"inputs":[],"output":{"name":"box"}}],[11,"from","std::path","",214,{"inputs":[{"name":"t"}],"output":{"name":"pathbuf"}}],[11,"from","","",214,{"inputs":[{"name":"osstring"}],"output":{"name":"pathbuf"}}],[11,"from","std::ffi","",132,{"inputs":[{"name":"pathbuf"}],"output":{"name":"osstring"}}],[11,"from","std::path","",214,{"inputs":[{"name":"string"}],"output":{"name":"pathbuf"}}],[11,"from_iter","","",214,{"inputs":[{"name":"i"}],"output":{"name":"pathbuf"}}],[11,"extend","","",214,{"inputs":[{"name":"self"},{"name":"i"}],"output":null}],[11,"fmt","","",214,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"deref","","",214,{"inputs":[{"name":"self"}],"output":{"name":"path"}}],[11,"borrow","","",214,{"inputs":[{"name":"self"}],"output":{"name":"path"}}],[11,"default","","",214,{"inputs":[],"output":{"name":"self"}}],[11,"from","std::borrow","",72,{"inputs":[{"name":"path"}],"output":{"name":"cow"}}],[11,"from","","",72,{"inputs":[{"name":"pathbuf"}],"output":{"name":"cow"}}],[11,"to_owned","std::path","",215,{"inputs":[{"name":"self"}],"output":{"name":"pathbuf"}}],[11,"eq","","",214,{"inputs":[{"name":"self"},{"name":"pathbuf"}],"output":{"name":"bool"}}],[11,"hash","","",214,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"partial_cmp","","",214,{"inputs":[{"name":"self"},{"name":"pathbuf"}],"output":{"name":"option"}}],[11,"cmp","","",214,{"inputs":[{"name":"self"},{"name":"pathbuf"}],"output":{"name":"ordering"}}],[11,"as_ref","","",214,{"inputs":[{"name":"self"}],"output":{"name":"osstr"}}],[11,"fmt","","",216,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",216,{"inputs":[{"name":"self"}],"output":{"name":"stripprefixerror"}}],[11,"eq","","",216,{"inputs":[{"name":"self"},{"name":"stripprefixerror"}],"output":{"name":"bool"}}],[11,"ne","","",216,{"inputs":[{"name":"self"},{"name":"stripprefixerror"}],"output":{"name":"bool"}}],[11,"new","","Directly wrap a string slice as a `Path` slice.",215,{"inputs":[{"name":"s"}],"output":{"name":"path"}}],[11,"as_os_str","","Yields the underlying [`OsStr`] slice.",215,{"inputs":[{"name":"self"}],"output":{"name":"osstr"}}],[11,"to_str","","Yields a [`&str`] slice if the `Path` is valid unicode.",215,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"to_string_lossy","","Converts a `Path` to a [`Cow<str>`].",215,{"inputs":[{"name":"self"}],"output":{"name":"cow"}}],[11,"to_path_buf","","Converts a `Path` to an owned [`PathBuf`].",215,{"inputs":[{"name":"self"}],"output":{"name":"pathbuf"}}],[11,"is_absolute","","A path is *absolute* if it is independent of the current directory.",215,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_relative","","A path is *relative* if it is not absolute.",215,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"has_root","","A path has a root if the body of the path begins with the directory separator.",215,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"parent","","The path without its final component, if any.",215,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"file_name","","The final component of the path, if it is a normal file.",215,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"strip_prefix","","Returns a path that, when joined onto `base`, yields `self`.",215,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"result"}}],[11,"starts_with","","Determines whether `base` is a prefix of `self`.",215,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"bool"}}],[11,"ends_with","","Determines whether `child` is a suffix of `self`.",215,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"bool"}}],[11,"file_stem","","Extracts the stem (non-extension) portion of [`self.file_name()`].",215,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"extension","","Extracts the extension of [`self.file_name()`], if possible.",215,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"join","","Creates an owned [`PathBuf`] with `path` adjoined to `self`.",215,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"pathbuf"}}],[11,"with_file_name","","Creates an owned [`PathBuf`] like `self` but with the given file name.",215,{"inputs":[{"name":"self"},{"name":"s"}],"output":{"name":"pathbuf"}}],[11,"with_extension","","Creates an owned [`PathBuf`] like `self` but with the given extension.",215,{"inputs":[{"name":"self"},{"name":"s"}],"output":{"name":"pathbuf"}}],[11,"components","","Produce an iterator over the components of the path.",215,{"inputs":[{"name":"self"}],"output":{"name":"components"}}],[11,"iter","","Produce an iterator over the path's components viewed as [`OsStr`] slices.",215,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"display","","Returns an object that implements [`Display`] for safely printing paths that may contain non-Unicode data.",215,{"inputs":[{"name":"self"}],"output":{"name":"display"}}],[11,"metadata","","Query the file system to get information about a file, directory, etc.",215,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"symlink_metadata","","Query the metadata about a file without following symlinks.",215,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"canonicalize","","Returns the canonical form of the path with all intermediate components normalized and symbolic links resolved.",215,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"read_link","","Reads a symbolic link, returning the file that the link points to.",215,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"read_dir","","Returns an iterator over the entries within a directory.",215,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"exists","","Returns whether the path points at an existing entity.",215,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_file","","Returns whether the path is pointing at a regular file.",215,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_dir","","Returns whether the path is pointing at a directory.",215,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"as_ref","","",215,{"inputs":[{"name":"self"}],"output":{"name":"osstr"}}],[11,"fmt","","",215,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",217,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",217,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",215,{"inputs":[{"name":"self"},{"name":"path"}],"output":{"name":"bool"}}],[11,"hash","","",215,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"partial_cmp","","",215,{"inputs":[{"name":"self"},{"name":"path"}],"output":{"name":"option"}}],[11,"cmp","","",215,{"inputs":[{"name":"self"},{"name":"path"}],"output":{"name":"ordering"}}],[11,"as_ref","","",215,{"inputs":[{"name":"self"}],"output":{"name":"path"}}],[11,"as_ref","std::ffi","",133,{"inputs":[{"name":"self"}],"output":{"name":"path"}}],[11,"as_ref","std::borrow","",72,{"inputs":[{"name":"self"}],"output":{"name":"path"}}],[11,"as_ref","std::ffi","",132,{"inputs":[{"name":"self"}],"output":{"name":"path"}}],[11,"as_ref","std::string","",134,{"inputs":[{"name":"self"}],"output":{"name":"path"}}],[11,"as_ref","std::path","",214,{"inputs":[{"name":"self"}],"output":{"name":"path"}}],[11,"eq","","",214,{"inputs":[{"name":"self"},{"name":"path"}],"output":{"name":"bool"}}],[11,"eq","","",215,{"inputs":[{"name":"self"},{"name":"pathbuf"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",214,{"inputs":[{"name":"self"},{"name":"path"}],"output":{"name":"option"}}],[11,"partial_cmp","","",215,{"inputs":[{"name":"self"},{"name":"pathbuf"}],"output":{"name":"option"}}],[11,"eq","","",214,{"inputs":[{"name":"self"},{"name":"path"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",214,{"inputs":[{"name":"self"},{"name":"path"}],"output":{"name":"option"}}],[11,"eq","std::borrow","",72,{"inputs":[{"name":"self"},{"name":"path"}],"output":{"name":"bool"}}],[11,"eq","std::path","",215,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"bool"}}],[11,"partial_cmp","std::borrow","",72,{"inputs":[{"name":"self"},{"name":"path"}],"output":{"name":"option"}}],[11,"partial_cmp","std::path","",215,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"option"}}],[11,"eq","std::borrow","",72,{"inputs":[{"name":"self"},{"name":"path"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",72,{"inputs":[{"name":"self"},{"name":"path"}],"output":{"name":"option"}}],[11,"eq","","",72,{"inputs":[{"name":"self"},{"name":"pathbuf"}],"output":{"name":"bool"}}],[11,"eq","std::path","",214,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"bool"}}],[11,"partial_cmp","std::borrow","",72,{"inputs":[{"name":"self"},{"name":"pathbuf"}],"output":{"name":"option"}}],[11,"partial_cmp","std::path","",214,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"option"}}],[11,"eq","","",214,{"inputs":[{"name":"self"},{"name":"osstr"}],"output":{"name":"bool"}}],[11,"eq","std::ffi","",133,{"inputs":[{"name":"self"},{"name":"pathbuf"}],"output":{"name":"bool"}}],[11,"partial_cmp","std::path","",214,{"inputs":[{"name":"self"},{"name":"osstr"}],"output":{"name":"option"}}],[11,"partial_cmp","std::ffi","",133,{"inputs":[{"name":"self"},{"name":"pathbuf"}],"output":{"name":"option"}}],[11,"eq","std::path","",214,{"inputs":[{"name":"self"},{"name":"osstr"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",214,{"inputs":[{"name":"self"},{"name":"osstr"}],"output":{"name":"option"}}],[11,"eq","","",214,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"bool"}}],[11,"eq","std::borrow","",72,{"inputs":[{"name":"self"},{"name":"pathbuf"}],"output":{"name":"bool"}}],[11,"partial_cmp","std::path","",214,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"option"}}],[11,"partial_cmp","std::borrow","",72,{"inputs":[{"name":"self"},{"name":"pathbuf"}],"output":{"name":"option"}}],[11,"eq","std::path","",214,{"inputs":[{"name":"self"},{"name":"osstring"}],"output":{"name":"bool"}}],[11,"eq","std::ffi","",132,{"inputs":[{"name":"self"},{"name":"pathbuf"}],"output":{"name":"bool"}}],[11,"partial_cmp","std::path","",214,{"inputs":[{"name":"self"},{"name":"osstring"}],"output":{"name":"option"}}],[11,"partial_cmp","std::ffi","",132,{"inputs":[{"name":"self"},{"name":"pathbuf"}],"output":{"name":"option"}}],[11,"eq","std::path","",215,{"inputs":[{"name":"self"},{"name":"osstr"}],"output":{"name":"bool"}}],[11,"eq","std::ffi","",133,{"inputs":[{"name":"self"},{"name":"path"}],"output":{"name":"bool"}}],[11,"partial_cmp","std::path","",215,{"inputs":[{"name":"self"},{"name":"osstr"}],"output":{"name":"option"}}],[11,"partial_cmp","std::ffi","",133,{"inputs":[{"name":"self"},{"name":"path"}],"output":{"name":"option"}}],[11,"eq","std::path","",215,{"inputs":[{"name":"self"},{"name":"osstr"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",215,{"inputs":[{"name":"self"},{"name":"osstr"}],"output":{"name":"option"}}],[11,"eq","","",215,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"bool"}}],[11,"eq","std::borrow","",72,{"inputs":[{"name":"self"},{"name":"path"}],"output":{"name":"bool"}}],[11,"partial_cmp","std::path","",215,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"option"}}],[11,"partial_cmp","std::borrow","",72,{"inputs":[{"name":"self"},{"name":"path"}],"output":{"name":"option"}}],[11,"eq","std::path","",215,{"inputs":[{"name":"self"},{"name":"osstring"}],"output":{"name":"bool"}}],[11,"eq","std::ffi","",132,{"inputs":[{"name":"self"},{"name":"path"}],"output":{"name":"bool"}}],[11,"partial_cmp","std::path","",215,{"inputs":[{"name":"self"},{"name":"osstring"}],"output":{"name":"option"}}],[11,"partial_cmp","std::ffi","",132,{"inputs":[{"name":"self"},{"name":"path"}],"output":{"name":"option"}}],[11,"eq","","",133,{"inputs":[{"name":"self"},{"name":"path"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",133,{"inputs":[{"name":"self"},{"name":"path"}],"output":{"name":"option"}}],[11,"eq","std::borrow","",72,{"inputs":[{"name":"self"},{"name":"path"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",72,{"inputs":[{"name":"self"},{"name":"path"}],"output":{"name":"option"}}],[11,"eq","std::ffi","",132,{"inputs":[{"name":"self"},{"name":"path"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",132,{"inputs":[{"name":"self"},{"name":"path"}],"output":{"name":"option"}}],[11,"eq","std::borrow","",72,{"inputs":[{"name":"self"},{"name":"osstr"}],"output":{"name":"bool"}}],[11,"eq","std::ffi","",133,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"bool"}}],[11,"partial_cmp","std::borrow","",72,{"inputs":[{"name":"self"},{"name":"osstr"}],"output":{"name":"option"}}],[11,"partial_cmp","std::ffi","",133,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"option"}}],[11,"eq","std::borrow","",72,{"inputs":[{"name":"self"},{"name":"osstr"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",72,{"inputs":[{"name":"self"},{"name":"osstr"}],"output":{"name":"option"}}],[11,"eq","","",72,{"inputs":[{"name":"self"},{"name":"osstring"}],"output":{"name":"bool"}}],[11,"eq","std::ffi","",132,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"bool"}}],[11,"partial_cmp","std::borrow","",72,{"inputs":[{"name":"self"},{"name":"osstring"}],"output":{"name":"option"}}],[11,"partial_cmp","std::ffi","",132,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"option"}}],[11,"fmt","std::path","",216,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"description","","",216,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[0,"process","std","A module for working with processes.",null,null],[3,"Child","std::process","Representation of a running or exited child process.",null,null],[12,"stdin","","The handle for writing to the child's stdin, if it has been captured",218,null],[12,"stdout","","The handle for reading from the child's stdout, if it has been captured",218,null],[12,"stderr","","The handle for reading from the child's stderr, if it has been captured",218,null],[3,"ChildStdin","","A handle to a child process's stdin. This struct is used in the [`stdin`] field on [`Child`].",null,null],[3,"ChildStdout","","A handle to a child process's stdout. This struct is used in the [`stdout`] field on [`Child`].",null,null],[3,"ChildStderr","","A handle to a child process's stderr. This struct is used in the [`stderr`] field on [`Child`].",null,null],[3,"Command","","A process builder, providing fine-grained control over how a new process should be spawned.",null,null],[3,"Output","","The output of a finished process.",null,null],[12,"status","","The status (exit code) of the process.",219,null],[12,"stdout","","The data that the process wrote to stdout.",219,null],[12,"stderr","","The data that the process wrote to stderr.",219,null],[3,"Stdio","","Describes what to do with a standard I/O stream for a child process.",null,null],[3,"ExitStatus","","Describes the result of a process after it has terminated.",null,null],[5,"exit","","Terminates the current process with the specified exit code.",null,null],[5,"abort","","Terminates the process in an abnormal fashion.",null,null],[11,"fmt","","",218,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"write","","",220,null],[11,"flush","","",220,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"fmt","","",220,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"read","","",221,null],[11,"read_to_end","","",221,{"inputs":[{"name":"self"},{"name":"vec"}],"output":{"name":"result"}}],[11,"fmt","","",221,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"read","","",222,null],[11,"read_to_end","","",222,{"inputs":[{"name":"self"},{"name":"vec"}],"output":{"name":"result"}}],[11,"fmt","","",222,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Constructs a new `Command` for launching the program at path `program`, with the following default configuration:",223,{"inputs":[{"name":"s"}],"output":{"name":"command"}}],[11,"arg","","Add an argument to pass to the program.",223,{"inputs":[{"name":"self"},{"name":"s"}],"output":{"name":"command"}}],[11,"args","","Add multiple arguments to pass to the program.",223,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"command"}}],[11,"env","","Inserts or updates an environment variable mapping.",223,{"inputs":[{"name":"self"},{"name":"k"},{"name":"v"}],"output":{"name":"command"}}],[11,"envs","","Add or update multiple environment variable mappings.",223,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"command"}}],[11,"env_remove","","Removes an environment variable mapping.",223,{"inputs":[{"name":"self"},{"name":"k"}],"output":{"name":"command"}}],[11,"env_clear","","Clears the entire environment map for the child process.",223,{"inputs":[{"name":"self"}],"output":{"name":"command"}}],[11,"current_dir","","Sets the working directory for the child process.",223,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"command"}}],[11,"stdin","","Configuration for the child process's stdin handle (file descriptor 0).",223,{"inputs":[{"name":"self"},{"name":"stdio"}],"output":{"name":"command"}}],[11,"stdout","","Configuration for the child process's stdout handle (file descriptor 1).",223,{"inputs":[{"name":"self"},{"name":"stdio"}],"output":{"name":"command"}}],[11,"stderr","","Configuration for the child process's stderr handle (file descriptor 2).",223,{"inputs":[{"name":"self"},{"name":"stdio"}],"output":{"name":"command"}}],[11,"spawn","","Executes the command as a child process, returning a handle to it.",223,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"output","","Executes the command as a child process, waiting for it to finish and collecting all of its output.",223,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"status","","Executes a command as a child process, waiting for it to finish and collecting its exit status.",223,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"fmt","","Format the program and arguments of a Command for display. Any non-utf8 data is lossily converted using the utf8 replacement character.",223,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",219,{"inputs":[{"name":"self"},{"name":"output"}],"output":{"name":"bool"}}],[11,"ne","","",219,{"inputs":[{"name":"self"},{"name":"output"}],"output":{"name":"bool"}}],[11,"clone","","",219,{"inputs":[{"name":"self"}],"output":{"name":"output"}}],[11,"fmt","","",219,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"piped","","A new pipe should be arranged to connect the parent and child processes.",224,{"inputs":[],"output":{"name":"stdio"}}],[11,"inherit","","The child inherits from the corresponding parent descriptor.",224,{"inputs":[],"output":{"name":"stdio"}}],[11,"null","","This stream will be ignored. This is the equivalent of attaching the stream to `/dev/null`",224,{"inputs":[],"output":{"name":"stdio"}}],[11,"fmt","","",224,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",225,{"inputs":[{"name":"self"},{"name":"exitstatus"}],"output":{"name":"bool"}}],[11,"ne","","",225,{"inputs":[{"name":"self"},{"name":"exitstatus"}],"output":{"name":"bool"}}],[11,"clone","","",225,{"inputs":[{"name":"self"}],"output":{"name":"exitstatus"}}],[11,"fmt","","",225,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"success","","Was termination successful? Signal termination not considered a success, and success is defined as a zero exit status.",225,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"code","","Returns the exit code of the process, if any.",225,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",225,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"kill","","Forces the child to exit. This is equivalent to sending a SIGKILL on unix platforms.",218,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"id","","Returns the OS-assigned process identifier associated with this child.",218,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"wait","","Waits for the child to exit completely, returning the status that it exited with. This function will continue to have the same return value after it has been called at least once.",218,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"try_wait","","Attempts to collect the exit status of the child if it has already exited.",218,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"wait_with_output","","Simultaneously waits for the child to exit and collect all remaining output on the stdout/stderr handles, returning an `Output` instance.",218,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[0,"sync","std","Useful synchronization primitives.",null,null],[3,"Arc","std::sync","A thread-safe reference-counting pointer.",null,null],[3,"Weak","","A weak version of [`Arc`][arc].",null,null],[0,"atomic","","Atomic types",null,null],[3,"AtomicBool","std::sync::atomic","A boolean type which can be safely shared between threads.",null,null],[3,"AtomicPtr","","A raw pointer type which can be safely shared between threads.",null,null],[4,"Ordering","","Atomic memory orderings",null,null],[13,"Relaxed","","No ordering constraints, only atomic operations. Corresponds to LLVM's `Monotonic` ordering.",226,null],[13,"Release","","When coupled with a store, all previous writes become visible to the other threads that perform a load with `Acquire` ordering on the same value.",226,null],[13,"Acquire","","When coupled with a load, all subsequent loads will see data written before a store with `Release` ordering on the same value in other threads.",226,null],[13,"AcqRel","","When coupled with a load, uses `Acquire` ordering, and with a store `Release` ordering.",226,null],[13,"SeqCst","","Like `AcqRel` with the additional guarantee that all threads see all sequentially consistent operations in the same order.",226,null],[17,"ATOMIC_BOOL_INIT","","An `AtomicBool` initialized to `false`.",null,null],[3,"AtomicI8","","An integer type which can be safely shared between threads.",null,null],[17,"ATOMIC_I8_INIT","","An atomic integer initialized to `0`.",null,null],[3,"AtomicU8","","An integer type which can be safely shared between threads.",null,null],[17,"ATOMIC_U8_INIT","","An atomic integer initialized to `0`.",null,null],[3,"AtomicI16","","An integer type which can be safely shared between threads.",null,null],[17,"ATOMIC_I16_INIT","","An atomic integer initialized to `0`.",null,null],[3,"AtomicU16","","An integer type which can be safely shared between threads.",null,null],[17,"ATOMIC_U16_INIT","","An atomic integer initialized to `0`.",null,null],[3,"AtomicI32","","An integer type which can be safely shared between threads.",null,null],[17,"ATOMIC_I32_INIT","","An atomic integer initialized to `0`.",null,null],[3,"AtomicU32","","An integer type which can be safely shared between threads.",null,null],[17,"ATOMIC_U32_INIT","","An atomic integer initialized to `0`.",null,null],[3,"AtomicI64","","An integer type which can be safely shared between threads.",null,null],[17,"ATOMIC_I64_INIT","","An atomic integer initialized to `0`.",null,null],[3,"AtomicU64","","An integer type which can be safely shared between threads.",null,null],[17,"ATOMIC_U64_INIT","","An atomic integer initialized to `0`.",null,null],[3,"AtomicIsize","","An integer type which can be safely shared between threads.",null,null],[17,"ATOMIC_ISIZE_INIT","","An atomic integer initialized to `0`.",null,null],[3,"AtomicUsize","","An integer type which can be safely shared between threads.",null,null],[17,"ATOMIC_USIZE_INIT","","An atomic integer initialized to `0`.",null,null],[5,"fence","","An atomic fence.",null,null],[3,"Barrier","std::sync","A barrier enables multiple threads to synchronize the beginning of some computation.",null,null],[3,"BarrierWaitResult","","A result returned from wait.",null,null],[3,"Condvar","","A Condition Variable",null,null],[3,"WaitTimeoutResult","","A type indicating whether a timed wait on a condition variable returned due to a time out or not.",null,null],[3,"Mutex","","A mutual exclusion primitive useful for protecting shared data",null,null],[3,"MutexGuard","","An RAII implementation of a \"scoped lock\" of a mutex. When this structure is dropped (falls out of scope), the lock will be unlocked.",null,null],[3,"Once","","A synchronization primitive which can be used to run a one-time global initialization. Useful for one-time initialization for FFI or related functionality. This type can only be constructed with the `ONCE_INIT` value.",null,null],[3,"OnceState","","State yielded to the `call_once_force` method which can be used to query whether the `Once` was previously poisoned or not.",null,null],[3,"PoisonError","","A type of error which can be returned whenever a lock is acquired.",null,null],[3,"RwLock","","A reader-writer lock",null,null],[3,"RwLockReadGuard","","RAII structure used to release the shared read access of a lock when dropped.",null,null],[3,"RwLockWriteGuard","","RAII structure used to release the exclusive write access of a lock when dropped.",null,null],[4,"TryLockError","","An enumeration of possible errors which can occur while calling the `try_lock` method.",null,null],[13,"Poisoned","","The lock could not be acquired because another thread failed while holding the lock.",227,null],[13,"WouldBlock","","The lock could not be acquired at this time because the operation would otherwise block.",227,null],[0,"mpsc","","Multi-producer, single-consumer FIFO queue communication primitives.",null,null],[3,"Select","std::sync::mpsc","The \"receiver set\" of the select interface. This structure is used to manage a set of receivers which are being selected over.",null,null],[3,"Handle","","A handle to a receiver which is currently a member of a `Select` set of receivers.  This handle is used to keep the receiver in the set as well as interact with the underlying receiver.",null,null],[3,"Receiver","","The receiving-half of Rust's channel type. This half can only be owned by one thread",null,null],[3,"Iter","","An iterator over messages on a receiver, this iterator will block whenever `next` is called, waiting for a new message, and `None` will be returned when the corresponding channel has hung up.",null,null],[3,"TryIter","","An iterator that attempts to yield all pending values for a receiver. `None` will be returned when there are no pending values remaining or if the corresponding channel has hung up.",null,null],[3,"IntoIter","","An owning iterator over messages on a receiver, this iterator will block whenever `next` is called, waiting for a new message, and `None` will be returned when the corresponding channel has hung up.",null,null],[3,"Sender","","The sending-half of Rust's asynchronous channel type. This half can only be owned by one thread, but it can be cloned to send to other threads.",null,null],[3,"SyncSender","","The sending-half of Rust's synchronous channel type. This half can only be owned by one thread, but it can be cloned to send to other threads.",null,null],[3,"SendError","","An error returned from the `send` function on channels.",null,null],[12,"0","","",228,null],[3,"RecvError","","An error returned from the `recv` function on a `Receiver`.",null,null],[4,"TryRecvError","","This enumeration is the list of the possible reasons that `try_recv` could not return data when called.",null,null],[13,"Empty","","This channel is currently empty, but the sender(s) have not yet disconnected, so data may yet become available.",229,null],[13,"Disconnected","","This channel's sending half has become disconnected, and there will never be any more data received on this channel",229,null],[4,"RecvTimeoutError","","This enumeration is the list of possible errors that `recv_timeout` could not return data when called.",null,null],[13,"Timeout","","This channel is currently empty, but the sender(s) have not yet disconnected, so data may yet become available.",230,null],[13,"Disconnected","","This channel's sending half has become disconnected, and there will never be any more data received on this channel",230,null],[4,"TrySendError","","This enumeration is the list of the possible error outcomes for the `SyncSender::try_send` method.",null,null],[13,"Full","","The data could not be sent on the channel because it would require that the callee block to send the data.",231,null],[13,"Disconnected","","This channel's receiving half has disconnected, so the data could not be sent. The data is returned back to the callee in this case.",231,null],[5,"channel","","Creates a new asynchronous channel, returning the sender/receiver halves. All data sent on the sender will become available on the receiver, and no send will block the calling thread (this channel has an \"infinite buffer\").",null,null],[5,"sync_channel","","Creates a new synchronous, bounded channel.",null,null],[11,"new","","Creates a new selection structure. This set is initially empty.",232,{"inputs":[],"output":{"name":"select"}}],[11,"handle","","Creates a new handle into this receiver set for a new receiver. Note that this does *not* add the receiver to the receiver set, for that you must call the `add` method on the handle itself.",232,{"inputs":[{"name":"self"},{"name":"receiver"}],"output":{"name":"handle"}}],[11,"wait","","Waits for an event on this receiver set. The returned value is *not* an index, but rather an id. This id can be queried against any active `Handle` structures (each one has an `id` method). The handle with the matching `id` will have some sort of event available on it. The event could either be that data is available or the corresponding channel has been closed.",232,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"id","","Retrieves the id of this handle.",233,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"recv","","Blocks to receive a value on the underlying receiver, returning `Some` on success or `None` if the channel disconnects. This function has the same semantics as `Receiver.recv`",233,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"add","","Adds this handle to the receiver set that the handle was created from. This method can be called multiple times, but it has no effect if `add` was called previously.",233,{"inputs":[{"name":"self"}],"output":null}],[11,"remove","","Removes this handle from the `Select` set. This method is unsafe because it has no guarantee that the `Handle` was not moved since `add` was called.",233,{"inputs":[{"name":"self"}],"output":null}],[11,"drop","","",232,{"inputs":[{"name":"self"}],"output":null}],[11,"drop","","",233,{"inputs":[{"name":"self"}],"output":null}],[11,"fmt","","",232,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",233,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",234,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",235,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",236,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",228,{"inputs":[{"name":"self"},{"name":"senderror"}],"output":{"name":"bool"}}],[11,"ne","","",228,{"inputs":[{"name":"self"},{"name":"senderror"}],"output":{"name":"bool"}}],[11,"clone","","",228,{"inputs":[{"name":"self"}],"output":{"name":"senderror"}}],[11,"eq","","",237,{"inputs":[{"name":"self"},{"name":"recverror"}],"output":{"name":"bool"}}],[11,"clone","","",237,{"inputs":[{"name":"self"}],"output":{"name":"recverror"}}],[11,"fmt","","",237,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",229,{"inputs":[{"name":"self"},{"name":"tryrecverror"}],"output":{"name":"bool"}}],[11,"clone","","",229,{"inputs":[{"name":"self"}],"output":{"name":"tryrecverror"}}],[11,"fmt","","",229,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",230,{"inputs":[{"name":"self"},{"name":"recvtimeouterror"}],"output":{"name":"bool"}}],[11,"clone","","",230,{"inputs":[{"name":"self"}],"output":{"name":"recvtimeouterror"}}],[11,"fmt","","",230,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",231,{"inputs":[{"name":"self"},{"name":"trysenderror"}],"output":{"name":"bool"}}],[11,"ne","","",231,{"inputs":[{"name":"self"},{"name":"trysenderror"}],"output":{"name":"bool"}}],[11,"clone","","",231,{"inputs":[{"name":"self"}],"output":{"name":"trysenderror"}}],[11,"send","","Attempts to send a value on this channel, returning it back if it could not be sent.",238,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"result"}}],[11,"clone","","",238,{"inputs":[{"name":"self"}],"output":{"name":"sender"}}],[11,"drop","","",238,{"inputs":[{"name":"self"}],"output":null}],[11,"fmt","","",238,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"send","","Sends a value on this synchronous channel.",239,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"result"}}],[11,"try_send","","Attempts to send a value on this channel without blocking.",239,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"result"}}],[11,"clone","","",239,{"inputs":[{"name":"self"}],"output":{"name":"syncsender"}}],[11,"drop","","",239,{"inputs":[{"name":"self"}],"output":null}],[11,"fmt","","",239,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"try_recv","","Attempts to return a pending value on this receiver without blocking",240,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"recv","","Attempts to wait for a value on this receiver, returning an error if the corresponding channel has hung up.",240,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"recv_timeout","","Attempts to wait for a value on this receiver, returning an error if the corresponding channel has hung up, or if it waits more than `timeout`.",240,{"inputs":[{"name":"self"},{"name":"duration"}],"output":{"name":"result"}}],[11,"iter","","Returns an iterator that will block waiting for messages, but never `panic!`. It will return `None` when the channel has hung up.",240,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"try_iter","","Returns an iterator that will attempt to yield all pending values. It will return `None` if there are no more pending values or if the channel has hung up. The iterator will never `panic!` or block the user by waiting for values.",240,{"inputs":[{"name":"self"}],"output":{"name":"tryiter"}}],[11,"next","","",234,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",235,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",236,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"into_iter","","",240,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"drop","","",240,{"inputs":[{"name":"self"}],"output":null}],[11,"fmt","","",240,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",228,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",228,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"description","","",228,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"cause","","",228,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",231,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",231,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"description","","",231,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"cause","","",231,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",237,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"description","","",237,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"cause","","",237,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",229,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"description","","",229,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"cause","","",229,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",230,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"description","","",230,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"cause","","",230,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","std::sync","",241,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new barrier that can block a given number of threads.",241,{"inputs":[{"name":"usize"}],"output":{"name":"barrier"}}],[11,"wait","","Blocks the current thread until all threads have rendezvoused here.",241,{"inputs":[{"name":"self"}],"output":{"name":"barrierwaitresult"}}],[11,"fmt","","",242,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"is_leader","","Returns whether this thread from [`wait`] is the \"leader thread\".",242,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"fmt","","",243,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",243,{"inputs":[{"name":"self"},{"name":"waittimeoutresult"}],"output":{"name":"bool"}}],[11,"ne","","",243,{"inputs":[{"name":"self"},{"name":"waittimeoutresult"}],"output":{"name":"bool"}}],[11,"clone","","",243,{"inputs":[{"name":"self"}],"output":{"name":"waittimeoutresult"}}],[11,"timed_out","","Returns whether the wait was known to have timed out.",243,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"new","","Creates a new condition variable which is ready to be waited on and notified.",244,{"inputs":[],"output":{"name":"condvar"}}],[11,"wait","","Blocks the current thread until this condition variable receives a notification.",244,{"inputs":[{"name":"self"},{"name":"mutexguard"}],"output":{"name":"lockresult"}}],[11,"wait_timeout_ms","","Waits on this condition variable for a notification, timing out after a specified duration.",244,{"inputs":[{"name":"self"},{"name":"mutexguard"},{"name":"u32"}],"output":{"name":"lockresult"}}],[11,"wait_timeout","","Waits on this condition variable for a notification, timing out after a specified duration.",244,{"inputs":[{"name":"self"},{"name":"mutexguard"},{"name":"duration"}],"output":{"name":"lockresult"}}],[11,"notify_one","","Wakes up one blocked thread on this condvar.",244,{"inputs":[{"name":"self"}],"output":null}],[11,"notify_all","","Wakes up all blocked threads on this condvar.",244,{"inputs":[{"name":"self"}],"output":null}],[11,"fmt","","",244,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"default","","Creates a `Condvar` which is ready to be waited on and notified.",244,{"inputs":[],"output":{"name":"condvar"}}],[11,"drop","","",244,{"inputs":[{"name":"self"}],"output":null}],[11,"new","","Creates a new mutex in an unlocked state ready for use.",245,{"inputs":[{"name":"t"}],"output":{"name":"mutex"}}],[11,"lock","","Acquires a mutex, blocking the current thread until it is able to do so.",245,{"inputs":[{"name":"self"}],"output":{"name":"lockresult"}}],[11,"try_lock","","Attempts to acquire this lock.",245,{"inputs":[{"name":"self"}],"output":{"name":"trylockresult"}}],[11,"is_poisoned","","Determines whether the lock is poisoned.",245,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"into_inner","","Consumes this mutex, returning the underlying data.",245,{"inputs":[{"name":"self"}],"output":{"name":"lockresult"}}],[11,"get_mut","","Returns a mutable reference to the underlying data.",245,{"inputs":[{"name":"self"}],"output":{"name":"lockresult"}}],[11,"drop","","",245,{"inputs":[{"name":"self"}],"output":null}],[11,"default","","Creates a `Mutex<T>`, with the `Default` value for T.",245,{"inputs":[],"output":{"name":"mutex"}}],[11,"fmt","","",245,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"deref","","",246,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"deref_mut","","",246,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"drop","","",246,{"inputs":[{"name":"self"}],"output":null}],[11,"fmt","","",246,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",247,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new `Once` value.",248,{"inputs":[],"output":{"name":"once"}}],[11,"call_once","","Performs an initialization routine once and only once. The given closure will be executed if this is the first time `call_once` has been called, and otherwise the routine will *not* be invoked.",248,{"inputs":[{"name":"self"},{"name":"f"}],"output":null}],[11,"call_once_force","","Performs the same function as `call_once` except ignores poisoning.",248,{"inputs":[{"name":"self"},{"name":"f"}],"output":null}],[11,"fmt","","",248,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"poisoned","","Returns whether the associated `Once` has been poisoned.",247,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"new","","Creates a new instance of an `RwLock<T>` which is unlocked.",249,{"inputs":[{"name":"t"}],"output":{"name":"rwlock"}}],[11,"read","","Locks this rwlock with shared read access, blocking the current thread until it can be acquired.",249,{"inputs":[{"name":"self"}],"output":{"name":"lockresult"}}],[11,"try_read","","Attempts to acquire this rwlock with shared read access.",249,{"inputs":[{"name":"self"}],"output":{"name":"trylockresult"}}],[11,"write","","Locks this rwlock with exclusive write access, blocking the current thread until it can be acquired.",249,{"inputs":[{"name":"self"}],"output":{"name":"lockresult"}}],[11,"try_write","","Attempts to lock this rwlock with exclusive write access.",249,{"inputs":[{"name":"self"}],"output":{"name":"trylockresult"}}],[11,"is_poisoned","","Determines whether the lock is poisoned.",249,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"into_inner","","Consumes this `RwLock`, returning the underlying data.",249,{"inputs":[{"name":"self"}],"output":{"name":"lockresult"}}],[11,"get_mut","","Returns a mutable reference to the underlying data.",249,{"inputs":[{"name":"self"}],"output":{"name":"lockresult"}}],[11,"drop","","",249,{"inputs":[{"name":"self"}],"output":null}],[11,"fmt","","",249,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"default","","Creates a new `RwLock<T>`, with the `Default` value for T.",249,{"inputs":[],"output":{"name":"rwlock"}}],[11,"fmt","","",250,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",251,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"deref","","",250,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"deref","","",251,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"deref_mut","","",251,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"drop","","",250,{"inputs":[{"name":"self"}],"output":null}],[11,"drop","","",251,{"inputs":[{"name":"self"}],"output":null}],[6,"TryLockResult","","A type alias for the result of a nonblocking locking method.",null,null],[6,"LockResult","","A type alias for the result of a lock method which can be poisoned.",null,null],[17,"ONCE_INIT","","Initialization value for static `Once` values.",null,null],[0,"time","std","Temporal quantification.",null,null],[3,"Duration","std::time","A `Duration` type to represent a span of time, typically used for system timeouts.",null,null],[3,"Instant","","A measurement of a monotonically increasing clock. Opaque and useful only with `Duration`.",null,null],[3,"SystemTime","","A measurement of the system clock, useful for talking to external entities like the file system or other processes.",null,null],[3,"SystemTimeError","","An error returned from the `duration_since` and `elapsed` methods on `SystemTime`, used to learn how far in the opposite direction a system time lies.",null,null],[11,"clone","","",252,{"inputs":[{"name":"self"}],"output":{"name":"duration"}}],[11,"eq","","",252,{"inputs":[{"name":"self"},{"name":"duration"}],"output":{"name":"bool"}}],[11,"ne","","",252,{"inputs":[{"name":"self"},{"name":"duration"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",252,{"inputs":[{"name":"self"},{"name":"duration"}],"output":{"name":"option"}}],[11,"lt","","",252,{"inputs":[{"name":"self"},{"name":"duration"}],"output":{"name":"bool"}}],[11,"le","","",252,{"inputs":[{"name":"self"},{"name":"duration"}],"output":{"name":"bool"}}],[11,"gt","","",252,{"inputs":[{"name":"self"},{"name":"duration"}],"output":{"name":"bool"}}],[11,"ge","","",252,{"inputs":[{"name":"self"},{"name":"duration"}],"output":{"name":"bool"}}],[11,"cmp","","",252,{"inputs":[{"name":"self"},{"name":"duration"}],"output":{"name":"ordering"}}],[11,"fmt","","",252,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",252,null],[11,"default","","",252,{"inputs":[],"output":{"name":"duration"}}],[11,"new","","Creates a new `Duration` from the specified number of seconds and additional nanosecond precision.",252,{"inputs":[{"name":"u64"},{"name":"u32"}],"output":{"name":"duration"}}],[11,"from_secs","","Creates a new `Duration` from the specified number of seconds.",252,{"inputs":[{"name":"u64"}],"output":{"name":"duration"}}],[11,"from_millis","","Creates a new `Duration` from the specified number of milliseconds.",252,{"inputs":[{"name":"u64"}],"output":{"name":"duration"}}],[11,"as_secs","","Returns the number of whole seconds represented by this `Duration`.",252,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"subsec_nanos","","Returns the nanosecond precision represented by this `Duration`.",252,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"checked_add","","Checked `Duration` addition. Computes `self + other`, returning [`None`] if overflow occurred.",252,{"inputs":[{"name":"self"},{"name":"duration"}],"output":{"name":"option"}}],[11,"checked_sub","","Checked `Duration` subtraction. Computes `self - other`, returning [`None`] if the result would be negative or if underflow occurred.",252,{"inputs":[{"name":"self"},{"name":"duration"}],"output":{"name":"option"}}],[11,"checked_mul","","Checked `Duration` multiplication. Computes `self * other`, returning [`None`] if overflow occurred.",252,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"option"}}],[11,"checked_div","","Checked `Duration` division. Computes `self / other`, returning [`None`] if `other == 0`.",252,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"option"}}],[11,"add","","",252,{"inputs":[{"name":"self"},{"name":"duration"}],"output":{"name":"duration"}}],[11,"add_assign","","",252,{"inputs":[{"name":"self"},{"name":"duration"}],"output":null}],[11,"sub","","",252,{"inputs":[{"name":"self"},{"name":"duration"}],"output":{"name":"duration"}}],[11,"sub_assign","","",252,{"inputs":[{"name":"self"},{"name":"duration"}],"output":null}],[11,"mul","","",252,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"duration"}}],[11,"mul_assign","","",252,{"inputs":[{"name":"self"},{"name":"u32"}],"output":null}],[11,"div","","",252,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"duration"}}],[11,"div_assign","","",252,{"inputs":[{"name":"self"},{"name":"u32"}],"output":null}],[11,"sum","","",252,{"inputs":[{"name":"i"}],"output":{"name":"duration"}}],[11,"sum","","",252,{"inputs":[{"name":"i"}],"output":{"name":"duration"}}],[17,"UNIX_EPOCH","","An anchor in time which can be used to create new `SystemTime` instances or learn about where in time a `SystemTime` lies.",null,null],[11,"clone","","",253,{"inputs":[{"name":"self"}],"output":{"name":"instant"}}],[11,"eq","","",253,{"inputs":[{"name":"self"},{"name":"instant"}],"output":{"name":"bool"}}],[11,"ne","","",253,{"inputs":[{"name":"self"},{"name":"instant"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",253,{"inputs":[{"name":"self"},{"name":"instant"}],"output":{"name":"option"}}],[11,"lt","","",253,{"inputs":[{"name":"self"},{"name":"instant"}],"output":{"name":"bool"}}],[11,"le","","",253,{"inputs":[{"name":"self"},{"name":"instant"}],"output":{"name":"bool"}}],[11,"gt","","",253,{"inputs":[{"name":"self"},{"name":"instant"}],"output":{"name":"bool"}}],[11,"ge","","",253,{"inputs":[{"name":"self"},{"name":"instant"}],"output":{"name":"bool"}}],[11,"cmp","","",253,{"inputs":[{"name":"self"},{"name":"instant"}],"output":{"name":"ordering"}}],[11,"clone","","",254,{"inputs":[{"name":"self"}],"output":{"name":"systemtime"}}],[11,"eq","","",254,{"inputs":[{"name":"self"},{"name":"systemtime"}],"output":{"name":"bool"}}],[11,"ne","","",254,{"inputs":[{"name":"self"},{"name":"systemtime"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",254,{"inputs":[{"name":"self"},{"name":"systemtime"}],"output":{"name":"option"}}],[11,"lt","","",254,{"inputs":[{"name":"self"},{"name":"systemtime"}],"output":{"name":"bool"}}],[11,"le","","",254,{"inputs":[{"name":"self"},{"name":"systemtime"}],"output":{"name":"bool"}}],[11,"gt","","",254,{"inputs":[{"name":"self"},{"name":"systemtime"}],"output":{"name":"bool"}}],[11,"ge","","",254,{"inputs":[{"name":"self"},{"name":"systemtime"}],"output":{"name":"bool"}}],[11,"cmp","","",254,{"inputs":[{"name":"self"},{"name":"systemtime"}],"output":{"name":"ordering"}}],[11,"clone","","",255,{"inputs":[{"name":"self"}],"output":{"name":"systemtimeerror"}}],[11,"fmt","","",255,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"now","","Returns an instant corresponding to \"now\".",253,{"inputs":[],"output":{"name":"instant"}}],[11,"duration_since","","Returns the amount of time elapsed from another instant to this one.",253,{"inputs":[{"name":"self"},{"name":"instant"}],"output":{"name":"duration"}}],[11,"elapsed","","Returns the amount of time elapsed since this instant was created.",253,{"inputs":[{"name":"self"}],"output":{"name":"duration"}}],[11,"add","","",253,{"inputs":[{"name":"self"},{"name":"duration"}],"output":{"name":"instant"}}],[11,"add_assign","","",253,{"inputs":[{"name":"self"},{"name":"duration"}],"output":null}],[11,"sub","","",253,{"inputs":[{"name":"self"},{"name":"duration"}],"output":{"name":"instant"}}],[11,"sub_assign","","",253,{"inputs":[{"name":"self"},{"name":"duration"}],"output":null}],[11,"sub","","",253,{"inputs":[{"name":"self"},{"name":"instant"}],"output":{"name":"duration"}}],[11,"fmt","","",253,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"now","","Returns the system time corresponding to \"now\".",254,{"inputs":[],"output":{"name":"systemtime"}}],[11,"duration_since","","Returns the amount of time elapsed from an earlier point in time.",254,{"inputs":[{"name":"self"},{"name":"systemtime"}],"output":{"name":"result"}}],[11,"elapsed","","Returns the amount of time elapsed since this system time was created.",254,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"add","","",254,{"inputs":[{"name":"self"},{"name":"duration"}],"output":{"name":"systemtime"}}],[11,"add_assign","","",254,{"inputs":[{"name":"self"},{"name":"duration"}],"output":null}],[11,"sub","","",254,{"inputs":[{"name":"self"},{"name":"duration"}],"output":{"name":"systemtime"}}],[11,"sub_assign","","",254,{"inputs":[{"name":"self"},{"name":"duration"}],"output":null}],[11,"fmt","","",254,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"duration","","Returns the positive duration which represents how far forward the second system time was from the first.",255,{"inputs":[{"name":"self"}],"output":{"name":"duration"}}],[11,"description","","",255,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"fmt","","",255,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::sync","",256,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",256,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"description","","",256,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"new","","Creates a `PoisonError`.",256,{"inputs":[{"name":"t"}],"output":{"name":"poisonerror"}}],[11,"into_inner","","Consumes this error indicating that a lock is poisoned, returning the underlying guard to allow access regardless.",256,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"get_ref","","Reaches into this error indicating that a lock is poisoned, returning a reference to the underlying guard to allow access regardless.",256,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"get_mut","","Reaches into this error indicating that a lock is poisoned, returning a mutable reference to the underlying guard to allow access regardless.",256,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"from","","",227,{"inputs":[{"name":"poisonerror"}],"output":{"name":"trylockerror"}}],[11,"fmt","","",227,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",227,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"description","","",227,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"cause","","",227,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"as_raw_fd","std::fs","",141,{"inputs":[{"name":"self"}],"output":{"name":"rawfd"}}],[11,"from_raw_fd","","",141,{"inputs":[{"name":"rawfd"}],"output":{"name":"file"}}],[11,"into_raw_fd","","",141,{"inputs":[{"name":"self"}],"output":{"name":"rawfd"}}],[11,"as_raw_fd","std::net","",180,{"inputs":[{"name":"self"}],"output":{"name":"rawfd"}}],[11,"as_raw_fd","","",181,{"inputs":[{"name":"self"}],"output":{"name":"rawfd"}}],[11,"as_raw_fd","","",182,{"inputs":[{"name":"self"}],"output":{"name":"rawfd"}}],[11,"from_raw_fd","","",180,{"inputs":[{"name":"rawfd"}],"output":{"name":"tcpstream"}}],[11,"from_raw_fd","","",181,{"inputs":[{"name":"rawfd"}],"output":{"name":"tcplistener"}}],[11,"from_raw_fd","","",182,{"inputs":[{"name":"rawfd"}],"output":{"name":"udpsocket"}}],[11,"into_raw_fd","","",180,{"inputs":[{"name":"self"}],"output":{"name":"rawfd"}}],[11,"into_raw_fd","","",181,{"inputs":[{"name":"self"}],"output":{"name":"rawfd"}}],[11,"into_raw_fd","","",182,{"inputs":[{"name":"self"}],"output":{"name":"rawfd"}}],[11,"from_vec","std::ffi","",132,{"inputs":[{"name":"vec"}],"output":{"name":"osstring"}}],[11,"into_vec","","",132,{"inputs":[{"name":"self"}],"output":{"name":"vec"}}],[11,"from_bytes","","",133,null],[11,"as_bytes","","",133,null],[11,"read_at","std::fs","",141,null],[11,"write_at","","",141,null],[11,"mode","","",138,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"set_mode","","",138,{"inputs":[{"name":"self"},{"name":"u32"}],"output":null}],[11,"from_mode","","",138,{"inputs":[{"name":"u32"}],"output":{"name":"permissions"}}],[11,"mode","","",137,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"openoptions"}}],[11,"custom_flags","","",137,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"openoptions"}}],[11,"dev","","",135,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"ino","","",135,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"mode","","",135,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"nlink","","",135,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"uid","","",135,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"gid","","",135,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"rdev","","",135,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"size","","",135,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"atime","","",135,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[11,"atime_nsec","","",135,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[11,"mtime","","",135,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[11,"mtime_nsec","","",135,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[11,"ctime","","",135,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[11,"ctime_nsec","","",135,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[11,"blksize","","",135,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"blocks","","",135,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"is_block_device","","",139,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_char_device","","",139,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_fifo","","",139,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_socket","","",139,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"ino","","",142,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"mode","","",140,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"dirbuilder"}}],[11,"uid","std::process","",223,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"command"}}],[11,"gid","","",223,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"command"}}],[11,"before_exec","","",223,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"command"}}],[11,"exec","","",223,{"inputs":[{"name":"self"}],"output":{"name":"error"}}],[11,"from_raw","","",225,{"inputs":[{"name":"i32"}],"output":{"name":"self"}}],[11,"signal","","",225,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"from_raw_fd","","",224,{"inputs":[{"name":"rawfd"}],"output":{"name":"stdio"}}],[11,"as_raw_fd","","",220,{"inputs":[{"name":"self"}],"output":{"name":"rawfd"}}],[11,"as_raw_fd","","",221,{"inputs":[{"name":"self"}],"output":{"name":"rawfd"}}],[11,"as_raw_fd","","",222,{"inputs":[{"name":"self"}],"output":{"name":"rawfd"}}],[11,"into_raw_fd","","",220,{"inputs":[{"name":"self"}],"output":{"name":"rawfd"}}],[11,"into_raw_fd","","",221,{"inputs":[{"name":"self"}],"output":{"name":"rawfd"}}],[11,"into_raw_fd","","",222,{"inputs":[{"name":"self"}],"output":{"name":"rawfd"}}],[11,"as_pthread_t","std::thread","",98,{"inputs":[{"name":"self"}],"output":{"name":"rawpthread"}}],[11,"into_pthread_t","","",98,{"inputs":[{"name":"self"}],"output":{"name":"rawpthread"}}],[11,"clone","std::os::unix::net","",257,{"inputs":[{"name":"self"}],"output":{"name":"socketaddr"}}],[11,"is_unnamed","","Returns true if and only if the address is unnamed.",257,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"as_pathname","","Returns the contents of this address if it is a `pathname` address.",257,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",257,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",258,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"connect","","Connects to the socket named by `path`.",258,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[11,"pair","","Creates an unnamed pair of connected sockets.",258,{"inputs":[],"output":{"name":"result"}}],[11,"try_clone","","Creates a new independently owned handle to the underlying socket.",258,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"local_addr","","Returns the socket address of the local half of this connection.",258,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"peer_addr","","Returns the socket address of the remote half of this connection.",258,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"set_read_timeout","","Sets the read timeout for the socket.",258,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"name":"result"}}],[11,"set_write_timeout","","Sets the write timeout for the socket.",258,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"name":"result"}}],[11,"read_timeout","","Returns the read timeout of this socket.",258,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"write_timeout","","Returns the write timeout of this socket.",258,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"set_nonblocking","","Moves the socket into or out of nonblocking mode.",258,{"inputs":[{"name":"self"},{"name":"bool"}],"output":{"name":"result"}}],[11,"take_error","","Returns the value of the `SO_ERROR` option.",258,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"shutdown","","Shuts down the read, write, or both halves of this connection.",258,{"inputs":[{"name":"self"},{"name":"shutdown"}],"output":{"name":"result"}}],[11,"read","","",258,null],[11,"read_to_end","","",258,{"inputs":[{"name":"self"},{"name":"vec"}],"output":{"name":"result"}}],[11,"write","","",258,null],[11,"flush","","",258,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"as_raw_fd","","",258,{"inputs":[{"name":"self"}],"output":{"name":"rawfd"}}],[11,"from_raw_fd","","",258,{"inputs":[{"name":"rawfd"}],"output":{"name":"unixstream"}}],[11,"into_raw_fd","","",258,{"inputs":[{"name":"self"}],"output":{"name":"rawfd"}}],[11,"fmt","","",259,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"bind","","Creates a new `UnixListener` bound to the specified socket.",259,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[11,"accept","","Accepts a new incoming connection to this listener.",259,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"try_clone","","Creates a new independently owned handle to the underlying socket.",259,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"local_addr","","Returns the local socket address of this listener.",259,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"set_nonblocking","","Moves the socket into or out of nonblocking mode.",259,{"inputs":[{"name":"self"},{"name":"bool"}],"output":{"name":"result"}}],[11,"take_error","","Returns the value of the `SO_ERROR` option.",259,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"incoming","","Returns an iterator over incoming connections.",259,{"inputs":[{"name":"self"}],"output":{"name":"incoming"}}],[11,"as_raw_fd","","",259,{"inputs":[{"name":"self"}],"output":{"name":"rawfd"}}],[11,"from_raw_fd","","",259,{"inputs":[{"name":"rawfd"}],"output":{"name":"unixlistener"}}],[11,"into_raw_fd","","",259,{"inputs":[{"name":"self"}],"output":{"name":"rawfd"}}],[11,"fmt","","",260,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next","","",260,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",260,null],[11,"fmt","","",261,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"bind","","Creates a Unix datagram socket bound to the given path.",261,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[11,"unbound","","Creates a Unix Datagram socket which is not bound to any address.",261,{"inputs":[],"output":{"name":"result"}}],[11,"pair","","Create an unnamed pair of connected sockets.",261,{"inputs":[],"output":{"name":"result"}}],[11,"connect","","Connects the socket to the specified address.",261,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"result"}}],[11,"try_clone","","Creates a new independently owned handle to the underlying socket.",261,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"local_addr","","Returns the address of this socket.",261,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"peer_addr","","Returns the address of this socket's peer.",261,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"recv_from","","Receives data from the socket.",261,null],[11,"recv","","Receives data from the socket.",261,null],[11,"send_to","","Sends data on the socket to the specified address.",261,null],[11,"send","","Sends data on the socket to the socket's peer.",261,null],[11,"set_read_timeout","","Sets the read timeout for the socket.",261,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"name":"result"}}],[11,"set_write_timeout","","Sets the write timeout for the socket.",261,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"name":"result"}}],[11,"read_timeout","","Returns the read timeout of this socket.",261,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"write_timeout","","Returns the write timeout of this socket.",261,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"set_nonblocking","","Moves the socket into or out of nonblocking mode.",261,{"inputs":[{"name":"self"},{"name":"bool"}],"output":{"name":"result"}}],[11,"take_error","","Returns the value of the `SO_ERROR` option.",261,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"shutdown","","Shut down the read, write, or both halves of this connection.",261,{"inputs":[{"name":"self"},{"name":"shutdown"}],"output":{"name":"result"}}],[11,"as_raw_fd","","",261,{"inputs":[{"name":"self"}],"output":{"name":"rawfd"}}],[11,"from_raw_fd","","",261,{"inputs":[{"name":"rawfd"}],"output":{"name":"unixdatagram"}}],[11,"into_raw_fd","","",261,{"inputs":[{"name":"self"}],"output":{"name":"rawfd"}}],[11,"fmt","std::panic","",262,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"payload","","Returns the payload associated with the panic.",262,{"inputs":[{"name":"self"}],"output":{"name":"any"}}],[11,"location","","Returns information about the location from which the panic originated, if available.",262,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",263,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"file","","Returns the name of the source file from which the panic originated.",263,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"line","","Returns the line number from which the panic originated.",263,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[14,"format","std","Use the syntax described in `std::fmt` to create a value of type `String`. See [`std::fmt`][fmt] for more information.",null,null],[14,"vec","","Creates a `Vec` containing the arguments.",null,null],[14,"try","","Helper macro for reducing boilerplate code for matching `Result` together with converting downstream errors.",null,null],[14,"writeln","","Write formatted data into a buffer, with a newline appended.",null,null],[14,"write","","Write formatted data into a buffer",null,null],[14,"unimplemented","","A standardized placeholder for marking unfinished code. It panics with the message `\"not yet implemented\"` when executed.",null,null],[14,"unreachable","","A utility macro for indicating unreachable code.",null,null],[14,"debug_assert_ne","","Asserts that two expressions are not equal to each other.",null,null],[14,"debug_assert_eq","","Asserts that two expressions are equal to each other.",null,null],[14,"debug_assert","","Ensure that a boolean expression is `true` at runtime.",null,null],[14,"assert_ne","","Asserts that two expressions are not equal to each other.",null,null],[14,"assert_eq","","Asserts that two expressions are equal to each other.",null,null],[14,"assert","","Ensure that a boolean expression is `true` at runtime.",null,null],[14,"panic","","The entry point for panic of Rust threads.",null,null],[14,"print","","Macro for printing to the standard output.",null,null],[14,"println","","Macro for printing to the standard output, with a newline. On all platforms, the newline is the LINE FEED character (`\\n`/`U+000A`) alone (no additional CARRIAGE RETURN (`\\r`/`U+000D`).",null,null],[14,"select","","A macro to select an event from a number of receivers.",null,null],[14,"format_args","","The core macro for formatted string creation & output.",null,null],[14,"env","","Inspect an environment variable at compile time.",null,null],[14,"option_env","","Optionally inspect an environment variable at compile time.",null,null],[14,"concat_idents","","Concatenate identifiers into one identifier.",null,null],[14,"concat","","Concatenates literals into a static string slice.",null,null],[14,"line","","A macro which expands to the line number on which it was invoked.",null,null],[14,"column","","A macro which expands to the column number on which it was invoked.",null,null],[14,"file","","A macro which expands to the file name from which it was invoked.",null,null],[14,"stringify","","A macro which stringifies its argument.",null,null],[14,"include_str","","Includes a utf8-encoded file as a string.",null,null],[14,"include_bytes","","Includes a file as a reference to a byte array.",null,null],[14,"module_path","","Expands to a string that represents the current module path.",null,null],[14,"cfg","","Boolean evaluation of configuration flags.",null,null],[14,"include","","Parse a file as an expression or an item according to the context.",null,null],[14,"thread_local","","Declare a new thread local storage key of type `std::thread::LocalKey`.",null,null],[15,"bool","","The boolean type.",null,null],[15,"char","","A character type.",null,null],[15,"pointer","","Raw, unsafe pointers, `*const T`, and `*mut T`.",null,null],[15,"array","","A fixed-size array, denoted `[T; N]`, for the element type, `T`, and the non-negative compile-time constant size, `N`.",null,null],[15,"slice","","A dynamically-sized view into a contiguous sequence, `[T]`.",null,null],[15,"str","","String slices.",null,null],[15,"tuple","","A finite heterogeneous sequence, `(T, U, ..)`.",null,null],[15,"f32","","The 32-bit floating point type.",null,null],[15,"f64","","The 64-bit floating point type.",null,null],[15,"i8","","The 8-bit signed integer type.",null,null],[15,"i16","","The 16-bit signed integer type.",null,null],[15,"i32","","The 32-bit signed integer type.",null,null],[15,"i64","","The 64-bit signed integer type.",null,null],[15,"i128","","The 128-bit signed integer type.",null,null],[15,"u8","","The 8-bit unsigned integer type.",null,null],[15,"u16","","The 16-bit unsigned integer type.",null,null],[15,"u32","","The 32-bit unsigned integer type.",null,null],[15,"u64","","The 64-bit unsigned integer type.",null,null],[15,"u128","","The 128-bit unsigned integer type.",null,null],[15,"isize","","The pointer-sized signed integer type.",null,null],[15,"usize","","The pointer-sized unsigned integer type.",null,null],[11,"is","std::any","Returns true if the boxed type is the same as `T`.",0,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"downcast_ref","","Returns some reference to the boxed value if it is of type `T`, or `None` if it isn't.",0,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"downcast_mut","","Returns some mutable reference to the boxed value if it is of type `T`, or `None` if it isn't.",0,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"is","","Forwards to the method defined on the type `Any`.",0,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"downcast_ref","","Forwards to the method defined on the type `Any`.",0,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"downcast_mut","","Forwards to the method defined on the type `Any`.",0,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"low","std","",264,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"high","","",264,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"from_parts","","",264,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"u128"}}],[11,"low","","",265,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"high","","",265,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[11,"from_parts","","",265,{"inputs":[{"name":"u64"},{"name":"i64"}],"output":{"name":"i128"}}],[11,"make_place","std::collections::linked_list","",266,{"inputs":[{"name":"self"}],"output":{"name":"frontplace"}}],[11,"make_place","","",267,{"inputs":[{"name":"self"}],"output":{"name":"backplace"}}],[11,"make_place","std::vec","",268,{"inputs":[{"name":"self"}],"output":{"name":"placeback"}}],[11,"make_place","std::collections::vec_deque","",269,{"inputs":[{"name":"self"}],"output":{"name":"placeback"}}],[11,"make_place","","",270,{"inputs":[{"name":"self"}],"output":{"name":"placefront"}}],[11,"from_iter","std::collections::binary_heap","",271,{"inputs":[{"name":"i"}],"output":{"name":"binaryheap"}}],[11,"from_iter","std::collections::btree_map","",272,{"inputs":[{"name":"t"}],"output":{"name":"btreemap"}}],[11,"from_iter","std::collections::btree_set","",273,{"inputs":[{"name":"i"}],"output":{"name":"btreeset"}}],[11,"from_iter","std::collections::linked_list","",274,{"inputs":[{"name":"i"}],"output":{"name":"linkedlist"}}],[11,"from_iter","std::string","",134,{"inputs":[{"name":"i"}],"output":{"name":"string"}}],[11,"from_iter","","",134,{"inputs":[{"name":"i"}],"output":{"name":"string"}}],[11,"from_iter","","",134,{"inputs":[{"name":"i"}],"output":{"name":"string"}}],[11,"from_iter","","",134,{"inputs":[{"name":"i"}],"output":{"name":"string"}}],[11,"from_iter","std::borrow","",72,{"inputs":[{"name":"i"}],"output":{"name":"cow"}}],[11,"from_iter","","",72,{"inputs":[{"name":"i"}],"output":{"name":"cow"}}],[11,"from_iter","","",72,{"inputs":[{"name":"i"}],"output":{"name":"cow"}}],[11,"from_iter","std::vec","",131,{"inputs":[{"name":"i"}],"output":{"name":"vec"}}],[11,"from_iter","std::borrow","",72,{"inputs":[{"name":"i"}],"output":{"name":"cow"}}],[11,"from_iter","std::collections::vec_deque","",275,{"inputs":[{"name":"t"}],"output":{"name":"vecdeque"}}],[11,"write_str","std::string","",134,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"result"}}],[11,"write_char","","",134,{"inputs":[{"name":"self"},{"name":"char"}],"output":{"name":"result"}}],[11,"borrow_mut","std::vec","",131,null],[11,"to_owned","std","",276,{"inputs":[{"name":"self"}],"output":{"name":"vec"}}],[11,"to_owned","","",277,{"inputs":[{"name":"self"}],"output":{"name":"string"}}],[11,"cmp","std::collections::btree_map","",272,{"inputs":[{"name":"self"},{"name":"btreemap"}],"output":{"name":"ordering"}}],[11,"cmp","std::borrow","",72,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"ordering"}}],[11,"cmp","std::collections::linked_list","",274,{"inputs":[{"name":"self"},{"name":"linkedlist"}],"output":{"name":"ordering"}}],[11,"cmp","std::vec","",131,{"inputs":[{"name":"self"},{"name":"vec"}],"output":{"name":"ordering"}}],[11,"cmp","std::collections::vec_deque","",275,{"inputs":[{"name":"self"},{"name":"vecdeque"}],"output":{"name":"ordering"}}],[11,"cmp","std::collections::btree_set","",273,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"ordering"}}],[11,"cmp","std::string","",134,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"ordering"}}],[11,"concat","std","",276,{"inputs":[{"name":"self"}],"output":{"name":"vec"}}],[11,"join","","",276,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"vec"}}],[11,"connect","","",276,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"vec"}}],[11,"concat","","",276,{"inputs":[{"name":"self"}],"output":{"name":"string"}}],[11,"join","","",276,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"string"}}],[11,"connect","","",276,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"string"}}],[11,"start","std::ops","",278,{"inputs":[{"name":"self"}],"output":{"name":"bound"}}],[11,"end","","",278,{"inputs":[{"name":"self"}],"output":{"name":"bound"}}],[11,"start","","",52,{"inputs":[{"name":"self"}],"output":{"name":"bound"}}],[11,"end","","",52,{"inputs":[{"name":"self"}],"output":{"name":"bound"}}],[11,"start","","",53,{"inputs":[{"name":"self"}],"output":{"name":"bound"}}],[11,"end","","",53,{"inputs":[{"name":"self"}],"output":{"name":"bound"}}],[11,"start","","",51,{"inputs":[{"name":"self"}],"output":{"name":"bound"}}],[11,"end","","",51,{"inputs":[{"name":"self"}],"output":{"name":"bound"}}],[11,"start","","",54,{"inputs":[{"name":"self"}],"output":{"name":"bound"}}],[11,"end","","",54,{"inputs":[{"name":"self"}],"output":{"name":"bound"}}],[11,"start","","",55,{"inputs":[{"name":"self"}],"output":{"name":"bound"}}],[11,"end","","",55,{"inputs":[{"name":"self"}],"output":{"name":"bound"}}],[11,"start","std","",279,{"inputs":[{"name":"self"}],"output":{"name":"bound"}}],[11,"end","","",279,{"inputs":[{"name":"self"}],"output":{"name":"bound"}}],[11,"start","","",279,{"inputs":[{"name":"self"}],"output":{"name":"bound"}}],[11,"end","","",279,{"inputs":[{"name":"self"}],"output":{"name":"bound"}}],[11,"clone","std::collections::binary_heap","",271,{"inputs":[{"name":"self"}],"output":{"name":"binaryheap"}}],[11,"clone_from","","",271,null],[11,"clone","","",280,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"clone","std::collections::btree_map","",272,{"inputs":[{"name":"self"}],"output":{"name":"btreemap"}}],[11,"clone","","",281,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"clone","","",282,{"inputs":[{"name":"self"}],"output":{"name":"keys"}}],[11,"clone","","",283,{"inputs":[{"name":"self"}],"output":{"name":"values"}}],[11,"clone","","",284,{"inputs":[{"name":"self"}],"output":{"name":"range"}}],[11,"clone","std::collections::btree_set","",285,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"clone","","",286,{"inputs":[{"name":"self"}],"output":{"name":"range"}}],[11,"clone","","",287,{"inputs":[{"name":"self"}],"output":{"name":"difference"}}],[11,"clone","","",288,{"inputs":[{"name":"self"}],"output":{"name":"symmetricdifference"}}],[11,"clone","","",289,{"inputs":[{"name":"self"}],"output":{"name":"intersection"}}],[11,"clone","","",290,{"inputs":[{"name":"self"}],"output":{"name":"union"}}],[11,"clone","std::borrow","",72,{"inputs":[{"name":"self"}],"output":{"name":"cow"}}],[11,"clone","std::collections::linked_list","",291,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"clone","","",274,{"inputs":[{"name":"self"}],"output":{"name":"linkedlist"}}],[11,"clone","std::string","",134,{"inputs":[{"name":"self"}],"output":{"name":"string"}}],[11,"clone_from","","",134,null],[11,"clone","","",120,{"inputs":[{"name":"self"}],"output":{"name":"parseerror"}}],[11,"clone","std::vec","",131,{"inputs":[{"name":"self"}],"output":{"name":"vec"}}],[11,"clone_from","","",131,null],[11,"clone","","",292,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"clone","std::collections::vec_deque","",275,{"inputs":[{"name":"self"}],"output":{"name":"vecdeque"}}],[11,"clone","","",293,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"clone","std::collections::binary_heap","",294,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"clone","std::collections::btree_set","",273,{"inputs":[{"name":"self"}],"output":{"name":"btreeset"}}],[11,"clone","std::collections::linked_list","",295,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"clone","std::str","",296,{"inputs":[{"name":"self"}],"output":{"name":"encodeutf16"}}],[11,"clone","std::collections::vec_deque","",297,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"clone","std::collections","",101,{"inputs":[{"name":"self"}],"output":{"name":"bound"}}],[11,"extend","std::collections::binary_heap","",271,null],[11,"extend","","",271,null],[11,"extend","std::collections::btree_map","",272,null],[11,"extend","","",272,null],[11,"extend","std::collections::btree_set","",273,null],[11,"extend","","",273,null],[11,"extend","std::collections::linked_list","",274,null],[11,"extend","","",274,null],[11,"extend","std::string","",134,null],[11,"extend","","",134,null],[11,"extend","","",134,null],[11,"extend","","",134,null],[11,"extend","std::vec","",131,null],[11,"extend","","",131,null],[11,"extend","std::collections::vec_deque","",275,null],[11,"extend","","",275,null],[11,"next_back","std::collections::binary_heap","",280,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",294,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",298,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","std::collections::btree_map","",281,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",299,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",300,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",282,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",283,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",301,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",284,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",302,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","std::collections::btree_set","",285,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",303,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",286,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","std::collections::linked_list","",291,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",304,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",295,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","std::string","",305,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","std::vec","",292,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",306,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","std::collections::vec_deque","",293,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",307,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",297,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",308,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"add_assign","std::borrow","",72,null],[11,"add_assign","","",72,null],[11,"add_assign","std::string","",134,null],[11,"hash","std::collections::btree_map","",272,null],[11,"hash","std::borrow","",72,null],[11,"hash","std::collections::linked_list","",274,null],[11,"hash","std::string","",134,null],[11,"hash","std::vec","",131,null],[11,"hash","std::collections::vec_deque","",275,null],[11,"hash","std::collections::btree_set","",273,null],[11,"hash","std::collections","",101,null],[11,"finalize","std::collections::binary_heap","",309,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"finalize","std::collections::linked_list","",266,null],[11,"finalize","","",267,null],[11,"finalize","std::vec","",268,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"finalize","std::collections::vec_deque","",269,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"finalize","","",270,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"index","std::collections::btree_map","",272,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"v"}}],[11,"index","std::string","",134,{"inputs":[{"name":"self"},{"name":"range"}],"output":{"name":"str"}}],[11,"index","","",134,{"inputs":[{"name":"self"},{"name":"rangeto"}],"output":{"name":"str"}}],[11,"index","","",134,{"inputs":[{"name":"self"},{"name":"rangefrom"}],"output":{"name":"str"}}],[11,"index","","",134,{"inputs":[{"name":"self"},{"name":"rangefull"}],"output":{"name":"str"}}],[11,"index","","",134,{"inputs":[{"name":"self"},{"name":"rangeinclusive"}],"output":{"name":"str"}}],[11,"index","","",134,{"inputs":[{"name":"self"},{"name":"rangetoinclusive"}],"output":{"name":"str"}}],[11,"index","std::vec","",131,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"t"}}],[11,"index","","",131,null],[11,"index","","",131,null],[11,"index","","",131,null],[11,"index","","",131,null],[11,"index","","",131,null],[11,"index","","",131,null],[11,"index","std::collections::vec_deque","",275,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"a"}}],[11,"index_mut","std::string","",134,{"inputs":[{"name":"self"},{"name":"range"}],"output":{"name":"str"}}],[11,"index_mut","","",134,{"inputs":[{"name":"self"},{"name":"rangeto"}],"output":{"name":"str"}}],[11,"index_mut","","",134,{"inputs":[{"name":"self"},{"name":"rangefrom"}],"output":{"name":"str"}}],[11,"index_mut","","",134,{"inputs":[{"name":"self"},{"name":"rangefull"}],"output":{"name":"str"}}],[11,"index_mut","","",134,{"inputs":[{"name":"self"},{"name":"rangeinclusive"}],"output":{"name":"str"}}],[11,"index_mut","","",134,{"inputs":[{"name":"self"},{"name":"rangetoinclusive"}],"output":{"name":"str"}}],[11,"index_mut","std::vec","",131,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"t"}}],[11,"index_mut","","",131,null],[11,"index_mut","","",131,null],[11,"index_mut","","",131,null],[11,"index_mut","","",131,null],[11,"index_mut","","",131,null],[11,"index_mut","","",131,null],[11,"index_mut","std::collections::vec_deque","",275,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"a"}}],[11,"deref","std::collections::binary_heap","",310,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"deref","std::borrow","",72,{"inputs":[{"name":"self"}],"output":{"name":"b"}}],[11,"len","std","Returns the length of `self`.",277,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","Returns true if this slice has a length of zero bytes.",277,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_char_boundary","","Checks that `index`-th byte lies at the start and/or end of a UTF-8 code point sequence.",277,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"bool"}}],[11,"as_bytes","","Converts a string slice to a byte slice.",277,null],[11,"as_ptr","","Converts a string slice to a raw pointer.",277,null],[11,"slice_unchecked","","Creates a string slice from another string slice, bypassing safety checks.",277,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"usize"}],"output":{"name":"str"}}],[11,"slice_mut_unchecked","","Creates a string slice from another string slice, bypassing safety checks.",277,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"usize"}],"output":{"name":"str"}}],[11,"split_at","","Divide one string slice into two at an index.",277,null],[11,"split_at_mut","","Divide one mutable string slice into two at an index.",277,null],[11,"chars","","Returns an iterator over the `char`s of a string slice.",277,{"inputs":[{"name":"self"}],"output":{"name":"chars"}}],[11,"char_indices","","Returns an iterator over the [`char`]s of a string slice, and their positions.",277,{"inputs":[{"name":"self"}],"output":{"name":"charindices"}}],[11,"bytes","","An iterator over the bytes of a string slice.",277,{"inputs":[{"name":"self"}],"output":{"name":"bytes"}}],[11,"split_whitespace","","Split a string slice by whitespace.",277,{"inputs":[{"name":"self"}],"output":{"name":"splitwhitespace"}}],[11,"lines","","An iterator over the lines of a string, as string slices.",277,{"inputs":[{"name":"self"}],"output":{"name":"lines"}}],[11,"lines_any","","An iterator over the lines of a string.",277,{"inputs":[{"name":"self"}],"output":{"name":"linesany"}}],[11,"encode_utf16","","Returns an iterator of `u16` over the string encoded as UTF-16.",277,{"inputs":[{"name":"self"}],"output":{"name":"encodeutf16"}}],[11,"contains","","Returns `true` if the given pattern matches a sub-slice of this string slice.",277,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"bool"}}],[11,"starts_with","","Returns `true` if the given pattern matches a prefix of this string slice.",277,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"bool"}}],[11,"ends_with","","Returns `true` if the given pattern matches a suffix of this string slice.",277,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"bool"}}],[11,"find","","Returns the byte index of the first character of this string slice that matches the pattern.",277,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"option"}}],[11,"rfind","","Returns the byte index of the last character of this string slice that matches the pattern.",277,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"option"}}],[11,"split","","An iterator over substrings of this string slice, separated by characters matched by a pattern.",277,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"split"}}],[11,"rsplit","","An iterator over substrings of the given string slice, separated by characters matched by a pattern and yielded in reverse order.",277,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"rsplit"}}],[11,"split_terminator","","An iterator over substrings of the given string slice, separated by characters matched by a pattern.",277,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"splitterminator"}}],[11,"rsplit_terminator","","An iterator over substrings of `self`, separated by characters matched by a pattern and yielded in reverse order.",277,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"rsplitterminator"}}],[11,"splitn","","An iterator over substrings of the given string slice, separated by a pattern, restricted to returning at most `n` items.",277,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"p"}],"output":{"name":"splitn"}}],[11,"rsplitn","","An iterator over substrings of this string slice, separated by a pattern, starting from the end of the string, restricted to returning at most `n` items.",277,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"p"}],"output":{"name":"rsplitn"}}],[11,"matches","","An iterator over the matches of a pattern within the given string slice.",277,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"matches"}}],[11,"rmatches","","An iterator over the matches of a pattern within this string slice, yielded in reverse order.",277,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"rmatches"}}],[11,"match_indices","","An iterator over the disjoint matches of a pattern within this string slice as well as the index that the match starts at.",277,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"matchindices"}}],[11,"rmatch_indices","","An iterator over the disjoint matches of a pattern within `self`, yielded in reverse order along with the index of the match.",277,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"rmatchindices"}}],[11,"trim","","Returns a string slice with leading and trailing whitespace removed.",277,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"trim_left","","Returns a string slice with leading whitespace removed.",277,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"trim_right","","Returns a string slice with trailing whitespace removed.",277,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"trim_matches","","Returns a string slice with all prefixes and suffixes that match a pattern repeatedly removed.",277,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"str"}}],[11,"trim_left_matches","","Returns a string slice with all prefixes that match a pattern repeatedly removed.",277,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"str"}}],[11,"trim_right_matches","","Returns a string slice with all suffixes that match a pattern repeatedly removed.",277,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"str"}}],[11,"parse","","Parses this string slice into another type.",277,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"replace","","Replaces all matches of a pattern with another string.",277,{"inputs":[{"name":"self"},{"name":"p"},{"name":"str"}],"output":{"name":"string"}}],[11,"replacen","","Replaces first N matches of a pattern with another string.",277,{"inputs":[{"name":"self"},{"name":"p"},{"name":"str"},{"name":"usize"}],"output":{"name":"string"}}],[11,"to_lowercase","","Returns the lowercase equivalent of this string slice, as a new [`String`].",277,{"inputs":[{"name":"self"}],"output":{"name":"string"}}],[11,"to_uppercase","","Returns the uppercase equivalent of this string slice, as a new [`String`].",277,{"inputs":[{"name":"self"}],"output":{"name":"string"}}],[11,"escape_debug","","Escapes each char in `s` with `char::escape_debug`.",277,{"inputs":[{"name":"self"}],"output":{"name":"string"}}],[11,"escape_default","","Escapes each char in `s` with `char::escape_default`.",277,{"inputs":[{"name":"self"}],"output":{"name":"string"}}],[11,"escape_unicode","","Escapes each char in `s` with `char::escape_unicode`.",277,{"inputs":[{"name":"self"}],"output":{"name":"string"}}],[11,"into_string","","Converts a `Box<str>` into a [`String`] without copying or allocating.",277,{"inputs":[{"name":"box"}],"output":{"name":"string"}}],[11,"repeat","","Create a [`String`] by repeating a string `n` times.",277,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"string"}}],[11,"deref","std::string","",134,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"len","std","Returns the number of elements in the slice.",276,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","Returns `true` if the slice has a length of 0.",276,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"first","","Returns the first element of a slice, or `None` if it is empty.",276,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"first_mut","","Returns a mutable pointer to the first element of a slice, or `None` if it is empty.",276,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"split_first","","Returns the first and all the rest of the elements of a slice.",276,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"split_first_mut","","Returns the first and all the rest of the elements of a slice.",276,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"split_last","","Returns the last and all the rest of the elements of a slice.",276,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"split_last_mut","","Returns the last and all the rest of the elements of a slice.",276,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"last","","Returns the last element of a slice, or `None` if it is empty.",276,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"last_mut","","Returns a mutable pointer to the last item in the slice.",276,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"get","","Returns a reference to an element or subslice depending on the type of index.",276,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"option"}}],[11,"get_mut","","Returns a mutable reference to an element or subslice depending on the type of index (see [`get()`]) or `None` if the index is out of bounds.",276,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"option"}}],[11,"get_unchecked","","Returns a reference to an element or subslice, without doing bounds checking. So use it very carefully!",276,null],[11,"get_unchecked_mut","","Returns a mutable reference to an element or subslice, without doing bounds checking. So use it very carefully!",276,null],[11,"as_ptr","","Returns a raw pointer to the slice's buffer.",276,null],[11,"as_mut_ptr","","Returns an unsafe mutable pointer to the slice's buffer.",276,null],[11,"swap","","Swaps two elements in a slice.",276,null],[11,"reverse","","Reverses the order of elements in a slice, in place.",276,null],[11,"iter","","Returns an iterator over the slice.",276,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"iter_mut","","Returns an iterator that allows modifying each value.",276,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"windows","","Returns an iterator over all contiguous windows of length `size`. The windows overlap. If the slice is shorter than `size`, the iterator returns no values.",276,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"windows"}}],[11,"chunks","","Returns an iterator over `size` elements of the slice at a time. The chunks are slices and do not overlap. If `size` does not divide the length of the slice, then the last chunk will not have length `size`.",276,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"chunks"}}],[11,"chunks_mut","","Returns an iterator over `chunk_size` elements of the slice at a time. The chunks are mutable slices, and do not overlap. If `chunk_size` does not divide the length of the slice, then the last chunk will not have length `chunk_size`.",276,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"chunksmut"}}],[11,"split_at","","Divides one slice into two at an index.",276,null],[11,"split_at_mut","","Divides one `&mut` into two at an index.",276,null],[11,"split","","Returns an iterator over subslices separated by elements that match `pred`. The matched element is not contained in the subslices.",276,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"split"}}],[11,"split_mut","","Returns an iterator over mutable subslices separated by elements that match `pred`. The matched element is not contained in the subslices.",276,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"splitmut"}}],[11,"splitn","","Returns an iterator over subslices separated by elements that match `pred`, limited to returning at most `n` items. The matched element is not contained in the subslices.",276,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"f"}],"output":{"name":"splitn"}}],[11,"splitn_mut","","Returns an iterator over subslices separated by elements that match `pred`, limited to returning at most `n` items. The matched element is not contained in the subslices.",276,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"f"}],"output":{"name":"splitnmut"}}],[11,"rsplitn","","Returns an iterator over subslices separated by elements that match `pred` limited to returning at most `n` items. This starts at the end of the slice and works backwards.  The matched element is not contained in the subslices.",276,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"f"}],"output":{"name":"rsplitn"}}],[11,"rsplitn_mut","","Returns an iterator over subslices separated by elements that match `pred` limited to returning at most `n` items. This starts at the end of the slice and works backwards. The matched element is not contained in the subslices.",276,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"f"}],"output":{"name":"rsplitnmut"}}],[11,"contains","","Returns `true` if the slice contains an element with the given value.",276,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"bool"}}],[11,"starts_with","","Returns `true` if `needle` is a prefix of the slice.",276,null],[11,"ends_with","","Returns `true` if `needle` is a suffix of the slice.",276,null],[11,"binary_search","","Binary search a sorted slice for a given element.",276,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"result"}}],[11,"binary_search_by","","Binary search a sorted slice with a comparator function.",276,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"result"}}],[11,"binary_search_by_key","","Binary search a sorted slice with a key extraction function.",276,{"inputs":[{"name":"self"},{"name":"b"},{"name":"f"}],"output":{"name":"result"}}],[11,"sort","","Sorts the slice.",276,null],[11,"sort_by_key","","Sorts the slice using `f` to extract a key to compare elements by.",276,null],[11,"sort_by","","Sorts the slice using `compare` to compare elements.",276,null],[11,"clone_from_slice","","Copies the elements from `src` into `self`.",276,null],[11,"copy_from_slice","","Copies all elements from `src` into `self`, using a memcpy.",276,null],[11,"to_vec","","Copies `self` into a new `Vec`.",276,{"inputs":[{"name":"self"}],"output":{"name":"vec"}}],[11,"into_vec","","Converts `self` into a vector without clones or allocation.",276,{"inputs":[{"name":"box"}],"output":{"name":"vec"}}],[11,"deref","std::vec","",131,null],[11,"eq","std::collections::btree_map","",272,{"inputs":[{"name":"self"},{"name":"btreemap"}],"output":{"name":"bool"}}],[11,"eq","std::borrow","",72,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"bool"}}],[11,"eq","std::collections::linked_list","",274,{"inputs":[{"name":"self"},{"name":"linkedlist"}],"output":{"name":"bool"}}],[11,"ne","","",274,{"inputs":[{"name":"self"},{"name":"linkedlist"}],"output":{"name":"bool"}}],[11,"eq","std::string","",134,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"bool"}}],[11,"ne","","",134,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"bool"}}],[11,"eq","","",120,{"inputs":[{"name":"self"},{"name":"parseerror"}],"output":{"name":"bool"}}],[11,"eq","std::collections::vec_deque","",275,{"inputs":[{"name":"self"},{"name":"vecdeque"}],"output":{"name":"bool"}}],[11,"eq","std::collections::btree_set","",273,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"ne","","",273,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"eq","std::string","",134,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"ne","","",134,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"eq","std","",277,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"bool"}}],[11,"ne","","",277,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"bool"}}],[11,"eq","std::string","",134,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"ne","","",134,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"eq","std","",277,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"bool"}}],[11,"ne","","",277,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"bool"}}],[11,"eq","std::borrow","",72,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"ne","","",72,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"eq","std","",277,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"bool"}}],[11,"ne","","",277,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"bool"}}],[11,"eq","std::borrow","",72,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"ne","","",72,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"eq","std","",277,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"bool"}}],[11,"ne","","",277,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"bool"}}],[11,"eq","std::borrow","",72,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"bool"}}],[11,"ne","","",72,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"bool"}}],[11,"eq","std::string","",134,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"bool"}}],[11,"ne","","",134,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"bool"}}],[11,"eq","std::vec","",131,{"inputs":[{"name":"self"},{"name":"vec"}],"output":{"name":"bool"}}],[11,"ne","","",131,{"inputs":[{"name":"self"},{"name":"vec"}],"output":{"name":"bool"}}],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","std::borrow","",72,null],[11,"ne","","",72,null],[11,"eq","","",72,null],[11,"ne","","",72,null],[11,"eq","","",72,{"inputs":[{"name":"self"},{"name":"vec"}],"output":{"name":"bool"}}],[11,"ne","","",72,{"inputs":[{"name":"self"},{"name":"vec"}],"output":{"name":"bool"}}],[11,"eq","std::vec","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","std::collections::vec_deque","",275,{"inputs":[{"name":"self"},{"name":"vec"}],"output":{"name":"bool"}}],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","","",275,null],[11,"eq","std::collections","",101,{"inputs":[{"name":"self"},{"name":"bound"}],"output":{"name":"bool"}}],[11,"ne","","",101,{"inputs":[{"name":"self"},{"name":"bound"}],"output":{"name":"bool"}}],[11,"from_str","std::string","",134,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"pointer","std::collections::binary_heap","",309,null],[11,"pointer","std::collections::linked_list","",266,null],[11,"pointer","","",267,null],[11,"pointer","std::vec","",268,null],[11,"pointer","std::collections::vec_deque","",269,null],[11,"pointer","","",270,null],[11,"to_string","std","",277,{"inputs":[{"name":"self"}],"output":{"name":"string"}}],[11,"to_string","std::borrow","",72,{"inputs":[{"name":"self"}],"output":{"name":"string"}}],[11,"to_string","std::string","",134,{"inputs":[{"name":"self"}],"output":{"name":"string"}}],[11,"default","std::collections::binary_heap","Creates an empty `BinaryHeap<T>`.",271,{"inputs":[],"output":{"name":"binaryheap"}}],[11,"default","std::collections::btree_map","Creates an empty `BTreeMap<K, V>`.",272,{"inputs":[],"output":{"name":"btreemap"}}],[11,"default","std::collections::btree_set","Makes an empty `BTreeSet<T>` with a reasonable choice of B.",273,{"inputs":[],"output":{"name":"btreeset"}}],[11,"default","std::borrow","Creates an owned Cow<'a, B> with the default value for the contained owned value.",72,{"inputs":[],"output":{"name":"cow"}}],[11,"default","std::collections::linked_list","Creates an empty `LinkedList<T>`.",274,{"inputs":[],"output":{"name":"linkedlist"}}],[11,"default","std::string","Creates an empty `String`.",134,{"inputs":[],"output":{"name":"string"}}],[11,"default","std::vec","Creates an empty `Vec<T>`.",131,{"inputs":[],"output":{"name":"vec"}}],[11,"default","std::collections::vec_deque","Creates an empty `VecDeque<T>`.",275,{"inputs":[],"output":{"name":"vecdeque"}}],[11,"partial_cmp","std::collections::btree_map","",272,{"inputs":[{"name":"self"},{"name":"btreemap"}],"output":{"name":"option"}}],[11,"partial_cmp","std::borrow","",72,{"inputs":[{"name":"self"},{"name":"cow"}],"output":{"name":"option"}}],[11,"partial_cmp","std::collections::linked_list","",274,{"inputs":[{"name":"self"},{"name":"linkedlist"}],"output":{"name":"option"}}],[11,"partial_cmp","std::vec","",131,{"inputs":[{"name":"self"},{"name":"vec"}],"output":{"name":"option"}}],[11,"partial_cmp","std::collections::vec_deque","",275,{"inputs":[{"name":"self"},{"name":"vecdeque"}],"output":{"name":"option"}}],[11,"partial_cmp","std::collections::btree_set","",273,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"option"}}],[11,"lt","","",273,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"le","","",273,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"gt","","",273,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"ge","","",273,{"inputs":[{"name":"self"},{"name":"btreeset"}],"output":{"name":"bool"}}],[11,"partial_cmp","std::string","",134,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"option"}}],[11,"lt","","",134,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"bool"}}],[11,"le","","",134,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"bool"}}],[11,"gt","","",134,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"bool"}}],[11,"ge","","",134,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"bool"}}],[11,"borrow","std::borrow","",72,{"inputs":[{"name":"self"}],"output":{"name":"b"}}],[11,"borrow","std::vec","",131,null],[11,"borrow","std::string","",134,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"add","std::borrow","",72,null],[11,"add","","",72,null],[11,"add","std::string","",134,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"string"}}],[11,"as_ref","std::borrow","",72,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"as_ref","std::string","",134,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"as_ref","","",134,null],[11,"as_ref","std::vec","",131,{"inputs":[{"name":"self"}],"output":{"name":"vec"}}],[11,"as_ref","","",131,null],[11,"fmt","std::collections::binary_heap","",310,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",271,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",280,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",294,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",309,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::collections::btree_map","",281,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",300,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",282,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",283,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",284,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",302,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",102,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",311,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",312,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",272,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::collections::btree_set","",285,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",287,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",288,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",289,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",290,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",273,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::borrow","",72,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::collections::linked_list","",291,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",304,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",295,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",274,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",266,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",267,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::str","",296,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::string","",134,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",120,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",305,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::vec","",131,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",292,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",306,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::collections::vec_deque","",293,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",307,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",297,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",308,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",275,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::collections::binary_heap","",298,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::collections::btree_map","",299,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",301,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::collections::btree_set","",303,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",286,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::string","",118,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",119,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::vec","",268,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::collections::vec_deque","",269,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",270,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::collections","",101,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"deref_mut","std::collections::binary_heap","",310,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"deref_mut","std::string","",134,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"deref_mut","std::vec","",131,null],[11,"fmt","std::borrow","",72,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::string","",118,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",119,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",134,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",120,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"into_iter","std::collections::binary_heap","Creates a consuming iterator, that is, one that moves each value out of the binary heap in arbitrary order. The binary heap cannot be used after calling this.",271,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"into_iter","std::collections::btree_map","",272,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"into_iter","std::collections::btree_set","Gets an iterator for moving out the BtreeSet's contents.",273,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"into_iter","std::collections::linked_list","Consumes the list into an iterator yielding elements by value.",274,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"into_iter","std::vec","Creates a consuming iterator, that is, one that moves each value out of the vector (from start to end). The vector cannot be used after calling this.",131,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"into_iter","std::collections::vec_deque","Consumes the list into a front-to-back iterator yielding elements by value.",275,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"from","std::collections::binary_heap","",271,{"inputs":[{"name":"vec"}],"output":{"name":"binaryheap"}}],[11,"from","std::vec","",131,{"inputs":[{"name":"binaryheap"}],"output":{"name":"vec"}}],[11,"from","std::string","",134,{"inputs":[{"name":"str"}],"output":{"name":"string"}}],[11,"from","","",134,{"inputs":[{"name":"cow"}],"output":{"name":"string"}}],[11,"from","std::borrow","",72,{"inputs":[{"name":"str"}],"output":{"name":"cow"}}],[11,"from","","",72,{"inputs":[{"name":"string"}],"output":{"name":"cow"}}],[11,"from","std::vec","",131,{"inputs":[{"name":"string"}],"output":{"name":"vec"}}],[11,"from","","",131,null],[11,"from","","",131,{"inputs":[{"name":"cow"}],"output":{"name":"vec"}}],[11,"from","","",131,{"inputs":[{"name":"str"}],"output":{"name":"vec"}}],[11,"from","std::borrow","",72,null],[11,"from","","",72,{"inputs":[{"name":"vec"}],"output":{"name":"cow"}}],[11,"from","std::collections::vec_deque","",275,{"inputs":[{"name":"vec"}],"output":{"name":"vecdeque"}}],[11,"from","std::vec","",131,{"inputs":[{"name":"vecdeque"}],"output":{"name":"vec"}}],[11,"next","std::collections::binary_heap","",280,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",280,null],[11,"next","","",294,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",294,null],[11,"next","","",298,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",298,null],[11,"next","std::collections::btree_map","",281,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",281,null],[11,"next","","",299,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",299,null],[11,"next","","",300,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",300,null],[11,"next","","",282,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",282,null],[11,"next","","",283,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",283,null],[11,"next","","",284,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",301,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",301,null],[11,"next","","",302,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","std::collections::btree_set","",285,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",285,null],[11,"next","","",303,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",303,null],[11,"next","","",286,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",287,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",287,null],[11,"next","","",288,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",288,null],[11,"next","","",289,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",289,null],[11,"next","","",290,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",290,null],[11,"next","std::collections::linked_list","",291,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",291,null],[11,"next","","",304,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",304,null],[11,"next","","",295,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",295,null],[11,"next","std::str","",296,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",296,null],[11,"next","std::string","",305,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",305,null],[11,"next","std::vec","",292,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",292,null],[11,"count","","",292,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"next","","",306,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",306,null],[11,"next","std::collections::vec_deque","",293,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",293,null],[11,"fold","","",293,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"f"}],"output":{"name":"acc"}}],[11,"next","","",307,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",307,null],[11,"fold","","",307,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"f"}],"output":{"name":"acc"}}],[11,"next","","",297,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",297,null],[11,"next","","",308,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",308,null],[11,"is_empty","std::collections::binary_heap","",280,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_empty","","",294,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_empty","","",298,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"len","std::collections::btree_map","",281,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"len","","",299,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"len","","",300,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"len","","",282,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"len","","",283,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"len","","",301,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"len","std::collections::btree_set","",285,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"len","","",303,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","std::vec","",292,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_empty","","",306,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_empty","std::collections::vec_deque","",293,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_empty","","",307,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_empty","","",297,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"drop","std::collections::binary_heap","",310,null],[11,"drop","std::collections::btree_map","",272,null],[11,"drop","","",300,null],[11,"drop","std::collections::linked_list","",274,null],[11,"drop","std::string","",305,null],[11,"drop","std::vec","",131,null],[11,"drop","","",292,null],[11,"drop","","",306,null],[11,"drop","std::collections::vec_deque","",275,null],[11,"drop","","",308,null],[11,"as_mut","std::vec","",131,{"inputs":[{"name":"self"}],"output":{"name":"vec"}}],[11,"as_mut","","",131,null],[11,"as_mut","std::boxed","",115,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"make_place","","",313,{"inputs":[],"output":{"name":"intermediatebox"}}],[11,"make_place","","",314,{"inputs":[{"name":"self"}],"output":{"name":"intermediatebox"}}],[11,"borrow_mut","","",115,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"fmt","","",115,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::sync","",315,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::rc","",316,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"cmp","std::boxed","",115,{"inputs":[{"name":"self"},{"name":"box"}],"output":{"name":"ordering"}}],[11,"cmp","std::sync","Comparison for two `Arc`s.",315,{"inputs":[{"name":"self"},{"name":"arc"}],"output":{"name":"ordering"}}],[11,"cmp","std::rc","Comparison for two `Rc`s.",316,{"inputs":[{"name":"self"},{"name":"rc"}],"output":{"name":"ordering"}}],[11,"clone","std::boxed","Returns a new box with a `clone()` of this box's contents.",115,{"inputs":[{"name":"self"}],"output":{"name":"box"}}],[11,"clone_from","","Copies `source`'s contents into `self` without creating a new allocation.",115,null],[11,"clone","","",115,{"inputs":[{"name":"self"}],"output":{"name":"box"}}],[11,"clone","","",115,{"inputs":[{"name":"self"}],"output":{"name":"box"}}],[11,"clone","std::sync","Makes a clone of the `Arc` pointer.",315,{"inputs":[{"name":"self"}],"output":{"name":"arc"}}],[11,"clone","","Makes a clone of the `Weak` pointer.",317,{"inputs":[{"name":"self"}],"output":{"name":"weak"}}],[11,"clone","std::rc","Makes a clone of the `Rc` pointer.",316,{"inputs":[{"name":"self"}],"output":{"name":"rc"}}],[11,"clone","","Makes a clone of the `Weak` pointer.",318,{"inputs":[{"name":"self"}],"output":{"name":"weak"}}],[11,"clone","std::boxed","",314,{"inputs":[{"name":"self"}],"output":{"name":"exchangeheapsingleton"}}],[11,"next_back","","",115,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"hash","","",115,null],[11,"hash","std::sync","",315,null],[11,"hash","std::rc","",316,null],[11,"finalize","std::boxed","",313,{"inputs":[{"name":"self"}],"output":{"name":"box"}}],[11,"deref","","",115,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"deref","std::sync","",315,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"deref","std::rc","",316,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"eq","std::boxed","",115,{"inputs":[{"name":"self"},{"name":"box"}],"output":{"name":"bool"}}],[11,"ne","","",115,{"inputs":[{"name":"self"},{"name":"box"}],"output":{"name":"bool"}}],[11,"eq","std::sync","Equality for two `Arc`s.",315,{"inputs":[{"name":"self"},{"name":"arc"}],"output":{"name":"bool"}}],[11,"ne","","Inequality for two `Arc`s.",315,{"inputs":[{"name":"self"},{"name":"arc"}],"output":{"name":"bool"}}],[11,"eq","std::rc","Equality for two `Rc`s.",316,{"inputs":[{"name":"self"},{"name":"rc"}],"output":{"name":"bool"}}],[11,"ne","","Inequality for two `Rc`s.",316,{"inputs":[{"name":"self"},{"name":"rc"}],"output":{"name":"bool"}}],[11,"pointer","std::boxed","",313,null],[11,"default","","Creates a `Box<T>`, with the `Default` value for T.",115,{"inputs":[],"output":{"name":"box"}}],[11,"default","","",115,{"inputs":[],"output":{"name":"box"}}],[11,"default","","",115,{"inputs":[],"output":{"name":"box"}}],[11,"default","std::sync","Constructs a new `Weak<T>`, without an accompanying instance of `T`.",317,{"inputs":[],"output":{"name":"weak"}}],[11,"default","","Creates a new `Arc<T>`, with the `Default` value for `T`.",315,{"inputs":[],"output":{"name":"arc"}}],[11,"default","std::rc","Creates a new `Rc<T>`, with the `Default` value for `T`.",316,{"inputs":[],"output":{"name":"rc"}}],[11,"default","","Constructs a new `Weak<T>`, without an accompanying instance of `T`.",318,{"inputs":[],"output":{"name":"weak"}}],[11,"partial_cmp","std::boxed","",115,{"inputs":[{"name":"self"},{"name":"box"}],"output":{"name":"option"}}],[11,"lt","","",115,{"inputs":[{"name":"self"},{"name":"box"}],"output":{"name":"bool"}}],[11,"le","","",115,{"inputs":[{"name":"self"},{"name":"box"}],"output":{"name":"bool"}}],[11,"ge","","",115,{"inputs":[{"name":"self"},{"name":"box"}],"output":{"name":"bool"}}],[11,"gt","","",115,{"inputs":[{"name":"self"},{"name":"box"}],"output":{"name":"bool"}}],[11,"partial_cmp","std::sync","Partial comparison for two `Arc`s.",315,{"inputs":[{"name":"self"},{"name":"arc"}],"output":{"name":"option"}}],[11,"lt","","Less-than comparison for two `Arc`s.",315,{"inputs":[{"name":"self"},{"name":"arc"}],"output":{"name":"bool"}}],[11,"le","","'Less than or equal to' comparison for two `Arc`s.",315,{"inputs":[{"name":"self"},{"name":"arc"}],"output":{"name":"bool"}}],[11,"gt","","Greater-than comparison for two `Arc`s.",315,{"inputs":[{"name":"self"},{"name":"arc"}],"output":{"name":"bool"}}],[11,"ge","","'Greater than or equal to' comparison for two `Arc`s.",315,{"inputs":[{"name":"self"},{"name":"arc"}],"output":{"name":"bool"}}],[11,"partial_cmp","std::rc","Partial comparison for two `Rc`s.",316,{"inputs":[{"name":"self"},{"name":"rc"}],"output":{"name":"option"}}],[11,"lt","","Less-than comparison for two `Rc`s.",316,{"inputs":[{"name":"self"},{"name":"rc"}],"output":{"name":"bool"}}],[11,"le","","'Less than or equal to' comparison for two `Rc`s.",316,{"inputs":[{"name":"self"},{"name":"rc"}],"output":{"name":"bool"}}],[11,"gt","","Greater-than comparison for two `Rc`s.",316,{"inputs":[{"name":"self"},{"name":"rc"}],"output":{"name":"bool"}}],[11,"ge","","'Greater than or equal to' comparison for two `Rc`s.",316,{"inputs":[{"name":"self"},{"name":"rc"}],"output":{"name":"bool"}}],[11,"borrow","std::boxed","",115,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"borrow","std::sync","",315,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"borrow","std::rc","",316,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"as_ref","std::boxed","",115,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"as_ref","std::sync","",315,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"as_ref","std::rc","",316,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"fmt","std::boxed","",115,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::sync","",317,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",315,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::rc","",316,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",318,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::boxed","",115,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::sync","",315,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::rc","",316,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"deref_mut","std::boxed","",115,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"finalize","","",115,{"inputs":[{"name":"intermediatebox"}],"output":{"name":"box"}}],[11,"from","","",115,{"inputs":[{"name":"t"}],"output":{"name":"box"}}],[11,"from","","",115,null],[11,"from","","",115,{"inputs":[{"name":"str"}],"output":{"name":"box"}}],[11,"from","std::sync","",315,{"inputs":[{"name":"t"}],"output":{"name":"arc"}}],[11,"from","std::rc","",316,{"inputs":[{"name":"t"}],"output":{"name":"rc"}}],[11,"next","std::boxed","",115,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",115,null],[11,"nth","","",115,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"len","","",115,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","",115,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"call_once","","",115,{"inputs":[{"name":"self"},{"name":"a"}],"output":{"name":"r"}}],[11,"call_once","","",115,{"inputs":[{"name":"self"},{"name":"a"}],"output":{"name":"r"}}],[11,"drop","","",313,null],[11,"drop","","",115,null],[11,"drop","std::sync","Drops the `Arc`.",315,null],[11,"drop","","Drops the `Weak` pointer.",317,null],[11,"drop","std::rc","Drops the `Rc`.",316,null],[11,"drop","","Drops the `Weak` pointer.",318,null],[11,"index_mut","std","",276,null],[11,"index_mut","","",277,{"inputs":[{"name":"self"},{"name":"range"}],"output":{"name":"str"}}],[11,"index_mut","","",277,{"inputs":[{"name":"self"},{"name":"rangeto"}],"output":{"name":"str"}}],[11,"index_mut","","",277,{"inputs":[{"name":"self"},{"name":"rangefrom"}],"output":{"name":"str"}}],[11,"index_mut","","",277,{"inputs":[{"name":"self"},{"name":"rangefull"}],"output":{"name":"str"}}],[11,"index_mut","","",277,{"inputs":[{"name":"self"},{"name":"rangeinclusive"}],"output":{"name":"str"}}],[11,"index_mut","","",277,{"inputs":[{"name":"self"},{"name":"rangetoinclusive"}],"output":{"name":"str"}}],[11,"one","","",319,{"inputs":[],"output":{"name":"u8"}}],[11,"one","","",320,{"inputs":[],"output":{"name":"u16"}}],[11,"one","","",321,{"inputs":[],"output":{"name":"u32"}}],[11,"one","","",322,{"inputs":[],"output":{"name":"u64"}}],[11,"one","","",264,{"inputs":[],"output":{"name":"u128"}}],[11,"one","","",323,{"inputs":[],"output":{"name":"usize"}}],[11,"one","","",324,{"inputs":[],"output":{"name":"i8"}}],[11,"one","","",325,{"inputs":[],"output":{"name":"i16"}}],[11,"one","","",326,{"inputs":[],"output":{"name":"i32"}}],[11,"one","","",327,{"inputs":[],"output":{"name":"i64"}}],[11,"one","","",265,{"inputs":[],"output":{"name":"i128"}}],[11,"one","","",328,{"inputs":[],"output":{"name":"isize"}}],[11,"one","","",329,{"inputs":[],"output":{"name":"f32"}}],[11,"one","","",330,{"inputs":[],"output":{"name":"f64"}}],[11,"index","","",276,null],[11,"index","","",277,{"inputs":[{"name":"self"},{"name":"range"}],"output":{"name":"str"}}],[11,"index","","",277,{"inputs":[{"name":"self"},{"name":"rangeto"}],"output":{"name":"str"}}],[11,"index","","",277,{"inputs":[{"name":"self"},{"name":"rangefrom"}],"output":{"name":"str"}}],[11,"index","","",277,{"inputs":[{"name":"self"},{"name":"rangefull"}],"output":{"name":"str"}}],[11,"index","","",277,{"inputs":[{"name":"self"},{"name":"rangeinclusive"}],"output":{"name":"str"}}],[11,"index","","",277,{"inputs":[{"name":"self"},{"name":"rangetoinclusive"}],"output":{"name":"str"}}],[11,"mul","std::num","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"mul","","",189,null],[11,"mul","","",189,null],[11,"mul","","",189,null],[11,"mul","","",189,null],[11,"mul","","",189,null],[11,"mul","","",189,null],[11,"mul","","",189,null],[11,"mul","","",189,null],[11,"mul","","",189,null],[11,"mul","","",189,null],[11,"mul","","",189,null],[11,"mul","","",189,null],[11,"mul","std","",323,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"usize"}}],[11,"mul","","",319,{"inputs":[{"name":"self"},{"name":"u8"}],"output":{"name":"u8"}}],[11,"mul","","",320,{"inputs":[{"name":"self"},{"name":"u16"}],"output":{"name":"u16"}}],[11,"mul","","",321,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"u32"}}],[11,"mul","","",322,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"u64"}}],[11,"mul","","",264,{"inputs":[{"name":"self"},{"name":"u128"}],"output":{"name":"u128"}}],[11,"mul","","",328,{"inputs":[{"name":"self"},{"name":"isize"}],"output":{"name":"isize"}}],[11,"mul","","",324,{"inputs":[{"name":"self"},{"name":"i8"}],"output":{"name":"i8"}}],[11,"mul","","",325,{"inputs":[{"name":"self"},{"name":"i16"}],"output":{"name":"i16"}}],[11,"mul","","",326,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"i32"}}],[11,"mul","","",327,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"i64"}}],[11,"mul","","",265,{"inputs":[{"name":"self"},{"name":"i128"}],"output":{"name":"i128"}}],[11,"mul","","",329,{"inputs":[{"name":"self"},{"name":"f32"}],"output":{"name":"f32"}}],[11,"mul","","",330,{"inputs":[{"name":"self"},{"name":"f64"}],"output":{"name":"f64"}}],[11,"mul","","",323,null],[11,"mul","","",323,null],[11,"mul","","",323,null],[11,"mul","","",319,null],[11,"mul","","",319,null],[11,"mul","","",319,null],[11,"mul","","",320,null],[11,"mul","","",320,null],[11,"mul","","",320,null],[11,"mul","","",321,null],[11,"mul","","",321,null],[11,"mul","","",321,null],[11,"mul","","",322,null],[11,"mul","","",322,null],[11,"mul","","",322,null],[11,"mul","","",264,null],[11,"mul","","",264,null],[11,"mul","","",264,null],[11,"mul","","",328,null],[11,"mul","","",328,null],[11,"mul","","",328,null],[11,"mul","","",324,null],[11,"mul","","",324,null],[11,"mul","","",324,null],[11,"mul","","",325,null],[11,"mul","","",325,null],[11,"mul","","",325,null],[11,"mul","","",326,null],[11,"mul","","",326,null],[11,"mul","","",326,null],[11,"mul","","",327,null],[11,"mul","","",327,null],[11,"mul","","",327,null],[11,"mul","","",265,null],[11,"mul","","",265,null],[11,"mul","","",265,null],[11,"mul","","",329,null],[11,"mul","","",329,null],[11,"mul","","",329,null],[11,"mul","","",330,null],[11,"mul","","",330,null],[11,"mul","","",330,null],[11,"try_from","","",331,{"inputs":[{"name":"u32"}],"output":{"name":"result"}}],[11,"try_from","","",319,{"inputs":[{"name":"u8"}],"output":{"name":"result"}}],[11,"try_from","","",319,{"inputs":[{"name":"u16"}],"output":{"name":"result"}}],[11,"try_from","","",319,{"inputs":[{"name":"u32"}],"output":{"name":"result"}}],[11,"try_from","","",319,{"inputs":[{"name":"u64"}],"output":{"name":"result"}}],[11,"try_from","","",319,{"inputs":[{"name":"u128"}],"output":{"name":"result"}}],[11,"try_from","","",319,{"inputs":[{"name":"usize"}],"output":{"name":"result"}}],[11,"try_from","","",324,{"inputs":[{"name":"i8"}],"output":{"name":"result"}}],[11,"try_from","","",324,{"inputs":[{"name":"i16"}],"output":{"name":"result"}}],[11,"try_from","","",324,{"inputs":[{"name":"i32"}],"output":{"name":"result"}}],[11,"try_from","","",324,{"inputs":[{"name":"i64"}],"output":{"name":"result"}}],[11,"try_from","","",324,{"inputs":[{"name":"i128"}],"output":{"name":"result"}}],[11,"try_from","","",324,{"inputs":[{"name":"isize"}],"output":{"name":"result"}}],[11,"try_from","","",320,{"inputs":[{"name":"u8"}],"output":{"name":"result"}}],[11,"try_from","","",320,{"inputs":[{"name":"u16"}],"output":{"name":"result"}}],[11,"try_from","","",320,{"inputs":[{"name":"u32"}],"output":{"name":"result"}}],[11,"try_from","","",320,{"inputs":[{"name":"u64"}],"output":{"name":"result"}}],[11,"try_from","","",320,{"inputs":[{"name":"u128"}],"output":{"name":"result"}}],[11,"try_from","","",320,{"inputs":[{"name":"usize"}],"output":{"name":"result"}}],[11,"try_from","","",325,{"inputs":[{"name":"i8"}],"output":{"name":"result"}}],[11,"try_from","","",325,{"inputs":[{"name":"i16"}],"output":{"name":"result"}}],[11,"try_from","","",325,{"inputs":[{"name":"i32"}],"output":{"name":"result"}}],[11,"try_from","","",325,{"inputs":[{"name":"i64"}],"output":{"name":"result"}}],[11,"try_from","","",325,{"inputs":[{"name":"i128"}],"output":{"name":"result"}}],[11,"try_from","","",325,{"inputs":[{"name":"isize"}],"output":{"name":"result"}}],[11,"try_from","","",321,{"inputs":[{"name":"u8"}],"output":{"name":"result"}}],[11,"try_from","","",321,{"inputs":[{"name":"u16"}],"output":{"name":"result"}}],[11,"try_from","","",321,{"inputs":[{"name":"u32"}],"output":{"name":"result"}}],[11,"try_from","","",321,{"inputs":[{"name":"u64"}],"output":{"name":"result"}}],[11,"try_from","","",321,{"inputs":[{"name":"u128"}],"output":{"name":"result"}}],[11,"try_from","","",321,{"inputs":[{"name":"usize"}],"output":{"name":"result"}}],[11,"try_from","","",326,{"inputs":[{"name":"i8"}],"output":{"name":"result"}}],[11,"try_from","","",326,{"inputs":[{"name":"i16"}],"output":{"name":"result"}}],[11,"try_from","","",326,{"inputs":[{"name":"i32"}],"output":{"name":"result"}}],[11,"try_from","","",326,{"inputs":[{"name":"i64"}],"output":{"name":"result"}}],[11,"try_from","","",326,{"inputs":[{"name":"i128"}],"output":{"name":"result"}}],[11,"try_from","","",326,{"inputs":[{"name":"isize"}],"output":{"name":"result"}}],[11,"try_from","","",322,{"inputs":[{"name":"u8"}],"output":{"name":"result"}}],[11,"try_from","","",322,{"inputs":[{"name":"u16"}],"output":{"name":"result"}}],[11,"try_from","","",322,{"inputs":[{"name":"u32"}],"output":{"name":"result"}}],[11,"try_from","","",322,{"inputs":[{"name":"u64"}],"output":{"name":"result"}}],[11,"try_from","","",322,{"inputs":[{"name":"u128"}],"output":{"name":"result"}}],[11,"try_from","","",322,{"inputs":[{"name":"usize"}],"output":{"name":"result"}}],[11,"try_from","","",327,{"inputs":[{"name":"i8"}],"output":{"name":"result"}}],[11,"try_from","","",327,{"inputs":[{"name":"i16"}],"output":{"name":"result"}}],[11,"try_from","","",327,{"inputs":[{"name":"i32"}],"output":{"name":"result"}}],[11,"try_from","","",327,{"inputs":[{"name":"i64"}],"output":{"name":"result"}}],[11,"try_from","","",327,{"inputs":[{"name":"i128"}],"output":{"name":"result"}}],[11,"try_from","","",327,{"inputs":[{"name":"isize"}],"output":{"name":"result"}}],[11,"try_from","","",264,{"inputs":[{"name":"u8"}],"output":{"name":"result"}}],[11,"try_from","","",264,{"inputs":[{"name":"u16"}],"output":{"name":"result"}}],[11,"try_from","","",264,{"inputs":[{"name":"u32"}],"output":{"name":"result"}}],[11,"try_from","","",264,{"inputs":[{"name":"u64"}],"output":{"name":"result"}}],[11,"try_from","","",264,{"inputs":[{"name":"u128"}],"output":{"name":"result"}}],[11,"try_from","","",264,{"inputs":[{"name":"usize"}],"output":{"name":"result"}}],[11,"try_from","","",265,{"inputs":[{"name":"i8"}],"output":{"name":"result"}}],[11,"try_from","","",265,{"inputs":[{"name":"i16"}],"output":{"name":"result"}}],[11,"try_from","","",265,{"inputs":[{"name":"i32"}],"output":{"name":"result"}}],[11,"try_from","","",265,{"inputs":[{"name":"i64"}],"output":{"name":"result"}}],[11,"try_from","","",265,{"inputs":[{"name":"i128"}],"output":{"name":"result"}}],[11,"try_from","","",265,{"inputs":[{"name":"isize"}],"output":{"name":"result"}}],[11,"try_from","","",323,{"inputs":[{"name":"u8"}],"output":{"name":"result"}}],[11,"try_from","","",323,{"inputs":[{"name":"u16"}],"output":{"name":"result"}}],[11,"try_from","","",323,{"inputs":[{"name":"u32"}],"output":{"name":"result"}}],[11,"try_from","","",323,{"inputs":[{"name":"u64"}],"output":{"name":"result"}}],[11,"try_from","","",323,{"inputs":[{"name":"u128"}],"output":{"name":"result"}}],[11,"try_from","","",323,{"inputs":[{"name":"usize"}],"output":{"name":"result"}}],[11,"try_from","","",328,{"inputs":[{"name":"i8"}],"output":{"name":"result"}}],[11,"try_from","","",328,{"inputs":[{"name":"i16"}],"output":{"name":"result"}}],[11,"try_from","","",328,{"inputs":[{"name":"i32"}],"output":{"name":"result"}}],[11,"try_from","","",328,{"inputs":[{"name":"i64"}],"output":{"name":"result"}}],[11,"try_from","","",328,{"inputs":[{"name":"i128"}],"output":{"name":"result"}}],[11,"try_from","","",328,{"inputs":[{"name":"isize"}],"output":{"name":"result"}}],[11,"try_from","","",324,{"inputs":[{"name":"u8"}],"output":{"name":"result"}}],[11,"try_from","","",319,{"inputs":[{"name":"i8"}],"output":{"name":"result"}}],[11,"try_from","","",325,{"inputs":[{"name":"u8"}],"output":{"name":"result"}}],[11,"try_from","","",319,{"inputs":[{"name":"i16"}],"output":{"name":"result"}}],[11,"try_from","","",326,{"inputs":[{"name":"u8"}],"output":{"name":"result"}}],[11,"try_from","","",319,{"inputs":[{"name":"i32"}],"output":{"name":"result"}}],[11,"try_from","","",327,{"inputs":[{"name":"u8"}],"output":{"name":"result"}}],[11,"try_from","","",319,{"inputs":[{"name":"i64"}],"output":{"name":"result"}}],[11,"try_from","","",265,{"inputs":[{"name":"u8"}],"output":{"name":"result"}}],[11,"try_from","","",319,{"inputs":[{"name":"i128"}],"output":{"name":"result"}}],[11,"try_from","","",328,{"inputs":[{"name":"u8"}],"output":{"name":"result"}}],[11,"try_from","","",319,{"inputs":[{"name":"isize"}],"output":{"name":"result"}}],[11,"try_from","","",324,{"inputs":[{"name":"u16"}],"output":{"name":"result"}}],[11,"try_from","","",320,{"inputs":[{"name":"i8"}],"output":{"name":"result"}}],[11,"try_from","","",325,{"inputs":[{"name":"u16"}],"output":{"name":"result"}}],[11,"try_from","","",320,{"inputs":[{"name":"i16"}],"output":{"name":"result"}}],[11,"try_from","","",326,{"inputs":[{"name":"u16"}],"output":{"name":"result"}}],[11,"try_from","","",320,{"inputs":[{"name":"i32"}],"output":{"name":"result"}}],[11,"try_from","","",327,{"inputs":[{"name":"u16"}],"output":{"name":"result"}}],[11,"try_from","","",320,{"inputs":[{"name":"i64"}],"output":{"name":"result"}}],[11,"try_from","","",265,{"inputs":[{"name":"u16"}],"output":{"name":"result"}}],[11,"try_from","","",320,{"inputs":[{"name":"i128"}],"output":{"name":"result"}}],[11,"try_from","","",328,{"inputs":[{"name":"u16"}],"output":{"name":"result"}}],[11,"try_from","","",320,{"inputs":[{"name":"isize"}],"output":{"name":"result"}}],[11,"try_from","","",324,{"inputs":[{"name":"u32"}],"output":{"name":"result"}}],[11,"try_from","","",321,{"inputs":[{"name":"i8"}],"output":{"name":"result"}}],[11,"try_from","","",325,{"inputs":[{"name":"u32"}],"output":{"name":"result"}}],[11,"try_from","","",321,{"inputs":[{"name":"i16"}],"output":{"name":"result"}}],[11,"try_from","","",326,{"inputs":[{"name":"u32"}],"output":{"name":"result"}}],[11,"try_from","","",321,{"inputs":[{"name":"i32"}],"output":{"name":"result"}}],[11,"try_from","","",327,{"inputs":[{"name":"u32"}],"output":{"name":"result"}}],[11,"try_from","","",321,{"inputs":[{"name":"i64"}],"output":{"name":"result"}}],[11,"try_from","","",265,{"inputs":[{"name":"u32"}],"output":{"name":"result"}}],[11,"try_from","","",321,{"inputs":[{"name":"i128"}],"output":{"name":"result"}}],[11,"try_from","","",328,{"inputs":[{"name":"u32"}],"output":{"name":"result"}}],[11,"try_from","","",321,{"inputs":[{"name":"isize"}],"output":{"name":"result"}}],[11,"try_from","","",324,{"inputs":[{"name":"u64"}],"output":{"name":"result"}}],[11,"try_from","","",322,{"inputs":[{"name":"i8"}],"output":{"name":"result"}}],[11,"try_from","","",325,{"inputs":[{"name":"u64"}],"output":{"name":"result"}}],[11,"try_from","","",322,{"inputs":[{"name":"i16"}],"output":{"name":"result"}}],[11,"try_from","","",326,{"inputs":[{"name":"u64"}],"output":{"name":"result"}}],[11,"try_from","","",322,{"inputs":[{"name":"i32"}],"output":{"name":"result"}}],[11,"try_from","","",327,{"inputs":[{"name":"u64"}],"output":{"name":"result"}}],[11,"try_from","","",322,{"inputs":[{"name":"i64"}],"output":{"name":"result"}}],[11,"try_from","","",265,{"inputs":[{"name":"u64"}],"output":{"name":"result"}}],[11,"try_from","","",322,{"inputs":[{"name":"i128"}],"output":{"name":"result"}}],[11,"try_from","","",328,{"inputs":[{"name":"u64"}],"output":{"name":"result"}}],[11,"try_from","","",322,{"inputs":[{"name":"isize"}],"output":{"name":"result"}}],[11,"try_from","","",324,{"inputs":[{"name":"u128"}],"output":{"name":"result"}}],[11,"try_from","","",264,{"inputs":[{"name":"i8"}],"output":{"name":"result"}}],[11,"try_from","","",325,{"inputs":[{"name":"u128"}],"output":{"name":"result"}}],[11,"try_from","","",264,{"inputs":[{"name":"i16"}],"output":{"name":"result"}}],[11,"try_from","","",326,{"inputs":[{"name":"u128"}],"output":{"name":"result"}}],[11,"try_from","","",264,{"inputs":[{"name":"i32"}],"output":{"name":"result"}}],[11,"try_from","","",327,{"inputs":[{"name":"u128"}],"output":{"name":"result"}}],[11,"try_from","","",264,{"inputs":[{"name":"i64"}],"output":{"name":"result"}}],[11,"try_from","","",265,{"inputs":[{"name":"u128"}],"output":{"name":"result"}}],[11,"try_from","","",264,{"inputs":[{"name":"i128"}],"output":{"name":"result"}}],[11,"try_from","","",328,{"inputs":[{"name":"u128"}],"output":{"name":"result"}}],[11,"try_from","","",264,{"inputs":[{"name":"isize"}],"output":{"name":"result"}}],[11,"try_from","","",324,{"inputs":[{"name":"usize"}],"output":{"name":"result"}}],[11,"try_from","","",323,{"inputs":[{"name":"i8"}],"output":{"name":"result"}}],[11,"try_from","","",325,{"inputs":[{"name":"usize"}],"output":{"name":"result"}}],[11,"try_from","","",323,{"inputs":[{"name":"i16"}],"output":{"name":"result"}}],[11,"try_from","","",326,{"inputs":[{"name":"usize"}],"output":{"name":"result"}}],[11,"try_from","","",323,{"inputs":[{"name":"i32"}],"output":{"name":"result"}}],[11,"try_from","","",327,{"inputs":[{"name":"usize"}],"output":{"name":"result"}}],[11,"try_from","","",323,{"inputs":[{"name":"i64"}],"output":{"name":"result"}}],[11,"try_from","","",265,{"inputs":[{"name":"usize"}],"output":{"name":"result"}}],[11,"try_from","","",323,{"inputs":[{"name":"i128"}],"output":{"name":"result"}}],[11,"try_from","","",328,{"inputs":[{"name":"usize"}],"output":{"name":"result"}}],[11,"try_from","","",323,{"inputs":[{"name":"isize"}],"output":{"name":"result"}}],[11,"split_at","","",276,null],[11,"iter","","",276,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"split","","",276,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"split"}}],[11,"splitn","","",276,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"p"}],"output":{"name":"splitn"}}],[11,"rsplitn","","",276,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"p"}],"output":{"name":"rsplitn"}}],[11,"windows","","",276,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"windows"}}],[11,"chunks","","",276,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"chunks"}}],[11,"get","","",276,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"option"}}],[11,"first","","",276,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"split_first","","",276,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"split_last","","",276,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"last","","",276,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"get_unchecked","","",276,null],[11,"as_ptr","","",276,null],[11,"binary_search_by","","",276,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"result"}}],[11,"len","","",276,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"get_mut","","",276,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"option"}}],[11,"split_at_mut","","",276,null],[11,"iter_mut","","",276,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"last_mut","","",276,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"first_mut","","",276,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"split_first_mut","","",276,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"split_last_mut","","",276,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"split_mut","","",276,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"splitmut"}}],[11,"splitn_mut","","",276,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"p"}],"output":{"name":"splitnmut"}}],[11,"rsplitn_mut","","",276,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"p"}],"output":{"name":"rsplitnmut"}}],[11,"chunks_mut","","",276,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"chunksmut"}}],[11,"swap","","",276,null],[11,"reverse","","",276,null],[11,"get_unchecked_mut","","",276,null],[11,"as_mut_ptr","","",276,null],[11,"contains","","",276,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"bool"}}],[11,"starts_with","","",276,null],[11,"ends_with","","",276,null],[11,"binary_search","","",276,{"inputs":[{"name":"self"},{"name":"q"}],"output":{"name":"result"}}],[11,"clone_from_slice","","",276,null],[11,"copy_from_slice","","",276,null],[11,"binary_search_by_key","","",276,{"inputs":[{"name":"self"},{"name":"q"},{"name":"f"}],"output":{"name":"result"}}],[11,"eq","std::mem","",332,{"inputs":[{"name":"self"},{"name":"discriminant"}],"output":{"name":"bool"}}],[11,"eq","std","",333,null],[11,"eq","","",333,null],[11,"eq","","",279,null],[11,"ne","","",279,null],[11,"eq","std::cell","",334,{"inputs":[{"name":"self"},{"name":"cell"}],"output":{"name":"bool"}}],[11,"eq","","",335,{"inputs":[{"name":"self"},{"name":"refcell"}],"output":{"name":"bool"}}],[11,"eq","std","",276,null],[11,"ne","","",276,null],[11,"eq","","",277,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"ne","","",277,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"eq","std::num","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"bool"}}],[11,"ne","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"bool"}}],[11,"eq","","",336,{"inputs":[{"name":"self"},{"name":"parsefloaterror"}],"output":{"name":"bool"}}],[11,"ne","","",336,{"inputs":[{"name":"self"},{"name":"parsefloaterror"}],"output":{"name":"bool"}}],[11,"eq","","",188,{"inputs":[{"name":"self"},{"name":"fpcategory"}],"output":{"name":"bool"}}],[11,"eq","","",337,{"inputs":[{"name":"self"},{"name":"parseinterror"}],"output":{"name":"bool"}}],[11,"ne","","",337,{"inputs":[{"name":"self"},{"name":"parseinterror"}],"output":{"name":"bool"}}],[11,"eq","std::marker","",338,{"inputs":[{"name":"self"},{"name":"phantomdata"}],"output":{"name":"bool"}}],[11,"eq","std::ops","",278,{"inputs":[{"name":"self"},{"name":"rangefull"}],"output":{"name":"bool"}}],[11,"eq","","",51,{"inputs":[{"name":"self"},{"name":"range"}],"output":{"name":"bool"}}],[11,"ne","","",51,{"inputs":[{"name":"self"},{"name":"range"}],"output":{"name":"bool"}}],[11,"eq","","",52,{"inputs":[{"name":"self"},{"name":"rangefrom"}],"output":{"name":"bool"}}],[11,"ne","","",52,{"inputs":[{"name":"self"},{"name":"rangefrom"}],"output":{"name":"bool"}}],[11,"eq","","",53,{"inputs":[{"name":"self"},{"name":"rangeto"}],"output":{"name":"bool"}}],[11,"ne","","",53,{"inputs":[{"name":"self"},{"name":"rangeto"}],"output":{"name":"bool"}}],[11,"eq","","",54,{"inputs":[{"name":"self"},{"name":"rangeinclusive"}],"output":{"name":"bool"}}],[11,"ne","","",54,{"inputs":[{"name":"self"},{"name":"rangeinclusive"}],"output":{"name":"bool"}}],[11,"eq","","",55,{"inputs":[{"name":"self"},{"name":"rangetoinclusive"}],"output":{"name":"bool"}}],[11,"ne","","",55,{"inputs":[{"name":"self"},{"name":"rangetoinclusive"}],"output":{"name":"bool"}}],[11,"eq","std::cmp","",4,{"inputs":[{"name":"self"},{"name":"ordering"}],"output":{"name":"bool"}}],[11,"eq","std","",339,{"inputs":[{"name":"self"},{"name":"bool"}],"output":{"name":"bool"}}],[11,"ne","","",339,{"inputs":[{"name":"self"},{"name":"bool"}],"output":{"name":"bool"}}],[11,"eq","","",331,{"inputs":[{"name":"self"},{"name":"char"}],"output":{"name":"bool"}}],[11,"ne","","",331,{"inputs":[{"name":"self"},{"name":"char"}],"output":{"name":"bool"}}],[11,"eq","","",323,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"bool"}}],[11,"ne","","",323,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"bool"}}],[11,"eq","","",319,{"inputs":[{"name":"self"},{"name":"u8"}],"output":{"name":"bool"}}],[11,"ne","","",319,{"inputs":[{"name":"self"},{"name":"u8"}],"output":{"name":"bool"}}],[11,"eq","","",320,{"inputs":[{"name":"self"},{"name":"u16"}],"output":{"name":"bool"}}],[11,"ne","","",320,{"inputs":[{"name":"self"},{"name":"u16"}],"output":{"name":"bool"}}],[11,"eq","","",321,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"bool"}}],[11,"ne","","",321,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"bool"}}],[11,"eq","","",322,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"bool"}}],[11,"ne","","",322,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"bool"}}],[11,"eq","","",264,{"inputs":[{"name":"self"},{"name":"u128"}],"output":{"name":"bool"}}],[11,"ne","","",264,{"inputs":[{"name":"self"},{"name":"u128"}],"output":{"name":"bool"}}],[11,"eq","","",328,{"inputs":[{"name":"self"},{"name":"isize"}],"output":{"name":"bool"}}],[11,"ne","","",328,{"inputs":[{"name":"self"},{"name":"isize"}],"output":{"name":"bool"}}],[11,"eq","","",324,{"inputs":[{"name":"self"},{"name":"i8"}],"output":{"name":"bool"}}],[11,"ne","","",324,{"inputs":[{"name":"self"},{"name":"i8"}],"output":{"name":"bool"}}],[11,"eq","","",325,{"inputs":[{"name":"self"},{"name":"i16"}],"output":{"name":"bool"}}],[11,"ne","","",325,{"inputs":[{"name":"self"},{"name":"i16"}],"output":{"name":"bool"}}],[11,"eq","","",326,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"bool"}}],[11,"ne","","",326,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"bool"}}],[11,"eq","","",327,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"bool"}}],[11,"ne","","",327,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"bool"}}],[11,"eq","","",265,{"inputs":[{"name":"self"},{"name":"i128"}],"output":{"name":"bool"}}],[11,"ne","","",265,{"inputs":[{"name":"self"},{"name":"i128"}],"output":{"name":"bool"}}],[11,"eq","","",329,{"inputs":[{"name":"self"},{"name":"f32"}],"output":{"name":"bool"}}],[11,"ne","","",329,{"inputs":[{"name":"self"},{"name":"f32"}],"output":{"name":"bool"}}],[11,"eq","","",330,{"inputs":[{"name":"self"},{"name":"f64"}],"output":{"name":"bool"}}],[11,"ne","","",330,{"inputs":[{"name":"self"},{"name":"f64"}],"output":{"name":"bool"}}],[11,"eq","std::any","",340,{"inputs":[{"name":"self"},{"name":"typeid"}],"output":{"name":"bool"}}],[11,"ne","","",340,{"inputs":[{"name":"self"},{"name":"typeid"}],"output":{"name":"bool"}}],[11,"eq","std","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","","",276,null],[11,"ne","","",276,null],[11,"eq","","",341,null],[11,"ne","","",341,null],[11,"eq","std::cell","",1,{"inputs":[{"name":"self"},{"name":"borrowstate"}],"output":{"name":"bool"}}],[11,"eq","std::char","",125,{"inputs":[{"name":"self"},{"name":"chartryfromerror"}],"output":{"name":"bool"}}],[11,"ne","","",125,{"inputs":[{"name":"self"},{"name":"chartryfromerror"}],"output":{"name":"bool"}}],[11,"eq","std::option","",69,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"name":"bool"}}],[11,"ne","","",69,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"name":"bool"}}],[11,"eq","std::result","",68,{"inputs":[{"name":"self"},{"name":"result"}],"output":{"name":"bool"}}],[11,"ne","","",68,{"inputs":[{"name":"self"},{"name":"result"}],"output":{"name":"bool"}}],[11,"eq","std::str::pattern","",89,{"inputs":[{"name":"self"},{"name":"searchstep"}],"output":{"name":"bool"}}],[11,"ne","","",89,{"inputs":[{"name":"self"},{"name":"searchstep"}],"output":{"name":"bool"}}],[11,"eq","std::str","",116,{"inputs":[{"name":"self"},{"name":"parseboolerror"}],"output":{"name":"bool"}}],[11,"ne","","",116,{"inputs":[{"name":"self"},{"name":"parseboolerror"}],"output":{"name":"bool"}}],[11,"eq","","",117,{"inputs":[{"name":"self"},{"name":"utf8error"}],"output":{"name":"bool"}}],[11,"ne","","",117,{"inputs":[{"name":"self"},{"name":"utf8error"}],"output":{"name":"bool"}}],[11,"eq","std::fmt","",122,{"inputs":[{"name":"self"},{"name":"error"}],"output":{"name":"bool"}}],[11,"eq","std","",279,null],[11,"ne","","",279,null],[11,"eq","","",279,null],[11,"ne","","",279,null],[11,"eq","","",279,null],[11,"ne","","",279,null],[11,"eq","","",279,null],[11,"ne","","",279,null],[11,"eq","","",279,null],[11,"ne","","",279,null],[11,"eq","","",279,null],[11,"ne","","",279,null],[11,"eq","","",279,null],[11,"ne","","",279,null],[11,"eq","","",279,null],[11,"ne","","",279,null],[11,"eq","","",279,null],[11,"ne","","",279,null],[11,"eq","","",279,null],[11,"ne","","",279,null],[11,"eq","","",279,null],[11,"ne","","",279,null],[11,"eq","","",279,null],[11,"ne","","",279,null],[11,"from_str","","Parse a `bool` from a string.",339,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","Converts a string in base 10 to a float. Accepts an optional decimal exponent.",329,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","Converts a string in base 10 to a float. Accepts an optional decimal exponent.",330,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",328,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",324,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",325,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",326,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",327,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",265,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",323,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",319,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",320,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",321,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",322,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",264,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"get","","",323,null],[11,"get_mut","","",323,null],[11,"get_unchecked","","",323,null],[11,"get_unchecked_mut","","",323,null],[11,"index","","",323,null],[11,"index_mut","","",323,null],[11,"get","std::ops","",51,null],[11,"get_mut","","",51,null],[11,"get_unchecked","","",51,null],[11,"get_unchecked_mut","","",51,null],[11,"index","","",51,null],[11,"index_mut","","",51,null],[11,"get","","",53,null],[11,"get_mut","","",53,null],[11,"get_unchecked","","",53,null],[11,"get_unchecked_mut","","",53,null],[11,"index","","",53,null],[11,"index_mut","","",53,null],[11,"get","","",52,null],[11,"get_mut","","",52,null],[11,"get_unchecked","","",52,null],[11,"get_unchecked_mut","","",52,null],[11,"index","","",52,null],[11,"index_mut","","",52,null],[11,"get","","",278,null],[11,"get_mut","","",278,null],[11,"get_unchecked","","",278,null],[11,"get_unchecked_mut","","",278,null],[11,"index","","",278,null],[11,"index_mut","","",278,null],[11,"get","","",54,null],[11,"get_mut","","",54,null],[11,"get_unchecked","","",54,null],[11,"get_unchecked_mut","","",54,null],[11,"index","","",54,null],[11,"index_mut","","",54,null],[11,"get","","",55,null],[11,"get_mut","","",55,null],[11,"get_unchecked","","",55,null],[11,"get_unchecked_mut","","",55,null],[11,"index","","",55,null],[11,"index_mut","","",55,null],[11,"bitxor","std::num","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitxor","","",189,null],[11,"bitxor","","",189,null],[11,"bitxor","","",189,null],[11,"bitxor","","",189,null],[11,"bitxor","","",189,null],[11,"bitxor","","",189,null],[11,"bitxor","","",189,null],[11,"bitxor","","",189,null],[11,"bitxor","","",189,null],[11,"bitxor","","",189,null],[11,"bitxor","","",189,null],[11,"bitxor","","",189,null],[11,"bitxor","std","",339,{"inputs":[{"name":"self"},{"name":"bool"}],"output":{"name":"bool"}}],[11,"bitxor","","",323,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"usize"}}],[11,"bitxor","","",319,{"inputs":[{"name":"self"},{"name":"u8"}],"output":{"name":"u8"}}],[11,"bitxor","","",320,{"inputs":[{"name":"self"},{"name":"u16"}],"output":{"name":"u16"}}],[11,"bitxor","","",321,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"u32"}}],[11,"bitxor","","",322,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"u64"}}],[11,"bitxor","","",264,{"inputs":[{"name":"self"},{"name":"u128"}],"output":{"name":"u128"}}],[11,"bitxor","","",328,{"inputs":[{"name":"self"},{"name":"isize"}],"output":{"name":"isize"}}],[11,"bitxor","","",324,{"inputs":[{"name":"self"},{"name":"i8"}],"output":{"name":"i8"}}],[11,"bitxor","","",325,{"inputs":[{"name":"self"},{"name":"i16"}],"output":{"name":"i16"}}],[11,"bitxor","","",326,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"i32"}}],[11,"bitxor","","",327,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"i64"}}],[11,"bitxor","","",265,{"inputs":[{"name":"self"},{"name":"i128"}],"output":{"name":"i128"}}],[11,"bitxor","","",339,null],[11,"bitxor","","",339,null],[11,"bitxor","","",339,null],[11,"bitxor","","",323,null],[11,"bitxor","","",323,null],[11,"bitxor","","",323,null],[11,"bitxor","","",319,null],[11,"bitxor","","",319,null],[11,"bitxor","","",319,null],[11,"bitxor","","",320,null],[11,"bitxor","","",320,null],[11,"bitxor","","",320,null],[11,"bitxor","","",321,null],[11,"bitxor","","",321,null],[11,"bitxor","","",321,null],[11,"bitxor","","",322,null],[11,"bitxor","","",322,null],[11,"bitxor","","",322,null],[11,"bitxor","","",264,null],[11,"bitxor","","",264,null],[11,"bitxor","","",264,null],[11,"bitxor","","",328,null],[11,"bitxor","","",328,null],[11,"bitxor","","",328,null],[11,"bitxor","","",324,null],[11,"bitxor","","",324,null],[11,"bitxor","","",324,null],[11,"bitxor","","",325,null],[11,"bitxor","","",325,null],[11,"bitxor","","",325,null],[11,"bitxor","","",326,null],[11,"bitxor","","",326,null],[11,"bitxor","","",326,null],[11,"bitxor","","",327,null],[11,"bitxor","","",327,null],[11,"bitxor","","",327,null],[11,"bitxor","","",265,null],[11,"bitxor","","",265,null],[11,"bitxor","","",265,null],[11,"len","std::char","",342,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"len","","",343,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"len","std::iter","",344,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"len","","",345,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"len","","",346,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","",346,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"len","","",347,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","",347,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"len","","",348,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","",348,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"len","","",349,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","",349,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"len","","",350,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","",350,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"len","","",351,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","",351,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_empty","std::slice","",352,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_empty","","",353,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"len","std::str","",354,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_empty","","",354,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"from_success","std::result","",68,{"inputs":[{"name":"u"}],"output":{"name":"result"}}],[11,"from_error","","",68,{"inputs":[{"name":"v"}],"output":{"name":"result"}}],[11,"translate","","",68,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"into_iter","std::option","Returns a consuming iterator over the possibly contained value.",69,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"into_iter","std::result","Returns a consuming iterator over the possibly contained value.",68,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"into_iter","std","",276,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",276,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"into_iter","","",341,{"inputs":[{"name":"self"}],"output":{"name":"itermut"}}],[11,"div","std::num","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"div","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"div","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"div","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"div","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"div","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"div","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"div","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"div","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"div","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"div","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"div","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"div","","",189,null],[11,"div","","",189,null],[11,"div","","",189,null],[11,"div","","",189,null],[11,"div","","",189,null],[11,"div","","",189,null],[11,"div","","",189,null],[11,"div","","",189,null],[11,"div","","",189,null],[11,"div","","",189,null],[11,"div","","",189,null],[11,"div","","",189,null],[11,"div","std","",323,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"usize"}}],[11,"div","","",319,{"inputs":[{"name":"self"},{"name":"u8"}],"output":{"name":"u8"}}],[11,"div","","",320,{"inputs":[{"name":"self"},{"name":"u16"}],"output":{"name":"u16"}}],[11,"div","","",321,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"u32"}}],[11,"div","","",322,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"u64"}}],[11,"div","","",264,{"inputs":[{"name":"self"},{"name":"u128"}],"output":{"name":"u128"}}],[11,"div","","",328,{"inputs":[{"name":"self"},{"name":"isize"}],"output":{"name":"isize"}}],[11,"div","","",324,{"inputs":[{"name":"self"},{"name":"i8"}],"output":{"name":"i8"}}],[11,"div","","",325,{"inputs":[{"name":"self"},{"name":"i16"}],"output":{"name":"i16"}}],[11,"div","","",326,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"i32"}}],[11,"div","","",327,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"i64"}}],[11,"div","","",265,{"inputs":[{"name":"self"},{"name":"i128"}],"output":{"name":"i128"}}],[11,"div","","",323,null],[11,"div","","",323,null],[11,"div","","",323,null],[11,"div","","",319,null],[11,"div","","",319,null],[11,"div","","",319,null],[11,"div","","",320,null],[11,"div","","",320,null],[11,"div","","",320,null],[11,"div","","",321,null],[11,"div","","",321,null],[11,"div","","",321,null],[11,"div","","",322,null],[11,"div","","",322,null],[11,"div","","",322,null],[11,"div","","",264,null],[11,"div","","",264,null],[11,"div","","",264,null],[11,"div","","",328,null],[11,"div","","",328,null],[11,"div","","",328,null],[11,"div","","",324,null],[11,"div","","",324,null],[11,"div","","",324,null],[11,"div","","",325,null],[11,"div","","",325,null],[11,"div","","",325,null],[11,"div","","",326,null],[11,"div","","",326,null],[11,"div","","",326,null],[11,"div","","",327,null],[11,"div","","",327,null],[11,"div","","",327,null],[11,"div","","",265,null],[11,"div","","",265,null],[11,"div","","",265,null],[11,"div","","",329,{"inputs":[{"name":"self"},{"name":"f32"}],"output":{"name":"f32"}}],[11,"div","","",330,{"inputs":[{"name":"self"},{"name":"f64"}],"output":{"name":"f64"}}],[11,"div","","",329,null],[11,"div","","",329,null],[11,"div","","",329,null],[11,"div","","",330,null],[11,"div","","",330,null],[11,"div","","",330,null],[11,"build_hasher","std::hash","",355,{"inputs":[{"name":"self"}],"output":{"name":"h"}}],[11,"product","std::result","",68,{"inputs":[{"name":"i"}],"output":{"name":"result"}}],[11,"product","std","",324,{"inputs":[{"name":"i"}],"output":{"name":"i8"}}],[11,"product","","",324,{"inputs":[{"name":"i"}],"output":{"name":"i8"}}],[11,"product","","",325,{"inputs":[{"name":"i"}],"output":{"name":"i16"}}],[11,"product","","",325,{"inputs":[{"name":"i"}],"output":{"name":"i16"}}],[11,"product","","",326,{"inputs":[{"name":"i"}],"output":{"name":"i32"}}],[11,"product","","",326,{"inputs":[{"name":"i"}],"output":{"name":"i32"}}],[11,"product","","",327,{"inputs":[{"name":"i"}],"output":{"name":"i64"}}],[11,"product","","",327,{"inputs":[{"name":"i"}],"output":{"name":"i64"}}],[11,"product","","",328,{"inputs":[{"name":"i"}],"output":{"name":"isize"}}],[11,"product","","",328,{"inputs":[{"name":"i"}],"output":{"name":"isize"}}],[11,"product","","",319,{"inputs":[{"name":"i"}],"output":{"name":"u8"}}],[11,"product","","",319,{"inputs":[{"name":"i"}],"output":{"name":"u8"}}],[11,"product","","",320,{"inputs":[{"name":"i"}],"output":{"name":"u16"}}],[11,"product","","",320,{"inputs":[{"name":"i"}],"output":{"name":"u16"}}],[11,"product","","",321,{"inputs":[{"name":"i"}],"output":{"name":"u32"}}],[11,"product","","",321,{"inputs":[{"name":"i"}],"output":{"name":"u32"}}],[11,"product","","",322,{"inputs":[{"name":"i"}],"output":{"name":"u64"}}],[11,"product","","",322,{"inputs":[{"name":"i"}],"output":{"name":"u64"}}],[11,"product","","",323,{"inputs":[{"name":"i"}],"output":{"name":"usize"}}],[11,"product","","",323,{"inputs":[{"name":"i"}],"output":{"name":"usize"}}],[11,"product","std::num","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","std","",329,{"inputs":[{"name":"i"}],"output":{"name":"f32"}}],[11,"product","","",329,{"inputs":[{"name":"i"}],"output":{"name":"f32"}}],[11,"product","","",330,{"inputs":[{"name":"i"}],"output":{"name":"f64"}}],[11,"product","","",330,{"inputs":[{"name":"i"}],"output":{"name":"f64"}}],[11,"shl","std::num","",189,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shl","","",189,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shl","","",189,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shl","","",189,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shl","","",189,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shl","","",189,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shl","","",189,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shl","","",189,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shl","","",189,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shl","","",189,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shl","std","",319,{"inputs":[{"name":"self"},{"name":"u8"}],"output":{"name":"u8"}}],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,{"inputs":[{"name":"self"},{"name":"u16"}],"output":{"name":"u8"}}],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"u8"}}],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"u8"}}],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,{"inputs":[{"name":"self"},{"name":"u128"}],"output":{"name":"u8"}}],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"u8"}}],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,{"inputs":[{"name":"self"},{"name":"i8"}],"output":{"name":"u8"}}],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,{"inputs":[{"name":"self"},{"name":"i16"}],"output":{"name":"u8"}}],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"u8"}}],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"u8"}}],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,{"inputs":[{"name":"self"},{"name":"i128"}],"output":{"name":"u8"}}],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,{"inputs":[{"name":"self"},{"name":"isize"}],"output":{"name":"u8"}}],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",320,{"inputs":[{"name":"self"},{"name":"u8"}],"output":{"name":"u16"}}],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,{"inputs":[{"name":"self"},{"name":"u16"}],"output":{"name":"u16"}}],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"u16"}}],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"u16"}}],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,{"inputs":[{"name":"self"},{"name":"u128"}],"output":{"name":"u16"}}],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"u16"}}],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,{"inputs":[{"name":"self"},{"name":"i8"}],"output":{"name":"u16"}}],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,{"inputs":[{"name":"self"},{"name":"i16"}],"output":{"name":"u16"}}],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"u16"}}],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"u16"}}],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,{"inputs":[{"name":"self"},{"name":"i128"}],"output":{"name":"u16"}}],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,{"inputs":[{"name":"self"},{"name":"isize"}],"output":{"name":"u16"}}],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",321,{"inputs":[{"name":"self"},{"name":"u8"}],"output":{"name":"u32"}}],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,{"inputs":[{"name":"self"},{"name":"u16"}],"output":{"name":"u32"}}],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"u32"}}],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"u32"}}],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,{"inputs":[{"name":"self"},{"name":"u128"}],"output":{"name":"u32"}}],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"u32"}}],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,{"inputs":[{"name":"self"},{"name":"i8"}],"output":{"name":"u32"}}],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,{"inputs":[{"name":"self"},{"name":"i16"}],"output":{"name":"u32"}}],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"u32"}}],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"u32"}}],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,{"inputs":[{"name":"self"},{"name":"i128"}],"output":{"name":"u32"}}],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,{"inputs":[{"name":"self"},{"name":"isize"}],"output":{"name":"u32"}}],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",322,{"inputs":[{"name":"self"},{"name":"u8"}],"output":{"name":"u64"}}],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,{"inputs":[{"name":"self"},{"name":"u16"}],"output":{"name":"u64"}}],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"u64"}}],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"u64"}}],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,{"inputs":[{"name":"self"},{"name":"u128"}],"output":{"name":"u64"}}],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"u64"}}],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,{"inputs":[{"name":"self"},{"name":"i8"}],"output":{"name":"u64"}}],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,{"inputs":[{"name":"self"},{"name":"i16"}],"output":{"name":"u64"}}],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"u64"}}],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"u64"}}],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,{"inputs":[{"name":"self"},{"name":"i128"}],"output":{"name":"u64"}}],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,{"inputs":[{"name":"self"},{"name":"isize"}],"output":{"name":"u64"}}],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",264,{"inputs":[{"name":"self"},{"name":"u8"}],"output":{"name":"u128"}}],[11,"shl","","",264,null],[11,"shl","","",264,null],[11,"shl","","",264,null],[11,"shl","","",264,{"inputs":[{"name":"self"},{"name":"u16"}],"output":{"name":"u128"}}],[11,"shl","","",264,null],[11,"shl","","",264,null],[11,"shl","","",264,null],[11,"shl","","",264,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"u128"}}],[11,"shl","","",264,null],[11,"shl","","",264,null],[11,"shl","","",264,null],[11,"shl","","",264,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"u128"}}],[11,"shl","","",264,null],[11,"shl","","",264,null],[11,"shl","","",264,null],[11,"shl","","",264,{"inputs":[{"name":"self"},{"name":"u128"}],"output":{"name":"u128"}}],[11,"shl","","",264,null],[11,"shl","","",264,null],[11,"shl","","",264,null],[11,"shl","","",264,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"u128"}}],[11,"shl","","",264,null],[11,"shl","","",264,null],[11,"shl","","",264,null],[11,"shl","","",264,{"inputs":[{"name":"self"},{"name":"i8"}],"output":{"name":"u128"}}],[11,"shl","","",264,null],[11,"shl","","",264,null],[11,"shl","","",264,null],[11,"shl","","",264,{"inputs":[{"name":"self"},{"name":"i16"}],"output":{"name":"u128"}}],[11,"shl","","",264,null],[11,"shl","","",264,null],[11,"shl","","",264,null],[11,"shl","","",264,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"u128"}}],[11,"shl","","",264,null],[11,"shl","","",264,null],[11,"shl","","",264,null],[11,"shl","","",264,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"u128"}}],[11,"shl","","",264,null],[11,"shl","","",264,null],[11,"shl","","",264,null],[11,"shl","","",264,{"inputs":[{"name":"self"},{"name":"i128"}],"output":{"name":"u128"}}],[11,"shl","","",264,null],[11,"shl","","",264,null],[11,"shl","","",264,null],[11,"shl","","",264,{"inputs":[{"name":"self"},{"name":"isize"}],"output":{"name":"u128"}}],[11,"shl","","",264,null],[11,"shl","","",264,null],[11,"shl","","",264,null],[11,"shl","","",323,{"inputs":[{"name":"self"},{"name":"u8"}],"output":{"name":"usize"}}],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,{"inputs":[{"name":"self"},{"name":"u16"}],"output":{"name":"usize"}}],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"usize"}}],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"usize"}}],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,{"inputs":[{"name":"self"},{"name":"u128"}],"output":{"name":"usize"}}],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"usize"}}],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,{"inputs":[{"name":"self"},{"name":"i8"}],"output":{"name":"usize"}}],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,{"inputs":[{"name":"self"},{"name":"i16"}],"output":{"name":"usize"}}],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"usize"}}],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"usize"}}],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,{"inputs":[{"name":"self"},{"name":"i128"}],"output":{"name":"usize"}}],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,{"inputs":[{"name":"self"},{"name":"isize"}],"output":{"name":"usize"}}],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",324,{"inputs":[{"name":"self"},{"name":"u8"}],"output":{"name":"i8"}}],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,{"inputs":[{"name":"self"},{"name":"u16"}],"output":{"name":"i8"}}],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"i8"}}],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"i8"}}],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,{"inputs":[{"name":"self"},{"name":"u128"}],"output":{"name":"i8"}}],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"i8"}}],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,{"inputs":[{"name":"self"},{"name":"i8"}],"output":{"name":"i8"}}],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,{"inputs":[{"name":"self"},{"name":"i16"}],"output":{"name":"i8"}}],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"i8"}}],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"i8"}}],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,{"inputs":[{"name":"self"},{"name":"i128"}],"output":{"name":"i8"}}],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,{"inputs":[{"name":"self"},{"name":"isize"}],"output":{"name":"i8"}}],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",325,{"inputs":[{"name":"self"},{"name":"u8"}],"output":{"name":"i16"}}],[11,"shl","","",325,null],[11,"shl","","",325,null],[11,"shl","","",325,null],[11,"shl","","",325,{"inputs":[{"name":"self"},{"name":"u16"}],"output":{"name":"i16"}}],[11,"shl","","",325,null],[11,"shl","","",325,null],[11,"shl","","",325,null],[11,"shl","","",325,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"i16"}}],[11,"shl","","",325,null],[11,"shl","","",325,null],[11,"shl","","",325,null],[11,"shl","","",325,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"i16"}}],[11,"shl","","",325,null],[11,"shl","","",325,null],[11,"shl","","",325,null],[11,"shl","","",325,{"inputs":[{"name":"self"},{"name":"u128"}],"output":{"name":"i16"}}],[11,"shl","","",325,null],[11,"shl","","",325,null],[11,"shl","","",325,null],[11,"shl","","",325,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"i16"}}],[11,"shl","","",325,null],[11,"shl","","",325,null],[11,"shl","","",325,null],[11,"shl","","",325,{"inputs":[{"name":"self"},{"name":"i8"}],"output":{"name":"i16"}}],[11,"shl","","",325,null],[11,"shl","","",325,null],[11,"shl","","",325,null],[11,"shl","","",325,{"inputs":[{"name":"self"},{"name":"i16"}],"output":{"name":"i16"}}],[11,"shl","","",325,null],[11,"shl","","",325,null],[11,"shl","","",325,null],[11,"shl","","",325,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"i16"}}],[11,"shl","","",325,null],[11,"shl","","",325,null],[11,"shl","","",325,null],[11,"shl","","",325,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"i16"}}],[11,"shl","","",325,null],[11,"shl","","",325,null],[11,"shl","","",325,null],[11,"shl","","",325,{"inputs":[{"name":"self"},{"name":"i128"}],"output":{"name":"i16"}}],[11,"shl","","",325,null],[11,"shl","","",325,null],[11,"shl","","",325,null],[11,"shl","","",325,{"inputs":[{"name":"self"},{"name":"isize"}],"output":{"name":"i16"}}],[11,"shl","","",325,null],[11,"shl","","",325,null],[11,"shl","","",325,null],[11,"shl","","",326,{"inputs":[{"name":"self"},{"name":"u8"}],"output":{"name":"i32"}}],[11,"shl","","",326,null],[11,"shl","","",326,null],[11,"shl","","",326,null],[11,"shl","","",326,{"inputs":[{"name":"self"},{"name":"u16"}],"output":{"name":"i32"}}],[11,"shl","","",326,null],[11,"shl","","",326,null],[11,"shl","","",326,null],[11,"shl","","",326,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"i32"}}],[11,"shl","","",326,null],[11,"shl","","",326,null],[11,"shl","","",326,null],[11,"shl","","",326,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"i32"}}],[11,"shl","","",326,null],[11,"shl","","",326,null],[11,"shl","","",326,null],[11,"shl","","",326,{"inputs":[{"name":"self"},{"name":"u128"}],"output":{"name":"i32"}}],[11,"shl","","",326,null],[11,"shl","","",326,null],[11,"shl","","",326,null],[11,"shl","","",326,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"i32"}}],[11,"shl","","",326,null],[11,"shl","","",326,null],[11,"shl","","",326,null],[11,"shl","","",326,{"inputs":[{"name":"self"},{"name":"i8"}],"output":{"name":"i32"}}],[11,"shl","","",326,null],[11,"shl","","",326,null],[11,"shl","","",326,null],[11,"shl","","",326,{"inputs":[{"name":"self"},{"name":"i16"}],"output":{"name":"i32"}}],[11,"shl","","",326,null],[11,"shl","","",326,null],[11,"shl","","",326,null],[11,"shl","","",326,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"i32"}}],[11,"shl","","",326,null],[11,"shl","","",326,null],[11,"shl","","",326,null],[11,"shl","","",326,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"i32"}}],[11,"shl","","",326,null],[11,"shl","","",326,null],[11,"shl","","",326,null],[11,"shl","","",326,{"inputs":[{"name":"self"},{"name":"i128"}],"output":{"name":"i32"}}],[11,"shl","","",326,null],[11,"shl","","",326,null],[11,"shl","","",326,null],[11,"shl","","",326,{"inputs":[{"name":"self"},{"name":"isize"}],"output":{"name":"i32"}}],[11,"shl","","",326,null],[11,"shl","","",326,null],[11,"shl","","",326,null],[11,"shl","","",327,{"inputs":[{"name":"self"},{"name":"u8"}],"output":{"name":"i64"}}],[11,"shl","","",327,null],[11,"shl","","",327,null],[11,"shl","","",327,null],[11,"shl","","",327,{"inputs":[{"name":"self"},{"name":"u16"}],"output":{"name":"i64"}}],[11,"shl","","",327,null],[11,"shl","","",327,null],[11,"shl","","",327,null],[11,"shl","","",327,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"i64"}}],[11,"shl","","",327,null],[11,"shl","","",327,null],[11,"shl","","",327,null],[11,"shl","","",327,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"i64"}}],[11,"shl","","",327,null],[11,"shl","","",327,null],[11,"shl","","",327,null],[11,"shl","","",327,{"inputs":[{"name":"self"},{"name":"u128"}],"output":{"name":"i64"}}],[11,"shl","","",327,null],[11,"shl","","",327,null],[11,"shl","","",327,null],[11,"shl","","",327,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"i64"}}],[11,"shl","","",327,null],[11,"shl","","",327,null],[11,"shl","","",327,null],[11,"shl","","",327,{"inputs":[{"name":"self"},{"name":"i8"}],"output":{"name":"i64"}}],[11,"shl","","",327,null],[11,"shl","","",327,null],[11,"shl","","",327,null],[11,"shl","","",327,{"inputs":[{"name":"self"},{"name":"i16"}],"output":{"name":"i64"}}],[11,"shl","","",327,null],[11,"shl","","",327,null],[11,"shl","","",327,null],[11,"shl","","",327,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"i64"}}],[11,"shl","","",327,null],[11,"shl","","",327,null],[11,"shl","","",327,null],[11,"shl","","",327,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"i64"}}],[11,"shl","","",327,null],[11,"shl","","",327,null],[11,"shl","","",327,null],[11,"shl","","",327,{"inputs":[{"name":"self"},{"name":"i128"}],"output":{"name":"i64"}}],[11,"shl","","",327,null],[11,"shl","","",327,null],[11,"shl","","",327,null],[11,"shl","","",327,{"inputs":[{"name":"self"},{"name":"isize"}],"output":{"name":"i64"}}],[11,"shl","","",327,null],[11,"shl","","",327,null],[11,"shl","","",327,null],[11,"shl","","",328,{"inputs":[{"name":"self"},{"name":"u8"}],"output":{"name":"isize"}}],[11,"shl","","",328,null],[11,"shl","","",328,null],[11,"shl","","",328,null],[11,"shl","","",328,{"inputs":[{"name":"self"},{"name":"u16"}],"output":{"name":"isize"}}],[11,"shl","","",328,null],[11,"shl","","",328,null],[11,"shl","","",328,null],[11,"shl","","",328,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"isize"}}],[11,"shl","","",328,null],[11,"shl","","",328,null],[11,"shl","","",328,null],[11,"shl","","",328,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"isize"}}],[11,"shl","","",328,null],[11,"shl","","",328,null],[11,"shl","","",328,null],[11,"shl","","",328,{"inputs":[{"name":"self"},{"name":"u128"}],"output":{"name":"isize"}}],[11,"shl","","",328,null],[11,"shl","","",328,null],[11,"shl","","",328,null],[11,"shl","","",328,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"isize"}}],[11,"shl","","",328,null],[11,"shl","","",328,null],[11,"shl","","",328,null],[11,"shl","","",328,{"inputs":[{"name":"self"},{"name":"i8"}],"output":{"name":"isize"}}],[11,"shl","","",328,null],[11,"shl","","",328,null],[11,"shl","","",328,null],[11,"shl","","",328,{"inputs":[{"name":"self"},{"name":"i16"}],"output":{"name":"isize"}}],[11,"shl","","",328,null],[11,"shl","","",328,null],[11,"shl","","",328,null],[11,"shl","","",328,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"isize"}}],[11,"shl","","",328,null],[11,"shl","","",328,null],[11,"shl","","",328,null],[11,"shl","","",328,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"isize"}}],[11,"shl","","",328,null],[11,"shl","","",328,null],[11,"shl","","",328,null],[11,"shl","","",328,{"inputs":[{"name":"self"},{"name":"i128"}],"output":{"name":"isize"}}],[11,"shl","","",328,null],[11,"shl","","",328,null],[11,"shl","","",328,null],[11,"shl","","",328,{"inputs":[{"name":"self"},{"name":"isize"}],"output":{"name":"isize"}}],[11,"shl","","",328,null],[11,"shl","","",328,null],[11,"shl","","",328,null],[11,"shl","","",265,{"inputs":[{"name":"self"},{"name":"u8"}],"output":{"name":"i128"}}],[11,"shl","","",265,null],[11,"shl","","",265,null],[11,"shl","","",265,null],[11,"shl","","",265,{"inputs":[{"name":"self"},{"name":"u16"}],"output":{"name":"i128"}}],[11,"shl","","",265,null],[11,"shl","","",265,null],[11,"shl","","",265,null],[11,"shl","","",265,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"i128"}}],[11,"shl","","",265,null],[11,"shl","","",265,null],[11,"shl","","",265,null],[11,"shl","","",265,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"i128"}}],[11,"shl","","",265,null],[11,"shl","","",265,null],[11,"shl","","",265,null],[11,"shl","","",265,{"inputs":[{"name":"self"},{"name":"u128"}],"output":{"name":"i128"}}],[11,"shl","","",265,null],[11,"shl","","",265,null],[11,"shl","","",265,null],[11,"shl","","",265,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"i128"}}],[11,"shl","","",265,null],[11,"shl","","",265,null],[11,"shl","","",265,null],[11,"shl","","",265,{"inputs":[{"name":"self"},{"name":"i8"}],"output":{"name":"i128"}}],[11,"shl","","",265,null],[11,"shl","","",265,null],[11,"shl","","",265,null],[11,"shl","","",265,{"inputs":[{"name":"self"},{"name":"i16"}],"output":{"name":"i128"}}],[11,"shl","","",265,null],[11,"shl","","",265,null],[11,"shl","","",265,null],[11,"shl","","",265,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"i128"}}],[11,"shl","","",265,null],[11,"shl","","",265,null],[11,"shl","","",265,null],[11,"shl","","",265,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"i128"}}],[11,"shl","","",265,null],[11,"shl","","",265,null],[11,"shl","","",265,null],[11,"shl","","",265,{"inputs":[{"name":"self"},{"name":"i128"}],"output":{"name":"i128"}}],[11,"shl","","",265,null],[11,"shl","","",265,null],[11,"shl","","",265,null],[11,"shl","","",265,{"inputs":[{"name":"self"},{"name":"isize"}],"output":{"name":"i128"}}],[11,"shl","","",265,null],[11,"shl","","",265,null],[11,"shl","","",265,null],[11,"fmt","","",329,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",330,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"borrow","","",341,null],[11,"borrow","","",341,null],[11,"borrow","","",341,null],[11,"borrow","","",341,null],[11,"borrow","","",341,null],[11,"borrow","","",341,null],[11,"borrow","","",341,null],[11,"borrow","","",341,null],[11,"borrow","","",341,null],[11,"borrow","","",341,null],[11,"borrow","","",341,null],[11,"borrow","","",341,null],[11,"borrow","","",341,null],[11,"borrow","","",341,null],[11,"borrow","","",341,null],[11,"borrow","","",341,null],[11,"borrow","","",341,null],[11,"borrow","","",341,null],[11,"borrow","","",341,null],[11,"borrow","","",341,null],[11,"borrow","","",341,null],[11,"borrow","","",341,null],[11,"borrow","","",341,null],[11,"borrow","","",341,null],[11,"borrow","","",341,null],[11,"borrow","","",341,null],[11,"borrow","","",341,null],[11,"borrow","","",341,null],[11,"borrow","","",341,null],[11,"borrow","","",341,null],[11,"borrow","","",341,null],[11,"borrow","","",341,null],[11,"borrow","","",341,null],[11,"as_mut","","",276,null],[11,"as_mut","","",341,null],[11,"as_mut","","",341,null],[11,"as_mut","","",341,null],[11,"as_mut","","",341,null],[11,"as_mut","","",341,null],[11,"as_mut","","",341,null],[11,"as_mut","","",341,null],[11,"as_mut","","",341,null],[11,"as_mut","","",341,null],[11,"as_mut","","",341,null],[11,"as_mut","","",341,null],[11,"as_mut","","",341,null],[11,"as_mut","","",341,null],[11,"as_mut","","",341,null],[11,"as_mut","","",341,null],[11,"as_mut","","",341,null],[11,"as_mut","","",341,null],[11,"as_mut","","",341,null],[11,"as_mut","","",341,null],[11,"as_mut","","",341,null],[11,"as_mut","","",341,null],[11,"as_mut","","",341,null],[11,"as_mut","","",341,null],[11,"as_mut","","",341,null],[11,"as_mut","","",341,null],[11,"as_mut","","",341,null],[11,"as_mut","","",341,null],[11,"as_mut","","",341,null],[11,"as_mut","","",341,null],[11,"as_mut","","",341,null],[11,"as_mut","","",341,null],[11,"as_mut","","",341,null],[11,"as_mut","","",341,null],[11,"fmt","std::num","",189,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std","",328,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",323,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",324,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",319,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",325,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",320,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",326,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",321,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",327,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",322,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",265,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",264,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::num","",189,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",336,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",356,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",337,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::cell","",123,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",124,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::char","",125,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",342,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",343,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",357,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::str","",116,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",117,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::fmt","",358,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",122,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std","",339,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",277,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",331,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",329,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",330,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",324,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",319,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",325,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",320,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",326,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",321,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",327,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",322,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",265,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",264,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",328,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",323,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"deref_mut","std::cell","",359,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"haystack","std::str::pattern","",360,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"next","","",360,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match","","",360,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject","","",360,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"haystack","","",361,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"next","","",361,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match","","",361,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject","","",361,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"haystack","","",362,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"next","","",362,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match","","",362,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject","","",362,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"haystack","","",363,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"next","","",363,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match","","",363,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"from_iter","std::option","Takes each element in the `Iterator`: if it is `None`, no further elements are taken, and the `None` is returned. Should no `None` occur, a container with the values of each `Option` is returned.",69,{"inputs":[{"name":"i"}],"output":{"name":"option"}}],[11,"from_iter","std::result","Takes each element in the `Iterator`: if it is an `Err`, no further elements are taken, and the `Err` is returned. Should no `Err` occur, a container with the values of each `Result` is returned.",68,{"inputs":[{"name":"i"}],"output":{"name":"result"}}],[11,"next","std::char","",342,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",342,null],[11,"count","","",342,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"last","","",342,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",343,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",343,null],[11,"count","","",343,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"nth","","",343,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",343,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",357,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",357,null],[11,"next","","",364,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","std::iter","",365,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",365,null],[11,"next","","",365,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",365,null],[11,"next","","",365,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",365,null],[11,"next","std::ops","",51,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",51,null],[11,"next","","",52,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",54,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",54,null],[11,"next","std::iter","",366,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",366,null],[11,"next","","",344,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",344,null],[11,"next","","",345,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",345,null],[11,"next","","",346,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",346,null],[11,"next","","",347,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",347,null],[11,"fold","","",347,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"f"}],"output":{"name":"acc"}}],[11,"next","","",367,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",367,null],[11,"next","","",368,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"count","","",368,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"fold","","",368,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"f"}],"output":{"name":"acc"}}],[11,"nth","","",368,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"find","","",368,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"option"}}],[11,"last","","",368,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",368,null],[11,"next","","",369,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",369,null],[11,"next","","",348,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",348,null],[11,"fold","","",348,{"inputs":[{"name":"self"},{"name":"acc"},{"name":"g"}],"output":{"name":"acc"}}],[11,"next","","",370,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",370,null],[11,"count","","",370,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"next","","",371,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",371,null],[11,"next","","Overflow Behavior",349,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",349,null],[11,"nth","","",349,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"count","","",349,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"next","","",372,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"count","","",372,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"nth","","",372,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",372,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",372,null],[11,"next","","",373,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",373,null],[11,"next","","",374,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",374,null],[11,"next","","",375,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"nth","","",375,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"count","","",375,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"last","","",375,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",375,null],[11,"next","","",376,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"nth","","",376,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"size_hint","","",376,null],[11,"next","","",377,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",377,null],[11,"next","","",378,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",378,null],[11,"next","","",350,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"nth","","",350,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",350,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"count","","",350,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"size_hint","","",350,null],[11,"next","","",350,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"nth","","",350,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",350,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"count","","",350,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"size_hint","","",350,null],[11,"next","","",351,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",351,null],[11,"next","std::option","",379,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",379,null],[11,"next","","",380,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",380,null],[11,"next","","",381,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",381,null],[11,"next","std::result","",382,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",382,null],[11,"next","","",383,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",383,null],[11,"next","","",384,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",384,null],[11,"next","std::slice","",385,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",385,null],[11,"next","","",386,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",386,null],[11,"next","","",387,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",387,null],[11,"count","","",387,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"nth","","",387,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",387,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",388,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",388,null],[11,"count","","",388,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"nth","","",388,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",388,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",389,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",389,null],[11,"count","","",389,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"nth","","",389,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",389,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","std::str","",390,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"count","","",390,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"size_hint","","",390,null],[11,"last","","",390,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",391,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"count","","",391,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"size_hint","","",391,null],[11,"last","","",391,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",354,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",354,null],[11,"count","","",354,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"last","","",354,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"nth","","",354,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"next","","",392,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",392,null],[11,"next","","",393,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",393,null],[11,"next","std::slice","",352,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",352,null],[11,"count","","",352,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"nth","","",352,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",352,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"all","","",352,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"any","","",352,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"find","","",352,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"position","","",352,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"rposition","","",352,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"next","","",353,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",353,null],[11,"count","","",353,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"nth","","",353,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"last","","",353,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"all","","",353,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"any","","",353,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"find","","",353,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"position","","",353,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"rposition","","",353,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"option"}}],[11,"next","","",394,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",394,null],[11,"next","","",395,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",395,null],[11,"next","","",396,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",396,null],[11,"next","","",397,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",397,null],[11,"next","std::str","",398,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",399,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",400,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",401,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",402,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",403,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",404,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",405,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",406,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next","","",407,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"sum","std::result","",68,{"inputs":[{"name":"i"}],"output":{"name":"result"}}],[11,"sum","std","",324,{"inputs":[{"name":"i"}],"output":{"name":"i8"}}],[11,"sum","","",324,{"inputs":[{"name":"i"}],"output":{"name":"i8"}}],[11,"sum","","",325,{"inputs":[{"name":"i"}],"output":{"name":"i16"}}],[11,"sum","","",325,{"inputs":[{"name":"i"}],"output":{"name":"i16"}}],[11,"sum","","",326,{"inputs":[{"name":"i"}],"output":{"name":"i32"}}],[11,"sum","","",326,{"inputs":[{"name":"i"}],"output":{"name":"i32"}}],[11,"sum","","",327,{"inputs":[{"name":"i"}],"output":{"name":"i64"}}],[11,"sum","","",327,{"inputs":[{"name":"i"}],"output":{"name":"i64"}}],[11,"sum","","",328,{"inputs":[{"name":"i"}],"output":{"name":"isize"}}],[11,"sum","","",328,{"inputs":[{"name":"i"}],"output":{"name":"isize"}}],[11,"sum","","",319,{"inputs":[{"name":"i"}],"output":{"name":"u8"}}],[11,"sum","","",319,{"inputs":[{"name":"i"}],"output":{"name":"u8"}}],[11,"sum","","",320,{"inputs":[{"name":"i"}],"output":{"name":"u16"}}],[11,"sum","","",320,{"inputs":[{"name":"i"}],"output":{"name":"u16"}}],[11,"sum","","",321,{"inputs":[{"name":"i"}],"output":{"name":"u32"}}],[11,"sum","","",321,{"inputs":[{"name":"i"}],"output":{"name":"u32"}}],[11,"sum","","",322,{"inputs":[{"name":"i"}],"output":{"name":"u64"}}],[11,"sum","","",322,{"inputs":[{"name":"i"}],"output":{"name":"u64"}}],[11,"sum","","",323,{"inputs":[{"name":"i"}],"output":{"name":"usize"}}],[11,"sum","","",323,{"inputs":[{"name":"i"}],"output":{"name":"usize"}}],[11,"sum","std::num","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","std","",329,{"inputs":[{"name":"i"}],"output":{"name":"f32"}}],[11,"sum","","",329,{"inputs":[{"name":"i"}],"output":{"name":"f32"}}],[11,"sum","","",330,{"inputs":[{"name":"i"}],"output":{"name":"f64"}}],[11,"sum","","",330,{"inputs":[{"name":"i"}],"output":{"name":"f64"}}],[11,"write","std::hash","",408,null],[11,"finish","","",408,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"write","","",409,null],[11,"finish","","",409,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"write","","",410,null],[11,"finish","","",410,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"rem","std::num","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"rem","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"rem","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"rem","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"rem","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"rem","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"rem","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"rem","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"rem","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"rem","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"rem","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"rem","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"rem","","",189,null],[11,"rem","","",189,null],[11,"rem","","",189,null],[11,"rem","","",189,null],[11,"rem","","",189,null],[11,"rem","","",189,null],[11,"rem","","",189,null],[11,"rem","","",189,null],[11,"rem","","",189,null],[11,"rem","","",189,null],[11,"rem","","",189,null],[11,"rem","","",189,null],[11,"rem","std","",323,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"usize"}}],[11,"rem","","",319,{"inputs":[{"name":"self"},{"name":"u8"}],"output":{"name":"u8"}}],[11,"rem","","",320,{"inputs":[{"name":"self"},{"name":"u16"}],"output":{"name":"u16"}}],[11,"rem","","",321,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"u32"}}],[11,"rem","","",322,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"u64"}}],[11,"rem","","",264,{"inputs":[{"name":"self"},{"name":"u128"}],"output":{"name":"u128"}}],[11,"rem","","",328,{"inputs":[{"name":"self"},{"name":"isize"}],"output":{"name":"isize"}}],[11,"rem","","",324,{"inputs":[{"name":"self"},{"name":"i8"}],"output":{"name":"i8"}}],[11,"rem","","",325,{"inputs":[{"name":"self"},{"name":"i16"}],"output":{"name":"i16"}}],[11,"rem","","",326,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"i32"}}],[11,"rem","","",327,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"i64"}}],[11,"rem","","",265,{"inputs":[{"name":"self"},{"name":"i128"}],"output":{"name":"i128"}}],[11,"rem","","",323,null],[11,"rem","","",323,null],[11,"rem","","",323,null],[11,"rem","","",319,null],[11,"rem","","",319,null],[11,"rem","","",319,null],[11,"rem","","",320,null],[11,"rem","","",320,null],[11,"rem","","",320,null],[11,"rem","","",321,null],[11,"rem","","",321,null],[11,"rem","","",321,null],[11,"rem","","",322,null],[11,"rem","","",322,null],[11,"rem","","",322,null],[11,"rem","","",264,null],[11,"rem","","",264,null],[11,"rem","","",264,null],[11,"rem","","",328,null],[11,"rem","","",328,null],[11,"rem","","",328,null],[11,"rem","","",324,null],[11,"rem","","",324,null],[11,"rem","","",324,null],[11,"rem","","",325,null],[11,"rem","","",325,null],[11,"rem","","",325,null],[11,"rem","","",326,null],[11,"rem","","",326,null],[11,"rem","","",326,null],[11,"rem","","",327,null],[11,"rem","","",327,null],[11,"rem","","",327,null],[11,"rem","","",265,null],[11,"rem","","",265,null],[11,"rem","","",265,null],[11,"rem","","",329,{"inputs":[{"name":"self"},{"name":"f32"}],"output":{"name":"f32"}}],[11,"rem","","",330,{"inputs":[{"name":"self"},{"name":"f64"}],"output":{"name":"f64"}}],[11,"rem","","",329,null],[11,"rem","","",329,null],[11,"rem","","",329,null],[11,"rem","","",330,null],[11,"rem","","",330,null],[11,"rem","","",330,null],[11,"shr","std::num","",189,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shr","","",189,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shr","","",189,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shr","","",189,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shr","","",189,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shr","","",189,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shr","","",189,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shr","","",189,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shr","","",189,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shr","","",189,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"wrapping"}}],[11,"shr","std","",319,{"inputs":[{"name":"self"},{"name":"u8"}],"output":{"name":"u8"}}],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,{"inputs":[{"name":"self"},{"name":"u16"}],"output":{"name":"u8"}}],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"u8"}}],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"u8"}}],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,{"inputs":[{"name":"self"},{"name":"u128"}],"output":{"name":"u8"}}],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"u8"}}],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,{"inputs":[{"name":"self"},{"name":"i8"}],"output":{"name":"u8"}}],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,{"inputs":[{"name":"self"},{"name":"i16"}],"output":{"name":"u8"}}],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"u8"}}],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"u8"}}],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,{"inputs":[{"name":"self"},{"name":"i128"}],"output":{"name":"u8"}}],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,{"inputs":[{"name":"self"},{"name":"isize"}],"output":{"name":"u8"}}],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",320,{"inputs":[{"name":"self"},{"name":"u8"}],"output":{"name":"u16"}}],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,{"inputs":[{"name":"self"},{"name":"u16"}],"output":{"name":"u16"}}],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"u16"}}],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"u16"}}],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,{"inputs":[{"name":"self"},{"name":"u128"}],"output":{"name":"u16"}}],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"u16"}}],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,{"inputs":[{"name":"self"},{"name":"i8"}],"output":{"name":"u16"}}],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,{"inputs":[{"name":"self"},{"name":"i16"}],"output":{"name":"u16"}}],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"u16"}}],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"u16"}}],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,{"inputs":[{"name":"self"},{"name":"i128"}],"output":{"name":"u16"}}],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,{"inputs":[{"name":"self"},{"name":"isize"}],"output":{"name":"u16"}}],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",321,{"inputs":[{"name":"self"},{"name":"u8"}],"output":{"name":"u32"}}],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,{"inputs":[{"name":"self"},{"name":"u16"}],"output":{"name":"u32"}}],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"u32"}}],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"u32"}}],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,{"inputs":[{"name":"self"},{"name":"u128"}],"output":{"name":"u32"}}],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"u32"}}],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,{"inputs":[{"name":"self"},{"name":"i8"}],"output":{"name":"u32"}}],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,{"inputs":[{"name":"self"},{"name":"i16"}],"output":{"name":"u32"}}],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"u32"}}],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"u32"}}],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,{"inputs":[{"name":"self"},{"name":"i128"}],"output":{"name":"u32"}}],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,{"inputs":[{"name":"self"},{"name":"isize"}],"output":{"name":"u32"}}],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",322,{"inputs":[{"name":"self"},{"name":"u8"}],"output":{"name":"u64"}}],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,{"inputs":[{"name":"self"},{"name":"u16"}],"output":{"name":"u64"}}],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"u64"}}],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"u64"}}],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,{"inputs":[{"name":"self"},{"name":"u128"}],"output":{"name":"u64"}}],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"u64"}}],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,{"inputs":[{"name":"self"},{"name":"i8"}],"output":{"name":"u64"}}],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,{"inputs":[{"name":"self"},{"name":"i16"}],"output":{"name":"u64"}}],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"u64"}}],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"u64"}}],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,{"inputs":[{"name":"self"},{"name":"i128"}],"output":{"name":"u64"}}],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,{"inputs":[{"name":"self"},{"name":"isize"}],"output":{"name":"u64"}}],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",264,{"inputs":[{"name":"self"},{"name":"u8"}],"output":{"name":"u128"}}],[11,"shr","","",264,null],[11,"shr","","",264,null],[11,"shr","","",264,null],[11,"shr","","",264,{"inputs":[{"name":"self"},{"name":"u16"}],"output":{"name":"u128"}}],[11,"shr","","",264,null],[11,"shr","","",264,null],[11,"shr","","",264,null],[11,"shr","","",264,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"u128"}}],[11,"shr","","",264,null],[11,"shr","","",264,null],[11,"shr","","",264,null],[11,"shr","","",264,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"u128"}}],[11,"shr","","",264,null],[11,"shr","","",264,null],[11,"shr","","",264,null],[11,"shr","","",264,{"inputs":[{"name":"self"},{"name":"u128"}],"output":{"name":"u128"}}],[11,"shr","","",264,null],[11,"shr","","",264,null],[11,"shr","","",264,null],[11,"shr","","",264,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"u128"}}],[11,"shr","","",264,null],[11,"shr","","",264,null],[11,"shr","","",264,null],[11,"shr","","",264,{"inputs":[{"name":"self"},{"name":"i8"}],"output":{"name":"u128"}}],[11,"shr","","",264,null],[11,"shr","","",264,null],[11,"shr","","",264,null],[11,"shr","","",264,{"inputs":[{"name":"self"},{"name":"i16"}],"output":{"name":"u128"}}],[11,"shr","","",264,null],[11,"shr","","",264,null],[11,"shr","","",264,null],[11,"shr","","",264,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"u128"}}],[11,"shr","","",264,null],[11,"shr","","",264,null],[11,"shr","","",264,null],[11,"shr","","",264,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"u128"}}],[11,"shr","","",264,null],[11,"shr","","",264,null],[11,"shr","","",264,null],[11,"shr","","",264,{"inputs":[{"name":"self"},{"name":"i128"}],"output":{"name":"u128"}}],[11,"shr","","",264,null],[11,"shr","","",264,null],[11,"shr","","",264,null],[11,"shr","","",264,{"inputs":[{"name":"self"},{"name":"isize"}],"output":{"name":"u128"}}],[11,"shr","","",264,null],[11,"shr","","",264,null],[11,"shr","","",264,null],[11,"shr","","",323,{"inputs":[{"name":"self"},{"name":"u8"}],"output":{"name":"usize"}}],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,{"inputs":[{"name":"self"},{"name":"u16"}],"output":{"name":"usize"}}],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"usize"}}],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"usize"}}],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,{"inputs":[{"name":"self"},{"name":"u128"}],"output":{"name":"usize"}}],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"usize"}}],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,{"inputs":[{"name":"self"},{"name":"i8"}],"output":{"name":"usize"}}],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,{"inputs":[{"name":"self"},{"name":"i16"}],"output":{"name":"usize"}}],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"usize"}}],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"usize"}}],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,{"inputs":[{"name":"self"},{"name":"i128"}],"output":{"name":"usize"}}],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,{"inputs":[{"name":"self"},{"name":"isize"}],"output":{"name":"usize"}}],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",324,{"inputs":[{"name":"self"},{"name":"u8"}],"output":{"name":"i8"}}],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,{"inputs":[{"name":"self"},{"name":"u16"}],"output":{"name":"i8"}}],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"i8"}}],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"i8"}}],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,{"inputs":[{"name":"self"},{"name":"u128"}],"output":{"name":"i8"}}],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"i8"}}],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,{"inputs":[{"name":"self"},{"name":"i8"}],"output":{"name":"i8"}}],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,{"inputs":[{"name":"self"},{"name":"i16"}],"output":{"name":"i8"}}],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"i8"}}],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"i8"}}],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,{"inputs":[{"name":"self"},{"name":"i128"}],"output":{"name":"i8"}}],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,{"inputs":[{"name":"self"},{"name":"isize"}],"output":{"name":"i8"}}],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",325,{"inputs":[{"name":"self"},{"name":"u8"}],"output":{"name":"i16"}}],[11,"shr","","",325,null],[11,"shr","","",325,null],[11,"shr","","",325,null],[11,"shr","","",325,{"inputs":[{"name":"self"},{"name":"u16"}],"output":{"name":"i16"}}],[11,"shr","","",325,null],[11,"shr","","",325,null],[11,"shr","","",325,null],[11,"shr","","",325,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"i16"}}],[11,"shr","","",325,null],[11,"shr","","",325,null],[11,"shr","","",325,null],[11,"shr","","",325,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"i16"}}],[11,"shr","","",325,null],[11,"shr","","",325,null],[11,"shr","","",325,null],[11,"shr","","",325,{"inputs":[{"name":"self"},{"name":"u128"}],"output":{"name":"i16"}}],[11,"shr","","",325,null],[11,"shr","","",325,null],[11,"shr","","",325,null],[11,"shr","","",325,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"i16"}}],[11,"shr","","",325,null],[11,"shr","","",325,null],[11,"shr","","",325,null],[11,"shr","","",325,{"inputs":[{"name":"self"},{"name":"i8"}],"output":{"name":"i16"}}],[11,"shr","","",325,null],[11,"shr","","",325,null],[11,"shr","","",325,null],[11,"shr","","",325,{"inputs":[{"name":"self"},{"name":"i16"}],"output":{"name":"i16"}}],[11,"shr","","",325,null],[11,"shr","","",325,null],[11,"shr","","",325,null],[11,"shr","","",325,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"i16"}}],[11,"shr","","",325,null],[11,"shr","","",325,null],[11,"shr","","",325,null],[11,"shr","","",325,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"i16"}}],[11,"shr","","",325,null],[11,"shr","","",325,null],[11,"shr","","",325,null],[11,"shr","","",325,{"inputs":[{"name":"self"},{"name":"i128"}],"output":{"name":"i16"}}],[11,"shr","","",325,null],[11,"shr","","",325,null],[11,"shr","","",325,null],[11,"shr","","",325,{"inputs":[{"name":"self"},{"name":"isize"}],"output":{"name":"i16"}}],[11,"shr","","",325,null],[11,"shr","","",325,null],[11,"shr","","",325,null],[11,"shr","","",326,{"inputs":[{"name":"self"},{"name":"u8"}],"output":{"name":"i32"}}],[11,"shr","","",326,null],[11,"shr","","",326,null],[11,"shr","","",326,null],[11,"shr","","",326,{"inputs":[{"name":"self"},{"name":"u16"}],"output":{"name":"i32"}}],[11,"shr","","",326,null],[11,"shr","","",326,null],[11,"shr","","",326,null],[11,"shr","","",326,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"i32"}}],[11,"shr","","",326,null],[11,"shr","","",326,null],[11,"shr","","",326,null],[11,"shr","","",326,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"i32"}}],[11,"shr","","",326,null],[11,"shr","","",326,null],[11,"shr","","",326,null],[11,"shr","","",326,{"inputs":[{"name":"self"},{"name":"u128"}],"output":{"name":"i32"}}],[11,"shr","","",326,null],[11,"shr","","",326,null],[11,"shr","","",326,null],[11,"shr","","",326,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"i32"}}],[11,"shr","","",326,null],[11,"shr","","",326,null],[11,"shr","","",326,null],[11,"shr","","",326,{"inputs":[{"name":"self"},{"name":"i8"}],"output":{"name":"i32"}}],[11,"shr","","",326,null],[11,"shr","","",326,null],[11,"shr","","",326,null],[11,"shr","","",326,{"inputs":[{"name":"self"},{"name":"i16"}],"output":{"name":"i32"}}],[11,"shr","","",326,null],[11,"shr","","",326,null],[11,"shr","","",326,null],[11,"shr","","",326,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"i32"}}],[11,"shr","","",326,null],[11,"shr","","",326,null],[11,"shr","","",326,null],[11,"shr","","",326,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"i32"}}],[11,"shr","","",326,null],[11,"shr","","",326,null],[11,"shr","","",326,null],[11,"shr","","",326,{"inputs":[{"name":"self"},{"name":"i128"}],"output":{"name":"i32"}}],[11,"shr","","",326,null],[11,"shr","","",326,null],[11,"shr","","",326,null],[11,"shr","","",326,{"inputs":[{"name":"self"},{"name":"isize"}],"output":{"name":"i32"}}],[11,"shr","","",326,null],[11,"shr","","",326,null],[11,"shr","","",326,null],[11,"shr","","",327,{"inputs":[{"name":"self"},{"name":"u8"}],"output":{"name":"i64"}}],[11,"shr","","",327,null],[11,"shr","","",327,null],[11,"shr","","",327,null],[11,"shr","","",327,{"inputs":[{"name":"self"},{"name":"u16"}],"output":{"name":"i64"}}],[11,"shr","","",327,null],[11,"shr","","",327,null],[11,"shr","","",327,null],[11,"shr","","",327,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"i64"}}],[11,"shr","","",327,null],[11,"shr","","",327,null],[11,"shr","","",327,null],[11,"shr","","",327,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"i64"}}],[11,"shr","","",327,null],[11,"shr","","",327,null],[11,"shr","","",327,null],[11,"shr","","",327,{"inputs":[{"name":"self"},{"name":"u128"}],"output":{"name":"i64"}}],[11,"shr","","",327,null],[11,"shr","","",327,null],[11,"shr","","",327,null],[11,"shr","","",327,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"i64"}}],[11,"shr","","",327,null],[11,"shr","","",327,null],[11,"shr","","",327,null],[11,"shr","","",327,{"inputs":[{"name":"self"},{"name":"i8"}],"output":{"name":"i64"}}],[11,"shr","","",327,null],[11,"shr","","",327,null],[11,"shr","","",327,null],[11,"shr","","",327,{"inputs":[{"name":"self"},{"name":"i16"}],"output":{"name":"i64"}}],[11,"shr","","",327,null],[11,"shr","","",327,null],[11,"shr","","",327,null],[11,"shr","","",327,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"i64"}}],[11,"shr","","",327,null],[11,"shr","","",327,null],[11,"shr","","",327,null],[11,"shr","","",327,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"i64"}}],[11,"shr","","",327,null],[11,"shr","","",327,null],[11,"shr","","",327,null],[11,"shr","","",327,{"inputs":[{"name":"self"},{"name":"i128"}],"output":{"name":"i64"}}],[11,"shr","","",327,null],[11,"shr","","",327,null],[11,"shr","","",327,null],[11,"shr","","",327,{"inputs":[{"name":"self"},{"name":"isize"}],"output":{"name":"i64"}}],[11,"shr","","",327,null],[11,"shr","","",327,null],[11,"shr","","",327,null],[11,"shr","","",265,{"inputs":[{"name":"self"},{"name":"u8"}],"output":{"name":"i128"}}],[11,"shr","","",265,null],[11,"shr","","",265,null],[11,"shr","","",265,null],[11,"shr","","",265,{"inputs":[{"name":"self"},{"name":"u16"}],"output":{"name":"i128"}}],[11,"shr","","",265,null],[11,"shr","","",265,null],[11,"shr","","",265,null],[11,"shr","","",265,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"i128"}}],[11,"shr","","",265,null],[11,"shr","","",265,null],[11,"shr","","",265,null],[11,"shr","","",265,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"i128"}}],[11,"shr","","",265,null],[11,"shr","","",265,null],[11,"shr","","",265,null],[11,"shr","","",265,{"inputs":[{"name":"self"},{"name":"u128"}],"output":{"name":"i128"}}],[11,"shr","","",265,null],[11,"shr","","",265,null],[11,"shr","","",265,null],[11,"shr","","",265,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"i128"}}],[11,"shr","","",265,null],[11,"shr","","",265,null],[11,"shr","","",265,null],[11,"shr","","",265,{"inputs":[{"name":"self"},{"name":"i8"}],"output":{"name":"i128"}}],[11,"shr","","",265,null],[11,"shr","","",265,null],[11,"shr","","",265,null],[11,"shr","","",265,{"inputs":[{"name":"self"},{"name":"i16"}],"output":{"name":"i128"}}],[11,"shr","","",265,null],[11,"shr","","",265,null],[11,"shr","","",265,null],[11,"shr","","",265,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"i128"}}],[11,"shr","","",265,null],[11,"shr","","",265,null],[11,"shr","","",265,null],[11,"shr","","",265,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"i128"}}],[11,"shr","","",265,null],[11,"shr","","",265,null],[11,"shr","","",265,null],[11,"shr","","",265,{"inputs":[{"name":"self"},{"name":"i128"}],"output":{"name":"i128"}}],[11,"shr","","",265,null],[11,"shr","","",265,null],[11,"shr","","",265,null],[11,"shr","","",265,{"inputs":[{"name":"self"},{"name":"isize"}],"output":{"name":"i128"}}],[11,"shr","","",265,null],[11,"shr","","",265,null],[11,"shr","","",265,null],[11,"shr","","",328,{"inputs":[{"name":"self"},{"name":"u8"}],"output":{"name":"isize"}}],[11,"shr","","",328,null],[11,"shr","","",328,null],[11,"shr","","",328,null],[11,"shr","","",328,{"inputs":[{"name":"self"},{"name":"u16"}],"output":{"name":"isize"}}],[11,"shr","","",328,null],[11,"shr","","",328,null],[11,"shr","","",328,null],[11,"shr","","",328,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"isize"}}],[11,"shr","","",328,null],[11,"shr","","",328,null],[11,"shr","","",328,null],[11,"shr","","",328,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"isize"}}],[11,"shr","","",328,null],[11,"shr","","",328,null],[11,"shr","","",328,null],[11,"shr","","",328,{"inputs":[{"name":"self"},{"name":"u128"}],"output":{"name":"isize"}}],[11,"shr","","",328,null],[11,"shr","","",328,null],[11,"shr","","",328,null],[11,"shr","","",328,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"isize"}}],[11,"shr","","",328,null],[11,"shr","","",328,null],[11,"shr","","",328,null],[11,"shr","","",328,{"inputs":[{"name":"self"},{"name":"i8"}],"output":{"name":"isize"}}],[11,"shr","","",328,null],[11,"shr","","",328,null],[11,"shr","","",328,null],[11,"shr","","",328,{"inputs":[{"name":"self"},{"name":"i16"}],"output":{"name":"isize"}}],[11,"shr","","",328,null],[11,"shr","","",328,null],[11,"shr","","",328,null],[11,"shr","","",328,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"isize"}}],[11,"shr","","",328,null],[11,"shr","","",328,null],[11,"shr","","",328,null],[11,"shr","","",328,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"isize"}}],[11,"shr","","",328,null],[11,"shr","","",328,null],[11,"shr","","",328,null],[11,"shr","","",328,{"inputs":[{"name":"self"},{"name":"i128"}],"output":{"name":"isize"}}],[11,"shr","","",328,null],[11,"shr","","",328,null],[11,"shr","","",328,null],[11,"shr","","",328,{"inputs":[{"name":"self"},{"name":"isize"}],"output":{"name":"isize"}}],[11,"shr","","",328,null],[11,"shr","","",328,null],[11,"shr","","",328,null],[11,"from","std::cell","",334,{"inputs":[{"name":"t"}],"output":{"name":"cell"}}],[11,"from","","",335,{"inputs":[{"name":"t"}],"output":{"name":"refcell"}}],[11,"from","","",411,{"inputs":[{"name":"t"}],"output":{"name":"unsafecell"}}],[11,"from","std","",321,{"inputs":[{"name":"char"}],"output":{"name":"u32"}}],[11,"from","","",331,{"inputs":[{"name":"u8"}],"output":{"name":"char"}}],[11,"from","std::option","",69,{"inputs":[{"name":"t"}],"output":{"name":"option"}}],[11,"from","std","",320,{"inputs":[{"name":"u8"}],"output":{"name":"u16"}}],[11,"from","","",321,{"inputs":[{"name":"u8"}],"output":{"name":"u32"}}],[11,"from","","",322,{"inputs":[{"name":"u8"}],"output":{"name":"u64"}}],[11,"from","","",264,{"inputs":[{"name":"u8"}],"output":{"name":"u128"}}],[11,"from","","",323,{"inputs":[{"name":"u8"}],"output":{"name":"usize"}}],[11,"from","","",321,{"inputs":[{"name":"u16"}],"output":{"name":"u32"}}],[11,"from","","",322,{"inputs":[{"name":"u16"}],"output":{"name":"u64"}}],[11,"from","","",264,{"inputs":[{"name":"u16"}],"output":{"name":"u128"}}],[11,"from","","",322,{"inputs":[{"name":"u32"}],"output":{"name":"u64"}}],[11,"from","","",264,{"inputs":[{"name":"u32"}],"output":{"name":"u128"}}],[11,"from","","",264,{"inputs":[{"name":"u64"}],"output":{"name":"u128"}}],[11,"from","","",325,{"inputs":[{"name":"i8"}],"output":{"name":"i16"}}],[11,"from","","",326,{"inputs":[{"name":"i8"}],"output":{"name":"i32"}}],[11,"from","","",327,{"inputs":[{"name":"i8"}],"output":{"name":"i64"}}],[11,"from","","",265,{"inputs":[{"name":"i8"}],"output":{"name":"i128"}}],[11,"from","","",328,{"inputs":[{"name":"i8"}],"output":{"name":"isize"}}],[11,"from","","",326,{"inputs":[{"name":"i16"}],"output":{"name":"i32"}}],[11,"from","","",327,{"inputs":[{"name":"i16"}],"output":{"name":"i64"}}],[11,"from","","",265,{"inputs":[{"name":"i16"}],"output":{"name":"i128"}}],[11,"from","","",327,{"inputs":[{"name":"i32"}],"output":{"name":"i64"}}],[11,"from","","",265,{"inputs":[{"name":"i32"}],"output":{"name":"i128"}}],[11,"from","","",265,{"inputs":[{"name":"i64"}],"output":{"name":"i128"}}],[11,"from","","",325,{"inputs":[{"name":"u8"}],"output":{"name":"i16"}}],[11,"from","","",326,{"inputs":[{"name":"u8"}],"output":{"name":"i32"}}],[11,"from","","",327,{"inputs":[{"name":"u8"}],"output":{"name":"i64"}}],[11,"from","","",265,{"inputs":[{"name":"u8"}],"output":{"name":"i128"}}],[11,"from","","",326,{"inputs":[{"name":"u16"}],"output":{"name":"i32"}}],[11,"from","","",327,{"inputs":[{"name":"u16"}],"output":{"name":"i64"}}],[11,"from","","",265,{"inputs":[{"name":"u16"}],"output":{"name":"i128"}}],[11,"from","","",327,{"inputs":[{"name":"u32"}],"output":{"name":"i64"}}],[11,"from","","",265,{"inputs":[{"name":"u32"}],"output":{"name":"i128"}}],[11,"from","","",265,{"inputs":[{"name":"u64"}],"output":{"name":"i128"}}],[11,"from","","",329,{"inputs":[{"name":"i8"}],"output":{"name":"f32"}}],[11,"from","","",330,{"inputs":[{"name":"i8"}],"output":{"name":"f64"}}],[11,"from","","",329,{"inputs":[{"name":"i16"}],"output":{"name":"f32"}}],[11,"from","","",330,{"inputs":[{"name":"i16"}],"output":{"name":"f64"}}],[11,"from","","",330,{"inputs":[{"name":"i32"}],"output":{"name":"f64"}}],[11,"from","","",329,{"inputs":[{"name":"u8"}],"output":{"name":"f32"}}],[11,"from","","",330,{"inputs":[{"name":"u8"}],"output":{"name":"f64"}}],[11,"from","","",329,{"inputs":[{"name":"u16"}],"output":{"name":"f32"}}],[11,"from","","",330,{"inputs":[{"name":"u16"}],"output":{"name":"f64"}}],[11,"from","","",330,{"inputs":[{"name":"u32"}],"output":{"name":"f64"}}],[11,"from","","",330,{"inputs":[{"name":"f32"}],"output":{"name":"f64"}}],[11,"fmt","std::ptr","",412,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",413,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std","",333,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",333,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"as_ref","","",276,null],[11,"as_ref","","",277,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"as_ref","std::slice","",352,null],[11,"as_ref","std","",277,null],[11,"as_ref","","",341,null],[11,"as_ref","","",341,null],[11,"as_ref","","",341,null],[11,"as_ref","","",341,null],[11,"as_ref","","",341,null],[11,"as_ref","","",341,null],[11,"as_ref","","",341,null],[11,"as_ref","","",341,null],[11,"as_ref","","",341,null],[11,"as_ref","","",341,null],[11,"as_ref","","",341,null],[11,"as_ref","","",341,null],[11,"as_ref","","",341,null],[11,"as_ref","","",341,null],[11,"as_ref","","",341,null],[11,"as_ref","","",341,null],[11,"as_ref","","",341,null],[11,"as_ref","","",341,null],[11,"as_ref","","",341,null],[11,"as_ref","","",341,null],[11,"as_ref","","",341,null],[11,"as_ref","","",341,null],[11,"as_ref","","",341,null],[11,"as_ref","","",341,null],[11,"as_ref","","",341,null],[11,"as_ref","","",341,null],[11,"as_ref","","",341,null],[11,"as_ref","","",341,null],[11,"as_ref","","",341,null],[11,"as_ref","","",341,null],[11,"as_ref","","",341,null],[11,"as_ref","","",341,null],[11,"as_ref","","",341,null],[11,"fmt","std::num","",189,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std","",328,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",323,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",324,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",319,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",325,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",320,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",326,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",321,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",327,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",322,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",265,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",264,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::num","",189,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::mem","",332,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::ops","",278,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",51,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",52,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",53,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",54,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",55,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::any","",0,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",0,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::sync::atomic","",414,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",415,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::cell","",123,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",124,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::iter","",344,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",348,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",370,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",371,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",373,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",374,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",377,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",378,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",351,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::slice","",352,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",353,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",385,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",386,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",394,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",395,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",396,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",397,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::str::pattern","",362,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::hash","",355,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::fmt","",358,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std","",339,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",277,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",331,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",333,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",333,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",276,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",279,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::marker","",338,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::cell","",334,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",335,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",416,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",359,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",411,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::num","",336,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",188,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",356,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",337,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::cmp","",4,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::any","",340,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std","",341,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",341,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",341,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",341,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",341,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",341,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",341,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",341,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",341,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",341,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",341,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",341,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",341,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",341,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",341,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",341,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",341,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",341,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",341,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",341,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",341,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",341,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",341,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",341,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",341,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",341,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",341,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",341,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",341,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",341,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",341,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",341,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",341,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::sync::atomic","",226,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",417,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",418,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",419,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",420,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",421,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",422,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",423,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",424,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",425,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",426,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::cell","",1,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::char","",125,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",342,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",343,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",357,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",364,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::iter","",365,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",366,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",345,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",346,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",347,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",367,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",368,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",369,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",349,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",372,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",375,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",376,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",350,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::option","",69,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",379,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",380,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",381,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::result","",68,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",382,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",383,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",384,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::slice","",387,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",388,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",389,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::str::pattern","",89,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",360,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",361,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",363,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::str","",116,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",117,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",390,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",391,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",354,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",398,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",399,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",400,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",401,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",402,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",403,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",404,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",405,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",406,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",407,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",392,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",393,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::hash","",409,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",410,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",408,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std","",329,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",330,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",328,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",323,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",324,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",319,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",325,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",320,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",326,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",321,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",327,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",322,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",265,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",264,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std::fmt","",122,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std","",279,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",279,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",279,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",279,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",279,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",279,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",279,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",279,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",279,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",279,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",279,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",279,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"next_back","std::str::pattern","",360,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match_back","","",360,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject_back","","",360,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",361,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match_back","","",361,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject_back","","",361,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",362,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match_back","","",362,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_reject_back","","",362,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"next_back","","",363,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"next_match_back","","",363,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"is_null","std","Returns true if the pointer is null.",333,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"as_ref","","Returns `None` if the pointer is null, or else returns a reference to the value wrapped in `Some`.",333,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"offset","","Calculates the offset from a pointer. `count` is in units of T; e.g. a `count` of 3 represents a pointer offset of `3 * sizeof::<T>()` bytes.",333,null],[11,"wrapping_offset","","Calculates the offset from a pointer using wrapping arithmetic. `count` is in units of T; e.g. a `count` of 3 represents a pointer offset of `3 * sizeof::<T>()` bytes.",333,null],[11,"deref","std::ptr","",412,null],[11,"deref","","",413,null],[11,"deref","std::cell","",416,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"deref","","",359,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"zero","std","",319,{"inputs":[],"output":{"name":"u8"}}],[11,"zero","","",320,{"inputs":[],"output":{"name":"u16"}}],[11,"zero","","",321,{"inputs":[],"output":{"name":"u32"}}],[11,"zero","","",322,{"inputs":[],"output":{"name":"u64"}}],[11,"zero","","",264,{"inputs":[],"output":{"name":"u128"}}],[11,"zero","","",323,{"inputs":[],"output":{"name":"usize"}}],[11,"zero","","",324,{"inputs":[],"output":{"name":"i8"}}],[11,"zero","","",325,{"inputs":[],"output":{"name":"i16"}}],[11,"zero","","",326,{"inputs":[],"output":{"name":"i32"}}],[11,"zero","","",327,{"inputs":[],"output":{"name":"i64"}}],[11,"zero","","",265,{"inputs":[],"output":{"name":"i128"}}],[11,"zero","","",328,{"inputs":[],"output":{"name":"isize"}}],[11,"zero","","",329,{"inputs":[],"output":{"name":"f32"}}],[11,"zero","","",330,{"inputs":[],"output":{"name":"f64"}}],[11,"into_searcher","","",331,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"charsearcher"}}],[11,"is_contained_in","","",331,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"is_prefix_of","","",331,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"is_suffix_of","","",331,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"into_searcher","","",276,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"charslicesearcher"}}],[11,"is_contained_in","","",276,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"is_prefix_of","","",276,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"is_suffix_of","","",276,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"into_searcher","","",277,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"strsearcher"}}],[11,"is_prefix_of","","Checks whether the pattern matches at the front of the haystack",277,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"is_suffix_of","","Checks whether the pattern matches at the back of the haystack",277,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"bool"}}],[11,"shl_assign","std::num","",189,null],[11,"shl_assign","","",189,null],[11,"shl_assign","","",189,null],[11,"shl_assign","","",189,null],[11,"shl_assign","","",189,null],[11,"shl_assign","","",189,null],[11,"shl_assign","","",189,null],[11,"shl_assign","","",189,null],[11,"shl_assign","","",189,null],[11,"shl_assign","","",189,null],[11,"shl_assign","std","",319,null],[11,"shl_assign","","",319,null],[11,"shl_assign","","",319,null],[11,"shl_assign","","",319,null],[11,"shl_assign","","",319,null],[11,"shl_assign","","",319,null],[11,"shl_assign","","",319,null],[11,"shl_assign","","",319,null],[11,"shl_assign","","",319,null],[11,"shl_assign","","",319,null],[11,"shl_assign","","",319,null],[11,"shl_assign","","",319,null],[11,"shl_assign","","",320,null],[11,"shl_assign","","",320,null],[11,"shl_assign","","",320,null],[11,"shl_assign","","",320,null],[11,"shl_assign","","",320,null],[11,"shl_assign","","",320,null],[11,"shl_assign","","",320,null],[11,"shl_assign","","",320,null],[11,"shl_assign","","",320,null],[11,"shl_assign","","",320,null],[11,"shl_assign","","",320,null],[11,"shl_assign","","",320,null],[11,"shl_assign","","",321,null],[11,"shl_assign","","",321,null],[11,"shl_assign","","",321,null],[11,"shl_assign","","",321,null],[11,"shl_assign","","",321,null],[11,"shl_assign","","",321,null],[11,"shl_assign","","",321,null],[11,"shl_assign","","",321,null],[11,"shl_assign","","",321,null],[11,"shl_assign","","",321,null],[11,"shl_assign","","",321,null],[11,"shl_assign","","",321,null],[11,"shl_assign","","",322,null],[11,"shl_assign","","",322,null],[11,"shl_assign","","",322,null],[11,"shl_assign","","",322,null],[11,"shl_assign","","",322,null],[11,"shl_assign","","",322,null],[11,"shl_assign","","",322,null],[11,"shl_assign","","",322,null],[11,"shl_assign","","",322,null],[11,"shl_assign","","",322,null],[11,"shl_assign","","",322,null],[11,"shl_assign","","",322,null],[11,"shl_assign","","",264,null],[11,"shl_assign","","",264,null],[11,"shl_assign","","",264,null],[11,"shl_assign","","",264,null],[11,"shl_assign","","",264,null],[11,"shl_assign","","",264,null],[11,"shl_assign","","",264,null],[11,"shl_assign","","",264,null],[11,"shl_assign","","",264,null],[11,"shl_assign","","",264,null],[11,"shl_assign","","",264,null],[11,"shl_assign","","",264,null],[11,"shl_assign","","",323,null],[11,"shl_assign","","",323,null],[11,"shl_assign","","",323,null],[11,"shl_assign","","",323,null],[11,"shl_assign","","",323,null],[11,"shl_assign","","",323,null],[11,"shl_assign","","",323,null],[11,"shl_assign","","",323,null],[11,"shl_assign","","",323,null],[11,"shl_assign","","",323,null],[11,"shl_assign","","",323,null],[11,"shl_assign","","",323,null],[11,"shl_assign","","",324,null],[11,"shl_assign","","",324,null],[11,"shl_assign","","",324,null],[11,"shl_assign","","",324,null],[11,"shl_assign","","",324,null],[11,"shl_assign","","",324,null],[11,"shl_assign","","",324,null],[11,"shl_assign","","",324,null],[11,"shl_assign","","",324,null],[11,"shl_assign","","",324,null],[11,"shl_assign","","",324,null],[11,"shl_assign","","",324,null],[11,"shl_assign","","",325,null],[11,"shl_assign","","",325,null],[11,"shl_assign","","",325,null],[11,"shl_assign","","",325,null],[11,"shl_assign","","",325,null],[11,"shl_assign","","",325,null],[11,"shl_assign","","",325,null],[11,"shl_assign","","",325,null],[11,"shl_assign","","",325,null],[11,"shl_assign","","",325,null],[11,"shl_assign","","",325,null],[11,"shl_assign","","",325,null],[11,"shl_assign","","",326,null],[11,"shl_assign","","",326,null],[11,"shl_assign","","",326,null],[11,"shl_assign","","",326,null],[11,"shl_assign","","",326,null],[11,"shl_assign","","",326,null],[11,"shl_assign","","",326,null],[11,"shl_assign","","",326,null],[11,"shl_assign","","",326,null],[11,"shl_assign","","",326,null],[11,"shl_assign","","",326,null],[11,"shl_assign","","",326,null],[11,"shl_assign","","",327,null],[11,"shl_assign","","",327,null],[11,"shl_assign","","",327,null],[11,"shl_assign","","",327,null],[11,"shl_assign","","",327,null],[11,"shl_assign","","",327,null],[11,"shl_assign","","",327,null],[11,"shl_assign","","",327,null],[11,"shl_assign","","",327,null],[11,"shl_assign","","",327,null],[11,"shl_assign","","",327,null],[11,"shl_assign","","",327,null],[11,"shl_assign","","",265,null],[11,"shl_assign","","",265,null],[11,"shl_assign","","",265,null],[11,"shl_assign","","",265,null],[11,"shl_assign","","",265,null],[11,"shl_assign","","",265,null],[11,"shl_assign","","",265,null],[11,"shl_assign","","",265,null],[11,"shl_assign","","",265,null],[11,"shl_assign","","",265,null],[11,"shl_assign","","",265,null],[11,"shl_assign","","",265,null],[11,"shl_assign","","",328,null],[11,"shl_assign","","",328,null],[11,"shl_assign","","",328,null],[11,"shl_assign","","",328,null],[11,"shl_assign","","",328,null],[11,"shl_assign","","",328,null],[11,"shl_assign","","",328,null],[11,"shl_assign","","",328,null],[11,"shl_assign","","",328,null],[11,"shl_assign","","",328,null],[11,"shl_assign","","",328,null],[11,"shl_assign","","",328,null],[11,"add","std::num","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"add","","",189,null],[11,"add","","",189,null],[11,"add","","",189,null],[11,"add","","",189,null],[11,"add","","",189,null],[11,"add","","",189,null],[11,"add","","",189,null],[11,"add","","",189,null],[11,"add","","",189,null],[11,"add","","",189,null],[11,"add","","",189,null],[11,"add","","",189,null],[11,"add","std","",323,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"usize"}}],[11,"add","","",319,{"inputs":[{"name":"self"},{"name":"u8"}],"output":{"name":"u8"}}],[11,"add","","",320,{"inputs":[{"name":"self"},{"name":"u16"}],"output":{"name":"u16"}}],[11,"add","","",321,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"u32"}}],[11,"add","","",322,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"u64"}}],[11,"add","","",264,{"inputs":[{"name":"self"},{"name":"u128"}],"output":{"name":"u128"}}],[11,"add","","",328,{"inputs":[{"name":"self"},{"name":"isize"}],"output":{"name":"isize"}}],[11,"add","","",324,{"inputs":[{"name":"self"},{"name":"i8"}],"output":{"name":"i8"}}],[11,"add","","",325,{"inputs":[{"name":"self"},{"name":"i16"}],"output":{"name":"i16"}}],[11,"add","","",326,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"i32"}}],[11,"add","","",327,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"i64"}}],[11,"add","","",265,{"inputs":[{"name":"self"},{"name":"i128"}],"output":{"name":"i128"}}],[11,"add","","",329,{"inputs":[{"name":"self"},{"name":"f32"}],"output":{"name":"f32"}}],[11,"add","","",330,{"inputs":[{"name":"self"},{"name":"f64"}],"output":{"name":"f64"}}],[11,"add","","",323,null],[11,"add","","",323,null],[11,"add","","",323,null],[11,"add","","",319,null],[11,"add","","",319,null],[11,"add","","",319,null],[11,"add","","",320,null],[11,"add","","",320,null],[11,"add","","",320,null],[11,"add","","",321,null],[11,"add","","",321,null],[11,"add","","",321,null],[11,"add","","",322,null],[11,"add","","",322,null],[11,"add","","",322,null],[11,"add","","",264,null],[11,"add","","",264,null],[11,"add","","",264,null],[11,"add","","",328,null],[11,"add","","",328,null],[11,"add","","",328,null],[11,"add","","",324,null],[11,"add","","",324,null],[11,"add","","",324,null],[11,"add","","",325,null],[11,"add","","",325,null],[11,"add","","",325,null],[11,"add","","",326,null],[11,"add","","",326,null],[11,"add","","",326,null],[11,"add","","",327,null],[11,"add","","",327,null],[11,"add","","",327,null],[11,"add","","",265,null],[11,"add","","",265,null],[11,"add","","",265,null],[11,"add","","",329,null],[11,"add","","",329,null],[11,"add","","",329,null],[11,"add","","",330,null],[11,"add","","",330,null],[11,"add","","",330,null],[11,"bitxor_assign","std::num","",189,null],[11,"bitxor_assign","","",189,null],[11,"bitxor_assign","","",189,null],[11,"bitxor_assign","","",189,null],[11,"bitxor_assign","","",189,null],[11,"bitxor_assign","","",189,null],[11,"bitxor_assign","","",189,null],[11,"bitxor_assign","","",189,null],[11,"bitxor_assign","","",189,null],[11,"bitxor_assign","","",189,null],[11,"bitxor_assign","","",189,null],[11,"bitxor_assign","","",189,null],[11,"bitxor_assign","std","",339,null],[11,"bitxor_assign","","",323,null],[11,"bitxor_assign","","",319,null],[11,"bitxor_assign","","",320,null],[11,"bitxor_assign","","",321,null],[11,"bitxor_assign","","",322,null],[11,"bitxor_assign","","",264,null],[11,"bitxor_assign","","",328,null],[11,"bitxor_assign","","",324,null],[11,"bitxor_assign","","",325,null],[11,"bitxor_assign","","",326,null],[11,"bitxor_assign","","",327,null],[11,"bitxor_assign","","",265,null],[11,"bitor_assign","std::num","",189,null],[11,"bitor_assign","","",189,null],[11,"bitor_assign","","",189,null],[11,"bitor_assign","","",189,null],[11,"bitor_assign","","",189,null],[11,"bitor_assign","","",189,null],[11,"bitor_assign","","",189,null],[11,"bitor_assign","","",189,null],[11,"bitor_assign","","",189,null],[11,"bitor_assign","","",189,null],[11,"bitor_assign","","",189,null],[11,"bitor_assign","","",189,null],[11,"bitor_assign","std","",339,null],[11,"bitor_assign","","",323,null],[11,"bitor_assign","","",319,null],[11,"bitor_assign","","",320,null],[11,"bitor_assign","","",321,null],[11,"bitor_assign","","",322,null],[11,"bitor_assign","","",264,null],[11,"bitor_assign","","",328,null],[11,"bitor_assign","","",324,null],[11,"bitor_assign","","",325,null],[11,"bitor_assign","","",326,null],[11,"bitor_assign","","",327,null],[11,"bitor_assign","","",265,null],[11,"bitand_assign","std::num","",189,null],[11,"bitand_assign","","",189,null],[11,"bitand_assign","","",189,null],[11,"bitand_assign","","",189,null],[11,"bitand_assign","","",189,null],[11,"bitand_assign","","",189,null],[11,"bitand_assign","","",189,null],[11,"bitand_assign","","",189,null],[11,"bitand_assign","","",189,null],[11,"bitand_assign","","",189,null],[11,"bitand_assign","","",189,null],[11,"bitand_assign","","",189,null],[11,"bitand_assign","std","",339,null],[11,"bitand_assign","","",323,null],[11,"bitand_assign","","",319,null],[11,"bitand_assign","","",320,null],[11,"bitand_assign","","",321,null],[11,"bitand_assign","","",322,null],[11,"bitand_assign","","",264,null],[11,"bitand_assign","","",328,null],[11,"bitand_assign","","",324,null],[11,"bitand_assign","","",325,null],[11,"bitand_assign","","",326,null],[11,"bitand_assign","","",327,null],[11,"bitand_assign","","",265,null],[11,"bitand","std::num","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitand","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitand","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitand","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitand","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitand","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitand","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitand","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitand","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitand","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitand","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitand","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitand","","",189,null],[11,"bitand","","",189,null],[11,"bitand","","",189,null],[11,"bitand","","",189,null],[11,"bitand","","",189,null],[11,"bitand","","",189,null],[11,"bitand","","",189,null],[11,"bitand","","",189,null],[11,"bitand","","",189,null],[11,"bitand","","",189,null],[11,"bitand","","",189,null],[11,"bitand","","",189,null],[11,"bitand","std","",339,{"inputs":[{"name":"self"},{"name":"bool"}],"output":{"name":"bool"}}],[11,"bitand","","",323,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"usize"}}],[11,"bitand","","",319,{"inputs":[{"name":"self"},{"name":"u8"}],"output":{"name":"u8"}}],[11,"bitand","","",320,{"inputs":[{"name":"self"},{"name":"u16"}],"output":{"name":"u16"}}],[11,"bitand","","",321,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"u32"}}],[11,"bitand","","",322,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"u64"}}],[11,"bitand","","",264,{"inputs":[{"name":"self"},{"name":"u128"}],"output":{"name":"u128"}}],[11,"bitand","","",328,{"inputs":[{"name":"self"},{"name":"isize"}],"output":{"name":"isize"}}],[11,"bitand","","",324,{"inputs":[{"name":"self"},{"name":"i8"}],"output":{"name":"i8"}}],[11,"bitand","","",325,{"inputs":[{"name":"self"},{"name":"i16"}],"output":{"name":"i16"}}],[11,"bitand","","",326,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"i32"}}],[11,"bitand","","",327,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"i64"}}],[11,"bitand","","",265,{"inputs":[{"name":"self"},{"name":"i128"}],"output":{"name":"i128"}}],[11,"bitand","","",339,null],[11,"bitand","","",339,null],[11,"bitand","","",339,null],[11,"bitand","","",323,null],[11,"bitand","","",323,null],[11,"bitand","","",323,null],[11,"bitand","","",319,null],[11,"bitand","","",319,null],[11,"bitand","","",319,null],[11,"bitand","","",320,null],[11,"bitand","","",320,null],[11,"bitand","","",320,null],[11,"bitand","","",321,null],[11,"bitand","","",321,null],[11,"bitand","","",321,null],[11,"bitand","","",322,null],[11,"bitand","","",322,null],[11,"bitand","","",322,null],[11,"bitand","","",264,null],[11,"bitand","","",264,null],[11,"bitand","","",264,null],[11,"bitand","","",328,null],[11,"bitand","","",328,null],[11,"bitand","","",328,null],[11,"bitand","","",324,null],[11,"bitand","","",324,null],[11,"bitand","","",324,null],[11,"bitand","","",325,null],[11,"bitand","","",325,null],[11,"bitand","","",325,null],[11,"bitand","","",326,null],[11,"bitand","","",326,null],[11,"bitand","","",326,null],[11,"bitand","","",327,null],[11,"bitand","","",327,null],[11,"bitand","","",327,null],[11,"bitand","","",265,null],[11,"bitand","","",265,null],[11,"bitand","","",265,null],[11,"rem_assign","std::num","",189,null],[11,"rem_assign","","",189,null],[11,"rem_assign","","",189,null],[11,"rem_assign","","",189,null],[11,"rem_assign","","",189,null],[11,"rem_assign","","",189,null],[11,"rem_assign","","",189,null],[11,"rem_assign","","",189,null],[11,"rem_assign","","",189,null],[11,"rem_assign","","",189,null],[11,"rem_assign","","",189,null],[11,"rem_assign","","",189,null],[11,"rem_assign","std","",323,null],[11,"rem_assign","","",319,null],[11,"rem_assign","","",320,null],[11,"rem_assign","","",321,null],[11,"rem_assign","","",322,null],[11,"rem_assign","","",264,null],[11,"rem_assign","","",328,null],[11,"rem_assign","","",324,null],[11,"rem_assign","","",325,null],[11,"rem_assign","","",326,null],[11,"rem_assign","","",327,null],[11,"rem_assign","","",265,null],[11,"rem_assign","","",329,null],[11,"rem_assign","","",330,null],[11,"div_assign","std::num","",189,null],[11,"div_assign","","",189,null],[11,"div_assign","","",189,null],[11,"div_assign","","",189,null],[11,"div_assign","","",189,null],[11,"div_assign","","",189,null],[11,"div_assign","","",189,null],[11,"div_assign","","",189,null],[11,"div_assign","","",189,null],[11,"div_assign","","",189,null],[11,"div_assign","","",189,null],[11,"div_assign","","",189,null],[11,"div_assign","std","",323,null],[11,"div_assign","","",319,null],[11,"div_assign","","",320,null],[11,"div_assign","","",321,null],[11,"div_assign","","",322,null],[11,"div_assign","","",264,null],[11,"div_assign","","",328,null],[11,"div_assign","","",324,null],[11,"div_assign","","",325,null],[11,"div_assign","","",326,null],[11,"div_assign","","",327,null],[11,"div_assign","","",265,null],[11,"div_assign","","",329,null],[11,"div_assign","","",330,null],[11,"cmp","","",333,null],[11,"cmp","","",333,null],[11,"cmp","std::cmp","",4,{"inputs":[{"name":"self"},{"name":"ordering"}],"output":{"name":"ordering"}}],[11,"cmp","std","",279,null],[11,"cmp","","",339,{"inputs":[{"name":"self"},{"name":"bool"}],"output":{"name":"ordering"}}],[11,"cmp","std::cell","",334,{"inputs":[{"name":"self"},{"name":"cell"}],"output":{"name":"ordering"}}],[11,"cmp","","",335,{"inputs":[{"name":"self"},{"name":"refcell"}],"output":{"name":"ordering"}}],[11,"cmp","std","",276,null],[11,"cmp","","",277,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"ordering"}}],[11,"cmp","std::num","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"ordering"}}],[11,"cmp","std::marker","",338,{"inputs":[{"name":"self"},{"name":"phantomdata"}],"output":{"name":"ordering"}}],[11,"cmp","std","",331,{"inputs":[{"name":"self"},{"name":"char"}],"output":{"name":"ordering"}}],[11,"cmp","","",323,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"ordering"}}],[11,"cmp","","",319,{"inputs":[{"name":"self"},{"name":"u8"}],"output":{"name":"ordering"}}],[11,"cmp","","",320,{"inputs":[{"name":"self"},{"name":"u16"}],"output":{"name":"ordering"}}],[11,"cmp","","",321,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"ordering"}}],[11,"cmp","","",322,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"ordering"}}],[11,"cmp","","",264,{"inputs":[{"name":"self"},{"name":"u128"}],"output":{"name":"ordering"}}],[11,"cmp","","",328,{"inputs":[{"name":"self"},{"name":"isize"}],"output":{"name":"ordering"}}],[11,"cmp","","",324,{"inputs":[{"name":"self"},{"name":"i8"}],"output":{"name":"ordering"}}],[11,"cmp","","",325,{"inputs":[{"name":"self"},{"name":"i16"}],"output":{"name":"ordering"}}],[11,"cmp","","",326,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"ordering"}}],[11,"cmp","","",327,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"ordering"}}],[11,"cmp","","",265,{"inputs":[{"name":"self"},{"name":"i128"}],"output":{"name":"ordering"}}],[11,"cmp","std::any","",340,{"inputs":[{"name":"self"},{"name":"typeid"}],"output":{"name":"ordering"}}],[11,"cmp","std","",341,null],[11,"cmp","","",341,null],[11,"cmp","","",341,null],[11,"cmp","","",341,null],[11,"cmp","","",341,null],[11,"cmp","","",341,null],[11,"cmp","","",341,null],[11,"cmp","","",341,null],[11,"cmp","","",341,null],[11,"cmp","","",341,null],[11,"cmp","","",341,null],[11,"cmp","","",341,null],[11,"cmp","","",341,null],[11,"cmp","","",341,null],[11,"cmp","","",341,null],[11,"cmp","","",341,null],[11,"cmp","","",341,null],[11,"cmp","","",341,null],[11,"cmp","","",341,null],[11,"cmp","","",341,null],[11,"cmp","","",341,null],[11,"cmp","","",341,null],[11,"cmp","","",341,null],[11,"cmp","","",341,null],[11,"cmp","","",341,null],[11,"cmp","","",341,null],[11,"cmp","","",341,null],[11,"cmp","","",341,null],[11,"cmp","","",341,null],[11,"cmp","","",341,null],[11,"cmp","","",341,null],[11,"cmp","","",341,null],[11,"cmp","","",341,null],[11,"cmp","std::option","",69,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"name":"ordering"}}],[11,"cmp","std::result","",68,{"inputs":[{"name":"self"},{"name":"result"}],"output":{"name":"ordering"}}],[11,"cmp","std::fmt","",122,{"inputs":[{"name":"self"},{"name":"error"}],"output":{"name":"ordering"}}],[11,"cmp","std","",279,null],[11,"cmp","","",279,null],[11,"cmp","","",279,null],[11,"cmp","","",279,null],[11,"cmp","","",279,null],[11,"cmp","","",279,null],[11,"cmp","","",279,null],[11,"cmp","","",279,null],[11,"cmp","","",279,null],[11,"cmp","","",279,null],[11,"cmp","","",279,null],[11,"cmp","","",279,null],[11,"neg","std::num","",189,{"inputs":[{"name":"self"}],"output":{"name":"wrapping"}}],[11,"neg","","",189,{"inputs":[{"name":"self"}],"output":{"name":"wrapping"}}],[11,"neg","","",189,{"inputs":[{"name":"self"}],"output":{"name":"wrapping"}}],[11,"neg","","",189,{"inputs":[{"name":"self"}],"output":{"name":"wrapping"}}],[11,"neg","","",189,{"inputs":[{"name":"self"}],"output":{"name":"wrapping"}}],[11,"neg","","",189,{"inputs":[{"name":"self"}],"output":{"name":"wrapping"}}],[11,"neg","","",189,{"inputs":[{"name":"self"}],"output":{"name":"wrapping"}}],[11,"neg","","",189,{"inputs":[{"name":"self"}],"output":{"name":"wrapping"}}],[11,"neg","","",189,{"inputs":[{"name":"self"}],"output":{"name":"wrapping"}}],[11,"neg","","",189,{"inputs":[{"name":"self"}],"output":{"name":"wrapping"}}],[11,"neg","","",189,{"inputs":[{"name":"self"}],"output":{"name":"wrapping"}}],[11,"neg","","",189,{"inputs":[{"name":"self"}],"output":{"name":"wrapping"}}],[11,"neg","std","",328,{"inputs":[{"name":"self"}],"output":{"name":"isize"}}],[11,"neg","","",324,{"inputs":[{"name":"self"}],"output":{"name":"i8"}}],[11,"neg","","",325,{"inputs":[{"name":"self"}],"output":{"name":"i16"}}],[11,"neg","","",326,{"inputs":[{"name":"self"}],"output":{"name":"i32"}}],[11,"neg","","",327,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[11,"neg","","",265,{"inputs":[{"name":"self"}],"output":{"name":"i128"}}],[11,"neg","","",329,{"inputs":[{"name":"self"}],"output":{"name":"f32"}}],[11,"neg","","",330,{"inputs":[{"name":"self"}],"output":{"name":"f64"}}],[11,"neg","","",328,null],[11,"neg","","",324,null],[11,"neg","","",325,null],[11,"neg","","",326,null],[11,"neg","","",327,null],[11,"neg","","",265,null],[11,"neg","","",329,null],[11,"neg","","",330,null],[11,"mul_assign","std::num","",189,null],[11,"mul_assign","","",189,null],[11,"mul_assign","","",189,null],[11,"mul_assign","","",189,null],[11,"mul_assign","","",189,null],[11,"mul_assign","","",189,null],[11,"mul_assign","","",189,null],[11,"mul_assign","","",189,null],[11,"mul_assign","","",189,null],[11,"mul_assign","","",189,null],[11,"mul_assign","","",189,null],[11,"mul_assign","","",189,null],[11,"mul_assign","std","",323,null],[11,"mul_assign","","",319,null],[11,"mul_assign","","",320,null],[11,"mul_assign","","",321,null],[11,"mul_assign","","",322,null],[11,"mul_assign","","",264,null],[11,"mul_assign","","",328,null],[11,"mul_assign","","",324,null],[11,"mul_assign","","",325,null],[11,"mul_assign","","",326,null],[11,"mul_assign","","",327,null],[11,"mul_assign","","",265,null],[11,"mul_assign","","",329,null],[11,"mul_assign","","",330,null],[11,"clone","std::mem","",332,{"inputs":[{"name":"self"}],"output":{"name":"discriminant"}}],[11,"clone","std","",333,null],[11,"clone","","",333,null],[11,"clone","std::ptr","",413,{"inputs":[{"name":"self"}],"output":{"name":"shared"}}],[11,"clone","std::cell","",334,{"inputs":[{"name":"self"}],"output":{"name":"cell"}}],[11,"clone","","",335,{"inputs":[{"name":"self"}],"output":{"name":"refcell"}}],[11,"clone","std::iter","",344,{"inputs":[{"name":"self"}],"output":{"name":"empty"}}],[11,"clone","std::option","",379,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"clone","std::result","",382,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"clone","std::slice","",352,{"inputs":[{"name":"self"}],"output":{"name":"iter"}}],[11,"clone","","",385,{"inputs":[{"name":"self"}],"output":{"name":"split"}}],[11,"clone","","",387,{"inputs":[{"name":"self"}],"output":{"name":"windows"}}],[11,"clone","","",388,{"inputs":[{"name":"self"}],"output":{"name":"chunks"}}],[11,"clone","std::hash","",355,{"inputs":[{"name":"self"}],"output":{"name":"buildhasherdefault"}}],[11,"clone","std::num","",189,{"inputs":[{"name":"self"}],"output":{"name":"wrapping"}}],[11,"clone","","",336,{"inputs":[{"name":"self"}],"output":{"name":"parsefloaterror"}}],[11,"clone","","",188,{"inputs":[{"name":"self"}],"output":{"name":"fpcategory"}}],[11,"clone","","",356,{"inputs":[{"name":"self"}],"output":{"name":"tryfrominterror"}}],[11,"clone","","",337,{"inputs":[{"name":"self"}],"output":{"name":"parseinterror"}}],[11,"clone","std::marker","",338,{"inputs":[{"name":"self"}],"output":{"name":"phantomdata"}}],[11,"clone","std::ops","",278,{"inputs":[{"name":"self"}],"output":{"name":"rangefull"}}],[11,"clone","","",51,{"inputs":[{"name":"self"}],"output":{"name":"range"}}],[11,"clone","","",52,{"inputs":[{"name":"self"}],"output":{"name":"rangefrom"}}],[11,"clone","","",53,{"inputs":[{"name":"self"}],"output":{"name":"rangeto"}}],[11,"clone","","",54,{"inputs":[{"name":"self"}],"output":{"name":"rangeinclusive"}}],[11,"clone","","",55,{"inputs":[{"name":"self"}],"output":{"name":"rangetoinclusive"}}],[11,"clone","std::cmp","",4,{"inputs":[{"name":"self"}],"output":{"name":"ordering"}}],[11,"clone","std","Returns a deep copy of the value.",328,{"inputs":[{"name":"self"}],"output":{"name":"isize"}}],[11,"clone","","Returns a deep copy of the value.",324,{"inputs":[{"name":"self"}],"output":{"name":"i8"}}],[11,"clone","","Returns a deep copy of the value.",325,{"inputs":[{"name":"self"}],"output":{"name":"i16"}}],[11,"clone","","Returns a deep copy of the value.",326,{"inputs":[{"name":"self"}],"output":{"name":"i32"}}],[11,"clone","","Returns a deep copy of the value.",327,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[11,"clone","","Returns a deep copy of the value.",265,{"inputs":[{"name":"self"}],"output":{"name":"i128"}}],[11,"clone","","Returns a deep copy of the value.",323,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"clone","","Returns a deep copy of the value.",319,{"inputs":[{"name":"self"}],"output":{"name":"u8"}}],[11,"clone","","Returns a deep copy of the value.",320,{"inputs":[{"name":"self"}],"output":{"name":"u16"}}],[11,"clone","","Returns a deep copy of the value.",321,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"clone","","Returns a deep copy of the value.",322,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"clone","","Returns a deep copy of the value.",264,{"inputs":[{"name":"self"}],"output":{"name":"u128"}}],[11,"clone","","Returns a deep copy of the value.",329,{"inputs":[{"name":"self"}],"output":{"name":"f32"}}],[11,"clone","","Returns a deep copy of the value.",330,{"inputs":[{"name":"self"}],"output":{"name":"f64"}}],[11,"clone","","Returns a deep copy of the value.",279,null],[11,"clone","","Returns a deep copy of the value.",339,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","Returns a deep copy of the value.",331,{"inputs":[{"name":"self"}],"output":{"name":"char"}}],[11,"clone","std::any","",340,{"inputs":[{"name":"self"}],"output":{"name":"typeid"}}],[11,"clone","std","",341,null],[11,"clone","","",341,null],[11,"clone","","",341,null],[11,"clone","","",341,null],[11,"clone","","",341,null],[11,"clone","","",341,null],[11,"clone","","",341,null],[11,"clone","","",341,null],[11,"clone","","",341,null],[11,"clone","","",341,null],[11,"clone","","",341,null],[11,"clone","","",341,null],[11,"clone","","",341,null],[11,"clone","","",341,null],[11,"clone","","",341,null],[11,"clone","","",341,null],[11,"clone","","",341,null],[11,"clone","","",341,null],[11,"clone","","",341,null],[11,"clone","","",341,null],[11,"clone","","",341,null],[11,"clone","","",341,null],[11,"clone","","",341,null],[11,"clone","","",341,null],[11,"clone","","",341,null],[11,"clone","","",341,null],[11,"clone","","",341,null],[11,"clone","","",341,null],[11,"clone","","",341,null],[11,"clone","","",341,null],[11,"clone","","",341,null],[11,"clone","","",341,null],[11,"clone","","",341,null],[11,"clone","std::sync::atomic","",226,{"inputs":[{"name":"self"}],"output":{"name":"ordering"}}],[11,"clone","std::cell","",1,{"inputs":[{"name":"self"}],"output":{"name":"borrowstate"}}],[11,"clone","std::char","",125,{"inputs":[{"name":"self"}],"output":{"name":"chartryfromerror"}}],[11,"clone","","",342,{"inputs":[{"name":"self"}],"output":{"name":"escapeunicode"}}],[11,"clone","","",343,{"inputs":[{"name":"self"}],"output":{"name":"escapedefault"}}],[11,"clone","","",357,{"inputs":[{"name":"self"}],"output":{"name":"escapedebug"}}],[11,"clone","","",364,{"inputs":[{"name":"self"}],"output":{"name":"decodeutf8"}}],[11,"clone","std::iter","",365,{"inputs":[{"name":"self"}],"output":{"name":"stepby"}}],[11,"clone","","",366,{"inputs":[{"name":"self"}],"output":{"name":"repeat"}}],[11,"clone","","",345,{"inputs":[{"name":"self"}],"output":{"name":"once"}}],[11,"clone","","",346,{"inputs":[{"name":"self"}],"output":{"name":"rev"}}],[11,"clone","","",347,{"inputs":[{"name":"self"}],"output":{"name":"cloned"}}],[11,"clone","","",367,{"inputs":[{"name":"self"}],"output":{"name":"cycle"}}],[11,"clone","","",368,{"inputs":[{"name":"self"}],"output":{"name":"chain"}}],[11,"clone","","",369,{"inputs":[{"name":"self"}],"output":{"name":"zip"}}],[11,"clone","","",348,{"inputs":[{"name":"self"}],"output":{"name":"map"}}],[11,"clone","","",370,{"inputs":[{"name":"self"}],"output":{"name":"filter"}}],[11,"clone","","",371,{"inputs":[{"name":"self"}],"output":{"name":"filtermap"}}],[11,"clone","","",349,{"inputs":[{"name":"self"}],"output":{"name":"enumerate"}}],[11,"clone","","",372,{"inputs":[{"name":"self"}],"output":{"name":"peekable"}}],[11,"clone","","",373,{"inputs":[{"name":"self"}],"output":{"name":"skipwhile"}}],[11,"clone","","",374,{"inputs":[{"name":"self"}],"output":{"name":"takewhile"}}],[11,"clone","","",375,{"inputs":[{"name":"self"}],"output":{"name":"skip"}}],[11,"clone","","",376,{"inputs":[{"name":"self"}],"output":{"name":"take"}}],[11,"clone","","",377,{"inputs":[{"name":"self"}],"output":{"name":"scan"}}],[11,"clone","","",378,{"inputs":[{"name":"self"}],"output":{"name":"flatmap"}}],[11,"clone","","",350,{"inputs":[{"name":"self"}],"output":{"name":"fuse"}}],[11,"clone","","",351,{"inputs":[{"name":"self"}],"output":{"name":"inspect"}}],[11,"clone","std::option","",69,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"clone","","",381,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"clone","std::raw","",67,{"inputs":[{"name":"self"}],"output":{"name":"traitobject"}}],[11,"clone","std::result","",68,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"clone","std::str::pattern","",89,{"inputs":[{"name":"self"}],"output":{"name":"searchstep"}}],[11,"clone","","",360,{"inputs":[{"name":"self"}],"output":{"name":"charsearcher"}}],[11,"clone","","",361,{"inputs":[{"name":"self"}],"output":{"name":"charslicesearcher"}}],[11,"clone","","",362,{"inputs":[{"name":"self"}],"output":{"name":"charpredicatesearcher"}}],[11,"clone","","",363,{"inputs":[{"name":"self"}],"output":{"name":"strsearcher"}}],[11,"clone","std::str","",116,{"inputs":[{"name":"self"}],"output":{"name":"parseboolerror"}}],[11,"clone","","",117,{"inputs":[{"name":"self"}],"output":{"name":"utf8error"}}],[11,"clone","","",390,{"inputs":[{"name":"self"}],"output":{"name":"chars"}}],[11,"clone","","",391,{"inputs":[{"name":"self"}],"output":{"name":"charindices"}}],[11,"clone","","",354,{"inputs":[{"name":"self"}],"output":{"name":"bytes"}}],[11,"clone","","",398,{"inputs":[{"name":"self"}],"output":{"name":"split"}}],[11,"clone","","",399,{"inputs":[{"name":"self"}],"output":{"name":"rsplit"}}],[11,"clone","","",400,{"inputs":[{"name":"self"}],"output":{"name":"splitterminator"}}],[11,"clone","","",401,{"inputs":[{"name":"self"}],"output":{"name":"rsplitterminator"}}],[11,"clone","","",402,{"inputs":[{"name":"self"}],"output":{"name":"splitn"}}],[11,"clone","","",403,{"inputs":[{"name":"self"}],"output":{"name":"rsplitn"}}],[11,"clone","","",404,{"inputs":[{"name":"self"}],"output":{"name":"matchindices"}}],[11,"clone","","",405,{"inputs":[{"name":"self"}],"output":{"name":"rmatchindices"}}],[11,"clone","","",406,{"inputs":[{"name":"self"}],"output":{"name":"matches"}}],[11,"clone","","",407,{"inputs":[{"name":"self"}],"output":{"name":"rmatches"}}],[11,"clone","","",392,{"inputs":[{"name":"self"}],"output":{"name":"lines"}}],[11,"clone","","",393,{"inputs":[{"name":"self"}],"output":{"name":"linesany"}}],[11,"clone","std::hash","",409,{"inputs":[{"name":"self"}],"output":{"name":"siphasher13"}}],[11,"clone","","",410,{"inputs":[{"name":"self"}],"output":{"name":"siphasher24"}}],[11,"clone","","",408,{"inputs":[{"name":"self"}],"output":{"name":"siphasher"}}],[11,"clone","std::fmt","",122,{"inputs":[{"name":"self"}],"output":{"name":"error"}}],[11,"clone","","",358,{"inputs":[{"name":"self"}],"output":{"name":"arguments"}}],[11,"clone","std","",279,null],[11,"clone","","",279,null],[11,"clone","","",279,null],[11,"clone","","",279,null],[11,"clone","","",279,null],[11,"clone","","",279,null],[11,"clone","","",279,null],[11,"clone","","",279,null],[11,"clone","","",279,null],[11,"clone","","",279,null],[11,"clone","","",279,null],[11,"clone","","",279,null],[11,"sub_assign","std::num","",189,null],[11,"sub_assign","","",189,null],[11,"sub_assign","","",189,null],[11,"sub_assign","","",189,null],[11,"sub_assign","","",189,null],[11,"sub_assign","","",189,null],[11,"sub_assign","","",189,null],[11,"sub_assign","","",189,null],[11,"sub_assign","","",189,null],[11,"sub_assign","","",189,null],[11,"sub_assign","","",189,null],[11,"sub_assign","","",189,null],[11,"sub_assign","std","",323,null],[11,"sub_assign","","",319,null],[11,"sub_assign","","",320,null],[11,"sub_assign","","",321,null],[11,"sub_assign","","",322,null],[11,"sub_assign","","",264,null],[11,"sub_assign","","",328,null],[11,"sub_assign","","",324,null],[11,"sub_assign","","",325,null],[11,"sub_assign","","",326,null],[11,"sub_assign","","",327,null],[11,"sub_assign","","",265,null],[11,"sub_assign","","",329,null],[11,"sub_assign","","",330,null],[11,"step","","",323,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"steps_between","","",323,{"inputs":[{"name":"usize"},{"name":"usize"},{"name":"usize"}],"output":{"name":"option"}}],[11,"is_negative","","",323,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"replace_one","","",323,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"replace_zero","","",323,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"add_one","","",323,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"sub_one","","",323,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"steps_between_by_one","","",323,{"inputs":[{"name":"usize"},{"name":"usize"}],"output":{"name":"option"}}],[11,"step","","",319,{"inputs":[{"name":"self"},{"name":"u8"}],"output":{"name":"option"}}],[11,"steps_between","","",319,{"inputs":[{"name":"u8"},{"name":"u8"},{"name":"u8"}],"output":{"name":"option"}}],[11,"is_negative","","",319,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"replace_one","","",319,{"inputs":[{"name":"self"}],"output":{"name":"u8"}}],[11,"replace_zero","","",319,{"inputs":[{"name":"self"}],"output":{"name":"u8"}}],[11,"add_one","","",319,{"inputs":[{"name":"self"}],"output":{"name":"u8"}}],[11,"sub_one","","",319,{"inputs":[{"name":"self"}],"output":{"name":"u8"}}],[11,"steps_between_by_one","","",319,{"inputs":[{"name":"u8"},{"name":"u8"}],"output":{"name":"option"}}],[11,"step","","",320,{"inputs":[{"name":"self"},{"name":"u16"}],"output":{"name":"option"}}],[11,"steps_between","","",320,{"inputs":[{"name":"u16"},{"name":"u16"},{"name":"u16"}],"output":{"name":"option"}}],[11,"is_negative","","",320,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"replace_one","","",320,{"inputs":[{"name":"self"}],"output":{"name":"u16"}}],[11,"replace_zero","","",320,{"inputs":[{"name":"self"}],"output":{"name":"u16"}}],[11,"add_one","","",320,{"inputs":[{"name":"self"}],"output":{"name":"u16"}}],[11,"sub_one","","",320,{"inputs":[{"name":"self"}],"output":{"name":"u16"}}],[11,"steps_between_by_one","","",320,{"inputs":[{"name":"u16"},{"name":"u16"}],"output":{"name":"option"}}],[11,"step","","",321,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"option"}}],[11,"steps_between","","",321,{"inputs":[{"name":"u32"},{"name":"u32"},{"name":"u32"}],"output":{"name":"option"}}],[11,"is_negative","","",321,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"replace_one","","",321,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"replace_zero","","",321,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"add_one","","",321,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"sub_one","","",321,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"steps_between_by_one","","",321,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"option"}}],[11,"step","","",328,{"inputs":[{"name":"self"},{"name":"isize"}],"output":{"name":"option"}}],[11,"steps_between","","",328,{"inputs":[{"name":"isize"},{"name":"isize"},{"name":"isize"}],"output":{"name":"option"}}],[11,"is_negative","","",328,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"replace_one","","",328,{"inputs":[{"name":"self"}],"output":{"name":"isize"}}],[11,"replace_zero","","",328,{"inputs":[{"name":"self"}],"output":{"name":"isize"}}],[11,"add_one","","",328,{"inputs":[{"name":"self"}],"output":{"name":"isize"}}],[11,"sub_one","","",328,{"inputs":[{"name":"self"}],"output":{"name":"isize"}}],[11,"steps_between_by_one","","",328,{"inputs":[{"name":"isize"},{"name":"isize"}],"output":{"name":"option"}}],[11,"step","","",324,{"inputs":[{"name":"self"},{"name":"i8"}],"output":{"name":"option"}}],[11,"steps_between","","",324,{"inputs":[{"name":"i8"},{"name":"i8"},{"name":"i8"}],"output":{"name":"option"}}],[11,"is_negative","","",324,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"replace_one","","",324,{"inputs":[{"name":"self"}],"output":{"name":"i8"}}],[11,"replace_zero","","",324,{"inputs":[{"name":"self"}],"output":{"name":"i8"}}],[11,"add_one","","",324,{"inputs":[{"name":"self"}],"output":{"name":"i8"}}],[11,"sub_one","","",324,{"inputs":[{"name":"self"}],"output":{"name":"i8"}}],[11,"steps_between_by_one","","",324,{"inputs":[{"name":"i8"},{"name":"i8"}],"output":{"name":"option"}}],[11,"step","","",325,{"inputs":[{"name":"self"},{"name":"i16"}],"output":{"name":"option"}}],[11,"steps_between","","",325,{"inputs":[{"name":"i16"},{"name":"i16"},{"name":"i16"}],"output":{"name":"option"}}],[11,"is_negative","","",325,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"replace_one","","",325,{"inputs":[{"name":"self"}],"output":{"name":"i16"}}],[11,"replace_zero","","",325,{"inputs":[{"name":"self"}],"output":{"name":"i16"}}],[11,"add_one","","",325,{"inputs":[{"name":"self"}],"output":{"name":"i16"}}],[11,"sub_one","","",325,{"inputs":[{"name":"self"}],"output":{"name":"i16"}}],[11,"steps_between_by_one","","",325,{"inputs":[{"name":"i16"},{"name":"i16"}],"output":{"name":"option"}}],[11,"step","","",326,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"option"}}],[11,"steps_between","","",326,{"inputs":[{"name":"i32"},{"name":"i32"},{"name":"i32"}],"output":{"name":"option"}}],[11,"is_negative","","",326,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"replace_one","","",326,{"inputs":[{"name":"self"}],"output":{"name":"i32"}}],[11,"replace_zero","","",326,{"inputs":[{"name":"self"}],"output":{"name":"i32"}}],[11,"add_one","","",326,{"inputs":[{"name":"self"}],"output":{"name":"i32"}}],[11,"sub_one","","",326,{"inputs":[{"name":"self"}],"output":{"name":"i32"}}],[11,"steps_between_by_one","","",326,{"inputs":[{"name":"i32"},{"name":"i32"}],"output":{"name":"option"}}],[11,"step","","",322,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"option"}}],[11,"steps_between","","",322,{"inputs":[{"name":"u64"},{"name":"u64"},{"name":"u64"}],"output":{"name":"option"}}],[11,"is_negative","","",322,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"replace_one","","",322,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"replace_zero","","",322,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"add_one","","",322,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"sub_one","","",322,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"steps_between_by_one","","",322,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"option"}}],[11,"step","","",327,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"option"}}],[11,"steps_between","","",327,{"inputs":[{"name":"i64"},{"name":"i64"},{"name":"i64"}],"output":{"name":"option"}}],[11,"is_negative","","",327,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"replace_one","","",327,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[11,"replace_zero","","",327,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[11,"add_one","","",327,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[11,"sub_one","","",327,{"inputs":[{"name":"self"}],"output":{"name":"i64"}}],[11,"steps_between_by_one","","",327,{"inputs":[{"name":"i64"},{"name":"i64"}],"output":{"name":"option"}}],[11,"step","","",264,{"inputs":[{"name":"self"},{"name":"u128"}],"output":{"name":"option"}}],[11,"steps_between","","",264,{"inputs":[{"name":"u128"},{"name":"u128"},{"name":"u128"}],"output":{"name":"option"}}],[11,"is_negative","","",264,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"replace_one","","",264,{"inputs":[{"name":"self"}],"output":{"name":"u128"}}],[11,"replace_zero","","",264,{"inputs":[{"name":"self"}],"output":{"name":"u128"}}],[11,"add_one","","",264,{"inputs":[{"name":"self"}],"output":{"name":"u128"}}],[11,"sub_one","","",264,{"inputs":[{"name":"self"}],"output":{"name":"u128"}}],[11,"steps_between_by_one","","",264,{"inputs":[{"name":"u128"},{"name":"u128"}],"output":{"name":"option"}}],[11,"step","","",265,{"inputs":[{"name":"self"},{"name":"i128"}],"output":{"name":"option"}}],[11,"steps_between","","",265,{"inputs":[{"name":"i128"},{"name":"i128"},{"name":"i128"}],"output":{"name":"option"}}],[11,"is_negative","","",265,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"replace_one","","",265,{"inputs":[{"name":"self"}],"output":{"name":"i128"}}],[11,"replace_zero","","",265,{"inputs":[{"name":"self"}],"output":{"name":"i128"}}],[11,"add_one","","",265,{"inputs":[{"name":"self"}],"output":{"name":"i128"}}],[11,"sub_one","","",265,{"inputs":[{"name":"self"}],"output":{"name":"i128"}}],[11,"steps_between_by_one","","",265,{"inputs":[{"name":"i128"},{"name":"i128"}],"output":{"name":"option"}}],[11,"add_assign","std::num","",189,null],[11,"add_assign","","",189,null],[11,"add_assign","","",189,null],[11,"add_assign","","",189,null],[11,"add_assign","","",189,null],[11,"add_assign","","",189,null],[11,"add_assign","","",189,null],[11,"add_assign","","",189,null],[11,"add_assign","","",189,null],[11,"add_assign","","",189,null],[11,"add_assign","","",189,null],[11,"add_assign","","",189,null],[11,"add_assign","std","",323,null],[11,"add_assign","","",319,null],[11,"add_assign","","",320,null],[11,"add_assign","","",321,null],[11,"add_assign","","",322,null],[11,"add_assign","","",264,null],[11,"add_assign","","",328,null],[11,"add_assign","","",324,null],[11,"add_assign","","",325,null],[11,"add_assign","","",326,null],[11,"add_assign","","",327,null],[11,"add_assign","","",265,null],[11,"add_assign","","",329,null],[11,"add_assign","","",330,null],[11,"hash","std::mem","",332,null],[11,"hash","std","",339,null],[11,"hash","","",331,null],[11,"hash","","",277,null],[11,"hash","","",276,null],[11,"hash","","",333,null],[11,"hash","","",333,null],[11,"hash","std::num","",189,null],[11,"hash","std::marker","",338,null],[11,"hash","std::ops","",278,null],[11,"hash","","",51,null],[11,"hash","","",52,null],[11,"hash","","",53,null],[11,"hash","","",54,null],[11,"hash","","",55,null],[11,"hash","std::cmp","",4,null],[11,"hash","std::any","",340,null],[11,"hash","std","",341,null],[11,"hash","","",341,null],[11,"hash","","",341,null],[11,"hash","","",341,null],[11,"hash","","",341,null],[11,"hash","","",341,null],[11,"hash","","",341,null],[11,"hash","","",341,null],[11,"hash","","",341,null],[11,"hash","","",341,null],[11,"hash","","",341,null],[11,"hash","","",341,null],[11,"hash","","",341,null],[11,"hash","","",341,null],[11,"hash","","",341,null],[11,"hash","","",341,null],[11,"hash","","",341,null],[11,"hash","","",341,null],[11,"hash","","",341,null],[11,"hash","","",341,null],[11,"hash","","",341,null],[11,"hash","","",341,null],[11,"hash","","",341,null],[11,"hash","","",341,null],[11,"hash","","",341,null],[11,"hash","","",341,null],[11,"hash","","",341,null],[11,"hash","","",341,null],[11,"hash","","",341,null],[11,"hash","","",341,null],[11,"hash","","",341,null],[11,"hash","","",341,null],[11,"hash","","",341,null],[11,"hash","std::option","",69,null],[11,"hash","std::result","",68,null],[11,"hash","std","",319,null],[11,"hash_slice","","",319,null],[11,"hash","","",320,null],[11,"hash_slice","","",320,null],[11,"hash","","",321,null],[11,"hash_slice","","",321,null],[11,"hash","","",322,null],[11,"hash_slice","","",322,null],[11,"hash","","",323,null],[11,"hash_slice","","",323,null],[11,"hash","","",324,null],[11,"hash_slice","","",324,null],[11,"hash","","",325,null],[11,"hash_slice","","",325,null],[11,"hash","","",326,null],[11,"hash_slice","","",326,null],[11,"hash","","",327,null],[11,"hash_slice","","",327,null],[11,"hash","","",328,null],[11,"hash_slice","","",328,null],[11,"hash","","",264,null],[11,"hash_slice","","",264,null],[11,"hash","","",265,null],[11,"hash_slice","","",265,null],[11,"hash","","",279,null],[11,"hash","","",279,null],[11,"hash","","",279,null],[11,"hash","","",279,null],[11,"hash","","",279,null],[11,"hash","","",279,null],[11,"hash","","",279,null],[11,"hash","","",279,null],[11,"hash","","",279,null],[11,"hash","","",279,null],[11,"hash","","",279,null],[11,"hash","","",279,null],[11,"hash","","",279,null],[11,"hash","std::fmt","",122,null],[11,"shr_assign","std::num","",189,null],[11,"shr_assign","","",189,null],[11,"shr_assign","","",189,null],[11,"shr_assign","","",189,null],[11,"shr_assign","","",189,null],[11,"shr_assign","","",189,null],[11,"shr_assign","","",189,null],[11,"shr_assign","","",189,null],[11,"shr_assign","","",189,null],[11,"shr_assign","","",189,null],[11,"shr_assign","std","",319,null],[11,"shr_assign","","",319,null],[11,"shr_assign","","",319,null],[11,"shr_assign","","",319,null],[11,"shr_assign","","",319,null],[11,"shr_assign","","",319,null],[11,"shr_assign","","",319,null],[11,"shr_assign","","",319,null],[11,"shr_assign","","",319,null],[11,"shr_assign","","",319,null],[11,"shr_assign","","",319,null],[11,"shr_assign","","",319,null],[11,"shr_assign","","",320,null],[11,"shr_assign","","",320,null],[11,"shr_assign","","",320,null],[11,"shr_assign","","",320,null],[11,"shr_assign","","",320,null],[11,"shr_assign","","",320,null],[11,"shr_assign","","",320,null],[11,"shr_assign","","",320,null],[11,"shr_assign","","",320,null],[11,"shr_assign","","",320,null],[11,"shr_assign","","",320,null],[11,"shr_assign","","",320,null],[11,"shr_assign","","",321,null],[11,"shr_assign","","",321,null],[11,"shr_assign","","",321,null],[11,"shr_assign","","",321,null],[11,"shr_assign","","",321,null],[11,"shr_assign","","",321,null],[11,"shr_assign","","",321,null],[11,"shr_assign","","",321,null],[11,"shr_assign","","",321,null],[11,"shr_assign","","",321,null],[11,"shr_assign","","",321,null],[11,"shr_assign","","",321,null],[11,"shr_assign","","",322,null],[11,"shr_assign","","",322,null],[11,"shr_assign","","",322,null],[11,"shr_assign","","",322,null],[11,"shr_assign","","",322,null],[11,"shr_assign","","",322,null],[11,"shr_assign","","",322,null],[11,"shr_assign","","",322,null],[11,"shr_assign","","",322,null],[11,"shr_assign","","",322,null],[11,"shr_assign","","",322,null],[11,"shr_assign","","",322,null],[11,"shr_assign","","",264,null],[11,"shr_assign","","",264,null],[11,"shr_assign","","",264,null],[11,"shr_assign","","",264,null],[11,"shr_assign","","",264,null],[11,"shr_assign","","",264,null],[11,"shr_assign","","",264,null],[11,"shr_assign","","",264,null],[11,"shr_assign","","",264,null],[11,"shr_assign","","",264,null],[11,"shr_assign","","",264,null],[11,"shr_assign","","",264,null],[11,"shr_assign","","",323,null],[11,"shr_assign","","",323,null],[11,"shr_assign","","",323,null],[11,"shr_assign","","",323,null],[11,"shr_assign","","",323,null],[11,"shr_assign","","",323,null],[11,"shr_assign","","",323,null],[11,"shr_assign","","",323,null],[11,"shr_assign","","",323,null],[11,"shr_assign","","",323,null],[11,"shr_assign","","",323,null],[11,"shr_assign","","",323,null],[11,"shr_assign","","",324,null],[11,"shr_assign","","",324,null],[11,"shr_assign","","",324,null],[11,"shr_assign","","",324,null],[11,"shr_assign","","",324,null],[11,"shr_assign","","",324,null],[11,"shr_assign","","",324,null],[11,"shr_assign","","",324,null],[11,"shr_assign","","",324,null],[11,"shr_assign","","",324,null],[11,"shr_assign","","",324,null],[11,"shr_assign","","",324,null],[11,"shr_assign","","",325,null],[11,"shr_assign","","",325,null],[11,"shr_assign","","",325,null],[11,"shr_assign","","",325,null],[11,"shr_assign","","",325,null],[11,"shr_assign","","",325,null],[11,"shr_assign","","",325,null],[11,"shr_assign","","",325,null],[11,"shr_assign","","",325,null],[11,"shr_assign","","",325,null],[11,"shr_assign","","",325,null],[11,"shr_assign","","",325,null],[11,"shr_assign","","",326,null],[11,"shr_assign","","",326,null],[11,"shr_assign","","",326,null],[11,"shr_assign","","",326,null],[11,"shr_assign","","",326,null],[11,"shr_assign","","",326,null],[11,"shr_assign","","",326,null],[11,"shr_assign","","",326,null],[11,"shr_assign","","",326,null],[11,"shr_assign","","",326,null],[11,"shr_assign","","",326,null],[11,"shr_assign","","",326,null],[11,"shr_assign","","",327,null],[11,"shr_assign","","",327,null],[11,"shr_assign","","",327,null],[11,"shr_assign","","",327,null],[11,"shr_assign","","",327,null],[11,"shr_assign","","",327,null],[11,"shr_assign","","",327,null],[11,"shr_assign","","",327,null],[11,"shr_assign","","",327,null],[11,"shr_assign","","",327,null],[11,"shr_assign","","",327,null],[11,"shr_assign","","",327,null],[11,"shr_assign","","",265,null],[11,"shr_assign","","",265,null],[11,"shr_assign","","",265,null],[11,"shr_assign","","",265,null],[11,"shr_assign","","",265,null],[11,"shr_assign","","",265,null],[11,"shr_assign","","",265,null],[11,"shr_assign","","",265,null],[11,"shr_assign","","",265,null],[11,"shr_assign","","",265,null],[11,"shr_assign","","",265,null],[11,"shr_assign","","",265,null],[11,"shr_assign","","",328,null],[11,"shr_assign","","",328,null],[11,"shr_assign","","",328,null],[11,"shr_assign","","",328,null],[11,"shr_assign","","",328,null],[11,"shr_assign","","",328,null],[11,"shr_assign","","",328,null],[11,"shr_assign","","",328,null],[11,"shr_assign","","",328,null],[11,"shr_assign","","",328,null],[11,"shr_assign","","",328,null],[11,"shr_assign","","",328,null],[11,"write_str","std::fmt","",427,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"result"}}],[11,"write_char","","",427,{"inputs":[{"name":"self"},{"name":"char"}],"output":{"name":"result"}}],[11,"write_fmt","","",427,{"inputs":[{"name":"self"},{"name":"arguments"}],"output":{"name":"result"}}],[11,"sub","std::num","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"sub","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"sub","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"sub","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"sub","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"sub","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"sub","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"sub","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"sub","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"sub","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"sub","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"sub","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"sub","","",189,null],[11,"sub","","",189,null],[11,"sub","","",189,null],[11,"sub","","",189,null],[11,"sub","","",189,null],[11,"sub","","",189,null],[11,"sub","","",189,null],[11,"sub","","",189,null],[11,"sub","","",189,null],[11,"sub","","",189,null],[11,"sub","","",189,null],[11,"sub","","",189,null],[11,"sub","std","",323,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"usize"}}],[11,"sub","","",319,{"inputs":[{"name":"self"},{"name":"u8"}],"output":{"name":"u8"}}],[11,"sub","","",320,{"inputs":[{"name":"self"},{"name":"u16"}],"output":{"name":"u16"}}],[11,"sub","","",321,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"u32"}}],[11,"sub","","",322,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"u64"}}],[11,"sub","","",264,{"inputs":[{"name":"self"},{"name":"u128"}],"output":{"name":"u128"}}],[11,"sub","","",328,{"inputs":[{"name":"self"},{"name":"isize"}],"output":{"name":"isize"}}],[11,"sub","","",324,{"inputs":[{"name":"self"},{"name":"i8"}],"output":{"name":"i8"}}],[11,"sub","","",325,{"inputs":[{"name":"self"},{"name":"i16"}],"output":{"name":"i16"}}],[11,"sub","","",326,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"i32"}}],[11,"sub","","",327,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"i64"}}],[11,"sub","","",265,{"inputs":[{"name":"self"},{"name":"i128"}],"output":{"name":"i128"}}],[11,"sub","","",329,{"inputs":[{"name":"self"},{"name":"f32"}],"output":{"name":"f32"}}],[11,"sub","","",330,{"inputs":[{"name":"self"},{"name":"f64"}],"output":{"name":"f64"}}],[11,"sub","","",323,null],[11,"sub","","",323,null],[11,"sub","","",323,null],[11,"sub","","",319,null],[11,"sub","","",319,null],[11,"sub","","",319,null],[11,"sub","","",320,null],[11,"sub","","",320,null],[11,"sub","","",320,null],[11,"sub","","",321,null],[11,"sub","","",321,null],[11,"sub","","",321,null],[11,"sub","","",322,null],[11,"sub","","",322,null],[11,"sub","","",322,null],[11,"sub","","",264,null],[11,"sub","","",264,null],[11,"sub","","",264,null],[11,"sub","","",328,null],[11,"sub","","",328,null],[11,"sub","","",328,null],[11,"sub","","",324,null],[11,"sub","","",324,null],[11,"sub","","",324,null],[11,"sub","","",325,null],[11,"sub","","",325,null],[11,"sub","","",325,null],[11,"sub","","",326,null],[11,"sub","","",326,null],[11,"sub","","",326,null],[11,"sub","","",327,null],[11,"sub","","",327,null],[11,"sub","","",327,null],[11,"sub","","",265,null],[11,"sub","","",265,null],[11,"sub","","",265,null],[11,"sub","","",329,null],[11,"sub","","",329,null],[11,"sub","","",329,null],[11,"sub","","",330,null],[11,"sub","","",330,null],[11,"sub","","",330,null],[11,"fmt","","",329,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",330,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"borrow_mut","","",341,null],[11,"borrow_mut","","",341,null],[11,"borrow_mut","","",341,null],[11,"borrow_mut","","",341,null],[11,"borrow_mut","","",341,null],[11,"borrow_mut","","",341,null],[11,"borrow_mut","","",341,null],[11,"borrow_mut","","",341,null],[11,"borrow_mut","","",341,null],[11,"borrow_mut","","",341,null],[11,"borrow_mut","","",341,null],[11,"borrow_mut","","",341,null],[11,"borrow_mut","","",341,null],[11,"borrow_mut","","",341,null],[11,"borrow_mut","","",341,null],[11,"borrow_mut","","",341,null],[11,"borrow_mut","","",341,null],[11,"borrow_mut","","",341,null],[11,"borrow_mut","","",341,null],[11,"borrow_mut","","",341,null],[11,"borrow_mut","","",341,null],[11,"borrow_mut","","",341,null],[11,"borrow_mut","","",341,null],[11,"borrow_mut","","",341,null],[11,"borrow_mut","","",341,null],[11,"borrow_mut","","",341,null],[11,"borrow_mut","","",341,null],[11,"borrow_mut","","",341,null],[11,"borrow_mut","","",341,null],[11,"borrow_mut","","",341,null],[11,"borrow_mut","","",341,null],[11,"borrow_mut","","",341,null],[11,"borrow_mut","","",341,null],[11,"fmt","std::num","",189,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","std","",328,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",323,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",324,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",319,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",325,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",320,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",326,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",321,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",327,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",322,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",265,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",264,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"bitor","std::num","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitor","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitor","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitor","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitor","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitor","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitor","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitor","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitor","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitor","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitor","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitor","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"wrapping"}}],[11,"bitor","","",189,null],[11,"bitor","","",189,null],[11,"bitor","","",189,null],[11,"bitor","","",189,null],[11,"bitor","","",189,null],[11,"bitor","","",189,null],[11,"bitor","","",189,null],[11,"bitor","","",189,null],[11,"bitor","","",189,null],[11,"bitor","","",189,null],[11,"bitor","","",189,null],[11,"bitor","","",189,null],[11,"bitor","std","",339,{"inputs":[{"name":"self"},{"name":"bool"}],"output":{"name":"bool"}}],[11,"bitor","","",323,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"usize"}}],[11,"bitor","","",319,{"inputs":[{"name":"self"},{"name":"u8"}],"output":{"name":"u8"}}],[11,"bitor","","",320,{"inputs":[{"name":"self"},{"name":"u16"}],"output":{"name":"u16"}}],[11,"bitor","","",321,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"u32"}}],[11,"bitor","","",322,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"u64"}}],[11,"bitor","","",264,{"inputs":[{"name":"self"},{"name":"u128"}],"output":{"name":"u128"}}],[11,"bitor","","",328,{"inputs":[{"name":"self"},{"name":"isize"}],"output":{"name":"isize"}}],[11,"bitor","","",324,{"inputs":[{"name":"self"},{"name":"i8"}],"output":{"name":"i8"}}],[11,"bitor","","",325,{"inputs":[{"name":"self"},{"name":"i16"}],"output":{"name":"i16"}}],[11,"bitor","","",326,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"i32"}}],[11,"bitor","","",327,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"i64"}}],[11,"bitor","","",265,{"inputs":[{"name":"self"},{"name":"i128"}],"output":{"name":"i128"}}],[11,"bitor","","",339,null],[11,"bitor","","",339,null],[11,"bitor","","",339,null],[11,"bitor","","",323,null],[11,"bitor","","",323,null],[11,"bitor","","",323,null],[11,"bitor","","",319,null],[11,"bitor","","",319,null],[11,"bitor","","",319,null],[11,"bitor","","",320,null],[11,"bitor","","",320,null],[11,"bitor","","",320,null],[11,"bitor","","",321,null],[11,"bitor","","",321,null],[11,"bitor","","",321,null],[11,"bitor","","",322,null],[11,"bitor","","",322,null],[11,"bitor","","",322,null],[11,"bitor","","",264,null],[11,"bitor","","",264,null],[11,"bitor","","",264,null],[11,"bitor","","",328,null],[11,"bitor","","",328,null],[11,"bitor","","",328,null],[11,"bitor","","",324,null],[11,"bitor","","",324,null],[11,"bitor","","",324,null],[11,"bitor","","",325,null],[11,"bitor","","",325,null],[11,"bitor","","",325,null],[11,"bitor","","",326,null],[11,"bitor","","",326,null],[11,"bitor","","",326,null],[11,"bitor","","",327,null],[11,"bitor","","",327,null],[11,"bitor","","",327,null],[11,"bitor","","",265,null],[11,"bitor","","",265,null],[11,"bitor","","",265,null],[11,"default","std::sync::atomic","Creates an `AtomicBool` initialized to `false`.",414,{"inputs":[],"output":{"name":"atomicbool"}}],[11,"default","","Creates a null `AtomicPtr<T>`.",415,{"inputs":[],"output":{"name":"atomicptr"}}],[11,"default","std::cell","Creates a `Cell<T>`, with the `Default` value for T.",334,{"inputs":[],"output":{"name":"cell"}}],[11,"default","","Creates a `RefCell<T>`, with the `Default` value for T.",335,{"inputs":[],"output":{"name":"refcell"}}],[11,"default","","Creates an `UnsafeCell`, with the `Default` value for T.",411,{"inputs":[],"output":{"name":"unsafecell"}}],[11,"default","std::iter","",344,{"inputs":[],"output":{"name":"empty"}}],[11,"default","std::option","Returns None.",69,{"inputs":[],"output":{"name":"option"}}],[11,"default","std","Creates an empty slice.",276,null],[11,"default","","Creates a mutable empty slice.",276,null],[11,"default","","Creates an empty str",277,{"inputs":[],"output":{"name":"str"}}],[11,"default","std::hash","",355,{"inputs":[],"output":{"name":"buildhasherdefault"}}],[11,"default","std::num","",189,{"inputs":[],"output":{"name":"wrapping"}}],[11,"default","std::marker","",338,{"inputs":[],"output":{"name":"phantomdata"}}],[11,"default","std","",279,null],[11,"default","","",339,{"inputs":[],"output":{"name":"bool"}}],[11,"default","","",331,{"inputs":[],"output":{"name":"char"}}],[11,"default","","",323,{"inputs":[],"output":{"name":"usize"}}],[11,"default","","",319,{"inputs":[],"output":{"name":"u8"}}],[11,"default","","",320,{"inputs":[],"output":{"name":"u16"}}],[11,"default","","",321,{"inputs":[],"output":{"name":"u32"}}],[11,"default","","",322,{"inputs":[],"output":{"name":"u64"}}],[11,"default","","",264,{"inputs":[],"output":{"name":"u128"}}],[11,"default","","",328,{"inputs":[],"output":{"name":"isize"}}],[11,"default","","",324,{"inputs":[],"output":{"name":"i8"}}],[11,"default","","",325,{"inputs":[],"output":{"name":"i16"}}],[11,"default","","",326,{"inputs":[],"output":{"name":"i32"}}],[11,"default","","",327,{"inputs":[],"output":{"name":"i64"}}],[11,"default","","",265,{"inputs":[],"output":{"name":"i128"}}],[11,"default","","",329,{"inputs":[],"output":{"name":"f32"}}],[11,"default","","",330,{"inputs":[],"output":{"name":"f64"}}],[11,"default","","",341,null],[11,"default","","",341,null],[11,"default","","",341,null],[11,"default","","",341,null],[11,"default","","",341,null],[11,"default","","",341,null],[11,"default","","",341,null],[11,"default","","",341,null],[11,"default","","",341,null],[11,"default","","",341,null],[11,"default","","",341,null],[11,"default","","",341,null],[11,"default","","",341,null],[11,"default","","",341,null],[11,"default","","",341,null],[11,"default","","",341,null],[11,"default","","",341,null],[11,"default","","",341,null],[11,"default","","",341,null],[11,"default","","",341,null],[11,"default","","",341,null],[11,"default","","",341,null],[11,"default","","",341,null],[11,"default","","",341,null],[11,"default","","",341,null],[11,"default","","",341,null],[11,"default","","",341,null],[11,"default","","",341,null],[11,"default","","",341,null],[11,"default","","",341,null],[11,"default","","",341,null],[11,"default","","",341,null],[11,"default","","",341,null],[11,"default","std::sync::atomic","",417,{"inputs":[],"output":{"name":"atomici8"}}],[11,"default","","",418,{"inputs":[],"output":{"name":"atomicu8"}}],[11,"default","","",419,{"inputs":[],"output":{"name":"atomici16"}}],[11,"default","","",420,{"inputs":[],"output":{"name":"atomicu16"}}],[11,"default","","",421,{"inputs":[],"output":{"name":"atomici32"}}],[11,"default","","",422,{"inputs":[],"output":{"name":"atomicu32"}}],[11,"default","","",423,{"inputs":[],"output":{"name":"atomici64"}}],[11,"default","","",424,{"inputs":[],"output":{"name":"atomicu64"}}],[11,"default","","",425,{"inputs":[],"output":{"name":"atomicisize"}}],[11,"default","","",426,{"inputs":[],"output":{"name":"atomicusize"}}],[11,"default","std::hash","",409,{"inputs":[],"output":{"name":"siphasher13"}}],[11,"default","","",410,{"inputs":[],"output":{"name":"siphasher24"}}],[11,"default","","",408,{"inputs":[],"output":{"name":"siphasher"}}],[11,"default","std::fmt","",122,{"inputs":[],"output":{"name":"error"}}],[11,"default","std","",279,null],[11,"default","","",279,null],[11,"default","","",279,null],[11,"default","","",279,null],[11,"default","","",279,null],[11,"default","","",279,null],[11,"default","","",279,null],[11,"default","","",279,null],[11,"default","","",279,null],[11,"default","","",279,null],[11,"default","","",279,null],[11,"default","","",279,null],[11,"partial_cmp","","",333,null],[11,"lt","","",333,null],[11,"le","","",333,null],[11,"gt","","",333,null],[11,"ge","","",333,null],[11,"partial_cmp","","",333,null],[11,"lt","","",333,null],[11,"le","","",333,null],[11,"gt","","",333,null],[11,"ge","","",333,null],[11,"partial_cmp","std::cmp","",4,{"inputs":[{"name":"self"},{"name":"ordering"}],"output":{"name":"option"}}],[11,"partial_cmp","std","",279,null],[11,"partial_cmp","","",339,{"inputs":[{"name":"self"},{"name":"bool"}],"output":{"name":"option"}}],[11,"partial_cmp","std::cell","",334,{"inputs":[{"name":"self"},{"name":"cell"}],"output":{"name":"option"}}],[11,"lt","","",334,{"inputs":[{"name":"self"},{"name":"cell"}],"output":{"name":"bool"}}],[11,"le","","",334,{"inputs":[{"name":"self"},{"name":"cell"}],"output":{"name":"bool"}}],[11,"gt","","",334,{"inputs":[{"name":"self"},{"name":"cell"}],"output":{"name":"bool"}}],[11,"ge","","",334,{"inputs":[{"name":"self"},{"name":"cell"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",335,{"inputs":[{"name":"self"},{"name":"refcell"}],"output":{"name":"option"}}],[11,"lt","","",335,{"inputs":[{"name":"self"},{"name":"refcell"}],"output":{"name":"bool"}}],[11,"le","","",335,{"inputs":[{"name":"self"},{"name":"refcell"}],"output":{"name":"bool"}}],[11,"gt","","",335,{"inputs":[{"name":"self"},{"name":"refcell"}],"output":{"name":"bool"}}],[11,"ge","","",335,{"inputs":[{"name":"self"},{"name":"refcell"}],"output":{"name":"bool"}}],[11,"partial_cmp","std","",276,null],[11,"partial_cmp","","",277,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"option"}}],[11,"partial_cmp","std::num","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"option"}}],[11,"lt","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"bool"}}],[11,"le","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"bool"}}],[11,"gt","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"bool"}}],[11,"ge","","",189,{"inputs":[{"name":"self"},{"name":"wrapping"}],"output":{"name":"bool"}}],[11,"partial_cmp","std::marker","",338,{"inputs":[{"name":"self"},{"name":"phantomdata"}],"output":{"name":"option"}}],[11,"partial_cmp","std","",329,{"inputs":[{"name":"self"},{"name":"f32"}],"output":{"name":"option"}}],[11,"lt","","",329,{"inputs":[{"name":"self"},{"name":"f32"}],"output":{"name":"bool"}}],[11,"le","","",329,{"inputs":[{"name":"self"},{"name":"f32"}],"output":{"name":"bool"}}],[11,"ge","","",329,{"inputs":[{"name":"self"},{"name":"f32"}],"output":{"name":"bool"}}],[11,"gt","","",329,{"inputs":[{"name":"self"},{"name":"f32"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",330,{"inputs":[{"name":"self"},{"name":"f64"}],"output":{"name":"option"}}],[11,"lt","","",330,{"inputs":[{"name":"self"},{"name":"f64"}],"output":{"name":"bool"}}],[11,"le","","",330,{"inputs":[{"name":"self"},{"name":"f64"}],"output":{"name":"bool"}}],[11,"ge","","",330,{"inputs":[{"name":"self"},{"name":"f64"}],"output":{"name":"bool"}}],[11,"gt","","",330,{"inputs":[{"name":"self"},{"name":"f64"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",331,{"inputs":[{"name":"self"},{"name":"char"}],"output":{"name":"option"}}],[11,"lt","","",331,{"inputs":[{"name":"self"},{"name":"char"}],"output":{"name":"bool"}}],[11,"le","","",331,{"inputs":[{"name":"self"},{"name":"char"}],"output":{"name":"bool"}}],[11,"ge","","",331,{"inputs":[{"name":"self"},{"name":"char"}],"output":{"name":"bool"}}],[11,"gt","","",331,{"inputs":[{"name":"self"},{"name":"char"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",323,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"lt","","",323,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"bool"}}],[11,"le","","",323,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"bool"}}],[11,"ge","","",323,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"bool"}}],[11,"gt","","",323,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",319,{"inputs":[{"name":"self"},{"name":"u8"}],"output":{"name":"option"}}],[11,"lt","","",319,{"inputs":[{"name":"self"},{"name":"u8"}],"output":{"name":"bool"}}],[11,"le","","",319,{"inputs":[{"name":"self"},{"name":"u8"}],"output":{"name":"bool"}}],[11,"ge","","",319,{"inputs":[{"name":"self"},{"name":"u8"}],"output":{"name":"bool"}}],[11,"gt","","",319,{"inputs":[{"name":"self"},{"name":"u8"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",320,{"inputs":[{"name":"self"},{"name":"u16"}],"output":{"name":"option"}}],[11,"lt","","",320,{"inputs":[{"name":"self"},{"name":"u16"}],"output":{"name":"bool"}}],[11,"le","","",320,{"inputs":[{"name":"self"},{"name":"u16"}],"output":{"name":"bool"}}],[11,"ge","","",320,{"inputs":[{"name":"self"},{"name":"u16"}],"output":{"name":"bool"}}],[11,"gt","","",320,{"inputs":[{"name":"self"},{"name":"u16"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",321,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"option"}}],[11,"lt","","",321,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"bool"}}],[11,"le","","",321,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"bool"}}],[11,"ge","","",321,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"bool"}}],[11,"gt","","",321,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",322,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"option"}}],[11,"lt","","",322,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"bool"}}],[11,"le","","",322,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"bool"}}],[11,"ge","","",322,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"bool"}}],[11,"gt","","",322,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",264,{"inputs":[{"name":"self"},{"name":"u128"}],"output":{"name":"option"}}],[11,"lt","","",264,{"inputs":[{"name":"self"},{"name":"u128"}],"output":{"name":"bool"}}],[11,"le","","",264,{"inputs":[{"name":"self"},{"name":"u128"}],"output":{"name":"bool"}}],[11,"ge","","",264,{"inputs":[{"name":"self"},{"name":"u128"}],"output":{"name":"bool"}}],[11,"gt","","",264,{"inputs":[{"name":"self"},{"name":"u128"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",328,{"inputs":[{"name":"self"},{"name":"isize"}],"output":{"name":"option"}}],[11,"lt","","",328,{"inputs":[{"name":"self"},{"name":"isize"}],"output":{"name":"bool"}}],[11,"le","","",328,{"inputs":[{"name":"self"},{"name":"isize"}],"output":{"name":"bool"}}],[11,"ge","","",328,{"inputs":[{"name":"self"},{"name":"isize"}],"output":{"name":"bool"}}],[11,"gt","","",328,{"inputs":[{"name":"self"},{"name":"isize"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",324,{"inputs":[{"name":"self"},{"name":"i8"}],"output":{"name":"option"}}],[11,"lt","","",324,{"inputs":[{"name":"self"},{"name":"i8"}],"output":{"name":"bool"}}],[11,"le","","",324,{"inputs":[{"name":"self"},{"name":"i8"}],"output":{"name":"bool"}}],[11,"ge","","",324,{"inputs":[{"name":"self"},{"name":"i8"}],"output":{"name":"bool"}}],[11,"gt","","",324,{"inputs":[{"name":"self"},{"name":"i8"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",325,{"inputs":[{"name":"self"},{"name":"i16"}],"output":{"name":"option"}}],[11,"lt","","",325,{"inputs":[{"name":"self"},{"name":"i16"}],"output":{"name":"bool"}}],[11,"le","","",325,{"inputs":[{"name":"self"},{"name":"i16"}],"output":{"name":"bool"}}],[11,"ge","","",325,{"inputs":[{"name":"self"},{"name":"i16"}],"output":{"name":"bool"}}],[11,"gt","","",325,{"inputs":[{"name":"self"},{"name":"i16"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",326,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"option"}}],[11,"lt","","",326,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"bool"}}],[11,"le","","",326,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"bool"}}],[11,"ge","","",326,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"bool"}}],[11,"gt","","",326,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",327,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"option"}}],[11,"lt","","",327,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"bool"}}],[11,"le","","",327,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"bool"}}],[11,"ge","","",327,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"bool"}}],[11,"gt","","",327,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",265,{"inputs":[{"name":"self"},{"name":"i128"}],"output":{"name":"option"}}],[11,"lt","","",265,{"inputs":[{"name":"self"},{"name":"i128"}],"output":{"name":"bool"}}],[11,"le","","",265,{"inputs":[{"name":"self"},{"name":"i128"}],"output":{"name":"bool"}}],[11,"ge","","",265,{"inputs":[{"name":"self"},{"name":"i128"}],"output":{"name":"bool"}}],[11,"gt","","",265,{"inputs":[{"name":"self"},{"name":"i128"}],"output":{"name":"bool"}}],[11,"partial_cmp","std::any","",340,{"inputs":[{"name":"self"},{"name":"typeid"}],"output":{"name":"option"}}],[11,"lt","","",340,{"inputs":[{"name":"self"},{"name":"typeid"}],"output":{"name":"bool"}}],[11,"le","","",340,{"inputs":[{"name":"self"},{"name":"typeid"}],"output":{"name":"bool"}}],[11,"gt","","",340,{"inputs":[{"name":"self"},{"name":"typeid"}],"output":{"name":"bool"}}],[11,"ge","","",340,{"inputs":[{"name":"self"},{"name":"typeid"}],"output":{"name":"bool"}}],[11,"partial_cmp","std","",341,null],[11,"lt","","",341,null],[11,"le","","",341,null],[11,"ge","","",341,null],[11,"gt","","",341,null],[11,"partial_cmp","","",341,null],[11,"lt","","",341,null],[11,"le","","",341,null],[11,"ge","","",341,null],[11,"gt","","",341,null],[11,"partial_cmp","","",341,null],[11,"lt","","",341,null],[11,"le","","",341,null],[11,"ge","","",341,null],[11,"gt","","",341,null],[11,"partial_cmp","","",341,null],[11,"lt","","",341,null],[11,"le","","",341,null],[11,"ge","","",341,null],[11,"gt","","",341,null],[11,"partial_cmp","","",341,null],[11,"lt","","",341,null],[11,"le","","",341,null],[11,"ge","","",341,null],[11,"gt","","",341,null],[11,"partial_cmp","","",341,null],[11,"lt","","",341,null],[11,"le","","",341,null],[11,"ge","","",341,null],[11,"gt","","",341,null],[11,"partial_cmp","","",341,null],[11,"lt","","",341,null],[11,"le","","",341,null],[11,"ge","","",341,null],[11,"gt","","",341,null],[11,"partial_cmp","","",341,null],[11,"lt","","",341,null],[11,"le","","",341,null],[11,"ge","","",341,null],[11,"gt","","",341,null],[11,"partial_cmp","","",341,null],[11,"lt","","",341,null],[11,"le","","",341,null],[11,"ge","","",341,null],[11,"gt","","",341,null],[11,"partial_cmp","","",341,null],[11,"lt","","",341,null],[11,"le","","",341,null],[11,"ge","","",341,null],[11,"gt","","",341,null],[11,"partial_cmp","","",341,null],[11,"lt","","",341,null],[11,"le","","",341,null],[11,"ge","","",341,null],[11,"gt","","",341,null],[11,"partial_cmp","","",341,null],[11,"lt","","",341,null],[11,"le","","",341,null],[11,"ge","","",341,null],[11,"gt","","",341,null],[11,"partial_cmp","","",341,null],[11,"lt","","",341,null],[11,"le","","",341,null],[11,"ge","","",341,null],[11,"gt","","",341,null],[11,"partial_cmp","","",341,null],[11,"lt","","",341,null],[11,"le","","",341,null],[11,"ge","","",341,null],[11,"gt","","",341,null],[11,"partial_cmp","","",341,null],[11,"lt","","",341,null],[11,"le","","",341,null],[11,"ge","","",341,null],[11,"gt","","",341,null],[11,"partial_cmp","","",341,null],[11,"lt","","",341,null],[11,"le","","",341,null],[11,"ge","","",341,null],[11,"gt","","",341,null],[11,"partial_cmp","","",341,null],[11,"lt","","",341,null],[11,"le","","",341,null],[11,"ge","","",341,null],[11,"gt","","",341,null],[11,"partial_cmp","","",341,null],[11,"lt","","",341,null],[11,"le","","",341,null],[11,"ge","","",341,null],[11,"gt","","",341,null],[11,"partial_cmp","","",341,null],[11,"lt","","",341,null],[11,"le","","",341,null],[11,"ge","","",341,null],[11,"gt","","",341,null],[11,"partial_cmp","","",341,null],[11,"lt","","",341,null],[11,"le","","",341,null],[11,"ge","","",341,null],[11,"gt","","",341,null],[11,"partial_cmp","","",341,null],[11,"lt","","",341,null],[11,"le","","",341,null],[11,"ge","","",341,null],[11,"gt","","",341,null],[11,"partial_cmp","","",341,null],[11,"lt","","",341,null],[11,"le","","",341,null],[11,"ge","","",341,null],[11,"gt","","",341,null],[11,"partial_cmp","","",341,null],[11,"lt","","",341,null],[11,"le","","",341,null],[11,"ge","","",341,null],[11,"gt","","",341,null],[11,"partial_cmp","","",341,null],[11,"lt","","",341,null],[11,"le","","",341,null],[11,"ge","","",341,null],[11,"gt","","",341,null],[11,"partial_cmp","","",341,null],[11,"lt","","",341,null],[11,"le","","",341,null],[11,"ge","","",341,null],[11,"gt","","",341,null],[11,"partial_cmp","","",341,null],[11,"lt","","",341,null],[11,"le","","",341,null],[11,"ge","","",341,null],[11,"gt","","",341,null],[11,"partial_cmp","","",341,null],[11,"lt","","",341,null],[11,"le","","",341,null],[11,"ge","","",341,null],[11,"gt","","",341,null],[11,"partial_cmp","","",341,null],[11,"lt","","",341,null],[11,"le","","",341,null],[11,"ge","","",341,null],[11,"gt","","",341,null],[11,"partial_cmp","","",341,null],[11,"lt","","",341,null],[11,"le","","",341,null],[11,"ge","","",341,null],[11,"gt","","",341,null],[11,"partial_cmp","","",341,null],[11,"lt","","",341,null],[11,"le","","",341,