; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+sse2 | FileCheck %s --check-prefix=X32-SSE --check-prefix=X32-SSE2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse2 | FileCheck %s --check-prefix=X64-SSE --check-prefix=X64-SSE2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx | FileCheck %s --check-prefix=X64-AVX --check-prefix=X64-AVX1
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefix=X64-AVX --check-prefix=X64-AVX2

define <4 x i32> @trunc_ashr_v4i64(<4 x i64> %a) nounwind {
; X32-SSE-LABEL: trunc_ashr_v4i64:
; X32-SSE:       # BB#0:
; X32-SSE-NEXT:    psrad $31, %xmm1
; X32-SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; X32-SSE-NEXT:    psrad $31, %xmm0
; X32-SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; X32-SSE-NEXT:    packsswb %xmm1, %xmm0
; X32-SSE-NEXT:    retl
;
; X64-SSE-LABEL: trunc_ashr_v4i64:
; X64-SSE:       # BB#0:
; X64-SSE-NEXT:    psrad $31, %xmm1
; X64-SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; X64-SSE-NEXT:    psrad $31, %xmm0
; X64-SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; X64-SSE-NEXT:    packsswb %xmm1, %xmm0
; X64-SSE-NEXT:    retq
;
; X64-AVX1-LABEL: trunc_ashr_v4i64:
; X64-AVX1:       # BB#0:
; X64-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; X64-AVX1-NEXT:    vpsrad $31, %xmm1, %xmm1
; X64-AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; X64-AVX1-NEXT:    vpsrad $31, %xmm0, %xmm0
; X64-AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; X64-AVX1-NEXT:    vpacksswb %xmm1, %xmm0, %xmm0
; X64-AVX1-NEXT:    vzeroupper
; X64-AVX1-NEXT:    retq
;
; X64-AVX2-LABEL: trunc_ashr_v4i64:
; X64-AVX2:       # BB#0:
; X64-AVX2-NEXT:    vpsrad $31, %ymm0, %ymm0
; X64-AVX2-NEXT:    vpshufd {{.*#+}} ymm0 = ymm0[1,1,3,3,5,5,7,7]
; X64-AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X64-AVX2-NEXT:    vpacksswb %xmm1, %xmm0, %xmm0
; X64-AVX2-NEXT:    vzeroupper
; X64-AVX2-NEXT:    retq
  %1 = ashr <4 x i64> %a, <i64 63, i64 63, i64 63, i64 63>
  %2 = trunc <4 x i64> %1 to <4 x i32>
  ret <4 x i32> %2
}

define <8 x i16> @trunc_ashr_v8i32(<8 x i32> %a) nounwind {
; X32-SSE-LABEL: trunc_ashr_v8i32:
; X32-SSE:       # BB#0:
; X32-SSE-NEXT:    psrad $31, %xmm1
; X32-SSE-NEXT:    psrad $31, %xmm0
; X32-SSE-NEXT:    packsswb %xmm1, %xmm0
; X32-SSE-NEXT:    retl
;
; X64-SSE-LABEL: trunc_ashr_v8i32:
; X64-SSE:       # BB#0:
; X64-SSE-NEXT:    psrad $31, %xmm1
; X64-SSE-NEXT:    psrad $31, %xmm0
; X64-SSE-NEXT:    packsswb %xmm1, %xmm0
; X64-SSE-NEXT:    retq
;
; X64-AVX1-LABEL: trunc_ashr_v8i32:
; X64-AVX1:       # BB#0:
; X64-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; X64-AVX1-NEXT:    vpsrad $31, %xmm1, %xmm1
; X64-AVX1-NEXT:    vpsrad $31, %xmm0, %xmm0
; X64-AVX1-NEXT:    vpacksswb %xmm1, %xmm0, %xmm0
; X64-AVX1-NEXT:    vzeroupper
; X64-AVX1-NEXT:    retq
;
; X64-AVX2-LABEL: trunc_ashr_v8i32:
; X64-AVX2:       # BB#0:
; X64-AVX2-NEXT:    vpsrad $31, %ymm0, %ymm0
; X64-AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X64-AVX2-NEXT:    vpacksswb %xmm1, %xmm0, %xmm0
; X64-AVX2-NEXT:    vzeroupper
; X64-AVX2-NEXT:    retq
  %1 = ashr <8 x i32> %a, <i32 31, i32 31, i32 31, i32 31, i32 31, i32 31, i32 31, i32 31>
  %2 = trunc <8 x i32> %1 to <8 x i16>
  ret <8 x i16> %2
}

define <8 x i16> @trunc_ashr_v4i32_icmp_v4i32(<4 x i32> %a, <4 x i32> %b) nounwind {
; X32-SSE-LABEL: trunc_ashr_v4i32_icmp_v4i32:
; X32-SSE:       # BB#0:
; X32-SSE-NEXT:    psrad $31, %xmm0
; X32-SSE-NEXT:    pcmpgtd {{\.LCPI.*}}, %xmm1
; X32-SSE-NEXT:    packsswb %xmm1, %xmm0
; X32-SSE-NEXT:    retl
;
; X64-SSE-LABEL: trunc_ashr_v4i32_icmp_v4i32:
; X64-SSE:       # BB#0:
; X64-SSE-NEXT:    psrad $31, %xmm0
; X64-SSE-NEXT:    pcmpgtd {{.*}}(%rip), %xmm1
; X64-SSE-NEXT:    packsswb %xmm1, %xmm0
; X64-SSE-NEXT:    retq
;
; X64-AVX-LABEL: trunc_ashr_v4i32_icmp_v4i32:
; X64-AVX:       # BB#0:
; X64-AVX-NEXT:    vpsrad $31, %xmm0, %xmm0
; X64-AVX-NEXT:    vpcmpgtd {{.*}}(%rip), %xmm1, %xmm1
; X64-AVX-NEXT:    vpacksswb %xmm1, %xmm0, %xmm0
; X64-AVX-NEXT:    retq
  %1 = ashr <4 x i32> %a, <i32 31, i32 31, i32 31, i32 31>
  %2 = icmp sgt <4 x i32> %b, <i32 1, i32 16, i32 255, i32 65535>
  %3 = sext <4 x i1> %2 to <4 x i32>
  %4 = shufflevector <4 x i32> %1, <4 x i32> %3, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %5 = trunc <8 x i32> %4 to <8 x i16>
  ret <8 x i16> %5
}
