var searchIndex = {};
searchIndex["arena"] = {"doc":"The arena, a fast but limited type of allocator.","items":[[3,"TypedArena","arena","An arena that can hold objects of only one type.",null,null],[3,"DroplessArena","","",null,null],[11,"new","","Creates a new `TypedArena`.",0,{"inputs":[],"output":{"name":"typedarena"}}],[11,"alloc","","Allocates an object in the `TypedArena`, returning a reference to it.",0,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"t"}}],[11,"alloc_slice","","Allocates a slice of objects that are copied into the `TypedArena`, returning a mutable reference to it. Will panic if passed a zero-sized types.",0,null],[11,"clear","","Clears the arena. Deallocates all but the longest chunk which may be reused.",0,{"inputs":[{"name":"self"}],"output":null}],[11,"drop","","",0,{"inputs":[{"name":"self"}],"output":null}],[11,"new","","",1,{"inputs":[],"output":{"name":"droplessarena"}}],[11,"in_arena","","",1,null],[11,"alloc","","",1,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"t"}}],[11,"alloc_slice","","Allocates a slice of objects that are copied into the `DroplessArena`, returning a mutable reference to it. Will panic if passed a zero-sized type.",1,null]],"paths":[[3,"TypedArena"],[3,"DroplessArena"]]};
searchIndex["fmt_macros"] = {"doc":"Macro support for format strings","items":[[3,"Argument","fmt_macros","Representation of an argument specification.",null,null],[12,"position","","Where to find this argument",0,null],[12,"format","","How to format the argument",0,null],[3,"FormatSpec","","Specification for the formatting of an argument in the format string.",null,null],[12,"fill","","Optionally specified character to fill alignment with",1,null],[12,"align","","Optionally specified alignment",1,null],[12,"flags","","Packed version of various flags provided",1,null],[12,"precision","","The integer precision to use",1,null],[12,"width","","The string width requested for the resulting format",1,null],[12,"ty","","The descriptor string representing the name of the format desired for this argument, this can be empty or any number of characters, although it is required to be one word.",1,null],[3,"Parser","","The parser structure for interpreting the input format string. This is modeled as an iterator over `Piece` structures to form a stream of tokens being output.",null,null],[12,"errors","","Error messages accumulated during parsing",2,null],[4,"Piece","","A piece is a portion of the format string which represents the next part to emit. These are emitted as a stream by the `Parser` class.",null,null],[13,"String","","A literal string which should directly be emitted",3,null],[13,"NextArgument","","This describes that formatting should process the next argument (as specified inside) for emission.",3,null],[4,"Position","","Enum describing where an argument for a format can be located.",null,null],[13,"ArgumentImplicitlyIs","","The argument is implied to be located at an index",4,null],[13,"ArgumentIs","","The argument is located at a specific index given in the format",4,null],[13,"ArgumentNamed","","The argument has a name.",4,null],[4,"Alignment","","Enum of alignments which are supported.",null,null],[13,"AlignLeft","","The value will be aligned to the left.",5,null],[13,"AlignRight","","The value will be aligned to the right.",5,null],[13,"AlignCenter","","The value will be aligned in the center.",5,null],[13,"AlignUnknown","","The value will take on a default alignment.",5,null],[4,"Flag","","Various flags which can be applied to format strings. The meaning of these flags is defined by the formatters themselves.",null,null],[13,"FlagSignPlus","","A `+` will be used to denote positive numbers.",6,null],[13,"FlagSignMinus","","A `-` will be used to denote negative numbers. This is the default.",6,null],[13,"FlagAlternate","","An alternate form will be used for the value. In the case of numbers, this means that the number will be prefixed with the supplied string.",6,null],[13,"FlagSignAwareZeroPad","","For numbers, this means that the number will be padded with zeroes, and the sign (`+` or `-`) will precede them.",6,null],[13,"FlagDebugLowerHex","","For Debug / `?`, format integers in lower-case hexadecimal.",6,null],[13,"FlagDebugUpperHex","","For Debug / `?`, format integers in upper-case hexadecimal.",6,null],[4,"Count","","A count is used for the precision and width parameters of an integer, and can reference either an argument or a literal integer.",null,null],[13,"CountIs","","The count is specified explicitly.",7,null],[13,"CountIsName","","The count is specified by the argument with the given name.",7,null],[13,"CountIsParam","","The count is specified by the argument at the given index.",7,null],[13,"CountImplied","","The count is implied and cannot be explicitly specified.",7,null],[11,"clone","","",3,{"inputs":[{"name":"self"}],"output":{"name":"piece"}}],[11,"eq","","",3,{"inputs":[{"name":"self"},{"name":"piece"}],"output":{"name":"bool"}}],[11,"ne","","",3,{"inputs":[{"name":"self"},{"name":"piece"}],"output":{"name":"bool"}}],[11,"clone","","",0,{"inputs":[{"name":"self"}],"output":{"name":"argument"}}],[11,"eq","","",0,{"inputs":[{"name":"self"},{"name":"argument"}],"output":{"name":"bool"}}],[11,"ne","","",0,{"inputs":[{"name":"self"},{"name":"argument"}],"output":{"name":"bool"}}],[11,"clone","","",1,{"inputs":[{"name":"self"}],"output":{"name":"formatspec"}}],[11,"eq","","",1,{"inputs":[{"name":"self"},{"name":"formatspec"}],"output":{"name":"bool"}}],[11,"ne","","",1,{"inputs":[{"name":"self"},{"name":"formatspec"}],"output":{"name":"bool"}}],[11,"clone","","",4,{"inputs":[{"name":"self"}],"output":{"name":"position"}}],[11,"eq","","",4,{"inputs":[{"name":"self"},{"name":"position"}],"output":{"name":"bool"}}],[11,"ne","","",4,{"inputs":[{"name":"self"},{"name":"position"}],"output":{"name":"bool"}}],[11,"clone","","",5,{"inputs":[{"name":"self"}],"output":{"name":"alignment"}}],[11,"eq","","",5,{"inputs":[{"name":"self"},{"name":"alignment"}],"output":{"name":"bool"}}],[11,"clone","","",6,{"inputs":[{"name":"self"}],"output":{"name":"flag"}}],[11,"eq","","",6,{"inputs":[{"name":"self"},{"name":"flag"}],"output":{"name":"bool"}}],[11,"clone","","",7,{"inputs":[{"name":"self"}],"output":{"name":"count"}}],[11,"eq","","",7,{"inputs":[{"name":"self"},{"name":"count"}],"output":{"name":"bool"}}],[11,"ne","","",7,{"inputs":[{"name":"self"},{"name":"count"}],"output":{"name":"bool"}}],[11,"next","","",2,{"inputs":[{"name":"self"}],"output":{"generics":["piece"],"name":"option"}}],[11,"new","","Creates a new parser for the given format string",2,{"inputs":[{"name":"str"}],"output":{"name":"parser"}}]],"paths":[[3,"Argument"],[3,"FormatSpec"],[3,"Parser"],[4,"Piece"],[4,"Position"],[4,"Alignment"],[4,"Flag"],[4,"Count"]]};
searchIndex["graphviz"] = {"doc":"Generate files suitable for use with Graphviz","items":[[3,"Id","graphviz","`Id` is a Graphviz `ID`.",null,null],[4,"LabelText","","The text for a graphviz label on a node or edge.",null,null],[13,"LabelStr","","This kind of label preserves the text directly as is.",0,null],[13,"EscStr","","This kind of label uses the graphviz label escString type: http://www.graphviz.org/content/attrs#kescString",0,null],[13,"HtmlStr","","This uses a graphviz [HTML string label][html]. The string is printed exactly as given, but between `<` and `>`. No escaping is performed.",0,null],[4,"Style","","The style for a node or edge. See http://www.graphviz.org/doc/info/attrs.html#k:style for descriptions. Note that some of these are not valid for edges.",null,null],[13,"None","","",1,null],[13,"Solid","","",1,null],[13,"Dashed","","",1,null],[13,"Dotted","","",1,null],[13,"Bold","","",1,null],[13,"Rounded","","",1,null],[13,"Diagonals","","",1,null],[13,"Filled","","",1,null],[13,"Striped","","",1,null],[13,"Wedged","","",1,null],[4,"RenderOption","","",null,null],[13,"NoEdgeLabels","","",2,null],[13,"NoNodeLabels","","",2,null],[13,"NoEdgeStyles","","",2,null],[13,"NoNodeStyles","","",2,null],[5,"escape_html","","Escape tags in such a way that it is suitable for inclusion in a Graphviz HTML label.",null,{"inputs":[{"name":"str"}],"output":{"name":"string"}}],[5,"default_options","","Returns vec holding all the default render options.",null,{"inputs":[],"output":{"generics":["renderoption"],"name":"vec"}}],[5,"render","","Renders directed graph `g` into the writer `w` in DOT syntax. (Simple wrapper around `render_opts` that passes a default set of options.)",null,{"inputs":[{"name":"g"},{"name":"w"}],"output":{"name":"result"}}],[5,"render_opts","","Renders directed graph `g` into the writer `w` in DOT syntax. (Main entry point for the library.)",null,null],[6,"Nodes","","",null,null],[6,"Edges","","",null,null],[8,"Labeller","","Each instance of a type that implements `Label<C>` maps to a unique identifier with respect to `C`, which is used to identify it in the generated .dot file. They can also provide more elaborate (and non-unique) label text that is used in the graphviz rendered output. The graph instance is responsible for providing the DOT compatible identifiers for the nodes and (optionally) rendered labels for the nodes and edges, as well as an identifier for the graph itself.",null,null],[16,"Node","","",3,null],[16,"Edge","","",3,null],[10,"graph_id","","Must return a DOT compatible identifier naming the graph.",3,{"inputs":[{"name":"self"}],"output":{"name":"id"}}],[10,"node_id","","Maps `n` to a unique identifier with respect to `self`. The implementor is responsible for ensuring that the returned name is a valid DOT identifier.",3,null],[11,"node_shape","","Maps `n` to one of the [graphviz `shape` names][1]. If `None` is returned, no `shape` attribute is specified.",3,null],[11,"node_label","","Maps `n` to a label that will be used in the rendered output. The label need not be unique, and may be the empty string; the default is just the output from `node_id`.",3,null],[11,"edge_label","","Maps `e` to a label that will be used in the rendered output. The label need not be unique, and may be the empty string; the default is in fact the empty string.",3,null],[11,"node_style","","Maps `n` to a style that will be used in the rendered output.",3,null],[11,"edge_style","","Maps `e` to a style that will be used in the rendered output.",3,null],[8,"GraphWalk","","GraphWalk is an abstraction over a directed graph = (nodes,edges) made up of node handles `N` and edge handles `E`, where each `E` can be mapped to its source and target nodes.",null,null],[16,"Node","","",4,null],[16,"Edge","","",4,null],[10,"nodes","","Returns all the nodes in this graph.",4,{"inputs":[{"name":"self"}],"output":{"name":"nodes"}}],[10,"edges","","Returns all of the edges in this graph.",4,{"inputs":[{"name":"self"}],"output":{"name":"edges"}}],[10,"source","","The source node for `edge`.",4,null],[10,"target","","The target node for `edge`.",4,null],[8,"IntoCow","","",null,null],[10,"into_cow","","",5,{"inputs":[{"name":"self"}],"output":{"name":"cow"}}],[11,"clone","","",1,{"inputs":[{"name":"self"}],"output":{"name":"style"}}],[11,"eq","","",1,{"inputs":[{"name":"self"},{"name":"style"}],"output":{"name":"bool"}}],[11,"fmt","","",1,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"as_slice","","",1,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"new","","Creates an `Id` named `name`.",6,{"inputs":[{"name":"name"}],"output":{"generics":["id"],"name":"result"}}],[11,"as_slice","","",6,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"name","","",6,{"inputs":[{"name":"self"}],"output":{"generics":["str"],"name":"cow"}}],[11,"label","","",0,{"inputs":[{"name":"s"}],"output":{"name":"labeltext"}}],[11,"escaped","","",0,{"inputs":[{"name":"s"}],"output":{"name":"labeltext"}}],[11,"html","","",0,{"inputs":[{"name":"s"}],"output":{"name":"labeltext"}}],[11,"to_dot_string","","Renders text as string suitable for a label in a .dot file. This includes quotes or suitable delimiters.",0,{"inputs":[{"name":"self"}],"output":{"name":"string"}}],[11,"prefix_line","","Puts `prefix` on a line above this label, with a blank line separator.",0,{"inputs":[{"name":"self"},{"name":"labeltext"}],"output":{"name":"labeltext"}}],[11,"suffix_line","","Puts `suffix` on a line below this label, with a blank line separator.",0,{"inputs":[{"name":"self"},{"name":"labeltext"}],"output":{"name":"labeltext"}}],[11,"clone","","",2,{"inputs":[{"name":"self"}],"output":{"name":"renderoption"}}],[11,"eq","","",2,{"inputs":[{"name":"self"},{"name":"renderoption"}],"output":{"name":"bool"}}],[11,"fmt","","",2,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}]],"paths":[[4,"LabelText"],[4,"Style"],[4,"RenderOption"],[8,"Labeller"],[8,"GraphWalk"],[8,"IntoCow"],[3,"Id"]]};
searchIndex["proc_macro"] = {"doc":"A support library for macro authors when defining new macros.","items":[[3,"Diagnostic","proc_macro","A structure representing a diagnostic message and associated children messages.",null,null],[3,"TokenStream","","The main type provided by this crate, representing an abstract stream of tokens.",null,null],[3,"LexError","","Error returned from `TokenStream::from_str`.",null,null],[3,"Span","","A region of source code, along with macro expansion information.",null,null],[3,"LineColumn","","A line-column pair representing the start or end of a `Span`.",null,null],[12,"line","","The 1-indexed line in the source file on which the span starts or ends (inclusive).",0,null],[12,"column","","The 0-indexed column (in UTF-8 characters) in the source file on which the span starts or ends (inclusive).",0,null],[3,"SourceFile","","The source file of a given `Span`.",null,null],[3,"TokenTree","","A single token or a delimited sequence of token trees (e.g. `[1, (), ..]`).",null,null],[12,"span","","The `TokenTree`'s span",1,null],[12,"kind","","Description of the `TokenTree`",1,null],[3,"Term","","An interned string.",null,null],[3,"Literal","","A literal character (`'a'`), string (`\"hello\"`), or number (`2.3`).",null,null],[3,"TokenTreeIter","","An iterator over `TokenTree`s.",null,null],[4,"Level","","An enum representing a diagnostic level.",null,null],[13,"Error","","An error.",2,null],[13,"Warning","","A warning.",2,null],[13,"Note","","A note.",2,null],[13,"Help","","A help message.",2,null],[4,"TokenNode","","Description of a `TokenTree`",null,null],[13,"Group","","A delimited tokenstream.",3,null],[13,"Term","","A unicode identifier.",3,null],[13,"Op","","A punctuation character (`+`, `,`, `$`, etc.).",3,null],[13,"Literal","","A literal character (`'a'`), string (`\"hello\"`), or number (`2.3`).",3,null],[4,"Delimiter","","Describes how a sequence of token trees is delimited.",null,null],[13,"Parenthesis","","`( ... )`",4,null],[13,"Brace","","`{ ... }`",4,null],[13,"Bracket","","`[ ... ]`",4,null],[13,"None","","An implicit delimiter, e.g. `$var`, where $var is  `...`.",4,null],[4,"Spacing","","Whether an `Op` is either followed immediately by another `Op` or followed by whitespace.",null,null],[13,"Alone","","e.g. `+` is `Alone` in `+ =`.",5,null],[13,"Joint","","e.g. `+` is `Joint` in `+=`.",5,null],[5,"quote_span","","Quote a `Span` into a `TokenStream`. This is needed to implement a custom quoter.",null,{"inputs":[{"name":"span"}],"output":{"name":"tokenstream"}}],[11,"clone","","",2,{"inputs":[{"name":"self"}],"output":{"name":"level"}}],[11,"fmt","","",2,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",6,{"inputs":[{"name":"self"}],"output":{"name":"diagnostic"}}],[11,"fmt","","",6,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Create a new diagnostic with the given `level` and `message`.",6,{"inputs":[{"name":"level"},{"name":"t"}],"output":{"name":"diagnostic"}}],[11,"spanned","","Create a new diagnostic with the given `level` and `message` pointing to the given `span`.",6,{"inputs":[{"name":"span"},{"name":"level"},{"name":"t"}],"output":{"name":"diagnostic"}}],[11,"span_error","","Add a new child diagnostic message to `self` with the level identified by this methods name with the given `span` and `message`.",6,{"inputs":[{"name":"self"},{"name":"span"},{"name":"t"}],"output":{"name":"diagnostic"}}],[11,"error","","Add a new child diagnostic message to `self` with the level identified by this method's name with the given `message`.",6,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"diagnostic"}}],[11,"span_warning","","Add a new child diagnostic message to `self` with the level identified by this methods name with the given `span` and `message`.",6,{"inputs":[{"name":"self"},{"name":"span"},{"name":"t"}],"output":{"name":"diagnostic"}}],[11,"warning","","Add a new child diagnostic message to `self` with the level identified by this method's name with the given `message`.",6,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"diagnostic"}}],[11,"span_note","","Add a new child diagnostic message to `self` with the level identified by this methods name with the given `span` and `message`.",6,{"inputs":[{"name":"self"},{"name":"span"},{"name":"t"}],"output":{"name":"diagnostic"}}],[11,"note","","Add a new child diagnostic message to `self` with the level identified by this method's name with the given `message`.",6,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"diagnostic"}}],[11,"span_help","","Add a new child diagnostic message to `self` with the level identified by this methods name with the given `span` and `message`.",6,{"inputs":[{"name":"self"},{"name":"span"},{"name":"t"}],"output":{"name":"diagnostic"}}],[11,"help","","Add a new child diagnostic message to `self` with the level identified by this method's name with the given `message`.",6,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"diagnostic"}}],[11,"level","","Returns the diagnostic `level` for `self`.",6,{"inputs":[{"name":"self"}],"output":{"name":"level"}}],[11,"emit","","Emit the diagnostic.",6,{"inputs":[{"name":"self"}],"output":null}],[11,"clone","","",7,{"inputs":[{"name":"self"}],"output":{"name":"tokenstream"}}],[11,"fmt","","",7,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",8,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"from_str","","",7,{"inputs":[{"name":"str"}],"output":{"generics":["tokenstream","lexerror"],"name":"result"}}],[11,"fmt","","",7,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"from","","",7,{"inputs":[{"name":"tokentree"}],"output":{"name":"tokenstream"}}],[11,"from","","",7,{"inputs":[{"name":"tokennode"}],"output":{"name":"tokenstream"}}],[11,"from_iter","","",7,{"inputs":[{"name":"i"}],"output":{"name":"self"}}],[11,"into_iter","","",7,{"inputs":[{"name":"self"}],"output":{"name":"tokentreeiter"}}],[11,"empty","","Returns an empty `TokenStream`.",7,{"inputs":[],"output":{"name":"tokenstream"}}],[11,"is_empty","","Checks if this `TokenStream` is empty.",7,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",9,{"inputs":[{"name":"self"}],"output":{"name":"span"}}],[11,"fmt","","",9,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",9,{"inputs":[{"name":"self"},{"name":"span"}],"output":{"name":"bool"}}],[11,"ne","","",9,{"inputs":[{"name":"self"},{"name":"span"}],"output":{"name":"bool"}}],[11,"def_site","","A span that resolves at the macro definition site.",9,{"inputs":[],"output":{"name":"span"}}],[11,"call_site","","The span of the invocation of the current procedural macro.",9,{"inputs":[],"output":{"name":"span"}}],[11,"source_file","","The original source file into which this span points.",9,{"inputs":[{"name":"self"}],"output":{"name":"sourcefile"}}],[11,"parent","","The `Span` for the tokens in the previous macro expansion from which `self` was generated from, if any.",9,{"inputs":[{"name":"self"}],"output":{"generics":["span"],"name":"option"}}],[11,"source","","The span for the origin source code that `self` was generated from. If this `Span` wasn't generated from other macro expansions then the return value is the same as `*self`.",9,{"inputs":[{"name":"self"}],"output":{"name":"span"}}],[11,"start","","Get the starting line/column in the source file for this span.",9,{"inputs":[{"name":"self"}],"output":{"name":"linecolumn"}}],[11,"end","","Get the ending line/column in the source file for this span.",9,{"inputs":[{"name":"self"}],"output":{"name":"linecolumn"}}],[11,"join","","Create a new span encompassing `self` and `other`.",9,{"inputs":[{"name":"self"},{"name":"span"}],"output":{"generics":["span"],"name":"option"}}],[11,"resolved_at","","Creates a new span with the same line/column information as `self` but that resolves symbols as though it were at `other`.",9,{"inputs":[{"name":"self"},{"name":"span"}],"output":{"name":"span"}}],[11,"located_at","","Creates a new span with the same name resolution behavior as `self` but with the line/column information of `other`.",9,{"inputs":[{"name":"self"},{"name":"span"}],"output":{"name":"span"}}],[11,"error","","Create a new `Diagnostic` with the given `message` at the span `self`.",9,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"diagnostic"}}],[11,"warning","","Create a new `Diagnostic` with the given `message` at the span `self`.",9,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"diagnostic"}}],[11,"note","","Create a new `Diagnostic` with the given `message` at the span `self`.",9,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"diagnostic"}}],[11,"help","","Create a new `Diagnostic` with the given `message` at the span `self`.",9,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"diagnostic"}}],[11,"clone","","",0,{"inputs":[{"name":"self"}],"output":{"name":"linecolumn"}}],[11,"fmt","","",0,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",0,{"inputs":[{"name":"self"},{"name":"linecolumn"}],"output":{"name":"bool"}}],[11,"ne","","",0,{"inputs":[{"name":"self"},{"name":"linecolumn"}],"output":{"name":"bool"}}],[11,"clone","","",10,{"inputs":[{"name":"self"}],"output":{"name":"sourcefile"}}],[11,"path","","Get the path to this source file.",10,{"inputs":[{"name":"self"}],"output":{"name":"filename"}}],[11,"is_real","","Returns `true` if this source file is a real source file, and not generated by an external macro's expansion.",10,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"as_ref","","",10,{"inputs":[{"name":"self"}],"output":{"name":"filename"}}],[11,"fmt","","",10,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",10,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"bool"}}],[11,"eq","","",10,{"inputs":[{"name":"self"},{"name":"filename"}],"output":{"name":"bool"}}],[11,"clone","","",1,{"inputs":[{"name":"self"}],"output":{"name":"tokentree"}}],[11,"fmt","","",1,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"from","","",1,{"inputs":[{"name":"tokennode"}],"output":{"name":"tokentree"}}],[11,"fmt","","",1,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",3,{"inputs":[{"name":"self"}],"output":{"name":"tokennode"}}],[11,"fmt","","",3,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",4,{"inputs":[{"name":"self"}],"output":{"name":"delimiter"}}],[11,"fmt","","",4,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",4,{"inputs":[{"name":"self"},{"name":"delimiter"}],"output":{"name":"bool"}}],[11,"clone","","",11,{"inputs":[{"name":"self"}],"output":{"name":"term"}}],[11,"fmt","","",11,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"intern","","Intern a string into a `Term`.",11,{"inputs":[{"name":"str"}],"output":{"name":"term"}}],[11,"as_str","","Get a reference to the interned string.",11,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"clone","","",5,{"inputs":[{"name":"self"}],"output":{"name":"spacing"}}],[11,"fmt","","",5,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",5,{"inputs":[{"name":"self"},{"name":"spacing"}],"output":{"name":"bool"}}],[11,"clone","","",12,{"inputs":[{"name":"self"}],"output":{"name":"literal"}}],[11,"fmt","","",12,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",12,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"integer","","Integer literal",12,{"inputs":[{"name":"i128"}],"output":{"name":"literal"}}],[11,"u8","","Integer literal.",12,{"inputs":[{"name":"u8"}],"output":{"name":"literal"}}],[11,"i8","","Integer literal.",12,{"inputs":[{"name":"i8"}],"output":{"name":"literal"}}],[11,"u16","","Integer literal.",12,{"inputs":[{"name":"u16"}],"output":{"name":"literal"}}],[11,"i16","","Integer literal.",12,{"inputs":[{"name":"i16"}],"output":{"name":"literal"}}],[11,"u32","","Integer literal.",12,{"inputs":[{"name":"u32"}],"output":{"name":"literal"}}],[11,"i32","","Integer literal.",12,{"inputs":[{"name":"i32"}],"output":{"name":"literal"}}],[11,"u64","","Integer literal.",12,{"inputs":[{"name":"u64"}],"output":{"name":"literal"}}],[11,"i64","","Integer literal.",12,{"inputs":[{"name":"i64"}],"output":{"name":"literal"}}],[11,"usize","","Integer literal.",12,{"inputs":[{"name":"usize"}],"output":{"name":"literal"}}],[11,"isize","","Integer literal.",12,{"inputs":[{"name":"isize"}],"output":{"name":"literal"}}],[11,"float","","Floating point literal.",12,{"inputs":[{"name":"f64"}],"output":{"name":"literal"}}],[11,"f32","","Floating point literal.",12,{"inputs":[{"name":"f32"}],"output":{"name":"literal"}}],[11,"f64","","Floating point literal.",12,{"inputs":[{"name":"f64"}],"output":{"name":"literal"}}],[11,"string","","String literal.",12,{"inputs":[{"name":"str"}],"output":{"name":"literal"}}],[11,"character","","Character literal.",12,{"inputs":[{"name":"char"}],"output":{"name":"literal"}}],[11,"byte_string","","Byte string literal.",12,null],[11,"clone","","",13,{"inputs":[{"name":"self"}],"output":{"name":"tokentreeiter"}}],[11,"next","","",13,{"inputs":[{"name":"self"}],"output":{"generics":["tokentree"],"name":"option"}}],[14,"quote","","`quote!(..)` accepts arbitrary tokens and expands into a `TokenStream` describing the input. For example, `quote!(a + b)` will produce a expression, that, when evaluated, constructs the `TokenStream` `[Word(\"a\"), Op('+', Alone), Word(\"b\")]`.",null,null]],"paths":[[3,"LineColumn"],[3,"TokenTree"],[4,"Level"],[4,"TokenNode"],[4,"Delimiter"],[4,"Spacing"],[3,"Diagnostic"],[3,"TokenStream"],[3,"LexError"],[3,"Span"],[3,"SourceFile"],[3,"Term"],[3,"Literal"],[3,"TokenTreeIter"]]};
searchIndex["rustc"] = {"doc":"The \"main crate\" of the Rust compiler. This crate contains common type definitions that are used by the other crates in the rustc \"family\". Some prominent examples (note that each of these modules has their own README with further details).","items":[[0,"diagnostics","rustc","",null,null],[0,"cfg","","Module that constructs a control-flow graph representing an item. Uses `Graph` as the underlying representation.",null,null],[3,"CFG","rustc::cfg","",null,null],[12,"owner_def_id","","",0,null],[12,"graph","","",0,null],[12,"entry","","",0,null],[12,"exit","","",0,null],[3,"CFGEdgeData","","",null,null],[12,"exiting_scopes","","",1,null],[4,"CFGNodeData","","",null,null],[13,"AST","","",2,null],[13,"Entry","","",2,null],[13,"Exit","","",2,null],[13,"Dummy","","",2,null],[13,"Unreachable","","",2,null],[0,"graphviz","","",null,null],[3,"LabelledCFG","rustc::cfg::graphviz","",null,null],[12,"tcx","","",3,null],[12,"cfg","","",3,null],[12,"name","","",3,null],[12,"labelled_edges","","`labelled_edges` controls whether we emit labels on the edges",3,null],[6,"Node","","",null,null],[6,"Edge","","",null,null],[11,"graph_id","","",3,{"inputs":[{"name":"self"}],"output":{"name":"id"}}],[11,"node_id","","",3,{"inputs":[{"name":"self"},{"name":"node"}],"output":{"name":"id"}}],[11,"node_label","","",3,{"inputs":[{"name":"self"},{"name":"node"}],"output":{"name":"labeltext"}}],[11,"edge_label","","",3,{"inputs":[{"name":"self"},{"name":"edge"}],"output":{"name":"labeltext"}}],[11,"nodes","","",3,{"inputs":[{"name":"self"}],"output":{"generics":["node"],"name":"nodes"}}],[11,"edges","","",3,{"inputs":[{"name":"self"}],"output":{"generics":["edge"],"name":"edges"}}],[11,"source","","",3,{"inputs":[{"name":"self"},{"name":"edge"}],"output":{"name":"node"}}],[11,"target","","",3,{"inputs":[{"name":"self"},{"name":"edge"}],"output":{"name":"node"}}],[6,"CFGIndex","rustc::cfg","",null,null],[6,"CFGGraph","","",null,null],[6,"CFGNode","","",null,null],[6,"CFGEdge","","",null,null],[11,"clone","","",2,{"inputs":[{"name":"self"}],"output":{"name":"cfgnodedata"}}],[11,"fmt","","",2,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",2,{"inputs":[{"name":"self"},{"name":"cfgnodedata"}],"output":{"name":"bool"}}],[11,"ne","","",2,{"inputs":[{"name":"self"},{"name":"cfgnodedata"}],"output":{"name":"bool"}}],[11,"id","","",2,{"inputs":[{"name":"self"}],"output":{"name":"itemlocalid"}}],[11,"fmt","","",1,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","",0,{"inputs":[{"name":"tyctxt"},{"name":"body"}],"output":{"name":"cfg"}}],[11,"node_is_reachable","","",0,{"inputs":[{"name":"self"},{"name":"itemlocalid"}],"output":{"name":"bool"}}],[0,"dep_graph","rustc","",null,null],[3,"DepTrackingMap","rustc::dep_graph","A DepTrackingMap offers a subset of the `Map` API and ensures that we make calls to `read` and `write` as appropriate. We key the maps with a unique type for brevity.",null,null],[3,"DepNode","","",null,null],[12,"kind","","",4,null],[12,"hash","","",4,null],[3,"WorkProductId","","A \"work product\" corresponds to a `.o` (or other) file that we save in between runs. These ids do not have a DefId but rather some independent path or string that persists between runs without the need to be mapped or unmapped. (This ensures we can serialize them even in the absence of a tcx.)",null,null],[3,"DepGraph","","",null,null],[3,"WorkProduct","","A \"work product\" is an intermediate result that we save into the incremental directory for later re-use. The primary example are the object files that we save for each partition at code generation time.",null,null],[12,"cgu_name","","",5,null],[12,"saved_files","","Saved files associated with this CGU",5,null],[3,"DepNodeIndex","","",null,null],[3,"PreviousDepGraph","","",null,null],[3,"DepGraphQuery","","",null,null],[12,"graph","","",6,null],[12,"indices","","",6,null],[3,"AssertDepGraphSafe","","A convenient override that lets you pass arbitrary state into a task. Every use should be accompanied by a comment explaining why it makes sense (or how it could be refactored away in the future).",null,null],[12,"0","","",7,null],[3,"SerializedDepGraph","","Data for use when recompiling the current crate.",null,null],[12,"nodes","","The set of all DepNodes in the graph",8,null],[12,"fingerprints","","The set of all Fingerprints in the graph. Each Fingerprint corresponds to the DepNode at the same index in the nodes vector.",8,null],[12,"edge_list_indices","","For each DepNode, stores the list of edges originating from that DepNode. Encoded as a [start, end) pair indexing into edge_list_data, which holds the actual DepNodeIndices of the target nodes.",8,null],[12,"edge_list_data","","A flattened list of all edge targets in the graph. Edge sources are implicit in edge_list_indices.",8,null],[3,"SerializedDepNodeIndex","","",null,null],[4,"DepKind","","",null,null],[13,"Null","","",9,null],[13,"Krate","","",9,null],[13,"HirBody","","",9,null],[13,"Hir","","",9,null],[13,"CrateMetadata","","",9,null],[13,"RegionScopeTree","","",9,null],[13,"Coherence","","",9,null],[13,"CoherenceInherentImplOverlapCheck","","",9,null],[13,"CoherenceCheckTrait","","",9,null],[13,"PrivacyAccessLevels","","",9,null],[13,"MirConstQualif","","",9,null],[13,"MirBuilt","","",9,null],[13,"MirConst","","",9,null],[13,"MirValidated","","",9,null],[13,"MirOptimized","","",9,null],[13,"MirShim","","",9,null],[13,"BorrowCheckKrate","","",9,null],[13,"BorrowCheck","","",9,null],[13,"MirBorrowCheck","","",9,null],[13,"UnsafetyCheckResult","","",9,null],[13,"UnsafeDeriveOnReprPacked","","",9,null],[13,"Reachability","","",9,null],[13,"MirKeys","","",9,null],[13,"CrateVariances","","",9,null],[13,"AssociatedItems","","",9,null],[13,"TypeOfItem","","",9,null],[13,"GenericsOfItem","","",9,null],[13,"PredicatesOfItem","","",9,null],[13,"InferredOutlivesOf","","",9,null],[13,"SuperPredicatesOfItem","","",9,null],[13,"TraitDefOfItem","","",9,null],[13,"AdtDefOfItem","","",9,null],[13,"ImplTraitRef","","",9,null],[13,"ImplPolarity","","",9,null],[13,"FnSignature","","",9,null],[13,"CoerceUnsizedInfo","","",9,null],[13,"ItemVarianceConstraints","","",9,null],[13,"ItemVariances","","",9,null],[13,"IsConstFn","","",9,null],[13,"IsForeignItem","","",9,null],[13,"TypeParamPredicates","","",9,null],[13,"SizedConstraint","","",9,null],[13,"DtorckConstraint","","",9,null],[13,"AdtDestructor","","",9,null],[13,"AssociatedItemDefIds","","",9,null],[13,"InherentImpls","","",9,null],[13,"TypeckBodiesKrate","","",9,null],[13,"TypeckTables","","",9,null],[13,"UsedTraitImports","","",9,null],[13,"HasTypeckTables","","",9,null],[13,"ConstEval","","",9,null],[13,"CheckMatch","","",9,null],[13,"SymbolName","","",9,null],[13,"InstanceSymbolName","","",9,null],[13,"SpecializationGraph","","",9,null],[13,"ObjectSafety","","",9,null],[13,"FulfillObligation","","",9,null],[13,"VtableMethods","","",9,null],[13,"IsCopy","","",9,null],[13,"IsSized","","",9,null],[13,"IsFreeze","","",9,null],[13,"NeedsDrop","","",9,null],[13,"Layout","","",9,null],[13,"TraitImpls","","",9,null],[13,"AllLocalTraitImpls","","",9,null],[13,"TraitSelect","","",9,null],[13,"ParamEnv","","",9,null],[13,"DescribeDef","","",9,null],[13,"DefSpan","","",9,null],[13,"LookupStability","","",9,null],[13,"LookupDeprecationEntry","","",9,null],[13,"ItemBodyNestedBodies","","",9,null],[13,"ConstIsRvaluePromotableToStatic","","",9,null],[13,"RvaluePromotableMap","","",9,null],[13,"ImplParent","","",9,null],[13,"TraitOfItem","","",9,null],[13,"IsReachableNonGeneric","","",9,null],[13,"IsMirAvailable","","",9,null],[13,"ItemAttrs","","",9,null],[13,"TransFnAttrs","","",9,null],[13,"FnArgNames","","",9,null],[13,"DylibDepFormats","","",9,null],[13,"IsPanicRuntime","","",9,null],[13,"IsCompilerBuiltins","","",9,null],[13,"HasGlobalAllocator","","",9,null],[13,"ExternCrate","","",9,null],[13,"LintLevels","","",9,null],[13,"Specializes","","",9,null],[13,"InScopeTraits","","",9,null],[13,"ModuleExports","","",9,null],[13,"IsSanitizerRuntime","","",9,null],[13,"IsProfilerRuntime","","",9,null],[13,"GetPanicStrategy","","",9,null],[13,"IsNoBuiltins","","",9,null],[13,"ImplDefaultness","","",9,null],[13,"CheckItemWellFormed","","",9,null],[13,"CheckTraitItemWellFormed","","",9,null],[13,"CheckImplItemWellFormed","","",9,null],[13,"ReachableNonGenerics","","",9,null],[13,"NativeLibraries","","",9,null],[13,"PluginRegistrarFn","","",9,null],[13,"DeriveRegistrarFn","","",9,null],[13,"CrateDisambiguator","","",9,null],[13,"CrateHash","","",9,null],[13,"OriginalCrateName","","",9,null],[13,"ImplementationsOfTrait","","",9,null],[13,"AllTraitImplementations","","",9,null],[13,"DllimportForeignItems","","",9,null],[13,"IsDllimportForeignItem","","",9,null],[13,"IsStaticallyIncludedForeignItem","","",9,null],[13,"NativeLibraryKind","","",9,null],[13,"LinkArgs","","",9,null],[13,"ResolveLifetimes","","",9,null],[13,"NamedRegion","","",9,null],[13,"IsLateBound","","",9,null],[13,"ObjectLifetimeDefaults","","",9,null],[13,"Visibility","","",9,null],[13,"DepKind","","",9,null],[13,"CrateName","","",9,null],[13,"ItemChildren","","",9,null],[13,"ExternModStmtCnum","","",9,null],[13,"GetLangItems","","",9,null],[13,"DefinedLangItems","","",9,null],[13,"MissingLangItems","","",9,null],[13,"ExternConstBody","","",9,null],[13,"VisibleParentMap","","",9,null],[13,"MissingExternCrateItem","","",9,null],[13,"UsedCrateSource","","",9,null],[13,"PostorderCnums","","",9,null],[13,"EraseRegionsTy","","",9,null],[13,"Freevars","","",9,null],[13,"MaybeUnusedTraitImport","","",9,null],[13,"MaybeUnusedExternCrates","","",9,null],[13,"StabilityIndex","","",9,null],[13,"AllCrateNums","","",9,null],[13,"ExportedSymbols","","",9,null],[13,"CollectAndPartitionTranslationItems","","",9,null],[13,"IsTranslatedItem","","",9,null],[13,"CodegenUnit","","",9,null],[13,"CompileCodegenUnit","","",9,null],[13,"OutputFilenames","","",9,null],[13,"NormalizeProjectionTy","","",9,null],[13,"NormalizeTyAfterErasingRegions","","",9,null],[13,"DropckOutlives","","",9,null],[13,"SubstituteNormalizeAndTestPredicates","","",9,null],[13,"TargetFeaturesWhitelist","","",9,null],[13,"InstanceDefSizeEstimate","","",9,null],[13,"GetSymbolExportLevel","","",9,null],[13,"WasmCustomSections","","",9,null],[13,"Features","","",9,null],[13,"ProgramClausesFor","","",9,null],[13,"WasmImportModuleMap","","",9,null],[13,"ForeignModules","","",9,null],[4,"DepConstructor","","",null,null],[13,"Null","","",10,null],[13,"Krate","","",10,null],[13,"HirBody","","",10,null],[13,"Hir","","",10,null],[13,"CrateMetadata","","",10,null],[13,"RegionScopeTree","","",10,null],[13,"Coherence","","",10,null],[13,"CoherenceInherentImplOverlapCheck","","",10,null],[13,"CoherenceCheckTrait","","",10,null],[13,"PrivacyAccessLevels","","",10,null],[13,"MirConstQualif","","",10,null],[13,"MirBuilt","","",10,null],[13,"MirConst","","",10,null],[13,"MirValidated","","",10,null],[13,"MirOptimized","","",10,null],[13,"MirShim","","",10,null],[12,"instance_def","rustc::dep_graph::DepConstructor","",10,null],[13,"BorrowCheckKrate","rustc::dep_graph","",10,null],[13,"BorrowCheck","","",10,null],[13,"MirBorrowCheck","","",10,null],[13,"UnsafetyCheckResult","","",10,null],[13,"UnsafeDeriveOnReprPacked","","",10,null],[13,"Reachability","","",10,null],[13,"MirKeys","","",10,null],[13,"CrateVariances","","",10,null],[13,"AssociatedItems","","",10,null],[13,"TypeOfItem","","",10,null],[13,"GenericsOfItem","","",10,null],[13,"PredicatesOfItem","","",10,null],[13,"InferredOutlivesOf","","",10,null],[13,"SuperPredicatesOfItem","","",10,null],[13,"TraitDefOfItem","","",10,null],[13,"AdtDefOfItem","","",10,null],[13,"ImplTraitRef","","",10,null],[13,"ImplPolarity","","",10,null],[13,"FnSignature","","",10,null],[13,"CoerceUnsizedInfo","","",10,null],[13,"ItemVarianceConstraints","","",10,null],[13,"ItemVariances","","",10,null],[13,"IsConstFn","","",10,null],[13,"IsForeignItem","","",10,null],[13,"TypeParamPredicates","","",10,null],[12,"item_id","rustc::dep_graph::DepConstructor","",10,null],[12,"param_id","","",10,null],[13,"SizedConstraint","rustc::dep_graph","",10,null],[13,"DtorckConstraint","","",10,null],[13,"AdtDestructor","","",10,null],[13,"AssociatedItemDefIds","","",10,null],[13,"InherentImpls","","",10,null],[13,"TypeckBodiesKrate","","",10,null],[13,"TypeckTables","","",10,null],[13,"UsedTraitImports","","",10,null],[13,"HasTypeckTables","","",10,null],[13,"ConstEval","","",10,null],[12,"param_env","rustc::dep_graph::DepConstructor","",10,null],[13,"CheckMatch","rustc::dep_graph","",10,null],[13,"SymbolName","","",10,null],[13,"InstanceSymbolName","","",10,null],[12,"instance","rustc::dep_graph::DepConstructor","",10,null],[13,"SpecializationGraph","rustc::dep_graph","",10,null],[13,"ObjectSafety","","",10,null],[13,"FulfillObligation","","",10,null],[12,"param_env","rustc::dep_graph::DepConstructor","",10,null],[12,"trait_ref","","",10,null],[13,"VtableMethods","rustc::dep_graph","",10,null],[12,"trait_ref","rustc::dep_graph::DepConstructor","",10,null],[13,"IsCopy","rustc::dep_graph","",10,null],[12,"param_env","rustc::dep_graph::DepConstructor","",10,null],[13,"IsSized","rustc::dep_graph","",10,null],[12,"param_env","rustc::dep_graph::DepConstructor","",10,null],[13,"IsFreeze","rustc::dep_graph","",10,null],[12,"param_env","rustc::dep_graph::DepConstructor","",10,null],[13,"NeedsDrop","rustc::dep_graph","",10,null],[12,"param_env","rustc::dep_graph::DepConstructor","",10,null],[13,"Layout","rustc::dep_graph","",10,null],[12,"param_env","rustc::dep_graph::DepConstructor","",10,null],[13,"TraitImpls","rustc::dep_graph","",10,null],[13,"AllLocalTraitImpls","","",10,null],[13,"TraitSelect","","",10,null],[13,"ParamEnv","","",10,null],[13,"DescribeDef","","",10,null],[13,"DefSpan","","",10,null],[13,"LookupStability","","",10,null],[13,"LookupDeprecationEntry","","",10,null],[13,"ItemBodyNestedBodies","","",10,null],[13,"ConstIsRvaluePromotableToStatic","","",10,null],[13,"RvaluePromotableMap","","",10,null],[13,"ImplParent","","",10,null],[13,"TraitOfItem","","",10,null],[13,"IsReachableNonGeneric","","",10,null],[13,"IsMirAvailable","","",10,null],[13,"ItemAttrs","","",10,null],[13,"TransFnAttrs","","",10,null],[13,"FnArgNames","","",10,null],[13,"DylibDepFormats","","",10,null],[13,"IsPanicRuntime","","",10,null],[13,"IsCompilerBuiltins","","",10,null],[13,"HasGlobalAllocator","","",10,null],[13,"ExternCrate","","",10,null],[13,"LintLevels","","",10,null],[13,"Specializes","","",10,null],[12,"impl1","rustc::dep_graph::DepConstructor","",10,null],[12,"impl2","","",10,null],[13,"InScopeTraits","rustc::dep_graph","",10,null],[13,"ModuleExports","","",10,null],[13,"IsSanitizerRuntime","","",10,null],[13,"IsProfilerRuntime","","",10,null],[13,"GetPanicStrategy","","",10,null],[13,"IsNoBuiltins","","",10,null],[13,"ImplDefaultness","","",10,null],[13,"CheckItemWellFormed","","",10,null],[13,"CheckTraitItemWellFormed","","",10,null],[13,"CheckImplItemWellFormed","","",10,null],[13,"ReachableNonGenerics","","",10,null],[13,"NativeLibraries","","",10,null],[13,"PluginRegistrarFn","","",10,null],[13,"DeriveRegistrarFn","","",10,null],[13,"CrateDisambiguator","","",10,null],[13,"CrateHash","","",10,null],[13,"OriginalCrateName","","",10,null],[13,"ImplementationsOfTrait","","",10,null],[12,"krate","rustc::dep_graph::DepConstructor","",10,null],[12,"trait_id","","",10,null],[13,"AllTraitImplementations","rustc::dep_graph","",10,null],[13,"DllimportForeignItems","","",10,null],[13,"IsDllimportForeignItem","","",10,null],[13,"IsStaticallyIncludedForeignItem","","",10,null],[13,"NativeLibraryKind","","",10,null],[13,"LinkArgs","","",10,null],[13,"ResolveLifetimes","","",10,null],[13,"NamedRegion","","",10,null],[13,"IsLateBound","","",10,null],[13,"ObjectLifetimeDefaults","","",10,null],[13,"Visibility","","",10,null],[13,"DepKind","","",10,null],[13,"CrateName","","",10,null],[13,"ItemChildren","","",10,null],[13,"ExternModStmtCnum","","",10,null],[13,"GetLangItems","","",10,null],[13,"DefinedLangItems","","",10,null],[13,"MissingLangItems","","",10,null],[13,"ExternConstBody","","",10,null],[13,"VisibleParentMap","","",10,null],[13,"MissingExternCrateItem","","",10,null],[13,"UsedCrateSource","","",10,null],[13,"PostorderCnums","","",10,null],[13,"EraseRegionsTy","","",10,null],[12,"ty","rustc::dep_graph::DepConstructor","",10,null],[13,"Freevars","rustc::dep_graph","",10,null],[13,"MaybeUnusedTraitImport","","",10,null],[13,"MaybeUnusedExternCrates","","",10,null],[13,"StabilityIndex","","",10,null],[13,"AllCrateNums","","",10,null],[13,"ExportedSymbols","","",10,null],[13,"CollectAndPartitionTranslationItems","","",10,null],[13,"IsTranslatedItem","","",10,null],[13,"CodegenUnit","","",10,null],[13,"CompileCodegenUnit","","",10,null],[13,"OutputFilenames","","",10,null],[13,"NormalizeProjectionTy","","",10,null],[13,"NormalizeTyAfterErasingRegions","","",10,null],[13,"DropckOutlives","","",10,null],[13,"SubstituteNormalizeAndTestPredicates","","",10,null],[12,"key","rustc::dep_graph::DepConstructor","",10,null],[13,"TargetFeaturesWhitelist","rustc::dep_graph","",10,null],[13,"InstanceDefSizeEstimate","","",10,null],[12,"instance_def","rustc::dep_graph::DepConstructor","",10,null],[13,"GetSymbolExportLevel","rustc::dep_graph","",10,null],[13,"WasmCustomSections","","",10,null],[13,"Features","","",10,null],[13,"ProgramClausesFor","","",10,null],[13,"WasmImportModuleMap","","",10,null],[13,"ForeignModules","","",10,null],[4,"DepNodeColor","","",null,null],[13,"Red","","",11,null],[13,"Green","","",11,null],[4,"WorkProductFileKind","","",null,null],[13,"Object","","",12,null],[13,"Bytecode","","",12,null],[13,"BytecodeCompressed","","",12,null],[0,"debug","","Code for debugging the dep-graph.",null,null],[3,"DepNodeFilter","rustc::dep_graph::debug","A dep-node filter goes from a user-defined string to a query over nodes. Right now the format is like this:",null,null],[3,"EdgeFilter","","A filter like `F -> G` where `F` and `G` are valid dep-node filters. This can be used to test the source/target independently.",null,null],[12,"source","","",13,null],[12,"target","","",13,null],[11,"fmt","","",14,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","",14,{"inputs":[{"name":"str"}],"output":{"name":"self"}}],[11,"accepts_all","","True if all nodes always pass the filter.",14,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"test","","Tests whether `node` meets the filter, returning true if so.",14,{"inputs":[{"name":"self"},{"name":"depnode"}],"output":{"name":"bool"}}],[11,"new","","",13,{"inputs":[{"name":"str"}],"output":{"generics":["edgefilter","box"],"name":"result"}}],[11,"test","","",13,{"inputs":[{"name":"self"},{"name":"depnode"},{"name":"depnode"}],"output":{"name":"bool"}}],[11,"fmt","rustc::dep_graph","",4,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fingerprint_needed_for_crate_hash","","",9,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",9,{"inputs":[{"name":"self"}],"output":{"name":"depkind"}}],[11,"fmt","","",9,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",9,{"inputs":[{"name":"self"},{"name":"depkind"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",9,{"inputs":[{"name":"self"},{"name":"depkind"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"cmp","","",9,{"inputs":[{"name":"self"},{"name":"depkind"}],"output":{"name":"ordering"}}],[11,"hash","","",9,null],[11,"encode","","",9,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",9,{"inputs":[{"name":"__d"}],"output":{"generics":["depkind"],"name":"result"}}],[11,"can_reconstruct_query_key","","",9,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_anon","","",9,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_input","","",9,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_eval_always","","",9,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"has_params","","",9,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",4,{"inputs":[{"name":"self"}],"output":{"name":"depnode"}}],[11,"eq","","",4,{"inputs":[{"name":"self"},{"name":"depnode"}],"output":{"name":"bool"}}],[11,"ne","","",4,{"inputs":[{"name":"self"},{"name":"depnode"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",4,{"inputs":[{"name":"self"},{"name":"depnode"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",4,{"inputs":[{"name":"self"},{"name":"depnode"}],"output":{"name":"bool"}}],[11,"le","","",4,{"inputs":[{"name":"self"},{"name":"depnode"}],"output":{"name":"bool"}}],[11,"gt","","",4,{"inputs":[{"name":"self"},{"name":"depnode"}],"output":{"name":"bool"}}],[11,"ge","","",4,{"inputs":[{"name":"self"},{"name":"depnode"}],"output":{"name":"bool"}}],[11,"cmp","","",4,{"inputs":[{"name":"self"},{"name":"depnode"}],"output":{"name":"ordering"}}],[11,"hash","","",4,null],[11,"encode","","",4,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",4,{"inputs":[{"name":"__d"}],"output":{"generics":["depnode"],"name":"result"}}],[11,"new","","",4,{"inputs":[{"name":"tyctxt"},{"name":"depconstructor"}],"output":{"name":"depnode"}}],[11,"from_def_path_hash","","Construct a DepNode from the given DepKind and DefPathHash. This method will assert that the given DepKind actually requires a single DefId/DefPathHash parameter.",4,{"inputs":[{"name":"depkind"},{"name":"defpathhash"}],"output":{"name":"depnode"}}],[11,"new_no_params","","Create a new, parameterless DepNode. This method will assert that the DepNode corresponding to the given DepKind actually does not require any parameters.",4,{"inputs":[{"name":"depkind"}],"output":{"name":"depnode"}}],[11,"extract_def_id","","Extract the DefId corresponding to this DepNode. This will work if two conditions are met:",4,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"generics":["defid"],"name":"option"}}],[11,"from_label_string","","Used in testing",4,{"inputs":[{"name":"str"},{"name":"defpathhash"}],"output":{"generics":["depnode"],"name":"result"}}],[11,"has_label_string","","Used in testing",4,{"inputs":[{"name":"str"}],"output":{"name":"bool"}}],[11,"clone","","",15,{"inputs":[{"name":"self"}],"output":{"name":"workproductid"}}],[11,"fmt","","",15,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",15,{"inputs":[{"name":"self"},{"name":"workproductid"}],"output":{"name":"bool"}}],[11,"ne","","",15,{"inputs":[{"name":"self"},{"name":"workproductid"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",15,{"inputs":[{"name":"self"},{"name":"workproductid"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",15,{"inputs":[{"name":"self"},{"name":"workproductid"}],"output":{"name":"bool"}}],[11,"le","","",15,{"inputs":[{"name":"self"},{"name":"workproductid"}],"output":{"name":"bool"}}],[11,"gt","","",15,{"inputs":[{"name":"self"},{"name":"workproductid"}],"output":{"name":"bool"}}],[11,"ge","","",15,{"inputs":[{"name":"self"},{"name":"workproductid"}],"output":{"name":"bool"}}],[11,"cmp","","",15,{"inputs":[{"name":"self"},{"name":"workproductid"}],"output":{"name":"ordering"}}],[11,"hash","","",15,null],[11,"encode","","",15,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",15,{"inputs":[{"name":"__d"}],"output":{"generics":["workproductid"],"name":"result"}}],[11,"from_cgu_name","","",15,{"inputs":[{"name":"str"}],"output":{"name":"workproductid"}}],[11,"from_fingerprint","","",15,{"inputs":[{"name":"fingerprint"}],"output":{"name":"workproductid"}}],[11,"hash_stable","","",15,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"new","","",16,{"inputs":[{"name":"depgraph"}],"output":{"name":"deptrackingmap"}}],[11,"clone","","",17,{"inputs":[{"name":"self"}],"output":{"name":"depgraph"}}],[11,"clone","","",18,{"inputs":[{"name":"self"}],"output":{"name":"depnodeindex"}}],[11,"eq","","",18,{"inputs":[{"name":"self"},{"name":"depnodeindex"}],"output":{"name":"bool"}}],[11,"ne","","",18,{"inputs":[{"name":"self"},{"name":"depnodeindex"}],"output":{"name":"bool"}}],[11,"hash","","",18,null],[11,"partial_cmp","","",18,{"inputs":[{"name":"self"},{"name":"depnodeindex"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",18,{"inputs":[{"name":"self"},{"name":"depnodeindex"}],"output":{"name":"bool"}}],[11,"le","","",18,{"inputs":[{"name":"self"},{"name":"depnodeindex"}],"output":{"name":"bool"}}],[11,"gt","","",18,{"inputs":[{"name":"self"},{"name":"depnodeindex"}],"output":{"name":"bool"}}],[11,"ge","","",18,{"inputs":[{"name":"self"},{"name":"depnodeindex"}],"output":{"name":"bool"}}],[11,"cmp","","",18,{"inputs":[{"name":"self"},{"name":"depnodeindex"}],"output":{"name":"ordering"}}],[11,"decode","","",18,{"inputs":[{"name":"__d"}],"output":{"generics":["depnodeindex"],"name":"result"}}],[11,"encode","","",18,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"new","","",18,{"inputs":[{"name":"usize"}],"output":{"name":"self"}}],[11,"index","","",18,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"fmt","","",18,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",11,{"inputs":[{"name":"self"}],"output":{"name":"depnodecolor"}}],[11,"fmt","","",11,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",11,{"inputs":[{"name":"self"},{"name":"depnodecolor"}],"output":{"name":"bool"}}],[11,"ne","","",11,{"inputs":[{"name":"self"},{"name":"depnodecolor"}],"output":{"name":"bool"}}],[11,"hash","","",11,null],[11,"is_green","","",11,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"new","","",17,{"inputs":[{"name":"previousdepgraph"}],"output":{"name":"depgraph"}}],[11,"new_disabled","","",17,{"inputs":[],"output":{"name":"depgraph"}}],[11,"is_fully_enabled","","True if we are actually building the full dep-graph.",17,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"query","","",17,{"inputs":[{"name":"self"}],"output":{"name":"depgraphquery"}}],[11,"assert_ignored","","",17,{"inputs":[{"name":"self"}],"output":null}],[11,"with_ignore","","",17,{"inputs":[{"name":"self"},{"name":"op"}],"output":{"name":"r"}}],[11,"with_task","","Starts a new dep-graph task. Dep-graph tasks are specified using a free function (`task`) and not a closure -- this is intentional because we want to exercise tight control over what state they have access to. In particular, we want to prevent implicit 'leaks' of tracked state into the task (which could then be read without generating correct edges in the dep-graph -- see the [rustc guide] for more details on the dep-graph). To this end, the task function gets exactly two pieces of state: the context `cx` and an argument `arg`. Both of these bits of state must be of some type that implements `DepGraphSafe` and hence does not leak.",17,null],[11,"with_anon_task","","Execute something within an \"anonymous\" task, that is, a task the DepNode of which is determined by the list of inputs it read from.",17,null],[11,"with_eval_always_task","","Execute something within an \"eval-always\" task which is a task",17,null],[11,"read","","",17,{"inputs":[{"name":"self"},{"name":"depnode"}],"output":null}],[11,"read_index","","",17,{"inputs":[{"name":"self"},{"name":"depnodeindex"}],"output":null}],[11,"dep_node_index_of","","",17,{"inputs":[{"name":"self"},{"name":"depnode"}],"output":{"name":"depnodeindex"}}],[11,"dep_node_exists","","",17,{"inputs":[{"name":"self"},{"name":"depnode"}],"output":{"name":"bool"}}],[11,"fingerprint_of","","",17,{"inputs":[{"name":"self"},{"name":"depnodeindex"}],"output":{"name":"fingerprint"}}],[11,"prev_fingerprint_of","","",17,{"inputs":[{"name":"self"},{"name":"depnode"}],"output":{"generics":["fingerprint"],"name":"option"}}],[11,"prev_dep_node_index_of","","",17,{"inputs":[{"name":"self"},{"name":"depnode"}],"output":{"name":"serializeddepnodeindex"}}],[11,"insert_previous_work_product","","Indicates that a previous work product exists for `v`. This is invoked during initial start-up based on what nodes are clean (and what files exist in the incr. directory).",17,{"inputs":[{"name":"self"},{"name":"workproductid"},{"name":"workproduct"}],"output":null}],[11,"insert_work_product","","Indicates that we created the given work-product in this run for `v`. This record will be preserved and loaded in the next run.",17,{"inputs":[{"name":"self"},{"name":"workproductid"},{"name":"workproduct"}],"output":null}],[11,"previous_work_product","","Check whether a previous work product exists for `v` and, if so, return the path that leads to it. Used to skip doing work.",17,{"inputs":[{"name":"self"},{"name":"workproductid"}],"output":{"generics":["workproduct"],"name":"option"}}],[11,"work_products","","Access the map of work-products created during this run. Only used during saving of the dep-graph.",17,{"inputs":[{"name":"self"}],"output":{"generics":["fxhashmap"],"name":"ref"}}],[11,"previous_work_products","","Access the map of work-products created during the cached run. Only used during saving of the dep-graph.",17,{"inputs":[{"name":"self"}],"output":{"generics":["fxhashmap"],"name":"ref"}}],[11,"register_dep_node_debug_str","","",17,{"inputs":[{"name":"self"},{"name":"depnode"},{"name":"f"}],"output":null}],[11,"edge_deduplication_data","","",17,null],[11,"serialize","","",17,{"inputs":[{"name":"self"}],"output":{"name":"serializeddepgraph"}}],[11,"node_color","","",17,{"inputs":[{"name":"self"},{"name":"depnode"}],"output":{"generics":["depnodecolor"],"name":"option"}}],[11,"try_mark_green","","",17,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"depnode"}],"output":{"generics":["depnodeindex"],"name":"option"}}],[11,"is_green","","",17,{"inputs":[{"name":"self"},{"name":"depnode"}],"output":{"name":"bool"}}],[11,"exec_cache_promotions","","",17,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":null}],[11,"mark_loaded_from_cache","","",17,{"inputs":[{"name":"self"},{"name":"depnodeindex"},{"name":"bool"}],"output":null}],[11,"was_loaded_from_cache","","",17,{"inputs":[{"name":"self"},{"name":"depnode"}],"output":{"generics":["bool"],"name":"option"}}],[11,"clone","","",5,{"inputs":[{"name":"self"}],"output":{"name":"workproduct"}}],[11,"fmt","","",5,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",5,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",5,{"inputs":[{"name":"__d"}],"output":{"generics":["workproduct"],"name":"result"}}],[11,"clone","","",12,{"inputs":[{"name":"self"}],"output":{"name":"workproductfilekind"}}],[11,"fmt","","",12,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",12,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",12,{"inputs":[{"name":"__d"}],"output":{"generics":["workproductfilekind"],"name":"result"}}],[11,"fmt","","",19,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",19,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",19,{"inputs":[{"name":"__d"}],"output":{"generics":["previousdepgraph"],"name":"result"}}],[11,"new","","",19,{"inputs":[{"name":"serializeddepgraph"}],"output":{"name":"previousdepgraph"}}],[11,"edges_from","","",19,{"inputs":[{"name":"self"},{"name":"depnode"}],"output":{"name":"option"}}],[11,"index_to_node","","",19,{"inputs":[{"name":"self"},{"name":"serializeddepnodeindex"}],"output":{"name":"depnode"}}],[11,"node_to_index","","",19,{"inputs":[{"name":"self"},{"name":"depnode"}],"output":{"name":"serializeddepnodeindex"}}],[11,"node_to_index_opt","","",19,{"inputs":[{"name":"self"},{"name":"depnode"}],"output":{"generics":["serializeddepnodeindex"],"name":"option"}}],[11,"fingerprint_of","","",19,{"inputs":[{"name":"self"},{"name":"depnode"}],"output":{"generics":["fingerprint"],"name":"option"}}],[11,"fingerprint_by_index","","",19,{"inputs":[{"name":"self"},{"name":"serializeddepnodeindex"}],"output":{"name":"fingerprint"}}],[11,"node_count","","",19,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"new","","",6,null],[11,"contains_node","","",6,{"inputs":[{"name":"self"},{"name":"depnode"}],"output":{"name":"bool"}}],[11,"nodes","","",6,{"inputs":[{"name":"self"}],"output":{"generics":["depnode"],"name":"vec"}}],[11,"edges","","",6,{"inputs":[{"name":"self"}],"output":{"name":"vec"}}],[11,"transitive_successors","","All nodes reachable from `node`. In other words, things that will have to be recomputed if `node` changes.",6,{"inputs":[{"name":"self"},{"name":"depnode"}],"output":{"generics":["depnode"],"name":"vec"}}],[11,"transitive_predecessors","","All nodes that can reach `node`.",6,{"inputs":[{"name":"self"},{"name":"depnode"}],"output":{"generics":["depnode"],"name":"vec"}}],[11,"immediate_successors","","Just the outgoing edges from `node`.",6,{"inputs":[{"name":"self"},{"name":"depnode"}],"output":{"generics":["depnode"],"name":"vec"}}],[11,"clone","","",20,{"inputs":[{"name":"self"}],"output":{"name":"serializeddepnodeindex"}}],[11,"eq","","",20,{"inputs":[{"name":"self"},{"name":"serializeddepnodeindex"}],"output":{"name":"bool"}}],[11,"ne","","",20,{"inputs":[{"name":"self"},{"name":"serializeddepnodeindex"}],"output":{"name":"bool"}}],[11,"hash","","",20,null],[11,"partial_cmp","","",20,{"inputs":[{"name":"self"},{"name":"serializeddepnodeindex"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",20,{"inputs":[{"name":"self"},{"name":"serializeddepnodeindex"}],"output":{"name":"bool"}}],[11,"le","","",20,{"inputs":[{"name":"self"},{"name":"serializeddepnodeindex"}],"output":{"name":"bool"}}],[11,"gt","","",20,{"inputs":[{"name":"self"},{"name":"serializeddepnodeindex"}],"output":{"name":"bool"}}],[11,"ge","","",20,{"inputs":[{"name":"self"},{"name":"serializeddepnodeindex"}],"output":{"name":"bool"}}],[11,"cmp","","",20,{"inputs":[{"name":"self"},{"name":"serializeddepnodeindex"}],"output":{"name":"ordering"}}],[11,"decode","","",20,{"inputs":[{"name":"__d"}],"output":{"generics":["serializeddepnodeindex"],"name":"result"}}],[11,"encode","","",20,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"new","","",20,{"inputs":[{"name":"usize"}],"output":{"name":"self"}}],[11,"index","","",20,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"fmt","","",20,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",8,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",8,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",8,{"inputs":[{"name":"__d"}],"output":{"generics":["serializeddepgraph"],"name":"result"}}],[11,"new","","",8,{"inputs":[],"output":{"name":"serializeddepgraph"}}],[11,"edge_targets_from","","",8,null],[0,"label_strs","","Contains variant => str representations for constructing DepNode groups for tests.",null,null],[17,"Null","rustc::dep_graph::label_strs","",null,null],[17,"Krate","","",null,null],[17,"HirBody","","",null,null],[17,"Hir","","",null,null],[17,"CrateMetadata","","",null,null],[17,"RegionScopeTree","","",null,null],[17,"Coherence","","",null,null],[17,"CoherenceInherentImplOverlapCheck","","",null,null],[17,"CoherenceCheckTrait","","",null,null],[17,"PrivacyAccessLevels","","",null,null],[17,"MirConstQualif","","",null,null],[17,"MirBuilt","","",null,null],[17,"MirConst","","",null,null],[17,"MirValidated","","",null,null],[17,"MirOptimized","","",null,null],[17,"MirShim","","",null,null],[17,"BorrowCheckKrate","","",null,null],[17,"BorrowCheck","","",null,null],[17,"MirBorrowCheck","","",null,null],[17,"UnsafetyCheckResult","","",null,null],[17,"UnsafeDeriveOnReprPacked","","",null,null],[17,"Reachability","","",null,null],[17,"MirKeys","","",null,null],[17,"CrateVariances","","",null,null],[17,"AssociatedItems","","",null,null],[17,"TypeOfItem","","",null,null],[17,"GenericsOfItem","","",null,null],[17,"PredicatesOfItem","","",null,null],[17,"InferredOutlivesOf","","",null,null],[17,"SuperPredicatesOfItem","","",null,null],[17,"TraitDefOfItem","","",null,null],[17,"AdtDefOfItem","","",null,null],[17,"ImplTraitRef","","",null,null],[17,"ImplPolarity","","",null,null],[17,"FnSignature","","",null,null],[17,"CoerceUnsizedInfo","","",null,null],[17,"ItemVarianceConstraints","","",null,null],[17,"ItemVariances","","",null,null],[17,"IsConstFn","","",null,null],[17,"IsForeignItem","","",null,null],[17,"TypeParamPredicates","","",null,null],[17,"SizedConstraint","","",null,null],[17,"DtorckConstraint","","",null,null],[17,"AdtDestructor","","",null,null],[17,"AssociatedItemDefIds","","",null,null],[17,"InherentImpls","","",null,null],[17,"TypeckBodiesKrate","","",null,null],[17,"TypeckTables","","",null,null],[17,"UsedTraitImports","","",null,null],[17,"HasTypeckTables","","",null,null],[17,"ConstEval","","",null,null],[17,"CheckMatch","","",null,null],[17,"SymbolName","","",null,null],[17,"InstanceSymbolName","","",null,null],[17,"SpecializationGraph","","",null,null],[17,"ObjectSafety","","",null,null],[17,"FulfillObligation","","",null,null],[17,"VtableMethods","","",null,null],[17,"IsCopy","","",null,null],[17,"IsSized","","",null,null],[17,"IsFreeze","","",null,null],[17,"NeedsDrop","","",null,null],[17,"Layout","","",null,null],[17,"TraitImpls","","",null,null],[17,"AllLocalTraitImpls","","",null,null],[17,"TraitSelect","","",null,null],[17,"ParamEnv","","",null,null],[17,"DescribeDef","","",null,null],[17,"DefSpan","","",null,null],[17,"LookupStability","","",null,null],[17,"LookupDeprecationEntry","","",null,null],[17,"ItemBodyNestedBodies","","",null,null],[17,"ConstIsRvaluePromotableToStatic","","",null,null],[17,"RvaluePromotableMap","","",null,null],[17,"ImplParent","","",null,null],[17,"TraitOfItem","","",null,null],[17,"IsReachableNonGeneric","","",null,null],[17,"IsMirAvailable","","",null,null],[17,"ItemAttrs","","",null,null],[17,"TransFnAttrs","","",null,null],[17,"FnArgNames","","",null,null],[17,"DylibDepFormats","","",null,null],[17,"IsPanicRuntime","","",null,null],[17,"IsCompilerBuiltins","","",null,null],[17,"HasGlobalAllocator","","",null,null],[17,"ExternCrate","","",null,null],[17,"LintLevels","","",null,null],[17,"Specializes","","",null,null],[17,"InScopeTraits","","",null,null],[17,"ModuleExports","","",null,null],[17,"IsSanitizerRuntime","","",null,null],[17,"IsProfilerRuntime","","",null,null],[17,"GetPanicStrategy","","",null,null],[17,"IsNoBuiltins","","",null,null],[17,"ImplDefaultness","","",null,null],[17,"CheckItemWellFormed","","",null,null],[17,"CheckTraitItemWellFormed","","",null,null],[17,"CheckImplItemWellFormed","","",null,null],[17,"ReachableNonGenerics","","",null,null],[17,"NativeLibraries","","",null,null],[17,"PluginRegistrarFn","","",null,null],[17,"DeriveRegistrarFn","","",null,null],[17,"CrateDisambiguator","","",null,null],[17,"CrateHash","","",null,null],[17,"OriginalCrateName","","",null,null],[17,"ImplementationsOfTrait","","",null,null],[17,"AllTraitImplementations","","",null,null],[17,"DllimportForeignItems","","",null,null],[17,"IsDllimportForeignItem","","",null,null],[17,"IsStaticallyIncludedForeignItem","","",null,null],[17,"NativeLibraryKind","","",null,null],[17,"LinkArgs","","",null,null],[17,"ResolveLifetimes","","",null,null],[17,"NamedRegion","","",null,null],[17,"IsLateBound","","",null,null],[17,"ObjectLifetimeDefaults","","",null,null],[17,"Visibility","","",null,null],[17,"DepKind","","",null,null],[17,"CrateName","","",null,null],[17,"ItemChildren","","",null,null],[17,"ExternModStmtCnum","","",null,null],[17,"GetLangItems","","",null,null],[17,"DefinedLangItems","","",null,null],[17,"MissingLangItems","","",null,null],[17,"ExternConstBody","","",null,null],[17,"VisibleParentMap","","",null,null],[17,"MissingExternCrateItem","","",null,null],[17,"UsedCrateSource","","",null,null],[17,"PostorderCnums","","",null,null],[17,"EraseRegionsTy","","",null,null],[17,"Freevars","","",null,null],[17,"MaybeUnusedTraitImport","","",null,null],[17,"MaybeUnusedExternCrates","","",null,null],[17,"StabilityIndex","","",null,null],[17,"AllCrateNums","","",null,null],[17,"ExportedSymbols","","",null,null],[17,"CollectAndPartitionTranslationItems","","",null,null],[17,"IsTranslatedItem","","",null,null],[17,"CodegenUnit","","",null,null],[17,"CompileCodegenUnit","","",null,null],[17,"OutputFilenames","","",null,null],[17,"NormalizeProjectionTy","","",null,null],[17,"NormalizeTyAfterErasingRegions","","",null,null],[17,"DropckOutlives","","",null,null],[17,"SubstituteNormalizeAndTestPredicates","","",null,null],[17,"TargetFeaturesWhitelist","","",null,null],[17,"InstanceDefSizeEstimate","","",null,null],[17,"GetSymbolExportLevel","","",null,null],[17,"WasmCustomSections","","",null,null],[17,"Features","","",null,null],[17,"ProgramClausesFor","","",null,null],[17,"WasmImportModuleMap","","",null,null],[17,"ForeignModules","","",null,null],[8,"DepTrackingMapConfig","rustc::dep_graph","",null,null],[16,"Key","","",21,null],[16,"Value","","",21,null],[10,"to_dep_kind","","",21,{"inputs":[],"output":{"name":"depkind"}}],[8,"DepGraphSafe","","The `DepGraphSafe` trait is used to specify what kinds of values are safe to \"leak\" into a task. The idea is that this should be only be implemented for things like the tcx as well as various id types, which will create reads in the dep-graph whenever the trait loads anything that might depend on the input program.",null,null],[0,"hir","rustc","",null,null],[3,"HirId","rustc::hir","A HirId uniquely identifies a node in the HIR of the current crate. It is composed of the `owner`, which is the DefIndex of the directly enclosing hir::Item, hir::TraitItem, or hir::ImplItem (i.e. the closest \"item-like\"), and the `local_id` which is unique within the given owner.",null,null],[12,"owner","","",22,null],[12,"local_id","","",22,null],[3,"ItemLocalId","","An `ItemLocalId` uniquely identifies something within a given \"item-like\", that is within a hir::Item, hir::TraitItem, or hir::ImplItem. There is no guarantee that the numerical value of a given `ItemLocalId` corresponds to the node's position within the owning item in any way, but there is a guarantee that the `LocalItemId`s within an owner occupy a dense range of integers starting at zero, so a mapping that maps all or most nodes within an \"item-like\" to something else can be implement by a `Vec` instead of a tree or hash map.",null,null],[12,"0","","",23,null],[3,"Label","","",null,null],[12,"name","","",24,null],[12,"span","","",24,null],[3,"Lifetime","","",null,null],[12,"id","","",25,null],[12,"span","","",25,null],[12,"name","","Either \"'a\", referring to a named lifetime definition, or \"\" (aka keywords::Invalid), for elision placeholders.",25,null],[3,"LifetimeDef","","A lifetime definition, eg `'a: 'b+'c+'d`",null,null],[12,"lifetime","","",26,null],[12,"bounds","","",26,null],[12,"pure_wrt_drop","","",26,null],[12,"in_band","","",26,null],[3,"Path","","A \"Path\" is essentially Rust's notion of a name; for instance: `std::cmp::PartialEq`. It's represented as a sequence of identifiers, along with a bunch of supporting information.",null,null],[12,"span","","",27,null],[12,"def","","The definition that the path resolved to.",27,null],[12,"segments","","The segments in the path: the things separated by `::`.",27,null],[3,"PathSegment","","A segment of a path: an identifier, an optional lifetime, and a set of types.",null,null],[12,"name","","The identifier portion of this path segment.",28,null],[12,"parameters","","Type/lifetime parameters attached to this path. They come in two flavors: `Path<A,B,C>` and `Path(A,B) -> C`. Note that this is more than just simple syntactic sugar; the use of parens affects the region binding rules, so we preserve the distinction.",28,null],[12,"infer_types","","Whether to infer remaining type parameters, if any. This only applies to expression and pattern paths, and out of those only the segments with no type parameters to begin with, e.g. `Vec::new` is `<Vec<..>>::new::<..>`.",28,null],[3,"PathParameters","","",null,null],[12,"lifetimes","","The lifetime parameters for this path segment.",29,null],[12,"types","","The type parameters for this path segment, if present.",29,null],[12,"bindings","","Bindings (equality constraints) on associated types, if present. E.g., `Foo<A=Bar>`.",29,null],[12,"parenthesized","","Were parameters written in parenthesized form `Fn(T) -> U`? This is required mostly for pretty-printing and diagnostics, but also for changing lifetime elision rules to be \"function-like\".",29,null],[3,"TyParam","","",null,null],[12,"name","","",30,null],[12,"id","","",30,null],[12,"bounds","","",30,null],[12,"default","","",30,null],[12,"span","","",30,null],[12,"pure_wrt_drop","","",30,null],[12,"synthetic","","",30,null],[12,"attrs","","",30,null],[3,"Generics","","Represents lifetimes and type parameters attached to a declaration of a function, enum, trait, etc.",null,null],[12,"params","","",31,null],[12,"where_clause","","",31,null],[12,"span","","",31,null],[3,"WhereClause","","A `where` clause in a definition",null,null],[12,"id","","",32,null],[12,"predicates","","",32,null],[3,"WhereBoundPredicate","","A type bound, eg `for<'c> Foo: Send+Clone+'c`",null,null],[12,"span","","",33,null],[12,"bound_generic_params","","Any generics from a `for` binding",33,null],[12,"bounded_ty","","The type being bounded",33,null],[12,"bounds","","Trait and lifetime bounds (`Clone+Send+'static`)",33,null],[3,"WhereRegionPredicate","","A lifetime predicate, e.g. `'a: 'b+'c`",null,null],[12,"span","","",34,null],[12,"lifetime","","",34,null],[12,"bounds","","",34,null],[3,"WhereEqPredicate","","An equality predicate (unsupported), e.g. `T=int`",null,null],[12,"id","","",35,null],[12,"span","","",35,null],[12,"lhs_ty","","",35,null],[12,"rhs_ty","","",35,null],[3,"Crate","","The top-level data structure that stores the entire contents of the crate currently being compiled.",null,null],[12,"module","","",36,null],[12,"attrs","","",36,null],[12,"span","","",36,null],[12,"exported_macros","","",36,null],[12,"items","","",36,null],[12,"trait_items","","",36,null],[12,"impl_items","","",36,null],[12,"bodies","","",36,null],[12,"trait_impls","","",36,null],[12,"trait_auto_impl","","",36,null],[12,"body_ids","","A list of the body ids written out in the order in which they appear in the crate. If you're going to process all the bodies in the crate, you should iterate over this list rather than the keys of bodies.",36,null],[3,"MacroDef","","A macro definition, in this crate or imported from another.",null,null],[12,"name","","",37,null],[12,"vis","","",37,null],[12,"attrs","","",37,null],[12,"id","","",37,null],[12,"span","","",37,null],[12,"body","","",37,null],[12,"legacy","","",37,null],[3,"Block","","",null,null],[12,"stmts","","Statements in a block",38,null],[12,"expr","","An expression at the end of the block without a semicolon, if any",38,null],[12,"id","","",38,null],[12,"hir_id","","",38,null],[12,"rules","","Distinguishes between `unsafe { ... }` and `{ ... }`",38,null],[12,"span","","",38,null],[12,"targeted_by_break","","If true, then there may exist `break 'a` values that aim to break out of this block early. As of this writing, this is not currently permitted in Rust itself, but it is generated as part of `catch` statements.",38,null],[12,"recovered","","If true, don't emit return value type errors as the parser had to recover from a parse error so this block will not have an appropriate type. A parse error will have been emitted so the compilation will never succeed if this is true.",38,null],[3,"Pat","","",null,null],[12,"id","","",39,null],[12,"hir_id","","",39,null],[12,"node","","",39,null],[12,"span","","",39,null],[3,"FieldPat","","A single field in a struct pattern",null,null],[12,"name","","The identifier for the field",40,null],[12,"pat","","The pattern the field is destructured to",40,null],[12,"is_shorthand","","",40,null],[3,"Local","","Local represents a `let` statement, e.g., `let <pat>:<ty> = <expr>;`",null,null],[12,"pat","","",41,null],[12,"ty","","",41,null],[12,"init","","Initializer expression to set the value, if any",41,null],[12,"id","","",41,null],[12,"hir_id","","",41,null],[12,"span","","",41,null],[12,"attrs","","",41,null],[12,"source","","",41,null],[3,"Arm","","represents one arm of a 'match'",null,null],[12,"attrs","","",42,null],[12,"pats","","",42,null],[12,"guard","","",42,null],[12,"body","","",42,null],[3,"Field","","",null,null],[12,"name","","",43,null],[12,"expr","","",43,null],[12,"span","","",43,null],[12,"is_shorthand","","",43,null],[3,"BodyId","","",null,null],[12,"node_id","","",44,null],[3,"Body","","The body of a function, closure, or constant value. In the case of a function, the body contains not only the function body itself (which is an expression), but also the argument patterns, since those are something that the caller doesn't really care about.",null,null],[12,"arguments","","",45,null],[12,"value","","",45,null],[12,"is_generator","","",45,null],[3,"Expr","","An expression",null,null],[12,"id","","",46,null],[12,"span","","",46,null],[12,"node","","",46,null],[12,"attrs","","",46,null],[12,"hir_id","","",46,null],[3,"Destination","","",null,null],[12,"label","","",47,null],[12,"target_id","","",47,null],[3,"MutTy","","",null,null],[12,"ty","","",48,null],[12,"mutbl","","",48,null],[3,"MethodSig","","Represents a method's signature in a trait declaration or implementation.",null,null],[12,"unsafety","","",49,null],[12,"constness","","",49,null],[12,"abi","","",49,null],[12,"decl","","",49,null],[3,"TraitItemId","","",null,null],[12,"node_id","","",50,null],[3,"TraitItem","","Represents an item declaration within a trait declaration, possibly including a default implementation. A trait item is either required (meaning it doesn't have an implementation, just a signature) or provided (meaning it has a default implementation).",null,null],[12,"id","","",51,null],[12,"name","","",51,null],[12,"hir_id","","",51,null],[12,"attrs","","",51,null],[12,"generics","","",51,null],[12,"node","","",51,null],[12,"span","","",51,null],[3,"ImplItemId","","",null,null],[12,"node_id","","",52,null],[3,"ImplItem","","Represents anything within an `impl` block",null,null],[12,"id","","",53,null],[12,"name","","",53,null],[12,"hir_id","","",53,null],[12,"vis","","",53,null],[12,"defaultness","","",53,null],[12,"attrs","","",53,null],[12,"generics","","",53,null],[12,"node","","",53,null],[12,"span","","",53,null],[3,"TypeBinding","","",null,null],[12,"id","","",54,null],[12,"name","","",54,null],[12,"ty","","",54,null],[12,"span","","",54,null],[3,"Ty","","",null,null],[12,"id","","",55,null],[12,"node","","",55,null],[12,"span","","",55,null],[12,"hir_id","","",55,null],[3,"BareFnTy","","",null,null],[12,"unsafety","","",56,null],[12,"abi","","",56,null],[12,"generic_params","","",56,null],[12,"decl","","",56,null],[12,"arg_names","","",56,null],[3,"ExistTy","","",null,null],[12,"generics","","",57,null],[12,"bounds","","",57,null],[3,"InlineAsmOutput","","",null,null],[12,"constraint","","",58,null],[12,"is_rw","","",58,null],[12,"is_indirect","","",58,null],[3,"InlineAsm","","",null,null],[12,"asm","","",59,null],[12,"asm_str_style","","",59,null],[12,"outputs","","",59,null],[12,"inputs","","",59,null],[12,"clobbers","","",59,null],[12,"volatile","","",59,null],[12,"alignstack","","",59,null],[12,"dialect","","",59,null],[12,"ctxt","","",59,null],[3,"Arg","","represents an argument in a function header",null,null],[12,"pat","","",60,null],[12,"id","","",60,null],[12,"hir_id","","",60,null],[3,"FnDecl","","Represents the header (not the body) of a function declaration",null,null],[12,"inputs","","",61,null],[12,"output","","",61,null],[12,"variadic","","",61,null],[12,"has_implicit_self","","True if this function has an `self`, `&self` or `&mut self` receiver (but not a `self: Xxx` one).",61,null],[3,"Mod","","",null,null],[12,"inner","","A span from the first token past `{` to the last token until `}`. For `mod foo;`, the inner span ranges from the first token to the last token in the external file.",62,null],[12,"item_ids","","",62,null],[3,"ForeignMod","","",null,null],[12,"abi","","",63,null],[12,"items","","",63,null],[3,"GlobalAsm","","",null,null],[12,"asm","","",64,null],[12,"ctxt","","",64,null],[3,"EnumDef","","",null,null],[12,"variants","","",65,null],[3,"Variant_","","",null,null],[12,"name","","",66,null],[12,"attrs","","",66,null],[12,"data","","",66,null],[12,"disr_expr","","Explicit discriminant, eg `Foo = 1`",66,null],[3,"TraitRef","","TraitRef's appear in impls.",null,null],[12,"path","","",67,null],[12,"ref_id","","",67,null],[3,"PolyTraitRef","","",null,null],[12,"bound_generic_params","","The `'a` in `<'a> Foo<&'a T>`",68,null],[12,"trait_ref","","The `Foo<&'a T>` in `<'a> Foo<&'a T>`",68,null],[12,"span","","",68,null],[3,"StructField","","",null,null],[12,"span","","",69,null],[12,"name","","",69,null],[12,"vis","","",69,null],[12,"id","","",69,null],[12,"ty","","",69,null],[12,"attrs","","",69,null],[3,"ItemId","","",null,null],[12,"id","","",70,null],[3,"Item","","An item",null,null],[12,"name","","",71,null],[12,"id","","",71,null],[12,"hir_id","","",71,null],[12,"attrs","","",71,null],[12,"node","","",71,null],[12,"vis","","",71,null],[12,"span","","",71,null],[3,"TraitItemRef","","A reference from an trait to one of its associated items. This contains the item's id, naturally, but also the item's name and some other high-level details (like whether it is an associated type or method, and whether it is public). This allows other passes to find the impl they want without loading the id (which means fewer edges in the incremental compilation graph).",null,null],[12,"id","","",72,null],[12,"name","","",72,null],[12,"kind","","",72,null],[12,"span","","",72,null],[12,"defaultness","","",72,null],[3,"ImplItemRef","","A reference from an impl to one of its associated items. This contains the item's id, naturally, but also the item's name and some other high-level details (like whether it is an associated type or method, and whether it is public). This allows other passes to find the impl they want without loading the id (which means fewer edges in the incremental compilation graph).",null,null],[12,"id","","",73,null],[12,"name","","",73,null],[12,"kind","","",73,null],[12,"span","","",73,null],[12,"vis","","",73,null],[12,"defaultness","","",73,null],[3,"ForeignItem","","",null,null],[12,"name","","",74,null],[12,"attrs","","",74,null],[12,"node","","",74,null],[12,"id","","",74,null],[12,"span","","",74,null],[12,"vis","","",74,null],[3,"Freevar","","A free variable referred to in a function.",null,null],[12,"def","","The variable being accessed free.",75,null],[12,"span","","",75,null],[3,"TraitCandidate","","",null,null],[12,"def_id","","",76,null],[12,"import_id","","",76,null],[3,"TransFnAttrs","","",null,null],[12,"flags","","",77,null],[12,"inline","","",77,null],[12,"export_name","","",77,null],[12,"target_features","","",77,null],[12,"linkage","","",77,null],[3,"TransFnAttrFlags","","",null,null],[4,"LifetimeName","","",null,null],[13,"Implicit","","User typed nothing. e.g. the lifetime in `&u32`.",78,null],[13,"Underscore","","User typed `'_`.",78,null],[13,"Fresh","","Synthetic name generated when user elided a lifetime in an impl header, e.g. the lifetimes in cases like these:",78,null],[13,"Static","","User wrote `'static`",78,null],[13,"Name","","Some user-given name like `'x`",78,null],[4,"TyParamBound","","The AST represents all type param bounds as types. typeck::collect::compute_bounds matches these against the \"special\" built-in traits (see middle::lang_items) and detects Copy, Send and Sync.",null,null],[13,"TraitTyParamBound","","",79,null],[13,"RegionTyParamBound","","",79,null],[4,"TraitBoundModifier","","A modifier on a bound, currently this is only used for `?Sized`, where the modifier is `Maybe`. Negative bounds should also be handled here.",null,null],[13,"None","","",80,null],[13,"Maybe","","",80,null],[4,"GenericParam","","",null,null],[13,"Lifetime","","",81,null],[13,"Type","","",81,null],[4,"UnsafeGeneric","","",null,null],[13,"Region","","",82,null],[13,"Type","","",82,null],[4,"SyntheticTyParamKind","","Synthetic Type Parameters are converted to an other form during lowering, this allows to track the original form they had. Useful for error messages.",null,null],[13,"ImplTrait","","",83,null],[4,"WherePredicate","","A single predicate in a `where` clause",null,null],[13,"BoundPredicate","","A type binding, eg `for<'c> Foo: Send+Clone+'c`",84,null],[13,"RegionPredicate","","A lifetime predicate, e.g. `'a: 'b+'c`",84,null],[13,"EqPredicate","","An equality predicate (unsupported)",84,null],[4,"BindingAnnotation","","Explicit binding annotations given in the HIR for a binding. Note that this is not the final binding mode that we infer after type inference.",null,null],[13,"Unannotated","","No binding annotation given: this means that the final binding mode will depend on whether we have skipped through a `&` reference when matching. For example, the `x` in `Some(x)` will have binding mode `None`; if you do `let Some(x) = &Some(22)`, it will ultimately be inferred to be by-reference.",85,null],[13,"Mutable","","Annotated with `mut x` -- could be either ref or not, similar to `None`.",85,null],[13,"Ref","","Annotated as `ref`, like `ref x`",85,null],[13,"RefMut","","Annotated as `ref mut x`.",85,null],[4,"RangeEnd","","",null,null],[13,"Included","","",86,null],[13,"Excluded","","",86,null],[4,"PatKind","","",null,null],[13,"Wild","","Represents a wildcard pattern (`_`)",87,null],[13,"Binding","","A fresh binding `ref mut binding @ OPT_SUBPATTERN`. The `NodeId` is the canonical ID for the variable being bound, e.g. in `Ok(x) | Err(x)`, both `x` use the same canonical ID, which is the pattern ID of the first `x`.",87,null],[13,"Struct","","A struct or struct variant pattern, e.g. `Variant {x, y, ..}`. The `bool` is `true` in the presence of a `..`.",87,null],[13,"TupleStruct","","A tuple struct/variant pattern `Variant(x, y, .., z)`. If the `..` pattern fragment is present, then `Option<usize>` denotes its position. 0 <= position <= subpats.len()",87,null],[13,"Path","","A path pattern for an unit struct/variant or a (maybe-associated) constant.",87,null],[13,"Tuple","","A tuple pattern `(a, b)`. If the `..` pattern fragment is present, then `Option<usize>` denotes its position. 0 <= position <= subpats.len()",87,null],[13,"Box","","A `box` pattern",87,null],[13,"Ref","","A reference pattern, e.g. `&mut (a, b)`",87,null],[13,"Lit","","A literal",87,null],[13,"Range","","A range pattern, e.g. `1...2` or `1..2`",87,null],[13,"Slice","","`[a, b, ..i, y, z]` is represented as: `PatKind::Slice(box [a, b], Some(i), box [y, z])`",87,null],[4,"Mutability","","",null,null],[13,"MutMutable","","",88,null],[13,"MutImmutable","","",88,null],[4,"BinOp_","","",null,null],[13,"BiAdd","","The `+` operator (addition)",89,null],[13,"BiSub","","The `-` operator (subtraction)",89,null],[13,"BiMul","","The `*` operator (multiplication)",89,null],[13,"BiDiv","","The `/` operator (division)",89,null],[13,"BiRem","","The `%` operator (modulus)",89,null],[13,"BiAnd","","The `&&` operator (logical and)",89,null],[13,"BiOr","","The `||` operator (logical or)",89,null],[13,"BiBitXor","","The `^` operator (bitwise xor)",89,null],[13,"BiBitAnd","","The `&` operator (bitwise and)",89,null],[13,"BiBitOr","","The `|` operator (bitwise or)",89,null],[13,"BiShl","","The `<<` operator (shift left)",89,null],[13,"BiShr","","The `>>` operator (shift right)",89,null],[13,"BiEq","","The `==` operator (equality)",89,null],[13,"BiLt","","The `<` operator (less than)",89,null],[13,"BiLe","","The `<=` operator (less than or equal to)",89,null],[13,"BiNe","","The `!=` operator (not equal to)",89,null],[13,"BiGe","","The `>=` operator (greater than or equal to)",89,null],[13,"BiGt","","The `>` operator (greater than)",89,null],[4,"UnOp","","",null,null],[13,"UnDeref","","The `*` operator for dereferencing",90,null],[13,"UnNot","","The `!` operator for logical inversion",90,null],[13,"UnNeg","","The `-` operator for negation",90,null],[4,"Stmt_","","",null,null],[13,"StmtDecl","","Could be an item or a local (let) binding:",91,null],[13,"StmtExpr","","Expr without trailing semi-colon (must have unit type):",91,null],[13,"StmtSemi","","Expr with trailing semi-colon (may have any type):",91,null],[4,"Decl_","","",null,null],[13,"DeclLocal","","A local (let) binding:",92,null],[13,"DeclItem","","An item binding:",92,null],[4,"BlockCheckMode","","",null,null],[13,"DefaultBlock","","",93,null],[13,"UnsafeBlock","","",93,null],[13,"PushUnsafeBlock","","",93,null],[13,"PopUnsafeBlock","","",93,null],[4,"UnsafeSource","","",null,null],[13,"CompilerGenerated","","",94,null],[13,"UserProvided","","",94,null],[4,"BodyOwnerKind","","",null,null],[13,"Fn","","Functions and methods.",95,null],[13,"Const","","Constants and associated constants.",95,null],[13,"Static","","Initializer of a `static` item.",95,null],[4,"Expr_","","",null,null],[13,"ExprBox","","A `box x` expression.",96,null],[13,"ExprArray","","An array (`[a, b, c, d]`)",96,null],[13,"ExprCall","","A function call",96,null],[13,"ExprMethodCall","","A method call (`x.foo::<'static, Bar, Baz>(a, b, c, d)`)",96,null],[13,"ExprTup","","A tuple (`(a, b, c ,d)`)",96,null],[13,"ExprBinary","","A binary operation (For example: `a + b`, `a * b`)",96,null],[13,"ExprUnary","","A unary operation (For example: `!x`, `*x`)",96,null],[13,"ExprLit","","A literal (For example: `1`, `\"foo\"`)",96,null],[13,"ExprCast","","A cast (`foo as f64`)",96,null],[13,"ExprType","","",96,null],[13,"ExprIf","","An `if` block, with an optional else block",96,null],[13,"ExprWhile","","A while loop, with an optional label",96,null],[13,"ExprLoop","","Conditionless loop (can be exited with break, continue, or return)",96,null],[13,"ExprMatch","","A `match` block, with a source that indicates whether or not it is the result of a desugaring, and if so, which kind.",96,null],[13,"ExprClosure","","A closure (for example, `move |a, b, c| {a + b + c}`).",96,null],[13,"ExprBlock","","A block (`{ ... }`)",96,null],[13,"ExprAssign","","An assignment (`a = foo()`)",96,null],[13,"ExprAssignOp","","An assignment with an operator",96,null],[13,"ExprField","","Access of a named struct field (`obj.foo`)",96,null],[13,"ExprTupField","","Access of an unnamed field of a struct or tuple-struct",96,null],[13,"ExprIndex","","An indexing operation (`foo[2]`)",96,null],[13,"ExprPath","","Path to a definition, possibly containing lifetime or type parameters.",96,null],[13,"ExprAddrOf","","A referencing operation (`&a` or `&mut a`)",96,null],[13,"ExprBreak","","A `break`, with an optional label to break",96,null],[13,"ExprAgain","","A `continue`, with an optional label",96,null],[13,"ExprRet","","A `return`, with an optional value to be returned",96,null],[13,"ExprInlineAsm","","Inline assembly (from `asm!`), with its outputs and inputs.",96,null],[13,"ExprStruct","","A struct or struct-like variant literal expression.",96,null],[13,"ExprRepeat","","An array literal constructed from one repeated element.",96,null],[13,"ExprYield","","A suspension point for generators. This is `yield <expr>` in Rust.",96,null],[4,"QPath","","Optionally `Self`-qualified value/type path or associated extension.",null,null],[13,"Resolved","","Path to a definition, optionally \"fully-qualified\" with a `Self` type, if the path points to an associated item in a trait.",97,null],[13,"TypeRelative","","Type-related paths, e.g. `<T>::default` or `<T>::Output`. Will be resolved by type-checking to an associated item.",97,null],[4,"LocalSource","","Hints at the original code for a let statement",null,null],[13,"Normal","","A `match _ { .. }`",98,null],[13,"ForLoopDesugar","","A desugared `for _ in _ { .. }` loop",98,null],[4,"MatchSource","","Hints at the original code for a `match _ { .. }`",null,null],[13,"Normal","","A `match _ { .. }`",99,null],[13,"IfLetDesugar","","An `if let _ = _ { .. }` (optionally with `else { .. }`)",99,null],[12,"contains_else_clause","rustc::hir::MatchSource","",99,null],[13,"WhileLetDesugar","rustc::hir","A `while let _ = _ { .. }` (which was desugared to a `loop { match _ { .. } }`)",99,null],[13,"ForLoopDesugar","","A desugared `for _ in _ { .. }` loop",99,null],[13,"TryDesugar","","A desugared `?` operator",99,null],[4,"LoopSource","","The loop type that yielded an ExprLoop",null,null],[13,"Loop","","A `loop { .. }` loop",100,null],[13,"WhileLet","","A `while let _ = _ { .. }` loop",100,null],[13,"ForLoop","","A `for _ in _ { .. }` loop",100,null],[4,"LoopIdError","","",null,null],[13,"OutsideLoopScope","","",101,null],[13,"UnlabeledCfInWhileCondition","","",101,null],[13,"UnresolvedLabel","","",101,null],[4,"LoopIdResult","","",null,null],[13,"Ok","","",102,null],[13,"Err","","",102,null],[4,"ScopeTarget","","",null,null],[13,"Block","","",103,null],[13,"Loop","","",103,null],[4,"GeneratorMovability","","",null,null],[13,"Static","","",104,null],[13,"Movable","","",104,null],[4,"CaptureClause","","",null,null],[13,"CaptureByValue","","",105,null],[13,"CaptureByRef","","",105,null],[4,"TraitMethod","","A trait method's body (or just argument names).",null,null],[13,"Required","","No default body in the trait, just a signature.",106,null],[13,"Provided","","Both signature and body are provided in the trait.",106,null],[4,"TraitItemKind","","Represents a trait method or associated constant or type",null,null],[13,"Const","","An associated constant with an optional value (otherwise `impl`s must contain a value)",107,null],[13,"Method","","A method with an optional body",107,null],[13,"Type","","An associated type with (possibly empty) bounds and optional concrete type",107,null],[4,"ImplItemKind","","Represents different contents within `impl`s",null,null],[13,"Const","","An associated constant of the given type, set to the constant result of the expression",108,null],[13,"Method","","A method implementation with the given signature and body",108,null],[13,"Type","","An associated type",108,null],[4,"PrimTy","","Not represented directly in the AST, referred to by name through a ty_path.",null,null],[13,"TyInt","","",109,null],[13,"TyUint","","",109,null],[13,"TyFloat","","",109,null],[13,"TyStr","","",109,null],[13,"TyBool","","",109,null],[13,"TyChar","","",109,null],[4,"Ty_","","The different kinds of types recognized by the compiler",null,null],[13,"TySlice","","A variable length slice (`[T]`)",110,null],[13,"TyArray","","A fixed length array (`[T; n]`)",110,null],[13,"TyPtr","","A raw pointer (`*const T` or `*mut T`)",110,null],[13,"TyRptr","","A reference (`&'a T` or `&'a mut T`)",110,null],[13,"TyBareFn","","A bare function (e.g. `fn(usize) -> bool`)",110,null],[13,"TyNever","","The never type (`!`)",110,null],[13,"TyTup","","A tuple (`(A, B, C, D,...)`)",110,null],[13,"TyPath","","A path to a type definition (`module::module::...::Type`), or an associated type, e.g. `<Vec<T> as Trait>::Type` or `<T>::Target`.",110,null],[13,"TyTraitObject","","A trait object type `Bound1 + Bound2 + Bound3` where `Bound` is a trait or a lifetime.",110,null],[13,"TyImplTraitExistential","","An existentially quantified (there exists a type satisfying) `impl Bound1 + Bound2 + Bound3` type where `Bound` is a trait or a lifetime.",110,null],[13,"TyTypeof","","Unused for now",110,null],[13,"TyInfer","","TyInfer means the type should be inferred instead of it having been specified. This can appear anywhere in a type.",110,null],[13,"TyErr","","Placeholder for a type that has failed to be defined.",110,null],[4,"IsAuto","","Is the trait definition an auto trait?",null,null],[13,"Yes","","",111,null],[13,"No","","",111,null],[4,"Unsafety","","",null,null],[13,"Unsafe","","",112,null],[13,"Normal","","",112,null],[4,"Constness","","",null,null],[13,"Const","","",113,null],[13,"NotConst","","",113,null],[4,"Defaultness","","",null,null],[13,"Default","","",114,null],[12,"has_value","rustc::hir::Defaultness","",114,null],[13,"Final","rustc::hir","",114,null],[4,"ImplPolarity","","",null,null],[13,"Positive","","`impl Trait for Type`",115,null],[13,"Negative","","`impl !Trait for Type`",115,null],[4,"FunctionRetTy","","",null,null],[13,"DefaultReturn","","Return type is not specified.",116,null],[13,"Return","","Everything else",116,null],[4,"UseKind","","",null,null],[13,"Single","","One import, e.g. `use foo::bar` or `use foo::bar as baz`. Also produced for each element of a list `use`, e.g.",117,null],[13,"Glob","","Glob import, e.g. `use foo::*`.",117,null],[13,"ListStem","","Degenerate list import, e.g. `use foo::{a, b}` produces an additional `use foo::{}` for performing checks such as unstable feature gating. May be removed in the future.",117,null],[4,"Visibility","","",null,null],[13,"Public","","",118,null],[13,"Crate","","",118,null],[13,"Restricted","","",118,null],[12,"path","rustc::hir::Visibility","",118,null],[12,"id","","",118,null],[13,"Inherited","rustc::hir","",118,null],[4,"VariantData","","Fields and Ids of enum variants and structs",null,null],[13,"Struct","","",119,null],[13,"Tuple","","",119,null],[13,"Unit","","",119,null],[4,"Item_","","",null,null],[13,"ItemExternCrate","","An `extern crate` item, with optional original crate name if the crate was renamed.",120,null],[13,"ItemUse","","`use foo::bar::*;` or `use foo::bar::baz as quux;`",120,null],[13,"ItemStatic","","A `static` item",120,null],[13,"ItemConst","","A `const` item",120,null],[13,"ItemFn","","A function declaration",120,null],[13,"ItemMod","","A module",120,null],[13,"ItemForeignMod","","An external module",120,null],[13,"ItemGlobalAsm","","Module-level inline assembly (from global_asm!)",120,null],[13,"ItemTy","","A type alias, e.g. `type Foo = Bar<u8>`",120,null],[13,"ItemEnum","","An enum definition, e.g. `enum Foo<A, B> {C<A>, D<B>}`",120,null],[13,"ItemStruct","","A struct definition, e.g. `struct Foo<A> {x: A}`",120,null],[13,"ItemUnion","","A union definition, e.g. `union Foo<A, B> {x: A, y: B}`",120,null],[13,"ItemTrait","","Represents a Trait Declaration",120,null],[13,"ItemTraitAlias","","Represents a Trait Alias Declaration",120,null],[13,"ItemImpl","","An implementation, eg `impl<A> Trait for Foo { .. }`",120,null],[4,"AssociatedItemKind","","",null,null],[13,"Const","","",121,null],[13,"Method","","",121,null],[12,"has_self","rustc::hir::AssociatedItemKind","",121,null],[13,"Type","rustc::hir","",121,null],[4,"ForeignItem_","","An item within an `extern` block",null,null],[13,"ForeignItemFn","","A foreign function",122,null],[13,"ForeignItemStatic","","A foreign static item (`static ext: u8`), with optional mutability (the boolean is true when mutable)",122,null],[13,"ForeignItemType","","A foreign type",122,null],[5,"provide","","",null,{"inputs":[{"name":"providers"}],"output":null}],[0,"check_attr","","This module implements some validity checks for attributes. In particular it verifies that `#[inline]` and `#[repr]` attributes are attached to items that actually support them and if there are conflicts between multiple such attributes attached to the same item.",null,null],[5,"check_crate","rustc::hir::check_attr","",null,{"inputs":[{"name":"tyctxt"}],"output":null}],[0,"def","rustc::hir","",null,null],[3,"PathResolution","rustc::hir::def","The result of resolving a path before lowering to HIR. `base_def` is definition of resolved part of the path, `unresolved_segments` is the number of unresolved segments.",null,null],[3,"Export","","",null,null],[12,"ident","","The name of the target.",123,null],[12,"def","","The definition of the target.",123,null],[12,"span","","The span of the target definition.",123,null],[12,"vis","","The visibility of the export. We include non-`pub` exports for hygienic macros that get used from extern crates.",123,null],[12,"is_import","","True if from a `use` or and `extern crate`. Used in rustdoc.",123,null],[4,"CtorKind","","",null,null],[13,"Fn","","Constructor function automatically created by a tuple struct/variant.",124,null],[13,"Const","","Constructor constant automatically created by a unit struct/variant.",124,null],[13,"Fictive","","Unusable name in value namespace created by a struct variant.",124,null],[4,"Def","","",null,null],[13,"Mod","","",125,null],[13,"Struct","","",125,null],[13,"Union","","",125,null],[13,"Enum","","",125,null],[13,"Variant","","",125,null],[13,"Trait","","",125,null],[13,"TyAlias","","",125,null],[13,"TyForeign","","",125,null],[13,"TraitAlias","","",125,null],[13,"AssociatedTy","","",125,null],[13,"PrimTy","","",125,null],[13,"TyParam","","",125,null],[13,"SelfTy","","",125,null],[13,"Fn","","",125,null],[13,"Const","","",125,null],[13,"Static","","",125,null],[13,"StructCtor","","",125,null],[13,"VariantCtor","","",125,null],[13,"Method","","",125,null],[13,"AssociatedConst","","",125,null],[13,"Local","","",125,null],[13,"Upvar","","",125,null],[13,"Label","","",125,null],[13,"Macro","","",125,null],[13,"GlobalAsm","","",125,null],[13,"Err","","",125,null],[6,"DefMap","","Definition mapping",null,null],[6,"ExportMap","","This is the replacement export map. It maps a module to all of the exports within.",null,null],[11,"clone","","",124,{"inputs":[{"name":"self"}],"output":{"name":"ctorkind"}}],[11,"eq","","",124,{"inputs":[{"name":"self"},{"name":"ctorkind"}],"output":{"name":"bool"}}],[11,"encode","","",124,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",124,{"inputs":[{"name":"__d"}],"output":{"generics":["ctorkind"],"name":"result"}}],[11,"hash","","",124,null],[11,"fmt","","",124,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",125,{"inputs":[{"name":"self"}],"output":{"name":"def"}}],[11,"eq","","",125,{"inputs":[{"name":"self"},{"name":"def"}],"output":{"name":"bool"}}],[11,"ne","","",125,{"inputs":[{"name":"self"},{"name":"def"}],"output":{"name":"bool"}}],[11,"encode","","",125,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",125,{"inputs":[{"name":"__d"}],"output":{"generics":["def"],"name":"result"}}],[11,"hash","","",125,null],[11,"fmt","","",125,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",126,{"inputs":[{"name":"self"}],"output":{"name":"pathresolution"}}],[11,"fmt","","",126,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","",126,{"inputs":[{"name":"def"}],"output":{"name":"self"}}],[11,"with_unresolved_segments","","",126,{"inputs":[{"name":"def"},{"name":"usize"}],"output":{"name":"self"}}],[11,"base_def","","",126,{"inputs":[{"name":"self"}],"output":{"name":"def"}}],[11,"unresolved_segments","","",126,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"kind_name","","",126,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"clone","","",123,{"inputs":[{"name":"self"}],"output":{"name":"export"}}],[11,"fmt","","",123,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",123,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",123,{"inputs":[{"name":"__d"}],"output":{"generics":["export"],"name":"result"}}],[11,"from_ast","","",124,{"inputs":[{"name":"variantdata"}],"output":{"name":"ctorkind"}}],[11,"from_hir","","",124,{"inputs":[{"name":"variantdata"}],"output":{"name":"ctorkind"}}],[11,"def_id","","",125,{"inputs":[{"name":"self"}],"output":{"name":"defid"}}],[11,"kind_name","","A human readable kind name",125,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[0,"def_id","rustc::hir","",null,null],[3,"CrateNum","rustc::hir::def_id","",null,null],[3,"DefIndex","","A DefIndex is an index into the hir-map for a crate, identifying a particular definition. It should really be considered an interned shorthand for a particular DefPath.",null,null],[3,"DefId","","A DefId identifies a particular definition, by combining a crate index and a def index.",null,null],[12,"krate","","",127,null],[12,"index","","",127,null],[3,"LocalDefId","","A LocalDefId is equivalent to a DefId with `krate == LOCAL_CRATE`. Since we encode this information in the type, we can ensure at compile time that no DefIds from upstream crates get thrown into the mix. There are quite a few cases where we know that only DefIds from the local crate are expected and a DefId from a different crate would signify a bug somewhere. This is when LocalDefId comes in handy.",null,null],[4,"DefIndexAddressSpace","","",null,null],[13,"Low","","",128,null],[13,"High","","",128,null],[17,"LOCAL_CRATE","","Item definitions in the currently-compiled crate would have the CrateNum LOCAL_CRATE in their DefId.",null,null],[17,"BUILTIN_MACROS_CRATE","","Virtual crate for builtin macros",null,null],[17,"INVALID_CRATE","","A CrateNum value that indicates that something is wrong.",null,null],[17,"RESERVED_FOR_INCR_COMP_CACHE","","A special CrateNum that we use for the tcx.rcache when decoding from the incr. comp. cache.",null,null],[17,"CRATE_DEF_INDEX","","The crate root is always assigned index 0 by the AST Map code, thanks to `NodeCollector::new`.",null,null],[11,"clone","","",129,{"inputs":[{"name":"self"}],"output":{"name":"cratenum"}}],[11,"eq","","",129,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"bool"}}],[11,"ne","","",129,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"bool"}}],[11,"hash","","",129,null],[11,"partial_cmp","","",129,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",129,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"bool"}}],[11,"le","","",129,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"bool"}}],[11,"gt","","",129,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"bool"}}],[11,"ge","","",129,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"bool"}}],[11,"cmp","","",129,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"ordering"}}],[11,"new","","",129,{"inputs":[{"name":"usize"}],"output":{"name":"self"}}],[11,"index","","",129,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"fmt","","",129,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","",129,{"inputs":[{"name":"usize"}],"output":{"name":"cratenum"}}],[11,"from_u32","","",129,{"inputs":[{"name":"u32"}],"output":{"name":"cratenum"}}],[11,"as_usize","","",129,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"as_u32","","",129,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"as_def_id","","",129,{"inputs":[{"name":"self"}],"output":{"name":"defid"}}],[11,"fmt","","",129,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",130,{"inputs":[{"name":"self"}],"output":{"name":"defindex"}}],[11,"cmp","","",130,{"inputs":[{"name":"self"},{"name":"defindex"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",130,{"inputs":[{"name":"self"},{"name":"defindex"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",130,{"inputs":[{"name":"self"},{"name":"defindex"}],"output":{"name":"bool"}}],[11,"le","","",130,{"inputs":[{"name":"self"},{"name":"defindex"}],"output":{"name":"bool"}}],[11,"gt","","",130,{"inputs":[{"name":"self"},{"name":"defindex"}],"output":{"name":"bool"}}],[11,"ge","","",130,{"inputs":[{"name":"self"},{"name":"defindex"}],"output":{"name":"bool"}}],[11,"eq","","",130,{"inputs":[{"name":"self"},{"name":"defindex"}],"output":{"name":"bool"}}],[11,"ne","","",130,{"inputs":[{"name":"self"},{"name":"defindex"}],"output":{"name":"bool"}}],[11,"hash","","",130,null],[11,"fmt","","",130,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"address_space","","",130,{"inputs":[{"name":"self"}],"output":{"name":"defindexaddressspace"}}],[11,"as_array_index","","Converts this DefIndex into a zero-based array index. This index is the offset within the given DefIndexAddressSpace.",130,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"from_array_index","","",130,{"inputs":[{"name":"usize"},{"name":"defindexaddressspace"}],"output":{"name":"defindex"}}],[11,"from_proc_macro_index","","",130,{"inputs":[{"name":"usize"}],"output":{"name":"defindex"}}],[11,"to_proc_macro_index","","",130,{"inputs":[{"name":"defindex"}],"output":{"name":"usize"}}],[11,"from_raw_u32","","",130,{"inputs":[{"name":"u32"}],"output":{"name":"defindex"}}],[11,"as_raw_u32","","",130,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"clone","","",128,{"inputs":[{"name":"self"}],"output":{"name":"defindexaddressspace"}}],[11,"eq","","",128,{"inputs":[{"name":"self"},{"name":"defindexaddressspace"}],"output":{"name":"bool"}}],[11,"hash","","",128,null],[11,"index","","",128,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"clone","","",127,{"inputs":[{"name":"self"}],"output":{"name":"defid"}}],[11,"cmp","","",127,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",127,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",127,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"bool"}}],[11,"le","","",127,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"bool"}}],[11,"gt","","",127,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"bool"}}],[11,"ge","","",127,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"bool"}}],[11,"eq","","",127,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"bool"}}],[11,"ne","","",127,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"bool"}}],[11,"hash","","",127,null],[11,"fmt","","",127,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"local","","Make a local `DefId` with the given index.",127,{"inputs":[{"name":"defindex"}],"output":{"name":"defid"}}],[11,"is_local","","",127,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"to_local","","",127,{"inputs":[{"name":"self"}],"output":{"name":"localdefid"}}],[11,"clone","","",131,{"inputs":[{"name":"self"}],"output":{"name":"localdefid"}}],[11,"eq","","",131,{"inputs":[{"name":"self"},{"name":"localdefid"}],"output":{"name":"bool"}}],[11,"ne","","",131,{"inputs":[{"name":"self"},{"name":"localdefid"}],"output":{"name":"bool"}}],[11,"cmp","","",131,{"inputs":[{"name":"self"},{"name":"localdefid"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",131,{"inputs":[{"name":"self"},{"name":"localdefid"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",131,{"inputs":[{"name":"self"},{"name":"localdefid"}],"output":{"name":"bool"}}],[11,"le","","",131,{"inputs":[{"name":"self"},{"name":"localdefid"}],"output":{"name":"bool"}}],[11,"gt","","",131,{"inputs":[{"name":"self"},{"name":"localdefid"}],"output":{"name":"bool"}}],[11,"ge","","",131,{"inputs":[{"name":"self"},{"name":"localdefid"}],"output":{"name":"bool"}}],[11,"hash","","",131,null],[11,"from_def_id","","",131,{"inputs":[{"name":"defid"}],"output":{"name":"localdefid"}}],[11,"to_def_id","","",131,{"inputs":[{"name":"self"}],"output":{"name":"defid"}}],[11,"fmt","","",131,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[0,"intravisit","rustc::hir","HIR walker for walking the contents of nodes.",null,null],[3,"IdRange","rustc::hir::intravisit","",null,null],[12,"min","","",132,null],[12,"max","","",132,null],[3,"IdRangeComputingVisitor","","",null,null],[4,"FnKind","","",null,null],[13,"ItemFn","","fn foo() or extern \"Abi\" fn foo()",133,null],[13,"Method","","fn foo(&self)",133,null],[13,"Closure","","|x, y| {}",133,null],[4,"NestedVisitorMap","","Specifies what nested things a visitor wants to visit. The most common choice is `OnlyBodies`, which will cause the visitor to visit fn bodies for fns that it encounters, but skip over nested item-like things.",null,null],[13,"None","","Do not visit any nested things. When you add a new \"non-nested\" thing, you will want to audit such uses to see if they remain valid.",134,null],[13,"OnlyBodies","","Do not visit nested item-like things, but visit nested things that are inside of an item-like.",134,null],[13,"All","","Visit all nested things, including item-likes.",134,null],[5,"walk_crate","","Walks the contents of a crate. See also `Crate::visit_all_items`.",null,{"inputs":[{"name":"v"},{"name":"crate"}],"output":null}],[5,"walk_macro_def","","",null,{"inputs":[{"name":"v"},{"name":"macrodef"}],"output":null}],[5,"walk_mod","","",null,{"inputs":[{"name":"v"},{"name":"mod"},{"name":"nodeid"}],"output":null}],[5,"walk_body","","",null,{"inputs":[{"name":"v"},{"name":"body"}],"output":null}],[5,"walk_local","","",null,{"inputs":[{"name":"v"},{"name":"local"}],"output":null}],[5,"walk_label","","",null,{"inputs":[{"name":"v"},{"name":"label"}],"output":null}],[5,"walk_lifetime","","",null,{"inputs":[{"name":"v"},{"name":"lifetime"}],"output":null}],[5,"walk_poly_trait_ref","","",null,{"inputs":[{"name":"v"},{"name":"polytraitref"},{"name":"traitboundmodifier"}],"output":null}],[5,"walk_trait_ref","","",null,{"inputs":[{"name":"v"},{"name":"traitref"}],"output":null}],[5,"walk_item","","",null,{"inputs":[{"name":"v"},{"name":"item"}],"output":null}],[5,"walk_enum_def","","",null,{"inputs":[{"name":"v"},{"name":"enumdef"},{"name":"generics"},{"name":"nodeid"}],"output":null}],[5,"walk_variant","","",null,{"inputs":[{"name":"v"},{"name":"variant"},{"name":"generics"},{"name":"nodeid"}],"output":null}],[5,"walk_ty","","",null,{"inputs":[{"name":"v"},{"name":"ty"}],"output":null}],[5,"walk_qpath","","",null,{"inputs":[{"name":"v"},{"name":"qpath"},{"name":"nodeid"},{"name":"span"}],"output":null}],[5,"walk_path","","",null,{"inputs":[{"name":"v"},{"name":"path"}],"output":null}],[5,"walk_path_segment","","",null,{"inputs":[{"name":"v"},{"name":"span"},{"name":"pathsegment"}],"output":null}],[5,"walk_path_parameters","","",null,{"inputs":[{"name":"v"},{"name":"span"},{"name":"pathparameters"}],"output":null}],[5,"walk_assoc_type_binding","","",null,{"inputs":[{"name":"v"},{"name":"typebinding"}],"output":null}],[5,"walk_pat","","",null,{"inputs":[{"name":"v"},{"name":"pat"}],"output":null}],[5,"walk_foreign_item","","",null,{"inputs":[{"name":"v"},{"name":"foreignitem"}],"output":null}],[5,"walk_ty_param_bound","","",null,{"inputs":[{"name":"v"},{"name":"typarambound"}],"output":null}],[5,"walk_generic_param","","",null,{"inputs":[{"name":"v"},{"name":"genericparam"}],"output":null}],[5,"walk_generics","","",null,{"inputs":[{"name":"v"},{"name":"generics"}],"output":null}],[5,"walk_where_predicate","","",null,{"inputs":[{"name":"v"},{"name":"wherepredicate"}],"output":null}],[5,"walk_fn_ret_ty","","",null,{"inputs":[{"name":"v"},{"name":"functionretty"}],"output":null}],[5,"walk_fn_decl","","",null,{"inputs":[{"name":"v"},{"name":"fndecl"}],"output":null}],[5,"walk_fn_kind","","",null,{"inputs":[{"name":"v"},{"name":"fnkind"}],"output":null}],[5,"walk_fn","","",null,{"inputs":[{"name":"v"},{"name":"fnkind"},{"name":"fndecl"},{"name":"bodyid"},{"name":"span"},{"name":"nodeid"}],"output":null}],[5,"walk_trait_item","","",null,{"inputs":[{"name":"v"},{"name":"traititem"}],"output":null}],[5,"walk_trait_item_ref","","",null,{"inputs":[{"name":"v"},{"name":"traititemref"}],"output":null}],[5,"walk_impl_item","","",null,{"inputs":[{"name":"v"},{"name":"implitem"}],"output":null}],[5,"walk_impl_item_ref","","",null,{"inputs":[{"name":"v"},{"name":"implitemref"}],"output":null}],[5,"walk_struct_def","","",null,{"inputs":[{"name":"v"},{"name":"variantdata"}],"output":null}],[5,"walk_struct_field","","",null,{"inputs":[{"name":"v"},{"name":"structfield"}],"output":null}],[5,"walk_block","","",null,{"inputs":[{"name":"v"},{"name":"block"}],"output":null}],[5,"walk_stmt","","",null,{"inputs":[{"name":"v"},{"name":"stmt"}],"output":null}],[5,"walk_decl","","",null,{"inputs":[{"name":"v"},{"name":"decl"}],"output":null}],[5,"walk_expr","","",null,{"inputs":[{"name":"v"},{"name":"expr"}],"output":null}],[5,"walk_arm","","",null,{"inputs":[{"name":"v"},{"name":"arm"}],"output":null}],[5,"walk_vis","","",null,{"inputs":[{"name":"v"},{"name":"visibility"}],"output":null}],[5,"walk_associated_item_kind","","",null,{"inputs":[{"name":"v"},{"name":"associateditemkind"}],"output":null}],[5,"walk_defaultness","","",null,{"inputs":[{"name":"v"},{"name":"defaultness"}],"output":null}],[8,"Visitor","","Each method of the Visitor trait is a hook to be potentially overridden.  Each method's default implementation recursively visits the substructure of the input via the corresponding `walk` method; e.g. the `visit_mod` method by default calls `intravisit::walk_mod`.",null,null],[10,"nested_visit_map","","The default versions of the `visit_nested_XXX` routines invoke this method to get a map to use. By selecting an enum variant, you control which kinds of nested HIR are visited; see `NestedVisitorMap` for details. By \"nested HIR\", we are referring to bits of HIR that are not directly embedded within one another but rather indirectly, through a table in the crate. This is done to control dependencies during incremental compilation: the non-inline bits of HIR can be tracked and hashed separately.",135,{"inputs":[{"name":"self"}],"output":{"name":"nestedvisitormap"}}],[11,"visit_nested_item","","Invoked when a nested item is encountered. By default does nothing unless you override `nested_visit_map` to return `Some(_)`, in which case it will walk the item. You probably don't want to override this method -- instead, override `nested_visit_map` or use the \"shallow\" or \"deep\" visit patterns described on `itemlikevisit::ItemLikeVisitor`. The only reason to override this method is if you want a nested pattern but cannot supply a `Map`; see `nested_visit_map` for advice.",135,{"inputs":[{"name":"self"},{"name":"itemid"}],"output":null}],[11,"visit_nested_trait_item","","Like `visit_nested_item()`, but for trait items. See `visit_nested_item()` for advice on when to override this method.",135,{"inputs":[{"name":"self"},{"name":"traititemid"}],"output":null}],[11,"visit_nested_impl_item","","Like `visit_nested_item()`, but for impl items. See `visit_nested_item()` for advice on when to override this method.",135,{"inputs":[{"name":"self"},{"name":"implitemid"}],"output":null}],[11,"visit_nested_body","","Invoked to visit the body of a function, method or closure. Like visit_nested_item, does nothing by default unless you override `nested_visit_map` to return `Some(_)`, in which case it will walk the body.",135,{"inputs":[{"name":"self"},{"name":"bodyid"}],"output":null}],[11,"visit_item","","Visit the top-level item and (optionally) nested items / impl items. See `visit_nested_item` for details.",135,{"inputs":[{"name":"self"},{"name":"item"}],"output":null}],[11,"visit_body","","",135,{"inputs":[{"name":"self"},{"name":"body"}],"output":null}],[11,"as_deep_visitor","","When invoking `visit_all_item_likes()`, you need to supply an item-like visitor.  This method converts a \"intra-visit\" visitor into an item-like visitor that walks the entire tree. If you use this, you probably don't want to process the contents of nested item-like things, since the outer loop will visit them as well.",135,{"inputs":[{"name":"self"}],"output":{"name":"deepvisitor"}}],[11,"visit_id","","",135,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":null}],[11,"visit_def_mention","","",135,{"inputs":[{"name":"self"},{"name":"def"}],"output":null}],[11,"visit_name","","",135,{"inputs":[{"name":"self"},{"name":"span"},{"name":"name"}],"output":null}],[11,"visit_mod","","",135,{"inputs":[{"name":"self"},{"name":"mod"},{"name":"span"},{"name":"nodeid"}],"output":null}],[11,"visit_foreign_item","","",135,{"inputs":[{"name":"self"},{"name":"foreignitem"}],"output":null}],[11,"visit_local","","",135,{"inputs":[{"name":"self"},{"name":"local"}],"output":null}],[11,"visit_block","","",135,{"inputs":[{"name":"self"},{"name":"block"}],"output":null}],[11,"visit_stmt","","",135,{"inputs":[{"name":"self"},{"name":"stmt"}],"output":null}],[11,"visit_arm","","",135,{"inputs":[{"name":"self"},{"name":"arm"}],"output":null}],[11,"visit_pat","","",135,{"inputs":[{"name":"self"},{"name":"pat"}],"output":null}],[11,"visit_decl","","",135,{"inputs":[{"name":"self"},{"name":"decl"}],"output":null}],[11,"visit_expr","","",135,{"inputs":[{"name":"self"},{"name":"expr"}],"output":null}],[11,"visit_ty","","",135,{"inputs":[{"name":"self"},{"name":"ty"}],"output":null}],[11,"visit_generic_param","","",135,{"inputs":[{"name":"self"},{"name":"genericparam"}],"output":null}],[11,"visit_generics","","",135,{"inputs":[{"name":"self"},{"name":"generics"}],"output":null}],[11,"visit_where_predicate","","",135,{"inputs":[{"name":"self"},{"name":"wherepredicate"}],"output":null}],[11,"visit_fn_decl","","",135,{"inputs":[{"name":"self"},{"name":"fndecl"}],"output":null}],[11,"visit_fn","","",135,{"inputs":[{"name":"self"},{"name":"fnkind"},{"name":"fndecl"},{"name":"bodyid"},{"name":"span"},{"name":"nodeid"}],"output":null}],[11,"visit_trait_item","","",135,{"inputs":[{"name":"self"},{"name":"traititem"}],"output":null}],[11,"visit_trait_item_ref","","",135,{"inputs":[{"name":"self"},{"name":"traititemref"}],"output":null}],[11,"visit_impl_item","","",135,{"inputs":[{"name":"self"},{"name":"implitem"}],"output":null}],[11,"visit_impl_item_ref","","",135,{"inputs":[{"name":"self"},{"name":"implitemref"}],"output":null}],[11,"visit_trait_ref","","",135,{"inputs":[{"name":"self"},{"name":"traitref"}],"output":null}],[11,"visit_ty_param_bound","","",135,{"inputs":[{"name":"self"},{"name":"typarambound"}],"output":null}],[11,"visit_poly_trait_ref","","",135,{"inputs":[{"name":"self"},{"name":"polytraitref"},{"name":"traitboundmodifier"}],"output":null}],[11,"visit_variant_data","","",135,{"inputs":[{"name":"self"},{"name":"variantdata"},{"name":"name"},{"name":"generics"},{"name":"nodeid"},{"name":"span"}],"output":null}],[11,"visit_struct_field","","",135,{"inputs":[{"name":"self"},{"name":"structfield"}],"output":null}],[11,"visit_enum_def","","",135,{"inputs":[{"name":"self"},{"name":"enumdef"},{"name":"generics"},{"name":"nodeid"},{"name":"span"}],"output":null}],[11,"visit_variant","","",135,{"inputs":[{"name":"self"},{"name":"variant"},{"name":"generics"},{"name":"nodeid"}],"output":null}],[11,"visit_label","","",135,{"inputs":[{"name":"self"},{"name":"label"}],"output":null}],[11,"visit_lifetime","","",135,{"inputs":[{"name":"self"},{"name":"lifetime"}],"output":null}],[11,"visit_qpath","","",135,{"inputs":[{"name":"self"},{"name":"qpath"},{"name":"nodeid"},{"name":"span"}],"output":null}],[11,"visit_path","","",135,{"inputs":[{"name":"self"},{"name":"path"},{"name":"nodeid"}],"output":null}],[11,"visit_path_segment","","",135,{"inputs":[{"name":"self"},{"name":"span"},{"name":"pathsegment"}],"output":null}],[11,"visit_path_parameters","","",135,{"inputs":[{"name":"self"},{"name":"span"},{"name":"pathparameters"}],"output":null}],[11,"visit_assoc_type_binding","","",135,{"inputs":[{"name":"self"},{"name":"typebinding"}],"output":null}],[11,"visit_attribute","","",135,{"inputs":[{"name":"self"},{"name":"attribute"}],"output":null}],[11,"visit_macro_def","","",135,{"inputs":[{"name":"self"},{"name":"macrodef"}],"output":null}],[11,"visit_vis","","",135,{"inputs":[{"name":"self"},{"name":"visibility"}],"output":null}],[11,"visit_associated_item_kind","","",135,{"inputs":[{"name":"self"},{"name":"associateditemkind"}],"output":null}],[11,"visit_defaultness","","",135,{"inputs":[{"name":"self"},{"name":"defaultness"}],"output":null}],[11,"clone","","",133,{"inputs":[{"name":"self"}],"output":{"name":"fnkind"}}],[11,"eq","","",133,{"inputs":[{"name":"self"},{"name":"fnkind"}],"output":{"name":"bool"}}],[11,"ne","","",133,{"inputs":[{"name":"self"},{"name":"fnkind"}],"output":{"name":"bool"}}],[11,"attrs","","",133,null],[11,"intra","","Returns the map to use for an \"intra item-like\" thing (if any). e.g., function body.",134,{"inputs":[{"name":"self"}],"output":{"generics":["map"],"name":"option"}}],[11,"inter","","Returns the map to use for an \"item-like\" thing (if any). e.g., item, impl-item.",134,{"inputs":[{"name":"self"}],"output":{"generics":["map"],"name":"option"}}],[11,"clone","","",132,{"inputs":[{"name":"self"}],"output":{"name":"idrange"}}],[11,"encode","","",132,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",132,{"inputs":[{"name":"__d"}],"output":{"generics":["idrange"],"name":"result"}}],[11,"fmt","","",132,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",132,{"inputs":[{"name":"self"},{"name":"idrange"}],"output":{"name":"bool"}}],[11,"ne","","",132,{"inputs":[{"name":"self"},{"name":"idrange"}],"output":{"name":"bool"}}],[11,"max","","",132,{"inputs":[],"output":{"name":"idrange"}}],[11,"empty","","",132,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"contains","","",132,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"bool"}}],[11,"add","","",132,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":null}],[11,"new","","",136,{"inputs":[{"name":"map"}],"output":{"name":"idrangecomputingvisitor"}}],[11,"result","","",136,{"inputs":[{"name":"self"}],"output":{"name":"idrange"}}],[11,"nested_visit_map","","",136,{"inputs":[{"name":"self"}],"output":{"name":"nestedvisitormap"}}],[11,"visit_id","","",136,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":null}],[0,"itemlikevisit","rustc::hir","",null,null],[3,"DeepVisitor","rustc::hir::itemlikevisit","",null,null],[8,"ItemLikeVisitor","","The \"item-like visitor\" visitor defines only the top-level methods that can be invoked by `Crate::visit_all_item_likes()`. Whether this trait is the right one to implement will depend on the overall pattern you need. Here are the three available patterns, in roughly the order of desirability:",null,null],[10,"visit_item","","",137,{"inputs":[{"name":"self"},{"name":"item"}],"output":null}],[10,"visit_trait_item","","",137,{"inputs":[{"name":"self"},{"name":"traititem"}],"output":null}],[10,"visit_impl_item","","",137,{"inputs":[{"name":"self"},{"name":"implitem"}],"output":null}],[11,"new","","",138,{"inputs":[{"name":"v"}],"output":{"name":"self"}}],[11,"visit_item","","",138,{"inputs":[{"name":"self"},{"name":"item"}],"output":null}],[11,"visit_trait_item","","",138,{"inputs":[{"name":"self"},{"name":"traititem"}],"output":null}],[11,"visit_impl_item","","",138,{"inputs":[{"name":"self"},{"name":"implitem"}],"output":null}],[0,"lowering","rustc::hir","Lowers the AST to the HIR.",null,null],[3,"LoweringContext","rustc::hir::lowering","",null,null],[5,"lower_crate","","",null,{"inputs":[{"name":"session"},{"name":"cratestore"},{"name":"depgraph"},{"name":"crate"},{"name":"resolver"}],"output":{"name":"crate"}}],[8,"Resolver","","",null,null],[10,"resolve_hir_path","","Resolve a hir path generated by the lowerer when expanding `for`, `if let`, etc.",139,{"inputs":[{"name":"self"},{"name":"path"},{"name":"bool"}],"output":null}],[10,"get_resolution","","Obtain the resolution for a node id",139,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"generics":["pathresolution"],"name":"option"}}],[10,"definitions","","We must keep the set of definitions up to date as we add nodes that weren't in the AST. This should only return `None` during testing.",139,{"inputs":[{"name":"self"}],"output":{"name":"definitions"}}],[10,"resolve_str_path","","Given suffix [\"b\",\"c\",\"d\"], creates a HIR path for `[::crate_root]::b::c::d` and resolves it based on `is_value`.",139,null],[11,"lower_item","","",140,{"inputs":[{"name":"self"},{"name":"item"}],"output":{"generics":["item"],"name":"option"}}],[0,"map","rustc::hir","",null,null],[3,"DefCollector","rustc::hir::map","Creates def ids for nodes in the AST.",null,null],[12,"visit_macro_invoc","","",141,null],[3,"MacroInvocationData","","",null,null],[12,"mark","","",142,null],[12,"def_index","","",142,null],[12,"const_expr","","",142,null],[3,"Forest","","Stores a crate and any number of inlined items from other crates.",null,null],[12,"dep_graph","","",143,null],[3,"Map","","Represents a mapping from Node IDs to AST elements and their parent Node IDs",null,null],[12,"forest","","The backing storage for all the AST nodes.",144,null],[12,"dep_graph","","Same as the dep_graph in forest, just available with one fewer deref. This is a gratuitous micro-optimization.",144,null],[12,"crate_hash","","The SVH of the local crate.",144,null],[3,"NodesMatchingSuffix","","",null,null],[4,"Node","","",null,null],[13,"NodeItem","","",145,null],[13,"NodeForeignItem","","",145,null],[13,"NodeTraitItem","","",145,null],[13,"NodeImplItem","","",145,null],[13,"NodeVariant","","",145,null],[13,"NodeField","","",145,null],[13,"NodeExpr","","",145,null],[13,"NodeStmt","","",145,null],[13,"NodeTy","","",145,null],[13,"NodeTraitRef","","",145,null],[13,"NodeBinding","","",145,null],[13,"NodePat","","",145,null],[13,"NodeBlock","","",145,null],[13,"NodeLocal","","",145,null],[13,"NodeMacroDef","","",145,null],[13,"NodeStructCtor","","NodeStructCtor represents a tuple struct.",145,null],[13,"NodeLifetime","","",145,null],[13,"NodeTyParam","","",145,null],[13,"NodeVisibility","","",145,null],[5,"map_crate","","",null,{"inputs":[{"name":"session"},{"name":"cratestore"},{"name":"forest"},{"name":"definitions"}],"output":{"name":"map"}}],[5,"describe_def","","",null,{"inputs":[{"name":"tyctxt"},{"name":"defid"}],"output":{"generics":["def"],"name":"option"}}],[0,"blocks","","This module provides a simplified abstraction for working with code blocks identified by their integer node-id.  In particular, it captures a common set of attributes that all \"function-like things\" (represented by `FnLike` instances) share.  For example, all `FnLike` instances have a type signature (be it explicit or inferred).  And all `FnLike` instances have a body, i.e. the code that is run when the function-like thing it represents is invoked.",null,null],[3,"FnLikeNode","rustc::hir::map::blocks","An FnLikeNode is a Node that is like a fn, in that it has a decl and a body (as well as a NodeId, a span, etc).",null,null],[4,"Code","","Carries either an FnLikeNode or a Expr, as these are the two constructs that correspond to \"code\" (as in, something from which we can construct a control-flow graph).",null,null],[13,"FnLike","","",146,null],[13,"Expr","","",146,null],[8,"MaybeFnLike","","MaybeFnLike wraps a method that indicates if an object corresponds to some FnLikeNode.",null,null],[10,"is_fn_like","","",147,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",148,{"inputs":[{"name":"self"}],"output":{"name":"fnlikenode"}}],[11,"fmt","","",148,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"is_fn_like","rustc::hir","",71,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_fn_like","","",51,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_fn_like","","",46,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","rustc::hir::map::blocks","",146,{"inputs":[{"name":"self"}],"output":{"name":"code"}}],[11,"id","","",146,{"inputs":[{"name":"self"}],"output":{"name":"nodeid"}}],[11,"from_node","","Attempts to construct a Code from presumed FnLike or Expr node input.",146,{"inputs":[{"name":"map"},{"name":"nodeid"}],"output":{"generics":["code"],"name":"option"}}],[11,"from_node","","Attempts to construct a FnLikeNode from presumed FnLike node input.",148,{"inputs":[{"name":"node"}],"output":{"generics":["fnlikenode"],"name":"option"}}],[11,"body","","",148,{"inputs":[{"name":"self"}],"output":{"name":"bodyid"}}],[11,"decl","","",148,{"inputs":[{"name":"self"}],"output":{"name":"fndecl"}}],[11,"span","","",148,{"inputs":[{"name":"self"}],"output":{"name":"span"}}],[11,"id","","",148,{"inputs":[{"name":"self"}],"output":{"name":"nodeid"}}],[11,"constness","","",148,{"inputs":[{"name":"self"}],"output":{"name":"constness"}}],[11,"unsafety","","",148,{"inputs":[{"name":"self"}],"output":{"name":"unsafety"}}],[11,"kind","","",148,{"inputs":[{"name":"self"}],"output":{"name":"fnkind"}}],[11,"new","rustc::hir::map","",141,{"inputs":[{"name":"definitions"},{"name":"mark"}],"output":{"name":"self"}}],[11,"collect_root","","",141,{"inputs":[{"name":"self"},{"name":"str"},{"name":"cratedisambiguator"}],"output":null}],[11,"with_parent","","",141,{"inputs":[{"name":"self"},{"name":"defindex"},{"name":"f"}],"output":null}],[11,"visit_const_expr","","",141,{"inputs":[{"name":"self"},{"name":"expr"}],"output":null}],[11,"visit_item","","",141,{"inputs":[{"name":"self"},{"name":"item"}],"output":null}],[11,"visit_use_tree","","",141,{"inputs":[{"name":"self"},{"name":"usetree"},{"name":"nodeid"},{"name":"bool"}],"output":null}],[11,"visit_foreign_item","","",141,{"inputs":[{"name":"self"},{"name":"foreignitem"}],"output":null}],[11,"visit_generic_param","","",141,{"inputs":[{"name":"self"},{"name":"genericparam"}],"output":null}],[11,"visit_trait_item","","",141,{"inputs":[{"name":"self"},{"name":"traititem"}],"output":null}],[11,"visit_impl_item","","",141,{"inputs":[{"name":"self"},{"name":"implitem"}],"output":null}],[11,"visit_pat","","",141,{"inputs":[{"name":"self"},{"name":"pat"}],"output":null}],[11,"visit_expr","","",141,{"inputs":[{"name":"self"},{"name":"expr"}],"output":null}],[11,"visit_ty","","",141,{"inputs":[{"name":"self"},{"name":"ty"}],"output":null}],[11,"visit_stmt","","",141,{"inputs":[{"name":"self"},{"name":"stmt"}],"output":null}],[11,"visit_token","","",141,{"inputs":[{"name":"self"},{"name":"token"}],"output":null}],[0,"definitions","","For each definition, we track the following data.  A definition here is defined somewhat circularly as \"something with a def-id\", but it generally corresponds to things like structs, enums, etc. There are also some rather random cases (like const initializer expressions) that are mostly just leftovers.",null,null],[3,"DefPathTable","rustc::hir::map::definitions","The DefPathTable maps DefIndexes to DefKeys and vice versa. Internally the DefPathTable holds a tree of DefKeys, where each DefKey stores the DefIndex of its parent. There is one DefPathTable for each crate.",null,null],[3,"Definitions","","The definition table containing node definitions. It holds the DefPathTable for local DefIds/DefPaths and it also stores a mapping from NodeIds to local DefIds.",null,null],[3,"DefKey","","A unique identifier that we can use to lookup a definition precisely. It combines the index of the definition's parent (if any) with a `DisambiguatedDefPathData`.",null,null],[12,"parent","","Parent path.",149,null],[12,"disambiguated_data","","Identifier of this node.",149,null],[3,"DisambiguatedDefPathData","","Pair of `DefPathData` and an integer disambiguator. The integer is normally 0, but in the event that there are multiple defs with the same `parent` and `data`, we use this field to disambiguate between them. This introduces some artificial ordering dependency but means that if you have (e.g.) two impls for the same type in the same module, they do get distinct def-ids.",null,null],[12,"data","","",150,null],[12,"disambiguator","","",150,null],[3,"DefPath","","",null,null],[12,"data","","the path leading from the crate root to the item",151,null],[12,"krate","","what krate root is this path relative to?",151,null],[3,"DefPathHash","","",null,null],[12,"0","","",152,null],[4,"DefPathData","","",null,null],[13,"CrateRoot","","The crate root (marker)",153,null],[13,"Misc","","",153,null],[13,"Impl","","An impl",153,null],[13,"TypeNs","","Something in the type NS",153,null],[13,"ValueNs","","Something in the value NS",153,null],[13,"Module","","A module declaration",153,null],[13,"MacroDef","","A macro rule",153,null],[13,"ClosureExpr","","A closure expression",153,null],[13,"TypeParam","","A type parameter (generic parameter)",153,null],[13,"LifetimeDef","","A lifetime definition",153,null],[13,"EnumVariant","","A variant of a enum",153,null],[13,"Field","","A struct field",153,null],[13,"StructCtor","","Implicit ctor for a tuple-like struct",153,null],[13,"Initializer","","Initializer for a const",153,null],[13,"ImplTrait","","An `impl Trait` type node.",153,null],[13,"Typeof","","A `typeof` type node.",153,null],[13,"GlobalMetaData","","GlobalMetaData identifies a piece of crate metadata that is global to a whole crate (as opposed to just one item). GlobalMetaData components are only supposed to show up right below the crate root.",153,null],[4,"GlobalMetaDataKind","","",null,null],[13,"Krate","","",154,null],[13,"CrateDeps","","",154,null],[13,"DylibDependencyFormats","","",154,null],[13,"LangItems","","",154,null],[13,"LangItemsMissing","","",154,null],[13,"NativeLibraries","","",154,null],[13,"CodeMap","","",154,null],[13,"Impls","","",154,null],[13,"ExportedSymbols","","",154,null],[11,"clone","","",155,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"next_id","","",155,{"inputs":[{"name":"self"},{"name":"defindexaddressspace"}],"output":{"name":"defindex"}}],[11,"def_key","","",155,{"inputs":[{"name":"self"},{"name":"defindex"}],"output":{"name":"defkey"}}],[11,"def_path_hash","","",155,{"inputs":[{"name":"self"},{"name":"defindex"}],"output":{"name":"defpathhash"}}],[11,"add_def_path_hashes_to","","",155,{"inputs":[{"name":"self"},{"name":"cratenum"},{"name":"fxhashmap"}],"output":null}],[11,"size","","",155,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"encode","","",155,{"inputs":[{"name":"self"},{"name":"s"}],"output":{"name":"result"}}],[11,"decode","","",155,{"inputs":[{"name":"d"}],"output":{"generics":["defpathtable"],"name":"result"}}],[11,"clone","","",156,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"clone","","",149,{"inputs":[{"name":"self"}],"output":{"name":"defkey"}}],[11,"fmt","","",149,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",149,{"inputs":[{"name":"self"},{"name":"defkey"}],"output":{"name":"bool"}}],[11,"ne","","",149,{"inputs":[{"name":"self"},{"name":"defkey"}],"output":{"name":"bool"}}],[11,"hash","","",149,null],[11,"encode","","",149,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",149,{"inputs":[{"name":"__d"}],"output":{"generics":["defkey"],"name":"result"}}],[11,"clone","","",150,{"inputs":[{"name":"self"}],"output":{"name":"disambiguateddefpathdata"}}],[11,"fmt","","",150,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",150,{"inputs":[{"name":"self"},{"name":"disambiguateddefpathdata"}],"output":{"name":"bool"}}],[11,"ne","","",150,{"inputs":[{"name":"self"},{"name":"disambiguateddefpathdata"}],"output":{"name":"bool"}}],[11,"hash","","",150,null],[11,"encode","","",150,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",150,{"inputs":[{"name":"__d"}],"output":{"generics":["disambiguateddefpathdata"],"name":"result"}}],[11,"clone","","",151,{"inputs":[{"name":"self"}],"output":{"name":"defpath"}}],[11,"fmt","","",151,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",151,{"inputs":[{"name":"self"},{"name":"defpath"}],"output":{"name":"bool"}}],[11,"ne","","",151,{"inputs":[{"name":"self"},{"name":"defpath"}],"output":{"name":"bool"}}],[11,"hash","","",151,null],[11,"encode","","",151,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",151,{"inputs":[{"name":"__d"}],"output":{"generics":["defpath"],"name":"result"}}],[11,"is_local","","",151,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"make","","",151,{"inputs":[{"name":"cratenum"},{"name":"defindex"},{"name":"fn"}],"output":{"name":"defpath"}}],[11,"to_string_no_crate","","Returns a string representation of the DefPath without the crate-prefix. This method is useful if you don't have a TyCtxt available.",151,{"inputs":[{"name":"self"}],"output":{"name":"string"}}],[11,"to_filename_friendly_no_crate","","Return filename friendly string of the DefPah without the crate-prefix. This method is useful if you don't have a TyCtxt available.",151,{"inputs":[{"name":"self"}],"output":{"name":"string"}}],[11,"clone","","",153,{"inputs":[{"name":"self"}],"output":{"name":"defpathdata"}}],[11,"fmt","","",153,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",153,{"inputs":[{"name":"self"},{"name":"defpathdata"}],"output":{"name":"bool"}}],[11,"ne","","",153,{"inputs":[{"name":"self"},{"name":"defpathdata"}],"output":{"name":"bool"}}],[11,"hash","","",153,null],[11,"encode","","",153,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",153,{"inputs":[{"name":"__d"}],"output":{"generics":["defpathdata"],"name":"result"}}],[11,"clone","","",152,{"inputs":[{"name":"self"}],"output":{"name":"defpathhash"}}],[11,"hash","","",152,null],[11,"eq","","",152,{"inputs":[{"name":"self"},{"name":"defpathhash"}],"output":{"name":"bool"}}],[11,"ne","","",152,{"inputs":[{"name":"self"},{"name":"defpathhash"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",152,{"inputs":[{"name":"self"},{"name":"defpathhash"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",152,{"inputs":[{"name":"self"},{"name":"defpathhash"}],"output":{"name":"bool"}}],[11,"le","","",152,{"inputs":[{"name":"self"},{"name":"defpathhash"}],"output":{"name":"bool"}}],[11,"gt","","",152,{"inputs":[{"name":"self"},{"name":"defpathhash"}],"output":{"name":"bool"}}],[11,"ge","","",152,{"inputs":[{"name":"self"},{"name":"defpathhash"}],"output":{"name":"bool"}}],[11,"cmp","","",152,{"inputs":[{"name":"self"},{"name":"defpathhash"}],"output":{"name":"ordering"}}],[11,"fmt","","",152,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",152,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",152,{"inputs":[{"name":"__d"}],"output":{"generics":["defpathhash"],"name":"result"}}],[11,"hash_stable","","",152,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"new","","Create new empty definition map.",156,{"inputs":[],"output":{"name":"definitions"}}],[11,"def_path_table","","",156,{"inputs":[{"name":"self"}],"output":{"name":"defpathtable"}}],[11,"def_index_counts_lo_hi","","Get the number of definitions.",156,null],[11,"def_key","","",156,{"inputs":[{"name":"self"},{"name":"defindex"}],"output":{"name":"defkey"}}],[11,"def_path_hash","","",156,{"inputs":[{"name":"self"},{"name":"defindex"}],"output":{"name":"defpathhash"}}],[11,"def_path","","Returns the path from the crate root to `index`. The root nodes are not included in the path (i.e., this will be an empty vector for the crate root). For an inlined item, this will be the path of the item in the external crate (but the path will begin with the path to the external crate).",156,{"inputs":[{"name":"self"},{"name":"defindex"}],"output":{"name":"defpath"}}],[11,"opt_def_index","","",156,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"generics":["defindex"],"name":"option"}}],[11,"opt_local_def_id","","",156,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"generics":["defid"],"name":"option"}}],[11,"local_def_id","","",156,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"defid"}}],[11,"as_local_node_id","","",156,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["nodeid"],"name":"option"}}],[11,"node_to_hir_id","","",156,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"hirid"}}],[11,"find_node_for_hir_id","","",156,{"inputs":[{"name":"self"},{"name":"hirid"}],"output":{"name":"nodeid"}}],[11,"def_index_to_hir_id","","",156,{"inputs":[{"name":"self"},{"name":"defindex"}],"output":{"name":"hirid"}}],[11,"opt_span","","Retrieve the span of the given `DefId` if `DefId` is in the local crate, the span exists and it's not DUMMY_SP",156,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["span"],"name":"option"}}],[11,"create_root_def","","Add a definition with a parent definition.",156,{"inputs":[{"name":"self"},{"name":"str"},{"name":"cratedisambiguator"}],"output":{"name":"defindex"}}],[11,"create_def_with_parent","","Add a definition with a parent definition.",156,{"inputs":[{"name":"self"},{"name":"defindex"},{"name":"nodeid"},{"name":"defpathdata"},{"name":"defindexaddressspace"},{"name":"mark"},{"name":"span"}],"output":{"name":"defindex"}}],[11,"init_node_id_to_hir_id_mapping","","Initialize the ast::NodeId to HirId mapping once it has been generated during AST to HIR lowering.",156,{"inputs":[{"name":"self"},{"generics":["nodeid","hirid"],"name":"indexvec"}],"output":null}],[11,"expansion","","",156,{"inputs":[{"name":"self"},{"name":"defindex"}],"output":{"name":"mark"}}],[11,"macro_def_scope","","",156,{"inputs":[{"name":"self"},{"name":"mark"}],"output":{"name":"defid"}}],[11,"add_macro_def_scope","","",156,{"inputs":[{"name":"self"},{"name":"mark"},{"name":"defid"}],"output":null}],[11,"get_opt_name","","",153,{"inputs":[{"name":"self"}],"output":{"generics":["internedstring"],"name":"option"}}],[11,"as_interned_str","","",153,{"inputs":[{"name":"self"}],"output":{"name":"internedstring"}}],[11,"to_string","","",153,{"inputs":[{"name":"self"}],"output":{"name":"string"}}],[11,"clone","","",154,{"inputs":[{"name":"self"}],"output":{"name":"globalmetadatakind"}}],[11,"fmt","","",154,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",154,{"inputs":[{"name":"self"},{"name":"globalmetadatakind"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",154,{"inputs":[{"name":"self"},{"name":"globalmetadatakind"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"cmp","","",154,{"inputs":[{"name":"self"},{"name":"globalmetadatakind"}],"output":{"name":"ordering"}}],[11,"hash","","",154,null],[11,"encode","","",154,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",154,{"inputs":[{"name":"__d"}],"output":{"generics":["globalmetadatakind"],"name":"result"}}],[11,"def_index","","",154,{"inputs":[{"name":"self"},{"name":"defpathtable"}],"output":{"name":"defindex"}}],[17,"ITEM_LIKE_SPACE","rustc::hir::map","",null,null],[17,"REGULAR_SPACE","","",null,null],[11,"clone","","",145,{"inputs":[{"name":"self"}],"output":{"name":"node"}}],[11,"fmt","","",145,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","",143,{"inputs":[{"name":"crate"},{"name":"depgraph"}],"output":{"name":"forest"}}],[11,"krate","","",143,{"inputs":[{"name":"self"}],"output":{"name":"crate"}}],[11,"clone","","",144,{"inputs":[{"name":"self"}],"output":{"name":"map"}}],[11,"read","","Registers a read in the dependency graph of the AST node with the given `id`. This needs to be called each time a public function returns the HIR for a node -- in other words, when it \"reveals\" the content of a node to the caller (who might not otherwise have had access to those contents, and hence needs a read recorded). If the function just returns a DefId or NodeId, no actual content was returned, so no read is needed.",144,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":null}],[11,"definitions","","",144,{"inputs":[{"name":"self"}],"output":{"name":"definitions"}}],[11,"def_key","","",144,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"defkey"}}],[11,"def_path_from_id","","",144,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"generics":["defpath"],"name":"option"}}],[11,"def_path","","",144,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"defpath"}}],[11,"local_def_id","","",144,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"defid"}}],[11,"opt_local_def_id","","",144,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"generics":["defid"],"name":"option"}}],[11,"as_local_node_id","","",144,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["nodeid"],"name":"option"}}],[11,"hir_to_node_id","","",144,{"inputs":[{"name":"self"},{"name":"hirid"}],"output":{"name":"nodeid"}}],[11,"node_to_hir_id","","",144,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"hirid"}}],[11,"def_index_to_hir_id","","",144,{"inputs":[{"name":"self"},{"name":"defindex"}],"output":{"name":"hirid"}}],[11,"def_index_to_node_id","","",144,{"inputs":[{"name":"self"},{"name":"defindex"}],"output":{"name":"nodeid"}}],[11,"local_def_id_to_hir_id","","",144,{"inputs":[{"name":"self"},{"name":"localdefid"}],"output":{"name":"hirid"}}],[11,"local_def_id_to_node_id","","",144,{"inputs":[{"name":"self"},{"name":"localdefid"}],"output":{"name":"nodeid"}}],[11,"describe_def","","",144,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"generics":["def"],"name":"option"}}],[11,"krate","","",144,{"inputs":[{"name":"self"}],"output":{"name":"crate"}}],[11,"trait_item","","",144,{"inputs":[{"name":"self"},{"name":"traititemid"}],"output":{"name":"traititem"}}],[11,"impl_item","","",144,{"inputs":[{"name":"self"},{"name":"implitemid"}],"output":{"name":"implitem"}}],[11,"body","","",144,{"inputs":[{"name":"self"},{"name":"bodyid"}],"output":{"name":"body"}}],[11,"body_owner","","Returns the `NodeId` that corresponds to the definition of which this is the body of, i.e. a `fn`, `const` or `static` item (possibly associated), or a closure, or the body itself for embedded constant expressions (e.g. `N` in `[T; N]`).",144,{"inputs":[{"name":"self"},{"name":"bodyid"}],"output":{"name":"nodeid"}}],[11,"body_owner_def_id","","",144,{"inputs":[{"name":"self"},{"name":"bodyid"}],"output":{"name":"defid"}}],[11,"maybe_body_owned_by","","Given a node id, returns the `BodyId` associated with it, if the node is a body owner, otherwise returns `None`.",144,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"generics":["bodyid"],"name":"option"}}],[11,"body_owned_by","","Given a body owner's id, returns the `BodyId` associated with it.",144,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"bodyid"}}],[11,"body_owner_kind","","",144,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"bodyownerkind"}}],[11,"ty_param_owner","","",144,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"nodeid"}}],[11,"ty_param_name","","",144,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"name"}}],[11,"trait_impls","","",144,null],[11,"trait_auto_impl","","",144,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["nodeid"],"name":"option"}}],[11,"trait_is_auto","","",144,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"bool"}}],[11,"krate_attrs","","Get the attributes on the krate. This is preferable to invoking `krate.attrs` because it registers a tighter dep-graph access.",144,null],[11,"get","","Retrieve the Node corresponding to `id`, panicking if it cannot be found.",144,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"node"}}],[11,"get_if_local","","",144,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["node"],"name":"option"}}],[11,"find","","Retrieve the Node corresponding to `id`, returning None if cannot be found.",144,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"generics":["node"],"name":"option"}}],[11,"get_parent_node","","Similar to get_parent, returns the parent node id or id if there is no parent. Note that the parent may be CRATE_NODE_ID, which is not itself present in the map -- so passing the return value of get_parent_node to get may actually panic. This function returns the immediate parent in the AST, whereas get_parent returns the enclosing item. Note that this might not be the actual parent node in the AST - some kinds of nodes are not in the map and these will never appear as the parent_node. So you can always walk the parent_nodes from a node to the root of the ast (unless you get the same id back here that can happen if the id is not in the map itself or is just weird).",144,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"nodeid"}}],[11,"is_argument","","Check if the node is an argument. An argument is a local variable whose immediate parent is an item or a closure.",144,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"bool"}}],[11,"get_return_block","","Retrieve the NodeId for `id`'s enclosing method, unless there's a `while` or `loop` before reaching it, as block tail returns are not available in them.",144,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"generics":["nodeid"],"name":"option"}}],[11,"get_parent","","Retrieve the NodeId for `id`'s parent item, or `id` itself if no parent item is in this map. The \"parent item\" is the closest parent node in the AST which is recorded by the map and is an item, either an item in a module, trait, or impl.",144,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"nodeid"}}],[11,"get_module_parent","","Returns the NodeId of `id`'s nearest module parent, or `id` itself if no module parent is in this map.",144,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"defid"}}],[11,"get_enclosing_scope","","Returns the nearest enclosing scope. A scope is an item or block. FIXME it is not clear to me that all items qualify as scopes - statics and associated types probably shouldn't, for example. Behavior in this regard should be expected to be highly unstable.",144,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"generics":["nodeid"],"name":"option"}}],[11,"get_parent_did","","",144,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"defid"}}],[11,"get_foreign_abi","","",144,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"abi"}}],[11,"expect_item","","",144,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"item"}}],[11,"expect_impl_item","","",144,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"implitem"}}],[11,"expect_trait_item","","",144,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"traititem"}}],[11,"expect_variant_data","","",144,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"variantdata"}}],[11,"expect_variant","","",144,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"variant"}}],[11,"expect_foreign_item","","",144,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"foreignitem"}}],[11,"expect_expr","","",144,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"expr"}}],[11,"get_inlined_body_untracked","","",144,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["body"],"name":"option"}}],[11,"intern_inlined_body","","",144,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"body"}],"output":{"name":"body"}}],[11,"name","","Returns the name associated with the given NodeId's AST.",144,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"name"}}],[11,"attrs","","Given a node ID, get a list of attributes associated with the AST corresponding to the Node ID",144,null],[11,"nodes_matching_suffix","","Returns an iterator that yields the node id's with paths that match `parts`.  (Requires `parts` is non-empty.)",144,null],[11,"span","","",144,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"span"}}],[11,"span_if_local","","",144,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["span"],"name":"option"}}],[11,"node_to_string","","",144,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"string"}}],[11,"node_to_user_string","","",144,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"string"}}],[11,"node_to_pretty_string","","",144,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"string"}}],[11,"next","","",157,{"inputs":[{"name":"self"}],"output":{"generics":["nodeid"],"name":"option"}}],[11,"nested","","",144,{"inputs":[{"name":"self"},{"name":"state"},{"name":"nested"}],"output":{"name":"result"}}],[0,"pat_util","rustc::hir","",null,null],[3,"EnumerateAndAdjust","rustc::hir::pat_util","",null,null],[8,"EnumerateAndAdjustIterator","","",null,null],[10,"enumerate_and_adjust","","",158,{"inputs":[{"name":"self"},{"name":"usize"},{"generics":["usize"],"name":"option"}],"output":{"name":"enumerateandadjust"}}],[11,"next","","",159,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",159,null],[11,"is_refutable","rustc::hir","",39,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_const","","",39,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"each_binding","","Call `f` on every \"binding\" in a pattern, e.g., on `a` in `match foo() { Some(a) => (), None => () }`",39,{"inputs":[{"name":"self"},{"name":"f"}],"output":null}],[11,"contains_bindings","","Checks if the pattern contains any patterns that bind something to an ident, e.g. `foo`, or `Foo(foo)` or `foo @ Bar(..)`.",39,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"contains_bindings_or_wild","","Checks if the pattern contains any patterns that bind something to an ident or wildcard, e.g. `foo`, or `Foo(_)`, `foo @ Bar(..)`,",39,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"simple_name","","",39,{"inputs":[{"name":"self"}],"output":{"generics":["name"],"name":"option"}}],[11,"necessary_variants","","Return variants that are necessary to exist for the pattern to match.",39,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"vec"}}],[11,"contains_explicit_ref_binding","","Checks if the pattern contains any `ref` or `ref mut` bindings, and if yes whether it contains mutable or just immutables ones.",39,{"inputs":[{"name":"self"}],"output":{"generics":["mutability"],"name":"option"}}],[11,"contains_explicit_ref_binding","","Checks if the patterns for this arm contain any `ref` or `ref mut` bindings, and if yes whether its containing mutable ones or just immutables ones.",42,{"inputs":[{"name":"self"}],"output":{"generics":["mutability"],"name":"option"}}],[0,"print","","",null,null],[3,"NoAnn","rustc::hir::print","",null,null],[3,"State","","",null,null],[12,"s","","",160,null],[4,"AnnNode","","",null,null],[13,"NodeName","","",161,null],[13,"NodeBlock","","",161,null],[13,"NodeItem","","",161,null],[13,"NodeSubItem","","",161,null],[13,"NodeExpr","","",161,null],[13,"NodePat","","",161,null],[4,"Nested","","",null,null],[13,"Item","","",162,null],[13,"TraitItem","","",162,null],[13,"ImplItem","","",162,null],[13,"Body","","",162,null],[13,"BodyArgPat","","",162,null],[5,"print_crate","","Requires you to pass an input filename and reader so that it can scan the input text for comments and literals to copy forward.",null,{"inputs":[{"name":"codemap"},{"name":"parsesess"},{"name":"crate"},{"name":"filename"},{"name":"read"},{"generics":["write"],"name":"box"},{"name":"ppann"},{"name":"bool"}],"output":{"name":"result"}}],[5,"to_string","","",null,{"inputs":[{"name":"ppann"},{"name":"f"}],"output":{"name":"string"}}],[5,"visibility_qualified","","",null,{"inputs":[{"name":"visibility"},{"name":"str"}],"output":{"name":"string"}}],[17,"NO_ANN","","",null,null],[17,"indent_unit","","",null,null],[17,"default_columns","","",null,null],[8,"PpAnn","","",null,null],[11,"nested","","",163,{"inputs":[{"name":"self"},{"name":"state"},{"name":"nested"}],"output":{"name":"result"}}],[11,"pre","","",163,{"inputs":[{"name":"self"},{"name":"state"},{"name":"annnode"}],"output":{"name":"result"}}],[11,"post","","",163,{"inputs":[{"name":"self"},{"name":"state"},{"name":"annnode"}],"output":{"name":"result"}}],[11,"nested","rustc::hir","",36,{"inputs":[{"name":"self"},{"name":"state"},{"name":"nested"}],"output":{"name":"result"}}],[11,"writer","rustc::hir::print","",160,{"inputs":[{"name":"self"}],"output":{"name":"printer"}}],[11,"boxes","","",160,{"inputs":[{"name":"self"}],"output":{"name":"vec"}}],[11,"comments","","",160,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"cur_cmnt","","",160,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"cur_lit","","",160,{"inputs":[{"name":"self"}],"output":{"generics":["literal"],"name":"option"}}],[11,"bump_lit","","",160,{"inputs":[{"name":"self"}],"output":{"generics":["literal"],"name":"option"}}],[11,"new_from_input","","",160,{"inputs":[{"name":"codemap"},{"name":"parsesess"},{"name":"filename"},{"name":"read"},{"generics":["write"],"name":"box"},{"name":"ppann"},{"name":"bool"}],"output":{"name":"state"}}],[11,"new","","",160,{"inputs":[{"name":"codemap"},{"generics":["write"],"name":"box"},{"name":"ppann"},{"generics":["vec"],"name":"option"},{"generics":["vec"],"name":"option"}],"output":{"name":"state"}}],[11,"cbox","","",160,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"result"}}],[11,"nbsp","","",160,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"word_nbsp","","",160,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"result"}}],[11,"head","","",160,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"result"}}],[11,"bopen","","",160,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"bclose_","","",160,{"inputs":[{"name":"self"},{"name":"span"},{"name":"usize"}],"output":{"name":"result"}}],[11,"bclose_maybe_open","","",160,{"inputs":[{"name":"self"},{"name":"span"},{"name":"usize"},{"name":"bool"}],"output":{"name":"result"}}],[11,"bclose","","",160,{"inputs":[{"name":"self"},{"name":"span"}],"output":{"name":"result"}}],[11,"in_cbox","","",160,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"space_if_not_bol","","",160,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"break_offset_if_not_bol","","",160,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"isize"}],"output":{"name":"result"}}],[11,"synth_comment","","",160,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"result"}}],[11,"commasep_cmnt","","",160,null],[11,"commasep_exprs","","",160,null],[11,"print_mod","","",160,null],[11,"print_foreign_mod","","",160,null],[11,"print_opt_lifetime","","",160,{"inputs":[{"name":"self"},{"name":"lifetime"}],"output":{"name":"result"}}],[11,"print_type","","",160,{"inputs":[{"name":"self"},{"name":"ty"}],"output":{"name":"result"}}],[11,"print_foreign_item","","",160,{"inputs":[{"name":"self"},{"name":"foreignitem"}],"output":{"name":"result"}}],[11,"print_item","","Pretty-print an item",160,{"inputs":[{"name":"self"},{"name":"item"}],"output":{"name":"result"}}],[11,"print_trait_ref","","",160,{"inputs":[{"name":"self"},{"name":"traitref"}],"output":{"name":"result"}}],[11,"print_enum_def","","",160,{"inputs":[{"name":"self"},{"name":"enumdef"},{"name":"generics"},{"name":"name"},{"name":"span"},{"name":"visibility"}],"output":{"name":"result"}}],[11,"print_variants","","",160,null],[11,"print_visibility","","",160,{"inputs":[{"name":"self"},{"name":"visibility"}],"output":{"name":"result"}}],[11,"print_defaultness","","",160,{"inputs":[{"name":"self"},{"name":"defaultness"}],"output":{"name":"result"}}],[11,"print_struct","","",160,{"inputs":[{"name":"self"},{"name":"variantdata"},{"name":"generics"},{"name":"name"},{"name":"span"},{"name":"bool"}],"output":{"name":"result"}}],[11,"print_variant","","",160,{"inputs":[{"name":"self"},{"name":"variant"}],"output":{"name":"result"}}],[11,"print_method_sig","","",160,null],[11,"print_trait_item","","",160,{"inputs":[{"name":"self"},{"name":"traititem"}],"output":{"name":"result"}}],[11,"print_impl_item","","",160,{"inputs":[{"name":"self"},{"name":"implitem"}],"output":{"name":"result"}}],[11,"print_stmt","","",160,{"inputs":[{"name":"self"},{"name":"stmt"}],"output":{"name":"result"}}],[11,"print_block","","",160,{"inputs":[{"name":"self"},{"name":"block"}],"output":{"name":"result"}}],[11,"print_block_unclosed","","",160,{"inputs":[{"name":"self"},{"name":"block"}],"output":{"name":"result"}}],[11,"print_block_unclosed_indent","","",160,{"inputs":[{"name":"self"},{"name":"block"},{"name":"usize"}],"output":{"name":"result"}}],[11,"print_block_with_attrs","","",160,null],[11,"print_block_maybe_unclosed","","",160,null],[11,"print_if","","",160,{"inputs":[{"name":"self"},{"name":"expr"},{"name":"expr"},{"generics":["expr"],"name":"option"}],"output":{"name":"result"}}],[11,"print_if_let","","",160,{"inputs":[{"name":"self"},{"name":"pat"},{"name":"expr"},{"name":"block"},{"generics":["expr"],"name":"option"}],"output":{"name":"result"}}],[11,"print_expr_maybe_paren","","",160,{"inputs":[{"name":"self"},{"name":"expr"},{"name":"i8"}],"output":{"name":"result"}}],[11,"print_expr_as_cond","","Print an expr using syntax that's acceptable in a condition position, such as the `cond` in `if cond { ... }`.",160,{"inputs":[{"name":"self"},{"name":"expr"}],"output":{"name":"result"}}],[11,"print_expr","","",160,{"inputs":[{"name":"self"},{"name":"expr"}],"output":{"name":"result"}}],[11,"print_local_decl","","",160,{"inputs":[{"name":"self"},{"name":"local"}],"output":{"name":"result"}}],[11,"print_decl","","",160,{"inputs":[{"name":"self"},{"name":"decl"}],"output":{"name":"result"}}],[11,"print_usize","","",160,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"result"}}],[11,"print_name","","",160,{"inputs":[{"name":"self"},{"name":"name"}],"output":{"name":"result"}}],[11,"print_for_decl","","",160,{"inputs":[{"name":"self"},{"name":"local"},{"name":"expr"}],"output":{"name":"result"}}],[11,"print_path","","",160,{"inputs":[{"name":"self"},{"name":"path"},{"name":"bool"}],"output":{"name":"result"}}],[11,"print_qpath","","",160,{"inputs":[{"name":"self"},{"name":"qpath"},{"name":"bool"}],"output":{"name":"result"}}],[11,"print_pat","","",160,{"inputs":[{"name":"self"},{"name":"pat"}],"output":{"name":"result"}}],[11,"print_fn","","",160,null],[11,"print_capture_clause","","",160,{"inputs":[{"name":"self"},{"name":"captureclause"}],"output":{"name":"result"}}],[11,"print_bounds","","",160,null],[11,"print_lifetime","","",160,{"inputs":[{"name":"self"},{"name":"lifetime"}],"output":{"name":"result"}}],[11,"print_lifetime_def","","",160,{"inputs":[{"name":"self"},{"name":"lifetimedef"}],"output":{"name":"result"}}],[11,"print_generic_params","","",160,null],[11,"print_ty_param","","",160,{"inputs":[{"name":"self"},{"name":"typaram"}],"output":{"name":"result"}}],[11,"print_where_clause","","",160,{"inputs":[{"name":"self"},{"name":"whereclause"}],"output":{"name":"result"}}],[11,"print_mutability","","",160,{"inputs":[{"name":"self"},{"name":"mutability"}],"output":{"name":"result"}}],[11,"print_mt","","",160,{"inputs":[{"name":"self"},{"name":"mutty"}],"output":{"name":"result"}}],[11,"print_fn_output","","",160,{"inputs":[{"name":"self"},{"name":"fndecl"}],"output":{"name":"result"}}],[11,"print_ty_fn","","",160,null],[11,"maybe_print_trailing_comment","","",160,{"inputs":[{"name":"self"},{"name":"span"},{"generics":["bytepos"],"name":"option"}],"output":{"name":"result"}}],[11,"print_remaining_comments","","",160,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"print_opt_abi_and_extern_if_nondefault","","",160,{"inputs":[{"name":"self"},{"generics":["abi"],"name":"option"}],"output":{"name":"result"}}],[11,"print_extern_opt_abi","","",160,{"inputs":[{"name":"self"},{"generics":["abi"],"name":"option"}],"output":{"name":"result"}}],[11,"print_fn_header_info","","",160,{"inputs":[{"name":"self"},{"name":"unsafety"},{"name":"constness"},{"name":"abi"},{"name":"visibility"}],"output":{"name":"result"}}],[11,"print_unsafety","","",160,{"inputs":[{"name":"self"},{"name":"unsafety"}],"output":{"name":"result"}}],[11,"print_is_auto","","",160,{"inputs":[{"name":"self"},{"name":"isauto"}],"output":{"name":"result"}}],[0,"svh","rustc::hir","Calculation and management of a Strict Version Hash for crates",null,null],[3,"Svh","rustc::hir::svh","",null,null],[11,"clone","","",164,{"inputs":[{"name":"self"}],"output":{"name":"svh"}}],[11,"eq","","",164,{"inputs":[{"name":"self"},{"name":"svh"}],"output":{"name":"bool"}}],[11,"ne","","",164,{"inputs":[{"name":"self"},{"name":"svh"}],"output":{"name":"bool"}}],[11,"fmt","","",164,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Create a new `Svh` given the hash. If you actually want to compute the SVH from some HIR, you want the `calculate_svh` function found in `librustc_incremental`.",164,{"inputs":[{"name":"u64"}],"output":{"name":"svh"}}],[11,"as_u64","","",164,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"to_string","","",164,{"inputs":[{"name":"self"}],"output":{"name":"string"}}],[11,"hash","","",164,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"fmt","","",164,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",164,{"inputs":[{"name":"self"},{"name":"s"}],"output":{"name":"result"}}],[11,"decode","","",164,{"inputs":[{"name":"d"}],"output":{"generics":["svh"],"name":"result"}}],[11,"hash_stable","","",164,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[6,"HirVec","rustc::hir","HIR doesn't commit to a concrete storage type and has its own alias for a vector. It can be `Vec`, `P<[T]>` or potentially `Box<[T]>`, or some other container with similar behavior. Unlike AST, HIR is mostly a static structure, so we can use an owned slice instead of `Vec` to avoid keeping extra capacity.",null,null],[6,"TyParamBounds","","",null,null],[6,"CrateConfig","","",null,null],[6,"BinOp","","",null,null],[6,"Stmt","","A statement",null,null],[6,"Decl","","",null,null],[6,"Variant","","",null,null],[6,"FreevarMap","","",null,null],[6,"CaptureModeMap","","",null,null],[6,"TraitMap","","",null,null],[6,"GlobMap","","",null,null],[17,"CRATE_HIR_ID","","The `HirId` corresponding to CRATE_NODE_ID and CRATE_DEF_INDEX",null,null],[17,"DUMMY_HIR_ID","","",null,null],[17,"DUMMY_ITEM_LOCAL_ID","","",null,null],[8,"GenericParamsExt","","",null,null],[10,"lifetimes","","",165,{"inputs":[{"name":"self"}],"output":{"generics":["iter"],"name":"filtermap"}}],[10,"ty_params","","",165,{"inputs":[{"name":"self"}],"output":{"generics":["iter"],"name":"filtermap"}}],[11,"clone","","",22,{"inputs":[{"name":"self"}],"output":{"name":"hirid"}}],[11,"eq","","",22,{"inputs":[{"name":"self"},{"name":"hirid"}],"output":{"name":"bool"}}],[11,"ne","","",22,{"inputs":[{"name":"self"},{"name":"hirid"}],"output":{"name":"bool"}}],[11,"hash","","",22,null],[11,"partial_cmp","","",22,{"inputs":[{"name":"self"},{"name":"hirid"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",22,{"inputs":[{"name":"self"},{"name":"hirid"}],"output":{"name":"bool"}}],[11,"le","","",22,{"inputs":[{"name":"self"},{"name":"hirid"}],"output":{"name":"bool"}}],[11,"gt","","",22,{"inputs":[{"name":"self"},{"name":"hirid"}],"output":{"name":"bool"}}],[11,"ge","","",22,{"inputs":[{"name":"self"},{"name":"hirid"}],"output":{"name":"bool"}}],[11,"cmp","","",22,{"inputs":[{"name":"self"},{"name":"hirid"}],"output":{"name":"ordering"}}],[11,"fmt","","",22,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"owner_def_id","","",22,{"inputs":[{"name":"self"}],"output":{"name":"defid"}}],[11,"owner_local_def_id","","",22,{"inputs":[{"name":"self"}],"output":{"name":"localdefid"}}],[11,"default_encode","","",22,{"inputs":[{"name":"self"},{"name":"s"}],"output":{"name":"result"}}],[11,"default_decode","","",22,{"inputs":[{"name":"d"}],"output":{"generics":["hirid"],"name":"result"}}],[11,"clone","","",23,{"inputs":[{"name":"self"}],"output":{"name":"itemlocalid"}}],[11,"eq","","",23,{"inputs":[{"name":"self"},{"name":"itemlocalid"}],"output":{"name":"bool"}}],[11,"ne","","",23,{"inputs":[{"name":"self"},{"name":"itemlocalid"}],"output":{"name":"bool"}}],[11,"hash","","",23,null],[11,"partial_cmp","","",23,{"inputs":[{"name":"self"},{"name":"itemlocalid"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",23,{"inputs":[{"name":"self"},{"name":"itemlocalid"}],"output":{"name":"bool"}}],[11,"le","","",23,{"inputs":[{"name":"self"},{"name":"itemlocalid"}],"output":{"name":"bool"}}],[11,"gt","","",23,{"inputs":[{"name":"self"},{"name":"itemlocalid"}],"output":{"name":"bool"}}],[11,"ge","","",23,{"inputs":[{"name":"self"},{"name":"itemlocalid"}],"output":{"name":"bool"}}],[11,"cmp","","",23,{"inputs":[{"name":"self"},{"name":"itemlocalid"}],"output":{"name":"ordering"}}],[11,"fmt","","",23,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",23,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",23,{"inputs":[{"name":"__d"}],"output":{"generics":["itemlocalid"],"name":"result"}}],[11,"as_usize","","",23,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"new","","",23,{"inputs":[{"name":"usize"}],"output":{"name":"self"}}],[11,"index","","",23,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"clone","","",24,{"inputs":[{"name":"self"}],"output":{"name":"label"}}],[11,"eq","","",24,{"inputs":[{"name":"self"},{"name":"label"}],"output":{"name":"bool"}}],[11,"ne","","",24,{"inputs":[{"name":"self"},{"name":"label"}],"output":{"name":"bool"}}],[11,"encode","","",24,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",24,{"inputs":[{"name":"__d"}],"output":{"generics":["label"],"name":"result"}}],[11,"hash","","",24,null],[11,"fmt","","",24,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",25,{"inputs":[{"name":"self"}],"output":{"name":"lifetime"}}],[11,"eq","","",25,{"inputs":[{"name":"self"},{"name":"lifetime"}],"output":{"name":"bool"}}],[11,"ne","","",25,{"inputs":[{"name":"self"},{"name":"lifetime"}],"output":{"name":"bool"}}],[11,"encode","","",25,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",25,{"inputs":[{"name":"__d"}],"output":{"generics":["lifetime"],"name":"result"}}],[11,"hash","","",25,null],[11,"fmt","","",78,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",78,{"inputs":[{"name":"self"}],"output":{"name":"lifetimename"}}],[11,"eq","","",78,{"inputs":[{"name":"self"},{"name":"lifetimename"}],"output":{"name":"bool"}}],[11,"ne","","",78,{"inputs":[{"name":"self"},{"name":"lifetimename"}],"output":{"name":"bool"}}],[11,"encode","","",78,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",78,{"inputs":[{"name":"__d"}],"output":{"generics":["lifetimename"],"name":"result"}}],[11,"hash","","",78,null],[11,"name","","",78,{"inputs":[{"name":"self"}],"output":{"name":"name"}}],[11,"fmt","","",25,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"is_elided","","",25,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_static","","",25,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",26,{"inputs":[{"name":"self"}],"output":{"name":"lifetimedef"}}],[11,"eq","","",26,{"inputs":[{"name":"self"},{"name":"lifetimedef"}],"output":{"name":"bool"}}],[11,"ne","","",26,{"inputs":[{"name":"self"},{"name":"lifetimedef"}],"output":{"name":"bool"}}],[11,"encode","","",26,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",26,{"inputs":[{"name":"__d"}],"output":{"generics":["lifetimedef"],"name":"result"}}],[11,"hash","","",26,null],[11,"fmt","","",26,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",27,{"inputs":[{"name":"self"}],"output":{"name":"path"}}],[11,"eq","","",27,{"inputs":[{"name":"self"},{"name":"path"}],"output":{"name":"bool"}}],[11,"ne","","",27,{"inputs":[{"name":"self"},{"name":"path"}],"output":{"name":"bool"}}],[11,"encode","","",27,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",27,{"inputs":[{"name":"__d"}],"output":{"generics":["path"],"name":"result"}}],[11,"hash","","",27,null],[11,"is_global","","",27,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"fmt","","",27,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",27,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",28,{"inputs":[{"name":"self"}],"output":{"name":"pathsegment"}}],[11,"eq","","",28,{"inputs":[{"name":"self"},{"name":"pathsegment"}],"output":{"name":"bool"}}],[11,"ne","","",28,{"inputs":[{"name":"self"},{"name":"pathsegment"}],"output":{"name":"bool"}}],[11,"encode","","",28,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",28,{"inputs":[{"name":"__d"}],"output":{"generics":["pathsegment"],"name":"result"}}],[11,"hash","","",28,null],[11,"fmt","","",28,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"from_name","","Convert an identifier to the corresponding segment.",28,{"inputs":[{"name":"name"}],"output":{"name":"pathsegment"}}],[11,"new","","",28,{"inputs":[{"name":"name"},{"name":"pathparameters"},{"name":"bool"}],"output":{"name":"self"}}],[11,"with_parameters","","",28,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"r"}}],[11,"clone","","",29,{"inputs":[{"name":"self"}],"output":{"name":"pathparameters"}}],[11,"eq","","",29,{"inputs":[{"name":"self"},{"name":"pathparameters"}],"output":{"name":"bool"}}],[11,"ne","","",29,{"inputs":[{"name":"self"},{"name":"pathparameters"}],"output":{"name":"bool"}}],[11,"encode","","",29,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",29,{"inputs":[{"name":"__d"}],"output":{"generics":["pathparameters"],"name":"result"}}],[11,"hash","","",29,null],[11,"fmt","","",29,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"none","","",29,{"inputs":[],"output":{"name":"self"}}],[11,"is_empty","","",29,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"inputs","","",29,null],[11,"clone","","",79,{"inputs":[{"name":"self"}],"output":{"name":"typarambound"}}],[11,"eq","","",79,{"inputs":[{"name":"self"},{"name":"typarambound"}],"output":{"name":"bool"}}],[11,"ne","","",79,{"inputs":[{"name":"self"},{"name":"typarambound"}],"output":{"name":"bool"}}],[11,"encode","","",79,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",79,{"inputs":[{"name":"__d"}],"output":{"generics":["typarambound"],"name":"result"}}],[11,"hash","","",79,null],[11,"fmt","","",79,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"span","","",79,{"inputs":[{"name":"self"}],"output":{"name":"span"}}],[11,"clone","","",80,{"inputs":[{"name":"self"}],"output":{"name":"traitboundmodifier"}}],[11,"eq","","",80,{"inputs":[{"name":"self"},{"name":"traitboundmodifier"}],"output":{"name":"bool"}}],[11,"encode","","",80,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",80,{"inputs":[{"name":"__d"}],"output":{"generics":["traitboundmodifier"],"name":"result"}}],[11,"hash","","",80,null],[11,"fmt","","",80,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",30,{"inputs":[{"name":"self"}],"output":{"name":"typaram"}}],[11,"eq","","",30,{"inputs":[{"name":"self"},{"name":"typaram"}],"output":{"name":"bool"}}],[11,"ne","","",30,{"inputs":[{"name":"self"},{"name":"typaram"}],"output":{"name":"bool"}}],[11,"encode","","",30,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",30,{"inputs":[{"name":"__d"}],"output":{"generics":["typaram"],"name":"result"}}],[11,"hash","","",30,null],[11,"fmt","","",30,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",81,{"inputs":[{"name":"self"}],"output":{"name":"genericparam"}}],[11,"eq","","",81,{"inputs":[{"name":"self"},{"name":"genericparam"}],"output":{"name":"bool"}}],[11,"ne","","",81,{"inputs":[{"name":"self"},{"name":"genericparam"}],"output":{"name":"bool"}}],[11,"encode","","",81,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",81,{"inputs":[{"name":"__d"}],"output":{"generics":["genericparam"],"name":"result"}}],[11,"hash","","",81,null],[11,"fmt","","",81,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"is_lifetime_param","","",81,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_type_param","","",81,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",31,{"inputs":[{"name":"self"}],"output":{"name":"generics"}}],[11,"eq","","",31,{"inputs":[{"name":"self"},{"name":"generics"}],"output":{"name":"bool"}}],[11,"ne","","",31,{"inputs":[{"name":"self"},{"name":"generics"}],"output":{"name":"bool"}}],[11,"encode","","",31,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",31,{"inputs":[{"name":"__d"}],"output":{"generics":["generics"],"name":"result"}}],[11,"hash","","",31,null],[11,"fmt","","",31,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"empty","","",31,{"inputs":[],"output":{"name":"generics"}}],[11,"is_lt_parameterized","","",31,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_type_parameterized","","",31,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"lifetimes","","",31,null],[11,"ty_params","","",31,null],[11,"attr_name","","",82,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"carries_unsafe_attr","","",31,{"inputs":[{"name":"self"}],"output":{"generics":["unsafegeneric"],"name":"option"}}],[11,"clone","","",83,{"inputs":[{"name":"self"}],"output":{"name":"synthetictyparamkind"}}],[11,"eq","","",83,{"inputs":[{"name":"self"},{"name":"synthetictyparamkind"}],"output":{"name":"bool"}}],[11,"encode","","",83,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",83,{"inputs":[{"name":"__d"}],"output":{"generics":["synthetictyparamkind"],"name":"result"}}],[11,"hash","","",83,null],[11,"fmt","","",83,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",32,{"inputs":[{"name":"self"}],"output":{"name":"whereclause"}}],[11,"eq","","",32,{"inputs":[{"name":"self"},{"name":"whereclause"}],"output":{"name":"bool"}}],[11,"ne","","",32,{"inputs":[{"name":"self"},{"name":"whereclause"}],"output":{"name":"bool"}}],[11,"encode","","",32,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",32,{"inputs":[{"name":"__d"}],"output":{"generics":["whereclause"],"name":"result"}}],[11,"hash","","",32,null],[11,"fmt","","",32,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",84,{"inputs":[{"name":"self"}],"output":{"name":"wherepredicate"}}],[11,"eq","","",84,{"inputs":[{"name":"self"},{"name":"wherepredicate"}],"output":{"name":"bool"}}],[11,"ne","","",84,{"inputs":[{"name":"self"},{"name":"wherepredicate"}],"output":{"name":"bool"}}],[11,"encode","","",84,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",84,{"inputs":[{"name":"__d"}],"output":{"generics":["wherepredicate"],"name":"result"}}],[11,"hash","","",84,null],[11,"fmt","","",84,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"span","","",84,{"inputs":[{"name":"self"}],"output":{"name":"span"}}],[11,"clone","","",33,{"inputs":[{"name":"self"}],"output":{"name":"whereboundpredicate"}}],[11,"eq","","",33,{"inputs":[{"name":"self"},{"name":"whereboundpredicate"}],"output":{"name":"bool"}}],[11,"ne","","",33,{"inputs":[{"name":"self"},{"name":"whereboundpredicate"}],"output":{"name":"bool"}}],[11,"encode","","",33,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",33,{"inputs":[{"name":"__d"}],"output":{"generics":["whereboundpredicate"],"name":"result"}}],[11,"hash","","",33,null],[11,"fmt","","",33,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",34,{"inputs":[{"name":"self"}],"output":{"name":"whereregionpredicate"}}],[11,"eq","","",34,{"inputs":[{"name":"self"},{"name":"whereregionpredicate"}],"output":{"name":"bool"}}],[11,"ne","","",34,{"inputs":[{"name":"self"},{"name":"whereregionpredicate"}],"output":{"name":"bool"}}],[11,"encode","","",34,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",34,{"inputs":[{"name":"__d"}],"output":{"generics":["whereregionpredicate"],"name":"result"}}],[11,"hash","","",34,null],[11,"fmt","","",34,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",35,{"inputs":[{"name":"self"}],"output":{"name":"whereeqpredicate"}}],[11,"eq","","",35,{"inputs":[{"name":"self"},{"name":"whereeqpredicate"}],"output":{"name":"bool"}}],[11,"ne","","",35,{"inputs":[{"name":"self"},{"name":"whereeqpredicate"}],"output":{"name":"bool"}}],[11,"encode","","",35,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",35,{"inputs":[{"name":"__d"}],"output":{"generics":["whereeqpredicate"],"name":"result"}}],[11,"hash","","",35,null],[11,"fmt","","",35,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",36,{"inputs":[{"name":"self"}],"output":{"name":"crate"}}],[11,"eq","","",36,{"inputs":[{"name":"self"},{"name":"crate"}],"output":{"name":"bool"}}],[11,"ne","","",36,{"inputs":[{"name":"self"},{"name":"crate"}],"output":{"name":"bool"}}],[11,"encode","","",36,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",36,{"inputs":[{"name":"__d"}],"output":{"generics":["crate"],"name":"result"}}],[11,"fmt","","",36,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"item","","",36,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"item"}}],[11,"trait_item","","",36,{"inputs":[{"name":"self"},{"name":"traititemid"}],"output":{"name":"traititem"}}],[11,"impl_item","","",36,{"inputs":[{"name":"self"},{"name":"implitemid"}],"output":{"name":"implitem"}}],[11,"visit_all_item_likes","","Visits all items in the crate in some deterministic (but unspecified) order. If you just need to process every item, but don't care about nesting, this method is the best choice.",36,{"inputs":[{"name":"self"},{"name":"v"}],"output":null}],[11,"body","","",36,{"inputs":[{"name":"self"},{"name":"bodyid"}],"output":{"name":"body"}}],[11,"clone","","",37,{"inputs":[{"name":"self"}],"output":{"name":"macrodef"}}],[11,"eq","","",37,{"inputs":[{"name":"self"},{"name":"macrodef"}],"output":{"name":"bool"}}],[11,"ne","","",37,{"inputs":[{"name":"self"},{"name":"macrodef"}],"output":{"name":"bool"}}],[11,"encode","","",37,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",37,{"inputs":[{"name":"__d"}],"output":{"generics":["macrodef"],"name":"result"}}],[11,"hash","","",37,null],[11,"fmt","","",37,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",38,{"inputs":[{"name":"self"}],"output":{"name":"block"}}],[11,"eq","","",38,{"inputs":[{"name":"self"},{"name":"block"}],"output":{"name":"bool"}}],[11,"ne","","",38,{"inputs":[{"name":"self"},{"name":"block"}],"output":{"name":"bool"}}],[11,"encode","","",38,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",38,{"inputs":[{"name":"__d"}],"output":{"generics":["block"],"name":"result"}}],[11,"hash","","",38,null],[11,"fmt","","",38,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",39,{"inputs":[{"name":"self"}],"output":{"name":"pat"}}],[11,"eq","","",39,{"inputs":[{"name":"self"},{"name":"pat"}],"output":{"name":"bool"}}],[11,"ne","","",39,{"inputs":[{"name":"self"},{"name":"pat"}],"output":{"name":"bool"}}],[11,"encode","","",39,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",39,{"inputs":[{"name":"__d"}],"output":{"generics":["pat"],"name":"result"}}],[11,"hash","","",39,null],[11,"fmt","","",39,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"walk","","",39,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"clone","","",40,{"inputs":[{"name":"self"}],"output":{"name":"fieldpat"}}],[11,"eq","","",40,{"inputs":[{"name":"self"},{"name":"fieldpat"}],"output":{"name":"bool"}}],[11,"ne","","",40,{"inputs":[{"name":"self"},{"name":"fieldpat"}],"output":{"name":"bool"}}],[11,"encode","","",40,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",40,{"inputs":[{"name":"__d"}],"output":{"generics":["fieldpat"],"name":"result"}}],[11,"hash","","",40,null],[11,"fmt","","",40,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",85,{"inputs":[{"name":"self"}],"output":{"name":"bindingannotation"}}],[11,"eq","","",85,{"inputs":[{"name":"self"},{"name":"bindingannotation"}],"output":{"name":"bool"}}],[11,"encode","","",85,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",85,{"inputs":[{"name":"__d"}],"output":{"generics":["bindingannotation"],"name":"result"}}],[11,"hash","","",85,null],[11,"fmt","","",85,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",86,{"inputs":[{"name":"self"}],"output":{"name":"rangeend"}}],[11,"eq","","",86,{"inputs":[{"name":"self"},{"name":"rangeend"}],"output":{"name":"bool"}}],[11,"encode","","",86,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",86,{"inputs":[{"name":"__d"}],"output":{"generics":["rangeend"],"name":"result"}}],[11,"hash","","",86,null],[11,"fmt","","",86,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",87,{"inputs":[{"name":"self"}],"output":{"name":"patkind"}}],[11,"eq","","",87,{"inputs":[{"name":"self"},{"name":"patkind"}],"output":{"name":"bool"}}],[11,"ne","","",87,{"inputs":[{"name":"self"},{"name":"patkind"}],"output":{"name":"bool"}}],[11,"encode","","",87,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",87,{"inputs":[{"name":"__d"}],"output":{"generics":["patkind"],"name":"result"}}],[11,"hash","","",87,null],[11,"fmt","","",87,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",88,{"inputs":[{"name":"self"}],"output":{"name":"mutability"}}],[11,"eq","","",88,{"inputs":[{"name":"self"},{"name":"mutability"}],"output":{"name":"bool"}}],[11,"encode","","",88,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",88,{"inputs":[{"name":"__d"}],"output":{"generics":["mutability"],"name":"result"}}],[11,"hash","","",88,null],[11,"fmt","","",88,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"and","","Return MutMutable only if both arguments are mutable.",88,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"self"}}],[11,"clone","","",89,{"inputs":[{"name":"self"}],"output":{"name":"binop_"}}],[11,"eq","","",89,{"inputs":[{"name":"self"},{"name":"binop_"}],"output":{"name":"bool"}}],[11,"encode","","",89,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",89,{"inputs":[{"name":"__d"}],"output":{"generics":["binop_"],"name":"result"}}],[11,"hash","","",89,null],[11,"fmt","","",89,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"as_str","","",89,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"is_lazy","","",89,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_shift","","",89,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_comparison","","",89,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_by_value","","Returns `true` if the binary operator takes its arguments by value",89,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"into","","",89,{"inputs":[{"name":"self"}],"output":{"name":"binopkind"}}],[11,"clone","","",90,{"inputs":[{"name":"self"}],"output":{"name":"unop"}}],[11,"eq","","",90,{"inputs":[{"name":"self"},{"name":"unop"}],"output":{"name":"bool"}}],[11,"encode","","",90,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",90,{"inputs":[{"name":"__d"}],"output":{"generics":["unop"],"name":"result"}}],[11,"hash","","",90,null],[11,"fmt","","",90,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"as_str","","",90,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"is_by_value","","Returns `true` if the unary operator takes its argument by value",90,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"fmt","","",91,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",91,{"inputs":[{"name":"self"}],"output":{"name":"stmt_"}}],[11,"eq","","",91,{"inputs":[{"name":"self"},{"name":"stmt_"}],"output":{"name":"bool"}}],[11,"ne","","",91,{"inputs":[{"name":"self"},{"name":"stmt_"}],"output":{"name":"bool"}}],[11,"encode","","",91,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",91,{"inputs":[{"name":"__d"}],"output":{"generics":["stmt_"],"name":"result"}}],[11,"hash","","",91,null],[11,"attrs","","",91,null],[11,"id","","",91,{"inputs":[{"name":"self"}],"output":{"name":"nodeid"}}],[11,"clone","","",41,{"inputs":[{"name":"self"}],"output":{"name":"local"}}],[11,"eq","","",41,{"inputs":[{"name":"self"},{"name":"local"}],"output":{"name":"bool"}}],[11,"ne","","",41,{"inputs":[{"name":"self"},{"name":"local"}],"output":{"name":"bool"}}],[11,"encode","","",41,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",41,{"inputs":[{"name":"__d"}],"output":{"generics":["local"],"name":"result"}}],[11,"hash","","",41,null],[11,"fmt","","",41,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",92,{"inputs":[{"name":"self"}],"output":{"name":"decl_"}}],[11,"eq","","",92,{"inputs":[{"name":"self"},{"name":"decl_"}],"output":{"name":"bool"}}],[11,"ne","","",92,{"inputs":[{"name":"self"},{"name":"decl_"}],"output":{"name":"bool"}}],[11,"encode","","",92,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",92,{"inputs":[{"name":"__d"}],"output":{"generics":["decl_"],"name":"result"}}],[11,"hash","","",92,null],[11,"fmt","","",92,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"attrs","","",92,null],[11,"is_local","","",92,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",42,{"inputs":[{"name":"self"}],"output":{"name":"arm"}}],[11,"eq","","",42,{"inputs":[{"name":"self"},{"name":"arm"}],"output":{"name":"bool"}}],[11,"ne","","",42,{"inputs":[{"name":"self"},{"name":"arm"}],"output":{"name":"bool"}}],[11,"encode","","",42,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",42,{"inputs":[{"name":"__d"}],"output":{"generics":["arm"],"name":"result"}}],[11,"hash","","",42,null],[11,"fmt","","",42,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",43,{"inputs":[{"name":"self"}],"output":{"name":"field"}}],[11,"eq","","",43,{"inputs":[{"name":"self"},{"name":"field"}],"output":{"name":"bool"}}],[11,"ne","","",43,{"inputs":[{"name":"self"},{"name":"field"}],"output":{"name":"bool"}}],[11,"encode","","",43,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",43,{"inputs":[{"name":"__d"}],"output":{"generics":["field"],"name":"result"}}],[11,"hash","","",43,null],[11,"fmt","","",43,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",93,{"inputs":[{"name":"self"}],"output":{"name":"blockcheckmode"}}],[11,"eq","","",93,{"inputs":[{"name":"self"},{"name":"blockcheckmode"}],"output":{"name":"bool"}}],[11,"ne","","",93,{"inputs":[{"name":"self"},{"name":"blockcheckmode"}],"output":{"name":"bool"}}],[11,"encode","","",93,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",93,{"inputs":[{"name":"__d"}],"output":{"generics":["blockcheckmode"],"name":"result"}}],[11,"hash","","",93,null],[11,"fmt","","",93,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",94,{"inputs":[{"name":"self"}],"output":{"name":"unsafesource"}}],[11,"eq","","",94,{"inputs":[{"name":"self"},{"name":"unsafesource"}],"output":{"name":"bool"}}],[11,"encode","","",94,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",94,{"inputs":[{"name":"__d"}],"output":{"generics":["unsafesource"],"name":"result"}}],[11,"hash","","",94,null],[11,"fmt","","",94,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",44,{"inputs":[{"name":"self"}],"output":{"name":"bodyid"}}],[11,"eq","","",44,{"inputs":[{"name":"self"},{"name":"bodyid"}],"output":{"name":"bool"}}],[11,"ne","","",44,{"inputs":[{"name":"self"},{"name":"bodyid"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",44,{"inputs":[{"name":"self"},{"name":"bodyid"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",44,{"inputs":[{"name":"self"},{"name":"bodyid"}],"output":{"name":"bool"}}],[11,"le","","",44,{"inputs":[{"name":"self"},{"name":"bodyid"}],"output":{"name":"bool"}}],[11,"gt","","",44,{"inputs":[{"name":"self"},{"name":"bodyid"}],"output":{"name":"bool"}}],[11,"ge","","",44,{"inputs":[{"name":"self"},{"name":"bodyid"}],"output":{"name":"bool"}}],[11,"cmp","","",44,{"inputs":[{"name":"self"},{"name":"bodyid"}],"output":{"name":"ordering"}}],[11,"encode","","",44,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",44,{"inputs":[{"name":"__d"}],"output":{"generics":["bodyid"],"name":"result"}}],[11,"hash","","",44,null],[11,"fmt","","",44,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",45,{"inputs":[{"name":"self"}],"output":{"name":"body"}}],[11,"eq","","",45,{"inputs":[{"name":"self"},{"name":"body"}],"output":{"name":"bool"}}],[11,"ne","","",45,{"inputs":[{"name":"self"},{"name":"body"}],"output":{"name":"bool"}}],[11,"encode","","",45,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",45,{"inputs":[{"name":"__d"}],"output":{"generics":["body"],"name":"result"}}],[11,"hash","","",45,null],[11,"fmt","","",45,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"id","","",45,{"inputs":[{"name":"self"}],"output":{"name":"bodyid"}}],[11,"clone","","",95,{"inputs":[{"name":"self"}],"output":{"name":"bodyownerkind"}}],[11,"fmt","","",95,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",46,{"inputs":[{"name":"self"}],"output":{"name":"expr"}}],[11,"eq","","",46,{"inputs":[{"name":"self"},{"name":"expr"}],"output":{"name":"bool"}}],[11,"ne","","",46,{"inputs":[{"name":"self"},{"name":"expr"}],"output":{"name":"bool"}}],[11,"encode","","",46,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",46,{"inputs":[{"name":"__d"}],"output":{"generics":["expr"],"name":"result"}}],[11,"hash","","",46,null],[11,"precedence","","",46,{"inputs":[{"name":"self"}],"output":{"name":"exprprecedence"}}],[11,"fmt","","",46,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",96,{"inputs":[{"name":"self"}],"output":{"name":"expr_"}}],[11,"eq","","",96,{"inputs":[{"name":"self"},{"name":"expr_"}],"output":{"name":"bool"}}],[11,"ne","","",96,{"inputs":[{"name":"self"},{"name":"expr_"}],"output":{"name":"bool"}}],[11,"encode","","",96,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",96,{"inputs":[{"name":"__d"}],"output":{"generics":["expr_"],"name":"result"}}],[11,"hash","","",96,null],[11,"fmt","","",96,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",97,{"inputs":[{"name":"self"}],"output":{"name":"qpath"}}],[11,"eq","","",97,{"inputs":[{"name":"self"},{"name":"qpath"}],"output":{"name":"bool"}}],[11,"ne","","",97,{"inputs":[{"name":"self"},{"name":"qpath"}],"output":{"name":"bool"}}],[11,"encode","","",97,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",97,{"inputs":[{"name":"__d"}],"output":{"generics":["qpath"],"name":"result"}}],[11,"hash","","",97,null],[11,"fmt","","",97,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",98,{"inputs":[{"name":"self"}],"output":{"name":"localsource"}}],[11,"eq","","",98,{"inputs":[{"name":"self"},{"name":"localsource"}],"output":{"name":"bool"}}],[11,"encode","","",98,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",98,{"inputs":[{"name":"__d"}],"output":{"generics":["localsource"],"name":"result"}}],[11,"hash","","",98,null],[11,"fmt","","",98,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",99,{"inputs":[{"name":"self"}],"output":{"name":"matchsource"}}],[11,"eq","","",99,{"inputs":[{"name":"self"},{"name":"matchsource"}],"output":{"name":"bool"}}],[11,"ne","","",99,{"inputs":[{"name":"self"},{"name":"matchsource"}],"output":{"name":"bool"}}],[11,"encode","","",99,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",99,{"inputs":[{"name":"__d"}],"output":{"generics":["matchsource"],"name":"result"}}],[11,"hash","","",99,null],[11,"fmt","","",99,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",100,{"inputs":[{"name":"self"}],"output":{"name":"loopsource"}}],[11,"eq","","",100,{"inputs":[{"name":"self"},{"name":"loopsource"}],"output":{"name":"bool"}}],[11,"encode","","",100,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",100,{"inputs":[{"name":"__d"}],"output":{"generics":["loopsource"],"name":"result"}}],[11,"hash","","",100,null],[11,"fmt","","",100,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",101,{"inputs":[{"name":"self"}],"output":{"name":"loopiderror"}}],[11,"eq","","",101,{"inputs":[{"name":"self"},{"name":"loopiderror"}],"output":{"name":"bool"}}],[11,"encode","","",101,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",101,{"inputs":[{"name":"__d"}],"output":{"generics":["loopiderror"],"name":"result"}}],[11,"hash","","",101,null],[11,"fmt","","",101,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",101,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",102,{"inputs":[{"name":"self"}],"output":{"name":"loopidresult"}}],[11,"eq","","",102,{"inputs":[{"name":"self"},{"name":"loopidresult"}],"output":{"name":"bool"}}],[11,"ne","","",102,{"inputs":[{"name":"self"},{"name":"loopidresult"}],"output":{"name":"bool"}}],[11,"encode","","",102,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",102,{"inputs":[{"name":"__d"}],"output":{"generics":["loopidresult"],"name":"result"}}],[11,"hash","","",102,null],[11,"fmt","","",102,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"into","","",102,{"inputs":[{"name":"self"}],"output":{"generics":["nodeid","loopiderror"],"name":"result"}}],[11,"from","","",102,{"inputs":[{"generics":["nodeid","loopiderror"],"name":"result"}],"output":{"name":"self"}}],[11,"clone","","",103,{"inputs":[{"name":"self"}],"output":{"name":"scopetarget"}}],[11,"eq","","",103,{"inputs":[{"name":"self"},{"name":"scopetarget"}],"output":{"name":"bool"}}],[11,"ne","","",103,{"inputs":[{"name":"self"},{"name":"scopetarget"}],"output":{"name":"bool"}}],[11,"encode","","",103,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",103,{"inputs":[{"name":"__d"}],"output":{"generics":["scopetarget"],"name":"result"}}],[11,"hash","","",103,null],[11,"fmt","","",103,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"opt_id","","",103,{"inputs":[{"name":"self"}],"output":{"generics":["nodeid"],"name":"option"}}],[11,"clone","","",47,{"inputs":[{"name":"self"}],"output":{"name":"destination"}}],[11,"eq","","",47,{"inputs":[{"name":"self"},{"name":"destination"}],"output":{"name":"bool"}}],[11,"ne","","",47,{"inputs":[{"name":"self"},{"name":"destination"}],"output":{"name":"bool"}}],[11,"encode","","",47,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",47,{"inputs":[{"name":"__d"}],"output":{"generics":["destination"],"name":"result"}}],[11,"hash","","",47,null],[11,"fmt","","",47,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",104,{"inputs":[{"name":"self"}],"output":{"name":"generatormovability"}}],[11,"eq","","",104,{"inputs":[{"name":"self"},{"name":"generatormovability"}],"output":{"name":"bool"}}],[11,"encode","","",104,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",104,{"inputs":[{"name":"__d"}],"output":{"generics":["generatormovability"],"name":"result"}}],[11,"hash","","",104,null],[11,"fmt","","",104,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",105,{"inputs":[{"name":"self"}],"output":{"name":"captureclause"}}],[11,"eq","","",105,{"inputs":[{"name":"self"},{"name":"captureclause"}],"output":{"name":"bool"}}],[11,"encode","","",105,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",105,{"inputs":[{"name":"__d"}],"output":{"generics":["captureclause"],"name":"result"}}],[11,"hash","","",105,null],[11,"fmt","","",105,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",48,{"inputs":[{"name":"self"}],"output":{"name":"mutty"}}],[11,"eq","","",48,{"inputs":[{"name":"self"},{"name":"mutty"}],"output":{"name":"bool"}}],[11,"ne","","",48,{"inputs":[{"name":"self"},{"name":"mutty"}],"output":{"name":"bool"}}],[11,"encode","","",48,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",48,{"inputs":[{"name":"__d"}],"output":{"generics":["mutty"],"name":"result"}}],[11,"hash","","",48,null],[11,"fmt","","",48,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",49,{"inputs":[{"name":"self"}],"output":{"name":"methodsig"}}],[11,"eq","","",49,{"inputs":[{"name":"self"},{"name":"methodsig"}],"output":{"name":"bool"}}],[11,"ne","","",49,{"inputs":[{"name":"self"},{"name":"methodsig"}],"output":{"name":"bool"}}],[11,"encode","","",49,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",49,{"inputs":[{"name":"__d"}],"output":{"generics":["methodsig"],"name":"result"}}],[11,"hash","","",49,null],[11,"fmt","","",49,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",50,{"inputs":[{"name":"self"}],"output":{"name":"traititemid"}}],[11,"eq","","",50,{"inputs":[{"name":"self"},{"name":"traititemid"}],"output":{"name":"bool"}}],[11,"ne","","",50,{"inputs":[{"name":"self"},{"name":"traititemid"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",50,{"inputs":[{"name":"self"},{"name":"traititemid"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",50,{"inputs":[{"name":"self"},{"name":"traititemid"}],"output":{"name":"bool"}}],[11,"le","","",50,{"inputs":[{"name":"self"},{"name":"traititemid"}],"output":{"name":"bool"}}],[11,"gt","","",50,{"inputs":[{"name":"self"},{"name":"traititemid"}],"output":{"name":"bool"}}],[11,"ge","","",50,{"inputs":[{"name":"self"},{"name":"traititemid"}],"output":{"name":"bool"}}],[11,"cmp","","",50,{"inputs":[{"name":"self"},{"name":"traititemid"}],"output":{"name":"ordering"}}],[11,"encode","","",50,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",50,{"inputs":[{"name":"__d"}],"output":{"generics":["traititemid"],"name":"result"}}],[11,"hash","","",50,null],[11,"fmt","","",50,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",51,{"inputs":[{"name":"self"}],"output":{"name":"traititem"}}],[11,"eq","","",51,{"inputs":[{"name":"self"},{"name":"traititem"}],"output":{"name":"bool"}}],[11,"ne","","",51,{"inputs":[{"name":"self"},{"name":"traititem"}],"output":{"name":"bool"}}],[11,"encode","","",51,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",51,{"inputs":[{"name":"__d"}],"output":{"generics":["traititem"],"name":"result"}}],[11,"hash","","",51,null],[11,"fmt","","",51,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",106,{"inputs":[{"name":"self"}],"output":{"name":"traitmethod"}}],[11,"eq","","",106,{"inputs":[{"name":"self"},{"name":"traitmethod"}],"output":{"name":"bool"}}],[11,"ne","","",106,{"inputs":[{"name":"self"},{"name":"traitmethod"}],"output":{"name":"bool"}}],[11,"encode","","",106,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",106,{"inputs":[{"name":"__d"}],"output":{"generics":["traitmethod"],"name":"result"}}],[11,"hash","","",106,null],[11,"fmt","","",106,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",107,{"inputs":[{"name":"self"}],"output":{"name":"traititemkind"}}],[11,"eq","","",107,{"inputs":[{"name":"self"},{"name":"traititemkind"}],"output":{"name":"bool"}}],[11,"ne","","",107,{"inputs":[{"name":"self"},{"name":"traititemkind"}],"output":{"name":"bool"}}],[11,"encode","","",107,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",107,{"inputs":[{"name":"__d"}],"output":{"generics":["traititemkind"],"name":"result"}}],[11,"hash","","",107,null],[11,"fmt","","",107,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",52,{"inputs":[{"name":"self"}],"output":{"name":"implitemid"}}],[11,"eq","","",52,{"inputs":[{"name":"self"},{"name":"implitemid"}],"output":{"name":"bool"}}],[11,"ne","","",52,{"inputs":[{"name":"self"},{"name":"implitemid"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",52,{"inputs":[{"name":"self"},{"name":"implitemid"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",52,{"inputs":[{"name":"self"},{"name":"implitemid"}],"output":{"name":"bool"}}],[11,"le","","",52,{"inputs":[{"name":"self"},{"name":"implitemid"}],"output":{"name":"bool"}}],[11,"gt","","",52,{"inputs":[{"name":"self"},{"name":"implitemid"}],"output":{"name":"bool"}}],[11,"ge","","",52,{"inputs":[{"name":"self"},{"name":"implitemid"}],"output":{"name":"bool"}}],[11,"cmp","","",52,{"inputs":[{"name":"self"},{"name":"implitemid"}],"output":{"name":"ordering"}}],[11,"encode","","",52,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",52,{"inputs":[{"name":"__d"}],"output":{"generics":["implitemid"],"name":"result"}}],[11,"hash","","",52,null],[11,"fmt","","",52,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",53,{"inputs":[{"name":"self"}],"output":{"name":"implitem"}}],[11,"eq","","",53,{"inputs":[{"name":"self"},{"name":"implitem"}],"output":{"name":"bool"}}],[11,"ne","","",53,{"inputs":[{"name":"self"},{"name":"implitem"}],"output":{"name":"bool"}}],[11,"encode","","",53,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",53,{"inputs":[{"name":"__d"}],"output":{"generics":["implitem"],"name":"result"}}],[11,"hash","","",53,null],[11,"fmt","","",53,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",108,{"inputs":[{"name":"self"}],"output":{"name":"implitemkind"}}],[11,"eq","","",108,{"inputs":[{"name":"self"},{"name":"implitemkind"}],"output":{"name":"bool"}}],[11,"ne","","",108,{"inputs":[{"name":"self"},{"name":"implitemkind"}],"output":{"name":"bool"}}],[11,"encode","","",108,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",108,{"inputs":[{"name":"__d"}],"output":{"generics":["implitemkind"],"name":"result"}}],[11,"hash","","",108,null],[11,"fmt","","",108,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",54,{"inputs":[{"name":"self"}],"output":{"name":"typebinding"}}],[11,"eq","","",54,{"inputs":[{"name":"self"},{"name":"typebinding"}],"output":{"name":"bool"}}],[11,"ne","","",54,{"inputs":[{"name":"self"},{"name":"typebinding"}],"output":{"name":"bool"}}],[11,"encode","","",54,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",54,{"inputs":[{"name":"__d"}],"output":{"generics":["typebinding"],"name":"result"}}],[11,"hash","","",54,null],[11,"fmt","","",54,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",55,{"inputs":[{"name":"self"}],"output":{"name":"ty"}}],[11,"eq","","",55,{"inputs":[{"name":"self"},{"name":"ty"}],"output":{"name":"bool"}}],[11,"ne","","",55,{"inputs":[{"name":"self"},{"name":"ty"}],"output":{"name":"bool"}}],[11,"encode","","",55,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",55,{"inputs":[{"name":"__d"}],"output":{"generics":["ty"],"name":"result"}}],[11,"hash","","",55,null],[11,"fmt","","",55,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",109,{"inputs":[{"name":"self"}],"output":{"name":"primty"}}],[11,"eq","","",109,{"inputs":[{"name":"self"},{"name":"primty"}],"output":{"name":"bool"}}],[11,"ne","","",109,{"inputs":[{"name":"self"},{"name":"primty"}],"output":{"name":"bool"}}],[11,"encode","","",109,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",109,{"inputs":[{"name":"__d"}],"output":{"generics":["primty"],"name":"result"}}],[11,"hash","","",109,null],[11,"fmt","","",109,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",56,{"inputs":[{"name":"self"}],"output":{"name":"barefnty"}}],[11,"eq","","",56,{"inputs":[{"name":"self"},{"name":"barefnty"}],"output":{"name":"bool"}}],[11,"ne","","",56,{"inputs":[{"name":"self"},{"name":"barefnty"}],"output":{"name":"bool"}}],[11,"encode","","",56,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",56,{"inputs":[{"name":"__d"}],"output":{"generics":["barefnty"],"name":"result"}}],[11,"hash","","",56,null],[11,"fmt","","",56,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",57,{"inputs":[{"name":"self"}],"output":{"name":"existty"}}],[11,"eq","","",57,{"inputs":[{"name":"self"},{"name":"existty"}],"output":{"name":"bool"}}],[11,"ne","","",57,{"inputs":[{"name":"self"},{"name":"existty"}],"output":{"name":"bool"}}],[11,"encode","","",57,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",57,{"inputs":[{"name":"__d"}],"output":{"generics":["existty"],"name":"result"}}],[11,"hash","","",57,null],[11,"fmt","","",57,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",110,{"inputs":[{"name":"self"}],"output":{"name":"ty_"}}],[11,"eq","","",110,{"inputs":[{"name":"self"},{"name":"ty_"}],"output":{"name":"bool"}}],[11,"ne","","",110,{"inputs":[{"name":"self"},{"name":"ty_"}],"output":{"name":"bool"}}],[11,"encode","","",110,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",110,{"inputs":[{"name":"__d"}],"output":{"generics":["ty_"],"name":"result"}}],[11,"hash","","",110,null],[11,"fmt","","",110,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",58,{"inputs":[{"name":"self"}],"output":{"name":"inlineasmoutput"}}],[11,"eq","","",58,{"inputs":[{"name":"self"},{"name":"inlineasmoutput"}],"output":{"name":"bool"}}],[11,"ne","","",58,{"inputs":[{"name":"self"},{"name":"inlineasmoutput"}],"output":{"name":"bool"}}],[11,"encode","","",58,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",58,{"inputs":[{"name":"__d"}],"output":{"generics":["inlineasmoutput"],"name":"result"}}],[11,"hash","","",58,null],[11,"fmt","","",58,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",59,{"inputs":[{"name":"self"}],"output":{"name":"inlineasm"}}],[11,"eq","","",59,{"inputs":[{"name":"self"},{"name":"inlineasm"}],"output":{"name":"bool"}}],[11,"ne","","",59,{"inputs":[{"name":"self"},{"name":"inlineasm"}],"output":{"name":"bool"}}],[11,"encode","","",59,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",59,{"inputs":[{"name":"__d"}],"output":{"generics":["inlineasm"],"name":"result"}}],[11,"hash","","",59,null],[11,"fmt","","",59,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",60,{"inputs":[{"name":"self"}],"output":{"name":"arg"}}],[11,"eq","","",60,{"inputs":[{"name":"self"},{"name":"arg"}],"output":{"name":"bool"}}],[11,"ne","","",60,{"inputs":[{"name":"self"},{"name":"arg"}],"output":{"name":"bool"}}],[11,"encode","","",60,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",60,{"inputs":[{"name":"__d"}],"output":{"generics":["arg"],"name":"result"}}],[11,"hash","","",60,null],[11,"fmt","","",60,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",61,{"inputs":[{"name":"self"}],"output":{"name":"fndecl"}}],[11,"eq","","",61,{"inputs":[{"name":"self"},{"name":"fndecl"}],"output":{"name":"bool"}}],[11,"ne","","",61,{"inputs":[{"name":"self"},{"name":"fndecl"}],"output":{"name":"bool"}}],[11,"encode","","",61,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",61,{"inputs":[{"name":"__d"}],"output":{"generics":["fndecl"],"name":"result"}}],[11,"hash","","",61,null],[11,"fmt","","",61,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",111,{"inputs":[{"name":"self"}],"output":{"name":"isauto"}}],[11,"eq","","",111,{"inputs":[{"name":"self"},{"name":"isauto"}],"output":{"name":"bool"}}],[11,"encode","","",111,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",111,{"inputs":[{"name":"__d"}],"output":{"generics":["isauto"],"name":"result"}}],[11,"hash","","",111,null],[11,"fmt","","",111,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",112,{"inputs":[{"name":"self"}],"output":{"name":"unsafety"}}],[11,"eq","","",112,{"inputs":[{"name":"self"},{"name":"unsafety"}],"output":{"name":"bool"}}],[11,"encode","","",112,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",112,{"inputs":[{"name":"__d"}],"output":{"generics":["unsafety"],"name":"result"}}],[11,"hash","","",112,null],[11,"fmt","","",112,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",113,{"inputs":[{"name":"self"}],"output":{"name":"constness"}}],[11,"eq","","",113,{"inputs":[{"name":"self"},{"name":"constness"}],"output":{"name":"bool"}}],[11,"encode","","",113,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",113,{"inputs":[{"name":"__d"}],"output":{"generics":["constness"],"name":"result"}}],[11,"hash","","",113,null],[11,"fmt","","",113,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",114,{"inputs":[{"name":"self"}],"output":{"name":"defaultness"}}],[11,"eq","","",114,{"inputs":[{"name":"self"},{"name":"defaultness"}],"output":{"name":"bool"}}],[11,"ne","","",114,{"inputs":[{"name":"self"},{"name":"defaultness"}],"output":{"name":"bool"}}],[11,"encode","","",114,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",114,{"inputs":[{"name":"__d"}],"output":{"generics":["defaultness"],"name":"result"}}],[11,"hash","","",114,null],[11,"fmt","","",114,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"has_value","","",114,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_final","","",114,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_default","","",114,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"fmt","","",112,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",115,{"inputs":[{"name":"self"}],"output":{"name":"implpolarity"}}],[11,"eq","","",115,{"inputs":[{"name":"self"},{"name":"implpolarity"}],"output":{"name":"bool"}}],[11,"encode","","",115,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",115,{"inputs":[{"name":"__d"}],"output":{"generics":["implpolarity"],"name":"result"}}],[11,"hash","","",115,null],[11,"fmt","","",115,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",116,{"inputs":[{"name":"self"}],"output":{"name":"functionretty"}}],[11,"eq","","",116,{"inputs":[{"name":"self"},{"name":"functionretty"}],"output":{"name":"bool"}}],[11,"ne","","",116,{"inputs":[{"name":"self"},{"name":"functionretty"}],"output":{"name":"bool"}}],[11,"encode","","",116,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",116,{"inputs":[{"name":"__d"}],"output":{"generics":["functionretty"],"name":"result"}}],[11,"hash","","",116,null],[11,"fmt","","",116,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"span","","",116,{"inputs":[{"name":"self"}],"output":{"name":"span"}}],[11,"clone","","",62,{"inputs":[{"name":"self"}],"output":{"name":"mod"}}],[11,"eq","","",62,{"inputs":[{"name":"self"},{"name":"mod"}],"output":{"name":"bool"}}],[11,"ne","","",62,{"inputs":[{"name":"self"},{"name":"mod"}],"output":{"name":"bool"}}],[11,"encode","","",62,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",62,{"inputs":[{"name":"__d"}],"output":{"generics":["mod"],"name":"result"}}],[11,"hash","","",62,null],[11,"fmt","","",62,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",63,{"inputs":[{"name":"self"}],"output":{"name":"foreignmod"}}],[11,"eq","","",63,{"inputs":[{"name":"self"},{"name":"foreignmod"}],"output":{"name":"bool"}}],[11,"ne","","",63,{"inputs":[{"name":"self"},{"name":"foreignmod"}],"output":{"name":"bool"}}],[11,"encode","","",63,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",63,{"inputs":[{"name":"__d"}],"output":{"generics":["foreignmod"],"name":"result"}}],[11,"hash","","",63,null],[11,"fmt","","",63,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",64,{"inputs":[{"name":"self"}],"output":{"name":"globalasm"}}],[11,"eq","","",64,{"inputs":[{"name":"self"},{"name":"globalasm"}],"output":{"name":"bool"}}],[11,"ne","","",64,{"inputs":[{"name":"self"},{"name":"globalasm"}],"output":{"name":"bool"}}],[11,"encode","","",64,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",64,{"inputs":[{"name":"__d"}],"output":{"generics":["globalasm"],"name":"result"}}],[11,"hash","","",64,null],[11,"fmt","","",64,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",65,{"inputs":[{"name":"self"}],"output":{"name":"enumdef"}}],[11,"eq","","",65,{"inputs":[{"name":"self"},{"name":"enumdef"}],"output":{"name":"bool"}}],[11,"ne","","",65,{"inputs":[{"name":"self"},{"name":"enumdef"}],"output":{"name":"bool"}}],[11,"encode","","",65,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",65,{"inputs":[{"name":"__d"}],"output":{"generics":["enumdef"],"name":"result"}}],[11,"hash","","",65,null],[11,"fmt","","",65,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",66,{"inputs":[{"name":"self"}],"output":{"name":"variant_"}}],[11,"eq","","",66,{"inputs":[{"name":"self"},{"name":"variant_"}],"output":{"name":"bool"}}],[11,"ne","","",66,{"inputs":[{"name":"self"},{"name":"variant_"}],"output":{"name":"bool"}}],[11,"encode","","",66,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",66,{"inputs":[{"name":"__d"}],"output":{"generics":["variant_"],"name":"result"}}],[11,"hash","","",66,null],[11,"fmt","","",66,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",117,{"inputs":[{"name":"self"}],"output":{"name":"usekind"}}],[11,"eq","","",117,{"inputs":[{"name":"self"},{"name":"usekind"}],"output":{"name":"bool"}}],[11,"encode","","",117,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",117,{"inputs":[{"name":"__d"}],"output":{"generics":["usekind"],"name":"result"}}],[11,"hash","","",117,null],[11,"fmt","","",117,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",67,{"inputs":[{"name":"self"}],"output":{"name":"traitref"}}],[11,"eq","","",67,{"inputs":[{"name":"self"},{"name":"traitref"}],"output":{"name":"bool"}}],[11,"ne","","",67,{"inputs":[{"name":"self"},{"name":"traitref"}],"output":{"name":"bool"}}],[11,"encode","","",67,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",67,{"inputs":[{"name":"__d"}],"output":{"generics":["traitref"],"name":"result"}}],[11,"hash","","",67,null],[11,"fmt","","",67,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",68,{"inputs":[{"name":"self"}],"output":{"name":"polytraitref"}}],[11,"eq","","",68,{"inputs":[{"name":"self"},{"name":"polytraitref"}],"output":{"name":"bool"}}],[11,"ne","","",68,{"inputs":[{"name":"self"},{"name":"polytraitref"}],"output":{"name":"bool"}}],[11,"encode","","",68,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",68,{"inputs":[{"name":"__d"}],"output":{"generics":["polytraitref"],"name":"result"}}],[11,"hash","","",68,null],[11,"fmt","","",68,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",118,{"inputs":[{"name":"self"}],"output":{"name":"visibility"}}],[11,"eq","","",118,{"inputs":[{"name":"self"},{"name":"visibility"}],"output":{"name":"bool"}}],[11,"ne","","",118,{"inputs":[{"name":"self"},{"name":"visibility"}],"output":{"name":"bool"}}],[11,"encode","","",118,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",118,{"inputs":[{"name":"__d"}],"output":{"generics":["visibility"],"name":"result"}}],[11,"hash","","",118,null],[11,"fmt","","",118,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"is_pub_restricted","","",118,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",69,{"inputs":[{"name":"self"}],"output":{"name":"structfield"}}],[11,"eq","","",69,{"inputs":[{"name":"self"},{"name":"structfield"}],"output":{"name":"bool"}}],[11,"ne","","",69,{"inputs":[{"name":"self"},{"name":"structfield"}],"output":{"name":"bool"}}],[11,"encode","","",69,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",69,{"inputs":[{"name":"__d"}],"output":{"generics":["structfield"],"name":"result"}}],[11,"hash","","",69,null],[11,"fmt","","",69,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"is_positional","","",69,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",119,{"inputs":[{"name":"self"}],"output":{"name":"variantdata"}}],[11,"eq","","",119,{"inputs":[{"name":"self"},{"name":"variantdata"}],"output":{"name":"bool"}}],[11,"ne","","",119,{"inputs":[{"name":"self"},{"name":"variantdata"}],"output":{"name":"bool"}}],[11,"encode","","",119,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",119,{"inputs":[{"name":"__d"}],"output":{"generics":["variantdata"],"name":"result"}}],[11,"hash","","",119,null],[11,"fmt","","",119,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fields","","",119,null],[11,"id","","",119,{"inputs":[{"name":"self"}],"output":{"name":"nodeid"}}],[11,"is_struct","","",119,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_tuple","","",119,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_unit","","",119,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",70,{"inputs":[{"name":"self"}],"output":{"name":"itemid"}}],[11,"eq","","",70,{"inputs":[{"name":"self"},{"name":"itemid"}],"output":{"name":"bool"}}],[11,"ne","","",70,{"inputs":[{"name":"self"},{"name":"itemid"}],"output":{"name":"bool"}}],[11,"encode","","",70,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",70,{"inputs":[{"name":"__d"}],"output":{"generics":["itemid"],"name":"result"}}],[11,"hash","","",70,null],[11,"fmt","","",70,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",71,{"inputs":[{"name":"self"}],"output":{"name":"item"}}],[11,"eq","","",71,{"inputs":[{"name":"self"},{"name":"item"}],"output":{"name":"bool"}}],[11,"ne","","",71,{"inputs":[{"name":"self"},{"name":"item"}],"output":{"name":"bool"}}],[11,"encode","","",71,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",71,{"inputs":[{"name":"__d"}],"output":{"generics":["item"],"name":"result"}}],[11,"hash","","",71,null],[11,"fmt","","",71,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",120,{"inputs":[{"name":"self"}],"output":{"name":"item_"}}],[11,"eq","","",120,{"inputs":[{"name":"self"},{"name":"item_"}],"output":{"name":"bool"}}],[11,"ne","","",120,{"inputs":[{"name":"self"},{"name":"item_"}],"output":{"name":"bool"}}],[11,"encode","","",120,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",120,{"inputs":[{"name":"__d"}],"output":{"generics":["item_"],"name":"result"}}],[11,"hash","","",120,null],[11,"fmt","","",120,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"descriptive_variant","","",120,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"adt_kind","","",120,{"inputs":[{"name":"self"}],"output":{"generics":["adtkind"],"name":"option"}}],[11,"generics","","",120,{"inputs":[{"name":"self"}],"output":{"generics":["generics"],"name":"option"}}],[11,"clone","","",72,{"inputs":[{"name":"self"}],"output":{"name":"traititemref"}}],[11,"eq","","",72,{"inputs":[{"name":"self"},{"name":"traititemref"}],"output":{"name":"bool"}}],[11,"ne","","",72,{"inputs":[{"name":"self"},{"name":"traititemref"}],"output":{"name":"bool"}}],[11,"encode","","",72,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",72,{"inputs":[{"name":"__d"}],"output":{"generics":["traititemref"],"name":"result"}}],[11,"hash","","",72,null],[11,"fmt","","",72,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",73,{"inputs":[{"name":"self"}],"output":{"name":"implitemref"}}],[11,"eq","","",73,{"inputs":[{"name":"self"},{"name":"implitemref"}],"output":{"name":"bool"}}],[11,"ne","","",73,{"inputs":[{"name":"self"},{"name":"implitemref"}],"output":{"name":"bool"}}],[11,"encode","","",73,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",73,{"inputs":[{"name":"__d"}],"output":{"generics":["implitemref"],"name":"result"}}],[11,"hash","","",73,null],[11,"fmt","","",73,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",121,{"inputs":[{"name":"self"}],"output":{"name":"associateditemkind"}}],[11,"eq","","",121,{"inputs":[{"name":"self"},{"name":"associateditemkind"}],"output":{"name":"bool"}}],[11,"ne","","",121,{"inputs":[{"name":"self"},{"name":"associateditemkind"}],"output":{"name":"bool"}}],[11,"encode","","",121,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",121,{"inputs":[{"name":"__d"}],"output":{"generics":["associateditemkind"],"name":"result"}}],[11,"hash","","",121,null],[11,"fmt","","",121,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",74,{"inputs":[{"name":"self"}],"output":{"name":"foreignitem"}}],[11,"eq","","",74,{"inputs":[{"name":"self"},{"name":"foreignitem"}],"output":{"name":"bool"}}],[11,"ne","","",74,{"inputs":[{"name":"self"},{"name":"foreignitem"}],"output":{"name":"bool"}}],[11,"encode","","",74,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",74,{"inputs":[{"name":"__d"}],"output":{"generics":["foreignitem"],"name":"result"}}],[11,"hash","","",74,null],[11,"fmt","","",74,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",122,{"inputs":[{"name":"self"}],"output":{"name":"foreignitem_"}}],[11,"eq","","",122,{"inputs":[{"name":"self"},{"name":"foreignitem_"}],"output":{"name":"bool"}}],[11,"ne","","",122,{"inputs":[{"name":"self"},{"name":"foreignitem_"}],"output":{"name":"bool"}}],[11,"encode","","",122,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",122,{"inputs":[{"name":"__d"}],"output":{"generics":["foreignitem_"],"name":"result"}}],[11,"hash","","",122,null],[11,"fmt","","",122,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"descriptive_variant","","",122,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"fmt","","",75,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",75,{"inputs":[{"name":"self"}],"output":{"name":"freevar"}}],[11,"encode","","",75,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",75,{"inputs":[{"name":"__d"}],"output":{"generics":["freevar"],"name":"result"}}],[11,"var_id","","",75,{"inputs":[{"name":"self"}],"output":{"name":"nodeid"}}],[11,"clone","","",76,{"inputs":[{"name":"self"}],"output":{"name":"traitcandidate"}}],[11,"fmt","","",76,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",77,{"inputs":[{"name":"self"}],"output":{"name":"transfnattrs"}}],[11,"encode","","",77,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",77,{"inputs":[{"name":"__d"}],"output":{"generics":["transfnattrs"],"name":"result"}}],[11,"hash","","",77,null],[11,"eq","","",166,{"inputs":[{"name":"self"},{"name":"transfnattrflags"}],"output":{"name":"bool"}}],[11,"ne","","",166,{"inputs":[{"name":"self"},{"name":"transfnattrflags"}],"output":{"name":"bool"}}],[11,"clone","","",166,{"inputs":[{"name":"self"}],"output":{"name":"transfnattrflags"}}],[11,"partial_cmp","","",166,{"inputs":[{"name":"self"},{"name":"transfnattrflags"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",166,{"inputs":[{"name":"self"},{"name":"transfnattrflags"}],"output":{"name":"bool"}}],[11,"le","","",166,{"inputs":[{"name":"self"},{"name":"transfnattrflags"}],"output":{"name":"bool"}}],[11,"gt","","",166,{"inputs":[{"name":"self"},{"name":"transfnattrflags"}],"output":{"name":"bool"}}],[11,"ge","","",166,{"inputs":[{"name":"self"},{"name":"transfnattrflags"}],"output":{"name":"bool"}}],[11,"cmp","","",166,{"inputs":[{"name":"self"},{"name":"transfnattrflags"}],"output":{"name":"ordering"}}],[11,"hash","","",166,null],[11,"encode","","",166,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",166,{"inputs":[{"name":"__d"}],"output":{"generics":["transfnattrflags"],"name":"result"}}],[11,"fmt","","",166,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",166,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",166,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",166,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",166,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[18,"COLD","","",166,null],[18,"ALLOCATOR","","",166,null],[18,"UNWIND","","",166,null],[18,"RUSTC_ALLOCATOR_NOUNWIND","","",166,null],[18,"NAKED","","",166,null],[18,"NO_MANGLE","","",166,null],[18,"RUSTC_STD_INTERNAL_SYMBOL","","",166,null],[18,"NO_DEBUG","","",166,null],[11,"empty","","Returns an empty set of flags.",166,{"inputs":[],"output":{"name":"transfnattrflags"}}],[11,"all","","Returns the set containing all flags.",166,{"inputs":[],"output":{"name":"transfnattrflags"}}],[11,"bits","","Returns the raw value of the flags currently stored.",166,{"inputs":[{"name":"self"}],"output":{"name":"u8"}}],[11,"from_bits","","Convert from underlying bit representation, unless that representation contains bits that do not correspond to a flag.",166,{"inputs":[{"name":"u8"}],"output":{"generics":["transfnattrflags"],"name":"option"}}],[11,"from_bits_truncate","","Convert from underlying bit representation, dropping any bits that do not correspond to flags.",166,{"inputs":[{"name":"u8"}],"output":{"name":"transfnattrflags"}}],[11,"is_empty","","Returns `true` if no flags are currently stored.",166,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_all","","Returns `true` if all flags are currently set.",166,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"intersects","","Returns `true` if there are flags common to both `self` and `other`.",166,{"inputs":[{"name":"self"},{"name":"transfnattrflags"}],"output":{"name":"bool"}}],[11,"contains","","Returns `true` all of the flags in `other` are contained within `self`.",166,{"inputs":[{"name":"self"},{"name":"transfnattrflags"}],"output":{"name":"bool"}}],[11,"insert","","Inserts the specified flags in-place.",166,{"inputs":[{"name":"self"},{"name":"transfnattrflags"}],"output":null}],[11,"remove","","Removes the specified flags in-place.",166,{"inputs":[{"name":"self"},{"name":"transfnattrflags"}],"output":null}],[11,"toggle","","Toggles the specified flags in-place.",166,{"inputs":[{"name":"self"},{"name":"transfnattrflags"}],"output":null}],[11,"set","","Inserts or removes the specified flags depending on the passed value.",166,{"inputs":[{"name":"self"},{"name":"transfnattrflags"},{"name":"bool"}],"output":null}],[11,"bitor","","Returns the union of the two sets of flags.",166,{"inputs":[{"name":"self"},{"name":"transfnattrflags"}],"output":{"name":"transfnattrflags"}}],[11,"bitor_assign","","Adds the set of flags.",166,{"inputs":[{"name":"self"},{"name":"transfnattrflags"}],"output":null}],[11,"bitxor","","Returns the left flags, but with all the right flags toggled.",166,{"inputs":[{"name":"self"},{"name":"transfnattrflags"}],"output":{"name":"transfnattrflags"}}],[11,"bitxor_assign","","Toggles the set of flags.",166,{"inputs":[{"name":"self"},{"name":"transfnattrflags"}],"output":null}],[11,"bitand","","Returns the intersection between the two sets of flags.",166,{"inputs":[{"name":"self"},{"name":"transfnattrflags"}],"output":{"name":"transfnattrflags"}}],[11,"bitand_assign","","Disables all flags disabled in the set.",166,{"inputs":[{"name":"self"},{"name":"transfnattrflags"}],"output":null}],[11,"sub","","Returns the set difference of the two sets of flags.",166,{"inputs":[{"name":"self"},{"name":"transfnattrflags"}],"output":{"name":"transfnattrflags"}}],[11,"sub_assign","","Disables all flags enabled in the set.",166,{"inputs":[{"name":"self"},{"name":"transfnattrflags"}],"output":null}],[11,"not","","Returns the complement of this set of flags.",166,{"inputs":[{"name":"self"}],"output":{"name":"transfnattrflags"}}],[11,"extend","","",166,{"inputs":[{"name":"self"},{"name":"t"}],"output":null}],[11,"from_iter","","",166,{"inputs":[{"name":"t"}],"output":{"name":"transfnattrflags"}}],[11,"new","","",77,{"inputs":[],"output":{"name":"transfnattrs"}}],[11,"requests_inline","","True if `#[inline]` or `#[inline(always)]` is present.",77,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"contains_extern_indicator","","True if `#[no_mangle]` or `#[export_name(...)]` is present.",77,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[0,"ich","rustc","ICH - Incremental Compilation Hash",null,null],[3,"Fingerprint","rustc::ich","",null,null],[3,"CachingCodemapView","","",null,null],[3,"StableHashingContext","","This is the context state available during incr. comp. hashing. It contains enough information to transform DefIds and HirIds into stable DefPaths (i.e. a reference to the TyCtxt) and it holds a few caches for speeding up various things (e.g. each DefId/DefPath is only hashed once).",null,null],[4,"NodeIdHashingMode","","",null,null],[13,"Ignore","","",167,null],[13,"HashDefPath","","",167,null],[5,"hash_stable_trait_impls","","",null,{"inputs":[{"name":"stablehashingcontext"},{"name":"stablehasher"},{"name":"vec"},{"name":"hashmap"}],"output":null}],[5,"compute_ignored_attr_names","","",null,{"inputs":[],"output":{"generics":["symbol"],"name":"fxhashset"}}],[11,"eq","","",168,{"inputs":[{"name":"self"},{"name":"fingerprint"}],"output":{"name":"bool"}}],[11,"ne","","",168,{"inputs":[{"name":"self"},{"name":"fingerprint"}],"output":{"name":"bool"}}],[11,"cmp","","",168,{"inputs":[{"name":"self"},{"name":"fingerprint"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",168,{"inputs":[{"name":"self"},{"name":"fingerprint"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",168,{"inputs":[{"name":"self"},{"name":"fingerprint"}],"output":{"name":"bool"}}],[11,"le","","",168,{"inputs":[{"name":"self"},{"name":"fingerprint"}],"output":{"name":"bool"}}],[11,"gt","","",168,{"inputs":[{"name":"self"},{"name":"fingerprint"}],"output":{"name":"bool"}}],[11,"ge","","",168,{"inputs":[{"name":"self"},{"name":"fingerprint"}],"output":{"name":"bool"}}],[11,"hash","","",168,null],[11,"fmt","","",168,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",168,{"inputs":[{"name":"self"}],"output":{"name":"fingerprint"}}],[18,"ZERO","","",168,null],[11,"from_smaller_hash","","",168,{"inputs":[{"name":"u64"}],"output":{"name":"fingerprint"}}],[11,"to_smaller_hash","","",168,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"as_value","","",168,null],[11,"combine","","",168,{"inputs":[{"name":"self"},{"name":"fingerprint"}],"output":{"name":"fingerprint"}}],[11,"to_hex","","",168,{"inputs":[{"name":"self"}],"output":{"name":"string"}}],[11,"encode_opaque","","",168,{"inputs":[{"name":"self"},{"name":"encoder"}],"output":{"name":"encoderesult"}}],[11,"decode_opaque","","",168,{"inputs":[{"name":"decoder"}],"output":{"generics":["fingerprint","string"],"name":"result"}}],[11,"fmt","","",168,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"generics":["error"],"name":"result"}}],[11,"finish","","",168,{"inputs":[{"name":"stablehasher"}],"output":{"name":"self"}}],[11,"hash_stable","","",168,{"inputs":[{"name":"self"},{"name":"ctx"},{"name":"stablehasher"}],"output":null}],[11,"clone","","",169,{"inputs":[{"name":"self"}],"output":{"name":"cachingcodemapview"}}],[11,"new","","",169,{"inputs":[{"name":"codemap"}],"output":{"name":"cachingcodemapview"}}],[11,"byte_pos_to_line_and_col","","",169,{"inputs":[{"name":"self"},{"name":"bytepos"}],"output":{"name":"option"}}],[11,"clone","","",170,{"inputs":[{"name":"self"}],"output":{"name":"stablehashingcontext"}}],[11,"eq","","",167,{"inputs":[{"name":"self"},{"name":"nodeidhashingmode"}],"output":{"name":"bool"}}],[11,"clone","","",167,{"inputs":[{"name":"self"}],"output":{"name":"nodeidhashingmode"}}],[11,"new","","",170,{"inputs":[{"name":"session"},{"name":"crate"},{"name":"definitions"},{"name":"cratestore"}],"output":{"name":"self"}}],[11,"sess","","",170,{"inputs":[{"name":"self"}],"output":{"name":"session"}}],[11,"while_hashing_hir_bodies","","",170,{"inputs":[{"name":"self"},{"name":"bool"},{"name":"f"}],"output":null}],[11,"while_hashing_spans","","",170,{"inputs":[{"name":"self"},{"name":"bool"},{"name":"f"}],"output":null}],[11,"with_node_id_hashing_mode","","",170,{"inputs":[{"name":"self"},{"name":"nodeidhashingmode"},{"name":"f"}],"output":null}],[11,"def_path_hash","","",170,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"defpathhash"}}],[11,"local_def_path_hash","","",170,{"inputs":[{"name":"self"},{"name":"defindex"}],"output":{"name":"defpathhash"}}],[11,"node_to_hir_id","","",170,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"hirid"}}],[11,"hash_bodies","","",170,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"codemap","","",170,{"inputs":[{"name":"self"}],"output":{"name":"cachingcodemapview"}}],[11,"is_ignored_attr","","",170,{"inputs":[{"name":"self"},{"name":"symbol"}],"output":{"name":"bool"}}],[11,"hash_hir_item_like","","",170,{"inputs":[{"name":"self"},{"name":"f"}],"output":null}],[11,"get_stable_hashing_context","","",170,{"inputs":[{"name":"self"}],"output":{"name":"stablehashingcontext"}}],[11,"hash_stable","rustc::hir","",44,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",22,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"to_stable_hash_key","","",22,null],[11,"hash_stable","rustc::hir::def_id","",127,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"to_stable_hash_key","","",127,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"}],"output":{"name":"defpathhash"}}],[11,"hash_stable","","",131,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"to_stable_hash_key","","",131,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"}],"output":{"name":"defpathhash"}}],[11,"hash_stable","","",129,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"to_stable_hash_key","","",129,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"}],"output":{"name":"defpathhash"}}],[11,"hash_stable","rustc::hir","",23,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"to_stable_hash_key","","",23,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"}],"output":{"name":"itemlocalid"}}],[11,"hash_stable","","",70,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",50,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",52,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",78,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",24,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",25,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",26,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",27,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",28,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",29,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",79,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",80,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",30,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",81,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",31,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",83,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",32,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",84,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",33,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",34,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",35,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",48,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",49,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",54,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",55,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",109,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",56,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",57,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",110,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",61,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",116,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",67,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",68,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",97,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",37,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",38,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",39,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",40,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",85,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",86,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",87,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",89,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",90,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",41,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",92,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",42,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",43,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",93,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",94,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",46,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",96,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",98,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",100,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",99,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",104,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",105,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",47,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",102,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",101,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",103,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",51,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",106,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",107,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",53,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",108,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",118,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",114,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",115,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",62,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",63,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",65,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",66,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",117,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",69,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",119,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",71,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",120,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",72,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",73,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",121,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",74,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",122,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",91,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",60,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",45,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"to_stable_hash_key","","",44,null],[11,"hash_stable","","",58,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",64,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",59,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","rustc::hir::def","",124,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",125,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","rustc::hir","",88,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",111,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",112,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",113,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","rustc::hir::def_id","",130,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"to_stable_hash_key","","",130,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"}],"output":{"name":"defpathhash"}}],[11,"hash_stable","rustc::hir::def","",123,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","rustc::hir","",76,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"to_stable_hash_key","","",76,null],[11,"hash_stable","","",77,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",166,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",75,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[17,"ATTR_DIRTY","rustc::ich","",null,null],[17,"ATTR_CLEAN","","",null,null],[17,"ATTR_IF_THIS_CHANGED","","",null,null],[17,"ATTR_THEN_THIS_WOULD_NEED","","",null,null],[17,"ATTR_PARTITION_REUSED","","",null,null],[17,"ATTR_PARTITION_TRANSLATED","","",null,null],[17,"DEP_GRAPH_ASSERT_ATTRS","","",null,null],[17,"IGNORED_ATTRIBUTES","","",null,null],[8,"StableHashingContextProvider","","Something that can provide a stable hashing context.",null,null],[10,"get_stable_hashing_context","","",171,{"inputs":[{"name":"self"}],"output":{"name":"stablehashingcontext"}}],[0,"infer","rustc","See the Book for more information.",null,null],[3,"TypeFreshener","rustc::infer","",null,null],[3,"InferOk","","",null,null],[12,"value","","",172,null],[12,"obligations","","",172,null],[3,"InferCtxt","","",null,null],[12,"tcx","","",173,null],[12,"in_progress_tables","","During type-checking/inference of a body, `in_progress_tables` contains a reference to the tables being built up, which are used for reading closure kinds/signatures as they are inferred, and for error reporting logic to read arbitrary node types.",173,null],[12,"projection_cache","","",173,null],[12,"type_variables","","",173,null],[12,"selection_cache","","Caches the results of trait selection. This cache is used for things that have to do with the parameters in scope.",173,null],[12,"evaluation_cache","","Caches the results of trait evaluation.",173,null],[12,"reported_trait_errors","","",173,null],[12,"region_obligations","","",173,null],[3,"TypeTrace","","The trace designates the path through inference that we took to encounter an error or subtyping constraint.",null,null],[3,"RegionObligation","","See the `region_obligations` field for more information.",null,null],[12,"sub_region","","",174,null],[12,"sup_type","","",174,null],[12,"cause","","",174,null],[3,"InferCtxtBuilder","","Helper type of a temporary returned by tcx.infer_ctxt(). Necessary because we can't write the following bound: F: for<'b, 'tcx> where 'gcx: 'tcx FnOnce(InferCtxt<'b, 'gcx, 'tcx>).",null,null],[3,"CombinedSnapshot","","",null,null],[4,"ValuePairs","","See `error_reporting` module for more details",null,null],[13,"Types","","",175,null],[13,"Regions","","",175,null],[13,"TraitRefs","","",175,null],[13,"PolyTraitRefs","","",175,null],[4,"SubregionOrigin","","The origin of a `r1 <= r2` constraint.",null,null],[13,"Subtype","","",176,null],[13,"InfStackClosure","","",176,null],[13,"InvokeClosure","","",176,null],[13,"DerefPointer","","",176,null],[13,"FreeVariable","","",176,null],[13,"IndexSlice","","",176,null],[13,"RelateObjectBound","","",176,null],[13,"RelateParamBound","","",176,null],[13,"RelateRegionParamBound","","",176,null],[13,"RelateDefaultParamBound","","",176,null],[13,"Reborrow","","",176,null],[13,"ReborrowUpvar","","",176,null],[13,"DataBorrowed","","",176,null],[13,"ReferenceOutlivesReferent","","",176,null],[13,"ParameterInScope","","",176,null],[13,"ExprTypeIsNotInScope","","",176,null],[13,"BindingTypeIsNotValidAtDecl","","",176,null],[13,"CallRcvr","","",176,null],[13,"CallArg","","",176,null],[13,"CallReturn","","",176,null],[13,"Operand","","",176,null],[13,"AddrOf","","",176,null],[13,"AutoBorrow","","",176,null],[13,"SafeDestructor","","",176,null],[13,"CompareImplMethodObligation","","",176,null],[12,"span","rustc::infer::SubregionOrigin","",176,null],[12,"item_name","","",176,null],[12,"impl_item_def_id","","",176,null],[12,"trait_item_def_id","","",176,null],[4,"ParameterOrigin","rustc::infer","Places that type/region parameters can appear.",null,null],[13,"Path","","",177,null],[13,"MethodCall","","",177,null],[13,"OverloadedOperator","","",177,null],[13,"OverloadedDeref","","",177,null],[4,"LateBoundRegionConversionTime","","Times when we replace late-bound regions with variables:",null,null],[13,"FnCall","","when a fn is called",178,null],[13,"HigherRankedType","","when two higher-ranked types are compared",178,null],[13,"AssocTypeProjection","","when projecting an associated type",178,null],[4,"RegionVariableOrigin","","Reasons to create a region inference variable",null,null],[13,"MiscVariable","","",179,null],[13,"PatternRegion","","",179,null],[13,"AddrOfRegion","","",179,null],[13,"Autoref","","",179,null],[13,"Coercion","","",179,null],[13,"EarlyBoundRegion","","",179,null],[13,"LateBoundRegion","","",179,null],[13,"UpvarRegion","","",179,null],[13,"BoundRegionInCoherence","","",179,null],[13,"NLL","","",179,null],[4,"NLLRegionVariableOrigin","","",null,null],[13,"FreeRegion","","",180,null],[13,"Inferred","","",180,null],[4,"FixupError","","",null,null],[13,"UnresolvedIntTy","","",181,null],[13,"UnresolvedFloatTy","","",181,null],[13,"UnresolvedTy","","",181,null],[0,"anon_types","","",null,null],[3,"AnonTypeDecl","rustc::infer::anon_types","Information about the anonymous, abstract types whose values we are inferring in this function (these are the `impl Trait` that appear in the return type).",null,null],[12,"substs","","The substitutions that we apply to the abstract that that this `impl Trait` desugars to. e.g., if:",182,null],[12,"concrete_ty","","The type variable that represents the value of the abstract type that we require. In other words, after we compile this function, we will be created a constraint like:",182,null],[12,"has_required_region_bounds","","True if the `impl Trait` bounds include region bounds. For example, this would be true for:",182,null],[6,"AnonTypeMap","","",null,null],[11,"clone","","",182,{"inputs":[{"name":"self"}],"output":{"name":"anontypedecl"}}],[11,"fmt","","",182,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"instantiate_anon_types","rustc::infer","Replace all anonymized types in `value` with fresh inference variables and creates appropriate obligations. For example, given the input:",173,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"nodeid"},{"name":"paramenv"},{"name":"t"}],"output":{"name":"inferok"}}],[11,"constrain_anon_types","","Given the map `anon_types` containing the existential `impl Trait` types whose underlying, hidden types are being inferred, this method adds constraints to the regions appearing in those underlying hidden types to ensure that they at least do not refer to random scopes within the current function. These constraints are not (quite) sufficient to guarantee that the regions are actually legal values; that final condition is imposed after region inference is done.",173,{"inputs":[{"name":"self"},{"name":"anontypemap"},{"name":"frr"}],"output":null}],[11,"infer_anon_definition_from_instantiation","","Given the fully resolved, instantiated type for an anonymous type, i.e., the value of an inference variable like C1 or C2 (*), computes the \"definition type\" for an abstract type definition -- that is, the inferred value of `Foo1<'x>` or `Foo2<'x>` that we would conceptually use in its definition:",173,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"anontypedecl"},{"name":"ty"}],"output":{"name":"ty"}}],[0,"at","","A nice interface for working with the infcx.  The basic idea is to do `infcx.at(cause, param_env)`, which sets the \"cause\" of the operation as well as the surrounding parameter environment.  Then you can do something like `.sub(a, b)` or `.eq(a, b)` to create a subtype or equality relationship respectively. The first argument is always the \"expected\" output from the POV of diagnostics.",null,null],[3,"At","rustc::infer::at","",null,null],[12,"infcx","","",183,null],[12,"cause","","",183,null],[12,"param_env","","",183,null],[3,"Trace","","",null,null],[8,"ToTrace","","",null,null],[10,"to_trace","","",184,{"inputs":[{"name":"obligationcause"},{"name":"bool"},{"name":"self"},{"name":"self"}],"output":{"name":"typetrace"}}],[11,"at","rustc::infer","",173,{"inputs":[{"name":"self"},{"name":"obligationcause"},{"name":"paramenv"}],"output":{"name":"at"}}],[11,"eq_impl_headers","rustc::infer::at","Hacky routine for equating two impl headers in coherence.",183,{"inputs":[{"name":"self"},{"name":"implheader"},{"name":"implheader"}],"output":{"name":"inferresult"}}],[11,"sub_exp","","Make `a <: b` where `a` may or may not be expected",183,{"inputs":[{"name":"self"},{"name":"bool"},{"name":"t"},{"name":"t"}],"output":{"name":"inferresult"}}],[11,"sup","","Make `actual <: expected`. For example, if type-checking a call like `foo(x)`, where `foo: fn(i32)`, you might have `sup(i32, x)`, since the \"expected\" type is the type that appears in the signature.",183,{"inputs":[{"name":"self"},{"name":"t"},{"name":"t"}],"output":{"name":"inferresult"}}],[11,"sub","","Make `expected <: actual`",183,{"inputs":[{"name":"self"},{"name":"t"},{"name":"t"}],"output":{"name":"inferresult"}}],[11,"eq_exp","","Make `expected <: actual`",183,{"inputs":[{"name":"self"},{"name":"bool"},{"name":"t"},{"name":"t"}],"output":{"name":"inferresult"}}],[11,"eq","","Make `expected <: actual`",183,{"inputs":[{"name":"self"},{"name":"t"},{"name":"t"}],"output":{"name":"inferresult"}}],[11,"lub","","Compute the least-upper-bound, or mutual supertype, of two values. The order of the arguments doesn't matter, but since this can result in an error (e.g., if asked to compute LUB of u32 and i32), it is meaningful to call one of them the \"expected type\".",183,{"inputs":[{"name":"self"},{"name":"t"},{"name":"t"}],"output":{"name":"inferresult"}}],[11,"glb","","Compute the greatest-lower-bound, or mutual subtype, of two values. As with `lub` order doesn't matter, except for error cases.",183,{"inputs":[{"name":"self"},{"name":"t"},{"name":"t"}],"output":{"name":"inferresult"}}],[11,"trace","","Sets the \"trace\" values that will be used for error-reporting, but doesn't actually perform any operation yet (this is useful when you want to set the trace using distinct values from those you wish to operate upon).",183,{"inputs":[{"name":"self"},{"name":"t"},{"name":"t"}],"output":{"name":"trace"}}],[11,"trace_exp","","Like `trace`, but the expected value is determined by the boolean argument (if true, then the first argument `a` is the \"expected\" value).",183,{"inputs":[{"name":"self"},{"name":"bool"},{"name":"t"},{"name":"t"}],"output":{"name":"trace"}}],[11,"sub","","Make `a <: b` where `a` may or may not be expected (if `a_is_expected` is true, then `a` is expected). Make `expected <: actual`",185,{"inputs":[{"name":"self"},{"name":"t"},{"name":"t"}],"output":{"name":"inferresult"}}],[11,"eq","","Make `a == b`; the expectation is set by the call to `trace()`.",185,{"inputs":[{"name":"self"},{"name":"t"},{"name":"t"}],"output":{"name":"inferresult"}}],[11,"lub","","",185,{"inputs":[{"name":"self"},{"name":"t"},{"name":"t"}],"output":{"name":"inferresult"}}],[11,"glb","","",185,{"inputs":[{"name":"self"},{"name":"t"},{"name":"t"}],"output":{"name":"inferresult"}}],[0,"canonical","rustc::infer","Canonicalization is the key to constructing a query in the middle of type inference. Ordinarily, it is not possible to store types from type inference in query keys, because they contain references to inference variables whose lifetimes are too short and so forth. Canonicalizing a value T1 using `canonicalize_query` produces two things:",null,null],[3,"Canonical","rustc::infer::canonical","A \"canonicalized\" type `V` is one where all free inference variables have been rewriten to \"canonical vars\". These are numbered starting from 0 in order of first appearance.",null,null],[12,"variables","","",186,null],[12,"value","","",186,null],[3,"CanonicalVarValues","","A set of values corresponding to the canonical variables from some `Canonical`. You can give these values to `canonical_value.substitute` to substitute them into the canonical value at the right places.",null,null],[12,"var_values","","",187,null],[3,"CanonicalVarInfo","","Information about a canonical variable that is included with the canonical value. This is sufficient information for code to create a copy of the canonical value in some other inference context, with fresh inference variables replacing the canonical values.",null,null],[12,"kind","","",188,null],[3,"QueryResult","","After we execute a query with a canonicalized key, we get back a `Canonical<QueryResult<..>>`. You can use `instantiate_query_result` to access the data in this result.",null,null],[12,"var_values","","",189,null],[12,"region_constraints","","",189,null],[12,"certainty","","",189,null],[12,"value","","",189,null],[3,"QueryRegionConstraints","","Subset of `RegionConstraintData` produced by trait query.",null,null],[12,"region_outlives","","",190,null],[12,"ty_outlives","","",190,null],[4,"CanonicalVarKind","","Describes the \"kind\" of the canonical variable. This is a \"kind\" in the type-theory sense of the term -- i.e., a \"meta\" type system that analyzes type-like values.",null,null],[13,"Ty","","Some kind of type inference variable.",191,null],[13,"Region","","Region variable `'?R`.",191,null],[4,"CanonicalTyVarKind","","Rust actually has more than one category of type variables; notably, the type variables we create for literals (e.g., 22 or 22.) can only be instantiated with integral/float types (e.g., usize or f32). In order to faithfully reproduce a type, we need to know what set of types a given type variable can be unified with.",null,null],[13,"General","","General type variable `?T` that can be unified with arbitrary types.",192,null],[13,"Int","","Integral type variable `?I` (that can only be unified with integral types).",192,null],[13,"Float","","Floating-point type variable `?F` (that can only be unified with float types).",192,null],[4,"Certainty","","Indicates whether or not we were able to prove the query to be true.",null,null],[13,"Proven","","The query is known to be true, presuming that you apply the given `var_values` and the region-constraints are satisfied.",193,null],[13,"Ambiguous","","The query is not known to be true, but also not known to be false. The `var_values` represent either values that must hold in order for the query to be true, or helpful tips that might make it true. Currently rustc's trait solver cannot distinguish the two (e.g., due to our preference for where clauses over impls).",193,null],[6,"CanonicalVarInfos","","",null,null],[8,"Canonicalize","","Trait implemented by values that can be canonicalized. It mainly serves to identify the interning table we will use.",null,null],[16,"Canonicalized","","",194,null],[10,"intern","","After a value has been fully canonicalized and lifted, this method will allocate it in a global arena.",194,null],[11,"clone","","",186,{"inputs":[{"name":"self"}],"output":{"name":"canonical"}}],[11,"fmt","","",186,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",186,{"inputs":[{"name":"self"},{"name":"canonical"}],"output":{"name":"bool"}}],[11,"ne","","",186,{"inputs":[{"name":"self"},{"name":"canonical"}],"output":{"name":"bool"}}],[11,"hash","","",186,null],[11,"decode","","",186,{"inputs":[{"name":"__dv"}],"output":{"generics":["canonical"],"name":"result"}}],[11,"encode","","",186,{"inputs":[{"name":"self"},{"name":"__sv"}],"output":{"name":"result"}}],[11,"clone","","",187,{"inputs":[{"name":"self"}],"output":{"name":"canonicalvarvalues"}}],[11,"fmt","","",187,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",187,{"inputs":[{"name":"self"},{"name":"canonicalvarvalues"}],"output":{"name":"bool"}}],[11,"ne","","",187,{"inputs":[{"name":"self"},{"name":"canonicalvarvalues"}],"output":{"name":"bool"}}],[11,"hash","","",187,null],[11,"decode","","",187,{"inputs":[{"name":"__d"}],"output":{"generics":["canonicalvarvalues"],"name":"result"}}],[11,"encode","","",187,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"clone","","",188,{"inputs":[{"name":"self"}],"output":{"name":"canonicalvarinfo"}}],[11,"fmt","","",188,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",188,{"inputs":[{"name":"self"},{"name":"canonicalvarinfo"}],"output":{"name":"bool"}}],[11,"ne","","",188,{"inputs":[{"name":"self"},{"name":"canonicalvarinfo"}],"output":{"name":"bool"}}],[11,"hash","","",188,null],[11,"decode","","",188,{"inputs":[{"name":"__d"}],"output":{"generics":["canonicalvarinfo"],"name":"result"}}],[11,"encode","","",188,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"clone","","",191,{"inputs":[{"name":"self"}],"output":{"name":"canonicalvarkind"}}],[11,"fmt","","",191,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",191,{"inputs":[{"name":"self"},{"name":"canonicalvarkind"}],"output":{"name":"bool"}}],[11,"ne","","",191,{"inputs":[{"name":"self"},{"name":"canonicalvarkind"}],"output":{"name":"bool"}}],[11,"hash","","",191,null],[11,"decode","","",191,{"inputs":[{"name":"__d"}],"output":{"generics":["canonicalvarkind"],"name":"result"}}],[11,"encode","","",191,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"clone","","",192,{"inputs":[{"name":"self"}],"output":{"name":"canonicaltyvarkind"}}],[11,"fmt","","",192,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",192,{"inputs":[{"name":"self"},{"name":"canonicaltyvarkind"}],"output":{"name":"bool"}}],[11,"hash","","",192,null],[11,"decode","","",192,{"inputs":[{"name":"__d"}],"output":{"generics":["canonicaltyvarkind"],"name":"result"}}],[11,"encode","","",192,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"clone","","",189,{"inputs":[{"name":"self"}],"output":{"name":"queryresult"}}],[11,"fmt","","",189,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",193,{"inputs":[{"name":"self"}],"output":{"name":"certainty"}}],[11,"fmt","","",193,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"is_proven","","",193,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_ambiguous","","",193,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_proven","","",189,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_ambiguous","","",189,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_proven","","",186,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_ambiguous","","",186,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",190,{"inputs":[{"name":"self"}],"output":{"name":"queryregionconstraints"}}],[11,"fmt","","",190,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"default","","",190,{"inputs":[],"output":{"name":"queryregionconstraints"}}],[11,"instantiate_canonical_with_fresh_inference_vars","rustc::infer","Creates a substitution S for the canonical value with fresh inference variables and applies it to the canonical value. Returns both the instantiated result and the substitution S.",173,null],[11,"fresh_inference_vars_for_canonical_vars","","Given the \"infos\" about the canonical variables from some canonical, creates fresh inference variables with the same characteristics. You can then use `substitute` to instantiate the canonical variable with these inference variables.",173,{"inputs":[{"name":"self"},{"name":"span"},{"name":"slice"}],"output":{"name":"canonicalvarvalues"}}],[11,"fresh_inference_var_for_canonical_var","","Given the \"info\" about a canonical variable, creates a fresh inference variable with the same characteristics.",173,{"inputs":[{"name":"self"},{"name":"span"},{"name":"canonicalvarinfo"}],"output":{"name":"kind"}}],[11,"instantiate_query_result","","Given the (canonicalized) result to a canonical query, instantiates the result so it can be used, plugging in the values from the canonical query. (Note that the result may have been ambiguous; you should check the certainty level of the query before applying this function.)",173,{"inputs":[{"name":"self"},{"name":"obligationcause"},{"name":"paramenv"},{"name":"canonicalvarvalues"},{"name":"canonical"}],"output":{"name":"inferresult"}}],[11,"canonicalize_query","","Canonicalizes a query value `V`. When we canonicalize a query, we not only canonicalize unbound inference variables, but we also replace all free regions whatsoever. So for example a query like `T: Trait<'static>` would be canonicalized to",173,null],[11,"canonicalize_response","","Canonicalizes a query response `V`. When we canonicalize a query response, we only canonicalize unbound inference variables, and we leave other free regions alone. So, continuing with the example from `canonicalize_query`, if there was an input query `T: Trait<'static>`, it would have been canonicalized to",173,null],[11,"super_fold_with","rustc::infer::canonical","",193,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"certainty"}}],[11,"super_visit_with","","",193,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",188,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"canonicalvarinfo"}}],[11,"super_visit_with","","",188,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",191,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"canonicalvarkind"}}],[11,"super_visit_with","","",191,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"lift_to_tcx","","",193,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","","",188,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","","",191,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"super_fold_with","","",195,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"canonicalvarinfos"}}],[11,"super_visit_with","","",195,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",186,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",186,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"lift_to_tcx","","",186,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"generics":["canonical"],"name":"option"}}],[11,"lift_to_tcx","","",187,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"generics":["canonicalvarvalues"],"name":"option"}}],[11,"super_fold_with","","",187,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",187,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",190,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",190,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"lift_to_tcx","","",190,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"generics":["queryregionconstraints"],"name":"option"}}],[11,"super_fold_with","","",189,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",189,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"lift_to_tcx","","",189,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"generics":["queryresult"],"name":"option"}}],[11,"index","","",187,{"inputs":[{"name":"self"},{"name":"canonicalvar"}],"output":{"name":"kind"}}],[11,"super_combine_tys","rustc::infer","",173,{"inputs":[{"name":"self"},{"name":"r"},{"name":"ty"},{"name":"ty"}],"output":{"generics":["ty"],"name":"relateresult"}}],[0,"error_reporting","","Error Reporting Code for the inference engine",null,null],[11,"need_type_info","","",173,{"inputs":[{"name":"self"},{"generics":["bodyid"],"name":"option"},{"name":"span"},{"name":"ty"}],"output":null}],[0,"nice_region_error","rustc::infer::error_reporting","",null,null],[3,"NiceRegionError","rustc::infer::error_reporting::nice_region_error","",null,null],[11,"try_report_nice_region_error","rustc::infer","",173,{"inputs":[{"name":"self"},{"name":"regionresolutionerror"}],"output":{"name":"bool"}}],[11,"new","rustc::infer::error_reporting::nice_region_error","",196,{"inputs":[{"name":"tyctxt"},{"name":"regionresolutionerror"},{"generics":["typecktables"],"name":"option"}],"output":{"name":"self"}}],[11,"new_from_span","","",196,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"region"},{"name":"region"},{"generics":["typecktables"],"name":"option"}],"output":{"name":"self"}}],[11,"try_report","","",196,{"inputs":[{"name":"self"}],"output":{"generics":["errorreported"],"name":"option"}}],[11,"get_regions","","",196,null],[11,"report_region_errors","rustc::infer","",173,{"inputs":[{"name":"self"},{"name":"scopetree"},{"name":"vec"},{"name":"bool"}],"output":null}],[11,"note_type_err","","",173,{"inputs":[{"name":"self"},{"name":"diagnosticbuilder"},{"name":"obligationcause"},{"name":"option"},{"generics":["valuepairs"],"name":"option"},{"name":"typeerror"}],"output":null}],[11,"report_and_explain_type_error","","",173,{"inputs":[{"name":"self"},{"name":"typetrace"},{"name":"typeerror"}],"output":{"name":"diagnosticbuilder"}}],[11,"report_generic_bound_failure","","",173,{"inputs":[{"name":"self"},{"name":"scopetree"},{"name":"span"},{"generics":["subregionorigin"],"name":"option"},{"name":"generickind"},{"name":"region"}],"output":null}],[11,"fudge_regions_if_ok","","This rather funky routine is used while processing expected types. What happens here is that we want to propagate a coercion through the return type of a fn to its argument. Consider the type of `Option::Some`, which is basically `for<T> fn(T) -> Option<T>`. So if we have an expression `Some(&[1, 2, 3])`, and that has the expected type `Option<&[u32]>`, we would like to type check `&[1, 2, 3]` with the expectation of `&[u32]`. This will cause us to coerce from `&[u32; 3]` to `&[u32]` and make the users life more pleasant.",173,{"inputs":[{"name":"self"},{"name":"regionvariableorigin"},{"name":"f"}],"output":{"name":"result"}}],[11,"skolemize_late_bound_regions","","Replace all regions bound by `binder` with skolemized regions and return a map indicating which bound-region was replaced with what skolemized region. This is the first step of checking subtyping when higher-ranked things are involved.",173,null],[11,"leak_check","","Searches the region constraints created since `snapshot` was started and checks to determine whether any of the skolemized regions created in `skol_map` would \"escape\" -- meaning that they are related to other regions in some way. If so, the higher-ranked subtyping doesn't hold. See `README.md` for more details.",173,{"inputs":[{"name":"self"},{"name":"bool"},{"name":"span"},{"name":"skolemizationmap"},{"name":"combinedsnapshot"}],"output":{"name":"relateresult"}}],[11,"plug_leaks","","This code converts from skolemized regions back to late-bound regions. It works by replacing each region in the taint set of a skolemized region with a bound-region. The bound region will be bound by the outer-most binder in `value`; the caller must ensure that there is such a binder and it is the right place.",173,{"inputs":[{"name":"self"},{"name":"skolemizationmap"},{"name":"combinedsnapshot"},{"name":"t"}],"output":{"name":"t"}}],[11,"pop_skolemized","","Pops the skolemized regions found in `skol_map` from the region inference context. Whenever you create skolemized regions via `skolemize_late_bound_regions`, they must be popped before you commit the enclosing snapshot (if you do not commit, e.g. within a probe or as a result of an error, then this is not necessary, as popping happens as part of the rollback).",173,{"inputs":[{"name":"self"},{"name":"skolemizationmap"},{"name":"combinedsnapshot"}],"output":null}],[0,"lattice","","Lattice Variables",null,null],[5,"super_lattice_tys","rustc::infer::lattice","",null,{"inputs":[{"name":"l"},{"name":"ty"},{"name":"ty"}],"output":{"generics":["ty"],"name":"relateresult"}}],[8,"LatticeDir","","",null,null],[10,"infcx","","",197,{"inputs":[{"name":"self"}],"output":{"name":"inferctxt"}}],[10,"cause","","",197,{"inputs":[{"name":"self"}],"output":{"name":"obligationcause"}}],[10,"relate_bound","","",197,{"inputs":[{"name":"self"},{"name":"ty"},{"name":"ty"},{"name":"ty"}],"output":{"name":"relateresult"}}],[0,"region_constraints","rustc::infer","See README.md",null,null],[3,"RegionConstraintCollector","rustc::infer::region_constraints","",null,null],[3,"RegionConstraintData","","The full set of region constraints gathered up by the collector. Describes constraints between the region variables and other regions, as well as other conditions that must be verified, or assumptions that can be made.",null,null],[12,"constraints","","Constraints of the form `A <= B`, where either `A` or `B` can be a region variable (or neither, as it happens).",198,null],[12,"verifys","","A \"verify\" is something that we need to verify after inference is done, but which does not directly affect inference in any way.",198,null],[12,"givens","","A \"given\" is a relationship that is known to hold. In particular, we often know from closure fn signatures that a particular free region must be a subregion of a region variable:",198,null],[3,"Verify","","VerifyGenericBound(T, _, R, RS): The parameter type `T` (or associated type) must outlive the region `R`. `T` is known to outlive `RS`. Therefore verify that `R <= RS[i]` for some `i`. Inference variables may be involved (but this verification step doesn't influence inference).",null,null],[12,"kind","","",199,null],[12,"origin","","",199,null],[12,"region","","",199,null],[12,"bound","","",199,null],[3,"RegionSnapshot","","",null,null],[3,"TaintDirections","","When working with skolemized regions, we often wish to find all of the regions that are either reachable from a skolemized region, or which can reach a skolemized region, or both. We call such regions tained regions.  This struct allows you to decide what set of tainted regions you want.",null,null],[4,"Constraint","","A constraint that influences the inference process.",null,null],[13,"VarSubVar","","One region variable is subregion of another",200,null],[13,"RegSubVar","","Concrete region is subregion of region variable",200,null],[13,"VarSubReg","","Region variable is subregion of concrete region. This does not directly affect inference, but instead is checked after inference is complete.",200,null],[13,"RegSubReg","","A constraint where neither side is a variable. This does not directly affect inference, but instead is checked after inference is complete.",200,null],[4,"GenericKind","","",null,null],[13,"Param","","",201,null],[13,"Projection","","",201,null],[4,"VerifyBound","","When we introduce a verification step, we wish to test that a particular region (let's call it `'min`) meets some bound. The bound is described the by the following grammar:",null,null],[13,"AnyRegion","","B = exists {R} --> some 'r in {R} must outlive 'min",202,null],[13,"AllRegions","","B = forall {R} --> all 'r in {R} must outlive 'min",202,null],[13,"AnyBound","","B = exists {B} --> 'min must meet some bound b in {B}",202,null],[13,"AllBounds","","B = forall {B} --> 'min must meet all bounds b in {B}",202,null],[6,"VarOrigins","","",null,null],[11,"fmt","","",198,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"default","","",198,{"inputs":[],"output":{"name":"regionconstraintdata"}}],[11,"clone","","",198,{"inputs":[{"name":"self"}],"output":{"name":"regionconstraintdata"}}],[11,"clone","","",200,{"inputs":[{"name":"self"}],"output":{"name":"constraint"}}],[11,"eq","","",200,{"inputs":[{"name":"self"},{"name":"constraint"}],"output":{"name":"bool"}}],[11,"ne","","",200,{"inputs":[{"name":"self"},{"name":"constraint"}],"output":{"name":"bool"}}],[11,"hash","","",200,null],[11,"fmt","","",200,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"partial_cmp","","",200,{"inputs":[{"name":"self"},{"name":"constraint"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",200,{"inputs":[{"name":"self"},{"name":"constraint"}],"output":{"name":"bool"}}],[11,"le","","",200,{"inputs":[{"name":"self"},{"name":"constraint"}],"output":{"name":"bool"}}],[11,"gt","","",200,{"inputs":[{"name":"self"},{"name":"constraint"}],"output":{"name":"bool"}}],[11,"ge","","",200,{"inputs":[{"name":"self"},{"name":"constraint"}],"output":{"name":"bool"}}],[11,"cmp","","",200,{"inputs":[{"name":"self"},{"name":"constraint"}],"output":{"name":"ordering"}}],[11,"fmt","","",199,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",199,{"inputs":[{"name":"self"}],"output":{"name":"verify"}}],[11,"clone","","",201,{"inputs":[{"name":"self"}],"output":{"name":"generickind"}}],[11,"eq","","",201,{"inputs":[{"name":"self"},{"name":"generickind"}],"output":{"name":"bool"}}],[11,"ne","","",201,{"inputs":[{"name":"self"},{"name":"generickind"}],"output":{"name":"bool"}}],[11,"fmt","","",202,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",202,{"inputs":[{"name":"self"}],"output":{"name":"verifybound"}}],[11,"fmt","","",203,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"incoming","","",203,{"inputs":[],"output":{"name":"self"}}],[11,"outgoing","","",203,{"inputs":[],"output":{"name":"self"}}],[11,"both","","",203,{"inputs":[],"output":{"name":"self"}}],[11,"new","","",204,{"inputs":[],"output":{"name":"regionconstraintcollector"}}],[11,"var_origins","","",204,{"inputs":[{"name":"self"}],"output":{"name":"varorigins"}}],[11,"region_constraint_data","","",204,{"inputs":[{"name":"self"}],"output":{"name":"regionconstraintdata"}}],[11,"into_origins_and_data","","Once all the constraints have been gathered, extract out the final data.",204,null],[11,"take_and_reset_data","","Takes (and clears) the current set of constraints. Note that the set of variables remains intact, but all relationships between them are reset.  This is used during NLL checking to grab the set of constraints that arose from a particular operation.",204,{"inputs":[{"name":"self"}],"output":{"name":"regionconstraintdata"}}],[11,"data","","",204,{"inputs":[{"name":"self"}],"output":{"name":"regionconstraintdata"}}],[11,"start_snapshot","","",204,{"inputs":[{"name":"self"}],"output":{"name":"regionsnapshot"}}],[11,"commit","","",204,{"inputs":[{"name":"self"},{"name":"regionsnapshot"}],"output":null}],[11,"rollback_to","","",204,{"inputs":[{"name":"self"},{"name":"regionsnapshot"}],"output":null}],[11,"new_region_var","","",204,{"inputs":[{"name":"self"},{"name":"regionvariableorigin"}],"output":{"name":"regionvid"}}],[11,"var_origin","","Returns the origin for the given variable.",204,{"inputs":[{"name":"self"},{"name":"regionvid"}],"output":{"name":"regionvariableorigin"}}],[11,"push_skolemized","","Creates a new skolemized region. Skolemized regions are fresh regions used when performing higher-ranked computations. They must be used in a very particular way and are never supposed to \"escape\" out into error messages or the code at large.",204,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"boundregion"},{"name":"regionsnapshot"}],"output":{"name":"region"}}],[11,"pop_skolemized","","Removes all the edges to/from the skolemized regions that are in `skols`. This is used after a higher-ranked operation completes to remove all trace of the skolemized regions created in that time.",204,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"fxhashset"},{"name":"regionsnapshot"}],"output":null}],[11,"new_bound","","",204,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"debruijnindex"}],"output":{"name":"region"}}],[11,"add_given","","",204,{"inputs":[{"name":"self"},{"name":"region"},{"name":"regionvid"}],"output":null}],[11,"make_eqregion","","",204,{"inputs":[{"name":"self"},{"name":"subregionorigin"},{"name":"region"},{"name":"region"}],"output":null}],[11,"make_subregion","","",204,{"inputs":[{"name":"self"},{"name":"subregionorigin"},{"name":"region"},{"name":"region"}],"output":null}],[11,"verify_generic_bound","","See `Verify::VerifyGenericBound`",204,{"inputs":[{"name":"self"},{"name":"subregionorigin"},{"name":"generickind"},{"name":"region"},{"name":"verifybound"}],"output":null}],[11,"lub_regions","","",204,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"subregionorigin"},{"name":"region"},{"name":"region"}],"output":{"name":"region"}}],[11,"glb_regions","","",204,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"subregionorigin"},{"name":"region"},{"name":"region"}],"output":{"name":"region"}}],[11,"opportunistic_resolve_var","","",204,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"regionvid"}],"output":{"name":"region"}}],[11,"vars_created_since_snapshot","","",204,{"inputs":[{"name":"self"},{"name":"regionsnapshot"}],"output":{"generics":["regionvid"],"name":"vec"}}],[11,"tainted","","Computes all regions that have been related to `r0` since the mark `mark` was made---`r0` itself will be the first entry. The `directions` parameter controls what kind of relations are considered. For example, one can say that only \"incoming\" edges to `r0` are desired, in which case one will get the set of regions `{r|r <= r0}`. This is used when checking whether skolemized regions are being improperly related to other regions.",204,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"regionsnapshot"},{"name":"region"},{"name":"taintdirections"}],"output":{"generics":["region"],"name":"fxhashset"}}],[11,"fmt","","",205,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",201,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",201,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"to_ty","","",201,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"ty"}}],[11,"must_hold","","",202,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"cannot_hold","","",202,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"or","","",202,{"inputs":[{"name":"self"},{"name":"verifybound"}],"output":{"name":"verifybound"}}],[11,"and","","",202,{"inputs":[{"name":"self"},{"name":"verifybound"}],"output":{"name":"verifybound"}}],[11,"is_empty","","True if this region constraint data contains no constraints.",198,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[0,"outlives","rustc::infer","Various code related to computing outlives relations.",null,null],[0,"env","rustc::infer::outlives","",null,null],[3,"OutlivesEnvironment","rustc::infer::outlives::env","The `OutlivesEnvironment` collects information about what outlives what in a given type-checking setting. For example, if we have a where-clause like `where T: 'a` in scope, then the `OutlivesEnvironment` would record that (in its `region_bound_pairs` field). Similarly, it contains methods for processing and adding implied bounds into the outlives environment.",null,null],[11,"clone","","",206,{"inputs":[{"name":"self"}],"output":{"name":"outlivesenvironment"}}],[11,"new","","",206,{"inputs":[{"name":"paramenv"}],"output":{"name":"self"}}],[11,"free_region_map","","Borrows current value of the `free_region_map`.",206,{"inputs":[{"name":"self"}],"output":{"name":"freeregionmap"}}],[11,"region_bound_pairs","","Borrows current value of the `region_bound_pairs`.",206,null],[11,"into_free_region_map","","Returns ownership of the `free_region_map`.",206,{"inputs":[{"name":"self"}],"output":{"name":"freeregionmap"}}],[11,"push_snapshot_pre_closure","","This is a hack to support the old-skool regionck, which processes region constraints from the main function and the closure together. In that context, when we enter a closure, we want to be able to \"save\" the state of the surrounding a function. We can then add implied bounds and the like from the closure arguments into the environment -- these should only apply in the closure body, so once we exit, we invoke `pop_snapshot_post_closure` to remove them.",206,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"pop_snapshot_post_closure","","See `push_snapshot_pre_closure`.",206,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"add_implied_bounds","","This method adds \"implied bounds\" into the outlives environment. Implied bounds are outlives relationships that we can deduce on the basis that certain types must be well-formed -- these are either the types that appear in the function signature or else the input types to an impl. For example, if you have a function like",206,null],[0,"free_region_map","rustc::infer::outlives","",null,null],[3,"FreeRegionMap","rustc::infer::outlives::free_region_map","",null,null],[8,"FreeRegionRelations","","The NLL region handling code represents free region relations in a slightly different way; this trait allows functions to be abstract over which version is in use.",null,null],[10,"sub_free_regions","","Tests whether `r_a <= r_b`. Both must be free regions or `'static`.",207,{"inputs":[{"name":"self"},{"name":"region"},{"name":"region"}],"output":{"name":"bool"}}],[11,"clone","","",208,{"inputs":[{"name":"self"}],"output":{"name":"freeregionmap"}}],[11,"encode","","",208,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",208,{"inputs":[{"name":"__d"}],"output":{"generics":["freeregionmap"],"name":"result"}}],[11,"fmt","","",208,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","",208,{"inputs":[],"output":{"name":"self"}}],[11,"is_empty","","",208,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"relate_regions","","",208,{"inputs":[{"name":"self"},{"name":"region"},{"name":"region"}],"output":null}],[11,"lub_free_regions","","Compute the least-upper-bound of two free regions. In some cases, this is more conservative than necessary, in order to avoid making arbitrary choices. See `TransitiveRelation::postdom_upper_bound` for more details.",208,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"region"},{"name":"region"}],"output":{"name":"region"}}],[11,"sub_free_regions","","",208,{"inputs":[{"name":"self"},{"name":"region"},{"name":"region"}],"output":{"name":"bool"}}],[11,"hash_stable","","",208,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"lift_to_tcx","","",208,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"generics":["freeregionmap"],"name":"option"}}],[0,"bounds","rustc::infer::outlives","",null,null],[4,"OutlivesBound","rustc::infer::outlives::bounds","Outlives bounds are relationships between generic parameters, whether they both be regions (`'a: 'b`) or whether types are involved (`T: 'a`).  These relationships can be extracted from the full set of predicates we understand or also from types (in which case they are called implied bounds). They are fed to the `OutlivesEnv` which in turn is supplied to the region checker and other parts of the inference system.",null,null],[13,"RegionSubRegion","","",209,null],[13,"RegionSubParam","","",209,null],[13,"RegionSubProjection","","",209,null],[5,"explicit_outlives_bounds","","",null,null],[11,"fmt","","",209,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"implied_outlives_bounds","rustc::infer","Implied bounds are region relationships that we deduce automatically.  The idea is that (e.g.) a caller must check that a function's argument types are well-formed immediately before calling that fn, and hence the callee can assume that its argument types are well-formed. This may imply certain relationships between generic parameters. For example:",173,{"inputs":[{"name":"self"},{"name":"paramenv"},{"name":"nodeid"},{"name":"ty"},{"name":"span"}],"output":{"generics":["outlivesbound"],"name":"vec"}}],[11,"register_region_obligation","","Registers that the given region obligation must be resolved from within the scope of `body_id`. These regions are enqueued and later processed by regionck, when full type information is available (see `region_obligations` field for more information).",173,{"inputs":[{"name":"self"},{"name":"nodeid"},{"name":"regionobligation"}],"output":null}],[11,"take_registered_region_obligations","","Trait queries just want to pass back type obligations \"as is\"",173,{"inputs":[{"name":"self"}],"output":{"name":"vec"}}],[11,"process_registered_region_obligations","","Process the region obligations that must be proven (during `regionck`) for the given `body_id`, given information about the region bounds in scope and so forth. This function must be invoked for all relevant body-ids before region inference is done (or else an assert will fire).",173,null],[11,"type_must_outlive","","Processes a single ad-hoc region obligation that was not registered in advance.",173,null],[0,"resolve","","",null,null],[3,"OpportunisticTypeResolver","rustc::infer::resolve","The opportunistic type resolver can be used at any time. It simply replaces type variables that have been unified with the things they have been unified with (similar to `shallow_resolve`, but deep). This is useful for printing messages etc but also required at various points for correctness.",null,null],[3,"OpportunisticTypeAndRegionResolver","","The opportunistic type and region resolver is similar to the opportunistic type resolver, but also opportunistically resolves regions. It is useful for canonicalization.",null,null],[3,"UnresolvedTypeFinder","","The unresolved type finder walks your type and searches for type variables that don't yet have a value. They get pushed into a vector. It does not construct the fully resolved type (which might involve some hashing and so forth).",null,null],[5,"fully_resolve","","Full type resolution replaces all type and region variables with their concrete results. If any variable cannot be replaced (never unified, etc) then an `Err` result is returned.",null,{"inputs":[{"name":"inferctxt"},{"name":"t"}],"output":{"name":"fixupresult"}}],[11,"new","","",210,{"inputs":[{"name":"inferctxt"}],"output":{"name":"self"}}],[11,"tcx","","",210,{"inputs":[{"name":"self"}],"output":{"name":"tyctxt"}}],[11,"fold_ty","","",210,{"inputs":[{"name":"self"},{"name":"ty"}],"output":{"name":"ty"}}],[11,"new","","",211,{"inputs":[{"name":"inferctxt"}],"output":{"name":"self"}}],[11,"tcx","","",211,{"inputs":[{"name":"self"}],"output":{"name":"tyctxt"}}],[11,"fold_ty","","",211,{"inputs":[{"name":"self"},{"name":"ty"}],"output":{"name":"ty"}}],[11,"fold_region","","",211,{"inputs":[{"name":"self"},{"name":"region"}],"output":{"name":"region"}}],[11,"new","","",212,{"inputs":[{"name":"inferctxt"}],"output":{"name":"self"}}],[11,"visit_ty","","",212,{"inputs":[{"name":"self"},{"name":"ty"}],"output":{"name":"bool"}}],[11,"new","rustc::infer","",213,{"inputs":[{"name":"inferctxt"}],"output":{"name":"typefreshener"}}],[11,"tcx","","",213,{"inputs":[{"name":"self"}],"output":{"name":"tyctxt"}}],[11,"fold_region","","",213,{"inputs":[{"name":"self"},{"name":"region"}],"output":{"name":"region"}}],[11,"fold_ty","","",213,{"inputs":[{"name":"self"},{"name":"ty"}],"output":{"name":"ty"}}],[0,"type_variable","","",null,null],[3,"TypeVariableTable","rustc::infer::type_variable","",null,null],[3,"Snapshot","","",null,null],[4,"TypeVariableOrigin","","Reasons to create a type inference variable",null,null],[13,"MiscVariable","","",214,null],[13,"NormalizeProjectionType","","",214,null],[13,"TypeInference","","",214,null],[13,"TypeParameterDefinition","","",214,null],[13,"ClosureSynthetic","","one of the upvars or closure kind parameters in a `ClosureSubsts` (before it has been determined)",214,null],[13,"SubstitutionPlaceholder","","",214,null],[13,"AutoDeref","","",214,null],[13,"AdjustmentType","","",214,null],[13,"DivergingStmt","","",214,null],[13,"DivergingBlockExpr","","",214,null],[13,"DivergingFn","","",214,null],[13,"LatticeVariable","","",214,null],[13,"Generalized","","",214,null],[4,"TypeVariableValue","","",null,null],[13,"Known","","",215,null],[12,"value","rustc::infer::type_variable::TypeVariableValue","",215,null],[13,"Unknown","rustc::infer::type_variable","",215,null],[6,"TypeVariableMap","","",null,null],[11,"clone","","",214,{"inputs":[{"name":"self"}],"output":{"name":"typevariableorigin"}}],[11,"fmt","","",214,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",215,{"inputs":[{"name":"self"}],"output":{"name":"typevariablevalue"}}],[11,"fmt","","",215,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"known","","",215,{"inputs":[{"name":"self"}],"output":{"generics":["ty"],"name":"option"}}],[11,"is_unknown","","",215,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"new","","",216,{"inputs":[],"output":{"name":"typevariabletable"}}],[11,"var_diverges","","Returns the diverges flag given when `vid` was created.",216,{"inputs":[{"name":"self"},{"name":"tyvid"}],"output":{"name":"bool"}}],[11,"var_origin","","Returns the origin that was given when `vid` was created.",216,{"inputs":[{"name":"self"},{"name":"tyvid"}],"output":{"name":"typevariableorigin"}}],[11,"equate","","Records that `a == b`, depending on `dir`.",216,{"inputs":[{"name":"self"},{"name":"tyvid"},{"name":"tyvid"}],"output":null}],[11,"sub","","Records that `a <: b`, depending on `dir`.",216,{"inputs":[{"name":"self"},{"name":"tyvid"},{"name":"tyvid"}],"output":null}],[11,"instantiate","","Instantiates `vid` with the type `ty`.",216,{"inputs":[{"name":"self"},{"name":"tyvid"},{"name":"ty"}],"output":null}],[11,"new_var","","Creates a new type variable.",216,{"inputs":[{"name":"self"},{"name":"bool"},{"name":"typevariableorigin"}],"output":{"name":"tyvid"}}],[11,"num_vars","","Returns the number of type variables created thus far.",216,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"root_var","","Returns the \"root\" variable of `vid` in the `eq_relations` equivalence table. All type variables that have been equated will yield the same root variable (per the union-find algorithm), so `root_var(a) == root_var(b)` implies that `a == b` (transitively).",216,{"inputs":[{"name":"self"},{"name":"tyvid"}],"output":{"name":"tyvid"}}],[11,"sub_root_var","","Returns the \"root\" variable of `vid` in the `sub_relations` equivalence table. All type variables that have been are related via equality or subtyping will yield the same root variable (per the union-find algorithm), so `sub_root_var(a) == sub_root_var(b)` implies that:",216,{"inputs":[{"name":"self"},{"name":"tyvid"}],"output":{"name":"tyvid"}}],[11,"sub_unified","","True if `a` and `b` have same \"sub-root\" (i.e., exists some type X such that `forall i in {a, b}. (i <: X || X <: i)`.",216,{"inputs":[{"name":"self"},{"name":"tyvid"},{"name":"tyvid"}],"output":{"name":"bool"}}],[11,"probe","","Retrieves the type to which `vid` has been instantiated, if any.",216,{"inputs":[{"name":"self"},{"name":"tyvid"}],"output":{"name":"typevariablevalue"}}],[11,"replace_if_possible","","If `t` is a type-inference variable, and it has been instantiated, then return the with which it was instantiated. Otherwise, returns `t`.",216,{"inputs":[{"name":"self"},{"name":"ty"}],"output":{"name":"ty"}}],[11,"snapshot","","Creates a snapshot of the type variable state.  This snapshot must later be committed (`commit()`) or rolled back (`rollback_to()`).  Nested snapshots are permitted, but must be processed in a stack-like fashion.",216,{"inputs":[{"name":"self"}],"output":{"name":"snapshot"}}],[11,"rollback_to","","Undoes all changes since the snapshot was created. Any snapshots created since that point must already have been committed or rolled back.",216,{"inputs":[{"name":"self"},{"name":"snapshot"}],"output":null}],[11,"commit","","Commits all changes since the snapshot was created, making them permanent (unless this snapshot was created within another snapshot). Any snapshots created since that point must already have been committed or rolled back.",216,{"inputs":[{"name":"self"},{"name":"snapshot"}],"output":null}],[11,"types_created_since_snapshot","","Returns a map `{V1 -> V2}`, where the keys `{V1}` are ty-variables created during the snapshot, and the values `{V2}` are the root variables that they were unified with, along with their origin.",216,{"inputs":[{"name":"self"},{"name":"snapshot"}],"output":{"name":"typevariablemap"}}],[11,"types_escaping_snapshot","","Find the set of type variables that existed before `s` but which have only been unified since `s` started, and return the types with which they were unified. So if we had a type variable `V0`, then we started the snapshot, then we created a type variable `V1`, unifed `V0` with `T0`, and unified `V1` with `T1`, this function would return `{T0}`.",216,{"inputs":[{"name":"self"},{"name":"snapshot"}],"output":{"generics":["ty"],"name":"vec"}}],[11,"unsolved_variables","","Returns indices of all variables that are not yet instantiated.",216,{"inputs":[{"name":"self"}],"output":{"generics":["tyvid"],"name":"vec"}}],[11,"unify_values","","",215,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"generics":["noerror"],"name":"result"}}],[0,"unify_key","rustc::infer","",null,null],[3,"RegionVidKey","rustc::infer::unify_key","",null,null],[12,"min_vid","","The minimum region vid in the unification set. This is needed to have a canonical name for a type to prevent infinite recursion.",217,null],[8,"ToType","","",null,null],[10,"to_type","","",218,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"ty"}}],[11,"eq","","",217,{"inputs":[{"name":"self"},{"name":"regionvidkey"}],"output":{"name":"bool"}}],[11,"ne","","",217,{"inputs":[{"name":"self"},{"name":"regionvidkey"}],"output":{"name":"bool"}}],[11,"clone","","",217,{"inputs":[{"name":"self"}],"output":{"name":"regionvidkey"}}],[11,"fmt","","",217,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"unify_values","","",217,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"generics":["noerror"],"name":"result"}}],[6,"InferResult","rustc::infer","",null,null],[6,"Bound","","",null,null],[6,"UnitResult","","",null,null],[6,"FixupResult","","",null,null],[6,"SkolemizationMap","","A map returned by `skolemize_late_bound_regions()` indicating the skolemized region that each late-bound region was replaced with.",null,null],[11,"fmt","","",172,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",175,{"inputs":[{"name":"self"}],"output":{"name":"valuepairs"}}],[11,"fmt","","",175,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",219,{"inputs":[{"name":"self"}],"output":{"name":"typetrace"}}],[11,"clone","","",176,{"inputs":[{"name":"self"}],"output":{"name":"subregionorigin"}}],[11,"fmt","","",176,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",177,{"inputs":[{"name":"self"}],"output":{"name":"parameterorigin"}}],[11,"fmt","","",177,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",178,{"inputs":[{"name":"self"}],"output":{"name":"lateboundregionconversiontime"}}],[11,"fmt","","",178,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",179,{"inputs":[{"name":"self"}],"output":{"name":"regionvariableorigin"}}],[11,"fmt","","",179,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",180,{"inputs":[{"name":"self"}],"output":{"name":"nllregionvariableorigin"}}],[11,"fmt","","",180,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",180,{"inputs":[{"name":"self"},{"name":"nllregionvariableorigin"}],"output":{"name":"bool"}}],[11,"ne","","",180,{"inputs":[{"name":"self"},{"name":"nllregionvariableorigin"}],"output":{"name":"bool"}}],[11,"hash","","",180,null],[11,"clone","","",181,{"inputs":[{"name":"self"}],"output":{"name":"fixuperror"}}],[11,"fmt","","",181,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",174,{"inputs":[{"name":"self"}],"output":{"name":"regionobligation"}}],[11,"fmt","","",181,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"with_fresh_in_progress_tables","","Used only by `rustc_typeck` during body type-checking/inference, will initialize `in_progress_tables` with fresh `TypeckTables`.",220,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"self"}}],[11,"enter","","",220,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"r"}}],[11,"unit","","",172,{"inputs":[{"name":"self"}],"output":{"name":"inferok"}}],[11,"into_obligations","","",172,{"inputs":[{"name":"self"}],"output":{"name":"predicateobligations"}}],[11,"is_in_snapshot","","",173,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"freshen","","",173,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"t"}}],[11,"type_var_diverges","","",173,{"inputs":[{"name":"self"},{"name":"ty"}],"output":{"name":"bool"}}],[11,"freshener","","",173,{"inputs":[{"name":"self"}],"output":{"name":"typefreshener"}}],[11,"type_is_unconstrained_numeric","","",173,{"inputs":[{"name":"self"},{"name":"ty"}],"output":{"name":"unconstrainednumeric"}}],[11,"unsolved_variables","","",173,{"inputs":[{"name":"self"}],"output":{"generics":["ty"],"name":"vec"}}],[11,"save_and_restore_in_snapshot_flag","","",173,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"r"}}],[11,"commit_unconditionally","","Execute `f` and commit the bindings",173,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"r"}}],[11,"commit_if_ok","","Execute `f` and commit the bindings if closure `f` returns `Ok(_)`",173,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"result"}}],[11,"in_snapshot","","",173,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"t"}}],[11,"probe","","Execute `f` then unroll any bindings it creates",173,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"r"}}],[11,"add_given","","",173,{"inputs":[{"name":"self"},{"name":"region"},{"name":"regionvid"}],"output":null}],[11,"can_sub","","",173,{"inputs":[{"name":"self"},{"name":"paramenv"},{"name":"t"},{"name":"t"}],"output":{"name":"unitresult"}}],[11,"can_eq","","",173,{"inputs":[{"name":"self"},{"name":"paramenv"},{"name":"t"},{"name":"t"}],"output":{"name":"unitresult"}}],[11,"sub_regions","","",173,{"inputs":[{"name":"self"},{"name":"subregionorigin"},{"name":"region"},{"name":"region"}],"output":null}],[11,"subtype_predicate","","",173,{"inputs":[{"name":"self"},{"name":"obligationcause"},{"name":"paramenv"},{"name":"polysubtypepredicate"}],"output":{"generics":["inferresult"],"name":"option"}}],[11,"region_outlives_predicate","","",173,{"inputs":[{"name":"self"},{"name":"obligationcause"},{"name":"polyregionoutlivespredicate"}],"output":{"name":"unitresult"}}],[11,"next_ty_var_id","","",173,{"inputs":[{"name":"self"},{"name":"bool"},{"name":"typevariableorigin"}],"output":{"name":"tyvid"}}],[11,"next_ty_var","","",173,{"inputs":[{"name":"self"},{"name":"typevariableorigin"}],"output":{"name":"ty"}}],[11,"next_diverging_ty_var","","",173,{"inputs":[{"name":"self"},{"name":"typevariableorigin"}],"output":{"name":"ty"}}],[11,"next_int_var_id","","",173,{"inputs":[{"name":"self"}],"output":{"name":"intvid"}}],[11,"next_float_var_id","","",173,{"inputs":[{"name":"self"}],"output":{"name":"floatvid"}}],[11,"next_region_var","","Create a fresh region variable with the next available index.",173,{"inputs":[{"name":"self"},{"name":"regionvariableorigin"}],"output":{"name":"region"}}],[11,"num_region_vars","","Number of region variables created so far.",173,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"next_nll_region_var","","Just a convenient wrapper of `next_region_var` for using during NLL.",173,{"inputs":[{"name":"self"},{"name":"nllregionvariableorigin"}],"output":{"name":"region"}}],[11,"region_var_for_def","","Create a region inference variable for the given region parameter definition.",173,{"inputs":[{"name":"self"},{"name":"span"},{"name":"regionparameterdef"}],"output":{"name":"region"}}],[11,"type_var_for_def","","Create a type inference variable for the given type parameter definition. The substitutions are for actual parameters that may be referred to by the default of this type parameter, if it exists. E.g. `struct Foo<A, B, C = (A, B)>(...);` when used in a path such as `Foo::<T, U>::new()` will use an inference variable for `C` with `[T, U]` as the substitutions for the default, `(T, U)`.",173,{"inputs":[{"name":"self"},{"name":"span"},{"name":"typeparameterdef"}],"output":{"name":"ty"}}],[11,"fresh_substs_for_item","","Given a set of generics defined on a type or impl, returns a substitution mapping each type/region parameter to a fresh inference variable.",173,{"inputs":[{"name":"self"},{"name":"span"},{"name":"defid"}],"output":{"name":"substs"}}],[11,"is_tainted_by_errors","","True if errors have been reported since this infcx was created.  This is sometimes used as a heuristic to skip reporting errors that often occur as a result of earlier errors, but where it's hard to be 100% sure (e.g., unresolved inference variables, regionck errors).",173,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"set_tainted_by_errors","","Set the \"tainted by errors\" flag to true. We call this when we observe an error from a prior pass.",173,{"inputs":[{"name":"self"}],"output":null}],[11,"resolve_regions_and_report_errors","","Process the region constraints and report any errors that result. After this, no more unification operations should be done -- or the compiler will panic -- but it is legal to use `resolve_type_vars_if_possible` as well as `fully_resolve`.",173,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"scopetree"},{"name":"outlivesenvironment"}],"output":null}],[11,"resolve_regions_and_report_errors_unless_nll","","Like `resolve_regions_and_report_errors`, but skips error reporting if NLL is enabled.  This is used for fn bodies where the same error may later be reported by the NLL-based inference.",173,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"scopetree"},{"name":"outlivesenvironment"}],"output":null}],[11,"take_and_reset_region_constraints","","Obtains (and clears) the current set of region constraints. The inference context is still usable: further unifications will simply add new constraints.",173,{"inputs":[{"name":"self"}],"output":{"name":"regionconstraintdata"}}],[11,"with_region_constraints","","Gives temporary access to the region constraint data.",173,null],[11,"take_region_var_origins","","Takes ownership of the list of variable regions. This implies that all the region constriants have already been taken, and hence that `resolve_regions_and_report_errors` can never be called. This is used only during NLL processing to \"hand off\" ownership of the set of region vairables into the NLL region context.",173,{"inputs":[{"name":"self"}],"output":{"name":"varorigins"}}],[11,"ty_to_string","","",173,{"inputs":[{"name":"self"},{"name":"ty"}],"output":{"name":"string"}}],[11,"tys_to_string","","",173,null],[11,"trait_ref_to_string","","",173,{"inputs":[{"name":"self"},{"name":"traitref"}],"output":{"name":"string"}}],[11,"shallow_resolve","","",173,{"inputs":[{"name":"self"},{"name":"ty"}],"output":{"name":"ty"}}],[11,"resolve_type_vars_if_possible","","Where possible, replaces type/int/float variables in `value` with their final value. Note that region variables are unaffected. If a type variable has not been unified, it is left as is.  This is an idempotent operation that does not affect inference state in any way and so you can do it at will.",173,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"t"}}],[11,"any_unresolved_type_vars","","Returns true if `T` contains unresolved type variables. In the process of visiting `T`, this will resolve (where possible) type variables in `T`, but it never constructs the final, resolved type, so it's more efficient than `resolve_type_vars_if_possible()`.",173,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"bool"}}],[11,"resolve_type_and_region_vars_if_possible","","",173,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"t"}}],[11,"fully_resolve","","Attempts to resolve all type/region variables in `value`. Region inference must have been run already (e.g., by calling `resolve_regions_and_report_errors`).  If some variable was never unified, an `Err` results.",173,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"fixupresult"}}],[11,"type_error_struct_with_diag","","",173,{"inputs":[{"name":"self"},{"name":"span"},{"name":"m"},{"name":"ty"}],"output":{"name":"diagnosticbuilder"}}],[11,"report_mismatched_types","","",173,{"inputs":[{"name":"self"},{"name":"obligationcause"},{"name":"ty"},{"name":"ty"},{"name":"typeerror"}],"output":{"name":"diagnosticbuilder"}}],[11,"replace_late_bound_regions_with_fresh_var","","",173,null],[11,"match_poly_projection_predicate","","Given a higher-ranked projection predicate like:",173,{"inputs":[{"name":"self"},{"name":"obligationcause"},{"name":"paramenv"},{"name":"polyprojectionpredicate"},{"name":"traitref"}],"output":{"generics":["hrmatchresult"],"name":"inferresult"}}],[11,"verify_generic_bound","","See `verify_generic_bound` method in `region_constraints`",173,{"inputs":[{"name":"self"},{"name":"subregionorigin"},{"name":"generickind"},{"name":"region"},{"name":"verifybound"}],"output":null}],[11,"type_moves_by_default","","",173,{"inputs":[{"name":"self"},{"name":"paramenv"},{"name":"ty"},{"name":"span"}],"output":{"name":"bool"}}],[11,"closure_kind","","Obtains the latest type of the given closure; this may be a closure in the current function, in which case its `ClosureKind` may not yet be known.",173,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"closuresubsts"}],"output":{"generics":["closurekind"],"name":"option"}}],[11,"closure_sig","","Obtain the signature of a closure.  For closures, unlike `tcx.fn_sig(def_id)`, this method will work during the type-checking of the enclosing function and return the closure signature in its partially inferred state.",173,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"closuresubsts"}],"output":{"name":"polyfnsig"}}],[11,"partially_normalize_associated_types_in","","Normalizes associated types in `value`, potentially returning new obligations that must further be processed.",173,{"inputs":[{"name":"self"},{"name":"span"},{"name":"nodeid"},{"name":"paramenv"},{"name":"t"}],"output":{"name":"inferok"}}],[11,"borrow_region_constraints","","",173,{"inputs":[{"name":"self"}],"output":{"generics":["regionconstraintcollector"],"name":"refmut"}}],[11,"clear_caches","","Clears the selection, evaluation, and projection cachesThis is useful when repeatedly attemping to select an Obligation while changing only its ParamEnv, since FulfillmentContext doesn't use 'probe'",173,{"inputs":[{"name":"self"}],"output":null}],[11,"span","","",219,{"inputs":[{"name":"self"}],"output":{"name":"span"}}],[11,"types","","",219,{"inputs":[{"name":"obligationcause"},{"name":"bool"},{"name":"ty"},{"name":"ty"}],"output":{"name":"typetrace"}}],[11,"dummy","","",219,{"inputs":[{"name":"tyctxt"}],"output":{"name":"typetrace"}}],[11,"fmt","","",219,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"span","","",176,{"inputs":[{"name":"self"}],"output":{"name":"span"}}],[11,"from_obligation_cause","","",176,{"inputs":[{"name":"obligationcause"},{"name":"f"}],"output":{"name":"self"}}],[11,"span","","",179,{"inputs":[{"name":"self"}],"output":{"name":"span"}}],[11,"super_fold_with","","",175,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",175,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"fmt","","",174,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[0,"lint","rustc","Lints, aka compiler warnings.",null,null],[3,"LateContext","rustc::lint","Context for lint checking after type checking.",null,null],[12,"tcx","","Type context we're checking in.",221,null],[12,"tables","","Side-tables for the body we are in.",221,null],[12,"param_env","","Parameter environment for the item we are in.",221,null],[12,"access_levels","","Items accessible from the crate being checked.",221,null],[12,"generics","","Generic type parameters in scope for the item we are in.",221,null],[3,"EarlyContext","","Context for lint checking of the AST, after expansion, before lowering to HIR.",null,null],[12,"sess","","Type context we're checking in.",222,null],[12,"krate","","The crate being checked.",222,null],[3,"LintStore","","Information about the registered lints.",null,null],[3,"FutureIncompatibleInfo","","Extra information for a future incompatibility lint. See the call to `register_future_incompatible` in `librustc_lint/lib.rs` for guidelines.",null,null],[12,"id","","",223,null],[12,"reference","","e.g., a URL for an issue/PR/RFC or error code",223,null],[12,"edition","","If this is an edition fixing lint, the edition in which this lint becomes obsolete",223,null],[3,"BufferedEarlyLint","","Lints that are buffered up early on in the `Session` before the `LintLevels` is calculated",null,null],[12,"lint_id","","",224,null],[12,"ast_id","","",224,null],[12,"span","","",224,null],[12,"msg","","",224,null],[12,"diagnostic","","",224,null],[3,"Lint","","Specification of a single lint.",null,null],[12,"name","","A string identifier for the lint.",225,null],[12,"default_level","","Default level for the lint.",225,null],[12,"desc","","Description of the lint or the issue it detects.",225,null],[12,"edition_deny","","Deny lint after this edition",225,null],[3,"LintId","","Identifies a lint known to the compiler.",null,null],[3,"LintLevelSets","","",null,null],[3,"LintLevelMap","","",null,null],[3,"LintBuffer","","",null,null],[4,"Level","","Setting for how to handle a lint.",null,null],[13,"Allow","","",226,null],[13,"Warn","","",226,null],[13,"Deny","","",226,null],[13,"Forbid","","",226,null],[4,"LintSource","","How a lint level was set.",null,null],[13,"Default","","Lint is at the default level as declared in rustc or a plugin.",227,null],[13,"Node","","Lint level was set by an attribute.",227,null],[13,"CommandLine","","Lint level was set by a command-line flag.",227,null],[5,"check_crate","","Perform lint checking on a crate.",null,{"inputs":[{"name":"tyctxt"}],"output":null}],[5,"check_ast_crate","","",null,{"inputs":[{"name":"session"},{"name":"crate"}],"output":null}],[5,"struct_lint_level","","",null,{"inputs":[{"name":"session"},{"name":"lint"},{"name":"level"},{"name":"lintsource"},{"generics":["multispan"],"name":"option"},{"name":"str"}],"output":{"name":"diagnosticbuilder"}}],[5,"provide","","",null,{"inputs":[{"name":"providers"}],"output":null}],[0,"builtin","","Some lints that are built in to the compiler.",null,null],[3,"HardwiredLints","rustc::lint::builtin","Does nothing as a lint pass, but registers some `Lint`s which are used by other parts of the compiler.",null,null],[4,"BuiltinLintDiagnostics","","",null,null],[13,"Normal","","",228,null],[13,"BareTraitObject","","",228,null],[7,"EXCEEDING_BITSHIFTS","","",null,null],[7,"CONST_ERR","","",null,null],[7,"UNUSED_IMPORTS","","",null,null],[7,"UNUSED_EXTERN_CRATES","","",null,null],[7,"UNUSED_QUALIFICATIONS","","",null,null],[7,"UNKNOWN_LINTS","","",null,null],[7,"UNUSED_VARIABLES","","",null,null],[7,"UNUSED_ASSIGNMENTS","","",null,null],[7,"DEAD_CODE","","",null,null],[7,"UNREACHABLE_CODE","","",null,null],[7,"UNREACHABLE_PATTERNS","","",null,null],[7,"UNUSED_MACROS","","",null,null],[7,"WARNINGS","","",null,null],[7,"UNUSED_FEATURES","","",null,null],[7,"STABLE_FEATURES","","",null,null],[7,"UNKNOWN_CRATE_TYPES","","",null,null],[7,"TRIVIAL_CASTS","","",null,null],[7,"TRIVIAL_NUMERIC_CASTS","","",null,null],[7,"PRIVATE_IN_PUBLIC","","",null,null],[7,"PUB_USE_OF_PRIVATE_EXTERN_CRATE","","",null,null],[7,"INVALID_TYPE_PARAM_DEFAULT","","",null,null],[7,"RENAMED_AND_REMOVED_LINTS","","",null,null],[7,"SAFE_EXTERN_STATICS","","",null,null],[7,"SAFE_PACKED_BORROWS","","",null,null],[7,"PATTERNS_IN_FNS_WITHOUT_BODY","","",null,null],[7,"LEGACY_DIRECTORY_OWNERSHIP","","",null,null],[7,"LEGACY_IMPORTS","","",null,null],[7,"LEGACY_CONSTRUCTOR_VISIBILITY","","",null,null],[7,"MISSING_FRAGMENT_SPECIFIER","","",null,null],[7,"PARENTHESIZED_PARAMS_IN_TYPES_AND_MODULES","","",null,null],[7,"LATE_BOUND_LIFETIME_ARGUMENTS","","",null,null],[7,"INCOHERENT_FUNDAMENTAL_IMPLS","","",null,null],[7,"DEPRECATED","","",null,null],[7,"UNUSED_UNSAFE","","",null,null],[7,"UNUSED_MUT","","",null,null],[7,"SINGLE_USE_LIFETIME","","",null,null],[7,"TYVAR_BEHIND_RAW_POINTER","","",null,null],[7,"ELIDED_LIFETIME_IN_PATH","","",null,null],[7,"BARE_TRAIT_OBJECT","","",null,null],[7,"ILLEGAL_FLOATING_POINT_LITERAL_PATTERN","","",null,null],[7,"UNSTABLE_NAME_COLLISION","","",null,null],[11,"clone","","",229,{"inputs":[{"name":"self"}],"output":{"name":"hardwiredlints"}}],[11,"get_lints","","",229,{"inputs":[{"name":"self"}],"output":{"name":"lintarray"}}],[11,"eq","","",228,{"inputs":[{"name":"self"},{"name":"builtinlintdiagnostics"}],"output":{"name":"bool"}}],[11,"ne","","",228,{"inputs":[{"name":"self"},{"name":"builtinlintdiagnostics"}],"output":{"name":"bool"}}],[11,"encode","","",228,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",228,{"inputs":[{"name":"__d"}],"output":{"generics":["builtinlintdiagnostics"],"name":"result"}}],[11,"fmt","","",228,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"run","","",228,{"inputs":[{"name":"self"},{"name":"session"},{"name":"diagnosticbuilder"}],"output":null}],[11,"eq","rustc::lint","",224,{"inputs":[{"name":"self"},{"name":"bufferedearlylint"}],"output":{"name":"bool"}}],[11,"ne","","",224,{"inputs":[{"name":"self"},{"name":"bufferedearlylint"}],"output":{"name":"bool"}}],[11,"encode","","",224,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",224,{"inputs":[{"name":"__d"}],"output":{"generics":["bufferedearlylint"],"name":"result"}}],[11,"fmt","","",224,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","",230,{"inputs":[],"output":{"name":"lintstore"}}],[11,"get_lints","","",230,null],[11,"get_lint_groups","","",230,{"inputs":[{"name":"self"}],"output":{"name":"vec"}}],[11,"register_early_pass","","",230,{"inputs":[{"name":"self"},{"generics":["session"],"name":"option"},{"name":"bool"},{"name":"earlylintpassobject"}],"output":null}],[11,"register_late_pass","","",230,{"inputs":[{"name":"self"},{"generics":["session"],"name":"option"},{"name":"bool"},{"name":"latelintpassobject"}],"output":null}],[11,"register_future_incompatible","","",230,{"inputs":[{"name":"self"},{"generics":["session"],"name":"option"},{"generics":["futureincompatibleinfo"],"name":"vec"}],"output":null}],[11,"future_incompatible","","",230,{"inputs":[{"name":"self"},{"name":"lintid"}],"output":{"generics":["futureincompatibleinfo"],"name":"option"}}],[11,"register_group","","",230,{"inputs":[{"name":"self"},{"generics":["session"],"name":"option"},{"name":"bool"},{"name":"str"},{"generics":["lintid"],"name":"vec"}],"output":null}],[11,"register_renamed","","",230,{"inputs":[{"name":"self"},{"name":"str"},{"name":"str"}],"output":null}],[11,"register_removed","","",230,{"inputs":[{"name":"self"},{"name":"str"},{"name":"str"}],"output":null}],[11,"find_lints","","",230,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"generics":["vec","findlinterror"],"name":"result"}}],[11,"check_lint_name_cmdline","","Checks the validity of lint names derived from the command line",230,{"inputs":[{"name":"self"},{"name":"session"},{"name":"str"},{"name":"level"}],"output":null}],[11,"check_lint_name","","Checks the name of a lint for its existence, and whether it was renamed or removed. Generates a DiagnosticBuilder containing a warning for renamed and removed lints. This is over both lint names from attributes and those passed on the command line. Since it emits non-fatal warnings and there are two lint passes that inspect attributes, this is only run from the late pass to avoid printing duplicate warnings.",230,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"checklintnameresult"}}],[11,"sess","","Get the overall compiler `Session` object.",221,{"inputs":[{"name":"self"}],"output":{"name":"session"}}],[11,"lints","","",221,{"inputs":[{"name":"self"}],"output":{"name":"lintstore"}}],[11,"lint_sess","","",221,{"inputs":[{"name":"self"}],"output":{"name":"lintsession"}}],[11,"lint_sess_mut","","",221,{"inputs":[{"name":"self"}],"output":{"name":"lintsession"}}],[11,"enter_attrs","","",221,null],[11,"exit_attrs","","",221,null],[11,"lookup","","",221,{"inputs":[{"name":"self"},{"name":"lint"},{"name":"option"},{"name":"str"}],"output":{"name":"diagnosticbuilder"}}],[11,"with_lint_attrs","","",221,null],[11,"sess","","Get the overall compiler `Session` object.",222,{"inputs":[{"name":"self"}],"output":{"name":"session"}}],[11,"lints","","",222,{"inputs":[{"name":"self"}],"output":{"name":"lintstore"}}],[11,"lint_sess","","",222,{"inputs":[{"name":"self"}],"output":{"name":"lintsession"}}],[11,"lint_sess_mut","","",222,{"inputs":[{"name":"self"}],"output":{"name":"lintsession"}}],[11,"enter_attrs","","",222,null],[11,"exit_attrs","","",222,null],[11,"lookup","","",222,{"inputs":[{"name":"self"},{"name":"lint"},{"name":"option"},{"name":"str"}],"output":{"name":"diagnosticbuilder"}}],[11,"with_lint_attrs","","",222,null],[11,"nested_visit_map","","Because lints are scoped lexically, we want to walk nested items in the context of the outer item, so enable deep-walking.",221,{"inputs":[{"name":"self"}],"output":{"name":"nestedvisitormap"}}],[11,"visit_nested_body","","",221,{"inputs":[{"name":"self"},{"name":"bodyid"}],"output":null}],[11,"visit_body","","",221,{"inputs":[{"name":"self"},{"name":"body"}],"output":null}],[11,"visit_item","","",221,{"inputs":[{"name":"self"},{"name":"item"}],"output":null}],[11,"visit_foreign_item","","",221,{"inputs":[{"name":"self"},{"name":"foreignitem"}],"output":null}],[11,"visit_pat","","",221,{"inputs":[{"name":"self"},{"name":"pat"}],"output":null}],[11,"visit_expr","","",221,{"inputs":[{"name":"self"},{"name":"expr"}],"output":null}],[11,"visit_stmt","","",221,{"inputs":[{"name":"self"},{"name":"stmt"}],"output":null}],[11,"visit_fn","","",221,{"inputs":[{"name":"self"},{"name":"fnkind"},{"name":"fndecl"},{"name":"bodyid"},{"name":"span"},{"name":"nodeid"}],"output":null}],[11,"visit_variant_data","","",221,{"inputs":[{"name":"self"},{"name":"variantdata"},{"name":"name"},{"name":"generics"},{"name":"nodeid"},{"name":"span"}],"output":null}],[11,"visit_struct_field","","",221,{"inputs":[{"name":"self"},{"name":"structfield"}],"output":null}],[11,"visit_variant","","",221,{"inputs":[{"name":"self"},{"name":"variant"},{"name":"generics"},{"name":"nodeid"}],"output":null}],[11,"visit_ty","","",221,{"inputs":[{"name":"self"},{"name":"ty"}],"output":null}],[11,"visit_name","","",221,{"inputs":[{"name":"self"},{"name":"span"},{"name":"name"}],"output":null}],[11,"visit_mod","","",221,{"inputs":[{"name":"self"},{"name":"mod"},{"name":"span"},{"name":"nodeid"}],"output":null}],[11,"visit_local","","",221,{"inputs":[{"name":"self"},{"name":"local"}],"output":null}],[11,"visit_block","","",221,{"inputs":[{"name":"self"},{"name":"block"}],"output":null}],[11,"visit_arm","","",221,{"inputs":[{"name":"self"},{"name":"arm"}],"output":null}],[11,"visit_decl","","",221,{"inputs":[{"name":"self"},{"name":"decl"}],"output":null}],[11,"visit_generic_param","","",221,{"inputs":[{"name":"self"},{"name":"genericparam"}],"output":null}],[11,"visit_generics","","",221,{"inputs":[{"name":"self"},{"name":"generics"}],"output":null}],[11,"visit_where_predicate","","",221,{"inputs":[{"name":"self"},{"name":"wherepredicate"}],"output":null}],[11,"visit_poly_trait_ref","","",221,{"inputs":[{"name":"self"},{"name":"polytraitref"},{"name":"traitboundmodifier"}],"output":null}],[11,"visit_trait_item","","",221,{"inputs":[{"name":"self"},{"name":"traititem"}],"output":null}],[11,"visit_impl_item","","",221,{"inputs":[{"name":"self"},{"name":"implitem"}],"output":null}],[11,"visit_lifetime","","",221,{"inputs":[{"name":"self"},{"name":"lifetime"}],"output":null}],[11,"visit_path","","",221,{"inputs":[{"name":"self"},{"name":"path"},{"name":"nodeid"}],"output":null}],[11,"visit_attribute","","",221,{"inputs":[{"name":"self"},{"name":"attribute"}],"output":null}],[11,"visit_item","","",222,{"inputs":[{"name":"self"},{"name":"item"}],"output":null}],[11,"visit_foreign_item","","",222,{"inputs":[{"name":"self"},{"name":"foreignitem"}],"output":null}],[11,"visit_pat","","",222,{"inputs":[{"name":"self"},{"name":"pat"}],"output":null}],[11,"visit_expr","","",222,{"inputs":[{"name":"self"},{"name":"expr"}],"output":null}],[11,"visit_stmt","","",222,{"inputs":[{"name":"self"},{"name":"stmt"}],"output":null}],[11,"visit_fn","","",222,{"inputs":[{"name":"self"},{"name":"fnkind"},{"name":"fndecl"},{"name":"span"},{"name":"nodeid"}],"output":null}],[11,"visit_variant_data","","",222,{"inputs":[{"name":"self"},{"name":"variantdata"},{"name":"ident"},{"name":"generics"},{"name":"nodeid"},{"name":"span"}],"output":null}],[11,"visit_struct_field","","",222,{"inputs":[{"name":"self"},{"name":"structfield"}],"output":null}],[11,"visit_variant","","",222,{"inputs":[{"name":"self"},{"name":"variant"},{"name":"generics"},{"name":"nodeid"}],"output":null}],[11,"visit_ty","","",222,{"inputs":[{"name":"self"},{"name":"ty"}],"output":null}],[11,"visit_ident","","",222,{"inputs":[{"name":"self"},{"name":"span"},{"name":"ident"}],"output":null}],[11,"visit_mod","","",222,null],[11,"visit_local","","",222,{"inputs":[{"name":"self"},{"name":"local"}],"output":null}],[11,"visit_block","","",222,{"inputs":[{"name":"self"},{"name":"block"}],"output":null}],[11,"visit_arm","","",222,{"inputs":[{"name":"self"},{"name":"arm"}],"output":null}],[11,"visit_expr_post","","",222,{"inputs":[{"name":"self"},{"name":"expr"}],"output":null}],[11,"visit_generic_param","","",222,{"inputs":[{"name":"self"},{"name":"genericparam"}],"output":null}],[11,"visit_generics","","",222,{"inputs":[{"name":"self"},{"name":"generics"}],"output":null}],[11,"visit_where_predicate","","",222,{"inputs":[{"name":"self"},{"name":"wherepredicate"}],"output":null}],[11,"visit_poly_trait_ref","","",222,{"inputs":[{"name":"self"},{"name":"polytraitref"},{"name":"traitboundmodifier"}],"output":null}],[11,"visit_trait_item","","",222,{"inputs":[{"name":"self"},{"name":"traititem"}],"output":null}],[11,"visit_impl_item","","",222,{"inputs":[{"name":"self"},{"name":"implitem"}],"output":null}],[11,"visit_lifetime","","",222,{"inputs":[{"name":"self"},{"name":"lifetime"}],"output":null}],[11,"visit_path","","",222,{"inputs":[{"name":"self"},{"name":"path"},{"name":"nodeid"}],"output":null}],[11,"visit_attribute","","",222,{"inputs":[{"name":"self"},{"name":"attribute"}],"output":null}],[11,"visit_mac_def","","",222,{"inputs":[{"name":"self"},{"name":"macrodef"},{"name":"nodeid"}],"output":null}],[11,"encode","","",231,{"inputs":[{"name":"self"},{"name":"s"}],"output":{"name":"result"}}],[11,"decode","","",231,{"inputs":[{"name":"d"}],"output":{"generics":["lintid"],"name":"result"}}],[11,"new","","",232,{"inputs":[{"name":"session"}],"output":{"name":"lintlevelsets"}}],[11,"builder","","",232,{"inputs":[{"name":"session"}],"output":{"name":"lintlevelsbuilder"}}],[11,"level_and_source","","If the `id` was previously registered with `register_id` when building this `LintLevelMap` this returns the corresponding lint level and source of the lint level for the lint provided.",233,{"inputs":[{"name":"self"},{"name":"lint"},{"name":"hirid"},{"name":"session"}],"output":{"name":"option"}}],[11,"lint_level_set","","Returns if this `id` has lint level information.",233,{"inputs":[{"name":"self"},{"name":"hirid"}],"output":{"generics":["u32"],"name":"option"}}],[11,"hash_stable","","",233,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",231,{"inputs":[{"name":"self"},{"name":"hcx"},{"name":"stablehasher"}],"output":null}],[11,"to_stable_hash_key","","",231,{"inputs":[{"name":"self"},{"name":"hcx"}],"output":{"name":"str"}}],[6,"LintArray","","",null,null],[6,"EarlyLintPassObject","","A lint pass boxed up as a trait object.",null,null],[6,"LateLintPassObject","","",null,null],[6,"LevelSource","","",null,null],[8,"LintContext","","",null,null],[16,"PassObject","","",234,null],[10,"sess","","",234,{"inputs":[{"name":"self"}],"output":{"name":"session"}}],[10,"lints","","",234,{"inputs":[{"name":"self"}],"output":{"name":"lintstore"}}],[10,"lint_sess","","",234,{"inputs":[{"name":"self"}],"output":{"name":"lintsession"}}],[10,"lint_sess_mut","","",234,{"inputs":[{"name":"self"}],"output":{"name":"lintsession"}}],[10,"enter_attrs","","",234,null],[10,"exit_attrs","","",234,null],[11,"lookup_and_emit","","",234,{"inputs":[{"name":"self"},{"name":"lint"},{"name":"option"},{"name":"str"}],"output":null}],[11,"lookup_and_emit_with_diagnostics","","",234,{"inputs":[{"name":"self"},{"name":"lint"},{"name":"option"},{"name":"str"},{"name":"builtinlintdiagnostics"}],"output":null}],[10,"lookup","","",234,{"inputs":[{"name":"self"},{"name":"lint"},{"name":"option"},{"name":"str"}],"output":{"name":"diagnosticbuilder"}}],[11,"span_lint","","Emit a lint at the appropriate level, for a particular span.",234,{"inputs":[{"name":"self"},{"name":"lint"},{"name":"s"},{"name":"str"}],"output":null}],[11,"struct_span_lint","","",234,{"inputs":[{"name":"self"},{"name":"lint"},{"name":"s"},{"name":"str"}],"output":{"name":"diagnosticbuilder"}}],[11,"span_lint_note","","Emit a lint and note at the appropriate level, for a particular span.",234,{"inputs":[{"name":"self"},{"name":"lint"},{"name":"span"},{"name":"str"},{"name":"span"},{"name":"str"}],"output":null}],[11,"span_lint_help","","Emit a lint and help at the appropriate level, for a particular span.",234,{"inputs":[{"name":"self"},{"name":"lint"},{"name":"span"},{"name":"str"},{"name":"str"}],"output":null}],[11,"lint","","Emit a lint at the appropriate level, with no associated span.",234,{"inputs":[{"name":"self"},{"name":"lint"},{"name":"str"}],"output":null}],[10,"with_lint_attrs","","Merge the lints specified by any lint attributes into the current lint context, call the provided function, then reset the lints in effect to their previous state.",234,null],[8,"LintPass","","",null,null],[10,"get_lints","","Get descriptions of the lints this `LintPass` object can emit.",235,{"inputs":[{"name":"self"}],"output":{"name":"lintarray"}}],[8,"LateLintPass","","Trait for types providing lint checks.",null,null],[11,"check_body","","",236,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"body"}],"output":null}],[11,"check_body_post","","",236,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"body"}],"output":null}],[11,"check_name","","",236,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"span"},{"name":"name"}],"output":null}],[11,"check_crate","","",236,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"crate"}],"output":null}],[11,"check_crate_post","","",236,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"crate"}],"output":null}],[11,"check_mod","","",236,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"mod"},{"name":"span"},{"name":"nodeid"}],"output":null}],[11,"check_mod_post","","",236,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"mod"},{"name":"span"},{"name":"nodeid"}],"output":null}],[11,"check_foreign_item","","",236,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"foreignitem"}],"output":null}],[11,"check_foreign_item_post","","",236,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"foreignitem"}],"output":null}],[11,"check_item","","",236,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"item"}],"output":null}],[11,"check_item_post","","",236,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"item"}],"output":null}],[11,"check_local","","",236,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"local"}],"output":null}],[11,"check_block","","",236,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"block"}],"output":null}],[11,"check_block_post","","",236,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"block"}],"output":null}],[11,"check_stmt","","",236,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"stmt"}],"output":null}],[11,"check_arm","","",236,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"arm"}],"output":null}],[11,"check_pat","","",236,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"pat"}],"output":null}],[11,"check_decl","","",236,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"decl"}],"output":null}],[11,"check_expr","","",236,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"expr"}],"output":null}],[11,"check_expr_post","","",236,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"expr"}],"output":null}],[11,"check_ty","","",236,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"ty"}],"output":null}],[11,"check_generic_param","","",236,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"genericparam"}],"output":null}],[11,"check_generics","","",236,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"generics"}],"output":null}],[11,"check_where_predicate","","",236,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"wherepredicate"}],"output":null}],[11,"check_poly_trait_ref","","",236,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"polytraitref"},{"name":"traitboundmodifier"}],"output":null}],[11,"check_fn","","",236,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"fnkind"},{"name":"fndecl"},{"name":"body"},{"name":"span"},{"name":"nodeid"}],"output":null}],[11,"check_fn_post","","",236,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"fnkind"},{"name":"fndecl"},{"name":"body"},{"name":"span"},{"name":"nodeid"}],"output":null}],[11,"check_trait_item","","",236,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"traititem"}],"output":null}],[11,"check_trait_item_post","","",236,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"traititem"}],"output":null}],[11,"check_impl_item","","",236,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"implitem"}],"output":null}],[11,"check_impl_item_post","","",236,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"implitem"}],"output":null}],[11,"check_struct_def","","",236,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"variantdata"},{"name":"name"},{"name":"generics"},{"name":"nodeid"}],"output":null}],[11,"check_struct_def_post","","",236,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"variantdata"},{"name":"name"},{"name":"generics"},{"name":"nodeid"}],"output":null}],[11,"check_struct_field","","",236,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"structfield"}],"output":null}],[11,"check_variant","","",236,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"variant"},{"name":"generics"}],"output":null}],[11,"check_variant_post","","",236,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"variant"},{"name":"generics"}],"output":null}],[11,"check_lifetime","","",236,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"lifetime"}],"output":null}],[11,"check_path","","",236,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"path"},{"name":"nodeid"}],"output":null}],[11,"check_attribute","","",236,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"attribute"}],"output":null}],[11,"enter_lint_attrs","","Called when entering a syntax node that can have lint attributes such as `#[allow(...)]`. Called with all the attributes of that node.",236,null],[11,"exit_lint_attrs","","Counterpart to `enter_lint_attrs`.",236,null],[8,"EarlyLintPass","","",null,null],[11,"check_ident","","",237,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"span"},{"name":"ident"}],"output":null}],[11,"check_crate","","",237,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"crate"}],"output":null}],[11,"check_crate_post","","",237,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"crate"}],"output":null}],[11,"check_mod","","",237,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"mod"},{"name":"span"},{"name":"nodeid"}],"output":null}],[11,"check_mod_post","","",237,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"mod"},{"name":"span"},{"name":"nodeid"}],"output":null}],[11,"check_foreign_item","","",237,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"foreignitem"}],"output":null}],[11,"check_foreign_item_post","","",237,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"foreignitem"}],"output":null}],[11,"check_item","","",237,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"item"}],"output":null}],[11,"check_item_post","","",237,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"item"}],"output":null}],[11,"check_local","","",237,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"local"}],"output":null}],[11,"check_block","","",237,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"block"}],"output":null}],[11,"check_block_post","","",237,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"block"}],"output":null}],[11,"check_stmt","","",237,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"stmt"}],"output":null}],[11,"check_arm","","",237,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"arm"}],"output":null}],[11,"check_pat","","",237,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"pat"}],"output":null}],[11,"check_expr","","",237,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"expr"}],"output":null}],[11,"check_expr_post","","",237,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"expr"}],"output":null}],[11,"check_ty","","",237,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"ty"}],"output":null}],[11,"check_generic_param","","",237,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"genericparam"}],"output":null}],[11,"check_generics","","",237,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"generics"}],"output":null}],[11,"check_where_predicate","","",237,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"wherepredicate"}],"output":null}],[11,"check_poly_trait_ref","","",237,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"polytraitref"},{"name":"traitboundmodifier"}],"output":null}],[11,"check_fn","","",237,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"fnkind"},{"name":"fndecl"},{"name":"span"},{"name":"nodeid"}],"output":null}],[11,"check_fn_post","","",237,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"fnkind"},{"name":"fndecl"},{"name":"span"},{"name":"nodeid"}],"output":null}],[11,"check_trait_item","","",237,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"traititem"}],"output":null}],[11,"check_trait_item_post","","",237,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"traititem"}],"output":null}],[11,"check_impl_item","","",237,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"implitem"}],"output":null}],[11,"check_impl_item_post","","",237,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"implitem"}],"output":null}],[11,"check_struct_def","","",237,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"variantdata"},{"name":"ident"},{"name":"generics"},{"name":"nodeid"}],"output":null}],[11,"check_struct_def_post","","",237,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"variantdata"},{"name":"ident"},{"name":"generics"},{"name":"nodeid"}],"output":null}],[11,"check_struct_field","","",237,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"structfield"}],"output":null}],[11,"check_variant","","",237,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"variant"},{"name":"generics"}],"output":null}],[11,"check_variant_post","","",237,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"variant"},{"name":"generics"}],"output":null}],[11,"check_lifetime","","",237,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"lifetime"}],"output":null}],[11,"check_path","","",237,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"path"},{"name":"nodeid"}],"output":null}],[11,"check_attribute","","",237,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"attribute"}],"output":null}],[11,"enter_lint_attrs","","Called when entering a syntax node that can have lint attributes such as `#[allow(...)]`. Called with all the attributes of that node.",237,null],[11,"exit_lint_attrs","","Counterpart to `enter_lint_attrs`.",237,null],[11,"clone","","",225,{"inputs":[{"name":"self"}],"output":{"name":"lint"}}],[11,"fmt","","",225,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"name_lower","","Get the lint's name, with ASCII letters converted to lowercase.",225,{"inputs":[{"name":"self"}],"output":{"name":"string"}}],[11,"default_level","","",225,{"inputs":[{"name":"self"},{"name":"session"}],"output":{"name":"level"}}],[11,"clone","","",231,{"inputs":[{"name":"self"}],"output":{"name":"lintid"}}],[11,"fmt","","",231,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",231,{"inputs":[{"name":"self"},{"name":"lintid"}],"output":{"name":"bool"}}],[11,"hash","","",231,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"of","","Get the `LintId` for a `Lint`.",231,{"inputs":[{"name":"lint"}],"output":{"name":"lintid"}}],[11,"lint_name_raw","","",231,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"to_string","","Get the name of the lint.",231,{"inputs":[{"name":"self"}],"output":{"name":"string"}}],[11,"clone","","",226,{"inputs":[{"name":"self"}],"output":{"name":"level"}}],[11,"eq","","",226,{"inputs":[{"name":"self"},{"name":"level"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",226,{"inputs":[{"name":"self"},{"name":"level"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"cmp","","",226,{"inputs":[{"name":"self"},{"name":"level"}],"output":{"name":"ordering"}}],[11,"fmt","","",226,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",226,null],[11,"hash_stable","","",226,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"as_str","","Convert a level to a lower-case string.",226,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"from_str","","Convert a lower-case string to a level.",226,{"inputs":[{"name":"str"}],"output":{"generics":["level"],"name":"option"}}],[11,"clone","","",227,{"inputs":[{"name":"self"}],"output":{"name":"lintsource"}}],[11,"eq","","",227,{"inputs":[{"name":"self"},{"name":"lintsource"}],"output":{"name":"bool"}}],[11,"ne","","",227,{"inputs":[{"name":"self"},{"name":"lintsource"}],"output":{"name":"bool"}}],[11,"hash_stable","","",227,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"new","","",238,{"inputs":[],"output":{"name":"lintbuffer"}}],[11,"add_lint","","",238,{"inputs":[{"name":"self"},{"name":"lint"},{"name":"nodeid"},{"name":"multispan"},{"name":"str"},{"name":"builtinlintdiagnostics"}],"output":null}],[11,"take","","",238,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"generics":["bufferedearlylint"],"name":"vec"}}],[11,"get_any","","",238,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[0,"middle","rustc","",null,null],[0,"allocator","rustc::middle","",null,null],[4,"AllocatorKind","rustc::middle::allocator","",null,null],[13,"Global","","",239,null],[13,"DefaultLib","","",239,null],[13,"DefaultExe","","",239,null],[11,"clone","","",239,{"inputs":[{"name":"self"}],"output":{"name":"allocatorkind"}}],[11,"fn_name","","",239,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"string"}}],[0,"borrowck","rustc::middle","",null,null],[3,"BorrowCheckResult","rustc::middle::borrowck","",null,null],[12,"used_mut_nodes","","",240,null],[11,"fmt","","",240,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",240,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",240,{"inputs":[{"name":"__d"}],"output":{"generics":["borrowcheckresult"],"name":"result"}}],[11,"hash_stable","","",240,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[0,"expr_use_visitor","rustc::middle","A different sort of visitor for walking fn bodies.  Unlike the normal visitor, which just walks the entire body in one shot, the `ExprUseVisitor` determines how expressions are being used.",null,null],[3,"ExprUseVisitor","rustc::middle::expr_use_visitor","",null,null],[4,"LoanCause","","",null,null],[13,"ClosureCapture","","",241,null],[13,"AddrOf","","",241,null],[13,"AutoRef","","",241,null],[13,"AutoUnsafe","","",241,null],[13,"RefBinding","","",241,null],[13,"OverloadedOperator","","",241,null],[13,"ClosureInvocation","","",241,null],[13,"ForLoop","","",241,null],[13,"MatchDiscriminant","","",241,null],[4,"ConsumeMode","","",null,null],[13,"Copy","","",242,null],[13,"Move","","",242,null],[4,"MoveReason","","",null,null],[13,"DirectRefMove","","",243,null],[13,"PatBindingMove","","",243,null],[13,"CaptureMove","","",243,null],[4,"MatchMode","","",null,null],[13,"NonBindingMatch","","",244,null],[13,"BorrowingMatch","","",244,null],[13,"CopyingMatch","","",244,null],[13,"MovingMatch","","",244,null],[4,"MutateMode","","",null,null],[13,"Init","","",245,null],[13,"JustWrite","","",245,null],[13,"WriteAndRead","","",245,null],[8,"Delegate","","This trait defines the callbacks you can expect to receive when employing the ExprUseVisitor.",null,null],[10,"consume","","",246,{"inputs":[{"name":"self"},{"name":"nodeid"},{"name":"span"},{"name":"cmt"},{"name":"consumemode"}],"output":null}],[10,"matched_pat","","",246,{"inputs":[{"name":"self"},{"name":"pat"},{"name":"cmt"},{"name":"matchmode"}],"output":null}],[10,"consume_pat","","",246,{"inputs":[{"name":"self"},{"name":"pat"},{"name":"cmt"},{"name":"consumemode"}],"output":null}],[10,"borrow","","",246,{"inputs":[{"name":"self"},{"name":"nodeid"},{"name":"span"},{"name":"cmt"},{"name":"region"},{"name":"borrowkind"},{"name":"loancause"}],"output":null}],[10,"decl_without_init","","",246,{"inputs":[{"name":"self"},{"name":"nodeid"},{"name":"span"}],"output":null}],[10,"mutate","","",246,{"inputs":[{"name":"self"},{"name":"nodeid"},{"name":"span"},{"name":"cmt"},{"name":"mutatemode"}],"output":null}],[11,"clone","","",241,{"inputs":[{"name":"self"}],"output":{"name":"loancause"}}],[11,"eq","","",241,{"inputs":[{"name":"self"},{"name":"loancause"}],"output":{"name":"bool"}}],[11,"ne","","",241,{"inputs":[{"name":"self"},{"name":"loancause"}],"output":{"name":"bool"}}],[11,"fmt","","",241,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",242,{"inputs":[{"name":"self"}],"output":{"name":"consumemode"}}],[11,"eq","","",242,{"inputs":[{"name":"self"},{"name":"consumemode"}],"output":{"name":"bool"}}],[11,"ne","","",242,{"inputs":[{"name":"self"},{"name":"consumemode"}],"output":{"name":"bool"}}],[11,"fmt","","",242,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",243,{"inputs":[{"name":"self"}],"output":{"name":"movereason"}}],[11,"eq","","",243,{"inputs":[{"name":"self"},{"name":"movereason"}],"output":{"name":"bool"}}],[11,"fmt","","",243,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",244,{"inputs":[{"name":"self"}],"output":{"name":"matchmode"}}],[11,"eq","","",244,{"inputs":[{"name":"self"},{"name":"matchmode"}],"output":{"name":"bool"}}],[11,"fmt","","",244,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",245,{"inputs":[{"name":"self"}],"output":{"name":"mutatemode"}}],[11,"eq","","",245,{"inputs":[{"name":"self"},{"name":"mutatemode"}],"output":{"name":"bool"}}],[11,"fmt","","",245,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates the ExprUseVisitor, configuring it with the various options provided:",247,{"inputs":[{"name":"delegate"},{"name":"tyctxt"},{"name":"paramenv"},{"name":"scopetree"},{"name":"typecktables"},{"generics":["lrc"],"name":"option"}],"output":{"name":"self"}}],[11,"with_infer","","",247,{"inputs":[{"name":"delegate"},{"name":"inferctxt"},{"name":"paramenv"},{"name":"scopetree"},{"name":"typecktables"}],"output":{"name":"self"}}],[11,"consume_body","","",247,{"inputs":[{"name":"self"},{"name":"body"}],"output":null}],[11,"consume_expr","","",247,{"inputs":[{"name":"self"},{"name":"expr"}],"output":null}],[11,"walk_expr","","",247,{"inputs":[{"name":"self"},{"name":"expr"}],"output":null}],[0,"const_val","rustc::middle","",null,null],[3,"ConstEvalErr","rustc::middle::const_val","",null,null],[12,"span","","",248,null],[12,"kind","","",248,null],[3,"FrameInfo","","",null,null],[12,"span","","",249,null],[12,"location","","",249,null],[4,"ConstVal","","",null,null],[13,"Unevaluated","","",250,null],[13,"Value","","",250,null],[4,"ErrKind","","",null,null],[13,"NonConstPath","","",251,null],[13,"UnimplementedConstVal","","",251,null],[13,"IndexOutOfBounds","","",251,null],[12,"len","rustc::middle::const_val::ErrKind","",251,null],[12,"index","","",251,null],[13,"Math","rustc::middle::const_val","",251,null],[13,"LayoutError","","",251,null],[13,"TypeckError","","",251,null],[13,"CheckMatchError","","",251,null],[13,"Miri","","",251,null],[4,"ConstEvalErrDescription","","",null,null],[13,"Simple","","",252,null],[13,"Backtrace","","",252,null],[5,"struct_error","","",null,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"str"}],"output":{"name":"diagnosticbuilder"}}],[6,"EvalResult","","",null,null],[11,"clone","","",250,{"inputs":[{"name":"self"}],"output":{"name":"constval"}}],[11,"fmt","","",250,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",250,null],[11,"encode","","",250,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",250,{"inputs":[{"name":"__d"}],"output":{"generics":["constval"],"name":"result"}}],[11,"eq","","",250,{"inputs":[{"name":"self"},{"name":"constval"}],"output":{"name":"bool"}}],[11,"ne","","",250,{"inputs":[{"name":"self"},{"name":"constval"}],"output":{"name":"bool"}}],[11,"to_raw_bits","","",250,{"inputs":[{"name":"self"}],"output":{"generics":["u128"],"name":"option"}}],[11,"unwrap_u64","","",250,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"clone","","",248,{"inputs":[{"name":"self"}],"output":{"name":"constevalerr"}}],[11,"fmt","","",248,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",251,{"inputs":[{"name":"self"}],"output":{"name":"errkind"}}],[11,"fmt","","",251,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",249,{"inputs":[{"name":"self"}],"output":{"name":"frameinfo"}}],[11,"fmt","","",249,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"from","","",251,{"inputs":[{"name":"constmatherr"}],"output":{"name":"errkind"}}],[11,"clone","","",252,{"inputs":[{"name":"self"}],"output":{"name":"constevalerrdescription"}}],[11,"fmt","","",252,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"into_oneline","","Return a one-line description of the error, for lints and such",252,{"inputs":[{"name":"self"}],"output":{"generics":["str"],"name":"cow"}}],[11,"description","","",248,{"inputs":[{"name":"self"}],"output":{"name":"constevalerrdescription"}}],[11,"struct_error","","",248,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"span"},{"name":"str"}],"output":{"name":"diagnosticbuilder"}}],[11,"note","","",248,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"span"},{"name":"str"},{"name":"diagnosticbuilder"}],"output":null}],[11,"report","","",248,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"span"},{"name":"str"}],"output":null}],[0,"cstore","rustc::middle","the rustc crate store interface. This also includes types that are mostly used as a part of that interface, but these should probably get a better home if someone can find one.",null,null],[3,"LinkMeta","rustc::middle::cstore","",null,null],[12,"crate_hash","","",253,null],[3,"CrateSource","","Where a crate came from on the local filesystem. One of these three options must be non-None.",null,null],[12,"dylib","","",254,null],[12,"rlib","","",254,null],[12,"rmeta","","",254,null],[3,"NativeLibrary","","",null,null],[12,"kind","","",255,null],[12,"name","","",255,null],[12,"cfg","","",255,null],[12,"foreign_module","","",255,null],[3,"ForeignModule","","",null,null],[12,"foreign_items","","",256,null],[12,"def_id","","",256,null],[3,"ExternCrate","","",null,null],[12,"def_id","","def_id of an `extern crate` in the current crate that caused this crate to be loaded; note that there could be multiple such ids",257,null],[12,"span","","span of the extern crate that caused this to be loaded",257,null],[12,"direct","","If true, then this crate is the crate named by the extern crate referenced above. If false, then this crate is a dep of the crate.",257,null],[12,"path_len","","Number of links to reach the extern crate `def_id` declaration; used to select the extern crate with the shortest path",257,null],[3,"EncodedMetadata","","",null,null],[12,"raw_data","","",258,null],[3,"ExternConstBody","","",null,null],[12,"body","","",259,null],[12,"fingerprint","","",259,null],[3,"ExternBodyNestedBodies","","",null,null],[12,"nested_bodies","","",260,null],[12,"fingerprint","","",260,null],[3,"DummyCrateStore","","A dummy crate store that does not support any non-local crates, for test purposes.",null,null],[4,"DepKind","","",null,null],[13,"UnexportedMacrosOnly","","A dependency that is only used for its macros, none of which are visible from other crates. These are included in the metadata only as placeholders and are ignored when decoding.",261,null],[13,"MacrosOnly","","A dependency that is only used for its macros.",261,null],[13,"Implicit","","A dependency that is always injected into the dependency list and so doesn't need to be linked to an rlib, e.g. the injected allocator.",261,null],[13,"Explicit","","A dependency that is required by an rlib version of this crate. Ordinary `extern crate`s result in `Explicit` dependencies.",261,null],[4,"LibSource","","",null,null],[13,"Some","","",262,null],[13,"MetadataOnly","","",262,null],[13,"None","","",262,null],[4,"LinkagePreference","","",null,null],[13,"RequireDynamic","","",263,null],[13,"RequireStatic","","",263,null],[4,"NativeLibraryKind","","",null,null],[13,"NativeStatic","","native static library (.a archive)",264,null],[13,"NativeStaticNobundle","","native static library, which doesn't get bundled into .rlibs",264,null],[13,"NativeFramework","","macOS-specific",264,null],[13,"NativeUnknown","","default way to specify a dynamic library",264,null],[4,"LoadedMacro","","",null,null],[13,"MacroDef","","",265,null],[13,"ProcMacro","","",265,null],[5,"validate_crate_name","","",null,{"inputs":[{"generics":["session"],"name":"option"},{"name":"str"},{"generics":["span"],"name":"option"}],"output":null}],[5,"used_crates","","",null,{"inputs":[{"name":"tyctxt"},{"name":"linkagepreference"}],"output":{"name":"vec"}}],[8,"MetadataLoader","","The backend's way to give the crate store access to the metadata in a library. Note that it returns the raw metadata bytes stored in the library file, whether it is compressed, uncompressed, some weird mix, etc. rmeta files are backend independent and not handled here.",null,null],[10,"get_rlib_metadata","","",266,{"inputs":[{"name":"self"},{"name":"target"},{"name":"path"}],"output":{"generics":["metadataref","string"],"name":"result"}}],[10,"get_dylib_metadata","","",266,{"inputs":[{"name":"self"},{"name":"target"},{"name":"path"}],"output":{"generics":["metadataref","string"],"name":"result"}}],[8,"CrateStore","","A store of Rust crates, through with their metadata can be accessed.",null,null],[10,"crate_data_as_rc_any","","",267,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["any"],"name":"lrc"}}],[10,"metadata_loader","","",267,{"inputs":[{"name":"self"}],"output":{"name":"metadataloader"}}],[10,"def_key","","",267,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"defkey"}}],[10,"def_path","","",267,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"defpath"}}],[10,"def_path_hash","","",267,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"defpathhash"}}],[10,"def_path_table","","",267,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["defpathtable"],"name":"lrc"}}],[10,"visibility_untracked","","",267,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"visibility"}}],[10,"export_macros_untracked","","",267,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":null}],[10,"dep_kind_untracked","","",267,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"depkind"}}],[10,"crate_name_untracked","","",267,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"symbol"}}],[10,"crate_disambiguator_untracked","","",267,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"cratedisambiguator"}}],[10,"crate_hash_untracked","","",267,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"svh"}}],[10,"struct_field_names_untracked","","",267,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["name"],"name":"vec"}}],[10,"item_children_untracked","","",267,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"session"}],"output":{"generics":["export"],"name":"vec"}}],[10,"load_macro_untracked","","",267,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"session"}],"output":{"name":"loadedmacro"}}],[10,"extern_mod_stmt_cnum_untracked","","",267,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"generics":["cratenum"],"name":"option"}}],[10,"item_generics_cloned_untracked","","",267,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"session"}],"output":{"name":"generics"}}],[10,"associated_item_cloned_untracked","","",267,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"associateditem"}}],[10,"postorder_cnums_untracked","","",267,{"inputs":[{"name":"self"}],"output":{"generics":["cratenum"],"name":"vec"}}],[10,"crates_untracked","","",267,{"inputs":[{"name":"self"}],"output":{"generics":["cratenum"],"name":"vec"}}],[10,"encode_metadata","","",267,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"linkmeta"}],"output":{"name":"encodedmetadata"}}],[10,"metadata_encoding_version","","",267,null],[8,"CrateLoader","","",null,null],[10,"process_item","","",268,{"inputs":[{"name":"self"},{"name":"item"},{"name":"definitions"}],"output":null}],[10,"postprocess","","",268,{"inputs":[{"name":"self"},{"name":"crate"}],"output":null}],[10,"resolve_crate_from_path","","",268,{"inputs":[{"name":"self"},{"name":"symbol"},{"name":"span"}],"output":{"name":"cratenum"}}],[11,"clone","","",253,{"inputs":[{"name":"self"}],"output":{"name":"linkmeta"}}],[11,"fmt","","",253,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",254,{"inputs":[{"name":"self"},{"name":"cratesource"}],"output":{"name":"bool"}}],[11,"ne","","",254,{"inputs":[{"name":"self"},{"name":"cratesource"}],"output":{"name":"bool"}}],[11,"clone","","",254,{"inputs":[{"name":"self"}],"output":{"name":"cratesource"}}],[11,"fmt","","",254,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",261,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",261,{"inputs":[{"name":"__d"}],"output":{"generics":["depkind"],"name":"result"}}],[11,"clone","","",261,{"inputs":[{"name":"self"}],"output":{"name":"depkind"}}],[11,"cmp","","",261,{"inputs":[{"name":"self"},{"name":"depkind"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",261,{"inputs":[{"name":"self"},{"name":"depkind"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"eq","","",261,{"inputs":[{"name":"self"},{"name":"depkind"}],"output":{"name":"bool"}}],[11,"fmt","","",261,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"macros_only","","",261,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"eq","","",262,{"inputs":[{"name":"self"},{"name":"libsource"}],"output":{"name":"bool"}}],[11,"ne","","",262,{"inputs":[{"name":"self"},{"name":"libsource"}],"output":{"name":"bool"}}],[11,"clone","","",262,{"inputs":[{"name":"self"}],"output":{"name":"libsource"}}],[11,"fmt","","",262,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"is_some","","",262,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"option","","",262,{"inputs":[{"name":"self"}],"output":{"generics":["pathbuf"],"name":"option"}}],[11,"fmt","","",263,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",263,{"inputs":[{"name":"self"},{"name":"linkagepreference"}],"output":{"name":"bool"}}],[11,"clone","","",263,{"inputs":[{"name":"self"}],"output":{"name":"linkagepreference"}}],[11,"encode","","",263,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",263,{"inputs":[{"name":"__d"}],"output":{"generics":["linkagepreference"],"name":"result"}}],[11,"clone","","",264,{"inputs":[{"name":"self"}],"output":{"name":"nativelibrarykind"}}],[11,"eq","","",264,{"inputs":[{"name":"self"},{"name":"nativelibrarykind"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",264,{"inputs":[{"name":"self"},{"name":"nativelibrarykind"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"cmp","","",264,{"inputs":[{"name":"self"},{"name":"nativelibrarykind"}],"output":{"name":"ordering"}}],[11,"hash","","",264,null],[11,"encode","","",264,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",264,{"inputs":[{"name":"__d"}],"output":{"generics":["nativelibrarykind"],"name":"result"}}],[11,"clone","","",255,{"inputs":[{"name":"self"}],"output":{"name":"nativelibrary"}}],[11,"hash","","",255,null],[11,"encode","","",255,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",255,{"inputs":[{"name":"__d"}],"output":{"generics":["nativelibrary"],"name":"result"}}],[11,"clone","","",256,{"inputs":[{"name":"self"}],"output":{"name":"foreignmodule"}}],[11,"hash","","",256,null],[11,"encode","","",256,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",256,{"inputs":[{"name":"__d"}],"output":{"generics":["foreignmodule"],"name":"result"}}],[11,"clone","","",257,{"inputs":[{"name":"self"}],"output":{"name":"externcrate"}}],[11,"fmt","","",257,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","",258,{"inputs":[],"output":{"name":"encodedmetadata"}}],[11,"clone","","",259,{"inputs":[{"name":"self"}],"output":{"name":"externconstbody"}}],[11,"clone","","",260,{"inputs":[{"name":"self"}],"output":{"name":"externbodynestedbodies"}}],[11,"crate_data_as_rc_any","","",269,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["any"],"name":"lrc"}}],[11,"visibility_untracked","","",269,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"visibility"}}],[11,"item_generics_cloned_untracked","","",269,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"session"}],"output":{"name":"generics"}}],[11,"associated_item_cloned_untracked","","",269,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"associateditem"}}],[11,"dep_kind_untracked","","",269,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"depkind"}}],[11,"export_macros_untracked","","",269,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":null}],[11,"crate_name_untracked","","",269,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"symbol"}}],[11,"crate_disambiguator_untracked","","",269,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"cratedisambiguator"}}],[11,"crate_hash_untracked","","",269,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"svh"}}],[11,"def_key","","",269,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"defkey"}}],[11,"def_path","","",269,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"defpath"}}],[11,"def_path_hash","","",269,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"defpathhash"}}],[11,"def_path_table","","",269,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["defpathtable"],"name":"lrc"}}],[11,"struct_field_names_untracked","","",269,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["name"],"name":"vec"}}],[11,"item_children_untracked","","",269,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"session"}],"output":{"generics":["export"],"name":"vec"}}],[11,"load_macro_untracked","","",269,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"session"}],"output":{"name":"loadedmacro"}}],[11,"crates_untracked","","",269,{"inputs":[{"name":"self"}],"output":{"generics":["cratenum"],"name":"vec"}}],[11,"extern_mod_stmt_cnum_untracked","","",269,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"generics":["cratenum"],"name":"option"}}],[11,"encode_metadata","","",269,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"linkmeta"}],"output":{"name":"encodedmetadata"}}],[11,"metadata_encoding_version","","",269,null],[11,"postorder_cnums_untracked","","",269,{"inputs":[{"name":"self"}],"output":{"generics":["cratenum"],"name":"vec"}}],[11,"metadata_loader","","",269,{"inputs":[{"name":"self"}],"output":{"name":"metadataloader"}}],[0,"dataflow","rustc::middle","A module for propagating forward dataflow information. The analysis assumes that the items to be propagated can be represented as bits and thus uses bitvectors. Your job is simply to specify the so-called GEN and KILL bits for each expression.",null,null],[3,"DataFlowContext","rustc::middle::dataflow","",null,null],[4,"EntryOrExit","","",null,null],[13,"Entry","","",270,null],[13,"Exit","","",270,null],[4,"KillFrom","","Flag used by `add_kill` to indicate whether the provided kill takes effect only when control flows directly through the node in question, or if the kill's effect is associated with any control-flow directly through or indirectly over the node.",null,null],[13,"ScopeEnd","","A `ScopeEnd` kill is one that takes effect when any control flow goes over the node. A kill associated with the end of the scope of a variable declaration `let x;` is an example of a `ScopeEnd` kill.",271,null],[13,"Execution","","An `Execution` kill is one that takes effect only when control flow goes through the node to completion. A kill associated with an assignment statement `x = expr;` is an example of an `Execution` kill.",271,null],[8,"BitwiseOperator","","",null,null],[10,"join","","Joins two predecessor bits together, typically either `|` or `&`",272,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"usize"}],"output":{"name":"usize"}}],[8,"DataFlowOperator","","Parameterization for the precise form of data flow that is used.",null,null],[10,"initial_value","","Specifies the initial value for each bit in the `on_entry` set",273,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",270,{"inputs":[{"name":"self"}],"output":{"name":"entryorexit"}}],[11,"fmt","","",270,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",274,{"inputs":[{"name":"self"}],"output":{"name":"dataflowcontext"}}],[11,"nested","","",274,{"inputs":[{"name":"self"},{"name":"state"},{"name":"nested"}],"output":{"name":"result"}}],[11,"pre","","",274,{"inputs":[{"name":"self"},{"name":"state"},{"name":"annnode"}],"output":{"name":"result"}}],[11,"clone","","",271,{"inputs":[{"name":"self"}],"output":{"name":"killfrom"}}],[11,"eq","","",271,{"inputs":[{"name":"self"},{"name":"killfrom"}],"output":{"name":"bool"}}],[11,"fmt","","",271,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","",274,{"inputs":[{"name":"tyctxt"},{"name":"str"},{"generics":["body"],"name":"option"},{"name":"cfg"},{"name":"o"},{"name":"idrange"},{"name":"usize"}],"output":{"name":"dataflowcontext"}}],[11,"add_gen","","Indicates that `id` generates `bit`",274,{"inputs":[{"name":"self"},{"name":"itemlocalid"},{"name":"usize"}],"output":null}],[11,"add_kill","","Indicates that `id` kills `bit`",274,{"inputs":[{"name":"self"},{"name":"killfrom"},{"name":"itemlocalid"},{"name":"usize"}],"output":null}],[11,"each_bit_on_entry","","Iterates through each bit that is set on entry to `id`. Only useful after `propagate()` has been called.",274,{"inputs":[{"name":"self"},{"name":"itemlocalid"},{"name":"f"}],"output":{"name":"bool"}}],[11,"each_bit_for_node","","Iterates through each bit that is set on entry/exit to `cfgidx`. Only useful after `propagate()` has been called.",274,{"inputs":[{"name":"self"},{"name":"entryorexit"},{"name":"cfgindex"},{"name":"f"}],"output":{"name":"bool"}}],[11,"each_gen_bit","","Iterates through each bit in the gen set for `id`.",274,{"inputs":[{"name":"self"},{"name":"itemlocalid"},{"name":"f"}],"output":{"name":"bool"}}],[11,"add_kills_from_flow_exits","","Whenever you have a `break` or `continue` statement, flow exits through any number of enclosing scopes on its way to the new destination. This function infers the kill bits of those control operators based on the kill bits associated with those scopes.",274,{"inputs":[{"name":"self"},{"name":"cfg"}],"output":null}],[11,"propagate","","Performs the data flow analysis.",274,{"inputs":[{"name":"self"},{"name":"cfg"},{"name":"body"}],"output":null}],[0,"dead","rustc::middle","",null,null],[5,"check_crate","rustc::middle::dead","",null,{"inputs":[{"name":"tyctxt"}],"output":null}],[0,"dependency_format","rustc::middle","Resolution of mixing rlibs and dylibs",null,null],[4,"Linkage","rustc::middle::dependency_format","",null,null],[13,"NotLinked","","",275,null],[13,"IncludedFromDylib","","",275,null],[13,"Static","","",275,null],[13,"Dynamic","","",275,null],[5,"calculate","","",null,{"inputs":[{"name":"tyctxt"}],"output":null}],[6,"DependencyList","","A list of dependencies for a certain crate type.",null,null],[6,"Dependencies","","A mapping of all required dependencies for a particular flavor of output.",null,null],[11,"clone","","",275,{"inputs":[{"name":"self"}],"output":{"name":"linkage"}}],[11,"eq","","",275,{"inputs":[{"name":"self"},{"name":"linkage"}],"output":{"name":"bool"}}],[11,"fmt","","",275,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[0,"entry","rustc::middle","",null,null],[5,"find_entry_point","rustc::middle::entry","",null,{"inputs":[{"name":"session"},{"name":"map"},{"name":"str"}],"output":null}],[0,"exported_symbols","rustc::middle","",null,null],[4,"SymbolExportLevel","rustc::middle::exported_symbols","The SymbolExportLevel of a symbols specifies from which kinds of crates the symbol will be exported. `C` symbols will be exported from any kind of crate, including cdylibs which export very few things. `Rust` will only be exported if the crate produced is a Rust dylib.",null,null],[13,"C","","",276,null],[13,"Rust","","",276,null],[4,"ExportedSymbol","","",null,null],[13,"NonGeneric","","",277,null],[13,"NoDefId","","",277,null],[5,"metadata_symbol_name","","",null,{"inputs":[{"name":"tyctxt"}],"output":{"name":"string"}}],[11,"eq","","",276,{"inputs":[{"name":"self"},{"name":"symbolexportlevel"}],"output":{"name":"bool"}}],[11,"fmt","","",276,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",276,{"inputs":[{"name":"self"}],"output":{"name":"symbolexportlevel"}}],[11,"encode","","",276,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",276,{"inputs":[{"name":"__d"}],"output":{"generics":["symbolexportlevel"],"name":"result"}}],[11,"hash_stable","","",276,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"is_below_threshold","","",276,{"inputs":[{"name":"self"},{"name":"symbolexportlevel"}],"output":{"name":"bool"}}],[11,"eq","","",277,{"inputs":[{"name":"self"},{"name":"exportedsymbol"}],"output":{"name":"bool"}}],[11,"ne","","",277,{"inputs":[{"name":"self"},{"name":"exportedsymbol"}],"output":{"name":"bool"}}],[11,"fmt","","",277,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",277,{"inputs":[{"name":"self"}],"output":{"name":"exportedsymbol"}}],[11,"encode","","",277,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",277,{"inputs":[{"name":"__d"}],"output":{"generics":["exportedsymbol"],"name":"result"}}],[11,"symbol_name","","",277,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"symbolname"}}],[11,"compare_stable","","",277,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"exportedsymbol"}],"output":{"name":"ordering"}}],[11,"hash_stable","","",277,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[0,"free_region","rustc::middle","This file handles the relationships between free regions -- meaning lifetime parameters. Ordinarily, free regions are unrelated to one another, but they can be related via implied or explicit bounds.  In that case, we track the bounds using the `TransitiveRelation` type and use that to decide when one free region outlives another and so forth.",null,null],[3,"RegionRelations","rustc::middle::free_region","Combines a `region::ScopeTree` (which governs relationships between scopes) and a `FreeRegionMap` (which governs relationships between free regions) to yield a complete relation between concrete regions.",null,null],[12,"tcx","","",278,null],[12,"context","","context used to fetch the region maps",278,null],[12,"region_scope_tree","","region maps for the given context",278,null],[12,"free_regions","","free-region relationships",278,null],[11,"new","","",278,{"inputs":[{"name":"tyctxt"},{"name":"defid"},{"name":"scopetree"},{"name":"freeregionmap"}],"output":{"name":"self"}}],[11,"is_subregion_of","","Determines whether one region is a subregion of another.  This is intended to run after inference and sadly the logic is somewhat duplicated with the code in infer.rs.",278,{"inputs":[{"name":"self"},{"name":"region"},{"name":"region"}],"output":{"name":"bool"}}],[11,"lub_free_regions","","",278,{"inputs":[{"name":"self"},{"name":"region"},{"name":"region"}],"output":{"name":"region"}}],[0,"intrinsicck","rustc::middle","",null,null],[5,"check_crate","rustc::middle::intrinsicck","",null,{"inputs":[{"name":"tyctxt"}],"output":null}],[0,"lang_items","rustc::middle","",null,null],[3,"LanguageItems","rustc::middle::lang_items","",null,null],[12,"items","","",279,null],[12,"missing","","",279,null],[4,"LangItem","","",null,null],[13,"CharImplItem","","",280,null],[13,"StrImplItem","","",280,null],[13,"SliceImplItem","","",280,null],[13,"SliceU8ImplItem","","",280,null],[13,"ConstPtrImplItem","","",280,null],[13,"MutPtrImplItem","","",280,null],[13,"I8ImplItem","","",280,null],[13,"I16ImplItem","","",280,null],[13,"I32ImplItem","","",280,null],[13,"I64ImplItem","","",280,null],[13,"I128ImplItem","","",280,null],[13,"IsizeImplItem","","",280,null],[13,"U8ImplItem","","",280,null],[13,"U16ImplItem","","",280,null],[13,"U32ImplItem","","",280,null],[13,"U64ImplItem","","",280,null],[13,"U128ImplItem","","",280,null],[13,"UsizeImplItem","","",280,null],[13,"F32ImplItem","","",280,null],[13,"F64ImplItem","","",280,null],[13,"SizedTraitLangItem","","",280,null],[13,"UnsizeTraitLangItem","","",280,null],[13,"CopyTraitLangItem","","",280,null],[13,"CloneTraitLangItem","","",280,null],[13,"SyncTraitLangItem","","",280,null],[13,"FreezeTraitLangItem","","",280,null],[13,"DropTraitLangItem","","",280,null],[13,"CoerceUnsizedTraitLangItem","","",280,null],[13,"AddTraitLangItem","","",280,null],[13,"SubTraitLangItem","","",280,null],[13,"MulTraitLangItem","","",280,null],[13,"DivTraitLangItem","","",280,null],[13,"RemTraitLangItem","","",280,null],[13,"NegTraitLangItem","","",280,null],[13,"NotTraitLangItem","","",280,null],[13,"BitXorTraitLangItem","","",280,null],[13,"BitAndTraitLangItem","","",280,null],[13,"BitOrTraitLangItem","","",280,null],[13,"ShlTraitLangItem","","",280,null],[13,"ShrTraitLangItem","","",280,null],[13,"AddAssignTraitLangItem","","",280,null],[13,"SubAssignTraitLangItem","","",280,null],[13,"MulAssignTraitLangItem","","",280,null],[13,"DivAssignTraitLangItem","","",280,null],[13,"RemAssignTraitLangItem","","",280,null],[13,"BitXorAssignTraitLangItem","","",280,null],[13,"BitAndAssignTraitLangItem","","",280,null],[13,"BitOrAssignTraitLangItem","","",280,null],[13,"ShlAssignTraitLangItem","","",280,null],[13,"ShrAssignTraitLangItem","","",280,null],[13,"IndexTraitLangItem","","",280,null],[13,"IndexMutTraitLangItem","","",280,null],[13,"UnsafeCellTypeLangItem","","",280,null],[13,"DerefTraitLangItem","","",280,null],[13,"DerefMutTraitLangItem","","",280,null],[13,"FnTraitLangItem","","",280,null],[13,"FnMutTraitLangItem","","",280,null],[13,"FnOnceTraitLangItem","","",280,null],[13,"GeneratorStateLangItem","","",280,null],[13,"GeneratorTraitLangItem","","",280,null],[13,"EqTraitLangItem","","",280,null],[13,"PartialOrdTraitLangItem","","",280,null],[13,"OrdTraitLangItem","","",280,null],[13,"PanicFnLangItem","","",280,null],[13,"PanicBoundsCheckFnLangItem","","",280,null],[13,"PanicFmtLangItem","","",280,null],[13,"ExchangeMallocFnLangItem","","",280,null],[13,"BoxFreeFnLangItem","","",280,null],[13,"DropInPlaceFnLangItem","","",280,null],[13,"StartFnLangItem","","",280,null],[13,"EhPersonalityLangItem","","",280,null],[13,"EhUnwindResumeLangItem","","",280,null],[13,"MSVCTryFilterLangItem","","",280,null],[13,"OwnedBoxLangItem","","",280,null],[13,"PhantomDataItem","","",280,null],[13,"NonZeroItem","","",280,null],[13,"DebugTraitLangItem","","",280,null],[13,"I128AddFnLangItem","","",280,null],[13,"U128AddFnLangItem","","",280,null],[13,"I128SubFnLangItem","","",280,null],[13,"U128SubFnLangItem","","",280,null],[13,"I128MulFnLangItem","","",280,null],[13,"U128MulFnLangItem","","",280,null],[13,"I128DivFnLangItem","","",280,null],[13,"U128DivFnLangItem","","",280,null],[13,"I128RemFnLangItem","","",280,null],[13,"U128RemFnLangItem","","",280,null],[13,"I128ShlFnLangItem","","",280,null],[13,"U128ShlFnLangItem","","",280,null],[13,"I128ShrFnLangItem","","",280,null],[13,"U128ShrFnLangItem","","",280,null],[13,"I128AddoFnLangItem","","",280,null],[13,"U128AddoFnLangItem","","",280,null],[13,"I128SuboFnLangItem","","",280,null],[13,"U128SuboFnLangItem","","",280,null],[13,"I128MuloFnLangItem","","",280,null],[13,"U128MuloFnLangItem","","",280,null],[13,"I128ShloFnLangItem","","",280,null],[13,"U128ShloFnLangItem","","",280,null],[13,"I128ShroFnLangItem","","",280,null],[13,"U128ShroFnLangItem","","",280,null],[13,"TerminationTraitLangItem","","",280,null],[5,"extract","","",null,null],[5,"collect","","",null,{"inputs":[{"name":"tyctxt"}],"output":{"name":"languageitems"}}],[11,"fmt","","",280,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",280,{"inputs":[{"name":"self"}],"output":{"name":"langitem"}}],[11,"eq","","",280,{"inputs":[{"name":"self"},{"name":"langitem"}],"output":{"name":"bool"}}],[11,"hash","","",280,null],[11,"encode","","",280,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",280,{"inputs":[{"name":"__d"}],"output":{"generics":["langitem"],"name":"result"}}],[11,"from_u32","","",280,{"inputs":[{"name":"u32"}],"output":{"generics":["langitem"],"name":"option"}}],[11,"new","","",279,{"inputs":[],"output":{"name":"languageitems"}}],[11,"items","","",279,null],[11,"require","","",279,{"inputs":[{"name":"self"},{"name":"langitem"}],"output":{"generics":["defid","string"],"name":"result"}}],[11,"fn_trait_kind","","",279,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["closurekind"],"name":"option"}}],[11,"char_impl","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"str_impl","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"slice_impl","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"slice_u8_impl","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"const_ptr_impl","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"mut_ptr_impl","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"i8_impl","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"i16_impl","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"i32_impl","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"i64_impl","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"i128_impl","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"isize_impl","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"u8_impl","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"u16_impl","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"u32_impl","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"u64_impl","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"u128_impl","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"usize_impl","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"f32_impl","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"f64_impl","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"sized_trait","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"unsize_trait","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"copy_trait","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"clone_trait","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"sync_trait","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"freeze_trait","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"drop_trait","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"coerce_unsized_trait","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"add_trait","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"sub_trait","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"mul_trait","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"div_trait","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"rem_trait","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"neg_trait","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"not_trait","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"bitxor_trait","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"bitand_trait","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"bitor_trait","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"shl_trait","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"shr_trait","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"add_assign_trait","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"sub_assign_trait","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"mul_assign_trait","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"div_assign_trait","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"rem_assign_trait","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"bitxor_assign_trait","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"bitand_assign_trait","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"bitor_assign_trait","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"shl_assign_trait","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"shr_assign_trait","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"index_trait","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"index_mut_trait","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"unsafe_cell_type","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"deref_trait","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"deref_mut_trait","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"fn_trait","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"fn_mut_trait","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"fn_once_trait","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"gen_state","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"gen_trait","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"eq_trait","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"partial_ord_trait","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"ord_trait","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"panic_fn","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"panic_bounds_check_fn","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"panic_fmt","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"exchange_malloc_fn","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"box_free_fn","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"drop_in_place_fn","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"start_fn","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"eh_personality","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"eh_unwind_resume","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"msvc_try_filter","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"owned_box","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"phantom_data","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"non_zero","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"debug_trait","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"i128_add_fn","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"u128_add_fn","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"i128_sub_fn","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"u128_sub_fn","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"i128_mul_fn","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"u128_mul_fn","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"i128_div_fn","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"u128_div_fn","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"i128_rem_fn","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"u128_rem_fn","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"i128_shl_fn","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"u128_shl_fn","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"i128_shr_fn","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"u128_shr_fn","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"i128_addo_fn","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"u128_addo_fn","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"i128_subo_fn","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"u128_subo_fn","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"i128_mulo_fn","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"u128_mulo_fn","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"i128_shlo_fn","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"u128_shlo_fn","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"i128_shro_fn","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"u128_shro_fn","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"termination","","",279,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[0,"liveness","rustc::middle","A classic liveness analysis based on dataflow over the AST.  Computes, for each local variable in a function, whether that variable is live at a given point.  Program execution points are identified by their id.",null,null],[5,"check_crate","rustc::middle::liveness","",null,{"inputs":[{"name":"tyctxt"}],"output":null}],[0,"mem_categorization","rustc::middle","Categorization",null,null],[3,"Upvar","rustc::middle::mem_categorization","",null,null],[12,"id","","",281,null],[12,"kind","","",281,null],[3,"cmt_","","",null,null],[12,"id","","",282,null],[12,"span","","",282,null],[12,"cat","","",282,null],[12,"mutbl","","",282,null],[12,"ty","","",282,null],[12,"note","","",282,null],[3,"MemCategorizationContext","","",null,null],[12,"tcx","","",283,null],[12,"region_scope_tree","","",283,null],[12,"tables","","",283,null],[4,"Categorization","","",null,null],[13,"Rvalue","","",284,null],[13,"StaticItem","","",284,null],[13,"Upvar","","",284,null],[13,"Local","","",284,null],[13,"Deref","","",284,null],[13,"Interior","","",284,null],[13,"Downcast","","",284,null],[4,"PointerKind","","",null,null],[13,"Unique","","`Box<T>`",285,null],[13,"BorrowedPtr","","`&T`",285,null],[13,"UnsafePtr","","`*T`",285,null],[13,"Implicit","","Implicit deref of the `&T` that results from an overloaded index `[]`.",285,null],[4,"InteriorKind","","",null,null],[13,"InteriorField","","",286,null],[13,"InteriorElement","","",286,null],[4,"FieldName","","",null,null],[13,"NamedField","","",287,null],[13,"PositionalField","","",287,null],[4,"InteriorOffsetKind","","",null,null],[13,"Index","","",288,null],[13,"Pattern","","",288,null],[4,"MutabilityCategory","","",null,null],[13,"McImmutable","","",289,null],[13,"McDeclared","","",289,null],[13,"McInherited","","",289,null],[4,"Note","","",null,null],[13,"NoteClosureEnv","","",290,null],[13,"NoteUpvarRef","","",290,null],[13,"NoteNone","","",290,null],[4,"ImmutabilityBlame","","",null,null],[13,"ImmLocal","","",291,null],[13,"ClosureEnv","","",291,null],[13,"LocalDeref","","",291,null],[13,"AdtFieldDeref","","",291,null],[4,"Aliasability","","",null,null],[13,"FreelyAliasable","","",292,null],[13,"NonAliasable","","",292,null],[13,"ImmutableUnique","","",292,null],[4,"AliasableReason","","",null,null],[13,"AliasableBorrowed","","",293,null],[13,"AliasableStatic","","",293,null],[13,"AliasableStaticMut","","",293,null],[5,"ptr_sigil","","",null,{"inputs":[{"name":"pointerkind"}],"output":{"name":"str"}}],[6,"cmt","","",null,null],[6,"McResult","","",null,null],[8,"ast_node","","",null,null],[10,"id","","",294,{"inputs":[{"name":"self"}],"output":{"name":"nodeid"}}],[10,"span","","",294,{"inputs":[{"name":"self"}],"output":{"name":"span"}}],[11,"clone","","",284,{"inputs":[{"name":"self"}],"output":{"name":"categorization"}}],[11,"fmt","","",284,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",284,{"inputs":[{"name":"self"},{"name":"categorization"}],"output":{"name":"bool"}}],[11,"ne","","",284,{"inputs":[{"name":"self"},{"name":"categorization"}],"output":{"name":"bool"}}],[11,"clone","","",281,{"inputs":[{"name":"self"}],"output":{"name":"upvar"}}],[11,"eq","","",281,{"inputs":[{"name":"self"},{"name":"upvar"}],"output":{"name":"bool"}}],[11,"ne","","",281,{"inputs":[{"name":"self"},{"name":"upvar"}],"output":{"name":"bool"}}],[11,"clone","","",285,{"inputs":[{"name":"self"}],"output":{"name":"pointerkind"}}],[11,"fmt","","",285,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",285,{"inputs":[{"name":"self"},{"name":"pointerkind"}],"output":{"name":"bool"}}],[11,"ne","","",285,{"inputs":[{"name":"self"},{"name":"pointerkind"}],"output":{"name":"bool"}}],[11,"hash","","",285,null],[11,"clone","","",286,{"inputs":[{"name":"self"}],"output":{"name":"interiorkind"}}],[11,"eq","","",286,{"inputs":[{"name":"self"},{"name":"interiorkind"}],"output":{"name":"bool"}}],[11,"ne","","",286,{"inputs":[{"name":"self"},{"name":"interiorkind"}],"output":{"name":"bool"}}],[11,"hash","","",286,null],[11,"clone","","",287,{"inputs":[{"name":"self"}],"output":{"name":"fieldname"}}],[11,"eq","","",287,{"inputs":[{"name":"self"},{"name":"fieldname"}],"output":{"name":"bool"}}],[11,"ne","","",287,{"inputs":[{"name":"self"},{"name":"fieldname"}],"output":{"name":"bool"}}],[11,"hash","","",287,null],[11,"fmt","","",287,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",288,{"inputs":[{"name":"self"}],"output":{"name":"interioroffsetkind"}}],[11,"eq","","",288,{"inputs":[{"name":"self"},{"name":"interioroffsetkind"}],"output":{"name":"bool"}}],[11,"hash","","",288,null],[11,"fmt","","",288,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",289,{"inputs":[{"name":"self"}],"output":{"name":"mutabilitycategory"}}],[11,"eq","","",289,{"inputs":[{"name":"self"},{"name":"mutabilitycategory"}],"output":{"name":"bool"}}],[11,"hash","","",289,null],[11,"fmt","","",289,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",290,{"inputs":[{"name":"self"}],"output":{"name":"note"}}],[11,"eq","","",290,{"inputs":[{"name":"self"},{"name":"note"}],"output":{"name":"bool"}}],[11,"ne","","",290,{"inputs":[{"name":"self"},{"name":"note"}],"output":{"name":"bool"}}],[11,"fmt","","",290,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",282,{"inputs":[{"name":"self"}],"output":{"name":"cmt_"}}],[11,"fmt","","",282,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",282,{"inputs":[{"name":"self"},{"name":"cmt_"}],"output":{"name":"bool"}}],[11,"ne","","",282,{"inputs":[{"name":"self"},{"name":"cmt_"}],"output":{"name":"bool"}}],[11,"immutability_blame","","",282,{"inputs":[{"name":"self"}],"output":{"generics":["immutabilityblame"],"name":"option"}}],[11,"id","rustc::hir","",46,{"inputs":[{"name":"self"}],"output":{"name":"nodeid"}}],[11,"span","","",46,{"inputs":[{"name":"self"}],"output":{"name":"span"}}],[11,"id","","",39,{"inputs":[{"name":"self"}],"output":{"name":"nodeid"}}],[11,"span","","",39,{"inputs":[{"name":"self"}],"output":{"name":"span"}}],[11,"clone","rustc::middle::mem_categorization","",283,{"inputs":[{"name":"self"}],"output":{"name":"memcategorizationcontext"}}],[11,"from_mutbl","","",289,{"inputs":[{"name":"mutability"}],"output":{"name":"mutabilitycategory"}}],[11,"from_borrow_kind","","",289,{"inputs":[{"name":"borrowkind"}],"output":{"name":"mutabilitycategory"}}],[11,"inherit","","",289,{"inputs":[{"name":"self"}],"output":{"name":"mutabilitycategory"}}],[11,"is_mutable","","",289,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_immutable","","",289,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"to_user_str","","",289,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"new","","",283,{"inputs":[{"name":"tyctxt"},{"name":"scopetree"},{"name":"typecktables"},{"generics":["lrc"],"name":"option"}],"output":{"name":"memcategorizationcontext"}}],[11,"with_infer","","Creates a `MemCategorizationContext` during type inference. This is used during upvar analysis and a few other places. Because the typeck tables are not yet complete, the results from the analysis must be used with caution:",283,{"inputs":[{"name":"inferctxt"},{"name":"scopetree"},{"name":"typecktables"}],"output":{"name":"memcategorizationcontext"}}],[11,"type_moves_by_default","","",283,{"inputs":[{"name":"self"},{"name":"paramenv"},{"name":"ty"},{"name":"span"}],"output":{"name":"bool"}}],[11,"node_ty","","",283,{"inputs":[{"name":"self"},{"name":"hirid"}],"output":{"generics":["ty"],"name":"mcresult"}}],[11,"expr_ty","","",283,{"inputs":[{"name":"self"},{"name":"expr"}],"output":{"generics":["ty"],"name":"mcresult"}}],[11,"expr_ty_adjusted","","",283,{"inputs":[{"name":"self"},{"name":"expr"}],"output":{"generics":["ty"],"name":"mcresult"}}],[11,"cat_expr","","",283,{"inputs":[{"name":"self"},{"name":"expr"}],"output":{"generics":["cmt"],"name":"mcresult"}}],[11,"cat_expr_adjusted","","",283,{"inputs":[{"name":"self"},{"name":"expr"},{"name":"cmt"},{"name":"adjustment"}],"output":{"generics":["cmt"],"name":"mcresult"}}],[11,"cat_expr_unadjusted","","",283,{"inputs":[{"name":"self"},{"name":"expr"}],"output":{"generics":["cmt"],"name":"mcresult"}}],[11,"cat_def","","",283,{"inputs":[{"name":"self"},{"name":"nodeid"},{"name":"span"},{"name":"ty"},{"name":"def"}],"output":{"generics":["cmt"],"name":"mcresult"}}],[11,"temporary_scope","","Returns the lifetime of a temporary created by expr with id `id`. This could be `'static` if `id` is part of a constant expression.",283,{"inputs":[{"name":"self"},{"name":"itemlocalid"}],"output":{"name":"region"}}],[11,"cat_rvalue_node","","",283,{"inputs":[{"name":"self"},{"name":"nodeid"},{"name":"span"},{"name":"ty"}],"output":{"name":"cmt"}}],[11,"cat_rvalue","","",283,{"inputs":[{"name":"self"},{"name":"nodeid"},{"name":"span"},{"name":"region"},{"name":"ty"}],"output":{"name":"cmt"}}],[11,"cat_field","","",283,{"inputs":[{"name":"self"},{"name":"n"},{"name":"cmt"},{"name":"name"},{"name":"ty"}],"output":{"name":"cmt"}}],[11,"cat_tup_field","","",283,{"inputs":[{"name":"self"},{"name":"n"},{"name":"cmt"},{"name":"usize"},{"name":"ty"}],"output":{"name":"cmt"}}],[11,"cat_deref","","",283,{"inputs":[{"name":"self"},{"name":"n"},{"name":"cmt"},{"name":"bool"}],"output":{"generics":["cmt"],"name":"mcresult"}}],[11,"cat_imm_interior","","",283,{"inputs":[{"name":"self"},{"name":"n"},{"name":"cmt"},{"name":"ty"},{"name":"interiorkind"}],"output":{"name":"cmt"}}],[11,"cat_downcast_if_needed","","",283,{"inputs":[{"name":"self"},{"name":"n"},{"name":"cmt"},{"name":"defid"}],"output":{"name":"cmt"}}],[11,"cat_pattern","","",283,{"inputs":[{"name":"self"},{"name":"cmt"},{"name":"pat"},{"name":"f"}],"output":{"name":"mcresult"}}],[11,"clone","","",292,{"inputs":[{"name":"self"}],"output":{"name":"aliasability"}}],[11,"fmt","","",292,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",293,{"inputs":[{"name":"self"}],"output":{"name":"aliasablereason"}}],[11,"fmt","","",293,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"guarantor","","Returns `self` after stripping away any derefs or interior content. The return value is basically the `cmt` which determines how long the value in `self` remains live.",282,{"inputs":[{"name":"self"}],"output":{"name":"cmt"}}],[11,"freely_aliasable","","Returns `FreelyAliasable(_)` if this place represents a freely aliasable pointer type.",282,{"inputs":[{"name":"self"}],"output":{"name":"aliasability"}}],[11,"upvar","","",282,{"inputs":[{"name":"self"}],"output":{"generics":["cmt"],"name":"option"}}],[11,"descriptive_string","","",282,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"string"}}],[11,"fmt","","",286,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",281,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",281,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[0,"privacy","rustc::middle","A pass that checks to make sure private fields and methods aren't used outside their scopes. This pass will also generate a set of exported items which are available for use externally when compiled as a library.",null,null],[3,"AccessLevels","rustc::middle::privacy","",null,null],[12,"map","","",295,null],[4,"AccessLevel","","",null,null],[13,"Reachable","","",296,null],[13,"Exported","","",296,null],[13,"Public","","",296,null],[6,"ExternalExports","","A set containing all exported definitions from external crates. The set does not contain any entries from local crates.",null,null],[11,"clone","","",296,{"inputs":[{"name":"self"}],"output":{"name":"accesslevel"}}],[11,"fmt","","",296,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",296,{"inputs":[{"name":"self"},{"name":"accesslevel"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",296,{"inputs":[{"name":"self"},{"name":"accesslevel"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"cmp","","",296,{"inputs":[{"name":"self"},{"name":"accesslevel"}],"output":{"name":"ordering"}}],[11,"clone","","",295,{"inputs":[{"name":"self"}],"output":{"name":"accesslevels"}}],[11,"is_reachable","","",295,{"inputs":[{"name":"self"},{"name":"id"}],"output":{"name":"bool"}}],[11,"is_exported","","",295,{"inputs":[{"name":"self"},{"name":"id"}],"output":{"name":"bool"}}],[11,"is_public","","",295,{"inputs":[{"name":"self"},{"name":"id"}],"output":{"name":"bool"}}],[11,"default","","",295,{"inputs":[],"output":{"name":"self"}}],[11,"fmt","","",295,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[0,"reachable","rustc::middle","",null,null],[3,"ReachableSet","rustc::middle::reachable","",null,null],[12,"0","","",297,null],[5,"provide","","",null,{"inputs":[{"name":"providers"}],"output":null}],[11,"clone","","",297,{"inputs":[{"name":"self"}],"output":{"name":"reachableset"}}],[0,"region","rustc::middle","This file builds up the `ScopeTree`, which describes the parent links in the region hierarchy.",null,null],[3,"Scope","rustc::middle::region","Scope represents a statically-describable scope that can be used to bound the lifetime/region for values.",null,null],[3,"BlockRemainder","","Represents a subscope of `block` for a binding that is introduced by `block.stmts[first_statement_index]`. Such subscopes represent a suffix of the block. Note that each subscope does not include the initializer expression, if any, for the statement indexed by `first_statement_index`.",null,null],[12,"block","","",298,null],[12,"first_statement_index","","",298,null],[3,"FirstStatementIndex","","",null,null],[12,"0","","",299,null],[3,"ScopeTree","","The region scope tree encodes information about region relationships.",null,null],[3,"Context","","",null,null],[4,"ScopeData","","",null,null],[13,"Node","","",300,null],[13,"CallSite","","",300,null],[13,"Arguments","","",300,null],[13,"Destruction","","",300,null],[13,"Remainder","","",300,null],[5,"provide","","",null,{"inputs":[{"name":"providers"}],"output":null}],[11,"clone","","",301,{"inputs":[{"name":"self"}],"output":{"name":"scope"}}],[11,"eq","","",301,{"inputs":[{"name":"self"},{"name":"scope"}],"output":{"name":"bool"}}],[11,"ne","","",301,{"inputs":[{"name":"self"},{"name":"scope"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",301,{"inputs":[{"name":"self"},{"name":"scope"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",301,{"inputs":[{"name":"self"},{"name":"scope"}],"output":{"name":"bool"}}],[11,"le","","",301,{"inputs":[{"name":"self"},{"name":"scope"}],"output":{"name":"bool"}}],[11,"gt","","",301,{"inputs":[{"name":"self"},{"name":"scope"}],"output":{"name":"bool"}}],[11,"ge","","",301,{"inputs":[{"name":"self"},{"name":"scope"}],"output":{"name":"bool"}}],[11,"cmp","","",301,{"inputs":[{"name":"self"},{"name":"scope"}],"output":{"name":"ordering"}}],[11,"hash","","",301,null],[11,"encode","","",301,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",301,{"inputs":[{"name":"__d"}],"output":{"generics":["scope"],"name":"result"}}],[11,"clone","","",300,{"inputs":[{"name":"self"}],"output":{"name":"scopedata"}}],[11,"eq","","",300,{"inputs":[{"name":"self"},{"name":"scopedata"}],"output":{"name":"bool"}}],[11,"ne","","",300,{"inputs":[{"name":"self"},{"name":"scopedata"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",300,{"inputs":[{"name":"self"},{"name":"scopedata"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",300,{"inputs":[{"name":"self"},{"name":"scopedata"}],"output":{"name":"bool"}}],[11,"le","","",300,{"inputs":[{"name":"self"},{"name":"scopedata"}],"output":{"name":"bool"}}],[11,"gt","","",300,{"inputs":[{"name":"self"},{"name":"scopedata"}],"output":{"name":"bool"}}],[11,"ge","","",300,{"inputs":[{"name":"self"},{"name":"scopedata"}],"output":{"name":"bool"}}],[11,"cmp","","",300,{"inputs":[{"name":"self"},{"name":"scopedata"}],"output":{"name":"ordering"}}],[11,"hash","","",300,null],[11,"fmt","","",300,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",300,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",300,{"inputs":[{"name":"__d"}],"output":{"generics":["scopedata"],"name":"result"}}],[11,"clone","","",298,{"inputs":[{"name":"self"}],"output":{"name":"blockremainder"}}],[11,"eq","","",298,{"inputs":[{"name":"self"},{"name":"blockremainder"}],"output":{"name":"bool"}}],[11,"ne","","",298,{"inputs":[{"name":"self"},{"name":"blockremainder"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",298,{"inputs":[{"name":"self"},{"name":"blockremainder"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",298,{"inputs":[{"name":"self"},{"name":"blockremainder"}],"output":{"name":"bool"}}],[11,"le","","",298,{"inputs":[{"name":"self"},{"name":"blockremainder"}],"output":{"name":"bool"}}],[11,"gt","","",298,{"inputs":[{"name":"self"},{"name":"blockremainder"}],"output":{"name":"bool"}}],[11,"ge","","",298,{"inputs":[{"name":"self"},{"name":"blockremainder"}],"output":{"name":"bool"}}],[11,"cmp","","",298,{"inputs":[{"name":"self"},{"name":"blockremainder"}],"output":{"name":"ordering"}}],[11,"hash","","",298,null],[11,"encode","","",298,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",298,{"inputs":[{"name":"__d"}],"output":{"generics":["blockremainder"],"name":"result"}}],[11,"fmt","","",298,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",299,{"inputs":[{"name":"self"}],"output":{"name":"firststatementindex"}}],[11,"eq","","",299,{"inputs":[{"name":"self"},{"name":"firststatementindex"}],"output":{"name":"bool"}}],[11,"ne","","",299,{"inputs":[{"name":"self"},{"name":"firststatementindex"}],"output":{"name":"bool"}}],[11,"hash","","",299,null],[11,"partial_cmp","","",299,{"inputs":[{"name":"self"},{"name":"firststatementindex"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",299,{"inputs":[{"name":"self"},{"name":"firststatementindex"}],"output":{"name":"bool"}}],[11,"le","","",299,{"inputs":[{"name":"self"},{"name":"firststatementindex"}],"output":{"name":"bool"}}],[11,"gt","","",299,{"inputs":[{"name":"self"},{"name":"firststatementindex"}],"output":{"name":"bool"}}],[11,"ge","","",299,{"inputs":[{"name":"self"},{"name":"firststatementindex"}],"output":{"name":"bool"}}],[11,"cmp","","",299,{"inputs":[{"name":"self"},{"name":"firststatementindex"}],"output":{"name":"ordering"}}],[11,"decode","","",299,{"inputs":[{"name":"__d"}],"output":{"generics":["firststatementindex"],"name":"result"}}],[11,"encode","","",299,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"new","","",299,{"inputs":[{"name":"usize"}],"output":{"name":"self"}}],[11,"index","","",299,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"fmt","","",299,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"from","","",301,{"inputs":[{"name":"scopedata"}],"output":{"name":"self"}}],[11,"fmt","","",301,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"data","","",301,{"inputs":[{"name":"self"}],"output":{"name":"scopedata"}}],[11,"Node","","",301,{"inputs":[{"name":"itemlocalid"}],"output":{"name":"self"}}],[11,"CallSite","","",301,{"inputs":[{"name":"itemlocalid"}],"output":{"name":"self"}}],[11,"Arguments","","",301,{"inputs":[{"name":"itemlocalid"}],"output":{"name":"self"}}],[11,"Destruction","","",301,{"inputs":[{"name":"itemlocalid"}],"output":{"name":"self"}}],[11,"Remainder","","",301,{"inputs":[{"name":"blockremainder"}],"output":{"name":"self"}}],[11,"item_local_id","","Returns a item-local id associated with this scope.",301,{"inputs":[{"name":"self"}],"output":{"name":"itemlocalid"}}],[11,"node_id","","",301,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"scopetree"}],"output":{"name":"nodeid"}}],[11,"span","","Returns the span of this Scope.  Note that in general the returned span may not correspond to the span of any node id in the AST.",301,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"scopetree"}],"output":{"name":"span"}}],[11,"default","","",302,{"inputs":[],"output":{"name":"scopetree"}}],[11,"fmt","","",302,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",303,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",303,{"inputs":[{"name":"self"}],"output":{"name":"context"}}],[11,"record_scope_parent","","",302,{"inputs":[{"name":"self"},{"name":"scope"},{"generics":["scope"],"name":"option"}],"output":null}],[11,"each_encl_scope","","",302,{"inputs":[{"name":"self"},{"name":"e"}],"output":null}],[11,"each_var_scope","","",302,{"inputs":[{"name":"self"},{"name":"e"}],"output":null}],[11,"opt_destruction_scope","","",302,{"inputs":[{"name":"self"},{"name":"itemlocalid"}],"output":{"generics":["scope"],"name":"option"}}],[11,"opt_encl_scope","","Returns the narrowest scope that encloses `id`, if any.",302,{"inputs":[{"name":"self"},{"name":"scope"}],"output":{"generics":["scope"],"name":"option"}}],[11,"encl_scope","","Returns the narrowest scope that encloses `id`, if any.",302,{"inputs":[{"name":"self"},{"name":"scope"}],"output":{"name":"scope"}}],[11,"var_scope","","Returns the lifetime of the local variable `var_id`",302,{"inputs":[{"name":"self"},{"name":"itemlocalid"}],"output":{"name":"scope"}}],[11,"temporary_scope","","Returns the scope when temp created by expr_id will be cleaned up",302,{"inputs":[{"name":"self"},{"name":"itemlocalid"}],"output":{"generics":["scope"],"name":"option"}}],[11,"var_region","","Returns the lifetime of the variable `id`.",302,{"inputs":[{"name":"self"},{"name":"itemlocalid"}],"output":{"name":"regionkind"}}],[11,"scopes_intersect","","",302,{"inputs":[{"name":"self"},{"name":"scope"},{"name":"scope"}],"output":{"name":"bool"}}],[11,"is_subscope_of","","Returns true if `subscope` is equal to or is lexically nested inside `superscope` and false otherwise.",302,{"inputs":[{"name":"self"},{"name":"scope"},{"name":"scope"}],"output":{"name":"bool"}}],[11,"containing_body","","Returns the id of the innermost containing body",302,{"inputs":[{"name":"self"},{"name":"scope"}],"output":{"generics":["itemlocalid"],"name":"option"}}],[11,"nearest_common_ancestor","","Finds the nearest common ancestor (if any) of two scopes.  That is, finds the smallest scope which is greater than or equal to both `scope_a` and `scope_b`.",302,{"inputs":[{"name":"self"},{"name":"scope"},{"name":"scope"}],"output":{"name":"scope"}}],[11,"early_free_scope","","Assuming that the provided region was defined within this `ScopeTree`, returns the outermost `Scope` that the region outlives.",302,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"earlyboundregion"}],"output":{"name":"scope"}}],[11,"free_scope","","Assuming that the provided region was defined within this `ScopeTree`, returns the outermost `Scope` that the region outlives.",302,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"freeregion"}],"output":{"name":"scope"}}],[11,"yield_in_scope","","Checks whether the given scope contains a `yield`. If so, returns `Some((span, expr_count))` with the span of a yield we found and the number of expressions and patterns appearing before the `yield` in the body + 1. If there a are multiple yields in a scope, the one with the highest number is returned.",302,{"inputs":[{"name":"self"},{"name":"scope"}],"output":{"name":"option"}}],[11,"yield_in_scope_for_expr","","Checks whether the given scope contains a `yield` and if that yield could execute after `expr`. If so, it returns the span of that `yield`. `scope` must be inside the body.",302,{"inputs":[{"name":"self"},{"name":"scope"},{"name":"nodeid"},{"name":"body"}],"output":{"generics":["span"],"name":"option"}}],[11,"body_expr_count","","Gives the number of expressions visited in a body. Used to sanity check visit_expr call count when calculating generator interiors.",302,{"inputs":[{"name":"self"},{"name":"bodyid"}],"output":{"generics":["usize"],"name":"option"}}],[11,"hash_stable","","",302,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[0,"recursion_limit","rustc::middle","",null,null],[5,"update_limits","rustc::middle::recursion_limit","",null,{"inputs":[{"name":"session"},{"name":"crate"}],"output":null}],[0,"resolve_lifetime","rustc::middle","Name resolution for lifetimes.",null,null],[3,"ResolveLifetimes","rustc::middle::resolve_lifetime","See `NamedRegionMap`.",null,null],[4,"LifetimeDefOrigin","","The origin of a named lifetime definition.",null,null],[13,"Explicit","","",304,null],[13,"InBand","","",304,null],[4,"LifetimeUseSet","","",null,null],[13,"One","","",305,null],[13,"Many","","",305,null],[4,"Region","","",null,null],[13,"Static","","",306,null],[13,"EarlyBound","","",306,null],[13,"LateBound","","",306,null],[13,"LateBoundAnon","","",306,null],[13,"Free","","",306,null],[4,"Set1","","A set containing, at most, one known element. If two distinct values are inserted into a set, then it becomes `Many`, which can be used to detect ambiguities.",null,null],[13,"Empty","","",307,null],[13,"One","","",307,null],[13,"Many","","",307,null],[5,"provide","","",null,{"inputs":[{"name":"providers"}],"output":null}],[5,"report_missing_lifetime_specifiers","","",null,{"inputs":[{"name":"session"},{"name":"span"},{"name":"usize"}],"output":{"name":"diagnosticbuilder"}}],[6,"ObjectLifetimeDefault","","",null,null],[11,"clone","","",304,{"inputs":[{"name":"self"}],"output":{"name":"lifetimedeforigin"}}],[11,"eq","","",304,{"inputs":[{"name":"self"},{"name":"lifetimedeforigin"}],"output":{"name":"bool"}}],[11,"hash","","",304,null],[11,"encode","","",304,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",304,{"inputs":[{"name":"__d"}],"output":{"generics":["lifetimedeforigin"],"name":"result"}}],[11,"fmt","","",304,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",305,{"inputs":[{"name":"self"}],"output":{"name":"lifetimeuseset"}}],[11,"fmt","","",305,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",306,{"inputs":[{"name":"self"}],"output":{"name":"region"}}],[11,"eq","","",306,{"inputs":[{"name":"self"},{"name":"region"}],"output":{"name":"bool"}}],[11,"ne","","",306,{"inputs":[{"name":"self"},{"name":"region"}],"output":{"name":"bool"}}],[11,"hash","","",306,null],[11,"encode","","",306,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",306,{"inputs":[{"name":"__d"}],"output":{"generics":["region"],"name":"result"}}],[11,"fmt","","",306,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",307,{"inputs":[{"name":"self"}],"output":{"name":"set1"}}],[11,"eq","","",307,{"inputs":[{"name":"self"},{"name":"set1"}],"output":{"name":"bool"}}],[11,"ne","","",307,{"inputs":[{"name":"self"},{"name":"set1"}],"output":{"name":"bool"}}],[11,"encode","","",307,{"inputs":[{"name":"self"},{"name":"__st"}],"output":{"name":"result"}}],[11,"decode","","",307,{"inputs":[{"name":"__dt"}],"output":{"generics":["set1"],"name":"result"}}],[11,"fmt","","",307,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"insert","","",307,{"inputs":[{"name":"self"},{"name":"t"}],"output":null}],[11,"hash_stable","","",308,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[0,"stability","rustc::middle","A pass that annotates every item and method with its stability level, propagating default levels lexically from parent to children ast nodes.",null,null],[3,"DeprecationEntry","rustc::middle::stability","An entry in the `depr_map`.",null,null],[12,"attr","","The metadata of the attribute associated with this entry.",309,null],[3,"Index","","A stability index, giving the stability level for items and methods.",null,null],[4,"StabilityLevel","","",null,null],[13,"Unstable","","",310,null],[13,"Stable","","",310,null],[4,"EvalResult","","Result of `TyCtxt::eval_stability`.",null,null],[13,"Allow","","We can use the item because it is stable or we provided the corresponding feature gate.",311,null],[13,"Deny","","We cannot use the item because it is unstable and we did not provide the corresponding feature gate.",311,null],[12,"feature","rustc::middle::stability::EvalResult","",311,null],[12,"reason","","",311,null],[12,"issue","","",311,null],[13,"Unmarked","rustc::middle::stability","The item does not have the `#[stable]` or `#[unstable]` marker assigned.",311,null],[5,"check_unstable_api_usage","","Cross-references the feature names of unstable APIs with enabled features and possibly prints errors.",null,{"inputs":[{"name":"tyctxt"}],"output":null}],[5,"check_unused_or_stable_features","","Given the list of enabled features that were not language features (i.e. that were expected to be library features), and the list of features used from libraries, identify activated features that don't exist and error about them.",null,{"inputs":[{"name":"tyctxt"}],"output":null}],[11,"encode","","",310,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",310,{"inputs":[{"name":"__d"}],"output":{"generics":["stabilitylevel"],"name":"result"}}],[11,"eq","","",310,{"inputs":[{"name":"self"},{"name":"stabilitylevel"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",310,{"inputs":[{"name":"self"},{"name":"stabilitylevel"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"clone","","",310,{"inputs":[{"name":"self"}],"output":{"name":"stabilitylevel"}}],[11,"fmt","","",310,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",310,null],[11,"from_attr_level","","",310,{"inputs":[{"name":"stabilitylevel"}],"output":{"name":"self"}}],[11,"clone","","",309,{"inputs":[{"name":"self"}],"output":{"name":"deprecationentry"}}],[11,"hash_stable","","",309,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"external","","",309,{"inputs":[{"name":"deprecation"}],"output":{"name":"deprecationentry"}}],[11,"same_origin","","",309,{"inputs":[{"name":"self"},{"name":"deprecationentry"}],"output":{"name":"bool"}}],[11,"hash_stable","","",312,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"new","","",312,{"inputs":[{"name":"tyctxt"}],"output":{"name":"index"}}],[11,"local_stability","","",312,{"inputs":[{"name":"self"},{"name":"hirid"}],"output":{"generics":["stability"],"name":"option"}}],[11,"local_deprecation_entry","","",312,{"inputs":[{"name":"self"},{"name":"hirid"}],"output":{"generics":["deprecationentry"],"name":"option"}}],[0,"weak_lang_items","rustc::middle","Validity checking for weak lang items",null,null],[5,"check_crate","rustc::middle::weak_lang_items","Checks the crate for usage of weak lang items, returning a vector of all the language items required by this crate, but not defined yet.",null,{"inputs":[{"name":"tyctxt"},{"name":"languageitems"}],"output":null}],[5,"link_name","","",null,null],[0,"mir","rustc","MIR datatypes and passes. See the [rustc guide] for more info.",null,null],[3,"Mir","rustc::mir","Lowered representation of a single function.",null,null],[12,"visibility_scopes","","List of visibility (lexical) scopes; these are referenced by statements and used (eventually) for debuginfo. Indexed by a `VisibilityScope`.",313,null],[12,"visibility_scope_info","","Crate-local information for each visibility scope, that can't (and needn't) be tracked across crates.",313,null],[12,"promoted","","Rvalues promoted from this function, such as borrows of constants. Each of them is the Mir of a constant with the fn's type parameters in scope, but a separate set of locals.",313,null],[12,"yield_ty","","Yield type of the function, if it is a generator.",313,null],[12,"generator_drop","","Generator drop glue",313,null],[12,"generator_layout","","The layout of a generator. Produced by the state transformation.",313,null],[12,"local_decls","","Declarations of locals.",313,null],[12,"arg_count","","Number of arguments this function takes.",313,null],[12,"upvar_decls","","Names and capture modes of all the closure upvars, assuming the first argument is either the closure or a reference to it.",313,null],[12,"spread_arg","","Mark an argument local (which must be a tuple) as getting passed as its individual components at the LLVM level.",313,null],[12,"span","","A span representing this MIR, for error reporting",313,null],[3,"VisibilityScopeInfo","","",null,null],[12,"lint_root","","A NodeId with lint levels equivalent to this scope's lint levels.",314,null],[12,"safety","","The unsafe block that contains this node.",314,null],[3,"SourceInfo","","Grouped information about the source code origin of a MIR entity. Intended to be inspected by diagnostics and debuginfo. Most passes can work with it as a whole, within a single function.",null,null],[12,"span","","Source span for the AST pertaining to this MIR entity.",315,null],[12,"scope","","The lexical visibility scope, i.e. which bindings can be seen.",315,null],[3,"Local","","",null,null],[3,"LocalDecl","","A MIR local.",null,null],[12,"mutability","","`let mut x` vs `let x`.",316,null],[12,"is_user_variable","","True if this corresponds to a user-declared local variable.",316,null],[12,"internal","","True if this is an internal local",316,null],[12,"ty","","Type of this local.",316,null],[12,"name","","Name of the local, used in debuginfo and pretty-printing.",316,null],[12,"source_info","","Source info of the local.",316,null],[12,"syntactic_scope","","The syntactic visibility scope the local is defined in. If the local was defined in a let-statement, this is within the let-statement, rather than outside of it.",316,null],[3,"UpvarDecl","","A closure capture, with its name and mode.",null,null],[12,"debug_name","","",317,null],[12,"by_ref","","If true, the capture is behind a reference.",317,null],[12,"mutability","","",317,null],[3,"BasicBlock","","",null,null],[3,"BasicBlockData","","",null,null],[12,"statements","","List of statements in this block.",318,null],[12,"terminator","","Terminator for this block.",318,null],[12,"is_cleanup","","If true, this block lies on an unwind path. This is used during trans where distinct kinds of basic blocks may be generated (particularly for MSVC cleanup). Unwind blocks must only branch to other unwind blocks.",318,null],[3,"Terminator","","",null,null],[12,"source_info","","",319,null],[12,"kind","","",319,null],[3,"Statement","","",null,null],[12,"source_info","","",320,null],[12,"kind","","",320,null],[3,"ValidationOperand","","",null,null],[12,"place","","",321,null],[12,"ty","","",321,null],[12,"re","","",321,null],[12,"mutbl","","",321,null],[3,"Static","","The def-id of a static, along with its normalized type (which is stored to avoid requiring normalization when reading MIR).",null,null],[12,"def_id","","",322,null],[12,"ty","","",322,null],[3,"Projection","","The `Projection` data structure defines things of the form `B.x` or `*B` or `B[index]`. Note that it is parameterized because it is shared between `Constant` and `Place`. See the aliases `PlaceProjection` etc below.",null,null],[12,"base","","",323,null],[12,"elem","","",323,null],[3,"Field","","",null,null],[3,"VisibilityScope","","",null,null],[3,"VisibilityScopeData","","",null,null],[12,"span","","",324,null],[12,"parent_scope","","",324,null],[3,"Constant","","Constants",null,null],[12,"span","","",325,null],[12,"ty","","",325,null],[12,"literal","","",325,null],[3,"Promoted","","",null,null],[3,"Location","","",null,null],[12,"block","","the location is within this block",326,null],[12,"statement_index","","the location is the start of the statement; or, if `statement_index` == num-statements, then the start of the terminator.",326,null],[3,"UnsafetyViolation","","",null,null],[12,"source_info","","",327,null],[12,"description","","",327,null],[12,"kind","","",327,null],[3,"UnsafetyCheckResult","","",null,null],[12,"violations","","Violations that are propagated upwards from this function",328,null],[12,"unsafe_blocks","","unsafe blocks in this function, along with whether they are used. This is used for the \"unused_unsafe\" lint.",328,null],[3,"GeneratorLayout","","The layout of generator state",null,null],[12,"fields","","",329,null],[3,"ClosureRegionRequirements","","After we borrow check a closure, we are left with various requirements that we have inferred between the free regions that appear in the closure's signature or on its field types.  These requirements are then verified and proved by the closure's creating function. This struct encodes those requirements.",null,null],[12,"num_external_vids","","The number of external regions defined on the closure.  In our example above, it would be 3 -- one for `'static`, then `'1` and `'2`. This is just used for a sanity check later on, to make sure that the number of regions we see at the callsite matches.",330,null],[12,"outlives_requirements","","Requirements between the various free regions defined in indices.",330,null],[3,"ClosureOutlivesRequirement","","Indicates an outlives constraint between a type or between two free-regions declared on the closure.",null,null],[12,"subject","","",331,null],[12,"outlived_free_region","","",331,null],[12,"blame_span","","",331,null],[4,"Safety","","",null,null],[13,"Safe","","",332,null],[13,"BuiltinUnsafe","","Unsafe because of a PushUnsafeBlock",332,null],[13,"FnUnsafe","","Unsafe because of an unsafe fn",332,null],[13,"ExplicitUnsafe","","Unsafe because of an `unsafe` block",332,null],[4,"ClearCrossCrate","","",null,null],[13,"Clear","","",333,null],[13,"Set","","",333,null],[4,"Mutability","","",null,null],[13,"Mut","","",334,null],[13,"Not","","",334,null],[4,"BorrowKind","","",null,null],[13,"Shared","","Data must be immutable and is aliasable.",335,null],[13,"Unique","","Data must be immutable but not aliasable.  This kind of borrow cannot currently be expressed by the user and is used only in implicit closure bindings. It is needed when you the closure is borrowing or mutating a mutable referent, e.g.:",335,null],[13,"Mut","","Data is mutable and not aliasable.",335,null],[12,"allow_two_phase_borrow","rustc::mir::BorrowKind","True if this borrow arose from method-call auto-ref (i.e. `adjustment::Adjust::Borrow`)",335,null],[4,"LocalKind","rustc::mir","Classifies locals into categories. See `Mir::local_kind`.",null,null],[13,"Var","","User-declared variable binding",336,null],[13,"Temp","","Compiler-introduced temporary",336,null],[13,"Arg","","Function argument",336,null],[13,"ReturnPointer","","Location of function's return value",336,null],[4,"TerminatorKind","","",null,null],[13,"Goto","","block should have one successor in the graph; we jump there",337,null],[12,"target","rustc::mir::TerminatorKind","",337,null],[13,"SwitchInt","rustc::mir","operand evaluates to an integer; jump depending on its value to one of the targets, and otherwise fallback to `otherwise`",337,null],[12,"discr","rustc::mir::TerminatorKind","discriminant value being tested",337,null],[12,"switch_ty","","type of value being tested",337,null],[12,"values","","Possible values. The locations to branch to in each case are found in the corresponding indices from the `targets` vector.",337,null],[12,"targets","","Possible branch sites. The last element of this vector is used for the otherwise branch, so targets.len() == values.len() + 1 should hold.",337,null],[13,"Resume","rustc::mir","Indicates that the landing pad is finished and unwinding should continue. Emitted by build::scope::diverge_cleanup.",337,null],[13,"Abort","","Indicates that the landing pad is finished and that the process should abort. Used to prevent unwinding for foreign items.",337,null],[13,"Return","","Indicates a normal return. The return place should have been filled in by now. This should occur at most once.",337,null],[13,"Unreachable","","Indicates a terminator that can never be reached.",337,null],[13,"Drop","","Drop the Place",337,null],[12,"location","rustc::mir::TerminatorKind","",337,null],[12,"target","","",337,null],[12,"unwind","","",337,null],[13,"DropAndReplace","rustc::mir","Drop the Place and assign the new value over it. This ensures that the assignment to `P` occurs even if the destructor for place unwinds. Its semantics are best explained by by the elaboration:",337,null],[12,"location","rustc::mir::TerminatorKind","",337,null],[12,"value","","",337,null],[12,"target","","",337,null],[12,"unwind","","",337,null],[13,"Call","rustc::mir","Block ends with a call of a converging function",337,null],[12,"func","rustc::mir::TerminatorKind","The function that’s being called",337,null],[12,"args","","Arguments the function is called with. These are owned by the callee, which is free to modify them. This allows the memory occupied by \"by-value\" arguments to be reused across function calls without duplicating the contents.",337,null],[12,"destination","","Destination for the return value. If some, the call is converging.",337,null],[12,"cleanup","","Cleanups to be done if the call unwinds.",337,null],[13,"Assert","rustc::mir","Jump to the target if the condition has the expected value, otherwise panic with a message and a cleanup target.",337,null],[12,"cond","rustc::mir::TerminatorKind","",337,null],[12,"expected","","",337,null],[12,"msg","","",337,null],[12,"target","","",337,null],[12,"cleanup","","",337,null],[13,"Yield","rustc::mir","A suspend point",337,null],[12,"value","rustc::mir::TerminatorKind","The value to return",337,null],[12,"resume","","Where to resume to",337,null],[12,"drop","","Cleanup to be done if the generator is dropped at this suspend point",337,null],[13,"GeneratorDrop","rustc::mir","Indicates the end of the dropping of a generator",337,null],[13,"FalseEdges","","A block where control flow only ever takes one real path, but borrowck needs to be more conservative.",337,null],[12,"real_target","rustc::mir::TerminatorKind","The target normal control flow will take",337,null],[12,"imaginary_targets","","The list of blocks control flow could conceptually take, but won't in practice",337,null],[13,"FalseUnwind","rustc::mir","A terminator for blocks that only take one path in reality, but where we reserve the right to unwind in borrowck, even if it won't happen in practice. This can arise in infinite loops with no function calls for example.",337,null],[12,"real_target","rustc::mir::TerminatorKind","The target normal control flow will take",337,null],[12,"unwind","","The imaginary cleanup block link. This particular path will never be taken in practice, but in order to avoid fragility we want to always consider it in borrowck. We don't want to accept programs which pass borrowck only when panic=abort or some assertions are disabled due to release vs. debug mode builds. This needs to be an Option because of the remove_noop_landing_pads and no_landing_pads passes",337,null],[4,"AssertMessage","rustc::mir","",null,null],[13,"BoundsCheck","","",338,null],[12,"len","rustc::mir::AssertMessage","",338,null],[12,"index","","",338,null],[13,"Math","rustc::mir","",338,null],[13,"GeneratorResumedAfterReturn","","",338,null],[13,"GeneratorResumedAfterPanic","","",338,null],[4,"StatementKind","","",null,null],[13,"Assign","","Write the RHS Rvalue to the LHS Place.",339,null],[13,"SetDiscriminant","","Write the discriminant for a variant to the enum Place.",339,null],[12,"place","rustc::mir::StatementKind","",339,null],[12,"variant_index","","",339,null],[13,"StorageLive","rustc::mir","Start a live range for the storage of the local.",339,null],[13,"StorageDead","","End the current live range for the storage of the local.",339,null],[13,"InlineAsm","","Execute a piece of inline Assembly.",339,null],[12,"asm","rustc::mir::StatementKind","",339,null],[12,"outputs","","",339,null],[12,"inputs","","",339,null],[13,"Validate","rustc::mir","Assert the given places to be valid inhabitants of their type.  These statements are currently only interpreted by miri and only generated when \"-Z mir-emit-validate\" is passed. See https://internals.rust-lang.org/t/types-as-contracts/5562/73 for more details.",339,null],[13,"EndRegion","","Mark one terminating point of a region scope (i.e. static region). (The starting point(s) arise implicitly from borrows.)",339,null],[13,"UserAssertTy","","Encodes a user's type assertion. These need to be preserved intact so that NLL can respect them. For example:",339,null],[13,"Nop","","No-op. Useful for deleting instructions without affecting statement indices.",339,null],[4,"ValidationOp","","The `ValidationOp` describes what happens with each of the operands of a `Validate` statement.",null,null],[13,"Acquire","","Recursively traverse the place following the type and validate that all type invariants are maintained.  Furthermore, acquire exclusive/read-only access to the memory reachable from the place.",340,null],[13,"Release","","Recursive traverse the mutable part of the type and relinquish all exclusive access.",340,null],[13,"Suspend","","Recursive traverse the mutable part of the type and relinquish all exclusive access until the given region ends.  Then, access will be recovered.",340,null],[4,"Place","","A path to a value; something that can be evaluated without changing or disturbing program state.",null,null],[13,"Local","","local variable",341,null],[13,"Static","","static or static mut variable",341,null],[13,"Projection","","projection out of a place (access a field, deref a pointer, etc)",341,null],[4,"ProjectionElem","","",null,null],[13,"Deref","","",342,null],[13,"Field","","",342,null],[13,"Index","","",342,null],[13,"ConstantIndex","","These indices are generated by slice patterns. Easiest to explain by example:",342,null],[12,"offset","rustc::mir::ProjectionElem","index or -index (in Python terms), depending on from_end",342,null],[12,"min_length","","thing being indexed must be at least this long",342,null],[12,"from_end","","counting backwards from end?",342,null],[13,"Subslice","rustc::mir","These indices are generated by slice patterns.",342,null],[12,"from","rustc::mir::ProjectionElem","",342,null],[12,"to","","",342,null],[13,"Downcast","rustc::mir","\"Downcast\" to a variant of an ADT. Currently, we only introduce this for ADTs with more than one variant. It may be better to just introduce it always, or always for enums.",342,null],[4,"Operand","","These are values that can appear inside an rvalue (or an index place). They are intentionally limited to prevent rvalues from being nested in one another.",null,null],[13,"Copy","","Copy: The value must be available for use afterwards.",343,null],[13,"Move","","Move: The value (including old borrows of it) will not be used again.",343,null],[13,"Constant","","",343,null],[4,"Rvalue","","Rvalues",null,null],[13,"Use","","x (either a move or copy, depending on type of x)",344,null],[13,"Repeat","","[x; 32]",344,null],[13,"Ref","","&x or &mut x",344,null],[13,"Len","","length of a [X] or [X;n] value",344,null],[13,"Cast","","",344,null],[13,"BinaryOp","","",344,null],[13,"CheckedBinaryOp","","",344,null],[13,"NullaryOp","","",344,null],[13,"UnaryOp","","",344,null],[13,"Discriminant","","Read the discriminant of an ADT.",344,null],[13,"Aggregate","","Create an aggregate value, like a tuple or struct.  This is only needed because we want to distinguish `dest = Foo { x: ..., y: ... }` from `dest.x = ...; dest.y = ...;` in the case that `Foo` has a destructor. These rvalues can be optimized away after type-checking and before lowering.",344,null],[4,"CastKind","","",null,null],[13,"Misc","","",345,null],[13,"ReifyFnPointer","","Convert unique, zero-sized type for a fn to fn()",345,null],[13,"ClosureFnPointer","","Convert non capturing closure to fn()",345,null],[13,"UnsafeFnPointer","","Convert safe fn() to unsafe fn()",345,null],[13,"Unsize","","\"Unsize\" -- convert a thin-or-fat pointer to a fat pointer. trans must figure out the details once full monomorphization is known. For example, this could be used to cast from a `&[i32;N]` to a `&[i32]`, or a `Box<T>` to a `Box<Trait>` (presuming `T: Trait`).",345,null],[4,"AggregateKind","","",null,null],[13,"Array","","The type is of the element",346,null],[13,"Tuple","","",346,null],[13,"Adt","","The second field is the variant index. It's equal to 0 for struct and union expressions. The fourth field is active field number and is present only for union expressions -- e.g. for a union expression `SomeUnion { c: .. }`, the active field index would identity the field `c`",346,null],[13,"Closure","","",346,null],[13,"Generator","","",346,null],[4,"BinOp","","",null,null],[13,"Add","","The `+` operator (addition)",347,null],[13,"Sub","","The `-` operator (subtraction)",347,null],[13,"Mul","","The `*` operator (multiplication)",347,null],[13,"Div","","The `/` operator (division)",347,null],[13,"Rem","","The `%` operator (modulus)",347,null],[13,"BitXor","","The `^` operator (bitwise xor)",347,null],[13,"BitAnd","","The `&` operator (bitwise and)",347,null],[13,"BitOr","","The `|` operator (bitwise or)",347,null],[13,"Shl","","The `<<` operator (shift left)",347,null],[13,"Shr","","The `>>` operator (shift right)",347,null],[13,"Eq","","The `==` operator (equality)",347,null],[13,"Lt","","The `<` operator (less than)",347,null],[13,"Le","","The `<=` operator (less than or equal to)",347,null],[13,"Ne","","The `!=` operator (not equal to)",347,null],[13,"Ge","","The `>=` operator (greater than or equal to)",347,null],[13,"Gt","","The `>` operator (greater than)",347,null],[13,"Offset","","The `ptr.offset` operator",347,null],[4,"NullOp","","",null,null],[13,"SizeOf","","Return the size of a value of that type",348,null],[13,"Box","","Create a new uninitialized box for a value of that type",348,null],[4,"UnOp","","",null,null],[13,"Not","","The `!` operator for logical inversion",349,null],[13,"Neg","","The `-` operator for negation",349,null],[4,"Literal","","",null,null],[13,"Value","","",350,null],[12,"value","rustc::mir::Literal","",350,null],[13,"Promoted","rustc::mir","",350,null],[12,"index","rustc::mir::Literal","",350,null],[4,"UnsafetyViolationKind","rustc::mir","",null,null],[13,"General","","",351,null],[13,"ExternStatic","","",351,null],[13,"BorrowPacked","","",351,null],[4,"ClosureOutlivesSubject","","The subject of a ClosureOutlivesRequirement -- that is, the thing that must outlive some region.",null,null],[13,"Ty","","Subject is a type, typically a type parameter, but could also be a projection. Indicates a requirement like `T: 'a` being passed to the caller, where the type here is `T`.",352,null],[13,"Region","","Subject is a free region from the closure. Indicates a requirement like `'a: 'b` being passed to the caller; the region here is `'a`.",352,null],[5,"print_miri_value","","",null,{"inputs":[{"name":"value"},{"name":"ty"},{"name":"w"}],"output":{"name":"result"}}],[0,"tcx","","Methods for the various MIR types. These are intended for use after building is complete.",null,null],[4,"PlaceTy","rustc::mir::tcx","",null,null],[13,"Ty","","Normal type.",353,null],[12,"ty","rustc::mir::tcx::PlaceTy","",353,null],[13,"Downcast","rustc::mir::tcx","Downcast to a particular variant of an enum.",353,null],[12,"adt_def","rustc::mir::tcx::PlaceTy","",353,null],[12,"substs","","",353,null],[12,"variant_index","","",353,null],[4,"RvalueInitializationState","rustc::mir::tcx","",null,null],[13,"Shallow","","",354,null],[13,"Deep","","",354,null],[11,"clone","","",353,{"inputs":[{"name":"self"}],"output":{"name":"placety"}}],[11,"fmt","","",353,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"from_ty","","",353,{"inputs":[{"name":"ty"}],"output":{"name":"placety"}}],[11,"to_ty","","",353,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"ty"}}],[11,"projection_ty","","",353,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"placeelem"}],"output":{"name":"placety"}}],[11,"super_fold_with","","",353,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",353,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"ty","rustc::mir","",341,{"inputs":[{"name":"self"},{"name":"d"},{"name":"tyctxt"}],"output":{"name":"placety"}}],[11,"ty","","",344,{"inputs":[{"name":"self"},{"name":"d"},{"name":"tyctxt"}],"output":{"name":"ty"}}],[11,"initialization_state","","Returns whether this rvalue is deeply initialized (most rvalues) or whether its only shallowly initialized (`Rvalue::Box`).",344,{"inputs":[{"name":"self"}],"output":{"name":"rvalueinitializationstate"}}],[11,"ty","","",343,{"inputs":[{"name":"self"},{"name":"d"},{"name":"tyctxt"}],"output":{"name":"ty"}}],[11,"ty","","",347,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"ty"},{"name":"ty"}],"output":{"name":"ty"}}],[11,"to_mutbl_lossy","","",335,{"inputs":[{"name":"self"}],"output":{"name":"mutability"}}],[11,"to_hir_binop","","",347,{"inputs":[{"name":"self"}],"output":{"name":"binop_"}}],[0,"visit","","",null,null],[4,"TyContext","rustc::mir::visit","Extra information passed to `visit_ty` and friends to give context about where the type etc appears.",null,null],[13,"LocalDecl","","",355,null],[12,"local","rustc::mir::visit::TyContext","The index of the local variable we are visiting.",355,null],[12,"source_info","","The source location where this local variable was declared.",355,null],[13,"ReturnTy","rustc::mir::visit","The return type of the function.",355,null],[13,"YieldTy","","",355,null],[13,"Location","","A type found at some location.",355,null],[4,"PlaceContext","","",null,null],[13,"Store","","",356,null],[13,"AsmOutput","","",356,null],[13,"Call","","",356,null],[13,"Drop","","",356,null],[13,"Inspect","","",356,null],[13,"Borrow","","",356,null],[12,"region","rustc::mir::visit::PlaceContext","",356,null],[12,"kind","","",356,null],[13,"Projection","rustc::mir::visit","",356,null],[13,"Copy","","",356,null],[13,"Move","","",356,null],[13,"StorageLive","","",356,null],[13,"StorageDead","","",356,null],[13,"Validate","","",356,null],[8,"Visitor","","",null,null],[11,"visit_mir","","",357,{"inputs":[{"name":"self"},{"name":"mir"}],"output":null}],[11,"visit_basic_block_data","","",357,{"inputs":[{"name":"self"},{"name":"basicblock"},{"name":"basicblockdata"}],"output":null}],[11,"visit_visibility_scope_data","","",357,{"inputs":[{"name":"self"},{"name":"visibilityscopedata"}],"output":null}],[11,"visit_statement","","",357,{"inputs":[{"name":"self"},{"name":"basicblock"},{"name":"statement"},{"name":"location"}],"output":null}],[11,"visit_assign","","",357,{"inputs":[{"name":"self"},{"name":"basicblock"},{"name":"place"},{"name":"rvalue"},{"name":"location"}],"output":null}],[11,"visit_terminator","","",357,{"inputs":[{"name":"self"},{"name":"basicblock"},{"name":"terminator"},{"name":"location"}],"output":null}],[11,"visit_terminator_kind","","",357,{"inputs":[{"name":"self"},{"name":"basicblock"},{"name":"terminatorkind"},{"name":"location"}],"output":null}],[11,"visit_assert_message","","",357,{"inputs":[{"name":"self"},{"name":"assertmessage"},{"name":"location"}],"output":null}],[11,"visit_rvalue","","",357,{"inputs":[{"name":"self"},{"name":"rvalue"},{"name":"location"}],"output":null}],[11,"visit_operand","","",357,{"inputs":[{"name":"self"},{"name":"operand"},{"name":"location"}],"output":null}],[11,"visit_user_assert_ty","","",357,{"inputs":[{"name":"self"},{"name":"canonicalty"},{"name":"local"},{"name":"location"}],"output":null}],[11,"visit_place","","",357,{"inputs":[{"name":"self"},{"name":"place"},{"name":"placecontext"},{"name":"location"}],"output":null}],[11,"visit_static","","",357,{"inputs":[{"name":"self"},{"name":"static"},{"name":"placecontext"},{"name":"location"}],"output":null}],[11,"visit_projection","","",357,{"inputs":[{"name":"self"},{"name":"placeprojection"},{"name":"placecontext"},{"name":"location"}],"output":null}],[11,"visit_projection_elem","","",357,{"inputs":[{"name":"self"},{"name":"placeelem"},{"name":"placecontext"},{"name":"location"}],"output":null}],[11,"visit_branch","","",357,{"inputs":[{"name":"self"},{"name":"basicblock"},{"name":"basicblock"}],"output":null}],[11,"visit_constant","","",357,{"inputs":[{"name":"self"},{"name":"constant"},{"name":"location"}],"output":null}],[11,"visit_literal","","",357,{"inputs":[{"name":"self"},{"name":"literal"},{"name":"location"}],"output":null}],[11,"visit_def_id","","",357,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"location"}],"output":null}],[11,"visit_span","","",357,{"inputs":[{"name":"self"},{"name":"span"}],"output":null}],[11,"visit_source_info","","",357,{"inputs":[{"name":"self"},{"name":"sourceinfo"}],"output":null}],[11,"visit_ty","","",357,{"inputs":[{"name":"self"},{"name":"ty"},{"name":"tycontext"}],"output":null}],[11,"visit_region","","",357,{"inputs":[{"name":"self"},{"name":"region"},{"name":"location"}],"output":null}],[11,"visit_const","","",357,{"inputs":[{"name":"self"},{"name":"const"},{"name":"location"}],"output":null}],[11,"visit_substs","","",357,{"inputs":[{"name":"self"},{"name":"substs"},{"name":"location"}],"output":null}],[11,"visit_closure_substs","","",357,{"inputs":[{"name":"self"},{"name":"closuresubsts"},{"name":"location"}],"output":null}],[11,"visit_generator_interior","","",357,{"inputs":[{"name":"self"},{"name":"generatorinterior"},{"name":"location"}],"output":null}],[11,"visit_local_decl","","",357,{"inputs":[{"name":"self"},{"name":"local"},{"name":"localdecl"}],"output":null}],[11,"visit_local","","",357,{"inputs":[{"name":"self"},{"name":"local"},{"name":"placecontext"},{"name":"location"}],"output":null}],[11,"visit_visibility_scope","","",357,{"inputs":[{"name":"self"},{"name":"visibilityscope"}],"output":null}],[11,"super_mir","","",357,{"inputs":[{"name":"self"},{"name":"mir"}],"output":null}],[11,"super_basic_block_data","","",357,{"inputs":[{"name":"self"},{"name":"basicblock"},{"name":"basicblockdata"}],"output":null}],[11,"super_visibility_scope_data","","",357,{"inputs":[{"name":"self"},{"name":"visibilityscopedata"}],"output":null}],[11,"super_statement","","",357,{"inputs":[{"name":"self"},{"name":"basicblock"},{"name":"statement"},{"name":"location"}],"output":null}],[11,"super_assign","","",357,{"inputs":[{"name":"self"},{"name":"basicblock"},{"name":"place"},{"name":"rvalue"},{"name":"location"}],"output":null}],[11,"super_terminator","","",357,{"inputs":[{"name":"self"},{"name":"basicblock"},{"name":"terminator"},{"name":"location"}],"output":null}],[11,"super_terminator_kind","","",357,{"inputs":[{"name":"self"},{"name":"basicblock"},{"name":"terminatorkind"},{"name":"location"}],"output":null}],[11,"super_assert_message","","",357,{"inputs":[{"name":"self"},{"name":"assertmessage"},{"name":"location"}],"output":null}],[11,"super_rvalue","","",357,{"inputs":[{"name":"self"},{"name":"rvalue"},{"name":"location"}],"output":null}],[11,"super_operand","","",357,{"inputs":[{"name":"self"},{"name":"operand"},{"name":"location"}],"output":null}],[11,"super_user_assert_ty","","",357,{"inputs":[{"name":"self"},{"name":"canonicalty"},{"name":"local"},{"name":"location"}],"output":null}],[11,"super_place","","",357,{"inputs":[{"name":"self"},{"name":"place"},{"name":"placecontext"},{"name":"location"}],"output":null}],[11,"super_static","","",357,{"inputs":[{"name":"self"},{"name":"static"},{"name":"placecontext"},{"name":"location"}],"output":null}],[11,"super_projection","","",357,{"inputs":[{"name":"self"},{"name":"placeprojection"},{"name":"placecontext"},{"name":"location"}],"output":null}],[11,"super_projection_elem","","",357,{"inputs":[{"name":"self"},{"name":"placeelem"},{"name":"placecontext"},{"name":"location"}],"output":null}],[11,"super_local_decl","","",357,{"inputs":[{"name":"self"},{"name":"local"},{"name":"localdecl"}],"output":null}],[11,"super_visibility_scope","","",357,{"inputs":[{"name":"self"},{"name":"visibilityscope"}],"output":null}],[11,"super_branch","","",357,{"inputs":[{"name":"self"},{"name":"basicblock"},{"name":"basicblock"}],"output":null}],[11,"super_constant","","",357,{"inputs":[{"name":"self"},{"name":"constant"},{"name":"location"}],"output":null}],[11,"super_literal","","",357,{"inputs":[{"name":"self"},{"name":"literal"},{"name":"location"}],"output":null}],[11,"super_def_id","","",357,{"inputs":[{"name":"self"},{"name":"defid"}],"output":null}],[11,"super_span","","",357,{"inputs":[{"name":"self"},{"name":"span"}],"output":null}],[11,"super_source_info","","",357,{"inputs":[{"name":"self"},{"name":"sourceinfo"}],"output":null}],[11,"super_ty","","",357,{"inputs":[{"name":"self"},{"name":"ty"}],"output":null}],[11,"super_region","","",357,{"inputs":[{"name":"self"},{"name":"region"}],"output":null}],[11,"super_const","","",357,{"inputs":[{"name":"self"},{"name":"const"}],"output":null}],[11,"super_substs","","",357,{"inputs":[{"name":"self"},{"name":"substs"}],"output":null}],[11,"super_generator_interior","","",357,{"inputs":[{"name":"self"},{"name":"generatorinterior"}],"output":null}],[11,"super_closure_substs","","",357,{"inputs":[{"name":"self"},{"name":"closuresubsts"}],"output":null}],[11,"visit_location","","",357,{"inputs":[{"name":"self"},{"name":"mir"},{"name":"location"}],"output":null}],[8,"MutVisitor","","",null,null],[11,"visit_mir","","",358,{"inputs":[{"name":"self"},{"name":"mir"}],"output":null}],[11,"visit_basic_block_data","","",358,{"inputs":[{"name":"self"},{"name":"basicblock"},{"name":"basicblockdata"}],"output":null}],[11,"visit_visibility_scope_data","","",358,{"inputs":[{"name":"self"},{"name":"visibilityscopedata"}],"output":null}],[11,"visit_statement","","",358,{"inputs":[{"name":"self"},{"name":"basicblock"},{"name":"statement"},{"name":"location"}],"output":null}],[11,"visit_assign","","",358,{"inputs":[{"name":"self"},{"name":"basicblock"},{"name":"place"},{"name":"rvalue"},{"name":"location"}],"output":null}],[11,"visit_terminator","","",358,{"inputs":[{"name":"self"},{"name":"basicblock"},{"name":"terminator"},{"name":"location"}],"output":null}],[11,"visit_terminator_kind","","",358,{"inputs":[{"name":"self"},{"name":"basicblock"},{"name":"terminatorkind"},{"name":"location"}],"output":null}],[11,"visit_assert_message","","",358,{"inputs":[{"name":"self"},{"name":"assertmessage"},{"name":"location"}],"output":null}],[11,"visit_rvalue","","",358,{"inputs":[{"name":"self"},{"name":"rvalue"},{"name":"location"}],"output":null}],[11,"visit_operand","","",358,{"inputs":[{"name":"self"},{"name":"operand"},{"name":"location"}],"output":null}],[11,"visit_user_assert_ty","","",358,{"inputs":[{"name":"self"},{"name":"canonicalty"},{"name":"local"},{"name":"location"}],"output":null}],[11,"visit_place","","",358,{"inputs":[{"name":"self"},{"name":"place"},{"name":"placecontext"},{"name":"location"}],"output":null}],[11,"visit_static","","",358,{"inputs":[{"name":"self"},{"name":"static"},{"name":"placecontext"},{"name":"location"}],"output":null}],[11,"visit_projection","","",358,{"inputs":[{"name":"self"},{"name":"placeprojection"},{"name":"placecontext"},{"name":"location"}],"output":null}],[11,"visit_projection_elem","","",358,{"inputs":[{"name":"self"},{"name":"placeelem"},{"name":"placecontext"},{"name":"location"}],"output":null}],[11,"visit_branch","","",358,{"inputs":[{"name":"self"},{"name":"basicblock"},{"name":"basicblock"}],"output":null}],[11,"visit_constant","","",358,{"inputs":[{"name":"self"},{"name":"constant"},{"name":"location"}],"output":null}],[11,"visit_literal","","",358,{"inputs":[{"name":"self"},{"name":"literal"},{"name":"location"}],"output":null}],[11,"visit_def_id","","",358,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"location"}],"output":null}],[11,"visit_span","","",358,{"inputs":[{"name":"self"},{"name":"span"}],"output":null}],[11,"visit_source_info","","",358,{"inputs":[{"name":"self"},{"name":"sourceinfo"}],"output":null}],[11,"visit_ty","","",358,{"inputs":[{"name":"self"},{"name":"ty"},{"name":"tycontext"}],"output":null}],[11,"visit_region","","",358,{"inputs":[{"name":"self"},{"name":"region"},{"name":"location"}],"output":null}],[11,"visit_const","","",358,{"inputs":[{"name":"self"},{"name":"const"},{"name":"location"}],"output":null}],[11,"visit_substs","","",358,{"inputs":[{"name":"self"},{"name":"substs"},{"name":"location"}],"output":null}],[11,"visit_closure_substs","","",358,{"inputs":[{"name":"self"},{"name":"closuresubsts"},{"name":"location"}],"output":null}],[11,"visit_generator_interior","","",358,{"inputs":[{"name":"self"},{"name":"generatorinterior"},{"name":"location"}],"output":null}],[11,"visit_local_decl","","",358,{"inputs":[{"name":"self"},{"name":"local"},{"name":"localdecl"}],"output":null}],[11,"visit_local","","",358,{"inputs":[{"name":"self"},{"name":"local"},{"name":"placecontext"},{"name":"location"}],"output":null}],[11,"visit_visibility_scope","","",358,{"inputs":[{"name":"self"},{"name":"visibilityscope"}],"output":null}],[11,"super_mir","","",358,{"inputs":[{"name":"self"},{"name":"mir"}],"output":null}],[11,"super_basic_block_data","","",358,{"inputs":[{"name":"self"},{"name":"basicblock"},{"name":"basicblockdata"}],"output":null}],[11,"super_visibility_scope_data","","",358,{"inputs":[{"name":"self"},{"name":"visibilityscopedata"}],"output":null}],[11,"super_statement","","",358,{"inputs":[{"name":"self"},{"name":"basicblock"},{"name":"statement"},{"name":"location"}],"output":null}],[11,"super_assign","","",358,{"inputs":[{"name":"self"},{"name":"basicblock"},{"name":"place"},{"name":"rvalue"},{"name":"location"}],"output":null}],[11,"super_terminator","","",358,{"inputs":[{"name":"self"},{"name":"basicblock"},{"name":"terminator"},{"name":"location"}],"output":null}],[11,"super_terminator_kind","","",358,{"inputs":[{"name":"self"},{"name":"basicblock"},{"name":"terminatorkind"},{"name":"location"}],"output":null}],[11,"super_assert_message","","",358,{"inputs":[{"name":"self"},{"name":"assertmessage"},{"name":"location"}],"output":null}],[11,"super_rvalue","","",358,{"inputs":[{"name":"self"},{"name":"rvalue"},{"name":"location"}],"output":null}],[11,"super_operand","","",358,{"inputs":[{"name":"self"},{"name":"operand"},{"name":"location"}],"output":null}],[11,"super_user_assert_ty","","",358,{"inputs":[{"name":"self"},{"name":"canonicalty"},{"name":"local"},{"name":"location"}],"output":null}],[11,"super_place","","",358,{"inputs":[{"name":"self"},{"name":"place"},{"name":"placecontext"},{"name":"location"}],"output":null}],[11,"super_static","","",358,{"inputs":[{"name":"self"},{"name":"static"},{"name":"placecontext"},{"name":"location"}],"output":null}],[11,"super_projection","","",358,{"inputs":[{"name":"self"},{"name":"placeprojection"},{"name":"placecontext"},{"name":"location"}],"output":null}],[11,"super_projection_elem","","",358,{"inputs":[{"name":"self"},{"name":"placeelem"},{"name":"placecontext"},{"name":"location"}],"output":null}],[11,"super_local_decl","","",358,{"inputs":[{"name":"self"},{"name":"local"},{"name":"localdecl"}],"output":null}],[11,"super_visibility_scope","","",358,{"inputs":[{"name":"self"},{"name":"visibilityscope"}],"output":null}],[11,"super_branch","","",358,{"inputs":[{"name":"self"},{"name":"basicblock"},{"name":"basicblock"}],"output":null}],[11,"super_constant","","",358,{"inputs":[{"name":"self"},{"name":"constant"},{"name":"location"}],"output":null}],[11,"super_literal","","",358,{"inputs":[{"name":"self"},{"name":"literal"},{"name":"location"}],"output":null}],[11,"super_def_id","","",358,{"inputs":[{"name":"self"},{"name":"defid"}],"output":null}],[11,"super_span","","",358,{"inputs":[{"name":"self"},{"name":"span"}],"output":null}],[11,"super_source_info","","",358,{"inputs":[{"name":"self"},{"name":"sourceinfo"}],"output":null}],[11,"super_ty","","",358,{"inputs":[{"name":"self"},{"name":"ty"}],"output":null}],[11,"super_region","","",358,{"inputs":[{"name":"self"},{"name":"region"}],"output":null}],[11,"super_const","","",358,{"inputs":[{"name":"self"},{"name":"const"}],"output":null}],[11,"super_substs","","",358,{"inputs":[{"name":"self"},{"name":"substs"}],"output":null}],[11,"super_generator_interior","","",358,{"inputs":[{"name":"self"},{"name":"generatorinterior"}],"output":null}],[11,"super_closure_substs","","",358,{"inputs":[{"name":"self"},{"name":"closuresubsts"}],"output":null}],[11,"visit_location","","",358,{"inputs":[{"name":"self"},{"name":"mir"},{"name":"location"}],"output":null}],[8,"MirVisitable","","",null,null],[10,"apply","","",359,{"inputs":[{"name":"self"},{"name":"location"},{"name":"visitor"}],"output":null}],[11,"apply","rustc::mir","",320,{"inputs":[{"name":"self"},{"name":"location"},{"name":"visitor"}],"output":null}],[11,"apply","","",319,{"inputs":[{"name":"self"},{"name":"location"},{"name":"visitor"}],"output":null}],[11,"clone","rustc::mir::visit","",355,{"inputs":[{"name":"self"}],"output":{"name":"tycontext"}}],[11,"fmt","","",355,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",355,{"inputs":[{"name":"self"},{"name":"tycontext"}],"output":{"name":"bool"}}],[11,"ne","","",355,{"inputs":[{"name":"self"},{"name":"tycontext"}],"output":{"name":"bool"}}],[11,"hash","","",355,null],[11,"clone","","",356,{"inputs":[{"name":"self"}],"output":{"name":"placecontext"}}],[11,"fmt","","",356,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",356,{"inputs":[{"name":"self"},{"name":"placecontext"}],"output":{"name":"bool"}}],[11,"ne","","",356,{"inputs":[{"name":"self"},{"name":"placecontext"}],"output":{"name":"bool"}}],[11,"is_drop","","Returns true if this place context represents a drop.",356,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_storage_marker","","Returns true if this place context represents a storage live or storage dead marker.",356,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_storage_live_marker","","Returns true if this place context represents a storage live marker.",356,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_storage_dead_marker","","Returns true if this place context represents a storage dead marker.",356,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_mutating_use","","Returns true if this place context represents a use that potentially changes the value.",356,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_nonmutating_use","","Returns true if this place context represents a use that does not change the value.",356,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_use","","",356,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[0,"traversal","rustc::mir","",null,null],[3,"Preorder","rustc::mir::traversal","Preorder traversal of a graph.",null,null],[3,"Postorder","","Postorder traversal of a graph.",null,null],[3,"ReversePostorder","","Reverse postorder traversal of a graph",null,null],[5,"preorder","","",null,{"inputs":[{"name":"mir"}],"output":{"name":"preorder"}}],[5,"postorder","","",null,{"inputs":[{"name":"mir"}],"output":{"name":"postorder"}}],[5,"reverse_postorder","","",null,{"inputs":[{"name":"mir"}],"output":{"name":"reversepostorder"}}],[11,"clone","","",360,{"inputs":[{"name":"self"}],"output":{"name":"preorder"}}],[11,"new","","",360,{"inputs":[{"name":"mir"},{"name":"basicblock"}],"output":{"name":"preorder"}}],[11,"next","","",360,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",360,null],[11,"new","","",361,{"inputs":[{"name":"mir"},{"name":"basicblock"}],"output":{"name":"postorder"}}],[11,"next","","",361,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",361,null],[11,"clone","","",362,{"inputs":[{"name":"self"}],"output":{"name":"reversepostorder"}}],[11,"new","","",362,{"inputs":[{"name":"mir"},{"name":"basicblock"}],"output":{"name":"reversepostorder"}}],[11,"reset","","",362,{"inputs":[{"name":"self"}],"output":null}],[11,"next","","",362,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",362,null],[0,"interpret","rustc::mir","An interpreter for MIR used in CTFE and by miri",null,null],[3,"EvalError","rustc::mir::interpret","",null,null],[12,"kind","","",363,null],[12,"backtrace","","",363,null],[3,"Pointer","","A wrapper type around `PrimVal` that cannot be turned back into a `PrimVal` accidentally. This type clears up a few APIs where having a `PrimVal` argument for something that is potentially an integer pointer or a pointer to an allocation was unclear.",null,null],[12,"primval","","",364,null],[3,"DynamicLifetime","","",null,null],[12,"frame","","",365,null],[12,"region","","",365,null],[3,"GlobalId","","Uniquely identifies a specific constant or static.",null,null],[12,"instance","","For a constant or static, the `Instance` of the item itself. For a promoted global, the `Instance` of the function they belong to.",366,null],[12,"promoted","","The index for promoted globals within their function's `Mir`.",366,null],[3,"MemoryPointer","","",null,null],[12,"alloc_id","","",367,null],[12,"offset","","",367,null],[3,"AllocId","","",null,null],[12,"0","","",368,null],[3,"Allocation","","",null,null],[12,"bytes","","The actual bytes of the allocation. Note that the bytes of a pointer represent the offset of the pointer",369,null],[12,"relocations","","Maps from byte addresses to allocations. Only the first byte of a pointer is inserted into the map.",369,null],[12,"undef_mask","","Denotes undefined memory. Reading from undefined memory is forbidden in miri",369,null],[12,"align","","The alignment of the allocation to detect unaligned reads.",369,null],[12,"runtime_mutability","","Whether the allocation (of a static) should be put into mutable memory when translating",369,null],[3,"UndefMask","","",null,null],[4,"EvalErrorKind","","",null,null],[13,"MachineError","","This variant is used by machines to signal their own errors that do not match an existing variant",370,null],[13,"FunctionPointerTyMismatch","","",370,null],[13,"NoMirFor","","",370,null],[13,"UnterminatedCString","","",370,null],[13,"DanglingPointerDeref","","",370,null],[13,"DoubleFree","","",370,null],[13,"InvalidMemoryAccess","","",370,null],[13,"InvalidFunctionPointer","","",370,null],[13,"InvalidBool","","",370,null],[13,"InvalidDiscriminant","","",370,null],[13,"PointerOutOfBounds","","",370,null],[12,"ptr","rustc::mir::interpret::EvalErrorKind","",370,null],[12,"access","","",370,null],[12,"allocation_size","","",370,null],[13,"InvalidNullPointerUsage","rustc::mir::interpret","",370,null],[13,"ReadPointerAsBytes","","",370,null],[13,"ReadBytesAsPointer","","",370,null],[13,"InvalidPointerMath","","",370,null],[13,"ReadUndefBytes","","",370,null],[13,"DeadLocal","","",370,null],[13,"InvalidBoolOp","","",370,null],[13,"Unimplemented","","",370,null],[13,"DerefFunctionPointer","","",370,null],[13,"ExecuteMemory","","",370,null],[13,"ArrayIndexOutOfBounds","","",370,null],[13,"Math","","",370,null],[13,"Intrinsic","","",370,null],[13,"OverflowingMath","","",370,null],[13,"InvalidChar","","",370,null],[13,"StackFrameLimitReached","","",370,null],[13,"OutOfTls","","",370,null],[13,"TlsOutOfBounds","","",370,null],[13,"AbiViolation","","",370,null],[13,"AlignmentCheckFailed","","",370,null],[12,"required","rustc::mir::interpret::EvalErrorKind","",370,null],[12,"has","","",370,null],[13,"MemoryLockViolation","rustc::mir::interpret","",370,null],[12,"ptr","rustc::mir::interpret::EvalErrorKind","",370,null],[12,"len","","",370,null],[12,"frame","","",370,null],[12,"access","","",370,null],[12,"lock","","",370,null],[13,"MemoryAcquireConflict","rustc::mir::interpret","",370,null],[12,"ptr","rustc::mir::interpret::EvalErrorKind","",370,null],[12,"len","","",370,null],[12,"kind","","",370,null],[12,"lock","","",370,null],[13,"InvalidMemoryLockRelease","rustc::mir::interpret","",370,null],[12,"ptr","rustc::mir::interpret::EvalErrorKind","",370,null],[12,"len","","",370,null],[12,"frame","","",370,null],[12,"lock","","",370,null],[13,"DeallocatedLockedMemory","rustc::mir::interpret","",370,null],[12,"ptr","rustc::mir::interpret::EvalErrorKind","",370,null],[12,"lock","","",370,null],[13,"ValidationFailure","rustc::mir::interpret","",370,null],[13,"CalledClosureAsFunction","","",370,null],[13,"VtableForArgumentlessMethod","","",370,null],[13,"ModifiedConstantMemory","","",370,null],[13,"AssumptionNotHeld","","",370,null],[13,"InlineAsm","","",370,null],[13,"TypeNotPrimitive","","",370,null],[13,"ReallocatedWrongMemoryKind","","",370,null],[13,"DeallocatedWrongMemoryKind","","",370,null],[13,"ReallocateNonBasePtr","","",370,null],[13,"DeallocateNonBasePtr","","",370,null],[13,"IncorrectAllocationInformation","","",370,null],[13,"Layout","","",370,null],[13,"HeapAllocZeroBytes","","",370,null],[13,"HeapAllocNonPowerOfTwoAlignment","","",370,null],[13,"Unreachable","","",370,null],[13,"Panic","","",370,null],[13,"ReadFromReturnPointer","","",370,null],[13,"PathNotFound","","",370,null],[13,"UnimplementedTraitSelection","","",370,null],[13,"TypeckError","","Abort in case type errors are reached",370,null],[13,"ReferencedConstant","","Cannot compute this constant because it depends on another one which already produced an error",370,null],[4,"PrimVal","","A `PrimVal` represents an immediate, primitive value existing outside of a `memory::Allocation`. It is in many ways like a small chunk of a `Allocation`, up to 8 bytes in size. Like a range of bytes in an `Allocation`, a `PrimVal` can either represent the raw bytes of a simple value, a pointer into another `Allocation`, or be undefined.",null,null],[13,"Bytes","","The raw bytes of a simple value.",371,null],[13,"Ptr","","A pointer into an `Allocation`. An `Allocation` in the `memory` module has a list of relocations, but a `PrimVal` is only large enough to contain one, so we just represent the relocation and its associated offset together as a `MemoryPointer` here.",371,null],[13,"Undef","","An undefined `PrimVal`, for representing values that aren't safe to examine, but are safe to copy around, just like undefined bytes in an `Allocation`.",371,null],[4,"PrimValKind","","",null,null],[13,"I8","","",372,null],[13,"I16","","",372,null],[13,"I32","","",372,null],[13,"I64","","",372,null],[13,"I128","","",372,null],[13,"U8","","",372,null],[13,"U16","","",372,null],[13,"U32","","",372,null],[13,"U64","","",372,null],[13,"U128","","",372,null],[13,"F32","","",372,null],[13,"F64","","",372,null],[13,"Ptr","","",372,null],[13,"FnPtr","","",372,null],[13,"Bool","","",372,null],[13,"Char","","",372,null],[4,"Value","","A `Value` represents a single self-contained Rust value.",null,null],[13,"ByRef","","",373,null],[13,"ByVal","","",373,null],[13,"ByValPair","","",373,null],[4,"Lock","","",null,null],[13,"NoLock","","",374,null],[13,"WriteLock","","",374,null],[13,"ReadLock","","This should never be empty -- that would be a read lock held and nobody there to release it...",374,null],[4,"AccessKind","","",null,null],[13,"Read","","",375,null],[13,"Write","","",375,null],[5,"specialized_encode_alloc_id","","",null,{"inputs":[{"name":"e"},{"name":"tyctxt"},{"name":"allocid"}],"output":{"name":"result"}}],[5,"specialized_decode_alloc_id","","",null,{"inputs":[{"name":"d"},{"name":"tyctxt"},{"name":"cache"}],"output":{"generics":["allocid"],"name":"result"}}],[11,"fmt","","",363,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",363,{"inputs":[{"name":"self"}],"output":{"name":"evalerror"}}],[11,"from","","",363,{"inputs":[{"name":"evalerrorkind"}],"output":{"name":"self"}}],[11,"fmt","","",370,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",370,{"inputs":[{"name":"self"}],"output":{"name":"evalerrorkind"}}],[11,"description","","",363,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"fmt","","",363,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",373,{"inputs":[{"name":"self"}],"output":{"name":"value"}}],[11,"fmt","","",373,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",373,{"inputs":[{"name":"self"},{"name":"value"}],"output":{"name":"bool"}}],[11,"ne","","",373,{"inputs":[{"name":"self"},{"name":"value"}],"output":{"name":"bool"}}],[11,"encode","","",373,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",373,{"inputs":[{"name":"__d"}],"output":{"generics":["value"],"name":"result"}}],[11,"hash","","",373,null],[11,"super_fold_with","","",373,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"self"}}],[11,"super_visit_with","","",373,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"clone","","",364,{"inputs":[{"name":"self"}],"output":{"name":"pointer"}}],[11,"fmt","","",364,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",364,{"inputs":[{"name":"self"},{"name":"pointer"}],"output":{"name":"bool"}}],[11,"ne","","",364,{"inputs":[{"name":"self"},{"name":"pointer"}],"output":{"name":"bool"}}],[11,"encode","","",364,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",364,{"inputs":[{"name":"__d"}],"output":{"generics":["pointer"],"name":"result"}}],[11,"hash","","",364,null],[11,"null","","",364,{"inputs":[],"output":{"name":"self"}}],[11,"to_ptr","","",364,{"inputs":[{"name":"self"}],"output":{"generics":["memorypointer"],"name":"evalresult"}}],[11,"into_inner_primval","","",364,{"inputs":[{"name":"self"}],"output":{"name":"primval"}}],[11,"signed_offset","","",364,{"inputs":[{"name":"self"},{"name":"i64"},{"name":"c"}],"output":{"name":"evalresult"}}],[11,"offset","","",364,{"inputs":[{"name":"self"},{"name":"u64"},{"name":"c"}],"output":{"name":"evalresult"}}],[11,"wrapping_signed_offset","","",364,{"inputs":[{"name":"self"},{"name":"i64"},{"name":"c"}],"output":{"name":"evalresult"}}],[11,"is_null","","",364,{"inputs":[{"name":"self"}],"output":{"generics":["bool"],"name":"evalresult"}}],[11,"to_value_with_len","","",364,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"value"}}],[11,"to_value_with_vtable","","",364,{"inputs":[{"name":"self"},{"name":"memorypointer"}],"output":{"name":"value"}}],[11,"to_value","","",364,{"inputs":[{"name":"self"}],"output":{"name":"value"}}],[11,"from","","",364,{"inputs":[{"name":"primval"}],"output":{"name":"self"}}],[11,"from","","",364,{"inputs":[{"name":"memorypointer"}],"output":{"name":"self"}}],[11,"clone","","",371,{"inputs":[{"name":"self"}],"output":{"name":"primval"}}],[11,"fmt","","",371,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",371,{"inputs":[{"name":"self"},{"name":"primval"}],"output":{"name":"bool"}}],[11,"ne","","",371,{"inputs":[{"name":"self"},{"name":"primval"}],"output":{"name":"bool"}}],[11,"encode","","",371,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",371,{"inputs":[{"name":"__d"}],"output":{"generics":["primval"],"name":"result"}}],[11,"hash","","",371,null],[11,"clone","","",372,{"inputs":[{"name":"self"}],"output":{"name":"primvalkind"}}],[11,"fmt","","",372,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",372,{"inputs":[{"name":"self"},{"name":"primvalkind"}],"output":{"name":"bool"}}],[11,"from_u128","","",371,{"inputs":[{"name":"u128"}],"output":{"name":"self"}}],[11,"from_i128","","",371,{"inputs":[{"name":"i128"}],"output":{"name":"self"}}],[11,"from_bool","","",371,{"inputs":[{"name":"bool"}],"output":{"name":"self"}}],[11,"from_char","","",371,{"inputs":[{"name":"char"}],"output":{"name":"self"}}],[11,"to_bytes","","",371,{"inputs":[{"name":"self"}],"output":{"generics":["u128"],"name":"evalresult"}}],[11,"to_ptr","","",371,{"inputs":[{"name":"self"}],"output":{"generics":["memorypointer"],"name":"evalresult"}}],[11,"is_bytes","","",371,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_ptr","","",371,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_undef","","",371,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"to_u128","","",371,{"inputs":[{"name":"self"}],"output":{"generics":["u128"],"name":"evalresult"}}],[11,"to_u64","","",371,{"inputs":[{"name":"self"}],"output":{"generics":["u64"],"name":"evalresult"}}],[11,"to_i32","","",371,{"inputs":[{"name":"self"}],"output":{"generics":["i32"],"name":"evalresult"}}],[11,"to_i128","","",371,{"inputs":[{"name":"self"}],"output":{"generics":["i128"],"name":"evalresult"}}],[11,"to_i64","","",371,{"inputs":[{"name":"self"}],"output":{"generics":["i64"],"name":"evalresult"}}],[11,"to_bool","","",371,{"inputs":[{"name":"self"}],"output":{"generics":["bool"],"name":"evalresult"}}],[11,"is_int","","",372,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_signed_int","","",372,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_float","","",372,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"from_uint_size","","",372,{"inputs":[{"name":"u64"}],"output":{"name":"self"}}],[11,"from_int_size","","",372,{"inputs":[{"name":"u64"}],"output":{"name":"self"}}],[11,"is_ptr","","",372,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[6,"EvalResult","","",null,null],[8,"PointerArithmetic","","",null,null],[11,"truncate_to_ptr","","",376,null],[11,"overflowing_signed_offset","","",376,null],[11,"overflowing_offset","","",376,null],[11,"signed_offset","","",376,{"inputs":[{"name":"self"},{"name":"u64"},{"name":"i64"}],"output":{"generics":["u64"],"name":"evalresult"}}],[11,"offset","","",376,{"inputs":[{"name":"self"},{"name":"u64"},{"name":"u64"}],"output":{"generics":["u64"],"name":"evalresult"}}],[11,"wrapping_signed_offset","","",376,{"inputs":[{"name":"self"},{"name":"u64"},{"name":"i64"}],"output":{"name":"u64"}}],[11,"clone","","",374,{"inputs":[{"name":"self"}],"output":{"name":"lock"}}],[11,"fmt","","",374,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",374,{"inputs":[{"name":"self"},{"name":"lock"}],"output":{"name":"bool"}}],[11,"ne","","",374,{"inputs":[{"name":"self"},{"name":"lock"}],"output":{"name":"bool"}}],[11,"clone","","",365,{"inputs":[{"name":"self"}],"output":{"name":"dynamiclifetime"}}],[11,"fmt","","",365,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",365,{"inputs":[{"name":"self"},{"name":"dynamiclifetime"}],"output":{"name":"bool"}}],[11,"ne","","",365,{"inputs":[{"name":"self"},{"name":"dynamiclifetime"}],"output":{"name":"bool"}}],[11,"hash","","",365,null],[11,"clone","","",375,{"inputs":[{"name":"self"}],"output":{"name":"accesskind"}}],[11,"fmt","","",375,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",375,{"inputs":[{"name":"self"},{"name":"accesskind"}],"output":{"name":"bool"}}],[11,"clone","","",366,{"inputs":[{"name":"self"}],"output":{"name":"globalid"}}],[11,"fmt","","",366,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",366,{"inputs":[{"name":"self"},{"name":"globalid"}],"output":{"name":"bool"}}],[11,"ne","","",366,{"inputs":[{"name":"self"},{"name":"globalid"}],"output":{"name":"bool"}}],[11,"hash","","",366,null],[11,"encode","","",366,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",366,{"inputs":[{"name":"__d"}],"output":{"generics":["globalid"],"name":"result"}}],[11,"clone","","",367,{"inputs":[{"name":"self"}],"output":{"name":"memorypointer"}}],[11,"fmt","","",367,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",367,{"inputs":[{"name":"self"},{"name":"memorypointer"}],"output":{"name":"bool"}}],[11,"ne","","",367,{"inputs":[{"name":"self"},{"name":"memorypointer"}],"output":{"name":"bool"}}],[11,"encode","","",367,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",367,{"inputs":[{"name":"__d"}],"output":{"generics":["memorypointer"],"name":"result"}}],[11,"hash","","",367,null],[11,"new","","",367,{"inputs":[{"name":"allocid"},{"name":"u64"}],"output":{"name":"self"}}],[11,"overflowing_signed_offset","","",367,null],[11,"overflowing_offset","","",367,null],[11,"offset","","",367,{"inputs":[{"name":"self"},{"name":"u64"},{"name":"c"}],"output":{"name":"evalresult"}}],[11,"clone","","",368,{"inputs":[{"name":"self"}],"output":{"name":"allocid"}}],[11,"default","","",368,{"inputs":[],"output":{"name":"allocid"}}],[11,"hash","","",368,null],[11,"cmp","","",368,{"inputs":[{"name":"self"},{"name":"allocid"}],"output":{"name":"ordering"}}],[11,"eq","","",368,{"inputs":[{"name":"self"},{"name":"allocid"}],"output":{"name":"bool"}}],[11,"ne","","",368,{"inputs":[{"name":"self"},{"name":"allocid"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",368,{"inputs":[{"name":"self"},{"name":"allocid"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",368,{"inputs":[{"name":"self"},{"name":"allocid"}],"output":{"name":"bool"}}],[11,"le","","",368,{"inputs":[{"name":"self"},{"name":"allocid"}],"output":{"name":"bool"}}],[11,"gt","","",368,{"inputs":[{"name":"self"},{"name":"allocid"}],"output":{"name":"bool"}}],[11,"ge","","",368,{"inputs":[{"name":"self"},{"name":"allocid"}],"output":{"name":"bool"}}],[11,"fmt","","",368,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",368,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",369,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",369,{"inputs":[{"name":"self"},{"name":"allocation"}],"output":{"name":"bool"}}],[11,"ne","","",369,{"inputs":[{"name":"self"},{"name":"allocation"}],"output":{"name":"bool"}}],[11,"hash","","",369,null],[11,"encode","","",369,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",369,{"inputs":[{"name":"__d"}],"output":{"generics":["allocation"],"name":"result"}}],[11,"from_bytes","","",369,null],[11,"clone","","",377,{"inputs":[{"name":"self"}],"output":{"name":"undefmask"}}],[11,"fmt","","",377,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",377,{"inputs":[{"name":"self"},{"name":"undefmask"}],"output":{"name":"bool"}}],[11,"ne","","",377,{"inputs":[{"name":"self"},{"name":"undefmask"}],"output":{"name":"bool"}}],[11,"hash","","",377,null],[11,"encode","","",377,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",377,{"inputs":[{"name":"__d"}],"output":{"generics":["undefmask"],"name":"result"}}],[11,"hash_stable","","",377,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"new","","",377,{"inputs":[{"name":"u64"}],"output":{"name":"self"}}],[11,"is_range_defined","","Check whether the range `start..end` (end-exclusive) is entirely defined.",377,{"inputs":[{"name":"self"},{"name":"u64"},{"name":"u64"}],"output":{"name":"bool"}}],[11,"set_range","","",377,{"inputs":[{"name":"self"},{"name":"u64"},{"name":"u64"},{"name":"bool"}],"output":null}],[11,"set_range_inbounds","","",377,{"inputs":[{"name":"self"},{"name":"u64"},{"name":"u64"},{"name":"bool"}],"output":null}],[11,"get","","",377,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"bool"}}],[11,"set","","",377,{"inputs":[{"name":"self"},{"name":"u64"},{"name":"bool"}],"output":null}],[11,"grow","","",377,{"inputs":[{"name":"self"},{"name":"u64"},{"name":"bool"}],"output":null}],[0,"mono","rustc::mir","",null,null],[3,"CodegenUnit","rustc::mir::mono","",null,null],[3,"Stats","","",null,null],[12,"n_glues_created","","",378,null],[12,"n_null_glues","","",378,null],[12,"n_real_glues","","",378,null],[12,"n_fns","","",378,null],[12,"n_inlines","","",378,null],[12,"n_closures","","",378,null],[12,"n_llvm_insns","","",378,null],[12,"llvm_insns","","",378,null],[12,"fn_stats","","",378,null],[4,"MonoItem","","",null,null],[13,"Fn","","",379,null],[13,"Static","","",379,null],[13,"GlobalAsm","","",379,null],[4,"Linkage","","",null,null],[13,"External","","",380,null],[13,"AvailableExternally","","",380,null],[13,"LinkOnceAny","","",380,null],[13,"LinkOnceODR","","",380,null],[13,"WeakAny","","",380,null],[13,"WeakODR","","",380,null],[13,"Appending","","",380,null],[13,"Internal","","",380,null],[13,"Private","","",380,null],[13,"ExternalWeak","","",380,null],[13,"Common","","",380,null],[4,"Visibility","","",null,null],[13,"Default","","",381,null],[13,"Hidden","","",381,null],[13,"Protected","","",381,null],[11,"eq","","",379,{"inputs":[{"name":"self"},{"name":"monoitem"}],"output":{"name":"bool"}}],[11,"ne","","",379,{"inputs":[{"name":"self"},{"name":"monoitem"}],"output":{"name":"bool"}}],[11,"clone","","",379,{"inputs":[{"name":"self"}],"output":{"name":"monoitem"}}],[11,"fmt","","",379,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",379,null],[11,"size_estimate","","",379,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"usize"}}],[11,"hash_stable","","",379,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"clone","","",380,{"inputs":[{"name":"self"}],"output":{"name":"linkage"}}],[11,"eq","","",380,{"inputs":[{"name":"self"},{"name":"linkage"}],"output":{"name":"bool"}}],[11,"hash","","",380,null],[11,"fmt","","",380,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",380,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",380,{"inputs":[{"name":"__d"}],"output":{"generics":["linkage"],"name":"result"}}],[11,"hash_stable","","",380,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"clone","","",381,{"inputs":[{"name":"self"}],"output":{"name":"visibility"}}],[11,"eq","","",381,{"inputs":[{"name":"self"},{"name":"visibility"}],"output":{"name":"bool"}}],[11,"hash","","",381,null],[11,"fmt","","",381,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash_stable","","",381,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"new","","",382,{"inputs":[{"name":"internedstring"}],"output":{"name":"codegenunit"}}],[11,"name","","",382,{"inputs":[{"name":"self"}],"output":{"name":"internedstring"}}],[11,"set_name","","",382,{"inputs":[{"name":"self"},{"name":"internedstring"}],"output":null}],[11,"items","","",382,{"inputs":[{"name":"self"}],"output":{"name":"fxhashmap"}}],[11,"items_mut","","",382,{"inputs":[{"name":"self"}],"output":{"name":"fxhashmap"}}],[11,"mangle_name","","",382,{"inputs":[{"name":"str"}],"output":{"name":"string"}}],[11,"estimate_size","","",382,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":null}],[11,"size_estimate","","",382,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"modify_size_estimate","","",382,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"hash_stable","","",382,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"clone","","",378,{"inputs":[{"name":"self"}],"output":{"name":"stats"}}],[11,"default","","",378,{"inputs":[],"output":{"name":"stats"}}],[11,"hash_stable","","",378,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"extend","","",378,{"inputs":[{"name":"self"},{"name":"stats"}],"output":null}],[6,"PlaceProjection","rustc::mir","Alias for projections as they appear in places, where the base is a place and the index is a local.",null,null],[6,"PlaceElem","","Alias for projections as they appear in places, where the base is a place and the index is a local.",null,null],[17,"START_BLOCK","","where execution begins",null,null],[17,"RETURN_PLACE","","",null,null],[17,"ARGUMENT_VISIBILITY_SCOPE","","",null,null],[8,"HasLocalDecls","","",null,null],[10,"local_decls","","",383,{"inputs":[{"name":"self"}],"output":{"name":"indexvec"}}],[11,"local_decls","","",313,{"inputs":[{"name":"self"}],"output":{"name":"indexvec"}}],[11,"clone","","",313,{"inputs":[{"name":"self"}],"output":{"name":"mir"}}],[11,"encode","","",313,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",313,{"inputs":[{"name":"__d"}],"output":{"generics":["mir"],"name":"result"}}],[11,"fmt","","",313,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","",313,{"inputs":[{"generics":["basicblock","basicblockdata"],"name":"indexvec"},{"generics":["visibilityscope","visibilityscopedata"],"name":"indexvec"},{"generics":["indexvec"],"name":"clearcrosscrate"},{"generics":["promoted","mir"],"name":"indexvec"},{"generics":["ty"],"name":"option"},{"generics":["local","localdecl"],"name":"indexvec"},{"name":"usize"},{"generics":["upvardecl"],"name":"vec"},{"name":"span"}],"output":{"name":"self"}}],[11,"basic_blocks","","",313,{"inputs":[{"name":"self"}],"output":{"name":"indexvec"}}],[11,"basic_blocks_mut","","",313,{"inputs":[{"name":"self"}],"output":{"name":"indexvec"}}],[11,"basic_blocks_and_local_decls_mut","","",313,null],[11,"predecessors","","",313,{"inputs":[{"name":"self"}],"output":{"generics":["indexvec"],"name":"ref"}}],[11,"predecessors_for","","",313,{"inputs":[{"name":"self"},{"name":"basicblock"}],"output":{"generics":["vec"],"name":"ref"}}],[11,"dominators","","",313,{"inputs":[{"name":"self"}],"output":{"generics":["basicblock"],"name":"dominators"}}],[11,"local_kind","","",313,{"inputs":[{"name":"self"},{"name":"local"}],"output":{"name":"localkind"}}],[11,"temps_iter","","Returns an iterator over all temporaries.",313,null],[11,"vars_iter","","Returns an iterator over all user-declared locals.",313,null],[11,"args_iter","","Returns an iterator over all function arguments.",313,null],[11,"vars_and_temps_iter","","Returns an iterator over all user-defined variables and compiler-generated temporaries (all locals that are neither arguments nor the return place).",313,null],[11,"make_statement_nop","","Changes a statement to a nop. This is both faster than deleting instructions and avoids invalidating statement indices in `Location`s.",313,{"inputs":[{"name":"self"},{"name":"location"}],"output":null}],[11,"source_info","","Returns the source info associated with `location`.",313,{"inputs":[{"name":"self"},{"name":"location"}],"output":{"name":"sourceinfo"}}],[11,"return_ty","","Return the return type, it always return first element from `local_decls` array",313,{"inputs":[{"name":"self"}],"output":{"name":"ty"}}],[11,"clone","","",314,{"inputs":[{"name":"self"}],"output":{"name":"visibilityscopeinfo"}}],[11,"fmt","","",314,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",314,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",314,{"inputs":[{"name":"__d"}],"output":{"generics":["visibilityscopeinfo"],"name":"result"}}],[11,"clone","","",332,{"inputs":[{"name":"self"}],"output":{"name":"safety"}}],[11,"fmt","","",332,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",332,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",332,{"inputs":[{"name":"__d"}],"output":{"generics":["safety"],"name":"result"}}],[11,"hash_stable","","",313,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"index","","",313,{"inputs":[{"name":"self"},{"name":"basicblock"}],"output":{"name":"basicblockdata"}}],[11,"index_mut","","",313,{"inputs":[{"name":"self"},{"name":"basicblock"}],"output":{"name":"basicblockdata"}}],[11,"clone","","",333,{"inputs":[{"name":"self"}],"output":{"name":"clearcrosscrate"}}],[11,"fmt","","",333,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",315,{"inputs":[{"name":"self"}],"output":{"name":"sourceinfo"}}],[11,"fmt","","",315,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",315,{"inputs":[{"name":"self"},{"name":"sourceinfo"}],"output":{"name":"bool"}}],[11,"ne","","",315,{"inputs":[{"name":"self"},{"name":"sourceinfo"}],"output":{"name":"bool"}}],[11,"encode","","",315,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",315,{"inputs":[{"name":"__d"}],"output":{"generics":["sourceinfo"],"name":"result"}}],[11,"hash","","",315,null],[11,"clone","","",334,{"inputs":[{"name":"self"}],"output":{"name":"mutability"}}],[11,"fmt","","",334,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",334,{"inputs":[{"name":"self"},{"name":"mutability"}],"output":{"name":"bool"}}],[11,"encode","","",334,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",334,{"inputs":[{"name":"__d"}],"output":{"generics":["mutability"],"name":"result"}}],[11,"clone","","",335,{"inputs":[{"name":"self"}],"output":{"name":"borrowkind"}}],[11,"fmt","","",335,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",335,{"inputs":[{"name":"self"},{"name":"borrowkind"}],"output":{"name":"bool"}}],[11,"ne","","",335,{"inputs":[{"name":"self"},{"name":"borrowkind"}],"output":{"name":"bool"}}],[11,"encode","","",335,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",335,{"inputs":[{"name":"__d"}],"output":{"generics":["borrowkind"],"name":"result"}}],[11,"allows_two_phase_borrow","","",335,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",384,{"inputs":[{"name":"self"}],"output":{"name":"local"}}],[11,"eq","","",384,{"inputs":[{"name":"self"},{"name":"local"}],"output":{"name":"bool"}}],[11,"ne","","",384,{"inputs":[{"name":"self"},{"name":"local"}],"output":{"name":"bool"}}],[11,"hash","","",384,null],[11,"partial_cmp","","",384,{"inputs":[{"name":"self"},{"name":"local"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",384,{"inputs":[{"name":"self"},{"name":"local"}],"output":{"name":"bool"}}],[11,"le","","",384,{"inputs":[{"name":"self"},{"name":"local"}],"output":{"name":"bool"}}],[11,"gt","","",384,{"inputs":[{"name":"self"},{"name":"local"}],"output":{"name":"bool"}}],[11,"ge","","",384,{"inputs":[{"name":"self"},{"name":"local"}],"output":{"name":"bool"}}],[11,"cmp","","",384,{"inputs":[{"name":"self"},{"name":"local"}],"output":{"name":"ordering"}}],[11,"decode","","",384,{"inputs":[{"name":"__d"}],"output":{"generics":["local"],"name":"result"}}],[11,"encode","","",384,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"new","","",384,{"inputs":[{"name":"usize"}],"output":{"name":"self"}}],[11,"index","","",384,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"fmt","","",384,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",336,{"inputs":[{"name":"self"},{"name":"localkind"}],"output":{"name":"bool"}}],[11,"fmt","","",336,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",316,{"inputs":[{"name":"self"}],"output":{"name":"localdecl"}}],[11,"fmt","","",316,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",316,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",316,{"inputs":[{"name":"__d"}],"output":{"generics":["localdecl"],"name":"result"}}],[11,"new_temp","","Create a new `LocalDecl` for a temporary.",316,{"inputs":[{"name":"ty"},{"name":"span"}],"output":{"name":"self"}}],[11,"new_internal","","Create a new `LocalDecl` for a internal temporary.",316,{"inputs":[{"name":"ty"},{"name":"span"}],"output":{"name":"self"}}],[11,"new_return_place","","Builds a `LocalDecl` for the return place.",316,{"inputs":[{"name":"ty"},{"name":"span"}],"output":{"name":"localdecl"}}],[11,"clone","","",317,{"inputs":[{"name":"self"}],"output":{"name":"upvardecl"}}],[11,"fmt","","",317,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",317,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",317,{"inputs":[{"name":"__d"}],"output":{"generics":["upvardecl"],"name":"result"}}],[11,"clone","","",385,{"inputs":[{"name":"self"}],"output":{"name":"basicblock"}}],[11,"eq","","",385,{"inputs":[{"name":"self"},{"name":"basicblock"}],"output":{"name":"bool"}}],[11,"ne","","",385,{"inputs":[{"name":"self"},{"name":"basicblock"}],"output":{"name":"bool"}}],[11,"hash","","",385,null],[11,"partial_cmp","","",385,{"inputs":[{"name":"self"},{"name":"basicblock"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",385,{"inputs":[{"name":"self"},{"name":"basicblock"}],"output":{"name":"bool"}}],[11,"le","","",385,{"inputs":[{"name":"self"},{"name":"basicblock"}],"output":{"name":"bool"}}],[11,"gt","","",385,{"inputs":[{"name":"self"},{"name":"basicblock"}],"output":{"name":"bool"}}],[11,"ge","","",385,{"inputs":[{"name":"self"},{"name":"basicblock"}],"output":{"name":"bool"}}],[11,"cmp","","",385,{"inputs":[{"name":"self"},{"name":"basicblock"}],"output":{"name":"ordering"}}],[11,"decode","","",385,{"inputs":[{"name":"__d"}],"output":{"generics":["basicblock"],"name":"result"}}],[11,"encode","","",385,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"new","","",385,{"inputs":[{"name":"usize"}],"output":{"name":"self"}}],[11,"index","","",385,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"fmt","","",385,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"start_location","","",385,{"inputs":[{"name":"self"}],"output":{"name":"location"}}],[11,"clone","","",318,{"inputs":[{"name":"self"}],"output":{"name":"basicblockdata"}}],[11,"fmt","","",318,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",318,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",318,{"inputs":[{"name":"__d"}],"output":{"generics":["basicblockdata"],"name":"result"}}],[11,"clone","","",319,{"inputs":[{"name":"self"}],"output":{"name":"terminator"}}],[11,"fmt","","",319,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",319,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",319,{"inputs":[{"name":"__d"}],"output":{"generics":["terminator"],"name":"result"}}],[11,"clone","","",337,{"inputs":[{"name":"self"}],"output":{"name":"terminatorkind"}}],[11,"encode","","",337,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",337,{"inputs":[{"name":"__d"}],"output":{"generics":["terminatorkind"],"name":"result"}}],[11,"successors","","",319,{"inputs":[{"name":"self"}],"output":{"name":"cow"}}],[11,"successors_mut","","",319,{"inputs":[{"name":"self"}],"output":{"generics":["basicblock"],"name":"vec"}}],[11,"unwind_mut","","",319,{"inputs":[{"name":"self"}],"output":{"generics":["option"],"name":"option"}}],[11,"if_","","",337,{"inputs":[{"name":"tyctxt"},{"name":"operand"},{"name":"basicblock"},{"name":"basicblock"}],"output":{"name":"terminatorkind"}}],[11,"successors","","",337,{"inputs":[{"name":"self"}],"output":{"name":"cow"}}],[11,"successors_mut","","",337,{"inputs":[{"name":"self"}],"output":{"generics":["basicblock"],"name":"vec"}}],[11,"unwind_mut","","",337,{"inputs":[{"name":"self"}],"output":{"generics":["option"],"name":"option"}}],[11,"new","","",318,{"inputs":[{"generics":["terminator"],"name":"option"}],"output":{"name":"basicblockdata"}}],[11,"terminator","","Accessor for terminator.",318,{"inputs":[{"name":"self"}],"output":{"name":"terminator"}}],[11,"terminator_mut","","",318,{"inputs":[{"name":"self"}],"output":{"name":"terminator"}}],[11,"retain_statements","","",318,{"inputs":[{"name":"self"},{"name":"f"}],"output":null}],[11,"expand_statements","","",318,{"inputs":[{"name":"self"},{"name":"f"}],"output":null}],[11,"visitable","","",318,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"mirvisitable"}}],[11,"fmt","","",337,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt_head","","Write the \"head\" part of the terminator; that is, its name and the data it uses to pick the successor basic block, if any. The only information not included is the list of possible successors, which may be rendered differently between the text and the graphviz format.",337,{"inputs":[{"name":"self"},{"name":"w"}],"output":{"name":"result"}}],[11,"fmt_successor_labels","","Return the list of labels for the edges to the successor basic blocks.",337,{"inputs":[{"name":"self"}],"output":{"generics":["cow"],"name":"vec"}}],[11,"clone","","",338,{"inputs":[{"name":"self"}],"output":{"name":"assertmessage"}}],[11,"fmt","","",338,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",338,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",338,{"inputs":[{"name":"__d"}],"output":{"generics":["assertmessage"],"name":"result"}}],[11,"clone","","",320,{"inputs":[{"name":"self"}],"output":{"name":"statement"}}],[11,"encode","","",320,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",320,{"inputs":[{"name":"__d"}],"output":{"generics":["statement"],"name":"result"}}],[11,"make_nop","","Changes a statement to a nop. This is both faster than deleting instructions and avoids invalidating statement indices in `Location`s.",320,{"inputs":[{"name":"self"}],"output":null}],[11,"replace_nop","","Changes a statement to a nop and returns the original statement.",320,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"clone","","",339,{"inputs":[{"name":"self"}],"output":{"name":"statementkind"}}],[11,"fmt","","",339,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",339,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",339,{"inputs":[{"name":"__d"}],"output":{"generics":["statementkind"],"name":"result"}}],[11,"clone","","",340,{"inputs":[{"name":"self"}],"output":{"name":"validationop"}}],[11,"encode","","",340,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",340,{"inputs":[{"name":"__d"}],"output":{"generics":["validationop"],"name":"result"}}],[11,"eq","","",340,{"inputs":[{"name":"self"},{"name":"validationop"}],"output":{"name":"bool"}}],[11,"ne","","",340,{"inputs":[{"name":"self"},{"name":"validationop"}],"output":{"name":"bool"}}],[11,"fmt","","",340,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",321,{"inputs":[{"name":"self"}],"output":{"name":"validationoperand"}}],[11,"encode","","",321,{"inputs":[{"name":"self"},{"name":"__st"}],"output":{"name":"result"}}],[11,"decode","","",321,{"inputs":[{"name":"__dt"}],"output":{"generics":["validationoperand"],"name":"result"}}],[11,"fmt","","",321,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",320,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",341,{"inputs":[{"name":"self"}],"output":{"name":"place"}}],[11,"eq","","",341,{"inputs":[{"name":"self"},{"name":"place"}],"output":{"name":"bool"}}],[11,"ne","","",341,{"inputs":[{"name":"self"},{"name":"place"}],"output":{"name":"bool"}}],[11,"hash","","",341,null],[11,"encode","","",341,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",341,{"inputs":[{"name":"__d"}],"output":{"generics":["place"],"name":"result"}}],[11,"clone","","",322,{"inputs":[{"name":"self"}],"output":{"name":"static"}}],[11,"eq","","",322,{"inputs":[{"name":"self"},{"name":"static"}],"output":{"name":"bool"}}],[11,"ne","","",322,{"inputs":[{"name":"self"},{"name":"static"}],"output":{"name":"bool"}}],[11,"hash","","",322,null],[11,"encode","","",322,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",322,{"inputs":[{"name":"__d"}],"output":{"generics":["static"],"name":"result"}}],[11,"hash_stable","","",322,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"clone","","",323,{"inputs":[{"name":"self"}],"output":{"name":"projection"}}],[11,"fmt","","",323,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",323,{"inputs":[{"name":"self"},{"name":"projection"}],"output":{"name":"bool"}}],[11,"ne","","",323,{"inputs":[{"name":"self"},{"name":"projection"}],"output":{"name":"bool"}}],[11,"hash","","",323,null],[11,"encode","","",323,{"inputs":[{"name":"self"},{"name":"__sbvt"}],"output":{"name":"result"}}],[11,"decode","","",323,{"inputs":[{"name":"__dbvt"}],"output":{"generics":["projection"],"name":"result"}}],[11,"clone","","",342,{"inputs":[{"name":"self"}],"output":{"name":"projectionelem"}}],[11,"fmt","","",342,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",342,{"inputs":[{"name":"self"},{"name":"projectionelem"}],"output":{"name":"bool"}}],[11,"ne","","",342,{"inputs":[{"name":"self"},{"name":"projectionelem"}],"output":{"name":"bool"}}],[11,"hash","","",342,null],[11,"encode","","",342,{"inputs":[{"name":"self"},{"name":"__svt"}],"output":{"name":"result"}}],[11,"decode","","",342,{"inputs":[{"name":"__dvt"}],"output":{"generics":["projectionelem"],"name":"result"}}],[11,"clone","","",386,{"inputs":[{"name":"self"}],"output":{"name":"field"}}],[11,"eq","","",386,{"inputs":[{"name":"self"},{"name":"field"}],"output":{"name":"bool"}}],[11,"ne","","",386,{"inputs":[{"name":"self"},{"name":"field"}],"output":{"name":"bool"}}],[11,"hash","","",386,null],[11,"partial_cmp","","",386,{"inputs":[{"name":"self"},{"name":"field"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",386,{"inputs":[{"name":"self"},{"name":"field"}],"output":{"name":"bool"}}],[11,"le","","",386,{"inputs":[{"name":"self"},{"name":"field"}],"output":{"name":"bool"}}],[11,"gt","","",386,{"inputs":[{"name":"self"},{"name":"field"}],"output":{"name":"bool"}}],[11,"ge","","",386,{"inputs":[{"name":"self"},{"name":"field"}],"output":{"name":"bool"}}],[11,"cmp","","",386,{"inputs":[{"name":"self"},{"name":"field"}],"output":{"name":"ordering"}}],[11,"decode","","",386,{"inputs":[{"name":"__d"}],"output":{"generics":["field"],"name":"result"}}],[11,"encode","","",386,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"new","","",386,{"inputs":[{"name":"usize"}],"output":{"name":"self"}}],[11,"index","","",386,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"fmt","","",386,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"field","","",341,{"inputs":[{"name":"self"},{"name":"field"},{"name":"ty"}],"output":{"name":"place"}}],[11,"deref","","",341,{"inputs":[{"name":"self"}],"output":{"name":"place"}}],[11,"downcast","","",341,{"inputs":[{"name":"self"},{"name":"adtdef"},{"name":"usize"}],"output":{"name":"place"}}],[11,"index","","",341,{"inputs":[{"name":"self"},{"name":"local"}],"output":{"name":"place"}}],[11,"elem","","",341,{"inputs":[{"name":"self"},{"name":"placeelem"}],"output":{"name":"place"}}],[11,"fmt","","",341,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",387,{"inputs":[{"name":"self"}],"output":{"name":"visibilityscope"}}],[11,"eq","","",387,{"inputs":[{"name":"self"},{"name":"visibilityscope"}],"output":{"name":"bool"}}],[11,"ne","","",387,{"inputs":[{"name":"self"},{"name":"visibilityscope"}],"output":{"name":"bool"}}],[11,"hash","","",387,null],[11,"partial_cmp","","",387,{"inputs":[{"name":"self"},{"name":"visibilityscope"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",387,{"inputs":[{"name":"self"},{"name":"visibilityscope"}],"output":{"name":"bool"}}],[11,"le","","",387,{"inputs":[{"name":"self"},{"name":"visibilityscope"}],"output":{"name":"bool"}}],[11,"gt","","",387,{"inputs":[{"name":"self"},{"name":"visibilityscope"}],"output":{"name":"bool"}}],[11,"ge","","",387,{"inputs":[{"name":"self"},{"name":"visibilityscope"}],"output":{"name":"bool"}}],[11,"cmp","","",387,{"inputs":[{"name":"self"},{"name":"visibilityscope"}],"output":{"name":"ordering"}}],[11,"decode","","",387,{"inputs":[{"name":"__d"}],"output":{"generics":["visibilityscope"],"name":"result"}}],[11,"encode","","",387,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"new","","",387,{"inputs":[{"name":"usize"}],"output":{"name":"self"}}],[11,"index","","",387,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"fmt","","",387,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",324,{"inputs":[{"name":"self"}],"output":{"name":"visibilityscopedata"}}],[11,"fmt","","",324,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",324,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",324,{"inputs":[{"name":"__d"}],"output":{"generics":["visibilityscopedata"],"name":"result"}}],[11,"clone","","",343,{"inputs":[{"name":"self"}],"output":{"name":"operand"}}],[11,"eq","","",343,{"inputs":[{"name":"self"},{"name":"operand"}],"output":{"name":"bool"}}],[11,"ne","","",343,{"inputs":[{"name":"self"},{"name":"operand"}],"output":{"name":"bool"}}],[11,"encode","","",343,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",343,{"inputs":[{"name":"__d"}],"output":{"generics":["operand"],"name":"result"}}],[11,"fmt","","",343,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"function_handle","","",343,{"inputs":[{"name":"tyctxt"},{"name":"defid"},{"name":"substs"},{"name":"span"}],"output":{"name":"self"}}],[11,"to_copy","","",343,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"clone","","",344,{"inputs":[{"name":"self"}],"output":{"name":"rvalue"}}],[11,"encode","","",344,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",344,{"inputs":[{"name":"__d"}],"output":{"generics":["rvalue"],"name":"result"}}],[11,"clone","","",345,{"inputs":[{"name":"self"}],"output":{"name":"castkind"}}],[11,"fmt","","",345,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",345,{"inputs":[{"name":"self"},{"name":"castkind"}],"output":{"name":"bool"}}],[11,"encode","","",345,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",345,{"inputs":[{"name":"__d"}],"output":{"generics":["castkind"],"name":"result"}}],[11,"clone","","",346,{"inputs":[{"name":"self"}],"output":{"name":"aggregatekind"}}],[11,"fmt","","",346,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",346,{"inputs":[{"name":"self"},{"name":"aggregatekind"}],"output":{"name":"bool"}}],[11,"ne","","",346,{"inputs":[{"name":"self"},{"name":"aggregatekind"}],"output":{"name":"bool"}}],[11,"encode","","",346,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",346,{"inputs":[{"name":"__d"}],"output":{"generics":["aggregatekind"],"name":"result"}}],[11,"clone","","",347,{"inputs":[{"name":"self"}],"output":{"name":"binop"}}],[11,"fmt","","",347,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",347,{"inputs":[{"name":"self"},{"name":"binop"}],"output":{"name":"bool"}}],[11,"encode","","",347,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",347,{"inputs":[{"name":"__d"}],"output":{"generics":["binop"],"name":"result"}}],[11,"is_checkable","","",347,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",348,{"inputs":[{"name":"self"}],"output":{"name":"nullop"}}],[11,"fmt","","",348,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",348,{"inputs":[{"name":"self"},{"name":"nullop"}],"output":{"name":"bool"}}],[11,"encode","","",348,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",348,{"inputs":[{"name":"__d"}],"output":{"generics":["nullop"],"name":"result"}}],[11,"clone","","",349,{"inputs":[{"name":"self"}],"output":{"name":"unop"}}],[11,"fmt","","",349,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",349,{"inputs":[{"name":"self"},{"name":"unop"}],"output":{"name":"bool"}}],[11,"encode","","",349,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",349,{"inputs":[{"name":"__d"}],"output":{"generics":["unop"],"name":"result"}}],[11,"fmt","","",344,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",325,{"inputs":[{"name":"self"}],"output":{"name":"constant"}}],[11,"eq","","",325,{"inputs":[{"name":"self"},{"name":"constant"}],"output":{"name":"bool"}}],[11,"ne","","",325,{"inputs":[{"name":"self"},{"name":"constant"}],"output":{"name":"bool"}}],[11,"hash","","",325,null],[11,"encode","","",325,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",325,{"inputs":[{"name":"__d"}],"output":{"generics":["constant"],"name":"result"}}],[11,"clone","","",388,{"inputs":[{"name":"self"}],"output":{"name":"promoted"}}],[11,"eq","","",388,{"inputs":[{"name":"self"},{"name":"promoted"}],"output":{"name":"bool"}}],[11,"ne","","",388,{"inputs":[{"name":"self"},{"name":"promoted"}],"output":{"name":"bool"}}],[11,"hash","","",388,null],[11,"partial_cmp","","",388,{"inputs":[{"name":"self"},{"name":"promoted"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",388,{"inputs":[{"name":"self"},{"name":"promoted"}],"output":{"name":"bool"}}],[11,"le","","",388,{"inputs":[{"name":"self"},{"name":"promoted"}],"output":{"name":"bool"}}],[11,"gt","","",388,{"inputs":[{"name":"self"},{"name":"promoted"}],"output":{"name":"bool"}}],[11,"ge","","",388,{"inputs":[{"name":"self"},{"name":"promoted"}],"output":{"name":"bool"}}],[11,"cmp","","",388,{"inputs":[{"name":"self"},{"name":"promoted"}],"output":{"name":"ordering"}}],[11,"decode","","",388,{"inputs":[{"name":"__d"}],"output":{"generics":["promoted"],"name":"result"}}],[11,"encode","","",388,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"new","","",388,{"inputs":[{"name":"usize"}],"output":{"name":"self"}}],[11,"index","","",388,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"fmt","","",388,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",350,{"inputs":[{"name":"self"}],"output":{"name":"literal"}}],[11,"eq","","",350,{"inputs":[{"name":"self"},{"name":"literal"}],"output":{"name":"bool"}}],[11,"ne","","",350,{"inputs":[{"name":"self"},{"name":"literal"}],"output":{"name":"bool"}}],[11,"hash","","",350,null],[11,"encode","","",350,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",350,{"inputs":[{"name":"__d"}],"output":{"generics":["literal"],"name":"result"}}],[11,"fmt","","",325,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",350,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"num_nodes","","",313,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"start_node","","",313,null],[11,"predecessors","","",313,null],[11,"successors","","",313,null],[11,"clone","","",326,{"inputs":[{"name":"self"}],"output":{"name":"location"}}],[11,"eq","","",326,{"inputs":[{"name":"self"},{"name":"location"}],"output":{"name":"bool"}}],[11,"ne","","",326,{"inputs":[{"name":"self"},{"name":"location"}],"output":{"name":"bool"}}],[11,"hash","","",326,null],[11,"cmp","","",326,{"inputs":[{"name":"self"},{"name":"location"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",326,{"inputs":[{"name":"self"},{"name":"location"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",326,{"inputs":[{"name":"self"},{"name":"location"}],"output":{"name":"bool"}}],[11,"le","","",326,{"inputs":[{"name":"self"},{"name":"location"}],"output":{"name":"bool"}}],[11,"gt","","",326,{"inputs":[{"name":"self"},{"name":"location"}],"output":{"name":"bool"}}],[11,"ge","","",326,{"inputs":[{"name":"self"},{"name":"location"}],"output":{"name":"bool"}}],[11,"fmt","","",326,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"successor_within_block","","Returns the location immediately after this one within the enclosing block.",326,{"inputs":[{"name":"self"}],"output":{"name":"location"}}],[11,"dominates","","",326,{"inputs":[{"name":"self"},{"name":"location"},{"name":"dominators"}],"output":{"name":"bool"}}],[11,"clone","","",351,{"inputs":[{"name":"self"}],"output":{"name":"unsafetyviolationkind"}}],[11,"fmt","","",351,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",351,{"inputs":[{"name":"self"},{"name":"unsafetyviolationkind"}],"output":{"name":"bool"}}],[11,"ne","","",351,{"inputs":[{"name":"self"},{"name":"unsafetyviolationkind"}],"output":{"name":"bool"}}],[11,"hash","","",351,null],[11,"encode","","",351,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",351,{"inputs":[{"name":"__d"}],"output":{"generics":["unsafetyviolationkind"],"name":"result"}}],[11,"clone","","",327,{"inputs":[{"name":"self"}],"output":{"name":"unsafetyviolation"}}],[11,"fmt","","",327,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",327,{"inputs":[{"name":"self"},{"name":"unsafetyviolation"}],"output":{"name":"bool"}}],[11,"ne","","",327,{"inputs":[{"name":"self"},{"name":"unsafetyviolation"}],"output":{"name":"bool"}}],[11,"hash","","",327,null],[11,"encode","","",327,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",327,{"inputs":[{"name":"__d"}],"output":{"generics":["unsafetyviolation"],"name":"result"}}],[11,"clone","","",328,{"inputs":[{"name":"self"}],"output":{"name":"unsafetycheckresult"}}],[11,"fmt","","",328,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",328,{"inputs":[{"name":"self"},{"name":"unsafetycheckresult"}],"output":{"name":"bool"}}],[11,"ne","","",328,{"inputs":[{"name":"self"},{"name":"unsafetycheckresult"}],"output":{"name":"bool"}}],[11,"hash","","",328,null],[11,"encode","","",328,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",328,{"inputs":[{"name":"__d"}],"output":{"generics":["unsafetycheckresult"],"name":"result"}}],[11,"clone","","",329,{"inputs":[{"name":"self"}],"output":{"name":"generatorlayout"}}],[11,"fmt","","",329,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",329,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",329,{"inputs":[{"name":"__d"}],"output":{"generics":["generatorlayout"],"name":"result"}}],[11,"clone","","",330,{"inputs":[{"name":"self"}],"output":{"name":"closureregionrequirements"}}],[11,"fmt","","",330,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",330,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",330,{"inputs":[{"name":"__d"}],"output":{"generics":["closureregionrequirements"],"name":"result"}}],[11,"clone","","",331,{"inputs":[{"name":"self"}],"output":{"name":"closureoutlivesrequirement"}}],[11,"fmt","","",331,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",331,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",331,{"inputs":[{"name":"__d"}],"output":{"generics":["closureoutlivesrequirement"],"name":"result"}}],[11,"clone","","",352,{"inputs":[{"name":"self"}],"output":{"name":"closureoutlivessubject"}}],[11,"fmt","","",352,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",352,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",352,{"inputs":[{"name":"__d"}],"output":{"generics":["closureoutlivessubject"],"name":"result"}}],[11,"super_fold_with","","",334,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"mutability"}}],[11,"super_visit_with","","",334,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",315,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"sourceinfo"}}],[11,"super_visit_with","","",315,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",317,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"upvardecl"}}],[11,"super_visit_with","","",317,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",340,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"validationop"}}],[11,"super_visit_with","","",340,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",324,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"visibilityscopedata"}}],[11,"super_visit_with","","",324,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",387,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"visibilityscope"}}],[11,"super_visit_with","","",387,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",314,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"visibilityscopeinfo"}}],[11,"super_visit_with","","",314,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"lift_to_tcx","","",334,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","","",315,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","","",317,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","","",340,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","","",324,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","","",387,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","","",314,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"super_fold_with","","",313,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",313,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",329,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",329,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",316,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",316,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",318,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",318,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",321,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",321,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",320,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",320,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",339,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",339,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",333,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",333,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",319,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"self"}}],[11,"super_visit_with","","",319,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",341,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"self"}}],[11,"super_visit_with","","",341,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",344,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"self"}}],[11,"super_visit_with","","",344,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",343,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"self"}}],[11,"super_visit_with","","",343,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",323,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"self"}}],[11,"super_visit_with","","",323,{"inputs":[{"name":"self"},{"name":"vs"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",386,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"self"}}],[11,"super_visit_with","","",386,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",325,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"self"}}],[11,"super_visit_with","","",325,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",350,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"self"}}],[11,"super_visit_with","","",350,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[0,"session","rustc","",null,null],[3,"CodeStats","rustc::session","",null,null],[3,"FieldInfo","","",null,null],[12,"name","","",389,null],[12,"offset","","",389,null],[12,"size","","",389,null],[12,"align","","",389,null],[3,"TypeSizeInfo","","",null,null],[12,"kind","","",390,null],[12,"type_description","","",390,null],[12,"align","","",390,null],[12,"overall_size","","",390,null],[12,"opt_discr_size","","",390,null],[12,"variants","","",390,null],[3,"VariantInfo","","",null,null],[12,"name","","",391,null],[12,"kind","","",391,null],[12,"size","","",391,null],[12,"align","","",391,null],[12,"fields","","",391,null],[3,"Session","","Represents the data associated with a compilation session for a single crate.",null,null],[12,"target","","",392,null],[12,"host","","",392,null],[12,"opts","","",392,null],[12,"parse_sess","","",392,null],[12,"entry_fn","","For a library crate, this is always none",392,null],[12,"entry_type","","",392,null],[12,"plugin_registrar_fn","","",392,null],[12,"derive_registrar_fn","","",392,null],[12,"default_sysroot","","",392,null],[12,"local_crate_source_file","","The name of the root source file of the crate, in the local file system. `None` means that there is no source file.",392,null],[12,"working_dir","","The directory the compiler has been executed in plus a flag indicating if the value stored here has been affected by path remapping.",392,null],[12,"lint_store","","",392,null],[12,"buffered_lints","","",392,null],[12,"one_time_diagnostics","","Set of (DiagnosticId, Option, message) tuples tracking (sub)diagnostics that have been set once, but should not be set again, in order to avoid redundantly verbose output (Issue #24690, #44953).",392,null],[12,"plugin_llvm_passes","","",392,null],[12,"plugin_attributes","","",392,null],[12,"crate_types","","",392,null],[12,"dependency_formats","","",392,null],[12,"crate_disambiguator","","The crate_disambiguator is constructed out of all the `-C metadata` arguments passed to the compiler. Its value together with the crate-name forms a unique global identifier for the crate. It is used to allow multiple crates with the same name to coexist. See the trans::back::symbol_names module for more information.",392,null],[12,"recursion_limit","","The maximum recursion limit for potentially infinitely recursive operations such as auto-dereference and monomorphization.",392,null],[12,"type_length_limit","","The maximum length of types during monomorphization.",392,null],[12,"const_eval_stack_frame_limit","","The maximum number of stackframes allowed in const eval",392,null],[12,"injected_allocator","","The metadata::creader module may inject an allocator/panic_runtime dependency if it didn't already find one, and this tracks what was injected.",392,null],[12,"allocator_kind","","",392,null],[12,"injected_panic_runtime","","",392,null],[12,"imported_macro_spans","","Map from imported macro spans (which consist of the localized span for the macro body) to the macro name and definition span in the source crate.",392,null],[12,"ignored_attr_names","","A cache of attributes ignored by StableHashingContext",392,null],[12,"profile_channel","","Used by -Z profile-queries in util::common",392,null],[12,"perf_stats","","Some measurements that are being gathered during compilation.",392,null],[12,"code_stats","","Data about code being compiled, gathered during compilation.",392,null],[12,"print_fuel_crate","","If -zprint-fuel=crate, Some(crate).",392,null],[12,"print_fuel","","Always set to zero and incremented so that we can print fuel expended by a crate.",392,null],[12,"jobserver_from_env","","Loaded up early on in the initialization of this `Session` to avoid false positives about a job server in our environment.",392,null],[12,"has_global_allocator","","Metadata about the allocators for the current crate being compiled",392,null],[3,"PerfStats","","",null,null],[12,"svh_time","","The accumulated time needed for computing the SVH of the crate",393,null],[12,"incr_comp_hashes_time","","The accumulated time spent on computing incr. comp. hashes",393,null],[12,"incr_comp_hashes_count","","The number of incr. comp. hash computations performed",393,null],[12,"incr_comp_bytes_hashed","","The number of bytes hashed when computing ICH values",393,null],[12,"symbol_hash_time","","The accumulated time spent on computing symbol hashes",393,null],[12,"decode_def_path_tables_time","","The accumulated time spent decoding def path tables from metadata",393,null],[12,"queries_canonicalized","","Total number of values canonicalized queries constructed.",393,null],[12,"canonicalized_values_allocated","","Number of times we canonicalized a value and found that the result had already been canonicalized.",393,null],[12,"normalize_ty_after_erasing_regions","","Number of times this query is invoked.",393,null],[12,"normalize_projection_ty","","Number of times this query is invoked.",393,null],[3,"CrateDisambiguator","","Hash value constructed out of all the `-C metadata` arguments passed to the compiler. Together with the crate-name forms a unique global identifier for the crate.",null,null],[4,"DataTypeKind","","",null,null],[13,"Struct","","",394,null],[13,"Union","","",394,null],[13,"Enum","","",394,null],[13,"Closure","","",394,null],[4,"SizeKind","","",null,null],[13,"Exact","","",395,null],[13,"Min","","",395,null],[4,"DiagnosticMessageId","","Diagnostic message ID—used by `Session.one_time_diagnostics` to avoid emitting the same message more than once",null,null],[13,"ErrorId","","",396,null],[13,"LintId","","",396,null],[13,"StabilityId","","",396,null],[4,"IncrCompSession","","Holds data on the current incremental compilation session, if there is one.",null,null],[13,"NotInitialized","","This is the state the session will be in until the incr. comp. dir is needed.",397,null],[13,"Active","","This is the state during which the session directory is private and can be modified.",397,null],[12,"session_directory","rustc::session::IncrCompSession","",397,null],[12,"lock_file","","",397,null],[12,"load_dep_graph","","",397,null],[13,"Finalized","rustc::session","This is the state after the session directory has been finalized. In this state, the contents of the directory must not be modified any more.",397,null],[12,"session_directory","rustc::session::IncrCompSession","",397,null],[13,"InvalidBecauseOfErrors","rustc::session","This is an error state that is reached when some compilation error has occurred. It indicates that the contents of the session directory must not be used, since they might be invalid.",397,null],[12,"session_directory","rustc::session::IncrCompSession","",397,null],[4,"CompileIncomplete","rustc::session","",null,null],[13,"Stopped","","",398,null],[13,"Errored","","",398,null],[5,"build_session","","",null,{"inputs":[{"name":"options"},{"generics":["pathbuf"],"name":"option"},{"name":"registry"}],"output":{"name":"session"}}],[5,"build_session_with_codemap","","",null,{"inputs":[{"name":"options"},{"generics":["pathbuf"],"name":"option"},{"name":"registry"},{"generics":["codemap"],"name":"lrc"},{"generics":["box"],"name":"option"}],"output":{"name":"session"}}],[5,"build_session_","","",null,{"inputs":[{"name":"options"},{"generics":["pathbuf"],"name":"option"},{"name":"handler"},{"generics":["codemap"],"name":"lrc"}],"output":{"name":"session"}}],[5,"early_error","","",null,null],[5,"early_warn","","",null,{"inputs":[{"name":"erroroutputtype"},{"name":"str"}],"output":null}],[5,"compile_result_from_err_count","","",null,{"inputs":[{"name":"usize"}],"output":{"name":"compileresult"}}],[5,"bug_fmt","","",null,null],[5,"span_bug_fmt","","",null,null],[11,"clone","","",391,{"inputs":[{"name":"self"}],"output":{"name":"variantinfo"}}],[11,"eq","","",391,{"inputs":[{"name":"self"},{"name":"variantinfo"}],"output":{"name":"bool"}}],[11,"ne","","",391,{"inputs":[{"name":"self"},{"name":"variantinfo"}],"output":{"name":"bool"}}],[11,"hash","","",391,null],[11,"fmt","","",391,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",395,{"inputs":[{"name":"self"}],"output":{"name":"sizekind"}}],[11,"eq","","",395,{"inputs":[{"name":"self"},{"name":"sizekind"}],"output":{"name":"bool"}}],[11,"hash","","",395,null],[11,"fmt","","",395,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",389,{"inputs":[{"name":"self"}],"output":{"name":"fieldinfo"}}],[11,"eq","","",389,{"inputs":[{"name":"self"},{"name":"fieldinfo"}],"output":{"name":"bool"}}],[11,"ne","","",389,{"inputs":[{"name":"self"},{"name":"fieldinfo"}],"output":{"name":"bool"}}],[11,"hash","","",389,null],[11,"fmt","","",389,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"from","","",394,{"inputs":[{"name":"adtkind"}],"output":{"name":"self"}}],[11,"clone","","",394,{"inputs":[{"name":"self"}],"output":{"name":"datatypekind"}}],[11,"eq","","",394,{"inputs":[{"name":"self"},{"name":"datatypekind"}],"output":{"name":"bool"}}],[11,"hash","","",394,null],[11,"fmt","","",394,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",390,{"inputs":[{"name":"self"},{"name":"typesizeinfo"}],"output":{"name":"bool"}}],[11,"ne","","",390,{"inputs":[{"name":"self"},{"name":"typesizeinfo"}],"output":{"name":"bool"}}],[11,"hash","","",390,null],[11,"fmt","","",390,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",399,{"inputs":[{"name":"self"},{"name":"codestats"}],"output":{"name":"bool"}}],[11,"ne","","",399,{"inputs":[{"name":"self"},{"name":"codestats"}],"output":{"name":"bool"}}],[11,"fmt","","",399,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","",399,{"inputs":[],"output":{"name":"self"}}],[11,"record_type_size","","",399,{"inputs":[{"name":"self"},{"name":"datatypekind"},{"name":"s"},{"name":"align"},{"name":"size"},{"generics":["size"],"name":"option"},{"generics":["variantinfo"],"name":"vec"}],"output":null}],[11,"print_type_sizes","","",399,{"inputs":[{"name":"self"}],"output":null}],[0,"config","","Contains infrastructure for configuring the compiler, including parsing command line options.",null,null],[3,"Config","rustc::session::config","",null,null],[12,"target","","",400,null],[12,"isize_ty","","",400,null],[12,"usize_ty","","",400,null],[3,"OutputTypes","","",null,null],[3,"Externs","","",null,null],[3,"Options","","",null,null],[12,"crate_types","","",401,null],[12,"optimize","","",401,null],[12,"debug_assertions","","",401,null],[12,"debuginfo","","",401,null],[12,"lint_opts","","",401,null],[12,"lint_cap","","",401,null],[12,"describe_lints","","",401,null],[12,"output_types","","",401,null],[12,"search_paths","","",401,null],[12,"libs","","",401,null],[12,"maybe_sysroot","","",401,null],[12,"target_triple","","",401,null],[12,"test","","",401,null],[12,"error_format","","",401,null],[12,"incremental","","",401,null],[12,"debugging_opts","","",401,null],[12,"prints","","",401,null],[12,"borrowck_mode","","",401,null],[12,"cg","","",401,null],[12,"externs","","",401,null],[12,"crate_name","","",401,null],[12,"alt_std_name","","",401,null],[12,"unstable_features","","",401,null],[12,"actually_rustdoc","","",401,null],[12,"cli_forced_codegen_units","","",401,null],[12,"cli_forced_thinlto_off","","",401,null],[12,"remap_path_prefix","","",401,null],[3,"OutputFilenames","","",null,null],[12,"out_directory","","",402,null],[12,"out_filestem","","",402,null],[12,"single_output_file","","",402,null],[12,"extra","","",402,null],[12,"outputs","","",402,null],[3,"CodegenOptions","","",null,null],[12,"ar","","",403,null],[12,"linker","","",403,null],[12,"link_arg","","",403,null],[12,"link_args","","",403,null],[12,"link_dead_code","","",403,null],[12,"lto","","",403,null],[12,"target_cpu","","",403,null],[12,"target_feature","","",403,null],[12,"passes","","",403,null],[12,"llvm_args","","",403,null],[12,"save_temps","","",403,null],[12,"rpath","","",403,null],[12,"overflow_checks","","",403,null],[12,"no_prepopulate_passes","","",403,null],[12,"no_vectorize_loops","","",403,null],[12,"no_vectorize_slp","","",403,null],[12,"soft_float","","",403,null],[12,"prefer_dynamic","","",403,null],[12,"no_integrated_as","","",403,null],[12,"no_redzone","","",403,null],[12,"relocation_model","","",403,null],[12,"code_model","","",403,null],[12,"metadata","","",403,null],[12,"extra_filename","","",403,null],[12,"codegen_units","","",403,null],[12,"remark","","",403,null],[12,"no_stack_check","","",403,null],[12,"debuginfo","","",403,null],[12,"opt_level","","",403,null],[12,"debug_assertions","","",403,null],[12,"inline_threshold","","",403,null],[12,"panic","","",403,null],[12,"incremental","","",403,null],[3,"DebuggingOptions","","",null,null],[12,"codegen_backend","","",404,null],[12,"verbose","","",404,null],[12,"span_free_formats","","",404,null],[12,"identify_regions","","",404,null],[12,"emit_end_regions","","",404,null],[12,"borrowck","","",404,null],[12,"two_phase_borrows","","",404,null],[12,"two_phase_beyond_autoref","","",404,null],[12,"time_passes","","",404,null],[12,"count_llvm_insns","","",404,null],[12,"time_llvm_passes","","",404,null],[12,"input_stats","","",404,null],[12,"trans_stats","","",404,null],[12,"asm_comments","","",404,null],[12,"no_verify","","",404,null],[12,"borrowck_stats","","",404,null],[12,"no_landing_pads","","",404,null],[12,"fewer_names","","",404,null],[12,"meta_stats","","",404,null],[12,"print_link_args","","",404,null],[12,"print_llvm_passes","","",404,null],[12,"ast_json","","",404,null],[12,"query_threads","","",404,null],[12,"ast_json_noexpand","","",404,null],[12,"ls","","",404,null],[12,"save_analysis","","",404,null],[12,"flowgraph_print_loans","","",404,null],[12,"flowgraph_print_moves","","",404,null],[12,"flowgraph_print_assigns","","",404,null],[12,"flowgraph_print_all","","",404,null],[12,"print_region_graph","","",404,null],[12,"parse_only","","",404,null],[12,"no_trans","","",404,null],[12,"treat_err_as_bug","","",404,null],[12,"external_macro_backtrace","","",404,null],[12,"teach","","",404,null],[12,"continue_parse_after_error","","",404,null],[12,"incremental","","",404,null],[12,"incremental_queries","","",404,null],[12,"incremental_info","","",404,null],[12,"incremental_dump_hash","","",404,null],[12,"incremental_verify_ich","","",404,null],[12,"incremental_ignore_spans","","",404,null],[12,"dump_dep_graph","","",404,null],[12,"query_dep_graph","","",404,null],[12,"profile_queries","","",404,null],[12,"profile_queries_and_keys","","",404,null],[12,"no_analysis","","",404,null],[12,"extra_plugins","","",404,null],[12,"unstable_options","","",404,null],[12,"force_overflow_checks","","",404,null],[12,"trace_macros","","",404,null],[12,"debug_macros","","",404,null],[12,"enable_nonzeroing_move_hints","","",404,null],[12,"keep_hygiene_data","","",404,null],[12,"keep_ast","","",404,null],[12,"show_span","","",404,null],[12,"print_type_sizes","","",404,null],[12,"print_trans_items","","",404,null],[12,"mir_opt_level","","",404,null],[12,"mutable_noalias","","",404,null],[12,"arg_align_attributes","","",404,null],[12,"dump_mir","","",404,null],[12,"dump_mir_dir","","",404,null],[12,"dump_mir_graphviz","","",404,null],[12,"dump_mir_exclude_pass_number","","",404,null],[12,"mir_emit_validate","","",404,null],[12,"perf_stats","","",404,null],[12,"hir_stats","","",404,null],[12,"mir_stats","","",404,null],[12,"always_encode_mir","","",404,null],[12,"miri","","",404,null],[12,"osx_rpath_install_name","","",404,null],[12,"sanitizer","","",404,null],[12,"linker_flavor","","",404,null],[12,"fuel","","",404,null],[12,"print_fuel","","",404,null],[12,"force_unstable_if_unmarked","","",404,null],[12,"pre_link_arg","","",404,null],[12,"pre_link_args","","",404,null],[12,"profile","","",404,null],[12,"pgo_gen","","",404,null],[12,"pgo_use","","",404,null],[12,"disable_instrumentation_preinliner","","",404,null],[12,"relro_level","","",404,null],[12,"nll","","",404,null],[12,"disable_nll_user_type_assert","","",404,null],[12,"trans_time_graph","","",404,null],[12,"thinlto","","",404,null],[12,"inline_in_all_cgus","","",404,null],[12,"tls_model","","",404,null],[12,"saturating_float_casts","","",404,null],[12,"lower_128bit_ops","","",404,null],[12,"human_readable_cgu_names","","",404,null],[12,"dep_info_omit_d_target","","",404,null],[12,"approximate_suggestions","","",404,null],[12,"unpretty","","",404,null],[12,"edition","","",404,null],[12,"run_dsymutil","","",404,null],[12,"ui_testing","","",404,null],[12,"embed_bitcode","","",404,null],[12,"strip_debuginfo_if_disabled","","",404,null],[3,"RustcOptGroup","","",null,null],[12,"apply","","",405,null],[12,"name","","",405,null],[12,"stability","","",405,null],[4,"Sanitizer","","",null,null],[13,"Address","","",406,null],[13,"Leak","","",406,null],[13,"Memory","","",406,null],[13,"Thread","","",406,null],[4,"OptLevel","","",null,null],[13,"No","","",407,null],[13,"Less","","",407,null],[13,"Default","","",407,null],[13,"Aggressive","","",407,null],[13,"Size","","",407,null],[13,"SizeMin","","",407,null],[4,"Lto","","",null,null],[13,"No","","Don't do any LTO whatsoever",408,null],[13,"Yes","","Do a full crate graph LTO. The flavor is determined by the compiler (currently the default is \"fat\").",408,null],[13,"Thin","","Do a full crate graph LTO with ThinLTO",408,null],[13,"ThinLocal","","Do a local graph LTO with ThinLTO (only relevant for multiple codegen units).",408,null],[13,"Fat","","Do a full crate graph LTO with \"fat\" LTO",408,null],[4,"DebugInfoLevel","","",null,null],[13,"NoDebugInfo","","",409,null],[13,"LimitedDebugInfo","","",409,null],[13,"FullDebugInfo","","",409,null],[4,"OutputType","","",null,null],[13,"Bitcode","","",410,null],[13,"Assembly","","",410,null],[13,"LlvmAssembly","","",410,null],[13,"Mir","","",410,null],[13,"Metadata","","",410,null],[13,"Object","","",410,null],[13,"Exe","","",410,null],[13,"DepInfo","","",410,null],[4,"ErrorOutputType","","",null,null],[13,"HumanReadable","","",411,null],[13,"Json","","",411,null],[13,"Short","","",411,null],[4,"PrintRequest","","",null,null],[13,"FileNames","","",412,null],[13,"Sysroot","","",412,null],[13,"CrateName","","",412,null],[13,"Cfg","","",412,null],[13,"TargetList","","",412,null],[13,"TargetCPUs","","",412,null],[13,"TargetFeatures","","",412,null],[13,"RelocationModels","","",412,null],[13,"CodeModels","","",412,null],[13,"TlsModels","","",412,null],[13,"TargetSpec","","",412,null],[13,"NativeStaticLibs","","",412,null],[4,"BorrowckMode","","",null,null],[13,"Ast","","",413,null],[13,"Mir","","",413,null],[13,"Compare","","",413,null],[4,"Input","","",null,null],[13,"File","","Load source from file",414,null],[13,"Str","","",414,null],[12,"name","rustc::session::config::Input","String that is shown in place of a filename",414,null],[12,"input","","Anonymous source string",414,null],[4,"EntryFnType","rustc::session::config","",null,null],[13,"EntryMain","","",415,null],[13,"EntryStart","","",415,null],[13,"EntryNone","","",415,null],[4,"CrateType","","",null,null],[13,"CrateTypeExecutable","","",416,null],[13,"CrateTypeDylib","","",416,null],[13,"CrateTypeRlib","","",416,null],[13,"CrateTypeStaticlib","","",416,null],[13,"CrateTypeCdylib","","",416,null],[13,"CrateTypeProcMacro","","",416,null],[4,"Passes","","",null,null],[13,"SomePasses","","",417,null],[13,"AllPasses","","",417,null],[4,"OptionStability","","",null,null],[13,"Stable","","",418,null],[13,"Unstable","","",418,null],[5,"host_triple","","",null,{"inputs":[],"output":{"name":"str"}}],[5,"basic_options","","Some reasonable defaults",null,{"inputs":[],"output":{"name":"options"}}],[5,"basic_codegen_options","","",null,{"inputs":[],"output":{"name":"codegenoptions"}}],[5,"build_codegen_options","","",null,{"inputs":[{"name":"matches"},{"name":"erroroutputtype"}],"output":{"name":"codegenoptions"}}],[5,"basic_debugging_options","","",null,{"inputs":[],"output":{"name":"debuggingoptions"}}],[5,"build_debugging_options","","",null,{"inputs":[{"name":"matches"},{"name":"erroroutputtype"}],"output":{"name":"debuggingoptions"}}],[5,"default_lib_output","","",null,{"inputs":[],"output":{"name":"cratetype"}}],[5,"default_configuration","","",null,{"inputs":[{"name":"session"}],"output":{"name":"crateconfig"}}],[5,"build_configuration","","",null,{"inputs":[{"name":"session"},{"name":"crateconfig"}],"output":{"name":"crateconfig"}}],[5,"build_target_config","","",null,{"inputs":[{"name":"options"},{"name":"handler"}],"output":{"name":"config"}}],[5,"rustc_short_optgroups","","Returns the \"short\" subset of the rustc command line options, including metadata for each option, such as whether the option is part of the stable long-term interface for rustc.",null,{"inputs":[],"output":{"generics":["rustcoptgroup"],"name":"vec"}}],[5,"rustc_optgroups","","Returns all rustc command line options, including metadata for each option, such as whether the option is part of the stable long-term interface for rustc.",null,{"inputs":[],"output":{"generics":["rustcoptgroup"],"name":"vec"}}],[5,"parse_cfgspecs","","",null,{"inputs":[{"generics":["string"],"name":"vec"}],"output":{"name":"crateconfig"}}],[5,"build_session_options_and_crate_config","","",null,null],[5,"parse_crate_types_from_list","","",null,{"inputs":[{"generics":["string"],"name":"vec"}],"output":{"generics":["vec","string"],"name":"result"}}],[0,"nightly_options","","",null,null],[5,"is_unstable_enabled","rustc::session::config::nightly_options","",null,{"inputs":[{"name":"matches"}],"output":{"name":"bool"}}],[5,"is_nightly_build","","",null,{"inputs":[],"output":{"name":"bool"}}],[5,"check_nightly_options","","",null,null],[6,"CodegenSetter","rustc::session::config","",null,null],[6,"DebuggingSetter","","",null,null],[17,"RUST_CGU_EXT","","",null,null],[17,"CG_OPTIONS","","",null,null],[17,"DB_OPTIONS","","",null,null],[11,"clone","","",406,{"inputs":[{"name":"self"}],"output":{"name":"sanitizer"}}],[11,"hash","","",406,null],[11,"fmt","","",406,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",407,{"inputs":[{"name":"self"}],"output":{"name":"optlevel"}}],[11,"eq","","",407,{"inputs":[{"name":"self"},{"name":"optlevel"}],"output":{"name":"bool"}}],[11,"hash","","",407,null],[11,"clone","","",408,{"inputs":[{"name":"self"}],"output":{"name":"lto"}}],[11,"eq","","",408,{"inputs":[{"name":"self"},{"name":"lto"}],"output":{"name":"bool"}}],[11,"hash","","",408,null],[11,"clone","","",409,{"inputs":[{"name":"self"}],"output":{"name":"debuginfolevel"}}],[11,"eq","","",409,{"inputs":[{"name":"self"},{"name":"debuginfolevel"}],"output":{"name":"bool"}}],[11,"hash","","",409,null],[11,"clone","","",410,{"inputs":[{"name":"self"}],"output":{"name":"outputtype"}}],[11,"eq","","",410,{"inputs":[{"name":"self"},{"name":"outputtype"}],"output":{"name":"bool"}}],[11,"hash","","",410,null],[11,"fmt","","",410,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"partial_cmp","","",410,{"inputs":[{"name":"self"},{"name":"outputtype"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"cmp","","",410,{"inputs":[{"name":"self"},{"name":"outputtype"}],"output":{"name":"ordering"}}],[11,"encode","","",410,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",410,{"inputs":[{"name":"__d"}],"output":{"generics":["outputtype"],"name":"result"}}],[11,"hash_stable","","",410,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"to_stable_hash_key","","",410,null],[11,"extension","","",410,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"clone","","",411,{"inputs":[{"name":"self"}],"output":{"name":"erroroutputtype"}}],[11,"fmt","","",411,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",411,{"inputs":[{"name":"self"},{"name":"erroroutputtype"}],"output":{"name":"bool"}}],[11,"ne","","",411,{"inputs":[{"name":"self"},{"name":"erroroutputtype"}],"output":{"name":"bool"}}],[11,"default","","",411,{"inputs":[],"output":{"name":"erroroutputtype"}}],[11,"clone","","",419,{"inputs":[{"name":"self"}],"output":{"name":"outputtypes"}}],[11,"hash","","",419,null],[11,"hash_stable","","",419,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"new","","",419,null],[11,"get","","",419,{"inputs":[{"name":"self"},{"name":"outputtype"}],"output":{"generics":["option"],"name":"option"}}],[11,"contains_key","","",419,{"inputs":[{"name":"self"},{"name":"outputtype"}],"output":{"name":"bool"}}],[11,"keys","","",419,{"inputs":[{"name":"self"}],"output":{"generics":["outputtype","option"],"name":"btreemapkeysiter"}}],[11,"values","","",419,{"inputs":[{"name":"self"}],"output":{"generics":["outputtype","option"],"name":"btreemapvaluesiter"}}],[11,"should_trans","","",419,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",420,{"inputs":[{"name":"self"}],"output":{"name":"externs"}}],[11,"hash","","",420,null],[11,"new","","",420,{"inputs":[{"generics":["string","btreeset"],"name":"btreemap"}],"output":{"name":"externs"}}],[11,"get","","",420,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"generics":["btreeset"],"name":"option"}}],[11,"iter","","",420,{"inputs":[{"name":"self"}],"output":{"generics":["string","btreeset"],"name":"btreemapiter"}}],[11,"clone","","",401,{"inputs":[{"name":"self"}],"output":{"name":"options"}}],[11,"dep_tracking_hash","","",401,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"clone","","",412,{"inputs":[{"name":"self"}],"output":{"name":"printrequest"}}],[11,"eq","","",412,{"inputs":[{"name":"self"},{"name":"printrequest"}],"output":{"name":"bool"}}],[11,"fmt","","",412,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",413,{"inputs":[{"name":"self"}],"output":{"name":"borrowckmode"}}],[11,"fmt","","",413,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",413,{"inputs":[{"name":"self"},{"name":"borrowckmode"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",413,{"inputs":[{"name":"self"},{"name":"borrowckmode"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"cmp","","",413,{"inputs":[{"name":"self"},{"name":"borrowckmode"}],"output":{"name":"ordering"}}],[11,"hash","","",413,null],[11,"use_ast","","Should we emit the AST-based borrow checker errors?",413,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"use_mir","","Should we emit the MIR-based borrow checker errors?",413,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"filestem","","",414,{"inputs":[{"name":"self"}],"output":{"name":"string"}}],[11,"clone","","",402,{"inputs":[{"name":"self"}],"output":{"name":"outputfilenames"}}],[11,"hash_stable","","",402,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"path","","",402,{"inputs":[{"name":"self"},{"name":"outputtype"}],"output":{"name":"pathbuf"}}],[11,"temp_path","","Get the path where a compilation artifact of the given type for the given codegen unit should be placed on disk. If codegen_unit_name is None, a path distinct from those of any codegen unit will be generated.",402,{"inputs":[{"name":"self"},{"name":"outputtype"},{"generics":["str"],"name":"option"}],"output":{"name":"pathbuf"}}],[11,"temp_path_ext","","Like temp_path, but also supports things where there is no corresponding OutputType, like no-opt-bitcode or lto-bitcode.",402,{"inputs":[{"name":"self"},{"name":"str"},{"generics":["str"],"name":"option"}],"output":{"name":"pathbuf"}}],[11,"with_extension","","",402,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"pathbuf"}}],[11,"filestem","","",402,{"inputs":[{"name":"self"}],"output":{"name":"string"}}],[11,"build_dep_graph","","True if there is a reason to build the dep graph.",401,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"enable_dep_node_debug_strs","","",401,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"file_path_mapping","","",401,{"inputs":[{"name":"self"}],"output":{"name":"filepathmapping"}}],[11,"will_create_output_file","","True if there will be an output file generated",401,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",415,{"inputs":[{"name":"self"}],"output":{"name":"entryfntype"}}],[11,"eq","","",415,{"inputs":[{"name":"self"},{"name":"entryfntype"}],"output":{"name":"bool"}}],[11,"eq","","",416,{"inputs":[{"name":"self"},{"name":"cratetype"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",416,{"inputs":[{"name":"self"},{"name":"cratetype"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"clone","","",416,{"inputs":[{"name":"self"}],"output":{"name":"cratetype"}}],[11,"cmp","","",416,{"inputs":[{"name":"self"},{"name":"cratetype"}],"output":{"name":"ordering"}}],[11,"hash","","",416,null],[11,"fmt","","",416,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",417,{"inputs":[{"name":"self"}],"output":{"name":"passes"}}],[11,"hash","","",417,null],[11,"is_empty","","",417,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",403,{"inputs":[{"name":"self"}],"output":{"name":"codegenoptions"}}],[11,"clone","","",404,{"inputs":[{"name":"self"}],"output":{"name":"debuggingoptions"}}],[11,"clone","","",418,{"inputs":[{"name":"self"}],"output":{"name":"optionstability"}}],[11,"eq","","",418,{"inputs":[{"name":"self"},{"name":"optionstability"}],"output":{"name":"bool"}}],[11,"fmt","","",418,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"is_stable","","",405,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"stable","","",405,{"inputs":[{"name":"str"},{"name":"f"}],"output":{"name":"rustcoptgroup"}}],[11,"unstable","","",405,{"inputs":[{"name":"str"},{"name":"f"}],"output":{"name":"rustcoptgroup"}}],[11,"fmt","","",416,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[0,"filesearch","rustc::session","",null,null],[3,"FileSearch","rustc::session::filesearch","",null,null],[12,"sysroot","","",421,null],[12,"search_paths","","",421,null],[12,"triple","","",421,null],[12,"kind","","",421,null],[4,"FileMatch","","",null,null],[13,"FileMatches","","",422,null],[13,"FileDoesntMatch","","",422,null],[5,"relative_target_lib_path","","",null,{"inputs":[{"name":"path"},{"name":"str"}],"output":{"name":"pathbuf"}}],[5,"get_or_default_sysroot","","",null,{"inputs":[],"output":{"name":"pathbuf"}}],[11,"clone","","",422,{"inputs":[{"name":"self"}],"output":{"name":"filematch"}}],[11,"for_each_lib_search_path","","",421,{"inputs":[{"name":"self"},{"name":"f"}],"output":null}],[11,"get_lib_path","","",421,{"inputs":[{"name":"self"}],"output":{"name":"pathbuf"}}],[11,"search","","",421,{"inputs":[{"name":"self"},{"name":"f"}],"output":null}],[11,"new","","",421,{"inputs":[{"name":"path"},{"name":"str"},{"name":"searchpaths"},{"name":"pathkind"}],"output":{"name":"filesearch"}}],[11,"get_dylib_search_paths","","",421,{"inputs":[{"name":"self"}],"output":{"generics":["pathbuf"],"name":"vec"}}],[11,"get_tools_search_paths","","",421,{"inputs":[{"name":"self"}],"output":{"generics":["pathbuf"],"name":"vec"}}],[0,"search_paths","rustc::session","",null,null],[3,"SearchPaths","rustc::session::search_paths","",null,null],[3,"Iter","","",null,null],[4,"PathKind","","",null,null],[13,"Native","","",423,null],[13,"Crate","","",423,null],[13,"Dependency","","",423,null],[13,"Framework","","",423,null],[13,"ExternFlag","","",423,null],[13,"All","","",423,null],[11,"clone","","",424,{"inputs":[{"name":"self"}],"output":{"name":"searchpaths"}}],[11,"fmt","","",424,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",423,{"inputs":[{"name":"self"},{"name":"pathkind"}],"output":{"name":"bool"}}],[11,"clone","","",423,{"inputs":[{"name":"self"}],"output":{"name":"pathkind"}}],[11,"fmt","","",423,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"partial_cmp","","",423,{"inputs":[{"name":"self"},{"name":"pathkind"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"cmp","","",423,{"inputs":[{"name":"self"},{"name":"pathkind"}],"output":{"name":"ordering"}}],[11,"hash","","",423,null],[11,"new","","",424,{"inputs":[],"output":{"name":"searchpaths"}}],[11,"add_path","","",424,{"inputs":[{"name":"self"},{"name":"str"},{"name":"erroroutputtype"}],"output":null}],[11,"iter","","",424,{"inputs":[{"name":"self"},{"name":"pathkind"}],"output":{"name":"iter"}}],[11,"next","","",425,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",425,null],[6,"CompileResult","rustc::session","",null,null],[11,"clone","","",396,{"inputs":[{"name":"self"}],"output":{"name":"diagnosticmessageid"}}],[11,"fmt","","",396,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",396,{"inputs":[{"name":"self"},{"name":"diagnosticmessageid"}],"output":{"name":"bool"}}],[11,"ne","","",396,{"inputs":[{"name":"self"},{"name":"diagnosticmessageid"}],"output":{"name":"bool"}}],[11,"hash","","",396,null],[11,"from","","",396,{"inputs":[{"name":"lint"}],"output":{"name":"self"}}],[11,"local_crate_disambiguator","","",392,{"inputs":[{"name":"self"}],"output":{"name":"cratedisambiguator"}}],[11,"struct_span_warn","","",392,{"inputs":[{"name":"self"},{"name":"s"},{"name":"str"}],"output":{"name":"diagnosticbuilder"}}],[11,"struct_span_warn_with_code","","",392,{"inputs":[{"name":"self"},{"name":"s"},{"name":"str"},{"name":"diagnosticid"}],"output":{"name":"diagnosticbuilder"}}],[11,"struct_warn","","",392,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"diagnosticbuilder"}}],[11,"struct_span_err","","",392,{"inputs":[{"name":"self"},{"name":"s"},{"name":"str"}],"output":{"name":"diagnosticbuilder"}}],[11,"struct_span_err_with_code","","",392,{"inputs":[{"name":"self"},{"name":"s"},{"name":"str"},{"name":"diagnosticid"}],"output":{"name":"diagnosticbuilder"}}],[11,"struct_err","","",392,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"diagnosticbuilder"}}],[11,"struct_err_with_code","","",392,{"inputs":[{"name":"self"},{"name":"str"},{"name":"diagnosticid"}],"output":{"name":"diagnosticbuilder"}}],[11,"struct_span_fatal","","",392,{"inputs":[{"name":"self"},{"name":"s"},{"name":"str"}],"output":{"name":"diagnosticbuilder"}}],[11,"struct_span_fatal_with_code","","",392,{"inputs":[{"name":"self"},{"name":"s"},{"name":"str"},{"name":"diagnosticid"}],"output":{"name":"diagnosticbuilder"}}],[11,"struct_fatal","","",392,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"diagnosticbuilder"}}],[11,"span_fatal","","",392,null],[11,"span_fatal_with_code","","",392,null],[11,"fatal","","",392,null],[11,"span_err_or_warn","","",392,{"inputs":[{"name":"self"},{"name":"bool"},{"name":"s"},{"name":"str"}],"output":null}],[11,"span_err","","",392,{"inputs":[{"name":"self"},{"name":"s"},{"name":"str"}],"output":null}],[11,"span_err_with_code","","",392,{"inputs":[{"name":"self"},{"name":"s"},{"name":"str"},{"name":"diagnosticid"}],"output":null}],[11,"err","","",392,{"inputs":[{"name":"self"},{"name":"str"}],"output":null}],[11,"err_count","","",392,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"has_errors","","",392,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"abort_if_errors","","",392,{"inputs":[{"name":"self"}],"output":null}],[11,"compile_status","","",392,{"inputs":[{"name":"self"}],"output":{"generics":["compileincomplete"],"name":"result"}}],[11,"track_errors","","",392,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"generics":["errorreported"],"name":"result"}}],[11,"span_warn","","",392,{"inputs":[{"name":"self"},{"name":"s"},{"name":"str"}],"output":null}],[11,"span_warn_with_code","","",392,{"inputs":[{"name":"self"},{"name":"s"},{"name":"str"},{"name":"diagnosticid"}],"output":null}],[11,"warn","","",392,{"inputs":[{"name":"self"},{"name":"str"}],"output":null}],[11,"opt_span_warn","","",392,{"inputs":[{"name":"self"},{"name":"option"},{"name":"str"}],"output":null}],[11,"delay_span_bug","","Delay a span_bug() call until abort_if_errors()",392,{"inputs":[{"name":"self"},{"name":"s"},{"name":"str"}],"output":null}],[11,"note_without_error","","",392,{"inputs":[{"name":"self"},{"name":"str"}],"output":null}],[11,"span_note_without_error","","",392,{"inputs":[{"name":"self"},{"name":"s"},{"name":"str"}],"output":null}],[11,"span_unimpl","","",392,null],[11,"unimpl","","",392,null],[11,"buffer_lint","","",392,{"inputs":[{"name":"self"},{"name":"lint"},{"name":"nodeid"},{"name":"s"},{"name":"str"}],"output":null}],[11,"buffer_lint_with_diagnostic","","",392,{"inputs":[{"name":"self"},{"name":"lint"},{"name":"nodeid"},{"name":"s"},{"name":"str"},{"name":"builtinlintdiagnostics"}],"output":null}],[11,"reserve_node_ids","","",392,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"nodeid"}}],[11,"next_node_id","","",392,{"inputs":[{"name":"self"}],"output":{"name":"nodeid"}}],[11,"diagnostic","","",392,{"inputs":[{"name":"self"}],"output":{"name":"handler"}}],[11,"diag_span_note_once","","",392,{"inputs":[{"name":"self"},{"name":"diagnosticbuilder"},{"name":"diagnosticmessageid"},{"name":"span"},{"name":"str"}],"output":null}],[11,"diag_note_once","","",392,{"inputs":[{"name":"self"},{"name":"diagnosticbuilder"},{"name":"diagnosticmessageid"},{"name":"str"}],"output":null}],[11,"diag_span_suggestion_once","","",392,{"inputs":[{"name":"self"},{"name":"diagnosticbuilder"},{"name":"diagnosticmessageid"},{"name":"span"},{"name":"str"},{"name":"string"}],"output":null}],[11,"codemap","","",392,{"inputs":[{"name":"self"}],"output":{"name":"codemap"}}],[11,"verbose","","",392,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"time_passes","","",392,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"profile_queries","","",392,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"profile_queries_and_keys","","",392,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"count_llvm_insns","","",392,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"time_llvm_passes","","",392,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"trans_stats","","",392,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"meta_stats","","",392,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"asm_comments","","",392,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"no_verify","","",392,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"borrowck_stats","","",392,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"print_llvm_passes","","",392,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"features_untracked","","Get the features enabled for the current compilation session. DO NOT USE THIS METHOD if there is a TyCtxt available, as it circumvents dependency tracking. Use tcx.features() instead.",392,{"inputs":[{"name":"self"}],"output":{"generics":["features"],"name":"ref"}}],[11,"init_features","","",392,{"inputs":[{"name":"self"},{"name":"features"}],"output":null}],[11,"lto","","Calculates the flavor of LTO to use for this compilation.",392,{"inputs":[{"name":"self"}],"output":{"name":"lto"}}],[11,"panic_strategy","","Returns the panic strategy for this compile session. If the user explicitly selected one using '-C panic', use that, otherwise use the panic strategy defined by the target.",392,{"inputs":[{"name":"self"}],"output":{"name":"panicstrategy"}}],[11,"linker_flavor","","",392,{"inputs":[{"name":"self"}],"output":{"name":"linkerflavor"}}],[11,"fewer_names","","",392,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"no_landing_pads","","",392,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"unstable_options","","",392,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"nonzeroing_move_hints","","",392,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"overflow_checks","","",392,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"crt_static","","",392,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"crt_static_feature","","",392,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"must_not_eliminate_frame_pointers","","",392,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"generate_plugin_registrar_symbol","","Returns the symbol name for the registrar function, given the crate Svh and the function DefIndex.",392,{"inputs":[{"name":"self"},{"name":"cratedisambiguator"}],"output":{"name":"string"}}],[11,"generate_derive_registrar_symbol","","",392,{"inputs":[{"name":"self"},{"name":"cratedisambiguator"}],"output":{"name":"string"}}],[11,"sysroot","","",392,{"inputs":[{"name":"self"}],"output":{"name":"path"}}],[11,"target_filesearch","","",392,{"inputs":[{"name":"self"},{"name":"pathkind"}],"output":{"name":"filesearch"}}],[11,"host_filesearch","","",392,{"inputs":[{"name":"self"},{"name":"pathkind"}],"output":{"name":"filesearch"}}],[11,"set_incr_session_load_dep_graph","","",392,{"inputs":[{"name":"self"},{"name":"bool"}],"output":null}],[11,"incr_session_load_dep_graph","","",392,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"init_incr_comp_session","","",392,{"inputs":[{"name":"self"},{"name":"pathbuf"},{"name":"lock"},{"name":"bool"}],"output":null}],[11,"finalize_incr_comp_session","","",392,{"inputs":[{"name":"self"},{"name":"pathbuf"}],"output":null}],[11,"mark_incr_comp_session_as_invalid","","",392,{"inputs":[{"name":"self"}],"output":null}],[11,"incr_comp_session_dir","","",392,{"inputs":[{"name":"self"}],"output":{"generics":["pathbuf"],"name":"ref"}}],[11,"incr_comp_session_dir_opt","","",392,{"inputs":[{"name":"self"}],"output":{"generics":["ref"],"name":"option"}}],[11,"print_perf_stats","","",392,{"inputs":[{"name":"self"}],"output":null}],[11,"consider_optimizing","","We want to know if we're allowed to do an optimization for crate foo from -z fuel=foo=n. This expends fuel if applicable, and records fuel if applicable.",392,{"inputs":[{"name":"self"},{"name":"str"},{"name":"t"}],"output":{"name":"bool"}}],[11,"query_threads","","Returns the number of query threads that should be used for this compilation",392,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"codegen_units","","Returns the number of codegen units that should be used for this compilation",392,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"teach","","",392,{"inputs":[{"name":"self"},{"name":"diagnosticid"}],"output":{"name":"bool"}}],[11,"rust_2018","","Are we allowed to use features from the Rust 2018 edition?",392,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"edition","","",392,{"inputs":[{"name":"self"}],"output":{"name":"edition"}}],[11,"eq","","",426,{"inputs":[{"name":"self"},{"name":"cratedisambiguator"}],"output":{"name":"bool"}}],[11,"ne","","",426,{"inputs":[{"name":"self"},{"name":"cratedisambiguator"}],"output":{"name":"bool"}}],[11,"cmp","","",426,{"inputs":[{"name":"self"},{"name":"cratedisambiguator"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",426,{"inputs":[{"name":"self"},{"name":"cratedisambiguator"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",426,{"inputs":[{"name":"self"},{"name":"cratedisambiguator"}],"output":{"name":"bool"}}],[11,"le","","",426,{"inputs":[{"name":"self"},{"name":"cratedisambiguator"}],"output":{"name":"bool"}}],[11,"gt","","",426,{"inputs":[{"name":"self"},{"name":"cratedisambiguator"}],"output":{"name":"bool"}}],[11,"ge","","",426,{"inputs":[{"name":"self"},{"name":"cratedisambiguator"}],"output":{"name":"bool"}}],[11,"hash","","",426,null],[11,"fmt","","",426,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",426,{"inputs":[{"name":"self"}],"output":{"name":"cratedisambiguator"}}],[11,"encode","","",426,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",426,{"inputs":[{"name":"__d"}],"output":{"generics":["cratedisambiguator"],"name":"result"}}],[11,"to_fingerprint","","",426,{"inputs":[{"name":"self"}],"output":{"name":"fingerprint"}}],[11,"from","","",426,{"inputs":[{"name":"fingerprint"}],"output":{"name":"cratedisambiguator"}}],[11,"hash_stable","","",426,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"fmt","","",397,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",398,{"inputs":[{"name":"self"}],"output":{"name":"compileincomplete"}}],[11,"fmt","","",398,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"from","","",398,{"inputs":[{"name":"errorreported"}],"output":{"name":"compileincomplete"}}],[0,"traits","rustc","Trait Resolution. See [rustc guide] for more info on how this works.",null,null],[3,"OverlapResult","rustc::traits","",null,null],[12,"impl_header","","",427,null],[12,"intercrate_ambiguity_causes","","",427,null],[3,"FulfillmentContext","","The fulfillment context is used to drive trait resolution.  It consists of a list of obligations that must be (eventually) satisfied. The job is to track which are satisfied, which yielded errors, and which are still pending. At any point, users can call `select_where_possible`, and the fulfillment context will try to do selection, retaining only those obligations that remain ambiguous. This may be helpful in pushing type inference along. Once all type inference constraints have been generated, the method `select_all_or_error` can be used to report any remaining ambiguous cases as errors.",null,null],[3,"PendingPredicateObligation","","",null,null],[12,"obligation","","",428,null],[12,"stalled_on","","",428,null],[3,"MismatchedProjectionTypes","","",null,null],[12,"err","","",429,null],[3,"ProjectionCache","","The projection cache. Unlike the standard caches, this can include infcx-dependent type variables - therefore, we have to roll the cache back each time we roll a snapshot back, to avoid assumptions on yet-unresolved inference variables. Types with skolemized regions also have to be removed when the respective snapshot ends.",null,null],[3,"ProjectionCacheSnapshot","","",null,null],[3,"Normalized","","",null,null],[12,"value","","",430,null],[12,"obligations","","",430,null],[3,"OnUnimplementedDirective","","",null,null],[12,"condition","","",431,null],[12,"subcommands","","",431,null],[12,"message","","",431,null],[12,"label","","",431,null],[12,"note","","",431,null],[3,"OnUnimplementedNote","","",null,null],[12,"message","","",432,null],[12,"label","","",432,null],[12,"note","","",432,null],[3,"EvaluationCache","","",null,null],[3,"SelectionContext","","",null,null],[3,"SelectionCache","","",null,null],[3,"OverlapError","","Information pertinent to an overlapping impl error.",null,null],[12,"with_impl","","",433,null],[12,"trait_desc","","",433,null],[12,"self_desc","","",433,null],[12,"intercrate_ambiguity_causes","","",433,null],[3,"SpecializesCache","","",null,null],[3,"SupertraitDefIds","","",null,null],[3,"Obligation","","An `Obligation` represents some trait reference (e.g. `int:Eq`) for which the vtable must be found.  The process of finding a vtable is called \"resolving\" the `Obligation`. This process consists of either identifying an `impl` (e.g., `impl Eq for int`) that provides the required vtable, or else finding a bound that is in scope. The eventual result is usually a `Selection` (defined below).",null,null],[12,"cause","","Why do we have to prove this thing?",434,null],[12,"param_env","","In which environment should we prove this thing?",434,null],[12,"predicate","","What are we trying to prove?",434,null],[12,"recursion_depth","","If we started proving this as a result of trying to prove something else, track the total depth to ensure termination. If this goes over a certain threshold, we abort compilation -- in such cases, we can not say whether or not the predicate holds for certain. Stupid halting problem. Such a drag.",434,null],[3,"ObligationCause","","Why did we incur this obligation? Used for error reporting.",null,null],[12,"span","","",435,null],[12,"body_id","","",435,null],[12,"code","","",435,null],[3,"DerivedObligationCause","","",null,null],[3,"FulfillmentError","","",null,null],[12,"obligation","","",436,null],[12,"code","","",436,null],[3,"VtableImplData","","Identifies a particular impl in the source, along with a set of substitutions from the impl's type/lifetime parameters. The `nested` vector corresponds to the nested obligations attached to the impl's type parameters.",null,null],[12,"impl_def_id","","",437,null],[12,"substs","","",437,null],[12,"nested","","",437,null],[3,"VtableGeneratorData","","",null,null],[12,"closure_def_id","","",438,null],[12,"substs","","",438,null],[12,"nested","","Nested obligations. This can be non-empty if the generator signature contains associated types.",438,null],[3,"VtableClosureData","","",null,null],[12,"closure_def_id","","",439,null],[12,"substs","","",439,null],[12,"nested","","Nested obligations. This can be non-empty if the closure signature contains associated types.",439,null],[3,"VtableAutoImplData","","",null,null],[12,"trait_def_id","","",440,null],[12,"nested","","",440,null],[3,"VtableBuiltinData","","",null,null],[12,"nested","","",441,null],[3,"VtableObjectData","","A vtable for some object-safe trait `Foo` automatically derived for the object type `Foo`.",null,null],[12,"upcast_trait_ref","","`Foo` upcast to the obligation trait. This will be some supertrait of `Foo`.",442,null],[12,"vtable_base","","The vtable is formed by concatenating together the method lists of the base object trait and all supertraits; this is the start of `upcast_trait_ref`'s methods in that vtable.",442,null],[12,"nested","","",442,null],[3,"VtableFnPointerData","","",null,null],[12,"fn_ty","","",443,null],[12,"nested","","",443,null],[4,"OrphanCheckErr","","",null,null],[13,"NoLocalInputType","","",444,null],[13,"UncoveredTy","","",444,null],[4,"Reveal","","Depending on the stage of compilation, we want projection to be more or less conservative.",null,null],[13,"UserFacing","","At type-checking time, we refuse to project any associated type that is marked `default`. Non-`default` (\"final\") types are always projected. This is necessary in general for soundness of specialization. However, we could allow projections in fully-monomorphic cases. We choose not to, because we prefer for `default type` to force the type definition to be treated abstractly by any consumers of the impl. Concretely, that means that the following example will fail to compile:",445,null],[13,"All","","At trans time, all monomorphic projections will succeed. Also, `impl Trait` is normalized to the concrete type, which has to be already collected by type-checking.",445,null],[4,"ObjectSafetyViolation","","",null,null],[13,"SizedSelf","","Self : Sized declared on the trait",446,null],[13,"SupertraitSelf","","Supertrait reference references `Self` an in illegal location (e.g. `trait Foo : Bar<Self>`)",446,null],[13,"Method","","Method has something illegal",446,null],[13,"AssociatedConst","","Associated const",446,null],[4,"MethodViolationCode","","Reasons a method might not be object-safe.",null,null],[13,"StaticMethod","","e.g., `fn foo()`",447,null],[13,"ReferencesSelf","","e.g., `fn foo(&self, x: Self)` or `fn foo(&self) -> Self`",447,null],[13,"Generic","","e.g., `fn foo<A>()`",447,null],[13,"NonStandardSelfType","","arbitrary `self` type, e.g. `self: Rc<Self>`",447,null],[4,"IntercrateAmbiguityCause","","",null,null],[13,"DownstreamCrate","","",448,null],[12,"trait_desc","rustc::traits::IntercrateAmbiguityCause","",448,null],[12,"self_desc","","",448,null],[13,"UpstreamCrateUpdate","rustc::traits","",448,null],[12,"trait_desc","rustc::traits::IntercrateAmbiguityCause","",448,null],[12,"self_desc","","",448,null],[4,"IntercrateMode","rustc::traits","",null,null],[13,"Issue43355","","",449,null],[13,"Fixed","","",449,null],[4,"ObligationCauseCode","","",null,null],[13,"MiscObligation","","Not well classified or should be obvious from span.",450,null],[13,"SliceOrArrayElem","","A slice or array is WF only if `T: Sized`",450,null],[13,"TupleElem","","A tuple is WF only if its middle elements are Sized",450,null],[13,"ProjectionWf","","This is the trait reference from the given projection",450,null],[13,"ItemObligation","","In an impl of trait X for type Y, type Y must also implement all supertraits of X.",450,null],[13,"ReferenceOutlivesReferent","","A type like `&'a T` is WF only if `T: 'a`.",450,null],[13,"ObjectTypeBound","","A type like `Box<Foo<'a> + 'b>` is WF only if `'b: 'a`.",450,null],[13,"ObjectCastObligation","","Obligation incurred due to an object cast.",450,null],[13,"AssignmentLhsSized","","L = X implies that L is Sized",450,null],[13,"TupleInitializerSized","","(x1, .., xn) must be Sized",450,null],[13,"StructInitializerSized","","S { ... } must be Sized",450,null],[13,"VariableType","","Type of each variable must be Sized",450,null],[13,"SizedReturnType","","Return type must be Sized",450,null],[13,"SizedYieldType","","Yield type must be Sized",450,null],[13,"RepeatVec","","[T,..n] --> T must be Copy",450,null],[13,"FieldSized","","Types of fields (other than the last) in a struct must be sized.",450,null],[13,"ConstSized","","Constant expressions must be sized.",450,null],[13,"SharedStatic","","static items must have `Sync` type",450,null],[13,"BuiltinDerivedObligation","","",450,null],[13,"ImplDerivedObligation","","",450,null],[13,"CompareImplMethodObligation","","error derived when matching traits/impls; see ObligationCause for more details",450,null],[12,"item_name","rustc::traits::ObligationCauseCode","",450,null],[12,"impl_item_def_id","","",450,null],[12,"trait_item_def_id","","",450,null],[13,"ExprAssignable","rustc::traits","Checking that this expression can be assigned where it needs to be",450,null],[13,"MatchExpressionArm","","Computing common supertype in the arms of a match expression",450,null],[12,"arm_span","rustc::traits::ObligationCauseCode","",450,null],[12,"source","","",450,null],[13,"IfExpression","rustc::traits","Computing common supertype in an if expression",450,null],[13,"IfExpressionWithNoElse","","Computing common supertype of an if expression with no else counter-part",450,null],[13,"MainFunctionType","","`main` has wrong type",450,null],[13,"StartFunctionType","","`start` has wrong type",450,null],[13,"IntrinsicType","","intrinsic has wrong type",450,null],[13,"MethodReceiver","","method receiver",450,null],[13,"ReturnNoExpression","","`return` with no expression",450,null],[13,"ReturnType","","`return` with an expression",450,null],[13,"BlockTailExpression","","Block implicit return",450,null],[4,"WhereClauseAtom","","The following types: * `WhereClauseAtom` * `DomainGoal` * `Goal` * `Clause` are used for representing the trait system in the form of logic programming clauses. They are part of the interface for the chalk SLG solver.",null,null],[13,"Implemented","","",451,null],[13,"ProjectionEq","","",451,null],[4,"DomainGoal","","",null,null],[13,"Holds","","",452,null],[13,"WellFormed","","",452,null],[13,"FromEnv","","",452,null],[13,"WellFormedTy","","",452,null],[13,"FromEnvTy","","",452,null],[13,"RegionOutlives","","",452,null],[13,"TypeOutlives","","",452,null],[4,"QuantifierKind","","",null,null],[13,"Universal","","",453,null],[13,"Existential","","",453,null],[4,"Goal","","",null,null],[13,"Implies","","",454,null],[13,"And","","",454,null],[13,"Not","","",454,null],[13,"DomainGoal","","",454,null],[13,"Quantified","","",454,null],[4,"Clause","","This matches the definition from Page 7 of \"A Proof Procedure for the Logic of Hereditary Harrop Formulas\".",null,null],[13,"Implies","","",455,null],[13,"DomainGoal","","",455,null],[13,"ForAll","","",455,null],[4,"SelectionError","","",null,null],[13,"Unimplemented","","",456,null],[13,"OutputTypeParameterMismatch","","",456,null],[13,"TraitNotObjectSafe","","",456,null],[13,"ConstEvalFailure","","",456,null],[4,"FulfillmentErrorCode","","",null,null],[13,"CodeSelectionError","","",457,null],[13,"CodeProjectionError","","",457,null],[13,"CodeSubtypeError","","",457,null],[13,"CodeAmbiguity","","",457,null],[4,"Vtable","","Given the successful resolution of an obligation, the `Vtable` indicates where the vtable comes from. Note that while we call this a \"vtable\", it does not necessarily indicate dynamic dispatch at runtime. `Vtable` instances just tell the compiler where to find methods, but in generic code those methods are typically statically dispatched -- only when an object is constructed is a `Vtable` instance reified into an actual vtable.",null,null],[13,"VtableImpl","","Vtable identifying a particular impl.",458,null],[13,"VtableAutoImpl","","Vtable for auto trait implementations This carries the information and nested obligations with regards to an auto implementation for a trait `Trait`. The nested obligations ensure the trait implementation holds for all the constituent types.",458,null],[13,"VtableParam","","Successful resolution to an obligation provided by the caller for some type parameter. The `Vec<N>` represents the obligations incurred from normalizing the where-clause (if any).",458,null],[13,"VtableObject","","Virtual calls through an object",458,null],[13,"VtableBuiltin","","Successful resolution for a builtin trait.",458,null],[13,"VtableClosure","","Vtable automatically generated for a closure. The def ID is the ID of the closure expression. This is a `VtableImpl` in spirit, but the impl is generated by the compiler and does not appear in the source.",458,null],[13,"VtableFnPointer","","Same as above, but for a fn pointer type with the given signature.",458,null],[13,"VtableGenerator","","Vtable automatically generated for a generator",458,null],[5,"orphan_check","","Checks the coherence orphan rules. `impl_def_id` should be the def-id of a trait impl. To pass, either the trait must be local, or else two conditions must be satisfied:",null,{"inputs":[{"name":"tyctxt"},{"name":"defid"}],"output":{"generics":["orphancheckerr"],"name":"result"}}],[5,"overlapping_impls","","If there are types that satisfy both impls, invokes `on_overlap` with a suitably-freshened `ImplHeader` with those types substituted. Otherwise, invokes `no_overlap`.",null,{"inputs":[{"name":"tyctxt"},{"name":"defid"},{"name":"defid"},{"name":"intercratemode"},{"name":"f1"},{"name":"f2"}],"output":{"name":"r"}}],[5,"normalize","","Normalizes any associated type projections in `value`, replacing them with a fully resolved type where possible. The return value combines the normalized result and any additional obligations that were incurred as result.",null,{"inputs":[{"name":"selectioncontext"},{"name":"paramenv"},{"name":"obligationcause"},{"name":"t"}],"output":{"name":"normalized"}}],[5,"normalize_projection_type","","The guts of `normalize`: normalize a specific projection like `<T as Trait>::Item`. The result is always a type (and possibly additional obligations). If ambiguity arises, which implies that there are unresolved type variables in the projection, we will substitute a fresh type variable `$X` and generate a new obligation `<T as Trait>::Item == $X` for later.",null,{"inputs":[{"name":"selectioncontext"},{"name":"paramenv"},{"name":"projectionty"},{"name":"obligationcause"},{"name":"usize"}],"output":{"generics":["ty"],"name":"normalized"}}],[5,"poly_project_and_unify_type","","Evaluates constraints of the form:",null,{"inputs":[{"name":"selectioncontext"},{"name":"obligation"}],"output":{"generics":["option","mismatchedprojectiontypes"],"name":"result"}}],[5,"translate_substs","","Given a subst for the requested impl, translate it to a subst appropriate for the actual item definition (whether it be in that impl, a parent impl, or the trait).",null,{"inputs":[{"name":"inferctxt"},{"name":"paramenv"},{"name":"defid"},{"name":"substs"},{"name":"node"}],"output":{"name":"substs"}}],[5,"find_associated_item","","Given a selected impl described by `impl_data`, returns the definition and substitutions for the method with the name `name` the kind `kind`, and trait method substitutions `substs`, in that impl, a less specialized impl, or the trait default, whichever applies.",null,null],[5,"elaborate_predicates","","",null,{"inputs":[{"name":"tyctxt"},{"generics":["predicate"],"name":"vec"}],"output":{"name":"elaborator"}}],[5,"supertraits","","",null,{"inputs":[{"name":"tyctxt"},{"name":"polytraitref"}],"output":{"name":"supertraits"}}],[5,"supertrait_def_ids","","",null,{"inputs":[{"name":"tyctxt"},{"name":"defid"}],"output":{"name":"supertraitdefids"}}],[5,"transitive_bounds","","",null,null],[5,"predicates_for_generics","","Creates predicate obligations from the generic bounds.",null,{"inputs":[{"name":"obligationcause"},{"name":"paramenv"},{"name":"instantiatedpredicates"}],"output":{"name":"predicateobligations"}}],[5,"type_known_to_meet_bound","","Determines whether the type `ty` is known to meet `bound` and returns true if so. Returns false if `ty` either does not meet `bound` or is not known to meet bound (note that this is conservative towards no impl, which is the opposite of the `evaluate` methods).",null,{"inputs":[{"name":"inferctxt"},{"name":"paramenv"},{"name":"ty"},{"name":"defid"},{"name":"span"}],"output":{"name":"bool"}}],[5,"normalize_param_env_or_error","","Normalizes the parameter environment, reporting errors if they occur.",null,{"inputs":[{"name":"tyctxt"},{"name":"defid"},{"name":"paramenv"},{"name":"obligationcause"}],"output":{"name":"paramenv"}}],[5,"fully_normalize","","",null,{"inputs":[{"name":"inferctxt"},{"name":"obligationcause"},{"name":"paramenv"},{"name":"t"}],"output":{"generics":["vec"],"name":"result"}}],[5,"fully_normalize_with_fulfillcx","","",null,{"inputs":[{"name":"inferctxt"},{"name":"fulfillmentcontext"},{"name":"obligationcause"},{"name":"paramenv"},{"name":"t"}],"output":{"generics":["vec"],"name":"result"}}],[5,"provide","","",null,{"inputs":[{"name":"providers"}],"output":null}],[0,"specialization_graph","","",null,null],[3,"Graph","rustc::traits::specialization_graph","A per-trait graph of impls in specialization order. At the moment, this graph forms a tree rooted with the trait itself, with all other nodes representing impls, and parent-child relationships representing specializations.",null,null],[3,"Ancestors","","",null,null],[3,"NodeItem","","",null,null],[12,"node","","",459,null],[12,"item","","",459,null],[4,"Node","","A node in the specialization graph is either an impl or a trait definition; either can serve as a source of item definitions. There is always exactly one trait definition node: the root.",null,null],[13,"Impl","","",460,null],[13,"Trait","","",460,null],[5,"ancestors","","Walk up the specialization ancestors of a given impl, starting with that impl itself.",null,{"inputs":[{"name":"tyctxt"},{"name":"defid"},{"name":"defid"}],"output":{"name":"ancestors"}}],[0,"error_reporting","rustc::traits","",null,null],[4,"ArgKind","rustc::traits::error_reporting","Summarizes information",null,null],[13,"Arg","","An argument of non-tuple type. Parameters are (name, ty)",461,null],[13,"Tuple","","An argument of tuple type. For a \"found\" argument, the span is the locationo in the source of the pattern. For a \"expected\" argument, it will be None. The vector is a list of (name, ty) strings for the components of the tuple.",461,null],[11,"report_fulfillment_errors","rustc::infer","",173,{"inputs":[{"name":"self"},{"name":"vec"},{"generics":["bodyid"],"name":"option"},{"name":"bool"}],"output":null}],[11,"report_overflow_error","","Reports that an overflow has occurred and halts compilation. We halt compilation unconditionally because it is important that overflows never be masked -- they basically represent computations whose result could not be truly determined and thus we can't say if the program type checks or not -- and they are unusual occurrences in any case.",173,null],[11,"report_overflow_error_cycle","","Reports that a cycle was detected which led to overflow and halts compilation. This is equivalent to `report_overflow_error` except that we can give a more helpful error message (and, in particular, we do not suggest increasing the overflow limit, which is not going to help).",173,null],[11,"report_extra_impl_obligation","","",173,{"inputs":[{"name":"self"},{"name":"span"},{"name":"name"},{"name":"defid"},{"name":"defid"},{"name":"display"}],"output":{"name":"diagnosticbuilder"}}],[11,"report_selection_error","","",173,{"inputs":[{"name":"self"},{"name":"predicateobligation"},{"name":"selectionerror"},{"name":"bool"}],"output":null}],[11,"get_fn_like_arguments","","Given some node representing a fn-like thing in the HIR map, returns a span and `ArgKind` information that describes the arguments it expects. This can be supplied to `report_arg_count_mismatch`.",173,null],[11,"report_arg_count_mismatch","","Reports an error when the number of arguments needed by a trait match doesn't match the number that the expression provides.",173,{"inputs":[{"name":"self"},{"name":"span"},{"generics":["span"],"name":"option"},{"generics":["argkind"],"name":"vec"},{"generics":["argkind"],"name":"vec"},{"name":"bool"}],"output":{"name":"diagnosticbuilder"}}],[11,"from_expected_ty","rustc::traits::error_reporting","Creates an `ArgKind` from the expected type of an argument. This has no name (`_`) and no source spans..",461,{"inputs":[{"name":"ty"}],"output":{"name":"argkind"}}],[11,"as_predicate","rustc::traits","",428,null],[11,"clone","","",428,{"inputs":[{"name":"self"}],"output":{"name":"pendingpredicateobligation"}}],[11,"fmt","","",428,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new fulfillment context.",462,{"inputs":[],"output":{"name":"fulfillmentcontext"}}],[11,"new_ignoring_regions","","",462,{"inputs":[],"output":{"name":"fulfillmentcontext"}}],[11,"register_predicate_obligations","","",462,{"inputs":[{"name":"self"},{"name":"inferctxt"},{"name":"i"}],"output":null}],[11,"normalize_projection_type","","\"Normalize\" a projection type `<SomeType as SomeTrait>::X` by creating a fresh type variable `$0` as well as a projection predicate `<SomeType as SomeTrait>::X == $0`. When the inference engine runs, it will attempt to find an impl of `SomeTrait` or a where clause that lets us unify `$0` with something concrete. If this fails, we'll unify `$0` with `projection_ty` again.",462,{"inputs":[{"name":"self"},{"name":"inferctxt"},{"name":"paramenv"},{"name":"projectionty"},{"name":"obligationcause"}],"output":{"name":"ty"}}],[11,"register_bound","","Requires that `ty` must implement the trait with `def_id` in the given environment. This trait must not have any type parameters (except for `Self`).",462,{"inputs":[{"name":"self"},{"name":"inferctxt"},{"name":"paramenv"},{"name":"ty"},{"name":"defid"},{"name":"obligationcause"}],"output":null}],[11,"register_predicate_obligation","","",462,{"inputs":[{"name":"self"},{"name":"inferctxt"},{"name":"predicateobligation"}],"output":null}],[11,"select_all_or_error","","",462,{"inputs":[{"name":"self"},{"name":"inferctxt"}],"output":{"generics":["vec"],"name":"result"}}],[11,"select_where_possible","","",462,{"inputs":[{"name":"self"},{"name":"inferctxt"}],"output":{"generics":["vec"],"name":"result"}}],[11,"pending_obligations","","",462,{"inputs":[{"name":"self"}],"output":{"generics":["pendingpredicateobligation"],"name":"vec"}}],[11,"fmt","","",445,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",445,{"inputs":[{"name":"self"}],"output":{"name":"reveal"}}],[11,"eq","","",445,{"inputs":[{"name":"self"},{"name":"reveal"}],"output":{"name":"bool"}}],[11,"hash","","",445,null],[11,"clone","","",429,{"inputs":[{"name":"self"}],"output":{"name":"mismatchedprojectiontypes"}}],[11,"clone","","",430,{"inputs":[{"name":"self"}],"output":{"name":"normalized"}}],[11,"with","","",430,{"inputs":[{"name":"self"},{"name":"u"}],"output":{"name":"normalized"}}],[11,"new","","",463,{"inputs":[],"output":{"name":"self"}}],[11,"clear","","",463,{"inputs":[{"name":"self"}],"output":null}],[11,"snapshot","","",463,{"inputs":[{"name":"self"}],"output":{"name":"projectioncachesnapshot"}}],[11,"rollback_to","","",463,{"inputs":[{"name":"self"},{"name":"projectioncachesnapshot"}],"output":null}],[11,"rollback_skolemized","","",463,{"inputs":[{"name":"self"},{"name":"projectioncachesnapshot"}],"output":null}],[11,"commit","","",463,{"inputs":[{"name":"self"},{"name":"projectioncachesnapshot"}],"output":null}],[11,"complete","","Mark the relevant projection cache key as having its derived obligations complete, so they won't have to be re-computed (this is OK to do in a snapshot - if the snapshot is rolled back, the obligations will be marked as incomplete again).",463,{"inputs":[{"name":"self"},{"name":"projectioncachekey"}],"output":null}],[11,"clone","","",446,{"inputs":[{"name":"self"}],"output":{"name":"objectsafetyviolation"}}],[11,"fmt","","",446,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",446,{"inputs":[{"name":"self"},{"name":"objectsafetyviolation"}],"output":{"name":"bool"}}],[11,"ne","","",446,{"inputs":[{"name":"self"},{"name":"objectsafetyviolation"}],"output":{"name":"bool"}}],[11,"hash","","",446,null],[11,"error_msg","","",446,{"inputs":[{"name":"self"}],"output":{"generics":["str"],"name":"cow"}}],[11,"clone","","",447,{"inputs":[{"name":"self"}],"output":{"name":"methodviolationcode"}}],[11,"fmt","","",447,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",447,{"inputs":[{"name":"self"},{"name":"methodviolationcode"}],"output":{"name":"bool"}}],[11,"hash","","",447,null],[11,"fmt","","",431,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"empty","","",432,{"inputs":[],"output":{"name":"self"}}],[11,"parse","","",431,null],[11,"of_item","","",431,{"inputs":[{"name":"tyctxt"},{"name":"defid"},{"name":"defid"}],"output":{"generics":["option","errorreported"],"name":"result"}}],[11,"evaluate","","",431,null],[11,"clone","","",448,{"inputs":[{"name":"self"}],"output":{"name":"intercrateambiguitycause"}}],[11,"fmt","","",448,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"add_intercrate_ambiguity_hint","","Emits notes when the overlap is caused by complex intercrate ambiguities. See #23980 for details.",448,{"inputs":[{"name":"self"},{"name":"diagnosticbuilder"}],"output":null}],[11,"intercrate_ambiguity_hint","","",448,{"inputs":[{"name":"self"}],"output":{"name":"string"}}],[11,"clone","","",464,{"inputs":[{"name":"self"}],"output":{"name":"selectioncache"}}],[11,"clone","","",465,{"inputs":[{"name":"self"}],"output":{"name":"evaluationcache"}}],[11,"new","","",466,{"inputs":[{"name":"inferctxt"}],"output":{"name":"selectioncontext"}}],[11,"intercrate","","",466,{"inputs":[{"name":"inferctxt"},{"name":"intercratemode"}],"output":{"name":"selectioncontext"}}],[11,"with_negative","","",466,{"inputs":[{"name":"inferctxt"},{"name":"bool"}],"output":{"name":"selectioncontext"}}],[11,"enable_tracking_intercrate_ambiguity_causes","","Enables tracking of intercrate ambiguity causes. These are used in coherence to give improved diagnostics. We don't do this until we detect a coherence error because it can lead to false overflow results (#47139) and because it costs computation time.",466,{"inputs":[{"name":"self"}],"output":null}],[11,"take_intercrate_ambiguity_causes","","Gets the intercrate ambiguity causes collected since tracking was enabled and disables tracking at the same time. If tracking is not enabled, just returns an empty vector.",466,{"inputs":[{"name":"self"}],"output":{"generics":["intercrateambiguitycause"],"name":"vec"}}],[11,"infcx","","",466,{"inputs":[{"name":"self"}],"output":{"name":"inferctxt"}}],[11,"tcx","","",466,{"inputs":[{"name":"self"}],"output":{"name":"tyctxt"}}],[11,"closure_typer","","",466,{"inputs":[{"name":"self"}],"output":{"name":"inferctxt"}}],[11,"select","","Attempts to satisfy the obligation. If successful, this will affect the surrounding type environment by performing unification.",466,{"inputs":[{"name":"self"},{"name":"traitobligation"}],"output":{"generics":["selection"],"name":"selectionresult"}}],[11,"evaluate_obligation","","Evaluates whether the obligation `obligation` can be satisfied (by any means).",466,{"inputs":[{"name":"self"},{"name":"predicateobligation"}],"output":{"name":"bool"}}],[11,"evaluate_obligation_conservatively","","Evaluates whether the obligation `obligation` can be satisfied, and returns `false` if not certain. However, this is not entirely accurate if inference variables are involved.",466,{"inputs":[{"name":"self"},{"name":"predicateobligation"}],"output":{"name":"bool"}}],[11,"coinductive_match","","For defaulted traits, we use a co-inductive strategy to solve, so that recursion is ok. This routine returns true if the top of the stack (`cycle[0]`):",466,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"bool"}}],[11,"new","","",464,{"inputs":[],"output":{"name":"selectioncache"}}],[11,"clear","","",464,{"inputs":[{"name":"self"}],"output":null}],[11,"new","","",465,{"inputs":[],"output":{"name":"evaluationcache"}}],[11,"clear","","",465,{"inputs":[{"name":"self"}],"output":null}],[11,"encode","rustc::traits::specialization_graph","",467,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",467,{"inputs":[{"name":"__d"}],"output":{"generics":["graph"],"name":"result"}}],[11,"new","","",467,{"inputs":[],"output":{"name":"graph"}}],[11,"insert","","Insert a local impl into the specialization graph. If an existing impl conflicts with it (has overlap, but neither specializes the other), information about the area of overlap is returned in the `Err`.",467,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"defid"}],"output":{"generics":["option","overlaperror"],"name":"result"}}],[11,"record_impl_from_cstore","","Insert cached metadata mapping from a child impl back to its parent.",467,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"defid"},{"name":"defid"}],"output":null}],[11,"parent","","The parent of a given impl, which is the def id of the trait when the impl is a \"specialization root\".",467,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"defid"}}],[11,"fmt","","",460,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",460,{"inputs":[{"name":"self"}],"output":{"name":"node"}}],[11,"is_from_trait","","",460,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"items","","Iterate over the items defined directly by the given (impl or trait) node.",460,null],[11,"def_id","","",460,{"inputs":[{"name":"self"}],"output":{"name":"defid"}}],[11,"next","","",468,{"inputs":[{"name":"self"}],"output":{"generics":["node"],"name":"option"}}],[11,"map","","",459,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"nodeitem"}}],[11,"defs","","Search the items from the given ancestors, returning each definition with the given name and the given kind.",468,null],[11,"hash_stable","","",467,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"new","rustc::traits","",469,{"inputs":[],"output":{"name":"self"}}],[11,"check","","",469,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"defid"}],"output":{"generics":["bool"],"name":"option"}}],[11,"insert","","",469,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"defid"},{"name":"bool"}],"output":null}],[11,"fmt","","",430,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",434,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",458,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",437,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",438,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",439,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",441,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",440,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",442,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",443,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",436,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",457,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",429,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"lift_to_tcx","","",456,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","","",450,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","","",470,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","","",435,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","","",458,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"super_fold_with","","",434,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"self"}}],[11,"super_visit_with","","",434,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",437,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",437,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",438,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",438,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",439,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",439,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",440,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",440,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",441,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",441,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",442,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",442,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",443,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",443,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",458,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",458,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",430,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",430,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"fmt","","",451,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",452,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",453,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",454,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",455,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"super_fold_with","","",451,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",451,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",452,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",452,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",453,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"quantifierkind"}}],[11,"super_visit_with","","",453,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",454,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",454,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",455,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",455,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[0,"trans","","",null,null],[3,"TraitSelectionCache","rustc::traits::trans","",null,null],[3,"ProjectionCache","","",null,null],[5,"trans_fulfill_obligation","","Attempts to resolve an obligation to a vtable.. The result is a shallow vtable resolution -- meaning that we do not (necessarily) resolve all nested obligations on the impl. Note that type check should guarantee to us that all nested obligations could be resolved if we wanted to. Assumes that this is run after the entire crate has been successfully type-checked.",null,null],[11,"to_dep_kind","","",471,{"inputs":[],"output":{"name":"depkind"}}],[11,"to_dep_kind","","",472,{"inputs":[],"output":{"name":"depkind"}}],[11,"next","rustc::traits","",473,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[0,"query","","Experimental types for the trait query interface. The methods defined in this module are all based on canonicalization, which makes a canonical query by replacing unbound inference variables and regions, so that results can be reused more broadly. The providers for the queries defined here can be found in `librustc_traits`.",null,null],[3,"NoSolution","rustc::traits::query","",null,null],[0,"dropck_outlives","","",null,null],[3,"DropckOutlivesResult","rustc::traits::query::dropck_outlives","",null,null],[12,"kinds","","",474,null],[12,"overflows","","",474,null],[3,"DtorckConstraint","","A set of constraints that need to be satisfied in order for a type to be valid for destruction.",null,null],[12,"outlives","","Types that are required to be alive in order for this type to be valid for destruction.",475,null],[12,"dtorck_types","","Types that could not be resolved: projections and params.",475,null],[12,"overflows","","If, during the computation of the dtorck constraint, we overflow, that gets recorded here. The caller is expected to report an error.",475,null],[11,"dropck_outlives","rustc::infer::at","Given a type `ty` of some value being dropped, computes a set of \"kinds\" (types, regions) that must be outlive the execution of the destructor. These basically correspond to data that the destructor might access. This is used during regionck to impose \"outlives\" constraints on any lifetimes referenced within.",183,{"inputs":[{"name":"self"},{"name":"ty"}],"output":{"generics":["vec"],"name":"inferok"}}],[11,"clone","rustc::traits::query::dropck_outlives","",474,{"inputs":[{"name":"self"}],"output":{"name":"dropckoutlivesresult"}}],[11,"fmt","","",474,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",475,{"inputs":[{"name":"self"}],"output":{"name":"dtorckconstraint"}}],[11,"fmt","","",475,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"empty","","",475,{"inputs":[],"output":{"name":"dtorckconstraint"}}],[11,"from_iter","","",475,{"inputs":[{"name":"i"}],"output":{"name":"self"}}],[11,"super_fold_with","","",474,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",474,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"lift_to_tcx","","",474,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"generics":["dropckoutlivesresult"],"name":"option"}}],[11,"hash_stable","","",474,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"intern","rustc::infer::canonical","",189,null],[11,"hash_stable","rustc::traits::query::dropck_outlives","",475,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[0,"normalize","rustc::traits::query","Code for the 'normalization' query. This consists of a wrapper which folds deeply, invoking the underlying `normalize_projection_ty` query when it encounters projections.",null,null],[3,"NormalizationResult","rustc::traits::query::normalize","Result from the `normalize_projection_ty` query.",null,null],[12,"normalized_ty","","Result of normalization.",476,null],[11,"normalize","rustc::infer::at","Normalize `value` in the context of the inference context, yielding a resulting type, or an error if `value` cannot be normalized. If you don't care about regions, you should prefer `normalize_erasing_regions`, which is more efficient.",183,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"generics":["normalized","nosolution"],"name":"result"}}],[11,"clone","rustc::traits::query::normalize","",476,{"inputs":[{"name":"self"}],"output":{"name":"normalizationresult"}}],[11,"fmt","","",476,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"super_fold_with","","",476,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",476,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"lift_to_tcx","","",476,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"generics":["normalizationresult"],"name":"option"}}],[11,"intern","rustc::infer::canonical","",189,null],[11,"hash_stable","rustc::traits::query::normalize","",476,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[0,"normalize_erasing_regions","rustc::traits::query","Methods for normalizing when you don't care about regions (and aren't doing type inference). If either of those things don't apply to you, use `infcx.normalize(...)`.",null,null],[6,"CanonicalProjectionGoal","","",null,null],[6,"CanonicalTyGoal","","",null,null],[6,"Fallible","","",null,null],[11,"clone","","",477,{"inputs":[{"name":"self"}],"output":{"name":"nosolution"}}],[11,"fmt","","",477,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",477,{"inputs":[{"name":"self"},{"name":"nosolution"}],"output":{"name":"bool"}}],[11,"hash","","",477,null],[11,"hash_stable","","",477,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[6,"Supertraits","rustc::traits","",null,null],[6,"PredicateObligation","","",null,null],[6,"TraitObligation","","",null,null],[6,"Obligations","","",null,null],[6,"PredicateObligations","","",null,null],[6,"TraitObligations","","",null,null],[6,"Selection","","",null,null],[6,"SelectionResult","","When performing resolution, it is typically the case that there can be one of three outcomes:",null,null],[8,"TraitEngine","","",null,null],[10,"normalize_projection_type","","",478,{"inputs":[{"name":"self"},{"name":"inferctxt"},{"name":"paramenv"},{"name":"projectionty"},{"name":"obligationcause"}],"output":{"name":"ty"}}],[10,"register_bound","","",478,{"inputs":[{"name":"self"},{"name":"inferctxt"},{"name":"paramenv"},{"name":"ty"},{"name":"defid"},{"name":"obligationcause"}],"output":null}],[10,"register_predicate_obligation","","",478,{"inputs":[{"name":"self"},{"name":"inferctxt"},{"name":"predicateobligation"}],"output":null}],[10,"select_all_or_error","","",478,{"inputs":[{"name":"self"},{"name":"inferctxt"}],"output":{"generics":["vec"],"name":"result"}}],[10,"select_where_possible","","",478,{"inputs":[{"name":"self"},{"name":"inferctxt"}],"output":{"generics":["vec"],"name":"result"}}],[10,"pending_obligations","","",478,{"inputs":[{"name":"self"}],"output":{"generics":["pendingpredicateobligation"],"name":"vec"}}],[11,"clone","","",449,{"inputs":[{"name":"self"}],"output":{"name":"intercratemode"}}],[11,"eq","","",449,{"inputs":[{"name":"self"},{"name":"intercratemode"}],"output":{"name":"bool"}}],[11,"fmt","","",449,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",434,{"inputs":[{"name":"self"}],"output":{"name":"obligation"}}],[11,"eq","","",434,{"inputs":[{"name":"self"},{"name":"obligation"}],"output":{"name":"bool"}}],[11,"ne","","",434,{"inputs":[{"name":"self"},{"name":"obligation"}],"output":{"name":"bool"}}],[11,"hash","","",434,null],[11,"clone","","",435,{"inputs":[{"name":"self"}],"output":{"name":"obligationcause"}}],[11,"fmt","","",435,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",435,{"inputs":[{"name":"self"},{"name":"obligationcause"}],"output":{"name":"bool"}}],[11,"ne","","",435,{"inputs":[{"name":"self"},{"name":"obligationcause"}],"output":{"name":"bool"}}],[11,"hash","","",435,null],[11,"span","","",435,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"span"}}],[11,"clone","","",450,{"inputs":[{"name":"self"}],"output":{"name":"obligationcausecode"}}],[11,"fmt","","",450,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",450,{"inputs":[{"name":"self"},{"name":"obligationcausecode"}],"output":{"name":"bool"}}],[11,"ne","","",450,{"inputs":[{"name":"self"},{"name":"obligationcausecode"}],"output":{"name":"bool"}}],[11,"hash","","",450,null],[11,"clone","","",470,{"inputs":[{"name":"self"}],"output":{"name":"derivedobligationcause"}}],[11,"fmt","","",470,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",470,{"inputs":[{"name":"self"},{"name":"derivedobligationcause"}],"output":{"name":"bool"}}],[11,"ne","","",470,{"inputs":[{"name":"self"},{"name":"derivedobligationcause"}],"output":{"name":"bool"}}],[11,"hash","","",470,null],[11,"clone","","",451,{"inputs":[{"name":"self"}],"output":{"name":"whereclauseatom"}}],[11,"eq","","",451,{"inputs":[{"name":"self"},{"name":"whereclauseatom"}],"output":{"name":"bool"}}],[11,"ne","","",451,{"inputs":[{"name":"self"},{"name":"whereclauseatom"}],"output":{"name":"bool"}}],[11,"hash","","",451,null],[11,"fmt","","",451,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",452,{"inputs":[{"name":"self"}],"output":{"name":"domaingoal"}}],[11,"eq","","",452,{"inputs":[{"name":"self"},{"name":"domaingoal"}],"output":{"name":"bool"}}],[11,"ne","","",452,{"inputs":[{"name":"self"},{"name":"domaingoal"}],"output":{"name":"bool"}}],[11,"hash","","",452,null],[11,"fmt","","",452,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",453,{"inputs":[{"name":"self"}],"output":{"name":"quantifierkind"}}],[11,"eq","","",453,{"inputs":[{"name":"self"},{"name":"quantifierkind"}],"output":{"name":"bool"}}],[11,"hash","","",453,null],[11,"fmt","","",453,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",454,{"inputs":[{"name":"self"}],"output":{"name":"goal"}}],[11,"eq","","",454,{"inputs":[{"name":"self"},{"name":"goal"}],"output":{"name":"bool"}}],[11,"ne","","",454,{"inputs":[{"name":"self"},{"name":"goal"}],"output":{"name":"bool"}}],[11,"hash","","",454,null],[11,"fmt","","",454,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"from","","",454,{"inputs":[{"name":"domaingoal"}],"output":{"name":"self"}}],[11,"from","","",455,{"inputs":[{"name":"domaingoal"}],"output":{"name":"self"}}],[11,"clone","","",455,{"inputs":[{"name":"self"}],"output":{"name":"clause"}}],[11,"eq","","",455,{"inputs":[{"name":"self"},{"name":"clause"}],"output":{"name":"bool"}}],[11,"ne","","",455,{"inputs":[{"name":"self"},{"name":"clause"}],"output":{"name":"bool"}}],[11,"hash","","",455,null],[11,"fmt","","",455,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",456,{"inputs":[{"name":"self"}],"output":{"name":"selectionerror"}}],[11,"fmt","","",456,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",457,{"inputs":[{"name":"self"}],"output":{"name":"fulfillmenterrorcode"}}],[11,"clone","","",458,{"inputs":[{"name":"self"}],"output":{"name":"vtable"}}],[11,"eq","","",458,{"inputs":[{"name":"self"},{"name":"vtable"}],"output":{"name":"bool"}}],[11,"ne","","",458,{"inputs":[{"name":"self"},{"name":"vtable"}],"output":{"name":"bool"}}],[11,"encode","","",458,{"inputs":[{"name":"self"},{"name":"__sn"}],"output":{"name":"result"}}],[11,"decode","","",458,{"inputs":[{"name":"__dn"}],"output":{"generics":["vtable"],"name":"result"}}],[11,"clone","","",437,{"inputs":[{"name":"self"}],"output":{"name":"vtableimpldata"}}],[11,"eq","","",437,{"inputs":[{"name":"self"},{"name":"vtableimpldata"}],"output":{"name":"bool"}}],[11,"ne","","",437,{"inputs":[{"name":"self"},{"name":"vtableimpldata"}],"output":{"name":"bool"}}],[11,"encode","","",437,{"inputs":[{"name":"self"},{"name":"__sn"}],"output":{"name":"result"}}],[11,"decode","","",437,{"inputs":[{"name":"__dn"}],"output":{"generics":["vtableimpldata"],"name":"result"}}],[11,"clone","","",438,{"inputs":[{"name":"self"}],"output":{"name":"vtablegeneratordata"}}],[11,"eq","","",438,{"inputs":[{"name":"self"},{"name":"vtablegeneratordata"}],"output":{"name":"bool"}}],[11,"ne","","",438,{"inputs":[{"name":"self"},{"name":"vtablegeneratordata"}],"output":{"name":"bool"}}],[11,"encode","","",438,{"inputs":[{"name":"self"},{"name":"__sn"}],"output":{"name":"result"}}],[11,"decode","","",438,{"inputs":[{"name":"__dn"}],"output":{"generics":["vtablegeneratordata"],"name":"result"}}],[11,"clone","","",439,{"inputs":[{"name":"self"}],"output":{"name":"vtableclosuredata"}}],[11,"eq","","",439,{"inputs":[{"name":"self"},{"name":"vtableclosuredata"}],"output":{"name":"bool"}}],[11,"ne","","",439,{"inputs":[{"name":"self"},{"name":"vtableclosuredata"}],"output":{"name":"bool"}}],[11,"encode","","",439,{"inputs":[{"name":"self"},{"name":"__sn"}],"output":{"name":"result"}}],[11,"decode","","",439,{"inputs":[{"name":"__dn"}],"output":{"generics":["vtableclosuredata"],"name":"result"}}],[11,"clone","","",440,{"inputs":[{"name":"self"}],"output":{"name":"vtableautoimpldata"}}],[11,"eq","","",440,{"inputs":[{"name":"self"},{"name":"vtableautoimpldata"}],"output":{"name":"bool"}}],[11,"ne","","",440,{"inputs":[{"name":"self"},{"name":"vtableautoimpldata"}],"output":{"name":"bool"}}],[11,"encode","","",440,{"inputs":[{"name":"self"},{"name":"__sn"}],"output":{"name":"result"}}],[11,"decode","","",440,{"inputs":[{"name":"__dn"}],"output":{"generics":["vtableautoimpldata"],"name":"result"}}],[11,"clone","","",441,{"inputs":[{"name":"self"}],"output":{"name":"vtablebuiltindata"}}],[11,"eq","","",441,{"inputs":[{"name":"self"},{"name":"vtablebuiltindata"}],"output":{"name":"bool"}}],[11,"ne","","",441,{"inputs":[{"name":"self"},{"name":"vtablebuiltindata"}],"output":{"name":"bool"}}],[11,"encode","","",441,{"inputs":[{"name":"self"},{"name":"__sn"}],"output":{"name":"result"}}],[11,"decode","","",441,{"inputs":[{"name":"__dn"}],"output":{"generics":["vtablebuiltindata"],"name":"result"}}],[11,"eq","","",442,{"inputs":[{"name":"self"},{"name":"vtableobjectdata"}],"output":{"name":"bool"}}],[11,"ne","","",442,{"inputs":[{"name":"self"},{"name":"vtableobjectdata"}],"output":{"name":"bool"}}],[11,"clone","","",442,{"inputs":[{"name":"self"}],"output":{"name":"vtableobjectdata"}}],[11,"encode","","",442,{"inputs":[{"name":"self"},{"name":"__sn"}],"output":{"name":"result"}}],[11,"decode","","",442,{"inputs":[{"name":"__dn"}],"output":{"generics":["vtableobjectdata"],"name":"result"}}],[11,"clone","","",443,{"inputs":[{"name":"self"}],"output":{"name":"vtablefnpointerdata"}}],[11,"eq","","",443,{"inputs":[{"name":"self"},{"name":"vtablefnpointerdata"}],"output":{"name":"bool"}}],[11,"ne","","",443,{"inputs":[{"name":"self"},{"name":"vtablefnpointerdata"}],"output":{"name":"bool"}}],[11,"encode","","",443,{"inputs":[{"name":"self"},{"name":"__sn"}],"output":{"name":"result"}}],[11,"decode","","",443,{"inputs":[{"name":"__dn"}],"output":{"generics":["vtablefnpointerdata"],"name":"result"}}],[11,"new","","",434,{"inputs":[{"name":"obligationcause"},{"name":"paramenv"},{"name":"o"}],"output":{"name":"obligation"}}],[11,"misc","","",434,{"inputs":[{"name":"span"},{"name":"nodeid"},{"name":"paramenv"},{"name":"o"}],"output":{"name":"obligation"}}],[11,"with","","",434,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"obligation"}}],[11,"new","","",435,{"inputs":[{"name":"span"},{"name":"nodeid"},{"name":"obligationcausecode"}],"output":{"name":"obligationcause"}}],[11,"misc","","",435,{"inputs":[{"name":"span"},{"name":"nodeid"}],"output":{"name":"obligationcause"}}],[11,"dummy","","",435,{"inputs":[],"output":{"name":"obligationcause"}}],[11,"nested_obligations","","",458,{"inputs":[{"name":"self"}],"output":{"name":"vec"}}],[11,"map","","",458,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"vtable"}}],[0,"ty","rustc","",null,null],[3,"Binder","rustc::ty","Binder is a binder for higher-ranked lifetimes. It is part of the compiler's representation for things like `for<'a> Fn(&'a isize)` (which would be represented by the type `PolyTraitRef == Binder<TraitRef>`). Note that when we skolemize, instantiate, erase, or otherwise \"discharge\" these bound regions, we change the type from `Binder<T>` to just `T` (see e.g. `liberate_late_bound_regions`).",null,null],[12,"0","","",479,null],[3,"CanonicalVar","","",null,null],[3,"DebruijnIndex","","A [De Bruijn index][dbi] is a standard means of representing regions (and perhaps later types) in a higher-ranked setting. In particular, imagine a type like this:",null,null],[12,"depth","","We maintain the invariant that this is never 0. So 1 indicates the innermost binder. To ensure this, create with `DebruijnIndex::new`.",480,null],[3,"FnSig","","Signature of a function type, which I have arbitrarily decided to use to refer to the input/output types.",null,null],[12,"inputs_and_output","","",481,null],[12,"variadic","","",481,null],[12,"unsafety","","",481,null],[12,"abi","","",481,null],[3,"GenSig","","",null,null],[12,"yield_ty","","",482,null],[12,"return_ty","","",482,null],[3,"ParamTy","","",null,null],[12,"idx","","",483,null],[12,"name","","",483,null],[3,"ProjectionTy","","Represents the projection of an associated type. In explicit UFCS form this would be written `<T as Trait<..>>::N`.",null,null],[12,"substs","","The parameters of the associated item.",484,null],[12,"item_def_id","","The DefId of the TraitItem for the associated type N.",484,null],[3,"ClosureSubsts","","A closure can be modeled as a struct that looks like:",null,null],[12,"substs","","Lifetime and type parameters from the enclosing function, concatenated with the types of the upvars.",485,null],[3,"GeneratorInterior","","This describes the types that can be contained in a generator. It will be a type variable initially and unified in the last stages of typeck of a body. It contains a tuple of all the types that could end up on a generator frame. The state transformation MIR pass may only produce layouts which mention types in this tuple. Upvars are not counted here.",null,null],[12,"witness","","",486,null],[12,"movable","","",486,null],[3,"TypeAndMut","","",null,null],[12,"ty","","",487,null],[12,"mutbl","","",487,null],[3,"TraitRef","","A complete reference to a trait. These take numerous guises in syntax, but perhaps the most recognizable form is in a where clause:",null,null],[12,"def_id","","",488,null],[12,"substs","","",488,null],[3,"ExistentialTraitRef","","An existential reference to a trait, where `Self` is erased. For example, the trait object `Trait<'a, 'b, X, Y>` is:",null,null],[12,"def_id","","",489,null],[12,"substs","","",489,null],[3,"ExistentialProjection","","A `ProjectionPredicate` for an `ExistentialTraitRef`.",null,null],[12,"item_def_id","","",490,null],[12,"substs","","",490,null],[12,"ty","","",490,null],[3,"Const","","Typed constant value.",null,null],[12,"ty","","",491,null],[12,"val","","",491,null],[3,"EarlyBoundRegion","","",null,null],[12,"def_id","","",492,null],[12,"index","","",492,null],[12,"name","","",492,null],[3,"FreeRegion","","A \"free\" region `fr` can be interpreted as \"some region at least as big as the scope `fr.scope`\".",null,null],[12,"scope","","",493,null],[12,"bound_region","","",493,null],[3,"TyVid","","",null,null],[12,"index","","",494,null],[3,"IntVid","","",null,null],[12,"index","","",495,null],[3,"FloatVid","","",null,null],[12,"index","","",496,null],[3,"RegionVid","","",null,null],[12,"0","","",497,null],[3,"SkolemizedRegionVid","","",null,null],[12,"index","","",498,null],[3,"TyCtxt","","The central data structure of the compiler. It stores references to the various arenas and also houses the results of the various compiler queries that have been performed. See the [rustc guide] for more details.",null,null],[3,"GlobalArenas","","Internal storage",null,null],[3,"AllArenas","","",null,null],[12,"global","","",499,null],[12,"interner","","",499,null],[3,"TypeckTables","","",null,null],[12,"local_id_root","","The HirId::owner all ItemLocalIds in this table are relative to.",500,null],[12,"upvar_capture_map","","Borrows",500,null],[12,"used_trait_imports","","Set of trait imports actually used in the method resolution. This is used for warning unused imports. During type checking, this `Lrc` should not be cloned: it must have a ref-count of 1 so that we can insert things into the set mutably.",500,null],[12,"tainted_by_errors","","If any errors occurred while type-checking this body, this field will be set to `true`.",500,null],[12,"free_region_map","","Stores the free-region relationships that were deduced from its where clauses and parameter types. These are then read-again by borrowck.",500,null],[3,"InterpretInterner","","Everything needed to efficiently work with interned allocations",null,null],[3,"Instance","","",null,null],[12,"def","","",501,null],[12,"substs","","",501,null],[3,"CrateAnalysis","","The complete set of all analyses described in this module. This is produced by the driver and fed to trans and later passes.",null,null],[12,"access_levels","","",502,null],[12,"name","","",502,null],[12,"glob_map","","",502,null],[3,"Resolutions","","",null,null],[12,"freevars","","",503,null],[12,"trait_map","","",503,null],[12,"maybe_unused_trait_imports","","",503,null],[12,"maybe_unused_extern_crates","","",503,null],[12,"export_map","","",503,null],[3,"ImplHeader","","The \"header\" of an impl is everything outside the body: a Self type, a trait ref (in the case of a trait impl), and a set of predicates (from the bounds/where clauses).",null,null],[12,"impl_def_id","","",504,null],[12,"self_ty","","",504,null],[12,"trait_ref","","",504,null],[12,"predicates","","",504,null],[3,"AssociatedItem","","",null,null],[12,"def_id","","",505,null],[12,"name","","",505,null],[12,"kind","","",505,null],[12,"vis","","",505,null],[12,"defaultness","","",505,null],[12,"container","","",505,null],[12,"method_has_self_argument","","Whether this is a method with an explicit self as its first argument, allowing method calls.",505,null],[3,"CrateVariancesMap","","The crate variances map is computed during typeck and contains the variance of every item in the local crate. You should not use it directly, because to do so will make your pass dependent on the HIR of every item in the local crate. Instead, use `tcx.variances_of()` to get the variance for a particular item.",null,null],[12,"variances","","For each item with generics, maps to a vector of the variance of its generics.  If an item has no generics, it will have no entry.",506,null],[12,"empty_variance","","An empty vector, useful for cloning.",506,null],[3,"CReaderCacheKey","","",null,null],[12,"cnum","","",507,null],[12,"pos","","",507,null],[3,"TypeFlags","","",null,null],[3,"TyS","","",null,null],[12,"sty","","",508,null],[12,"flags","","",508,null],[3,"Slice","","A wrapper for slices with the additional invariant that the slice is interned and no other slice with the same contents can exist in the same context. This means we can use pointer + length for both equality comparisons and hashing.",null,null],[3,"UpvarId","","Upvars do not get their own node-id. Instead, we use the pair of the original var id (that is, the root variable that is referenced by the upvar) and the id of the closure expression.",null,null],[12,"var_id","","",509,null],[12,"closure_expr_id","","",509,null],[3,"UpvarBorrow","","",null,null],[12,"kind","","The kind of borrow: by-ref upvars have access to shared immutable borrows, which are not part of the normal language syntax.",510,null],[12,"region","","Region of the resulting reference.",510,null],[3,"ClosureUpvar","","",null,null],[12,"def","","",511,null],[12,"span","","",511,null],[12,"ty","","",511,null],[3,"FloatVarValue","","",null,null],[12,"0","","",512,null],[3,"TypeParameterDef","","",null,null],[12,"name","","",513,null],[12,"def_id","","",513,null],[12,"index","","",513,null],[12,"has_default","","",513,null],[12,"object_lifetime_default","","",513,null],[12,"pure_wrt_drop","","`pure_wrt_drop`, set by the (unsafe) `#[may_dangle]` attribute on generic parameter `T`, asserts data behind the parameter `T` won't be accessed during the parent type's `Drop` impl.",513,null],[12,"synthetic","","",513,null],[3,"RegionParameterDef","","",null,null],[12,"name","","",514,null],[12,"def_id","","",514,null],[12,"index","","",514,null],[12,"pure_wrt_drop","","`pure_wrt_drop`, set by the (unsafe) `#[may_dangle]` attribute on generic parameter `'a`, asserts data of lifetime `'a` won't be accessed during the parent type's `Drop` impl.",514,null],[3,"Generics","","Information about the formal type/lifetime parameters associated with an item or method. Analogous to hir::Generics.",null,null],[12,"parent","","",515,null],[12,"parent_regions","","",515,null],[12,"parent_types","","",515,null],[12,"regions","","",515,null],[12,"types","","",515,null],[12,"type_param_to_index","","Reverse map to each `TypeParameterDef`'s `index` field",515,null],[12,"has_self","","",515,null],[12,"has_late_bound_regions","","",515,null],[3,"GenericPredicates","","Bounds on generics.",null,null],[12,"parent","","",516,null],[12,"predicates","","",516,null],[3,"TraitPredicate","","",null,null],[12,"trait_ref","","",517,null],[3,"OutlivesPredicate","","",null,null],[12,"0","","",518,null],[12,"1","","",518,null],[3,"SubtypePredicate","","",null,null],[12,"a_is_expected","","",519,null],[12,"a","","",519,null],[12,"b","","",519,null],[3,"ProjectionPredicate","","This kind of predicate has no direct correspondent in the syntax, but it roughly corresponds to the syntactic forms:",null,null],[12,"projection_ty","","",520,null],[12,"ty","","",520,null],[3,"InstantiatedPredicates","","Represents the bounds declared on a particular set of type parameters.  Should eventually be generalized into a flag list of where clauses.  You can obtain a `InstantiatedPredicates` list from a `GenericPredicates` by using the `instantiate` method. Note that this method reflects an important semantic invariant of `InstantiatedPredicates`: while the `GenericPredicates` are expressed in terms of the bound type parameters of the impl/trait/whatever, an `InstantiatedPredicates` instance represented a set of bounds for some particular instantiation, meaning that the generic parameters have been substituted with their values.",null,null],[12,"predicates","","",521,null],[3,"UniverseIndex","","\"Universes\" are used during type- and trait-checking in the presence of `for<..>` binders to control what sets of names are visible. Universes are arranged into a tree: the root universe contains names that are always visible. But when you enter into some subuniverse, then it may add names that are only visible within that subtree (but it can still name the names of its ancestor universes).",null,null],[3,"ParamEnv","","When type checking, we use the `ParamEnv` to track details about the set of where-clauses that are in scope at this particular point.",null,null],[12,"caller_bounds","","Obligations that the caller must satisfy. This is basically the set of bounds on the in-scope type parameters, translated into Obligations, and elaborated and normalized.",522,null],[12,"reveal","","Typically, this is `Reveal::UserFacing`, but during trans we want `Reveal::All` -- note that this is always paired with an empty environment. To get that, use `ParamEnv::reveal()`.",522,null],[3,"ParamEnvAnd","","",null,null],[12,"param_env","","",523,null],[12,"value","","",523,null],[3,"Destructor","","",null,null],[12,"did","","The def-id of the destructor method",524,null],[3,"AdtFlags","","",null,null],[3,"VariantDef","","",null,null],[12,"did","","The variant's DefId. If this is a tuple-like struct, this is the DefId of the struct's ctor.",525,null],[12,"name","","",525,null],[12,"discr","","",525,null],[12,"fields","","",525,null],[12,"ctor_kind","","",525,null],[3,"FieldDef","","",null,null],[12,"did","","",526,null],[12,"name","","",526,null],[12,"vis","","",526,null],[3,"AdtDef","","The definition of an abstract data type - a struct or enum.",null,null],[12,"did","","",527,null],[12,"variants","","",527,null],[12,"repr","","",527,null],[3,"ReprFlags","","",null,null],[3,"ReprOptions","","Represents the repr options provided by the user,",null,null],[12,"int","","",528,null],[12,"align","","",528,null],[12,"flags","","",528,null],[3,"CrateInherentImpls","","A map for the local crate mapping each type to a vector of its inherent impls. This is not meant to be used outside of coherence; rather, you should request the vector for a specific type via `tcx.inherent_impls(def_id)` so as to minimize your dependencies (constructing this map requires touching the entire crate).",null,null],[12,"inherent_impls","","",529,null],[3,"SymbolName","","",null,null],[12,"name","","",530,null],[4,"InferTy","","",null,null],[13,"TyVar","","",531,null],[13,"IntVar","","",531,null],[13,"FloatVar","","",531,null],[13,"FreshTy","","A `FreshTy` is one that is generated as a replacement for an unbound type variable. This is convenient for caching etc. See `infer::freshen` for more details.",531,null],[13,"FreshIntTy","","",531,null],[13,"FreshFloatTy","","",531,null],[13,"CanonicalTy","","Canonicalized type variable, used only when preparing a trait query.",531,null],[4,"ExistentialPredicate","","",null,null],[13,"Trait","","e.g. Iterator",532,null],[13,"Projection","","e.g. Iterator::Item = T",532,null],[13,"AutoTrait","","e.g. Send",532,null],[4,"TypeVariants","","NB: If you change this, you'll probably want to change the corresponding AST structure in libsyntax/ast.rs as well.",null,null],[13,"TyBool","","The primitive boolean type. Written as `bool`.",533,null],[13,"TyChar","","The primitive character type; holds a Unicode scalar value (a non-surrogate code point).  Written as `char`.",533,null],[13,"TyInt","","A primitive signed integer type. For example, `i32`.",533,null],[13,"TyUint","","A primitive unsigned integer type. For example, `u32`.",533,null],[13,"TyFloat","","A primitive floating-point type. For example, `f64`.",533,null],[13,"TyAdt","","Structures, enumerations and unions.",533,null],[13,"TyForeign","","",533,null],[13,"TyStr","","The pointee of a string slice. Written as `str`.",533,null],[13,"TyArray","","An array with the given length. Written as `[T; n]`.",533,null],[13,"TySlice","","The pointee of an array slice.  Written as `[T]`.",533,null],[13,"TyRawPtr","","A raw pointer. Written as `*mut T` or `*const T`",533,null],[13,"TyRef","","A reference; a pointer with an associated lifetime. Written as `&'a mut T` or `&'a T`.",533,null],[13,"TyFnDef","","The anonymous type of a function declaration/definition. Each function has a unique type.",533,null],[13,"TyFnPtr","","A pointer to a function.  Written as `fn() -> i32`.",533,null],[13,"TyDynamic","","A trait, defined with `trait`.",533,null],[13,"TyClosure","","The anonymous type of a closure. Used to represent the type of `|a| a`.",533,null],[13,"TyGenerator","","The anonymous type of a generator. Used to represent the type of `|a| yield a`.",533,null],[13,"TyGeneratorWitness","","A type representin the types stored inside a generator. This should only appear in GeneratorInteriors.",533,null],[13,"TyNever","","The never type `!`",533,null],[13,"TyTuple","","A tuple type.  For example, `(i32, bool)`.",533,null],[13,"TyProjection","","The projection of an associated type.  For example, `<T as Trait<..>>::N`.",533,null],[13,"TyAnon","","Anonymized (`impl Trait`) type found in a return type. The DefId comes from the `impl Trait` ast::Ty node, and the substitutions are for the generics of the function in question. After typeck, the concrete type can be found in the `types` map.",533,null],[13,"TyParam","","A type parameter; for example, `T` in `fn f(x: T) {}",533,null],[13,"TyInfer","","A type variable used during type-checking.",533,null],[13,"TyError","","A placeholder for a type which could not be computed; this is propagated to avoid useless error messages.",533,null],[4,"BoundRegion","","",null,null],[13,"BrAnon","","An anonymous region parameter for a given fn (&T)",534,null],[13,"BrNamed","","Named region parameters for functions (a in &'a T)",534,null],[13,"BrFresh","","Fresh bound identifiers created during GLB computations.",534,null],[13,"BrEnv","","Anonymous region for the implicit env pointer parameter to a closure",534,null],[4,"RegionKind","","Representation of regions.",null,null],[13,"ReEarlyBound","","",535,null],[13,"ReLateBound","","",535,null],[13,"ReFree","","When checking a function body, the types of all arguments and so forth that refer to bound region parameters are modified to refer to free region parameters.",535,null],[13,"ReScope","","A concrete region naming some statically determined scope (e.g. an expression or sequence of statements) within the current function.",535,null],[13,"ReStatic","","Static data that has an \"infinite\" lifetime. Top in the region lattice.",535,null],[13,"ReVar","","A region variable.  Should not exist after typeck.",535,null],[13,"ReSkolemized","","A skolemized region - basically the higher-ranked version of ReFree. Should not exist after typeck.",535,null],[13,"ReEmpty","","Empty lifetime is for data that is never accessed. Bottom in the region lattice. We treat ReEmpty somewhat specially; at least right now, we do not generate instances of it during the GLB computations, but rather generate an error instead. This is to improve error messages. The only way to get an instance of ReEmpty is to have a region variable with no constraints.",535,null],[13,"ReErased","","Erased region, used by trait selection, in MIR and during trans.",535,null],[13,"ReClosureBound","","These are regions bound in the \"defining type\" for a closure. They are used ONLY as part of the `ClosureRegionRequirements` that are produced by MIR borrowck. See `ClosureRegionRequirements` for more details.",535,null],[13,"ReCanonical","","Canonicalized region, used only when preparing a trait query.",535,null],[4,"InstanceDef","","",null,null],[13,"Item","","",536,null],[13,"Intrinsic","","",536,null],[13,"FnPtrShim","","<fn() as FnTrait>::call_* def-id is FnTrait::call_*",536,null],[13,"Virtual","","::fn",536,null],[13,"ClosureOnceShim","","<[mut closure] as FnOnce>::call_once",536,null],[12,"call_once","rustc::ty::InstanceDef","",536,null],[13,"DropGlue","rustc::ty","drop_in_place::; None for empty drop glue.",536,null],[13,"CloneShim","","`<T as Clone>::clone` shim.",536,null],[4,"AssociatedItemContainer","","",null,null],[13,"TraitContainer","","",537,null],[13,"ImplContainer","","",537,null],[4,"AssociatedKind","","",null,null],[13,"Const","","",538,null],[13,"Method","","",538,null],[13,"Type","","",538,null],[4,"Visibility","","",null,null],[13,"Public","","Visible everywhere (including in other crates).",539,null],[13,"Restricted","","Visible only in the given crate-local module.",539,null],[13,"Invisible","","Not visible anywhere in the local crate. This is the visibility of private external items.",539,null],[4,"Variance","","",null,null],[13,"Covariant","","",540,null],[13,"Invariant","","",540,null],[13,"Contravariant","","",540,null],[13,"Bivariant","","",540,null],[4,"BorrowKind","","",null,null],[13,"ImmBorrow","","Data must be immutable and is aliasable.",541,null],[13,"UniqueImmBorrow","","Data must be immutable but not aliasable.  This kind of borrow cannot currently be expressed by the user and is used only in implicit closure bindings. It is needed when the closure is borrowing or mutating a mutable referent, e.g.:",541,null],[13,"MutBorrow","","Data is mutable and not aliasable.",541,null],[4,"UpvarCapture","","Information describing the capture of an upvar. This is computed during `typeck`, specifically by `regionck`.",null,null],[13,"ByValue","","Upvar is captured by value. This is always true when the closure is labeled `move`, but can also be true in other cases depending on inference.",542,null],[13,"ByRef","","Upvar is captured by reference.",542,null],[4,"IntVarValue","","",null,null],[13,"IntType","","",543,null],[13,"UintType","","",543,null],[4,"Predicate","","",null,null],[13,"Trait","","Corresponds to `where Foo : Bar<A,B,C>`. `Foo` here would be the `Self` type of the trait reference and `A`, `B`, and `C` would be the type parameters.",544,null],[13,"RegionOutlives","","where 'a : 'b",544,null],[13,"TypeOutlives","","where T : 'a",544,null],[13,"Projection","","where ::Name == X, approximately. See `ProjectionPredicate` struct for details.",544,null],[13,"WellFormed","","no syntax: T WF",544,null],[13,"ObjectSafe","","trait must be object-safe",544,null],[13,"ClosureKind","","No direct syntax. May be thought of as `where T : FnFoo<...>` for some substitutions `...` and T being a closure type. Satisfied (or refuted) once we know the closure's kind.",544,null],[13,"Subtype","","`T1 <: T2`",544,null],[13,"ConstEvaluatable","","Constant initializer must evaluate successfully.",544,null],[4,"VariantDiscr","","",null,null],[13,"Explicit","","Explicit value for this variant, i.e. `X = 123`. The `DefId` corresponds to the embedded constant.",545,null],[13,"Relative","","The previous variant's discriminant plus one. For efficiency reasons, the distance from the last `Explicit` discriminant is being stored, or `0` for the first variant, if it has none.",545,null],[4,"AdtKind","","",null,null],[13,"Struct","","",546,null],[13,"Union","","",546,null],[13,"Enum","","",546,null],[4,"ClosureKind","","Represents the various closure traits in the Rust language. This will determine the type of the environment (`self`, in the desuaring) argument that the closure expects.",null,null],[13,"Fn","","",547,null],[13,"FnMut","","",547,null],[13,"FnOnce","","",547,null],[4,"Attributes","","",null,null],[13,"Owned","","",548,null],[13,"Borrowed","","",548,null],[5,"keep_local","","",null,{"inputs":[{"name":"t"}],"output":{"name":"bool"}}],[5,"provide","","",null,{"inputs":[{"name":"providers"}],"output":null}],[0,"tls","","",null,null],[5,"enter_global","rustc::ty::tls","",null,{"inputs":[{"name":"globalctxt"},{"name":"f"}],"output":{"name":"r"}}],[5,"enter","","",null,{"inputs":[{"name":"globalctxt"},{"name":"ctxtinterners"},{"name":"f"}],"output":{"name":"r"}}],[5,"with","","",null,{"inputs":[{"name":"f"}],"output":{"name":"r"}}],[5,"with_opt","","",null,{"inputs":[{"name":"f"}],"output":{"name":"r"}}],[0,"adjustment","rustc::ty","",null,null],[3,"Adjustment","rustc::ty::adjustment","Represents coercing a value to a different type of value.",null,null],[12,"kind","","",549,null],[12,"target","","",549,null],[3,"OverloadedDeref","","An overloaded autoderef step, representing a `Deref(Mut)::deref(_mut)` call, with the signature `&'a T -> &'a U` or `&'a mut T -> &'a mut U`. The target type is `U` in both cases, with the region and mutability being those shared by both the receiver and the returned reference.",null,null],[12,"region","","",550,null],[12,"mutbl","","",550,null],[3,"CoerceUnsizedInfo","","Information for `CoerceUnsized` impls, storing information we have computed about the coercion.",null,null],[12,"custom_kind","","If this is a \"custom coerce\" impl, then what kind of custom coercion is it? This applies to impls of `CoerceUnsized` for structs, primarily, where we store a bit of info about which fields need to be coerced.",551,null],[4,"Adjust","","",null,null],[13,"NeverToAny","","Go from ! to any type.",552,null],[13,"ReifyFnPointer","","Go from a fn-item type to a fn-pointer type.",552,null],[13,"UnsafeFnPointer","","Go from a safe fn pointer to an unsafe fn pointer.",552,null],[13,"ClosureFnPointer","","Go from a non-capturing closure to an fn pointer.",552,null],[13,"MutToConstPointer","","Go from a mut raw pointer to a const raw pointer.",552,null],[13,"Deref","","Dereference once, producing a place.",552,null],[13,"Borrow","","Take the address and produce either a `&` or `*` pointer.",552,null],[13,"Unsize","","Unsize a pointer/reference value, e.g. `&[T; n]` to `&[T]`. Note that the source could be a thin or fat pointer. This will do things like convert thin pointers to fat pointers, or convert structs containing thin pointers to structs containing fat pointers, or convert between fat pointers.  We don't store the details of how the transform is done (in fact, we don't know that, because it might depend on the precise type parameters). We just store the target type. Trans figures out what has to be done at monomorphization time based on the precise source/target type at hand.",552,null],[4,"AutoBorrowMutability","","",null,null],[13,"Mutable","","",553,null],[12,"allow_two_phase_borrow","rustc::ty::adjustment::AutoBorrowMutability","",553,null],[13,"Immutable","rustc::ty::adjustment","",553,null],[4,"AutoBorrow","","",null,null],[13,"Ref","","Convert from T to &T.",554,null],[13,"RawPtr","","Convert from T to *T.",554,null],[4,"CustomCoerceUnsized","","",null,null],[13,"Struct","","Records the index of the field being coerced.",555,null],[11,"clone","","",549,{"inputs":[{"name":"self"}],"output":{"name":"adjustment"}}],[11,"encode","","",549,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",549,{"inputs":[{"name":"__d"}],"output":{"generics":["adjustment"],"name":"result"}}],[11,"clone","","",552,{"inputs":[{"name":"self"}],"output":{"name":"adjust"}}],[11,"fmt","","",552,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",552,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",552,{"inputs":[{"name":"__d"}],"output":{"generics":["adjust"],"name":"result"}}],[11,"clone","","",550,{"inputs":[{"name":"self"}],"output":{"name":"overloadedderef"}}],[11,"eq","","",550,{"inputs":[{"name":"self"},{"name":"overloadedderef"}],"output":{"name":"bool"}}],[11,"ne","","",550,{"inputs":[{"name":"self"},{"name":"overloadedderef"}],"output":{"name":"bool"}}],[11,"fmt","","",550,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",550,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",550,{"inputs":[{"name":"__d"}],"output":{"generics":["overloadedderef"],"name":"result"}}],[11,"method_call","","",550,null],[11,"clone","","",553,{"inputs":[{"name":"self"}],"output":{"name":"autoborrowmutability"}}],[11,"eq","","",553,{"inputs":[{"name":"self"},{"name":"autoborrowmutability"}],"output":{"name":"bool"}}],[11,"ne","","",553,{"inputs":[{"name":"self"},{"name":"autoborrowmutability"}],"output":{"name":"bool"}}],[11,"fmt","","",553,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",553,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",553,{"inputs":[{"name":"__d"}],"output":{"generics":["autoborrowmutability"],"name":"result"}}],[11,"from","rustc::hir","",88,{"inputs":[{"name":"autoborrowmutability"}],"output":{"name":"self"}}],[11,"clone","rustc::ty::adjustment","",554,{"inputs":[{"name":"self"}],"output":{"name":"autoborrow"}}],[11,"eq","","",554,{"inputs":[{"name":"self"},{"name":"autoborrow"}],"output":{"name":"bool"}}],[11,"ne","","",554,{"inputs":[{"name":"self"},{"name":"autoborrow"}],"output":{"name":"bool"}}],[11,"fmt","","",554,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",554,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",554,{"inputs":[{"name":"__d"}],"output":{"generics":["autoborrow"],"name":"result"}}],[11,"clone","","",551,{"inputs":[{"name":"self"}],"output":{"name":"coerceunsizedinfo"}}],[11,"encode","","",551,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",551,{"inputs":[{"name":"__d"}],"output":{"generics":["coerceunsizedinfo"],"name":"result"}}],[11,"fmt","","",551,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",555,{"inputs":[{"name":"self"}],"output":{"name":"customcoerceunsized"}}],[11,"encode","","",555,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",555,{"inputs":[{"name":"__d"}],"output":{"generics":["customcoerceunsized"],"name":"result"}}],[11,"fmt","","",555,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[0,"binding","rustc::ty","",null,null],[4,"BindingMode","rustc::ty::binding","",null,null],[13,"BindByReference","","",556,null],[13,"BindByValue","","",556,null],[11,"clone","","",556,{"inputs":[{"name":"self"}],"output":{"name":"bindingmode"}}],[11,"eq","","",556,{"inputs":[{"name":"self"},{"name":"bindingmode"}],"output":{"name":"bool"}}],[11,"ne","","",556,{"inputs":[{"name":"self"},{"name":"bindingmode"}],"output":{"name":"bool"}}],[11,"encode","","",556,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",556,{"inputs":[{"name":"__d"}],"output":{"generics":["bindingmode"],"name":"result"}}],[11,"hash","","",556,null],[11,"fmt","","",556,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"convert","","",556,{"inputs":[{"name":"bindingannotation"}],"output":{"name":"bindingmode"}}],[11,"hash_stable","","",556,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[0,"cast","rustc::ty","",null,null],[4,"IntTy","rustc::ty::cast","Types that are represented as ints.",null,null],[13,"U","","",557,null],[13,"I","","",557,null],[13,"Ivar","","",557,null],[13,"CEnum","","",557,null],[13,"Bool","","",557,null],[13,"Char","","",557,null],[4,"CastTy","","",null,null],[13,"Int","","Various types that are represented as ints and handled mostly in the same way, merged for easier matching.",558,null],[13,"Float","","Floating-Point types",558,null],[13,"FnPtr","","Function Pointers",558,null],[13,"Ptr","","Raw pointers",558,null],[13,"RPtr","","References",558,null],[4,"CastKind","","Cast Kind. See RFC 401 (or librustc_typeck/check/cast.rs)",null,null],[13,"CoercionCast","","",559,null],[13,"PtrPtrCast","","",559,null],[13,"PtrAddrCast","","",559,null],[13,"AddrPtrCast","","",559,null],[13,"NumericCast","","",559,null],[13,"EnumCast","","",559,null],[13,"PrimIntCast","","",559,null],[13,"U8CharCast","","",559,null],[13,"ArrayPtrCast","","",559,null],[13,"FnPtrPtrCast","","",559,null],[13,"FnPtrAddrCast","","",559,null],[11,"clone","","",557,{"inputs":[{"name":"self"}],"output":{"name":"intty"}}],[11,"fmt","","",557,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",557,{"inputs":[{"name":"self"},{"name":"intty"}],"output":{"name":"bool"}}],[11,"ne","","",557,{"inputs":[{"name":"self"},{"name":"intty"}],"output":{"name":"bool"}}],[11,"clone","","",558,{"inputs":[{"name":"self"}],"output":{"name":"castty"}}],[11,"fmt","","",558,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",558,{"inputs":[{"name":"self"},{"name":"castty"}],"output":{"name":"bool"}}],[11,"ne","","",558,{"inputs":[{"name":"self"},{"name":"castty"}],"output":{"name":"bool"}}],[11,"clone","","",559,{"inputs":[{"name":"self"}],"output":{"name":"castkind"}}],[11,"fmt","","",559,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",559,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",559,{"inputs":[{"name":"__d"}],"output":{"generics":["castkind"],"name":"result"}}],[11,"from_ty","","",558,{"inputs":[{"name":"ty"}],"output":{"generics":["castty"],"name":"option"}}],[0,"codec","rustc::ty","",null,null],[5,"encode_with_shorthand","rustc::ty::codec","Encode the given value or a previously cached shorthand.",null,{"inputs":[{"name":"e"},{"name":"t"},{"name":"m"}],"output":{"name":"result"}}],[5,"encode_predicates","","",null,{"inputs":[{"name":"e"},{"name":"genericpredicates"},{"name":"c"}],"output":{"name":"result"}}],[5,"decode_cnum","","",null,{"inputs":[{"name":"d"}],"output":{"generics":["cratenum"],"name":"result"}}],[5,"decode_ty","","",null,{"inputs":[{"name":"d"}],"output":{"generics":["ty"],"name":"result"}}],[5,"decode_predicates","","",null,{"inputs":[{"name":"d"}],"output":{"generics":["genericpredicates"],"name":"result"}}],[5,"decode_substs","","",null,{"inputs":[{"name":"d"}],"output":{"generics":["substs"],"name":"result"}}],[5,"decode_region","","",null,{"inputs":[{"name":"d"}],"output":{"generics":["region"],"name":"result"}}],[5,"decode_ty_slice","","",null,{"inputs":[{"name":"d"}],"output":{"generics":["slice"],"name":"result"}}],[5,"decode_adt_def","","",null,{"inputs":[{"name":"d"}],"output":{"generics":["adtdef"],"name":"result"}}],[5,"decode_existential_predicate_slice","","",null,{"inputs":[{"name":"d"}],"output":{"generics":["slice"],"name":"result"}}],[5,"decode_canonical_var_infos","","",null,{"inputs":[{"name":"d"}],"output":{"generics":["canonicalvarinfos"],"name":"result"}}],[5,"decode_const","","",null,{"inputs":[{"name":"d"}],"output":{"generics":["const"],"name":"result"}}],[17,"SHORTHAND_OFFSET","","The shorthand encoding uses an enum's variant index `usize` and is offset by this value so it never matches a real variant. This offset is also chosen so that the first byte is never < 0x80.",null,null],[8,"EncodableWithShorthand","","",null,null],[16,"Variant","","",560,null],[10,"variant","","",560,null],[8,"TyEncoder","","",null,null],[10,"position","","",561,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[8,"TyDecoder","","",null,null],[10,"tcx","","",562,{"inputs":[{"name":"self"}],"output":{"name":"tyctxt"}}],[10,"peek_byte","","",562,{"inputs":[{"name":"self"}],"output":{"name":"u8"}}],[10,"position","","",562,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[10,"cached_ty_for_shorthand","","",562,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"f"}],"output":{"generics":["ty"],"name":"result"}}],[10,"with_position","","",562,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"f"}],"output":{"name":"r"}}],[10,"map_encoded_cnum_to_current","","",562,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"cratenum"}}],[11,"positioned_at_shorthand","","",562,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"variant","rustc::ty","",544,null],[0,"error","","",null,null],[3,"ExpectedFound","rustc::ty::error","",null,null],[12,"expected","","",563,null],[12,"found","","",563,null],[4,"TypeError","","",null,null],[13,"Mismatch","","",564,null],[13,"UnsafetyMismatch","","",564,null],[13,"AbiMismatch","","",564,null],[13,"Mutability","","",564,null],[13,"TupleSize","","",564,null],[13,"FixedArraySize","","",564,null],[13,"ArgCount","","",564,null],[13,"RegionsDoesNotOutlive","","",564,null],[13,"RegionsInsufficientlyPolymorphic","","",564,null],[13,"RegionsOverlyPolymorphic","","",564,null],[13,"Sorts","","",564,null],[13,"IntMismatch","","",564,null],[13,"FloatMismatch","","",564,null],[13,"Traits","","",564,null],[13,"VariadicMismatch","","",564,null],[13,"CyclicTy","","Instantiating a type variable with the given type would have created a cycle (because it appears somewhere within that type).",564,null],[13,"ProjectionMismatched","","",564,null],[13,"ProjectionBoundsLength","","",564,null],[13,"ExistentialMismatch","","",564,null],[13,"OldStyleLUB","","",564,null],[4,"UnconstrainedNumeric","","",null,null],[13,"UnconstrainedFloat","","",565,null],[13,"UnconstrainedInt","","",565,null],[13,"Neither","","",565,null],[11,"clone","","",563,{"inputs":[{"name":"self"}],"output":{"name":"expectedfound"}}],[11,"fmt","","",563,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",564,{"inputs":[{"name":"self"}],"output":{"name":"typeerror"}}],[11,"fmt","","",564,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",565,{"inputs":[{"name":"self"}],"output":{"name":"unconstrainednumeric"}}],[11,"encode","","",565,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",565,{"inputs":[{"name":"__d"}],"output":{"generics":["unconstrainednumeric"],"name":"result"}}],[11,"eq","","",565,{"inputs":[{"name":"self"},{"name":"unconstrainednumeric"}],"output":{"name":"bool"}}],[11,"hash","","",565,null],[11,"fmt","","",565,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",564,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"sort_string","rustc::ty","",508,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"string"}}],[11,"note_and_explain_type_err","","",566,{"inputs":[{"name":"self"},{"name":"diagnosticbuilder"},{"name":"typeerror"},{"name":"span"}],"output":null}],[11,"erase_regions","","Returns an equivalent value with all free regions removed (note that late-bound regions remain, because they are important for subtyping, but they are anonymized and normalized as well)..",566,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"t"}}],[0,"fast_reject","","",null,null],[4,"SimplifiedTypeGen","rustc::ty::fast_reject","See `simplify_type`",null,null],[13,"BoolSimplifiedType","","",567,null],[13,"CharSimplifiedType","","",567,null],[13,"IntSimplifiedType","","",567,null],[13,"UintSimplifiedType","","",567,null],[13,"FloatSimplifiedType","","",567,null],[13,"AdtSimplifiedType","","",567,null],[13,"StrSimplifiedType","","",567,null],[13,"ArraySimplifiedType","","",567,null],[13,"PtrSimplifiedType","","",567,null],[13,"NeverSimplifiedType","","",567,null],[13,"TupleSimplifiedType","","",567,null],[13,"TraitSimplifiedType","","",567,null],[13,"ClosureSimplifiedType","","",567,null],[13,"GeneratorSimplifiedType","","",567,null],[13,"GeneratorWitnessSimplifiedType","","",567,null],[13,"AnonSimplifiedType","","",567,null],[13,"FunctionSimplifiedType","","",567,null],[13,"ParameterSimplifiedType","","",567,null],[13,"ForeignSimplifiedType","","",567,null],[5,"simplify_type","","Tries to simplify a type by dropping type parameters, deref'ing away any reference types, etc. The idea is to get something simple that we can use to quickly decide if two types could unify during method lookup.",null,{"inputs":[{"name":"tyctxt"},{"name":"ty"},{"name":"bool"}],"output":{"generics":["simplifiedtype"],"name":"option"}}],[6,"SimplifiedType","","",null,null],[11,"clone","","",567,{"inputs":[{"name":"self"}],"output":{"name":"simplifiedtypegen"}}],[11,"fmt","","",567,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",567,{"inputs":[{"name":"self"},{"name":"simplifiedtypegen"}],"output":{"name":"bool"}}],[11,"ne","","",567,{"inputs":[{"name":"self"},{"name":"simplifiedtypegen"}],"output":{"name":"bool"}}],[11,"hash","","",567,null],[11,"partial_cmp","","",567,{"inputs":[{"name":"self"},{"name":"simplifiedtypegen"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",567,{"inputs":[{"name":"self"},{"name":"simplifiedtypegen"}],"output":{"name":"bool"}}],[11,"le","","",567,{"inputs":[{"name":"self"},{"name":"simplifiedtypegen"}],"output":{"name":"bool"}}],[11,"gt","","",567,{"inputs":[{"name":"self"},{"name":"simplifiedtypegen"}],"output":{"name":"bool"}}],[11,"ge","","",567,{"inputs":[{"name":"self"},{"name":"simplifiedtypegen"}],"output":{"name":"bool"}}],[11,"cmp","","",567,{"inputs":[{"name":"self"},{"name":"simplifiedtypegen"}],"output":{"name":"ordering"}}],[11,"encode","","",567,{"inputs":[{"name":"self"},{"name":"__sd"}],"output":{"name":"result"}}],[11,"decode","","",567,{"inputs":[{"name":"__dd"}],"output":{"generics":["simplifiedtypegen"],"name":"result"}}],[11,"map_def","","",567,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"simplifiedtypegen"}}],[11,"hash_stable","","",567,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[0,"fold","rustc::ty","Generalized type folding mechanism. The setup is a bit convoluted but allows for convenient usage. Let T be an instance of some \"foldable type\" (one which implements `TypeFoldable`) and F be an instance of a \"folder\" (a type which implements `TypeFolder`). Then the setup is intended to be:",null,null],[3,"BottomUpFolder","rustc::ty::fold","",null,null],[12,"tcx","","",568,null],[12,"fldop","","",568,null],[3,"RegionFolder","","Folds over the substructure of a type, visiting its component types and all regions that occur free within it.",null,null],[5,"shift_region","","",null,{"inputs":[{"name":"regionkind"},{"name":"u32"}],"output":{"name":"regionkind"}}],[5,"shift_region_ref","","",null,{"inputs":[{"name":"tyctxt"},{"name":"region"},{"name":"u32"}],"output":{"name":"region"}}],[5,"shift_regions","","",null,{"inputs":[{"name":"tyctxt"},{"name":"u32"},{"name":"t"}],"output":{"name":"t"}}],[8,"TypeFoldable","","The TypeFoldable trait is implemented for every type that can be folded. Basically, every type that has a corresponding method in TypeFolder.",null,null],[10,"super_fold_with","","",569,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"self"}}],[11,"fold_with","","",569,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"self"}}],[10,"super_visit_with","","",569,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"visit_with","","",569,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"has_regions_escaping_depth","","",569,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"bool"}}],[11,"has_escaping_regions","","",569,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"has_type_flags","","",569,{"inputs":[{"name":"self"},{"name":"typeflags"}],"output":{"name":"bool"}}],[11,"has_projections","","",569,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"references_error","","",569,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"has_param_types","","",569,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"has_self_ty","","",569,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"has_infer_types","","",569,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"needs_infer","","",569,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"needs_subst","","",569,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"has_re_skol","","",569,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"has_closure_types","","",569,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"has_free_regions","","\"Free\" regions in this context means that it has any region that is not (a) erased or (b) late-bound.",569,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"has_erasable_regions","","True if there any any un-erased free regions.",569,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_normalized_for_trans","","",569,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_global","","Indicates whether this value references only 'global' types/lifetimes that are the same regardless of what fn we are in. This is used for caching. Errs on the side of returning false.",569,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[8,"TypeFolder","","The TypeFolder trait defines the actual folding. There is a method defined for every foldable type. Each of these has a default implementation that does an \"identity\" fold. Within each identity fold, it should invoke `foo.fold_with(self)` to fold each sub-item.",null,null],[10,"tcx","","",570,{"inputs":[{"name":"self"}],"output":{"name":"tyctxt"}}],[11,"fold_binder","","",570,{"inputs":[{"name":"self"},{"name":"binder"}],"output":{"name":"binder"}}],[11,"fold_ty","","",570,{"inputs":[{"name":"self"},{"name":"ty"}],"output":{"name":"ty"}}],[11,"fold_region","","",570,{"inputs":[{"name":"self"},{"name":"region"}],"output":{"name":"region"}}],[11,"fold_const","","",570,{"inputs":[{"name":"self"},{"name":"const"}],"output":{"name":"const"}}],[8,"TypeVisitor","","",null,null],[11,"visit_binder","","",571,{"inputs":[{"name":"self"},{"name":"binder"}],"output":{"name":"bool"}}],[11,"visit_ty","","",571,{"inputs":[{"name":"self"},{"name":"ty"}],"output":{"name":"bool"}}],[11,"visit_region","","",571,{"inputs":[{"name":"self"},{"name":"region"}],"output":{"name":"bool"}}],[11,"visit_const","","",571,{"inputs":[{"name":"self"},{"name":"const"}],"output":{"name":"bool"}}],[11,"tcx","","",568,{"inputs":[{"name":"self"}],"output":{"name":"tyctxt"}}],[11,"fold_ty","","",568,{"inputs":[{"name":"self"},{"name":"ty"}],"output":{"name":"ty"}}],[11,"collect_regions","rustc::ty","Collects the free and escaping regions in `value` into `region_set`. Returns whether any late-bound regions were skipped",566,{"inputs":[{"name":"self"},{"name":"t"},{"name":"fxhashset"}],"output":{"name":"bool"}}],[11,"fold_regions","","Folds the escaping and free regions in `value` using `f`, and sets `skipped_regions` to true if any late-bound region was found and skipped.",566,{"inputs":[{"name":"self"},{"name":"t"},{"name":"bool"},{"name":"f"}],"output":{"name":"t"}}],[11,"for_each_free_region","","",566,{"inputs":[{"name":"self"},{"name":"t"},{"name":"f"}],"output":null}],[11,"new","rustc::ty::fold","",572,{"inputs":[{"name":"tyctxt"},{"name":"bool"},{"name":"f"}],"output":{"name":"regionfolder"}}],[11,"tcx","","",572,{"inputs":[{"name":"self"}],"output":{"name":"tyctxt"}}],[11,"fold_binder","","",572,{"inputs":[{"name":"self"},{"name":"binder"}],"output":{"name":"binder"}}],[11,"fold_region","","",572,{"inputs":[{"name":"self"},{"name":"region"}],"output":{"name":"region"}}],[11,"replace_late_bound_regions","rustc::ty","Replace all regions bound by the given `Binder` with the results returned by the closure; the closure is expected to return a free region (relative to this binder), and hence the binder is removed in the return type. The closure is invoked once for each unique `BoundRegion`; multiple references to the same `BoundRegion` will reuse the previous result.  A map is returned at the end with each bound region and the free region that replaced it.",566,null],[11,"liberate_late_bound_regions","","Replace any late-bound regions bound in `value` with free variants attached to `all_outlive_scope`.",566,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"binder"}],"output":{"name":"t"}}],[11,"flatten_late_bound_regions","","Flattens two binding levels into one. So `for<'a> for<'b> Foo` becomes `for<'a,'b> Foo`.",566,{"inputs":[{"name":"self"},{"name":"binder"}],"output":{"name":"binder"}}],[11,"collect_constrained_late_bound_regions","","Returns a set of all late-bound regions that are constrained by `value`, meaning that if we instantiate those LBR with variables and equate `value` with something else, those variables will also be equated.",566,{"inputs":[{"name":"self"},{"name":"binder"}],"output":{"generics":["boundregion"],"name":"fxhashset"}}],[11,"collect_referenced_late_bound_regions","","Returns a set of all late-bound regions that appear in `value` anywhere.",566,{"inputs":[{"name":"self"},{"name":"binder"}],"output":{"generics":["boundregion"],"name":"fxhashset"}}],[11,"erase_late_bound_regions","","Replace any late-bound regions bound in `value` with `'erased`. Useful in trans but also method lookup and a few other places where precise region relationships are not required.",566,{"inputs":[{"name":"self"},{"name":"binder"}],"output":{"name":"t"}}],[11,"anonymize_late_bound_regions","","Rewrite any late-bound regions so that they are anonymous.  Region numbers are assigned starting at 1 and increasing monotonically in the order traversed by the fold operation.",566,{"inputs":[{"name":"self"},{"name":"binder"}],"output":{"name":"binder"}}],[0,"inhabitedness","","",null,null],[3,"DefIdForest","rustc::ty::inhabitedness","Represents a forest of DefIds closed under the ancestor relation. That is, if a DefId representing a module is contained in the forest then all DefIds defined in that module or submodules are also implicitly contained in the forest.",null,null],[11,"clone","","",573,{"inputs":[{"name":"self"}],"output":{"name":"defidforest"}}],[11,"empty","","Create an empty forest.",573,{"inputs":[],"output":{"name":"defidforest"}}],[11,"full","","Create a forest consisting of a single tree representing the entire crate.",573,{"inputs":[{"name":"tyctxt"}],"output":{"name":"defidforest"}}],[11,"from_id","","Create a forest containing a DefId and all its descendants.",573,{"inputs":[{"name":"defid"}],"output":{"name":"defidforest"}}],[11,"is_empty","","Test whether the forest is empty.",573,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"contains","","Test whether the forest contains a given DefId.",573,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"defid"}],"output":{"name":"bool"}}],[11,"intersection","","Calculate the intersection of a collection of forests.",573,{"inputs":[{"name":"tyctxt"},{"name":"i"}],"output":{"name":"defidforest"}}],[11,"union","","Calculate the union of a collection of forests.",573,{"inputs":[{"name":"tyctxt"},{"name":"i"}],"output":{"name":"defidforest"}}],[11,"is_ty_uninhabited_from","rustc::ty","Checks whether a type is visibly uninhabited from a particular module. # Example ```rust enum Void {} mod a {     pub mod b {         pub struct SecretlyUninhabited {             _priv: !,         }     } }",566,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"ty"}],"output":{"name":"bool"}}],[11,"is_ty_uninhabited_from_all_modules","","",566,{"inputs":[{"name":"self"},{"name":"ty"}],"output":{"name":"bool"}}],[11,"is_enum_variant_uninhabited_from","","",566,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"variantdef"},{"name":"substs"}],"output":{"name":"bool"}}],[11,"is_variant_uninhabited_from_all_modules","","",566,{"inputs":[{"name":"self"},{"name":"variantdef"},{"name":"substs"}],"output":{"name":"bool"}}],[0,"item_path","","",null,null],[4,"RootMode","rustc::ty::item_path","",null,null],[13,"Local","","Try to make a path relative to the local crate.  In particular, local paths have no prefix, and if the path comes from an extern crate, start with the path to the `extern crate` declaration.",574,null],[13,"Absolute","","Always prepend the crate name to the path, forming an absolute path from within a given set of crates.",574,null],[5,"with_forced_absolute_paths","","Enforces that item_path_str always returns an absolute path and also enables \"type-based\" impl paths. This is used when building symbols that contain types, where we want the crate name to be part of the symbol.",null,{"inputs":[{"name":"f"}],"output":{"name":"r"}}],[5,"with_forced_impl_filename_line","","Force us to name impls with just the filename/line number. We normally try to use types. But at some points, notably while printing cycle errors, this can result in extra or suboptimal error output, so this variable disables that check.",null,{"inputs":[{"name":"f"}],"output":{"name":"r"}}],[5,"characteristic_def_id_of_type","","As a heuristic, when we see an impl, if we see that the 'self-type' is a type defined in the same module as the impl, we can omit including the path to the impl itself. This function tries to find a \"characteristic def-id\" for a type. It's just a heuristic so it makes some questionable decisions and we may want to adjust it later.",null,{"inputs":[{"name":"ty"}],"output":{"generics":["defid"],"name":"option"}}],[8,"ItemPathBuffer","","Unifying Trait for different kinds of item paths we might construct. The basic interface is that components get pushed: the instance can also customize how we handle the root of a crate.",null,null],[10,"root_mode","","",575,{"inputs":[{"name":"self"}],"output":{"name":"rootmode"}}],[10,"push","","",575,{"inputs":[{"name":"self"},{"name":"str"}],"output":null}],[11,"item_path_str","rustc::ty","Returns a string identifying this def-id. This string is suitable for user output. It is relative to the current crate root, unless with_forced_absolute_paths was used.",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"string"}}],[11,"node_path_str","","Returns a string identifying this local node-id.",566,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"string"}}],[11,"absolute_item_path_str","","Returns a string identifying this def-id. This string is suitable for user output. It always begins with a crate identifier.",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"string"}}],[11,"push_krate_path","","Returns the \"path\" to a particular crate. This can proceed in various ways, depending on the `root_mode` of the `buffer`. (See `RootMode` enum for more details.)",566,{"inputs":[{"name":"self"},{"name":"t"},{"name":"cratenum"}],"output":null}],[11,"try_push_visible_item_path","","If possible, this pushes a global path resolving to `external_def_id` that is visible from at least one local module and returns true. If the crate defining `external_def_id` is declared with an `extern crate`, the path is guaranteed to use the `extern crate`.",566,{"inputs":[{"name":"self"},{"name":"t"},{"name":"defid"}],"output":{"name":"bool"}}],[11,"push_item_path","","",566,{"inputs":[{"name":"self"},{"name":"t"},{"name":"defid"}],"output":null}],[11,"parent_def_id","","Returns the def-id of `def_id`'s parent in the def tree. If this returns `None`, then `def_id` represents a crate root or inlined root.",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["defid"],"name":"option"}}],[11,"fmt","rustc::ty::item_path","",574,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[0,"layout","rustc::ty","",null,null],[3,"TargetDataLayout","rustc::ty::layout","Parsed Data layout for a target, which contains everything needed to compute layouts.",null,null],[12,"endian","","",576,null],[12,"i1_align","","",576,null],[12,"i8_align","","",576,null],[12,"i16_align","","",576,null],[12,"i32_align","","",576,null],[12,"i64_align","","",576,null],[12,"i128_align","","",576,null],[12,"f32_align","","",576,null],[12,"f64_align","","",576,null],[12,"pointer_size","","",576,null],[12,"pointer_align","","",576,null],[12,"aggregate_align","","",576,null],[12,"vector_align","","Alignments for vector types.",576,null],[3,"Size","","Size of a type in bytes.",null,null],[3,"Align","","Alignment of a type in bytes, both ABI-mandated and preferred. Each field is a power of two, giving the alignment a maximum value of 2(28 - 1), which is limited by LLVM to a i32, with a maximum capacity of 231 - 1 or 2147483647.",null,null],[3,"Scalar","","Information about one scalar component of a Rust type.",null,null],[12,"value","","",577,null],[12,"valid_range","","Inclusive wrap-around range of valid values, that is, if min > max, it represents min..=u128::MAX followed by 0..=max.",577,null],[3,"LayoutDetails","","",null,null],[12,"variants","","",578,null],[12,"fields","","",578,null],[12,"abi","","",578,null],[12,"align","","",578,null],[12,"size","","",578,null],[3,"LayoutCx","","",null,null],[12,"tcx","","",579,null],[12,"param_env","","",579,null],[3,"TyLayout","","The details of the layout of a type, alongside the type itself. Provides various type traversal APIs (e.g. recursing into fields).",null,null],[12,"ty","","",580,null],[4,"Endian","","Endianness of the target, which must match cfg(target-endian).",null,null],[13,"Little","","",581,null],[13,"Big","","",581,null],[4,"Integer","","Integers, also used for enum discriminants.",null,null],[13,"I8","","",582,null],[13,"I16","","",582,null],[13,"I32","","",582,null],[13,"I64","","",582,null],[13,"I128","","",582,null],[4,"Primitive","","Fundamental unit of memory access and layout.",null,null],[13,"Int","","The `bool` is the signedness of the `Integer` type.",583,null],[13,"F32","","",583,null],[13,"F64","","",583,null],[13,"Pointer","","",583,null],[4,"FieldPlacement","","Describes how the fields of a type are located in memory.",null,null],[13,"Union","","All fields start at no offset. The `usize` is the field count.",584,null],[13,"Array","","Array/vector-like placement, with all fields of identical types.",584,null],[12,"stride","rustc::ty::layout::FieldPlacement","",584,null],[12,"count","","",584,null],[13,"Arbitrary","rustc::ty::layout","Struct-like placement, with precomputed offsets.",584,null],[12,"offsets","rustc::ty::layout::FieldPlacement","Offsets for the first byte of each field, ordered to match the source definition order. This vector does not go in increasing order.",584,null],[12,"memory_index","","Maps source order field indices to memory order indices, depending how fields were permuted.",584,null],[4,"Abi","rustc::ty::layout","Describes how values of the type are passed by target ABIs, in terms of categories of C types there are ABI rules for.",null,null],[13,"Uninhabited","","",585,null],[13,"Scalar","","",585,null],[13,"ScalarPair","","",585,null],[13,"Vector","","",585,null],[12,"element","rustc::ty::layout::Abi","",585,null],[12,"count","","",585,null],[13,"Aggregate","rustc::ty::layout","",585,null],[12,"sized","rustc::ty::layout::Abi","If true, the size is exact, otherwise it's only a lower bound.",585,null],[4,"Variants","rustc::ty::layout","",null,null],[13,"Single","","Single enum variants, structs/tuples, unions, and all non-ADTs.",586,null],[12,"index","rustc::ty::layout::Variants","",586,null],[13,"Tagged","rustc::ty::layout","General-case enums: for each case there is a struct, and they all have all space reserved for the discriminant, and their first field starts at a non-0 offset, after where the discriminant would go.",586,null],[12,"discr","rustc::ty::layout::Variants","",586,null],[12,"variants","","",586,null],[13,"NicheFilling","rustc::ty::layout","Multiple cases distinguished by a niche (values invalid for a type): the variant `dataful_variant` contains a niche at an arbitrary offset (field 0 of the enum), which for a variant with discriminant `d` is set to `(d - niche_variants.start).wrapping_add(niche_start)`.",586,null],[12,"dataful_variant","rustc::ty::layout::Variants","",586,null],[12,"niche_variants","","",586,null],[12,"niche","","",586,null],[12,"niche_start","","",586,null],[12,"variants","","",586,null],[4,"LayoutError","rustc::ty::layout","",null,null],[13,"Unknown","","",587,null],[13,"SizeOverflow","","",587,null],[4,"SizeSkeleton","","Type size \"skeleton\", i.e. the only information determining a type's size. While this is conservative, (aside from constant sizes, only pointers, newtypes thereof and null pointer optimized enums are allowed), it is enough to statically check common usecases of transmute.",null,null],[13,"Known","","Any statically computable Layout.",588,null],[13,"Pointer","","A potentially-fat pointer.",588,null],[12,"non_zero","rustc::ty::layout::SizeSkeleton","If true, this pointer is never null.",588,null],[12,"tail","","The type which determines the unsized metadata, if any, of this pointer. Either a type parameter or a projection depending on one, with regions erased.",588,null],[5,"provide","rustc::ty::layout","",null,{"inputs":[{"name":"providers"}],"output":null}],[17,"FAT_PTR_ADDR","","The first half of a fat pointer.",null,null],[17,"FAT_PTR_EXTRA","","The second half of a fat pointer.",null,null],[8,"HasDataLayout","","",null,null],[10,"data_layout","","",589,{"inputs":[{"name":"self"}],"output":{"name":"targetdatalayout"}}],[8,"HasTyCtxt","","",null,null],[10,"tcx","","",590,{"inputs":[{"name":"self"}],"output":{"name":"tyctxt"}}],[8,"MaybeResult","","",null,null],[10,"from_ok","","",591,{"inputs":[{"name":"t"}],"output":{"name":"self"}}],[10,"map_same","","",591,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"self"}}],[8,"LayoutOf","","",null,null],[16,"TyLayout","","",592,null],[10,"layout_of","","",592,null],[11,"default","","Creates an instance of `TargetDataLayout`.",576,{"inputs":[],"output":{"name":"targetdatalayout"}}],[11,"parse","","",576,{"inputs":[{"name":"session"}],"output":{"name":"targetdatalayout"}}],[11,"obj_size_bound","","Return exclusive upper bound on object size.",576,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"ptr_sized_integer","","",576,{"inputs":[{"name":"self"}],"output":{"name":"integer"}}],[11,"vector_align","","",576,{"inputs":[{"name":"self"},{"name":"size"}],"output":{"name":"align"}}],[11,"clone","","",581,{"inputs":[{"name":"self"}],"output":{"name":"endian"}}],[11,"clone","","",593,{"inputs":[{"name":"self"}],"output":{"name":"size"}}],[11,"eq","","",593,{"inputs":[{"name":"self"},{"name":"size"}],"output":{"name":"bool"}}],[11,"ne","","",593,{"inputs":[{"name":"self"},{"name":"size"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",593,{"inputs":[{"name":"self"},{"name":"size"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",593,{"inputs":[{"name":"self"},{"name":"size"}],"output":{"name":"bool"}}],[11,"le","","",593,{"inputs":[{"name":"self"},{"name":"size"}],"output":{"name":"bool"}}],[11,"gt","","",593,{"inputs":[{"name":"self"},{"name":"size"}],"output":{"name":"bool"}}],[11,"ge","","",593,{"inputs":[{"name":"self"},{"name":"size"}],"output":{"name":"bool"}}],[11,"cmp","","",593,{"inputs":[{"name":"self"},{"name":"size"}],"output":{"name":"ordering"}}],[11,"hash","","",593,null],[11,"fmt","","",593,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"from_bits","","",593,{"inputs":[{"name":"u64"}],"output":{"name":"size"}}],[11,"from_bytes","","",593,{"inputs":[{"name":"u64"}],"output":{"name":"size"}}],[11,"bytes","","",593,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"bits","","",593,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"abi_align","","",593,{"inputs":[{"name":"self"},{"name":"align"}],"output":{"name":"size"}}],[11,"is_abi_aligned","","",593,{"inputs":[{"name":"self"},{"name":"align"}],"output":{"name":"bool"}}],[11,"checked_add","","",593,{"inputs":[{"name":"self"},{"name":"size"},{"name":"c"}],"output":{"generics":["size"],"name":"option"}}],[11,"checked_mul","","",593,{"inputs":[{"name":"self"},{"name":"u64"},{"name":"c"}],"output":{"generics":["size"],"name":"option"}}],[11,"add","","",593,{"inputs":[{"name":"self"},{"name":"size"}],"output":{"name":"size"}}],[11,"sub","","",593,{"inputs":[{"name":"self"},{"name":"size"}],"output":{"name":"size"}}],[11,"mul","","",593,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"size"}}],[11,"add_assign","","",593,{"inputs":[{"name":"self"},{"name":"size"}],"output":null}],[11,"clone","","",594,{"inputs":[{"name":"self"}],"output":{"name":"align"}}],[11,"eq","","",594,{"inputs":[{"name":"self"},{"name":"align"}],"output":{"name":"bool"}}],[11,"ne","","",594,{"inputs":[{"name":"self"},{"name":"align"}],"output":{"name":"bool"}}],[11,"hash","","",594,null],[11,"fmt","","",594,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",594,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",594,{"inputs":[{"name":"__d"}],"output":{"generics":["align"],"name":"result"}}],[11,"from_bits","","",594,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"generics":["align","string"],"name":"result"}}],[11,"from_bytes","","",594,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"generics":["align","string"],"name":"result"}}],[11,"abi","","",594,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"pref","","",594,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"abi_bits","","",594,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"pref_bits","","",594,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"min","","",594,{"inputs":[{"name":"self"},{"name":"align"}],"output":{"name":"align"}}],[11,"max","","",594,{"inputs":[{"name":"self"},{"name":"align"}],"output":{"name":"align"}}],[11,"clone","","",582,{"inputs":[{"name":"self"}],"output":{"name":"integer"}}],[11,"eq","","",582,{"inputs":[{"name":"self"},{"name":"integer"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",582,{"inputs":[{"name":"self"},{"name":"integer"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"cmp","","",582,{"inputs":[{"name":"self"},{"name":"integer"}],"output":{"name":"ordering"}}],[11,"hash","","",582,null],[11,"fmt","","",582,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"size","","",582,{"inputs":[{"name":"self"}],"output":{"name":"size"}}],[11,"align","","",582,{"inputs":[{"name":"self"},{"name":"c"}],"output":{"name":"align"}}],[11,"to_ty","","",582,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"bool"}],"output":{"name":"ty"}}],[11,"fit_signed","","Find the smallest Integer type which can represent the signed value.",582,{"inputs":[{"name":"i128"}],"output":{"name":"integer"}}],[11,"fit_unsigned","","Find the smallest Integer type which can represent the unsigned value.",582,{"inputs":[{"name":"u128"}],"output":{"name":"integer"}}],[11,"for_abi_align","","Find the smallest integer with the given alignment.",582,{"inputs":[{"name":"c"},{"name":"align"}],"output":{"generics":["integer"],"name":"option"}}],[11,"approximate_abi_align","","Find the largest integer with the given alignment or less.",582,{"inputs":[{"name":"c"},{"name":"align"}],"output":{"name":"integer"}}],[11,"from_attr","","Get the Integer type from an attr::IntType.",582,{"inputs":[{"name":"c"},{"name":"inttype"}],"output":{"name":"integer"}}],[11,"clone","","",583,{"inputs":[{"name":"self"}],"output":{"name":"primitive"}}],[11,"eq","","",583,{"inputs":[{"name":"self"},{"name":"primitive"}],"output":{"name":"bool"}}],[11,"ne","","",583,{"inputs":[{"name":"self"},{"name":"primitive"}],"output":{"name":"bool"}}],[11,"hash","","",583,null],[11,"fmt","","",583,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"size","","",583,{"inputs":[{"name":"self"},{"name":"c"}],"output":{"name":"size"}}],[11,"align","","",583,{"inputs":[{"name":"self"},{"name":"c"}],"output":{"name":"align"}}],[11,"to_ty","","",583,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"ty"}}],[11,"clone","","",577,{"inputs":[{"name":"self"}],"output":{"name":"scalar"}}],[11,"eq","","",577,{"inputs":[{"name":"self"},{"name":"scalar"}],"output":{"name":"bool"}}],[11,"ne","","",577,{"inputs":[{"name":"self"},{"name":"scalar"}],"output":{"name":"bool"}}],[11,"hash","","",577,null],[11,"fmt","","",577,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"is_bool","","",577,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"eq","","",584,{"inputs":[{"name":"self"},{"name":"fieldplacement"}],"output":{"name":"bool"}}],[11,"ne","","",584,{"inputs":[{"name":"self"},{"name":"fieldplacement"}],"output":{"name":"bool"}}],[11,"hash","","",584,null],[11,"fmt","","",584,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"count","","",584,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"offset","","",584,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"size"}}],[11,"memory_index","","",584,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"usize"}}],[11,"index_by_increasing_offset","","Get source indices of the fields by increasing offsets.",584,null],[11,"clone","","",585,{"inputs":[{"name":"self"}],"output":{"name":"abi"}}],[11,"eq","","",585,{"inputs":[{"name":"self"},{"name":"abi"}],"output":{"name":"bool"}}],[11,"ne","","",585,{"inputs":[{"name":"self"},{"name":"abi"}],"output":{"name":"bool"}}],[11,"hash","","",585,null],[11,"fmt","","",585,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"is_unsized","","Returns true if the layout corresponds to an unsized type.",585,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_signed","","Returns true if this is a single signed integer scalar",585,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"eq","","",586,{"inputs":[{"name":"self"},{"name":"variants"}],"output":{"name":"bool"}}],[11,"ne","","",586,{"inputs":[{"name":"self"},{"name":"variants"}],"output":{"name":"bool"}}],[11,"hash","","",586,null],[11,"fmt","","",586,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",587,{"inputs":[{"name":"self"}],"output":{"name":"layouterror"}}],[11,"fmt","","",587,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",587,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",578,{"inputs":[{"name":"self"},{"name":"layoutdetails"}],"output":{"name":"bool"}}],[11,"ne","","",578,{"inputs":[{"name":"self"},{"name":"layoutdetails"}],"output":{"name":"bool"}}],[11,"hash","","",578,null],[11,"fmt","","",578,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",579,{"inputs":[{"name":"self"}],"output":{"name":"layoutcx"}}],[11,"clone","","",588,{"inputs":[{"name":"self"}],"output":{"name":"sizeskeleton"}}],[11,"fmt","","",588,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"compute","","",588,{"inputs":[{"name":"ty"},{"name":"tyctxt"},{"name":"paramenv"}],"output":{"generics":["sizeskeleton","layouterror"],"name":"result"}}],[11,"same_size","","",588,{"inputs":[{"name":"self"},{"name":"sizeskeleton"}],"output":{"name":"bool"}}],[11,"clone","","",580,{"inputs":[{"name":"self"}],"output":{"name":"tylayout"}}],[11,"fmt","","",580,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"deref","","",580,{"inputs":[{"name":"self"}],"output":{"name":"layoutdetails"}}],[11,"data_layout","rustc::ty","",566,{"inputs":[{"name":"self"}],"output":{"name":"targetdatalayout"}}],[11,"tcx","","",566,{"inputs":[{"name":"self"}],"output":{"name":"tyctxt"}}],[11,"data_layout","rustc::ty::layout","",579,{"inputs":[{"name":"self"}],"output":{"name":"targetdatalayout"}}],[11,"tcx","","",579,{"inputs":[{"name":"self"}],"output":{"name":"tyctxt"}}],[11,"layout_of","","Computes the layout of a type. Note that this implicitly executes in \"reveal all\" mode.",579,null],[11,"layout_of","","Computes the layout of a type. Note that this implicitly executes in \"reveal all\" mode.",579,null],[11,"layout_of","rustc::ty","Computes the layout of a type. Note that this implicitly executes in \"reveal all\" mode.",566,{"inputs":[{"name":"self"},{"generics":["ty"],"name":"paramenvand"}],"output":{"generics":["tylayout","layouterror"],"name":"result"}}],[11,"for_variant","rustc::ty::layout","",580,{"inputs":[{"name":"self"},{"name":"c"},{"name":"usize"}],"output":{"name":"self"}}],[11,"field","","",580,null],[11,"is_unsized","","Returns true if the layout corresponds to an unsized type.",580,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_zst","","Returns true if the type is a ZST and not unsized.",580,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"size_and_align","","",580,null],[11,"hash_stable","","",586,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",584,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",585,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",577,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",578,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",582,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",583,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",594,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",593,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",587,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[0,"_match","rustc::ty","",null,null],[3,"Match","rustc::ty::_match","A type \"A\" matches \"B\" if the fresh types in B could be substituted with values so as to make it equal to A. Matching is intended to be used only on freshened types, and it basically indicates if the non-freshened versions of A and B could have been unified.",null,null],[11,"new","","",595,{"inputs":[{"name":"tyctxt"}],"output":{"name":"match"}}],[11,"tag","","",595,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"tcx","","",595,{"inputs":[{"name":"self"}],"output":{"name":"tyctxt"}}],[11,"a_is_expected","","",595,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"relate_with_variance","","",595,{"inputs":[{"name":"self"},{"name":"variance"},{"name":"t"},{"name":"t"}],"output":{"name":"relateresult"}}],[11,"regions","","",595,{"inputs":[{"name":"self"},{"name":"region"},{"name":"region"}],"output":{"generics":["region"],"name":"relateresult"}}],[11,"tys","","",595,{"inputs":[{"name":"self"},{"name":"ty"},{"name":"ty"}],"output":{"generics":["ty"],"name":"relateresult"}}],[11,"binders","","",595,{"inputs":[{"name":"self"},{"name":"binder"},{"name":"binder"}],"output":{"generics":["binder"],"name":"relateresult"}}],[0,"maps","rustc::ty","",null,null],[3,"OnDiskCache","rustc::ty::maps","`OnDiskCache` provides an interface to incr. comp. data cached from the previous compilation session. This data will eventually include the results of a few selected queries (like `typeck_tables_of` and `mir_optimized`) and any diagnostics that have been emitted during a query.",null,null],[3,"Maps","","",null,null],[3,"TyCtxtAt","","",null,null],[12,"tcx","","",596,null],[12,"span","","",596,null],[3,"Providers","","",null,null],[12,"type_of","","",597,null],[12,"generics_of","","",597,null],[12,"predicates_of","","",597,null],[12,"super_predicates_of","","",597,null],[12,"type_param_predicates","","",597,null],[12,"trait_def","","",597,null],[12,"adt_def","","",597,null],[12,"adt_destructor","","",597,null],[12,"adt_sized_constraint","","",597,null],[12,"adt_dtorck_constraint","","",597,null],[12,"is_const_fn","","",597,null],[12,"is_foreign_item","","",597,null],[12,"crate_variances","","",597,null],[12,"variances_of","","",597,null],[12,"inferred_outlives_of","","",597,null],[12,"associated_item_def_ids","","",597,null],[12,"associated_item","","",597,null],[12,"impl_trait_ref","","",597,null],[12,"impl_polarity","","",597,null],[12,"inherent_impls","","",597,null],[12,"mir_keys","","",597,null],[12,"mir_const_qualif","","",597,null],[12,"mir_built","","",597,null],[12,"mir_const","","",597,null],[12,"mir_validated","","",597,null],[12,"optimized_mir","","",597,null],[12,"unsafety_check_result","","",597,null],[12,"unsafe_derive_on_repr_packed","","",597,null],[12,"fn_sig","","",597,null],[12,"coerce_unsized_info","","",597,null],[12,"typeck_item_bodies","","",597,null],[12,"typeck_tables_of","","",597,null],[12,"used_trait_imports","","",597,null],[12,"has_typeck_tables","","",597,null],[12,"coherent_trait","","",597,null],[12,"borrowck","","",597,null],[12,"mir_borrowck","","",597,null],[12,"crate_inherent_impls","","",597,null],[12,"crate_inherent_impls_overlap_check","","",597,null],[12,"const_eval","","",597,null],[12,"check_match","","",597,null],[12,"privacy_access_levels","","",597,null],[12,"reachable_set","","",597,null],[12,"region_scope_tree","","",597,null],[12,"mir_shims","","",597,null],[12,"def_symbol_name","","",597,null],[12,"symbol_name","","",597,null],[12,"describe_def","","",597,null],[12,"def_span","","",597,null],[12,"lookup_stability","","",597,null],[12,"lookup_deprecation_entry","","",597,null],[12,"item_attrs","","",597,null],[12,"trans_fn_attrs","","",597,null],[12,"fn_arg_names","","",597,null],[12,"impl_parent","","",597,null],[12,"trait_of_item","","",597,null],[12,"item_body_nested_bodies","","",597,null],[12,"const_is_rvalue_promotable_to_static","","",597,null],[12,"rvalue_promotable_map","","",597,null],[12,"is_mir_available","","",597,null],[12,"vtable_methods","","",597,null],[12,"trans_fulfill_obligation","","",597,null],[12,"trait_impls_of","","",597,null],[12,"specialization_graph_of","","",597,null],[12,"is_object_safe","","",597,null],[12,"param_env","","",597,null],[12,"is_copy_raw","","",597,null],[12,"is_sized_raw","","",597,null],[12,"is_freeze_raw","","",597,null],[12,"needs_drop_raw","","",597,null],[12,"layout_raw","","",597,null],[12,"dylib_dependency_formats","","",597,null],[12,"is_panic_runtime","","",597,null],[12,"is_compiler_builtins","","",597,null],[12,"has_global_allocator","","",597,null],[12,"is_sanitizer_runtime","","",597,null],[12,"is_profiler_runtime","","",597,null],[12,"panic_strategy","","",597,null],[12,"is_no_builtins","","",597,null],[12,"extern_crate","","",597,null],[12,"specializes","","",597,null],[12,"in_scope_traits_map","","",597,null],[12,"module_exports","","",597,null],[12,"lint_levels","","",597,null],[12,"impl_defaultness","","",597,null],[12,"check_item_well_formed","","",597,null],[12,"check_trait_item_well_formed","","",597,null],[12,"check_impl_item_well_formed","","",597,null],[12,"reachable_non_generics","","",597,null],[12,"is_reachable_non_generic","","",597,null],[12,"native_libraries","","",597,null],[12,"foreign_modules","","",597,null],[12,"plugin_registrar_fn","","",597,null],[12,"derive_registrar_fn","","",597,null],[12,"crate_disambiguator","","",597,null],[12,"crate_hash","","",597,null],[12,"original_crate_name","","",597,null],[12,"implementations_of_trait","","",597,null],[12,"all_trait_implementations","","",597,null],[12,"dllimport_foreign_items","","",597,null],[12,"is_dllimport_foreign_item","","",597,null],[12,"is_statically_included_foreign_item","","",597,null],[12,"native_library_kind","","",597,null],[12,"link_args","","",597,null],[12,"resolve_lifetimes","","",597,null],[12,"named_region_map","","",597,null],[12,"is_late_bound_map","","",597,null],[12,"object_lifetime_defaults_map","","",597,null],[12,"visibility","","",597,null],[12,"dep_kind","","",597,null],[12,"crate_name","","",597,null],[12,"item_children","","",597,null],[12,"extern_mod_stmt_cnum","","",597,null],[12,"get_lang_items","","",597,null],[12,"defined_lang_items","","",597,null],[12,"missing_lang_items","","",597,null],[12,"extern_const_body","","",597,null],[12,"visible_parent_map","","",597,null],[12,"missing_extern_crate_item","","",597,null],[12,"used_crate_source","","",597,null],[12,"postorder_cnums","","",597,null],[12,"freevars","","",597,null],[12,"maybe_unused_trait_import","","",597,null],[12,"maybe_unused_extern_crates","","",597,null],[12,"stability_index","","",597,null],[12,"all_crate_nums","","",597,null],[12,"exported_symbols","","",597,null],[12,"collect_and_partition_translation_items","","",597,null],[12,"symbol_export_level","","",597,null],[12,"is_translated_item","","",597,null],[12,"codegen_unit","","",597,null],[12,"compile_codegen_unit","","",597,null],[12,"output_filenames","","",597,null],[12,"erase_regions_ty","","",597,null],[12,"normalize_projection_ty","","",597,null],[12,"normalize_ty_after_erasing_regions","","",597,null],[12,"dropck_outlives","","",597,null],[12,"substitute_normalize_and_test_predicates","","",597,null],[12,"target_features_whitelist","","",597,null],[12,"instance_def_size_estimate","","",597,null],[12,"features_query","","",597,null],[12,"program_clauses_for","","",597,null],[12,"wasm_custom_sections","","",597,null],[12,"wasm_import_module_map","","",597,null],[4,"Query","","",null,null],[13,"type_of","","Records the type of every item.",598,null],[13,"generics_of","","Maps from the def-id of an item (trait/struct/enum/fn) to its associated generics and predicates.",598,null],[13,"predicates_of","","",598,null],[13,"super_predicates_of","","Maps from the def-id of a trait to the list of super-predicates. This is a subset of the full list of predicates. We store these in a separate map because we must evaluate them even during type conversion, often before the full predicates are available (note that supertraits have additional acyclicity requirements).",598,null],[13,"type_param_predicates","","To avoid cycles within the predicates of a single item we compute per-type-parameter predicates for resolving `T::AssocTy`.",598,null],[13,"trait_def","","",598,null],[13,"adt_def","","",598,null],[13,"adt_destructor","","",598,null],[13,"adt_sized_constraint","","",598,null],[13,"adt_dtorck_constraint","","",598,null],[13,"is_const_fn","","True if this is a const fn",598,null],[13,"is_foreign_item","","True if this is a foreign item (i.e., linked via `extern { ... }`).",598,null],[13,"crate_variances","","Get a map with the variance of every item; use `item_variance` instead.",598,null],[13,"variances_of","","Maps from def-id of a type or region parameter to its (inferred) variance.",598,null],[13,"inferred_outlives_of","","Maps from def-id of a type to its (inferred) outlives.",598,null],[13,"associated_item_def_ids","","Maps from an impl/trait def-id to a list of the def-ids of its items",598,null],[13,"associated_item","","Maps from a trait item to the trait item \"descriptor\"",598,null],[13,"impl_trait_ref","","",598,null],[13,"impl_polarity","","",598,null],[13,"inherent_impls","","Maps a DefId of a type to a list of its inherent impls. Contains implementations of methods that are inherent to a type. Methods in these implementations don't need to be exported.",598,null],[13,"mir_keys","","Set of all the def-ids in this crate that have MIR associated with them. This includes all the body owners, but also things like struct constructors.",598,null],[13,"mir_const_qualif","","Maps DefId's that have an associated Mir to the result of the MIR qualify_consts pass. The actual meaning of the value isn't known except to the pass itself.",598,null],[13,"mir_built","","Fetch the MIR for a given def-id right after it's built - this includes unreachable code.",598,null],[13,"mir_const","","Fetch the MIR for a given def-id up till the point where it is ready for const evaluation.",598,null],[13,"mir_validated","","",598,null],[13,"optimized_mir","","MIR after our optimization passes have run. This is MIR that is ready for trans. This is also the only query that can fetch non-local MIR, at present.",598,null],[13,"unsafety_check_result","","The result of unsafety-checking this def-id.",598,null],[13,"unsafe_derive_on_repr_packed","","HACK: when evaluated, this reports a \"unsafe derive on repr(packed)\" error",598,null],[13,"fn_sig","","The signature of functions and closures.",598,null],[13,"coerce_unsized_info","","Caches CoerceUnsized kinds for impls on custom types.",598,null],[13,"typeck_item_bodies","","",598,null],[13,"typeck_tables_of","","",598,null],[13,"used_trait_imports","","",598,null],[13,"has_typeck_tables","","",598,null],[13,"coherent_trait","","",598,null],[13,"borrowck","","",598,null],[13,"mir_borrowck","","Borrow checks the function body. If this is a closure, returns additional requirements that the closure's creator must verify.",598,null],[13,"crate_inherent_impls","","Gets a complete map from all types to their inherent impls. Not meant to be used directly outside of coherence. (Defined only for LOCAL_CRATE)",598,null],[13,"crate_inherent_impls_overlap_check","","Checks all types in the krate for overlap in their inherent impls. Reports errors. Not meant to be used directly outside of coherence. (Defined only for LOCAL_CRATE)",598,null],[13,"const_eval","","Results of evaluating const items or constants embedded in other items (such as enum variant explicit discriminants).",598,null],[13,"check_match","","",598,null],[13,"privacy_access_levels","","Performs the privacy check and computes \"access levels\".",598,null],[13,"reachable_set","","",598,null],[13,"region_scope_tree","","Per-body `region::ScopeTree`. The `DefId` should be the owner-def-id for the body; in the case of closures, this will be redirected to the enclosing function.",598,null],[13,"mir_shims","","",598,null],[13,"def_symbol_name","","",598,null],[13,"symbol_name","","",598,null],[13,"describe_def","","",598,null],[13,"def_span","","",598,null],[13,"lookup_stability","","",598,null],[13,"lookup_deprecation_entry","","",598,null],[13,"item_attrs","","",598,null],[13,"trans_fn_attrs","","",598,null],[13,"fn_arg_names","","",598,null],[13,"impl_parent","","",598,null],[13,"trait_of_item","","",598,null],[13,"item_body_nested_bodies","","",598,null],[13,"const_is_rvalue_promotable_to_static","","",598,null],[13,"rvalue_promotable_map","","",598,null],[13,"is_mir_available","","",598,null],[13,"vtable_methods","","",598,null],[13,"trans_fulfill_obligation","","",598,null],[13,"trait_impls_of","","",598,null],[13,"specialization_graph_of","","",598,null],[13,"is_object_safe","","",598,null],[13,"param_env","","",598,null],[13,"is_copy_raw","","",598,null],[13,"is_sized_raw","","",598,null],[13,"is_freeze_raw","","",598,null],[13,"needs_drop_raw","","",598,null],[13,"layout_raw","","",598,null],[13,"dylib_dependency_formats","","",598,null],[13,"is_panic_runtime","","",598,null],[13,"is_compiler_builtins","","",598,null],[13,"has_global_allocator","","",598,null],[13,"is_sanitizer_runtime","","",598,null],[13,"is_profiler_runtime","","",598,null],[13,"panic_strategy","","",598,null],[13,"is_no_builtins","","",598,null],[13,"extern_crate","","",598,null],[13,"specializes","","",598,null],[13,"in_scope_traits_map","","",598,null],[13,"module_exports","","",598,null],[13,"lint_levels","","",598,null],[13,"impl_defaultness","","",598,null],[13,"check_item_well_formed","","",598,null],[13,"check_trait_item_well_formed","","",598,null],[13,"check_impl_item_well_formed","","",598,null],[13,"reachable_non_generics","","",598,null],[13,"is_reachable_non_generic","","",598,null],[13,"native_libraries","","",598,null],[13,"foreign_modules","","",598,null],[13,"plugin_registrar_fn","","",598,null],[13,"derive_registrar_fn","","",598,null],[13,"crate_disambiguator","","",598,null],[13,"crate_hash","","",598,null],[13,"original_crate_name","","",598,null],[13,"implementations_of_trait","","",598,null],[13,"all_trait_implementations","","",598,null],[13,"dllimport_foreign_items","","",598,null],[13,"is_dllimport_foreign_item","","",598,null],[13,"is_statically_included_foreign_item","","",598,null],[13,"native_library_kind","","",598,null],[13,"link_args","","",598,null],[13,"resolve_lifetimes","","",598,null],[13,"named_region_map","","",598,null],[13,"is_late_bound_map","","",598,null],[13,"object_lifetime_defaults_map","","",598,null],[13,"visibility","","",598,null],[13,"dep_kind","","",598,null],[13,"crate_name","","",598,null],[13,"item_children","","",598,null],[13,"extern_mod_stmt_cnum","","",598,null],[13,"get_lang_items","","",598,null],[13,"defined_lang_items","","",598,null],[13,"missing_lang_items","","",598,null],[13,"extern_const_body","","",598,null],[13,"visible_parent_map","","",598,null],[13,"missing_extern_crate_item","","",598,null],[13,"used_crate_source","","",598,null],[13,"postorder_cnums","","",598,null],[13,"freevars","","",598,null],[13,"maybe_unused_trait_import","","",598,null],[13,"maybe_unused_extern_crates","","",598,null],[13,"stability_index","","",598,null],[13,"all_crate_nums","","",598,null],[13,"exported_symbols","","",598,null],[13,"collect_and_partition_translation_items","","",598,null],[13,"symbol_export_level","","",598,null],[13,"is_translated_item","","",598,null],[13,"codegen_unit","","",598,null],[13,"compile_codegen_unit","","",598,null],[13,"output_filenames","","",598,null],[13,"erase_regions_ty","","",598,null],[13,"normalize_projection_ty","","Do not call this query directly: invoke `normalize` instead.",598,null],[13,"normalize_ty_after_erasing_regions","","Do not call this query directly: invoke `normalize_erasing_regions` instead.",598,null],[13,"dropck_outlives","","Do not call this query directly: invoke `infcx.at().dropck_outlives()` instead.",598,null],[13,"substitute_normalize_and_test_predicates","","",598,null],[13,"target_features_whitelist","","",598,null],[13,"instance_def_size_estimate","","",598,null],[13,"features_query","","",598,null],[13,"program_clauses_for","","",598,null],[13,"wasm_custom_sections","","",598,null],[13,"wasm_import_module_map","","",598,null],[4,"QueryMsg","","",null,null],[13,"type_of","","",599,null],[13,"generics_of","","",599,null],[13,"predicates_of","","",599,null],[13,"super_predicates_of","","",599,null],[13,"type_param_predicates","","",599,null],[13,"trait_def","","",599,null],[13,"adt_def","","",599,null],[13,"adt_destructor","","",599,null],[13,"adt_sized_constraint","","",599,null],[13,"adt_dtorck_constraint","","",599,null],[13,"is_const_fn","","",599,null],[13,"is_foreign_item","","",599,null],[13,"crate_variances","","",599,null],[13,"variances_of","","",599,null],[13,"inferred_outlives_of","","",599,null],[13,"associated_item_def_ids","","",599,null],[13,"associated_item","","",599,null],[13,"impl_trait_ref","","",599,null],[13,"impl_polarity","","",599,null],[13,"inherent_impls","","",599,null],[13,"mir_keys","","",599,null],[13,"mir_const_qualif","","",599,null],[13,"mir_built","","",599,null],[13,"mir_const","","",599,null],[13,"mir_validated","","",599,null],[13,"optimized_mir","","",599,null],[13,"unsafety_check_result","","",599,null],[13,"unsafe_derive_on_repr_packed","","",599,null],[13,"fn_sig","","",599,null],[13,"coerce_unsized_info","","",599,null],[13,"typeck_item_bodies","","",599,null],[13,"typeck_tables_of","","",599,null],[13,"used_trait_imports","","",599,null],[13,"has_typeck_tables","","",599,null],[13,"coherent_trait","","",599,null],[13,"borrowck","","",599,null],[13,"mir_borrowck","","",599,null],[13,"crate_inherent_impls","","",599,null],[13,"crate_inherent_impls_overlap_check","","",599,null],[13,"const_eval","","",599,null],[13,"check_match","","",599,null],[13,"privacy_access_levels","","",599,null],[13,"reachable_set","","",599,null],[13,"region_scope_tree","","",599,null],[13,"mir_shims","","",599,null],[13,"def_symbol_name","","",599,null],[13,"symbol_name","","",599,null],[13,"describe_def","","",599,null],[13,"def_span","","",599,null],[13,"lookup_stability","","",599,null],[13,"lookup_deprecation_entry","","",599,null],[13,"item_attrs","","",599,null],[13,"trans_fn_attrs","","",599,null],[13,"fn_arg_names","","",599,null],[13,"impl_parent","","",599,null],[13,"trait_of_item","","",599,null],[13,"item_body_nested_bodies","","",599,null],[13,"const_is_rvalue_promotable_to_static","","",599,null],[13,"rvalue_promotable_map","","",599,null],[13,"is_mir_available","","",599,null],[13,"vtable_methods","","",599,null],[13,"trans_fulfill_obligation","","",599,null],[13,"trait_impls_of","","",599,null],[13,"specialization_graph_of","","",599,null],[13,"is_object_safe","","",599,null],[13,"param_env","","",599,null],[13,"is_copy_raw","","",599,null],[13,"is_sized_raw","","",599,null],[13,"is_freeze_raw","","",599,null],[13,"needs_drop_raw","","",599,null],[13,"layout_raw","","",599,null],[13,"dylib_dependency_formats","","",599,null],[13,"is_panic_runtime","","",599,null],[13,"is_compiler_builtins","","",599,null],[13,"has_global_allocator","","",599,null],[13,"is_sanitizer_runtime","","",599,null],[13,"is_profiler_runtime","","",599,null],[13,"panic_strategy","","",599,null],[13,"is_no_builtins","","",599,null],[13,"extern_crate","","",599,null],[13,"specializes","","",599,null],[13,"in_scope_traits_map","","",599,null],[13,"module_exports","","",599,null],[13,"lint_levels","","",599,null],[13,"impl_defaultness","","",599,null],[13,"check_item_well_formed","","",599,null],[13,"check_trait_item_well_formed","","",599,null],[13,"check_impl_item_well_formed","","",599,null],[13,"reachable_non_generics","","",599,null],[13,"is_reachable_non_generic","","",599,null],[13,"native_libraries","","",599,null],[13,"foreign_modules","","",599,null],[13,"plugin_registrar_fn","","",599,null],[13,"derive_registrar_fn","","",599,null],[13,"crate_disambiguator","","",599,null],[13,"crate_hash","","",599,null],[13,"original_crate_name","","",599,null],[13,"implementations_of_trait","","",599,null],[13,"all_trait_implementations","","",599,null],[13,"dllimport_foreign_items","","",599,null],[13,"is_dllimport_foreign_item","","",599,null],[13,"is_statically_included_foreign_item","","",599,null],[13,"native_library_kind","","",599,null],[13,"link_args","","",599,null],[13,"resolve_lifetimes","","",599,null],[13,"named_region_map","","",599,null],[13,"is_late_bound_map","","",599,null],[13,"object_lifetime_defaults_map","","",599,null],[13,"visibility","","",599,null],[13,"dep_kind","","",599,null],[13,"crate_name","","",599,null],[13,"item_children","","",599,null],[13,"extern_mod_stmt_cnum","","",599,null],[13,"get_lang_items","","",599,null],[13,"defined_lang_items","","",599,null],[13,"missing_lang_items","","",599,null],[13,"extern_const_body","","",599,null],[13,"visible_parent_map","","",599,null],[13,"missing_extern_crate_item","","",599,null],[13,"used_crate_source","","",599,null],[13,"postorder_cnums","","",599,null],[13,"freevars","","",599,null],[13,"maybe_unused_trait_import","","",599,null],[13,"maybe_unused_extern_crates","","",599,null],[13,"stability_index","","",599,null],[13,"all_crate_nums","","",599,null],[13,"exported_symbols","","",599,null],[13,"collect_and_partition_translation_items","","",599,null],[13,"symbol_export_level","","",599,null],[13,"is_translated_item","","",599,null],[13,"codegen_unit","","",599,null],[13,"compile_codegen_unit","","",599,null],[13,"output_filenames","","",599,null],[13,"erase_regions_ty","","",599,null],[13,"normalize_projection_ty","","",599,null],[13,"normalize_ty_after_erasing_regions","","",599,null],[13,"dropck_outlives","","",599,null],[13,"substitute_normalize_and_test_predicates","","",599,null],[13,"target_features_whitelist","","",599,null],[13,"instance_def_size_estimate","","",599,null],[13,"features_query","","",599,null],[13,"program_clauses_for","","",599,null],[13,"wasm_custom_sections","","",599,null],[13,"wasm_import_module_map","","",599,null],[5,"force_from_dep_node","","The red/green evaluation system will try to mark a specific DepNode in the dependency graph as green by recursively trying to mark the dependencies of that DepNode as green. While doing so, it will sometimes encounter a DepNode where we don't know if it is red or green and we therefore actually have to recompute its value in order to find out. Since the only piece of information that we have at that point is the DepNode we are trying to re-evaluate, we need some way to re-run a query from just that. This is what `force_from_dep_node()` implements.",null,{"inputs":[{"name":"tyctxt"},{"name":"depnode"}],"output":{"name":"bool"}}],[11,"cache_on_disk","rustc::dep_graph","",4,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"bool"}}],[11,"load_from_on_disk_cache","","",4,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":null}],[11,"map_crate","rustc::ty","",536,{"inputs":[{"name":"self"}],"output":{"name":"cratenum"}}],[11,"default_span","","",536,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"span"}}],[11,"map_crate","","",501,{"inputs":[{"name":"self"}],"output":{"name":"cratenum"}}],[11,"default_span","","",501,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"span"}}],[11,"map_crate","rustc::mir::interpret","",366,{"inputs":[{"name":"self"}],"output":{"name":"cratenum"}}],[11,"default_span","","",366,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"span"}}],[11,"map_crate","rustc::hir::def_id","",129,{"inputs":[{"name":"self"}],"output":{"name":"cratenum"}}],[11,"default_span","","",129,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"span"}}],[11,"map_crate","","",130,{"inputs":[{"name":"self"}],"output":{"name":"cratenum"}}],[11,"default_span","","",130,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"span"}}],[11,"map_crate","","",127,{"inputs":[{"name":"self"}],"output":{"name":"cratenum"}}],[11,"default_span","","",127,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"span"}}],[11,"map_crate","rustc::ty","",523,{"inputs":[{"name":"self"}],"output":{"name":"cratenum"}}],[11,"default_span","","",523,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"span"}}],[11,"map_crate","rustc::ty::maps::keys","",600,{"inputs":[{"name":"self"}],"output":{"name":"cratenum"}}],[11,"default_span","","",600,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"span"}}],[11,"map_crate","","",601,{"inputs":[{"name":"self"}],"output":{"name":"cratenum"}}],[11,"default_span","","",601,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"span"}}],[11,"new","rustc::ty::maps","Create a new OnDiskCache instance from the serialized data in `data`.",602,{"inputs":[{"name":"session"},{"generics":["u8"],"name":"vec"},{"name":"usize"}],"output":{"name":"ondiskcache"}}],[11,"new_empty","","",602,{"inputs":[{"name":"codemap"}],"output":{"name":"ondiskcache"}}],[11,"serialize","","",602,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"e"}],"output":{"name":"result"}}],[11,"load_diagnostics","","Load a diagnostic emitted during the previous compilation session.",602,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"serializeddepnodeindex"}],"output":{"generics":["diagnostic"],"name":"vec"}}],[11,"store_diagnostics","","Store a diagnostic emitted during the current compilation session. Anything stored like this will be available via `load_diagnostics` in the next compilation session.",602,{"inputs":[{"name":"self"},{"name":"depnodeindex"},{"generics":["diagnostic"],"name":"vec"}],"output":null}],[11,"try_load_query_result","","Returns the cached query result if there is something in the cache for the given SerializedDepNodeIndex. Otherwise returns None.",602,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"serializeddepnodeindex"}],"output":{"name":"option"}}],[11,"store_diagnostics_for_anon_node","","Store a diagnostic emitted during computation of an anonymous query. Since many anonymous queries can share the same `DepNode`, we aggregate them -- as opposed to regular queries where we assume that there is a 1:1 relationship between query-key and `DepNode`.",602,{"inputs":[{"name":"self"},{"name":"depnodeindex"},{"generics":["diagnostic"],"name":"vec"}],"output":null}],[0,"queries","","",null,null],[3,"type_of","rustc::ty::maps::queries","",null,null],[3,"generics_of","","",null,null],[3,"predicates_of","","",null,null],[3,"super_predicates_of","","",null,null],[3,"type_param_predicates","","",null,null],[3,"trait_def","","",null,null],[3,"adt_def","","",null,null],[3,"adt_destructor","","",null,null],[3,"adt_sized_constraint","","",null,null],[3,"adt_dtorck_constraint","","",null,null],[3,"is_const_fn","","",null,null],[3,"is_foreign_item","","",null,null],[3,"crate_variances","","",null,null],[3,"variances_of","","",null,null],[3,"inferred_outlives_of","","",null,null],[3,"associated_item_def_ids","","",null,null],[3,"associated_item","","",null,null],[3,"impl_trait_ref","","",null,null],[3,"impl_polarity","","",null,null],[3,"inherent_impls","","",null,null],[3,"mir_keys","","",null,null],[3,"mir_const_qualif","","",null,null],[3,"mir_built","","",null,null],[3,"mir_const","","",null,null],[3,"mir_validated","","",null,null],[3,"optimized_mir","","",null,null],[3,"unsafety_check_result","","",null,null],[3,"unsafe_derive_on_repr_packed","","",null,null],[3,"fn_sig","","",null,null],[3,"coerce_unsized_info","","",null,null],[3,"typeck_item_bodies","","",null,null],[3,"typeck_tables_of","","",null,null],[3,"used_trait_imports","","",null,null],[3,"has_typeck_tables","","",null,null],[3,"coherent_trait","","",null,null],[3,"borrowck","","",null,null],[3,"mir_borrowck","","",null,null],[3,"crate_inherent_impls","","",null,null],[3,"crate_inherent_impls_overlap_check","","",null,null],[3,"const_eval","","",null,null],[3,"check_match","","",null,null],[3,"privacy_access_levels","","",null,null],[3,"reachable_set","","",null,null],[3,"region_scope_tree","","",null,null],[3,"mir_shims","","",null,null],[3,"def_symbol_name","","",null,null],[3,"symbol_name","","",null,null],[3,"describe_def","","",null,null],[3,"def_span","","",null,null],[3,"lookup_stability","","",null,null],[3,"lookup_deprecation_entry","","",null,null],[3,"item_attrs","","",null,null],[3,"trans_fn_attrs","","",null,null],[3,"fn_arg_names","","",null,null],[3,"impl_parent","","",null,null],[3,"trait_of_item","","",null,null],[3,"item_body_nested_bodies","","",null,null],[3,"const_is_rvalue_promotable_to_static","","",null,null],[3,"rvalue_promotable_map","","",null,null],[3,"is_mir_available","","",null,null],[3,"vtable_methods","","",null,null],[3,"trans_fulfill_obligation","","",null,null],[3,"trait_impls_of","","",null,null],[3,"specialization_graph_of","","",null,null],[3,"is_object_safe","","",null,null],[3,"param_env","","",null,null],[3,"is_copy_raw","","",null,null],[3,"is_sized_raw","","",null,null],[3,"is_freeze_raw","","",null,null],[3,"needs_drop_raw","","",null,null],[3,"layout_raw","","",null,null],[3,"dylib_dependency_formats","","",null,null],[3,"is_panic_runtime","","",null,null],[3,"is_compiler_builtins","","",null,null],[3,"has_global_allocator","","",null,null],[3,"is_sanitizer_runtime","","",null,null],[3,"is_profiler_runtime","","",null,null],[3,"panic_strategy","","",null,null],[3,"is_no_builtins","","",null,null],[3,"extern_crate","","",null,null],[3,"specializes","","",null,null],[3,"in_scope_traits_map","","",null,null],[3,"module_exports","","",null,null],[3,"lint_levels","","",null,null],[3,"impl_defaultness","","",null,null],[3,"check_item_well_formed","","",null,null],[3,"check_trait_item_well_formed","","",null,null],[3,"check_impl_item_well_formed","","",null,null],[3,"reachable_non_generics","","",null,null],[3,"is_reachable_non_generic","","",null,null],[3,"native_libraries","","",null,null],[3,"foreign_modules","","",null,null],[3,"plugin_registrar_fn","","",null,null],[3,"derive_registrar_fn","","",null,null],[3,"crate_disambiguator","","",null,null],[3,"crate_hash","","",null,null],[3,"original_crate_name","","",null,null],[3,"implementations_of_trait","","",null,null],[3,"all_trait_implementations","","",null,null],[3,"dllimport_foreign_items","","",null,null],[3,"is_dllimport_foreign_item","","",null,null],[3,"is_statically_included_foreign_item","","",null,null],[3,"native_library_kind","","",null,null],[3,"link_args","","",null,null],[3,"resolve_lifetimes","","",null,null],[3,"named_region_map","","",null,null],[3,"is_late_bound_map","","",null,null],[3,"object_lifetime_defaults_map","","",null,null],[3,"visibility","","",null,null],[3,"dep_kind","","",null,null],[3,"crate_name","","",null,null],[3,"item_children","","",null,null],[3,"extern_mod_stmt_cnum","","",null,null],[3,"get_lang_items","","",null,null],[3,"defined_lang_items","","",null,null],[3,"missing_lang_items","","",null,null],[3,"extern_const_body","","",null,null],[3,"visible_parent_map","","",null,null],[3,"missing_extern_crate_item","","",null,null],[3,"used_crate_source","","",null,null],[3,"postorder_cnums","","",null,null],[3,"freevars","","",null,null],[3,"maybe_unused_trait_import","","",null,null],[3,"maybe_unused_extern_crates","","",null,null],[3,"stability_index","","",null,null],[3,"all_crate_nums","","",null,null],[3,"exported_symbols","","",null,null],[3,"collect_and_partition_translation_items","","",null,null],[3,"symbol_export_level","","",null,null],[3,"is_translated_item","","",null,null],[3,"codegen_unit","","",null,null],[3,"compile_codegen_unit","","",null,null],[3,"output_filenames","","",null,null],[3,"erase_regions_ty","","",null,null],[3,"normalize_projection_ty","","",null,null],[3,"normalize_ty_after_erasing_regions","","",null,null],[3,"dropck_outlives","","",null,null],[3,"substitute_normalize_and_test_predicates","","",null,null],[3,"target_features_whitelist","","",null,null],[3,"instance_def_size_estimate","","",null,null],[3,"features_query","","",null,null],[3,"program_clauses_for","","",null,null],[3,"wasm_custom_sections","","",null,null],[3,"wasm_import_module_map","","",null,null],[8,"Key","rustc::ty::maps","The `Key` trait controls what types can legally be used as the key for a query.",null,null],[10,"map_crate","","Given an instance of this key, what crate is it referring to? This is used to find the provider.",603,{"inputs":[{"name":"self"}],"output":{"name":"cratenum"}}],[10,"default_span","","In the event that a cycle occurs, if no explicit span has been given for a query with key `self`, what span should we use?",603,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"span"}}],[8,"QueryConfig","","Query configuration and description traits.",null,null],[16,"Key","","",604,null],[16,"Value","","",604,null],[11,"new","","",605,{"inputs":[{"generics":["cratenum","providers"],"name":"indexvec"}],"output":{"name":"self"}}],[11,"clone","","",598,{"inputs":[{"name":"self"}],"output":{"name":"query"}}],[11,"fmt","","",598,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",598,{"inputs":[{"name":"self"},{"name":"query"}],"output":{"name":"bool"}}],[11,"ne","","",598,{"inputs":[{"name":"self"},{"name":"query"}],"output":{"name":"bool"}}],[11,"clone","","",599,{"inputs":[{"name":"self"}],"output":{"name":"querymsg"}}],[11,"fmt","","",599,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",599,{"inputs":[{"name":"self"},{"name":"querymsg"}],"output":{"name":"bool"}}],[11,"ne","","",599,{"inputs":[{"name":"self"},{"name":"querymsg"}],"output":{"name":"bool"}}],[11,"describe","","",598,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"string"}}],[11,"ensure","rustc::ty::maps::queries","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",606,null],[11,"try_get","","",606,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["ty","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",607,null],[11,"try_get","","",607,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["generics","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",608,null],[11,"try_get","","",608,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["genericpredicates","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",609,null],[11,"try_get","","",609,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["genericpredicates","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",610,null],[11,"try_get","","",610,null],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",611,null],[11,"try_get","","",611,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["traitdef","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",612,null],[11,"try_get","","",612,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["adtdef","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",613,null],[11,"try_get","","",613,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["option","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",614,null],[11,"try_get","","",614,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",615,null],[11,"try_get","","",615,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["result","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",616,null],[11,"try_get","","",616,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["bool","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",617,null],[11,"try_get","","",617,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["bool","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",618,null],[11,"try_get","","",618,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"cratenum"}],"output":{"generics":["lrc","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",619,null],[11,"try_get","","",619,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["lrc","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",620,null],[11,"try_get","","",620,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["vec","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",621,null],[11,"try_get","","",621,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["lrc","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",622,null],[11,"try_get","","",622,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["associateditem","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",623,null],[11,"try_get","","",623,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["option","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",624,null],[11,"try_get","","",624,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["implpolarity","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",625,null],[11,"try_get","","",625,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["lrc","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",626,null],[11,"try_get","","",626,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"cratenum"}],"output":{"generics":["lrc","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",627,null],[11,"try_get","","",627,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",628,null],[11,"try_get","","",628,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["steal","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",629,null],[11,"try_get","","",629,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["steal","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",630,null],[11,"try_get","","",630,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["steal","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",631,null],[11,"try_get","","",631,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["mir","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",632,null],[11,"try_get","","",632,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["unsafetycheckresult","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",633,null],[11,"try_get","","",633,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",634,null],[11,"try_get","","",634,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["polyfnsig","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",635,null],[11,"try_get","","",635,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["coerceunsizedinfo","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",636,null],[11,"try_get","","",636,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"cratenum"}],"output":{"generics":["compileresult","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",637,null],[11,"try_get","","",637,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["typecktables","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",638,null],[11,"try_get","","",638,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["lrc","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",639,null],[11,"try_get","","",639,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["bool","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",640,null],[11,"try_get","","",640,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",641,null],[11,"try_get","","",641,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["lrc","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",642,null],[11,"try_get","","",642,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["option","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",643,null],[11,"try_get","","",643,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"cratenum"}],"output":{"generics":["crateinherentimpls","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",644,null],[11,"try_get","","",644,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"cratenum"}],"output":{"generics":["diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",645,null],[11,"try_get","","",645,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"generics":["globalid"],"name":"paramenvand"}],"output":{"generics":["evalresult","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",646,null],[11,"try_get","","",646,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["result","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",647,null],[11,"try_get","","",647,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"cratenum"}],"output":{"generics":["lrc","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",648,null],[11,"try_get","","",648,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"cratenum"}],"output":{"generics":["reachableset","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",649,null],[11,"try_get","","",649,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["lrc","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",650,null],[11,"try_get","","",650,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"instancedef"}],"output":{"generics":["mir","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",651,null],[11,"try_get","","",651,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["symbolname","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",652,null],[11,"try_get","","",652,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"instance"}],"output":{"generics":["symbolname","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",653,null],[11,"try_get","","",653,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["option","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",654,null],[11,"try_get","","",654,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["span","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",655,null],[11,"try_get","","",655,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["option","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",656,null],[11,"try_get","","",656,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["option","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",657,null],[11,"try_get","","",657,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["lrc","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",658,null],[11,"try_get","","",658,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["transfnattrs","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",659,null],[11,"try_get","","",659,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["vec","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",660,null],[11,"try_get","","",660,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["option","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",661,null],[11,"try_get","","",661,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["option","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",662,null],[11,"try_get","","",662,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["externbodynestedbodies","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",663,null],[11,"try_get","","",663,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["bool","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",664,null],[11,"try_get","","",664,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["lrc","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",665,null],[11,"try_get","","",665,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["bool","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",666,null],[11,"try_get","","",666,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"polytraitref"}],"output":{"generics":["lrc","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",667,null],[11,"try_get","","",667,null],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",668,null],[11,"try_get","","",668,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["lrc","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",669,null],[11,"try_get","","",669,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["lrc","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",670,null],[11,"try_get","","",670,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["bool","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",671,null],[11,"try_get","","",671,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["paramenv","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",672,null],[11,"try_get","","",672,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"generics":["ty"],"name":"paramenvand"}],"output":{"generics":["bool","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",673,null],[11,"try_get","","",673,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"generics":["ty"],"name":"paramenvand"}],"output":{"generics":["bool","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",674,null],[11,"try_get","","",674,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"generics":["ty"],"name":"paramenvand"}],"output":{"generics":["bool","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",675,null],[11,"try_get","","",675,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"generics":["ty"],"name":"paramenvand"}],"output":{"generics":["bool","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",676,null],[11,"try_get","","",676,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"generics":["ty"],"name":"paramenvand"}],"output":{"generics":["result","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",677,null],[11,"try_get","","",677,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"cratenum"}],"output":{"generics":["lrc","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",678,null],[11,"try_get","","",678,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"cratenum"}],"output":{"generics":["bool","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",679,null],[11,"try_get","","",679,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"cratenum"}],"output":{"generics":["bool","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",680,null],[11,"try_get","","",680,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"cratenum"}],"output":{"generics":["bool","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",681,null],[11,"try_get","","",681,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"cratenum"}],"output":{"generics":["bool","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",682,null],[11,"try_get","","",682,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"cratenum"}],"output":{"generics":["bool","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",683,null],[11,"try_get","","",683,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"cratenum"}],"output":{"generics":["panicstrategy","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",684,null],[11,"try_get","","",684,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"cratenum"}],"output":{"generics":["bool","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",685,null],[11,"try_get","","",685,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["lrc","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",686,null],[11,"try_get","","",686,null],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",687,null],[11,"try_get","","",687,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defindex"}],"output":{"generics":["option","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",688,null],[11,"try_get","","",688,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["option","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",689,null],[11,"try_get","","",689,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"cratenum"}],"output":{"generics":["lrc","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",690,null],[11,"try_get","","",690,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["defaultness","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",691,null],[11,"try_get","","",691,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",692,null],[11,"try_get","","",692,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",693,null],[11,"try_get","","",693,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",694,null],[11,"try_get","","",694,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"cratenum"}],"output":{"generics":["lrc","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",695,null],[11,"try_get","","",695,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["bool","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",696,null],[11,"try_get","","",696,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"cratenum"}],"output":{"generics":["lrc","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",697,null],[11,"try_get","","",697,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"cratenum"}],"output":{"generics":["lrc","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",698,null],[11,"try_get","","",698,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"cratenum"}],"output":{"generics":["option","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",699,null],[11,"try_get","","",699,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"cratenum"}],"output":{"generics":["option","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",700,null],[11,"try_get","","",700,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"cratenum"}],"output":{"generics":["cratedisambiguator","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",701,null],[11,"try_get","","",701,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"cratenum"}],"output":{"generics":["svh","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",702,null],[11,"try_get","","",702,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"cratenum"}],"output":{"generics":["symbol","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",703,null],[11,"try_get","","",703,null],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",704,null],[11,"try_get","","",704,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"cratenum"}],"output":{"generics":["lrc","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",705,null],[11,"try_get","","",705,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"cratenum"}],"output":{"generics":["lrc","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",706,null],[11,"try_get","","",706,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["bool","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",707,null],[11,"try_get","","",707,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["bool","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",708,null],[11,"try_get","","",708,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["option","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",709,null],[11,"try_get","","",709,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"cratenum"}],"output":{"generics":["lrc","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",710,null],[11,"try_get","","",710,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"cratenum"}],"output":{"generics":["lrc","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",711,null],[11,"try_get","","",711,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defindex"}],"output":{"generics":["option","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",712,null],[11,"try_get","","",712,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defindex"}],"output":{"generics":["option","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",713,null],[11,"try_get","","",713,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defindex"}],"output":{"generics":["option","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",714,null],[11,"try_get","","",714,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["visibility","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",715,null],[11,"try_get","","",715,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"cratenum"}],"output":{"generics":["depkind","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",716,null],[11,"try_get","","",716,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"cratenum"}],"output":{"generics":["symbol","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",717,null],[11,"try_get","","",717,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["lrc","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",718,null],[11,"try_get","","",718,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["option","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",719,null],[11,"try_get","","",719,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"cratenum"}],"output":{"generics":["lrc","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",720,null],[11,"try_get","","",720,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"cratenum"}],"output":{"generics":["lrc","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",721,null],[11,"try_get","","",721,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"cratenum"}],"output":{"generics":["lrc","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",722,null],[11,"try_get","","",722,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["externconstbody","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",723,null],[11,"try_get","","",723,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"cratenum"}],"output":{"generics":["lrc","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",724,null],[11,"try_get","","",724,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"cratenum"}],"output":{"generics":["bool","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",725,null],[11,"try_get","","",725,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"cratenum"}],"output":{"generics":["lrc","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",726,null],[11,"try_get","","",726,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"cratenum"}],"output":{"generics":["lrc","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",727,null],[11,"try_get","","",727,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["option","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",728,null],[11,"try_get","","",728,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["bool","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",729,null],[11,"try_get","","",729,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"cratenum"}],"output":{"generics":["lrc","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",730,null],[11,"try_get","","",730,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"cratenum"}],"output":{"generics":["lrc","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",731,null],[11,"try_get","","",731,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"cratenum"}],"output":{"generics":["lrc","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",732,null],[11,"try_get","","",732,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"cratenum"}],"output":{"generics":["arc","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",733,null],[11,"try_get","","",733,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"cratenum"}],"output":{"generics":["diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",734,null],[11,"try_get","","",734,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["symbolexportlevel","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",735,null],[11,"try_get","","",735,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["bool","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",736,null],[11,"try_get","","",736,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"internedstring"}],"output":{"generics":["arc","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",737,null],[11,"try_get","","",737,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"internedstring"}],"output":{"generics":["stats","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",738,null],[11,"try_get","","",738,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"cratenum"}],"output":{"generics":["arc","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",739,null],[11,"try_get","","",739,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"ty"}],"output":{"generics":["ty","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",740,null],[11,"try_get","","",740,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"canonicalprojectiongoal"}],"output":{"generics":["result","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",741,null],[11,"try_get","","",741,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"generics":["ty"],"name":"paramenvand"}],"output":{"generics":["ty","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",742,null],[11,"try_get","","",742,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"canonicaltygoal"}],"output":{"generics":["result","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",743,null],[11,"try_get","","",743,null],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",744,null],[11,"try_get","","",744,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"cratenum"}],"output":{"generics":["lrc","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",745,null],[11,"try_get","","",745,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"instancedef"}],"output":{"generics":["usize","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",746,null],[11,"try_get","","",746,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"cratenum"}],"output":{"generics":["lrc","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",747,null],[11,"try_get","","",747,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"defid"}],"output":{"generics":["lrc","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",748,null],[11,"try_get","","",748,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"cratenum"}],"output":{"generics":["lrc","diagnosticbuilder"],"name":"result"}}],[11,"ensure","","Ensure that either this query has all green inputs or been executed. Executing query::ensure(D) is considered a read of the dep-node D.",749,null],[11,"try_get","","",749,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"cratenum"}],"output":{"generics":["lrc","diagnosticbuilder"],"name":"result"}}],[11,"clone","rustc::ty::maps","",596,{"inputs":[{"name":"self"}],"output":{"name":"tyctxtat"}}],[11,"deref","","",596,null],[11,"at","rustc::ty","Return a transparent wrapper for `TyCtxt` which uses `span` as the location of queries performed through it.",566,{"inputs":[{"name":"self"},{"name":"span"}],"output":{"name":"tyctxtat"}}],[11,"type_of","","Records the type of every item.",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"ty"}}],[11,"generics_of","","Maps from the def-id of an item (trait/struct/enum/fn) to its associated generics and predicates.",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"generics"}}],[11,"predicates_of","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"genericpredicates"}}],[11,"super_predicates_of","","Maps from the def-id of a trait to the list of super-predicates. This is a subset of the full list of predicates. We store these in a separate map because we must evaluate them even during type conversion, often before the full predicates are available (note that supertraits have additional acyclicity requirements).",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"genericpredicates"}}],[11,"type_param_predicates","","To avoid cycles within the predicates of a single item we compute per-type-parameter predicates for resolving `T::AssocTy`.",566,null],[11,"trait_def","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"traitdef"}}],[11,"adt_def","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"adtdef"}}],[11,"adt_destructor","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["destructor"],"name":"option"}}],[11,"adt_sized_constraint","","",566,null],[11,"adt_dtorck_constraint","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["dtorckconstraint","nosolution"],"name":"result"}}],[11,"is_const_fn","","True if this is a const fn",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"bool"}}],[11,"is_foreign_item","","True if this is a foreign item (i.e., linked via `extern { ... }`).",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"bool"}}],[11,"crate_variances","","Get a map with the variance of every item; use `item_variance` instead.",566,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["cratevariancesmap"],"name":"lrc"}}],[11,"variances_of","","Maps from def-id of a type or region parameter to its (inferred) variance.",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["vec"],"name":"lrc"}}],[11,"inferred_outlives_of","","Maps from def-id of a type to its (inferred) outlives.",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["predicate"],"name":"vec"}}],[11,"associated_item_def_ids","","Maps from an impl/trait def-id to a list of the def-ids of its items",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["vec"],"name":"lrc"}}],[11,"associated_item","","Maps from a trait item to the trait item \"descriptor\"",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"associateditem"}}],[11,"impl_trait_ref","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["traitref"],"name":"option"}}],[11,"impl_polarity","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"implpolarity"}}],[11,"inherent_impls","","Maps a DefId of a type to a list of its inherent impls. Contains implementations of methods that are inherent to a type. Methods in these implementations don't need to be exported.",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["vec"],"name":"lrc"}}],[11,"mir_keys","","Set of all the def-ids in this crate that have MIR associated with them. This includes all the body owners, but also things like struct constructors.",566,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["defidset"],"name":"lrc"}}],[11,"mir_const_qualif","","Maps DefId's that have an associated Mir to the result of the MIR qualify_consts pass. The actual meaning of the value isn't known except to the pass itself.",566,null],[11,"mir_built","","Fetch the MIR for a given def-id right after it's built - this includes unreachable code.",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"steal"}}],[11,"mir_const","","Fetch the MIR for a given def-id up till the point where it is ready for const evaluation.",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"steal"}}],[11,"mir_validated","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"steal"}}],[11,"optimized_mir","","MIR after our optimization passes have run. This is MIR that is ready for trans. This is also the only query that can fetch non-local MIR, at present.",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"mir"}}],[11,"unsafety_check_result","","The result of unsafety-checking this def-id.",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"unsafetycheckresult"}}],[11,"unsafe_derive_on_repr_packed","","HACK: when evaluated, this reports a \"unsafe derive on repr(packed)\" error",566,null],[11,"fn_sig","","The signature of functions and closures.",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"polyfnsig"}}],[11,"coerce_unsized_info","","Caches CoerceUnsized kinds for impls on custom types.",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"coerceunsizedinfo"}}],[11,"typeck_item_bodies","","",566,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"compileresult"}}],[11,"typeck_tables_of","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"typecktables"}}],[11,"used_trait_imports","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["defidset"],"name":"lrc"}}],[11,"has_typeck_tables","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"bool"}}],[11,"coherent_trait","","",566,null],[11,"borrowck","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["borrowcheckresult"],"name":"lrc"}}],[11,"mir_borrowck","","Borrow checks the function body. If this is a closure, returns additional requirements that the closure's creator must verify.",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["closureregionrequirements"],"name":"option"}}],[11,"crate_inherent_impls","","Gets a complete map from all types to their inherent impls. Not meant to be used directly outside of coherence. (Defined only for LOCAL_CRATE)",566,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"crateinherentimpls"}}],[11,"crate_inherent_impls_overlap_check","","Checks all types in the krate for overlap in their inherent impls. Reports errors. Not meant to be used directly outside of coherence. (Defined only for LOCAL_CRATE)",566,null],[11,"const_eval","","Results of evaluating const items or constants embedded in other items (such as enum variant explicit discriminants).",566,{"inputs":[{"name":"self"},{"generics":["globalid"],"name":"paramenvand"}],"output":{"name":"evalresult"}}],[11,"check_match","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["errorreported"],"name":"result"}}],[11,"privacy_access_levels","","Performs the privacy check and computes \"access levels\".",566,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["accesslevels"],"name":"lrc"}}],[11,"reachable_set","","",566,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"reachableset"}}],[11,"region_scope_tree","","Per-body `region::ScopeTree`. The `DefId` should be the owner-def-id for the body; in the case of closures, this will be redirected to the enclosing function.",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["scopetree"],"name":"lrc"}}],[11,"mir_shims","","",566,{"inputs":[{"name":"self"},{"name":"instancedef"}],"output":{"name":"mir"}}],[11,"def_symbol_name","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"symbolname"}}],[11,"symbol_name","","",566,{"inputs":[{"name":"self"},{"name":"instance"}],"output":{"name":"symbolname"}}],[11,"describe_def","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["def"],"name":"option"}}],[11,"def_span","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"span"}}],[11,"lookup_stability","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["stability"],"name":"option"}}],[11,"lookup_deprecation_entry","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["deprecationentry"],"name":"option"}}],[11,"item_attrs","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"lrc"}}],[11,"trans_fn_attrs","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"transfnattrs"}}],[11,"fn_arg_names","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["name"],"name":"vec"}}],[11,"impl_parent","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["defid"],"name":"option"}}],[11,"trait_of_item","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["defid"],"name":"option"}}],[11,"item_body_nested_bodies","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"externbodynestedbodies"}}],[11,"const_is_rvalue_promotable_to_static","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"bool"}}],[11,"rvalue_promotable_map","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["itemlocalset"],"name":"lrc"}}],[11,"is_mir_available","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"bool"}}],[11,"vtable_methods","","",566,{"inputs":[{"name":"self"},{"name":"polytraitref"}],"output":{"generics":["vec"],"name":"lrc"}}],[11,"trans_fulfill_obligation","","",566,null],[11,"trait_impls_of","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["traitimpls"],"name":"lrc"}}],[11,"specialization_graph_of","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["graph"],"name":"lrc"}}],[11,"is_object_safe","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"bool"}}],[11,"param_env","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"paramenv"}}],[11,"is_copy_raw","","",566,{"inputs":[{"name":"self"},{"generics":["ty"],"name":"paramenvand"}],"output":{"name":"bool"}}],[11,"is_sized_raw","","",566,{"inputs":[{"name":"self"},{"generics":["ty"],"name":"paramenvand"}],"output":{"name":"bool"}}],[11,"is_freeze_raw","","",566,{"inputs":[{"name":"self"},{"generics":["ty"],"name":"paramenvand"}],"output":{"name":"bool"}}],[11,"needs_drop_raw","","",566,{"inputs":[{"name":"self"},{"generics":["ty"],"name":"paramenvand"}],"output":{"name":"bool"}}],[11,"layout_raw","","",566,{"inputs":[{"name":"self"},{"generics":["ty"],"name":"paramenvand"}],"output":{"generics":["layoutdetails","layouterror"],"name":"result"}}],[11,"dylib_dependency_formats","","",566,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["vec"],"name":"lrc"}}],[11,"is_panic_runtime","","",566,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"bool"}}],[11,"is_compiler_builtins","","",566,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"bool"}}],[11,"has_global_allocator","","",566,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"bool"}}],[11,"is_sanitizer_runtime","","",566,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"bool"}}],[11,"is_profiler_runtime","","",566,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"bool"}}],[11,"panic_strategy","","",566,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"panicstrategy"}}],[11,"is_no_builtins","","",566,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"bool"}}],[11,"extern_crate","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["option"],"name":"lrc"}}],[11,"specializes","","",566,null],[11,"in_scope_traits_map","","",566,{"inputs":[{"name":"self"},{"name":"defindex"}],"output":{"generics":["lrc"],"name":"option"}}],[11,"module_exports","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["lrc"],"name":"option"}}],[11,"lint_levels","","",566,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["lintlevelmap"],"name":"lrc"}}],[11,"impl_defaultness","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"defaultness"}}],[11,"check_item_well_formed","","",566,null],[11,"check_trait_item_well_formed","","",566,null],[11,"check_impl_item_well_formed","","",566,null],[11,"reachable_non_generics","","",566,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["defidset"],"name":"lrc"}}],[11,"is_reachable_non_generic","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"bool"}}],[11,"native_libraries","","",566,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["vec"],"name":"lrc"}}],[11,"foreign_modules","","",566,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["vec"],"name":"lrc"}}],[11,"plugin_registrar_fn","","",566,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["defid"],"name":"option"}}],[11,"derive_registrar_fn","","",566,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["defid"],"name":"option"}}],[11,"crate_disambiguator","","",566,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"cratedisambiguator"}}],[11,"crate_hash","","",566,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"svh"}}],[11,"original_crate_name","","",566,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"symbol"}}],[11,"implementations_of_trait","","",566,null],[11,"all_trait_implementations","","",566,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["vec"],"name":"lrc"}}],[11,"dllimport_foreign_items","","",566,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["fxhashset"],"name":"lrc"}}],[11,"is_dllimport_foreign_item","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"bool"}}],[11,"is_statically_included_foreign_item","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"bool"}}],[11,"native_library_kind","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["nativelibrarykind"],"name":"option"}}],[11,"link_args","","",566,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["vec"],"name":"lrc"}}],[11,"resolve_lifetimes","","",566,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["resolvelifetimes"],"name":"lrc"}}],[11,"named_region_map","","",566,{"inputs":[{"name":"self"},{"name":"defindex"}],"output":{"generics":["lrc"],"name":"option"}}],[11,"is_late_bound_map","","",566,{"inputs":[{"name":"self"},{"name":"defindex"}],"output":{"generics":["lrc"],"name":"option"}}],[11,"object_lifetime_defaults_map","","",566,{"inputs":[{"name":"self"},{"name":"defindex"}],"output":{"generics":["lrc"],"name":"option"}}],[11,"visibility","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"visibility"}}],[11,"dep_kind","","",566,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"depkind"}}],[11,"crate_name","","",566,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"symbol"}}],[11,"item_children","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["vec"],"name":"lrc"}}],[11,"extern_mod_stmt_cnum","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["cratenum"],"name":"option"}}],[11,"get_lang_items","","",566,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["languageitems"],"name":"lrc"}}],[11,"defined_lang_items","","",566,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["vec"],"name":"lrc"}}],[11,"missing_lang_items","","",566,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["vec"],"name":"lrc"}}],[11,"extern_const_body","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"externconstbody"}}],[11,"visible_parent_map","","",566,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["defidmap"],"name":"lrc"}}],[11,"missing_extern_crate_item","","",566,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"bool"}}],[11,"used_crate_source","","",566,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["cratesource"],"name":"lrc"}}],[11,"postorder_cnums","","",566,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["vec"],"name":"lrc"}}],[11,"freevars","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["lrc"],"name":"option"}}],[11,"maybe_unused_trait_import","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"bool"}}],[11,"maybe_unused_extern_crates","","",566,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["vec"],"name":"lrc"}}],[11,"stability_index","","",566,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["index"],"name":"lrc"}}],[11,"all_crate_nums","","",566,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["vec"],"name":"lrc"}}],[11,"exported_symbols","","",566,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["vec"],"name":"arc"}}],[11,"collect_and_partition_translation_items","","",566,null],[11,"symbol_export_level","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"symbolexportlevel"}}],[11,"is_translated_item","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"bool"}}],[11,"codegen_unit","","",566,{"inputs":[{"name":"self"},{"name":"internedstring"}],"output":{"generics":["codegenunit"],"name":"arc"}}],[11,"compile_codegen_unit","","",566,{"inputs":[{"name":"self"},{"name":"internedstring"}],"output":{"name":"stats"}}],[11,"output_filenames","","",566,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["outputfilenames"],"name":"arc"}}],[11,"erase_regions_ty","","",566,{"inputs":[{"name":"self"},{"name":"ty"}],"output":{"name":"ty"}}],[11,"normalize_projection_ty","","Do not call this query directly: invoke `normalize` instead.",566,{"inputs":[{"name":"self"},{"name":"canonicalprojectiongoal"}],"output":{"generics":["lrc","nosolution"],"name":"result"}}],[11,"normalize_ty_after_erasing_regions","","Do not call this query directly: invoke `normalize_erasing_regions` instead.",566,{"inputs":[{"name":"self"},{"generics":["ty"],"name":"paramenvand"}],"output":{"name":"ty"}}],[11,"dropck_outlives","","Do not call this query directly: invoke `infcx.at().dropck_outlives()` instead.",566,{"inputs":[{"name":"self"},{"name":"canonicaltygoal"}],"output":{"generics":["lrc","nosolution"],"name":"result"}}],[11,"substitute_normalize_and_test_predicates","","",566,null],[11,"target_features_whitelist","","",566,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["fxhashset"],"name":"lrc"}}],[11,"instance_def_size_estimate","","",566,{"inputs":[{"name":"self"},{"name":"instancedef"}],"output":{"name":"usize"}}],[11,"features_query","","",566,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["features"],"name":"lrc"}}],[11,"program_clauses_for","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["vec"],"name":"lrc"}}],[11,"wasm_custom_sections","","",566,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["vec"],"name":"lrc"}}],[11,"wasm_import_module_map","","",566,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["fxhashmap"],"name":"lrc"}}],[11,"type_of","rustc::ty::maps","Records the type of every item.",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"ty"}}],[11,"generics_of","","Maps from the def-id of an item (trait/struct/enum/fn) to its associated generics and predicates.",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"generics"}}],[11,"predicates_of","","",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"genericpredicates"}}],[11,"super_predicates_of","","Maps from the def-id of a trait to the list of super-predicates. This is a subset of the full list of predicates. We store these in a separate map because we must evaluate them even during type conversion, often before the full predicates are available (note that supertraits have additional acyclicity requirements).",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"genericpredicates"}}],[11,"type_param_predicates","","To avoid cycles within the predicates of a single item we compute per-type-parameter predicates for resolving `T::AssocTy`.",596,null],[11,"trait_def","","",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"traitdef"}}],[11,"adt_def","","",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"adtdef"}}],[11,"adt_destructor","","",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["destructor"],"name":"option"}}],[11,"adt_sized_constraint","","",596,null],[11,"adt_dtorck_constraint","","",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["dtorckconstraint","nosolution"],"name":"result"}}],[11,"is_const_fn","","True if this is a const fn",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"bool"}}],[11,"is_foreign_item","","True if this is a foreign item (i.e., linked via `extern { ... }`).",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"bool"}}],[11,"crate_variances","","Get a map with the variance of every item; use `item_variance` instead.",596,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["cratevariancesmap"],"name":"lrc"}}],[11,"variances_of","","Maps from def-id of a type or region parameter to its (inferred) variance.",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["vec"],"name":"lrc"}}],[11,"inferred_outlives_of","","Maps from def-id of a type to its (inferred) outlives.",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["predicate"],"name":"vec"}}],[11,"associated_item_def_ids","","Maps from an impl/trait def-id to a list of the def-ids of its items",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["vec"],"name":"lrc"}}],[11,"associated_item","","Maps from a trait item to the trait item \"descriptor\"",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"associateditem"}}],[11,"impl_trait_ref","","",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["traitref"],"name":"option"}}],[11,"impl_polarity","","",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"implpolarity"}}],[11,"inherent_impls","","Maps a DefId of a type to a list of its inherent impls. Contains implementations of methods that are inherent to a type. Methods in these implementations don't need to be exported.",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["vec"],"name":"lrc"}}],[11,"mir_keys","","Set of all the def-ids in this crate that have MIR associated with them. This includes all the body owners, but also things like struct constructors.",596,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["defidset"],"name":"lrc"}}],[11,"mir_const_qualif","","Maps DefId's that have an associated Mir to the result of the MIR qualify_consts pass. The actual meaning of the value isn't known except to the pass itself.",596,null],[11,"mir_built","","Fetch the MIR for a given def-id right after it's built - this includes unreachable code.",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"steal"}}],[11,"mir_const","","Fetch the MIR for a given def-id up till the point where it is ready for const evaluation.",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"steal"}}],[11,"mir_validated","","",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"steal"}}],[11,"optimized_mir","","MIR after our optimization passes have run. This is MIR that is ready for trans. This is also the only query that can fetch non-local MIR, at present.",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"mir"}}],[11,"unsafety_check_result","","The result of unsafety-checking this def-id.",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"unsafetycheckresult"}}],[11,"unsafe_derive_on_repr_packed","","HACK: when evaluated, this reports a \"unsafe derive on repr(packed)\" error",596,null],[11,"fn_sig","","The signature of functions and closures.",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"polyfnsig"}}],[11,"coerce_unsized_info","","Caches CoerceUnsized kinds for impls on custom types.",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"coerceunsizedinfo"}}],[11,"typeck_item_bodies","","",596,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"compileresult"}}],[11,"typeck_tables_of","","",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"typecktables"}}],[11,"used_trait_imports","","",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["defidset"],"name":"lrc"}}],[11,"has_typeck_tables","","",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"bool"}}],[11,"coherent_trait","","",596,null],[11,"borrowck","","",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["borrowcheckresult"],"name":"lrc"}}],[11,"mir_borrowck","","Borrow checks the function body. If this is a closure, returns additional requirements that the closure's creator must verify.",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["closureregionrequirements"],"name":"option"}}],[11,"crate_inherent_impls","","Gets a complete map from all types to their inherent impls. Not meant to be used directly outside of coherence. (Defined only for LOCAL_CRATE)",596,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"crateinherentimpls"}}],[11,"crate_inherent_impls_overlap_check","","Checks all types in the krate for overlap in their inherent impls. Reports errors. Not meant to be used directly outside of coherence. (Defined only for LOCAL_CRATE)",596,null],[11,"const_eval","","Results of evaluating const items or constants embedded in other items (such as enum variant explicit discriminants).",596,{"inputs":[{"name":"self"},{"generics":["globalid"],"name":"paramenvand"}],"output":{"name":"evalresult"}}],[11,"check_match","","",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["errorreported"],"name":"result"}}],[11,"privacy_access_levels","","Performs the privacy check and computes \"access levels\".",596,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["accesslevels"],"name":"lrc"}}],[11,"reachable_set","","",596,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"reachableset"}}],[11,"region_scope_tree","","Per-body `region::ScopeTree`. The `DefId` should be the owner-def-id for the body; in the case of closures, this will be redirected to the enclosing function.",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["scopetree"],"name":"lrc"}}],[11,"mir_shims","","",596,{"inputs":[{"name":"self"},{"name":"instancedef"}],"output":{"name":"mir"}}],[11,"def_symbol_name","","",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"symbolname"}}],[11,"symbol_name","","",596,{"inputs":[{"name":"self"},{"name":"instance"}],"output":{"name":"symbolname"}}],[11,"describe_def","","",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["def"],"name":"option"}}],[11,"def_span","","",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"span"}}],[11,"lookup_stability","","",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["stability"],"name":"option"}}],[11,"lookup_deprecation_entry","","",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["deprecationentry"],"name":"option"}}],[11,"item_attrs","","",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"lrc"}}],[11,"trans_fn_attrs","","",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"transfnattrs"}}],[11,"fn_arg_names","","",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["name"],"name":"vec"}}],[11,"impl_parent","","",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["defid"],"name":"option"}}],[11,"trait_of_item","","",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["defid"],"name":"option"}}],[11,"item_body_nested_bodies","","",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"externbodynestedbodies"}}],[11,"const_is_rvalue_promotable_to_static","","",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"bool"}}],[11,"rvalue_promotable_map","","",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["itemlocalset"],"name":"lrc"}}],[11,"is_mir_available","","",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"bool"}}],[11,"vtable_methods","","",596,{"inputs":[{"name":"self"},{"name":"polytraitref"}],"output":{"generics":["vec"],"name":"lrc"}}],[11,"trans_fulfill_obligation","","",596,null],[11,"trait_impls_of","","",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["traitimpls"],"name":"lrc"}}],[11,"specialization_graph_of","","",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["graph"],"name":"lrc"}}],[11,"is_object_safe","","",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"bool"}}],[11,"param_env","","",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"paramenv"}}],[11,"is_copy_raw","","",596,{"inputs":[{"name":"self"},{"generics":["ty"],"name":"paramenvand"}],"output":{"name":"bool"}}],[11,"is_sized_raw","","",596,{"inputs":[{"name":"self"},{"generics":["ty"],"name":"paramenvand"}],"output":{"name":"bool"}}],[11,"is_freeze_raw","","",596,{"inputs":[{"name":"self"},{"generics":["ty"],"name":"paramenvand"}],"output":{"name":"bool"}}],[11,"needs_drop_raw","","",596,{"inputs":[{"name":"self"},{"generics":["ty"],"name":"paramenvand"}],"output":{"name":"bool"}}],[11,"layout_raw","","",596,{"inputs":[{"name":"self"},{"generics":["ty"],"name":"paramenvand"}],"output":{"generics":["layoutdetails","layouterror"],"name":"result"}}],[11,"dylib_dependency_formats","","",596,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["vec"],"name":"lrc"}}],[11,"is_panic_runtime","","",596,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"bool"}}],[11,"is_compiler_builtins","","",596,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"bool"}}],[11,"has_global_allocator","","",596,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"bool"}}],[11,"is_sanitizer_runtime","","",596,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"bool"}}],[11,"is_profiler_runtime","","",596,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"bool"}}],[11,"panic_strategy","","",596,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"panicstrategy"}}],[11,"is_no_builtins","","",596,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"bool"}}],[11,"extern_crate","","",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["option"],"name":"lrc"}}],[11,"specializes","","",596,null],[11,"in_scope_traits_map","","",596,{"inputs":[{"name":"self"},{"name":"defindex"}],"output":{"generics":["lrc"],"name":"option"}}],[11,"module_exports","","",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["lrc"],"name":"option"}}],[11,"lint_levels","","",596,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["lintlevelmap"],"name":"lrc"}}],[11,"impl_defaultness","","",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"defaultness"}}],[11,"check_item_well_formed","","",596,null],[11,"check_trait_item_well_formed","","",596,null],[11,"check_impl_item_well_formed","","",596,null],[11,"reachable_non_generics","","",596,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["defidset"],"name":"lrc"}}],[11,"is_reachable_non_generic","","",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"bool"}}],[11,"native_libraries","","",596,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["vec"],"name":"lrc"}}],[11,"foreign_modules","","",596,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["vec"],"name":"lrc"}}],[11,"plugin_registrar_fn","","",596,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["defid"],"name":"option"}}],[11,"derive_registrar_fn","","",596,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["defid"],"name":"option"}}],[11,"crate_disambiguator","","",596,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"cratedisambiguator"}}],[11,"crate_hash","","",596,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"svh"}}],[11,"original_crate_name","","",596,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"symbol"}}],[11,"implementations_of_trait","","",596,null],[11,"all_trait_implementations","","",596,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["vec"],"name":"lrc"}}],[11,"dllimport_foreign_items","","",596,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["fxhashset"],"name":"lrc"}}],[11,"is_dllimport_foreign_item","","",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"bool"}}],[11,"is_statically_included_foreign_item","","",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"bool"}}],[11,"native_library_kind","","",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["nativelibrarykind"],"name":"option"}}],[11,"link_args","","",596,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["vec"],"name":"lrc"}}],[11,"resolve_lifetimes","","",596,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["resolvelifetimes"],"name":"lrc"}}],[11,"named_region_map","","",596,{"inputs":[{"name":"self"},{"name":"defindex"}],"output":{"generics":["lrc"],"name":"option"}}],[11,"is_late_bound_map","","",596,{"inputs":[{"name":"self"},{"name":"defindex"}],"output":{"generics":["lrc"],"name":"option"}}],[11,"object_lifetime_defaults_map","","",596,{"inputs":[{"name":"self"},{"name":"defindex"}],"output":{"generics":["lrc"],"name":"option"}}],[11,"visibility","","",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"visibility"}}],[11,"dep_kind","","",596,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"depkind"}}],[11,"crate_name","","",596,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"symbol"}}],[11,"item_children","","",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["vec"],"name":"lrc"}}],[11,"extern_mod_stmt_cnum","","",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["cratenum"],"name":"option"}}],[11,"get_lang_items","","",596,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["languageitems"],"name":"lrc"}}],[11,"defined_lang_items","","",596,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["vec"],"name":"lrc"}}],[11,"missing_lang_items","","",596,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["vec"],"name":"lrc"}}],[11,"extern_const_body","","",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"externconstbody"}}],[11,"visible_parent_map","","",596,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["defidmap"],"name":"lrc"}}],[11,"missing_extern_crate_item","","",596,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"bool"}}],[11,"used_crate_source","","",596,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["cratesource"],"name":"lrc"}}],[11,"postorder_cnums","","",596,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["vec"],"name":"lrc"}}],[11,"freevars","","",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["lrc"],"name":"option"}}],[11,"maybe_unused_trait_import","","",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"bool"}}],[11,"maybe_unused_extern_crates","","",596,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["vec"],"name":"lrc"}}],[11,"stability_index","","",596,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["index"],"name":"lrc"}}],[11,"all_crate_nums","","",596,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["vec"],"name":"lrc"}}],[11,"exported_symbols","","",596,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["vec"],"name":"arc"}}],[11,"collect_and_partition_translation_items","","",596,null],[11,"symbol_export_level","","",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"symbolexportlevel"}}],[11,"is_translated_item","","",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"bool"}}],[11,"codegen_unit","","",596,{"inputs":[{"name":"self"},{"name":"internedstring"}],"output":{"generics":["codegenunit"],"name":"arc"}}],[11,"compile_codegen_unit","","",596,{"inputs":[{"name":"self"},{"name":"internedstring"}],"output":{"name":"stats"}}],[11,"output_filenames","","",596,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["outputfilenames"],"name":"arc"}}],[11,"erase_regions_ty","","",596,{"inputs":[{"name":"self"},{"name":"ty"}],"output":{"name":"ty"}}],[11,"normalize_projection_ty","","Do not call this query directly: invoke `normalize` instead.",596,{"inputs":[{"name":"self"},{"name":"canonicalprojectiongoal"}],"output":{"generics":["lrc","nosolution"],"name":"result"}}],[11,"normalize_ty_after_erasing_regions","","Do not call this query directly: invoke `normalize_erasing_regions` instead.",596,{"inputs":[{"name":"self"},{"generics":["ty"],"name":"paramenvand"}],"output":{"name":"ty"}}],[11,"dropck_outlives","","Do not call this query directly: invoke `infcx.at().dropck_outlives()` instead.",596,{"inputs":[{"name":"self"},{"name":"canonicaltygoal"}],"output":{"generics":["lrc","nosolution"],"name":"result"}}],[11,"substitute_normalize_and_test_predicates","","",596,null],[11,"target_features_whitelist","","",596,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["fxhashset"],"name":"lrc"}}],[11,"instance_def_size_estimate","","",596,{"inputs":[{"name":"self"},{"name":"instancedef"}],"output":{"name":"usize"}}],[11,"features_query","","",596,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["features"],"name":"lrc"}}],[11,"program_clauses_for","","",596,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["vec"],"name":"lrc"}}],[11,"wasm_custom_sections","","",596,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["vec"],"name":"lrc"}}],[11,"wasm_import_module_map","","",596,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["fxhashmap"],"name":"lrc"}}],[11,"default","","",597,{"inputs":[],"output":{"name":"self"}}],[11,"clone","","",597,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[0,"outlives","rustc::ty","",null,null],[4,"Component","rustc::ty::outlives","",null,null],[13,"Region","","",750,null],[13,"Param","","",750,null],[13,"UnresolvedInferenceVariable","","",750,null],[13,"Projection","","",750,null],[13,"EscapingProjection","","",750,null],[11,"fmt","","",750,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"outlives_components","rustc::ty","Returns all the things that must outlive `'a` for the condition `ty0: 'a` to hold. Note that `ty0` must be a fully resolved type.",566,{"inputs":[{"name":"self"},{"name":"ty"}],"output":{"generics":["component"],"name":"vec"}}],[0,"relate","","Generalized type relating mechanism. A type relation R relates a pair of values (A, B). A and B are usually types or regions but can be other things. Examples of type relations are subtyping, type equality, etc.",null,null],[4,"Cause","rustc::ty::relate","",null,null],[13,"ExistentialRegionBound","","",751,null],[5,"relate_substs","","",null,{"inputs":[{"name":"r"},{"generics":["vec"],"name":"option"},{"name":"substs"},{"name":"substs"}],"output":{"generics":["substs"],"name":"relateresult"}}],[5,"super_relate_tys","","The main \"type relation\" routine. Note that this does not handle inference artifacts, so you should filter those out before calling it.",null,{"inputs":[{"name":"r"},{"name":"ty"},{"name":"ty"}],"output":{"generics":["ty"],"name":"relateresult"}}],[5,"expected_found","","",null,{"inputs":[{"name":"r"},{"name":"t"},{"name":"t"}],"output":{"name":"expectedfound"}}],[5,"expected_found_bool","","",null,{"inputs":[{"name":"bool"},{"name":"t"},{"name":"t"}],"output":{"name":"expectedfound"}}],[6,"RelateResult","","",null,null],[8,"TypeRelation","","",null,null],[10,"tcx","","",752,{"inputs":[{"name":"self"}],"output":{"name":"tyctxt"}}],[10,"tag","","Returns a static string we can use for printouts.",752,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[10,"a_is_expected","","Returns true if the value `a` is the \"expected\" type in the relation. Just affects error messages.",752,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"with_cause","","",752,{"inputs":[{"name":"self"},{"name":"cause"},{"name":"f"}],"output":{"name":"r"}}],[11,"relate","","Generic relation routine suitable for most anything.",752,{"inputs":[{"name":"self"},{"name":"t"},{"name":"t"}],"output":{"name":"relateresult"}}],[11,"relate_item_substs","","Relate the two substitutions for the given item. The default is to look up the variance for the item and proceed accordingly.",752,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"substs"},{"name":"substs"}],"output":{"generics":["substs"],"name":"relateresult"}}],[10,"relate_with_variance","","Switch variance for the purpose of relating `a` and `b`.",752,{"inputs":[{"name":"self"},{"name":"variance"},{"name":"t"},{"name":"t"}],"output":{"name":"relateresult"}}],[10,"tys","","",752,{"inputs":[{"name":"self"},{"name":"ty"},{"name":"ty"}],"output":{"generics":["ty"],"name":"relateresult"}}],[10,"regions","","",752,{"inputs":[{"name":"self"},{"name":"region"},{"name":"region"}],"output":{"generics":["region"],"name":"relateresult"}}],[10,"binders","","",752,{"inputs":[{"name":"self"},{"name":"binder"},{"name":"binder"}],"output":{"generics":["binder"],"name":"relateresult"}}],[8,"Relate","","",null,null],[10,"relate","","",753,{"inputs":[{"name":"r"},{"name":"self"},{"name":"self"}],"output":{"name":"relateresult"}}],[11,"clone","","",751,{"inputs":[{"name":"self"}],"output":{"name":"cause"}}],[11,"fmt","","",751,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"relate","rustc::ty","",487,{"inputs":[{"name":"r"},{"name":"typeandmut"},{"name":"typeandmut"}],"output":{"generics":["typeandmut"],"name":"relateresult"}}],[11,"relate","","",481,{"inputs":[{"name":"r"},{"name":"fnsig"},{"name":"fnsig"}],"output":{"generics":["fnsig"],"name":"relateresult"}}],[11,"relate","rustc::hir","",112,{"inputs":[{"name":"r"},{"name":"unsafety"},{"name":"unsafety"}],"output":{"generics":["unsafety"],"name":"relateresult"}}],[11,"relate","rustc::ty","",484,{"inputs":[{"name":"r"},{"name":"projectionty"},{"name":"projectionty"}],"output":{"generics":["projectionty"],"name":"relateresult"}}],[11,"relate","","",490,{"inputs":[{"name":"r"},{"name":"existentialprojection"},{"name":"existentialprojection"}],"output":{"generics":["existentialprojection"],"name":"relateresult"}}],[11,"relate","","",488,{"inputs":[{"name":"r"},{"name":"traitref"},{"name":"traitref"}],"output":{"generics":["traitref"],"name":"relateresult"}}],[11,"relate","","",489,{"inputs":[{"name":"r"},{"name":"existentialtraitref"},{"name":"existentialtraitref"}],"output":{"generics":["existentialtraitref"],"name":"relateresult"}}],[11,"relate","","",485,{"inputs":[{"name":"r"},{"name":"closuresubsts"},{"name":"closuresubsts"}],"output":{"generics":["closuresubsts"],"name":"relateresult"}}],[11,"relate","","",486,{"inputs":[{"name":"r"},{"name":"generatorinterior"},{"name":"generatorinterior"}],"output":{"generics":["generatorinterior"],"name":"relateresult"}}],[11,"relate","","",479,{"inputs":[{"name":"r"},{"name":"binder"},{"name":"binder"}],"output":{"generics":["binder"],"name":"relateresult"}}],[0,"steal","","",null,null],[3,"Steal","rustc::ty::steal","The `Steal` struct is intended to used as the value for a query. Specifically, we sometimes have queries (cough MIR cough) where we create a large, complex value that we want to iteratively update (e.g., optimize). We could clone the value for each optimization, but that'd be expensive. And yet we don't just want to mutate it in place, because that would spoil the idea that queries are these pure functions that produce an immutable value (since if you did the query twice, you could observe the mutations). So instead we have the query produce a `&'tcx Steal<Mir<'tcx>>` (to be very specific). Now we can read from this as much as we want (using `borrow()`), but you can also `steal()`. Once you steal, any further attempt to read will panic. Therefore we know that -- assuming no ICE -- nobody is observing the fact that the MIR was updated.",null,null],[11,"new","","",754,{"inputs":[{"name":"t"}],"output":{"name":"self"}}],[11,"borrow","","",754,{"inputs":[{"name":"self"}],"output":{"name":"ref"}}],[11,"steal","","",754,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[0,"subst","rustc::ty","",null,null],[3,"Kind","rustc::ty::subst","An entity in the Rust typesystem, which can be one of several kinds (only types and lifetimes for now). To reduce memory usage, a `Kind` is a interned pointer, with the lowest 2 bits being reserved for a tag to indicate the type (`Ty` or `Region`) it points to.",null,null],[4,"UnpackedKind","","",null,null],[13,"Lifetime","","",755,null],[13,"Type","","",755,null],[6,"Substs","","A substitution mapping type/region parameters to new values.",null,null],[8,"Subst","","",null,null],[11,"subst","","",756,null],[10,"subst_spanned","","",756,null],[11,"clone","","",757,{"inputs":[{"name":"self"}],"output":{"name":"kind"}}],[11,"eq","","",757,{"inputs":[{"name":"self"},{"name":"kind"}],"output":{"name":"bool"}}],[11,"ne","","",757,{"inputs":[{"name":"self"},{"name":"kind"}],"output":{"name":"bool"}}],[11,"hash","","",757,null],[11,"fmt","","",755,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"from","","",757,{"inputs":[{"name":"region"}],"output":{"name":"kind"}}],[11,"from","","",757,{"inputs":[{"name":"ty"}],"output":{"name":"kind"}}],[11,"unpack","","",757,{"inputs":[{"name":"self"}],"output":{"name":"unpackedkind"}}],[11,"fmt","","",757,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",757,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"lift_to_tcx","","",757,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"super_fold_with","","",757,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"self"}}],[11,"super_visit_with","","",757,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"encode","","",757,{"inputs":[{"name":"self"},{"name":"e"}],"output":{"name":"result"}}],[11,"decode","","",757,{"inputs":[{"name":"d"}],"output":{"generics":["kind"],"name":"result"}}],[11,"identity_for_item","","Creates a Substs that maps each generic parameter to itself.",758,{"inputs":[{"name":"tyctxt"},{"name":"defid"}],"output":{"name":"substs"}}],[11,"for_item","","Creates a Substs for generic parameter definitions, by calling closures to obtain each region and type. The closures get to observe the Substs as they're being built, which can be used to correctly substitute defaults of type parameters.",758,{"inputs":[{"name":"tyctxt"},{"name":"defid"},{"name":"fr"},{"name":"ft"}],"output":{"name":"substs"}}],[11,"extend_to","","",758,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"defid"},{"name":"fr"},{"name":"ft"}],"output":{"name":"substs"}}],[11,"fill_item","","",758,{"inputs":[{"name":"vec"},{"name":"tyctxt"},{"name":"generics"},{"name":"fr"},{"name":"ft"}],"output":null}],[11,"is_noop","","",758,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"types","","",758,null],[11,"regions","","",758,null],[11,"type_at","","",758,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"ty"}}],[11,"region_at","","",758,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"region"}}],[11,"type_for_def","","",758,{"inputs":[{"name":"self"},{"name":"typeparameterdef"}],"output":{"name":"ty"}}],[11,"region_for_def","","",758,{"inputs":[{"name":"self"},{"name":"regionparameterdef"}],"output":{"name":"region"}}],[11,"rebase_onto","","Transform from substitutions for a child of `source_ancestor` (e.g. a trait or impl) to substitutions for the same child in a different item, with `target_substs` as the base for the target impl/trait, with the source child-specific parameters (e.g. method parameters) on top of that base.",758,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"defid"},{"name":"substs"}],"output":{"name":"substs"}}],[11,"truncate_to","","",758,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"generics"}],"output":{"name":"substs"}}],[11,"from_method","rustc::ty","",488,{"inputs":[{"name":"tyctxt"},{"name":"defid"},{"name":"substs"}],"output":{"name":"traitref"}}],[11,"erase_self_ty","","",489,{"inputs":[{"name":"tyctxt"},{"name":"traitref"}],"output":{"name":"existentialtraitref"}}],[0,"trait_def","","",null,null],[3,"TraitDef","rustc::ty::trait_def","A trait's definition with type information.",null,null],[12,"def_id","","",759,null],[12,"unsafety","","",759,null],[12,"paren_sugar","","If `true`, then this trait had the `#[rustc_paren_sugar]` attribute, indicating that it should be used with `Foo()` sugar. This is a temporary thing -- eventually any trait will be usable with the sugar (or without it).",759,null],[12,"has_auto_impl","","",759,null],[12,"def_path_hash","","The ICH of this trait's DefPath, cached here so it doesn't have to be recomputed all the time.",759,null],[3,"TraitImpls","","",null,null],[11,"new","","",759,{"inputs":[{"name":"defid"},{"name":"unsafety"},{"name":"bool"},{"name":"bool"},{"name":"defpathhash"}],"output":{"name":"traitdef"}}],[11,"ancestors","","",759,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"defid"}],"output":{"name":"ancestors"}}],[11,"for_each_impl","rustc::ty","",566,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"f"}],"output":null}],[11,"for_each_relevant_impl","","Iterate over every impl that could possibly match the self-type `self_ty`.",566,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"ty"},{"name":"f"}],"output":null}],[11,"hash_stable","rustc::ty::trait_def","",760,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[0,"walk","rustc::ty","An iterator over the type substructure. WARNING: this does not keep track of the region depth.",null,null],[3,"TypeWalker","rustc::ty::walk","",null,null],[5,"walk_shallow","","",null,{"inputs":[{"name":"ty"}],"output":{"generics":["typewalkerarray"],"name":"accintoiter"}}],[6,"TypeWalkerArray","","",null,null],[6,"TypeWalkerStack","","",null,null],[11,"new","","",761,{"inputs":[{"name":"ty"}],"output":{"name":"typewalker"}}],[11,"skip_current_subtree","","Skips the subtree of types corresponding to the last type returned by `next()`.",761,{"inputs":[{"name":"self"}],"output":null}],[11,"next","","",761,{"inputs":[{"name":"self"}],"output":{"generics":["ty"],"name":"option"}}],[0,"wf","rustc::ty","",null,null],[5,"obligations","rustc::ty::wf","Returns the set of obligations needed to make `ty` well-formed. If `ty` contains unresolved inference variables, this may include further WF obligations. However, if `ty` IS an unresolved inference variable, returns `None`, because we are not able to make any progress at all. This is to prevent \"livelock\" where we say \"$0 is WF if $0 is WF\".",null,{"inputs":[{"name":"inferctxt"},{"name":"paramenv"},{"name":"nodeid"},{"name":"ty"},{"name":"span"}],"output":{"generics":["vec"],"name":"option"}}],[5,"trait_obligations","","Returns the obligations that make this trait reference well-formed.  For example, if there is a trait `Set` defined like `trait Set<K:Eq>`, then the trait reference `Foo: Set<Bar>` is WF if `Bar: Eq`.",null,{"inputs":[{"name":"inferctxt"},{"name":"paramenv"},{"name":"nodeid"},{"name":"traitref"},{"name":"span"}],"output":{"generics":["predicateobligation"],"name":"vec"}}],[5,"predicate_obligations","","",null,{"inputs":[{"name":"inferctxt"},{"name":"paramenv"},{"name":"nodeid"},{"name":"predicate"},{"name":"span"}],"output":{"generics":["predicateobligation"],"name":"vec"}}],[5,"object_region_bounds","","Given an object type like `SomeTrait+Send`, computes the lifetime bounds that must hold on the elided self type. These are derived from the declarations of `SomeTrait`, `Send`, and friends -- if they declare `trait SomeTrait : 'static`, for example, then `'static` would appear in the list. The hard work is done by `ty::required_region_bounds`, see that for more information.",null,{"inputs":[{"name":"tyctxt"},{"generics":["slice"],"name":"binder"}],"output":{"generics":["region"],"name":"vec"}}],[0,"util","rustc::ty","misc. type-system utilities too small to deserve their own file",null,null],[3,"Discr","rustc::ty::util","",null,null],[12,"val","","bit representation of the discriminant, so `-128i8` is `0xFF_u128`",762,null],[12,"ty","","",762,null],[3,"TypeIdHasher","","",null,null],[4,"CopyImplementationError","","",null,null],[13,"InfrigingField","","",763,null],[13,"NotAnAdt","","",763,null],[13,"HasDestructor","","",763,null],[4,"Representability","","Describes whether a type is representable. For types that are not representable, 'SelfRecursive' and 'ContainsRecursive' are used to distinguish between types that are recursive with themselves and types that contain a different recursive type. These cases can therefore be treated differently when reporting errors.",null,null],[13,"Representable","","",764,null],[13,"ContainsRecursive","","",764,null],[13,"SelfRecursive","","",764,null],[4,"ExplicitSelf","","",null,null],[13,"ByValue","","",765,null],[13,"ByReference","","",765,null],[13,"ByRawPointer","","",765,null],[13,"ByBox","","",765,null],[13,"Other","","",765,null],[5,"provide","","",null,{"inputs":[{"name":"providers"}],"output":null}],[8,"IntTypeExt","","",null,null],[10,"to_ty","","",766,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"ty"}}],[10,"disr_incr","","",766,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"generics":["discr"],"name":"option"}],"output":{"generics":["discr"],"name":"option"}}],[10,"initial_discriminant","","",766,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"discr"}}],[11,"clone","","",762,{"inputs":[{"name":"self"}],"output":{"name":"discr"}}],[11,"fmt","","",762,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",762,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"wrap_incr","","Adds 1 to the value and wraps around if the maximum for the type is reached",762,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"self"}}],[11,"checked_add","","",762,null],[11,"clone","","",763,{"inputs":[{"name":"self"}],"output":{"name":"copyimplementationerror"}}],[11,"clone","","",764,{"inputs":[{"name":"self"}],"output":{"name":"representability"}}],[11,"partial_cmp","","",764,{"inputs":[{"name":"self"},{"name":"representability"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",764,{"inputs":[{"name":"self"},{"name":"representability"}],"output":{"name":"bool"}}],[11,"le","","",764,{"inputs":[{"name":"self"},{"name":"representability"}],"output":{"name":"bool"}}],[11,"gt","","",764,{"inputs":[{"name":"self"},{"name":"representability"}],"output":{"name":"bool"}}],[11,"ge","","",764,{"inputs":[{"name":"self"},{"name":"representability"}],"output":{"name":"bool"}}],[11,"cmp","","",764,{"inputs":[{"name":"self"},{"name":"representability"}],"output":{"name":"ordering"}}],[11,"eq","","",764,{"inputs":[{"name":"self"},{"name":"representability"}],"output":{"name":"bool"}}],[11,"ne","","",764,{"inputs":[{"name":"self"},{"name":"representability"}],"output":{"name":"bool"}}],[11,"fmt","","",764,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"can_type_implement_copy","rustc::ty","",522,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"ty"},{"name":"span"}],"output":{"generics":["copyimplementationerror"],"name":"result"}}],[11,"type_id_hash","","Creates a hash of the type `Ty` which will be the same no matter what crate context it's calculated within. This is used by the `type_id` intrinsic.",566,{"inputs":[{"name":"self"},{"name":"ty"}],"output":{"name":"u64"}}],[11,"has_error_field","","",566,{"inputs":[{"name":"self"},{"name":"ty"}],"output":{"name":"bool"}}],[11,"positional_element_ty","","Returns the type of element at index `i` in tuple or tuple-like type `t`. For an enum `t`, `variant` is None only if `t` is a univariant enum.",566,{"inputs":[{"name":"self"},{"name":"ty"},{"name":"usize"},{"generics":["defid"],"name":"option"}],"output":{"generics":["ty"],"name":"option"}}],[11,"named_element_ty","","Returns the type of element at field `n` in struct or struct-like type `t`. For an enum `t`, `variant` must be some def id.",566,{"inputs":[{"name":"self"},{"name":"ty"},{"name":"name"},{"generics":["defid"],"name":"option"}],"output":{"generics":["ty"],"name":"option"}}],[11,"struct_tail","","Returns the deeply last field of nested structures, or the same type, if not a structure at all. Corresponds to the only possible unsized field, and its type can be used to determine unsizing strategy.",566,{"inputs":[{"name":"self"},{"name":"ty"}],"output":{"name":"ty"}}],[11,"struct_lockstep_tails","","Same as applying struct_tail on `source` and `target`, but only keeps going as long as the two types are instances of the same structure definitions. For `(Foo<Foo<T>>, Foo<Trait>)`, the result will be `(Foo<T>, Trait)`, whereas struct_tail produces `T`, and `Trait`, respectively.",566,null],[11,"required_region_bounds","","Given a set of predicates that apply to an object type, returns the region bounds that the (erased) `Self` type must outlive. Precisely because the `Self` type is erased, the parameter `erased_self_ty` must be supplied to indicate what type has been used to represent `Self` in the predicates themselves. This should really be a unique type; `FreshTy(0)` is a popular choice.",566,{"inputs":[{"name":"self"},{"name":"ty"},{"generics":["predicate"],"name":"vec"}],"output":{"generics":["region"],"name":"vec"}}],[11,"calculate_dtor","","Calculate the destructor of a given type.",566,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"fnmut"}],"output":{"generics":["destructor"],"name":"option"}}],[11,"destructor_constraints","","Return the set of types that are required to be alive in order to run the destructor of `def` (see RFCs 769 and 1238).",566,{"inputs":[{"name":"self"},{"name":"adtdef"}],"output":{"generics":["kind"],"name":"vec"}}],[11,"is_closure","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"bool"}}],[11,"closure_base_def_id","","Given the `DefId` of a fn or closure, returns the `DefId` of the innermost fn item that the closure is contained within. This is a significant def-id because, when we do type-checking, we type-check this fn item and all of its (transitive) closures together.  Therefore, when we fetch the `typeck_tables_of` the closure, for example, we really wind up fetching the `typeck_tables_of` the enclosing fn item.",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"defid"}}],[11,"closure_env_ty","","Given the def-id and substs a closure, creates the type of `self` argument that the closure expects. For example, for a `Fn` closure, this would return a reference type `&T` where `T=closure_ty`.",566,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"closuresubsts"}],"output":{"generics":["binder"],"name":"option"}}],[11,"empty_substs_for_def_id","","Given the def-id of some item that has no type parameters, make a suitable \"empty substs\" for it.",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"substs"}}],[11,"is_static","","Return whether the node pointed to by def_id is a static item, and its mutability",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["mutability"],"name":"option"}}],[11,"new","rustc::ty::util","",767,{"inputs":[{"name":"tyctxt"}],"output":{"name":"self"}}],[11,"finish","","",767,{"inputs":[{"name":"self"}],"output":{"name":"w"}}],[11,"hash","","",767,{"inputs":[{"name":"self"},{"name":"t"}],"output":null}],[11,"visit_ty","","",767,{"inputs":[{"name":"self"},{"name":"ty"}],"output":{"name":"bool"}}],[11,"visit_region","","",767,{"inputs":[{"name":"self"},{"name":"region"}],"output":{"name":"bool"}}],[11,"visit_binder","","",767,{"inputs":[{"name":"self"},{"name":"binder"}],"output":{"name":"bool"}}],[11,"moves_by_default","rustc::ty","",508,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"paramenv"},{"name":"span"}],"output":{"name":"bool"}}],[11,"is_sized","","",508,{"inputs":[{"name":"self"},{"name":"tyctxtat"},{"name":"paramenv"}],"output":{"name":"bool"}}],[11,"is_freeze","","",508,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"paramenv"},{"name":"span"}],"output":{"name":"bool"}}],[11,"needs_drop","","If `ty.needs_drop(...)` returns `true`, then `ty` is definitely non-copy and might have a destructor attached; if it returns `false`, then `ty` definitely has no destructor (i.e. no drop glue).",508,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"paramenv"}],"output":{"name":"bool"}}],[11,"is_representable","","Check whether a type is representable. This means it cannot contain unboxed structural recursion. This check is needed for structs and enums.",508,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"span"}],"output":{"name":"representability"}}],[11,"determine","rustc::ty::util","Categorizes an explicit self declaration like `self: SomeType` into either `self`, `&self`, `&mut self`, `Box<self>`, or `Other`. This is mainly used to require the arbitrary_self_types feature in the case of `Other`, to improve error messages in the common cases, and to make `Other` non-object-safe.",765,{"inputs":[{"name":"ty"},{"name":"p"}],"output":{"name":"explicitself"}}],[11,"new","rustc::ty","",499,{"inputs":[],"output":{"name":"self"}}],[11,"new","","",768,{"inputs":[],"output":{"name":"globalarenas"}}],[11,"encode","","",500,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",500,{"inputs":[{"name":"__d"}],"output":{"generics":["typecktables"],"name":"result"}}],[11,"fmt","","",500,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"empty","","",500,{"inputs":[{"generics":["defid"],"name":"option"}],"output":{"name":"typecktables"}}],[11,"qpath_def","","Returns the final resolution of a `QPath` in an `Expr` or `Pat` node.",500,{"inputs":[{"name":"self"},{"name":"qpath"},{"name":"hirid"}],"output":{"name":"def"}}],[11,"type_dependent_defs","","",500,{"inputs":[{"name":"self"}],"output":{"generics":["def"],"name":"localtableincontext"}}],[11,"type_dependent_defs_mut","","",500,{"inputs":[{"name":"self"}],"output":{"generics":["def"],"name":"localtableincontextmut"}}],[11,"user_provided_tys","","",500,{"inputs":[{"name":"self"}],"output":{"generics":["canonicalty"],"name":"localtableincontext"}}],[11,"user_provided_tys_mut","","",500,{"inputs":[{"name":"self"}],"output":{"generics":["canonicalty"],"name":"localtableincontextmut"}}],[11,"node_types","","",500,{"inputs":[{"name":"self"}],"output":{"generics":["ty"],"name":"localtableincontext"}}],[11,"node_types_mut","","",500,{"inputs":[{"name":"self"}],"output":{"generics":["ty"],"name":"localtableincontextmut"}}],[11,"node_id_to_type","","",500,{"inputs":[{"name":"self"},{"name":"hirid"}],"output":{"name":"ty"}}],[11,"node_id_to_type_opt","","",500,{"inputs":[{"name":"self"},{"name":"hirid"}],"output":{"generics":["ty"],"name":"option"}}],[11,"node_substs_mut","","",500,{"inputs":[{"name":"self"}],"output":{"generics":["substs"],"name":"localtableincontextmut"}}],[11,"node_substs","","",500,{"inputs":[{"name":"self"},{"name":"hirid"}],"output":{"name":"substs"}}],[11,"node_substs_opt","","",500,{"inputs":[{"name":"self"},{"name":"hirid"}],"output":{"generics":["substs"],"name":"option"}}],[11,"pat_ty","","",500,{"inputs":[{"name":"self"},{"name":"pat"}],"output":{"name":"ty"}}],[11,"pat_ty_opt","","",500,{"inputs":[{"name":"self"},{"name":"pat"}],"output":{"generics":["ty"],"name":"option"}}],[11,"expr_ty","","",500,{"inputs":[{"name":"self"},{"name":"expr"}],"output":{"name":"ty"}}],[11,"expr_ty_opt","","",500,{"inputs":[{"name":"self"},{"name":"expr"}],"output":{"generics":["ty"],"name":"option"}}],[11,"adjustments","","",500,{"inputs":[{"name":"self"}],"output":{"generics":["vec"],"name":"localtableincontext"}}],[11,"adjustments_mut","","",500,{"inputs":[{"name":"self"}],"output":{"generics":["vec"],"name":"localtableincontextmut"}}],[11,"expr_adjustments","","",500,null],[11,"expr_ty_adjusted","","Returns the type of `expr`, considering any `Adjustment` entry recorded for that expression.",500,{"inputs":[{"name":"self"},{"name":"expr"}],"output":{"name":"ty"}}],[11,"expr_ty_adjusted_opt","","",500,{"inputs":[{"name":"self"},{"name":"expr"}],"output":{"generics":["ty"],"name":"option"}}],[11,"is_method_call","","",500,{"inputs":[{"name":"self"},{"name":"expr"}],"output":{"name":"bool"}}],[11,"pat_binding_modes","","",500,{"inputs":[{"name":"self"}],"output":{"generics":["bindingmode"],"name":"localtableincontext"}}],[11,"pat_binding_modes_mut","","",500,{"inputs":[{"name":"self"}],"output":{"generics":["bindingmode"],"name":"localtableincontextmut"}}],[11,"pat_adjustments","","",500,{"inputs":[{"name":"self"}],"output":{"generics":["vec"],"name":"localtableincontext"}}],[11,"pat_adjustments_mut","","",500,{"inputs":[{"name":"self"}],"output":{"generics":["vec"],"name":"localtableincontextmut"}}],[11,"upvar_capture","","",500,{"inputs":[{"name":"self"},{"name":"upvarid"}],"output":{"name":"upvarcapture"}}],[11,"closure_kind_origins","","",500,{"inputs":[{"name":"self"}],"output":{"name":"localtableincontext"}}],[11,"closure_kind_origins_mut","","",500,{"inputs":[{"name":"self"}],"output":{"name":"localtableincontextmut"}}],[11,"liberated_fn_sigs","","",500,{"inputs":[{"name":"self"}],"output":{"generics":["fnsig"],"name":"localtableincontext"}}],[11,"liberated_fn_sigs_mut","","",500,{"inputs":[{"name":"self"}],"output":{"generics":["fnsig"],"name":"localtableincontextmut"}}],[11,"fru_field_types","","",500,{"inputs":[{"name":"self"}],"output":{"generics":["vec"],"name":"localtableincontext"}}],[11,"fru_field_types_mut","","",500,{"inputs":[{"name":"self"}],"output":{"generics":["vec"],"name":"localtableincontextmut"}}],[11,"cast_kinds","","",500,{"inputs":[{"name":"self"}],"output":{"generics":["castkind"],"name":"localtableincontext"}}],[11,"cast_kinds_mut","","",500,{"inputs":[{"name":"self"}],"output":{"generics":["castkind"],"name":"localtableincontextmut"}}],[11,"hash_stable","","",500,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"clone","","",566,{"inputs":[{"name":"self"}],"output":{"name":"tyctxt"}}],[11,"deref","","",566,null],[11,"fmt","","",769,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"default","","",769,{"inputs":[],"output":{"name":"interpretinterner"}}],[11,"create_fn_alloc","","",769,{"inputs":[{"name":"self"},{"name":"instance"}],"output":{"name":"allocid"}}],[11,"get_fn","","",769,{"inputs":[{"name":"self"},{"name":"allocid"}],"output":{"generics":["instance"],"name":"option"}}],[11,"get_alloc","","",769,{"inputs":[{"name":"self"},{"name":"allocid"}],"output":{"generics":["allocation"],"name":"option"}}],[11,"cache_static","","",769,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"allocid"}}],[11,"get_static","","",769,{"inputs":[{"name":"self"},{"name":"allocid"}],"output":{"generics":["defid"],"name":"option"}}],[11,"intern_at_reserved","","",769,{"inputs":[{"name":"self"},{"name":"allocid"},{"name":"allocation"}],"output":null}],[11,"reserve","","obtains a new allocation ID that can be referenced but does not yet have an allocation backing it.",769,{"inputs":[{"name":"self"}],"output":{"name":"allocid"}}],[11,"global_tcx","","Get the global TyCtxt.",566,{"inputs":[{"name":"self"}],"output":{"name":"tyctxt"}}],[11,"alloc_generics","","",566,{"inputs":[{"name":"self"},{"name":"generics"}],"output":{"name":"generics"}}],[11,"alloc_steal_mir","","",566,{"inputs":[{"name":"self"},{"name":"mir"}],"output":{"name":"steal"}}],[11,"alloc_mir","","",566,{"inputs":[{"name":"self"},{"name":"mir"}],"output":{"name":"mir"}}],[11,"alloc_tables","","",566,{"inputs":[{"name":"self"},{"name":"typecktables"}],"output":{"name":"typecktables"}}],[11,"alloc_trait_def","","",566,{"inputs":[{"name":"self"},{"name":"traitdef"}],"output":{"name":"traitdef"}}],[11,"alloc_adt_def","","",566,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"adtkind"},{"generics":["variantdef"],"name":"vec"},{"name":"reproptions"}],"output":{"name":"adtdef"}}],[11,"alloc_byte_array","","",566,null],[11,"alloc_const_slice","","",566,null],[11,"alloc_name_const_slice","","",566,null],[11,"intern_const_alloc","","",566,{"inputs":[{"name":"self"},{"name":"allocation"}],"output":{"name":"allocation"}}],[11,"allocate_cached","","Allocates a byte or string literal for `mir::interpret`",566,null],[11,"intern_stability","","",566,{"inputs":[{"name":"self"},{"name":"stability"}],"output":{"name":"stability"}}],[11,"intern_layout","","",566,{"inputs":[{"name":"self"},{"name":"layoutdetails"}],"output":{"name":"layoutdetails"}}],[11,"lift","","",566,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"option"}}],[11,"lift_to_global","","Like lift, but only tries in the global tcx.",566,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"option"}}],[11,"create_and_enter","","Create a type context and call the closure with a `TyCtxt` reference to the context. The closure enforces that the type context and any interned value (types, substs, etc.) can only be used while `ty::tls` has a valid reference to the context, to allow formatting values that need it.",566,{"inputs":[{"name":"session"},{"name":"cratestore"},{"name":"providers"},{"name":"providers"},{"name":"allarenas"},{"name":"resolutions"},{"name":"map"},{"name":"ondiskcache"},{"name":"str"},{"generics":["box"],"name":"sender"},{"name":"outputfilenames"},{"name":"f"}],"output":{"name":"r"}}],[11,"consider_optimizing","","",566,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"bool"}}],[11,"lang_items","","",566,{"inputs":[{"name":"self"}],"output":{"generics":["languageitems"],"name":"lrc"}}],[11,"is_binop_lang_item","","Due to missing llvm support for lowering 128 bit math to software emulation (on some targets), the lowering can be done in MIR.",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"option"}}],[11,"stability","","",566,{"inputs":[{"name":"self"}],"output":{"generics":["index"],"name":"lrc"}}],[11,"crates","","",566,{"inputs":[{"name":"self"}],"output":{"generics":["vec"],"name":"lrc"}}],[11,"features","","",566,{"inputs":[{"name":"self"}],"output":{"generics":["features"],"name":"lrc"}}],[11,"def_key","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"defkey"}}],[11,"def_path","","Convert a `DefId` into its fully expanded `DefPath` (every `DefId` is really just an interned def-path).",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"defpath"}}],[11,"def_path_hash","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"defpathhash"}}],[11,"def_path_debug_str","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"string"}}],[11,"metadata_encoding_version","","",566,{"inputs":[{"name":"self"}],"output":{"generics":["u8"],"name":"vec"}}],[11,"crate_data_as_rc_any","","",566,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["any"],"name":"lrc"}}],[11,"create_stable_hashing_context","","",566,{"inputs":[{"name":"self"}],"output":{"name":"stablehashingcontext"}}],[11,"allocate_metadata_dep_nodes","","",566,{"inputs":[{"name":"self"}],"output":null}],[11,"precompute_in_scope_traits_hashes","","",566,{"inputs":[{"name":"self"}],"output":null}],[11,"serialize_query_result_cache","","",566,{"inputs":[{"name":"self"},{"name":"e"}],"output":{"name":"result"}}],[11,"nll","","If true, we should use NLL-style region checking instead of lexical style.",566,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"use_mir","","If true, we should use the MIR-based borrowck (we may also use the AST-based borrowck).",566,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"two_phase_borrows","","If true, we should enable two-phase borrows checks. This is done with either `-Ztwo-phase-borrows` or with `#![feature(nll)]`.",566,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"borrowck_mode","","What mode(s) of borrowck should we run? AST? MIR? both? (Also considers the `#![feature(nll)]` setting.)",566,{"inputs":[{"name":"self"}],"output":{"name":"borrowckmode"}}],[11,"emit_end_regions","","Should we emit EndRegion MIR statements? These are consumed by MIR borrowck, but not when NLL is used. They are also consumed by the validation stuff.",566,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"encode_metadata","","",566,{"inputs":[{"name":"self"},{"name":"linkmeta"}],"output":{"name":"encodedmetadata"}}],[11,"print_debug_stats","","",566,{"inputs":[{"name":"self"}],"output":null}],[11,"mk_region","","",566,{"inputs":[{"name":"self"},{"name":"regionkind"}],"output":{"name":"regionkind"}}],[11,"mk_const","","",566,{"inputs":[{"name":"self"},{"name":"const"}],"output":{"name":"const"}}],[11,"_intern_existential_predicates","","",566,null],[11,"_intern_predicates","","",566,null],[11,"_intern_type_list","","",566,null],[11,"_intern_substs","","",566,null],[11,"_intern_canonical_var_infos","","",566,null],[11,"safe_to_unsafe_fn_ty","","Given a `fn` type, returns an equivalent `unsafe fn` type; that is, a `fn` type that is equivalent in every way for being unsafe.",566,{"inputs":[{"name":"self"},{"name":"polyfnsig"}],"output":{"name":"ty"}}],[11,"coerce_closure_fn_ty","","Given a closure signature `sig`, returns an equivalent `fn` type with the same signature. Detuples and so forth -- so e.g. if we have a sig with `Fn<(u32, i32)>` then you would get a `fn(u32, i32)`.",566,{"inputs":[{"name":"self"},{"name":"polyfnsig"}],"output":{"name":"ty"}}],[11,"mk_ty","","",566,{"inputs":[{"name":"self"},{"name":"typevariants"}],"output":{"name":"ty"}}],[11,"mk_mach_int","","",566,{"inputs":[{"name":"self"},{"name":"intty"}],"output":{"name":"ty"}}],[11,"mk_mach_uint","","",566,{"inputs":[{"name":"self"},{"name":"uintty"}],"output":{"name":"ty"}}],[11,"mk_mach_float","","",566,{"inputs":[{"name":"self"},{"name":"floatty"}],"output":{"name":"ty"}}],[11,"mk_str","","",566,{"inputs":[{"name":"self"}],"output":{"name":"ty"}}],[11,"mk_static_str","","",566,{"inputs":[{"name":"self"}],"output":{"name":"ty"}}],[11,"mk_adt","","",566,{"inputs":[{"name":"self"},{"name":"adtdef"},{"name":"substs"}],"output":{"name":"ty"}}],[11,"mk_foreign","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"ty"}}],[11,"mk_box","","",566,{"inputs":[{"name":"self"},{"name":"ty"}],"output":{"name":"ty"}}],[11,"mk_ptr","","",566,{"inputs":[{"name":"self"},{"name":"typeandmut"}],"output":{"name":"ty"}}],[11,"mk_ref","","",566,{"inputs":[{"name":"self"},{"name":"region"},{"name":"typeandmut"}],"output":{"name":"ty"}}],[11,"mk_mut_ref","","",566,{"inputs":[{"name":"self"},{"name":"region"},{"name":"ty"}],"output":{"name":"ty"}}],[11,"mk_imm_ref","","",566,{"inputs":[{"name":"self"},{"name":"region"},{"name":"ty"}],"output":{"name":"ty"}}],[11,"mk_mut_ptr","","",566,{"inputs":[{"name":"self"},{"name":"ty"}],"output":{"name":"ty"}}],[11,"mk_imm_ptr","","",566,{"inputs":[{"name":"self"},{"name":"ty"}],"output":{"name":"ty"}}],[11,"mk_nil_ptr","","",566,{"inputs":[{"name":"self"}],"output":{"name":"ty"}}],[11,"mk_array","","",566,{"inputs":[{"name":"self"},{"name":"ty"},{"name":"u64"}],"output":{"name":"ty"}}],[11,"mk_slice","","",566,{"inputs":[{"name":"self"},{"name":"ty"}],"output":{"name":"ty"}}],[11,"intern_tup","","",566,null],[11,"mk_tup","","",566,null],[11,"mk_nil","","",566,{"inputs":[{"name":"self"}],"output":{"name":"ty"}}],[11,"mk_diverging_default","","",566,{"inputs":[{"name":"self"}],"output":{"name":"ty"}}],[11,"mk_bool","","",566,{"inputs":[{"name":"self"}],"output":{"name":"ty"}}],[11,"mk_fn_def","","",566,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"substs"}],"output":{"name":"ty"}}],[11,"mk_fn_ptr","","",566,{"inputs":[{"name":"self"},{"name":"polyfnsig"}],"output":{"name":"ty"}}],[11,"mk_dynamic","","",566,{"inputs":[{"name":"self"},{"generics":["slice"],"name":"binder"},{"name":"region"}],"output":{"name":"ty"}}],[11,"mk_projection","","",566,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"substs"}],"output":{"name":"ty"}}],[11,"mk_closure","","",566,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"closuresubsts"}],"output":{"name":"ty"}}],[11,"mk_closure_from_closure_substs","","",566,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"closuresubsts"}],"output":{"name":"ty"}}],[11,"mk_generator","","",566,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"closuresubsts"},{"name":"generatorinterior"}],"output":{"name":"ty"}}],[11,"mk_generator_witness","","",566,{"inputs":[{"name":"self"},{"generics":["slice"],"name":"binder"}],"output":{"name":"ty"}}],[11,"mk_var","","",566,{"inputs":[{"name":"self"},{"name":"tyvid"}],"output":{"name":"ty"}}],[11,"mk_int_var","","",566,{"inputs":[{"name":"self"},{"name":"intvid"}],"output":{"name":"ty"}}],[11,"mk_float_var","","",566,{"inputs":[{"name":"self"},{"name":"floatvid"}],"output":{"name":"ty"}}],[11,"mk_infer","","",566,{"inputs":[{"name":"self"},{"name":"inferty"}],"output":{"name":"ty"}}],[11,"mk_param","","",566,{"inputs":[{"name":"self"},{"name":"u32"},{"name":"internedstring"}],"output":{"name":"ty"}}],[11,"mk_self_type","","",566,{"inputs":[{"name":"self"}],"output":{"name":"ty"}}],[11,"mk_param_from_def","","",566,{"inputs":[{"name":"self"},{"name":"typeparameterdef"}],"output":{"name":"ty"}}],[11,"mk_anon","","",566,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"substs"}],"output":{"name":"ty"}}],[11,"intern_existential_predicates","","",566,null],[11,"intern_predicates","","",566,null],[11,"intern_type_list","","",566,null],[11,"intern_substs","","",566,null],[11,"intern_canonical_var_infos","","",566,null],[11,"mk_fn_sig","","",566,null],[11,"mk_existential_predicates","","",566,null],[11,"mk_predicates","","",566,null],[11,"mk_type_list","","",566,null],[11,"mk_substs","","",566,null],[11,"mk_substs_trait","","",566,null],[11,"lint_node","","",566,{"inputs":[{"name":"self"},{"name":"lint"},{"name":"nodeid"},{"name":"s"},{"name":"str"}],"output":null}],[11,"lint_node_note","","",566,{"inputs":[{"name":"self"},{"name":"lint"},{"name":"nodeid"},{"name":"s"},{"name":"str"},{"name":"str"}],"output":null}],[11,"lint_level_at_node","","",566,null],[11,"struct_span_lint_node","","",566,{"inputs":[{"name":"self"},{"name":"lint"},{"name":"nodeid"},{"name":"s"},{"name":"str"}],"output":{"name":"diagnosticbuilder"}}],[11,"struct_lint_node","","",566,{"inputs":[{"name":"self"},{"name":"lint"},{"name":"nodeid"},{"name":"str"}],"output":{"name":"diagnosticbuilder"}}],[11,"in_scope_traits","","",566,{"inputs":[{"name":"self"},{"name":"hirid"}],"output":{"generics":["lrc"],"name":"option"}}],[11,"named_region","","",566,{"inputs":[{"name":"self"},{"name":"hirid"}],"output":{"generics":["region"],"name":"option"}}],[11,"is_late_bound","","",566,{"inputs":[{"name":"self"},{"name":"hirid"}],"output":{"name":"bool"}}],[11,"object_lifetime_defaults","","",566,{"inputs":[{"name":"self"},{"name":"hirid"}],"output":{"generics":["lrc"],"name":"option"}}],[11,"clone","","",501,{"inputs":[{"name":"self"}],"output":{"name":"instance"}}],[11,"eq","","",501,{"inputs":[{"name":"self"},{"name":"instance"}],"output":{"name":"bool"}}],[11,"ne","","",501,{"inputs":[{"name":"self"},{"name":"instance"}],"output":{"name":"bool"}}],[11,"hash","","",501,null],[11,"fmt","","",501,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",501,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",501,{"inputs":[{"name":"__d"}],"output":{"generics":["instance"],"name":"result"}}],[11,"clone","","",536,{"inputs":[{"name":"self"}],"output":{"name":"instancedef"}}],[11,"eq","","",536,{"inputs":[{"name":"self"},{"name":"instancedef"}],"output":{"name":"bool"}}],[11,"ne","","",536,{"inputs":[{"name":"self"},{"name":"instancedef"}],"output":{"name":"bool"}}],[11,"hash","","",536,null],[11,"fmt","","",536,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",536,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",536,{"inputs":[{"name":"__d"}],"output":{"generics":["instancedef"],"name":"result"}}],[11,"ty","","",501,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"ty"}}],[11,"def_id","","",536,{"inputs":[{"name":"self"}],"output":{"name":"defid"}}],[11,"attrs","","",536,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"attributes"}}],[11,"is_inline","","",536,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"bool"}}],[11,"requires_local","","",536,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"bool"}}],[11,"fmt","","",501,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","",501,{"inputs":[{"name":"defid"},{"name":"substs"}],"output":{"name":"instance"}}],[11,"mono","","",501,{"inputs":[{"name":"tyctxt"},{"name":"defid"}],"output":{"name":"instance"}}],[11,"def_id","","",501,{"inputs":[{"name":"self"}],"output":{"name":"defid"}}],[11,"resolve","","Resolve a (def_id, substs) pair to an (optional) instance -- most commonly, this is used to find the precise code that will run for a trait method invocation, if known.",501,{"inputs":[{"name":"tyctxt"},{"name":"paramenv"},{"name":"defid"},{"name":"substs"}],"output":{"generics":["instance"],"name":"option"}}],[11,"resolve_closure","","",501,{"inputs":[{"name":"tyctxt"},{"name":"defid"},{"name":"closuresubsts"},{"name":"closurekind"}],"output":{"name":"instance"}}],[11,"super_fold_with","rustc::middle::region","",301,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"scope"}}],[11,"super_visit_with","","",301,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"super_fold_with","rustc::hir::def","",125,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"def"}}],[11,"super_visit_with","","",125,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"super_fold_with","rustc::hir::def_id","",127,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"defid"}}],[11,"super_visit_with","","",127,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"super_fold_with","rustc::hir","",59,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"inlineasm"}}],[11,"super_visit_with","","",59,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",99,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"matchsource"}}],[11,"super_visit_with","","",99,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",88,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"mutability"}}],[11,"super_visit_with","","",88,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",112,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"unsafety"}}],[11,"super_visit_with","","",112,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"super_fold_with","rustc::mir","",384,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"local"}}],[11,"super_visit_with","","",384,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",388,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"promoted"}}],[11,"super_visit_with","","",388,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"super_fold_with","rustc::traits","",445,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"reveal"}}],[11,"super_visit_with","","",445,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"super_fold_with","rustc::ty::adjustment","",553,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"autoborrowmutability"}}],[11,"super_visit_with","","",553,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"super_fold_with","rustc::ty","",546,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"adtkind"}}],[11,"super_visit_with","","",546,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",534,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"boundregion"}}],[11,"super_visit_with","","",534,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",547,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"closurekind"}}],[11,"super_visit_with","","",547,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",543,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"intvarvalue"}}],[11,"super_visit_with","","",543,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"lift_to_tcx","rustc::middle::region","",301,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","rustc::hir::def","",125,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","rustc::hir::def_id","",127,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","rustc::hir","",59,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","","",99,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","","",88,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","","",112,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","rustc::mir","",384,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","","",388,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","rustc::traits","",445,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","rustc::ty::adjustment","",553,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","rustc::ty","",546,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","","",534,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","","",547,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","","",543,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","","",488,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","","",489,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","","",517,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"generics":["traitpredicate"],"name":"option"}}],[11,"lift_to_tcx","","",519,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"generics":["subtypepredicate"],"name":"option"}}],[11,"lift_to_tcx","","",518,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","","",484,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"generics":["projectionty"],"name":"option"}}],[11,"lift_to_tcx","","",520,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"generics":["projectionpredicate"],"name":"option"}}],[11,"lift_to_tcx","","",490,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","","",544,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","","",479,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","","",522,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","","",523,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","","",485,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","","",486,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","rustc::ty::adjustment","",549,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","","",552,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","","",550,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","","",554,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","rustc::ty","",482,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","","",481,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","rustc::ty::error","",563,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","","",564,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","rustc::middle::const_val","",248,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","rustc::mir::interpret","",363,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","rustc::middle::const_val","",251,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","rustc::ty::layout","",587,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","rustc::ty","",536,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","","",501,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"generics":["instance"],"name":"option"}}],[11,"lift_to_tcx","rustc::mir::interpret","",366,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"generics":["globalid"],"name":"option"}}],[11,"super_fold_with","rustc::ty","",479,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"self"}}],[11,"fold_with","","",479,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"self"}}],[11,"super_visit_with","","",479,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"visit_with","","",479,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",522,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",522,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",532,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",532,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",501,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"self"}}],[11,"super_visit_with","","",501,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","rustc::mir::interpret","",366,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"self"}}],[11,"super_visit_with","","",366,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","rustc::ty","",487,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",487,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",482,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",482,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",481,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",481,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",488,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",488,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",489,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",489,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",504,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",504,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",485,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",485,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",486,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",486,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","rustc::ty::adjustment","",549,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",549,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",552,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",552,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",550,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",550,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",554,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",554,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","rustc::ty","",516,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",516,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",544,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",544,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",520,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",520,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",490,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",490,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",484,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",484,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",521,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",521,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",523,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",523,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",519,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",519,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",517,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",517,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",518,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",518,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",511,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",511,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","rustc::ty::error","",563,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",563,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",564,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",564,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","rustc::middle::const_val","",250,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"self"}}],[11,"super_visit_with","","",250,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"clone","rustc::ty","",487,{"inputs":[{"name":"self"}],"output":{"name":"typeandmut"}}],[11,"eq","","",487,{"inputs":[{"name":"self"},{"name":"typeandmut"}],"output":{"name":"bool"}}],[11,"ne","","",487,{"inputs":[{"name":"self"},{"name":"typeandmut"}],"output":{"name":"bool"}}],[11,"hash","","",487,null],[11,"fmt","","",487,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",487,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",487,{"inputs":[{"name":"__d"}],"output":{"generics":["typeandmut"],"name":"result"}}],[11,"clone","","",493,{"inputs":[{"name":"self"}],"output":{"name":"freeregion"}}],[11,"eq","","",493,{"inputs":[{"name":"self"},{"name":"freeregion"}],"output":{"name":"bool"}}],[11,"ne","","",493,{"inputs":[{"name":"self"},{"name":"freeregion"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",493,{"inputs":[{"name":"self"},{"name":"freeregion"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",493,{"inputs":[{"name":"self"},{"name":"freeregion"}],"output":{"name":"bool"}}],[11,"le","","",493,{"inputs":[{"name":"self"},{"name":"freeregion"}],"output":{"name":"bool"}}],[11,"gt","","",493,{"inputs":[{"name":"self"},{"name":"freeregion"}],"output":{"name":"bool"}}],[11,"ge","","",493,{"inputs":[{"name":"self"},{"name":"freeregion"}],"output":{"name":"bool"}}],[11,"cmp","","",493,{"inputs":[{"name":"self"},{"name":"freeregion"}],"output":{"name":"ordering"}}],[11,"hash","","",493,null],[11,"encode","","",493,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",493,{"inputs":[{"name":"__d"}],"output":{"generics":["freeregion"],"name":"result"}}],[11,"clone","","",534,{"inputs":[{"name":"self"}],"output":{"name":"boundregion"}}],[11,"eq","","",534,{"inputs":[{"name":"self"},{"name":"boundregion"}],"output":{"name":"bool"}}],[11,"ne","","",534,{"inputs":[{"name":"self"},{"name":"boundregion"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",534,{"inputs":[{"name":"self"},{"name":"boundregion"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",534,{"inputs":[{"name":"self"},{"name":"boundregion"}],"output":{"name":"bool"}}],[11,"le","","",534,{"inputs":[{"name":"self"},{"name":"boundregion"}],"output":{"name":"bool"}}],[11,"gt","","",534,{"inputs":[{"name":"self"},{"name":"boundregion"}],"output":{"name":"bool"}}],[11,"ge","","",534,{"inputs":[{"name":"self"},{"name":"boundregion"}],"output":{"name":"bool"}}],[11,"cmp","","",534,{"inputs":[{"name":"self"},{"name":"boundregion"}],"output":{"name":"ordering"}}],[11,"hash","","",534,null],[11,"encode","","",534,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",534,{"inputs":[{"name":"__d"}],"output":{"generics":["boundregion"],"name":"result"}}],[11,"is_named","","",534,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",533,{"inputs":[{"name":"self"}],"output":{"name":"typevariants"}}],[11,"eq","","",533,{"inputs":[{"name":"self"},{"name":"typevariants"}],"output":{"name":"bool"}}],[11,"ne","","",533,{"inputs":[{"name":"self"},{"name":"typevariants"}],"output":{"name":"bool"}}],[11,"hash","","",533,null],[11,"fmt","","",533,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",533,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",533,{"inputs":[{"name":"__d"}],"output":{"generics":["typevariants"],"name":"result"}}],[11,"clone","","",485,{"inputs":[{"name":"self"}],"output":{"name":"closuresubsts"}}],[11,"eq","","",485,{"inputs":[{"name":"self"},{"name":"closuresubsts"}],"output":{"name":"bool"}}],[11,"ne","","",485,{"inputs":[{"name":"self"},{"name":"closuresubsts"}],"output":{"name":"bool"}}],[11,"hash","","",485,null],[11,"fmt","","",485,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",485,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",485,{"inputs":[{"name":"__d"}],"output":{"generics":["closuresubsts"],"name":"result"}}],[11,"upvar_tys","","",485,null],[11,"closure_kind_ty","","Returns the closure kind for this closure; may return a type variable during inference. To get the closure kind during inference, use `infcx.closure_kind(def_id, substs)`.",485,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"tyctxt"}],"output":{"name":"ty"}}],[11,"closure_sig_ty","","Returns the type representing the closure signature for this closure; may contain type variables during inference. To get the closure signature during inference, use `infcx.fn_sig(def_id)`.",485,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"tyctxt"}],"output":{"name":"ty"}}],[11,"generator_yield_ty","","Returns the type representing the yield type of the generator.",485,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"tyctxt"}],"output":{"name":"ty"}}],[11,"generator_return_ty","","Returns the type representing the return type of the generator.",485,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"tyctxt"}],"output":{"name":"ty"}}],[11,"generator_poly_sig","","Return the \"generator signature\", which consists of its yield and return types.",485,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"tyctxt"}],"output":{"name":"polygensig"}}],[11,"generator_sig","","Return the \"generator signature\", which consists of its yield and return types.",485,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"tyctxt"}],"output":{"name":"gensig"}}],[11,"closure_kind","","Returns the closure kind for this closure; only usable outside of an inference context, because in that context we know that there are no type variables.",485,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"tyctxt"}],"output":{"name":"closurekind"}}],[11,"closure_sig","","Extracts the signature from the closure; only usable outside of an inference context, because in that context we know that there are no type variables.",485,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"tyctxt"}],"output":{"name":"polyfnsig"}}],[11,"state_tys","","This returns the types of the MIR locals which had to be stored across suspension points. It is calculated in rustc_mir::transform::generator::StateTransform. All the types here must be in the tuple in GeneratorInterior.",485,null],[11,"pre_transforms_tys","","This is the types of the fields of a generate which is available before the generator transformation. It includes the upvars and the state discriminant which is u32.",485,null],[11,"field_tys","","This is the types of all the fields stored in a generator. It includes the upvars, state types and the state discriminant which is u32.",485,null],[11,"clone","","",486,{"inputs":[{"name":"self"}],"output":{"name":"generatorinterior"}}],[11,"eq","","",486,{"inputs":[{"name":"self"},{"name":"generatorinterior"}],"output":{"name":"bool"}}],[11,"ne","","",486,{"inputs":[{"name":"self"},{"name":"generatorinterior"}],"output":{"name":"bool"}}],[11,"hash","","",486,null],[11,"fmt","","",486,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",486,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",486,{"inputs":[{"name":"__d"}],"output":{"generics":["generatorinterior"],"name":"result"}}],[11,"fmt","","",532,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",532,{"inputs":[{"name":"self"}],"output":{"name":"existentialpredicate"}}],[11,"eq","","",532,{"inputs":[{"name":"self"},{"name":"existentialpredicate"}],"output":{"name":"bool"}}],[11,"ne","","",532,{"inputs":[{"name":"self"},{"name":"existentialpredicate"}],"output":{"name":"bool"}}],[11,"hash","","",532,null],[11,"encode","","",532,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",532,{"inputs":[{"name":"__d"}],"output":{"generics":["existentialpredicate"],"name":"result"}}],[11,"cmp","","",532,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"self"}],"output":{"name":"ordering"}}],[11,"with_self_ty","","",479,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"ty"}],"output":{"name":"predicate"}}],[11,"principal","","",770,{"inputs":[{"name":"self"}],"output":{"generics":["existentialtraitref"],"name":"option"}}],[11,"projection_bounds","","",770,null],[11,"auto_traits","","",770,null],[11,"principal","","",479,{"inputs":[{"name":"self"}],"output":{"generics":["polyexistentialtraitref"],"name":"option"}}],[11,"projection_bounds","","",479,null],[11,"auto_traits","","",479,null],[11,"iter","","",479,null],[11,"clone","","",488,{"inputs":[{"name":"self"}],"output":{"name":"traitref"}}],[11,"eq","","",488,{"inputs":[{"name":"self"},{"name":"traitref"}],"output":{"name":"bool"}}],[11,"ne","","",488,{"inputs":[{"name":"self"},{"name":"traitref"}],"output":{"name":"bool"}}],[11,"hash","","",488,null],[11,"encode","","",488,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",488,{"inputs":[{"name":"__d"}],"output":{"generics":["traitref"],"name":"result"}}],[11,"new","","",488,{"inputs":[{"name":"defid"},{"name":"substs"}],"output":{"name":"traitref"}}],[11,"self_ty","","",488,{"inputs":[{"name":"self"}],"output":{"name":"ty"}}],[11,"input_types","","",488,null],[11,"clone","","",489,{"inputs":[{"name":"self"}],"output":{"name":"existentialtraitref"}}],[11,"eq","","",489,{"inputs":[{"name":"self"},{"name":"existentialtraitref"}],"output":{"name":"bool"}}],[11,"ne","","",489,{"inputs":[{"name":"self"},{"name":"existentialtraitref"}],"output":{"name":"bool"}}],[11,"hash","","",489,null],[11,"encode","","",489,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",489,{"inputs":[{"name":"__d"}],"output":{"generics":["existentialtraitref"],"name":"result"}}],[11,"input_types","","",489,null],[11,"with_self_ty","","Object types don't have a self-type specified. Therefore, when we convert the principal trait-ref into a normal trait-ref, you must give some self-type. A common choice is `mk_err()` or some skolemized type.",489,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"ty"}],"output":{"name":"traitref"}}],[11,"clone","","",479,{"inputs":[{"name":"self"}],"output":{"name":"binder"}}],[11,"eq","","",479,{"inputs":[{"name":"self"},{"name":"binder"}],"output":{"name":"bool"}}],[11,"ne","","",479,{"inputs":[{"name":"self"},{"name":"binder"}],"output":{"name":"bool"}}],[11,"hash","","",479,null],[11,"fmt","","",479,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",479,{"inputs":[{"name":"self"},{"name":"__st"}],"output":{"name":"result"}}],[11,"decode","","",479,{"inputs":[{"name":"__dt"}],"output":{"generics":["binder"],"name":"result"}}],[11,"dummy","","Wraps `value` in a binder, asserting that `value` does not contain any bound regions that would be bound by the binder. This is commonly used to 'inject' a value T into a different binding level.",479,{"inputs":[{"name":"t"}],"output":{"name":"binder"}}],[11,"skip_binder","","Skips the binder and returns the \"bound\" value. This is a risky thing to do because it's easy to get confused about debruijn indices and the like. It is usually better to discharge the binder using `no_late_bound_regions` or `replace_late_bound_regions` or something like that. `skip_binder` is only valid when you are either extracting data that has nothing to do with bound regions, you are doing some sort of test that does not involve bound regions, or you are being very careful about your depth accounting.",479,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"as_ref","","",479,{"inputs":[{"name":"self"}],"output":{"name":"binder"}}],[11,"map_bound_ref","","",479,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"binder"}}],[11,"map_bound","","",479,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"binder"}}],[11,"no_late_bound_regions","","Unwraps and returns the value within, but only if it contains no bound regions at all. (In other words, if this binder -- and indeed any enclosing binder -- doesn't bind anything at all.) Otherwise, returns `None`.",479,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fuse","","Given two things that have the same binder level, and an operation that wraps on their contents, execute the operation and then wrap its result.",479,{"inputs":[{"name":"self"},{"name":"binder"},{"name":"f"}],"output":{"name":"binder"}}],[11,"split","","Split the contents into two things that share the same binder level as the original, returning two distinct binders.",479,null],[11,"clone","","",484,{"inputs":[{"name":"self"}],"output":{"name":"projectionty"}}],[11,"eq","","",484,{"inputs":[{"name":"self"},{"name":"projectionty"}],"output":{"name":"bool"}}],[11,"ne","","",484,{"inputs":[{"name":"self"},{"name":"projectionty"}],"output":{"name":"bool"}}],[11,"hash","","",484,null],[11,"fmt","","",484,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",484,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",484,{"inputs":[{"name":"__d"}],"output":{"generics":["projectionty"],"name":"result"}}],[11,"from_ref_and_name","","Construct a ProjectionTy by searching the trait from trait_ref for the associated item named item_name.",484,{"inputs":[{"name":"tyctxt"},{"name":"traitref"},{"name":"name"}],"output":{"name":"projectionty"}}],[11,"trait_ref","","Extracts the underlying trait reference from this projection. For example, if this is a projection of `<T as Iterator>::Item`, then this function would return a `T: Iterator` trait reference.",484,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"traitref"}}],[11,"self_ty","","",484,{"inputs":[{"name":"self"}],"output":{"name":"ty"}}],[11,"clone","","",482,{"inputs":[{"name":"self"}],"output":{"name":"gensig"}}],[11,"fmt","","",482,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",482,{"inputs":[{"name":"self"},{"name":"gensig"}],"output":{"name":"bool"}}],[11,"ne","","",482,{"inputs":[{"name":"self"},{"name":"gensig"}],"output":{"name":"bool"}}],[11,"hash","","",482,null],[11,"encode","","",482,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",482,{"inputs":[{"name":"__d"}],"output":{"generics":["gensig"],"name":"result"}}],[11,"clone","","",481,{"inputs":[{"name":"self"}],"output":{"name":"fnsig"}}],[11,"eq","","",481,{"inputs":[{"name":"self"},{"name":"fnsig"}],"output":{"name":"bool"}}],[11,"ne","","",481,{"inputs":[{"name":"self"},{"name":"fnsig"}],"output":{"name":"bool"}}],[11,"hash","","",481,null],[11,"encode","","",481,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",481,{"inputs":[{"name":"__d"}],"output":{"generics":["fnsig"],"name":"result"}}],[11,"inputs","","",481,null],[11,"output","","",481,{"inputs":[{"name":"self"}],"output":{"name":"ty"}}],[11,"clone","","",483,{"inputs":[{"name":"self"}],"output":{"name":"paramty"}}],[11,"eq","","",483,{"inputs":[{"name":"self"},{"name":"paramty"}],"output":{"name":"bool"}}],[11,"ne","","",483,{"inputs":[{"name":"self"},{"name":"paramty"}],"output":{"name":"bool"}}],[11,"hash","","",483,null],[11,"encode","","",483,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",483,{"inputs":[{"name":"__d"}],"output":{"generics":["paramty"],"name":"result"}}],[11,"new","","",483,{"inputs":[{"name":"u32"},{"name":"internedstring"}],"output":{"name":"paramty"}}],[11,"for_self","","",483,{"inputs":[],"output":{"name":"paramty"}}],[11,"for_def","","",483,{"inputs":[{"name":"typeparameterdef"}],"output":{"name":"paramty"}}],[11,"to_ty","","",483,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"ty"}}],[11,"is_self","","",483,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",480,{"inputs":[{"name":"self"}],"output":{"name":"debruijnindex"}}],[11,"eq","","",480,{"inputs":[{"name":"self"},{"name":"debruijnindex"}],"output":{"name":"bool"}}],[11,"ne","","",480,{"inputs":[{"name":"self"},{"name":"debruijnindex"}],"output":{"name":"bool"}}],[11,"hash","","",480,null],[11,"encode","","",480,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",480,{"inputs":[{"name":"__d"}],"output":{"generics":["debruijnindex"],"name":"result"}}],[11,"fmt","","",480,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"partial_cmp","","",480,{"inputs":[{"name":"self"},{"name":"debruijnindex"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",480,{"inputs":[{"name":"self"},{"name":"debruijnindex"}],"output":{"name":"bool"}}],[11,"le","","",480,{"inputs":[{"name":"self"},{"name":"debruijnindex"}],"output":{"name":"bool"}}],[11,"gt","","",480,{"inputs":[{"name":"self"},{"name":"debruijnindex"}],"output":{"name":"bool"}}],[11,"ge","","",480,{"inputs":[{"name":"self"},{"name":"debruijnindex"}],"output":{"name":"bool"}}],[11,"cmp","","",480,{"inputs":[{"name":"self"},{"name":"debruijnindex"}],"output":{"name":"ordering"}}],[11,"clone","","",535,{"inputs":[{"name":"self"}],"output":{"name":"regionkind"}}],[11,"eq","","",535,{"inputs":[{"name":"self"},{"name":"regionkind"}],"output":{"name":"bool"}}],[11,"ne","","",535,{"inputs":[{"name":"self"},{"name":"regionkind"}],"output":{"name":"bool"}}],[11,"hash","","",535,null],[11,"encode","","",535,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",535,{"inputs":[{"name":"__d"}],"output":{"generics":["regionkind"],"name":"result"}}],[11,"partial_cmp","","",535,{"inputs":[{"name":"self"},{"name":"regionkind"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",535,{"inputs":[{"name":"self"},{"name":"regionkind"}],"output":{"name":"bool"}}],[11,"le","","",535,{"inputs":[{"name":"self"},{"name":"regionkind"}],"output":{"name":"bool"}}],[11,"gt","","",535,{"inputs":[{"name":"self"},{"name":"regionkind"}],"output":{"name":"bool"}}],[11,"ge","","",535,{"inputs":[{"name":"self"},{"name":"regionkind"}],"output":{"name":"bool"}}],[11,"cmp","","",535,{"inputs":[{"name":"self"},{"name":"regionkind"}],"output":{"name":"ordering"}}],[11,"clone","","",492,{"inputs":[{"name":"self"}],"output":{"name":"earlyboundregion"}}],[11,"eq","","",492,{"inputs":[{"name":"self"},{"name":"earlyboundregion"}],"output":{"name":"bool"}}],[11,"ne","","",492,{"inputs":[{"name":"self"},{"name":"earlyboundregion"}],"output":{"name":"bool"}}],[11,"hash","","",492,null],[11,"encode","","",492,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",492,{"inputs":[{"name":"__d"}],"output":{"generics":["earlyboundregion"],"name":"result"}}],[11,"fmt","","",492,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"partial_cmp","","",492,{"inputs":[{"name":"self"},{"name":"earlyboundregion"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",492,{"inputs":[{"name":"self"},{"name":"earlyboundregion"}],"output":{"name":"bool"}}],[11,"le","","",492,{"inputs":[{"name":"self"},{"name":"earlyboundregion"}],"output":{"name":"bool"}}],[11,"gt","","",492,{"inputs":[{"name":"self"},{"name":"earlyboundregion"}],"output":{"name":"bool"}}],[11,"ge","","",492,{"inputs":[{"name":"self"},{"name":"earlyboundregion"}],"output":{"name":"bool"}}],[11,"cmp","","",492,{"inputs":[{"name":"self"},{"name":"earlyboundregion"}],"output":{"name":"ordering"}}],[11,"clone","","",494,{"inputs":[{"name":"self"}],"output":{"name":"tyvid"}}],[11,"eq","","",494,{"inputs":[{"name":"self"},{"name":"tyvid"}],"output":{"name":"bool"}}],[11,"ne","","",494,{"inputs":[{"name":"self"},{"name":"tyvid"}],"output":{"name":"bool"}}],[11,"hash","","",494,null],[11,"encode","","",494,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",494,{"inputs":[{"name":"__d"}],"output":{"generics":["tyvid"],"name":"result"}}],[11,"clone","","",495,{"inputs":[{"name":"self"}],"output":{"name":"intvid"}}],[11,"eq","","",495,{"inputs":[{"name":"self"},{"name":"intvid"}],"output":{"name":"bool"}}],[11,"ne","","",495,{"inputs":[{"name":"self"},{"name":"intvid"}],"output":{"name":"bool"}}],[11,"hash","","",495,null],[11,"encode","","",495,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",495,{"inputs":[{"name":"__d"}],"output":{"generics":["intvid"],"name":"result"}}],[11,"clone","","",496,{"inputs":[{"name":"self"}],"output":{"name":"floatvid"}}],[11,"eq","","",496,{"inputs":[{"name":"self"},{"name":"floatvid"}],"output":{"name":"bool"}}],[11,"ne","","",496,{"inputs":[{"name":"self"},{"name":"floatvid"}],"output":{"name":"bool"}}],[11,"hash","","",496,null],[11,"encode","","",496,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",496,{"inputs":[{"name":"__d"}],"output":{"generics":["floatvid"],"name":"result"}}],[11,"clone","","",497,{"inputs":[{"name":"self"}],"output":{"name":"regionvid"}}],[11,"eq","","",497,{"inputs":[{"name":"self"},{"name":"regionvid"}],"output":{"name":"bool"}}],[11,"ne","","",497,{"inputs":[{"name":"self"},{"name":"regionvid"}],"output":{"name":"bool"}}],[11,"hash","","",497,null],[11,"partial_cmp","","",497,{"inputs":[{"name":"self"},{"name":"regionvid"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",497,{"inputs":[{"name":"self"},{"name":"regionvid"}],"output":{"name":"bool"}}],[11,"le","","",497,{"inputs":[{"name":"self"},{"name":"regionvid"}],"output":{"name":"bool"}}],[11,"gt","","",497,{"inputs":[{"name":"self"},{"name":"regionvid"}],"output":{"name":"bool"}}],[11,"ge","","",497,{"inputs":[{"name":"self"},{"name":"regionvid"}],"output":{"name":"bool"}}],[11,"cmp","","",497,{"inputs":[{"name":"self"},{"name":"regionvid"}],"output":{"name":"ordering"}}],[11,"decode","","",497,{"inputs":[{"name":"__d"}],"output":{"generics":["regionvid"],"name":"result"}}],[11,"encode","","",497,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"new","","",497,{"inputs":[{"name":"usize"}],"output":{"name":"self"}}],[11,"index","","",497,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"clone","","",498,{"inputs":[{"name":"self"}],"output":{"name":"skolemizedregionvid"}}],[11,"eq","","",498,{"inputs":[{"name":"self"},{"name":"skolemizedregionvid"}],"output":{"name":"bool"}}],[11,"ne","","",498,{"inputs":[{"name":"self"},{"name":"skolemizedregionvid"}],"output":{"name":"bool"}}],[11,"hash","","",498,null],[11,"encode","","",498,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",498,{"inputs":[{"name":"__d"}],"output":{"generics":["skolemizedregionvid"],"name":"result"}}],[11,"partial_cmp","","",498,{"inputs":[{"name":"self"},{"name":"skolemizedregionvid"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",498,{"inputs":[{"name":"self"},{"name":"skolemizedregionvid"}],"output":{"name":"bool"}}],[11,"le","","",498,{"inputs":[{"name":"self"},{"name":"skolemizedregionvid"}],"output":{"name":"bool"}}],[11,"gt","","",498,{"inputs":[{"name":"self"},{"name":"skolemizedregionvid"}],"output":{"name":"bool"}}],[11,"ge","","",498,{"inputs":[{"name":"self"},{"name":"skolemizedregionvid"}],"output":{"name":"bool"}}],[11,"cmp","","",498,{"inputs":[{"name":"self"},{"name":"skolemizedregionvid"}],"output":{"name":"ordering"}}],[11,"clone","","",531,{"inputs":[{"name":"self"}],"output":{"name":"inferty"}}],[11,"eq","","",531,{"inputs":[{"name":"self"},{"name":"inferty"}],"output":{"name":"bool"}}],[11,"ne","","",531,{"inputs":[{"name":"self"},{"name":"inferty"}],"output":{"name":"bool"}}],[11,"hash","","",531,null],[11,"encode","","",531,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",531,{"inputs":[{"name":"__d"}],"output":{"generics":["inferty"],"name":"result"}}],[11,"clone","","",771,{"inputs":[{"name":"self"}],"output":{"name":"canonicalvar"}}],[11,"eq","","",771,{"inputs":[{"name":"self"},{"name":"canonicalvar"}],"output":{"name":"bool"}}],[11,"ne","","",771,{"inputs":[{"name":"self"},{"name":"canonicalvar"}],"output":{"name":"bool"}}],[11,"hash","","",771,null],[11,"partial_cmp","","",771,{"inputs":[{"name":"self"},{"name":"canonicalvar"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",771,{"inputs":[{"name":"self"},{"name":"canonicalvar"}],"output":{"name":"bool"}}],[11,"le","","",771,{"inputs":[{"name":"self"},{"name":"canonicalvar"}],"output":{"name":"bool"}}],[11,"gt","","",771,{"inputs":[{"name":"self"},{"name":"canonicalvar"}],"output":{"name":"bool"}}],[11,"ge","","",771,{"inputs":[{"name":"self"},{"name":"canonicalvar"}],"output":{"name":"bool"}}],[11,"cmp","","",771,{"inputs":[{"name":"self"},{"name":"canonicalvar"}],"output":{"name":"ordering"}}],[11,"decode","","",771,{"inputs":[{"name":"__d"}],"output":{"generics":["canonicalvar"],"name":"result"}}],[11,"encode","","",771,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"new","","",771,{"inputs":[{"name":"usize"}],"output":{"name":"self"}}],[11,"index","","",771,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"fmt","","",771,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",490,{"inputs":[{"name":"self"}],"output":{"name":"existentialprojection"}}],[11,"eq","","",490,{"inputs":[{"name":"self"},{"name":"existentialprojection"}],"output":{"name":"bool"}}],[11,"ne","","",490,{"inputs":[{"name":"self"},{"name":"existentialprojection"}],"output":{"name":"bool"}}],[11,"hash","","",490,null],[11,"fmt","","",490,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",490,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",490,{"inputs":[{"name":"__d"}],"output":{"generics":["existentialprojection"],"name":"result"}}],[11,"trait_ref","","Extracts the underlying existential trait reference from this projection. For example, if this is a projection of `exists T. <T as Iterator>::Item == X`, then this function would return a `exists T. T: Iterator` existential trait reference.",490,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"existentialtraitref"}}],[11,"with_self_ty","","",490,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"ty"}],"output":{"name":"projectionpredicate"}}],[11,"new","","",480,{"inputs":[{"name":"u32"}],"output":{"name":"debruijnindex"}}],[11,"shifted","","",480,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"debruijnindex"}}],[11,"is_late_bound","","",535,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"needs_infer","","",535,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"escapes_depth","","",535,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"bool"}}],[11,"from_depth","","Returns the depth of `self` from the (1-based) binding level `depth`",535,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"regionkind"}}],[11,"type_flags","","",535,{"inputs":[{"name":"self"}],"output":{"name":"typeflags"}}],[11,"free_region_binding_scope","","Given an early-bound or free region, returns the def-id where it was bound. For example, consider the regions in this snippet of code:",535,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"defid"}}],[11,"is_nil","","",508,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_never","","",508,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_primitive","","",508,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_ty_var","","",508,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_ty_infer","","",508,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_phantom_data","","",508,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_bool","","",508,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_param","","",508,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"bool"}}],[11,"is_self","","",508,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_slice","","",508,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_simd","","",508,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"sequence_element_type","","",508,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"ty"}}],[11,"simd_type","","",508,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"ty"}}],[11,"simd_size","","",508,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"usize"}}],[11,"is_region_ptr","","",508,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_mutable_pointer","","",508,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_unsafe_ptr","","",508,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_box","","",508,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"boxed_ty","","panics if called on any type other than `Box<T>`",508,{"inputs":[{"name":"self"}],"output":{"name":"ty"}}],[11,"is_scalar","","A scalar type is one that denotes an atomic datum, with no sub-components. (A TyRawPtr is scalar because it represents a non-managed pointer, so its contents are abstract to rustc.)",508,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_floating_point","","Returns true if this type is a floating point type and false otherwise.",508,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_trait","","",508,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_enum","","",508,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_closure","","",508,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_generator","","",508,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_integral","","",508,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_fresh_ty","","",508,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_fresh","","",508,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_char","","",508,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_fp","","",508,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_numeric","","",508,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_signed","","",508,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_machine","","",508,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"has_concrete_skeleton","","",508,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"builtin_deref","","Returns the type and mutability of *ty.",508,{"inputs":[{"name":"self"},{"name":"bool"}],"output":{"generics":["typeandmut"],"name":"option"}}],[11,"builtin_index","","Returns the type of ty[i]",508,{"inputs":[{"name":"self"}],"output":{"generics":["ty"],"name":"option"}}],[11,"fn_sig","","",508,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"polyfnsig"}}],[11,"is_fn","","",508,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"ty_to_def_id","","",508,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"ty_adt_def","","",508,{"inputs":[{"name":"self"}],"output":{"generics":["adtdef"],"name":"option"}}],[11,"regions","","Returns the regions directly referenced from this type (but not types reachable from this type via `walk_tys`). This ignores late-bound regions binders.",508,{"inputs":[{"name":"self"}],"output":{"generics":["region"],"name":"vec"}}],[11,"to_opt_closure_kind","","When we create a closure, we record its kind (i.e., what trait it implements) into its `ClosureSubsts` using a type parameter. This is kind of a phantom type, except that the most convenient thing for us to are the integral types. This function converts such a special type into the closure kind. To go the other way, use `tcx.closure_kind_ty(closure_kind)`.",508,{"inputs":[{"name":"self"}],"output":{"generics":["closurekind"],"name":"option"}}],[11,"clone","","",491,{"inputs":[{"name":"self"}],"output":{"name":"const"}}],[11,"fmt","","",491,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",491,null],[11,"encode","","",491,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",491,{"inputs":[{"name":"__d"}],"output":{"generics":["const"],"name":"result"}}],[11,"eq","","",491,{"inputs":[{"name":"self"},{"name":"const"}],"output":{"name":"bool"}}],[11,"ne","","",491,{"inputs":[{"name":"self"},{"name":"const"}],"output":{"name":"bool"}}],[6,"PolyFnSig","","",null,null],[6,"PolyGenSig","","",null,null],[6,"PolyTraitRef","","",null,null],[6,"PolyExistentialTraitRef","","",null,null],[6,"PolyExistentialProjection","","",null,null],[6,"Region","","",null,null],[6,"Ty","","",null,null],[6,"CanonicalTy","","",null,null],[6,"UpvarCaptureMap","","",null,null],[6,"PolyTraitPredicate","","",null,null],[6,"PolyOutlivesPredicate","","",null,null],[6,"RegionOutlivesPredicate","","",null,null],[6,"TypeOutlivesPredicate","","",null,null],[6,"PolyRegionOutlivesPredicate","","",null,null],[6,"PolyTypeOutlivesPredicate","","",null,null],[6,"PolySubtypePredicate","","",null,null],[6,"PolyProjectionPredicate","","",null,null],[8,"Lift","","A trait implemented for all X<'a> types which can be safely and efficiently converted to X<'tcx> as long as they are part of the provided TyCtxt<'tcx>. This can be done, for example, for Ty<'tcx> or &'tcx Substs<'tcx> by looking them up in their respective interners.",null,null],[16,"Lifted","","",772,null],[10,"lift_to_tcx","","",772,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[8,"DefIdTree","","",null,null],[10,"parent","","",773,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["defid"],"name":"option"}}],[11,"is_descendant_of","","",773,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"defid"}],"output":{"name":"bool"}}],[8,"ToPolyTraitRef","","",null,null],[10,"to_poly_trait_ref","","",774,{"inputs":[{"name":"self"}],"output":{"name":"polytraitref"}}],[8,"ToPredicate","","",null,null],[10,"to_predicate","","",775,{"inputs":[{"name":"self"}],"output":{"name":"predicate"}}],[11,"clone","","",502,{"inputs":[{"name":"self"}],"output":{"name":"crateanalysis"}}],[11,"clone","","",503,{"inputs":[{"name":"self"}],"output":{"name":"resolutions"}}],[11,"clone","","",537,{"inputs":[{"name":"self"}],"output":{"name":"associateditemcontainer"}}],[11,"eq","","",537,{"inputs":[{"name":"self"},{"name":"associateditemcontainer"}],"output":{"name":"bool"}}],[11,"ne","","",537,{"inputs":[{"name":"self"},{"name":"associateditemcontainer"}],"output":{"name":"bool"}}],[11,"fmt","","",537,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"assert_trait","","Asserts that this is the def-id of an associated item declared in a trait, and returns the trait def-id.",537,{"inputs":[{"name":"self"}],"output":{"name":"defid"}}],[11,"id","","",537,{"inputs":[{"name":"self"}],"output":{"name":"defid"}}],[11,"clone","","",504,{"inputs":[{"name":"self"}],"output":{"name":"implheader"}}],[11,"eq","","",504,{"inputs":[{"name":"self"},{"name":"implheader"}],"output":{"name":"bool"}}],[11,"ne","","",504,{"inputs":[{"name":"self"},{"name":"implheader"}],"output":{"name":"bool"}}],[11,"hash","","",504,null],[11,"fmt","","",504,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",505,{"inputs":[{"name":"self"}],"output":{"name":"associateditem"}}],[11,"fmt","","",505,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",505,{"inputs":[{"name":"self"},{"name":"associateditem"}],"output":{"name":"bool"}}],[11,"ne","","",505,{"inputs":[{"name":"self"},{"name":"associateditem"}],"output":{"name":"bool"}}],[11,"clone","","",538,{"inputs":[{"name":"self"}],"output":{"name":"associatedkind"}}],[11,"eq","","",538,{"inputs":[{"name":"self"},{"name":"associatedkind"}],"output":{"name":"bool"}}],[11,"fmt","","",538,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",538,null],[11,"encode","","",538,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",538,{"inputs":[{"name":"__d"}],"output":{"generics":["associatedkind"],"name":"result"}}],[11,"def","","",505,{"inputs":[{"name":"self"}],"output":{"name":"def"}}],[11,"relevant_for_never","","Tests whether the associated item admits a non-trivial implementation for !",505,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"signature","","",505,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"string"}}],[11,"clone","","",539,{"inputs":[{"name":"self"}],"output":{"name":"visibility"}}],[11,"fmt","","",539,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",539,{"inputs":[{"name":"self"},{"name":"visibility"}],"output":{"name":"bool"}}],[11,"ne","","",539,{"inputs":[{"name":"self"},{"name":"visibility"}],"output":{"name":"bool"}}],[11,"encode","","",539,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",539,{"inputs":[{"name":"__d"}],"output":{"generics":["visibility"],"name":"result"}}],[11,"parent","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["defid"],"name":"option"}}],[11,"from_hir","","",539,{"inputs":[{"name":"visibility"},{"name":"nodeid"},{"name":"tyctxt"}],"output":{"name":"self"}}],[11,"is_accessible_from","","Returns true if an item with this visibility is accessible from the given block.",539,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"t"}],"output":{"name":"bool"}}],[11,"is_at_least","","Returns true if this visibility is at least as accessible as the given visibility",539,{"inputs":[{"name":"self"},{"name":"visibility"},{"name":"t"}],"output":{"name":"bool"}}],[11,"is_visible_locally","","",539,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",540,{"inputs":[{"name":"self"}],"output":{"name":"variance"}}],[11,"eq","","",540,{"inputs":[{"name":"self"},{"name":"variance"}],"output":{"name":"bool"}}],[11,"decode","","",540,{"inputs":[{"name":"__d"}],"output":{"generics":["variance"],"name":"result"}}],[11,"encode","","",540,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"xform","","`a.xform(b)` combines the variance of a context with the variance of a type with the following meaning.  If we are in a context with variance `a`, and we encounter a type argument in a position with variance `b`, then `a.xform(b)` is the new variance with which the argument appears.",540,{"inputs":[{"name":"self"},{"name":"variance"}],"output":{"name":"variance"}}],[11,"clone","","",507,{"inputs":[{"name":"self"}],"output":{"name":"creadercachekey"}}],[11,"eq","","",507,{"inputs":[{"name":"self"},{"name":"creadercachekey"}],"output":{"name":"bool"}}],[11,"ne","","",507,{"inputs":[{"name":"self"},{"name":"creadercachekey"}],"output":{"name":"bool"}}],[11,"hash","","",507,null],[11,"eq","","",776,{"inputs":[{"name":"self"},{"name":"typeflags"}],"output":{"name":"bool"}}],[11,"ne","","",776,{"inputs":[{"name":"self"},{"name":"typeflags"}],"output":{"name":"bool"}}],[11,"clone","","",776,{"inputs":[{"name":"self"}],"output":{"name":"typeflags"}}],[11,"partial_cmp","","",776,{"inputs":[{"name":"self"},{"name":"typeflags"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",776,{"inputs":[{"name":"self"},{"name":"typeflags"}],"output":{"name":"bool"}}],[11,"le","","",776,{"inputs":[{"name":"self"},{"name":"typeflags"}],"output":{"name":"bool"}}],[11,"gt","","",776,{"inputs":[{"name":"self"},{"name":"typeflags"}],"output":{"name":"bool"}}],[11,"ge","","",776,{"inputs":[{"name":"self"},{"name":"typeflags"}],"output":{"name":"bool"}}],[11,"cmp","","",776,{"inputs":[{"name":"self"},{"name":"typeflags"}],"output":{"name":"ordering"}}],[11,"hash","","",776,null],[11,"fmt","","",776,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",776,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",776,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",776,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",776,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[18,"HAS_PARAMS","","",776,null],[18,"HAS_SELF","","",776,null],[18,"HAS_TY_INFER","","",776,null],[18,"HAS_RE_INFER","","",776,null],[18,"HAS_RE_SKOL","","",776,null],[18,"HAS_RE_EARLY_BOUND","","Does this have any `ReEarlyBound` regions? Used to determine whether substitition is required, since those represent regions that are bound in a `ty::Generics` and hence may be substituted.",776,null],[18,"HAS_FREE_REGIONS","","Does this have any region that \"appears free\" in the type? Basically anything but `ReLateBound` and `ReErased`.",776,null],[18,"HAS_TY_ERR","","Is an error type reachable?",776,null],[18,"HAS_PROJECTION","","",776,null],[18,"HAS_TY_CLOSURE","","",776,null],[18,"HAS_LOCAL_NAMES","","",776,null],[18,"KEEP_IN_LOCAL_TCX","","",776,null],[18,"HAS_NORMALIZABLE_PROJECTION","","",776,null],[18,"HAS_CANONICAL_VARS","","",776,null],[18,"NEEDS_SUBST","","",776,null],[18,"NOMINAL_FLAGS","","",776,null],[11,"empty","","Returns an empty set of flags.",776,{"inputs":[],"output":{"name":"typeflags"}}],[11,"all","","Returns the set containing all flags.",776,{"inputs":[],"output":{"name":"typeflags"}}],[11,"bits","","Returns the raw value of the flags currently stored.",776,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"from_bits","","Convert from underlying bit representation, unless that representation contains bits that do not correspond to a flag.",776,{"inputs":[{"name":"u32"}],"output":{"generics":["typeflags"],"name":"option"}}],[11,"from_bits_truncate","","Convert from underlying bit representation, dropping any bits that do not correspond to flags.",776,{"inputs":[{"name":"u32"}],"output":{"name":"typeflags"}}],[11,"is_empty","","Returns `true` if no flags are currently stored.",776,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_all","","Returns `true` if all flags are currently set.",776,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"intersects","","Returns `true` if there are flags common to both `self` and `other`.",776,{"inputs":[{"name":"self"},{"name":"typeflags"}],"output":{"name":"bool"}}],[11,"contains","","Returns `true` all of the flags in `other` are contained within `self`.",776,{"inputs":[{"name":"self"},{"name":"typeflags"}],"output":{"name":"bool"}}],[11,"insert","","Inserts the specified flags in-place.",776,{"inputs":[{"name":"self"},{"name":"typeflags"}],"output":null}],[11,"remove","","Removes the specified flags in-place.",776,{"inputs":[{"name":"self"},{"name":"typeflags"}],"output":null}],[11,"toggle","","Toggles the specified flags in-place.",776,{"inputs":[{"name":"self"},{"name":"typeflags"}],"output":null}],[11,"set","","Inserts or removes the specified flags depending on the passed value.",776,{"inputs":[{"name":"self"},{"name":"typeflags"},{"name":"bool"}],"output":null}],[11,"bitor","","Returns the union of the two sets of flags.",776,{"inputs":[{"name":"self"},{"name":"typeflags"}],"output":{"name":"typeflags"}}],[11,"bitor_assign","","Adds the set of flags.",776,{"inputs":[{"name":"self"},{"name":"typeflags"}],"output":null}],[11,"bitxor","","Returns the left flags, but with all the right flags toggled.",776,{"inputs":[{"name":"self"},{"name":"typeflags"}],"output":{"name":"typeflags"}}],[11,"bitxor_assign","","Toggles the set of flags.",776,{"inputs":[{"name":"self"},{"name":"typeflags"}],"output":null}],[11,"bitand","","Returns the intersection between the two sets of flags.",776,{"inputs":[{"name":"self"},{"name":"typeflags"}],"output":{"name":"typeflags"}}],[11,"bitand_assign","","Disables all flags disabled in the set.",776,{"inputs":[{"name":"self"},{"name":"typeflags"}],"output":null}],[11,"sub","","Returns the set difference of the two sets of flags.",776,{"inputs":[{"name":"self"},{"name":"typeflags"}],"output":{"name":"typeflags"}}],[11,"sub_assign","","Disables all flags enabled in the set.",776,{"inputs":[{"name":"self"},{"name":"typeflags"}],"output":null}],[11,"not","","Returns the complement of this set of flags.",776,{"inputs":[{"name":"self"}],"output":{"name":"typeflags"}}],[11,"extend","","",776,{"inputs":[{"name":"self"},{"name":"t"}],"output":null}],[11,"from_iter","","",776,{"inputs":[{"name":"t"}],"output":{"name":"typeflags"}}],[11,"eq","","",508,{"inputs":[{"name":"self"},{"name":"tys"}],"output":{"name":"bool"}}],[11,"hash","","",508,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"is_primitive_ty","","",508,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_suggestable","","",508,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"hash_stable","","",508,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"intern","","",777,null],[11,"fmt","","",770,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",770,{"inputs":[{"name":"self"},{"name":"__st"}],"output":{"name":"result"}}],[11,"eq","","",770,{"inputs":[{"name":"self"},{"name":"slice"}],"output":{"name":"bool"}}],[11,"hash","","",770,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"deref","","",770,null],[11,"empty","","",770,{"inputs":[],"output":{"name":"slice"}}],[11,"clone","","",509,{"inputs":[{"name":"self"}],"output":{"name":"upvarid"}}],[11,"eq","","",509,{"inputs":[{"name":"self"},{"name":"upvarid"}],"output":{"name":"bool"}}],[11,"ne","","",509,{"inputs":[{"name":"self"},{"name":"upvarid"}],"output":{"name":"bool"}}],[11,"hash","","",509,null],[11,"encode","","",509,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",509,{"inputs":[{"name":"__d"}],"output":{"generics":["upvarid"],"name":"result"}}],[11,"clone","","",541,{"inputs":[{"name":"self"}],"output":{"name":"borrowkind"}}],[11,"eq","","",541,{"inputs":[{"name":"self"},{"name":"borrowkind"}],"output":{"name":"bool"}}],[11,"hash","","",541,null],[11,"fmt","","",541,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",541,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",541,{"inputs":[{"name":"__d"}],"output":{"generics":["borrowkind"],"name":"result"}}],[11,"eq","","",542,{"inputs":[{"name":"self"},{"name":"upvarcapture"}],"output":{"name":"bool"}}],[11,"ne","","",542,{"inputs":[{"name":"self"},{"name":"upvarcapture"}],"output":{"name":"bool"}}],[11,"clone","","",542,{"inputs":[{"name":"self"}],"output":{"name":"upvarcapture"}}],[11,"fmt","","",542,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",542,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",542,{"inputs":[{"name":"__d"}],"output":{"generics":["upvarcapture"],"name":"result"}}],[11,"eq","","",510,{"inputs":[{"name":"self"},{"name":"upvarborrow"}],"output":{"name":"bool"}}],[11,"ne","","",510,{"inputs":[{"name":"self"},{"name":"upvarborrow"}],"output":{"name":"bool"}}],[11,"clone","","",510,{"inputs":[{"name":"self"}],"output":{"name":"upvarborrow"}}],[11,"encode","","",510,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",510,{"inputs":[{"name":"__d"}],"output":{"generics":["upvarborrow"],"name":"result"}}],[11,"clone","","",511,{"inputs":[{"name":"self"}],"output":{"name":"closureupvar"}}],[11,"clone","","",543,{"inputs":[{"name":"self"}],"output":{"name":"intvarvalue"}}],[11,"eq","","",543,{"inputs":[{"name":"self"},{"name":"intvarvalue"}],"output":{"name":"bool"}}],[11,"ne","","",543,{"inputs":[{"name":"self"},{"name":"intvarvalue"}],"output":{"name":"bool"}}],[11,"clone","","",512,{"inputs":[{"name":"self"}],"output":{"name":"floatvarvalue"}}],[11,"eq","","",512,{"inputs":[{"name":"self"},{"name":"floatvarvalue"}],"output":{"name":"bool"}}],[11,"ne","","",512,{"inputs":[{"name":"self"},{"name":"floatvarvalue"}],"output":{"name":"bool"}}],[11,"clone","","",513,{"inputs":[{"name":"self"}],"output":{"name":"typeparameterdef"}}],[11,"encode","","",513,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",513,{"inputs":[{"name":"__d"}],"output":{"generics":["typeparameterdef"],"name":"result"}}],[11,"clone","","",514,{"inputs":[{"name":"self"}],"output":{"name":"regionparameterdef"}}],[11,"encode","","",514,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",514,{"inputs":[{"name":"__d"}],"output":{"generics":["regionparameterdef"],"name":"result"}}],[11,"to_early_bound_region_data","","",514,{"inputs":[{"name":"self"}],"output":{"name":"earlyboundregion"}}],[11,"to_bound_region","","",514,{"inputs":[{"name":"self"}],"output":{"name":"boundregion"}}],[11,"to_bound_region","","",492,{"inputs":[{"name":"self"}],"output":{"name":"boundregion"}}],[11,"clone","","",515,{"inputs":[{"name":"self"}],"output":{"name":"generics"}}],[11,"fmt","","",515,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",515,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",515,{"inputs":[{"name":"__d"}],"output":{"generics":["generics"],"name":"result"}}],[11,"parent_count","","",515,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"own_count","","",515,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"count","","",515,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"region_param","","",515,{"inputs":[{"name":"self"},{"name":"earlyboundregion"},{"name":"tyctxt"}],"output":{"name":"regionparameterdef"}}],[11,"type_param","","Returns the `TypeParameterDef` associated with this `ParamTy`.",515,{"inputs":[{"name":"self"},{"name":"paramty"},{"name":"tyctxt"}],"output":{"name":"typeparameterdef"}}],[11,"clone","","",516,{"inputs":[{"name":"self"}],"output":{"name":"genericpredicates"}}],[11,"default","","",516,{"inputs":[],"output":{"name":"genericpredicates"}}],[11,"instantiate","","",516,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"substs"}],"output":{"name":"instantiatedpredicates"}}],[11,"instantiate_own","","",516,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"substs"}],"output":{"name":"instantiatedpredicates"}}],[11,"instantiate_identity","","",516,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"instantiatedpredicates"}}],[11,"instantiate_supertrait","","",516,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"polytraitref"}],"output":{"name":"instantiatedpredicates"}}],[11,"clone","","",544,{"inputs":[{"name":"self"}],"output":{"name":"predicate"}}],[11,"eq","","",544,{"inputs":[{"name":"self"},{"name":"predicate"}],"output":{"name":"bool"}}],[11,"ne","","",544,{"inputs":[{"name":"self"},{"name":"predicate"}],"output":{"name":"bool"}}],[11,"hash","","",544,null],[11,"encode","","",544,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",544,{"inputs":[{"name":"__d"}],"output":{"generics":["predicate"],"name":"result"}}],[11,"as_ref","","",544,{"inputs":[{"name":"self"}],"output":{"name":"predicate"}}],[11,"subst_supertrait","","Performs a substitution suitable for going from a poly-trait-ref to supertraits that must hold if that poly-trait-ref holds. This is slightly different from a normal substitution in terms of what happens with bound regions.  See lengthy comment below for details.",544,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"polytraitref"}],"output":{"name":"predicate"}}],[11,"clone","","",517,{"inputs":[{"name":"self"}],"output":{"name":"traitpredicate"}}],[11,"eq","","",517,{"inputs":[{"name":"self"},{"name":"traitpredicate"}],"output":{"name":"bool"}}],[11,"ne","","",517,{"inputs":[{"name":"self"},{"name":"traitpredicate"}],"output":{"name":"bool"}}],[11,"hash","","",517,null],[11,"encode","","",517,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",517,{"inputs":[{"name":"__d"}],"output":{"generics":["traitpredicate"],"name":"result"}}],[11,"def_id","","",517,{"inputs":[{"name":"self"}],"output":{"name":"defid"}}],[11,"input_types","","",517,null],[11,"self_ty","","",517,{"inputs":[{"name":"self"}],"output":{"name":"ty"}}],[11,"def_id","","",778,{"inputs":[{"name":"self"}],"output":{"name":"defid"}}],[11,"clone","","",518,{"inputs":[{"name":"self"}],"output":{"name":"outlivespredicate"}}],[11,"eq","","",518,{"inputs":[{"name":"self"},{"name":"outlivespredicate"}],"output":{"name":"bool"}}],[11,"ne","","",518,{"inputs":[{"name":"self"},{"name":"outlivespredicate"}],"output":{"name":"bool"}}],[11,"hash","","",518,null],[11,"fmt","","",518,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",518,{"inputs":[{"name":"self"},{"name":"__sab"}],"output":{"name":"result"}}],[11,"decode","","",518,{"inputs":[{"name":"__dab"}],"output":{"generics":["outlivespredicate"],"name":"result"}}],[11,"clone","","",519,{"inputs":[{"name":"self"}],"output":{"name":"subtypepredicate"}}],[11,"eq","","",519,{"inputs":[{"name":"self"},{"name":"subtypepredicate"}],"output":{"name":"bool"}}],[11,"ne","","",519,{"inputs":[{"name":"self"},{"name":"subtypepredicate"}],"output":{"name":"bool"}}],[11,"hash","","",519,null],[11,"fmt","","",519,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",519,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",519,{"inputs":[{"name":"__d"}],"output":{"generics":["subtypepredicate"],"name":"result"}}],[11,"clone","","",520,{"inputs":[{"name":"self"}],"output":{"name":"projectionpredicate"}}],[11,"eq","","",520,{"inputs":[{"name":"self"},{"name":"projectionpredicate"}],"output":{"name":"bool"}}],[11,"ne","","",520,{"inputs":[{"name":"self"},{"name":"projectionpredicate"}],"output":{"name":"bool"}}],[11,"hash","","",520,null],[11,"encode","","",520,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",520,{"inputs":[{"name":"__d"}],"output":{"generics":["projectionpredicate"],"name":"result"}}],[11,"to_poly_trait_ref","","",779,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"polytraitref"}}],[11,"ty","","",779,{"inputs":[{"name":"self"}],"output":{"generics":["ty"],"name":"binder"}}],[11,"to_poly_trait_ref","","",488,{"inputs":[{"name":"self"}],"output":{"name":"polytraitref"}}],[11,"to_poly_trait_ref","","",778,{"inputs":[{"name":"self"}],"output":{"name":"polytraitref"}}],[11,"to_predicate","","",488,{"inputs":[{"name":"self"}],"output":{"name":"predicate"}}],[11,"to_predicate","","",780,{"inputs":[{"name":"self"}],"output":{"name":"predicate"}}],[11,"to_predicate","","",781,{"inputs":[{"name":"self"}],"output":{"name":"predicate"}}],[11,"to_predicate","","",782,{"inputs":[{"name":"self"}],"output":{"name":"predicate"}}],[11,"to_predicate","","",779,{"inputs":[{"name":"self"}],"output":{"name":"predicate"}}],[11,"walk_tys","","Iterates over the types in this predicate. Note that in all cases this is skipping over a binder, so late-bound regions with depth 0 are bound by the predicate.",544,{"inputs":[{"name":"self"}],"output":{"generics":["ty"],"name":"intoiter"}}],[11,"to_opt_poly_trait_ref","","",544,{"inputs":[{"name":"self"}],"output":{"generics":["polytraitref"],"name":"option"}}],[11,"to_opt_type_outlives","","",544,{"inputs":[{"name":"self"}],"output":{"generics":["polytypeoutlivespredicate"],"name":"option"}}],[11,"clone","","",521,{"inputs":[{"name":"self"}],"output":{"name":"instantiatedpredicates"}}],[11,"empty","","",521,{"inputs":[],"output":{"name":"instantiatedpredicates"}}],[11,"is_empty","","",521,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",783,{"inputs":[{"name":"self"}],"output":{"name":"universeindex"}}],[11,"fmt","","",783,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",783,{"inputs":[{"name":"self"},{"name":"universeindex"}],"output":{"name":"bool"}}],[11,"ne","","",783,{"inputs":[{"name":"self"},{"name":"universeindex"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",783,{"inputs":[{"name":"self"},{"name":"universeindex"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",783,{"inputs":[{"name":"self"},{"name":"universeindex"}],"output":{"name":"bool"}}],[11,"le","","",783,{"inputs":[{"name":"self"},{"name":"universeindex"}],"output":{"name":"bool"}}],[11,"gt","","",783,{"inputs":[{"name":"self"},{"name":"universeindex"}],"output":{"name":"bool"}}],[11,"ge","","",783,{"inputs":[{"name":"self"},{"name":"universeindex"}],"output":{"name":"bool"}}],[11,"cmp","","",783,{"inputs":[{"name":"self"},{"name":"universeindex"}],"output":{"name":"ordering"}}],[11,"hash","","",783,null],[11,"root","","The root universe, where things that the user defined are visible.",783,{"inputs":[],"output":{"name":"universeindex"}}],[11,"subuniverse","","A \"subuniverse\" corresponds to being inside a `forall` quantifier. So, for example, suppose we have this type in universe `U`:",783,{"inputs":[{"name":"self"}],"output":{"name":"universeindex"}}],[11,"clone","","",522,{"inputs":[{"name":"self"}],"output":{"name":"paramenv"}}],[11,"fmt","","",522,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",522,{"inputs":[{"name":"self"},{"name":"paramenv"}],"output":{"name":"bool"}}],[11,"ne","","",522,{"inputs":[{"name":"self"},{"name":"paramenv"}],"output":{"name":"bool"}}],[11,"hash","","",522,null],[11,"empty","","Construct a trait environment suitable for contexts where there are no where clauses in scope. Hidden types (like `impl Trait`) are left hidden, so this is suitable for ordinary type-checking.",522,{"inputs":[],"output":{"name":"self"}}],[11,"reveal_all","","Construct a trait environment with no where clauses in scope where the values of all `impl Trait` and other hidden types are revealed. This is suitable for monomorphized, post-typeck environments like trans or doing optimizations.",522,{"inputs":[],"output":{"name":"self"}}],[11,"new","","Construct a trait environment with the given set of predicates.",522,{"inputs":[{"name":"slice"},{"name":"reveal"}],"output":{"name":"self"}}],[11,"with_reveal_all","","Returns a new parameter environment with the same clauses, but which \"reveals\" the true results of projections in all cases (even for associated types that are specializable).  This is the desired behavior during trans and certain other special contexts; normally though we want to use `Reveal::UserFacing`, which is the default.",522,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"without_caller_bounds","","Returns this same environment but with no caller bounds.",522,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"and","","Creates a suitable environment in which to perform trait queries on the given value. When type-checking, this is simply the pair of the environment plus value. But when reveal is set to All, then if `value` does not reference any type parameters, we will pair it with the empty environment. This improves caching and is generally invisible.",522,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"paramenvand"}}],[11,"clone","","",523,{"inputs":[{"name":"self"}],"output":{"name":"paramenvand"}}],[11,"fmt","","",523,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",523,{"inputs":[{"name":"self"},{"name":"paramenvand"}],"output":{"name":"bool"}}],[11,"ne","","",523,{"inputs":[{"name":"self"},{"name":"paramenvand"}],"output":{"name":"bool"}}],[11,"hash","","",523,null],[11,"into_parts","","",523,null],[11,"hash_stable","","",523,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"clone","","",524,{"inputs":[{"name":"self"}],"output":{"name":"destructor"}}],[11,"fmt","","",524,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",784,{"inputs":[{"name":"self"},{"name":"adtflags"}],"output":{"name":"bool"}}],[11,"ne","","",784,{"inputs":[{"name":"self"},{"name":"adtflags"}],"output":{"name":"bool"}}],[11,"clone","","",784,{"inputs":[{"name":"self"}],"output":{"name":"adtflags"}}],[11,"partial_cmp","","",784,{"inputs":[{"name":"self"},{"name":"adtflags"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",784,{"inputs":[{"name":"self"},{"name":"adtflags"}],"output":{"name":"bool"}}],[11,"le","","",784,{"inputs":[{"name":"self"},{"name":"adtflags"}],"output":{"name":"bool"}}],[11,"gt","","",784,{"inputs":[{"name":"self"},{"name":"adtflags"}],"output":{"name":"bool"}}],[11,"ge","","",784,{"inputs":[{"name":"self"},{"name":"adtflags"}],"output":{"name":"bool"}}],[11,"cmp","","",784,{"inputs":[{"name":"self"},{"name":"adtflags"}],"output":{"name":"ordering"}}],[11,"hash","","",784,null],[11,"fmt","","",784,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",784,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",784,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",784,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",784,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[18,"NO_ADT_FLAGS","","",784,null],[18,"IS_ENUM","","",784,null],[18,"IS_PHANTOM_DATA","","",784,null],[18,"IS_FUNDAMENTAL","","",784,null],[18,"IS_UNION","","",784,null],[18,"IS_BOX","","",784,null],[18,"IS_NON_EXHAUSTIVE","","Indicates whether this abstract data type will be expanded on in future (new fields/variants) and as such, whether downstream crates must match exhaustively on the fields/variants of this data type.",784,null],[11,"empty","","Returns an empty set of flags.",784,{"inputs":[],"output":{"name":"adtflags"}}],[11,"all","","Returns the set containing all flags.",784,{"inputs":[],"output":{"name":"adtflags"}}],[11,"bits","","Returns the raw value of the flags currently stored.",784,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"from_bits","","Convert from underlying bit representation, unless that representation contains bits that do not correspond to a flag.",784,{"inputs":[{"name":"u32"}],"output":{"generics":["adtflags"],"name":"option"}}],[11,"from_bits_truncate","","Convert from underlying bit representation, dropping any bits that do not correspond to flags.",784,{"inputs":[{"name":"u32"}],"output":{"name":"adtflags"}}],[11,"is_empty","","Returns `true` if no flags are currently stored.",784,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_all","","Returns `true` if all flags are currently set.",784,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"intersects","","Returns `true` if there are flags common to both `self` and `other`.",784,{"inputs":[{"name":"self"},{"name":"adtflags"}],"output":{"name":"bool"}}],[11,"contains","","Returns `true` all of the flags in `other` are contained within `self`.",784,{"inputs":[{"name":"self"},{"name":"adtflags"}],"output":{"name":"bool"}}],[11,"insert","","Inserts the specified flags in-place.",784,{"inputs":[{"name":"self"},{"name":"adtflags"}],"output":null}],[11,"remove","","Removes the specified flags in-place.",784,{"inputs":[{"name":"self"},{"name":"adtflags"}],"output":null}],[11,"toggle","","Toggles the specified flags in-place.",784,{"inputs":[{"name":"self"},{"name":"adtflags"}],"output":null}],[11,"set","","Inserts or removes the specified flags depending on the passed value.",784,{"inputs":[{"name":"self"},{"name":"adtflags"},{"name":"bool"}],"output":null}],[11,"bitor","","Returns the union of the two sets of flags.",784,{"inputs":[{"name":"self"},{"name":"adtflags"}],"output":{"name":"adtflags"}}],[11,"bitor_assign","","Adds the set of flags.",784,{"inputs":[{"name":"self"},{"name":"adtflags"}],"output":null}],[11,"bitxor","","Returns the left flags, but with all the right flags toggled.",784,{"inputs":[{"name":"self"},{"name":"adtflags"}],"output":{"name":"adtflags"}}],[11,"bitxor_assign","","Toggles the set of flags.",784,{"inputs":[{"name":"self"},{"name":"adtflags"}],"output":null}],[11,"bitand","","Returns the intersection between the two sets of flags.",784,{"inputs":[{"name":"self"},{"name":"adtflags"}],"output":{"name":"adtflags"}}],[11,"bitand_assign","","Disables all flags disabled in the set.",784,{"inputs":[{"name":"self"},{"name":"adtflags"}],"output":null}],[11,"sub","","Returns the set difference of the two sets of flags.",784,{"inputs":[{"name":"self"},{"name":"adtflags"}],"output":{"name":"adtflags"}}],[11,"sub_assign","","Disables all flags enabled in the set.",784,{"inputs":[{"name":"self"},{"name":"adtflags"}],"output":null}],[11,"not","","Returns the complement of this set of flags.",784,{"inputs":[{"name":"self"}],"output":{"name":"adtflags"}}],[11,"extend","","",784,{"inputs":[{"name":"self"},{"name":"t"}],"output":null}],[11,"from_iter","","",784,{"inputs":[{"name":"t"}],"output":{"name":"adtflags"}}],[11,"fmt","","",525,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",545,{"inputs":[{"name":"self"}],"output":{"name":"variantdiscr"}}],[11,"fmt","","",545,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",545,{"inputs":[{"name":"self"},{"name":"variantdiscr"}],"output":{"name":"bool"}}],[11,"ne","","",545,{"inputs":[{"name":"self"},{"name":"variantdiscr"}],"output":{"name":"bool"}}],[11,"encode","","",545,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",545,{"inputs":[{"name":"__d"}],"output":{"generics":["variantdiscr"],"name":"result"}}],[11,"fmt","","",526,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",527,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"bool"}}],[11,"hash","","",527,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"hash_stable","","",527,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"clone","","",546,{"inputs":[{"name":"self"}],"output":{"name":"adtkind"}}],[11,"fmt","","",546,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",546,{"inputs":[{"name":"self"},{"name":"adtkind"}],"output":{"name":"bool"}}],[11,"hash","","",546,null],[11,"eq","","",785,{"inputs":[{"name":"self"},{"name":"reprflags"}],"output":{"name":"bool"}}],[11,"ne","","",785,{"inputs":[{"name":"self"},{"name":"reprflags"}],"output":{"name":"bool"}}],[11,"clone","","",785,{"inputs":[{"name":"self"}],"output":{"name":"reprflags"}}],[11,"partial_cmp","","",785,{"inputs":[{"name":"self"},{"name":"reprflags"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",785,{"inputs":[{"name":"self"},{"name":"reprflags"}],"output":{"name":"bool"}}],[11,"le","","",785,{"inputs":[{"name":"self"},{"name":"reprflags"}],"output":{"name":"bool"}}],[11,"gt","","",785,{"inputs":[{"name":"self"},{"name":"reprflags"}],"output":{"name":"bool"}}],[11,"ge","","",785,{"inputs":[{"name":"self"},{"name":"reprflags"}],"output":{"name":"bool"}}],[11,"cmp","","",785,{"inputs":[{"name":"self"},{"name":"reprflags"}],"output":{"name":"ordering"}}],[11,"hash","","",785,null],[11,"encode","","",785,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",785,{"inputs":[{"name":"__d"}],"output":{"generics":["reprflags"],"name":"result"}}],[11,"default","","",785,{"inputs":[],"output":{"name":"reprflags"}}],[11,"fmt","","",785,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",785,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",785,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",785,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",785,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[18,"IS_C","","",785,null],[18,"IS_PACKED","","",785,null],[18,"IS_SIMD","","",785,null],[18,"IS_TRANSPARENT","","",785,null],[18,"IS_LINEAR","","",785,null],[18,"IS_UNOPTIMISABLE","","",785,null],[11,"empty","","Returns an empty set of flags.",785,{"inputs":[],"output":{"name":"reprflags"}}],[11,"all","","Returns the set containing all flags.",785,{"inputs":[],"output":{"name":"reprflags"}}],[11,"bits","","Returns the raw value of the flags currently stored.",785,{"inputs":[{"name":"self"}],"output":{"name":"u8"}}],[11,"from_bits","","Convert from underlying bit representation, unless that representation contains bits that do not correspond to a flag.",785,{"inputs":[{"name":"u8"}],"output":{"generics":["reprflags"],"name":"option"}}],[11,"from_bits_truncate","","Convert from underlying bit representation, dropping any bits that do not correspond to flags.",785,{"inputs":[{"name":"u8"}],"output":{"name":"reprflags"}}],[11,"is_empty","","Returns `true` if no flags are currently stored.",785,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_all","","Returns `true` if all flags are currently set.",785,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"intersects","","Returns `true` if there are flags common to both `self` and `other`.",785,{"inputs":[{"name":"self"},{"name":"reprflags"}],"output":{"name":"bool"}}],[11,"contains","","Returns `true` all of the flags in `other` are contained within `self`.",785,{"inputs":[{"name":"self"},{"name":"reprflags"}],"output":{"name":"bool"}}],[11,"insert","","Inserts the specified flags in-place.",785,{"inputs":[{"name":"self"},{"name":"reprflags"}],"output":null}],[11,"remove","","Removes the specified flags in-place.",785,{"inputs":[{"name":"self"},{"name":"reprflags"}],"output":null}],[11,"toggle","","Toggles the specified flags in-place.",785,{"inputs":[{"name":"self"},{"name":"reprflags"}],"output":null}],[11,"set","","Inserts or removes the specified flags depending on the passed value.",785,{"inputs":[{"name":"self"},{"name":"reprflags"},{"name":"bool"}],"output":null}],[11,"bitor","","Returns the union of the two sets of flags.",785,{"inputs":[{"name":"self"},{"name":"reprflags"}],"output":{"name":"reprflags"}}],[11,"bitor_assign","","Adds the set of flags.",785,{"inputs":[{"name":"self"},{"name":"reprflags"}],"output":null}],[11,"bitxor","","Returns the left flags, but with all the right flags toggled.",785,{"inputs":[{"name":"self"},{"name":"reprflags"}],"output":{"name":"reprflags"}}],[11,"bitxor_assign","","Toggles the set of flags.",785,{"inputs":[{"name":"self"},{"name":"reprflags"}],"output":null}],[11,"bitand","","Returns the intersection between the two sets of flags.",785,{"inputs":[{"name":"self"},{"name":"reprflags"}],"output":{"name":"reprflags"}}],[11,"bitand_assign","","Disables all flags disabled in the set.",785,{"inputs":[{"name":"self"},{"name":"reprflags"}],"output":null}],[11,"sub","","Returns the set difference of the two sets of flags.",785,{"inputs":[{"name":"self"},{"name":"reprflags"}],"output":{"name":"reprflags"}}],[11,"sub_assign","","Disables all flags enabled in the set.",785,{"inputs":[{"name":"self"},{"name":"reprflags"}],"output":null}],[11,"not","","Returns the complement of this set of flags.",785,{"inputs":[{"name":"self"}],"output":{"name":"reprflags"}}],[11,"extend","","",785,{"inputs":[{"name":"self"},{"name":"t"}],"output":null}],[11,"from_iter","","",785,{"inputs":[{"name":"t"}],"output":{"name":"reprflags"}}],[11,"hash_stable","","",785,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"clone","","",528,{"inputs":[{"name":"self"}],"output":{"name":"reproptions"}}],[11,"eq","","",528,{"inputs":[{"name":"self"},{"name":"reproptions"}],"output":{"name":"bool"}}],[11,"ne","","",528,{"inputs":[{"name":"self"},{"name":"reproptions"}],"output":{"name":"bool"}}],[11,"encode","","",528,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",528,{"inputs":[{"name":"__d"}],"output":{"generics":["reproptions"],"name":"result"}}],[11,"default","","",528,{"inputs":[],"output":{"name":"reproptions"}}],[11,"hash_stable","","",528,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"new","","",528,{"inputs":[{"name":"tyctxt"},{"name":"defid"}],"output":{"name":"reproptions"}}],[11,"simd","","",528,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"c","","",528,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"packed","","",528,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"transparent","","",528,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"linear","","",528,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"discr_type","","",528,{"inputs":[{"name":"self"}],"output":{"name":"inttype"}}],[11,"inhibit_enum_layout_opt","","Returns true if this `#[repr()]` should inhabit \"smart enum layout\" optimizations, such as representing `Foo<&T>` as a single pointer.",528,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_struct","","",527,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_union","","",527,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_enum","","",527,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_non_exhaustive","","",527,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"adt_kind","","Returns the kind of the ADT - Struct or Enum.",527,{"inputs":[{"name":"self"}],"output":{"name":"adtkind"}}],[11,"descr","","",527,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"variant_descr","","",527,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"is_fundamental","","Returns whether this type is #[fundamental] for the purposes of coherence checking.",527,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_phantom_data","","Returns true if this is PhantomData.",527,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_box","","Returns true if this is Box.",527,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"has_dtor","","Returns whether this type has a destructor.",527,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"bool"}}],[11,"non_enum_variant","","Asserts this is a struct or union and returns its unique variant.",527,{"inputs":[{"name":"self"}],"output":{"name":"variantdef"}}],[11,"predicates","","",527,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"genericpredicates"}}],[11,"all_fields","","Returns an iterator over all fields contained by this ADT.",527,null],[11,"is_payloadfree","","",527,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"variant_with_id","","",527,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"variantdef"}}],[11,"variant_index_with_id","","",527,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"usize"}}],[11,"variant_of_def","","",527,{"inputs":[{"name":"self"},{"name":"def"}],"output":{"name":"variantdef"}}],[11,"eval_explicit_discr","","",527,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"defid"}],"output":{"generics":["discr"],"name":"option"}}],[11,"discriminants","","",527,null],[11,"discriminant_for_variant","","Compute the discriminant value used by a specific variant. Unlike `discriminants`, this is (amortized) constant-time, only doing at most one query for evaluating an explicit discriminant (the last one before the requested variant), assuming there are no constant-evaluation errors there.",527,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"usize"}],"output":{"name":"discr"}}],[11,"discriminant_def_for_variant","","Yields a DefId for the discriminant and an offset to add to it Alternatively, if there is no explicit discriminant, returns the inferred discriminant directly",527,null],[11,"destructor","","",527,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"generics":["destructor"],"name":"option"}}],[11,"sized_constraint","","Returns a list of types such that `Self: Sized` if and only if that type is Sized, or `TyErr` if this type is recursive.",527,null],[11,"find_field_named","","",525,{"inputs":[{"name":"self"},{"name":"name"}],"output":{"generics":["fielddef"],"name":"option"}}],[11,"index_of_field_named","","",525,{"inputs":[{"name":"self"},{"name":"name"}],"output":{"generics":["usize"],"name":"option"}}],[11,"field_named","","",525,{"inputs":[{"name":"self"},{"name":"name"}],"output":{"name":"fielddef"}}],[11,"ty","","",526,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"substs"}],"output":{"name":"ty"}}],[11,"clone","","",547,{"inputs":[{"name":"self"}],"output":{"name":"closurekind"}}],[11,"partial_cmp","","",547,{"inputs":[{"name":"self"},{"name":"closurekind"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"cmp","","",547,{"inputs":[{"name":"self"},{"name":"closurekind"}],"output":{"name":"ordering"}}],[11,"eq","","",547,{"inputs":[{"name":"self"},{"name":"closurekind"}],"output":{"name":"bool"}}],[11,"hash","","",547,null],[11,"fmt","","",547,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",547,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",547,{"inputs":[{"name":"__d"}],"output":{"generics":["closurekind"],"name":"result"}}],[18,"LATTICE_BOTTOM","","",547,null],[11,"trait_did","","",547,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"defid"}}],[11,"extends","","True if this a type that impls this closure kind must also implement `other`.",547,{"inputs":[{"name":"self"},{"name":"closurekind"}],"output":{"name":"bool"}}],[11,"to_ty","","Returns the representative scalar type for this closure kind. See `TyS::to_opt_closure_kind` for more details.",547,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"ty"}}],[11,"walk","","Iterator that walks `self` and any types reachable from `self`, in depth-first order. Note that just walks the types that appear in `self`, it does not descend into the fields of structs or variants. For example:",508,{"inputs":[{"name":"self"}],"output":{"name":"typewalker"}}],[11,"walk_shallow","","Iterator that walks the immediate children of `self`.  Hence `Foo<Bar<i32>, u32>` yields the sequence `[Bar<i32>, u32]` (but not `i32`, like `walk`).",508,{"inputs":[{"name":"self"}],"output":{"generics":["typewalkerarray"],"name":"accintoiter"}}],[11,"maybe_walk","","Walks `ty` and any types appearing within `ty`, invoking the callback `f` on each type. If the callback returns false, then the children of the current type are ignored.",508,{"inputs":[{"name":"self"},{"name":"f"}],"output":null}],[11,"from_mutbl","","",541,{"inputs":[{"name":"mutability"}],"output":{"name":"borrowkind"}}],[11,"to_mutbl_lossy","","Returns a mutability `m` such that an `&m T` pointer could be used to obtain this borrow kind. Because borrow kinds are richer than mutabilities, we sometimes have to pick a mutability that is stronger than necessary so that it at least would permit the borrow in question.",541,{"inputs":[{"name":"self"}],"output":{"name":"mutability"}}],[11,"to_user_str","","",541,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"fmt","","",548,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",548,{"inputs":[{"name":"self"}],"output":{"name":"attributes"}}],[11,"deref","","",548,null],[11,"body_tables","","",566,{"inputs":[{"name":"self"},{"name":"bodyid"}],"output":{"name":"typecktables"}}],[11,"body_owners","","Returns an iterator of the def-ids for all body-owners in this crate. If you would prefer to iterate over the bodies themselves, you can do `self.hir.krate().body_ids.iter()`.",566,null],[11,"expr_span","","",566,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"span"}}],[11,"provided_trait_methods","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["associateditem"],"name":"vec"}}],[11,"trait_relevant_for_never","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"bool"}}],[11,"opt_associated_item","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["associateditem"],"name":"option"}}],[11,"associated_items","","",566,null],[11,"impls_are_allowed_to_overlap","","Returns true if the impls are the same polarity and are implementing a trait which contains no items",566,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"defid"}],"output":{"name":"bool"}}],[11,"expect_variant_def","","",566,{"inputs":[{"name":"self"},{"name":"def"}],"output":{"name":"variantdef"}}],[11,"adt_def_id_of_variant","","Given a `VariantDef`, returns the def-id of the `AdtDef` of which it is a part.",566,{"inputs":[{"name":"self"},{"name":"variantdef"}],"output":{"name":"defid"}}],[11,"item_name","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"internedstring"}}],[11,"instance_mir","","Return the possibly-auto-generated MIR of a (DefId, Subst) pair.",566,{"inputs":[{"name":"self"},{"name":"instancedef"}],"output":{"name":"mir"}}],[11,"maybe_optimized_mir","","Given the DefId of an item, returns its MIR, borrowed immutably. Returns None if there is no MIR for the DefId",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["mir"],"name":"option"}}],[11,"get_attrs","","Get the attributes of a definition.",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"attributes"}}],[11,"has_attr","","Determine whether an item is annotated with an attribute",566,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"str"}],"output":{"name":"bool"}}],[11,"trait_is_auto","","Returns true if this is an `auto trait`.",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"bool"}}],[11,"generator_layout","","",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"generatorlayout"}}],[11,"trait_id_of_impl","","Given the def_id of an impl, return the def_id of the trait it implements. If it implements no trait, return `None`.",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["defid"],"name":"option"}}],[11,"impl_of_method","","If the given def ID describes a method belonging to an impl, return the ID of the impl that the method belongs to. Otherwise, return `None`.",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["defid"],"name":"option"}}],[11,"span_of_impl","","Looks up the span of `impl_did` if the impl is local; otherwise returns `Err` with the name of the crate containing the impl.",566,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["span","symbol"],"name":"result"}}],[11,"hygienic_eq","","",566,{"inputs":[{"name":"self"},{"name":"name"},{"name":"name"},{"name":"defid"}],"output":{"name":"bool"}}],[11,"adjust","","",566,null],[11,"adjust_ident","","",566,null],[11,"with_freevars","","",566,{"inputs":[{"name":"self"},{"name":"nodeid"},{"name":"f"}],"output":{"name":"t"}}],[11,"clone","","",529,{"inputs":[{"name":"self"}],"output":{"name":"crateinherentimpls"}}],[11,"fmt","","",529,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",530,{"inputs":[{"name":"self"}],"output":{"name":"symbolname"}}],[11,"eq","","",530,{"inputs":[{"name":"self"},{"name":"symbolname"}],"output":{"name":"bool"}}],[11,"ne","","",530,{"inputs":[{"name":"self"},{"name":"symbolname"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",530,{"inputs":[{"name":"self"},{"name":"symbolname"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",530,{"inputs":[{"name":"self"},{"name":"symbolname"}],"output":{"name":"bool"}}],[11,"le","","",530,{"inputs":[{"name":"self"},{"name":"symbolname"}],"output":{"name":"bool"}}],[11,"gt","","",530,{"inputs":[{"name":"self"},{"name":"symbolname"}],"output":{"name":"bool"}}],[11,"ge","","",530,{"inputs":[{"name":"self"},{"name":"symbolname"}],"output":{"name":"bool"}}],[11,"cmp","","",530,{"inputs":[{"name":"self"},{"name":"symbolname"}],"output":{"name":"ordering"}}],[11,"encode","","",530,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",530,{"inputs":[{"name":"__d"}],"output":{"generics":["symbolname"],"name":"result"}}],[11,"hash_stable","","",530,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"new","","",530,{"inputs":[{"name":"str"}],"output":{"name":"symbolname"}}],[11,"deref","","",530,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"fmt","","",530,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",530,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[0,"util","rustc","",null,null],[0,"captures","rustc::util","",null,null],[8,"Captures","rustc::util::captures","\"Signaling\" trait used in impl trait to tag lifetimes that you may need to capture but don't really need for other reasons. Basically a workaround; see [this comment] for details.",null,null],[0,"common","rustc::util","",null,null],[3,"ErrorReported","rustc::util::common","",null,null],[3,"ProfQDumpParams","","Parameters to the `Dump` variant of type `ProfileQueriesMsg`.",null,null],[12,"path","","A base path for the files we will dump",786,null],[12,"ack","","To ensure that the compiler waits for us to finish our dumps",786,null],[12,"dump_profq_msg_log","","toggle dumping a log file with every `ProfileQueriesMsg`",786,null],[3,"Indenter","","",null,null],[4,"ProfileQueriesMsg","","A sequence of these messages induce a trace of query-based incremental compilation. FIXME(matthewhammer): Determine whether we should include cycle detection here or not.",null,null],[13,"TimeBegin","","begin a timed pass",787,null],[13,"TimeEnd","","end a timed pass",787,null],[13,"TaskBegin","","begin a task (see dep_graph::graph::with_task)",787,null],[13,"TaskEnd","","end a task",787,null],[13,"QueryBegin","","begin a new query can't use `Span` because queries are sent to other thread",787,null],[13,"CacheHit","","query is satisfied by using an already-known value for the given key",787,null],[13,"ProviderBegin","","query requires running a provider; providers may nest, permitting queries to nest.",787,null],[13,"ProviderEnd","","query is satisfied by a provider terminating with a value",787,null],[13,"Dump","","dump a record of the queries to the given path",787,null],[13,"Halt","","halt the profiling/monitoring background thread",787,null],[5,"install_panic_hook","","",null,{"inputs":[],"output":null}],[5,"profq_msg","","If enabled, send a message to the profile-queries thread",null,{"inputs":[{"name":"session"},{"name":"profilequeriesmsg"}],"output":null}],[5,"profq_set_chan","","Set channel for profile queries channel",null,{"inputs":[{"name":"session"},{"generics":["profilequeriesmsg"],"name":"sender"}],"output":{"name":"bool"}}],[5,"time_depth","","Read the current depth of `time()` calls. This is used to encourage indentation across threads.",null,{"inputs":[],"output":{"name":"usize"}}],[5,"set_time_depth","","Set the current depth of `time()` calls. The idea is to call `set_time_depth()` with the result from `time_depth()` in the parent thread.",null,{"inputs":[{"name":"usize"}],"output":null}],[5,"time","","",null,{"inputs":[{"name":"session"},{"name":"str"},{"name":"f"}],"output":{"name":"t"}}],[5,"time_ext","","",null,{"inputs":[{"name":"bool"},{"generics":["session"],"name":"option"},{"name":"str"},{"name":"f"}],"output":{"name":"t"}}],[5,"print_time_passes_entry","","",null,{"inputs":[{"name":"bool"},{"name":"str"},{"name":"duration"}],"output":null}],[5,"duration_to_secs_str","","",null,{"inputs":[{"name":"duration"}],"output":{"name":"string"}}],[5,"to_readable_str","","",null,{"inputs":[{"name":"usize"}],"output":{"name":"string"}}],[5,"record_time","","",null,{"inputs":[{"name":"cell"},{"name":"f"}],"output":{"name":"t"}}],[5,"indent","","",null,{"inputs":[{"name":"f"}],"output":{"name":"r"}}],[5,"indenter","","",null,{"inputs":[],"output":{"name":"indenter"}}],[5,"path2cstr","","",null,{"inputs":[{"name":"path"}],"output":{"name":"cstring"}}],[17,"FN_OUTPUT_NAME","","",null,null],[8,"MemoizationMap","","",null,null],[16,"Key","","",788,null],[16,"Value","","",788,null],[10,"memoize","","If `key` is present in the map, return the value, otherwise invoke `op` and store the value in the map.",788,null],[8,"CellUsizeExt","","",null,null],[10,"increment","","",789,{"inputs":[{"name":"self"}],"output":null}],[11,"clone","","",790,{"inputs":[{"name":"self"}],"output":{"name":"errorreported"}}],[11,"fmt","","",790,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",790,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",790,{"inputs":[{"name":"__d"}],"output":{"generics":["errorreported"],"name":"result"}}],[11,"clone","","",786,{"inputs":[{"name":"self"}],"output":{"name":"profqdumpparams"}}],[11,"fmt","","",786,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",787,{"inputs":[{"name":"self"}],"output":{"name":"profilequeriesmsg"}}],[11,"fmt","","",787,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"drop","","",791,{"inputs":[{"name":"self"}],"output":null}],[0,"ppaux","rustc::util","",null,null],[3,"PrintContext","rustc::util::ppaux","",null,null],[5,"verbose","","",null,{"inputs":[],"output":{"name":"bool"}}],[5,"identify_regions","","",null,{"inputs":[],"output":{"name":"bool"}}],[5,"parameterized","","",null,null],[8,"Print","","",null,null],[10,"print","","",792,{"inputs":[{"name":"self"},{"name":"f"},{"name":"printcontext"}],"output":{"name":"result"}}],[11,"print_to_string","","",792,{"inputs":[{"name":"self"},{"name":"printcontext"}],"output":{"name":"string"}}],[11,"print_display","","",792,{"inputs":[{"name":"self"},{"name":"f"},{"name":"printcontext"}],"output":{"name":"result"}}],[11,"print_display_to_string","","",792,{"inputs":[{"name":"self"},{"name":"printcontext"}],"output":{"name":"string"}}],[11,"print_debug","","",792,{"inputs":[{"name":"self"},{"name":"f"},{"name":"printcontext"}],"output":{"name":"result"}}],[11,"print_debug_to_string","","",792,{"inputs":[{"name":"self"},{"name":"printcontext"}],"output":{"name":"string"}}],[11,"fmt","","",793,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","rustc::ty","",513,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",514,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","rustc::ty::trait_def","",759,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","rustc::ty","",527,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",511,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",509,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",510,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"print","","",487,{"inputs":[{"name":"self"},{"name":"f"},{"name":"printcontext"}],"output":{"name":"result"}}],[11,"fmt","","",487,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"print","","",489,{"inputs":[{"name":"self"},{"name":"f"},{"name":"printcontext"}],"output":{"name":"result"}}],[11,"fmt","","",489,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"print","rustc::ty::adjustment","",549,{"inputs":[{"name":"self"},{"name":"f"},{"name":"printcontext"}],"output":{"name":"result"}}],[11,"fmt","","",549,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"print","rustc::ty","",534,{"inputs":[{"name":"self"},{"name":"f"},{"name":"printcontext"}],"output":{"name":"result"}}],[11,"fmt","","",534,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",534,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"print","","",535,{"inputs":[{"name":"self"},{"name":"f"},{"name":"printcontext"}],"output":{"name":"result"}}],[11,"fmt","","",535,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",535,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"print","","",493,{"inputs":[{"name":"self"},{"name":"f"},{"name":"printcontext"}],"output":{"name":"result"}}],[11,"fmt","","",493,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"print","","",540,{"inputs":[{"name":"self"},{"name":"f"},{"name":"printcontext"}],"output":{"name":"result"}}],[11,"fmt","","",540,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"print","","",516,{"inputs":[{"name":"self"},{"name":"f"},{"name":"printcontext"}],"output":{"name":"result"}}],[11,"fmt","","",516,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"print","","",521,{"inputs":[{"name":"self"},{"name":"f"},{"name":"printcontext"}],"output":{"name":"result"}}],[11,"fmt","","",521,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"print","","",481,{"inputs":[{"name":"self"},{"name":"f"},{"name":"printcontext"}],"output":{"name":"result"}}],[11,"fmt","","",481,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",481,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",494,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",495,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",496,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",497,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"print","","",531,{"inputs":[{"name":"self"},{"name":"f"},{"name":"printcontext"}],"output":{"name":"result"}}],[11,"fmt","","",531,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",531,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",543,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",512,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"print","","",479,{"inputs":[{"name":"self"},{"name":"f"},{"name":"printcontext"}],"output":{"name":"result"}}],[11,"fmt","","",479,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"print","","",479,{"inputs":[{"name":"self"},{"name":"f"},{"name":"printcontext"}],"output":{"name":"result"}}],[11,"fmt","","",479,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"print","","",479,{"inputs":[{"name":"self"},{"name":"f"},{"name":"printcontext"}],"output":{"name":"result"}}],[11,"fmt","","",479,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"print","","",479,{"inputs":[{"name":"self"},{"name":"f"},{"name":"printcontext"}],"output":{"name":"result"}}],[11,"fmt","","",479,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"print","","",479,{"inputs":[{"name":"self"},{"name":"f"},{"name":"printcontext"}],"output":{"name":"result"}}],[11,"fmt","","",479,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"print","","",479,{"inputs":[{"name":"self"},{"name":"f"},{"name":"printcontext"}],"output":{"name":"result"}}],[11,"fmt","","",479,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"print","","",479,{"inputs":[{"name":"self"},{"name":"f"},{"name":"printcontext"}],"output":{"name":"result"}}],[11,"fmt","","",479,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"print","","",479,{"inputs":[{"name":"self"},{"name":"f"},{"name":"printcontext"}],"output":{"name":"result"}}],[11,"fmt","","",479,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"print","","",488,{"inputs":[{"name":"self"},{"name":"f"},{"name":"printcontext"}],"output":{"name":"result"}}],[11,"fmt","","",488,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",488,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"print","","",486,{"inputs":[{"name":"self"},{"name":"f"},{"name":"printcontext"}],"output":{"name":"result"}}],[11,"fmt","","",486,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"print","","",533,{"inputs":[{"name":"self"},{"name":"f"},{"name":"printcontext"}],"output":{"name":"result"}}],[11,"fmt","","",533,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"print","","",508,{"inputs":[{"name":"self"},{"name":"f"},{"name":"printcontext"}],"output":{"name":"result"}}],[11,"fmt","","",508,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",508,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"print","","",483,{"inputs":[{"name":"self"},{"name":"f"},{"name":"printcontext"}],"output":{"name":"result"}}],[11,"fmt","","",483,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",483,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"print","","",518,{"inputs":[{"name":"self"},{"name":"f"},{"name":"printcontext"}],"output":{"name":"result"}}],[11,"fmt","","",518,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"print","","",519,{"inputs":[{"name":"self"},{"name":"f"},{"name":"printcontext"}],"output":{"name":"result"}}],[11,"fmt","","",519,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"print","","",517,{"inputs":[{"name":"self"},{"name":"f"},{"name":"printcontext"}],"output":{"name":"result"}}],[11,"fmt","","",517,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",517,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"print","","",520,{"inputs":[{"name":"self"},{"name":"f"},{"name":"printcontext"}],"output":{"name":"result"}}],[11,"fmt","","",520,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",520,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"print","","",484,{"inputs":[{"name":"self"},{"name":"f"},{"name":"printcontext"}],"output":{"name":"result"}}],[11,"fmt","","",484,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"print","","",547,{"inputs":[{"name":"self"},{"name":"f"},{"name":"printcontext"}],"output":{"name":"result"}}],[11,"fmt","","",547,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"print","","",544,{"inputs":[{"name":"self"},{"name":"f"},{"name":"printcontext"}],"output":{"name":"result"}}],[11,"fmt","","",544,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",544,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[0,"nodemap","rustc::util","An efficient hash map for node IDs",null,null],[6,"FxHashMap","rustc::util::nodemap","",null,null],[6,"FxHashSet","","",null,null],[5,"NodeMap","","",null,{"inputs":[],"output":{"name":"nodemap"}}],[5,"DefIdMap","","",null,{"inputs":[],"output":{"name":"defidmap"}}],[5,"ItemLocalMap","","",null,{"inputs":[],"output":{"name":"itemlocalmap"}}],[5,"NodeSet","","",null,{"inputs":[],"output":{"name":"nodeset"}}],[5,"DefIdSet","","",null,{"inputs":[],"output":{"name":"defidset"}}],[5,"ItemLocalSet","","",null,{"inputs":[],"output":{"name":"itemlocalset"}}],[6,"NodeMap","","",null,null],[6,"DefIdMap","","",null,null],[6,"HirIdMap","","",null,null],[6,"ItemLocalMap","","",null,null],[6,"NodeSet","","",null,null],[6,"DefIdSet","","",null,null],[6,"HirIdSet","","",null,null],[6,"ItemLocalSet","","",null,null],[0,"fs","rustc::util","",null,null],[4,"LinkOrCopy","rustc::util::fs","",null,null],[13,"Link","","",794,null],[13,"Copy","","",794,null],[4,"RenameOrCopyRemove","","",null,null],[13,"Rename","","",795,null],[13,"CopyRemove","","",795,null],[5,"fix_windows_verbatim_for_gcc","","",null,{"inputs":[{"name":"path"}],"output":{"name":"pathbuf"}}],[5,"link_or_copy","","Copy `p` into `q`, preferring to use hard-linking if possible. If `q` already exists, it is removed first. The result indicates which of the two operations has been performed.",null,{"inputs":[{"name":"p"},{"name":"q"}],"output":{"generics":["linkorcopy"],"name":"result"}}],[5,"rename_or_copy_remove","","Rename `p` into `q`, preferring to use `rename` if possible. If `rename` fails (rename may fail for reasons such as crossing filesystem), fallback to copy & remove",null,{"inputs":[{"name":"p"},{"name":"q"}],"output":{"generics":["renameorcopyremove"],"name":"result"}}],[11,"fmt","","",795,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[17,"DIAGNOSTICS","rustc","",null,null],[14,"bug","","",null,null],[14,"span_bug","","",null,null],[14,"__impl_stable_hash_field","","",null,null],[14,"impl_stable_hash_for","","",null,null],[14,"impl_stable_hash_for_spanned","","",null,null],[14,"CloneLiftImpls","","",null,null],[14,"CloneTypeFoldableImpls","","Used for types that are `Copy` and which do not care arena allocated data (i.e., don't need to be folded).",null,null],[14,"CloneTypeFoldableAndLiftImpls","","",null,null],[14,"BraceStructLiftImpl","","",null,null],[14,"EnumLiftImpl","","",null,null],[14,"BraceStructTypeFoldableImpl","","",null,null],[14,"TupleStructTypeFoldableImpl","","",null,null],[14,"EnumTypeFoldableImpl","","",null,null],[14,"declare_lint","","Declare a static item of type `&'static Lint`.",null,null],[14,"lint_array","","Declare a static `LintArray` and return it as an expression.",null,null],[14,"err","","",null,null],[14,"__impl_decoder_methods","","",null,null],[14,"implement_ty_decoder","","",null,null],[11,"to_dep_node","rustc::hir::map::definitions","",152,{"inputs":[{"name":"self"},{"name":"depkind"}],"output":{"name":"depnode"}}],[11,"to_dep_node","rustc::hir::def_id","",127,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"depkind"}],"output":{"name":"depnode"}}],[11,"print_node","rustc::hir::print","",160,{"inputs":[{"name":"self"},{"name":"node"}],"output":{"name":"result"}}],[11,"get_stable_hashing_context","rustc::ty","",566,{"inputs":[{"name":"self"}],"output":{"name":"stablehashingcontext"}}],[11,"hash_stable","rustc::middle::cstore","",261,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",264,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",255,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",256,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",263,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",257,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",254,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",260,{"inputs":[{"name":"self"},{"name":"hcx"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",259,{"inputs":[{"name":"self"},{"name":"hcx"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","rustc::middle::lang_items","",280,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",279,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","rustc::mir","",329,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",315,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",334,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",336,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",316,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",317,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",318,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",327,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",328,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",335,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",351,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",319,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",333,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",384,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",385,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",386,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",387,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",388,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",337,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",338,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",320,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",339,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",321,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",340,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",341,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",323,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",342,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",324,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",314,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",332,{"inputs":[{"name":"self"},{"name":"stablehashing