var searchIndex = {};
searchIndex["arena"] = {"doc":"The arena, a fast but limited type of allocator.","items":[[3,"TypedArena","arena","An arena that can hold objects of only one type.",null,null],[12,"ptr","","A pointer to the next object to be allocated.",0,null],[12,"end","","A pointer to the end of the allocated area. When this pointer is reached, a new chunk is allocated.",0,null],[12,"chunks","","A vector of arena chunks.",0,null],[12,"_own","","Marker indicating that dropping the arena causes its owned instances of `T` to be dropped.",0,null],[3,"TypedArenaChunk","","",null,null],[12,"storage","","The raw storage for the arena chunk.",1,null],[3,"DroplessArena","","",null,null],[12,"ptr","","A pointer to the next object to be allocated.",2,null],[12,"end","","A pointer to the end of the allocated area. When this pointer is reached, a new chunk is allocated.",2,null],[12,"chunks","","A vector of arena chunks.",2,null],[3,"SyncTypedArena","","",null,null],[12,"lock","","",3,null],[3,"SyncDroplessArena","","",null,null],[12,"lock","","",4,null],[17,"PAGE","","",null,null],[11,"new","","",1,{"inputs":[{"name":"usize"}],"output":{"name":"typedarenachunk"}}],[11,"destroy","","Destroys this arena chunk.",1,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"start","","",1,null],[11,"end","","",1,null],[11,"new","","Creates a new `TypedArena`.",0,{"inputs":[],"output":{"name":"typedarena"}}],[11,"alloc","","Allocates an object in the `TypedArena`, returning a reference to it.",0,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"t"}}],[11,"alloc_slice","","Allocates a slice of objects that are copied into the `TypedArena`, returning a mutable reference to it. Will panic if passed a zero-sized types.",0,null],[11,"grow","","Grows the arena.",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"clear","","Clears the arena. Deallocates all but the longest chunk which may be reused.",0,{"inputs":[{"name":"self"}],"output":null}],[11,"clear_last_chunk","","",0,{"inputs":[{"name":"self"},{"name":"typedarenachunk"}],"output":null}],[11,"drop","","",0,{"inputs":[{"name":"self"}],"output":null}],[11,"new","","",2,{"inputs":[],"output":{"name":"droplessarena"}}],[11,"in_arena","","",2,null],[11,"align_for","","",2,{"inputs":[{"name":"self"}],"output":null}],[11,"grow","","",2,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"alloc","","",2,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"t"}}],[11,"alloc_slice","","Allocates a slice of objects that are copied into the `DroplessArena`, returning a mutable reference to it. Will panic if passed a zero-sized type.",2,null],[11,"new","","",3,{"inputs":[],"output":{"name":"synctypedarena"}}],[11,"alloc","","",3,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"t"}}],[11,"alloc_slice","","",3,null],[11,"clear","","",3,{"inputs":[{"name":"self"}],"output":null}],[11,"new","","",4,{"inputs":[],"output":{"name":"syncdroplessarena"}}],[11,"in_arena","","",4,null],[11,"alloc","","",4,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"t"}}],[11,"alloc_slice","","",4,null]],"paths":[[3,"TypedArena"],[3,"TypedArenaChunk"],[3,"DroplessArena"],[3,"SyncTypedArena"],[3,"SyncDroplessArena"]]};
searchIndex["fmt_macros"] = {"doc":"Macro support for format strings","items":[[3,"Argument","fmt_macros","Representation of an argument specification.",null,null],[12,"position","","Where to find this argument",0,null],[12,"format","","How to format the argument",0,null],[3,"FormatSpec","","Specification for the formatting of an argument in the format string.",null,null],[12,"fill","","Optionally specified character to fill alignment with",1,null],[12,"align","","Optionally specified alignment",1,null],[12,"flags","","Packed version of various flags provided",1,null],[12,"precision","","The integer precision to use",1,null],[12,"width","","The string width requested for the resulting format",1,null],[12,"ty","","The descriptor string representing the name of the format desired for this argument, this can be empty or any number of characters, although it is required to be one word.",1,null],[3,"Parser","","The parser structure for interpreting the input format string. This is modeled as an iterator over `Piece` structures to form a stream of tokens being output.",null,null],[12,"input","","",2,null],[12,"cur","","",2,null],[12,"errors","","Error messages accumulated during parsing",2,null],[12,"curarg","","Current position of implicit positional argument pointer",2,null],[4,"Piece","","A piece is a portion of the format string which represents the next part to emit. These are emitted as a stream by the `Parser` class.",null,null],[13,"String","","A literal string which should directly be emitted",3,null],[13,"NextArgument","","This describes that formatting should process the next argument (as specified inside) for emission.",3,null],[4,"Position","","Enum describing where an argument for a format can be located.",null,null],[13,"ArgumentImplicitlyIs","","The argument is implied to be located at an index",4,null],[13,"ArgumentIs","","The argument is located at a specific index given in the format",4,null],[13,"ArgumentNamed","","The argument has a name.",4,null],[4,"Alignment","","Enum of alignments which are supported.",null,null],[13,"AlignLeft","","The value will be aligned to the left.",5,null],[13,"AlignRight","","The value will be aligned to the right.",5,null],[13,"AlignCenter","","The value will be aligned in the center.",5,null],[13,"AlignUnknown","","The value will take on a default alignment.",5,null],[4,"Flag","","Various flags which can be applied to format strings. The meaning of these flags is defined by the formatters themselves.",null,null],[13,"FlagSignPlus","","A `+` will be used to denote positive numbers.",6,null],[13,"FlagSignMinus","","A `-` will be used to denote negative numbers. This is the default.",6,null],[13,"FlagAlternate","","An alternate form will be used for the value. In the case of numbers, this means that the number will be prefixed with the supplied string.",6,null],[13,"FlagSignAwareZeroPad","","For numbers, this means that the number will be padded with zeroes, and the sign (`+` or `-`) will precede them.",6,null],[13,"FlagDebugLowerHex","","For Debug / `?`, format integers in lower-case hexadecimal.",6,null],[13,"FlagDebugUpperHex","","For Debug / `?`, format integers in upper-case hexadecimal.",6,null],[4,"Count","","A count is used for the precision and width parameters of an integer, and can reference either an argument or a literal integer.",null,null],[13,"CountIs","","The count is specified explicitly.",7,null],[13,"CountIsName","","The count is specified by the argument with the given name.",7,null],[13,"CountIsParam","","The count is specified by the argument at the given index.",7,null],[13,"CountImplied","","The count is implied and cannot be explicitly specified.",7,null],[11,"clone","","",3,{"inputs":[{"name":"self"}],"output":{"name":"piece"}}],[11,"eq","","",3,{"inputs":[{"name":"self"},{"name":"piece"}],"output":{"name":"bool"}}],[11,"ne","","",3,{"inputs":[{"name":"self"},{"name":"piece"}],"output":{"name":"bool"}}],[11,"clone","","",0,{"inputs":[{"name":"self"}],"output":{"name":"argument"}}],[11,"eq","","",0,{"inputs":[{"name":"self"},{"name":"argument"}],"output":{"name":"bool"}}],[11,"ne","","",0,{"inputs":[{"name":"self"},{"name":"argument"}],"output":{"name":"bool"}}],[11,"clone","","",1,{"inputs":[{"name":"self"}],"output":{"name":"formatspec"}}],[11,"eq","","",1,{"inputs":[{"name":"self"},{"name":"formatspec"}],"output":{"name":"bool"}}],[11,"ne","","",1,{"inputs":[{"name":"self"},{"name":"formatspec"}],"output":{"name":"bool"}}],[11,"clone","","",4,{"inputs":[{"name":"self"}],"output":{"name":"position"}}],[11,"eq","","",4,{"inputs":[{"name":"self"},{"name":"position"}],"output":{"name":"bool"}}],[11,"ne","","",4,{"inputs":[{"name":"self"},{"name":"position"}],"output":{"name":"bool"}}],[11,"clone","","",5,{"inputs":[{"name":"self"}],"output":{"name":"alignment"}}],[11,"eq","","",5,{"inputs":[{"name":"self"},{"name":"alignment"}],"output":{"name":"bool"}}],[11,"clone","","",6,{"inputs":[{"name":"self"}],"output":{"name":"flag"}}],[11,"eq","","",6,{"inputs":[{"name":"self"},{"name":"flag"}],"output":{"name":"bool"}}],[11,"clone","","",7,{"inputs":[{"name":"self"}],"output":{"name":"count"}}],[11,"eq","","",7,{"inputs":[{"name":"self"},{"name":"count"}],"output":{"name":"bool"}}],[11,"ne","","",7,{"inputs":[{"name":"self"},{"name":"count"}],"output":{"name":"bool"}}],[11,"next","","",2,{"inputs":[{"name":"self"}],"output":{"generics":["piece"],"name":"option"}}],[11,"new","","Creates a new parser for the given format string",2,{"inputs":[{"name":"str"}],"output":{"name":"parser"}}],[11,"err","","Notifies of an error. The message doesn't actually need to be of type String, but I think it does when this eventually uses conditions so it might as well start using it now.",2,{"inputs":[{"name":"self"},{"name":"str"}],"output":null}],[11,"err_with_note","","Notifies of an error. The message doesn't actually need to be of type String, but I think it does when this eventually uses conditions so it might as well start using it now.",2,{"inputs":[{"name":"self"},{"name":"str"},{"name":"str"}],"output":null}],[11,"consume","","Optionally consumes the specified character. If the character is not at the current position, then the current iterator isn't moved and false is returned, otherwise the character is consumed and true is returned.",2,{"inputs":[{"name":"self"},{"name":"char"}],"output":{"name":"bool"}}],[11,"must_consume","","Forces consumption of the specified character. If the character is not found, an error is emitted.",2,{"inputs":[{"name":"self"},{"name":"char"}],"output":null}],[11,"ws","","Consumes all whitespace characters until the first non-whitespace character",2,{"inputs":[{"name":"self"}],"output":null}],[11,"string","","Parses all of a string which is to be considered a \"raw literal\" in a format string. This is everything outside of the braces.",2,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"str"}}],[11,"argument","","Parses an Argument structure, or what's contained within braces inside the format string",2,{"inputs":[{"name":"self"}],"output":{"name":"argument"}}],[11,"position","","Parses a positional argument for a format. This could either be an integer index of an argument, a named argument, or a blank string. Returns `Some(parsed_position)` if the position is not implicitly consuming a macro argument, `None` if it's the case.",2,{"inputs":[{"name":"self"}],"output":{"generics":["position"],"name":"option"}}],[11,"format","","Parses a format specifier at the current position, returning all of the relevant information in the FormatSpec struct.",2,{"inputs":[{"name":"self"}],"output":{"name":"formatspec"}}],[11,"count","","Parses a Count parameter at the current position. This does not check for 'CountIsNextParam' because that is only used in precision, not width.",2,{"inputs":[{"name":"self"}],"output":{"name":"count"}}],[11,"word","","Parses a word starting at the current position. A word is considered to be an alphabetic character followed by any number of alphanumeric characters.",2,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"integer","","Optionally parses an integer at the current position. This doesn't deal with overflow at all, it's just accumulating digits.",2,{"inputs":[{"name":"self"}],"output":{"generics":["usize"],"name":"option"}}]],"paths":[[3,"Argument"],[3,"FormatSpec"],[3,"Parser"],[4,"Piece"],[4,"Position"],[4,"Alignment"],[4,"Flag"],[4,"Count"]]};
searchIndex["graphviz"] = {"doc":"Generate files suitable for use with Graphviz","items":[[3,"Id","graphviz","`Id` is a Graphviz `ID`.",null,null],[12,"name","","",0,null],[4,"LabelText","","The text for a graphviz label on a node or edge.",null,null],[13,"LabelStr","","This kind of label preserves the text directly as is.",1,null],[13,"EscStr","","This kind of label uses the graphviz label escString type: http://www.graphviz.org/content/attrs#kescString",1,null],[13,"HtmlStr","","This uses a graphviz [HTML string label][html]. The string is printed exactly as given, but between `<` and `>`. No escaping is performed.",1,null],[4,"Style","","The style for a node or edge. See http://www.graphviz.org/doc/info/attrs.html#k:style for descriptions. Note that some of these are not valid for edges.",null,null],[13,"None","","",2,null],[13,"Solid","","",2,null],[13,"Dashed","","",2,null],[13,"Dotted","","",2,null],[13,"Bold","","",2,null],[13,"Rounded","","",2,null],[13,"Diagonals","","",2,null],[13,"Filled","","",2,null],[13,"Striped","","",2,null],[13,"Wedged","","",2,null],[4,"RenderOption","","",null,null],[13,"NoEdgeLabels","","",3,null],[13,"NoNodeLabels","","",3,null],[13,"NoEdgeStyles","","",3,null],[13,"NoNodeStyles","","",3,null],[5,"escape_html","","Escape tags in such a way that it is suitable for inclusion in a Graphviz HTML label.",null,{"inputs":[{"name":"str"}],"output":{"name":"string"}}],[5,"default_options","","Returns vec holding all the default render options.",null,{"inputs":[],"output":{"generics":["renderoption"],"name":"vec"}}],[5,"render","","Renders directed graph `g` into the writer `w` in DOT syntax. (Simple wrapper around `render_opts` that passes a default set of options.)",null,{"inputs":[{"name":"g"},{"name":"w"}],"output":{"name":"result"}}],[5,"render_opts","","Renders directed graph `g` into the writer `w` in DOT syntax. (Main entry point for the library.)",null,null],[6,"Nodes","","",null,null],[6,"Edges","","",null,null],[8,"Labeller","","Each instance of a type that implements `Label<C>` maps to a unique identifier with respect to `C`, which is used to identify it in the generated .dot file. They can also provide more elaborate (and non-unique) label text that is used in the graphviz rendered output. The graph instance is responsible for providing the DOT compatible identifiers for the nodes and (optionally) rendered labels for the nodes and edges, as well as an identifier for the graph itself.",null,null],[16,"Node","","",4,null],[16,"Edge","","",4,null],[10,"graph_id","","Must return a DOT compatible identifier naming the graph.",4,{"inputs":[{"name":"self"}],"output":{"name":"id"}}],[10,"node_id","","Maps `n` to a unique identifier with respect to `self`. The implementor is responsible for ensuring that the returned name is a valid DOT identifier.",4,null],[11,"node_shape","","Maps `n` to one of the [graphviz `shape` names][1]. If `None` is returned, no `shape` attribute is specified.",4,null],[11,"node_label","","Maps `n` to a label that will be used in the rendered output. The label need not be unique, and may be the empty string; the default is just the output from `node_id`.",4,null],[11,"edge_label","","Maps `e` to a label that will be used in the rendered output. The label need not be unique, and may be the empty string; the default is in fact the empty string.",4,null],[11,"node_style","","Maps `n` to a style that will be used in the rendered output.",4,null],[11,"edge_style","","Maps `e` to a style that will be used in the rendered output.",4,null],[8,"GraphWalk","","GraphWalk is an abstraction over a directed graph = (nodes,edges) made up of node handles `N` and edge handles `E`, where each `E` can be mapped to its source and target nodes.",null,null],[16,"Node","","",5,null],[16,"Edge","","",5,null],[10,"nodes","","Returns all the nodes in this graph.",5,{"inputs":[{"name":"self"}],"output":{"name":"nodes"}}],[10,"edges","","Returns all of the edges in this graph.",5,{"inputs":[{"name":"self"}],"output":{"name":"edges"}}],[10,"source","","The source node for `edge`.",5,null],[10,"target","","The target node for `edge`.",5,null],[8,"IntoCow","","",null,null],[10,"into_cow","","",6,{"inputs":[{"name":"self"}],"output":{"name":"cow"}}],[11,"clone","","",2,{"inputs":[{"name":"self"}],"output":{"name":"style"}}],[11,"eq","","",2,{"inputs":[{"name":"self"},{"name":"style"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",2,null],[11,"fmt","","",2,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"as_slice","","",2,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"new","","Creates an `Id` named `name`.",0,{"inputs":[{"name":"name"}],"output":{"generics":["id"],"name":"result"}}],[11,"as_slice","","",0,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"name","","",0,{"inputs":[{"name":"self"}],"output":{"generics":["str"],"name":"cow"}}],[11,"label","","",1,{"inputs":[{"name":"s"}],"output":{"name":"labeltext"}}],[11,"escaped","","",1,{"inputs":[{"name":"s"}],"output":{"name":"labeltext"}}],[11,"html","","",1,{"inputs":[{"name":"s"}],"output":{"name":"labeltext"}}],[11,"escape_char","","",1,{"inputs":[{"name":"char"},{"name":"f"}],"output":null}],[11,"escape_str","","",1,{"inputs":[{"name":"str"}],"output":{"name":"string"}}],[11,"to_dot_string","","Renders text as string suitable for a label in a .dot file. This includes quotes or suitable delimiters.",1,{"inputs":[{"name":"self"}],"output":{"name":"string"}}],[11,"pre_escaped_content","","Decomposes content into string suitable for making EscStr that yields same content as self.  The result obeys the law render(`lt`) == render(`EscStr(lt.pre_escaped_content())`) for all `lt: LabelText`.",1,{"inputs":[{"name":"self"}],"output":{"generics":["str"],"name":"cow"}}],[11,"prefix_line","","Puts `prefix` on a line above this label, with a blank line separator.",1,{"inputs":[{"name":"self"},{"name":"labeltext"}],"output":{"name":"labeltext"}}],[11,"suffix_line","","Puts `suffix` on a line below this label, with a blank line separator.",1,{"inputs":[{"name":"self"},{"name":"labeltext"}],"output":{"name":"labeltext"}}],[11,"clone","","",3,{"inputs":[{"name":"self"}],"output":{"name":"renderoption"}}],[11,"eq","","",3,{"inputs":[{"name":"self"},{"name":"renderoption"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",3,null],[11,"fmt","","",3,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}]],"paths":[[3,"Id"],[4,"LabelText"],[4,"Style"],[4,"RenderOption"],[8,"Labeller"],[8,"GraphWalk"],[8,"IntoCow"]]};
searchIndex["proc_macro"] = {"doc":"A support library for macro authors when defining new macros.","items":[[3,"Diagnostic","proc_macro","A structure representing a diagnostic message and associated children messages.",null,null],[12,"level","","",0,null],[12,"message","","",0,null],[12,"span","","",0,null],[12,"children","","",0,null],[3,"TokenStream","","The main type provided by this crate, representing an abstract stream of tokens.",null,null],[12,"0","","",1,null],[3,"LexError","","Error returned from `TokenStream::from_str`.",null,null],[12,"_inner","","",2,null],[3,"Span","","A region of source code, along with macro expansion information.",null,null],[12,"0","","",3,null],[3,"LineColumn","","A line-column pair representing the start or end of a `Span`.",null,null],[12,"line","","The 1-indexed line in the source file on which the span starts or ends (inclusive).",4,null],[12,"column","","The 0-indexed column (in UTF-8 characters) in the source file on which the span starts or ends (inclusive).",4,null],[3,"SourceFile","","The source file of a given `Span`.",null,null],[12,"filemap","","",5,null],[3,"Group","","A delimited token stream",null,null],[12,"delimiter","","",6,null],[12,"stream","","",6,null],[12,"span","","",6,null],[3,"Op","","An `Op` is an operator like `+` or `-`, and only represents one character.",null,null],[12,"op","","",7,null],[12,"spacing","","",7,null],[12,"span","","",7,null],[3,"Term","","An interned string.",null,null],[12,"sym","","",8,null],[12,"span","","",8,null],[3,"Literal","","A literal character (`'a'`), string (`\"hello\"`), a number (`2.3`), etc.",null,null],[12,"lit","","",9,null],[12,"suffix","","",9,null],[12,"span","","",9,null],[4,"Level","","An enum representing a diagnostic level.",null,null],[13,"Error","","An error.",10,null],[13,"Warning","","A warning.",10,null],[13,"Note","","A note.",10,null],[13,"Help","","A help message.",10,null],[13,"__Nonexhaustive","","",10,null],[4,"TokenTree","","A single token or a delimited sequence of token trees (e.g. `[1, (), ..]`).",null,null],[13,"Group","","A delimited tokenstream",11,null],[13,"Term","","A unicode identifier",11,null],[13,"Op","","A punctuation character (`+`, `,`, `$`, etc.).",11,null],[13,"Literal","","A literal character (`'a'`), string (`\"hello\"`), number (`2.3`), etc.",11,null],[4,"Delimiter","","Describes how a sequence of token trees is delimited.",null,null],[13,"Parenthesis","","`( ... )`",12,null],[13,"Brace","","`{ ... }`",12,null],[13,"Bracket","","`[ ... ]`",12,null],[13,"None","","An implicit delimiter, e.g. `$var`, where $var is  `...`.",12,null],[4,"Spacing","","Whether an `Op` is either followed immediately by another `Op` or followed by whitespace.",null,null],[13,"Alone","","e.g. `+` is `Alone` in `+ =`.",13,null],[13,"Joint","","e.g. `+` is `Joint` in `+=`.",13,null],[5,"quote_span","","Quote a `Span` into a `TokenStream`. This is needed to implement a custom quoter.",null,{"inputs":[{"name":"span"}],"output":{"name":"tokenstream"}}],[5,"parse_to_lex_err","","",null,{"inputs":[{"name":"diagnosticbuilder"}],"output":{"name":"lexerror"}}],[0,"diagnostic","","",null,null],[3,"Diagnostic","proc_macro::diagnostic","A structure representing a diagnostic message and associated children messages.",null,null],[12,"level","","",0,null],[12,"message","","",0,null],[12,"span","","",0,null],[12,"children","","",0,null],[4,"Level","","An enum representing a diagnostic level.",null,null],[13,"Error","","An error.",10,null],[13,"Warning","","A warning.",10,null],[13,"Note","","A note.",10,null],[13,"Help","","A help message.",10,null],[13,"__Nonexhaustive","","",10,null],[0,"__internal","","",null,null],[5,"level_to_internal_level","proc_macro::diagnostic::__internal","",null,{"inputs":[{"name":"level"}],"output":{"name":"level"}}],[11,"clone","proc_macro","",10,{"inputs":[{"name":"self"}],"output":{"name":"level"}}],[11,"fmt","","",10,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",0,{"inputs":[{"name":"self"}],"output":{"name":"diagnostic"}}],[11,"fmt","","",0,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Create a new diagnostic with the given `level` and `message`.",0,{"inputs":[{"name":"level"},{"name":"t"}],"output":{"name":"diagnostic"}}],[11,"spanned","","Create a new diagnostic with the given `level` and `message` pointing to the given `span`.",0,{"inputs":[{"name":"span"},{"name":"level"},{"name":"t"}],"output":{"name":"diagnostic"}}],[11,"span_error","","Add a new child diagnostic message to `self` with the level identified by this methods name with the given `span` and `message`.",0,{"inputs":[{"name":"self"},{"name":"span"},{"name":"t"}],"output":{"name":"diagnostic"}}],[11,"error","","Add a new child diagnostic message to `self` with the level identified by this method's name with the given `message`.",0,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"diagnostic"}}],[11,"span_warning","","Add a new child diagnostic message to `self` with the level identified by this methods name with the given `span` and `message`.",0,{"inputs":[{"name":"self"},{"name":"span"},{"name":"t"}],"output":{"name":"diagnostic"}}],[11,"warning","","Add a new child diagnostic message to `self` with the level identified by this method's name with the given `message`.",0,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"diagnostic"}}],[11,"span_note","","Add a new child diagnostic message to `self` with the level identified by this methods name with the given `span` and `message`.",0,{"inputs":[{"name":"self"},{"name":"span"},{"name":"t"}],"output":{"name":"diagnostic"}}],[11,"note","","Add a new child diagnostic message to `self` with the level identified by this method's name with the given `message`.",0,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"diagnostic"}}],[11,"span_help","","Add a new child diagnostic message to `self` with the level identified by this methods name with the given `span` and `message`.",0,{"inputs":[{"name":"self"},{"name":"span"},{"name":"t"}],"output":{"name":"diagnostic"}}],[11,"help","","Add a new child diagnostic message to `self` with the level identified by this method's name with the given `message`.",0,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"diagnostic"}}],[11,"level","","Returns the diagnostic `level` for `self`.",0,{"inputs":[{"name":"self"}],"output":{"name":"level"}}],[11,"emit","","Emit the diagnostic.",0,{"inputs":[{"name":"self"}],"output":null}],[0,"token_stream","","Implementation details for the `TokenTree` type, such as iterators.",null,null],[3,"IntoIter","proc_macro::token_stream","An iterator over `TokenTree`s.",null,null],[12,"cursor","","",14,null],[12,"stack","","",14,null],[11,"clone","","",14,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[11,"next","","",14,{"inputs":[{"name":"self"}],"output":{"generics":["tokentree"],"name":"option"}}],[11,"into_iter","proc_macro","",1,{"inputs":[{"name":"self"}],"output":{"name":"intoiter"}}],[0,"quote","","Quasiquoter This file contains the implementation internals of the quasiquoter provided by `quote!`. This quasiquoter uses macros 2.0 hygiene to reliably access items from `proc_macro`, to build a `proc_macro::TokenStream`.",null,null],[3,"Quoter","proc_macro::quote","",null,null],[4,"LiteralKind","","",null,null],[13,"Byte","","",15,null],[13,"Char","","",15,null],[13,"Float","","",15,null],[13,"Str_","","",15,null],[13,"Integer","","",15,null],[13,"ByteStr","","",15,null],[13,"StrRaw","","",15,null],[13,"ByteStrRaw","","",15,null],[5,"unquote","","",null,{"inputs":[{"name":"t"}],"output":{"name":"tokenstream"}}],[8,"Quote","","",null,null],[10,"quote","","",16,{"inputs":[{"name":"self"}],"output":{"name":"tokenstream"}}],[11,"expand","","",17,{"inputs":[{"name":"self"},{"name":"extctxt"},{"name":"span"},{"name":"tokenstream"}],"output":{"name":"tokenstream"}}],[11,"quote","proc_macro","",1,{"inputs":[{"name":"self"}],"output":{"name":"tokenstream"}}],[11,"quote","","",11,{"inputs":[{"name":"self"}],"output":{"name":"tokenstream"}}],[11,"quote","","",6,{"inputs":[{"name":"self"}],"output":{"name":"tokenstream"}}],[11,"quote","","",7,{"inputs":[{"name":"self"}],"output":{"name":"tokenstream"}}],[11,"quote","","",8,{"inputs":[{"name":"self"}],"output":{"name":"tokenstream"}}],[11,"quote","","",3,{"inputs":[{"name":"self"}],"output":{"name":"tokenstream"}}],[11,"with_contents_and_suffix","proc_macro::quote","",15,{"inputs":[{"name":"self"},{"name":"term"},{"generics":["term"],"name":"option"}],"output":{"name":"literal"}}],[11,"kind_contents_and_suffix","proc_macro","",9,null],[11,"quote","proc_macro::quote","",15,{"inputs":[{"name":"self"}],"output":{"name":"tokenstream"}}],[11,"quote","proc_macro","",9,{"inputs":[{"name":"self"}],"output":{"name":"tokenstream"}}],[11,"quote","","",12,{"inputs":[{"name":"self"}],"output":{"name":"tokenstream"}}],[11,"quote","","",13,{"inputs":[{"name":"self"}],"output":{"name":"tokenstream"}}],[0,"__internal","","Permanently unstable internal implementation details of this crate. This should not be used.",null,null],[3,"Quoter","proc_macro::__internal","",null,null],[4,"LiteralKind","","",null,null],[13,"Byte","","",15,null],[13,"Char","","",15,null],[13,"Float","","",15,null],[13,"Str_","","",15,null],[13,"Integer","","",15,null],[13,"ByteStr","","",15,null],[13,"StrRaw","","",15,null],[13,"ByteStrRaw","","",15,null],[5,"unquote","","",null,{"inputs":[{"name":"t"}],"output":{"name":"tokenstream"}}],[5,"lookup_char_pos","","",null,{"inputs":[{"name":"bytepos"}],"output":{"name":"loc"}}],[5,"new_token_stream","","",null,{"inputs":[{"generics":["item"],"name":"p"}],"output":{"name":"tokenstream"}}],[5,"token_stream_wrap","","",null,{"inputs":[{"name":"tokenstream"}],"output":{"name":"tokenstream"}}],[5,"token_stream_parse_items","","",null,{"inputs":[{"name":"tokenstream"}],"output":{"generics":["vec","lexerror"],"name":"result"}}],[5,"token_stream_inner","","",null,{"inputs":[{"name":"tokenstream"}],"output":{"name":"tokenstream"}}],[5,"set_sess","","",null,{"inputs":[{"name":"extctxt"},{"name":"f"}],"output":{"name":"r"}}],[5,"in_sess","","",null,{"inputs":[],"output":{"name":"bool"}}],[5,"with_sess","","",null,{"inputs":[{"name":"f"}],"output":{"name":"r"}}],[17,"CURRENT_SESS","","",null,null],[8,"Registry","","",null,null],[10,"register_custom_derive","","",18,null],[10,"register_attr_proc_macro","","",18,null],[10,"register_bang_proc_macro","","",18,null],[11,"clone","proc_macro","",1,{"inputs":[{"name":"self"}],"output":{"name":"tokenstream"}}],[11,"fmt","","",2,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"empty","","Returns an empty `TokenStream`.",1,{"inputs":[],"output":{"name":"tokenstream"}}],[11,"is_empty","","Checks if this `TokenStream` is empty.",1,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"from_str","","",1,{"inputs":[{"name":"str"}],"output":{"generics":["tokenstream","lexerror"],"name":"result"}}],[11,"fmt","","",1,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",1,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"from","","",1,{"inputs":[{"name":"tokentree"}],"output":{"name":"tokenstream"}}],[11,"from_iter","","",1,{"inputs":[{"name":"i"}],"output":{"name":"self"}}],[11,"from_iter","","",1,{"inputs":[{"name":"i"}],"output":{"name":"self"}}],[11,"clone","","",3,{"inputs":[{"name":"self"}],"output":{"name":"span"}}],[11,"def_site","","A span that resolves at the macro definition site.",3,{"inputs":[],"output":{"name":"span"}}],[11,"call_site","","The span of the invocation of the current procedural macro.",3,{"inputs":[],"output":{"name":"span"}}],[11,"source_file","","The original source file into which this span points.",3,{"inputs":[{"name":"self"}],"output":{"name":"sourcefile"}}],[11,"parent","","The `Span` for the tokens in the previous macro expansion from which `self` was generated from, if any.",3,{"inputs":[{"name":"self"}],"output":{"generics":["span"],"name":"option"}}],[11,"source","","The span for the origin source code that `self` was generated from. If this `Span` wasn't generated from other macro expansions then the return value is the same as `*self`.",3,{"inputs":[{"name":"self"}],"output":{"name":"span"}}],[11,"start","","Get the starting line/column in the source file for this span.",3,{"inputs":[{"name":"self"}],"output":{"name":"linecolumn"}}],[11,"end","","Get the ending line/column in the source file for this span.",3,{"inputs":[{"name":"self"}],"output":{"name":"linecolumn"}}],[11,"join","","Create a new span encompassing `self` and `other`.",3,{"inputs":[{"name":"self"},{"name":"span"}],"output":{"generics":["span"],"name":"option"}}],[11,"resolved_at","","Creates a new span with the same line/column information as `self` but that resolves symbols as though it were at `other`.",3,{"inputs":[{"name":"self"},{"name":"span"}],"output":{"name":"span"}}],[11,"located_at","","Creates a new span with the same name resolution behavior as `self` but with the line/column information of `other`.",3,{"inputs":[{"name":"self"},{"name":"span"}],"output":{"name":"span"}}],[11,"eq","","Compares to spans to see if they're equal.",3,{"inputs":[{"name":"self"},{"name":"span"}],"output":{"name":"bool"}}],[11,"error","","Create a new `Diagnostic` with the given `message` at the span `self`.",3,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"diagnostic"}}],[11,"warning","","Create a new `Diagnostic` with the given `message` at the span `self`.",3,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"diagnostic"}}],[11,"note","","Create a new `Diagnostic` with the given `message` at the span `self`.",3,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"diagnostic"}}],[11,"help","","Create a new `Diagnostic` with the given `message` at the span `self`.",3,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"diagnostic"}}],[11,"fmt","","",3,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",4,{"inputs":[{"name":"self"}],"output":{"name":"linecolumn"}}],[11,"fmt","","",4,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",4,{"inputs":[{"name":"self"},{"name":"linecolumn"}],"output":{"name":"bool"}}],[11,"ne","","",4,{"inputs":[{"name":"self"},{"name":"linecolumn"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",4,null],[11,"clone","","",5,{"inputs":[{"name":"self"}],"output":{"name":"sourcefile"}}],[11,"path","","Get the path to this source file.",5,{"inputs":[{"name":"self"}],"output":{"name":"filename"}}],[11,"is_real","","Returns `true` if this source file is a real source file, and not generated by an external macro's expansion.",5,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"as_ref","","",5,{"inputs":[{"name":"self"}],"output":{"name":"filename"}}],[11,"fmt","","",5,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",5,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"bool"}}],[11,"eq","","",5,{"inputs":[{"name":"self"},{"name":"filename"}],"output":{"name":"bool"}}],[11,"clone","","",11,{"inputs":[{"name":"self"}],"output":{"name":"tokentree"}}],[11,"span","","Returns the span of this token, accessing the `span` method of each of the internal tokens.",11,{"inputs":[{"name":"self"}],"output":{"name":"span"}}],[11,"set_span","","Configures the span for only this token.",11,{"inputs":[{"name":"self"},{"name":"span"}],"output":null}],[11,"fmt","","",11,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"from","","",11,{"inputs":[{"name":"group"}],"output":{"name":"tokentree"}}],[11,"from","","",11,{"inputs":[{"name":"term"}],"output":{"name":"tokentree"}}],[11,"from","","",11,{"inputs":[{"name":"op"}],"output":{"name":"tokentree"}}],[11,"from","","",11,{"inputs":[{"name":"literal"}],"output":{"name":"tokentree"}}],[11,"fmt","","",11,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",6,{"inputs":[{"name":"self"}],"output":{"name":"group"}}],[11,"fmt","","",6,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",12,{"inputs":[{"name":"self"}],"output":{"name":"delimiter"}}],[11,"fmt","","",12,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",12,{"inputs":[{"name":"self"},{"name":"delimiter"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",12,null],[11,"new","","Creates a new `group` with the given delimiter and token stream.",6,{"inputs":[{"name":"delimiter"},{"name":"tokenstream"}],"output":{"name":"group"}}],[11,"delimiter","","Returns the delimiter of this `Group`",6,{"inputs":[{"name":"self"}],"output":{"name":"delimiter"}}],[11,"stream","","Returns the `TokenStream` of tokens that are delimited in this `Group`.",6,{"inputs":[{"name":"self"}],"output":{"name":"tokenstream"}}],[11,"span","","Returns the span for the delimiters of this token stream, spanning the entire `Group`.",6,{"inputs":[{"name":"self"}],"output":{"name":"span"}}],[11,"set_span","","Configures the span for this `Group`'s delimiters, but not its internal tokens.",6,{"inputs":[{"name":"self"},{"name":"span"}],"output":null}],[11,"fmt","","",6,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",7,{"inputs":[{"name":"self"}],"output":{"name":"op"}}],[11,"fmt","","",7,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",13,{"inputs":[{"name":"self"}],"output":{"name":"spacing"}}],[11,"fmt","","",13,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",13,{"inputs":[{"name":"self"},{"name":"spacing"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",13,null],[11,"new","","Creates a new `Op` from the given character and spacing.",7,{"inputs":[{"name":"char"},{"name":"spacing"}],"output":{"name":"op"}}],[11,"op","","Returns the character this operation represents, for example `'+'`",7,{"inputs":[{"name":"self"}],"output":{"name":"char"}}],[11,"spacing","","Returns the spacing of this operator, indicating whether it's a joint operator with more operators coming next in the token stream or an `Alone` meaning that the operator has ended.",7,{"inputs":[{"name":"self"}],"output":{"name":"spacing"}}],[11,"span","","Returns the span for this operator character",7,{"inputs":[{"name":"self"}],"output":{"name":"span"}}],[11,"set_span","","Configure the span for this operator's character",7,{"inputs":[{"name":"self"},{"name":"span"}],"output":null}],[11,"fmt","","",7,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",8,{"inputs":[{"name":"self"}],"output":{"name":"term"}}],[11,"fmt","","",8,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new `Term` with the given `string` as well as the specified `span`.",8,{"inputs":[{"name":"str"},{"name":"span"}],"output":{"name":"term"}}],[11,"as_str","","Get a reference to the interned string.",8,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"span","","Returns the span of this `Term`, encompassing the entire string returned by `as_str`.",8,{"inputs":[{"name":"self"}],"output":{"name":"span"}}],[11,"set_span","","Configures the span of this `Term`, possibly changing hygiene information.",8,{"inputs":[{"name":"self"},{"name":"span"}],"output":null}],[11,"fmt","","",8,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",9,{"inputs":[{"name":"self"}],"output":{"name":"literal"}}],[11,"fmt","","",9,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"u8_suffixed","","Creates a new suffixed integer literal with the specified value.",9,{"inputs":[{"name":"u8"}],"output":{"name":"literal"}}],[11,"u16_suffixed","","Creates a new suffixed integer literal with the specified value.",9,{"inputs":[{"name":"u16"}],"output":{"name":"literal"}}],[11,"u32_suffixed","","Creates a new suffixed integer literal with the specified value.",9,{"inputs":[{"name":"u32"}],"output":{"name":"literal"}}],[11,"u64_suffixed","","Creates a new suffixed integer literal with the specified value.",9,{"inputs":[{"name":"u64"}],"output":{"name":"literal"}}],[11,"u128_suffixed","","Creates a new suffixed integer literal with the specified value.",9,{"inputs":[{"name":"u128"}],"output":{"name":"literal"}}],[11,"usize_suffixed","","Creates a new suffixed integer literal with the specified value.",9,{"inputs":[{"name":"usize"}],"output":{"name":"literal"}}],[11,"i8_suffixed","","Creates a new suffixed integer literal with the specified value.",9,{"inputs":[{"name":"i8"}],"output":{"name":"literal"}}],[11,"i16_suffixed","","Creates a new suffixed integer literal with the specified value.",9,{"inputs":[{"name":"i16"}],"output":{"name":"literal"}}],[11,"i32_suffixed","","Creates a new suffixed integer literal with the specified value.",9,{"inputs":[{"name":"i32"}],"output":{"name":"literal"}}],[11,"i64_suffixed","","Creates a new suffixed integer literal with the specified value.",9,{"inputs":[{"name":"i64"}],"output":{"name":"literal"}}],[11,"i128_suffixed","","Creates a new suffixed integer literal with the specified value.",9,{"inputs":[{"name":"i128"}],"output":{"name":"literal"}}],[11,"isize_suffixed","","Creates a new suffixed integer literal with the specified value.",9,{"inputs":[{"name":"isize"}],"output":{"name":"literal"}}],[11,"u8_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",9,{"inputs":[{"name":"u8"}],"output":{"name":"literal"}}],[11,"u16_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",9,{"inputs":[{"name":"u16"}],"output":{"name":"literal"}}],[11,"u32_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",9,{"inputs":[{"name":"u32"}],"output":{"name":"literal"}}],[11,"u64_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",9,{"inputs":[{"name":"u64"}],"output":{"name":"literal"}}],[11,"u128_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",9,{"inputs":[{"name":"u128"}],"output":{"name":"literal"}}],[11,"usize_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",9,{"inputs":[{"name":"usize"}],"output":{"name":"literal"}}],[11,"i8_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",9,{"inputs":[{"name":"i8"}],"output":{"name":"literal"}}],[11,"i16_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",9,{"inputs":[{"name":"i16"}],"output":{"name":"literal"}}],[11,"i32_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",9,{"inputs":[{"name":"i32"}],"output":{"name":"literal"}}],[11,"i64_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",9,{"inputs":[{"name":"i64"}],"output":{"name":"literal"}}],[11,"i128_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",9,{"inputs":[{"name":"i128"}],"output":{"name":"literal"}}],[11,"isize_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",9,{"inputs":[{"name":"isize"}],"output":{"name":"literal"}}],[11,"f32_unsuffixed","","Creates a new unsuffixed floating-point literal.",9,{"inputs":[{"name":"f32"}],"output":{"name":"literal"}}],[11,"f32_suffixed","","Creates a new suffixed floating-point literal.",9,{"inputs":[{"name":"f32"}],"output":{"name":"literal"}}],[11,"f64_unsuffixed","","Creates a new unsuffixed floating-point literal.",9,{"inputs":[{"name":"f64"}],"output":{"name":"literal"}}],[11,"f64_suffixed","","Creates a new suffixed floating-point literal.",9,{"inputs":[{"name":"f64"}],"output":{"name":"literal"}}],[11,"string","","String literal.",9,{"inputs":[{"name":"str"}],"output":{"name":"literal"}}],[11,"character","","Character literal.",9,{"inputs":[{"name":"char"}],"output":{"name":"literal"}}],[11,"byte_string","","Byte string literal.",9,null],[11,"span","","Returns the span encompassing this literal.",9,{"inputs":[{"name":"self"}],"output":{"name":"span"}}],[11,"set_span","","Configures the span associated for this literal.",9,{"inputs":[{"name":"self"},{"name":"span"}],"output":null}],[11,"fmt","","",9,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"from_internal","","",12,{"inputs":[{"name":"delimtoken"}],"output":{"name":"delimiter"}}],[11,"to_internal","","",12,{"inputs":[{"name":"self"}],"output":{"name":"delimtoken"}}],[11,"from_internal","","",11,{"inputs":[{"name":"tokenstream"},{"name":"vec"}],"output":{"name":"tokentree"}}],[11,"to_internal","","",11,{"inputs":[{"name":"self"}],"output":{"name":"tokenstream"}}],[14,"quote","","`quote!(..)` accepts arbitrary tokens and expands into a `TokenStream` describing the input. For example, `quote!(a + b)` will produce a expression, that, when evaluated, constructs the `TokenStream` `[Word(\"a\"), Op('+', Alone), Word(\"b\")]`.",null,null]],"paths":[[3,"Diagnostic"],[3,"TokenStream"],[3,"LexError"],[3,"Span"],[3,"LineColumn"],[3,"SourceFile"],[3,"Group"],[3,"Op"],[3,"Term"],[3,"Literal"],[4,"Level"],[4,"TokenTree"],[4,"Delimiter"],[4,"Spacing"],[3,"IntoIter"],[4,"LiteralKind"],[8,"Quote"],[3,"Quoter"],[8,"Registry"]]};
searchIndex["rustc"] = {"doc":"The \"main crate\" of the Rust compiler. This crate contains common type definitions that are used by the other crates in the rustc \"family\". Some prominent examples (note that each of these modules has their own README with further details).","items":[[0,"macros","rustc","",null,null],[0,"diagnostics","","",null,null],[0,"__register_diagnostic_E0038","rustc::diagnostics","",null,null],[0,"__register_diagnostic_E0072","","",null,null],[0,"__register_diagnostic_E0080","","",null,null],[0,"__register_diagnostic_E0106","","",null,null],[0,"__register_diagnostic_E0119","","",null,null],[0,"__register_diagnostic_E0136","","",null,null],[0,"__register_diagnostic_E0137","","",null,null],[0,"__register_diagnostic_E0138","","",null,null],[0,"__register_diagnostic_E0139","","",null,null],[0,"__register_diagnostic_E0152","","",null,null],[0,"__register_diagnostic_E0214","","",null,null],[0,"__register_diagnostic_E0230","","",null,null],[0,"__register_diagnostic_E0231","","",null,null],[0,"__register_diagnostic_E0232","","",null,null],[0,"__register_diagnostic_E0261","","",null,null],[0,"__register_diagnostic_E0262","","",null,null],[0,"__register_diagnostic_E0263","","",null,null],[0,"__register_diagnostic_E0264","","",null,null],[0,"__register_diagnostic_E0271","","",null,null],[0,"__register_diagnostic_E0275","","",null,null],[0,"__register_diagnostic_E0276","","",null,null],[0,"__register_diagnostic_E0277","","",null,null],[0,"__register_diagnostic_E0281","","",null,null],[0,"__register_diagnostic_E0282","","",null,null],[0,"__register_diagnostic_E0283","","",null,null],[0,"__register_diagnostic_E0296","","",null,null],[0,"__register_diagnostic_E0308","","",null,null],[0,"__register_diagnostic_E0309","","",null,null],[0,"__register_diagnostic_E0310","","",null,null],[0,"__register_diagnostic_E0317","","",null,null],[0,"__register_diagnostic_E0391","","",null,null],[0,"__register_diagnostic_E0398","","",null,null],[0,"__register_diagnostic_E0452","","",null,null],[0,"__register_diagnostic_E0453","","",null,null],[0,"__register_diagnostic_E0478","","",null,null],[0,"__register_diagnostic_E0491","","",null,null],[0,"__register_diagnostic_E0496","","",null,null],[0,"__register_diagnostic_E0497","","",null,null],[0,"__register_diagnostic_E0512","","",null,null],[0,"__register_diagnostic_E0517","","",null,null],[0,"__register_diagnostic_E0518","","",null,null],[0,"__register_diagnostic_E0522","","",null,null],[0,"__register_diagnostic_E0525","","",null,null],[0,"__register_diagnostic_E0580","","",null,null],[0,"__register_diagnostic_E0562","","",null,null],[0,"__register_diagnostic_E0591","","",null,null],[0,"__register_diagnostic_E0593","","",null,null],[0,"__register_diagnostic_E0601","","",null,null],[0,"__register_diagnostic_E0602","","",null,null],[0,"__register_diagnostic_E0621","","",null,null],[0,"__register_diagnostic_E0644","","",null,null],[0,"__register_diagnostic_E0692","","",null,null],[0,"__register_diagnostic_E0909","","",null,null],[0,"__register_diagnostic_E0910","","",null,null],[0,"__register_diagnostic_E0911","","",null,null],[0,"__register_diagnostic_E0278","","",null,null],[0,"__register_diagnostic_E0279","","",null,null],[0,"__register_diagnostic_E0280","","",null,null],[0,"__register_diagnostic_E0284","","",null,null],[0,"__register_diagnostic_E0311","","",null,null],[0,"__register_diagnostic_E0312","","",null,null],[0,"__register_diagnostic_E0313","","",null,null],[0,"__register_diagnostic_E0314","","",null,null],[0,"__register_diagnostic_E0315","","",null,null],[0,"__register_diagnostic_E0316","","",null,null],[0,"__register_diagnostic_E0320","","",null,null],[0,"__register_diagnostic_E0473","","",null,null],[0,"__register_diagnostic_E0474","","",null,null],[0,"__register_diagnostic_E0475","","",null,null],[0,"__register_diagnostic_E0476","","",null,null],[0,"__register_diagnostic_E0477","","",null,null],[0,"__register_diagnostic_E0479","","",null,null],[0,"__register_diagnostic_E0480","","",null,null],[0,"__register_diagnostic_E0481","","",null,null],[0,"__register_diagnostic_E0482","","",null,null],[0,"__register_diagnostic_E0483","","",null,null],[0,"__register_diagnostic_E0484","","",null,null],[0,"__register_diagnostic_E0485","","",null,null],[0,"__register_diagnostic_E0486","","",null,null],[0,"__register_diagnostic_E0487","","",null,null],[0,"__register_diagnostic_E0488","","",null,null],[0,"__register_diagnostic_E0489","","",null,null],[0,"__register_diagnostic_E0490","","",null,null],[0,"__register_diagnostic_E0495","","",null,null],[0,"__register_diagnostic_E0566","","",null,null],[0,"__register_diagnostic_E0623","","",null,null],[0,"__register_diagnostic_E0628","","",null,null],[0,"__register_diagnostic_E0631","","",null,null],[0,"__register_diagnostic_E0637","","",null,null],[0,"__register_diagnostic_E0657","","",null,null],[0,"__register_diagnostic_E0687","","",null,null],[0,"__register_diagnostic_E0688","","",null,null],[0,"__register_diagnostic_E0906","","",null,null],[0,"cfg","rustc","Module that constructs a control-flow graph representing an item. Uses `Graph` as the underlying representation.",null,null],[3,"CFG","rustc::cfg","",null,null],[12,"owner_def_id","","",0,null],[12,"graph","","",0,null],[12,"entry","","",0,null],[12,"exit","","",0,null],[3,"CFGEdgeData","","",null,null],[12,"exiting_scopes","","",1,null],[4,"CFGNodeData","","",null,null],[13,"AST","","",2,null],[13,"Entry","","",2,null],[13,"Exit","","",2,null],[13,"Dummy","","",2,null],[13,"Unreachable","","",2,null],[0,"construct","","",null,null],[3,"CFGBuilder","rustc::cfg::construct","",null,null],[12,"tcx","","",3,null],[12,"owner_def_id","","",3,null],[12,"tables","","",3,null],[12,"graph","","",3,null],[12,"fn_exit","","",3,null],[12,"loop_scopes","","",3,null],[12,"breakable_block_scopes","","",3,null],[3,"BlockScope","","",null,null],[12,"block_expr_id","","",4,null],[12,"break_index","","",4,null],[3,"LoopScope","","",null,null],[12,"loop_id","","",5,null],[12,"continue_index","","",5,null],[12,"break_index","","",5,null],[4,"ScopeCfKind","","",null,null],[13,"Break","","",6,null],[13,"Continue","","",6,null],[5,"construct","","",null,{"inputs":[{"name":"tyctxt"},{"name":"body"}],"output":{"name":"cfg"}}],[11,"clone","","",4,{"inputs":[{"name":"self"}],"output":{"name":"blockscope"}}],[11,"clone","","",5,{"inputs":[{"name":"self"}],"output":{"name":"loopscope"}}],[11,"block","","",3,{"inputs":[{"name":"self"},{"name":"block"},{"name":"cfgindex"}],"output":{"name":"cfgindex"}}],[11,"stmt","","",3,{"inputs":[{"name":"self"},{"name":"stmt"},{"name":"cfgindex"}],"output":{"name":"cfgindex"}}],[11,"decl","","",3,{"inputs":[{"name":"self"},{"name":"decl"},{"name":"cfgindex"}],"output":{"name":"cfgindex"}}],[11,"pat","","",3,{"inputs":[{"name":"self"},{"name":"pat"},{"name":"cfgindex"}],"output":{"name":"cfgindex"}}],[11,"pats_all","","Handles case where all of the patterns must match.",3,{"inputs":[{"name":"self"},{"name":"i"},{"name":"cfgindex"}],"output":{"name":"cfgindex"}}],[11,"expr","","",3,{"inputs":[{"name":"self"},{"name":"expr"},{"name":"cfgindex"}],"output":{"name":"cfgindex"}}],[11,"call","","",3,{"inputs":[{"name":"self"},{"name":"expr"},{"name":"cfgindex"},{"name":"expr"},{"name":"i"}],"output":{"name":"cfgindex"}}],[11,"exprs","","Constructs graph for `exprs` evaluated in order",3,{"inputs":[{"name":"self"},{"name":"i"},{"name":"cfgindex"}],"output":{"name":"cfgindex"}}],[11,"opt_expr","","Constructs graph for `opt_expr` evaluated, if Some",3,{"inputs":[{"name":"self"},{"name":"option"},{"name":"cfgindex"}],"output":{"name":"cfgindex"}}],[11,"straightline","","Handles case of an expression that evaluates `subexprs` in order",3,{"inputs":[{"name":"self"},{"name":"expr"},{"name":"cfgindex"},{"name":"i"}],"output":{"name":"cfgindex"}}],[11,"match_","","",3,null],[11,"add_dummy_node","","",3,null],[11,"add_ast_node","","",3,null],[11,"add_unreachable_node","","",3,{"inputs":[{"name":"self"}],"output":{"name":"cfgindex"}}],[11,"add_node","","",3,null],[11,"add_contained_edge","","",3,{"inputs":[{"name":"self"},{"name":"cfgindex"},{"name":"cfgindex"}],"output":null}],[11,"add_exiting_edge","","",3,{"inputs":[{"name":"self"},{"name":"expr"},{"name":"cfgindex"},{"name":"scope"},{"name":"cfgindex"}],"output":null}],[11,"add_returning_edge","","",3,{"inputs":[{"name":"self"},{"name":"expr"},{"name":"cfgindex"}],"output":null}],[11,"find_scope_edge","","",3,null],[11,"clone","","",6,{"inputs":[{"name":"self"}],"output":{"name":"scopecfkind"}}],[11,"assert_receiver_is_total_eq","","",6,null],[11,"eq","","",6,{"inputs":[{"name":"self"},{"name":"scopecfkind"}],"output":{"name":"bool"}}],[0,"graphviz","rustc::cfg","",null,null],[3,"LabelledCFG","rustc::cfg::graphviz","",null,null],[12,"tcx","","",7,null],[12,"cfg","","",7,null],[12,"name","","",7,null],[12,"labelled_edges","","`labelled_edges` controls whether we emit labels on the edges",7,null],[6,"Node","","",null,null],[6,"Edge","","",null,null],[11,"local_id_to_string","","",7,{"inputs":[{"name":"self"},{"name":"itemlocalid"}],"output":{"name":"string"}}],[11,"graph_id","","",7,{"inputs":[{"name":"self"}],"output":{"name":"id"}}],[11,"node_id","","",7,{"inputs":[{"name":"self"},{"name":"node"}],"output":{"name":"id"}}],[11,"node_label","","",7,{"inputs":[{"name":"self"},{"name":"node"}],"output":{"name":"labeltext"}}],[11,"edge_label","","",7,{"inputs":[{"name":"self"},{"name":"edge"}],"output":{"name":"labeltext"}}],[11,"nodes","","",7,{"inputs":[{"name":"self"}],"output":{"generics":["node"],"name":"nodes"}}],[11,"edges","","",7,{"inputs":[{"name":"self"}],"output":{"generics":["edge"],"name":"edges"}}],[11,"source","","",7,{"inputs":[{"name":"self"},{"name":"edge"}],"output":{"name":"node"}}],[11,"target","","",7,{"inputs":[{"name":"self"},{"name":"edge"}],"output":{"name":"node"}}],[6,"CFGIndex","rustc::cfg","",null,null],[6,"CFGGraph","","",null,null],[6,"CFGNode","","",null,null],[6,"CFGEdge","","",null,null],[11,"clone","","",2,{"inputs":[{"name":"self"}],"output":{"name":"cfgnodedata"}}],[11,"fmt","","",2,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",2,{"inputs":[{"name":"self"},{"name":"cfgnodedata"}],"output":{"name":"bool"}}],[11,"ne","","",2,{"inputs":[{"name":"self"},{"name":"cfgnodedata"}],"output":{"name":"bool"}}],[11,"id","","",2,{"inputs":[{"name":"self"}],"output":{"name":"itemlocalid"}}],[11,"fmt","","",1,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","",0,{"inputs":[{"name":"tyctxt"},{"name":"body"}],"output":{"name":"cfg"}}],[11,"node_is_reachable","","",0,{"inputs":[{"name":"self"},{"name":"itemlocalid"}],"output":{"name":"bool"}}],[0,"dep_graph","rustc","",null,null],[3,"DepTrackingMap","rustc::dep_graph","A DepTrackingMap offers a subset of the `Map` API and ensures that we make calls to `read` and `write` as appropriate. We key the maps with a unique type for brevity.",null,null],[12,"phantom","","",8,null],[12,"graph","","",8,null],[12,"map","","",8,null],[3,"DepNode","","",null,null],[12,"kind","","",9,null],[12,"hash","","",9,null],[3,"WorkProductId","","A \"work product\" corresponds to a `.o` (or other) file that we save in between runs. These ids do not have a DefId but rather some independent path or string that persists between runs without the need to be mapped or unmapped. (This ensures we can serialize them even in the absence of a tcx.)",null,null],[12,"hash","","",10,null],[3,"DepGraph","","",null,null],[12,"data","","",11,null],[12,"fingerprints","","",11,null],[3,"WorkProduct","","A \"work product\" is an intermediate result that we save into the incremental directory for later re-use. The primary example are the object files that we save for each partition at code generation time.",null,null],[12,"cgu_name","","",12,null],[12,"saved_files","","Saved files associated with this CGU",12,null],[3,"DepNodeIndex","","",null,null],[12,"0","","",13,null],[3,"PreviousDepGraph","","",null,null],[12,"data","","",14,null],[12,"index","","",14,null],[3,"DepGraphQuery","","",null,null],[12,"graph","","",15,null],[12,"indices","","",15,null],[3,"AssertDepGraphSafe","","A convenient override that lets you pass arbitrary state into a task. Every use should be accompanied by a comment explaining why it makes sense (or how it could be refactored away in the future).",null,null],[12,"0","","",16,null],[3,"SerializedDepGraph","","Data for use when recompiling the current crate.",null,null],[12,"nodes","","The set of all DepNodes in the graph",17,null],[12,"fingerprints","","The set of all Fingerprints in the graph. Each Fingerprint corresponds to the DepNode at the same index in the nodes vector.",17,null],[12,"edge_list_indices","","For each DepNode, stores the list of edges originating from that DepNode. Encoded as a [start, end) pair indexing into edge_list_data, which holds the actual DepNodeIndices of the target nodes.",17,null],[12,"edge_list_data","","A flattened list of all edge targets in the graph. Edge sources are implicit in edge_list_indices.",17,null],[3,"SerializedDepNodeIndex","","",null,null],[12,"0","","",18,null],[4,"DepKind","","",null,null],[13,"Null","","",19,null],[13,"Krate","","",19,null],[13,"HirBody","","",19,null],[13,"Hir","","",19,null],[13,"CrateMetadata","","",19,null],[13,"RegionScopeTree","","",19,null],[13,"Coherence","","",19,null],[13,"CoherenceInherentImplOverlapCheck","","",19,null],[13,"CoherenceCheckTrait","","",19,null],[13,"PrivacyAccessLevels","","",19,null],[13,"MirConstQualif","","",19,null],[13,"MirBuilt","","",19,null],[13,"MirConst","","",19,null],[13,"MirValidated","","",19,null],[13,"MirOptimized","","",19,null],[13,"MirShim","","",19,null],[13,"BorrowCheckKrate","","",19,null],[13,"BorrowCheck","","",19,null],[13,"MirBorrowCheck","","",19,null],[13,"UnsafetyCheckResult","","",19,null],[13,"UnsafeDeriveOnReprPacked","","",19,null],[13,"Reachability","","",19,null],[13,"MirKeys","","",19,null],[13,"CrateVariances","","",19,null],[13,"AssociatedItems","","",19,null],[13,"TypeOfItem","","",19,null],[13,"GenericsOfItem","","",19,null],[13,"PredicatesOfItem","","",19,null],[13,"InferredOutlivesOf","","",19,null],[13,"InferredOutlivesCrate","","",19,null],[13,"SuperPredicatesOfItem","","",19,null],[13,"TraitDefOfItem","","",19,null],[13,"AdtDefOfItem","","",19,null],[13,"ImplTraitRef","","",19,null],[13,"ImplPolarity","","",19,null],[13,"FnSignature","","",19,null],[13,"CoerceUnsizedInfo","","",19,null],[13,"ItemVarianceConstraints","","",19,null],[13,"ItemVariances","","",19,null],[13,"IsConstFn","","",19,null],[13,"IsForeignItem","","",19,null],[13,"TypeParamPredicates","","",19,null],[13,"SizedConstraint","","",19,null],[13,"DtorckConstraint","","",19,null],[13,"AdtDestructor","","",19,null],[13,"AssociatedItemDefIds","","",19,null],[13,"InherentImpls","","",19,null],[13,"TypeckBodiesKrate","","",19,null],[13,"TypeckTables","","",19,null],[13,"UsedTraitImports","","",19,null],[13,"HasTypeckTables","","",19,null],[13,"ConstEval","","",19,null],[13,"CheckMatch","","",19,null],[13,"SymbolName","","",19,null],[13,"InstanceSymbolName","","",19,null],[13,"SpecializationGraph","","",19,null],[13,"ObjectSafety","","",19,null],[13,"FulfillObligation","","",19,null],[13,"VtableMethods","","",19,null],[13,"IsCopy","","",19,null],[13,"IsSized","","",19,null],[13,"IsFreeze","","",19,null],[13,"NeedsDrop","","",19,null],[13,"Layout","","",19,null],[13,"TraitImpls","","",19,null],[13,"AllLocalTraitImpls","","",19,null],[13,"TraitSelect","","",19,null],[13,"ParamEnv","","",19,null],[13,"DescribeDef","","",19,null],[13,"DefSpan","","",19,null],[13,"LookupStability","","",19,null],[13,"LookupDeprecationEntry","","",19,null],[13,"ConstIsRvaluePromotableToStatic","","",19,null],[13,"RvaluePromotableMap","","",19,null],[13,"ImplParent","","",19,null],[13,"TraitOfItem","","",19,null],[13,"IsReachableNonGeneric","","",19,null],[13,"IsUnreachableLocalDefinition","","",19,null],[13,"IsMirAvailable","","",19,null],[13,"ItemAttrs","","",19,null],[13,"TransFnAttrs","","",19,null],[13,"FnArgNames","","",19,null],[13,"RenderedConst","","",19,null],[13,"DylibDepFormats","","",19,null],[13,"IsPanicRuntime","","",19,null],[13,"IsCompilerBuiltins","","",19,null],[13,"HasGlobalAllocator","","",19,null],[13,"ExternCrate","","",19,null],[13,"LintLevels","","",19,null],[13,"Specializes","","",19,null],[13,"InScopeTraits","","",19,null],[13,"ModuleExports","","",19,null],[13,"IsSanitizerRuntime","","",19,null],[13,"IsProfilerRuntime","","",19,null],[13,"GetPanicStrategy","","",19,null],[13,"IsNoBuiltins","","",19,null],[13,"ImplDefaultness","","",19,null],[13,"CheckItemWellFormed","","",19,null],[13,"CheckTraitItemWellFormed","","",19,null],[13,"CheckImplItemWellFormed","","",19,null],[13,"ReachableNonGenerics","","",19,null],[13,"NativeLibraries","","",19,null],[13,"PluginRegistrarFn","","",19,null],[13,"DeriveRegistrarFn","","",19,null],[13,"CrateDisambiguator","","",19,null],[13,"CrateHash","","",19,null],[13,"OriginalCrateName","","",19,null],[13,"ExtraFileName","","",19,null],[13,"ImplementationsOfTrait","","",19,null],[13,"AllTraitImplementations","","",19,null],[13,"DllimportForeignItems","","",19,null],[13,"IsDllimportForeignItem","","",19,null],[13,"IsStaticallyIncludedForeignItem","","",19,null],[13,"NativeLibraryKind","","",19,null],[13,"LinkArgs","","",19,null],[13,"ResolveLifetimes","","",19,null],[13,"NamedRegion","","",19,null],[13,"IsLateBound","","",19,null],[13,"ObjectLifetimeDefaults","","",19,null],[13,"Visibility","","",19,null],[13,"DepKind","","",19,null],[13,"CrateName","","",19,null],[13,"ItemChildren","","",19,null],[13,"ExternModStmtCnum","","",19,null],[13,"GetLangItems","","",19,null],[13,"DefinedLangItems","","",19,null],[13,"MissingLangItems","","",19,null],[13,"VisibleParentMap","","",19,null],[13,"MissingExternCrateItem","","",19,null],[13,"UsedCrateSource","","",19,null],[13,"PostorderCnums","","",19,null],[13,"EraseRegionsTy","","",19,null],[13,"Freevars","","",19,null],[13,"MaybeUnusedTraitImport","","",19,null],[13,"MaybeUnusedExternCrates","","",19,null],[13,"StabilityIndex","","",19,null],[13,"AllTraits","","",19,null],[13,"AllCrateNums","","",19,null],[13,"ExportedSymbols","","",19,null],[13,"CollectAndPartitionTranslationItems","","",19,null],[13,"IsTranslatedItem","","",19,null],[13,"CodegenUnit","","",19,null],[13,"CompileCodegenUnit","","",19,null],[13,"OutputFilenames","","",19,null],[13,"NormalizeProjectionTy","","",19,null],[13,"NormalizeTyAfterErasingRegions","","",19,null],[13,"DropckOutlives","","",19,null],[13,"EvaluateObligation","","",19,null],[13,"SubstituteNormalizeAndTestPredicates","","",19,null],[13,"TargetFeaturesWhitelist","","",19,null],[13,"InstanceDefSizeEstimate","","",19,null],[13,"WasmCustomSections","","",19,null],[13,"Features","","",19,null],[13,"ProgramClausesFor","","",19,null],[13,"ProgramClausesForEnv","","",19,null],[13,"WasmImportModuleMap","","",19,null],[13,"ForeignModules","","",19,null],[13,"UpstreamMonomorphizations","","",19,null],[13,"UpstreamMonomorphizationsFor","","",19,null],[4,"DepConstructor","","",null,null],[13,"Null","","",20,null],[13,"Krate","","",20,null],[13,"HirBody","","",20,null],[13,"Hir","","",20,null],[13,"CrateMetadata","","",20,null],[13,"RegionScopeTree","","",20,null],[13,"Coherence","","",20,null],[13,"CoherenceInherentImplOverlapCheck","","",20,null],[13,"CoherenceCheckTrait","","",20,null],[13,"PrivacyAccessLevels","","",20,null],[13,"MirConstQualif","","",20,null],[13,"MirBuilt","","",20,null],[13,"MirConst","","",20,null],[13,"MirValidated","","",20,null],[13,"MirOptimized","","",20,null],[13,"MirShim","","",20,null],[12,"instance_def","rustc::dep_graph::DepConstructor","",20,null],[13,"BorrowCheckKrate","rustc::dep_graph","",20,null],[13,"BorrowCheck","","",20,null],[13,"MirBorrowCheck","","",20,null],[13,"UnsafetyCheckResult","","",20,null],[13,"UnsafeDeriveOnReprPacked","","",20,null],[13,"Reachability","","",20,null],[13,"MirKeys","","",20,null],[13,"CrateVariances","","",20,null],[13,"AssociatedItems","","",20,null],[13,"TypeOfItem","","",20,null],[13,"GenericsOfItem","","",20,null],[13,"PredicatesOfItem","","",20,null],[13,"InferredOutlivesOf","","",20,null],[13,"InferredOutlivesCrate","","",20,null],[13,"SuperPredicatesOfItem","","",20,null],[13,"TraitDefOfItem","","",20,null],[13,"AdtDefOfItem","","",20,null],[13,"ImplTraitRef","","",20,null],[13,"ImplPolarity","","",20,null],[13,"FnSignature","","",20,null],[13,"CoerceUnsizedInfo","","",20,null],[13,"ItemVarianceConstraints","","",20,null],[13,"ItemVariances","","",20,null],[13,"IsConstFn","","",20,null],[13,"IsForeignItem","","",20,null],[13,"TypeParamPredicates","","",20,null],[12,"item_id","rustc::dep_graph::DepConstructor","",20,null],[12,"param_id","","",20,null],[13,"SizedConstraint","rustc::dep_graph","",20,null],[13,"DtorckConstraint","","",20,null],[13,"AdtDestructor","","",20,null],[13,"AssociatedItemDefIds","","",20,null],[13,"InherentImpls","","",20,null],[13,"TypeckBodiesKrate","","",20,null],[13,"TypeckTables","","",20,null],[13,"UsedTraitImports","","",20,null],[13,"HasTypeckTables","","",20,null],[13,"ConstEval","","",20,null],[12,"param_env","rustc::dep_graph::DepConstructor","",20,null],[13,"CheckMatch","rustc::dep_graph","",20,null],[13,"SymbolName","","",20,null],[13,"InstanceSymbolName","","",20,null],[12,"instance","rustc::dep_graph::DepConstructor","",20,null],[13,"SpecializationGraph","rustc::dep_graph","",20,null],[13,"ObjectSafety","","",20,null],[13,"FulfillObligation","","",20,null],[12,"param_env","rustc::dep_graph::DepConstructor","",20,null],[12,"trait_ref","","",20,null],[13,"VtableMethods","rustc::dep_graph","",20,null],[12,"trait_ref","rustc::dep_graph::DepConstructor","",20,null],[13,"IsCopy","rustc::dep_graph","",20,null],[12,"param_env","rustc::dep_graph::DepConstructor","",20,null],[13,"IsSized","rustc::dep_graph","",20,null],[12,"param_env","rustc::dep_graph::DepConstructor","",20,null],[13,"IsFreeze","rustc::dep_graph","",20,null],[12,"param_env","rustc::dep_graph::DepConstructor","",20,null],[13,"NeedsDrop","rustc::dep_graph","",20,null],[12,"param_env","rustc::dep_graph::DepConstructor","",20,null],[13,"Layout","rustc::dep_graph","",20,null],[12,"param_env","rustc::dep_graph::DepConstructor","",20,null],[13,"TraitImpls","rustc::dep_graph","",20,null],[13,"AllLocalTraitImpls","","",20,null],[13,"TraitSelect","","",20,null],[13,"ParamEnv","","",20,null],[13,"DescribeDef","","",20,null],[13,"DefSpan","","",20,null],[13,"LookupStability","","",20,null],[13,"LookupDeprecationEntry","","",20,null],[13,"ConstIsRvaluePromotableToStatic","","",20,null],[13,"RvaluePromotableMap","","",20,null],[13,"ImplParent","","",20,null],[13,"TraitOfItem","","",20,null],[13,"IsReachableNonGeneric","","",20,null],[13,"IsUnreachableLocalDefinition","","",20,null],[13,"IsMirAvailable","","",20,null],[13,"ItemAttrs","","",20,null],[13,"TransFnAttrs","","",20,null],[13,"FnArgNames","","",20,null],[13,"RenderedConst","","",20,null],[13,"DylibDepFormats","","",20,null],[13,"IsPanicRuntime","","",20,null],[13,"IsCompilerBuiltins","","",20,null],[13,"HasGlobalAllocator","","",20,null],[13,"ExternCrate","","",20,null],[13,"LintLevels","","",20,null],[13,"Specializes","","",20,null],[12,"impl1","rustc::dep_graph::DepConstructor","",20,null],[12,"impl2","","",20,null],[13,"InScopeTraits","rustc::dep_graph","",20,null],[13,"ModuleExports","","",20,null],[13,"IsSanitizerRuntime","","",20,null],[13,"IsProfilerRuntime","","",20,null],[13,"GetPanicStrategy","","",20,null],[13,"IsNoBuiltins","","",20,null],[13,"ImplDefaultness","","",20,null],[13,"CheckItemWellFormed","","",20,null],[13,"CheckTraitItemWellFormed","","",20,null],[13,"CheckImplItemWellFormed","","",20,null],[13,"ReachableNonGenerics","","",20,null],[13,"NativeLibraries","","",20,null],[13,"PluginRegistrarFn","","",20,null],[13,"DeriveRegistrarFn","","",20,null],[13,"CrateDisambiguator","","",20,null],[13,"CrateHash","","",20,null],[13,"OriginalCrateName","","",20,null],[13,"ExtraFileName","","",20,null],[13,"ImplementationsOfTrait","","",20,null],[12,"krate","rustc::dep_graph::DepConstructor","",20,null],[12,"trait_id","","",20,null],[13,"AllTraitImplementations","rustc::dep_graph","",20,null],[13,"DllimportForeignItems","","",20,null],[13,"IsDllimportForeignItem","","",20,null],[13,"IsStaticallyIncludedForeignItem","","",20,null],[13,"NativeLibraryKind","","",20,null],[13,"LinkArgs","","",20,null],[13,"ResolveLifetimes","","",20,null],[13,"NamedRegion","","",20,null],[13,"IsLateBound","","",20,null],[13,"ObjectLifetimeDefaults","","",20,null],[13,"Visibility","","",20,null],[13,"DepKind","","",20,null],[13,"CrateName","","",20,null],[13,"ItemChildren","","",20,null],[13,"ExternModStmtCnum","","",20,null],[13,"GetLangItems","","",20,null],[13,"DefinedLangItems","","",20,null],[13,"MissingLangItems","","",20,null],[13,"VisibleParentMap","","",20,null],[13,"MissingExternCrateItem","","",20,null],[13,"UsedCrateSource","","",20,null],[13,"PostorderCnums","","",20,null],[13,"EraseRegionsTy","","",20,null],[12,"ty","rustc::dep_graph::DepConstructor","",20,null],[13,"Freevars","rustc::dep_graph","",20,null],[13,"MaybeUnusedTraitImport","","",20,null],[13,"MaybeUnusedExternCrates","","",20,null],[13,"StabilityIndex","","",20,null],[13,"AllTraits","","",20,null],[13,"AllCrateNums","","",20,null],[13,"ExportedSymbols","","",20,null],[13,"CollectAndPartitionTranslationItems","","",20,null],[13,"IsTranslatedItem","","",20,null],[13,"CodegenUnit","","",20,null],[13,"CompileCodegenUnit","","",20,null],[13,"OutputFilenames","","",20,null],[13,"NormalizeProjectionTy","","",20,null],[13,"NormalizeTyAfterErasingRegions","","",20,null],[13,"DropckOutlives","","",20,null],[13,"EvaluateObligation","","",20,null],[13,"SubstituteNormalizeAndTestPredicates","","",20,null],[12,"key","rustc::dep_graph::DepConstructor","",20,null],[13,"TargetFeaturesWhitelist","rustc::dep_graph","",20,null],[13,"InstanceDefSizeEstimate","","",20,null],[12,"instance_def","rustc::dep_graph::DepConstructor","",20,null],[13,"WasmCustomSections","rustc::dep_graph","",20,null],[13,"Features","","",20,null],[13,"ProgramClausesFor","","",20,null],[13,"ProgramClausesForEnv","","",20,null],[13,"WasmImportModuleMap","","",20,null],[13,"ForeignModules","","",20,null],[13,"UpstreamMonomorphizations","","",20,null],[13,"UpstreamMonomorphizationsFor","","",20,null],[4,"DepNodeColor","","",null,null],[13,"Red","","",21,null],[13,"Green","","",21,null],[4,"OpenTask","","",null,null],[13,"Regular","","",22,null],[13,"Anon","","",22,null],[13,"Ignore","","",22,null],[13,"EvalAlways","","",22,null],[12,"node","rustc::dep_graph::OpenTask","",22,null],[4,"WorkProductFileKind","rustc::dep_graph","",null,null],[13,"Object","","",23,null],[13,"Bytecode","","",23,null],[13,"BytecodeCompressed","","",23,null],[0,"debug","","Code for debugging the dep-graph.",null,null],[3,"DepNodeFilter","rustc::dep_graph::debug","A dep-node filter goes from a user-defined string to a query over nodes. Right now the format is like this:",null,null],[12,"text","","",24,null],[3,"EdgeFilter","","A filter like `F -> G` where `F` and `G` are valid dep-node filters. This can be used to test the source/target independently.",null,null],[12,"source","","",25,null],[12,"target","","",25,null],[11,"fmt","","",24,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","",24,{"inputs":[{"name":"str"}],"output":{"name":"self"}}],[11,"accepts_all","","True if all nodes always pass the filter.",24,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"test","","Tests whether `node` meets the filter, returning true if so.",24,{"inputs":[{"name":"self"},{"name":"depnode"}],"output":{"name":"bool"}}],[11,"new","","",25,{"inputs":[{"name":"str"}],"output":{"generics":["edgefilter","box"],"name":"result"}}],[11,"test","","",25,{"inputs":[{"name":"self"},{"name":"depnode"},{"name":"depnode"}],"output":{"name":"bool"}}],[0,"dep_node","rustc::dep_graph","This module defines the `DepNode` type which the compiler uses to represent nodes in the dependency graph. A `DepNode` consists of a `DepKind` (which specifies the kind of thing it represents, like a piece of HIR, MIR, etc) and a `Fingerprint`, a 128 bit hash value the exact meaning of which depends on the node's `DepKind`. Together, the kind and the fingerprint fully identify a dependency node, even across multiple compilation sessions. In other words, the value of the fingerprint does not depend on anything that is specific to a given compilation session, like an unpredictable interning key (e.g. NodeId, DefId, Symbol) or the numeric value of a pointer. The concept behind this could be compared to how git commit hashes uniquely identify a given commit and has a few advantages:",null,null],[3,"DepNode","rustc::dep_graph::dep_node","",null,null],[12,"kind","","",9,null],[12,"hash","","",9,null],[3,"WorkProductId","","A \"work product\" corresponds to a `.o` (or other) file that we save in between runs. These ids do not have a DefId but rather some independent path or string that persists between runs without the need to be mapped or unmapped. (This ensures we can serialize them even in the absence of a tcx.)",null,null],[12,"hash","","",10,null],[4,"DepKind","","",null,null],[13,"Null","","",19,null],[13,"Krate","","",19,null],[13,"HirBody","","",19,null],[13,"Hir","","",19,null],[13,"CrateMetadata","","",19,null],[13,"RegionScopeTree","","",19,null],[13,"Coherence","","",19,null],[13,"CoherenceInherentImplOverlapCheck","","",19,null],[13,"CoherenceCheckTrait","","",19,null],[13,"PrivacyAccessLevels","","",19,null],[13,"MirConstQualif","","",19,null],[13,"MirBuilt","","",19,null],[13,"MirConst","","",19,null],[13,"MirValidated","","",19,null],[13,"MirOptimized","","",19,null],[13,"MirShim","","",19,null],[13,"BorrowCheckKrate","","",19,null],[13,"BorrowCheck","","",19,null],[13,"MirBorrowCheck","","",19,null],[13,"UnsafetyCheckResult","","",19,null],[13,"UnsafeDeriveOnReprPacked","","",19,null],[13,"Reachability","","",19,null],[13,"MirKeys","","",19,null],[13,"CrateVariances","","",19,null],[13,"AssociatedItems","","",19,null],[13,"TypeOfItem","","",19,null],[13,"GenericsOfItem","","",19,null],[13,"PredicatesOfItem","","",19,null],[13,"InferredOutlivesOf","","",19,null],[13,"InferredOutlivesCrate","","",19,null],[13,"SuperPredicatesOfItem","","",19,null],[13,"TraitDefOfItem","","",19,null],[13,"AdtDefOfItem","","",19,null],[13,"ImplTraitRef","","",19,null],[13,"ImplPolarity","","",19,null],[13,"FnSignature","","",19,null],[13,"CoerceUnsizedInfo","","",19,null],[13,"ItemVarianceConstraints","","",19,null],[13,"ItemVariances","","",19,null],[13,"IsConstFn","","",19,null],[13,"IsForeignItem","","",19,null],[13,"TypeParamPredicates","","",19,null],[13,"SizedConstraint","","",19,null],[13,"DtorckConstraint","","",19,null],[13,"AdtDestructor","","",19,null],[13,"AssociatedItemDefIds","","",19,null],[13,"InherentImpls","","",19,null],[13,"TypeckBodiesKrate","","",19,null],[13,"TypeckTables","","",19,null],[13,"UsedTraitImports","","",19,null],[13,"HasTypeckTables","","",19,null],[13,"ConstEval","","",19,null],[13,"CheckMatch","","",19,null],[13,"SymbolName","","",19,null],[13,"InstanceSymbolName","","",19,null],[13,"SpecializationGraph","","",19,null],[13,"ObjectSafety","","",19,null],[13,"FulfillObligation","","",19,null],[13,"VtableMethods","","",19,null],[13,"IsCopy","","",19,null],[13,"IsSized","","",19,null],[13,"IsFreeze","","",19,null],[13,"NeedsDrop","","",19,null],[13,"Layout","","",19,null],[13,"TraitImpls","","",19,null],[13,"AllLocalTraitImpls","","",19,null],[13,"TraitSelect","","",19,null],[13,"ParamEnv","","",19,null],[13,"DescribeDef","","",19,null],[13,"DefSpan","","",19,null],[13,"LookupStability","","",19,null],[13,"LookupDeprecationEntry","","",19,null],[13,"ConstIsRvaluePromotableToStatic","","",19,null],[13,"RvaluePromotableMap","","",19,null],[13,"ImplParent","","",19,null],[13,"TraitOfItem","","",19,null],[13,"IsReachableNonGeneric","","",19,null],[13,"IsUnreachableLocalDefinition","","",19,null],[13,"IsMirAvailable","","",19,null],[13,"ItemAttrs","","",19,null],[13,"TransFnAttrs","","",19,null],[13,"FnArgNames","","",19,null],[13,"RenderedConst","","",19,null],[13,"DylibDepFormats","","",19,null],[13,"IsPanicRuntime","","",19,null],[13,"IsCompilerBuiltins","","",19,null],[13,"HasGlobalAllocator","","",19,null],[13,"ExternCrate","","",19,null],[13,"LintLevels","","",19,null],[13,"Specializes","","",19,null],[13,"InScopeTraits","","",19,null],[13,"ModuleExports","","",19,null],[13,"IsSanitizerRuntime","","",19,null],[13,"IsProfilerRuntime","","",19,null],[13,"GetPanicStrategy","","",19,null],[13,"IsNoBuiltins","","",19,null],[13,"ImplDefaultness","","",19,null],[13,"CheckItemWellFormed","","",19,null],[13,"CheckTraitItemWellFormed","","",19,null],[13,"CheckImplItemWellFormed","","",19,null],[13,"ReachableNonGenerics","","",19,null],[13,"NativeLibraries","","",19,null],[13,"PluginRegistrarFn","","",19,null],[13,"DeriveRegistrarFn","","",19,null],[13,"CrateDisambiguator","","",19,null],[13,"CrateHash","","",19,null],[13,"OriginalCrateName","","",19,null],[13,"ExtraFileName","","",19,null],[13,"ImplementationsOfTrait","","",19,null],[13,"AllTraitImplementations","","",19,null],[13,"DllimportForeignItems","","",19,null],[13,"IsDllimportForeignItem","","",19,null],[13,"IsStaticallyIncludedForeignItem","","",19,null],[13,"NativeLibraryKind","","",19,null],[13,"LinkArgs","","",19,null],[13,"ResolveLifetimes","","",19,null],[13,"NamedRegion","","",19,null],[13,"IsLateBound","","",19,null],[13,"ObjectLifetimeDefaults","","",19,null],[13,"Visibility","","",19,null],[13,"DepKind","","",19,null],[13,"CrateName","","",19,null],[13,"ItemChildren","","",19,null],[13,"ExternModStmtCnum","","",19,null],[13,"GetLangItems","","",19,null],[13,"DefinedLangItems","","",19,null],[13,"MissingLangItems","","",19,null],[13,"VisibleParentMap","","",19,null],[13,"MissingExternCrateItem","","",19,null],[13,"UsedCrateSource","","",19,null],[13,"PostorderCnums","","",19,null],[13,"EraseRegionsTy","","",19,null],[13,"Freevars","","",19,null],[13,"MaybeUnusedTraitImport","","",19,null],[13,"MaybeUnusedExternCrates","","",19,null],[13,"StabilityIndex","","",19,null],[13,"AllTraits","","",19,null],[13,"AllCrateNums","","",19,null],[13,"ExportedSymbols","","",19,null],[13,"CollectAndPartitionTranslationItems","","",19,null],[13,"IsTranslatedItem","","",19,null],[13,"CodegenUnit","","",19,null],[13,"CompileCodegenUnit","","",19,null],[13,"OutputFilenames","","",19,null],[13,"NormalizeProjectionTy","","",19,null],[13,"NormalizeTyAfterErasingRegions","","",19,null],[13,"DropckOutlives","","",19,null],[13,"EvaluateObligation","","",19,null],[13,"SubstituteNormalizeAndTestPredicates","","",19,null],[13,"TargetFeaturesWhitelist","","",19,null],[13,"InstanceDefSizeEstimate","","",19,null],[13,"WasmCustomSections","","",19,null],[13,"Features","","",19,null],[13,"ProgramClausesFor","","",19,null],[13,"ProgramClausesForEnv","","",19,null],[13,"WasmImportModuleMap","","",19,null],[13,"ForeignModules","","",19,null],[13,"UpstreamMonomorphizations","","",19,null],[13,"UpstreamMonomorphizationsFor","","",19,null],[4,"DepConstructor","","",null,null],[13,"Null","","",20,null],[13,"Krate","","",20,null],[13,"HirBody","","",20,null],[13,"Hir","","",20,null],[13,"CrateMetadata","","",20,null],[13,"RegionScopeTree","","",20,null],[13,"Coherence","","",20,null],[13,"CoherenceInherentImplOverlapCheck","","",20,null],[13,"CoherenceCheckTrait","","",20,null],[13,"PrivacyAccessLevels","","",20,null],[13,"MirConstQualif","","",20,null],[13,"MirBuilt","","",20,null],[13,"MirConst","","",20,null],[13,"MirValidated","","",20,null],[13,"MirOptimized","","",20,null],[13,"MirShim","","",20,null],[12,"instance_def","rustc::dep_graph::dep_node::DepConstructor","",20,null],[13,"BorrowCheckKrate","rustc::dep_graph::dep_node","",20,null],[13,"BorrowCheck","","",20,null],[13,"MirBorrowCheck","","",20,null],[13,"UnsafetyCheckResult","","",20,null],[13,"UnsafeDeriveOnReprPacked","","",20,null],[13,"Reachability","","",20,null],[13,"MirKeys","","",20,null],[13,"CrateVariances","","",20,null],[13,"AssociatedItems","","",20,null],[13,"TypeOfItem","","",20,null],[13,"GenericsOfItem","","",20,null],[13,"PredicatesOfItem","","",20,null],[13,"InferredOutlivesOf","","",20,null],[13,"InferredOutlivesCrate","","",20,null],[13,"SuperPredicatesOfItem","","",20,null],[13,"TraitDefOfItem","","",20,null],[13,"AdtDefOfItem","","",20,null],[13,"ImplTraitRef","","",20,null],[13,"ImplPolarity","","",20,null],[13,"FnSignature","","",20,null],[13,"CoerceUnsizedInfo","","",20,null],[13,"ItemVarianceConstraints","","",20,null],[13,"ItemVariances","","",20,null],[13,"IsConstFn","","",20,null],[13,"IsForeignItem","","",20,null],[13,"TypeParamPredicates","","",20,null],[12,"item_id","rustc::dep_graph::dep_node::DepConstructor","",20,null],[12,"param_id","","",20,null],[13,"SizedConstraint","rustc::dep_graph::dep_node","",20,null],[13,"DtorckConstraint","","",20,null],[13,"AdtDestructor","","",20,null],[13,"AssociatedItemDefIds","","",20,null],[13,"InherentImpls","","",20,null],[13,"TypeckBodiesKrate","","",20,null],[13,"TypeckTables","","",20,null],[13,"UsedTraitImports","","",20,null],[13,"HasTypeckTables","","",20,null],[13,"ConstEval","","",20,null],[12,"param_env","rustc::dep_graph::dep_node::DepConstructor","",20,null],[13,"CheckMatch","rustc::dep_graph::dep_node","",20,null],[13,"SymbolName","","",20,null],[13,"InstanceSymbolName","","",20,null],[12,"instance","rustc::dep_graph::dep_node::DepConstructor","",20,null],[13,"SpecializationGraph","rustc::dep_graph::dep_node","",20,null],[13,"ObjectSafety","","",20,null],[13,"FulfillObligation","","",20,null],[12,"param_env","rustc::dep_graph::dep_node::DepConstructor","",20,null],[12,"trait_ref","","",20,null],[13,"VtableMethods","rustc::dep_graph::dep_node","",20,null],[12,"trait_ref","rustc::dep_graph::dep_node::DepConstructor","",20,null],[13,"IsCopy","rustc::dep_graph::dep_node","",20,null],[12,"param_env","rustc::dep_graph::dep_node::DepConstructor","",20,null],[13,"IsSized","rustc::dep_graph::dep_node","",20,null],[12,"param_env","rustc::dep_graph::dep_node::DepConstructor","",20,null],[13,"IsFreeze","rustc::dep_graph::dep_node","",20,null],[12,"param_env","rustc::dep_graph::dep_node::DepConstructor","",20,null],[13,"NeedsDrop","rustc::dep_graph::dep_node","",20,null],[12,"param_env","rustc::dep_graph::dep_node::DepConstructor","",20,null],[13,"Layout","rustc::dep_graph::dep_node","",20,null],[12,"param_env","rustc::dep_graph::dep_node::DepConstructor","",20,null],[13,"TraitImpls","rustc::dep_graph::dep_node","",20,null],[13,"AllLocalTraitImpls","","",20,null],[13,"TraitSelect","","",20,null],[13,"ParamEnv","","",20,null],[13,"DescribeDef","","",20,null],[13,"DefSpan","","",20,null],[13,"LookupStability","","",20,null],[13,"LookupDeprecationEntry","","",20,null],[13,"ConstIsRvaluePromotableToStatic","","",20,null],[13,"RvaluePromotableMap","","",20,null],[13,"ImplParent","","",20,null],[13,"TraitOfItem","","",20,null],[13,"IsReachableNonGeneric","","",20,null],[13,"IsUnreachableLocalDefinition","","",20,null],[13,"IsMirAvailable","","",20,null],[13,"ItemAttrs","","",20,null],[13,"TransFnAttrs","","",20,null],[13,"FnArgNames","","",20,null],[13,"RenderedConst","","",20,null],[13,"DylibDepFormats","","",20,null],[13,"IsPanicRuntime","","",20,null],[13,"IsCompilerBuiltins","","",20,null],[13,"HasGlobalAllocator","","",20,null],[13,"ExternCrate","","",20,null],[13,"LintLevels","","",20,null],[13,"Specializes","","",20,null],[12,"impl1","rustc::dep_graph::dep_node::DepConstructor","",20,null],[12,"impl2","","",20,null],[13,"InScopeTraits","rustc::dep_graph::dep_node","",20,null],[13,"ModuleExports","","",20,null],[13,"IsSanitizerRuntime","","",20,null],[13,"IsProfilerRuntime","","",20,null],[13,"GetPanicStrategy","","",20,null],[13,"IsNoBuiltins","","",20,null],[13,"ImplDefaultness","","",20,null],[13,"CheckItemWellFormed","","",20,null],[13,"CheckTraitItemWellFormed","","",20,null],[13,"CheckImplItemWellFormed","","",20,null],[13,"ReachableNonGenerics","","",20,null],[13,"NativeLibraries","","",20,null],[13,"PluginRegistrarFn","","",20,null],[13,"DeriveRegistrarFn","","",20,null],[13,"CrateDisambiguator","","",20,null],[13,"CrateHash","","",20,null],[13,"OriginalCrateName","","",20,null],[13,"ExtraFileName","","",20,null],[13,"ImplementationsOfTrait","","",20,null],[12,"krate","rustc::dep_graph::dep_node::DepConstructor","",20,null],[12,"trait_id","","",20,null],[13,"AllTraitImplementations","rustc::dep_graph::dep_node","",20,null],[13,"DllimportForeignItems","","",20,null],[13,"IsDllimportForeignItem","","",20,null],[13,"IsStaticallyIncludedForeignItem","","",20,null],[13,"NativeLibraryKind","","",20,null],[13,"LinkArgs","","",20,null],[13,"ResolveLifetimes","","",20,null],[13,"NamedRegion","","",20,null],[13,"IsLateBound","","",20,null],[13,"ObjectLifetimeDefaults","","",20,null],[13,"Visibility","","",20,null],[13,"DepKind","","",20,null],[13,"CrateName","","",20,null],[13,"ItemChildren","","",20,null],[13,"ExternModStmtCnum","","",20,null],[13,"GetLangItems","","",20,null],[13,"DefinedLangItems","","",20,null],[13,"MissingLangItems","","",20,null],[13,"VisibleParentMap","","",20,null],[13,"MissingExternCrateItem","","",20,null],[13,"UsedCrateSource","","",20,null],[13,"PostorderCnums","","",20,null],[13,"EraseRegionsTy","","",20,null],[12,"ty","rustc::dep_graph::dep_node::DepConstructor","",20,null],[13,"Freevars","rustc::dep_graph::dep_node","",20,null],[13,"MaybeUnusedTraitImport","","",20,null],[13,"MaybeUnusedExternCrates","","",20,null],[13,"StabilityIndex","","",20,null],[13,"AllTraits","","",20,null],[13,"AllCrateNums","","",20,null],[13,"ExportedSymbols","","",20,null],[13,"CollectAndPartitionTranslationItems","","",20,null],[13,"IsTranslatedItem","","",20,null],[13,"CodegenUnit","","",20,null],[13,"CompileCodegenUnit","","",20,null],[13,"OutputFilenames","","",20,null],[13,"NormalizeProjectionTy","","",20,null],[13,"NormalizeTyAfterErasingRegions","","",20,null],[13,"DropckOutlives","","",20,null],[13,"EvaluateObligation","","",20,null],[13,"SubstituteNormalizeAndTestPredicates","","",20,null],[12,"key","rustc::dep_graph::dep_node::DepConstructor","",20,null],[13,"TargetFeaturesWhitelist","rustc::dep_graph::dep_node","",20,null],[13,"InstanceDefSizeEstimate","","",20,null],[12,"instance_def","rustc::dep_graph::dep_node::DepConstructor","",20,null],[13,"WasmCustomSections","rustc::dep_graph::dep_node","",20,null],[13,"Features","","",20,null],[13,"ProgramClausesFor","","",20,null],[13,"ProgramClausesForEnv","","",20,null],[13,"WasmImportModuleMap","","",20,null],[13,"ForeignModules","","",20,null],[13,"UpstreamMonomorphizations","","",20,null],[13,"UpstreamMonomorphizationsFor","","",20,null],[0,"label_strs","","Contains variant => str representations for constructing DepNode groups for tests.",null,null],[17,"Null","rustc::dep_graph::dep_node::label_strs","",null,null],[17,"Krate","","",null,null],[17,"HirBody","","",null,null],[17,"Hir","","",null,null],[17,"CrateMetadata","","",null,null],[17,"RegionScopeTree","","",null,null],[17,"Coherence","","",null,null],[17,"CoherenceInherentImplOverlapCheck","","",null,null],[17,"CoherenceCheckTrait","","",null,null],[17,"PrivacyAccessLevels","","",null,null],[17,"MirConstQualif","","",null,null],[17,"MirBuilt","","",null,null],[17,"MirConst","","",null,null],[17,"MirValidated","","",null,null],[17,"MirOptimized","","",null,null],[17,"MirShim","","",null,null],[17,"BorrowCheckKrate","","",null,null],[17,"BorrowCheck","","",null,null],[17,"MirBorrowCheck","","",null,null],[17,"UnsafetyCheckResult","","",null,null],[17,"UnsafeDeriveOnReprPacked","","",null,null],[17,"Reachability","","",null,null],[17,"MirKeys","","",null,null],[17,"CrateVariances","","",null,null],[17,"AssociatedItems","","",null,null],[17,"TypeOfItem","","",null,null],[17,"GenericsOfItem","","",null,null],[17,"PredicatesOfItem","","",null,null],[17,"InferredOutlivesOf","","",null,null],[17,"InferredOutlivesCrate","","",null,null],[17,"SuperPredicatesOfItem","","",null,null],[17,"TraitDefOfItem","","",null,null],[17,"AdtDefOfItem","","",null,null],[17,"ImplTraitRef","","",null,null],[17,"ImplPolarity","","",null,null],[17,"FnSignature","","",null,null],[17,"CoerceUnsizedInfo","","",null,null],[17,"ItemVarianceConstraints","","",null,null],[17,"ItemVariances","","",null,null],[17,"IsConstFn","","",null,null],[17,"IsForeignItem","","",null,null],[17,"TypeParamPredicates","","",null,null],[17,"SizedConstraint","","",null,null],[17,"DtorckConstraint","","",null,null],[17,"AdtDestructor","","",null,null],[17,"AssociatedItemDefIds","","",null,null],[17,"InherentImpls","","",null,null],[17,"TypeckBodiesKrate","","",null,null],[17,"TypeckTables","","",null,null],[17,"UsedTraitImports","","",null,null],[17,"HasTypeckTables","","",null,null],[17,"ConstEval","","",null,null],[17,"CheckMatch","","",null,null],[17,"SymbolName","","",null,null],[17,"InstanceSymbolName","","",null,null],[17,"SpecializationGraph","","",null,null],[17,"ObjectSafety","","",null,null],[17,"FulfillObligation","","",null,null],[17,"VtableMethods","","",null,null],[17,"IsCopy","","",null,null],[17,"IsSized","","",null,null],[17,"IsFreeze","","",null,null],[17,"NeedsDrop","","",null,null],[17,"Layout","","",null,null],[17,"TraitImpls","","",null,null],[17,"AllLocalTraitImpls","","",null,null],[17,"TraitSelect","","",null,null],[17,"ParamEnv","","",null,null],[17,"DescribeDef","","",null,null],[17,"DefSpan","","",null,null],[17,"LookupStability","","",null,null],[17,"LookupDeprecationEntry","","",null,null],[17,"ConstIsRvaluePromotableToStatic","","",null,null],[17,"RvaluePromotableMap","","",null,null],[17,"ImplParent","","",null,null],[17,"TraitOfItem","","",null,null],[17,"IsReachableNonGeneric","","",null,null],[17,"IsUnreachableLocalDefinition","","",null,null],[17,"IsMirAvailable","","",null,null],[17,"ItemAttrs","","",null,null],[17,"TransFnAttrs","","",null,null],[17,"FnArgNames","","",null,null],[17,"RenderedConst","","",null,null],[17,"DylibDepFormats","","",null,null],[17,"IsPanicRuntime","","",null,null],[17,"IsCompilerBuiltins","","",null,null],[17,"HasGlobalAllocator","","",null,null],[17,"ExternCrate","","",null,null],[17,"LintLevels","","",null,null],[17,"Specializes","","",null,null],[17,"InScopeTraits","","",null,null],[17,"ModuleExports","","",null,null],[17,"IsSanitizerRuntime","","",null,null],[17,"IsProfilerRuntime","","",null,null],[17,"GetPanicStrategy","","",null,null],[17,"IsNoBuiltins","","",null,null],[17,"ImplDefaultness","","",null,null],[17,"CheckItemWellFormed","","",null,null],[17,"CheckTraitItemWellFormed","","",null,null],[17,"CheckImplItemWellFormed","","",null,null],[17,"ReachableNonGenerics","","",null,null],[17,"NativeLibraries","","",null,null],[17,"PluginRegistrarFn","","",null,null],[17,"DeriveRegistrarFn","","",null,null],[17,"CrateDisambiguator","","",null,null],[17,"CrateHash","","",null,null],[17,"OriginalCrateName","","",null,null],[17,"ExtraFileName","","",null,null],[17,"ImplementationsOfTrait","","",null,null],[17,"AllTraitImplementations","","",null,null],[17,"DllimportForeignItems","","",null,null],[17,"IsDllimportForeignItem","","",null,null],[17,"IsStaticallyIncludedForeignItem","","",null,null],[17,"NativeLibraryKind","","",null,null],[17,"LinkArgs","","",null,null],[17,"ResolveLifetimes","","",null,null],[17,"NamedRegion","","",null,null],[17,"IsLateBound","","",null,null],[17,"ObjectLifetimeDefaults","","",null,null],[17,"Visibility","","",null,null],[17,"DepKind","","",null,null],[17,"CrateName","","",null,null],[17,"ItemChildren","","",null,null],[17,"ExternModStmtCnum","","",null,null],[17,"GetLangItems","","",null,null],[17,"DefinedLangItems","","",null,null],[17,"MissingLangItems","","",null,null],[17,"VisibleParentMap","","",null,null],[17,"MissingExternCrateItem","","",null,null],[17,"UsedCrateSource","","",null,null],[17,"PostorderCnums","","",null,null],[17,"EraseRegionsTy","","",null,null],[17,"Freevars","","",null,null],[17,"MaybeUnusedTraitImport","","",null,null],[17,"MaybeUnusedExternCrates","","",null,null],[17,"StabilityIndex","","",null,null],[17,"AllTraits","","",null,null],[17,"AllCrateNums","","",null,null],[17,"ExportedSymbols","","",null,null],[17,"CollectAndPartitionTranslationItems","","",null,null],[17,"IsTranslatedItem","","",null,null],[17,"CodegenUnit","","",null,null],[17,"CompileCodegenUnit","","",null,null],[17,"OutputFilenames","","",null,null],[17,"NormalizeProjectionTy","","",null,null],[17,"NormalizeTyAfterErasingRegions","","",null,null],[17,"DropckOutlives","","",null,null],[17,"EvaluateObligation","","",null,null],[17,"SubstituteNormalizeAndTestPredicates","","",null,null],[17,"TargetFeaturesWhitelist","","",null,null],[17,"InstanceDefSizeEstimate","","",null,null],[17,"WasmCustomSections","","",null,null],[17,"Features","","",null,null],[17,"ProgramClausesFor","","",null,null],[17,"ProgramClausesForEnv","","",null,null],[17,"WasmImportModuleMap","","",null,null],[17,"ForeignModules","","",null,null],[17,"UpstreamMonomorphizations","","",null,null],[17,"UpstreamMonomorphizationsFor","","",null,null],[8,"DepNodeParams","rustc::dep_graph::dep_node","",null,null],[18,"CAN_RECONSTRUCT_QUERY_KEY","","",26,null],[11,"to_fingerprint","","This method turns the parameters of a DepNodeConstructor into an opaque Fingerprint to be used in DepNode. Not all DepNodeParams support being turned into a Fingerprint (they don't need to if the corresponding DepNode is anonymous).",26,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"fingerprint"}}],[11,"to_debug_str","","",26,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"string"}}],[11,"fmt","rustc::dep_graph","",9,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fingerprint_needed_for_crate_hash","","",19,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",19,{"inputs":[{"name":"self"}],"output":{"name":"depkind"}}],[11,"fmt","","",19,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",19,{"inputs":[{"name":"self"},{"name":"depkind"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",19,null],[11,"partial_cmp","","",19,{"inputs":[{"name":"self"},{"name":"depkind"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"cmp","","",19,{"inputs":[{"name":"self"},{"name":"depkind"}],"output":{"name":"ordering"}}],[11,"hash","","",19,null],[11,"encode","","",19,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",19,{"inputs":[{"name":"__d"}],"output":{"generics":["depkind"],"name":"result"}}],[11,"can_reconstruct_query_key","","",19,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_anon","","",19,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_input","","",19,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_eval_always","","",19,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"has_params","","",19,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",9,{"inputs":[{"name":"self"}],"output":{"name":"depnode"}}],[11,"eq","","",9,{"inputs":[{"name":"self"},{"name":"depnode"}],"output":{"name":"bool"}}],[11,"ne","","",9,{"inputs":[{"name":"self"},{"name":"depnode"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",9,null],[11,"partial_cmp","","",9,{"inputs":[{"name":"self"},{"name":"depnode"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",9,{"inputs":[{"name":"self"},{"name":"depnode"}],"output":{"name":"bool"}}],[11,"le","","",9,{"inputs":[{"name":"self"},{"name":"depnode"}],"output":{"name":"bool"}}],[11,"gt","","",9,{"inputs":[{"name":"self"},{"name":"depnode"}],"output":{"name":"bool"}}],[11,"ge","","",9,{"inputs":[{"name":"self"},{"name":"depnode"}],"output":{"name":"bool"}}],[11,"cmp","","",9,{"inputs":[{"name":"self"},{"name":"depnode"}],"output":{"name":"ordering"}}],[11,"hash","","",9,null],[11,"encode","","",9,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",9,{"inputs":[{"name":"__d"}],"output":{"generics":["depnode"],"name":"result"}}],[11,"new","","",9,{"inputs":[{"name":"tyctxt"},{"name":"depconstructor"}],"output":{"name":"depnode"}}],[11,"from_def_path_hash","","Construct a DepNode from the given DepKind and DefPathHash. This method will assert that the given DepKind actually requires a single DefId/DefPathHash parameter.",9,{"inputs":[{"name":"depkind"},{"name":"defpathhash"}],"output":{"name":"depnode"}}],[11,"new_no_params","","Create a new, parameterless DepNode. This method will assert that the DepNode corresponding to the given DepKind actually does not require any parameters.",9,{"inputs":[{"name":"depkind"}],"output":{"name":"depnode"}}],[11,"extract_def_id","","Extract the DefId corresponding to this DepNode. This will work if two conditions are met:",9,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"generics":["defid"],"name":"option"}}],[11,"from_label_string","","Used in testing",9,{"inputs":[{"name":"str"},{"name":"defpathhash"}],"output":{"generics":["depnode"],"name":"result"}}],[11,"has_label_string","","Used in testing",9,{"inputs":[{"name":"str"}],"output":{"name":"bool"}}],[11,"clone","","",10,{"inputs":[{"name":"self"}],"output":{"name":"workproductid"}}],[11,"fmt","","",10,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",10,{"inputs":[{"name":"self"},{"name":"workproductid"}],"output":{"name":"bool"}}],[11,"ne","","",10,{"inputs":[{"name":"self"},{"name":"workproductid"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",10,null],[11,"partial_cmp","","",10,{"inputs":[{"name":"self"},{"name":"workproductid"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",10,{"inputs":[{"name":"self"},{"name":"workproductid"}],"output":{"name":"bool"}}],[11,"le","","",10,{"inputs":[{"name":"self"},{"name":"workproductid"}],"output":{"name":"bool"}}],[11,"gt","","",10,{"inputs":[{"name":"self"},{"name":"workproductid"}],"output":{"name":"bool"}}],[11,"ge","","",10,{"inputs":[{"name":"self"},{"name":"workproductid"}],"output":{"name":"bool"}}],[11,"cmp","","",10,{"inputs":[{"name":"self"},{"name":"workproductid"}],"output":{"name":"ordering"}}],[11,"hash","","",10,null],[11,"encode","","",10,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",10,{"inputs":[{"name":"__d"}],"output":{"generics":["workproductid"],"name":"result"}}],[11,"from_cgu_name","","",10,{"inputs":[{"name":"str"}],"output":{"name":"workproductid"}}],[11,"from_fingerprint","","",10,{"inputs":[{"name":"fingerprint"}],"output":{"name":"workproductid"}}],[11,"hash_stable","","",10,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[0,"dep_tracking_map","","",null,null],[3,"DepTrackingMap","rustc::dep_graph::dep_tracking_map","A DepTrackingMap offers a subset of the `Map` API and ensures that we make calls to `read` and `write` as appropriate. We key the maps with a unique type for brevity.",null,null],[12,"phantom","","",8,null],[12,"graph","","",8,null],[12,"map","","",8,null],[8,"DepTrackingMapConfig","","",null,null],[16,"Key","","",27,null],[16,"Value","","",27,null],[10,"to_dep_kind","","",27,{"inputs":[],"output":{"name":"depkind"}}],[11,"new","rustc::dep_graph","",8,{"inputs":[{"name":"depgraph"}],"output":{"name":"deptrackingmap"}}],[0,"graph","","",null,null],[3,"DepGraph","rustc::dep_graph::graph","",null,null],[12,"data","","",11,null],[12,"fingerprints","","",11,null],[3,"DepNodeIndex","","",null,null],[12,"0","","",13,null],[3,"DepGraphData","","",null,null],[12,"current","","The new encoding of the dependency graph, optimized for red/green tracking. The `current` field is the dependency graph of only the current compilation session: We don't merge the previous dep-graph into current one anymore.",28,null],[12,"previous","","The dep-graph from the previous compilation session. It contains all nodes and edges as well as all fingerprints of nodes that have them.",28,null],[12,"colors","","",28,null],[12,"previous_work_products","","When we load, there may be `.o` files, cached mir, or other such things available to us. If we find that they are not dirty, we load the path to the file storing those work-products here into this map. We can later look for and extract that data.",28,null],[12,"work_products","","Work-products that we generate in this run.",28,null],[12,"dep_node_debug","","",28,null],[12,"loaded_from_cache","","",28,null],[3,"WorkProduct","","A \"work product\" is an intermediate result that we save into the incremental directory for later re-use. The primary example are the object files that we save for each partition at code generation time.",null,null],[12,"cgu_name","","",12,null],[12,"saved_files","","Saved files associated with this CGU",12,null],[3,"CurrentDepGraph","","",null,null],[12,"nodes","","",29,null],[12,"edges","","",29,null],[12,"node_to_node_index","","",29,null],[12,"forbidden_edge","","",29,null],[12,"anon_id_seed","","",29,null],[12,"total_read_count","","",29,null],[12,"total_duplicate_read_count","","",29,null],[3,"RegularOpenTask","","",null,null],[12,"node","","",30,null],[12,"reads","","",30,null],[12,"read_set","","",30,null],[3,"AnonOpenTask","","",null,null],[12,"reads","","",31,null],[12,"read_set","","",31,null],[3,"DepNodeColorMap","","",null,null],[12,"values","","",32,null],[4,"DepNodeColor","","",null,null],[13,"Red","","",21,null],[13,"Green","","",21,null],[4,"WorkProductFileKind","","",null,null],[13,"Object","","",23,null],[13,"Bytecode","","",23,null],[13,"BytecodeCompressed","","",23,null],[4,"OpenTask","","",null,null],[13,"Regular","","",22,null],[13,"Anon","","",22,null],[13,"Ignore","","",22,null],[13,"EvalAlways","","",22,null],[12,"node","rustc::dep_graph::graph::OpenTask","",22,null],[17,"COMPRESSED_NONE","rustc::dep_graph::graph","",null,null],[17,"COMPRESSED_RED","","",null,null],[17,"COMPRESSED_FIRST_GREEN","","",null,null],[11,"clone","rustc::dep_graph","",11,{"inputs":[{"name":"self"}],"output":{"name":"depgraph"}}],[11,"clone","","",13,{"inputs":[{"name":"self"}],"output":{"name":"depnodeindex"}}],[11,"eq","","",13,{"inputs":[{"name":"self"},{"name":"depnodeindex"}],"output":{"name":"bool"}}],[11,"ne","","",13,{"inputs":[{"name":"self"},{"name":"depnodeindex"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",13,null],[11,"hash","","",13,null],[11,"partial_cmp","","",13,{"inputs":[{"name":"self"},{"name":"depnodeindex"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",13,{"inputs":[{"name":"self"},{"name":"depnodeindex"}],"output":{"name":"bool"}}],[11,"le","","",13,{"inputs":[{"name":"self"},{"name":"depnodeindex"}],"output":{"name":"bool"}}],[11,"gt","","",13,{"inputs":[{"name":"self"},{"name":"depnodeindex"}],"output":{"name":"bool"}}],[11,"ge","","",13,{"inputs":[{"name":"self"},{"name":"depnodeindex"}],"output":{"name":"bool"}}],[11,"cmp","","",13,{"inputs":[{"name":"self"},{"name":"depnodeindex"}],"output":{"name":"ordering"}}],[11,"decode","","",13,{"inputs":[{"name":"__d"}],"output":{"generics":["depnodeindex"],"name":"result"}}],[11,"encode","","",13,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"new","","",13,{"inputs":[{"name":"usize"}],"output":{"name":"self"}}],[11,"index","","",13,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"fmt","","",13,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[18,"INVALID","","",13,null],[11,"clone","","",21,{"inputs":[{"name":"self"}],"output":{"name":"depnodecolor"}}],[11,"fmt","","",21,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",21,{"inputs":[{"name":"self"},{"name":"depnodecolor"}],"output":{"name":"bool"}}],[11,"ne","","",21,{"inputs":[{"name":"self"},{"name":"depnodecolor"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",21,null],[11,"hash","","",21,null],[11,"is_green","","",21,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"new","","",11,{"inputs":[{"name":"previousdepgraph"}],"output":{"name":"depgraph"}}],[11,"new_disabled","","",11,{"inputs":[],"output":{"name":"depgraph"}}],[11,"is_fully_enabled","","True if we are actually building the full dep-graph.",11,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"query","","",11,{"inputs":[{"name":"self"}],"output":{"name":"depgraphquery"}}],[11,"assert_ignored","","",11,{"inputs":[{"name":"self"}],"output":null}],[11,"with_ignore","","",11,{"inputs":[{"name":"self"},{"name":"op"}],"output":{"name":"r"}}],[11,"with_task","","Starts a new dep-graph task. Dep-graph tasks are specified using a free function (`task`) and not a closure -- this is intentional because we want to exercise tight control over what state they have access to. In particular, we want to prevent implicit 'leaks' of tracked state into the task (which could then be read without generating correct edges in the dep-graph -- see the [rustc guide] for more details on the dep-graph). To this end, the task function gets exactly two pieces of state: the context `cx` and an argument `arg`. Both of these bits of state must be of some type that implements `DepGraphSafe` and hence does not leak.",11,null],[11,"input_task","","Creates a new dep-graph input with value `input`",11,null],[11,"with_task_impl","","",11,null],[11,"with_anon_task","","Execute something within an \"anonymous\" task, that is, a task the DepNode of which is determined by the list of inputs it read from.",11,null],[11,"with_eval_always_task","","Execute something within an \"eval-always\" task which is a task",11,null],[11,"read","","",11,{"inputs":[{"name":"self"},{"name":"depnode"}],"output":null}],[11,"read_index","","",11,{"inputs":[{"name":"self"},{"name":"depnodeindex"}],"output":null}],[11,"dep_node_index_of","","",11,{"inputs":[{"name":"self"},{"name":"depnode"}],"output":{"name":"depnodeindex"}}],[11,"dep_node_exists","","",11,{"inputs":[{"name":"self"},{"name":"depnode"}],"output":{"name":"bool"}}],[11,"fingerprint_of","","",11,{"inputs":[{"name":"self"},{"name":"depnodeindex"}],"output":{"name":"fingerprint"}}],[11,"prev_fingerprint_of","","",11,{"inputs":[{"name":"self"},{"name":"depnode"}],"output":{"generics":["fingerprint"],"name":"option"}}],[11,"prev_dep_node_index_of","","",11,{"inputs":[{"name":"self"},{"name":"depnode"}],"output":{"name":"serializeddepnodeindex"}}],[11,"insert_previous_work_product","","Indicates that a previous work product exists for `v`. This is invoked during initial start-up based on what nodes are clean (and what files exist in the incr. directory).",11,{"inputs":[{"name":"self"},{"name":"workproductid"},{"name":"workproduct"}],"output":null}],[11,"insert_work_product","","Indicates that we created the given work-product in this run for `v`. This record will be preserved and loaded in the next run.",11,{"inputs":[{"name":"self"},{"name":"workproductid"},{"name":"workproduct"}],"output":null}],[11,"previous_work_product","","Check whether a previous work product exists for `v` and, if so, return the path that leads to it. Used to skip doing work.",11,{"inputs":[{"name":"self"},{"name":"workproductid"}],"output":{"generics":["workproduct"],"name":"option"}}],[11,"work_products","","Access the map of work-products created during this run. Only used during saving of the dep-graph.",11,{"inputs":[{"name":"self"}],"output":{"generics":["fxhashmap"],"name":"readguard"}}],[11,"previous_work_products","","Access the map of work-products created during the cached run. Only used during saving of the dep-graph.",11,{"inputs":[{"name":"self"}],"output":{"generics":["fxhashmap"],"name":"readguard"}}],[11,"register_dep_node_debug_str","","",11,{"inputs":[{"name":"self"},{"name":"depnode"},{"name":"f"}],"output":null}],[11,"dep_node_debug_str","","",11,{"inputs":[{"name":"self"},{"name":"depnode"}],"output":{"generics":["string"],"name":"option"}}],[11,"edge_deduplication_data","","",11,null],[11,"serialize","","",11,{"inputs":[{"name":"self"}],"output":{"name":"serializeddepgraph"}}],[11,"node_color","","",11,{"inputs":[{"name":"self"},{"name":"depnode"}],"output":{"generics":["depnodecolor"],"name":"option"}}],[11,"try_mark_green","","",11,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"depnode"}],"output":{"generics":["depnodeindex"],"name":"option"}}],[11,"is_green","","",11,{"inputs":[{"name":"self"},{"name":"depnode"}],"output":{"name":"bool"}}],[11,"exec_cache_promotions","","",11,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":null}],[11,"mark_loaded_from_cache","","",11,{"inputs":[{"name":"self"},{"name":"depnodeindex"},{"name":"bool"}],"output":null}],[11,"was_loaded_from_cache","","",11,{"inputs":[{"name":"self"},{"name":"depnode"}],"output":{"generics":["bool"],"name":"option"}}],[11,"clone","","",12,{"inputs":[{"name":"self"}],"output":{"name":"workproduct"}}],[11,"fmt","","",12,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",12,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",12,{"inputs":[{"name":"__d"}],"output":{"generics":["workproduct"],"name":"result"}}],[11,"clone","","",23,{"inputs":[{"name":"self"}],"output":{"name":"workproductfilekind"}}],[11,"fmt","","",23,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",23,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",23,{"inputs":[{"name":"__d"}],"output":{"generics":["workproductfilekind"],"name":"result"}}],[11,"new","rustc::dep_graph::graph","",29,{"inputs":[],"output":{"name":"currentdepgraph"}}],[11,"complete_task","","",29,{"inputs":[{"name":"self"},{"name":"depnode"},{"name":"opentask"}],"output":{"name":"depnodeindex"}}],[11,"pop_anon_task","","",29,{"inputs":[{"name":"self"},{"name":"depkind"},{"name":"opentask"}],"output":{"name":"depnodeindex"}}],[11,"complete_eval_always_task","","",29,{"inputs":[{"name":"self"},{"name":"depnode"},{"name":"opentask"}],"output":{"name":"depnodeindex"}}],[11,"read_index","","",29,{"inputs":[{"name":"self"},{"name":"depnodeindex"}],"output":null}],[11,"alloc_node","","",29,{"inputs":[{"name":"self"},{"name":"depnode"},{"generics":["depnodeindex"],"name":"vec"}],"output":{"name":"depnodeindex"}}],[11,"new","","",32,{"inputs":[{"name":"usize"}],"output":{"name":"depnodecolormap"}}],[11,"get","","",32,{"inputs":[{"name":"self"},{"name":"serializeddepnodeindex"}],"output":{"generics":["depnodecolor"],"name":"option"}}],[11,"insert","","",32,{"inputs":[{"name":"self"},{"name":"serializeddepnodeindex"},{"name":"depnodecolor"}],"output":null}],[0,"prev","rustc::dep_graph","",null,null],[3,"PreviousDepGraph","rustc::dep_graph::prev","",null,null],[12,"data","","",14,null],[12,"index","","",14,null],[11,"fmt","rustc::dep_graph","",14,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",14,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",14,{"inputs":[{"name":"__d"}],"output":{"generics":["previousdepgraph"],"name":"result"}}],[11,"new","","",14,{"inputs":[{"name":"serializeddepgraph"}],"output":{"name":"previousdepgraph"}}],[11,"edges_from","","",14,{"inputs":[{"name":"self"},{"name":"depnode"}],"output":{"name":"option"}}],[11,"index_to_node","","",14,{"inputs":[{"name":"self"},{"name":"serializeddepnodeindex"}],"output":{"name":"depnode"}}],[11,"node_to_index","","",14,{"inputs":[{"name":"self"},{"name":"depnode"}],"output":{"name":"serializeddepnodeindex"}}],[11,"node_to_index_opt","","",14,{"inputs":[{"name":"self"},{"name":"depnode"}],"output":{"generics":["serializeddepnodeindex"],"name":"option"}}],[11,"fingerprint_of","","",14,{"inputs":[{"name":"self"},{"name":"depnode"}],"output":{"generics":["fingerprint"],"name":"option"}}],[11,"fingerprint_by_index","","",14,{"inputs":[{"name":"self"},{"name":"serializeddepnodeindex"}],"output":{"name":"fingerprint"}}],[11,"node_count","","",14,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[0,"query","","",null,null],[3,"DepGraphQuery","rustc::dep_graph::query","",null,null],[12,"graph","","",15,null],[12,"indices","","",15,null],[11,"new","rustc::dep_graph","",15,null],[11,"contains_node","","",15,{"inputs":[{"name":"self"},{"name":"depnode"}],"output":{"name":"bool"}}],[11,"nodes","","",15,{"inputs":[{"name":"self"}],"output":{"generics":["depnode"],"name":"vec"}}],[11,"edges","","",15,{"inputs":[{"name":"self"}],"output":{"name":"vec"}}],[11,"reachable_nodes","","",15,{"inputs":[{"name":"self"},{"name":"depnode"},{"name":"direction"}],"output":{"generics":["depnode"],"name":"vec"}}],[11,"transitive_successors","","All nodes reachable from `node`. In other words, things that will have to be recomputed if `node` changes.",15,{"inputs":[{"name":"self"},{"name":"depnode"}],"output":{"generics":["depnode"],"name":"vec"}}],[11,"transitive_predecessors","","All nodes that can reach `node`.",15,{"inputs":[{"name":"self"},{"name":"depnode"}],"output":{"generics":["depnode"],"name":"vec"}}],[11,"immediate_successors","","Just the outgoing edges from `node`.",15,{"inputs":[{"name":"self"},{"name":"depnode"}],"output":{"generics":["depnode"],"name":"vec"}}],[0,"safe","","The `DepGraphSafe` trait",null,null],[3,"AssertDepGraphSafe","rustc::dep_graph::safe","A convenient override that lets you pass arbitrary state into a task. Every use should be accompanied by a comment explaining why it makes sense (or how it could be refactored away in the future).",null,null],[12,"0","","",16,null],[8,"DepGraphSafe","","The `DepGraphSafe` trait is used to specify what kinds of values are safe to \"leak\" into a task. The idea is that this should be only be implemented for things like the tcx as well as various id types, which will create reads in the dep-graph whenever the trait loads anything that might depend on the input program.",null,null],[0,"serialized","rustc::dep_graph","The data that we will serialize and deserialize.",null,null],[3,"SerializedDepNodeIndex","rustc::dep_graph::serialized","",null,null],[12,"0","","",18,null],[3,"SerializedDepGraph","","Data for use when recompiling the current crate.",null,null],[12,"nodes","","The set of all DepNodes in the graph",17,null],[12,"fingerprints","","The set of all Fingerprints in the graph. Each Fingerprint corresponds to the DepNode at the same index in the nodes vector.",17,null],[12,"edge_list_indices","","For each DepNode, stores the list of edges originating from that DepNode. Encoded as a [start, end) pair indexing into edge_list_data, which holds the actual DepNodeIndices of the target nodes.",17,null],[12,"edge_list_data","","A flattened list of all edge targets in the graph. Edge sources are implicit in edge_list_indices.",17,null],[11,"clone","rustc::dep_graph","",18,{"inputs":[{"name":"self"}],"output":{"name":"serializeddepnodeindex"}}],[11,"eq","","",18,{"inputs":[{"name":"self"},{"name":"serializeddepnodeindex"}],"output":{"name":"bool"}}],[11,"ne","","",18,{"inputs":[{"name":"self"},{"name":"serializeddepnodeindex"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",18,null],[11,"hash","","",18,null],[11,"partial_cmp","","",18,{"inputs":[{"name":"self"},{"name":"serializeddepnodeindex"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",18,{"inputs":[{"name":"self"},{"name":"serializeddepnodeindex"}],"output":{"name":"bool"}}],[11,"le","","",18,{"inputs":[{"name":"self"},{"name":"serializeddepnodeindex"}],"output":{"name":"bool"}}],[11,"gt","","",18,{"inputs":[{"name":"self"},{"name":"serializeddepnodeindex"}],"output":{"name":"bool"}}],[11,"ge","","",18,{"inputs":[{"name":"self"},{"name":"serializeddepnodeindex"}],"output":{"name":"bool"}}],[11,"cmp","","",18,{"inputs":[{"name":"self"},{"name":"serializeddepnodeindex"}],"output":{"name":"ordering"}}],[11,"decode","","",18,{"inputs":[{"name":"__d"}],"output":{"generics":["serializeddepnodeindex"],"name":"result"}}],[11,"encode","","",18,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"new","","",18,{"inputs":[{"name":"usize"}],"output":{"name":"self"}}],[11,"index","","",18,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"fmt","","",18,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",17,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",17,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",17,{"inputs":[{"name":"__d"}],"output":{"generics":["serializeddepgraph"],"name":"result"}}],[11,"new","","",17,{"inputs":[],"output":{"name":"serializeddepgraph"}}],[11,"edge_targets_from","","",17,null],[0,"label_strs","","Contains variant => str representations for constructing DepNode groups for tests.",null,null],[17,"Null","rustc::dep_graph::label_strs","",null,null],[17,"Krate","","",null,null],[17,"HirBody","","",null,null],[17,"Hir","","",null,null],[17,"CrateMetadata","","",null,null],[17,"RegionScopeTree","","",null,null],[17,"Coherence","","",null,null],[17,"CoherenceInherentImplOverlapCheck","","",null,null],[17,"CoherenceCheckTrait","","",null,null],[17,"PrivacyAccessLevels","","",null,null],[17,"MirConstQualif","","",null,null],[17,"MirBuilt","","",null,null],[17,"MirConst","","",null,null],[17,"MirValidated","","",null,null],[17,"MirOptimized","","",null,null],[17,"MirShim","","",null,null],[17,"BorrowCheckKrate","","",null,null],[17,"BorrowCheck","","",null,null],[17,"MirBorrowCheck","","",null,null],[17,"UnsafetyCheckResult","","",null,null],[17,"UnsafeDeriveOnReprPacked","","",null,null],[17,"Reachability","","",null,null],[17,"MirKeys","","",null,null],[17,"CrateVariances","","",null,null],[17,"AssociatedItems","","",null,null],[17,"TypeOfItem","","",null,null],[17,"GenericsOfItem","","",null,null],[17,"PredicatesOfItem","","",null,null],[17,"InferredOutlivesOf","","",null,null],[17,"InferredOutlivesCrate","","",null,null],[17,"SuperPredicatesOfItem","","",null,null],[17,"TraitDefOfItem","","",null,null],[17,"AdtDefOfItem","","",null,null],[17,"ImplTraitRef","","",null,null],[17,"ImplPolarity","","",null,null],[17,"FnSignature","","",null,null],[17,"CoerceUnsizedInfo","","",null,null],[17,"ItemVarianceConstraints","","",null,null],[17,"ItemVariances","","",null,null],[17,"IsConstFn","","",null,null],[17,"IsForeignItem","","",null,null],[17,"TypeParamPredicates","","",null,null],[17,"SizedConstraint","","",null,null],[17,"DtorckConstraint","","",null,null],[17,"AdtDestructor","","",null,null],[17,"AssociatedItemDefIds","","",null,null],[17,"InherentImpls","","",null,null],[17,"TypeckBodiesKrate","","",null,null],[17,"TypeckTables","","",null,null],[17,"UsedTraitImports","","",null,null],[17,"HasTypeckTables","","",null,null],[17,"ConstEval","","",null,null],[17,"CheckMatch","","",null,null],[17,"SymbolName","","",null,null],[17,"InstanceSymbolName","","",null,null],[17,"SpecializationGraph","","",null,null],[17,"ObjectSafety","","",null,null],[17,"FulfillObligation","","",null,null],[17,"VtableMethods","","",null,null],[17,"IsCopy","","",null,null],[17,"IsSized","","",null,null],[17,"IsFreeze","","",null,null],[17,"NeedsDrop","","",null,null],[17,"Layout","","",null,null],[17,"TraitImpls","","",null,null],[17,"AllLocalTraitImpls","","",null,null],[17,"TraitSelect","","",null,null],[17,"ParamEnv","","",null,null],[17,"DescribeDef","","",null,null],[17,"DefSpan","","",null,null],[17,"LookupStability","","",null,null],[17,"LookupDeprecationEntry","","",null,null],[17,"ConstIsRvaluePromotableToStatic","","",null,null],[17,"RvaluePromotableMap","","",null,null],[17,"ImplParent","","",null,null],[17,"TraitOfItem","","",null,null],[17,"IsReachableNonGeneric","","",null,null],[17,"IsUnreachableLocalDefinition","","",null,null],[17,"IsMirAvailable","","",null,null],[17,"ItemAttrs","","",null,null],[17,"TransFnAttrs","","",null,null],[17,"FnArgNames","","",null,null],[17,"RenderedConst","","",null,null],[17,"DylibDepFormats","","",null,null],[17,"IsPanicRuntime","","",null,null],[17,"IsCompilerBuiltins","","",null,null],[17,"HasGlobalAllocator","","",null,null],[17,"ExternCrate","","",null,null],[17,"LintLevels","","",null,null],[17,"Specializes","","",null,null],[17,"InScopeTraits","","",null,null],[17,"ModuleExports","","",null,null],[17,"IsSanitizerRuntime","","",null,null],[17,"IsProfilerRuntime","","",null,null],[17,"GetPanicStrategy","","",null,null],[17,"IsNoBuiltins","","",null,null],[17,"ImplDefaultness","","",null,null],[17,"CheckItemWellFormed","","",null,null],[17,"CheckTraitItemWellFormed","","",null,null],[17,"CheckImplItemWellFormed","","",null,null],[17,"ReachableNonGenerics","","",null,null],[17,"NativeLibraries","","",null,null],[17,"PluginRegistrarFn","","",null,null],[17,"DeriveRegistrarFn","","",null,null],[17,"CrateDisambiguator","","",null,null],[17,"CrateHash","","",null,null],[17,"OriginalCrateName","","",null,null],[17,"ExtraFileName","","",null,null],[17,"ImplementationsOfTrait","","",null,null],[17,"AllTraitImplementations","","",null,null],[17,"DllimportForeignItems","","",null,null],[17,"IsDllimportForeignItem","","",null,null],[17,"IsStaticallyIncludedForeignItem","","",null,null],[17,"NativeLibraryKind","","",null,null],[17,"LinkArgs","","",null,null],[17,"ResolveLifetimes","","",null,null],[17,"NamedRegion","","",null,null],[17,"IsLateBound","","",null,null],[17,"ObjectLifetimeDefaults","","",null,null],[17,"Visibility","","",null,null],[17,"DepKind","","",null,null],[17,"CrateName","","",null,null],[17,"ItemChildren","","",null,null],[17,"ExternModStmtCnum","","",null,null],[17,"GetLangItems","","",null,null],[17,"DefinedLangItems","","",null,null],[17,"MissingLangItems","","",null,null],[17,"VisibleParentMap","","",null,null],[17,"MissingExternCrateItem","","",null,null],[17,"UsedCrateSource","","",null,null],[17,"PostorderCnums","","",null,null],[17,"EraseRegionsTy","","",null,null],[17,"Freevars","","",null,null],[17,"MaybeUnusedTraitImport","","",null,null],[17,"MaybeUnusedExternCrates","","",null,null],[17,"StabilityIndex","","",null,null],[17,"AllTraits","","",null,null],[17,"AllCrateNums","","",null,null],[17,"ExportedSymbols","","",null,null],[17,"CollectAndPartitionTranslationItems","","",null,null],[17,"IsTranslatedItem","","",null,null],[17,"CodegenUnit","","",null,null],[17,"CompileCodegenUnit","","",null,null],[17,"OutputFilenames","","",null,null],[17,"NormalizeProjectionTy","","",null,null],[17,"NormalizeTyAfterErasingRegions","","",null,null],[17,"DropckOutlives","","",null,null],[17,"EvaluateObligation","","",null,null],[17,"SubstituteNormalizeAndTestPredicates","","",null,null],[17,"TargetFeaturesWhitelist","","",null,null],[17,"InstanceDefSizeEstimate","","",null,null],[17,"WasmCustomSections","","",null,null],[17,"Features","","",null,null],[17,"ProgramClausesFor","","",null,null],[17,"ProgramClausesForEnv","","",null,null],[17,"WasmImportModuleMap","","",null,null],[17,"ForeignModules","","",null,null],[17,"UpstreamMonomorphizations","","",null,null],[17,"UpstreamMonomorphizationsFor","","",null,null],[8,"DepTrackingMapConfig","rustc::dep_graph","",null,null],[16,"Key","","",27,null],[16,"Value","","",27,null],[10,"to_dep_kind","","",27,{"inputs":[],"output":{"name":"depkind"}}],[8,"DepGraphSafe","","The `DepGraphSafe` trait is used to specify what kinds of values are safe to \"leak\" into a task. The idea is that this should be only be implemented for things like the tcx as well as various id types, which will create reads in the dep-graph whenever the trait loads anything that might depend on the input program.",null,null],[0,"hir","rustc","",null,null],[3,"HirId","rustc::hir","A HirId uniquely identifies a node in the HIR of the current crate. It is composed of the `owner`, which is the DefIndex of the directly enclosing hir::Item, hir::TraitItem, or hir::ImplItem (i.e. the closest \"item-like\"), and the `local_id` which is unique within the given owner.",null,null],[12,"owner","","",33,null],[12,"local_id","","",33,null],[3,"ItemLocalId","","An `ItemLocalId` uniquely identifies something within a given \"item-like\", that is within a hir::Item, hir::TraitItem, or hir::ImplItem. There is no guarantee that the numerical value of a given `ItemLocalId` corresponds to the node's position within the owning item in any way, but there is a guarantee that the `LocalItemId`s within an owner occupy a dense range of integers starting at zero, so a mapping that maps all or most nodes within an \"item-like\" to something else can be implement by a `Vec` instead of a tree or hash map.",null,null],[12,"0","","",34,null],[3,"Label","","",null,null],[12,"name","","",35,null],[12,"span","","",35,null],[3,"Lifetime","","",null,null],[12,"id","","",36,null],[12,"span","","",36,null],[12,"name","","Either \"'a\", referring to a named lifetime definition, or \"\" (aka keywords::Invalid), for elision placeholders.",36,null],[3,"LifetimeDef","","A lifetime definition, eg `'a: 'b+'c+'d`",null,null],[12,"lifetime","","",37,null],[12,"bounds","","",37,null],[12,"pure_wrt_drop","","",37,null],[12,"in_band","","",37,null],[3,"Path","","A \"Path\" is essentially Rust's notion of a name; for instance: `std::cmp::PartialEq`. It's represented as a sequence of identifiers, along with a bunch of supporting information.",null,null],[12,"span","","",38,null],[12,"def","","The definition that the path resolved to.",38,null],[12,"segments","","The segments in the path: the things separated by `::`.",38,null],[3,"PathSegment","","A segment of a path: an identifier, an optional lifetime, and a set of types.",null,null],[12,"name","","The identifier portion of this path segment.",39,null],[12,"parameters","","Type/lifetime parameters attached to this path. They come in two flavors: `Path<A,B,C>` and `Path(A,B) -> C`. Note that this is more than just simple syntactic sugar; the use of parens affects the region binding rules, so we preserve the distinction.",39,null],[12,"infer_types","","Whether to infer remaining type parameters, if any. This only applies to expression and pattern paths, and out of those only the segments with no type parameters to begin with, e.g. `Vec::new` is `<Vec<..>>::new::<..>`.",39,null],[3,"PathParameters","","",null,null],[12,"lifetimes","","The lifetime parameters for this path segment.",40,null],[12,"types","","The type parameters for this path segment, if present.",40,null],[12,"bindings","","Bindings (equality constraints) on associated types, if present. E.g., `Foo<A=Bar>`.",40,null],[12,"parenthesized","","Were parameters written in parenthesized form `Fn(T) -> U`? This is required mostly for pretty-printing and diagnostics, but also for changing lifetime elision rules to be \"function-like\".",40,null],[3,"TyParam","","",null,null],[12,"name","","",41,null],[12,"id","","",41,null],[12,"bounds","","",41,null],[12,"default","","",41,null],[12,"span","","",41,null],[12,"pure_wrt_drop","","",41,null],[12,"synthetic","","",41,null],[12,"attrs","","",41,null],[3,"Generics","","Represents lifetimes and type parameters attached to a declaration of a function, enum, trait, etc.",null,null],[12,"params","","",42,null],[12,"where_clause","","",42,null],[12,"span","","",42,null],[3,"WhereClause","","A `where` clause in a definition",null,null],[12,"id","","",43,null],[12,"predicates","","",43,null],[3,"WhereBoundPredicate","","A type bound, eg `for<'c> Foo: Send+Clone+'c`",null,null],[12,"span","","",44,null],[12,"bound_generic_params","","Any generics from a `for` binding",44,null],[12,"bounded_ty","","The type being bounded",44,null],[12,"bounds","","Trait and lifetime bounds (`Clone+Send+'static`)",44,null],[3,"WhereRegionPredicate","","A lifetime predicate, e.g. `'a: 'b+'c`",null,null],[12,"span","","",45,null],[12,"lifetime","","",45,null],[12,"bounds","","",45,null],[3,"WhereEqPredicate","","An equality predicate (unsupported), e.g. `T=int`",null,null],[12,"id","","",46,null],[12,"span","","",46,null],[12,"lhs_ty","","",46,null],[12,"rhs_ty","","",46,null],[3,"Crate","","The top-level data structure that stores the entire contents of the crate currently being compiled.",null,null],[12,"module","","",47,null],[12,"attrs","","",47,null],[12,"span","","",47,null],[12,"exported_macros","","",47,null],[12,"items","","",47,null],[12,"trait_items","","",47,null],[12,"impl_items","","",47,null],[12,"bodies","","",47,null],[12,"trait_impls","","",47,null],[12,"trait_auto_impl","","",47,null],[12,"body_ids","","A list of the body ids written out in the order in which they appear in the crate. If you're going to process all the bodies in the crate, you should iterate over this list rather than the keys of bodies.",47,null],[3,"MacroDef","","A macro definition, in this crate or imported from another.",null,null],[12,"name","","",48,null],[12,"vis","","",48,null],[12,"attrs","","",48,null],[12,"id","","",48,null],[12,"span","","",48,null],[12,"body","","",48,null],[12,"legacy","","",48,null],[3,"Block","","",null,null],[12,"stmts","","Statements in a block",49,null],[12,"expr","","An expression at the end of the block without a semicolon, if any",49,null],[12,"id","","",49,null],[12,"hir_id","","",49,null],[12,"rules","","Distinguishes between `unsafe { ... }` and `{ ... }`",49,null],[12,"span","","",49,null],[12,"targeted_by_break","","If true, then there may exist `break 'a` values that aim to break out of this block early. As of this writing, this is not currently permitted in Rust itself, but it is generated as part of `catch` statements.",49,null],[12,"recovered","","If true, don't emit return value type errors as the parser had to recover from a parse error so this block will not have an appropriate type. A parse error will have been emitted so the compilation will never succeed if this is true.",49,null],[3,"Pat","","",null,null],[12,"id","","",50,null],[12,"hir_id","","",50,null],[12,"node","","",50,null],[12,"span","","",50,null],[3,"FieldPat","","A single field in a struct pattern",null,null],[12,"id","","",51,null],[12,"name","","The identifier for the field",51,null],[12,"pat","","The pattern the field is destructured to",51,null],[12,"is_shorthand","","",51,null],[3,"Local","","Local represents a `let` statement, e.g., `let <pat>:<ty> = <expr>;`",null,null],[12,"pat","","",52,null],[12,"ty","","",52,null],[12,"init","","Initializer expression to set the value, if any",52,null],[12,"id","","",52,null],[12,"hir_id","","",52,null],[12,"span","","",52,null],[12,"attrs","","",52,null],[12,"source","","",52,null],[3,"Arm","","represents one arm of a 'match'",null,null],[12,"attrs","","",53,null],[12,"pats","","",53,null],[12,"guard","","",53,null],[12,"body","","",53,null],[3,"Field","","",null,null],[12,"id","","",54,null],[12,"name","","",54,null],[12,"expr","","",54,null],[12,"span","","",54,null],[12,"is_shorthand","","",54,null],[3,"BodyId","","",null,null],[12,"node_id","","",55,null],[3,"Body","","The body of a function, closure, or constant value. In the case of a function, the body contains not only the function body itself (which is an expression), but also the argument patterns, since those are something that the caller doesn't really care about.",null,null],[12,"arguments","","",56,null],[12,"value","","",56,null],[12,"is_generator","","",56,null],[3,"Expr","","An expression",null,null],[12,"id","","",57,null],[12,"span","","",57,null],[12,"node","","",57,null],[12,"attrs","","",57,null],[12,"hir_id","","",57,null],[3,"Destination","","",null,null],[12,"label","","",58,null],[12,"target_id","","",58,null],[3,"MutTy","","",null,null],[12,"ty","","",59,null],[12,"mutbl","","",59,null],[3,"MethodSig","","Represents a method's signature in a trait declaration or implementation.",null,null],[12,"unsafety","","",60,null],[12,"constness","","",60,null],[12,"abi","","",60,null],[12,"decl","","",60,null],[3,"TraitItemId","","",null,null],[12,"node_id","","",61,null],[3,"TraitItem","","Represents an item declaration within a trait declaration, possibly including a default implementation. A trait item is either required (meaning it doesn't have an implementation, just a signature) or provided (meaning it has a default implementation).",null,null],[12,"id","","",62,null],[12,"name","","",62,null],[12,"hir_id","","",62,null],[12,"attrs","","",62,null],[12,"generics","","",62,null],[12,"node","","",62,null],[12,"span","","",62,null],[3,"ImplItemId","","",null,null],[12,"node_id","","",63,null],[3,"ImplItem","","Represents anything within an `impl` block",null,null],[12,"id","","",64,null],[12,"name","","",64,null],[12,"hir_id","","",64,null],[12,"vis","","",64,null],[12,"defaultness","","",64,null],[12,"attrs","","",64,null],[12,"generics","","",64,null],[12,"node","","",64,null],[12,"span","","",64,null],[3,"TypeBinding","","",null,null],[12,"id","","",65,null],[12,"name","","",65,null],[12,"ty","","",65,null],[12,"span","","",65,null],[3,"Ty","","",null,null],[12,"id","","",66,null],[12,"node","","",66,null],[12,"span","","",66,null],[12,"hir_id","","",66,null],[3,"BareFnTy","","",null,null],[12,"unsafety","","",67,null],[12,"abi","","",67,null],[12,"generic_params","","",67,null],[12,"decl","","",67,null],[12,"arg_names","","",67,null],[3,"ExistTy","","",null,null],[12,"generics","","",68,null],[12,"bounds","","",68,null],[3,"InlineAsmOutput","","",null,null],[12,"constraint","","",69,null],[12,"is_rw","","",69,null],[12,"is_indirect","","",69,null],[3,"InlineAsm","","",null,null],[12,"asm","","",70,null],[12,"asm_str_style","","",70,null],[12,"outputs","","",70,null],[12,"inputs","","",70,null],[12,"clobbers","","",70,null],[12,"volatile","","",70,null],[12,"alignstack","","",70,null],[12,"dialect","","",70,null],[12,"ctxt","","",70,null],[3,"Arg","","represents an argument in a function header",null,null],[12,"pat","","",71,null],[12,"id","","",71,null],[12,"hir_id","","",71,null],[3,"FnDecl","","Represents the header (not the body) of a function declaration",null,null],[12,"inputs","","",72,null],[12,"output","","",72,null],[12,"variadic","","",72,null],[12,"has_implicit_self","","True if this function has an `self`, `&self` or `&mut self` receiver (but not a `self: Xxx` one).",72,null],[3,"Mod","","",null,null],[12,"inner","","A span from the first token past `{` to the last token until `}`. For `mod foo;`, the inner span ranges from the first token to the last token in the external file.",73,null],[12,"item_ids","","",73,null],[3,"ForeignMod","","",null,null],[12,"abi","","",74,null],[12,"items","","",74,null],[3,"GlobalAsm","","",null,null],[12,"asm","","",75,null],[12,"ctxt","","",75,null],[3,"EnumDef","","",null,null],[12,"variants","","",76,null],[3,"Variant_","","",null,null],[12,"name","","",77,null],[12,"attrs","","",77,null],[12,"data","","",77,null],[12,"disr_expr","","Explicit discriminant, eg `Foo = 1`",77,null],[3,"TraitRef","","TraitRef's appear in impls.",null,null],[12,"path","","",78,null],[12,"ref_id","","",78,null],[3,"PolyTraitRef","","",null,null],[12,"bound_generic_params","","The `'a` in `<'a> Foo<&'a T>`",79,null],[12,"trait_ref","","The `Foo<&'a T>` in `<'a> Foo<&'a T>`",79,null],[12,"span","","",79,null],[3,"StructField","","",null,null],[12,"span","","",80,null],[12,"name","","",80,null],[12,"vis","","",80,null],[12,"id","","",80,null],[12,"ty","","",80,null],[12,"attrs","","",80,null],[3,"ItemId","","",null,null],[12,"id","","",81,null],[3,"Item","","An item",null,null],[12,"name","","",82,null],[12,"id","","",82,null],[12,"hir_id","","",82,null],[12,"attrs","","",82,null],[12,"node","","",82,null],[12,"vis","","",82,null],[12,"span","","",82,null],[3,"TraitItemRef","","A reference from an trait to one of its associated items. This contains the item's id, naturally, but also the item's name and some other high-level details (like whether it is an associated type or method, and whether it is public). This allows other passes to find the impl they want without loading the id (which means fewer edges in the incremental compilation graph).",null,null],[12,"id","","",83,null],[12,"name","","",83,null],[12,"kind","","",83,null],[12,"span","","",83,null],[12,"defaultness","","",83,null],[3,"ImplItemRef","","A reference from an impl to one of its associated items. This contains the item's id, naturally, but also the item's name and some other high-level details (like whether it is an associated type or method, and whether it is public). This allows other passes to find the impl they want without loading the id (which means fewer edges in the incremental compilation graph).",null,null],[12,"id","","",84,null],[12,"name","","",84,null],[12,"kind","","",84,null],[12,"span","","",84,null],[12,"vis","","",84,null],[12,"defaultness","","",84,null],[3,"ForeignItem","","",null,null],[12,"name","","",85,null],[12,"attrs","","",85,null],[12,"node","","",85,null],[12,"id","","",85,null],[12,"span","","",85,null],[12,"vis","","",85,null],[3,"Freevar","","A free variable referred to in a function.",null,null],[12,"def","","The variable being accessed free.",86,null],[12,"span","","",86,null],[3,"TraitCandidate","","",null,null],[12,"def_id","","",87,null],[12,"import_id","","",87,null],[3,"TransFnAttrs","","",null,null],[12,"flags","","",88,null],[12,"inline","","",88,null],[12,"export_name","","",88,null],[12,"target_features","","",88,null],[12,"linkage","","",88,null],[3,"TransFnAttrFlags","","",null,null],[12,"bits","","",89,null],[4,"LifetimeName","","",null,null],[13,"Implicit","","User typed nothing. e.g. the lifetime in `&u32`.",90,null],[13,"Underscore","","User typed `'_`.",90,null],[13,"Fresh","","Synthetic name generated when user elided a lifetime in an impl header, e.g. the lifetimes in cases like these:",90,null],[13,"Static","","User wrote `'static`",90,null],[13,"Name","","Some user-given name like `'x`",90,null],[4,"TyParamBound","","The AST represents all type param bounds as types. typeck::collect::compute_bounds matches these against the \"special\" built-in traits (see middle::lang_items) and detects Copy, Send and Sync.",null,null],[13,"TraitTyParamBound","","",91,null],[13,"RegionTyParamBound","","",91,null],[4,"TraitBoundModifier","","A modifier on a bound, currently this is only used for `?Sized`, where the modifier is `Maybe`. Negative bounds should also be handled here.",null,null],[13,"None","","",92,null],[13,"Maybe","","",92,null],[4,"GenericParam","","",null,null],[13,"Lifetime","","",93,null],[13,"Type","","",93,null],[4,"UnsafeGeneric","","",null,null],[13,"Region","","",94,null],[13,"Type","","",94,null],[4,"SyntheticTyParamKind","","Synthetic Type Parameters are converted to an other form during lowering, this allows to track the original form they had. Useful for error messages.",null,null],[13,"ImplTrait","","",95,null],[4,"WherePredicate","","A single predicate in a `where` clause",null,null],[13,"BoundPredicate","","A type binding, eg `for<'c> Foo: Send+Clone+'c`",96,null],[13,"RegionPredicate","","A lifetime predicate, e.g. `'a: 'b+'c`",96,null],[13,"EqPredicate","","An equality predicate (unsupported)",96,null],[4,"BindingAnnotation","","Explicit binding annotations given in the HIR for a binding. Note that this is not the final binding mode that we infer after type inference.",null,null],[13,"Unannotated","","No binding annotation given: this means that the final binding mode will depend on whether we have skipped through a `&` reference when matching. For example, the `x` in `Some(x)` will have binding mode `None`; if you do `let Some(x) = &Some(22)`, it will ultimately be inferred to be by-reference.",97,null],[13,"Mutable","","Annotated with `mut x` -- could be either ref or not, similar to `None`.",97,null],[13,"Ref","","Annotated as `ref`, like `ref x`",97,null],[13,"RefMut","","Annotated as `ref mut x`.",97,null],[4,"RangeEnd","","",null,null],[13,"Included","","",98,null],[13,"Excluded","","",98,null],[4,"PatKind","","",null,null],[13,"Wild","","Represents a wildcard pattern (`_`)",99,null],[13,"Binding","","A fresh binding `ref mut binding @ OPT_SUBPATTERN`. The `NodeId` is the canonical ID for the variable being bound, e.g. in `Ok(x) | Err(x)`, both `x` use the same canonical ID, which is the pattern ID of the first `x`.",99,null],[13,"Struct","","A struct or struct variant pattern, e.g. `Variant {x, y, ..}`. The `bool` is `true` in the presence of a `..`.",99,null],[13,"TupleStruct","","A tuple struct/variant pattern `Variant(x, y, .., z)`. If the `..` pattern fragment is present, then `Option<usize>` denotes its position. 0 <= position <= subpats.len()",99,null],[13,"Path","","A path pattern for an unit struct/variant or a (maybe-associated) constant.",99,null],[13,"Tuple","","A tuple pattern `(a, b)`. If the `..` pattern fragment is present, then `Option<usize>` denotes its position. 0 <= position <= subpats.len()",99,null],[13,"Box","","A `box` pattern",99,null],[13,"Ref","","A reference pattern, e.g. `&mut (a, b)`",99,null],[13,"Lit","","A literal",99,null],[13,"Range","","A range pattern, e.g. `1...2` or `1..2`",99,null],[13,"Slice","","`[a, b, ..i, y, z]` is represented as: `PatKind::Slice(box [a, b], Some(i), box [y, z])`",99,null],[4,"Mutability","","",null,null],[13,"MutMutable","","",100,null],[13,"MutImmutable","","",100,null],[4,"BinOp_","","",null,null],[13,"BiAdd","","The `+` operator (addition)",101,null],[13,"BiSub","","The `-` operator (subtraction)",101,null],[13,"BiMul","","The `*` operator (multiplication)",101,null],[13,"BiDiv","","The `/` operator (division)",101,null],[13,"BiRem","","The `%` operator (modulus)",101,null],[13,"BiAnd","","The `&&` operator (logical and)",101,null],[13,"BiOr","","The `||` operator (logical or)",101,null],[13,"BiBitXor","","The `^` operator (bitwise xor)",101,null],[13,"BiBitAnd","","The `&` operator (bitwise and)",101,null],[13,"BiBitOr","","The `|` operator (bitwise or)",101,null],[13,"BiShl","","The `<<` operator (shift left)",101,null],[13,"BiShr","","The `>>` operator (shift right)",101,null],[13,"BiEq","","The `==` operator (equality)",101,null],[13,"BiLt","","The `<` operator (less than)",101,null],[13,"BiLe","","The `<=` operator (less than or equal to)",101,null],[13,"BiNe","","The `!=` operator (not equal to)",101,null],[13,"BiGe","","The `>=` operator (greater than or equal to)",101,null],[13,"BiGt","","The `>` operator (greater than)",101,null],[4,"UnOp","","",null,null],[13,"UnDeref","","The `*` operator for dereferencing",102,null],[13,"UnNot","","The `!` operator for logical inversion",102,null],[13,"UnNeg","","The `-` operator for negation",102,null],[4,"Stmt_","","",null,null],[13,"StmtDecl","","Could be an item or a local (let) binding:",103,null],[13,"StmtExpr","","Expr without trailing semi-colon (must have unit type):",103,null],[13,"StmtSemi","","Expr with trailing semi-colon (may have any type):",103,null],[4,"Decl_","","",null,null],[13,"DeclLocal","","A local (let) binding:",104,null],[13,"DeclItem","","An item binding:",104,null],[4,"BlockCheckMode","","",null,null],[13,"DefaultBlock","","",105,null],[13,"UnsafeBlock","","",105,null],[13,"PushUnsafeBlock","","",105,null],[13,"PopUnsafeBlock","","",105,null],[4,"UnsafeSource","","",null,null],[13,"CompilerGenerated","","",106,null],[13,"UserProvided","","",106,null],[4,"BodyOwnerKind","","",null,null],[13,"Fn","","Functions and methods.",107,null],[13,"Const","","Constants and associated constants.",107,null],[13,"Static","","Initializer of a `static` item.",107,null],[4,"Expr_","","",null,null],[13,"ExprBox","","A `box x` expression.",108,null],[13,"ExprArray","","An array (`[a, b, c, d]`)",108,null],[13,"ExprCall","","A function call",108,null],[13,"ExprMethodCall","","A method call (`x.foo::<'static, Bar, Baz>(a, b, c, d)`)",108,null],[13,"ExprTup","","A tuple (`(a, b, c ,d)`)",108,null],[13,"ExprBinary","","A binary operation (For example: `a + b`, `a * b`)",108,null],[13,"ExprUnary","","A unary operation (For example: `!x`, `*x`)",108,null],[13,"ExprLit","","A literal (For example: `1`, `\"foo\"`)",108,null],[13,"ExprCast","","A cast (`foo as f64`)",108,null],[13,"ExprType","","",108,null],[13,"ExprIf","","An `if` block, with an optional else block",108,null],[13,"ExprWhile","","A while loop, with an optional label",108,null],[13,"ExprLoop","","Conditionless loop (can be exited with break, continue, or return)",108,null],[13,"ExprMatch","","A `match` block, with a source that indicates whether or not it is the result of a desugaring, and if so, which kind.",108,null],[13,"ExprClosure","","A closure (for example, `move |a, b, c| {a + b + c}`).",108,null],[13,"ExprBlock","","A block (`{ ... }`)",108,null],[13,"ExprAssign","","An assignment (`a = foo()`)",108,null],[13,"ExprAssignOp","","An assignment with an operator",108,null],[13,"ExprField","","Access of a named (`obj.foo`) or unnamed (`obj.0`) struct or tuple field",108,null],[13,"ExprIndex","","An indexing operation (`foo[2]`)",108,null],[13,"ExprPath","","Path to a definition, possibly containing lifetime or type parameters.",108,null],[13,"ExprAddrOf","","A referencing operation (`&a` or `&mut a`)",108,null],[13,"ExprBreak","","A `break`, with an optional label to break",108,null],[13,"ExprAgain","","A `continue`, with an optional label",108,null],[13,"ExprRet","","A `return`, with an optional value to be returned",108,null],[13,"ExprInlineAsm","","Inline assembly (from `asm!`), with its outputs and inputs.",108,null],[13,"ExprStruct","","A struct or struct-like variant literal expression.",108,null],[13,"ExprRepeat","","An array literal constructed from one repeated element.",108,null],[13,"ExprYield","","A suspension point for generators. This is `yield <expr>` in Rust.",108,null],[4,"QPath","","Optionally `Self`-qualified value/type path or associated extension.",null,null],[13,"Resolved","","Path to a definition, optionally \"fully-qualified\" with a `Self` type, if the path points to an associated item in a trait.",109,null],[13,"TypeRelative","","Type-related paths, e.g. `<T>::default` or `<T>::Output`. Will be resolved by type-checking to an associated item.",109,null],[4,"LocalSource","","Hints at the original code for a let statement",null,null],[13,"Normal","","A `match _ { .. }`",110,null],[13,"ForLoopDesugar","","A desugared `for _ in _ { .. }` loop",110,null],[4,"MatchSource","","Hints at the original code for a `match _ { .. }`",null,null],[13,"Normal","","A `match _ { .. }`",111,null],[13,"IfLetDesugar","","An `if let _ = _ { .. }` (optionally with `else { .. }`)",111,null],[12,"contains_else_clause","rustc::hir::MatchSource","",111,null],[13,"WhileLetDesugar","rustc::hir","A `while let _ = _ { .. }` (which was desugared to a `loop { match _ { .. } }`)",111,null],[13,"ForLoopDesugar","","A desugared `for _ in _ { .. }` loop",111,null],[13,"TryDesugar","","A desugared `?` operator",111,null],[4,"LoopSource","","The loop type that yielded an ExprLoop",null,null],[13,"Loop","","A `loop { .. }` loop",112,null],[13,"WhileLet","","A `while let _ = _ { .. }` loop",112,null],[13,"ForLoop","","A `for _ in _ { .. }` loop",112,null],[4,"LoopIdError","","",null,null],[13,"OutsideLoopScope","","",113,null],[13,"UnlabeledCfInWhileCondition","","",113,null],[13,"UnresolvedLabel","","",113,null],[4,"LoopIdResult","","",null,null],[13,"Ok","","",114,null],[13,"Err","","",114,null],[4,"ScopeTarget","","",null,null],[13,"Block","","",115,null],[13,"Loop","","",115,null],[4,"GeneratorMovability","","",null,null],[13,"Static","","",116,null],[13,"Movable","","",116,null],[4,"CaptureClause","","",null,null],[13,"CaptureByValue","","",117,null],[13,"CaptureByRef","","",117,null],[4,"TraitMethod","","A trait method's body (or just argument names).",null,null],[13,"Required","","No default body in the trait, just a signature.",118,null],[13,"Provided","","Both signature and body are provided in the trait.",118,null],[4,"TraitItemKind","","Represents a trait method or associated constant or type",null,null],[13,"Const","","An associated constant with an optional value (otherwise `impl`s must contain a value)",119,null],[13,"Method","","A method with an optional body",119,null],[13,"Type","","An associated type with (possibly empty) bounds and optional concrete type",119,null],[4,"ImplItemKind","","Represents different contents within `impl`s",null,null],[13,"Const","","An associated constant of the given type, set to the constant result of the expression",120,null],[13,"Method","","A method implementation with the given signature and body",120,null],[13,"Type","","An associated type",120,null],[4,"PrimTy","","Not represented directly in the AST, referred to by name through a ty_path.",null,null],[13,"TyInt","","",121,null],[13,"TyUint","","",121,null],[13,"TyFloat","","",121,null],[13,"TyStr","","",121,null],[13,"TyBool","","",121,null],[13,"TyChar","","",121,null],[4,"Ty_","","The different kinds of types recognized by the compiler",null,null],[13,"TySlice","","A variable length slice (`[T]`)",122,null],[13,"TyArray","","A fixed length array (`[T; n]`)",122,null],[13,"TyPtr","","A raw pointer (`*const T` or `*mut T`)",122,null],[13,"TyRptr","","A reference (`&'a T` or `&'a mut T`)",122,null],[13,"TyBareFn","","A bare function (e.g. `fn(usize) -> bool`)",122,null],[13,"TyNever","","The never type (`!`)",122,null],[13,"TyTup","","A tuple (`(A, B, C, D,...)`)",122,null],[13,"TyPath","","A path to a type definition (`module::module::...::Type`), or an associated type, e.g. `<Vec<T> as Trait>::Type` or `<T>::Target`.",122,null],[13,"TyTraitObject","","A trait object type `Bound1 + Bound2 + Bound3` where `Bound` is a trait or a lifetime.",122,null],[13,"TyImplTraitExistential","","An existentially quantified (there exists a type satisfying) `impl Bound1 + Bound2 + Bound3` type where `Bound` is a trait or a lifetime.",122,null],[13,"TyTypeof","","Unused for now",122,null],[13,"TyInfer","","TyInfer means the type should be inferred instead of it having been specified. This can appear anywhere in a type.",122,null],[13,"TyErr","","Placeholder for a type that has failed to be defined.",122,null],[4,"IsAuto","","Is the trait definition an auto trait?",null,null],[13,"Yes","","",123,null],[13,"No","","",123,null],[4,"Unsafety","","",null,null],[13,"Unsafe","","",124,null],[13,"Normal","","",124,null],[4,"Constness","","",null,null],[13,"Const","","",125,null],[13,"NotConst","","",125,null],[4,"Defaultness","","",null,null],[13,"Default","","",126,null],[12,"has_value","rustc::hir::Defaultness","",126,null],[13,"Final","rustc::hir","",126,null],[4,"ImplPolarity","","",null,null],[13,"Positive","","`impl Trait for Type`",127,null],[13,"Negative","","`impl !Trait for Type`",127,null],[4,"FunctionRetTy","","",null,null],[13,"DefaultReturn","","Return type is not specified.",128,null],[13,"Return","","Everything else",128,null],[4,"UseKind","","",null,null],[13,"Single","","One import, e.g. `use foo::bar` or `use foo::bar as baz`. Also produced for each element of a list `use`, e.g.",129,null],[13,"Glob","","Glob import, e.g. `use foo::*`.",129,null],[13,"ListStem","","Degenerate list import, e.g. `use foo::{a, b}` produces an additional `use foo::{}` for performing checks such as unstable feature gating. May be removed in the future.",129,null],[4,"Visibility","","",null,null],[13,"Public","","",130,null],[13,"Crate","","",130,null],[13,"Restricted","","",130,null],[12,"path","rustc::hir::Visibility","",130,null],[12,"id","","",130,null],[13,"Inherited","rustc::hir","",130,null],[4,"VariantData","","Fields and Ids of enum variants and structs",null,null],[13,"Struct","","",131,null],[13,"Tuple","","",131,null],[13,"Unit","","",131,null],[4,"Item_","","",null,null],[13,"ItemExternCrate","","An `extern crate` item, with optional original crate name if the crate was renamed.",132,null],[13,"ItemUse","","`use foo::bar::*;` or `use foo::bar::baz as quux;`",132,null],[13,"ItemStatic","","A `static` item",132,null],[13,"ItemConst","","A `const` item",132,null],[13,"ItemFn","","A function declaration",132,null],[13,"ItemMod","","A module",132,null],[13,"ItemForeignMod","","An external module",132,null],[13,"ItemGlobalAsm","","Module-level inline assembly (from global_asm!)",132,null],[13,"ItemTy","","A type alias, e.g. `type Foo = Bar<u8>`",132,null],[13,"ItemEnum","","An enum definition, e.g. `enum Foo<A, B> {C<A>, D<B>}`",132,null],[13,"ItemStruct","","A struct definition, e.g. `struct Foo<A> {x: A}`",132,null],[13,"ItemUnion","","A union definition, e.g. `union Foo<A, B> {x: A, y: B}`",132,null],[13,"ItemTrait","","Represents a Trait Declaration",132,null],[13,"ItemTraitAlias","","Represents a Trait Alias Declaration",132,null],[13,"ItemImpl","","An implementation, eg `impl<A> Trait for Foo { .. }`",132,null],[4,"AssociatedItemKind","","",null,null],[13,"Const","","",133,null],[13,"Method","","",133,null],[12,"has_self","rustc::hir::AssociatedItemKind","",133,null],[13,"Type","rustc::hir","",133,null],[4,"ForeignItem_","","An item within an `extern` block",null,null],[13,"ForeignItemFn","","A foreign function",134,null],[13,"ForeignItemStatic","","A foreign static item (`static ext: u8`), with optional mutability (the boolean is true when mutable)",134,null],[13,"ForeignItemType","","A foreign type",134,null],[5,"provide","","",null,{"inputs":[{"name":"providers"}],"output":null}],[0,"check_attr","","This module implements some validity checks for attributes. In particular it verifies that `#[inline]` and `#[repr]` attributes are attached to items that actually support them and if there are conflicts between multiple such attributes attached to the same item.",null,null],[3,"CheckAttrVisitor","rustc::hir::check_attr","",null,null],[12,"tcx","","",135,null],[4,"Target","","",null,null],[13,"Fn","","",136,null],[13,"Struct","","",136,null],[13,"Union","","",136,null],[13,"Enum","","",136,null],[13,"Const","","",136,null],[13,"ForeignMod","","",136,null],[13,"Expression","","",136,null],[13,"Statement","","",136,null],[13,"Closure","","",136,null],[13,"Static","","",136,null],[13,"Other","","",136,null],[5,"check_crate","","",null,{"inputs":[{"name":"tyctxt"}],"output":null}],[5,"is_c_like_enum","","",null,{"inputs":[{"name":"item"}],"output":{"name":"bool"}}],[11,"clone","","",136,{"inputs":[{"name":"self"}],"output":{"name":"target"}}],[11,"eq","","",136,{"inputs":[{"name":"self"},{"name":"target"}],"output":{"name":"bool"}}],[11,"from_item","","",136,{"inputs":[{"name":"item"}],"output":{"name":"target"}}],[11,"check_attributes","","Check any attribute.",135,{"inputs":[{"name":"self"},{"name":"item"},{"name":"target"}],"output":null}],[11,"check_inline","","Check if an `#[inline]` is applied to a function or a closure.",135,{"inputs":[{"name":"self"},{"name":"attribute"},{"name":"span"},{"name":"target"}],"output":null}],[11,"check_non_exhaustive","","Check if the `#[non_exhaustive]` attribute on an `item` is valid.",135,{"inputs":[{"name":"self"},{"name":"attribute"},{"name":"item"},{"name":"target"}],"output":null}],[11,"check_repr","","Check if the `#[repr]` attributes on `item` are valid.",135,{"inputs":[{"name":"self"},{"name":"item"},{"name":"target"}],"output":null}],[11,"emit_repr_error","","",135,{"inputs":[{"name":"self"},{"name":"span"},{"name":"span"},{"name":"str"},{"name":"str"}],"output":null}],[11,"check_stmt_attributes","","",135,{"inputs":[{"name":"self"},{"name":"stmt"}],"output":null}],[11,"check_expr_attributes","","",135,{"inputs":[{"name":"self"},{"name":"expr"}],"output":null}],[11,"check_used","","",135,{"inputs":[{"name":"self"},{"name":"item"},{"name":"target"}],"output":null}],[11,"nested_visit_map","","",135,{"inputs":[{"name":"self"}],"output":{"name":"nestedvisitormap"}}],[11,"visit_item","","",135,{"inputs":[{"name":"self"},{"name":"item"}],"output":null}],[11,"visit_stmt","","",135,{"inputs":[{"name":"self"},{"name":"stmt"}],"output":null}],[11,"visit_expr","","",135,{"inputs":[{"name":"self"},{"name":"expr"}],"output":null}],[0,"def","rustc::hir","",null,null],[3,"PathResolution","rustc::hir::def","The result of resolving a path before lowering to HIR. `base_def` is definition of resolved part of the path, `unresolved_segments` is the number of unresolved segments.",null,null],[12,"base_def","","",137,null],[12,"unresolved_segments","","",137,null],[3,"Export","","",null,null],[12,"ident","","The name of the target.",138,null],[12,"def","","The definition of the target.",138,null],[12,"span","","The span of the target definition.",138,null],[12,"vis","","The visibility of the export. We include non-`pub` exports for hygienic macros that get used from extern crates.",138,null],[12,"is_import","","True if from a `use` or and `extern crate`. Used in rustdoc.",138,null],[4,"CtorKind","","",null,null],[13,"Fn","","Constructor function automatically created by a tuple struct/variant.",139,null],[13,"Const","","Constructor constant automatically created by a unit struct/variant.",139,null],[13,"Fictive","","Unusable name in value namespace created by a struct variant.",139,null],[4,"Def","","",null,null],[13,"Mod","","",140,null],[13,"Struct","","",140,null],[13,"Union","","",140,null],[13,"Enum","","",140,null],[13,"Variant","","",140,null],[13,"Trait","","",140,null],[13,"TyAlias","","",140,null],[13,"TyForeign","","",140,null],[13,"TraitAlias","","",140,null],[13,"AssociatedTy","","",140,null],[13,"PrimTy","","",140,null],[13,"TyParam","","",140,null],[13,"SelfTy","","",140,null],[13,"Fn","","",140,null],[13,"Const","","",140,null],[13,"Static","","",140,null],[13,"StructCtor","","",140,null],[13,"VariantCtor","","",140,null],[13,"Method","","",140,null],[13,"AssociatedConst","","",140,null],[13,"Local","","",140,null],[13,"Upvar","","",140,null],[13,"Label","","",140,null],[13,"Macro","","",140,null],[13,"GlobalAsm","","",140,null],[13,"Err","","",140,null],[6,"DefMap","","Definition mapping",null,null],[6,"ExportMap","","This is the replacement export map. It maps a module to all of the exports within.",null,null],[11,"clone","","",139,{"inputs":[{"name":"self"}],"output":{"name":"ctorkind"}}],[11,"eq","","",139,{"inputs":[{"name":"self"},{"name":"ctorkind"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",139,null],[11,"encode","","",139,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",139,{"inputs":[{"name":"__d"}],"output":{"generics":["ctorkind"],"name":"result"}}],[11,"hash","","",139,null],[11,"fmt","","",139,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",140,{"inputs":[{"name":"self"}],"output":{"name":"def"}}],[11,"eq","","",140,{"inputs":[{"name":"self"},{"name":"def"}],"output":{"name":"bool"}}],[11,"ne","","",140,{"inputs":[{"name":"self"},{"name":"def"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",140,null],[11,"encode","","",140,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",140,{"inputs":[{"name":"__d"}],"output":{"generics":["def"],"name":"result"}}],[11,"hash","","",140,null],[11,"fmt","","",140,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",137,{"inputs":[{"name":"self"}],"output":{"name":"pathresolution"}}],[11,"fmt","","",137,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","",137,{"inputs":[{"name":"def"}],"output":{"name":"self"}}],[11,"with_unresolved_segments","","",137,{"inputs":[{"name":"def"},{"name":"usize"}],"output":{"name":"self"}}],[11,"base_def","","",137,{"inputs":[{"name":"self"}],"output":{"name":"def"}}],[11,"unresolved_segments","","",137,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"kind_name","","",137,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"clone","","",138,{"inputs":[{"name":"self"}],"output":{"name":"export"}}],[11,"fmt","","",138,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",138,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",138,{"inputs":[{"name":"__d"}],"output":{"generics":["export"],"name":"result"}}],[11,"from_ast","","",139,{"inputs":[{"name":"variantdata"}],"output":{"name":"ctorkind"}}],[11,"from_hir","","",139,{"inputs":[{"name":"variantdata"}],"output":{"name":"ctorkind"}}],[11,"def_id","","",140,{"inputs":[{"name":"self"}],"output":{"name":"defid"}}],[11,"kind_name","","A human readable kind name",140,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[0,"def_id","rustc::hir","",null,null],[3,"CrateNum","rustc::hir::def_id","",null,null],[12,"0","","",141,null],[3,"DefIndex","","A DefIndex is an index into the hir-map for a crate, identifying a particular definition. It should really be considered an interned shorthand for a particular DefPath.",null,null],[12,"0","","",142,null],[3,"DefId","","A DefId identifies a particular definition, by combining a crate index and a def index.",null,null],[12,"krate","","",143,null],[12,"index","","",143,null],[3,"LocalDefId","","A LocalDefId is equivalent to a DefId with `krate == LOCAL_CRATE`. Since we encode this information in the type, we can ensure at compile time that no DefIds from upstream crates get thrown into the mix. There are quite a few cases where we know that only DefIds from the local crate are expected and a DefId from a different crate would signify a bug somewhere. This is when LocalDefId comes in handy.",null,null],[12,"0","","",144,null],[4,"DefIndexAddressSpace","","",null,null],[13,"Low","","",145,null],[13,"High","","",145,null],[17,"LOCAL_CRATE","","Item definitions in the currently-compiled crate would have the CrateNum LOCAL_CRATE in their DefId.",null,null],[17,"BUILTIN_MACROS_CRATE","","Virtual crate for builtin macros",null,null],[17,"INVALID_CRATE","","A CrateNum value that indicates that something is wrong.",null,null],[17,"RESERVED_FOR_INCR_COMP_CACHE","","A special CrateNum that we use for the tcx.rcache when decoding from the incr. comp. cache.",null,null],[17,"CRATE_DEF_INDEX","","The crate root is always assigned index 0 by the AST Map code, thanks to `NodeCollector::new`.",null,null],[11,"clone","","",141,{"inputs":[{"name":"self"}],"output":{"name":"cratenum"}}],[11,"eq","","",141,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"bool"}}],[11,"ne","","",141,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",141,null],[11,"hash","","",141,null],[11,"partial_cmp","","",141,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",141,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"bool"}}],[11,"le","","",141,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"bool"}}],[11,"gt","","",141,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"bool"}}],[11,"ge","","",141,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"bool"}}],[11,"cmp","","",141,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"ordering"}}],[11,"new","","",141,{"inputs":[{"name":"usize"}],"output":{"name":"self"}}],[11,"index","","",141,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"fmt","","",141,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","",141,{"inputs":[{"name":"usize"}],"output":{"name":"cratenum"}}],[11,"from_u32","","",141,{"inputs":[{"name":"u32"}],"output":{"name":"cratenum"}}],[11,"as_usize","","",141,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"as_u32","","",141,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"as_def_id","","",141,{"inputs":[{"name":"self"}],"output":{"name":"defid"}}],[11,"fmt","","",141,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",142,{"inputs":[{"name":"self"}],"output":{"name":"defindex"}}],[11,"assert_receiver_is_total_eq","","",142,null],[11,"cmp","","",142,{"inputs":[{"name":"self"},{"name":"defindex"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",142,{"inputs":[{"name":"self"},{"name":"defindex"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",142,{"inputs":[{"name":"self"},{"name":"defindex"}],"output":{"name":"bool"}}],[11,"le","","",142,{"inputs":[{"name":"self"},{"name":"defindex"}],"output":{"name":"bool"}}],[11,"gt","","",142,{"inputs":[{"name":"self"},{"name":"defindex"}],"output":{"name":"bool"}}],[11,"ge","","",142,{"inputs":[{"name":"self"},{"name":"defindex"}],"output":{"name":"bool"}}],[11,"eq","","",142,{"inputs":[{"name":"self"},{"name":"defindex"}],"output":{"name":"bool"}}],[11,"ne","","",142,{"inputs":[{"name":"self"},{"name":"defindex"}],"output":{"name":"bool"}}],[11,"hash","","",142,null],[11,"fmt","","",142,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"address_space","","",142,{"inputs":[{"name":"self"}],"output":{"name":"defindexaddressspace"}}],[11,"as_array_index","","Converts this DefIndex into a zero-based array index. This index is the offset within the given DefIndexAddressSpace.",142,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"from_array_index","","",142,{"inputs":[{"name":"usize"},{"name":"defindexaddressspace"}],"output":{"name":"defindex"}}],[11,"from_proc_macro_index","","",142,{"inputs":[{"name":"usize"}],"output":{"name":"defindex"}}],[11,"to_proc_macro_index","","",142,{"inputs":[{"name":"defindex"}],"output":{"name":"usize"}}],[11,"from_raw_u32","","",142,{"inputs":[{"name":"u32"}],"output":{"name":"defindex"}}],[11,"as_raw_u32","","",142,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"clone","","",145,{"inputs":[{"name":"self"}],"output":{"name":"defindexaddressspace"}}],[11,"assert_receiver_is_total_eq","","",145,null],[11,"eq","","",145,{"inputs":[{"name":"self"},{"name":"defindexaddressspace"}],"output":{"name":"bool"}}],[11,"hash","","",145,null],[11,"index","","",145,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"clone","","",143,{"inputs":[{"name":"self"}],"output":{"name":"defid"}}],[11,"assert_receiver_is_total_eq","","",143,null],[11,"cmp","","",143,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",143,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",143,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"bool"}}],[11,"le","","",143,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"bool"}}],[11,"gt","","",143,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"bool"}}],[11,"ge","","",143,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"bool"}}],[11,"eq","","",143,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"bool"}}],[11,"ne","","",143,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"bool"}}],[11,"hash","","",143,null],[11,"fmt","","",143,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"local","","Make a local `DefId` with the given index.",143,{"inputs":[{"name":"defindex"}],"output":{"name":"defid"}}],[11,"is_local","","",143,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"to_local","","",143,{"inputs":[{"name":"self"}],"output":{"name":"localdefid"}}],[11,"clone","","",144,{"inputs":[{"name":"self"}],"output":{"name":"localdefid"}}],[11,"assert_receiver_is_total_eq","","",144,null],[11,"eq","","",144,{"inputs":[{"name":"self"},{"name":"localdefid"}],"output":{"name":"bool"}}],[11,"ne","","",144,{"inputs":[{"name":"self"},{"name":"localdefid"}],"output":{"name":"bool"}}],[11,"cmp","","",144,{"inputs":[{"name":"self"},{"name":"localdefid"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",144,{"inputs":[{"name":"self"},{"name":"localdefid"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",144,{"inputs":[{"name":"self"},{"name":"localdefid"}],"output":{"name":"bool"}}],[11,"le","","",144,{"inputs":[{"name":"self"},{"name":"localdefid"}],"output":{"name":"bool"}}],[11,"gt","","",144,{"inputs":[{"name":"self"},{"name":"localdefid"}],"output":{"name":"bool"}}],[11,"ge","","",144,{"inputs":[{"name":"self"},{"name":"localdefid"}],"output":{"name":"bool"}}],[11,"hash","","",144,null],[11,"from_def_id","","",144,{"inputs":[{"name":"defid"}],"output":{"name":"localdefid"}}],[11,"to_def_id","","",144,{"inputs":[{"name":"self"}],"output":{"name":"defid"}}],[11,"fmt","","",144,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[0,"intravisit","rustc::hir","HIR walker for walking the contents of nodes.",null,null],[3,"IdRange","rustc::hir::intravisit","",null,null],[12,"min","","",146,null],[12,"max","","",146,null],[3,"IdRangeComputingVisitor","","",null,null],[12,"result","","",147,null],[12,"map","","",147,null],[4,"FnKind","","",null,null],[13,"ItemFn","","fn foo() or extern \"Abi\" fn foo()",148,null],[13,"Method","","fn foo(&self)",148,null],[13,"Closure","","|x, y| {}",148,null],[4,"NestedVisitorMap","","Specifies what nested things a visitor wants to visit. The most common choice is `OnlyBodies`, which will cause the visitor to visit fn bodies for fns that it encounters, but skip over nested item-like things.",null,null],[13,"None","","Do not visit any nested things. When you add a new \"non-nested\" thing, you will want to audit such uses to see if they remain valid.",149,null],[13,"OnlyBodies","","Do not visit nested item-like things, but visit nested things that are inside of an item-like.",149,null],[13,"All","","Visit all nested things, including item-likes.",149,null],[5,"walk_crate","","Walks the contents of a crate. See also `Crate::visit_all_items`.",null,{"inputs":[{"name":"v"},{"name":"crate"}],"output":null}],[5,"walk_macro_def","","",null,{"inputs":[{"name":"v"},{"name":"macrodef"}],"output":null}],[5,"walk_mod","","",null,{"inputs":[{"name":"v"},{"name":"mod"},{"name":"nodeid"}],"output":null}],[5,"walk_body","","",null,{"inputs":[{"name":"v"},{"name":"body"}],"output":null}],[5,"walk_local","","",null,{"inputs":[{"name":"v"},{"name":"local"}],"output":null}],[5,"walk_label","","",null,{"inputs":[{"name":"v"},{"name":"label"}],"output":null}],[5,"walk_lifetime","","",null,{"inputs":[{"name":"v"},{"name":"lifetime"}],"output":null}],[5,"walk_poly_trait_ref","","",null,{"inputs":[{"name":"v"},{"name":"polytraitref"},{"name":"traitboundmodifier"}],"output":null}],[5,"walk_trait_ref","","",null,{"inputs":[{"name":"v"},{"name":"traitref"}],"output":null}],[5,"walk_item","","",null,{"inputs":[{"name":"v"},{"name":"item"}],"output":null}],[5,"walk_enum_def","","",null,{"inputs":[{"name":"v"},{"name":"enumdef"},{"name":"generics"},{"name":"nodeid"}],"output":null}],[5,"walk_variant","","",null,{"inputs":[{"name":"v"},{"name":"variant"},{"name":"generics"},{"name":"nodeid"}],"output":null}],[5,"walk_ty","","",null,{"inputs":[{"name":"v"},{"name":"ty"}],"output":null}],[5,"walk_qpath","","",null,{"inputs":[{"name":"v"},{"name":"qpath"},{"name":"nodeid"},{"name":"span"}],"output":null}],[5,"walk_path","","",null,{"inputs":[{"name":"v"},{"name":"path"}],"output":null}],[5,"walk_path_segment","","",null,{"inputs":[{"name":"v"},{"name":"span"},{"name":"pathsegment"}],"output":null}],[5,"walk_path_parameters","","",null,{"inputs":[{"name":"v"},{"name":"span"},{"name":"pathparameters"}],"output":null}],[5,"walk_assoc_type_binding","","",null,{"inputs":[{"name":"v"},{"name":"typebinding"}],"output":null}],[5,"walk_pat","","",null,{"inputs":[{"name":"v"},{"name":"pat"}],"output":null}],[5,"walk_foreign_item","","",null,{"inputs":[{"name":"v"},{"name":"foreignitem"}],"output":null}],[5,"walk_ty_param_bound","","",null,{"inputs":[{"name":"v"},{"name":"typarambound"}],"output":null}],[5,"walk_generic_param","","",null,{"inputs":[{"name":"v"},{"name":"genericparam"}],"output":null}],[5,"walk_generics","","",null,{"inputs":[{"name":"v"},{"name":"generics"}],"output":null}],[5,"walk_where_predicate","","",null,{"inputs":[{"name":"v"},{"name":"wherepredicate"}],"output":null}],[5,"walk_fn_ret_ty","","",null,{"inputs":[{"name":"v"},{"name":"functionretty"}],"output":null}],[5,"walk_fn_decl","","",null,{"inputs":[{"name":"v"},{"name":"fndecl"}],"output":null}],[5,"walk_fn_kind","","",null,{"inputs":[{"name":"v"},{"name":"fnkind"}],"output":null}],[5,"walk_fn","","",null,{"inputs":[{"name":"v"},{"name":"fnkind"},{"name":"fndecl"},{"name":"bodyid"},{"name":"span"},{"name":"nodeid"}],"output":null}],[5,"walk_trait_item","","",null,{"inputs":[{"name":"v"},{"name":"traititem"}],"output":null}],[5,"walk_trait_item_ref","","",null,{"inputs":[{"name":"v"},{"name":"traititemref"}],"output":null}],[5,"walk_impl_item","","",null,{"inputs":[{"name":"v"},{"name":"implitem"}],"output":null}],[5,"walk_impl_item_ref","","",null,{"inputs":[{"name":"v"},{"name":"implitemref"}],"output":null}],[5,"walk_struct_def","","",null,{"inputs":[{"name":"v"},{"name":"variantdata"}],"output":null}],[5,"walk_struct_field","","",null,{"inputs":[{"name":"v"},{"name":"structfield"}],"output":null}],[5,"walk_block","","",null,{"inputs":[{"name":"v"},{"name":"block"}],"output":null}],[5,"walk_stmt","","",null,{"inputs":[{"name":"v"},{"name":"stmt"}],"output":null}],[5,"walk_decl","","",null,{"inputs":[{"name":"v"},{"name":"decl"}],"output":null}],[5,"walk_expr","","",null,{"inputs":[{"name":"v"},{"name":"expr"}],"output":null}],[5,"walk_arm","","",null,{"inputs":[{"name":"v"},{"name":"arm"}],"output":null}],[5,"walk_vis","","",null,{"inputs":[{"name":"v"},{"name":"visibility"}],"output":null}],[5,"walk_associated_item_kind","","",null,{"inputs":[{"name":"v"},{"name":"associateditemkind"}],"output":null}],[5,"walk_defaultness","","",null,{"inputs":[{"name":"v"},{"name":"defaultness"}],"output":null}],[8,"Visitor","","Each method of the Visitor trait is a hook to be potentially overridden.  Each method's default implementation recursively visits the substructure of the input via the corresponding `walk` method; e.g. the `visit_mod` method by default calls `intravisit::walk_mod`.",null,null],[10,"nested_visit_map","","The default versions of the `visit_nested_XXX` routines invoke this method to get a map to use. By selecting an enum variant, you control which kinds of nested HIR are visited; see `NestedVisitorMap` for details. By \"nested HIR\", we are referring to bits of HIR that are not directly embedded within one another but rather indirectly, through a table in the crate. This is done to control dependencies during incremental compilation: the non-inline bits of HIR can be tracked and hashed separately.",150,{"inputs":[{"name":"self"}],"output":{"name":"nestedvisitormap"}}],[11,"visit_nested_item","","Invoked when a nested item is encountered. By default does nothing unless you override `nested_visit_map` to return `Some(_)`, in which case it will walk the item. You probably don't want to override this method -- instead, override `nested_visit_map` or use the \"shallow\" or \"deep\" visit patterns described on `itemlikevisit::ItemLikeVisitor`. The only reason to override this method is if you want a nested pattern but cannot supply a `Map`; see `nested_visit_map` for advice.",150,{"inputs":[{"name":"self"},{"name":"itemid"}],"output":null}],[11,"visit_nested_trait_item","","Like `visit_nested_item()`, but for trait items. See `visit_nested_item()` for advice on when to override this method.",150,{"inputs":[{"name":"self"},{"name":"traititemid"}],"output":null}],[11,"visit_nested_impl_item","","Like `visit_nested_item()`, but for impl items. See `visit_nested_item()` for advice on when to override this method.",150,{"inputs":[{"name":"self"},{"name":"implitemid"}],"output":null}],[11,"visit_nested_body","","Invoked to visit the body of a function, method or closure. Like visit_nested_item, does nothing by default unless you override `nested_visit_map` to return `Some(_)`, in which case it will walk the body.",150,{"inputs":[{"name":"self"},{"name":"bodyid"}],"output":null}],[11,"visit_item","","Visit the top-level item and (optionally) nested items / impl items. See `visit_nested_item` for details.",150,{"inputs":[{"name":"self"},{"name":"item"}],"output":null}],[11,"visit_body","","",150,{"inputs":[{"name":"self"},{"name":"body"}],"output":null}],[11,"as_deep_visitor","","When invoking `visit_all_item_likes()`, you need to supply an item-like visitor.  This method converts a \"intra-visit\" visitor into an item-like visitor that walks the entire tree. If you use this, you probably don't want to process the contents of nested item-like things, since the outer loop will visit them as well.",150,{"inputs":[{"name":"self"}],"output":{"name":"deepvisitor"}}],[11,"visit_id","","",150,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":null}],[11,"visit_def_mention","","",150,{"inputs":[{"name":"self"},{"name":"def"}],"output":null}],[11,"visit_name","","",150,{"inputs":[{"name":"self"},{"name":"span"},{"name":"name"}],"output":null}],[11,"visit_mod","","",150,{"inputs":[{"name":"self"},{"name":"mod"},{"name":"span"},{"name":"nodeid"}],"output":null}],[11,"visit_foreign_item","","",150,{"inputs":[{"name":"self"},{"name":"foreignitem"}],"output":null}],[11,"visit_local","","",150,{"inputs":[{"name":"self"},{"name":"local"}],"output":null}],[11,"visit_block","","",150,{"inputs":[{"name":"self"},{"name":"block"}],"output":null}],[11,"visit_stmt","","",150,{"inputs":[{"name":"self"},{"name":"stmt"}],"output":null}],[11,"visit_arm","","",150,{"inputs":[{"name":"self"},{"name":"arm"}],"output":null}],[11,"visit_pat","","",150,{"inputs":[{"name":"self"},{"name":"pat"}],"output":null}],[11,"visit_decl","","",150,{"inputs":[{"name":"self"},{"name":"decl"}],"output":null}],[11,"visit_expr","","",150,{"inputs":[{"name":"self"},{"name":"expr"}],"output":null}],[11,"visit_ty","","",150,{"inputs":[{"name":"self"},{"name":"ty"}],"output":null}],[11,"visit_generic_param","","",150,{"inputs":[{"name":"self"},{"name":"genericparam"}],"output":null}],[11,"visit_generics","","",150,{"inputs":[{"name":"self"},{"name":"generics"}],"output":null}],[11,"visit_where_predicate","","",150,{"inputs":[{"name":"self"},{"name":"wherepredicate"}],"output":null}],[11,"visit_fn_decl","","",150,{"inputs":[{"name":"self"},{"name":"fndecl"}],"output":null}],[11,"visit_fn","","",150,{"inputs":[{"name":"self"},{"name":"fnkind"},{"name":"fndecl"},{"name":"bodyid"},{"name":"span"},{"name":"nodeid"}],"output":null}],[11,"visit_trait_item","","",150,{"inputs":[{"name":"self"},{"name":"traititem"}],"output":null}],[11,"visit_trait_item_ref","","",150,{"inputs":[{"name":"self"},{"name":"traititemref"}],"output":null}],[11,"visit_impl_item","","",150,{"inputs":[{"name":"self"},{"name":"implitem"}],"output":null}],[11,"visit_impl_item_ref","","",150,{"inputs":[{"name":"self"},{"name":"implitemref"}],"output":null}],[11,"visit_trait_ref","","",150,{"inputs":[{"name":"self"},{"name":"traitref"}],"output":null}],[11,"visit_ty_param_bound","","",150,{"inputs":[{"name":"self"},{"name":"typarambound"}],"output":null}],[11,"visit_poly_trait_ref","","",150,{"inputs":[{"name":"self"},{"name":"polytraitref"},{"name":"traitboundmodifier"}],"output":null}],[11,"visit_variant_data","","",150,{"inputs":[{"name":"self"},{"name":"variantdata"},{"name":"name"},{"name":"generics"},{"name":"nodeid"},{"name":"span"}],"output":null}],[11,"visit_struct_field","","",150,{"inputs":[{"name":"self"},{"name":"structfield"}],"output":null}],[11,"visit_enum_def","","",150,{"inputs":[{"name":"self"},{"name":"enumdef"},{"name":"generics"},{"name":"nodeid"},{"name":"span"}],"output":null}],[11,"visit_variant","","",150,{"inputs":[{"name":"self"},{"name":"variant"},{"name":"generics"},{"name":"nodeid"}],"output":null}],[11,"visit_label","","",150,{"inputs":[{"name":"self"},{"name":"label"}],"output":null}],[11,"visit_lifetime","","",150,{"inputs":[{"name":"self"},{"name":"lifetime"}],"output":null}],[11,"visit_qpath","","",150,{"inputs":[{"name":"self"},{"name":"qpath"},{"name":"nodeid"},{"name":"span"}],"output":null}],[11,"visit_path","","",150,{"inputs":[{"name":"self"},{"name":"path"},{"name":"nodeid"}],"output":null}],[11,"visit_path_segment","","",150,{"inputs":[{"name":"self"},{"name":"span"},{"name":"pathsegment"}],"output":null}],[11,"visit_path_parameters","","",150,{"inputs":[{"name":"self"},{"name":"span"},{"name":"pathparameters"}],"output":null}],[11,"visit_assoc_type_binding","","",150,{"inputs":[{"name":"self"},{"name":"typebinding"}],"output":null}],[11,"visit_attribute","","",150,{"inputs":[{"name":"self"},{"name":"attribute"}],"output":null}],[11,"visit_macro_def","","",150,{"inputs":[{"name":"self"},{"name":"macrodef"}],"output":null}],[11,"visit_vis","","",150,{"inputs":[{"name":"self"},{"name":"visibility"}],"output":null}],[11,"visit_associated_item_kind","","",150,{"inputs":[{"name":"self"},{"name":"associateditemkind"}],"output":null}],[11,"visit_defaultness","","",150,{"inputs":[{"name":"self"},{"name":"defaultness"}],"output":null}],[11,"clone","","",148,{"inputs":[{"name":"self"}],"output":{"name":"fnkind"}}],[11,"eq","","",148,{"inputs":[{"name":"self"},{"name":"fnkind"}],"output":{"name":"bool"}}],[11,"ne","","",148,{"inputs":[{"name":"self"},{"name":"fnkind"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",148,null],[11,"attrs","","",148,null],[11,"intra","","Returns the map to use for an \"intra item-like\" thing (if any). e.g., function body.",149,{"inputs":[{"name":"self"}],"output":{"generics":["map"],"name":"option"}}],[11,"inter","","Returns the map to use for an \"item-like\" thing (if any). e.g., item, impl-item.",149,{"inputs":[{"name":"self"}],"output":{"generics":["map"],"name":"option"}}],[11,"clone","","",146,{"inputs":[{"name":"self"}],"output":{"name":"idrange"}}],[11,"encode","","",146,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",146,{"inputs":[{"name":"__d"}],"output":{"generics":["idrange"],"name":"result"}}],[11,"fmt","","",146,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",146,{"inputs":[{"name":"self"},{"name":"idrange"}],"output":{"name":"bool"}}],[11,"ne","","",146,{"inputs":[{"name":"self"},{"name":"idrange"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",146,null],[11,"max","","",146,{"inputs":[],"output":{"name":"idrange"}}],[11,"empty","","",146,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"contains","","",146,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"bool"}}],[11,"add","","",146,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":null}],[11,"new","","",147,{"inputs":[{"name":"map"}],"output":{"name":"idrangecomputingvisitor"}}],[11,"result","","",147,{"inputs":[{"name":"self"}],"output":{"name":"idrange"}}],[11,"nested_visit_map","","",147,{"inputs":[{"name":"self"}],"output":{"name":"nestedvisitormap"}}],[11,"visit_id","","",147,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":null}],[0,"itemlikevisit","rustc::hir","",null,null],[3,"DeepVisitor","rustc::hir::itemlikevisit","",null,null],[12,"visitor","","",151,null],[8,"ItemLikeVisitor","","The \"item-like visitor\" visitor defines only the top-level methods that can be invoked by `Crate::visit_all_item_likes()`. Whether this trait is the right one to implement will depend on the overall pattern you need. Here are the three available patterns, in roughly the order of desirability:",null,null],[10,"visit_item","","",152,{"inputs":[{"name":"self"},{"name":"item"}],"output":null}],[10,"visit_trait_item","","",152,{"inputs":[{"name":"self"},{"name":"traititem"}],"output":null}],[10,"visit_impl_item","","",152,{"inputs":[{"name":"self"},{"name":"implitem"}],"output":null}],[11,"new","","",151,{"inputs":[{"name":"v"}],"output":{"name":"self"}}],[11,"visit_item","","",151,{"inputs":[{"name":"self"},{"name":"item"}],"output":null}],[11,"visit_trait_item","","",151,{"inputs":[{"name":"self"},{"name":"traititem"}],"output":null}],[11,"visit_impl_item","","",151,{"inputs":[{"name":"self"},{"name":"implitem"}],"output":null}],[0,"lowering","rustc::hir","Lowers the AST to the HIR.",null,null],[3,"LoweringContext","rustc::hir::lowering","",null,null],[12,"crate_root","","",153,null],[12,"sess","","",153,null],[12,"cstore","","",153,null],[12,"parent_def","","",153,null],[12,"resolver","","",153,null],[12,"name_map","","",153,null],[12,"items","","The items being lowered are collected here.",153,null],[12,"trait_items","","",153,null],[12,"impl_items","","",153,null],[12,"bodies","","",153,null],[12,"exported_macros","","",153,null],[12,"trait_impls","","",153,null],[12,"trait_auto_impl","","",153,null],[12,"is_generator","","",153,null],[12,"catch_scopes","","",153,null],[12,"loop_scopes","","",153,null],[12,"is_in_loop_condition","","",153,null],[12,"is_in_trait_impl","","",153,null],[12,"anonymous_lifetime_mode","","What to do when we encounter either an \"anonymous lifetime reference\". The term \"anonymous\" is meant to encompass both `'_` lifetimes as well as fully elided cases where nothing is written at all (e.g., `&T` or `std::cell::Ref<T>`).",153,null],[12,"in_band_ty_params","","",153,null],[12,"lifetimes_to_define","","",153,null],[12,"is_collecting_in_band_lifetimes","","",153,null],[12,"in_scope_lifetimes","","",153,null],[12,"type_def_lifetime_params","","",153,null],[12,"current_hir_id_owner","","",153,null],[12,"item_local_id_counters","","",153,null],[12,"node_id_to_hir_id","","",153,null],[3,"LoweredNodeId","","",null,null],[12,"node_id","","",154,null],[12,"hir_id","","",154,null],[4,"ImplTraitContext","","",null,null],[13,"Universal","","Treat `impl Trait` as shorthand for a new universal generic parameter. Example: `fn foo(x: impl Debug)`, where `impl Debug` is conceptually equivalent to a fresh universal parameter like `fn foo<T: Debug>(x: T)`.",155,null],[13,"Existential","","Treat `impl Trait` as shorthand for a new universal existential parameter. Example: `fn foo() -> impl Debug`, where `impl Debug` is conceptually equivalent to a fresh existential parameter like `abstract type T; fn foo() -> T`.",155,null],[13,"Disallowed","","`impl Trait` is not accepted in this position.",155,null],[4,"ParamMode","","",null,null],[13,"Explicit","","Any path in a type context.",156,null],[13,"Optional","","The `module::Type` in `module::Type::method` in an expression.",156,null],[4,"ParenthesizedGenericArgs","","",null,null],[13,"Ok","","",157,null],[13,"Warn","","",157,null],[13,"Err","","",157,null],[4,"AnonymousLifetimeMode","","What to do when we encounter an anonymous lifetime reference. Anonymous lifetime references come in two flavors.  You have implicit, or fully elided, references to lifetimes, like the one in `&T` or `Ref<T>`, and you have `'_` lifetimes, like `&'_ T` or `Ref<'_, T>`.  These often behave the same, but not always:",null,null],[13,"CreateParameter","","For Modern cases, create a new anonymous region parameter and reference that.",158,null],[13,"PassThrough","","Pass responsibility to `resolve_lifetime` code for all cases.",158,null],[5,"lower_crate","","",null,{"inputs":[{"name":"session"},{"name":"cratestore"},{"name":"depgraph"},{"name":"crate"},{"name":"resolver"}],"output":{"name":"crate"}}],[5,"body_ids","","",null,{"inputs":[{"name":"btreemap"}],"output":{"generics":["bodyid"],"name":"vec"}}],[17,"HIR_ID_COUNTER_LOCKED","","",null,null],[8,"Resolver","","",null,null],[10,"resolve_hir_path","","Resolve a hir path generated by the lowerer when expanding `for`, `if let`, etc.",159,{"inputs":[{"name":"self"},{"name":"path"},{"name":"bool"}],"output":null}],[10,"get_resolution","","Obtain the resolution for a node id",159,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"generics":["pathresolution"],"name":"option"}}],[10,"definitions","","We must keep the set of definitions up to date as we add nodes that weren't in the AST. This should only return `None` during testing.",159,{"inputs":[{"name":"self"}],"output":{"name":"definitions"}}],[10,"resolve_str_path","","Given suffix [\"b\",\"c\",\"d\"], creates a HIR path for `[::crate_root]::b::c::d` and resolves it based on `is_value`.",159,null],[11,"clone","","",155,{"inputs":[{"name":"self"}],"output":{"name":"impltraitcontext"}}],[11,"fmt","","",155,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",156,{"inputs":[{"name":"self"}],"output":{"name":"parammode"}}],[11,"eq","","",156,{"inputs":[{"name":"self"},{"name":"parammode"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",156,null],[11,"clone","","",158,{"inputs":[{"name":"self"}],"output":{"name":"anonymouslifetimemode"}}],[11,"lower_crate","","",153,{"inputs":[{"name":"self"},{"name":"crate"}],"output":{"name":"crate"}}],[11,"allocate_hir_id_counter","","",153,{"inputs":[{"name":"self"},{"name":"nodeid"},{"name":"t"}],"output":null}],[11,"lower_node_id_generic","","",153,{"inputs":[{"name":"self"},{"name":"nodeid"},{"name":"f"}],"output":{"name":"lowerednodeid"}}],[11,"with_hir_id_owner","","",153,{"inputs":[{"name":"self"},{"name":"nodeid"},{"name":"f"}],"output":null}],[11,"lower_node_id","","This method allocates a new HirId for the given NodeId and stores it in the LoweringContext's NodeId => HirId map. Take care not to call this method if the resulting HirId is then not actually used in the HIR, as that would trigger an assertion in the HirIdValidator later on, which makes sure that all NodeIds got mapped properly. Calling the method twice with the same NodeId is fine though.",153,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"lowerednodeid"}}],[11,"lower_node_id_with_owner","","",153,{"inputs":[{"name":"self"},{"name":"nodeid"},{"name":"nodeid"}],"output":{"name":"lowerednodeid"}}],[11,"record_body","","",153,{"inputs":[{"name":"self"},{"name":"expr"},{"generics":["fndecl"],"name":"option"}],"output":{"name":"bodyid"}}],[11,"next_id","","",153,{"inputs":[{"name":"self"}],"output":{"name":"lowerednodeid"}}],[11,"expect_full_def","","",153,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"def"}}],[11,"diagnostic","","",153,{"inputs":[{"name":"self"}],"output":{"name":"handler"}}],[11,"str_to_ident","","",153,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"name"}}],[11,"allow_internal_unstable","","",153,{"inputs":[{"name":"self"},{"name":"compilerdesugaringkind"},{"name":"span"}],"output":{"name":"span"}}],[11,"collect_in_band_defs","","Creates a new hir::GenericParam for every new lifetime and type parameter encountered while evaluating `f`. Definitions are created with the parent provided. If no `parent_id` is provided, no definitions will be returned.",153,null],[11,"maybe_collect_in_band_lifetime","","When there is a reference to some lifetime `'a`, and in-band lifetimes are enabled, then we want to push that lifetime into the vector of names to define later. In that case, it will get added to the appropriate generics.",153,{"inputs":[{"name":"self"},{"name":"span"},{"name":"name"}],"output":null}],[11,"collect_fresh_in_band_lifetime","","When we have either an elided or `'_` lifetime in an impl header, we convert it to",153,{"inputs":[{"name":"self"},{"name":"span"}],"output":{"name":"lifetimename"}}],[11,"with_in_scope_lifetime_defs","","",153,null],[11,"with_parent_impl_lifetime_defs","","",153,null],[11,"add_in_band_defs","","Appends in-band lifetime defs and argument-position `impl Trait` defs to the existing set of generics.",153,null],[11,"with_catch_scope","","",153,{"inputs":[{"name":"self"},{"name":"nodeid"},{"name":"f"}],"output":{"name":"t"}}],[11,"lower_body","","",153,{"inputs":[{"name":"self"},{"generics":["fndecl"],"name":"option"},{"name":"f"}],"output":{"name":"bodyid"}}],[11,"with_loop_scope","","",153,{"inputs":[{"name":"self"},{"name":"nodeid"},{"name":"f"}],"output":{"name":"t"}}],[11,"with_loop_condition_scope","","",153,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"t"}}],[11,"with_new_scopes","","",153,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"t"}}],[11,"with_parent_def","","",153,{"inputs":[{"name":"self"},{"name":"nodeid"},{"name":"f"}],"output":{"name":"t"}}],[11,"def_key","","",153,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"defkey"}}],[11,"lower_ident","","",153,{"inputs":[{"name":"self"},{"name":"ident"}],"output":{"name":"name"}}],[11,"lower_label","","",153,{"inputs":[{"name":"self"},{"generics":["label"],"name":"option"}],"output":{"generics":["label"],"name":"option"}}],[11,"lower_loop_destination","","",153,{"inputs":[{"name":"self"},{"name":"option"}],"output":{"name":"destination"}}],[11,"lower_attrs","","",153,null],[11,"lower_attr","","",153,{"inputs":[{"name":"self"},{"name":"attribute"}],"output":{"name":"attribute"}}],[11,"lower_token_stream","","",153,{"inputs":[{"name":"self"},{"name":"tokenstream"}],"output":{"name":"tokenstream"}}],[11,"lower_token_tree","","",153,{"inputs":[{"name":"self"},{"name":"tokentree"}],"output":{"name":"tokenstream"}}],[11,"lower_token","","",153,{"inputs":[{"name":"self"},{"name":"token"},{"name":"span"}],"output":{"name":"tokenstream"}}],[11,"lower_arm","","",153,{"inputs":[{"name":"self"},{"name":"arm"}],"output":{"name":"arm"}}],[11,"lower_ty_binding","","",153,{"inputs":[{"name":"self"},{"name":"typebinding"},{"name":"impltraitcontext"}],"output":{"name":"typebinding"}}],[11,"lower_ty","","",153,{"inputs":[{"name":"self"},{"name":"ty"},{"name":"impltraitcontext"}],"output":{"generics":["ty"],"name":"p"}}],[11,"lifetimes_from_impl_trait_bounds","","",153,null],[11,"lower_foreign_mod","","",153,{"inputs":[{"name":"self"},{"name":"foreignmod"}],"output":{"name":"foreignmod"}}],[11,"lower_global_asm","","",153,{"inputs":[{"name":"self"},{"name":"globalasm"}],"output":{"generics":["globalasm"],"name":"p"}}],[11,"lower_variant","","",153,{"inputs":[{"name":"self"},{"name":"variant"}],"output":{"name":"variant"}}],[11,"lower_qpath","","",153,{"inputs":[{"name":"self"},{"name":"nodeid"},{"name":"option"},{"name":"path"},{"name":"parammode"},{"name":"impltraitcontext"}],"output":{"name":"qpath"}}],[11,"lower_path_extra","","",153,{"inputs":[{"name":"self"},{"name":"nodeid"},{"name":"path"},{"generics":["name"],"name":"option"},{"name":"parammode"}],"output":{"name":"path"}}],[11,"lower_path","","",153,{"inputs":[{"name":"self"},{"name":"nodeid"},{"name":"path"},{"name":"parammode"}],"output":{"name":"path"}}],[11,"lower_path_segment","","",153,{"inputs":[{"name":"self"},{"name":"span"},{"name":"pathsegment"},{"name":"parammode"},{"name":"usize"},{"name":"parenthesizedgenericargs"},{"name":"impltraitcontext"}],"output":{"name":"pathsegment"}}],[11,"lower_angle_bracketed_parameter_data","","",153,null],[11,"lower_parenthesized_parameter_data","","",153,null],[11,"lower_local","","",153,{"inputs":[{"name":"self"},{"name":"local"}],"output":{"generics":["local"],"name":"p"}}],[11,"lower_mutability","","",153,{"inputs":[{"name":"self"},{"name":"mutability"}],"output":{"name":"mutability"}}],[11,"lower_arg","","",153,{"inputs":[{"name":"self"},{"name":"arg"}],"output":{"name":"arg"}}],[11,"lower_fn_args_to_names","","",153,{"inputs":[{"name":"self"},{"name":"fndecl"}],"output":{"generics":["spanned"],"name":"hirvec"}}],[11,"lower_fn_decl","","",153,{"inputs":[{"name":"self"},{"name":"fndecl"},{"generics":["defid"],"name":"option"},{"name":"bool"}],"output":{"generics":["fndecl"],"name":"p"}}],[11,"lower_ty_param_bound","","",153,{"inputs":[{"name":"self"},{"name":"typarambound"},{"name":"impltraitcontext"}],"output":{"name":"typarambound"}}],[11,"lower_ty_param","","",153,null],[11,"lower_lifetime","","",153,{"inputs":[{"name":"self"},{"name":"lifetime"}],"output":{"name":"lifetime"}}],[11,"new_named_lifetime","","",153,{"inputs":[{"name":"self"},{"name":"nodeid"},{"name":"span"},{"name":"lifetimename"}],"output":{"name":"lifetime"}}],[11,"lower_lifetime_def","","",153,{"inputs":[{"name":"self"},{"name":"lifetimedef"}],"output":{"name":"lifetimedef"}}],[11,"lower_lifetimes","","",153,{"inputs":[{"name":"self"},{"name":"vec"}],"output":{"generics":["lifetime"],"name":"hirvec"}}],[11,"lower_generic_params","","",153,{"inputs":[{"name":"self"},{"name":"vec"},{"name":"nodemap"},{"name":"impltraitcontext"}],"output":{"generics":["genericparam"],"name":"hirvec"}}],[11,"lower_generics","","",153,{"inputs":[{"name":"self"},{"name":"generics"},{"name":"impltraitcontext"}],"output":{"name":"generics"}}],[11,"lower_where_clause","","",153,{"inputs":[{"name":"self"},{"name":"whereclause"}],"output":{"name":"whereclause"}}],[11,"lower_where_predicate","","",153,{"inputs":[{"name":"self"},{"name":"wherepredicate"}],"output":{"name":"wherepredicate"}}],[11,"lower_variant_data","","",153,{"inputs":[{"name":"self"},{"name":"variantdata"}],"output":{"name":"variantdata"}}],[11,"lower_trait_ref","","",153,{"inputs":[{"name":"self"},{"name":"traitref"},{"name":"impltraitcontext"}],"output":{"name":"traitref"}}],[11,"lower_poly_trait_ref","","",153,{"inputs":[{"name":"self"},{"name":"polytraitref"},{"name":"impltraitcontext"}],"output":{"name":"polytraitref"}}],[11,"lower_struct_field","","",153,null],[11,"lower_field","","",153,{"inputs":[{"name":"self"},{"name":"field"}],"output":{"name":"field"}}],[11,"lower_mt","","",153,{"inputs":[{"name":"self"},{"name":"mutty"},{"name":"impltraitcontext"}],"output":{"name":"mutty"}}],[11,"lower_bounds","","",153,null],[11,"lower_block","","",153,{"inputs":[{"name":"self"},{"name":"block"},{"name":"bool"}],"output":{"generics":["block"],"name":"p"}}],[11,"lower_item_kind","","",153,{"inputs":[{"name":"self"},{"name":"nodeid"},{"name":"name"},{"name":"hirvec"},{"name":"visibility"},{"name":"itemkind"}],"output":{"name":"item_"}}],[11,"lower_use_tree","","",153,{"inputs":[{"name":"self"},{"name":"usetree"},{"name":"path"},{"name":"nodeid"},{"name":"visibility"},{"name":"name"},{"name":"hirvec"}],"output":{"name":"item_"}}],[11,"lower_trait_item","","",153,{"inputs":[{"name":"self"},{"name":"traititem"}],"output":{"name":"traititem"}}],[11,"lower_trait_item_ref","","",153,{"inputs":[{"name":"self"},{"name":"traititem"}],"output":{"name":"traititemref"}}],[11,"lower_impl_item","","",153,{"inputs":[{"name":"self"},{"name":"implitem"}],"output":{"name":"implitem"}}],[11,"lower_impl_item_ref","","",153,{"inputs":[{"name":"self"},{"name":"implitem"}],"output":{"name":"implitemref"}}],[11,"lower_mod","","",153,{"inputs":[{"name":"self"},{"name":"mod"}],"output":{"name":"mod"}}],[11,"lower_item_id","","",153,{"inputs":[{"name":"self"},{"name":"item"}],"output":{"generics":["itemid"],"name":"smallvector"}}],[11,"lower_item_id_use_tree","","",153,{"inputs":[{"name":"self"},{"name":"usetree"},{"name":"smallvector"}],"output":null}],[11,"lower_item","","",153,{"inputs":[{"name":"self"},{"name":"item"}],"output":{"generics":["item"],"name":"option"}}],[11,"lower_foreign_item","","",153,{"inputs":[{"name":"self"},{"name":"foreignitem"}],"output":{"name":"foreignitem"}}],[11,"lower_method_sig","","",153,{"inputs":[{"name":"self"},{"name":"methodsig"},{"name":"defid"},{"name":"bool"}],"output":{"name":"methodsig"}}],[11,"lower_is_auto","","",153,{"inputs":[{"name":"self"},{"name":"isauto"}],"output":{"name":"isauto"}}],[11,"lower_unsafety","","",153,{"inputs":[{"name":"self"},{"name":"unsafety"}],"output":{"name":"unsafety"}}],[11,"lower_constness","","",153,{"inputs":[{"name":"self"},{"generics":["constness"],"name":"spanned"}],"output":{"name":"constness"}}],[11,"lower_unop","","",153,{"inputs":[{"name":"self"},{"name":"unop"}],"output":{"name":"unop"}}],[11,"lower_binop","","",153,{"inputs":[{"name":"self"},{"name":"binop"}],"output":{"name":"binop"}}],[11,"lower_pat","","",153,{"inputs":[{"name":"self"},{"name":"pat"}],"output":{"generics":["pat"],"name":"p"}}],[11,"lower_range_end","","",153,{"inputs":[{"name":"self"},{"name":"rangeend"}],"output":{"name":"rangeend"}}],[11,"lower_expr","","",153,{"inputs":[{"name":"self"},{"name":"expr"}],"output":{"name":"expr"}}],[11,"lower_stmt","","",153,{"inputs":[{"name":"self"},{"name":"stmt"}],"output":{"generics":["stmt"],"name":"smallvector"}}],[11,"lower_capture_clause","","",153,{"inputs":[{"name":"self"},{"name":"captureby"}],"output":{"name":"captureclause"}}],[11,"lower_visibility","","If an `explicit_owner` is given, this method allocates the `HirId` in the address space of that item instead of the item currently being lowered. This can happen during `lower_impl_item_ref()` where we need to lower a `Visibility` value although we haven't lowered the owning `ImplItem` in question yet.",153,{"inputs":[{"name":"self"},{"name":"visibility"},{"generics":["nodeid"],"name":"option"}],"output":{"name":"visibility"}}],[11,"lower_defaultness","","",153,{"inputs":[{"name":"self"},{"name":"defaultness"},{"name":"bool"}],"output":{"name":"defaultness"}}],[11,"lower_block_check_mode","","",153,{"inputs":[{"name":"self"},{"name":"blockcheckmode"}],"output":{"name":"blockcheckmode"}}],[11,"lower_binding_mode","","",153,{"inputs":[{"name":"self"},{"name":"bindingmode"}],"output":{"name":"bindingannotation"}}],[11,"lower_unsafe_source","","",153,{"inputs":[{"name":"self"},{"name":"unsafesource"}],"output":{"name":"unsafesource"}}],[11,"lower_impl_polarity","","",153,{"inputs":[{"name":"self"},{"name":"implpolarity"}],"output":{"name":"implpolarity"}}],[11,"lower_trait_bound_modifier","","",153,{"inputs":[{"name":"self"},{"name":"traitboundmodifier"}],"output":{"name":"traitboundmodifier"}}],[11,"arm","","",153,{"inputs":[{"name":"self"},{"generics":["p"],"name":"hirvec"},{"generics":["expr"],"name":"p"}],"output":{"name":"arm"}}],[11,"field","","",153,{"inputs":[{"name":"self"},{"name":"name"},{"generics":["expr"],"name":"p"},{"name":"span"}],"output":{"name":"field"}}],[11,"expr_break","","",153,{"inputs":[{"name":"self"},{"name":"span"},{"generics":["attribute"],"name":"thinvec"}],"output":{"generics":["expr"],"name":"p"}}],[11,"expr_call","","",153,{"inputs":[{"name":"self"},{"name":"span"},{"generics":["expr"],"name":"p"},{"generics":["expr"],"name":"hirvec"}],"output":{"name":"expr"}}],[11,"expr_ident","","",153,{"inputs":[{"name":"self"},{"name":"span"},{"name":"name"},{"name":"nodeid"}],"output":{"name":"expr"}}],[11,"expr_ident_with_attrs","","",153,{"inputs":[{"name":"self"},{"name":"span"},{"name":"name"},{"name":"nodeid"},{"generics":["attribute"],"name":"thinvec"}],"output":{"name":"expr"}}],[11,"expr_mut_addr_of","","",153,{"inputs":[{"name":"self"},{"name":"span"},{"generics":["expr"],"name":"p"}],"output":{"name":"expr"}}],[11,"expr_std_path","","",153,null],[11,"expr_match","","",153,{"inputs":[{"name":"self"},{"name":"span"},{"generics":["expr"],"name":"p"},{"generics":["arm"],"name":"hirvec"},{"name":"matchsource"}],"output":{"name":"expr"}}],[11,"expr_block","","",153,{"inputs":[{"name":"self"},{"generics":["block"],"name":"p"},{"generics":["attribute"],"name":"thinvec"}],"output":{"name":"expr"}}],[11,"expr_tuple","","",153,{"inputs":[{"name":"self"},{"name":"span"},{"generics":["expr"],"name":"hirvec"}],"output":{"generics":["expr"],"name":"p"}}],[11,"expr","","",153,{"inputs":[{"name":"self"},{"name":"span"},{"name":"expr_"},{"generics":["attribute"],"name":"thinvec"}],"output":{"name":"expr"}}],[11,"stmt_let_pat","","",153,{"inputs":[{"name":"self"},{"name":"span"},{"generics":["p"],"name":"option"},{"generics":["pat"],"name":"p"},{"name":"localsource"}],"output":{"name":"stmt"}}],[11,"stmt_let","","",153,null],[11,"block_expr","","",153,{"inputs":[{"name":"self"},{"generics":["expr"],"name":"p"}],"output":{"name":"block"}}],[11,"block_all","","",153,{"inputs":[{"name":"self"},{"name":"span"},{"generics":["stmt"],"name":"hirvec"},{"generics":["p"],"name":"option"}],"output":{"name":"block"}}],[11,"pat_ok","","",153,{"inputs":[{"name":"self"},{"name":"span"},{"generics":["pat"],"name":"p"}],"output":{"generics":["pat"],"name":"p"}}],[11,"pat_err","","",153,{"inputs":[{"name":"self"},{"name":"span"},{"generics":["pat"],"name":"p"}],"output":{"generics":["pat"],"name":"p"}}],[11,"pat_some","","",153,{"inputs":[{"name":"self"},{"name":"span"},{"generics":["pat"],"name":"p"}],"output":{"generics":["pat"],"name":"p"}}],[11,"pat_none","","",153,{"inputs":[{"name":"self"},{"name":"span"}],"output":{"generics":["pat"],"name":"p"}}],[11,"pat_std_enum","","",153,null],[11,"pat_ident","","",153,{"inputs":[{"name":"self"},{"name":"span"},{"name":"name"}],"output":{"generics":["pat"],"name":"p"}}],[11,"pat_ident_binding_mode","","",153,{"inputs":[{"name":"self"},{"name":"span"},{"name":"name"},{"name":"bindingannotation"}],"output":{"generics":["pat"],"name":"p"}}],[11,"pat_wild","","",153,{"inputs":[{"name":"self"},{"name":"span"}],"output":{"generics":["pat"],"name":"p"}}],[11,"pat","","",153,{"inputs":[{"name":"self"},{"name":"span"},{"name":"patkind"}],"output":{"generics":["pat"],"name":"p"}}],[11,"std_path","","Given suffix [\"b\",\"c\",\"d\"], returns path `::std::b::c::d` when `fld.cx.use_std`, and `::core::b::c::d` otherwise. The path is also resolved according to `is_value`.",153,null],[11,"ty_path","","",153,{"inputs":[{"name":"self"},{"name":"lowerednodeid"},{"name":"span"},{"name":"qpath"}],"output":{"generics":["ty"],"name":"p"}}],[11,"elided_ref_lifetime","","Invoked to create the lifetime argument for a type `&T` with no explicit lifetime.",153,{"inputs":[{"name":"self"},{"name":"span"}],"output":{"name":"lifetime"}}],[11,"elided_path_lifetimes","","Invoked to create the lifetime argument(s) for a path like `std::cell::Ref<T>`; note that implicit lifetimes in these sorts of cases are deprecated. This may therefore report a warning or an error, depending on the mode.",153,{"inputs":[{"name":"self"},{"name":"span"},{"name":"usize"}],"output":{"name":"p"}}],[11,"elided_dyn_bound","","Invoked to create the lifetime argument(s) for an elided trait object bound, like the bound in `Box<dyn Debug>`. This method is not invoked when the bound is written, even if it is written with `'_` like in `Box<dyn Debug + '_>`. In those cases, `lower_lifetime` is invoked.",153,{"inputs":[{"name":"self"},{"name":"span"}],"output":{"name":"lifetime"}}],[11,"new_implicit_lifetime","","",153,{"inputs":[{"name":"self"},{"name":"span"}],"output":{"name":"lifetime"}}],[11,"maybe_lint_bare_trait","","",153,{"inputs":[{"name":"self"},{"name":"span"},{"name":"nodeid"},{"name":"bool"}],"output":null}],[11,"wrap_in_try_constructor","","",153,{"inputs":[{"name":"self"},{"name":"str"},{"name":"expr"},{"name":"span"}],"output":{"generics":["expr"],"name":"p"}}],[0,"map","rustc::hir","",null,null],[3,"DefCollector","rustc::hir::map","Creates def ids for nodes in the AST.",null,null],[12,"definitions","","",160,null],[12,"parent_def","","",160,null],[12,"expansion","","",160,null],[12,"visit_macro_invoc","","",160,null],[3,"MacroInvocationData","","",null,null],[12,"mark","","",161,null],[12,"def_index","","",161,null],[12,"const_expr","","",161,null],[3,"Forest","","Stores a crate and any number of inlined items from other crates.",null,null],[12,"krate","","",162,null],[12,"dep_graph","","",162,null],[3,"Map","","Represents a mapping from Node IDs to AST elements and their parent Node IDs",null,null],[12,"forest","","The backing storage for all the AST nodes.",163,null],[12,"dep_graph","","Same as the dep_graph in forest, just available with one fewer deref. This is a gratuitous micro-optimization.",163,null],[12,"crate_hash","","The SVH of the local crate.",163,null],[12,"map","","NodeIds are sequential integers from 0, so we can be super-compact by storing them in a vector. Not everything with a NodeId is in the map, but empirically the occupancy is about 75-80%, so there's not too much overhead (certainly less than a hashmap, since they (at the time of writing) have a maximum of 75% occupancy).",163,null],[12,"definitions","","",163,null],[12,"hir_to_node_id","","The reverse mapping of `node_to_hir_id`.",163,null],[3,"NodesMatchingSuffix","","",null,null],[12,"map","","",164,null],[12,"item_name","","",164,null],[12,"in_which","","",164,null],[12,"idx","","",164,null],[4,"Node","","",null,null],[13,"NodeItem","","",165,null],[13,"NodeForeignItem","","",165,null],[13,"NodeTraitItem","","",165,null],[13,"NodeImplItem","","",165,null],[13,"NodeVariant","","",165,null],[13,"NodeField","","",165,null],[13,"NodeExpr","","",165,null],[13,"NodeStmt","","",165,null],[13,"NodeTy","","",165,null],[13,"NodeTraitRef","","",165,null],[13,"NodeBinding","","",165,null],[13,"NodePat","","",165,null],[13,"NodeBlock","","",165,null],[13,"NodeLocal","","",165,null],[13,"NodeMacroDef","","",165,null],[13,"NodeStructCtor","","NodeStructCtor represents a tuple struct.",165,null],[13,"NodeLifetime","","",165,null],[13,"NodeTyParam","","",165,null],[13,"NodeVisibility","","",165,null],[4,"MapEntry","","Represents an entry and its parent NodeID. The odd layout is to bring down the total size.",null,null],[13,"NotPresent","","Placeholder for holes in the map.",166,null],[13,"EntryItem","","All the node types, with a parent ID.",166,null],[13,"EntryForeignItem","","",166,null],[13,"EntryTraitItem","","",166,null],[13,"EntryImplItem","","",166,null],[13,"EntryVariant","","",166,null],[13,"EntryField","","",166,null],[13,"EntryExpr","","",166,null],[13,"EntryStmt","","",166,null],[13,"EntryTy","","",166,null],[13,"EntryTraitRef","","",166,null],[13,"EntryBinding","","",166,null],[13,"EntryPat","","",166,null],[13,"EntryBlock","","",166,null],[13,"EntryStructCtor","","",166,null],[13,"EntryLifetime","","",166,null],[13,"EntryTyParam","","",166,null],[13,"EntryVisibility","","",166,null],[13,"EntryLocal","","",166,null],[13,"EntryMacroDef","","",166,null],[13,"RootCrate","","Roots for node trees. The DepNodeIndex is the dependency node of the crate's root module.",166,null],[5,"map_crate","","",null,{"inputs":[{"name":"session"},{"name":"cratestore"},{"name":"forest"},{"name":"definitions"}],"output":{"name":"map"}}],[5,"node_id_to_string","","",null,{"inputs":[{"name":"map"},{"name":"nodeid"},{"name":"bool"}],"output":{"name":"string"}}],[5,"describe_def","","",null,{"inputs":[{"name":"tyctxt"},{"name":"defid"}],"output":{"generics":["def"],"name":"option"}}],[0,"blocks","","This module provides a simplified abstraction for working with code blocks identified by their integer node-id.  In particular, it captures a common set of attributes that all \"function-like things\" (represented by `FnLike` instances) share.  For example, all `FnLike` instances have a type signature (be it explicit or inferred).  And all `FnLike` instances have a body, i.e. the code that is run when the function-like thing it represents is invoked.",null,null],[3,"FnLikeNode","rustc::hir::map::blocks","An FnLikeNode is a Node that is like a fn, in that it has a decl and a body (as well as a NodeId, a span, etc).",null,null],[12,"node","","",167,null],[3,"ItemFnParts","","These are all the components one can extract from a fn item for use when implementing FnLikeNode operations.",null,null],[12,"name","","",168,null],[12,"decl","","",168,null],[12,"unsafety","","",168,null],[12,"constness","","",168,null],[12,"abi","","",168,null],[12,"vis","","",168,null],[12,"generics","","",168,null],[12,"body","","",168,null],[12,"id","","",168,null],[12,"span","","",168,null],[12,"attrs","","",168,null],[3,"ClosureParts","","These are all the components one can extract from a closure expr for use when implementing FnLikeNode operations.",null,null],[12,"decl","","",169,null],[12,"body","","",169,null],[12,"id","","",169,null],[12,"span","","",169,null],[12,"attrs","","",169,null],[4,"Code","","Carries either an FnLikeNode or a Expr, as these are the two constructs that correspond to \"code\" (as in, something from which we can construct a control-flow graph).",null,null],[13,"FnLike","","",170,null],[13,"Expr","","",170,null],[8,"MaybeFnLike","","MaybeFnLike wraps a method that indicates if an object corresponds to some FnLikeNode.",null,null],[10,"is_fn_like","","",171,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",167,{"inputs":[{"name":"self"}],"output":{"name":"fnlikenode"}}],[11,"fmt","","",167,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"is_fn_like","rustc::hir","",82,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_fn_like","","",62,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_fn_like","","",57,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","rustc::hir::map::blocks","",170,{"inputs":[{"name":"self"}],"output":{"name":"code"}}],[11,"id","","",170,{"inputs":[{"name":"self"}],"output":{"name":"nodeid"}}],[11,"from_node","","Attempts to construct a Code from presumed FnLike or Expr node input.",170,{"inputs":[{"name":"map"},{"name":"nodeid"}],"output":{"generics":["code"],"name":"option"}}],[11,"new","","",169,null],[11,"from_node","","Attempts to construct a FnLikeNode from presumed FnLike node input.",167,{"inputs":[{"name":"node"}],"output":{"generics":["fnlikenode"],"name":"option"}}],[11,"body","","",167,{"inputs":[{"name":"self"}],"output":{"name":"bodyid"}}],[11,"decl","","",167,{"inputs":[{"name":"self"}],"output":{"name":"fndecl"}}],[11,"span","","",167,{"inputs":[{"name":"self"}],"output":{"name":"span"}}],[11,"id","","",167,{"inputs":[{"name":"self"}],"output":{"name":"nodeid"}}],[11,"constness","","",167,{"inputs":[{"name":"self"}],"output":{"name":"constness"}}],[11,"unsafety","","",167,{"inputs":[{"name":"self"}],"output":{"name":"unsafety"}}],[11,"kind","","",167,{"inputs":[{"name":"self"}],"output":{"name":"fnkind"}}],[11,"handle","","",167,{"inputs":[{"name":"self"},{"name":"i"},{"name":"m"},{"name":"c"}],"output":{"name":"a"}}],[0,"collector","rustc::hir::map","",null,null],[3,"NodeCollector","rustc::hir::map::collector","A Visitor that walks over the HIR and collects Nodes into a HIR map",null,null],[12,"krate","","The crate",172,null],[12,"map","","The node map",172,null],[12,"parent_node","","The parent of this node",172,null],[12,"current_dep_node_owner","","",172,null],[12,"current_signature_dep_index","","",172,null],[12,"current_full_dep_index","","",172,null],[12,"currently_in_body","","",172,null],[12,"dep_graph","","",172,null],[12,"definitions","","",172,null],[12,"hcx","","",172,null],[12,"hir_body_nodes","","",172,null],[3,"HirItemLike","","",null,null],[12,"item_like","","",173,null],[12,"hash_bodies","","",173,null],[11,"root","","",172,{"inputs":[{"name":"crate"},{"name":"depgraph"},{"name":"definitions"},{"name":"stablehashingcontext"}],"output":{"name":"nodecollector"}}],[11,"finalize_and_compute_crate_hash","","",172,null],[11,"insert_entry","","",172,{"inputs":[{"name":"self"},{"name":"nodeid"},{"name":"mapentry"}],"output":null}],[11,"insert","","",172,{"inputs":[{"name":"self"},{"name":"nodeid"},{"name":"node"}],"output":null}],[11,"with_parent","","",172,{"inputs":[{"name":"self"},{"name":"nodeid"},{"name":"f"}],"output":null}],[11,"with_dep_node_owner","","",172,{"inputs":[{"name":"self"},{"name":"defindex"},{"name":"t"},{"name":"f"}],"output":null}],[11,"nested_visit_map","","Because we want to track parent items and so forth, enable deep walking so that we walk nested items in the context of their outer items.",172,{"inputs":[{"name":"self"}],"output":{"name":"nestedvisitormap"}}],[11,"visit_nested_item","","",172,{"inputs":[{"name":"self"},{"name":"itemid"}],"output":null}],[11,"visit_nested_trait_item","","",172,{"inputs":[{"name":"self"},{"name":"traititemid"}],"output":null}],[11,"visit_nested_impl_item","","",172,{"inputs":[{"name":"self"},{"name":"implitemid"}],"output":null}],[11,"visit_nested_body","","",172,{"inputs":[{"name":"self"},{"name":"bodyid"}],"output":null}],[11,"visit_item","","",172,{"inputs":[{"name":"self"},{"name":"item"}],"output":null}],[11,"visit_foreign_item","","",172,{"inputs":[{"name":"self"},{"name":"foreignitem"}],"output":null}],[11,"visit_generics","","",172,{"inputs":[{"name":"self"},{"name":"generics"}],"output":null}],[11,"visit_trait_item","","",172,{"inputs":[{"name":"self"},{"name":"traititem"}],"output":null}],[11,"visit_impl_item","","",172,{"inputs":[{"name":"self"},{"name":"implitem"}],"output":null}],[11,"visit_pat","","",172,{"inputs":[{"name":"self"},{"name":"pat"}],"output":null}],[11,"visit_expr","","",172,{"inputs":[{"name":"self"},{"name":"expr"}],"output":null}],[11,"visit_stmt","","",172,{"inputs":[{"name":"self"},{"name":"stmt"}],"output":null}],[11,"visit_ty","","",172,{"inputs":[{"name":"self"},{"name":"ty"}],"output":null}],[11,"visit_trait_ref","","",172,{"inputs":[{"name":"self"},{"name":"traitref"}],"output":null}],[11,"visit_fn","","",172,{"inputs":[{"name":"self"},{"name":"fnkind"},{"name":"fndecl"},{"name":"bodyid"},{"name":"span"},{"name":"nodeid"}],"output":null}],[11,"visit_block","","",172,{"inputs":[{"name":"self"},{"name":"block"}],"output":null}],[11,"visit_local","","",172,{"inputs":[{"name":"self"},{"name":"local"}],"output":null}],[11,"visit_lifetime","","",172,{"inputs":[{"name":"self"},{"name":"lifetime"}],"output":null}],[11,"visit_vis","","",172,{"inputs":[{"name":"self"},{"name":"visibility"}],"output":null}],[11,"visit_macro_def","","",172,{"inputs":[{"name":"self"},{"name":"macrodef"}],"output":null}],[11,"visit_variant","","",172,{"inputs":[{"name":"self"},{"name":"variant"},{"name":"generics"},{"name":"nodeid"}],"output":null}],[11,"visit_struct_field","","",172,{"inputs":[{"name":"self"},{"name":"structfield"}],"output":null}],[11,"visit_trait_item_ref","","",172,{"inputs":[{"name":"self"},{"name":"traititemref"}],"output":null}],[11,"visit_impl_item_ref","","",172,{"inputs":[{"name":"self"},{"name":"implitemref"}],"output":null}],[11,"hash_stable","","",173,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[0,"def_collector","rustc::hir::map","",null,null],[3,"DefCollector","rustc::hir::map::def_collector","Creates def ids for nodes in the AST.",null,null],[12,"definitions","","",160,null],[12,"parent_def","","",160,null],[12,"expansion","","",160,null],[12,"visit_macro_invoc","","",160,null],[3,"MacroInvocationData","","",null,null],[12,"mark","","",161,null],[12,"def_index","","",161,null],[12,"const_expr","","",161,null],[11,"new","rustc::hir::map","",160,{"inputs":[{"name":"definitions"},{"name":"mark"}],"output":{"name":"self"}}],[11,"collect_root","","",160,{"inputs":[{"name":"self"},{"name":"str"},{"name":"cratedisambiguator"}],"output":null}],[11,"create_def","","",160,{"inputs":[{"name":"self"},{"name":"nodeid"},{"name":"defpathdata"},{"name":"defindexaddressspace"},{"name":"span"}],"output":{"name":"defindex"}}],[11,"with_parent","","",160,{"inputs":[{"name":"self"},{"name":"defindex"},{"name":"f"}],"output":null}],[11,"visit_const_expr","","",160,{"inputs":[{"name":"self"},{"name":"expr"}],"output":null}],[11,"visit_macro_invoc","","",160,{"inputs":[{"name":"self"},{"name":"nodeid"},{"name":"bool"}],"output":null}],[11,"visit_item","","",160,{"inputs":[{"name":"self"},{"name":"item"}],"output":null}],[11,"visit_use_tree","","",160,{"inputs":[{"name":"self"},{"name":"usetree"},{"name":"nodeid"},{"name":"bool"}],"output":null}],[11,"visit_foreign_item","","",160,{"inputs":[{"name":"self"},{"name":"foreignitem"}],"output":null}],[11,"visit_generic_param","","",160,{"inputs":[{"name":"self"},{"name":"genericparam"}],"output":null}],[11,"visit_trait_item","","",160,{"inputs":[{"name":"self"},{"name":"traititem"}],"output":null}],[11,"visit_impl_item","","",160,{"inputs":[{"name":"self"},{"name":"implitem"}],"output":null}],[11,"visit_pat","","",160,{"inputs":[{"name":"self"},{"name":"pat"}],"output":null}],[11,"visit_expr","","",160,{"inputs":[{"name":"self"},{"name":"expr"}],"output":null}],[11,"visit_ty","","",160,{"inputs":[{"name":"self"},{"name":"ty"}],"output":null}],[11,"visit_stmt","","",160,{"inputs":[{"name":"self"},{"name":"stmt"}],"output":null}],[11,"visit_token","","",160,{"inputs":[{"name":"self"},{"name":"token"}],"output":null}],[0,"definitions","","For each definition, we track the following data.  A definition here is defined somewhat circularly as \"something with a def-id\", but it generally corresponds to things like structs, enums, etc. There are also some rather random cases (like const initializer expressions) that are mostly just leftovers.",null,null],[3,"DefPathTable","rustc::hir::map::definitions","The DefPathTable maps DefIndexes to DefKeys and vice versa. Internally the DefPathTable holds a tree of DefKeys, where each DefKey stores the DefIndex of its parent. There is one DefPathTable for each crate.",null,null],[12,"index_to_key","","",174,null],[12,"def_path_hashes","","",174,null],[3,"Definitions","","The definition table containing node definitions. It holds the DefPathTable for local DefIds/DefPaths and it also stores a mapping from NodeIds to local DefIds.",null,null],[12,"table","","",175,null],[12,"node_to_def_index","","",175,null],[12,"def_index_to_node","","",175,null],[12,"node_to_hir_id","","",175,null],[12,"macro_def_scopes","","",175,null],[12,"expansions","","",175,null],[12,"next_disambiguator","","",175,null],[12,"def_index_to_span","","",175,null],[3,"DefKey","","A unique identifier that we can use to lookup a definition precisely. It combines the index of the definition's parent (if any) with a `DisambiguatedDefPathData`.",null,null],[12,"parent","","Parent path.",176,null],[12,"disambiguated_data","","Identifier of this node.",176,null],[3,"DisambiguatedDefPathData","","Pair of `DefPathData` and an integer disambiguator. The integer is normally 0, but in the event that there are multiple defs with the same `parent` and `data`, we use this field to disambiguate between them. This introduces some artificial ordering dependency but means that if you have (e.g.) two impls for the same type in the same module, they do get distinct def-ids.",null,null],[12,"data","","",177,null],[12,"disambiguator","","",177,null],[3,"DefPath","","",null,null],[12,"data","","the path leading from the crate root to the item",178,null],[12,"krate","","what krate root is this path relative to?",178,null],[3,"DefPathHash","","",null,null],[12,"0","","",179,null],[4,"DefPathData","","",null,null],[13,"CrateRoot","","The crate root (marker)",180,null],[13,"Misc","","",180,null],[13,"Impl","","An impl",180,null],[13,"Trait","","A trait",180,null],[13,"AssocTypeInTrait","","An associated type declaration (i.e., in a trait)",180,null],[13,"AssocTypeInImpl","","An associated type value (i.e., in an impl)",180,null],[13,"TypeNs","","Something in the type NS",180,null],[13,"ValueNs","","Something in the value NS",180,null],[13,"Module","","A module declaration",180,null],[13,"MacroDef","","A macro rule",180,null],[13,"ClosureExpr","","A closure expression",180,null],[13,"TypeParam","","A type parameter (generic parameter)",180,null],[13,"LifetimeDef","","A lifetime definition",180,null],[13,"EnumVariant","","A variant of a enum",180,null],[13,"Field","","A struct field",180,null],[13,"StructCtor","","Implicit ctor for a tuple-like struct",180,null],[13,"Initializer","","Initializer for a const",180,null],[13,"ImplTrait","","An `impl Trait` type node.",180,null],[13,"Typeof","","A `typeof` type node.",180,null],[13,"GlobalMetaData","","GlobalMetaData identifies a piece of crate metadata that is global to a whole crate (as opposed to just one item). GlobalMetaData components are only supposed to show up right below the crate root.",180,null],[4,"GlobalMetaDataKind","","",null,null],[13,"Krate","","",181,null],[13,"CrateDeps","","",181,null],[13,"DylibDependencyFormats","","",181,null],[13,"LangItems","","",181,null],[13,"LangItemsMissing","","",181,null],[13,"NativeLibraries","","",181,null],[13,"CodeMap","","",181,null],[13,"Impls","","",181,null],[13,"ExportedSymbols","","",181,null],[17,"GLOBAL_MD_ADDRESS_SPACE","","",null,null],[11,"clone","","",174,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"allocate","","",174,{"inputs":[{"name":"self"},{"name":"defkey"},{"name":"defpathhash"},{"name":"defindexaddressspace"}],"output":{"name":"defindex"}}],[11,"next_id","","",174,{"inputs":[{"name":"self"},{"name":"defindexaddressspace"}],"output":{"name":"defindex"}}],[11,"def_key","","",174,{"inputs":[{"name":"self"},{"name":"defindex"}],"output":{"name":"defkey"}}],[11,"def_path_hash","","",174,{"inputs":[{"name":"self"},{"name":"defindex"}],"output":{"name":"defpathhash"}}],[11,"add_def_path_hashes_to","","",174,{"inputs":[{"name":"self"},{"name":"cratenum"},{"name":"fxhashmap"}],"output":null}],[11,"size","","",174,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"encode","","",174,{"inputs":[{"name":"self"},{"name":"s"}],"output":{"name":"result"}}],[11,"decode","","",174,{"inputs":[{"name":"d"}],"output":{"generics":["defpathtable"],"name":"result"}}],[11,"clone","","",175,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"clone","","",176,{"inputs":[{"name":"self"}],"output":{"name":"defkey"}}],[11,"fmt","","",176,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",176,{"inputs":[{"name":"self"},{"name":"defkey"}],"output":{"name":"bool"}}],[11,"ne","","",176,{"inputs":[{"name":"self"},{"name":"defkey"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",176,null],[11,"hash","","",176,null],[11,"encode","","",176,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",176,{"inputs":[{"name":"__d"}],"output":{"generics":["defkey"],"name":"result"}}],[11,"compute_stable_hash","","",176,{"inputs":[{"name":"self"},{"name":"defpathhash"}],"output":{"name":"defpathhash"}}],[11,"root_parent_stable_hash","","",176,{"inputs":[{"name":"str"},{"name":"cratedisambiguator"}],"output":{"name":"defpathhash"}}],[11,"clone","","",177,{"inputs":[{"name":"self"}],"output":{"name":"disambiguateddefpathdata"}}],[11,"fmt","","",177,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",177,{"inputs":[{"name":"self"},{"name":"disambiguateddefpathdata"}],"output":{"name":"bool"}}],[11,"ne","","",177,{"inputs":[{"name":"self"},{"name":"disambiguateddefpathdata"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",177,null],[11,"hash","","",177,null],[11,"encode","","",177,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",177,{"inputs":[{"name":"__d"}],"output":{"generics":["disambiguateddefpathdata"],"name":"result"}}],[11,"clone","","",178,{"inputs":[{"name":"self"}],"output":{"name":"defpath"}}],[11,"fmt","","",178,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",178,{"inputs":[{"name":"self"},{"name":"defpath"}],"output":{"name":"bool"}}],[11,"ne","","",178,{"inputs":[{"name":"self"},{"name":"defpath"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",178,null],[11,"hash","","",178,null],[11,"encode","","",178,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",178,{"inputs":[{"name":"__d"}],"output":{"generics":["defpath"],"name":"result"}}],[11,"is_local","","",178,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"make","","",178,{"inputs":[{"name":"cratenum"},{"name":"defindex"},{"name":"fn"}],"output":{"name":"defpath"}}],[11,"to_string_no_crate","","Returns a string representation of the DefPath without the crate-prefix. This method is useful if you don't have a TyCtxt available.",178,{"inputs":[{"name":"self"}],"output":{"name":"string"}}],[11,"to_filename_friendly_no_crate","","Return filename friendly string of the DefPah without the crate-prefix. This method is useful if you don't have a TyCtxt available.",178,{"inputs":[{"name":"self"}],"output":{"name":"string"}}],[11,"clone","","",180,{"inputs":[{"name":"self"}],"output":{"name":"defpathdata"}}],[11,"fmt","","",180,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"assert_receiver_is_total_eq","","",180,null],[11,"eq","","",180,{"inputs":[{"name":"self"},{"name":"defpathdata"}],"output":{"name":"bool"}}],[11,"ne","","",180,{"inputs":[{"name":"self"},{"name":"defpathdata"}],"output":{"name":"bool"}}],[11,"hash","","",180,null],[11,"encode","","",180,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",180,{"inputs":[{"name":"__d"}],"output":{"generics":["defpathdata"],"name":"result"}}],[11,"clone","","",179,{"inputs":[{"name":"self"}],"output":{"name":"defpathhash"}}],[11,"hash","","",179,null],[11,"eq","","",179,{"inputs":[{"name":"self"},{"name":"defpathhash"}],"output":{"name":"bool"}}],[11,"ne","","",179,{"inputs":[{"name":"self"},{"name":"defpathhash"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",179,null],[11,"partial_cmp","","",179,{"inputs":[{"name":"self"},{"name":"defpathhash"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",179,{"inputs":[{"name":"self"},{"name":"defpathhash"}],"output":{"name":"bool"}}],[11,"le","","",179,{"inputs":[{"name":"self"},{"name":"defpathhash"}],"output":{"name":"bool"}}],[11,"gt","","",179,{"inputs":[{"name":"self"},{"name":"defpathhash"}],"output":{"name":"bool"}}],[11,"ge","","",179,{"inputs":[{"name":"self"},{"name":"defpathhash"}],"output":{"name":"bool"}}],[11,"cmp","","",179,{"inputs":[{"name":"self"},{"name":"defpathhash"}],"output":{"name":"ordering"}}],[11,"fmt","","",179,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",179,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",179,{"inputs":[{"name":"__d"}],"output":{"generics":["defpathhash"],"name":"result"}}],[11,"hash_stable","","",179,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"new","","Create new empty definition map.",175,{"inputs":[],"output":{"name":"definitions"}}],[11,"def_path_table","","",175,{"inputs":[{"name":"self"}],"output":{"name":"defpathtable"}}],[11,"def_index_counts_lo_hi","","Get the number of definitions.",175,null],[11,"def_key","","",175,{"inputs":[{"name":"self"},{"name":"defindex"}],"output":{"name":"defkey"}}],[11,"def_path_hash","","",175,{"inputs":[{"name":"self"},{"name":"defindex"}],"output":{"name":"defpathhash"}}],[11,"def_path","","Returns the path from the crate root to `index`. The root nodes are not included in the path (i.e., this will be an empty vector for the crate root). For an inlined item, this will be the path of the item in the external crate (but the path will begin with the path to the external crate).",175,{"inputs":[{"name":"self"},{"name":"defindex"}],"output":{"name":"defpath"}}],[11,"opt_def_index","","",175,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"generics":["defindex"],"name":"option"}}],[11,"opt_local_def_id","","",175,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"generics":["defid"],"name":"option"}}],[11,"local_def_id","","",175,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"defid"}}],[11,"as_local_node_id","","",175,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["nodeid"],"name":"option"}}],[11,"node_to_hir_id","","",175,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"hirid"}}],[11,"find_node_for_hir_id","","",175,{"inputs":[{"name":"self"},{"name":"hirid"}],"output":{"name":"nodeid"}}],[11,"def_index_to_hir_id","","",175,{"inputs":[{"name":"self"},{"name":"defindex"}],"output":{"name":"hirid"}}],[11,"opt_span","","Retrieve the span of the given `DefId` if `DefId` is in the local crate, the span exists and it's not DUMMY_SP",175,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["span"],"name":"option"}}],[11,"create_root_def","","Add a definition with a parent definition.",175,{"inputs":[{"name":"self"},{"name":"str"},{"name":"cratedisambiguator"}],"output":{"name":"defindex"}}],[11,"create_def_with_parent","","Add a definition with a parent definition.",175,{"inputs":[{"name":"self"},{"name":"defindex"},{"name":"nodeid"},{"name":"defpathdata"},{"name":"defindexaddressspace"},{"name":"mark"},{"name":"span"}],"output":{"name":"defindex"}}],[11,"init_node_id_to_hir_id_mapping","","Initialize the ast::NodeId to HirId mapping once it has been generated during AST to HIR lowering.",175,{"inputs":[{"name":"self"},{"generics":["nodeid","hirid"],"name":"indexvec"}],"output":null}],[11,"expansion","","",175,{"inputs":[{"name":"self"},{"name":"defindex"}],"output":{"name":"mark"}}],[11,"macro_def_scope","","",175,{"inputs":[{"name":"self"},{"name":"mark"}],"output":{"name":"defid"}}],[11,"add_macro_def_scope","","",175,{"inputs":[{"name":"self"},{"name":"mark"},{"name":"defid"}],"output":null}],[11,"get_opt_name","","",180,{"inputs":[{"name":"self"}],"output":{"generics":["internedstring"],"name":"option"}}],[11,"as_interned_str","","",180,{"inputs":[{"name":"self"}],"output":{"name":"internedstring"}}],[11,"to_string","","",180,{"inputs":[{"name":"self"}],"output":{"name":"string"}}],[11,"clone","","",181,{"inputs":[{"name":"self"}],"output":{"name":"globalmetadatakind"}}],[11,"fmt","","",181,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",181,{"inputs":[{"name":"self"},{"name":"globalmetadatakind"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",181,null],[11,"partial_cmp","","",181,{"inputs":[{"name":"self"},{"name":"globalmetadatakind"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"cmp","","",181,{"inputs":[{"name":"self"},{"name":"globalmetadatakind"}],"output":{"name":"ordering"}}],[11,"hash","","",181,null],[11,"encode","","",181,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",181,{"inputs":[{"name":"__d"}],"output":{"generics":["globalmetadatakind"],"name":"result"}}],[11,"allocate_def_indices","","",181,{"inputs":[{"name":"definitions"}],"output":null}],[11,"def_index","","",181,{"inputs":[{"name":"self"},{"name":"defpathtable"}],"output":{"name":"defindex"}}],[11,"name","","",181,{"inputs":[{"name":"self"}],"output":{"name":"symbol"}}],[0,"hir_id_validator","rustc::hir::map","",null,null],[3,"HirIdValidator","rustc::hir::map::hir_id_validator","",null,null],[12,"hir_map","","",182,null],[12,"owner_def_index","","",182,null],[12,"hir_ids_seen","","",182,null],[12,"errors","","",182,null],[3,"OuterVisitor","","",null,null],[12,"hir_map","","",183,null],[12,"errors","","",183,null],[5,"check_crate","","",null,{"inputs":[{"name":"map"}],"output":null}],[11,"new_inner_visitor","","",183,{"inputs":[{"name":"self"},{"name":"map"}],"output":{"name":"hiridvalidator"}}],[11,"visit_item","","",183,{"inputs":[{"name":"self"},{"name":"item"}],"output":null}],[11,"visit_trait_item","","",183,{"inputs":[{"name":"self"},{"name":"traititem"}],"output":null}],[11,"visit_impl_item","","",183,{"inputs":[{"name":"self"},{"name":"implitem"}],"output":null}],[11,"check","","",182,{"inputs":[{"name":"self"},{"name":"nodeid"},{"name":"f"}],"output":null}],[11,"nested_visit_map","","",182,{"inputs":[{"name":"self"}],"output":{"name":"nestedvisitormap"}}],[11,"visit_id","","",182,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":null}],[11,"visit_impl_item_ref","","",182,{"inputs":[{"name":"self"},{"name":"implitemref"}],"output":null}],[17,"ITEM_LIKE_SPACE","rustc::hir::map","",null,null],[17,"REGULAR_SPACE","","",null,null],[8,"Named","","",null,null],[10,"name","","",184,{"inputs":[{"name":"self"}],"output":{"name":"name"}}],[11,"clone","","",165,{"inputs":[{"name":"self"}],"output":{"name":"node"}}],[11,"fmt","","",165,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",166,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",166,{"inputs":[{"name":"self"}],"output":{"name":"mapentry"}}],[11,"parent_node","","",166,{"inputs":[{"name":"self"}],"output":{"generics":["nodeid"],"name":"option"}}],[11,"to_node","","",166,{"inputs":[{"name":"self"}],"output":{"generics":["node"],"name":"option"}}],[11,"associated_body","","",166,{"inputs":[{"name":"self"}],"output":{"generics":["bodyid"],"name":"option"}}],[11,"is_body_owner","","",166,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"bool"}}],[11,"new","","",162,{"inputs":[{"name":"crate"},{"name":"depgraph"}],"output":{"name":"forest"}}],[11,"krate","","",162,{"inputs":[{"name":"self"}],"output":{"name":"crate"}}],[11,"clone","","",163,{"inputs":[{"name":"self"}],"output":{"name":"map"}}],[11,"read","","Registers a read in the dependency graph of the AST node with the given `id`. This needs to be called each time a public function returns the HIR for a node -- in other words, when it \"reveals\" the content of a node to the caller (who might not otherwise have had access to those contents, and hence needs a read recorded). If the function just returns a DefId or NodeId, no actual content was returned, so no read is needed.",163,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":null}],[11,"definitions","","",163,{"inputs":[{"name":"self"}],"output":{"name":"definitions"}}],[11,"def_key","","",163,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"defkey"}}],[11,"def_path_from_id","","",163,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"generics":["defpath"],"name":"option"}}],[11,"def_path","","",163,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"defpath"}}],[11,"local_def_id","","",163,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"defid"}}],[11,"opt_local_def_id","","",163,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"generics":["defid"],"name":"option"}}],[11,"as_local_node_id","","",163,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["nodeid"],"name":"option"}}],[11,"hir_to_node_id","","",163,{"inputs":[{"name":"self"},{"name":"hirid"}],"output":{"name":"nodeid"}}],[11,"node_to_hir_id","","",163,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"hirid"}}],[11,"def_index_to_hir_id","","",163,{"inputs":[{"name":"self"},{"name":"defindex"}],"output":{"name":"hirid"}}],[11,"def_index_to_node_id","","",163,{"inputs":[{"name":"self"},{"name":"defindex"}],"output":{"name":"nodeid"}}],[11,"local_def_id_to_hir_id","","",163,{"inputs":[{"name":"self"},{"name":"localdefid"}],"output":{"name":"hirid"}}],[11,"local_def_id_to_node_id","","",163,{"inputs":[{"name":"self"},{"name":"localdefid"}],"output":{"name":"nodeid"}}],[11,"describe_def","","",163,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"generics":["def"],"name":"option"}}],[11,"entry_count","","",163,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"find_entry","","",163,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"generics":["mapentry"],"name":"option"}}],[11,"krate","","",163,{"inputs":[{"name":"self"}],"output":{"name":"crate"}}],[11,"trait_item","","",163,{"inputs":[{"name":"self"},{"name":"traititemid"}],"output":{"name":"traititem"}}],[11,"impl_item","","",163,{"inputs":[{"name":"self"},{"name":"implitemid"}],"output":{"name":"implitem"}}],[11,"body","","",163,{"inputs":[{"name":"self"},{"name":"bodyid"}],"output":{"name":"body"}}],[11,"body_owner","","Returns the `NodeId` that corresponds to the definition of which this is the body of, i.e. a `fn`, `const` or `static` item (possibly associated), or a closure, or the body itself for embedded constant expressions (e.g. `N` in `[T; N]`).",163,{"inputs":[{"name":"self"},{"name":"bodyid"}],"output":{"name":"nodeid"}}],[11,"body_owner_def_id","","",163,{"inputs":[{"name":"self"},{"name":"bodyid"}],"output":{"name":"defid"}}],[11,"maybe_body_owned_by","","Given a node id, returns the `BodyId` associated with it, if the node is a body owner, otherwise returns `None`.",163,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"generics":["bodyid"],"name":"option"}}],[11,"body_owned_by","","Given a body owner's id, returns the `BodyId` associated with it.",163,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"bodyid"}}],[11,"body_owner_kind","","",163,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"bodyownerkind"}}],[11,"ty_param_owner","","",163,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"nodeid"}}],[11,"ty_param_name","","",163,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"name"}}],[11,"trait_impls","","",163,null],[11,"trait_auto_impl","","",163,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["nodeid"],"name":"option"}}],[11,"trait_is_auto","","",163,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"bool"}}],[11,"krate_attrs","","Get the attributes on the krate. This is preferable to invoking `krate.attrs` because it registers a tighter dep-graph access.",163,null],[11,"get","","Retrieve the Node corresponding to `id`, panicking if it cannot be found.",163,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"node"}}],[11,"get_if_local","","",163,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["node"],"name":"option"}}],[11,"find","","Retrieve the Node corresponding to `id`, returning None if cannot be found.",163,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"generics":["node"],"name":"option"}}],[11,"get_parent_node","","Similar to get_parent, returns the parent node id or id if there is no parent. Note that the parent may be CRATE_NODE_ID, which is not itself present in the map -- so passing the return value of get_parent_node to get may actually panic. This function returns the immediate parent in the AST, whereas get_parent returns the enclosing item. Note that this might not be the actual parent node in the AST - some kinds of nodes are not in the map and these will never appear as the parent_node. So you can always walk the parent_nodes from a node to the root of the ast (unless you get the same id back here that can happen if the id is not in the map itself or is just weird).",163,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"nodeid"}}],[11,"is_argument","","Check if the node is an argument. An argument is a local variable whose immediate parent is an item or a closure.",163,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"bool"}}],[11,"walk_parent_nodes","","If there is some error when walking the parents (e.g., a node does not have a parent in the map or a node can't be found), then we return the last good node id we found. Note that reaching the crate root (id == 0), is not an error, since items in the crate module have the crate root as parent.",163,{"inputs":[{"name":"self"},{"name":"nodeid"},{"name":"f"},{"name":"f2"}],"output":{"generics":["nodeid","nodeid"],"name":"result"}}],[11,"get_return_block","","Retrieve the NodeId for `id`'s enclosing method, unless there's a `while` or `loop` before reaching it, as block tail returns are not available in them.",163,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"generics":["nodeid"],"name":"option"}}],[11,"get_parent","","Retrieve the NodeId for `id`'s parent item, or `id` itself if no parent item is in this map. The \"parent item\" is the closest parent node in the AST which is recorded by the map and is an item, either an item in a module, trait, or impl.",163,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"nodeid"}}],[11,"get_module_parent","","Returns the NodeId of `id`'s nearest module parent, or `id` itself if no module parent is in this map.",163,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"defid"}}],[11,"get_enclosing_scope","","Returns the nearest enclosing scope. A scope is an item or block. FIXME it is not clear to me that all items qualify as scopes - statics and associated types probably shouldn't, for example. Behavior in this regard should be expected to be highly unstable.",163,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"generics":["nodeid"],"name":"option"}}],[11,"get_parent_did","","",163,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"defid"}}],[11,"get_foreign_abi","","",163,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"abi"}}],[11,"expect_item","","",163,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"item"}}],[11,"expect_impl_item","","",163,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"implitem"}}],[11,"expect_trait_item","","",163,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"traititem"}}],[11,"expect_variant_data","","",163,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"variantdata"}}],[11,"expect_variant","","",163,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"variant"}}],[11,"expect_foreign_item","","",163,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"foreignitem"}}],[11,"expect_expr","","",163,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"expr"}}],[11,"name","","Returns the name associated with the given NodeId's AST.",163,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"name"}}],[11,"attrs","","Given a node ID, get a list of attributes associated with the AST corresponding to the Node ID",163,null],[11,"nodes_matching_suffix","","Returns an iterator that yields the node id's with paths that match `parts`.  (Requires `parts` is non-empty.)",163,null],[11,"span","","",163,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"span"}}],[11,"span_if_local","","",163,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["span"],"name":"option"}}],[11,"node_to_string","","",163,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"string"}}],[11,"node_to_user_string","","",163,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"string"}}],[11,"node_to_pretty_string","","",163,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"string"}}],[11,"suffix_matches","","Returns true only if some suffix of the module path for parent matches `self.in_which`.",164,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"bool"}}],[11,"matches_names","","",164,{"inputs":[{"name":"self"},{"name":"nodeid"},{"name":"name"}],"output":{"name":"bool"}}],[11,"next","","",164,{"inputs":[{"name":"self"}],"output":{"generics":["nodeid"],"name":"option"}}],[11,"name","rustc::hir","",82,{"inputs":[{"name":"self"}],"output":{"name":"name"}}],[11,"name","","",85,{"inputs":[{"name":"self"}],"output":{"name":"name"}}],[11,"name","","",77,{"inputs":[{"name":"self"}],"output":{"name":"name"}}],[11,"name","","",80,{"inputs":[{"name":"self"}],"output":{"name":"name"}}],[11,"name","","",62,{"inputs":[{"name":"self"}],"output":{"name":"name"}}],[11,"name","","",64,{"inputs":[{"name":"self"}],"output":{"name":"name"}}],[11,"nested","rustc::hir::map","",163,{"inputs":[{"name":"self"},{"name":"state"},{"name":"nested"}],"output":{"name":"result"}}],[0,"pat_util","rustc::hir","",null,null],[3,"EnumerateAndAdjust","rustc::hir::pat_util","",null,null],[12,"enumerate","","",185,null],[12,"gap_pos","","",185,null],[12,"gap_len","","",185,null],[8,"EnumerateAndAdjustIterator","","",null,null],[10,"enumerate_and_adjust","","",186,{"inputs":[{"name":"self"},{"name":"usize"},{"generics":["usize"],"name":"option"}],"output":{"name":"enumerateandadjust"}}],[11,"next","","",185,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",185,null],[11,"is_refutable","rustc::hir","",50,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_const","","",50,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"each_binding","","Call `f` on every \"binding\" in a pattern, e.g., on `a` in `match foo() { Some(a) => (), None => () }`",50,{"inputs":[{"name":"self"},{"name":"f"}],"output":null}],[11,"contains_bindings","","Checks if the pattern contains any patterns that bind something to an ident, e.g. `foo`, or `Foo(foo)` or `foo @ Bar(..)`.",50,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"contains_bindings_or_wild","","Checks if the pattern contains any patterns that bind something to an ident or wildcard, e.g. `foo`, or `Foo(_)`, `foo @ Bar(..)`,",50,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"simple_name","","",50,{"inputs":[{"name":"self"}],"output":{"generics":["name"],"name":"option"}}],[11,"necessary_variants","","Return variants that are necessary to exist for the pattern to match.",50,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"vec"}}],[11,"contains_explicit_ref_binding","","Checks if the pattern contains any `ref` or `ref mut` bindings, and if yes whether it contains mutable or just immutables ones.",50,{"inputs":[{"name":"self"}],"output":{"generics":["mutability"],"name":"option"}}],[11,"contains_explicit_ref_binding","","Checks if the patterns for this arm contain any `ref` or `ref mut` bindings, and if yes whether its containing mutable ones or just immutables ones.",53,{"inputs":[{"name":"self"}],"output":{"generics":["mutability"],"name":"option"}}],[0,"print","","",null,null],[3,"NoAnn","rustc::hir::print","",null,null],[3,"State","","",null,null],[12,"s","","",187,null],[12,"cm","","",187,null],[12,"comments","","",187,null],[12,"literals","","",187,null],[12,"cur_cmnt","","",187,null],[12,"boxes","","",187,null],[12,"ann","","",187,null],[4,"AnnNode","","",null,null],[13,"NodeName","","",188,null],[13,"NodeBlock","","",188,null],[13,"NodeItem","","",188,null],[13,"NodeSubItem","","",188,null],[13,"NodeExpr","","",188,null],[13,"NodePat","","",188,null],[4,"Nested","","",null,null],[13,"Item","","",189,null],[13,"TraitItem","","",189,null],[13,"ImplItem","","",189,null],[13,"Body","","",189,null],[13,"BodyArgPat","","",189,null],[5,"print_crate","","Requires you to pass an input filename and reader so that it can scan the input text for comments and literals to copy forward.",null,{"inputs":[{"name":"codemap"},{"name":"parsesess"},{"name":"crate"},{"name":"filename"},{"name":"read"},{"generics":["write"],"name":"box"},{"name":"ppann"},{"name":"bool"}],"output":{"name":"result"}}],[5,"to_string","","",null,{"inputs":[{"name":"ppann"},{"name":"f"}],"output":{"name":"string"}}],[5,"visibility_qualified","","",null,{"inputs":[{"name":"visibility"},{"name":"str"}],"output":{"name":"string"}}],[5,"expr_requires_semi_to_be_stmt","","Does this expression require a semicolon to be treated as a statement? The negation of this: 'can this expression be used as a statement without a semicolon' -- is used as an early-bail-out in the parser so that, for instance,     if true {...} else {...}      |x| 5 isn't parsed as (if true {...} else {...} | x) | 5",null,{"inputs":[{"name":"expr"}],"output":{"name":"bool"}}],[5,"stmt_ends_with_semi","","this statement requires a semicolon after it. note that in one case (stmt_semi), we've already seen the semicolon, and thus don't need another.",null,{"inputs":[{"name":"stmt_"}],"output":{"name":"bool"}}],[5,"bin_op_to_assoc_op","","",null,{"inputs":[{"name":"binop_"}],"output":{"name":"assocop"}}],[5,"contains_exterior_struct_lit","","Expressions that syntactically contain an \"exterior\" struct literal i.e. not surrounded by any parens or other delimiters, e.g. `X { y: 1 }`, `X { y: 1 }.method()`, `foo == X { y: 1 }` and `X { y: 1 } == foo` all do, but `(X { y: 1 }) == foo` does not.",null,{"inputs":[{"name":"expr"}],"output":{"name":"bool"}}],[17,"NO_ANN","","",null,null],[17,"indent_unit","","",null,null],[17,"default_columns","","",null,null],[8,"PpAnn","","",null,null],[11,"nested","","",190,{"inputs":[{"name":"self"},{"name":"state"},{"name":"nested"}],"output":{"name":"result"}}],[11,"pre","","",190,{"inputs":[{"name":"self"},{"name":"state"},{"name":"annnode"}],"output":{"name":"result"}}],[11,"post","","",190,{"inputs":[{"name":"self"},{"name":"state"},{"name":"annnode"}],"output":{"name":"result"}}],[11,"nested","rustc::hir","",47,{"inputs":[{"name":"self"},{"name":"state"},{"name":"nested"}],"output":{"name":"result"}}],[11,"writer","rustc::hir::print","",187,{"inputs":[{"name":"self"}],"output":{"name":"printer"}}],[11,"boxes","","",187,{"inputs":[{"name":"self"}],"output":{"name":"vec"}}],[11,"comments","","",187,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"cur_cmnt","","",187,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"cur_lit","","",187,{"inputs":[{"name":"self"}],"output":{"generics":["literal"],"name":"option"}}],[11,"bump_lit","","",187,{"inputs":[{"name":"self"}],"output":{"generics":["literal"],"name":"option"}}],[11,"new_from_input","","",187,{"inputs":[{"name":"codemap"},{"name":"parsesess"},{"name":"filename"},{"name":"read"},{"generics":["write"],"name":"box"},{"name":"ppann"},{"name":"bool"}],"output":{"name":"state"}}],[11,"new","","",187,{"inputs":[{"name":"codemap"},{"generics":["write"],"name":"box"},{"name":"ppann"},{"generics":["vec"],"name":"option"},{"generics":["vec"],"name":"option"}],"output":{"name":"state"}}],[11,"cbox","","",187,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"result"}}],[11,"nbsp","","",187,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"word_nbsp","","",187,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"result"}}],[11,"head","","",187,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"result"}}],[11,"bopen","","",187,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"bclose_","","",187,{"inputs":[{"name":"self"},{"name":"span"},{"name":"usize"}],"output":{"name":"result"}}],[11,"bclose_maybe_open","","",187,{"inputs":[{"name":"self"},{"name":"span"},{"name":"usize"},{"name":"bool"}],"output":{"name":"result"}}],[11,"bclose","","",187,{"inputs":[{"name":"self"},{"name":"span"}],"output":{"name":"result"}}],[11,"in_cbox","","",187,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"space_if_not_bol","","",187,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"break_offset_if_not_bol","","",187,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"isize"}],"output":{"name":"result"}}],[11,"synth_comment","","",187,{"inputs":[{"name":"self"},{"name":"string"}],"output":{"name":"result"}}],[11,"commasep_cmnt","","",187,null],[11,"commasep_exprs","","",187,null],[11,"print_mod","","",187,null],[11,"print_foreign_mod","","",187,null],[11,"print_opt_lifetime","","",187,{"inputs":[{"name":"self"},{"name":"lifetime"}],"output":{"name":"result"}}],[11,"print_type","","",187,{"inputs":[{"name":"self"},{"name":"ty"}],"output":{"name":"result"}}],[11,"print_foreign_item","","",187,{"inputs":[{"name":"self"},{"name":"foreignitem"}],"output":{"name":"result"}}],[11,"print_associated_const","","",187,{"inputs":[{"name":"self"},{"name":"name"},{"name":"ty"},{"generics":["bodyid"],"name":"option"},{"name":"visibility"}],"output":{"name":"result"}}],[11,"print_associated_type","","",187,{"inputs":[{"name":"self"},{"name":"name"},{"generics":["typarambounds"],"name":"option"},{"generics":["ty"],"name":"option"}],"output":{"name":"result"}}],[11,"print_item","","Pretty-print an item",187,{"inputs":[{"name":"self"},{"name":"item"}],"output":{"name":"result"}}],[11,"print_trait_ref","","",187,{"inputs":[{"name":"self"},{"name":"traitref"}],"output":{"name":"result"}}],[11,"print_formal_generic_params","","",187,null],[11,"print_poly_trait_ref","","",187,{"inputs":[{"name":"self"},{"name":"polytraitref"}],"output":{"name":"result"}}],[11,"print_enum_def","","",187,{"inputs":[{"name":"self"},{"name":"enumdef"},{"name":"generics"},{"name":"name"},{"name":"span"},{"name":"visibility"}],"output":{"name":"result"}}],[11,"print_variants","","",187,null],[11,"print_visibility","","",187,{"inputs":[{"name":"self"},{"name":"visibility"}],"output":{"name":"result"}}],[11,"print_defaultness","","",187,{"inputs":[{"name":"self"},{"name":"defaultness"}],"output":{"name":"result"}}],[11,"print_struct","","",187,{"inputs":[{"name":"self"},{"name":"variantdata"},{"name":"generics"},{"name":"name"},{"name":"span"},{"name":"bool"}],"output":{"name":"result"}}],[11,"print_variant","","",187,{"inputs":[{"name":"self"},{"name":"variant"}],"output":{"name":"result"}}],[11,"print_method_sig","","",187,null],[11,"print_trait_item","","",187,{"inputs":[{"name":"self"},{"name":"traititem"}],"output":{"name":"result"}}],[11,"print_impl_item","","",187,{"inputs":[{"name":"self"},{"name":"implitem"}],"output":{"name":"result"}}],[11,"print_stmt","","",187,{"inputs":[{"name":"self"},{"name":"stmt"}],"output":{"name":"result"}}],[11,"print_block","","",187,{"inputs":[{"name":"self"},{"name":"block"}],"output":{"name":"result"}}],[11,"print_block_unclosed","","",187,{"inputs":[{"name":"self"},{"name":"block"}],"output":{"name":"result"}}],[11,"print_block_unclosed_indent","","",187,{"inputs":[{"name":"self"},{"name":"block"},{"name":"usize"}],"output":{"name":"result"}}],[11,"print_block_with_attrs","","",187,null],[11,"print_block_maybe_unclosed","","",187,null],[11,"print_else","","",187,{"inputs":[{"name":"self"},{"generics":["expr"],"name":"option"}],"output":{"name":"result"}}],[11,"print_if","","",187,{"inputs":[{"name":"self"},{"name":"expr"},{"name":"expr"},{"generics":["expr"],"name":"option"}],"output":{"name":"result"}}],[11,"print_if_let","","",187,{"inputs":[{"name":"self"},{"name":"pat"},{"name":"expr"},{"name":"block"},{"generics":["expr"],"name":"option"}],"output":{"name":"result"}}],[11,"print_call_post","","",187,null],[11,"print_expr_maybe_paren","","",187,{"inputs":[{"name":"self"},{"name":"expr"},{"name":"i8"}],"output":{"name":"result"}}],[11,"print_expr_as_cond","","Print an expr using syntax that's acceptable in a condition position, such as the `cond` in `if cond { ... }`.",187,{"inputs":[{"name":"self"},{"name":"expr"}],"output":{"name":"result"}}],[11,"print_expr_vec","","",187,null],[11,"print_expr_repeat","","",187,{"inputs":[{"name":"self"},{"name":"expr"},{"name":"bodyid"}],"output":{"name":"result"}}],[11,"print_expr_struct","","",187,null],[11,"print_expr_tup","","",187,null],[11,"print_expr_call","","",187,null],[11,"print_expr_method_call","","",187,null],[11,"print_expr_binary","","",187,{"inputs":[{"name":"self"},{"name":"binop"},{"name":"expr"},{"name":"expr"}],"output":{"name":"result"}}],[11,"print_expr_unary","","",187,{"inputs":[{"name":"self"},{"name":"unop"},{"name":"expr"}],"output":{"name":"result"}}],[11,"print_expr_addr_of","","",187,{"inputs":[{"name":"self"},{"name":"mutability"},{"name":"expr"}],"output":{"name":"result"}}],[11,"print_expr","","",187,{"inputs":[{"name":"self"},{"name":"expr"}],"output":{"name":"result"}}],[11,"print_local_decl","","",187,{"inputs":[{"name":"self"},{"name":"local"}],"output":{"name":"result"}}],[11,"print_decl","","",187,{"inputs":[{"name":"self"},{"name":"decl"}],"output":{"name":"result"}}],[11,"print_usize","","",187,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"result"}}],[11,"print_name","","",187,{"inputs":[{"name":"self"},{"name":"name"}],"output":{"name":"result"}}],[11,"print_for_decl","","",187,{"inputs":[{"name":"self"},{"name":"local"},{"name":"expr"}],"output":{"name":"result"}}],[11,"print_path","","",187,{"inputs":[{"name":"self"},{"name":"path"},{"name":"bool"}],"output":{"name":"result"}}],[11,"print_qpath","","",187,{"inputs":[{"name":"self"},{"name":"qpath"},{"name":"bool"}],"output":{"name":"result"}}],[11,"print_path_parameters","","",187,{"inputs":[{"name":"self"},{"name":"pathparameters"},{"name":"bool"},{"name":"bool"}],"output":{"name":"result"}}],[11,"print_pat","","",187,{"inputs":[{"name":"self"},{"name":"pat"}],"output":{"name":"result"}}],[11,"print_arm","","",187,{"inputs":[{"name":"self"},{"name":"arm"}],"output":{"name":"result"}}],[11,"print_fn","","",187,null],[11,"print_closure_args","","",187,{"inputs":[{"name":"self"},{"name":"fndecl"},{"name":"bodyid"}],"output":{"name":"result"}}],[11,"print_capture_clause","","",187,{"inputs":[{"name":"self"},{"name":"captureclause"}],"output":{"name":"result"}}],[11,"print_bounds","","",187,null],[11,"print_lifetime","","",187,{"inputs":[{"name":"self"},{"name":"lifetime"}],"output":{"name":"result"}}],[11,"print_lifetime_def","","",187,{"inputs":[{"name":"self"},{"name":"lifetimedef"}],"output":{"name":"result"}}],[11,"print_generic_params","","",187,null],[11,"print_ty_param","","",187,{"inputs":[{"name":"self"},{"name":"typaram"}],"output":{"name":"result"}}],[11,"print_where_clause","","",187,{"inputs":[{"name":"self"},{"name":"whereclause"}],"output":{"name":"result"}}],[11,"print_mutability","","",187,{"inputs":[{"name":"self"},{"name":"mutability"}],"output":{"name":"result"}}],[11,"print_mt","","",187,{"inputs":[{"name":"self"},{"name":"mutty"}],"output":{"name":"result"}}],[11,"print_fn_output","","",187,{"inputs":[{"name":"self"},{"name":"fndecl"}],"output":{"name":"result"}}],[11,"print_ty_fn","","",187,null],[11,"maybe_print_trailing_comment","","",187,{"inputs":[{"name":"self"},{"name":"span"},{"generics":["bytepos"],"name":"option"}],"output":{"name":"result"}}],[11,"print_remaining_comments","","",187,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"print_opt_abi_and_extern_if_nondefault","","",187,{"inputs":[{"name":"self"},{"generics":["abi"],"name":"option"}],"output":{"name":"result"}}],[11,"print_extern_opt_abi","","",187,{"inputs":[{"name":"self"},{"generics":["abi"],"name":"option"}],"output":{"name":"result"}}],[11,"print_fn_header_info","","",187,{"inputs":[{"name":"self"},{"name":"unsafety"},{"name":"constness"},{"name":"abi"},{"name":"visibility"}],"output":{"name":"result"}}],[11,"print_unsafety","","",187,{"inputs":[{"name":"self"},{"name":"unsafety"}],"output":{"name":"result"}}],[11,"print_is_auto","","",187,{"inputs":[{"name":"self"},{"name":"isauto"}],"output":{"name":"result"}}],[0,"svh","rustc::hir","Calculation and management of a Strict Version Hash for crates",null,null],[3,"Svh","rustc::hir::svh","",null,null],[12,"hash","","",191,null],[11,"clone","","",191,{"inputs":[{"name":"self"}],"output":{"name":"svh"}}],[11,"eq","","",191,{"inputs":[{"name":"self"},{"name":"svh"}],"output":{"name":"bool"}}],[11,"ne","","",191,{"inputs":[{"name":"self"},{"name":"svh"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",191,null],[11,"fmt","","",191,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Create a new `Svh` given the hash. If you actually want to compute the SVH from some HIR, you want the `calculate_svh` function found in `librustc_incremental`.",191,{"inputs":[{"name":"u64"}],"output":{"name":"svh"}}],[11,"as_u64","","",191,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"to_string","","",191,{"inputs":[{"name":"self"}],"output":{"name":"string"}}],[11,"hash","","",191,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"fmt","","",191,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",191,{"inputs":[{"name":"self"},{"name":"s"}],"output":{"name":"result"}}],[11,"decode","","",191,{"inputs":[{"name":"d"}],"output":{"generics":["svh"],"name":"result"}}],[11,"hash_stable","","",191,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[6,"HirVec","rustc::hir","HIR doesn't commit to a concrete storage type and has its own alias for a vector. It can be `Vec`, `P<[T]>` or potentially `Box<[T]>`, or some other container with similar behavior. Unlike AST, HIR is mostly a static structure, so we can use an owned slice instead of `Vec` to avoid keeping extra capacity.",null,null],[6,"TyParamBounds","","",null,null],[6,"CrateConfig","","",null,null],[6,"BinOp","","",null,null],[6,"Stmt","","A statement",null,null],[6,"Decl","","",null,null],[6,"Variant","","",null,null],[6,"FreevarMap","","",null,null],[6,"CaptureModeMap","","",null,null],[6,"TraitMap","","",null,null],[6,"GlobMap","","",null,null],[17,"CRATE_HIR_ID","","The `HirId` corresponding to CRATE_NODE_ID and CRATE_DEF_INDEX",null,null],[17,"DUMMY_HIR_ID","","",null,null],[17,"DUMMY_ITEM_LOCAL_ID","","",null,null],[8,"GenericParamsExt","","",null,null],[10,"lifetimes","","",192,{"inputs":[{"name":"self"}],"output":{"generics":["iter"],"name":"filtermap"}}],[10,"ty_params","","",192,{"inputs":[{"name":"self"}],"output":{"generics":["iter"],"name":"filtermap"}}],[11,"clone","","",33,{"inputs":[{"name":"self"}],"output":{"name":"hirid"}}],[11,"eq","","",33,{"inputs":[{"name":"self"},{"name":"hirid"}],"output":{"name":"bool"}}],[11,"ne","","",33,{"inputs":[{"name":"self"},{"name":"hirid"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",33,null],[11,"hash","","",33,null],[11,"partial_cmp","","",33,{"inputs":[{"name":"self"},{"name":"hirid"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",33,{"inputs":[{"name":"self"},{"name":"hirid"}],"output":{"name":"bool"}}],[11,"le","","",33,{"inputs":[{"name":"self"},{"name":"hirid"}],"output":{"name":"bool"}}],[11,"gt","","",33,{"inputs":[{"name":"self"},{"name":"hirid"}],"output":{"name":"bool"}}],[11,"ge","","",33,{"inputs":[{"name":"self"},{"name":"hirid"}],"output":{"name":"bool"}}],[11,"cmp","","",33,{"inputs":[{"name":"self"},{"name":"hirid"}],"output":{"name":"ordering"}}],[11,"fmt","","",33,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"owner_def_id","","",33,{"inputs":[{"name":"self"}],"output":{"name":"defid"}}],[11,"owner_local_def_id","","",33,{"inputs":[{"name":"self"}],"output":{"name":"localdefid"}}],[11,"default_encode","","",33,{"inputs":[{"name":"self"},{"name":"s"}],"output":{"name":"result"}}],[11,"default_decode","","",33,{"inputs":[{"name":"d"}],"output":{"generics":["hirid"],"name":"result"}}],[11,"clone","","",34,{"inputs":[{"name":"self"}],"output":{"name":"itemlocalid"}}],[11,"eq","","",34,{"inputs":[{"name":"self"},{"name":"itemlocalid"}],"output":{"name":"bool"}}],[11,"ne","","",34,{"inputs":[{"name":"self"},{"name":"itemlocalid"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",34,null],[11,"hash","","",34,null],[11,"partial_cmp","","",34,{"inputs":[{"name":"self"},{"name":"itemlocalid"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",34,{"inputs":[{"name":"self"},{"name":"itemlocalid"}],"output":{"name":"bool"}}],[11,"le","","",34,{"inputs":[{"name":"self"},{"name":"itemlocalid"}],"output":{"name":"bool"}}],[11,"gt","","",34,{"inputs":[{"name":"self"},{"name":"itemlocalid"}],"output":{"name":"bool"}}],[11,"ge","","",34,{"inputs":[{"name":"self"},{"name":"itemlocalid"}],"output":{"name":"bool"}}],[11,"cmp","","",34,{"inputs":[{"name":"self"},{"name":"itemlocalid"}],"output":{"name":"ordering"}}],[11,"fmt","","",34,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",34,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",34,{"inputs":[{"name":"__d"}],"output":{"generics":["itemlocalid"],"name":"result"}}],[11,"as_usize","","",34,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"new","","",34,{"inputs":[{"name":"usize"}],"output":{"name":"self"}}],[11,"index","","",34,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"clone","","",35,{"inputs":[{"name":"self"}],"output":{"name":"label"}}],[11,"eq","","",35,{"inputs":[{"name":"self"},{"name":"label"}],"output":{"name":"bool"}}],[11,"ne","","",35,{"inputs":[{"name":"self"},{"name":"label"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",35,null],[11,"encode","","",35,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",35,{"inputs":[{"name":"__d"}],"output":{"generics":["label"],"name":"result"}}],[11,"hash","","",35,null],[11,"fmt","","",35,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",36,{"inputs":[{"name":"self"}],"output":{"name":"lifetime"}}],[11,"eq","","",36,{"inputs":[{"name":"self"},{"name":"lifetime"}],"output":{"name":"bool"}}],[11,"ne","","",36,{"inputs":[{"name":"self"},{"name":"lifetime"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",36,null],[11,"encode","","",36,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",36,{"inputs":[{"name":"__d"}],"output":{"generics":["lifetime"],"name":"result"}}],[11,"hash","","",36,null],[11,"fmt","","",90,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",90,{"inputs":[{"name":"self"}],"output":{"name":"lifetimename"}}],[11,"eq","","",90,{"inputs":[{"name":"self"},{"name":"lifetimename"}],"output":{"name":"bool"}}],[11,"ne","","",90,{"inputs":[{"name":"self"},{"name":"lifetimename"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",90,null],[11,"encode","","",90,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",90,{"inputs":[{"name":"__d"}],"output":{"generics":["lifetimename"],"name":"result"}}],[11,"hash","","",90,null],[11,"name","","",90,{"inputs":[{"name":"self"}],"output":{"name":"name"}}],[11,"fmt","","",36,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"is_elided","","",36,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_static","","",36,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",37,{"inputs":[{"name":"self"}],"output":{"name":"lifetimedef"}}],[11,"eq","","",37,{"inputs":[{"name":"self"},{"name":"lifetimedef"}],"output":{"name":"bool"}}],[11,"ne","","",37,{"inputs":[{"name":"self"},{"name":"lifetimedef"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",37,null],[11,"encode","","",37,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",37,{"inputs":[{"name":"__d"}],"output":{"generics":["lifetimedef"],"name":"result"}}],[11,"hash","","",37,null],[11,"fmt","","",37,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",38,{"inputs":[{"name":"self"}],"output":{"name":"path"}}],[11,"eq","","",38,{"inputs":[{"name":"self"},{"name":"path"}],"output":{"name":"bool"}}],[11,"ne","","",38,{"inputs":[{"name":"self"},{"name":"path"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",38,null],[11,"encode","","",38,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",38,{"inputs":[{"name":"__d"}],"output":{"generics":["path"],"name":"result"}}],[11,"hash","","",38,null],[11,"is_global","","",38,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"fmt","","",38,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",38,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",39,{"inputs":[{"name":"self"}],"output":{"name":"pathsegment"}}],[11,"eq","","",39,{"inputs":[{"name":"self"},{"name":"pathsegment"}],"output":{"name":"bool"}}],[11,"ne","","",39,{"inputs":[{"name":"self"},{"name":"pathsegment"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",39,null],[11,"encode","","",39,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",39,{"inputs":[{"name":"__d"}],"output":{"generics":["pathsegment"],"name":"result"}}],[11,"hash","","",39,null],[11,"fmt","","",39,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"from_name","","Convert an identifier to the corresponding segment.",39,{"inputs":[{"name":"name"}],"output":{"name":"pathsegment"}}],[11,"new","","",39,{"inputs":[{"name":"name"},{"name":"pathparameters"},{"name":"bool"}],"output":{"name":"self"}}],[11,"with_parameters","","",39,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"r"}}],[11,"clone","","",40,{"inputs":[{"name":"self"}],"output":{"name":"pathparameters"}}],[11,"eq","","",40,{"inputs":[{"name":"self"},{"name":"pathparameters"}],"output":{"name":"bool"}}],[11,"ne","","",40,{"inputs":[{"name":"self"},{"name":"pathparameters"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",40,null],[11,"encode","","",40,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",40,{"inputs":[{"name":"__d"}],"output":{"generics":["pathparameters"],"name":"result"}}],[11,"hash","","",40,null],[11,"fmt","","",40,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"none","","",40,{"inputs":[],"output":{"name":"self"}}],[11,"is_empty","","",40,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"inputs","","",40,null],[11,"clone","","",91,{"inputs":[{"name":"self"}],"output":{"name":"typarambound"}}],[11,"eq","","",91,{"inputs":[{"name":"self"},{"name":"typarambound"}],"output":{"name":"bool"}}],[11,"ne","","",91,{"inputs":[{"name":"self"},{"name":"typarambound"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",91,null],[11,"encode","","",91,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",91,{"inputs":[{"name":"__d"}],"output":{"generics":["typarambound"],"name":"result"}}],[11,"hash","","",91,null],[11,"fmt","","",91,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"span","","",91,{"inputs":[{"name":"self"}],"output":{"name":"span"}}],[11,"clone","","",92,{"inputs":[{"name":"self"}],"output":{"name":"traitboundmodifier"}}],[11,"eq","","",92,{"inputs":[{"name":"self"},{"name":"traitboundmodifier"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",92,null],[11,"encode","","",92,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",92,{"inputs":[{"name":"__d"}],"output":{"generics":["traitboundmodifier"],"name":"result"}}],[11,"hash","","",92,null],[11,"fmt","","",92,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",41,{"inputs":[{"name":"self"}],"output":{"name":"typaram"}}],[11,"eq","","",41,{"inputs":[{"name":"self"},{"name":"typaram"}],"output":{"name":"bool"}}],[11,"ne","","",41,{"inputs":[{"name":"self"},{"name":"typaram"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",41,null],[11,"encode","","",41,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",41,{"inputs":[{"name":"__d"}],"output":{"generics":["typaram"],"name":"result"}}],[11,"hash","","",41,null],[11,"fmt","","",41,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",93,{"inputs":[{"name":"self"}],"output":{"name":"genericparam"}}],[11,"eq","","",93,{"inputs":[{"name":"self"},{"name":"genericparam"}],"output":{"name":"bool"}}],[11,"ne","","",93,{"inputs":[{"name":"self"},{"name":"genericparam"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",93,null],[11,"encode","","",93,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",93,{"inputs":[{"name":"__d"}],"output":{"generics":["genericparam"],"name":"result"}}],[11,"hash","","",93,null],[11,"fmt","","",93,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"is_lifetime_param","","",93,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_type_param","","",93,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",42,{"inputs":[{"name":"self"}],"output":{"name":"generics"}}],[11,"eq","","",42,{"inputs":[{"name":"self"},{"name":"generics"}],"output":{"name":"bool"}}],[11,"ne","","",42,{"inputs":[{"name":"self"},{"name":"generics"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",42,null],[11,"encode","","",42,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",42,{"inputs":[{"name":"__d"}],"output":{"generics":["generics"],"name":"result"}}],[11,"hash","","",42,null],[11,"fmt","","",42,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"empty","","",42,{"inputs":[],"output":{"name":"generics"}}],[11,"is_lt_parameterized","","",42,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_type_parameterized","","",42,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"lifetimes","","",42,null],[11,"ty_params","","",42,null],[11,"attr_name","","",94,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"carries_unsafe_attr","","",42,{"inputs":[{"name":"self"}],"output":{"generics":["unsafegeneric"],"name":"option"}}],[11,"clone","","",95,{"inputs":[{"name":"self"}],"output":{"name":"synthetictyparamkind"}}],[11,"eq","","",95,{"inputs":[{"name":"self"},{"name":"synthetictyparamkind"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",95,null],[11,"encode","","",95,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",95,{"inputs":[{"name":"__d"}],"output":{"generics":["synthetictyparamkind"],"name":"result"}}],[11,"hash","","",95,null],[11,"fmt","","",95,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",43,{"inputs":[{"name":"self"}],"output":{"name":"whereclause"}}],[11,"eq","","",43,{"inputs":[{"name":"self"},{"name":"whereclause"}],"output":{"name":"bool"}}],[11,"ne","","",43,{"inputs":[{"name":"self"},{"name":"whereclause"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",43,null],[11,"encode","","",43,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",43,{"inputs":[{"name":"__d"}],"output":{"generics":["whereclause"],"name":"result"}}],[11,"hash","","",43,null],[11,"fmt","","",43,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",96,{"inputs":[{"name":"self"}],"output":{"name":"wherepredicate"}}],[11,"eq","","",96,{"inputs":[{"name":"self"},{"name":"wherepredicate"}],"output":{"name":"bool"}}],[11,"ne","","",96,{"inputs":[{"name":"self"},{"name":"wherepredicate"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",96,null],[11,"encode","","",96,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",96,{"inputs":[{"name":"__d"}],"output":{"generics":["wherepredicate"],"name":"result"}}],[11,"hash","","",96,null],[11,"fmt","","",96,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"span","","",96,{"inputs":[{"name":"self"}],"output":{"name":"span"}}],[11,"clone","","",44,{"inputs":[{"name":"self"}],"output":{"name":"whereboundpredicate"}}],[11,"eq","","",44,{"inputs":[{"name":"self"},{"name":"whereboundpredicate"}],"output":{"name":"bool"}}],[11,"ne","","",44,{"inputs":[{"name":"self"},{"name":"whereboundpredicate"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",44,null],[11,"encode","","",44,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",44,{"inputs":[{"name":"__d"}],"output":{"generics":["whereboundpredicate"],"name":"result"}}],[11,"hash","","",44,null],[11,"fmt","","",44,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",45,{"inputs":[{"name":"self"}],"output":{"name":"whereregionpredicate"}}],[11,"eq","","",45,{"inputs":[{"name":"self"},{"name":"whereregionpredicate"}],"output":{"name":"bool"}}],[11,"ne","","",45,{"inputs":[{"name":"self"},{"name":"whereregionpredicate"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",45,null],[11,"encode","","",45,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",45,{"inputs":[{"name":"__d"}],"output":{"generics":["whereregionpredicate"],"name":"result"}}],[11,"hash","","",45,null],[11,"fmt","","",45,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",46,{"inputs":[{"name":"self"}],"output":{"name":"whereeqpredicate"}}],[11,"eq","","",46,{"inputs":[{"name":"self"},{"name":"whereeqpredicate"}],"output":{"name":"bool"}}],[11,"ne","","",46,{"inputs":[{"name":"self"},{"name":"whereeqpredicate"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",46,null],[11,"encode","","",46,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",46,{"inputs":[{"name":"__d"}],"output":{"generics":["whereeqpredicate"],"name":"result"}}],[11,"hash","","",46,null],[11,"fmt","","",46,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",47,{"inputs":[{"name":"self"}],"output":{"name":"crate"}}],[11,"eq","","",47,{"inputs":[{"name":"self"},{"name":"crate"}],"output":{"name":"bool"}}],[11,"ne","","",47,{"inputs":[{"name":"self"},{"name":"crate"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",47,null],[11,"encode","","",47,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",47,{"inputs":[{"name":"__d"}],"output":{"generics":["crate"],"name":"result"}}],[11,"fmt","","",47,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"item","","",47,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"item"}}],[11,"trait_item","","",47,{"inputs":[{"name":"self"},{"name":"traititemid"}],"output":{"name":"traititem"}}],[11,"impl_item","","",47,{"inputs":[{"name":"self"},{"name":"implitemid"}],"output":{"name":"implitem"}}],[11,"visit_all_item_likes","","Visits all items in the crate in some deterministic (but unspecified) order. If you just need to process every item, but don't care about nesting, this method is the best choice.",47,{"inputs":[{"name":"self"},{"name":"v"}],"output":null}],[11,"body","","",47,{"inputs":[{"name":"self"},{"name":"bodyid"}],"output":{"name":"body"}}],[11,"clone","","",48,{"inputs":[{"name":"self"}],"output":{"name":"macrodef"}}],[11,"eq","","",48,{"inputs":[{"name":"self"},{"name":"macrodef"}],"output":{"name":"bool"}}],[11,"ne","","",48,{"inputs":[{"name":"self"},{"name":"macrodef"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",48,null],[11,"encode","","",48,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",48,{"inputs":[{"name":"__d"}],"output":{"generics":["macrodef"],"name":"result"}}],[11,"hash","","",48,null],[11,"fmt","","",48,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",49,{"inputs":[{"name":"self"}],"output":{"name":"block"}}],[11,"eq","","",49,{"inputs":[{"name":"self"},{"name":"block"}],"output":{"name":"bool"}}],[11,"ne","","",49,{"inputs":[{"name":"self"},{"name":"block"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",49,null],[11,"encode","","",49,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",49,{"inputs":[{"name":"__d"}],"output":{"generics":["block"],"name":"result"}}],[11,"hash","","",49,null],[11,"fmt","","",49,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",50,{"inputs":[{"name":"self"}],"output":{"name":"pat"}}],[11,"eq","","",50,{"inputs":[{"name":"self"},{"name":"pat"}],"output":{"name":"bool"}}],[11,"ne","","",50,{"inputs":[{"name":"self"},{"name":"pat"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",50,null],[11,"encode","","",50,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",50,{"inputs":[{"name":"__d"}],"output":{"generics":["pat"],"name":"result"}}],[11,"hash","","",50,null],[11,"fmt","","",50,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"walk_","","",50,{"inputs":[{"name":"self"},{"name":"g"}],"output":{"name":"bool"}}],[11,"walk","","",50,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"clone","","",51,{"inputs":[{"name":"self"}],"output":{"name":"fieldpat"}}],[11,"eq","","",51,{"inputs":[{"name":"self"},{"name":"fieldpat"}],"output":{"name":"bool"}}],[11,"ne","","",51,{"inputs":[{"name":"self"},{"name":"fieldpat"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",51,null],[11,"encode","","",51,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",51,{"inputs":[{"name":"__d"}],"output":{"generics":["fieldpat"],"name":"result"}}],[11,"hash","","",51,null],[11,"fmt","","",51,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",97,{"inputs":[{"name":"self"}],"output":{"name":"bindingannotation"}}],[11,"eq","","",97,{"inputs":[{"name":"self"},{"name":"bindingannotation"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",97,null],[11,"encode","","",97,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",97,{"inputs":[{"name":"__d"}],"output":{"generics":["bindingannotation"],"name":"result"}}],[11,"hash","","",97,null],[11,"fmt","","",97,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",98,{"inputs":[{"name":"self"}],"output":{"name":"rangeend"}}],[11,"eq","","",98,{"inputs":[{"name":"self"},{"name":"rangeend"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",98,null],[11,"encode","","",98,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",98,{"inputs":[{"name":"__d"}],"output":{"generics":["rangeend"],"name":"result"}}],[11,"hash","","",98,null],[11,"fmt","","",98,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",99,{"inputs":[{"name":"self"}],"output":{"name":"patkind"}}],[11,"eq","","",99,{"inputs":[{"name":"self"},{"name":"patkind"}],"output":{"name":"bool"}}],[11,"ne","","",99,{"inputs":[{"name":"self"},{"name":"patkind"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",99,null],[11,"encode","","",99,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",99,{"inputs":[{"name":"__d"}],"output":{"generics":["patkind"],"name":"result"}}],[11,"hash","","",99,null],[11,"fmt","","",99,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",100,{"inputs":[{"name":"self"}],"output":{"name":"mutability"}}],[11,"eq","","",100,{"inputs":[{"name":"self"},{"name":"mutability"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",100,null],[11,"encode","","",100,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",100,{"inputs":[{"name":"__d"}],"output":{"generics":["mutability"],"name":"result"}}],[11,"hash","","",100,null],[11,"fmt","","",100,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"and","","Return MutMutable only if both arguments are mutable.",100,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"self"}}],[11,"clone","","",101,{"inputs":[{"name":"self"}],"output":{"name":"binop_"}}],[11,"eq","","",101,{"inputs":[{"name":"self"},{"name":"binop_"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",101,null],[11,"encode","","",101,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",101,{"inputs":[{"name":"__d"}],"output":{"generics":["binop_"],"name":"result"}}],[11,"hash","","",101,null],[11,"fmt","","",101,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"as_str","","",101,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"is_lazy","","",101,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_shift","","",101,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_comparison","","",101,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_by_value","","Returns `true` if the binary operator takes its arguments by value",101,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"into","","",101,{"inputs":[{"name":"self"}],"output":{"name":"binopkind"}}],[11,"clone","","",102,{"inputs":[{"name":"self"}],"output":{"name":"unop"}}],[11,"eq","","",102,{"inputs":[{"name":"self"},{"name":"unop"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",102,null],[11,"encode","","",102,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",102,{"inputs":[{"name":"__d"}],"output":{"generics":["unop"],"name":"result"}}],[11,"hash","","",102,null],[11,"fmt","","",102,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"as_str","","",102,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"is_by_value","","Returns `true` if the unary operator takes its argument by value",102,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"fmt","","",103,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",103,{"inputs":[{"name":"self"}],"output":{"name":"stmt_"}}],[11,"eq","","",103,{"inputs":[{"name":"self"},{"name":"stmt_"}],"output":{"name":"bool"}}],[11,"ne","","",103,{"inputs":[{"name":"self"},{"name":"stmt_"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",103,null],[11,"encode","","",103,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",103,{"inputs":[{"name":"__d"}],"output":{"generics":["stmt_"],"name":"result"}}],[11,"hash","","",103,null],[11,"attrs","","",103,null],[11,"id","","",103,{"inputs":[{"name":"self"}],"output":{"name":"nodeid"}}],[11,"clone","","",52,{"inputs":[{"name":"self"}],"output":{"name":"local"}}],[11,"eq","","",52,{"inputs":[{"name":"self"},{"name":"local"}],"output":{"name":"bool"}}],[11,"ne","","",52,{"inputs":[{"name":"self"},{"name":"local"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",52,null],[11,"encode","","",52,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",52,{"inputs":[{"name":"__d"}],"output":{"generics":["local"],"name":"result"}}],[11,"hash","","",52,null],[11,"fmt","","",52,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",104,{"inputs":[{"name":"self"}],"output":{"name":"decl_"}}],[11,"eq","","",104,{"inputs":[{"name":"self"},{"name":"decl_"}],"output":{"name":"bool"}}],[11,"ne","","",104,{"inputs":[{"name":"self"},{"name":"decl_"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",104,null],[11,"encode","","",104,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",104,{"inputs":[{"name":"__d"}],"output":{"generics":["decl_"],"name":"result"}}],[11,"hash","","",104,null],[11,"fmt","","",104,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"attrs","","",104,null],[11,"is_local","","",104,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",53,{"inputs":[{"name":"self"}],"output":{"name":"arm"}}],[11,"eq","","",53,{"inputs":[{"name":"self"},{"name":"arm"}],"output":{"name":"bool"}}],[11,"ne","","",53,{"inputs":[{"name":"self"},{"name":"arm"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",53,null],[11,"encode","","",53,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",53,{"inputs":[{"name":"__d"}],"output":{"generics":["arm"],"name":"result"}}],[11,"hash","","",53,null],[11,"fmt","","",53,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",54,{"inputs":[{"name":"self"}],"output":{"name":"field"}}],[11,"eq","","",54,{"inputs":[{"name":"self"},{"name":"field"}],"output":{"name":"bool"}}],[11,"ne","","",54,{"inputs":[{"name":"self"},{"name":"field"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",54,null],[11,"encode","","",54,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",54,{"inputs":[{"name":"__d"}],"output":{"generics":["field"],"name":"result"}}],[11,"hash","","",54,null],[11,"fmt","","",54,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",105,{"inputs":[{"name":"self"}],"output":{"name":"blockcheckmode"}}],[11,"eq","","",105,{"inputs":[{"name":"self"},{"name":"blockcheckmode"}],"output":{"name":"bool"}}],[11,"ne","","",105,{"inputs":[{"name":"self"},{"name":"blockcheckmode"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",105,null],[11,"encode","","",105,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",105,{"inputs":[{"name":"__d"}],"output":{"generics":["blockcheckmode"],"name":"result"}}],[11,"hash","","",105,null],[11,"fmt","","",105,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",106,{"inputs":[{"name":"self"}],"output":{"name":"unsafesource"}}],[11,"eq","","",106,{"inputs":[{"name":"self"},{"name":"unsafesource"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",106,null],[11,"encode","","",106,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",106,{"inputs":[{"name":"__d"}],"output":{"generics":["unsafesource"],"name":"result"}}],[11,"hash","","",106,null],[11,"fmt","","",106,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",55,{"inputs":[{"name":"self"}],"output":{"name":"bodyid"}}],[11,"eq","","",55,{"inputs":[{"name":"self"},{"name":"bodyid"}],"output":{"name":"bool"}}],[11,"ne","","",55,{"inputs":[{"name":"self"},{"name":"bodyid"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",55,null],[11,"partial_cmp","","",55,{"inputs":[{"name":"self"},{"name":"bodyid"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",55,{"inputs":[{"name":"self"},{"name":"bodyid"}],"output":{"name":"bool"}}],[11,"le","","",55,{"inputs":[{"name":"self"},{"name":"bodyid"}],"output":{"name":"bool"}}],[11,"gt","","",55,{"inputs":[{"name":"self"},{"name":"bodyid"}],"output":{"name":"bool"}}],[11,"ge","","",55,{"inputs":[{"name":"self"},{"name":"bodyid"}],"output":{"name":"bool"}}],[11,"cmp","","",55,{"inputs":[{"name":"self"},{"name":"bodyid"}],"output":{"name":"ordering"}}],[11,"encode","","",55,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",55,{"inputs":[{"name":"__d"}],"output":{"generics":["bodyid"],"name":"result"}}],[11,"hash","","",55,null],[11,"fmt","","",55,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",56,{"inputs":[{"name":"self"}],"output":{"name":"body"}}],[11,"eq","","",56,{"inputs":[{"name":"self"},{"name":"body"}],"output":{"name":"bool"}}],[11,"ne","","",56,{"inputs":[{"name":"self"},{"name":"body"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",56,null],[11,"encode","","",56,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",56,{"inputs":[{"name":"__d"}],"output":{"generics":["body"],"name":"result"}}],[11,"hash","","",56,null],[11,"fmt","","",56,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"id","","",56,{"inputs":[{"name":"self"}],"output":{"name":"bodyid"}}],[11,"clone","","",107,{"inputs":[{"name":"self"}],"output":{"name":"bodyownerkind"}}],[11,"fmt","","",107,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",57,{"inputs":[{"name":"self"}],"output":{"name":"expr"}}],[11,"eq","","",57,{"inputs":[{"name":"self"},{"name":"expr"}],"output":{"name":"bool"}}],[11,"ne","","",57,{"inputs":[{"name":"self"},{"name":"expr"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",57,null],[11,"encode","","",57,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",57,{"inputs":[{"name":"__d"}],"output":{"generics":["expr"],"name":"result"}}],[11,"hash","","",57,null],[11,"precedence","","",57,{"inputs":[{"name":"self"}],"output":{"name":"exprprecedence"}}],[11,"fmt","","",57,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",108,{"inputs":[{"name":"self"}],"output":{"name":"expr_"}}],[11,"eq","","",108,{"inputs":[{"name":"self"},{"name":"expr_"}],"output":{"name":"bool"}}],[11,"ne","","",108,{"inputs":[{"name":"self"},{"name":"expr_"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",108,null],[11,"encode","","",108,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",108,{"inputs":[{"name":"__d"}],"output":{"generics":["expr_"],"name":"result"}}],[11,"hash","","",108,null],[11,"fmt","","",108,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",109,{"inputs":[{"name":"self"}],"output":{"name":"qpath"}}],[11,"eq","","",109,{"inputs":[{"name":"self"},{"name":"qpath"}],"output":{"name":"bool"}}],[11,"ne","","",109,{"inputs":[{"name":"self"},{"name":"qpath"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",109,null],[11,"encode","","",109,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",109,{"inputs":[{"name":"__d"}],"output":{"generics":["qpath"],"name":"result"}}],[11,"hash","","",109,null],[11,"fmt","","",109,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",110,{"inputs":[{"name":"self"}],"output":{"name":"localsource"}}],[11,"eq","","",110,{"inputs":[{"name":"self"},{"name":"localsource"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",110,null],[11,"encode","","",110,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",110,{"inputs":[{"name":"__d"}],"output":{"generics":["localsource"],"name":"result"}}],[11,"hash","","",110,null],[11,"fmt","","",110,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",111,{"inputs":[{"name":"self"}],"output":{"name":"matchsource"}}],[11,"eq","","",111,{"inputs":[{"name":"self"},{"name":"matchsource"}],"output":{"name":"bool"}}],[11,"ne","","",111,{"inputs":[{"name":"self"},{"name":"matchsource"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",111,null],[11,"encode","","",111,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",111,{"inputs":[{"name":"__d"}],"output":{"generics":["matchsource"],"name":"result"}}],[11,"hash","","",111,null],[11,"fmt","","",111,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",112,{"inputs":[{"name":"self"}],"output":{"name":"loopsource"}}],[11,"eq","","",112,{"inputs":[{"name":"self"},{"name":"loopsource"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",112,null],[11,"encode","","",112,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",112,{"inputs":[{"name":"__d"}],"output":{"generics":["loopsource"],"name":"result"}}],[11,"hash","","",112,null],[11,"fmt","","",112,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",113,{"inputs":[{"name":"self"}],"output":{"name":"loopiderror"}}],[11,"eq","","",113,{"inputs":[{"name":"self"},{"name":"loopiderror"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",113,null],[11,"encode","","",113,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",113,{"inputs":[{"name":"__d"}],"output":{"generics":["loopiderror"],"name":"result"}}],[11,"hash","","",113,null],[11,"fmt","","",113,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",113,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",114,{"inputs":[{"name":"self"}],"output":{"name":"loopidresult"}}],[11,"eq","","",114,{"inputs":[{"name":"self"},{"name":"loopidresult"}],"output":{"name":"bool"}}],[11,"ne","","",114,{"inputs":[{"name":"self"},{"name":"loopidresult"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",114,null],[11,"encode","","",114,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",114,{"inputs":[{"name":"__d"}],"output":{"generics":["loopidresult"],"name":"result"}}],[11,"hash","","",114,null],[11,"fmt","","",114,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"into","","",114,{"inputs":[{"name":"self"}],"output":{"generics":["nodeid","loopiderror"],"name":"result"}}],[11,"from","","",114,{"inputs":[{"generics":["nodeid","loopiderror"],"name":"result"}],"output":{"name":"self"}}],[11,"clone","","",115,{"inputs":[{"name":"self"}],"output":{"name":"scopetarget"}}],[11,"eq","","",115,{"inputs":[{"name":"self"},{"name":"scopetarget"}],"output":{"name":"bool"}}],[11,"ne","","",115,{"inputs":[{"name":"self"},{"name":"scopetarget"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",115,null],[11,"encode","","",115,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",115,{"inputs":[{"name":"__d"}],"output":{"generics":["scopetarget"],"name":"result"}}],[11,"hash","","",115,null],[11,"fmt","","",115,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"opt_id","","",115,{"inputs":[{"name":"self"}],"output":{"generics":["nodeid"],"name":"option"}}],[11,"clone","","",58,{"inputs":[{"name":"self"}],"output":{"name":"destination"}}],[11,"eq","","",58,{"inputs":[{"name":"self"},{"name":"destination"}],"output":{"name":"bool"}}],[11,"ne","","",58,{"inputs":[{"name":"self"},{"name":"destination"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",58,null],[11,"encode","","",58,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",58,{"inputs":[{"name":"__d"}],"output":{"generics":["destination"],"name":"result"}}],[11,"hash","","",58,null],[11,"fmt","","",58,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",116,{"inputs":[{"name":"self"}],"output":{"name":"generatormovability"}}],[11,"eq","","",116,{"inputs":[{"name":"self"},{"name":"generatormovability"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",116,null],[11,"encode","","",116,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",116,{"inputs":[{"name":"__d"}],"output":{"generics":["generatormovability"],"name":"result"}}],[11,"hash","","",116,null],[11,"fmt","","",116,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",117,{"inputs":[{"name":"self"}],"output":{"name":"captureclause"}}],[11,"eq","","",117,{"inputs":[{"name":"self"},{"name":"captureclause"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",117,null],[11,"encode","","",117,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",117,{"inputs":[{"name":"__d"}],"output":{"generics":["captureclause"],"name":"result"}}],[11,"hash","","",117,null],[11,"fmt","","",117,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",59,{"inputs":[{"name":"self"}],"output":{"name":"mutty"}}],[11,"eq","","",59,{"inputs":[{"name":"self"},{"name":"mutty"}],"output":{"name":"bool"}}],[11,"ne","","",59,{"inputs":[{"name":"self"},{"name":"mutty"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",59,null],[11,"encode","","",59,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",59,{"inputs":[{"name":"__d"}],"output":{"generics":["mutty"],"name":"result"}}],[11,"hash","","",59,null],[11,"fmt","","",59,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",60,{"inputs":[{"name":"self"}],"output":{"name":"methodsig"}}],[11,"eq","","",60,{"inputs":[{"name":"self"},{"name":"methodsig"}],"output":{"name":"bool"}}],[11,"ne","","",60,{"inputs":[{"name":"self"},{"name":"methodsig"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",60,null],[11,"encode","","",60,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",60,{"inputs":[{"name":"__d"}],"output":{"generics":["methodsig"],"name":"result"}}],[11,"hash","","",60,null],[11,"fmt","","",60,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",61,{"inputs":[{"name":"self"}],"output":{"name":"traititemid"}}],[11,"eq","","",61,{"inputs":[{"name":"self"},{"name":"traititemid"}],"output":{"name":"bool"}}],[11,"ne","","",61,{"inputs":[{"name":"self"},{"name":"traititemid"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",61,null],[11,"partial_cmp","","",61,{"inputs":[{"name":"self"},{"name":"traititemid"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",61,{"inputs":[{"name":"self"},{"name":"traititemid"}],"output":{"name":"bool"}}],[11,"le","","",61,{"inputs":[{"name":"self"},{"name":"traititemid"}],"output":{"name":"bool"}}],[11,"gt","","",61,{"inputs":[{"name":"self"},{"name":"traititemid"}],"output":{"name":"bool"}}],[11,"ge","","",61,{"inputs":[{"name":"self"},{"name":"traititemid"}],"output":{"name":"bool"}}],[11,"cmp","","",61,{"inputs":[{"name":"self"},{"name":"traititemid"}],"output":{"name":"ordering"}}],[11,"encode","","",61,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",61,{"inputs":[{"name":"__d"}],"output":{"generics":["traititemid"],"name":"result"}}],[11,"hash","","",61,null],[11,"fmt","","",61,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",62,{"inputs":[{"name":"self"}],"output":{"name":"traititem"}}],[11,"eq","","",62,{"inputs":[{"name":"self"},{"name":"traititem"}],"output":{"name":"bool"}}],[11,"ne","","",62,{"inputs":[{"name":"self"},{"name":"traititem"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",62,null],[11,"encode","","",62,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",62,{"inputs":[{"name":"__d"}],"output":{"generics":["traititem"],"name":"result"}}],[11,"hash","","",62,null],[11,"fmt","","",62,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",118,{"inputs":[{"name":"self"}],"output":{"name":"traitmethod"}}],[11,"eq","","",118,{"inputs":[{"name":"self"},{"name":"traitmethod"}],"output":{"name":"bool"}}],[11,"ne","","",118,{"inputs":[{"name":"self"},{"name":"traitmethod"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",118,null],[11,"encode","","",118,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",118,{"inputs":[{"name":"__d"}],"output":{"generics":["traitmethod"],"name":"result"}}],[11,"hash","","",118,null],[11,"fmt","","",118,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",119,{"inputs":[{"name":"self"}],"output":{"name":"traititemkind"}}],[11,"eq","","",119,{"inputs":[{"name":"self"},{"name":"traititemkind"}],"output":{"name":"bool"}}],[11,"ne","","",119,{"inputs":[{"name":"self"},{"name":"traititemkind"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",119,null],[11,"encode","","",119,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",119,{"inputs":[{"name":"__d"}],"output":{"generics":["traititemkind"],"name":"result"}}],[11,"hash","","",119,null],[11,"fmt","","",119,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",63,{"inputs":[{"name":"self"}],"output":{"name":"implitemid"}}],[11,"eq","","",63,{"inputs":[{"name":"self"},{"name":"implitemid"}],"output":{"name":"bool"}}],[11,"ne","","",63,{"inputs":[{"name":"self"},{"name":"implitemid"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",63,null],[11,"partial_cmp","","",63,{"inputs":[{"name":"self"},{"name":"implitemid"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",63,{"inputs":[{"name":"self"},{"name":"implitemid"}],"output":{"name":"bool"}}],[11,"le","","",63,{"inputs":[{"name":"self"},{"name":"implitemid"}],"output":{"name":"bool"}}],[11,"gt","","",63,{"inputs":[{"name":"self"},{"name":"implitemid"}],"output":{"name":"bool"}}],[11,"ge","","",63,{"inputs":[{"name":"self"},{"name":"implitemid"}],"output":{"name":"bool"}}],[11,"cmp","","",63,{"inputs":[{"name":"self"},{"name":"implitemid"}],"output":{"name":"ordering"}}],[11,"encode","","",63,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",63,{"inputs":[{"name":"__d"}],"output":{"generics":["implitemid"],"name":"result"}}],[11,"hash","","",63,null],[11,"fmt","","",63,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",64,{"inputs":[{"name":"self"}],"output":{"name":"implitem"}}],[11,"eq","","",64,{"inputs":[{"name":"self"},{"name":"implitem"}],"output":{"name":"bool"}}],[11,"ne","","",64,{"inputs":[{"name":"self"},{"name":"implitem"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",64,null],[11,"encode","","",64,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",64,{"inputs":[{"name":"__d"}],"output":{"generics":["implitem"],"name":"result"}}],[11,"hash","","",64,null],[11,"fmt","","",64,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",120,{"inputs":[{"name":"self"}],"output":{"name":"implitemkind"}}],[11,"eq","","",120,{"inputs":[{"name":"self"},{"name":"implitemkind"}],"output":{"name":"bool"}}],[11,"ne","","",120,{"inputs":[{"name":"self"},{"name":"implitemkind"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",120,null],[11,"encode","","",120,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",120,{"inputs":[{"name":"__d"}],"output":{"generics":["implitemkind"],"name":"result"}}],[11,"hash","","",120,null],[11,"fmt","","",120,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",65,{"inputs":[{"name":"self"}],"output":{"name":"typebinding"}}],[11,"eq","","",65,{"inputs":[{"name":"self"},{"name":"typebinding"}],"output":{"name":"bool"}}],[11,"ne","","",65,{"inputs":[{"name":"self"},{"name":"typebinding"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",65,null],[11,"encode","","",65,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",65,{"inputs":[{"name":"__d"}],"output":{"generics":["typebinding"],"name":"result"}}],[11,"hash","","",65,null],[11,"fmt","","",65,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",66,{"inputs":[{"name":"self"}],"output":{"name":"ty"}}],[11,"eq","","",66,{"inputs":[{"name":"self"},{"name":"ty"}],"output":{"name":"bool"}}],[11,"ne","","",66,{"inputs":[{"name":"self"},{"name":"ty"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",66,null],[11,"encode","","",66,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",66,{"inputs":[{"name":"__d"}],"output":{"generics":["ty"],"name":"result"}}],[11,"hash","","",66,null],[11,"fmt","","",66,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",121,{"inputs":[{"name":"self"}],"output":{"name":"primty"}}],[11,"eq","","",121,{"inputs":[{"name":"self"},{"name":"primty"}],"output":{"name":"bool"}}],[11,"ne","","",121,{"inputs":[{"name":"self"},{"name":"primty"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",121,null],[11,"encode","","",121,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",121,{"inputs":[{"name":"__d"}],"output":{"generics":["primty"],"name":"result"}}],[11,"hash","","",121,null],[11,"fmt","","",121,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",67,{"inputs":[{"name":"self"}],"output":{"name":"barefnty"}}],[11,"eq","","",67,{"inputs":[{"name":"self"},{"name":"barefnty"}],"output":{"name":"bool"}}],[11,"ne","","",67,{"inputs":[{"name":"self"},{"name":"barefnty"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",67,null],[11,"encode","","",67,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",67,{"inputs":[{"name":"__d"}],"output":{"generics":["barefnty"],"name":"result"}}],[11,"hash","","",67,null],[11,"fmt","","",67,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",68,{"inputs":[{"name":"self"}],"output":{"name":"existty"}}],[11,"eq","","",68,{"inputs":[{"name":"self"},{"name":"existty"}],"output":{"name":"bool"}}],[11,"ne","","",68,{"inputs":[{"name":"self"},{"name":"existty"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",68,null],[11,"encode","","",68,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",68,{"inputs":[{"name":"__d"}],"output":{"generics":["existty"],"name":"result"}}],[11,"hash","","",68,null],[11,"fmt","","",68,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",122,{"inputs":[{"name":"self"}],"output":{"name":"ty_"}}],[11,"eq","","",122,{"inputs":[{"name":"self"},{"name":"ty_"}],"output":{"name":"bool"}}],[11,"ne","","",122,{"inputs":[{"name":"self"},{"name":"ty_"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",122,null],[11,"encode","","",122,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",122,{"inputs":[{"name":"__d"}],"output":{"generics":["ty_"],"name":"result"}}],[11,"hash","","",122,null],[11,"fmt","","",122,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",69,{"inputs":[{"name":"self"}],"output":{"name":"inlineasmoutput"}}],[11,"eq","","",69,{"inputs":[{"name":"self"},{"name":"inlineasmoutput"}],"output":{"name":"bool"}}],[11,"ne","","",69,{"inputs":[{"name":"self"},{"name":"inlineasmoutput"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",69,null],[11,"encode","","",69,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",69,{"inputs":[{"name":"__d"}],"output":{"generics":["inlineasmoutput"],"name":"result"}}],[11,"hash","","",69,null],[11,"fmt","","",69,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",70,{"inputs":[{"name":"self"}],"output":{"name":"inlineasm"}}],[11,"eq","","",70,{"inputs":[{"name":"self"},{"name":"inlineasm"}],"output":{"name":"bool"}}],[11,"ne","","",70,{"inputs":[{"name":"self"},{"name":"inlineasm"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",70,null],[11,"encode","","",70,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",70,{"inputs":[{"name":"__d"}],"output":{"generics":["inlineasm"],"name":"result"}}],[11,"hash","","",70,null],[11,"fmt","","",70,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",71,{"inputs":[{"name":"self"}],"output":{"name":"arg"}}],[11,"eq","","",71,{"inputs":[{"name":"self"},{"name":"arg"}],"output":{"name":"bool"}}],[11,"ne","","",71,{"inputs":[{"name":"self"},{"name":"arg"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",71,null],[11,"encode","","",71,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",71,{"inputs":[{"name":"__d"}],"output":{"generics":["arg"],"name":"result"}}],[11,"hash","","",71,null],[11,"fmt","","",71,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",72,{"inputs":[{"name":"self"}],"output":{"name":"fndecl"}}],[11,"eq","","",72,{"inputs":[{"name":"self"},{"name":"fndecl"}],"output":{"name":"bool"}}],[11,"ne","","",72,{"inputs":[{"name":"self"},{"name":"fndecl"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",72,null],[11,"encode","","",72,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",72,{"inputs":[{"name":"__d"}],"output":{"generics":["fndecl"],"name":"result"}}],[11,"hash","","",72,null],[11,"fmt","","",72,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",123,{"inputs":[{"name":"self"}],"output":{"name":"isauto"}}],[11,"eq","","",123,{"inputs":[{"name":"self"},{"name":"isauto"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",123,null],[11,"encode","","",123,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",123,{"inputs":[{"name":"__d"}],"output":{"generics":["isauto"],"name":"result"}}],[11,"hash","","",123,null],[11,"fmt","","",123,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",124,{"inputs":[{"name":"self"}],"output":{"name":"unsafety"}}],[11,"eq","","",124,{"inputs":[{"name":"self"},{"name":"unsafety"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",124,null],[11,"encode","","",124,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",124,{"inputs":[{"name":"__d"}],"output":{"generics":["unsafety"],"name":"result"}}],[11,"hash","","",124,null],[11,"fmt","","",124,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",125,{"inputs":[{"name":"self"}],"output":{"name":"constness"}}],[11,"eq","","",125,{"inputs":[{"name":"self"},{"name":"constness"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",125,null],[11,"encode","","",125,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",125,{"inputs":[{"name":"__d"}],"output":{"generics":["constness"],"name":"result"}}],[11,"hash","","",125,null],[11,"fmt","","",125,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",126,{"inputs":[{"name":"self"}],"output":{"name":"defaultness"}}],[11,"eq","","",126,{"inputs":[{"name":"self"},{"name":"defaultness"}],"output":{"name":"bool"}}],[11,"ne","","",126,{"inputs":[{"name":"self"},{"name":"defaultness"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",126,null],[11,"encode","","",126,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",126,{"inputs":[{"name":"__d"}],"output":{"generics":["defaultness"],"name":"result"}}],[11,"hash","","",126,null],[11,"fmt","","",126,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"has_value","","",126,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_final","","",126,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_default","","",126,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"fmt","","",124,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",127,{"inputs":[{"name":"self"}],"output":{"name":"implpolarity"}}],[11,"eq","","",127,{"inputs":[{"name":"self"},{"name":"implpolarity"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",127,null],[11,"encode","","",127,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",127,{"inputs":[{"name":"__d"}],"output":{"generics":["implpolarity"],"name":"result"}}],[11,"hash","","",127,null],[11,"fmt","","",127,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",128,{"inputs":[{"name":"self"}],"output":{"name":"functionretty"}}],[11,"eq","","",128,{"inputs":[{"name":"self"},{"name":"functionretty"}],"output":{"name":"bool"}}],[11,"ne","","",128,{"inputs":[{"name":"self"},{"name":"functionretty"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",128,null],[11,"encode","","",128,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",128,{"inputs":[{"name":"__d"}],"output":{"generics":["functionretty"],"name":"result"}}],[11,"hash","","",128,null],[11,"fmt","","",128,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"span","","",128,{"inputs":[{"name":"self"}],"output":{"name":"span"}}],[11,"clone","","",73,{"inputs":[{"name":"self"}],"output":{"name":"mod"}}],[11,"eq","","",73,{"inputs":[{"name":"self"},{"name":"mod"}],"output":{"name":"bool"}}],[11,"ne","","",73,{"inputs":[{"name":"self"},{"name":"mod"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",73,null],[11,"encode","","",73,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",73,{"inputs":[{"name":"__d"}],"output":{"generics":["mod"],"name":"result"}}],[11,"hash","","",73,null],[11,"fmt","","",73,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",74,{"inputs":[{"name":"self"}],"output":{"name":"foreignmod"}}],[11,"eq","","",74,{"inputs":[{"name":"self"},{"name":"foreignmod"}],"output":{"name":"bool"}}],[11,"ne","","",74,{"inputs":[{"name":"self"},{"name":"foreignmod"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",74,null],[11,"encode","","",74,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",74,{"inputs":[{"name":"__d"}],"output":{"generics":["foreignmod"],"name":"result"}}],[11,"hash","","",74,null],[11,"fmt","","",74,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",75,{"inputs":[{"name":"self"}],"output":{"name":"globalasm"}}],[11,"eq","","",75,{"inputs":[{"name":"self"},{"name":"globalasm"}],"output":{"name":"bool"}}],[11,"ne","","",75,{"inputs":[{"name":"self"},{"name":"globalasm"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",75,null],[11,"encode","","",75,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",75,{"inputs":[{"name":"__d"}],"output":{"generics":["globalasm"],"name":"result"}}],[11,"hash","","",75,null],[11,"fmt","","",75,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",76,{"inputs":[{"name":"self"}],"output":{"name":"enumdef"}}],[11,"eq","","",76,{"inputs":[{"name":"self"},{"name":"enumdef"}],"output":{"name":"bool"}}],[11,"ne","","",76,{"inputs":[{"name":"self"},{"name":"enumdef"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",76,null],[11,"encode","","",76,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",76,{"inputs":[{"name":"__d"}],"output":{"generics":["enumdef"],"name":"result"}}],[11,"hash","","",76,null],[11,"fmt","","",76,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",77,{"inputs":[{"name":"self"}],"output":{"name":"variant_"}}],[11,"eq","","",77,{"inputs":[{"name":"self"},{"name":"variant_"}],"output":{"name":"bool"}}],[11,"ne","","",77,{"inputs":[{"name":"self"},{"name":"variant_"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",77,null],[11,"encode","","",77,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",77,{"inputs":[{"name":"__d"}],"output":{"generics":["variant_"],"name":"result"}}],[11,"hash","","",77,null],[11,"fmt","","",77,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",129,{"inputs":[{"name":"self"}],"output":{"name":"usekind"}}],[11,"eq","","",129,{"inputs":[{"name":"self"},{"name":"usekind"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",129,null],[11,"encode","","",129,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",129,{"inputs":[{"name":"__d"}],"output":{"generics":["usekind"],"name":"result"}}],[11,"hash","","",129,null],[11,"fmt","","",129,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",78,{"inputs":[{"name":"self"}],"output":{"name":"traitref"}}],[11,"eq","","",78,{"inputs":[{"name":"self"},{"name":"traitref"}],"output":{"name":"bool"}}],[11,"ne","","",78,{"inputs":[{"name":"self"},{"name":"traitref"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",78,null],[11,"encode","","",78,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",78,{"inputs":[{"name":"__d"}],"output":{"generics":["traitref"],"name":"result"}}],[11,"hash","","",78,null],[11,"fmt","","",78,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",79,{"inputs":[{"name":"self"}],"output":{"name":"polytraitref"}}],[11,"eq","","",79,{"inputs":[{"name":"self"},{"name":"polytraitref"}],"output":{"name":"bool"}}],[11,"ne","","",79,{"inputs":[{"name":"self"},{"name":"polytraitref"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",79,null],[11,"encode","","",79,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",79,{"inputs":[{"name":"__d"}],"output":{"generics":["polytraitref"],"name":"result"}}],[11,"hash","","",79,null],[11,"fmt","","",79,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",130,{"inputs":[{"name":"self"}],"output":{"name":"visibility"}}],[11,"eq","","",130,{"inputs":[{"name":"self"},{"name":"visibility"}],"output":{"name":"bool"}}],[11,"ne","","",130,{"inputs":[{"name":"self"},{"name":"visibility"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",130,null],[11,"encode","","",130,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",130,{"inputs":[{"name":"__d"}],"output":{"generics":["visibility"],"name":"result"}}],[11,"hash","","",130,null],[11,"fmt","","",130,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"is_pub_restricted","","",130,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",80,{"inputs":[{"name":"self"}],"output":{"name":"structfield"}}],[11,"eq","","",80,{"inputs":[{"name":"self"},{"name":"structfield"}],"output":{"name":"bool"}}],[11,"ne","","",80,{"inputs":[{"name":"self"},{"name":"structfield"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",80,null],[11,"encode","","",80,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",80,{"inputs":[{"name":"__d"}],"output":{"generics":["structfield"],"name":"result"}}],[11,"hash","","",80,null],[11,"fmt","","",80,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"is_positional","","",80,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",131,{"inputs":[{"name":"self"}],"output":{"name":"variantdata"}}],[11,"eq","","",131,{"inputs":[{"name":"self"},{"name":"variantdata"}],"output":{"name":"bool"}}],[11,"ne","","",131,{"inputs":[{"name":"self"},{"name":"variantdata"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",131,null],[11,"encode","","",131,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",131,{"inputs":[{"name":"__d"}],"output":{"generics":["variantdata"],"name":"result"}}],[11,"hash","","",131,null],[11,"fmt","","",131,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fields","","",131,null],[11,"id","","",131,{"inputs":[{"name":"self"}],"output":{"name":"nodeid"}}],[11,"is_struct","","",131,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_tuple","","",131,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_unit","","",131,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",81,{"inputs":[{"name":"self"}],"output":{"name":"itemid"}}],[11,"eq","","",81,{"inputs":[{"name":"self"},{"name":"itemid"}],"output":{"name":"bool"}}],[11,"ne","","",81,{"inputs":[{"name":"self"},{"name":"itemid"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",81,null],[11,"encode","","",81,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",81,{"inputs":[{"name":"__d"}],"output":{"generics":["itemid"],"name":"result"}}],[11,"hash","","",81,null],[11,"fmt","","",81,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",82,{"inputs":[{"name":"self"}],"output":{"name":"item"}}],[11,"eq","","",82,{"inputs":[{"name":"self"},{"name":"item"}],"output":{"name":"bool"}}],[11,"ne","","",82,{"inputs":[{"name":"self"},{"name":"item"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",82,null],[11,"encode","","",82,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",82,{"inputs":[{"name":"__d"}],"output":{"generics":["item"],"name":"result"}}],[11,"hash","","",82,null],[11,"fmt","","",82,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",132,{"inputs":[{"name":"self"}],"output":{"name":"item_"}}],[11,"eq","","",132,{"inputs":[{"name":"self"},{"name":"item_"}],"output":{"name":"bool"}}],[11,"ne","","",132,{"inputs":[{"name":"self"},{"name":"item_"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",132,null],[11,"encode","","",132,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",132,{"inputs":[{"name":"__d"}],"output":{"generics":["item_"],"name":"result"}}],[11,"hash","","",132,null],[11,"fmt","","",132,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"descriptive_variant","","",132,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"adt_kind","","",132,{"inputs":[{"name":"self"}],"output":{"generics":["adtkind"],"name":"option"}}],[11,"generics","","",132,{"inputs":[{"name":"self"}],"output":{"generics":["generics"],"name":"option"}}],[11,"clone","","",83,{"inputs":[{"name":"self"}],"output":{"name":"traititemref"}}],[11,"eq","","",83,{"inputs":[{"name":"self"},{"name":"traititemref"}],"output":{"name":"bool"}}],[11,"ne","","",83,{"inputs":[{"name":"self"},{"name":"traititemref"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",83,null],[11,"encode","","",83,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",83,{"inputs":[{"name":"__d"}],"output":{"generics":["traititemref"],"name":"result"}}],[11,"hash","","",83,null],[11,"fmt","","",83,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",84,{"inputs":[{"name":"self"}],"output":{"name":"implitemref"}}],[11,"eq","","",84,{"inputs":[{"name":"self"},{"name":"implitemref"}],"output":{"name":"bool"}}],[11,"ne","","",84,{"inputs":[{"name":"self"},{"name":"implitemref"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",84,null],[11,"encode","","",84,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",84,{"inputs":[{"name":"__d"}],"output":{"generics":["implitemref"],"name":"result"}}],[11,"hash","","",84,null],[11,"fmt","","",84,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",133,{"inputs":[{"name":"self"}],"output":{"name":"associateditemkind"}}],[11,"eq","","",133,{"inputs":[{"name":"self"},{"name":"associateditemkind"}],"output":{"name":"bool"}}],[11,"ne","","",133,{"inputs":[{"name":"self"},{"name":"associateditemkind"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",133,null],[11,"encode","","",133,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",133,{"inputs":[{"name":"__d"}],"output":{"generics":["associateditemkind"],"name":"result"}}],[11,"hash","","",133,null],[11,"fmt","","",133,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",85,{"inputs":[{"name":"self"}],"output":{"name":"foreignitem"}}],[11,"eq","","",85,{"inputs":[{"name":"self"},{"name":"foreignitem"}],"output":{"name":"bool"}}],[11,"ne","","",85,{"inputs":[{"name":"self"},{"name":"foreignitem"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",85,null],[11,"encode","","",85,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",85,{"inputs":[{"name":"__d"}],"output":{"generics":["foreignitem"],"name":"result"}}],[11,"hash","","",85,null],[11,"fmt","","",85,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",134,{"inputs":[{"name":"self"}],"output":{"name":"foreignitem_"}}],[11,"eq","","",134,{"inputs":[{"name":"self"},{"name":"foreignitem_"}],"output":{"name":"bool"}}],[11,"ne","","",134,{"inputs":[{"name":"self"},{"name":"foreignitem_"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",134,null],[11,"encode","","",134,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",134,{"inputs":[{"name":"__d"}],"output":{"generics":["foreignitem_"],"name":"result"}}],[11,"hash","","",134,null],[11,"fmt","","",134,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"descriptive_variant","","",134,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"fmt","","",86,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",86,{"inputs":[{"name":"self"}],"output":{"name":"freevar"}}],[11,"encode","","",86,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",86,{"inputs":[{"name":"__d"}],"output":{"generics":["freevar"],"name":"result"}}],[11,"var_id","","",86,{"inputs":[{"name":"self"}],"output":{"name":"nodeid"}}],[11,"clone","","",87,{"inputs":[{"name":"self"}],"output":{"name":"traitcandidate"}}],[11,"fmt","","",87,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",88,{"inputs":[{"name":"self"}],"output":{"name":"transfnattrs"}}],[11,"encode","","",88,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",88,{"inputs":[{"name":"__d"}],"output":{"generics":["transfnattrs"],"name":"result"}}],[11,"hash","","",88,null],[11,"eq","","",89,{"inputs":[{"name":"self"},{"name":"transfnattrflags"}],"output":{"name":"bool"}}],[11,"ne","","",89,{"inputs":[{"name":"self"},{"name":"transfnattrflags"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",89,null],[11,"clone","","",89,{"inputs":[{"name":"self"}],"output":{"name":"transfnattrflags"}}],[11,"partial_cmp","","",89,{"inputs":[{"name":"self"},{"name":"transfnattrflags"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",89,{"inputs":[{"name":"self"},{"name":"transfnattrflags"}],"output":{"name":"bool"}}],[11,"le","","",89,{"inputs":[{"name":"self"},{"name":"transfnattrflags"}],"output":{"name":"bool"}}],[11,"gt","","",89,{"inputs":[{"name":"self"},{"name":"transfnattrflags"}],"output":{"name":"bool"}}],[11,"ge","","",89,{"inputs":[{"name":"self"},{"name":"transfnattrflags"}],"output":{"name":"bool"}}],[11,"cmp","","",89,{"inputs":[{"name":"self"},{"name":"transfnattrflags"}],"output":{"name":"ordering"}}],[11,"hash","","",89,null],[11,"encode","","",89,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",89,{"inputs":[{"name":"__d"}],"output":{"generics":["transfnattrflags"],"name":"result"}}],[11,"fmt","","",89,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",89,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",89,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",89,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",89,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[18,"COLD","","",89,null],[18,"ALLOCATOR","","",89,null],[18,"UNWIND","","",89,null],[18,"RUSTC_ALLOCATOR_NOUNWIND","","",89,null],[18,"NAKED","","",89,null],[18,"NO_MANGLE","","",89,null],[18,"RUSTC_STD_INTERNAL_SYMBOL","","",89,null],[18,"NO_DEBUG","","",89,null],[11,"empty","","Returns an empty set of flags.",89,{"inputs":[],"output":{"name":"transfnattrflags"}}],[11,"all","","Returns the set containing all flags.",89,{"inputs":[],"output":{"name":"transfnattrflags"}}],[11,"bits","","Returns the raw value of the flags currently stored.",89,{"inputs":[{"name":"self"}],"output":{"name":"u8"}}],[11,"from_bits","","Convert from underlying bit representation, unless that representation contains bits that do not correspond to a flag.",89,{"inputs":[{"name":"u8"}],"output":{"generics":["transfnattrflags"],"name":"option"}}],[11,"from_bits_truncate","","Convert from underlying bit representation, dropping any bits that do not correspond to flags.",89,{"inputs":[{"name":"u8"}],"output":{"name":"transfnattrflags"}}],[11,"is_empty","","Returns `true` if no flags are currently stored.",89,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_all","","Returns `true` if all flags are currently set.",89,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"intersects","","Returns `true` if there are flags common to both `self` and `other`.",89,{"inputs":[{"name":"self"},{"name":"transfnattrflags"}],"output":{"name":"bool"}}],[11,"contains","","Returns `true` all of the flags in `other` are contained within `self`.",89,{"inputs":[{"name":"self"},{"name":"transfnattrflags"}],"output":{"name":"bool"}}],[11,"insert","","Inserts the specified flags in-place.",89,{"inputs":[{"name":"self"},{"name":"transfnattrflags"}],"output":null}],[11,"remove","","Removes the specified flags in-place.",89,{"inputs":[{"name":"self"},{"name":"transfnattrflags"}],"output":null}],[11,"toggle","","Toggles the specified flags in-place.",89,{"inputs":[{"name":"self"},{"name":"transfnattrflags"}],"output":null}],[11,"set","","Inserts or removes the specified flags depending on the passed value.",89,{"inputs":[{"name":"self"},{"name":"transfnattrflags"},{"name":"bool"}],"output":null}],[11,"bitor","","Returns the union of the two sets of flags.",89,{"inputs":[{"name":"self"},{"name":"transfnattrflags"}],"output":{"name":"transfnattrflags"}}],[11,"bitor_assign","","Adds the set of flags.",89,{"inputs":[{"name":"self"},{"name":"transfnattrflags"}],"output":null}],[11,"bitxor","","Returns the left flags, but with all the right flags toggled.",89,{"inputs":[{"name":"self"},{"name":"transfnattrflags"}],"output":{"name":"transfnattrflags"}}],[11,"bitxor_assign","","Toggles the set of flags.",89,{"inputs":[{"name":"self"},{"name":"transfnattrflags"}],"output":null}],[11,"bitand","","Returns the intersection between the two sets of flags.",89,{"inputs":[{"name":"self"},{"name":"transfnattrflags"}],"output":{"name":"transfnattrflags"}}],[11,"bitand_assign","","Disables all flags disabled in the set.",89,{"inputs":[{"name":"self"},{"name":"transfnattrflags"}],"output":null}],[11,"sub","","Returns the set difference of the two sets of flags.",89,{"inputs":[{"name":"self"},{"name":"transfnattrflags"}],"output":{"name":"transfnattrflags"}}],[11,"sub_assign","","Disables all flags enabled in the set.",89,{"inputs":[{"name":"self"},{"name":"transfnattrflags"}],"output":null}],[11,"not","","Returns the complement of this set of flags.",89,{"inputs":[{"name":"self"}],"output":{"name":"transfnattrflags"}}],[11,"extend","","",89,{"inputs":[{"name":"self"},{"name":"t"}],"output":null}],[11,"from_iter","","",89,{"inputs":[{"name":"t"}],"output":{"name":"transfnattrflags"}}],[11,"new","","",88,{"inputs":[],"output":{"name":"transfnattrs"}}],[11,"requests_inline","","True if `#[inline]` or `#[inline(always)]` is present.",88,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"contains_extern_indicator","","True if `#[no_mangle]` or `#[export_name(...)]` is present.",88,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[0,"ich","rustc","ICH - Incremental Compilation Hash",null,null],[3,"Fingerprint","rustc::ich","",null,null],[12,"0","","",193,null],[12,"1","","",193,null],[3,"CachingCodemapView","","",null,null],[12,"codemap","","",194,null],[12,"line_cache","","",194,null],[12,"time_stamp","","",194,null],[3,"StableHashingContext","","This is the context state available during incr. comp. hashing. It contains enough information to transform DefIds and HirIds into stable DefPaths (i.e. a reference to the TyCtxt) and it holds a few caches for speeding up various things (e.g. each DefId/DefPath is only hashed once).",null,null],[12,"sess","","",195,null],[12,"definitions","","",195,null],[12,"cstore","","",195,null],[12,"body_resolver","","",195,null],[12,"hash_spans","","",195,null],[12,"hash_bodies","","",195,null],[12,"node_id_hashing_mode","","",195,null],[12,"raw_codemap","","",195,null],[12,"caching_codemap","","",195,null],[12,"alloc_id_recursion_tracker","","",195,null],[4,"NodeIdHashingMode","","",null,null],[13,"Ignore","","",196,null],[13,"HashDefPath","","",196,null],[5,"hash_stable_trait_impls","","",null,{"inputs":[{"name":"stablehashingcontext"},{"name":"stablehasher"},{"name":"vec"},{"name":"hashmap"}],"output":null}],[5,"compute_ignored_attr_names","","",null,{"inputs":[],"output":{"generics":["symbol"],"name":"fxhashset"}}],[0,"fingerprint","","",null,null],[3,"Fingerprint","rustc::ich::fingerprint","",null,null],[12,"0","","",193,null],[12,"1","","",193,null],[11,"assert_receiver_is_total_eq","rustc::ich","",193,null],[11,"eq","","",193,{"inputs":[{"name":"self"},{"name":"fingerprint"}],"output":{"name":"bool"}}],[11,"ne","","",193,{"inputs":[{"name":"self"},{"name":"fingerprint"}],"output":{"name":"bool"}}],[11,"cmp","","",193,{"inputs":[{"name":"self"},{"name":"fingerprint"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",193,{"inputs":[{"name":"self"},{"name":"fingerprint"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",193,{"inputs":[{"name":"self"},{"name":"fingerprint"}],"output":{"name":"bool"}}],[11,"le","","",193,{"inputs":[{"name":"self"},{"name":"fingerprint"}],"output":{"name":"bool"}}],[11,"gt","","",193,{"inputs":[{"name":"self"},{"name":"fingerprint"}],"output":{"name":"bool"}}],[11,"ge","","",193,{"inputs":[{"name":"self"},{"name":"fingerprint"}],"output":{"name":"bool"}}],[11,"hash","","",193,null],[11,"fmt","","",193,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",193,{"inputs":[{"name":"self"}],"output":{"name":"fingerprint"}}],[18,"ZERO","","",193,null],[11,"from_smaller_hash","","",193,{"inputs":[{"name":"u64"}],"output":{"name":"fingerprint"}}],[11,"to_smaller_hash","","",193,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"as_value","","",193,null],[11,"combine","","",193,{"inputs":[{"name":"self"},{"name":"fingerprint"}],"output":{"name":"fingerprint"}}],[11,"to_hex","","",193,{"inputs":[{"name":"self"}],"output":{"name":"string"}}],[11,"encode_opaque","","",193,{"inputs":[{"name":"self"},{"name":"encoder"}],"output":{"name":"encoderesult"}}],[11,"decode_opaque","","",193,{"inputs":[{"name":"decoder"}],"output":{"generics":["fingerprint","string"],"name":"result"}}],[11,"fmt","","",193,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"generics":["error"],"name":"result"}}],[11,"finish","","",193,{"inputs":[{"name":"stablehasher"}],"output":{"name":"self"}}],[11,"hash_stable","","",193,{"inputs":[{"name":"self"},{"name":"ctx"},{"name":"stablehasher"}],"output":null}],[0,"caching_codemap_view","","",null,null],[3,"CacheEntry","rustc::ich::caching_codemap_view","",null,null],[12,"time_stamp","","",197,null],[12,"line_number","","",197,null],[12,"line_start","","",197,null],[12,"line_end","","",197,null],[12,"file","","",197,null],[12,"file_index","","",197,null],[3,"CachingCodemapView","","",null,null],[12,"codemap","","",194,null],[12,"line_cache","","",194,null],[12,"time_stamp","","",194,null],[11,"clone","","",197,{"inputs":[{"name":"self"}],"output":{"name":"cacheentry"}}],[11,"clone","rustc::ich","",194,{"inputs":[{"name":"self"}],"output":{"name":"cachingcodemapview"}}],[11,"new","","",194,{"inputs":[{"name":"codemap"}],"output":{"name":"cachingcodemapview"}}],[11,"byte_pos_to_line_and_col","","",194,{"inputs":[{"name":"self"},{"name":"bytepos"}],"output":{"name":"option"}}],[0,"hcx","","",null,null],[3,"StableHashingContext","rustc::ich::hcx","This is the context state available during incr. comp. hashing. It contains enough information to transform DefIds and HirIds into stable DefPaths (i.e. a reference to the TyCtxt) and it holds a few caches for speeding up various things (e.g. each DefId/DefPath is only hashed once).",null,null],[12,"sess","","",195,null],[12,"definitions","","",195,null],[12,"cstore","","",195,null],[12,"body_resolver","","",195,null],[12,"hash_spans","","",195,null],[12,"hash_bodies","","",195,null],[12,"node_id_hashing_mode","","",195,null],[12,"raw_codemap","","",195,null],[12,"caching_codemap","","",195,null],[12,"alloc_id_recursion_tracker","","",195,null],[3,"BodyResolver","","The BodyResolver allows to map a BodyId to the corresponding hir::Body. We could also just store a plain reference to the hir::Crate but we want to avoid that the crate is used to get untracked access to all of the HIR.",null,null],[12,"0","","",198,null],[4,"NodeIdHashingMode","","",null,null],[13,"Ignore","","",196,null],[13,"HashDefPath","","",196,null],[5,"compute_ignored_attr_names","","",null,{"inputs":[],"output":{"generics":["symbol"],"name":"fxhashset"}}],[5,"hash_stable_trait_impls","","",null,{"inputs":[{"name":"stablehashingcontext"},{"name":"stablehasher"},{"name":"vec"},{"name":"hashmap"}],"output":null}],[8,"StableHashingContextProvider","","Something that can provide a stable hashing context.",null,null],[10,"get_stable_hashing_context","","",199,{"inputs":[{"name":"self"}],"output":{"name":"stablehashingcontext"}}],[11,"clone","rustc::ich","",195,{"inputs":[{"name":"self"}],"output":{"name":"stablehashingcontext"}}],[11,"eq","","",196,{"inputs":[{"name":"self"},{"name":"nodeidhashingmode"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",196,null],[11,"clone","","",196,{"inputs":[{"name":"self"}],"output":{"name":"nodeidhashingmode"}}],[11,"clone","rustc::ich::hcx","",198,{"inputs":[{"name":"self"}],"output":{"name":"bodyresolver"}}],[11,"body","","",198,{"inputs":[{"name":"self"},{"name":"bodyid"}],"output":{"name":"body"}}],[11,"new","rustc::ich","",195,{"inputs":[{"name":"session"},{"name":"crate"},{"name":"definitions"},{"name":"cratestore"}],"output":{"name":"self"}}],[11,"sess","","",195,{"inputs":[{"name":"self"}],"output":{"name":"session"}}],[11,"while_hashing_hir_bodies","","",195,{"inputs":[{"name":"self"},{"name":"bool"},{"name":"f"}],"output":null}],[11,"while_hashing_spans","","",195,{"inputs":[{"name":"self"},{"name":"bool"},{"name":"f"}],"output":null}],[11,"with_node_id_hashing_mode","","",195,{"inputs":[{"name":"self"},{"name":"nodeidhashingmode"},{"name":"f"}],"output":null}],[11,"def_path_hash","","",195,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"defpathhash"}}],[11,"local_def_path_hash","","",195,{"inputs":[{"name":"self"},{"name":"defindex"}],"output":{"name":"defpathhash"}}],[11,"node_to_hir_id","","",195,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"name":"hirid"}}],[11,"hash_bodies","","",195,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"codemap","","",195,{"inputs":[{"name":"self"}],"output":{"name":"cachingcodemapview"}}],[11,"is_ignored_attr","","",195,{"inputs":[{"name":"self"},{"name":"symbol"}],"output":{"name":"bool"}}],[11,"hash_hir_item_like","","",195,{"inputs":[{"name":"self"},{"name":"f"}],"output":null}],[11,"get_stable_hashing_context","","",195,{"inputs":[{"name":"self"}],"output":{"name":"stablehashingcontext"}}],[11,"hash_stable","rustc::hir","",55,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",33,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"to_stable_hash_key","","",33,null],[0,"impls_cstore","rustc::ich","This module contains `HashStable` implementations for various data types from rustc::middle::cstore in no particular order.",null,null],[0,"impls_hir","","This module contains `HashStable` implementations for various HIR data types in no particular order.",null,null],[11,"hash_stable","rustc::hir::def_id","",143,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"to_stable_hash_key","","",143,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"}],"output":{"name":"defpathhash"}}],[11,"hash_stable","","",144,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"to_stable_hash_key","","",144,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"}],"output":{"name":"defpathhash"}}],[11,"hash_stable","","",141,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"to_stable_hash_key","","",141,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"}],"output":{"name":"defpathhash"}}],[11,"hash_stable","rustc::hir","",34,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"to_stable_hash_key","","",34,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"}],"output":{"name":"itemlocalid"}}],[11,"hash_stable","","",81,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",61,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",63,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",90,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",35,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",36,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",37,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",38,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",39,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",40,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",91,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",92,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",41,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",93,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",42,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",95,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",43,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",96,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",44,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",45,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",46,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",59,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",60,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",65,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",66,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",121,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",67,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",68,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",122,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",72,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",128,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",78,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",79,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",109,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",48,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",49,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",50,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",51,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",97,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",98,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",99,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",101,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",102,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",52,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",104,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",53,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",54,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",105,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",106,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",57,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",108,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",110,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",112,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",111,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",116,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",117,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",58,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",114,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",113,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",115,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",62,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",118,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",119,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",64,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",120,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",130,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",126,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",127,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",73,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",74,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",76,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",77,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",129,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",80,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",131,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",82,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",132,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",83,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",84,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",133,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",85,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",134,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",103,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",71,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",56,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"to_stable_hash_key","","",55,null],[11,"hash_stable","","",69,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",75,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",70,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","rustc::hir::def","",139,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",140,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","rustc::hir","",100,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",123,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",124,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",125,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","rustc::hir::def_id","",142,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"to_stable_hash_key","","",142,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"}],"output":{"name":"defpathhash"}}],[11,"hash_stable","rustc::hir::def","",138,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","rustc::hir","",87,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"to_stable_hash_key","","",87,null],[11,"hash_stable","","",88,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",89,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",86,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[0,"impls_mir","rustc::ich","This module contains `HashStable` implementations for various MIR data types in no particular order.",null,null],[0,"impls_misc","","This module contains `HashStable` implementations for various data types that don't fit into any of the other impls_xxx modules.",null,null],[0,"impls_ty","","This module contains `HashStable` implementations for various data types from rustc::ty in no particular order.",null,null],[4,"AllocDiscriminant","rustc::ich::impls_ty","",null,null],[13,"Alloc","","",200,null],[13,"Static","","",200,null],[13,"Function","","",200,null],[11,"hash_stable","","",200,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[0,"impls_syntax","rustc::ich","This module contains `HashStable` implementations for various data types from libsyntax in no particular order.",null,null],[5,"hash_token","rustc::ich::impls_syntax","",null,{"inputs":[{"name":"token"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[5,"stable_byte_pos","","",null,{"inputs":[{"name":"bytepos"},{"name":"bytepos"}],"output":{"name":"u32"}}],[5,"stable_multibyte_char","","",null,null],[5,"stable_non_narrow_char","","",null,null],[17,"ATTR_DIRTY","rustc::ich","",null,null],[17,"ATTR_CLEAN","","",null,null],[17,"ATTR_IF_THIS_CHANGED","","",null,null],[17,"ATTR_THEN_THIS_WOULD_NEED","","",null,null],[17,"ATTR_PARTITION_REUSED","","",null,null],[17,"ATTR_PARTITION_TRANSLATED","","",null,null],[17,"DEP_GRAPH_ASSERT_ATTRS","","",null,null],[17,"IGNORED_ATTRIBUTES","","",null,null],[8,"StableHashingContextProvider","","Something that can provide a stable hashing context.",null,null],[10,"get_stable_hashing_context","","",199,{"inputs":[{"name":"self"}],"output":{"name":"stablehashingcontext"}}],[0,"infer","rustc","See the Book for more information.",null,null],[3,"TypeFreshener","rustc::infer","",null,null],[12,"infcx","","",201,null],[12,"freshen_count","","",201,null],[12,"freshen_map","","",201,null],[3,"InferOk","","",null,null],[12,"value","","",202,null],[12,"obligations","","",202,null],[3,"InferCtxt","","",null,null],[12,"tcx","","",203,null],[12,"in_progress_tables","","During type-checking/inference of a body, `in_progress_tables` contains a reference to the tables being built up, which are used for reading closure kinds/signatures as they are inferred, and for error reporting logic to read arbitrary node types.",203,null],[12,"projection_cache","","",203,null],[12,"type_variables","","",203,null],[12,"int_unification_table","","",203,null],[12,"float_unification_table","","",203,null],[12,"region_constraints","","",203,null],[12,"lexical_region_resolutions","","",203,null],[12,"selection_cache","","Caches the results of trait selection. This cache is used for things that have to do with the parameters in scope.",203,null],[12,"evaluation_cache","","Caches the results of trait evaluation.",203,null],[12,"reported_trait_errors","","",203,null],[12,"tainted_by_errors_flag","","",203,null],[12,"err_count_on_creation","","",203,null],[12,"in_snapshot","","",203,null],[12,"region_obligations","","",203,null],[12,"universe","","What is the innermost universe we have created? Starts out as `UniverseIndex::root()` but grows from there as we enter universal quantifiers.",203,null],[3,"TypeTrace","","The trace designates the path through inference that we took to encounter an error or subtyping constraint.",null,null],[12,"cause","","",204,null],[12,"values","","",204,null],[3,"RegionObligation","","See the `region_obligations` field for more information.",null,null],[12,"sub_region","","",205,null],[12,"sup_type","","",205,null],[12,"cause","","",205,null],[3,"InferCtxtBuilder","","Helper type of a temporary returned by tcx.infer_ctxt(). Necessary because we can't write the following bound: F: for<'b, 'tcx> where 'gcx: 'tcx FnOnce(InferCtxt<'b, 'gcx, 'tcx>).",null,null],[12,"global_tcx","","",206,null],[12,"arena","","",206,null],[12,"fresh_tables","","",206,null],[3,"CombinedSnapshot","","",null,null],[12,"projection_cache_snapshot","","",207,null],[12,"type_snapshot","","",207,null],[12,"int_snapshot","","",207,null],[12,"float_snapshot","","",207,null],[12,"region_constraints_snapshot","","",207,null],[12,"region_obligations_snapshot","","",207,null],[12,"universe","","",207,null],[12,"was_in_snapshot","","",207,null],[12,"_in_progress_tables","","",207,null],[4,"ValuePairs","","See `error_reporting` module for more details",null,null],[13,"Types","","",208,null],[13,"Regions","","",208,null],[13,"TraitRefs","","",208,null],[13,"PolyTraitRefs","","",208,null],[4,"SubregionOrigin","","The origin of a `r1 <= r2` constraint.",null,null],[13,"Subtype","","",209,null],[13,"InfStackClosure","","",209,null],[13,"InvokeClosure","","",209,null],[13,"DerefPointer","","",209,null],[13,"FreeVariable","","",209,null],[13,"IndexSlice","","",209,null],[13,"RelateObjectBound","","",209,null],[13,"RelateParamBound","","",209,null],[13,"RelateRegionParamBound","","",209,null],[13,"RelateDefaultParamBound","","",209,null],[13,"Reborrow","","",209,null],[13,"ReborrowUpvar","","",209,null],[13,"DataBorrowed","","",209,null],[13,"ReferenceOutlivesReferent","","",209,null],[13,"ParameterInScope","","",209,null],[13,"ExprTypeIsNotInScope","","",209,null],[13,"BindingTypeIsNotValidAtDecl","","",209,null],[13,"CallRcvr","","",209,null],[13,"CallArg","","",209,null],[13,"CallReturn","","",209,null],[13,"Operand","","",209,null],[13,"AddrOf","","",209,null],[13,"AutoBorrow","","",209,null],[13,"SafeDestructor","","",209,null],[13,"CompareImplMethodObligation","","",209,null],[12,"span","rustc::infer::SubregionOrigin","",209,null],[12,"item_name","","",209,null],[12,"impl_item_def_id","","",209,null],[12,"trait_item_def_id","","",209,null],[4,"ParameterOrigin","rustc::infer","Places that type/region parameters can appear.",null,null],[13,"Path","","",210,null],[13,"MethodCall","","",210,null],[13,"OverloadedOperator","","",210,null],[13,"OverloadedDeref","","",210,null],[4,"LateBoundRegionConversionTime","","Times when we replace late-bound regions with variables:",null,null],[13,"FnCall","","when a fn is called",211,null],[13,"HigherRankedType","","when two higher-ranked types are compared",211,null],[13,"AssocTypeProjection","","when projecting an associated type",211,null],[4,"RegionVariableOrigin","","Reasons to create a region inference variable",null,null],[13,"MiscVariable","","",212,null],[13,"PatternRegion","","",212,null],[13,"AddrOfRegion","","",212,null],[13,"Autoref","","",212,null],[13,"Coercion","","",212,null],[13,"EarlyBoundRegion","","",212,null],[13,"LateBoundRegion","","",212,null],[13,"UpvarRegion","","",212,null],[13,"BoundRegionInCoherence","","",212,null],[13,"NLL","","",212,null],[4,"NLLRegionVariableOrigin","","",null,null],[13,"FreeRegion","","",213,null],[13,"Inferred","","",213,null],[4,"FixupError","","",null,null],[13,"UnresolvedIntTy","","",214,null],[13,"UnresolvedFloatTy","","",214,null],[13,"UnresolvedTy","","",214,null],[0,"anon_types","","",null,null],[3,"AnonTypeDecl","rustc::infer::anon_types","Information about the anonymous, abstract types whose values we are inferring in this function (these are the `impl Trait` that appear in the return type).",null,null],[12,"substs","","The substitutions that we apply to the abstract that that this `impl Trait` desugars to. e.g., if:",215,null],[12,"concrete_ty","","The type variable that represents the value of the abstract type that we require. In other words, after we compile this function, we will be created a constraint like:",215,null],[12,"has_required_region_bounds","","True if the `impl Trait` bounds include region bounds. For example, this would be true for:",215,null],[3,"ReverseMapper","","",null,null],[12,"tcx","","",216,null],[12,"tainted_by_errors","","If errors have already been reported in this fn, we suppress our own errors because they are sometimes derivative.",216,null],[12,"anon_type_def_id","","",216,null],[12,"map","","",216,null],[12,"map_missing_regions_to_empty","","",216,null],[12,"hidden_ty","","initially `Some`, set to `None` once error has been reported",216,null],[3,"Instantiator","","",null,null],[12,"infcx","","",217,null],[12,"parent_def_id","","",217,null],[12,"body_id","","",217,null],[12,"param_env","","",217,null],[12,"anon_types","","",217,null],[12,"obligations","","",217,null],[6,"AnonTypeMap","","",null,null],[11,"clone","","",215,{"inputs":[{"name":"self"}],"output":{"name":"anontypedecl"}}],[11,"fmt","","",215,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"instantiate_anon_types","rustc::infer","Replace all anonymized types in `value` with fresh inference variables and creates appropriate obligations. For example, given the input:",203,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"nodeid"},{"name":"paramenv"},{"name":"t"}],"output":{"name":"inferok"}}],[11,"constrain_anon_types","","Given the map `anon_types` containing the existential `impl Trait` types whose underlying, hidden types are being inferred, this method adds constraints to the regions appearing in those underlying hidden types to ensure that they at least do not refer to random scopes within the current function. These constraints are not (quite) sufficient to guarantee that the regions are actually legal values; that final condition is imposed after region inference is done.",203,{"inputs":[{"name":"self"},{"name":"anontypemap"},{"name":"frr"}],"output":null}],[11,"constrain_anon_type","","",203,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"anontypedecl"},{"name":"frr"}],"output":null}],[11,"infer_anon_definition_from_instantiation","","Given the fully resolved, instantiated type for an anonymous type, i.e., the value of an inference variable like C1 or C2 (*), computes the \"definition type\" for an abstract type definition -- that is, the inferred value of `Foo1<'x>` or `Foo2<'x>` that we would conceptually use in its definition:",203,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"anontypedecl"},{"name":"ty"}],"output":{"name":"ty"}}],[11,"new","rustc::infer::anon_types","",216,{"inputs":[{"name":"tyctxt"},{"name":"bool"},{"name":"defid"},{"generics":["kind","kind"],"name":"fxhashmap"},{"name":"ty"}],"output":{"name":"self"}}],[11,"fold_kind_mapping_missing_regions_to_empty","","",216,{"inputs":[{"name":"self"},{"name":"kind"}],"output":{"name":"kind"}}],[11,"fold_kind_normally","","",216,{"inputs":[{"name":"self"},{"name":"kind"}],"output":{"name":"kind"}}],[11,"tcx","","",216,{"inputs":[{"name":"self"}],"output":{"name":"tyctxt"}}],[11,"fold_region","","",216,{"inputs":[{"name":"self"},{"name":"region"}],"output":{"name":"region"}}],[11,"fold_ty","","",216,{"inputs":[{"name":"self"},{"name":"ty"}],"output":{"name":"ty"}}],[11,"instantiate_anon_types_in_map","","",217,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"t"}}],[11,"fold_anon_ty","","",217,{"inputs":[{"name":"self"},{"name":"ty"},{"name":"defid"},{"name":"substs"}],"output":{"name":"ty"}}],[0,"at","rustc::infer","A nice interface for working with the infcx.  The basic idea is to do `infcx.at(cause, param_env)`, which sets the \"cause\" of the operation as well as the surrounding parameter environment.  Then you can do something like `.sub(a, b)` or `.eq(a, b)` to create a subtype or equality relationship respectively. The first argument is always the \"expected\" output from the POV of diagnostics.",null,null],[3,"At","rustc::infer::at","",null,null],[12,"infcx","","",218,null],[12,"cause","","",218,null],[12,"param_env","","",218,null],[3,"Trace","","",null,null],[12,"at","","",219,null],[12,"a_is_expected","","",219,null],[12,"trace","","",219,null],[8,"ToTrace","","",null,null],[10,"to_trace","","",220,{"inputs":[{"name":"obligationcause"},{"name":"bool"},{"name":"self"},{"name":"self"}],"output":{"name":"typetrace"}}],[11,"at","rustc::infer","",203,{"inputs":[{"name":"self"},{"name":"obligationcause"},{"name":"paramenv"}],"output":{"name":"at"}}],[11,"eq_impl_headers","rustc::infer::at","Hacky routine for equating two impl headers in coherence.",218,{"inputs":[{"name":"self"},{"name":"implheader"},{"name":"implheader"}],"output":{"name":"inferresult"}}],[11,"sub_exp","","Make `a <: b` where `a` may or may not be expected",218,{"inputs":[{"name":"self"},{"name":"bool"},{"name":"t"},{"name":"t"}],"output":{"name":"inferresult"}}],[11,"sup","","Make `actual <: expected`. For example, if type-checking a call like `foo(x)`, where `foo: fn(i32)`, you might have `sup(i32, x)`, since the \"expected\" type is the type that appears in the signature.",218,{"inputs":[{"name":"self"},{"name":"t"},{"name":"t"}],"output":{"name":"inferresult"}}],[11,"sub","","Make `expected <: actual`",218,{"inputs":[{"name":"self"},{"name":"t"},{"name":"t"}],"output":{"name":"inferresult"}}],[11,"eq_exp","","Make `expected <: actual`",218,{"inputs":[{"name":"self"},{"name":"bool"},{"name":"t"},{"name":"t"}],"output":{"name":"inferresult"}}],[11,"eq","","Make `expected <: actual`",218,{"inputs":[{"name":"self"},{"name":"t"},{"name":"t"}],"output":{"name":"inferresult"}}],[11,"lub","","Compute the least-upper-bound, or mutual supertype, of two values. The order of the arguments doesn't matter, but since this can result in an error (e.g., if asked to compute LUB of u32 and i32), it is meaningful to call one of them the \"expected type\".",218,{"inputs":[{"name":"self"},{"name":"t"},{"name":"t"}],"output":{"name":"inferresult"}}],[11,"glb","","Compute the greatest-lower-bound, or mutual subtype, of two values. As with `lub` order doesn't matter, except for error cases.",218,{"inputs":[{"name":"self"},{"name":"t"},{"name":"t"}],"output":{"name":"inferresult"}}],[11,"trace","","Sets the \"trace\" values that will be used for error-reporting, but doesn't actually perform any operation yet (this is useful when you want to set the trace using distinct values from those you wish to operate upon).",218,{"inputs":[{"name":"self"},{"name":"t"},{"name":"t"}],"output":{"name":"trace"}}],[11,"trace_exp","","Like `trace`, but the expected value is determined by the boolean argument (if true, then the first argument `a` is the \"expected\" value).",218,{"inputs":[{"name":"self"},{"name":"bool"},{"name":"t"},{"name":"t"}],"output":{"name":"trace"}}],[11,"sub","","Make `a <: b` where `a` may or may not be expected (if `a_is_expected` is true, then `a` is expected). Make `expected <: actual`",219,{"inputs":[{"name":"self"},{"name":"t"},{"name":"t"}],"output":{"name":"inferresult"}}],[11,"eq","","Make `a == b`; the expectation is set by the call to `trace()`.",219,{"inputs":[{"name":"self"},{"name":"t"},{"name":"t"}],"output":{"name":"inferresult"}}],[11,"lub","","",219,{"inputs":[{"name":"self"},{"name":"t"},{"name":"t"}],"output":{"name":"inferresult"}}],[11,"glb","","",219,{"inputs":[{"name":"self"},{"name":"t"},{"name":"t"}],"output":{"name":"inferresult"}}],[0,"canonical","rustc::infer","Canonicalization is the key to constructing a query in the middle of type inference. Ordinarily, it is not possible to store types from type inference in query keys, because they contain references to inference variables whose lifetimes are too short and so forth. Canonicalizing a value T1 using `canonicalize_query` produces two things:",null,null],[3,"Canonical","rustc::infer::canonical","A \"canonicalized\" type `V` is one where all free inference variables have been rewriten to \"canonical vars\". These are numbered starting from 0 in order of first appearance.",null,null],[12,"variables","","",221,null],[12,"value","","",221,null],[3,"CanonicalVarValues","","A set of values corresponding to the canonical variables from some `Canonical`. You can give these values to `canonical_value.substitute` to substitute them into the canonical value at the right places.",null,null],[12,"var_values","","",222,null],[3,"CanonicalVarInfo","","Information about a canonical variable that is included with the canonical value. This is sufficient information for code to create a copy of the canonical value in some other inference context, with fresh inference variables replacing the canonical values.",null,null],[12,"kind","","",223,null],[3,"QueryResult","","After we execute a query with a canonicalized key, we get back a `Canonical<QueryResult<..>>`. You can use `instantiate_query_result` to access the data in this result.",null,null],[12,"var_values","","",224,null],[12,"region_constraints","","",224,null],[12,"certainty","","",224,null],[12,"value","","",224,null],[3,"CanonicalizeAllFreeRegions","","If this flag is true, then all free regions will be replaced with a canonical var. This is used to make queries as generic as possible. For example, the query `F: Foo<'static>` would be canonicalized to `F: Foo<'0>`.",null,null],[12,"0","","",225,null],[3,"Canonicalizer","","",null,null],[12,"infcx","","",226,null],[12,"tcx","","",226,null],[12,"variables","","",226,null],[12,"indices","","",226,null],[12,"var_values","","",226,null],[12,"canonicalize_all_free_regions","","",226,null],[12,"needs_canonical_flags","","",226,null],[3,"CanonicalVarValuesSubst","","",null,null],[12,"tcx","","",227,null],[12,"var_values","","",227,null],[4,"CanonicalVarKind","","Describes the \"kind\" of the canonical variable. This is a \"kind\" in the type-theory sense of the term -- i.e., a \"meta\" type system that analyzes type-like values.",null,null],[13,"Ty","","Some kind of type inference variable.",228,null],[13,"Region","","Region variable `'?R`.",228,null],[4,"CanonicalTyVarKind","","Rust actually has more than one category of type variables; notably, the type variables we create for literals (e.g., 22 or 22.) can only be instantiated with integral/float types (e.g., usize or f32). In order to faithfully reproduce a type, we need to know what set of types a given type variable can be unified with.",null,null],[13,"General","","General type variable `?T` that can be unified with arbitrary types.",229,null],[13,"Int","","Integral type variable `?I` (that can only be unified with integral types).",229,null],[13,"Float","","Floating-point type variable `?F` (that can only be unified with float types).",229,null],[4,"Certainty","","Indicates whether or not we were able to prove the query to be true.",null,null],[13,"Proven","","The query is known to be true, presuming that you apply the given `var_values` and the region-constraints are satisfied.",230,null],[13,"Ambiguous","","The query is not known to be true, but also not known to be false. The `var_values` represent either values that must hold in order for the query to be true, or helpful tips that might make it true. Currently rustc's trait solver cannot distinguish the two (e.g., due to our preference for where clauses over impls).",230,null],[5,"substitute_value","","Substitute the values from `var_values` into `value`. `var_values` must be values for the set of cnaonical variables that appear in `value`.",null,{"inputs":[{"name":"tyctxt"},{"name":"canonicalvarvalues"},{"name":"t"}],"output":{"name":"t"}}],[6,"CanonicalVarInfos","","",null,null],[6,"QueryRegionConstraint","","",null,null],[8,"Canonicalize","","Trait implemented by values that can be canonicalized. It mainly serves to identify the interning table we will use.",null,null],[16,"Canonicalized","","",231,null],[10,"intern","","After a value has been fully canonicalized and lifted, this method will allocate it in a global arena.",231,null],[11,"clone","","",221,{"inputs":[{"name":"self"}],"output":{"name":"canonical"}}],[11,"fmt","","",221,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",221,{"inputs":[{"name":"self"},{"name":"canonical"}],"output":{"name":"bool"}}],[11,"ne","","",221,{"inputs":[{"name":"self"},{"name":"canonical"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",221,null],[11,"hash","","",221,null],[11,"decode","","",221,{"inputs":[{"name":"__dv"}],"output":{"generics":["canonical"],"name":"result"}}],[11,"encode","","",221,{"inputs":[{"name":"self"},{"name":"__sv"}],"output":{"name":"result"}}],[11,"clone","","",222,{"inputs":[{"name":"self"}],"output":{"name":"canonicalvarvalues"}}],[11,"fmt","","",222,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",222,{"inputs":[{"name":"self"},{"name":"canonicalvarvalues"}],"output":{"name":"bool"}}],[11,"ne","","",222,{"inputs":[{"name":"self"},{"name":"canonicalvarvalues"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",222,null],[11,"hash","","",222,null],[11,"decode","","",222,{"inputs":[{"name":"__d"}],"output":{"generics":["canonicalvarvalues"],"name":"result"}}],[11,"encode","","",222,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"clone","","",223,{"inputs":[{"name":"self"}],"output":{"name":"canonicalvarinfo"}}],[11,"fmt","","",223,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",223,{"inputs":[{"name":"self"},{"name":"canonicalvarinfo"}],"output":{"name":"bool"}}],[11,"ne","","",223,{"inputs":[{"name":"self"},{"name":"canonicalvarinfo"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",223,null],[11,"hash","","",223,null],[11,"decode","","",223,{"inputs":[{"name":"__d"}],"output":{"generics":["canonicalvarinfo"],"name":"result"}}],[11,"encode","","",223,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"clone","","",228,{"inputs":[{"name":"self"}],"output":{"name":"canonicalvarkind"}}],[11,"fmt","","",228,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",228,{"inputs":[{"name":"self"},{"name":"canonicalvarkind"}],"output":{"name":"bool"}}],[11,"ne","","",228,{"inputs":[{"name":"self"},{"name":"canonicalvarkind"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",228,null],[11,"hash","","",228,null],[11,"decode","","",228,{"inputs":[{"name":"__d"}],"output":{"generics":["canonicalvarkind"],"name":"result"}}],[11,"encode","","",228,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"clone","","",229,{"inputs":[{"name":"self"}],"output":{"name":"canonicaltyvarkind"}}],[11,"fmt","","",229,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",229,{"inputs":[{"name":"self"},{"name":"canonicaltyvarkind"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",229,null],[11,"hash","","",229,null],[11,"decode","","",229,{"inputs":[{"name":"__d"}],"output":{"generics":["canonicaltyvarkind"],"name":"result"}}],[11,"encode","","",229,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"clone","","",224,{"inputs":[{"name":"self"}],"output":{"name":"queryresult"}}],[11,"fmt","","",224,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",230,{"inputs":[{"name":"self"}],"output":{"name":"certainty"}}],[11,"fmt","","",230,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"is_proven","","",230,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_ambiguous","","",230,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_proven","","",224,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_ambiguous","","",224,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_proven","","",221,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_ambiguous","","",221,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"instantiate_canonical_with_fresh_inference_vars","rustc::infer","Creates a substitution S for the canonical value with fresh inference variables and applies it to the canonical value. Returns both the instantiated result and the substitution S.",203,null],[11,"fresh_inference_vars_for_canonical_vars","","Given the \"infos\" about the canonical variables from some canonical, creates fresh inference variables with the same characteristics. You can then use `substitute` to instantiate the canonical variable with these inference variables.",203,{"inputs":[{"name":"self"},{"name":"span"},{"name":"slice"}],"output":{"name":"canonicalvarvalues"}}],[11,"fresh_inference_var_for_canonical_var","","Given the \"info\" about a canonical variable, creates a fresh inference variable with the same characteristics.",203,{"inputs":[{"name":"self"},{"name":"span"},{"name":"canonicalvarinfo"}],"output":{"name":"kind"}}],[11,"instantiate_query_result","","Given the (canonicalized) result to a canonical query, instantiates the result so it can be used, plugging in the values from the canonical query. (Note that the result may have been ambiguous; you should check the certainty level of the query before applying this function.)",203,{"inputs":[{"name":"self"},{"name":"obligationcause"},{"name":"paramenv"},{"name":"canonicalvarvalues"},{"name":"canonical"}],"output":{"name":"inferresult"}}],[11,"query_region_constraints_into_obligations","","Converts the region constraints resulting from a query into an iterator of obligations.",203,null],[11,"unify_canonical_vars","","Given two sets of values for the same set of canonical variables, unify them. The second set is produced lazilly by supplying indices from the first set.",203,null],[11,"canonicalize_query","","Canonicalizes a query value `V`. When we canonicalize a query, we not only canonicalize unbound inference variables, but we also replace all free regions whatsoever. So for example a query like `T: Trait<'static>` would be canonicalized to",203,null],[11,"canonicalize_response","","Canonicalizes a query response `V`. When we canonicalize a query response, we only canonicalize unbound inference variables, and we leave other free regions alone. So, continuing with the example from `canonicalize_query`, if there was an input query `T: Trait<'static>`, it would have been canonicalized to",203,null],[11,"tcx","rustc::infer::canonical","",226,{"inputs":[{"name":"self"}],"output":{"name":"tyctxt"}}],[11,"fold_region","","",226,{"inputs":[{"name":"self"},{"name":"region"}],"output":{"name":"region"}}],[11,"fold_ty","","",226,{"inputs":[{"name":"self"},{"name":"ty"}],"output":{"name":"ty"}}],[11,"canonicalize","","The main `canonicalize` method, shared impl of `canonicalize_query` and `canonicalize_response`.",226,null],[11,"canonical_var","","Creates a canonical variable replacing `kind` from the input, or returns an existing variable if `kind` has already been seen. `kind` is expected to be an unbound variable (or potentially a free region).",226,{"inputs":[{"name":"self"},{"name":"canonicalvarinfo"},{"name":"kind"}],"output":{"name":"canonicalvar"}}],[11,"canonicalize_ty_var","","Given a type variable `ty_var` of the given kind, first check if `ty_var` is bound to anything; if so, canonicalize that. Otherwise, create a new canonical variable for `ty_var`.",226,{"inputs":[{"name":"self"},{"name":"canonicaltyvarkind"},{"name":"ty"}],"output":{"name":"ty"}}],[11,"substitute","","Instantiate the wrapped value, replacing each canonical value with the value given in `var_values`.",221,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"canonicalvarvalues"}],"output":{"name":"v"}}],[11,"substitute_projected","","Invoke `projection_fn` with `self.value` to get a value V that is expressed in terms of the same canonical variables bound in `self`. Apply the substitution `var_values` to this value V, replacing each of the canonical variables.",221,null],[11,"tcx","","",227,{"inputs":[{"name":"self"}],"output":{"name":"tyctxt"}}],[11,"fold_ty","","",227,{"inputs":[{"name":"self"},{"name":"ty"}],"output":{"name":"ty"}}],[11,"fold_region","","",227,{"inputs":[{"name":"self"},{"name":"region"}],"output":{"name":"region"}}],[11,"super_fold_with","","",230,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"certainty"}}],[11,"super_visit_with","","",230,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",223,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"canonicalvarinfo"}}],[11,"super_visit_with","","",223,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",228,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"canonicalvarkind"}}],[11,"super_visit_with","","",228,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"lift_to_tcx","","",230,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","","",223,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","","",228,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"super_fold_with","","",232,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"canonicalvarinfos"}}],[11,"super_visit_with","","",232,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",221,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",221,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"lift_to_tcx","","",221,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"generics":["canonical"],"name":"option"}}],[11,"iter","","",222,null],[11,"len","","",222,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"lift_to_tcx","","",222,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"generics":["canonicalvarvalues"],"name":"option"}}],[11,"super_fold_with","","",222,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",222,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",224,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",224,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"lift_to_tcx","","",224,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"generics":["queryresult"],"name":"option"}}],[11,"index","","",222,{"inputs":[{"name":"self"},{"name":"canonicalvar"}],"output":{"name":"kind"}}],[0,"combine","rustc::infer","",null,null],[3,"CombineFields","rustc::infer::combine","",null,null],[12,"infcx","","",233,null],[12,"trace","","",233,null],[12,"cause","","",233,null],[12,"param_env","","",233,null],[12,"obligations","","",233,null],[3,"Generalizer","","",null,null],[12,"infcx","","",234,null],[12,"span","","Span, used when creating new type variables and things.",234,null],[12,"for_vid_sub_root","","The vid of the type variable that is in the process of being instantiated; if we find this within the type we are folding, that means we would have created a cyclic type.",234,null],[12,"ambient_variance","","Track the variance as we descend into the type.",234,null],[12,"needs_wf","","See the field `needs_wf` in `Generalization`.",234,null],[12,"root_ty","","The root type that we are generalizing. Used when reporting cycles.",234,null],[3,"Generalization","","Result from a generalization operation. This includes not only the generalized type, but also a bool flag indicating whether further WF checks are needed.",null,null],[12,"ty","","",235,null],[12,"needs_wf","","If true, then the generalized type may not be well-formed, even if the source type is well-formed, so we should add an additional check to enforce that it is. This arises in particular around 'bivariant' type parameters that are only constrained by a where-clause. As an example, imagine a type:",235,null],[4,"RelationDir","","",null,null],[13,"SubtypeOf","","",236,null],[13,"SupertypeOf","","",236,null],[13,"EqTo","","",236,null],[5,"int_unification_error","","",null,null],[5,"float_unification_error","","",null,null],[8,"RelateResultCompare","","",null,null],[10,"compare","","",237,{"inputs":[{"name":"self"},{"name":"t"},{"name":"f"}],"output":{"name":"relateresult"}}],[11,"clone","","",233,{"inputs":[{"name":"self"}],"output":{"name":"combinefields"}}],[11,"clone","","",236,{"inputs":[{"name":"self"}],"output":{"name":"relationdir"}}],[11,"assert_receiver_is_total_eq","","",236,null],[11,"eq","","",236,{"inputs":[{"name":"self"},{"name":"relationdir"}],"output":{"name":"bool"}}],[11,"hash","","",236,null],[11,"fmt","","",236,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"super_combine_tys","rustc::infer","",203,{"inputs":[{"name":"self"},{"name":"r"},{"name":"ty"},{"name":"ty"}],"output":{"generics":["ty"],"name":"relateresult"}}],[11,"unify_integral_variable","","",203,{"inputs":[{"name":"self"},{"name":"bool"},{"name":"intvid"},{"name":"intvarvalue"}],"output":{"generics":["ty"],"name":"relateresult"}}],[11,"unify_float_variable","","",203,{"inputs":[{"name":"self"},{"name":"bool"},{"name":"floatvid"},{"name":"floatty"}],"output":{"generics":["ty"],"name":"relateresult"}}],[11,"tcx","rustc::infer::combine","",233,{"inputs":[{"name":"self"}],"output":{"name":"tyctxt"}}],[11,"equate","","",233,{"inputs":[{"name":"self"},{"name":"bool"}],"output":{"name":"equate"}}],[11,"sub","","",233,{"inputs":[{"name":"self"},{"name":"bool"}],"output":{"name":"sub"}}],[11,"lub","","",233,{"inputs":[{"name":"self"},{"name":"bool"}],"output":{"name":"lub"}}],[11,"glb","","",233,{"inputs":[{"name":"self"},{"name":"bool"}],"output":{"name":"glb"}}],[11,"instantiate","","Here dir is either EqTo, SubtypeOf, or SupertypeOf. The idea is that we should ensure that the type `a_ty` is equal to, a subtype of, or a supertype of (respectively) the type to which `b_vid` is bound.",233,{"inputs":[{"name":"self"},{"name":"ty"},{"name":"relationdir"},{"name":"tyvid"},{"name":"bool"}],"output":{"name":"relateresult"}}],[11,"generalize","","Attempts to generalize `ty` for the type variable `for_vid`. This checks for cycle -- that is, whether the type `ty` references `for_vid`. The `dir` is the \"direction\" for which we a performing the generalization (i.e., are we producing a type that can be used as a supertype etc).",233,{"inputs":[{"name":"self"},{"name":"ty"},{"name":"tyvid"},{"name":"relationdir"}],"output":{"generics":["generalization"],"name":"relateresult"}}],[11,"tcx","","",234,{"inputs":[{"name":"self"}],"output":{"name":"tyctxt"}}],[11,"tag","","",234,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"a_is_expected","","",234,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"binders","","",234,{"inputs":[{"name":"self"},{"name":"binder"},{"name":"binder"}],"output":{"generics":["binder"],"name":"relateresult"}}],[11,"relate_item_substs","","",234,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"substs"},{"name":"substs"}],"output":{"generics":["substs"],"name":"relateresult"}}],[11,"relate_with_variance","","",234,{"inputs":[{"name":"self"},{"name":"variance"},{"name":"t"},{"name":"t"}],"output":{"name":"relateresult"}}],[11,"tys","","",234,{"inputs":[{"name":"self"},{"name":"ty"},{"name":"ty"}],"output":{"generics":["ty"],"name":"relateresult"}}],[11,"regions","","",234,{"inputs":[{"name":"self"},{"name":"region"},{"name":"region"}],"output":{"generics":["region"],"name":"relateresult"}}],[0,"equate","rustc::infer","",null,null],[3,"Equate","rustc::infer::equate","Ensures `a` is made equal to `b`. Returns `a` on success.",null,null],[12,"fields","","",238,null],[12,"a_is_expected","","",238,null],[11,"new","","",238,{"inputs":[{"name":"combinefields"},{"name":"bool"}],"output":{"name":"equate"}}],[11,"tag","","",238,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"tcx","","",238,{"inputs":[{"name":"self"}],"output":{"name":"tyctxt"}}],[11,"a_is_expected","","",238,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"relate_item_substs","","",238,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"substs"},{"name":"substs"}],"output":{"generics":["substs"],"name":"relateresult"}}],[11,"relate_with_variance","","",238,{"inputs":[{"name":"self"},{"name":"variance"},{"name":"t"},{"name":"t"}],"output":{"name":"relateresult"}}],[11,"tys","","",238,{"inputs":[{"name":"self"},{"name":"ty"},{"name":"ty"}],"output":{"generics":["ty"],"name":"relateresult"}}],[11,"regions","","",238,{"inputs":[{"name":"self"},{"name":"region"},{"name":"region"}],"output":{"generics":["region"],"name":"relateresult"}}],[11,"binders","","",238,{"inputs":[{"name":"self"},{"name":"binder"},{"name":"binder"}],"output":{"generics":["binder"],"name":"relateresult"}}],[0,"error_reporting","rustc::infer","Error Reporting Code for the inference engine",null,null],[4,"FailureCode","rustc::infer::error_reporting","",null,null],[13,"Error0317","","",239,null],[13,"Error0580","","",239,null],[13,"Error0308","","",239,null],[13,"Error0644","","",239,null],[0,"note","","",null,null],[11,"note_region_origin","rustc::infer","",203,{"inputs":[{"name":"self"},{"name":"diagnosticbuilder"},{"name":"subregionorigin"}],"output":null}],[11,"report_concrete_failure","","",203,{"inputs":[{"name":"self"},{"name":"scopetree"},{"name":"subregionorigin"},{"name":"region"},{"name":"region"}],"output":{"name":"diagnosticbuilder"}}],[0,"need_type_info","rustc::infer::error_reporting","",null,null],[3,"FindLocalByTypeVisitor","rustc::infer::error_reporting::need_type_info","",null,null],[12,"infcx","","",240,null],[12,"target_ty","","",240,null],[12,"hir_map","","",240,null],[12,"found_local_pattern","","",240,null],[12,"found_arg_pattern","","",240,null],[11,"node_matches_type","","",240,{"inputs":[{"name":"self"},{"name":"hirid"}],"output":{"name":"bool"}}],[11,"nested_visit_map","","",240,{"inputs":[{"name":"self"}],"output":{"name":"nestedvisitormap"}}],[11,"visit_local","","",240,{"inputs":[{"name":"self"},{"name":"local"}],"output":null}],[11,"visit_body","","",240,{"inputs":[{"name":"self"},{"name":"body"}],"output":null}],[11,"extract_type_name","rustc::infer","",203,{"inputs":[{"name":"self"},{"name":"ty"}],"output":{"name":"string"}}],[11,"need_type_info","","",203,{"inputs":[{"name":"self"},{"generics":["bodyid"],"name":"option"},{"name":"span"},{"name":"ty"}],"output":null}],[0,"nice_region_error","rustc::infer::error_reporting","",null,null],[3,"NiceRegionError","rustc::infer::error_reporting::nice_region_error","",null,null],[12,"tcx","","",241,null],[12,"error","","",241,null],[12,"regions","","",241,null],[12,"tables","","",241,null],[0,"different_lifetimes","","Error Reporting for Anonymous Region Lifetime Errors where both the regions are anonymous.",null,null],[11,"try_report_anon_anon_conflict","","Print the error message for lifetime errors when both the concerned regions are anonymous.",241,{"inputs":[{"name":"self"}],"output":{"generics":["errorreported"],"name":"option"}}],[0,"find_anon_type","","",null,null],[3,"FindNestedTypeVisitor","rustc::infer::error_reporting::nice_region_error::find_anon_type","",null,null],[12,"tcx","","",242,null],[12,"bound_region","","",242,null],[12,"found_type","","",242,null],[12,"depth","","",242,null],[3,"TyPathVisitor","","",null,null],[12,"tcx","","",243,null],[12,"found_it","","",243,null],[12,"bound_region","","",243,null],[12,"depth","","",243,null],[11,"find_anon_type","rustc::infer::error_reporting::nice_region_error","This function calls the `visit_ty` method for the parameters corresponding to the anonymous regions. The `nested_visitor.found_type` contains the anonymous type.",241,{"inputs":[{"name":"self"},{"name":"region"},{"name":"boundregion"}],"output":{"name":"option"}}],[11,"find_component_for_bound_region","","",241,{"inputs":[{"name":"self"},{"name":"ty"},{"name":"boundregion"}],"output":{"generics":["ty"],"name":"option"}}],[11,"nested_visit_map","rustc::infer::error_reporting::nice_region_error::find_anon_type","",242,{"inputs":[{"name":"self"}],"output":{"name":"nestedvisitormap"}}],[11,"visit_ty","","",242,{"inputs":[{"name":"self"},{"name":"ty"}],"output":null}],[11,"nested_visit_map","","",243,{"inputs":[{"name":"self"}],"output":{"name":"nestedvisitormap"}}],[11,"visit_lifetime","","",243,{"inputs":[{"name":"self"},{"name":"lifetime"}],"output":null}],[11,"visit_ty","","",243,{"inputs":[{"name":"self"},{"name":"ty"}],"output":null}],[0,"named_anon_conflict","rustc::infer::error_reporting::nice_region_error","Error Reporting for Anonymous Region Lifetime Errors where one region is named and the other is anonymous.",null,null],[11,"try_report_named_anon_conflict","","When given a `ConcreteFailure` for a function with arguments containing a named region and an anonymous region, emit an descriptive diagnostic error.",241,{"inputs":[{"name":"self"}],"output":{"generics":["errorreported"],"name":"option"}}],[11,"is_named_region","","",241,{"inputs":[{"name":"self"},{"name":"region"}],"output":{"name":"bool"}}],[0,"outlives_closure","","Error Reporting for Anonymous Region Lifetime Errors where both the regions are anonymous.",null,null],[11,"try_report_outlives_closure","","Print the error message for lifetime errors when binding excapes a closure.",241,{"inputs":[{"name":"self"}],"output":{"generics":["errorreported"],"name":"option"}}],[0,"util","","Helper functions corresponding to lifetime errors due to anonymous regions.",null,null],[3,"AnonymousArgInfo","rustc::infer::error_reporting::nice_region_error::util","",null,null],[12,"arg","","",244,null],[12,"arg_ty","","",244,null],[12,"bound_region","","",244,null],[12,"is_first","","",244,null],[3,"FreeRegionInfo","","",null,null],[12,"def_id","","",245,null],[12,"boundregion","","",245,null],[12,"is_impl_item","","",245,null],[11,"fmt","","",244,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",245,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"find_arg_with_region","rustc::infer::error_reporting::nice_region_error","",241,{"inputs":[{"name":"self"},{"name":"region"},{"name":"region"}],"output":{"generics":["anonymousarginfo"],"name":"option"}}],[11,"is_suitable_region","","",241,{"inputs":[{"name":"self"},{"name":"region"}],"output":{"generics":["freeregioninfo"],"name":"option"}}],[11,"is_return_type_anon","","",241,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"boundregion"},{"name":"fndecl"}],"output":{"generics":["span"],"name":"option"}}],[11,"is_self_anon","","",241,{"inputs":[{"name":"self"},{"name":"bool"},{"name":"defid"}],"output":{"name":"bool"}}],[11,"is_bound_region_in_impl_item","","",241,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"bool"}}],[11,"try_report_nice_region_error","rustc::infer","",203,{"inputs":[{"name":"self"},{"name":"regionresolutionerror"}],"output":{"name":"bool"}}],[11,"new","rustc::infer::error_reporting::nice_region_error","",241,{"inputs":[{"name":"tyctxt"},{"name":"regionresolutionerror"},{"generics":["typecktables"],"name":"option"}],"output":{"name":"self"}}],[11,"new_from_span","","",241,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"region"},{"name":"region"},{"generics":["typecktables"],"name":"option"}],"output":{"name":"self"}}],[11,"try_report","","",241,{"inputs":[{"name":"self"}],"output":{"generics":["errorreported"],"name":"option"}}],[11,"get_regions","","",241,null],[11,"report_region_errors","rustc::infer","",203,{"inputs":[{"name":"self"},{"name":"scopetree"},{"name":"vec"},{"name":"bool"}],"output":null}],[11,"process_errors","","",203,{"inputs":[{"name":"self"},{"name":"vec"}],"output":{"generics":["regionresolutionerror"],"name":"vec"}}],[11,"check_and_note_conflicting_crates","","Adds a note if the types come from similarly named crates",203,{"inputs":[{"name":"self"},{"name":"diagnosticbuilder"},{"name":"typeerror"},{"name":"span"}],"output":null}],[11,"note_error_origin","","",203,{"inputs":[{"name":"self"},{"name":"diagnosticbuilder"},{"name":"obligationcause"}],"output":null}],[11,"highlight_outer","","Given that `other_ty` is the same as a type argument for `name` in `sub`, populate `value` highlighting `name` and every type argument that isn't at `pos` (which is `other_ty`), and populate `other_value` with `other_ty`.",203,{"inputs":[{"name":"self"},{"name":"diagnosticstyledstring"},{"name":"diagnosticstyledstring"},{"name":"string"},{"name":"substs"},{"name":"usize"},{"name":"ty"}],"output":null}],[11,"cmp_type_arg","","If `other_ty` is the same as a type argument present in `sub`, highlight `path` in `t1_out`, as that is the difference to the other type.",203,{"inputs":[{"name":"self"},{"name":"diagnosticstyledstring"},{"name":"diagnosticstyledstring"},{"name":"string"},{"name":"substs"},{"name":"string"},{"name":"ty"}],"output":{"name":"option"}}],[11,"push_comma","","Add a `,` to the type representation only if it is appropriate.",203,{"inputs":[{"name":"self"},{"name":"diagnosticstyledstring"},{"name":"diagnosticstyledstring"},{"name":"usize"},{"name":"usize"}],"output":null}],[11,"cmp","","Compare two given types, eliding parts that are the same between them and highlighting relevant differences, and return two representation of those types for highlighted printing.",203,null],[11,"note_type_err","","",203,{"inputs":[{"name":"self"},{"name":"diagnosticbuilder"},{"name":"obligationcause"},{"name":"option"},{"generics":["valuepairs"],"name":"option"},{"name":"typeerror"}],"output":null}],[11,"report_and_explain_type_error","","",203,{"inputs":[{"name":"self"},{"name":"typetrace"},{"name":"typeerror"}],"output":{"name":"diagnosticbuilder"}}],[11,"values_str","","",203,{"inputs":[{"name":"self"},{"name":"valuepairs"}],"output":{"name":"option"}}],[11,"expected_found_str_ty","","",203,{"inputs":[{"name":"self"},{"name":"expectedfound"}],"output":{"name":"option"}}],[11,"expected_found_str","","Returns a string of the form \"expected `{}`, found `{}`\".",203,{"inputs":[{"name":"self"},{"name":"expectedfound"}],"output":{"name":"option"}}],[11,"report_generic_bound_failure","","",203,{"inputs":[{"name":"self"},{"name":"scopetree"},{"name":"span"},{"generics":["subregionorigin"],"name":"option"},{"name":"generickind"},{"name":"region"}],"output":null}],[11,"report_sub_sup_conflict","","",203,{"inputs":[{"name":"self"},{"name":"scopetree"},{"name":"regionvariableorigin"},{"name":"subregionorigin"},{"name":"region"},{"name":"subregionorigin"},{"name":"region"}],"output":null}],[11,"report_inference_failure","","",203,{"inputs":[{"name":"self"},{"name":"regionvariableorigin"}],"output":{"name":"diagnosticbuilder"}}],[0,"fudge","","",null,null],[3,"RegionFudger","rustc::infer::fudge","",null,null],[12,"infcx","","",246,null],[12,"type_variables","","",246,null],[12,"region_vars","","",246,null],[12,"origin","","",246,null],[11,"fudge_regions_if_ok","rustc::infer","This rather funky routine is used while processing expected types. What happens here is that we want to propagate a coercion through the return type of a fn to its argument. Consider the type of `Option::Some`, which is basically `for<T> fn(T) -> Option<T>`. So if we have an expression `Some(&[1, 2, 3])`, and that has the expected type `Option<&[u32]>`, we would like to type check `&[1, 2, 3]` with the expectation of `&[u32]`. This will cause us to coerce from `&[u32; 3]` to `&[u32]` and make the users life more pleasant.",203,{"inputs":[{"name":"self"},{"name":"regionvariableorigin"},{"name":"f"}],"output":{"name":"result"}}],[11,"tcx","rustc::infer::fudge","",246,{"inputs":[{"name":"self"}],"output":{"name":"tyctxt"}}],[11,"fold_ty","","",246,{"inputs":[{"name":"self"},{"name":"ty"}],"output":{"name":"ty"}}],[11,"fold_region","","",246,{"inputs":[{"name":"self"},{"name":"region"}],"output":{"name":"region"}}],[0,"glb","rustc::infer","",null,null],[3,"Glb","rustc::infer::glb","\"Greatest lower bound\" (common subtype)",null,null],[12,"fields","","",247,null],[12,"a_is_expected","","",247,null],[11,"new","","",247,{"inputs":[{"name":"combinefields"},{"name":"bool"}],"output":{"name":"glb"}}],[11,"tag","","",247,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"tcx","","",247,{"inputs":[{"name":"self"}],"output":{"name":"tyctxt"}}],[11,"a_is_expected","","",247,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"relate_with_variance","","",247,{"inputs":[{"name":"self"},{"name":"variance"},{"name":"t"},{"name":"t"}],"output":{"name":"relateresult"}}],[11,"tys","","",247,{"inputs":[{"name":"self"},{"name":"ty"},{"name":"ty"}],"output":{"generics":["ty"],"name":"relateresult"}}],[11,"regions","","",247,{"inputs":[{"name":"self"},{"name":"region"},{"name":"region"}],"output":{"generics":["region"],"name":"relateresult"}}],[11,"binders","","",247,{"inputs":[{"name":"self"},{"name":"binder"},{"name":"binder"}],"output":{"generics":["binder"],"name":"relateresult"}}],[11,"infcx","","",247,{"inputs":[{"name":"self"}],"output":{"name":"inferctxt"}}],[11,"cause","","",247,{"inputs":[{"name":"self"}],"output":{"name":"obligationcause"}}],[11,"relate_bound","","",247,{"inputs":[{"name":"self"},{"name":"ty"},{"name":"ty"},{"name":"ty"}],"output":{"name":"relateresult"}}],[0,"higher_ranked","rustc::infer","Helper routines for higher-ranked things. See the `doc` module at the end of the file for details.",null,null],[3,"HrMatchResult","rustc::infer::higher_ranked","",null,null],[12,"value","","",248,null],[5,"var_ids","","",null,{"inputs":[{"name":"combinefields"},{"name":"lazybtreemap"}],"output":{"generics":["regionvid"],"name":"vec"}}],[5,"is_var_in_set","","",null,null],[5,"fold_regions_in","","",null,{"inputs":[{"name":"tyctxt"},{"name":"t"},{"name":"f"}],"output":{"name":"t"}}],[11,"higher_ranked_sub","rustc::infer::combine","",233,{"inputs":[{"name":"self"},{"name":"binder"},{"name":"binder"},{"name":"bool"}],"output":{"generics":["binder"],"name":"relateresult"}}],[11,"higher_ranked_match","","The value consists of a pair `(t, u)` where `t` is the matcher and `u` is a value. The idea is to find a substitution `S` such that `S(t) == b`, and then return `S(u)`. In other words, find values for the late-bound regions in `a` that can make `t == b` and then replace the LBR in `u` with those values.",233,{"inputs":[{"name":"self"},{"name":"binder"},{"name":"t"},{"name":"bool"}],"output":{"generics":["hrmatchresult"],"name":"relateresult"}}],[11,"higher_ranked_lub","","",233,{"inputs":[{"name":"self"},{"name":"binder"},{"name":"binder"},{"name":"bool"}],"output":{"generics":["binder"],"name":"relateresult"}}],[11,"higher_ranked_glb","","",233,{"inputs":[{"name":"self"},{"name":"binder"},{"name":"binder"},{"name":"bool"}],"output":{"generics":["binder"],"name":"relateresult"}}],[11,"tainted_regions","rustc::infer","",203,{"inputs":[{"name":"self"},{"name":"combinedsnapshot"},{"name":"region"},{"name":"taintdirections"}],"output":{"generics":["region"],"name":"fxhashset"}}],[11,"region_vars_confined_to_snapshot","","Returns the set of region variables that do not affect any types/regions which existed before `snapshot` was started. This is used in the sub/lub/glb computations. The idea here is that when we are computing lub/glb of two regions, we sometimes create intermediate region variables. Those region variables may touch some of the skolemized or other \"forbidden\" regions we created to replace bound regions, but they don't really represent an \"external\" constraint.",203,{"inputs":[{"name":"self"},{"name":"combinedsnapshot"}],"output":{"generics":["regionvid"],"name":"vec"}}],[11,"skolemize_late_bound_regions","","Replace all regions bound by `binder` with skolemized regions and return a map indicating which bound-region was replaced with what skolemized region. This is the first step of checking subtyping when higher-ranked things are involved.",203,null],[11,"leak_check","","Searches the region constraints created since `snapshot` was started and checks to determine whether any of the skolemized regions created in `skol_map` would \"escape\" -- meaning that they are related to other regions in some way. If so, the higher-ranked subtyping doesn't hold. See `README.md` for more details.",203,{"inputs":[{"name":"self"},{"name":"bool"},{"name":"span"},{"name":"skolemizationmap"},{"name":"combinedsnapshot"}],"output":{"name":"relateresult"}}],[11,"plug_leaks","","This code converts from skolemized regions back to late-bound regions. It works by replacing each region in the taint set of a skolemized region with a bound-region. The bound region will be bound by the outer-most binder in `value`; the caller must ensure that there is such a binder and it is the right place.",203,{"inputs":[{"name":"self"},{"name":"skolemizationmap"},{"name":"combinedsnapshot"},{"name":"t"}],"output":{"name":"t"}}],[11,"pop_skolemized","","Pops the skolemized regions found in `skol_map` from the region inference context. Whenever you create skolemized regions via `skolemize_late_bound_regions`, they must be popped before you commit the enclosing snapshot (if you do not commit, e.g. within a probe or as a result of an error, then this is not necessary, as popping happens as part of the rollback).",203,{"inputs":[{"name":"self"},{"name":"skolemizationmap"},{"name":"combinedsnapshot"}],"output":null}],[0,"lattice","","Lattice Variables",null,null],[5,"super_lattice_tys","rustc::infer::lattice","",null,{"inputs":[{"name":"l"},{"name":"ty"},{"name":"ty"}],"output":{"generics":["ty"],"name":"relateresult"}}],[8,"LatticeDir","","",null,null],[10,"infcx","","",249,{"inputs":[{"name":"self"}],"output":{"name":"inferctxt"}}],[10,"cause","","",249,{"inputs":[{"name":"self"}],"output":{"name":"obligationcause"}}],[10,"relate_bound","","",249,{"inputs":[{"name":"self"},{"name":"ty"},{"name":"ty"},{"name":"ty"}],"output":{"name":"relateresult"}}],[0,"lub","rustc::infer","",null,null],[3,"Lub","rustc::infer::lub","\"Least upper bound\" (common supertype)",null,null],[12,"fields","","",250,null],[12,"a_is_expected","","",250,null],[11,"new","","",250,{"inputs":[{"name":"combinefields"},{"name":"bool"}],"output":{"name":"lub"}}],[11,"tag","","",250,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"tcx","","",250,{"inputs":[{"name":"self"}],"output":{"name":"tyctxt"}}],[11,"a_is_expected","","",250,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"relate_with_variance","","",250,{"inputs":[{"name":"self"},{"name":"variance"},{"name":"t"},{"name":"t"}],"output":{"name":"relateresult"}}],[11,"tys","","",250,{"inputs":[{"name":"self"},{"name":"ty"},{"name":"ty"}],"output":{"generics":["ty"],"name":"relateresult"}}],[11,"regions","","",250,{"inputs":[{"name":"self"},{"name":"region"},{"name":"region"}],"output":{"generics":["region"],"name":"relateresult"}}],[11,"binders","","",250,{"inputs":[{"name":"self"},{"name":"binder"},{"name":"binder"}],"output":{"generics":["binder"],"name":"relateresult"}}],[11,"infcx","","",250,{"inputs":[{"name":"self"}],"output":{"name":"inferctxt"}}],[11,"cause","","",250,{"inputs":[{"name":"self"}],"output":{"name":"obligationcause"}}],[11,"relate_bound","","",250,{"inputs":[{"name":"self"},{"name":"ty"},{"name":"ty"},{"name":"ty"}],"output":{"name":"relateresult"}}],[0,"region_constraints","rustc::infer","See README.md",null,null],[3,"RegionConstraintCollector","rustc::infer::region_constraints","",null,null],[12,"var_infos","","For each `RegionVid`, the corresponding `RegionVariableOrigin`.",251,null],[12,"data","","",251,null],[12,"lubs","","For a given pair of regions (R1, R2), maps to a region R3 that is designated as their LUB (edges R1 <= R3 and R2 <= R3 exist). This prevents us from making many such regions.",251,null],[12,"glbs","","For a given pair of regions (R1, R2), maps to a region R3 that is designated as their GLB (edges R3 <= R1 and R3 <= R2 exist). This prevents us from making many such regions.",251,null],[12,"bound_count","","Global counter used during the GLB algorithm to create unique names for fresh bound regions",251,null],[12,"undo_log","","The undo log records actions that might later be undone.",251,null],[12,"unification_table","","When we add a R1 == R2 constriant, we currently add (a) edges R1 <= R2 and R2 <= R1 and (b) we unify the two regions in this table. You can then call `opportunistic_resolve_var` early which will map R1 and R2 to some common region (i.e., either R1 or R2). This is important when dropck and other such code is iterating to a fixed point, because otherwise we sometimes would wind up with a fresh stream of region variables that have been equated but appear distinct.",251,null],[3,"RegionConstraintData","","The full set of region constraints gathered up by the collector. Describes constraints between the region variables and other regions, as well as other conditions that must be verified, or assumptions that can be made.",null,null],[12,"constraints","","Constraints of the form `A <= B`, where either `A` or `B` can be a region variable (or neither, as it happens).",252,null],[12,"verifys","","A \"verify\" is something that we need to verify after inference is done, but which does not directly affect inference in any way.",252,null],[12,"givens","","A \"given\" is a relationship that is known to hold. In particular, we often know from closure fn signatures that a particular free region must be a subregion of a region variable:",252,null],[3,"Verify","","VerifyGenericBound(T, _, R, RS): The parameter type `T` (or associated type) must outlive the region `R`. `T` is known to outlive `RS`. Therefore verify that `R <= RS[i]` for some `i`. Inference variables may be involved (but this verification step doesn't influence inference).",null,null],[12,"kind","","",253,null],[12,"origin","","",253,null],[12,"region","","",253,null],[12,"bound","","",253,null],[3,"TwoRegions","","",null,null],[12,"a","","",254,null],[12,"b","","",254,null],[3,"RegionVariableInfo","","",null,null],[12,"origin","","",255,null],[12,"universe","","",255,null],[3,"RegionSnapshot","","",null,null],[12,"length","","",256,null],[12,"region_snapshot","","",256,null],[3,"TaintDirections","","When working with skolemized regions, we often wish to find all of the regions that are either reachable from a skolemized region, or which can reach a skolemized region, or both. We call such regions tained regions.  This struct allows you to decide what set of tainted regions you want.",null,null],[12,"incoming","","",257,null],[12,"outgoing","","",257,null],[4,"Constraint","","A constraint that influences the inference process.",null,null],[13,"VarSubVar","","One region variable is subregion of another",258,null],[13,"RegSubVar","","Concrete region is subregion of region variable",258,null],[13,"VarSubReg","","Region variable is subregion of concrete region. This does not directly affect inference, but instead is checked after inference is complete.",258,null],[13,"RegSubReg","","A constraint where neither side is a variable. This does not directly affect inference, but instead is checked after inference is complete.",258,null],[4,"GenericKind","","",null,null],[13,"Param","","",259,null],[13,"Projection","","",259,null],[4,"VerifyBound","","When we introduce a verification step, we wish to test that a particular region (let's call it `'min`) meets some bound. The bound is described the by the following grammar:",null,null],[13,"AnyRegion","","B = exists {R} --> some 'r in {R} must outlive 'min",260,null],[13,"AllRegions","","B = forall {R} --> all 'r in {R} must outlive 'min",260,null],[13,"AnyBound","","B = exists {B} --> 'min must meet some bound b in {B}",260,null],[13,"AllBounds","","B = forall {B} --> 'min must meet all bounds b in {B}",260,null],[4,"UndoLogEntry","","",null,null],[13,"OpenSnapshot","","Pushed when we start a snapshot.",261,null],[13,"CommitedSnapshot","","Replaces an `OpenSnapshot` when a snapshot is committed, but that snapshot is not the root. If the root snapshot is unrolled, all nested snapshots must be committed.",261,null],[13,"AddVar","","We added `RegionVid`",261,null],[13,"AddConstraint","","We added the given `constraint`",261,null],[13,"AddVerify","","We added the given `verify`",261,null],[13,"AddGiven","","We added the given `given`",261,null],[13,"AddCombination","","We added a GLB/LUB \"combination variable\"",261,null],[13,"Purged","","During skolemization, we sometimes purge entries from the undo log in a kind of minisnapshot (unlike other snapshots, this purging actually takes place on success). In that case, we replace the corresponding entry with `Noop` so as to avoid the need to do a bunch of swapping. (We can't use `swap_remove` as the order of the vector is important.)",261,null],[4,"CombineMapType","","",null,null],[13,"Lub","","",262,null],[13,"Glb","","",262,null],[0,"taint","","",null,null],[3,"TaintSet","rustc::infer::region_constraints::taint","",null,null],[12,"directions","","",263,null],[12,"regions","","",263,null],[11,"fmt","","",263,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","",263,{"inputs":[{"name":"taintdirections"},{"name":"region"}],"output":{"name":"self"}}],[11,"fixed_point","","",263,null],[11,"into_set","","",263,{"inputs":[{"name":"self"}],"output":{"generics":["region"],"name":"fxhashset"}}],[11,"len","","",263,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"add_edge","","",263,{"inputs":[{"name":"self"},{"name":"region"},{"name":"region"}],"output":null}],[6,"VarInfos","rustc::infer::region_constraints","",null,null],[6,"CombineMap","","",null,null],[11,"fmt","","",252,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"default","","",252,{"inputs":[],"output":{"name":"regionconstraintdata"}}],[11,"clone","","",252,{"inputs":[{"name":"self"}],"output":{"name":"regionconstraintdata"}}],[11,"clone","","",258,{"inputs":[{"name":"self"}],"output":{"name":"constraint"}}],[11,"eq","","",258,{"inputs":[{"name":"self"},{"name":"constraint"}],"output":{"name":"bool"}}],[11,"ne","","",258,{"inputs":[{"name":"self"},{"name":"constraint"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",258,null],[11,"hash","","",258,null],[11,"fmt","","",258,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"partial_cmp","","",258,{"inputs":[{"name":"self"},{"name":"constraint"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",258,{"inputs":[{"name":"self"},{"name":"constraint"}],"output":{"name":"bool"}}],[11,"le","","",258,{"inputs":[{"name":"self"},{"name":"constraint"}],"output":{"name":"bool"}}],[11,"gt","","",258,{"inputs":[{"name":"self"},{"name":"constraint"}],"output":{"name":"bool"}}],[11,"ge","","",258,{"inputs":[{"name":"self"},{"name":"constraint"}],"output":{"name":"bool"}}],[11,"cmp","","",258,{"inputs":[{"name":"self"},{"name":"constraint"}],"output":{"name":"ordering"}}],[11,"fmt","","",253,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",253,{"inputs":[{"name":"self"}],"output":{"name":"verify"}}],[11,"clone","","",259,{"inputs":[{"name":"self"}],"output":{"name":"generickind"}}],[11,"eq","","",259,{"inputs":[{"name":"self"},{"name":"generickind"}],"output":{"name":"bool"}}],[11,"ne","","",259,{"inputs":[{"name":"self"},{"name":"generickind"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",259,null],[11,"fmt","","",260,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",260,{"inputs":[{"name":"self"}],"output":{"name":"verifybound"}}],[11,"clone","","",254,{"inputs":[{"name":"self"}],"output":{"name":"tworegions"}}],[11,"eq","","",254,{"inputs":[{"name":"self"},{"name":"tworegions"}],"output":{"name":"bool"}}],[11,"ne","","",254,{"inputs":[{"name":"self"},{"name":"tworegions"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",254,null],[11,"hash","","",254,null],[11,"clone","","",261,{"inputs":[{"name":"self"}],"output":{"name":"undologentry"}}],[11,"eq","","",261,{"inputs":[{"name":"self"},{"name":"undologentry"}],"output":{"name":"bool"}}],[11,"ne","","",261,{"inputs":[{"name":"self"},{"name":"undologentry"}],"output":{"name":"bool"}}],[11,"clone","","",262,{"inputs":[{"name":"self"}],"output":{"name":"combinemaptype"}}],[11,"eq","","",262,{"inputs":[{"name":"self"},{"name":"combinemaptype"}],"output":{"name":"bool"}}],[11,"fmt","","",255,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",255,{"inputs":[{"name":"self"}],"output":{"name":"regionvariableinfo"}}],[11,"fmt","","",257,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"incoming","","",257,{"inputs":[],"output":{"name":"self"}}],[11,"outgoing","","",257,{"inputs":[],"output":{"name":"self"}}],[11,"both","","",257,{"inputs":[],"output":{"name":"self"}}],[11,"new","","",251,{"inputs":[],"output":{"name":"regionconstraintcollector"}}],[11,"num_region_vars","","",251,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"region_constraint_data","","",251,{"inputs":[{"name":"self"}],"output":{"name":"regionconstraintdata"}}],[11,"into_infos_and_data","","Once all the constraints have been gathered, extract out the final data.",251,null],[11,"take_and_reset_data","","Takes (and clears) the current set of constraints. Note that the set of variables remains intact, but all relationships between them are reset.  This is used during NLL checking to grab the set of constraints that arose from a particular operation.",251,{"inputs":[{"name":"self"}],"output":{"name":"regionconstraintdata"}}],[11,"data","","",251,{"inputs":[{"name":"self"}],"output":{"name":"regionconstraintdata"}}],[11,"in_snapshot","","",251,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"start_snapshot","","",251,{"inputs":[{"name":"self"}],"output":{"name":"regionsnapshot"}}],[11,"commit","","",251,{"inputs":[{"name":"self"},{"name":"regionsnapshot"}],"output":null}],[11,"rollback_to","","",251,{"inputs":[{"name":"self"},{"name":"regionsnapshot"}],"output":null}],[11,"rollback_undo_entry","","",251,{"inputs":[{"name":"self"},{"name":"undologentry"}],"output":null}],[11,"new_region_var","","",251,{"inputs":[{"name":"self"},{"name":"universeindex"},{"name":"regionvariableorigin"}],"output":{"name":"regionvid"}}],[11,"var_universe","","Returns the universe for the given variable.",251,{"inputs":[{"name":"self"},{"name":"regionvid"}],"output":{"name":"universeindex"}}],[11,"var_origin","","Returns the origin for the given variable.",251,{"inputs":[{"name":"self"},{"name":"regionvid"}],"output":{"name":"regionvariableorigin"}}],[11,"pop_skolemized","","Removes all the edges to/from the skolemized regions that are in `skols`. This is used after a higher-ranked operation completes to remove all trace of the skolemized regions created in that time.",251,{"inputs":[{"name":"self"},{"name":"universeindex"},{"name":"fxhashset"},{"name":"regionsnapshot"}],"output":null}],[11,"new_bound","","",251,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"debruijnindex"}],"output":{"name":"region"}}],[11,"add_constraint","","",251,{"inputs":[{"name":"self"},{"name":"constraint"},{"name":"subregionorigin"}],"output":null}],[11,"add_verify","","",251,{"inputs":[{"name":"self"},{"name":"verify"}],"output":null}],[11,"add_given","","",251,{"inputs":[{"name":"self"},{"name":"region"},{"name":"regionvid"}],"output":null}],[11,"make_eqregion","","",251,{"inputs":[{"name":"self"},{"name":"subregionorigin"},{"name":"region"},{"name":"region"}],"output":null}],[11,"make_subregion","","",251,{"inputs":[{"name":"self"},{"name":"subregionorigin"},{"name":"region"},{"name":"region"}],"output":null}],[11,"verify_generic_bound","","See `Verify::VerifyGenericBound`",251,{"inputs":[{"name":"self"},{"name":"subregionorigin"},{"name":"generickind"},{"name":"region"},{"name":"verifybound"}],"output":null}],[11,"lub_regions","","",251,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"subregionorigin"},{"name":"region"},{"name":"region"}],"output":{"name":"region"}}],[11,"glb_regions","","",251,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"subregionorigin"},{"name":"region"},{"name":"region"}],"output":{"name":"region"}}],[11,"opportunistic_resolve_var","","",251,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"regionvid"}],"output":{"name":"region"}}],[11,"combine_map","","",251,{"inputs":[{"name":"self"},{"name":"combinemaptype"}],"output":{"name":"fxhashmap"}}],[11,"combine_vars","","",251,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"combinemaptype"},{"name":"region"},{"name":"region"},{"name":"subregionorigin"}],"output":{"name":"region"}}],[11,"universe","","",251,{"inputs":[{"name":"self"},{"name":"region"}],"output":{"name":"universeindex"}}],[11,"vars_created_since_snapshot","","",251,{"inputs":[{"name":"self"},{"name":"regionsnapshot"}],"output":{"generics":["regionvid"],"name":"vec"}}],[11,"tainted","","Computes all regions that have been related to `r0` since the mark `mark` was made---`r0` itself will be the first entry. The `directions` parameter controls what kind of relations are considered. For example, one can say that only \"incoming\" edges to `r0` are desired, in which case one will get the set of regions `{r|r <= r0}`. This is used when checking whether skolemized regions are being improperly related to other regions.",251,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"regionsnapshot"},{"name":"region"},{"name":"taintdirections"}],"output":{"generics":["region"],"name":"fxhashset"}}],[11,"fmt","","",256,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",259,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",259,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"to_ty","","",259,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"ty"}}],[11,"for_each_region","","",260,{"inputs":[{"name":"self"},{"name":"fnmut"}],"output":null}],[11,"must_hold","","",260,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"cannot_hold","","",260,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"or","","",260,{"inputs":[{"name":"self"},{"name":"verifybound"}],"output":{"name":"verifybound"}}],[11,"and","","",260,{"inputs":[{"name":"self"},{"name":"verifybound"}],"output":{"name":"verifybound"}}],[11,"is_empty","","True if this region constraint data contains no constraints.",252,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[0,"lexical_region_resolve","rustc::infer","The code to do lexical region resolution.",null,null],[3,"LexicalRegionResolutions","rustc::infer::lexical_region_resolve","Contains the result of lexical region resolution. Offers methods to lookup up the final value of a region variable.",null,null],[12,"values","","",264,null],[12,"error_region","","",264,null],[3,"RegionAndOrigin","","",null,null],[12,"region","","",265,null],[12,"origin","","",265,null],[3,"LexicalResolver","","",null,null],[12,"region_rels","","",266,null],[12,"var_infos","","",266,null],[12,"data","","",266,null],[4,"VarValue","","",null,null],[13,"Value","","",267,null],[13,"ErrorValue","","",267,null],[4,"RegionResolutionError","","",null,null],[13,"ConcreteFailure","","`ConcreteFailure(o, a, b)`:",268,null],[13,"GenericBoundFailure","","`GenericBoundFailure(p, s, a)",268,null],[13,"SubSupConflict","","`SubSupConflict(v, sub_origin, sub_r, sup_origin, sup_r)`:",268,null],[5,"resolve","","This function performs lexical region resolution given a complete set of constraints and variable origins. It performs a fixed-point iteration to find region values which satisfy all constraints, assuming such values can be found. It returns the final values of all the variables as well as a set of errors that must be reported.",null,null],[0,"graphviz","","This module provides linkage between libgraphviz traits and `rustc::middle::typeck::infer::region_constraints`, generating a rendering of the graph represented by the list of `Constraint` instances (which make up the edges of the graph), as well as the origin for each constraint (which are attached to the labels on each edge).",null,null],[3,"ConstraintGraph","rustc::infer::lexical_region_resolve::graphviz","",null,null],[12,"graph_name","","",269,null],[12,"region_rels","","",269,null],[12,"map","","",269,null],[12,"node_ids","","",269,null],[4,"Node","","",null,null],[13,"RegionVid","","",270,null],[13,"Region","","",270,null],[4,"Edge","","",null,null],[13,"Constraint","","",271,null],[13,"EnclScope","","",271,null],[5,"print_help_message","","",null,{"inputs":[],"output":null}],[5,"maybe_print_constraints_for","","",null,{"inputs":[{"name":"regionconstraintdata"},{"name":"regionrelations"}],"output":null}],[5,"constraint_to_nodes","","",null,null],[5,"edge_to_nodes","","",null,null],[5,"dump_region_data_to","","",null,{"inputs":[{"name":"regionrelations"},{"name":"btreemap"},{"name":"str"}],"output":{"name":"result"}}],[6,"ConstraintMap","","",null,null],[11,"clone","","",270,{"inputs":[{"name":"self"}],"output":{"name":"node"}}],[11,"hash","","",270,null],[11,"eq","","",270,{"inputs":[{"name":"self"},{"name":"node"}],"output":{"name":"bool"}}],[11,"ne","","",270,{"inputs":[{"name":"self"},{"name":"node"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",270,null],[11,"fmt","","",270,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",271,{"inputs":[{"name":"self"}],"output":{"name":"edge"}}],[11,"eq","","",271,{"inputs":[{"name":"self"},{"name":"edge"}],"output":{"name":"bool"}}],[11,"ne","","",271,{"inputs":[{"name":"self"},{"name":"edge"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",271,null],[11,"fmt","","",271,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","",269,{"inputs":[{"name":"string"},{"name":"regionrelations"},{"name":"btreemap"}],"output":{"name":"constraintgraph"}}],[11,"graph_id","","",269,{"inputs":[{"name":"self"}],"output":{"name":"id"}}],[11,"node_id","","",269,{"inputs":[{"name":"self"},{"name":"node"}],"output":{"name":"id"}}],[11,"node_label","","",269,{"inputs":[{"name":"self"},{"name":"node"}],"output":{"name":"labeltext"}}],[11,"edge_label","","",269,{"inputs":[{"name":"self"},{"name":"edge"}],"output":{"name":"labeltext"}}],[11,"nodes","","",269,{"inputs":[{"name":"self"}],"output":{"generics":["node"],"name":"nodes"}}],[11,"edges","","",269,{"inputs":[{"name":"self"}],"output":{"generics":["edge"],"name":"edges"}}],[11,"source","","",269,{"inputs":[{"name":"self"},{"name":"edge"}],"output":{"name":"node"}}],[11,"target","","",269,{"inputs":[{"name":"self"},{"name":"edge"}],"output":{"name":"node"}}],[6,"RegionGraph","rustc::infer::lexical_region_resolve","",null,null],[11,"clone","","",267,{"inputs":[{"name":"self"}],"output":{"name":"varvalue"}}],[11,"fmt","","",267,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",268,{"inputs":[{"name":"self"}],"output":{"name":"regionresolutionerror"}}],[11,"fmt","","",268,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"infer_variable_values","","",266,{"inputs":[{"name":"self"},{"name":"vec"}],"output":{"name":"lexicalregionresolutions"}}],[11,"num_vars","","",266,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"construct_var_data","","Initially, the value for all variables is set to `'empty`, the empty region. The `expansion` phase will grow this larger.",266,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"lexicalregionresolutions"}}],[11,"dump_constraints","","",266,{"inputs":[{"name":"self"},{"name":"regionrelations"}],"output":null}],[11,"expand_givens","","",266,{"inputs":[{"name":"self"},{"name":"graph"}],"output":null}],[11,"expansion","","",266,{"inputs":[{"name":"self"},{"name":"lexicalregionresolutions"}],"output":null}],[11,"expand_node","","",266,{"inputs":[{"name":"self"},{"name":"region"},{"name":"regionvid"},{"name":"varvalue"}],"output":{"name":"bool"}}],[11,"lub_concrete_regions","","",266,{"inputs":[{"name":"self"},{"name":"region"},{"name":"region"}],"output":{"name":"region"}}],[11,"collect_errors","","After expansion is complete, go and check upper bounds (i.e., cases where the region cannot grow larger than a fixed point) and check that they are satisfied.",266,{"inputs":[{"name":"self"},{"name":"lexicalregionresolutions"},{"name":"vec"}],"output":null}],[11,"collect_var_errors","","Go over the variables that were declared to be error variables and create a `RegionResolutionError` for each of them.",266,{"inputs":[{"name":"self"},{"name":"lexicalregionresolutions"},{"name":"graph"},{"name":"vec"}],"output":null}],[11,"construct_graph","","",266,{"inputs":[{"name":"self"}],"output":{"generics":["constraint"],"name":"graph"}}],[11,"collect_error_for_expanding_node","","",266,null],[11,"collect_concrete_regions","","",266,null],[11,"iterate_until_fixed_point","","",266,{"inputs":[{"name":"self"},{"name":"str"},{"name":"f"}],"output":null}],[11,"bound_is_met","","",266,{"inputs":[{"name":"self"},{"name":"verifybound"},{"name":"lexicalregionresolutions"},{"name":"region"}],"output":{"name":"bool"}}],[11,"fmt","","",265,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"normalize","","",264,{"inputs":[{"name":"self"},{"name":"region"}],"output":{"name":"region"}}],[11,"value","","",264,{"inputs":[{"name":"self"},{"name":"regionvid"}],"output":{"name":"varvalue"}}],[11,"value_mut","","",264,{"inputs":[{"name":"self"},{"name":"regionvid"}],"output":{"name":"varvalue"}}],[11,"resolve_var","","",264,{"inputs":[{"name":"self"},{"name":"regionvid"}],"output":{"name":"region"}}],[0,"outlives","rustc::infer","Various code related to computing outlives relations.",null,null],[0,"env","rustc::infer::outlives","",null,null],[3,"OutlivesEnvironment","rustc::infer::outlives::env","The `OutlivesEnvironment` collects information about what outlives what in a given type-checking setting. For example, if we have a where-clause like `where T: 'a` in scope, then the `OutlivesEnvironment` would record that (in its `region_bound_pairs` field). Similarly, it contains methods for processing and adding implied bounds into the outlives environment.",null,null],[12,"param_env","","",272,null],[12,"free_region_map","","",272,null],[12,"region_bound_pairs","","",272,null],[11,"clone","","",272,{"inputs":[{"name":"self"}],"output":{"name":"outlivesenvironment"}}],[11,"new","","",272,{"inputs":[{"name":"paramenv"}],"output":{"name":"self"}}],[11,"free_region_map","","Borrows current value of the `free_region_map`.",272,{"inputs":[{"name":"self"}],"output":{"name":"freeregionmap"}}],[11,"region_bound_pairs","","Borrows current value of the `region_bound_pairs`.",272,null],[11,"into_free_region_map","","Returns ownership of the `free_region_map`.",272,{"inputs":[{"name":"self"}],"output":{"name":"freeregionmap"}}],[11,"push_snapshot_pre_closure","","This is a hack to support the old-skool regionck, which processes region constraints from the main function and the closure together. In that context, when we enter a closure, we want to be able to \"save\" the state of the surrounding a function. We can then add implied bounds and the like from the closure arguments into the environment -- these should only apply in the closure body, so once we exit, we invoke `pop_snapshot_post_closure` to remove them.",272,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"pop_snapshot_post_closure","","See `push_snapshot_pre_closure`.",272,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"add_implied_bounds","","This method adds \"implied bounds\" into the outlives environment. Implied bounds are outlives relationships that we can deduce on the basis that certain types must be well-formed -- these are either the types that appear in the function signature or else the input types to an impl. For example, if you have a function like",272,null],[11,"add_outlives_bounds","","Processes outlives bounds that are known to hold, whether from implied or other sources.",272,{"inputs":[{"name":"self"},{"generics":["inferctxt"],"name":"option"},{"name":"i"}],"output":null}],[0,"free_region_map","rustc::infer::outlives","",null,null],[3,"FreeRegionMap","rustc::infer::outlives::free_region_map","",null,null],[12,"relation","","",273,null],[5,"is_free","","",null,{"inputs":[{"name":"region"}],"output":{"name":"bool"}}],[5,"is_free_or_static","","",null,{"inputs":[{"name":"region"}],"output":{"name":"bool"}}],[8,"FreeRegionRelations","","The NLL region handling code represents free region relations in a slightly different way; this trait allows functions to be abstract over which version is in use.",null,null],[10,"sub_free_regions","","Tests whether `r_a <= r_b`. Both must be free regions or `'static`.",274,{"inputs":[{"name":"self"},{"name":"region"},{"name":"region"}],"output":{"name":"bool"}}],[11,"clone","","",273,{"inputs":[{"name":"self"}],"output":{"name":"freeregionmap"}}],[11,"encode","","",273,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",273,{"inputs":[{"name":"__d"}],"output":{"generics":["freeregionmap"],"name":"result"}}],[11,"fmt","","",273,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","",273,{"inputs":[],"output":{"name":"self"}}],[11,"is_empty","","",273,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"relate_regions","","",273,{"inputs":[{"name":"self"},{"name":"region"},{"name":"region"}],"output":null}],[11,"lub_free_regions","","Compute the least-upper-bound of two free regions. In some cases, this is more conservative than necessary, in order to avoid making arbitrary choices. See `TransitiveRelation::postdom_upper_bound` for more details.",273,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"region"},{"name":"region"}],"output":{"name":"region"}}],[11,"sub_free_regions","","",273,{"inputs":[{"name":"self"},{"name":"region"},{"name":"region"}],"output":{"name":"bool"}}],[11,"hash_stable","","",273,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"lift_to_tcx","","",273,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"generics":["freeregionmap"],"name":"option"}}],[0,"bounds","rustc::infer::outlives","",null,null],[4,"OutlivesBound","rustc::infer::outlives::bounds","Outlives bounds are relationships between generic parameters, whether they both be regions (`'a: 'b`) or whether types are involved (`T: 'a`).  These relationships can be extracted from the full set of predicates we understand or also from types (in which case they are called implied bounds). They are fed to the `OutlivesEnv` which in turn is supplied to the region checker and other parts of the inference system.",null,null],[13,"RegionSubRegion","","",275,null],[13,"RegionSubParam","","",275,null],[13,"RegionSubProjection","","",275,null],[5,"explicit_outlives_bounds","","",null,null],[11,"fmt","","",275,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"implied_outlives_bounds","rustc::infer","Implied bounds are region relationships that we deduce automatically.  The idea is that (e.g.) a caller must check that a function's argument types are well-formed immediately before calling that fn, and hence the callee can assume that its argument types are well-formed. This may imply certain relationships between generic parameters. For example:",203,{"inputs":[{"name":"self"},{"name":"paramenv"},{"name":"nodeid"},{"name":"ty"},{"name":"span"}],"output":{"generics":["outlivesbound"],"name":"vec"}}],[11,"implied_bounds_from_components","","When we have an implied bound that `T: 'a`, we can further break this down to determine what relationships would have to hold for `T: 'a` to hold. We get to assume that the caller has validated those relationships.",203,{"inputs":[{"name":"region"},{"generics":["component"],"name":"vec"}],"output":{"generics":["outlivesbound"],"name":"vec"}}],[0,"obligations","rustc::infer::outlives","Code that handles \"type-outlives\" constraints like `T: 'a`. This is based on the `outlives_components` function defined on the tcx, but it adds a bit of heuristics on top, in particular to deal with associated types and projections.",null,null],[3,"TypeOutlives","rustc::infer::outlives::obligations","",null,null],[12,"infcx","","",276,null],[12,"region_bound_pairs","","",276,null],[12,"implicit_region_bound","","",276,null],[12,"param_env","","",276,null],[11,"register_region_obligation","rustc::infer","Registers that the given region obligation must be resolved from within the scope of `body_id`. These regions are enqueued and later processed by regionck, when full type information is available (see `region_obligations` field for more information).",203,{"inputs":[{"name":"self"},{"name":"nodeid"},{"name":"regionobligation"}],"output":null}],[11,"take_registered_region_obligations","","Trait queries just want to pass back type obligations \"as is\"",203,{"inputs":[{"name":"self"}],"output":{"name":"vec"}}],[11,"process_registered_region_obligations","","Process the region obligations that must be proven (during `regionck`) for the given `body_id`, given information about the region bounds in scope and so forth. This function must be invoked for all relevant body-ids before region inference is done (or else an assert will fire).",203,null],[11,"type_must_outlive","","Processes a single ad-hoc region obligation that was not registered in advance.",203,null],[11,"new","rustc::infer::outlives::obligations","",276,null],[11,"type_must_outlive","","Adds constraints to inference such that `T: 'a` holds (or reports an error if it cannot).",276,{"inputs":[{"name":"self"},{"name":"subregionorigin"},{"name":"ty"},{"name":"region"}],"output":null}],[11,"tcx","","",276,{"inputs":[{"name":"self"}],"output":{"name":"tyctxt"}}],[11,"components_must_outlive","","",276,{"inputs":[{"name":"self"},{"name":"subregionorigin"},{"generics":["component"],"name":"vec"},{"name":"region"}],"output":null}],[11,"param_ty_must_outlive","","",276,{"inputs":[{"name":"self"},{"name":"subregionorigin"},{"name":"region"},{"name":"paramty"}],"output":null}],[11,"projection_must_outlive","","",276,{"inputs":[{"name":"self"},{"name":"subregionorigin"},{"name":"region"},{"name":"projectionty"}],"output":null}],[11,"type_bound","","",276,{"inputs":[{"name":"self"},{"name":"ty"}],"output":{"name":"verifybound"}}],[11,"param_bound","","",276,{"inputs":[{"name":"self"},{"name":"paramty"}],"output":{"name":"verifybound"}}],[11,"projection_declared_bounds","","",276,{"inputs":[{"name":"self"},{"name":"projectionty"}],"output":{"generics":["region"],"name":"vec"}}],[11,"projection_bound","","",276,{"inputs":[{"name":"self"},{"generics":["region"],"name":"vec"},{"name":"projectionty"}],"output":{"name":"verifybound"}}],[11,"recursive_type_bound","","",276,{"inputs":[{"name":"self"},{"name":"ty"}],"output":{"name":"verifybound"}}],[11,"declared_generic_bounds_from_env","","",276,{"inputs":[{"name":"self"},{"name":"generickind"}],"output":{"generics":["region"],"name":"vec"}}],[11,"declared_projection_bounds_from_trait","","Given a projection like `<T as Foo<'x>>::Bar`, returns any bounds declared in the trait definition. For example, if the trait were",276,{"inputs":[{"name":"self"},{"name":"projectionty"}],"output":{"generics":["region"],"name":"vec"}}],[11,"region_bounds_declared_on_associated_item","","Given the def-id of an associated item, returns any region bounds attached to that associated item from the trait definition.",276,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["region"],"name":"vec"}}],[11,"collect_outlives_from_predicate_list","","Searches through a predicate list for a predicate `T: 'a`.",276,{"inputs":[{"name":"self"},{"name":"ty"},{"name":"i"}],"output":{"generics":["region"],"name":"vec"}}],[0,"resolve","rustc::infer","",null,null],[3,"OpportunisticTypeResolver","rustc::infer::resolve","The opportunistic type resolver can be used at any time. It simply replaces type variables that have been unified with the things they have been unified with (similar to `shallow_resolve`, but deep). This is useful for printing messages etc but also required at various points for correctness.",null,null],[12,"infcx","","",277,null],[3,"OpportunisticTypeAndRegionResolver","","The opportunistic type and region resolver is similar to the opportunistic type resolver, but also opportunistically resolves regions. It is useful for canonicalization.",null,null],[12,"infcx","","",278,null],[3,"UnresolvedTypeFinder","","The unresolved type finder walks your type and searches for type variables that don't yet have a value. They get pushed into a vector. It does not construct the fully resolved type (which might involve some hashing and so forth).",null,null],[12,"infcx","","",279,null],[3,"FullTypeResolver","","",null,null],[12,"infcx","","",280,null],[12,"err","","",280,null],[5,"fully_resolve","","Full type resolution replaces all type and region variables with their concrete results. If any variable cannot be replaced (never unified, etc) then an `Err` result is returned.",null,{"inputs":[{"name":"inferctxt"},{"name":"t"}],"output":{"name":"fixupresult"}}],[11,"new","","",277,{"inputs":[{"name":"inferctxt"}],"output":{"name":"self"}}],[11,"tcx","","",277,{"inputs":[{"name":"self"}],"output":{"name":"tyctxt"}}],[11,"fold_ty","","",277,{"inputs":[{"name":"self"},{"name":"ty"}],"output":{"name":"ty"}}],[11,"new","","",278,{"inputs":[{"name":"inferctxt"}],"output":{"name":"self"}}],[11,"tcx","","",278,{"inputs":[{"name":"self"}],"output":{"name":"tyctxt"}}],[11,"fold_ty","","",278,{"inputs":[{"name":"self"},{"name":"ty"}],"output":{"name":"ty"}}],[11,"fold_region","","",278,{"inputs":[{"name":"self"},{"name":"region"}],"output":{"name":"region"}}],[11,"new","","",279,{"inputs":[{"name":"inferctxt"}],"output":{"name":"self"}}],[11,"visit_ty","","",279,{"inputs":[{"name":"self"},{"name":"ty"}],"output":{"name":"bool"}}],[11,"tcx","","",280,{"inputs":[{"name":"self"}],"output":{"name":"tyctxt"}}],[11,"fold_ty","","",280,{"inputs":[{"name":"self"},{"name":"ty"}],"output":{"name":"ty"}}],[11,"fold_region","","",280,{"inputs":[{"name":"self"},{"name":"region"}],"output":{"name":"region"}}],[0,"freshen","rustc::infer","Freshening is the process of replacing unknown variables with fresh types. The idea is that the type, after freshening, contains no inference variables but instead contains either a value for each variable or fresh \"arbitrary\" types wherever a variable would have been.",null,null],[3,"TypeFreshener","rustc::infer::freshen","",null,null],[12,"infcx","","",201,null],[12,"freshen_count","","",201,null],[12,"freshen_map","","",201,null],[11,"new","rustc::infer","",201,{"inputs":[{"name":"inferctxt"}],"output":{"name":"typefreshener"}}],[11,"freshen","","",201,{"inputs":[{"name":"self"},{"generics":["ty"],"name":"option"},{"name":"inferty"},{"name":"f"}],"output":{"name":"ty"}}],[11,"tcx","","",201,{"inputs":[{"name":"self"}],"output":{"name":"tyctxt"}}],[11,"fold_region","","",201,{"inputs":[{"name":"self"},{"name":"region"}],"output":{"name":"region"}}],[11,"fold_ty","","",201,{"inputs":[{"name":"self"},{"name":"ty"}],"output":{"name":"ty"}}],[0,"sub","","",null,null],[3,"Sub","rustc::infer::sub","Ensures `a` is made a subtype of `b`. Returns `a` on success.",null,null],[12,"fields","","",281,null],[12,"a_is_expected","","",281,null],[11,"new","","",281,{"inputs":[{"name":"combinefields"},{"name":"bool"}],"output":{"name":"sub"}}],[11,"with_expected_switched","","",281,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"r"}}],[11,"tag","","",281,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"tcx","","",281,{"inputs":[{"name":"self"}],"output":{"name":"tyctxt"}}],[11,"a_is_expected","","",281,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"with_cause","","",281,{"inputs":[{"name":"self"},{"name":"cause"},{"name":"f"}],"output":{"name":"r"}}],[11,"relate_with_variance","","",281,{"inputs":[{"name":"self"},{"name":"variance"},{"name":"t"},{"name":"t"}],"output":{"name":"relateresult"}}],[11,"tys","","",281,{"inputs":[{"name":"self"},{"name":"ty"},{"name":"ty"}],"output":{"generics":["ty"],"name":"relateresult"}}],[11,"regions","","",281,{"inputs":[{"name":"self"},{"name":"region"},{"name":"region"}],"output":{"generics":["region"],"name":"relateresult"}}],[11,"binders","","",281,{"inputs":[{"name":"self"},{"name":"binder"},{"name":"binder"}],"output":{"generics":["binder"],"name":"relateresult"}}],[0,"type_variable","rustc::infer","",null,null],[3,"TypeVariableTable","rustc::infer::type_variable","",null,null],[12,"values","","",282,null],[12,"eq_relations","","Two variables are unified in `eq_relations` when we have a constraint `?X == ?Y`. This table also stores, for each key, the known value.",282,null],[12,"sub_relations","","Two variables are unified in `eq_relations` when we have a constraint `?X <: ?Y` or a constraint `?Y <: ?X`. This second table exists only to help with the occurs check. In particular, we want to report constraints like these as an occurs check violation:",282,null],[3,"TypeVariableData","","",null,null],[12,"origin","","",283,null],[12,"diverging","","",283,null],[3,"Snapshot","","",null,null],[12,"snapshot","","",284,null],[12,"eq_snapshot","","",284,null],[12,"sub_snapshot","","",284,null],[3,"Instantiate","","",null,null],[12,"vid","","",285,null],[3,"Delegate","","",null,null],[3,"TyVidEqKey","","These structs (a newtyped TyVid) are used as the unification key for the `eq_relations`; they carry a `TypeVariableValue` along with them.",null,null],[12,"vid","","",286,null],[12,"phantom","","",286,null],[4,"TypeVariableOrigin","","Reasons to create a type inference variable",null,null],[13,"MiscVariable","","",287,null],[13,"NormalizeProjectionType","","",287,null],[13,"TypeInference","","",287,null],[13,"TypeParameterDefinition","","",287,null],[13,"ClosureSynthetic","","one of the upvars or closure kind parameters in a `ClosureSubsts` (before it has been determined)",287,null],[13,"SubstitutionPlaceholder","","",287,null],[13,"AutoDeref","","",287,null],[13,"AdjustmentType","","",287,null],[13,"DivergingStmt","","",287,null],[13,"DivergingBlockExpr","","",287,null],[13,"DivergingFn","","",287,null],[13,"LatticeVariable","","",287,null],[13,"Generalized","","",287,null],[4,"TypeVariableValue","","",null,null],[13,"Known","","",288,null],[12,"value","rustc::infer::type_variable::TypeVariableValue","",288,null],[13,"Unknown","rustc::infer::type_variable","",288,null],[12,"universe","rustc::infer::type_variable::TypeVariableValue","",288,null],[6,"TypeVariableMap","rustc::infer::type_variable","",null,null],[11,"clone","","",287,{"inputs":[{"name":"self"}],"output":{"name":"typevariableorigin"}}],[11,"fmt","","",287,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",288,{"inputs":[{"name":"self"}],"output":{"name":"typevariablevalue"}}],[11,"fmt","","",288,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"known","","If this value is known, returns the type it is known to be. Otherwise, `None`.",288,{"inputs":[{"name":"self"}],"output":{"generics":["ty"],"name":"option"}}],[11,"is_unknown","","",288,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"new","","",282,{"inputs":[],"output":{"name":"typevariabletable"}}],[11,"var_diverges","","Returns the diverges flag given when `vid` was created.",282,{"inputs":[{"name":"self"},{"name":"tyvid"}],"output":{"name":"bool"}}],[11,"var_origin","","Returns the origin that was given when `vid` was created.",282,{"inputs":[{"name":"self"},{"name":"tyvid"}],"output":{"name":"typevariableorigin"}}],[11,"equate","","Records that `a == b`, depending on `dir`.",282,{"inputs":[{"name":"self"},{"name":"tyvid"},{"name":"tyvid"}],"output":null}],[11,"sub","","Records that `a <: b`, depending on `dir`.",282,{"inputs":[{"name":"self"},{"name":"tyvid"},{"name":"tyvid"}],"output":null}],[11,"instantiate","","Instantiates `vid` with the type `ty`.",282,{"inputs":[{"name":"self"},{"name":"tyvid"},{"name":"ty"}],"output":null}],[11,"new_var","","Creates a new type variable.",282,{"inputs":[{"name":"self"},{"name":"universeindex"},{"name":"bool"},{"name":"typevariableorigin"}],"output":{"name":"tyvid"}}],[11,"num_vars","","Returns the number of type variables created thus far.",282,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"root_var","","Returns the \"root\" variable of `vid` in the `eq_relations` equivalence table. All type variables that have been equated will yield the same root variable (per the union-find algorithm), so `root_var(a) == root_var(b)` implies that `a == b` (transitively).",282,{"inputs":[{"name":"self"},{"name":"tyvid"}],"output":{"name":"tyvid"}}],[11,"sub_root_var","","Returns the \"root\" variable of `vid` in the `sub_relations` equivalence table. All type variables that have been are related via equality or subtyping will yield the same root variable (per the union-find algorithm), so `sub_root_var(a) == sub_root_var(b)` implies that:",282,{"inputs":[{"name":"self"},{"name":"tyvid"}],"output":{"name":"tyvid"}}],[11,"sub_unified","","True if `a` and `b` have same \"sub-root\" (i.e., exists some type X such that `forall i in {a, b}. (i <: X || X <: i)`.",282,{"inputs":[{"name":"self"},{"name":"tyvid"},{"name":"tyvid"}],"output":{"name":"bool"}}],[11,"probe","","Retrieves the type to which `vid` has been instantiated, if any.",282,{"inputs":[{"name":"self"},{"name":"tyvid"}],"output":{"name":"typevariablevalue"}}],[11,"replace_if_possible","","If `t` is a type-inference variable, and it has been instantiated, then return the with which it was instantiated. Otherwise, returns `t`.",282,{"inputs":[{"name":"self"},{"name":"ty"}],"output":{"name":"ty"}}],[11,"snapshot","","Creates a snapshot of the type variable state.  This snapshot must later be committed (`commit()`) or rolled back (`rollback_to()`).  Nested snapshots are permitted, but must be processed in a stack-like fashion.",282,{"inputs":[{"name":"self"}],"output":{"name":"snapshot"}}],[11,"rollback_to","","Undoes all changes since the snapshot was created. Any snapshots created since that point must already have been committed or rolled back.",282,{"inputs":[{"name":"self"},{"name":"snapshot"}],"output":null}],[11,"commit","","Commits all changes since the snapshot was created, making them permanent (unless this snapshot was created within another snapshot). Any snapshots created since that point must already have been committed or rolled back.",282,{"inputs":[{"name":"self"},{"name":"snapshot"}],"output":null}],[11,"types_created_since_snapshot","","Returns a map `{V1 -> V2}`, where the keys `{V1}` are ty-variables created during the snapshot, and the values `{V2}` are the root variables that they were unified with, along with their origin.",282,{"inputs":[{"name":"self"},{"name":"snapshot"}],"output":{"name":"typevariablemap"}}],[11,"types_escaping_snapshot","","Find the set of type variables that existed before `s` but which have only been unified since `s` started, and return the types with which they were unified. So if we had a type variable `V0`, then we started the snapshot, then we created a type variable `V1`, unifed `V0` with `T0`, and unified `V1` with `T1`, this function would return `{T0}`.",282,{"inputs":[{"name":"self"},{"name":"snapshot"}],"output":{"generics":["ty"],"name":"vec"}}],[11,"unsolved_variables","","Returns indices of all variables that are not yet instantiated.",282,{"inputs":[{"name":"self"}],"output":{"generics":["tyvid"],"name":"vec"}}],[11,"reverse","","",289,{"inputs":[{"name":"vec"},{"name":"instantiate"}],"output":null}],[11,"clone","","",286,{"inputs":[{"name":"self"}],"output":{"name":"tyvideqkey"}}],[11,"fmt","","",286,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",286,{"inputs":[{"name":"self"},{"name":"tyvideqkey"}],"output":{"name":"bool"}}],[11,"ne","","",286,{"inputs":[{"name":"self"},{"name":"tyvideqkey"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",286,null],[11,"from","","",286,{"inputs":[{"name":"tyvid"}],"output":{"name":"self"}}],[11,"index","","",286,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"from_index","","",286,{"inputs":[{"name":"u32"}],"output":{"name":"self"}}],[11,"tag","","",286,{"inputs":[],"output":{"name":"str"}}],[11,"unify_values","","",288,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"generics":["noerror"],"name":"result"}}],[0,"unify_key","rustc::infer","",null,null],[3,"RegionVidKey","rustc::infer::unify_key","",null,null],[12,"min_vid","","The minimum region vid in the unification set. This is needed to have a canonical name for a type to prevent infinite recursion.",290,null],[8,"ToType","","",null,null],[10,"to_type","","",291,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"ty"}}],[11,"eq","","",290,{"inputs":[{"name":"self"},{"name":"regionvidkey"}],"output":{"name":"bool"}}],[11,"ne","","",290,{"inputs":[{"name":"self"},{"name":"regionvidkey"}],"output":{"name":"bool"}}],[11,"clone","","",290,{"inputs":[{"name":"self"}],"output":{"name":"regionvidkey"}}],[11,"fmt","","",290,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"unify_values","","",290,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"generics":["noerror"],"name":"result"}}],[6,"InferResult","rustc::infer","",null,null],[6,"Bound","","",null,null],[6,"UnitResult","","",null,null],[6,"FixupResult","","",null,null],[6,"SkolemizationMap","","A map returned by `skolemize_late_bound_regions()` indicating the skolemized region that each late-bound region was replaced with.",null,null],[11,"fmt","","",202,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",208,{"inputs":[{"name":"self"}],"output":{"name":"valuepairs"}}],[11,"fmt","","",208,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",204,{"inputs":[{"name":"self"}],"output":{"name":"typetrace"}}],[11,"clone","","",209,{"inputs":[{"name":"self"}],"output":{"name":"subregionorigin"}}],[11,"fmt","","",209,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",210,{"inputs":[{"name":"self"}],"output":{"name":"parameterorigin"}}],[11,"fmt","","",210,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",211,{"inputs":[{"name":"self"}],"output":{"name":"lateboundregionconversiontime"}}],[11,"fmt","","",211,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",212,{"inputs":[{"name":"self"}],"output":{"name":"regionvariableorigin"}}],[11,"fmt","","",212,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",213,{"inputs":[{"name":"self"}],"output":{"name":"nllregionvariableorigin"}}],[11,"fmt","","",213,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",213,{"inputs":[{"name":"self"},{"name":"nllregionvariableorigin"}],"output":{"name":"bool"}}],[11,"ne","","",213,{"inputs":[{"name":"self"},{"name":"nllregionvariableorigin"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",213,null],[11,"hash","","",213,null],[11,"clone","","",214,{"inputs":[{"name":"self"}],"output":{"name":"fixuperror"}}],[11,"fmt","","",214,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",205,{"inputs":[{"name":"self"}],"output":{"name":"regionobligation"}}],[11,"fmt","","",214,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"with_fresh_in_progress_tables","","Used only by `rustc_typeck` during body type-checking/inference, will initialize `in_progress_tables` with fresh `TypeckTables`.",206,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"self"}}],[11,"enter","","",206,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"r"}}],[11,"unit","","",202,{"inputs":[{"name":"self"}],"output":{"name":"inferok"}}],[11,"into_obligations","","",202,{"inputs":[{"name":"self"}],"output":{"name":"predicateobligations"}}],[11,"is_in_snapshot","","",203,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"freshen","","",203,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"t"}}],[11,"type_var_diverges","","",203,{"inputs":[{"name":"self"},{"name":"ty"}],"output":{"name":"bool"}}],[11,"freshener","","",203,{"inputs":[{"name":"self"}],"output":{"name":"typefreshener"}}],[11,"type_is_unconstrained_numeric","","",203,{"inputs":[{"name":"self"},{"name":"ty"}],"output":{"name":"unconstrainednumeric"}}],[11,"unsolved_variables","","",203,{"inputs":[{"name":"self"}],"output":{"generics":["ty"],"name":"vec"}}],[11,"combine_fields","","",203,{"inputs":[{"name":"self"},{"name":"typetrace"},{"name":"paramenv"}],"output":{"name":"combinefields"}}],[11,"save_and_restore_in_snapshot_flag","","",203,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"r"}}],[11,"start_snapshot","","",203,{"inputs":[{"name":"self"}],"output":{"name":"combinedsnapshot"}}],[11,"rollback_to","","",203,{"inputs":[{"name":"self"},{"name":"str"},{"name":"combinedsnapshot"}],"output":null}],[11,"commit_from","","",203,{"inputs":[{"name":"self"},{"name":"combinedsnapshot"}],"output":null}],[11,"commit_unconditionally","","Execute `f` and commit the bindings",203,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"r"}}],[11,"commit_if_ok","","Execute `f` and commit the bindings if closure `f` returns `Ok(_)`",203,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"result"}}],[11,"in_snapshot","","",203,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"t"}}],[11,"probe","","Execute `f` then unroll any bindings it creates",203,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"r"}}],[11,"add_given","","",203,{"inputs":[{"name":"self"},{"name":"region"},{"name":"regionvid"}],"output":null}],[11,"can_sub","","",203,{"inputs":[{"name":"self"},{"name":"paramenv"},{"name":"t"},{"name":"t"}],"output":{"name":"unitresult"}}],[11,"can_eq","","",203,{"inputs":[{"name":"self"},{"name":"paramenv"},{"name":"t"},{"name":"t"}],"output":{"name":"unitresult"}}],[11,"sub_regions","","",203,{"inputs":[{"name":"self"},{"name":"subregionorigin"},{"name":"region"},{"name":"region"}],"output":null}],[11,"subtype_predicate","","",203,{"inputs":[{"name":"self"},{"name":"obligationcause"},{"name":"paramenv"},{"name":"polysubtypepredicate"}],"output":{"generics":["inferresult"],"name":"option"}}],[11,"region_outlives_predicate","","",203,{"inputs":[{"name":"self"},{"name":"obligationcause"},{"name":"polyregionoutlivespredicate"}],"output":{"name":"unitresult"}}],[11,"next_ty_var_id","","",203,{"inputs":[{"name":"self"},{"name":"bool"},{"name":"typevariableorigin"}],"output":{"name":"tyvid"}}],[11,"next_ty_var","","",203,{"inputs":[{"name":"self"},{"name":"typevariableorigin"}],"output":{"name":"ty"}}],[11,"next_diverging_ty_var","","",203,{"inputs":[{"name":"self"},{"name":"typevariableorigin"}],"output":{"name":"ty"}}],[11,"next_int_var_id","","",203,{"inputs":[{"name":"self"}],"output":{"name":"intvid"}}],[11,"next_float_var_id","","",203,{"inputs":[{"name":"self"}],"output":{"name":"floatvid"}}],[11,"next_region_var","","Create a fresh region variable with the next available index.",203,{"inputs":[{"name":"self"},{"name":"regionvariableorigin"}],"output":{"name":"region"}}],[11,"num_region_vars","","Number of region variables created so far.",203,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"next_nll_region_var","","Just a convenient wrapper of `next_region_var` for using during NLL.",203,{"inputs":[{"name":"self"},{"name":"nllregionvariableorigin"}],"output":{"name":"region"}}],[11,"region_var_for_def","","Create a region inference variable for the given region parameter definition.",203,{"inputs":[{"name":"self"},{"name":"span"},{"name":"regionparameterdef"}],"output":{"name":"region"}}],[11,"type_var_for_def","","Create a type inference variable for the given type parameter definition. The substitutions are for actual parameters that may be referred to by the default of this type parameter, if it exists. E.g. `struct Foo<A, B, C = (A, B)>(...);` when used in a path such as `Foo::<T, U>::new()` will use an inference variable for `C` with `[T, U]` as the substitutions for the default, `(T, U)`.",203,{"inputs":[{"name":"self"},{"name":"span"},{"name":"typeparameterdef"}],"output":{"name":"ty"}}],[11,"fresh_substs_for_item","","Given a set of generics defined on a type or impl, returns a substitution mapping each type/region parameter to a fresh inference variable.",203,{"inputs":[{"name":"self"},{"name":"span"},{"name":"defid"}],"output":{"name":"substs"}}],[11,"is_tainted_by_errors","","True if errors have been reported since this infcx was created.  This is sometimes used as a heuristic to skip reporting errors that often occur as a result of earlier errors, but where it's hard to be 100% sure (e.g., unresolved inference variables, regionck errors).",203,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"set_tainted_by_errors","","Set the \"tainted by errors\" flag to true. We call this when we observe an error from a prior pass.",203,{"inputs":[{"name":"self"}],"output":null}],[11,"resolve_regions_and_report_errors","","Process the region constraints and report any errors that result. After this, no more unification operations should be done -- or the compiler will panic -- but it is legal to use `resolve_type_vars_if_possible` as well as `fully_resolve`.",203,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"scopetree"},{"name":"outlivesenvironment"}],"output":null}],[11,"resolve_regions_and_report_errors_unless_nll","","Like `resolve_regions_and_report_errors`, but skips error reporting if NLL is enabled.  This is used for fn bodies where the same error may later be reported by the NLL-based inference.",203,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"scopetree"},{"name":"outlivesenvironment"}],"output":null}],[11,"resolve_regions_and_report_errors_inner","","",203,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"scopetree"},{"name":"outlivesenvironment"},{"name":"bool"}],"output":null}],[11,"take_and_reset_region_constraints","","Obtains (and clears) the current set of region constraints. The inference context is still usable: further unifications will simply add new constraints.",203,{"inputs":[{"name":"self"}],"output":{"name":"regionconstraintdata"}}],[11,"with_region_constraints","","Gives temporary access to the region constraint data.",203,null],[11,"take_region_var_origins","","Takes ownership of the list of variable regions. This implies that all the region constriants have already been taken, and hence that `resolve_regions_and_report_errors` can never be called. This is used only during NLL processing to \"hand off\" ownership of the set of region vairables into the NLL region context.",203,{"inputs":[{"name":"self"}],"output":{"name":"varinfos"}}],[11,"ty_to_string","","",203,{"inputs":[{"name":"self"},{"name":"ty"}],"output":{"name":"string"}}],[11,"tys_to_string","","",203,null],[11,"trait_ref_to_string","","",203,{"inputs":[{"name":"self"},{"name":"traitref"}],"output":{"name":"string"}}],[11,"shallow_resolve","","",203,{"inputs":[{"name":"self"},{"name":"ty"}],"output":{"name":"ty"}}],[11,"resolve_type_vars_if_possible","","Where possible, replaces type/int/float variables in `value` with their final value. Note that region variables are unaffected. If a type variable has not been unified, it is left as is.  This is an idempotent operation that does not affect inference state in any way and so you can do it at will.",203,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"t"}}],[11,"any_unresolved_type_vars","","Returns true if `T` contains unresolved type variables. In the process of visiting `T`, this will resolve (where possible) type variables in `T`, but it never constructs the final, resolved type, so it's more efficient than `resolve_type_vars_if_possible()`.",203,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"bool"}}],[11,"resolve_type_and_region_vars_if_possible","","",203,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"t"}}],[11,"fully_resolve","","Attempts to resolve all type/region variables in `value`. Region inference must have been run already (e.g., by calling `resolve_regions_and_report_errors`).  If some variable was never unified, an `Err` results.",203,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"fixupresult"}}],[11,"type_error_struct_with_diag","","",203,{"inputs":[{"name":"self"},{"name":"span"},{"name":"m"},{"name":"ty"}],"output":{"name":"diagnosticbuilder"}}],[11,"report_mismatched_types","","",203,{"inputs":[{"name":"self"},{"name":"obligationcause"},{"name":"ty"},{"name":"ty"},{"name":"typeerror"}],"output":{"name":"diagnosticbuilder"}}],[11,"replace_late_bound_regions_with_fresh_var","","",203,null],[11,"match_poly_projection_predicate","","Given a higher-ranked projection predicate like:",203,{"inputs":[{"name":"self"},{"name":"obligationcause"},{"name":"paramenv"},{"name":"polyprojectionpredicate"},{"name":"traitref"}],"output":{"generics":["hrmatchresult"],"name":"inferresult"}}],[11,"verify_generic_bound","","See `verify_generic_bound` method in `region_constraints`",203,{"inputs":[{"name":"self"},{"name":"subregionorigin"},{"name":"generickind"},{"name":"region"},{"name":"verifybound"}],"output":null}],[11,"type_moves_by_default","","",203,{"inputs":[{"name":"self"},{"name":"paramenv"},{"name":"ty"},{"name":"span"}],"output":{"name":"bool"}}],[11,"closure_kind","","Obtains the latest type of the given closure; this may be a closure in the current function, in which case its `ClosureKind` may not yet be known.",203,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"closuresubsts"}],"output":{"generics":["closurekind"],"name":"option"}}],[11,"closure_sig","","Obtain the signature of a closure.  For closures, unlike `tcx.fn_sig(def_id)`, this method will work during the type-checking of the enclosing function and return the closure signature in its partially inferred state.",203,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"closuresubsts"}],"output":{"name":"polyfnsig"}}],[11,"partially_normalize_associated_types_in","","Normalizes associated types in `value`, potentially returning new obligations that must further be processed.",203,{"inputs":[{"name":"self"},{"name":"span"},{"name":"nodeid"},{"name":"paramenv"},{"name":"t"}],"output":{"name":"inferok"}}],[11,"borrow_region_constraints","","",203,{"inputs":[{"name":"self"}],"output":{"generics":["regionconstraintcollector"],"name":"refmut"}}],[11,"clear_caches","","Clears the selection, evaluation, and projection cachesThis is useful when repeatedly attemping to select an Obligation while changing only its ParamEnv, since FulfillmentContext doesn't use 'probe'",203,{"inputs":[{"name":"self"}],"output":null}],[11,"universe","","",203,{"inputs":[{"name":"self"}],"output":{"name":"universeindex"}}],[11,"span","","",204,{"inputs":[{"name":"self"}],"output":{"name":"span"}}],[11,"types","","",204,{"inputs":[{"name":"obligationcause"},{"name":"bool"},{"name":"ty"},{"name":"ty"}],"output":{"name":"typetrace"}}],[11,"dummy","","",204,{"inputs":[{"name":"tyctxt"}],"output":{"name":"typetrace"}}],[11,"fmt","","",204,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"span","","",209,{"inputs":[{"name":"self"}],"output":{"name":"span"}}],[11,"from_obligation_cause","","",209,{"inputs":[{"name":"obligationcause"},{"name":"f"}],"output":{"name":"self"}}],[11,"span","","",212,{"inputs":[{"name":"self"}],"output":{"name":"span"}}],[11,"super_fold_with","","",208,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",208,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"fmt","","",205,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[0,"lint","rustc","Lints, aka compiler warnings.",null,null],[3,"LateContext","rustc::lint","Context for lint checking after type checking.",null,null],[12,"tcx","","Type context we're checking in.",292,null],[12,"tables","","Side-tables for the body we are in.",292,null],[12,"param_env","","Parameter environment for the item we are in.",292,null],[12,"access_levels","","Items accessible from the crate being checked.",292,null],[12,"lint_sess","","The store of registered lints and the lint levels.",292,null],[12,"last_ast_node_with_lint_attrs","","",292,null],[12,"generics","","Generic type parameters in scope for the item we are in.",292,null],[3,"EarlyContext","","Context for lint checking of the AST, after expansion, before lowering to HIR.",null,null],[12,"sess","","Type context we're checking in.",293,null],[12,"krate","","The crate being checked.",293,null],[12,"builder","","",293,null],[12,"lint_sess","","The store of registered lints and the lint levels.",293,null],[12,"buffered","","",293,null],[3,"LintStore","","Information about the registered lints.",null,null],[12,"lints","","Registered lints. The bool is true if the lint was added by a plugin.",294,null],[12,"early_passes","","Trait objects for each lint pass. This is only `None` while performing a lint pass. See the definition of `LintSession::new`.",294,null],[12,"late_passes","","",294,null],[12,"by_name","","Lints indexed by name.",294,null],[12,"lint_groups","","Map of registered lint groups to what lints they expand to. The bool is true if the lint group was added by a plugin.",294,null],[12,"future_incompatible","","Extra info for future incompatibility lints, describing the issue or RFC that caused the incompatibility.",294,null],[3,"FutureIncompatibleInfo","","Extra information for a future incompatibility lint. See the call to `register_future_incompatible` in `librustc_lint/lib.rs` for guidelines.",null,null],[12,"id","","",295,null],[12,"reference","","e.g., a URL for an issue/PR/RFC or error code",295,null],[12,"edition","","If this is an edition fixing lint, the edition in which this lint becomes obsolete",295,null],[3,"BufferedEarlyLint","","Lints that are buffered up early on in the `Session` before the `LintLevels` is calculated",null,null],[12,"lint_id","","",296,null],[12,"ast_id","","",296,null],[12,"span","","",296,null],[12,"msg","","",296,null],[12,"diagnostic","","",296,null],[3,"Lint","","Specification of a single lint.",null,null],[12,"name","","A string identifier for the lint.",297,null],[12,"default_level","","Default level for the lint.",297,null],[12,"desc","","Description of the lint or the issue it detects.",297,null],[12,"edition_deny","","Deny lint after this edition",297,null],[3,"LintId","","Identifies a lint known to the compiler.",null,null],[12,"lint","","",298,null],[3,"LintLevelSets","","",null,null],[12,"list","","",299,null],[12,"lint_cap","","",299,null],[3,"LintLevelMap","","",null,null],[12,"sets","","",300,null],[12,"id_to_set","","",300,null],[3,"LintBuffer","","",null,null],[12,"map","","",301,null],[3,"LintLevelMapBuilder","","",null,null],[12,"levels","","",302,null],[12,"tcx","","",302,null],[4,"Level","","Setting for how to handle a lint.",null,null],[13,"Allow","","",303,null],[13,"Warn","","",303,null],[13,"Deny","","",303,null],[13,"Forbid","","",303,null],[4,"LintSource","","How a lint level was set.",null,null],[13,"Default","","Lint is at the default level as declared in rustc or a plugin.",304,null],[13,"Node","","Lint level was set by an attribute.",304,null],[13,"CommandLine","","Lint level was set by a command-line flag.",304,null],[5,"check_crate","","Perform lint checking on a crate.",null,{"inputs":[{"name":"tyctxt"}],"output":null}],[5,"check_ast_crate","","",null,{"inputs":[{"name":"session"},{"name":"crate"}],"output":null}],[5,"struct_lint_level","","",null,{"inputs":[{"name":"session"},{"name":"lint"},{"name":"level"},{"name":"lintsource"},{"generics":["multispan"],"name":"option"},{"name":"str"}],"output":{"name":"diagnosticbuilder"}}],[5,"lint_levels","","",null,{"inputs":[{"name":"tyctxt"},{"name":"cratenum"}],"output":{"generics":["lintlevelmap"],"name":"lrc"}}],[5,"provide","","",null,{"inputs":[{"name":"providers"}],"output":null}],[0,"builtin","","Some lints that are built in to the compiler.",null,null],[3,"HardwiredLints","rustc::lint::builtin","Does nothing as a lint pass, but registers some `Lint`s which are used by other parts of the compiler.",null,null],[4,"BuiltinLintDiagnostics","","",null,null],[13,"Normal","","",305,null],[13,"BareTraitObject","","",305,null],[13,"AbsPathWithModule","","",305,null],[7,"EXCEEDING_BITSHIFTS","","",null,null],[7,"CONST_ERR","","",null,null],[7,"UNUSED_IMPORTS","","",null,null],[7,"UNUSED_EXTERN_CRATES","","",null,null],[7,"UNUSED_QUALIFICATIONS","","",null,null],[7,"UNKNOWN_LINTS","","",null,null],[7,"UNUSED_VARIABLES","","",null,null],[7,"UNUSED_ASSIGNMENTS","","",null,null],[7,"DEAD_CODE","","",null,null],[7,"UNREACHABLE_CODE","","",null,null],[7,"UNREACHABLE_PATTERNS","","",null,null],[7,"UNUSED_MACROS","","",null,null],[7,"WARNINGS","","",null,null],[7,"UNUSED_FEATURES","","",null,null],[7,"STABLE_FEATURES","","",null,null],[7,"UNKNOWN_CRATE_TYPES","","",null,null],[7,"TRIVIAL_CASTS","","",null,null],[7,"TRIVIAL_NUMERIC_CASTS","","",null,null],[7,"PRIVATE_IN_PUBLIC","","",null,null],[7,"PUB_USE_OF_PRIVATE_EXTERN_CRATE","","",null,null],[7,"INVALID_TYPE_PARAM_DEFAULT","","",null,null],[7,"RENAMED_AND_REMOVED_LINTS","","",null,null],[7,"SAFE_EXTERN_STATICS","","",null,null],[7,"SAFE_PACKED_BORROWS","","",null,null],[7,"PATTERNS_IN_FNS_WITHOUT_BODY","","",null,null],[7,"LEGACY_DIRECTORY_OWNERSHIP","","",null,null],[7,"LEGACY_IMPORTS","","",null,null],[7,"LEGACY_CONSTRUCTOR_VISIBILITY","","",null,null],[7,"MISSING_FRAGMENT_SPECIFIER","","",null,null],[7,"PARENTHESIZED_PARAMS_IN_TYPES_AND_MODULES","","",null,null],[7,"LATE_BOUND_LIFETIME_ARGUMENTS","","",null,null],[7,"INCOHERENT_FUNDAMENTAL_IMPLS","","",null,null],[7,"DEPRECATED","","",null,null],[7,"UNUSED_UNSAFE","","",null,null],[7,"UNUSED_MUT","","",null,null],[7,"SINGLE_USE_LIFETIMES","","",null,null],[7,"TYVAR_BEHIND_RAW_POINTER","","",null,null],[7,"ELIDED_LIFETIMES_IN_PATHS","","",null,null],[7,"BARE_TRAIT_OBJECTS","","",null,null],[7,"ABSOLUTE_PATHS_NOT_STARTING_WITH_CRATE","","",null,null],[7,"ILLEGAL_FLOATING_POINT_LITERAL_PATTERN","","",null,null],[7,"UNSTABLE_NAME_COLLISIONS","","",null,null],[11,"clone","","",306,{"inputs":[{"name":"self"}],"output":{"name":"hardwiredlints"}}],[11,"get_lints","","",306,{"inputs":[{"name":"self"}],"output":{"name":"lintarray"}}],[11,"eq","","",305,{"inputs":[{"name":"self"},{"name":"builtinlintdiagnostics"}],"output":{"name":"bool"}}],[11,"ne","","",305,{"inputs":[{"name":"self"},{"name":"builtinlintdiagnostics"}],"output":{"name":"bool"}}],[11,"encode","","",305,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",305,{"inputs":[{"name":"__d"}],"output":{"generics":["builtinlintdiagnostics"],"name":"result"}}],[11,"fmt","","",305,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"run","","",305,{"inputs":[{"name":"self"},{"name":"session"},{"name":"diagnosticbuilder"}],"output":null}],[0,"context","rustc::lint","Implementation of lint checking.",null,null],[3,"LintStore","rustc::lint::context","Information about the registered lints.",null,null],[12,"lints","","Registered lints. The bool is true if the lint was added by a plugin.",294,null],[12,"early_passes","","Trait objects for each lint pass. This is only `None` while performing a lint pass. See the definition of `LintSession::new`.",294,null],[12,"late_passes","","",294,null],[12,"by_name","","Lints indexed by name.",294,null],[12,"lint_groups","","Map of registered lint groups to what lints they expand to. The bool is true if the lint group was added by a plugin.",294,null],[12,"future_incompatible","","Extra info for future incompatibility lints, describing the issue or RFC that caused the incompatibility.",294,null],[3,"LintSession","","",null,null],[12,"lints","","Reference to the store of registered lints.",307,null],[12,"passes","","Trait objects for each lint pass.",307,null],[3,"BufferedEarlyLint","","Lints that are buffered up early on in the `Session` before the `LintLevels` is calculated",null,null],[12,"lint_id","","",296,null],[12,"ast_id","","",296,null],[12,"span","","",296,null],[12,"msg","","",296,null],[12,"diagnostic","","",296,null],[3,"FutureIncompatibleInfo","","Extra information for a future incompatibility lint. See the call to `register_future_incompatible` in `librustc_lint/lib.rs` for guidelines.",null,null],[12,"id","","",295,null],[12,"reference","","e.g., a URL for an issue/PR/RFC or error code",295,null],[12,"edition","","If this is an edition fixing lint, the edition in which this lint becomes obsolete",295,null],[3,"LateContext","","Context for lint checking after type checking.",null,null],[12,"tcx","","Type context we're checking in.",292,null],[12,"tables","","Side-tables for the body we are in.",292,null],[12,"param_env","","Parameter environment for the item we are in.",292,null],[12,"access_levels","","Items accessible from the crate being checked.",292,null],[12,"lint_sess","","The store of registered lints and the lint levels.",292,null],[12,"last_ast_node_with_lint_attrs","","",292,null],[12,"generics","","Generic type parameters in scope for the item we are in.",292,null],[3,"EarlyContext","","Context for lint checking of the AST, after expansion, before lowering to HIR.",null,null],[12,"sess","","Type context we're checking in.",293,null],[12,"krate","","The crate being checked.",293,null],[12,"builder","","",293,null],[12,"lint_sess","","The store of registered lints and the lint levels.",293,null],[12,"buffered","","",293,null],[4,"TargetLint","","The target of the `by_name` map, which accounts for renaming/deprecation.",null,null],[13,"Id","","A direct lint target",308,null],[13,"Renamed","","Temporary renaming, used for easing migration pain; see #16545",308,null],[13,"Removed","","Lint with this name existed previously, but has been removed/deprecated. The string argument is the reason for removal.",308,null],[4,"FindLintError","","",null,null],[13,"NotFound","","",309,null],[13,"Removed","","",309,null],[4,"CheckLintNameResult","","",null,null],[13,"Ok","","",310,null],[13,"NoLint","","Lint doesn't exist",310,null],[13,"Warning","","The lint is either renamed or removed. This is the warning message.",310,null],[5,"check_crate","","Perform lint checking on a crate.",null,{"inputs":[{"name":"tyctxt"}],"output":null}],[5,"check_ast_crate","","",null,{"inputs":[{"name":"session"},{"name":"crate"}],"output":null}],[8,"LintPassObject","","",null,null],[10,"take_passes","","",311,{"inputs":[{"name":"lintstore"}],"output":{"generics":["vec"],"name":"option"}}],[10,"restore_passes","","",311,{"inputs":[{"name":"lintstore"},{"generics":["vec"],"name":"option"}],"output":null}],[8,"LintContext","","",null,null],[16,"PassObject","","",312,null],[10,"sess","","",312,{"inputs":[{"name":"self"}],"output":{"name":"session"}}],[10,"lints","","",312,{"inputs":[{"name":"self"}],"output":{"name":"lintstore"}}],[10,"lint_sess","","",312,{"inputs":[{"name":"self"}],"output":{"name":"lintsession"}}],[10,"lint_sess_mut","","",312,{"inputs":[{"name":"self"}],"output":{"name":"lintsession"}}],[10,"enter_attrs","","",312,null],[10,"exit_attrs","","",312,null],[11,"lookup_and_emit","","",312,{"inputs":[{"name":"self"},{"name":"lint"},{"name":"option"},{"name":"str"}],"output":null}],[11,"lookup_and_emit_with_diagnostics","","",312,{"inputs":[{"name":"self"},{"name":"lint"},{"name":"option"},{"name":"str"},{"name":"builtinlintdiagnostics"}],"output":null}],[10,"lookup","","",312,{"inputs":[{"name":"self"},{"name":"lint"},{"name":"option"},{"name":"str"}],"output":{"name":"diagnosticbuilder"}}],[11,"span_lint","","Emit a lint at the appropriate level, for a particular span.",312,{"inputs":[{"name":"self"},{"name":"lint"},{"name":"s"},{"name":"str"}],"output":null}],[11,"struct_span_lint","","",312,{"inputs":[{"name":"self"},{"name":"lint"},{"name":"s"},{"name":"str"}],"output":{"name":"diagnosticbuilder"}}],[11,"span_lint_note","","Emit a lint and note at the appropriate level, for a particular span.",312,{"inputs":[{"name":"self"},{"name":"lint"},{"name":"span"},{"name":"str"},{"name":"span"},{"name":"str"}],"output":null}],[11,"span_lint_help","","Emit a lint and help at the appropriate level, for a particular span.",312,{"inputs":[{"name":"self"},{"name":"lint"},{"name":"span"},{"name":"str"},{"name":"str"}],"output":null}],[11,"lint","","Emit a lint at the appropriate level, with no associated span.",312,{"inputs":[{"name":"self"},{"name":"lint"},{"name":"str"}],"output":null}],[10,"with_lint_attrs","","Merge the lints specified by any lint attributes into the current lint context, call the provided function, then reset the lints in effect to their previous state.",312,null],[11,"eq","rustc::lint","",296,{"inputs":[{"name":"self"},{"name":"bufferedearlylint"}],"output":{"name":"bool"}}],[11,"ne","","",296,{"inputs":[{"name":"self"},{"name":"bufferedearlylint"}],"output":{"name":"bool"}}],[11,"encode","","",296,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",296,{"inputs":[{"name":"__d"}],"output":{"generics":["bufferedearlylint"],"name":"result"}}],[11,"fmt","","",296,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","",294,{"inputs":[],"output":{"name":"lintstore"}}],[11,"get_lints","","",294,null],[11,"get_lint_groups","","",294,{"inputs":[{"name":"self"}],"output":{"name":"vec"}}],[11,"register_early_pass","","",294,{"inputs":[{"name":"self"},{"generics":["session"],"name":"option"},{"name":"bool"},{"name":"earlylintpassobject"}],"output":null}],[11,"register_late_pass","","",294,{"inputs":[{"name":"self"},{"generics":["session"],"name":"option"},{"name":"bool"},{"name":"latelintpassobject"}],"output":null}],[11,"push_pass","","",294,{"inputs":[{"name":"self"},{"generics":["session"],"name":"option"},{"name":"bool"},{"name":"box"}],"output":null}],[11,"register_future_incompatible","","",294,{"inputs":[{"name":"self"},{"generics":["session"],"name":"option"},{"generics":["futureincompatibleinfo"],"name":"vec"}],"output":null}],[11,"future_incompatible","","",294,{"inputs":[{"name":"self"},{"name":"lintid"}],"output":{"generics":["futureincompatibleinfo"],"name":"option"}}],[11,"register_group","","",294,{"inputs":[{"name":"self"},{"generics":["session"],"name":"option"},{"name":"bool"},{"name":"str"},{"generics":["lintid"],"name":"vec"}],"output":null}],[11,"register_renamed","","",294,{"inputs":[{"name":"self"},{"name":"str"},{"name":"str"}],"output":null}],[11,"register_removed","","",294,{"inputs":[{"name":"self"},{"name":"str"},{"name":"str"}],"output":null}],[11,"find_lints","","",294,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"generics":["vec","findlinterror"],"name":"result"}}],[11,"check_lint_name_cmdline","","Checks the validity of lint names derived from the command line",294,{"inputs":[{"name":"self"},{"name":"session"},{"name":"str"},{"name":"level"}],"output":null}],[11,"check_lint_name","","Checks the name of a lint for its existence, and whether it was renamed or removed. Generates a DiagnosticBuilder containing a warning for renamed and removed lints. This is over both lint names from attributes and those passed on the command line. Since it emits non-fatal warnings and there are two lint passes that inspect attributes, this is only run from the late pass to avoid printing duplicate warnings.",294,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"checklintnameresult"}}],[11,"new","rustc::lint::context","Creates a new `LintSession`, by moving out the `LintStore`'s initial lint levels and pass objects. These can be restored using the `restore` method.",307,{"inputs":[{"name":"rwlock"}],"output":{"name":"lintsession"}}],[11,"restore","","Restores the levels back to the original lint store.",307,{"inputs":[{"name":"self"},{"name":"rwlock"}],"output":null}],[11,"new","rustc::lint","",293,{"inputs":[{"name":"session"},{"name":"crate"}],"output":{"name":"earlycontext"}}],[11,"check_id","","",293,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":null}],[11,"sess","","Get the overall compiler `Session` object.",292,{"inputs":[{"name":"self"}],"output":{"name":"session"}}],[11,"lints","","",292,{"inputs":[{"name":"self"}],"output":{"name":"lintstore"}}],[11,"lint_sess","","",292,{"inputs":[{"name":"self"}],"output":{"name":"lintsession"}}],[11,"lint_sess_mut","","",292,{"inputs":[{"name":"self"}],"output":{"name":"lintsession"}}],[11,"enter_attrs","","",292,null],[11,"exit_attrs","","",292,null],[11,"lookup","","",292,{"inputs":[{"name":"self"},{"name":"lint"},{"name":"option"},{"name":"str"}],"output":{"name":"diagnosticbuilder"}}],[11,"with_lint_attrs","","",292,null],[11,"sess","","Get the overall compiler `Session` object.",293,{"inputs":[{"name":"self"}],"output":{"name":"session"}}],[11,"lints","","",293,{"inputs":[{"name":"self"}],"output":{"name":"lintstore"}}],[11,"lint_sess","","",293,{"inputs":[{"name":"self"}],"output":{"name":"lintsession"}}],[11,"lint_sess_mut","","",293,{"inputs":[{"name":"self"}],"output":{"name":"lintsession"}}],[11,"enter_attrs","","",293,null],[11,"exit_attrs","","",293,null],[11,"lookup","","",293,{"inputs":[{"name":"self"},{"name":"lint"},{"name":"option"},{"name":"str"}],"output":{"name":"diagnosticbuilder"}}],[11,"with_lint_attrs","","",293,null],[11,"with_param_env","","",292,{"inputs":[{"name":"self"},{"name":"nodeid"},{"name":"f"}],"output":null}],[11,"nested_visit_map","","Because lints are scoped lexically, we want to walk nested items in the context of the outer item, so enable deep-walking.",292,{"inputs":[{"name":"self"}],"output":{"name":"nestedvisitormap"}}],[11,"visit_nested_body","","",292,{"inputs":[{"name":"self"},{"name":"bodyid"}],"output":null}],[11,"visit_body","","",292,{"inputs":[{"name":"self"},{"name":"body"}],"output":null}],[11,"visit_item","","",292,{"inputs":[{"name":"self"},{"name":"item"}],"output":null}],[11,"visit_foreign_item","","",292,{"inputs":[{"name":"self"},{"name":"foreignitem"}],"output":null}],[11,"visit_pat","","",292,{"inputs":[{"name":"self"},{"name":"pat"}],"output":null}],[11,"visit_expr","","",292,{"inputs":[{"name":"self"},{"name":"expr"}],"output":null}],[11,"visit_stmt","","",292,{"inputs":[{"name":"self"},{"name":"stmt"}],"output":null}],[11,"visit_fn","","",292,{"inputs":[{"name":"self"},{"name":"fnkind"},{"name":"fndecl"},{"name":"bodyid"},{"name":"span"},{"name":"nodeid"}],"output":null}],[11,"visit_variant_data","","",292,{"inputs":[{"name":"self"},{"name":"variantdata"},{"name":"name"},{"name":"generics"},{"name":"nodeid"},{"name":"span"}],"output":null}],[11,"visit_struct_field","","",292,{"inputs":[{"name":"self"},{"name":"structfield"}],"output":null}],[11,"visit_variant","","",292,{"inputs":[{"name":"self"},{"name":"variant"},{"name":"generics"},{"name":"nodeid"}],"output":null}],[11,"visit_ty","","",292,{"inputs":[{"name":"self"},{"name":"ty"}],"output":null}],[11,"visit_name","","",292,{"inputs":[{"name":"self"},{"name":"span"},{"name":"name"}],"output":null}],[11,"visit_mod","","",292,{"inputs":[{"name":"self"},{"name":"mod"},{"name":"span"},{"name":"nodeid"}],"output":null}],[11,"visit_local","","",292,{"inputs":[{"name":"self"},{"name":"local"}],"output":null}],[11,"visit_block","","",292,{"inputs":[{"name":"self"},{"name":"block"}],"output":null}],[11,"visit_arm","","",292,{"inputs":[{"name":"self"},{"name":"arm"}],"output":null}],[11,"visit_decl","","",292,{"inputs":[{"name":"self"},{"name":"decl"}],"output":null}],[11,"visit_generic_param","","",292,{"inputs":[{"name":"self"},{"name":"genericparam"}],"output":null}],[11,"visit_generics","","",292,{"inputs":[{"name":"self"},{"name":"generics"}],"output":null}],[11,"visit_where_predicate","","",292,{"inputs":[{"name":"self"},{"name":"wherepredicate"}],"output":null}],[11,"visit_poly_trait_ref","","",292,{"inputs":[{"name":"self"},{"name":"polytraitref"},{"name":"traitboundmodifier"}],"output":null}],[11,"visit_trait_item","","",292,{"inputs":[{"name":"self"},{"name":"traititem"}],"output":null}],[11,"visit_impl_item","","",292,{"inputs":[{"name":"self"},{"name":"implitem"}],"output":null}],[11,"visit_lifetime","","",292,{"inputs":[{"name":"self"},{"name":"lifetime"}],"output":null}],[11,"visit_path","","",292,{"inputs":[{"name":"self"},{"name":"path"},{"name":"nodeid"}],"output":null}],[11,"visit_attribute","","",292,{"inputs":[{"name":"self"},{"name":"attribute"}],"output":null}],[11,"visit_item","","",293,{"inputs":[{"name":"self"},{"name":"item"}],"output":null}],[11,"visit_foreign_item","","",293,{"inputs":[{"name":"self"},{"name":"foreignitem"}],"output":null}],[11,"visit_pat","","",293,{"inputs":[{"name":"self"},{"name":"pat"}],"output":null}],[11,"visit_expr","","",293,{"inputs":[{"name":"self"},{"name":"expr"}],"output":null}],[11,"visit_stmt","","",293,{"inputs":[{"name":"self"},{"name":"stmt"}],"output":null}],[11,"visit_fn","","",293,{"inputs":[{"name":"self"},{"name":"fnkind"},{"name":"fndecl"},{"name":"span"},{"name":"nodeid"}],"output":null}],[11,"visit_variant_data","","",293,{"inputs":[{"name":"self"},{"name":"variantdata"},{"name":"ident"},{"name":"generics"},{"name":"nodeid"},{"name":"span"}],"output":null}],[11,"visit_struct_field","","",293,{"inputs":[{"name":"self"},{"name":"structfield"}],"output":null}],[11,"visit_variant","","",293,{"inputs":[{"name":"self"},{"name":"variant"},{"name":"generics"},{"name":"nodeid"}],"output":null}],[11,"visit_ty","","",293,{"inputs":[{"name":"self"},{"name":"ty"}],"output":null}],[11,"visit_ident","","",293,{"inputs":[{"name":"self"},{"name":"ident"}],"output":null}],[11,"visit_mod","","",293,null],[11,"visit_local","","",293,{"inputs":[{"name":"self"},{"name":"local"}],"output":null}],[11,"visit_block","","",293,{"inputs":[{"name":"self"},{"name":"block"}],"output":null}],[11,"visit_arm","","",293,{"inputs":[{"name":"self"},{"name":"arm"}],"output":null}],[11,"visit_expr_post","","",293,{"inputs":[{"name":"self"},{"name":"expr"}],"output":null}],[11,"visit_generic_param","","",293,{"inputs":[{"name":"self"},{"name":"genericparam"}],"output":null}],[11,"visit_generics","","",293,{"inputs":[{"name":"self"},{"name":"generics"}],"output":null}],[11,"visit_where_predicate","","",293,{"inputs":[{"name":"self"},{"name":"wherepredicate"}],"output":null}],[11,"visit_poly_trait_ref","","",293,{"inputs":[{"name":"self"},{"name":"polytraitref"},{"name":"traitboundmodifier"}],"output":null}],[11,"visit_trait_item","","",293,{"inputs":[{"name":"self"},{"name":"traititem"}],"output":null}],[11,"visit_impl_item","","",293,{"inputs":[{"name":"self"},{"name":"implitem"}],"output":null}],[11,"visit_lifetime","","",293,{"inputs":[{"name":"self"},{"name":"lifetime"}],"output":null}],[11,"visit_path","","",293,{"inputs":[{"name":"self"},{"name":"path"},{"name":"nodeid"}],"output":null}],[11,"visit_attribute","","",293,{"inputs":[{"name":"self"},{"name":"attribute"}],"output":null}],[11,"visit_mac_def","","",293,{"inputs":[{"name":"self"},{"name":"macrodef"},{"name":"nodeid"}],"output":null}],[11,"encode","","",298,{"inputs":[{"name":"self"},{"name":"s"}],"output":{"name":"result"}}],[11,"decode","","",298,{"inputs":[{"name":"d"}],"output":{"generics":["lintid"],"name":"result"}}],[0,"levels","","",null,null],[3,"LintLevelSets","rustc::lint::levels","",null,null],[12,"list","","",299,null],[12,"lint_cap","","",299,null],[3,"LintLevelsBuilder","","",null,null],[12,"sess","","",313,null],[12,"sets","","",313,null],[12,"id_to_set","","",313,null],[12,"cur","","",313,null],[12,"warn_about_weird_lints","","",313,null],[3,"BuilderPush","","",null,null],[12,"prev","","",314,null],[3,"LintLevelMap","","",null,null],[12,"sets","","",300,null],[12,"id_to_set","","",300,null],[4,"LintSet","","",null,null],[13,"CommandLine","","",315,null],[12,"specs","rustc::lint::levels::LintSet","",315,null],[13,"Node","rustc::lint::levels","",315,null],[12,"specs","rustc::lint::levels::LintSet","",315,null],[12,"parent","","",315,null],[11,"new","rustc::lint","",299,{"inputs":[{"name":"session"}],"output":{"name":"lintlevelsets"}}],[11,"builder","","",299,{"inputs":[{"name":"session"}],"output":{"name":"lintlevelsbuilder"}}],[11,"process_command_line","","",299,{"inputs":[{"name":"self"},{"name":"session"}],"output":null}],[11,"get_lint_level","","",299,null],[11,"get_lint_id_level","","",299,null],[11,"new","rustc::lint::levels","",313,{"inputs":[{"name":"session"},{"name":"lintlevelsets"}],"output":{"name":"lintlevelsbuilder"}}],[11,"push","","Pushes a list of AST lint attributes onto this context.",313,null],[11,"pop","","Called after `push` when the scope of a set of attributes are exited.",313,{"inputs":[{"name":"self"},{"name":"builderpush"}],"output":null}],[11,"struct_lint","","Used to emit a lint-related diagnostic based on the current state of this lint context.",313,{"inputs":[{"name":"self"},{"name":"lint"},{"generics":["multispan"],"name":"option"},{"name":"str"}],"output":{"name":"diagnosticbuilder"}}],[11,"register_id","","Registers the ID provided with the current set of lints stored in this context.",313,{"inputs":[{"name":"self"},{"name":"hirid"}],"output":null}],[11,"build","","",313,{"inputs":[{"name":"self"}],"output":{"name":"lintlevelsets"}}],[11,"build_map","","",313,{"inputs":[{"name":"self"}],"output":{"name":"lintlevelmap"}}],[11,"level_and_source","rustc::lint","If the `id` was previously registered with `register_id` when building this `LintLevelMap` this returns the corresponding lint level and source of the lint level for the lint provided.",300,{"inputs":[{"name":"self"},{"name":"lint"},{"name":"hirid"},{"name":"session"}],"output":{"name":"option"}}],[11,"lint_level_set","","Returns if this `id` has lint level information.",300,{"inputs":[{"name":"self"},{"name":"hirid"}],"output":{"generics":["u32"],"name":"option"}}],[11,"hash_stable","","",300,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","","",298,{"inputs":[{"name":"self"},{"name":"hcx"},{"name":"stablehasher"}],"output":null}],[11,"to_stable_hash_key","","",298,{"inputs":[{"name":"self"},{"name":"hcx"}],"output":{"name":"str"}}],[6,"LintArray","","",null,null],[6,"EarlyLintPassObject","","A lint pass boxed up as a trait object.",null,null],[6,"LateLintPassObject","","",null,null],[6,"LevelSource","","",null,null],[8,"LintContext","","",null,null],[16,"PassObject","","",312,null],[10,"sess","","",312,{"inputs":[{"name":"self"}],"output":{"name":"session"}}],[10,"lints","","",312,{"inputs":[{"name":"self"}],"output":{"name":"lintstore"}}],[10,"lint_sess","","",312,{"inputs":[{"name":"self"}],"output":{"name":"lintsession"}}],[10,"lint_sess_mut","","",312,{"inputs":[{"name":"self"}],"output":{"name":"lintsession"}}],[10,"enter_attrs","","",312,null],[10,"exit_attrs","","",312,null],[11,"lookup_and_emit","rustc::lint::context","",312,{"inputs":[{"name":"self"},{"name":"lint"},{"name":"option"},{"name":"str"}],"output":null}],[11,"lookup_and_emit_with_diagnostics","","",312,{"inputs":[{"name":"self"},{"name":"lint"},{"name":"option"},{"name":"str"},{"name":"builtinlintdiagnostics"}],"output":null}],[10,"lookup","rustc::lint","",312,{"inputs":[{"name":"self"},{"name":"lint"},{"name":"option"},{"name":"str"}],"output":{"name":"diagnosticbuilder"}}],[11,"span_lint","rustc::lint::context","Emit a lint at the appropriate level, for a particular span.",312,{"inputs":[{"name":"self"},{"name":"lint"},{"name":"s"},{"name":"str"}],"output":null}],[11,"struct_span_lint","","",312,{"inputs":[{"name":"self"},{"name":"lint"},{"name":"s"},{"name":"str"}],"output":{"name":"diagnosticbuilder"}}],[11,"span_lint_note","","Emit a lint and note at the appropriate level, for a particular span.",312,{"inputs":[{"name":"self"},{"name":"lint"},{"name":"span"},{"name":"str"},{"name":"span"},{"name":"str"}],"output":null}],[11,"span_lint_help","","Emit a lint and help at the appropriate level, for a particular span.",312,{"inputs":[{"name":"self"},{"name":"lint"},{"name":"span"},{"name":"str"},{"name":"str"}],"output":null}],[11,"lint","","Emit a lint at the appropriate level, with no associated span.",312,{"inputs":[{"name":"self"},{"name":"lint"},{"name":"str"}],"output":null}],[10,"with_lint_attrs","rustc::lint","Merge the lints specified by any lint attributes into the current lint context, call the provided function, then reset the lints in effect to their previous state.",312,null],[8,"LintPass","","",null,null],[10,"get_lints","","Get descriptions of the lints this `LintPass` object can emit.",316,{"inputs":[{"name":"self"}],"output":{"name":"lintarray"}}],[8,"LateLintPass","","Trait for types providing lint checks.",null,null],[11,"check_body","","",317,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"body"}],"output":null}],[11,"check_body_post","","",317,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"body"}],"output":null}],[11,"check_name","","",317,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"span"},{"name":"name"}],"output":null}],[11,"check_crate","","",317,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"crate"}],"output":null}],[11,"check_crate_post","","",317,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"crate"}],"output":null}],[11,"check_mod","","",317,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"mod"},{"name":"span"},{"name":"nodeid"}],"output":null}],[11,"check_mod_post","","",317,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"mod"},{"name":"span"},{"name":"nodeid"}],"output":null}],[11,"check_foreign_item","","",317,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"foreignitem"}],"output":null}],[11,"check_foreign_item_post","","",317,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"foreignitem"}],"output":null}],[11,"check_item","","",317,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"item"}],"output":null}],[11,"check_item_post","","",317,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"item"}],"output":null}],[11,"check_local","","",317,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"local"}],"output":null}],[11,"check_block","","",317,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"block"}],"output":null}],[11,"check_block_post","","",317,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"block"}],"output":null}],[11,"check_stmt","","",317,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"stmt"}],"output":null}],[11,"check_arm","","",317,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"arm"}],"output":null}],[11,"check_pat","","",317,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"pat"}],"output":null}],[11,"check_decl","","",317,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"decl"}],"output":null}],[11,"check_expr","","",317,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"expr"}],"output":null}],[11,"check_expr_post","","",317,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"expr"}],"output":null}],[11,"check_ty","","",317,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"ty"}],"output":null}],[11,"check_generic_param","","",317,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"genericparam"}],"output":null}],[11,"check_generics","","",317,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"generics"}],"output":null}],[11,"check_where_predicate","","",317,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"wherepredicate"}],"output":null}],[11,"check_poly_trait_ref","","",317,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"polytraitref"},{"name":"traitboundmodifier"}],"output":null}],[11,"check_fn","","",317,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"fnkind"},{"name":"fndecl"},{"name":"body"},{"name":"span"},{"name":"nodeid"}],"output":null}],[11,"check_fn_post","","",317,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"fnkind"},{"name":"fndecl"},{"name":"body"},{"name":"span"},{"name":"nodeid"}],"output":null}],[11,"check_trait_item","","",317,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"traititem"}],"output":null}],[11,"check_trait_item_post","","",317,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"traititem"}],"output":null}],[11,"check_impl_item","","",317,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"implitem"}],"output":null}],[11,"check_impl_item_post","","",317,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"implitem"}],"output":null}],[11,"check_struct_def","","",317,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"variantdata"},{"name":"name"},{"name":"generics"},{"name":"nodeid"}],"output":null}],[11,"check_struct_def_post","","",317,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"variantdata"},{"name":"name"},{"name":"generics"},{"name":"nodeid"}],"output":null}],[11,"check_struct_field","","",317,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"structfield"}],"output":null}],[11,"check_variant","","",317,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"variant"},{"name":"generics"}],"output":null}],[11,"check_variant_post","","",317,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"variant"},{"name":"generics"}],"output":null}],[11,"check_lifetime","","",317,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"lifetime"}],"output":null}],[11,"check_path","","",317,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"path"},{"name":"nodeid"}],"output":null}],[11,"check_attribute","","",317,{"inputs":[{"name":"self"},{"name":"latecontext"},{"name":"attribute"}],"output":null}],[11,"enter_lint_attrs","","Called when entering a syntax node that can have lint attributes such as `#[allow(...)]`. Called with all the attributes of that node.",317,null],[11,"exit_lint_attrs","","Counterpart to `enter_lint_attrs`.",317,null],[8,"EarlyLintPass","","",null,null],[11,"check_ident","","",318,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"ident"}],"output":null}],[11,"check_crate","","",318,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"crate"}],"output":null}],[11,"check_crate_post","","",318,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"crate"}],"output":null}],[11,"check_mod","","",318,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"mod"},{"name":"span"},{"name":"nodeid"}],"output":null}],[11,"check_mod_post","","",318,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"mod"},{"name":"span"},{"name":"nodeid"}],"output":null}],[11,"check_foreign_item","","",318,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"foreignitem"}],"output":null}],[11,"check_foreign_item_post","","",318,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"foreignitem"}],"output":null}],[11,"check_item","","",318,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"item"}],"output":null}],[11,"check_item_post","","",318,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"item"}],"output":null}],[11,"check_local","","",318,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"local"}],"output":null}],[11,"check_block","","",318,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"block"}],"output":null}],[11,"check_block_post","","",318,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"block"}],"output":null}],[11,"check_stmt","","",318,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"stmt"}],"output":null}],[11,"check_arm","","",318,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"arm"}],"output":null}],[11,"check_pat","","",318,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"pat"}],"output":null}],[11,"check_expr","","",318,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"expr"}],"output":null}],[11,"check_expr_post","","",318,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"expr"}],"output":null}],[11,"check_ty","","",318,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"ty"}],"output":null}],[11,"check_generic_param","","",318,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"genericparam"}],"output":null}],[11,"check_generics","","",318,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"generics"}],"output":null}],[11,"check_where_predicate","","",318,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"wherepredicate"}],"output":null}],[11,"check_poly_trait_ref","","",318,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"polytraitref"},{"name":"traitboundmodifier"}],"output":null}],[11,"check_fn","","",318,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"fnkind"},{"name":"fndecl"},{"name":"span"},{"name":"nodeid"}],"output":null}],[11,"check_fn_post","","",318,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"fnkind"},{"name":"fndecl"},{"name":"span"},{"name":"nodeid"}],"output":null}],[11,"check_trait_item","","",318,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"traititem"}],"output":null}],[11,"check_trait_item_post","","",318,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"traititem"}],"output":null}],[11,"check_impl_item","","",318,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"implitem"}],"output":null}],[11,"check_impl_item_post","","",318,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"implitem"}],"output":null}],[11,"check_struct_def","","",318,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"variantdata"},{"name":"ident"},{"name":"generics"},{"name":"nodeid"}],"output":null}],[11,"check_struct_def_post","","",318,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"variantdata"},{"name":"ident"},{"name":"generics"},{"name":"nodeid"}],"output":null}],[11,"check_struct_field","","",318,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"structfield"}],"output":null}],[11,"check_variant","","",318,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"variant"},{"name":"generics"}],"output":null}],[11,"check_variant_post","","",318,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"variant"},{"name":"generics"}],"output":null}],[11,"check_lifetime","","",318,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"lifetime"}],"output":null}],[11,"check_path","","",318,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"path"},{"name":"nodeid"}],"output":null}],[11,"check_attribute","","",318,{"inputs":[{"name":"self"},{"name":"earlycontext"},{"name":"attribute"}],"output":null}],[11,"enter_lint_attrs","","Called when entering a syntax node that can have lint attributes such as `#[allow(...)]`. Called with all the attributes of that node.",318,null],[11,"exit_lint_attrs","","Counterpart to `enter_lint_attrs`.",318,null],[11,"clone","","",297,{"inputs":[{"name":"self"}],"output":{"name":"lint"}}],[11,"fmt","","",297,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"name_lower","","Get the lint's name, with ASCII letters converted to lowercase.",297,{"inputs":[{"name":"self"}],"output":{"name":"string"}}],[11,"default_level","","",297,{"inputs":[{"name":"self"},{"name":"session"}],"output":{"name":"level"}}],[11,"clone","","",298,{"inputs":[{"name":"self"}],"output":{"name":"lintid"}}],[11,"fmt","","",298,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",298,{"inputs":[{"name":"self"},{"name":"lintid"}],"output":{"name":"bool"}}],[11,"hash","","",298,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"of","","Get the `LintId` for a `Lint`.",298,{"inputs":[{"name":"lint"}],"output":{"name":"lintid"}}],[11,"lint_name_raw","","",298,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"to_string","","Get the name of the lint.",298,{"inputs":[{"name":"self"}],"output":{"name":"string"}}],[11,"clone","","",303,{"inputs":[{"name":"self"}],"output":{"name":"level"}}],[11,"eq","","",303,{"inputs":[{"name":"self"},{"name":"level"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",303,{"inputs":[{"name":"self"},{"name":"level"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"assert_receiver_is_total_eq","","",303,null],[11,"cmp","","",303,{"inputs":[{"name":"self"},{"name":"level"}],"output":{"name":"ordering"}}],[11,"fmt","","",303,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",303,null],[11,"hash_stable","","",303,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"as_str","","Convert a level to a lower-case string.",303,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"from_str","","Convert a lower-case string to a level.",303,{"inputs":[{"name":"str"}],"output":{"generics":["level"],"name":"option"}}],[11,"clone","","",304,{"inputs":[{"name":"self"}],"output":{"name":"lintsource"}}],[11,"eq","","",304,{"inputs":[{"name":"self"},{"name":"lintsource"}],"output":{"name":"bool"}}],[11,"ne","","",304,{"inputs":[{"name":"self"},{"name":"lintsource"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",304,null],[11,"hash_stable","","",304,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"new","","",301,{"inputs":[],"output":{"name":"lintbuffer"}}],[11,"add_lint","","",301,{"inputs":[{"name":"self"},{"name":"lint"},{"name":"nodeid"},{"name":"multispan"},{"name":"str"},{"name":"builtinlintdiagnostics"}],"output":null}],[11,"take","","",301,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"generics":["bufferedearlylint"],"name":"vec"}}],[11,"get_any","","",301,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"with_lint_attrs","","",302,null],[11,"nested_visit_map","","",302,{"inputs":[{"name":"self"}],"output":{"name":"nestedvisitormap"}}],[11,"visit_item","","",302,{"inputs":[{"name":"self"},{"name":"item"}],"output":null}],[11,"visit_foreign_item","","",302,{"inputs":[{"name":"self"},{"name":"foreignitem"}],"output":null}],[11,"visit_expr","","",302,{"inputs":[{"name":"self"},{"name":"expr"}],"output":null}],[11,"visit_struct_field","","",302,{"inputs":[{"name":"self"},{"name":"structfield"}],"output":null}],[11,"visit_variant","","",302,{"inputs":[{"name":"self"},{"name":"variant"},{"name":"generics"},{"name":"nodeid"}],"output":null}],[11,"visit_local","","",302,{"inputs":[{"name":"self"},{"name":"local"}],"output":null}],[11,"visit_trait_item","","",302,{"inputs":[{"name":"self"},{"name":"traititem"}],"output":null}],[11,"visit_impl_item","","",302,{"inputs":[{"name":"self"},{"name":"implitem"}],"output":null}],[0,"middle","rustc","",null,null],[0,"allocator","rustc::middle","",null,null],[4,"AllocatorKind","rustc::middle::allocator","",null,null],[13,"Global","","",319,null],[13,"DefaultLib","","",319,null],[13,"DefaultExe","","",319,null],[11,"clone","","",319,{"inputs":[{"name":"self"}],"output":{"name":"allocatorkind"}}],[11,"fn_name","","",319,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"string"}}],[0,"borrowck","rustc::middle","",null,null],[3,"BorrowCheckResult","rustc::middle::borrowck","",null,null],[12,"used_mut_nodes","","",320,null],[11,"fmt","","",320,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",320,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",320,{"inputs":[{"name":"__d"}],"output":{"generics":["borrowcheckresult"],"name":"result"}}],[11,"hash_stable","","",320,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[0,"expr_use_visitor","rustc::middle","A different sort of visitor for walking fn bodies.  Unlike the normal visitor, which just walks the entire body in one shot, the `ExprUseVisitor` determines how expressions are being used.",null,null],[3,"ExprUseVisitor","rustc::middle::expr_use_visitor","",null,null],[12,"mc","","",321,null],[12,"delegate","","",321,null],[12,"param_env","","",321,null],[4,"LoanCause","","",null,null],[13,"ClosureCapture","","",322,null],[13,"AddrOf","","",322,null],[13,"AutoRef","","",322,null],[13,"AutoUnsafe","","",322,null],[13,"RefBinding","","",322,null],[13,"OverloadedOperator","","",322,null],[13,"ClosureInvocation","","",322,null],[13,"ForLoop","","",322,null],[13,"MatchDiscriminant","","",322,null],[4,"ConsumeMode","","",null,null],[13,"Copy","","",323,null],[13,"Move","","",323,null],[4,"MoveReason","","",null,null],[13,"DirectRefMove","","",324,null],[13,"PatBindingMove","","",324,null],[13,"CaptureMove","","",324,null],[4,"MatchMode","","",null,null],[13,"NonBindingMatch","","",325,null],[13,"BorrowingMatch","","",325,null],[13,"CopyingMatch","","",325,null],[13,"MovingMatch","","",325,null],[4,"TrackMatchMode","","",null,null],[13,"Unknown","","",326,null],[13,"Definite","","",326,null],[13,"Conflicting","","",326,null],[4,"MutateMode","","",null,null],[13,"Init","","",327,null],[13,"JustWrite","","",327,null],[13,"WriteAndRead","","",327,null],[4,"OverloadedCallType","","",null,null],[13,"FnOverloadedCall","","",328,null],[13,"FnMutOverloadedCall","","",328,null],[13,"FnOnceOverloadedCall","","",328,null],[5,"copy_or_move","","",null,{"inputs":[{"name":"memcategorizationcontext"},{"name":"paramenv"},{"name":"cmt_"},{"name":"movereason"}],"output":{"name":"consumemode"}}],[8,"Delegate","","This trait defines the callbacks you can expect to receive when employing the ExprUseVisitor.",null,null],[10,"consume","","",329,{"inputs":[{"name":"self"},{"name":"nodeid"},{"name":"span"},{"name":"cmt_"},{"name":"consumemode"}],"output":null}],[10,"matched_pat","","",329,{"inputs":[{"name":"self"},{"name":"pat"},{"name":"cmt_"},{"name":"matchmode"}],"output":null}],[10,"consume_pat","","",329,{"inputs":[{"name":"self"},{"name":"pat"},{"name":"cmt_"},{"name":"consumemode"}],"output":null}],[10,"borrow","","",329,{"inputs":[{"name":"self"},{"name":"nodeid"},{"name":"span"},{"name":"cmt_"},{"name":"region"},{"name":"borrowkind"},{"name":"loancause"}],"output":null}],[10,"decl_without_init","","",329,{"inputs":[{"name":"self"},{"name":"nodeid"},{"name":"span"}],"output":null}],[10,"mutate","","",329,{"inputs":[{"name":"self"},{"name":"nodeid"},{"name":"span"},{"name":"cmt_"},{"name":"mutatemode"}],"output":null}],[11,"clone","","",322,{"inputs":[{"name":"self"}],"output":{"name":"loancause"}}],[11,"eq","","",322,{"inputs":[{"name":"self"},{"name":"loancause"}],"output":{"name":"bool"}}],[11,"ne","","",322,{"inputs":[{"name":"self"},{"name":"loancause"}],"output":{"name":"bool"}}],[11,"fmt","","",322,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",323,{"inputs":[{"name":"self"}],"output":{"name":"consumemode"}}],[11,"eq","","",323,{"inputs":[{"name":"self"},{"name":"consumemode"}],"output":{"name":"bool"}}],[11,"ne","","",323,{"inputs":[{"name":"self"},{"name":"consumemode"}],"output":{"name":"bool"}}],[11,"fmt","","",323,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",324,{"inputs":[{"name":"self"}],"output":{"name":"movereason"}}],[11,"eq","","",324,{"inputs":[{"name":"self"},{"name":"movereason"}],"output":{"name":"bool"}}],[11,"fmt","","",324,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",325,{"inputs":[{"name":"self"}],"output":{"name":"matchmode"}}],[11,"eq","","",325,{"inputs":[{"name":"self"},{"name":"matchmode"}],"output":{"name":"bool"}}],[11,"fmt","","",325,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",326,{"inputs":[{"name":"self"}],"output":{"name":"trackmatchmode"}}],[11,"eq","","",326,{"inputs":[{"name":"self"},{"name":"trackmatchmode"}],"output":{"name":"bool"}}],[11,"ne","","",326,{"inputs":[{"name":"self"},{"name":"trackmatchmode"}],"output":{"name":"bool"}}],[11,"fmt","","",326,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"lub","","",326,{"inputs":[{"name":"self"},{"name":"matchmode"}],"output":null}],[11,"match_mode","","",326,{"inputs":[{"name":"self"}],"output":{"name":"matchmode"}}],[11,"clone","","",327,{"inputs":[{"name":"self"}],"output":{"name":"mutatemode"}}],[11,"eq","","",327,{"inputs":[{"name":"self"},{"name":"mutatemode"}],"output":{"name":"bool"}}],[11,"fmt","","",327,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",328,{"inputs":[{"name":"self"}],"output":{"name":"overloadedcalltype"}}],[11,"from_trait_id","","",328,{"inputs":[{"name":"tyctxt"},{"name":"defid"}],"output":{"name":"overloadedcalltype"}}],[11,"from_method_id","","",328,{"inputs":[{"name":"tyctxt"},{"name":"defid"}],"output":{"name":"overloadedcalltype"}}],[11,"new","","Creates the ExprUseVisitor, configuring it with the various options provided:",321,{"inputs":[{"name":"delegate"},{"name":"tyctxt"},{"name":"paramenv"},{"name":"scopetree"},{"name":"typecktables"},{"generics":["lrc"],"name":"option"}],"output":{"name":"self"}}],[11,"with_infer","","",321,{"inputs":[{"name":"delegate"},{"name":"inferctxt"},{"name":"paramenv"},{"name":"scopetree"},{"name":"typecktables"}],"output":{"name":"self"}}],[11,"consume_body","","",321,{"inputs":[{"name":"self"},{"name":"body"}],"output":null}],[11,"tcx","","",321,{"inputs":[{"name":"self"}],"output":{"name":"tyctxt"}}],[11,"delegate_consume","","",321,{"inputs":[{"name":"self"},{"name":"nodeid"},{"name":"span"},{"name":"cmt_"}],"output":null}],[11,"consume_exprs","","",321,null],[11,"consume_expr","","",321,{"inputs":[{"name":"self"},{"name":"expr"}],"output":null}],[11,"mutate_expr","","",321,{"inputs":[{"name":"self"},{"name":"expr"},{"name":"expr"},{"name":"mutatemode"}],"output":null}],[11,"borrow_expr","","",321,{"inputs":[{"name":"self"},{"name":"expr"},{"name":"region"},{"name":"borrowkind"},{"name":"loancause"}],"output":null}],[11,"select_from_expr","","",321,{"inputs":[{"name":"self"},{"name":"expr"}],"output":null}],[11,"walk_expr","","",321,{"inputs":[{"name":"self"},{"name":"expr"}],"output":null}],[11,"walk_callee","","",321,{"inputs":[{"name":"self"},{"name":"expr"},{"name":"expr"}],"output":null}],[11,"walk_stmt","","",321,{"inputs":[{"name":"self"},{"name":"stmt"}],"output":null}],[11,"walk_local","","",321,{"inputs":[{"name":"self"},{"name":"local"}],"output":null}],[11,"walk_block","","Indicates that the value of `blk` will be consumed, meaning either copied or moved depending on its type.",321,{"inputs":[{"name":"self"},{"name":"block"}],"output":null}],[11,"walk_struct_expr","","",321,null],[11,"walk_adjustment","","",321,{"inputs":[{"name":"self"},{"name":"expr"}],"output":null}],[11,"walk_autoref","","Walks the autoref `autoref` applied to the autoderef'd `expr`. `cmt_base` is the mem-categorized form of `expr` after all relevant autoderefs have occurred.",321,{"inputs":[{"name":"self"},{"name":"expr"},{"name":"cmt_"},{"name":"autoborrow"}],"output":null}],[11,"arm_move_mode","","",321,{"inputs":[{"name":"self"},{"name":"cmt"},{"name":"arm"}],"output":{"name":"trackmatchmode"}}],[11,"walk_arm","","",321,{"inputs":[{"name":"self"},{"name":"cmt"},{"name":"arm"},{"name":"matchmode"}],"output":null}],[11,"walk_irrefutable_pat","","Walks a pat that occurs in isolation (i.e. top-level of fn arg or let binding.  Not a match arm or nested pat.)",321,{"inputs":[{"name":"self"},{"name":"cmt"},{"name":"pat"}],"output":null}],[11,"determine_pat_move_mode","","Identifies any bindings within `pat` and accumulates within `mode` whether the overall pattern/match structure is a move, copy, or borrow.",321,{"inputs":[{"name":"self"},{"name":"cmt"},{"name":"pat"},{"name":"trackmatchmode"}],"output":null}],[11,"walk_pat","","The core driver for walking a pattern; `match_mode` must be established up front, e.g. via `determine_pat_move_mode` (see also `walk_irrefutable_pat` for patterns that stand alone).",321,{"inputs":[{"name":"self"},{"name":"cmt"},{"name":"pat"},{"name":"matchmode"}],"output":null}],[11,"walk_captures","","",321,{"inputs":[{"name":"self"},{"name":"expr"},{"name":"span"}],"output":null}],[11,"cat_captured_var","","",321,{"inputs":[{"name":"self"},{"name":"nodeid"},{"name":"span"},{"name":"freevar"}],"output":{"generics":["cmt_"],"name":"mcresult"}}],[0,"const_val","rustc::middle","",null,null],[3,"ConstEvalErr","rustc::middle::const_val","",null,null],[12,"span","","",330,null],[12,"kind","","",330,null],[3,"FrameInfo","","",null,null],[12,"span","","",331,null],[12,"location","","",331,null],[4,"ConstVal","","",null,null],[13,"Unevaluated","","",332,null],[13,"Value","","",332,null],[4,"ErrKind","","",null,null],[13,"NonConstPath","","",333,null],[13,"UnimplementedConstVal","","",333,null],[13,"IndexOutOfBounds","","",333,null],[12,"len","rustc::middle::const_val::ErrKind","",333,null],[12,"index","","",333,null],[13,"LayoutError","rustc::middle::const_val","",333,null],[13,"TypeckError","","",333,null],[13,"CheckMatchError","","",333,null],[13,"Miri","","",333,null],[4,"ConstEvalErrDescription","","",null,null],[13,"Simple","","",334,null],[13,"Backtrace","","",334,null],[5,"struct_error","","",null,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"str"}],"output":{"name":"diagnosticbuilder"}}],[6,"EvalResult","","",null,null],[11,"clone","","",332,{"inputs":[{"name":"self"}],"output":{"name":"constval"}}],[11,"fmt","","",332,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",332,null],[11,"encode","","",332,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",332,{"inputs":[{"name":"__d"}],"output":{"generics":["constval"],"name":"result"}}],[11,"assert_receiver_is_total_eq","","",332,null],[11,"eq","","",332,{"inputs":[{"name":"self"},{"name":"constval"}],"output":{"name":"bool"}}],[11,"ne","","",332,{"inputs":[{"name":"self"},{"name":"constval"}],"output":{"name":"bool"}}],[11,"to_raw_bits","","",332,{"inputs":[{"name":"self"}],"output":{"generics":["u128"],"name":"option"}}],[11,"unwrap_u64","","",332,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"clone","","",330,{"inputs":[{"name":"self"}],"output":{"name":"constevalerr"}}],[11,"fmt","","",330,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",333,{"inputs":[{"name":"self"}],"output":{"name":"errkind"}}],[11,"fmt","","",333,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",331,{"inputs":[{"name":"self"}],"output":{"name":"frameinfo"}}],[11,"fmt","","",331,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",334,{"inputs":[{"name":"self"}],"output":{"name":"constevalerrdescription"}}],[11,"fmt","","",334,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"into_oneline","","Return a one-line description of the error, for lints and such",334,{"inputs":[{"name":"self"}],"output":{"generics":["str"],"name":"cow"}}],[11,"description","","",330,{"inputs":[{"name":"self"}],"output":{"name":"constevalerrdescription"}}],[11,"struct_error","","",330,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"span"},{"name":"str"}],"output":{"name":"diagnosticbuilder"}}],[11,"note","","",330,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"span"},{"name":"str"},{"name":"diagnosticbuilder"}],"output":null}],[11,"report","","",330,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"span"},{"name":"str"}],"output":null}],[0,"cstore","rustc::middle","the rustc crate store interface. This also includes types that are mostly used as a part of that interface, but these should probably get a better home if someone can find one.",null,null],[3,"LinkMeta","rustc::middle::cstore","",null,null],[12,"crate_hash","","",335,null],[3,"CrateSource","","Where a crate came from on the local filesystem. One of these three options must be non-None.",null,null],[12,"dylib","","",336,null],[12,"rlib","","",336,null],[12,"rmeta","","",336,null],[3,"NativeLibrary","","",null,null],[12,"kind","","",337,null],[12,"name","","",337,null],[12,"cfg","","",337,null],[12,"foreign_module","","",337,null],[3,"ForeignModule","","",null,null],[12,"foreign_items","","",338,null],[12,"def_id","","",338,null],[3,"ExternCrate","","",null,null],[12,"src","","",339,null],[12,"span","","span of the extern crate that caused this to be loaded",339,null],[12,"path_len","","Number of links to reach the extern; used to select the extern with the shortest path",339,null],[12,"direct","","If true, then this crate is the crate named by the extern crate referenced above. If false, then this crate is a dep of the crate.",339,null],[3,"EncodedMetadata","","",null,null],[12,"raw_data","","",340,null],[3,"DummyCrateStore","","A dummy crate store that does not support any non-local crates, for test purposes.",null,null],[4,"DepKind","","",null,null],[13,"UnexportedMacrosOnly","","A dependency that is only used for its macros, none of which are visible from other crates. These are included in the metadata only as placeholders and are ignored when decoding.",341,null],[13,"MacrosOnly","","A dependency that is only used for its macros.",341,null],[13,"Implicit","","A dependency that is always injected into the dependency list and so doesn't need to be linked to an rlib, e.g. the injected allocator.",341,null],[13,"Explicit","","A dependency that is required by an rlib version of this crate. Ordinary `extern crate`s result in `Explicit` dependencies.",341,null],[4,"LibSource","","",null,null],[13,"Some","","",342,null],[13,"MetadataOnly","","",342,null],[13,"None","","",342,null],[4,"LinkagePreference","","",null,null],[13,"RequireDynamic","","",343,null],[13,"RequireStatic","","",343,null],[4,"NativeLibraryKind","","",null,null],[13,"NativeStatic","","native static library (.a archive)",344,null],[13,"NativeStaticNobundle","","native static library, which doesn't get bundled into .rlibs",344,null],[13,"NativeFramework","","macOS-specific",344,null],[13,"NativeUnknown","","default way to specify a dynamic library",344,null],[4,"LoadedMacro","","",null,null],[13,"MacroDef","","",345,null],[13,"ProcMacro","","",345,null],[4,"ExternCrateSource","","",null,null],[13,"Extern","","Crate is loaded by `extern crate`.",346,null],[13,"Use","","",346,null],[13,"Path","","Crate is implicitly loaded by an absolute or an `extern::` path.",346,null],[5,"validate_crate_name","","",null,{"inputs":[{"generics":["session"],"name":"option"},{"name":"str"},{"generics":["span"],"name":"option"}],"output":null}],[5,"used_crates","","",null,{"inputs":[{"name":"tyctxt"},{"name":"linkagepreference"}],"output":{"name":"vec"}}],[8,"MetadataLoader","","The backend's way to give the crate store access to the metadata in a library. Note that it returns the raw metadata bytes stored in the library file, whether it is compressed, uncompressed, some weird mix, etc. rmeta files are backend independent and not handled here.",null,null],[10,"get_rlib_metadata","","",347,{"inputs":[{"name":"self"},{"name":"target"},{"name":"path"}],"output":{"generics":["metadataref","string"],"name":"result"}}],[10,"get_dylib_metadata","","",347,{"inputs":[{"name":"self"},{"name":"target"},{"name":"path"}],"output":{"generics":["metadataref","string"],"name":"result"}}],[8,"CrateStore","","A store of Rust crates, through with their metadata can be accessed.",null,null],[10,"crate_data_as_rc_any","","",348,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["any"],"name":"lrc"}}],[10,"metadata_loader","","",348,{"inputs":[{"name":"self"}],"output":{"name":"metadataloader"}}],[10,"def_key","","",348,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"defkey"}}],[10,"def_path","","",348,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"defpath"}}],[10,"def_path_hash","","",348,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"defpathhash"}}],[10,"def_path_table","","",348,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["defpathtable"],"name":"lrc"}}],[10,"visibility_untracked","","",348,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"visibility"}}],[10,"export_macros_untracked","","",348,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":null}],[10,"dep_kind_untracked","","",348,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"depkind"}}],[10,"crate_name_untracked","","",348,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"symbol"}}],[10,"crate_disambiguator_untracked","","",348,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"cratedisambiguator"}}],[10,"crate_hash_untracked","","",348,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"svh"}}],[10,"struct_field_names_untracked","","",348,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["name"],"name":"vec"}}],[10,"item_children_untracked","","",348,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"session"}],"output":{"generics":["export"],"name":"vec"}}],[10,"load_macro_untracked","","",348,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"session"}],"output":{"name":"loadedmacro"}}],[10,"extern_mod_stmt_cnum_untracked","","",348,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"generics":["cratenum"],"name":"option"}}],[10,"item_generics_cloned_untracked","","",348,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"session"}],"output":{"name":"generics"}}],[10,"associated_item_cloned_untracked","","",348,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"associateditem"}}],[10,"postorder_cnums_untracked","","",348,{"inputs":[{"name":"self"}],"output":{"generics":["cratenum"],"name":"vec"}}],[10,"crates_untracked","","",348,{"inputs":[{"name":"self"}],"output":{"generics":["cratenum"],"name":"vec"}}],[10,"encode_metadata","","",348,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"linkmeta"}],"output":{"name":"encodedmetadata"}}],[10,"metadata_encoding_version","","",348,null],[8,"CrateLoader","","",null,null],[10,"process_extern_crate","","",349,{"inputs":[{"name":"self"},{"name":"item"},{"name":"definitions"}],"output":{"name":"cratenum"}}],[10,"process_path_extern","","",349,{"inputs":[{"name":"self"},{"name":"symbol"},{"name":"span"}],"output":{"name":"cratenum"}}],[10,"process_use_extern","","",349,{"inputs":[{"name":"self"},{"name":"symbol"},{"name":"span"},{"name":"nodeid"},{"name":"definitions"}],"output":{"name":"cratenum"}}],[10,"postprocess","","",349,{"inputs":[{"name":"self"},{"name":"crate"}],"output":null}],[11,"clone","","",335,{"inputs":[{"name":"self"}],"output":{"name":"linkmeta"}}],[11,"fmt","","",335,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",336,{"inputs":[{"name":"self"},{"name":"cratesource"}],"output":{"name":"bool"}}],[11,"ne","","",336,{"inputs":[{"name":"self"},{"name":"cratesource"}],"output":{"name":"bool"}}],[11,"clone","","",336,{"inputs":[{"name":"self"}],"output":{"name":"cratesource"}}],[11,"fmt","","",336,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",341,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",341,{"inputs":[{"name":"__d"}],"output":{"generics":["depkind"],"name":"result"}}],[11,"clone","","",341,{"inputs":[{"name":"self"}],"output":{"name":"depkind"}}],[11,"cmp","","",341,{"inputs":[{"name":"self"},{"name":"depkind"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",341,{"inputs":[{"name":"self"},{"name":"depkind"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"assert_receiver_is_total_eq","","",341,null],[11,"eq","","",341,{"inputs":[{"name":"self"},{"name":"depkind"}],"output":{"name":"bool"}}],[11,"fmt","","",341,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"macros_only","","",341,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"eq","","",342,{"inputs":[{"name":"self"},{"name":"libsource"}],"output":{"name":"bool"}}],[11,"ne","","",342,{"inputs":[{"name":"self"},{"name":"libsource"}],"output":{"name":"bool"}}],[11,"clone","","",342,{"inputs":[{"name":"self"}],"output":{"name":"libsource"}}],[11,"fmt","","",342,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"is_some","","",342,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"option","","",342,{"inputs":[{"name":"self"}],"output":{"generics":["pathbuf"],"name":"option"}}],[11,"fmt","","",343,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",343,{"inputs":[{"name":"self"},{"name":"linkagepreference"}],"output":{"name":"bool"}}],[11,"clone","","",343,{"inputs":[{"name":"self"}],"output":{"name":"linkagepreference"}}],[11,"encode","","",343,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",343,{"inputs":[{"name":"__d"}],"output":{"generics":["linkagepreference"],"name":"result"}}],[11,"clone","","",344,{"inputs":[{"name":"self"}],"output":{"name":"nativelibrarykind"}}],[11,"eq","","",344,{"inputs":[{"name":"self"},{"name":"nativelibrarykind"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",344,null],[11,"partial_cmp","","",344,{"inputs":[{"name":"self"},{"name":"nativelibrarykind"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"cmp","","",344,{"inputs":[{"name":"self"},{"name":"nativelibrarykind"}],"output":{"name":"ordering"}}],[11,"hash","","",344,null],[11,"encode","","",344,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",344,{"inputs":[{"name":"__d"}],"output":{"generics":["nativelibrarykind"],"name":"result"}}],[11,"clone","","",337,{"inputs":[{"name":"self"}],"output":{"name":"nativelibrary"}}],[11,"hash","","",337,null],[11,"encode","","",337,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",337,{"inputs":[{"name":"__d"}],"output":{"generics":["nativelibrary"],"name":"result"}}],[11,"clone","","",338,{"inputs":[{"name":"self"}],"output":{"name":"foreignmodule"}}],[11,"hash","","",338,null],[11,"encode","","",338,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",338,{"inputs":[{"name":"__d"}],"output":{"generics":["foreignmodule"],"name":"result"}}],[11,"clone","","",339,{"inputs":[{"name":"self"}],"output":{"name":"externcrate"}}],[11,"fmt","","",339,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",346,{"inputs":[{"name":"self"}],"output":{"name":"externcratesource"}}],[11,"fmt","","",346,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","",340,{"inputs":[],"output":{"name":"encodedmetadata"}}],[11,"crate_data_as_rc_any","","",350,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["any"],"name":"lrc"}}],[11,"visibility_untracked","","",350,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"visibility"}}],[11,"item_generics_cloned_untracked","","",350,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"session"}],"output":{"name":"generics"}}],[11,"associated_item_cloned_untracked","","",350,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"associateditem"}}],[11,"dep_kind_untracked","","",350,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"depkind"}}],[11,"export_macros_untracked","","",350,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":null}],[11,"crate_name_untracked","","",350,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"symbol"}}],[11,"crate_disambiguator_untracked","","",350,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"cratedisambiguator"}}],[11,"crate_hash_untracked","","",350,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"name":"svh"}}],[11,"def_key","","",350,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"defkey"}}],[11,"def_path","","",350,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"defpath"}}],[11,"def_path_hash","","",350,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"defpathhash"}}],[11,"def_path_table","","",350,{"inputs":[{"name":"self"},{"name":"cratenum"}],"output":{"generics":["defpathtable"],"name":"lrc"}}],[11,"struct_field_names_untracked","","",350,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["name"],"name":"vec"}}],[11,"item_children_untracked","","",350,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"session"}],"output":{"generics":["export"],"name":"vec"}}],[11,"load_macro_untracked","","",350,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"session"}],"output":{"name":"loadedmacro"}}],[11,"crates_untracked","","",350,{"inputs":[{"name":"self"}],"output":{"generics":["cratenum"],"name":"vec"}}],[11,"extern_mod_stmt_cnum_untracked","","",350,{"inputs":[{"name":"self"},{"name":"nodeid"}],"output":{"generics":["cratenum"],"name":"option"}}],[11,"encode_metadata","","",350,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"linkmeta"}],"output":{"name":"encodedmetadata"}}],[11,"metadata_encoding_version","","",350,null],[11,"postorder_cnums_untracked","","",350,{"inputs":[{"name":"self"}],"output":{"generics":["cratenum"],"name":"vec"}}],[11,"metadata_loader","","",350,{"inputs":[{"name":"self"}],"output":{"name":"metadataloader"}}],[0,"dataflow","rustc::middle","A module for propagating forward dataflow information. The analysis assumes that the items to be propagated can be represented as bits and thus uses bitvectors. Your job is simply to specify the so-called GEN and KILL bits for each expression.",null,null],[3,"DataFlowContext","rustc::middle::dataflow","",null,null],[12,"tcx","","",351,null],[12,"analysis_name","","a name for the analysis using this dataflow instance",351,null],[12,"oper","","the data flow operator",351,null],[12,"bits_per_id","","number of bits to propagate per id",351,null],[12,"words_per_id","","number of words we will use to store bits_per_id. equal to bits_per_id/usize::BITS rounded up.",351,null],[12,"local_id_to_index","","",351,null],[12,"gens","","bits generated as we exit the cfg node. Updated by `add_gen()`.",351,null],[12,"scope_kills","","bits killed as we exit the cfg node, or non-locally jump over it. Updated by `add_kill(KillFrom::ScopeEnd)`.",351,null],[12,"action_kills","","bits killed as we exit the cfg node directly; if it is jumped over, e.g. via `break`, the kills are not reflected in the jump's effects. Updated by `add_kill(KillFrom::Execution)`.",351,null],[12,"on_entry","","bits that are valid on entry to the cfg node. Updated by `propagate()`.",351,null],[3,"PropagationContext","","",null,null],[12,"dfcx","","",352,null],[12,"changed","","",352,null],[3,"Union","","",null,null],[3,"Subtract","","",null,null],[4,"EntryOrExit","","",null,null],[13,"Entry","","",353,null],[13,"Exit","","",353,null],[4,"KillFrom","","Flag used by `add_kill` to indicate whether the provided kill takes effect only when control flows directly through the node in question, or if the kill's effect is associated with any control-flow directly through or indirectly over the node.",null,null],[13,"ScopeEnd","","A `ScopeEnd` kill is one that takes effect when any control flow goes over the node. A kill associated with the end of the scope of a variable declaration `let x;` is an example of a `ScopeEnd` kill.",354,null],[13,"Execution","","An `Execution` kill is one that takes effect only when control flow goes through the node to completion. A kill associated with an assignment statement `x = expr;` is an example of an `Execution` kill.",354,null],[5,"get_cfg_indices","","",null,null],[5,"build_local_id_to_index","","",null,{"inputs":[{"generics":["body"],"name":"option"},{"name":"cfg"}],"output":{"generics":["itemlocalid","vec"],"name":"fxhashmap"}}],[5,"mut_bits_to_string","","",null,null],[5,"bits_to_string","","",null,null],[5,"bitwise","","",null,null],[5,"set_bit","","",null,null],[5,"bit_str","","",null,{"inputs":[{"name":"usize"}],"output":{"name":"string"}}],[8,"BitwiseOperator","","",null,null],[10,"join","","Joins two predecessor bits together, typically either `|` or `&`",355,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"usize"}],"output":{"name":"usize"}}],[8,"DataFlowOperator","","Parameterization for the precise form of data flow that is used.",null,null],[10,"initial_value","","Specifies the initial value for each bit in the `on_entry` set",356,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",353,{"inputs":[{"name":"self"}],"output":{"name":"entryorexit"}}],[11,"fmt","","",353,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",351,{"inputs":[{"name":"self"}],"output":{"name":"dataflowcontext"}}],[11,"has_bitset_for_local_id","","",351,{"inputs":[{"name":"self"},{"name":"itemlocalid"}],"output":{"name":"bool"}}],[11,"nested","","",351,{"inputs":[{"name":"self"},{"name":"state"},{"name":"nested"}],"output":{"name":"result"}}],[11,"pre","","",351,{"inputs":[{"name":"self"},{"name":"state"},{"name":"annnode"}],"output":{"name":"result"}}],[11,"clone","","",354,{"inputs":[{"name":"self"}],"output":{"name":"killfrom"}}],[11,"eq","","",354,{"inputs":[{"name":"self"},{"name":"killfrom"}],"output":{"name":"bool"}}],[11,"fmt","","",354,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","",351,{"inputs":[{"name":"tyctxt"},{"name":"str"},{"generics":["body"],"name":"option"},{"name":"cfg"},{"name":"o"},{"name":"idrange"},{"name":"usize"}],"output":{"name":"dataflowcontext"}}],[11,"add_gen","","Indicates that `id` generates `bit`",351,{"inputs":[{"name":"self"},{"name":"itemlocalid"},{"name":"usize"}],"output":null}],[11,"add_kill","","Indicates that `id` kills `bit`",351,{"inputs":[{"name":"self"},{"name":"killfrom"},{"name":"itemlocalid"},{"name":"usize"}],"output":null}],[11,"apply_gen_kill","","Applies the gen and kill sets for `cfgidx` to `bits`",351,null],[11,"compute_id_range","","",351,null],[11,"each_bit_on_entry","","Iterates through each bit that is set on entry to `id`. Only useful after `propagate()` has been called.",351,{"inputs":[{"name":"self"},{"name":"itemlocalid"},{"name":"f"}],"output":{"name":"bool"}}],[11,"each_bit_for_node","","Iterates through each bit that is set on entry/exit to `cfgidx`. Only useful after `propagate()` has been called.",351,{"inputs":[{"name":"self"},{"name":"entryorexit"},{"name":"cfgindex"},{"name":"f"}],"output":{"name":"bool"}}],[11,"each_gen_bit","","Iterates through each bit in the gen set for `id`.",351,{"inputs":[{"name":"self"},{"name":"itemlocalid"},{"name":"f"}],"output":{"name":"bool"}}],[11,"each_bit","","Helper for iterating over the bits in a bit set. Returns false on the first call to `f` that returns false; if all calls to `f` return true, then returns true.",351,null],[11,"add_kills_from_flow_exits","","Whenever you have a `break` or `continue` statement, flow exits through any number of enclosing scopes on its way to the new destination. This function infers the kill bits of those control operators based on the kill bits associated with those scopes.",351,{"inputs":[{"name":"self"},{"name":"cfg"}],"output":null}],[11,"propagate","","Performs the data flow analysis.",351,{"inputs":[{"name":"self"},{"name":"cfg"},{"name":"body"}],"output":null}],[11,"walk_cfg","","",352,null],[11,"reset","","",352,null],[11,"propagate_bits_into_graph_successors_of","","",352,null],[11,"propagate_bits_into_entry_set_for","","",352,null],[11,"join","","",357,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"usize"}],"output":{"name":"usize"}}],[11,"join","","",358,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"usize"}],"output":{"name":"usize"}}],[0,"dead","rustc::middle","",null,null],[3,"MarkSymbolVisitor","rustc::middle::dead","",null,null],[12,"worklist","","",359,null],[12,"tcx","","",359,null],[12,"tables","","",359,null],[12,"live_symbols","","",359,null],[12,"repr_has_repr_c","","",359,null],[12,"in_pat","","",359,null],[12,"inherited_pub_visibility","","",359,null],[12,"ignore_variant_stack","","",359,null],[3,"LifeSeeder","","",null,null],[12,"worklist","","",360,null],[12,"krate","","",360,null],[12,"tcx","","",360,null],[3,"DeadVisitor","","",null,null],[12,"tcx","","",361,null],[12,"live_symbols","","",361,null],[5,"should_explore","","",null,{"inputs":[{"name":"tyctxt"},{"name":"nodeid"}],"output":{"name":"bool"}}],[5,"has_allow_dead_code_or_lang_attr","","",null,null],[5,"create_and_seed_worklist","","",null,{"inputs":[{"name":"tyctxt"},{"name":"accesslevels"},{"name":"crate"}],"output":{"generics":["nodeid"],"name":"vec"}}],[5,"find_live","","",null,{"inputs":[{"name":"tyctxt"},{"name":"accesslevels"},{"name":"crate"}],"output":{"generics":["fxhashset"],"name":"box"}}],[5,"get_struct_ctor_id","","",null,{"inputs":[{"name":"item"}],"output":{"generics":["nodeid"],"name":"option"}}],[5,"check_crate","","",null,{"inputs":[{"name":"tyctxt"}],"output":null}],[11,"check_def_id","","",359,{"inputs":[{"name":"self"},{"name":"defid"}],"output":null}],[11,"insert_def_id","","",359,{"inputs":[{"name":"self"},{"name":"defid"}],"output":null}],[11,"handle_definition","","",359,{"inputs":[{"name":"self"},{"name":"def"}],"output":null}],[11,"lookup_and_handle_method","","",359,{"inputs":[{"name":"self"},{"name":"hirid"}],"output":null}],[11,"handle_field_access","","",359,{"inputs":[{"name":"self"},{"name":"expr"},{"name":"nodeid"}],"output":null}],[11,"handle_field_pattern_match","","",359,null],[11,"mark_live_symbols","","",359,{"inputs":[{"name":"self"}],"output":null}],[11,"visit_node","","",359,{"inputs":[{"name":"self"},{"name":"node"}],"output":null}],[11,"mark_as_used_if_union","","",359,{"inputs":[{"name":"self"},{"name":"adtdef"},{"name":"hirvec"}],"output":null}],[11,"nested_visit_map","","",359,{"inputs":[{"name":"self"}],"output":{"name":"nestedvisitormap"}}],[11,"visit_nested_body","","",359,{"inputs":[{"name":"self"},{"name":"bodyid"}],"output":null}],[11,"visit_variant_data","","",359,{"inputs":[{"name":"self"},{"name":"variantdata"},{"name":"name"},{"name":"generics"},{"name":"nodeid"},{"name":"span"}],"output":null}],[11,"visit_expr","","",359,{"inputs":[{"name":"self"},{"name":"expr"}],"output":null}],[11,"visit_arm","","",359,{"inputs":[{"name":"self"},{"name":"arm"}],"output":null}],[11,"visit_pat","","",359,{"inputs":[{"name":"self"},{"name":"pat"}],"output":null}],[11,"visit_path","","",359,{"inputs":[{"name":"self"},{"name":"path"},{"name":"nodeid"}],"output":null}],[11,"visit_item","","",360,{"inputs":[{"name":"self"},{"name":"item"}],"output":null}],[11,"visit_trait_item","","",360,{"inputs":[{"name":"self"},{"name":"traititem"}],"output":null}],[11,"visit_impl_item","","",360,{"inputs":[{"name":"self"},{"name":"implitem"}],"output":null}],[11,"should_warn_about_item","","",361,{"inputs":[{"name":"self"},{"name":"item"}],"output":{"name":"bool"}}],[11,"should_warn_about_field","","",361,{"inputs":[{"name":"self"},{"name":"structfield"}],"output":{"name":"bool"}}],[11,"should_warn_about_variant","","",361,{"inputs":[{"name":"self"},{"name":"variant_"}],"output":{"name":"bool"}}],[11,"should_warn_about_foreign_item","","",361,{"inputs":[{"name":"self"},{"name":"foreignitem"}],"output":{"name":"bool"}}],[11,"symbol_is_live","","",361,{"inputs":[{"name":"self"},{"name":"nodeid"},{"generics":["nodeid"],"name":"option"}],"output":{"name":"bool"}}],[11,"warn_dead_code","","",361,{"inputs":[{"name":"self"},{"name":"nodeid"},{"name":"span"},{"name":"name"},{"name":"str"},{"name":"str"}],"output":null}],[11,"nested_visit_map","","Walk nested items in place so that we don't report dead-code on inner functions when the outer function is already getting an error. We could do this also by checking the parents, but this is how the code is setup and it seems harmless enough.",361,{"inputs":[{"name":"self"}],"output":{"name":"nestedvisitormap"}}],[11,"visit_item","","",361,{"inputs":[{"name":"self"},{"name":"item"}],"output":null}],[11,"visit_variant","","",361,{"inputs":[{"name":"self"},{"name":"variant"},{"name":"generics"},{"name":"nodeid"}],"output":null}],[11,"visit_foreign_item","","",361,{"inputs":[{"name":"self"},{"name":"foreignitem"}],"output":null}],[11,"visit_struct_field","","",361,{"inputs":[{"name":"self"},{"name":"structfield"}],"output":null}],[11,"visit_impl_item","","",361,{"inputs":[{"name":"self"},{"name":"implitem"}],"output":null}],[11,"visit_trait_item","","",361,{"inputs":[{"name":"self"},{"name":"traititem"}],"output":null}],[0,"dependency_format","rustc::middle","Resolution of mixing rlibs and dylibs",null,null],[4,"Linkage","rustc::middle::dependency_format","",null,null],[13,"NotLinked","","",362,null],[13,"IncludedFromDylib","","",362,null],[13,"Static","","",362,null],[13,"Dynamic","","",362,null],[5,"calculate","","",null,{"inputs":[{"name":"tyctxt"}],"output":null}],[5,"calculate_type","","",null,{"inputs":[{"name":"tyctxt"},{"name":"cratetype"}],"output":{"name":"dependencylist"}}],[5,"add_library","","",null,{"inputs":[{"name":"tyctxt"},{"name":"cratenum"},{"name":"linkagepreference"},{"name":"fxhashmap"}],"output":null}],[5,"attempt_static","","",null,{"inputs":[{"name":"tyctxt"}],"output":{"generics":["dependencylist"],"name":"option"}}],[5,"activate_injected_dep","","",null,{"inputs":[{"generics":["cratenum"],"name":"option"},{"name":"dependencylist"},{"name":"fn"}],"output":null}],[5,"activate_injected_allocator","","",null,{"inputs":[{"name":"session"},{"name":"dependencylist"}],"output":null}],[5,"verify_ok","","",null,null],[6,"DependencyList","","A list of dependencies for a certain crate type.",null,null],[6,"Dependencies","","A mapping of all required dependencies for a particular flavor of output.",null,null],[11,"clone","","",362,{"inputs":[{"name":"self"}],"output":{"name":"linkage"}}],[11,"eq","","",362,{"inputs":[{"name":"self"},{"name":"linkage"}],"output":{"name":"bool"}}],[11,"fmt","","",362,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[0,"entry","rustc::middle","",null,null],[3,"EntryContext","rustc::middle::entry","",null,null],[12,"session","","",363,null],[12,"map","","",363,null],[12,"main_fn","","",363,null],[12,"attr_main_fn","","",363,null],[12,"start_fn","","",363,null],[12,"non_main_fns","","",363,null],[5,"find_entry_point","","",null,{"inputs":[{"name":"session"},{"name":"map"},{"name":"str"}],"output":null}],[5,"entry_point_type","","",null,{"inputs":[{"name":"item"},{"name":"bool"}],"output":{"name":"entrypointtype"}}],[5,"find_item","","",null,{"inputs":[{"name":"item"},{"name":"entrycontext"},{"name":"bool"}],"output":null}],[5,"configure_main","","",null,{"inputs":[{"name":"entrycontext"},{"name":"str"}],"output":null}],[11,"visit_item","","",363,{"inputs":[{"name":"self"},{"name":"item"}],"output":null}],[11,"visit_trait_item","","",363,{"inputs":[{"name":"self"},{"name":"traititem"}],"output":null}],[11,"visit_impl_item","","",363,{"inputs":[{"name":"self"},{"name":"implitem"}],"output":null}],[0,"exported_symbols","rustc::middle","",null,null],[4,"SymbolExportLevel","rustc::middle::exported_symbols","The SymbolExportLevel of a symbols specifies from which kinds of crates the symbol will be exported. `C` symbols will be exported from any kind of crate, including cdylibs which export very few things. `Rust` will only be exported if the crate produced is a Rust dylib.",null,null],[13,"C","","",364,null],[13,"Rust","","",364,null],[4,"ExportedSymbol","","",null,null],[13,"NonGeneric","","",365,null],[13,"Generic","","",365,null],[13,"NoDefId","","",365,null],[5,"metadata_symbol_name","","",null,{"inputs":[{"name":"tyctxt"}],"output":{"name":"string"}}],[11,"assert_receiver_is_total_eq","","",364,null],[11,"eq","","",364,{"inputs":[{"name":"self"},{"name":"symbolexportlevel"}],"output":{"name":"bool"}}],[11,"fmt","","",364,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",364,{"inputs":[{"name":"self"}],"output":{"name":"symbolexportlevel"}}],[11,"encode","","",364,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",364,{"inputs":[{"name":"__d"}],"output":{"generics":["symbolexportlevel"],"name":"result"}}],[11,"hash_stable","","",364,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"is_below_threshold","","",364,{"inputs":[{"name":"self"},{"name":"symbolexportlevel"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",365,null],[11,"eq","","",365,{"inputs":[{"name":"self"},{"name":"exportedsymbol"}],"output":{"name":"bool"}}],[11,"ne","","",365,{"inputs":[{"name":"self"},{"name":"exportedsymbol"}],"output":{"name":"bool"}}],[11,"fmt","","",365,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",365,{"inputs":[{"name":"self"}],"output":{"name":"exportedsymbol"}}],[11,"encode","","",365,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",365,{"inputs":[{"name":"__d"}],"output":{"generics":["exportedsymbol"],"name":"result"}}],[11,"symbol_name","","",365,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"symbolname"}}],[11,"compare_stable","","",365,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"exportedsymbol"}],"output":{"name":"ordering"}}],[11,"hash_stable","","",365,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[0,"free_region","rustc::middle","This file handles the relationships between free regions -- meaning lifetime parameters. Ordinarily, free regions are unrelated to one another, but they can be related via implied or explicit bounds.  In that case, we track the bounds using the `TransitiveRelation` type and use that to decide when one free region outlives another and so forth.",null,null],[3,"RegionRelations","rustc::middle::free_region","Combines a `region::ScopeTree` (which governs relationships between scopes) and a `FreeRegionMap` (which governs relationships between free regions) to yield a complete relation between concrete regions.",null,null],[12,"tcx","","",366,null],[12,"context","","context used to fetch the region maps",366,null],[12,"region_scope_tree","","region maps for the given context",366,null],[12,"free_regions","","free-region relationships",366,null],[11,"new","","",366,{"inputs":[{"name":"tyctxt"},{"name":"defid"},{"name":"scopetree"},{"name":"freeregionmap"}],"output":{"name":"self"}}],[11,"is_subregion_of","","Determines whether one region is a subregion of another.  This is intended to run after inference and sadly the logic is somewhat duplicated with the code in infer.rs.",366,{"inputs":[{"name":"self"},{"name":"region"},{"name":"region"}],"output":{"name":"bool"}}],[11,"is_static","","Determines whether this free-region is required to be 'static",366,{"inputs":[{"name":"self"},{"name":"region"}],"output":{"name":"bool"}}],[11,"lub_free_regions","","",366,{"inputs":[{"name":"self"},{"name":"region"},{"name":"region"}],"output":{"name":"region"}}],[0,"intrinsicck","rustc::middle","",null,null],[3,"ItemVisitor","rustc::middle::intrinsicck","",null,null],[12,"tcx","","",367,null],[3,"ExprVisitor","","",null,null],[12,"tcx","","",368,null],[12,"tables","","",368,null],[12,"param_env","","",368,null],[5,"check_crate","","",null,{"inputs":[{"name":"tyctxt"}],"output":null}],[5,"unpack_option_like","","If the type is `Option<T>`, it will return `T`, otherwise the type itself. Works on most `Option`-like types.",null,{"inputs":[{"name":"tyctxt"},{"name":"ty"}],"output":{"name":"ty"}}],[11,"def_id_is_transmute","","",368,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"bool"}}],[11,"check_transmute","","",368,{"inputs":[{"name":"self"},{"name":"span"},{"name":"ty"},{"name":"ty"}],"output":null}],[11,"nested_visit_map","","",367,{"inputs":[{"name":"self"}],"output":{"name":"nestedvisitormap"}}],[11,"visit_nested_body","","",367,{"inputs":[{"name":"self"},{"name":"bodyid"}],"output":null}],[11,"nested_visit_map","","",368,{"inputs":[{"name":"self"}],"output":{"name":"nestedvisitormap"}}],[11,"visit_expr","","",368,{"inputs":[{"name":"self"},{"name":"expr"}],"output":null}],[0,"lang_items","rustc::middle","",null,null],[3,"LanguageItems","rustc::middle::lang_items","",null,null],[12,"items","","",369,null],[12,"missing","","",369,null],[3,"LanguageItemCollector","","",null,null],[12,"items","","",370,null],[12,"tcx","","",370,null],[12,"item_refs","","",370,null],[4,"LangItem","","",null,null],[13,"CharImplItem","","",371,null],[13,"StrImplItem","","",371,null],[13,"SliceImplItem","","",371,null],[13,"SliceU8ImplItem","","",371,null],[13,"StrAllocImplItem","","",371,null],[13,"SliceAllocImplItem","","",371,null],[13,"SliceU8AllocImplItem","","",371,null],[13,"ConstPtrImplItem","","",371,null],[13,"MutPtrImplItem","","",371,null],[13,"I8ImplItem","","",371,null],[13,"I16ImplItem","","",371,null],[13,"I32ImplItem","","",371,null],[13,"I64ImplItem","","",371,null],[13,"I128ImplItem","","",371,null],[13,"IsizeImplItem","","",371,null],[13,"U8ImplItem","","",371,null],[13,"U16ImplItem","","",371,null],[13,"U32ImplItem","","",371,null],[13,"U64ImplItem","","",371,null],[13,"U128ImplItem","","",371,null],[13,"UsizeImplItem","","",371,null],[13,"F32ImplItem","","",371,null],[13,"F64ImplItem","","",371,null],[13,"F32RuntimeImplItem","","",371,null],[13,"F64RuntimeImplItem","","",371,null],[13,"SizedTraitLangItem","","",371,null],[13,"UnsizeTraitLangItem","","",371,null],[13,"CopyTraitLangItem","","",371,null],[13,"CloneTraitLangItem","","",371,null],[13,"SyncTraitLangItem","","",371,null],[13,"FreezeTraitLangItem","","",371,null],[13,"DropTraitLangItem","","",371,null],[13,"CoerceUnsizedTraitLangItem","","",371,null],[13,"AddTraitLangItem","","",371,null],[13,"SubTraitLangItem","","",371,null],[13,"MulTraitLangItem","","",371,null],[13,"DivTraitLangItem","","",371,null],[13,"RemTraitLangItem","","",371,null],[13,"NegTraitLangItem","","",371,null],[13,"NotTraitLangItem","","",371,null],[13,"BitXorTraitLangItem","","",371,null],[13,"BitAndTraitLangItem","","",371,null],[13,"BitOrTraitLangItem","","",371,null],[13,"ShlTraitLangItem","","",371,null],[13,"ShrTraitLangItem","","",371,null],[13,"AddAssignTraitLangItem","","",371,null],[13,"SubAssignTraitLangItem","","",371,null],[13,"MulAssignTraitLangItem","","",371,null],[13,"DivAssignTraitLangItem","","",371,null],[13,"RemAssignTraitLangItem","","",371,null],[13,"BitXorAssignTraitLangItem","","",371,null],[13,"BitAndAssignTraitLangItem","","",371,null],[13,"BitOrAssignTraitLangItem","","",371,null],[13,"ShlAssignTraitLangItem","","",371,null],[13,"ShrAssignTraitLangItem","","",371,null],[13,"IndexTraitLangItem","","",371,null],[13,"IndexMutTraitLangItem","","",371,null],[13,"UnsafeCellTypeLangItem","","",371,null],[13,"DerefTraitLangItem","","",371,null],[13,"DerefMutTraitLangItem","","",371,null],[13,"FnTraitLangItem","","",371,null],[13,"FnMutTraitLangItem","","",371,null],[13,"FnOnceTraitLangItem","","",371,null],[13,"GeneratorStateLangItem","","",371,null],[13,"GeneratorTraitLangItem","","",371,null],[13,"EqTraitLangItem","","",371,null],[13,"PartialOrdTraitLangItem","","",371,null],[13,"OrdTraitLangItem","","",371,null],[13,"PanicFnLangItem","","",371,null],[13,"PanicBoundsCheckFnLangItem","","",371,null],[13,"PanicFmtLangItem","","",371,null],[13,"ExchangeMallocFnLangItem","","",371,null],[13,"BoxFreeFnLangItem","","",371,null],[13,"DropInPlaceFnLangItem","","",371,null],[13,"OomLangItem","","",371,null],[13,"StartFnLangItem","","",371,null],[13,"EhPersonalityLangItem","","",371,null],[13,"EhUnwindResumeLangItem","","",371,null],[13,"MSVCTryFilterLangItem","","",371,null],[13,"OwnedBoxLangItem","","",371,null],[13,"PhantomDataItem","","",371,null],[13,"NonZeroItem","","",371,null],[13,"DebugTraitLangItem","","",371,null],[13,"I128AddFnLangItem","","",371,null],[13,"U128AddFnLangItem","","",371,null],[13,"I128SubFnLangItem","","",371,null],[13,"U128SubFnLangItem","","",371,null],[13,"I128MulFnLangItem","","",371,null],[13,"U128MulFnLangItem","","",371,null],[13,"I128DivFnLangItem","","",371,null],[13,"U128DivFnLangItem","","",371,null],[13,"I128RemFnLangItem","","",371,null],[13,"U128RemFnLangItem","","",371,null],[13,"I128ShlFnLangItem","","",371,null],[13,"U128ShlFnLangItem","","",371,null],[13,"I128ShrFnLangItem","","",371,null],[13,"U128ShrFnLangItem","","",371,null],[13,"I128AddoFnLangItem","","",371,null],[13,"U128AddoFnLangItem","","",371,null],[13,"I128SuboFnLangItem","","",371,null],[13,"U128SuboFnLangItem","","",371,null],[13,"I128MuloFnLangItem","","",371,null],[13,"U128MuloFnLangItem","","",371,null],[13,"I128ShloFnLangItem","","",371,null],[13,"U128ShloFnLangItem","","",371,null],[13,"I128ShroFnLangItem","","",371,null],[13,"U128ShroFnLangItem","","",371,null],[13,"TerminationTraitLangItem","","",371,null],[5,"extract","","",null,null],[5,"collect","","",null,{"inputs":[{"name":"tyctxt"}],"output":{"name":"languageitems"}}],[11,"fmt","","",371,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",371,{"inputs":[{"name":"self"}],"output":{"name":"langitem"}}],[11,"eq","","",371,{"inputs":[{"name":"self"},{"name":"langitem"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",371,null],[11,"hash","","",371,null],[11,"encode","","",371,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",371,{"inputs":[{"name":"__d"}],"output":{"generics":["langitem"],"name":"result"}}],[11,"from_u32","","",371,{"inputs":[{"name":"u32"}],"output":{"generics":["langitem"],"name":"option"}}],[11,"name","","",371,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"new","","",369,{"inputs":[],"output":{"name":"languageitems"}}],[11,"items","","",369,null],[11,"require","","",369,{"inputs":[{"name":"self"},{"name":"langitem"}],"output":{"generics":["defid","string"],"name":"result"}}],[11,"fn_trait_kind","","",369,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"generics":["closurekind"],"name":"option"}}],[11,"char_impl","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"str_impl","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"slice_impl","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"slice_u8_impl","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"str_alloc_impl","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"slice_alloc_impl","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"slice_u8_alloc_impl","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"const_ptr_impl","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"mut_ptr_impl","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"i8_impl","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"i16_impl","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"i32_impl","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"i64_impl","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"i128_impl","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"isize_impl","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"u8_impl","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"u16_impl","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"u32_impl","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"u64_impl","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"u128_impl","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"usize_impl","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"f32_impl","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"f64_impl","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"f32_runtime_impl","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"f64_runtime_impl","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"sized_trait","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"unsize_trait","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"copy_trait","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"clone_trait","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"sync_trait","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"freeze_trait","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"drop_trait","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"coerce_unsized_trait","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"add_trait","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"sub_trait","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"mul_trait","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"div_trait","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"rem_trait","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"neg_trait","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"not_trait","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"bitxor_trait","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"bitand_trait","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"bitor_trait","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"shl_trait","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"shr_trait","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"add_assign_trait","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"sub_assign_trait","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"mul_assign_trait","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"div_assign_trait","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"rem_assign_trait","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"bitxor_assign_trait","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"bitand_assign_trait","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"bitor_assign_trait","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"shl_assign_trait","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"shr_assign_trait","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"index_trait","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"index_mut_trait","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"unsafe_cell_type","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"deref_trait","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"deref_mut_trait","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"fn_trait","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"fn_mut_trait","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"fn_once_trait","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"gen_state","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"gen_trait","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"eq_trait","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"partial_ord_trait","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"ord_trait","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"panic_fn","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"panic_bounds_check_fn","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"panic_fmt","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"exchange_malloc_fn","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"box_free_fn","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"drop_in_place_fn","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"oom","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"start_fn","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"eh_personality","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"eh_unwind_resume","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"msvc_try_filter","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"owned_box","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"phantom_data","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"non_zero","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"debug_trait","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"i128_add_fn","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"u128_add_fn","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"i128_sub_fn","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"u128_sub_fn","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"i128_mul_fn","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"u128_mul_fn","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"i128_div_fn","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"u128_div_fn","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"i128_rem_fn","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"u128_rem_fn","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"i128_shl_fn","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"u128_shl_fn","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"i128_shr_fn","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"u128_shr_fn","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"i128_addo_fn","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"u128_addo_fn","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"i128_subo_fn","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"u128_subo_fn","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"i128_mulo_fn","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"u128_mulo_fn","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"i128_shlo_fn","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"u128_shlo_fn","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"i128_shro_fn","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"u128_shro_fn","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"termination","","",369,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"visit_item","","",370,{"inputs":[{"name":"self"},{"name":"item"}],"output":null}],[11,"visit_trait_item","","",370,{"inputs":[{"name":"self"},{"name":"traititem"}],"output":null}],[11,"visit_impl_item","","",370,{"inputs":[{"name":"self"},{"name":"implitem"}],"output":null}],[11,"new","","",370,{"inputs":[{"name":"tyctxt"}],"output":{"name":"languageitemcollector"}}],[11,"collect_item","","",370,{"inputs":[{"name":"self"},{"name":"usize"},{"name":"defid"}],"output":null}],[0,"liveness","rustc::middle","A classic liveness analysis based on dataflow over the AST.  Computes, for each local variable in a function, whether that variable is live at a given point.  Program execution points are identified by their id.",null,null],[3,"Variable","rustc::middle::liveness","",null,null],[12,"0","","",372,null],[3,"LiveNode","","",null,null],[12,"0","","",373,null],[3,"CaptureInfo","","",null,null],[12,"ln","","",374,null],[12,"var_nid","","",374,null],[3,"LocalInfo","","",null,null],[12,"id","","",375,null],[12,"name","","",375,null],[12,"is_shorthand","","",375,null],[3,"IrMaps","","",null,null],[12,"tcx","","",376,null],[12,"num_live_nodes","","",376,null],[12,"num_vars","","",376,null],[12,"live_node_map","","",376,null],[12,"variable_map","","",376,null],[12,"capture_info_map","","",376,null],[12,"var_kinds","","",376,null],[12,"lnks","","",376,null],[3,"Users","","",null,null],[12,"reader","","",377,null],[12,"writer","","",377,null],[12,"used","","",377,null],[3,"Specials","","",null,null],[12,"exit_ln","","",378,null],[12,"fallthrough_ln","","",378,null],[12,"clean_exit_var","","",378,null],[3,"Liveness","","",null,null],[12,"ir","","",379,null],[12,"tables","","",379,null],[12,"s","","",379,null],[12,"successors","","",379,null],[12,"users","","",379,null],[12,"break_ln","","",379,null],[12,"cont_ln","","",379,null],[12,"breakable_block_ln","","",379,null],[4,"LoopKind","","For use with `propagate_through_loop`.",null,null],[13,"LoopLoop","","An endless `loop` loop.",380,null],[13,"WhileLoop","","A `while` loop, with the given expression as condition.",380,null],[4,"LiveNodeKind","","",null,null],[13,"FreeVarNode","","",381,null],[13,"ExprNode","","",381,null],[13,"VarDefNode","","",381,null],[13,"ExitNode","","",381,null],[4,"VarKind","","",null,null],[13,"Arg","","",382,null],[13,"Local","","",382,null],[13,"CleanExit","","",382,null],[5,"live_node_kind_to_string","","",null,{"inputs":[{"name":"livenodekind"},{"name":"tyctxt"}],"output":{"name":"string"}}],[5,"check_crate","","",null,{"inputs":[{"name":"tyctxt"}],"output":null}],[5,"invalid_node","","",null,{"inputs":[],"output":{"name":"livenode"}}],[5,"visit_fn","","",null,{"inputs":[{"name":"irmaps"},{"name":"fnkind"},{"name":"fndecl"},{"name":"bodyid"},{"name":"span"},{"name":"nodeid"}],"output":null}],[5,"visit_local","","",null,{"inputs":[{"name":"irmaps"},{"name":"local"}],"output":null}],[5,"visit_arm","","",null,{"inputs":[{"name":"irmaps"},{"name":"arm"}],"output":null}],[5,"visit_expr","","",null,{"inputs":[{"name":"irmaps"},{"name":"expr"}],"output":null}],[5,"invalid_users","","",null,{"inputs":[],"output":{"name":"users"}}],[5,"check_local","","",null,{"inputs":[{"name":"liveness"},{"name":"local"}],"output":null}],[5,"check_arm","","",null,{"inputs":[{"name":"liveness"},{"name":"arm"}],"output":null}],[5,"check_expr","","",null,{"inputs":[{"name":"liveness"},{"name":"expr"}],"output":null}],[17,"ACC_READ","","",null,null],[17,"ACC_WRITE","","",null,null],[17,"ACC_USE","","",null,null],[11,"clone","","",372,{"inputs":[{"name":"self"}],"output":{"name":"variable"}}],[11,"eq","","",372,{"inputs":[{"name":"self"},{"name":"variable"}],"output":{"name":"bool"}}],[11,"ne","","",372,{"inputs":[{"name":"self"},{"name":"variable"}],"output":{"name":"bool"}}],[11,"eq","","",373,{"inputs":[{"name":"self"},{"name":"livenode"}],"output":{"name":"bool"}}],[11,"ne","","",373,{"inputs":[{"name":"self"},{"name":"livenode"}],"output":{"name":"bool"}}],[11,"get","","",372,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"get","","",373,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"clone","","",373,{"inputs":[{"name":"self"}],"output":{"name":"livenode"}}],[11,"clone","","",381,{"inputs":[{"name":"self"}],"output":{"name":"livenodekind"}}],[11,"eq","","",381,{"inputs":[{"name":"self"},{"name":"livenodekind"}],"output":{"name":"bool"}}],[11,"ne","","",381,{"inputs":[{"name":"self"},{"name":"livenodekind"}],"output":{"name":"bool"}}],[11,"fmt","","",381,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"nested_visit_map","","",376,{"inputs":[{"name":"self"}],"output":{"name":"nestedvisitormap"}}],[11,"visit_fn","","",376,{"inputs":[{"name":"self"},{"name":"fnkind"},{"name":"fndecl"},{"name":"bodyid"},{"name":"span"},{"name":"nodeid"}],"output":null}],[11,"visit_local","","",376,{"inputs":[{"name":"self"},{"name":"local"}],"output":null}],[11,"visit_expr","","",376,{"inputs":[{"name":"self"},{"name":"expr"}],"output":null}],[11,"visit_arm","","",376,{"inputs":[{"name":"self"},{"name":"arm"}],"output":null}],[11,"fmt","","",373,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",372,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"is_valid","","",373,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",375,{"inputs":[{"name":"self"}],"output":{"name":"localinfo"}}],[11,"fmt","","",375,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",382,{"inputs":[{"name":"self"}],"output":{"name":"varkind"}}],[11,"fmt","","",382,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","",376,{"inputs":[{"name":"tyctxt"}],"output":{"name":"irmaps"}}],[11,"add_live_node","","",376,{"inputs":[{"name":"self"},{"name":"livenodekind"}],"output":{"name":"livenode"}}],[11,"add_live_node_for_node","","",376,{"inputs":[{"name":"self"},{"name":"nodeid"},{"name":"livenodekind"}],"output":null}],[11,"add_variable","","",376,{"inputs":[{"name":"self"},{"name":"varkind"}],"output":{"name":"variable"}}],[11,"variable","","",376,{"inputs":[{"name":"self"},{"name":"nodeid"},{"name":"span"}],"output":{"name":"variable"}}],[11,"variable_name","","",376,{"inputs":[{"name":"self"},{"name":"variable"}],"output":{"name":"string"}}],[11,"variable_is_shorthand","","",376,{"inputs":[{"name":"self"},{"name":"variable"}],"output":{"name":"bool"}}],[11,"set_captures","","",376,{"inputs":[{"name":"self"},{"name":"nodeid"},{"generics":["captureinfo"],"name":"vec"}],"output":null}],[11,"lnk","","",376,{"inputs":[{"name":"self"},{"name":"livenode"}],"output":{"name":"livenodekind"}}],[11,"clone","","",377,{"inputs":[{"name":"self"}],"output":{"name":"users"}}],[11,"clone","","",378,{"inputs":[{"name":"self"}],"output":{"name":"specials"}}],[11,"new","","",379,{"inputs":[{"name":"irmaps"},{"name":"bodyid"}],"output":{"name":"liveness"}}],[11,"live_node","","",379,{"inputs":[{"name":"self"},{"name":"nodeid"},{"name":"span"}],"output":{"name":"livenode"}}],[11,"variable","","",379,{"inputs":[{"name":"self"},{"name":"nodeid"},{"name":"span"}],"output":{"name":"variable"}}],[11,"pat_bindings","","",379,{"inputs":[{"name":"self"},{"name":"pat"},{"name":"f"}],"output":null}],[11,"arm_pats_bindings","","",379,{"inputs":[{"name":"self"},{"generics":["pat"],"name":"option"},{"name":"f"}],"output":null}],[11,"define_bindings_in_pat","","",379,{"inputs":[{"name":"self"},{"name":"pat"},{"name":"livenode"}],"output":{"name":"livenode"}}],[11,"define_bindings_in_arm_pats","","",379,{"inputs":[{"name":"self"},{"generics":["pat"],"name":"option"},{"name":"livenode"}],"output":{"name":"livenode"}}],[11,"idx","","",379,{"inputs":[{"name":"self"},{"name":"livenode"},{"name":"variable"}],"output":{"name":"usize"}}],[11,"live_on_entry","","",379,{"inputs":[{"name":"self"},{"name":"livenode"},{"name":"variable"}],"output":{"generics":["livenodekind"],"name":"option"}}],[11,"live_on_exit","","",379,{"inputs":[{"name":"self"},{"name":"livenode"},{"name":"variable"}],"output":{"generics":["livenodekind"],"name":"option"}}],[11,"used_on_entry","","",379,{"inputs":[{"name":"self"},{"name":"livenode"},{"name":"variable"}],"output":{"name":"bool"}}],[11,"assigned_on_entry","","",379,{"inputs":[{"name":"self"},{"name":"livenode"},{"name":"variable"}],"output":{"generics":["livenodekind"],"name":"option"}}],[11,"assigned_on_exit","","",379,{"inputs":[{"name":"self"},{"name":"livenode"},{"name":"variable"}],"output":{"generics":["livenodekind"],"name":"option"}}],[11,"indices2","","",379,{"inputs":[{"name":"self"},{"name":"livenode"},{"name":"livenode"},{"name":"f"}],"output":null}],[11,"write_vars","","",379,{"inputs":[{"name":"self"},{"name":"write"},{"name":"livenode"},{"name":"f"}],"output":{"name":"result"}}],[11,"ln_str","","",379,{"inputs":[{"name":"self"},{"name":"livenode"}],"output":{"name":"string"}}],[11,"init_empty","","",379,{"inputs":[{"name":"self"},{"name":"livenode"},{"name":"livenode"}],"output":null}],[11,"init_from_succ","","",379,{"inputs":[{"name":"self"},{"name":"livenode"},{"name":"livenode"}],"output":null}],[11,"merge_from_succ","","",379,{"inputs":[{"name":"self"},{"name":"livenode"},{"name":"livenode"},{"name":"bool"}],"output":{"name":"bool"}}],[11,"define","","",379,{"inputs":[{"name":"self"},{"name":"livenode"},{"name":"variable"}],"output":null}],[11,"acc","","",379,{"inputs":[{"name":"self"},{"name":"livenode"},{"name":"variable"},{"name":"u32"}],"output":null}],[11,"compute","","",379,{"inputs":[{"name":"self"},{"name":"expr"}],"output":{"name":"livenode"}}],[11,"propagate_through_block","","",379,{"inputs":[{"name":"self"},{"name":"block"},{"name":"livenode"}],"output":{"name":"livenode"}}],[11,"propagate_through_stmt","","",379,{"inputs":[{"name":"self"},{"name":"stmt"},{"name":"livenode"}],"output":{"name":"livenode"}}],[11,"propagate_through_decl","","",379,{"inputs":[{"name":"self"},{"name":"decl"},{"name":"livenode"}],"output":{"name":"livenode"}}],[11,"propagate_through_local","","",379,{"inputs":[{"name":"self"},{"name":"local"},{"name":"livenode"}],"output":{"name":"livenode"}}],[11,"propagate_through_exprs","","",379,null],[11,"propagate_through_opt_expr","","",379,{"inputs":[{"name":"self"},{"generics":["expr"],"name":"option"},{"name":"livenode"}],"output":{"name":"livenode"}}],[11,"propagate_through_expr","","",379,{"inputs":[{"name":"self"},{"name":"expr"},{"name":"livenode"}],"output":{"name":"livenode"}}],[11,"propagate_through_place_components","","",379,{"inputs":[{"name":"self"},{"name":"expr"},{"name":"livenode"}],"output":{"name":"livenode"}}],[11,"write_place","","",379,{"inputs":[{"name":"self"},{"name":"expr"},{"name":"livenode"},{"name":"u32"}],"output":{"name":"livenode"}}],[11,"access_var","","",379,{"inputs":[{"name":"self"},{"name":"nodeid"},{"name":"nodeid"},{"name":"livenode"},{"name":"u32"},{"name":"span"}],"output":{"name":"livenode"}}],[11,"access_path","","",379,{"inputs":[{"name":"self"},{"name":"nodeid"},{"name":"path"},{"name":"livenode"},{"name":"u32"}],"output":{"name":"livenode"}}],[11,"propagate_through_loop","","",379,{"inputs":[{"name":"self"},{"name":"expr"},{"name":"loopkind"},{"name":"block"},{"name":"livenode"}],"output":{"name":"livenode"}}],[11,"nested_visit_map","","",379,{"inputs":[{"name":"self"}],"output":{"name":"nestedvisitormap"}}],[11,"visit_local","","",379,{"inputs":[{"name":"self"},{"name":"local"}],"output":null}],[11,"visit_expr","","",379,{"inputs":[{"name":"self"},{"name":"expr"}],"output":null}],[11,"visit_arm","","",379,{"inputs":[{"name":"self"},{"name":"arm"}],"output":null}],[11,"check_place","","",379,{"inputs":[{"name":"self"},{"name":"expr"}],"output":null}],[11,"should_warn","","",379,{"inputs":[{"name":"self"},{"name":"variable"}],"output":{"generics":["string"],"name":"option"}}],[11,"warn_about_unused_args","","",379,{"inputs":[{"name":"self"},{"name":"body"},{"name":"livenode"}],"output":null}],[11,"warn_about_unused_or_dead_vars_in_pat","","",379,{"inputs":[{"name":"self"},{"name":"pat"}],"output":null}],[11,"warn_about_unused","","",379,{"inputs":[{"name":"self"},{"name":"span"},{"name":"nodeid"},{"name":"livenode"},{"name":"variable"}],"output":{"name":"bool"}}],[11,"warn_about_dead_assign","","",379,{"inputs":[{"name":"self"},{"name":"span"},{"name":"nodeid"},{"name":"livenode"},{"name":"variable"}],"output":null}],[11,"report_dead_assign","","",379,{"inputs":[{"name":"self"},{"name":"nodeid"},{"name":"span"},{"name":"variable"},{"name":"bool"}],"output":null}],[0,"mem_categorization","rustc::middle","Categorization",null,null],[3,"Upvar","rustc::middle::mem_categorization","",null,null],[12,"id","","",383,null],[12,"kind","","",383,null],[3,"FieldIndex","","",null,null],[12,"0","","",384,null],[12,"1","","",384,null],[3,"cmt_","","",null,null],[12,"id","","",385,null],[12,"span","","",385,null],[12,"cat","","",385,null],[12,"mutbl","","",385,null],[12,"ty","","",385,null],[12,"note","","",385,null],[3,"MemCategorizationContext","","",null,null],[12,"tcx","","",386,null],[12,"region_scope_tree","","",386,null],[12,"tables","","",386,null],[12,"rvalue_promotable_map","","",386,null],[12,"infcx","","",386,null],[4,"Categorization","","",null,null],[13,"Rvalue","","",387,null],[13,"StaticItem","","",387,null],[13,"Upvar","","",387,null],[13,"Local","","",387,null],[13,"Deref","","",387,null],[13,"Interior","","",387,null],[13,"Downcast","","",387,null],[4,"PointerKind","","",null,null],[13,"Unique","","`Box<T>`",388,null],[13,"BorrowedPtr","","`&T`",388,null],[13,"UnsafePtr","","`*T`",388,null],[4,"InteriorKind","","",null,null],[13,"InteriorField","","",389,null],[13,"InteriorElement","","",389,null],[4,"InteriorOffsetKind","","",null,null],[13,"Index","","",390,null],[13,"Pattern","","",390,null],[4,"MutabilityCategory","","",null,null],[13,"McImmutable","","",391,null],[13,"McDeclared","","",391,null],[13,"McInherited","","",391,null],[4,"Note","","",null,null],[13,"NoteClosureEnv","","",392,null],[13,"NoteUpvarRef","","",392,null],[13,"NoteIndex","","",392,null],[13,"NoteNone","","",392,null],[4,"ImmutabilityBlame","","",null,null],[13,"ImmLocal","","",393,null],[13,"ClosureEnv","","",393,null],[13,"LocalDeref","","",393,null],[13,"AdtFieldDeref","","",393,null],[4,"Aliasability","","",null,null],[13,"FreelyAliasable","","",394,null],[13,"NonAliasable","","",394,null],[13,"ImmutableUnique","","",394,null],[4,"AliasableReason","","",null,null],[13,"AliasableBorrowed","","",395,null],[13,"AliasableStatic","","",395,null],[13,"AliasableStaticMut","","",395,null],[5,"ptr_sigil","","",null,{"inputs":[{"name":"pointerkind"}],"output":{"name":"str"}}],[6,"cmt","","",null,null],[6,"McResult","","",null,null],[8,"ast_node","","",null,null],[10,"id","","",396,{"inputs":[{"name":"self"}],"output":{"name":"nodeid"}}],[10,"span","","",396,{"inputs":[{"name":"self"}],"output":{"name":"span"}}],[11,"clone","","",387,{"inputs":[{"name":"self"}],"output":{"name":"categorization"}}],[11,"fmt","","",387,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",387,{"inputs":[{"name":"self"},{"name":"categorization"}],"output":{"name":"bool"}}],[11,"ne","","",387,{"inputs":[{"name":"self"},{"name":"categorization"}],"output":{"name":"bool"}}],[11,"clone","","",383,{"inputs":[{"name":"self"}],"output":{"name":"upvar"}}],[11,"eq","","",383,{"inputs":[{"name":"self"},{"name":"upvar"}],"output":{"name":"bool"}}],[11,"ne","","",383,{"inputs":[{"name":"self"},{"name":"upvar"}],"output":{"name":"bool"}}],[11,"clone","","",388,{"inputs":[{"name":"self"}],"output":{"name":"pointerkind"}}],[11,"fmt","","",388,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",388,{"inputs":[{"name":"self"},{"name":"pointerkind"}],"output":{"name":"bool"}}],[11,"ne","","",388,{"inputs":[{"name":"self"},{"name":"pointerkind"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",388,null],[11,"hash","","",388,null],[11,"clone","","",389,{"inputs":[{"name":"self"}],"output":{"name":"interiorkind"}}],[11,"eq","","",389,{"inputs":[{"name":"self"},{"name":"interiorkind"}],"output":{"name":"bool"}}],[11,"ne","","",389,{"inputs":[{"name":"self"},{"name":"interiorkind"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",389,null],[11,"hash","","",389,null],[11,"clone","","",384,{"inputs":[{"name":"self"}],"output":{"name":"fieldindex"}}],[11,"assert_receiver_is_total_eq","","",384,null],[11,"eq","","",384,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"bool"}}],[11,"hash","","",384,{"inputs":[{"name":"self"},{"name":"h"}],"output":null}],[11,"clone","","",390,{"inputs":[{"name":"self"}],"output":{"name":"interioroffsetkind"}}],[11,"eq","","",390,{"inputs":[{"name":"self"},{"name":"interioroffsetkind"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",390,null],[11,"hash","","",390,null],[11,"fmt","","",390,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",391,{"inputs":[{"name":"self"}],"output":{"name":"mutabilitycategory"}}],[11,"eq","","",391,{"inputs":[{"name":"self"},{"name":"mutabilitycategory"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",391,null],[11,"hash","","",391,null],[11,"fmt","","",391,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",392,{"inputs":[{"name":"self"}],"output":{"name":"note"}}],[11,"eq","","",392,{"inputs":[{"name":"self"},{"name":"note"}],"output":{"name":"bool"}}],[11,"ne","","",392,{"inputs":[{"name":"self"},{"name":"note"}],"output":{"name":"bool"}}],[11,"fmt","","",392,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",385,{"inputs":[{"name":"self"}],"output":{"name":"cmt_"}}],[11,"fmt","","",385,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",385,{"inputs":[{"name":"self"},{"name":"cmt_"}],"output":{"name":"bool"}}],[11,"ne","","",385,{"inputs":[{"name":"self"},{"name":"cmt_"}],"output":{"name":"bool"}}],[11,"resolve_field","","",385,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"option"}}],[11,"immutability_blame","","",385,{"inputs":[{"name":"self"}],"output":{"generics":["immutabilityblame"],"name":"option"}}],[11,"id","rustc::hir","",57,{"inputs":[{"name":"self"}],"output":{"name":"nodeid"}}],[11,"span","","",57,{"inputs":[{"name":"self"}],"output":{"name":"span"}}],[11,"id","","",50,{"inputs":[{"name":"self"}],"output":{"name":"nodeid"}}],[11,"span","","",50,{"inputs":[{"name":"self"}],"output":{"name":"span"}}],[11,"clone","rustc::middle::mem_categorization","",386,{"inputs":[{"name":"self"}],"output":{"name":"memcategorizationcontext"}}],[11,"from_mutbl","","",391,{"inputs":[{"name":"mutability"}],"output":{"name":"mutabilitycategory"}}],[11,"from_borrow_kind","","",391,{"inputs":[{"name":"borrowkind"}],"output":{"name":"mutabilitycategory"}}],[11,"from_pointer_kind","","",391,{"inputs":[{"name":"mutabilitycategory"},{"name":"pointerkind"}],"output":{"name":"mutabilitycategory"}}],[11,"from_local","","",391,{"inputs":[{"name":"tyctxt"},{"name":"typecktables"},{"name":"nodeid"}],"output":{"name":"mutabilitycategory"}}],[11,"inherit","","",391,{"inputs":[{"name":"self"}],"output":{"name":"mutabilitycategory"}}],[11,"is_mutable","","",391,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_immutable","","",391,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"to_user_str","","",391,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"new","","",386,{"inputs":[{"name":"tyctxt"},{"name":"scopetree"},{"name":"typecktables"},{"generics":["lrc"],"name":"option"}],"output":{"name":"memcategorizationcontext"}}],[11,"with_infer","","Creates a `MemCategorizationContext` during type inference. This is used during upvar analysis and a few other places. Because the typeck tables are not yet complete, the results from the analysis must be used with caution:",386,{"inputs":[{"name":"inferctxt"},{"name":"scopetree"},{"name":"typecktables"}],"output":{"name":"memcategorizationcontext"}}],[11,"type_moves_by_default","","",386,{"inputs":[{"name":"self"},{"name":"paramenv"},{"name":"ty"},{"name":"span"}],"output":{"name":"bool"}}],[11,"resolve_type_vars_if_possible","","",386,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"t"}}],[11,"is_tainted_by_errors","","",386,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"resolve_type_vars_or_error","","",386,{"inputs":[{"name":"self"},{"name":"hirid"},{"generics":["ty"],"name":"option"}],"output":{"generics":["ty"],"name":"mcresult"}}],[11,"node_ty","","",386,{"inputs":[{"name":"self"},{"name":"hirid"}],"output":{"generics":["ty"],"name":"mcresult"}}],[11,"expr_ty","","",386,{"inputs":[{"name":"self"},{"name":"expr"}],"output":{"generics":["ty"],"name":"mcresult"}}],[11,"expr_ty_adjusted","","",386,{"inputs":[{"name":"self"},{"name":"expr"}],"output":{"generics":["ty"],"name":"mcresult"}}],[11,"pat_ty_adjusted","","Returns the type of value that this pattern matches against. Some non-obvious cases:",386,{"inputs":[{"name":"self"},{"name":"pat"}],"output":{"generics":["ty"],"name":"mcresult"}}],[11,"pat_ty_unadjusted","","Like `pat_ty`, but ignores implicit `&` patterns.",386,{"inputs":[{"name":"self"},{"name":"pat"}],"output":{"generics":["ty"],"name":"mcresult"}}],[11,"cat_expr","","",386,{"inputs":[{"name":"self"},{"name":"expr"}],"output":{"generics":["cmt_"],"name":"mcresult"}}],[11,"cat_expr_adjusted","","",386,{"inputs":[{"name":"self"},{"name":"expr"},{"name":"cmt_"},{"name":"adjustment"}],"output":{"generics":["cmt_"],"name":"mcresult"}}],[11,"cat_expr_adjusted_with","","",386,{"inputs":[{"name":"self"},{"name":"expr"},{"name":"f"},{"name":"adjustment"}],"output":{"generics":["cmt_"],"name":"mcresult"}}],[11,"cat_expr_unadjusted","","",386,{"inputs":[{"name":"self"},{"name":"expr"}],"output":{"generics":["cmt_"],"name":"mcresult"}}],[11,"cat_def","","",386,{"inputs":[{"name":"self"},{"name":"nodeid"},{"name":"span"},{"name":"ty"},{"name":"def"}],"output":{"generics":["cmt_"],"name":"mcresult"}}],[11,"cat_upvar","","",386,{"inputs":[{"name":"self"},{"name":"nodeid"},{"name":"span"},{"name":"nodeid"},{"name":"nodeid"}],"output":{"generics":["cmt_"],"name":"mcresult"}}],[11,"env_deref","","",386,{"inputs":[{"name":"self"},{"name":"nodeid"},{"name":"span"},{"name":"upvarid"},{"name":"mutabilitycategory"},{"name":"borrowkind"},{"name":"cmt_"}],"output":{"name":"cmt_"}}],[11,"temporary_scope","","Returns the lifetime of a temporary created by expr with id `id`. This could be `'static` if `id` is part of a constant expression.",386,{"inputs":[{"name":"self"},{"name":"itemlocalid"}],"output":{"name":"region"}}],[11,"cat_rvalue_node","","",386,{"inputs":[{"name":"self"},{"name":"nodeid"},{"name":"span"},{"name":"ty"}],"output":{"name":"cmt_"}}],[11,"cat_rvalue","","",386,{"inputs":[{"name":"self"},{"name":"nodeid"},{"name":"span"},{"name":"region"},{"name":"ty"}],"output":{"name":"cmt_"}}],[11,"cat_field","","",386,{"inputs":[{"name":"self"},{"name":"n"},{"name":"cmt"},{"name":"usize"},{"name":"name"},{"name":"ty"}],"output":{"name":"cmt_"}}],[11,"cat_overloaded_place","","",386,{"inputs":[{"name":"self"},{"name":"expr"},{"name":"expr"},{"name":"note"}],"output":{"generics":["cmt_"],"name":"mcresult"}}],[11,"cat_deref","","",386,null],[11,"cat_index","","Creates a cmt for an indexing operation (`[]`).",386,{"inputs":[{"name":"self"},{"name":"n"},{"name":"cmt"},{"name":"ty"},{"name":"interioroffsetkind"}],"output":{"generics":["cmt_"],"name":"mcresult"}}],[11,"cat_imm_interior","","",386,{"inputs":[{"name":"self"},{"name":"n"},{"name":"cmt"},{"name":"ty"},{"name":"interiorkind"}],"output":{"name":"cmt_"}}],[11,"cat_downcast_if_needed","","",386,{"inputs":[{"name":"self"},{"name":"n"},{"name":"cmt"},{"name":"defid"}],"output":{"name":"cmt"}}],[11,"cat_pattern","","",386,{"inputs":[{"name":"self"},{"name":"cmt"},{"name":"pat"},{"name":"f"}],"output":{"name":"mcresult"}}],[11,"cat_pattern_","","",386,{"inputs":[{"name":"self"},{"name":"cmt"},{"name":"pat"},{"name":"f"}],"output":{"name":"mcresult"}}],[11,"clone","","",394,{"inputs":[{"name":"self"}],"output":{"name":"aliasability"}}],[11,"fmt","","",394,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",395,{"inputs":[{"name":"self"}],"output":{"name":"aliasablereason"}}],[11,"fmt","","",395,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"guarantor","","Returns `self` after stripping away any derefs or interior content. The return value is basically the `cmt` which determines how long the value in `self` remains live.",385,{"inputs":[{"name":"self"}],"output":{"name":"cmt_"}}],[11,"freely_aliasable","","Returns `FreelyAliasable(_)` if this place represents a freely aliasable pointer type.",385,{"inputs":[{"name":"self"}],"output":{"name":"aliasability"}}],[11,"upvar_cat","","",385,{"inputs":[{"name":"self"}],"output":{"generics":["categorization"],"name":"option"}}],[11,"descriptive_string","","",385,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"string"}}],[11,"fmt","","",389,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",383,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",383,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[0,"privacy","rustc::middle","A pass that checks to make sure private fields and methods aren't used outside their scopes. This pass will also generate a set of exported items which are available for use externally when compiled as a library.",null,null],[3,"AccessLevels","rustc::middle::privacy","",null,null],[12,"map","","",397,null],[4,"AccessLevel","","",null,null],[13,"Reachable","","",398,null],[13,"Exported","","",398,null],[13,"Public","","",398,null],[6,"ExternalExports","","A set containing all exported definitions from external crates. The set does not contain any entries from local crates.",null,null],[11,"clone","","",398,{"inputs":[{"name":"self"}],"output":{"name":"accesslevel"}}],[11,"fmt","","",398,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",398,{"inputs":[{"name":"self"},{"name":"accesslevel"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",398,null],[11,"partial_cmp","","",398,{"inputs":[{"name":"self"},{"name":"accesslevel"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"cmp","","",398,{"inputs":[{"name":"self"},{"name":"accesslevel"}],"output":{"name":"ordering"}}],[11,"clone","","",397,{"inputs":[{"name":"self"}],"output":{"name":"accesslevels"}}],[11,"is_reachable","","",397,{"inputs":[{"name":"self"},{"name":"id"}],"output":{"name":"bool"}}],[11,"is_exported","","",397,{"inputs":[{"name":"self"},{"name":"id"}],"output":{"name":"bool"}}],[11,"is_public","","",397,{"inputs":[{"name":"self"},{"name":"id"}],"output":{"name":"bool"}}],[11,"default","","",397,{"inputs":[],"output":{"name":"self"}}],[11,"fmt","","",397,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[0,"reachable","rustc::middle","",null,null],[3,"ReachableContext","rustc::middle::reachable","",null,null],[12,"tcx","","",399,null],[12,"tables","","",399,null],[12,"reachable_symbols","","",399,null],[12,"worklist","","",399,null],[12,"any_library","","",399,null],[3,"CollectPrivateImplItemsVisitor","","",null,null],[12,"tcx","","",400,null],[12,"access_levels","","",400,null],[12,"worklist","","",400,null],[3,"ReachableSet","","",null,null],[12,"0","","",401,null],[5,"generics_require_inlining","","",null,{"inputs":[{"name":"generics"}],"output":{"name":"bool"}}],[5,"item_might_be_inlined","","",null,{"inputs":[{"name":"item"},{"name":"transfnattrs"}],"output":{"name":"bool"}}],[5,"method_might_be_inlined","","",null,{"inputs":[{"name":"tyctxt"},{"name":"implitem"},{"name":"defid"}],"output":{"name":"bool"}}],[5,"reachable_set","","",null,{"inputs":[{"name":"tyctxt"},{"name":"cratenum"}],"output":{"name":"reachableset"}}],[5,"provide","","",null,{"inputs":[{"name":"providers"}],"output":null}],[11,"nested_visit_map","","",399,{"inputs":[{"name":"self"}],"output":{"name":"nestedvisitormap"}}],[11,"visit_nested_body","","",399,{"inputs":[{"name":"self"},{"name":"bodyid"}],"output":null}],[11,"visit_expr","","",399,{"inputs":[{"name":"self"},{"name":"expr"}],"output":null}],[11,"def_id_represents_local_inlined_item","","",399,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"bool"}}],[11,"propagate","","",399,{"inputs":[{"name":"self"}],"output":null}],[11,"propagate_node","","",399,{"inputs":[{"name":"self"},{"name":"node"},{"name":"nodeid"}],"output":null}],[11,"visit_item","","",400,{"inputs":[{"name":"self"},{"name":"item"}],"output":null}],[11,"visit_trait_item","","",400,{"inputs":[{"name":"self"},{"name":"traititem"}],"output":null}],[11,"visit_impl_item","","",400,{"inputs":[{"name":"self"},{"name":"implitem"}],"output":null}],[11,"clone","","",401,{"inputs":[{"name":"self"}],"output":{"name":"reachableset"}}],[0,"region","rustc::middle","This file builds up the `ScopeTree`, which describes the parent links in the region hierarchy.",null,null],[3,"Scope","rustc::middle::region","Scope represents a statically-describable scope that can be used to bound the lifetime/region for values.",null,null],[12,"id","","",402,null],[12,"code","","",402,null],[3,"BlockRemainder","","Represents a subscope of `block` for a binding that is introduced by `block.stmts[first_statement_index]`. Such subscopes represent a suffix of the block. Note that each subscope does not include the initializer expression, if any, for the statement indexed by `first_statement_index`.",null,null],[12,"block","","",403,null],[12,"first_statement_index","","",403,null],[3,"FirstStatementIndex","","",null,null],[12,"0","","",404,null],[3,"ScopeTree","","The region scope tree encodes information about region relationships.",null,null],[12,"root_body","","If not empty, this body is the root of this region hierarchy.",405,null],[12,"root_parent","","The parent of the root body owner, if the latter is an an associated const or method, as impls/traits can also have lifetime parameters free in this body.",405,null],[12,"parent_map","","`parent_map` maps from a scope id to the enclosing scope id; this is usually corresponding to the lexical nesting, though in the case of closures the parent scope is the innermost conditional expression or repeating block. (Note that the enclosing scope id for the block associated with a closure is the closure itself.)",405,null],[12,"var_map","","`var_map` maps from a variable or binding id to the block in which that variable is declared.",405,null],[12,"destruction_scopes","","maps from a node-id to the associated destruction scope (if any)",405,null],[12,"rvalue_scopes","","`rvalue_scopes` includes entries for those expressions whose cleanup scope is larger than the default. The map goes from the expression id to the cleanup scope id. For rvalues not present in this table, the appropriate cleanup scope is the innermost enclosing statement, conditional expression, or repeating block (see `terminating_scopes`). In constants, None is used to indicate that certain expressions escape into 'static and should have no local cleanup scope.",405,null],[12,"closure_tree","","Encodes the hierarchy of fn bodies. Every fn body (including closures) forms its own distinct region hierarchy, rooted in the block that is the fn body. This map points from the id of that root block to the id of the root block for the enclosing fn, if any. Thus the map structures the fn bodies into a hierarchy based on their lexical mapping. This is used to handle the relationships between regions in a fn and in a closure defined by that fn. See the \"Modeling closures\" section of the README in infer::region_constraints for more details.",405,null],[12,"yield_in_scope","","If there are any `yield` nested within a scope, this map stores the `Span` of the last one and its index in the postorder of the Visitor traversal on the HIR.",405,null],[12,"body_expr_count","","The number of visit_expr and visit_pat calls done in the body. Used to sanity check visit_expr/visit_pat call count when calculating generator interiors.",405,null],[3,"Context","","",null,null],[12,"root_id","","the root of the current region tree. This is typically the id of the innermost fn body. Each fn forms its own disjoint tree in the region hierarchy. These fn bodies are themselves arranged into a tree. See the \"Modeling closures\" section of the README in infer::region_constraints for more details.",406,null],[12,"var_parent","","the scope that contains any new variables declared",406,null],[12,"parent","","region parent of expressions etc",406,null],[3,"RegionResolutionVisitor","","",null,null],[12,"tcx","","",407,null],[12,"expr_and_pat_count","","",407,null],[12,"scope_tree","","",407,null],[12,"cx","","",407,null],[12,"terminating_scopes","","`terminating_scopes` is a set containing the ids of each statement, or conditional/repeating expression. These scopes are calling \"terminating scopes\" because, when attempting to find the scope of a temporary, by default we search up the enclosing scopes until we encounter the terminating scope. A conditional/repeating expression is one which is not guaranteed to execute exactly once upon entering the parent scope. This could be because the expression only executes conditionally, such as the expression `b` in `a && b`, or because the expression may execute many times, such as a loop body. The reason that we distinguish such expressions is that, upon exiting the parent scope, we cannot statically know how many times the expression executed, and thus if the expression creates temporaries we cannot know statically how many such temporaries we would have to cleanup. Therefore we ensure that the temporaries never outlast the conditional/repeating expression, preventing the need for dynamic checks and/or arbitrary amounts of stack space. Terminating scopes end up being contained in a DestructionScope that contains the destructor's execution.",407,null],[3,"ExprLocatorVisitor","","",null,null],[12,"id","","",408,null],[12,"result","","",408,null],[12,"expr_and_pat_count","","",408,null],[4,"ScopeData","","",null,null],[13,"Node","","",409,null],[13,"CallSite","","",409,null],[13,"Arguments","","",409,null],[13,"Destruction","","",409,null],[13,"Remainder","","",409,null],[5,"record_var_lifetime","","Records the lifetime of a local variable as `cx.var_parent`",null,{"inputs":[{"name":"regionresolutionvisitor"},{"name":"itemlocalid"},{"name":"span"}],"output":null}],[5,"resolve_block","","",null,{"inputs":[{"name":"regionresolutionvisitor"},{"name":"block"}],"output":null}],[5,"resolve_arm","","",null,{"inputs":[{"name":"regionresolutionvisitor"},{"name":"arm"}],"output":null}],[5,"resolve_pat","","",null,{"inputs":[{"name":"regionresolutionvisitor"},{"name":"pat"}],"output":null}],[5,"resolve_stmt","","",null,{"inputs":[{"name":"regionresolutionvisitor"},{"name":"stmt"}],"output":null}],[5,"resolve_expr","","",null,{"inputs":[{"name":"regionresolutionvisitor"},{"name":"expr"}],"output":null}],[5,"resolve_local","","",null,{"inputs":[{"name":"regionresolutionvisitor"},{"generics":["pat"],"name":"option"},{"generics":["expr"],"name":"option"}],"output":null}],[5,"region_scope_tree","","",null,{"inputs":[{"name":"tyctxt"},{"name":"defid"}],"output":{"generics":["scopetree"],"name":"lrc"}}],[5,"provide","","",null,{"inputs":[{"name":"providers"}],"output":null}],[17,"SCOPE_DATA_NODE","","",null,null],[17,"SCOPE_DATA_CALLSITE","","",null,null],[17,"SCOPE_DATA_ARGUMENTS","","",null,null],[17,"SCOPE_DATA_DESTRUCTION","","",null,null],[17,"SCOPE_DATA_REMAINDER_MAX","","",null,null],[11,"clone","","",402,{"inputs":[{"name":"self"}],"output":{"name":"scope"}}],[11,"eq","","",402,{"inputs":[{"name":"self"},{"name":"scope"}],"output":{"name":"bool"}}],[11,"ne","","",402,{"inputs":[{"name":"self"},{"name":"scope"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",402,{"inputs":[{"name":"self"},{"name":"scope"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",402,{"inputs":[{"name":"self"},{"name":"scope"}],"output":{"name":"bool"}}],[11,"le","","",402,{"inputs":[{"name":"self"},{"name":"scope"}],"output":{"name":"bool"}}],[11,"gt","","",402,{"inputs":[{"name":"self"},{"name":"scope"}],"output":{"name":"bool"}}],[11,"ge","","",402,{"inputs":[{"name":"self"},{"name":"scope"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",402,null],[11,"cmp","","",402,{"inputs":[{"name":"self"},{"name":"scope"}],"output":{"name":"ordering"}}],[11,"hash","","",402,null],[11,"encode","","",402,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",402,{"inputs":[{"name":"__d"}],"output":{"generics":["scope"],"name":"result"}}],[11,"clone","","",409,{"inputs":[{"name":"self"}],"output":{"name":"scopedata"}}],[11,"eq","","",409,{"inputs":[{"name":"self"},{"name":"scopedata"}],"output":{"name":"bool"}}],[11,"ne","","",409,{"inputs":[{"name":"self"},{"name":"scopedata"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",409,{"inputs":[{"name":"self"},{"name":"scopedata"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",409,{"inputs":[{"name":"self"},{"name":"scopedata"}],"output":{"name":"bool"}}],[11,"le","","",409,{"inputs":[{"name":"self"},{"name":"scopedata"}],"output":{"name":"bool"}}],[11,"gt","","",409,{"inputs":[{"name":"self"},{"name":"scopedata"}],"output":{"name":"bool"}}],[11,"ge","","",409,{"inputs":[{"name":"self"},{"name":"scopedata"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",409,null],[11,"cmp","","",409,{"inputs":[{"name":"self"},{"name":"scopedata"}],"output":{"name":"ordering"}}],[11,"hash","","",409,null],[11,"fmt","","",409,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",409,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",409,{"inputs":[{"name":"__d"}],"output":{"generics":["scopedata"],"name":"result"}}],[11,"clone","","",403,{"inputs":[{"name":"self"}],"output":{"name":"blockremainder"}}],[11,"eq","","",403,{"inputs":[{"name":"self"},{"name":"blockremainder"}],"output":{"name":"bool"}}],[11,"ne","","",403,{"inputs":[{"name":"self"},{"name":"blockremainder"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",403,{"inputs":[{"name":"self"},{"name":"blockremainder"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",403,{"inputs":[{"name":"self"},{"name":"blockremainder"}],"output":{"name":"bool"}}],[11,"le","","",403,{"inputs":[{"name":"self"},{"name":"blockremainder"}],"output":{"name":"bool"}}],[11,"gt","","",403,{"inputs":[{"name":"self"},{"name":"blockremainder"}],"output":{"name":"bool"}}],[11,"ge","","",403,{"inputs":[{"name":"self"},{"name":"blockremainder"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",403,null],[11,"cmp","","",403,{"inputs":[{"name":"self"},{"name":"blockremainder"}],"output":{"name":"ordering"}}],[11,"hash","","",403,null],[11,"encode","","",403,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",403,{"inputs":[{"name":"__d"}],"output":{"generics":["blockremainder"],"name":"result"}}],[11,"fmt","","",403,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",404,{"inputs":[{"name":"self"}],"output":{"name":"firststatementindex"}}],[11,"eq","","",404,{"inputs":[{"name":"self"},{"name":"firststatementindex"}],"output":{"name":"bool"}}],[11,"ne","","",404,{"inputs":[{"name":"self"},{"name":"firststatementindex"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",404,null],[11,"hash","","",404,null],[11,"partial_cmp","","",404,{"inputs":[{"name":"self"},{"name":"firststatementindex"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",404,{"inputs":[{"name":"self"},{"name":"firststatementindex"}],"output":{"name":"bool"}}],[11,"le","","",404,{"inputs":[{"name":"self"},{"name":"firststatementindex"}],"output":{"name":"bool"}}],[11,"gt","","",404,{"inputs":[{"name":"self"},{"name":"firststatementindex"}],"output":{"name":"bool"}}],[11,"ge","","",404,{"inputs":[{"name":"self"},{"name":"firststatementindex"}],"output":{"name":"bool"}}],[11,"cmp","","",404,{"inputs":[{"name":"self"},{"name":"firststatementindex"}],"output":{"name":"ordering"}}],[11,"decode","","",404,{"inputs":[{"name":"__d"}],"output":{"generics":["firststatementindex"],"name":"result"}}],[11,"encode","","",404,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"new","","",404,{"inputs":[{"name":"usize"}],"output":{"name":"self"}}],[11,"index","","",404,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"fmt","","",404,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"from","","",402,{"inputs":[{"name":"scopedata"}],"output":{"name":"self"}}],[11,"fmt","","",402,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"data","","",402,{"inputs":[{"name":"self"}],"output":{"name":"scopedata"}}],[11,"Node","","",402,{"inputs":[{"name":"itemlocalid"}],"output":{"name":"self"}}],[11,"CallSite","","",402,{"inputs":[{"name":"itemlocalid"}],"output":{"name":"self"}}],[11,"Arguments","","",402,{"inputs":[{"name":"itemlocalid"}],"output":{"name":"self"}}],[11,"Destruction","","",402,{"inputs":[{"name":"itemlocalid"}],"output":{"name":"self"}}],[11,"Remainder","","",402,{"inputs":[{"name":"blockremainder"}],"output":{"name":"self"}}],[11,"item_local_id","","Returns a item-local id associated with this scope.",402,{"inputs":[{"name":"self"}],"output":{"name":"itemlocalid"}}],[11,"node_id","","",402,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"scopetree"}],"output":{"name":"nodeid"}}],[11,"span","","Returns the span of this Scope.  Note that in general the returned span may not correspond to the span of any node id in the AST.",402,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"scopetree"}],"output":{"name":"span"}}],[11,"default","","",405,{"inputs":[],"output":{"name":"scopetree"}}],[11,"fmt","","",405,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",406,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",406,{"inputs":[{"name":"self"}],"output":{"name":"context"}}],[11,"nested_visit_map","","",408,{"inputs":[{"name":"self"}],"output":{"name":"nestedvisitormap"}}],[11,"visit_pat","","",408,{"inputs":[{"name":"self"},{"name":"pat"}],"output":null}],[11,"visit_expr","","",408,{"inputs":[{"name":"self"},{"name":"expr"}],"output":null}],[11,"record_scope_parent","","",405,{"inputs":[{"name":"self"},{"name":"scope"},{"generics":["scope"],"name":"option"}],"output":null}],[11,"each_encl_scope","","",405,{"inputs":[{"name":"self"},{"name":"e"}],"output":null}],[11,"each_var_scope","","",405,{"inputs":[{"name":"self"},{"name":"e"}],"output":null}],[11,"opt_destruction_scope","","",405,{"inputs":[{"name":"self"},{"name":"itemlocalid"}],"output":{"generics":["scope"],"name":"option"}}],[11,"record_closure_parent","","Records that `sub_closure` is defined within `sup_closure`. These ids should be the id of the block that is the fn body, which is also the root of the region hierarchy for that fn.",405,{"inputs":[{"name":"self"},{"name":"itemlocalid"},{"name":"itemlocalid"}],"output":null}],[11,"closure_is_enclosed_by","","",405,{"inputs":[{"name":"self"},{"name":"itemlocalid"},{"name":"itemlocalid"}],"output":{"name":"bool"}}],[11,"record_var_scope","","",405,{"inputs":[{"name":"self"},{"name":"itemlocalid"},{"name":"scope"}],"output":null}],[11,"record_rvalue_scope","","",405,{"inputs":[{"name":"self"},{"name":"itemlocalid"},{"generics":["scope"],"name":"option"}],"output":null}],[11,"opt_encl_scope","","Returns the narrowest scope that encloses `id`, if any.",405,{"inputs":[{"name":"self"},{"name":"scope"}],"output":{"generics":["scope"],"name":"option"}}],[11,"encl_scope","","Returns the narrowest scope that encloses `id`, if any.",405,{"inputs":[{"name":"self"},{"name":"scope"}],"output":{"name":"scope"}}],[11,"var_scope","","Returns the lifetime of the local variable `var_id`",405,{"inputs":[{"name":"self"},{"name":"itemlocalid"}],"output":{"name":"scope"}}],[11,"temporary_scope","","Returns the scope when temp created by expr_id will be cleaned up",405,{"inputs":[{"name":"self"},{"name":"itemlocalid"}],"output":{"generics":["scope"],"name":"option"}}],[11,"var_region","","Returns the lifetime of the variable `id`.",405,{"inputs":[{"name":"self"},{"name":"itemlocalid"}],"output":{"name":"regionkind"}}],[11,"scopes_intersect","","",405,{"inputs":[{"name":"self"},{"name":"scope"},{"name":"scope"}],"output":{"name":"bool"}}],[11,"is_subscope_of","","Returns true if `subscope` is equal to or is lexically nested inside `superscope` and false otherwise.",405,{"inputs":[{"name":"self"},{"name":"scope"},{"name":"scope"}],"output":{"name":"bool"}}],[11,"containing_body","","Returns the id of the innermost containing body",405,{"inputs":[{"name":"self"},{"name":"scope"}],"output":{"generics":["itemlocalid"],"name":"option"}}],[11,"nearest_common_ancestor","","Finds the nearest common ancestor (if any) of two scopes.  That is, finds the smallest scope which is greater than or equal to both `scope_a` and `scope_b`.",405,{"inputs":[{"name":"self"},{"name":"scope"},{"name":"scope"}],"output":{"name":"scope"}}],[11,"early_free_scope","","Assuming that the provided region was defined within this `ScopeTree`, returns the outermost `Scope` that the region outlives.",405,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"earlyboundregion"}],"output":{"name":"scope"}}],[11,"free_scope","","Assuming that the provided region was defined within this `ScopeTree`, returns the outermost `Scope` that the region outlives.",405,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"freeregion"}],"output":{"name":"scope"}}],[11,"yield_in_scope","","Checks whether the given scope contains a `yield`. If so, returns `Some((span, expr_count))` with the span of a yield we found and the number of expressions and patterns appearing before the `yield` in the body + 1. If there a are multiple yields in a scope, the one with the highest number is returned.",405,{"inputs":[{"name":"self"},{"name":"scope"}],"output":{"name":"option"}}],[11,"yield_in_scope_for_expr","","Checks whether the given scope contains a `yield` and if that yield could execute after `expr`. If so, it returns the span of that `yield`. `scope` must be inside the body.",405,{"inputs":[{"name":"self"},{"name":"scope"},{"name":"nodeid"},{"name":"body"}],"output":{"generics":["span"],"name":"option"}}],[11,"body_expr_count","","Gives the number of expressions visited in a body. Used to sanity check visit_expr call count when calculating generator interiors.",405,{"inputs":[{"name":"self"},{"name":"bodyid"}],"output":{"generics":["usize"],"name":"option"}}],[11,"record_child_scope","","Records the current parent (if any) as the parent of `child_scope`.",407,{"inputs":[{"name":"self"},{"name":"scope"}],"output":null}],[11,"enter_scope","","Records the current parent (if any) as the parent of `child_scope`, and sets `child_scope` as the new current parent.",407,{"inputs":[{"name":"self"},{"name":"scope"}],"output":null}],[11,"enter_node_scope_with_dtor","","",407,{"inputs":[{"name":"self"},{"name":"itemlocalid"}],"output":null}],[11,"nested_visit_map","","",407,{"inputs":[{"name":"self"}],"output":{"name":"nestedvisitormap"}}],[11,"visit_block","","",407,{"inputs":[{"name":"self"},{"name":"block"}],"output":null}],[11,"visit_body","","",407,{"inputs":[{"name":"self"},{"name":"body"}],"output":null}],[11,"visit_arm","","",407,{"inputs":[{"name":"self"},{"name":"arm"}],"output":null}],[11,"visit_pat","","",407,{"inputs":[{"name":"self"},{"name":"pat"}],"output":null}],[11,"visit_stmt","","",407,{"inputs":[{"name":"self"},{"name":"stmt"}],"output":null}],[11,"visit_expr","","",407,{"inputs":[{"name":"self"},{"name":"expr"}],"output":null}],[11,"visit_local","","",407,{"inputs":[{"name":"self"},{"name":"local"}],"output":null}],[11,"hash_stable","","",405,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[0,"recursion_limit","rustc::middle","",null,null],[5,"update_limits","rustc::middle::recursion_limit","",null,{"inputs":[{"name":"session"},{"name":"crate"}],"output":null}],[5,"update_limit","","",null,{"inputs":[{"name":"session"},{"name":"crate"},{"name":"once"},{"name":"str"},{"name":"str"},{"name":"usize"}],"output":null}],[0,"resolve_lifetime","rustc::middle","Name resolution for lifetimes.",null,null],[3,"NamedRegionMap","rustc::middle::resolve_lifetime","Maps the id of each lifetime reference to the lifetime decl that it corresponds to.",null,null],[12,"defs","","",410,null],[12,"late_bound","","",410,null],[12,"object_lifetime_defaults","","",410,null],[3,"ResolveLifetimes","","See `NamedRegionMap`.",null,null],[12,"defs","","",411,null],[12,"late_bound","","",411,null],[12,"object_lifetime_defaults","","",411,null],[3,"LifetimeContext","","",null,null],[12,"tcx","","",412,null],[12,"map","","",412,null],[12,"scope","","",412,null],[12,"trait_ref_hack","","",412,null],[12,"is_in_fn_syntax","","",412,null],[12,"labels_in_fn","","",412,null],[12,"xcrate_object_lifetime_defaults","","",412,null],[12,"lifetime_uses","","",412,null],[3,"ElisionFailureInfo","","",null,null],[12,"parent","","Where we can find the argument pattern.",413,null],[12,"index","","The index of the argument in the original definition.",413,null],[12,"lifetime_count","","",413,null],[12,"have_bound_regions","","",413,null],[3,"Original","","",null,null],[12,"kind","","",414,null],[12,"span","","",414,null],[3,"Shadower","","",null,null],[12,"kind","","",415,null],[12,"span","","",415,null],[4,"LifetimeDefOrigin","","The origin of a named lifetime definition.",null,null],[13,"Explicit","","",416,null],[13,"InBand","","",416,null],[4,"LifetimeUseSet","","",null,null],[13,"One","","",417,null],[13,"Many","","",417,null],[4,"Region","","",null,null],[13,"Static","","",418,null],[13,"EarlyBound","","",418,null],[13,"LateBound","","",418,null],[13,"LateBoundAnon","","",418,null],[13,"Free","","",418,null],[4,"Set1","","A set containing, at most, one known element. If two distinct values are inserted into a set, then it becomes `Many`, which can be used to detect ambiguities.",null,null],[13,"Empty","","",419,null],[13,"One","","",419,null],[13,"Many","","",419,null],[4,"Scope","","",null,null],[13,"Binder","","Declares lifetimes, and each can be early-bound or late-bound. The `DebruijnIndex` of late-bound lifetimes starts at `1` and it should be shifted by the number of `Binder`s in between the declaration `Binder` and the location it's referenced from.",420,null],[12,"lifetimes","rustc::middle::resolve_lifetime::Scope","",420,null],[12,"next_early_index","","if we extend this scope with another scope, what is the next index we should use for an early-bound region?",420,null],[12,"abstract_type_parent","","Whether or not this binder would serve as the parent binder for abstract types introduced within. For example:",420,null],[12,"s","","",420,null],[13,"Body","rustc::middle::resolve_lifetime","Lifetimes introduced by a fn are scoped to the call-site for that fn, if this is a fn body, otherwise the original definitions are used. Unspecified lifetimes are inferred, unless an elision scope is nested, e.g. `(&T, fn(&T) -> &T);` becomes `(&'_ T, for<'a> fn(&'a T) -> &'a T)`.",420,null],[12,"id","rustc::middle::resolve_lifetime::Scope","",420,null],[12,"s","","",420,null],[13,"Elision","rustc::middle::resolve_lifetime","A scope which either determines unspecified lifetimes or errors on them (e.g. due to ambiguity). For more details, see `Elide`.",420,null],[12,"elide","rustc::middle::resolve_lifetime::Scope","",420,null],[12,"s","","",420,null],[13,"ObjectLifetimeDefault","rustc::middle::resolve_lifetime","Use a specific lifetime (if `Some`) or leave it unset (to be inferred in a function body or potentially error outside one), for the default choice of lifetime in a trait object type.",420,null],[12,"lifetime","rustc::middle::resolve_lifetime::Scope","",420,null],[12,"s","","",420,null],[13,"Root","rustc::middle::resolve_lifetime","",420,null],[4,"Elide","","",null,null],[13,"FreshLateAnon","","Use a fresh anonymous late-bound lifetime each time, by incrementing the counter to generate sequential indices.",421,null],[13,"Exact","","Always use this one lifetime.",421,null],[13,"Error","","Less or more than one lifetime were found, error on unspecified.",421,null],[4,"ShadowKind","","",null,null],[13,"Label","","",422,null],[13,"Lifetime","","",422,null],[5,"provide","","",null,{"inputs":[{"name":"providers"}],"output":null}],[5,"resolve_lifetimes","","Computes the `ResolveLifetimes` map that contains data for the entire crate. You should not read the result of this query directly, but rather use `named_region_map`, `is_late_bound_map`, etc.",null,{"inputs":[{"name":"tyctxt"},{"name":"cratenum"}],"output":{"generics":["resolvelifetimes"],"name":"lrc"}}],[5,"krate","","",null,{"inputs":[{"name":"tyctxt"}],"output":{"name":"namedregionmap"}}],[5,"original_label","","",null,{"inputs":[{"name":"span"}],"output":{"name":"original"}}],[5,"shadower_label","","",null,{"inputs":[{"name":"span"}],"output":{"name":"shadower"}}],[5,"original_lifetime","","",null,{"inputs":[{"name":"span"}],"output":{"name":"original"}}],[5,"shadower_lifetime","","",null,{"inputs":[{"name":"lifetime"}],"output":{"name":"shadower"}}],[5,"check_mixed_explicit_and_in_band_defs","","",null,null],[5,"signal_shadowing_problem","","",null,{"inputs":[{"name":"tyctxt"},{"name":"name"},{"name":"original"},{"name":"shadower"}],"output":null}],[5,"extract_labels","","",null,{"inputs":[{"name":"lifetimecontext"},{"name":"body"}],"output":null}],[5,"compute_object_lifetime_defaults","","",null,{"inputs":[{"name":"tyctxt"}],"output":{"generics":["vec"],"name":"nodemap"}}],[5,"object_lifetime_defaults_for_item","","Scan the bounds and where-clauses on parameters to extract bounds of the form `T:'a` so as to determine the `ObjectLifetimeDefault` for each type parameter.",null,{"inputs":[{"name":"tyctxt"},{"name":"generics"}],"output":{"generics":["objectlifetimedefault"],"name":"vec"}}],[5,"insert_late_bound_lifetimes","","Detects late-bound lifetimes and inserts them into `map.late_bound`.",null,{"inputs":[{"name":"namedregionmap"},{"name":"fndecl"},{"name":"generics"}],"output":null}],[5,"report_missing_lifetime_specifiers","","",null,{"inputs":[{"name":"session"},{"name":"span"},{"name":"usize"}],"output":{"name":"diagnosticbuilder"}}],[6,"ObjectLifetimeDefault","","",null,null],[6,"ScopeRef","","",null,null],[17,"ROOT_SCOPE","","",null,null],[11,"clone","","",416,{"inputs":[{"name":"self"}],"output":{"name":"lifetimedeforigin"}}],[11,"eq","","",416,{"inputs":[{"name":"self"},{"name":"lifetimedeforigin"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",416,null],[11,"hash","","",416,null],[11,"encode","","",416,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",416,{"inputs":[{"name":"__d"}],"output":{"generics":["lifetimedeforigin"],"name":"result"}}],[11,"fmt","","",416,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"from_is_in_band","","",416,{"inputs":[{"name":"bool"}],"output":{"name":"self"}}],[11,"clone","","",417,{"inputs":[{"name":"self"}],"output":{"name":"lifetimeuseset"}}],[11,"fmt","","",417,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",418,{"inputs":[{"name":"self"}],"output":{"name":"region"}}],[11,"eq","","",418,{"inputs":[{"name":"self"},{"name":"region"}],"output":{"name":"bool"}}],[11,"ne","","",418,{"inputs":[{"name":"self"},{"name":"region"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",418,null],[11,"hash","","",418,null],[11,"encode","","",418,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",418,{"inputs":[{"name":"__d"}],"output":{"generics":["region"],"name":"result"}}],[11,"fmt","","",418,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"early","","",418,null],[11,"late","","",418,null],[11,"late_anon","","",418,{"inputs":[{"name":"cell"}],"output":{"name":"region"}}],[11,"id","","",418,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"shifted","","",418,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"region"}}],[11,"from_depth","","",418,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"region"}}],[11,"subst","","",418,null],[11,"clone","","",419,{"inputs":[{"name":"self"}],"output":{"name":"set1"}}],[11,"eq","","",419,{"inputs":[{"name":"self"},{"name":"set1"}],"output":{"name":"bool"}}],[11,"ne","","",419,{"inputs":[{"name":"self"},{"name":"set1"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",419,null],[11,"encode","","",419,{"inputs":[{"name":"self"},{"name":"__st"}],"output":{"name":"result"}}],[11,"decode","","",419,{"inputs":[{"name":"__dt"}],"output":{"generics":["set1"],"name":"result"}}],[11,"fmt","","",419,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"insert","","",419,{"inputs":[{"name":"self"},{"name":"t"}],"output":null}],[11,"default","","",410,{"inputs":[],"output":{"name":"namedregionmap"}}],[11,"hash_stable","","",411,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"fmt","","",420,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",421,{"inputs":[{"name":"self"}],"output":{"name":"elide"}}],[11,"fmt","","",421,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",413,{"inputs":[{"name":"self"}],"output":{"name":"elisionfailureinfo"}}],[11,"fmt","","",413,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"nested_visit_map","","",412,{"inputs":[{"name":"self"}],"output":{"name":"nestedvisitormap"}}],[11,"visit_nested_item","","",412,{"inputs":[{"name":"self"},{"name":"itemid"}],"output":null}],[11,"visit_nested_body","","",412,{"inputs":[{"name":"self"},{"name":"bodyid"}],"output":null}],[11,"visit_item","","",412,{"inputs":[{"name":"self"},{"name":"item"}],"output":null}],[11,"visit_foreign_item","","",412,{"inputs":[{"name":"self"},{"name":"foreignitem"}],"output":null}],[11,"visit_ty","","",412,{"inputs":[{"name":"self"},{"name":"ty"}],"output":null}],[11,"visit_trait_item","","",412,{"inputs":[{"name":"self"},{"name":"traititem"}],"output":null}],[11,"visit_impl_item","","",412,{"inputs":[{"name":"self"},{"name":"implitem"}],"output":null}],[11,"visit_lifetime","","",412,{"inputs":[{"name":"self"},{"name":"lifetime"}],"output":null}],[11,"visit_path","","",412,{"inputs":[{"name":"self"},{"name":"path"},{"name":"nodeid"}],"output":null}],[11,"visit_fn_decl","","",412,{"inputs":[{"name":"self"},{"name":"fndecl"}],"output":null}],[11,"visit_generics","","",412,{"inputs":[{"name":"self"},{"name":"generics"}],"output":null}],[11,"visit_poly_trait_ref","","",412,{"inputs":[{"name":"self"},{"name":"polytraitref"},{"name":"traitboundmodifier"}],"output":null}],[11,"clone","","",422,{"inputs":[{"name":"self"}],"output":{"name":"shadowkind"}}],[11,"eq","","",422,{"inputs":[{"name":"self"},{"name":"shadowkind"}],"output":{"name":"bool"}}],[11,"desc","","",422,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"hack","","",412,{"inputs":[{"name":"self"},{"name":"f"}],"output":null}],[11,"with","","",412,{"inputs":[{"name":"self"},{"name":"scope"},{"name":"f"}],"output":null}],[11,"visit_early_late","","Visits self by adding a scope and handling recursive walk over the contents with `walk`.",412,{"inputs":[{"name":"self"},{"generics":["nodeid"],"name":"option"},{"name":"fndecl"},{"name":"generics"},{"name":"f"}],"output":null}],[11,"next_early_index_helper","","",412,{"inputs":[{"name":"self"},{"name":"bool"}],"output":{"name":"u32"}}],[11,"next_early_index","","Returns the next index one would use for an early-bound-region if extending the current scope.",412,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"next_early_index_for_abstract_type","","Returns the next index one would use for an `impl Trait` that is being converted into an `abstract type`. This will be the next early index from the enclosing item, for the most part. See the `abstract_type_parent` field for more info.",412,{"inputs":[{"name":"self"}],"output":{"name":"u32"}}],[11,"resolve_lifetime_ref","","",412,{"inputs":[{"name":"self"},{"name":"lifetime"}],"output":null}],[11,"visit_segment_parameters","","",412,{"inputs":[{"name":"self"},{"name":"def"},{"name":"usize"},{"name":"pathparameters"}],"output":null}],[11,"visit_fn_like_elision","","",412,null],[11,"resolve_elided_lifetimes","","",412,null],[11,"report_elision_failure","","",412,null],[11,"resolve_object_lifetime_default","","",412,{"inputs":[{"name":"self"},{"name":"lifetime"}],"output":null}],[11,"check_lifetime_params","","",412,null],[11,"check_lifetime_def_for_shadowing","","",412,{"inputs":[{"name":"self"},{"name":"scope"},{"name":"lifetime"}],"output":null}],[11,"insert_lifetime","","",412,{"inputs":[{"name":"self"},{"name":"lifetime"},{"name":"region"}],"output":null}],[0,"stability","rustc::middle","A pass that annotates every item and method with its stability level, propagating default levels lexically from parent to children ast nodes.",null,null],[3,"DeprecationEntry","rustc::middle::stability","An entry in the `depr_map`.",null,null],[12,"attr","","The metadata of the attribute associated with this entry.",423,null],[12,"origin","","The def id where the attr was originally attached. `None` for non-local `DefId`'s.",423,null],[3,"Index","","A stability index, giving the stability level for items and methods.",null,null],[12,"stab_map","","This is mostly a cache, except the stabilities of local items are filled by the annotator.",424,null],[12,"depr_map","","",424,null],[12,"staged_api","","Maps for each crate whether it is part of the staged API.",424,null],[12,"active_features","","Features enabled for this crate.",424,null],[3,"Annotator","","",null,null],[12,"tcx","","",425,null],[12,"index","","",425,null],[12,"parent_stab","","",425,null],[12,"parent_depr","","",425,null],[12,"in_trait_impl","","",425,null],[3,"MissingStabilityAnnotations","","",null,null],[12,"tcx","","",426,null],[12,"access_levels","","",426,null],[3,"Checker","","",null,null],[12,"tcx","","",427,null],[4,"StabilityLevel","","",null,null],[13,"Unstable","","",428,null],[13,"Stable","","",428,null],[4,"AnnotationKind","","",null,null],[13,"Required","","",429,null],[13,"Prohibited","","",429,null],[13,"Container","","",429,null],[4,"EvalResult","","Result of `TyCtxt::eval_stability`.",null,null],[13,"Allow","","We can use the item because it is stable or we provided the corresponding feature gate.",430,null],[13,"Deny","","We cannot use the item because it is unstable and we did not provide the corresponding feature gate.",430,null],[12,"feature","rustc::middle::stability::EvalResult","",430,null],[12,"reason","","",430,null],[12,"issue","","",430,null],[13,"Unmarked","rustc::middle::stability","The item does not have the `#[stable]` or `#[unstable]` marker assigned.",430,null],[5,"check_unstable_api_usage","","Cross-references the feature names of unstable APIs with enabled features and possibly prints errors.",null,{"inputs":[{"name":"tyctxt"}],"output":null}],[5,"deprecation_in_effect","","Check whether an item marked with `deprecated(since=\"X\")` is currently deprecated (i.e. whether X is not greater than the current rustc version).",null,{"inputs":[{"name":"str"}],"output":{"name":"bool"}}],[5,"check_unused_or_stable_features","","Given the list of enabled features that were not language features (i.e. that were expected to be library features), and the list of features used from libraries, identify activated features that don't exist and error about them.",null,{"inputs":[{"name":"tyctxt"}],"output":null}],[5,"format_stable_since_msg","","",null,{"inputs":[{"name":"str"}],"output":{"name":"string"}}],[11,"encode","","",428,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",428,{"inputs":[{"name":"__d"}],"output":{"generics":["stabilitylevel"],"name":"result"}}],[11,"eq","","",428,{"inputs":[{"name":"self"},{"name":"stabilitylevel"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",428,{"inputs":[{"name":"self"},{"name":"stabilitylevel"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"clone","","",428,{"inputs":[{"name":"self"}],"output":{"name":"stabilitylevel"}}],[11,"fmt","","",428,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"assert_receiver_is_total_eq","","",428,null],[11,"hash","","",428,null],[11,"from_attr_level","","",428,{"inputs":[{"name":"stabilitylevel"}],"output":{"name":"self"}}],[11,"eq","","",429,{"inputs":[{"name":"self"},{"name":"annotationkind"}],"output":{"name":"bool"}}],[11,"clone","","",423,{"inputs":[{"name":"self"}],"output":{"name":"deprecationentry"}}],[11,"hash_stable","","",423,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"local","","",423,{"inputs":[{"name":"deprecation"},{"name":"hirid"}],"output":{"name":"deprecationentry"}}],[11,"external","","",423,{"inputs":[{"name":"deprecation"}],"output":{"name":"deprecationentry"}}],[11,"same_origin","","",423,{"inputs":[{"name":"self"},{"name":"deprecationentry"}],"output":{"name":"bool"}}],[11,"hash_stable","","",424,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"annotate","","",425,null],[11,"nested_visit_map","","Because stability levels are scoped lexically, we want to walk nested items in the context of the outer item, so enable deep-walking.",425,{"inputs":[{"name":"self"}],"output":{"name":"nestedvisitormap"}}],[11,"visit_item","","",425,{"inputs":[{"name":"self"},{"name":"item"}],"output":null}],[11,"visit_trait_item","","",425,{"inputs":[{"name":"self"},{"name":"traititem"}],"output":null}],[11,"visit_impl_item","","",425,{"inputs":[{"name":"self"},{"name":"implitem"}],"output":null}],[11,"visit_variant","","",425,{"inputs":[{"name":"self"},{"name":"variant"},{"name":"generics"},{"name":"nodeid"}],"output":null}],[11,"visit_struct_field","","",425,{"inputs":[{"name":"self"},{"name":"structfield"}],"output":null}],[11,"visit_foreign_item","","",425,{"inputs":[{"name":"self"},{"name":"foreignitem"}],"output":null}],[11,"visit_macro_def","","",425,{"inputs":[{"name":"self"},{"name":"macrodef"}],"output":null}],[11,"check_missing_stability","","",426,{"inputs":[{"name":"self"},{"name":"nodeid"},{"name":"span"}],"output":null}],[11,"nested_visit_map","","",426,{"inputs":[{"name":"self"}],"output":{"name":"nestedvisitormap"}}],[11,"visit_item","","",426,{"inputs":[{"name":"self"},{"name":"item"}],"output":null}],[11,"visit_trait_item","","",426,{"inputs":[{"name":"self"},{"name":"traititem"}],"output":null}],[11,"visit_impl_item","","",426,{"inputs":[{"name":"self"},{"name":"implitem"}],"output":null}],[11,"visit_variant","","",426,{"inputs":[{"name":"self"},{"name":"variant"},{"name":"generics"},{"name":"nodeid"}],"output":null}],[11,"visit_struct_field","","",426,{"inputs":[{"name":"self"},{"name":"structfield"}],"output":null}],[11,"visit_foreign_item","","",426,{"inputs":[{"name":"self"},{"name":"foreignitem"}],"output":null}],[11,"visit_macro_def","","",426,{"inputs":[{"name":"self"},{"name":"macrodef"}],"output":null}],[11,"new","","",424,{"inputs":[{"name":"tyctxt"}],"output":{"name":"index"}}],[11,"local_stability","","",424,{"inputs":[{"name":"self"},{"name":"hirid"}],"output":{"generics":["stability"],"name":"option"}}],[11,"local_deprecation_entry","","",424,{"inputs":[{"name":"self"},{"name":"hirid"}],"output":{"generics":["deprecationentry"],"name":"option"}}],[11,"nested_visit_map","","Because stability levels are scoped lexically, we want to walk nested items in the context of the outer item, so enable deep-walking.",427,{"inputs":[{"name":"self"}],"output":{"name":"nestedvisitormap"}}],[11,"visit_item","","",427,{"inputs":[{"name":"self"},{"name":"item"}],"output":null}],[11,"visit_path","","",427,{"inputs":[{"name":"self"},{"name":"path"},{"name":"nodeid"}],"output":null}],[0,"weak_lang_items","rustc::middle","Validity checking for weak lang items",null,null],[3,"Context","rustc::middle::weak_lang_items","",null,null],[12,"tcx","","",431,null],[12,"items","","",431,null],[5,"check_crate","","Checks the crate for usage of weak lang items, returning a vector of all the language items required by this crate, but not defined yet.",null,{"inputs":[{"name":"tyctxt"},{"name":"languageitems"}],"output":null}],[5,"link_name","","",null,null],[5,"whitelisted","","Returns whether the specified `lang_item` doesn't actually need to be present for this compilation.",null,{"inputs":[{"name":"tyctxt"},{"name":"langitem"}],"output":{"name":"bool"}}],[5,"verify","","",null,{"inputs":[{"name":"tyctxt"},{"name":"languageitems"}],"output":null}],[11,"register","","",431,{"inputs":[{"name":"self"},{"name":"str"},{"name":"span"}],"output":null}],[11,"nested_visit_map","","",431,{"inputs":[{"name":"self"}],"output":{"name":"nestedvisitormap"}}],[11,"visit_foreign_item","","",431,{"inputs":[{"name":"self"},{"name":"foreignitem"}],"output":null}],[0,"mir","rustc","MIR datatypes and passes. See the [rustc guide] for more info.",null,null],[3,"Mir","rustc::mir","Lowered representation of a single function.",null,null],[12,"basic_blocks","","List of basic blocks. References to basic block use a newtyped index type `BasicBlock` that indexes into this vector.",432,null],[12,"visibility_scopes","","List of visibility (lexical) scopes; these are referenced by statements and used (eventually) for debuginfo. Indexed by a `VisibilityScope`.",432,null],[12,"visibility_scope_info","","Crate-local information for each visibility scope, that can't (and needn't) be tracked across crates.",432,null],[12,"promoted","","Rvalues promoted from this function, such as borrows of constants. Each of them is the Mir of a constant with the fn's type parameters in scope, but a separate set of locals.",432,null],[12,"yield_ty","","Yield type of the function, if it is a generator.",432,null],[12,"generator_drop","","Generator drop glue",432,null],[12,"generator_layout","","The layout of a generator. Produced by the state transformation.",432,null],[12,"local_decls","","Declarations of locals.",432,null],[12,"arg_count","","Number of arguments this function takes.",432,null],[12,"upvar_decls","","Names and capture modes of all the closure upvars, assuming the first argument is either the closure or a reference to it.",432,null],[12,"spread_arg","","Mark an argument local (which must be a tuple) as getting passed as its individual components at the LLVM level.",432,null],[12,"span","","A span representing this MIR, for error reporting",432,null],[12,"cache","","A cache for various calculations",432,null],[3,"VisibilityScopeInfo","","",null,null],[12,"lint_root","","A NodeId with lint levels equivalent to this scope's lint levels.",433,null],[12,"safety","","The unsafe block that contains this node.",433,null],[3,"SourceInfo","","Grouped information about the source code origin of a MIR entity. Intended to be inspected by diagnostics and debuginfo. Most passes can work with it as a whole, within a single function.",null,null],[12,"span","","Source span for the AST pertaining to this MIR entity.",434,null],[12,"scope","","The lexical visibility scope, i.e. which bindings can be seen.",434,null],[3,"Local","","",null,null],[12,"0","","",435,null],[3,"LocalDecl","","A MIR local.",null,null],[12,"mutability","","`let mut x` vs `let x`.",436,null],[12,"is_user_variable","","True if this corresponds to a user-declared local variable.",436,null],[12,"internal","","True if this is an internal local",436,null],[12,"ty","","Type of this local.",436,null],[12,"name","","Name of the local, used in debuginfo and pretty-printing.",436,null],[12,"source_info","","Source info of the local.",436,null],[12,"syntactic_scope","","The syntactic visibility scope the local is defined in. If the local was defined in a let-statement, this is within the let-statement, rather than outside of it.",436,null],[3,"UpvarDecl","","A closure capture, with its name and mode.",null,null],[12,"debug_name","","",437,null],[12,"by_ref","","If true, the capture is behind a reference.",437,null],[12,"mutability","","",437,null],[3,"BasicBlock","","",null,null],[12,"0","","",438,null],[3,"BasicBlockData","","",null,null],[12,"statements","","List of statements in this block.",439,null],[12,"terminator","","Terminator for this block.",439,null],[12,"is_cleanup","","If true, this block lies on an unwind path. This is used during trans where distinct kinds of basic blocks may be generated (particularly for MSVC cleanup). Unwind blocks must only branch to other unwind blocks.",439,null],[3,"Terminator","","",null,null],[12,"source_info","","",440,null],[12,"kind","","",440,null],[3,"Statement","","",null,null],[12,"source_info","","",441,null],[12,"kind","","",441,null],[3,"ValidationOperand","","",null,null],[12,"place","","",442,null],[12,"ty","","",442,null],[12,"re","","",442,null],[12,"mutbl","","",442,null],[3,"Static","","The def-id of a static, along with its normalized type (which is stored to avoid requiring normalization when reading MIR).",null,null],[12,"def_id","","",443,null],[12,"ty","","",443,null],[3,"Projection","","The `Projection` data structure defines things of the form `B.x` or `*B` or `B[index]`. Note that it is parameterized because it is shared between `Constant` and `Place`. See the aliases `PlaceProjection` etc below.",null,null],[12,"base","","",444,null],[12,"elem","","",444,null],[3,"Field","","",null,null],[12,"0","","",445,null],[3,"VisibilityScope","","",null,null],[12,"0","","",446,null],[3,"VisibilityScopeData","","",null,null],[12,"span","","",447,null],[12,"parent_scope","","",447,null],[3,"Constant","","Constants",null,null],[12,"span","","",448,null],[12,"ty","","",448,null],[12,"literal","","",448,null],[3,"Promoted","","",null,null],[12,"0","","",449,null],[3,"Location","","",null,null],[12,"block","","the location is within this block",450,null],[12,"statement_index","","the location is the start of the statement; or, if `statement_index` == num-statements, then the start of the terminator.",450,null],[3,"UnsafetyViolation","","",null,null],[12,"source_info","","",451,null],[12,"description","","",451,null],[12,"kind","","",451,null],[3,"UnsafetyCheckResult","","",null,null],[12,"violations","","Violations that are propagated upwards from this function",452,null],[12,"unsafe_blocks","","unsafe blocks in this function, along with whether they are used. This is used for the \"unused_unsafe\" lint.",452,null],[3,"GeneratorLayout","","The layout of generator state",null,null],[12,"fields","","",453,null],[3,"BorrowCheckResult","","",null,null],[12,"closure_requirements","","",454,null],[12,"used_mut_upvars","","",454,null],[3,"ClosureRegionRequirements","","After we borrow check a closure, we are left with various requirements that we have inferred between the free regions that appear in the closure's signature or on its field types.  These requirements are then verified and proved by the closure's creating function. This struct encodes those requirements.",null,null],[12,"num_external_vids","","The number of external regions defined on the closure.  In our example above, it would be 3 -- one for `'static`, then `'1` and `'2`. This is just used for a sanity check later on, to make sure that the number of regions we see at the callsite matches.",455,null],[12,"outlives_requirements","","Requirements between the various free regions defined in indices.",455,null],[3,"ClosureOutlivesRequirement","","Indicates an outlives constraint between a type or between two free-regions declared on the closure.",null,null],[12,"subject","","",456,null],[12,"outlived_free_region","","",456,null],[12,"blame_span","","",456,null],[4,"Safety","","",null,null],[13,"Safe","","",457,null],[13,"BuiltinUnsafe","","Unsafe because of a PushUnsafeBlock",457,null],[13,"FnUnsafe","","Unsafe because of an unsafe fn",457,null],[13,"ExplicitUnsafe","","Unsafe because of an `unsafe` block",457,null],[4,"ClearCrossCrate","","",null,null],[13,"Clear","","",458,null],[13,"Set","","",458,null],[4,"Mutability","","",null,null],[13,"Mut","","",459,null],[13,"Not","","",459,null],[4,"BorrowKind","","",null,null],[13,"Shared","","Data must be immutable and is aliasable.",460,null],[13,"Unique","","Data must be immutable but not aliasable.  This kind of borrow cannot currently be expressed by the user and is used only in implicit closure bindings. It is needed when you the closure is borrowing or mutating a mutable referent, e.g.:",460,null],[13,"Mut","","Data is mutable and not aliasable.",460,null],[12,"allow_two_phase_borrow","rustc::mir::BorrowKind","True if this borrow arose from method-call auto-ref (i.e. `adjustment::Adjust::Borrow`)",460,null],[4,"LocalKind","rustc::mir","Classifies locals into categories. See `Mir::local_kind`.",null,null],[13,"Var","","User-declared variable binding",461,null],[13,"Temp","","Compiler-introduced temporary",461,null],[13,"Arg","","Function argument",461,null],[13,"ReturnPointer","","Location of function's return value",461,null],[4,"TerminatorKind","","",null,null],[13,"Goto","","block should have one successor in the graph; we jump there",462,null],[12,"target","rustc::mir::TerminatorKind","",462,null],[13,"SwitchInt","rustc::mir","operand evaluates to an integer; jump depending on its value to one of the targets, and otherwise fallback to `otherwise`",462,null],[12,"discr","rustc::mir::TerminatorKind","discriminant value being tested",462,null],[12,"switch_ty","","type of value being tested",462,null],[12,"values","","Possible values. The locations to branch to in each case are found in the corresponding indices from the `targets` vector.",462,null],[12,"targets","","Possible branch sites. The last element of this vector is used for the otherwise branch, so targets.len() == values.len() + 1 should hold.",462,null],[13,"Resume","rustc::mir","Indicates that the landing pad is finished and unwinding should continue. Emitted by build::scope::diverge_cleanup.",462,null],[13,"Abort","","Indicates that the landing pad is finished and that the process should abort. Used to prevent unwinding for foreign items.",462,null],[13,"Return","","Indicates a normal return. The return place should have been filled in by now. This should occur at most once.",462,null],[13,"Unreachable","","Indicates a terminator that can never be reached.",462,null],[13,"Drop","","Drop the Place",462,null],[12,"location","rustc::mir::TerminatorKind","",462,null],[12,"target","","",462,null],[12,"unwind","","",462,null],[13,"DropAndReplace","rustc::mir","Drop the Place and assign the new value over it. This ensures that the assignment to `P` occurs even if the destructor for place unwinds. Its semantics are best explained by by the elaboration:",462,null],[12,"location","rustc::mir::TerminatorKind","",462,null],[12,"value","","",462,null],[12,"target","","",462,null],[12,"unwind","","",462,null],[13,"Call","rustc::mir","Block ends with a call of a converging function",462,null],[12,"func","rustc::mir::TerminatorKind","The function that’s being called",462,null],[12,"args","","Arguments the function is called with. These are owned by the callee, which is free to modify them. This allows the memory occupied by \"by-value\" arguments to be reused across function calls without duplicating the contents.",462,null],[12,"destination","","Destination for the return value. If some, the call is converging.",462,null],[12,"cleanup","","Cleanups to be done if the call unwinds.",462,null],[13,"Assert","rustc::mir","Jump to the target if the condition has the expected value, otherwise panic with a message and a cleanup target.",462,null],[12,"cond","rustc::mir::TerminatorKind","",462,null],[12,"expected","","",462,null],[12,"msg","","",462,null],[12,"target","","",462,null],[12,"cleanup","","",462,null],[13,"Yield","rustc::mir","A suspend point",462,null],[12,"value","rustc::mir::TerminatorKind","The value to return",462,null],[12,"resume","","Where to resume to",462,null],[12,"drop","","Cleanup to be done if the generator is dropped at this suspend point",462,null],[13,"GeneratorDrop","rustc::mir","Indicates the end of the dropping of a generator",462,null],[13,"FalseEdges","","A block where control flow only ever takes one real path, but borrowck needs to be more conservative.",462,null],[12,"real_target","rustc::mir::TerminatorKind","The target normal control flow will take",462,null],[12,"imaginary_targets","","The list of blocks control flow could conceptually take, but won't in practice",462,null],[13,"FalseUnwind","rustc::mir","A terminator for blocks that only take one path in reality, but where we reserve the right to unwind in borrowck, even if it won't happen in practice. This can arise in infinite loops with no function calls for example.",462,null],[12,"real_target","rustc::mir::TerminatorKind","The target normal control flow will take",462,null],[12,"unwind","","The imaginary cleanup block link. This particular path will never be taken in practice, but in order to avoid fragility we want to always consider it in borrowck. We don't want to accept programs which pass borrowck only when panic=abort or some assertions are disabled due to release vs. debug mode builds. This needs to be an Option because of the remove_noop_landing_pads and no_landing_pads passes",462,null],[4,"StatementKind","rustc::mir","",null,null],[13,"Assign","","Write the RHS Rvalue to the LHS Place.",463,null],[13,"SetDiscriminant","","Write the discriminant for a variant to the enum Place.",463,null],[12,"place","rustc::mir::StatementKind","",463,null],[12,"variant_index","","",463,null],[13,"StorageLive","rustc::mir","Start a live range for the storage of the local.",463,null],[13,"StorageDead","","End the current live range for the storage of the local.",463,null],[13,"InlineAsm","","Execute a piece of inline Assembly.",463,null],[12,"asm","rustc::mir::StatementKind","",463,null],[12,"outputs","","",463,null],[12,"inputs","","",463,null],[13,"Validate","rustc::mir","Assert the given places to be valid inhabitants of their type.  These statements are currently only interpreted by miri and only generated when \"-Z mir-emit-validate\" is passed. See https://internals.rust-lang.org/t/types-as-contracts/5562/73 for more details.",463,null],[13,"EndRegion","","Mark one terminating point of a region scope (i.e. static region). (The starting point(s) arise implicitly from borrows.)",463,null],[13,"UserAssertTy","","Encodes a user's type assertion. These need to be preserved intact so that NLL can respect them. For example:",463,null],[13,"Nop","","No-op. Useful for deleting instructions without affecting statement indices.",463,null],[4,"ValidationOp","","The `ValidationOp` describes what happens with each of the operands of a `Validate` statement.",null,null],[13,"Acquire","","Recursively traverse the place following the type and validate that all type invariants are maintained.  Furthermore, acquire exclusive/read-only access to the memory reachable from the place.",464,null],[13,"Release","","Recursive traverse the mutable part of the type and relinquish all exclusive access.",464,null],[13,"Suspend","","Recursive traverse the mutable part of the type and relinquish all exclusive access until the given region ends.  Then, access will be recovered.",464,null],[4,"Place","","A path to a value; something that can be evaluated without changing or disturbing program state.",null,null],[13,"Local","","local variable",465,null],[13,"Static","","static or static mut variable",465,null],[13,"Projection","","projection out of a place (access a field, deref a pointer, etc)",465,null],[4,"ProjectionElem","","",null,null],[13,"Deref","","",466,null],[13,"Field","","",466,null],[13,"Index","","",466,null],[13,"ConstantIndex","","These indices are generated by slice patterns. Easiest to explain by example:",466,null],[12,"offset","rustc::mir::ProjectionElem","index or -index (in Python terms), depending on from_end",466,null],[12,"min_length","","thing being indexed must be at least this long",466,null],[12,"from_end","","counting backwards from end?",466,null],[13,"Subslice","rustc::mir","These indices are generated by slice patterns.",466,null],[12,"from","rustc::mir::ProjectionElem","",466,null],[12,"to","","",466,null],[13,"Downcast","rustc::mir","\"Downcast\" to a variant of an ADT. Currently, we only introduce this for ADTs with more than one variant. It may be better to just introduce it always, or always for enums.",466,null],[4,"Operand","","These are values that can appear inside an rvalue (or an index place). They are intentionally limited to prevent rvalues from being nested in one another.",null,null],[13,"Copy","","Copy: The value must be available for use afterwards.",467,null],[13,"Move","","Move: The value (including old borrows of it) will not be used again.",467,null],[13,"Constant","","",467,null],[4,"Rvalue","","Rvalues",null,null],[13,"Use","","x (either a move or copy, depending on type of x)",468,null],[13,"Repeat","","[x; 32]",468,null],[13,"Ref","","&x or &mut x",468,null],[13,"Len","","length of a [X] or [X;n] value",468,null],[13,"Cast","","",468,null],[13,"BinaryOp","","",468,null],[13,"CheckedBinaryOp","","",468,null],[13,"NullaryOp","","",468,null],[13,"UnaryOp","","",468,null],[13,"Discriminant","","Read the discriminant of an ADT.",468,null],[13,"Aggregate","","Create an aggregate value, like a tuple or struct.  This is only needed because we want to distinguish `dest = Foo { x: ..., y: ... }` from `dest.x = ...; dest.y = ...;` in the case that `Foo` has a destructor. These rvalues can be optimized away after type-checking and before lowering.",468,null],[4,"CastKind","","",null,null],[13,"Misc","","",469,null],[13,"ReifyFnPointer","","Convert unique, zero-sized type for a fn to fn()",469,null],[13,"ClosureFnPointer","","Convert non capturing closure to fn()",469,null],[13,"UnsafeFnPointer","","Convert safe fn() to unsafe fn()",469,null],[13,"Unsize","","\"Unsize\" -- convert a thin-or-fat pointer to a fat pointer. trans must figure out the details once full monomorphization is known. For example, this could be used to cast from a `&[i32;N]` to a `&[i32]`, or a `Box<T>` to a `Box<Trait>` (presuming `T: Trait`).",469,null],[4,"AggregateKind","","",null,null],[13,"Array","","The type is of the element",470,null],[13,"Tuple","","",470,null],[13,"Adt","","The second field is the variant index. It's equal to 0 for struct and union expressions. The fourth field is active field number and is present only for union expressions -- e.g. for a union expression `SomeUnion { c: .. }`, the active field index would identity the field `c`",470,null],[13,"Closure","","",470,null],[13,"Generator","","",470,null],[4,"BinOp","","",null,null],[13,"Add","","The `+` operator (addition)",471,null],[13,"Sub","","The `-` operator (subtraction)",471,null],[13,"Mul","","The `*` operator (multiplication)",471,null],[13,"Div","","The `/` operator (division)",471,null],[13,"Rem","","The `%` operator (modulus)",471,null],[13,"BitXor","","The `^` operator (bitwise xor)",471,null],[13,"BitAnd","","The `&` operator (bitwise and)",471,null],[13,"BitOr","","The `|` operator (bitwise or)",471,null],[13,"Shl","","The `<<` operator (shift left)",471,null],[13,"Shr","","The `>>` operator (shift right)",471,null],[13,"Eq","","The `==` operator (equality)",471,null],[13,"Lt","","The `<` operator (less than)",471,null],[13,"Le","","The `<=` operator (less than or equal to)",471,null],[13,"Ne","","The `!=` operator (not equal to)",471,null],[13,"Ge","","The `>=` operator (greater than or equal to)",471,null],[13,"Gt","","The `>` operator (greater than)",471,null],[13,"Offset","","The `ptr.offset` operator",471,null],[4,"NullOp","","",null,null],[13,"SizeOf","","Return the size of a value of that type",472,null],[13,"Box","","Create a new uninitialized box for a value of that type",472,null],[4,"UnOp","","",null,null],[13,"Not","","The `!` operator for logical inversion",473,null],[13,"Neg","","The `-` operator for negation",473,null],[4,"Literal","","",null,null],[13,"Value","","",474,null],[12,"value","rustc::mir::Literal","",474,null],[13,"Promoted","rustc::mir","",474,null],[12,"index","rustc::mir::Literal","",474,null],[4,"UnsafetyViolationKind","rustc::mir","",null,null],[13,"General","","",475,null],[13,"ExternStatic","","",475,null],[13,"BorrowPacked","","",475,null],[4,"ClosureOutlivesSubject","","The subject of a ClosureOutlivesRequirement -- that is, the thing that must outlive some region.",null,null],[13,"Ty","","Subject is a type, typically a type parameter, but could also be a projection. Indicates a requirement like `T: 'a` being passed to the caller, where the type here is `T`.",476,null],[13,"Region","","Subject is a free region from the closure. Indicates a requirement like `'a: 'b` being passed to the caller; the region here is `'a`.",476,null],[5,"fmt_const_val","","Write a `ConstVal` in a way closer to the original source code than the `Debug` output.",null,{"inputs":[{"name":"w"},{"name":"const"}],"output":{"name":"result"}}],[5,"print_miri_value","","",null,{"inputs":[{"name":"value"},{"name":"ty"},{"name":"w"}],"output":{"name":"result"}}],[5,"item_path_str","","",null,{"inputs":[{"name":"defid"}],"output":{"name":"string"}}],[0,"cache","","",null,null],[3,"Cache","rustc::mir::cache","",null,null],[12,"predecessors","","",477,null],[5,"calculate_predecessors","","",null,{"inputs":[{"name":"mir"}],"output":{"generics":["basicblock","vec"],"name":"indexvec"}}],[11,"clone","","",477,{"inputs":[{"name":"self"}],"output":{"name":"cache"}}],[11,"fmt","","",477,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",477,{"inputs":[{"name":"self"},{"name":"s"}],"output":{"name":"result"}}],[11,"decode","","",477,{"inputs":[{"name":"d"}],"output":{"name":"result"}}],[11,"hash_stable","","",477,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"new","","",477,{"inputs":[],"output":{"name":"self"}}],[11,"invalidate","","",477,{"inputs":[{"name":"self"}],"output":null}],[11,"predecessors","","",477,{"inputs":[{"name":"self"},{"name":"mir"}],"output":{"generics":["indexvec"],"name":"readguard"}}],[11,"super_fold_with","","",477,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"cache"}}],[11,"super_visit_with","","",477,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"lift_to_tcx","","",477,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[0,"tcx","rustc::mir","Methods for the various MIR types. These are intended for use after building is complete.",null,null],[4,"PlaceTy","rustc::mir::tcx","",null,null],[13,"Ty","","Normal type.",478,null],[12,"ty","rustc::mir::tcx::PlaceTy","",478,null],[13,"Downcast","rustc::mir::tcx","Downcast to a particular variant of an enum.",478,null],[12,"adt_def","rustc::mir::tcx::PlaceTy","",478,null],[12,"substs","","",478,null],[12,"variant_index","","",478,null],[4,"RvalueInitializationState","rustc::mir::tcx","",null,null],[13,"Shallow","","",479,null],[13,"Deep","","",479,null],[11,"clone","","",478,{"inputs":[{"name":"self"}],"output":{"name":"placety"}}],[11,"fmt","","",478,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"from_ty","","",478,{"inputs":[{"name":"ty"}],"output":{"name":"placety"}}],[11,"to_ty","","",478,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"ty"}}],[11,"projection_ty","","",478,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"placeelem"}],"output":{"name":"placety"}}],[11,"super_fold_with","","",478,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",478,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"ty","rustc::mir","",465,{"inputs":[{"name":"self"},{"name":"d"},{"name":"tyctxt"}],"output":{"name":"placety"}}],[11,"ty","","",468,{"inputs":[{"name":"self"},{"name":"d"},{"name":"tyctxt"}],"output":{"name":"ty"}}],[11,"initialization_state","","Returns whether this rvalue is deeply initialized (most rvalues) or whether its only shallowly initialized (`Rvalue::Box`).",468,{"inputs":[{"name":"self"}],"output":{"name":"rvalueinitializationstate"}}],[11,"ty","","",467,{"inputs":[{"name":"self"},{"name":"d"},{"name":"tyctxt"}],"output":{"name":"ty"}}],[11,"ty","","",471,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"ty"},{"name":"ty"}],"output":{"name":"ty"}}],[11,"to_mutbl_lossy","","",460,{"inputs":[{"name":"self"}],"output":{"name":"mutability"}}],[11,"to_hir_binop","","",471,{"inputs":[{"name":"self"}],"output":{"name":"binop_"}}],[0,"visit","","",null,null],[4,"TyContext","rustc::mir::visit","Extra information passed to `visit_ty` and friends to give context about where the type etc appears.",null,null],[13,"LocalDecl","","",480,null],[12,"local","rustc::mir::visit::TyContext","The index of the local variable we are visiting.",480,null],[12,"source_info","","The source location where this local variable was declared.",480,null],[13,"ReturnTy","rustc::mir::visit","The return type of the function.",480,null],[13,"YieldTy","","",480,null],[13,"Location","","A type found at some location.",480,null],[4,"PlaceContext","","",null,null],[13,"Store","","",481,null],[13,"AsmOutput","","",481,null],[13,"Call","","",481,null],[13,"Drop","","",481,null],[13,"Inspect","","",481,null],[13,"Borrow","","",481,null],[12,"region","rustc::mir::visit::PlaceContext","",481,null],[12,"kind","","",481,null],[13,"Projection","rustc::mir::visit","",481,null],[13,"Copy","","",481,null],[13,"Move","","",481,null],[13,"StorageLive","","",481,null],[13,"StorageDead","","",481,null],[13,"Validate","","",481,null],[8,"Visitor","","",null,null],[11,"visit_mir","","",482,{"inputs":[{"name":"self"},{"name":"mir"}],"output":null}],[11,"visit_basic_block_data","","",482,{"inputs":[{"name":"self"},{"name":"basicblock"},{"name":"basicblockdata"}],"output":null}],[11,"visit_visibility_scope_data","","",482,{"inputs":[{"name":"self"},{"name":"visibilityscopedata"}],"output":null}],[11,"visit_statement","","",482,{"inputs":[{"name":"self"},{"name":"basicblock"},{"name":"statement"},{"name":"location"}],"output":null}],[11,"visit_assign","","",482,{"inputs":[{"name":"self"},{"name":"basicblock"},{"name":"place"},{"name":"rvalue"},{"name":"location"}],"output":null}],[11,"visit_terminator","","",482,{"inputs":[{"name":"self"},{"name":"basicblock"},{"name":"terminator"},{"name":"location"}],"output":null}],[11,"visit_terminator_kind","","",482,{"inputs":[{"name":"self"},{"name":"basicblock"},{"name":"terminatorkind"},{"name":"location"}],"output":null}],[11,"visit_assert_message","","",482,{"inputs":[{"name":"self"},{"name":"assertmessage"},{"name":"location"}],"output":null}],[11,"visit_rvalue","","",482,{"inputs":[{"name":"self"},{"name":"rvalue"},{"name":"location"}],"output":null}],[11,"visit_operand","","",482,{"inputs":[{"name":"self"},{"name":"operand"},{"name":"location"}],"output":null}],[11,"visit_user_assert_ty","","",482,{"inputs":[{"name":"self"},{"name":"canonicalty"},{"name":"local"},{"name":"location"}],"output":null}],[11,"visit_place","","",482,{"inputs":[{"name":"self"},{"name":"place"},{"name":"placecontext"},{"name":"location"}],"output":null}],[11,"visit_static","","",482,{"inputs":[{"name":"self"},{"name":"static"},{"name":"placecontext"},{"name":"location"}],"output":null}],[11,"visit_projection","","",482,{"inputs":[{"name":"self"},{"name":"placeprojection"},{"name":"placecontext"},{"name":"location"}],"output":null}],[11,"visit_projection_elem","","",482,{"inputs":[{"name":"self"},{"name":"placeelem"},{"name":"placecontext"},{"name":"location"}],"output":null}],[11,"visit_branch","","",482,{"inputs":[{"name":"self"},{"name":"basicblock"},{"name":"basicblock"}],"output":null}],[11,"visit_constant","","",482,{"inputs":[{"name":"self"},{"name":"constant"},{"name":"location"}],"output":null}],[11,"visit_literal","","",482,{"inputs":[{"name":"self"},{"name":"literal"},{"name":"location"}],"output":null}],[11,"visit_def_id","","",482,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"location"}],"output":null}],[11,"visit_span","","",482,{"inputs":[{"name":"self"},{"name":"span"}],"output":null}],[11,"visit_source_info","","",482,{"inputs":[{"name":"self"},{"name":"sourceinfo"}],"output":null}],[11,"visit_ty","","",482,{"inputs":[{"name":"self"},{"name":"ty"},{"name":"tycontext"}],"output":null}],[11,"visit_region","","",482,{"inputs":[{"name":"self"},{"name":"region"},{"name":"location"}],"output":null}],[11,"visit_const","","",482,{"inputs":[{"name":"self"},{"name":"const"},{"name":"location"}],"output":null}],[11,"visit_substs","","",482,{"inputs":[{"name":"self"},{"name":"substs"},{"name":"location"}],"output":null}],[11,"visit_closure_substs","","",482,{"inputs":[{"name":"self"},{"name":"closuresubsts"},{"name":"location"}],"output":null}],[11,"visit_generator_interior","","",482,{"inputs":[{"name":"self"},{"name":"generatorinterior"},{"name":"location"}],"output":null}],[11,"visit_local_decl","","",482,{"inputs":[{"name":"self"},{"name":"local"},{"name":"localdecl"}],"output":null}],[11,"visit_local","","",482,{"inputs":[{"name":"self"},{"name":"local"},{"name":"placecontext"},{"name":"location"}],"output":null}],[11,"visit_visibility_scope","","",482,{"inputs":[{"name":"self"},{"name":"visibilityscope"}],"output":null}],[11,"super_mir","","",482,{"inputs":[{"name":"self"},{"name":"mir"}],"output":null}],[11,"super_basic_block_data","","",482,{"inputs":[{"name":"self"},{"name":"basicblock"},{"name":"basicblockdata"}],"output":null}],[11,"super_visibility_scope_data","","",482,{"inputs":[{"name":"self"},{"name":"visibilityscopedata"}],"output":null}],[11,"super_statement","","",482,{"inputs":[{"name":"self"},{"name":"basicblock"},{"name":"statement"},{"name":"location"}],"output":null}],[11,"super_assign","","",482,{"inputs":[{"name":"self"},{"name":"basicblock"},{"name":"place"},{"name":"rvalue"},{"name":"location"}],"output":null}],[11,"super_terminator","","",482,{"inputs":[{"name":"self"},{"name":"basicblock"},{"name":"terminator"},{"name":"location"}],"output":null}],[11,"super_terminator_kind","","",482,{"inputs":[{"name":"self"},{"name":"basicblock"},{"name":"terminatorkind"},{"name":"location"}],"output":null}],[11,"super_assert_message","","",482,{"inputs":[{"name":"self"},{"name":"assertmessage"},{"name":"location"}],"output":null}],[11,"super_rvalue","","",482,{"inputs":[{"name":"self"},{"name":"rvalue"},{"name":"location"}],"output":null}],[11,"super_operand","","",482,{"inputs":[{"name":"self"},{"name":"operand"},{"name":"location"}],"output":null}],[11,"super_user_assert_ty","","",482,{"inputs":[{"name":"self"},{"name":"canonicalty"},{"name":"local"},{"name":"location"}],"output":null}],[11,"super_place","","",482,{"inputs":[{"name":"self"},{"name":"place"},{"name":"placecontext"},{"name":"location"}],"output":null}],[11,"super_static","","",482,{"inputs":[{"name":"self"},{"name":"static"},{"name":"placecontext"},{"name":"location"}],"output":null}],[11,"super_projection","","",482,{"inputs":[{"name":"self"},{"name":"placeprojection"},{"name":"placecontext"},{"name":"location"}],"output":null}],[11,"super_projection_elem","","",482,{"inputs":[{"name":"self"},{"name":"placeelem"},{"name":"placecontext"},{"name":"location"}],"output":null}],[11,"super_local_decl","","",482,{"inputs":[{"name":"self"},{"name":"local"},{"name":"localdecl"}],"output":null}],[11,"super_visibility_scope","","",482,{"inputs":[{"name":"self"},{"name":"visibilityscope"}],"output":null}],[11,"super_branch","","",482,{"inputs":[{"name":"self"},{"name":"basicblock"},{"name":"basicblock"}],"output":null}],[11,"super_constant","","",482,{"inputs":[{"name":"self"},{"name":"constant"},{"name":"location"}],"output":null}],[11,"super_literal","","",482,{"inputs":[{"name":"self"},{"name":"literal"},{"name":"location"}],"output":null}],[11,"super_def_id","","",482,{"inputs":[{"name":"self"},{"name":"defid"}],"output":null}],[11,"super_span","","",482,{"inputs":[{"name":"self"},{"name":"span"}],"output":null}],[11,"super_source_info","","",482,{"inputs":[{"name":"self"},{"name":"sourceinfo"}],"output":null}],[11,"super_ty","","",482,{"inputs":[{"name":"self"},{"name":"ty"}],"output":null}],[11,"super_region","","",482,{"inputs":[{"name":"self"},{"name":"region"}],"output":null}],[11,"super_const","","",482,{"inputs":[{"name":"self"},{"name":"const"}],"output":null}],[11,"super_substs","","",482,{"inputs":[{"name":"self"},{"name":"substs"}],"output":null}],[11,"super_generator_interior","","",482,{"inputs":[{"name":"self"},{"name":"generatorinterior"}],"output":null}],[11,"super_closure_substs","","",482,{"inputs":[{"name":"self"},{"name":"closuresubsts"}],"output":null}],[11,"visit_location","","",482,{"inputs":[{"name":"self"},{"name":"mir"},{"name":"location"}],"output":null}],[8,"MutVisitor","","",null,null],[11,"visit_mir","","",483,{"inputs":[{"name":"self"},{"name":"mir"}],"output":null}],[11,"visit_basic_block_data","","",483,{"inputs":[{"name":"self"},{"name":"basicblock"},{"name":"basicblockdata"}],"output":null}],[11,"visit_visibility_scope_data","","",483,{"inputs":[{"name":"self"},{"name":"visibilityscopedata"}],"output":null}],[11,"visit_statement","","",483,{"inputs":[{"name":"self"},{"name":"basicblock"},{"name":"statement"},{"name":"location"}],"output":null}],[11,"visit_assign","","",483,{"inputs":[{"name":"self"},{"name":"basicblock"},{"name":"place"},{"name":"rvalue"},{"name":"location"}],"output":null}],[11,"visit_terminator","","",483,{"inputs":[{"name":"self"},{"name":"basicblock"},{"name":"terminator"},{"name":"location"}],"output":null}],[11,"visit_terminator_kind","","",483,{"inputs":[{"name":"self"},{"name":"basicblock"},{"name":"terminatorkind"},{"name":"location"}],"output":null}],[11,"visit_assert_message","","",483,{"inputs":[{"name":"self"},{"name":"assertmessage"},{"name":"location"}],"output":null}],[11,"visit_rvalue","","",483,{"inputs":[{"name":"self"},{"name":"rvalue"},{"name":"location"}],"output":null}],[11,"visit_operand","","",483,{"inputs":[{"name":"self"},{"name":"operand"},{"name":"location"}],"output":null}],[11,"visit_user_assert_ty","","",483,{"inputs":[{"name":"self"},{"name":"canonicalty"},{"name":"local"},{"name":"location"}],"output":null}],[11,"visit_place","","",483,{"inputs":[{"name":"self"},{"name":"place"},{"name":"placecontext"},{"name":"location"}],"output":null}],[11,"visit_static","","",483,{"inputs":[{"name":"self"},{"name":"static"},{"name":"placecontext"},{"name":"location"}],"output":null}],[11,"visit_projection","","",483,{"inputs":[{"name":"self"},{"name":"placeprojection"},{"name":"placecontext"},{"name":"location"}],"output":null}],[11,"visit_projection_elem","","",483,{"inputs":[{"name":"self"},{"name":"placeelem"},{"name":"placecontext"},{"name":"location"}],"output":null}],[11,"visit_branch","","",483,{"inputs":[{"name":"self"},{"name":"basicblock"},{"name":"basicblock"}],"output":null}],[11,"visit_constant","","",483,{"inputs":[{"name":"self"},{"name":"constant"},{"name":"location"}],"output":null}],[11,"visit_literal","","",483,{"inputs":[{"name":"self"},{"name":"literal"},{"name":"location"}],"output":null}],[11,"visit_def_id","","",483,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"location"}],"output":null}],[11,"visit_span","","",483,{"inputs":[{"name":"self"},{"name":"span"}],"output":null}],[11,"visit_source_info","","",483,{"inputs":[{"name":"self"},{"name":"sourceinfo"}],"output":null}],[11,"visit_ty","","",483,{"inputs":[{"name":"self"},{"name":"ty"},{"name":"tycontext"}],"output":null}],[11,"visit_region","","",483,{"inputs":[{"name":"self"},{"name":"region"},{"name":"location"}],"output":null}],[11,"visit_const","","",483,{"inputs":[{"name":"self"},{"name":"const"},{"name":"location"}],"output":null}],[11,"visit_substs","","",483,{"inputs":[{"name":"self"},{"name":"substs"},{"name":"location"}],"output":null}],[11,"visit_closure_substs","","",483,{"inputs":[{"name":"self"},{"name":"closuresubsts"},{"name":"location"}],"output":null}],[11,"visit_generator_interior","","",483,{"inputs":[{"name":"self"},{"name":"generatorinterior"},{"name":"location"}],"output":null}],[11,"visit_local_decl","","",483,{"inputs":[{"name":"self"},{"name":"local"},{"name":"localdecl"}],"output":null}],[11,"visit_local","","",483,{"inputs":[{"name":"self"},{"name":"local"},{"name":"placecontext"},{"name":"location"}],"output":null}],[11,"visit_visibility_scope","","",483,{"inputs":[{"name":"self"},{"name":"visibilityscope"}],"output":null}],[11,"super_mir","","",483,{"inputs":[{"name":"self"},{"name":"mir"}],"output":null}],[11,"super_basic_block_data","","",483,{"inputs":[{"name":"self"},{"name":"basicblock"},{"name":"basicblockdata"}],"output":null}],[11,"super_visibility_scope_data","","",483,{"inputs":[{"name":"self"},{"name":"visibilityscopedata"}],"output":null}],[11,"super_statement","","",483,{"inputs":[{"name":"self"},{"name":"basicblock"},{"name":"statement"},{"name":"location"}],"output":null}],[11,"super_assign","","",483,{"inputs":[{"name":"self"},{"name":"basicblock"},{"name":"place"},{"name":"rvalue"},{"name":"location"}],"output":null}],[11,"super_terminator","","",483,{"inputs":[{"name":"self"},{"name":"basicblock"},{"name":"terminator"},{"name":"location"}],"output":null}],[11,"super_terminator_kind","","",483,{"inputs":[{"name":"self"},{"name":"basicblock"},{"name":"terminatorkind"},{"name":"location"}],"output":null}],[11,"super_assert_message","","",483,{"inputs":[{"name":"self"},{"name":"assertmessage"},{"name":"location"}],"output":null}],[11,"super_rvalue","","",483,{"inputs":[{"name":"self"},{"name":"rvalue"},{"name":"location"}],"output":null}],[11,"super_operand","","",483,{"inputs":[{"name":"self"},{"name":"operand"},{"name":"location"}],"output":null}],[11,"super_user_assert_ty","","",483,{"inputs":[{"name":"self"},{"name":"canonicalty"},{"name":"local"},{"name":"location"}],"output":null}],[11,"super_place","","",483,{"inputs":[{"name":"self"},{"name":"place"},{"name":"placecontext"},{"name":"location"}],"output":null}],[11,"super_static","","",483,{"inputs":[{"name":"self"},{"name":"static"},{"name":"placecontext"},{"name":"location"}],"output":null}],[11,"super_projection","","",483,{"inputs":[{"name":"self"},{"name":"placeprojection"},{"name":"placecontext"},{"name":"location"}],"output":null}],[11,"super_projection_elem","","",483,{"inputs":[{"name":"self"},{"name":"placeelem"},{"name":"placecontext"},{"name":"location"}],"output":null}],[11,"super_local_decl","","",483,{"inputs":[{"name":"self"},{"name":"local"},{"name":"localdecl"}],"output":null}],[11,"super_visibility_scope","","",483,{"inputs":[{"name":"self"},{"name":"visibilityscope"}],"output":null}],[11,"super_branch","","",483,{"inputs":[{"name":"self"},{"name":"basicblock"},{"name":"basicblock"}],"output":null}],[11,"super_constant","","",483,{"inputs":[{"name":"self"},{"name":"constant"},{"name":"location"}],"output":null}],[11,"super_literal","","",483,{"inputs":[{"name":"self"},{"name":"literal"},{"name":"location"}],"output":null}],[11,"super_def_id","","",483,{"inputs":[{"name":"self"},{"name":"defid"}],"output":null}],[11,"super_span","","",483,{"inputs":[{"name":"self"},{"name":"span"}],"output":null}],[11,"super_source_info","","",483,{"inputs":[{"name":"self"},{"name":"sourceinfo"}],"output":null}],[11,"super_ty","","",483,{"inputs":[{"name":"self"},{"name":"ty"}],"output":null}],[11,"super_region","","",483,{"inputs":[{"name":"self"},{"name":"region"}],"output":null}],[11,"super_const","","",483,{"inputs":[{"name":"self"},{"name":"const"}],"output":null}],[11,"super_substs","","",483,{"inputs":[{"name":"self"},{"name":"substs"}],"output":null}],[11,"super_generator_interior","","",483,{"inputs":[{"name":"self"},{"name":"generatorinterior"}],"output":null}],[11,"super_closure_substs","","",483,{"inputs":[{"name":"self"},{"name":"closuresubsts"}],"output":null}],[11,"visit_location","","",483,{"inputs":[{"name":"self"},{"name":"mir"},{"name":"location"}],"output":null}],[8,"MirVisitable","","",null,null],[10,"apply","","",484,{"inputs":[{"name":"self"},{"name":"location"},{"name":"visitor"}],"output":null}],[11,"apply","rustc::mir","",441,{"inputs":[{"name":"self"},{"name":"location"},{"name":"visitor"}],"output":null}],[11,"apply","","",440,{"inputs":[{"name":"self"},{"name":"location"},{"name":"visitor"}],"output":null}],[11,"clone","rustc::mir::visit","",480,{"inputs":[{"name":"self"}],"output":{"name":"tycontext"}}],[11,"fmt","","",480,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",480,{"inputs":[{"name":"self"},{"name":"tycontext"}],"output":{"name":"bool"}}],[11,"ne","","",480,{"inputs":[{"name":"self"},{"name":"tycontext"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",480,null],[11,"hash","","",480,null],[11,"clone","","",481,{"inputs":[{"name":"self"}],"output":{"name":"placecontext"}}],[11,"fmt","","",481,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",481,{"inputs":[{"name":"self"},{"name":"placecontext"}],"output":{"name":"bool"}}],[11,"ne","","",481,{"inputs":[{"name":"self"},{"name":"placecontext"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",481,null],[11,"is_drop","","Returns true if this place context represents a drop.",481,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_storage_marker","","Returns true if this place context represents a storage live or storage dead marker.",481,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_storage_live_marker","","Returns true if this place context represents a storage live marker.",481,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_storage_dead_marker","","Returns true if this place context represents a storage dead marker.",481,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_mutating_use","","Returns true if this place context represents a use that potentially changes the value.",481,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_nonmutating_use","","Returns true if this place context represents a use that does not change the value.",481,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_use","","",481,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[0,"traversal","rustc::mir","",null,null],[3,"Preorder","rustc::mir::traversal","Preorder traversal of a graph.",null,null],[12,"mir","","",485,null],[12,"visited","","",485,null],[12,"worklist","","",485,null],[3,"Postorder","","Postorder traversal of a graph.",null,null],[12,"mir","","",486,null],[12,"visited","","",486,null],[12,"visit_stack","","",486,null],[3,"ReversePostorder","","Reverse postorder traversal of a graph",null,null],[12,"mir","","",487,null],[12,"blocks","","",487,null],[12,"idx","","",487,null],[5,"preorder","","",null,{"inputs":[{"name":"mir"}],"output":{"name":"preorder"}}],[5,"postorder","","",null,{"inputs":[{"name":"mir"}],"output":{"name":"postorder"}}],[5,"reverse_postorder","","",null,{"inputs":[{"name":"mir"}],"output":{"name":"reversepostorder"}}],[11,"clone","","",485,{"inputs":[{"name":"self"}],"output":{"name":"preorder"}}],[11,"new","","",485,{"inputs":[{"name":"mir"},{"name":"basicblock"}],"output":{"name":"preorder"}}],[11,"next","","",485,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",485,null],[11,"new","","",486,{"inputs":[{"name":"mir"},{"name":"basicblock"}],"output":{"name":"postorder"}}],[11,"traverse_successor","","",486,{"inputs":[{"name":"self"}],"output":null}],[11,"next","","",486,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",486,null],[11,"clone","","",487,{"inputs":[{"name":"self"}],"output":{"name":"reversepostorder"}}],[11,"new","","",487,{"inputs":[{"name":"mir"},{"name":"basicblock"}],"output":{"name":"reversepostorder"}}],[11,"reset","","",487,{"inputs":[{"name":"self"}],"output":null}],[11,"next","","",487,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",487,null],[0,"interpret","rustc::mir","An interpreter for MIR used in CTFE and by miri",null,null],[3,"EvalError","rustc::mir::interpret","",null,null],[12,"kind","","",488,null],[12,"backtrace","","",488,null],[3,"Pointer","","A wrapper type around `PrimVal` that cannot be turned back into a `PrimVal` accidentally. This type clears up a few APIs where having a `PrimVal` argument for something that is potentially an integer pointer or a pointer to an allocation was unclear.",null,null],[12,"primval","","",489,null],[3,"DynamicLifetime","","",null,null],[12,"frame","","",490,null],[12,"region","","",490,null],[3,"GlobalId","","Uniquely identifies a specific constant or static.",null,null],[12,"instance","","For a constant or static, the `Instance` of the item itself. For a promoted global, the `Instance` of the function they belong to.",491,null],[12,"promoted","","The index for promoted globals within their function's `Mir`.",491,null],[3,"MemoryPointer","","",null,null],[12,"alloc_id","","",492,null],[12,"offset","","",492,null],[3,"AllocId","","",null,null],[12,"0","","",493,null],[3,"Allocation","","",null,null],[12,"bytes","","The actual bytes of the allocation. Note that the bytes of a pointer represent the offset of the pointer",494,null],[12,"relocations","","Maps from byte addresses to allocations. Only the first byte of a pointer is inserted into the map.",494,null],[12,"undef_mask","","Denotes undefined memory. Reading from undefined memory is forbidden in miri",494,null],[12,"align","","The alignment of the allocation to detect unaligned reads.",494,null],[12,"runtime_mutability","","Whether the allocation (of a static) should be put into mutable memory when translating",494,null],[3,"UndefMask","","",null,null],[12,"blocks","","",495,null],[12,"len","","",495,null],[4,"EvalErrorKind","","",null,null],[13,"MachineError","","This variant is used by machines to signal their own errors that do not match an existing variant",496,null],[13,"FunctionPointerTyMismatch","","",496,null],[13,"NoMirFor","","",496,null],[13,"UnterminatedCString","","",496,null],[13,"DanglingPointerDeref","","",496,null],[13,"DoubleFree","","",496,null],[13,"InvalidMemoryAccess","","",496,null],[13,"InvalidFunctionPointer","","",496,null],[13,"InvalidBool","","",496,null],[13,"InvalidDiscriminant","","",496,null],[13,"PointerOutOfBounds","","",496,null],[12,"ptr","rustc::mir::interpret::EvalErrorKind","",496,null],[12,"access","","",496,null],[12,"allocation_size","","",496,null],[13,"InvalidNullPointerUsage","rustc::mir::interpret","",496,null],[13,"ReadPointerAsBytes","","",496,null],[13,"ReadBytesAsPointer","","",496,null],[13,"InvalidPointerMath","","",496,null],[13,"ReadUndefBytes","","",496,null],[13,"DeadLocal","","",496,null],[13,"InvalidBoolOp","","",496,null],[13,"Unimplemented","","",496,null],[13,"DerefFunctionPointer","","",496,null],[13,"ExecuteMemory","","",496,null],[13,"BoundsCheck","","",496,null],[12,"len","rustc::mir::interpret::EvalErrorKind","",496,null],[12,"index","","",496,null],[13,"Overflow","rustc::mir::interpret","",496,null],[13,"OverflowNeg","","",496,null],[13,"DivisionByZero","","",496,null],[13,"RemainderByZero","","",496,null],[13,"Intrinsic","","",496,null],[13,"InvalidChar","","",496,null],[13,"StackFrameLimitReached","","",496,null],[13,"OutOfTls","","",496,null],[13,"TlsOutOfBounds","","",496,null],[13,"AbiViolation","","",496,null],[13,"AlignmentCheckFailed","","",496,null],[12,"required","rustc::mir::interpret::EvalErrorKind","",496,null],[12,"has","","",496,null],[13,"MemoryLockViolation","rustc::mir::interpret","",496,null],[12,"ptr","rustc::mir::interpret::EvalErrorKind","",496,null],[12,"len","","",496,null],[12,"frame","","",496,null],[12,"access","","",496,null],[12,"lock","","",496,null],[13,"MemoryAcquireConflict","rustc::mir::interpret","",496,null],[12,"ptr","rustc::mir::interpret::EvalErrorKind","",496,null],[12,"len","","",496,null],[12,"kind","","",496,null],[12,"lock","","",496,null],[13,"InvalidMemoryLockRelease","rustc::mir::interpret","",496,null],[12,"ptr","rustc::mir::interpret::EvalErrorKind","",496,null],[12,"len","","",496,null],[12,"frame","","",496,null],[12,"lock","","",496,null],[13,"DeallocatedLockedMemory","rustc::mir::interpret","",496,null],[12,"ptr","rustc::mir::interpret::EvalErrorKind","",496,null],[12,"lock","","",496,null],[13,"ValidationFailure","rustc::mir::interpret","",496,null],[13,"CalledClosureAsFunction","","",496,null],[13,"VtableForArgumentlessMethod","","",496,null],[13,"ModifiedConstantMemory","","",496,null],[13,"AssumptionNotHeld","","",496,null],[13,"InlineAsm","","",496,null],[13,"TypeNotPrimitive","","",496,null],[13,"ReallocatedWrongMemoryKind","","",496,null],[13,"DeallocatedWrongMemoryKind","","",496,null],[13,"ReallocateNonBasePtr","","",496,null],[13,"DeallocateNonBasePtr","","",496,null],[13,"IncorrectAllocationInformation","","",496,null],[13,"Layout","","",496,null],[13,"HeapAllocZeroBytes","","",496,null],[13,"HeapAllocNonPowerOfTwoAlignment","","",496,null],[13,"Unreachable","","",496,null],[13,"Panic","","",496,null],[13,"ReadFromReturnPointer","","",496,null],[13,"PathNotFound","","",496,null],[13,"UnimplementedTraitSelection","","",496,null],[13,"TypeckError","","Abort in case type errors are reached",496,null],[13,"ReferencedConstant","","Cannot compute this constant because it depends on another one which already produced an error",496,null],[13,"GeneratorResumedAfterReturn","","",496,null],[13,"GeneratorResumedAfterPanic","","",496,null],[4,"PrimVal","","A `PrimVal` represents an immediate, primitive value existing outside of a `memory::Allocation`. It is in many ways like a small chunk of a `Allocation`, up to 8 bytes in size. Like a range of bytes in an `Allocation`, a `PrimVal` can either represent the raw bytes of a simple value, a pointer into another `Allocation`, or be undefined.",null,null],[13,"Bytes","","The raw bytes of a simple value.",497,null],[13,"Ptr","","A pointer into an `Allocation`. An `Allocation` in the `memory` module has a list of relocations, but a `PrimVal` is only large enough to contain one, so we just represent the relocation and its associated offset together as a `MemoryPointer` here.",497,null],[13,"Undef","","An undefined `PrimVal`, for representing values that aren't safe to examine, but are safe to copy around, just like undefined bytes in an `Allocation`.",497,null],[4,"PrimValKind","","",null,null],[13,"I8","","",498,null],[13,"I16","","",498,null],[13,"I32","","",498,null],[13,"I64","","",498,null],[13,"I128","","",498,null],[13,"U8","","",498,null],[13,"U16","","",498,null],[13,"U32","","",498,null],[13,"U64","","",498,null],[13,"U128","","",498,null],[13,"F32","","",498,null],[13,"F64","","",498,null],[13,"Ptr","","",498,null],[13,"FnPtr","","",498,null],[13,"Bool","","",498,null],[13,"Char","","",498,null],[4,"Value","","A `Value` represents a single self-contained Rust value.",null,null],[13,"ByRef","","",499,null],[13,"ByVal","","",499,null],[13,"ByValPair","","",499,null],[4,"Lock","","",null,null],[13,"NoLock","","",500,null],[13,"WriteLock","","",500,null],[13,"ReadLock","","This should never be empty -- that would be a read lock held and nobody there to release it...",500,null],[4,"AccessKind","","",null,null],[13,"Read","","",501,null],[13,"Write","","",501,null],[4,"AllocKind","","",null,null],[13,"Alloc","","",502,null],[13,"Fn","","",502,null],[13,"Static","","",502,null],[5,"specialized_encode_alloc_id","","",null,{"inputs":[{"name":"e"},{"name":"tyctxt"},{"name":"allocid"}],"output":{"name":"result"}}],[5,"specialized_decode_alloc_id","","",null,{"inputs":[{"name":"d"},{"name":"tyctxt"},{"name":"cache"}],"output":{"generics":["allocid"],"name":"result"}}],[5,"bit_index","","",null,null],[0,"error","","",null,null],[3,"EvalError","rustc::mir::interpret::error","",null,null],[12,"kind","","",488,null],[12,"backtrace","","",488,null],[4,"EvalErrorKind","","",null,null],[13,"MachineError","","This variant is used by machines to signal their own errors that do not match an existing variant",496,null],[13,"FunctionPointerTyMismatch","","",496,null],[13,"NoMirFor","","",496,null],[13,"UnterminatedCString","","",496,null],[13,"DanglingPointerDeref","","",496,null],[13,"DoubleFree","","",496,null],[13,"InvalidMemoryAccess","","",496,null],[13,"InvalidFunctionPointer","","",496,null],[13,"InvalidBool","","",496,null],[13,"InvalidDiscriminant","","",496,null],[13,"PointerOutOfBounds","","",496,null],[12,"ptr","rustc::mir::interpret::error::EvalErrorKind","",496,null],[12,"access","","",496,null],[12,"allocation_size","","",496,null],[13,"InvalidNullPointerUsage","rustc::mir::interpret::error","",496,null],[13,"ReadPointerAsBytes","","",496,null],[13,"ReadBytesAsPointer","","",496,null],[13,"InvalidPointerMath","","",496,null],[13,"ReadUndefBytes","","",496,null],[13,"DeadLocal","","",496,null],[13,"InvalidBoolOp","","",496,null],[13,"Unimplemented","","",496,null],[13,"DerefFunctionPointer","","",496,null],[13,"ExecuteMemory","","",496,null],[13,"BoundsCheck","","",496,null],[12,"len","rustc::mir::interpret::error::EvalErrorKind","",496,null],[12,"index","","",496,null],[13,"Overflow","rustc::mir::interpret::error","",496,null],[13,"OverflowNeg","","",496,null],[13,"DivisionByZero","","",496,null],[13,"RemainderByZero","","",496,null],[13,"Intrinsic","","",496,null],[13,"InvalidChar","","",496,null],[13,"StackFrameLimitReached","","",496,null],[13,"OutOfTls","","",496,null],[13,"TlsOutOfBounds","","",496,null],[13,"AbiViolation","","",496,null],[13,"AlignmentCheckFailed","","",496,null],[12,"required","rustc::mir::interpret::error::EvalErrorKind","",496,null],[12,"has","","",496,null],[13,"MemoryLockViolation","rustc::mir::interpret::error","",496,null],[12,"ptr","rustc::mir::interpret::error::EvalErrorKind","",496,null],[12,"len","","",496,null],[12,"frame","","",496,null],[12,"access","","",496,null],[12,"lock","","",496,null],[13,"MemoryAcquireConflict","rustc::mir::interpret::error","",496,null],[12,"ptr","rustc::mir::interpret::error::EvalErrorKind","",496,null],[12,"len","","",496,null],[12,"kind","","",496,null],[12,"lock","","",496,null],[13,"InvalidMemoryLockRelease","rustc::mir::interpret::error","",496,null],[12,"ptr","rustc::mir::interpret::error::EvalErrorKind","",496,null],[12,"len","","",496,null],[12,"frame","","",496,null],[12,"lock","","",496,null],[13,"DeallocatedLockedMemory","rustc::mir::interpret::error","",496,null],[12,"ptr","rustc::mir::interpret::error::EvalErrorKind","",496,null],[12,"lock","","",496,null],[13,"ValidationFailure","rustc::mir::interpret::error","",496,null],[13,"CalledClosureAsFunction","","",496,null],[13,"VtableForArgumentlessMethod","","",496,null],[13,"ModifiedConstantMemory","","",496,null],[13,"AssumptionNotHeld","","",496,null],[13,"InlineAsm","","",496,null],[13,"TypeNotPrimitive","","",496,null],[13,"ReallocatedWrongMemoryKind","","",496,null],[13,"DeallocatedWrongMemoryKind","","",496,null],[13,"ReallocateNonBasePtr","","",496,null],[13,"DeallocateNonBasePtr","","",496,null],[13,"IncorrectAllocationInformation","","",496,null],[13,"Layout","","",496,null],[13,"HeapAllocZeroBytes","","",496,null],[13,"HeapAllocNonPowerOfTwoAlignment","","",496,null],[13,"Unreachable","","",496,null],[13,"Panic","","",496,null],[13,"ReadFromReturnPointer","","",496,null],[13,"PathNotFound","","",496,null],[13,"UnimplementedTraitSelection","","",496,null],[13,"TypeckError","","Abort in case type errors are reached",496,null],[13,"ReferencedConstant","","Cannot compute this constant because it depends on another one which already produced an error",496,null],[13,"GeneratorResumedAfterReturn","","",496,null],[13,"GeneratorResumedAfterPanic","","",496,null],[6,"AssertMessage","","",null,null],[6,"EvalResult","","",null,null],[11,"fmt","rustc::mir::interpret","",488,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",488,{"inputs":[{"name":"self"}],"output":{"name":"evalerror"}}],[11,"from","","",488,{"inputs":[{"generics":["u64"],"name":"evalerrorkind"}],"output":{"name":"self"}}],[11,"clone","","",496,{"inputs":[{"name":"self"}],"output":{"name":"evalerrorkind"}}],[11,"encode","","",496,{"inputs":[{"name":"self"},{"name":"__so"}],"output":{"name":"result"}}],[11,"decode","","",496,{"inputs":[{"name":"__do"}],"output":{"generics":["evalerrorkind"],"name":"result"}}],[11,"description","","",496,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"fmt","","",488,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",496,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[0,"value","","",null,null],[3,"Pointer","rustc::mir::interpret::value","A wrapper type around `PrimVal` that cannot be turned back into a `PrimVal` accidentally. This type clears up a few APIs where having a `PrimVal` argument for something that is potentially an integer pointer or a pointer to an allocation was unclear.",null,null],[12,"primval","","",489,null],[4,"Value","","A `Value` represents a single self-contained Rust value.",null,null],[13,"ByRef","","",499,null],[13,"ByVal","","",499,null],[13,"ByValPair","","",499,null],[4,"PrimVal","","A `PrimVal` represents an immediate, primitive value existing outside of a `memory::Allocation`. It is in many ways like a small chunk of a `Allocation`, up to 8 bytes in size. Like a range of bytes in an `Allocation`, a `PrimVal` can either represent the raw bytes of a simple value, a pointer into another `Allocation`, or be undefined.",null,null],[13,"Bytes","","The raw bytes of a simple value.",497,null],[13,"Ptr","","A pointer into an `Allocation`. An `Allocation` in the `memory` module has a list of relocations, but a `PrimVal` is only large enough to contain one, so we just represent the relocation and its associated offset together as a `MemoryPointer` here.",497,null],[13,"Undef","","An undefined `PrimVal`, for representing values that aren't safe to examine, but are safe to copy around, just like undefined bytes in an `Allocation`.",497,null],[4,"PrimValKind","","",null,null],[13,"I8","","",498,null],[13,"I16","","",498,null],[13,"I32","","",498,null],[13,"I64","","",498,null],[13,"I128","","",498,null],[13,"U8","","",498,null],[13,"U16","","",498,null],[13,"U32","","",498,null],[13,"U64","","",498,null],[13,"U128","","",498,null],[13,"F32","","",498,null],[13,"F64","","",498,null],[13,"Ptr","","",498,null],[13,"FnPtr","","",498,null],[13,"Bool","","",498,null],[13,"Char","","",498,null],[11,"clone","rustc::mir::interpret","",499,{"inputs":[{"name":"self"}],"output":{"name":"value"}}],[11,"fmt","","",499,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"assert_receiver_is_total_eq","","",499,null],[11,"eq","","",499,{"inputs":[{"name":"self"},{"name":"value"}],"output":{"name":"bool"}}],[11,"ne","","",499,{"inputs":[{"name":"self"},{"name":"value"}],"output":{"name":"bool"}}],[11,"encode","","",499,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",499,{"inputs":[{"name":"__d"}],"output":{"generics":["value"],"name":"result"}}],[11,"hash","","",499,null],[11,"super_fold_with","","",499,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"self"}}],[11,"super_visit_with","","",499,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"clone","","",489,{"inputs":[{"name":"self"}],"output":{"name":"pointer"}}],[11,"fmt","","",489,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"assert_receiver_is_total_eq","","",489,null],[11,"eq","","",489,{"inputs":[{"name":"self"},{"name":"pointer"}],"output":{"name":"bool"}}],[11,"ne","","",489,{"inputs":[{"name":"self"},{"name":"pointer"}],"output":{"name":"bool"}}],[11,"encode","","",489,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",489,{"inputs":[{"name":"__d"}],"output":{"generics":["pointer"],"name":"result"}}],[11,"hash","","",489,null],[11,"null","","",489,{"inputs":[],"output":{"name":"self"}}],[11,"to_ptr","","",489,{"inputs":[{"name":"self"}],"output":{"generics":["memorypointer"],"name":"evalresult"}}],[11,"into_inner_primval","","",489,{"inputs":[{"name":"self"}],"output":{"name":"primval"}}],[11,"signed_offset","","",489,{"inputs":[{"name":"self"},{"name":"i64"},{"name":"c"}],"output":{"name":"evalresult"}}],[11,"offset","","",489,{"inputs":[{"name":"self"},{"name":"u64"},{"name":"c"}],"output":{"name":"evalresult"}}],[11,"wrapping_signed_offset","","",489,{"inputs":[{"name":"self"},{"name":"i64"},{"name":"c"}],"output":{"name":"evalresult"}}],[11,"is_null","","",489,{"inputs":[{"name":"self"}],"output":{"generics":["bool"],"name":"evalresult"}}],[11,"to_value_with_len","","",489,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"value"}}],[11,"to_value_with_vtable","","",489,{"inputs":[{"name":"self"},{"name":"memorypointer"}],"output":{"name":"value"}}],[11,"to_value","","",489,{"inputs":[{"name":"self"}],"output":{"name":"value"}}],[11,"from","","",489,{"inputs":[{"name":"primval"}],"output":{"name":"self"}}],[11,"from","","",489,{"inputs":[{"name":"memorypointer"}],"output":{"name":"self"}}],[11,"clone","","",497,{"inputs":[{"name":"self"}],"output":{"name":"primval"}}],[11,"fmt","","",497,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"assert_receiver_is_total_eq","","",497,null],[11,"eq","","",497,{"inputs":[{"name":"self"},{"name":"primval"}],"output":{"name":"bool"}}],[11,"ne","","",497,{"inputs":[{"name":"self"},{"name":"primval"}],"output":{"name":"bool"}}],[11,"encode","","",497,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",497,{"inputs":[{"name":"__d"}],"output":{"generics":["primval"],"name":"result"}}],[11,"hash","","",497,null],[11,"clone","","",498,{"inputs":[{"name":"self"}],"output":{"name":"primvalkind"}}],[11,"fmt","","",498,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",498,{"inputs":[{"name":"self"},{"name":"primvalkind"}],"output":{"name":"bool"}}],[11,"from_u128","","",497,{"inputs":[{"name":"u128"}],"output":{"name":"self"}}],[11,"from_i128","","",497,{"inputs":[{"name":"i128"}],"output":{"name":"self"}}],[11,"from_bool","","",497,{"inputs":[{"name":"bool"}],"output":{"name":"self"}}],[11,"from_char","","",497,{"inputs":[{"name":"char"}],"output":{"name":"self"}}],[11,"to_bytes","","",497,{"inputs":[{"name":"self"}],"output":{"generics":["u128"],"name":"evalresult"}}],[11,"to_ptr","","",497,{"inputs":[{"name":"self"}],"output":{"generics":["memorypointer"],"name":"evalresult"}}],[11,"is_bytes","","",497,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_ptr","","",497,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_undef","","",497,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"to_u128","","",497,{"inputs":[{"name":"self"}],"output":{"generics":["u128"],"name":"evalresult"}}],[11,"to_u64","","",497,{"inputs":[{"name":"self"}],"output":{"generics":["u64"],"name":"evalresult"}}],[11,"to_i32","","",497,{"inputs":[{"name":"self"}],"output":{"generics":["i32"],"name":"evalresult"}}],[11,"to_i128","","",497,{"inputs":[{"name":"self"}],"output":{"generics":["i128"],"name":"evalresult"}}],[11,"to_i64","","",497,{"inputs":[{"name":"self"}],"output":{"generics":["i64"],"name":"evalresult"}}],[11,"to_bool","","",497,{"inputs":[{"name":"self"}],"output":{"generics":["bool"],"name":"evalresult"}}],[11,"is_int","","",498,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_signed_int","","",498,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_float","","",498,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"from_uint_size","","",498,{"inputs":[{"name":"u64"}],"output":{"name":"self"}}],[11,"from_int_size","","",498,{"inputs":[{"name":"u64"}],"output":{"name":"self"}}],[11,"is_ptr","","",498,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[6,"EvalResult","","",null,null],[6,"AssertMessage","","",null,null],[6,"Block","","",null,null],[17,"BLOCK_SIZE","","",null,null],[8,"PointerArithmetic","","",null,null],[11,"truncate_to_ptr","","",503,null],[11,"overflowing_signed_offset","","",503,null],[11,"overflowing_offset","","",503,null],[11,"signed_offset","","",503,{"inputs":[{"name":"self"},{"name":"u64"},{"name":"i64"}],"output":{"generics":["u64"],"name":"evalresult"}}],[11,"offset","","",503,{"inputs":[{"name":"self"},{"name":"u64"},{"name":"u64"}],"output":{"generics":["u64"],"name":"evalresult"}}],[11,"wrapping_signed_offset","","",503,{"inputs":[{"name":"self"},{"name":"u64"},{"name":"i64"}],"output":{"name":"u64"}}],[11,"clone","","",500,{"inputs":[{"name":"self"}],"output":{"name":"lock"}}],[11,"fmt","","",500,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",500,{"inputs":[{"name":"self"},{"name":"lock"}],"output":{"name":"bool"}}],[11,"ne","","",500,{"inputs":[{"name":"self"},{"name":"lock"}],"output":{"name":"bool"}}],[11,"encode","","",500,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",500,{"inputs":[{"name":"__d"}],"output":{"generics":["lock"],"name":"result"}}],[11,"clone","","",490,{"inputs":[{"name":"self"}],"output":{"name":"dynamiclifetime"}}],[11,"fmt","","",490,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",490,{"inputs":[{"name":"self"},{"name":"dynamiclifetime"}],"output":{"name":"bool"}}],[11,"ne","","",490,{"inputs":[{"name":"self"},{"name":"dynamiclifetime"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",490,null],[11,"hash","","",490,null],[11,"encode","","",490,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",490,{"inputs":[{"name":"__d"}],"output":{"generics":["dynamiclifetime"],"name":"result"}}],[11,"clone","","",501,{"inputs":[{"name":"self"}],"output":{"name":"accesskind"}}],[11,"fmt","","",501,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",501,{"inputs":[{"name":"self"},{"name":"accesskind"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",501,null],[11,"encode","","",501,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",501,{"inputs":[{"name":"__d"}],"output":{"generics":["accesskind"],"name":"result"}}],[11,"clone","","",491,{"inputs":[{"name":"self"}],"output":{"name":"globalid"}}],[11,"fmt","","",491,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"assert_receiver_is_total_eq","","",491,null],[11,"eq","","",491,{"inputs":[{"name":"self"},{"name":"globalid"}],"output":{"name":"bool"}}],[11,"ne","","",491,{"inputs":[{"name":"self"},{"name":"globalid"}],"output":{"name":"bool"}}],[11,"hash","","",491,null],[11,"encode","","",491,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",491,{"inputs":[{"name":"__d"}],"output":{"generics":["globalid"],"name":"result"}}],[11,"clone","","",492,{"inputs":[{"name":"self"}],"output":{"name":"memorypointer"}}],[11,"fmt","","",492,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"assert_receiver_is_total_eq","","",492,null],[11,"eq","","",492,{"inputs":[{"name":"self"},{"name":"memorypointer"}],"output":{"name":"bool"}}],[11,"ne","","",492,{"inputs":[{"name":"self"},{"name":"memorypointer"}],"output":{"name":"bool"}}],[11,"encode","","",492,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",492,{"inputs":[{"name":"__d"}],"output":{"generics":["memorypointer"],"name":"result"}}],[11,"hash","","",492,null],[11,"new","","",492,{"inputs":[{"name":"allocid"},{"name":"u64"}],"output":{"name":"self"}}],[11,"wrapping_signed_offset","","",492,{"inputs":[{"name":"self"},{"name":"i64"},{"name":"c"}],"output":{"name":"self"}}],[11,"overflowing_signed_offset","","",492,null],[11,"signed_offset","","",492,{"inputs":[{"name":"self"},{"name":"i64"},{"name":"c"}],"output":{"name":"evalresult"}}],[11,"overflowing_offset","","",492,null],[11,"offset","","",492,{"inputs":[{"name":"self"},{"name":"u64"},{"name":"c"}],"output":{"name":"evalresult"}}],[11,"clone","","",493,{"inputs":[{"name":"self"}],"output":{"name":"allocid"}}],[11,"default","","",493,{"inputs":[],"output":{"name":"allocid"}}],[11,"assert_receiver_is_total_eq","","",493,null],[11,"hash","","",493,null],[11,"cmp","","",493,{"inputs":[{"name":"self"},{"name":"allocid"}],"output":{"name":"ordering"}}],[11,"eq","","",493,{"inputs":[{"name":"self"},{"name":"allocid"}],"output":{"name":"bool"}}],[11,"ne","","",493,{"inputs":[{"name":"self"},{"name":"allocid"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",493,{"inputs":[{"name":"self"},{"name":"allocid"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",493,{"inputs":[{"name":"self"},{"name":"allocid"}],"output":{"name":"bool"}}],[11,"le","","",493,{"inputs":[{"name":"self"},{"name":"allocid"}],"output":{"name":"bool"}}],[11,"gt","","",493,{"inputs":[{"name":"self"},{"name":"allocid"}],"output":{"name":"bool"}}],[11,"ge","","",493,{"inputs":[{"name":"self"},{"name":"allocid"}],"output":{"name":"bool"}}],[11,"fmt","","",493,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"decode","","",502,{"inputs":[{"name":"__d"}],"output":{"generics":["allockind"],"name":"result"}}],[11,"encode","","",502,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"fmt","","",493,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",494,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"assert_receiver_is_total_eq","","",494,null],[11,"eq","","",494,{"inputs":[{"name":"self"},{"name":"allocation"}],"output":{"name":"bool"}}],[11,"ne","","",494,{"inputs":[{"name":"self"},{"name":"allocation"}],"output":{"name":"bool"}}],[11,"hash","","",494,null],[11,"encode","","",494,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",494,{"inputs":[{"name":"__d"}],"output":{"generics":["allocation"],"name":"result"}}],[11,"from_bytes","","",494,null],[11,"clone","","",495,{"inputs":[{"name":"self"}],"output":{"name":"undefmask"}}],[11,"fmt","","",495,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"assert_receiver_is_total_eq","","",495,null],[11,"eq","","",495,{"inputs":[{"name":"self"},{"name":"undefmask"}],"output":{"name":"bool"}}],[11,"ne","","",495,{"inputs":[{"name":"self"},{"name":"undefmask"}],"output":{"name":"bool"}}],[11,"hash","","",495,null],[11,"encode","","",495,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",495,{"inputs":[{"name":"__d"}],"output":{"generics":["undefmask"],"name":"result"}}],[11,"hash_stable","","",495,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"new","","",495,{"inputs":[{"name":"u64"}],"output":{"name":"self"}}],[11,"is_range_defined","","Check whether the range `start..end` (end-exclusive) is entirely defined.",495,{"inputs":[{"name":"self"},{"name":"u64"},{"name":"u64"}],"output":{"name":"bool"}}],[11,"set_range","","",495,{"inputs":[{"name":"self"},{"name":"u64"},{"name":"u64"},{"name":"bool"}],"output":null}],[11,"set_range_inbounds","","",495,{"inputs":[{"name":"self"},{"name":"u64"},{"name":"u64"},{"name":"bool"}],"output":null}],[11,"get","","",495,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"bool"}}],[11,"set","","",495,{"inputs":[{"name":"self"},{"name":"u64"},{"name":"bool"}],"output":null}],[11,"grow","","",495,{"inputs":[{"name":"self"},{"name":"u64"},{"name":"bool"}],"output":null}],[0,"mono","rustc::mir","",null,null],[3,"CodegenUnit","rustc::mir::mono","",null,null],[12,"name","","A name for this CGU. Incremental compilation requires that name be unique amongst all crates.  Therefore, it should contain something unique to this crate (e.g., a module path) as well as the crate name and disambiguator.",504,null],[12,"items","","",504,null],[12,"size_estimate","","",504,null],[3,"Stats","","",null,null],[12,"n_glues_created","","",505,null],[12,"n_null_glues","","",505,null],[12,"n_real_glues","","",505,null],[12,"n_fns","","",505,null],[12,"n_inlines","","",505,null],[12,"n_closures","","",505,null],[12,"n_llvm_insns","","",505,null],[12,"llvm_insns","","",505,null],[12,"fn_stats","","",505,null],[4,"MonoItem","","",null,null],[13,"Fn","","",506,null],[13,"Static","","",506,null],[13,"GlobalAsm","","",506,null],[4,"Linkage","","",null,null],[13,"External","","",507,null],[13,"AvailableExternally","","",507,null],[13,"LinkOnceAny","","",507,null],[13,"LinkOnceODR","","",507,null],[13,"WeakAny","","",507,null],[13,"WeakODR","","",507,null],[13,"Appending","","",507,null],[13,"Internal","","",507,null],[13,"Private","","",507,null],[13,"ExternalWeak","","",507,null],[13,"Common","","",507,null],[4,"Visibility","","",null,null],[13,"Default","","",508,null],[13,"Hidden","","",508,null],[13,"Protected","","",508,null],[11,"eq","","",506,{"inputs":[{"name":"self"},{"name":"monoitem"}],"output":{"name":"bool"}}],[11,"ne","","",506,{"inputs":[{"name":"self"},{"name":"monoitem"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",506,null],[11,"clone","","",506,{"inputs":[{"name":"self"}],"output":{"name":"monoitem"}}],[11,"fmt","","",506,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",506,null],[11,"size_estimate","","",506,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"usize"}}],[11,"hash_stable","","",506,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"clone","","",507,{"inputs":[{"name":"self"}],"output":{"name":"linkage"}}],[11,"eq","","",507,{"inputs":[{"name":"self"},{"name":"linkage"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",507,null],[11,"hash","","",507,null],[11,"fmt","","",507,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",507,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",507,{"inputs":[{"name":"__d"}],"output":{"generics":["linkage"],"name":"result"}}],[11,"hash_stable","","",507,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"clone","","",508,{"inputs":[{"name":"self"}],"output":{"name":"visibility"}}],[11,"eq","","",508,{"inputs":[{"name":"self"},{"name":"visibility"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",508,null],[11,"hash","","",508,null],[11,"fmt","","",508,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash_stable","","",508,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"new","","",504,{"inputs":[{"name":"internedstring"}],"output":{"name":"codegenunit"}}],[11,"name","","",504,{"inputs":[{"name":"self"}],"output":{"name":"internedstring"}}],[11,"set_name","","",504,{"inputs":[{"name":"self"},{"name":"internedstring"}],"output":null}],[11,"items","","",504,{"inputs":[{"name":"self"}],"output":{"name":"fxhashmap"}}],[11,"items_mut","","",504,{"inputs":[{"name":"self"}],"output":{"name":"fxhashmap"}}],[11,"mangle_name","","",504,{"inputs":[{"name":"str"}],"output":{"name":"string"}}],[11,"estimate_size","","",504,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":null}],[11,"size_estimate","","",504,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"modify_size_estimate","","",504,{"inputs":[{"name":"self"},{"name":"usize"}],"output":null}],[11,"hash_stable","","",504,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"clone","","",505,{"inputs":[{"name":"self"}],"output":{"name":"stats"}}],[11,"default","","",505,{"inputs":[],"output":{"name":"stats"}}],[11,"hash_stable","","",505,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"extend","","",505,{"inputs":[{"name":"self"},{"name":"stats"}],"output":null}],[6,"AssertMessage","rustc::mir","",null,null],[6,"LocalDecls","","Types for locals",null,null],[6,"Successors","","",null,null],[6,"SuccessorsMut","","",null,null],[6,"PlaceProjection","","Alias for projections as they appear in places, where the base is a place and the index is a local.",null,null],[6,"PlaceElem","","Alias for projections as they appear in places, where the base is a place and the index is a local.",null,null],[17,"START_BLOCK","","where execution begins",null,null],[17,"RETURN_PLACE","","",null,null],[17,"ARGUMENT_VISIBILITY_SCOPE","","",null,null],[8,"HasLocalDecls","","",null,null],[10,"local_decls","","",509,{"inputs":[{"name":"self"}],"output":{"name":"indexvec"}}],[11,"local_decls","","",432,{"inputs":[{"name":"self"}],"output":{"name":"indexvec"}}],[11,"clone","","",432,{"inputs":[{"name":"self"}],"output":{"name":"mir"}}],[11,"encode","","",432,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",432,{"inputs":[{"name":"__d"}],"output":{"generics":["mir"],"name":"result"}}],[11,"fmt","","",432,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","",432,{"inputs":[{"generics":["basicblock","basicblockdata"],"name":"indexvec"},{"generics":["visibilityscope","visibilityscopedata"],"name":"indexvec"},{"generics":["indexvec"],"name":"clearcrosscrate"},{"generics":["promoted","mir"],"name":"indexvec"},{"generics":["ty"],"name":"option"},{"generics":["local","localdecl"],"name":"indexvec"},{"name":"usize"},{"generics":["upvardecl"],"name":"vec"},{"name":"span"}],"output":{"name":"self"}}],[11,"basic_blocks","","",432,{"inputs":[{"name":"self"}],"output":{"name":"indexvec"}}],[11,"basic_blocks_mut","","",432,{"inputs":[{"name":"self"}],"output":{"name":"indexvec"}}],[11,"basic_blocks_and_local_decls_mut","","",432,null],[11,"predecessors","","",432,{"inputs":[{"name":"self"}],"output":{"generics":["indexvec"],"name":"readguard"}}],[11,"predecessors_for","","",432,{"inputs":[{"name":"self"},{"name":"basicblock"}],"output":{"generics":["vec"],"name":"readguard"}}],[11,"dominators","","",432,{"inputs":[{"name":"self"}],"output":{"generics":["basicblock"],"name":"dominators"}}],[11,"local_kind","","",432,{"inputs":[{"name":"self"},{"name":"local"}],"output":{"name":"localkind"}}],[11,"temps_iter","","Returns an iterator over all temporaries.",432,null],[11,"vars_iter","","Returns an iterator over all user-declared locals.",432,null],[11,"mut_vars_and_args_iter","","Returns an iterator over all user-declared mutable arguments and locals.",432,null],[11,"args_iter","","Returns an iterator over all function arguments.",432,null],[11,"vars_and_temps_iter","","Returns an iterator over all user-defined variables and compiler-generated temporaries (all locals that are neither arguments nor the return place).",432,null],[11,"make_statement_nop","","Changes a statement to a nop. This is both faster than deleting instructions and avoids invalidating statement indices in `Location`s.",432,{"inputs":[{"name":"self"},{"name":"location"}],"output":null}],[11,"source_info","","Returns the source info associated with `location`.",432,{"inputs":[{"name":"self"},{"name":"location"}],"output":{"name":"sourceinfo"}}],[11,"return_ty","","Return the return type, it always return first element from `local_decls` array",432,{"inputs":[{"name":"self"}],"output":{"name":"ty"}}],[11,"clone","","",433,{"inputs":[{"name":"self"}],"output":{"name":"visibilityscopeinfo"}}],[11,"fmt","","",433,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",433,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",433,{"inputs":[{"name":"__d"}],"output":{"generics":["visibilityscopeinfo"],"name":"result"}}],[11,"clone","","",457,{"inputs":[{"name":"self"}],"output":{"name":"safety"}}],[11,"fmt","","",457,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",457,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",457,{"inputs":[{"name":"__d"}],"output":{"generics":["safety"],"name":"result"}}],[11,"hash_stable","","",432,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"index","","",432,{"inputs":[{"name":"self"},{"name":"basicblock"}],"output":{"name":"basicblockdata"}}],[11,"index_mut","","",432,{"inputs":[{"name":"self"},{"name":"basicblock"}],"output":{"name":"basicblockdata"}}],[11,"clone","","",458,{"inputs":[{"name":"self"}],"output":{"name":"clearcrosscrate"}}],[11,"fmt","","",458,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",434,{"inputs":[{"name":"self"}],"output":{"name":"sourceinfo"}}],[11,"fmt","","",434,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",434,{"inputs":[{"name":"self"},{"name":"sourceinfo"}],"output":{"name":"bool"}}],[11,"ne","","",434,{"inputs":[{"name":"self"},{"name":"sourceinfo"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",434,null],[11,"encode","","",434,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",434,{"inputs":[{"name":"__d"}],"output":{"generics":["sourceinfo"],"name":"result"}}],[11,"hash","","",434,null],[11,"clone","","",459,{"inputs":[{"name":"self"}],"output":{"name":"mutability"}}],[11,"fmt","","",459,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",459,{"inputs":[{"name":"self"},{"name":"mutability"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",459,null],[11,"encode","","",459,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",459,{"inputs":[{"name":"__d"}],"output":{"generics":["mutability"],"name":"result"}}],[11,"clone","","",460,{"inputs":[{"name":"self"}],"output":{"name":"borrowkind"}}],[11,"fmt","","",460,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",460,{"inputs":[{"name":"self"},{"name":"borrowkind"}],"output":{"name":"bool"}}],[11,"ne","","",460,{"inputs":[{"name":"self"},{"name":"borrowkind"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",460,null],[11,"encode","","",460,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",460,{"inputs":[{"name":"__d"}],"output":{"generics":["borrowkind"],"name":"result"}}],[11,"allows_two_phase_borrow","","",460,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",435,{"inputs":[{"name":"self"}],"output":{"name":"local"}}],[11,"eq","","",435,{"inputs":[{"name":"self"},{"name":"local"}],"output":{"name":"bool"}}],[11,"ne","","",435,{"inputs":[{"name":"self"},{"name":"local"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",435,null],[11,"hash","","",435,null],[11,"partial_cmp","","",435,{"inputs":[{"name":"self"},{"name":"local"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",435,{"inputs":[{"name":"self"},{"name":"local"}],"output":{"name":"bool"}}],[11,"le","","",435,{"inputs":[{"name":"self"},{"name":"local"}],"output":{"name":"bool"}}],[11,"gt","","",435,{"inputs":[{"name":"self"},{"name":"local"}],"output":{"name":"bool"}}],[11,"ge","","",435,{"inputs":[{"name":"self"},{"name":"local"}],"output":{"name":"bool"}}],[11,"cmp","","",435,{"inputs":[{"name":"self"},{"name":"local"}],"output":{"name":"ordering"}}],[11,"decode","","",435,{"inputs":[{"name":"__d"}],"output":{"generics":["local"],"name":"result"}}],[11,"encode","","",435,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"new","","",435,{"inputs":[{"name":"usize"}],"output":{"name":"self"}}],[11,"index","","",435,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"fmt","","",435,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",461,{"inputs":[{"name":"self"},{"name":"localkind"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",461,null],[11,"fmt","","",461,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",436,{"inputs":[{"name":"self"}],"output":{"name":"localdecl"}}],[11,"fmt","","",436,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",436,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",436,{"inputs":[{"name":"__d"}],"output":{"generics":["localdecl"],"name":"result"}}],[11,"new_temp","","Create a new `LocalDecl` for a temporary.",436,{"inputs":[{"name":"ty"},{"name":"span"}],"output":{"name":"self"}}],[11,"new_internal","","Create a new `LocalDecl` for a internal temporary.",436,{"inputs":[{"name":"ty"},{"name":"span"}],"output":{"name":"self"}}],[11,"new_return_place","","Builds a `LocalDecl` for the return place.",436,{"inputs":[{"name":"ty"},{"name":"span"}],"output":{"name":"localdecl"}}],[11,"clone","","",437,{"inputs":[{"name":"self"}],"output":{"name":"upvardecl"}}],[11,"fmt","","",437,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",437,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",437,{"inputs":[{"name":"__d"}],"output":{"generics":["upvardecl"],"name":"result"}}],[11,"clone","","",438,{"inputs":[{"name":"self"}],"output":{"name":"basicblock"}}],[11,"eq","","",438,{"inputs":[{"name":"self"},{"name":"basicblock"}],"output":{"name":"bool"}}],[11,"ne","","",438,{"inputs":[{"name":"self"},{"name":"basicblock"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",438,null],[11,"hash","","",438,null],[11,"partial_cmp","","",438,{"inputs":[{"name":"self"},{"name":"basicblock"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",438,{"inputs":[{"name":"self"},{"name":"basicblock"}],"output":{"name":"bool"}}],[11,"le","","",438,{"inputs":[{"name":"self"},{"name":"basicblock"}],"output":{"name":"bool"}}],[11,"gt","","",438,{"inputs":[{"name":"self"},{"name":"basicblock"}],"output":{"name":"bool"}}],[11,"ge","","",438,{"inputs":[{"name":"self"},{"name":"basicblock"}],"output":{"name":"bool"}}],[11,"cmp","","",438,{"inputs":[{"name":"self"},{"name":"basicblock"}],"output":{"name":"ordering"}}],[11,"decode","","",438,{"inputs":[{"name":"__d"}],"output":{"generics":["basicblock"],"name":"result"}}],[11,"encode","","",438,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"new","","",438,{"inputs":[{"name":"usize"}],"output":{"name":"self"}}],[11,"index","","",438,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"fmt","","",438,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"start_location","","",438,{"inputs":[{"name":"self"}],"output":{"name":"location"}}],[11,"clone","","",439,{"inputs":[{"name":"self"}],"output":{"name":"basicblockdata"}}],[11,"fmt","","",439,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",439,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",439,{"inputs":[{"name":"__d"}],"output":{"generics":["basicblockdata"],"name":"result"}}],[11,"clone","","",440,{"inputs":[{"name":"self"}],"output":{"name":"terminator"}}],[11,"fmt","","",440,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",440,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",440,{"inputs":[{"name":"__d"}],"output":{"generics":["terminator"],"name":"result"}}],[11,"clone","","",462,{"inputs":[{"name":"self"}],"output":{"name":"terminatorkind"}}],[11,"encode","","",462,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",462,{"inputs":[{"name":"__d"}],"output":{"generics":["terminatorkind"],"name":"result"}}],[11,"successors","","",440,{"inputs":[{"name":"self"}],"output":{"name":"successors"}}],[11,"successors_mut","","",440,{"inputs":[{"name":"self"}],"output":{"name":"successorsmut"}}],[11,"unwind_mut","","",440,{"inputs":[{"name":"self"}],"output":{"generics":["option"],"name":"option"}}],[11,"if_","","",462,{"inputs":[{"name":"tyctxt"},{"name":"operand"},{"name":"basicblock"},{"name":"basicblock"}],"output":{"name":"terminatorkind"}}],[11,"successors","","",462,{"inputs":[{"name":"self"}],"output":{"name":"successors"}}],[11,"successors_mut","","",462,{"inputs":[{"name":"self"}],"output":{"name":"successorsmut"}}],[11,"unwind_mut","","",462,{"inputs":[{"name":"self"}],"output":{"generics":["option"],"name":"option"}}],[11,"new","","",439,{"inputs":[{"generics":["terminator"],"name":"option"}],"output":{"name":"basicblockdata"}}],[11,"terminator","","Accessor for terminator.",439,{"inputs":[{"name":"self"}],"output":{"name":"terminator"}}],[11,"terminator_mut","","",439,{"inputs":[{"name":"self"}],"output":{"name":"terminator"}}],[11,"retain_statements","","",439,{"inputs":[{"name":"self"},{"name":"f"}],"output":null}],[11,"expand_statements","","",439,{"inputs":[{"name":"self"},{"name":"f"}],"output":null}],[11,"visitable","","",439,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"mirvisitable"}}],[11,"fmt","","",462,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt_head","","Write the \"head\" part of the terminator; that is, its name and the data it uses to pick the successor basic block, if any. The only information not included is the list of possible successors, which may be rendered differently between the text and the graphviz format.",462,{"inputs":[{"name":"self"},{"name":"w"}],"output":{"name":"result"}}],[11,"fmt_successor_labels","","Return the list of labels for the edges to the successor basic blocks.",462,{"inputs":[{"name":"self"}],"output":{"generics":["cow"],"name":"vec"}}],[11,"clone","","",441,{"inputs":[{"name":"self"}],"output":{"name":"statement"}}],[11,"encode","","",441,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",441,{"inputs":[{"name":"__d"}],"output":{"generics":["statement"],"name":"result"}}],[11,"make_nop","","Changes a statement to a nop. This is both faster than deleting instructions and avoids invalidating statement indices in `Location`s.",441,{"inputs":[{"name":"self"}],"output":null}],[11,"replace_nop","","Changes a statement to a nop and returns the original statement.",441,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"clone","","",463,{"inputs":[{"name":"self"}],"output":{"name":"statementkind"}}],[11,"fmt","","",463,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",463,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",463,{"inputs":[{"name":"__d"}],"output":{"generics":["statementkind"],"name":"result"}}],[11,"clone","","",464,{"inputs":[{"name":"self"}],"output":{"name":"validationop"}}],[11,"encode","","",464,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",464,{"inputs":[{"name":"__d"}],"output":{"generics":["validationop"],"name":"result"}}],[11,"eq","","",464,{"inputs":[{"name":"self"},{"name":"validationop"}],"output":{"name":"bool"}}],[11,"ne","","",464,{"inputs":[{"name":"self"},{"name":"validationop"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",464,null],[11,"fmt","","",464,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",442,{"inputs":[{"name":"self"}],"output":{"name":"validationoperand"}}],[11,"encode","","",442,{"inputs":[{"name":"self"},{"name":"__st"}],"output":{"name":"result"}}],[11,"decode","","",442,{"inputs":[{"name":"__dt"}],"output":{"generics":["validationoperand"],"name":"result"}}],[11,"fmt","","",442,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",441,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",465,{"inputs":[{"name":"self"}],"output":{"name":"place"}}],[11,"eq","","",465,{"inputs":[{"name":"self"},{"name":"place"}],"output":{"name":"bool"}}],[11,"ne","","",465,{"inputs":[{"name":"self"},{"name":"place"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",465,null],[11,"hash","","",465,null],[11,"encode","","",465,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",465,{"inputs":[{"name":"__d"}],"output":{"generics":["place"],"name":"result"}}],[11,"clone","","",443,{"inputs":[{"name":"self"}],"output":{"name":"static"}}],[11,"eq","","",443,{"inputs":[{"name":"self"},{"name":"static"}],"output":{"name":"bool"}}],[11,"ne","","",443,{"inputs":[{"name":"self"},{"name":"static"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",443,null],[11,"hash","","",443,null],[11,"encode","","",443,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",443,{"inputs":[{"name":"__d"}],"output":{"generics":["static"],"name":"result"}}],[11,"hash_stable","","",443,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"clone","","",444,{"inputs":[{"name":"self"}],"output":{"name":"projection"}}],[11,"fmt","","",444,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",444,{"inputs":[{"name":"self"},{"name":"projection"}],"output":{"name":"bool"}}],[11,"ne","","",444,{"inputs":[{"name":"self"},{"name":"projection"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",444,null],[11,"hash","","",444,null],[11,"encode","","",444,{"inputs":[{"name":"self"},{"name":"__sbvt"}],"output":{"name":"result"}}],[11,"decode","","",444,{"inputs":[{"name":"__dbvt"}],"output":{"generics":["projection"],"name":"result"}}],[11,"clone","","",466,{"inputs":[{"name":"self"}],"output":{"name":"projectionelem"}}],[11,"fmt","","",466,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",466,{"inputs":[{"name":"self"},{"name":"projectionelem"}],"output":{"name":"bool"}}],[11,"ne","","",466,{"inputs":[{"name":"self"},{"name":"projectionelem"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",466,null],[11,"hash","","",466,null],[11,"encode","","",466,{"inputs":[{"name":"self"},{"name":"__svt"}],"output":{"name":"result"}}],[11,"decode","","",466,{"inputs":[{"name":"__dvt"}],"output":{"generics":["projectionelem"],"name":"result"}}],[11,"clone","","",445,{"inputs":[{"name":"self"}],"output":{"name":"field"}}],[11,"eq","","",445,{"inputs":[{"name":"self"},{"name":"field"}],"output":{"name":"bool"}}],[11,"ne","","",445,{"inputs":[{"name":"self"},{"name":"field"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",445,null],[11,"hash","","",445,null],[11,"partial_cmp","","",445,{"inputs":[{"name":"self"},{"name":"field"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",445,{"inputs":[{"name":"self"},{"name":"field"}],"output":{"name":"bool"}}],[11,"le","","",445,{"inputs":[{"name":"self"},{"name":"field"}],"output":{"name":"bool"}}],[11,"gt","","",445,{"inputs":[{"name":"self"},{"name":"field"}],"output":{"name":"bool"}}],[11,"ge","","",445,{"inputs":[{"name":"self"},{"name":"field"}],"output":{"name":"bool"}}],[11,"cmp","","",445,{"inputs":[{"name":"self"},{"name":"field"}],"output":{"name":"ordering"}}],[11,"decode","","",445,{"inputs":[{"name":"__d"}],"output":{"generics":["field"],"name":"result"}}],[11,"encode","","",445,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"new","","",445,{"inputs":[{"name":"usize"}],"output":{"name":"self"}}],[11,"index","","",445,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"fmt","","",445,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"field","","",465,{"inputs":[{"name":"self"},{"name":"field"},{"name":"ty"}],"output":{"name":"place"}}],[11,"deref","","",465,{"inputs":[{"name":"self"}],"output":{"name":"place"}}],[11,"downcast","","",465,{"inputs":[{"name":"self"},{"name":"adtdef"},{"name":"usize"}],"output":{"name":"place"}}],[11,"index","","",465,{"inputs":[{"name":"self"},{"name":"local"}],"output":{"name":"place"}}],[11,"elem","","",465,{"inputs":[{"name":"self"},{"name":"placeelem"}],"output":{"name":"place"}}],[11,"fmt","","",465,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",446,{"inputs":[{"name":"self"}],"output":{"name":"visibilityscope"}}],[11,"eq","","",446,{"inputs":[{"name":"self"},{"name":"visibilityscope"}],"output":{"name":"bool"}}],[11,"ne","","",446,{"inputs":[{"name":"self"},{"name":"visibilityscope"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",446,null],[11,"hash","","",446,null],[11,"partial_cmp","","",446,{"inputs":[{"name":"self"},{"name":"visibilityscope"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",446,{"inputs":[{"name":"self"},{"name":"visibilityscope"}],"output":{"name":"bool"}}],[11,"le","","",446,{"inputs":[{"name":"self"},{"name":"visibilityscope"}],"output":{"name":"bool"}}],[11,"gt","","",446,{"inputs":[{"name":"self"},{"name":"visibilityscope"}],"output":{"name":"bool"}}],[11,"ge","","",446,{"inputs":[{"name":"self"},{"name":"visibilityscope"}],"output":{"name":"bool"}}],[11,"cmp","","",446,{"inputs":[{"name":"self"},{"name":"visibilityscope"}],"output":{"name":"ordering"}}],[11,"decode","","",446,{"inputs":[{"name":"__d"}],"output":{"generics":["visibilityscope"],"name":"result"}}],[11,"encode","","",446,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"new","","",446,{"inputs":[{"name":"usize"}],"output":{"name":"self"}}],[11,"index","","",446,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"fmt","","",446,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",447,{"inputs":[{"name":"self"}],"output":{"name":"visibilityscopedata"}}],[11,"fmt","","",447,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",447,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",447,{"inputs":[{"name":"__d"}],"output":{"generics":["visibilityscopedata"],"name":"result"}}],[11,"clone","","",467,{"inputs":[{"name":"self"}],"output":{"name":"operand"}}],[11,"eq","","",467,{"inputs":[{"name":"self"},{"name":"operand"}],"output":{"name":"bool"}}],[11,"ne","","",467,{"inputs":[{"name":"self"},{"name":"operand"}],"output":{"name":"bool"}}],[11,"encode","","",467,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",467,{"inputs":[{"name":"__d"}],"output":{"generics":["operand"],"name":"result"}}],[11,"fmt","","",467,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"function_handle","","",467,{"inputs":[{"name":"tyctxt"},{"name":"defid"},{"name":"substs"},{"name":"span"}],"output":{"name":"self"}}],[11,"to_copy","","",467,{"inputs":[{"name":"self"}],"output":{"name":"self"}}],[11,"clone","","",468,{"inputs":[{"name":"self"}],"output":{"name":"rvalue"}}],[11,"encode","","",468,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",468,{"inputs":[{"name":"__d"}],"output":{"generics":["rvalue"],"name":"result"}}],[11,"clone","","",469,{"inputs":[{"name":"self"}],"output":{"name":"castkind"}}],[11,"fmt","","",469,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",469,{"inputs":[{"name":"self"},{"name":"castkind"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",469,null],[11,"encode","","",469,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",469,{"inputs":[{"name":"__d"}],"output":{"generics":["castkind"],"name":"result"}}],[11,"clone","","",470,{"inputs":[{"name":"self"}],"output":{"name":"aggregatekind"}}],[11,"fmt","","",470,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",470,{"inputs":[{"name":"self"},{"name":"aggregatekind"}],"output":{"name":"bool"}}],[11,"ne","","",470,{"inputs":[{"name":"self"},{"name":"aggregatekind"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",470,null],[11,"encode","","",470,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",470,{"inputs":[{"name":"__d"}],"output":{"generics":["aggregatekind"],"name":"result"}}],[11,"clone","","",471,{"inputs":[{"name":"self"}],"output":{"name":"binop"}}],[11,"fmt","","",471,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",471,{"inputs":[{"name":"self"},{"name":"binop"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",471,null],[11,"encode","","",471,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",471,{"inputs":[{"name":"__d"}],"output":{"generics":["binop"],"name":"result"}}],[11,"is_checkable","","",471,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",472,{"inputs":[{"name":"self"}],"output":{"name":"nullop"}}],[11,"fmt","","",472,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",472,{"inputs":[{"name":"self"},{"name":"nullop"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",472,null],[11,"encode","","",472,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",472,{"inputs":[{"name":"__d"}],"output":{"generics":["nullop"],"name":"result"}}],[11,"clone","","",473,{"inputs":[{"name":"self"}],"output":{"name":"unop"}}],[11,"fmt","","",473,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",473,{"inputs":[{"name":"self"},{"name":"unop"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",473,null],[11,"encode","","",473,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",473,{"inputs":[{"name":"__d"}],"output":{"generics":["unop"],"name":"result"}}],[11,"fmt","","",468,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",448,{"inputs":[{"name":"self"}],"output":{"name":"constant"}}],[11,"eq","","",448,{"inputs":[{"name":"self"},{"name":"constant"}],"output":{"name":"bool"}}],[11,"ne","","",448,{"inputs":[{"name":"self"},{"name":"constant"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",448,null],[11,"hash","","",448,null],[11,"encode","","",448,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",448,{"inputs":[{"name":"__d"}],"output":{"generics":["constant"],"name":"result"}}],[11,"clone","","",449,{"inputs":[{"name":"self"}],"output":{"name":"promoted"}}],[11,"eq","","",449,{"inputs":[{"name":"self"},{"name":"promoted"}],"output":{"name":"bool"}}],[11,"ne","","",449,{"inputs":[{"name":"self"},{"name":"promoted"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",449,null],[11,"hash","","",449,null],[11,"partial_cmp","","",449,{"inputs":[{"name":"self"},{"name":"promoted"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",449,{"inputs":[{"name":"self"},{"name":"promoted"}],"output":{"name":"bool"}}],[11,"le","","",449,{"inputs":[{"name":"self"},{"name":"promoted"}],"output":{"name":"bool"}}],[11,"gt","","",449,{"inputs":[{"name":"self"},{"name":"promoted"}],"output":{"name":"bool"}}],[11,"ge","","",449,{"inputs":[{"name":"self"},{"name":"promoted"}],"output":{"name":"bool"}}],[11,"cmp","","",449,{"inputs":[{"name":"self"},{"name":"promoted"}],"output":{"name":"ordering"}}],[11,"decode","","",449,{"inputs":[{"name":"__d"}],"output":{"generics":["promoted"],"name":"result"}}],[11,"encode","","",449,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"new","","",449,{"inputs":[{"name":"usize"}],"output":{"name":"self"}}],[11,"index","","",449,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"fmt","","",449,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",474,{"inputs":[{"name":"self"}],"output":{"name":"literal"}}],[11,"eq","","",474,{"inputs":[{"name":"self"},{"name":"literal"}],"output":{"name":"bool"}}],[11,"ne","","",474,{"inputs":[{"name":"self"},{"name":"literal"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",474,null],[11,"hash","","",474,null],[11,"encode","","",474,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",474,{"inputs":[{"name":"__d"}],"output":{"generics":["literal"],"name":"result"}}],[11,"fmt","","",448,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",474,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"num_nodes","","",432,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"start_node","","",432,null],[11,"predecessors","","",432,null],[11,"successors","","",432,null],[11,"clone","","",450,{"inputs":[{"name":"self"}],"output":{"name":"location"}}],[11,"eq","","",450,{"inputs":[{"name":"self"},{"name":"location"}],"output":{"name":"bool"}}],[11,"ne","","",450,{"inputs":[{"name":"self"},{"name":"location"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",450,null],[11,"hash","","",450,null],[11,"cmp","","",450,{"inputs":[{"name":"self"},{"name":"location"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",450,{"inputs":[{"name":"self"},{"name":"location"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",450,{"inputs":[{"name":"self"},{"name":"location"}],"output":{"name":"bool"}}],[11,"le","","",450,{"inputs":[{"name":"self"},{"name":"location"}],"output":{"name":"bool"}}],[11,"gt","","",450,{"inputs":[{"name":"self"},{"name":"location"}],"output":{"name":"bool"}}],[11,"ge","","",450,{"inputs":[{"name":"self"},{"name":"location"}],"output":{"name":"bool"}}],[11,"fmt","","",450,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[18,"START","","",450,null],[11,"successor_within_block","","Returns the location immediately after this one within the enclosing block.",450,{"inputs":[{"name":"self"}],"output":{"name":"location"}}],[11,"dominates","","",450,{"inputs":[{"name":"self"},{"name":"location"},{"name":"dominators"}],"output":{"name":"bool"}}],[11,"clone","","",475,{"inputs":[{"name":"self"}],"output":{"name":"unsafetyviolationkind"}}],[11,"fmt","","",475,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",475,{"inputs":[{"name":"self"},{"name":"unsafetyviolationkind"}],"output":{"name":"bool"}}],[11,"ne","","",475,{"inputs":[{"name":"self"},{"name":"unsafetyviolationkind"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",475,null],[11,"hash","","",475,null],[11,"encode","","",475,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",475,{"inputs":[{"name":"__d"}],"output":{"generics":["unsafetyviolationkind"],"name":"result"}}],[11,"clone","","",451,{"inputs":[{"name":"self"}],"output":{"name":"unsafetyviolation"}}],[11,"fmt","","",451,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",451,{"inputs":[{"name":"self"},{"name":"unsafetyviolation"}],"output":{"name":"bool"}}],[11,"ne","","",451,{"inputs":[{"name":"self"},{"name":"unsafetyviolation"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",451,null],[11,"hash","","",451,null],[11,"encode","","",451,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",451,{"inputs":[{"name":"__d"}],"output":{"generics":["unsafetyviolation"],"name":"result"}}],[11,"clone","","",452,{"inputs":[{"name":"self"}],"output":{"name":"unsafetycheckresult"}}],[11,"fmt","","",452,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",452,{"inputs":[{"name":"self"},{"name":"unsafetycheckresult"}],"output":{"name":"bool"}}],[11,"ne","","",452,{"inputs":[{"name":"self"},{"name":"unsafetycheckresult"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",452,null],[11,"hash","","",452,null],[11,"encode","","",452,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",452,{"inputs":[{"name":"__d"}],"output":{"generics":["unsafetycheckresult"],"name":"result"}}],[11,"clone","","",453,{"inputs":[{"name":"self"}],"output":{"name":"generatorlayout"}}],[11,"fmt","","",453,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",453,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",453,{"inputs":[{"name":"__d"}],"output":{"generics":["generatorlayout"],"name":"result"}}],[11,"clone","","",454,{"inputs":[{"name":"self"}],"output":{"name":"borrowcheckresult"}}],[11,"fmt","","",454,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",454,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",454,{"inputs":[{"name":"__d"}],"output":{"generics":["borrowcheckresult"],"name":"result"}}],[11,"clone","","",455,{"inputs":[{"name":"self"}],"output":{"name":"closureregionrequirements"}}],[11,"fmt","","",455,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",455,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",455,{"inputs":[{"name":"__d"}],"output":{"generics":["closureregionrequirements"],"name":"result"}}],[11,"clone","","",456,{"inputs":[{"name":"self"}],"output":{"name":"closureoutlivesrequirement"}}],[11,"fmt","","",456,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",456,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",456,{"inputs":[{"name":"__d"}],"output":{"generics":["closureoutlivesrequirement"],"name":"result"}}],[11,"clone","","",476,{"inputs":[{"name":"self"}],"output":{"name":"closureoutlivessubject"}}],[11,"fmt","","",476,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"encode","","",476,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",476,{"inputs":[{"name":"__d"}],"output":{"generics":["closureoutlivessubject"],"name":"result"}}],[11,"super_fold_with","","",459,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"mutability"}}],[11,"super_visit_with","","",459,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",434,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"sourceinfo"}}],[11,"super_visit_with","","",434,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",437,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"upvardecl"}}],[11,"super_visit_with","","",437,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",464,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"validationop"}}],[11,"super_visit_with","","",464,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",447,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"visibilityscopedata"}}],[11,"super_visit_with","","",447,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",446,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"visibilityscope"}}],[11,"super_visit_with","","",446,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",433,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"visibilityscopeinfo"}}],[11,"super_visit_with","","",433,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"lift_to_tcx","","",459,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","","",434,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","","",437,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","","",464,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","","",447,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","","",446,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","","",433,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"super_fold_with","","",432,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",432,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",453,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",453,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",436,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",436,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",439,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",439,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",442,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",442,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",441,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",441,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",463,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",463,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",458,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",458,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",440,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"self"}}],[11,"super_visit_with","","",440,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",465,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"self"}}],[11,"super_visit_with","","",465,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",468,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"self"}}],[11,"super_visit_with","","",468,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",467,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"self"}}],[11,"super_visit_with","","",467,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",444,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"self"}}],[11,"super_visit_with","","",444,{"inputs":[{"name":"self"},{"name":"vs"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",445,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"self"}}],[11,"super_visit_with","","",445,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",448,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"self"}}],[11,"super_visit_with","","",448,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",474,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"self"}}],[11,"super_visit_with","","",474,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[0,"session","rustc","",null,null],[3,"CodeStats","rustc::session","",null,null],[12,"type_sizes","","",510,null],[3,"FieldInfo","","",null,null],[12,"name","","",511,null],[12,"offset","","",511,null],[12,"size","","",511,null],[12,"align","","",511,null],[3,"TypeSizeInfo","","",null,null],[12,"kind","","",512,null],[12,"type_description","","",512,null],[12,"align","","",512,null],[12,"overall_size","","",512,null],[12,"packed","","",512,null],[12,"opt_discr_size","","",512,null],[12,"variants","","",512,null],[3,"VariantInfo","","",null,null],[12,"name","","",513,null],[12,"kind","","",513,null],[12,"size","","",513,null],[12,"align","","",513,null],[12,"fields","","",513,null],[3,"Session","","Represents the data associated with a compilation session for a single crate.",null,null],[12,"target","","",514,null],[12,"host","","",514,null],[12,"opts","","",514,null],[12,"parse_sess","","",514,null],[12,"entry_fn","","For a library crate, this is always none",514,null],[12,"plugin_registrar_fn","","",514,null],[12,"derive_registrar_fn","","",514,null],[12,"default_sysroot","","",514,null],[12,"local_crate_source_file","","The name of the root source file of the crate, in the local file system. `None` means that there is no source file.",514,null],[12,"working_dir","","The directory the compiler has been executed in plus a flag indicating if the value stored here has been affected by path remapping.",514,null],[12,"lint_store","","",514,null],[12,"buffered_lints","","",514,null],[12,"one_time_diagnostics","","Set of (DiagnosticId, Option, message) tuples tracking (sub)diagnostics that have been set once, but should not be set again, in order to avoid redundantly verbose output (Issue #24690, #44953).",514,null],[12,"plugin_llvm_passes","","",514,null],[12,"plugin_attributes","","",514,null],[12,"crate_types","","",514,null],[12,"dependency_formats","","",514,null],[12,"crate_disambiguator","","The crate_disambiguator is constructed out of all the `-C metadata` arguments passed to the compiler. Its value together with the crate-name forms a unique global identifier for the crate. It is used to allow multiple crates with the same name to coexist. See the trans::back::symbol_names module for more information.",514,null],[12,"features","","",514,null],[12,"recursion_limit","","The maximum recursion limit for potentially infinitely recursive operations such as auto-dereference and monomorphization.",514,null],[12,"type_length_limit","","The maximum length of types during monomorphization.",514,null],[12,"const_eval_stack_frame_limit","","The maximum number of stackframes allowed in const eval",514,null],[12,"injected_allocator","","The metadata::creader module may inject an allocator/panic_runtime dependency if it didn't already find one, and this tracks what was injected.",514,null],[12,"allocator_kind","","",514,null],[12,"injected_panic_runtime","","",514,null],[12,"imported_macro_spans","","Map from imported macro spans (which consist of the localized span for the macro body) to the macro name and definition span in the source crate.",514,null],[12,"incr_comp_session","","",514,null],[12,"ignored_attr_names","","A cache of attributes ignored by StableHashingContext",514,null],[12,"profile_channel","","Used by -Z profile-queries in util::common",514,null],[12,"perf_stats","","Some measurements that are being gathered during compilation.",514,null],[12,"code_stats","","Data about code being compiled, gathered during compilation.",514,null],[12,"next_node_id","","",514,null],[12,"optimization_fuel_crate","","If -zfuel=crate=n is specified, Some(crate).",514,null],[12,"optimization_fuel_limit","","If -zfuel=crate=n is specified, initially set to n. Otherwise 0.",514,null],[12,"out_of_fuel","","We're rejecting all further optimizations.",514,null],[12,"print_fuel_crate","","If -zprint-fuel=crate, Some(crate).",514,null],[12,"print_fuel","","Always set to zero and incremented so that we can print fuel expended by a crate.",514,null],[12,"jobserver","","Loaded up early on in the initialization of this `Session` to avoid false positives about a job server in our environment.",514,null],[12,"has_global_allocator","","Metadata about the allocators for the current crate being compiled",514,null],[3,"PerfStats","","",null,null],[12,"symbol_hash_time","","The accumulated time spent on computing symbol hashes",515,null],[12,"decode_def_path_tables_time","","The accumulated time spent decoding def path tables from metadata",515,null],[12,"queries_canonicalized","","Total number of values canonicalized queries constructed.",515,null],[12,"normalize_ty_after_erasing_regions","","Number of times this query is invoked.",515,null],[12,"normalize_projection_ty","","Number of times this query is invoked.",515,null],[3,"CrateDisambiguator","","Hash value constructed out of all the `-C metadata` arguments passed to the compiler. Together with the crate-name forms a unique global identifier for the crate.",null,null],[12,"0","","",516,null],[4,"DataTypeKind","","",null,null],[13,"Struct","","",517,null],[13,"Union","","",517,null],[13,"Enum","","",517,null],[13,"Closure","","",517,null],[4,"SizeKind","","",null,null],[13,"Exact","","",518,null],[13,"Min","","",518,null],[4,"DiagnosticBuilderMethod","","Enum to support dispatch of one-time diagnostics (in Session.diag_once)",null,null],[13,"Note","","",519,null],[13,"SpanNote","","",519,null],[13,"SpanSuggestion","","",519,null],[4,"DiagnosticMessageId","","Diagnostic message ID—used by `Session.one_time_diagnostics` to avoid emitting the same message more than once",null,null],[13,"ErrorId","","",520,null],[13,"LintId","","",520,null],[13,"StabilityId","","",520,null],[4,"IncrCompSession","","Holds data on the current incremental compilation session, if there is one.",null,null],[13,"NotInitialized","","This is the state the session will be in until the incr. comp. dir is needed.",521,null],[13,"Active","","This is the state during which the session directory is private and can be modified.",521,null],[12,"session_directory","rustc::session::IncrCompSession","",521,null],[12,"lock_file","","",521,null],[12,"load_dep_graph","","",521,null],[13,"Finalized","rustc::session","This is the state after the session directory has been finalized. In this state, the contents of the directory must not be modified any more.",521,null],[12,"session_directory","rustc::session::IncrCompSession","",521,null],[13,"InvalidBecauseOfErrors","rustc::session","This is an error state that is reached when some compilation error has occurred. It indicates that the contents of the session directory must not be used, since they might be invalid.",521,null],[12,"session_directory","rustc::session::IncrCompSession","",521,null],[4,"CompileIncomplete","rustc::session","",null,null],[13,"Stopped","","",522,null],[13,"Errored","","",522,null],[5,"build_session","","",null,{"inputs":[{"name":"options"},{"generics":["pathbuf"],"name":"option"},{"name":"registry"}],"output":{"name":"session"}}],[5,"build_session_with_codemap","","",null,{"inputs":[{"name":"options"},{"generics":["pathbuf"],"name":"option"},{"name":"registry"},{"generics":["codemap"],"name":"lrc"},{"generics":["box"],"name":"option"}],"output":{"name":"session"}}],[5,"build_session_","","",null,{"inputs":[{"name":"options"},{"generics":["pathbuf"],"name":"option"},{"name":"handler"},{"generics":["codemap"],"name":"lrc"}],"output":{"name":"session"}}],[5,"early_error","","",null,null],[5,"early_warn","","",null,{"inputs":[{"name":"erroroutputtype"},{"name":"str"}],"output":null}],[5,"compile_result_from_err_count","","",null,{"inputs":[{"name":"usize"}],"output":{"name":"compileresult"}}],[5,"bug_fmt","","",null,null],[5,"span_bug_fmt","","",null,null],[5,"opt_span_bug_fmt","","",null,null],[0,"code_stats","","",null,null],[3,"VariantInfo","rustc::session::code_stats","",null,null],[12,"name","","",513,null],[12,"kind","","",513,null],[12,"size","","",513,null],[12,"align","","",513,null],[12,"fields","","",513,null],[3,"FieldInfo","","",null,null],[12,"name","","",511,null],[12,"offset","","",511,null],[12,"size","","",511,null],[12,"align","","",511,null],[3,"TypeSizeInfo","","",null,null],[12,"kind","","",512,null],[12,"type_description","","",512,null],[12,"align","","",512,null],[12,"overall_size","","",512,null],[12,"packed","","",512,null],[12,"opt_discr_size","","",512,null],[12,"variants","","",512,null],[3,"CodeStats","","",null,null],[12,"type_sizes","","",510,null],[4,"SizeKind","","",null,null],[13,"Exact","","",518,null],[13,"Min","","",518,null],[4,"DataTypeKind","","",null,null],[13,"Struct","","",517,null],[13,"Union","","",517,null],[13,"Enum","","",517,null],[13,"Closure","","",517,null],[11,"clone","rustc::session","",513,{"inputs":[{"name":"self"}],"output":{"name":"variantinfo"}}],[11,"eq","","",513,{"inputs":[{"name":"self"},{"name":"variantinfo"}],"output":{"name":"bool"}}],[11,"ne","","",513,{"inputs":[{"name":"self"},{"name":"variantinfo"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",513,null],[11,"hash","","",513,null],[11,"fmt","","",513,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",518,{"inputs":[{"name":"self"}],"output":{"name":"sizekind"}}],[11,"eq","","",518,{"inputs":[{"name":"self"},{"name":"sizekind"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",518,null],[11,"hash","","",518,null],[11,"fmt","","",518,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",511,{"inputs":[{"name":"self"}],"output":{"name":"fieldinfo"}}],[11,"eq","","",511,{"inputs":[{"name":"self"},{"name":"fieldinfo"}],"output":{"name":"bool"}}],[11,"ne","","",511,{"inputs":[{"name":"self"},{"name":"fieldinfo"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",511,null],[11,"hash","","",511,null],[11,"fmt","","",511,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"from","","",517,{"inputs":[{"name":"adtkind"}],"output":{"name":"self"}}],[11,"clone","","",517,{"inputs":[{"name":"self"}],"output":{"name":"datatypekind"}}],[11,"eq","","",517,{"inputs":[{"name":"self"},{"name":"datatypekind"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",517,null],[11,"hash","","",517,null],[11,"fmt","","",517,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",512,{"inputs":[{"name":"self"},{"name":"typesizeinfo"}],"output":{"name":"bool"}}],[11,"ne","","",512,{"inputs":[{"name":"self"},{"name":"typesizeinfo"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",512,null],[11,"hash","","",512,null],[11,"fmt","","",512,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",510,{"inputs":[{"name":"self"},{"name":"codestats"}],"output":{"name":"bool"}}],[11,"ne","","",510,{"inputs":[{"name":"self"},{"name":"codestats"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",510,null],[11,"fmt","","",510,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","",510,{"inputs":[],"output":{"name":"self"}}],[11,"record_type_size","","",510,{"inputs":[{"name":"self"},{"name":"datatypekind"},{"name":"s"},{"name":"align"},{"name":"size"},{"name":"bool"},{"generics":["size"],"name":"option"},{"generics":["variantinfo"],"name":"vec"}],"output":null}],[11,"print_type_sizes","","",510,{"inputs":[{"name":"self"}],"output":null}],[0,"config","","Contains infrastructure for configuring the compiler, including parsing command line options.",null,null],[3,"Config","rustc::session::config","",null,null],[12,"target","","",523,null],[12,"isize_ty","","",523,null],[12,"usize_ty","","",523,null],[3,"OutputTypes","","",null,null],[12,"0","","",524,null],[3,"Externs","","",null,null],[12,"0","","",525,null],[3,"Options","","",null,null],[12,"crate_types","","",526,null],[12,"optimize","","",526,null],[12,"debug_assertions","","",526,null],[12,"debuginfo","","",526,null],[12,"lint_opts","","",526,null],[12,"lint_cap","","",526,null],[12,"describe_lints","","",526,null],[12,"output_types","","",526,null],[12,"search_paths","","",526,null],[12,"libs","","",526,null],[12,"maybe_sysroot","","",526,null],[12,"target_triple","","",526,null],[12,"test","","",526,null],[12,"error_format","","",526,null],[12,"incremental","","",526,null],[12,"debugging_opts","","",526,null],[12,"prints","","",526,null],[12,"borrowck_mode","","",526,null],[12,"cg","","",526,null],[12,"externs","","",526,null],[12,"crate_name","","",526,null],[12,"alt_std_name","","",526,null],[12,"unstable_features","","",526,null],[12,"actually_rustdoc","","",526,null],[12,"cli_forced_codegen_units","","",526,null],[12,"cli_forced_thinlto_off","","",526,null],[12,"remap_path_prefix","","",526,null],[12,"edition","","",526,null],[3,"OutputFilenames","","",null,null],[12,"out_directory","","",527,null],[12,"out_filestem","","",527,null],[12,"single_output_file","","",527,null],[12,"extra","","",527,null],[12,"outputs","","",527,null],[3,"CodegenOptions","","",null,null],[12,"ar","","",528,null],[12,"linker","","",528,null],[12,"link_arg","","",528,null],[12,"link_args","","",528,null],[12,"link_dead_code","","",528,null],[12,"lto","","",528,null],[12,"target_cpu","","",528,null],[12,"target_feature","","",528,null],[12,"passes","","",528,null],[12,"llvm_args","","",528,null],[12,"save_temps","","",528,null],[12,"rpath","","",528,null],[12,"overflow_checks","","",528,null],[12,"no_prepopulate_passes","","",528,null],[12,"no_vectorize_loops","","",528,null],[12,"no_vectorize_slp","","",528,null],[12,"soft_float","","",528,null],[12,"prefer_dynamic","","",528,null],[12,"no_integrated_as","","",528,null],[12,"no_redzone","","",528,null],[12,"relocation_model","","",528,null],[12,"code_model","","",528,null],[12,"metadata","","",528,null],[12,"extra_filename","","",528,null],[12,"codegen_units","","",528,null],[12,"remark","","",528,null],[12,"no_stack_check","","",528,null],[12,"debuginfo","","",528,null],[12,"opt_level","","",528,null],[12,"force_frame_pointers","","",528,null],[12,"debug_assertions","","",528,null],[12,"inline_threshold","","",528,null],[12,"panic","","",528,null],[12,"incremental","","",528,null],[3,"DebuggingOptions","","",null,null],[12,"codegen_backend","","",529,null],[12,"verbose","","",529,null],[12,"span_free_formats","","",529,null],[12,"identify_regions","","",529,null],[12,"emit_end_regions","","",529,null],[12,"borrowck","","",529,null],[12,"two_phase_borrows","","",529,null],[12,"two_phase_beyond_autoref","","",529,null],[12,"time_passes","","",529,null],[12,"count_llvm_insns","","",529,null],[12,"time_llvm_passes","","",529,null],[12,"input_stats","","",529,null],[12,"trans_stats","","",529,null],[12,"asm_comments","","",529,null],[12,"no_verify","","",529,null],[12,"borrowck_stats","","",529,null],[12,"no_landing_pads","","",529,null],[12,"fewer_names","","",529,null],[12,"meta_stats","","",529,null],[12,"print_link_args","","",529,null],[12,"print_llvm_passes","","",529,null],[12,"ast_json","","",529,null],[12,"query_threads","","",529,null],[12,"ast_json_noexpand","","",529,null],[12,"ls","","",529,null],[12,"save_analysis","","",529,null],[12,"flowgraph_print_loans","","",529,null],[12,"flowgraph_print_moves","","",529,null],[12,"flowgraph_print_assigns","","",529,null],[12,"flowgraph_print_all","","",529,null],[12,"print_region_graph","","",529,null],[12,"parse_only","","",529,null],[12,"no_trans","","",529,null],[12,"treat_err_as_bug","","",529,null],[12,"external_macro_backtrace","","",529,null],[12,"teach","","",529,null],[12,"continue_parse_after_error","","",529,null],[12,"incremental","","",529,null],[12,"incremental_queries","","",529,null],[12,"incremental_info","","",529,null],[12,"incremental_dump_hash","","",529,null],[12,"incremental_verify_ich","","",529,null],[12,"incremental_ignore_spans","","",529,null],[12,"dump_dep_graph","","",529,null],[12,"query_dep_graph","","",529,null],[12,"profile_queries","","",529,null],[12,"profile_queries_and_keys","","",529,null],[12,"no_analysis","","",529,null],[12,"extra_plugins","","",529,null],[12,"unstable_options","","",529,null],[12,"force_overflow_checks","","",529,null],[12,"trace_macros","","",529,null],[12,"debug_macros","","",529,null],[12,"enable_nonzeroing_move_hints","","",529,null],[12,"keep_hygiene_data","","",529,null],[12,"keep_ast","","",529,null],[12,"show_span","","",529,null],[12,"print_type_sizes","","",529,null],[12,"print_trans_items","","",529,null],[12,"mir_opt_level","","",529,null],[12,"mutable_noalias","","",529,null],[12,"arg_align_attributes","","",529,null],[12,"dump_mir","","",529,null],[12,"dump_mir_dir","","",529,null],[12,"dump_mir_graphviz","","",529,null],[12,"dump_mir_exclude_pass_number","","",529,null],[12,"mir_emit_validate","","",529,null],[12,"perf_stats","","",529,null],[12,"hir_stats","","",529,null],[12,"mir_stats","","",529,null],[12,"always_encode_mir","","",529,null],[12,"osx_rpath_install_name","","",529,null],[12,"sanitizer","","",529,null],[12,"linker_flavor","","",529,null],[12,"fuel","","",529,null],[12,"print_fuel","","",529,null],[12,"force_unstable_if_unmarked","","",529,null],[12,"pre_link_arg","","",529,null],[12,"pre_link_args","","",529,null],[12,"profile","","",529,null],[12,"pgo_gen","","",529,null],[12,"pgo_use","","",529,null],[12,"disable_instrumentation_preinliner","","",529,null],[12,"relro_level","","",529,null],[12,"nll_subminimal_causes","","",529,null],[12,"nll_facts","","",529,null],[12,"disable_nll_user_type_assert","","",529,null],[12,"trans_time_graph","","",529,null],[12,"thinlto","","",529,null],[12,"inline_in_all_cgus","","",529,null],[12,"tls_model","","",529,null],[12,"saturating_float_casts","","",529,null],[12,"lower_128bit_ops","","",529,null],[12,"human_readable_cgu_names","","",529,null],[12,"dep_info_omit_d_target","","",529,null],[12,"suggestion_applicability","","",529,null],[12,"unpretty","","",529,null],[12,"run_dsymutil","","",529,null],[12,"ui_testing","","",529,null],[12,"embed_bitcode","","",529,null],[12,"strip_debuginfo_if_disabled","","",529,null],[12,"share_generics","","",529,null],[12,"chalk","","",529,null],[12,"cross_lang_lto","","",529,null],[3,"RustcOptGroup","","",null,null],[12,"apply","","",530,null],[12,"name","","",530,null],[12,"stability","","",530,null],[4,"Sanitizer","","",null,null],[13,"Address","","",531,null],[13,"Leak","","",531,null],[13,"Memory","","",531,null],[13,"Thread","","",531,null],[4,"OptLevel","","",null,null],[13,"No","","",532,null],[13,"Less","","",532,null],[13,"Default","","",532,null],[13,"Aggressive","","",532,null],[13,"Size","","",532,null],[13,"SizeMin","","",532,null],[4,"Lto","","",null,null],[13,"No","","Don't do any LTO whatsoever",533,null],[13,"Yes","","Do a full crate graph LTO. The flavor is determined by the compiler (currently the default is \"fat\").",533,null],[13,"Thin","","Do a full crate graph LTO with ThinLTO",533,null],[13,"ThinLocal","","Do a local graph LTO with ThinLTO (only relevant for multiple codegen units).",533,null],[13,"Fat","","Do a full crate graph LTO with \"fat\" LTO",533,null],[4,"DebugInfoLevel","","",null,null],[13,"NoDebugInfo","","",534,null],[13,"LimitedDebugInfo","","",534,null],[13,"FullDebugInfo","","",534,null],[4,"OutputType","","",null,null],[13,"Bitcode","","",535,null],[13,"Assembly","","",535,null],[13,"LlvmAssembly","","",535,null],[13,"Mir","","",535,null],[13,"Metadata","","",535,null],[13,"Object","","",535,null],[13,"Exe","","",535,null],[13,"DepInfo","","",535,null],[4,"ErrorOutputType","","",null,null],[13,"HumanReadable","","",536,null],[13,"Json","","",536,null],[13,"Short","","",536,null],[4,"PrintRequest","","",null,null],[13,"FileNames","","",537,null],[13,"Sysroot","","",537,null],[13,"CrateName","","",537,null],[13,"Cfg","","",537,null],[13,"TargetList","","",537,null],[13,"TargetCPUs","","",537,null],[13,"TargetFeatures","","",537,null],[13,"RelocationModels","","",537,null],[13,"CodeModels","","",537,null],[13,"TlsModels","","",537,null],[13,"TargetSpec","","",537,null],[13,"NativeStaticLibs","","",537,null],[4,"BorrowckMode","","",null,null],[13,"Ast","","",538,null],[13,"Mir","","",538,null],[13,"Compare","","",538,null],[4,"Input","","",null,null],[13,"File","","Load source from file",539,null],[13,"Str","","",539,null],[12,"name","rustc::session::config::Input","String that is shown in place of a filename",539,null],[12,"input","","Anonymous source string",539,null],[4,"EntryFnType","rustc::session::config","",null,null],[13,"EntryMain","","",540,null],[13,"EntryStart","","",540,null],[4,"CrateType","","",null,null],[13,"CrateTypeExecutable","","",541,null],[13,"CrateTypeDylib","","",541,null],[13,"CrateTypeRlib","","",541,null],[13,"CrateTypeStaticlib","","",541,null],[13,"CrateTypeCdylib","","",541,null],[13,"CrateTypeProcMacro","","",541,null],[4,"Passes","","",null,null],[13,"SomePasses","","",542,null],[13,"AllPasses","","",542,null],[4,"OptionStability","","",null,null],[13,"Stable","","",543,null],[13,"Unstable","","",543,null],[5,"host_triple","","",null,{"inputs":[],"output":{"name":"str"}}],[5,"basic_options","","Some reasonable defaults",null,{"inputs":[],"output":{"name":"options"}}],[5,"basic_codegen_options","","",null,{"inputs":[],"output":{"name":"codegenoptions"}}],[5,"build_codegen_options","","",null,{"inputs":[{"name":"matches"},{"name":"erroroutputtype"}],"output":{"name":"codegenoptions"}}],[5,"basic_debugging_options","","",null,{"inputs":[],"output":{"name":"debuggingoptions"}}],[5,"build_debugging_options","","",null,{"inputs":[{"name":"matches"},{"name":"erroroutputtype"}],"output":{"name":"debuggingoptions"}}],[5,"default_lib_output","","",null,{"inputs":[],"output":{"name":"cratetype"}}],[5,"default_configuration","","",null,{"inputs":[{"name":"session"}],"output":{"name":"crateconfig"}}],[5,"build_configuration","","",null,{"inputs":[{"name":"session"},{"name":"crateconfig"}],"output":{"name":"crateconfig"}}],[5,"build_target_config","","",null,{"inputs":[{"name":"options"},{"name":"handler"}],"output":{"name":"config"}}],[5,"rustc_short_optgroups","","Returns the \"short\" subset of the rustc command line options, including metadata for each option, such as whether the option is part of the stable long-term interface for rustc.",null,{"inputs":[],"output":{"generics":["rustcoptgroup"],"name":"vec"}}],[5,"rustc_optgroups","","Returns all rustc command line options, including metadata for each option, such as whether the option is part of the stable long-term interface for rustc.",null,{"inputs":[],"output":{"generics":["rustcoptgroup"],"name":"vec"}}],[5,"parse_cfgspecs","","",null,{"inputs":[{"generics":["string"],"name":"vec"}],"output":{"name":"crateconfig"}}],[5,"build_session_options_and_crate_config","","",null,null],[5,"parse_crate_types_from_list","","",null,{"inputs":[{"generics":["string"],"name":"vec"}],"output":{"generics":["vec","string"],"name":"result"}}],[0,"cg_type_desc","","",null,null],[17,"parse_bool","rustc::session::config::cg_type_desc","",null,null],[17,"parse_opt_bool","","",null,null],[17,"parse_string","","",null,null],[17,"parse_string_push","","",null,null],[17,"parse_pathbuf_push","","",null,null],[17,"parse_opt_string","","",null,null],[17,"parse_opt_pathbuf","","",null,null],[17,"parse_list","","",null,null],[17,"parse_opt_list","","",null,null],[17,"parse_uint","","",null,null],[17,"parse_passes","","",null,null],[17,"parse_opt_uint","","",null,null],[17,"parse_panic_strategy","","",null,null],[17,"parse_relro_level","","",null,null],[17,"parse_sanitizer","","",null,null],[17,"parse_linker_flavor","","",null,null],[17,"parse_optimization_fuel","","",null,null],[17,"parse_unpretty","","",null,null],[17,"parse_lto","","",null,null],[0,"cgsetters","rustc::session::config","",null,null],[5,"ar","rustc::session::config::cgsetters","",null,{"inputs":[{"name":"codegenoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"linker","","",null,{"inputs":[{"name":"codegenoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"link_arg","","",null,{"inputs":[{"name":"codegenoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"link_args","","",null,{"inputs":[{"name":"codegenoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"link_dead_code","","",null,{"inputs":[{"name":"codegenoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"lto","","",null,{"inputs":[{"name":"codegenoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"target_cpu","","",null,{"inputs":[{"name":"codegenoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"target_feature","","",null,{"inputs":[{"name":"codegenoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"passes","","",null,{"inputs":[{"name":"codegenoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"llvm_args","","",null,{"inputs":[{"name":"codegenoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"save_temps","","",null,{"inputs":[{"name":"codegenoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"rpath","","",null,{"inputs":[{"name":"codegenoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"overflow_checks","","",null,{"inputs":[{"name":"codegenoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"no_prepopulate_passes","","",null,{"inputs":[{"name":"codegenoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"no_vectorize_loops","","",null,{"inputs":[{"name":"codegenoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"no_vectorize_slp","","",null,{"inputs":[{"name":"codegenoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"soft_float","","",null,{"inputs":[{"name":"codegenoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"prefer_dynamic","","",null,{"inputs":[{"name":"codegenoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"no_integrated_as","","",null,{"inputs":[{"name":"codegenoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"no_redzone","","",null,{"inputs":[{"name":"codegenoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"relocation_model","","",null,{"inputs":[{"name":"codegenoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"code_model","","",null,{"inputs":[{"name":"codegenoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"metadata","","",null,{"inputs":[{"name":"codegenoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"extra_filename","","",null,{"inputs":[{"name":"codegenoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"codegen_units","","",null,{"inputs":[{"name":"codegenoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"remark","","",null,{"inputs":[{"name":"codegenoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"no_stack_check","","",null,{"inputs":[{"name":"codegenoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"debuginfo","","",null,{"inputs":[{"name":"codegenoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"opt_level","","",null,{"inputs":[{"name":"codegenoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"force_frame_pointers","","",null,{"inputs":[{"name":"codegenoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"debug_assertions","","",null,{"inputs":[{"name":"codegenoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"inline_threshold","","",null,{"inputs":[{"name":"codegenoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"panic","","",null,{"inputs":[{"name":"codegenoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"incremental","","",null,{"inputs":[{"name":"codegenoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"parse_bool","","",null,{"inputs":[{"name":"bool"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"parse_opt_bool","","",null,{"inputs":[{"name":"option"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"parse_opt_string","","",null,{"inputs":[{"name":"option"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"parse_opt_pathbuf","","",null,{"inputs":[{"name":"option"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"parse_string","","",null,{"inputs":[{"name":"string"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"parse_string_push","","",null,{"inputs":[{"name":"vec"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"parse_pathbuf_push","","",null,{"inputs":[{"name":"vec"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"parse_list","","",null,{"inputs":[{"name":"vec"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"parse_opt_list","","",null,{"inputs":[{"name":"option"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"parse_uint","","",null,{"inputs":[{"name":"usize"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"parse_opt_uint","","",null,{"inputs":[{"name":"option"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"parse_passes","","",null,{"inputs":[{"name":"passes"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"parse_panic_strategy","","",null,{"inputs":[{"name":"option"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"parse_relro_level","","",null,{"inputs":[{"name":"option"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"parse_sanitizer","","",null,{"inputs":[{"name":"option"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"parse_linker_flavor","","",null,{"inputs":[{"name":"option"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"parse_optimization_fuel","","",null,{"inputs":[{"name":"option"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"parse_unpretty","","",null,{"inputs":[{"name":"option"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"parse_lto","","",null,{"inputs":[{"name":"lto"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[0,"db_type_desc","rustc::session::config","",null,null],[17,"parse_bool","rustc::session::config::db_type_desc","",null,null],[17,"parse_opt_bool","","",null,null],[17,"parse_string","","",null,null],[17,"parse_string_push","","",null,null],[17,"parse_pathbuf_push","","",null,null],[17,"parse_opt_string","","",null,null],[17,"parse_opt_pathbuf","","",null,null],[17,"parse_list","","",null,null],[17,"parse_opt_list","","",null,null],[17,"parse_uint","","",null,null],[17,"parse_passes","","",null,null],[17,"parse_opt_uint","","",null,null],[17,"parse_panic_strategy","","",null,null],[17,"parse_relro_level","","",null,null],[17,"parse_sanitizer","","",null,null],[17,"parse_linker_flavor","","",null,null],[17,"parse_optimization_fuel","","",null,null],[17,"parse_unpretty","","",null,null],[17,"parse_lto","","",null,null],[0,"dbsetters","rustc::session::config","",null,null],[5,"codegen_backend","rustc::session::config::dbsetters","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"verbose","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"span_free_formats","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"identify_regions","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"emit_end_regions","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"borrowck","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"two_phase_borrows","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"two_phase_beyond_autoref","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"time_passes","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"count_llvm_insns","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"time_llvm_passes","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"input_stats","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"trans_stats","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"asm_comments","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"no_verify","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"borrowck_stats","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"no_landing_pads","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"fewer_names","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"meta_stats","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"print_link_args","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"print_llvm_passes","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"ast_json","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"query_threads","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"ast_json_noexpand","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"ls","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"save_analysis","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"flowgraph_print_loans","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"flowgraph_print_moves","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"flowgraph_print_assigns","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"flowgraph_print_all","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"print_region_graph","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"parse_only","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"no_trans","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"treat_err_as_bug","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"external_macro_backtrace","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"teach","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"continue_parse_after_error","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"incremental","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"incremental_queries","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"incremental_info","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"incremental_dump_hash","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"incremental_verify_ich","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"incremental_ignore_spans","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"dump_dep_graph","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"query_dep_graph","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"profile_queries","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"profile_queries_and_keys","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"no_analysis","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"extra_plugins","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"unstable_options","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"force_overflow_checks","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"trace_macros","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"debug_macros","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"enable_nonzeroing_move_hints","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"keep_hygiene_data","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"keep_ast","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"show_span","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"print_type_sizes","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"print_trans_items","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"mir_opt_level","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"mutable_noalias","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"arg_align_attributes","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"dump_mir","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"dump_mir_dir","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"dump_mir_graphviz","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"dump_mir_exclude_pass_number","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"mir_emit_validate","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"perf_stats","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"hir_stats","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"mir_stats","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"always_encode_mir","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"osx_rpath_install_name","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"sanitizer","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"linker_flavor","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"fuel","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"print_fuel","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"force_unstable_if_unmarked","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"pre_link_arg","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"pre_link_args","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"profile","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"pgo_gen","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"pgo_use","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"disable_instrumentation_preinliner","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"relro_level","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"nll_subminimal_causes","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"nll_facts","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"disable_nll_user_type_assert","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"trans_time_graph","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"thinlto","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"inline_in_all_cgus","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"tls_model","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"saturating_float_casts","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"lower_128bit_ops","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"human_readable_cgu_names","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"dep_info_omit_d_target","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"suggestion_applicability","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"unpretty","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"run_dsymutil","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"ui_testing","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"embed_bitcode","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"strip_debuginfo_if_disabled","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"share_generics","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"chalk","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"cross_lang_lto","","",null,{"inputs":[{"name":"debuggingoptions"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"parse_bool","","",null,{"inputs":[{"name":"bool"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"parse_opt_bool","","",null,{"inputs":[{"name":"option"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"parse_opt_string","","",null,{"inputs":[{"name":"option"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"parse_opt_pathbuf","","",null,{"inputs":[{"name":"option"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"parse_string","","",null,{"inputs":[{"name":"string"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"parse_string_push","","",null,{"inputs":[{"name":"vec"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"parse_pathbuf_push","","",null,{"inputs":[{"name":"vec"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"parse_list","","",null,{"inputs":[{"name":"vec"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"parse_opt_list","","",null,{"inputs":[{"name":"option"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"parse_uint","","",null,{"inputs":[{"name":"usize"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"parse_opt_uint","","",null,{"inputs":[{"name":"option"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"parse_passes","","",null,{"inputs":[{"name":"passes"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"parse_panic_strategy","","",null,{"inputs":[{"name":"option"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"parse_relro_level","","",null,{"inputs":[{"name":"option"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"parse_sanitizer","","",null,{"inputs":[{"name":"option"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"parse_linker_flavor","","",null,{"inputs":[{"name":"option"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"parse_optimization_fuel","","",null,{"inputs":[{"name":"option"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"parse_unpretty","","",null,{"inputs":[{"name":"option"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[5,"parse_lto","","",null,{"inputs":[{"name":"lto"},{"generics":["str"],"name":"option"}],"output":{"name":"bool"}}],[0,"opt","rustc::session::config","",null,null],[5,"stable","rustc::session::config::opt","",null,{"inputs":[{"name":"str"},{"name":"f"}],"output":{"name":"rustcoptgroup"}}],[5,"unstable","","",null,{"inputs":[{"name":"str"},{"name":"f"}],"output":{"name":"rustcoptgroup"}}],[5,"longer","","",null,{"inputs":[{"name":"str"},{"name":"str"}],"output":{"name":"str"}}],[5,"opt_s","","",null,{"inputs":[{"name":"str"},{"name":"str"},{"name":"str"},{"name":"str"}],"output":{"name":"rustcoptgroup"}}],[5,"multi_s","","",null,{"inputs":[{"name":"str"},{"name":"str"},{"name":"str"},{"name":"str"}],"output":{"name":"rustcoptgroup"}}],[5,"flag_s","","",null,{"inputs":[{"name":"str"},{"name":"str"},{"name":"str"}],"output":{"name":"rustcoptgroup"}}],[5,"flagopt_s","","",null,{"inputs":[{"name":"str"},{"name":"str"},{"name":"str"},{"name":"str"}],"output":{"name":"rustcoptgroup"}}],[5,"flagmulti_s","","",null,{"inputs":[{"name":"str"},{"name":"str"},{"name":"str"}],"output":{"name":"rustcoptgroup"}}],[5,"opt","","",null,{"inputs":[{"name":"str"},{"name":"str"},{"name":"str"},{"name":"str"}],"output":{"name":"rustcoptgroup"}}],[5,"multi","","",null,{"inputs":[{"name":"str"},{"name":"str"},{"name":"str"},{"name":"str"}],"output":{"name":"rustcoptgroup"}}],[5,"flag","","",null,{"inputs":[{"name":"str"},{"name":"str"},{"name":"str"}],"output":{"name":"rustcoptgroup"}}],[5,"flagopt","","",null,{"inputs":[{"name":"str"},{"name":"str"},{"name":"str"},{"name":"str"}],"output":{"name":"rustcoptgroup"}}],[5,"flagmulti","","",null,{"inputs":[{"name":"str"},{"name":"str"},{"name":"str"}],"output":{"name":"rustcoptgroup"}}],[6,"R","","",null,null],[6,"S","","",null,null],[0,"nightly_options","rustc::session::config","",null,null],[5,"is_unstable_enabled","rustc::session::config::nightly_options","",null,{"inputs":[{"name":"matches"}],"output":{"name":"bool"}}],[5,"is_nightly_build","","",null,{"inputs":[],"output":{"name":"bool"}}],[5,"check_nightly_options","","",null,null],[0,"dep_tracking","rustc::session::config","Commandline arguments passed to the compiler have to be incorporated with the dependency tracking system for incremental compilation. This module provides some utilities to make this more convenient.",null,null],[5,"stable_hash","rustc::session::config::dep_tracking","",null,{"inputs":[{"generics":["str","deptrackinghash"],"name":"btreemap"},{"name":"defaulthasher"},{"name":"erroroutputtype"}],"output":null}],[8,"DepTrackingHash","","",null,null],[10,"hash","","",544,{"inputs":[{"name":"self"},{"name":"defaulthasher"},{"name":"erroroutputtype"}],"output":null}],[11,"hash","rustc::lint","",303,{"inputs":[{"name":"self"},{"name":"defaulthasher"},{"name":"erroroutputtype"}],"output":null}],[11,"hash","rustc::session::config","",541,{"inputs":[{"name":"self"},{"name":"defaulthasher"},{"name":"erroroutputtype"}],"output":null}],[11,"hash","","",542,{"inputs":[{"name":"self"},{"name":"defaulthasher"},{"name":"erroroutputtype"}],"output":null}],[11,"hash","","",532,{"inputs":[{"name":"self"},{"name":"defaulthasher"},{"name":"erroroutputtype"}],"output":null}],[11,"hash","","",533,{"inputs":[{"name":"self"},{"name":"defaulthasher"},{"name":"erroroutputtype"}],"output":null}],[11,"hash","","",534,{"inputs":[{"name":"self"},{"name":"defaulthasher"},{"name":"erroroutputtype"}],"output":null}],[11,"hash","","",524,{"inputs":[{"name":"self"},{"name":"defaulthasher"},{"name":"erroroutputtype"}],"output":null}],[11,"hash","rustc::middle::cstore","",344,{"inputs":[{"name":"self"},{"name":"defaulthasher"},{"name":"erroroutputtype"}],"output":null}],[11,"hash","rustc::session::config","",531,{"inputs":[{"name":"self"},{"name":"defaulthasher"},{"name":"erroroutputtype"}],"output":null}],[6,"CodegenSetter","","",null,null],[6,"DebuggingSetter","","",null,null],[17,"RUST_CGU_EXT","","",null,null],[17,"CG_OPTIONS","","",null,null],[17,"DB_OPTIONS","","",null,null],[11,"clone","","",531,{"inputs":[{"name":"self"}],"output":{"name":"sanitizer"}}],[11,"hash","","",531,null],[11,"fmt","","",531,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",532,{"inputs":[{"name":"self"}],"output":{"name":"optlevel"}}],[11,"eq","","",532,{"inputs":[{"name":"self"},{"name":"optlevel"}],"output":{"name":"bool"}}],[11,"hash","","",532,null],[11,"clone","","",533,{"inputs":[{"name":"self"}],"output":{"name":"lto"}}],[11,"eq","","",533,{"inputs":[{"name":"self"},{"name":"lto"}],"output":{"name":"bool"}}],[11,"hash","","",533,null],[11,"clone","","",534,{"inputs":[{"name":"self"}],"output":{"name":"debuginfolevel"}}],[11,"eq","","",534,{"inputs":[{"name":"self"},{"name":"debuginfolevel"}],"output":{"name":"bool"}}],[11,"hash","","",534,null],[11,"clone","","",535,{"inputs":[{"name":"self"}],"output":{"name":"outputtype"}}],[11,"eq","","",535,{"inputs":[{"name":"self"},{"name":"outputtype"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",535,null],[11,"hash","","",535,null],[11,"fmt","","",535,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"partial_cmp","","",535,{"inputs":[{"name":"self"},{"name":"outputtype"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"cmp","","",535,{"inputs":[{"name":"self"},{"name":"outputtype"}],"output":{"name":"ordering"}}],[11,"encode","","",535,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",535,{"inputs":[{"name":"__d"}],"output":{"generics":["outputtype"],"name":"result"}}],[11,"hash_stable","","",535,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"to_stable_hash_key","","",535,null],[11,"is_compatible_with_codegen_units_and_single_output_file","","",535,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"shorthand","","",535,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"from_shorthand","","",535,{"inputs":[{"name":"str"}],"output":{"name":"option"}}],[11,"shorthands_display","","",535,{"inputs":[],"output":{"name":"string"}}],[11,"extension","","",535,{"inputs":[{"name":"self"}],"output":{"name":"str"}}],[11,"clone","","",536,{"inputs":[{"name":"self"}],"output":{"name":"erroroutputtype"}}],[11,"fmt","","",536,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",536,{"inputs":[{"name":"self"},{"name":"erroroutputtype"}],"output":{"name":"bool"}}],[11,"ne","","",536,{"inputs":[{"name":"self"},{"name":"erroroutputtype"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",536,null],[11,"default","","",536,{"inputs":[],"output":{"name":"erroroutputtype"}}],[11,"clone","","",524,{"inputs":[{"name":"self"}],"output":{"name":"outputtypes"}}],[11,"hash","","",524,null],[11,"hash_stable","","",524,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"new","","",524,null],[11,"get","","",524,{"inputs":[{"name":"self"},{"name":"outputtype"}],"output":{"generics":["option"],"name":"option"}}],[11,"contains_key","","",524,{"inputs":[{"name":"self"},{"name":"outputtype"}],"output":{"name":"bool"}}],[11,"keys","","",524,{"inputs":[{"name":"self"}],"output":{"generics":["outputtype","option"],"name":"btreemapkeysiter"}}],[11,"values","","",524,{"inputs":[{"name":"self"}],"output":{"generics":["outputtype","option"],"name":"btreemapvaluesiter"}}],[11,"len","","",524,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"should_trans","","",524,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",525,{"inputs":[{"name":"self"}],"output":{"name":"externs"}}],[11,"hash","","",525,null],[11,"new","","",525,{"inputs":[{"generics":["string","btreeset"],"name":"btreemap"}],"output":{"name":"externs"}}],[11,"get","","",525,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"generics":["btreeset"],"name":"option"}}],[11,"iter","","",525,{"inputs":[{"name":"self"}],"output":{"generics":["string","btreeset"],"name":"btreemapiter"}}],[11,"clone","","",526,{"inputs":[{"name":"self"}],"output":{"name":"options"}}],[11,"dep_tracking_hash","","",526,{"inputs":[{"name":"self"}],"output":{"name":"u64"}}],[11,"clone","","",537,{"inputs":[{"name":"self"}],"output":{"name":"printrequest"}}],[11,"eq","","",537,{"inputs":[{"name":"self"},{"name":"printrequest"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",537,null],[11,"fmt","","",537,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",538,{"inputs":[{"name":"self"}],"output":{"name":"borrowckmode"}}],[11,"fmt","","",538,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",538,{"inputs":[{"name":"self"},{"name":"borrowckmode"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",538,null],[11,"partial_cmp","","",538,{"inputs":[{"name":"self"},{"name":"borrowckmode"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"cmp","","",538,{"inputs":[{"name":"self"},{"name":"borrowckmode"}],"output":{"name":"ordering"}}],[11,"hash","","",538,null],[11,"use_ast","","Should we emit the AST-based borrow checker errors?",538,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"use_mir","","Should we emit the MIR-based borrow checker errors?",538,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"filestem","","",539,{"inputs":[{"name":"self"}],"output":{"name":"string"}}],[11,"clone","","",527,{"inputs":[{"name":"self"}],"output":{"name":"outputfilenames"}}],[11,"hash_stable","","",527,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"path","","",527,{"inputs":[{"name":"self"},{"name":"outputtype"}],"output":{"name":"pathbuf"}}],[11,"temp_path","","Get the path where a compilation artifact of the given type for the given codegen unit should be placed on disk. If codegen_unit_name is None, a path distinct from those of any codegen unit will be generated.",527,{"inputs":[{"name":"self"},{"name":"outputtype"},{"generics":["str"],"name":"option"}],"output":{"name":"pathbuf"}}],[11,"temp_path_ext","","Like temp_path, but also supports things where there is no corresponding OutputType, like no-opt-bitcode or lto-bitcode.",527,{"inputs":[{"name":"self"},{"name":"str"},{"generics":["str"],"name":"option"}],"output":{"name":"pathbuf"}}],[11,"with_extension","","",527,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"pathbuf"}}],[11,"filestem","","",527,{"inputs":[{"name":"self"}],"output":{"name":"string"}}],[11,"build_dep_graph","","True if there is a reason to build the dep graph.",526,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"enable_dep_node_debug_strs","","",526,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"file_path_mapping","","",526,{"inputs":[{"name":"self"}],"output":{"name":"filepathmapping"}}],[11,"will_create_output_file","","True if there will be an output file generated",526,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",540,{"inputs":[{"name":"self"}],"output":{"name":"entryfntype"}}],[11,"eq","","",540,{"inputs":[{"name":"self"},{"name":"entryfntype"}],"output":{"name":"bool"}}],[11,"eq","","",541,{"inputs":[{"name":"self"},{"name":"cratetype"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",541,{"inputs":[{"name":"self"},{"name":"cratetype"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"clone","","",541,{"inputs":[{"name":"self"}],"output":{"name":"cratetype"}}],[11,"cmp","","",541,{"inputs":[{"name":"self"},{"name":"cratetype"}],"output":{"name":"ordering"}}],[11,"assert_receiver_is_total_eq","","",541,null],[11,"hash","","",541,null],[11,"fmt","","",541,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",542,{"inputs":[{"name":"self"}],"output":{"name":"passes"}}],[11,"hash","","",542,null],[11,"is_empty","","",542,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","",528,{"inputs":[{"name":"self"}],"output":{"name":"codegenoptions"}}],[11,"hash","","",528,{"inputs":[{"name":"self"},{"name":"defaulthasher"},{"name":"erroroutputtype"}],"output":null}],[11,"clone","","",529,{"inputs":[{"name":"self"}],"output":{"name":"debuggingoptions"}}],[11,"hash","","",529,{"inputs":[{"name":"self"},{"name":"defaulthasher"},{"name":"erroroutputtype"}],"output":null}],[11,"clone","","",543,{"inputs":[{"name":"self"}],"output":{"name":"optionstability"}}],[11,"eq","","",543,{"inputs":[{"name":"self"},{"name":"optionstability"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",543,null],[11,"fmt","","",543,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"is_stable","","",530,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"stable","","",530,{"inputs":[{"name":"str"},{"name":"f"}],"output":{"name":"rustcoptgroup"}}],[11,"unstable","","",530,{"inputs":[{"name":"str"},{"name":"f"}],"output":{"name":"rustcoptgroup"}}],[11,"fmt","","",541,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[0,"filesearch","rustc::session","",null,null],[3,"FileSearch","rustc::session::filesearch","",null,null],[12,"sysroot","","",545,null],[12,"search_paths","","",545,null],[12,"triple","","",545,null],[12,"kind","","",545,null],[4,"FileMatch","","",null,null],[13,"FileMatches","","",546,null],[13,"FileDoesntMatch","","",546,null],[5,"relative_target_lib_path","","",null,{"inputs":[{"name":"path"},{"name":"str"}],"output":{"name":"pathbuf"}}],[5,"make_target_lib_path","","",null,{"inputs":[{"name":"path"},{"name":"str"}],"output":{"name":"pathbuf"}}],[5,"get_or_default_sysroot","","",null,{"inputs":[],"output":{"name":"pathbuf"}}],[5,"find_libdir","","",null,{"inputs":[{"name":"path"}],"output":{"generics":["str"],"name":"cow"}}],[17,"RUST_LIB_DIR","","",null,null],[11,"clone","","",546,{"inputs":[{"name":"self"}],"output":{"name":"filematch"}}],[11,"for_each_lib_search_path","","",545,{"inputs":[{"name":"self"},{"name":"f"}],"output":null}],[11,"get_lib_path","","",545,{"inputs":[{"name":"self"}],"output":{"name":"pathbuf"}}],[11,"search","","",545,{"inputs":[{"name":"self"},{"name":"f"}],"output":null}],[11,"new","","",545,{"inputs":[{"name":"path"},{"name":"str"},{"name":"searchpaths"},{"name":"pathkind"}],"output":{"name":"filesearch"}}],[11,"get_dylib_search_paths","","",545,{"inputs":[{"name":"self"}],"output":{"generics":["pathbuf"],"name":"vec"}}],[11,"get_tools_search_paths","","",545,{"inputs":[{"name":"self"}],"output":{"generics":["pathbuf"],"name":"vec"}}],[0,"search_paths","rustc::session","",null,null],[3,"SearchPaths","rustc::session::search_paths","",null,null],[12,"paths","","",547,null],[3,"Iter","","",null,null],[12,"kind","","",548,null],[12,"iter","","",548,null],[4,"PathKind","","",null,null],[13,"Native","","",549,null],[13,"Crate","","",549,null],[13,"Dependency","","",549,null],[13,"Framework","","",549,null],[13,"ExternFlag","","",549,null],[13,"All","","",549,null],[11,"clone","","",547,{"inputs":[{"name":"self"}],"output":{"name":"searchpaths"}}],[11,"fmt","","",547,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"assert_receiver_is_total_eq","","",549,null],[11,"eq","","",549,{"inputs":[{"name":"self"},{"name":"pathkind"}],"output":{"name":"bool"}}],[11,"clone","","",549,{"inputs":[{"name":"self"}],"output":{"name":"pathkind"}}],[11,"fmt","","",549,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"partial_cmp","","",549,{"inputs":[{"name":"self"},{"name":"pathkind"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"cmp","","",549,{"inputs":[{"name":"self"},{"name":"pathkind"}],"output":{"name":"ordering"}}],[11,"hash","","",549,null],[11,"new","","",547,{"inputs":[],"output":{"name":"searchpaths"}}],[11,"add_path","","",547,{"inputs":[{"name":"self"},{"name":"str"},{"name":"erroroutputtype"}],"output":null}],[11,"iter","","",547,{"inputs":[{"name":"self"},{"name":"pathkind"}],"output":{"name":"iter"}}],[11,"next","","",548,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"size_hint","","",548,null],[6,"CompileResult","rustc::session","",null,null],[11,"clone","","",520,{"inputs":[{"name":"self"}],"output":{"name":"diagnosticmessageid"}}],[11,"fmt","","",520,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",520,{"inputs":[{"name":"self"},{"name":"diagnosticmessageid"}],"output":{"name":"bool"}}],[11,"ne","","",520,{"inputs":[{"name":"self"},{"name":"diagnosticmessageid"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",520,null],[11,"hash","","",520,null],[11,"from","","",520,{"inputs":[{"name":"lint"}],"output":{"name":"self"}}],[11,"local_crate_disambiguator","","",514,{"inputs":[{"name":"self"}],"output":{"name":"cratedisambiguator"}}],[11,"struct_span_warn","","",514,{"inputs":[{"name":"self"},{"name":"s"},{"name":"str"}],"output":{"name":"diagnosticbuilder"}}],[11,"struct_span_warn_with_code","","",514,{"inputs":[{"name":"self"},{"name":"s"},{"name":"str"},{"name":"diagnosticid"}],"output":{"name":"diagnosticbuilder"}}],[11,"struct_warn","","",514,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"diagnosticbuilder"}}],[11,"struct_span_err","","",514,{"inputs":[{"name":"self"},{"name":"s"},{"name":"str"}],"output":{"name":"diagnosticbuilder"}}],[11,"struct_span_err_with_code","","",514,{"inputs":[{"name":"self"},{"name":"s"},{"name":"str"},{"name":"diagnosticid"}],"output":{"name":"diagnosticbuilder"}}],[11,"struct_err","","",514,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"diagnosticbuilder"}}],[11,"struct_err_with_code","","",514,{"inputs":[{"name":"self"},{"name":"str"},{"name":"diagnosticid"}],"output":{"name":"diagnosticbuilder"}}],[11,"struct_span_fatal","","",514,{"inputs":[{"name":"self"},{"name":"s"},{"name":"str"}],"output":{"name":"diagnosticbuilder"}}],[11,"struct_span_fatal_with_code","","",514,{"inputs":[{"name":"self"},{"name":"s"},{"name":"str"},{"name":"diagnosticid"}],"output":{"name":"diagnosticbuilder"}}],[11,"struct_fatal","","",514,{"inputs":[{"name":"self"},{"name":"str"}],"output":{"name":"diagnosticbuilder"}}],[11,"span_fatal","","",514,null],[11,"span_fatal_with_code","","",514,null],[11,"fatal","","",514,null],[11,"span_err_or_warn","","",514,{"inputs":[{"name":"self"},{"name":"bool"},{"name":"s"},{"name":"str"}],"output":null}],[11,"span_err","","",514,{"inputs":[{"name":"self"},{"name":"s"},{"name":"str"}],"output":null}],[11,"span_err_with_code","","",514,{"inputs":[{"name":"self"},{"name":"s"},{"name":"str"},{"name":"diagnosticid"}],"output":null}],[11,"err","","",514,{"inputs":[{"name":"self"},{"name":"str"}],"output":null}],[11,"err_count","","",514,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"has_errors","","",514,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"abort_if_errors","","",514,{"inputs":[{"name":"self"}],"output":null}],[11,"compile_status","","",514,{"inputs":[{"name":"self"}],"output":{"generics":["compileincomplete"],"name":"result"}}],[11,"track_errors","","",514,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"generics":["errorreported"],"name":"result"}}],[11,"span_warn","","",514,{"inputs":[{"name":"self"},{"name":"s"},{"name":"str"}],"output":null}],[11,"span_warn_with_code","","",514,{"inputs":[{"name":"self"},{"name":"s"},{"name":"str"},{"name":"diagnosticid"}],"output":null}],[11,"warn","","",514,{"inputs":[{"name":"self"},{"name":"str"}],"output":null}],[11,"opt_span_warn","","",514,{"inputs":[{"name":"self"},{"name":"option"},{"name":"str"}],"output":null}],[11,"delay_span_bug","","Delay a span_bug() call until abort_if_errors()",514,{"inputs":[{"name":"self"},{"name":"s"},{"name":"str"}],"output":null}],[11,"note_without_error","","",514,{"inputs":[{"name":"self"},{"name":"str"}],"output":null}],[11,"span_note_without_error","","",514,{"inputs":[{"name":"self"},{"name":"s"},{"name":"str"}],"output":null}],[11,"span_unimpl","","",514,null],[11,"unimpl","","",514,null],[11,"buffer_lint","","",514,{"inputs":[{"name":"self"},{"name":"lint"},{"name":"nodeid"},{"name":"s"},{"name":"str"}],"output":null}],[11,"buffer_lint_with_diagnostic","","",514,{"inputs":[{"name":"self"},{"name":"lint"},{"name":"nodeid"},{"name":"s"},{"name":"str"},{"name":"builtinlintdiagnostics"}],"output":null}],[11,"reserve_node_ids","","",514,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"nodeid"}}],[11,"next_node_id","","",514,{"inputs":[{"name":"self"}],"output":{"name":"nodeid"}}],[11,"diagnostic","","",514,{"inputs":[{"name":"self"}],"output":{"name":"handler"}}],[11,"diag_once","","Analogous to calling methods on the given `DiagnosticBuilder`, but deduplicates on lint ID, span (if any), and message for this `Session`",514,{"inputs":[{"name":"self"},{"name":"diagnosticbuilder"},{"name":"diagnosticbuildermethod"},{"name":"diagnosticmessageid"},{"name":"str"},{"generics":["span"],"name":"option"}],"output":null}],[11,"diag_span_note_once","","",514,{"inputs":[{"name":"self"},{"name":"diagnosticbuilder"},{"name":"diagnosticmessageid"},{"name":"span"},{"name":"str"}],"output":null}],[11,"diag_note_once","","",514,{"inputs":[{"name":"self"},{"name":"diagnosticbuilder"},{"name":"diagnosticmessageid"},{"name":"str"}],"output":null}],[11,"diag_span_suggestion_once","","",514,{"inputs":[{"name":"self"},{"name":"diagnosticbuilder"},{"name":"diagnosticmessageid"},{"name":"span"},{"name":"str"},{"name":"string"}],"output":null}],[11,"codemap","","",514,{"inputs":[{"name":"self"}],"output":{"name":"codemap"}}],[11,"verbose","","",514,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"time_passes","","",514,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"profile_queries","","",514,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"profile_queries_and_keys","","",514,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"count_llvm_insns","","",514,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"time_llvm_passes","","",514,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"trans_stats","","",514,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"meta_stats","","",514,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"asm_comments","","",514,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"no_verify","","",514,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"borrowck_stats","","",514,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"print_llvm_passes","","",514,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"features_untracked","","Get the features enabled for the current compilation session. DO NOT USE THIS METHOD if there is a TyCtxt available, as it circumvents dependency tracking. Use tcx.features() instead.",514,{"inputs":[{"name":"self"}],"output":{"name":"features"}}],[11,"init_features","","",514,{"inputs":[{"name":"self"},{"name":"features"}],"output":null}],[11,"lto","","Calculates the flavor of LTO to use for this compilation.",514,{"inputs":[{"name":"self"}],"output":{"name":"lto"}}],[11,"panic_strategy","","Returns the panic strategy for this compile session. If the user explicitly selected one using '-C panic', use that, otherwise use the panic strategy defined by the target.",514,{"inputs":[{"name":"self"}],"output":{"name":"panicstrategy"}}],[11,"linker_flavor","","",514,{"inputs":[{"name":"self"}],"output":{"name":"linkerflavor"}}],[11,"fewer_names","","",514,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"no_landing_pads","","",514,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"unstable_options","","",514,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"nonzeroing_move_hints","","",514,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"overflow_checks","","",514,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"crt_static","","",514,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"crt_static_feature","","",514,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"must_not_eliminate_frame_pointers","","",514,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"generate_plugin_registrar_symbol","","Returns the symbol name for the registrar function, given the crate Svh and the function DefIndex.",514,{"inputs":[{"name":"self"},{"name":"cratedisambiguator"}],"output":{"name":"string"}}],[11,"generate_derive_registrar_symbol","","",514,{"inputs":[{"name":"self"},{"name":"cratedisambiguator"}],"output":{"name":"string"}}],[11,"sysroot","","",514,{"inputs":[{"name":"self"}],"output":{"name":"path"}}],[11,"target_filesearch","","",514,{"inputs":[{"name":"self"},{"name":"pathkind"}],"output":{"name":"filesearch"}}],[11,"host_filesearch","","",514,{"inputs":[{"name":"self"},{"name":"pathkind"}],"output":{"name":"filesearch"}}],[11,"set_incr_session_load_dep_graph","","",514,{"inputs":[{"name":"self"},{"name":"bool"}],"output":null}],[11,"incr_session_load_dep_graph","","",514,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"init_incr_comp_session","","",514,{"inputs":[{"name":"self"},{"name":"pathbuf"},{"name":"lock"},{"name":"bool"}],"output":null}],[11,"finalize_incr_comp_session","","",514,{"inputs":[{"name":"self"},{"name":"pathbuf"}],"output":null}],[11,"mark_incr_comp_session_as_invalid","","",514,{"inputs":[{"name":"self"}],"output":null}],[11,"incr_comp_session_dir","","",514,{"inputs":[{"name":"self"}],"output":{"generics":["pathbuf"],"name":"ref"}}],[11,"incr_comp_session_dir_opt","","",514,{"inputs":[{"name":"self"}],"output":{"generics":["ref"],"name":"option"}}],[11,"print_perf_stats","","",514,{"inputs":[{"name":"self"}],"output":null}],[11,"consider_optimizing","","We want to know if we're allowed to do an optimization for crate foo from -z fuel=foo=n. This expends fuel if applicable, and records fuel if applicable.",514,{"inputs":[{"name":"self"},{"name":"str"},{"name":"t"}],"output":{"name":"bool"}}],[11,"query_threads","","Returns the number of query threads that should be used for this compilation",514,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"codegen_units","","Returns the number of codegen units that should be used for this compilation",514,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"teach","","",514,{"inputs":[{"name":"self"},{"name":"diagnosticid"}],"output":{"name":"bool"}}],[11,"rust_2018","","Are we allowed to use features from the Rust 2018 edition?",514,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"edition","","",514,{"inputs":[{"name":"self"}],"output":{"name":"edition"}}],[11,"assert_receiver_is_total_eq","","",516,null],[11,"eq","","",516,{"inputs":[{"name":"self"},{"name":"cratedisambiguator"}],"output":{"name":"bool"}}],[11,"ne","","",516,{"inputs":[{"name":"self"},{"name":"cratedisambiguator"}],"output":{"name":"bool"}}],[11,"cmp","","",516,{"inputs":[{"name":"self"},{"name":"cratedisambiguator"}],"output":{"name":"ordering"}}],[11,"partial_cmp","","",516,{"inputs":[{"name":"self"},{"name":"cratedisambiguator"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"lt","","",516,{"inputs":[{"name":"self"},{"name":"cratedisambiguator"}],"output":{"name":"bool"}}],[11,"le","","",516,{"inputs":[{"name":"self"},{"name":"cratedisambiguator"}],"output":{"name":"bool"}}],[11,"gt","","",516,{"inputs":[{"name":"self"},{"name":"cratedisambiguator"}],"output":{"name":"bool"}}],[11,"ge","","",516,{"inputs":[{"name":"self"},{"name":"cratedisambiguator"}],"output":{"name":"bool"}}],[11,"hash","","",516,null],[11,"fmt","","",516,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",516,{"inputs":[{"name":"self"}],"output":{"name":"cratedisambiguator"}}],[11,"encode","","",516,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",516,{"inputs":[{"name":"__d"}],"output":{"generics":["cratedisambiguator"],"name":"result"}}],[11,"to_fingerprint","","",516,{"inputs":[{"name":"self"}],"output":{"name":"fingerprint"}}],[11,"from","","",516,{"inputs":[{"name":"fingerprint"}],"output":{"name":"cratedisambiguator"}}],[11,"hash_stable","","",516,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"fmt","","",521,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",522,{"inputs":[{"name":"self"}],"output":{"name":"compileincomplete"}}],[11,"fmt","","",522,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"from","","",522,{"inputs":[{"name":"errorreported"}],"output":{"name":"compileincomplete"}}],[0,"traits","rustc","Trait Resolution. See [rustc guide] for more info on how this works.",null,null],[3,"OverlapResult","rustc::traits","",null,null],[12,"impl_header","","",550,null],[12,"intercrate_ambiguity_causes","","",550,null],[3,"FulfillmentContext","","The fulfillment context is used to drive trait resolution.  It consists of a list of obligations that must be (eventually) satisfied. The job is to track which are satisfied, which yielded errors, and which are still pending. At any point, users can call `select_where_possible`, and the fulfillment context will try to do selection, retaining only those obligations that remain ambiguous. This may be helpful in pushing type inference along. Once all type inference constraints have been generated, the method `select_all_or_error` can be used to report any remaining ambiguous cases as errors.",null,null],[12,"predicates","","",551,null],[12,"register_region_obligations","","",551,null],[3,"PendingPredicateObligation","","",null,null],[12,"obligation","","",552,null],[12,"stalled_on","","",552,null],[3,"MismatchedProjectionTypes","","",null,null],[12,"err","","",553,null],[3,"ProjectionCache","","The projection cache. Unlike the standard caches, this can include infcx-dependent type variables - therefore, we have to roll the cache back each time we roll a snapshot back, to avoid assumptions on yet-unresolved inference variables. Types with skolemized regions also have to be removed when the respective snapshot ends.",null,null],[12,"map","","",554,null],[3,"ProjectionCacheSnapshot","","",null,null],[12,"snapshot","","",555,null],[3,"Normalized","","",null,null],[12,"value","","",556,null],[12,"obligations","","",556,null],[3,"OnUnimplementedDirective","","",null,null],[12,"condition","","",557,null],[12,"subcommands","","",557,null],[12,"message","","",557,null],[12,"label","","",557,null],[12,"note","","",557,null],[3,"OnUnimplementedNote","","",null,null],[12,"message","","",558,null],[12,"label","","",558,null],[12,"note","","",558,null],[3,"EvaluationCache","","",null,null],[12,"hashmap","","",559,null],[3,"SelectionContext","","",null,null],[12,"infcx","","",560,null],[12,"freshener","","Freshener used specifically for skolemizing entries on the obligation stack. This ensures that all entries on the stack at one time will have the same set of skolemized entries, which is important for checking for trait bounds that recursively require themselves.",560,null],[12,"intercrate","","If true, indicates that the evaluation should be conservative and consider the possibility of types outside this crate. This comes up primarily when resolving ambiguity. Imagine there is some trait reference `$0 : Bar` where `$0` is an inference variable. If `intercrate` is true, then we can never say for sure that this reference is not implemented, even if there are no impls at all for `Bar`, because `$0` could be bound to some type that in a downstream crate that implements `Bar`. This is the suitable mode for coherence. Elsewhere, though, we set this to false, because we are only interested in types that the user could actually have written --- in other words, we consider `$0 : Bar` to be unimplemented if there is no type that the user could actually name that would satisfy it. This avoids crippling inference, basically.",560,null],[12,"intercrate_ambiguity_causes","","",560,null],[12,"allow_negative_impls","","Controls whether or not to filter out negative impls when selecting. This is used in librustdoc to distinguish between the lack of an impl and a negative impl",560,null],[12,"query_mode","","The mode that trait queries run in, which informs our error handling policy. In essence, canonicalized queries need their errors propagated rather than immediately reported because we do not have accurate spans.",560,null],[3,"SelectionCache","","",null,null],[12,"hashmap","","",561,null],[3,"OverflowError","","Indicates that trait evaluation caused overflow.",null,null],[3,"OverlapError","","Information pertinent to an overlapping impl error.",null,null],[12,"with_impl","","",562,null],[12,"trait_desc","","",562,null],[12,"self_desc","","",562,null],[12,"intercrate_ambiguity_causes","","",562,null],[3,"SpecializesCache","","",null,null],[12,"map","","",563,null],[3,"SupertraitDefIds","","",null,null],[12,"tcx","","",564,null],[12,"stack","","",564,null],[12,"visited","","",564,null],[3,"Obligation","","An `Obligation` represents some trait reference (e.g. `int:Eq`) for which the vtable must be found.  The process of finding a vtable is called \"resolving\" the `Obligation`. This process consists of either identifying an `impl` (e.g., `impl Eq for int`) that provides the required vtable, or else finding a bound that is in scope. The eventual result is usually a `Selection` (defined below).",null,null],[12,"cause","","Why do we have to prove this thing?",565,null],[12,"param_env","","In which environment should we prove this thing?",565,null],[12,"predicate","","What are we trying to prove?",565,null],[12,"recursion_depth","","If we started proving this as a result of trying to prove something else, track the total depth to ensure termination. If this goes over a certain threshold, we abort compilation -- in such cases, we can not say whether or not the predicate holds for certain. Stupid halting problem. Such a drag.",565,null],[3,"ObligationCause","","Why did we incur this obligation? Used for error reporting.",null,null],[12,"span","","",566,null],[12,"body_id","","",566,null],[12,"code","","",566,null],[3,"DerivedObligationCause","","",null,null],[12,"parent_trait_ref","","The trait reference of the parent obligation that led to the current obligation. Note that only trait obligations lead to derived obligations, so we just store the trait reference here directly.",567,null],[12,"parent_code","","The parent trait had this cause",567,null],[3,"ProgramClause","","A \"program clause\" has the form `D :- G1, ..., Gn`. It is saying that the domain goal `D` is true if `G1...Gn` are provable. This is equivalent to the implication `G1..Gn => D`; we usually write it with the reverse implication operator `:-` to emphasize the way that programs are actually solved (via backchaining, which starts with the goal to solve and proceeds from there).",null,null],[12,"goal","","This goal will be considered true...",568,null],[12,"hypotheses","","...if we can prove these hypotheses (there may be no hypotheses at all):",568,null],[3,"FulfillmentError","","",null,null],[12,"obligation","","",569,null],[12,"code","","",569,null],[3,"VtableImplData","","Identifies a particular impl in the source, along with a set of substitutions from the impl's type/lifetime parameters. The `nested` vector corresponds to the nested obligations attached to the impl's type parameters.",null,null],[12,"impl_def_id","","",570,null],[12,"substs","","",570,null],[12,"nested","","",570,null],[3,"VtableGeneratorData","","",null,null],[12,"closure_def_id","","",571,null],[12,"substs","","",571,null],[12,"nested","","Nested obligations. This can be non-empty if the generator signature contains associated types.",571,null],[3,"VtableClosureData","","",null,null],[12,"closure_def_id","","",572,null],[12,"substs","","",572,null],[12,"nested","","Nested obligations. This can be non-empty if the closure signature contains associated types.",572,null],[3,"VtableAutoImplData","","",null,null],[12,"trait_def_id","","",573,null],[12,"nested","","",573,null],[3,"VtableBuiltinData","","",null,null],[12,"nested","","",574,null],[3,"VtableObjectData","","A vtable for some object-safe trait `Foo` automatically derived for the object type `Foo`.",null,null],[12,"upcast_trait_ref","","`Foo` upcast to the obligation trait. This will be some supertrait of `Foo`.",575,null],[12,"vtable_base","","The vtable is formed by concatenating together the method lists of the base object trait and all supertraits; this is the start of `upcast_trait_ref`'s methods in that vtable.",575,null],[12,"nested","","",575,null],[3,"VtableFnPointerData","","",null,null],[12,"fn_ty","","",576,null],[12,"nested","","",576,null],[4,"OrphanCheckErr","","",null,null],[13,"NoLocalInputType","","",577,null],[13,"UncoveredTy","","",577,null],[4,"Reveal","","Depending on the stage of compilation, we want projection to be more or less conservative.",null,null],[13,"UserFacing","","At type-checking time, we refuse to project any associated type that is marked `default`. Non-`default` (\"final\") types are always projected. This is necessary in general for soundness of specialization. However, we could allow projections in fully-monomorphic cases. We choose not to, because we prefer for `default type` to force the type definition to be treated abstractly by any consumers of the impl. Concretely, that means that the following example will fail to compile:",578,null],[13,"All","","At trans time, all monomorphic projections will succeed. Also, `impl Trait` is normalized to the concrete type, which has to be already collected by type-checking.",578,null],[4,"ObjectSafetyViolation","","",null,null],[13,"SizedSelf","","Self : Sized declared on the trait",579,null],[13,"SupertraitSelf","","Supertrait reference references `Self` an in illegal location (e.g. `trait Foo : Bar<Self>`)",579,null],[13,"Method","","Method has something illegal",579,null],[13,"AssociatedConst","","Associated const",579,null],[4,"MethodViolationCode","","Reasons a method might not be object-safe.",null,null],[13,"StaticMethod","","e.g., `fn foo()`",580,null],[13,"ReferencesSelf","","e.g., `fn foo(&self, x: Self)` or `fn foo(&self) -> Self`",580,null],[13,"Generic","","e.g., `fn foo<A>()`",580,null],[13,"NonStandardSelfType","","arbitrary `self` type, e.g. `self: Rc<Self>`",580,null],[4,"EvaluationResult","","The result of trait evaluation. The order is important here as the evaluation of a list is the maximum of the evaluations.",null,null],[13,"EvaluatedToOk","","Evaluation successful",581,null],[13,"EvaluatedToAmbig","","Evaluation is known to be ambiguous - it might hold for some assignment of inference variables, but it might not.",581,null],[13,"EvaluatedToUnknown","","Evaluation failed because of recursion involving inference variables. We are somewhat imprecise there, so we don't actually know the real result.",581,null],[13,"EvaluatedToRecur","","Evaluation failed because we encountered an obligation we are already trying to prove on this branch.",581,null],[13,"EvaluatedToErr","","Evaluation failed",581,null],[4,"IntercrateAmbiguityCause","","",null,null],[13,"DownstreamCrate","","",582,null],[12,"trait_desc","rustc::traits::IntercrateAmbiguityCause","",582,null],[12,"self_desc","","",582,null],[13,"UpstreamCrateUpdate","rustc::traits","",582,null],[12,"trait_desc","rustc::traits::IntercrateAmbiguityCause","",582,null],[12,"self_desc","","",582,null],[4,"IntercrateMode","rustc::traits","",null,null],[13,"Issue43355","","",583,null],[13,"Fixed","","",583,null],[4,"TraitQueryMode","","",null,null],[13,"Standard","","",584,null],[13,"Canonical","","",584,null],[4,"ObligationCauseCode","","",null,null],[13,"MiscObligation","","Not well classified or should be obvious from span.",585,null],[13,"SliceOrArrayElem","","A slice or array is WF only if `T: Sized`",585,null],[13,"TupleElem","","A tuple is WF only if its middle elements are Sized",585,null],[13,"ProjectionWf","","This is the trait reference from the given projection",585,null],[13,"ItemObligation","","In an impl of trait X for type Y, type Y must also implement all supertraits of X.",585,null],[13,"ReferenceOutlivesReferent","","A type like `&'a T` is WF only if `T: 'a`.",585,null],[13,"ObjectTypeBound","","A type like `Box<Foo<'a> + 'b>` is WF only if `'b: 'a`.",585,null],[13,"ObjectCastObligation","","Obligation incurred due to an object cast.",585,null],[13,"AssignmentLhsSized","","L = X implies that L is Sized",585,null],[13,"TupleInitializerSized","","(x1, .., xn) must be Sized",585,null],[13,"StructInitializerSized","","S { ... } must be Sized",585,null],[13,"VariableType","","Type of each variable must be Sized",585,null],[13,"SizedReturnType","","Return type must be Sized",585,null],[13,"SizedYieldType","","Yield type must be Sized",585,null],[13,"RepeatVec","","[T,..n] --> T must be Copy",585,null],[13,"FieldSized","","Types of fields (other than the last) in a struct must be sized.",585,null],[13,"ConstSized","","Constant expressions must be sized.",585,null],[13,"SharedStatic","","static items must have `Sync` type",585,null],[13,"BuiltinDerivedObligation","","",585,null],[13,"ImplDerivedObligation","","",585,null],[13,"CompareImplMethodObligation","","error derived when matching traits/impls; see ObligationCause for more details",585,null],[12,"item_name","rustc::traits::ObligationCauseCode","",585,null],[12,"impl_item_def_id","","",585,null],[12,"trait_item_def_id","","",585,null],[13,"ExprAssignable","rustc::traits","Checking that this expression can be assigned where it needs to be",585,null],[13,"MatchExpressionArm","","Computing common supertype in the arms of a match expression",585,null],[12,"arm_span","rustc::traits::ObligationCauseCode","",585,null],[12,"source","","",585,null],[13,"IfExpression","rustc::traits","Computing common supertype in an if expression",585,null],[13,"IfExpressionWithNoElse","","Computing common supertype of an if expression with no else counter-part",585,null],[13,"MainFunctionType","","`main` has wrong type",585,null],[13,"StartFunctionType","","`start` has wrong type",585,null],[13,"IntrinsicType","","intrinsic has wrong type",585,null],[13,"MethodReceiver","","method receiver",585,null],[13,"ReturnNoExpression","","`return` with no expression",585,null],[13,"ReturnType","","`return` with an expression",585,null],[13,"BlockTailExpression","","Block implicit return",585,null],[4,"WhereClauseAtom","","The following types: * `WhereClauseAtom` * `DomainGoal` * `Goal` * `Clause` are used for representing the trait system in the form of logic programming clauses. They are part of the interface for the chalk SLG solver.",null,null],[13,"Implemented","","",586,null],[13,"ProjectionEq","","",586,null],[4,"DomainGoal","","",null,null],[13,"Holds","","",587,null],[13,"WellFormed","","",587,null],[13,"FromEnv","","",587,null],[13,"WellFormedTy","","",587,null],[13,"Normalize","","",587,null],[13,"FromEnvTy","","",587,null],[13,"RegionOutlives","","",587,null],[13,"TypeOutlives","","",587,null],[4,"QuantifierKind","","",null,null],[13,"Universal","","",588,null],[13,"Existential","","",588,null],[4,"Goal","","",null,null],[13,"Implies","","",589,null],[13,"And","","",589,null],[13,"Not","","",589,null],[13,"DomainGoal","","",589,null],[13,"Quantified","","",589,null],[13,"CannotProve","","",589,null],[4,"Clause","","This matches the definition from Page 7 of \"A Proof Procedure for the Logic of Hereditary Harrop Formulas\".",null,null],[13,"Implies","","",590,null],[13,"ForAll","","",590,null],[4,"SelectionError","","",null,null],[13,"Unimplemented","","",591,null],[13,"OutputTypeParameterMismatch","","",591,null],[13,"TraitNotObjectSafe","","",591,null],[13,"ConstEvalFailure","","",591,null],[13,"Overflow","","",591,null],[4,"FulfillmentErrorCode","","",null,null],[13,"CodeSelectionError","","",592,null],[13,"CodeProjectionError","","",592,null],[13,"CodeSubtypeError","","",592,null],[13,"CodeAmbiguity","","",592,null],[4,"Vtable","","Given the successful resolution of an obligation, the `Vtable` indicates where the vtable comes from. Note that while we call this a \"vtable\", it does not necessarily indicate dynamic dispatch at runtime. `Vtable` instances just tell the compiler where to find methods, but in generic code those methods are typically statically dispatched -- only when an object is constructed is a `Vtable` instance reified into an actual vtable.",null,null],[13,"VtableImpl","","Vtable identifying a particular impl.",593,null],[13,"VtableAutoImpl","","Vtable for auto trait implementations This carries the information and nested obligations with regards to an auto implementation for a trait `Trait`. The nested obligations ensure the trait implementation holds for all the constituent types.",593,null],[13,"VtableParam","","Successful resolution to an obligation provided by the caller for some type parameter. The `Vec<N>` represents the obligations incurred from normalizing the where-clause (if any).",593,null],[13,"VtableObject","","Virtual calls through an object",593,null],[13,"VtableBuiltin","","Successful resolution for a builtin trait.",593,null],[13,"VtableClosure","","Vtable automatically generated for a closure. The def ID is the ID of the closure expression. This is a `VtableImpl` in spirit, but the impl is generated by the compiler and does not appear in the source.",593,null],[13,"VtableFnPointer","","Same as above, but for a fn pointer type with the given signature.",593,null],[13,"VtableGenerator","","Vtable automatically generated for a generator",593,null],[5,"orphan_check","","Checks the coherence orphan rules. `impl_def_id` should be the def-id of a trait impl. To pass, either the trait must be local, or else two conditions must be satisfied:",null,{"inputs":[{"name":"tyctxt"},{"name":"defid"}],"output":{"generics":["orphancheckerr"],"name":"result"}}],[5,"overlapping_impls","","If there are types that satisfy both impls, invokes `on_overlap` with a suitably-freshened `ImplHeader` with those types substituted. Otherwise, invokes `no_overlap`.",null,{"inputs":[{"name":"tyctxt"},{"name":"defid"},{"name":"defid"},{"name":"intercratemode"},{"name":"f1"},{"name":"f2"}],"output":{"name":"r"}}],[5,"normalize","","Normalizes any associated type projections in `value`, replacing them with a fully resolved type where possible. The return value combines the normalized result and any additional obligations that were incurred as result.",null,{"inputs":[{"name":"selectioncontext"},{"name":"paramenv"},{"name":"obligationcause"},{"name":"t"}],"output":{"name":"normalized"}}],[5,"normalize_projection_type","","The guts of `normalize`: normalize a specific projection like `<T as Trait>::Item`. The result is always a type (and possibly additional obligations). If ambiguity arises, which implies that there are unresolved type variables in the projection, we will substitute a fresh type variable `$X` and generate a new obligation `<T as Trait>::Item == $X` for later.",null,{"inputs":[{"name":"selectioncontext"},{"name":"paramenv"},{"name":"projectionty"},{"name":"obligationcause"},{"name":"usize"}],"output":{"generics":["ty"],"name":"normalized"}}],[5,"poly_project_and_unify_type","","Evaluates constraints of the form:",null,{"inputs":[{"name":"selectioncontext"},{"name":"obligation"}],"output":{"generics":["option","mismatchedprojectiontypes"],"name":"result"}}],[5,"translate_substs","","Given a subst for the requested impl, translate it to a subst appropriate for the actual item definition (whether it be in that impl, a parent impl, or the trait).",null,{"inputs":[{"name":"inferctxt"},{"name":"paramenv"},{"name":"defid"},{"name":"substs"},{"name":"node"}],"output":{"name":"substs"}}],[5,"find_associated_item","","Given a selected impl described by `impl_data`, returns the definition and substitutions for the method with the name `name` the kind `kind`, and trait method substitutions `substs`, in that impl, a less specialized impl, or the trait default, whichever applies.",null,null],[5,"elaborate_predicates","","",null,{"inputs":[{"name":"tyctxt"},{"generics":["predicate"],"name":"vec"}],"output":{"name":"elaborator"}}],[5,"supertraits","","",null,{"inputs":[{"name":"tyctxt"},{"name":"polytraitref"}],"output":{"name":"supertraits"}}],[5,"supertrait_def_ids","","",null,{"inputs":[{"name":"tyctxt"},{"name":"defid"}],"output":{"name":"supertraitdefids"}}],[5,"transitive_bounds","","",null,null],[5,"predicates_for_generics","","Creates predicate obligations from the generic bounds.",null,{"inputs":[{"name":"obligationcause"},{"name":"paramenv"},{"name":"instantiatedpredicates"}],"output":{"name":"predicateobligations"}}],[5,"type_known_to_meet_bound","","Determines whether the type `ty` is known to meet `bound` and returns true if so. Returns false if `ty` either does not meet `bound` or is not known to meet bound (note that this is conservative towards no impl, which is the opposite of the `evaluate` methods).",null,{"inputs":[{"name":"inferctxt"},{"name":"paramenv"},{"name":"ty"},{"name":"defid"},{"name":"span"}],"output":{"name":"bool"}}],[5,"normalize_param_env_or_error","","Normalizes the parameter environment, reporting errors if they occur.",null,{"inputs":[{"name":"tyctxt"},{"name":"defid"},{"name":"paramenv"},{"name":"obligationcause"}],"output":{"name":"paramenv"}}],[5,"fully_normalize","","",null,{"inputs":[{"name":"inferctxt"},{"name":"obligationcause"},{"name":"paramenv"},{"name":"t"}],"output":{"generics":["vec"],"name":"result"}}],[5,"fully_normalize_with_fulfillcx","","",null,{"inputs":[{"name":"inferctxt"},{"name":"fulfillmentcontext"},{"name":"obligationcause"},{"name":"paramenv"},{"name":"t"}],"output":{"generics":["vec"],"name":"result"}}],[5,"normalize_and_test_predicates","","Normalizes the predicates and checks whether they hold in an empty environment. If this returns false, then either normalize encountered an error or one of the predicates did not hold. Used when creating vtables to check for unsatisfiable methods.",null,{"inputs":[{"name":"tyctxt"},{"generics":["predicate"],"name":"vec"}],"output":{"name":"bool"}}],[5,"substitute_normalize_and_test_predicates","","",null,null],[5,"vtable_methods","","Given a trait `trait_ref`, iterates the vtable entries that come from `trait_ref`, including its supertraits.",null,{"inputs":[{"name":"tyctxt"},{"name":"polytraitref"}],"output":{"generics":["vec"],"name":"lrc"}}],[5,"provide","","",null,{"inputs":[{"name":"providers"}],"output":null}],[0,"specialization_graph","","",null,null],[3,"Graph","rustc::traits::specialization_graph","A per-trait graph of impls in specialization order. At the moment, this graph forms a tree rooted with the trait itself, with all other nodes representing impls, and parent-child relationships representing specializations.",null,null],[12,"parent","","",594,null],[12,"children","","",594,null],[3,"Ancestors","","",null,null],[12,"trait_def_id","","",595,null],[12,"specialization_graph","","",595,null],[12,"current_source","","",595,null],[3,"NodeItem","","",null,null],[12,"node","","",596,null],[12,"item","","",596,null],[4,"Node","","A node in the specialization graph is either an impl or a trait definition; either can serve as a source of item definitions. There is always exactly one trait definition node: the root.",null,null],[13,"Impl","","",597,null],[13,"Trait","","",597,null],[5,"ancestors","","Walk up the specialization ancestors of a given impl, starting with that impl itself.",null,{"inputs":[{"name":"tyctxt"},{"name":"defid"},{"name":"defid"}],"output":{"name":"ancestors"}}],[0,"coherence","rustc::traits","See rustc guide chapters on [trait-resolution] and [trait-specialization] for more info on how this works.",null,null],[3,"OverlapResult","rustc::traits::coherence","",null,null],[12,"impl_header","","",550,null],[12,"intercrate_ambiguity_causes","","",550,null],[4,"InCrate","","Whether we do the orphan check relative to this crate or to some remote crate.",null,null],[13,"Local","","",598,null],[13,"Remote","","",598,null],[4,"Conflict","","",null,null],[13,"Upstream","","",599,null],[13,"Downstream","","",599,null],[12,"used_to_be_broken","rustc::traits::coherence::Conflict","",599,null],[4,"OrphanCheckErr","rustc::traits::coherence","",null,null],[13,"NoLocalInputType","","",577,null],[13,"UncoveredTy","","",577,null],[5,"overlapping_impls","","If there are types that satisfy both impls, invokes `on_overlap` with a suitably-freshened `ImplHeader` with those types substituted. Otherwise, invokes `no_overlap`.",null,{"inputs":[{"name":"tyctxt"},{"name":"defid"},{"name":"defid"},{"name":"intercratemode"},{"name":"f1"},{"name":"f2"}],"output":{"name":"r"}}],[5,"with_fresh_ty_vars","","",null,{"inputs":[{"name":"selectioncontext"},{"name":"paramenv"},{"name":"defid"}],"output":{"name":"implheader"}}],[5,"overlap","","Can both impl `a` and impl `b` be satisfied by a common type (including `where` clauses)? If so, returns an `ImplHeader` that unifies the two impls.",null,{"inputs":[{"name":"selectioncontext"},{"name":"defid"},{"name":"defid"}],"output":{"generics":["overlapresult"],"name":"option"}}],[5,"trait_ref_is_knowable","","",null,{"inputs":[{"name":"tyctxt"},{"name":"traitref"}],"output":{"generics":["conflict"],"name":"option"}}],[5,"trait_ref_is_local_or_fundamental","","",null,{"inputs":[{"name":"tyctxt"},{"name":"traitref"}],"output":{"name":"bool"}}],[5,"orphan_check","","Checks the coherence orphan rules. `impl_def_id` should be the def-id of a trait impl. To pass, either the trait must be local, or else two conditions must be satisfied:",null,{"inputs":[{"name":"tyctxt"},{"name":"defid"}],"output":{"generics":["orphancheckerr"],"name":"result"}}],[5,"orphan_check_trait_ref","","Check whether a trait-ref is potentially implementable by a crate.",null,{"inputs":[{"name":"tyctxt"},{"name":"traitref"},{"name":"incrate"}],"output":{"generics":["orphancheckerr"],"name":"result"}}],[5,"uncovered_tys","","",null,{"inputs":[{"name":"tyctxt"},{"name":"ty"},{"name":"incrate"}],"output":{"generics":["ty"],"name":"vec"}}],[5,"is_possibly_remote_type","","",null,{"inputs":[{"name":"ty"},{"name":"incrate"}],"output":{"name":"bool"}}],[5,"ty_is_local","","",null,{"inputs":[{"name":"tyctxt"},{"name":"ty"},{"name":"incrate"}],"output":{"name":"bool"}}],[5,"fundamental_ty","","",null,{"inputs":[{"name":"tyctxt"},{"name":"ty"}],"output":{"name":"bool"}}],[5,"def_id_is_local","","",null,{"inputs":[{"name":"defid"},{"name":"incrate"}],"output":{"name":"bool"}}],[5,"ty_is_local_constructor","","",null,{"inputs":[{"name":"ty"},{"name":"incrate"}],"output":{"name":"bool"}}],[11,"clone","","",598,{"inputs":[{"name":"self"}],"output":{"name":"incrate"}}],[11,"fmt","","",598,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",599,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",599,{"inputs":[{"name":"self"}],"output":{"name":"conflict"}}],[0,"error_reporting","rustc::traits","",null,null],[4,"ArgKind","rustc::traits::error_reporting","Summarizes information",null,null],[13,"Arg","","An argument of non-tuple type. Parameters are (name, ty)",600,null],[13,"Tuple","","An argument of tuple type. For a \"found\" argument, the span is the locationo in the source of the pattern. For a \"expected\" argument, it will be None. The vector is a list of (name, ty) strings for the components of the tuple.",600,null],[11,"report_fulfillment_errors","rustc::infer","",203,{"inputs":[{"name":"self"},{"name":"vec"},{"generics":["bodyid"],"name":"option"},{"name":"bool"}],"output":null}],[11,"error_implies","","",203,{"inputs":[{"name":"self"},{"name":"predicate"},{"name":"predicate"}],"output":{"name":"bool"}}],[11,"report_fulfillment_error","","",203,{"inputs":[{"name":"self"},{"name":"fulfillmenterror"},{"generics":["bodyid"],"name":"option"},{"name":"bool"}],"output":null}],[11,"report_projection_error","","",203,{"inputs":[{"name":"self"},{"name":"predicateobligation"},{"name":"mismatchedprojectiontypes"}],"output":null}],[11,"fuzzy_match_tys","","",203,{"inputs":[{"name":"self"},{"name":"ty"},{"name":"ty"}],"output":{"name":"bool"}}],[11,"impl_similar_to","","",203,{"inputs":[{"name":"self"},{"name":"polytraitref"},{"name":"predicateobligation"}],"output":{"generics":["defid"],"name":"option"}}],[11,"on_unimplemented_note","","",203,{"inputs":[{"name":"self"},{"name":"polytraitref"},{"name":"predicateobligation"}],"output":{"name":"onunimplementednote"}}],[11,"find_similar_impl_candidates","","",203,{"inputs":[{"name":"self"},{"name":"polytraitref"}],"output":{"generics":["traitref"],"name":"vec"}}],[11,"report_similar_impl_candidates","","",203,{"inputs":[{"name":"self"},{"generics":["traitref"],"name":"vec"},{"name":"diagnosticbuilder"}],"output":null}],[11,"report_overflow_error","","Reports that an overflow has occurred and halts compilation. We halt compilation unconditionally because it is important that overflows never be masked -- they basically represent computations whose result could not be truly determined and thus we can't say if the program type checks or not -- and they are unusual occurrences in any case.",203,null],[11,"report_overflow_error_cycle","","Reports that a cycle was detected which led to overflow and halts compilation. This is equivalent to `report_overflow_error` except that we can give a more helpful error message (and, in particular, we do not suggest increasing the overflow limit, which is not going to help).",203,null],[11,"report_extra_impl_obligation","","",203,{"inputs":[{"name":"self"},{"name":"span"},{"name":"name"},{"name":"defid"},{"name":"defid"},{"name":"display"}],"output":{"name":"diagnosticbuilder"}}],[11,"get_parent_trait_ref","","Get the parent trait chain start",203,{"inputs":[{"name":"self"},{"name":"obligationcausecode"}],"output":{"generics":["string"],"name":"option"}}],[11,"report_selection_error","","",203,{"inputs":[{"name":"self"},{"name":"predicateobligation"},{"name":"selectionerror"},{"name":"bool"}],"output":null}],[11,"suggest_borrow_on_unsized_slice","","When encountering an assignment of an unsized trait, like `let x = \"\"[..];`, provide a suggestion to borrow the initializer in order to use have a slice instead.",203,{"inputs":[{"name":"self"},{"name":"obligationcausecode"},{"name":"diagnosticbuilder"}],"output":null}],[11,"suggest_remove_reference","","Whenever references are used by mistake, like `for (i, e) in &vec.iter().enumerate()`, suggest removing these references until we reach a type that implements the trait.",203,{"inputs":[{"name":"self"},{"name":"predicateobligation"},{"name":"diagnosticbuilder"},{"name":"binder"}],"output":null}],[11,"get_fn_like_arguments","","Given some node representing a fn-like thing in the HIR map, returns a span and `ArgKind` information that describes the arguments it expects. This can be supplied to `report_arg_count_mismatch`.",203,null],[11,"report_arg_count_mismatch","","Reports an error when the number of arguments needed by a trait match doesn't match the number that the expression provides.",203,{"inputs":[{"name":"self"},{"name":"span"},{"generics":["span"],"name":"option"},{"generics":["argkind"],"name":"vec"},{"generics":["argkind"],"name":"vec"},{"name":"bool"}],"output":{"name":"diagnosticbuilder"}}],[11,"report_closure_arg_mismatch","","",203,{"inputs":[{"name":"self"},{"name":"span"},{"generics":["span"],"name":"option"},{"name":"polytraitref"},{"name":"polytraitref"}],"output":{"name":"diagnosticbuilder"}}],[11,"maybe_report_ambiguity","","",203,{"inputs":[{"name":"self"},{"name":"predicateobligation"},{"generics":["bodyid"],"name":"option"}],"output":null}],[11,"predicate_can_apply","","Returns whether the trait predicate may apply for some assignment to the type parameters.",203,{"inputs":[{"name":"self"},{"name":"paramenv"},{"name":"polytraitref"}],"output":{"name":"bool"}}],[11,"note_obligation_cause","","",203,{"inputs":[{"name":"self"},{"name":"diagnosticbuilder"},{"name":"obligation"}],"output":null}],[11,"note_obligation_cause_code","","",203,{"inputs":[{"name":"self"},{"name":"diagnosticbuilder"},{"name":"t"},{"name":"obligationcausecode"},{"name":"vec"}],"output":null}],[11,"suggest_new_overflow_limit","","",203,{"inputs":[{"name":"self"},{"name":"diagnosticbuilder"}],"output":null}],[11,"is_recursive_obligation","","",203,{"inputs":[{"name":"self"},{"name":"vec"},{"name":"obligationcausecode"}],"output":{"name":"bool"}}],[11,"empty","rustc::traits::error_reporting","",600,{"inputs":[],"output":{"name":"argkind"}}],[11,"from_expected_ty","","Creates an `ArgKind` from the expected type of an argument. This has no name (`_`) and no source spans..",600,{"inputs":[{"name":"ty"}],"output":{"name":"argkind"}}],[0,"engine","rustc::traits","",null,null],[8,"TraitEngine","rustc::traits::engine","",null,null],[10,"normalize_projection_type","","",601,{"inputs":[{"name":"self"},{"name":"inferctxt"},{"name":"paramenv"},{"name":"projectionty"},{"name":"obligationcause"}],"output":{"name":"ty"}}],[10,"register_bound","","",601,{"inputs":[{"name":"self"},{"name":"inferctxt"},{"name":"paramenv"},{"name":"ty"},{"name":"defid"},{"name":"obligationcause"}],"output":null}],[10,"register_predicate_obligation","","",601,{"inputs":[{"name":"self"},{"name":"inferctxt"},{"name":"predicateobligation"}],"output":null}],[10,"select_all_or_error","","",601,{"inputs":[{"name":"self"},{"name":"inferctxt"}],"output":{"generics":["vec"],"name":"result"}}],[10,"select_where_possible","","",601,{"inputs":[{"name":"self"},{"name":"inferctxt"}],"output":{"generics":["vec"],"name":"result"}}],[10,"pending_obligations","","",601,{"inputs":[{"name":"self"}],"output":{"generics":["pendingpredicateobligation"],"name":"vec"}}],[11,"new","","",601,{"inputs":[{"name":"tyctxt"}],"output":{"name":"box"}}],[11,"register_predicate_obligations","","",601,{"inputs":[{"name":"self"},{"name":"inferctxt"},{"name":"i"}],"output":null}],[0,"fulfill","rustc::traits","",null,null],[3,"FulfillmentContext","rustc::traits::fulfill","The fulfillment context is used to drive trait resolution.  It consists of a list of obligations that must be (eventually) satisfied. The job is to track which are satisfied, which yielded errors, and which are still pending. At any point, users can call `select_where_possible`, and the fulfillment context will try to do selection, retaining only those obligations that remain ambiguous. This may be helpful in pushing type inference along. Once all type inference constraints have been generated, the method `select_all_or_error` can be used to report any remaining ambiguous cases as errors.",null,null],[12,"predicates","","",551,null],[12,"register_region_obligations","","",551,null],[3,"PendingPredicateObligation","","",null,null],[12,"obligation","","",552,null],[12,"stalled_on","","",552,null],[3,"FulfillProcessor","","",null,null],[12,"selcx","","",602,null],[12,"register_region_obligations","","",602,null],[5,"trait_ref_type_vars","","Return the set of type variables contained in a trait ref",null,{"inputs":[{"name":"selectioncontext"},{"name":"polytraitref"}],"output":{"generics":["ty"],"name":"vec"}}],[5,"process_predicate","","Processes a predicate obligation and returns either: - `Ok(Some(v))` if the predicate is true, presuming that `v` are also true - `Ok(None)` if we don't have enough info to be sure - `Err` if the predicate does not hold",null,{"inputs":[{"name":"selectioncontext"},{"name":"pendingpredicateobligation"},{"name":"bool"}],"output":{"generics":["option","fulfillmenterrorcode"],"name":"result"}}],[5,"to_fulfillment_error","","",null,{"inputs":[{"generics":["pendingpredicateobligation","fulfillmenterrorcode"],"name":"error"}],"output":{"name":"fulfillmenterror"}}],[11,"as_predicate","rustc::traits","",552,null],[11,"clone","","",552,{"inputs":[{"name":"self"}],"output":{"name":"pendingpredicateobligation"}}],[11,"fmt","","",552,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","","Creates a new fulfillment context.",551,{"inputs":[],"output":{"name":"fulfillmentcontext"}}],[11,"new_ignoring_regions","","",551,{"inputs":[],"output":{"name":"fulfillmentcontext"}}],[11,"register_predicate_obligations","","",551,{"inputs":[{"name":"self"},{"name":"inferctxt"},{"name":"i"}],"output":null}],[11,"select","","Attempts to select obligations using `selcx`. If `only_new_obligations` is true, then it only attempts to select obligations that haven't been seen before.",551,{"inputs":[{"name":"self"},{"name":"selectioncontext"}],"output":{"generics":["vec"],"name":"result"}}],[11,"normalize_projection_type","","\"Normalize\" a projection type `<SomeType as SomeTrait>::X` by creating a fresh type variable `$0` as well as a projection predicate `<SomeType as SomeTrait>::X == $0`. When the inference engine runs, it will attempt to find an impl of `SomeTrait` or a where clause that lets us unify `$0` with something concrete. If this fails, we'll unify `$0` with `projection_ty` again.",551,{"inputs":[{"name":"self"},{"name":"inferctxt"},{"name":"paramenv"},{"name":"projectionty"},{"name":"obligationcause"}],"output":{"name":"ty"}}],[11,"register_bound","","Requires that `ty` must implement the trait with `def_id` in the given environment. This trait must not have any type parameters (except for `Self`).",551,{"inputs":[{"name":"self"},{"name":"inferctxt"},{"name":"paramenv"},{"name":"ty"},{"name":"defid"},{"name":"obligationcause"}],"output":null}],[11,"register_predicate_obligation","","",551,{"inputs":[{"name":"self"},{"name":"inferctxt"},{"name":"predicateobligation"}],"output":null}],[11,"select_all_or_error","","",551,{"inputs":[{"name":"self"},{"name":"inferctxt"}],"output":{"generics":["vec"],"name":"result"}}],[11,"select_where_possible","","",551,{"inputs":[{"name":"self"},{"name":"inferctxt"}],"output":{"generics":["vec"],"name":"result"}}],[11,"pending_obligations","","",551,{"inputs":[{"name":"self"}],"output":{"generics":["pendingpredicateobligation"],"name":"vec"}}],[11,"process_obligation","rustc::traits::fulfill","",602,null],[11,"process_backedge","","",602,{"inputs":[{"name":"self"},{"name":"i"},{"generics":["pendingpredicateobligation"],"name":"phantomdata"}],"output":null}],[0,"project","rustc::traits","Code for projecting associated types out of trait references.",null,null],[3,"MismatchedProjectionTypes","rustc::traits::project","",null,null],[12,"err","","",553,null],[3,"AssociatedTypeNormalizer","","",null,null],[12,"selcx","","",603,null],[12,"param_env","","",603,null],[12,"cause","","",603,null],[12,"obligations","","",603,null],[12,"depth","","",603,null],[3,"Normalized","","",null,null],[12,"value","","",556,null],[12,"obligations","","",556,null],[3,"Progress","","",null,null],[12,"ty","","",604,null],[12,"obligations","","",604,null],[3,"ProjectionCache","","The projection cache. Unlike the standard caches, this can include infcx-dependent type variables - therefore, we have to roll the cache back each time we roll a snapshot back, to avoid assumptions on yet-unresolved inference variables. Types with skolemized regions also have to be removed when the respective snapshot ends.",null,null],[12,"map","","",554,null],[3,"ProjectionCacheKey","","",null,null],[12,"ty","","",605,null],[3,"ProjectionCacheSnapshot","","",null,null],[12,"snapshot","","",555,null],[4,"Reveal","","Depending on the stage of compilation, we want projection to be more or less conservative.",null,null],[13,"UserFacing","","At type-checking time, we refuse to project any associated type that is marked `default`. Non-`default` (\"final\") types are always projected. This is necessary in general for soundness of specialization. However, we could allow projections in fully-monomorphic cases. We choose not to, because we prefer for `default type` to force the type definition to be treated abstractly by any consumers of the impl. Concretely, that means that the following example will fail to compile:",578,null],[13,"All","","At trans time, all monomorphic projections will succeed. Also, `impl Trait` is normalized to the concrete type, which has to be already collected by type-checking.",578,null],[4,"ProjectionTyError","","When attempting to resolve `<T as TraitRef>::Name` ...",null,null],[13,"TooManyCandidates","","...we found multiple sources of information and couldn't resolve the ambiguity.",606,null],[13,"TraitSelectionError","","...an error occurred matching `T : TraitRef`",606,null],[4,"ProjectionTyCandidate","","",null,null],[13,"ParamEnv","","",607,null],[13,"TraitDef","","",607,null],[13,"Select","","",607,null],[4,"ProjectionTyCandidateSet","","",null,null],[13,"None","","",608,null],[13,"Single","","",608,null],[13,"Ambiguous","","",608,null],[13,"Error","","",608,null],[4,"ProjectedTy","","",null,null],[13,"Progress","","",609,null],[13,"NoProgress","","",609,null],[4,"ProjectionCacheEntry","","",null,null],[13,"InProgress","","",610,null],[13,"Ambiguous","","",610,null],[13,"Error","","",610,null],[13,"NormalizedTy","","",610,null],[5,"poly_project_and_unify_type","","Evaluates constraints of the form:",null,{"inputs":[{"name":"selectioncontext"},{"name":"obligation"}],"output":{"generics":["option","mismatchedprojectiontypes"],"name":"result"}}],[5,"project_and_unify_type","","Evaluates constraints of the form:",null,{"inputs":[{"name":"selectioncontext"},{"name":"obligation"}],"output":{"generics":["option","mismatchedprojectiontypes"],"name":"result"}}],[5,"normalize","","Normalizes any associated type projections in `value`, replacing them with a fully resolved type where possible. The return value combines the normalized result and any additional obligations that were incurred as result.",null,{"inputs":[{"name":"selectioncontext"},{"name":"paramenv"},{"name":"obligationcause"},{"name":"t"}],"output":{"name":"normalized"}}],[5,"normalize_with_depth","","As `normalize`, but with a custom depth.",null,{"inputs":[{"name":"selectioncontext"},{"name":"paramenv"},{"name":"obligationcause"},{"name":"usize"},{"name":"t"}],"output":{"name":"normalized"}}],[5,"normalize_projection_type","","The guts of `normalize`: normalize a specific projection like `<T as Trait>::Item`. The result is always a type (and possibly additional obligations). If ambiguity arises, which implies that there are unresolved type variables in the projection, we will substitute a fresh type variable `$X` and generate a new obligation `<T as Trait>::Item == $X` for later.",null,{"inputs":[{"name":"selectioncontext"},{"name":"paramenv"},{"name":"projectionty"},{"name":"obligationcause"},{"name":"usize"}],"output":{"generics":["ty"],"name":"normalized"}}],[5,"opt_normalize_projection_type","","The guts of `normalize`: normalize a specific projection like `<T as Trait>::Item`. The result is always a type (and possibly additional obligations). Returns `None` in the case of ambiguity, which indicates that there are unbound type variables.",null,{"inputs":[{"name":"selectioncontext"},{"name":"paramenv"},{"name":"projectionty"},{"name":"obligationcause"},{"name":"usize"}],"output":{"generics":["normalized"],"name":"option"}}],[5,"prune_cache_value_obligations","","If there are unresolved type variables, then we need to include any subobligations that bind them, at least until those type variables are fully resolved.",null,{"inputs":[{"name":"inferctxt"},{"name":"normalized"}],"output":{"generics":["ty"],"name":"normalized"}}],[5,"push_paranoid_cache_value_obligation","","Whenever we give back a cache result for a projection like `<T as Trait>::Item ==> X`, we always include the obligation to prove that `T: Trait` (we may also include some other obligations). This may or may not be necessary -- in principle, all the obligations that must be proven to show that `T: Trait` were also returned when the cache was first populated. But there are some vague concerns, and so we take the precatuionary measure of including `T: Trait` in the result:",null,{"inputs":[{"name":"inferctxt"},{"name":"paramenv"},{"name":"projectionty"},{"name":"obligationcause"},{"name":"usize"},{"name":"normalized"}],"output":null}],[5,"normalize_to_error","","If we are projecting `<T as Trait>::Item`, but `T: Trait` does not hold. In various error cases, we cannot generate a valid normalized projection. Therefore, we create an inference variable return an associated obligation that, when fulfilled, will lead to an error.",null,{"inputs":[{"name":"selectioncontext"},{"name":"paramenv"},{"name":"projectionty"},{"name":"obligationcause"},{"name":"usize"}],"output":{"generics":["ty"],"name":"normalized"}}],[5,"project_type","","Compute the result of a projection type (if we can).",null,{"inputs":[{"name":"selectioncontext"},{"name":"obligation"}],"output":{"generics":["projectedty","projectiontyerror"],"name":"result"}}],[5,"assemble_candidates_from_param_env","","The first thing we have to do is scan through the parameter environment to see whether there are any projection predicates there that can answer this question.",null,{"inputs":[{"name":"selectioncontext"},{"name":"obligation"},{"name":"traitref"},{"name":"projectiontycandidateset"}],"output":null}],[5,"assemble_candidates_from_trait_def","","In the case of a nested projection like <::FooT as Bar>::BarT, we may find that the definition of `Foo` has some clues:",null,{"inputs":[{"name":"selectioncontext"},{"name":"obligation"},{"name":"traitref"},{"name":"projectiontycandidateset"}],"output":null}],[5,"assemble_candidates_from_predicates","","",null,null],[5,"assemble_candidates_from_impls","","",null,{"inputs":[{"name":"selectioncontext"},{"name":"obligation"},{"name":"traitref"},{"name":"projectiontycandidateset"}],"output":null}],[5,"confirm_candidate","","",null,{"inputs":[{"name":"selectioncontext"},{"name":"obligation"},{"name":"traitref"},{"name":"projectiontycandidate"}],"output":{"name":"progress"}}],[5,"confirm_select_candidate","","",null,{"inputs":[{"name":"selectioncontext"},{"name":"obligation"},{"name":"traitref"},{"name":"selection"}],"output":{"name":"progress"}}],[5,"confirm_object_candidate","","",null,{"inputs":[{"name":"selectioncontext"},{"name":"obligation"},{"name":"traitref"}],"output":{"name":"progress"}}],[5,"confirm_generator_candidate","","",null,{"inputs":[{"name":"selectioncontext"},{"name":"obligation"},{"generics":["predicateobligation"],"name":"vtablegeneratordata"}],"output":{"name":"progress"}}],[5,"confirm_fn_pointer_candidate","","",null,{"inputs":[{"name":"selectioncontext"},{"name":"obligation"},{"generics":["predicateobligation"],"name":"vtablefnpointerdata"}],"output":{"name":"progress"}}],[5,"confirm_closure_candidate","","",null,{"inputs":[{"name":"selectioncontext"},{"name":"obligation"},{"generics":["predicateobligation"],"name":"vtableclosuredata"}],"output":{"name":"progress"}}],[5,"confirm_callable_candidate","","",null,{"inputs":[{"name":"selectioncontext"},{"name":"obligation"},{"name":"polyfnsig"},{"name":"tupleargumentsflag"}],"output":{"name":"progress"}}],[5,"confirm_param_env_candidate","","",null,{"inputs":[{"name":"selectioncontext"},{"name":"obligation"},{"name":"polyprojectionpredicate"}],"output":{"name":"progress"}}],[5,"confirm_impl_candidate","","",null,{"inputs":[{"name":"selectioncontext"},{"name":"obligation"},{"generics":["predicateobligation"],"name":"vtableimpldata"}],"output":{"name":"progress"}}],[5,"assoc_ty_def","","Locate the definition of an associated type in the specialization hierarchy, starting from the given impl.",null,{"inputs":[{"name":"selectioncontext"},{"name":"defid"},{"name":"defid"}],"output":{"generics":["associateditem"],"name":"nodeitem"}}],[6,"PolyProjectionObligation","","",null,null],[6,"ProjectionObligation","","",null,null],[6,"ProjectionTyObligation","","",null,null],[6,"NormalizedTy","","",null,null],[11,"fmt","rustc::traits","",578,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",578,{"inputs":[{"name":"self"}],"output":{"name":"reveal"}}],[11,"eq","","",578,{"inputs":[{"name":"self"},{"name":"reveal"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",578,null],[11,"hash","","",578,null],[11,"fmt","rustc::traits::project","",606,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","rustc::traits","",553,{"inputs":[{"name":"self"}],"output":{"name":"mismatchedprojectiontypes"}}],[11,"eq","rustc::traits::project","",607,{"inputs":[{"name":"self"},{"name":"projectiontycandidate"}],"output":{"name":"bool"}}],[11,"ne","","",607,{"inputs":[{"name":"self"},{"name":"projectiontycandidate"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",607,null],[11,"fmt","","",607,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"mark_ambiguous","","",608,{"inputs":[{"name":"self"}],"output":null}],[11,"mark_error","","",608,{"inputs":[{"name":"self"},{"name":"selectionerror"}],"output":null}],[11,"push_candidate","","",608,{"inputs":[{"name":"self"},{"name":"projectiontycandidate"}],"output":{"name":"bool"}}],[11,"new","","",603,{"inputs":[{"name":"selectioncontext"},{"name":"paramenv"},{"name":"obligationcause"},{"name":"usize"}],"output":{"name":"associatedtypenormalizer"}}],[11,"fold","","",603,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"name":"t"}}],[11,"tcx","","",603,{"inputs":[{"name":"self"}],"output":{"name":"tyctxt"}}],[11,"fold_ty","","",603,{"inputs":[{"name":"self"},{"name":"ty"}],"output":{"name":"ty"}}],[11,"fold_const","","",603,{"inputs":[{"name":"self"},{"name":"const"}],"output":{"name":"const"}}],[11,"clone","rustc::traits","",556,{"inputs":[{"name":"self"}],"output":{"name":"normalized"}}],[11,"with","","",556,{"inputs":[{"name":"self"},{"name":"u"}],"output":{"name":"normalized"}}],[11,"error","rustc::traits::project","",604,{"inputs":[{"name":"tyctxt"}],"output":{"name":"self"}}],[11,"with_addl_obligations","","",604,{"inputs":[{"name":"self"},{"generics":["predicateobligation"],"name":"vec"}],"output":{"name":"self"}}],[11,"clone","","",605,{"inputs":[{"name":"self"}],"output":{"name":"projectioncachekey"}}],[11,"fmt","","",605,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",605,null],[11,"eq","","",605,{"inputs":[{"name":"self"},{"name":"projectioncachekey"}],"output":{"name":"bool"}}],[11,"ne","","",605,{"inputs":[{"name":"self"},{"name":"projectioncachekey"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",605,null],[11,"from_poly_projection_predicate","","",605,{"inputs":[{"name":"selectioncontext"},{"name":"polyprojectionpredicate"}],"output":{"name":"option"}}],[11,"clone","","",610,{"inputs":[{"name":"self"}],"output":{"name":"projectioncacheentry"}}],[11,"fmt","","",610,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"new","rustc::traits","",554,{"inputs":[],"output":{"name":"self"}}],[11,"clear","","",554,{"inputs":[{"name":"self"}],"output":null}],[11,"snapshot","","",554,{"inputs":[{"name":"self"}],"output":{"name":"projectioncachesnapshot"}}],[11,"rollback_to","","",554,{"inputs":[{"name":"self"},{"name":"projectioncachesnapshot"}],"output":null}],[11,"rollback_skolemized","","",554,{"inputs":[{"name":"self"},{"name":"projectioncachesnapshot"}],"output":null}],[11,"commit","","",554,{"inputs":[{"name":"self"},{"name":"projectioncachesnapshot"}],"output":null}],[11,"try_start","","Try to start normalize `key`; returns an error if normalization already occurred (this error corresponds to a cache hit, so it's actually a good thing).",554,{"inputs":[{"name":"self"},{"name":"projectioncachekey"}],"output":{"generics":["projectioncacheentry"],"name":"result"}}],[11,"insert_ty","","Indicates that `key` was normalized to `value`.",554,{"inputs":[{"name":"self"},{"name":"projectioncachekey"},{"generics":["ty"],"name":"normalized"}],"output":null}],[11,"complete","","Mark the relevant projection cache key as having its derived obligations complete, so they won't have to be re-computed (this is OK to do in a snapshot - if the snapshot is rolled back, the obligations will be marked as incomplete again).",554,{"inputs":[{"name":"self"},{"name":"projectioncachekey"}],"output":null}],[11,"ambiguous","","Indicates that trying to normalize `key` resulted in ambiguity. No point in trying it again then until we gain more type information (in which case, the \"fully resolved\" key will be different).",554,{"inputs":[{"name":"self"},{"name":"projectioncachekey"}],"output":null}],[11,"error","","Indicates that trying to normalize `key` resulted in error.",554,{"inputs":[{"name":"self"},{"name":"projectioncachekey"}],"output":null}],[0,"object_safety","","\"Object safety\" refers to the ability for a trait to be converted to an object. In general, traits may only be converted to an object if all of their methods meet certain criteria. In particular, they must:",null,null],[4,"ObjectSafetyViolation","rustc::traits::object_safety","",null,null],[13,"SizedSelf","","Self : Sized declared on the trait",579,null],[13,"SupertraitSelf","","Supertrait reference references `Self` an in illegal location (e.g. `trait Foo : Bar<Self>`)",579,null],[13,"Method","","Method has something illegal",579,null],[13,"AssociatedConst","","Associated const",579,null],[4,"MethodViolationCode","","Reasons a method might not be object-safe.",null,null],[13,"StaticMethod","","e.g., `fn foo()`",580,null],[13,"ReferencesSelf","","e.g., `fn foo(&self, x: Self)` or `fn foo(&self) -> Self`",580,null],[13,"Generic","","e.g., `fn foo<A>()`",580,null],[13,"NonStandardSelfType","","arbitrary `self` type, e.g. `self: Rc<Self>`",580,null],[5,"is_object_safe_provider","","",null,{"inputs":[{"name":"tyctxt"},{"name":"defid"}],"output":{"name":"bool"}}],[11,"clone","rustc::traits","",579,{"inputs":[{"name":"self"}],"output":{"name":"objectsafetyviolation"}}],[11,"fmt","","",579,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",579,{"inputs":[{"name":"self"},{"name":"objectsafetyviolation"}],"output":{"name":"bool"}}],[11,"ne","","",579,{"inputs":[{"name":"self"},{"name":"objectsafetyviolation"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",579,null],[11,"hash","","",579,null],[11,"error_msg","","",579,{"inputs":[{"name":"self"}],"output":{"generics":["str"],"name":"cow"}}],[11,"clone","","",580,{"inputs":[{"name":"self"}],"output":{"name":"methodviolationcode"}}],[11,"fmt","","",580,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",580,{"inputs":[{"name":"self"},{"name":"methodviolationcode"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",580,null],[11,"hash","","",580,null],[0,"on_unimplemented","","",null,null],[3,"OnUnimplementedFormatString","rustc::traits::on_unimplemented","",null,null],[12,"0","","",611,null],[3,"OnUnimplementedDirective","","",null,null],[12,"condition","","",557,null],[12,"subcommands","","",557,null],[12,"message","","",557,null],[12,"label","","",557,null],[12,"note","","",557,null],[3,"OnUnimplementedNote","","",null,null],[12,"message","","",558,null],[12,"label","","",558,null],[12,"note","","",558,null],[5,"parse_error","","",null,{"inputs":[{"name":"tyctxt"},{"name":"span"},{"name":"str"},{"name":"str"},{"generics":["str"],"name":"option"}],"output":{"name":"errorreported"}}],[11,"clone","","",611,{"inputs":[{"name":"self"}],"output":{"name":"onunimplementedformatstring"}}],[11,"fmt","","",611,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","rustc::traits","",557,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"empty","","",558,{"inputs":[],"output":{"name":"self"}}],[11,"parse","","",557,null],[11,"of_item","","",557,{"inputs":[{"name":"tyctxt"},{"name":"defid"},{"name":"defid"}],"output":{"generics":["option","errorreported"],"name":"result"}}],[11,"evaluate","","",557,null],[11,"try_parse","rustc::traits::on_unimplemented","",611,{"inputs":[{"name":"tyctxt"},{"name":"defid"},{"name":"localinternedstring"},{"name":"span"}],"output":{"generics":["errorreported"],"name":"result"}}],[11,"verify","","",611,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"defid"},{"name":"span"}],"output":{"generics":["errorreported"],"name":"result"}}],[11,"format","","",611,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"traitref"}],"output":{"name":"string"}}],[0,"select","rustc::traits","See [rustc guide] for more info on how this works.",null,null],[3,"SelectionContext","rustc::traits::select","",null,null],[12,"infcx","","",560,null],[12,"freshener","","Freshener used specifically for skolemizing entries on the obligation stack. This ensures that all entries on the stack at one time will have the same set of skolemized entries, which is important for checking for trait bounds that recursively require themselves.",560,null],[12,"intercrate","","If true, indicates that the evaluation should be conservative and consider the possibility of types outside this crate. This comes up primarily when resolving ambiguity. Imagine there is some trait reference `$0 : Bar` where `$0` is an inference variable. If `intercrate` is true, then we can never say for sure that this reference is not implemented, even if there are no impls at all for `Bar`, because `$0` could be bound to some type that in a downstream crate that implements `Bar`. This is the suitable mode for coherence. Elsewhere, though, we set this to false, because we are only interested in types that the user could actually have written --- in other words, we consider `$0 : Bar` to be unimplemented if there is no type that the user could actually name that would satisfy it. This avoids crippling inference, basically.",560,null],[12,"intercrate_ambiguity_causes","","",560,null],[12,"allow_negative_impls","","Controls whether or not to filter out negative impls when selecting. This is used in librustdoc to distinguish between the lack of an impl and a negative impl",560,null],[12,"query_mode","","The mode that trait queries run in, which informs our error handling policy. In essence, canonicalized queries need their errors propagated rather than immediately reported because we do not have accurate spans.",560,null],[3,"TraitObligationStack","","",null,null],[12,"obligation","","",612,null],[12,"fresh_trait_ref","","Trait ref from `obligation` but skolemized with the selection-context's freshener. Used to check for recursion.",612,null],[12,"previous","","",612,null],[3,"SelectionCache","","",null,null],[12,"hashmap","","",561,null],[3,"SelectionCandidateSet","","",null,null],[12,"vec","","",613,null],[12,"ambiguous","","",613,null],[3,"EvaluatedCandidate","","",null,null],[12,"candidate","","",614,null],[12,"evaluation","","",614,null],[3,"OverflowError","","Indicates that trait evaluation caused overflow.",null,null],[3,"EvaluationCache","","",null,null],[12,"hashmap","","",559,null],[3,"TraitObligationStackList","","",null,null],[12,"head","","",615,null],[3,"WithDepNode","","",null,null],[12,"dep_node","","",616,null],[12,"cached_value","","",616,null],[4,"IntercrateAmbiguityCause","","",null,null],[13,"DownstreamCrate","","",582,null],[12,"trait_desc","rustc::traits::select::IntercrateAmbiguityCause","",582,null],[12,"self_desc","","",582,null],[13,"UpstreamCrateUpdate","rustc::traits::select","",582,null],[12,"trait_desc","rustc::traits::select::IntercrateAmbiguityCause","",582,null],[12,"self_desc","","",582,null],[4,"SelectionCandidate","rustc::traits::select","The selection process begins by considering all impls, where clauses, and so forth that might resolve an obligation.  Sometimes we'll be able to say definitively that (e.g.) an impl does not apply to the obligation: perhaps it is defined for `usize` but the obligation is for `int`. In that case, we drop the impl out of the list.  But the other cases are considered candidates.",null,null],[13,"BuiltinCandidate","","",617,null],[12,"has_nested","rustc::traits::select::SelectionCandidate","",617,null],[13,"ParamCandidate","rustc::traits::select","",617,null],[13,"ImplCandidate","","",617,null],[13,"AutoImplCandidate","","",617,null],[13,"ProjectionCandidate","","This is a trait matching with a projected type as `Self`, and we found an applicable bound in the trait definition.",617,null],[13,"ClosureCandidate","","Implementation of a `Fn`-family trait by one of the anonymous types generated for a `||` expression.",617,null],[13,"GeneratorCandidate","","Implementation of a `Generator` trait by one of the anonymous types generated for a generator.",617,null],[13,"FnPointerCandidate","","Implementation of a `Fn`-family trait by one of the anonymous types generated for a fn pointer type (e.g., `fn(int)->int`)",617,null],[13,"ObjectCandidate","","",617,null],[13,"BuiltinObjectCandidate","","",617,null],[13,"BuiltinUnsizeCandidate","","",617,null],[4,"BuiltinImplConditions","","When does the builtin impl for `T: Trait` apply?",null,null],[13,"Where","","The impl is conditional on T1,T2,.. : Trait",618,null],[13,"None","","There is no built-in impl. There may be some other candidate (a where-clause or user-defined impl).",618,null],[13,"Never","","There is no impl for this, builtin or not. Ignore all where-clauses.",618,null],[13,"Ambiguous","","It is unknown whether there is an impl.",618,null],[4,"EvaluationResult","","The result of trait evaluation. The order is important here as the evaluation of a list is the maximum of the evaluations.",null,null],[13,"EvaluatedToOk","","Evaluation successful",581,null],[13,"EvaluatedToAmbig","","Evaluation is known to be ambiguous - it might hold for some assignment of inference variables, but it might not.",581,null],[13,"EvaluatedToUnknown","","Evaluation failed because of recursion involving inference variables. We are somewhat imprecise there, so we don't actually know the real result.",581,null],[13,"EvaluatedToRecur","","Evaluation failed because we encountered an obligation we are already trying to prove on this branch.",581,null],[13,"EvaluatedToErr","","Evaluation failed",581,null],[11,"clone","rustc::traits","",582,{"inputs":[{"name":"self"}],"output":{"name":"intercrateambiguitycause"}}],[11,"fmt","","",582,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"add_intercrate_ambiguity_hint","","Emits notes when the overlap is caused by complex intercrate ambiguities. See #23980 for details.",582,{"inputs":[{"name":"self"},{"name":"diagnosticbuilder"}],"output":null}],[11,"intercrate_ambiguity_hint","","",582,{"inputs":[{"name":"self"}],"output":{"name":"string"}}],[11,"clone","","",561,{"inputs":[{"name":"self"}],"output":{"name":"selectioncache"}}],[11,"eq","rustc::traits::select","",617,{"inputs":[{"name":"self"},{"name":"selectioncandidate"}],"output":{"name":"bool"}}],[11,"ne","","",617,{"inputs":[{"name":"self"},{"name":"selectioncandidate"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",617,null],[11,"fmt","","",617,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",617,{"inputs":[{"name":"self"}],"output":{"name":"selectioncandidate"}}],[11,"lift_to_tcx","","",617,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"eq","","",614,{"inputs":[{"name":"self"},{"name":"evaluatedcandidate"}],"output":{"name":"bool"}}],[11,"ne","","",614,{"inputs":[{"name":"self"},{"name":"evaluatedcandidate"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",614,null],[11,"fmt","","",614,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",614,{"inputs":[{"name":"self"}],"output":{"name":"evaluatedcandidate"}}],[11,"clone","rustc::traits","",581,{"inputs":[{"name":"self"}],"output":{"name":"evaluationresult"}}],[11,"fmt","","",581,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"partial_cmp","","",581,{"inputs":[{"name":"self"},{"name":"evaluationresult"}],"output":{"generics":["ordering"],"name":"option"}}],[11,"cmp","","",581,{"inputs":[{"name":"self"},{"name":"evaluationresult"}],"output":{"name":"ordering"}}],[11,"eq","","",581,{"inputs":[{"name":"self"},{"name":"evaluationresult"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",581,null],[11,"may_apply","","",581,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_stack_dependent","","",581,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"hash_stable","","",581,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"clone","","",619,{"inputs":[{"name":"self"}],"output":{"name":"overflowerror"}}],[11,"fmt","","",619,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",619,{"inputs":[{"name":"self"},{"name":"overflowerror"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",619,null],[11,"hash_stable","","",619,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"from","","",591,{"inputs":[{"name":"overflowerror"}],"output":{"name":"selectionerror"}}],[11,"clone","","",559,{"inputs":[{"name":"self"}],"output":{"name":"evaluationcache"}}],[11,"new","","",560,{"inputs":[{"name":"inferctxt"}],"output":{"name":"selectioncontext"}}],[11,"intercrate","","",560,{"inputs":[{"name":"inferctxt"},{"name":"intercratemode"}],"output":{"name":"selectioncontext"}}],[11,"with_negative","","",560,{"inputs":[{"name":"inferctxt"},{"name":"bool"}],"output":{"name":"selectioncontext"}}],[11,"with_query_mode","","",560,{"inputs":[{"name":"inferctxt"},{"name":"traitquerymode"}],"output":{"name":"selectioncontext"}}],[11,"enable_tracking_intercrate_ambiguity_causes","","Enables tracking of intercrate ambiguity causes. These are used in coherence to give improved diagnostics. We don't do this until we detect a coherence error because it can lead to false overflow results (#47139) and because it costs computation time.",560,{"inputs":[{"name":"self"}],"output":null}],[11,"take_intercrate_ambiguity_causes","","Gets the intercrate ambiguity causes collected since tracking was enabled and disables tracking at the same time. If tracking is not enabled, just returns an empty vector.",560,{"inputs":[{"name":"self"}],"output":{"generics":["intercrateambiguitycause"],"name":"vec"}}],[11,"infcx","","",560,{"inputs":[{"name":"self"}],"output":{"name":"inferctxt"}}],[11,"tcx","","",560,{"inputs":[{"name":"self"}],"output":{"name":"tyctxt"}}],[11,"closure_typer","","",560,{"inputs":[{"name":"self"}],"output":{"name":"inferctxt"}}],[11,"in_snapshot","","Wraps the inference context's in_snapshot s.t. snapshot handling is only from the selection context's self.",560,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"r"}}],[11,"probe","","Wraps a probe s.t. obligations collected during it are ignored and old obligations are retained.",560,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"r"}}],[11,"commit_if_ok","","Wraps a commit_if_ok s.t. obligations collected during it are not returned in selection if the transaction fails and s.t. old obligations are retained.",560,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"result"}}],[11,"select","","Attempts to satisfy the obligation. If successful, this will affect the surrounding type environment by performing unification.",560,{"inputs":[{"name":"self"},{"name":"traitobligation"}],"output":{"generics":["selection"],"name":"selectionresult"}}],[11,"predicate_may_hold_fatal","","Evaluates whether the obligation `obligation` can be satisfied (by any means).",560,{"inputs":[{"name":"self"},{"name":"predicateobligation"}],"output":{"name":"bool"}}],[11,"evaluate_obligation_recursively","","Evaluates whether the obligation `obligation` can be satisfied and returns an `EvaluationResult`.",560,{"inputs":[{"name":"self"},{"name":"predicateobligation"}],"output":{"generics":["evaluationresult","overflowerror"],"name":"result"}}],[11,"evaluate_predicates_recursively","","Evaluates the predicates in `predicates` recursively. Note that this applies projections in the predicates, and therefore is run within an inference probe.",560,{"inputs":[{"name":"self"},{"name":"traitobligationstacklist"},{"name":"i"}],"output":{"generics":["evaluationresult","overflowerror"],"name":"result"}}],[11,"evaluate_predicate_recursively","","",560,{"inputs":[{"name":"self"},{"name":"traitobligationstacklist"},{"name":"predicateobligation"}],"output":{"generics":["evaluationresult","overflowerror"],"name":"result"}}],[11,"evaluate_trait_predicate_recursively","","",560,{"inputs":[{"name":"self"},{"name":"traitobligationstacklist"},{"name":"traitobligation"}],"output":{"generics":["evaluationresult","overflowerror"],"name":"result"}}],[11,"evaluate_stack","","",560,{"inputs":[{"name":"self"},{"name":"traitobligationstack"}],"output":{"generics":["evaluationresult","overflowerror"],"name":"result"}}],[11,"coinductive_match","","For defaulted traits, we use a co-inductive strategy to solve, so that recursion is ok. This routine returns true if the top of the stack (`cycle[0]`):",560,{"inputs":[{"name":"self"},{"name":"i"}],"output":{"name":"bool"}}],[11,"coinductive_predicate","","",560,{"inputs":[{"name":"self"},{"name":"predicate"}],"output":{"name":"bool"}}],[11,"evaluate_candidate","","Further evaluate `candidate` to decide whether all type parameters match and whether nested obligations are met. Returns true if `candidate` remains viable after this further scrutiny.",560,{"inputs":[{"name":"self"},{"name":"traitobligationstack"},{"name":"selectioncandidate"}],"output":{"generics":["evaluationresult","overflowerror"],"name":"result"}}],[11,"check_evaluation_cache","","",560,{"inputs":[{"name":"self"},{"name":"paramenv"},{"name":"polytraitref"}],"output":{"generics":["evaluationresult"],"name":"option"}}],[11,"insert_evaluation_cache","","",560,{"inputs":[{"name":"self"},{"name":"paramenv"},{"name":"polytraitref"},{"name":"depnodeindex"},{"name":"evaluationresult"}],"output":null}],[11,"candidate_from_obligation","","",560,{"inputs":[{"name":"self"},{"name":"traitobligationstack"}],"output":{"generics":["selectioncandidate"],"name":"selectionresult"}}],[11,"in_task","","",560,null],[11,"filter_negative_impls","","",560,{"inputs":[{"name":"self"},{"name":"selectioncandidate"}],"output":{"generics":["selectioncandidate"],"name":"selectionresult"}}],[11,"candidate_from_obligation_no_cache","","",560,{"inputs":[{"name":"self"},{"name":"traitobligationstack"}],"output":{"generics":["selectioncandidate"],"name":"selectionresult"}}],[11,"is_knowable","","",560,{"inputs":[{"name":"self"},{"name":"traitobligationstack"}],"output":{"generics":["conflict"],"name":"option"}}],[11,"can_use_global_caches","","Returns true if the global caches can be used. Do note that if the type itself is not in the global tcx, the local caches will be used.",560,{"inputs":[{"name":"self"},{"name":"paramenv"}],"output":{"name":"bool"}}],[11,"check_candidate_cache","","",560,{"inputs":[{"name":"self"},{"name":"paramenv"},{"name":"polytraitpredicate"}],"output":{"generics":["selectionresult"],"name":"option"}}],[11,"insert_candidate_cache","","",560,{"inputs":[{"name":"self"},{"name":"paramenv"},{"name":"polytraitpredicate"},{"name":"depnodeindex"},{"generics":["selectioncandidate"],"name":"selectionresult"}],"output":null}],[11,"assemble_candidates","","",560,{"inputs":[{"name":"self"},{"name":"traitobligationstack"}],"output":{"generics":["selectioncandidateset","selectionerror"],"name":"result"}}],[11,"assemble_candidates_from_projected_tys","","",560,{"inputs":[{"name":"self"},{"name":"traitobligation"},{"name":"selectioncandidateset"}],"output":null}],[11,"match_projection_obligation_against_definition_bounds","","",560,{"inputs":[{"name":"self"},{"name":"traitobligation"},{"name":"combinedsnapshot"}],"output":{"name":"bool"}}],[11,"match_projection","","",560,{"inputs":[{"name":"self"},{"name":"traitobligation"},{"name":"polytraitref"},{"name":"traitref"},{"name":"skolemizationmap"},{"name":"combinedsnapshot"}],"output":{"name":"bool"}}],[11,"assemble_candidates_from_caller_bounds","","Given an obligation like `<SomeTrait for T>`, search the obligations that the caller supplied to find out whether it is listed among them.",560,{"inputs":[{"name":"self"},{"name":"traitobligationstack"},{"name":"selectioncandidateset"}],"output":{"generics":["selectionerror"],"name":"result"}}],[11,"evaluate_where_clause","","",560,{"inputs":[{"name":"self"},{"name":"traitobligationstack"},{"name":"polytraitref"}],"output":{"generics":["evaluationresult","overflowerror"],"name":"result"}}],[11,"assemble_generator_candidates","","",560,{"inputs":[{"name":"self"},{"name":"traitobligation"},{"name":"selectioncandidateset"}],"output":{"generics":["selectionerror"],"name":"result"}}],[11,"assemble_closure_candidates","","Check for the artificial impl that the compiler will create for an obligation like `X : FnMut<..>` where `X` is a closure type.",560,{"inputs":[{"name":"self"},{"name":"traitobligation"},{"name":"selectioncandidateset"}],"output":{"generics":["selectionerror"],"name":"result"}}],[11,"assemble_fn_pointer_candidates","","Implement one of the `Fn()` family for a fn pointer.",560,{"inputs":[{"name":"self"},{"name":"traitobligation"},{"name":"selectioncandidateset"}],"output":{"generics":["selectionerror"],"name":"result"}}],[11,"assemble_candidates_from_impls","","Search for impls that might apply to `obligation`.",560,{"inputs":[{"name":"self"},{"name":"traitobligation"},{"name":"selectioncandidateset"}],"output":{"generics":["selectionerror"],"name":"result"}}],[11,"assemble_candidates_from_auto_impls","","",560,{"inputs":[{"name":"self"},{"name":"traitobligation"},{"name":"selectioncandidateset"}],"output":{"generics":["selectionerror"],"name":"result"}}],[11,"assemble_candidates_from_object_ty","","Search for impls that might apply to `obligation`.",560,{"inputs":[{"name":"self"},{"name":"traitobligation"},{"name":"selectioncandidateset"}],"output":null}],[11,"assemble_candidates_for_unsizing","","Search for unsizing that might apply to `obligation`.",560,{"inputs":[{"name":"self"},{"name":"traitobligation"},{"name":"selectioncandidateset"}],"output":null}],[11,"candidate_should_be_dropped_in_favor_of","","Returns true if `candidate_i` should be dropped in favor of `candidate_j`.  Generally speaking we will drop duplicate candidates and prefer where-clause candidates. Returns true if `victim` should be dropped in favor of `other`.  Generally speaking we will drop duplicate candidates and prefer where-clause candidates.",560,{"inputs":[{"name":"self"},{"name":"evaluatedcandidate"},{"name":"evaluatedcandidate"}],"output":{"name":"bool"}}],[11,"assemble_builtin_bound_candidates","","",560,{"inputs":[{"name":"self"},{"name":"builtinimplconditions"},{"name":"selectioncandidateset"}],"output":{"generics":["selectionerror"],"name":"result"}}],[11,"sized_conditions","","",560,{"inputs":[{"name":"self"},{"name":"traitobligation"}],"output":{"name":"builtinimplconditions"}}],[11,"copy_clone_conditions","","",560,{"inputs":[{"name":"self"},{"name":"traitobligation"}],"output":{"name":"builtinimplconditions"}}],[11,"constituent_types_for_ty","","For default impls, we need to break apart a type into its \"constituent types\" -- meaning, the types that it contains.",560,{"inputs":[{"name":"self"},{"name":"ty"}],"output":{"generics":["ty"],"name":"vec"}}],[11,"collect_predicates_for_types","","",560,{"inputs":[{"name":"self"},{"name":"paramenv"},{"name":"obligationcause"},{"name":"usize"},{"name":"defid"},{"generics":["vec"],"name":"binder"}],"output":{"generics":["predicateobligation"],"name":"vec"}}],[11,"confirm_candidate","","",560,{"inputs":[{"name":"self"},{"name":"traitobligation"},{"name":"selectioncandidate"}],"output":{"generics":["selection","selectionerror"],"name":"result"}}],[11,"confirm_projection_candidate","","",560,{"inputs":[{"name":"self"},{"name":"traitobligation"}],"output":null}],[11,"confirm_param_candidate","","",560,{"inputs":[{"name":"self"},{"name":"traitobligation"},{"name":"polytraitref"}],"output":{"generics":["predicateobligation"],"name":"vec"}}],[11,"confirm_builtin_candidate","","",560,{"inputs":[{"name":"self"},{"name":"traitobligation"},{"name":"bool"}],"output":{"generics":["predicateobligation"],"name":"vtablebuiltindata"}}],[11,"confirm_auto_impl_candidate","","This handles the case where a `auto trait Foo` impl is being used. The idea is that the impl applies to `X : Foo` if the following conditions are met:",560,{"inputs":[{"name":"self"},{"name":"traitobligation"},{"name":"defid"}],"output":{"generics":["predicateobligation"],"name":"vtableautoimpldata"}}],[11,"vtable_auto_impl","","See `confirm_auto_impl_candidate`",560,{"inputs":[{"name":"self"},{"name":"traitobligation"},{"name":"defid"},{"generics":["vec"],"name":"binder"}],"output":{"generics":["predicateobligation"],"name":"vtableautoimpldata"}}],[11,"confirm_impl_candidate","","",560,{"inputs":[{"name":"self"},{"name":"traitobligation"},{"name":"defid"}],"output":{"generics":["predicateobligation"],"name":"vtableimpldata"}}],[11,"vtable_impl","","",560,{"inputs":[{"name":"self"},{"name":"defid"},{"generics":["substs"],"name":"normalized"},{"name":"obligationcause"},{"name":"usize"},{"name":"paramenv"},{"name":"skolemizationmap"},{"name":"combinedsnapshot"}],"output":{"generics":["predicateobligation"],"name":"vtableimpldata"}}],[11,"confirm_object_candidate","","",560,{"inputs":[{"name":"self"},{"name":"traitobligation"}],"output":{"generics":["predicateobligation"],"name":"vtableobjectdata"}}],[11,"confirm_fn_pointer_candidate","","",560,{"inputs":[{"name":"self"},{"name":"traitobligation"}],"output":{"generics":["vtablefnpointerdata","selectionerror"],"name":"result"}}],[11,"confirm_generator_candidate","","",560,{"inputs":[{"name":"self"},{"name":"traitobligation"}],"output":{"generics":["vtablegeneratordata","selectionerror"],"name":"result"}}],[11,"confirm_closure_candidate","","",560,{"inputs":[{"name":"self"},{"name":"traitobligation"}],"output":{"generics":["vtableclosuredata","selectionerror"],"name":"result"}}],[11,"confirm_poly_trait_refs","","In the case of closure types and fn pointers, we currently treat the input type parameters on the trait as outputs. This means that when we have a match we have only considered the self type, so we have to go back and make sure to relate the argument types too.  This is kind of wrong, but since we control the full set of impls, also not that wrong, and it DOES yield better error messages (since we don't report errors as if there is no applicable impl, but rather report errors are about mismatched argument types.",560,{"inputs":[{"name":"self"},{"name":"obligationcause"},{"name":"paramenv"},{"name":"polytraitref"},{"name":"polytraitref"}],"output":{"generics":["vec","selectionerror"],"name":"result"}}],[11,"confirm_builtin_unsize_candidate","","",560,{"inputs":[{"name":"self"},{"name":"traitobligation"}],"output":{"generics":["vtablebuiltindata","selectionerror"],"name":"result"}}],[11,"rematch_impl","","",560,null],[11,"match_impl","","",560,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"traitobligation"},{"name":"combinedsnapshot"}],"output":{"name":"result"}}],[11,"fast_reject_trait_refs","","",560,{"inputs":[{"name":"self"},{"name":"traitobligation"},{"name":"traitref"}],"output":{"name":"bool"}}],[11,"match_where_clause_trait_ref","","Normalize `where_clause_trait_ref` and try to match it against `obligation`.  If successful, return any predicates that result from the normalization. Normalization is necessary because where-clauses are stored in the parameter environment unnormalized.",560,{"inputs":[{"name":"self"},{"name":"traitobligation"},{"name":"polytraitref"}],"output":{"generics":["vec"],"name":"result"}}],[11,"match_poly_trait_ref","","Returns `Ok` if `poly_trait_ref` being true implies that the obligation is satisfied.",560,{"inputs":[{"name":"self"},{"name":"traitobligation"},{"name":"polytraitref"}],"output":{"generics":["vec"],"name":"result"}}],[11,"match_fresh_trait_refs","","",560,{"inputs":[{"name":"self"},{"name":"polytraitref"},{"name":"polytraitref"}],"output":{"name":"bool"}}],[11,"push_stack","","",560,{"inputs":[{"name":"self"},{"name":"traitobligationstacklist"},{"name":"traitobligation"}],"output":{"name":"traitobligationstack"}}],[11,"closure_trait_ref_unnormalized","","",560,{"inputs":[{"name":"self"},{"name":"traitobligation"},{"name":"defid"},{"name":"closuresubsts"}],"output":{"name":"polytraitref"}}],[11,"generator_trait_ref_unnormalized","","",560,{"inputs":[{"name":"self"},{"name":"traitobligation"},{"name":"defid"},{"name":"closuresubsts"}],"output":{"name":"polytraitref"}}],[11,"impl_or_trait_obligations","","Returns the obligations that are implied by instantiating an impl or trait. The obligations are substituted and fully normalized. This is used when confirming an impl or default impl.",560,{"inputs":[{"name":"self"},{"name":"obligationcause"},{"name":"usize"},{"name":"paramenv"},{"name":"defid"},{"name":"substs"},{"name":"skolemizationmap"},{"name":"combinedsnapshot"}],"output":{"generics":["predicateobligation"],"name":"vec"}}],[11,"new","","",561,{"inputs":[],"output":{"name":"selectioncache"}}],[11,"clear","","",561,{"inputs":[{"name":"self"}],"output":null}],[11,"new","","",559,{"inputs":[],"output":{"name":"evaluationcache"}}],[11,"clear","","",559,{"inputs":[{"name":"self"}],"output":null}],[11,"list","rustc::traits::select","",612,{"inputs":[{"name":"self"}],"output":{"name":"traitobligationstacklist"}}],[11,"iter","","",612,{"inputs":[{"name":"self"}],"output":{"name":"traitobligationstacklist"}}],[11,"clone","","",615,{"inputs":[{"name":"self"}],"output":{"name":"traitobligationstacklist"}}],[11,"empty","","",615,{"inputs":[],"output":{"name":"traitobligationstacklist"}}],[11,"with","","",615,{"inputs":[{"name":"traitobligationstack"}],"output":{"name":"traitobligationstacklist"}}],[11,"next","","",615,{"inputs":[{"name":"self"}],"output":{"generics":["traitobligationstack"],"name":"option"}}],[11,"fmt","","",612,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",616,{"inputs":[{"name":"self"}],"output":{"name":"withdepnode"}}],[11,"new","","",616,{"inputs":[{"name":"depnodeindex"},{"name":"t"}],"output":{"name":"self"}}],[11,"get","","",616,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"t"}}],[0,"specialize","rustc::traits","Logic and data structures related to impl specialization, explained in greater detail below.",null,null],[3,"OverlapError","rustc::traits::specialize","Information pertinent to an overlapping impl error.",null,null],[12,"with_impl","","",562,null],[12,"trait_desc","","",562,null],[12,"self_desc","","",562,null],[12,"intercrate_ambiguity_causes","","",562,null],[3,"SpecializesCache","","",null,null],[12,"map","","",563,null],[5,"translate_substs","","Given a subst for the requested impl, translate it to a subst appropriate for the actual item definition (whether it be in that impl, a parent impl, or the trait).",null,{"inputs":[{"name":"inferctxt"},{"name":"paramenv"},{"name":"defid"},{"name":"substs"},{"name":"node"}],"output":{"name":"substs"}}],[5,"find_associated_item","","Given a selected impl described by `impl_data`, returns the definition and substitutions for the method with the name `name` the kind `kind`, and trait method substitutions `substs`, in that impl, a less specialized impl, or the trait default, whichever applies.",null,null],[5,"specializes","","Is impl1 a specialization of impl2?",null,null],[5,"fulfill_implication","","Attempt to fulfill all obligations of `target_impl` after unification with `source_trait_ref`. If successful, returns a substitution for all the generics of `target_impl`, including both those needed to unify with `source_trait_ref` and those whose identity is determined via a where clause in the impl.",null,{"inputs":[{"name":"inferctxt"},{"name":"paramenv"},{"name":"traitref"},{"name":"defid"}],"output":{"generics":["substs"],"name":"result"}}],[5,"specialization_graph_provider","","",null,{"inputs":[{"name":"tyctxt"},{"name":"defid"}],"output":{"generics":["graph"],"name":"lrc"}}],[5,"to_pretty_impl_header","","Recovers the \"impl X for Y\" signature from `impl_def_id` and returns it as a string.",null,{"inputs":[{"name":"tyctxt"},{"name":"defid"}],"output":{"generics":["string"],"name":"option"}}],[0,"specialization_graph","","",null,null],[3,"Graph","rustc::traits::specialize::specialization_graph","A per-trait graph of impls in specialization order. At the moment, this graph forms a tree rooted with the trait itself, with all other nodes representing impls, and parent-child relationships representing specializations.",null,null],[12,"parent","","",594,null],[12,"children","","",594,null],[3,"Children","","Children of a given impl, grouped into blanket/non-blanket varieties as is done in `TraitDef`.",null,null],[12,"nonblanket_impls","","Impls of the trait.",620,null],[12,"blanket_impls","","Blanket impls associated with the trait.",620,null],[3,"Ancestors","","",null,null],[12,"trait_def_id","","",595,null],[12,"specialization_graph","","",595,null],[12,"current_source","","",595,null],[3,"NodeItem","","",null,null],[12,"node","","",596,null],[12,"item","","",596,null],[4,"Inserted","","The result of attempting to insert an impl into a group of children.",null,null],[13,"BecameNewSibling","","The impl was inserted as a new child in this group of children.",621,null],[13,"Replaced","","The impl replaced an existing impl that specializes it.",621,null],[13,"ShouldRecurseOn","","The impl is a specialization of an existing child.",621,null],[4,"Node","","A node in the specialization graph is either an impl or a trait definition; either can serve as a source of item definitions. There is always exactly one trait definition node: the root.",null,null],[13,"Impl","","",597,null],[13,"Trait","","",597,null],[5,"ancestors","","Walk up the specialization ancestors of a given impl, starting with that impl itself.",null,{"inputs":[{"name":"tyctxt"},{"name":"defid"},{"name":"defid"}],"output":{"name":"ancestors"}}],[11,"encode","rustc::traits::specialization_graph","",594,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",594,{"inputs":[{"name":"__d"}],"output":{"generics":["graph"],"name":"result"}}],[11,"encode","rustc::traits::specialize::specialization_graph","",620,{"inputs":[{"name":"self"},{"name":"__s"}],"output":{"name":"result"}}],[11,"decode","","",620,{"inputs":[{"name":"__d"}],"output":{"generics":["children"],"name":"result"}}],[11,"new","","",620,{"inputs":[],"output":{"name":"children"}}],[11,"insert_blindly","","Insert an impl into this set of children without comparing to any existing impls",620,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"defid"}],"output":null}],[11,"insert","","Attempt to insert an impl into this set of children, while comparing for specialization relationships.",620,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"defid"},{"generics":["simplifiedtype"],"name":"option"}],"output":{"generics":["inserted","overlaperror"],"name":"result"}}],[11,"iter_mut","","",620,{"inputs":[{"name":"self"}],"output":{"generics":["iterator"],"name":"box"}}],[11,"filtered_mut","","",620,{"inputs":[{"name":"self"},{"name":"simplifiedtype"}],"output":{"generics":["iterator"],"name":"box"}}],[11,"new","rustc::traits::specialization_graph","",594,{"inputs":[],"output":{"name":"graph"}}],[11,"insert","","Insert a local impl into the specialization graph. If an existing impl conflicts with it (has overlap, but neither specializes the other), information about the area of overlap is returned in the `Err`.",594,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"defid"}],"output":{"generics":["option","overlaperror"],"name":"result"}}],[11,"record_impl_from_cstore","","Insert cached metadata mapping from a child impl back to its parent.",594,{"inputs":[{"name":"self"},{"name":"tyctxt"},{"name":"defid"},{"name":"defid"}],"output":null}],[11,"parent","","The parent of a given impl, which is the def id of the trait when the impl is a \"specialization root\".",594,{"inputs":[{"name":"self"},{"name":"defid"}],"output":{"name":"defid"}}],[11,"fmt","","",597,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",597,{"inputs":[{"name":"self"}],"output":{"name":"node"}}],[11,"is_from_trait","","",597,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"items","","Iterate over the items defined directly by the given (impl or trait) node.",597,null],[11,"def_id","","",597,{"inputs":[{"name":"self"}],"output":{"name":"defid"}}],[11,"next","","",595,{"inputs":[{"name":"self"}],"output":{"generics":["node"],"name":"option"}}],[11,"map","","",596,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"nodeitem"}}],[11,"defs","","Search the items from the given ancestors, returning each definition with the given name and the given kind.",595,null],[11,"hash_stable","rustc::traits::specialize::specialization_graph","",620,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"hash_stable","rustc::traits::specialization_graph","",594,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"new","rustc::traits","",563,{"inputs":[],"output":{"name":"self"}}],[11,"check","","",563,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"defid"}],"output":{"generics":["bool"],"name":"option"}}],[11,"insert","","",563,{"inputs":[{"name":"self"},{"name":"defid"},{"name":"defid"},{"name":"bool"}],"output":null}],[0,"structural_impls","","",null,null],[11,"fmt","","",556,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",565,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",593,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",570,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",571,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",572,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",574,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",573,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",575,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",576,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",569,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",592,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",553,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"lift_to_tcx","","",591,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","","",585,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","","",567,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","","",566,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"lift_to_tcx","","",593,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"option"}}],[11,"super_fold_with","","",565,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"self"}}],[11,"super_visit_with","","",565,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",570,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",570,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",571,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",571,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",572,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",572,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",573,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",573,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",574,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",574,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",575,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",575,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",576,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",576,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",593,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",593,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",556,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",556,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"fmt","","",586,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",587,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",588,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",589,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",568,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",590,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"super_fold_with","","",586,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",586,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",587,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",587,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",588,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"quantifierkind"}}],[11,"super_visit_with","","",588,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",589,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",589,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",568,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",568,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"super_fold_with","","",590,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",590,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[0,"trans","","",null,null],[3,"TraitSelectionCache","rustc::traits::trans","",null,null],[12,"data","","",622,null],[3,"ProjectionCache","","",null,null],[12,"data","","",623,null],[5,"trans_fulfill_obligation","","Attempts to resolve an obligation to a vtable.. The result is a shallow vtable resolution -- meaning that we do not (necessarily) resolve all nested obligations on the impl. Note that type check should guarantee to us that all nested obligations could be resolved if we wanted to. Assumes that this is run after the entire crate has been successfully type-checked.",null,null],[11,"to_dep_kind","","",622,{"inputs":[],"output":{"name":"depkind"}}],[11,"to_dep_kind","","",623,{"inputs":[],"output":{"name":"depkind"}}],[11,"drain_fulfillment_cx_or_panic","rustc::infer","Finishes processes any obligations that remain in the fulfillment context, and then returns the result with all type variables removed and regions erased. Because this is intended for use after type-check has completed, if any errors occur, it will panic. It is used during normalization and other cases where processing the obligations in `fulfill_cx` may cause type inference variables that appear in `result` to be unified, and hence we need to process those obligations to get the complete picture of the type.",203,null],[0,"util","rustc::traits","",null,null],[3,"PredicateSet","rustc::traits::util","",null,null],[12,"tcx","","",624,null],[12,"set","","",624,null],[3,"Elaborator","","\"Elaboration\" is the process of identifying all the predicates that are implied by a source predicate. Currently this basically means walking the \"supertraits\" and other similar assumptions. For example, if we know that `T : Ord`, the elaborator would deduce that `T : PartialOrd` holds as well. Similarly, if we have `trait Foo : 'static`, and we know that `T : Foo`, then we know that `T : 'static`.",null,null],[12,"stack","","",625,null],[12,"visited","","",625,null],[3,"SupertraitDefIds","","",null,null],[12,"tcx","","",564,null],[12,"stack","","",564,null],[12,"visited","","",564,null],[3,"FilterToTraits","","A filter around an iterator of predicates that makes it yield up just trait references.",null,null],[12,"base_iterator","","",626,null],[4,"TupleArgumentsFlag","","",null,null],[13,"Yes","","",627,null],[13,"No","","",627,null],[5,"anonymize_predicate","","",null,{"inputs":[{"name":"tyctxt"},{"name":"predicate"}],"output":{"name":"predicate"}}],[5,"elaborate_trait_ref","","",null,{"inputs":[{"name":"tyctxt"},{"name":"polytraitref"}],"output":{"name":"elaborator"}}],[5,"elaborate_trait_refs","","",null,null],[5,"elaborate_predicates","","",null,{"inputs":[{"name":"tyctxt"},{"generics":["predicate"],"name":"vec"}],"output":{"name":"elaborator"}}],[5,"supertraits","","",null,{"inputs":[{"name":"tyctxt"},{"name":"polytraitref"}],"output":{"name":"supertraits"}}],[5,"transitive_bounds","","",null,null],[5,"supertrait_def_ids","","",null,{"inputs":[{"name":"tyctxt"},{"name":"defid"}],"output":{"name":"supertraitdefids"}}],[5,"impl_trait_ref_and_oblig","","Instantiate all bound parameters of the impl with the given substs, returning the resulting trait ref and all obligations that arise. The obligations are closed under normalization.",null,null],[5,"predicates_for_generics","","See `super::obligations_for_generics`",null,{"inputs":[{"name":"obligationcause"},{"name":"usize"},{"name":"paramenv"},{"name":"instantiatedpredicates"}],"output":{"generics":["predicateobligation"],"name":"vec"}}],[5,"predicate_for_trait_ref","","",null,{"inputs":[{"name":"obligationcause"},{"name":"paramenv"},{"name":"traitref"},{"name":"usize"}],"output":{"name":"predicateobligation"}}],[6,"Supertraits","","",null,null],[11,"new","","",624,{"inputs":[{"name":"tyctxt"}],"output":{"name":"predicateset"}}],[11,"insert","","",624,{"inputs":[{"name":"self"},{"name":"predicate"}],"output":{"name":"bool"}}],[11,"filter_to_traits","","",625,{"inputs":[{"name":"self"}],"output":{"name":"filtertotraits"}}],[11,"push","","",625,{"inputs":[{"name":"self"},{"name":"predicate"}],"output":null}],[11,"next","","",625,{"inputs":[{"name":"self"}],"output":{"generics":["predicate"],"name":"option"}}],[11,"next","rustc::traits","",564,{"inputs":[{"name":"self"}],"output":{"generics":["defid"],"name":"option"}}],[11,"new","rustc::traits::util","",626,{"inputs":[{"name":"i"}],"output":{"name":"filtertotraits"}}],[11,"next","","",626,{"inputs":[{"name":"self"}],"output":{"generics":["polytraitref"],"name":"option"}}],[11,"size_hint","","",626,null],[0,"query","rustc::traits","Experimental types for the trait query interface. The methods defined in this module are all based on canonicalization, which makes a canonical query by replacing unbound inference variables and regions, so that results can be reused more broadly. The providers for the queries defined here can be found in `librustc_traits`.",null,null],[3,"NoSolution","rustc::traits::query","",null,null],[0,"dropck_outlives","","",null,null],[3,"DropckOutlivesResult","rustc::traits::query::dropck_outlives","",null,null],[12,"kinds","","",628,null],[12,"overflows","","",628,null],[3,"DtorckConstraint","","A set of constraints that need to be satisfied in order for a type to be valid for destruction.",null,null],[12,"outlives","","Types that are required to be alive in order for this type to be valid for destruction.",629,null],[12,"dtorck_types","","Types that could not be resolved: projections and params.",629,null],[12,"overflows","","If, during the computation of the dtorck constraint, we overflow, that gets recorded here. The caller is expected to report an error.",629,null],[5,"trivial_dropck_outlives","","This returns true if the type `ty` is \"trivial\" for dropck-outlives -- that is, if it doesn't require any types to outlive. This is similar but not quite the same as the `needs_drop` test in the compiler already -- that is, for every type T for which this function return true, needs-drop would return false. But the reverse does not hold: in particular, `needs_drop` returns false for `PhantomData`, but it is not trivial for dropck-outlives.",null,{"inputs":[{"name":"tyctxt"},{"name":"ty"}],"output":{"name":"bool"}}],[11,"dropck_outlives","rustc::infer::at","Given a type `ty` of some value being dropped, computes a set of \"kinds\" (types, regions) that must be outlive the execution of the destructor. These basically correspond to data that the destructor might access. This is used during regionck to impose \"outlives\" constraints on any lifetimes referenced within.",218,{"inputs":[{"name":"self"},{"name":"ty"}],"output":{"generics":["vec"],"name":"inferok"}}],[11,"clone","rustc::traits::query::dropck_outlives","",628,{"inputs":[{"name":"self"}],"output":{"name":"dropckoutlivesresult"}}],[11,"fmt","","",628,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",629,{"inputs":[{"name":"self"}],"output":{"name":"dtorckconstraint"}}],[11,"fmt","","",629,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"empty","","",629,{"inputs":[],"output":{"name":"dtorckconstraint"}}],[11,"from_iter","","",629,{"inputs":[{"name":"i"}],"output":{"name":"self"}}],[11,"super_fold_with","","",628,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",628,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"lift_to_tcx","","",628,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"generics":["dropckoutlivesresult"],"name":"option"}}],[11,"hash_stable","","",628,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[11,"intern","rustc::infer::canonical","",224,null],[11,"hash_stable","rustc::traits::query::dropck_outlives","",629,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[0,"evaluate_obligation","rustc::traits::query","",null,null],[11,"predicate_may_hold","rustc::infer","Evaluates whether the predicate can be satisfied (by any means) in the given `ParamEnv`.",203,{"inputs":[{"name":"self"},{"name":"predicateobligation"}],"output":{"name":"bool"}}],[11,"predicate_must_hold","","Evaluates whether the predicate can be satisfied in the given `ParamEnv`, and returns `false` if not certain. However, this is not entirely accurate if inference variables are involved.",203,{"inputs":[{"name":"self"},{"name":"predicateobligation"}],"output":{"name":"bool"}}],[11,"evaluate_obligation","","",203,{"inputs":[{"name":"self"},{"name":"predicateobligation"}],"output":{"name":"evaluationresult"}}],[0,"normalize","rustc::traits::query","Code for the 'normalization' query. This consists of a wrapper which folds deeply, invoking the underlying `normalize_projection_ty` query when it encounters projections.",null,null],[3,"NormalizationResult","rustc::traits::query::normalize","Result from the `normalize_projection_ty` query.",null,null],[12,"normalized_ty","","Result of normalization.",630,null],[3,"QueryNormalizer","","",null,null],[12,"infcx","","",631,null],[12,"cause","","",631,null],[12,"param_env","","",631,null],[12,"obligations","","",631,null],[12,"error","","",631,null],[12,"anon_depth","","",631,null],[11,"normalize","rustc::infer::at","Normalize `value` in the context of the inference context, yielding a resulting type, or an error if `value` cannot be normalized. If you don't care about regions, you should prefer `normalize_erasing_regions`, which is more efficient.",218,{"inputs":[{"name":"self"},{"name":"t"}],"output":{"generics":["normalized","nosolution"],"name":"result"}}],[11,"clone","rustc::traits::query::normalize","",630,{"inputs":[{"name":"self"}],"output":{"name":"normalizationresult"}}],[11,"fmt","","",630,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"tcx","","",631,{"inputs":[{"name":"self"}],"output":{"name":"tyctxt"}}],[11,"fold_ty","","",631,{"inputs":[{"name":"self"},{"name":"ty"}],"output":{"name":"ty"}}],[11,"fold_const","","",631,{"inputs":[{"name":"self"},{"name":"const"}],"output":{"name":"const"}}],[11,"super_fold_with","","",630,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"self"}}],[11,"super_visit_with","","",630,{"inputs":[{"name":"self"},{"name":"v"}],"output":{"name":"bool"}}],[11,"lift_to_tcx","","",630,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"generics":["normalizationresult"],"name":"option"}}],[11,"intern","rustc::infer::canonical","",224,null],[11,"hash_stable","rustc::traits::query::normalize","",630,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[0,"normalize_erasing_regions","rustc::traits::query","Methods for normalizing when you don't care about regions (and aren't doing type inference). If either of those things don't apply to you, use `infcx.normalize(...)`.",null,null],[3,"NormalizeAfterErasingRegionsFolder","rustc::traits::query::normalize_erasing_regions","",null,null],[12,"tcx","","",632,null],[12,"param_env","","",632,null],[11,"tcx","","",632,{"inputs":[{"name":"self"}],"output":{"name":"tyctxt"}}],[11,"fold_ty","","",632,{"inputs":[{"name":"self"},{"name":"ty"}],"output":{"name":"ty"}}],[6,"CanonicalProjectionGoal","rustc::traits::query","",null,null],[6,"CanonicalTyGoal","","",null,null],[6,"CanonicalPredicateGoal","","",null,null],[6,"Fallible","","",null,null],[11,"clone","","",633,{"inputs":[{"name":"self"}],"output":{"name":"nosolution"}}],[11,"fmt","","",633,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",633,{"inputs":[{"name":"self"},{"name":"nosolution"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",633,null],[11,"hash","","",633,null],[11,"hash_stable","","",633,{"inputs":[{"name":"self"},{"name":"stablehashingcontext"},{"name":"stablehasher"}],"output":null}],[6,"Supertraits","rustc::traits","",null,null],[6,"PredicateObligation","","",null,null],[6,"TraitObligation","","",null,null],[6,"Obligations","","",null,null],[6,"PredicateObligations","","",null,null],[6,"TraitObligations","","",null,null],[6,"PolyDomainGoal","","",null,null],[6,"Goals","","",null,null],[6,"Clauses","","Multiple clauses.",null,null],[6,"Selection","","",null,null],[6,"SelectionResult","","When performing resolution, it is typically the case that there can be one of three outcomes:",null,null],[8,"TraitEngine","","",null,null],[10,"normalize_projection_type","","",601,{"inputs":[{"name":"self"},{"name":"inferctxt"},{"name":"paramenv"},{"name":"projectionty"},{"name":"obligationcause"}],"output":{"name":"ty"}}],[10,"register_bound","","",601,{"inputs":[{"name":"self"},{"name":"inferctxt"},{"name":"paramenv"},{"name":"ty"},{"name":"defid"},{"name":"obligationcause"}],"output":null}],[10,"register_predicate_obligation","","",601,{"inputs":[{"name":"self"},{"name":"inferctxt"},{"name":"predicateobligation"}],"output":null}],[10,"select_all_or_error","","",601,{"inputs":[{"name":"self"},{"name":"inferctxt"}],"output":{"generics":["vec"],"name":"result"}}],[10,"select_where_possible","","",601,{"inputs":[{"name":"self"},{"name":"inferctxt"}],"output":{"generics":["vec"],"name":"result"}}],[10,"pending_obligations","","",601,{"inputs":[{"name":"self"}],"output":{"generics":["pendingpredicateobligation"],"name":"vec"}}],[11,"clone","","",583,{"inputs":[{"name":"self"}],"output":{"name":"intercratemode"}}],[11,"eq","","",583,{"inputs":[{"name":"self"},{"name":"intercratemode"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",583,null],[11,"fmt","","",583,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",584,{"inputs":[{"name":"self"}],"output":{"name":"traitquerymode"}}],[11,"eq","","",584,{"inputs":[{"name":"self"},{"name":"traitquerymode"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",584,null],[11,"fmt","","",584,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",565,{"inputs":[{"name":"self"}],"output":{"name":"obligation"}}],[11,"eq","","",565,{"inputs":[{"name":"self"},{"name":"obligation"}],"output":{"name":"bool"}}],[11,"ne","","",565,{"inputs":[{"name":"self"},{"name":"obligation"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",565,null],[11,"hash","","",565,null],[11,"clone","","",566,{"inputs":[{"name":"self"}],"output":{"name":"obligationcause"}}],[11,"fmt","","",566,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",566,{"inputs":[{"name":"self"},{"name":"obligationcause"}],"output":{"name":"bool"}}],[11,"ne","","",566,{"inputs":[{"name":"self"},{"name":"obligationcause"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",566,null],[11,"hash","","",566,null],[11,"span","","",566,{"inputs":[{"name":"self"},{"name":"tyctxt"}],"output":{"name":"span"}}],[11,"clone","","",585,{"inputs":[{"name":"self"}],"output":{"name":"obligationcausecode"}}],[11,"fmt","","",585,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",585,{"inputs":[{"name":"self"},{"name":"obligationcausecode"}],"output":{"name":"bool"}}],[11,"ne","","",585,{"inputs":[{"name":"self"},{"name":"obligationcausecode"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",585,null],[11,"hash","","",585,null],[11,"clone","","",567,{"inputs":[{"name":"self"}],"output":{"name":"derivedobligationcause"}}],[11,"fmt","","",567,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",567,{"inputs":[{"name":"self"},{"name":"derivedobligationcause"}],"output":{"name":"bool"}}],[11,"ne","","",567,{"inputs":[{"name":"self"},{"name":"derivedobligationcause"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",567,null],[11,"hash","","",567,null],[11,"clone","","",586,{"inputs":[{"name":"self"}],"output":{"name":"whereclauseatom"}}],[11,"eq","","",586,{"inputs":[{"name":"self"},{"name":"whereclauseatom"}],"output":{"name":"bool"}}],[11,"ne","","",586,{"inputs":[{"name":"self"},{"name":"whereclauseatom"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",586,null],[11,"hash","","",586,null],[11,"fmt","","",586,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",587,{"inputs":[{"name":"self"}],"output":{"name":"domaingoal"}}],[11,"eq","","",587,{"inputs":[{"name":"self"},{"name":"domaingoal"}],"output":{"name":"bool"}}],[11,"ne","","",587,{"inputs":[{"name":"self"},{"name":"domaingoal"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",587,null],[11,"hash","","",587,null],[11,"fmt","","",587,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",588,{"inputs":[{"name":"self"}],"output":{"name":"quantifierkind"}}],[11,"eq","","",588,{"inputs":[{"name":"self"},{"name":"quantifierkind"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",588,null],[11,"hash","","",588,null],[11,"fmt","","",588,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",589,{"inputs":[{"name":"self"}],"output":{"name":"goal"}}],[11,"eq","","",589,{"inputs":[{"name":"self"},{"name":"goal"}],"output":{"name":"bool"}}],[11,"ne","","",589,{"inputs":[{"name":"self"},{"name":"goal"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",589,null],[11,"hash","","",589,null],[11,"fmt","","",589,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"from_poly_domain_goal","","",589,{"inputs":[{"name":"polydomaingoal"},{"name":"tyctxt"}],"output":{"name":"goal"}}],[11,"from","","",589,{"inputs":[{"name":"domaingoal"}],"output":{"name":"self"}}],[11,"clone","","",590,{"inputs":[{"name":"self"}],"output":{"name":"clause"}}],[11,"eq","","",590,{"inputs":[{"name":"self"},{"name":"clause"}],"output":{"name":"bool"}}],[11,"ne","","",590,{"inputs":[{"name":"self"},{"name":"clause"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",590,null],[11,"hash","","",590,null],[11,"fmt","","",590,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",568,{"inputs":[{"name":"self"}],"output":{"name":"programclause"}}],[11,"eq","","",568,{"inputs":[{"name":"self"},{"name":"programclause"}],"output":{"name":"bool"}}],[11,"ne","","",568,{"inputs":[{"name":"self"},{"name":"programclause"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",568,null],[11,"hash","","",568,null],[11,"fmt","","",568,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",591,{"inputs":[{"name":"self"}],"output":{"name":"selectionerror"}}],[11,"fmt","","",591,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",592,{"inputs":[{"name":"self"}],"output":{"name":"fulfillmenterrorcode"}}],[11,"clone","","",593,{"inputs":[{"name":"self"}],"output":{"name":"vtable"}}],[11,"eq","","",593,{"inputs":[{"name":"self"},{"name":"vtable"}],"output":{"name":"bool"}}],[11,"ne","","",593,{"inputs":[{"name":"self"},{"name":"vtable"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",593,null],[11,"encode","","",593,{"inputs":[{"name":"self"},{"name":"__sn"}],"output":{"name":"result"}}],[11,"decode","","",593,{"inputs":[{"name":"__dn"}],"output":{"generics":["vtable"],"name":"result"}}],[11,"clone","","",570,{"inputs":[{"name":"self"}],"output":{"name":"vtableimpldata"}}],[11,"eq","","",570,{"inputs":[{"name":"self"},{"name":"vtableimpldata"}],"output":{"name":"bool"}}],[11,"ne","","",570,{"inputs":[{"name":"self"},{"name":"vtableimpldata"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",570,null],[11,"encode","","",570,{"inputs":[{"name":"self"},{"name":"__sn"}],"output":{"name":"result"}}],[11,"decode","","",570,{"inputs":[{"name":"__dn"}],"output":{"generics":["vtableimpldata"],"name":"result"}}],[11,"clone","","",571,{"inputs":[{"name":"self"}],"output":{"name":"vtablegeneratordata"}}],[11,"eq","","",571,{"inputs":[{"name":"self"},{"name":"vtablegeneratordata"}],"output":{"name":"bool"}}],[11,"ne","","",571,{"inputs":[{"name":"self"},{"name":"vtablegeneratordata"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",571,null],[11,"encode","","",571,{"inputs":[{"name":"self"},{"name":"__sn"}],"output":{"name":"result"}}],[11,"decode","","",571,{"inputs":[{"name":"__dn"}],"output":{"generics":["vtablegeneratordata"],"name":"result"}}],[11,"clone","","",572,{"inputs":[{"name":"self"}],"output":{"name":"vtableclosuredata"}}],[11,"eq","","",572,{"inputs":[{"name":"self"},{"name":"vtableclosuredata"}],"output":{"name":"bool"}}],[11,"ne","","",572,{"inputs":[{"name":"self"},{"name":"vtableclosuredata"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",572,null],[11,"encode","","",572,{"inputs":[{"name":"self"},{"name":"__sn"}],"output":{"name":"result"}}],[11,"decode","","",572,{"inputs":[{"name":"__dn"}],"output":{"generics":["vtableclosuredata"],"name":"result"}}],[11,"clone","","",573,{"inputs":[{"name":"self"}],"output":{"name":"vtableautoimpldata"}}],[11,"eq","","",573,{"inputs":[{"name":"self"},{"name":"vtableautoimpldata"}],"output":{"name":"bool"}}],[11,"ne","","",573,{"inputs":[{"name":"self"},{"name":"vtableautoimpldata"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",573,null],[11,"encode","","",573,{"inputs":[{"name":"self"},{"name":"__sn"}],"output":{"name":"result"}}],[11,"decode","","",573,{"inputs":[{"name":"__dn"}],"output":{"generics":["vtableautoimpldata"],"name":"result"}}],[11,"clone","","",574,{"inputs":[{"name":"self"}],"output":{"name":"vtablebuiltindata"}}],[11,"eq","","",574,{"inputs":[{"name":"self"},{"name":"vtablebuiltindata"}],"output":{"name":"bool"}}],[11,"ne","","",574,{"inputs":[{"name":"self"},{"name":"vtablebuiltindata"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",574,null],[11,"encode","","",574,{"inputs":[{"name":"self"},{"name":"__sn"}],"output":{"name":"result"}}],[11,"decode","","",574,{"inputs":[{"name":"__dn"}],"output":{"generics":["vtablebuiltindata"],"name":"result"}}],[11,"eq","","",575,{"inputs":[{"name":"self"},{"name":"vtableobjectdata"}],"output":{"name":"bool"}}],[11,"ne","","",575,{"inputs":[{"name":"self"},{"name":"vtableobjectdata"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",575,null],[11,"clone","","",575,{"inputs":[{"name":"self"}],"output":{"name":"vtableobjectdata"}}],[11,"encode","","",575,{"inputs":[{"name":"self"},{"name":"__sn"}],"output":{"name":"result"}}],[11,"decode","","",575,{"inputs":[{"name":"__dn"}],"output":{"generics":["vtableobjectdata"],"name":"result"}}],[11,"clone","","",576,{"inputs":[{"name":"self"}],"output":{"name":"vtablefnpointerdata"}}],[11,"eq","","",576,{"inputs":[{"name":"self"},{"name":"vtablefnpointerdata"}],"output":{"name":"bool"}}],[11,"ne","","",576,{"inputs":[{"name":"self"},{"name":"vtablefnpointerdata"}],"output":{"name":"bool"}}],[11,"assert_receiver_is_total_eq","","",576,null],[11,"encode","","",576,{"inputs":[{"name":"self"},{"name":"__sn"}],"output":{"name":"result"}}],[11,"decode","","",576,{"inputs":[{"name":"__dn"}],"output":{"generics":["vtablefnpointerdata"],"name":"result"}}],[11,"new","","",565,{"inputs":[{"name":"obligationcause"},{"name":"paramenv"},{"name":"o"}],"output":{"name":"obligation"}}],[11,"with_depth","","",565,{"inputs":[{"name":"obligationcause"},{"name":"usize"},{"name":"paramenv"},{"name":"o"}],"output":{"name":"obligation"}}],[11,"misc","","",565,{"inputs":[{"name":"span"},{"name":"nodeid"},{"name":"paramenv"},{"name":"o"}],"output":{"name":"obligation"}}],[11,"with","","",565,{"inputs":[{"name":"self"},{"name":"p"}],"output":{"name":"obligation"}}],[11,"new","","",566,{"inputs":[{"name":"span"},{"name":"nodeid"},{"name":"obligationcausecode"}],"output":{"name":"obligationcause"}}],[11,"misc","","",566,{"inputs":[{"name":"span"},{"name":"nodeid"}],"output":{"name":"obligationcause"}}],[11,"dummy","","",566,{"inputs":[],"output":{"name":"obligationcause"}}],[11,"nested_obligations","","",593,{"inputs":[{"name":"self"}],"output":{"name":"vec"}}],[11,"map","","",593,{"inputs":[{"name":"self"},{"name":"f"}],"output":{"name":"vtable"}}],[11,"new","","",569,{"inputs":[{"name":"predicateobligation"},{"name":"fulfillmenterrorcode"}],"output":{"name":"fulfillmenterror"}}],[11,"self_ty","","",634,{"inputs":[{"name":"self"}],"output":{"generics":["ty"],"name":"binder"}}],[0,"ty","rustc","",null,null],[3,"Binder","rustc::ty","Binder is a binder for higher-ranked lifetimes. It is part of the compiler's representation for things like `for<'a> Fn(&'a isize)` (which would be represented by the type `PolyTraitRef == Binder<TraitRef>`). Note that when we skolemize, instantiate, erase, or otherwise \"discharge\" these bound regions, we change the type from `Binder<T>` to just `T` (see e.g. `liberate_late_bound_regions`).",null,null],[12,"0","","",635,null],[3,"CanonicalVar","","",null,null],[12,"0","","",636,null],[3,"DebruijnIndex","","A [De Bruijn index][dbi] is a standard means of representing regions (and perhaps later types) in a higher-ranked setting. In particular, imagine a type like this:",null,null],[12,"depth","","We maintain the invariant that this is never 0. So 1 indicates the innermost binder. To ensure this, create with `DebruijnIndex::new`.",637,null],[3,"FnSig","","Signature of a function type, which I have arbitrarily decided to use to refer to the input/output types.",null,null],[12,"inputs_and_output","","",638,null],[12,"variadic","","",638,null],[12,"unsafety","","",638,null],[12,"abi","","",638,null],[3,"GenSig","","",null,null],[12,"yield_ty","","",639,null],[12,"return_ty","","",639,null],[3,"ParamTy","","",null,null],[12,"idx","","",640,null],[12,"name","","",640,null],[3,"ProjectionTy","","Represents the projection of an associated type. In explicit UFCS form this would be written `<T as Trait<..>>::N`.",null,null],[12,"substs","","The parameters of the associated item.",641,null],[12,"item_def_id","","The DefId of the TraitItem for the associated type N.",641,null],[3,"ClosureSubsts","","A closure can be modeled as a struct that looks like:",null,null],[12,"substs","","Lifetime and type parameters from the enclosing function, concatenated with the types of the upvars.",642,null],[3,"GeneratorInterior","","This describes the types that can be contained in a generator. It will be a type variable initially and unified in the last stages of typeck of a body. It contains a tuple of all the types that could end up on a generator frame. The state transformation MIR pass may only produce layouts which mention types in this tuple. Upvars are not counted here.",null,null],[12,"witness","","",643,null],[12,"movable","","",643,null],[3,"TypeAndMut","","",null,null],[12,"ty","","",644,null],[12,"mutbl","","",644,null],[3,"TraitRef","","A complete reference to a trait. These take numerous guises in syntax, but perhaps the most recognizable form is in a where clause:",null,null],[12,"def_id","","",645,null],[12,"substs","","",645,null],[3,"ExistentialTraitRef","","An existential reference to a trait, where `Self` is erased. For example, the trait object `Trait<'a, 'b, X, Y>` is:",null,null],[12,"def_id","","",646,null],[12,"substs","","",646,null],[3,"ExistentialProjection","","A `ProjectionPredicate` for an `ExistentialTraitRef`.",null,null],[12,"item_def_id","","",647,null],[12,"substs","","",647,null],[12,"ty","","",647,null],[3,"Const","","Typed constant value.",null,null],[12,"ty","","",648,null],[12,"val","","",648,null],[3,"EarlyBoundRegion","","",null,null],[12,"def_id","","",649,null],[12,"index","","",649,null],[12,"name","","",649,null],[3,"FreeRegion","","A \"free\" region `fr` can be interpreted as \"some region at least as big as the scope `fr.scope`\".",null,null],[12,"scope","","",650,null],[12,"bound_region","","",650,null],[3,"TyVid","","",null,null],[12,"index","","",651,null],[3,"IntVid","","",null,null],[12,"index","","",652,null],[3,"FloatVid","","",null,null],[12,"index","","",653,null],[3,"RegionVid","","",null,null],[12,"0","","",654,null],[3,"TyCtxt","","The central data structure of the compiler. It stores references to the various arenas and also houses the results of the various compiler queries that have been performed. See the [rustc guide] for more details.",null,null],[12,"gcx","","",655,null],[12,"interners","","",655,null],[3,"GlobalArenas","","Internal storage",null,null],[12,"layout","","",656,null],[12,"generics","","",656,null],[12,"trait_def","","",656,null],[12,"adt_def","","",656,null],[12,"steal_mir","","",656,null],[12,"mir","","",656,null],[12,"tables","","",656,null],[12,"const_allocs","","miri allocations",656,null],[3,"AllArenas","","",null,null],[12,"global","","",657,null],[12,"interner","","",657,null],[3,"TypeckTables","","",null,null],[12,"local_id_root","","The HirId::owner all ItemLocalIds in this table are relative to.",658,null],[12,"type_dependent_defs","","Resolved definitions for `<T>::X` associated paths and method calls, including those of overloaded operators.",658,null],[12,"field_indices","","Resolved field indices for field accesses in expressions (`S { field }`, `obj.field`) or patterns (`S { field }`). The index is often useful by itself, but to learn more about the field you also need definition of the variant to which the field belongs, but it may not exist if it's a tuple field (`tuple.0`).",658,null],[12,"user_provided_tys","","Stores the canonicalized types provided by the user. See also `UserAssertTy` statement in MIR.",658,null],[12,"node_types","","Stores the types for various nodes in the AST.  Note that this table is not guaranteed to be populated until after typeck.  See typeck::check::fn_ctxt for details.",658,null],[12,"node_substs","","Stores the type parameters which were substituted to obtain the type of this node.  This only applies to nodes that refer to entities parameterized by type parameters, such as generic fns, types, or other items.",658,null],[12,"adjustments","","",658,null],[12,"pat_binding_modes","","Stores the actual binding mode for all instances of hir::BindingAnnotation.",658,null],[12,"pat_adjustments","","Stores the types which were implicitly dereferenced in pattern binding modes for later usage in HAIR lowering. For example,",658,null],[12,"upvar_capture_map","","Borrows",658,null],[12,"closure_kind_origins","","Records the reasons that we picked the kind of each closure; not all closures are present in the map.",658,null],[12,"liberated_fn_sigs","","For each fn, records the \"liberated\" types of its arguments and return type. Liberated means that all bound regions (including late-bound regions) are replaced with free equivalents. This table is not used in trans (since regions are erased there) and hence is not serialized to metadata.",658,null],[12,"fru_field_types","","For each FRU expression, record the normalized types of the fields of the struct - this is needed because it is non-trivial to normalize while preserving regions. This table is used only in MIR construction and hence is not serialized to metadata.",658,null],[12,"cast_kinds","","Maps a cast expression to its kind. This is keyed on the from expression of the cast, not the cast itself.",658,null],[12,"used_trait_imports","","Set of trait imports actually used in the method resolution. This is used for warning unused imports. During type checking, this `Lrc` should not be cloned: it must have a ref-count of 1 so that we can insert things into the set mutably.",658,null],[12,"tainted_by_errors","","If any errors occurred while type-checking this body, this field will be set to `true`.",658,null],[12,"free_region_map","","Stores the free-region relationships that were deduced from its where clauses and parameter types. These are then read-again by borrowck.",658,null],[3,"InterpretInterner","","Everything needed to efficiently work with interned allocations",null,null],[12,"inner","","",659,null],[3,"Instance","","",null,null],[12,"def","","",660,null],[12,"substs","","",660,null],[3,"CrateAnalysis","","The complete set of all analyses described in this module. This is produced by the driver and fed to trans and later passes.",null,null],[12,"access_levels","","",661,null],[12,"name","","",661,null],[12,"glob_map","","",661,null],[3,"Resolutions","","",null,null],[12,"freevars","","",662,null],[12,"trait_map","","",662,null],[12,"maybe_unused_trait_imports","","",662,null],[12,"maybe_unused_extern_crates","","",662,null],[12,"export_map","","",662,null],[3,"ImplHeader","","The \"header\" of an impl is everything outside the body: a Self type, a trait ref (in the case of a trait impl), and a set of predicates (from the bounds/where clauses).",null,null],[12,"impl_def_id","","",663,null],[12,"self_ty","","",663,null],[12,"trait_ref","","",663,null],[12,"predicates","","",663,null],[3,"AssociatedItem","","",null,null],[12,"def_id","","",664,null],[12,"name","","",664,null],[12,"kind","","",664,null],[12,"vis","","",664,null],[12,"defaultness","","",664,null],[12,"container","","",664,null],[12,"method_has_self_argument","","Whether this is a method with an explicit self as its first argument, allowing method calls.",664,null],[3,"CrateVariancesMap","","The crate variances map is computed during typeck and contains the variance of every item in the local crate. You should not use it directly, because to do so will make your pass dependent on the HIR of every item in the local crate. Instead, use `tcx.variances_of()` to get the variance for a particular item.",null,null],[12,"variances","","For each item with generics, maps to a vector of the variance of its generics.  If an item has no generics, it will have no entry.",665,null],[12,"empty_variance","","An empty vector, useful for cloning.",665,null],[3,"CReaderCacheKey","","",null,null],[12,"cnum","","",666,null],[12,"pos","","",666,null],[3,"TypeFlags","","",null,null],[12,"bits","","",667,null],[3,"TyS","","",null,null],[12,"sty","","",668,null],[12,"flags","","",668,null],[12,"region_depth","","",668,null],[3,"Slice","","A wrapper for slices with the additional invariant that the slice is interned and no other slice with the same contents can exist in the same context. This means we can use pointer + length for both equality comparisons and hashing.",null,null],[12,"0","","",669,null],[3,"UpvarId","","Upvars do not get their own node-id. Instead, we use the pair of the original var id (that is, the root variable that is referenced by the upvar) and the id of the closure expression.",null,null],[12,"var_id","","",670,null],[12,"closure_expr_id","","",670,null],[3,"UpvarBorrow","","",null,null],[12,"kind","","The kind of borrow: by-ref upvars have access to shared immutable borrows, which are not part of the normal language syntax.",671,null],[12,"region","","Region of the resulting reference.",671,null],[3,"ClosureUpvar","","",null,null],[12,"def","","",672,null],[12,"span","","",672,null],[12,"ty","","",672,null],[3,"FloatVarValue","","",null,null],[12,"0","","",673,null],[3,"TypeParameterDef","","",null,null],[12,"name","","",674,null],[12,"def_id","","",674,null],[12,"index","","",674,null],[12,"has_default","","",674,null],[12,"object_lifetime_default","","",674,null],[12,"pure_wrt_drop","","`pure_wrt_drop`, set by the (unsafe) `#[may_dangle]` attribute on generic parameter `T`, asserts data behind the parameter `T` won't be accessed during the parent type's `Drop` impl.",674,null],[12,"synthetic","","",674,null],[3,"RegionParameterDef","","",null,null],[12,"name","","",675,null],[12,"def_id","","",675,null],[12,"index","","",675,null],[12,"pure_wrt_drop","","`pure_wrt_drop`, set by the (unsafe) `#[may_dangle]` attribute on generic parameter `'a`, asserts data of lifetime `'a` won't be accessed during the parent type's `Drop` impl.",675,null],[3,"Generics","","Information about the formal type/lifetime parameters associated with an item or method. Analogous to hir::Generics.",null,null],[12,"parent","","",676,null],[12,"parent_regions","","",676,null],[12,"parent_types","","",676,null],[12,"regions","","",676,null],[12,"types","","",676,null],[12,"type_param_to_index","","Reverse map to each `TypeParameterDef`'s `index` field",676,null],[12,"has_self","","",676,null],[12,"has_late_bound_regions","","",676,null],[3,"GenericPredicates","","Bounds on generics.",null,null],[12,"parent","","",677,null],[12,"predicates","","",677,null],[3,"CratePredicatesMap","","The crate outlives map is computed during typeck and contains the outlives of every item in the local crate. You should not use it directly, because to do so will make your pass dependent on the HIR of every item in the local crate. Instead, use `tcx.inferred_outlives_of()` to get the outlives for a particular item.",null,null],[12,"predicates","","For each struct with outlive bounds, maps to a vector of the predicate of its outlive bounds. If an item has no outlives bounds, it will have no entry.",678,null],[12,"empty_predicate","","An empty vector, useful for cloning.",678,null],[3,"TraitPredicate","","",null,null],[12,"trait_ref","","",679,null],[3,"OutlivesPredicate","","",null,null],[12,"0","","",680,null],[12,"1","","",680,null],[3,"SubtypePredicate","","",null,null],[12,"a_is_expected","","",681,null],[12,"a","","",681,null],[12,"b","","",681,null],[3,"ProjectionPredicate","","This kind of predicate has no direct correspondent in the syntax, but it roughly corresponds to the syntactic forms:",null,null],[12,"projection_ty","","",682,null],[12,"ty","","",682,null],[3,"InstantiatedPredicates","","Represents the bounds declared on a particular set of type parameters.  Should eventually be generalized into a flag list of where clauses.  You can obtain a `InstantiatedPredicates` list from a `GenericPredicates` by using the `instantiate` method. Note that this method reflects an important semantic invariant of `InstantiatedPredicates`: while the `GenericPredicates` are expressed in terms of the bound type parameters of the impl/trait/whatever, an `InstantiatedPredicates` instance represented a set of bounds for some particular instantiation, meaning that the generic parameters have been substituted with their values.",null,null],[12,"predicates","","",683,null],[3,"UniverseIndex","","\"Universes\" are used during type- and trait-checking in the presence of `for<..>` binders to control what sets of names are visible. Universes are arranged into a tree: the root universe contains names that are always visible. But when you enter into some subuniverse, then it may add names that are only visible within that subtree (but it can still name the names of its ancestor universes).",null,null],[12,"0","","",684,null],[3,"ParamEnv","","When type checking, we use the `ParamEnv` to track details about the set of where-clauses that are in scope at this particular point.",null,null],[12,"caller_bounds","","Obligations that the caller must satisfy. This is basically the set of bounds on the in-scope type parameters, translated into Obligations, and elaborated and normalized.",685,null],[12,"reveal","","Typically, this is `Reveal::UserFacing`, but during trans we want `Reveal::All` -- note that this is always paired with an empty environment. To get that, use `ParamEnv::reveal()`.",685,null],[3,"ParamEnvAnd","","",null,null],[12,"param_env","","",686,null],[12,"value","","",686,null],[3,"Destructor","","",null,null],[12,"did","","The def-id of the destructor method",687,null],[3,"AdtFlags","","",null,null],[12,"bits","","",688,null],[3,"VariantDef","","",null,null],[12,"did","","The variant's DefId. If this is a tuple-like struct, this is the DefId of the struct's ctor.",689,null],[12,"name","","",689,null],[12,"discr","","",689,null],[12,"fields","","",689,null],[12,"ctor_kind","","",689,null],[3,"FieldDef","","",null,null],[12,"did","","",690,null],[12,"name","","",690,null],[12,"vis","","",690,null],[3,"AdtDef","","The definition of an abstract data type - a struct or enum.",null,null],[12,"did","","",691,null],[12,"variants","","",691,null],[12,"flags","","",691,null],[12,"repr","","",691,null],[3,"ReprFlags","","",null,null],[12,"bits","","",692,null],[3,"ReprOptions","","Represents the repr options provided by the user,",null,null],[12,"int","","",693,null],[12,"align","","",693,null],[12,"pack","","",693,null],[12,"flags","","",693,null],[3,"CrateInherentImpls","","A map for the local crate mapping each type to a vector of its inherent impls. This is not meant to be used outside of coherence; rather, you should request the vector for a specific type via `tcx.inherent_impls(def_id)` so as to minimize your dependencies (constructing this map requires touching the entire crate).",null,null],[12,"inherent_impls","","",694,null],[3,"SymbolName","","",null,null],[12,"name","","",695,null],[4,"InferTy","","",null,null],[13,"TyVar","","",696,null],[13,"IntVar","","",696,null],[13,"FloatVar","","",696,null],[13,"FreshTy","","A `FreshTy` is one that is generated as a replacement for an unbound type variable. This is convenient for caching etc. See `infer::freshen` for more details.",696,null],[13,"FreshIntTy","","",696,null],[13,"FreshFloatTy","","",696,null],[13,"CanonicalTy","","Canonicalized type variable, used only when preparing a trait query.",696,null],[4,"ExistentialPredicate","","",null,null],[13,"Trait","","e.g. Iterator",697,null],[13,"Projection","","e.g. Iterator::Item = T",697,null],[13,"AutoTrait","","e.g. Send",697,null],[4,"TypeVariants","","NB: If you change this, you'll probably want to change the corresponding AST structure in libsyntax/ast.rs as well.",null,null],[13,"TyBool","","The primitive boolean type. Written as `bool`.",698,null],[13,"TyChar","","The primitive character type; holds a Unicode scalar value (a non-surrogate code point).  Written as `char`.",698,null],[13,"TyInt","","A primitive signed integer type. For example, `i32`.",698,null],[13,"TyUint","","A primitive unsigned integer type. For example, `u32`.",698,null],[13,"TyFloat","","A primitive floating-point type. For example, `f64`.",698,null],[13,"TyAdt","","Structures, enumerations and unions.",698,null],[13,"TyForeign","","",698,null],[13,"TyStr","","The pointee of a string slice. Written as `str`.",698,null],[13,"TyArray","","An array with the given length. Written as `[T; n]`.",698,null],[13,"TySlice","","The pointee of an array slice.  Written as `[T]`.",698,null],[13,"TyRawPtr","","A raw pointer. Written as `*mut T` or `*const T`",698,null],[13,"TyRef","","A reference; a pointer with an associated lifetime. Written as `&'a mut T` or `&'a T`.",698,null],[13,"TyFnDef","","The anonymous type of a function declaration/definition. Each function has a unique type.",698,null],[13,"TyFnPtr","","A pointer to a function.  Written as `fn() -> i32`.",698,null],[13,"TyDynamic","","A trait, defined with `trait`.",698,null],[13,"TyClosure","","The anonymous type of a closure. Used to represent the type of `|a| a`.",698,null],[13,"TyGenerator","","The anonymous type of a generator. Used to represent the type of `|a| yield a`.",698,null],[13,"TyGeneratorWitness","","A type representin the types stored inside a generator. This should only appear in GeneratorInteriors.",698,null],[13,"TyNever","","The never type `!`",698,null],[13,"TyTuple","","A tuple type.  For example, `(i32, bool)`.",698,null],[13,"TyProjection","","The projection of an associated type.  For example, `<T as Trait<..>>::N`.",698,null],[13,"TyAnon","","Anonymized (`impl Trait`) type found in a return type. The DefId comes from the `impl Trait` ast::Ty node, and the substitutions are for the generics of the function in question. After typeck, the concrete type can be found in the `types` map.",698,null],[13,"TyParam","","A type parameter; for example, `T` in `fn f(x: T) {}",698,null],[13,"TyInfer","","A type variable used during type-checking.",698,null],[13,"TyError","","A placeholder for a type which could not be computed; this is propagated to avoid useless error messages.",698,null],[4,"BoundRegion","","",null,null],[13,"BrAnon","","An anonymous region parameter for a given fn (&T)",699,null],[13,"BrNamed","","Named region parameters for functions (a in &'a T)",699,null],[13,"BrFresh","","Fresh bound identifiers created during GLB computations.",699,null],[13,"BrEnv","","Anonymous region for the implicit env pointer parameter to a closure",699,null],[4,"RegionKind","","Representation of regions.",null,null],[13,"ReEarlyBound","","",700,null],[13,"ReLateBound","","",700,null],[13,"ReFree","","When checking a function body, the types of all arguments and so forth that refer to bound region parameters are modified to refer to free region parameters.",700,null],[13,"ReScope","","A concrete region naming some statically determined scope (e.g. an expression or sequence of statements) within the current function.",700,null],[13,"ReStatic","","Static data that has an \"infinite\" lifetime. Top in the region lattice.",700,null],[13,"ReVar","","A region variable.  Should not exist after typeck.",700,null],[13,"ReSkolemized","","A skolemized region - basically the higher-ranked version of ReFree. Should not exist after typeck.",700,null],[13,"ReEmpty","","Empty lifetime is for data that is never accessed. Bottom in the region lattice. We treat ReEmpty somewhat specially; at least right now, we do not generate instances of it during the GLB computations, but rather generate an error instead. This is to improve error messages. The only way to get an instance of ReEmpty is to have a region variable with no constraints.",700,null],[13,"ReErased","","Erased region, used by trait selection, in MIR and during trans.",700,null],[13,"ReClosureBound","","These are regions bound in the \"defining type\" for a closure. They are used ONLY as part of the `ClosureRegionRequirements` that are produced by MIR borrowck. See `ClosureRegionRequirements` for more details.",700,null],[13,"ReCanonical","","Canonicalized region, used only when preparing a trait query.",700,null],[4,"InstanceDef","","",null,null],[13,"Item","","",701,null],[13,"Intrinsic","","",701,null],[13,"FnPtrShim","","<fn() as FnTrait>::call_* def-id is FnTrait::call_*",701,null],[13,"Virtual","","::fn",701,null],[13,"ClosureOnceShim","","<[mut closure] as FnOnce>::call_once",701,null],[12,"call_once","rustc::ty::InstanceDef","",701,null],[13,"DropGlue","rustc::ty","drop_in_place::; None for empty drop glue.",701,null],[13,"CloneShim","","`<T as Clone>::clone` shim.",701,null],[4,"AssociatedItemContainer","","",null,null],[13,"TraitContainer","","",702,null],[13,"ImplContainer","","",702,null],[4,"AssociatedKind","","",null,null],[13,"Const","","",703,null],[13,"Method","","",703,null],[13,"Type","","",703,null],[4,"Visibility","","",null,null],[13,"Public","","Visible everywhere (including in other crates).",704,null],[13,"Restricted","","Visible only in the given crate-local module.",704,null],[13,"Invisible","","Not visible anywhere in the local crate. This is the visibility of private external items.",704,null],[4,"Variance","","",null,null],[13,"Covariant","","",705,null],[13,"Invariant","","",705,null],[13,"Contravariant","","",705,null],[13,"Bivariant","","",705,null],[4,"BorrowKind","","",null,null],[13,"ImmBorrow","","Data must be immutable and is aliasable.",706,null],[13,"UniqueImmBorrow","","Data must be immutable but not aliasable.  This kind of borrow cannot currently be expressed by the user and is used only in implicit closure bindings. It is needed when the closure is borrowing or mutating a mutable referent, e.g.:",706,null],[13,"MutBorrow","","Data is mutable and not aliasable.",706,null],[4,"UpvarCapture","","Information describing the capture of an upvar. This is computed during `typeck`, specifically by `regionck`.",null,null],[13,"ByValue","","Upvar is captured by value. This is always true when the closure is labeled `move`, but can also be true in other cases depending on inference.",707,null],[13,"ByRef","","Upvar is captured by reference.",707,null],[4,"IntVarValue","","",null,null],[13,"IntType","","",708,null],[13,"UintType","","",708,null],[4,"Predicate","","",null,null],[13,"Trait","","Corresponds to `where Foo : Bar<A,B,C>`. `Foo` here would be the `Self` type of the trait reference and `A`, `B`, and `C` would be the type parameters.",709,null],[13,"RegionOutlives","","where 'a : 'b",709,null],[13,"TypeOutlives","","where T : 'a",709,null],[13,"Projection","","where ::Name == X, approximately. See `ProjectionPredicate` struct for details.",709,null],[13,"WellFormed","","no syntax: T WF",709,null],[13,"ObjectSafe","","trait must be object-safe",709,null],[13,"ClosureKind","","No direct syntax. May be thought of as `where T : FnFoo<...>` for some substitutions `...` and T being a closure type. Satisfied (or refuted) once we know the closure's kind.",709,null],[13,"Subtype","","`T1 <: T2`",709,null],[13,"ConstEvaluatable","","Constant initializer must evaluate successfully.",709,null],[4,"VariantDiscr","","",null,null],[13,"Explicit","","Explicit value for this variant, i.e. `X = 123`. The `DefId` corresponds to the embedded constant.",710,null],[13,"Relative","","The previous variant's discriminant plus one. For efficiency reasons, the distance from the last `Explicit` discriminant is being stored, or `0` for the first variant, if it has none.",710,null],[4,"AdtKind","","",null,null],[13,"Struct","","",711,null],[13,"Union","","",711,null],[13,"Enum","","",711,null],[4,"ClosureKind","","Represents the various closure traits in the Rust language. This will determine the type of the environment (`self`, in the desuaring) argument that the closure expects.",null,null],[13,"Fn","","",712,null],[13,"FnMut","","",712,null],[13,"FnOnce","","",712,null],[4,"Attributes","","",null,null],[13,"Owned","","",713,null],[13,"Borrowed","","",713,null],[5,"keep_local","","",null,{"inputs":[{"name":"t"}],"output":{"name":"bool"}}],[5,"associated_item","","",null,{"inputs":[{"name":"tyctxt"},{"name":"defid"}],"output":{"name":"associateditem"}}],[5,"adt_sized_constraint","","Calculates the Sized-constraint.",null,null],[5,"associated_item_def_ids","","",null,{"inputs":[{"name":"tyctxt"},{"name":"defid"}],"output":{"generics":["vec"],"name":"lrc"}}],[5,"def_span","","",null,{"inputs":[{"name":"tyctxt"},{"name":"defid"}],"output":{"name":"span"}}],[5,"trait_of_item","","If the given def ID describes an item belonging to a trait, return the ID of the trait that the trait item belongs to. Otherwise, return `None`.",null,{"inputs":[{"name":"tyctxt"},{"name":"defid"}],"output":{"generics":["defid"],"name":"option"}}],[5,"param_env","","See `ParamEnv` struct def'n for details.",null,{"inputs":[{"name":"tyctxt"},{"name":"defid"}],"output":{"name":"paramenv"}}],[5,"crate_disambiguator","","",null,{"inputs":[{"name":"tyctxt"},{"name":"cratenum"}],"output":{"name":"cratedisambiguator"}}],[5,"original_crate_name","","",null,{"inputs":[{"name":"tyctxt"},{"name":"cratenum"}],"output":{"name":"symbol"}}],[5,"crate_hash","","",null,{"inputs":[{"name":"tyctxt"},{"name":"cratenum"}],"output":{"name":"svh"}}],[5,"instance_def_size_estimate","","",null,{"inputs":[{"name":"tyctxt"},{"name":"instancedef"}],"output":{"name":"usize"}}],[5,"provide","","",null,{"inputs":[{"name":"providers"}],"output":null}],[0,"tls","","",null,null],[3,"ImplicitCtxt","rustc::ty::tls","This is the implicit state of rustc. It contains the current TyCtxt and query. It is updated when creating a local interner or executing a new query. Whenever there's a TyCtxt value available you should also have access to an ImplicitCtxt through the functions in this module.",null,null],[12,"tcx","","The current TyCtxt. Initially created by `enter_global` and updated by `enter_local` with a new local interner",714,null],[12,"query","","The current query job, if any. This is updated by start_job in ty::maps::plumbing when executing a query",714,null],[12,"layout_depth","","Used to prevent layout from recursing too deeply.",714,null],[12,"task","","The current dep graph task. This is used to add dependencies to queries when executing them",714,null],[5,"with_thread_locals","","Sets up the callbacks from libsyntax on the current thread",null,{"inputs":[{"name":"f"}],"output":{"name":"r"}}],[5,"enter_context","","Sets `context` as the new current ImplicitCtxt for the duration of the function `f`",null,{"inputs":[{"name":"implicitctxt"},{"name":"f"}],"output":{"name":"r"}}],[5,"enter_global","","Enters GlobalCtxt by setting up libsyntax callbacks and creating a initial TyCtxt and ImplicitCtxt. This happens once per rustc session and TyCtxts only exists inside the `f` function.",null,{"inputs":[{"name":"globalctxt"},{"name":"f"}],"output":{"name":"r"}}],[5,"with_context_opt","","Allows access to the current ImplicitCtxt in a closure if one is available",null,{"inputs":[{"name":"f"}],"output":{"name":"r"}}],[5,"with_context","","Allows access to the current ImplicitCtxt. Panics if there is no ImplicitCtxt available",null,{"inputs":[{"name":"f"}],"output":{"name":"r"}}],[5,"with_related_context","","Allows access to the current ImplicitCtxt whose tcx field has the same global interner as the tcx argument passed in. This means the closure is given an ImplicitCtxt with the same 'gcx lifetime as the TyCtxt passed in. This will panic if you pass it a TyCtxt which has a different global interner from the current ImplicitCtxt's tcx field.",null,{"inputs":[{"name":"tyctxt"},{"name":"f"}],"output":{"name":"r"}}],[5,"with_fully_related_context","","Allows access to the current ImplicitCtxt whose tcx field has the same global interner and local interner as the tcx argument passed in. This means the closure is given an ImplicitCtxt with the same 'tcx and 'gcx lifetimes as the TyCtxt passed in. This will panic if you pass it a TyCtxt which has a different global interner or a different local interner from the current ImplicitCtxt's tcx field.",null,{"inputs":[{"name":"tyctxt"},{"name":"f"}],"output":{"name":"r"}}],[5,"with","","Allows access to the TyCtxt in the current ImplicitCtxt. Panics if there is no ImplicitCtxt available",null,{"inputs":[{"name":"f"}],"output":{"name":"r"}}],[5,"with_opt","","Allows access to the TyCtxt in the current ImplicitCtxt. The closure is passed None if there is no ImplicitCtxt available",null,{"inputs":[{"name":"f"}],"output":{"name":"r"}}],[0,"adjustment","rustc::ty","",null,null],[3,"Adjustment","rustc::ty::adjustment","Represents coercing a value to a different type of value.",null,null],[12,"kind","","",715,null],[12,"target","","",715,null],[3,"OverloadedDeref","","An overloaded autoderef step, representing a `Deref(Mut)::deref(_mut)` call, with the signature `&'a T -> &'a U` or `&'a mut T -> &'a mut U`. The target type is `U` in both cases, with the region and mutability being those shared by both the receiver and the returned reference.",null,null],[12,"region","","",716,null],[12,"mutbl","","",716,null],[3,"CoerceUnsizedInfo","","Information for `CoerceUnsized` impls, storing information we have computed about the coercion.",null,null],[12,"custom_kind","","If this is a \"custom coerce\" impl, then what kind of custom coercion is it? This applies to impls of `CoerceUnsized` for structs, primarily, where we store a bit of info about which fields need to be coerced.",717,null],[4,"Adjust","","",null,null],[13,"NeverToAny","","Go from ! to any type.",718,null],[13,"ReifyFnPointer","","Go from a fn-item type to a fn-pointer type.",718,null],[13,"UnsafeFnPointer","","Go from a safe fn pointer to an unsafe fn pointer.",718,null],[13,"ClosureFnPointer","","Go from a non-capturing closure to an fn pointer.",718,null],[13,"MutToConstPointer","","Go from a mut raw pointer to a const raw pointer.",718,null],[13,"Deref","","Dereference once, producing a place.",718,null],[13,"Borrow","","Take the address and produce either a `&` or `*` pointer.",718,null],[13,"Unsize","","Unsize a pointer/reference value, e.g. `&[T; n]` to `&[T]`. Note that the source could be a thin or fat pointer. This will do things like convert thin pointers to fat pointers, or convert structs containing thin pointers to structs containing fat pointers, or convert betwee