var searchIndex = {};
searchIndex["aho_corasick"] = {"doc":"An implementation of the Aho-Corasick string search algorithm.","items":[[3,"Match","aho_corasick","Records a match in the search text.",null,null],[12,"pati","","The pattern index.",0,null],[12,"start","","The starting byte offset of the match in the search text.",0,null],[12,"end","","The ending byte offset of the match in the search text.",0,null],[3,"Matches","","An iterator of non-overlapping matches for in-memory text.",null,null],[12,"aut","","",1,null],[12,"text","","",1,null],[12,"texti","","",1,null],[12,"si","","",1,null],[12,"_m","","",1,null],[3,"MatchesOverlapping","","An iterator of overlapping matches for in-memory text.",null,null],[12,"aut","","",2,null],[12,"text","","",2,null],[12,"texti","","",2,null],[12,"si","","",2,null],[12,"outi","","",2,null],[12,"_m","","",2,null],[3,"StreamMatches","","An iterator of non-overlapping matches for streaming text.",null,null],[12,"aut","","",3,null],[12,"buf","","",3,null],[12,"texti","","",3,null],[12,"si","","",3,null],[12,"_m","","",3,null],[3,"StreamMatchesOverlapping","","An iterator of overlapping matches for streaming text.",null,null],[12,"aut","","",4,null],[12,"buf","","",4,null],[12,"texti","","",4,null],[12,"si","","",4,null],[12,"outi","","",4,null],[12,"_m","","",4,null],[3,"FullAcAutomaton","","A complete Aho-Corasick automaton.",null,null],[12,"pats","","",5,null],[12,"trans","","",5,null],[12,"out","","",5,null],[12,"start_bytes","","",5,null],[3,"AcAutomaton","","An Aho-Corasick finite automaton.",null,null],[12,"pats","","",6,null],[12,"states","","",6,null],[12,"start_bytes","","",6,null],[3,"State","","",null,null],[12,"out","","",7,null],[12,"fail","","",7,null],[12,"goto","","",7,null],[12,"depth","","",7,null],[3,"Dense","","State transitions that can be stored either sparsely or densely.",null,null],[12,"0","","",8,null],[3,"Sparse","","State transitions that are always sparse.",null,null],[12,"0","","",9,null],[4,"DenseChoice","","",null,null],[13,"Sparse","","",10,null],[13,"Dense","","",10,null],[5,"vec_bytes","","",null,{"o":{"n":"usize"}}],[5,"usize_bytes","","",null,{"o":{"n":"usize"}}],[0,"autiter","","",null,null],[3,"Match","aho_corasick::autiter","Records a match in the search text.",null,null],[12,"pati","","The pattern index.",0,null],[12,"start","","The starting byte offset of the match in the search text.",0,null],[12,"end","","The ending byte offset of the match in the search text.",0,null],[3,"Matches","","An iterator of non-overlapping matches for in-memory text.",null,null],[12,"aut","","",1,null],[12,"text","","",1,null],[12,"texti","","",1,null],[12,"si","","",1,null],[12,"_m","","",1,null],[3,"StreamMatches","","An iterator of non-overlapping matches for streaming text.",null,null],[12,"aut","","",3,null],[12,"buf","","",3,null],[12,"texti","","",3,null],[12,"si","","",3,null],[12,"_m","","",3,null],[3,"MatchesOverlapping","","An iterator of overlapping matches for in-memory text.",null,null],[12,"aut","","",2,null],[12,"text","","",2,null],[12,"texti","","",2,null],[12,"si","","",2,null],[12,"outi","","",2,null],[12,"_m","","",2,null],[3,"StreamMatchesOverlapping","","An iterator of overlapping matches for streaming text.",null,null],[12,"aut","","",4,null],[12,"buf","","",4,null],[12,"texti","","",4,null],[12,"si","","",4,null],[12,"outi","","",4,null],[12,"_m","","",4,null],[5,"step_to_match","","",null,null],[5,"skip_to_match","","",null,null],[5,"skip1","","",null,null],[5,"skip2","","",null,null],[5,"skip3","","",null,null],[8,"Automaton","","An abstraction over automatons and their corresponding iterators. The type parameter `P` is the type of the pattern that was used to construct this Automaton.",null,null],[10,"next_state","","Return the next state given the current state and next character.",11,{"i":[{"n":"self"},{"n":"stateidx"},{"n":"u8"}],"o":{"n":"stateidx"}}],[10,"has_match","","Return true if and only if the given state and current pattern index indicate a match.",11,{"i":[{"n":"self"},{"n":"stateidx"},{"n":"usize"}],"o":{"n":"bool"}}],[10,"get_match","","Build a match given the current state, pattern index and input index.",11,{"i":[{"n":"self"},{"n":"stateidx"},{"n":"usize"},{"n":"usize"}],"o":{"n":"match"}}],[10,"start_bytes","","Return the set of bytes that have transitions in the root state.",11,null],[10,"patterns","","Returns all of the patterns matched by this automaton.",11,null],[10,"pattern","","Returns the pattern indexed at `i`.",11,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"p"}}],[11,"len","","Return the number of patterns in the automaton.",11,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"is_empty","","Returns true if the automaton has no patterns.",11,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"find","","Returns an iterator of non-overlapping matches in `s`.",11,{"i":[{"n":"self"},{"n":"q"}],"o":{"n":"matches"}}],[11,"find_overlapping","","Returns an iterator of overlapping matches in `s`.",11,{"i":[{"n":"self"},{"n":"q"}],"o":{"n":"matchesoverlapping"}}],[11,"stream_find","","Returns an iterator of non-overlapping matches in the given reader.",11,{"i":[{"n":"self"},{"n":"r"}],"o":{"n":"streammatches"}}],[11,"stream_find_overlapping","","Returns an iterator of overlapping matches in the given reader.",11,{"i":[{"n":"self"},{"n":"r"}],"o":{"n":"streammatchesoverlapping"}}],[11,"clone","aho_corasick","",0,{"i":[{"n":"self"}],"o":{"n":"match"}}],[11,"fmt","","",0,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"hash","","",0,null],[11,"eq","","",0,{"i":[{"n":"self"},{"n":"match"}],"o":{"n":"bool"}}],[11,"ne","","",0,{"i":[{"n":"self"},{"n":"match"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",0,null],[11,"fmt","","",1,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",1,{"i":[{"n":"self"}],"o":{"g":["match"],"n":"option"}}],[11,"fmt","","",3,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",3,{"i":[{"n":"self"}],"o":{"g":["result"],"n":"option"}}],[11,"fmt","","",2,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",2,{"i":[{"n":"self"}],"o":{"g":["match"],"n":"option"}}],[11,"fmt","","",4,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",4,{"i":[{"n":"self"}],"o":{"g":["result"],"n":"option"}}],[0,"full","","",null,null],[3,"FullAcAutomaton","aho_corasick::full","A complete Aho-Corasick automaton.",null,null],[12,"pats","","",5,null],[12,"trans","","",5,null],[12,"out","","",5,null],[12,"start_bytes","","",5,null],[11,"clone","aho_corasick","",5,{"i":[{"n":"self"}],"o":{"n":"fullacautomaton"}}],[11,"new","","Build a new expanded Aho-Corasick automaton from an existing Aho-Corasick automaton.",5,{"i":[{"n":"acautomaton"}],"o":{"n":"fullacautomaton"}}],[11,"memory_usage","","",5,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"heap_bytes","","",5,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"set","","",5,{"i":[{"n":"self"},{"n":"stateidx"},{"n":"u8"},{"n":"stateidx"}]}],[11,"num_states","","",5,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"next_state","","",5,{"i":[{"n":"self"},{"n":"stateidx"},{"n":"u8"}],"o":{"n":"stateidx"}}],[11,"get_match","","",5,{"i":[{"n":"self"},{"n":"stateidx"},{"n":"usize"},{"n":"usize"}],"o":{"n":"match"}}],[11,"has_match","","",5,{"i":[{"n":"self"},{"n":"stateidx"},{"n":"usize"}],"o":{"n":"bool"}}],[11,"start_bytes","","",5,null],[11,"patterns","","",5,null],[11,"pattern","","",5,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"p"}}],[11,"build_matrix","","",5,{"i":[{"n":"self"},{"n":"acautomaton"}]}],[11,"fmt","","",5,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[6,"StateIdx","","The integer type used for the state index.",null,null],[17,"FAIL_STATE","","",null,null],[17,"ROOT_STATE","","",null,null],[17,"DENSE_DEPTH_THRESHOLD","","",null,null],[8,"Automaton","","An abstraction over automatons and their corresponding iterators. The type parameter `P` is the type of the pattern that was used to construct this Automaton.",null,null],[10,"next_state","","Return the next state given the current state and next character.",11,{"i":[{"n":"self"},{"n":"stateidx"},{"n":"u8"}],"o":{"n":"stateidx"}}],[10,"has_match","","Return true if and only if the given state and current pattern index indicate a match.",11,{"i":[{"n":"self"},{"n":"stateidx"},{"n":"usize"}],"o":{"n":"bool"}}],[10,"get_match","","Build a match given the current state, pattern index and input index.",11,{"i":[{"n":"self"},{"n":"stateidx"},{"n":"usize"},{"n":"usize"}],"o":{"n":"match"}}],[10,"start_bytes","","Return the set of bytes that have transitions in the root state.",11,null],[10,"patterns","","Returns all of the patterns matched by this automaton.",11,null],[10,"pattern","","Returns the pattern indexed at `i`.",11,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"p"}}],[11,"len","aho_corasick::autiter","Return the number of patterns in the automaton.",11,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"is_empty","","Returns true if the automaton has no patterns.",11,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"find","","Returns an iterator of non-overlapping matches in `s`.",11,{"i":[{"n":"self"},{"n":"q"}],"o":{"n":"matches"}}],[11,"find_overlapping","","Returns an iterator of overlapping matches in `s`.",11,{"i":[{"n":"self"},{"n":"q"}],"o":{"n":"matchesoverlapping"}}],[11,"stream_find","","Returns an iterator of non-overlapping matches in the given reader.",11,{"i":[{"n":"self"},{"n":"r"}],"o":{"n":"streammatches"}}],[11,"stream_find_overlapping","","Returns an iterator of overlapping matches in the given reader.",11,{"i":[{"n":"self"},{"n":"r"}],"o":{"n":"streammatchesoverlapping"}}],[8,"Transitions","aho_corasick","An abstraction over state transition strategies.",null,null],[10,"new","","Return a new state at the given depth.",12,{"i":[{"n":"u32"}],"o":{"n":"self"}}],[10,"goto","","Return the next state index given the next character.",12,{"i":[{"n":"self"},{"n":"u8"}],"o":{"n":"stateidx"}}],[10,"set_goto","","Set the next state index for the character given.",12,{"i":[{"n":"self"},{"n":"u8"},{"n":"stateidx"}]}],[10,"heap_bytes","","The memory use in bytes (on the heap) of this set of transitions.",12,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"clone","","",6,{"i":[{"n":"self"}],"o":{"n":"acautomaton"}}],[11,"clone","","",7,{"i":[{"n":"self"}],"o":{"n":"state"}}],[11,"new","","Create a new automaton from an iterator of patterns.",6,{"i":[{"n":"i"}],"o":{"g":["dense"],"n":"acautomaton"}}],[11,"with_transitions","","Create a new automaton from an iterator of patterns.",6,{"i":[{"n":"i"}],"o":{"n":"acautomaton"}}],[11,"into_full","","Build out the entire automaton into a single matrix.",6,{"i":[{"n":"self"}],"o":{"n":"fullacautomaton"}}],[11,"num_states","","",6,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"heap_bytes","","",6,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"next_state","","",6,{"i":[{"n":"self"},{"n":"stateidx"},{"n":"u8"}],"o":{"n":"stateidx"}}],[11,"get_match","","",6,{"i":[{"n":"self"},{"n":"stateidx"},{"n":"usize"},{"n":"usize"}],"o":{"n":"match"}}],[11,"has_match","","",6,{"i":[{"n":"self"},{"n":"stateidx"},{"n":"usize"}],"o":{"n":"bool"}}],[11,"start_bytes","","",6,null],[11,"patterns","","",6,null],[11,"pattern","","",6,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"p"}}],[11,"build","","",6,{"i":[{"n":"self"},{"n":"vec"}],"o":{"n":"acautomaton"}}],[11,"fill","","",6,{"i":[{"n":"self"}],"o":{"n":"acautomaton"}}],[11,"add_state","","",6,{"i":[{"n":"self"},{"n":"state"}],"o":{"n":"stateidx"}}],[11,"new","","",7,{"i":[{"n":"u32"}],"o":{"n":"state"}}],[11,"goto","","",7,{"i":[{"n":"self"},{"n":"u8"}],"o":{"n":"stateidx"}}],[11,"set_goto","","",7,{"i":[{"n":"self"},{"n":"u8"},{"n":"stateidx"}]}],[11,"heap_bytes","","",7,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"clone","","",8,{"i":[{"n":"self"}],"o":{"n":"dense"}}],[11,"fmt","","",8,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",10,{"i":[{"n":"self"}],"o":{"n":"densechoice"}}],[11,"fmt","","",10,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","",8,{"i":[{"n":"u32"}],"o":{"n":"dense"}}],[11,"goto","","",8,{"i":[{"n":"self"},{"n":"u8"}],"o":{"n":"stateidx"}}],[11,"set_goto","","",8,{"i":[{"n":"self"},{"n":"u8"},{"n":"stateidx"}]}],[11,"heap_bytes","","",8,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"clone","","",9,{"i":[{"n":"self"}],"o":{"n":"sparse"}}],[11,"fmt","","",9,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","",9,{"i":[{"n":"u32"}],"o":{"n":"sparse"}}],[11,"goto","","",9,{"i":[{"n":"self"},{"n":"u8"}],"o":{"n":"stateidx"}}],[11,"set_goto","","",9,{"i":[{"n":"self"},{"n":"u8"},{"n":"stateidx"}]}],[11,"heap_bytes","","",9,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"from_iter","","Create an automaton from an iterator of strings.",6,{"i":[{"n":"t"}],"o":{"n":"acautomaton"}}],[11,"fmt","","",6,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"debug","","",7,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"string"}}],[11,"goto_string","","",7,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"string"}}],[11,"fmt","","",7,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"dot","","",6,{"i":[{"n":"self"}],"o":{"n":"string"}}]],"paths":[[3,"Match"],[3,"Matches"],[3,"MatchesOverlapping"],[3,"StreamMatches"],[3,"StreamMatchesOverlapping"],[3,"FullAcAutomaton"],[3,"AcAutomaton"],[3,"State"],[3,"Dense"],[3,"Sparse"],[4,"DenseChoice"],[8,"Automaton"],[8,"Transitions"]]};
searchIndex["arena"] = {"doc":"The arena, a fast but limited type of allocator.","items":[[3,"TypedArena","arena","An arena that can hold objects of only one type.",null,null],[12,"ptr","","A pointer to the next object to be allocated.",0,null],[12,"end","","A pointer to the end of the allocated area. When this pointer is reached, a new chunk is allocated.",0,null],[12,"chunks","","A vector of arena chunks.",0,null],[12,"_own","","Marker indicating that dropping the arena causes its owned instances of `T` to be dropped.",0,null],[3,"TypedArenaChunk","","",null,null],[12,"storage","","The raw storage for the arena chunk.",1,null],[3,"DroplessArena","","",null,null],[12,"ptr","","A pointer to the next object to be allocated.",2,null],[12,"end","","A pointer to the end of the allocated area. When this pointer is reached, a new chunk is allocated.",2,null],[12,"chunks","","A vector of arena chunks.",2,null],[3,"SyncTypedArena","","",null,null],[12,"lock","","",3,null],[3,"SyncDroplessArena","","",null,null],[12,"lock","","",4,null],[17,"PAGE","","",null,null],[11,"new","","",1,{"i":[{"n":"usize"}],"o":{"n":"typedarenachunk"}}],[11,"destroy","","Destroys this arena chunk.",1,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"start","","",1,null],[11,"end","","",1,null],[11,"new","","Creates a new `TypedArena`.",0,{"o":{"n":"typedarena"}}],[11,"alloc","","Allocates an object in the `TypedArena`, returning a reference to it.",0,{"i":[{"n":"self"},{"n":"t"}],"o":{"n":"t"}}],[11,"alloc_slice","","Allocates a slice of objects that are copied into the `TypedArena`, returning a mutable reference to it. Will panic if passed a zero-sized types.",0,null],[11,"grow","","Grows the arena.",0,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"clear","","Clears the arena. Deallocates all but the longest chunk which may be reused.",0,{"i":[{"n":"self"}]}],[11,"clear_last_chunk","","",0,{"i":[{"n":"self"},{"n":"typedarenachunk"}]}],[11,"drop","","",0,{"i":[{"n":"self"}]}],[11,"new","","",2,{"o":{"n":"droplessarena"}}],[11,"in_arena","","",2,null],[11,"align","","",2,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"grow","","",2,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"alloc_raw","","",2,null],[11,"alloc","","",2,{"i":[{"n":"self"},{"n":"t"}],"o":{"n":"t"}}],[11,"alloc_slice","","Allocates a slice of objects that are copied into the `DroplessArena`, returning a mutable reference to it. Will panic if passed a zero-sized type.",2,null],[11,"new","","",3,{"o":{"n":"synctypedarena"}}],[11,"alloc","","",3,{"i":[{"n":"self"},{"n":"t"}],"o":{"n":"t"}}],[11,"alloc_slice","","",3,null],[11,"clear","","",3,{"i":[{"n":"self"}]}],[11,"new","","",4,{"o":{"n":"syncdroplessarena"}}],[11,"in_arena","","",4,null],[11,"alloc_raw","","",4,null],[11,"alloc","","",4,{"i":[{"n":"self"},{"n":"t"}],"o":{"n":"t"}}],[11,"alloc_slice","","",4,null]],"paths":[[3,"TypedArena"],[3,"TypedArenaChunk"],[3,"DroplessArena"],[3,"SyncTypedArena"],[3,"SyncDroplessArena"]]};
searchIndex["bitflags"] = {"doc":"A typesafe bitmask flag generator useful for sets of C-style bitmask flags. It can be used for creating typesafe wrappers around C APIs.","items":[[0,"example_generated","bitflags","This module shows an example of code generated by the macro. IT MUST NOT BE USED OUTSIDE THIS CRATE.",null,null],[3,"Flags","bitflags::example_generated","This is the same `Flags` struct defined in the crate level example. Note that this struct is just for documentation purposes only, it must not be used outside this crate.",null,null],[12,"bits","","",0,null],[17,"FLAG_A","","",null,null],[17,"FLAG_B","","",null,null],[17,"FLAG_C","","",null,null],[17,"FLAG_ABC","","",null,null],[11,"eq","","",0,{"i":[{"n":"self"},{"n":"flags"}],"o":{"n":"bool"}}],[11,"ne","","",0,{"i":[{"n":"self"},{"n":"flags"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",0,null],[11,"clone","","",0,{"i":[{"n":"self"}],"o":{"n":"flags"}}],[11,"partial_cmp","","",0,{"i":[{"n":"self"},{"n":"flags"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",0,{"i":[{"n":"self"},{"n":"flags"}],"o":{"n":"bool"}}],[11,"le","","",0,{"i":[{"n":"self"},{"n":"flags"}],"o":{"n":"bool"}}],[11,"gt","","",0,{"i":[{"n":"self"},{"n":"flags"}],"o":{"n":"bool"}}],[11,"ge","","",0,{"i":[{"n":"self"},{"n":"flags"}],"o":{"n":"bool"}}],[11,"cmp","","",0,{"i":[{"n":"self"},{"n":"flags"}],"o":{"n":"ordering"}}],[11,"hash","","",0,null],[11,"fmt","","",0,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",0,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",0,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",0,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",0,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"empty","","Returns an empty set of flags.",0,{"o":{"n":"flags"}}],[11,"all","","Returns the set containing all flags.",0,{"o":{"n":"flags"}}],[11,"bits","","Returns the raw value of the flags currently stored.",0,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"from_bits","","Convert from underlying bit representation, unless that representation contains bits that do not correspond to a flag.",0,{"i":[{"n":"u32"}],"o":{"g":["flags"],"n":"option"}}],[11,"from_bits_truncate","","Convert from underlying bit representation, dropping any bits that do not correspond to flags.",0,{"i":[{"n":"u32"}],"o":{"n":"flags"}}],[11,"is_empty","","Returns `true` if no flags are currently stored.",0,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"is_all","","Returns `true` if all flags are currently set.",0,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"intersects","","Returns `true` if there are flags common to both `self` and `other`.",0,{"i":[{"n":"self"},{"n":"flags"}],"o":{"n":"bool"}}],[11,"contains","","Returns `true` all of the flags in `other` are contained within `self`.",0,{"i":[{"n":"self"},{"n":"flags"}],"o":{"n":"bool"}}],[11,"insert","","Inserts the specified flags in-place.",0,{"i":[{"n":"self"},{"n":"flags"}]}],[11,"remove","","Removes the specified flags in-place.",0,{"i":[{"n":"self"},{"n":"flags"}]}],[11,"toggle","","Toggles the specified flags in-place.",0,{"i":[{"n":"self"},{"n":"flags"}]}],[11,"set","","Inserts or removes the specified flags depending on the passed value.",0,{"i":[{"n":"self"},{"n":"flags"},{"n":"bool"}]}],[11,"bitor","","Returns the union of the two sets of flags.",0,{"i":[{"n":"self"},{"n":"flags"}],"o":{"n":"flags"}}],[11,"bitor_assign","","Adds the set of flags.",0,{"i":[{"n":"self"},{"n":"flags"}]}],[11,"bitxor","","Returns the left flags, but with all the right flags toggled.",0,{"i":[{"n":"self"},{"n":"flags"}],"o":{"n":"flags"}}],[11,"bitxor_assign","","Toggles the set of flags.",0,{"i":[{"n":"self"},{"n":"flags"}]}],[11,"bitand","","Returns the intersection between the two sets of flags.",0,{"i":[{"n":"self"},{"n":"flags"}],"o":{"n":"flags"}}],[11,"bitand_assign","","Disables all flags disabled in the set.",0,{"i":[{"n":"self"},{"n":"flags"}]}],[11,"sub","","Returns the set difference of the two sets of flags.",0,{"i":[{"n":"self"},{"n":"flags"}],"o":{"n":"flags"}}],[11,"sub_assign","","Disables all flags enabled in the set.",0,{"i":[{"n":"self"},{"n":"flags"}]}],[11,"not","","Returns the complement of this set of flags.",0,{"i":[{"n":"self"}],"o":{"n":"flags"}}],[11,"extend","","",0,{"i":[{"n":"self"},{"n":"t"}]}],[11,"from_iter","","",0,{"i":[{"n":"t"}],"o":{"n":"flags"}}],[14,"bitflags","bitflags","The macro used to generate the flag structure.",null,null],[14,"__impl_bitflags","","",null,null]],"paths":[[3,"Flags"]]};
searchIndex["fmt_macros"] = {"doc":"Macro support for format strings","items":[[3,"Argument","fmt_macros","Representation of an argument specification.",null,null],[12,"position","","Where to find this argument",0,null],[12,"format","","How to format the argument",0,null],[3,"FormatSpec","","Specification for the formatting of an argument in the format string.",null,null],[12,"fill","","Optionally specified character to fill alignment with",1,null],[12,"align","","Optionally specified alignment",1,null],[12,"flags","","Packed version of various flags provided",1,null],[12,"precision","","The integer precision to use",1,null],[12,"width","","The string width requested for the resulting format",1,null],[12,"ty","","The descriptor string representing the name of the format desired for this argument, this can be empty or any number of characters, although it is required to be one word.",1,null],[3,"ParseError","","",null,null],[12,"description","","",2,null],[12,"note","","",2,null],[12,"label","","",2,null],[12,"start","","",2,null],[12,"end","","",2,null],[3,"Parser","","The parser structure for interpreting the input format string. This is modeled as an iterator over `Piece` structures to form a stream of tokens being output.",null,null],[12,"input","","",3,null],[12,"cur","","",3,null],[12,"errors","","Error messages accumulated during parsing",3,null],[12,"curarg","","Current position of implicit positional argument pointer",3,null],[4,"Piece","","A piece is a portion of the format string which represents the next part to emit. These are emitted as a stream by the `Parser` class.",null,null],[13,"String","","A literal string which should directly be emitted",4,null],[13,"NextArgument","","This describes that formatting should process the next argument (as specified inside) for emission.",4,null],[4,"Position","","Enum describing where an argument for a format can be located.",null,null],[13,"ArgumentImplicitlyIs","","The argument is implied to be located at an index",5,null],[13,"ArgumentIs","","The argument is located at a specific index given in the format",5,null],[13,"ArgumentNamed","","The argument has a name.",5,null],[4,"Alignment","","Enum of alignments which are supported.",null,null],[13,"AlignLeft","","The value will be aligned to the left.",6,null],[13,"AlignRight","","The value will be aligned to the right.",6,null],[13,"AlignCenter","","The value will be aligned in the center.",6,null],[13,"AlignUnknown","","The value will take on a default alignment.",6,null],[4,"Flag","","Various flags which can be applied to format strings. The meaning of these flags is defined by the formatters themselves.",null,null],[13,"FlagSignPlus","","A `+` will be used to denote positive numbers.",7,null],[13,"FlagSignMinus","","A `-` will be used to denote negative numbers. This is the default.",7,null],[13,"FlagAlternate","","An alternate form will be used for the value. In the case of numbers, this means that the number will be prefixed with the supplied string.",7,null],[13,"FlagSignAwareZeroPad","","For numbers, this means that the number will be padded with zeroes, and the sign (`+` or `-`) will precede them.",7,null],[13,"FlagDebugLowerHex","","For Debug / `?`, format integers in lower-case hexadecimal.",7,null],[13,"FlagDebugUpperHex","","For Debug / `?`, format integers in upper-case hexadecimal.",7,null],[4,"Count","","A count is used for the precision and width parameters of an integer, and can reference either an argument or a literal integer.",null,null],[13,"CountIs","","The count is specified explicitly.",8,null],[13,"CountIsName","","The count is specified by the argument with the given name.",8,null],[13,"CountIsParam","","The count is specified by the argument at the given index.",8,null],[13,"CountImplied","","The count is implied and cannot be explicitly specified.",8,null],[11,"clone","","",4,{"i":[{"n":"self"}],"o":{"n":"piece"}}],[11,"eq","","",4,{"i":[{"n":"self"},{"n":"piece"}],"o":{"n":"bool"}}],[11,"ne","","",4,{"i":[{"n":"self"},{"n":"piece"}],"o":{"n":"bool"}}],[11,"clone","","",0,{"i":[{"n":"self"}],"o":{"n":"argument"}}],[11,"eq","","",0,{"i":[{"n":"self"},{"n":"argument"}],"o":{"n":"bool"}}],[11,"ne","","",0,{"i":[{"n":"self"},{"n":"argument"}],"o":{"n":"bool"}}],[11,"clone","","",1,{"i":[{"n":"self"}],"o":{"n":"formatspec"}}],[11,"eq","","",1,{"i":[{"n":"self"},{"n":"formatspec"}],"o":{"n":"bool"}}],[11,"ne","","",1,{"i":[{"n":"self"},{"n":"formatspec"}],"o":{"n":"bool"}}],[11,"clone","","",5,{"i":[{"n":"self"}],"o":{"n":"position"}}],[11,"eq","","",5,{"i":[{"n":"self"},{"n":"position"}],"o":{"n":"bool"}}],[11,"ne","","",5,{"i":[{"n":"self"},{"n":"position"}],"o":{"n":"bool"}}],[11,"clone","","",6,{"i":[{"n":"self"}],"o":{"n":"alignment"}}],[11,"eq","","",6,{"i":[{"n":"self"},{"n":"alignment"}],"o":{"n":"bool"}}],[11,"clone","","",7,{"i":[{"n":"self"}],"o":{"n":"flag"}}],[11,"eq","","",7,{"i":[{"n":"self"},{"n":"flag"}],"o":{"n":"bool"}}],[11,"clone","","",8,{"i":[{"n":"self"}],"o":{"n":"count"}}],[11,"eq","","",8,{"i":[{"n":"self"},{"n":"count"}],"o":{"n":"bool"}}],[11,"ne","","",8,{"i":[{"n":"self"},{"n":"count"}],"o":{"n":"bool"}}],[11,"next","","",3,{"i":[{"n":"self"}],"o":{"g":["piece"],"n":"option"}}],[11,"new","","Creates a new parser for the given format string",3,{"i":[{"n":"str"}],"o":{"n":"parser"}}],[11,"err","","Notifies of an error. The message doesn't actually need to be of type String, but I think it does when this eventually uses conditions so it might as well start using it now.",3,{"i":[{"n":"self"},{"n":"s1"},{"n":"s2"},{"n":"usize"},{"n":"usize"}]}],[11,"err_with_note","","Notifies of an error. The message doesn't actually need to be of type String, but I think it does when this eventually uses conditions so it might as well start using it now.",3,{"i":[{"n":"self"},{"n":"s1"},{"n":"s2"},{"n":"s3"},{"n":"usize"},{"n":"usize"}]}],[11,"consume","","Optionally consumes the specified character. If the character is not at the current position, then the current iterator isn't moved and false is returned, otherwise the character is consumed and true is returned.",3,{"i":[{"n":"self"},{"n":"char"}],"o":{"n":"bool"}}],[11,"must_consume","","Forces consumption of the specified character. If the character is not found, an error is emitted.",3,{"i":[{"n":"self"},{"n":"char"}]}],[11,"ws","","Consumes all whitespace characters until the first non-whitespace character",3,{"i":[{"n":"self"}]}],[11,"string","","Parses all of a string which is to be considered a \"raw literal\" in a format string. This is everything outside of the braces.",3,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"str"}}],[11,"argument","","Parses an Argument structure, or what's contained within braces inside the format string",3,{"i":[{"n":"self"}],"o":{"n":"argument"}}],[11,"position","","Parses a positional argument for a format. This could either be an integer index of an argument, a named argument, or a blank string. Returns `Some(parsed_position)` if the position is not implicitly consuming a macro argument, `None` if it's the case.",3,{"i":[{"n":"self"}],"o":{"g":["position"],"n":"option"}}],[11,"format","","Parses a format specifier at the current position, returning all of the relevant information in the FormatSpec struct.",3,{"i":[{"n":"self"}],"o":{"n":"formatspec"}}],[11,"count","","Parses a Count parameter at the current position. This does not check for 'CountIsNextParam' because that is only used in precision, not width.",3,{"i":[{"n":"self"}],"o":{"n":"count"}}],[11,"word","","Parses a word starting at the current position. A word is considered to be an alphabetic character followed by any number of alphanumeric characters.",3,{"i":[{"n":"self"}],"o":{"n":"str"}}],[11,"integer","","Optionally parses an integer at the current position. This doesn't deal with overflow at all, it's just accumulating digits.",3,{"i":[{"n":"self"}],"o":{"g":["usize"],"n":"option"}}]],"paths":[[3,"Argument"],[3,"FormatSpec"],[3,"ParseError"],[3,"Parser"],[4,"Piece"],[4,"Position"],[4,"Alignment"],[4,"Flag"],[4,"Count"]]};
searchIndex["graphviz"] = {"doc":"Generate files suitable for use with Graphviz","items":[[3,"Id","graphviz","`Id` is a Graphviz `ID`.",null,null],[12,"name","","",0,null],[4,"LabelText","","The text for a graphviz label on a node or edge.",null,null],[13,"LabelStr","","This kind of label preserves the text directly as is.",1,null],[13,"EscStr","","This kind of label uses the graphviz label escString type: http://www.graphviz.org/content/attrs#kescString",1,null],[13,"HtmlStr","","This uses a graphviz [HTML string label][html]. The string is printed exactly as given, but between `<` and `>`. No escaping is performed.",1,null],[4,"Style","","The style for a node or edge. See http://www.graphviz.org/doc/info/attrs.html#k:style for descriptions. Note that some of these are not valid for edges.",null,null],[13,"None","","",2,null],[13,"Solid","","",2,null],[13,"Dashed","","",2,null],[13,"Dotted","","",2,null],[13,"Bold","","",2,null],[13,"Rounded","","",2,null],[13,"Diagonals","","",2,null],[13,"Filled","","",2,null],[13,"Striped","","",2,null],[13,"Wedged","","",2,null],[4,"RenderOption","","",null,null],[13,"NoEdgeLabels","","",3,null],[13,"NoNodeLabels","","",3,null],[13,"NoEdgeStyles","","",3,null],[13,"NoNodeStyles","","",3,null],[5,"escape_html","","Escape tags in such a way that it is suitable for inclusion in a Graphviz HTML label.",null,{"i":[{"n":"str"}],"o":{"n":"string"}}],[5,"default_options","","Returns vec holding all the default render options.",null,{"o":{"g":["renderoption"],"n":"vec"}}],[5,"render","","Renders directed graph `g` into the writer `w` in DOT syntax. (Simple wrapper around `render_opts` that passes a default set of options.)",null,{"i":[{"n":"g"},{"n":"w"}],"o":{"n":"result"}}],[5,"render_opts","","Renders directed graph `g` into the writer `w` in DOT syntax. (Main entry point for the library.)",null,null],[6,"Nodes","","",null,null],[6,"Edges","","",null,null],[8,"Labeller","","Each instance of a type that implements `Label<C>` maps to a unique identifier with respect to `C`, which is used to identify it in the generated .dot file. They can also provide more elaborate (and non-unique) label text that is used in the graphviz rendered output. The graph instance is responsible for providing the DOT compatible identifiers for the nodes and (optionally) rendered labels for the nodes and edges, as well as an identifier for the graph itself.",null,null],[16,"Node","","",4,null],[16,"Edge","","",4,null],[10,"graph_id","","Must return a DOT compatible identifier naming the graph.",4,{"i":[{"n":"self"}],"o":{"n":"id"}}],[10,"node_id","","Maps `n` to a unique identifier with respect to `self`. The implementor is responsible for ensuring that the returned name is a valid DOT identifier.",4,null],[11,"node_shape","","Maps `n` to one of the [graphviz `shape` names][1]. If `None` is returned, no `shape` attribute is specified.",4,null],[11,"node_label","","Maps `n` to a label that will be used in the rendered output. The label need not be unique, and may be the empty string; the default is just the output from `node_id`.",4,null],[11,"edge_label","","Maps `e` to a label that will be used in the rendered output. The label need not be unique, and may be the empty string; the default is in fact the empty string.",4,null],[11,"node_style","","Maps `n` to a style that will be used in the rendered output.",4,null],[11,"edge_style","","Maps `e` to a style that will be used in the rendered output.",4,null],[8,"GraphWalk","","GraphWalk is an abstraction over a directed graph = (nodes,edges) made up of node handles `N` and edge handles `E`, where each `E` can be mapped to its source and target nodes.",null,null],[16,"Node","","",5,null],[16,"Edge","","",5,null],[10,"nodes","","Returns all the nodes in this graph.",5,{"i":[{"n":"self"}],"o":{"n":"nodes"}}],[10,"edges","","Returns all of the edges in this graph.",5,{"i":[{"n":"self"}],"o":{"n":"edges"}}],[10,"source","","The source node for `edge`.",5,null],[10,"target","","The target node for `edge`.",5,null],[8,"IntoCow","","",null,null],[10,"into_cow","","",6,{"i":[{"n":"self"}],"o":{"n":"cow"}}],[11,"clone","","",2,{"i":[{"n":"self"}],"o":{"n":"style"}}],[11,"eq","","",2,{"i":[{"n":"self"},{"n":"style"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",2,null],[11,"fmt","","",2,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"as_slice","","",2,{"i":[{"n":"self"}],"o":{"n":"str"}}],[11,"new","","Creates an `Id` named `name`.",0,{"i":[{"n":"name"}],"o":{"g":["id"],"n":"result"}}],[11,"as_slice","","",0,{"i":[{"n":"self"}],"o":{"n":"str"}}],[11,"name","","",0,{"i":[{"n":"self"}],"o":{"g":["str"],"n":"cow"}}],[11,"label","","",1,{"i":[{"n":"s"}],"o":{"n":"labeltext"}}],[11,"escaped","","",1,{"i":[{"n":"s"}],"o":{"n":"labeltext"}}],[11,"html","","",1,{"i":[{"n":"s"}],"o":{"n":"labeltext"}}],[11,"escape_char","","",1,{"i":[{"n":"char"},{"n":"f"}]}],[11,"escape_str","","",1,{"i":[{"n":"str"}],"o":{"n":"string"}}],[11,"to_dot_string","","Renders text as string suitable for a label in a .dot file. This includes quotes or suitable delimiters.",1,{"i":[{"n":"self"}],"o":{"n":"string"}}],[11,"pre_escaped_content","","Decomposes content into string suitable for making EscStr that yields same content as self.  The result obeys the law render(`lt`) == render(`EscStr(lt.pre_escaped_content())`) for all `lt: LabelText`.",1,{"i":[{"n":"self"}],"o":{"g":["str"],"n":"cow"}}],[11,"prefix_line","","Puts `prefix` on a line above this label, with a blank line separator.",1,{"i":[{"n":"self"},{"n":"labeltext"}],"o":{"n":"labeltext"}}],[11,"suffix_line","","Puts `suffix` on a line below this label, with a blank line separator.",1,{"i":[{"n":"self"},{"n":"labeltext"}],"o":{"n":"labeltext"}}],[11,"clone","","",3,{"i":[{"n":"self"}],"o":{"n":"renderoption"}}],[11,"eq","","",3,{"i":[{"n":"self"},{"n":"renderoption"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",3,null],[11,"fmt","","",3,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}]],"paths":[[3,"Id"],[4,"LabelText"],[4,"Style"],[4,"RenderOption"],[8,"Labeller"],[8,"GraphWalk"],[8,"IntoCow"]]};
searchIndex["lazy_static"] = {"doc":"A macro for declaring lazily evaluated statics.","items":[[5,"initialize","lazy_static","Takes a shared reference to a lazy static and initializes it if it has not been already.",null,{"i":[{"n":"t"}]}],[0,"lazy","","",null,null],[17,"ONCE_INIT","lazy_static::lazy","Initialization value for static [`Once`] values.",null,null],[3,"Lazy","","",null,null],[12,"0","","",0,null],[12,"1","","",0,null],[11,"get","","",0,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"t"}}],[8,"LazyStatic","lazy_static","Support trait for enabling a few common operation on lazy static values.",null,null],[10,"initialize","","",1,{"i":[{"n":"self"}]}],[14,"__lazy_static_create","","",null,null],[14,"__lazy_static_internal","","",null,null],[14,"lazy_static","","",null,null]],"paths":[[3,"Lazy"],[8,"LazyStatic"]]};
searchIndex["libc"] = {"doc":"Crate docs","items":[[3,"group","libc","",null,null],[12,"gr_name","","",0,null],[12,"gr_passwd","","",0,null],[12,"gr_gid","","",0,null],[12,"gr_mem","","",0,null],[3,"utimbuf","","",null,null],[12,"actime","","",1,null],[12,"modtime","","",1,null],[3,"timeval","","",null,null],[12,"tv_sec","","",2,null],[12,"tv_usec","","",2,null],[3,"timespec","","",null,null],[12,"tv_sec","","",3,null],[12,"tv_nsec","","",3,null],[3,"rlimit","","",null,null],[12,"rlim_cur","","",4,null],[12,"rlim_max","","",4,null],[3,"rusage","","",null,null],[12,"ru_utime","","",5,null],[12,"ru_stime","","",5,null],[12,"ru_maxrss","","",5,null],[12,"ru_ixrss","","",5,null],[12,"ru_idrss","","",5,null],[12,"ru_isrss","","",5,null],[12,"ru_minflt","","",5,null],[12,"ru_majflt","","",5,null],[12,"ru_nswap","","",5,null],[12,"ru_inblock","","",5,null],[12,"ru_oublock","","",5,null],[12,"ru_msgsnd","","",5,null],[12,"ru_msgrcv","","",5,null],[12,"ru_nsignals","","",5,null],[12,"ru_nvcsw","","",5,null],[12,"ru_nivcsw","","",5,null],[3,"in_addr","","",null,null],[12,"s_addr","","",6,null],[3,"in6_addr","","",null,null],[12,"s6_addr","","",7,null],[12,"__align","","",7,null],[3,"ip_mreq","","",null,null],[12,"imr_multiaddr","","",8,null],[12,"imr_interface","","",8,null],[3,"ipv6_mreq","","",null,null],[12,"ipv6mr_multiaddr","","",9,null],[12,"ipv6mr_interface","","",9,null],[3,"hostent","","",null,null],[12,"h_name","","",10,null],[12,"h_aliases","","",10,null],[12,"h_addrtype","","",10,null],[12,"h_length","","",10,null],[12,"h_addr_list","","",10,null],[3,"iovec","","",null,null],[12,"iov_base","","",11,null],[12,"iov_len","","",11,null],[3,"pollfd","","",null,null],[12,"fd","","",12,null],[12,"events","","",12,null],[12,"revents","","",12,null],[3,"winsize","","",null,null],[12,"ws_row","","",13,null],[12,"ws_col","","",13,null],[12,"ws_xpixel","","",13,null],[12,"ws_ypixel","","",13,null],[3,"linger","","",null,null],[12,"l_onoff","","",14,null],[12,"l_linger","","",14,null],[3,"sigval","","",null,null],[12,"sival_ptr","","",15,null],[3,"itimerval","","",null,null],[12,"it_interval","","",16,null],[12,"it_value","","",16,null],[3,"tms","","",null,null],[12,"tms_utime","","",17,null],[12,"tms_stime","","",17,null],[12,"tms_cutime","","",17,null],[12,"tms_cstime","","",17,null],[3,"servent","","",null,null],[12,"s_name","","",18,null],[12,"s_aliases","","",18,null],[12,"s_port","","",18,null],[12,"s_proto","","",18,null],[3,"protoent","","",null,null],[12,"p_name","","",19,null],[12,"p_aliases","","",19,null],[12,"p_proto","","",19,null],[3,"sockaddr","","",null,null],[12,"sa_family","","",20,null],[12,"sa_data","","",20,null],[3,"sockaddr_in","","",null,null],[12,"sin_family","","",21,null],[12,"sin_port","","",21,null],[12,"sin_addr","","",21,null],[12,"sin_zero","","",21,null],[3,"sockaddr_in6","","",null,null],[12,"sin6_family","","",22,null],[12,"sin6_port","","",22,null],[12,"sin6_flowinfo","","",22,null],[12,"sin6_addr","","",22,null],[12,"sin6_scope_id","","",22,null],[3,"sockaddr_un","","",null,null],[12,"sun_family","","",23,null],[12,"sun_path","","",23,null],[3,"sockaddr_storage","","",null,null],[12,"ss_family","","",24,null],[12,"__ss_align","","",24,null],[12,"__ss_pad2","","",24,null],[3,"addrinfo","","",null,null],[12,"ai_flags","","",25,null],[12,"ai_family","","",25,null],[12,"ai_socktype","","",25,null],[12,"ai_protocol","","",25,null],[12,"ai_addrlen","","",25,null],[12,"ai_addr","","",25,null],[12,"ai_canonname","","",25,null],[12,"ai_next","","",25,null],[3,"sockaddr_nl","","",null,null],[12,"nl_family","","",26,null],[12,"nl_pad","","",26,null],[12,"nl_pid","","",26,null],[12,"nl_groups","","",26,null],[3,"sockaddr_ll","","",null,null],[12,"sll_family","","",27,null],[12,"sll_protocol","","",27,null],[12,"sll_ifindex","","",27,null],[12,"sll_hatype","","",27,null],[12,"sll_pkttype","","",27,null],[12,"sll_halen","","",27,null],[12,"sll_addr","","",27,null],[3,"fd_set","","",null,null],[12,"fds_bits","","",28,null],[3,"tm","","",null,null],[12,"tm_sec","","",29,null],[12,"tm_min","","",29,null],[12,"tm_hour","","",29,null],[12,"tm_mday","","",29,null],[12,"tm_mon","","",29,null],[12,"tm_year","","",29,null],[12,"tm_wday","","",29,null],[12,"tm_yday","","",29,null],[12,"tm_isdst","","",29,null],[12,"tm_gmtoff","","",29,null],[12,"tm_zone","","",29,null],[3,"sched_param","","",null,null],[12,"sched_priority","","",30,null],[3,"Dl_info","","",null,null],[12,"dli_fname","","",31,null],[12,"dli_fbase","","",31,null],[12,"dli_sname","","",31,null],[12,"dli_saddr","","",31,null],[3,"epoll_event","","",null,null],[12,"events","","",32,null],[12,"u64","","",32,null],[3,"utsname","","",null,null],[12,"sysname","","",33,null],[12,"nodename","","",33,null],[12,"release","","",33,null],[12,"version","","",33,null],[12,"machine","","",33,null],[12,"domainname","","",33,null],[3,"lconv","","",null,null],[12,"decimal_point","","",34,null],[12,"thousands_sep","","",34,null],[12,"grouping","","",34,null],[12,"int_curr_symbol","","",34,null],[12,"currency_symbol","","",34,null],[12,"mon_decimal_point","","",34,null],[12,"mon_thousands_sep","","",34,null],[12,"mon_grouping","","",34,null],[12,"positive_sign","","",34,null],[12,"negative_sign","","",34,null],[12,"int_frac_digits","","",34,null],[12,"frac_digits","","",34,null],[12,"p_cs_precedes","","",34,null],[12,"p_sep_by_space","","",34,null],[12,"n_cs_precedes","","",34,null],[12,"n_sep_by_space","","",34,null],[12,"p_sign_posn","","",34,null],[12,"n_sign_posn","","",34,null],[12,"int_p_cs_precedes","","",34,null],[12,"int_p_sep_by_space","","",34,null],[12,"int_n_cs_precedes","","",34,null],[12,"int_n_sep_by_space","","",34,null],[12,"int_p_sign_posn","","",34,null],[12,"int_n_sign_posn","","",34,null],[3,"sigevent","","",null,null],[12,"sigev_value","","",35,null],[12,"sigev_signo","","",35,null],[12,"sigev_notify","","",35,null],[12,"sigev_notify_thread_id","","",35,null],[12,"__unused1","","",35,null],[3,"dirent","","",null,null],[12,"d_ino","","",36,null],[12,"d_off","","",36,null],[12,"d_reclen","","",36,null],[12,"d_type","","",36,null],[12,"d_name","","",36,null],[3,"dirent64","","",null,null],[12,"d_ino","","",37,null],[12,"d_off","","",37,null],[12,"d_reclen","","",37,null],[12,"d_type","","",37,null],[12,"d_name","","",37,null],[3,"rlimit64","","",null,null],[12,"rlim_cur","","",38,null],[12,"rlim_max","","",38,null],[3,"glob_t","","",null,null],[12,"gl_pathc","","",39,null],[12,"gl_pathv","","",39,null],[12,"gl_offs","","",39,null],[12,"gl_flags","","",39,null],[12,"__unused1","","",39,null],[12,"__unused2","","",39,null],[12,"__unused3","","",39,null],[12,"__unused4","","",39,null],[12,"__unused5","","",39,null],[3,"ifaddrs","","",null,null],[12,"ifa_next","","",40,null],[12,"ifa_name","","",40,null],[12,"ifa_flags","","",40,null],[12,"ifa_addr","","",40,null],[12,"ifa_netmask","","",40,null],[12,"ifa_ifu","","",40,null],[12,"ifa_data","","",40,null],[3,"pthread_mutex_t","","",null,null],[12,"__align","","",41,null],[12,"size","","",41,null],[3,"pthread_rwlock_t","","",null,null],[12,"__align","","",42,null],[12,"size","","",42,null],[3,"pthread_mutexattr_t","","",null,null],[12,"__align","","",43,null],[12,"size","","",43,null],[3,"pthread_rwlockattr_t","","",null,null],[12,"__align","","",44,null],[12,"size","","",44,null],[3,"pthread_cond_t","","",null,null],[12,"__align","","",45,null],[12,"size","","",45,null],[3,"pthread_condattr_t","","",null,null],[12,"__align","","",46,null],[12,"size","","",46,null],[3,"passwd","","",null,null],[12,"pw_name","","",47,null],[12,"pw_passwd","","",47,null],[12,"pw_uid","","",47,null],[12,"pw_gid","","",47,null],[12,"pw_gecos","","",47,null],[12,"pw_dir","","",47,null],[12,"pw_shell","","",47,null],[3,"spwd","","",null,null],[12,"sp_namp","","",48,null],[12,"sp_pwdp","","",48,null],[12,"sp_lstchg","","",48,null],[12,"sp_min","","",48,null],[12,"sp_max","","",48,null],[12,"sp_warn","","",48,null],[12,"sp_inact","","",48,null],[12,"sp_expire","","",48,null],[12,"sp_flag","","",48,null],[3,"statvfs","","",null,null],[12,"f_bsize","","",49,null],[12,"f_frsize","","",49,null],[12,"f_blocks","","",49,null],[12,"f_bfree","","",49,null],[12,"f_bavail","","",49,null],[12,"f_files","","",49,null],[12,"f_ffree","","",49,null],[12,"f_favail","","",49,null],[12,"f_fsid","","",49,null],[12,"f_flag","","",49,null],[12,"f_namemax","","",49,null],[12,"__f_spare","","",49,null],[3,"dqblk","","",null,null],[12,"dqb_bhardlimit","","",50,null],[12,"dqb_bsoftlimit","","",50,null],[12,"dqb_curspace","","",50,null],[12,"dqb_ihardlimit","","",50,null],[12,"dqb_isoftlimit","","",50,null],[12,"dqb_curinodes","","",50,null],[12,"dqb_btime","","",50,null],[12,"dqb_itime","","",50,null],[12,"dqb_valid","","",50,null],[3,"signalfd_siginfo","","",null,null],[12,"ssi_signo","","",51,null],[12,"ssi_errno","","",51,null],[12,"ssi_code","","",51,null],[12,"ssi_pid","","",51,null],[12,"ssi_uid","","",51,null],[12,"ssi_fd","","",51,null],[12,"ssi_tid","","",51,null],[12,"ssi_band","","",51,null],[12,"ssi_overrun","","",51,null],[12,"ssi_trapno","","",51,null],[12,"ssi_status","","",51,null],[12,"ssi_int","","",51,null],[12,"ssi_ptr","","",51,null],[12,"ssi_utime","","",51,null],[12,"ssi_stime","","",51,null],[12,"ssi_addr","","",51,null],[12,"_pad","","",51,null],[3,"itimerspec","","",null,null],[12,"it_interval","","",52,null],[12,"it_value","","",52,null],[3,"fsid_t","","",null,null],[12,"__val","","",53,null],[3,"mq_attr","","",null,null],[12,"mq_flags","","",54,null],[12,"mq_maxmsg","","",54,null],[12,"mq_msgsize","","",54,null],[12,"mq_curmsgs","","",54,null],[12,"pad","","",54,null],[3,"cpu_set_t","","",null,null],[12,"bits","","",55,null],[3,"if_nameindex","","",null,null],[12,"if_index","","",56,null],[12,"if_name","","",56,null],[3,"msginfo","","",null,null],[12,"msgpool","","",57,null],[12,"msgmap","","",57,null],[12,"msgmax","","",57,null],[12,"msgmnb","","",57,null],[12,"msgmni","","",57,null],[12,"msgssz","","",57,null],[12,"msgtql","","",57,null],[12,"msgseg","","",57,null],[3,"mmsghdr","","",null,null],[12,"msg_hdr","","",58,null],[12,"msg_len","","",58,null],[3,"sembuf","","",null,null],[12,"sem_num","","",59,null],[12,"sem_op","","",59,null],[12,"sem_flg","","",59,null],[3,"input_event","","",null,null],[12,"time","","",60,null],[12,"type_","","",60,null],[12,"code","","",60,null],[12,"value","","",60,null],[3,"input_id","","",null,null],[12,"bustype","","",61,null],[12,"vendor","","",61,null],[12,"product","","",61,null],[12,"version","","",61,null],[3,"input_absinfo","","",null,null],[12,"value","","",62,null],[12,"minimum","","",62,null],[12,"maximum","","",62,null],[12,"fuzz","","",62,null],[12,"flat","","",62,null],[12,"resolution","","",62,null],[3,"input_keymap_entry","","",null,null],[12,"flags","","",63,null],[12,"len","","",63,null],[12,"index","","",63,null],[12,"keycode","","",63,null],[12,"scancode","","",63,null],[3,"input_mask","","",null,null],[12,"type_","","",64,null],[12,"codes_size","","",64,null],[12,"codes_ptr","","",64,null],[3,"ff_replay","","",null,null],[12,"length","","",65,null],[12,"delay","","",65,null],[3,"ff_trigger","","",null,null],[12,"button","","",66,null],[12,"interval","","",66,null],[3,"ff_envelope","","",null,null],[12,"attack_length","","",67,null],[12,"attack_level","","",67,null],[12,"fade_length","","",67,null],[12,"fade_level","","",67,null],[3,"ff_constant_effect","","",null,null],[12,"level","","",68,null],[12,"envelope","","",68,null],[3,"ff_ramp_effect","","",null,null],[12,"start_level","","",69,null],[12,"end_level","","",69,null],[12,"envelope","","",69,null],[3,"ff_condition_effect","","",null,null],[12,"right_saturation","","",70,null],[12,"left_saturation","","",70,null],[12,"right_coeff","","",70,null],[12,"left_coeff","","",70,null],[12,"deadband","","",70,null],[12,"center","","",70,null],[3,"ff_periodic_effect","","",null,null],[12,"waveform","","",71,null],[12,"period","","",71,null],[12,"magnitude","","",71,null],[12,"offset","","",71,null],[12,"phase","","",71,null],[12,"envelope","","",71,null],[12,"custom_len","","",71,null],[12,"custom_data","","",71,null],[3,"ff_rumble_effect","","",null,null],[12,"strong_magnitude","","",72,null],[12,"weak_magnitude","","",72,null],[3,"ff_effect","","",null,null],[12,"type_","","",73,null],[12,"id","","",73,null],[12,"direction","","",73,null],[12,"trigger","","",73,null],[12,"replay","","",73,null],[12,"u","","",73,null],[3,"dl_phdr_info","","",null,null],[12,"dlpi_addr","","",74,null],[12,"dlpi_name","","",74,null],[12,"dlpi_phdr","","",74,null],[12,"dlpi_phnum","","",74,null],[12,"dlpi_adds","","",74,null],[12,"dlpi_subs","","",74,null],[12,"dlpi_tls_modid","","",74,null],[12,"dlpi_tls_data","","",74,null],[3,"Elf32_Phdr","","",null,null],[12,"p_type","","",75,null],[12,"p_offset","","",75,null],[12,"p_vaddr","","",75,null],[12,"p_paddr","","",75,null],[12,"p_filesz","","",75,null],[12,"p_memsz","","",75,null],[12,"p_flags","","",75,null],[12,"p_align","","",75,null],[3,"Elf64_Phdr","","",null,null],[12,"p_type","","",76,null],[12,"p_flags","","",76,null],[12,"p_offset","","",76,null],[12,"p_vaddr","","",76,null],[12,"p_paddr","","",76,null],[12,"p_filesz","","",76,null],[12,"p_memsz","","",76,null],[12,"p_align","","",76,null],[3,"ucred","","",null,null],[12,"pid","","",77,null],[12,"uid","","",77,null],[12,"gid","","",77,null],[3,"mntent","","",null,null],[12,"mnt_fsname","","",78,null],[12,"mnt_dir","","",78,null],[12,"mnt_type","","",78,null],[12,"mnt_opts","","",78,null],[12,"mnt_freq","","",78,null],[12,"mnt_passno","","",78,null],[3,"posix_spawn_file_actions_t","","",null,null],[12,"__allocated","","",79,null],[12,"__used","","",79,null],[12,"__actions","","",79,null],[12,"__pad","","",79,null],[3,"posix_spawnattr_t","","",null,null],[12,"__flags","","",80,null],[12,"__pgrp","","",80,null],[12,"__sd","","",80,null],[12,"__ss","","",80,null],[12,"__sp","","",80,null],[12,"__policy","","",80,null],[12,"__pad","","",80,null],[3,"genlmsghdr","","",null,null],[12,"cmd","","",81,null],[12,"version","","",81,null],[12,"reserved","","",81,null],[3,"aiocb","","",null,null],[12,"aio_fildes","","",82,null],[12,"aio_lio_opcode","","",82,null],[12,"aio_reqprio","","",82,null],[12,"aio_buf","","",82,null],[12,"aio_nbytes","","",82,null],[12,"aio_sigevent","","",82,null],[12,"__next_prio","","",82,null],[12,"__abs_prio","","",82,null],[12,"__policy","","",82,null],[12,"__error_code","","",82,null],[12,"__return_value","","",82,null],[12,"aio_offset","","",82,null],[12,"__glibc_reserved","","",82,null],[3,"__exit_status","","",null,null],[12,"e_termination","","",83,null],[12,"e_exit","","",83,null],[3,"__timeval","","",null,null],[12,"tv_sec","","",84,null],[12,"tv_usec","","",84,null],[3,"utmpx","","",null,null],[12,"ut_type","","",85,null],[12,"ut_pid","","",85,null],[12,"ut_line","","",85,null],[12,"ut_id","","",85,null],[12,"ut_user","","",85,null],[12,"ut_host","","",85,null],[12,"ut_exit","","",85,null],[12,"ut_session","","",85,null],[12,"ut_tv","","",85,null],[12,"ut_addr_v6","","",85,null],[12,"__glibc_reserved","","",85,null],[3,"sigaction","","",null,null],[12,"sa_sigaction","","",86,null],[12,"sa_mask","","",86,null],[12,"sa_flags","","",86,null],[12,"sa_restorer","","",86,null],[3,"stack_t","","",null,null],[12,"ss_sp","","",87,null],[12,"ss_flags","","",87,null],[12,"ss_size","","",87,null],[3,"siginfo_t","","",null,null],[12,"si_signo","","",88,null],[12,"si_errno","","",88,null],[12,"si_code","","",88,null],[12,"_pad","","",88,null],[12,"_align","","",88,null],[3,"glob64_t","","",null,null],[12,"gl_pathc","","",89,null],[12,"gl_pathv","","",89,null],[12,"gl_offs","","",89,null],[12,"gl_flags","","",89,null],[12,"__unused1","","",89,null],[12,"__unused2","","",89,null],[12,"__unused3","","",89,null],[12,"__unused4","","",89,null],[12,"__unused5","","",89,null],[3,"statfs","","",null,null],[12,"f_type","","",90,null],[12,"f_bsize","","",90,null],[12,"f_blocks","","",90,null],[12,"f_bfree","","",90,null],[12,"f_bavail","","",90,null],[12,"f_files","","",90,null],[12,"f_ffree","","",90,null],[12,"f_fsid","","",90,null],[12,"f_namelen","","",90,null],[12,"f_frsize","","",90,null],[12,"f_spare","","",90,null],[3,"msghdr","","",null,null],[12,"msg_name","","",91,null],[12,"msg_namelen","","",91,null],[12,"msg_iov","","",91,null],[12,"msg_iovlen","","",91,null],[12,"msg_control","","",91,null],[12,"msg_controllen","","",91,null],[12,"msg_flags","","",91,null],[3,"cmsghdr","","",null,null],[12,"cmsg_len","","",92,null],[12,"cmsg_level","","",92,null],[12,"cmsg_type","","",92,null],[3,"termios","","",null,null],[12,"c_iflag","","",93,null],[12,"c_oflag","","",93,null],[12,"c_cflag","","",93,null],[12,"c_lflag","","",93,null],[12,"c_line","","",93,null],[12,"c_cc","","",93,null],[12,"c_ispeed","","",93,null],[12,"c_ospeed","","",93,null],[3,"flock","","",null,null],[12,"l_type","","",94,null],[12,"l_whence","","",94,null],[12,"l_start","","",94,null],[12,"l_len","","",94,null],[12,"l_pid","","",94,null],[3,"sem_t","","",null,null],[12,"__size","","",95,null],[12,"__align","","",95,null],[3,"mallinfo","","",null,null],[12,"arena","","",96,null],[12,"ordblks","","",96,null],[12,"smblks","","",96,null],[12,"hblks","","",96,null],[12,"hblkhd","","",96,null],[12,"usmblks","","",96,null],[12,"fsmblks","","",96,null],[12,"uordblks","","",96,null],[12,"fordblks","","",96,null],[12,"keepcost","","",96,null],[3,"nlmsghdr","","",null,null],[12,"nlmsg_len","","",97,null],[12,"nlmsg_type","","",97,null],[12,"nlmsg_flags","","",97,null],[12,"nlmsg_seq","","",97,null],[12,"nlmsg_pid","","",97,null],[3,"nlmsgerr","","",null,null],[12,"error","","",98,null],[12,"msg","","",98,null],[3,"nl_pktinfo","","",null,null],[12,"group","","",99,null],[3,"nl_mmap_req","","",null,null],[12,"nm_block_size","","",100,null],[12,"nm_block_nr","","",100,null],[12,"nm_frame_size","","",100,null],[12,"nm_frame_nr","","",100,null],[3,"nl_mmap_hdr","","",null,null],[12,"nm_status","","",101,null],[12,"nm_len","","",101,null],[12,"nm_group","","",101,null],[12,"nm_pid","","",101,null],[12,"nm_uid","","",101,null],[12,"nm_gid","","",101,null],[3,"nlattr","","",null,null],[12,"nla_len","","",102,null],[12,"nla_type","","",102,null],[3,"sigset_t","","",null,null],[12,"__val","","",103,null],[3,"sysinfo","","",null,null],[12,"uptime","","",104,null],[12,"loads","","",104,null],[12,"totalram","","",104,null],[12,"freeram","","",104,null],[12,"sharedram","","",104,null],[12,"bufferram","","",104,null],[12,"totalswap","","",104,null],[12,"freeswap","","",104,null],[12,"procs","","",104,null],[12,"pad","","",104,null],[12,"totalhigh","","",104,null],[12,"freehigh","","",104,null],[12,"mem_unit","","",104,null],[12,"_f","","",104,null],[3,"msqid_ds","","",null,null],[12,"msg_perm","","",105,null],[12,"msg_stime","","",105,null],[12,"msg_rtime","","",105,null],[12,"msg_ctime","","",105,null],[12,"__msg_cbytes","","",105,null],[12,"msg_qnum","","",105,null],[12,"msg_qbytes","","",105,null],[12,"msg_lspid","","",105,null],[12,"msg_lrpid","","",105,null],[12,"__glibc_reserved4","","",105,null],[12,"__glibc_reserved5","","",105,null],[3,"stat","","",null,null],[12,"st_dev","","",106,null],[12,"st_ino","","",106,null],[12,"st_nlink","","",106,null],[12,"st_mode","","",106,null],[12,"st_uid","","",106,null],[12,"st_gid","","",106,null],[12,"__pad0","","",106,null],[12,"st_rdev","","",106,null],[12,"st_size","","",106,null],[12,"st_blksize","","",106,null],[12,"st_blocks","","",106,null],[12,"st_atime","","",106,null],[12,"st_atime_nsec","","",106,null],[12,"st_mtime","","",106,null],[12,"st_mtime_nsec","","",106,null],[12,"st_ctime","","",106,null],[12,"st_ctime_nsec","","",106,null],[12,"__unused","","",106,null],[3,"stat64","","",null,null],[12,"st_dev","","",107,null],[12,"st_ino","","",107,null],[12,"st_nlink","","",107,null],[12,"st_mode","","",107,null],[12,"st_uid","","",107,null],[12,"st_gid","","",107,null],[12,"__pad0","","",107,null],[12,"st_rdev","","",107,null],[12,"st_size","","",107,null],[12,"st_blksize","","",107,null],[12,"st_blocks","","",107,null],[12,"st_atime","","",107,null],[12,"st_atime_nsec","","",107,null],[12,"st_mtime","","",107,null],[12,"st_mtime_nsec","","",107,null],[12,"st_ctime","","",107,null],[12,"st_ctime_nsec","","",107,null],[12,"__reserved","","",107,null],[3,"statfs64","","",null,null],[12,"f_type","","",108,null],[12,"f_bsize","","",108,null],[12,"f_blocks","","",108,null],[12,"f_bfree","","",108,null],[12,"f_bavail","","",108,null],[12,"f_files","","",108,null],[12,"f_ffree","","",108,null],[12,"f_fsid","","",108,null],[12,"f_namelen","","",108,null],[12,"f_frsize","","",108,null],[12,"f_flags","","",108,null],[12,"f_spare","","",108,null],[3,"statvfs64","","",null,null],[12,"f_bsize","","",109,null],[12,"f_frsize","","",109,null],[12,"f_blocks","","",109,null],[12,"f_bfree","","",109,null],[12,"f_bavail","","",109,null],[12,"f_files","","",109,null],[12,"f_ffree","","",109,null],[12,"f_favail","","",109,null],[12,"f_fsid","","",109,null],[12,"f_flag","","",109,null],[12,"f_namemax","","",109,null],[12,"__f_spare","","",109,null],[3,"pthread_attr_t","","",null,null],[12,"__size","","",110,null],[3,"_libc_fpxreg","","",null,null],[12,"significand","","",111,null],[12,"exponent","","",111,null],[12,"__private","","",111,null],[3,"_libc_xmmreg","","",null,null],[12,"element","","",112,null],[3,"_libc_fpstate","","",null,null],[12,"cwd","","",113,null],[12,"swd","","",113,null],[12,"ftw","","",113,null],[12,"fop","","",113,null],[12,"rip","","",113,null],[12,"rdp","","",113,null],[12,"mxcsr","","",113,null],[12,"mxcr_mask","","",113,null],[12,"_st","","",113,null],[12,"_xmm","","",113,null],[12,"__private","","",113,null],[3,"user_fpregs_struct","","",null,null],[12,"cwd","","",114,null],[12,"swd","","",114,null],[12,"ftw","","",114,null],[12,"fop","","",114,null],[12,"rip","","",114,null],[12,"rdp","","",114,null],[12,"mxcsr","","",114,null],[12,"mxcr_mask","","",114,null],[12,"st_space","","",114,null],[12,"xmm_space","","",114,null],[12,"padding","","",114,null],[3,"user_regs_struct","","",null,null],[12,"r15","","",115,null],[12,"r14","","",115,null],[12,"r13","","",115,null],[12,"r12","","",115,null],[12,"rbp","","",115,null],[12,"rbx","","",115,null],[12,"r11","","",115,null],[12,"r10","","",115,null],[12,"r9","","",115,null],[12,"r8","","",115,null],[12,"rax","","",115,null],[12,"rcx","","",115,null],[12,"rdx","","",115,null],[12,"rsi","","",115,null],[12,"rdi","","",115,null],[12,"orig_rax","","",115,null],[12,"rip","","",115,null],[12,"cs","","",115,null],[12,"eflags","","",115,null],[12,"rsp","","",115,null],[12,"ss","","",115,null],[12,"fs_base","","",115,null],[12,"gs_base","","",115,null],[12,"ds","","",115,null],[12,"es","","",115,null],[12,"fs","","",115,null],[12,"gs","","",115,null],[3,"user","","",null,null],[12,"regs","","",116,null],[12,"u_fpvalid","","",116,null],[12,"i387","","",116,null],[12,"u_tsize","","",116,null],[12,"u_dsize","","",116,null],[12,"u_ssize","","",116,null],[12,"start_code","","",116,null],[12,"start_stack","","",116,null],[12,"signal","","",116,null],[12,"__reserved","","",116,null],[12,"u_ar0","","",116,null],[12,"u_fpstate","","",116,null],[12,"magic","","",116,null],[12,"u_comm","","",116,null],[12,"u_debugreg","","",116,null],[3,"mcontext_t","","",null,null],[12,"gregs","","",117,null],[12,"fpregs","","",117,null],[12,"__private","","",117,null],[3,"ucontext_t","","",null,null],[12,"uc_flags","","",118,null],[12,"uc_link","","",118,null],[12,"uc_stack","","",118,null],[12,"uc_mcontext","","",118,null],[12,"uc_sigmask","","",118,null],[12,"__private","","",118,null],[3,"ipc_perm","","",null,null],[12,"__key","","",119,null],[12,"uid","","",119,null],[12,"gid","","",119,null],[12,"cuid","","",119,null],[12,"cgid","","",119,null],[12,"mode","","",119,null],[12,"__pad1","","",119,null],[12,"__seq","","",119,null],[12,"__pad2","","",119,null],[12,"__unused1","","",119,null],[12,"__unused2","","",119,null],[3,"shmid_ds","","",null,null],[12,"shm_perm","","",120,null],[12,"shm_segsz","","",120,null],[12,"shm_atime","","",120,null],[12,"shm_dtime","","",120,null],[12,"shm_ctime","","",120,null],[12,"shm_cpid","","",120,null],[12,"shm_lpid","","",120,null],[12,"shm_nattch","","",120,null],[12,"__unused4","","",120,null],[12,"__unused5","","",120,null],[3,"termios2","","",null,null],[12,"c_iflag","","",121,null],[12,"c_oflag","","",121,null],[12,"c_cflag","","",121,null],[12,"c_lflag","","",121,null],[12,"c_line","","",121,null],[12,"c_cc","","",121,null],[12,"c_ispeed","","",121,null],[12,"c_ospeed","","",121,null],[4,"c_void","","",null,null],[13,"__variant1","","",122,null],[13,"__variant2","","",122,null],[4,"FILE","","",null,null],[4,"fpos_t","","",null,null],[4,"DIR","","",null,null],[4,"locale_t","","",null,null],[4,"timezone","","",null,null],[4,"fpos64_t","","",null,null],[5,"FD_CLR","","",null,null],[5,"FD_ISSET","","",null,null],[5,"FD_SET","","",null,null],[5,"FD_ZERO","","",null,null],[5,"WIFSTOPPED","","",null,{"i":[{"n":"c_int"}],"o":{"n":"bool"}}],[5,"WSTOPSIG","","",null,{"i":[{"n":"c_int"}],"o":{"n":"c_int"}}],[5,"WIFCONTINUED","","",null,{"i":[{"n":"c_int"}],"o":{"n":"bool"}}],[5,"WIFSIGNALED","","",null,{"i":[{"n":"c_int"}],"o":{"n":"bool"}}],[5,"WTERMSIG","","",null,{"i":[{"n":"c_int"}],"o":{"n":"c_int"}}],[5,"WIFEXITED","","",null,{"i":[{"n":"c_int"}],"o":{"n":"bool"}}],[5,"WEXITSTATUS","","",null,{"i":[{"n":"c_int"}],"o":{"n":"c_int"}}],[5,"WCOREDUMP","","",null,{"i":[{"n":"c_int"}],"o":{"n":"bool"}}],[5,"QCMD","","",null,{"i":[{"n":"c_int"},{"n":"c_int"}],"o":{"n":"c_int"}}],[5,"CPU_ZERO","","",null,null],[5,"CPU_SET","","",null,null],[5,"CPU_CLR","","",null,null],[5,"CPU_ISSET","","",null,{"i":[{"n":"usize"},{"n":"cpu_set_t"}],"o":{"n":"bool"}}],[5,"CPU_EQUAL","","",null,{"i":[{"n":"cpu_set_t"},{"n":"cpu_set_t"}],"o":{"n":"bool"}}],[5,"major","","",null,{"i":[{"n":"dev_t"}],"o":{"n":"c_uint"}}],[5,"minor","","",null,{"i":[{"n":"dev_t"}],"o":{"n":"c_uint"}}],[5,"makedev","","",null,{"i":[{"n":"c_uint"},{"n":"c_uint"}],"o":{"n":"dev_t"}}],[5,"NLA_ALIGN","","",null,{"i":[{"n":"c_int"}],"o":{"n":"c_int"}}],[5,"isalnum","","",null,null],[5,"isalpha","","",null,null],[5,"iscntrl","","",null,null],[5,"isdigit","","",null,null],[5,"isgraph","","",null,null],[5,"islower","","",null,null],[5,"isprint","","",null,null],[5,"ispunct","","",null,null],[5,"isspace","","",null,null],[5,"isupper","","",null,null],[5,"isxdigit","","",null,null],[5,"tolower","","",null,null],[5,"toupper","","",null,null],[5,"fopen","","",null,null],[5,"freopen","","",null,null],[5,"fflush","","",null,null],[5,"fclose","","",null,null],[5,"remove","","",null,null],[5,"rename","","",null,null],[5,"tmpfile","","",null,null],[5,"setvbuf","","",null,null],[5,"setbuf","","",null,null],[5,"getchar","","",null,null],[5,"putchar","","",null,null],[5,"fgetc","","",null,null],[5,"fgets","","",null,null],[5,"fputc","","",null,null],[5,"fputs","","",null,null],[5,"puts","","",null,null],[5,"ungetc","","",null,null],[5,"fread","","",null,null],[5,"fwrite","","",null,null],[5,"fseek","","",null,null],[5,"ftell","","",null,null],[5,"rewind","","",null,null],[5,"fgetpos","","",null,null],[5,"fsetpos","","",null,null],[5,"feof","","",null,null],[5,"ferror","","",null,null],[5,"perror","","",null,null],[5,"atoi","","",null,null],[5,"strtod","","",null,null],[5,"strtol","","",null,null],[5,"strtoul","","",null,null],[5,"calloc","","",null,null],[5,"malloc","","",null,null],[5,"realloc","","",null,null],[5,"free","","",null,null],[5,"abort","","",null,null],[5,"exit","","",null,null],[5,"_exit","","",null,null],[5,"atexit","","",null,null],[5,"system","","",null,null],[5,"getenv","","",null,null],[5,"strcpy","","",null,null],[5,"strncpy","","",null,null],[5,"strcat","","",null,null],[5,"strncat","","",null,null],[5,"strcmp","","",null,null],[5,"strncmp","","",null,null],[5,"strcoll","","",null,null],[5,"strchr","","",null,null],[5,"strrchr","","",null,null],[5,"strspn","","",null,null],[5,"strcspn","","",null,null],[5,"strdup","","",null,null],[5,"strpbrk","","",null,null],[5,"strstr","","",null,null],[5,"strlen","","",null,null],[5,"strnlen","","",null,null],[5,"strerror","","",null,null],[5,"strtok","","",null,null],[5,"strxfrm","","",null,null],[5,"wcslen","","",null,null],[5,"wcstombs","","",null,null],[5,"memchr","","",null,null],[5,"memcmp","","",null,null],[5,"memcpy","","",null,null],[5,"memmove","","",null,null],[5,"memset","","",null,null],[5,"abs","","",null,null],[5,"atof","","",null,null],[5,"labs","","",null,null],[5,"rand","","",null,null],[5,"srand","","",null,null],[5,"getpwnam","","",null,null],[5,"getpwuid","","",null,null],[5,"fprintf","","",null,null],[5,"printf","","",null,null],[5,"snprintf","","",null,null],[5,"sprintf","","",null,null],[5,"fscanf","","",null,null],[5,"scanf","","",null,null],[5,"sscanf","","",null,null],[5,"getchar_unlocked","","",null,null],[5,"putchar_unlocked","","",null,null],[5,"socket","","",null,null],[5,"connect","","",null,null],[5,"listen","","",null,null],[5,"accept","","",null,null],[5,"getpeername","","",null,null],[5,"getsockname","","",null,null],[5,"setsockopt","","",null,null],[5,"socketpair","","",null,null],[5,"sendto","","",null,null],[5,"shutdown","","",null,null],[5,"chmod","","",null,null],[5,"fchmod","","",null,null],[5,"fstat","","",null,null],[5,"mkdir","","",null,null],[5,"stat","","",null,null],[5,"pclose","","",null,null],[5,"fdopen","","",null,null],[5,"fileno","","",null,null],[5,"open","","",null,null],[5,"creat","","",null,null],[5,"fcntl","","",null,null],[5,"opendir","","",null,null],[5,"readdir","","",null,null],[5,"readdir_r","","",null,null],[5,"closedir","","",null,null],[5,"rewinddir","","",null,null],[5,"openat","","",null,null],[5,"fchmodat","","",null,null],[5,"fchown","","",null,null],[5,"fchownat","","",null,null],[5,"fstatat","","",null,null],[5,"linkat","","",null,null],[5,"mkdirat","","",null,null],[5,"readlinkat","","",null,null],[5,"renameat","","",null,null],[5,"symlinkat","","",null,null],[5,"unlinkat","","",null,null],[5,"access","","",null,null],[5,"alarm","","",null,null],[5,"chdir","","",null,null],[5,"fchdir","","",null,null],[5,"chown","","",null,null],[5,"lchown","","",null,null],[5,"close","","",null,null],[5,"dup","","",null,null],[5,"dup2","","",null,null],[5,"execl","","",null,null],[5,"execle","","",null,null],[5,"execlp","","",null,null],[5,"execv","","",null,null],[5,"execve","","",null,null],[5,"execvp","","",null,null],[5,"fork","","",null,null],[5,"fpathconf","","",null,null],[5,"getcwd","","",null,null],[5,"getegid","","",null,null],[5,"geteuid","","",null,null],[5,"getgid","","",null,null],[5,"getgroups","","",null,null],[5,"getlogin","","",null,null],[5,"getopt","","",null,null],[5,"getpgid","","",null,null],[5,"getpgrp","","",null,null],[5,"getpid","","",null,null],[5,"getppid","","",null,null],[5,"getuid","","",null,null],[5,"isatty","","",null,null],[5,"link","","",null,null],[5,"lseek","","",null,null],[5,"pathconf","","",null,null],[5,"pause","","",null,null],[5,"pipe","","",null,null],[5,"posix_memalign","","",null,null],[5,"read","","",null,null],[5,"rmdir","","",null,null],[5,"seteuid","","",null,null],[5,"setgid","","",null,null],[5,"setpgid","","",null,null],[5,"setsid","","",null,null],[5,"setuid","","",null,null],[5,"sleep","","",null,null],[5,"nanosleep","","",null,null],[5,"tcgetpgrp","","",null,null],[5,"tcsetpgrp","","",null,null],[5,"ttyname","","",null,null],[5,"unlink","","",null,null],[5,"wait","","",null,null],[5,"waitpid","","",null,null],[5,"write","","",null,null],[5,"pread","","",null,null],[5,"pwrite","","",null,null],[5,"umask","","",null,null],[5,"utime","","",null,null],[5,"kill","","",null,null],[5,"killpg","","",null,null],[5,"mlock","","",null,null],[5,"munlock","","",null,null],[5,"mlockall","","",null,null],[5,"munlockall","","",null,null],[5,"mmap","","",null,null],[5,"munmap","","",null,null],[5,"if_nametoindex","","",null,null],[5,"if_indextoname","","",null,null],[5,"lstat","","",null,null],[5,"fsync","","",null,null],[5,"setenv","","",null,null],[5,"unsetenv","","",null,null],[5,"symlink","","",null,null],[5,"ftruncate","","",null,null],[5,"signal","","",null,null],[5,"getrlimit","","",null,null],[5,"setrlimit","","",null,null],[5,"getrusage","","",null,null],[5,"realpath","","",null,null],[5,"flock","","",null,null],[5,"gettimeofday","","",null,null],[5,"times","","",null,null],[5,"pthread_self","","",null,null],[5,"pthread_join","","",null,null],[5,"pthread_exit","","",null,null],[5,"pthread_attr_init","","",null,null],[5,"pthread_attr_destroy","","",null,null],[5,"pthread_attr_setstacksize","","",null,null],[5,"pthread_attr_setdetachstate","","",null,null],[5,"pthread_detach","","",null,null],[5,"sched_yield","","",null,null],[5,"pthread_key_create","","",null,null],[5,"pthread_key_delete","","",null,null],[5,"pthread_getspecific","","",null,null],[5,"pthread_setspecific","","",null,null],[5,"pthread_mutex_init","","",null,null],[5,"pthread_mutex_destroy","","",null,null],[5,"pthread_mutex_lock","","",null,null],[5,"pthread_mutex_trylock","","",null,null],[5,"pthread_mutex_unlock","","",null,null],[5,"pthread_mutexattr_init","","",null,null],[5,"pthread_mutexattr_destroy","","",null,null],[5,"pthread_mutexattr_settype","","",null,null],[5,"pthread_cond_init","","",null,null],[5,"pthread_cond_wait","","",null,null],[5,"pthread_cond_timedwait","","",null,null],[5,"pthread_cond_signal","","",null,null],[5,"pthread_cond_broadcast","","",null,null],[5,"pthread_cond_destroy","","",null,null],[5,"pthread_condattr_init","","",null,null],[5,"pthread_condattr_destroy","","",null,null],[5,"pthread_rwlock_init","","",null,null],[5,"pthread_rwlock_destroy","","",null,null],[5,"pthread_rwlock_rdlock","","",null,null],[5,"pthread_rwlock_tryrdlock","","",null,null],[5,"pthread_rwlock_wrlock","","",null,null],[5,"pthread_rwlock_trywrlock","","",null,null],[5,"pthread_rwlock_unlock","","",null,null],[5,"pthread_rwlockattr_init","","",null,null],[5,"pthread_rwlockattr_destroy","","",null,null],[5,"strerror_r","","",null,null],[5,"getsockopt","","",null,null],[5,"raise","","",null,null],[5,"sigaction","","",null,null],[5,"utimes","","",null,null],[5,"dlopen","","",null,null],[5,"dlerror","","",null,null],[5,"dlsym","","",null,null],[5,"dlclose","","",null,null],[5,"dladdr","","",null,null],[5,"getaddrinfo","","",null,null],[5,"freeaddrinfo","","",null,null],[5,"gai_strerror","","",null,null],[5,"res_init","","",null,null],[5,"gmtime_r","","",null,null],[5,"localtime_r","","",null,null],[5,"mktime","","",null,null],[5,"time","","",null,null],[5,"gmtime","","",null,null],[5,"localtime","","",null,null],[5,"difftime","","",null,null],[5,"mknod","","",null,null],[5,"uname","","",null,null],[5,"gethostname","","",null,null],[5,"getservbyname","","",null,null],[5,"getprotobyname","","",null,null],[5,"getprotobynumber","","",null,null],[5,"chroot","","",null,null],[5,"usleep","","",null,null],[5,"send","","",null,null],[5,"recv","","",null,null],[5,"putenv","","",null,null],[5,"poll","","",null,null],[5,"select","","",null,null],[5,"setlocale","","",null,null],[5,"localeconv","","",null,null],[5,"sem_destroy","","",null,null],[5,"sem_wait","","",null,null],[5,"sem_trywait","","",null,null],[5,"sem_post","","",null,null],[5,"sem_init","","",null,null],[5,"statvfs","","",null,null],[5,"fstatvfs","","",null,null],[5,"readlink","","",null,null],[5,"sigemptyset","","",null,null],[5,"sigaddset","","",null,null],[5,"sigfillset","","",null,null],[5,"sigdelset","","",null,null],[5,"sigismember","","",null,null],[5,"sigprocmask","","",null,null],[5,"sigpending","","",null,null],[5,"timegm","","",null,null],[5,"getsid","","",null,null],[5,"sysconf","","",null,null],[5,"mkfifo","","",null,null],[5,"pselect","","",null,null],[5,"fseeko","","",null,null],[5,"ftello","","",null,null],[5,"tcdrain","","",null,null],[5,"cfgetispeed","","",null,null],[5,"cfgetospeed","","",null,null],[5,"cfmakeraw","","",null,null],[5,"cfsetispeed","","",null,null],[5,"cfsetospeed","","",null,null],[5,"cfsetspeed","","",null,null],[5,"tcgetattr","","",null,null],[5,"tcsetattr","","",null,null],[5,"tcflow","","",null,null],[5,"tcflush","","",null,null],[5,"tcgetsid","","",null,null],[5,"tcsendbreak","","",null,null],[5,"mkstemp","","",null,null],[5,"mkdtemp","","",null,null],[5,"tmpnam","","",null,null],[5,"openlog","","",null,null],[5,"closelog","","",null,null],[5,"setlogmask","","",null,null],[5,"syslog","","",null,null],[5,"nice","","",null,null],[5,"grantpt","","",null,null],[5,"posix_openpt","","",null,null],[5,"ptsname","","",null,null],[5,"unlockpt","","",null,null],[5,"fdatasync","","",null,null],[5,"mincore","","",null,null],[5,"clock_getres","","",null,null],[5,"clock_gettime","","",null,null],[5,"clock_settime","","",null,null],[5,"dirfd","","",null,null],[5,"pthread_getattr_np","","",null,null],[5,"pthread_attr_getstack","","",null,null],[5,"memalign","","",null,null],[5,"setgroups","","",null,null],[5,"pipe2","","",null,null],[5,"statfs","","",null,null],[5,"statfs64","","",null,null],[5,"fstatfs","","",null,null],[5,"fstatfs64","","",null,null],[5,"statvfs64","","",null,null],[5,"fstatvfs64","","",null,null],[5,"memrchr","","",null,null],[5,"posix_fadvise","","",null,null],[5,"futimens","","",null,null],[5,"utimensat","","",null,null],[5,"duplocale","","",null,null],[5,"freelocale","","",null,null],[5,"newlocale","","",null,null],[5,"uselocale","","",null,null],[5,"creat64","","",null,null],[5,"fstat64","","",null,null],[5,"fstatat64","","",null,null],[5,"ftruncate64","","",null,null],[5,"getrlimit64","","",null,null],[5,"lseek64","","",null,null],[5,"lstat64","","",null,null],[5,"mmap64","","",null,null],[5,"open64","","",null,null],[5,"openat64","","",null,null],[5,"pread64","","",null,null],[5,"preadv64","","",null,null],[5,"pwrite64","","",null,null],[5,"pwritev64","","",null,null],[5,"readdir64","","",null,null],[5,"readdir64_r","","",null,null],[5,"setrlimit64","","",null,null],[5,"stat64","","",null,null],[5,"truncate64","","",null,null],[5,"fdopendir","","",null,null],[5,"mknodat","","",null,null],[5,"pthread_condattr_getclock","","",null,null],[5,"pthread_condattr_setclock","","",null,null],[5,"pthread_condattr_setpshared","","",null,null],[5,"accept4","","",null,null],[5,"pthread_mutexattr_setpshared","","",null,null],[5,"pthread_rwlockattr_getpshared","","",null,null],[5,"pthread_rwlockattr_setpshared","","",null,null],[5,"ptsname_r","","",null,null],[5,"clearenv","","",null,null],[5,"waitid","","",null,null],[5,"setreuid","","",null,null],[5,"setregid","","",null,null],[5,"getresuid","","",null,null],[5,"getresgid","","",null,null],[5,"acct","","",null,null],[5,"brk","","",null,null],[5,"sbrk","","",null,null],[5,"vfork","","",null,null],[5,"setresgid","","",null,null],[5,"setresuid","","",null,null],[5,"wait4","","",null,null],[5,"openpty","","",null,null],[5,"execvpe","","",null,null],[5,"fexecve","","",null,null],[5,"aio_read","","",null,null],[5,"aio_write","","",null,null],[5,"aio_fsync","","",null,null],[5,"aio_error","","",null,null],[5,"aio_return","","",null,null],[5,"aio_suspend","","",null,null],[5,"aio_cancel","","",null,null],[5,"lio_listio","","",null,null],[5,"lutimes","","",null,null],[5,"setpwent","","",null,null],[5,"endpwent","","",null,null],[5,"getpwent","","",null,null],[5,"setgrent","","",null,null],[5,"endgrent","","",null,null],[5,"getgrent","","",null,null],[5,"setspent","","",null,null],[5,"endspent","","",null,null],[5,"getspent","","",null,null],[5,"getspnam","","",null,null],[5,"shm_open","","",null,null],[5,"shmget","","",null,null],[5,"shmat","","",null,null],[5,"shmdt","","",null,null],[5,"shmctl","","",null,null],[5,"ftok","","",null,null],[5,"semget","","",null,null],[5,"semop","","",null,null],[5,"semctl","","",null,null],[5,"msgctl","","",null,null],[5,"msgget","","",null,null],[5,"msgrcv","","",null,null],[5,"msgsnd","","",null,null],[5,"mprotect","","",null,null],[5,"__errno_location","","",null,null],[5,"fopen64","","",null,null],[5,"freopen64","","",null,null],[5,"tmpfile64","","",null,null],[5,"fgetpos64","","",null,null],[5,"fsetpos64","","",null,null],[5,"fseeko64","","",null,null],[5,"ftello64","","",null,null],[5,"fallocate","","",null,null],[5,"posix_fallocate","","",null,null],[5,"readahead","","",null,null],[5,"getxattr","","",null,null],[5,"lgetxattr","","",null,null],[5,"fgetxattr","","",null,null],[5,"setxattr","","",null,null],[5,"lsetxattr","","",null,null],[5,"fsetxattr","","",null,null],[5,"listxattr","","",null,null],[5,"llistxattr","","",null,null],[5,"flistxattr","","",null,null],[5,"removexattr","","",null,null],[5,"lremovexattr","","",null,null],[5,"fremovexattr","","",null,null],[5,"signalfd","","",null,null],[5,"timerfd_create","","",null,null],[5,"timerfd_gettime","","",null,null],[5,"timerfd_settime","","",null,null],[5,"pwritev","","",null,null],[5,"preadv","","",null,null],[5,"quotactl","","",null,null],[5,"mq_open","","",null,null],[5,"mq_close","","",null,null],[5,"mq_unlink","","",null,null],[5,"mq_receive","","",null,null],[5,"mq_send","","",null,null],[5,"mq_getattr","","",null,null],[5,"mq_setattr","","",null,null],[5,"epoll_pwait","","",null,null],[5,"dup3","","",null,null],[5,"mkostemp","","",null,null],[5,"mkostemps","","",null,null],[5,"sigtimedwait","","",null,null],[5,"sigwaitinfo","","",null,null],[5,"nl_langinfo_l","","",null,null],[5,"getnameinfo","","",null,null],[5,"pthread_setschedprio","","",null,null],[5,"prlimit","","",null,null],[5,"prlimit64","","",null,null],[5,"getloadavg","","",null,null],[5,"process_vm_readv","","",null,null],[5,"process_vm_writev","","",null,null],[5,"reboot","","",null,null],[5,"setfsgid","","",null,null],[5,"setfsuid","","",null,null],[5,"mkfifoat","","",null,null],[5,"if_nameindex","","",null,null],[5,"if_freenameindex","","",null,null],[5,"sync_file_range","","",null,null],[5,"getifaddrs","","",null,null],[5,"freeifaddrs","","",null,null],[5,"mremap","","",null,null],[5,"glob","","",null,null],[5,"globfree","","",null,null],[5,"posix_madvise","","",null,null],[5,"shm_unlink","","",null,null],[5,"seekdir","","",null,null],[5,"telldir","","",null,null],[5,"madvise","","",null,null],[5,"msync","","",null,null],[5,"remap_file_pages","","",null,null],[5,"recvfrom","","",null,null],[5,"mkstemps","","",null,null],[5,"futimes","","",null,null],[5,"nl_langinfo","","",null,null],[5,"bind","","",null,null],[5,"writev","","",null,null],[5,"readv","","",null,null],[5,"sendmsg","","",null,null],[5,"recvmsg","","",null,null],[5,"getdomainname","","",null,null],[5,"setdomainname","","",null,null],[5,"vhangup","","",null,null],[5,"sendmmsg","","",null,null],[5,"recvmmsg","","",null,null],[5,"sync","","",null,null],[5,"syscall","","",null,null],[5,"sched_getaffinity","","",null,null],[5,"sched_setaffinity","","",null,null],[5,"epoll_create","","",null,null],[5,"epoll_create1","","",null,null],[5,"epoll_wait","","",null,null],[5,"epoll_ctl","","",null,null],[5,"pthread_getschedparam","","",null,null],[5,"unshare","","",null,null],[5,"umount","","",null,null],[5,"sched_get_priority_max","","",null,null],[5,"tee","","",null,null],[5,"settimeofday","","",null,null],[5,"splice","","",null,null],[5,"eventfd","","",null,null],[5,"sched_rr_get_interval","","",null,null],[5,"sem_timedwait","","",null,null],[5,"sched_setparam","","",null,null],[5,"setns","","",null,null],[5,"swapoff","","",null,null],[5,"vmsplice","","",null,null],[5,"mount","","",null,null],[5,"personality","","",null,null],[5,"prctl","","",null,null],[5,"sched_getparam","","",null,null],[5,"ppoll","","",null,null],[5,"pthread_mutex_timedlock","","",null,null],[5,"clone","","",null,null],[5,"sched_getscheduler","","",null,null],[5,"clock_nanosleep","","",null,null],[5,"pthread_attr_getguardsize","","",null,null],[5,"sethostname","","",null,null],[5,"sched_get_priority_min","","",null,null],[5,"pthread_condattr_getpshared","","",null,null],[5,"sysinfo","","",null,null],[5,"umount2","","",null,null],[5,"pthread_setschedparam","","",null,null],[5,"swapon","","",null,null],[5,"sched_setscheduler","","",null,null],[5,"sendfile","","",null,null],[5,"sigsuspend","","",null,null],[5,"getgrgid_r","","",null,null],[5,"sigaltstack","","",null,null],[5,"sem_close","","",null,null],[5,"getdtablesize","","",null,null],[5,"getgrnam_r","","",null,null],[5,"initgroups","","",null,null],[5,"pthread_sigmask","","",null,null],[5,"sem_open","","",null,null],[5,"getgrnam","","",null,null],[5,"pthread_cancel","","",null,null],[5,"pthread_kill","","",null,null],[5,"sem_unlink","","",null,null],[5,"daemon","","",null,null],[5,"getpwnam_r","","",null,null],[5,"getpwuid_r","","",null,null],[5,"sigwait","","",null,null],[5,"pthread_atfork","","",null,null],[5,"getgrgid","","",null,null],[5,"getgrouplist","","",null,null],[5,"pthread_mutexattr_getpshared","","",null,null],[5,"popen","","",null,null],[5,"faccessat","","",null,null],[5,"pthread_create","","",null,null],[5,"dl_iterate_phdr","","",null,null],[5,"setmntent","","",null,null],[5,"getmntent","","",null,null],[5,"addmntent","","",null,null],[5,"endmntent","","",null,null],[5,"hasmntopt","","",null,null],[5,"posix_spawn","","",null,null],[5,"posix_spawnp","","",null,null],[5,"posix_spawnattr_init","","",null,null],[5,"posix_spawnattr_destroy","","",null,null],[5,"posix_spawnattr_getsigdefault","","",null,null],[5,"posix_spawnattr_setsigdefault","","",null,null],[5,"posix_spawnattr_getsigmask","","",null,null],[5,"posix_spawnattr_setsigmask","","",null,null],[5,"posix_spawnattr_getflags","","",null,null],[5,"posix_spawnattr_setflags","","",null,null],[5,"posix_spawnattr_getpgroup","","",null,null],[5,"posix_spawnattr_setpgroup","","",null,null],[5,"posix_spawnattr_getschedpolicy","","",null,null],[5,"posix_spawnattr_setschedpolicy","","",null,null],[5,"posix_spawnattr_getschedparam","","",null,null],[5,"posix_spawnattr_setschedparam","","",null,null],[5,"posix_spawn_file_actions_init","","",null,null],[5,"posix_spawn_file_actions_destroy","","",null,null],[5,"posix_spawn_file_actions_addopen","","",null,null],[5,"posix_spawn_file_actions_addclose","","",null,null],[5,"posix_spawn_file_actions_adddup2","","",null,null],[5,"utmpxname","","",null,null],[5,"getutxent","","",null,null],[5,"getutxid","","",null,null],[5,"getutxline","","",null,null],[5,"pututxline","","",null,null],[5,"setutxent","","",null,null],[5,"endutxent","","",null,null],[5,"getpt","","",null,null],[5,"ioctl","","",null,null],[5,"backtrace","","",null,null],[5,"glob64","","",null,null],[5,"globfree64","","",null,null],[5,"ptrace","","",null,null],[5,"pthread_attr_getaffinity_np","","",null,null],[5,"pthread_attr_setaffinity_np","","",null,null],[5,"getpriority","","",null,null],[5,"setpriority","","",null,null],[5,"pthread_getaffinity_np","","",null,null],[5,"pthread_setaffinity_np","","",null,null],[5,"pthread_rwlockattr_getkind_np","","",null,null],[5,"pthread_rwlockattr_setkind_np","","",null,null],[5,"sched_getcpu","","",null,null],[5,"mallinfo","","",null,null],[5,"malloc_usable_size","","",null,null],[5,"getauxval","","",null,null],[5,"getpwent_r","","",null,null],[5,"getgrent_r","","",null,null],[5,"getcontext","","",null,null],[5,"setcontext","","",null,null],[5,"makecontext","","",null,null],[5,"swapcontext","","",null,null],[5,"iopl","","",null,null],[5,"ioperm","","",null,null],[5,"sysctl","","",null,null],[0,"macros","","",null,null],[0,"dox","","",null,null],[0,"imp","libc::dox","",null,null],[4,"Option","libc::dox::imp","The `Option` type. See the module level documentation for more.",null,null],[13,"None","","No value",123,null],[13,"Some","","Some value `T`",123,null],[8,"Clone","","A common trait for the ability to explicitly duplicate an object.",null,null],[10,"clone","","Returns a copy of the value.",124,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"clone_from","","Performs copy-assignment from `source`.",124,null],[8,"Copy","","Types whose values can be duplicated simply by copying bits.",null,null],[0,"mem","","Basic functions for dealing with memory.",null,null],[5,"forget","libc::dox::imp::mem","Leaks a value: takes ownership and \"forgets\" about the value without running its destructor.",null,null],[5,"size_of","","Returns the size of a type in bytes.",null,{"o":{"n":"usize"}}],[5,"size_of_val","","Returns the size of the pointed-to value in bytes.",null,{"i":[{"n":"t"}],"o":{"n":"usize"}}],[5,"min_align_of","","Returns the [ABI]-required minimum alignment of a type.",null,{"o":{"n":"usize"}}],[5,"min_align_of_val","","Returns the [ABI]-required minimum alignment of the type of the value that `val` points to.",null,{"i":[{"n":"t"}],"o":{"n":"usize"}}],[5,"align_of","","Returns the [ABI]-required minimum alignment of a type.",null,{"o":{"n":"usize"}}],[5,"align_of_val","","Returns the [ABI]-required minimum alignment of the type of the value that `val` points to.",null,{"i":[{"n":"t"}],"o":{"n":"usize"}}],[5,"needs_drop","","Returns whether dropping values of type `T` matters.",null,{"o":{"n":"bool"}}],[5,"zeroed","","Creates a value whose bytes are all zero.",null,{"o":{"n":"t"}}],[5,"uninitialized","","Bypasses Rust's normal memory-initialization checks by pretending to produce a value of type `T`, while doing nothing at all.",null,{"o":{"n":"t"}}],[5,"swap","","Swaps the values at two mutable locations, without deinitializing either one.",null,null],[5,"replace","","Moves `src` into the referenced `dest`, returning the previous `dest` value.",null,{"i":[{"n":"t"},{"n":"t"}],"o":{"n":"t"}}],[5,"drop","","Disposes of a value.",null,null],[5,"transmute_copy","","Interprets `src` as having type `&U`, and then reads `src` without moving the contained value.",null,{"i":[{"n":"t"}],"o":{"n":"u"}}],[3,"Discriminant","","Opaque type representing the discriminant of an enum.",null,null],[12,"0","","",125,null],[12,"1","","",125,null],[5,"discriminant","","Returns a value uniquely identifying the enum variant in `v`.",null,{"i":[{"n":"t"}],"o":{"n":"discriminant"}}],[19,"ManuallyDrop","","A wrapper to inhibit compiler from automatically calling `T`’s destructor.",null,null],[12,"value","","",126,null],[3,"PinMut","","A pinned reference.",null,null],[12,"inner","","",127,null],[5,"transmute","","Reinterprets the bits of a value of one type as another type.",null,{"i":[{"n":"t"}],"o":{"n":"u"}}],[0,"unix","libc","Definitions found commonly among almost all Unix derivatives",null,null],[3,"group","libc::unix","",null,null],[12,"gr_name","","",0,null],[12,"gr_passwd","","",0,null],[12,"gr_gid","","",0,null],[12,"gr_mem","","",0,null],[3,"utimbuf","","",null,null],[12,"actime","","",1,null],[12,"modtime","","",1,null],[3,"timeval","","",null,null],[12,"tv_sec","","",2,null],[12,"tv_usec","","",2,null],[3,"timespec","","",null,null],[12,"tv_sec","","",3,null],[12,"tv_nsec","","",3,null],[3,"rlimit","","",null,null],[12,"rlim_cur","","",4,null],[12,"rlim_max","","",4,null],[3,"rusage","","",null,null],[12,"ru_utime","","",5,null],[12,"ru_stime","","",5,null],[12,"ru_maxrss","","",5,null],[12,"ru_ixrss","","",5,null],[12,"ru_idrss","","",5,null],[12,"ru_isrss","","",5,null],[12,"ru_minflt","","",5,null],[12,"ru_majflt","","",5,null],[12,"ru_nswap","","",5,null],[12,"ru_inblock","","",5,null],[12,"ru_oublock","","",5,null],[12,"ru_msgsnd","","",5,null],[12,"ru_msgrcv","","",5,null],[12,"ru_nsignals","","",5,null],[12,"ru_nvcsw","","",5,null],[12,"ru_nivcsw","","",5,null],[3,"in_addr","","",null,null],[12,"s_addr","","",6,null],[3,"in6_addr","","",null,null],[12,"s6_addr","","",7,null],[12,"__align","","",7,null],[3,"ip_mreq","","",null,null],[12,"imr_multiaddr","","",8,null],[12,"imr_interface","","",8,null],[3,"ipv6_mreq","","",null,null],[12,"ipv6mr_multiaddr","","",9,null],[12,"ipv6mr_interface","","",9,null],[3,"hostent","","",null,null],[12,"h_name","","",10,null],[12,"h_aliases","","",10,null],[12,"h_addrtype","","",10,null],[12,"h_length","","",10,null],[12,"h_addr_list","","",10,null],[3,"iovec","","",null,null],[12,"iov_base","","",11,null],[12,"iov_len","","",11,null],[3,"pollfd","","",null,null],[12,"fd","","",12,null],[12,"events","","",12,null],[12,"revents","","",12,null],[3,"winsize","","",null,null],[12,"ws_row","","",13,null],[12,"ws_col","","",13,null],[12,"ws_xpixel","","",13,null],[12,"ws_ypixel","","",13,null],[3,"linger","","",null,null],[12,"l_onoff","","",14,null],[12,"l_linger","","",14,null],[3,"sigval","","",null,null],[12,"sival_ptr","","",15,null],[3,"itimerval","","",null,null],[12,"it_interval","","",16,null],[12,"it_value","","",16,null],[3,"tms","","",null,null],[12,"tms_utime","","",17,null],[12,"tms_stime","","",17,null],[12,"tms_cutime","","",17,null],[12,"tms_cstime","","",17,null],[3,"servent","","",null,null],[12,"s_name","","",18,null],[12,"s_aliases","","",18,null],[12,"s_port","","",18,null],[12,"s_proto","","",18,null],[3,"protoent","","",null,null],[12,"p_name","","",19,null],[12,"p_aliases","","",19,null],[12,"p_proto","","",19,null],[4,"DIR","","",null,null],[4,"locale_t","","",null,null],[5,"getpwnam","","",null,null],[5,"getpwuid","","",null,null],[5,"fprintf","","",null,null],[5,"printf","","",null,null],[5,"snprintf","","",null,null],[5,"sprintf","","",null,null],[5,"fscanf","","",null,null],[5,"scanf","","",null,null],[5,"sscanf","","",null,null],[5,"getchar_unlocked","","",null,null],[5,"putchar_unlocked","","",null,null],[5,"socket","","",null,null],[5,"connect","","",null,null],[5,"listen","","",null,null],[5,"accept","","",null,null],[5,"getpeername","","",null,null],[5,"getsockname","","",null,null],[5,"setsockopt","","",null,null],[5,"socketpair","","",null,null],[5,"sendto","","",null,null],[5,"shutdown","","",null,null],[5,"chmod","","",null,null],[5,"fchmod","","",null,null],[5,"fstat","","",null,null],[5,"mkdir","","",null,null],[5,"stat","","",null,null],[5,"pclose","","",null,null],[5,"fdopen","","",null,null],[5,"fileno","","",null,null],[5,"open","","",null,null],[5,"creat","","",null,null],[5,"fcntl","","",null,null],[5,"opendir","","",null,null],[5,"readdir","","",null,null],[5,"readdir_r","","",null,null],[5,"closedir","","",null,null],[5,"rewinddir","","",null,null],[5,"openat","","",null,null],[5,"fchmodat","","",null,null],[5,"fchown","","",null,null],[5,"fchownat","","",null,null],[5,"fstatat","","",null,null],[5,"linkat","","",null,null],[5,"mkdirat","","",null,null],[5,"readlinkat","","",null,null],[5,"renameat","","",null,null],[5,"symlinkat","","",null,null],[5,"unlinkat","","",null,null],[5,"access","","",null,null],[5,"alarm","","",null,null],[5,"chdir","","",null,null],[5,"fchdir","","",null,null],[5,"chown","","",null,null],[5,"lchown","","",null,null],[5,"close","","",null,null],[5,"dup","","",null,null],[5,"dup2","","",null,null],[5,"execl","","",null,null],[5,"execle","","",null,null],[5,"execlp","","",null,null],[5,"execv","","",null,null],[5,"execve","","",null,null],[5,"execvp","","",null,null],[5,"fork","","",null,null],[5,"fpathconf","","",null,null],[5,"getcwd","","",null,null],[5,"getegid","","",null,null],[5,"geteuid","","",null,null],[5,"getgid","","",null,null],[5,"getgroups","","",null,null],[5,"getlogin","","",null,null],[5,"getopt","","",null,null],[5,"getpgid","","",null,null],[5,"getpgrp","","",null,null],[5,"getpid","","",null,null],[5,"getppid","","",null,null],[5,"getuid","","",null,null],[5,"isatty","","",null,null],[5,"link","","",null,null],[5,"lseek","","",null,null],[5,"pathconf","","",null,null],[5,"pause","","",null,null],[5,"pipe","","",null,null],[5,"posix_memalign","","",null,null],[5,"read","","",null,null],[5,"rmdir","","",null,null],[5,"seteuid","","",null,null],[5,"setgid","","",null,null],[5,"setpgid","","",null,null],[5,"setsid","","",null,null],[5,"setuid","","",null,null],[5,"sleep","","",null,null],[5,"nanosleep","","",null,null],[5,"tcgetpgrp","","",null,null],[5,"tcsetpgrp","","",null,null],[5,"ttyname","","",null,null],[5,"unlink","","",null,null],[5,"wait","","",null,null],[5,"waitpid","","",null,null],[5,"write","","",null,null],[5,"pread","","",null,null],[5,"pwrite","","",null,null],[5,"umask","","",null,null],[5,"utime","","",null,null],[5,"kill","","",null,null],[5,"killpg","","",null,null],[5,"mlock","","",null,null],[5,"munlock","","",null,null],[5,"mlockall","","",null,null],[5,"munlockall","","",null,null],[5,"mmap","","",null,null],[5,"munmap","","",null,null],[5,"if_nametoindex","","",null,null],[5,"if_indextoname","","",null,null],[5,"lstat","","",null,null],[5,"fsync","","",null,null],[5,"setenv","","",null,null],[5,"unsetenv","","",null,null],[5,"symlink","","",null,null],[5,"ftruncate","","",null,null],[5,"signal","","",null,null],[5,"getrlimit","","",null,null],[5,"setrlimit","","",null,null],[5,"getrusage","","",null,null],[5,"realpath","","",null,null],[5,"flock","","",null,null],[5,"gettimeofday","","",null,null],[5,"times","","",null,null],[5,"pthread_self","","",null,null],[5,"pthread_join","","",null,null],[5,"pthread_exit","","",null,null],[5,"pthread_attr_init","","",null,null],[5,"pthread_attr_destroy","","",null,null],[5,"pthread_attr_setstacksize","","",null,null],[5,"pthread_attr_setdetachstate","","",null,null],[5,"pthread_detach","","",null,null],[5,"sched_yield","","",null,null],[5,"pthread_key_create","","",null,null],[5,"pthread_key_delete","","",null,null],[5,"pthread_getspecific","","",null,null],[5,"pthread_setspecific","","",null,null],[5,"pthread_mutex_init","","",null,null],[5,"pthread_mutex_destroy","","",null,null],[5,"pthread_mutex_lock","","",null,null],[5,"pthread_mutex_trylock","","",null,null],[5,"pthread_mutex_unlock","","",null,null],[5,"pthread_mutexattr_init","","",null,null],[5,"pthread_mutexattr_destroy","","",null,null],[5,"pthread_mutexattr_settype","","",null,null],[5,"pthread_cond_init","","",null,null],[5,"pthread_cond_wait","","",null,null],[5,"pthread_cond_timedwait","","",null,null],[5,"pthread_cond_signal","","",null,null],[5,"pthread_cond_broadcast","","",null,null],[5,"pthread_cond_destroy","","",null,null],[5,"pthread_condattr_init","","",null,null],[5,"pthread_condattr_destroy","","",null,null],[5,"pthread_rwlock_init","","",null,null],[5,"pthread_rwlock_destroy","","",null,null],[5,"pthread_rwlock_rdlock","","",null,null],[5,"pthread_rwlock_tryrdlock","","",null,null],[5,"pthread_rwlock_wrlock","","",null,null],[5,"pthread_rwlock_trywrlock","","",null,null],[5,"pthread_rwlock_unlock","","",null,null],[5,"pthread_rwlockattr_init","","",null,null],[5,"pthread_rwlockattr_destroy","","",null,null],[5,"strerror_r","","",null,null],[5,"getsockopt","","",null,null],[5,"raise","","",null,null],[5,"sigaction","","",null,null],[5,"utimes","","",null,null],[5,"dlopen","","",null,null],[5,"dlerror","","",null,null],[5,"dlsym","","",null,null],[5,"dlclose","","",null,null],[5,"dladdr","","",null,null],[5,"getaddrinfo","","",null,null],[5,"freeaddrinfo","","",null,null],[5,"gai_strerror","","",null,null],[5,"res_init","","",null,null],[5,"gmtime_r","","",null,null],[5,"localtime_r","","",null,null],[5,"mktime","","",null,null],[5,"time","","",null,null],[5,"gmtime","","",null,null],[5,"localtime","","",null,null],[5,"difftime","","",null,null],[5,"mknod","","",null,null],[5,"uname","","",null,null],[5,"gethostname","","",null,null],[5,"getservbyname","","",null,null],[5,"getprotobyname","","",null,null],[5,"getprotobynumber","","",null,null],[5,"chroot","","",null,null],[5,"usleep","","",null,null],[5,"send","","",null,null],[5,"recv","","",null,null],[5,"putenv","","",null,null],[5,"poll","","",null,null],[5,"select","","",null,null],[5,"setlocale","","",null,null],[5,"localeconv","","",null,null],[5,"sem_destroy","","",null,null],[5,"sem_wait","","",null,null],[5,"sem_trywait","","",null,null],[5,"sem_post","","",null,null],[5,"sem_init","","",null,null],[5,"statvfs","","",null,null],[5,"fstatvfs","","",null,null],[5,"readlink","","",null,null],[5,"sigemptyset","","",null,null],[5,"sigaddset","","",null,null],[5,"sigfillset","","",null,null],[5,"sigdelset","","",null,null],[5,"sigismember","","",null,null],[5,"sigprocmask","","",null,null],[5,"sigpending","","",null,null],[5,"timegm","","",null,null],[5,"getsid","","",null,null],[5,"sysconf","","",null,null],[5,"mkfifo","","",null,null],[5,"pselect","","",null,null],[5,"fseeko","","",null,null],[5,"ftello","","",null,null],[5,"tcdrain","","",null,null],[5,"cfgetispeed","","",null,null],[5,"cfgetospeed","","",null,null],[5,"cfmakeraw","","",null,null],[5,"cfsetispeed","","",null,null],[5,"cfsetospeed","","",null,null],[5,"cfsetspeed","","",null,null],[5,"tcgetattr","","",null,null],[5,"tcsetattr","","",null,null],[5,"tcflow","","",null,null],[5,"tcflush","","",null,null],[5,"tcgetsid","","",null,null],[5,"tcsendbreak","","",null,null],[5,"mkstemp","","",null,null],[5,"mkdtemp","","",null,null],[5,"tmpnam","","",null,null],[5,"openlog","","",null,null],[5,"closelog","","",null,null],[5,"setlogmask","","",null,null],[5,"syslog","","",null,null],[5,"nice","","",null,null],[5,"grantpt","","",null,null],[5,"posix_openpt","","",null,null],[5,"ptsname","","",null,null],[5,"unlockpt","","",null,null],[0,"notbsd","","",null,null],[3,"sockaddr","libc::unix::notbsd","",null,null],[12,"sa_family","","",20,null],[12,"sa_data","","",20,null],[3,"sockaddr_in","","",null,null],[12,"sin_family","","",21,null],[12,"sin_port","","",21,null],[12,"sin_addr","","",21,null],[12,"sin_zero","","",21,null],[3,"sockaddr_in6","","",null,null],[12,"sin6_family","","",22,null],[12,"sin6_port","","",22,null],[12,"sin6_flowinfo","","",22,null],[12,"sin6_addr","","",22,null],[12,"sin6_scope_id","","",22,null],[3,"sockaddr_un","","",null,null],[12,"sun_family","","",23,null],[12,"sun_path","","",23,null],[3,"sockaddr_storage","","",null,null],[12,"ss_family","","",24,null],[12,"__ss_align","","",24,null],[12,"__ss_pad2","","",24,null],[3,"addrinfo","","",null,null],[12,"ai_flags","","",25,null],[12,"ai_family","","",25,null],[12,"ai_socktype","","",25,null],[12,"ai_protocol","","",25,null],[12,"ai_addrlen","","",25,null],[12,"ai_addr","","",25,null],[12,"ai_canonname","","",25,null],[12,"ai_next","","",25,null],[3,"sockaddr_nl","","",null,null],[12,"nl_family","","",26,null],[12,"nl_pad","","",26,null],[12,"nl_pid","","",26,null],[12,"nl_groups","","",26,null],[3,"sockaddr_ll","","",null,null],[12,"sll_family","","",27,null],[12,"sll_protocol","","",27,null],[12,"sll_ifindex","","",27,null],[12,"sll_hatype","","",27,null],[12,"sll_pkttype","","",27,null],[12,"sll_halen","","",27,null],[12,"sll_addr","","",27,null],[3,"fd_set","","",null,null],[12,"fds_bits","","",28,null],[3,"tm","","",null,null],[12,"tm_sec","","",29,null],[12,"tm_min","","",29,null],[12,"tm_hour","","",29,null],[12,"tm_mday","","",29,null],[12,"tm_mon","","",29,null],[12,"tm_year","","",29,null],[12,"tm_wday","","",29,null],[12,"tm_yday","","",29,null],[12,"tm_isdst","","",29,null],[12,"tm_gmtoff","","",29,null],[12,"tm_zone","","",29,null],[3,"sched_param","","",null,null],[12,"sched_priority","","",30,null],[3,"Dl_info","","",null,null],[12,"dli_fname","","",31,null],[12,"dli_fbase","","",31,null],[12,"dli_sname","","",31,null],[12,"dli_saddr","","",31,null],[3,"epoll_event","","",null,null],[12,"events","","",32,null],[12,"u64","","",32,null],[3,"utsname","","",null,null],[12,"sysname","","",33,null],[12,"nodename","","",33,null],[12,"release","","",33,null],[12,"version","","",33,null],[12,"machine","","",33,null],[12,"domainname","","",33,null],[3,"lconv","","",null,null],[12,"decimal_point","","",34,null],[12,"thousands_sep","","",34,null],[12,"grouping","","",34,null],[12,"int_curr_symbol","","",34,null],[12,"currency_symbol","","",34,null],[12,"mon_decimal_point","","",34,null],[12,"mon_thousands_sep","","",34,null],[12,"mon_grouping","","",34,null],[12,"positive_sign","","",34,null],[12,"negative_sign","","",34,null],[12,"int_frac_digits","","",34,null],[12,"frac_digits","","",34,null],[12,"p_cs_precedes","","",34,null],[12,"p_sep_by_space","","",34,null],[12,"n_cs_precedes","","",34,null],[12,"n_sep_by_space","","",34,null],[12,"p_sign_posn","","",34,null],[12,"n_sign_posn","","",34,null],[12,"int_p_cs_precedes","","",34,null],[12,"int_p_sep_by_space","","",34,null],[12,"int_n_cs_precedes","","",34,null],[12,"int_n_sep_by_space","","",34,null],[12,"int_p_sign_posn","","",34,null],[12,"int_n_sign_posn","","",34,null],[3,"sigevent","","",null,null],[12,"sigev_value","","",35,null],[12,"sigev_signo","","",35,null],[12,"sigev_notify","","",35,null],[12,"sigev_notify_thread_id","","",35,null],[12,"__unused1","","",35,null],[4,"timezone","","",null,null],[5,"FD_CLR","","",null,null],[5,"FD_ISSET","","",null,null],[5,"FD_SET","","",null,null],[5,"FD_ZERO","","",null,null],[5,"WIFSTOPPED","","",null,{"i":[{"n":"c_int"}],"o":{"n":"bool"}}],[5,"WSTOPSIG","","",null,{"i":[{"n":"c_int"}],"o":{"n":"c_int"}}],[5,"WIFCONTINUED","","",null,{"i":[{"n":"c_int"}],"o":{"n":"bool"}}],[5,"WIFSIGNALED","","",null,{"i":[{"n":"c_int"}],"o":{"n":"bool"}}],[5,"WTERMSIG","","",null,{"i":[{"n":"c_int"}],"o":{"n":"c_int"}}],[5,"WIFEXITED","","",null,{"i":[{"n":"c_int"}],"o":{"n":"bool"}}],[5,"WEXITSTATUS","","",null,{"i":[{"n":"c_int"}],"o":{"n":"c_int"}}],[5,"WCOREDUMP","","",null,{"i":[{"n":"c_int"}],"o":{"n":"bool"}}],[5,"QCMD","","",null,{"i":[{"n":"c_int"},{"n":"c_int"}],"o":{"n":"c_int"}}],[5,"fdatasync","","",null,null],[5,"mincore","","",null,null],[5,"clock_getres","","",null,null],[5,"clock_gettime","","",null,null],[5,"clock_settime","","",null,null],[5,"dirfd","","",null,null],[5,"pthread_getattr_np","","",null,null],[5,"pthread_attr_getstack","","",null,null],[5,"memalign","","",null,null],[5,"setgroups","","",null,null],[5,"pipe2","","",null,null],[5,"statfs","","",null,null],[5,"statfs64","","",null,null],[5,"fstatfs","","",null,null],[5,"fstatfs64","","",null,null],[5,"statvfs64","","",null,null],[5,"fstatvfs64","","",null,null],[5,"memrchr","","",null,null],[5,"posix_fadvise","","",null,null],[5,"futimens","","",null,null],[5,"utimensat","","",null,null],[5,"duplocale","","",null,null],[5,"freelocale","","",null,null],[5,"newlocale","","",null,null],[5,"uselocale","","",null,null],[5,"creat64","","",null,null],[5,"fstat64","","",null,null],[5,"fstatat64","","",null,null],[5,"ftruncate64","","",null,null],[5,"getrlimit64","","",null,null],[5,"lseek64","","",null,null],[5,"lstat64","","",null,null],[5,"mmap64","","",null,null],[5,"open64","","",null,null],[5,"openat64","","",null,null],[5,"pread64","","",null,null],[5,"preadv64","","",null,null],[5,"pwrite64","","",null,null],[5,"pwritev64","","",null,null],[5,"readdir64","","",null,null],[5,"readdir64_r","","",null,null],[5,"setrlimit64","","",null,null],[5,"stat64","","",null,null],[5,"truncate64","","",null,null],[5,"fdopendir","","",null,null],[5,"mknodat","","",null,null],[5,"pthread_condattr_getclock","","",null,null],[5,"pthread_condattr_setclock","","",null,null],[5,"pthread_condattr_setpshared","","",null,null],[5,"accept4","","",null,null],[5,"pthread_mutexattr_setpshared","","",null,null],[5,"pthread_rwlockattr_getpshared","","",null,null],[5,"pthread_rwlockattr_setpshared","","",null,null],[5,"ptsname_r","","",null,null],[5,"clearenv","","",null,null],[5,"waitid","","",null,null],[5,"setreuid","","",null,null],[5,"setregid","","",null,null],[5,"getresuid","","",null,null],[5,"getresgid","","",null,null],[5,"acct","","",null,null],[5,"brk","","",null,null],[5,"sbrk","","",null,null],[5,"vfork","","",null,null],[5,"setresgid","","",null,null],[5,"setresuid","","",null,null],[5,"wait4","","",null,null],[5,"openpty","","",null,null],[5,"execvpe","","",null,null],[5,"fexecve","","",null,null],[0,"linux","","Linux-specific definitions for linux-like values",null,null],[3,"dirent","libc::unix::notbsd::linux","",null,null],[12,"d_ino","","",36,null],[12,"d_off","","",36,null],[12,"d_reclen","","",36,null],[12,"d_type","","",36,null],[12,"d_name","","",36,null],[3,"dirent64","","",null,null],[12,"d_ino","","",37,null],[12,"d_off","","",37,null],[12,"d_reclen","","",37,null],[12,"d_type","","",37,null],[12,"d_name","","",37,null],[3,"rlimit64","","",null,null],[12,"rlim_cur","","",38,null],[12,"rlim_max","","",38,null],[3,"glob_t","","",null,null],[12,"gl_pathc","","",39,null],[12,"gl_pathv","","",39,null],[12,"gl_offs","","",39,null],[12,"gl_flags","","",39,null],[12,"__unused1","","",39,null],[12,"__unused2","","",39,null],[12,"__unused3","","",39,null],[12,"__unused4","","",39,null],[12,"__unused5","","",39,null],[3,"ifaddrs","","",null,null],[12,"ifa_next","","",40,null],[12,"ifa_name","","",40,null],[12,"ifa_flags","","",40,null],[12,"ifa_addr","","",40,null],[12,"ifa_netmask","","",40,null],[12,"ifa_ifu","","",40,null],[12,"ifa_data","","",40,null],[3,"pthread_mutex_t","","",null,null],[12,"__align","","",41,null],[12,"size","","",41,null],[3,"pthread_rwlock_t","","",null,null],[12,"__align","","",42,null],[12,"size","","",42,null],[3,"pthread_mutexattr_t","","",null,null],[12,"__align","","",43,null],[12,"size","","",43,null],[3,"pthread_rwlockattr_t","","",null,null],[12,"__align","","",44,null],[12,"size","","",44,null],[3,"pthread_cond_t","","",null,null],[12,"__align","","",45,null],[12,"size","","",45,null],[3,"pthread_condattr_t","","",null,null],[12,"__align","","",46,null],[12,"size","","",46,null],[3,"passwd","","",null,null],[12,"pw_name","","",47,null],[12,"pw_passwd","","",47,null],[12,"pw_uid","","",47,null],[12,"pw_gid","","",47,null],[12,"pw_gecos","","",47,null],[12,"pw_dir","","",47,null],[12,"pw_shell","","",47,null],[3,"spwd","","",null,null],[12,"sp_namp","","",48,null],[12,"sp_pwdp","","",48,null],[12,"sp_lstchg","","",48,null],[12,"sp_min","","",48,null],[12,"sp_max","","",48,null],[12,"sp_warn","","",48,null],[12,"sp_inact","","",48,null],[12,"sp_expire","","",48,null],[12,"sp_flag","","",48,null],[3,"statvfs","","",null,null],[12,"f_bsize","","",49,null],[12,"f_frsize","","",49,null],[12,"f_blocks","","",49,null],[12,"f_bfree","","",49,null],[12,"f_bavail","","",49,null],[12,"f_files","","",49,null],[12,"f_ffree","","",49,null],[12,"f_favail","","",49,null],[12,"f_fsid","","",49,null],[12,"f_flag","","",49,null],[12,"f_namemax","","",49,null],[12,"__f_spare","","",49,null],[3,"dqblk","","",null,null],[12,"dqb_bhardlimit","","",50,null],[12,"dqb_bsoftlimit","","",50,null],[12,"dqb_curspace","","",50,null],[12,"dqb_ihardlimit","","",50,null],[12,"dqb_isoftlimit","","",50,null],[12,"dqb_curinodes","","",50,null],[12,"dqb_btime","","",50,null],[12,"dqb_itime","","",50,null],[12,"dqb_valid","","",50,null],[3,"signalfd_siginfo","","",null,null],[12,"ssi_signo","","",51,null],[12,"ssi_errno","","",51,null],[12,"ssi_code","","",51,null],[12,"ssi_pid","","",51,null],[12,"ssi_uid","","",51,null],[12,"ssi_fd","","",51,null],[12,"ssi_tid","","",51,null],[12,"ssi_band","","",51,null],[12,"ssi_overrun","","",51,null],[12,"ssi_trapno","","",51,null],[12,"ssi_status","","",51,null],[12,"ssi_int","","",51,null],[12,"ssi_ptr","","",51,null],[12,"ssi_utime","","",51,null],[12,"ssi_stime","","",51,null],[12,"ssi_addr","","",51,null],[12,"_pad","","",51,null],[3,"itimerspec","","",null,null],[12,"it_interval","","",52,null],[12,"it_value","","",52,null],[3,"fsid_t","","",null,null],[12,"__val","","",53,null],[3,"mq_attr","","",null,null],[12,"mq_flags","","",54,null],[12,"mq_maxmsg","","",54,null],[12,"mq_msgsize","","",54,null],[12,"mq_curmsgs","","",54,null],[12,"pad","","",54,null],[3,"cpu_set_t","","",null,null],[12,"bits","","",55,null],[3,"if_nameindex","","",null,null],[12,"if_index","","",56,null],[12,"if_name","","",56,null],[3,"msginfo","","",null,null],[12,"msgpool","","",57,null],[12,"msgmap","","",57,null],[12,"msgmax","","",57,null],[12,"msgmnb","","",57,null],[12,"msgmni","","",57,null],[12,"msgssz","","",57,null],[12,"msgtql","","",57,null],[12,"msgseg","","",57,null],[3,"mmsghdr","","",null,null],[12,"msg_hdr","","",58,null],[12,"msg_len","","",58,null],[3,"sembuf","","",null,null],[12,"sem_num","","",59,null],[12,"sem_op","","",59,null],[12,"sem_flg","","",59,null],[3,"input_event","","",null,null],[12,"time","","",60,null],[12,"type_","","",60,null],[12,"code","","",60,null],[12,"value","","",60,null],[3,"input_id","","",null,null],[12,"bustype","","",61,null],[12,"vendor","","",61,null],[12,"product","","",61,null],[12,"version","","",61,null],[3,"input_absinfo","","",null,null],[12,"value","","",62,null],[12,"minimum","","",62,null],[12,"maximum","","",62,null],[12,"fuzz","","",62,null],[12,"flat","","",62,null],[12,"resolution","","",62,null],[3,"input_keymap_entry","","",null,null],[12,"flags","","",63,null],[12,"len","","",63,null],[12,"index","","",63,null],[12,"keycode","","",63,null],[12,"scancode","","",63,null],[3,"input_mask","","",null,null],[12,"type_","","",64,null],[12,"codes_size","","",64,null],[12,"codes_ptr","","",64,null],[3,"ff_replay","","",null,null],[12,"length","","",65,null],[12,"delay","","",65,null],[3,"ff_trigger","","",null,null],[12,"button","","",66,null],[12,"interval","","",66,null],[3,"ff_envelope","","",null,null],[12,"attack_length","","",67,null],[12,"attack_level","","",67,null],[12,"fade_length","","",67,null],[12,"fade_level","","",67,null],[3,"ff_constant_effect","","",null,null],[12,"level","","",68,null],[12,"envelope","","",68,null],[3,"ff_ramp_effect","","",null,null],[12,"start_level","","",69,null],[12,"end_level","","",69,null],[12,"envelope","","",69,null],[3,"ff_condition_effect","","",null,null],[12,"right_saturation","","",70,null],[12,"left_saturation","","",70,null],[12,"right_coeff","","",70,null],[12,"left_coeff","","",70,null],[12,"deadband","","",70,null],[12,"center","","",70,null],[3,"ff_periodic_effect","","",null,null],[12,"waveform","","",71,null],[12,"period","","",71,null],[12,"magnitude","","",71,null],[12,"offset","","",71,null],[12,"phase","","",71,null],[12,"envelope","","",71,null],[12,"custom_len","","",71,null],[12,"custom_data","","",71,null],[3,"ff_rumble_effect","","",null,null],[12,"strong_magnitude","","",72,null],[12,"weak_magnitude","","",72,null],[3,"ff_effect","","",null,null],[12,"type_","","",73,null],[12,"id","","",73,null],[12,"direction","","",73,null],[12,"trigger","","",73,null],[12,"replay","","",73,null],[12,"u","","",73,null],[3,"dl_phdr_info","","",null,null],[12,"dlpi_addr","","",74,null],[12,"dlpi_name","","",74,null],[12,"dlpi_phdr","","",74,null],[12,"dlpi_phnum","","",74,null],[12,"dlpi_adds","","",74,null],[12,"dlpi_subs","","",74,null],[12,"dlpi_tls_modid","","",74,null],[12,"dlpi_tls_data","","",74,null],[3,"Elf32_Phdr","","",null,null],[12,"p_type","","",75,null],[12,"p_offset","","",75,null],[12,"p_vaddr","","",75,null],[12,"p_paddr","","",75,null],[12,"p_filesz","","",75,null],[12,"p_memsz","","",75,null],[12,"p_flags","","",75,null],[12,"p_align","","",75,null],[3,"Elf64_Phdr","","",null,null],[12,"p_type","","",76,null],[12,"p_flags","","",76,null],[12,"p_offset","","",76,null],[12,"p_vaddr","","",76,null],[12,"p_paddr","","",76,null],[12,"p_filesz","","",76,null],[12,"p_memsz","","",76,null],[12,"p_align","","",76,null],[3,"ucred","","",null,null],[12,"pid","","",77,null],[12,"uid","","",77,null],[12,"gid","","",77,null],[3,"mntent","","",null,null],[12,"mnt_fsname","","",78,null],[12,"mnt_dir","","",78,null],[12,"mnt_type","","",78,null],[12,"mnt_opts","","",78,null],[12,"mnt_freq","","",78,null],[12,"mnt_passno","","",78,null],[3,"posix_spawn_file_actions_t","","",null,null],[12,"__allocated","","",79,null],[12,"__used","","",79,null],[12,"__actions","","",79,null],[12,"__pad","","",79,null],[3,"posix_spawnattr_t","","",null,null],[12,"__flags","","",80,null],[12,"__pgrp","","",80,null],[12,"__sd","","",80,null],[12,"__ss","","",80,null],[12,"__sp","","",80,null],[12,"__policy","","",80,null],[12,"__pad","","",80,null],[3,"genlmsghdr","","",null,null],[12,"cmd","","",81,null],[12,"version","","",81,null],[12,"reserved","","",81,null],[4,"fpos64_t","","",null,null],[5,"CPU_ZERO","","",null,null],[5,"CPU_SET","","",null,null],[5,"CPU_CLR","","",null,null],[5,"CPU_ISSET","","",null,{"i":[{"n":"usize"},{"n":"cpu_set_t"}],"o":{"n":"bool"}}],[5,"CPU_EQUAL","","",null,{"i":[{"n":"cpu_set_t"},{"n":"cpu_set_t"}],"o":{"n":"bool"}}],[5,"major","","",null,{"i":[{"n":"dev_t"}],"o":{"n":"c_uint"}}],[5,"minor","","",null,{"i":[{"n":"dev_t"}],"o":{"n":"c_uint"}}],[5,"makedev","","",null,{"i":[{"n":"c_uint"},{"n":"c_uint"}],"o":{"n":"dev_t"}}],[5,"aio_read","","",null,null],[5,"aio_write","","",null,null],[5,"aio_fsync","","",null,null],[5,"aio_error","","",null,null],[5,"aio_return","","",null,null],[5,"aio_suspend","","",null,null],[5,"aio_cancel","","",null,null],[5,"lio_listio","","",null,null],[5,"lutimes","","",null,null],[5,"setpwent","","",null,null],[5,"endpwent","","",null,null],[5,"getpwent","","",null,null],[5,"setgrent","","",null,null],[5,"endgrent","","",null,null],[5,"getgrent","","",null,null],[5,"setspent","","",null,null],[5,"endspent","","",null,null],[5,"getspent","","",null,null],[5,"getspnam","","",null,null],[5,"shm_open","","",null,null],[5,"shmget","","",null,null],[5,"shmat","","",null,null],[5,"shmdt","","",null,null],[5,"shmctl","","",null,null],[5,"ftok","","",null,null],[5,"semget","","",null,null],[5,"semop","","",null,null],[5,"semctl","","",null,null],[5,"msgctl","","",null,null],[5,"msgget","","",null,null],[5,"msgrcv","","",null,null],[5,"msgsnd","","",null,null],[5,"mprotect","","",null,null],[5,"__errno_location","","",null,null],[5,"fopen64","","",null,null],[5,"freopen64","","",null,null],[5,"tmpfile64","","",null,null],[5,"fgetpos64","","",null,null],[5,"fsetpos64","","",null,null],[5,"fseeko64","","",null,null],[5,"ftello64","","",null,null],[5,"fallocate","","",null,null],[5,"posix_fallocate","","",null,null],[5,"readahead","","",null,null],[5,"getxattr","","",null,null],[5,"lgetxattr","","",null,null],[5,"fgetxattr","","",null,null],[5,"setxattr","","",null,null],[5,"lsetxattr","","",null,null],[5,"fsetxattr","","",null,null],[5,"listxattr","","",null,null],[5,"llistxattr","","",null,null],[5,"flistxattr","","",null,null],[5,"removexattr","","",null,null],[5,"lremovexattr","","",null,null],[5,"fremovexattr","","",null,null],[5,"signalfd","","",null,null],[5,"timerfd_create","","",null,null],[5,"timerfd_gettime","","",null,null],[5,"timerfd_settime","","",null,null],[5,"pwritev","","",null,null],[5,"preadv","","",null,null],[5,"quotactl","","",null,null],[5,"mq_open","","",null,null],[5,"mq_close","","",null,null],[5,"mq_unlink","","",null,null],[5,"mq_receive","","",null,null],[5,"mq_send","","",null,null],[5,"mq_getattr","","",null,null],[5,"mq_setattr","","",null,null],[5,"epoll_pwait","","",null,null],[5,"dup3","","",null,null],[5,"mkostemp","","",null,null],[5,"mkostemps","","",null,null],[5,"sigtimedwait","","",null,null],[5,"sigwaitinfo","","",null,null],[5,"nl_langinfo_l","","",null,null],[5,"getnameinfo","","",null,null],[5,"pthread_setschedprio","","",null,null],[5,"prlimit","","",null,null],[5,"prlimit64","","",null,null],[5,"getloadavg","","",null,null],[5,"process_vm_readv","","",null,null],[5,"process_vm_writev","","",null,null],[5,"reboot","","",null,null],[5,"setfsgid","","",null,null],[5,"setfsuid","","",null,null],[5,"mkfifoat","","",null,null],[5,"if_nameindex","","",null,null],[5,"if_freenameindex","","",null,null],[5,"sync_file_range","","",null,null],[5,"getifaddrs","","",null,null],[5,"freeifaddrs","","",null,null],[5,"mremap","","",null,null],[5,"glob","","",null,null],[5,"globfree","","",null,null],[5,"posix_madvise","","",null,null],[5,"shm_unlink","","",null,null],[5,"seekdir","","",null,null],[5,"telldir","","",null,null],[5,"madvise","","",null,null],[5,"msync","","",null,null],[5,"remap_file_pages","","",null,null],[5,"recvfrom","","",null,null],[5,"mkstemps","","",null,null],[5,"futimes","","",null,null],[5,"nl_langinfo","","",null,null],[5,"bind","","",null,null],[5,"writev","","",null,null],[5,"readv","","",null,null],[5,"sendmsg","","",null,null],[5,"recvmsg","","",null,null],[5,"getdomainname","","",null,null],[5,"setdomainname","","",null,null],[5,"vhangup","","",null,null],[5,"sendmmsg","","",null,null],[5,"recvmmsg","","",null,null],[5,"sync","","",null,null],[5,"syscall","","",null,null],[5,"sched_getaffinity","","",null,null],[5,"sched_setaffinity","","",null,null],[5,"epoll_create","","",null,null],[5,"epoll_create1","","",null,null],[5,"epoll_wait","","",null,null],[5,"epoll_ctl","","",null,null],[5,"pthread_getschedparam","","",null,null],[5,"unshare","","",null,null],[5,"umount","","",null,null],[5,"sched_get_priority_max","","",null,null],[5,"tee","","",null,null],[5,"settimeofday","","",null,null],[5,"splice","","",null,null],[5,"eventfd","","",null,null],[5,"sched_rr_get_interval","","",null,null],[5,"sem_timedwait","","",null,null],[5,"sched_setparam","","",null,null],[5,"setns","","",null,null],[5,"swapoff","","",null,null],[5,"vmsplice","","",null,null],[5,"mount","","",null,null],[5,"personality","","",null,null],[5,"prctl","","",null,null],[5,"sched_getparam","","",null,null],[5,"ppoll","","",null,null],[5,"pthread_mutex_timedlock","","",null,null],[5,"clone","","",null,null],[5,"sched_getscheduler","","",null,null],[5,"clock_nanosleep","","",null,null],[5,"pthread_attr_getguardsize","","",null,null],[5,"sethostname","","",null,null],[5,"sched_get_priority_min","","",null,null],[5,"pthread_condattr_getpshared","","",null,null],[5,"sysinfo","","",null,null],[5,"umount2","","",null,null],[5,"pthread_setschedparam","","",null,null],[5,"swapon","","",null,null],[5,"sched_setscheduler","","",null,null],[5,"sendfile","","",null,null],[5,"sigsuspend","","",null,null],[5,"getgrgid_r","","",null,null],[5,"sigaltstack","","",null,null],[5,"sem_close","","",null,null],[5,"getdtablesize","","",null,null],[5,"getgrnam_r","","",null,null],[5,"initgroups","","",null,null],[5,"pthread_sigmask","","",null,null],[5,"sem_open","","",null,null],[5,"getgrnam","","",null,null],[5,"pthread_cancel","","",null,null],[5,"pthread_kill","","",null,null],[5,"sem_unlink","","",null,null],[5,"daemon","","",null,null],[5,"getpwnam_r","","",null,null],[5,"getpwuid_r","","",null,null],[5,"sigwait","","",null,null],[5,"pthread_atfork","","",null,null],[5,"getgrgid","","",null,null],[5,"getgrouplist","","",null,null],[5,"pthread_mutexattr_getpshared","","",null,null],[5,"popen","","",null,null],[5,"faccessat","","",null,null],[5,"pthread_create","","",null,null],[5,"dl_iterate_phdr","","",null,null],[5,"setmntent","","",null,null],[5,"getmntent","","",null,null],[5,"addmntent","","",null,null],[5,"endmntent","","",null,null],[5,"hasmntopt","","",null,null],[5,"posix_spawn","","",null,null],[5,"posix_spawnp","","",null,null],[5,"posix_spawnattr_init","","",null,null],[5,"posix_spawnattr_destroy","","",null,null],[5,"posix_spawnattr_getsigdefault","","",null,null],[5,"posix_spawnattr_setsigdefault","","",null,null],[5,"posix_spawnattr_getsigmask","","",null,null],[5,"posix_spawnattr_setsigmask","","",null,null],[5,"posix_spawnattr_getflags","","",null,null],[5,"posix_spawnattr_setflags","","",null,null],[5,"posix_spawnattr_getpgroup","","",null,null],[5,"posix_spawnattr_setpgroup","","",null,null],[5,"posix_spawnattr_getschedpolicy","","",null,null],[5,"posix_spawnattr_setschedpolicy","","",null,null],[5,"posix_spawnattr_getschedparam","","",null,null],[5,"posix_spawnattr_setschedparam","","",null,null],[5,"posix_spawn_file_actions_init","","",null,null],[5,"posix_spawn_file_actions_destroy","","",null,null],[5,"posix_spawn_file_actions_addopen","","",null,null],[5,"posix_spawn_file_actions_addclose","","",null,null],[5,"posix_spawn_file_actions_adddup2","","",null,null],[0,"other","","",null,null],[3,"aiocb","libc::unix::notbsd::linux::other","",null,null],[12,"aio_fildes","","",82,null],[12,"aio_lio_opcode","","",82,null],[12,"aio_reqprio","","",82,null],[12,"aio_buf","","",82,null],[12,"aio_nbytes","","",82,null],[12,"aio_sigevent","","",82,null],[12,"__next_prio","","",82,null],[12,"__abs_prio","","",82,null],[12,"__policy","","",82,null],[12,"__error_code","","",82,null],[12,"__return_value","","",82,null],[12,"aio_offset","","",82,null],[12,"__glibc_reserved","","",82,null],[3,"__exit_status","","",null,null],[12,"e_termination","","",83,null],[12,"e_exit","","",83,null],[3,"__timeval","","",null,null],[12,"tv_sec","","",84,null],[12,"tv_usec","","",84,null],[3,"utmpx","","",null,null],[12,"ut_type","","",85,null],[12,"ut_pid","","",85,null],[12,"ut_line","","",85,null],[12,"ut_id","","",85,null],[12,"ut_user","","",85,null],[12,"ut_host","","",85,null],[12,"ut_exit","","",85,null],[12,"ut_session","","",85,null],[12,"ut_tv","","",85,null],[12,"ut_addr_v6","","",85,null],[12,"__glibc_reserved","","",85,null],[3,"sigaction","","",null,null],[12,"sa_sigaction","","",86,null],[12,"sa_mask","","",86,null],[12,"sa_flags","","",86,null],[12,"sa_restorer","","",86,null],[3,"stack_t","","",null,null],[12,"ss_sp","","",87,null],[12,"ss_flags","","",87,null],[12,"ss_size","","",87,null],[3,"siginfo_t","","",null,null],[12,"si_signo","","",88,null],[12,"si_errno","","",88,null],[12,"si_code","","",88,null],[12,"_pad","","",88,null],[12,"_align","","",88,null],[3,"glob64_t","","",null,null],[12,"gl_pathc","","",89,null],[12,"gl_pathv","","",89,null],[12,"gl_offs","","",89,null],[12,"gl_flags","","",89,null],[12,"__unused1","","",89,null],[12,"__unused2","","",89,null],[12,"__unused3","","",89,null],[12,"__unused4","","",89,null],[12,"__unused5","","",89,null],[3,"statfs","","",null,null],[12,"f_type","","",90,null],[12,"f_bsize","","",90,null],[12,"f_blocks","","",90,null],[12,"f_bfree","","",90,null],[12,"f_bavail","","",90,null],[12,"f_files","","",90,null],[12,"f_ffree","","",90,null],[12,"f_fsid","","",90,null],[12,"f_namelen","","",90,null],[12,"f_frsize","","",90,null],[12,"f_spare","","",90,null],[3,"msghdr","","",null,null],[12,"msg_name","","",91,null],[12,"msg_namelen","","",91,null],[12,"msg_iov","","",91,null],[12,"msg_iovlen","","",91,null],[12,"msg_control","","",91,null],[12,"msg_controllen","","",91,null],[12,"msg_flags","","",91,null],[3,"cmsghdr","","",null,null],[12,"cmsg_len","","",92,null],[12,"cmsg_level","","",92,null],[12,"cmsg_type","","",92,null],[3,"termios","","",null,null],[12,"c_iflag","","",93,null],[12,"c_oflag","","",93,null],[12,"c_cflag","","",93,null],[12,"c_lflag","","",93,null],[12,"c_line","","",93,null],[12,"c_cc","","",93,null],[12,"c_ispeed","","",93,null],[12,"c_ospeed","","",93,null],[3,"flock","","",null,null],[12,"l_type","","",94,null],[12,"l_whence","","",94,null],[12,"l_start","","",94,null],[12,"l_len","","",94,null],[12,"l_pid","","",94,null],[3,"sem_t","","",null,null],[12,"__size","","",95,null],[12,"__align","","",95,null],[3,"mallinfo","","",null,null],[12,"arena","","",96,null],[12,"ordblks","","",96,null],[12,"smblks","","",96,null],[12,"hblks","","",96,null],[12,"hblkhd","","",96,null],[12,"usmblks","","",96,null],[12,"fsmblks","","",96,null],[12,"uordblks","","",96,null],[12,"fordblks","","",96,null],[12,"keepcost","","",96,null],[3,"nlmsghdr","","",null,null],[12,"nlmsg_len","","",97,null],[12,"nlmsg_type","","",97,null],[12,"nlmsg_flags","","",97,null],[12,"nlmsg_seq","","",97,null],[12,"nlmsg_pid","","",97,null],[3,"nlmsgerr","","",null,null],[12,"error","","",98,null],[12,"msg","","",98,null],[3,"nl_pktinfo","","",null,null],[12,"group","","",99,null],[3,"nl_mmap_req","","",null,null],[12,"nm_block_size","","",100,null],[12,"nm_block_nr","","",100,null],[12,"nm_frame_size","","",100,null],[12,"nm_frame_nr","","",100,null],[3,"nl_mmap_hdr","","",null,null],[12,"nm_status","","",101,null],[12,"nm_len","","",101,null],[12,"nm_group","","",101,null],[12,"nm_pid","","",101,null],[12,"nm_uid","","",101,null],[12,"nm_gid","","",101,null],[3,"nlattr","","",null,null],[12,"nla_len","","",102,null],[12,"nla_type","","",102,null],[5,"NLA_ALIGN","","",null,{"i":[{"n":"c_int"}],"o":{"n":"c_int"}}],[5,"utmpxname","","",null,null],[5,"getutxent","","",null,null],[5,"getutxid","","",null,null],[5,"getutxline","","",null,null],[5,"pututxline","","",null,null],[5,"setutxent","","",null,null],[5,"endutxent","","",null,null],[5,"getpt","","",null,null],[5,"ioctl","","",null,null],[5,"backtrace","","",null,null],[5,"glob64","","",null,null],[5,"globfree64","","",null,null],[5,"ptrace","","",null,null],[5,"pthread_attr_getaffinity_np","","",null,null],[5,"pthread_attr_setaffinity_np","","",null,null],[5,"getpriority","","",null,null],[5,"setpriority","","",null,null],[5,"pthread_getaffinity_np","","",null,null],[5,"pthread_setaffinity_np","","",null,null],[5,"pthread_rwlockattr_getkind_np","","",null,null],[5,"pthread_rwlockattr_setkind_np","","",null,null],[5,"sched_getcpu","","",null,null],[5,"mallinfo","","",null,null],[5,"malloc_usable_size","","",null,null],[5,"getauxval","","",null,null],[5,"getpwent_r","","",null,null],[5,"getgrent_r","","",null,null],[0,"b64","","64-bit specific definitions for linux-like values",null,null],[3,"sigset_t","libc::unix::notbsd::linux::other::b64","",null,null],[12,"__val","","",103,null],[3,"sysinfo","","",null,null],[12,"uptime","","",104,null],[12,"loads","","",104,null],[12,"totalram","","",104,null],[12,"freeram","","",104,null],[12,"sharedram","","",104,null],[12,"bufferram","","",104,null],[12,"totalswap","","",104,null],[12,"freeswap","","",104,null],[12,"procs","","",104,null],[12,"pad","","",104,null],[12,"totalhigh","","",104,null],[12,"freehigh","","",104,null],[12,"mem_unit","","",104,null],[12,"_f","","",104,null],[3,"msqid_ds","","",null,null],[12,"msg_perm","","",105,null],[12,"msg_stime","","",105,null],[12,"msg_rtime","","",105,null],[12,"msg_ctime","","",105,null],[12,"__msg_cbytes","","",105,null],[12,"msg_qnum","","",105,null],[12,"msg_qbytes","","",105,null],[12,"msg_lspid","","",105,null],[12,"msg_lrpid","","",105,null],[12,"__glibc_reserved4","","",105,null],[12,"__glibc_reserved5","","",105,null],[0,"x86_64","","x86_64-specific definitions for 64-bit linux-like values",null,null],[3,"stat","libc::unix::notbsd::linux::other::b64::x86_64","",null,null],[12,"st_dev","","",106,null],[12,"st_ino","","",106,null],[12,"st_nlink","","",106,null],[12,"st_mode","","",106,null],[12,"st_uid","","",106,null],[12,"st_gid","","",106,null],[12,"__pad0","","",106,null],[12,"st_rdev","","",106,null],[12,"st_size","","",106,null],[12,"st_blksize","","",106,null],[12,"st_blocks","","",106,null],[12,"st_atime","","",106,null],[12,"st_atime_nsec","","",106,null],[12,"st_mtime","","",106,null],[12,"st_mtime_nsec","","",106,null],[12,"st_ctime","","",106,null],[12,"st_ctime_nsec","","",106,null],[12,"__unused","","",106,null],[3,"stat64","","",null,null],[12,"st_dev","","",107,null],[12,"st_ino","","",107,null],[12,"st_nlink","","",107,null],[12,"st_mode","","",107,null],[12,"st_uid","","",107,null],[12,"st_gid","","",107,null],[12,"__pad0","","",107,null],[12,"st_rdev","","",107,null],[12,"st_size","","",107,null],[12,"st_blksize","","",107,null],[12,"st_blocks","","",107,null],[12,"st_atime","","",107,null],[12,"st_atime_nsec","","",107,null],[12,"st_mtime","","",107,null],[12,"st_mtime_nsec","","",107,null],[12,"st_ctime","","",107,null],[12,"st_ctime_nsec","","",107,null],[12,"__reserved","","",107,null],[3,"statfs64","","",null,null],[12,"f_type","","",108,null],[12,"f_bsize","","",108,null],[12,"f_blocks","","",108,null],[12,"f_bfree","","",108,null],[12,"f_bavail","","",108,null],[12,"f_files","","",108,null],[12,"f_ffree","","",108,null],[12,"f_fsid","","",108,null],[12,"f_namelen","","",108,null],[12,"f_frsize","","",108,null],[12,"f_flags","","",108,null],[12,"f_spare","","",108,null],[3,"statvfs64","","",null,null],[12,"f_bsize","","",109,null],[12,"f_frsize","","",109,null],[12,"f_blocks","","",109,null],[12,"f_bfree","","",109,null],[12,"f_bavail","","",109,null],[12,"f_files","","",109,null],[12,"f_ffree","","",109,null],[12,"f_favail","","",109,null],[12,"f_fsid","","",109,null],[12,"f_flag","","",109,null],[12,"f_namemax","","",109,null],[12,"__f_spare","","",109,null],[3,"pthread_attr_t","","",null,null],[12,"__size","","",110,null],[3,"_libc_fpxreg","","",null,null],[12,"significand","","",111,null],[12,"exponent","","",111,null],[12,"__private","","",111,null],[3,"_libc_xmmreg","","",null,null],[12,"element","","",112,null],[3,"_libc_fpstate","","",null,null],[12,"cwd","","",113,null],[12,"swd","","",113,null],[12,"ftw","","",113,null],[12,"fop","","",113,null],[12,"rip","","",113,null],[12,"rdp","","",113,null],[12,"mxcsr","","",113,null],[12,"mxcr_mask","","",113,null],[12,"_st","","",113,null],[12,"_xmm","","",113,null],[12,"__private","","",113,null],[3,"user_fpregs_struct","","",null,null],[12,"cwd","","",114,null],[12,"swd","","",114,null],[12,"ftw","","",114,null],[12,"fop","","",114,null],[12,"rip","","",114,null],[12,"rdp","","",114,null],[12,"mxcsr","","",114,null],[12,"mxcr_mask","","",114,null],[12,"st_space","","",114,null],[12,"xmm_space","","",114,null],[12,"padding","","",114,null],[3,"user_regs_struct","","",null,null],[12,"r15","","",115,null],[12,"r14","","",115,null],[12,"r13","","",115,null],[12,"r12","","",115,null],[12,"rbp","","",115,null],[12,"rbx","","",115,null],[12,"r11","","",115,null],[12,"r10","","",115,null],[12,"r9","","",115,null],[12,"r8","","",115,null],[12,"rax","","",115,null],[12,"rcx","","",115,null],[12,"rdx","","",115,null],[12,"rsi","","",115,null],[12,"rdi","","",115,null],[12,"orig_rax","","",115,null],[12,"rip","","",115,null],[12,"cs","","",115,null],[12,"eflags","","",115,null],[12,"rsp","","",115,null],[12,"ss","","",115,null],[12,"fs_base","","",115,null],[12,"gs_base","","",115,null],[12,"ds","","",115,null],[12,"es","","",115,null],[12,"fs","","",115,null],[12,"gs","","",115,null],[3,"user","","",null,null],[12,"regs","","",116,null],[12,"u_fpvalid","","",116,null],[12,"i387","","",116,null],[12,"u_tsize","","",116,null],[12,"u_dsize","","",116,null],[12,"u_ssize","","",116,null],[12,"start_code","","",116,null],[12,"start_stack","","",116,null],[12,"signal","","",116,null],[12,"__reserved","","",116,null],[12,"u_ar0","","",116,null],[12,"u_fpstate","","",116,null],[12,"magic","","",116,null],[12,"u_comm","","",116,null],[12,"u_debugreg","","",116,null],[3,"mcontext_t","","",null,null],[12,"gregs","","",117,null],[12,"fpregs","","",117,null],[12,"__private","","",117,null],[3,"ucontext_t","","",null,null],[12,"uc_flags","","",118,null],[12,"uc_link","","",118,null],[12,"uc_stack","","",118,null],[12,"uc_mcontext","","",118,null],[12,"uc_sigmask","","",118,null],[12,"__private","","",118,null],[3,"ipc_perm","","",null,null],[12,"__key","","",119,null],[12,"uid","","",119,null],[12,"gid","","",119,null],[12,"cuid","","",119,null],[12,"cgid","","",119,null],[12,"mode","","",119,null],[12,"__pad1","","",119,null],[12,"__seq","","",119,null],[12,"__pad2","","",119,null],[12,"__unused1","","",119,null],[12,"__unused2","","",119,null],[3,"shmid_ds","","",null,null],[12,"shm_perm","","",120,null],[12,"shm_segsz","","",120,null],[12,"shm_atime","","",120,null],[12,"shm_dtime","","",120,null],[12,"shm_ctime","","",120,null],[12,"shm_cpid","","",120,null],[12,"shm_lpid","","",120,null],[12,"shm_nattch","","",120,null],[12,"__unused4","","",120,null],[12,"__unused5","","",120,null],[3,"termios2","","",null,null],[12,"c_iflag","","",121,null],[12,"c_oflag","","",121,null],[12,"c_cflag","","",121,null],[12,"c_lflag","","",121,null],[12,"c_line","","",121,null],[12,"c_cc","","",121,null],[12,"c_ispeed","","",121,null],[12,"c_ospeed","","",121,null],[5,"getcontext","","",null,null],[5,"setcontext","","",null,null],[5,"makecontext","","",null,null],[5,"swapcontext","","",null,null],[5,"iopl","","",null,null],[5,"ioperm","","",null,null],[6,"c_char","","",null,null],[6,"wchar_t","","",null,null],[6,"nlink_t","","",null,null],[6,"blksize_t","","",null,null],[6,"greg_t","","",null,null],[6,"suseconds_t","","",null,null],[6,"__u64","","",null,null],[17,"TIOCGSOFTCAR","","",null,null],[17,"TIOCSSOFTCAR","","",null,null],[17,"RLIMIT_NOFILE","","",null,null],[17,"RLIMIT_NPROC","","",null,null],[17,"O_APPEND","","",null,null],[17,"O_CREAT","","",null,null],[17,"O_EXCL","","",null,null],[17,"O_NOCTTY","","",null,null],[17,"O_NONBLOCK","","",null,null],[17,"O_SYNC","","",null,null],[17,"O_RSYNC","","",null,null],[17,"O_DSYNC","","",null,null],[17,"O_FSYNC","","",null,null],[17,"O_NOATIME","","",null,null],[17,"O_PATH","","",null,null],[17,"O_TMPFILE","","",null,null],[17,"MAP_GROWSDOWN","","",null,null],[17,"EDEADLK","","",null,null],[17,"ENAMETOOLONG","","",null,null],[17,"ENOLCK","","",null,null],[17,"ENOSYS","","",null,null],[17,"ENOTEMPTY","","",null,null],[17,"ELOOP","","",null,null],[17,"ENOMSG","","",null,null],[17,"EIDRM","","",null,null],[17,"ECHRNG","","",null,null],[17,"EL2NSYNC","","",null,null],[17,"EL3HLT","","",null,null],[17,"EL3RST","","",null,null],[17,"ELNRNG","","",null,null],[17,"EUNATCH","","",null,null],[17,"ENOCSI","","",null,null],[17,"EL2HLT","","",null,null],[17,"EBADE","","",null,null],[17,"EBADR","","",null,null],[17,"EXFULL","","",null,null],[17,"ENOANO","","",null,null],[17,"EBADRQC","","",null,null],[17,"EBADSLT","","",null,null],[17,"EMULTIHOP","","",null,null],[17,"EOVERFLOW","","",null,null],[17,"ENOTUNIQ","","",null,null],[17,"EBADFD","","",null,null],[17,"EBADMSG","","",null,null],[17,"EREMCHG","","",null,null],[17,"ELIBACC","","",null,null],[17,"ELIBBAD","","",null,null],[17,"ELIBSCN","","",null,null],[17,"ELIBMAX","","",null,null],[17,"ELIBEXEC","","",null,null],[17,"EILSEQ","","",null,null],[17,"ERESTART","","",null,null],[17,"ESTRPIPE","","",null,null],[17,"EUSERS","","",null,null],[17,"ENOTSOCK","","",null,null],[17,"EDESTADDRREQ","","",null,null],[17,"EMSGSIZE","","",null,null],[17,"EPROTOTYPE","","",null,null],[17,"ENOPROTOOPT","","",null,null],[17,"EPROTONOSUPPORT","","",null,null],[17,"ESOCKTNOSUPPORT","","",null,null],[17,"EOPNOTSUPP","","",null,null],[17,"EPFNOSUPPORT","","",null,null],[17,"EAFNOSUPPORT","","",null,null],[17,"EADDRINUSE","","",null,null],[17,"EADDRNOTAVAIL","","",null,null],[17,"ENETDOWN","","",null,null],[17,"ENETUNREACH","","",null,null],[17,"ENETRESET","","",null,null],[17,"ECONNABORTED","","",null,null],[17,"ECONNRESET","","",null,null],[17,"ENOBUFS","","",null,null],[17,"EISCONN","","",null,null],[17,"ENOTCONN","","",null,null],[17,"ESHUTDOWN","","",null,null],[17,"ETOOMANYREFS","","",null,null],[17,"ETIMEDOUT","","",null,null],[17,"ECONNREFUSED","","",null,null],[17,"EHOSTDOWN","","",null,null],[17,"EHOSTUNREACH","","",null,null],[17,"EALREADY","","",null,null],[17,"EINPROGRESS","","",null,null],[17,"ESTALE","","",null,null],[17,"EDQUOT","","",null,null],[17,"ENOMEDIUM","","",null,null],[17,"EMEDIUMTYPE","","",null,null],[17,"ECANCELED","","",null,null],[17,"ENOKEY","","",null,null],[17,"EKEYEXPIRED","","",null,null],[17,"EKEYREVOKED","","",null,null],[17,"EKEYREJECTED","","",null,null],[17,"EOWNERDEAD","","",null,null],[17,"ENOTRECOVERABLE","","",null,null],[17,"EHWPOISON","","",null,null],[17,"ERFKILL","","",null,null],[17,"SOL_SOCKET","","",null,null],[17,"SO_REUSEADDR","","",null,null],[17,"SO_TYPE","","",null,null],[17,"SO_ERROR","","",null,null],[17,"SO_DONTROUTE","","",null,null],[17,"SO_BROADCAST","","",null,null],[17,"SO_SNDBUF","","",null,null],[17,"SO_RCVBUF","","",null,null],[17,"SO_SNDBUFFORCE","","",null,null],[17,"SO_RCVBUFFORCE","","",null,null],[17,"SO_KEEPALIVE","","",null,null],[17,"SO_OOBINLINE","","",null,null],[17,"SO_NO_CHECK","","",null,null],[17,"SO_PRIORITY","","",null,null],[17,"SO_LINGER","","",null,null],[17,"SO_BSDCOMPAT","","",null,null],[17,"SO_REUSEPORT","","",null,null],[17,"SO_PASSCRED","","",null,null],[17,"SO_PEERCRED","","",null,null],[17,"SO_RCVLOWAT","","",null,null],[17,"SO_SNDLOWAT","","",null,null],[17,"SO_RCVTIMEO","","",null,null],[17,"SO_SNDTIMEO","","",null,null],[17,"SO_SECURITY_AUTHENTICATION","","",null,null],[17,"SO_SECURITY_ENCRYPTION_TRANSPORT","","",null,null],[17,"SO_SECURITY_ENCRYPTION_NETWORK","","",null,null],[17,"SO_BINDTODEVICE","","",null,null],[17,"SO_ATTACH_FILTER","","",null,null],[17,"SO_DETACH_FILTER","","",null,null],[17,"SO_GET_FILTER","","",null,null],[17,"SO_PEERNAME","","",null,null],[17,"SO_TIMESTAMP","","",null,null],[17,"SO_ACCEPTCONN","","",null,null],[17,"SO_PEERSEC","","",null,null],[17,"SO_PASSSEC","","",null,null],[17,"SO_TIMESTAMPNS","","",null,null],[17,"SCM_TIMESTAMPNS","","",null,null],[17,"SO_MARK","","",null,null],[17,"SO_TIMESTAMPING","","",null,null],[17,"SCM_TIMESTAMPING","","",null,null],[17,"SO_PROTOCOL","","",null,null],[17,"SO_DOMAIN","","",null,null],[17,"SO_RXQ_OVFL","","",null,null],[17,"SO_WIFI_STATUS","","",null,null],[17,"SCM_WIFI_STATUS","","",null,null],[17,"SO_PEEK_OFF","","",null,null],[17,"SO_NOFCS","","",null,null],[17,"SO_LOCK_FILTER","","",null,null],[17,"SO_SELECT_ERR_QUEUE","","",null,null],[17,"SO_BUSY_POLL","","",null,null],[17,"SO_MAX_PACING_RATE","","",null,null],[17,"SO_BPF_EXTENSIONS","","",null,null],[17,"SO_INCOMING_CPU","","",null,null],[17,"SO_ATTACH_BPF","","",null,null],[17,"SO_DETACH_BPF","","",null,null],[17,"SA_ONSTACK","","",null,null],[17,"SA_SIGINFO","","",null,null],[17,"SA_NOCLDWAIT","","",null,null],[17,"SIGCHLD","","",null,null],[17,"SIGBUS","","",null,null],[17,"SIGUSR1","","",null,null],[17,"SIGUSR2","","",null,null],[17,"SIGCONT","","",null,null],[17,"SIGSTOP","","",null,null],[17,"SIGTSTP","","",null,null],[17,"SIGURG","","",null,null],[17,"SIGIO","","",null,null],[17,"SIGSYS","","",null,null],[17,"SIGSTKFLT","","",null,null],[17,"SIGUNUSED","","",null,null],[17,"SIGPOLL","","",null,null],[17,"SIGPWR","","",null,null],[17,"SIG_SETMASK","","",null,null],[17,"SIG_BLOCK","","",null,null],[17,"SIG_UNBLOCK","","",null,null],[17,"POLLWRNORM","","",null,null],[17,"POLLWRBAND","","",null,null],[17,"O_ASYNC","","",null,null],[17,"O_NDELAY","","",null,null],[17,"PTRACE_DETACH","","",null,null],[17,"EFD_NONBLOCK","","",null,null],[17,"F_GETLK","","",null,null],[17,"F_GETOWN","","",null,null],[17,"F_SETOWN","","",null,null],[17,"F_SETLK","","",null,null],[17,"F_SETLKW","","",null,null],[17,"SFD_NONBLOCK","","",null,null],[17,"TIOCEXCL","","",null,null],[17,"TIOCNXCL","","",null,null],[17,"TIOCSCTTY","","",null,null],[17,"TIOCSTI","","",null,null],[17,"TIOCMGET","","",null,null],[17,"TIOCMBIS","","",null,null],[17,"TIOCMBIC","","",null,null],[17,"TIOCMSET","","",null,null],[17,"TIOCCONS","","",null,null],[17,"SFD_CLOEXEC","","",null,null],[17,"NCCS","","",null,null],[17,"O_TRUNC","","",null,null],[17,"O_CLOEXEC","","",null,null],[17,"EBFONT","","",null,null],[17,"ENOSTR","","",null,null],[17,"ENODATA","","",null,null],[17,"ETIME","","",null,null],[17,"ENOSR","","",null,null],[17,"ENONET","","",null,null],[17,"ENOPKG","","",null,null],[17,"EREMOTE","","",null,null],[17,"ENOLINK","","",null,null],[17,"EADV","","",null,null],[17,"ESRMNT","","",null,null],[17,"ECOMM","","",null,null],[17,"EPROTO","","",null,null],[17,"EDOTDOT","","",null,null],[17,"SA_NODEFER","","",null,null],[17,"SA_RESETHAND","","",null,null],[17,"SA_RESTART","","",null,null],[17,"SA_NOCLDSTOP","","",null,null],[17,"EPOLL_CLOEXEC","","",null,null],[17,"EFD_CLOEXEC","","",null,null],[17,"__SIZEOF_PTHREAD_CONDATTR_T","","",null,null],[17,"__SIZEOF_PTHREAD_MUTEXATTR_T","","",null,null],[17,"O_DIRECT","","",null,null],[17,"O_DIRECTORY","","",null,null],[17,"O_NOFOLLOW","","",null,null],[17,"MAP_LOCKED","","",null,null],[17,"MAP_NORESERVE","","",null,null],[17,"MAP_32BIT","","",null,null],[17,"EDEADLOCK","","",null,null],[17,"FIOCLEX","","",null,null],[17,"FIONBIO","","",null,null],[17,"PTRACE_GETFPREGS","","",null,null],[17,"PTRACE_SETFPREGS","","",null,null],[17,"PTRACE_GETFPXREGS","","",null,null],[17,"PTRACE_SETFPXREGS","","",null,null],[17,"PTRACE_GETREGS","","",null,null],[17,"PTRACE_SETREGS","","",null,null],[17,"PTRACE_PEEKSIGINFO_SHARED","","",null,null],[17,"MCL_CURRENT","","",null,null],[17,"MCL_FUTURE","","",null,null],[17,"SIGSTKSZ","","",null,null],[17,"MINSIGSTKSZ","","",null,null],[17,"CBAUD","","",null,null],[17,"TAB1","","",null,null],[17,"TAB2","","",null,null],[17,"TAB3","","",null,null],[17,"CR1","","",null,null],[17,"CR2","","",null,null],[17,"CR3","","",null,null],[17,"FF1","","",null,null],[17,"BS1","","",null,null],[17,"VT1","","",null,null],[17,"VWERASE","","",null,null],[17,"VREPRINT","","",null,null],[17,"VSUSP","","",null,null],[17,"VSTART","","",null,null],[17,"VSTOP","","",null,null],[17,"VDISCARD","","",null,null],[17,"VTIME","","",null,null],[17,"IXON","","",null,null],[17,"IXOFF","","",null,null],[17,"ONLCR","","",null,null],[17,"CSIZE","","",null,null],[17,"CS6","","",null,null],[17,"CS7","","",null,null],[17,"CS8","","",null,null],[17,"CSTOPB","","",null,null],[17,"CREAD","","",null,null],[17,"PARENB","","",null,null],[17,"PARODD","","",null,null],[17,"HUPCL","","",null,null],[17,"CLOCAL","","",null,null],[17,"ECHOKE","","",null,null],[17,"ECHOE","","",null,null],[17,"ECHOK","","",null,null],[17,"ECHONL","","",null,null],[17,"ECHOPRT","","",null,null],[17,"ECHOCTL","","",null,null],[17,"ISIG","","",null,null],[17,"ICANON","","",null,null],[17,"PENDIN","","",null,null],[17,"NOFLSH","","",null,null],[17,"CIBAUD","","",null,null],[17,"CBAUDEX","","",null,null],[17,"VSWTC","","",null,null],[17,"OLCUC","","",null,null],[17,"NLDLY","","",null,null],[17,"CRDLY","","",null,null],[17,"TABDLY","","",null,null],[17,"BSDLY","","",null,null],[17,"FFDLY","","",null,null],[17,"VTDLY","","",null,null],[17,"XTABS","","",null,null],[17,"B0","","",null,null],[17,"B50","","",null,null],[17,"B75","","",null,null],[17,"B110","","",null,null],[17,"B134","","",null,null],[17,"B150","","",null,null],[17,"B200","","",null,null],[17,"B300","","",null,null],[17,"B600","","",null,null],[17,"B1200","","",null,null],[17,"B1800","","",null,null],[17,"B2400","","",null,null],[17,"B4800","","",null,null],[17,"B9600","","",null,null],[17,"B19200","","",null,null],[17,"B38400","","",null,null],[17,"EXTA","","",null,null],[17,"EXTB","","",null,null],[17,"BOTHER","","",null,null],[17,"B57600","","",null,null],[17,"B115200","","",null,null],[17,"B230400","","",null,null],[17,"B460800","","",null,null],[17,"B500000","","",null,null],[17,"B576000","","",null,null],[17,"B921600","","",null,null],[17,"B1000000","","",null,null],[17,"B1152000","","",null,null],[17,"B1500000","","",null,null],[17,"B2000000","","",null,null],[17,"B2500000","","",null,null],[17,"B3000000","","",null,null],[17,"B3500000","","",null,null],[17,"B4000000","","",null,null],[17,"VEOL","","",null,null],[17,"VEOL2","","",null,null],[17,"VMIN","","",null,null],[17,"IEXTEN","","",null,null],[17,"TOSTOP","","",null,null],[17,"FLUSHO","","",null,null],[17,"EXTPROC","","",null,null],[17,"TCGETS","","",null,null],[17,"TCSETS","","",null,null],[17,"TCSETSW","","",null,null],[17,"TCSETSF","","",null,null],[17,"TCGETA","","",null,null],[17,"TCSETA","","",null,null],[17,"TCSETAW","","",null,null],[17,"TCSETAF","","",null,null],[17,"TCSBRK","","",null,null],[17,"TCXONC","","",null,null],[17,"TCFLSH","","",null,null],[17,"TIOCINQ","","",null,null],[17,"TIOCGPGRP","","",null,null],[17,"TIOCSPGRP","","",null,null],[17,"TIOCOUTQ","","",null,null],[17,"TIOCGWINSZ","","",null,null],[17,"TIOCSWINSZ","","",null,null],[17,"FIONREAD","","",null,null],[17,"R15","","",null,null],[17,"R14","","",null,null],[17,"R13","","",null,null],[17,"R12","","",null,null],[17,"RBP","","",null,null],[17,"RBX","","",null,null],[17,"R11","","",null,null],[17,"R10","","",null,null],[17,"R9","","",null,null],[17,"R8","","",null,null],[17,"RAX","","",null,null],[17,"RCX","","",null,null],[17,"RDX","","",null,null],[17,"RSI","","",null,null],[17,"RDI","","",null,null],[17,"ORIG_RAX","","",null,null],[17,"RIP","","",null,null],[17,"CS","","",null,null],[17,"EFLAGS","","",null,null],[17,"RSP","","",null,null],[17,"SS","","",null,null],[17,"FS_BASE","","",null,null],[17,"GS_BASE","","",null,null],[17,"DS","","",null,null],[17,"ES","","",null,null],[17,"FS","","",null,null],[17,"GS","","",null,null],[11,"clone","libc","",106,{"i":[{"n":"self"}],"o":{"n":"stat"}}],[11,"clone","","",107,{"i":[{"n":"self"}],"o":{"n":"stat64"}}],[11,"clone","","",108,{"i":[{"n":"self"}],"o":{"n":"statfs64"}}],[11,"clone","","",109,{"i":[{"n":"self"}],"o":{"n":"statvfs64"}}],[11,"clone","","",110,{"i":[{"n":"self"}],"o":{"n":"pthread_attr_t"}}],[11,"clone","","",111,{"i":[{"n":"self"}],"o":{"n":"_libc_fpxreg"}}],[11,"clone","","",112,{"i":[{"n":"self"}],"o":{"n":"_libc_xmmreg"}}],[11,"clone","","",113,{"i":[{"n":"self"}],"o":{"n":"_libc_fpstate"}}],[11,"clone","","",114,{"i":[{"n":"self"}],"o":{"n":"user_fpregs_struct"}}],[11,"clone","","",115,{"i":[{"n":"self"}],"o":{"n":"user_regs_struct"}}],[11,"clone","","",116,{"i":[{"n":"self"}],"o":{"n":"user"}}],[11,"clone","","",117,{"i":[{"n":"self"}],"o":{"n":"mcontext_t"}}],[11,"clone","","",118,{"i":[{"n":"self"}],"o":{"n":"ucontext_t"}}],[11,"clone","","",119,{"i":[{"n":"self"}],"o":{"n":"ipc_perm"}}],[11,"clone","","",120,{"i":[{"n":"self"}],"o":{"n":"shmid_ds"}}],[11,"clone","","",121,{"i":[{"n":"self"}],"o":{"n":"termios2"}}],[0,"not_x32","libc::unix::notbsd::linux::other::b64","",null,null],[5,"sysctl","libc::unix::notbsd::linux::other::b64::not_x32","",null,null],[6,"c_long","","",null,null],[6,"c_ulong","","",null,null],[17,"__SIZEOF_PTHREAD_MUTEX_T","","",null,null],[17,"__SIZEOF_PTHREAD_RWLOCK_T","","",null,null],[17,"SYS_read","","",null,null],[17,"SYS_write","","",null,null],[17,"SYS_open","","",null,null],[17,"SYS_close","","",null,null],[17,"SYS_stat","","",null,null],[17,"SYS_fstat","","",null,null],[17,"SYS_lstat","","",null,null],[17,"SYS_poll","","",null,null],[17,"SYS_lseek","","",null,null],[17,"SYS_mmap","","",null,null],[17,"SYS_mprotect","","",null,null],[17,"SYS_munmap","","",null,null],[17,"SYS_brk","","",null,null],[17,"SYS_rt_sigaction","","",null,null],[17,"SYS_rt_sigprocmask","","",null,null],[17,"SYS_rt_sigreturn","","",null,null],[17,"SYS_ioctl","","",null,null],[17,"SYS_pread64","","",null,null],[17,"SYS_pwrite64","","",null,null],[17,"SYS_readv","","",null,null],[17,"SYS_writev","","",null,null],[17,"SYS_access","","",null,null],[17,"SYS_pipe","","",null,null],[17,"SYS_select","","",null,null],[17,"SYS_sched_yield","","",null,null],[17,"SYS_mremap","","",null,null],[17,"SYS_msync","","",null,null],[17,"SYS_mincore","","",null,null],[17,"SYS_madvise","","",null,null],[17,"SYS_shmget","","",null,null],[17,"SYS_shmat","","",null,null],[17,"SYS_shmctl","","",null,null],[17,"SYS_dup","","",null,null],[17,"SYS_dup2","","",null,null],[17,"SYS_pause","","",null,null],[17,"SYS_nanosleep","","",null,null],[17,"SYS_getitimer","","",null,null],[17,"SYS_alarm","","",null,null],[17,"SYS_setitimer","","",null,null],[17,"SYS_getpid","","",null,null],[17,"SYS_sendfile","","",null,null],[17,"SYS_socket","","",null,null],[17,"SYS_connect","","",null,null],[17,"SYS_accept","","",null,null],[17,"SYS_sendto","","",null,null],[17,"SYS_recvfrom","","",null,null],[17,"SYS_sendmsg","","",null,null],[17,"SYS_recvmsg","","",null,null],[17,"SYS_shutdown","","",null,null],[17,"SYS_bind","","",null,null],[17,"SYS_listen","","",null,null],[17,"SYS_getsockname","","",null,null],[17,"SYS_getpeername","","",null,null],[17,"SYS_socketpair","","",null,null],[17,"SYS_setsockopt","","",null,null],[17,"SYS_getsockopt","","",null,null],[17,"SYS_clone","","",null,null],[17,"SYS_fork","","",null,null],[17,"SYS_vfork","","",null,null],[17,"SYS_execve","","",null,null],[17,"SYS_exit","","",null,null],[17,"SYS_wait4","","",null,null],[17,"SYS_kill","","",null,null],[17,"SYS_uname","","",null,null],[17,"SYS_semget","","",null,null],[17,"SYS_semop","","",null,null],[17,"SYS_semctl","","",null,null],[17,"SYS_shmdt","","",null,null],[17,"SYS_msgget","","",null,null],[17,"SYS_msgsnd","","",null,null],[17,"SYS_msgrcv","","",null,null],[17,"SYS_msgctl","","",null,null],[17,"SYS_fcntl","","",null,null],[17,"SYS_flock","","",null,null],[17,"SYS_fsync","","",null,null],[17,"SYS_fdatasync","","",null,null],[17,"SYS_truncate","","",null,null],[17,"SYS_ftruncate","","",null,null],[17,"SYS_getdents","","",null,null],[17,"SYS_getcwd","","",null,null],[17,"SYS_chdir","","",null,null],[17,"SYS_fchdir","","",null,null],[17,"SYS_rename","","",null,null],[17,"SYS_mkdir","","",null,null],[17,"SYS_rmdir","","",null,null],[17,"SYS_creat","","",null,null],[17,"SYS_link","","",null,null],[17,"SYS_unlink","","",null,null],[17,"SYS_symlink","","",null,null],[17,"SYS_readlink","","",null,null],[17,"SYS_chmod","","",null,null],[17,"SYS_fchmod","","",null,null],[17,"SYS_chown","","",null,null],[17,"SYS_fchown","","",null,null],[17,"SYS_lchown","","",null,null],[17,"SYS_umask","","",null,null],[17,"SYS_gettimeofday","","",null,null],[17,"SYS_getrlimit","","",null,null],[17,"SYS_getrusage","","",null,null],[17,"SYS_sysinfo","","",null,null],[17,"SYS_times","","",null,null],[17,"SYS_ptrace","","",null,null],[17,"SYS_getuid","","",null,null],[17,"SYS_syslog","","",null,null],[17,"SYS_getgid","","",null,null],[17,"SYS_setuid","","",null,null],[17,"SYS_setgid","","",null,null],[17,"SYS_geteuid","","",null,null],[17,"SYS_getegid","","",null,null],[17,"SYS_setpgid","","",null,null],[17,"SYS_getppid","","",null,null],[17,"SYS_getpgrp","","",null,null],[17,"SYS_setsid","","",null,null],[17,"SYS_setreuid","","",null,null],[17,"SYS_setregid","","",null,null],[17,"SYS_getgroups","","",null,null],[17,"SYS_setgroups","","",null,null],[17,"SYS_setresuid","","",null,null],[17,"SYS_getresuid","","",null,null],[17,"SYS_setresgid","","",null,null],[17,"SYS_getresgid","","",null,null],[17,"SYS_getpgid","","",null,null],[17,"SYS_setfsuid","","",null,null],[17,"SYS_setfsgid","","",null,null],[17,"SYS_getsid","","",null,null],[17,"SYS_capget","","",null,null],[17,"SYS_capset","","",null,null],[17,"SYS_rt_sigpending","","",null,null],[17,"SYS_rt_sigtimedwait","","",null,null],[17,"SYS_rt_sigqueueinfo","","",null,null],[17,"SYS_rt_sigsuspend","","",null,null],[17,"SYS_sigaltstack","","",null,null],[17,"SYS_utime","","",null,null],[17,"SYS_mknod","","",null,null],[17,"SYS_uselib","","",null,null],[17,"SYS_personality","","",null,null],[17,"SYS_ustat","","",null,null],[17,"SYS_statfs","","",null,null],[17,"SYS_fstatfs","","",null,null],[17,"SYS_sysfs","","",null,null],[17,"SYS_getpriority","","",null,null],[17,"SYS_setpriority","","",null,null],[17,"SYS_sched_setparam","","",null,null],[17,"SYS_sched_getparam","","",null,null],[17,"SYS_sched_setscheduler","","",null,null],[17,"SYS_sched_getscheduler","","",null,null],[17,"SYS_sched_get_priority_max","","",null,null],[17,"SYS_sched_get_priority_min","","",null,null],[17,"SYS_sched_rr_get_interval","","",null,null],[17,"SYS_mlock","","",null,null],[17,"SYS_munlock","","",null,null],[17,"SYS_mlockall","","",null,null],[17,"SYS_munlockall","","",null,null],[17,"SYS_vhangup","","",null,null],[17,"SYS_modify_ldt","","",null,null],[17,"SYS_pivot_root","","",null,null],[17,"SYS__sysctl","","",null,null],[17,"SYS_prctl","","",null,null],[17,"SYS_arch_prctl","","",null,null],[17,"SYS_adjtimex","","",null,null],[17,"SYS_setrlimit","","",null,null],[17,"SYS_chroot","","",null,null],[17,"SYS_sync","","",null,null],[17,"SYS_acct","","",null,null],[17,"SYS_settimeofday","","",null,null],[17,"SYS_mount","","",null,null],[17,"SYS_umount2","","",null,null],[17,"SYS_swapon","","",null,null],[17,"SYS_swapoff","","",null,null],[17,"SYS_reboot","","",null,null],[17,"SYS_sethostname","","",null,null],[17,"SYS_setdomainname","","",null,null],[17,"SYS_iopl","","",null,null],[17,"SYS_ioperm","","",null,null],[17,"SYS_create_module","","",null,null],[17,"SYS_init_module","","",null,null],[17,"SYS_delete_module","","",null,null],[17,"SYS_get_kernel_syms","","",null,null],[17,"SYS_query_module","","",null,null],[17,"SYS_quotactl","","",null,null],[17,"SYS_nfsservctl","","",null,null],[17,"SYS_getpmsg","","",null,null],[17,"SYS_putpmsg","","",null,null],[17,"SYS_afs_syscall","","",null,null],[17,"SYS_tuxcall","","",null,null],[17,"SYS_security","","",null,null],[17,"SYS_gettid","","",null,null],[17,"SYS_readahead","","",null,null],[17,"SYS_setxattr","","",null,null],[17,"SYS_lsetxattr","","",null,null],[17,"SYS_fsetxattr","","",null,null],[17,"SYS_getxattr","","",null,null],[17,"SYS_lgetxattr","","",null,null],[17,"SYS_fgetxattr","","",null,null],[17,"SYS_listxattr","","",null,null],[17,"SYS_llistxattr","","",null,null],[17,"SYS_flistxattr","","",null,null],[17,"SYS_removexattr","","",null,null],[17,"SYS_lremovexattr","","",null,null],[17,"SYS_fremovexattr","","",null,null],[17,"SYS_tkill","","",null,null],[17,"SYS_time","","",null,null],[17,"SYS_futex","","",null,null],[17,"SYS_sched_setaffinity","","",null,null],[17,"SYS_sched_getaffinity","","",null,null],[17,"SYS_set_thread_area","","",null,null],[17,"SYS_io_setup","","",null,null],[17,"SYS_io_destroy","","",null,null],[17,"SYS_io_getevents","","",null,null],[17,"SYS_io_submit","","",null,null],[17,"SYS_io_cancel","","",null,null],[17,"SYS_get_thread_area","","",null,null],[17,"SYS_lookup_dcookie","","",null,null],[17,"SYS_epoll_create","","",null,null],[17,"SYS_epoll_ctl_old","","",null,null],[17,"SYS_epoll_wait_old","","",null,null],[17,"SYS_remap_file_pages","","",null,null],[17,"SYS_getdents64","","",null,null],[17,"SYS_set_tid_address","","",null,null],[17,"SYS_restart_syscall","","",null,null],[17,"SYS_semtimedop","","",null,null],[17,"SYS_fadvise64","","",null,null],[17,"SYS_timer_create","","",null,null],[17,"SYS_timer_settime","","",null,null],[17,"SYS_timer_gettime","","",null,null],[17,"SYS_timer_getoverrun","","",null,null],[17,"SYS_timer_delete","","",null,null],[17,"SYS_clock_settime","","",null,null],[17,"SYS_clock_gettime","","",null,null],[17,"SYS_clock_getres","","",null,null],[17,"SYS_clock_nanosleep","","",null,null],[17,"SYS_exit_group","","",null,null],[17,"SYS_epoll_wait","","",null,null],[17,"SYS_epoll_ctl","","",null,null],[17,"SYS_tgkill","","",null,null],[17,"SYS_utimes","","",null,null],[17,"SYS_vserver","","",null,null],[17,"SYS_mbind","","",null,null],[17,"SYS_set_mempolicy","","",null,null],[17,"SYS_get_mempolicy","","",null,null],[17,"SYS_mq_open","","",null,null],[17,"SYS_mq_unlink","","",null,null],[17,"SYS_mq_timedsend","","",null,null],[17,"SYS_mq_timedreceive","","",null,null],[17,"SYS_mq_notify","","",null,null],[17,"SYS_mq_getsetattr","","",null,null],[17,"SYS_kexec_load","","",null,null],[17,"SYS_waitid","","",null,null],[17,"SYS_add_key","","",null,null],[17,"SYS_request_key","","",null,null],[17,"SYS_keyctl","","",null,null],[17,"SYS_ioprio_set","","",null,null],[17,"SYS_ioprio_get","","",null,null],[17,"SYS_inotify_init","","",null,null],[17,"SYS_inotify_add_watch","","",null,null],[17,"SYS_inotify_rm_watch","","",null,null],[17,"SYS_migrate_pages","","",null,null],[17,"SYS_openat","","",null,null],[17,"SYS_mkdirat","","",null,null],[17,"SYS_mknodat","","",null,null],[17,"SYS_fchownat","","",null,null],[17,"SYS_futimesat","","",null,null],[17,"SYS_newfstatat","","",null,null],[17,"SYS_unlinkat","","",null,null],[17,"SYS_renameat","","",null,null],[17,"SYS_linkat","","",null,null],[17,"SYS_symlinkat","","",null,null],[17,"SYS_readlinkat","","",null,null],[17,"SYS_fchmodat","","",null,null],[17,"SYS_faccessat","","",null,null],[17,"SYS_pselect6","","",null,null],[17,"SYS_ppoll","","",null,null],[17,"SYS_unshare","","",null,null],[17,"SYS_set_robust_list","","",null,null],[17,"SYS_get_robust_list","","",null,null],[17,"SYS_splice","","",null,null],[17,"SYS_tee","","",null,null],[17,"SYS_sync_file_range","","",null,null],[17,"SYS_vmsplice","","",null,null],[17,"SYS_move_pages","","",null,null],[17,"SYS_utimensat","","",null,null],[17,"SYS_epoll_pwait","","",null,null],[17,"SYS_signalfd","","",null,null],[17,"SYS_timerfd_create","","",null,null],[17,"SYS_eventfd","","",null,null],[17,"SYS_fallocate","","",null,null],[17,"SYS_timerfd_settime","","",null,null],[17,"SYS_timerfd_gettime","","",null,null],[17,"SYS_accept4","","",null,null],[17,"SYS_signalfd4","","",null,null],[17,"SYS_eventfd2","","",null,null],[17,"SYS_epoll_create1","","",null,null],[17,"SYS_dup3","","",null,null],[17,"SYS_pipe2","","",null,null],[17,"SYS_inotify_init1","","",null,null],[17,"SYS_preadv","","",null,null],[17,"SYS_pwritev","","",null,null],[17,"SYS_rt_tgsigqueueinfo","","",null,null],[17,"SYS_perf_event_open","","",null,null],[17,"SYS_recvmmsg","","",null,null],[17,"SYS_fanotify_init","","",null,null],[17,"SYS_fanotify_mark","","",null,null],[17,"SYS_prlimit64","","",null,null],[17,"SYS_name_to_handle_at","","",null,null],[17,"SYS_open_by_handle_at","","",null,null],[17,"SYS_clock_adjtime","","",null,null],[17,"SYS_syncfs","","",null,null],[17,"SYS_sendmmsg","","",null,null],[17,"SYS_setns","","",null,null],[17,"SYS_getcpu","","",null,null],[17,"SYS_process_vm_readv","","",null,null],[17,"SYS_process_vm_writev","","",null,null],[17,"SYS_kcmp","","",null,null],[17,"SYS_finit_module","","",null,null],[17,"SYS_sched_setattr","","",null,null],[17,"SYS_sched_getattr","","",null,null],[17,"SYS_renameat2","","",null,null],[17,"SYS_seccomp","","",null,null],[17,"SYS_getrandom","","",null,null],[17,"SYS_memfd_create","","",null,null],[17,"SYS_kexec_file_load","","",null,null],[17,"SYS_bpf","","",null,null],[17,"SYS_execveat","","",null,null],[17,"SYS_userfaultfd","","",null,null],[17,"SYS_membarrier","","",null,null],[17,"SYS_mlock2","","",null,null],[17,"SYS_copy_file_range","","",null,null],[17,"SYS_preadv2","","",null,null],[17,"SYS_pwritev2","","",null,null],[17,"SYS_pkey_mprotect","","",null,null],[17,"SYS_pkey_alloc","","",null,null],[17,"SYS_pkey_free","","",null,null],[6,"clock_t","libc::unix::notbsd::linux::other::b64","",null,null],[6,"time_t","","",null,null],[6,"ino_t","","",null,null],[6,"off_t","","",null,null],[6,"blkcnt_t","","",null,null],[6,"__fsword_t","","",null,null],[6,"shmatt_t","","",null,null],[6,"msgqnum_t","","",null,null],[6,"msglen_t","","",null,null],[6,"fsblkcnt_t","","",null,null],[6,"fsfilcnt_t","","",null,null],[6,"rlim_t","","",null,null],[17,"__SIZEOF_PTHREAD_RWLOCKATTR_T","","",null,null],[17,"O_LARGEFILE","","",null,null],[11,"clone","libc","",103,{"i":[{"n":"self"}],"o":{"n":"sigset_t"}}],[11,"clone","","",104,{"i":[{"n":"self"}],"o":{"n":"sysinfo"}}],[11,"clone","","",105,{"i":[{"n":"self"}],"o":{"n":"msqid_ds"}}],[6,"__priority_which_t","libc::unix::notbsd::linux::other","",null,null],[17,"__UT_LINESIZE","","",null,null],[17,"__UT_NAMESIZE","","",null,null],[17,"__UT_HOSTSIZE","","",null,null],[17,"EMPTY","","",null,null],[17,"RUN_LVL","","",null,null],[17,"BOOT_TIME","","",null,null],[17,"NEW_TIME","","",null,null],[17,"OLD_TIME","","",null,null],[17,"INIT_PROCESS","","",null,null],[17,"LOGIN_PROCESS","","",null,null],[17,"USER_PROCESS","","",null,null],[17,"DEAD_PROCESS","","",null,null],[17,"ACCOUNTING","","",null,null],[17,"RLIMIT_RSS","","",null,null],[17,"RLIMIT_AS","","",null,null],[17,"RLIMIT_MEMLOCK","","",null,null],[17,"RLIM_INFINITY","","",null,null],[17,"RLIMIT_RTTIME","","",null,null],[17,"RLIMIT_NLIMITS","","",null,null],[17,"SOCK_NONBLOCK","","",null,null],[17,"SOL_RXRPC","","",null,null],[17,"SOL_PPPOL2TP","","",null,null],[17,"SOL_BLUETOOTH","","",null,null],[17,"SOL_PNPIPE","","",null,null],[17,"SOL_RDS","","",null,null],[17,"SOL_IUCV","","",null,null],[17,"SOL_CAIF","","",null,null],[17,"SOL_ALG","","",null,null],[17,"SOL_NFC","","",null,null],[17,"MSG_TRYHARD","","",null,null],[17,"LC_PAPER","","",null,null],[17,"LC_NAME","","",null,null],[17,"LC_ADDRESS","","",null,null],[17,"LC_TELEPHONE","","",null,null],[17,"LC_MEASUREMENT","","",null,null],[17,"LC_IDENTIFICATION","","",null,null],[17,"LC_PAPER_MASK","","",null,null],[17,"LC_NAME_MASK","","",null,null],[17,"LC_ADDRESS_MASK","","",null,null],[17,"LC_TELEPHONE_MASK","","",null,null],[17,"LC_MEASUREMENT_MASK","","",null,null],[17,"LC_IDENTIFICATION_MASK","","",null,null],[17,"LC_ALL_MASK","","",null,null],[17,"MAP_ANON","","",null,null],[17,"MAP_ANONYMOUS","","",null,null],[17,"MAP_DENYWRITE","","",null,null],[17,"MAP_EXECUTABLE","","",null,null],[17,"MAP_POPULATE","","",null,null],[17,"MAP_NONBLOCK","","",null,null],[17,"MAP_STACK","","",null,null],[17,"ENOTSUP","","",null,null],[17,"EUCLEAN","","",null,null],[17,"ENOTNAM","","",null,null],[17,"ENAVAIL","","",null,null],[17,"EISNAM","","",null,null],[17,"EREMOTEIO","","",null,null],[17,"SOCK_STREAM","","",null,null],[17,"SOCK_DGRAM","","",null,null],[17,"SOCK_SEQPACKET","","",null,null],[17,"SOCK_DCCP","","",null,null],[17,"SOCK_PACKET","","",null,null],[17,"TCP_COOKIE_TRANSACTIONS","","",null,null],[17,"TCP_THIN_LINEAR_TIMEOUTS","","",null,null],[17,"TCP_THIN_DUPACK","","",null,null],[17,"TCP_USER_TIMEOUT","","",null,null],[17,"TCP_REPAIR","","",null,null],[17,"TCP_REPAIR_QUEUE","","",null,null],[17,"TCP_QUEUE_SEQ","","",null,null],[17,"TCP_REPAIR_OPTIONS","","",null,null],[17,"TCP_FASTOPEN","","",null,null],[17,"TCP_TIMESTAMP","","",null,null],[17,"DCCP_SOCKOPT_PACKET_SIZE","","",null,null],[17,"DCCP_SOCKOPT_SERVICE","","",null,null],[17,"DCCP_SOCKOPT_CHANGE_L","","",null,null],[17,"DCCP_SOCKOPT_CHANGE_R","","",null,null],[17,"DCCP_SOCKOPT_GET_CUR_MPS","","",null,null],[17,"DCCP_SOCKOPT_SERVER_TIMEWAIT","","",null,null],[17,"DCCP_SOCKOPT_SEND_CSCOV","","",null,null],[17,"DCCP_SOCKOPT_RECV_CSCOV","","",null,null],[17,"DCCP_SOCKOPT_AVAILABLE_CCIDS","","",null,null],[17,"DCCP_SOCKOPT_CCID","","",null,null],[17,"DCCP_SOCKOPT_TX_CCID","","",null,null],[17,"DCCP_SOCKOPT_RX_CCID","","",null,null],[17,"DCCP_SOCKOPT_QPOLICY_ID","","",null,null],[17,"DCCP_SOCKOPT_QPOLICY_TXQLEN","","",null,null],[17,"DCCP_SOCKOPT_CCID_RX_INFO","","",null,null],[17,"DCCP_SOCKOPT_CCID_TX_INFO","","",null,null],[17,"DCCP_SERVICE_LIST_MAX_LEN","","maximum number of services provided on the same listening port",null,null],[17,"SIGTTIN","","",null,null],[17,"SIGTTOU","","",null,null],[17,"SIGXCPU","","",null,null],[17,"SIGXFSZ","","",null,null],[17,"SIGVTALRM","","",null,null],[17,"SIGPROF","","",null,null],[17,"SIGWINCH","","",null,null],[17,"SIGEV_THREAD_ID","","",null,null],[17,"BUFSIZ","","",null,null],[17,"TMP_MAX","","",null,null],[17,"FOPEN_MAX","","",null,null],[17,"POSIX_FADV_DONTNEED","","",null,null],[17,"POSIX_FADV_NOREUSE","","",null,null],[17,"POSIX_MADV_DONTNEED","","",null,null],[17,"_SC_EQUIV_CLASS_MAX","","",null,null],[17,"_SC_CHARCLASS_NAME_MAX","","",null,null],[17,"_SC_PII","","",null,null],[17,"_SC_PII_XTI","","",null,null],[17,"_SC_PII_SOCKET","","",null,null],[17,"_SC_PII_INTERNET","","",null,null],[17,"_SC_PII_OSI","","",null,null],[17,"_SC_POLL","","",null,null],[17,"_SC_SELECT","","",null,null],[17,"_SC_PII_INTERNET_STREAM","","",null,null],[17,"_SC_PII_INTERNET_DGRAM","","",null,null],[17,"_SC_PII_OSI_COTS","","",null,null],[17,"_SC_PII_OSI_CLTS","","",null,null],[17,"_SC_PII_OSI_M","","",null,null],[17,"_SC_T_IOV_MAX","","",null,null],[17,"_SC_2_C_VERSION","","",null,null],[17,"_SC_CHAR_BIT","","",null,null],[17,"_SC_CHAR_MAX","","",null,null],[17,"_SC_CHAR_MIN","","",null,null],[17,"_SC_INT_MAX","","",null,null],[17,"_SC_INT_MIN","","",null,null],[17,"_SC_LONG_BIT","","",null,null],[17,"_SC_WORD_BIT","","",null,null],[17,"_SC_MB_LEN_MAX","","",null,null],[17,"_SC_SSIZE_MAX","","",null,null],[17,"_SC_SCHAR_MAX","","",null,null],[17,"_SC_SCHAR_MIN","","",null,null],[17,"_SC_SHRT_MAX","","",null,null],[17,"_SC_SHRT_MIN","","",null,null],[17,"_SC_UCHAR_MAX","","",null,null],[17,"_SC_UINT_MAX","","",null,null],[17,"_SC_ULONG_MAX","","",null,null],[17,"_SC_USHRT_MAX","","",null,null],[17,"_SC_NL_ARGMAX","","",null,null],[17,"_SC_NL_LANGMAX","","",null,null],[17,"_SC_NL_MSGMAX","","",null,null],[17,"_SC_NL_NMAX","","",null,null],[17,"_SC_NL_SETMAX","","",null,null],[17,"_SC_NL_TEXTMAX","","",null,null],[17,"_SC_BASE","","",null,null],[17,"_SC_C_LANG_SUPPORT","","",null,null],[17,"_SC_C_LANG_SUPPORT_R","","",null,null],[17,"_SC_DEVICE_IO","","",null,null],[17,"_SC_DEVICE_SPECIFIC","","",null,null],[17,"_SC_DEVICE_SPECIFIC_R","","",null,null],[17,"_SC_FD_MGMT","","",null,null],[17,"_SC_FIFO","","",null,null],[17,"_SC_PIPE","","",null,null],[17,"_SC_FILE_ATTRIBUTES","","",null,null],[17,"_SC_FILE_LOCKING","","",null,null],[17,"_SC_FILE_SYSTEM","","",null,null],[17,"_SC_MULTI_PROCESS","","",null,null],[17,"_SC_SINGLE_PROCESS","","",null,null],[17,"_SC_NETWORKING","","",null,null],[17,"_SC_REGEX_VERSION","","",null,null],[17,"_SC_SIGNALS","","",null,null],[17,"_SC_SYSTEM_DATABASE","","",null,null],[17,"_SC_SYSTEM_DATABASE_R","","",null,null],[17,"_SC_USER_GROUPS","","",null,null],[17,"_SC_USER_GROUPS_R","","",null,null],[17,"_SC_LEVEL1_ICACHE_SIZE","","",null,null],[17,"_SC_LEVEL1_ICACHE_ASSOC","","",null,null],[17,"_SC_LEVEL1_ICACHE_LINESIZE","","",null,null],[17,"_SC_LEVEL1_DCACHE_SIZE","","",null,null],[17,"_SC_LEVEL1_DCACHE_ASSOC","","",null,null],[17,"_SC_LEVEL1_DCACHE_LINESIZE","","",null,null],[17,"_SC_LEVEL2_CACHE_SIZE","","",null,null],[17,"_SC_LEVEL2_CACHE_ASSOC","","",null,null],[17,"_SC_LEVEL2_CACHE_LINESIZE","","",null,null],[17,"_SC_LEVEL3_CACHE_SIZE","","",null,null],[17,"_SC_LEVEL3_CACHE_ASSOC","","",null,null],[17,"_SC_LEVEL3_CACHE_LINESIZE","","",null,null],[17,"_SC_LEVEL4_CACHE_SIZE","","",null,null],[17,"_SC_LEVEL4_CACHE_ASSOC","","",null,null],[17,"_SC_LEVEL4_CACHE_LINESIZE","","",null,null],[17,"O_ACCMODE","","",null,null],[17,"ST_RELATIME","","",null,null],[17,"NI_MAXHOST","","",null,null],[17,"ADFS_SUPER_MAGIC","","",null,null],[17,"AFFS_SUPER_MAGIC","","",null,null],[17,"CODA_SUPER_MAGIC","","",null,null],[17,"CRAMFS_MAGIC","","",null,null],[17,"EFS_SUPER_MAGIC","","",null,null],[17,"EXT2_SUPER_MAGIC","","",null,null],[17,"EXT3_SUPER_MAGIC","","",null,null],[17,"EXT4_SUPER_MAGIC","","",null,null],[17,"HPFS_SUPER_MAGIC","","",null,null],[17,"HUGETLBFS_MAGIC","","",null,null],[17,"ISOFS_SUPER_MAGIC","","",null,null],[17,"JFFS2_SUPER_MAGIC","","",null,null],[17,"MINIX_SUPER_MAGIC","","",null,null],[17,"MINIX_SUPER_MAGIC2","","",null,null],[17,"MINIX2_SUPER_MAGIC","","",null,null],[17,"MINIX2_SUPER_MAGIC2","","",null,null],[17,"MSDOS_SUPER_MAGIC","","",null,null],[17,"NCP_SUPER_MAGIC","","",null,null],[17,"NFS_SUPER_MAGIC","","",null,null],[17,"OPENPROM_SUPER_MAGIC","","",null,null],[17,"PROC_SUPER_MAGIC","","",null,null],[17,"QNX4_SUPER_MAGIC","","",null,null],[17,"REISERFS_SUPER_MAGIC","","",null,null],[17,"SMB_SUPER_MAGIC","","",null,null],[17,"TMPFS_MAGIC","","",null,null],[17,"USBDEVICE_SUPER_MAGIC","","",null,null],[17,"VEOF","","",null,null],[17,"CPU_SETSIZE","","",null,null],[17,"PTRACE_TRACEME","","",null,null],[17,"PTRACE_PEEKTEXT","","",null,null],[17,"PTRACE_PEEKDATA","","",null,null],[17,"PTRACE_PEEKUSER","","",null,null],[17,"PTRACE_POKETEXT","","",null,null],[17,"PTRACE_POKEDATA","","",null,null],[17,"PTRACE_POKEUSER","","",null,null],[17,"PTRACE_CONT","","",null,null],[17,"PTRACE_KILL","","",null,null],[17,"PTRACE_SINGLESTEP","","",null,null],[17,"PTRACE_ATTACH","","",null,null],[17,"PTRACE_SYSCALL","","",null,null],[17,"PTRACE_SETOPTIONS","","",null,null],[17,"PTRACE_GETEVENTMSG","","",null,null],[17,"PTRACE_GETSIGINFO","","",null,null],[17,"PTRACE_SETSIGINFO","","",null,null],[17,"PTRACE_GETREGSET","","",null,null],[17,"PTRACE_SETREGSET","","",null,null],[17,"PTRACE_SEIZE","","",null,null],[17,"PTRACE_INTERRUPT","","",null,null],[17,"PTRACE_LISTEN","","",null,null],[17,"PTRACE_PEEKSIGINFO","","",null,null],[17,"EPOLLWAKEUP","","",null,null],[17,"MAP_HUGETLB","","",null,null],[17,"SEEK_DATA","","",null,null],[17,"SEEK_HOLE","","",null,null],[17,"TCSANOW","","",null,null],[17,"TCSADRAIN","","",null,null],[17,"TCSAFLUSH","","",null,null],[17,"TIOCLINUX","","",null,null],[17,"TIOCGSERIAL","","",null,null],[17,"RTLD_DEEPBIND","","",null,null],[17,"RTLD_GLOBAL","","",null,null],[17,"RTLD_NOLOAD","","",null,null],[17,"LINUX_REBOOT_MAGIC1","","",null,null],[17,"LINUX_REBOOT_MAGIC2","","",null,null],[17,"LINUX_REBOOT_MAGIC2A","","",null,null],[17,"LINUX_REBOOT_MAGIC2B","","",null,null],[17,"LINUX_REBOOT_MAGIC2C","","",null,null],[17,"LINUX_REBOOT_CMD_RESTART","","",null,null],[17,"LINUX_REBOOT_CMD_HALT","","",null,null],[17,"LINUX_REBOOT_CMD_CAD_ON","","",null,null],[17,"LINUX_REBOOT_CMD_CAD_OFF","","",null,null],[17,"LINUX_REBOOT_CMD_POWER_OFF","","",null,null],[17,"LINUX_REBOOT_CMD_RESTART2","","",null,null],[17,"LINUX_REBOOT_CMD_SW_SUSPEND","","",null,null],[17,"LINUX_REBOOT_CMD_KEXEC","","",null,null],[17,"NETLINK_ROUTE","","",null,null],[17,"NETLINK_UNUSED","","",null,null],[17,"NETLINK_USERSOCK","","",null,null],[17,"NETLINK_FIREWALL","","",null,null],[17,"NETLINK_SOCK_DIAG","","",null,null],[17,"NETLINK_NFLOG","","",null,null],[17,"NETLINK_XFRM","","",null,null],[17,"NETLINK_SELINUX","","",null,null],[17,"NETLINK_ISCSI","","",null,null],[17,"NETLINK_AUDIT","","",null,null],[17,"NETLINK_FIB_LOOKUP","","",null,null],[17,"NETLINK_CONNECTOR","","",null,null],[17,"NETLINK_NETFILTER","","",null,null],[17,"NETLINK_IP6_FW","","",null,null],[17,"NETLINK_DNRTMSG","","",null,null],[17,"NETLINK_KOBJECT_UEVENT","","",null,null],[17,"NETLINK_GENERIC","","",null,null],[17,"NETLINK_SCSITRANSPORT","","",null,null],[17,"NETLINK_ECRYPTFS","","",null,null],[17,"NETLINK_RDMA","","",null,null],[17,"NETLINK_CRYPTO","","",null,null],[17,"NETLINK_INET_DIAG","","",null,null],[17,"MAX_LINKS","","",null,null],[17,"NLM_F_REQUEST","","",null,null],[17,"NLM_F_MULTI","","",null,null],[17,"NLM_F_ACK","","",null,null],[17,"NLM_F_ECHO","","",null,null],[17,"NLM_F_DUMP_INTR","","",null,null],[17,"NLM_F_DUMP_FILTERED","","",null,null],[17,"NLM_F_ROOT","","",null,null],[17,"NLM_F_MATCH","","",null,null],[17,"NLM_F_ATOMIC","","",null,null],[17,"NLM_F_DUMP","","",null,null],[17,"NLM_F_REPLACE","","",null,null],[17,"NLM_F_EXCL","","",null,null],[17,"NLM_F_CREATE","","",null,null],[17,"NLM_F_APPEND","","",null,null],[17,"NETLINK_ADD_MEMBERSHIP","","",null,null],[17,"NETLINK_DROP_MEMBERSHIP","","",null,null],[17,"NETLINK_PKTINFO","","",null,null],[17,"NETLINK_BROADCAST_ERROR","","",null,null],[17,"NETLINK_NO_ENOBUFS","","",null,null],[17,"NETLINK_RX_RING","","",null,null],[17,"NETLINK_TX_RING","","",null,null],[17,"NETLINK_LISTEN_ALL_NSID","","",null,null],[17,"NETLINK_LIST_MEMBERSHIPS","","",null,null],[17,"NETLINK_CAP_ACK","","",null,null],[17,"NLA_F_NESTED","","",null,null],[17,"NLA_F_NET_BYTEORDER","","",null,null],[17,"NLA_TYPE_MASK","","",null,null],[17,"NLA_ALIGNTO","","",null,null],[17,"GENL_UNS_ADMIN_PERM","","",null,null],[17,"GENL_ID_VFS_DQUOT","","",null,null],[17,"GENL_ID_PMCRAID","","",null,null],[17,"TIOCM_LE","","",null,null],[17,"TIOCM_DTR","","",null,null],[17,"TIOCM_RTS","","",null,null],[17,"TIOCM_ST","","",null,null],[17,"TIOCM_SR","","",null,null],[17,"TIOCM_CTS","","",null,null],[17,"TIOCM_CAR","","",null,null],[17,"TIOCM_RNG","","",null,null],[17,"TIOCM_DSR","","",null,null],[17,"TIOCM_CD","","",null,null],[17,"TIOCM_RI","","",null,null],[17,"NF_NETDEV_INGRESS","","",null,null],[17,"NF_NETDEV_NUMHOOKS","","",null,null],[17,"NFPROTO_INET","","",null,null],[17,"NFPROTO_NETDEV","","",null,null],[17,"NFT_TABLE_MAXNAMELEN","","",null,null],[17,"NFT_CHAIN_MAXNAMELEN","","",null,null],[17,"NFT_SET_MAXNAMELEN","","",null,null],[17,"NFT_OBJ_MAXNAMELEN","","",null,null],[17,"NFT_USERDATA_MAXLEN","","",null,null],[17,"NFT_REG_VERDICT","","",null,null],[17,"NFT_REG_1","","",null,null],[17,"NFT_REG_2","","",null,null],[17,"NFT_REG_3","","",null,null],[17,"NFT_REG_4","","",null,null],[17,"__NFT_REG_MAX","","",null,null],[17,"NFT_REG32_00","","",null,null],[17,"NFT_REG32_01","","",null,null],[17,"NFT_REG32_02","","",null,null],[17,"NFT_REG32_03","","",null,null],[17,"NFT_REG32_04","","",null,null],[17,"NFT_REG32_05","","",null,null],[17,"NFT_REG32_06","","",null,null],[17,"NFT_REG32_07","","",null,null],[17,"NFT_REG32_08","","",null,null],[17,"NFT_REG32_09","","",null,null],[17,"NFT_REG32_10","","",null,null],[17,"NFT_REG32_11","","",null,null],[17,"NFT_REG32_12","","",null,null],[17,"NFT_REG32_13","","",null,null],[17,"NFT_REG32_14","","",null,null],[17,"NFT_REG32_15","","",null,null],[17,"NFT_REG_SIZE","","",null,null],[17,"NFT_REG32_SIZE","","",null,null],[17,"NFT_CONTINUE","","",null,null],[17,"NFT_BREAK","","",null,null],[17,"NFT_JUMP","","",null,null],[17,"NFT_GOTO","","",null,null],[17,"NFT_RETURN","","",null,null],[17,"NFT_MSG_NEWTABLE","","",null,null],[17,"NFT_MSG_GETTABLE","","",null,null],[17,"NFT_MSG_DELTABLE","","",null,null],[17,"NFT_MSG_NEWCHAIN","","",null,null],[17,"NFT_MSG_GETCHAIN","","",null,null],[17,"NFT_MSG_DELCHAIN","","",null,null],[17,"NFT_MSG_NEWRULE","","",null,null],[17,"NFT_MSG_GETRULE","","",null,null],[17,"NFT_MSG_DELRULE","","",null,null],[17,"NFT_MSG_NEWSET","","",null,null],[17,"NFT_MSG_GETSET","","",null,null],[17,"NFT_MSG_DELSET","","",null,null],[17,"NFT_MSG_NEWSETELEM","","",null,null],[17,"NFT_MSG_GETSETELEM","","",null,null],[17,"NFT_MSG_DELSETELEM","","",null,null],[17,"NFT_MSG_NEWGEN","","",null,null],[17,"NFT_MSG_GETGEN","","",null,null],[17,"NFT_MSG_TRACE","","",null,null],[17,"NFT_MSG_NEWOBJ","","",null,null],[17,"NFT_MSG_GETOBJ","","",null,null],[17,"NFT_MSG_DELOBJ","","",null,null],[17,"NFT_MSG_GETOBJ_RESET","","",null,null],[17,"NFT_MSG_MAX","","",null,null],[17,"NFT_SET_ANONYMOUS","","",null,null],[17,"NFT_SET_CONSTANT","","",null,null],[17,"NFT_SET_INTERVAL","","",null,null],[17,"NFT_SET_MAP","","",null,null],[17,"NFT_SET_TIMEOUT","","",null,null],[17,"NFT_SET_EVAL","","",null,null],[17,"NFT_SET_POL_PERFORMANCE","","",null,null],[17,"NFT_SET_POL_MEMORY","","",null,null],[17,"NFT_SET_ELEM_INTERVAL_END","","",null,null],[17,"NFT_DATA_VALUE","","",null,null],[17,"NFT_DATA_VERDICT","","",null,null],[17,"NFT_DATA_RESERVED_MASK","","",null,null],[17,"NFT_DATA_VALUE_MAXLEN","","",null,null],[17,"NFT_BYTEORDER_NTOH","","",null,null],[17,"NFT_BYTEORDER_HTON","","",null,null],[17,"NFT_CMP_EQ","","",null,null],[17,"NFT_CMP_NEQ","","",null,null],[17,"NFT_CMP_LT","","",null,null],[17,"NFT_CMP_LTE","","",null,null],[17,"NFT_CMP_GT","","",null,null],[17,"NFT_CMP_GTE","","",null,null],[17,"NFT_RANGE_EQ","","",null,null],[17,"NFT_RANGE_NEQ","","",null,null],[17,"NFT_LOOKUP_F_INV","","",null,null],[17,"NFT_DYNSET_OP_ADD","","",null,null],[17,"NFT_DYNSET_OP_UPDATE","","",null,null],[17,"NFT_DYNSET_F_INV","","",null,null],[17,"NFT_PAYLOAD_LL_HEADER","","",null,null],[17,"NFT_PAYLOAD_NETWORK_HEADER","","",null,null],[17,"NFT_PAYLOAD_TRANSPORT_HEADER","","",null,null],[17,"NFT_PAYLOAD_CSUM_NONE","","",null,null],[17,"NFT_PAYLOAD_CSUM_INET","","",null,null],[17,"NFT_META_LEN","","",null,null],[17,"NFT_META_PROTOCOL","","",null,null],[17,"NFT_META_PRIORITY","","",null,null],[17,"NFT_META_MARK","","",null,null],[17,"NFT_META_IIF","","",null,null],[17,"NFT_META_OIF","","",null,null],[17,"NFT_META_IIFNAME","","",null,null],[17,"NFT_META_OIFNAME","","",null,null],[17,"NFT_META_IIFTYPE","","",null,null],[17,"NFT_META_OIFTYPE","","",null,null],[17,"NFT_META_SKUID","","",null,null],[17,"NFT_META_SKGID","","",null,null],[17,"NFT_META_NFTRACE","","",null,null],[17,"NFT_META_RTCLASSID","","",null,null],[17,"NFT_META_SECMARK","","",null,null],[17,"NFT_META_NFPROTO","","",null,null],[17,"NFT_META_L4PROTO","","",null,null],[17,"NFT_META_BRI_IIFNAME","","",null,null],[17,"NFT_META_BRI_OIFNAME","","",null,null],[17,"NFT_META_PKTTYPE","","",null,null],[17,"NFT_META_CPU","","",null,null],[17,"NFT_META_IIFGROUP","","",null,null],[17,"NFT_META_OIFGROUP","","",null,null],[17,"NFT_META_CGROUP","","",null,null],[17,"NFT_META_PRANDOM","","",null,null],[17,"NFT_CT_STATE","","",null,null],[17,"NFT_CT_DIRECTION","","",null,null],[17,"NFT_CT_STATUS","","",null,null],[17,"NFT_CT_MARK","","",null,null],[17,"NFT_CT_SECMARK","","",null,null],[17,"NFT_CT_EXPIRATION","","",null,null],[17,"NFT_CT_HELPER","","",null,null],[17,"NFT_CT_L3PROTOCOL","","",null,null],[17,"NFT_CT_SRC","","",null,null],[17,"NFT_CT_DST","","",null,null],[17,"NFT_CT_PROTOCOL","","",null,null],[17,"NFT_CT_PROTO_SRC","","",null,null],[17,"NFT_CT_PROTO_DST","","",null,null],[17,"NFT_CT_LABELS","","",null,null],[17,"NFT_CT_PKTS","","",null,null],[17,"NFT_CT_BYTES","","",null,null],[17,"NFT_LIMIT_PKTS","","",null,null],[17,"NFT_LIMIT_PKT_BYTES","","",null,null],[17,"NFT_LIMIT_F_INV","","",null,null],[17,"NFT_QUEUE_FLAG_BYPASS","","",null,null],[17,"NFT_QUEUE_FLAG_CPU_FANOUT","","",null,null],[17,"NFT_QUEUE_FLAG_MASK","","",null,null],[17,"NFT_QUOTA_F_INV","","",null,null],[17,"NFT_REJECT_ICMP_UNREACH","","",null,null],[17,"NFT_REJECT_TCP_RST","","",null,null],[17,"NFT_REJECT_ICMPX_UNREACH","","",null,null],[17,"NFT_REJECT_ICMPX_NO_ROUTE","","",null,null],[17,"NFT_REJECT_ICMPX_PORT_UNREACH","","",null,null],[17,"NFT_REJECT_ICMPX_HOST_UNREACH","","",null,null],[17,"NFT_REJECT_ICMPX_ADMIN_PROHIBITED","","",null,null],[17,"NFT_NAT_SNAT","","",null,null],[17,"NFT_NAT_DNAT","","",null,null],[17,"NFT_TRACETYPE_UNSPEC","","",null,null],[17,"NFT_TRACETYPE_POLICY","","",null,null],[17,"NFT_TRACETYPE_RETURN","","",null,null],[17,"NFT_TRACETYPE_RULE","","",null,null],[17,"NFT_NG_INCREMENTAL","","",null,null],[17,"NFT_NG_RANDOM","","",null,null],[17,"AF_MAX","","",null,null],[17,"PF_MAX","","",null,null],[17,"PTHREAD_STACK_MIN","","",null,null],[11,"clone","libc","",82,{"i":[{"n":"self"}],"o":{"n":"aiocb"}}],[11,"clone","","",83,{"i":[{"n":"self"}],"o":{"n":"__exit_status"}}],[11,"clone","","",84,{"i":[{"n":"self"}],"o":{"n":"__timeval"}}],[11,"clone","","",85,{"i":[{"n":"self"}],"o":{"n":"utmpx"}}],[11,"clone","","",86,{"i":[{"n":"self"}],"o":{"n":"sigaction"}}],[11,"clone","","",87,{"i":[{"n":"self"}],"o":{"n":"stack_t"}}],[11,"clone","","",88,{"i":[{"n":"self"}],"o":{"n":"siginfo_t"}}],[11,"clone","","",89,{"i":[{"n":"self"}],"o":{"n":"glob64_t"}}],[11,"clone","","",90,{"i":[{"n":"self"}],"o":{"n":"statfs"}}],[11,"clone","","",91,{"i":[{"n":"self"}],"o":{"n":"msghdr"}}],[11,"clone","","",92,{"i":[{"n":"self"}],"o":{"n":"cmsghdr"}}],[11,"clone","","",93,{"i":[{"n":"self"}],"o":{"n":"termios"}}],[11,"clone","","",94,{"i":[{"n":"self"}],"o":{"n":"flock"}}],[11,"clone","","",95,{"i":[{"n":"self"}],"o":{"n":"sem_t"}}],[11,"clone","","",96,{"i":[{"n":"self"}],"o":{"n":"mallinfo"}}],[11,"clone","","",97,{"i":[{"n":"self"}],"o":{"n":"nlmsghdr"}}],[11,"clone","","",98,{"i":[{"n":"self"}],"o":{"n":"nlmsgerr"}}],[11,"clone","","",99,{"i":[{"n":"self"}],"o":{"n":"nl_pktinfo"}}],[11,"clone","","",100,{"i":[{"n":"self"}],"o":{"n":"nl_mmap_req"}}],[11,"clone","","",101,{"i":[{"n":"self"}],"o":{"n":"nl_mmap_hdr"}}],[11,"clone","","",102,{"i":[{"n":"self"}],"o":{"n":"nlattr"}}],[6,"useconds_t","libc::unix::notbsd::linux","",null,null],[6,"dev_t","","",null,null],[6,"socklen_t","","",null,null],[6,"pthread_t","","",null,null],[6,"mode_t","","",null,null],[6,"ino64_t","","",null,null],[6,"off64_t","","",null,null],[6,"blkcnt64_t","","",null,null],[6,"rlim64_t","","",null,null],[6,"mqd_t","","",null,null],[6,"nfds_t","","",null,null],[6,"nl_item","","",null,null],[6,"idtype_t","","",null,null],[6,"loff_t","","",null,null],[6,"__u8","","",null,null],[6,"__u16","","",null,null],[6,"__s16","","",null,null],[6,"__u32","","",null,null],[6,"__s32","","",null,null],[6,"Elf32_Half","","",null,null],[6,"Elf32_Word","","",null,null],[6,"Elf32_Off","","",null,null],[6,"Elf32_Addr","","",null,null],[6,"Elf64_Half","","",null,null],[6,"Elf64_Word","","",null,null],[6,"Elf64_Off","","",null,null],[6,"Elf64_Addr","","",null,null],[6,"Elf64_Xword","","",null,null],[17,"ABDAY_1","","",null,null],[17,"ABDAY_2","","",null,null],[17,"ABDAY_3","","",null,null],[17,"ABDAY_4","","",null,null],[17,"ABDAY_5","","",null,null],[17,"ABDAY_6","","",null,null],[17,"ABDAY_7","","",null,null],[17,"DAY_1","","",null,null],[17,"DAY_2","","",null,null],[17,"DAY_3","","",null,null],[17,"DAY_4","","",null,null],[17,"DAY_5","","",null,null],[17,"DAY_6","","",null,null],[17,"DAY_7","","",null,null],[17,"ABMON_1","","",null,null],[17,"ABMON_2","","",null,null],[17,"ABMON_3","","",null,null],[17,"ABMON_4","","",null,null],[17,"ABMON_5","","",null,null],[17,"ABMON_6","","",null,null],[17,"ABMON_7","","",null,null],[17,"ABMON_8","","",null,null],[17,"ABMON_9","","",null,null],[17,"ABMON_10","","",null,null],[17,"ABMON_11","","",null,null],[17,"ABMON_12","","",null,null],[17,"MON_1","","",null,null],[17,"MON_2","","",null,null],[17,"MON_3","","",null,null],[17,"MON_4","","",null,null],[17,"MON_5","","",null,null],[17,"MON_6","","",null,null],[17,"MON_7","","",null,null],[17,"MON_8","","",null,null],[17,"MON_9","","",null,null],[17,"MON_10","","",null,null],[17,"MON_11","","",null,null],[17,"MON_12","","",null,null],[17,"AM_STR","","",null,null],[17,"PM_STR","","",null,null],[17,"D_T_FMT","","",null,null],[17,"D_FMT","","",null,null],[17,"T_FMT","","",null,null],[17,"T_FMT_AMPM","","",null,null],[17,"ERA","","",null,null],[17,"ERA_D_FMT","","",null,null],[17,"ALT_DIGITS","","",null,null],[17,"ERA_D_T_FMT","","",null,null],[17,"ERA_T_FMT","","",null,null],[17,"CODESET","","",null,null],[17,"CRNCYSTR","","",null,null],[17,"RUSAGE_THREAD","","",null,null],[17,"RUSAGE_CHILDREN","","",null,null],[17,"RADIXCHAR","","",null,null],[17,"THOUSEP","","",null,null],[17,"YESEXPR","","",null,null],[17,"NOEXPR","","",null,null],[17,"YESSTR","","",null,null],[17,"NOSTR","","",null,null],[17,"FILENAME_MAX","","",null,null],[17,"L_tmpnam","","",null,null],[17,"_PC_LINK_MAX","","",null,null],[17,"_PC_MAX_CANON","","",null,null],[17,"_PC_MAX_INPUT","","",null,null],[17,"_PC_NAME_MAX","","",null,null],[17,"_PC_PATH_MAX","","",null,null],[17,"_PC_PIPE_BUF","","",null,null],[17,"_PC_CHOWN_RESTRICTED","","",null,null],[17,"_PC_NO_TRUNC","","",null,null],[17,"_PC_VDISABLE","","",null,null],[17,"_PC_SYNC_IO","","",null,null],[17,"_PC_ASYNC_IO","","",null,null],[17,"_PC_PRIO_IO","","",null,null],[17,"_PC_SOCK_MAXBUF","","",null,null],[17,"_PC_FILESIZEBITS","","",null,null],[17,"_PC_REC_INCR_XFER_SIZE","","",null,null],[17,"_PC_REC_MAX_XFER_SIZE","","",null,null],[17,"_PC_REC_MIN_XFER_SIZE","","",null,null],[17,"_PC_REC_XFER_ALIGN","","",null,null],[17,"_PC_ALLOC_SIZE_MIN","","",null,null],[17,"_PC_SYMLINK_MAX","","",null,null],[17,"_PC_2_SYMLINKS","","",null,null],[17,"_SC_ARG_MAX","","",null,null],[17,"_SC_CHILD_MAX","","",null,null],[17,"_SC_CLK_TCK","","",null,null],[17,"_SC_NGROUPS_MAX","","",null,null],[17,"_SC_OPEN_MAX","","",null,null],[17,"_SC_STREAM_MAX","","",null,null],[17,"_SC_TZNAME_MAX","","",null,null],[17,"_SC_JOB_CONTROL","","",null,null],[17,"_SC_SAVED_IDS","","",null,null],[17,"_SC_REALTIME_SIGNALS","","",null,null],[17,"_SC_PRIORITY_SCHEDULING","","",null,null],[17,"_SC_TIMERS","","",null,null],[17,"_SC_ASYNCHRONOUS_IO","","",null,null],[17,"_SC_PRIORITIZED_IO","","",null,null],[17,"_SC_SYNCHRONIZED_IO","","",null,null],[17,"_SC_FSYNC","","",null,null],[17,"_SC_MAPPED_FILES","","",null,null],[17,"_SC_MEMLOCK","","",null,null],[17,"_SC_MEMLOCK_RANGE","","",null,null],[17,"_SC_MEMORY_PROTECTION","","",null,null],[17,"_SC_MESSAGE_PASSING","","",null,null],[17,"_SC_SEMAPHORES","","",null,null],[17,"_SC_SHARED_MEMORY_OBJECTS","","",null,null],[17,"_SC_AIO_LISTIO_MAX","","",null,null],[17,"_SC_AIO_MAX","","",null,null],[17,"_SC_AIO_PRIO_DELTA_MAX","","",null,null],[17,"_SC_DELAYTIMER_MAX","","",null,null],[17,"_SC_MQ_OPEN_MAX","","",null,null],[17,"_SC_MQ_PRIO_MAX","","",null,null],[17,"_SC_VERSION","","",null,null],[17,"_SC_PAGESIZE","","",null,null],[17,"_SC_PAGE_SIZE","","",null,null],[17,"_SC_RTSIG_MAX","","",null,null],[17,"_SC_SEM_NSEMS_MAX","","",null,null],[17,"_SC_SEM_VALUE_MAX","","",null,null],[17,"_SC_SIGQUEUE_MAX","","",null,null],[17,"_SC_TIMER_MAX","","",null,null],[17,"_SC_BC_BASE_MAX","","",null,null],[17,"_SC_BC_DIM_MAX","","",null,null],[17,"_SC_BC_SCALE_MAX","","",null,null],[17,"_SC_BC_STRING_MAX","","",null,null],[17,"_SC_COLL_WEIGHTS_MAX","","",null,null],[17,"_SC_EXPR_NEST_MAX","","",null,null],[17,"_SC_LINE_MAX","","",null,null],[17,"_SC_RE_DUP_MAX","","",null,null],[17,"_SC_2_VERSION","","",null,null],[17,"_SC_2_C_BIND","","",null,null],[17,"_SC_2_C_DEV","","",null,null],[17,"_SC_2_FORT_DEV","","",null,null],[17,"_SC_2_FORT_RUN","","",null,null],[17,"_SC_2_SW_DEV","","",null,null],[17,"_SC_2_LOCALEDEF","","",null,null],[17,"_SC_UIO_MAXIOV","","",null,null],[17,"_SC_IOV_MAX","","",null,null],[17,"_SC_THREADS","","",null,null],[17,"_SC_THREAD_SAFE_FUNCTIONS","","",null,null],[17,"_SC_GETGR_R_SIZE_MAX","","",null,null],[17,"_SC_GETPW_R_SIZE_MAX","","",null,null],[17,"_SC_LOGIN_NAME_MAX","","",null,null],[17,"_SC_TTY_NAME_MAX","","",null,null],[17,"_SC_THREAD_DESTRUCTOR_ITERATIONS","","",null,null],[17,"_SC_THREAD_KEYS_MAX","","",null,null],[17,"_SC_THREAD_STACK_MIN","","",null,null],[17,"_SC_THREAD_THREADS_MAX","","",null,null],[17,"_SC_THREAD_ATTR_STACKADDR","","",null,null],[17,"_SC_THREAD_ATTR_STACKSIZE","","",null,null],[17,"_SC_THREAD_PRIORITY_SCHEDULING","","",null,null],[17,"_SC_THREAD_PRIO_INHERIT","","",null,null],[17,"_SC_THREAD_PRIO_PROTECT","","",null,null],[17,"_SC_THREAD_PROCESS_SHARED","","",null,null],[17,"_SC_NPROCESSORS_CONF","","",null,null],[17,"_SC_NPROCESSORS_ONLN","","",null,null],[17,"_SC_PHYS_PAGES","","",null,null],[17,"_SC_AVPHYS_PAGES","","",null,null],[17,"_SC_ATEXIT_MAX","","",null,null],[17,"_SC_PASS_MAX","","",null,null],[17,"_SC_XOPEN_VERSION","","",null,null],[17,"_SC_XOPEN_XCU_VERSION","","",null,null],[17,"_SC_XOPEN_UNIX","","",null,null],[17,"_SC_XOPEN_CRYPT","","",null,null],[17,"_SC_XOPEN_ENH_I18N","","",null,null],[17,"_SC_XOPEN_SHM","","",null,null],[17,"_SC_2_CHAR_TERM","","",null,null],[17,"_SC_2_UPE","","",null,null],[17,"_SC_XOPEN_XPG2","","",null,null],[17,"_SC_XOPEN_XPG3","","",null,null],[17,"_SC_XOPEN_XPG4","","",null,null],[17,"_SC_NZERO","","",null,null],[17,"_SC_XBS5_ILP32_OFF32","","",null,null],[17,"_SC_XBS5_ILP32_OFFBIG","","",null,null],[17,"_SC_XBS5_LP64_OFF64","","",null,null],[17,"_SC_XBS5_LPBIG_OFFBIG","","",null,null],[17,"_SC_XOPEN_LEGACY","","",null,null],[17,"_SC_XOPEN_REALTIME","","",null,null],[17,"_SC_XOPEN_REALTIME_THREADS","","",null,null],[17,"_SC_ADVISORY_INFO","","",null,null],[17,"_SC_BARRIERS","","",null,null],[17,"_SC_CLOCK_SELECTION","","",null,null],[17,"_SC_CPUTIME","","",null,null],[17,"_SC_THREAD_CPUTIME","","",null,null],[17,"_SC_MONOTONIC_CLOCK","","",null,null],[17,"_SC_READER_WRITER_LOCKS","","",null,null],[17,"_SC_SPIN_LOCKS","","",null,null],[17,"_SC_REGEXP","","",null,null],[17,"_SC_SHELL","","",null,null],[17,"_SC_SPAWN","","",null,null],[17,"_SC_SPORADIC_SERVER","","",null,null],[17,"_SC_THREAD_SPORADIC_SERVER","","",null,null],[17,"_SC_TIMEOUTS","","",null,null],[17,"_SC_TYPED_MEMORY_OBJECTS","","",null,null],[17,"_SC_2_PBS","","",null,null],[17,"_SC_2_PBS_ACCOUNTING","","",null,null],[17,"_SC_2_PBS_LOCATE","","",null,null],[17,"_SC_2_PBS_MESSAGE","","",null,null],[17,"_SC_2_PBS_TRACK","","",null,null],[17,"_SC_SYMLOOP_MAX","","",null,null],[17,"_SC_STREAMS","","",null,null],[17,"_SC_2_PBS_CHECKPOINT","","",null,null],[17,"_SC_V6_ILP32_OFF32","","",null,null],[17,"_SC_V6_ILP32_OFFBIG","","",null,null],[17,"_SC_V6_LP64_OFF64","","",null,null],[17,"_SC_V6_LPBIG_OFFBIG","","",null,null],[17,"_SC_HOST_NAME_MAX","","",null,null],[17,"_SC_TRACE","","",null,null],[17,"_SC_TRACE_EVENT_FILTER","","",null,null],[17,"_SC_TRACE_INHERIT","","",null,null],[17,"_SC_TRACE_LOG","","",null,null],[17,"_SC_IPV6","","",null,null],[17,"_SC_RAW_SOCKETS","","",null,null],[17,"_SC_V7_ILP32_OFF32","","",null,null],[17,"_SC_V7_ILP32_OFFBIG","","",null,null],[17,"_SC_V7_LP64_OFF64","","",null,null],[17,"_SC_V7_LPBIG_OFFBIG","","",null,null],[17,"_SC_SS_REPL_MAX","","",null,null],[17,"_SC_TRACE_EVENT_NAME_MAX","","",null,null],[17,"_SC_TRACE_NAME_MAX","","",null,null],[17,"_SC_TRACE_SYS_MAX","","",null,null],[17,"_SC_TRACE_USER_EVENT_MAX","","",null,null],[17,"_SC_XOPEN_STREAMS","","",null,null],[17,"_SC_THREAD_ROBUST_PRIO_INHERIT","","",null,null],[17,"_SC_THREAD_ROBUST_PRIO_PROTECT","","",null,null],[17,"RLIM_SAVED_MAX","","",null,null],[17,"RLIM_SAVED_CUR","","",null,null],[17,"GLOB_ERR","","",null,null],[17,"GLOB_MARK","","",null,null],[17,"GLOB_NOSORT","","",null,null],[17,"GLOB_DOOFFS","","",null,null],[17,"GLOB_NOCHECK","","",null,null],[17,"GLOB_APPEND","","",null,null],[17,"GLOB_NOESCAPE","","",null,null],[17,"GLOB_NOSPACE","","",null,null],[17,"GLOB_ABORTED","","",null,null],[17,"GLOB_NOMATCH","","",null,null],[17,"POSIX_MADV_NORMAL","","",null,null],[17,"POSIX_MADV_RANDOM","","",null,null],[17,"POSIX_MADV_SEQUENTIAL","","",null,null],[17,"POSIX_MADV_WILLNEED","","",null,null],[17,"S_IEXEC","","",null,null],[17,"S_IWRITE","","",null,null],[17,"S_IREAD","","",null,null],[17,"F_LOCK","","",null,null],[17,"F_TEST","","",null,null],[17,"F_TLOCK","","",null,null],[17,"F_ULOCK","","",null,null],[17,"IFF_LOWER_UP","","",null,null],[17,"IFF_DORMANT","","",null,null],[17,"IFF_ECHO","","",null,null],[17,"IFF_TUN","","",null,null],[17,"IFF_TAP","","",null,null],[17,"IFF_NO_PI","","",null,null],[17,"TUN_READQ_SIZE","","",null,null],[17,"TUN_TUN_DEV","","",null,null],[17,"TUN_TAP_DEV","","",null,null],[17,"TUN_TYPE_MASK","","",null,null],[17,"IFF_ONE_QUEUE","","",null,null],[17,"IFF_VNET_HDR","","",null,null],[17,"IFF_TUN_EXCL","","",null,null],[17,"IFF_MULTI_QUEUE","","",null,null],[17,"IFF_ATTACH_QUEUE","","",null,null],[17,"IFF_DETACH_QUEUE","","",null,null],[17,"IFF_PERSIST","","",null,null],[17,"IFF_NOFILTER","","",null,null],[17,"ST_RDONLY","","",null,null],[17,"ST_NOSUID","","",null,null],[17,"ST_NODEV","","",null,null],[17,"ST_NOEXEC","","",null,null],[17,"ST_SYNCHRONOUS","","",null,null],[17,"ST_MANDLOCK","","",null,null],[17,"ST_WRITE","","",null,null],[17,"ST_APPEND","","",null,null],[17,"ST_IMMUTABLE","","",null,null],[17,"ST_NOATIME","","",null,null],[17,"ST_NODIRATIME","","",null,null],[17,"RTLD_NEXT","","",null,null],[17,"RTLD_DEFAULT","","",null,null],[17,"RTLD_NODELETE","","",null,null],[17,"RTLD_NOW","","",null,null],[17,"TCP_MD5SIG","","",null,null],[17,"PTHREAD_MUTEX_INITIALIZER","","",null,null],[17,"PTHREAD_COND_INITIALIZER","","",null,null],[17,"PTHREAD_RWLOCK_INITIALIZER","","",null,null],[17,"PTHREAD_MUTEX_NORMAL","","",null,null],[17,"PTHREAD_MUTEX_RECURSIVE","","",null,null],[17,"PTHREAD_MUTEX_ERRORCHECK","","",null,null],[17,"PTHREAD_MUTEX_DEFAULT","","",null,null],[17,"PTHREAD_PROCESS_PRIVATE","","",null,null],[17,"PTHREAD_PROCESS_SHARED","","",null,null],[17,"__SIZEOF_PTHREAD_COND_T","","",null,null],[17,"RENAME_NOREPLACE","","",null,null],[17,"RENAME_EXCHANGE","","",null,null],[17,"RENAME_WHITEOUT","","",null,null],[17,"SCHED_OTHER","","",null,null],[17,"SCHED_FIFO","","",null,null],[17,"SCHED_RR","","",null,null],[17,"SCHED_BATCH","","",null,null],[17,"SCHED_IDLE","","",null,null],[17,"IPPROTO_HOPOPTS","","Hop-by-hop option header",null,null],[17,"IPPROTO_IGMP","","group mgmt protocol",null,null],[17,"IPPROTO_IPIP","","for compatibility",null,null],[17,"IPPROTO_EGP","","exterior gateway protocol",null,null],[17,"IPPROTO_PUP","","pup",null,null],[17,"IPPROTO_IDP","","xns idp",null,null],[17,"IPPROTO_TP","","tp-4 w/ class negotiation",null,null],[17,"IPPROTO_DCCP","","DCCP",null,null],[17,"IPPROTO_ROUTING","","IP6 routing header",null,null],[17,"IPPROTO_FRAGMENT","","IP6 fragmentation header",null,null],[17,"IPPROTO_RSVP","","resource reservation",null,null],[17,"IPPROTO_GRE","","General Routing Encap.",null,null],[17,"IPPROTO_ESP","","IP6 Encap Sec. Payload",null,null],[17,"IPPROTO_AH","","IP6 Auth Header",null,null],[17,"IPPROTO_NONE","","IP6 no next header",null,null],[17,"IPPROTO_DSTOPTS","","IP6 destination option",null,null],[17,"IPPROTO_MTP","","",null,null],[17,"IPPROTO_BEETPH","","",null,null],[17,"IPPROTO_ENCAP","","encapsulation header",null,null],[17,"IPPROTO_PIM","","Protocol indep. multicast",null,null],[17,"IPPROTO_COMP","","IP Payload Comp. Protocol",null,null],[17,"IPPROTO_SCTP","","SCTP",null,null],[17,"IPPROTO_MH","","",null,null],[17,"IPPROTO_UDPLITE","","",null,null],[17,"IPPROTO_MPLS","","",null,null],[17,"IPPROTO_RAW","","raw IP packet",null,null],[17,"IPPROTO_MAX","","",null,null],[17,"AF_IB","","",null,null],[17,"AF_MPLS","","",null,null],[17,"AF_NFC","","",null,null],[17,"AF_VSOCK","","",null,null],[17,"PF_IB","","",null,null],[17,"PF_MPLS","","",null,null],[17,"PF_NFC","","",null,null],[17,"PF_VSOCK","","",null,null],[17,"IPC_PRIVATE","","",null,null],[17,"IPC_CREAT","","",null,null],[17,"IPC_EXCL","","",null,null],[17,"IPC_NOWAIT","","",null,null],[17,"IPC_RMID","","",null,null],[17,"IPC_SET","","",null,null],[17,"IPC_STAT","","",null,null],[17,"IPC_INFO","","",null,null],[17,"MSG_STAT","","",null,null],[17,"MSG_INFO","","",null,null],[17,"MSG_NOERROR","","",null,null],[17,"MSG_EXCEPT","","",null,null],[17,"MSG_COPY","","",null,null],[17,"SHM_R","","",null,null],[17,"SHM_W","","",null,null],[17,"SHM_RDONLY","","",null,null],[17,"SHM_RND","","",null,null],[17,"SHM_REMAP","","",null,null],[17,"SHM_EXEC","","",null,null],[17,"SHM_LOCK","","",null,null],[17,"SHM_UNLOCK","","",null,null],[17,"SHM_HUGETLB","","",null,null],[17,"SHM_NORESERVE","","",null,null],[17,"EPOLLRDHUP","","",null,null],[17,"EPOLLEXCLUSIVE","","",null,null],[17,"EPOLLONESHOT","","",null,null],[17,"QFMT_VFS_OLD","","",null,null],[17,"QFMT_VFS_V0","","",null,null],[17,"QFMT_VFS_V1","","",null,null],[17,"EFD_SEMAPHORE","","",null,null],[17,"LOG_NFACILITIES","","",null,null],[17,"SEM_FAILED","","",null,null],[17,"RB_AUTOBOOT","","",null,null],[17,"RB_HALT_SYSTEM","","",null,null],[17,"RB_ENABLE_CAD","","",null,null],[17,"RB_DISABLE_CAD","","",null,null],[17,"RB_POWER_OFF","","",null,null],[17,"RB_SW_SUSPEND","","",null,null],[17,"RB_KEXEC","","",null,null],[17,"AI_PASSIVE","","",null,null],[17,"AI_CANONNAME","","",null,null],[17,"AI_NUMERICHOST","","",null,null],[17,"AI_V4MAPPED","","",null,null],[17,"AI_ALL","","",null,null],[17,"AI_ADDRCONFIG","","",null,null],[17,"AI_NUMERICSERV","","",null,null],[17,"EAI_BADFLAGS","","",null,null],[17,"EAI_NONAME","","",null,null],[17,"EAI_AGAIN","","",null,null],[17,"EAI_FAIL","","",null,null],[17,"EAI_NODATA","","",null,null],[17,"EAI_FAMILY","","",null,null],[17,"EAI_SOCKTYPE","","",null,null],[17,"EAI_SERVICE","","",null,null],[17,"EAI_MEMORY","","",null,null],[17,"EAI_SYSTEM","","",null,null],[17,"EAI_OVERFLOW","","",null,null],[17,"NI_NUMERICHOST","","",null,null],[17,"NI_NUMERICSERV","","",null,null],[17,"NI_NOFQDN","","",null,null],[17,"NI_NAMEREQD","","",null,null],[17,"NI_DGRAM","","",null,null],[17,"SYNC_FILE_RANGE_WAIT_BEFORE","","",null,null],[17,"SYNC_FILE_RANGE_WRITE","","",null,null],[17,"SYNC_FILE_RANGE_WAIT_AFTER","","",null,null],[17,"AIO_CANCELED","","",null,null],[17,"AIO_NOTCANCELED","","",null,null],[17,"AIO_ALLDONE","","",null,null],[17,"LIO_READ","","",null,null],[17,"LIO_WRITE","","",null,null],[17,"LIO_NOP","","",null,null],[17,"LIO_WAIT","","",null,null],[17,"LIO_NOWAIT","","",null,null],[17,"MREMAP_MAYMOVE","","",null,null],[17,"MREMAP_FIXED","","",null,null],[17,"PR_SET_PDEATHSIG","","",null,null],[17,"PR_GET_PDEATHSIG","","",null,null],[17,"PR_GET_DUMPABLE","","",null,null],[17,"PR_SET_DUMPABLE","","",null,null],[17,"PR_GET_UNALIGN","","",null,null],[17,"PR_SET_UNALIGN","","",null,null],[17,"PR_UNALIGN_NOPRINT","","",null,null],[17,"PR_UNALIGN_SIGBUS","","",null,null],[17,"PR_GET_KEEPCAPS","","",null,null],[17,"PR_SET_KEEPCAPS","","",null,null],[17,"PR_GET_FPEMU","","",null,null],[17,"PR_SET_FPEMU","","",null,null],[17,"PR_FPEMU_NOPRINT","","",null,null],[17,"PR_FPEMU_SIGFPE","","",null,null],[17,"PR_GET_FPEXC","","",null,null],[17,"PR_SET_FPEXC","","",null,null],[17,"PR_FP_EXC_SW_ENABLE","","",null,null],[17,"PR_FP_EXC_DIV","","",null,null],[17,"PR_FP_EXC_OVF","","",null,null],[17,"PR_FP_EXC_UND","","",null,null],[17,"PR_FP_EXC_RES","","",null,null],[17,"PR_FP_EXC_INV","","",null,null],[17,"PR_FP_EXC_DISABLED","","",null,null],[17,"PR_FP_EXC_NONRECOV","","",null,null],[17,"PR_FP_EXC_ASYNC","","",null,null],[17,"PR_FP_EXC_PRECISE","","",null,null],[17,"PR_GET_TIMING","","",null,null],[17,"PR_SET_TIMING","","",null,null],[17,"PR_TIMING_STATISTICAL","","",null,null],[17,"PR_TIMING_TIMESTAMP","","",null,null],[17,"PR_SET_NAME","","",null,null],[17,"PR_GET_NAME","","",null,null],[17,"PR_GET_ENDIAN","","",null,null],[17,"PR_SET_ENDIAN","","",null,null],[17,"PR_ENDIAN_BIG","","",null,null],[17,"PR_ENDIAN_LITTLE","","",null,null],[17,"PR_ENDIAN_PPC_LITTLE","","",null,null],[17,"PR_GET_SECCOMP","","",null,null],[17,"PR_SET_SECCOMP","","",null,null],[17,"PR_CAPBSET_READ","","",null,null],[17,"PR_CAPBSET_DROP","","",null,null],[17,"PR_GET_TSC","","",null,null],[17,"PR_SET_TSC","","",null,null],[17,"PR_TSC_ENABLE","","",null,null],[17,"PR_TSC_SIGSEGV","","",null,null],[17,"PR_GET_SECUREBITS","","",null,null],[17,"PR_SET_SECUREBITS","","",null,null],[17,"PR_SET_TIMERSLACK","","",null,null],[17,"PR_GET_TIMERSLACK","","",null,null],[17,"PR_TASK_PERF_EVENTS_DISABLE","","",null,null],[17,"PR_TASK_PERF_EVENTS_ENABLE","","",null,null],[17,"PR_MCE_KILL","","",null,null],[17,"PR_MCE_KILL_CLEAR","","",null,null],[17,"PR_MCE_KILL_SET","","",null,null],[17,"PR_MCE_KILL_LATE","","",null,null],[17,"PR_MCE_KILL_EARLY","","",null,null],[17,"PR_MCE_KILL_DEFAULT","","",null,null],[17,"PR_MCE_KILL_GET","","",null,null],[17,"PR_SET_MM","","",null,null],[17,"PR_SET_MM_START_CODE","","",null,null],[17,"PR_SET_MM_END_CODE","","",null,null],[17,"PR_SET_MM_START_DATA","","",null,null],[17,"PR_SET_MM_END_DATA","","",null,null],[17,"PR_SET_MM_START_STACK","","",null,null],[17,"PR_SET_MM_START_BRK","","",null,null],[17,"PR_SET_MM_BRK","","",null,null],[17,"PR_SET_MM_ARG_START","","",null,null],[17,"PR_SET_MM_ARG_END","","",null,null],[17,"PR_SET_MM_ENV_START","","",null,null],[17,"PR_SET_MM_ENV_END","","",null,null],[17,"PR_SET_MM_AUXV","","",null,null],[17,"PR_SET_MM_EXE_FILE","","",null,null],[17,"PR_SET_MM_MAP","","",null,null],[17,"PR_SET_MM_MAP_SIZE","","",null,null],[17,"PR_SET_PTRACER","","",null,null],[17,"PR_SET_CHILD_SUBREAPER","","",null,null],[17,"PR_GET_CHILD_SUBREAPER","","",null,null],[17,"PR_SET_NO_NEW_PRIVS","","",null,null],[17,"PR_GET_NO_NEW_PRIVS","","",null,null],[17,"PR_GET_TID_ADDRESS","","",null,null],[17,"PR_SET_THP_DISABLE","","",null,null],[17,"PR_GET_THP_DISABLE","","",null,null],[17,"PR_MPX_ENABLE_MANAGEMENT","","",null,null],[17,"PR_MPX_DISABLE_MANAGEMENT","","",null,null],[17,"PR_SET_FP_MODE","","",null,null],[17,"PR_GET_FP_MODE","","",null,null],[17,"PR_FP_MODE_FR","","",null,null],[17,"PR_FP_MODE_FRE","","",null,null],[17,"PR_CAP_AMBIENT","","",null,null],[17,"PR_CAP_AMBIENT_IS_SET","","",null,null],[17,"PR_CAP_AMBIENT_RAISE","","",null,null],[17,"PR_CAP_AMBIENT_LOWER","","",null,null],[17,"PR_CAP_AMBIENT_CLEAR_ALL","","",null,null],[17,"GRND_NONBLOCK","","",null,null],[17,"GRND_RANDOM","","",null,null],[17,"SECCOMP_MODE_DISABLED","","",null,null],[17,"SECCOMP_MODE_STRICT","","",null,null],[17,"SECCOMP_MODE_FILTER","","",null,null],[17,"ITIMER_REAL","","",null,null],[17,"ITIMER_VIRTUAL","","",null,null],[17,"ITIMER_PROF","","",null,null],[17,"TFD_CLOEXEC","","",null,null],[17,"TFD_NONBLOCK","","",null,null],[17,"TFD_TIMER_ABSTIME","","",null,null],[17,"XATTR_CREATE","","",null,null],[17,"XATTR_REPLACE","","",null,null],[17,"_POSIX_VDISABLE","","",null,null],[17,"FALLOC_FL_KEEP_SIZE","","",null,null],[17,"FALLOC_FL_PUNCH_HOLE","","",null,null],[17,"FALLOC_FL_COLLAPSE_RANGE","","",null,null],[17,"FALLOC_FL_ZERO_RANGE","","",null,null],[17,"FALLOC_FL_INSERT_RANGE","","",null,null],[17,"FALLOC_FL_UNSHARE_RANGE","","",null,null],[17,"ENOATTR","","",null,null],[17,"SO_ORIGINAL_DST","","",null,null],[17,"IUTF8","","",null,null],[17,"CMSPAR","","",null,null],[17,"MFD_CLOEXEC","","",null,null],[17,"MFD_ALLOW_SEALING","","",null,null],[17,"PT_NULL","","",null,null],[17,"PT_LOAD","","",null,null],[17,"PT_DYNAMIC","","",null,null],[17,"PT_INTERP","","",null,null],[17,"PT_NOTE","","",null,null],[17,"PT_SHLIB","","",null,null],[17,"PT_PHDR","","",null,null],[17,"PT_TLS","","",null,null],[17,"PT_NUM","","",null,null],[17,"PT_LOOS","","",null,null],[17,"PT_GNU_EH_FRAME","","",null,null],[17,"PT_GNU_STACK","","",null,null],[17,"PT_GNU_RELRO","","",null,null],[17,"ETH_ALEN","","",null,null],[17,"ETH_HLEN","","",null,null],[17,"ETH_ZLEN","","",null,null],[17,"ETH_DATA_LEN","","",null,null],[17,"ETH_FRAME_LEN","","",null,null],[17,"ETH_FCS_LEN","","",null,null],[17,"ETH_P_LOOP","","",null,null],[17,"ETH_P_PUP","","",null,null],[17,"ETH_P_PUPAT","","",null,null],[17,"ETH_P_IP","","",null,null],[17,"ETH_P_X25","","",null,null],[17,"ETH_P_ARP","","",null,null],[17,"ETH_P_BPQ","","",null,null],[17,"ETH_P_IEEEPUP","","",null,null],[17,"ETH_P_IEEEPUPAT","","",null,null],[17,"ETH_P_BATMAN","","",null,null],[17,"ETH_P_DEC","","",null,null],[17,"ETH_P_DNA_DL","","",null,null],[17,"ETH_P_DNA_RC","","",null,null],[17,"ETH_P_DNA_RT","","",null,null],[17,"ETH_P_LAT","","",null,null],[17,"ETH_P_DIAG","","",null,null],[17,"ETH_P_CUST","","",null,null],[17,"ETH_P_SCA","","",null,null],[17,"ETH_P_TEB","","",null,null],[17,"ETH_P_RARP","","",null,null],[17,"ETH_P_ATALK","","",null,null],[17,"ETH_P_AARP","","",null,null],[17,"ETH_P_8021Q","","",null,null],[17,"ETH_P_IPX","","",null,null],[17,"ETH_P_IPV6","","",null,null],[17,"ETH_P_PAUSE","","",null,null],[17,"ETH_P_SLOW","","",null,null],[17,"ETH_P_WCCP","","",null,null],[17,"ETH_P_MPLS_UC","","",null,null],[17,"ETH_P_MPLS_MC","","",null,null],[17,"ETH_P_ATMMPOA","","",null,null],[17,"ETH_P_PPP_DISC","","",null,null],[17,"ETH_P_PPP_SES","","",null,null],[17,"ETH_P_LINK_CTL","","",null,null],[17,"ETH_P_ATMFATE","","",null,null],[17,"ETH_P_PAE","","",null,null],[17,"ETH_P_AOE","","",null,null],[17,"ETH_P_8021AD","","",null,null],[17,"ETH_P_802_EX1","","",null,null],[17,"ETH_P_TIPC","","",null,null],[17,"ETH_P_MACSEC","","",null,null],[17,"ETH_P_8021AH","","",null,null],[17,"ETH_P_MVRP","","",null,null],[17,"ETH_P_1588","","",null,null],[17,"ETH_P_PRP","","",null,null],[17,"ETH_P_FCOE","","",null,null],[17,"ETH_P_TDLS","","",null,null],[17,"ETH_P_FIP","","",null,null],[17,"ETH_P_80221","","",null,null],[17,"ETH_P_LOOPBACK","","",null,null],[17,"ETH_P_QINQ1","","",null,null],[17,"ETH_P_QINQ2","","",null,null],[17,"ETH_P_QINQ3","","",null,null],[17,"ETH_P_EDSA","","",null,null],[17,"ETH_P_AF_IUCV","","",null,null],[17,"ETH_P_802_3_MIN","","",null,null],[17,"ETH_P_802_3","","",null,null],[17,"ETH_P_AX25","","",null,null],[17,"ETH_P_ALL","","",null,null],[17,"ETH_P_802_2","","",null,null],[17,"ETH_P_SNAP","","",null,null],[17,"ETH_P_DDCMP","","",null,null],[17,"ETH_P_WAN_PPP","","",null,null],[17,"ETH_P_PPP_MP","","",null,null],[17,"ETH_P_LOCALTALK","","",null,null],[17,"ETH_P_CANFD","","",null,null],[17,"ETH_P_PPPTALK","","",null,null],[17,"ETH_P_TR_802_2","","",null,null],[17,"ETH_P_MOBITEX","","",null,null],[17,"ETH_P_CONTROL","","",null,null],[17,"ETH_P_IRDA","","",null,null],[17,"ETH_P_ECONET","","",null,null],[17,"ETH_P_HDLC","","",null,null],[17,"ETH_P_ARCNET","","",null,null],[17,"ETH_P_DSA","","",null,null],[17,"ETH_P_TRAILER","","",null,null],[17,"ETH_P_PHONET","","",null,null],[17,"ETH_P_IEEE802154","","",null,null],[17,"ETH_P_CAIF","","",null,null],[17,"POSIX_SPAWN_RESETIDS","","",null,null],[17,"POSIX_SPAWN_SETPGROUP","","",null,null],[17,"POSIX_SPAWN_SETSIGDEF","","",null,null],[17,"POSIX_SPAWN_SETSIGMASK","","",null,null],[17,"POSIX_SPAWN_SETSCHEDPARAM","","",null,null],[17,"POSIX_SPAWN_SETSCHEDULER","","",null,null],[17,"NLMSG_NOOP","","",null,null],[17,"NLMSG_ERROR","","",null,null],[17,"NLMSG_DONE","","",null,null],[17,"NLMSG_OVERRUN","","",null,null],[17,"NLMSG_MIN_TYPE","","",null,null],[17,"GENL_NAMSIZ","","",null,null],[17,"GENL_MIN_ID","","",null,null],[17,"GENL_MAX_ID","","",null,null],[17,"GENL_ADMIN_PERM","","",null,null],[17,"GENL_CMD_CAP_DO","","",null,null],[17,"GENL_CMD_CAP_DUMP","","",null,null],[17,"GENL_CMD_CAP_HASPOL","","",null,null],[17,"GENL_ID_CTRL","","",null,null],[17,"CTRL_CMD_UNSPEC","","",null,null],[17,"CTRL_CMD_NEWFAMILY","","",null,null],[17,"CTRL_CMD_DELFAMILY","","",null,null],[17,"CTRL_CMD_GETFAMILY","","",null,null],[17,"CTRL_CMD_NEWOPS","","",null,null],[17,"CTRL_CMD_DELOPS","","",null,null],[17,"CTRL_CMD_GETOPS","","",null,null],[17,"CTRL_CMD_NEWMCAST_GRP","","",null,null],[17,"CTRL_CMD_DELMCAST_GRP","","",null,null],[17,"CTRL_CMD_GETMCAST_GRP","","",null,null],[17,"CTRL_ATTR_UNSPEC","","",null,null],[17,"CTRL_ATTR_FAMILY_ID","","",null,null],[17,"CTRL_ATTR_FAMILY_NAME","","",null,null],[17,"CTRL_ATTR_VERSION","","",null,null],[17,"CTRL_ATTR_HDRSIZE","","",null,null],[17,"CTRL_ATTR_MAXATTR","","",null,null],[17,"CTRL_ATTR_OPS","","",null,null],[17,"CTRL_ATTR_MCAST_GROUPS","","",null,null],[17,"CTRL_ATTR_OP_UNSPEC","","",null,null],[17,"CTRL_ATTR_OP_ID","","",null,null],[17,"CTRL_ATTR_OP_FLAGS","","",null,null],[17,"CTRL_ATTR_MCAST_GRP_UNSPEC","","",null,null],[17,"CTRL_ATTR_MCAST_GRP_NAME","","",null,null],[17,"CTRL_ATTR_MCAST_GRP_ID","","",null,null],[17,"NF_DROP","","",null,null],[17,"NF_ACCEPT","","",null,null],[17,"NF_STOLEN","","",null,null],[17,"NF_QUEUE","","",null,null],[17,"NF_REPEAT","","",null,null],[17,"NF_STOP","","",null,null],[17,"NF_MAX_VERDICT","","",null,null],[17,"NF_VERDICT_MASK","","",null,null],[17,"NF_VERDICT_FLAG_QUEUE_BYPASS","","",null,null],[17,"NF_VERDICT_QMASK","","",null,null],[17,"NF_VERDICT_QBITS","","",null,null],[17,"NF_VERDICT_BITS","","",null,null],[17,"NF_INET_PRE_ROUTING","","",null,null],[17,"NF_INET_LOCAL_IN","","",null,null],[17,"NF_INET_FORWARD","","",null,null],[17,"NF_INET_LOCAL_OUT","","",null,null],[17,"NF_INET_POST_ROUTING","","",null,null],[17,"NF_INET_NUMHOOKS","","",null,null],[17,"NFPROTO_UNSPEC","","",null,null],[17,"NFPROTO_IPV4","","",null,null],[17,"NFPROTO_ARP","","",null,null],[17,"NFPROTO_BRIDGE","","",null,null],[17,"NFPROTO_IPV6","","",null,null],[17,"NFPROTO_DECNET","","",null,null],[17,"NFPROTO_NUMPROTO","","",null,null],[17,"NF_IP_PRE_ROUTING","","",null,null],[17,"NF_IP_LOCAL_IN","","",null,null],[17,"NF_IP_FORWARD","","",null,null],[17,"NF_IP_LOCAL_OUT","","",null,null],[17,"NF_IP_POST_ROUTING","","",null,null],[17,"NF_IP_NUMHOOKS","","",null,null],[17,"NF_IP_PRI_FIRST","","",null,null],[17,"NF_IP_PRI_CONNTRACK_DEFRAG","","",null,null],[17,"NF_IP_PRI_RAW","","",null,null],[17,"NF_IP_PRI_SELINUX_FIRST","","",null,null],[17,"NF_IP_PRI_CONNTRACK","","",null,null],[17,"NF_IP_PRI_MANGLE","","",null,null],[17,"NF_IP_PRI_NAT_DST","","",null,null],[17,"NF_IP_PRI_FILTER","","",null,null],[17,"NF_IP_PRI_SECURITY","","",null,null],[17,"NF_IP_PRI_NAT_SRC","","",null,null],[17,"NF_IP_PRI_SELINUX_LAST","","",null,null],[17,"NF_IP_PRI_CONNTRACK_HELPER","","",null,null],[17,"NF_IP_PRI_CONNTRACK_CONFIRM","","",null,null],[17,"NF_IP_PRI_LAST","","",null,null],[17,"NF_IP6_PRE_ROUTING","","",null,null],[17,"NF_IP6_LOCAL_IN","","",null,null],[17,"NF_IP6_FORWARD","","",null,null],[17,"NF_IP6_LOCAL_OUT","","",null,null],[17,"NF_IP6_POST_ROUTING","","",null,null],[17,"NF_IP6_NUMHOOKS","","",null,null],[17,"NF_IP6_PRI_FIRST","","",null,null],[17,"NF_IP6_PRI_CONNTRACK_DEFRAG","","",null,null],[17,"NF_IP6_PRI_RAW","","",null,null],[17,"NF_IP6_PRI_SELINUX_FIRST","","",null,null],[17,"NF_IP6_PRI_CONNTRACK","","",null,null],[17,"NF_IP6_PRI_MANGLE","","",null,null],[17,"NF_IP6_PRI_NAT_DST","","",null,null],[17,"NF_IP6_PRI_FILTER","","",null,null],[17,"NF_IP6_PRI_SECURITY","","",null,null],[17,"NF_IP6_PRI_NAT_SRC","","",null,null],[17,"NF_IP6_PRI_SELINUX_LAST","","",null,null],[17,"NF_IP6_PRI_CONNTRACK_HELPER","","",null,null],[17,"NF_IP6_PRI_LAST","","",null,null],[11,"clone","libc","",36,{"i":[{"n":"self"}],"o":{"n":"dirent"}}],[11,"clone","","",37,{"i":[{"n":"self"}],"o":{"n":"dirent64"}}],[11,"clone","","",38,{"i":[{"n":"self"}],"o":{"n":"rlimit64"}}],[11,"clone","","",39,{"i":[{"n":"self"}],"o":{"n":"glob_t"}}],[11,"clone","","",40,{"i":[{"n":"self"}],"o":{"n":"ifaddrs"}}],[11,"clone","","",41,{"i":[{"n":"self"}],"o":{"n":"pthread_mutex_t"}}],[11,"clone","","",42,{"i":[{"n":"self"}],"o":{"n":"pthread_rwlock_t"}}],[11,"clone","","",43,{"i":[{"n":"self"}],"o":{"n":"pthread_mutexattr_t"}}],[11,"clone","","",44,{"i":[{"n":"self"}],"o":{"n":"pthread_rwlockattr_t"}}],[11,"clone","","",45,{"i":[{"n":"self"}],"o":{"n":"pthread_cond_t"}}],[11,"clone","","",46,{"i":[{"n":"self"}],"o":{"n":"pthread_condattr_t"}}],[11,"clone","","",47,{"i":[{"n":"self"}],"o":{"n":"passwd"}}],[11,"clone","","",48,{"i":[{"n":"self"}],"o":{"n":"spwd"}}],[11,"clone","","",49,{"i":[{"n":"self"}],"o":{"n":"statvfs"}}],[11,"clone","","",50,{"i":[{"n":"self"}],"o":{"n":"dqblk"}}],[11,"clone","","",51,{"i":[{"n":"self"}],"o":{"n":"signalfd_siginfo"}}],[11,"clone","","",52,{"i":[{"n":"self"}],"o":{"n":"itimerspec"}}],[11,"clone","","",53,{"i":[{"n":"self"}],"o":{"n":"fsid_t"}}],[11,"clone","","",54,{"i":[{"n":"self"}],"o":{"n":"mq_attr"}}],[11,"clone","","",55,{"i":[{"n":"self"}],"o":{"n":"cpu_set_t"}}],[11,"clone","","",56,{"i":[{"n":"self"}],"o":{"n":"if_nameindex"}}],[11,"clone","","",57,{"i":[{"n":"self"}],"o":{"n":"msginfo"}}],[11,"clone","","",58,{"i":[{"n":"self"}],"o":{"n":"mmsghdr"}}],[11,"clone","","",59,{"i":[{"n":"self"}],"o":{"n":"sembuf"}}],[11,"clone","","",60,{"i":[{"n":"self"}],"o":{"n":"input_event"}}],[11,"clone","","",61,{"i":[{"n":"self"}],"o":{"n":"input_id"}}],[11,"clone","","",62,{"i":[{"n":"self"}],"o":{"n":"input_absinfo"}}],[11,"clone","","",63,{"i":[{"n":"self"}],"o":{"n":"input_keymap_entry"}}],[11,"clone","","",64,{"i":[{"n":"self"}],"o":{"n":"input_mask"}}],[11,"clone","","",65,{"i":[{"n":"self"}],"o":{"n":"ff_replay"}}],[11,"clone","","",66,{"i":[{"n":"self"}],"o":{"n":"ff_trigger"}}],[11,"clone","","",67,{"i":[{"n":"self"}],"o":{"n":"ff_envelope"}}],[11,"clone","","",68,{"i":[{"n":"self"}],"o":{"n":"ff_constant_effect"}}],[11,"clone","","",69,{"i":[{"n":"self"}],"o":{"n":"ff_ramp_effect"}}],[11,"clone","","",70,{"i":[{"n":"self"}],"o":{"n":"ff_condition_effect"}}],[11,"clone","","",71,{"i":[{"n":"self"}],"o":{"n":"ff_periodic_effect"}}],[11,"clone","","",72,{"i":[{"n":"self"}],"o":{"n":"ff_rumble_effect"}}],[11,"clone","","",73,{"i":[{"n":"self"}],"o":{"n":"ff_effect"}}],[11,"clone","","",74,{"i":[{"n":"self"}],"o":{"n":"dl_phdr_info"}}],[11,"clone","","",75,{"i":[{"n":"self"}],"o":{"n":"elf32_phdr"}}],[11,"clone","","",76,{"i":[{"n":"self"}],"o":{"n":"elf64_phdr"}}],[11,"clone","","",77,{"i":[{"n":"self"}],"o":{"n":"ucred"}}],[11,"clone","","",78,{"i":[{"n":"self"}],"o":{"n":"mntent"}}],[11,"clone","","",79,{"i":[{"n":"self"}],"o":{"n":"posix_spawn_file_actions_t"}}],[11,"clone","","",80,{"i":[{"n":"self"}],"o":{"n":"posix_spawnattr_t"}}],[11,"clone","","",81,{"i":[{"n":"self"}],"o":{"n":"genlmsghdr"}}],[6,"sa_family_t","libc::unix::notbsd","",null,null],[6,"pthread_key_t","","",null,null],[6,"speed_t","","",null,null],[6,"tcflag_t","","",null,null],[6,"clockid_t","","",null,null],[6,"key_t","","",null,null],[6,"id_t","","",null,null],[17,"ULONG_SIZE","","",null,null],[17,"EXIT_FAILURE","","",null,null],[17,"EXIT_SUCCESS","","",null,null],[17,"RAND_MAX","","",null,null],[17,"EOF","","",null,null],[17,"SEEK_SET","","",null,null],[17,"SEEK_CUR","","",null,null],[17,"SEEK_END","","",null,null],[17,"_IOFBF","","",null,null],[17,"_IONBF","","",null,null],[17,"_IOLBF","","",null,null],[17,"F_DUPFD","","",null,null],[17,"F_GETFD","","",null,null],[17,"F_SETFD","","",null,null],[17,"F_GETFL","","",null,null],[17,"F_SETFL","","",null,null],[17,"F_SETLEASE","","",null,null],[17,"F_GETLEASE","","",null,null],[17,"F_NOTIFY","","",null,null],[17,"F_CANCELLK","","",null,null],[17,"F_DUPFD_CLOEXEC","","",null,null],[17,"F_SETPIPE_SZ","","",null,null],[17,"F_GETPIPE_SZ","","",null,null],[17,"F_ADD_SEALS","","",null,null],[17,"F_GET_SEALS","","",null,null],[17,"F_SEAL_SEAL","","",null,null],[17,"F_SEAL_SHRINK","","",null,null],[17,"F_SEAL_GROW","","",null,null],[17,"F_SEAL_WRITE","","",null,null],[17,"SIGTRAP","","",null,null],[17,"PTHREAD_CREATE_JOINABLE","","",null,null],[17,"PTHREAD_CREATE_DETACHED","","",null,null],[17,"CLOCK_REALTIME","","",null,null],[17,"CLOCK_MONOTONIC","","",null,null],[17,"CLOCK_PROCESS_CPUTIME_ID","","",null,null],[17,"CLOCK_THREAD_CPUTIME_ID","","",null,null],[17,"CLOCK_MONOTONIC_RAW","","",null,null],[17,"CLOCK_REALTIME_COARSE","","",null,null],[17,"CLOCK_MONOTONIC_COARSE","","",null,null],[17,"CLOCK_BOOTTIME","","",null,null],[17,"CLOCK_REALTIME_ALARM","","",null,null],[17,"CLOCK_BOOTTIME_ALARM","","",null,null],[17,"TIMER_ABSTIME","","",null,null],[17,"RLIMIT_CPU","","",null,null],[17,"RLIMIT_FSIZE","","",null,null],[17,"RLIMIT_DATA","","",null,null],[17,"RLIMIT_STACK","","",null,null],[17,"RLIMIT_CORE","","",null,null],[17,"RLIMIT_LOCKS","","",null,null],[17,"RLIMIT_SIGPENDING","","",null,null],[17,"RLIMIT_MSGQUEUE","","",null,null],[17,"RLIMIT_NICE","","",null,null],[17,"RLIMIT_RTPRIO","","",null,null],[17,"RUSAGE_SELF","","",null,null],[17,"O_RDONLY","","",null,null],[17,"O_WRONLY","","",null,null],[17,"O_RDWR","","",null,null],[17,"SOCK_CLOEXEC","","",null,null],[17,"S_IFIFO","","",null,null],[17,"S_IFCHR","","",null,null],[17,"S_IFBLK","","",null,null],[17,"S_IFDIR","","",null,null],[17,"S_IFREG","","",null,null],[17,"S_IFLNK","","",null,null],[17,"S_IFSOCK","","",null,null],[17,"S_IFMT","","",null,null],[17,"S_IRWXU","","",null,null],[17,"S_IXUSR","","",null,null],[17,"S_IWUSR","","",null,null],[17,"S_IRUSR","","",null,null],[17,"S_IRWXG","","",null,null],[17,"S_IXGRP","","",null,null],[17,"S_IWGRP","","",null,null],[17,"S_IRGRP","","",null,null],[17,"S_IRWXO","","",null,null],[17,"S_IXOTH","","",null,null],[17,"S_IWOTH","","",null,null],[17,"S_IROTH","","",null,null],[17,"F_OK","","",null,null],[17,"R_OK","","",null,null],[17,"W_OK","","",null,null],[17,"X_OK","","",null,null],[17,"STDIN_FILENO","","",null,null],[17,"STDOUT_FILENO","","",null,null],[17,"STDERR_FILENO","","",null,null],[17,"SIGHUP","","",null,null],[17,"SIGINT","","",null,null],[17,"SIGQUIT","","",null,null],[17,"SIGILL","","",null,null],[17,"SIGABRT","","",null,null],[17,"SIGFPE","","",null,null],[17,"SIGKILL","","",null,null],[17,"SIGSEGV","","",null,null],[17,"SIGPIPE","","",null,null],[17,"SIGALRM","","",null,null],[17,"SIGTERM","","",null,null],[17,"PROT_NONE","","",null,null],[17,"PROT_READ","","",null,null],[17,"PROT_WRITE","","",null,null],[17,"PROT_EXEC","","",null,null],[17,"LC_CTYPE","","",null,null],[17,"LC_NUMERIC","","",null,null],[17,"LC_TIME","","",null,null],[17,"LC_COLLATE","","",null,null],[17,"LC_MONETARY","","",null,null],[17,"LC_MESSAGES","","",null,null],[17,"LC_ALL","","",null,null],[17,"LC_CTYPE_MASK","","",null,null],[17,"LC_NUMERIC_MASK","","",null,null],[17,"LC_TIME_MASK","","",null,null],[17,"LC_COLLATE_MASK","","",null,null],[17,"LC_MONETARY_MASK","","",null,null],[17,"LC_MESSAGES_MASK","","",null,null],[17,"MAP_FILE","","",null,null],[17,"MAP_SHARED","","",null,null],[17,"MAP_PRIVATE","","",null,null],[17,"MAP_FIXED","","",null,null],[17,"MAP_FAILED","","",null,null],[17,"MS_ASYNC","","",null,null],[17,"MS_INVALIDATE","","",null,null],[17,"MS_SYNC","","",null,null],[17,"MS_RDONLY","","",null,null],[17,"MS_NOSUID","","",null,null],[17,"MS_NODEV","","",null,null],[17,"MS_NOEXEC","","",null,null],[17,"MS_SYNCHRONOUS","","",null,null],[17,"MS_REMOUNT","","",null,null],[17,"MS_MANDLOCK","","",null,null],[17,"MS_DIRSYNC","","",null,null],[17,"MS_NOATIME","","",null,null],[17,"MS_NODIRATIME","","",null,null],[17,"MS_BIND","","",null,null],[17,"MS_MOVE","","",null,null],[17,"MS_REC","","",null,null],[17,"MS_SILENT","","",null,null],[17,"MS_POSIXACL","","",null,null],[17,"MS_UNBINDABLE","","",null,null],[17,"MS_PRIVATE","","",null,null],[17,"MS_SLAVE","","",null,null],[17,"MS_SHARED","","",null,null],[17,"MS_RELATIME","","",null,null],[17,"MS_KERNMOUNT","","",null,null],[17,"MS_I_VERSION","","",null,null],[17,"MS_STRICTATIME","","",null,null],[17,"MS_ACTIVE","","",null,null],[17,"MS_NOUSER","","",null,null],[17,"MS_MGC_VAL","","",null,null],[17,"MS_MGC_MSK","","",null,null],[17,"MS_RMT_MASK","","",null,null],[17,"EPERM","","",null,null],[17,"ENOENT","","",null,null],[17,"ESRCH","","",null,null],[17,"EINTR","","",null,null],[17,"EIO","","",null,null],[17,"ENXIO","","",null,null],[17,"E2BIG","","",null,null],[17,"ENOEXEC","","",null,null],[17,"EBADF","","",null,null],[17,"ECHILD","","",null,null],[17,"EAGAIN","","",null,null],[17,"ENOMEM","","",null,null],[17,"EACCES","","",null,null],[17,"EFAULT","","",null,null],[17,"ENOTBLK","","",null,null],[17,"EBUSY","","",null,null],[17,"EEXIST","","",null,null],[17,"EXDEV","","",null,null],[17,"ENODEV","","",null,null],[17,"ENOTDIR","","",null,null],[17,"EISDIR","","",null,null],[17,"EINVAL","","",null,null],[17,"ENFILE","","",null,null],[17,"EMFILE","","",null,null],[17,"ENOTTY","","",null,null],[17,"ETXTBSY","","",null,null],[17,"EFBIG","","",null,null],[17,"ENOSPC","","",null,null],[17,"ESPIPE","","",null,null],[17,"EROFS","","",null,null],[17,"EMLINK","","",null,null],[17,"EPIPE","","",null,null],[17,"EDOM","","",null,null],[17,"ERANGE","","",null,null],[17,"EWOULDBLOCK","","",null,null],[17,"SCM_RIGHTS","","",null,null],[17,"SCM_CREDENTIALS","","",null,null],[17,"PROT_GROWSDOWN","","",null,null],[17,"PROT_GROWSUP","","",null,null],[17,"MAP_TYPE","","",null,null],[17,"MADV_NORMAL","","",null,null],[17,"MADV_RANDOM","","",null,null],[17,"MADV_SEQUENTIAL","","",null,null],[17,"MADV_WILLNEED","","",null,null],[17,"MADV_DONTNEED","","",null,null],[17,"MADV_FREE","","",null,null],[17,"MADV_REMOVE","","",null,null],[17,"MADV_DONTFORK","","",null,null],[17,"MADV_DOFORK","","",null,null],[17,"MADV_MERGEABLE","","",null,null],[17,"MADV_UNMERGEABLE","","",null,null],[17,"MADV_HUGEPAGE","","",null,null],[17,"MADV_NOHUGEPAGE","","",null,null],[17,"MADV_DONTDUMP","","",null,null],[17,"MADV_DODUMP","","",null,null],[17,"MADV_HWPOISON","","",null,null],[17,"MADV_SOFT_OFFLINE","","",null,null],[17,"IFF_UP","","",null,null],[17,"IFF_BROADCAST","","",null,null],[17,"IFF_DEBUG","","",null,null],[17,"IFF_LOOPBACK","","",null,null],[17,"IFF_POINTOPOINT","","",null,null],[17,"IFF_NOTRAILERS","","",null,null],[17,"IFF_RUNNING","","",null,null],[17,"IFF_NOARP","","",null,null],[17,"IFF_PROMISC","","",null,null],[17,"IFF_ALLMULTI","","",null,null],[17,"IFF_MASTER","","",null,null],[17,"IFF_SLAVE","","",null,null],[17,"IFF_MULTICAST","","",null,null],[17,"IFF_PORTSEL","","",null,null],[17,"IFF_AUTOMEDIA","","",null,null],[17,"IFF_DYNAMIC","","",null,null],[17,"SOL_IP","","",null,null],[17,"SOL_TCP","","",null,null],[17,"SOL_UDP","","",null,null],[17,"SOL_IPV6","","",null,null],[17,"SOL_ICMPV6","","",null,null],[17,"SOL_RAW","","",null,null],[17,"SOL_DECNET","","",null,null],[17,"SOL_X25","","",null,null],[17,"SOL_PACKET","","",null,null],[17,"SOL_ATM","","",null,null],[17,"SOL_AAL","","",null,null],[17,"SOL_IRDA","","",null,null],[17,"SOL_NETBEUI","","",null,null],[17,"SOL_LLC","","",null,null],[17,"SOL_DCCP","","",null,null],[17,"SOL_NETLINK","","",null,null],[17,"SOL_TIPC","","",null,null],[17,"AF_UNSPEC","","",null,null],[17,"AF_UNIX","","",null,null],[17,"AF_LOCAL","","",null,null],[17,"AF_INET","","",null,null],[17,"AF_AX25","","",null,null],[17,"AF_IPX","","",null,null],[17,"AF_APPLETALK","","",null,null],[17,"AF_NETROM","","",null,null],[17,"AF_BRIDGE","","",null,null],[17,"AF_ATMPVC","","",null,null],[17,"AF_X25","","",null,null],[17,"AF_INET6","","",null,null],[17,"AF_ROSE","","",null,null],[17,"AF_DECnet","","",null,null],[17,"AF_NETBEUI","","",null,null],[17,"AF_SECURITY","","",null,null],[17,"AF_KEY","","",null,null],[17,"AF_NETLINK","","",null,null],[17,"AF_ROUTE","","",null,null],[17,"AF_PACKET","","",null,null],[17,"AF_ASH","","",null,null],[17,"AF_ECONET","","",null,null],[17,"AF_ATMSVC","","",null,null],[17,"AF_RDS","","",null,null],[17,"AF_SNA","","",null,null],[17,"AF_IRDA","","",null,null],[17,"AF_PPPOX","","",null,null],[17,"AF_WANPIPE","","",null,null],[17,"AF_LLC","","",null,null],[17,"AF_CAN","","",null,null],[17,"AF_TIPC","","",null,null],[17,"AF_BLUETOOTH","","",null,null],[17,"AF_IUCV","","",null,null],[17,"AF_RXRPC","","",null,null],[17,"AF_ISDN","","",null,null],[17,"AF_PHONET","","",null,null],[17,"AF_IEEE802154","","",null,null],[17,"AF_CAIF","","",null,null],[17,"AF_ALG","","",null,null],[17,"PF_UNSPEC","","",null,null],[17,"PF_UNIX","","",null,null],[17,"PF_LOCAL","","",null,null],[17,"PF_INET","","",null,null],[17,"PF_AX25","","",null,null],[17,"PF_IPX","","",null,null],[17,"PF_APPLETALK","","",null,null],[17,"PF_NETROM","","",null,null],[17,"PF_BRIDGE","","",null,null],[17,"PF_ATMPVC","","",null,null],[17,"PF_X25","","",null,null],[17,"PF_INET6","","",null,null],[17,"PF_ROSE","","",null,null],[17,"PF_DECnet","","",null,null],[17,"PF_NETBEUI","","",null,null],[17,"PF_SECURITY","","",null,null],[17,"PF_KEY","","",null,null],[17,"PF_NETLINK","","",null,null],[17,"PF_ROUTE","","",null,null],[17,"PF_PACKET","","",null,null],[17,"PF_ASH","","",null,null],[17,"PF_ECONET","","",null,null],[17,"PF_ATMSVC","","",null,null],[17,"PF_RDS","","",null,null],[17,"PF_SNA","","",null,null],[17,"PF_IRDA","","",null,null],[17,"PF_PPPOX","","",null,null],[17,"PF_WANPIPE","","",null,null],[17,"PF_LLC","","",null,null],[17,"PF_CAN","","",null,null],[17,"PF_TIPC","","",null,null],[17,"PF_BLUETOOTH","","",null,null],[17,"PF_IUCV","","",null,null],[17,"PF_RXRPC","","",null,null],[17,"PF_ISDN","","",null,null],[17,"PF_PHONET","","",null,null],[17,"PF_IEEE802154","","",null,null],[17,"PF_CAIF","","",null,null],[17,"PF_ALG","","",null,null],[17,"SOMAXCONN","","",null,null],[17,"MSG_OOB","","",null,null],[17,"MSG_PEEK","","",null,null],[17,"MSG_DONTROUTE","","",null,null],[17,"MSG_CTRUNC","","",null,null],[17,"MSG_TRUNC","","",null,null],[17,"MSG_DONTWAIT","","",null,null],[17,"MSG_EOR","","",null,null],[17,"MSG_WAITALL","","",null,null],[17,"MSG_FIN","","",null,null],[17,"MSG_SYN","","",null,null],[17,"MSG_CONFIRM","","",null,null],[17,"MSG_RST","","",null,null],[17,"MSG_ERRQUEUE","","",null,null],[17,"MSG_NOSIGNAL","","",null,null],[17,"MSG_MORE","","",null,null],[17,"MSG_WAITFORONE","","",null,null],[17,"MSG_FASTOPEN","","",null,null],[17,"MSG_CMSG_CLOEXEC","","",null,null],[17,"SCM_TIMESTAMP","","",null,null],[17,"SOCK_RAW","","",null,null],[17,"SOCK_RDM","","",null,null],[17,"IP_MULTICAST_IF","","",null,null],[17,"IP_MULTICAST_TTL","","",null,null],[17,"IP_MULTICAST_LOOP","","",null,null],[17,"IP_TTL","","",null,null],[17,"IP_HDRINCL","","",null,null],[17,"IP_ADD_MEMBERSHIP","","",null,null],[17,"IP_DROP_MEMBERSHIP","","",null,null],[17,"IP_TRANSPARENT","","",null,null],[17,"IPV6_UNICAST_HOPS","","",null,null],[17,"IPV6_MULTICAST_IF","","",null,null],[17,"IPV6_MULTICAST_HOPS","","",null,null],[17,"IPV6_MULTICAST_LOOP","","",null,null],[17,"IPV6_ADD_MEMBERSHIP","","",null,null],[17,"IPV6_DROP_MEMBERSHIP","","",null,null],[17,"IPV6_V6ONLY","","",null,null],[17,"TCP_NODELAY","","",null,null],[17,"TCP_MAXSEG","","",null,null],[17,"TCP_CORK","","",null,null],[17,"TCP_KEEPIDLE","","",null,null],[17,"TCP_KEEPINTVL","","",null,null],[17,"TCP_KEEPCNT","","",null,null],[17,"TCP_SYNCNT","","",null,null],[17,"TCP_LINGER2","","",null,null],[17,"TCP_DEFER_ACCEPT","","",null,null],[17,"TCP_WINDOW_CLAMP","","",null,null],[17,"TCP_INFO","","",null,null],[17,"TCP_QUICKACK","","",null,null],[17,"TCP_CONGESTION","","",null,null],[17,"SO_DEBUG","","",null,null],[17,"SHUT_RD","","",null,null],[17,"SHUT_WR","","",null,null],[17,"SHUT_RDWR","","",null,null],[17,"LOCK_SH","","",null,null],[17,"LOCK_EX","","",null,null],[17,"LOCK_NB","","",null,null],[17,"LOCK_UN","","",null,null],[17,"SS_ONSTACK","","",null,null],[17,"SS_DISABLE","","",null,null],[17,"PATH_MAX","","",null,null],[17,"FD_SETSIZE","","",null,null],[17,"EPOLLIN","","",null,null],[17,"EPOLLPRI","","",null,null],[17,"EPOLLOUT","","",null,null],[17,"EPOLLRDNORM","","",null,null],[17,"EPOLLRDBAND","","",null,null],[17,"EPOLLWRNORM","","",null,null],[17,"EPOLLWRBAND","","",null,null],[17,"EPOLLMSG","","",null,null],[17,"EPOLLERR","","",null,null],[17,"EPOLLHUP","","",null,null],[17,"EPOLLET","","",null,null],[17,"EPOLL_CTL_ADD","","",null,null],[17,"EPOLL_CTL_MOD","","",null,null],[17,"EPOLL_CTL_DEL","","",null,null],[17,"MNT_DETACH","","",null,null],[17,"MNT_EXPIRE","","",null,null],[17,"Q_GETFMT","","",null,null],[17,"Q_GETINFO","","",null,null],[17,"Q_SETINFO","","",null,null],[17,"QIF_BLIMITS","","",null,null],[17,"QIF_SPACE","","",null,null],[17,"QIF_ILIMITS","","",null,null],[17,"QIF_INODES","","",null,null],[17,"QIF_BTIME","","",null,null],[17,"QIF_ITIME","","",null,null],[17,"QIF_LIMITS","","",null,null],[17,"QIF_USAGE","","",null,null],[17,"QIF_TIMES","","",null,null],[17,"QIF_ALL","","",null,null],[17,"MNT_FORCE","","",null,null],[17,"Q_SYNC","","",null,null],[17,"Q_QUOTAON","","",null,null],[17,"Q_QUOTAOFF","","",null,null],[17,"Q_GETQUOTA","","",null,null],[17,"Q_SETQUOTA","","",null,null],[17,"TCIOFF","","",null,null],[17,"TCION","","",null,null],[17,"TCOOFF","","",null,null],[17,"TCOON","","",null,null],[17,"TCIFLUSH","","",null,null],[17,"TCOFLUSH","","",null,null],[17,"TCIOFLUSH","","",null,null],[17,"NL0","","",null,null],[17,"NL1","","",null,null],[17,"TAB0","","",null,null],[17,"CR0","","",null,null],[17,"FF0","","",null,null],[17,"BS0","","",null,null],[17,"VT0","","",null,null],[17,"VERASE","","",null,null],[17,"VKILL","","",null,null],[17,"VINTR","","",null,null],[17,"VQUIT","","",null,null],[17,"VLNEXT","","",null,null],[17,"IGNBRK","","",null,null],[17,"BRKINT","","",null,null],[17,"IGNPAR","","",null,null],[17,"PARMRK","","",null,null],[17,"INPCK","","",null,null],[17,"ISTRIP","","",null,null],[17,"INLCR","","",null,null],[17,"IGNCR","","",null,null],[17,"ICRNL","","",null,null],[17,"IXANY","","",null,null],[17,"IMAXBEL","","",null,null],[17,"OPOST","","",null,null],[17,"CS5","","",null,null],[17,"CRTSCTS","","",null,null],[17,"ECHO","","",null,null],[17,"OCRNL","","",null,null],[17,"ONOCR","","",null,null],[17,"ONLRET","","",null,null],[17,"OFILL","","",null,null],[17,"OFDEL","","",null,null],[17,"CLONE_VM","","",null,null],[17,"CLONE_FS","","",null,null],[17,"CLONE_FILES","","",null,null],[17,"CLONE_SIGHAND","","",null,null],[17,"CLONE_PTRACE","","",null,null],[17,"CLONE_VFORK","","",null,null],[17,"CLONE_PARENT","","",null,null],[17,"CLONE_THREAD","","",null,null],[17,"CLONE_NEWNS","","",null,null],[17,"CLONE_SYSVSEM","","",null,null],[17,"CLONE_SETTLS","","",null,null],[17,"CLONE_PARENT_SETTID","","",null,null],[17,"CLONE_CHILD_CLEARTID","","",null,null],[17,"CLONE_DETACHED","","",null,null],[17,"CLONE_UNTRACED","","",null,null],[17,"CLONE_CHILD_SETTID","","",null,null],[17,"CLONE_NEWUTS","","",null,null],[17,"CLONE_NEWIPC","","",null,null],[17,"CLONE_NEWUSER","","",null,null],[17,"CLONE_NEWPID","","",null,null],[17,"CLONE_NEWNET","","",null,null],[17,"CLONE_IO","","",null,null],[17,"CLONE_NEWCGROUP","","",null,null],[17,"WNOHANG","","",null,null],[17,"WUNTRACED","","",null,null],[17,"WSTOPPED","","",null,null],[17,"WEXITED","","",null,null],[17,"WCONTINUED","","",null,null],[17,"WNOWAIT","","",null,null],[17,"PTRACE_O_TRACESYSGOOD","","",null,null],[17,"PTRACE_O_TRACEFORK","","",null,null],[17,"PTRACE_O_TRACEVFORK","","",null,null],[17,"PTRACE_O_TRACECLONE","","",null,null],[17,"PTRACE_O_TRACEEXEC","","",null,null],[17,"PTRACE_O_TRACEVFORKDONE","","",null,null],[17,"PTRACE_O_TRACEEXIT","","",null,null],[17,"PTRACE_O_TRACESECCOMP","","",null,null],[17,"PTRACE_O_EXITKILL","","",null,null],[17,"PTRACE_O_SUSPEND_SECCOMP","","",null,null],[17,"PTRACE_O_MASK","","",null,null],[17,"PTRACE_EVENT_FORK","","",null,null],[17,"PTRACE_EVENT_VFORK","","",null,null],[17,"PTRACE_EVENT_CLONE","","",null,null],[17,"PTRACE_EVENT_EXEC","","",null,null],[17,"PTRACE_EVENT_VFORK_DONE","","",null,null],[17,"PTRACE_EVENT_EXIT","","",null,null],[17,"PTRACE_EVENT_SECCOMP","","",null,null],[17,"__WNOTHREAD","","",null,null],[17,"__WALL","","",null,null],[17,"__WCLONE","","",null,null],[17,"SPLICE_F_MOVE","","",null,null],[17,"SPLICE_F_NONBLOCK","","",null,null],[17,"SPLICE_F_MORE","","",null,null],[17,"SPLICE_F_GIFT","","",null,null],[17,"RTLD_LOCAL","","",null,null],[17,"RTLD_LAZY","","",null,null],[17,"POSIX_FADV_NORMAL","","",null,null],[17,"POSIX_FADV_RANDOM","","",null,null],[17,"POSIX_FADV_SEQUENTIAL","","",null,null],[17,"POSIX_FADV_WILLNEED","","",null,null],[17,"AT_FDCWD","","",null,null],[17,"AT_SYMLINK_NOFOLLOW","","",null,null],[17,"AT_REMOVEDIR","","",null,null],[17,"AT_SYMLINK_FOLLOW","","",null,null],[17,"AT_NO_AUTOMOUNT","","",null,null],[17,"AT_EMPTY_PATH","","",null,null],[17,"LOG_CRON","","",null,null],[17,"LOG_AUTHPRIV","","",null,null],[17,"LOG_FTP","","",null,null],[17,"LOG_PERROR","","",null,null],[17,"PIPE_BUF","","",null,null],[17,"SI_LOAD_SHIFT","","",null,null],[17,"SIGEV_SIGNAL","","",null,null],[17,"SIGEV_NONE","","",null,null],[17,"SIGEV_THREAD","","",null,null],[17,"P_ALL","","",null,null],[17,"P_PID","","",null,null],[17,"P_PGID","","",null,null],[17,"UTIME_OMIT","","",null,null],[17,"UTIME_NOW","","",null,null],[17,"POLLIN","","",null,null],[17,"POLLPRI","","",null,null],[17,"POLLOUT","","",null,null],[17,"POLLERR","","",null,null],[17,"POLLHUP","","",null,null],[17,"POLLNVAL","","",null,null],[17,"POLLRDNORM","","",null,null],[17,"POLLRDBAND","","",null,null],[11,"clone","libc","",20,{"i":[{"n":"self"}],"o":{"n":"sockaddr"}}],[11,"clone","","",21,{"i":[{"n":"self"}],"o":{"n":"sockaddr_in"}}],[11,"clone","","",22,{"i":[{"n":"self"}],"o":{"n":"sockaddr_in6"}}],[11,"clone","","",23,{"i":[{"n":"self"}],"o":{"n":"sockaddr_un"}}],[11,"clone","","",24,{"i":[{"n":"self"}],"o":{"n":"sockaddr_storage"}}],[11,"clone","","",25,{"i":[{"n":"self"}],"o":{"n":"addrinfo"}}],[11,"clone","","",26,{"i":[{"n":"self"}],"o":{"n":"sockaddr_nl"}}],[11,"clone","","",27,{"i":[{"n":"self"}],"o":{"n":"sockaddr_ll"}}],[11,"clone","","",28,{"i":[{"n":"self"}],"o":{"n":"fd_set"}}],[11,"clone","","",29,{"i":[{"n":"self"}],"o":{"n":"tm"}}],[11,"clone","","",30,{"i":[{"n":"self"}],"o":{"n":"sched_param"}}],[11,"clone","","",31,{"i":[{"n":"self"}],"o":{"n":"dl_info"}}],[11,"clone","","",32,{"i":[{"n":"self"}],"o":{"n":"epoll_event"}}],[11,"clone","","",33,{"i":[{"n":"self"}],"o":{"n":"utsname"}}],[11,"clone","","",34,{"i":[{"n":"self"}],"o":{"n":"lconv"}}],[11,"clone","","",35,{"i":[{"n":"self"}],"o":{"n":"sigevent"}}],[6,"pid_t","libc::unix","",null,null],[6,"uid_t","","",null,null],[6,"gid_t","","",null,null],[6,"in_addr_t","","",null,null],[6,"in_port_t","","",null,null],[6,"sighandler_t","","",null,null],[6,"cc_t","","",null,null],[17,"SIG_DFL","","",null,null],[17,"SIG_IGN","","",null,null],[17,"SIG_ERR","","",null,null],[17,"DT_UNKNOWN","","",null,null],[17,"DT_FIFO","","",null,null],[17,"DT_CHR","","",null,null],[17,"DT_DIR","","",null,null],[17,"DT_BLK","","",null,null],[17,"DT_REG","","",null,null],[17,"DT_LNK","","",null,null],[17,"DT_SOCK","","",null,null],[17,"FD_CLOEXEC","","",null,null],[17,"USRQUOTA","","",null,null],[17,"GRPQUOTA","","",null,null],[17,"SIGIOT","","",null,null],[17,"S_ISUID","","",null,null],[17,"S_ISGID","","",null,null],[17,"S_ISVTX","","",null,null],[17,"IF_NAMESIZE","","",null,null],[17,"IFNAMSIZ","","",null,null],[17,"LOG_EMERG","","",null,null],[17,"LOG_ALERT","","",null,null],[17,"LOG_CRIT","","",null,null],[17,"LOG_ERR","","",null,null],[17,"LOG_WARNING","","",null,null],[17,"LOG_NOTICE","","",null,null],[17,"LOG_INFO","","",null,null],[17,"LOG_DEBUG","","",null,null],[17,"LOG_KERN","","",null,null],[17,"LOG_USER","","",null,null],[17,"LOG_MAIL","","",null,null],[17,"LOG_DAEMON","","",null,null],[17,"LOG_AUTH","","",null,null],[17,"LOG_SYSLOG","","",null,null],[17,"LOG_LPR","","",null,null],[17,"LOG_NEWS","","",null,null],[17,"LOG_UUCP","","",null,null],[17,"LOG_LOCAL0","","",null,null],[17,"LOG_LOCAL1","","",null,null],[17,"LOG_LOCAL2","","",null,null],[17,"LOG_LOCAL3","","",null,null],[17,"LOG_LOCAL4","","",null,null],[17,"LOG_LOCAL5","","",null,null],[17,"LOG_LOCAL6","","",null,null],[17,"LOG_LOCAL7","","",null,null],[17,"LOG_PID","","",null,null],[17,"LOG_CONS","","",null,null],[17,"LOG_ODELAY","","",null,null],[17,"LOG_NDELAY","","",null,null],[17,"LOG_NOWAIT","","",null,null],[17,"LOG_PRIMASK","","",null,null],[17,"LOG_FACMASK","","",null,null],[17,"PRIO_PROCESS","","",null,null],[17,"PRIO_PGRP","","",null,null],[17,"PRIO_USER","","",null,null],[17,"PRIO_MIN","","",null,null],[17,"PRIO_MAX","","",null,null],[17,"IPPROTO_ICMP","","",null,null],[17,"IPPROTO_ICMPV6","","",null,null],[17,"IPPROTO_TCP","","",null,null],[17,"IPPROTO_UDP","","",null,null],[17,"IPPROTO_IP","","",null,null],[17,"IPPROTO_IPV6","","",null,null],[17,"INADDR_LOOPBACK","","",null,null],[17,"INADDR_ANY","","",null,null],[17,"INADDR_BROADCAST","","",null,null],[17,"INADDR_NONE","","",null,null],[11,"clone","libc","",0,{"i":[{"n":"self"}],"o":{"n":"group"}}],[11,"clone","","",1,{"i":[{"n":"self"}],"o":{"n":"utimbuf"}}],[11,"clone","","",2,{"i":[{"n":"self"}],"o":{"n":"timeval"}}],[11,"clone","","",3,{"i":[{"n":"self"}],"o":{"n":"timespec"}}],[11,"clone","","",4,{"i":[{"n":"self"}],"o":{"n":"rlimit"}}],[11,"clone","","",5,{"i":[{"n":"self"}],"o":{"n":"rusage"}}],[11,"clone","","",6,{"i":[{"n":"self"}],"o":{"n":"in_addr"}}],[11,"clone","","",7,{"i":[{"n":"self"}],"o":{"n":"in6_addr"}}],[11,"clone","","",8,{"i":[{"n":"self"}],"o":{"n":"ip_mreq"}}],[11,"clone","","",9,{"i":[{"n":"self"}],"o":{"n":"ipv6_mreq"}}],[11,"clone","","",10,{"i":[{"n":"self"}],"o":{"n":"hostent"}}],[11,"clone","","",11,{"i":[{"n":"self"}],"o":{"n":"iovec"}}],[11,"clone","","",12,{"i":[{"n":"self"}],"o":{"n":"pollfd"}}],[11,"clone","","",13,{"i":[{"n":"self"}],"o":{"n":"winsize"}}],[11,"clone","","",14,{"i":[{"n":"self"}],"o":{"n":"linger"}}],[11,"clone","","",15,{"i":[{"n":"self"}],"o":{"n":"sigval"}}],[11,"clone","","",16,{"i":[{"n":"self"}],"o":{"n":"itimerval"}}],[11,"clone","","",17,{"i":[{"n":"self"}],"o":{"n":"tms"}}],[11,"clone","","",18,{"i":[{"n":"self"}],"o":{"n":"servent"}}],[11,"clone","","",19,{"i":[{"n":"self"}],"o":{"n":"protoent"}}],[6,"int8_t","","",null,null],[6,"int16_t","","",null,null],[6,"int32_t","","",null,null],[6,"int64_t","","",null,null],[6,"uint8_t","","",null,null],[6,"uint16_t","","",null,null],[6,"uint32_t","","",null,null],[6,"uint64_t","","",null,null],[6,"c_schar","","",null,null],[6,"c_uchar","","",null,null],[6,"c_short","","",null,null],[6,"c_ushort","","",null,null],[6,"c_int","","",null,null],[6,"c_uint","","",null,null],[6,"c_float","","",null,null],[6,"c_double","","",null,null],[6,"c_longlong","","",null,null],[6,"c_ulonglong","","",null,null],[6,"intmax_t","","",null,null],[6,"uintmax_t","","",null,null],[6,"size_t","","",null,null],[6,"ptrdiff_t","","",null,null],[6,"intptr_t","","",null,null],[6,"uintptr_t","","",null,null],[6,"ssize_t","","",null,null],[6,"pid_t","","",null,null],[6,"uid_t","","",null,null],[6,"gid_t","","",null,null],[6,"in_addr_t","","",null,null],[6,"in_port_t","","",null,null],[6,"sighandler_t","","",null,null],[6,"cc_t","","",null,null],[6,"sa_family_t","","",null,null],[6,"pthread_key_t","","",null,null],[6,"speed_t","","",null,null],[6,"tcflag_t","","",null,null],[6,"clockid_t","","",null,null],[6,"key_t","","",null,null],[6,"id_t","","",null,null],[6,"useconds_t","","",null,null],[6,"dev_t","","",null,null],[6,"socklen_t","","",null,null],[6,"pthread_t","","",null,null],[6,"mode_t","","",null,null],[6,"ino64_t","","",null,null],[6,"off64_t","","",null,null],[6,"blkcnt64_t","","",null,null],[6,"rlim64_t","","",null,null],[6,"mqd_t","","",null,null],[6,"nfds_t","","",null,null],[6,"nl_item","","",null,null],[6,"idtype_t","","",null,null],[6,"loff_t","","",null,null],[6,"__u8","","",null,null],[6,"__u16","","",null,null],[6,"__s16","","",null,null],[6,"__u32","","",null,null],[6,"__s32","","",null,null],[6,"Elf32_Half","","",null,null],[6,"Elf32_Word","","",null,null],[6,"Elf32_Off","","",null,null],[6,"Elf32_Addr","","",null,null],[6,"Elf64_Half","","",null,null],[6,"Elf64_Word","","",null,null],[6,"Elf64_Off","","",null,null],[6,"Elf64_Addr","","",null,null],[6,"Elf64_Xword","","",null,null],[6,"__priority_which_t","","",null,null],[6,"clock_t","","",null,null],[6,"time_t","","",null,null],[6,"ino_t","","",null,null],[6,"off_t","","",null,null],[6,"blkcnt_t","","",null,null],[6,"__fsword_t","","",null,null],[6,"shmatt_t","","",null,null],[6,"msgqnum_t","","",null,null],[6,"msglen_t","","",null,null],[6,"fsblkcnt_t","","",null,null],[6,"fsfilcnt_t","","",null,null],[6,"rlim_t","","",null,null],[6,"c_char","","",null,null],[6,"wchar_t","","",null,null],[6,"nlink_t","","",null,null],[6,"blksize_t","","",null,null],[6,"greg_t","","",null,null],[6,"suseconds_t","","",null,null],[6,"__u64","","",null,null],[6,"c_long","","",null,null],[6,"c_ulong","","",null,null],[17,"INT_MIN","","",null,null],[17,"INT_MAX","","",null,null],[17,"SIG_DFL","","",null,null],[17,"SIG_IGN","","",null,null],[17,"SIG_ERR","","",null,null],[17,"DT_UNKNOWN","","",null,null],[17,"DT_FIFO","","",null,null],[17,"DT_CHR","","",null,null],[17,"DT_DIR","","",null,null],[17,"DT_BLK","","",null,null],[17,"DT_REG","","",null,null],[17,"DT_LNK","","",null,null],[17,"DT_SOCK","","",null,null],[17,"FD_CLOEXEC","","",null,null],[17,"USRQUOTA","","",null,null],[17,"GRPQUOTA","","",null,null],[17,"SIGIOT","","",null,null],[17,"S_ISUID","","",null,null],[17,"S_ISGID","","",null,null],[17,"S_ISVTX","","",null,null],[17,"IF_NAMESIZE","","",null,null],[17,"IFNAMSIZ","","",null,null],[17,"LOG_EMERG","","",null,null],[17,"LOG_ALERT","","",null,null],[17,"LOG_CRIT","","",null,null],[17,"LOG_ERR","","",null,null],[17,"LOG_WARNING","","",null,null],[17,"LOG_NOTICE","","",null,null],[17,"LOG_INFO","","",null,null],[17,"LOG_DEBUG","","",null,null],[17,"LOG_KERN","","",null,null],[17,"LOG_USER","","",null,null],[17,"LOG_MAIL","","",null,null],[17,"LOG_DAEMON","","",null,null],[17,"LOG_AUTH","","",null,null],[17,"LOG_SYSLOG","","",null,null],[17,"LOG_LPR","","",null,null],[17,"LOG_NEWS","","",null,null],[17,"LOG_UUCP","","",null,null],[17,"LOG_LOCAL0","","",null,null],[17,"LOG_LOCAL1","","",null,null],[17,"LOG_LOCAL2","","",null,null],[17,"LOG_LOCAL3","","",null,null],[17,"LOG_LOCAL4","","",null,null],[17,"LOG_LOCAL5","","",null,null],[17,"LOG_LOCAL6","","",null,null],[17,"LOG_LOCAL7","","",null,null],[17,"LOG_PID","","",null,null],[17,"LOG_CONS","","",null,null],[17,"LOG_ODELAY","","",null,null],[17,"LOG_NDELAY","","",null,null],[17,"LOG_NOWAIT","","",null,null],[17,"LOG_PRIMASK","","",null,null],[17,"LOG_FACMASK","","",null,null],[17,"PRIO_PROCESS","","",null,null],[17,"PRIO_PGRP","","",null,null],[17,"PRIO_USER","","",null,null],[17,"PRIO_MIN","","",null,null],[17,"PRIO_MAX","","",null,null],[17,"IPPROTO_ICMP","","",null,null],[17,"IPPROTO_ICMPV6","","",null,null],[17,"IPPROTO_TCP","","",null,null],[17,"IPPROTO_UDP","","",null,null],[17,"IPPROTO_IP","","",null,null],[17,"IPPROTO_IPV6","","",null,null],[17,"INADDR_LOOPBACK","","",null,null],[17,"INADDR_ANY","","",null,null],[17,"INADDR_BROADCAST","","",null,null],[17,"INADDR_NONE","","",null,null],[17,"EXIT_FAILURE","","",null,null],[17,"EXIT_SUCCESS","","",null,null],[17,"RAND_MAX","","",null,null],[17,"EOF","","",null,null],[17,"SEEK_SET","","",null,null],[17,"SEEK_CUR","","",null,null],[17,"SEEK_END","","",null,null],[17,"_IOFBF","","",null,null],[17,"_IONBF","","",null,null],[17,"_IOLBF","","",null,null],[17,"F_DUPFD","","",null,null],[17,"F_GETFD","","",null,null],[17,"F_SETFD","","",null,null],[17,"F_GETFL","","",null,null],[17,"F_SETFL","","",null,null],[17,"F_SETLEASE","","",null,null],[17,"F_GETLEASE","","",null,null],[17,"F_NOTIFY","","",null,null],[17,"F_CANCELLK","","",null,null],[17,"F_DUPFD_CLOEXEC","","",null,null],[17,"F_SETPIPE_SZ","","",null,null],[17,"F_GETPIPE_SZ","","",null,null],[17,"F_ADD_SEALS","","",null,null],[17,"F_GET_SEALS","","",null,null],[17,"F_SEAL_SEAL","","",null,null],[17,"F_SEAL_SHRINK","","",null,null],[17,"F_SEAL_GROW","","",null,null],[17,"F_SEAL_WRITE","","",null,null],[17,"SIGTRAP","","",null,null],[17,"PTHREAD_CREATE_JOINABLE","","",null,null],[17,"PTHREAD_CREATE_DETACHED","","",null,null],[17,"CLOCK_REALTIME","","",null,null],[17,"CLOCK_MONOTONIC","","",null,null],[17,"CLOCK_PROCESS_CPUTIME_ID","","",null,null],[17,"CLOCK_THREAD_CPUTIME_ID","","",null,null],[17,"CLOCK_MONOTONIC_RAW","","",null,null],[17,"CLOCK_REALTIME_COARSE","","",null,null],[17,"CLOCK_MONOTONIC_COARSE","","",null,null],[17,"CLOCK_BOOTTIME","","",null,null],[17,"CLOCK_REALTIME_ALARM","","",null,null],[17,"CLOCK_BOOTTIME_ALARM","","",null,null],[17,"TIMER_ABSTIME","","",null,null],[17,"RLIMIT_CPU","","",null,null],[17,"RLIMIT_FSIZE","","",null,null],[17,"RLIMIT_DATA","","",null,null],[17,"RLIMIT_STACK","","",null,null],[17,"RLIMIT_CORE","","",null,null],[17,"RLIMIT_LOCKS","","",null,null],[17,"RLIMIT_SIGPENDING","","",null,null],[17,"RLIMIT_MSGQUEUE","","",null,null],[17,"RLIMIT_NICE","","",null,null],[17,"RLIMIT_RTPRIO","","",null,null],[17,"RUSAGE_SELF","","",null,null],[17,"O_RDONLY","","",null,null],[17,"O_WRONLY","","",null,null],[17,"O_RDWR","","",null,null],[17,"SOCK_CLOEXEC","","",null,null],[17,"S_IFIFO","","",null,null],[17,"S_IFCHR","","",null,null],[17,"S_IFBLK","","",null,null],[17,"S_IFDIR","","",null,null],[17,"S_IFREG","","",null,null],[17,"S_IFLNK","","",null,null],[17,"S_IFSOCK","","",null,null],[17,"S_IFMT","","",null,null],[17,"S_IRWXU","","",null,null],[17,"S_IXUSR","","",null,null],[17,"S_IWUSR","","",null,null],[17,"S_IRUSR","","",null,null],[17,"S_IRWXG","","",null,null],[17,"S_IXGRP","","",null,null],[17,"S_IWGRP","","",null,null],[17,"S_IRGRP","","",null,null],[17,"S_IRWXO","","",null,null],[17,"S_IXOTH","","",null,null],[17,"S_IWOTH","","",null,null],[17,"S_IROTH","","",null,null],[17,"F_OK","","",null,null],[17,"R_OK","","",null,null],[17,"W_OK","","",null,null],[17,"X_OK","","",null,null],[17,"STDIN_FILENO","","",null,null],[17,"STDOUT_FILENO","","",null,null],[17,"STDERR_FILENO","","",null,null],[17,"SIGHUP","","",null,null],[17,"SIGINT","","",null,null],[17,"SIGQUIT","","",null,null],[17,"SIGILL","","",null,null],[17,"SIGABRT","","",null,null],[17,"SIGFPE","","",null,null],[17,"SIGKILL","","",null,null],[17,"SIGSEGV","","",null,null],[17,"SIGPIPE","","",null,null],[17,"SIGALRM","","",null,null],[17,"SIGTERM","","",null,null],[17,"PROT_NONE","","",null,null],[17,"PROT_READ","","",null,null],[17,"PROT_WRITE","","",null,null],[17,"PROT_EXEC","","",null,null],[17,"LC_CTYPE","","",null,null],[17,"LC_NUMERIC","","",null,null],[17,"LC_TIME","","",null,null],[17,"LC_COLLATE","","",null,null],[17,"LC_MONETARY","","",null,null],[17,"LC_MESSAGES","","",null,null],[17,"LC_ALL","","",null,null],[17,"LC_CTYPE_MASK","","",null,null],[17,"LC_NUMERIC_MASK","","",null,null],[17,"LC_TIME_MASK","","",null,null],[17,"LC_COLLATE_MASK","","",null,null],[17,"LC_MONETARY_MASK","","",null,null],[17,"LC_MESSAGES_MASK","","",null,null],[17,"MAP_FILE","","",null,null],[17,"MAP_SHARED","","",null,null],[17,"MAP_PRIVATE","","",null,null],[17,"MAP_FIXED","","",null,null],[17,"MAP_FAILED","","",null,null],[17,"MS_ASYNC","","",null,null],[17,"MS_INVALIDATE","","",null,null],[17,"MS_SYNC","","",null,null],[17,"MS_RDONLY","","",null,null],[17,"MS_NOSUID","","",null,null],[17,"MS_NODEV","","",null,null],[17,"MS_NOEXEC","","",null,null],[17,"MS_SYNCHRONOUS","","",null,null],[17,"MS_REMOUNT","","",null,null],[17,"MS_MANDLOCK","","",null,null],[17,"MS_DIRSYNC","","",null,null],[17,"MS_NOATIME","","",null,null],[17,"MS_NODIRATIME","","",null,null],[17,"MS_BIND","","",null,null],[17,"MS_MOVE","","",null,null],[17,"MS_REC","","",null,null],[17,"MS_SILENT","","",null,null],[17,"MS_POSIXACL","","",null,null],[17,"MS_UNBINDABLE","","",null,null],[17,"MS_PRIVATE","","",null,null],[17,"MS_SLAVE","","",null,null],[17,"MS_SHARED","","",null,null],[17,"MS_RELATIME","","",null,null],[17,"MS_KERNMOUNT","","",null,null],[17,"MS_I_VERSION","","",null,null],[17,"MS_STRICTATIME","","",null,null],[17,"MS_ACTIVE","","",null,null],[17,"MS_NOUSER","","",null,null],[17,"MS_MGC_VAL","","",null,null],[17,"MS_MGC_MSK","","",null,null],[17,"MS_RMT_MASK","","",null,null],[17,"EPERM","","",null,null],[17,"ENOENT","","",null,null],[17,"ESRCH","","",null,null],[17,"EINTR","","",null,null],[17,"EIO","","",null,null],[17,"ENXIO","","",null,null],[17,"E2BIG","","",null,null],[17,"ENOEXEC","","",null,null],[17,"EBADF","","",null,null],[17,"ECHILD","","",null,null],[17,"EAGAIN","","",null,null],[17,"ENOMEM","","",null,null],[17,"EACCES","","",null,null],[17,"EFAULT","","",null,null],[17,"ENOTBLK","","",null,null],[17,"EBUSY","","",null,null],[17,"EEXIST","","",null,null],[17,"EXDEV","","",null,null],[17,"ENODEV","","",null,null],[17,"ENOTDIR","","",null,null],[17,"EISDIR","","",null,null],[17,"EINVAL","","",null,null],[17,"ENFILE","","",null,null],[17,"EMFILE","","",null,null],[17,"ENOTTY","","",null,null],[17,"ETXTBSY","","",null,null],[17,"EFBIG","","",null,null],[17,"ENOSPC","","",null,null],[17,"ESPIPE","","",null,null],[17,"EROFS","","",null,null],[17,"EMLINK","","",null,null],[17,"EPIPE","","",null,null],[17,"EDOM","","",null,null],[17,"ERANGE","","",null,null],[17,"EWOULDBLOCK","","",null,null],[17,"SCM_RIGHTS","","",null,null],[17,"SCM_CREDENTIALS","","",null,null],[17,"PROT_GROWSDOWN","","",null,null],[17,"PROT_GROWSUP","","",null,null],[17,"MAP_TYPE","","",null,null],[17,"MADV_NORMAL","","",null,null],[17,"MADV_RANDOM","","",null,null],[17,"MADV_SEQUENTIAL","","",null,null],[17,"MADV_WILLNEED","","",null,null],[17,"MADV_DONTNEED","","",null,null],[17,"MADV_FREE","","",null,null],[17,"MADV_REMOVE","","",null,null],[17,"MADV_DONTFORK","","",null,null],[17,"MADV_DOFORK","","",null,null],[17,"MADV_MERGEABLE","","",null,null],[17,"MADV_UNMERGEABLE","","",null,null],[17,"MADV_HUGEPAGE","","",null,null],[17,"MADV_NOHUGEPAGE","","",null,null],[17,"MADV_DONTDUMP","","",null,null],[17,"MADV_DODUMP","","",null,null],[17,"MADV_HWPOISON","","",null,null],[17,"MADV_SOFT_OFFLINE","","",null,null],[17,"IFF_UP","","",null,null],[17,"IFF_BROADCAST","","",null,null],[17,"IFF_DEBUG","","",null,null],[17,"IFF_LOOPBACK","","",null,null],[17,"IFF_POINTOPOINT","","",null,null],[17,"IFF_NOTRAILERS","","",null,null],[17,"IFF_RUNNING","","",null,null],[17,"IFF_NOARP","","",null,null],[17,"IFF_PROMISC","","",null,null],[17,"IFF_ALLMULTI","","",null,null],[17,"IFF_MASTER","","",null,null],[17,"IFF_SLAVE","","",null,null],[17,"IFF_MULTICAST","","",null,null],[17,"IFF_PORTSEL","","",null,null],[17,"IFF_AUTOMEDIA","","",null,null],[17,"IFF_DYNAMIC","","",null,null],[17,"SOL_IP","","",null,null],[17,"SOL_TCP","","",null,null],[17,"SOL_UDP","","",null,null],[17,"SOL_IPV6","","",null,null],[17,"SOL_ICMPV6","","",null,null],[17,"SOL_RAW","","",null,null],[17,"SOL_DECNET","","",null,null],[17,"SOL_X25","","",null,null],[17,"SOL_PACKET","","",null,null],[17,"SOL_ATM","","",null,null],[17,"SOL_AAL","","",null,null],[17,"SOL_IRDA","","",null,null],[17,"SOL_NETBEUI","","",null,null],[17,"SOL_LLC","","",null,null],[17,"SOL_DCCP","","",null,null],[17,"SOL_NETLINK","","",null,null],[17,"SOL_TIPC","","",null,null],[17,"AF_UNSPEC","","",null,null],[17,"AF_UNIX","","",null,null],[17,"AF_LOCAL","","",null,null],[17,"AF_INET","","",null,null],[17,"AF_AX25","","",null,null],[17,"AF_IPX","","",null,null],[17,"AF_APPLETALK","","",null,null],[17,"AF_NETROM","","",null,null],[17,"AF_BRIDGE","","",null,null],[17,"AF_ATMPVC","","",null,null],[17,"AF_X25","","",null,null],[17,"AF_INET6","","",null,null],[17,"AF_ROSE","","",null,null],[17,"AF_DECnet","","",null,null],[17,"AF_NETBEUI","","",null,null],[17,"AF_SECURITY","","",null,null],[17,"AF_KEY","","",null,null],[17,"AF_NETLINK","","",null,null],[17,"AF_ROUTE","","",null,null],[17,"AF_PACKET","","",null,null],[17,"AF_ASH","","",null,null],[17,"AF_ECONET","","",null,null],[17,"AF_ATMSVC","","",null,null],[17,"AF_RDS","","",null,null],[17,"AF_SNA","","",null,null],[17,"AF_IRDA","","",null,null],[17,"AF_PPPOX","","",null,null],[17,"AF_WANPIPE","","",null,null],[17,"AF_LLC","","",null,null],[17,"AF_CAN","","",null,null],[17,"AF_TIPC","","",null,null],[17,"AF_BLUETOOTH","","",null,null],[17,"AF_IUCV","","",null,null],[17,"AF_RXRPC","","",null,null],[17,"AF_ISDN","","",null,null],[17,"AF_PHONET","","",null,null],[17,"AF_IEEE802154","","",null,null],[17,"AF_CAIF","","",null,null],[17,"AF_ALG","","",null,null],[17,"PF_UNSPEC","","",null,null],[17,"PF_UNIX","","",null,null],[17,"PF_LOCAL","","",null,null],[17,"PF_INET","","",null,null],[17,"PF_AX25","","",null,null],[17,"PF_IPX","","",null,null],[17,"PF_APPLETALK","","",null,null],[17,"PF_NETROM","","",null,null],[17,"PF_BRIDGE","","",null,null],[17,"PF_ATMPVC","","",null,null],[17,"PF_X25","","",null,null],[17,"PF_INET6","","",null,null],[17,"PF_ROSE","","",null,null],[17,"PF_DECnet","","",null,null],[17,"PF_NETBEUI","","",null,null],[17,"PF_SECURITY","","",null,null],[17,"PF_KEY","","",null,null],[17,"PF_NETLINK","","",null,null],[17,"PF_ROUTE","","",null,null],[17,"PF_PACKET","","",null,null],[17,"PF_ASH","","",null,null],[17,"PF_ECONET","","",null,null],[17,"PF_ATMSVC","","",null,null],[17,"PF_RDS","","",null,null],[17,"PF_SNA","","",null,null],[17,"PF_IRDA","","",null,null],[17,"PF_PPPOX","","",null,null],[17,"PF_WANPIPE","","",null,null],[17,"PF_LLC","","",null,null],[17,"PF_CAN","","",null,null],[17,"PF_TIPC","","",null,null],[17,"PF_BLUETOOTH","","",null,null],[17,"PF_IUCV","","",null,null],[17,"PF_RXRPC","","",null,null],[17,"PF_ISDN","","",null,null],[17,"PF_PHONET","","",null,null],[17,"PF_IEEE802154","","",null,null],[17,"PF_CAIF","","",null,null],[17,"PF_ALG","","",null,null],[17,"SOMAXCONN","","",null,null],[17,"MSG_OOB","","",null,null],[17,"MSG_PEEK","","",null,null],[17,"MSG_DONTROUTE","","",null,null],[17,"MSG_CTRUNC","","",null,null],[17,"MSG_TRUNC","","",null,null],[17,"MSG_DONTWAIT","","",null,null],[17,"MSG_EOR","","",null,null],[17,"MSG_WAITALL","","",null,null],[17,"MSG_FIN","","",null,null],[17,"MSG_SYN","","",null,null],[17,"MSG_CONFIRM","","",null,null],[17,"MSG_RST","","",null,null],[17,"MSG_ERRQUEUE","","",null,null],[17,"MSG_NOSIGNAL","","",null,null],[17,"MSG_MORE","","",null,null],[17,"MSG_WAITFORONE","","",null,null],[17,"MSG_FASTOPEN","","",null,null],[17,"MSG_CMSG_CLOEXEC","","",null,null],[17,"SCM_TIMESTAMP","","",null,null],[17,"SOCK_RAW","","",null,null],[17,"SOCK_RDM","","",null,null],[17,"IP_MULTICAST_IF","","",null,null],[17,"IP_MULTICAST_TTL","","",null,null],[17,"IP_MULTICAST_LOOP","","",null,null],[17,"IP_TTL","","",null,null],[17,"IP_HDRINCL","","",null,null],[17,"IP_ADD_MEMBERSHIP","","",null,null],[17,"IP_DROP_MEMBERSHIP","","",null,null],[17,"IP_TRANSPARENT","","",null,null],[17,"IPV6_UNICAST_HOPS","","",null,null],[17,"IPV6_MULTICAST_IF","","",null,null],[17,"IPV6_MULTICAST_HOPS","","",null,null],[17,"IPV6_MULTICAST_LOOP","","",null,null],[17,"IPV6_ADD_MEMBERSHIP","","",null,null],[17,"IPV6_DROP_MEMBERSHIP","","",null,null],[17,"IPV6_V6ONLY","","",null,null],[17,"TCP_NODELAY","","",null,null],[17,"TCP_MAXSEG","","",null,null],[17,"TCP_CORK","","",null,null],[17,"TCP_KEEPIDLE","","",null,null],[17,"TCP_KEEPINTVL","","",null,null],[17,"TCP_KEEPCNT","","",null,null],[17,"TCP_SYNCNT","","",null,null],[17,"TCP_LINGER2","","",null,null],[17,"TCP_DEFER_ACCEPT","","",null,null],[17,"TCP_WINDOW_CLAMP","","",null,null],[17,"TCP_INFO","","",null,null],[17,"TCP_QUICKACK","","",null,null],[17,"TCP_CONGESTION","","",null,null],[17,"SO_DEBUG","","",null,null],[17,"SHUT_RD","","",null,null],[17,"SHUT_WR","","",null,null],[17,"SHUT_RDWR","","",null,null],[17,"LOCK_SH","","",null,null],[17,"LOCK_EX","","",null,null],[17,"LOCK_NB","","",null,null],[17,"LOCK_UN","","",null,null],[17,"SS_ONSTACK","","",null,null],[17,"SS_DISABLE","","",null,null],[17,"PATH_MAX","","",null,null],[17,"FD_SETSIZE","","",null,null],[17,"EPOLLIN","","",null,null],[17,"EPOLLPRI","","",null,null],[17,"EPOLLOUT","","",null,null],[17,"EPOLLRDNORM","","",null,null],[17,"EPOLLRDBAND","","",null,null],[17,"EPOLLWRNORM","","",null,null],[17,"EPOLLWRBAND","","",null,null],[17,"EPOLLMSG","","",null,null],[17,"EPOLLERR","","",null,null],[17,"EPOLLHUP","","",null,null],[17,"EPOLLET","","",null,null],[17,"EPOLL_CTL_ADD","","",null,null],[17,"EPOLL_CTL_MOD","","",null,null],[17,"EPOLL_CTL_DEL","","",null,null],[17,"MNT_DETACH","","",null,null],[17,"MNT_EXPIRE","","",null,null],[17,"Q_GETFMT","","",null,null],[17,"Q_GETINFO","","",null,null],[17,"Q_SETINFO","","",null,null],[17,"QIF_BLIMITS","","",null,null],[17,"QIF_SPACE","","",null,null],[17,"QIF_ILIMITS","","",null,null],[17,"QIF_INODES","","",null,null],[17,"QIF_BTIME","","",null,null],[17,"QIF_ITIME","","",null,null],[17,"QIF_LIMITS","","",null,null],[17,"QIF_USAGE","","",null,null],[17,"QIF_TIMES","","",null,null],[17,"QIF_ALL","","",null,null],[17,"MNT_FORCE","","",null,null],[17,"Q_SYNC","","",null,null],[17,"Q_QUOTAON","","",null,null],[17,"Q_QUOTAOFF","","",null,null],[17,"Q_GETQUOTA","","",null,null],[17,"Q_SETQUOTA","","",null,null],[17,"TCIOFF","","",null,null],[17,"TCION","","",null,null],[17,"TCOOFF","","",null,null],[17,"TCOON","","",null,null],[17,"TCIFLUSH","","",null,null],[17,"TCOFLUSH","","",null,null],[17,"TCIOFLUSH","","",null,null],[17,"NL0","","",null,null],[17,"NL1","","",null,null],[17,"TAB0","","",null,null],[17,"CR0","","",null,null],[17,"FF0","","",null,null],[17,"BS0","","",null,null],[17,"VT0","","",null,null],[17,"VERASE","","",null,null],[17,"VKILL","","",null,null],[17,"VINTR","","",null,null],[17,"VQUIT","","",null,null],[17,"VLNEXT","","",null,null],[17,"IGNBRK","","",null,null],[17,"BRKINT","","",null,null],[17,"IGNPAR","","",null,null],[17,"PARMRK","","",null,null],[17,"INPCK","","",null,null],[17,"ISTRIP","","",null,null],[17,"INLCR","","",null,null],[17,"IGNCR","","",null,null],[17,"ICRNL","","",null,null],[17,"IXANY","","",null,null],[17,"IMAXBEL","","",null,null],[17,"OPOST","","",null,null],[17,"CS5","","",null,null],[17,"CRTSCTS","","",null,null],[17,"ECHO","","",null,null],[17,"OCRNL","","",null,null],[17,"ONOCR","","",null,null],[17,"ONLRET","","",null,null],[17,"OFILL","","",null,null],[17,"OFDEL","","",null,null],[17,"CLONE_VM","","",null,null],[17,"CLONE_FS","","",null,null],[17,"CLONE_FILES","","",null,null],[17,"CLONE_SIGHAND","","",null,null],[17,"CLONE_PTRACE","","",null,null],[17,"CLONE_VFORK","","",null,null],[17,"CLONE_PARENT","","",null,null],[17,"CLONE_THREAD","","",null,null],[17,"CLONE_NEWNS","","",null,null],[17,"CLONE_SYSVSEM","","",null,null],[17,"CLONE_SETTLS","","",null,null],[17,"CLONE_PARENT_SETTID","","",null,null],[17,"CLONE_CHILD_CLEARTID","","",null,null],[17,"CLONE_DETACHED","","",null,null],[17,"CLONE_UNTRACED","","",null,null],[17,"CLONE_CHILD_SETTID","","",null,null],[17,"CLONE_NEWUTS","","",null,null],[17,"CLONE_NEWIPC","","",null,null],[17,"CLONE_NEWUSER","","",null,null],[17,"CLONE_NEWPID","","",null,null],[17,"CLONE_NEWNET","","",null,null],[17,"CLONE_IO","","",null,null],[17,"CLONE_NEWCGROUP","","",null,null],[17,"WNOHANG","","",null,null],[17,"WUNTRACED","","",null,null],[17,"WSTOPPED","","",null,null],[17,"WEXITED","","",null,null],[17,"WCONTINUED","","",null,null],[17,"WNOWAIT","","",null,null],[17,"PTRACE_O_TRACESYSGOOD","","",null,null],[17,"PTRACE_O_TRACEFORK","","",null,null],[17,"PTRACE_O_TRACEVFORK","","",null,null],[17,"PTRACE_O_TRACECLONE","","",null,null],[17,"PTRACE_O_TRACEEXEC","","",null,null],[17,"PTRACE_O_TRACEVFORKDONE","","",null,null],[17,"PTRACE_O_TRACEEXIT","","",null,null],[17,"PTRACE_O_TRACESECCOMP","","",null,null],[17,"PTRACE_O_EXITKILL","","",null,null],[17,"PTRACE_O_SUSPEND_SECCOMP","","",null,null],[17,"PTRACE_O_MASK","","",null,null],[17,"PTRACE_EVENT_FORK","","",null,null],[17,"PTRACE_EVENT_VFORK","","",null,null],[17,"PTRACE_EVENT_CLONE","","",null,null],[17,"PTRACE_EVENT_EXEC","","",null,null],[17,"PTRACE_EVENT_VFORK_DONE","","",null,null],[17,"PTRACE_EVENT_EXIT","","",null,null],[17,"PTRACE_EVENT_SECCOMP","","",null,null],[17,"__WNOTHREAD","","",null,null],[17,"__WALL","","",null,null],[17,"__WCLONE","","",null,null],[17,"SPLICE_F_MOVE","","",null,null],[17,"SPLICE_F_NONBLOCK","","",null,null],[17,"SPLICE_F_MORE","","",null,null],[17,"SPLICE_F_GIFT","","",null,null],[17,"RTLD_LOCAL","","",null,null],[17,"RTLD_LAZY","","",null,null],[17,"POSIX_FADV_NORMAL","","",null,null],[17,"POSIX_FADV_RANDOM","","",null,null],[17,"POSIX_FADV_SEQUENTIAL","","",null,null],[17,"POSIX_FADV_WILLNEED","","",null,null],[17,"AT_FDCWD","","",null,null],[17,"AT_SYMLINK_NOFOLLOW","","",null,null],[17,"AT_REMOVEDIR","","",null,null],[17,"AT_SYMLINK_FOLLOW","","",null,null],[17,"AT_NO_AUTOMOUNT","","",null,null],[17,"AT_EMPTY_PATH","","",null,null],[17,"LOG_CRON","","",null,null],[17,"LOG_AUTHPRIV","","",null,null],[17,"LOG_FTP","","",null,null],[17,"LOG_PERROR","","",null,null],[17,"PIPE_BUF","","",null,null],[17,"SI_LOAD_SHIFT","","",null,null],[17,"SIGEV_SIGNAL","","",null,null],[17,"SIGEV_NONE","","",null,null],[17,"SIGEV_THREAD","","",null,null],[17,"P_ALL","","",null,null],[17,"P_PID","","",null,null],[17,"P_PGID","","",null,null],[17,"UTIME_OMIT","","",null,null],[17,"UTIME_NOW","","",null,null],[17,"POLLIN","","",null,null],[17,"POLLPRI","","",null,null],[17,"POLLOUT","","",null,null],[17,"POLLERR","","",null,null],[17,"POLLHUP","","",null,null],[17,"POLLNVAL","","",null,null],[17,"POLLRDNORM","","",null,null],[17,"POLLRDBAND","","",null,null],[17,"ABDAY_1","","",null,null],[17,"ABDAY_2","","",null,null],[17,"ABDAY_3","","",null,null],[17,"ABDAY_4","","",null,null],[17,"ABDAY_5","","",null,null],[17,"ABDAY_6","","",null,null],[17,"ABDAY_7","","",null,null],[17,"DAY_1","","",null,null],[17,"DAY_2","","",null,null],[17,"DAY_3","","",null,null],[17,"DAY_4","","",null,null],[17,"DAY_5","","",null,null],[17,"DAY_6","","",null,null],[17,"DAY_7","","",null,null],[17,"ABMON_1","","",null,null],[17,"ABMON_2","","",null,null],[17,"ABMON_3","","",null,null],[17,"ABMON_4","","",null,null],[17,"ABMON_5","","",null,null],[17,"ABMON_6","","",null,null],[17,"ABMON_7","","",null,null],[17,"ABMON_8","","",null,null],[17,"ABMON_9","","",null,null],[17,"ABMON_10","","",null,null],[17,"ABMON_11","","",null,null],[17,"ABMON_12","","",null,null],[17,"MON_1","","",null,null],[17,"MON_2","","",null,null],[17,"MON_3","","",null,null],[17,"MON_4","","",null,null],[17,"MON_5","","",null,null],[17,"MON_6","","",null,null],[17,"MON_7","","",null,null],[17,"MON_8","","",null,null],[17,"MON_9","","",null,null],[17,"MON_10","","",null,null],[17,"MON_11","","",null,null],[17,"MON_12","","",null,null],[17,"AM_STR","","",null,null],[17,"PM_STR","","",null,null],[17,"D_T_FMT","","",null,null],[17,"D_FMT","","",null,null],[17,"T_FMT","","",null,null],[17,"T_FMT_AMPM","","",null,null],[17,"ERA","","",null,null],[17,"ERA_D_FMT","","",null,null],[17,"ALT_DIGITS","","",null,null],[17,"ERA_D_T_FMT","","",null,null],[17,"ERA_T_FMT","","",null,null],[17,"CODESET","","",null,null],[17,"CRNCYSTR","","",null,null],[17,"RUSAGE_THREAD","","",null,null],[17,"RUSAGE_CHILDREN","","",null,null],[17,"RADIXCHAR","","",null,null],[17,"THOUSEP","","",null,null],[17,"YESEXPR","","",null,null],[17,"NOEXPR","","",null,null],[17,"YESSTR","","",null,null],[17,"NOSTR","","",null,null],[17,"FILENAME_MAX","","",null,null],[17,"L_tmpnam","","",null,null],[17,"_PC_LINK_MAX","","",null,null],[17,"_PC_MAX_CANON","","",null,null],[17,"_PC_MAX_INPUT","","",null,null],[17,"_PC_NAME_MAX","","",null,null],[17,"_PC_PATH_MAX","","",null,null],[17,"_PC_PIPE_BUF","","",null,null],[17,"_PC_CHOWN_RESTRICTED","","",null,null],[17,"_PC_NO_TRUNC","","",null,null],[17,"_PC_VDISABLE","","",null,null],[17,"_PC_SYNC_IO","","",null,null],[17,"_PC_ASYNC_IO","","",null,null],[17,"_PC_PRIO_IO","","",null,null],[17,"_PC_SOCK_MAXBUF","","",null,null],[17,"_PC_FILESIZEBITS","","",null,null],[17,"_PC_REC_INCR_XFER_SIZE","","",null,null],[17,"_PC_REC_MAX_XFER_SIZE","","",null,null],[17,"_PC_REC_MIN_XFER_SIZE","","",null,null],[17,"_PC_REC_XFER_ALIGN","","",null,null],[17,"_PC_ALLOC_SIZE_MIN","","",null,null],[17,"_PC_SYMLINK_MAX","","",null,null],[17,"_PC_2_SYMLINKS","","",null,null],[17,"_SC_ARG_MAX","","",null,null],[17,"_SC_CHILD_MAX","","",null,null],[17,"_SC_CLK_TCK","","",null,null],[17,"_SC_NGROUPS_MAX","","",null,null],[17,"_SC_OPEN_MAX","","",null,null],[17,"_SC_STREAM_MAX","","",null,null],[17,"_SC_TZNAME_MAX","","",null,null],[17,"_SC_JOB_CONTROL","","",null,null],[17,"_SC_SAVED_IDS","","",null,null],[17,"_SC_REALTIME_SIGNALS","","",null,null],[17,"_SC_PRIORITY_SCHEDULING","","",null,null],[17,"_SC_TIMERS","","",null,null],[17,"_SC_ASYNCHRONOUS_IO","","",null,null],[17,"_SC_PRIORITIZED_IO","","",null,null],[17,"_SC_SYNCHRONIZED_IO","","",null,null],[17,"_SC_FSYNC","","",null,null],[17,"_SC_MAPPED_FILES","","",null,null],[17,"_SC_MEMLOCK","","",null,null],[17,"_SC_MEMLOCK_RANGE","","",null,null],[17,"_SC_MEMORY_PROTECTION","","",null,null],[17,"_SC_MESSAGE_PASSING","","",null,null],[17,"_SC_SEMAPHORES","","",null,null],[17,"_SC_SHARED_MEMORY_OBJECTS","","",null,null],[17,"_SC_AIO_LISTIO_MAX","","",null,null],[17,"_SC_AIO_MAX","","",null,null],[17,"_SC_AIO_PRIO_DELTA_MAX","","",null,null],[17,"_SC_DELAYTIMER_MAX","","",null,null],[17,"_SC_MQ_OPEN_MAX","","",null,null],[17,"_SC_MQ_PRIO_MAX","","",null,null],[17,"_SC_VERSION","","",null,null],[17,"_SC_PAGESIZE","","",null,null],[17,"_SC_PAGE_SIZE","","",null,null],[17,"_SC_RTSIG_MAX","","",null,null],[17,"_SC_SEM_NSEMS_MAX","","",null,null],[17,"_SC_SEM_VALUE_MAX","","",null,null],[17,"_SC_SIGQUEUE_MAX","","",null,null],[17,"_SC_TIMER_MAX","","",null,null],[17,"_SC_BC_BASE_MAX","","",null,null],[17,"_SC_BC_DIM_MAX","","",null,null],[17,"_SC_BC_SCALE_MAX","","",null,null],[17,"_SC_BC_STRING_MAX","","",null,null],[17,"_SC_COLL_WEIGHTS_MAX","","",null,null],[17,"_SC_EXPR_NEST_MAX","","",null,null],[17,"_SC_LINE_MAX","","",null,null],[17,"_SC_RE_DUP_MAX","","",null,null],[17,"_SC_2_VERSION","","",null,null],[17,"_SC_2_C_BIND","","",null,null],[17,"_SC_2_C_DEV","","",null,null],[17,"_SC_2_FORT_DEV","","",null,null],[17,"_SC_2_FORT_RUN","","",null,null],[17,"_SC_2_SW_DEV","","",null,null],[17,"_SC_2_LOCALEDEF","","",null,null],[17,"_SC_UIO_MAXIOV","","",null,null],[17,"_SC_IOV_MAX","","",null,null],[17,"_SC_THREADS","","",null,null],[17,"_SC_THREAD_SAFE_FUNCTIONS","","",null,null],[17,"_SC_GETGR_R_SIZE_MAX","","",null,null],[17,"_SC_GETPW_R_SIZE_MAX","","",null,null],[17,"_SC_LOGIN_NAME_MAX","","",null,null],[17,"_SC_TTY_NAME_MAX","","",null,null],[17,"_SC_THREAD_DESTRUCTOR_ITERATIONS","","",null,null],[17,"_SC_THREAD_KEYS_MAX","","",null,null],[17,"_SC_THREAD_STACK_MIN","","",null,null],[17,"_SC_THREAD_THREADS_MAX","","",null,null],[17,"_SC_THREAD_ATTR_STACKADDR","","",null,null],[17,"_SC_THREAD_ATTR_STACKSIZE","","",null,null],[17,"_SC_THREAD_PRIORITY_SCHEDULING","","",null,null],[17,"_SC_THREAD_PRIO_INHERIT","","",null,null],[17,"_SC_THREAD_PRIO_PROTECT","","",null,null],[17,"_SC_THREAD_PROCESS_SHARED","","",null,null],[17,"_SC_NPROCESSORS_CONF","","",null,null],[17,"_SC_NPROCESSORS_ONLN","","",null,null],[17,"_SC_PHYS_PAGES","","",null,null],[17,"_SC_AVPHYS_PAGES","","",null,null],[17,"_SC_ATEXIT_MAX","","",null,null],[17,"_SC_PASS_MAX","","",null,null],[17,"_SC_XOPEN_VERSION","","",null,null],[17,"_SC_XOPEN_XCU_VERSION","","",null,null],[17,"_SC_XOPEN_UNIX","","",null,null],[17,"_SC_XOPEN_CRYPT","","",null,null],[17,"_SC_XOPEN_ENH_I18N","","",null,null],[17,"_SC_XOPEN_SHM","","",null,null],[17,"_SC_2_CHAR_TERM","","",null,null],[17,"_SC_2_UPE","","",null,null],[17,"_SC_XOPEN_XPG2","","",null,null],[17,"_SC_XOPEN_XPG3","","",null,null],[17,"_SC_XOPEN_XPG4","","",null,null],[17,"_SC_NZERO","","",null,null],[17,"_SC_XBS5_ILP32_OFF32","","",null,null],[17,"_SC_XBS5_ILP32_OFFBIG","","",null,null],[17,"_SC_XBS5_LP64_OFF64","","",null,null],[17,"_SC_XBS5_LPBIG_OFFBIG","","",null,null],[17,"_SC_XOPEN_LEGACY","","",null,null],[17,"_SC_XOPEN_REALTIME","","",null,null],[17,"_SC_XOPEN_REALTIME_THREADS","","",null,null],[17,"_SC_ADVISORY_INFO","","",null,null],[17,"_SC_BARRIERS","","",null,null],[17,"_SC_CLOCK_SELECTION","","",null,null],[17,"_SC_CPUTIME","","",null,null],[17,"_SC_THREAD_CPUTIME","","",null,null],[17,"_SC_MONOTONIC_CLOCK","","",null,null],[17,"_SC_READER_WRITER_LOCKS","","",null,null],[17,"_SC_SPIN_LOCKS","","",null,null],[17,"_SC_REGEXP","","",null,null],[17,"_SC_SHELL","","",null,null],[17,"_SC_SPAWN","","",null,null],[17,"_SC_SPORADIC_SERVER","","",null,null],[17,"_SC_THREAD_SPORADIC_SERVER","","",null,null],[17,"_SC_TIMEOUTS","","",null,null],[17,"_SC_TYPED_MEMORY_OBJECTS","","",null,null],[17,"_SC_2_PBS","","",null,null],[17,"_SC_2_PBS_ACCOUNTING","","",null,null],[17,"_SC_2_PBS_LOCATE","","",null,null],[17,"_SC_2_PBS_MESSAGE","","",null,null],[17,"_SC_2_PBS_TRACK","","",null,null],[17,"_SC_SYMLOOP_MAX","","",null,null],[17,"_SC_STREAMS","","",null,null],[17,"_SC_2_PBS_CHECKPOINT","","",null,null],[17,"_SC_V6_ILP32_OFF32","","",null,null],[17,"_SC_V6_ILP32_OFFBIG","","",null,null],[17,"_SC_V6_LP64_OFF64","","",null,null],[17,"_SC_V6_LPBIG_OFFBIG","","",null,null],[17,"_SC_HOST_NAME_MAX","","",null,null],[17,"_SC_TRACE","","",null,null],[17,"_SC_TRACE_EVENT_FILTER","","",null,null],[17,"_SC_TRACE_INHERIT","","",null,null],[17,"_SC_TRACE_LOG","","",null,null],[17,"_SC_IPV6","","",null,null],[17,"_SC_RAW_SOCKETS","","",null,null],[17,"_SC_V7_ILP32_OFF32","","",null,null],[17,"_SC_V7_ILP32_OFFBIG","","",null,null],[17,"_SC_V7_LP64_OFF64","","",null,null],[17,"_SC_V7_LPBIG_OFFBIG","","",null,null],[17,"_SC_SS_REPL_MAX","","",null,null],[17,"_SC_TRACE_EVENT_NAME_MAX","","",null,null],[17,"_SC_TRACE_NAME_MAX","","",null,null],[17,"_SC_TRACE_SYS_MAX","","",null,null],[17,"_SC_TRACE_USER_EVENT_MAX","","",null,null],[17,"_SC_XOPEN_STREAMS","","",null,null],[17,"_SC_THREAD_ROBUST_PRIO_INHERIT","","",null,null],[17,"_SC_THREAD_ROBUST_PRIO_PROTECT","","",null,null],[17,"RLIM_SAVED_MAX","","",null,null],[17,"RLIM_SAVED_CUR","","",null,null],[17,"GLOB_ERR","","",null,null],[17,"GLOB_MARK","","",null,null],[17,"GLOB_NOSORT","","",null,null],[17,"GLOB_DOOFFS","","",null,null],[17,"GLOB_NOCHECK","","",null,null],[17,"GLOB_APPEND","","",null,null],[17,"GLOB_NOESCAPE","","",null,null],[17,"GLOB_NOSPACE","","",null,null],[17,"GLOB_ABORTED","","",null,null],[17,"GLOB_NOMATCH","","",null,null],[17,"POSIX_MADV_NORMAL","","",null,null],[17,"POSIX_MADV_RANDOM","","",null,null],[17,"POSIX_MADV_SEQUENTIAL","","",null,null],[17,"POSIX_MADV_WILLNEED","","",null,null],[17,"S_IEXEC","","",null,null],[17,"S_IWRITE","","",null,null],[17,"S_IREAD","","",null,null],[17,"F_LOCK","","",null,null],[17,"F_TEST","","",null,null],[17,"F_TLOCK","","",null,null],[17,"F_ULOCK","","",null,null],[17,"IFF_LOWER_UP","","",null,null],[17,"IFF_DORMANT","","",null,null],[17,"IFF_ECHO","","",null,null],[17,"IFF_TUN","","",null,null],[17,"IFF_TAP","","",null,null],[17,"IFF_NO_PI","","",null,null],[17,"TUN_READQ_SIZE","","",null,null],[17,"TUN_TUN_DEV","","",null,null],[17,"TUN_TAP_DEV","","",null,null],[17,"TUN_TYPE_MASK","","",null,null],[17,"IFF_ONE_QUEUE","","",null,null],[17,"IFF_VNET_HDR","","",null,null],[17,"IFF_TUN_EXCL","","",null,null],[17,"IFF_MULTI_QUEUE","","",null,null],[17,"IFF_ATTACH_QUEUE","","",null,null],[17,"IFF_DETACH_QUEUE","","",null,null],[17,"IFF_PERSIST","","",null,null],[17,"IFF_NOFILTER","","",null,null],[17,"ST_RDONLY","","",null,null],[17,"ST_NOSUID","","",null,null],[17,"ST_NODEV","","",null,null],[17,"ST_NOEXEC","","",null,null],[17,"ST_SYNCHRONOUS","","",null,null],[17,"ST_MANDLOCK","","",null,null],[17,"ST_WRITE","","",null,null],[17,"ST_APPEND","","",null,null],[17,"ST_IMMUTABLE","","",null,null],[17,"ST_NOATIME","","",null,null],[17,"ST_NODIRATIME","","",null,null],[17,"RTLD_NEXT","","",null,null],[17,"RTLD_DEFAULT","","",null,null],[17,"RTLD_NODELETE","","",null,null],[17,"RTLD_NOW","","",null,null],[17,"TCP_MD5SIG","","",null,null],[17,"PTHREAD_MUTEX_INITIALIZER","","",null,null],[17,"PTHREAD_COND_INITIALIZER","","",null,null],[17,"PTHREAD_RWLOCK_INITIALIZER","","",null,null],[17,"PTHREAD_MUTEX_NORMAL","","",null,null],[17,"PTHREAD_MUTEX_RECURSIVE","","",null,null],[17,"PTHREAD_MUTEX_ERRORCHECK","","",null,null],[17,"PTHREAD_MUTEX_DEFAULT","","",null,null],[17,"PTHREAD_PROCESS_PRIVATE","","",null,null],[17,"PTHREAD_PROCESS_SHARED","","",null,null],[17,"__SIZEOF_PTHREAD_COND_T","","",null,null],[17,"RENAME_NOREPLACE","","",null,null],[17,"RENAME_EXCHANGE","","",null,null],[17,"RENAME_WHITEOUT","","",null,null],[17,"SCHED_OTHER","","",null,null],[17,"SCHED_FIFO","","",null,null],[17,"SCHED_RR","","",null,null],[17,"SCHED_BATCH","","",null,null],[17,"SCHED_IDLE","","",null,null],[17,"IPPROTO_HOPOPTS","","Hop-by-hop option header",null,null],[17,"IPPROTO_IGMP","","group mgmt protocol",null,null],[17,"IPPROTO_IPIP","","for compatibility",null,null],[17,"IPPROTO_EGP","","exterior gateway protocol",null,null],[17,"IPPROTO_PUP","","pup",null,null],[17,"IPPROTO_IDP","","xns idp",null,null],[17,"IPPROTO_TP","","tp-4 w/ class negotiation",null,null],[17,"IPPROTO_DCCP","","DCCP",null,null],[17,"IPPROTO_ROUTING","","IP6 routing header",null,null],[17,"IPPROTO_FRAGMENT","","IP6 fragmentation header",null,null],[17,"IPPROTO_RSVP","","resource reservation",null,null],[17,"IPPROTO_GRE","","General Routing Encap.",null,null],[17,"IPPROTO_ESP","","IP6 Encap Sec. Payload",null,null],[17,"IPPROTO_AH","","IP6 Auth Header",null,null],[17,"IPPROTO_NONE","","IP6 no next header",null,null],[17,"IPPROTO_DSTOPTS","","IP6 destination option",null,null],[17,"IPPROTO_MTP","","",null,null],[17,"IPPROTO_BEETPH","","",null,null],[17,"IPPROTO_ENCAP","","encapsulation header",null,null],[17,"IPPROTO_PIM","","Protocol indep. multicast",null,null],[17,"IPPROTO_COMP","","IP Payload Comp. Protocol",null,null],[17,"IPPROTO_SCTP","","SCTP",null,null],[17,"IPPROTO_MH","","",null,null],[17,"IPPROTO_UDPLITE","","",null,null],[17,"IPPROTO_MPLS","","",null,null],[17,"IPPROTO_RAW","","raw IP packet",null,null],[17,"IPPROTO_MAX","","",null,null],[17,"AF_IB","","",null,null],[17,"AF_MPLS","","",null,null],[17,"AF_NFC","","",null,null],[17,"AF_VSOCK","","",null,null],[17,"PF_IB","","",null,null],[17,"PF_MPLS","","",null,null],[17,"PF_NFC","","",null,null],[17,"PF_VSOCK","","",null,null],[17,"IPC_PRIVATE","","",null,null],[17,"IPC_CREAT","","",null,null],[17,"IPC_EXCL","","",null,null],[17,"IPC_NOWAIT","","",null,null],[17,"IPC_RMID","","",null,null],[17,"IPC_SET","","",null,null],[17,"IPC_STAT","","",null,null],[17,"IPC_INFO","","",null,null],[17,"MSG_STAT","","",null,null],[17,"MSG_INFO","","",null,null],[17,"MSG_NOERROR","","",null,null],[17,"MSG_EXCEPT","","",null,null],[17,"MSG_COPY","","",null,null],[17,"SHM_R","","",null,null],[17,"SHM_W","","",null,null],[17,"SHM_RDONLY","","",null,null],[17,"SHM_RND","","",null,null],[17,"SHM_REMAP","","",null,null],[17,"SHM_EXEC","","",null,null],[17,"SHM_LOCK","","",null,null],[17,"SHM_UNLOCK","","",null,null],[17,"SHM_HUGETLB","","",null,null],[17,"SHM_NORESERVE","","",null,null],[17,"EPOLLRDHUP","","",null,null],[17,"EPOLLEXCLUSIVE","","",null,null],[17,"EPOLLONESHOT","","",null,null],[17,"QFMT_VFS_OLD","","",null,null],[17,"QFMT_VFS_V0","","",null,null],[17,"QFMT_VFS_V1","","",null,null],[17,"EFD_SEMAPHORE","","",null,null],[17,"LOG_NFACILITIES","","",null,null],[17,"SEM_FAILED","","",null,null],[17,"RB_AUTOBOOT","","",null,null],[17,"RB_HALT_SYSTEM","","",null,null],[17,"RB_ENABLE_CAD","","",null,null],[17,"RB_DISABLE_CAD","","",null,null],[17,"RB_POWER_OFF","","",null,null],[17,"RB_SW_SUSPEND","","",null,null],[17,"RB_KEXEC","","",null,null],[17,"AI_PASSIVE","","",null,null],[17,"AI_CANONNAME","","",null,null],[17,"AI_NUMERICHOST","","",null,null],[17,"AI_V4MAPPED","","",null,null],[17,"AI_ALL","","",null,null],[17,"AI_ADDRCONFIG","","",null,null],[17,"AI_NUMERICSERV","","",null,null],[17,"EAI_BADFLAGS","","",null,null],[17,"EAI_NONAME","","",null,null],[17,"EAI_AGAIN","","",null,null],[17,"EAI_FAIL","","",null,null],[17,"EAI_NODATA","","",null,null],[17,"EAI_FAMILY","","",null,null],[17,"EAI_SOCKTYPE","","",null,null],[17,"EAI_SERVICE","","",null,null],[17,"EAI_MEMORY","","",null,null],[17,"EAI_SYSTEM","","",null,null],[17,"EAI_OVERFLOW","","",null,null],[17,"NI_NUMERICHOST","","",null,null],[17,"NI_NUMERICSERV","","",null,null],[17,"NI_NOFQDN","","",null,null],[17,"NI_NAMEREQD","","",null,null],[17,"NI_DGRAM","","",null,null],[17,"SYNC_FILE_RANGE_WAIT_BEFORE","","",null,null],[17,"SYNC_FILE_RANGE_WRITE","","",null,null],[17,"SYNC_FILE_RANGE_WAIT_AFTER","","",null,null],[17,"AIO_CANCELED","","",null,null],[17,"AIO_NOTCANCELED","","",null,null],[17,"AIO_ALLDONE","","",null,null],[17,"LIO_READ","","",null,null],[17,"LIO_WRITE","","",null,null],[17,"LIO_NOP","","",null,null],[17,"LIO_WAIT","","",null,null],[17,"LIO_NOWAIT","","",null,null],[17,"MREMAP_MAYMOVE","","",null,null],[17,"MREMAP_FIXED","","",null,null],[17,"PR_SET_PDEATHSIG","","",null,null],[17,"PR_GET_PDEATHSIG","","",null,null],[17,"PR_GET_DUMPABLE","","",null,null],[17,"PR_SET_DUMPABLE","","",null,null],[17,"PR_GET_UNALIGN","","",null,null],[17,"PR_SET_UNALIGN","","",null,null],[17,"PR_UNALIGN_NOPRINT","","",null,null],[17,"PR_UNALIGN_SIGBUS","","",null,null],[17,"PR_GET_KEEPCAPS","","",null,null],[17,"PR_SET_KEEPCAPS","","",null,null],[17,"PR_GET_FPEMU","","",null,null],[17,"PR_SET_FPEMU","","",null,null],[17,"PR_FPEMU_NOPRINT","","",null,null],[17,"PR_FPEMU_SIGFPE","","",null,null],[17,"PR_GET_FPEXC","","",null,null],[17,"PR_SET_FPEXC","","",null,null],[17,"PR_FP_EXC_SW_ENABLE","","",null,null],[17,"PR_FP_EXC_DIV","","",null,null],[17,"PR_FP_EXC_OVF","","",null,null],[17,"PR_FP_EXC_UND","","",null,null],[17,"PR_FP_EXC_RES","","",null,null],[17,"PR_FP_EXC_INV","","",null,null],[17,"PR_FP_EXC_DISABLED","","",null,null],[17,"PR_FP_EXC_NONRECOV","","",null,null],[17,"PR_FP_EXC_ASYNC","","",null,null],[17,"PR_FP_EXC_PRECISE","","",null,null],[17,"PR_GET_TIMING","","",null,null],[17,"PR_SET_TIMING","","",null,null],[17,"PR_TIMING_STATISTICAL","","",null,null],[17,"PR_TIMING_TIMESTAMP","","",null,null],[17,"PR_SET_NAME","","",null,null],[17,"PR_GET_NAME","","",null,null],[17,"PR_GET_ENDIAN","","",null,null],[17,"PR_SET_ENDIAN","","",null,null],[17,"PR_ENDIAN_BIG","","",null,null],[17,"PR_ENDIAN_LITTLE","","",null,null],[17,"PR_ENDIAN_PPC_LITTLE","","",null,null],[17,"PR_GET_SECCOMP","","",null,null],[17,"PR_SET_SECCOMP","","",null,null],[17,"PR_CAPBSET_READ","","",null,null],[17,"PR_CAPBSET_DROP","","",null,null],[17,"PR_GET_TSC","","",null,null],[17,"PR_SET_TSC","","",null,null],[17,"PR_TSC_ENABLE","","",null,null],[17,"PR_TSC_SIGSEGV","","",null,null],[17,"PR_GET_SECUREBITS","","",null,null],[17,"PR_SET_SECUREBITS","","",null,null],[17,"PR_SET_TIMERSLACK","","",null,null],[17,"PR_GET_TIMERSLACK","","",null,null],[17,"PR_TASK_PERF_EVENTS_DISABLE","","",null,null],[17,"PR_TASK_PERF_EVENTS_ENABLE","","",null,null],[17,"PR_MCE_KILL","","",null,null],[17,"PR_MCE_KILL_CLEAR","","",null,null],[17,"PR_MCE_KILL_SET","","",null,null],[17,"PR_MCE_KILL_LATE","","",null,null],[17,"PR_MCE_KILL_EARLY","","",null,null],[17,"PR_MCE_KILL_DEFAULT","","",null,null],[17,"PR_MCE_KILL_GET","","",null,null],[17,"PR_SET_MM","","",null,null],[17,"PR_SET_MM_START_CODE","","",null,null],[17,"PR_SET_MM_END_CODE","","",null,null],[17,"PR_SET_MM_START_DATA","","",null,null],[17,"PR_SET_MM_END_DATA","","",null,null],[17,"PR_SET_MM_START_STACK","","",null,null],[17,"PR_SET_MM_START_BRK","","",null,null],[17,"PR_SET_MM_BRK","","",null,null],[17,"PR_SET_MM_ARG_START","","",null,null],[17,"PR_SET_MM_ARG_END","","",null,null],[17,"PR_SET_MM_ENV_START","","",null,null],[17,"PR_SET_MM_ENV_END","","",null,null],[17,"PR_SET_MM_AUXV","","",null,null],[17,"PR_SET_MM_EXE_FILE","","",null,null],[17,"PR_SET_MM_MAP","","",null,null],[17,"PR_SET_MM_MAP_SIZE","","",null,null],[17,"PR_SET_PTRACER","","",null,null],[17,"PR_SET_CHILD_SUBREAPER","","",null,null],[17,"PR_GET_CHILD_SUBREAPER","","",null,null],[17,"PR_SET_NO_NEW_PRIVS","","",null,null],[17,"PR_GET_NO_NEW_PRIVS","","",null,null],[17,"PR_GET_TID_ADDRESS","","",null,null],[17,"PR_SET_THP_DISABLE","","",null,null],[17,"PR_GET_THP_DISABLE","","",null,null],[17,"PR_MPX_ENABLE_MANAGEMENT","","",null,null],[17,"PR_MPX_DISABLE_MANAGEMENT","","",null,null],[17,"PR_SET_FP_MODE","","",null,null],[17,"PR_GET_FP_MODE","","",null,null],[17,"PR_FP_MODE_FR","","",null,null],[17,"PR_FP_MODE_FRE","","",null,null],[17,"PR_CAP_AMBIENT","","",null,null],[17,"PR_CAP_AMBIENT_IS_SET","","",null,null],[17,"PR_CAP_AMBIENT_RAISE","","",null,null],[17,"PR_CAP_AMBIENT_LOWER","","",null,null],[17,"PR_CAP_AMBIENT_CLEAR_ALL","","",null,null],[17,"GRND_NONBLOCK","","",null,null],[17,"GRND_RANDOM","","",null,null],[17,"SECCOMP_MODE_DISABLED","","",null,null],[17,"SECCOMP_MODE_STRICT","","",null,null],[17,"SECCOMP_MODE_FILTER","","",null,null],[17,"ITIMER_REAL","","",null,null],[17,"ITIMER_VIRTUAL","","",null,null],[17,"ITIMER_PROF","","",null,null],[17,"TFD_CLOEXEC","","",null,null],[17,"TFD_NONBLOCK","","",null,null],[17,"TFD_TIMER_ABSTIME","","",null,null],[17,"XATTR_CREATE","","",null,null],[17,"XATTR_REPLACE","","",null,null],[17,"_POSIX_VDISABLE","","",null,null],[17,"FALLOC_FL_KEEP_SIZE","","",null,null],[17,"FALLOC_FL_PUNCH_HOLE","","",null,null],[17,"FALLOC_FL_COLLAPSE_RANGE","","",null,null],[17,"FALLOC_FL_ZERO_RANGE","","",null,null],[17,"FALLOC_FL_INSERT_RANGE","","",null,null],[17,"FALLOC_FL_UNSHARE_RANGE","","",null,null],[17,"ENOATTR","","",null,null],[17,"SO_ORIGINAL_DST","","",null,null],[17,"IUTF8","","",null,null],[17,"CMSPAR","","",null,null],[17,"MFD_CLOEXEC","","",null,null],[17,"MFD_ALLOW_SEALING","","",null,null],[17,"PT_NULL","","",null,null],[17,"PT_LOAD","","",null,null],[17,"PT_DYNAMIC","","",null,null],[17,"PT_INTERP","","",null,null],[17,"PT_NOTE","","",null,null],[17,"PT_SHLIB","","",null,null],[17,"PT_PHDR","","",null,null],[17,"PT_TLS","","",null,null],[17,"PT_NUM","","",null,null],[17,"PT_LOOS","","",null,null],[17,"PT_GNU_EH_FRAME","","",null,null],[17,"PT_GNU_STACK","","",null,null],[17,"PT_GNU_RELRO","","",null,null],[17,"ETH_ALEN","","",null,null],[17,"ETH_HLEN","","",null,null],[17,"ETH_ZLEN","","",null,null],[17,"ETH_DATA_LEN","","",null,null],[17,"ETH_FRAME_LEN","","",null,null],[17,"ETH_FCS_LEN","","",null,null],[17,"ETH_P_LOOP","","",null,null],[17,"ETH_P_PUP","","",null,null],[17,"ETH_P_PUPAT","","",null,null],[17,"ETH_P_IP","","",null,null],[17,"ETH_P_X25","","",null,null],[17,"ETH_P_ARP","","",null,null],[17,"ETH_P_BPQ","","",null,null],[17,"ETH_P_IEEEPUP","","",null,null],[17,"ETH_P_IEEEPUPAT","","",null,null],[17,"ETH_P_BATMAN","","",null,null],[17,"ETH_P_DEC","","",null,null],[17,"ETH_P_DNA_DL","","",null,null],[17,"ETH_P_DNA_RC","","",null,null],[17,"ETH_P_DNA_RT","","",null,null],[17,"ETH_P_LAT","","",null,null],[17,"ETH_P_DIAG","","",null,null],[17,"ETH_P_CUST","","",null,null],[17,"ETH_P_SCA","","",null,null],[17,"ETH_P_TEB","","",null,null],[17,"ETH_P_RARP","","",null,null],[17,"ETH_P_ATALK","","",null,null],[17,"ETH_P_AARP","","",null,null],[17,"ETH_P_8021Q","","",null,null],[17,"ETH_P_IPX","","",null,null],[17,"ETH_P_IPV6","","",null,null],[17,"ETH_P_PAUSE","","",null,null],[17,"ETH_P_SLOW","","",null,null],[17,"ETH_P_WCCP","","",null,null],[17,"ETH_P_MPLS_UC","","",null,null],[17,"ETH_P_MPLS_MC","","",null,null],[17,"ETH_P_ATMMPOA","","",null,null],[17,"ETH_P_PPP_DISC","","",null,null],[17,"ETH_P_PPP_SES","","",null,null],[17,"ETH_P_LINK_CTL","","",null,null],[17,"ETH_P_ATMFATE","","",null,null],[17,"ETH_P_PAE","","",null,null],[17,"ETH_P_AOE","","",null,null],[17,"ETH_P_8021AD","","",null,null],[17,"ETH_P_802_EX1","","",null,null],[17,"ETH_P_TIPC","","",null,null],[17,"ETH_P_MACSEC","","",null,null],[17,"ETH_P_8021AH","","",null,null],[17,"ETH_P_MVRP","","",null,null],[17,"ETH_P_1588","","",null,null],[17,"ETH_P_PRP","","",null,null],[17,"ETH_P_FCOE","","",null,null],[17,"ETH_P_TDLS","","",null,null],[17,"ETH_P_FIP","","",null,null],[17,"ETH_P_80221","","",null,null],[17,"ETH_P_LOOPBACK","","",null,null],[17,"ETH_P_QINQ1","","",null,null],[17,"ETH_P_QINQ2","","",null,null],[17,"ETH_P_QINQ3","","",null,null],[17,"ETH_P_EDSA","","",null,null],[17,"ETH_P_AF_IUCV","","",null,null],[17,"ETH_P_802_3_MIN","","",null,null],[17,"ETH_P_802_3","","",null,null],[17,"ETH_P_AX25","","",null,null],[17,"ETH_P_ALL","","",null,null],[17,"ETH_P_802_2","","",null,null],[17,"ETH_P_SNAP","","",null,null],[17,"ETH_P_DDCMP","","",null,null],[17,"ETH_P_WAN_PPP","","",null,null],[17,"ETH_P_PPP_MP","","",null,null],[17,"ETH_P_LOCALTALK","","",null,null],[17,"ETH_P_CANFD","","",null,null],[17,"ETH_P_PPPTALK","","",null,null],[17,"ETH_P_TR_802_2","","",null,null],[17,"ETH_P_MOBITEX","","",null,null],[17,"ETH_P_CONTROL","","",null,null],[17,"ETH_P_IRDA","","",null,null],[17,"ETH_P_ECONET","","",null,null],[17,"ETH_P_HDLC","","",null,null],[17,"ETH_P_ARCNET","","",null,null],[17,"ETH_P_DSA","","",null,null],[17,"ETH_P_TRAILER","","",null,null],[17,"ETH_P_PHONET","","",null,null],[17,"ETH_P_IEEE802154","","",null,null],[17,"ETH_P_CAIF","","",null,null],[17,"POSIX_SPAWN_RESETIDS","","",null,null],[17,"POSIX_SPAWN_SETPGROUP","","",null,null],[17,"POSIX_SPAWN_SETSIGDEF","","",null,null],[17,"POSIX_SPAWN_SETSIGMASK","","",null,null],[17,"POSIX_SPAWN_SETSCHEDPARAM","","",null,null],[17,"POSIX_SPAWN_SETSCHEDULER","","",null,null],[17,"NLMSG_NOOP","","",null,null],[17,"NLMSG_ERROR","","",null,null],[17,"NLMSG_DONE","","",null,null],[17,"NLMSG_OVERRUN","","",null,null],[17,"NLMSG_MIN_TYPE","","",null,null],[17,"GENL_NAMSIZ","","",null,null],[17,"GENL_MIN_ID","","",null,null],[17,"GENL_MAX_ID","","",null,null],[17,"GENL_ADMIN_PERM","","",null,null],[17,"GENL_CMD_CAP_DO","","",null,null],[17,"GENL_CMD_CAP_DUMP","","",null,null],[17,"GENL_CMD_CAP_HASPOL","","",null,null],[17,"GENL_ID_CTRL","","",null,null],[17,"CTRL_CMD_UNSPEC","","",null,null],[17,"CTRL_CMD_NEWFAMILY","","",null,null],[17,"CTRL_CMD_DELFAMILY","","",null,null],[17,"CTRL_CMD_GETFAMILY","","",null,null],[17,"CTRL_CMD_NEWOPS","","",null,null],[17,"CTRL_CMD_DELOPS","","",null,null],[17,"CTRL_CMD_GETOPS","","",null,null],[17,"CTRL_CMD_NEWMCAST_GRP","","",null,null],[17,"CTRL_CMD_DELMCAST_GRP","","",null,null],[17,"CTRL_CMD_GETMCAST_GRP","","",null,null],[17,"CTRL_ATTR_UNSPEC","","",null,null],[17,"CTRL_ATTR_FAMILY_ID","","",null,null],[17,"CTRL_ATTR_FAMILY_NAME","","",null,null],[17,"CTRL_ATTR_VERSION","","",null,null],[17,"CTRL_ATTR_HDRSIZE","","",null,null],[17,"CTRL_ATTR_MAXATTR","","",null,null],[17,"CTRL_ATTR_OPS","","",null,null],[17,"CTRL_ATTR_MCAST_GROUPS","","",null,null],[17,"CTRL_ATTR_OP_UNSPEC","","",null,null],[17,"CTRL_ATTR_OP_ID","","",null,null],[17,"CTRL_ATTR_OP_FLAGS","","",null,null],[17,"CTRL_ATTR_MCAST_GRP_UNSPEC","","",null,null],[17,"CTRL_ATTR_MCAST_GRP_NAME","","",null,null],[17,"CTRL_ATTR_MCAST_GRP_ID","","",null,null],[17,"NF_DROP","","",null,null],[17,"NF_ACCEPT","","",null,null],[17,"NF_STOLEN","","",null,null],[17,"NF_QUEUE","","",null,null],[17,"NF_REPEAT","","",null,null],[17,"NF_STOP","","",null,null],[17,"NF_MAX_VERDICT","","",null,null],[17,"NF_VERDICT_MASK","","",null,null],[17,"NF_VERDICT_FLAG_QUEUE_BYPASS","","",null,null],[17,"NF_VERDICT_QMASK","","",null,null],[17,"NF_VERDICT_QBITS","","",null,null],[17,"NF_VERDICT_BITS","","",null,null],[17,"NF_INET_PRE_ROUTING","","",null,null],[17,"NF_INET_LOCAL_IN","","",null,null],[17,"NF_INET_FORWARD","","",null,null],[17,"NF_INET_LOCAL_OUT","","",null,null],[17,"NF_INET_POST_ROUTING","","",null,null],[17,"NF_INET_NUMHOOKS","","",null,null],[17,"NFPROTO_UNSPEC","","",null,null],[17,"NFPROTO_IPV4","","",null,null],[17,"NFPROTO_ARP","","",null,null],[17,"NFPROTO_BRIDGE","","",null,null],[17,"NFPROTO_IPV6","","",null,null],[17,"NFPROTO_DECNET","","",null,null],[17,"NFPROTO_NUMPROTO","","",null,null],[17,"NF_IP_PRE_ROUTING","","",null,null],[17,"NF_IP_LOCAL_IN","","",null,null],[17,"NF_IP_FORWARD","","",null,null],[17,"NF_IP_LOCAL_OUT","","",null,null],[17,"NF_IP_POST_ROUTING","","",null,null],[17,"NF_IP_NUMHOOKS","","",null,null],[17,"NF_IP_PRI_FIRST","","",null,null],[17,"NF_IP_PRI_CONNTRACK_DEFRAG","","",null,null],[17,"NF_IP_PRI_RAW","","",null,null],[17,"NF_IP_PRI_SELINUX_FIRST","","",null,null],[17,"NF_IP_PRI_CONNTRACK","","",null,null],[17,"NF_IP_PRI_MANGLE","","",null,null],[17,"NF_IP_PRI_NAT_DST","","",null,null],[17,"NF_IP_PRI_FILTER","","",null,null],[17,"NF_IP_PRI_SECURITY","","",null,null],[17,"NF_IP_PRI_NAT_SRC","","",null,null],[17,"NF_IP_PRI_SELINUX_LAST","","",null,null],[17,"NF_IP_PRI_CONNTRACK_HELPER","","",null,null],[17,"NF_IP_PRI_CONNTRACK_CONFIRM","","",null,null],[17,"NF_IP_PRI_LAST","","",null,null],[17,"NF_IP6_PRE_ROUTING","","",null,null],[17,"NF_IP6_LOCAL_IN","","",null,null],[17,"NF_IP6_FORWARD","","",null,null],[17,"NF_IP6_LOCAL_OUT","","",null,null],[17,"NF_IP6_POST_ROUTING","","",null,null],[17,"NF_IP6_NUMHOOKS","","",null,null],[17,"NF_IP6_PRI_FIRST","","",null,null],[17,"NF_IP6_PRI_CONNTRACK_DEFRAG","","",null,null],[17,"NF_IP6_PRI_RAW","","",null,null],[17,"NF_IP6_PRI_SELINUX_FIRST","","",null,null],[17,"NF_IP6_PRI_CONNTRACK","","",null,null],[17,"NF_IP6_PRI_MANGLE","","",null,null],[17,"NF_IP6_PRI_NAT_DST","","",null,null],[17,"NF_IP6_PRI_FILTER","","",null,null],[17,"NF_IP6_PRI_SECURITY","","",null,null],[17,"NF_IP6_PRI_NAT_SRC","","",null,null],[17,"NF_IP6_PRI_SELINUX_LAST","","",null,null],[17,"NF_IP6_PRI_CONNTRACK_HELPER","","",null,null],[17,"NF_IP6_PRI_LAST","","",null,null],[17,"__UT_LINESIZE","","",null,null],[17,"__UT_NAMESIZE","","",null,null],[17,"__UT_HOSTSIZE","","",null,null],[17,"EMPTY","","",null,null],[17,"RUN_LVL","","",null,null],[17,"BOOT_TIME","","",null,null],[17,"NEW_TIME","","",null,null],[17,"OLD_TIME","","",null,null],[17,"INIT_PROCESS","","",null,null],[17,"LOGIN_PROCESS","","",null,null],[17,"USER_PROCESS","","",null,null],[17,"DEAD_PROCESS","","",null,null],[17,"ACCOUNTING","","",null,null],[17,"RLIMIT_RSS","","",null,null],[17,"RLIMIT_AS","","",null,null],[17,"RLIMIT_MEMLOCK","","",null,null],[17,"RLIM_INFINITY","","",null,null],[17,"RLIMIT_RTTIME","","",null,null],[17,"RLIMIT_NLIMITS","","",null,null],[17,"SOCK_NONBLOCK","","",null,null],[17,"SOL_RXRPC","","",null,null],[17,"SOL_PPPOL2TP","","",null,null],[17,"SOL_BLUETOOTH","","",null,null],[17,"SOL_PNPIPE","","",null,null],[17,"SOL_RDS","","",null,null],[17,"SOL_IUCV","","",null,null],[17,"SOL_CAIF","","",null,null],[17,"SOL_ALG","","",null,null],[17,"SOL_NFC","","",null,null],[17,"MSG_TRYHARD","","",null,null],[17,"LC_PAPER","","",null,null],[17,"LC_NAME","","",null,null],[17,"LC_ADDRESS","","",null,null],[17,"LC_TELEPHONE","","",null,null],[17,"LC_MEASUREMENT","","",null,null],[17,"LC_IDENTIFICATION","","",null,null],[17,"LC_PAPER_MASK","","",null,null],[17,"LC_NAME_MASK","","",null,null],[17,"LC_ADDRESS_MASK","","",null,null],[17,"LC_TELEPHONE_MASK","","",null,null],[17,"LC_MEASUREMENT_MASK","","",null,null],[17,"LC_IDENTIFICATION_MASK","","",null,null],[17,"LC_ALL_MASK","","",null,null],[17,"MAP_ANON","","",null,null],[17,"MAP_ANONYMOUS","","",null,null],[17,"MAP_DENYWRITE","","",null,null],[17,"MAP_EXECUTABLE","","",null,null],[17,"MAP_POPULATE","","",null,null],[17,"MAP_NONBLOCK","","",null,null],[17,"MAP_STACK","","",null,null],[17,"ENOTSUP","","",null,null],[17,"EUCLEAN","","",null,null],[17,"ENOTNAM","","",null,null],[17,"ENAVAIL","","",null,null],[17,"EISNAM","","",null,null],[17,"EREMOTEIO","","",null,null],[17,"SOCK_STREAM","","",null,null],[17,"SOCK_DGRAM","","",null,null],[17,"SOCK_SEQPACKET","","",null,null],[17,"SOCK_DCCP","","",null,null],[17,"SOCK_PACKET","","",null,null],[17,"TCP_COOKIE_TRANSACTIONS","","",null,null],[17,"TCP_THIN_LINEAR_TIMEOUTS","","",null,null],[17,"TCP_THIN_DUPACK","","",null,null],[17,"TCP_USER_TIMEOUT","","",null,null],[17,"TCP_REPAIR","","",null,null],[17,"TCP_REPAIR_QUEUE","","",null,null],[17,"TCP_QUEUE_SEQ","","",null,null],[17,"TCP_REPAIR_OPTIONS","","",null,null],[17,"TCP_FASTOPEN","","",null,null],[17,"TCP_TIMESTAMP","","",null,null],[17,"DCCP_SOCKOPT_PACKET_SIZE","","",null,null],[17,"DCCP_SOCKOPT_SERVICE","","",null,null],[17,"DCCP_SOCKOPT_CHANGE_L","","",null,null],[17,"DCCP_SOCKOPT_CHANGE_R","","",null,null],[17,"DCCP_SOCKOPT_GET_CUR_MPS","","",null,null],[17,"DCCP_SOCKOPT_SERVER_TIMEWAIT","","",null,null],[17,"DCCP_SOCKOPT_SEND_CSCOV","","",null,null],[17,"DCCP_SOCKOPT_RECV_CSCOV","","",null,null],[17,"DCCP_SOCKOPT_AVAILABLE_CCIDS","","",null,null],[17,"DCCP_SOCKOPT_CCID","","",null,null],[17,"DCCP_SOCKOPT_TX_CCID","","",null,null],[17,"DCCP_SOCKOPT_RX_CCID","","",null,null],[17,"DCCP_SOCKOPT_QPOLICY_ID","","",null,null],[17,"DCCP_SOCKOPT_QPOLICY_TXQLEN","","",null,null],[17,"DCCP_SOCKOPT_CCID_RX_INFO","","",null,null],[17,"DCCP_SOCKOPT_CCID_TX_INFO","","",null,null],[17,"DCCP_SERVICE_LIST_MAX_LEN","","maximum number of services provided on the same listening port",null,null],[17,"SIGTTIN","","",null,null],[17,"SIGTTOU","","",null,null],[17,"SIGXCPU","","",null,null],[17,"SIGXFSZ","","",null,null],[17,"SIGVTALRM","","",null,null],[17,"SIGPROF","","",null,null],[17,"SIGWINCH","","",null,null],[17,"SIGEV_THREAD_ID","","",null,null],[17,"BUFSIZ","","",null,null],[17,"TMP_MAX","","",null,null],[17,"FOPEN_MAX","","",null,null],[17,"POSIX_FADV_DONTNEED","","",null,null],[17,"POSIX_FADV_NOREUSE","","",null,null],[17,"POSIX_MADV_DONTNEED","","",null,null],[17,"_SC_EQUIV_CLASS_MAX","","",null,null],[17,"_SC_CHARCLASS_NAME_MAX","","",null,null],[17,"_SC_PII","","",null,null],[17,"_SC_PII_XTI","","",null,null],[17,"_SC_PII_SOCKET","","",null,null],[17,"_SC_PII_INTERNET","","",null,null],[17,"_SC_PII_OSI","","",null,null],[17,"_SC_POLL","","",null,null],[17,"_SC_SELECT","","",null,null],[17,"_SC_PII_INTERNET_STREAM","","",null,null],[17,"_SC_PII_INTERNET_DGRAM","","",null,null],[17,"_SC_PII_OSI_COTS","","",null,null],[17,"_SC_PII_OSI_CLTS","","",null,null],[17,"_SC_PII_OSI_M","","",null,null],[17,"_SC_T_IOV_MAX","","",null,null],[17,"_SC_2_C_VERSION","","",null,null],[17,"_SC_CHAR_BIT","","",null,null],[17,"_SC_CHAR_MAX","","",null,null],[17,"_SC_CHAR_MIN","","",null,null],[17,"_SC_INT_MAX","","",null,null],[17,"_SC_INT_MIN","","",null,null],[17,"_SC_LONG_BIT","","",null,null],[17,"_SC_WORD_BIT","","",null,null],[17,"_SC_MB_LEN_MAX","","",null,null],[17,"_SC_SSIZE_MAX","","",null,null],[17,"_SC_SCHAR_MAX","","",null,null],[17,"_SC_SCHAR_MIN","","",null,null],[17,"_SC_SHRT_MAX","","",null,null],[17,"_SC_SHRT_MIN","","",null,null],[17,"_SC_UCHAR_MAX","","",null,null],[17,"_SC_UINT_MAX","","",null,null],[17,"_SC_ULONG_MAX","","",null,null],[17,"_SC_USHRT_MAX","","",null,null],[17,"_SC_NL_ARGMAX","","",null,null],[17,"_SC_NL_LANGMAX","","",null,null],[17,"_SC_NL_MSGMAX","","",null,null],[17,"_SC_NL_NMAX","","",null,null],[17,"_SC_NL_SETMAX","","",null,null],[17,"_SC_NL_TEXTMAX","","",null,null],[17,"_SC_BASE","","",null,null],[17,"_SC_C_LANG_SUPPORT","","",null,null],[17,"_SC_C_LANG_SUPPORT_R","","",null,null],[17,"_SC_DEVICE_IO","","",null,null],[17,"_SC_DEVICE_SPECIFIC","","",null,null],[17,"_SC_DEVICE_SPECIFIC_R","","",null,null],[17,"_SC_FD_MGMT","","",null,null],[17,"_SC_FIFO","","",null,null],[17,"_SC_PIPE","","",null,null],[17,"_SC_FILE_ATTRIBUTES","","",null,null],[17,"_SC_FILE_LOCKING","","",null,null],[17,"_SC_FILE_SYSTEM","","",null,null],[17,"_SC_MULTI_PROCESS","","",null,null],[17,"_SC_SINGLE_PROCESS","","",null,null],[17,"_SC_NETWORKING","","",null,null],[17,"_SC_REGEX_VERSION","","",null,null],[17,"_SC_SIGNALS","","",null,null],[17,"_SC_SYSTEM_DATABASE","","",null,null],[17,"_SC_SYSTEM_DATABASE_R","","",null,null],[17,"_SC_USER_GROUPS","","",null,null],[17,"_SC_USER_GROUPS_R","","",null,null],[17,"_SC_LEVEL1_ICACHE_SIZE","","",null,null],[17,"_SC_LEVEL1_ICACHE_ASSOC","","",null,null],[17,"_SC_LEVEL1_ICACHE_LINESIZE","","",null,null],[17,"_SC_LEVEL1_DCACHE_SIZE","","",null,null],[17,"_SC_LEVEL1_DCACHE_ASSOC","","",null,null],[17,"_SC_LEVEL1_DCACHE_LINESIZE","","",null,null],[17,"_SC_LEVEL2_CACHE_SIZE","","",null,null],[17,"_SC_LEVEL2_CACHE_ASSOC","","",null,null],[17,"_SC_LEVEL2_CACHE_LINESIZE","","",null,null],[17,"_SC_LEVEL3_CACHE_SIZE","","",null,null],[17,"_SC_LEVEL3_CACHE_ASSOC","","",null,null],[17,"_SC_LEVEL3_CACHE_LINESIZE","","",null,null],[17,"_SC_LEVEL4_CACHE_SIZE","","",null,null],[17,"_SC_LEVEL4_CACHE_ASSOC","","",null,null],[17,"_SC_LEVEL4_CACHE_LINESIZE","","",null,null],[17,"O_ACCMODE","","",null,null],[17,"ST_RELATIME","","",null,null],[17,"NI_MAXHOST","","",null,null],[17,"ADFS_SUPER_MAGIC","","",null,null],[17,"AFFS_SUPER_MAGIC","","",null,null],[17,"CODA_SUPER_MAGIC","","",null,null],[17,"CRAMFS_MAGIC","","",null,null],[17,"EFS_SUPER_MAGIC","","",null,null],[17,"EXT2_SUPER_MAGIC","","",null,null],[17,"EXT3_SUPER_MAGIC","","",null,null],[17,"EXT4_SUPER_MAGIC","","",null,null],[17,"HPFS_SUPER_MAGIC","","",null,null],[17,"HUGETLBFS_MAGIC","","",null,null],[17,"ISOFS_SUPER_MAGIC","","",null,null],[17,"JFFS2_SUPER_MAGIC","","",null,null],[17,"MINIX_SUPER_MAGIC","","",null,null],[17,"MINIX_SUPER_MAGIC2","","",null,null],[17,"MINIX2_SUPER_MAGIC","","",null,null],[17,"MINIX2_SUPER_MAGIC2","","",null,null],[17,"MSDOS_SUPER_MAGIC","","",null,null],[17,"NCP_SUPER_MAGIC","","",null,null],[17,"NFS_SUPER_MAGIC","","",null,null],[17,"OPENPROM_SUPER_MAGIC","","",null,null],[17,"PROC_SUPER_MAGIC","","",null,null],[17,"QNX4_SUPER_MAGIC","","",null,null],[17,"REISERFS_SUPER_MAGIC","","",null,null],[17,"SMB_SUPER_MAGIC","","",null,null],[17,"TMPFS_MAGIC","","",null,null],[17,"USBDEVICE_SUPER_MAGIC","","",null,null],[17,"VEOF","","",null,null],[17,"CPU_SETSIZE","","",null,null],[17,"PTRACE_TRACEME","","",null,null],[17,"PTRACE_PEEKTEXT","","",null,null],[17,"PTRACE_PEEKDATA","","",null,null],[17,"PTRACE_PEEKUSER","","",null,null],[17,"PTRACE_POKETEXT","","",null,null],[17,"PTRACE_POKEDATA","","",null,null],[17,"PTRACE_POKEUSER","","",null,null],[17,"PTRACE_CONT","","",null,null],[17,"PTRACE_KILL","","",null,null],[17,"PTRACE_SINGLESTEP","","",null,null],[17,"PTRACE_ATTACH","","",null,null],[17,"PTRACE_SYSCALL","","",null,null],[17,"PTRACE_SETOPTIONS","","",null,null],[17,"PTRACE_GETEVENTMSG","","",null,null],[17,"PTRACE_GETSIGINFO","","",null,null],[17,"PTRACE_SETSIGINFO","","",null,null],[17,"PTRACE_GETREGSET","","",null,null],[17,"PTRACE_SETREGSET","","",null,null],[17,"PTRACE_SEIZE","","",null,null],[17,"PTRACE_INTERRUPT","","",null,null],[17,"PTRACE_LISTEN","","",null,null],[17,"PTRACE_PEEKSIGINFO","","",null,null],[17,"EPOLLWAKEUP","","",null,null],[17,"MAP_HUGETLB","","",null,null],[17,"SEEK_DATA","","",null,null],[17,"SEEK_HOLE","","",null,null],[17,"TCSANOW","","",null,null],[17,"TCSADRAIN","","",null,null],[17,"TCSAFLUSH","","",null,null],[17,"TIOCLINUX","","",null,null],[17,"TIOCGSERIAL","","",null,null],[17,"RTLD_DEEPBIND","","",null,null],[17,"RTLD_GLOBAL","","",null,null],[17,"RTLD_NOLOAD","","",null,null],[17,"LINUX_REBOOT_MAGIC1","","",null,null],[17,"LINUX_REBOOT_MAGIC2","","",null,null],[17,"LINUX_REBOOT_MAGIC2A","","",null,null],[17,"LINUX_REBOOT_MAGIC2B","","",null,null],[17,"LINUX_REBOOT_MAGIC2C","","",null,null],[17,"LINUX_REBOOT_CMD_RESTART","","",null,null],[17,"LINUX_REBOOT_CMD_HALT","","",null,null],[17,"LINUX_REBOOT_CMD_CAD_ON","","",null,null],[17,"LINUX_REBOOT_CMD_CAD_OFF","","",null,null],[17,"LINUX_REBOOT_CMD_POWER_OFF","","",null,null],[17,"LINUX_REBOOT_CMD_RESTART2","","",null,null],[17,"LINUX_REBOOT_CMD_SW_SUSPEND","","",null,null],[17,"LINUX_REBOOT_CMD_KEXEC","","",null,null],[17,"NETLINK_ROUTE","","",null,null],[17,"NETLINK_UNUSED","","",null,null],[17,"NETLINK_USERSOCK","","",null,null],[17,"NETLINK_FIREWALL","","",null,null],[17,"NETLINK_SOCK_DIAG","","",null,null],[17,"NETLINK_NFLOG","","",null,null],[17,"NETLINK_XFRM","","",null,null],[17,"NETLINK_SELINUX","","",null,null],[17,"NETLINK_ISCSI","","",null,null],[17,"NETLINK_AUDIT","","",null,null],[17,"NETLINK_FIB_LOOKUP","","",null,null],[17,"NETLINK_CONNECTOR","","",null,null],[17,"NETLINK_NETFILTER","","",null,null],[17,"NETLINK_IP6_FW","","",null,null],[17,"NETLINK_DNRTMSG","","",null,null],[17,"NETLINK_KOBJECT_UEVENT","","",null,null],[17,"NETLINK_GENERIC","","",null,null],[17,"NETLINK_SCSITRANSPORT","","",null,null],[17,"NETLINK_ECRYPTFS","","",null,null],[17,"NETLINK_RDMA","","",null,null],[17,"NETLINK_CRYPTO","","",null,null],[17,"NETLINK_INET_DIAG","","",null,null],[17,"MAX_LINKS","","",null,null],[17,"NLM_F_REQUEST","","",null,null],[17,"NLM_F_MULTI","","",null,null],[17,"NLM_F_ACK","","",null,null],[17,"NLM_F_ECHO","","",null,null],[17,"NLM_F_DUMP_INTR","","",null,null],[17,"NLM_F_DUMP_FILTERED","","",null,null],[17,"NLM_F_ROOT","","",null,null],[17,"NLM_F_MATCH","","",null,null],[17,"NLM_F_ATOMIC","","",null,null],[17,"NLM_F_DUMP","","",null,null],[17,"NLM_F_REPLACE","","",null,null],[17,"NLM_F_EXCL","","",null,null],[17,"NLM_F_CREATE","","",null,null],[17,"NLM_F_APPEND","","",null,null],[17,"NETLINK_ADD_MEMBERSHIP","","",null,null],[17,"NETLINK_DROP_MEMBERSHIP","","",null,null],[17,"NETLINK_PKTINFO","","",null,null],[17,"NETLINK_BROADCAST_ERROR","","",null,null],[17,"NETLINK_NO_ENOBUFS","","",null,null],[17,"NETLINK_RX_RING","","",null,null],[17,"NETLINK_TX_RING","","",null,null],[17,"NETLINK_LISTEN_ALL_NSID","","",null,null],[17,"NETLINK_LIST_MEMBERSHIPS","","",null,null],[17,"NETLINK_CAP_ACK","","",null,null],[17,"NLA_F_NESTED","","",null,null],[17,"NLA_F_NET_BYTEORDER","","",null,null],[17,"NLA_TYPE_MASK","","",null,null],[17,"NLA_ALIGNTO","","",null,null],[17,"GENL_UNS_ADMIN_PERM","","",null,null],[17,"GENL_ID_VFS_DQUOT","","",null,null],[17,"GENL_ID_PMCRAID","","",null,null],[17,"TIOCM_LE","","",null,null],[17,"TIOCM_DTR","","",null,null],[17,"TIOCM_RTS","","",null,null],[17,"TIOCM_ST","","",null,null],[17,"TIOCM_SR","","",null,null],[17,"TIOCM_CTS","","",null,null],[17,"TIOCM_CAR","","",null,null],[17,"TIOCM_RNG","","",null,null],[17,"TIOCM_DSR","","",null,null],[17,"TIOCM_CD","","",null,null],[17,"TIOCM_RI","","",null,null],[17,"NF_NETDEV_INGRESS","","",null,null],[17,"NF_NETDEV_NUMHOOKS","","",null,null],[17,"NFPROTO_INET","","",null,null],[17,"NFPROTO_NETDEV","","",null,null],[17,"NFT_TABLE_MAXNAMELEN","","",null,null],[17,"NFT_CHAIN_MAXNAMELEN","","",null,null],[17,"NFT_SET_MAXNAMELEN","","",null,null],[17,"NFT_OBJ_MAXNAMELEN","","",null,null],[17,"NFT_USERDATA_MAXLEN","","",null,null],[17,"NFT_REG_VERDICT","","",null,null],[17,"NFT_REG_1","","",null,null],[17,"NFT_REG_2","","",null,null],[17,"NFT_REG_3","","",null,null],[17,"NFT_REG_4","","",null,null],[17,"__NFT_REG_MAX","","",null,null],[17,"NFT_REG32_00","","",null,null],[17,"NFT_REG32_01","","",null,null],[17,"NFT_REG32_02","","",null,null],[17,"NFT_REG32_03","","",null,null],[17,"NFT_REG32_04","","",null,null],[17,"NFT_REG32_05","","",null,null],[17,"NFT_REG32_06","","",null,null],[17,"NFT_REG32_07","","",null,null],[17,"NFT_REG32_08","","",null,null],[17,"NFT_REG32_09","","",null,null],[17,"NFT_REG32_10","","",null,null],[17,"NFT_REG32_11","","",null,null],[17,"NFT_REG32_12","","",null,null],[17,"NFT_REG32_13","","",null,null],[17,"NFT_REG32_14","","",null,null],[17,"NFT_REG32_15","","",null,null],[17,"NFT_REG_SIZE","","",null,null],[17,"NFT_REG32_SIZE","","",null,null],[17,"NFT_CONTINUE","","",null,null],[17,"NFT_BREAK","","",null,null],[17,"NFT_JUMP","","",null,null],[17,"NFT_GOTO","","",null,null],[17,"NFT_RETURN","","",null,null],[17,"NFT_MSG_NEWTABLE","","",null,null],[17,"NFT_MSG_GETTABLE","","",null,null],[17,"NFT_MSG_DELTABLE","","",null,null],[17,"NFT_MSG_NEWCHAIN","","",null,null],[17,"NFT_MSG_GETCHAIN","","",null,null],[17,"NFT_MSG_DELCHAIN","","",null,null],[17,"NFT_MSG_NEWRULE","","",null,null],[17,"NFT_MSG_GETRULE","","",null,null],[17,"NFT_MSG_DELRULE","","",null,null],[17,"NFT_MSG_NEWSET","","",null,null],[17,"NFT_MSG_GETSET","","",null,null],[17,"NFT_MSG_DELSET","","",null,null],[17,"NFT_MSG_NEWSETELEM","","",null,null],[17,"NFT_MSG_GETSETELEM","","",null,null],[17,"NFT_MSG_DELSETELEM","","",null,null],[17,"NFT_MSG_NEWGEN","","",null,null],[17,"NFT_MSG_GETGEN","","",null,null],[17,"NFT_MSG_TRACE","","",null,null],[17,"NFT_MSG_NEWOBJ","","",null,null],[17,"NFT_MSG_GETOBJ","","",null,null],[17,"NFT_MSG_DELOBJ","","",null,null],[17,"NFT_MSG_GETOBJ_RESET","","",null,null],[17,"NFT_MSG_MAX","","",null,null],[17,"NFT_SET_ANONYMOUS","","",null,null],[17,"NFT_SET_CONSTANT","","",null,null],[17,"NFT_SET_INTERVAL","","",null,null],[17,"NFT_SET_MAP","","",null,null],[17,"NFT_SET_TIMEOUT","","",null,null],[17,"NFT_SET_EVAL","","",null,null],[17,"NFT_SET_POL_PERFORMANCE","","",null,null],[17,"NFT_SET_POL_MEMORY","","",null,null],[17,"NFT_SET_ELEM_INTERVAL_END","","",null,null],[17,"NFT_DATA_VALUE","","",null,null],[17,"NFT_DATA_VERDICT","","",null,null],[17,"NFT_DATA_RESERVED_MASK","","",null,null],[17,"NFT_DATA_VALUE_MAXLEN","","",null,null],[17,"NFT_BYTEORDER_NTOH","","",null,null],[17,"NFT_BYTEORDER_HTON","","",null,null],[17,"NFT_CMP_EQ","","",null,null],[17,"NFT_CMP_NEQ","","",null,null],[17,"NFT_CMP_LT","","",null,null],[17,"NFT_CMP_LTE","","",null,null],[17,"NFT_CMP_GT","","",null,null],[17,"NFT_CMP_GTE","","",null,null],[17,"NFT_RANGE_EQ","","",null,null],[17,"NFT_RANGE_NEQ","","",null,null],[17,"NFT_LOOKUP_F_INV","","",null,null],[17,"NFT_DYNSET_OP_ADD","","",null,null],[17,"NFT_DYNSET_OP_UPDATE","","",null,null],[17,"NFT_DYNSET_F_INV","","",null,null],[17,"NFT_PAYLOAD_LL_HEADER","","",null,null],[17,"NFT_PAYLOAD_NETWORK_HEADER","","",null,null],[17,"NFT_PAYLOAD_TRANSPORT_HEADER","","",null,null],[17,"NFT_PAYLOAD_CSUM_NONE","","",null,null],[17,"NFT_PAYLOAD_CSUM_INET","","",null,null],[17,"NFT_META_LEN","","",null,null],[17,"NFT_META_PROTOCOL","","",null,null],[17,"NFT_META_PRIORITY","","",null,null],[17,"NFT_META_MARK","","",null,null],[17,"NFT_META_IIF","","",null,null],[17,"NFT_META_OIF","","",null,null],[17,"NFT_META_IIFNAME","","",null,null],[17,"NFT_META_OIFNAME","","",null,null],[17,"NFT_META_IIFTYPE","","",null,null],[17,"NFT_META_OIFTYPE","","",null,null],[17,"NFT_META_SKUID","","",null,null],[17,"NFT_META_SKGID","","",null,null],[17,"NFT_META_NFTRACE","","",null,null],[17,"NFT_META_RTCLASSID","","",null,null],[17,"NFT_META_SECMARK","","",null,null],[17,"NFT_META_NFPROTO","","",null,null],[17,"NFT_META_L4PROTO","","",null,null],[17,"NFT_META_BRI_IIFNAME","","",null,null],[17,"NFT_META_BRI_OIFNAME","","",null,null],[17,"NFT_META_PKTTYPE","","",null,null],[17,"NFT_META_CPU","","",null,null],[17,"NFT_META_IIFGROUP","","",null,null],[17,"NFT_META_OIFGROUP","","",null,null],[17,"NFT_META_CGROUP","","",null,null],[17,"NFT_META_PRANDOM","","",null,null],[17,"NFT_CT_STATE","","",null,null],[17,"NFT_CT_DIRECTION","","",null,null],[17,"NFT_CT_STATUS","","",null,null],[17,"NFT_CT_MARK","","",null,null],[17,"NFT_CT_SECMARK","","",null,null],[17,"NFT_CT_EXPIRATION","","",null,null],[17,"NFT_CT_HELPER","","",null,null],[17,"NFT_CT_L3PROTOCOL","","",null,null],[17,"NFT_CT_SRC","","",null,null],[17,"NFT_CT_DST","","",null,null],[17,"NFT_CT_PROTOCOL","","",null,null],[17,"NFT_CT_PROTO_SRC","","",null,null],[17,"NFT_CT_PROTO_DST","","",null,null],[17,"NFT_CT_LABELS","","",null,null],[17,"NFT_CT_PKTS","","",null,null],[17,"NFT_CT_BYTES","","",null,null],[17,"NFT_LIMIT_PKTS","","",null,null],[17,"NFT_LIMIT_PKT_BYTES","","",null,null],[17,"NFT_LIMIT_F_INV","","",null,null],[17,"NFT_QUEUE_FLAG_BYPASS","","",null,null],[17,"NFT_QUEUE_FLAG_CPU_FANOUT","","",null,null],[17,"NFT_QUEUE_FLAG_MASK","","",null,null],[17,"NFT_QUOTA_F_INV","","",null,null],[17,"NFT_REJECT_ICMP_UNREACH","","",null,null],[17,"NFT_REJECT_TCP_RST","","",null,null],[17,"NFT_REJECT_ICMPX_UNREACH","","",null,null],[17,"NFT_REJECT_ICMPX_NO_ROUTE","","",null,null],[17,"NFT_REJECT_ICMPX_PORT_UNREACH","","",null,null],[17,"NFT_REJECT_ICMPX_HOST_UNREACH","","",null,null],[17,"NFT_REJECT_ICMPX_ADMIN_PROHIBITED","","",null,null],[17,"NFT_NAT_SNAT","","",null,null],[17,"NFT_NAT_DNAT","","",null,null],[17,"NFT_TRACETYPE_UNSPEC","","",null,null],[17,"NFT_TRACETYPE_POLICY","","",null,null],[17,"NFT_TRACETYPE_RETURN","","",null,null],[17,"NFT_TRACETYPE_RULE","","",null,null],[17,"NFT_NG_INCREMENTAL","","",null,null],[17,"NFT_NG_RANDOM","","",null,null],[17,"AF_MAX","","",null,null],[17,"PF_MAX","","",null,null],[17,"PTHREAD_STACK_MIN","","",null,null],[17,"__SIZEOF_PTHREAD_RWLOCKATTR_T","","",null,null],[17,"O_LARGEFILE","","",null,null],[17,"TIOCGSOFTCAR","","",null,null],[17,"TIOCSSOFTCAR","","",null,null],[17,"RLIMIT_NOFILE","","",null,null],[17,"RLIMIT_NPROC","","",null,null],[17,"O_APPEND","","",null,null],[17,"O_CREAT","","",null,null],[17,"O_EXCL","","",null,null],[17,"O_NOCTTY","","",null,null],[17,"O_NONBLOCK","","",null,null],[17,"O_SYNC","","",null,null],[17,"O_RSYNC","","",null,null],[17,"O_DSYNC","","",null,null],[17,"O_FSYNC","","",null,null],[17,"O_NOATIME","","",null,null],[17,"O_PATH","","",null,null],[17,"O_TMPFILE","","",null,null],[17,"MAP_GROWSDOWN","","",null,null],[17,"EDEADLK","","",null,null],[17,"ENAMETOOLONG","","",null,null],[17,"ENOLCK","","",null,null],[17,"ENOSYS","","",null,null],[17,"ENOTEMPTY","","",null,null],[17,"ELOOP","","",null,null],[17,"ENOMSG","","",null,null],[17,"EIDRM","","",null,null],[17,"ECHRNG","","",null,null],[17,"EL2NSYNC","","",null,null],[17,"EL3HLT","","",null,null],[17,"EL3RST","","",null,null],[17,"ELNRNG","","",null,null],[17,"EUNATCH","","",null,null],[17,"ENOCSI","","",null,null],[17,"EL2HLT","","",null,null],[17,"EBADE","","",null,null],[17,"EBADR","","",null,null],[17,"EXFULL","","",null,null],[17,"ENOANO","","",null,null],[17,"EBADRQC","","",null,null],[17,"EBADSLT","","",null,null],[17,"EMULTIHOP","","",null,null],[17,"EOVERFLOW","","",null,null],[17,"ENOTUNIQ","","",null,null],[17,"EBADFD","","",null,null],[17,"EBADMSG","","",null,null],[17,"EREMCHG","","",null,null],[17,"ELIBACC","","",null,null],[17,"ELIBBAD","","",null,null],[17,"ELIBSCN","","",null,null],[17,"ELIBMAX","","",null,null],[17,"ELIBEXEC","","",null,null],[17,"EILSEQ","","",null,null],[17,"ERESTART","","",null,null],[17,"ESTRPIPE","","",null,null],[17,"EUSERS","","",null,null],[17,"ENOTSOCK","","",null,null],[17,"EDESTADDRREQ","","",null,null],[17,"EMSGSIZE","","",null,null],[17,"EPROTOTYPE","","",null,null],[17,"ENOPROTOOPT","","",null,null],[17,"EPROTONOSUPPORT","","",null,null],[17,"ESOCKTNOSUPPORT","","",null,null],[17,"EOPNOTSUPP","","",null,null],[17,"EPFNOSUPPORT","","",null,null],[17,"EAFNOSUPPORT","","",null,null],[17,"EADDRINUSE","","",null,null],[17,"EADDRNOTAVAIL","","",null,null],[17,"ENETDOWN","","",null,null],[17,"ENETUNREACH","","",null,null],[17,"ENETRESET","","",null,null],[17,"ECONNABORTED","","",null,null],[17,"ECONNRESET","","",null,null],[17,"ENOBUFS","","",null,null],[17,"EISCONN","","",null,null],[17,"ENOTCONN","","",null,null],[17,"ESHUTDOWN","","",null,null],[17,"ETOOMANYREFS","","",null,null],[17,"ETIMEDOUT","","",null,null],[17,"ECONNREFUSED","","",null,null],[17,"EHOSTDOWN","","",null,null],[17,"EHOSTUNREACH","","",null,null],[17,"EALREADY","","",null,null],[17,"EINPROGRESS","","",null,null],[17,"ESTALE","","",null,null],[17,"EDQUOT","","",null,null],[17,"ENOMEDIUM","","",null,null],[17,"EMEDIUMTYPE","","",null,null],[17,"ECANCELED","","",null,null],[17,"ENOKEY","","",null,null],[17,"EKEYEXPIRED","","",null,null],[17,"EKEYREVOKED","","",null,null],[17,"EKEYREJECTED","","",null,null],[17,"EOWNERDEAD","","",null,null],[17,"ENOTRECOVERABLE","","",null,null],[17,"EHWPOISON","","",null,null],[17,"ERFKILL","","",null,null],[17,"SOL_SOCKET","","",null,null],[17,"SO_REUSEADDR","","",null,null],[17,"SO_TYPE","","",null,null],[17,"SO_ERROR","","",null,null],[17,"SO_DONTROUTE","","",null,null],[17,"SO_BROADCAST","","",null,null],[17,"SO_SNDBUF","","",null,null],[17,"SO_RCVBUF","","",null,null],[17,"SO_SNDBUFFORCE","","",null,null],[17,"SO_RCVBUFFORCE","","",null,null],[17,"SO_KEEPALIVE","","",null,null],[17,"SO_OOBINLINE","","",null,null],[17,"SO_NO_CHECK","","",null,null],[17,"SO_PRIORITY","","",null,null],[17,"SO_LINGER","","",null,null],[17,"SO_BSDCOMPAT","","",null,null],[17,"SO_REUSEPORT","","",null,null],[17,"SO_PASSCRED","","",null,null],[17,"SO_PEERCRED","","",null,null],[17,"SO_RCVLOWAT","","",null,null],[17,"SO_SNDLOWAT","","",null,null],[17,"SO_RCVTIMEO","","",null,null],[17,"SO_SNDTIMEO","","",null,null],[17,"SO_SECURITY_AUTHENTICATION","","",null,null],[17,"SO_SECURITY_ENCRYPTION_TRANSPORT","","",null,null],[17,"SO_SECURITY_ENCRYPTION_NETWORK","","",null,null],[17,"SO_BINDTODEVICE","","",null,null],[17,"SO_ATTACH_FILTER","","",null,null],[17,"SO_DETACH_FILTER","","",null,null],[17,"SO_GET_FILTER","","",null,null],[17,"SO_PEERNAME","","",null,null],[17,"SO_TIMESTAMP","","",null,null],[17,"SO_ACCEPTCONN","","",null,null],[17,"SO_PEERSEC","","",null,null],[17,"SO_PASSSEC","","",null,null],[17,"SO_TIMESTAMPNS","","",null,null],[17,"SCM_TIMESTAMPNS","","",null,null],[17,"SO_MARK","","",null,null],[17,"SO_TIMESTAMPING","","",null,null],[17,"SCM_TIMESTAMPING","","",null,null],[17,"SO_PROTOCOL","","",null,null],[17,"SO_DOMAIN","","",null,null],[17,"SO_RXQ_OVFL","","",null,null],[17,"SO_WIFI_STATUS","","",null,null],[17,"SCM_WIFI_STATUS","","",null,null],[17,"SO_PEEK_OFF","","",null,null],[17,"SO_NOFCS","","",null,null],[17,"SO_LOCK_FILTER","","",null,null],[17,"SO_SELECT_ERR_QUEUE","","",null,null],[17,"SO_BUSY_POLL","","",null,null],[17,"SO_MAX_PACING_RATE","","",null,null],[17,"SO_BPF_EXTENSIONS","","",null,null],[17,"SO_INCOMING_CPU","","",null,null],[17,"SO_ATTACH_BPF","","",null,null],[17,"SO_DETACH_BPF","","",null,null],[17,"SA_ONSTACK","","",null,null],[17,"SA_SIGINFO","","",null,null],[17,"SA_NOCLDWAIT","","",null,null],[17,"SIGCHLD","","",null,null],[17,"SIGBUS","","",null,null],[17,"SIGUSR1","","",null,null],[17,"SIGUSR2","","",null,null],[17,"SIGCONT","","",null,null],[17,"SIGSTOP","","",null,null],[17,"SIGTSTP","","",null,null],[17,"SIGURG","","",null,null],[17,"SIGIO","","",null,null],[17,"SIGSYS","","",null,null],[17,"SIGSTKFLT","","",null,null],[17,"SIGUNUSED","","",null,null],[17,"SIGPOLL","","",null,null],[17,"SIGPWR","","",null,null],[17,"SIG_SETMASK","","",null,null],[17,"SIG_BLOCK","","",null,null],[17,"SIG_UNBLOCK","","",null,null],[17,"POLLWRNORM","","",null,null],[17,"POLLWRBAND","","",null,null],[17,"O_ASYNC","","",null,null],[17,"O_NDELAY","","",null,null],[17,"PTRACE_DETACH","","",null,null],[17,"EFD_NONBLOCK","","",null,null],[17,"F_GETLK","","",null,null],[17,"F_GETOWN","","",null,null],[17,"F_SETOWN","","",null,null],[17,"F_SETLK","","",null,null],[17,"F_SETLKW","","",null,null],[17,"SFD_NONBLOCK","","",null,null],[17,"TIOCEXCL","","",null,null],[17,"TIOCNXCL","","",null,null],[17,"TIOCSCTTY","","",null,null],[17,"TIOCSTI","","",null,null],[17,"TIOCMGET","","",null,null],[17,"TIOCMBIS","","",null,null],[17,"TIOCMBIC","","",null,null],[17,"TIOCMSET","","",null,null],[17,"TIOCCONS","","",null,null],[17,"SFD_CLOEXEC","","",null,null],[17,"NCCS","","",null,null],[17,"O_TRUNC","","",null,null],[17,"O_CLOEXEC","","",null,null],[17,"EBFONT","","",null,null],[17,"ENOSTR","","",null,null],[17,"ENODATA","","",null,null],[17,"ETIME","","",null,null],[17,"ENOSR","","",null,null],[17,"ENONET","","",null,null],[17,"ENOPKG","","",null,null],[17,"EREMOTE","","",null,null],[17,"ENOLINK","","",null,null],[17,"EADV","","",null,null],[17,"ESRMNT","","",null,null],[17,"ECOMM","","",null,null],[17,"EPROTO","","",null,null],[17,"EDOTDOT","","",null,null],[17,"SA_NODEFER","","",null,null],[17,"SA_RESETHAND","","",null,null],[17,"SA_RESTART","","",null,null],[17,"SA_NOCLDSTOP","","",null,null],[17,"EPOLL_CLOEXEC","","",null,null],[17,"EFD_CLOEXEC","","",null,null],[17,"__SIZEOF_PTHREAD_CONDATTR_T","","",null,null],[17,"__SIZEOF_PTHREAD_MUTEXATTR_T","","",null,null],[17,"O_DIRECT","","",null,null],[17,"O_DIRECTORY","","",null,null],[17,"O_NOFOLLOW","","",null,null],[17,"MAP_LOCKED","","",null,null],[17,"MAP_NORESERVE","","",null,null],[17,"MAP_32BIT","","",null,null],[17,"EDEADLOCK","","",null,null],[17,"FIOCLEX","","",null,null],[17,"FIONBIO","","",null,null],[17,"PTRACE_GETFPREGS","","",null,null],[17,"PTRACE_SETFPREGS","","",null,null],[17,"PTRACE_GETFPXREGS","","",null,null],[17,"PTRACE_SETFPXREGS","","",null,null],[17,"PTRACE_GETREGS","","",null,null],[17,"PTRACE_SETREGS","","",null,null],[17,"PTRACE_PEEKSIGINFO_SHARED","","",null,null],[17,"MCL_CURRENT","","",null,null],[17,"MCL_FUTURE","","",null,null],[17,"SIGSTKSZ","","",null,null],[17,"MINSIGSTKSZ","","",null,null],[17,"CBAUD","","",null,null],[17,"TAB1","","",null,null],[17,"TAB2","","",null,null],[17,"TAB3","","",null,null],[17,"CR1","","",null,null],[17,"CR2","","",null,null],[17,"CR3","","",null,null],[17,"FF1","","",null,null],[17,"BS1","","",null,null],[17,"VT1","","",null,null],[17,"VWERASE","","",null,null],[17,"VREPRINT","","",null,null],[17,"VSUSP","","",null,null],[17,"VSTART","","",null,null],[17,"VSTOP","","",null,null],[17,"VDISCARD","","",null,null],[17,"VTIME","","",null,null],[17,"IXON","","",null,null],[17,"IXOFF","","",null,null],[17,"ONLCR","","",null,null],[17,"CSIZE","","",null,null],[17,"CS6","","",null,null],[17,"CS7","","",null,null],[17,"CS8","","",null,null],[17,"CSTOPB","","",null,null],[17,"CREAD","","",null,null],[17,"PARENB","","",null,null],[17,"PARODD","","",null,null],[17,"HUPCL","","",null,null],[17,"CLOCAL","","",null,null],[17,"ECHOKE","","",null,null],[17,"ECHOE","","",null,null],[17,"ECHOK","","",null,null],[17,"ECHONL","","",null,null],[17,"ECHOPRT","","",null,null],[17,"ECHOCTL","","",null,null],[17,"ISIG","","",null,null],[17,"ICANON","","",null,null],[17,"PENDIN","","",null,null],[17,"NOFLSH","","",null,null],[17,"CIBAUD","","",null,null],[17,"CBAUDEX","","",null,null],[17,"VSWTC","","",null,null],[17,"OLCUC","","",null,null],[17,"NLDLY","","",null,null],[17,"CRDLY","","",null,null],[17,"TABDLY","","",null,null],[17,"BSDLY","","",null,null],[17,"FFDLY","","",null,null],[17,"VTDLY","","",null,null],[17,"XTABS","","",null,null],[17,"B0","","",null,null],[17,"B50","","",null,null],[17,"B75","","",null,null],[17,"B110","","",null,null],[17,"B134","","",null,null],[17,"B150","","",null,null],[17,"B200","","",null,null],[17,"B300","","",null,null],[17,"B600","","",null,null],[17,"B1200","","",null,null],[17,"B1800","","",null,null],[17,"B2400","","",null,null],[17,"B4800","","",null,null],[17,"B9600","","",null,null],[17,"B19200","","",null,null],[17,"B38400","","",null,null],[17,"EXTA","","",null,null],[17,"EXTB","","",null,null],[17,"BOTHER","","",null,null],[17,"B57600","","",null,null],[17,"B115200","","",null,null],[17,"B230400","","",null,null],[17,"B460800","","",null,null],[17,"B500000","","",null,null],[17,"B576000","","",null,null],[17,"B921600","","",null,null],[17,"B1000000","","",null,null],[17,"B1152000","","",null,null],[17,"B1500000","","",null,null],[17,"B2000000","","",null,null],[17,"B2500000","","",null,null],[17,"B3000000","","",null,null],[17,"B3500000","","",null,null],[17,"B4000000","","",null,null],[17,"VEOL","","",null,null],[17,"VEOL2","","",null,null],[17,"VMIN","","",null,null],[17,"IEXTEN","","",null,null],[17,"TOSTOP","","",null,null],[17,"FLUSHO","","",null,null],[17,"EXTPROC","","",null,null],[17,"TCGETS","","",null,null],[17,"TCSETS","","",null,null],[17,"TCSETSW","","",null,null],[17,"TCSETSF","","",null,null],[17,"TCGETA","","",null,null],[17,"TCSETA","","",null,null],[17,"TCSETAW","","",null,null],[17,"TCSETAF","","",null,null],[17,"TCSBRK","","",null,null],[17,"TCXONC","","",null,null],[17,"TCFLSH","","",null,null],[17,"TIOCINQ","","",null,null],[17,"TIOCGPGRP","","",null,null],[17,"TIOCSPGRP","","",null,null],[17,"TIOCOUTQ","","",null,null],[17,"TIOCGWINSZ","","",null,null],[17,"TIOCSWINSZ","","",null,null],[17,"FIONREAD","","",null,null],[17,"R15","","",null,null],[17,"R14","","",null,null],[17,"R13","","",null,null],[17,"R12","","",null,null],[17,"RBP","","",null,null],[17,"RBX","","",null,null],[17,"R11","","",null,null],[17,"R10","","",null,null],[17,"R9","","",null,null],[17,"R8","","",null,null],[17,"RAX","","",null,null],[17,"RCX","","",null,null],[17,"RDX","","",null,null],[17,"RSI","","",null,null],[17,"RDI","","",null,null],[17,"ORIG_RAX","","",null,null],[17,"RIP","","",null,null],[17,"CS","","",null,null],[17,"EFLAGS","","",null,null],[17,"RSP","","",null,null],[17,"SS","","",null,null],[17,"FS_BASE","","",null,null],[17,"GS_BASE","","",null,null],[17,"DS","","",null,null],[17,"ES","","",null,null],[17,"FS","","",null,null],[17,"GS","","",null,null],[17,"__SIZEOF_PTHREAD_MUTEX_T","","",null,null],[17,"__SIZEOF_PTHREAD_RWLOCK_T","","",null,null],[17,"SYS_read","","",null,null],[17,"SYS_write","","",null,null],[17,"SYS_open","","",null,null],[17,"SYS_close","","",null,null],[17,"SYS_stat","","",null,null],[17,"SYS_fstat","","",null,null],[17,"SYS_lstat","","",null,null],[17,"SYS_poll","","",null,null],[17,"SYS_lseek","","",null,null],[17,"SYS_mmap","","",null,null],[17,"SYS_mprotect","","",null,null],[17,"SYS_munmap","","",null,null],[17,"SYS_brk","","",null,null],[17,"SYS_rt_sigaction","","",null,null],[17,"SYS_rt_sigprocmask","","",null,null],[17,"SYS_rt_sigreturn","","",null,null],[17,"SYS_ioctl","","",null,null],[17,"SYS_pread64","","",null,null],[17,"SYS_pwrite64","","",null,null],[17,"SYS_readv","","",null,null],[17,"SYS_writev","","",null,null],[17,"SYS_access","","",null,null],[17,"SYS_pipe","","",null,null],[17,"SYS_select","","",null,null],[17,"SYS_sched_yield","","",null,null],[17,"SYS_mremap","","",null,null],[17,"SYS_msync","","",null,null],[17,"SYS_mincore","","",null,null],[17,"SYS_madvise","","",null,null],[17,"SYS_shmget","","",null,null],[17,"SYS_shmat","","",null,null],[17,"SYS_shmctl","","",null,null],[17,"SYS_dup","","",null,null],[17,"SYS_dup2","","",null,null],[17,"SYS_pause","","",null,null],[17,"SYS_nanosleep","","",null,null],[17,"SYS_getitimer","","",null,null],[17,"SYS_alarm","","",null,null],[17,"SYS_setitimer","","",null,null],[17,"SYS_getpid","","",null,null],[17,"SYS_sendfile","","",null,null],[17,"SYS_socket","","",null,null],[17,"SYS_connect","","",null,null],[17,"SYS_accept","","",null,null],[17,"SYS_sendto","","",null,null],[17,"SYS_recvfrom","","",null,null],[17,"SYS_sendmsg","","",null,null],[17,"SYS_recvmsg","","",null,null],[17,"SYS_shutdown","","",null,null],[17,"SYS_bind","","",null,null],[17,"SYS_listen","","",null,null],[17,"SYS_getsockname","","",null,null],[17,"SYS_getpeername","","",null,null],[17,"SYS_socketpair","","",null,null],[17,"SYS_setsockopt","","",null,null],[17,"SYS_getsockopt","","",null,null],[17,"SYS_clone","","",null,null],[17,"SYS_fork","","",null,null],[17,"SYS_vfork","","",null,null],[17,"SYS_execve","","",null,null],[17,"SYS_exit","","",null,null],[17,"SYS_wait4","","",null,null],[17,"SYS_kill","","",null,null],[17,"SYS_uname","","",null,null],[17,"SYS_semget","","",null,null],[17,"SYS_semop","","",null,null],[17,"SYS_semctl","","",null,null],[17,"SYS_shmdt","","",null,null],[17,"SYS_msgget","","",null,null],[17,"SYS_msgsnd","","",null,null],[17,"SYS_msgrcv","","",null,null],[17,"SYS_msgctl","","",null,null],[17,"SYS_fcntl","","",null,null],[17,"SYS_flock","","",null,null],[17,"SYS_fsync","","",null,null],[17,"SYS_fdatasync","","",null,null],[17,"SYS_truncate","","",null,null],[17,"SYS_ftruncate","","",null,null],[17,"SYS_getdents","","",null,null],[17,"SYS_getcwd","","",null,null],[17,"SYS_chdir","","",null,null],[17,"SYS_fchdir","","",null,null],[17,"SYS_rename","","",null,null],[17,"SYS_mkdir","","",null,null],[17,"SYS_rmdir","","",null,null],[17,"SYS_creat","","",null,null],[17,"SYS_link","","",null,null],[17,"SYS_unlink","","",null,null],[17,"SYS_symlink","","",null,null],[17,"SYS_readlink","","",null,null],[17,"SYS_chmod","","",null,null],[17,"SYS_fchmod","","",null,null],[17,"SYS_chown","","",null,null],[17,"SYS_fchown","","",null,null],[17,"SYS_lchown","","",null,null],[17,"SYS_umask","","",null,null],[17,"SYS_gettimeofday","","",null,null],[17,"SYS_getrlimit","","",null,null],[17,"SYS_getrusage","","",null,null],[17,"SYS_sysinfo","","",null,null],[17,"SYS_times","","",null,null],[17,"SYS_ptrace","","",null,null],[17,"SYS_getuid","","",null,null],[17,"SYS_syslog","","",null,null],[17,"SYS_getgid","","",null,null],[17,"SYS_setuid","","",null,null],[17,"SYS_setgid","","",null,null],[17,"SYS_geteuid","","",null,null],[17,"SYS_getegid","","",null,null],[17,"SYS_setpgid","","",null,null],[17,"SYS_getppid","","",null,null],[17,"SYS_getpgrp","","",null,null],[17,"SYS_setsid","","",null,null],[17,"SYS_setreuid","","",null,null],[17,"SYS_setregid","","",null,null],[17,"SYS_getgroups","","",null,null],[17,"SYS_setgroups","","",null,null],[17,"SYS_setresuid","","",null,null],[17,"SYS_getresuid","","",null,null],[17,"SYS_setresgid","","",null,null],[17,"SYS_getresgid","","",null,null],[17,"SYS_getpgid","","",null,null],[17,"SYS_setfsuid","","",null,null],[17,"SYS_setfsgid","","",null,null],[17,"SYS_getsid","","",null,null],[17,"SYS_capget","","",null,null],[17,"SYS_capset","","",null,null],[17,"SYS_rt_sigpending","","",null,null],[17,"SYS_rt_sigtimedwait","","",null,null],[17,"SYS_rt_sigqueueinfo","","",null,null],[17,"SYS_rt_sigsuspend","","",null,null],[17,"SYS_sigaltstack","","",null,null],[17,"SYS_utime","","",null,null],[17,"SYS_mknod","","",null,null],[17,"SYS_uselib","","",null,null],[17,"SYS_personality","","",null,null],[17,"SYS_ustat","","",null,null],[17,"SYS_statfs","","",null,null],[17,"SYS_fstatfs","","",null,null],[17,"SYS_sysfs","","",null,null],[17,"SYS_getpriority","","",null,null],[17,"SYS_setpriority","","",null,null],[17,"SYS_sched_setparam","","",null,null],[17,"SYS_sched_getparam","","",null,null],[17,"SYS_sched_setscheduler","","",null,null],[17,"SYS_sched_getscheduler","","",null,null],[17,"SYS_sched_get_priority_max","","",null,null],[17,"SYS_sched_get_priority_min","","",null,null],[17,"SYS_sched_rr_get_interval","","",null,null],[17,"SYS_mlock","","",null,null],[17,"SYS_munlock","","",null,null],[17,"SYS_mlockall","","",null,null],[17,"SYS_munlockall","","",null,null],[17,"SYS_vhangup","","",null,null],[17,"SYS_modify_ldt","","",null,null],[17,"SYS_pivot_root","","",null,null],[17,"SYS__sysctl","","",null,null],[17,"SYS_prctl","","",null,null],[17,"SYS_arch_prctl","","",null,null],[17,"SYS_adjtimex","","",null,null],[17,"SYS_setrlimit","","",null,null],[17,"SYS_chroot","","",null,null],[17,"SYS_sync","","",null,null],[17,"SYS_acct","","",null,null],[17,"SYS_settimeofday","","",null,null],[17,"SYS_mount","","",null,null],[17,"SYS_umount2","","",null,null],[17,"SYS_swapon","","",null,null],[17,"SYS_swapoff","","",null,null],[17,"SYS_reboot","","",null,null],[17,"SYS_sethostname","","",null,null],[17,"SYS_setdomainname","","",null,null],[17,"SYS_iopl","","",null,null],[17,"SYS_ioperm","","",null,null],[17,"SYS_create_module","","",null,null],[17,"SYS_init_module","","",null,null],[17,"SYS_delete_module","","",null,null],[17,"SYS_get_kernel_syms","","",null,null],[17,"SYS_query_module","","",null,null],[17,"SYS_quotactl","","",null,null],[17,"SYS_nfsservctl","","",null,null],[17,"SYS_getpmsg","","",null,null],[17,"SYS_putpmsg","","",null,null],[17,"SYS_afs_syscall","","",null,null],[17,"SYS_tuxcall","","",null,null],[17,"SYS_security","","",null,null],[17,"SYS_gettid","","",null,null],[17,"SYS_readahead","","",null,null],[17,"SYS_setxattr","","",null,null],[17,"SYS_lsetxattr","","",null,null],[17,"SYS_fsetxattr","","",null,null],[17,"SYS_getxattr","","",null,null],[17,"SYS_lgetxattr","","",null,null],[17,"SYS_fgetxattr","","",null,null],[17,"SYS_listxattr","","",null,null],[17,"SYS_llistxattr","","",null,null],[17,"SYS_flistxattr","","",null,null],[17,"SYS_removexattr","","",null,null],[17,"SYS_lremovexattr","","",null,null],[17,"SYS_fremovexattr","","",null,null],[17,"SYS_tkill","","",null,null],[17,"SYS_time","","",null,null],[17,"SYS_futex","","",null,null],[17,"SYS_sched_setaffinity","","",null,null],[17,"SYS_sched_getaffinity","","",null,null],[17,"SYS_set_thread_area","","",null,null],[17,"SYS_io_setup","","",null,null],[17,"SYS_io_destroy","","",null,null],[17,"SYS_io_getevents","","",null,null],[17,"SYS_io_submit","","",null,null],[17,"SYS_io_cancel","","",null,null],[17,"SYS_get_thread_area","","",null,null],[17,"SYS_lookup_dcookie","","",null,null],[17,"SYS_epoll_create","","",null,null],[17,"SYS_epoll_ctl_old","","",null,null],[17,"SYS_epoll_wait_old","","",null,null],[17,"SYS_remap_file_pages","","",null,null],[17,"SYS_getdents64","","",null,null],[17,"SYS_set_tid_address","","",null,null],[17,"SYS_restart_syscall","","",null,null],[17,"SYS_semtimedop","","",null,null],[17,"SYS_fadvise64","","",null,null],[17,"SYS_timer_create","","",null,null],[17,"SYS_timer_settime","","",null,null],[17,"SYS_timer_gettime","","",null,null],[17,"SYS_timer_getoverrun","","",null,null],[17,"SYS_timer_delete","","",null,null],[17,"SYS_clock_settime","","",null,null],[17,"SYS_clock_gettime","","",null,null],[17,"SYS_clock_getres","","",null,null],[17,"SYS_clock_nanosleep","","",null,null],[17,"SYS_exit_group","","",null,null],[17,"SYS_epoll_wait","","",null,null],[17,"SYS_epoll_ctl","","",null,null],[17,"SYS_tgkill","","",null,null],[17,"SYS_utimes","","",null,null],[17,"SYS_vserver","","",null,null],[17,"SYS_mbind","","",null,null],[17,"SYS_set_mempolicy","","",null,null],[17,"SYS_get_mempolicy","","",null,null],[17,"SYS_mq_open","","",null,null],[17,"SYS_mq_unlink","","",null,null],[17,"SYS_mq_timedsend","","",null,null],[17,"SYS_mq_timedreceive","","",null,null],[17,"SYS_mq_notify","","",null,null],[17,"SYS_mq_getsetattr","","",null,null],[17,"SYS_kexec_load","","",null,null],[17,"SYS_waitid","","",null,null],[17,"SYS_add_key","","",null,null],[17,"SYS_request_key","","",null,null],[17,"SYS_keyctl","","",null,null],[17,"SYS_ioprio_set","","",null,null],[17,"SYS_ioprio_get","","",null,null],[17,"SYS_inotify_init","","",null,null],[17,"SYS_inotify_add_watch","","",null,null],[17,"SYS_inotify_rm_watch","","",null,null],[17,"SYS_migrate_pages","","",null,null],[17,"SYS_openat","","",null,null],[17,"SYS_mkdirat","","",null,null],[17,"SYS_mknodat","","",null,null],[17,"SYS_fchownat","","",null,null],[17,"SYS_futimesat","","",null,null],[17,"SYS_newfstatat","","",null,null],[17,"SYS_unlinkat","","",null,null],[17,"SYS_renameat","","",null,null],[17,"SYS_linkat","","",null,null],[17,"SYS_symlinkat","","",null,null],[17,"SYS_readlinkat","","",null,null],[17,"SYS_fchmodat","","",null,null],[17,"SYS_faccessat","","",null,null],[17,"SYS_pselect6","","",null,null],[17,"SYS_ppoll","","",null,null],[17,"SYS_unshare","","",null,null],[17,"SYS_set_robust_list","","",null,null],[17,"SYS_get_robust_list","","",null,null],[17,"SYS_splice","","",null,null],[17,"SYS_tee","","",null,null],[17,"SYS_sync_file_range","","",null,null],[17,"SYS_vmsplice","","",null,null],[17,"SYS_move_pages","","",null,null],[17,"SYS_utimensat","","",null,null],[17,"SYS_epoll_pwait","","",null,null],[17,"SYS_signalfd","","",null,null],[17,"SYS_timerfd_create","","",null,null],[17,"SYS_eventfd","","",null,null],[17,"SYS_fallocate","","",null,null],[17,"SYS_timerfd_settime","","",null,null],[17,"SYS_timerfd_gettime","","",null,null],[17,"SYS_accept4","","",null,null],[17,"SYS_signalfd4","","",null,null],[17,"SYS_eventfd2","","",null,null],[17,"SYS_epoll_create1","","",null,null],[17,"SYS_dup3","","",null,null],[17,"SYS_pipe2","","",null,null],[17,"SYS_inotify_init1","","",null,null],[17,"SYS_preadv","","",null,null],[17,"SYS_pwritev","","",null,null],[17,"SYS_rt_tgsigqueueinfo","","",null,null],[17,"SYS_perf_event_open","","",null,null],[17,"SYS_recvmmsg","","",null,null],[17,"SYS_fanotify_init","","",null,null],[17,"SYS_fanotify_mark","","",null,null],[17,"SYS_prlimit64","","",null,null],[17,"SYS_name_to_handle_at","","",null,null],[17,"SYS_open_by_handle_at","","",null,null],[17,"SYS_clock_adjtime","","",null,null],[17,"SYS_syncfs","","",null,null],[17,"SYS_sendmmsg","","",null,null],[17,"SYS_setns","","",null,null],[17,"SYS_getcpu","","",null,null],[17,"SYS_process_vm_readv","","",null,null],[17,"SYS_process_vm_writev","","",null,null],[17,"SYS_kcmp","","",null,null],[17,"SYS_finit_module","","",null,null],[17,"SYS_sched_setattr","","",null,null],[17,"SYS_sched_getattr","","",null,null],[17,"SYS_renameat2","","",null,null],[17,"SYS_seccomp","","",null,null],[17,"SYS_getrandom","","",null,null],[17,"SYS_memfd_create","","",null,null],[17,"SYS_kexec_file_load","","",null,null],[17,"SYS_bpf","","",null,null],[17,"SYS_execveat","","",null,null],[17,"SYS_userfaultfd","","",null,null],[17,"SYS_membarrier","","",null,null],[17,"SYS_mlock2","","",null,null],[17,"SYS_copy_file_range","","",null,null],[17,"SYS_preadv2","","",null,null],[17,"SYS_pwritev2","","",null,null],[17,"SYS_pkey_mprotect","","",null,null],[17,"SYS_pkey_alloc","","",null,null],[17,"SYS_pkey_free","","",null,null],[11,"is_some","libc::dox::imp","Returns `true` if the option is a [`Some`] value.",123,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"is_none","","Returns `true` if the option is a [`None`] value.",123,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"as_ref","","Converts from `Option<T>` to `Option<&T>`.",123,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"as_mut","","Converts from `Option<T>` to `Option<&mut T>`.",123,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"as_pin_mut","","Converts from `Option<T>` to `Option<PinMut<'_, T>>`",123,{"i":[{"g":["option"],"n":"pinmut"}],"o":{"g":["pinmut"],"n":"option"}}],[11,"expect","","Unwraps an option, yielding the content of a [`Some`].",123,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"t"}}],[11,"unwrap","","Moves the value `v` out of the `Option<T>` if it is [`Some(v)`].",123,{"i":[{"n":"self"}],"o":{"n":"t"}}],[11,"unwrap_or","","Returns the contained value or a default.",123,{"i":[{"n":"self"},{"n":"t"}],"o":{"n":"t"}}],[11,"unwrap_or_else","","Returns the contained value or computes it from a closure.",123,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"t"}}],[11,"map","","Maps an `Option<T>` to `Option<U>` by applying a function to a contained value.",123,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"option"}}],[11,"map_or","","Applies a function to the contained value (if any), or returns the provided default (if not).",123,{"i":[{"n":"self"},{"n":"u"},{"n":"f"}],"o":{"n":"u"}}],[11,"map_or_else","","Applies a function to the contained value (if any), or computes a default (if not).",123,{"i":[{"n":"self"},{"n":"d"},{"n":"f"}],"o":{"n":"u"}}],[11,"ok_or","","Transforms the `Option<T>` into a [`Result<T, E>`], mapping [`Some(v)`] to [`Ok(v)`] and [`None`] to [`Err(err)`].",123,{"i":[{"n":"self"},{"n":"e"}],"o":{"n":"result"}}],[11,"ok_or_else","","Transforms the `Option<T>` into a [`Result<T, E>`], mapping [`Some(v)`] to [`Ok(v)`] and [`None`] to [`Err(err())`].",123,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"result"}}],[11,"iter","","Returns an iterator over the possibly contained value.",123,{"i":[{"n":"self"}],"o":{"n":"iter"}}],[11,"iter_mut","","Returns a mutable iterator over the possibly contained value.",123,{"i":[{"n":"self"}],"o":{"n":"itermut"}}],[11,"and","","Returns [`None`] if the option is [`None`], otherwise returns `optb`.",123,{"i":[{"n":"self"},{"n":"option"}],"o":{"n":"option"}}],[11,"and_then","","Returns [`None`] if the option is [`None`], otherwise calls `f` with the wrapped value and returns the result.",123,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"option"}}],[11,"filter","","Returns `None` if the option is `None`, otherwise calls `predicate` with the wrapped value and returns:",123,{"i":[{"n":"self"},{"n":"p"}],"o":{"n":"option"}}],[11,"or","","Returns the option if it contains a value, otherwise returns `optb`.",123,{"i":[{"n":"self"},{"n":"option"}],"o":{"n":"option"}}],[11,"or_else","","Returns the option if it contains a value, otherwise calls `f` and returns the result.",123,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"option"}}],[11,"xor","","Returns [`Some`] if exactly one of `self`, `optb` is [`Some`], otherwise returns `None`.",123,{"i":[{"n":"self"},{"n":"option"}],"o":{"n":"option"}}],[11,"get_or_insert","","Inserts `v` into the option if it is [`None`], then returns a mutable reference to the contained value.",123,{"i":[{"n":"self"},{"n":"t"}],"o":{"n":"t"}}],[11,"get_or_insert_with","","Inserts a value computed from `f` into the option if it is [`None`], then returns a mutable reference to the contained value.",123,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"t"}}],[11,"take","","Takes the value out of the option, leaving a [`None`] in its place.",123,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"cloned","","Maps an `Option<&T>` to an `Option<T>` by cloning the contents of the option.",123,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"cloned","","Maps an `Option<&mut T>` to an `Option<T>` by cloning the contents of the option.",123,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"unwrap_or_default","","Returns the contained value or a default",123,{"i":[{"n":"self"}],"o":{"n":"t"}}],[11,"transpose","","Transposes an `Option` of a `Result` into a `Result` of an `Option`.",123,{"i":[{"n":"self"}],"o":{"g":["option"],"n":"result"}}],[11,"fmt","libc::dox::imp::mem","",127,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"deref_mut","","",127,{"i":[{"n":"self"}],"o":{"n":"t"}}],[11,"deref_mut","","",126,null],[11,"into_result","libc::dox::imp","",123,{"i":[{"n":"self"}],"o":{"g":["noneerror"],"n":"result"}}],[11,"from_ok","","",123,{"i":[{"n":"t"}],"o":{"n":"option"}}],[11,"from_error","","",123,{"i":[{"n":"noneerror"}],"o":{"n":"option"}}],[11,"deref","libc::dox::imp::mem","",127,{"i":[{"n":"self"}],"o":{"n":"t"}}],[11,"deref","","",126,null],[11,"fmt","","",126,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","","",125,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","libc::dox::imp","",123,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","libc::dox::imp::mem","",127,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"default","","",126,{"o":{"n":"manuallydrop"}}],[11,"default","libc::dox::imp","Returns [`None`].",123,{"o":{"n":"option"}}],[11,"into_iter","","Returns a consuming iterator over the possibly contained value.",123,{"i":[{"n":"self"}],"o":{"n":"intoiter"}}],[11,"from","","",123,{"i":[{"n":"t"}],"o":{"n":"option"}}],[11,"poll","libc::dox::imp::mem","",127,{"i":[{"g":["pinmut"],"n":"pinmut"},{"n":"context"}],"o":{"n":"poll"}}],[11,"clone","","",126,{"i":[{"n":"self"}],"o":{"n":"manuallydrop"}}],[11,"clone_from","","",126,null],[11,"clone","libc::dox::imp","",123,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"clone","libc::dox::imp::mem","",125,{"i":[{"n":"self"}],"o":{"n":"discriminant"}}],[11,"partial_cmp","libc::dox::imp","",123,{"i":[{"n":"self"},{"n":"option"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",123,{"i":[{"n":"self"},{"n":"option"}],"o":{"n":"bool"}}],[11,"le","","",123,{"i":[{"n":"self"},{"n":"option"}],"o":{"n":"bool"}}],[11,"gt","","",123,{"i":[{"n":"self"},{"n":"option"}],"o":{"n":"bool"}}],[11,"ge","","",123,{"i":[{"n":"self"},{"n":"option"}],"o":{"n":"bool"}}],[11,"partial_cmp","libc::dox::imp::mem","",126,{"i":[{"n":"self"},{"n":"manuallydrop"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",126,{"i":[{"n":"self"},{"n":"manuallydrop"}],"o":{"n":"bool"}}],[11,"le","","",126,{"i":[{"n":"self"},{"n":"manuallydrop"}],"o":{"n":"bool"}}],[11,"gt","","",126,{"i":[{"n":"self"},{"n":"manuallydrop"}],"o":{"n":"bool"}}],[11,"ge","","",126,{"i":[{"n":"self"},{"n":"manuallydrop"}],"o":{"n":"bool"}}],[11,"cmp","","",126,{"i":[{"n":"self"},{"n":"manuallydrop"}],"o":{"n":"ordering"}}],[11,"cmp","libc::dox::imp","",123,{"i":[{"n":"self"},{"n":"option"}],"o":{"n":"ordering"}}],[11,"from_iter","","Takes each element in the [`Iterator`]: if it is [`None`], no further elements are taken, and the [`None`] is returned. Should no [`None`] occur, a container with the values of each `Option` is returned.",123,{"i":[{"n":"i"}],"o":{"n":"option"}}],[11,"assert_receiver_is_total_eq","","",123,null],[11,"eq","libc::dox::imp::mem","",126,{"i":[{"n":"self"},{"n":"manuallydrop"}],"o":{"n":"bool"}}],[11,"ne","","",126,{"i":[{"n":"self"},{"n":"manuallydrop"}],"o":{"n":"bool"}}],[11,"eq","libc::dox::imp","",123,{"i":[{"n":"self"},{"n":"option"}],"o":{"n":"bool"}}],[11,"ne","","",123,{"i":[{"n":"self"},{"n":"option"}],"o":{"n":"bool"}}],[11,"eq","libc::dox::imp::mem","",125,{"i":[{"n":"self"},{"n":"discriminant"}],"o":{"n":"bool"}}],[11,"fmt","","",127,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"g":["error"],"n":"result"}}],[11,"hash","libc::dox::imp","",123,null],[11,"hash","libc::dox::imp::mem","",125,null],[11,"hash","","",126,null],[11,"new","","Wrap a value to be manually dropped.",126,{"i":[{"n":"t"}],"o":{"n":"manuallydrop"}}],[11,"into_inner","","Extract the value from the ManuallyDrop container.",126,{"i":[{"n":"manuallydrop"}],"o":{"n":"t"}}],[11,"drop","","Manually drops the contained value.",126,null],[11,"new","","Construct a new `PinMut` around a reference to some data of a type that implements `Unpin`.",127,{"i":[{"n":"t"}],"o":{"n":"pinmut"}}],[11,"new_unchecked","","Construct a new `PinMut` around a reference to some data of a type that may or may not implement `Unpin`.",127,{"i":[{"n":"t"}],"o":{"n":"pinmut"}}],[11,"reborrow","","Reborrow a `PinMut` for a shorter lifetime.",127,{"i":[{"n":"self"}],"o":{"n":"pinmut"}}],[11,"get_mut","","Get a mutable reference to the data inside of this `PinMut`.",127,{"i":[{"n":"pinmut"}],"o":{"n":"t"}}],[11,"map","","Construct a new pin by mapping the interior value.",127,{"i":[{"n":"pinmut"},{"n":"f"}],"o":{"n":"pinmut"}}],[11,"set","","Assign a new value to the memory behind the pinned reference.",127,null]],"paths":[[3,"group"],[3,"utimbuf"],[3,"timeval"],[3,"timespec"],[3,"rlimit"],[3,"rusage"],[3,"in_addr"],[3,"in6_addr"],[3,"ip_mreq"],[3,"ipv6_mreq"],[3,"hostent"],[3,"iovec"],[3,"pollfd"],[3,"winsize"],[3,"linger"],[3,"sigval"],[3,"itimerval"],[3,"tms"],[3,"servent"],[3,"protoent"],[3,"sockaddr"],[3,"sockaddr_in"],[3,"sockaddr_in6"],[3,"sockaddr_un"],[3,"sockaddr_storage"],[3,"addrinfo"],[3,"sockaddr_nl"],[3,"sockaddr_ll"],[3,"fd_set"],[3,"tm"],[3,"sched_param"],[3,"Dl_info"],[3,"epoll_event"],[3,"utsname"],[3,"lconv"],[3,"sigevent"],[3,"dirent"],[3,"dirent64"],[3,"rlimit64"],[3,"glob_t"],[3,"ifaddrs"],[3,"pthread_mutex_t"],[3,"pthread_rwlock_t"],[3,"pthread_mutexattr_t"],[3,"pthread_rwlockattr_t"],[3,"pthread_cond_t"],[3,"pthread_condattr_t"],[3,"passwd"],[3,"spwd"],[3,"statvfs"],[3,"dqblk"],[3,"signalfd_siginfo"],[3,"itimerspec"],[3,"fsid_t"],[3,"mq_attr"],[3,"cpu_set_t"],[3,"if_nameindex"],[3,"msginfo"],[3,"mmsghdr"],[3,"sembuf"],[3,"input_event"],[3,"input_id"],[3,"input_absinfo"],[3,"input_keymap_entry"],[3,"input_mask"],[3,"ff_replay"],[3,"ff_trigger"],[3,"ff_envelope"],[3,"ff_constant_effect"],[3,"ff_ramp_effect"],[3,"ff_condition_effect"],[3,"ff_periodic_effect"],[3,"ff_rumble_effect"],[3,"ff_effect"],[3,"dl_phdr_info"],[3,"Elf32_Phdr"],[3,"Elf64_Phdr"],[3,"ucred"],[3,"mntent"],[3,"posix_spawn_file_actions_t"],[3,"posix_spawnattr_t"],[3,"genlmsghdr"],[3,"aiocb"],[3,"__exit_status"],[3,"__timeval"],[3,"utmpx"],[3,"sigaction"],[3,"stack_t"],[3,"siginfo_t"],[3,"glob64_t"],[3,"statfs"],[3,"msghdr"],[3,"cmsghdr"],[3,"termios"],[3,"flock"],[3,"sem_t"],[3,"mallinfo"],[3,"nlmsghdr"],[3,"nlmsgerr"],[3,"nl_pktinfo"],[3,"nl_mmap_req"],[3,"nl_mmap_hdr"],[3,"nlattr"],[3,"sigset_t"],[3,"sysinfo"],[3,"msqid_ds"],[3,"stat"],[3,"stat64"],[3,"statfs64"],[3,"statvfs64"],[3,"pthread_attr_t"],[3,"_libc_fpxreg"],[3,"_libc_xmmreg"],[3,"_libc_fpstate"],[3,"user_fpregs_struct"],[3,"user_regs_struct"],[3,"user"],[3,"mcontext_t"],[3,"ucontext_t"],[3,"ipc_perm"],[3,"shmid_ds"],[3,"termios2"],[4,"c_void"],[4,"Option"],[8,"Clone"],[3,"Discriminant"],[19,"ManuallyDrop"],[3,"PinMut"]]};
searchIndex["memchr"] = {"doc":"This crate defines two functions, `memchr` and `memrchr`, which expose a safe interface to the corresponding functions in `libc`.","items":[[3,"Memchr","memchr","An iterator for memchr",null,null],[12,"needle","","",0,null],[12,"haystack","","",0,null],[12,"position","","",0,null],[3,"Memchr2","","An iterator for Memchr2",null,null],[12,"needle1","","",1,null],[12,"needle2","","",1,null],[12,"haystack","","",1,null],[12,"position","","",1,null],[3,"Memchr3","","An iterator for Memchr3",null,null],[12,"needle1","","",2,null],[12,"needle2","","",2,null],[12,"needle3","","",2,null],[12,"haystack","","",2,null],[12,"position","","",2,null],[5,"contains_zero_byte","","Return `true` if `x` contains any zero byte.",null,{"i":[{"n":"usize"}],"o":{"n":"bool"}}],[5,"repeat_byte","","",null,{"i":[{"n":"u8"}],"o":{"n":"usize"}}],[5,"memchr","","A safe interface to `memchr`.",null,null],[5,"memrchr","","A safe interface to `memrchr`.",null,null],[5,"memchr2","","Like `memchr`, but searches for two bytes instead of one.",null,null],[5,"memchr3","","Like `memchr`, but searches for three bytes instead of one.",null,null],[17,"LO_U64","","",null,null],[17,"HI_U64","","",null,null],[17,"LO_USIZE","","",null,null],[17,"HI_USIZE","","",null,null],[17,"USIZE_BYTES","","",null,null],[11,"new","","Creates a new iterator that yields all positions of needle in haystack.",0,null],[11,"next","","",0,{"i":[{"n":"self"}],"o":{"g":["usize"],"n":"option"}}],[11,"size_hint","","",0,null],[11,"next_back","","",0,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"new","","Creates a new iterator that yields all positions of needle in haystack.",1,null],[11,"next","","",1,{"i":[{"n":"self"}],"o":{"g":["usize"],"n":"option"}}],[11,"size_hint","","",1,null],[11,"new","","Create a new Memchr2 that's initalized to zero with a haystack",2,null],[11,"next","","",2,{"i":[{"n":"self"}],"o":{"g":["usize"],"n":"option"}}],[11,"size_hint","","",2,null]],"paths":[[3,"Memchr"],[3,"Memchr2"],[3,"Memchr3"]]};
searchIndex["minifier"] = {"doc":"","items":[[0,"html","minifier","",null,null],[5,"condense_whitespace","minifier::html","",null,{"i":[{"n":"str"}],"o":{"n":"string"}}],[5,"condense","","",null,{"i":[{"n":"str"}],"o":{"n":"string"}}],[5,"clean_unneeded_tags","","",null,{"i":[{"n":"str"}],"o":{"n":"string"}}],[5,"remove_comments","","",null,{"i":[{"n":"str"}],"o":{"n":"string"}}],[5,"unquote_attributes","","",null,{"i":[{"n":"str"}],"o":{"n":"string"}}],[5,"minify","","Returns a minified version of the provided HTML source.",null,{"i":[{"n":"str"}],"o":{"n":"string"}}],[0,"js","minifier","",null,null],[0,"token","minifier::js","",null,null],[3,"Tokens","minifier::js::token","",null,null],[12,"0","","",0,null],[4,"ReservedChar","","",null,null],[13,"Comma","","",1,null],[13,"OpenParenthese","","",1,null],[13,"CloseParenthese","","",1,null],[13,"OpenCurlyBrace","","",1,null],[13,"CloseCurlyBrace","","",1,null],[13,"OpenBracket","","",1,null],[13,"CloseBracket","","",1,null],[13,"Colon","","",1,null],[13,"SemiColon","","",1,null],[13,"Dot","","",1,null],[13,"Quote","","",1,null],[13,"DoubleQuote","","",1,null],[13,"ExclamationMark","","",1,null],[13,"QuestionMark","","",1,null],[13,"Slash","","",1,null],[13,"Modulo","","",1,null],[13,"Star","","",1,null],[13,"Minus","","",1,null],[13,"Plus","","",1,null],[13,"EqualSign","","",1,null],[13,"Backslash","","",1,null],[13,"Space","","",1,null],[13,"Tab","","",1,null],[13,"Backline","","",1,null],[13,"LessThan","","",1,null],[13,"SuperiorThan","","",1,null],[13,"Pipe","","",1,null],[13,"Ampersand","","",1,null],[4,"Keyword","","",null,null],[13,"Break","","",2,null],[13,"Case","","",2,null],[13,"Catch","","",2,null],[13,"Const","","",2,null],[13,"Continue","","",2,null],[13,"Default","","",2,null],[13,"Do","","",2,null],[13,"Else","","",2,null],[13,"False","","",2,null],[13,"Finally","","",2,null],[13,"Function","","",2,null],[13,"For","","",2,null],[13,"If","","",2,null],[13,"In","","",2,null],[13,"InstanceOf","","",2,null],[13,"New","","",2,null],[13,"Null","","",2,null],[13,"Private","","",2,null],[13,"Protected","","",2,null],[13,"Public","","",2,null],[13,"Return","","",2,null],[13,"Switch","","",2,null],[13,"This","","",2,null],[13,"Throw","","",2,null],[13,"True","","",2,null],[13,"Try","","",2,null],[13,"Typeof","","",2,null],[13,"Static","","",2,null],[13,"Var","","",2,null],[13,"While","","",2,null],[4,"Condition","","",null,null],[13,"And","","",3,null],[13,"Or","","",3,null],[13,"DifferentThan","","",3,null],[13,"SuperDifferentThan","","",3,null],[13,"EqualTo","","",3,null],[13,"SuperEqualTo","","",3,null],[13,"SuperiorThan","","",3,null],[13,"SuperiorOrEqualTo","","",3,null],[13,"InferiorThan","","",3,null],[13,"InferiorOrEqualTo","","",3,null],[4,"Operation","","",null,null],[13,"Addition","","",4,null],[13,"AdditionEqual","","",4,null],[13,"Subtract","","",4,null],[13,"SubtractEqual","","",4,null],[13,"Multiply","","",4,null],[13,"MultiplyEqual","","",4,null],[13,"Divide","","",4,null],[13,"DivideEqual","","",4,null],[13,"Modulo","","",4,null],[13,"ModuloEqual","","",4,null],[13,"Equal","","",4,null],[4,"Token","","",null,null],[13,"Keyword","","",5,null],[13,"Char","","",5,null],[13,"String","","",5,null],[13,"Comment","","",5,null],[13,"License","","",5,null],[13,"Other","","",5,null],[13,"Regex","","",5,null],[12,"regex","minifier::js::token::Token","",5,null],[12,"is_global","","",5,null],[12,"is_interactive","","",5,null],[13,"Condition","minifier::js::token","",5,null],[13,"Operation","","",5,null],[5,"get_required","","",null,{"i":[{"n":"token"}],"o":{"g":["char"],"n":"option"}}],[5,"get_line_comment","","",null,{"i":[{"n":"str"},{"n":"peekable"},{"n":"usize"}],"o":{"g":["token"],"n":"option"}}],[5,"get_regex","","",null,{"i":[{"n":"str"},{"n":"peekable"},{"n":"usize"}],"o":{"g":["token"],"n":"option"}}],[5,"get_comment","","",null,{"i":[{"n":"str"},{"n":"peekable"},{"n":"usize"}],"o":{"g":["token"],"n":"option"}}],[5,"get_string","","",null,{"i":[{"n":"str"},{"n":"peekable"},{"n":"usize"},{"n":"reservedchar"}],"o":{"g":["token"],"n":"option"}}],[5,"first_useful","","",null,null],[5,"tokenize","","",null,{"i":[{"n":"str"}],"o":{"n":"tokens"}}],[5,"clean_tokens","","",null,{"i":[{"n":"tokens"}]}],[8,"MyTryFrom","","",null,null],[16,"Error","","",6,null],[10,"try_from","","",6,{"i":[{"n":"t"}],"o":{"n":"result"}}],[11,"fmt","","",1,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"eq","","",1,{"i":[{"n":"self"},{"n":"reservedchar"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",1,null],[11,"clone","","",1,{"i":[{"n":"self"}],"o":{"n":"reservedchar"}}],[11,"is_useless","","",1,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"fmt","","",1,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"try_from","","",1,{"i":[{"n":"char"}],"o":{"g":["reservedchar"],"n":"result"}}],[11,"fmt","","",2,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"eq","","",2,{"i":[{"n":"self"},{"n":"keyword"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",2,null],[11,"clone","","",2,{"i":[{"n":"self"}],"o":{"n":"keyword"}}],[11,"fmt","","",2,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"try_from","","",2,{"i":[{"n":"str"}],"o":{"g":["keyword"],"n":"result"}}],[11,"fmt","","",3,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"eq","","",3,{"i":[{"n":"self"},{"n":"condition"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",3,null],[11,"clone","","",3,{"i":[{"n":"self"}],"o":{"n":"condition"}}],[11,"fmt","","",3,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",4,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"eq","","",4,{"i":[{"n":"self"},{"n":"operation"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",4,null],[11,"clone","","",4,{"i":[{"n":"self"}],"o":{"n":"operation"}}],[11,"fmt","","",4,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"try_from","","",4,{"i":[{"n":"reservedchar"}],"o":{"g":["operation"],"n":"result"}}],[11,"fmt","","",5,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"eq","","",5,{"i":[{"n":"self"},{"n":"token"}],"o":{"n":"bool"}}],[11,"ne","","",5,{"i":[{"n":"self"},{"n":"token"}],"o":{"n":"bool"}}],[11,"fmt","","",5,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"is_comment","","",5,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"get_char","","",5,{"i":[{"n":"self"}],"o":{"g":["reservedchar"],"n":"option"}}],[11,"is_condition","","",5,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"is_other","","",5,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"is_white_character","","",5,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"fmt","","",0,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[0,"js","minifier::js","",null,null],[5,"minify","minifier::js::js","",null,{"i":[{"n":"str"}],"o":{"n":"string"}}]],"paths":[[3,"Tokens"],[4,"ReservedChar"],[4,"Keyword"],[4,"Condition"],[4,"Operation"],[4,"Token"],[8,"MyTryFrom"]]};
searchIndex["proc_macro"] = {"doc":"A support library for macro authors when defining new macros.","items":[[3,"Diagnostic","proc_macro","A structure representing a diagnostic message and associated children messages.",null,null],[12,"level","","",0,null],[12,"message","","",0,null],[12,"span","","",0,null],[12,"children","","",0,null],[3,"TokenStream","","The main type provided by this crate, representing an abstract stream of tokens, or, more specifically, a sequence of token trees. The type provide interfaces for iterating over those token trees and, conversely, collecting a number of token trees into one stream.",null,null],[12,"0","","",1,null],[3,"LexError","","Error returned from `TokenStream::from_str`.",null,null],[12,"_inner","","",2,null],[3,"Span","","A region of source code, along with macro expansion information.",null,null],[12,"0","","",3,null],[3,"LineColumn","","A line-column pair representing the start or end of a `Span`.",null,null],[12,"line","","The 1-indexed line in the source file on which the span starts or ends (inclusive).",4,null],[12,"column","","The 0-indexed column (in UTF-8 characters) in the source file on which the span starts or ends (inclusive).",4,null],[3,"SourceFile","","The source file of a given `Span`.",null,null],[12,"filemap","","",5,null],[3,"Group","","A delimited token stream.",null,null],[12,"delimiter","","",6,null],[12,"stream","","",6,null],[12,"span","","",6,null],[3,"Punct","","An `Punct` is an single punctuation character like `+`, `-` or `#`.",null,null],[12,"ch","","",7,null],[12,"spacing","","",7,null],[12,"span","","",7,null],[3,"Ident","","An identifier (`ident`).",null,null],[12,"sym","","",8,null],[12,"span","","",8,null],[12,"is_raw","","",8,null],[3,"Literal","","A literal string (`\"hello\"`), byte string (`b\"hello\"`), character (`'a'`), byte character (`b'a'`), an integer or floating point number with or without a suffix (`1`, `1u8`, `2.3`, `2.3f32`). Boolean literals like `true` and `false` do not belong here, they are `Ident`s.",null,null],[12,"lit","","",9,null],[12,"suffix","","",9,null],[12,"span","","",9,null],[4,"Level","","An enum representing a diagnostic level.",null,null],[13,"Error","","An error.",10,null],[13,"Warning","","A warning.",10,null],[13,"Note","","A note.",10,null],[13,"Help","","A help message.",10,null],[13,"__Nonexhaustive","","",10,null],[4,"TokenTree","","A single token or a delimited sequence of token trees (e.g. `[1, (), ..]`).",null,null],[13,"Group","","A token stream surrounded by bracket delimiters.",11,null],[13,"Ident","","An identifier.",11,null],[13,"Punct","","A single punctuation character (`+`, `,`, `$`, etc.).",11,null],[13,"Literal","","A literal character (`'a'`), string (`\"hello\"`), number (`2.3`), etc.",11,null],[4,"Delimiter","","Describes how a sequence of token trees is delimited.",null,null],[13,"Parenthesis","","`( ... )`",12,null],[13,"Brace","","`{ ... }`",12,null],[13,"Bracket","","`[ ... ]`",12,null],[13,"None","","`Ø ... Ø` An implicit delimiter, that may, for example, appear around tokens coming from a \"macro variable\" `$var`. It is important to preserve operator priorities in cases like `$var * 3` where `$var` is `1 + 2`. Implicit delimiters may not survive roundtrip of a token stream through a string.",12,null],[4,"Spacing","","Whether an `Punct` is followed immediately by another `Punct` or followed by another token or whitespace.",null,null],[13,"Alone","","E.g. `+` is `Alone` in `+ =`, `+ident` or `+()`.",13,null],[13,"Joint","","E.g. `+` is `Joint` in `+=` or `'#`. Additionally, single quote `'` can join with identifiers to form lifetimes `'ident`.",13,null],[5,"quote_span","","Quote a `Span` into a `TokenStream`. This is needed to implement a custom quoter.",null,{"i":[{"n":"span"}],"o":{"n":"tokenstream"}}],[5,"parse_to_lex_err","","",null,{"i":[{"n":"diagnosticbuilder"}],"o":{"n":"lexerror"}}],[0,"diagnostic","","",null,null],[3,"Diagnostic","proc_macro::diagnostic","A structure representing a diagnostic message and associated children messages.",null,null],[12,"level","","",0,null],[12,"message","","",0,null],[12,"span","","",0,null],[12,"children","","",0,null],[4,"Level","","An enum representing a diagnostic level.",null,null],[13,"Error","","An error.",10,null],[13,"Warning","","A warning.",10,null],[13,"Note","","A note.",10,null],[13,"Help","","A help message.",10,null],[13,"__Nonexhaustive","","",10,null],[0,"__internal","","",null,null],[5,"level_to_internal_level","proc_macro::diagnostic::__internal","",null,{"i":[{"n":"level"}],"o":{"n":"level"}}],[11,"clone","proc_macro","",10,{"i":[{"n":"self"}],"o":{"n":"level"}}],[11,"fmt","","",10,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",0,{"i":[{"n":"self"}],"o":{"n":"diagnostic"}}],[11,"fmt","","",0,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","Create a new diagnostic with the given `level` and `message`.",0,{"i":[{"n":"level"},{"n":"t"}],"o":{"n":"diagnostic"}}],[11,"spanned","","Create a new diagnostic with the given `level` and `message` pointing to the given `span`.",0,{"i":[{"n":"span"},{"n":"level"},{"n":"t"}],"o":{"n":"diagnostic"}}],[11,"span_error","","Add a new child diagnostic message to `self` with the level identified by this methods name with the given `span` and `message`.",0,{"i":[{"n":"self"},{"n":"span"},{"n":"t"}],"o":{"n":"diagnostic"}}],[11,"error","","Add a new child diagnostic message to `self` with the level identified by this method's name with the given `message`.",0,{"i":[{"n":"self"},{"n":"t"}],"o":{"n":"diagnostic"}}],[11,"span_warning","","Add a new child diagnostic message to `self` with the level identified by this methods name with the given `span` and `message`.",0,{"i":[{"n":"self"},{"n":"span"},{"n":"t"}],"o":{"n":"diagnostic"}}],[11,"warning","","Add a new child diagnostic message to `self` with the level identified by this method's name with the given `message`.",0,{"i":[{"n":"self"},{"n":"t"}],"o":{"n":"diagnostic"}}],[11,"span_note","","Add a new child diagnostic message to `self` with the level identified by this methods name with the given `span` and `message`.",0,{"i":[{"n":"self"},{"n":"span"},{"n":"t"}],"o":{"n":"diagnostic"}}],[11,"note","","Add a new child diagnostic message to `self` with the level identified by this method's name with the given `message`.",0,{"i":[{"n":"self"},{"n":"t"}],"o":{"n":"diagnostic"}}],[11,"span_help","","Add a new child diagnostic message to `self` with the level identified by this methods name with the given `span` and `message`.",0,{"i":[{"n":"self"},{"n":"span"},{"n":"t"}],"o":{"n":"diagnostic"}}],[11,"help","","Add a new child diagnostic message to `self` with the level identified by this method's name with the given `message`.",0,{"i":[{"n":"self"},{"n":"t"}],"o":{"n":"diagnostic"}}],[11,"level","","Returns the diagnostic `level` for `self`.",0,{"i":[{"n":"self"}],"o":{"n":"level"}}],[11,"emit","","Emit the diagnostic.",0,{"i":[{"n":"self"}]}],[0,"token_stream","","Public implementation details for the `TokenStream` type, such as iterators.",null,null],[3,"IntoIter","proc_macro::token_stream","An iterator over `TokenStream`'s `TokenTree`s. The iteration is \"shallow\", e.g. the iterator doesn't recurse into delimited groups, and returns whole groups as token trees.",null,null],[12,"cursor","","",14,null],[12,"stack","","",14,null],[11,"clone","","",14,{"i":[{"n":"self"}],"o":{"n":"intoiter"}}],[11,"next","","",14,{"i":[{"n":"self"}],"o":{"g":["tokentree"],"n":"option"}}],[11,"into_iter","proc_macro","",1,{"i":[{"n":"self"}],"o":{"n":"intoiter"}}],[0,"quote","","Quasiquoter This file contains the implementation internals of the quasiquoter provided by `quote!`. This quasiquoter uses macros 2.0 hygiene to reliably access items from `proc_macro`, to build a `proc_macro::TokenStream`.",null,null],[3,"Quoter","proc_macro::quote","",null,null],[3,"SpannedSymbol","","",null,null],[12,"sym","","",15,null],[12,"span","","",15,null],[4,"LiteralKind","","",null,null],[13,"Byte","","",16,null],[13,"Char","","",16,null],[13,"Float","","",16,null],[13,"Str_","","",16,null],[13,"Integer","","",16,null],[13,"ByteStr","","",16,null],[13,"StrRaw","","",16,null],[13,"ByteStrRaw","","",16,null],[5,"unquote","","",null,{"i":[{"n":"t"}],"o":{"n":"tokenstream"}}],[8,"Quote","","",null,null],[10,"quote","","",17,{"i":[{"n":"self"}],"o":{"n":"tokenstream"}}],[11,"expand","","",18,{"i":[{"n":"self"},{"n":"extctxt"},{"n":"span"},{"n":"tokenstream"}],"o":{"n":"tokenstream"}}],[11,"quote","proc_macro","",1,{"i":[{"n":"self"}],"o":{"n":"tokenstream"}}],[11,"quote","","",11,{"i":[{"n":"self"}],"o":{"n":"tokenstream"}}],[11,"quote","","",6,{"i":[{"n":"self"}],"o":{"n":"tokenstream"}}],[11,"quote","","",7,{"i":[{"n":"self"}],"o":{"n":"tokenstream"}}],[11,"quote","","",8,{"i":[{"n":"self"}],"o":{"n":"tokenstream"}}],[11,"quote","","",3,{"i":[{"n":"self"}],"o":{"n":"tokenstream"}}],[11,"new","proc_macro::quote","",15,{"i":[{"n":"str"},{"n":"span"}],"o":{"n":"spannedsymbol"}}],[11,"quote","","",15,{"i":[{"n":"self"}],"o":{"n":"tokenstream"}}],[11,"with_contents_and_suffix","","",16,{"i":[{"n":"self"},{"n":"spannedsymbol"},{"g":["spannedsymbol"],"n":"option"}],"o":{"n":"literal"}}],[11,"kind_contents_and_suffix","proc_macro","",9,null],[11,"quote","proc_macro::quote","",16,{"i":[{"n":"self"}],"o":{"n":"tokenstream"}}],[11,"quote","proc_macro","",9,{"i":[{"n":"self"}],"o":{"n":"tokenstream"}}],[11,"quote","","",12,{"i":[{"n":"self"}],"o":{"n":"tokenstream"}}],[11,"quote","","",13,{"i":[{"n":"self"}],"o":{"n":"tokenstream"}}],[0,"__internal","","Permanently unstable internal implementation details of this crate. This should not be used.",null,null],[3,"SpannedSymbol","proc_macro::__internal","",null,null],[12,"sym","","",15,null],[12,"span","","",15,null],[3,"Quoter","","",null,null],[4,"LiteralKind","","",null,null],[13,"Byte","","",16,null],[13,"Char","","",16,null],[13,"Float","","",16,null],[13,"Str_","","",16,null],[13,"Integer","","",16,null],[13,"ByteStr","","",16,null],[13,"StrRaw","","",16,null],[13,"ByteStrRaw","","",16,null],[5,"unquote","","",null,{"i":[{"n":"t"}],"o":{"n":"tokenstream"}}],[5,"lookup_char_pos","","",null,{"i":[{"n":"bytepos"}],"o":{"n":"loc"}}],[5,"new_token_stream","","",null,{"i":[{"g":["item"],"n":"p"}],"o":{"n":"tokenstream"}}],[5,"token_stream_wrap","","",null,{"i":[{"n":"tokenstream"}],"o":{"n":"tokenstream"}}],[5,"token_stream_parse_items","","",null,{"i":[{"n":"tokenstream"}],"o":{"g":["vec","lexerror"],"n":"result"}}],[5,"token_stream_inner","","",null,{"i":[{"n":"tokenstream"}],"o":{"n":"tokenstream"}}],[5,"set_sess","","",null,{"i":[{"n":"extctxt"},{"n":"f"}],"o":{"n":"r"}}],[5,"in_sess","","",null,{"o":{"n":"bool"}}],[5,"with_sess","","",null,{"i":[{"n":"f"}],"o":{"n":"r"}}],[17,"CURRENT_SESS","","",null,null],[8,"Registry","","",null,null],[10,"register_custom_derive","","",19,null],[10,"register_attr_proc_macro","","",19,null],[10,"register_bang_proc_macro","","",19,null],[11,"clone","proc_macro","",1,{"i":[{"n":"self"}],"o":{"n":"tokenstream"}}],[11,"fmt","","",2,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","Returns an empty `TokenStream` containing no token trees.",1,{"o":{"n":"tokenstream"}}],[11,"is_empty","","Checks if this `TokenStream` is empty.",1,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"from_str","","",1,{"i":[{"n":"str"}],"o":{"g":["tokenstream","lexerror"],"n":"result"}}],[11,"fmt","","",1,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",1,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"from","","",1,{"i":[{"n":"tokentree"}],"o":{"n":"tokenstream"}}],[11,"from_iter","","",1,{"i":[{"n":"i"}],"o":{"n":"self"}}],[11,"from_iter","","",1,{"i":[{"n":"i"}],"o":{"n":"self"}}],[11,"clone","","",3,{"i":[{"n":"self"}],"o":{"n":"span"}}],[11,"def_site","","A span that resolves at the macro definition site.",3,{"o":{"n":"span"}}],[11,"call_site","","The span of the invocation of the current procedural macro. Identifiers created with this span will be resolved as if they were written directly at the macro call location (call-site hygiene) and other code at the macro call site will be able to refer to them as well.",3,{"o":{"n":"span"}}],[11,"source_file","","The original source file into which this span points.",3,{"i":[{"n":"self"}],"o":{"n":"sourcefile"}}],[11,"parent","","The `Span` for the tokens in the previous macro expansion from which `self` was generated from, if any.",3,{"i":[{"n":"self"}],"o":{"g":["span"],"n":"option"}}],[11,"source","","The span for the origin source code that `self` was generated from. If this `Span` wasn't generated from other macro expansions then the return value is the same as `*self`.",3,{"i":[{"n":"self"}],"o":{"n":"span"}}],[11,"start","","Get the starting line/column in the source file for this span.",3,{"i":[{"n":"self"}],"o":{"n":"linecolumn"}}],[11,"end","","Get the ending line/column in the source file for this span.",3,{"i":[{"n":"self"}],"o":{"n":"linecolumn"}}],[11,"join","","Create a new span encompassing `self` and `other`.",3,{"i":[{"n":"self"},{"n":"span"}],"o":{"g":["span"],"n":"option"}}],[11,"resolved_at","","Creates a new span with the same line/column information as `self` but that resolves symbols as though it were at `other`.",3,{"i":[{"n":"self"},{"n":"span"}],"o":{"n":"span"}}],[11,"located_at","","Creates a new span with the same name resolution behavior as `self` but with the line/column information of `other`.",3,{"i":[{"n":"self"},{"n":"span"}],"o":{"n":"span"}}],[11,"eq","","Compares to spans to see if they're equal.",3,{"i":[{"n":"self"},{"n":"span"}],"o":{"n":"bool"}}],[11,"error","","Create a new `Diagnostic` with the given `message` at the span `self`.",3,{"i":[{"n":"self"},{"n":"t"}],"o":{"n":"diagnostic"}}],[11,"warning","","Create a new `Diagnostic` with the given `message` at the span `self`.",3,{"i":[{"n":"self"},{"n":"t"}],"o":{"n":"diagnostic"}}],[11,"note","","Create a new `Diagnostic` with the given `message` at the span `self`.",3,{"i":[{"n":"self"},{"n":"t"}],"o":{"n":"diagnostic"}}],[11,"help","","Create a new `Diagnostic` with the given `message` at the span `self`.",3,{"i":[{"n":"self"},{"n":"t"}],"o":{"n":"diagnostic"}}],[11,"fmt","","",3,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",4,{"i":[{"n":"self"}],"o":{"n":"linecolumn"}}],[11,"fmt","","",4,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"eq","","",4,{"i":[{"n":"self"},{"n":"linecolumn"}],"o":{"n":"bool"}}],[11,"ne","","",4,{"i":[{"n":"self"},{"n":"linecolumn"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",4,null],[11,"clone","","",5,{"i":[{"n":"self"}],"o":{"n":"sourcefile"}}],[11,"path","","Get the path to this source file.",5,{"i":[{"n":"self"}],"o":{"n":"filename"}}],[11,"is_real","","Returns `true` if this source file is a real source file, and not generated by an external macro's expansion.",5,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"as_ref","","",5,{"i":[{"n":"self"}],"o":{"n":"filename"}}],[11,"fmt","","",5,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"eq","","",5,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"bool"}}],[11,"eq","","",5,{"i":[{"n":"self"},{"n":"filename"}],"o":{"n":"bool"}}],[11,"clone","","",11,{"i":[{"n":"self"}],"o":{"n":"tokentree"}}],[11,"span","","Returns the span of this tree, delegating to the `span` method of the contained token or a delimited stream.",11,{"i":[{"n":"self"}],"o":{"n":"span"}}],[11,"set_span","","Configures the span for only this token.",11,{"i":[{"n":"self"},{"n":"span"}]}],[11,"fmt","","",11,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"from","","",11,{"i":[{"n":"group"}],"o":{"n":"tokentree"}}],[11,"from","","",11,{"i":[{"n":"ident"}],"o":{"n":"tokentree"}}],[11,"from","","",11,{"i":[{"n":"punct"}],"o":{"n":"tokentree"}}],[11,"from","","",11,{"i":[{"n":"literal"}],"o":{"n":"tokentree"}}],[11,"fmt","","",11,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",6,{"i":[{"n":"self"}],"o":{"n":"group"}}],[11,"fmt","","",6,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",12,{"i":[{"n":"self"}],"o":{"n":"delimiter"}}],[11,"fmt","","",12,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"eq","","",12,{"i":[{"n":"self"},{"n":"delimiter"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",12,null],[11,"new","","Creates a new `Group` with the given delimiter and token stream.",6,{"i":[{"n":"delimiter"},{"n":"tokenstream"}],"o":{"n":"group"}}],[11,"delimiter","","Returns the delimiter of this `Group`",6,{"i":[{"n":"self"}],"o":{"n":"delimiter"}}],[11,"stream","","Returns the `TokenStream` of tokens that are delimited in this `Group`.",6,{"i":[{"n":"self"}],"o":{"n":"tokenstream"}}],[11,"span","","Returns the span for the delimiters of this token stream, spanning the entire `Group`.",6,{"i":[{"n":"self"}],"o":{"n":"span"}}],[11,"set_span","","Configures the span for this `Group`'s delimiters, but not its internal tokens.",6,{"i":[{"n":"self"},{"n":"span"}]}],[11,"fmt","","",6,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",7,{"i":[{"n":"self"}],"o":{"n":"punct"}}],[11,"fmt","","",7,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",13,{"i":[{"n":"self"}],"o":{"n":"spacing"}}],[11,"fmt","","",13,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"eq","","",13,{"i":[{"n":"self"},{"n":"spacing"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",13,null],[11,"new","","Creates a new `Punct` from the given character and spacing. The `ch` argument must be a valid punctuation character permitted by the language, otherwise the function will panic.",7,{"i":[{"n":"char"},{"n":"spacing"}],"o":{"n":"punct"}}],[11,"as_char","","Returns the value of this punctuation character as `char`.",7,{"i":[{"n":"self"}],"o":{"n":"char"}}],[11,"spacing","","Returns the spacing of this punctuation character, indicating whether it's immediately followed by another `Punct` in the token stream, so they can potentially be combined into a multicharacter operator (`Joint`), or it's followed by some other token or whitespace (`Alone`) so the operator has certainly ended.",7,{"i":[{"n":"self"}],"o":{"n":"spacing"}}],[11,"span","","Returns the span for this punctuation character.",7,{"i":[{"n":"self"}],"o":{"n":"span"}}],[11,"set_span","","Configure the span for this punctuation character.",7,{"i":[{"n":"self"},{"n":"span"}]}],[11,"fmt","","",7,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",8,{"i":[{"n":"self"}],"o":{"n":"ident"}}],[11,"fmt","","",8,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","Creates a new `Ident` with the given `string` as well as the specified `span`. The `string` argument must be a valid identifier permitted by the language, otherwise the function will panic.",8,{"i":[{"n":"str"},{"n":"span"}],"o":{"n":"ident"}}],[11,"new_raw","","Same as `Ident::new`, but creates a raw identifier (`r#ident`).",8,{"i":[{"n":"str"},{"n":"span"}],"o":{"n":"ident"}}],[11,"span","","Returns the span of this `Ident`, encompassing the entire string returned by `as_str`.",8,{"i":[{"n":"self"}],"o":{"n":"span"}}],[11,"set_span","","Configures the span of this `Ident`, possibly changing its hygiene context.",8,{"i":[{"n":"self"},{"n":"span"}]}],[11,"fmt","","",8,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",9,{"i":[{"n":"self"}],"o":{"n":"literal"}}],[11,"fmt","","",9,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"u8_suffixed","","Creates a new suffixed integer literal with the specified value.",9,{"i":[{"n":"u8"}],"o":{"n":"literal"}}],[11,"u16_suffixed","","Creates a new suffixed integer literal with the specified value.",9,{"i":[{"n":"u16"}],"o":{"n":"literal"}}],[11,"u32_suffixed","","Creates a new suffixed integer literal with the specified value.",9,{"i":[{"n":"u32"}],"o":{"n":"literal"}}],[11,"u64_suffixed","","Creates a new suffixed integer literal with the specified value.",9,{"i":[{"n":"u64"}],"o":{"n":"literal"}}],[11,"u128_suffixed","","Creates a new suffixed integer literal with the specified value.",9,{"i":[{"n":"u128"}],"o":{"n":"literal"}}],[11,"usize_suffixed","","Creates a new suffixed integer literal with the specified value.",9,{"i":[{"n":"usize"}],"o":{"n":"literal"}}],[11,"i8_suffixed","","Creates a new suffixed integer literal with the specified value.",9,{"i":[{"n":"i8"}],"o":{"n":"literal"}}],[11,"i16_suffixed","","Creates a new suffixed integer literal with the specified value.",9,{"i":[{"n":"i16"}],"o":{"n":"literal"}}],[11,"i32_suffixed","","Creates a new suffixed integer literal with the specified value.",9,{"i":[{"n":"i32"}],"o":{"n":"literal"}}],[11,"i64_suffixed","","Creates a new suffixed integer literal with the specified value.",9,{"i":[{"n":"i64"}],"o":{"n":"literal"}}],[11,"i128_suffixed","","Creates a new suffixed integer literal with the specified value.",9,{"i":[{"n":"i128"}],"o":{"n":"literal"}}],[11,"isize_suffixed","","Creates a new suffixed integer literal with the specified value.",9,{"i":[{"n":"isize"}],"o":{"n":"literal"}}],[11,"u8_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",9,{"i":[{"n":"u8"}],"o":{"n":"literal"}}],[11,"u16_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",9,{"i":[{"n":"u16"}],"o":{"n":"literal"}}],[11,"u32_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",9,{"i":[{"n":"u32"}],"o":{"n":"literal"}}],[11,"u64_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",9,{"i":[{"n":"u64"}],"o":{"n":"literal"}}],[11,"u128_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",9,{"i":[{"n":"u128"}],"o":{"n":"literal"}}],[11,"usize_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",9,{"i":[{"n":"usize"}],"o":{"n":"literal"}}],[11,"i8_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",9,{"i":[{"n":"i8"}],"o":{"n":"literal"}}],[11,"i16_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",9,{"i":[{"n":"i16"}],"o":{"n":"literal"}}],[11,"i32_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",9,{"i":[{"n":"i32"}],"o":{"n":"literal"}}],[11,"i64_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",9,{"i":[{"n":"i64"}],"o":{"n":"literal"}}],[11,"i128_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",9,{"i":[{"n":"i128"}],"o":{"n":"literal"}}],[11,"isize_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",9,{"i":[{"n":"isize"}],"o":{"n":"literal"}}],[11,"f32_unsuffixed","","Creates a new unsuffixed floating-point literal.",9,{"i":[{"n":"f32"}],"o":{"n":"literal"}}],[11,"f32_suffixed","","Creates a new suffixed floating-point literal.",9,{"i":[{"n":"f32"}],"o":{"n":"literal"}}],[11,"f64_unsuffixed","","Creates a new unsuffixed floating-point literal.",9,{"i":[{"n":"f64"}],"o":{"n":"literal"}}],[11,"f64_suffixed","","Creates a new suffixed floating-point literal.",9,{"i":[{"n":"f64"}],"o":{"n":"literal"}}],[11,"string","","String literal.",9,{"i":[{"n":"str"}],"o":{"n":"literal"}}],[11,"character","","Character literal.",9,{"i":[{"n":"char"}],"o":{"n":"literal"}}],[11,"byte_string","","Byte string literal.",9,null],[11,"span","","Returns the span encompassing this literal.",9,{"i":[{"n":"self"}],"o":{"n":"span"}}],[11,"set_span","","Configures the span associated for this literal.",9,{"i":[{"n":"self"},{"n":"span"}]}],[11,"fmt","","",9,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"from_internal","","",12,{"i":[{"n":"delimtoken"}],"o":{"n":"delimiter"}}],[11,"to_internal","","",12,{"i":[{"n":"self"}],"o":{"n":"delimtoken"}}],[11,"from_internal","","",11,{"i":[{"n":"tokenstream"},{"n":"vec"}],"o":{"n":"tokentree"}}],[11,"to_internal","","",11,{"i":[{"n":"self"}],"o":{"n":"tokenstream"}}],[14,"quote","","`quote!(..)` accepts arbitrary tokens and expands into a `TokenStream` describing the input. For example, `quote!(a + b)` will produce a expression, that, when evaluated, constructs the `TokenStream` `[Ident(\"a\"), Punct('+', Alone), Ident(\"b\")]`.",null,null]],"paths":[[3,"Diagnostic"],[3,"TokenStream"],[3,"LexError"],[3,"Span"],[3,"LineColumn"],[3,"SourceFile"],[3,"Group"],[3,"Punct"],[3,"Ident"],[3,"Literal"],[4,"Level"],[4,"TokenTree"],[4,"Delimiter"],[4,"Spacing"],[3,"IntoIter"],[3,"SpannedSymbol"],[4,"LiteralKind"],[8,"Quote"],[3,"Quoter"],[8,"Registry"]]};
searchIndex["pulldown_cmark"] = {"doc":"Pull parser for commonmark.","items":[[3,"Parser","pulldown_cmark","",null,null],[12,"inner","","",0,null],[12,"loose_lists","","",0,null],[12,"loose_stack","","",0,null],[3,"Options","","",null,null],[12,"bits","","",1,null],[4,"Alignment","","",null,null],[13,"None","","",2,null],[13,"Left","","",2,null],[13,"Center","","",2,null],[13,"Right","","",2,null],[4,"Event","","",null,null],[13,"Start","","",3,null],[13,"End","","",3,null],[13,"Text","","",3,null],[13,"Html","","",3,null],[13,"InlineHtml","","",3,null],[13,"FootnoteReference","","",3,null],[13,"SoftBreak","","",3,null],[13,"HardBreak","","",3,null],[4,"Tag","","",null,null],[13,"Paragraph","","",4,null],[13,"Rule","","",4,null],[13,"Header","","A heading. The field indicates the level of the heading.",4,null],[13,"BlockQuote","","",4,null],[13,"CodeBlock","","",4,null],[13,"List","","A list. If the list is ordered the field indicates the number of the first item.",4,null],[13,"Item","","",4,null],[13,"FootnoteDefinition","","",4,null],[13,"Table","","",4,null],[13,"TableHead","","",4,null],[13,"TableRow","","",4,null],[13,"TableCell","","",4,null],[13,"Emphasis","","",4,null],[13,"Strong","","",4,null],[13,"Code","","",4,null],[13,"Link","","A link. The first field is the destination URL, the second is a title",4,null],[13,"Image","","An image. The first field is the destination URL, the second is a title",4,null],[0,"html","","HTML renderer that takes an iterator of events as input.",null,null],[3,"Ctx","pulldown_cmark::html","",null,null],[12,"iter","","",5,null],[12,"buf","","",5,null],[12,"table_state","","",5,null],[12,"table_alignments","","",5,null],[12,"table_cell_index","","",5,null],[4,"TableState","","",null,null],[13,"Head","","",6,null],[13,"Body","","",6,null],[5,"push_html","","Iterate over an `Iterator` of `Event`s, generate HTML for each `Event`, and push it to a `String`.",null,{"i":[{"n":"string"},{"n":"i"}]}],[11,"fresh_line","","",5,{"i":[{"n":"self"}]}],[11,"run","","",5,{"i":[{"n":"self"}]}],[11,"start_tag","","",5,{"i":[{"n":"self"},{"n":"tag"},{"n":"hashmap"}]}],[11,"end_tag","","",5,{"i":[{"n":"self"},{"n":"tag"}]}],[11,"raw_text","","",5,{"i":[{"n":"self"},{"n":"hashmap"}]}],[0,"passes","pulldown_cmark","Main public pull parse interface, running two passes over input.",null,null],[3,"Parser","pulldown_cmark::passes","",null,null],[12,"inner","","",0,null],[12,"loose_lists","","",0,null],[12,"loose_stack","","",0,null],[11,"new","pulldown_cmark","",0,{"i":[{"n":"str"}],"o":{"n":"parser"}}],[11,"new_ext","","",0,{"i":[{"n":"str"},{"n":"options"}],"o":{"n":"parser"}}],[11,"new_with_broken_link_callback","","In case the parser encounters any potential links that have a broken reference (e.g `[foo]` when there is no `[foo]:` entry at the bottom) the provided callback will be called with the reference name, and the returned pair will be used as the link name and title if not None.",0,{"i":[{"n":"str"},{"n":"options"},{"g":["fn"],"n":"option"}],"o":{"n":"parser"}}],[11,"get_offset","","",0,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"next","","",0,{"i":[{"n":"self"}],"o":{"g":["event"],"n":"option"}}],[0,"parse","","Raw parser, for doing a single pass over input.",null,null],[3,"RawParser","pulldown_cmark::parse","",null,null],[12,"text","","",7,null],[12,"off","","",7,null],[12,"opts","","",7,null],[12,"active_tab","","",7,null],[12,"state","","",7,null],[12,"stack","","",7,null],[12,"leading_space","","",7,null],[12,"containers","","",7,null],[12,"last_line_was_empty","","",7,null],[12,"broken_link_callback","","In case we have a broken link/image reference, we can call this callback with the reference name (both normalized and not normalized) and use the link/title pair returned instead",7,null],[12,"fence_char","","",7,null],[12,"fence_count","","",7,null],[12,"fence_indent","","",7,null],[12,"loose_lists","","",7,null],[12,"links","","",7,null],[3,"ParseInfo","","",null,null],[12,"loose_lists","","",8,null],[12,"links","","",8,null],[3,"Options","","",null,null],[12,"bits","","",1,null],[4,"State","","",null,null],[13,"StartBlock","","",9,null],[13,"InContainers","","",9,null],[13,"Inline","","",9,null],[13,"TableHead","","",9,null],[13,"TableBody","","",9,null],[13,"TableRow","","",9,null],[13,"CodeLineStart","","",9,null],[13,"Code","","",9,null],[13,"InlineCode","","",9,null],[13,"Literal","","",9,null],[4,"Container","","",null,null],[13,"BlockQuote","","",10,null],[13,"List","","",10,null],[13,"ListItem","","",10,null],[13,"FootnoteDefinition","","",10,null],[4,"Tag","","",null,null],[13,"Paragraph","","",4,null],[13,"Rule","","",4,null],[13,"Header","","A heading. The field indicates the level of the heading.",4,null],[13,"BlockQuote","","",4,null],[13,"CodeBlock","","",4,null],[13,"List","","A list. If the list is ordered the field indicates the number of the first item.",4,null],[13,"Item","","",4,null],[13,"FootnoteDefinition","","",4,null],[13,"Table","","",4,null],[13,"TableHead","","",4,null],[13,"TableRow","","",4,null],[13,"TableCell","","",4,null],[13,"Emphasis","","",4,null],[13,"Strong","","",4,null],[13,"Code","","",4,null],[13,"Link","","A link. The first field is the destination URL, the second is a title",4,null],[13,"Image","","An image. The first field is the destination URL, the second is a title",4,null],[4,"Event","","",null,null],[13,"Start","","",3,null],[13,"End","","",3,null],[13,"Text","","",3,null],[13,"Html","","",3,null],[13,"InlineHtml","","",3,null],[13,"FootnoteReference","","",3,null],[13,"SoftBreak","","",3,null],[13,"HardBreak","","",3,null],[4,"Alignment","","",null,null],[13,"None","","",2,null],[13,"Left","","",2,null],[13,"Center","","",2,null],[13,"Right","","",2,null],[17,"OPTION_FIRST_PASS","","",null,null],[17,"OPTION_ENABLE_TABLES","","",null,null],[17,"OPTION_ENABLE_FOOTNOTES","","",null,null],[17,"MAX_LINK_NEST","","",null,null],[11,"eq","","",9,{"i":[{"n":"self"},{"n":"state"}],"o":{"n":"bool"}}],[11,"ne","","",9,{"i":[{"n":"self"},{"n":"state"}],"o":{"n":"bool"}}],[11,"fmt","","",9,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",10,{"i":[{"n":"self"}],"o":{"n":"container"}}],[11,"fmt","","",10,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"eq","","",10,{"i":[{"n":"self"},{"n":"container"}],"o":{"n":"bool"}}],[11,"ne","","",10,{"i":[{"n":"self"},{"n":"container"}],"o":{"n":"bool"}}],[11,"clone","pulldown_cmark","",4,{"i":[{"n":"self"}],"o":{"n":"tag"}}],[11,"fmt","","",4,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"eq","","",4,{"i":[{"n":"self"},{"n":"tag"}],"o":{"n":"bool"}}],[11,"ne","","",4,{"i":[{"n":"self"},{"n":"tag"}],"o":{"n":"bool"}}],[11,"clone","","",3,{"i":[{"n":"self"}],"o":{"n":"event"}}],[11,"fmt","","",3,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"eq","","",3,{"i":[{"n":"self"},{"n":"event"}],"o":{"n":"bool"}}],[11,"ne","","",3,{"i":[{"n":"self"},{"n":"event"}],"o":{"n":"bool"}}],[11,"clone","","",2,{"i":[{"n":"self"}],"o":{"n":"alignment"}}],[11,"fmt","","",2,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"eq","","",2,{"i":[{"n":"self"},{"n":"alignment"}],"o":{"n":"bool"}}],[11,"eq","","",1,{"i":[{"n":"self"},{"n":"options"}],"o":{"n":"bool"}}],[11,"ne","","",1,{"i":[{"n":"self"},{"n":"options"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",1,null],[11,"clone","","",1,{"i":[{"n":"self"}],"o":{"n":"options"}}],[11,"partial_cmp","","",1,{"i":[{"n":"self"},{"n":"options"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",1,{"i":[{"n":"self"},{"n":"options"}],"o":{"n":"bool"}}],[11,"le","","",1,{"i":[{"n":"self"},{"n":"options"}],"o":{"n":"bool"}}],[11,"gt","","",1,{"i":[{"n":"self"},{"n":"options"}],"o":{"n":"bool"}}],[11,"ge","","",1,{"i":[{"n":"self"},{"n":"options"}],"o":{"n":"bool"}}],[11,"cmp","","",1,{"i":[{"n":"self"},{"n":"options"}],"o":{"n":"ordering"}}],[11,"hash","","",1,null],[11,"fmt","","",1,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",1,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",1,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",1,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",1,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"empty","","Returns an empty set of flags.",1,{"o":{"n":"options"}}],[11,"all","","Returns the set containing all flags.",1,{"o":{"n":"options"}}],[11,"bits","","Returns the raw value of the flags currently stored.",1,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"from_bits","","Convert from underlying bit representation, unless that representation contains bits that do not correspond to a flag.",1,{"i":[{"n":"u32"}],"o":{"g":["options"],"n":"option"}}],[11,"from_bits_truncate","","Convert from underlying bit representation, dropping any bits that do not correspond to flags.",1,{"i":[{"n":"u32"}],"o":{"n":"options"}}],[11,"is_empty","","Returns `true` if no flags are currently stored.",1,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"is_all","","Returns `true` if all flags are currently set.",1,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"intersects","","Returns `true` if there are flags common to both `self` and `other`.",1,{"i":[{"n":"self"},{"n":"options"}],"o":{"n":"bool"}}],[11,"contains","","Returns `true` all of the flags in `other` are contained within `self`.",1,{"i":[{"n":"self"},{"n":"options"}],"o":{"n":"bool"}}],[11,"insert","","Inserts the specified flags in-place.",1,{"i":[{"n":"self"},{"n":"options"}]}],[11,"remove","","Removes the specified flags in-place.",1,{"i":[{"n":"self"},{"n":"options"}]}],[11,"toggle","","Toggles the specified flags in-place.",1,{"i":[{"n":"self"},{"n":"options"}]}],[11,"set","","Inserts or removes the specified flags depending on the passed value.",1,{"i":[{"n":"self"},{"n":"options"},{"n":"bool"}]}],[11,"bitor","","Returns the union of the two sets of flags.",1,{"i":[{"n":"self"},{"n":"options"}],"o":{"n":"options"}}],[11,"bitor_assign","","Adds the set of flags.",1,{"i":[{"n":"self"},{"n":"options"}]}],[11,"bitxor","","Returns the left flags, but with all the right flags toggled.",1,{"i":[{"n":"self"},{"n":"options"}],"o":{"n":"options"}}],[11,"bitxor_assign","","Toggles the set of flags.",1,{"i":[{"n":"self"},{"n":"options"}]}],[11,"bitand","","Returns the intersection between the two sets of flags.",1,{"i":[{"n":"self"},{"n":"options"}],"o":{"n":"options"}}],[11,"bitand_assign","","Disables all flags disabled in the set.",1,{"i":[{"n":"self"},{"n":"options"}]}],[11,"sub","","Returns the set difference of the two sets of flags.",1,{"i":[{"n":"self"},{"n":"options"}],"o":{"n":"options"}}],[11,"sub_assign","","Disables all flags enabled in the set.",1,{"i":[{"n":"self"},{"n":"options"}]}],[11,"not","","Returns the complement of this set of flags.",1,{"i":[{"n":"self"}],"o":{"n":"options"}}],[11,"extend","","",1,{"i":[{"n":"self"},{"n":"t"}]}],[11,"from_iter","","",1,{"i":[{"n":"t"}],"o":{"n":"options"}}],[11,"new_with_links_and_callback","pulldown_cmark::parse","",7,{"i":[{"n":"str"},{"n":"options"},{"g":["string"],"n":"hashmap"},{"g":["fn"],"n":"option"}],"o":{"n":"rawparser"}}],[11,"new_with_links","","",7,{"i":[{"n":"str"},{"n":"options"},{"g":["string"],"n":"hashmap"}],"o":{"n":"rawparser"}}],[11,"new","","",7,{"i":[{"n":"str"},{"n":"options"}],"o":{"n":"rawparser"}}],[11,"get_offset","","",7,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"get_info","","",7,{"i":[{"n":"self"}],"o":{"n":"parseinfo"}}],[11,"init_active","","",7,{"i":[{"n":"self"}]}],[11,"limit","","",7,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"start","","",7,{"i":[{"n":"self"},{"n":"tag"},{"n":"usize"},{"n":"usize"}],"o":{"n":"event"}}],[11,"end","","",7,{"i":[{"n":"self"}],"o":{"n":"event"}}],[11,"skip_leading_whitespace","","",7,{"i":[{"n":"self"}]}],[11,"skip_blank_lines","","",7,{"i":[{"n":"self"}]}],[11,"scan_containers","","",7,null],[11,"scan_empty_lines","","",7,null],[11,"scan_whitespace_inline","","",7,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"usize"}}],[11,"at_list","","",7,{"i":[{"n":"self"},{"n":"usize"}],"o":{"g":["usize"],"n":"option"}}],[11,"start_block","","",7,{"i":[{"n":"self"}],"o":{"g":["event"],"n":"option"}}],[11,"start_paragraph","","",7,{"i":[{"n":"self"}],"o":{"n":"event"}}],[11,"start_table_head","","",7,{"i":[{"n":"self"}],"o":{"n":"event"}}],[11,"start_table_body","","",7,{"i":[{"n":"self"}],"o":{"n":"event"}}],[11,"start_hrule","","",7,{"i":[{"n":"self"}],"o":{"n":"event"}}],[11,"start_atx_header","","",7,{"i":[{"n":"self"},{"n":"i32"}],"o":{"n":"event"}}],[11,"start_indented_code","","",7,{"i":[{"n":"self"}],"o":{"n":"event"}}],[11,"start_listitem","","",7,{"i":[{"n":"self"},{"n":"usize"},{"n":"u8"},{"n":"usize"},{"n":"usize"}],"o":{"n":"event"}}],[11,"start_code_fence","","",7,{"i":[{"n":"self"},{"n":"usize"},{"n":"u8"},{"n":"usize"}],"o":{"n":"event"}}],[11,"next_code_line_start","","",7,{"i":[{"n":"self"}],"o":{"n":"event"}}],[11,"next_code","","",7,{"i":[{"n":"self"}],"o":{"n":"event"}}],[11,"is_code_block_end","","",7,{"i":[{"n":"self"},{"n":"usize"},{"n":"usize"}],"o":{"n":"bool"}}],[11,"scan_html_block_tag","","",7,null],[11,"is_html_block","","",7,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"bool"}}],[11,"get_html_tag","","",7,{"i":[{"n":"self"}],"o":{"g":["str"],"n":"option"}}],[11,"do_html_block","","",7,{"i":[{"n":"self"}],"o":{"n":"event"}}],[11,"try_link_reference_definition","","",7,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"bool"}}],[11,"normalize_link_ref","","",7,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"string"}}],[11,"is_inline_block_end","","",7,{"i":[{"n":"self"},{"n":"str"},{"n":"usize"}],"o":{"n":"bool"}}],[11,"next_table_cell","","",7,{"i":[{"n":"self"}],"o":{"n":"event"}}],[11,"next_inline","","",7,{"i":[{"n":"self"}],"o":{"n":"event"}}],[11,"active_char","","",7,{"i":[{"n":"self"},{"n":"u8"}],"o":{"g":["event"],"n":"option"}}],[11,"char_null","","",7,{"i":[{"n":"self"}],"o":{"n":"event"}}],[11,"char_tab","","",7,{"i":[{"n":"self"}],"o":{"n":"event"}}],[11,"char_backslash","","",7,{"i":[{"n":"self"}],"o":{"g":["event"],"n":"option"}}],[11,"char_entity","","",7,{"i":[{"n":"self"}],"o":{"g":["event"],"n":"option"}}],[11,"char_emphasis","","",7,{"i":[{"n":"self"}],"o":{"g":["event"],"n":"option"}}],[11,"scan_link_label","","",7,null],[11,"scan_link_title","","",7,null],[11,"char_link","","",7,{"i":[{"n":"self"}],"o":{"g":["event"],"n":"option"}}],[11,"parse_link","","",7,{"i":[{"n":"self"},{"n":"str"},{"n":"bool"}],"o":{"n":"option"}}],[11,"contains_link","","",7,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"bool"}}],[11,"parse_footnote_definition","","",7,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"option"}}],[11,"char_link_footnote","","",7,{"i":[{"n":"self"}],"o":{"g":["event"],"n":"option"}}],[11,"parse_footnote","","",7,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"option"}}],[11,"scan_footnote_label","","",7,null],[11,"char_lt","","",7,{"i":[{"n":"self"}],"o":{"g":["event"],"n":"option"}}],[11,"scan_autolink_or_html","","",7,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"usize"}}],[11,"scan_inline_html","","",7,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"usize"}}],[11,"scan_html_tag","","",7,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"usize"}}],[11,"scan_attribute_value","","",7,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"usize"}}],[11,"scan_html_comment","","",7,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"usize"}}],[11,"scan_processing_instruction","","",7,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"usize"}}],[11,"scan_declaration","","",7,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"usize"}}],[11,"scan_cdata","","",7,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"usize"}}],[11,"inline_html_event","","",7,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"event"}}],[11,"next_literal","","",7,{"i":[{"n":"self"}],"o":{"n":"event"}}],[11,"scan_inline_code","","",7,null],[11,"char_backtick","","",7,{"i":[{"n":"self"}],"o":{"g":["event"],"n":"option"}}],[11,"next_inline_code","","",7,{"i":[{"n":"self"}],"o":{"n":"event"}}],[11,"next","","",7,{"i":[{"n":"self"}],"o":{"g":["event"],"n":"option"}}],[0,"scanners","pulldown_cmark","Scanners for fragments of CommonMark syntax",null,null],[5,"is_ascii_whitespace","pulldown_cmark::scanners","",null,{"i":[{"n":"u8"}],"o":{"n":"bool"}}],[5,"is_ascii_whitespace_no_nl","","",null,{"i":[{"n":"u8"}],"o":{"n":"bool"}}],[5,"is_ascii_alpha","","",null,{"i":[{"n":"u8"}],"o":{"n":"bool"}}],[5,"is_ascii_upper","","",null,{"i":[{"n":"u8"}],"o":{"n":"bool"}}],[5,"is_ascii_alphanumeric","","",null,{"i":[{"n":"u8"}],"o":{"n":"bool"}}],[5,"is_hexdigit","","",null,{"i":[{"n":"u8"}],"o":{"n":"bool"}}],[5,"is_digit","","",null,{"i":[{"n":"u8"}],"o":{"n":"bool"}}],[5,"scan_ch","","",null,{"i":[{"n":"str"},{"n":"u8"}],"o":{"n":"usize"}}],[5,"scan_while","","",null,{"i":[{"n":"str"},{"n":"f"}],"o":{"n":"usize"}}],[5,"scan_ch_repeat","","",null,{"i":[{"n":"str"},{"n":"u8"}],"o":{"n":"usize"}}],[5,"scan_whitespace_no_nl","","",null,{"i":[{"n":"str"}],"o":{"n":"usize"}}],[5,"scan_eol","","",null,null],[5,"scan_trailing_whitespace","","",null,{"i":[{"n":"str"}],"o":{"n":"usize"}}],[5,"scan_codepoint","","",null,{"i":[{"n":"str"}],"o":{"g":["char"],"n":"option"}}],[5,"scan_trailing_codepoint","","",null,{"i":[{"n":"str"}],"o":{"g":["char"],"n":"option"}}],[5,"scan_blank_line","","",null,{"i":[{"n":"str"}],"o":{"n":"usize"}}],[5,"scan_nextline","","",null,{"i":[{"n":"str"}],"o":{"n":"usize"}}],[5,"count_tab","","",null,null],[5,"scan_leading_space","","",null,null],[5,"calc_indent","","",null,null],[5,"scan_hrule","","",null,{"i":[{"n":"str"}],"o":{"n":"usize"}}],[5,"scan_atx_header","","",null,null],[5,"scan_setext_header","","",null,null],[5,"scan_table_head","","",null,null],[5,"scan_code_fence","","",null,null],[5,"scan_backticks","","",null,{"i":[{"n":"str"}],"o":{"n":"usize"}}],[5,"scan_blockquote_start","","",null,{"i":[{"n":"str"}],"o":{"n":"usize"}}],[5,"scan_listitem","","",null,null],[5,"compute_open_close","","",null,null],[5,"cow_from_codepoint_str","","",null,{"i":[{"n":"str"},{"n":"u32"}],"o":{"g":["str"],"n":"cow"}}],[5,"scan_entity","","",null,null],[5,"scan_link_dest","","",null,{"i":[{"n":"str"}],"o":{"n":"option"}}],[5,"scan_autolink","","",null,{"i":[{"n":"str"}],"o":{"n":"option"}}],[5,"scan_uri","","",null,{"i":[{"n":"str"}],"o":{"n":"usize"}}],[5,"scan_email","","",null,{"i":[{"n":"str"}],"o":{"n":"usize"}}],[5,"scan_attribute_name","","",null,{"i":[{"n":"str"}],"o":{"n":"usize"}}],[5,"is_escaped","","",null,{"i":[{"n":"str"},{"n":"usize"}],"o":{"n":"bool"}}],[5,"unescape","","",null,{"i":[{"n":"str"}],"o":{"g":["str"],"n":"cow"}}],[5,"is_html_tag","","",null,{"i":[{"n":"str"}],"o":{"n":"bool"}}],[5,"spaces","","",null,{"i":[{"n":"usize"}],"o":{"g":["str"],"n":"cow"}}],[17,"HTML_TAGS","","",null,null],[17,"URI_SCHEMES","","",null,null],[0,"entities","pulldown_cmark","Expansions of HTML5 entities",null,null],[5,"get_entity","pulldown_cmark::entities","",null,{"i":[{"n":"str"}],"o":{"g":["str"],"n":"option"}}],[17,"ENTITIES","","",null,null],[17,"ENTITY_VALUES","","",null,null],[0,"escape","pulldown_cmark","Utility functions for HTML escaping",null,null],[5,"escape_href","pulldown_cmark::escape","",null,{"i":[{"n":"string"},{"n":"str"}]}],[5,"escape_html","","",null,{"i":[{"n":"string"},{"n":"str"},{"n":"bool"}]}],[7,"HREF_SAFE","","",null,null],[7,"HEX_CHARS","","",null,null],[7,"HTML_ESCAPE_TABLE","","",null,null],[7,"HTML_ESCAPES","","",null,null],[0,"puncttable","pulldown_cmark","CommonMark punctuation set based on spec and Unicode properties.",null,null],[5,"is_ascii_punctuation","pulldown_cmark::puncttable","",null,{"i":[{"n":"u8"}],"o":{"n":"bool"}}],[5,"is_punctuation","","",null,{"i":[{"n":"char"}],"o":{"n":"bool"}}],[17,"PUNCT_MASKS_ASCII","","",null,null],[17,"PUNCT_TAB","","",null,null],[17,"PUNCT_MASKS","","",null,null],[0,"utils","pulldown_cmark","Utilities for manipulating strings.",null,null],[5,"ascii_tolower","pulldown_cmark::utils","",null,{"i":[{"n":"u8"}],"o":{"n":"u8"}}],[5,"strcasecmp","","",null,{"i":[{"n":"str"},{"n":"str"}],"o":{"n":"ordering"}}],[5,"cow_append","","",null,{"i":[{"g":["str"],"n":"cow"},{"g":["str"],"n":"cow"}],"o":{"g":["str"],"n":"cow"}}],[17,"OPTION_ENABLE_TABLES","pulldown_cmark","",null,null],[17,"OPTION_ENABLE_FOOTNOTES","","",null,null]],"paths":[[3,"Parser"],[3,"Options"],[4,"Alignment"],[4,"Event"],[4,"Tag"],[3,"Ctx"],[4,"TableState"],[3,"RawParser"],[3,"ParseInfo"],[4,"State"],[4,"Container"]]};
searchIndex["rand"] = {"doc":"Utilities for random number generation","items":[[3,"IsaacRng","rand","A random number generator that uses the ISAAC algorithm[1].",null,null],[12,"cnt","","",0,null],[12,"rsl","","",0,null],[12,"mem","","",0,null],[12,"a","","",0,null],[12,"b","","",0,null],[12,"c","","",0,null],[3,"Isaac64Rng","","A random number generator that uses ISAAC-64[1], the 64-bit variant of the ISAAC algorithm.",null,null],[12,"cnt","","",1,null],[12,"rsl","","",1,null],[12,"mem","","",1,null],[12,"a","","",1,null],[12,"b","","",1,null],[12,"c","","",1,null],[3,"ChaChaRng","","A random number generator that uses the ChaCha20 algorithm [1].",null,null],[12,"buffer","","",2,null],[12,"state","","",2,null],[12,"index","","",2,null],[3,"XorShiftRng","","An Xorshift[1] random number generator.",null,null],[12,"x","","",3,null],[12,"y","","",3,null],[12,"z","","",3,null],[12,"w","","",3,null],[3,"Generator","","Iterator which will generate a stream of random items.",null,null],[12,"rng","","",4,null],[12,"_marker","","",4,null],[3,"AsciiGenerator","","Iterator which will continuously generate random ascii characters.",null,null],[12,"rng","","",5,null],[3,"Open01","","A wrapper for generating floating point numbers uniformly in the open interval `(0,1)` (not including either endpoint).",null,null],[12,"0","","",6,null],[3,"Closed01","","A wrapper for generating floating point numbers uniformly in the closed interval `[0,1]` (including both endpoints).",null,null],[12,"0","","",7,null],[3,"StdRng","","The standard RNG. This is designed to be efficient on the current platform.",null,null],[12,"rng","","",8,null],[3,"ThreadRngReseeder","","Controls how the thread-local RNG is reseeded.",null,null],[3,"ThreadRng","","The thread-local RNG.",null,null],[12,"rng","","",9,null],[5,"weak_rng","","Create a weak random number generator with a default algorithm and seed.",null,{"o":{"n":"xorshiftrng"}}],[5,"thread_rng","","Retrieve the lazily-initialized thread-local random number generator, seeded by the system. Intended to be used in method chaining style, e.g. `thread_rng().gen::<i32>()`.",null,{"o":{"n":"threadrng"}}],[5,"random","","Generates a random value using the thread-local random number generator.",null,{"o":{"n":"t"}}],[5,"sample","","DEPRECATED: use `seq::sample_iter` instead.",null,{"i":[{"n":"r"},{"n":"i"},{"n":"usize"}],"o":{"n":"vec"}}],[0,"distributions","","Sampling from random distributions.",null,null],[3,"RandSample","rand::distributions","A wrapper for generating types that implement `Rand` via the `Sample` & `IndependentSample` traits.",null,null],[12,"_marker","","",10,null],[3,"Weighted","","A value with a particular weight for use with `WeightedChoice`.",null,null],[12,"weight","","The numerical weight of this item",11,null],[12,"item","","The actual item which is being weighted",11,null],[3,"WeightedChoice","","A distribution that selects from a finite collection of weighted items.",null,null],[12,"items","","",12,null],[12,"weight_range","","",12,null],[5,"ziggurat","","Sample a random number using the Ziggurat method (specifically the ZIGNOR variant from Doornik 2005). Most of the arguments are directly from the paper:",null,null],[0,"range","","Generating numbers between two others.",null,null],[3,"Range","rand::distributions::range","Sample values uniformly between two bounds.",null,null],[12,"low","","",13,null],[12,"range","","",13,null],[12,"accept_zone","","",13,null],[8,"SampleRange","","The helper trait for types that have a sensible way to sample uniformly between two values. This should not be used directly, and is only to facilitate `Range`.",null,null],[10,"construct_range","","Construct the `Range` object that `sample_range` requires. This should not ever be called directly, only via `Range::new`, which will check that `low < high`, so this function doesn't have to repeat the check.",14,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"range"}}],[10,"sample_range","","Sample a value from the given `Range` with the given `Rng` as a source of randomness.",14,{"i":[{"n":"range"},{"n":"r"}],"o":{"n":"self"}}],[11,"clone","","",13,{"i":[{"n":"self"}],"o":{"n":"range"}}],[11,"fmt","","",13,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","Create a new `Range` instance that samples uniformly from `[low, high)`. Panics if `low >= high`.",13,{"i":[{"n":"x"},{"n":"x"}],"o":{"n":"range"}}],[11,"sample","","",13,{"i":[{"n":"self"},{"n":"r"}],"o":{"n":"sup"}}],[11,"ind_sample","","",13,{"i":[{"n":"self"},{"n":"r"}],"o":{"n":"sup"}}],[0,"gamma","rand::distributions","The Gamma and derived distributions.",null,null],[3,"Gamma","rand::distributions::gamma","The Gamma distribution `Gamma(shape, scale)` distribution.",null,null],[12,"repr","","",15,null],[3,"GammaSmallShape","","Gamma distribution where the shape parameter is less than 1.",null,null],[12,"inv_shape","","",16,null],[12,"large_shape","","",16,null],[3,"GammaLargeShape","","Gamma distribution where the shape parameter is larger than 1.",null,null],[12,"scale","","",17,null],[12,"c","","",17,null],[12,"d","","",17,null],[3,"ChiSquared","","The chi-squared distribution `χ²(k)`, where `k` is the degrees of freedom.",null,null],[12,"repr","","",18,null],[3,"FisherF","","The Fisher F distribution `F(m, n)`.",null,null],[12,"numer","","",19,null],[12,"denom","","",19,null],[12,"dof_ratio","","",19,null],[3,"StudentT","","The Student t distribution, `t(nu)`, where `nu` is the degrees of freedom.",null,null],[12,"chi","","",20,null],[12,"dof","","",20,null],[4,"GammaRepr","","",null,null],[13,"Large","","",21,null],[13,"One","","",21,null],[13,"Small","","",21,null],[4,"ChiSquaredRepr","","",null,null],[13,"DoFExactlyOne","","",22,null],[13,"DoFAnythingElse","","",22,null],[11,"clone","","",15,{"i":[{"n":"self"}],"o":{"n":"gamma"}}],[11,"fmt","","",15,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",21,{"i":[{"n":"self"}],"o":{"n":"gammarepr"}}],[11,"fmt","","",21,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",16,{"i":[{"n":"self"}],"o":{"n":"gammasmallshape"}}],[11,"fmt","","",16,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",17,{"i":[{"n":"self"}],"o":{"n":"gammalargeshape"}}],[11,"fmt","","",17,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","Construct an object representing the `Gamma(shape, scale)` distribution.",15,{"i":[{"n":"f64"},{"n":"f64"}],"o":{"n":"gamma"}}],[11,"new_raw","","",16,{"i":[{"n":"f64"},{"n":"f64"}],"o":{"n":"gammasmallshape"}}],[11,"new_raw","","",17,{"i":[{"n":"f64"},{"n":"f64"}],"o":{"n":"gammalargeshape"}}],[11,"sample","","",15,{"i":[{"n":"self"},{"n":"r"}],"o":{"n":"f64"}}],[11,"sample","","",16,{"i":[{"n":"self"},{"n":"r"}],"o":{"n":"f64"}}],[11,"sample","","",17,{"i":[{"n":"self"},{"n":"r"}],"o":{"n":"f64"}}],[11,"ind_sample","","",15,{"i":[{"n":"self"},{"n":"r"}],"o":{"n":"f64"}}],[11,"ind_sample","","",16,{"i":[{"n":"self"},{"n":"r"}],"o":{"n":"f64"}}],[11,"ind_sample","","",17,{"i":[{"n":"self"},{"n":"r"}],"o":{"n":"f64"}}],[11,"clone","","",18,{"i":[{"n":"self"}],"o":{"n":"chisquared"}}],[11,"fmt","","",18,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",22,{"i":[{"n":"self"}],"o":{"n":"chisquaredrepr"}}],[11,"fmt","","",22,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","Create a new chi-squared distribution with degrees-of-freedom `k`. Panics if `k < 0`.",18,{"i":[{"n":"f64"}],"o":{"n":"chisquared"}}],[11,"sample","","",18,{"i":[{"n":"self"},{"n":"r"}],"o":{"n":"f64"}}],[11,"ind_sample","","",18,{"i":[{"n":"self"},{"n":"r"}],"o":{"n":"f64"}}],[11,"clone","","",19,{"i":[{"n":"self"}],"o":{"n":"fisherf"}}],[11,"fmt","","",19,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","Create a new `FisherF` distribution, with the given parameter. Panics if either `m` or `n` are not positive.",19,{"i":[{"n":"f64"},{"n":"f64"}],"o":{"n":"fisherf"}}],[11,"sample","","",19,{"i":[{"n":"self"},{"n":"r"}],"o":{"n":"f64"}}],[11,"ind_sample","","",19,{"i":[{"n":"self"},{"n":"r"}],"o":{"n":"f64"}}],[11,"clone","","",20,{"i":[{"n":"self"}],"o":{"n":"studentt"}}],[11,"fmt","","",20,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","Create a new Student t distribution with `n` degrees of freedom. Panics if `n <= 0`.",20,{"i":[{"n":"f64"}],"o":{"n":"studentt"}}],[11,"sample","","",20,{"i":[{"n":"self"},{"n":"r"}],"o":{"n":"f64"}}],[11,"ind_sample","","",20,{"i":[{"n":"self"},{"n":"r"}],"o":{"n":"f64"}}],[0,"normal","rand::distributions","The normal and derived distributions.",null,null],[3,"StandardNormal","rand::distributions::normal","A wrapper around an `f64` to generate N(0, 1) random numbers (a.k.a.  a standard normal, or Gaussian).",null,null],[12,"0","","",23,null],[3,"Normal","","The normal distribution `N(mean, std_dev**2)`.",null,null],[12,"mean","","",24,null],[12,"std_dev","","",24,null],[3,"LogNormal","","The log-normal distribution `ln N(mean, std_dev**2)`.",null,null],[12,"norm","","",25,null],[11,"clone","","",23,{"i":[{"n":"self"}],"o":{"n":"standardnormal"}}],[11,"fmt","","",23,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"rand","","",23,{"i":[{"n":"r"}],"o":{"n":"standardnormal"}}],[11,"clone","","",24,{"i":[{"n":"self"}],"o":{"n":"normal"}}],[11,"fmt","","",24,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","Construct a new `Normal` distribution with the given mean and standard deviation.",24,{"i":[{"n":"f64"},{"n":"f64"}],"o":{"n":"normal"}}],[11,"sample","","",24,{"i":[{"n":"self"},{"n":"r"}],"o":{"n":"f64"}}],[11,"ind_sample","","",24,{"i":[{"n":"self"},{"n":"r"}],"o":{"n":"f64"}}],[11,"clone","","",25,{"i":[{"n":"self"}],"o":{"n":"lognormal"}}],[11,"fmt","","",25,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","Construct a new `LogNormal` distribution with the given mean and standard deviation.",25,{"i":[{"n":"f64"},{"n":"f64"}],"o":{"n":"lognormal"}}],[11,"sample","","",25,{"i":[{"n":"self"},{"n":"r"}],"o":{"n":"f64"}}],[11,"ind_sample","","",25,{"i":[{"n":"self"},{"n":"r"}],"o":{"n":"f64"}}],[0,"exponential","rand::distributions","The exponential distribution.",null,null],[3,"Exp1","rand::distributions::exponential","A wrapper around an `f64` to generate Exp(1) random numbers.",null,null],[12,"0","","",26,null],[3,"Exp","","The exponential distribution `Exp(lambda)`.",null,null],[12,"lambda_inverse","","`lambda` stored as `1/lambda`, since this is what we scale by.",27,null],[11,"clone","","",26,{"i":[{"n":"self"}],"o":{"n":"exp1"}}],[11,"fmt","","",26,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"rand","","",26,{"i":[{"n":"r"}],"o":{"n":"exp1"}}],[11,"clone","","",27,{"i":[{"n":"self"}],"o":{"n":"exp"}}],[11,"fmt","","",27,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","Construct a new `Exp` with the given shape parameter `lambda`. Panics if `lambda <= 0`.",27,{"i":[{"n":"f64"}],"o":{"n":"exp"}}],[11,"sample","","",27,{"i":[{"n":"self"},{"n":"r"}],"o":{"n":"f64"}}],[11,"ind_sample","","",27,{"i":[{"n":"self"},{"n":"r"}],"o":{"n":"f64"}}],[0,"ziggurat_tables","rand::distributions","",null,null],[6,"ZigTable","rand::distributions::ziggurat_tables","",null,null],[7,"ZIG_NORM_X","","",null,null],[7,"ZIG_NORM_F","","",null,null],[7,"ZIG_EXP_X","","",null,null],[7,"ZIG_EXP_F","","",null,null],[17,"ZIG_NORM_R","","",null,null],[17,"ZIG_EXP_R","","",null,null],[8,"Sample","rand::distributions","Types that can be used to create a random instance of `Support`.",null,null],[10,"sample","","Generate a random value of `Support`, using `rng` as the source of randomness.",28,{"i":[{"n":"self"},{"n":"r"}],"o":{"n":"support"}}],[8,"IndependentSample","","`Sample`s that do not require keeping track of state.",null,null],[10,"ind_sample","","Generate a random value.",29,{"i":[{"n":"self"},{"n":"r"}],"o":{"n":"support"}}],[11,"fmt","","",10,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",10,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"sample","","",10,{"i":[{"n":"self"},{"n":"r"}],"o":{"n":"sup"}}],[11,"ind_sample","","",10,{"i":[{"n":"self"},{"n":"r"}],"o":{"n":"sup"}}],[11,"new","","",10,{"o":{"n":"randsample"}}],[11,"clone","","",11,{"i":[{"n":"self"}],"o":{"n":"weighted"}}],[11,"fmt","","",11,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",12,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","Create a new `WeightedChoice`.",12,null],[11,"sample","","",12,{"i":[{"n":"self"},{"n":"r"}],"o":{"n":"t"}}],[11,"ind_sample","","",12,{"i":[{"n":"self"},{"n":"r"}],"o":{"n":"t"}}],[0,"jitter","rand","Non-physical true random number generator based on timing jitter.",null,null],[3,"JitterRng","rand::jitter","A true random number generator based on jitter in the CPU execution time, and jitter in memory access time.",null,null],[12,"data","","",30,null],[12,"rounds","","",30,null],[12,"timer","","",30,null],[12,"prev_time","","",30,null],[12,"last_delta","","",30,null],[12,"last_delta2","","",30,null],[12,"mem_prev_index","","",30,null],[12,"mem","","",30,null],[12,"data_remaining","","",30,null],[4,"TimerError","","An error that can occur when `test_timer` fails.",null,null],[13,"NoTimer","","No timer available.",31,null],[13,"CoarseTimer","","Timer too coarse to use as an entropy source.",31,null],[13,"NotMonotonic","","Timer is not monotonically increasing.",31,null],[13,"TinyVariantions","","Variations of deltas of time too small.",31,null],[13,"TooManyStuck","","Too many stuck results (indicating no added entropy).",31,null],[13,"__Nonexhaustive","","",31,null],[5,"black_box","","",null,{"i":[{"n":"t"}],"o":{"n":"t"}}],[0,"platform","","",null,null],[5,"get_nstime","rand::jitter::platform","",null,{"o":{"n":"u64"}}],[7,"JITTER_ROUNDS","rand::jitter","",null,null],[17,"MEMORY_BLOCKS","","",null,null],[17,"MEMORY_BLOCKSIZE","","",null,null],[17,"MEMORY_SIZE","","",null,null],[11,"fmt","","",30,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",31,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",31,{"i":[{"n":"self"}],"o":{"n":"timererror"}}],[11,"eq","","",31,{"i":[{"n":"self"},{"n":"timererror"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",31,null],[11,"description","","",31,{"i":[{"n":"self"}],"o":{"n":"str"}}],[11,"fmt","","",31,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"description","","",31,{"i":[{"n":"self"}],"o":{"n":"str"}}],[11,"new","","Create a new `JitterRng`. Makes use of `std::time` for a timer.",30,{"o":{"g":["jitterrng","timererror"],"n":"result"}}],[11,"new_with_timer","","Create a new `JitterRng`. A custom timer can be supplied, making it possible to use `JitterRng` in `no_std` environments.",30,null],[11,"set_rounds","","Configures how many rounds are used to generate each 64-bit value. This must be greater than zero, and has a big impact on performance and output quality.",30,{"i":[{"n":"self"},{"n":"u32"}]}],[11,"random_loop_cnt","","",30,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"u32"}}],[11,"lfsr_time","","",30,{"i":[{"n":"self"},{"n":"u64"},{"n":"bool"}]}],[11,"memaccess","","",30,{"i":[{"n":"self"},{"n":"bool"}]}],[11,"stuck","","",30,{"i":[{"n":"self"},{"n":"i64"}],"o":{"n":"bool"}}],[11,"measure_jitter","","",30,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"stir_pool","","",30,{"i":[{"n":"self"}]}],[11,"gen_entropy","","",30,{"i":[{"n":"self"}],"o":{"n":"u64"}}],[11,"test_timer","","Basic quality tests on the timer, by measuring CPU timing jitter a few hundred times.",30,{"i":[{"n":"self"}],"o":{"g":["u32","timererror"],"n":"result"}}],[11,"timer_stats","","Statistical test: return the timer delta of one normal run of the `JitterEntropy` entropy collector.",30,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"i64"}}],[11,"next_u32","","",30,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"next_u64","","",30,{"i":[{"n":"self"}],"o":{"n":"u64"}}],[11,"fill_bytes","","",30,null],[0,"os","rand","Interfaces to the operating system provided random number generators.",null,null],[3,"OsRng","rand::os","A random number generator that retrieves randomness straight from the operating system. Platform sources:",null,null],[12,"0","","",32,null],[5,"next_u32","","",null,{"i":[{"n":"fnmut"}],"o":{"n":"u32"}}],[5,"next_u64","","",null,{"i":[{"n":"fnmut"}],"o":{"n":"u64"}}],[0,"imp","","",null,null],[3,"OsRng","rand::os::imp","",null,null],[12,"inner","","",33,null],[4,"OsRngInner","","",null,null],[13,"OsGetrandomRng","","",34,null],[13,"OsReadRng","","",34,null],[5,"getrandom","","",null,null],[5,"getrandom_fill_bytes","","",null,null],[5,"is_getrandom_available","","",null,{"o":{"n":"bool"}}],[11,"new","","",33,{"o":{"g":["osrng"],"n":"result"}}],[11,"next_u32","","",33,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"next_u64","","",33,{"i":[{"n":"self"}],"o":{"n":"u64"}}],[11,"fill_bytes","","",33,null],[11,"new","rand::os","Create a new `OsRng`.",32,{"o":{"g":["osrng"],"n":"result"}}],[11,"next_u32","","",32,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"next_u64","","",32,{"i":[{"n":"self"}],"o":{"n":"u64"}}],[11,"fill_bytes","","",32,null],[11,"fmt","","",32,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[0,"read","rand","A wrapper around any Read to treat it as an RNG.",null,null],[3,"ReadRng","rand::read","An RNG that reads random bytes straight from a `Read`. This will work best with an infinite reader, but this is not required.",null,null],[12,"reader","","",35,null],[5,"fill","","",null,null],[11,"fmt","","",35,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","Create a new `ReadRng` from a `Read`.",35,{"i":[{"n":"r"}],"o":{"n":"readrng"}}],[11,"next_u32","","",35,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"next_u64","","",35,{"i":[{"n":"self"}],"o":{"n":"u64"}}],[11,"fill_bytes","","",35,null],[0,"reseeding","rand","A wrapper around another RNG that reseeds it after it generates a certain number of random bytes.",null,null],[3,"ReseedingRng","rand::reseeding","A wrapper around any RNG which reseeds the underlying RNG after it has generated a certain number of random bytes.",null,null],[12,"rng","","",36,null],[12,"generation_threshold","","",36,null],[12,"bytes_generated","","",36,null],[12,"reseeder","","Controls the behaviour when reseeding the RNG.",36,null],[3,"ReseedWithDefault","","Reseed an RNG using a `Default` instance. This reseeds by replacing the RNG with the result of a `Default::default` call.",null,null],[17,"DEFAULT_GENERATION_THRESHOLD","","How many bytes of entropy the underling RNG is allowed to generate before it is reseeded",null,null],[8,"Reseeder","","Something that can be used to reseed an RNG via `ReseedingRng`.",null,null],[10,"reseed","","Reseed the given RNG.",37,{"i":[{"n":"self"},{"n":"r"}]}],[11,"fmt","","",36,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","Create a new `ReseedingRng` with the given parameters.",36,{"i":[{"n":"r"},{"n":"u64"},{"n":"rsdr"}],"o":{"n":"reseedingrng"}}],[11,"reseed_if_necessary","","Reseed the internal RNG if the number of bytes that have been generated exceed the threshold.",36,{"i":[{"n":"self"}]}],[11,"next_u32","","",36,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"next_u64","","",36,{"i":[{"n":"self"}],"o":{"n":"u64"}}],[11,"fill_bytes","","",36,null],[11,"reseed","","",36,null],[11,"from_seed","","Create a new `ReseedingRng` from the given reseeder and seed. This uses a default value for `generation_threshold`.",36,null],[11,"clone","","",38,{"i":[{"n":"self"}],"o":{"n":"reseedwithdefault"}}],[11,"fmt","","",38,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"reseed","","",38,{"i":[{"n":"self"},{"n":"r"}]}],[11,"default","","",38,{"o":{"n":"reseedwithdefault"}}],[0,"seq","rand","Functions for randomly accessing and sampling sequences.",null,null],[5,"sample_iter","rand::seq","Randomly sample `amount` elements from a finite iterator.",null,{"i":[{"n":"r"},{"n":"i"},{"n":"usize"}],"o":{"g":["vec","vec"],"n":"result"}}],[5,"sample_slice","","Randomly sample exactly `amount` values from `slice`.",null,null],[5,"sample_slice_ref","","Randomly sample exactly `amount` references from `slice`.",null,null],[5,"sample_indices","","Randomly sample exactly `amount` indices from `0..length`.",null,{"i":[{"n":"r"},{"n":"usize"},{"n":"usize"}],"o":{"g":["usize"],"n":"vec"}}],[5,"sample_indices_inplace","","Sample an amount of indices using an inplace partial fisher yates method.",null,{"i":[{"n":"r"},{"n":"usize"},{"n":"usize"}],"o":{"g":["usize"],"n":"vec"}}],[5,"sample_indices_cache","","This method performs a partial fisher-yates on a range of indices using a HashMap as a cache to record potential collisions.",null,{"i":[{"n":"r"},{"n":"usize"},{"n":"usize"}],"o":{"g":["usize"],"n":"vec"}}],[0,"chacha","rand","The ChaCha random number generator.",null,null],[3,"ChaChaRng","rand::chacha","A random number generator that uses the ChaCha20 algorithm [1].",null,null],[12,"buffer","","",2,null],[12,"state","","",2,null],[12,"index","","",2,null],[0,"isaac","rand","The ISAAC random number generator.",null,null],[3,"IsaacRng","rand::isaac","A random number generator that uses the ISAAC algorithm[1].",null,null],[12,"cnt","","",0,null],[12,"rsl","","",0,null],[12,"mem","","",0,null],[12,"a","","",0,null],[12,"b","","",0,null],[12,"c","","",0,null],[3,"Isaac64Rng","","A random number generator that uses ISAAC-64[1], the 64-bit variant of the ISAAC algorithm.",null,null],[12,"cnt","","",1,null],[12,"rsl","","",1,null],[12,"mem","","",1,null],[12,"a","","",1,null],[12,"b","","",1,null],[12,"c","","",1,null],[0,"rand_impls","rand","The implementations of `Rand` for the built-in types.",null,null],[0,"f64_rand_impls","rand::rand_impls","",null,null],[17,"SCALE","rand::rand_impls::f64_rand_impls","",null,null],[11,"rand","rand","",6,{"i":[{"n":"r"}],"o":{"g":["f64"],"n":"open01"}}],[11,"rand","","",7,{"i":[{"n":"r"}],"o":{"g":["f64"],"n":"closed01"}}],[0,"f32_rand_impls","rand::rand_impls","",null,null],[17,"SCALE","rand::rand_impls::f32_rand_impls","",null,null],[11,"rand","rand","",6,{"i":[{"n":"r"}],"o":{"g":["f32"],"n":"open01"}}],[11,"rand","","",7,{"i":[{"n":"r"}],"o":{"g":["f32"],"n":"closed01"}}],[0,"prng","","Pseudo random number generators are algorithms to produce apparently random numbers deterministically, and usually fairly quickly.",null,null],[0,"chacha","rand::prng","The ChaCha random number generator.",null,null],[3,"ChaChaRng","rand::prng::chacha","A random number generator that uses the ChaCha20 algorithm [1].",null,null],[12,"buffer","","",2,null],[12,"state","","",2,null],[12,"index","","",2,null],[5,"core","","",null,null],[6,"w32","","",null,null],[7,"EMPTY","","",null,null],[17,"KEY_WORDS","","",null,null],[17,"STATE_WORDS","","",null,null],[17,"CHACHA_ROUNDS","","",null,null],[11,"clone","rand","",2,{"i":[{"n":"self"}],"o":{"n":"chacharng"}}],[11,"fmt","","",2,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new_unseeded","","Create an ChaCha random number generator using the default fixed key of 8 zero words.",2,{"o":{"n":"chacharng"}}],[11,"set_counter","","Sets the internal 128-bit ChaCha counter to a user-provided value. This permits jumping arbitrarily ahead (or backwards) in the pseudorandom stream.",2,{"i":[{"n":"self"},{"n":"u64"},{"n":"u64"}]}],[11,"init","","Initializes `self.state` with the appropriate key and constants",2,null],[11,"update","","Refill the internal output buffer (`self.buffer`)",2,{"i":[{"n":"self"}]}],[11,"next_u32","","",2,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"reseed","","",2,null],[11,"from_seed","","Create a ChaCha generator from a seed, obtained from a variable-length u32 array. Only up to 8 words are used; if less than 8 words are used, the remaining are set to zero.",2,null],[11,"rand","","",2,{"i":[{"n":"r"}],"o":{"n":"chacharng"}}],[0,"isaac","rand::prng","The ISAAC random number generator.",null,null],[3,"IsaacRng","rand::prng::isaac","A random number generator that uses the ISAAC algorithm[1].",null,null],[12,"cnt","","",0,null],[12,"rsl","","",0,null],[12,"mem","","",0,null],[12,"a","","",0,null],[12,"b","","",0,null],[12,"c","","",0,null],[6,"w32","","",null,null],[7,"EMPTY","","",null,null],[17,"RAND_SIZE_LEN","","",null,null],[17,"RAND_SIZE","","",null,null],[17,"RAND_SIZE_USIZE","","",null,null],[11,"new_unseeded","rand","Create an ISAAC random number generator using the default fixed seed.",0,{"o":{"n":"isaacrng"}}],[11,"init","","Initialises `self`. If `use_rsl` is true, then use the current value of `rsl` as a seed, otherwise construct one algorithmically (not randomly).",0,{"i":[{"n":"self"},{"n":"bool"}]}],[11,"isaac","","Refills the output buffer (`self.rsl`)",0,{"i":[{"n":"self"}]}],[11,"clone","","",0,{"i":[{"n":"self"}],"o":{"n":"isaacrng"}}],[11,"next_u32","","",0,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"reseed","","",0,null],[11,"from_seed","","Create an ISAAC random number generator with a seed. This can be any length, although the maximum number of elements used is 256 and any more will be silently ignored. A generator constructed with a given seed will generate the same sequence of values as all other generators constructed with that seed.",0,null],[11,"rand","","",0,{"i":[{"n":"r"}],"o":{"n":"isaacrng"}}],[11,"fmt","","",0,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[0,"isaac64","rand::prng","The ISAAC-64 random number generator.",null,null],[3,"Isaac64Rng","rand::prng::isaac64","A random number generator that uses ISAAC-64[1], the 64-bit variant of the ISAAC algorithm.",null,null],[12,"cnt","","",1,null],[12,"rsl","","",1,null],[12,"mem","","",1,null],[12,"a","","",1,null],[12,"b","","",1,null],[12,"c","","",1,null],[6,"w64","","",null,null],[7,"EMPTY_64","","",null,null],[17,"RAND_SIZE_64_LEN","","",null,null],[17,"RAND_SIZE_64","","",null,null],[11,"new_unseeded","rand","Create a 64-bit ISAAC random number generator using the default fixed seed.",1,{"o":{"n":"isaac64rng"}}],[11,"init","","Initialises `self`. If `use_rsl` is true, then use the current value of `rsl` as a seed, otherwise construct one algorithmically (not randomly).",1,{"i":[{"n":"self"},{"n":"bool"}]}],[11,"isaac64","","Refills the output buffer (`self.rsl`)",1,{"i":[{"n":"self"}]}],[11,"clone","","",1,{"i":[{"n":"self"}],"o":{"n":"isaac64rng"}}],[11,"next_u32","","",1,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"next_u64","","",1,{"i":[{"n":"self"}],"o":{"n":"u64"}}],[11,"reseed","","",1,null],[11,"from_seed","","Create an ISAAC random number generator with a seed. This can be any length, although the maximum number of elements used is 256 and any more will be silently ignored. A generator constructed with a given seed will generate the same sequence of values as all other generators constructed with that seed.",1,null],[11,"rand","","",1,{"i":[{"n":"r"}],"o":{"n":"isaac64rng"}}],[11,"fmt","","",1,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[0,"xorshift","rand::prng","Xorshift generators",null,null],[3,"XorShiftRng","rand::prng::xorshift","An Xorshift[1] random number generator.",null,null],[12,"x","","",3,null],[12,"y","","",3,null],[12,"z","","",3,null],[12,"w","","",3,null],[11,"clone","rand","",3,{"i":[{"n":"self"}],"o":{"n":"xorshiftrng"}}],[11,"fmt","","",3,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new_unseeded","","Creates a new XorShiftRng instance which is not seeded.",3,{"o":{"n":"xorshiftrng"}}],[11,"next_u32","","",3,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"reseed","","Reseed an XorShiftRng. This will panic if `seed` is entirely 0.",3,null],[11,"from_seed","","Create a new XorShiftRng. This will panic if `seed` is entirely 0.",3,null],[11,"rand","","",3,{"i":[{"n":"r"}],"o":{"n":"xorshiftrng"}}],[6,"ThreadRngInner","","",null,null],[17,"THREAD_RNG_RESEED_THRESHOLD","","",null,null],[8,"Rand","","A type that can be randomly generated using an `Rng`.",null,null],[10,"rand","","Generates a random instance of this type using the specified source of randomness.",39,{"i":[{"n":"r"}],"o":{"n":"self"}}],[8,"Rng","","A random number generator.",null,null],[10,"next_u32","","Return the next random u32.",40,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"next_u64","","Return the next random u64.",40,{"i":[{"n":"self"}],"o":{"n":"u64"}}],[11,"next_f32","","Return the next random f32 selected from the half-open interval `[0, 1)`.",40,{"i":[{"n":"self"}],"o":{"n":"f32"}}],[11,"next_f64","","Return the next random f64 selected from the half-open interval `[0, 1)`.",40,{"i":[{"n":"self"}],"o":{"n":"f64"}}],[11,"fill_bytes","","Fill `dest` with random data.",40,null],[11,"gen","","Return a random value of a `Rand` type.",40,{"i":[{"n":"self"}],"o":{"n":"t"}}],[11,"gen_iter","","Return an iterator that will yield an infinite number of randomly generated items.",40,{"i":[{"n":"self"}],"o":{"n":"generator"}}],[11,"gen_range","","Generate a random value in the range [`low`, `high`).",40,{"i":[{"n":"self"},{"n":"t"},{"n":"t"}],"o":{"n":"t"}}],[11,"gen_weighted_bool","","Return a bool with a 1 in n chance of true",40,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"bool"}}],[11,"gen_ascii_chars","","Return an iterator of random characters from the set A-Z,a-z,0-9.",40,{"i":[{"n":"self"}],"o":{"n":"asciigenerator"}}],[11,"choose","","Return a random element from `values`.",40,null],[11,"choose_mut","","Return a mutable pointer to a random element from `values`.",40,null],[11,"shuffle","","Shuffle a mutable slice in place.",40,null],[8,"SeedableRng","","A random number generator that can be explicitly seeded to produce the same stream of randomness multiple times.",null,null],[10,"reseed","","Reseed an RNG with the given seed.",41,{"i":[{"n":"self"},{"n":"seed"}]}],[10,"from_seed","","Create a new RNG with the given seed.",41,{"i":[{"n":"seed"}],"o":{"n":"self"}}],[11,"fmt","","",4,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",4,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"fmt","","",5,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",5,{"i":[{"n":"self"}],"o":{"g":["char"],"n":"option"}}],[11,"fmt","","",6,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",7,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",8,{"i":[{"n":"self"}],"o":{"n":"stdrng"}}],[11,"fmt","","",8,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","Create a randomly seeded instance of `StdRng`.",8,{"o":{"g":["stdrng"],"n":"result"}}],[11,"next_u32","","",8,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"next_u64","","",8,{"i":[{"n":"self"}],"o":{"n":"u64"}}],[11,"reseed","","",8,null],[11,"from_seed","","",8,null],[11,"fmt","","",42,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"reseed","","",42,{"i":[{"n":"self"},{"n":"stdrng"}]}],[11,"clone","","",9,{"i":[{"n":"self"}],"o":{"n":"threadrng"}}],[11,"fmt","","",9,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next_u32","","",9,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"next_u64","","",9,{"i":[{"n":"self"}],"o":{"n":"u64"}}],[11,"fill_bytes","","",9,null]],"paths":[[3,"IsaacRng"],[3,"Isaac64Rng"],[3,"ChaChaRng"],[3,"XorShiftRng"],[3,"Generator"],[3,"AsciiGenerator"],[3,"Open01"],[3,"Closed01"],[3,"StdRng"],[3,"ThreadRng"],[3,"RandSample"],[3,"Weighted"],[3,"WeightedChoice"],[3,"Range"],[8,"SampleRange"],[3,"Gamma"],[3,"GammaSmallShape"],[3,"GammaLargeShape"],[3,"ChiSquared"],[3,"FisherF"],[3,"StudentT"],[4,"GammaRepr"],[4,"ChiSquaredRepr"],[3,"StandardNormal"],[3,"Normal"],[3,"LogNormal"],[3,"Exp1"],[3,"Exp"],[8,"Sample"],[8,"IndependentSample"],[3,"JitterRng"],[4,"TimerError"],[3,"OsRng"],[3,"OsRng"],[4,"OsRngInner"],[3,"ReadRng"],[3,"ReseedingRng"],[8,"Reseeder"],[3,"ReseedWithDefault"],[8,"Rand"],[8,"Rng"],[8,"SeedableRng"],[3,"ThreadRngReseeder"]]};
searchIndex["regex"] = {"doc":"This crate provides a library for parsing, compiling, and executing regular expressions. Its syntax is similar to Perl-style regular expressions, but lacks a few features like look around and backreferences. In exchange, all searches execute in linear time with respect to the size of the regular expression and search text.","items":[[3,"RegexBuilder","regex","A configurable builder for a regular expression.",null,null],[12,"0","","",0,null],[3,"RegexSetBuilder","","A configurable builder for a set of regular expressions.",null,null],[12,"0","","",1,null],[3,"RegexSet","","Match multiple (possibly overlapping) regular expressions in a single scan.",null,null],[12,"0","","",2,null],[3,"SetMatches","","A set of matches returned by a regex set.",null,null],[12,"matched_any","","",3,null],[12,"matches","","",3,null],[3,"SetMatchesIntoIter","","An owned iterator over the set of matches from a regex set.",null,null],[12,"0","","",4,null],[3,"SetMatchesIter","","A borrowed iterator over the set of matches from a regex set.",null,null],[12,"0","","",5,null],[3,"Locations","","Locations represents the offsets of each capturing group in a regex for a single match.",null,null],[12,"0","","",6,null],[3,"Regex","","A compiled regular expression for matching Unicode strings.",null,null],[12,"0","","",7,null],[3,"Match","","Match represents a single match of a regex in a haystack.",null,null],[12,"text","","",8,null],[12,"start","","",8,null],[12,"end","","",8,null],[3,"Captures","","Captures represents a group of captured strings for a single match.",null,null],[12,"text","","",9,null],[12,"locs","","",9,null],[12,"named_groups","","",9,null],[3,"CaptureNames","","An iterator over the names of all possible captures.",null,null],[12,"0","","",10,null],[3,"Matches","","An iterator over all non-overlapping matches for a particular string.",null,null],[12,"0","","",11,null],[3,"CaptureMatches","","An iterator that yields all non-overlapping capture groups matching a particular regular expression.",null,null],[12,"0","","",12,null],[3,"SubCaptureMatches","","An iterator that yields all capturing matches in the order in which they appear in the regex.",null,null],[12,"caps","","",13,null],[12,"it","","",13,null],[3,"ReplacerRef","","By-reference adaptor for a `Replacer`",null,null],[12,"0","","",14,null],[3,"NoExpand","","`NoExpand` indicates literal string replacement.",null,null],[12,"0","","",15,null],[3,"Split","","Yields all substrings delimited by a regular expression match.",null,null],[12,"finder","","",16,null],[12,"last","","",16,null],[3,"SplitN","","Yields at most `N` substrings delimited by a regular expression match.",null,null],[12,"splits","","",17,null],[12,"n","","",17,null],[4,"Error","","An error that occurred during parsing or compiling a regular expression.",null,null],[13,"Syntax","","A syntax error.",18,null],[13,"CompiledTooBig","","The compiled program exceeded the set size limit. The argument is the size limit imposed.",18,null],[13,"__Nonexhaustive","","Hints that destructuring should not be exhaustive.",18,null],[5,"escape","","Escapes all regular expression meta characters in `text`.",null,{"i":[{"n":"str"}],"o":{"n":"string"}}],[0,"bytes","","Match regular expressions on arbitrary bytes.",null,null],[3,"RegexBuilder","regex::bytes","A configurable builder for a regular expression.",null,null],[12,"0","","",19,null],[3,"RegexSetBuilder","","A configurable builder for a set of regular expressions.",null,null],[12,"0","","",20,null],[3,"Match","","Match represents a single match of a regex in a haystack.",null,null],[12,"text","","",21,null],[12,"start","","",21,null],[12,"end","","",21,null],[3,"Regex","","A compiled regular expression for matching arbitrary bytes.",null,null],[12,"0","","",22,null],[3,"Matches","","An iterator over all non-overlapping matches for a particular string.",null,null],[12,"0","","",23,null],[3,"CaptureMatches","","An iterator that yields all non-overlapping capture groups matching a particular regular expression.",null,null],[12,"0","","",24,null],[3,"Split","","Yields all substrings delimited by a regular expression match.",null,null],[12,"finder","","",25,null],[12,"last","","",25,null],[3,"SplitN","","Yields at most `N` substrings delimited by a regular expression match.",null,null],[12,"splits","","",26,null],[12,"n","","",26,null],[3,"CaptureNames","","An iterator over the names of all possible captures.",null,null],[12,"0","","",27,null],[3,"Captures","","Captures represents a group of captured byte strings for a single match.",null,null],[12,"text","","",28,null],[12,"locs","","",28,null],[12,"named_groups","","",28,null],[3,"SubCaptureMatches","","An iterator that yields all capturing matches in the order in which they appear in the regex.",null,null],[12,"caps","","",29,null],[12,"it","","",29,null],[3,"ReplacerRef","","By-reference adaptor for a `Replacer`",null,null],[12,"0","","",30,null],[3,"NoExpand","","`NoExpand` indicates literal byte string replacement.",null,null],[12,"0","","",31,null],[3,"RegexSet","","Match multiple (possibly overlapping) regular expressions in a single scan.",null,null],[12,"0","","",32,null],[3,"SetMatches","","A set of matches returned by a regex set.",null,null],[12,"matched_any","","",33,null],[12,"matches","","",33,null],[3,"SetMatchesIntoIter","","An owned iterator over the set of matches from a regex set.",null,null],[12,"0","","",34,null],[3,"SetMatchesIter","","A borrowed iterator over the set of matches from a regex set.",null,null],[12,"0","","",35,null],[3,"Locations","","Locations represents the offsets of each capturing group in a regex for a single match.",null,null],[12,"0","","",6,null],[8,"Replacer","","Replacer describes types that can be used to replace matches in a byte string.",null,null],[10,"replace_append","","Appends text to `dst` to replace the current match.",36,{"i":[{"n":"self"},{"n":"captures"},{"n":"vec"}]}],[11,"no_expansion","","Return a fixed unchanging replacement byte string.",36,{"i":[{"n":"self"}],"o":{"g":["cow"],"n":"option"}}],[11,"by_ref","","Return a `Replacer` that borrows and wraps this `Replacer`.",36,{"i":[{"n":"self"}],"o":{"n":"replacerref"}}],[0,"backtrack","regex","",null,null],[3,"Bounded","regex::backtrack","A backtracking matching engine.",null,null],[12,"prog","","",37,null],[12,"input","","",37,null],[12,"matches","","",37,null],[12,"slots","","",37,null],[12,"m","","",37,null],[3,"Cache","","Shared cached state between multiple invocations of a backtracking engine in the same thread.",null,null],[12,"jobs","","",38,null],[12,"visited","","",38,null],[4,"Job","","A job is an explicit unit of stack space in the backtracking engine.",null,null],[13,"Inst","","",39,null],[12,"ip","regex::backtrack::Job","",39,null],[12,"at","","",39,null],[13,"SaveRestore","regex::backtrack","",39,null],[12,"slot","regex::backtrack::Job","",39,null],[12,"old_pos","","",39,null],[5,"should_exec","regex::backtrack","Returns true iff the given regex and input should be executed by this engine with reasonable memory usage.",null,{"i":[{"n":"usize"},{"n":"usize"}],"o":{"n":"bool"}}],[5,"usize_to_u32","","",null,{"i":[{"n":"usize"}],"o":{"n":"u32"}}],[6,"Bits","","",null,null],[17,"BIT_SIZE","","",null,null],[17,"MAX_SIZE_BYTES","","",null,null],[11,"fmt","","",37,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",38,{"i":[{"n":"self"}],"o":{"n":"cache"}}],[11,"fmt","","",38,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","Create new empty cache for the backtracking engine.",38,{"i":[{"n":"program"}],"o":{"n":"self"}}],[11,"clone","","",39,{"i":[{"n":"self"}],"o":{"n":"job"}}],[11,"fmt","","",39,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"exec","","Execute the backtracking matching engine.",37,null],[11,"clear","","Clears the cache such that the backtracking engine can be executed on some input of fixed length.",37,{"i":[{"n":"self"}]}],[11,"exec_","","Start backtracking at the given position in the input, but also look for literal prefixes.",37,{"i":[{"n":"self"},{"n":"inputat"}],"o":{"n":"bool"}}],[11,"backtrack","","The main backtracking loop starting at the given input position.",37,{"i":[{"n":"self"},{"n":"inputat"}],"o":{"n":"bool"}}],[11,"step","","",37,{"i":[{"n":"self"},{"n":"usize"},{"n":"inputat"}],"o":{"n":"bool"}}],[11,"has_visited","","",37,{"i":[{"n":"self"},{"n":"usize"},{"n":"inputat"}],"o":{"n":"bool"}}],[0,"utf8","regex","",null,null],[5,"next_utf8","regex::utf8","Returns the smallest possible index of the next valid UTF-8 sequence starting after `i`.",null,null],[5,"encode_utf8","","Encode the given Unicode character to `dst` as a single UTF-8 sequence.",null,null],[5,"decode_utf8","","Decode a single UTF-8 sequence into a single Unicode codepoint from `src`.",null,null],[5,"decode_last_utf8","","Like `decode_utf8`, but decodes the last UTF-8 sequence in `src` instead of the first.",null,null],[5,"is_start_byte","","",null,{"i":[{"n":"u8"}],"o":{"n":"bool"}}],[17,"TAG_CONT","","",null,null],[17,"TAG_TWO","","",null,null],[17,"TAG_THREE","","",null,null],[17,"TAG_FOUR","","",null,null],[0,"compile","regex","",null,null],[3,"Patch","regex::compile","",null,null],[12,"hole","","",40,null],[12,"entry","","",40,null],[3,"Compiler","","A compiler translates a regular expression AST to a sequence of instructions. The sequence of instructions represents an NFA.",null,null],[12,"insts","","",41,null],[12,"compiled","","",41,null],[12,"capture_name_idx","","",41,null],[12,"num_exprs","","",41,null],[12,"size_limit","","",41,null],[12,"suffix_cache","","",41,null],[12,"utf8_seqs","","",41,null],[12,"byte_classes","","",41,null],[3,"CompileClass","","",null,null],[12,"c","","",42,null],[12,"ranges","","",42,null],[3,"SuffixCache","","`SuffixCache` is a simple bounded hash map for caching suffix entries in UTF-8 automata. For example, consider the Unicode range \\u{0}-\\u{FFFF}. The set of byte ranges looks like this:",null,null],[12,"table","","",43,null],[12,"version","","",43,null],[3,"SuffixCacheEntry","","",null,null],[12,"key","","",44,null],[12,"pc","","",44,null],[12,"version","","",44,null],[3,"SuffixCacheKey","","",null,null],[12,"from_inst","","",45,null],[12,"start","","",45,null],[12,"end","","",45,null],[3,"ByteClassSet","","",null,null],[12,"0","","",46,null],[4,"Hole","","",null,null],[13,"None","","",47,null],[13,"One","","",47,null],[13,"Many","","",47,null],[4,"MaybeInst","","",null,null],[13,"Compiled","","",48,null],[13,"Uncompiled","","",48,null],[13,"Split","","",48,null],[13,"Split1","","",48,null],[13,"Split2","","",48,null],[4,"InstHole","","",null,null],[13,"Save","","",49,null],[12,"slot","regex::compile::InstHole","",49,null],[13,"EmptyLook","regex::compile","",49,null],[12,"look","regex::compile::InstHole","",49,null],[13,"Char","regex::compile","",49,null],[12,"c","regex::compile::InstHole","",49,null],[13,"Ranges","regex::compile","",49,null],[12,"ranges","regex::compile::InstHole","",49,null],[13,"Bytes","regex::compile","",49,null],[12,"start","regex::compile::InstHole","",49,null],[12,"end","","",49,null],[5,"u32_to_usize","regex::compile","",null,{"i":[{"n":"u32"}],"o":{"n":"usize"}}],[6,"Result","","",null,null],[11,"fmt","","",40,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","Create a new regular expression compiler.",41,{"o":{"n":"self"}}],[11,"size_limit","","The size of the resulting program is limited by size_limit. If the program approximately exceeds the given size (in bytes), then compilation will stop and return an error.",41,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"self"}}],[11,"bytes","","If bytes is true, then the program is compiled as a byte based automaton, which incorporates UTF-8 decoding into the machine. If it's false, then the automaton is Unicode scalar value based, e.g., an engine utilizing such an automaton is resposible for UTF-8 decoding.",41,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"self"}}],[11,"only_utf8","","When disabled, the program compiled may match arbitrary bytes.",41,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"self"}}],[11,"dfa","","When set, the machine returned is suitable for use in the DFA matching engine.",41,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"self"}}],[11,"reverse","","When set, the machine returned is suitable for matching text in reverse. In particular, all concatenations are flipped.",41,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"self"}}],[11,"compile","","Compile a regular expression given its AST.",41,null],[11,"compile_one","","",41,{"i":[{"n":"self"},{"n":"hir"}],"o":{"g":["program","error"],"n":"result"}}],[11,"compile_many","","",41,null],[11,"compile_finish","","",41,{"i":[{"n":"self"}],"o":{"g":["program","error"],"n":"result"}}],[11,"c","","Compile expr into self.insts, returning a patch on success, or an error if we run out of memory.",41,{"i":[{"n":"self"},{"n":"hir"}],"o":{"g":["patch","error"],"n":"result"}}],[11,"c_capture","","",41,{"i":[{"n":"self"},{"n":"usize"},{"n":"hir"}],"o":{"g":["patch","error"],"n":"result"}}],[11,"c_dotstar","","",41,{"i":[{"n":"self"}],"o":{"g":["patch","error"],"n":"result"}}],[11,"c_literal","","",41,null],[11,"c_char","","",41,{"i":[{"n":"self"},{"n":"char"}],"o":{"g":["patch","error"],"n":"result"}}],[11,"c_class","","",41,null],[11,"c_bytes","","",41,null],[11,"c_byte","","",41,{"i":[{"n":"self"},{"n":"u8"}],"o":{"g":["patch","error"],"n":"result"}}],[11,"c_class_bytes","","",41,null],[11,"c_empty_look","","",41,{"i":[{"n":"self"},{"n":"emptylook"}],"o":{"g":["patch","error"],"n":"result"}}],[11,"c_concat","","",41,{"i":[{"n":"self"},{"n":"i"}],"o":{"g":["patch","error"],"n":"result"}}],[11,"c_alternate","","",41,null],[11,"c_repeat","","",41,{"i":[{"n":"self"},{"n":"repetition"}],"o":{"g":["patch","error"],"n":"result"}}],[11,"c_repeat_zero_or_one","","",41,{"i":[{"n":"self"},{"n":"hir"},{"n":"bool"}],"o":{"g":["patch","error"],"n":"result"}}],[11,"c_repeat_zero_or_more","","",41,{"i":[{"n":"self"},{"n":"hir"},{"n":"bool"}],"o":{"g":["patch","error"],"n":"result"}}],[11,"c_repeat_one_or_more","","",41,{"i":[{"n":"self"},{"n":"hir"},{"n":"bool"}],"o":{"g":["patch","error"],"n":"result"}}],[11,"c_repeat_range_min_or_more","","",41,{"i":[{"n":"self"},{"n":"hir"},{"n":"bool"},{"n":"u32"}],"o":{"g":["patch","error"],"n":"result"}}],[11,"c_repeat_range","","",41,{"i":[{"n":"self"},{"n":"hir"},{"n":"bool"},{"n":"u32"},{"n":"u32"}],"o":{"g":["patch","error"],"n":"result"}}],[11,"fill","","",41,{"i":[{"n":"self"},{"n":"hole"},{"n":"usize"}]}],[11,"fill_to_next","","",41,{"i":[{"n":"self"},{"n":"hole"}]}],[11,"fill_split","","",41,{"i":[{"n":"self"},{"n":"hole"},{"g":["usize"],"n":"option"},{"g":["usize"],"n":"option"}],"o":{"n":"hole"}}],[11,"push_compiled","","",41,{"i":[{"n":"self"},{"n":"inst"}]}],[11,"push_hole","","",41,{"i":[{"n":"self"},{"n":"insthole"}],"o":{"n":"hole"}}],[11,"push_split_hole","","",41,{"i":[{"n":"self"}],"o":{"n":"hole"}}],[11,"check_size","","",41,{"i":[{"n":"self"}],"o":{"g":["error"],"n":"result"}}],[11,"fmt","","",47,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",48,{"i":[{"n":"self"}],"o":{"n":"maybeinst"}}],[11,"fmt","","",48,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fill","","",48,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"fill_split","","",48,{"i":[{"n":"self"},{"n":"usize"},{"n":"usize"}]}],[11,"half_fill_split_goto1","","",48,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"half_fill_split_goto2","","",48,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"unwrap","","",48,{"i":[{"n":"self"}],"o":{"n":"inst"}}],[11,"clone","","",49,{"i":[{"n":"self"}],"o":{"n":"insthole"}}],[11,"fmt","","",49,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fill","","",49,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"inst"}}],[11,"compile","","",42,{"i":[{"n":"self"}],"o":{"g":["patch","error"],"n":"result"}}],[11,"c_utf8_seq","","",42,{"i":[{"n":"self"},{"n":"utf8sequence"}],"o":{"g":["patch","error"],"n":"result"}}],[11,"c_utf8_seq_","","",42,{"i":[{"n":"self"},{"n":"i"}],"o":{"g":["patch","error"],"n":"result"}}],[11,"clone","","",44,{"i":[{"n":"self"}],"o":{"n":"suffixcacheentry"}}],[11,"fmt","","",44,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"default","","",44,{"o":{"n":"suffixcacheentry"}}],[11,"assert_receiver_is_total_eq","","",44,null],[11,"hash","","",44,null],[11,"eq","","",44,{"i":[{"n":"self"},{"n":"suffixcacheentry"}],"o":{"n":"bool"}}],[11,"ne","","",44,{"i":[{"n":"self"},{"n":"suffixcacheentry"}],"o":{"n":"bool"}}],[11,"clone","","",45,{"i":[{"n":"self"}],"o":{"n":"suffixcachekey"}}],[11,"fmt","","",45,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"default","","",45,{"o":{"n":"suffixcachekey"}}],[11,"assert_receiver_is_total_eq","","",45,null],[11,"hash","","",45,null],[11,"eq","","",45,{"i":[{"n":"self"},{"n":"suffixcachekey"}],"o":{"n":"bool"}}],[11,"ne","","",45,{"i":[{"n":"self"},{"n":"suffixcachekey"}],"o":{"n":"bool"}}],[11,"new","","",43,{"i":[{"n":"usize"}],"o":{"n":"self"}}],[11,"get","","",43,{"i":[{"n":"self"},{"n":"suffixcachekey"},{"n":"usize"}],"o":{"g":["usize"],"n":"option"}}],[11,"clear","","",43,{"i":[{"n":"self"}]}],[11,"hash","","",43,{"i":[{"n":"self"},{"n":"suffixcachekey"}],"o":{"n":"usize"}}],[11,"new","","",46,{"o":{"n":"self"}}],[11,"set_range","","",46,{"i":[{"n":"self"},{"n":"u8"},{"n":"u8"}]}],[11,"set_word_boundary","","",46,{"i":[{"n":"self"}]}],[11,"byte_classes","","",46,{"i":[{"n":"self"}],"o":{"g":["u8"],"n":"vec"}}],[0,"dfa","regex","The DFA matching engine.",null,null],[3,"Cache","regex::dfa","A reusable cache of DFA states.",null,null],[12,"inner","","Group persistent DFA related cache state together. The sparse sets listed below are used as scratch space while computing uncached states.",50,null],[12,"qcur","","qcur and qnext are ordered sets with constant time addition/membership/clearing-whole-set and linear time iteration. They are used to manage the sets of NFA states in DFA states when computing cached DFA states. In particular, the order of the NFA states matters for leftmost-first style matching. Namely, when computing a cached state, the set of NFA states stops growing as soon as the first Match instruction is observed.",50,null],[12,"qnext","","",50,null],[3,"CacheInner","","`CacheInner` is logically just a part of Cache, but groups together fields that aren't passed as function parameters throughout search. (This split is mostly an artifact of the borrow checker. It is happily paid.)",null,null],[12,"compiled","","A cache of pre-compiled DFA states, keyed by the set of NFA states and the set of empty-width flags set at the byte in the input when the state was observed.",51,null],[12,"trans","","The transition table.",51,null],[12,"states","","Our set of states. Note that `StatePtr / num_byte_classes` indexes this Vec rather than just a `StatePtr`.",51,null],[12,"start_states","","A set of cached start states, which are limited to the number of permutations of flags set just before the initial byte of input. (The index into this vec is a `EmptyFlags`.)",51,null],[12,"stack","","Stack scratch space used to follow epsilon transitions in the NFA. (This permits us to avoid recursion.)",51,null],[12,"flush_count","","The total number of times this cache has been flushed by the DFA because of space constraints.",51,null],[12,"size","","The total heap size of the DFA's cache. We use this to determine when we should flush the cache.",51,null],[3,"Transitions","","The transition table.",null,null],[12,"table","","The table.",52,null],[12,"num_byte_classes","","The stride.",52,null],[3,"Fsm","","Fsm encapsulates the actual execution of the DFA.",null,null],[12,"prog","","prog contains the NFA instruction opcodes. DFA execution uses either the `dfa` instructions or the `dfa_reverse` instructions from `exec::ExecReadOnly`. (It never uses `ExecReadOnly.nfa`, which may have Unicode opcodes that cannot be executed by the DFA.)",53,null],[12,"start","","The start state. We record it here because the pointer may change when the cache is wiped.",53,null],[12,"at","","The current position in the input.",53,null],[12,"quit_after_match","","Should we quit after seeing the first match? e.g., When the caller uses `is_match` or `shortest_match`.",53,null],[12,"last_match_si","","The last state that matched.",53,null],[12,"last_cache_flush","","The input position of the last cache flush. We use this to determine if we're thrashing in the cache too often. If so, the DFA quits so that we can fall back to the NFA algorithm.",53,null],[12,"cache","","All cached DFA information that is persisted between searches.",53,null],[3,"State","","`State` is a DFA state. It contains an ordered set of NFA states (not necessarily complete) and a smattering of flags.",null,null],[12,"data","","",54,null],[3,"InstPtrs","","",null,null],[12,"base","","",55,null],[12,"data","","",55,null],[3,"Byte","","Byte is a u8 in spirit, but a u16 in practice so that we can represent the special EOF sentinel value.",null,null],[12,"0","","",56,null],[3,"EmptyFlags","","A set of flags for zero-width assertions.",null,null],[12,"start","","",57,null],[12,"end","","",57,null],[12,"start_line","","",57,null],[12,"end_line","","",57,null],[12,"word_boundary","","",57,null],[12,"not_word_boundary","","",57,null],[3,"StateFlags","","A set of flags describing various configurations of a DFA state. This is represented by a `u8` so that it is compact.",null,null],[12,"0","","",58,null],[3,"TransitionsRow","","",null,null],[12,"0","","",59,null],[4,"Result","","The result of running the DFA.",null,null],[13,"Match","","",60,null],[13,"NoMatch","","",60,null],[13,"Quit","","",60,null],[5,"can_exec","","Return true if and only if the given program can be executed by a DFA.",null,{"i":[{"n":"program"}],"o":{"n":"bool"}}],[5,"push_inst_ptr","","Adds ip to data using delta encoding with respect to prev.",null,{"i":[{"n":"vec"},{"n":"u32"},{"n":"u32"}]}],[5,"vb","","Helper function for formatting a byte as a nice-to-read escaped string.",null,{"i":[{"n":"usize"}],"o":{"n":"string"}}],[5,"usize_to_u32","","",null,{"i":[{"n":"usize"}],"o":{"n":"u32"}}],[5,"show_state_ptr","","",null,{"i":[{"n":"u32"}],"o":{"n":"string"}}],[5,"write_vari32","","https://developers.google.com/protocol-buffers/docs/encoding#varints",null,{"i":[{"n":"vec"},{"n":"i32"}]}],[5,"read_vari32","","https://developers.google.com/protocol-buffers/docs/encoding#varints",null,null],[5,"write_varu32","","https://developers.google.com/protocol-buffers/docs/encoding#varints",null,{"i":[{"n":"vec"},{"n":"u32"}]}],[5,"read_varu32","","https://developers.google.com/protocol-buffers/docs/encoding#varints",null,null],[6,"InstPtr","","`InstPtr` is a 32 bit pointer into a sequence of opcodes (i.e., it indexes an NFA state).",null,null],[6,"StatePtr","","`StatePtr` is a 32 bit pointer to the start of a row in the transition table.",null,null],[17,"STATE_UNKNOWN","","An unknown state means that the state has not been computed yet, and that the only way to progress is to compute it.",null,null],[17,"STATE_DEAD","","A dead state means that the state has been computed and it is known that once it is entered, no future match can ever occur.",null,null],[17,"STATE_QUIT","","A quit state means that the DFA came across some input that it doesn't know how to process correctly. The DFA should quit and another matching engine should be run in its place.",null,null],[17,"STATE_START","","A start state is a state that the DFA can start in.",null,null],[17,"STATE_MATCH","","A match state means that the regex has successfully matched.",null,null],[17,"STATE_MAX","","The maximum state pointer. This is useful to mask out the \"valid\" state pointer from a state with the \"start\" or \"match\" bits set.",null,null],[11,"clone","","",50,{"i":[{"n":"self"}],"o":{"n":"cache"}}],[11,"fmt","","",50,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",51,{"i":[{"n":"self"}],"o":{"n":"cacheinner"}}],[11,"fmt","","",51,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",52,{"i":[{"n":"self"}],"o":{"n":"transitions"}}],[11,"fmt","","",53,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",60,{"i":[{"n":"self"}],"o":{"n":"result"}}],[11,"fmt","","",60,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"is_match","","Returns true if this result corresponds to a match.",60,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"map","","Maps the given function onto T and returns the result.",60,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"result"}}],[11,"set_non_match","","Sets the non-match position.",60,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"result"}}],[11,"clone","","",54,{"i":[{"n":"self"}],"o":{"n":"state"}}],[11,"assert_receiver_is_total_eq","","",54,null],[11,"hash","","",54,null],[11,"eq","","",54,{"i":[{"n":"self"},{"n":"state"}],"o":{"n":"bool"}}],[11,"ne","","",54,{"i":[{"n":"self"},{"n":"state"}],"o":{"n":"bool"}}],[11,"next","","",55,{"i":[{"n":"self"}],"o":{"g":["usize"],"n":"option"}}],[11,"flags","","",54,{"i":[{"n":"self"}],"o":{"n":"stateflags"}}],[11,"inst_ptrs","","",54,{"i":[{"n":"self"}],"o":{"n":"instptrs"}}],[11,"clone","","",56,{"i":[{"n":"self"}],"o":{"n":"byte"}}],[11,"fmt","","",56,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",57,{"i":[{"n":"self"}],"o":{"n":"emptyflags"}}],[11,"assert_receiver_is_total_eq","","",57,null],[11,"fmt","","",57,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"default","","",57,{"o":{"n":"emptyflags"}}],[11,"hash","","",57,null],[11,"eq","","",57,{"i":[{"n":"self"},{"n":"emptyflags"}],"o":{"n":"bool"}}],[11,"ne","","",57,{"i":[{"n":"self"},{"n":"emptyflags"}],"o":{"n":"bool"}}],[11,"clone","","",58,{"i":[{"n":"self"}],"o":{"n":"stateflags"}}],[11,"assert_receiver_is_total_eq","","",58,null],[11,"default","","",58,{"o":{"n":"stateflags"}}],[11,"hash","","",58,null],[11,"eq","","",58,{"i":[{"n":"self"},{"n":"stateflags"}],"o":{"n":"bool"}}],[11,"ne","","",58,{"i":[{"n":"self"},{"n":"stateflags"}],"o":{"n":"bool"}}],[11,"new","","Create new empty cache for the DFA engine.",50,{"i":[{"n":"program"}],"o":{"n":"self"}}],[11,"reset_size","","Resets the cache size to account for fixed costs, such as the program and stack sizes.",51,{"i":[{"n":"self"}]}],[11,"forward","","",53,null],[11,"reverse","","",53,null],[11,"forward_many","","",53,null],[11,"exec_at","","Executes the DFA on a forward NFA.",53,null],[11,"exec_at_reverse","","Executes the DFA on a reverse NFA.",53,null],[11,"next_si","","next_si transitions to the next state, where the transition input corresponds to text[i].",53,null],[11,"exec_byte","","Computes the next state given the current state and the current input byte (which may be EOF).",53,{"i":[{"n":"self"},{"n":"sparseset"},{"n":"sparseset"},{"n":"u32"},{"n":"byte"}],"o":{"g":["u32"],"n":"option"}}],[11,"follow_epsilons","","Follows the epsilon transitions starting at (and including) `ip`. The resulting states are inserted into the ordered set `q`.",53,{"i":[{"n":"self"},{"n":"u32"},{"n":"sparseset"},{"n":"emptyflags"}]}],[11,"cached_state","","Find a previously computed state matching the given set of instructions and is_match bool.",53,{"i":[{"n":"self"},{"n":"sparseset"},{"n":"stateflags"},{"g":["u32"],"n":"option"}],"o":{"g":["u32"],"n":"option"}}],[11,"cached_state_key","","Produces a key suitable for describing a state in the DFA cache.",53,{"i":[{"n":"self"},{"n":"sparseset"},{"n":"stateflags"}],"o":{"g":["state"],"n":"option"}}],[11,"clear_cache_and_save","","Clears the cache, but saves and restores current_state if it is not none.",53,{"i":[{"n":"self"},{"g":["u32"],"n":"option"}],"o":{"n":"bool"}}],[11,"clear_cache","","Wipes the state cache, but saves and restores the current start state.",53,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"restore_state","","Restores the given state back into the cache, and returns a pointer to it.",53,{"i":[{"n":"self"},{"n":"state"}],"o":{"g":["u32"],"n":"option"}}],[11,"next_state","","Returns the next state given the current state si and current byte b. {qcur,qnext} are used as scratch space for storing ordered NFA states.",53,{"i":[{"n":"self"},{"n":"sparseset"},{"n":"sparseset"},{"n":"u32"},{"n":"byte"}],"o":{"g":["u32"],"n":"option"}}],[11,"start_state","","Computes and returns the start state, where searching begins at position `at` in `text`. If the state has already been computed, then it is pulled from the cache. If the state hasn't been cached, then it is computed, cached and a pointer to it is returned.",53,{"i":[{"n":"self"},{"n":"sparseset"},{"n":"emptyflags"},{"n":"stateflags"}],"o":{"g":["u32"],"n":"option"}}],[11,"start_flags","","Computes the set of starting flags for the given position in text.",53,null],[11,"start_flags_reverse","","Computes the set of starting flags for the given position in text.",53,null],[11,"state","","Returns a reference to a State given a pointer to it.",53,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"state"}}],[11,"add_state","","Adds the given state to the DFA.",53,{"i":[{"n":"self"},{"n":"state"}],"o":{"g":["u32"],"n":"option"}}],[11,"prefix_at","","Quickly finds the next occurrence of any literal prefixes in the regex. If there are no literal prefixes, then the current position is returned. If there are literal prefixes and one could not be found, then None is returned.",53,null],[11,"num_byte_classes","","Returns the number of byte classes required to discriminate transitions in each state.",53,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"byte_class","","Given an input byte or the special EOF sentinel, return its corresponding byte class.",53,{"i":[{"n":"self"},{"n":"byte"}],"o":{"n":"usize"}}],[11,"u8_class","","Like byte_class, but explicitly for u8s.",53,{"i":[{"n":"self"},{"n":"u8"}],"o":{"n":"usize"}}],[11,"continue_past_first_match","","Returns true if the DFA should continue searching past the first match.",53,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"has_prefix","","Returns true if there is a prefix we can quickly search for.",53,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"start_ptr","","Sets the STATE_START bit in the given state pointer if and only if we have a prefix to scan for.",53,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"u32"}}],[11,"approximate_size","","Approximate size returns the approximate heap space currently used by the DFA. It is used to determine whether the DFA's state cache needs to be wiped. Namely, it is possible that for certain regexes on certain inputs, a new state could be created for every byte of input. (This is bad for memory use, so we bound it with a cache.)",53,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"new","","Create a new transition table.",52,{"i":[{"n":"usize"}],"o":{"n":"transitions"}}],[11,"num_states","","Returns the total number of states currently in this table.",52,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"add","","Allocates room for one additional state and returns a pointer to it.",52,{"i":[{"n":"self"}],"o":{"g":["u32"],"n":"option"}}],[11,"clear","","Clears the table of all states.",52,{"i":[{"n":"self"}]}],[11,"set_next","","Sets the transition from (si, cls) to next.",52,{"i":[{"n":"self"},{"n":"u32"},{"n":"usize"},{"n":"u32"}]}],[11,"next","","Returns the transition corresponding to (si, cls).",52,{"i":[{"n":"self"},{"n":"u32"},{"n":"usize"}],"o":{"n":"u32"}}],[11,"state_heap_size","","The heap size, in bytes, of a single state in the transition table.",52,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"next_unchecked","","Like `next`, but uses unchecked access and is therefore unsafe.",52,{"i":[{"n":"self"},{"n":"u32"},{"n":"usize"}],"o":{"n":"u32"}}],[11,"is_match","","",58,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"set_match","","",58,{"i":[{"n":"self"}]}],[11,"is_word","","",58,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"set_word","","",58,{"i":[{"n":"self"}]}],[11,"has_empty","","",58,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"set_empty","","",58,{"i":[{"n":"self"}]}],[11,"byte","","",56,{"i":[{"n":"u8"}],"o":{"n":"self"}}],[11,"eof","","",56,{"o":{"n":"self"}}],[11,"is_eof","","",56,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"is_ascii_word","","",56,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"as_byte","","",56,{"i":[{"n":"self"}],"o":{"g":["u8"],"n":"option"}}],[11,"fmt","","",54,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",52,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",59,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",58,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[0,"error","regex","",null,null],[4,"Error","regex::error","An error that occurred during parsing or compiling a regular expression.",null,null],[13,"Syntax","","A syntax error.",18,null],[13,"CompiledTooBig","","The compiled program exceeded the set size limit. The argument is the size limit imposed.",18,null],[13,"__Nonexhaustive","","Hints that destructuring should not be exhaustive.",18,null],[11,"clone","regex","",18,{"i":[{"n":"self"}],"o":{"n":"error"}}],[11,"eq","","",18,{"i":[{"n":"self"},{"n":"error"}],"o":{"n":"bool"}}],[11,"ne","","",18,{"i":[{"n":"self"},{"n":"error"}],"o":{"n":"bool"}}],[11,"description","","",18,{"i":[{"n":"self"}],"o":{"n":"str"}}],[11,"cause","","",18,{"i":[{"n":"self"}],"o":{"g":["error"],"n":"option"}}],[11,"fmt","","",18,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",18,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"from","","",18,{"i":[{"n":"error"}],"o":{"n":"error"}}],[0,"exec","","",null,null],[3,"Exec","regex::exec","`Exec` manages the execution of a regular expression.",null,null],[12,"ro","","All read only state.",61,null],[12,"cache","","Caches for the various matching engines.",61,null],[3,"ExecNoSync","","`ExecNoSync` is like `Exec`, except it embeds a reference to a cache. This means it is no longer Sync, but we can now avoid the overhead of synchronization to fetch the cache.",null,null],[12,"ro","","All read only state.",62,null],[12,"cache","","Caches for the various matching engines.",62,null],[3,"ExecNoSyncStr","","`ExecNoSyncStr` is like `ExecNoSync`, but matches on &str instead of &[u8].",null,null],[12,"0","","",63,null],[3,"ExecReadOnly","","`ExecReadOnly` comprises all read only state for a regex. Namely, all such state is determined at compile time and never changes during search.",null,null],[12,"res","","The original regular expressions given by the caller to compile.",64,null],[12,"nfa","","A compiled program that is used in the NFA simulation and backtracking. It can be byte-based or Unicode codepoint based.",64,null],[12,"dfa","","A compiled byte based program for DFA execution. This is only used if a DFA can be executed. (Currently, only word boundary assertions are not supported.) Note that this program contains an embedded `.*?` preceding the first capture group, unless the regex is anchored at the beginning.",64,null],[12,"dfa_reverse","","The same as above, except the program is reversed (and there is no preceding `.*?`). This is used by the DFA to find the starting location of matches.",64,null],[12,"suffixes","","A set of suffix literals extracted from the regex.",64,null],[12,"match_type","","match_type encodes as much upfront knowledge about how we're going to execute a search as possible.",64,null],[3,"ExecBuilder","","Facilitates the construction of an executor by exposing various knobs to control how a regex is executed and what kinds of resources it's permitted to use.",null,null],[12,"options","","",65,null],[12,"match_type","","",65,null],[12,"bytes","","",65,null],[12,"only_utf8","","",65,null],[3,"Parsed","","Parsed represents a set of parsed regular expressions and their detected literals.",null,null],[12,"exprs","","",66,null],[12,"prefixes","","",66,null],[12,"suffixes","","",66,null],[12,"bytes","","",66,null],[3,"ProgramCacheInner","","",null,null],[12,"pikevm","","",67,null],[12,"backtrack","","",67,null],[12,"dfa","","",67,null],[12,"dfa_reverse","","",67,null],[4,"MatchType","","",null,null],[13,"Literal","","A single or multiple literal search. This is only used when the regex can be decomposed into unambiguous literal search.",68,null],[13,"Dfa","","A normal DFA search.",68,null],[13,"DfaAnchoredReverse","","A reverse DFA search starting from the end of a haystack.",68,null],[13,"DfaSuffix","","A reverse DFA search with suffix literal scanning.",68,null],[13,"DfaMany","","Use the DFA on two or more regular expressions.",68,null],[13,"Nfa","","An NFA variant.",68,null],[13,"Nothing","","No match is ever possible, so don't ever try to search.",68,null],[4,"MatchLiteralType","","",null,null],[13,"Unanchored","","Match literals anywhere in text.",69,null],[13,"AnchoredStart","","Match literals only at the start of text.",69,null],[13,"AnchoredEnd","","Match literals only at the end of text.",69,null],[4,"MatchNfaType","","",null,null],[13,"Auto","","Choose between Backtrack and PikeVM.",70,null],[13,"Backtrack","","NFA bounded backtracking.",70,null],[13,"PikeVM","","The Pike VM.",70,null],[6,"ProgramCache","","`ProgramCache` maintains reusable allocations for each matching engine available to a particular program.",null,null],[11,"fmt","","",62,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",64,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","Create a regex execution builder.",65,{"i":[{"n":"str"}],"o":{"n":"self"}}],[11,"new_many","","Like new, but compiles the union of the given regular expressions.",65,{"i":[{"n":"i"}],"o":{"n":"self"}}],[11,"new_options","","Create a regex execution builder.",65,{"i":[{"n":"regexoptions"}],"o":{"n":"self"}}],[11,"automatic","","Set the matching engine to be automatically determined.",65,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"nfa","","Sets the matching engine to use the NFA algorithm no matter what optimizations are possible.",65,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"bounded_backtracking","","Sets the matching engine to use a bounded backtracking engine no matter what optimizations are possible.",65,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"bytes","","Compiles byte based programs for use with the NFA matching engines.",65,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"self"}}],[11,"only_utf8","","When disabled, the program compiled may match arbitrary bytes.",65,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"self"}}],[11,"unicode","","Set the Unicode flag.",65,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"self"}}],[11,"parse","","Parse the current set of patterns into their AST and extract literals.",65,{"i":[{"n":"self"}],"o":{"g":["parsed","error"],"n":"result"}}],[11,"build","","Build an executor that can run a regular expression.",65,{"i":[{"n":"self"}],"o":{"g":["exec","error"],"n":"result"}}],[11,"slots_len","","",63,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"next_after_empty","","",63,{"i":[{"n":"self"},{"n":"str"},{"n":"usize"}],"o":{"n":"usize"}}],[11,"shortest_match_at","","",63,{"i":[{"n":"self"},{"n":"str"},{"n":"usize"}],"o":{"g":["usize"],"n":"option"}}],[11,"is_match_at","","",63,{"i":[{"n":"self"},{"n":"str"},{"n":"usize"}],"o":{"n":"bool"}}],[11,"find_at","","",63,{"i":[{"n":"self"},{"n":"str"},{"n":"usize"}],"o":{"n":"option"}}],[11,"read_captures_at","","",63,{"i":[{"n":"self"},{"n":"locations"},{"n":"str"},{"n":"usize"}],"o":{"n":"option"}}],[11,"slots_len","","Returns the number of capture slots in the regular expression. (There are two slots for every capture group, corresponding to possibly empty start and end locations of the capture.)",62,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"next_after_empty","","",62,null],[11,"shortest_match_at","","Returns the end of a match location, possibly occurring before the end location of the correct leftmost-first match.",62,null],[11,"is_match_at","","Returns true if and only if the regex matches text.",62,null],[11,"find_at","","Finds the start and end location of the leftmost-first match, starting at the given location.",62,null],[11,"read_captures_at","","Finds the start and end location of the leftmost-first match and also fills in all matching capture groups.",62,null],[11,"find_literals","","Finds the leftmost-first match using only literal search.",62,null],[11,"find_dfa_forward","","Finds the leftmost-first match (start and end) using only the DFA.",62,null],[11,"find_dfa_anchored_reverse","","Finds the leftmost-first match (start and end) using only the DFA, but assumes the regex is anchored at the end and therefore starts at the end of the regex and matches in reverse.",62,null],[11,"shortest_dfa","","Finds the end of the shortest match using only the DFA.",62,null],[11,"shortest_dfa_reverse_suffix","","Finds the end of the shortest match using only the DFA by scanning for suffix literals.",62,null],[11,"exec_dfa_reverse_suffix","","Finds the end of the shortest match using only the DFA by scanning for suffix literals. It also reports the start of the match.",62,null],[11,"find_dfa_reverse_suffix","","Finds the leftmost-first match (start and end) using only the DFA by scanning for suffix literals.",62,null],[11,"match_nfa","","Executes the NFA engine to return whether there is a match or not.",62,null],[11,"match_nfa_type","","Like match_nfa, but allows specification of the type of NFA engine.",62,null],[11,"shortest_nfa","","Finds the shortest match using an NFA.",62,null],[11,"shortest_nfa_type","","Like shortest_nfa, but allows specification of the type of NFA engine.",62,null],[11,"find_nfa","","Like find, but executes an NFA engine.",62,null],[11,"captures_nfa_with_match","","Like find_nfa, but fills in captures and restricts the search space using previously found match information.",62,null],[11,"captures_nfa","","Like find_nfa, but fills in captures.",62,null],[11,"captures_nfa_type","","Like captures_nfa, but allows specification of type of NFA engine.",62,null],[11,"exec_nfa","","",62,null],[11,"exec_pikevm","","Always run the NFA algorithm.",62,null],[11,"exec_backtrack","","Always runs the NFA using bounded backtracking.",62,null],[11,"many_matches_at","","Finds which regular expressions match the given text.",62,null],[11,"is_anchor_end_match","","",62,null],[11,"capture_name_idx","","",62,{"i":[{"n":"self"}],"o":{"n":"arc"}}],[11,"capture_name_idx","","",63,{"i":[{"n":"self"}],"o":{"n":"arc"}}],[11,"searcher","","Get a searcher that isn't Sync.",61,{"i":[{"n":"self"}],"o":{"n":"execnosync"}}],[11,"searcher_str","","Get a searcher that isn't Sync and can match on &str.",61,{"i":[{"n":"self"}],"o":{"n":"execnosyncstr"}}],[11,"into_regex","","Build a Regex from this executor.",61,{"i":[{"n":"self"}],"o":{"n":"regex"}}],[11,"into_regex_set","","Build a RegexSet from this executor.",61,{"i":[{"n":"self"}],"o":{"n":"regexset"}}],[11,"into_byte_regex","","Build a Regex from this executor that can match arbitrary bytes.",61,{"i":[{"n":"self"}],"o":{"n":"regex"}}],[11,"into_byte_regex_set","","Build a RegexSet from this executor that can match arbitrary bytes.",61,{"i":[{"n":"self"}],"o":{"n":"regexset"}}],[11,"regex_strings","","The original regular expressions given by the caller that were compiled.",61,null],[11,"capture_names","","Return a slice of capture names.",61,null],[11,"capture_name_idx","","Return a reference to named groups mapping (from group name to group position).",61,{"i":[{"n":"self"}],"o":{"n":"arc"}}],[11,"clone","","",61,{"i":[{"n":"self"}],"o":{"n":"exec"}}],[11,"choose_match_type","","",64,{"i":[{"n":"self"},{"g":["matchtype"],"n":"option"}],"o":{"n":"matchtype"}}],[11,"should_suffix_scan","","Returns true if the program is amenable to suffix scanning.",64,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"clone","","",68,{"i":[{"n":"self"}],"o":{"n":"matchtype"}}],[11,"fmt","","",68,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",69,{"i":[{"n":"self"}],"o":{"n":"matchliteraltype"}}],[11,"fmt","","",69,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",70,{"i":[{"n":"self"}],"o":{"n":"matchnfatype"}}],[11,"fmt","","",70,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",67,{"i":[{"n":"self"}],"o":{"n":"programcacheinner"}}],[11,"fmt","","",67,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","",67,{"i":[{"n":"execreadonly"}],"o":{"n":"self"}}],[0,"expand","regex","",null,null],[3,"CaptureRef","regex::expand","`CaptureRef` represents a reference to a capture group inside some text. The reference is either a capture group name or a number.",null,null],[12,"cap","","",71,null],[12,"end","","",71,null],[4,"Ref","","A reference to a capture group in some text.",null,null],[13,"Named","","",72,null],[13,"Number","","",72,null],[5,"expand_str","","",null,{"i":[{"n":"captures"},{"n":"str"},{"n":"string"}]}],[5,"expand_bytes","","",null,null],[5,"find_cap_ref","","Parses a possible reference to a capture group name in the given text, starting at the beginning of `replacement`.",null,{"i":[{"n":"t"}],"o":{"g":["captureref"],"n":"option"}}],[5,"is_valid_cap_letter","","Returns true if and only if the given byte is allowed in a capture name.",null,{"i":[{"n":"u8"}],"o":{"n":"bool"}}],[11,"clone","","",71,{"i":[{"n":"self"}],"o":{"n":"captureref"}}],[11,"fmt","","",71,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",71,null],[11,"eq","","",71,{"i":[{"n":"self"},{"n":"captureref"}],"o":{"n":"bool"}}],[11,"ne","","",71,{"i":[{"n":"self"},{"n":"captureref"}],"o":{"n":"bool"}}],[11,"clone","","",72,{"i":[{"n":"self"}],"o":{"n":"ref"}}],[11,"fmt","","",72,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",72,null],[11,"eq","","",72,{"i":[{"n":"self"},{"n":"ref"}],"o":{"n":"bool"}}],[11,"ne","","",72,{"i":[{"n":"self"},{"n":"ref"}],"o":{"n":"bool"}}],[11,"from","","",72,{"i":[{"n":"str"}],"o":{"n":"ref"}}],[11,"from","","",72,{"i":[{"n":"usize"}],"o":{"n":"ref"}}],[0,"freqs","regex","",null,null],[17,"BYTE_FREQUENCIES","regex::freqs","",null,null],[0,"input","regex","",null,null],[3,"InputAt","regex::input","Represents a location in the input.",null,null],[12,"pos","","",73,null],[12,"c","","",73,null],[12,"byte","","",73,null],[12,"len","","",73,null],[3,"CharInput","","An input reader over characters.",null,null],[12,"0","","",74,null],[3,"ByteInput","","An input reader over bytes.",null,null],[12,"text","","",75,null],[12,"only_utf8","","",75,null],[3,"Char","","An inline representation of `Option<char>`.",null,null],[12,"0","","",76,null],[8,"Input","","An abstraction over input used in the matching engines.",null,null],[10,"at","","Return an encoding of the position at byte offset `i`.",77,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"inputat"}}],[10,"next_char","","Return the Unicode character occurring next to `at`.",77,{"i":[{"n":"self"},{"n":"inputat"}],"o":{"n":"char"}}],[10,"previous_char","","Return the Unicode character occurring previous to `at`.",77,{"i":[{"n":"self"},{"n":"inputat"}],"o":{"n":"char"}}],[10,"is_empty_match","","Return true if the given empty width instruction matches at the input position given.",77,{"i":[{"n":"self"},{"n":"inputat"},{"n":"instemptylook"}],"o":{"n":"bool"}}],[10,"prefix_at","","Scan the input for a matching prefix.",77,{"i":[{"n":"self"},{"n":"literalsearcher"},{"n":"inputat"}],"o":{"g":["inputat"],"n":"option"}}],[10,"len","","The number of bytes in the input.",77,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"is_empty","","Whether the input is empty.",77,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[10,"as_bytes","","Return the given input as a sequence of bytes.",77,null],[11,"clone","","",73,{"i":[{"n":"self"}],"o":{"n":"inputat"}}],[11,"fmt","","",73,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"is_start","","Returns true iff this position is at the beginning of the input.",73,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"is_end","","Returns true iff this position is past the end of the input.",73,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"char","","Returns the character at this position.",73,{"i":[{"n":"self"}],"o":{"n":"char"}}],[11,"byte","","Returns the byte at this position.",73,{"i":[{"n":"self"}],"o":{"g":["u8"],"n":"option"}}],[11,"len","","Returns the UTF-8 width of the character at this position.",73,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"is_empty","","Returns whether the UTF-8 width of the character at this position is zero.",73,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"pos","","Returns the byte offset of this position.",73,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"next_pos","","Returns the byte offset of the next position in the input.",73,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"clone","","",74,{"i":[{"n":"self"}],"o":{"n":"charinput"}}],[11,"fmt","","",74,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","Return a new character input reader for the given string.",74,null],[11,"deref","","",74,null],[11,"at","","",74,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"inputat"}}],[11,"next_char","","",74,{"i":[{"n":"self"},{"n":"inputat"}],"o":{"n":"char"}}],[11,"previous_char","","",74,{"i":[{"n":"self"},{"n":"inputat"}],"o":{"n":"char"}}],[11,"is_empty_match","","",74,{"i":[{"n":"self"},{"n":"inputat"},{"n":"instemptylook"}],"o":{"n":"bool"}}],[11,"prefix_at","","",74,{"i":[{"n":"self"},{"n":"literalsearcher"},{"n":"inputat"}],"o":{"g":["inputat"],"n":"option"}}],[11,"len","","",74,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"as_bytes","","",74,null],[11,"clone","","",75,{"i":[{"n":"self"}],"o":{"n":"byteinput"}}],[11,"fmt","","",75,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","Return a new byte-based input reader for the given string.",75,null],[11,"deref","","",75,null],[11,"at","","",75,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"inputat"}}],[11,"next_char","","",75,{"i":[{"n":"self"},{"n":"inputat"}],"o":{"n":"char"}}],[11,"previous_char","","",75,{"i":[{"n":"self"},{"n":"inputat"}],"o":{"n":"char"}}],[11,"is_empty_match","","",75,{"i":[{"n":"self"},{"n":"inputat"},{"n":"instemptylook"}],"o":{"n":"bool"}}],[11,"prefix_at","","",75,{"i":[{"n":"self"},{"n":"literalsearcher"},{"n":"inputat"}],"o":{"g":["inputat"],"n":"option"}}],[11,"len","","",75,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"as_bytes","","",75,null],[11,"clone","","",76,{"i":[{"n":"self"}],"o":{"n":"char"}}],[11,"hash","","",76,null],[11,"eq","","",76,{"i":[{"n":"self"},{"n":"char"}],"o":{"n":"bool"}}],[11,"ne","","",76,{"i":[{"n":"self"},{"n":"char"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",76,null],[11,"partial_cmp","","",76,{"i":[{"n":"self"},{"n":"char"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",76,{"i":[{"n":"self"},{"n":"char"}],"o":{"n":"bool"}}],[11,"le","","",76,{"i":[{"n":"self"},{"n":"char"}],"o":{"n":"bool"}}],[11,"gt","","",76,{"i":[{"n":"self"},{"n":"char"}],"o":{"n":"bool"}}],[11,"ge","","",76,{"i":[{"n":"self"},{"n":"char"}],"o":{"n":"bool"}}],[11,"cmp","","",76,{"i":[{"n":"self"},{"n":"char"}],"o":{"n":"ordering"}}],[11,"fmt","","",76,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"is_none","","Returns true iff the character is absent.",76,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"len_utf8","","Returns the length of the character's UTF-8 encoding.",76,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"is_word_char","","Returns true iff the character is a word character.",76,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"is_word_byte","","Returns true iff the byte is a word byte.",76,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"from","","",76,{"i":[{"n":"char"}],"o":{"n":"char"}}],[11,"from","","",76,{"i":[{"g":["char"],"n":"option"}],"o":{"n":"char"}}],[11,"eq","","",76,{"i":[{"n":"self"},{"n":"char"}],"o":{"n":"bool"}}],[11,"partial_cmp","","",76,{"i":[{"n":"self"},{"n":"char"}],"o":{"g":["ordering"],"n":"option"}}],[0,"literal","regex","",null,null],[3,"LiteralSearcher","regex::literal","A prefix extracted from a compiled regular expression.",null,null],[12,"complete","","",78,null],[12,"lcp","","",78,null],[12,"lcs","","",78,null],[12,"matcher","","",78,null],[3,"SingleByteSet","","",null,null],[12,"sparse","","",79,null],[12,"dense","","",79,null],[12,"complete","","",79,null],[12,"all_ascii","","",79,null],[3,"FreqyPacked","","Provides an implementation of fast subtring search using frequency analysis.",null,null],[12,"pat","","The pattern.",80,null],[12,"char_len","","The number of Unicode characters in the pattern. This is useful for determining the effective length of a pattern when deciding which optimizations to perform. A trailing incomplete UTF-8 sequence counts as one character.",80,null],[12,"rare1","","The rarest byte in the pattern, according to pre-computed frequency analysis.",80,null],[12,"rare1i","","The offset of the rarest byte in `pat`.",80,null],[12,"rare2","","The second rarest byte in the pattern, according to pre-computed frequency analysis. (This may be equivalent to the rarest byte.)",80,null],[12,"rare2i","","The offset of the second rarest byte in `pat`.",80,null],[3,"BoyerMooreSearch","","An implementation of Tuned Boyer-Moore as laid out by Andrew Hume and Daniel Sunday in \"Fast String Searching\". O(n) in the size of the input.",null,null],[12,"pattern","","The pattern we are going to look for in the haystack.",81,null],[12,"skip_table","","The skip table for the skip loop.",81,null],[12,"guard","","The guard character (least frequently occurring char).",81,null],[12,"guard_reverse_idx","","The reverse-index of the guard character in the pattern.",81,null],[12,"md2_shift","","Daniel Sunday's mini generalized delta2 shift table.",81,null],[4,"Matcher","","",null,null],[13,"Empty","","No literals. (Never advances through the input.)",82,null],[13,"Bytes","","A set of four or more single byte literals.",82,null],[13,"FreqyPacked","","A single substring, find using memchr and frequency analysis.",82,null],[13,"BoyerMoore","","A single substring, find using Boyer-Moore.",82,null],[13,"AC","","An Aho-Corasick automaton.",82,null],[13,"TeddySSSE3","","A simd accelerated multiple string matcher. Used only for a small number of small literals.",82,null],[13,"TeddyAVX2","","A simd accelerated multiple string matcher. Used only for a small number of small literals. This uses 256-bit vectors.",82,null],[4,"LiteralIter","","",null,null],[13,"Empty","","",83,null],[13,"Bytes","","",83,null],[13,"Single","","",83,null],[13,"AC","","",83,null],[13,"TeddySSSE3","","",83,null],[13,"TeddyAVX2","","",83,null],[5,"char_len_lossy","","",null,null],[5,"freq_rank","","",null,{"i":[{"n":"u8"}],"o":{"n":"usize"}}],[0,"teddy_avx2","","",null,null],[0,"imp","regex::literal::teddy_avx2","",null,null],[3,"Teddy","regex::literal::teddy_avx2::imp","",null,null],[12,"0","","",84,null],[3,"Match","","",null,null],[12,"pat","","",85,null],[12,"start","","",85,null],[12,"end","","",85,null],[11,"fmt","","",84,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",84,{"i":[{"n":"self"}],"o":{"n":"teddy"}}],[11,"fmt","","",85,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",85,{"i":[{"n":"self"}],"o":{"n":"match"}}],[11,"available","","",84,{"o":{"n":"bool"}}],[11,"new","","",84,{"i":[{"n":"literals"}],"o":{"g":["teddy"],"n":"option"}}],[11,"patterns","","",84,null],[11,"len","","",84,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"approximate_size","","",84,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"find","","",84,null],[0,"teddy_ssse3","regex::literal","",null,null],[0,"imp","regex::literal::teddy_ssse3","",null,null],[3,"Teddy","regex::literal::teddy_ssse3::imp","",null,null],[12,"0","","",86,null],[3,"Match","","",null,null],[12,"pat","","",87,null],[12,"start","","",87,null],[12,"end","","",87,null],[11,"fmt","","",86,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",86,{"i":[{"n":"self"}],"o":{"n":"teddy"}}],[11,"fmt","","",87,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",87,{"i":[{"n":"self"}],"o":{"n":"match"}}],[11,"available","","",86,{"o":{"n":"bool"}}],[11,"new","","",86,{"i":[{"n":"literals"}],"o":{"g":["teddy"],"n":"option"}}],[11,"patterns","","",86,null],[11,"len","","",86,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"approximate_size","","",86,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"find","","",86,null],[11,"clone","regex::literal","",78,{"i":[{"n":"self"}],"o":{"n":"literalsearcher"}}],[11,"fmt","","",78,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",82,{"i":[{"n":"self"}],"o":{"n":"matcher"}}],[11,"fmt","","",82,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"empty","","Returns a matcher that never matches and never advances the input.",78,{"o":{"n":"self"}}],[11,"prefixes","","Returns a matcher for literal prefixes from the given set.",78,{"i":[{"n":"literals"}],"o":{"n":"self"}}],[11,"suffixes","","Returns a matcher for literal suffixes from the given set.",78,{"i":[{"n":"literals"}],"o":{"n":"self"}}],[11,"new","","",78,{"i":[{"n":"literals"},{"n":"matcher"}],"o":{"n":"self"}}],[11,"complete","","Returns true if all matches comprise the entire regular expression.",78,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"find","","Find the position of a literal in `haystack` if it exists.",78,null],[11,"find_start","","Like find, except matches must start at index `0`.",78,null],[11,"find_end","","Like find, except matches must end at index `haystack.len()`.",78,null],[11,"iter","","Returns an iterator over all literals to be matched.",78,{"i":[{"n":"self"}],"o":{"n":"literaliter"}}],[11,"lcp","","Returns a matcher for the longest common prefix of this matcher.",78,{"i":[{"n":"self"}],"o":{"n":"freqypacked"}}],[11,"lcs","","Returns a matcher for the longest common suffix of this matcher.",78,{"i":[{"n":"self"}],"o":{"n":"freqypacked"}}],[11,"is_empty","","Returns true iff this prefix is empty.",78,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"len","","Returns the number of prefixes in this machine.",78,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"approximate_size","","Return the approximate heap usage of literals in bytes.",78,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"prefixes","","",82,{"i":[{"n":"literals"}],"o":{"n":"self"}}],[11,"suffixes","","",82,{"i":[{"n":"literals"}],"o":{"n":"self"}}],[11,"new","","",82,{"i":[{"n":"literals"},{"n":"singlebyteset"}],"o":{"n":"self"}}],[11,"next","","",83,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"clone","","",79,{"i":[{"n":"self"}],"o":{"n":"singlebyteset"}}],[11,"fmt","","",79,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","",79,{"o":{"n":"singlebyteset"}}],[11,"prefixes","","",79,{"i":[{"n":"literals"}],"o":{"n":"singlebyteset"}}],[11,"suffixes","","",79,{"i":[{"n":"literals"}],"o":{"n":"singlebyteset"}}],[11,"find","","Faster find that special cases certain sizes to use memchr.",79,null],[11,"_find","","Generic find that works on any sized set.",79,null],[11,"approximate_size","","",79,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"clone","","",80,{"i":[{"n":"self"}],"o":{"n":"freqypacked"}}],[11,"fmt","","",80,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","",80,{"i":[{"g":["u8"],"n":"vec"}],"o":{"n":"freqypacked"}}],[11,"empty","","",80,{"o":{"n":"freqypacked"}}],[11,"find","","",80,null],[11,"is_suffix","","",80,null],[11,"len","","",80,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"char_len","","",80,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"approximate_size","","",80,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"clone","","",81,{"i":[{"n":"self"}],"o":{"n":"boyermooresearch"}}],[11,"fmt","","",81,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","Create a new string searcher, performing whatever compilation steps are required.",81,{"i":[{"g":["u8"],"n":"vec"}],"o":{"n":"self"}}],[11,"find","","Find the pattern in `haystack`, returning the offset of the start of the first occurrence of the pattern in `haystack`.",81,null],[11,"len","","",81,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"should_use","","The key heuristic behind which the BoyerMooreSearch lives.",81,null],[11,"check_match","","Check to see if there is a match at the given position",81,null],[11,"skip_loop","","Skip forward according to the shift table.",81,null],[11,"compile_skip_table","","Compute the ufast skip table.",81,null],[11,"select_guard","","Select the guard character based off of the precomputed frequency table.",81,null],[11,"compile_md2_shift","","If there is another occurrence of the skip char, shift to it, otherwise just shift to the next window.",81,null],[11,"approximate_size","","",81,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[0,"pikevm","regex","",null,null],[3,"Fsm","regex::pikevm","An NFA simulation matching engine.",null,null],[12,"prog","","The sequence of opcodes (among other things) that is actually executed.",88,null],[12,"stack","","An explicit stack used for following epsilon transitions. (This is borrowed from the cache.)",88,null],[12,"input","","The input to search.",88,null],[3,"Cache","","A cached allocation that can be reused on each execution.",null,null],[12,"clist","","A pair of ordered sets for tracking NFA states.",89,null],[12,"nlist","","",89,null],[12,"stack","","An explicit stack used for following epsilon transitions.",89,null],[3,"Threads","","An ordered set of NFA states and their captures.",null,null],[12,"set","","An ordered set of opcodes (each opcode is an NFA state).",90,null],[12,"caps","","Captures for every NFA state.",90,null],[12,"slots_per_thread","","The number of capture slots stored per thread. (Every capture has two slots.)",90,null],[4,"FollowEpsilon","","A representation of an explicit stack frame when following epsilon transitions. This is used to avoid recursion.",null,null],[13,"IP","","Follow transitions at the given instruction pointer.",91,null],[13,"Capture","","Restore the capture slot with the given position in the input.",91,null],[12,"slot","regex::pikevm::FollowEpsilon","",91,null],[12,"pos","","",91,null],[11,"fmt","regex::pikevm","",88,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",89,{"i":[{"n":"self"}],"o":{"n":"cache"}}],[11,"fmt","","",89,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",90,{"i":[{"n":"self"}],"o":{"n":"threads"}}],[11,"fmt","","",90,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",91,{"i":[{"n":"self"}],"o":{"n":"followepsilon"}}],[11,"fmt","","",91,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","Create a new allocation used by the NFA machine to record execution and captures.",89,{"i":[{"n":"program"}],"o":{"n":"self"}}],[11,"exec","","Execute the NFA matching engine.",88,null],[11,"exec_","","",88,null],[11,"step","","Step through the input, one token (byte or codepoint) at a time.",88,null],[11,"add","","Follows epsilon transitions and adds them for processing to nlist, starting at and including ip.",88,null],[11,"add_step","","A helper function for add that avoids excessive pushing to the stack.",88,null],[11,"new","","",90,{"o":{"n":"self"}}],[11,"resize","","",90,{"i":[{"n":"self"},{"n":"usize"},{"n":"usize"}]}],[11,"caps","","",90,null],[0,"prog","regex","",null,null],[3,"Program","regex::prog","Program is a sequence of instructions and various facts about thos instructions.",null,null],[12,"insts","","A sequence of instructions that represents an NFA.",92,null],[12,"matches","","Pointers to each Match instruction in the sequence.",92,null],[12,"captures","","The ordered sequence of all capture groups extracted from the AST. Unnamed groups are `None`.",92,null],[12,"capture_name_idx","","Pointers to all named capture groups into `captures`.",92,null],[12,"start","","A pointer to the start instruction. This can vary depending on how the program was compiled. For example, programs for use with the DFA engine have a `.*?` inserted at the beginning of unanchored regular expressions. The actual starting point of the program is after the `.*?`.",92,null],[12,"byte_classes","","A set of equivalence classes for discriminating bytes in the compiled program.",92,null],[12,"only_utf8","","When true, this program can only match valid UTF-8.",92,null],[12,"is_bytes","","When true, this program uses byte range instructions instead of Unicode range instructions.",92,null],[12,"is_dfa","","When true, the program is compiled for DFA matching. For example, this implies `is_bytes` and also inserts a preceding `.*?` for unanchored regexes.",92,null],[12,"is_reverse","","When true, the program matches text in reverse (for use only in the DFA).",92,null],[12,"is_anchored_start","","Whether the regex must match from the start of the input.",92,null],[12,"is_anchored_end","","Whether the regex must match at the end of the input.",92,null],[12,"has_unicode_word_boundary","","Whether this program contains a Unicode word boundary instruction.",92,null],[12,"prefixes","","A possibly empty machine for very quickly matching prefix literals.",92,null],[12,"dfa_size_limit","","A limit on the size of the cache that the DFA is allowed to use while matching.",92,null],[3,"InstSave","","Representation of the Save instruction.",null,null],[12,"goto","","The next location to execute in the program.",93,null],[12,"slot","","The capture slot (there are two slots for every capture in a regex, including the zeroth capture for the entire match).",93,null],[3,"InstSplit","","Representation of the Split instruction.",null,null],[12,"goto1","","The first instruction to try. A match resulting from following goto1 has precedence over a match resulting from following goto2.",94,null],[12,"goto2","","The second instruction to try. A match resulting from following goto1 has precedence over a match resulting from following goto2.",94,null],[3,"InstEmptyLook","","Representation of the `EmptyLook` instruction.",null,null],[12,"goto","","The next location to execute in the program if this instruction succeeds.",95,null],[12,"look","","The type of zero-width assertion to check.",95,null],[3,"InstChar","","Representation of the Char instruction.",null,null],[12,"goto","","The next location to execute in the program if this instruction succeeds.",96,null],[12,"c","","The character to test.",96,null],[3,"InstRanges","","Representation of the Ranges instruction.",null,null],[12,"goto","","The next location to execute in the program if this instruction succeeds.",97,null],[12,"ranges","","The set of Unicode scalar value ranges to test.",97,null],[3,"InstBytes","","Representation of the Bytes instruction.",null,null],[12,"goto","","The next location to execute in the program if this instruction succeeds.",98,null],[12,"start","","The start (inclusive) of this byte range.",98,null],[12,"end","","The end (inclusive) of this byte range.",98,null],[4,"Inst","","Inst is an instruction code in a Regex program.",null,null],[13,"Match","","Match indicates that the program has reached a match state.",99,null],[13,"Save","","Save causes the program to save the current location of the input in the slot indicated by InstSave.",99,null],[13,"Split","","Split causes the program to diverge to one of two paths in the program, preferring goto1 in InstSplit.",99,null],[13,"EmptyLook","","EmptyLook represents a zero-width assertion in a regex program. A zero-width assertion does not consume any of the input text.",99,null],[13,"Char","","Char requires the regex program to match the character in InstChar at the current position in the input.",99,null],[13,"Ranges","","Ranges requires the regex program to match the character at the current position in the input with one of the ranges specified in InstRanges.",99,null],[13,"Bytes","","Bytes is like Ranges, except it expresses a single byte range. It is used in conjunction with Split instructions to implement multi-byte character classes.",99,null],[4,"EmptyLook","","The set of zero-width match instructions.",null,null],[13,"StartLine","","Start of line or input.",100,null],[13,"EndLine","","End of line or input.",100,null],[13,"StartText","","Start of input.",100,null],[13,"EndText","","End of input.",100,null],[13,"WordBoundary","","Word character on one side and non-word character on other.",100,null],[13,"NotWordBoundary","","Word character on both sides or non-word character on both sides.",100,null],[13,"WordBoundaryAscii","","ASCII word boundary.",100,null],[13,"NotWordBoundaryAscii","","Not ASCII word boundary.",100,null],[6,"InstPtr","","`InstPtr` represents the index of an instruction in a regex program.",null,null],[11,"clone","","",92,{"i":[{"n":"self"}],"o":{"n":"program"}}],[11,"new","","Creates an empty instruction sequence. Fields are given default values.",92,{"o":{"n":"self"}}],[11,"skip","","If pc is an index to a no-op instruction (like Save), then return the next pc that is not a no-op instruction.",92,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"usize"}}],[11,"leads_to_match","","Return true if and only if an execution engine at instruction `pc` will always lead to a match.",92,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"bool"}}],[11,"needs_dotstar","","Returns true if the current configuration demands that an implicit `.*?` be prepended to the instruction sequence.",92,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"uses_bytes","","Returns true if this program uses Byte instructions instead of Char/Range instructions.",92,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"only_utf8","","Returns true if this program exclusively matches valid UTF-8 bytes.",92,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"approximate_size","","Return the approximate heap usage of this instruction sequence in bytes.",92,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"deref","","",92,null],[11,"fmt","","",92,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",99,{"i":[{"n":"self"}],"o":{"n":"inst"}}],[11,"fmt","","",99,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"is_match","","Returns true if and only if this is a match instruction.",99,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"clone","","",93,{"i":[{"n":"self"}],"o":{"n":"instsave"}}],[11,"fmt","","",93,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",94,{"i":[{"n":"self"}],"o":{"n":"instsplit"}}],[11,"fmt","","",94,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",95,{"i":[{"n":"self"}],"o":{"n":"instemptylook"}}],[11,"fmt","","",95,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",100,{"i":[{"n":"self"}],"o":{"n":"emptylook"}}],[11,"fmt","","",100,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"eq","","",100,{"i":[{"n":"self"},{"n":"emptylook"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",100,null],[11,"clone","","",96,{"i":[{"n":"self"}],"o":{"n":"instchar"}}],[11,"fmt","","",96,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",97,{"i":[{"n":"self"}],"o":{"n":"instranges"}}],[11,"fmt","","",97,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"matches","","Tests whether the given input character matches this instruction.",97,{"i":[{"n":"self"},{"n":"char"}],"o":{"n":"bool"}}],[11,"num_chars","","Return the number of distinct characters represented by all of the ranges.",97,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"clone","","",98,{"i":[{"n":"self"}],"o":{"n":"instbytes"}}],[11,"fmt","","",98,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"matches","","Returns true if and only if the given byte is in this range.",98,{"i":[{"n":"self"},{"n":"u8"}],"o":{"n":"bool"}}],[0,"re_builder","regex","",null,null],[3,"RegexOptions","regex::re_builder","The set of user configurable options for compiling zero or more regexes.",null,null],[12,"pats","","",101,null],[12,"size_limit","","",101,null],[12,"dfa_size_limit","","",101,null],[12,"nest_limit","","",101,null],[12,"case_insensitive","","",101,null],[12,"multi_line","","",101,null],[12,"dot_matches_new_line","","",101,null],[12,"swap_greed","","",101,null],[12,"ignore_whitespace","","",101,null],[12,"unicode","","",101,null],[0,"bytes","","",null,null],[3,"RegexBuilder","regex::re_builder::bytes","A configurable builder for a regular expression.",null,null],[12,"0","","",19,null],[11,"new","regex::bytes","Create a new regular expression builder with the given pattern.",19,{"i":[{"n":"str"}],"o":{"n":"regexbuilder"}}],[11,"build","","Consume the builder and compile the regular expression.",19,{"i":[{"n":"self"}],"o":{"g":["regex","error"],"n":"result"}}],[11,"case_insensitive","","Set the value for the case insensitive (`i`) flag.",19,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"regexbuilder"}}],[11,"multi_line","","Set the value for the multi-line matching (`m`) flag.",19,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"regexbuilder"}}],[11,"dot_matches_new_line","","Set the value for the any character (`s`) flag, where in `.` matches anything when `s` is set and matches anything except for new line when it is not set (the default).",19,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"regexbuilder"}}],[11,"swap_greed","","Set the value for the greedy swap (`U`) flag.",19,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"regexbuilder"}}],[11,"ignore_whitespace","","Set the value for the ignore whitespace (`x`) flag.",19,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"regexbuilder"}}],[11,"unicode","","Set the value for the Unicode (`u`) flag.",19,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"regexbuilder"}}],[11,"size_limit","","Set the approximate size limit of the compiled regular expression.",19,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"regexbuilder"}}],[11,"dfa_size_limit","","Set the approximate size of the cache used by the DFA.",19,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"regexbuilder"}}],[11,"nest_limit","","Set the nesting limit for this parser.",19,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"regexbuilder"}}],[0,"unicode","regex::re_builder","",null,null],[3,"RegexBuilder","regex::re_builder::unicode","A configurable builder for a regular expression.",null,null],[12,"0","","",0,null],[11,"new","regex","Create a new regular expression builder with the given pattern.",0,{"i":[{"n":"str"}],"o":{"n":"regexbuilder"}}],[11,"build","","Consume the builder and compile the regular expression.",0,{"i":[{"n":"self"}],"o":{"g":["regex","error"],"n":"result"}}],[11,"case_insensitive","","Set the value for the case insensitive (`i`) flag.",0,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"regexbuilder"}}],[11,"multi_line","","Set the value for the multi-line matching (`m`) flag.",0,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"regexbuilder"}}],[11,"dot_matches_new_line","","Set the value for the any character (`s`) flag, where in `.` matches anything when `s` is set and matches anything except for new line when it is not set (the default).",0,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"regexbuilder"}}],[11,"swap_greed","","Set the value for the greedy swap (`U`) flag.",0,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"regexbuilder"}}],[11,"ignore_whitespace","","Set the value for the ignore whitespace (`x`) flag.",0,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"regexbuilder"}}],[11,"unicode","","Set the value for the Unicode (`u`) flag.",0,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"regexbuilder"}}],[11,"size_limit","","Set the approximate size limit of the compiled regular expression.",0,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"regexbuilder"}}],[11,"dfa_size_limit","","Set the approximate size of the cache used by the DFA.",0,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"regexbuilder"}}],[11,"nest_limit","","Set the nesting limit for this parser.",0,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"regexbuilder"}}],[0,"set_bytes","regex::re_builder","",null,null],[3,"RegexSetBuilder","regex::re_builder::set_bytes","A configurable builder for a set of regular expressions.",null,null],[12,"0","","",20,null],[11,"new","regex::bytes","Create a new regular expression builder with the given pattern.",20,{"i":[{"n":"i"}],"o":{"n":"regexsetbuilder"}}],[11,"build","","Consume the builder and compile the regular expressions into a set.",20,{"i":[{"n":"self"}],"o":{"g":["regexset","error"],"n":"result"}}],[11,"case_insensitive","","Set the value for the case insensitive (`i`) flag.",20,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"regexsetbuilder"}}],[11,"multi_line","","Set the value for the multi-line matching (`m`) flag.",20,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"regexsetbuilder"}}],[11,"dot_matches_new_line","","Set the value for the any character (`s`) flag, where in `.` matches anything when `s` is set and matches anything except for new line when it is not set (the default).",20,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"regexsetbuilder"}}],[11,"swap_greed","","Set the value for the greedy swap (`U`) flag.",20,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"regexsetbuilder"}}],[11,"ignore_whitespace","","Set the value for the ignore whitespace (`x`) flag.",20,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"regexsetbuilder"}}],[11,"unicode","","Set the value for the Unicode (`u`) flag.",20,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"regexsetbuilder"}}],[11,"size_limit","","Set the approximate size limit of the compiled regular expression.",20,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"regexsetbuilder"}}],[11,"dfa_size_limit","","Set the approximate size of the cache used by the DFA.",20,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"regexsetbuilder"}}],[11,"nest_limit","","Set the nesting limit for this parser.",20,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"regexsetbuilder"}}],[0,"set_unicode","regex::re_builder","",null,null],[3,"RegexSetBuilder","regex::re_builder::set_unicode","A configurable builder for a set of regular expressions.",null,null],[12,"0","","",1,null],[11,"new","regex","Create a new regular expression builder with the given pattern.",1,{"i":[{"n":"i"}],"o":{"n":"regexsetbuilder"}}],[11,"build","","Consume the builder and compile the regular expressions into a set.",1,{"i":[{"n":"self"}],"o":{"g":["regexset","error"],"n":"result"}}],[11,"case_insensitive","","Set the value for the case insensitive (`i`) flag.",1,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"regexsetbuilder"}}],[11,"multi_line","","Set the value for the multi-line matching (`m`) flag.",1,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"regexsetbuilder"}}],[11,"dot_matches_new_line","","Set the value for the any character (`s`) flag, where in `.` matches anything when `s` is set and matches anything except for new line when it is not set (the default).",1,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"regexsetbuilder"}}],[11,"swap_greed","","Set the value for the greedy swap (`U`) flag.",1,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"regexsetbuilder"}}],[11,"ignore_whitespace","","Set the value for the ignore whitespace (`x`) flag.",1,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"regexsetbuilder"}}],[11,"unicode","","Set the value for the Unicode (`u`) flag.",1,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"regexsetbuilder"}}],[11,"size_limit","","Set the approximate size limit of the compiled regular expression.",1,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"regexsetbuilder"}}],[11,"dfa_size_limit","","Set the approximate size of the cache used by the DFA.",1,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"regexsetbuilder"}}],[11,"nest_limit","","Set the nesting limit for this parser.",1,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"regexsetbuilder"}}],[11,"clone","regex::re_builder","",101,{"i":[{"n":"self"}],"o":{"n":"regexoptions"}}],[11,"fmt","","",101,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"default","","",101,{"o":{"n":"self"}}],[0,"re_bytes","regex","",null,null],[3,"Match","regex::re_bytes","Match represents a single match of a regex in a haystack.",null,null],[12,"text","","",21,null],[12,"start","","",21,null],[12,"end","","",21,null],[3,"Regex","","A compiled regular expression for matching arbitrary bytes.",null,null],[12,"0","","",22,null],[3,"Matches","","An iterator over all non-overlapping matches for a particular string.",null,null],[12,"0","","",23,null],[3,"CaptureMatches","","An iterator that yields all non-overlapping capture groups matching a particular regular expression.",null,null],[12,"0","","",24,null],[3,"Split","","Yields all substrings delimited by a regular expression match.",null,null],[12,"finder","","",25,null],[12,"last","","",25,null],[3,"SplitN","","Yields at most `N` substrings delimited by a regular expression match.",null,null],[12,"splits","","",26,null],[12,"n","","",26,null],[3,"CaptureNames","","An iterator over the names of all possible captures.",null,null],[12,"0","","",27,null],[3,"Captures","","Captures represents a group of captured byte strings for a single match.",null,null],[12,"text","","",28,null],[12,"locs","","",28,null],[12,"named_groups","","",28,null],[3,"CapturesDebug","","",null,null],[12,"0","","",102,null],[3,"SubCaptureMatches","","An iterator that yields all capturing matches in the order in which they appear in the regex.",null,null],[12,"caps","","",29,null],[12,"it","","",29,null],[3,"ReplacerRef","","By-reference adaptor for a `Replacer`",null,null],[12,"0","","",30,null],[3,"NoExpand","","`NoExpand` indicates literal byte string replacement.",null,null],[12,"0","","",31,null],[8,"Replacer","","Replacer describes types that can be used to replace matches in a byte string.",null,null],[10,"replace_append","","Appends text to `dst` to replace the current match.",36,{"i":[{"n":"self"},{"n":"captures"},{"n":"vec"}]}],[11,"no_expansion","regex::bytes","Return a fixed unchanging replacement byte string.",36,{"i":[{"n":"self"}],"o":{"g":["cow"],"n":"option"}}],[11,"by_ref","","Return a `Replacer` that borrows and wraps this `Replacer`.",36,{"i":[{"n":"self"}],"o":{"n":"replacerref"}}],[11,"clone","","",21,{"i":[{"n":"self"}],"o":{"n":"match"}}],[11,"fmt","","",21,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",21,null],[11,"eq","","",21,{"i":[{"n":"self"},{"n":"match"}],"o":{"n":"bool"}}],[11,"ne","","",21,{"i":[{"n":"self"},{"n":"match"}],"o":{"n":"bool"}}],[11,"start","","Returns the starting byte offset of the match in the haystack.",21,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"end","","Returns the ending byte offset of the match in the haystack.",21,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"as_bytes","","Returns the matched text.",21,null],[11,"new","","Creates a new match from the given haystack and byte offsets.",21,null],[11,"clone","","",22,{"i":[{"n":"self"}],"o":{"n":"regex"}}],[11,"fmt","","Shows the original regular expression.",22,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","Shows the original regular expression.",22,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"from","","",22,{"i":[{"n":"exec"}],"o":{"n":"regex"}}],[11,"from_str","","Attempts to parse a string into a regular expression",22,{"i":[{"n":"str"}],"o":{"g":["regex","error"],"n":"result"}}],[11,"new","","Compiles a regular expression. Once compiled, it can be used repeatedly to search, split or replace text in a string.",22,{"i":[{"n":"str"}],"o":{"g":["regex","error"],"n":"result"}}],[11,"is_match","","Returns true if and only if the regex matches the string given.",22,null],[11,"find","","Returns the start and end byte range of the leftmost-first match in `text`. If no match exists, then `None` is returned.",22,null],[11,"find_iter","","Returns an iterator for each successive non-overlapping match in `text`, returning the start and end byte indices with respect to `text`.",22,null],[11,"captures","","Returns the capture groups corresponding to the leftmost-first match in `text`. Capture group `0` always corresponds to the entire match. If no match is found, then `None` is returned.",22,null],[11,"captures_iter","","Returns an iterator over all the non-overlapping capture groups matched in `text`. This is operationally the same as `find_iter`, except it yields information about capturing group matches.",22,null],[11,"split","","Returns an iterator of substrings of `text` delimited by a match of the regular expression. Namely, each element of the iterator corresponds to text that isn't matched by the regular expression.",22,null],[11,"splitn","","Returns an iterator of at most `limit` substrings of `text` delimited by a match of the regular expression. (A `limit` of `0` will return no substrings.) Namely, each element of the iterator corresponds to text that isn't matched by the regular expression. The remainder of the string that is not split will be the last element in the iterator.",22,null],[11,"replace","","Replaces the leftmost-first match with the replacement provided. The replacement can be a regular byte string (where `$N` and `$name` are expanded to match capture groups) or a function that takes the matches' `Captures` and returns the replaced byte string.",22,null],[11,"replace_all","","Replaces all non-overlapping matches in `text` with the replacement provided. This is the same as calling `replacen` with `limit` set to `0`.",22,null],[11,"replacen","","Replaces at most `limit` non-overlapping matches in `text` with the replacement provided. If `limit` is 0, then all non-overlapping matches are replaced.",22,null],[11,"shortest_match","","Returns the end location of a match in the text given.",22,null],[11,"shortest_match_at","","Returns the same as shortest_match, but starts the search at the given offset.",22,null],[11,"is_match_at","","Returns the same as is_match, but starts the search at the given offset.",22,null],[11,"find_at","","Returns the same as find, but starts the search at the given offset.",22,null],[11,"read_captures_at","","Returns the same as captures, but starts the search at the given offset and populates the capture locations given.",22,null],[11,"as_str","","Returns the original string of this regex.",22,{"i":[{"n":"self"}],"o":{"n":"str"}}],[11,"capture_names","","Returns an iterator over the capture names.",22,{"i":[{"n":"self"}],"o":{"n":"capturenames"}}],[11,"captures_len","","Returns the number of captures.",22,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"locations","","Returns an empty set of locations that can be reused in multiple calls to `read_captures`.",22,{"i":[{"n":"self"}],"o":{"n":"locations"}}],[11,"next","","",23,{"i":[{"n":"self"}],"o":{"g":["match"],"n":"option"}}],[11,"next","","",24,{"i":[{"n":"self"}],"o":{"g":["captures"],"n":"option"}}],[11,"next","","",25,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"next","","",26,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"next","","",27,{"i":[{"n":"self"}],"o":{"g":["option"],"n":"option"}}],[11,"size_hint","","",27,null],[11,"get","","Returns the match associated with the capture group at index `i`. If `i` does not correspond to a capture group, or if the capture group did not participate in the match, then `None` is returned.",28,{"i":[{"n":"self"},{"n":"usize"}],"o":{"g":["match"],"n":"option"}}],[11,"name","","Returns the match for the capture group named `name`. If `name` isn't a valid capture group or didn't match anything, then `None` is returned.",28,{"i":[{"n":"self"},{"n":"str"}],"o":{"g":["match"],"n":"option"}}],[11,"iter","","An iterator that yields all capturing matches in the order in which they appear in the regex. If a particular capture group didn't participate in the match, then `None` is yielded for that capture.",28,{"i":[{"n":"self"}],"o":{"n":"subcapturematches"}}],[11,"expand","","Expands all instances of `$name` in `replacement` to the corresponding capture group `name`, and writes them to the `dst` buffer given.",28,null],[11,"len","","Returns the number of captured groups.",28,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"fmt","","",28,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","regex::re_bytes","",102,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"index","regex::bytes","",28,null],[11,"index","","",28,null],[11,"next","","",29,{"i":[{"n":"self"}],"o":{"g":["option"],"n":"option"}}],[11,"fmt","","",30,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"replace_append","","",30,{"i":[{"n":"self"},{"n":"captures"},{"n":"vec"}]}],[11,"no_expansion","","",30,{"i":[{"n":"self"}],"o":{"g":["cow"],"n":"option"}}],[11,"replace_append","","",31,{"i":[{"n":"self"},{"n":"captures"},{"n":"vec"}]}],[11,"no_expansion","","",31,{"i":[{"n":"self"}],"o":{"g":["cow"],"n":"option"}}],[0,"re_set","regex","",null,null],[0,"unicode","regex::re_set","",null,null],[3,"RegexSet","regex::re_set::unicode","Match multiple (possibly overlapping) regular expressions in a single scan.",null,null],[12,"0","","",2,null],[3,"SetMatches","","A set of matches returned by a regex set.",null,null],[12,"matched_any","","",3,null],[12,"matches","","",3,null],[3,"SetMatchesIntoIter","","An owned iterator over the set of matches from a regex set.",null,null],[12,"0","","",4,null],[3,"SetMatchesIter","","A borrowed iterator over the set of matches from a regex set.",null,null],[12,"0","","",5,null],[5,"as_bytes_str","","",null,null],[5,"as_bytes_bytes","","",null,null],[11,"clone","regex","",2,{"i":[{"n":"self"}],"o":{"n":"regexset"}}],[11,"new","","Create a new regex set with the given regular expressions.",2,{"i":[{"n":"i"}],"o":{"g":["regexset","error"],"n":"result"}}],[11,"is_match","","Returns true if and only if one of the regexes in this set matches the text given.",2,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"bool"}}],[11,"is_match_at","","Returns the same as is_match, but starts the search at the given offset.",2,{"i":[{"n":"self"},{"n":"str"},{"n":"usize"}],"o":{"n":"bool"}}],[11,"matches","","Returns the set of regular expressions that match in the given text.",2,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"setmatches"}}],[11,"read_matches_at","","Returns the same as matches, but starts the search at the given offset and stores the matches into the slice given.",2,null],[11,"len","","Returns the total number of regular expressions in this set.",2,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"clone","","",3,{"i":[{"n":"self"}],"o":{"n":"setmatches"}}],[11,"fmt","","",3,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"matched_any","","Whether this set contains any matches.",3,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"matched","","Whether the regex at the given index matched.",3,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"bool"}}],[11,"len","","The total number of regexes in the set that created these matches.",3,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"iter","","Returns an iterator over indexes in the regex that matched.",3,{"i":[{"n":"self"}],"o":{"n":"setmatchesiter"}}],[11,"into_iter","","",3,null],[11,"next","","",4,{"i":[{"n":"self"}],"o":{"g":["usize"],"n":"option"}}],[11,"next_back","","",4,{"i":[{"n":"self"}],"o":{"g":["usize"],"n":"option"}}],[11,"clone","","",5,{"i":[{"n":"self"}],"o":{"n":"setmatchesiter"}}],[11,"next","","",5,{"i":[{"n":"self"}],"o":{"g":["usize"],"n":"option"}}],[11,"next_back","","",5,{"i":[{"n":"self"}],"o":{"g":["usize"],"n":"option"}}],[11,"from","","",2,{"i":[{"n":"exec"}],"o":{"n":"self"}}],[11,"fmt","","",2,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[0,"bytes","regex::re_set","",null,null],[3,"RegexSet","regex::re_set::bytes","Match multiple (possibly overlapping) regular expressions in a single scan.",null,null],[12,"0","","",32,null],[3,"SetMatches","","A set of matches returned by a regex set.",null,null],[12,"matched_any","","",33,null],[12,"matches","","",33,null],[3,"SetMatchesIntoIter","","An owned iterator over the set of matches from a regex set.",null,null],[12,"0","","",34,null],[3,"SetMatchesIter","","A borrowed iterator over the set of matches from a regex set.",null,null],[12,"0","","",35,null],[5,"as_bytes_str","","",null,null],[5,"as_bytes_bytes","","",null,null],[11,"clone","regex::bytes","",32,{"i":[{"n":"self"}],"o":{"n":"regexset"}}],[11,"new","","Create a new regex set with the given regular expressions.",32,{"i":[{"n":"i"}],"o":{"g":["regexset","error"],"n":"result"}}],[11,"is_match","","Returns true if and only if one of the regexes in this set matches the text given.",32,null],[11,"is_match_at","","Returns the same as is_match, but starts the search at the given offset.",32,null],[11,"matches","","Returns the set of regular expressions that match in the given text.",32,null],[11,"read_matches_at","","Returns the same as matches, but starts the search at the given offset and stores the matches into the slice given.",32,null],[11,"len","","Returns the total number of regular expressions in this set.",32,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"clone","","",33,{"i":[{"n":"self"}],"o":{"n":"setmatches"}}],[11,"fmt","","",33,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"matched_any","","Whether this set contains any matches.",33,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"matched","","Whether the regex at the given index matched.",33,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"bool"}}],[11,"len","","The total number of regexes in the set that created these matches.",33,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"iter","","Returns an iterator over indexes in the regex that matched.",33,{"i":[{"n":"self"}],"o":{"n":"setmatchesiter"}}],[11,"into_iter","","",33,null],[11,"next","","",34,{"i":[{"n":"self"}],"o":{"g":["usize"],"n":"option"}}],[11,"next_back","","",34,{"i":[{"n":"self"}],"o":{"g":["usize"],"n":"option"}}],[11,"clone","","",35,{"i":[{"n":"self"}],"o":{"n":"setmatchesiter"}}],[11,"next","","",35,{"i":[{"n":"self"}],"o":{"g":["usize"],"n":"option"}}],[11,"next_back","","",35,{"i":[{"n":"self"}],"o":{"g":["usize"],"n":"option"}}],[11,"from","","",32,{"i":[{"n":"exec"}],"o":{"n":"self"}}],[11,"fmt","","",32,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[0,"re_trait","regex","",null,null],[3,"Locations","regex::re_trait","Locations represents the offsets of each capturing group in a regex for a single match.",null,null],[12,"0","","",6,null],[3,"SubCapturesPosIter","","An iterator over capture group positions for a particular match of a regular expression.",null,null],[12,"idx","","",103,null],[12,"locs","","",103,null],[3,"Matches","","An iterator over all non-overlapping successive leftmost-first matches.",null,null],[12,"re","","",104,null],[12,"text","","",104,null],[12,"last_end","","",104,null],[12,"last_match","","",104,null],[3,"CaptureMatches","","An iterator over all non-overlapping successive leftmost-first matches with captures.",null,null],[12,"0","","",105,null],[5,"as_slots","","This is a hack to make Locations -> &mut [Slot] be available internally without exposing it in the public API.",null,null],[6,"Slot","","Slot is a single saved capture location. Note that there are two slots for every capture in a regular expression (one slot each for the start and end of the capture).",null,null],[8,"RegularExpression","","`RegularExpression` describes types that can implement regex searching.",null,null],[16,"Text","","The type of the haystack.",106,null],[10,"slots_len","","The number of capture slots in the compiled regular expression. This is always two times the number of capture groups (two slots per group).",106,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"locations","","Allocates fresh space for all capturing groups in this regex.",106,{"i":[{"n":"self"}],"o":{"n":"locations"}}],[10,"next_after_empty","","Returns the position of the next character after `i`.",106,null],[10,"shortest_match_at","","Returns the location of the shortest match.",106,null],[10,"is_match_at","","Returns whether the regex matches the text given.",106,null],[10,"find_at","","Returns the leftmost-first match location if one exists.",106,null],[10,"read_captures_at","","Returns the leftmost-first match location if one exists, and also fills in any matching capture slot locations.",106,null],[11,"find_iter","","Returns an iterator over all non-overlapping successive leftmost-first matches.",106,null],[11,"captures_iter","","Returns an iterator over all non-overlapping successive leftmost-first matches with captures.",106,null],[11,"pos","regex","Returns the start and end positions of the Nth capture group. Returns `None` if `i` is not a valid capture group or if the capture group did not match anything. The positions returned are always byte indices with respect to the original string matched.",6,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"option"}}],[11,"iter","","Creates an iterator of all the capture group positions in order of appearance in the regular expression. Positions are byte indices in terms of the original string matched.",6,{"i":[{"n":"self"}],"o":{"n":"subcapturespositer"}}],[11,"len","","Returns the total number of capturing groups.",6,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"next","regex::re_trait","",103,{"i":[{"n":"self"}],"o":{"g":["option"],"n":"option"}}],[11,"text","","Return the text being searched.",104,null],[11,"regex","","Return the underlying regex.",104,{"i":[{"n":"self"}],"o":{"n":"r"}}],[11,"next","","",104,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"text","","Return the text being searched.",105,null],[11,"regex","","Return the underlying regex.",105,{"i":[{"n":"self"}],"o":{"n":"r"}}],[11,"next","","",105,{"i":[{"n":"self"}],"o":{"g":["locations"],"n":"option"}}],[0,"re_unicode","regex","",null,null],[3,"Match","regex::re_unicode","Match represents a single match of a regex in a haystack.",null,null],[12,"text","","",8,null],[12,"start","","",8,null],[12,"end","","",8,null],[3,"Regex","","A compiled regular expression for matching Unicode strings.",null,null],[12,"0","","",7,null],[3,"CaptureNames","","An iterator over the names of all possible captures.",null,null],[12,"0","","",10,null],[3,"Split","","Yields all substrings delimited by a regular expression match.",null,null],[12,"finder","","",16,null],[12,"last","","",16,null],[3,"SplitN","","Yields at most `N` substrings delimited by a regular expression match.",null,null],[12,"splits","","",17,null],[12,"n","","",17,null],[3,"Captures","","Captures represents a group of captured strings for a single match.",null,null],[12,"text","","",9,null],[12,"locs","","",9,null],[12,"named_groups","","",9,null],[3,"CapturesDebug","","",null,null],[12,"0","","",107,null],[3,"SubCaptureMatches","","An iterator that yields all capturing matches in the order in which they appear in the regex.",null,null],[12,"caps","","",13,null],[12,"it","","",13,null],[3,"CaptureMatches","","An iterator that yields all non-overlapping capture groups matching a particular regular expression.",null,null],[12,"0","","",12,null],[3,"Matches","","An iterator over all non-overlapping matches for a particular string.",null,null],[12,"0","","",11,null],[3,"ReplacerRef","","By-reference adaptor for a `Replacer`",null,null],[12,"0","","",14,null],[3,"NoExpand","","`NoExpand` indicates literal string replacement.",null,null],[12,"0","","",15,null],[5,"escape","","Escapes all regular expression meta characters in `text`.",null,{"i":[{"n":"str"}],"o":{"n":"string"}}],[8,"Replacer","","Replacer describes types that can be used to replace matches in a string.",null,null],[10,"replace_append","","Appends text to `dst` to replace the current match.",108,{"i":[{"n":"self"},{"n":"captures"},{"n":"string"}]}],[11,"no_expansion","","Return a fixed unchanging replacement string.",108,{"i":[{"n":"self"}],"o":{"g":["cow"],"n":"option"}}],[11,"by_ref","","Return a `Replacer` that borrows and wraps this `Replacer`.",108,{"i":[{"n":"self"}],"o":{"n":"replacerref"}}],[11,"clone","regex","",8,{"i":[{"n":"self"}],"o":{"n":"match"}}],[11,"fmt","","",8,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",8,null],[11,"eq","","",8,{"i":[{"n":"self"},{"n":"match"}],"o":{"n":"bool"}}],[11,"ne","","",8,{"i":[{"n":"self"},{"n":"match"}],"o":{"n":"bool"}}],[11,"start","","Returns the starting byte offset of the match in the haystack.",8,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"end","","Returns the ending byte offset of the match in the haystack.",8,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"as_str","","Returns the matched text.",8,{"i":[{"n":"self"}],"o":{"n":"str"}}],[11,"new","","Creates a new match from the given haystack and byte offsets.",8,{"i":[{"n":"str"},{"n":"usize"},{"n":"usize"}],"o":{"n":"match"}}],[11,"clone","","",7,{"i":[{"n":"self"}],"o":{"n":"regex"}}],[11,"fmt","","Shows the original regular expression.",7,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","Shows the original regular expression.",7,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"from","","",7,{"i":[{"n":"exec"}],"o":{"n":"regex"}}],[11,"from_str","","Attempts to parse a string into a regular expression",7,{"i":[{"n":"str"}],"o":{"g":["regex","error"],"n":"result"}}],[11,"new","","Compiles a regular expression. Once compiled, it can be used repeatedly to search, split or replace text in a string.",7,{"i":[{"n":"str"}],"o":{"g":["regex","error"],"n":"result"}}],[11,"is_match","","Returns true if and only if the regex matches the string given.",7,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"bool"}}],[11,"find","","Returns the start and end byte range of the leftmost-first match in `text`. If no match exists, then `None` is returned.",7,{"i":[{"n":"self"},{"n":"str"}],"o":{"g":["match"],"n":"option"}}],[11,"find_iter","","Returns an iterator for each successive non-overlapping match in `text`, returning the start and end byte indices with respect to `text`.",7,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"matches"}}],[11,"captures","","Returns the capture groups corresponding to the leftmost-first match in `text`. Capture group `0` always corresponds to the entire match. If no match is found, then `None` is returned.",7,{"i":[{"n":"self"},{"n":"str"}],"o":{"g":["captures"],"n":"option"}}],[11,"captures_iter","","Returns an iterator over all the non-overlapping capture groups matched in `text`. This is operationally the same as `find_iter`, except it yields information about capturing group matches.",7,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"capturematches"}}],[11,"split","","Returns an iterator of substrings of `text` delimited by a match of the regular expression. Namely, each element of the iterator corresponds to text that isn't matched by the regular expression.",7,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"split"}}],[11,"splitn","","Returns an iterator of at most `limit` substrings of `text` delimited by a match of the regular expression. (A `limit` of `0` will return no substrings.) Namely, each element of the iterator corresponds to text that isn't matched by the regular expression. The remainder of the string that is not split will be the last element in the iterator.",7,{"i":[{"n":"self"},{"n":"str"},{"n":"usize"}],"o":{"n":"splitn"}}],[11,"replace","","Replaces the leftmost-first match with the replacement provided. The replacement can be a regular string (where `$N` and `$name` are expanded to match capture groups) or a function that takes the matches' `Captures` and returns the replaced string.",7,{"i":[{"n":"self"},{"n":"str"},{"n":"r"}],"o":{"g":["str"],"n":"cow"}}],[11,"replace_all","","Replaces all non-overlapping matches in `text` with the replacement provided. This is the same as calling `replacen` with `limit` set to `0`.",7,{"i":[{"n":"self"},{"n":"str"},{"n":"r"}],"o":{"g":["str"],"n":"cow"}}],[11,"replacen","","Replaces at most `limit` non-overlapping matches in `text` with the replacement provided. If `limit` is 0, then all non-overlapping matches are replaced.",7,{"i":[{"n":"self"},{"n":"str"},{"n":"usize"},{"n":"r"}],"o":{"g":["str"],"n":"cow"}}],[11,"shortest_match","","Returns the end location of a match in the text given.",7,{"i":[{"n":"self"},{"n":"str"}],"o":{"g":["usize"],"n":"option"}}],[11,"shortest_match_at","","Returns the same as shortest_match, but starts the search at the given offset.",7,{"i":[{"n":"self"},{"n":"str"},{"n":"usize"}],"o":{"g":["usize"],"n":"option"}}],[11,"is_match_at","","Returns the same as is_match, but starts the search at the given offset.",7,{"i":[{"n":"self"},{"n":"str"},{"n":"usize"}],"o":{"n":"bool"}}],[11,"find_at","","Returns the same as find, but starts the search at the given offset.",7,{"i":[{"n":"self"},{"n":"str"},{"n":"usize"}],"o":{"g":["match"],"n":"option"}}],[11,"read_captures_at","","Returns the same as captures, but starts the search at the given offset and populates the capture locations given.",7,{"i":[{"n":"self"},{"n":"locations"},{"n":"str"},{"n":"usize"}],"o":{"g":["match"],"n":"option"}}],[11,"as_str","","Returns the original string of this regex.",7,{"i":[{"n":"self"}],"o":{"n":"str"}}],[11,"capture_names","","Returns an iterator over the capture names.",7,{"i":[{"n":"self"}],"o":{"n":"capturenames"}}],[11,"captures_len","","Returns the number of captures.",7,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"locations","","Returns an empty set of locations that can be reused in multiple calls to `read_captures`.",7,{"i":[{"n":"self"}],"o":{"n":"locations"}}],[11,"next","","",10,{"i":[{"n":"self"}],"o":{"g":["option"],"n":"option"}}],[11,"size_hint","","",10,null],[11,"next","","",16,{"i":[{"n":"self"}],"o":{"g":["str"],"n":"option"}}],[11,"next","","",17,{"i":[{"n":"self"}],"o":{"g":["str"],"n":"option"}}],[11,"get","","Returns the match associated with the capture group at index `i`. If `i` does not correspond to a capture group, or if the capture group did not participate in the match, then `None` is returned.",9,{"i":[{"n":"self"},{"n":"usize"}],"o":{"g":["match"],"n":"option"}}],[11,"name","","Returns the match for the capture group named `name`. If `name` isn't a valid capture group or didn't match anything, then `None` is returned.",9,{"i":[{"n":"self"},{"n":"str"}],"o":{"g":["match"],"n":"option"}}],[11,"iter","","An iterator that yields all capturing matches in the order in which they appear in the regex. If a particular capture group didn't participate in the match, then `None` is yielded for that capture.",9,{"i":[{"n":"self"}],"o":{"n":"subcapturematches"}}],[11,"expand","","Expands all instances of `$name` in `replacement` to the corresponding capture group `name`, and writes them to the `dst` buffer given.",9,{"i":[{"n":"self"},{"n":"str"},{"n":"string"}]}],[11,"len","","Returns the number of captured groups.",9,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"fmt","","",9,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","regex::re_unicode","",107,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"index","regex","",9,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"str"}}],[11,"index","","",9,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"str"}}],[11,"next","","",13,{"i":[{"n":"self"}],"o":{"g":["option"],"n":"option"}}],[11,"next","","",12,{"i":[{"n":"self"}],"o":{"g":["captures"],"n":"option"}}],[11,"next","","",11,{"i":[{"n":"self"}],"o":{"g":["match"],"n":"option"}}],[11,"fmt","","",14,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"replace_append","","",14,{"i":[{"n":"self"},{"n":"captures"},{"n":"string"}]}],[11,"no_expansion","","",14,{"i":[{"n":"self"}],"o":{"g":["cow"],"n":"option"}}],[11,"replace_append","","",15,{"i":[{"n":"self"},{"n":"captures"},{"n":"string"}]}],[11,"no_expansion","","",15,{"i":[{"n":"self"}],"o":{"g":["cow"],"n":"option"}}],[0,"sparse","","",null,null],[3,"SparseSet","regex::sparse","A sparse set used for representing ordered NFA states.",null,null],[12,"dense","","Dense contains the instruction pointers in the order in which they were inserted. Accessing elements >= self.size is illegal.",109,null],[12,"sparse","","Sparse maps instruction pointers to their location in dense.",109,null],[12,"size","","The number of elements in the set.",109,null],[11,"clone","","",109,{"i":[{"n":"self"}],"o":{"n":"sparseset"}}],[11,"fmt","","",109,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","",109,{"i":[{"n":"usize"}],"o":{"n":"sparseset"}}],[11,"len","","",109,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"is_empty","","",109,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"capacity","","",109,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"insert","","",109,{"i":[{"n":"self"},{"n":"usize"}]}],[11,"contains","","",109,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"bool"}}],[11,"clear","","",109,{"i":[{"n":"self"}]}],[11,"deref","","",109,null],[0,"internal","regex","The `internal` module exists to support suspicious activity, such as testing different matching engines and supporting the `regex-debug` CLI utility.",null,null],[3,"Compiler","regex::internal","A compiler translates a regular expression AST to a sequence of instructions. The sequence of instructions represents an NFA.",null,null],[12,"insts","","",41,null],[12,"compiled","","",41,null],[12,"capture_name_idx","","",41,null],[12,"num_exprs","","",41,null],[12,"size_limit","","",41,null],[12,"suffix_cache","","",41,null],[12,"utf8_seqs","","",41,null],[12,"byte_classes","","",41,null],[3,"Exec","","`Exec` manages the execution of a regular expression.",null,null],[12,"ro","","All read only state.",61,null],[12,"cache","","Caches for the various matching engines.",61,null],[3,"ExecBuilder","","Facilitates the construction of an executor by exposing various knobs to control how a regex is executed and what kinds of resources it's permitted to use.",null,null],[12,"options","","",65,null],[12,"match_type","","",65,null],[12,"bytes","","",65,null],[12,"only_utf8","","",65,null],[3,"Char","","An inline representation of `Option<char>`.",null,null],[12,"0","","",76,null],[3,"CharInput","","An input reader over characters.",null,null],[12,"0","","",74,null],[3,"InputAt","","Represents a location in the input.",null,null],[12,"pos","","",73,null],[12,"c","","",73,null],[12,"byte","","",73,null],[12,"len","","",73,null],[3,"LiteralSearcher","","A prefix extracted from a compiled regular expression.",null,null],[12,"complete","","",78,null],[12,"lcp","","",78,null],[12,"lcs","","",78,null],[12,"matcher","","",78,null],[3,"Program","","Program is a sequence of instructions and various facts about thos instructions.",null,null],[12,"insts","","A sequence of instructions that represents an NFA.",92,null],[12,"matches","","Pointers to each Match instruction in the sequence.",92,null],[12,"captures","","The ordered sequence of all capture groups extracted from the AST. Unnamed groups are `None`.",92,null],[12,"capture_name_idx","","Pointers to all named capture groups into `captures`.",92,null],[12,"start","","A pointer to the start instruction. This can vary depending on how the program was compiled. For example, programs for use with the DFA engine have a `.*?` inserted at the beginning of unanchored regular expressions. The actual starting point of the program is after the `.*?`.",92,null],[12,"byte_classes","","A set of equivalence classes for discriminating bytes in the compiled program.",92,null],[12,"only_utf8","","When true, this program can only match valid UTF-8.",92,null],[12,"is_bytes","","When true, this program uses byte range instructions instead of Unicode range instructions.",92,null],[12,"is_dfa","","When true, the program is compiled for DFA matching. For example, this implies `is_bytes` and also inserts a preceding `.*?` for unanchored regexes.",92,null],[12,"is_reverse","","When true, the program matches text in reverse (for use only in the DFA).",92,null],[12,"is_anchored_start","","Whether the regex must match from the start of the input.",92,null],[12,"is_anchored_end","","Whether the regex must match at the end of the input.",92,null],[12,"has_unicode_word_boundary","","Whether this program contains a Unicode word boundary instruction.",92,null],[12,"prefixes","","A possibly empty machine for very quickly matching prefix literals.",92,null],[12,"dfa_size_limit","","A limit on the size of the cache that the DFA is allowed to use while matching.",92,null],[3,"InstRanges","","Representation of the Ranges instruction.",null,null],[12,"goto","","The next location to execute in the program if this instruction succeeds.",97,null],[12,"ranges","","The set of Unicode scalar value ranges to test.",97,null],[4,"Inst","","Inst is an instruction code in a Regex program.",null,null],[13,"Match","","Match indicates that the program has reached a match state.",99,null],[13,"Save","","Save causes the program to save the current location of the input in the slot indicated by InstSave.",99,null],[13,"Split","","Split causes the program to diverge to one of two paths in the program, preferring goto1 in InstSplit.",99,null],[13,"EmptyLook","","EmptyLook represents a zero-width assertion in a regex program. A zero-width assertion does not consume any of the input text.",99,null],[13,"Char","","Char requires the regex program to match the character in InstChar at the current position in the input.",99,null],[13,"Ranges","","Ranges requires the regex program to match the character at the current position in the input with one of the ranges specified in InstRanges.",99,null],[13,"Bytes","","Bytes is like Ranges, except it expresses a single byte range. It is used in conjunction with Split instructions to implement multi-byte character classes.",99,null],[4,"EmptyLook","","The set of zero-width match instructions.",null,null],[13,"StartLine","","Start of line or input.",100,null],[13,"EndLine","","End of line or input.",100,null],[13,"StartText","","Start of input.",100,null],[13,"EndText","","End of input.",100,null],[13,"WordBoundary","","Word character on one side and non-word character on other.",100,null],[13,"NotWordBoundary","","Word character on both sides or non-word character on both sides.",100,null],[13,"WordBoundaryAscii","","ASCII word boundary.",100,null],[13,"NotWordBoundaryAscii","","Not ASCII word boundary.",100,null],[8,"Input","","An abstraction over input used in the matching engines.",null,null],[10,"at","","Return an encoding of the position at byte offset `i`.",77,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"inputat"}}],[10,"next_char","","Return the Unicode character occurring next to `at`.",77,{"i":[{"n":"self"},{"n":"inputat"}],"o":{"n":"char"}}],[10,"previous_char","","Return the Unicode character occurring previous to `at`.",77,{"i":[{"n":"self"},{"n":"inputat"}],"o":{"n":"char"}}],[10,"is_empty_match","","Return true if the given empty width instruction matches at the input position given.",77,{"i":[{"n":"self"},{"n":"inputat"},{"n":"instemptylook"}],"o":{"n":"bool"}}],[10,"prefix_at","","Scan the input for a matching prefix.",77,{"i":[{"n":"self"},{"n":"literalsearcher"},{"n":"inputat"}],"o":{"g":["inputat"],"n":"option"}}],[10,"len","","The number of bytes in the input.",77,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"is_empty","regex::input","Whether the input is empty.",77,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[10,"as_bytes","regex::internal","Return the given input as a sequence of bytes.",77,null],[8,"Replacer","regex","Replacer describes types that can be used to replace matches in a string.",null,null],[10,"replace_append","","Appends text to `dst` to replace the current match.",108,{"i":[{"n":"self"},{"n":"captures"},{"n":"string"}]}],[11,"no_expansion","regex::re_unicode","Return a fixed unchanging replacement string.",108,{"i":[{"n":"self"}],"o":{"g":["cow"],"n":"option"}}],[11,"by_ref","","Return a `Replacer` that borrows and wraps this `Replacer`.",108,{"i":[{"n":"self"}],"o":{"n":"replacerref"}}]],"paths":[[3,"RegexBuilder"],[3,"RegexSetBuilder"],[3,"RegexSet"],[3,"SetMatches"],[3,"SetMatchesIntoIter"],[3,"SetMatchesIter"],[3,"Locations"],[3,"Regex"],[3,"Match"],[3,"Captures"],[3,"CaptureNames"],[3,"Matches"],[3,"CaptureMatches"],[3,"SubCaptureMatches"],[3,"ReplacerRef"],[3,"NoExpand"],[3,"Split"],[3,"SplitN"],[4,"Error"],[3,"RegexBuilder"],[3,"RegexSetBuilder"],[3,"Match"],[3,"Regex"],[3,"Matches"],[3,"CaptureMatches"],[3,"Split"],[3,"SplitN"],[3,"CaptureNames"],[3,"Captures"],[3,"SubCaptureMatches"],[3,"ReplacerRef"],[3,"NoExpand"],[3,"RegexSet"],[3,"SetMatches"],[3,"SetMatchesIntoIter"],[3,"SetMatchesIter"],[8,"Replacer"],[3,"Bounded"],[3,"Cache"],[4,"Job"],[3,"Patch"],[3,"Compiler"],[3,"CompileClass"],[3,"SuffixCache"],[3,"SuffixCacheEntry"],[3,"SuffixCacheKey"],[3,"ByteClassSet"],[4,"Hole"],[4,"MaybeInst"],[4,"InstHole"],[3,"Cache"],[3,"CacheInner"],[3,"Transitions"],[3,"Fsm"],[3,"State"],[3,"InstPtrs"],[3,"Byte"],[3,"EmptyFlags"],[3,"StateFlags"],[3,"TransitionsRow"],[4,"Result"],[3,"Exec"],[3,"ExecNoSync"],[3,"ExecNoSyncStr"],[3,"ExecReadOnly"],[3,"ExecBuilder"],[3,"Parsed"],[3,"ProgramCacheInner"],[4,"MatchType"],[4,"MatchLiteralType"],[4,"MatchNfaType"],[3,"CaptureRef"],[4,"Ref"],[3,"InputAt"],[3,"CharInput"],[3,"ByteInput"],[3,"Char"],[8,"Input"],[3,"LiteralSearcher"],[3,"SingleByteSet"],[3,"FreqyPacked"],[3,"BoyerMooreSearch"],[4,"Matcher"],[4,"LiteralIter"],[3,"Teddy"],[3,"Match"],[3,"Teddy"],[3,"Match"],[3,"Fsm"],[3,"Cache"],[3,"Threads"],[4,"FollowEpsilon"],[3,"Program"],[3,"InstSave"],[3,"InstSplit"],[3,"InstEmptyLook"],[3,"InstChar"],[3,"InstRanges"],[3,"InstBytes"],[4,"Inst"],[4,"EmptyLook"],[3,"RegexOptions"],[3,"CapturesDebug"],[3,"SubCapturesPosIter"],[3,"Matches"],[3,"CaptureMatches"],[8,"RegularExpression"],[3,"CapturesDebug"],[8,"Replacer"],[3,"SparseSet"]]};
searchIndex["regex_syntax"] = {"doc":"This crate provides a robust regular expression parser.","items":[[3,"Parser","regex_syntax","A convenience parser for regular expressions.",null,null],[12,"ast","","",0,null],[12,"hir","","",0,null],[3,"ParserBuilder","","A builder for a regular expression parser.",null,null],[12,"ast","","",1,null],[12,"hir","","",1,null],[4,"Error","","This error type encompasses any error that can be returned by this crate.",null,null],[13,"Parse","","An error that occurred while translating concrete syntax into abstract syntax (AST).",2,null],[13,"Translate","","An error that occurred while translating abstract syntax into a high level intermediate representation (HIR).",2,null],[13,"__Nonexhaustive","","Hints that destructuring should not be exhaustive.",2,null],[5,"escape","","Escapes all regular expression meta characters in `text`.",null,{"i":[{"n":"str"}],"o":{"n":"string"}}],[5,"escape_into","","Escapes all meta characters in `text` and writes the result into `buf`.",null,{"i":[{"n":"str"},{"n":"string"}]}],[5,"is_meta_character","","Returns true if the give character has significance in a regex.",null,{"i":[{"n":"char"}],"o":{"n":"bool"}}],[5,"is_word_character","","Returns true if and only if the given character is a Unicode word character.",null,{"i":[{"n":"char"}],"o":{"n":"bool"}}],[5,"is_word_byte","","Returns true if and only if the given character is an ASCII word character.",null,{"i":[{"n":"u8"}],"o":{"n":"bool"}}],[0,"ast","","Defines an abstract syntax for regular expressions.",null,null],[3,"Error","regex_syntax::ast","An error that occurred while parsing a regular expression into an abstract syntax tree.",null,null],[12,"kind","","The kind of error.",3,null],[12,"pattern","","The original pattern that the parser generated the error from. Every span in an error is a valid range into this string.",3,null],[12,"span","","The span of this error.",3,null],[3,"Span","","Span represents the position information of a single AST item.",null,null],[12,"start","","The start byte offset.",4,null],[12,"end","","The end byte offset.",4,null],[3,"Position","","A single position in a regular expression.",null,null],[12,"offset","","The absolute offset of this position, starting at `0` from the beginning of the regular expression pattern string.",5,null],[12,"line","","The line number, starting at `1`.",5,null],[12,"column","","The approximate column number, starting at `1`.",5,null],[3,"WithComments","","An abstract syntax tree for a singular expression along with comments found.",null,null],[12,"ast","","The actual ast.",6,null],[12,"comments","","All comments found in the original regular expression.",6,null],[3,"Comment","","A comment from a regular expression with an associated span.",null,null],[12,"span","","The span of this comment, including the beginning `#` and ending `\\n`.",7,null],[12,"comment","","The comment text, starting with the first character following the `#` and ending with the last character preceding the `\\n`.",7,null],[3,"Alternation","","An alternation of regular expressions.",null,null],[12,"span","","The span of this alternation.",8,null],[12,"asts","","The alternate regular expressions.",8,null],[3,"Concat","","A concatenation of regular expressions.",null,null],[12,"span","","The span of this concatenation.",9,null],[12,"asts","","The concatenation regular expressions.",9,null],[3,"Literal","","A single literal expression.",null,null],[12,"span","","The span of this literal.",10,null],[12,"kind","","The kind of this literal.",10,null],[12,"c","","The Unicode scalar value corresponding to this literal.",10,null],[3,"ClassPerl","","A Perl character class.",null,null],[12,"span","","The span of this class.",11,null],[12,"kind","","The kind of Perl class.",11,null],[12,"negated","","Whether the class is negated or not. e.g., `\\d` is not negated but `\\D` is.",11,null],[3,"ClassAscii","","An ASCII character class.",null,null],[12,"span","","The span of this class.",12,null],[12,"kind","","The kind of ASCII class.",12,null],[12,"negated","","Whether the class is negated or not. e.g., `[[:alpha:]]` is not negated but `[[:^alpha:]]` is.",12,null],[3,"ClassUnicode","","A Unicode character class.",null,null],[12,"span","","The span of this class.",13,null],[12,"negated","","Whether this class is negated or not.",13,null],[12,"kind","","The kind of Unicode class.",13,null],[3,"ClassBracketed","","A bracketed character class, e.g., `[a-z0-9]`.",null,null],[12,"span","","The span of this class.",14,null],[12,"negated","","Whether this class is negated or not. e.g., `[a]` is not negated but `[^a]` is.",14,null],[12,"kind","","The type of this set. A set is either a normal union of things, e.g., `[abc]` or a result of applying set operations, e.g., `[\\pL--c]`.",14,null],[3,"ClassSetRange","","A single character class range in a set.",null,null],[12,"span","","The span of this range.",15,null],[12,"start","","The start of this range.",15,null],[12,"end","","The end of this range.",15,null],[3,"ClassSetUnion","","A union of items inside a character class set.",null,null],[12,"span","","The span of the items in this operation. e.g., the `a-z0-9` in `[^a-z0-9]`",16,null],[12,"items","","The sequence of items that make up this union.",16,null],[3,"ClassSetBinaryOp","","A Unicode character class set operation.",null,null],[12,"span","","The span of this operation. e.g., the `a-z--[h-p]` in `[a-z--h-p]`.",17,null],[12,"kind","","The type of this set operation.",17,null],[12,"lhs","","The left hand side of the operation.",17,null],[12,"rhs","","The right hand side of the operation.",17,null],[3,"Assertion","","A single zero-width assertion.",null,null],[12,"span","","The span of this assertion.",18,null],[12,"kind","","The assertion kind, e.g., `\\b` or `^`.",18,null],[3,"Repetition","","A repetition operation applied to a regular expression.",null,null],[12,"span","","The span of this operation.",19,null],[12,"op","","The actual operation.",19,null],[12,"greedy","","Whether this operation was applied greedily or not.",19,null],[12,"ast","","The regular expression under repetition.",19,null],[3,"RepetitionOp","","The repetition operator itself.",null,null],[12,"span","","The span of this operator. This includes things like `+`, `*?` and `{m,n}`.",20,null],[12,"kind","","The type of operation.",20,null],[3,"Group","","A grouped regular expression.",null,null],[12,"span","","The span of this group.",21,null],[12,"kind","","The kind of this group.",21,null],[12,"ast","","The regular expression in this group.",21,null],[3,"CaptureName","","A capture name.",null,null],[12,"span","","The span of this capture name.",22,null],[12,"name","","The capture name.",22,null],[12,"index","","The capture index.",22,null],[3,"SetFlags","","A group of flags that is not applied to a particular regular expression.",null,null],[12,"span","","The span of these flags, including the grouping parentheses.",23,null],[12,"flags","","The actual sequence of flags.",23,null],[3,"Flags","","A group of flags.",null,null],[12,"span","","The span of this group of flags.",24,null],[12,"items","","A sequence of flag items. Each item is either a flag or a negation operator.",24,null],[3,"FlagsItem","","A single item in a group of flags.",null,null],[12,"span","","The span of this item.",25,null],[12,"kind","","The kind of this item.",25,null],[4,"ErrorKind","","The type of an error that occurred while building an AST.",null,null],[13,"CaptureLimitExceeded","","The capturing group limit was exceeded.",26,null],[13,"ClassEscapeInvalid","","An invalid escape sequence was found in a character class set.",26,null],[13,"ClassRangeInvalid","","An invalid character class range was found. An invalid range is any range where the start is greater than the end.",26,null],[13,"ClassUnclosed","","An opening `[` was found with no corresponding closing `]`.",26,null],[13,"DecimalEmpty","","An empty decimal number was given where one was expected.",26,null],[13,"DecimalInvalid","","An invalid decimal number was given where one was expected.",26,null],[13,"EscapeHexEmpty","","A bracketed hex literal was empty.",26,null],[13,"EscapeHexInvalid","","A bracketed hex literal did not correspond to a Unicode scalar value.",26,null],[13,"EscapeHexInvalidDigit","","An invalid hexadecimal digit was found.",26,null],[13,"EscapeUnexpectedEof","","EOF was found before an escape sequence was completed.",26,null],[13,"EscapeUnrecognized","","An unrecognized escape sequence.",26,null],[13,"FlagDanglingNegation","","A dangling negation was used when setting flags, e.g., `i-`.",26,null],[13,"FlagDuplicate","","A flag was used twice, e.g., `i-i`.",26,null],[12,"original","regex_syntax::ast::ErrorKind","The position of the original flag. The error position points to the duplicate flag.",26,null],[13,"FlagRepeatedNegation","regex_syntax::ast","The negation operator was used twice, e.g., `-i-s`.",26,null],[12,"original","regex_syntax::ast::ErrorKind","The position of the original negation operator. The error position points to the duplicate negation operator.",26,null],[13,"FlagUnexpectedEof","regex_syntax::ast","Expected a flag but got EOF, e.g., `(?`.",26,null],[13,"FlagUnrecognized","","Unrecognized flag, e.g., `a`.",26,null],[13,"GroupNameDuplicate","","A duplicate capture name was found.",26,null],[12,"original","regex_syntax::ast::ErrorKind","The position of the initial occurrence of the capture name. The error position itself points to the duplicate occurrence.",26,null],[13,"GroupNameEmpty","regex_syntax::ast","A capture group name is empty, e.g., `(?P<>abc)`.",26,null],[13,"GroupNameInvalid","","An invalid character was seen for a capture group name. This includes errors where the first character is a digit (even though subsequent characters are allowed to be digits).",26,null],[13,"GroupNameUnexpectedEof","","A closing `>` could not be found for a capture group name.",26,null],[13,"GroupUnclosed","","An unclosed group, e.g., `(ab`.",26,null],[13,"GroupUnopened","","An unopened group, e.g., `ab)`.",26,null],[13,"NestLimitExceeded","","The nest limit was exceeded. The limit stored here is the limit configured in the parser.",26,null],[13,"RepetitionCountInvalid","","The range provided in a counted repetition operator is invalid. The range is invalid if the start is greater than the end.",26,null],[13,"RepetitionCountUnclosed","","An opening `{` was found with no corresponding closing `}`.",26,null],[13,"RepetitionMissing","","A repetition operator was applied to a missing sub-expression. This occurs, for example, in the regex consisting of just a `*`. It is, however, possible to create a repetition operating on an empty sub-expression. For example, `()*` is still considered valid.",26,null],[13,"UnsupportedBackreference","","When octal support is disabled, this error is produced when an octal escape is used. The octal escape is assumed to be an invocation of a backreference, which is the common case.",26,null],[13,"UnsupportedLookAround","","When syntax similar to PCRE's look-around is used, this error is returned. Some example syntaxes that are rejected include, but are not necessarily limited to, `(?=re)`, `(?!re)`, `(?<=re)` and `(?<!re)`. Note that all of these syntaxes are otherwise invalid; this error is used to improve the user experience.",26,null],[13,"__Nonexhaustive","","Hints that destructuring should not be exhaustive.",26,null],[4,"Ast","","An abstract syntax tree for a single regular expression.",null,null],[13,"Empty","","An empty regex that matches everything.",27,null],[13,"Flags","","A set of flags, e.g., `(?is)`.",27,null],[13,"Literal","","A single character literal, which includes escape sequences.",27,null],[13,"Dot","","The \"any character\" class.",27,null],[13,"Assertion","","A single zero-width assertion.",27,null],[13,"Class","","A single character class. This includes all forms of character classes except for `.`. e.g., `\\d`, `\\pN`, `[a-z]` and `[[:alpha:]]`.",27,null],[13,"Repetition","","A repetition operator applied to an arbitrary regular expression.",27,null],[13,"Group","","A grouped regular expression.",27,null],[13,"Alternation","","An alternation of regular expressions.",27,null],[13,"Concat","","A concatenation of regular expressions.",27,null],[4,"LiteralKind","","The kind of a single literal expression.",null,null],[13,"Verbatim","","The literal is written verbatim, e.g., `a` or `☃`.",28,null],[13,"Punctuation","","The literal is written as an escape because it is punctuation, e.g., `\\*` or `\\[`.",28,null],[13,"Octal","","The literal is written as an octal escape, e.g., `\\141`.",28,null],[13,"HexFixed","","The literal is written as a hex code with a fixed number of digits depending on the type of the escape, e.g., `\\x61` or or `\\u0061` or `\\U00000061`.",28,null],[13,"HexBrace","","The literal is written as a hex code with a bracketed number of digits. The only restriction is that the bracketed hex code must refer to a valid Unicode scalar value.",28,null],[13,"Special","","The literal is written as a specially recognized escape, e.g., `\\f` or `\\n`.",28,null],[4,"SpecialLiteralKind","","The type of a special literal.",null,null],[13,"Bell","","Bell, spelled `\\a` (`\\x07`).",29,null],[13,"FormFeed","","Form feed, spelled `\\f` (`\\x0C`).",29,null],[13,"Tab","","Tab, spelled `\\t` (`\\x09`).",29,null],[13,"LineFeed","","Line feed, spelled `\\n` (`\\x0A`).",29,null],[13,"CarriageReturn","","Carriage return, spelled `\\r` (`\\x0D`).",29,null],[13,"VerticalTab","","Vertical tab, spelled `\\v` (`\\x0B`).",29,null],[13,"Space","","Space, spelled `\\` (`\\x20`). Note that this can only appear when parsing in verbose mode.",29,null],[4,"HexLiteralKind","","The type of a Unicode hex literal.",null,null],[13,"X","","A `\\x` prefix. When used without brackets, this form is limited to two digits.",30,null],[13,"UnicodeShort","","A `\\u` prefix. When used without brackets, this form is limited to four digits.",30,null],[13,"UnicodeLong","","A `\\U` prefix. When used without brackets, this form is limited to eight digits.",30,null],[4,"Class","","A single character class expression.",null,null],[13,"Unicode","","A Unicode character class, e.g., `\\pL` or `\\p{Greek}`.",31,null],[13,"Perl","","A perl character class, e.g., `\\d` or `\\W`.",31,null],[13,"Bracketed","","A bracketed character class set, which may contain zero or more character ranges and/or zero or more nested classes. e.g., `[a-zA-Z\\pL]`.",31,null],[4,"ClassPerlKind","","The available Perl character classes.",null,null],[13,"Digit","","Decimal numbers.",32,null],[13,"Space","","Whitespace.",32,null],[13,"Word","","Word characters.",32,null],[4,"ClassAsciiKind","","The available ASCII character classes.",null,null],[13,"Alnum","","`[0-9A-Za-z]`",33,null],[13,"Alpha","","`[A-Za-z]`",33,null],[13,"Ascii","","`[\\x00-\\x7F]`",33,null],[13,"Blank","","`[ \\t]`",33,null],[13,"Cntrl","","`[\\x00-\\x1F\\x7F]`",33,null],[13,"Digit","","`[0-9]`",33,null],[13,"Graph","","`[!-~]`",33,null],[13,"Lower","","`[a-z]`",33,null],[13,"Print","","`[ -~]`",33,null],[13,"Punct","","`[!-/:-@\\[-`{-~]`",33,null],[13,"Space","","`[\\t\\n\\v\\f\\r ]`",33,null],[13,"Upper","","`[A-Z]`",33,null],[13,"Word","","`[0-9A-Za-z_]`",33,null],[13,"Xdigit","","`[0-9A-Fa-f]`",33,null],[4,"ClassUnicodeKind","","The available forms of Unicode character classes.",null,null],[13,"OneLetter","","A one letter abbreviated class, e.g., `\\pN`.",34,null],[13,"Named","","A binary property, general category or script. The string may be empty.",34,null],[13,"NamedValue","","A property name and an associated value.",34,null],[12,"op","regex_syntax::ast::ClassUnicodeKind","The type of Unicode op used to associate `name` with `value`.",34,null],[12,"name","","The property name (which may be empty).",34,null],[12,"value","","The property value (which may be empty).",34,null],[4,"ClassUnicodeOpKind","regex_syntax::ast","The type of op used in a Unicode character class.",null,null],[13,"Equal","","A property set to a specific value, e.g., `\\p{scx=Katakana}`.",35,null],[13,"Colon","","A property set to a specific value using a colon, e.g., `\\p{scx:Katakana}`.",35,null],[13,"NotEqual","","A property that isn't a particular value, e.g., `\\p{scx!=Katakana}`.",35,null],[4,"ClassSet","","A character class set.",null,null],[13,"Item","","An item, which can be a single literal, range, nested character class or a union of items.",36,null],[13,"BinaryOp","","A single binary operation (i.e., &&, -- or ~~).",36,null],[4,"ClassSetItem","","A single component of a character class set.",null,null],[13,"Empty","","An empty item.",37,null],[13,"Literal","","A single literal.",37,null],[13,"Range","","A range between two literals.",37,null],[13,"Ascii","","An ASCII character class, e.g., `[:alnum:]` or `[:punct:]`.",37,null],[13,"Unicode","","A Unicode character class, e.g., `\\pL` or `\\p{Greek}`.",37,null],[13,"Perl","","A perl character class, e.g., `\\d` or `\\W`.",37,null],[13,"Bracketed","","A bracketed character class set, which may contain zero or more character ranges and/or zero or more nested classes. e.g., `[a-zA-Z\\pL]`.",37,null],[13,"Union","","A union of items.",37,null],[4,"ClassSetBinaryOpKind","","The type of a Unicode character class set operation.",null,null],[13,"Intersection","","The intersection of two sets, e.g., `\\pN&&[a-z]`.",38,null],[13,"Difference","","The difference of two sets, e.g., `\\pN--[0-9]`.",38,null],[13,"SymmetricDifference","","The symmetric difference of two sets. The symmetric difference is the set of elements belonging to one but not both sets. e.g., `[\\pL~~[:ascii:]]`.",38,null],[4,"AssertionKind","","An assertion kind.",null,null],[13,"StartLine","","`^`",39,null],[13,"EndLine","","`$`",39,null],[13,"StartText","","`\\A`",39,null],[13,"EndText","","`\\z`",39,null],[13,"WordBoundary","","`\\b`",39,null],[13,"NotWordBoundary","","`\\B`",39,null],[4,"RepetitionKind","","The kind of a repetition operator.",null,null],[13,"ZeroOrOne","","`?`",40,null],[13,"ZeroOrMore","","`*`",40,null],[13,"OneOrMore","","`+`",40,null],[13,"Range","","`{m,n}`",40,null],[4,"RepetitionRange","","A range repetition operator.",null,null],[13,"Exactly","","`{m}`",41,null],[13,"AtLeast","","`{m,}`",41,null],[13,"Bounded","","`{m,n}`",41,null],[4,"GroupKind","","The kind of a group.",null,null],[13,"CaptureIndex","","`(a)`",42,null],[13,"CaptureName","","`(?P<name>a)`",42,null],[13,"NonCapturing","","`(?:a)` and `(?i:a)`",42,null],[4,"FlagsItemKind","","The kind of an item in a group of flags.",null,null],[13,"Negation","","A negation operator applied to all subsequent flags in the enclosing group.",43,null],[13,"Flag","","A single flag in a group.",43,null],[4,"Flag","","A single flag.",null,null],[13,"CaseInsensitive","","`i`",44,null],[13,"MultiLine","","`m`",44,null],[13,"DotMatchesNewLine","","`s`",44,null],[13,"SwapGreed","","`U`",44,null],[13,"Unicode","","`u`",44,null],[13,"IgnoreWhitespace","","`x`",44,null],[5,"visit","","Executes an implementation of `Visitor` in constant stack space.",null,{"i":[{"n":"ast"},{"n":"v"}],"o":{"n":"result"}}],[0,"parse","","This module provides a regular expression parser.",null,null],[3,"ParserBuilder","regex_syntax::ast::parse","A builder for a regular expression parser.",null,null],[12,"ignore_whitespace","","",45,null],[12,"nest_limit","","",45,null],[12,"octal","","",45,null],[3,"Parser","","A regular expression parser.",null,null],[12,"pos","","The current position of the parser.",46,null],[12,"capture_index","","The current capture index.",46,null],[12,"nest_limit","","The maximum number of open parens/brackets allowed. If the parser exceeds this number, then an error is returned.",46,null],[12,"octal","","Whether to support octal syntax or not. When `false`, the parser will return an error helpfully pointing out that backreferences are not supported.",46,null],[12,"initial_ignore_whitespace","","The initial setting for `ignore_whitespace` as provided by Th`ParserBuilder`. is is used when reseting the parser's state.",46,null],[12,"ignore_whitespace","","Whether whitespace should be ignored. When enabled, comments are also permitted.",46,null],[12,"comments","","A list of comments, in order of appearance.",46,null],[12,"stack_group","","A stack of grouped sub-expressions, including alternations.",46,null],[12,"stack_class","","A stack of nested character classes. This is only non-empty when parsing a class.",46,null],[12,"capture_names","","A sorted sequence of capture names. This is used to detect duplicate capture names and report an error if one is detected.",46,null],[12,"scratch","","A scratch buffer used in various places. Mostly this is used to accumulate relevant characters from parts of a pattern.",46,null],[3,"ParserI","","ParserI is the internal parser implementation.",null,null],[12,"parser","","The parser state/configuration.",47,null],[12,"pattern","","The full regular expression provided by the user.",47,null],[3,"NestLimiter","","A type that traverses a fully parsed Ast and checks whether its depth exceeds the specified nesting limit. If it does, then an error is returned.",null,null],[12,"p","","The parser that is checking the nest limit.",48,null],[12,"depth","","The current depth while walking an Ast.",48,null],[4,"Primitive","","A primitive is an expression with no sub-expressions. This includes literals, assertions and non-set character classes. This representation is used as intermediate state in the parser.",null,null],[13,"Literal","","",49,null],[13,"Assertion","","",49,null],[13,"Dot","","",49,null],[13,"Perl","","",49,null],[13,"Unicode","","",49,null],[4,"GroupState","","GroupState represents a single stack frame while parsing nested groups and alternations. Each frame records the state up to an opening parenthesis or a alternating bracket `|`.",null,null],[13,"Group","","This state is pushed whenever an opening group is found.",50,null],[12,"concat","regex_syntax::ast::parse::GroupState","The concatenation immediately preceding the opening group.",50,null],[12,"group","","The group that has been opened. Its sub-AST is always empty.",50,null],[12,"ignore_whitespace","","Whether this group has the `x` flag enabled or not.",50,null],[13,"Alternation","regex_syntax::ast::parse","This state is pushed whenever a new alternation branch is found. If an alternation branch is found and this state is at the top of the stack, then this state should be modified to include the new alternation.",50,null],[4,"ClassState","","ClassState represents a single stack frame while parsing character classes. Each frame records the state up to an intersection, difference, symmetric difference or nested class.",null,null],[13,"Open","","This state is pushed whenever an opening bracket is found.",51,null],[12,"union","regex_syntax::ast::parse::ClassState","The union of class items immediately preceding this class.",51,null],[12,"set","","The class that has been opened. Typically this just corresponds to the `[`, but it can also include `[^` since `^` indicates negation of the class.",51,null],[13,"Op","regex_syntax::ast::parse","This state is pushed when a operator is seen. When popped, the stored set becomes the left hand side of the operator.",51,null],[12,"kind","regex_syntax::ast::parse::ClassState","The type of the operation, i.e., &&, -- or ~~.",51,null],[12,"lhs","","The left-hand side of the operator.",51,null],[5,"is_hex","regex_syntax::ast::parse","Returns true if the given character is a hexadecimal digit.",null,{"i":[{"n":"char"}],"o":{"n":"bool"}}],[5,"is_capture_char","","Returns true if the given character is a valid in a capture group name.",null,{"i":[{"n":"char"},{"n":"bool"}],"o":{"n":"bool"}}],[6,"Result","","",null,null],[11,"clone","","",49,{"i":[{"n":"self"}],"o":{"n":"primitive"}}],[11,"fmt","","",49,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",49,null],[11,"eq","","",49,{"i":[{"n":"self"},{"n":"primitive"}],"o":{"n":"bool"}}],[11,"ne","","",49,{"i":[{"n":"self"},{"n":"primitive"}],"o":{"n":"bool"}}],[11,"span","","Return the span of this primitive.",49,{"i":[{"n":"self"}],"o":{"n":"span"}}],[11,"into_ast","","Convert this primitive into a proper AST.",49,{"i":[{"n":"self"}],"o":{"n":"ast"}}],[11,"into_class_set_item","","Convert this primitive into an item in a character class.",49,{"i":[{"n":"self"},{"n":"parseri"}],"o":{"g":["classsetitem","error"],"n":"result"}}],[11,"into_class_literal","","Convert this primitive into a literal in a character class. In particular, literals are the only valid items that can appear in ranges.",49,{"i":[{"n":"self"},{"n":"parseri"}],"o":{"g":["literal","error"],"n":"result"}}],[11,"clone","","",45,{"i":[{"n":"self"}],"o":{"n":"parserbuilder"}}],[11,"fmt","","",45,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"default","","",45,{"o":{"n":"parserbuilder"}}],[11,"new","","Create a new parser builder with a default configuration.",45,{"o":{"n":"parserbuilder"}}],[11,"build","","Build a parser from this configuration with the given pattern.",45,{"i":[{"n":"self"}],"o":{"n":"parser"}}],[11,"nest_limit","","Set the nesting limit for this parser.",45,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"parserbuilder"}}],[11,"octal","","Whether to support octal syntax or not.",45,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"parserbuilder"}}],[11,"ignore_whitespace","","Enable verbose mode in the regular expression.",45,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"parserbuilder"}}],[11,"clone","","",46,{"i":[{"n":"self"}],"o":{"n":"parser"}}],[11,"fmt","","",46,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",47,{"i":[{"n":"self"}],"o":{"n":"parseri"}}],[11,"fmt","","",47,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",50,{"i":[{"n":"self"}],"o":{"n":"groupstate"}}],[11,"fmt","","",50,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",51,{"i":[{"n":"self"}],"o":{"n":"classstate"}}],[11,"fmt","","",51,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","Create a new parser with a default configuration.",46,{"o":{"n":"parser"}}],[11,"parse","","Parse the regular expression into an abstract syntax tree.",46,{"i":[{"n":"self"},{"n":"str"}],"o":{"g":["ast","error"],"n":"result"}}],[11,"parse_with_comments","","Parse the regular expression and return an abstract syntax tree with all of the comments found in the pattern.",46,{"i":[{"n":"self"},{"n":"str"}],"o":{"g":["withcomments","error"],"n":"result"}}],[11,"reset","","Reset the internal state of a parser.",46,{"i":[{"n":"self"}]}],[11,"new","","Build an internal parser from a parser configuration and a pattern.",47,{"i":[{"n":"p"},{"n":"str"}],"o":{"n":"parseri"}}],[11,"parser","","Return a reference to the parser state.",47,{"i":[{"n":"self"}],"o":{"n":"parser"}}],[11,"pattern","","Return a reference to the pattern being parsed.",47,{"i":[{"n":"self"}],"o":{"n":"str"}}],[11,"error","","Create a new error with the given span and error type.",47,{"i":[{"n":"self"},{"n":"span"},{"n":"errorkind"}],"o":{"n":"error"}}],[11,"offset","","Return the current offset of the parser.",47,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"line","","Return the current line number of the parser.",47,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"column","","Return the current column of the parser.",47,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"next_capture_index","","Return the next capturing index. Each subsequent call increments the internal index.",47,{"i":[{"n":"self"},{"n":"span"}],"o":{"g":["u32","error"],"n":"result"}}],[11,"add_capture_name","","Adds the given capture name to this parser. If this capture name has already been used, then an error is returned.",47,{"i":[{"n":"self"},{"n":"capturename"}],"o":{"g":["error"],"n":"result"}}],[11,"ignore_whitespace","","Return whether the parser should ignore whitespace or not.",47,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"char","","Return the character at the current position of the parser.",47,{"i":[{"n":"self"}],"o":{"n":"char"}}],[11,"char_at","","Return the character at the given position.",47,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"char"}}],[11,"bump","","Bump the parser to the next Unicode scalar value.",47,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"bump_if","","If the substring starting at the current position of the parser has the given prefix, then bump the parser to the character immediately following the prefix and return true. Otherwise, don't bump the parser and return false.",47,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"bool"}}],[11,"is_lookaround_prefix","","Returns true if and only if the parser is positioned at a look-around prefix. The conditions under which this returns true must always correspond to a regular expression that would otherwise be consider invalid.",47,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"bump_and_bump_space","","Bump the parser, and if the `x` flag is enabled, bump through any subsequent spaces. Return true if and only if the parser is not at EOF.",47,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"bump_space","","If the `x` flag is enabled (i.e., whitespace insensitivity with comments), then this will advance the parser through all whitespace and comments to the next non-whitespace non-comment byte.",47,{"i":[{"n":"self"}]}],[11,"peek","","Peek at the next character in the input without advancing the parser.",47,{"i":[{"n":"self"}],"o":{"g":["char"],"n":"option"}}],[11,"peek_space","","Like peek, but will ignore spaces when the parser is in whitespace insensitive mode.",47,{"i":[{"n":"self"}],"o":{"g":["char"],"n":"option"}}],[11,"is_eof","","Returns true if the next call to `bump` would return false.",47,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"pos","","Return the current position of the parser, which includes the offset, line and column.",47,{"i":[{"n":"self"}],"o":{"n":"position"}}],[11,"span","","Create a span at the current position of the parser. Both the start and end of the span are set.",47,{"i":[{"n":"self"}],"o":{"n":"span"}}],[11,"span_char","","Create a span that covers the current character.",47,{"i":[{"n":"self"}],"o":{"n":"span"}}],[11,"push_alternate","","Parse and push a single alternation on to the parser's internal stack. If the top of the stack already has an alternation, then add to that instead of pushing a new one.",47,{"i":[{"n":"self"},{"n":"concat"}],"o":{"g":["concat","error"],"n":"result"}}],[11,"push_or_add_alternation","","Pushes or adds the given branch of an alternation to the parser's internal stack of state.",47,{"i":[{"n":"self"},{"n":"concat"}]}],[11,"push_group","","Parse and push a group AST (and its parent concatenation) on to the parser's internal stack. Return a fresh concatenation corresponding to the group's sub-AST.",47,{"i":[{"n":"self"},{"n":"concat"}],"o":{"g":["concat","error"],"n":"result"}}],[11,"pop_group","","Pop a group AST from the parser's internal stack and set the group's AST to the given concatenation. Return the concatenation containing the group.",47,{"i":[{"n":"self"},{"n":"concat"}],"o":{"g":["concat","error"],"n":"result"}}],[11,"pop_group_end","","Pop the last state from the parser's internal stack, if it exists, and add the given concatenation to it. There either must be no state or a single alternation item on the stack. Any other scenario produces an error.",47,{"i":[{"n":"self"},{"n":"concat"}],"o":{"g":["ast","error"],"n":"result"}}],[11,"push_class_open","","Parse the opening of a character class and push the current class parsing context onto the parser's stack. This assumes that the parser is positioned at an opening `[`. The given union should correspond to the union of set items built up before seeing the `[`.",47,{"i":[{"n":"self"},{"n":"classsetunion"}],"o":{"g":["classsetunion","error"],"n":"result"}}],[11,"pop_class","","Parse the end of a character class set and pop the character class parser stack. The union given corresponds to the last union built before seeing the closing `]`. The union returned corresponds to the parent character class set with the nested class added to it.",47,{"i":[{"n":"self"},{"n":"classsetunion"}],"o":{"g":["either","error"],"n":"result"}}],[11,"unclosed_class_error","","Return an \"unclosed class\" error whose span points to the most recently opened class.",47,{"i":[{"n":"self"}],"o":{"n":"error"}}],[11,"push_class_op","","Push the current set of class items on to the class parser's stack as the left hand side of the given operator.",47,{"i":[{"n":"self"},{"n":"classsetbinaryopkind"},{"n":"classsetunion"}],"o":{"n":"classsetunion"}}],[11,"pop_class_op","","Pop a character class set from the character class parser stack. If the top of the stack is just an item (not an operation), then return the given set unchanged. If the top of the stack is an operation, then the given set will be used as the rhs of the operation on the top of the stack. In that case, the binary operation is returned as a set.",47,{"i":[{"n":"self"},{"n":"classset"}],"o":{"n":"classset"}}],[11,"parse","","Parse the regular expression into an abstract syntax tree.",47,{"i":[{"n":"self"}],"o":{"g":["ast","error"],"n":"result"}}],[11,"parse_with_comments","","Parse the regular expression and return an abstract syntax tree with all of the comments found in the pattern.",47,{"i":[{"n":"self"}],"o":{"g":["withcomments","error"],"n":"result"}}],[11,"parse_uncounted_repetition","","Parses an uncounted repetition operation. An uncounted repetition operator includes ?, * and +, but does not include the {m,n} syntax. The given `kind` should correspond to the operator observed by the caller.",47,{"i":[{"n":"self"},{"n":"concat"},{"n":"repetitionkind"}],"o":{"g":["concat","error"],"n":"result"}}],[11,"parse_counted_repetition","","Parses a counted repetition operation. A counted repetition operator corresponds to the {m,n} syntax, and does not include the ?, * or + operators.",47,{"i":[{"n":"self"},{"n":"concat"}],"o":{"g":["concat","error"],"n":"result"}}],[11,"parse_group","","Parse a group (which contains a sub-expression) or a set of flags.",47,{"i":[{"n":"self"}],"o":{"g":["either","error"],"n":"result"}}],[11,"parse_capture_name","","Parses a capture group name. Assumes that the parser is positioned at the first character in the name following the opening `<` (and may possibly be EOF). This advances the parser to the first character following the closing `>`.",47,{"i":[{"n":"self"},{"n":"u32"}],"o":{"g":["capturename","error"],"n":"result"}}],[11,"parse_flags","","Parse a sequence of flags starting at the current character.",47,{"i":[{"n":"self"}],"o":{"g":["flags","error"],"n":"result"}}],[11,"parse_flag","","Parse the current character as a flag. Do not advance the parser.",47,{"i":[{"n":"self"}],"o":{"g":["flag","error"],"n":"result"}}],[11,"parse_primitive","","Parse a primitive AST. e.g., A literal, non-set character class or assertion.",47,{"i":[{"n":"self"}],"o":{"g":["primitive","error"],"n":"result"}}],[11,"parse_escape","","Parse an escape sequence as a primitive AST.",47,{"i":[{"n":"self"}],"o":{"g":["primitive","error"],"n":"result"}}],[11,"parse_octal","","Parse an octal representation of a Unicode codepoint up to 3 digits long. This expects the parser to be positioned at the first octal digit and advances the parser to the first character immediately following the octal number. This also assumes that parsing octal escapes is enabled.",47,{"i":[{"n":"self"}],"o":{"n":"literal"}}],[11,"parse_hex","","Parse a hex representation of a Unicode codepoint. This handles both hex notations, i.e., `\\xFF` and `\\x{FFFF}`. This expects the parser to be positioned at the `x`, `u` or `U` prefix. The parser is advanced to the first character immediately following the hexadecimal literal.",47,{"i":[{"n":"self"}],"o":{"g":["literal","error"],"n":"result"}}],[11,"parse_hex_digits","","Parse an N-digit hex representation of a Unicode codepoint. This expects the parser to be positioned at the first digit and will advance the parser to the first character immediately following the escape sequence.",47,{"i":[{"n":"self"},{"n":"hexliteralkind"}],"o":{"g":["literal","error"],"n":"result"}}],[11,"parse_hex_brace","","Parse a hex representation of any Unicode scalar value. This expects the parser to be positioned at the opening brace `{` and will advance the parser to the first character following the closing brace `}`.",47,{"i":[{"n":"self"},{"n":"hexliteralkind"}],"o":{"g":["literal","error"],"n":"result"}}],[11,"parse_decimal","","Parse a decimal number into a u32 while trimming leading and trailing whitespace.",47,{"i":[{"n":"self"}],"o":{"g":["u32","error"],"n":"result"}}],[11,"parse_set_class","","Parse a standard character class consisting primarily of characters or character ranges, but can also contain nested character classes of any type (sans `.`).",47,{"i":[{"n":"self"}],"o":{"g":["class","error"],"n":"result"}}],[11,"parse_set_class_range","","Parse a single primitive item in a character class set. The item to be parsed can either be one of a simple literal character, a range between two simple literal characters or a \"primitive\" character class like \\w or \\p{Greek}.",47,{"i":[{"n":"self"}],"o":{"g":["classsetitem","error"],"n":"result"}}],[11,"parse_set_class_item","","Parse a single item in a character class as a primitive, where the primitive either consists of a verbatim literal or a single escape sequence.",47,{"i":[{"n":"self"}],"o":{"g":["primitive","error"],"n":"result"}}],[11,"parse_set_class_open","","Parses the opening of a character class set. This includes the opening bracket along with `^` if present to indicate negation. This also starts parsing the opening set of unioned items if applicable, since there are special rules applied to certain characters in the opening of a character class. For example, `[^]]` is the class of all characters not equal to `]`. (`]` would need to be escaped in any other position.) Similarly for `-`.",47,{"i":[{"n":"self"}],"o":{"g":["error"],"n":"result"}}],[11,"maybe_parse_ascii_class","","Attempt to parse an ASCII character class, e.g., `[:alnum:]`.",47,{"i":[{"n":"self"}],"o":{"g":["classascii"],"n":"option"}}],[11,"parse_unicode_class","","Parse a Unicode class in either the single character notation, `\\pN` or the multi-character bracketed notation, `\\p{Greek}`. This assumes the parser is positioned at the `p` (or `P` for negation) and will advance the parser to the character immediately following the class.",47,{"i":[{"n":"self"}],"o":{"g":["classunicode","error"],"n":"result"}}],[11,"parse_perl_class","","Parse a Perl character class, e.g., `\\d` or `\\W`. This assumes the parser is currently at a valid character class name and will be advanced to the character immediately following the class.",47,{"i":[{"n":"self"}],"o":{"n":"classperl"}}],[11,"fmt","","",48,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","",48,{"i":[{"n":"parseri"}],"o":{"n":"nestlimiter"}}],[11,"check","","",48,{"i":[{"n":"self"},{"n":"ast"}],"o":{"g":["error"],"n":"result"}}],[11,"increment_depth","","",48,{"i":[{"n":"self"},{"n":"span"}],"o":{"g":["error"],"n":"result"}}],[11,"decrement_depth","","",48,{"i":[{"n":"self"}]}],[11,"finish","","",48,{"i":[{"n":"self"}],"o":{"g":["error"],"n":"result"}}],[11,"visit_pre","","",48,{"i":[{"n":"self"},{"n":"ast"}],"o":{"g":["error"],"n":"result"}}],[11,"visit_post","","",48,{"i":[{"n":"self"},{"n":"ast"}],"o":{"g":["error"],"n":"result"}}],[11,"visit_class_set_item_pre","","",48,{"i":[{"n":"self"},{"n":"classsetitem"}],"o":{"g":["error"],"n":"result"}}],[11,"visit_class_set_item_post","","",48,{"i":[{"n":"self"},{"n":"classsetitem"}],"o":{"g":["error"],"n":"result"}}],[11,"visit_class_set_binary_op_pre","","",48,{"i":[{"n":"self"},{"n":"classsetbinaryop"}],"o":{"g":["error"],"n":"result"}}],[11,"visit_class_set_binary_op_post","","",48,{"i":[{"n":"self"},{"n":"classsetbinaryop"}],"o":{"g":["error"],"n":"result"}}],[0,"print","regex_syntax::ast","This module provides a regular expression printer for `Ast`.",null,null],[3,"PrinterBuilder","regex_syntax::ast::print","A builder for constructing a printer.",null,null],[12,"_priv","","",52,null],[3,"Printer","","A printer for a regular expression abstract syntax tree.",null,null],[12,"_priv","","",53,null],[3,"Writer","","",null,null],[12,"printer","","",54,null],[12,"wtr","","",54,null],[11,"clone","","",52,{"i":[{"n":"self"}],"o":{"n":"printerbuilder"}}],[11,"fmt","","",52,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"default","","",52,{"o":{"n":"printerbuilder"}}],[11,"new","","",52,{"o":{"n":"printerbuilder"}}],[11,"build","","",52,{"i":[{"n":"self"}],"o":{"n":"printer"}}],[11,"fmt","","",53,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","Create a new printer.",53,{"o":{"n":"printer"}}],[11,"print","","Print the given `Ast` to the given writer. The writer must implement `fmt::Write`. Typical implementations of `fmt::Write` that can be used here are a `fmt::Formatter` (which is available in `fmt::Display` implementations) or a `&mut String`.",53,{"i":[{"n":"self"},{"n":"ast"},{"n":"w"}],"o":{"n":"result"}}],[11,"fmt","","",54,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"finish","","",54,{"i":[{"n":"self"}],"o":{"n":"result"}}],[11,"visit_pre","","",54,{"i":[{"n":"self"},{"n":"ast"}],"o":{"n":"result"}}],[11,"visit_post","","",54,{"i":[{"n":"self"},{"n":"ast"}],"o":{"n":"result"}}],[11,"visit_alternation_in","","",54,{"i":[{"n":"self"}],"o":{"n":"result"}}],[11,"visit_class_set_item_pre","","",54,{"i":[{"n":"self"},{"n":"classsetitem"}],"o":{"n":"result"}}],[11,"visit_class_set_item_post","","",54,{"i":[{"n":"self"},{"n":"classsetitem"}],"o":{"n":"result"}}],[11,"visit_class_set_binary_op_in","","",54,{"i":[{"n":"self"},{"n":"classsetbinaryop"}],"o":{"n":"result"}}],[11,"fmt_group_pre","","",54,{"i":[{"n":"self"},{"n":"group"}],"o":{"n":"result"}}],[11,"fmt_group_post","","",54,{"i":[{"n":"self"},{"n":"group"}],"o":{"n":"result"}}],[11,"fmt_repetition","","",54,{"i":[{"n":"self"},{"n":"repetition"}],"o":{"n":"result"}}],[11,"fmt_repetition_range","","",54,{"i":[{"n":"self"},{"n":"repetitionrange"}],"o":{"n":"result"}}],[11,"fmt_literal","","",54,{"i":[{"n":"self"},{"n":"literal"}],"o":{"n":"result"}}],[11,"fmt_assertion","","",54,{"i":[{"n":"self"},{"n":"assertion"}],"o":{"n":"result"}}],[11,"fmt_set_flags","","",54,{"i":[{"n":"self"},{"n":"setflags"}],"o":{"n":"result"}}],[11,"fmt_flags","","",54,{"i":[{"n":"self"},{"n":"flags"}],"o":{"n":"result"}}],[11,"fmt_class_bracketed_pre","","",54,{"i":[{"n":"self"},{"n":"classbracketed"}],"o":{"n":"result"}}],[11,"fmt_class_bracketed_post","","",54,{"i":[{"n":"self"},{"n":"classbracketed"}],"o":{"n":"result"}}],[11,"fmt_class_set_binary_op_kind","","",54,{"i":[{"n":"self"},{"n":"classsetbinaryopkind"}],"o":{"n":"result"}}],[11,"fmt_class_perl","","",54,{"i":[{"n":"self"},{"n":"classperl"}],"o":{"n":"result"}}],[11,"fmt_class_ascii","","",54,{"i":[{"n":"self"},{"n":"classascii"}],"o":{"n":"result"}}],[11,"fmt_class_unicode","","",54,{"i":[{"n":"self"},{"n":"classunicode"}],"o":{"n":"result"}}],[0,"visitor","regex_syntax::ast","",null,null],[3,"HeapVisitor","regex_syntax::ast::visitor","HeapVisitor visits every item in an `Ast` recursively using constant stack size and a heap size proportional to the size of the `Ast`.",null,null],[12,"stack","","A stack of `Ast` nodes. This is roughly analogous to the call stack used in a typical recursive visitor.",55,null],[12,"stack_class","","Similar to the `Ast` stack above, but is used only for character classes. In particular, character classes embed their own mini recursive syntax.",55,null],[4,"Frame","","Represents a single stack frame while performing structural induction over an `Ast`.",null,null],[13,"Repetition","","A stack frame allocated just before descending into a repetition operator's child node.",56,null],[13,"Group","","A stack frame allocated just before descending into a group's child node.",56,null],[13,"Concat","","The stack frame used while visiting every child node of a concatenation of expressions.",56,null],[12,"head","regex_syntax::ast::visitor::Frame","The child node we are currently visiting.",56,null],[12,"tail","","The remaining child nodes to visit (which may be empty).",56,null],[13,"Alternation","regex_syntax::ast::visitor","The stack frame used while visiting every child node of an alternation of expressions.",56,null],[12,"head","regex_syntax::ast::visitor::Frame","The child node we are currently visiting.",56,null],[12,"tail","","The remaining child nodes to visit (which may be empty).",56,null],[4,"ClassFrame","regex_syntax::ast::visitor","Represents a single stack frame while performing structural induction over a character class.",null,null],[13,"Union","","The stack frame used while visiting every child node of a union of character class items.",57,null],[12,"head","regex_syntax::ast::visitor::ClassFrame","The child node we are currently visiting.",57,null],[12,"tail","","The remaining child nodes to visit (which may be empty).",57,null],[13,"Binary","regex_syntax::ast::visitor","The stack frame used while a binary class operation.",57,null],[12,"op","regex_syntax::ast::visitor::ClassFrame","",57,null],[13,"BinaryLHS","regex_syntax::ast::visitor","A stack frame allocated just before descending into a binary operator's left hand child node.",57,null],[12,"op","regex_syntax::ast::visitor::ClassFrame","",57,null],[12,"lhs","","",57,null],[12,"rhs","","",57,null],[13,"BinaryRHS","regex_syntax::ast::visitor","A stack frame allocated just before descending into a binary operator's right hand child node.",57,null],[12,"op","regex_syntax::ast::visitor::ClassFrame","",57,null],[12,"rhs","","",57,null],[4,"ClassInduct","regex_syntax::ast::visitor","A representation of the inductive step when performing structural induction over a character class.",null,null],[13,"Item","","",58,null],[13,"BinaryOp","","",58,null],[5,"visit","","Executes an implementation of `Visitor` in constant stack space.",null,{"i":[{"n":"ast"},{"n":"v"}],"o":{"n":"result"}}],[8,"Visitor","","A trait for visiting an abstract syntax tree (AST) in depth first order.",null,null],[16,"Output","","The result of visiting an AST.",59,null],[16,"Err","","An error that visiting an AST might return.",59,null],[10,"finish","","All implementors of `Visitor` must provide a `finish` method, which yields the result of visiting the AST or an error.",59,{"i":[{"n":"self"}],"o":{"n":"result"}}],[11,"start","","This method is called before beginning traversal of the AST.",59,{"i":[{"n":"self"}]}],[11,"visit_pre","","This method is called on an `Ast` before descending into child `Ast` nodes.",59,{"i":[{"n":"self"},{"n":"ast"}],"o":{"n":"result"}}],[11,"visit_post","","This method is called on an `Ast` after descending all of its child `Ast` nodes.",59,{"i":[{"n":"self"},{"n":"ast"}],"o":{"n":"result"}}],[11,"visit_alternation_in","","This method is called between child nodes of an `Alternation`.",59,{"i":[{"n":"self"}],"o":{"n":"result"}}],[11,"visit_class_set_item_pre","","This method is called on every `ClassSetItem` before descending into child nodes.",59,{"i":[{"n":"self"},{"n":"classsetitem"}],"o":{"n":"result"}}],[11,"visit_class_set_item_post","","This method is called on every `ClassSetItem` after descending into child nodes.",59,{"i":[{"n":"self"},{"n":"classsetitem"}],"o":{"n":"result"}}],[11,"visit_class_set_binary_op_pre","","This method is called on every `ClassSetBinaryOp` before descending into child nodes.",59,{"i":[{"n":"self"},{"n":"classsetbinaryop"}],"o":{"n":"result"}}],[11,"visit_class_set_binary_op_post","","This method is called on every `ClassSetBinaryOp` after descending into child nodes.",59,{"i":[{"n":"self"},{"n":"classsetbinaryop"}],"o":{"n":"result"}}],[11,"visit_class_set_binary_op_in","","This method is called between the left hand and right hand child nodes of a `ClassSetBinaryOp`.",59,{"i":[{"n":"self"},{"n":"classsetbinaryop"}],"o":{"n":"result"}}],[11,"new","","",55,{"o":{"n":"heapvisitor"}}],[11,"visit","","",55,{"i":[{"n":"self"},{"n":"ast"},{"n":"v"}],"o":{"n":"result"}}],[11,"induct","","Build a stack frame for the given AST if one is needed (which occurs if and only if there are child nodes in the AST). Otherwise, return None.",55,{"i":[{"n":"self"},{"n":"ast"},{"n":"v"}],"o":{"g":["option"],"n":"result"}}],[11,"pop","","Pops the given frame. If the frame has an additional inductive step, then return it, otherwise return `None`.",55,{"i":[{"n":"self"},{"n":"frame"}],"o":{"g":["frame"],"n":"option"}}],[11,"visit_class","","",55,{"i":[{"n":"self"},{"n":"classbracketed"},{"n":"v"}],"o":{"n":"result"}}],[11,"visit_class_pre","","Call the appropriate `Visitor` methods given an inductive step.",55,{"i":[{"n":"self"},{"n":"classinduct"},{"n":"v"}],"o":{"n":"result"}}],[11,"visit_class_post","","Call the appropriate `Visitor` methods given an inductive step.",55,{"i":[{"n":"self"},{"n":"classinduct"},{"n":"v"}],"o":{"n":"result"}}],[11,"induct_class","","Build a stack frame for the given class node if one is needed (which occurs if and only if there are child nodes). Otherwise, return None.",55,{"i":[{"n":"self"},{"n":"classinduct"}],"o":{"g":["classframe"],"n":"option"}}],[11,"pop_class","","Pops the given frame. If the frame has an additional inductive step, then return it, otherwise return `None`.",55,{"i":[{"n":"self"},{"n":"classframe"}],"o":{"g":["classframe"],"n":"option"}}],[11,"child","","Perform the next inductive step on this frame and return the next child AST node to visit.",56,{"i":[{"n":"self"}],"o":{"n":"ast"}}],[11,"child","","Perform the next inductive step on this frame and return the next child class node to visit.",57,{"i":[{"n":"self"}],"o":{"n":"classinduct"}}],[11,"from_bracketed","","",58,{"i":[{"n":"classbracketed"}],"o":{"n":"classinduct"}}],[11,"from_set","","",58,{"i":[{"n":"classset"}],"o":{"n":"classinduct"}}],[11,"fmt","","",57,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",58,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[8,"Visitor","regex_syntax::ast","A trait for visiting an abstract syntax tree (AST) in depth first order.",null,null],[16,"Output","","The result of visiting an AST.",59,null],[16,"Err","","An error that visiting an AST might return.",59,null],[10,"finish","","All implementors of `Visitor` must provide a `finish` method, which yields the result of visiting the AST or an error.",59,{"i":[{"n":"self"}],"o":{"n":"result"}}],[11,"start","regex_syntax::ast::visitor","This method is called before beginning traversal of the AST.",59,{"i":[{"n":"self"}]}],[11,"visit_pre","","This method is called on an `Ast` before descending into child `Ast` nodes.",59,{"i":[{"n":"self"},{"n":"ast"}],"o":{"n":"result"}}],[11,"visit_post","","This method is called on an `Ast` after descending all of its child `Ast` nodes.",59,{"i":[{"n":"self"},{"n":"ast"}],"o":{"n":"result"}}],[11,"visit_alternation_in","","This method is called between child nodes of an `Alternation`.",59,{"i":[{"n":"self"}],"o":{"n":"result"}}],[11,"visit_class_set_item_pre","","This method is called on every `ClassSetItem` before descending into child nodes.",59,{"i":[{"n":"self"},{"n":"classsetitem"}],"o":{"n":"result"}}],[11,"visit_class_set_item_post","","This method is called on every `ClassSetItem` after descending into child nodes.",59,{"i":[{"n":"self"},{"n":"classsetitem"}],"o":{"n":"result"}}],[11,"visit_class_set_binary_op_pre","","This method is called on every `ClassSetBinaryOp` before descending into child nodes.",59,{"i":[{"n":"self"},{"n":"classsetbinaryop"}],"o":{"n":"result"}}],[11,"visit_class_set_binary_op_post","","This method is called on every `ClassSetBinaryOp` after descending into child nodes.",59,{"i":[{"n":"self"},{"n":"classsetbinaryop"}],"o":{"n":"result"}}],[11,"visit_class_set_binary_op_in","","This method is called between the left hand and right hand child nodes of a `ClassSetBinaryOp`.",59,{"i":[{"n":"self"},{"n":"classsetbinaryop"}],"o":{"n":"result"}}],[11,"clone","regex_syntax::ast","",3,{"i":[{"n":"self"}],"o":{"n":"error"}}],[11,"fmt","","",3,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",3,null],[11,"eq","","",3,{"i":[{"n":"self"},{"n":"error"}],"o":{"n":"bool"}}],[11,"ne","","",3,{"i":[{"n":"self"},{"n":"error"}],"o":{"n":"bool"}}],[11,"kind","","Return the type of this error.",3,{"i":[{"n":"self"}],"o":{"n":"errorkind"}}],[11,"pattern","","The original pattern string in which this error occurred.",3,{"i":[{"n":"self"}],"o":{"n":"str"}}],[11,"span","","Return the span at which this error occurred.",3,{"i":[{"n":"self"}],"o":{"n":"span"}}],[11,"auxiliary_span","","Return an auxiliary span. This span exists only for some errors that benefit from being able to point to two locations in the original regular expression. For example, \"duplicate\" errors will have the main error position set to the duplicate occurrence while its auxiliary span will be set to the initial occurrence.",3,{"i":[{"n":"self"}],"o":{"g":["span"],"n":"option"}}],[11,"clone","","",26,{"i":[{"n":"self"}],"o":{"n":"errorkind"}}],[11,"fmt","","",26,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",26,null],[11,"eq","","",26,{"i":[{"n":"self"},{"n":"errorkind"}],"o":{"n":"bool"}}],[11,"ne","","",26,{"i":[{"n":"self"},{"n":"errorkind"}],"o":{"n":"bool"}}],[11,"description","","",3,{"i":[{"n":"self"}],"o":{"n":"str"}}],[11,"fmt","","",3,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",26,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",4,{"i":[{"n":"self"}],"o":{"n":"span"}}],[11,"assert_receiver_is_total_eq","","",4,null],[11,"eq","","",4,{"i":[{"n":"self"},{"n":"span"}],"o":{"n":"bool"}}],[11,"ne","","",4,{"i":[{"n":"self"},{"n":"span"}],"o":{"n":"bool"}}],[11,"fmt","","",4,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"cmp","","",4,{"i":[{"n":"self"},{"n":"span"}],"o":{"n":"ordering"}}],[11,"partial_cmp","","",4,{"i":[{"n":"self"},{"n":"span"}],"o":{"g":["ordering"],"n":"option"}}],[11,"clone","","",5,{"i":[{"n":"self"}],"o":{"n":"position"}}],[11,"assert_receiver_is_total_eq","","",5,null],[11,"eq","","",5,{"i":[{"n":"self"},{"n":"position"}],"o":{"n":"bool"}}],[11,"ne","","",5,{"i":[{"n":"self"},{"n":"position"}],"o":{"n":"bool"}}],[11,"fmt","","",5,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"cmp","","",5,{"i":[{"n":"self"},{"n":"position"}],"o":{"n":"ordering"}}],[11,"partial_cmp","","",5,{"i":[{"n":"self"},{"n":"position"}],"o":{"g":["ordering"],"n":"option"}}],[11,"new","","Create a new span with the given positions.",4,{"i":[{"n":"position"},{"n":"position"}],"o":{"n":"span"}}],[11,"splat","","Create a new span using the given position as the start and end.",4,{"i":[{"n":"position"}],"o":{"n":"span"}}],[11,"with_start","","Create a new span by replacing the starting the position with the one given.",4,{"i":[{"n":"self"},{"n":"position"}],"o":{"n":"span"}}],[11,"with_end","","Create a new span by replacing the ending the position with the one given.",4,{"i":[{"n":"self"},{"n":"position"}],"o":{"n":"span"}}],[11,"is_one_line","","Returns true if and only if this span occurs on a single line.",4,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"is_empty","","Returns true if and only if this span is empty. That is, it points to a single position in the concrete syntax of a regular expression.",4,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"new","","Create a new position with the given information.",5,{"i":[{"n":"usize"},{"n":"usize"},{"n":"usize"}],"o":{"n":"position"}}],[11,"clone","","",6,{"i":[{"n":"self"}],"o":{"n":"withcomments"}}],[11,"fmt","","",6,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",6,null],[11,"eq","","",6,{"i":[{"n":"self"},{"n":"withcomments"}],"o":{"n":"bool"}}],[11,"ne","","",6,{"i":[{"n":"self"},{"n":"withcomments"}],"o":{"n":"bool"}}],[11,"clone","","",7,{"i":[{"n":"self"}],"o":{"n":"comment"}}],[11,"fmt","","",7,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",7,null],[11,"eq","","",7,{"i":[{"n":"self"},{"n":"comment"}],"o":{"n":"bool"}}],[11,"ne","","",7,{"i":[{"n":"self"},{"n":"comment"}],"o":{"n":"bool"}}],[11,"clone","","",27,{"i":[{"n":"self"}],"o":{"n":"ast"}}],[11,"fmt","","",27,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",27,null],[11,"eq","","",27,{"i":[{"n":"self"},{"n":"ast"}],"o":{"n":"bool"}}],[11,"ne","","",27,{"i":[{"n":"self"},{"n":"ast"}],"o":{"n":"bool"}}],[11,"span","","Return the span of this abstract syntax tree.",27,{"i":[{"n":"self"}],"o":{"n":"span"}}],[11,"is_empty","","Return true if and only if this Ast is empty.",27,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"has_subexprs","","Returns true if and only if this AST has any (including possibly empty) subexpressions.",27,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"fmt","","",27,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",8,{"i":[{"n":"self"}],"o":{"n":"alternation"}}],[11,"fmt","","",8,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",8,null],[11,"eq","","",8,{"i":[{"n":"self"},{"n":"alternation"}],"o":{"n":"bool"}}],[11,"ne","","",8,{"i":[{"n":"self"},{"n":"alternation"}],"o":{"n":"bool"}}],[11,"into_ast","","Return this alternation as an AST.",8,{"i":[{"n":"self"}],"o":{"n":"ast"}}],[11,"clone","","",9,{"i":[{"n":"self"}],"o":{"n":"concat"}}],[11,"fmt","","",9,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",9,null],[11,"eq","","",9,{"i":[{"n":"self"},{"n":"concat"}],"o":{"n":"bool"}}],[11,"ne","","",9,{"i":[{"n":"self"},{"n":"concat"}],"o":{"n":"bool"}}],[11,"into_ast","","Return this concatenation as an AST.",9,{"i":[{"n":"self"}],"o":{"n":"ast"}}],[11,"clone","","",10,{"i":[{"n":"self"}],"o":{"n":"literal"}}],[11,"fmt","","",10,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",10,null],[11,"eq","","",10,{"i":[{"n":"self"},{"n":"literal"}],"o":{"n":"bool"}}],[11,"ne","","",10,{"i":[{"n":"self"},{"n":"literal"}],"o":{"n":"bool"}}],[11,"byte","","If this literal was written as a `\\x` hex escape, then this returns the corresponding byte value. Otherwise, this returns `None`.",10,{"i":[{"n":"self"}],"o":{"g":["u8"],"n":"option"}}],[11,"clone","","",28,{"i":[{"n":"self"}],"o":{"n":"literalkind"}}],[11,"fmt","","",28,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",28,null],[11,"eq","","",28,{"i":[{"n":"self"},{"n":"literalkind"}],"o":{"n":"bool"}}],[11,"ne","","",28,{"i":[{"n":"self"},{"n":"literalkind"}],"o":{"n":"bool"}}],[11,"clone","","",29,{"i":[{"n":"self"}],"o":{"n":"specialliteralkind"}}],[11,"fmt","","",29,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",29,null],[11,"eq","","",29,{"i":[{"n":"self"},{"n":"specialliteralkind"}],"o":{"n":"bool"}}],[11,"clone","","",30,{"i":[{"n":"self"}],"o":{"n":"hexliteralkind"}}],[11,"fmt","","",30,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",30,null],[11,"eq","","",30,{"i":[{"n":"self"},{"n":"hexliteralkind"}],"o":{"n":"bool"}}],[11,"digits","","The number of digits that must be used with this literal form when used without brackets. When used with brackets, there is no restriction on the number of digits.",30,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"clone","","",31,{"i":[{"n":"self"}],"o":{"n":"class"}}],[11,"fmt","","",31,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",31,null],[11,"eq","","",31,{"i":[{"n":"self"},{"n":"class"}],"o":{"n":"bool"}}],[11,"ne","","",31,{"i":[{"n":"self"},{"n":"class"}],"o":{"n":"bool"}}],[11,"span","","Return the span of this character class.",31,{"i":[{"n":"self"}],"o":{"n":"span"}}],[11,"clone","","",11,{"i":[{"n":"self"}],"o":{"n":"classperl"}}],[11,"fmt","","",11,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",11,null],[11,"eq","","",11,{"i":[{"n":"self"},{"n":"classperl"}],"o":{"n":"bool"}}],[11,"ne","","",11,{"i":[{"n":"self"},{"n":"classperl"}],"o":{"n":"bool"}}],[11,"clone","","",32,{"i":[{"n":"self"}],"o":{"n":"classperlkind"}}],[11,"fmt","","",32,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",32,null],[11,"eq","","",32,{"i":[{"n":"self"},{"n":"classperlkind"}],"o":{"n":"bool"}}],[11,"clone","","",12,{"i":[{"n":"self"}],"o":{"n":"classascii"}}],[11,"fmt","","",12,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",12,null],[11,"eq","","",12,{"i":[{"n":"self"},{"n":"classascii"}],"o":{"n":"bool"}}],[11,"ne","","",12,{"i":[{"n":"self"},{"n":"classascii"}],"o":{"n":"bool"}}],[11,"clone","","",33,{"i":[{"n":"self"}],"o":{"n":"classasciikind"}}],[11,"fmt","","",33,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",33,null],[11,"eq","","",33,{"i":[{"n":"self"},{"n":"classasciikind"}],"o":{"n":"bool"}}],[11,"from_name","","Return the corresponding ClassAsciiKind variant for the given name.",33,{"i":[{"n":"str"}],"o":{"g":["classasciikind"],"n":"option"}}],[11,"clone","","",13,{"i":[{"n":"self"}],"o":{"n":"classunicode"}}],[11,"fmt","","",13,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",13,null],[11,"eq","","",13,{"i":[{"n":"self"},{"n":"classunicode"}],"o":{"n":"bool"}}],[11,"ne","","",13,{"i":[{"n":"self"},{"n":"classunicode"}],"o":{"n":"bool"}}],[11,"is_negated","","Returns true if this class has been negated.",13,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"clone","","",34,{"i":[{"n":"self"}],"o":{"n":"classunicodekind"}}],[11,"fmt","","",34,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",34,null],[11,"eq","","",34,{"i":[{"n":"self"},{"n":"classunicodekind"}],"o":{"n":"bool"}}],[11,"ne","","",34,{"i":[{"n":"self"},{"n":"classunicodekind"}],"o":{"n":"bool"}}],[11,"clone","","",35,{"i":[{"n":"self"}],"o":{"n":"classunicodeopkind"}}],[11,"fmt","","",35,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",35,null],[11,"eq","","",35,{"i":[{"n":"self"},{"n":"classunicodeopkind"}],"o":{"n":"bool"}}],[11,"is_equal","","Whether the op is an equality op or not.",35,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"clone","","",14,{"i":[{"n":"self"}],"o":{"n":"classbracketed"}}],[11,"fmt","","",14,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",14,null],[11,"eq","","",14,{"i":[{"n":"self"},{"n":"classbracketed"}],"o":{"n":"bool"}}],[11,"ne","","",14,{"i":[{"n":"self"},{"n":"classbracketed"}],"o":{"n":"bool"}}],[11,"clone","","",36,{"i":[{"n":"self"}],"o":{"n":"classset"}}],[11,"fmt","","",36,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",36,null],[11,"eq","","",36,{"i":[{"n":"self"},{"n":"classset"}],"o":{"n":"bool"}}],[11,"ne","","",36,{"i":[{"n":"self"},{"n":"classset"}],"o":{"n":"bool"}}],[11,"union","","Build a set from a union.",36,{"i":[{"n":"classsetunion"}],"o":{"n":"classset"}}],[11,"span","","Return the span of this character class set.",36,{"i":[{"n":"self"}],"o":{"n":"span"}}],[11,"is_empty","","Return true if and only if this class set is empty.",36,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"clone","","",37,{"i":[{"n":"self"}],"o":{"n":"classsetitem"}}],[11,"fmt","","",37,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",37,null],[11,"eq","","",37,{"i":[{"n":"self"},{"n":"classsetitem"}],"o":{"n":"bool"}}],[11,"ne","","",37,{"i":[{"n":"self"},{"n":"classsetitem"}],"o":{"n":"bool"}}],[11,"span","","Return the span of this character class set item.",37,{"i":[{"n":"self"}],"o":{"n":"span"}}],[11,"clone","","",15,{"i":[{"n":"self"}],"o":{"n":"classsetrange"}}],[11,"fmt","","",15,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",15,null],[11,"eq","","",15,{"i":[{"n":"self"},{"n":"classsetrange"}],"o":{"n":"bool"}}],[11,"ne","","",15,{"i":[{"n":"self"},{"n":"classsetrange"}],"o":{"n":"bool"}}],[11,"is_valid","","Returns true if and only if this character class range is valid.",15,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"clone","","",16,{"i":[{"n":"self"}],"o":{"n":"classsetunion"}}],[11,"fmt","","",16,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",16,null],[11,"eq","","",16,{"i":[{"n":"self"},{"n":"classsetunion"}],"o":{"n":"bool"}}],[11,"ne","","",16,{"i":[{"n":"self"},{"n":"classsetunion"}],"o":{"n":"bool"}}],[11,"push","","Push a new item in this union.",16,{"i":[{"n":"self"},{"n":"classsetitem"}]}],[11,"into_item","","Return this union as a character class set item.",16,{"i":[{"n":"self"}],"o":{"n":"classsetitem"}}],[11,"clone","","",17,{"i":[{"n":"self"}],"o":{"n":"classsetbinaryop"}}],[11,"fmt","","",17,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",17,null],[11,"eq","","",17,{"i":[{"n":"self"},{"n":"classsetbinaryop"}],"o":{"n":"bool"}}],[11,"ne","","",17,{"i":[{"n":"self"},{"n":"classsetbinaryop"}],"o":{"n":"bool"}}],[11,"clone","","",38,{"i":[{"n":"self"}],"o":{"n":"classsetbinaryopkind"}}],[11,"fmt","","",38,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",38,null],[11,"eq","","",38,{"i":[{"n":"self"},{"n":"classsetbinaryopkind"}],"o":{"n":"bool"}}],[11,"clone","","",18,{"i":[{"n":"self"}],"o":{"n":"assertion"}}],[11,"fmt","","",18,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",18,null],[11,"eq","","",18,{"i":[{"n":"self"},{"n":"assertion"}],"o":{"n":"bool"}}],[11,"ne","","",18,{"i":[{"n":"self"},{"n":"assertion"}],"o":{"n":"bool"}}],[11,"clone","","",39,{"i":[{"n":"self"}],"o":{"n":"assertionkind"}}],[11,"fmt","","",39,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",39,null],[11,"eq","","",39,{"i":[{"n":"self"},{"n":"assertionkind"}],"o":{"n":"bool"}}],[11,"clone","","",19,{"i":[{"n":"self"}],"o":{"n":"repetition"}}],[11,"fmt","","",19,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",19,null],[11,"eq","","",19,{"i":[{"n":"self"},{"n":"repetition"}],"o":{"n":"bool"}}],[11,"ne","","",19,{"i":[{"n":"self"},{"n":"repetition"}],"o":{"n":"bool"}}],[11,"clone","","",20,{"i":[{"n":"self"}],"o":{"n":"repetitionop"}}],[11,"fmt","","",20,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",20,null],[11,"eq","","",20,{"i":[{"n":"self"},{"n":"repetitionop"}],"o":{"n":"bool"}}],[11,"ne","","",20,{"i":[{"n":"self"},{"n":"repetitionop"}],"o":{"n":"bool"}}],[11,"clone","","",40,{"i":[{"n":"self"}],"o":{"n":"repetitionkind"}}],[11,"fmt","","",40,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",40,null],[11,"eq","","",40,{"i":[{"n":"self"},{"n":"repetitionkind"}],"o":{"n":"bool"}}],[11,"ne","","",40,{"i":[{"n":"self"},{"n":"repetitionkind"}],"o":{"n":"bool"}}],[11,"clone","","",41,{"i":[{"n":"self"}],"o":{"n":"repetitionrange"}}],[11,"fmt","","",41,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",41,null],[11,"eq","","",41,{"i":[{"n":"self"},{"n":"repetitionrange"}],"o":{"n":"bool"}}],[11,"ne","","",41,{"i":[{"n":"self"},{"n":"repetitionrange"}],"o":{"n":"bool"}}],[11,"is_valid","","Returns true if and only if this repetition range is valid.",41,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"clone","","",21,{"i":[{"n":"self"}],"o":{"n":"group"}}],[11,"fmt","","",21,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",21,null],[11,"eq","","",21,{"i":[{"n":"self"},{"n":"group"}],"o":{"n":"bool"}}],[11,"ne","","",21,{"i":[{"n":"self"},{"n":"group"}],"o":{"n":"bool"}}],[11,"flags","","If this group is non-capturing, then this returns the (possibly empty) set of flags. Otherwise, `None` is returned.",21,{"i":[{"n":"self"}],"o":{"g":["flags"],"n":"option"}}],[11,"is_capturing","","Returns true if and only if this group is capturing.",21,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"capture_index","","Returns the capture index of this group, if this is a capturing group.",21,{"i":[{"n":"self"}],"o":{"g":["u32"],"n":"option"}}],[11,"clone","","",42,{"i":[{"n":"self"}],"o":{"n":"groupkind"}}],[11,"fmt","","",42,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",42,null],[11,"eq","","",42,{"i":[{"n":"self"},{"n":"groupkind"}],"o":{"n":"bool"}}],[11,"ne","","",42,{"i":[{"n":"self"},{"n":"groupkind"}],"o":{"n":"bool"}}],[11,"clone","","",22,{"i":[{"n":"self"}],"o":{"n":"capturename"}}],[11,"fmt","","",22,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",22,null],[11,"eq","","",22,{"i":[{"n":"self"},{"n":"capturename"}],"o":{"n":"bool"}}],[11,"ne","","",22,{"i":[{"n":"self"},{"n":"capturename"}],"o":{"n":"bool"}}],[11,"clone","","",23,{"i":[{"n":"self"}],"o":{"n":"setflags"}}],[11,"fmt","","",23,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",23,null],[11,"eq","","",23,{"i":[{"n":"self"},{"n":"setflags"}],"o":{"n":"bool"}}],[11,"ne","","",23,{"i":[{"n":"self"},{"n":"setflags"}],"o":{"n":"bool"}}],[11,"clone","","",24,{"i":[{"n":"self"}],"o":{"n":"flags"}}],[11,"fmt","","",24,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",24,null],[11,"eq","","",24,{"i":[{"n":"self"},{"n":"flags"}],"o":{"n":"bool"}}],[11,"ne","","",24,{"i":[{"n":"self"},{"n":"flags"}],"o":{"n":"bool"}}],[11,"add_item","","Add the given item to this sequence of flags.",24,{"i":[{"n":"self"},{"n":"flagsitem"}],"o":{"g":["usize"],"n":"option"}}],[11,"flag_state","","Returns the state of the given flag in this set.",24,{"i":[{"n":"self"},{"n":"flag"}],"o":{"g":["bool"],"n":"option"}}],[11,"clone","","",25,{"i":[{"n":"self"}],"o":{"n":"flagsitem"}}],[11,"fmt","","",25,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",25,null],[11,"eq","","",25,{"i":[{"n":"self"},{"n":"flagsitem"}],"o":{"n":"bool"}}],[11,"ne","","",25,{"i":[{"n":"self"},{"n":"flagsitem"}],"o":{"n":"bool"}}],[11,"clone","","",43,{"i":[{"n":"self"}],"o":{"n":"flagsitemkind"}}],[11,"fmt","","",43,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",43,null],[11,"eq","","",43,{"i":[{"n":"self"},{"n":"flagsitemkind"}],"o":{"n":"bool"}}],[11,"ne","","",43,{"i":[{"n":"self"},{"n":"flagsitemkind"}],"o":{"n":"bool"}}],[11,"is_negation","","Returns true if and only if this item is a negation operator.",43,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"clone","","",44,{"i":[{"n":"self"}],"o":{"n":"flag"}}],[11,"fmt","","",44,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",44,null],[11,"eq","","",44,{"i":[{"n":"self"},{"n":"flag"}],"o":{"n":"bool"}}],[11,"drop","","",27,{"i":[{"n":"self"}]}],[11,"drop","","",36,{"i":[{"n":"self"}]}],[0,"either","regex_syntax","",null,null],[4,"Either","regex_syntax::either","A simple binary sum type.",null,null],[13,"Left","","",60,null],[13,"Right","","",60,null],[11,"clone","","",60,{"i":[{"n":"self"}],"o":{"n":"either"}}],[11,"fmt","","",60,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",60,null],[11,"eq","","",60,{"i":[{"n":"self"},{"n":"either"}],"o":{"n":"bool"}}],[11,"ne","","",60,{"i":[{"n":"self"},{"n":"either"}],"o":{"n":"bool"}}],[0,"error","regex_syntax","",null,null],[3,"Formatter","regex_syntax::error","A helper type for formatting nice error messages.",null,null],[12,"pattern","","The original regex pattern in which the error occurred.",61,null],[12,"err","","The error kind. It must impl fmt::Display.",61,null],[12,"span","","The primary span of the error.",61,null],[12,"aux_span","","An auxiliary and optional span, in case the error needs to point to two locations (e.g., when reporting a duplicate capture group name).",61,null],[3,"Spans","","This type represents an arbitrary number of error spans in a way that makes it convenient to notate the regex pattern. (\"Notate\" means \"point out exactly where the error occurred in the regex pattern.\")",null,null],[12,"pattern","","The original regex pattern string.",62,null],[12,"line_number_width","","The total width that should be used for line numbers. The width is used for left padding the line numbers for alignment.",62,null],[12,"by_line","","All error spans that occur on a single line. This sequence always has length equivalent to the number of lines in `pattern`, where the index of the sequence represents a line number, starting at `0`. The spans in each line are sorted in ascending order.",62,null],[12,"multi_line","","All error spans that occur over one or more lines. That is, the start and end position of the span have different line numbers. The spans are sorted in ascending order.",62,null],[4,"Error","","This error type encompasses any error that can be returned by this crate.",null,null],[13,"Parse","","An error that occurred while translating concrete syntax into abstract syntax (AST).",2,null],[13,"Translate","","An error that occurred while translating abstract syntax into a high level intermediate representation (HIR).",2,null],[13,"__Nonexhaustive","","Hints that destructuring should not be exhaustive.",2,null],[5,"repeat_char","","",null,{"i":[{"n":"char"},{"n":"usize"}],"o":{"n":"string"}}],[6,"Result","","A type alias for dealing with errors returned by this crate.",null,null],[11,"clone","regex_syntax","",2,{"i":[{"n":"self"}],"o":{"n":"error"}}],[11,"fmt","","",2,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",2,null],[11,"eq","","",2,{"i":[{"n":"self"},{"n":"error"}],"o":{"n":"bool"}}],[11,"ne","","",2,{"i":[{"n":"self"},{"n":"error"}],"o":{"n":"bool"}}],[11,"from","","",2,{"i":[{"n":"error"}],"o":{"n":"error"}}],[11,"from","","",2,{"i":[{"n":"error"}],"o":{"n":"error"}}],[11,"description","","",2,{"i":[{"n":"self"}],"o":{"n":"str"}}],[11,"fmt","","",2,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","regex_syntax::error","",61,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"from","","",61,{"i":[{"n":"error"}],"o":{"n":"self"}}],[11,"from","","",61,{"i":[{"n":"error"}],"o":{"n":"self"}}],[11,"fmt","","",61,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"from_formatter","","Build a sequence of spans from a formatter.",62,{"i":[{"n":"formatter"}],"o":{"n":"spans"}}],[11,"add","","Add the given span to this sequence, putting it in the right place.",62,{"i":[{"n":"self"},{"n":"span"}]}],[11,"notate","","Notate the pattern string with carents (`^`) pointing at each span location. This only applies to spans that occur within a single line.",62,{"i":[{"n":"self"}],"o":{"n":"string"}}],[11,"notate_line","","Return notes for the line indexed at `i` (zero-based). If there are no spans for the given line, then `None` is returned. Otherwise, an appropriately space padded string with correctly positioned `^` is returned, accounting for line numbers.",62,{"i":[{"n":"self"},{"n":"usize"}],"o":{"g":["string"],"n":"option"}}],[11,"left_pad_line_number","","Left pad the given line number with spaces such that it is aligned with other line numbers.",62,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"string"}}],[11,"line_number_padding","","Return the line number padding beginning at the start of each line of the pattern.",62,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[0,"hir","regex_syntax","Defines a high-level intermediate representation for regular expressions.",null,null],[3,"Error","regex_syntax::hir","An error that can occur while translating an `Ast` to a `Hir`.",null,null],[12,"kind","","The kind of error.",63,null],[12,"pattern","","The original pattern that the translator's Ast was parsed from. Every span in an error is a valid range into this string.",63,null],[12,"span","","The span of this error, derived from the Ast given to the translator.",63,null],[3,"Hir","","A high-level intermediate representation (HIR) for a regular expression.",null,null],[12,"kind","","The underlying HIR kind.",64,null],[12,"info","","Analysis info about this HIR, computed during construction.",64,null],[3,"ClassUnicode","","A set of characters represented by Unicode scalar values.",null,null],[12,"set","","",65,null],[3,"ClassUnicodeIter","","An iterator over all ranges in a Unicode character class.",null,null],[12,"0","","",66,null],[3,"ClassUnicodeRange","","A single range of characters represented by Unicode scalar values.",null,null],[12,"start","","",67,null],[12,"end","","",67,null],[3,"ClassBytes","","A set of characters represented by arbitrary bytes (where one byte corresponds to one character).",null,null],[12,"set","","",68,null],[3,"ClassBytesIter","","An iterator over all ranges in a byte character class.",null,null],[12,"0","","",69,null],[3,"ClassBytesRange","","A single range of characters represented by arbitrary bytes.",null,null],[12,"start","","",70,null],[12,"end","","",70,null],[3,"Group","","The high-level intermediate representation for a group.",null,null],[12,"kind","","The kind of this group. If it is a capturing group, then the kind contains the capture group index (and the name, if it is a named group).",71,null],[12,"hir","","The expression inside the capturing group, which may be empty.",71,null],[3,"Repetition","","The high-level intermediate representation of a repetition operator.",null,null],[12,"kind","","The kind of this repetition operator.",72,null],[12,"greedy","","Whether this repetition operator is greedy or not. A greedy operator will match as much as it can. A non-greedy operator will match as little as it can.",72,null],[12,"hir","","The expression being repeated.",72,null],[3,"HirInfo","","A type that documents various attributes of an HIR expression.",null,null],[12,"bools","","Represent yes/no questions by a bitfield to conserve space, since this is included in every HIR expression.",73,null],[4,"ErrorKind","","The type of an error that occurred while building an `Hir`.",null,null],[13,"UnicodeNotAllowed","","This error occurs when a Unicode feature is used when Unicode support is disabled. For example `(?-u:\\pL)` would trigger this error.",74,null],[13,"InvalidUtf8","","This error occurs when translating a pattern that could match a byte sequence that isn't UTF-8 and `allow_invalid_utf8` was disabled.",74,null],[13,"UnicodePropertyNotFound","","This occurs when an unrecognized Unicode property name could not be found.",74,null],[13,"UnicodePropertyValueNotFound","","This occurs when an unrecognized Unicode property value could not be found.",74,null],[13,"EmptyClassNotAllowed","","This occurs when the translator attempts to construct a character class that is empty.",74,null],[13,"__Nonexhaustive","","Hints that destructuring should not be exhaustive.",74,null],[4,"HirKind","","The kind of an arbitrary `Hir` expression.",null,null],[13,"Empty","","The empty regular expression, which matches everything, including the empty string.",75,null],[13,"Literal","","A single literal character that matches exactly this character.",75,null],[13,"Class","","A single character class that matches any of the characters in the class. A class can either consist of Unicode scalar values as characters, or it can use bytes.",75,null],[13,"Anchor","","An anchor assertion. An anchor assertion match always has zero length.",75,null],[13,"WordBoundary","","A word boundary assertion, which may or may not be Unicode aware. A word boundary assertion match always has zero length.",75,null],[13,"Repetition","","A repetition operation applied to a child expression.",75,null],[13,"Group","","A possibly capturing group, which contains a child expression.",75,null],[13,"Concat","","A concatenation of expressions. A concatenation always has at least two child expressions.",75,null],[13,"Alternation","","An alternation of expressions. An alternation always has at least two child expressions.",75,null],[4,"Literal","","The high-level intermediate representation of a literal.",null,null],[13,"Unicode","","A single character represented by a Unicode scalar value.",76,null],[13,"Byte","","A single character represented by an arbitrary byte.",76,null],[4,"Class","","The high-level intermediate representation of a character class.",null,null],[13,"Unicode","","A set of characters represented by Unicode scalar values.",77,null],[13,"Bytes","","A set of characters represented by arbitrary bytes (one byte per character).",77,null],[4,"Anchor","","The high-level intermediate representation for an anchor assertion.",null,null],[13,"StartLine","","Match the beginning of a line or the beginning of text. Specifically, this matches at the starting position of the input, or at the position immediately following a `\\n` character.",78,null],[13,"EndLine","","Match the end of a line or the end of text. Specifically, this matches at the end position of the input, or at the position immediately preceding a `\\n` character.",78,null],[13,"StartText","","Match the beginning of text. Specifically, this matches at the starting position of the input.",78,null],[13,"EndText","","Match the end of text. Specifically, this matches at the ending position of the input.",78,null],[4,"WordBoundary","","The high-level intermediate representation for a word-boundary assertion.",null,null],[13,"Unicode","","Match a Unicode-aware word boundary. That is, this matches a position where the left adjacent character and right adjacent character correspond to a word and non-word or a non-word and word character.",79,null],[13,"UnicodeNegate","","Match a Unicode-aware negation of a word boundary.",79,null],[13,"Ascii","","Match an ASCII-only word boundary. That is, this matches a position where the left adjacent character and right adjacent character correspond to a word and non-word or a non-word and word character.",79,null],[13,"AsciiNegate","","Match an ASCII-only negation of a word boundary.",79,null],[4,"GroupKind","","The kind of group.",null,null],[13,"CaptureIndex","","A normal unnamed capturing group.",80,null],[13,"CaptureName","","A named capturing group.",80,null],[12,"name","regex_syntax::hir::GroupKind","The name of the group.",80,null],[12,"index","","The capture index of the group.",80,null],[13,"NonCapturing","regex_syntax::hir","A non-capturing group.",80,null],[4,"RepetitionKind","","The kind of a repetition operator.",null,null],[13,"ZeroOrOne","","Matches a sub-expression zero or one times.",81,null],[13,"ZeroOrMore","","Matches a sub-expression zero or more times.",81,null],[13,"OneOrMore","","Matches a sub-expression one or more times.",81,null],[13,"Range","","Matches a sub-expression within a bounded range of times.",81,null],[4,"RepetitionRange","","The kind of a counted repetition operator.",null,null],[13,"Exactly","","Matches a sub-expression exactly this many times.",82,null],[13,"AtLeast","","Matches a sub-expression at least this many times.",82,null],[13,"Bounded","","Matches a sub-expression at least `m` times and at most `n` times.",82,null],[5,"visit","","Executes an implementation of `Visitor` in constant stack space.",null,{"i":[{"n":"hir"},{"n":"v"}],"o":{"n":"result"}}],[0,"interval","","",null,null],[3,"IntervalSet","regex_syntax::hir::interval","",null,null],[12,"ranges","","",83,null],[3,"IntervalSetIter","","An iterator over intervals.",null,null],[12,"0","","",84,null],[8,"Interval","","",null,null],[16,"Bound","","",85,null],[10,"lower","","",85,null],[10,"upper","","",85,null],[10,"set_lower","","",85,null],[10,"set_upper","","",85,null],[10,"case_fold_simple","","",85,{"i":[{"n":"self"},{"n":"vec"}]}],[11,"create","","Create a new interval.",85,null],[11,"union","","Union the given overlapping range into this range.",85,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"option"}}],[11,"intersect","","Intersect this range with the given range and return the result.",85,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"option"}}],[11,"difference","","Subtract the given range from this range and return the resulting ranges.",85,null],[11,"symmetric_difference","","Compute the symmetric difference the given range from this range. This returns the union of the two ranges minus its intersection.",85,null],[11,"is_contiguous","","Returns true if and only if the two ranges are contiguous. Two ranges are contiguous if and only if the ranges are either overlapping or adjacent.",85,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"bool"}}],[11,"is_intersection_empty","","Returns true if and only if the intersection of this range and the other range is empty.",85,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"bool"}}],[11,"is_subset","","Returns true if and only if this range is a subset of the other range.",85,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"bool"}}],[8,"Bound","","",null,null],[10,"min_value","","",86,{"o":{"n":"self"}}],[10,"max_value","","",86,{"o":{"n":"self"}}],[10,"as_u32","","",86,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[10,"increment","","",86,{"i":[{"n":"self"}],"o":{"n":"self"}}],[10,"decrement","","",86,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"clone","","",83,{"i":[{"n":"self"}],"o":{"n":"intervalset"}}],[11,"fmt","","",83,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",83,null],[11,"eq","","",83,{"i":[{"n":"self"},{"n":"intervalset"}],"o":{"n":"bool"}}],[11,"ne","","",83,{"i":[{"n":"self"},{"n":"intervalset"}],"o":{"n":"bool"}}],[11,"new","","Create a new set from a sequence of intervals. Each interval is specified as a pair of bounds, where both bounds are inclusive.",83,{"i":[{"n":"t"}],"o":{"n":"intervalset"}}],[11,"push","","Add a new interval to this set.",83,{"i":[{"n":"self"},{"n":"i"}]}],[11,"iter","","Return an iterator over all intervals in this set.",83,{"i":[{"n":"self"}],"o":{"n":"intervalsetiter"}}],[11,"intervals","","Return an immutable slice of intervals in this set.",83,null],[11,"case_fold_simple","","Expand this interval set such that it contains all case folded characters. For example, if this class consists of the range `a-z`, then applying case folding will result in the class containing both the ranges `a-z` and `A-Z`.",83,{"i":[{"n":"self"}]}],[11,"union","","Union this set with the given set, in place.",83,{"i":[{"n":"self"},{"n":"intervalset"}]}],[11,"intersect","","Intersect this set with the given set, in place.",83,{"i":[{"n":"self"},{"n":"intervalset"}]}],[11,"difference","","Subtract the given set from this set, in place.",83,{"i":[{"n":"self"},{"n":"intervalset"}]}],[11,"symmetric_difference","","Compute the symmetric difference of the two sets, in place.",83,{"i":[{"n":"self"},{"n":"intervalset"}]}],[11,"negate","","Negate this interval set.",83,{"i":[{"n":"self"}]}],[11,"canonicalize","","Converts this set into a canonical ordering.",83,{"i":[{"n":"self"}]}],[11,"is_canonical","","Returns true if and only if this class is in a canonical ordering.",83,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"fmt","","",84,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",84,{"i":[{"n":"self"}],"o":{"n":"option"}}],[0,"literal","regex_syntax::hir","Provides routines for extracting literal prefixes and suffixes from an `Hir`.",null,null],[3,"Literals","regex_syntax::hir::literal","A set of literal byte strings extracted from a regular expression.",null,null],[12,"lits","","",87,null],[12,"limit_size","","",87,null],[12,"limit_class","","",87,null],[3,"Literal","","A single member of a set of literals extracted from a regular expression.",null,null],[12,"v","","",88,null],[12,"cut","","",88,null],[5,"prefixes","","",null,{"i":[{"n":"hir"},{"n":"literals"}]}],[5,"suffixes","","",null,{"i":[{"n":"hir"},{"n":"literals"}]}],[5,"repeat_zero_or_one_literals","","",null,{"i":[{"n":"hir"},{"n":"literals"},{"n":"f"}]}],[5,"repeat_zero_or_more_literals","","",null,{"i":[{"n":"hir"},{"n":"literals"},{"n":"f"}]}],[5,"repeat_one_or_more_literals","","",null,{"i":[{"n":"hir"},{"n":"literals"},{"n":"f"}]}],[5,"repeat_range_literals","","",null,{"i":[{"n":"hir"},{"n":"u32"},{"g":["u32"],"n":"option"},{"n":"bool"},{"n":"literals"},{"n":"f"}]}],[5,"alternate_literals","","",null,null],[5,"position","","",null,null],[5,"escape_unicode","","",null,null],[5,"escape_bytes","","",null,null],[5,"escape_byte","","",null,{"i":[{"n":"u8"}],"o":{"n":"string"}}],[5,"cls_char_count","","",null,{"i":[{"n":"classunicode"}],"o":{"n":"usize"}}],[5,"cls_byte_count","","",null,{"i":[{"n":"classbytes"}],"o":{"n":"usize"}}],[11,"clone","","",87,{"i":[{"n":"self"}],"o":{"n":"literals"}}],[11,"assert_receiver_is_total_eq","","",87,null],[11,"eq","","",87,{"i":[{"n":"self"},{"n":"literals"}],"o":{"n":"bool"}}],[11,"ne","","",87,{"i":[{"n":"self"},{"n":"literals"}],"o":{"n":"bool"}}],[11,"clone","","",88,{"i":[{"n":"self"}],"o":{"n":"literal"}}],[11,"assert_receiver_is_total_eq","","",88,null],[11,"cmp","","",88,{"i":[{"n":"self"},{"n":"literal"}],"o":{"n":"ordering"}}],[11,"empty","","Returns a new empty set of literals using default limits.",87,{"o":{"n":"literals"}}],[11,"prefixes","","Returns a set of literal prefixes extracted from the given `Hir`.",87,{"i":[{"n":"hir"}],"o":{"n":"literals"}}],[11,"suffixes","","Returns a set of literal suffixes extracted from the given `Hir`.",87,{"i":[{"n":"hir"}],"o":{"n":"literals"}}],[11,"limit_size","","Get the approximate size limit (in bytes) of this set.",87,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"set_limit_size","","Set the approximate size limit (in bytes) of this set.",87,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"literals"}}],[11,"limit_class","","Get the character class size limit for this set.",87,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"set_limit_class","","Limits the size of character(or byte) classes considered.",87,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"literals"}}],[11,"literals","","Returns the set of literals as a slice. Its order is unspecified.",87,null],[11,"min_len","","Returns the length of the smallest literal.",87,{"i":[{"n":"self"}],"o":{"g":["usize"],"n":"option"}}],[11,"all_complete","","Returns true if all members in this set are complete.",87,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"any_complete","","Returns true if any member in this set is complete.",87,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"contains_empty","","Returns true if this set contains an empty literal.",87,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"is_empty","","Returns true if this set is empty or if all of its members is empty.",87,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"to_empty","","Returns a new empty set of literals using this set's limits.",87,{"i":[{"n":"self"}],"o":{"n":"literals"}}],[11,"longest_common_prefix","","Returns the longest common prefix of all members in this set.",87,null],[11,"longest_common_suffix","","Returns the longest common suffix of all members in this set.",87,null],[11,"trim_suffix","","Returns a new set of literals with the given number of bytes trimmed from the suffix of each literal.",87,{"i":[{"n":"self"},{"n":"usize"}],"o":{"g":["literals"],"n":"option"}}],[11,"unambiguous_prefixes","","Returns a new set of prefixes of this set of literals that are guaranteed to be unambiguous.",87,{"i":[{"n":"self"}],"o":{"n":"literals"}}],[11,"unambiguous_suffixes","","Returns a new set of suffixes of this set of literals that are guaranteed to be unambiguous.",87,{"i":[{"n":"self"}],"o":{"n":"literals"}}],[11,"union_prefixes","","Unions the prefixes from the given expression to this set.",87,{"i":[{"n":"self"},{"n":"hir"}],"o":{"n":"bool"}}],[11,"union_suffixes","","Unions the suffixes from the given expression to this set.",87,{"i":[{"n":"self"},{"n":"hir"}],"o":{"n":"bool"}}],[11,"union","","Unions this set with another set.",87,{"i":[{"n":"self"},{"n":"literals"}],"o":{"n":"bool"}}],[11,"cross_product","","Extends this set with another set.",87,{"i":[{"n":"self"},{"n":"literals"}],"o":{"n":"bool"}}],[11,"cross_add","","Extends each literal in this set with the bytes given.",87,null],[11,"add","","Adds the given literal to this set.",87,{"i":[{"n":"self"},{"n":"literal"}],"o":{"n":"bool"}}],[11,"add_char_class","","Extends each literal in this set with the character class given.",87,{"i":[{"n":"self"},{"n":"classunicode"}],"o":{"n":"bool"}}],[11,"add_char_class_reverse","","Extends each literal in this set with the character class given, writing the bytes of each character in reverse.",87,{"i":[{"n":"self"},{"n":"classunicode"}],"o":{"n":"bool"}}],[11,"_add_char_class","","",87,{"i":[{"n":"self"},{"n":"classunicode"},{"n":"bool"}],"o":{"n":"bool"}}],[11,"add_byte_class","","Extends each literal in this set with the byte class given.",87,{"i":[{"n":"self"},{"n":"classbytes"}],"o":{"n":"bool"}}],[11,"cut","","Cuts every member of this set. When a member is cut, it can never be extended.",87,{"i":[{"n":"self"}]}],[11,"reverse","","Reverses all members in place.",87,{"i":[{"n":"self"}]}],[11,"clear","","Clears this set of all members.",87,{"i":[{"n":"self"}]}],[11,"remove_complete","","Pops all complete literals out of this set.",87,{"i":[{"n":"self"}],"o":{"g":["literal"],"n":"vec"}}],[11,"num_bytes","","Returns the total number of bytes in this set.",87,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"class_exceeds_limits","","Returns true if a character class with the given size would cause this set to exceed its limits.",87,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"bool"}}],[11,"fmt","","",87,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","Returns a new complete literal with the bytes given.",88,{"i":[{"g":["u8"],"n":"vec"}],"o":{"n":"literal"}}],[11,"empty","","Returns a new complete empty literal.",88,{"o":{"n":"literal"}}],[11,"is_cut","","Returns true if this literal was \"cut.\"",88,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"cut","","Cuts this literal.",88,{"i":[{"n":"self"}]}],[11,"eq","","",88,{"i":[{"n":"self"},{"n":"literal"}],"o":{"n":"bool"}}],[11,"partial_cmp","","",88,{"i":[{"n":"self"},{"n":"literal"}],"o":{"g":["ordering"],"n":"option"}}],[11,"fmt","","",88,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"as_ref","","",88,null],[11,"deref","","",88,{"i":[{"n":"self"}],"o":{"n":"vec"}}],[11,"deref_mut","","",88,{"i":[{"n":"self"}],"o":{"n":"vec"}}],[0,"print","regex_syntax::hir","This module provides a regular expression printer for `Hir`.",null,null],[3,"PrinterBuilder","regex_syntax::hir::print","A builder for constructing a printer.",null,null],[12,"_priv","","",89,null],[3,"Printer","","A printer for a regular expression's high-level intermediate representation.",null,null],[12,"_priv","","",90,null],[3,"Writer","","",null,null],[12,"printer","","",91,null],[12,"wtr","","",91,null],[11,"clone","","",89,{"i":[{"n":"self"}],"o":{"n":"printerbuilder"}}],[11,"fmt","","",89,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"default","","",89,{"o":{"n":"printerbuilder"}}],[11,"new","","",89,{"o":{"n":"printerbuilder"}}],[11,"build","","",89,{"i":[{"n":"self"}],"o":{"n":"printer"}}],[11,"fmt","","",90,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","Create a new printer.",90,{"o":{"n":"printer"}}],[11,"print","","Print the given `Ast` to the given writer. The writer must implement `fmt::Write`. Typical implementations of `fmt::Write` that can be used here are a `fmt::Formatter` (which is available in `fmt::Display` implementations) or a `&mut String`.",90,{"i":[{"n":"self"},{"n":"hir"},{"n":"w"}],"o":{"n":"result"}}],[11,"fmt","","",91,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"finish","","",91,{"i":[{"n":"self"}],"o":{"n":"result"}}],[11,"visit_pre","","",91,{"i":[{"n":"self"},{"n":"hir"}],"o":{"n":"result"}}],[11,"visit_post","","",91,{"i":[{"n":"self"},{"n":"hir"}],"o":{"n":"result"}}],[11,"visit_alternation_in","","",91,{"i":[{"n":"self"}],"o":{"n":"result"}}],[11,"write_literal_char","","",91,{"i":[{"n":"self"},{"n":"char"}],"o":{"n":"result"}}],[11,"write_literal_byte","","",91,{"i":[{"n":"self"},{"n":"u8"}],"o":{"n":"result"}}],[11,"write_literal_class_byte","","",91,{"i":[{"n":"self"},{"n":"u8"}],"o":{"n":"result"}}],[0,"translate","regex_syntax::hir","Defines a translator that converts an `Ast` to an `Hir`.",null,null],[3,"TranslatorBuilder","regex_syntax::hir::translate","A builder for constructing an AST->HIR translator.",null,null],[12,"allow_invalid_utf8","","",92,null],[12,"flags","","",92,null],[3,"Translator","","A translator maps abstract syntax to a high level intermediate representation.",null,null],[12,"stack","","Our call stack, but on the heap.",93,null],[12,"flags","","The current flag settings.",93,null],[12,"allow_invalid_utf8","","Whether we're allowed to produce HIR that can match arbitrary bytes.",93,null],[3,"TranslatorI","","The internal implementation of a translator.",null,null],[12,"trans","","",94,null],[12,"pattern","","",94,null],[3,"Flags","","A translator's representation of a regular expression's flags at any given moment in time.",null,null],[12,"case_insensitive","","",95,null],[12,"multi_line","","",95,null],[12,"dot_matches_new_line","","",95,null],[12,"swap_greed","","",95,null],[12,"unicode","","",95,null],[4,"HirFrame","","An HirFrame is a single stack frame, represented explicitly, which is created for each item in the Ast that we traverse.",null,null],[13,"Expr","","An arbitrary HIR expression. These get pushed whenever we hit a base case in the Ast. They get popped after an inductive (i.e., recursive) step is complete.",96,null],[13,"ClassUnicode","","A Unicode character class. This frame is mutated as we descend into the Ast of a character class (which is itself its own mini recursive structure).",96,null],[13,"ClassBytes","","A byte-oriented character class. This frame is mutated as we descend into the Ast of a character class (which is itself its own mini recursive structure).",96,null],[13,"Group","","This is pushed on to the stack upon first seeing any kind of group, indicated by parentheses (including non-capturing groups). It is popped upon leaving a group.",96,null],[12,"old_flags","regex_syntax::hir::translate::HirFrame","The old active flags, if any, when this group was opened.",96,null],[13,"Concat","regex_syntax::hir::translate","This is pushed whenever a concatenation is observed. After visiting every sub-expression in the concatenation, the translator's stack is popped until it sees a Concat frame.",96,null],[13,"Alternation","","This is pushed whenever an alternation is observed. After visiting every sub-expression in the alternation, the translator's stack is popped until it sees an Alternation frame.",96,null],[5,"hir_ascii_class_bytes","","",null,{"i":[{"n":"classasciikind"}],"o":{"n":"classbytes"}}],[5,"ascii_class","","",null,null],[6,"Result","","",null,null],[11,"clone","","",92,{"i":[{"n":"self"}],"o":{"n":"translatorbuilder"}}],[11,"fmt","","",92,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"default","","",92,{"o":{"n":"translatorbuilder"}}],[11,"new","","Create a new translator builder with a default c onfiguration.",92,{"o":{"n":"translatorbuilder"}}],[11,"build","","Build a translator using the current configuration.",92,{"i":[{"n":"self"}],"o":{"n":"translator"}}],[11,"allow_invalid_utf8","","When enabled, translation will permit the construction of a regular expression that may match invalid UTF-8.",92,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"translatorbuilder"}}],[11,"case_insensitive","","Enable or disable the case insensitive flag (`i`) by default.",92,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"translatorbuilder"}}],[11,"multi_line","","Enable or disable the multi-line matching flag (`m`) by default.",92,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"translatorbuilder"}}],[11,"dot_matches_new_line","","Enable or disable the \"dot matches any character\" flag (`s`) by default.",92,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"translatorbuilder"}}],[11,"swap_greed","","Enable or disable the \"swap greed\" flag (`U`) by default.",92,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"translatorbuilder"}}],[11,"unicode","","Enable or disable the Unicode flag (`u`) by default.",92,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"translatorbuilder"}}],[11,"clone","","",93,{"i":[{"n":"self"}],"o":{"n":"translator"}}],[11,"fmt","","",93,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","Create a new translator using the default configuration.",93,{"o":{"n":"translator"}}],[11,"translate","","Translate the given abstract syntax tree (AST) into a high level intermediate representation (HIR).",93,{"i":[{"n":"self"},{"n":"str"},{"n":"ast"}],"o":{"g":["hir","error"],"n":"result"}}],[11,"clone","","",96,{"i":[{"n":"self"}],"o":{"n":"hirframe"}}],[11,"fmt","","",96,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"unwrap_expr","","Assert that the current stack frame is an Hir expression and return it.",96,{"i":[{"n":"self"}],"o":{"n":"hir"}}],[11,"unwrap_class_unicode","","Assert that the current stack frame is a Unicode class expression and return it.",96,{"i":[{"n":"self"}],"o":{"n":"classunicode"}}],[11,"unwrap_class_bytes","","Assert that the current stack frame is a byte class expression and return it.",96,{"i":[{"n":"self"}],"o":{"n":"classbytes"}}],[11,"unwrap_group","","Assert that the current stack frame is a group indicator and return its corresponding flags (the flags that were active at the time the group was entered) if they exist.",96,{"i":[{"n":"self"}],"o":{"g":["flags"],"n":"option"}}],[11,"finish","","",94,{"i":[{"n":"self"}],"o":{"g":["hir","error"],"n":"result"}}],[11,"visit_pre","","",94,{"i":[{"n":"self"},{"n":"ast"}],"o":{"g":["error"],"n":"result"}}],[11,"visit_post","","",94,{"i":[{"n":"self"},{"n":"ast"}],"o":{"g":["error"],"n":"result"}}],[11,"visit_class_set_item_pre","","",94,{"i":[{"n":"self"},{"n":"classsetitem"}],"o":{"g":["error"],"n":"result"}}],[11,"visit_class_set_item_post","","",94,{"i":[{"n":"self"},{"n":"classsetitem"}],"o":{"g":["error"],"n":"result"}}],[11,"visit_class_set_binary_op_pre","","",94,{"i":[{"n":"self"},{"n":"classsetbinaryop"}],"o":{"g":["error"],"n":"result"}}],[11,"visit_class_set_binary_op_in","","",94,{"i":[{"n":"self"},{"n":"classsetbinaryop"}],"o":{"g":["error"],"n":"result"}}],[11,"visit_class_set_binary_op_post","","",94,{"i":[{"n":"self"},{"n":"classsetbinaryop"}],"o":{"g":["error"],"n":"result"}}],[11,"clone","","",94,{"i":[{"n":"self"}],"o":{"n":"translatori"}}],[11,"fmt","","",94,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","Build a new internal translator.",94,{"i":[{"n":"translator"},{"n":"str"}],"o":{"n":"translatori"}}],[11,"trans","","Return a reference to the underlying translator.",94,{"i":[{"n":"self"}],"o":{"n":"translator"}}],[11,"push","","Push the given frame on to the call stack.",94,{"i":[{"n":"self"},{"n":"hirframe"}]}],[11,"pop","","Pop the top of the call stack. If the call stack is empty, return None.",94,{"i":[{"n":"self"}],"o":{"g":["hirframe"],"n":"option"}}],[11,"error","","Create a new error with the given span and error type.",94,{"i":[{"n":"self"},{"n":"span"},{"n":"errorkind"}],"o":{"n":"error"}}],[11,"flags","","Return a copy of the active flags.",94,{"i":[{"n":"self"}],"o":{"n":"flags"}}],[11,"set_flags","","Set the flags of this translator from the flags set in the given AST. Then, return the old flags.",94,{"i":[{"n":"self"},{"n":"flags"}],"o":{"n":"flags"}}],[11,"hir_literal","","",94,{"i":[{"n":"self"},{"n":"literal"}],"o":{"g":["hir","error"],"n":"result"}}],[11,"literal_to_char","","Convert an Ast literal to its scalar representation.",94,{"i":[{"n":"self"},{"n":"literal"}],"o":{"g":["literal","error"],"n":"result"}}],[11,"hir_from_char","","",94,{"i":[{"n":"self"},{"n":"span"},{"n":"char"}],"o":{"g":["hir","error"],"n":"result"}}],[11,"hir_from_char_case_insensitive","","",94,{"i":[{"n":"self"},{"n":"span"},{"n":"char"}],"o":{"g":["hir","error"],"n":"result"}}],[11,"hir_dot","","",94,{"i":[{"n":"self"},{"n":"span"}],"o":{"g":["hir","error"],"n":"result"}}],[11,"hir_assertion","","",94,{"i":[{"n":"self"},{"n":"assertion"}],"o":{"g":["hir","error"],"n":"result"}}],[11,"hir_group","","",94,{"i":[{"n":"self"},{"n":"group"},{"n":"hir"}],"o":{"n":"hir"}}],[11,"hir_repetition","","",94,{"i":[{"n":"self"},{"n":"repetition"},{"n":"hir"}],"o":{"n":"hir"}}],[11,"hir_unicode_class","","",94,{"i":[{"n":"self"},{"n":"classunicode"}],"o":{"g":["classunicode","error"],"n":"result"}}],[11,"hir_perl_unicode_class","","",94,{"i":[{"n":"self"},{"n":"classperl"}],"o":{"n":"classunicode"}}],[11,"hir_perl_byte_class","","",94,{"i":[{"n":"self"},{"n":"classperl"}],"o":{"n":"classbytes"}}],[11,"unicode_fold_and_negate","","",94,{"i":[{"n":"self"},{"n":"bool"},{"n":"classunicode"}]}],[11,"bytes_fold_and_negate","","",94,{"i":[{"n":"self"},{"n":"span"},{"n":"bool"},{"n":"classbytes"}],"o":{"g":["error"],"n":"result"}}],[11,"class_literal_byte","","Return a scalar byte value suitable for use as a literal in a byte character class.",94,{"i":[{"n":"self"},{"n":"literal"}],"o":{"g":["u8","error"],"n":"result"}}],[11,"clone","","",95,{"i":[{"n":"self"}],"o":{"n":"flags"}}],[11,"fmt","","",95,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"default","","",95,{"o":{"n":"flags"}}],[11,"from_ast","","",95,{"i":[{"n":"flags"}],"o":{"n":"flags"}}],[11,"merge","","",95,{"i":[{"n":"self"},{"n":"flags"}]}],[11,"case_insensitive","","",95,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"multi_line","","",95,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"dot_matches_new_line","","",95,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"swap_greed","","",95,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"unicode","","",95,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[0,"visitor","regex_syntax::hir","",null,null],[3,"HeapVisitor","regex_syntax::hir::visitor","HeapVisitor visits every item in an `Hir` recursively using constant stack size and a heap size proportional to the size of the `Hir`.",null,null],[12,"stack","","A stack of `Hir` nodes. This is roughly analogous to the call stack used in a typical recursive visitor.",97,null],[4,"Frame","","Represents a single stack frame while performing structural induction over an `Hir`.",null,null],[13,"Repetition","","A stack frame allocated just before descending into a repetition operator's child node.",98,null],[13,"Group","","A stack frame allocated just before descending into a group's child node.",98,null],[13,"Concat","","The stack frame used while visiting every child node of a concatenation of expressions.",98,null],[12,"head","regex_syntax::hir::visitor::Frame","The child node we are currently visiting.",98,null],[12,"tail","","The remaining child nodes to visit (which may be empty).",98,null],[13,"Alternation","regex_syntax::hir::visitor","The stack frame used while visiting every child node of an alternation of expressions.",98,null],[12,"head","regex_syntax::hir::visitor::Frame","The child node we are currently visiting.",98,null],[12,"tail","","The remaining child nodes to visit (which may be empty).",98,null],[5,"visit","regex_syntax::hir::visitor","Executes an implementation of `Visitor` in constant stack space.",null,{"i":[{"n":"hir"},{"n":"v"}],"o":{"n":"result"}}],[8,"Visitor","","A trait for visiting the high-level IR (HIR) in depth first order.",null,null],[16,"Output","","The result of visiting an HIR.",99,null],[16,"Err","","An error that visiting an HIR might return.",99,null],[10,"finish","","All implementors of `Visitor` must provide a `finish` method, which yields the result of visiting the HIR or an error.",99,{"i":[{"n":"self"}],"o":{"n":"result"}}],[11,"start","","This method is called before beginning traversal of the HIR.",99,{"i":[{"n":"self"}]}],[11,"visit_pre","","This method is called on an `Hir` before descending into child `Hir` nodes.",99,{"i":[{"n":"self"},{"n":"hir"}],"o":{"n":"result"}}],[11,"visit_post","","This method is called on an `Hir` after descending all of its child `Hir` nodes.",99,{"i":[{"n":"self"},{"n":"hir"}],"o":{"n":"result"}}],[11,"visit_alternation_in","","This method is called between child nodes of an alternation.",99,{"i":[{"n":"self"}],"o":{"n":"result"}}],[11,"new","","",97,{"o":{"n":"heapvisitor"}}],[11,"visit","","",97,{"i":[{"n":"self"},{"n":"hir"},{"n":"v"}],"o":{"n":"result"}}],[11,"induct","","Build a stack frame for the given HIR if one is needed (which occurs if and only if there are child nodes in the HIR). Otherwise, return None.",97,{"i":[{"n":"self"},{"n":"hir"}],"o":{"g":["frame"],"n":"option"}}],[11,"pop","","Pops the given frame. If the frame has an additional inductive step, then return it, otherwise return `None`.",97,{"i":[{"n":"self"},{"n":"frame"}],"o":{"g":["frame"],"n":"option"}}],[11,"child","","Perform the next inductive step on this frame and return the next child HIR node to visit.",98,{"i":[{"n":"self"}],"o":{"n":"hir"}}],[8,"Visitor","regex_syntax::hir","A trait for visiting the high-level IR (HIR) in depth first order.",null,null],[16,"Output","","The result of visiting an HIR.",99,null],[16,"Err","","An error that visiting an HIR might return.",99,null],[10,"finish","","All implementors of `Visitor` must provide a `finish` method, which yields the result of visiting the HIR or an error.",99,{"i":[{"n":"self"}],"o":{"n":"result"}}],[11,"start","regex_syntax::hir::visitor","This method is called before beginning traversal of the HIR.",99,{"i":[{"n":"self"}]}],[11,"visit_pre","","This method is called on an `Hir` before descending into child `Hir` nodes.",99,{"i":[{"n":"self"},{"n":"hir"}],"o":{"n":"result"}}],[11,"visit_post","","This method is called on an `Hir` after descending all of its child `Hir` nodes.",99,{"i":[{"n":"self"},{"n":"hir"}],"o":{"n":"result"}}],[11,"visit_alternation_in","","This method is called between child nodes of an alternation.",99,{"i":[{"n":"self"}],"o":{"n":"result"}}],[11,"clone","regex_syntax::hir","",63,{"i":[{"n":"self"}],"o":{"n":"error"}}],[11,"fmt","","",63,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",63,null],[11,"eq","","",63,{"i":[{"n":"self"},{"n":"error"}],"o":{"n":"bool"}}],[11,"ne","","",63,{"i":[{"n":"self"},{"n":"error"}],"o":{"n":"bool"}}],[11,"kind","","Return the type of this error.",63,{"i":[{"n":"self"}],"o":{"n":"errorkind"}}],[11,"pattern","","The original pattern string in which this error occurred.",63,{"i":[{"n":"self"}],"o":{"n":"str"}}],[11,"span","","Return the span at which this error occurred.",63,{"i":[{"n":"self"}],"o":{"n":"span"}}],[11,"clone","","",74,{"i":[{"n":"self"}],"o":{"n":"errorkind"}}],[11,"fmt","","",74,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",74,null],[11,"eq","","",74,{"i":[{"n":"self"},{"n":"errorkind"}],"o":{"n":"bool"}}],[11,"description","","",74,{"i":[{"n":"self"}],"o":{"n":"str"}}],[11,"description","","",63,{"i":[{"n":"self"}],"o":{"n":"str"}}],[11,"fmt","","",63,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",74,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",64,{"i":[{"n":"self"}],"o":{"n":"hir"}}],[11,"fmt","","",64,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",64,null],[11,"eq","","",64,{"i":[{"n":"self"},{"n":"hir"}],"o":{"n":"bool"}}],[11,"ne","","",64,{"i":[{"n":"self"},{"n":"hir"}],"o":{"n":"bool"}}],[11,"clone","","",75,{"i":[{"n":"self"}],"o":{"n":"hirkind"}}],[11,"fmt","","",75,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",75,null],[11,"eq","","",75,{"i":[{"n":"self"},{"n":"hirkind"}],"o":{"n":"bool"}}],[11,"ne","","",75,{"i":[{"n":"self"},{"n":"hirkind"}],"o":{"n":"bool"}}],[11,"kind","","Returns a reference to the underlying HIR kind.",64,{"i":[{"n":"self"}],"o":{"n":"hirkind"}}],[11,"into_kind","","Consumes ownership of this HIR expression and returns its underlying `HirKind`.",64,{"i":[{"n":"self"}],"o":{"n":"hirkind"}}],[11,"empty","","Returns an empty HIR expression.",64,{"o":{"n":"hir"}}],[11,"literal","","Creates a literal HIR expression.",64,{"i":[{"n":"literal"}],"o":{"n":"hir"}}],[11,"class","","Creates a class HIR expression.",64,{"i":[{"n":"class"}],"o":{"n":"hir"}}],[11,"anchor","","Creates an anchor assertion HIR expression.",64,{"i":[{"n":"anchor"}],"o":{"n":"hir"}}],[11,"word_boundary","","Creates a word boundary assertion HIR expression.",64,{"i":[{"n":"wordboundary"}],"o":{"n":"hir"}}],[11,"repetition","","Creates a repetition HIR expression.",64,{"i":[{"n":"repetition"}],"o":{"n":"hir"}}],[11,"group","","Creates a group HIR expression.",64,{"i":[{"n":"group"}],"o":{"n":"hir"}}],[11,"concat","","Returns the concatenation of the given expressions.",64,{"i":[{"g":["hir"],"n":"vec"}],"o":{"n":"hir"}}],[11,"alternation","","Returns the alternation of the given expressions.",64,{"i":[{"g":["hir"],"n":"vec"}],"o":{"n":"hir"}}],[11,"dot","","Build an HIR expression for `.`.",64,{"i":[{"n":"bool"}],"o":{"n":"hir"}}],[11,"any","","Build an HIR expression for `(?s).`.",64,{"i":[{"n":"bool"}],"o":{"n":"hir"}}],[11,"is_always_utf8","","Return true if and only if this HIR will always match valid UTF-8.",64,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"is_all_assertions","","Returns true if and only if this entire HIR expression is made up of zero-width assertions.",64,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"is_anchored_start","","Return true if and only if this HIR is required to match from the beginning of text. This includes expressions like `^foo`, `^(foo|bar)`, `^foo|^bar` but not `^foo|bar`.",64,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"is_anchored_end","","Return true if and only if this HIR is required to match at the end of text. This includes expressions like `foo$`, `(foo|bar)$`, `foo$|bar$` but not `foo$|bar`.",64,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"is_any_anchored_start","","Return true if and only if this HIR contains any sub-expression that is required to match at the beginning of text. Specifically, this returns true if the `^` symbol (when multiline mode is disabled) or the `\\A` escape appear anywhere in the regex.",64,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"is_any_anchored_end","","Return true if and only if this HIR contains any sub-expression that is required to match at the end of text. Specifically, this returns true if the `$` symbol (when multiline mode is disabled) or the `\\z` escape appear anywhere in the regex.",64,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"is_match_empty","","Return true if and only if the empty string is part of the language matched by this regular expression.",64,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"is_empty","","Return true if and only if this HIR is the empty regular expression.",75,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"has_subexprs","","Returns true if and only if this kind has any (including possibly empty) subexpressions.",75,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"fmt","","",64,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",76,{"i":[{"n":"self"}],"o":{"n":"literal"}}],[11,"fmt","","",76,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",76,null],[11,"eq","","",76,{"i":[{"n":"self"},{"n":"literal"}],"o":{"n":"bool"}}],[11,"ne","","",76,{"i":[{"n":"self"},{"n":"literal"}],"o":{"n":"bool"}}],[11,"is_unicode","","Returns true if and only if this literal corresponds to a Unicode scalar value.",76,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"clone","","",77,{"i":[{"n":"self"}],"o":{"n":"class"}}],[11,"fmt","","",77,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",77,null],[11,"eq","","",77,{"i":[{"n":"self"},{"n":"class"}],"o":{"n":"bool"}}],[11,"ne","","",77,{"i":[{"n":"self"},{"n":"class"}],"o":{"n":"bool"}}],[11,"case_fold_simple","","Apply Unicode simple case folding to this character class, in place. The character class will be expanded to include all simple case folded character variants.",77,{"i":[{"n":"self"}]}],[11,"negate","","Negate this character class in place.",77,{"i":[{"n":"self"}]}],[11,"is_always_utf8","","Returns true if and only if this character class will only ever match valid UTF-8.",77,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"clone","","",65,{"i":[{"n":"self"}],"o":{"n":"classunicode"}}],[11,"fmt","","",65,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",65,null],[11,"eq","","",65,{"i":[{"n":"self"},{"n":"classunicode"}],"o":{"n":"bool"}}],[11,"ne","","",65,{"i":[{"n":"self"},{"n":"classunicode"}],"o":{"n":"bool"}}],[11,"new","","Create a new class from a sequence of ranges.",65,{"i":[{"n":"i"}],"o":{"n":"classunicode"}}],[11,"empty","","Create a new class with no ranges.",65,{"o":{"n":"classunicode"}}],[11,"push","","Add a new range to this set.",65,{"i":[{"n":"self"},{"n":"classunicoderange"}]}],[11,"iter","","Return an iterator over all ranges in this class.",65,{"i":[{"n":"self"}],"o":{"n":"classunicodeiter"}}],[11,"ranges","","Return the underlying ranges as a slice.",65,null],[11,"case_fold_simple","","Expand this character class such that it contains all case folded characters, according to Unicode's \"simple\" mapping. For example, if this class consists of the range `a-z`, then applying case folding will result in the class containing both the ranges `a-z` and `A-Z`.",65,{"i":[{"n":"self"}]}],[11,"negate","","Negate this character class.",65,{"i":[{"n":"self"}]}],[11,"union","","Union this character class with the given character class, in place.",65,{"i":[{"n":"self"},{"n":"classunicode"}]}],[11,"intersect","","Intersect this character class with the given character class, in place.",65,{"i":[{"n":"self"},{"n":"classunicode"}]}],[11,"difference","","Subtract the given character class from this character class, in place.",65,{"i":[{"n":"self"},{"n":"classunicode"}]}],[11,"symmetric_difference","","Compute the symmetric difference of the given character classes, in place.",65,{"i":[{"n":"self"},{"n":"classunicode"}]}],[11,"fmt","","",66,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",66,{"i":[{"n":"self"}],"o":{"g":["classunicoderange"],"n":"option"}}],[11,"clone","","",67,{"i":[{"n":"self"}],"o":{"n":"classunicoderange"}}],[11,"default","","",67,{"o":{"n":"classunicoderange"}}],[11,"assert_receiver_is_total_eq","","",67,null],[11,"eq","","",67,{"i":[{"n":"self"},{"n":"classunicoderange"}],"o":{"n":"bool"}}],[11,"ne","","",67,{"i":[{"n":"self"},{"n":"classunicoderange"}],"o":{"n":"bool"}}],[11,"partial_cmp","","",67,{"i":[{"n":"self"},{"n":"classunicoderange"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",67,{"i":[{"n":"self"},{"n":"classunicoderange"}],"o":{"n":"bool"}}],[11,"le","","",67,{"i":[{"n":"self"},{"n":"classunicoderange"}],"o":{"n":"bool"}}],[11,"gt","","",67,{"i":[{"n":"self"},{"n":"classunicoderange"}],"o":{"n":"bool"}}],[11,"ge","","",67,{"i":[{"n":"self"},{"n":"classunicoderange"}],"o":{"n":"bool"}}],[11,"cmp","","",67,{"i":[{"n":"self"},{"n":"classunicoderange"}],"o":{"n":"ordering"}}],[11,"fmt","","",67,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"lower","","",67,{"i":[{"n":"self"}],"o":{"n":"char"}}],[11,"upper","","",67,{"i":[{"n":"self"}],"o":{"n":"char"}}],[11,"set_lower","","",67,{"i":[{"n":"self"},{"n":"char"}]}],[11,"set_upper","","",67,{"i":[{"n":"self"},{"n":"char"}]}],[11,"case_fold_simple","","Apply simple case folding to this Unicode scalar value range.",67,{"i":[{"n":"self"},{"n":"vec"}]}],[11,"new","","Create a new Unicode scalar value range for a character class.",67,{"i":[{"n":"char"},{"n":"char"}],"o":{"n":"classunicoderange"}}],[11,"start","","Return the start of this range.",67,{"i":[{"n":"self"}],"o":{"n":"char"}}],[11,"end","","Return the end of this range.",67,{"i":[{"n":"self"}],"o":{"n":"char"}}],[11,"clone","","",68,{"i":[{"n":"self"}],"o":{"n":"classbytes"}}],[11,"fmt","","",68,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",68,null],[11,"eq","","",68,{"i":[{"n":"self"},{"n":"classbytes"}],"o":{"n":"bool"}}],[11,"ne","","",68,{"i":[{"n":"self"},{"n":"classbytes"}],"o":{"n":"bool"}}],[11,"new","","Create a new class from a sequence of ranges.",68,{"i":[{"n":"i"}],"o":{"n":"classbytes"}}],[11,"empty","","Create a new class with no ranges.",68,{"o":{"n":"classbytes"}}],[11,"push","","Add a new range to this set.",68,{"i":[{"n":"self"},{"n":"classbytesrange"}]}],[11,"iter","","Return an iterator over all ranges in this class.",68,{"i":[{"n":"self"}],"o":{"n":"classbytesiter"}}],[11,"ranges","","Return the underlying ranges as a slice.",68,null],[11,"case_fold_simple","","Expand this character class such that it contains all case folded characters. For example, if this class consists of the range `a-z`, then applying case folding will result in the class containing both the ranges `a-z` and `A-Z`.",68,{"i":[{"n":"self"}]}],[11,"negate","","Negate this byte class.",68,{"i":[{"n":"self"}]}],[11,"union","","Union this byte class with the given byte class, in place.",68,{"i":[{"n":"self"},{"n":"classbytes"}]}],[11,"intersect","","Intersect this byte class with the given byte class, in place.",68,{"i":[{"n":"self"},{"n":"classbytes"}]}],[11,"difference","","Subtract the given byte class from this byte class, in place.",68,{"i":[{"n":"self"},{"n":"classbytes"}]}],[11,"symmetric_difference","","Compute the symmetric difference of the given byte classes, in place.",68,{"i":[{"n":"self"},{"n":"classbytes"}]}],[11,"is_all_ascii","","Returns true if and only if this character class will either match nothing or only ASCII bytes. Stated differently, this returns false if and only if this class contains a non-ASCII byte.",68,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"fmt","","",69,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",69,{"i":[{"n":"self"}],"o":{"g":["classbytesrange"],"n":"option"}}],[11,"clone","","",70,{"i":[{"n":"self"}],"o":{"n":"classbytesrange"}}],[11,"default","","",70,{"o":{"n":"classbytesrange"}}],[11,"assert_receiver_is_total_eq","","",70,null],[11,"eq","","",70,{"i":[{"n":"self"},{"n":"classbytesrange"}],"o":{"n":"bool"}}],[11,"ne","","",70,{"i":[{"n":"self"},{"n":"classbytesrange"}],"o":{"n":"bool"}}],[11,"partial_cmp","","",70,{"i":[{"n":"self"},{"n":"classbytesrange"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",70,{"i":[{"n":"self"},{"n":"classbytesrange"}],"o":{"n":"bool"}}],[11,"le","","",70,{"i":[{"n":"self"},{"n":"classbytesrange"}],"o":{"n":"bool"}}],[11,"gt","","",70,{"i":[{"n":"self"},{"n":"classbytesrange"}],"o":{"n":"bool"}}],[11,"ge","","",70,{"i":[{"n":"self"},{"n":"classbytesrange"}],"o":{"n":"bool"}}],[11,"cmp","","",70,{"i":[{"n":"self"},{"n":"classbytesrange"}],"o":{"n":"ordering"}}],[11,"lower","","",70,{"i":[{"n":"self"}],"o":{"n":"u8"}}],[11,"upper","","",70,{"i":[{"n":"self"}],"o":{"n":"u8"}}],[11,"set_lower","","",70,{"i":[{"n":"self"},{"n":"u8"}]}],[11,"set_upper","","",70,{"i":[{"n":"self"},{"n":"u8"}]}],[11,"case_fold_simple","","Apply simple case folding to this byte range. Only ASCII case mappings (for a-z) are applied.",70,{"i":[{"n":"self"},{"n":"vec"}]}],[11,"new","","Create a new byte range for a character class.",70,{"i":[{"n":"u8"},{"n":"u8"}],"o":{"n":"classbytesrange"}}],[11,"start","","Return the start of this range.",70,{"i":[{"n":"self"}],"o":{"n":"u8"}}],[11,"end","","Return the end of this range.",70,{"i":[{"n":"self"}],"o":{"n":"u8"}}],[11,"fmt","","",70,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",78,{"i":[{"n":"self"}],"o":{"n":"anchor"}}],[11,"fmt","","",78,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",78,null],[11,"eq","","",78,{"i":[{"n":"self"},{"n":"anchor"}],"o":{"n":"bool"}}],[11,"clone","","",79,{"i":[{"n":"self"}],"o":{"n":"wordboundary"}}],[11,"fmt","","",79,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",79,null],[11,"eq","","",79,{"i":[{"n":"self"},{"n":"wordboundary"}],"o":{"n":"bool"}}],[11,"is_negated","","Returns true if and only if this word boundary assertion is negated.",79,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"clone","","",71,{"i":[{"n":"self"}],"o":{"n":"group"}}],[11,"fmt","","",71,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",71,null],[11,"eq","","",71,{"i":[{"n":"self"},{"n":"group"}],"o":{"n":"bool"}}],[11,"ne","","",71,{"i":[{"n":"self"},{"n":"group"}],"o":{"n":"bool"}}],[11,"clone","","",80,{"i":[{"n":"self"}],"o":{"n":"groupkind"}}],[11,"fmt","","",80,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",80,null],[11,"eq","","",80,{"i":[{"n":"self"},{"n":"groupkind"}],"o":{"n":"bool"}}],[11,"ne","","",80,{"i":[{"n":"self"},{"n":"groupkind"}],"o":{"n":"bool"}}],[11,"clone","","",72,{"i":[{"n":"self"}],"o":{"n":"repetition"}}],[11,"fmt","","",72,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",72,null],[11,"eq","","",72,{"i":[{"n":"self"},{"n":"repetition"}],"o":{"n":"bool"}}],[11,"ne","","",72,{"i":[{"n":"self"},{"n":"repetition"}],"o":{"n":"bool"}}],[11,"is_match_empty","","Returns true if and only if this repetition operator makes it possible to match the empty string.",72,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"clone","","",81,{"i":[{"n":"self"}],"o":{"n":"repetitionkind"}}],[11,"fmt","","",81,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",81,null],[11,"eq","","",81,{"i":[{"n":"self"},{"n":"repetitionkind"}],"o":{"n":"bool"}}],[11,"ne","","",81,{"i":[{"n":"self"},{"n":"repetitionkind"}],"o":{"n":"bool"}}],[11,"clone","","",82,{"i":[{"n":"self"}],"o":{"n":"repetitionrange"}}],[11,"fmt","","",82,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",82,null],[11,"eq","","",82,{"i":[{"n":"self"},{"n":"repetitionrange"}],"o":{"n":"bool"}}],[11,"ne","","",82,{"i":[{"n":"self"},{"n":"repetitionrange"}],"o":{"n":"bool"}}],[11,"drop","","",64,{"i":[{"n":"self"}]}],[11,"clone","","",73,{"i":[{"n":"self"}],"o":{"n":"hirinfo"}}],[11,"fmt","","",73,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",73,null],[11,"eq","","",73,{"i":[{"n":"self"},{"n":"hirinfo"}],"o":{"n":"bool"}}],[11,"ne","","",73,{"i":[{"n":"self"},{"n":"hirinfo"}],"o":{"n":"bool"}}],[11,"new","","",73,{"o":{"n":"hirinfo"}}],[11,"is_always_utf8","","",73,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"set_always_utf8","","",73,{"i":[{"n":"self"},{"n":"bool"}]}],[11,"is_all_assertions","","",73,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"set_all_assertions","","",73,{"i":[{"n":"self"},{"n":"bool"}]}],[11,"is_anchored_start","","",73,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"set_anchored_start","","",73,{"i":[{"n":"self"},{"n":"bool"}]}],[11,"is_anchored_end","","",73,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"set_anchored_end","","",73,{"i":[{"n":"self"},{"n":"bool"}]}],[11,"is_any_anchored_start","","",73,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"set_any_anchored_start","","",73,{"i":[{"n":"self"},{"n":"bool"}]}],[11,"is_any_anchored_end","","",73,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"set_any_anchored_end","","",73,{"i":[{"n":"self"},{"n":"bool"}]}],[11,"is_match_empty","","",73,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"set_match_empty","","",73,{"i":[{"n":"self"},{"n":"bool"}]}],[0,"parser","regex_syntax","",null,null],[3,"ParserBuilder","regex_syntax::parser","A builder for a regular expression parser.",null,null],[12,"ast","","",1,null],[12,"hir","","",1,null],[3,"Parser","","A convenience parser for regular expressions.",null,null],[12,"ast","","",0,null],[12,"hir","","",0,null],[11,"clone","regex_syntax","",1,{"i":[{"n":"self"}],"o":{"n":"parserbuilder"}}],[11,"fmt","","",1,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"default","","",1,{"o":{"n":"parserbuilder"}}],[11,"new","","Create a new parser builder with a default configuration.",1,{"o":{"n":"parserbuilder"}}],[11,"build","","Build a parser from this configuration with the given pattern.",1,{"i":[{"n":"self"}],"o":{"n":"parser"}}],[11,"nest_limit","","Set the nesting limit for this parser.",1,{"i":[{"n":"self"},{"n":"u32"}],"o":{"n":"parserbuilder"}}],[11,"octal","","Whether to support octal syntax or not.",1,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"parserbuilder"}}],[11,"allow_invalid_utf8","","When enabled, the parser will permit the construction of a regular expression that may match invalid UTF-8.",1,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"parserbuilder"}}],[11,"ignore_whitespace","","Enable verbose mode in the regular expression.",1,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"parserbuilder"}}],[11,"case_insensitive","","Enable or disable the case insensitive flag by default.",1,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"parserbuilder"}}],[11,"multi_line","","Enable or disable the multi-line matching flag by default.",1,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"parserbuilder"}}],[11,"dot_matches_new_line","","Enable or disable the \"dot matches any character\" flag by default.",1,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"parserbuilder"}}],[11,"swap_greed","","Enable or disable the \"swap greed\" flag by default.",1,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"parserbuilder"}}],[11,"unicode","","Enable or disable the Unicode flag (`u`) by default.",1,{"i":[{"n":"self"},{"n":"bool"}],"o":{"n":"parserbuilder"}}],[11,"clone","","",0,{"i":[{"n":"self"}],"o":{"n":"parser"}}],[11,"fmt","","",0,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","Create a new parser with a default configuration.",0,{"o":{"n":"parser"}}],[11,"parse","","Parse the regular expression into a high level intermediate representation.",0,{"i":[{"n":"self"},{"n":"str"}],"o":{"g":["hir"],"n":"result"}}],[0,"unicode","","",null,null],[3,"SimpleFoldIter","regex_syntax::unicode","An iterator over a codepoint's simple case equivalence class.",null,null],[12,"0","","",100,null],[3,"AgeIter","","An iterator over Unicode Age sets. Each item corresponds to a set of codepoints that were added in a particular revision of Unicode. The iterator yields items in chronological order.",null,null],[12,"ages","","",101,null],[4,"Error","","An error that occurs when dealing with Unicode.",null,null],[13,"PropertyNotFound","","",102,null],[13,"PropertyValueNotFound","","",102,null],[4,"ClassQuery","","A query for finding a character class defined by Unicode. This supports either use of a property name directly, or lookup by property value. The former generally refers to Binary properties (see UTS#44, Table 8), but as a special exception (see UTS#18, Section 1.2) both general categories (an enumeration) and scripts (a catalog) are supported as if each of their possible values were a binary property.",null,null],[13,"OneLetter","","Return a class corresponding to a Unicode binary property, named by a single letter.",103,null],[13,"Binary","","Return a class corresponding to a Unicode binary property.",103,null],[13,"ByValue","","Return a class corresponding to all codepoints whose property (identified by `property_name`) corresponds to the given value (identified by `property_value`).",103,null],[12,"property_name","regex_syntax::unicode::ClassQuery","A property name.",103,null],[12,"property_value","","A property value.",103,null],[4,"CanonicalClassQuery","regex_syntax::unicode","Like ClassQuery, but its parameters have been canonicalized. This also differentiates binary properties from flattened general categories and scripts.",null,null],[13,"Binary","","The canonical binary property name.",104,null],[13,"GeneralCategory","","The canonical general category name.",104,null],[13,"Script","","The canonical script name.",104,null],[13,"ByValue","","An arbitrary association between property and value, both of which have been canonicalized.",104,null],[12,"property_name","regex_syntax::unicode::CanonicalClassQuery","The canonical property name.",104,null],[12,"property_value","","The canonical property value.",104,null],[5,"encode_utf8","regex_syntax::unicode","Encode the given Unicode character to `dst` as a single UTF-8 sequence.",null,null],[5,"simple_fold","","Return an iterator over the equivalence class of simple case mappings for the given codepoint. The equivalence class does not include the given codepoint.",null,{"i":[{"n":"char"}],"o":{"g":["simplefolditer","option"],"n":"result"}}],[5,"contains_simple_case_mapping","","Returns true if and only if the given (inclusive) range contains at least one Unicode scalar value that has a non-empty non-trivial simple case mapping.",null,{"i":[{"n":"char"},{"n":"char"}],"o":{"n":"bool"}}],[5,"class","","Looks up a Unicode class given a query. If one doesn't exist, then `None` is returned.",null,{"i":[{"n":"classquery"}],"o":{"g":["classunicode","error"],"n":"result"}}],[5,"hir_class","","Build a Unicode HIR class from a sequence of Unicode scalar value ranges.",null,null],[5,"canonical_prop","","",null,{"i":[{"n":"str"}],"o":{"g":["str"],"n":"option"}}],[5,"canonical_gencat","","",null,{"i":[{"n":"str"}],"o":{"g":["str"],"n":"option"}}],[5,"canonical_script","","",null,{"i":[{"n":"str"}],"o":{"g":["str"],"n":"option"}}],[5,"canonical_value","","",null,{"i":[{"n":"propertyvalues"},{"n":"str"}],"o":{"g":["str"],"n":"option"}}],[5,"normalize","","",null,{"i":[{"n":"str"}],"o":{"n":"string"}}],[5,"property_values","","",null,{"i":[{"n":"str"}],"o":{"g":["propertyvalues"],"n":"option"}}],[5,"property_set","","",null,null],[5,"ages","","",null,{"i":[{"n":"str"}],"o":{"g":["ageiter","error"],"n":"result"}}],[6,"Result","","",null,null],[11,"fmt","","",102,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",100,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",100,{"i":[{"n":"self"}],"o":{"g":["char"],"n":"option"}}],[11,"fmt","","",103,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"canonicalize","","",103,{"i":[{"n":"self"}],"o":{"g":["canonicalclassquery","error"],"n":"result"}}],[11,"canonical_binary","","",103,{"i":[{"n":"self"},{"n":"str"}],"o":{"g":["canonicalclassquery","error"],"n":"result"}}],[11,"fmt","","",104,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",101,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"next","","",101,{"i":[{"n":"self"}],"o":{"n":"option"}}],[0,"unicode_tables","regex_syntax","",null,null],[0,"age","regex_syntax::unicode_tables","",null,null],[17,"BY_NAME","regex_syntax::unicode_tables::age","",null,null],[17,"V10_0","","",null,null],[17,"V1_1","","",null,null],[17,"V2_0","","",null,null],[17,"V2_1","","",null,null],[17,"V3_0","","",null,null],[17,"V3_1","","",null,null],[17,"V3_2","","",null,null],[17,"V4_0","","",null,null],[17,"V4_1","","",null,null],[17,"V5_0","","",null,null],[17,"V5_1","","",null,null],[17,"V5_2","","",null,null],[17,"V6_0","","",null,null],[17,"V6_1","","",null,null],[17,"V6_2","","",null,null],[17,"V6_3","","",null,null],[17,"V7_0","","",null,null],[17,"V8_0","","",null,null],[17,"V9_0","","",null,null],[0,"case_folding_simple","regex_syntax::unicode_tables","",null,null],[17,"CASE_FOLDING_SIMPLE","regex_syntax::unicode_tables::case_folding_simple","",null,null],[0,"general_category","regex_syntax::unicode_tables","",null,null],[17,"BY_NAME","regex_syntax::unicode_tables::general_category","",null,null],[17,"CASED_LETTER","","",null,null],[17,"CLOSE_PUNCTUATION","","",null,null],[17,"CONNECTOR_PUNCTUATION","","",null,null],[17,"CONTROL","","",null,null],[17,"CURRENCY_SYMBOL","","",null,null],[17,"DASH_PUNCTUATION","","",null,null],[17,"DECIMAL_NUMBER","","",null,null],[17,"ENCLOSING_MARK","","",null,null],[17,"FINAL_PUNCTUATION","","",null,null],[17,"FORMAT","","",null,null],[17,"INITIAL_PUNCTUATION","","",null,null],[17,"LETTER","","",null,null],[17,"LETTER_NUMBER","","",null,null],[17,"LINE_SEPARATOR","","",null,null],[17,"LOWERCASE_LETTER","","",null,null],[17,"MARK","","",null,null],[17,"MATH_SYMBOL","","",null,null],[17,"MODIFIER_LETTER","","",null,null],[17,"MODIFIER_SYMBOL","","",null,null],[17,"NONSPACING_MARK","","",null,null],[17,"NUMBER","","",null,null],[17,"OPEN_PUNCTUATION","","",null,null],[17,"OTHER","","",null,null],[17,"OTHER_LETTER","","",null,null],[17,"OTHER_NUMBER","","",null,null],[17,"OTHER_PUNCTUATION","","",null,null],[17,"OTHER_SYMBOL","","",null,null],[17,"PARAGRAPH_SEPARATOR","","",null,null],[17,"PRIVATE_USE","","",null,null],[17,"PUNCTUATION","","",null,null],[17,"SEPARATOR","","",null,null],[17,"SPACE_SEPARATOR","","",null,null],[17,"SPACING_MARK","","",null,null],[17,"SYMBOL","","",null,null],[17,"TITLECASE_LETTER","","",null,null],[17,"UNASSIGNED","","",null,null],[17,"UPPERCASE_LETTER","","",null,null],[0,"perl_word","regex_syntax::unicode_tables","",null,null],[17,"PERL_WORD","regex_syntax::unicode_tables::perl_word","",null,null],[0,"property_bool","regex_syntax::unicode_tables","",null,null],[17,"BY_NAME","regex_syntax::unicode_tables::property_bool","",null,null],[17,"ASCII_HEX_DIGIT","","",null,null],[17,"ALPHABETIC","","",null,null],[17,"BIDI_CONTROL","","",null,null],[17,"CASE_IGNORABLE","","",null,null],[17,"CASED","","",null,null],[17,"CHANGES_WHEN_CASEFOLDED","","",null,null],[17,"CHANGES_WHEN_CASEMAPPED","","",null,null],[17,"CHANGES_WHEN_LOWERCASED","","",null,null],[17,"CHANGES_WHEN_TITLECASED","","",null,null],[17,"CHANGES_WHEN_UPPERCASED","","",null,null],[17,"DASH","","",null,null],[17,"DEFAULT_IGNORABLE_CODE_POINT","","",null,null],[17,"DEPRECATED","","",null,null],[17,"DIACRITIC","","",null,null],[17,"EXTENDER","","",null,null],[17,"GRAPHEME_BASE","","",null,null],[17,"GRAPHEME_EXTEND","","",null,null],[17,"GRAPHEME_LINK","","",null,null],[17,"HEX_DIGIT","","",null,null],[17,"HYPHEN","","",null,null],[17,"IDS_BINARY_OPERATOR","","",null,null],[17,"IDS_TRINARY_OPERATOR","","",null,null],[17,"ID_CONTINUE","","",null,null],[17,"ID_START","","",null,null],[17,"IDEOGRAPHIC","","",null,null],[17,"JOIN_CONTROL","","",null,null],[17,"LOGICAL_ORDER_EXCEPTION","","",null,null],[17,"LOWERCASE","","",null,null],[17,"MATH","","",null,null],[17,"NONCHARACTER_CODE_POINT","","",null,null],[17,"OTHER_ALPHABETIC","","",null,null],[17,"OTHER_DEFAULT_IGNORABLE_CODE_POINT","","",null,null],[17,"OTHER_GRAPHEME_EXTEND","","",null,null],[17,"OTHER_ID_CONTINUE","","",null,null],[17,"OTHER_ID_START","","",null,null],[17,"OTHER_LOWERCASE","","",null,null],[17,"OTHER_MATH","","",null,null],[17,"OTHER_UPPERCASE","","",null,null],[17,"PATTERN_SYNTAX","","",null,null],[17,"PATTERN_WHITE_SPACE","","",null,null],[17,"PREPENDED_CONCATENATION_MARK","","",null,null],[17,"QUOTATION_MARK","","",null,null],[17,"RADICAL","","",null,null],[17,"REGIONAL_INDICATOR","","",null,null],[17,"SENTENCE_TERMINAL","","",null,null],[17,"SOFT_DOTTED","","",null,null],[17,"TERMINAL_PUNCTUATION","","",null,null],[17,"UNIFIED_IDEOGRAPH","","",null,null],[17,"UPPERCASE","","",null,null],[17,"VARIATION_SELECTOR","","",null,null],[17,"WHITE_SPACE","","",null,null],[17,"XID_CONTINUE","","",null,null],[17,"XID_START","","",null,null],[0,"property_names","regex_syntax::unicode_tables","",null,null],[17,"PROPERTY_NAMES","regex_syntax::unicode_tables::property_names","",null,null],[0,"property_values","regex_syntax::unicode_tables","",null,null],[17,"PROPERTY_VALUES","regex_syntax::unicode_tables::property_values","",null,null],[0,"script_extension","regex_syntax::unicode_tables","",null,null],[17,"BY_NAME","regex_syntax::unicode_tables::script_extension","",null,null],[17,"ADLAM","","",null,null],[17,"AHOM","","",null,null],[17,"ANATOLIAN_HIEROGLYPHS","","",null,null],[17,"ARABIC","","",null,null],[17,"ARMENIAN","","",null,null],[17,"AVESTAN","","",null,null],[17,"BALINESE","","",null,null],[17,"BAMUM","","",null,null],[17,"BASSA_VAH","","",null,null],[17,"BATAK","","",null,null],[17,"BENGALI","","",null,null],[17,"BHAIKSUKI","","",null,null],[17,"BOPOMOFO","","",null,null],[17,"BRAHMI","","",null,null],[17,"BRAILLE","","",null,null],[17,"BUGINESE","","",null,null],[17,"BUHID","","",null,null],[17,"CANADIAN_ABORIGINAL","","",null,null],[17,"CARIAN","","",null,null],[17,"CAUCASIAN_ALBANIAN","","",null,null],[17,"CHAKMA","","",null,null],[17,"CHAM","","",null,null],[17,"CHEROKEE","","",null,null],[17,"COMMON","","",null,null],[17,"COPTIC","","",null,null],[17,"CUNEIFORM","","",null,null],[17,"CYPRIOT","","",null,null],[17,"CYRILLIC","","",null,null],[17,"DESERET","","",null,null],[17,"DEVANAGARI","","",null,null],[17,"DUPLOYAN","","",null,null],[17,"EGYPTIAN_HIEROGLYPHS","","",null,null],[17,"ELBASAN","","",null,null],[17,"ETHIOPIC","","",null,null],[17,"GEORGIAN","","",null,null],[17,"GLAGOLITIC","","",null,null],[17,"GOTHIC","","",null,null],[17,"GRANTHA","","",null,null],[17,"GREEK","","",null,null],[17,"GUJARATI","","",null,null],[17,"GURMUKHI","","",null,null],[17,"HAN","","",null,null],[17,"HANGUL","","",null,null],[17,"HANUNOO","","",null,null],[17,"HATRAN","","",null,null],[17,"HEBREW","","",null,null],[17,"HIRAGANA","","",null,null],[17,"IMPERIAL_ARAMAIC","","",null,null],[17,"INHERITED","","",null,null],[17,"INSCRIPTIONAL_PAHLAVI","","",null,null],[17,"INSCRIPTIONAL_PARTHIAN","","",null,null],[17,"JAVANESE","","",null,null],[17,"KAITHI","","",null,null],[17,"KANNADA","","",null,null],[17,"KATAKANA","","",null,null],[17,"KAYAH_LI","","",null,null],[17,"KHAROSHTHI","","",null,null],[17,"KHMER","","",null,null],[17,"KHOJKI","","",null,null],[17,"KHUDAWADI","","",null,null],[17,"LAO","","",null,null],[17,"LATIN","","",null,null],[17,"LEPCHA","","",null,null],[17,"LIMBU","","",null,null],[17,"LINEAR_A","","",null,null],[17,"LINEAR_B","","",null,null],[17,"LISU","","",null,null],[17,"LYCIAN","","",null,null],[17,"LYDIAN","","",null,null],[17,"MAHAJANI","","",null,null],[17,"MALAYALAM","","",null,null],[17,"MANDAIC","","",null,null],[17,"MANICHAEAN","","",null,null],[17,"MARCHEN","","",null,null],[17,"MASARAM_GONDI","","",null,null],[17,"MEETEI_MAYEK","","",null,null],[17,"MENDE_KIKAKUI","","",null,null],[17,"MEROITIC_CURSIVE","","",null,null],[17,"MEROITIC_HIEROGLYPHS","","",null,null],[17,"MIAO","","",null,null],[17,"MODI","","",null,null],[17,"MONGOLIAN","","",null,null],[17,"MRO","","",null,null],[17,"MULTANI","","",null,null],[17,"MYANMAR","","",null,null],[17,"NABATAEAN","","",null,null],[17,"NEW_TAI_LUE","","",null,null],[17,"NEWA","","",null,null],[17,"NKO","","",null,null],[17,"NUSHU","","",null,null],[17,"OGHAM","","",null,null],[17,"OL_CHIKI","","",null,null],[17,"OLD_HUNGARIAN","","",null,null],[17,"OLD_ITALIC","","",null,null],[17,"OLD_NORTH_ARABIAN","","",null,null],[17,"OLD_PERMIC","","",null,null],[17,"OLD_PERSIAN","","",null,null],[17,"OLD_SOUTH_ARABIAN","","",null,null],[17,"OLD_TURKIC","","",null,null],[17,"ORIYA","","",null,null],[17,"OSAGE","","",null,null],[17,"OSMANYA","","",null,null],[17,"PAHAWH_HMONG","","",null,null],[17,"PALMYRENE","","",null,null],[17,"PAU_CIN_HAU","","",null,null],[17,"PHAGS_PA","","",null,null],[17,"PHOENICIAN","","",null,null],[17,"PSALTER_PAHLAVI","","",null,null],[17,"REJANG","","",null,null],[17,"RUNIC","","",null,null],[17,"SAMARITAN","","",null,null],[17,"SAURASHTRA","","",null,null],[17,"SHARADA","","",null,null],[17,"SHAVIAN","","",null,null],[17,"SIDDHAM","","",null,null],[17,"SIGNWRITING","","",null,null],[17,"SINHALA","","",null,null],[17,"SORA_SOMPENG","","",null,null],[17,"SOYOMBO","","",null,null],[17,"SUNDANESE","","",null,null],[17,"SYLOTI_NAGRI","","",null,null],[17,"SYRIAC","","",null,null],[17,"TAGALOG","","",null,null],[17,"TAGBANWA","","",null,null],[17,"TAI_LE","","",null,null],[17,"TAI_THAM","","",null,null],[17,"TAI_VIET","","",null,null],[17,"TAKRI","","",null,null],[17,"TAMIL","","",null,null],[17,"TANGUT","","",null,null],[17,"TELUGU","","",null,null],[17,"THAANA","","",null,null],[17,"THAI","","",null,null],[17,"TIBETAN","","",null,null],[17,"TIFINAGH","","",null,null],[17,"TIRHUTA","","",null,null],[17,"UGARITIC","","",null,null],[17,"VAI","","",null,null],[17,"WARANG_CITI","","",null,null],[17,"YI","","",null,null],[17,"ZANABAZAR_SQUARE","","",null,null],[0,"script","regex_syntax::unicode_tables","",null,null],[17,"BY_NAME","regex_syntax::unicode_tables::script","",null,null],[17,"ADLAM","","",null,null],[17,"AHOM","","",null,null],[17,"ANATOLIAN_HIEROGLYPHS","","",null,null],[17,"ARABIC","","",null,null],[17,"ARMENIAN","","",null,null],[17,"AVESTAN","","",null,null],[17,"BALINESE","","",null,null],[17,"BAMUM","","",null,null],[17,"BASSA_VAH","","",null,null],[17,"BATAK","","",null,null],[17,"BENGALI","","",null,null],[17,"BHAIKSUKI","","",null,null],[17,"BOPOMOFO","","",null,null],[17,"BRAHMI","","",null,null],[17,"BRAILLE","","",null,null],[17,"BUGINESE","","",null,null],[17,"BUHID","","",null,null],[17,"CANADIAN_ABORIGINAL","","",null,null],[17,"CARIAN","","",null,null],[17,"CAUCASIAN_ALBANIAN","","",null,null],[17,"CHAKMA","","",null,null],[17,"CHAM","","",null,null],[17,"CHEROKEE","","",null,null],[17,"COMMON","","",null,null],[17,"COPTIC","","",null,null],[17,"CUNEIFORM","","",null,null],[17,"CYPRIOT","","",null,null],[17,"CYRILLIC","","",null,null],[17,"DESERET","","",null,null],[17,"DEVANAGARI","","",null,null],[17,"DUPLOYAN","","",null,null],[17,"EGYPTIAN_HIEROGLYPHS","","",null,null],[17,"ELBASAN","","",null,null],[17,"ETHIOPIC","","",null,null],[17,"GEORGIAN","","",null,null],[17,"GLAGOLITIC","","",null,null],[17,"GOTHIC","","",null,null],[17,"GRANTHA","","",null,null],[17,"GREEK","","",null,null],[17,"GUJARATI","","",null,null],[17,"GURMUKHI","","",null,null],[17,"HAN","","",null,null],[17,"HANGUL","","",null,null],[17,"HANUNOO","","",null,null],[17,"HATRAN","","",null,null],[17,"HEBREW","","",null,null],[17,"HIRAGANA","","",null,null],[17,"IMPERIAL_ARAMAIC","","",null,null],[17,"INHERITED","","",null,null],[17,"INSCRIPTIONAL_PAHLAVI","","",null,null],[17,"INSCRIPTIONAL_PARTHIAN","","",null,null],[17,"JAVANESE","","",null,null],[17,"KAITHI","","",null,null],[17,"KANNADA","","",null,null],[17,"KATAKANA","","",null,null],[17,"KAYAH_LI","","",null,null],[17,"KHAROSHTHI","","",null,null],[17,"KHMER","","",null,null],[17,"KHOJKI","","",null,null],[17,"KHUDAWADI","","",null,null],[17,"LAO","","",null,null],[17,"LATIN","","",null,null],[17,"LEPCHA","","",null,null],[17,"LIMBU","","",null,null],[17,"LINEAR_A","","",null,null],[17,"LINEAR_B","","",null,null],[17,"LISU","","",null,null],[17,"LYCIAN","","",null,null],[17,"LYDIAN","","",null,null],[17,"MAHAJANI","","",null,null],[17,"MALAYALAM","","",null,null],[17,"MANDAIC","","",null,null],[17,"MANICHAEAN","","",null,null],[17,"MARCHEN","","",null,null],[17,"MASARAM_GONDI","","",null,null],[17,"MEETEI_MAYEK","","",null,null],[17,"MENDE_KIKAKUI","","",null,null],[17,"MEROITIC_CURSIVE","","",null,null],[17,"MEROITIC_HIEROGLYPHS","","",null,null],[17,"MIAO","","",null,null],[17,"MODI","","",null,null],[17,"MONGOLIAN","","",null,null],[17,"MRO","","",null,null],[17,"MULTANI","","",null,null],[17,"MYANMAR","","",null,null],[17,"NABATAEAN","","",null,null],[17,"NEW_TAI_LUE","","",null,null],[17,"NEWA","","",null,null],[17,"NKO","","",null,null],[17,"NUSHU","","",null,null],[17,"OGHAM","","",null,null],[17,"OL_CHIKI","","",null,null],[17,"OLD_HUNGARIAN","","",null,null],[17,"OLD_ITALIC","","",null,null],[17,"OLD_NORTH_ARABIAN","","",null,null],[17,"OLD_PERMIC","","",null,null],[17,"OLD_PERSIAN","","",null,null],[17,"OLD_SOUTH_ARABIAN","","",null,null],[17,"OLD_TURKIC","","",null,null],[17,"ORIYA","","",null,null],[17,"OSAGE","","",null,null],[17,"OSMANYA","","",null,null],[17,"PAHAWH_HMONG","","",null,null],[17,"PALMYRENE","","",null,null],[17,"PAU_CIN_HAU","","",null,null],[17,"PHAGS_PA","","",null,null],[17,"PHOENICIAN","","",null,null],[17,"PSALTER_PAHLAVI","","",null,null],[17,"REJANG","","",null,null],[17,"RUNIC","","",null,null],[17,"SAMARITAN","","",null,null],[17,"SAURASHTRA","","",null,null],[17,"SHARADA","","",null,null],[17,"SHAVIAN","","",null,null],[17,"SIDDHAM","","",null,null],[17,"SIGNWRITING","","",null,null],[17,"SINHALA","","",null,null],[17,"SORA_SOMPENG","","",null,null],[17,"SOYOMBO","","",null,null],[17,"SUNDANESE","","",null,null],[17,"SYLOTI_NAGRI","","",null,null],[17,"SYRIAC","","",null,null],[17,"TAGALOG","","",null,null],[17,"TAGBANWA","","",null,null],[17,"TAI_LE","","",null,null],[17,"TAI_THAM","","",null,null],[17,"TAI_VIET","","",null,null],[17,"TAKRI","","",null,null],[17,"TAMIL","","",null,null],[17,"TANGUT","","",null,null],[17,"TELUGU","","",null,null],[17,"THAANA","","",null,null],[17,"THAI","","",null,null],[17,"TIBETAN","","",null,null],[17,"TIFINAGH","","",null,null],[17,"TIRHUTA","","",null,null],[17,"UGARITIC","","",null,null],[17,"VAI","","",null,null],[17,"WARANG_CITI","","",null,null],[17,"YI","","",null,null],[17,"ZANABAZAR_SQUARE","","",null,null],[6,"Result","regex_syntax","A type alias for dealing with errors returned by this crate.",null,null]],"paths":[[3,"Parser"],[3,"ParserBuilder"],[4,"Error"],[3,"Error"],[3,"Span"],[3,"Position"],[3,"WithComments"],[3,"Comment"],[3,"Alternation"],[3,"Concat"],[3,"Literal"],[3,"ClassPerl"],[3,"ClassAscii"],[3,"ClassUnicode"],[3,"ClassBracketed"],[3,"ClassSetRange"],[3,"ClassSetUnion"],[3,"ClassSetBinaryOp"],[3,"Assertion"],[3,"Repetition"],[3,"RepetitionOp"],[3,"Group"],[3,"CaptureName"],[3,"SetFlags"],[3,"Flags"],[3,"FlagsItem"],[4,"ErrorKind"],[4,"Ast"],[4,"LiteralKind"],[4,"SpecialLiteralKind"],[4,"HexLiteralKind"],[4,"Class"],[4,"ClassPerlKind"],[4,"ClassAsciiKind"],[4,"ClassUnicodeKind"],[4,"ClassUnicodeOpKind"],[4,"ClassSet"],[4,"ClassSetItem"],[4,"ClassSetBinaryOpKind"],[4,"AssertionKind"],[4,"RepetitionKind"],[4,"RepetitionRange"],[4,"GroupKind"],[4,"FlagsItemKind"],[4,"Flag"],[3,"ParserBuilder"],[3,"Parser"],[3,"ParserI"],[3,"NestLimiter"],[4,"Primitive"],[4,"GroupState"],[4,"ClassState"],[3,"PrinterBuilder"],[3,"Printer"],[3,"Writer"],[3,"HeapVisitor"],[4,"Frame"],[4,"ClassFrame"],[4,"ClassInduct"],[8,"Visitor"],[4,"Either"],[3,"Formatter"],[3,"Spans"],[3,"Error"],[3,"Hir"],[3,"ClassUnicode"],[3,"ClassUnicodeIter"],[3,"ClassUnicodeRange"],[3,"ClassBytes"],[3,"ClassBytesIter"],[3,"ClassBytesRange"],[3,"Group"],[3,"Repetition"],[3,"HirInfo"],[4,"ErrorKind"],[4,"HirKind"],[4,"Literal"],[4,"Class"],[4,"Anchor"],[4,"WordBoundary"],[4,"GroupKind"],[4,"RepetitionKind"],[4,"RepetitionRange"],[3,"IntervalSet"],[3,"IntervalSetIter"],[8,"Interval"],[8,"Bound"],[3,"Literals"],[3,"Literal"],[3,"PrinterBuilder"],[3,"Printer"],[3,"Writer"],[3,"TranslatorBuilder"],[3,"Translator"],[3,"TranslatorI"],[3,"Flags"],[4,"HirFrame"],[3,"HeapVisitor"],[4,"Frame"],[8,"Visitor"],[3,"SimpleFoldIter"],[3,"AgeIter"],[4,"Error"],[4,"ClassQuery"],[4,"CanonicalClassQuery"]]};
searchIndex["remove_dir_all"] = {"doc":"","items":[[5,"remove_dir_all","remove_dir_all","Removes a directory at this path, after removing all its contents. Use carefully!",null,{"i":[{"n":"p"}],"o":{"g":["error"],"n":"result"}}]],"paths":[]};
searchIndex["rustc"] = {"doc":"The \"main crate\" of the Rust compiler. This crate contains common type definitions that are used by the other crates in the rustc \"family\". Some prominent examples (note that each of these modules has their own README with further details).","items":[[0,"macros","rustc","",null,null],[0,"diagnostics","","",null,null],[0,"__register_diagnostic_E0038","rustc::diagnostics","",null,null],[0,"__register_diagnostic_E0072","","",null,null],[0,"__register_diagnostic_E0080","","",null,null],[0,"__register_diagnostic_E0106","","",null,null],[0,"__register_diagnostic_E0119","","",null,null],[0,"__register_diagnostic_E0136","","",null,null],[0,"__register_diagnostic_E0137","","",null,null],[0,"__register_diagnostic_E0138","","",null,null],[0,"__register_diagnostic_E0139","","",null,null],[0,"__register_diagnostic_E0152","","",null,null],[0,"__register_diagnostic_E0214","","",null,null],[0,"__register_diagnostic_E0230","","",null,null],[0,"__register_diagnostic_E0231","","",null,null],[0,"__register_diagnostic_E0232","","",null,null],[0,"__register_diagnostic_E0261","","",null,null],[0,"__register_diagnostic_E0262","","",null,null],[0,"__register_diagnostic_E0263","","",null,null],[0,"__register_diagnostic_E0264","","",null,null],[0,"__register_diagnostic_E0271","","",null,null],[0,"__register_diagnostic_E0275","","",null,null],[0,"__register_diagnostic_E0276","","",null,null],[0,"__register_diagnostic_E0277","","",null,null],[0,"__register_diagnostic_E0281","","",null,null],[0,"__register_diagnostic_E0282","","",null,null],[0,"__register_diagnostic_E0283","","",null,null],[0,"__register_diagnostic_E0296","","",null,null],[0,"__register_diagnostic_E0308","","",null,null],[0,"__register_diagnostic_E0309","","",null,null],[0,"__register_diagnostic_E0310","","",null,null],[0,"__register_diagnostic_E0317","","",null,null],[0,"__register_diagnostic_E0391","","",null,null],[0,"__register_diagnostic_E0398","","",null,null],[0,"__register_diagnostic_E0452","","",null,null],[0,"__register_diagnostic_E0453","","",null,null],[0,"__register_diagnostic_E0478","","",null,null],[0,"__register_diagnostic_E0491","","",null,null],[0,"__register_diagnostic_E0496","","",null,null],[0,"__register_diagnostic_E0497","","",null,null],[0,"__register_diagnostic_E0512","","",null,null],[0,"__register_diagnostic_E0517","","",null,null],[0,"__register_diagnostic_E0518","","",null,null],[0,"__register_diagnostic_E0522","","",null,null],[0,"__register_diagnostic_E0525","","",null,null],[0,"__register_diagnostic_E0580","","",null,null],[0,"__register_diagnostic_E0562","","",null,null],[0,"__register_diagnostic_E0591","","",null,null],[0,"__register_diagnostic_E0593","","",null,null],[0,"__register_diagnostic_E0601","","",null,null],[0,"__register_diagnostic_E0602","","",null,null],[0,"__register_diagnostic_E0621","","",null,null],[0,"__register_diagnostic_E0644","","",null,null],[0,"__register_diagnostic_E0692","","",null,null],[0,"__register_diagnostic_E0700","","",null,null],[0,"__register_diagnostic_E0701","","",null,null],[0,"__register_diagnostic_E0702","","",null,null],[0,"__register_diagnostic_E0278","","",null,null],[0,"__register_diagnostic_E0279","","",null,null],[0,"__register_diagnostic_E0280","","",null,null],[0,"__register_diagnostic_E0284","","",null,null],[0,"__register_diagnostic_E0311","","",null,null],[0,"__register_diagnostic_E0312","","",null,null],[0,"__register_diagnostic_E0313","","",null,null],[0,"__register_diagnostic_E0314","","",null,null],[0,"__register_diagnostic_E0315","","",null,null],[0,"__register_diagnostic_E0316","","",null,null],[0,"__register_diagnostic_E0320","","",null,null],[0,"__register_diagnostic_E0473","","",null,null],[0,"__register_diagnostic_E0474","","",null,null],[0,"__register_diagnostic_E0475","","",null,null],[0,"__register_diagnostic_E0476","","",null,null],[0,"__register_diagnostic_E0477","","",null,null],[0,"__register_diagnostic_E0479","","",null,null],[0,"__register_diagnostic_E0480","","",null,null],[0,"__register_diagnostic_E0481","","",null,null],[0,"__register_diagnostic_E0482","","",null,null],[0,"__register_diagnostic_E0483","","",null,null],[0,"__register_diagnostic_E0484","","",null,null],[0,"__register_diagnostic_E0485","","",null,null],[0,"__register_diagnostic_E0486","","",null,null],[0,"__register_diagnostic_E0487","","",null,null],[0,"__register_diagnostic_E0488","","",null,null],[0,"__register_diagnostic_E0489","","",null,null],[0,"__register_diagnostic_E0490","","",null,null],[0,"__register_diagnostic_E0495","","",null,null],[0,"__register_diagnostic_E0566","","",null,null],[0,"__register_diagnostic_E0623","","",null,null],[0,"__register_diagnostic_E0628","","",null,null],[0,"__register_diagnostic_E0631","","",null,null],[0,"__register_diagnostic_E0637","","",null,null],[0,"__register_diagnostic_E0657","","",null,null],[0,"__register_diagnostic_E0687","","",null,null],[0,"__register_diagnostic_E0688","","",null,null],[0,"__register_diagnostic_E0697","","",null,null],[0,"cfg","rustc","Module that constructs a control-flow graph representing an item. Uses `Graph` as the underlying representation.",null,null],[3,"CFG","rustc::cfg","",null,null],[12,"owner_def_id","","",0,null],[12,"graph","","",0,null],[12,"entry","","",0,null],[12,"exit","","",0,null],[3,"CFGEdgeData","","",null,null],[12,"exiting_scopes","","",1,null],[4,"CFGNodeData","","",null,null],[13,"AST","","",2,null],[13,"Entry","","",2,null],[13,"Exit","","",2,null],[13,"Dummy","","",2,null],[13,"Unreachable","","",2,null],[0,"construct","","",null,null],[3,"CFGBuilder","rustc::cfg::construct","",null,null],[12,"tcx","","",3,null],[12,"owner_def_id","","",3,null],[12,"tables","","",3,null],[12,"graph","","",3,null],[12,"fn_exit","","",3,null],[12,"loop_scopes","","",3,null],[12,"breakable_block_scopes","","",3,null],[3,"BlockScope","","",null,null],[12,"block_expr_id","","",4,null],[12,"break_index","","",4,null],[3,"LoopScope","","",null,null],[12,"loop_id","","",5,null],[12,"continue_index","","",5,null],[12,"break_index","","",5,null],[4,"ScopeCfKind","","",null,null],[13,"Break","","",6,null],[13,"Continue","","",6,null],[5,"construct","","",null,{"i":[{"n":"tyctxt"},{"n":"body"}],"o":{"n":"cfg"}}],[11,"clone","","",4,{"i":[{"n":"self"}],"o":{"n":"blockscope"}}],[11,"clone","","",5,{"i":[{"n":"self"}],"o":{"n":"loopscope"}}],[11,"block","","",3,{"i":[{"n":"self"},{"n":"block"},{"n":"cfgindex"}],"o":{"n":"cfgindex"}}],[11,"stmt","","",3,{"i":[{"n":"self"},{"n":"stmt"},{"n":"cfgindex"}],"o":{"n":"cfgindex"}}],[11,"decl","","",3,{"i":[{"n":"self"},{"n":"decl"},{"n":"cfgindex"}],"o":{"n":"cfgindex"}}],[11,"pat","","",3,{"i":[{"n":"self"},{"n":"pat"},{"n":"cfgindex"}],"o":{"n":"cfgindex"}}],[11,"pats_all","","Handles case where all of the patterns must match.",3,{"i":[{"n":"self"},{"n":"i"},{"n":"cfgindex"}],"o":{"n":"cfgindex"}}],[11,"expr","","",3,{"i":[{"n":"self"},{"n":"expr"},{"n":"cfgindex"}],"o":{"n":"cfgindex"}}],[11,"call","","",3,{"i":[{"n":"self"},{"n":"expr"},{"n":"cfgindex"},{"n":"expr"},{"n":"i"}],"o":{"n":"cfgindex"}}],[11,"exprs","","Constructs graph for `exprs` evaluated in order",3,{"i":[{"n":"self"},{"n":"i"},{"n":"cfgindex"}],"o":{"n":"cfgindex"}}],[11,"opt_expr","","Constructs graph for `opt_expr` evaluated, if Some",3,{"i":[{"n":"self"},{"n":"option"},{"n":"cfgindex"}],"o":{"n":"cfgindex"}}],[11,"straightline","","Handles case of an expression that evaluates `subexprs` in order",3,{"i":[{"n":"self"},{"n":"expr"},{"n":"cfgindex"},{"n":"i"}],"o":{"n":"cfgindex"}}],[11,"match_","","",3,null],[11,"add_dummy_node","","",3,null],[11,"add_ast_node","","",3,null],[11,"add_unreachable_node","","",3,{"i":[{"n":"self"}],"o":{"n":"cfgindex"}}],[11,"add_node","","",3,null],[11,"add_contained_edge","","",3,{"i":[{"n":"self"},{"n":"cfgindex"},{"n":"cfgindex"}]}],[11,"add_exiting_edge","","",3,{"i":[{"n":"self"},{"n":"expr"},{"n":"cfgindex"},{"n":"scope"},{"n":"cfgindex"}]}],[11,"add_returning_edge","","",3,{"i":[{"n":"self"},{"n":"expr"},{"n":"cfgindex"}]}],[11,"find_scope_edge","","",3,null],[11,"clone","","",6,{"i":[{"n":"self"}],"o":{"n":"scopecfkind"}}],[11,"assert_receiver_is_total_eq","","",6,null],[11,"eq","","",6,{"i":[{"n":"self"},{"n":"scopecfkind"}],"o":{"n":"bool"}}],[0,"graphviz","rustc::cfg","",null,null],[3,"LabelledCFG","rustc::cfg::graphviz","",null,null],[12,"tcx","","",7,null],[12,"cfg","","",7,null],[12,"name","","",7,null],[12,"labelled_edges","","`labelled_edges` controls whether we emit labels on the edges",7,null],[6,"Node","","",null,null],[6,"Edge","","",null,null],[11,"local_id_to_string","","",7,{"i":[{"n":"self"},{"n":"itemlocalid"}],"o":{"n":"string"}}],[11,"graph_id","","",7,{"i":[{"n":"self"}],"o":{"n":"id"}}],[11,"node_id","","",7,{"i":[{"n":"self"},{"n":"node"}],"o":{"n":"id"}}],[11,"node_label","","",7,{"i":[{"n":"self"},{"n":"node"}],"o":{"n":"labeltext"}}],[11,"edge_label","","",7,{"i":[{"n":"self"},{"n":"edge"}],"o":{"n":"labeltext"}}],[11,"nodes","","",7,{"i":[{"n":"self"}],"o":{"g":["node"],"n":"nodes"}}],[11,"edges","","",7,{"i":[{"n":"self"}],"o":{"g":["edge"],"n":"edges"}}],[11,"source","","",7,{"i":[{"n":"self"},{"n":"edge"}],"o":{"n":"node"}}],[11,"target","","",7,{"i":[{"n":"self"},{"n":"edge"}],"o":{"n":"node"}}],[6,"CFGIndex","rustc::cfg","",null,null],[6,"CFGGraph","","",null,null],[6,"CFGNode","","",null,null],[6,"CFGEdge","","",null,null],[11,"clone","","",2,{"i":[{"n":"self"}],"o":{"n":"cfgnodedata"}}],[11,"fmt","","",2,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"eq","","",2,{"i":[{"n":"self"},{"n":"cfgnodedata"}],"o":{"n":"bool"}}],[11,"ne","","",2,{"i":[{"n":"self"},{"n":"cfgnodedata"}],"o":{"n":"bool"}}],[11,"id","","",2,{"i":[{"n":"self"}],"o":{"n":"itemlocalid"}}],[11,"fmt","","",1,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","",0,{"i":[{"n":"tyctxt"},{"n":"body"}],"o":{"n":"cfg"}}],[11,"node_is_reachable","","",0,{"i":[{"n":"self"},{"n":"itemlocalid"}],"o":{"n":"bool"}}],[0,"dep_graph","rustc","",null,null],[3,"DepTrackingMap","rustc::dep_graph","A DepTrackingMap offers a subset of the `Map` API and ensures that we make calls to `read` and `write` as appropriate. We key the maps with a unique type for brevity.",null,null],[12,"phantom","","",8,null],[12,"graph","","",8,null],[12,"map","","",8,null],[3,"DepNode","","",null,null],[12,"kind","","",9,null],[12,"hash","","",9,null],[3,"WorkProductId","","A \"work product\" corresponds to a `.o` (or other) file that we save in between runs. These ids do not have a DefId but rather some independent path or string that persists between runs without the need to be mapped or unmapped. (This ensures we can serialize them even in the absence of a tcx.)",null,null],[12,"hash","","",10,null],[3,"DepGraph","","",null,null],[12,"data","","",11,null],[12,"fingerprints","","",11,null],[3,"WorkProduct","","A \"work product\" is an intermediate result that we save into the incremental directory for later re-use. The primary example are the object files that we save for each partition at code generation time.",null,null],[12,"cgu_name","","",12,null],[12,"saved_files","","Saved files associated with this CGU",12,null],[3,"DepNodeIndex","","",null,null],[12,"0","","",13,null],[3,"PreviousDepGraph","","",null,null],[12,"data","","",14,null],[12,"index","","",14,null],[3,"DepGraphQuery","","",null,null],[12,"graph","","",15,null],[12,"indices","","",15,null],[3,"AssertDepGraphSafe","","A convenient override that lets you pass arbitrary state into a task. Every use should be accompanied by a comment explaining why it makes sense (or how it could be refactored away in the future).",null,null],[12,"0","","",16,null],[3,"SerializedDepGraph","","Data for use when recompiling the current crate.",null,null],[12,"nodes","","The set of all DepNodes in the graph",17,null],[12,"fingerprints","","The set of all Fingerprints in the graph. Each Fingerprint corresponds to the DepNode at the same index in the nodes vector.",17,null],[12,"edge_list_indices","","For each DepNode, stores the list of edges originating from that DepNode. Encoded as a [start, end) pair indexing into edge_list_data, which holds the actual DepNodeIndices of the target nodes.",17,null],[12,"edge_list_data","","A flattened list of all edge targets in the graph. Edge sources are implicit in edge_list_indices.",17,null],[3,"SerializedDepNodeIndex","","",null,null],[12,"0","","",18,null],[4,"DepKind","","",null,null],[13,"Null","","",19,null],[13,"Krate","","",19,null],[13,"HirBody","","",19,null],[13,"Hir","","",19,null],[13,"CrateMetadata","","",19,null],[13,"RegionScopeTree","","",19,null],[13,"Coherence","","",19,null],[13,"CoherenceInherentImplOverlapCheck","","",19,null],[13,"CoherenceCheckTrait","","",19,null],[13,"PrivacyAccessLevels","","",19,null],[13,"MirConstQualif","","",19,null],[13,"MirBuilt","","",19,null],[13,"MirConst","","",19,null],[13,"MirValidated","","",19,null],[13,"MirOptimized","","",19,null],[13,"MirShim","","",19,null],[13,"BorrowCheckKrate","","",19,null],[13,"BorrowCheck","","",19,null],[13,"MirBorrowCheck","","",19,null],[13,"UnsafetyCheckResult","","",19,null],[13,"UnsafeDeriveOnReprPacked","","",19,null],[13,"Reachability","","",19,null],[13,"MirKeys","","",19,null],[13,"CrateVariances","","",19,null],[13,"AssociatedItems","","",19,null],[13,"TypeOfItem","","",19,null],[13,"GenericsOfItem","","",19,null],[13,"PredicatesOfItem","","",19,null],[13,"ExplicitPredicatesOfItem","","",19,null],[13,"InferredOutlivesOf","","",19,null],[13,"InferredOutlivesCrate","","",19,null],[13,"SuperPredicatesOfItem","","",19,null],[13,"TraitDefOfItem","","",19,null],[13,"AdtDefOfItem","","",19,null],[13,"ImplTraitRef","","",19,null],[13,"ImplPolarity","","",19,null],[13,"FnSignature","","",19,null],[13,"CoerceUnsizedInfo","","",19,null],[13,"ItemVarianceConstraints","","",19,null],[13,"ItemVariances","","",19,null],[13,"IsConstFn","","",19,null],[13,"IsForeignItem","","",19,null],[13,"TypeParamPredicates","","",19,null],[13,"SizedConstraint","","",19,null],[13,"DtorckConstraint","","",19,null],[13,"AdtDestructor","","",19,null],[13,"AssociatedItemDefIds","","",19,null],[13,"InherentImpls","","",19,null],[13,"TypeckBodiesKrate","","",19,null],[13,"TypeckTables","","",19,null],[13,"UsedTraitImports","","",19,null],[13,"HasTypeckTables","","",19,null],[13,"ConstEval","","",19,null],[13,"CheckMatch","","",19,null],[13,"SymbolName","","",19,null],[13,"InstanceSymbolName","","",19,null],[13,"SpecializationGraph","","",19,null],[13,"ObjectSafety","","",19,null],[13,"FulfillObligation","","",19,null],[13,"VtableMethods","","",19,null],[13,"IsCopy","","",19,null],[13,"IsSized","","",19,null],[13,"IsFreeze","","",19,null],[13,"NeedsDrop","","",19,null],[13,"Layout","","",19,null],[13,"TraitImpls","","",19,null],[13,"AllLocalTraitImpls","","",19,null],[13,"TraitSelect","","",19,null],[13,"ParamEnv","","",19,null],[13,"DescribeDef","","",19,null],[13,"DefSpan","","",19,null],[13,"LookupStability","","",19,null],[13,"LookupDeprecationEntry","","",19,null],[13,"ConstIsRvaluePromotableToStatic","","",19,null],[13,"RvaluePromotableMap","","",19,null],[13,"ImplParent","","",19,null],[13,"TraitOfItem","","",19,null],[13,"IsReachableNonGeneric","","",19,null],[13,"IsUnreachableLocalDefinition","","",19,null],[13,"IsMirAvailable","","",19,null],[13,"ItemAttrs","","",19,null],[13,"CodegenFnAttrs","","",19,null],[13,"FnArgNames","","",19,null],[13,"RenderedConst","","",19,null],[13,"DylibDepFormats","","",19,null],[13,"IsPanicRuntime","","",19,null],[13,"IsCompilerBuiltins","","",19,null],[13,"HasGlobalAllocator","","",19,null],[13,"ExternCrate","","",19,null],[13,"LintLevels","","",19,null],[13,"Specializes","","",19,null],[13,"InScopeTraits","","",19,null],[13,"ModuleExports","","",19,null],[13,"IsSanitizerRuntime","","",19,null],[13,"IsProfilerRuntime","","",19,null],[13,"GetPanicStrategy","","",19,null],[13,"IsNoBuiltins","","",19,null],[13,"ImplDefaultness","","",19,null],[13,"CheckItemWellFormed","","",19,null],[13,"CheckTraitItemWellFormed","","",19,null],[13,"CheckImplItemWellFormed","","",19,null],[13,"ReachableNonGenerics","","",19,null],[13,"NativeLibraries","","",19,null],[13,"PluginRegistrarFn","","",19,null],[13,"DeriveRegistrarFn","","",19,null],[13,"CrateDisambiguator","","",19,null],[13,"CrateHash","","",19,null],[13,"OriginalCrateName","","",19,null],[13,"ExtraFileName","","",19,null],[13,"ImplementationsOfTrait","","",19,null],[13,"AllTraitImplementations","","",19,null],[13,"DllimportForeignItems","","",19,null],[13,"IsDllimportForeignItem","","",19,null],[13,"IsStaticallyIncludedForeignItem","","",19,null],[13,"NativeLibraryKind","","",19,null],[13,"LinkArgs","","",19,null],[13,"ResolveLifetimes","","",19,null],[13,"NamedRegion","","",19,null],[13,"IsLateBound","","",19,null],[13,"ObjectLifetimeDefaults","","",19,null],[13,"Visibility","","",19,null],[13,"DepKind","","",19,null],[13,"CrateName","","",19,null],[13,"ItemChildren","","",19,null],[13,"ExternModStmtCnum","","",19,null],[13,"GetLangItems","","",19,null],[13,"DefinedLangItems","","",19,null],[13,"MissingLangItems","","",19,null],[13,"VisibleParentMap","","",19,null],[13,"MissingExternCrateItem","","",19,null],[13,"UsedCrateSource","","",19,null],[13,"PostorderCnums","","",19,null],[13,"EraseRegionsTy","","",19,null],[13,"ConstValueToAllocation","","",19,null],[13,"Freevars","","",19,null],[13,"MaybeUnusedTraitImport","","",19,null],[13,"MaybeUnusedExternCrates","","",19,null],[13,"StabilityIndex","","",19,null],[13,"AllTraits","","",19,null],[13,"AllCrateNums","","",19,null],[13,"ExportedSymbols","","",19,null],[13,"CollectAndPartitionMonoItems","","",19,null],[13,"IsCodegenedItem","","",19,null],[13,"CodegenUnit","","",19,null],[13,"CompileCodegenUnit","","",19,null],[13,"OutputFilenames","","",19,null],[13,"NormalizeProjectionTy","","",19,null],[13,"NormalizeTyAfterErasingRegions","","",19,null],[13,"DropckOutlives","","",19,null],[13,"EvaluateObligation","","",19,null],[13,"SubstituteNormalizeAndTestPredicates","","",19,null],[13,"TargetFeaturesWhitelist","","",19,null],[13,"InstanceDefSizeEstimate","","",19,null],[13,"WasmCustomSections","","",19,null],[13,"Features","","",19,null],[13,"ProgramClausesFor","","",19,null],[13,"ProgramClausesForEnv","","",19,null],[13,"WasmImportModuleMap","","",19,null],[13,"ForeignModules","","",19,null],[13,"UpstreamMonomorphizations","","",19,null],[13,"UpstreamMonomorphizationsFor","","",19,null],[4,"DepConstructor","","",null,null],[13,"Null","","",20,null],[13,"Krate","","",20,null],[13,"HirBody","","",20,null],[13,"Hir","","",20,null],[13,"CrateMetadata","","",20,null],[13,"RegionScopeTree","","",20,null],[13,"Coherence","","",20,null],[13,"CoherenceInherentImplOverlapCheck","","",20,null],[13,"CoherenceCheckTrait","","",20,null],[13,"PrivacyAccessLevels","","",20,null],[13,"MirConstQualif","","",20,null],[13,"MirBuilt","","",20,null],[13,"MirConst","","",20,null],[13,"MirValidated","","",20,null],[13,"MirOptimized","","",20,null],[13,"MirShim","","",20,null],[12,"instance_def","rustc::dep_graph::DepConstructor","",20,null],[13,"BorrowCheckKrate","rustc::dep_graph","",20,null],[13,"BorrowCheck","","",20,null],[13,"MirBorrowCheck","","",20,null],[13,"UnsafetyCheckResult","","",20,null],[13,"UnsafeDeriveOnReprPacked","","",20,null],[13,"Reachability","","",20,null],[13,"MirKeys","","",20,null],[13,"CrateVariances","","",20,null],[13,"AssociatedItems","","",20,null],[13,"TypeOfItem","","",20,null],[13,"GenericsOfItem","","",20,null],[13,"PredicatesOfItem","","",20,null],[13,"ExplicitPredicatesOfItem","","",20,null],[13,"InferredOutlivesOf","","",20,null],[13,"InferredOutlivesCrate","","",20,null],[13,"SuperPredicatesOfItem","","",20,null],[13,"TraitDefOfItem","","",20,null],[13,"AdtDefOfItem","","",20,null],[13,"ImplTraitRef","","",20,null],[13,"ImplPolarity","","",20,null],[13,"FnSignature","","",20,null],[13,"CoerceUnsizedInfo","","",20,null],[13,"ItemVarianceConstraints","","",20,null],[13,"ItemVariances","","",20,null],[13,"IsConstFn","","",20,null],[13,"IsForeignItem","","",20,null],[13,"TypeParamPredicates","","",20,null],[12,"item_id","rustc::dep_graph::DepConstructor","",20,null],[12,"param_id","","",20,null],[13,"SizedConstraint","rustc::dep_graph","",20,null],[13,"DtorckConstraint","","",20,null],[13,"AdtDestructor","","",20,null],[13,"AssociatedItemDefIds","","",20,null],[13,"InherentImpls","","",20,null],[13,"TypeckBodiesKrate","","",20,null],[13,"TypeckTables","","",20,null],[13,"UsedTraitImports","","",20,null],[13,"HasTypeckTables","","",20,null],[13,"ConstEval","","",20,null],[12,"param_env","rustc::dep_graph::DepConstructor","",20,null],[13,"CheckMatch","rustc::dep_graph","",20,null],[13,"SymbolName","","",20,null],[13,"InstanceSymbolName","","",20,null],[12,"instance","rustc::dep_graph::DepConstructor","",20,null],[13,"SpecializationGraph","rustc::dep_graph","",20,null],[13,"ObjectSafety","","",20,null],[13,"FulfillObligation","","",20,null],[12,"param_env","rustc::dep_graph::DepConstructor","",20,null],[12,"trait_ref","","",20,null],[13,"VtableMethods","rustc::dep_graph","",20,null],[12,"trait_ref","rustc::dep_graph::DepConstructor","",20,null],[13,"IsCopy","rustc::dep_graph","",20,null],[12,"param_env","rustc::dep_graph::DepConstructor","",20,null],[13,"IsSized","rustc::dep_graph","",20,null],[12,"param_env","rustc::dep_graph::DepConstructor","",20,null],[13,"IsFreeze","rustc::dep_graph","",20,null],[12,"param_env","rustc::dep_graph::DepConstructor","",20,null],[13,"NeedsDrop","rustc::dep_graph","",20,null],[12,"param_env","rustc::dep_graph::DepConstructor","",20,null],[13,"Layout","rustc::dep_graph","",20,null],[12,"param_env","rustc::dep_graph::DepConstructor","",20,null],[13,"TraitImpls","rustc::dep_graph","",20,null],[13,"AllLocalTraitImpls","","",20,null],[13,"TraitSelect","","",20,null],[13,"ParamEnv","","",20,null],[13,"DescribeDef","","",20,null],[13,"DefSpan","","",20,null],[13,"LookupStability","","",20,null],[13,"LookupDeprecationEntry","","",20,null],[13,"ConstIsRvaluePromotableToStatic","","",20,null],[13,"RvaluePromotableMap","","",20,null],[13,"ImplParent","","",20,null],[13,"TraitOfItem","","",20,null],[13,"IsReachableNonGeneric","","",20,null],[13,"IsUnreachableLocalDefinition","","",20,null],[13,"IsMirAvailable","","",20,null],[13,"ItemAttrs","","",20,null],[13,"CodegenFnAttrs","","",20,null],[13,"FnArgNames","","",20,null],[13,"RenderedConst","","",20,null],[13,"DylibDepFormats","","",20,null],[13,"IsPanicRuntime","","",20,null],[13,"IsCompilerBuiltins","","",20,null],[13,"HasGlobalAllocator","","",20,null],[13,"ExternCrate","","",20,null],[13,"LintLevels","","",20,null],[13,"Specializes","","",20,null],[12,"impl1","rustc::dep_graph::DepConstructor","",20,null],[12,"impl2","","",20,null],[13,"InScopeTraits","rustc::dep_graph","",20,null],[13,"ModuleExports","","",20,null],[13,"IsSanitizerRuntime","","",20,null],[13,"IsProfilerRuntime","","",20,null],[13,"GetPanicStrategy","","",20,null],[13,"IsNoBuiltins","","",20,null],[13,"ImplDefaultness","","",20,null],[13,"CheckItemWellFormed","","",20,null],[13,"CheckTraitItemWellFormed","","",20,null],[13,"CheckImplItemWellFormed","","",20,null],[13,"ReachableNonGenerics","","",20,null],[13,"NativeLibraries","","",20,null],[13,"PluginRegistrarFn","","",20,null],[13,"DeriveRegistrarFn","","",20,null],[13,"CrateDisambiguator","","",20,null],[13,"CrateHash","","",20,null],[13,"OriginalCrateName","","",20,null],[13,"ExtraFileName","","",20,null],[13,"ImplementationsOfTrait","","",20,null],[12,"krate","rustc::dep_graph::DepConstructor","",20,null],[12,"trait_id","","",20,null],[13,"AllTraitImplementations","rustc::dep_graph","",20,null],[13,"DllimportForeignItems","","",20,null],[13,"IsDllimportForeignItem","","",20,null],[13,"IsStaticallyIncludedForeignItem","","",20,null],[13,"NativeLibraryKind","","",20,null],[13,"LinkArgs","","",20,null],[13,"ResolveLifetimes","","",20,null],[13,"NamedRegion","","",20,null],[13,"IsLateBound","","",20,null],[13,"ObjectLifetimeDefaults","","",20,null],[13,"Visibility","","",20,null],[13,"DepKind","","",20,null],[13,"CrateName","","",20,null],[13,"ItemChildren","","",20,null],[13,"ExternModStmtCnum","","",20,null],[13,"GetLangItems","","",20,null],[13,"DefinedLangItems","","",20,null],[13,"MissingLangItems","","",20,null],[13,"VisibleParentMap","","",20,null],[13,"MissingExternCrateItem","","",20,null],[13,"UsedCrateSource","","",20,null],[13,"PostorderCnums","","",20,null],[13,"EraseRegionsTy","","",20,null],[12,"ty","rustc::dep_graph::DepConstructor","",20,null],[13,"ConstValueToAllocation","rustc::dep_graph","",20,null],[12,"val","rustc::dep_graph::DepConstructor","",20,null],[12,"ty","","",20,null],[13,"Freevars","rustc::dep_graph","",20,null],[13,"MaybeUnusedTraitImport","","",20,null],[13,"MaybeUnusedExternCrates","","",20,null],[13,"StabilityIndex","","",20,null],[13,"AllTraits","","",20,null],[13,"AllCrateNums","","",20,null],[13,"ExportedSymbols","","",20,null],[13,"CollectAndPartitionMonoItems","","",20,null],[13,"IsCodegenedItem","","",20,null],[13,"CodegenUnit","","",20,null],[13,"CompileCodegenUnit","","",20,null],[13,"OutputFilenames","","",20,null],[13,"NormalizeProjectionTy","","",20,null],[13,"NormalizeTyAfterErasingRegions","","",20,null],[13,"DropckOutlives","","",20,null],[13,"EvaluateObligation","","",20,null],[13,"SubstituteNormalizeAndTestPredicates","","",20,null],[12,"key","rustc::dep_graph::DepConstructor","",20,null],[13,"TargetFeaturesWhitelist","rustc::dep_graph","",20,null],[13,"InstanceDefSizeEstimate","","",20,null],[12,"instance_def","rustc::dep_graph::DepConstructor","",20,null],[13,"WasmCustomSections","rustc::dep_graph","",20,null],[13,"Features","","",20,null],[13,"ProgramClausesFor","","",20,null],[13,"ProgramClausesForEnv","","",20,null],[13,"WasmImportModuleMap","","",20,null],[13,"ForeignModules","","",20,null],[13,"UpstreamMonomorphizations","","",20,null],[13,"UpstreamMonomorphizationsFor","","",20,null],[4,"DepNodeColor","","",null,null],[13,"Red","","",21,null],[13,"Green","","",21,null],[4,"OpenTask","","",null,null],[13,"Regular","","",22,null],[13,"Anon","","",22,null],[13,"Ignore","","",22,null],[13,"EvalAlways","","",22,null],[12,"node","rustc::dep_graph::OpenTask","",22,null],[4,"WorkProductFileKind","rustc::dep_graph","",null,null],[13,"Object","","",23,null],[13,"Bytecode","","",23,null],[13,"BytecodeCompressed","","",23,null],[0,"debug","","Code for debugging the dep-graph.",null,null],[3,"DepNodeFilter","rustc::dep_graph::debug","A dep-node filter goes from a user-defined string to a query over nodes. Right now the format is like this:",null,null],[12,"text","","",24,null],[3,"EdgeFilter","","A filter like `F -> G` where `F` and `G` are valid dep-node filters. This can be used to test the source/target independently.",null,null],[12,"source","","",25,null],[12,"target","","",25,null],[11,"fmt","","",24,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","",24,{"i":[{"n":"str"}],"o":{"n":"self"}}],[11,"accepts_all","","True if all nodes always pass the filter.",24,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"test","","Tests whether `node` meets the filter, returning true if so.",24,{"i":[{"n":"self"},{"n":"depnode"}],"o":{"n":"bool"}}],[11,"new","","",25,{"i":[{"n":"str"}],"o":{"g":["edgefilter","box"],"n":"result"}}],[11,"test","","",25,{"i":[{"n":"self"},{"n":"depnode"},{"n":"depnode"}],"o":{"n":"bool"}}],[0,"dep_node","rustc::dep_graph","This module defines the `DepNode` type which the compiler uses to represent nodes in the dependency graph. A `DepNode` consists of a `DepKind` (which specifies the kind of thing it represents, like a piece of HIR, MIR, etc) and a `Fingerprint`, a 128 bit hash value the exact meaning of which depends on the node's `DepKind`. Together, the kind and the fingerprint fully identify a dependency node, even across multiple compilation sessions. In other words, the value of the fingerprint does not depend on anything that is specific to a given compilation session, like an unpredictable interning key (e.g. NodeId, DefId, Symbol) or the numeric value of a pointer. The concept behind this could be compared to how git commit hashes uniquely identify a given commit and has a few advantages:",null,null],[3,"DepNode","rustc::dep_graph::dep_node","",null,null],[12,"kind","","",9,null],[12,"hash","","",9,null],[3,"WorkProductId","","A \"work product\" corresponds to a `.o` (or other) file that we save in between runs. These ids do not have a DefId but rather some independent path or string that persists between runs without the need to be mapped or unmapped. (This ensures we can serialize them even in the absence of a tcx.)",null,null],[12,"hash","","",10,null],[4,"DepKind","","",null,null],[13,"Null","","",19,null],[13,"Krate","","",19,null],[13,"HirBody","","",19,null],[13,"Hir","","",19,null],[13,"CrateMetadata","","",19,null],[13,"RegionScopeTree","","",19,null],[13,"Coherence","","",19,null],[13,"CoherenceInherentImplOverlapCheck","","",19,null],[13,"CoherenceCheckTrait","","",19,null],[13,"PrivacyAccessLevels","","",19,null],[13,"MirConstQualif","","",19,null],[13,"MirBuilt","","",19,null],[13,"MirConst","","",19,null],[13,"MirValidated","","",19,null],[13,"MirOptimized","","",19,null],[13,"MirShim","","",19,null],[13,"BorrowCheckKrate","","",19,null],[13,"BorrowCheck","","",19,null],[13,"MirBorrowCheck","","",19,null],[13,"UnsafetyCheckResult","","",19,null],[13,"UnsafeDeriveOnReprPacked","","",19,null],[13,"Reachability","","",19,null],[13,"MirKeys","","",19,null],[13,"CrateVariances","","",19,null],[13,"AssociatedItems","","",19,null],[13,"TypeOfItem","","",19,null],[13,"GenericsOfItem","","",19,null],[13,"PredicatesOfItem","","",19,null],[13,"ExplicitPredicatesOfItem","","",19,null],[13,"InferredOutlivesOf","","",19,null],[13,"InferredOutlivesCrate","","",19,null],[13,"SuperPredicatesOfItem","","",19,null],[13,"TraitDefOfItem","","",19,null],[13,"AdtDefOfItem","","",19,null],[13,"ImplTraitRef","","",19,null],[13,"ImplPolarity","","",19,null],[13,"FnSignature","","",19,null],[13,"CoerceUnsizedInfo","","",19,null],[13,"ItemVarianceConstraints","","",19,null],[13,"ItemVariances","","",19,null],[13,"IsConstFn","","",19,null],[13,"IsForeignItem","","",19,null],[13,"TypeParamPredicates","","",19,null],[13,"SizedConstraint","","",19,null],[13,"DtorckConstraint","","",19,null],[13,"AdtDestructor","","",19,null],[13,"AssociatedItemDefIds","","",19,null],[13,"InherentImpls","","",19,null],[13,"TypeckBodiesKrate","","",19,null],[13,"TypeckTables","","",19,null],[13,"UsedTraitImports","","",19,null],[13,"HasTypeckTables","","",19,null],[13,"ConstEval","","",19,null],[13,"CheckMatch","","",19,null],[13,"SymbolName","","",19,null],[13,"InstanceSymbolName","","",19,null],[13,"SpecializationGraph","","",19,null],[13,"ObjectSafety","","",19,null],[13,"FulfillObligation","","",19,null],[13,"VtableMethods","","",19,null],[13,"IsCopy","","",19,null],[13,"IsSized","","",19,null],[13,"IsFreeze","","",19,null],[13,"NeedsDrop","","",19,null],[13,"Layout","","",19,null],[13,"TraitImpls","","",19,null],[13,"AllLocalTraitImpls","","",19,null],[13,"TraitSelect","","",19,null],[13,"ParamEnv","","",19,null],[13,"DescribeDef","","",19,null],[13,"DefSpan","","",19,null],[13,"LookupStability","","",19,null],[13,"LookupDeprecationEntry","","",19,null],[13,"ConstIsRvaluePromotableToStatic","","",19,null],[13,"RvaluePromotableMap","","",19,null],[13,"ImplParent","","",19,null],[13,"TraitOfItem","","",19,null],[13,"IsReachableNonGeneric","","",19,null],[13,"IsUnreachableLocalDefinition","","",19,null],[13,"IsMirAvailable","","",19,null],[13,"ItemAttrs","","",19,null],[13,"CodegenFnAttrs","","",19,null],[13,"FnArgNames","","",19,null],[13,"RenderedConst","","",19,null],[13,"DylibDepFormats","","",19,null],[13,"IsPanicRuntime","","",19,null],[13,"IsCompilerBuiltins","","",19,null],[13,"HasGlobalAllocator","","",19,null],[13,"ExternCrate","","",19,null],[13,"LintLevels","","",19,null],[13,"Specializes","","",19,null],[13,"InScopeTraits","","",19,null],[13,"ModuleExports","","",19,null],[13,"IsSanitizerRuntime","","",19,null],[13,"IsProfilerRuntime","","",19,null],[13,"GetPanicStrategy","","",19,null],[13,"IsNoBuiltins","","",19,null],[13,"ImplDefaultness","","",19,null],[13,"CheckItemWellFormed","","",19,null],[13,"CheckTraitItemWellFormed","","",19,null],[13,"CheckImplItemWellFormed","","",19,null],[13,"ReachableNonGenerics","","",19,null],[13,"NativeLibraries","","",19,null],[13,"PluginRegistrarFn","","",19,null],[13,"DeriveRegistrarFn","","",19,null],[13,"CrateDisambiguator","","",19,null],[13,"CrateHash","","",19,null],[13,"OriginalCrateName","","",19,null],[13,"ExtraFileName","","",19,null],[13,"ImplementationsOfTrait","","",19,null],[13,"AllTraitImplementations","","",19,null],[13,"DllimportForeignItems","","",19,null],[13,"IsDllimportForeignItem","","",19,null],[13,"IsStaticallyIncludedForeignItem","","",19,null],[13,"NativeLibraryKind","","",19,null],[13,"LinkArgs","","",19,null],[13,"ResolveLifetimes","","",19,null],[13,"NamedRegion","","",19,null],[13,"IsLateBound","","",19,null],[13,"ObjectLifetimeDefaults","","",19,null],[13,"Visibility","","",19,null],[13,"DepKind","","",19,null],[13,"CrateName","","",19,null],[13,"ItemChildren","","",19,null],[13,"ExternModStmtCnum","","",19,null],[13,"GetLangItems","","",19,null],[13,"DefinedLangItems","","",19,null],[13,"MissingLangItems","","",19,null],[13,"VisibleParentMap","","",19,null],[13,"MissingExternCrateItem","","",19,null],[13,"UsedCrateSource","","",19,null],[13,"PostorderCnums","","",19,null],[13,"EraseRegionsTy","","",19,null],[13,"ConstValueToAllocation","","",19,null],[13,"Freevars","","",19,null],[13,"MaybeUnusedTraitImport","","",19,null],[13,"MaybeUnusedExternCrates","","",19,null],[13,"StabilityIndex","","",19,null],[13,"AllTraits","","",19,null],[13,"AllCrateNums","","",19,null],[13,"ExportedSymbols","","",19,null],[13,"CollectAndPartitionMonoItems","","",19,null],[13,"IsCodegenedItem","","",19,null],[13,"CodegenUnit","","",19,null],[13,"CompileCodegenUnit","","",19,null],[13,"OutputFilenames","","",19,null],[13,"NormalizeProjectionTy","","",19,null],[13,"NormalizeTyAfterErasingRegions","","",19,null],[13,"DropckOutlives","","",19,null],[13,"EvaluateObligation","","",19,null],[13,"SubstituteNormalizeAndTestPredicates","","",19,null],[13,"TargetFeaturesWhitelist","","",19,null],[13,"InstanceDefSizeEstimate","","",19,null],[13,"WasmCustomSections","","",19,null],[13,"Features","","",19,null],[13,"ProgramClausesFor","","",19,null],[13,"ProgramClausesForEnv","","",19,null],[13,"WasmImportModuleMap","","",19,null],[13,"ForeignModules","","",19,null],[13,"UpstreamMonomorphizations","","",19,null],[13,"UpstreamMonomorphizationsFor","","",19,null],[4,"DepConstructor","","",null,null],[13,"Null","","",20,null],[13,"Krate","","",20,null],[13,"HirBody","","",20,null],[13,"Hir","","",20,null],[13,"CrateMetadata","","",20,null],[13,"RegionScopeTree","","",20,null],[13,"Coherence","","",20,null],[13,"CoherenceInherentImplOverlapCheck","","",20,null],[13,"CoherenceCheckTrait","","",20,null],[13,"PrivacyAccessLevels","","",20,null],[13,"MirConstQualif","","",20,null],[13,"MirBuilt","","",20,null],[13,"MirConst","","",20,null],[13,"MirValidated","","",20,null],[13,"MirOptimized","","",20,null],[13,"MirShim","","",20,null],[12,"instance_def","rustc::dep_graph::dep_node::DepConstructor","",20,null],[13,"BorrowCheckKrate","rustc::dep_graph::dep_node","",20,null],[13,"BorrowCheck","","",20,null],[13,"MirBorrowCheck","","",20,null],[13,"UnsafetyCheckResult","","",20,null],[13,"UnsafeDeriveOnReprPacked","","",20,null],[13,"Reachability","","",20,null],[13,"MirKeys","","",20,null],[13,"CrateVariances","","",20,null],[13,"AssociatedItems","","",20,null],[13,"TypeOfItem","","",20,null],[13,"GenericsOfItem","","",20,null],[13,"PredicatesOfItem","","",20,null],[13,"ExplicitPredicatesOfItem","","",20,null],[13,"InferredOutlivesOf","","",20,null],[13,"InferredOutlivesCrate","","",20,null],[13,"SuperPredicatesOfItem","","",20,null],[13,"TraitDefOfItem","","",20,null],[13,"AdtDefOfItem","","",20,null],[13,"ImplTraitRef","","",20,null],[13,"ImplPolarity","","",20,null],[13,"FnSignature","","",20,null],[13,"CoerceUnsizedInfo","","",20,null],[13,"ItemVarianceConstraints","","",20,null],[13,"ItemVariances","","",20,null],[13,"IsConstFn","","",20,null],[13,"IsForeignItem","","",20,null],[13,"TypeParamPredicates","","",20,null],[12,"item_id","rustc::dep_graph::dep_node::DepConstructor","",20,null],[12,"param_id","","",20,null],[13,"SizedConstraint","rustc::dep_graph::dep_node","",20,null],[13,"DtorckConstraint","","",20,null],[13,"AdtDestructor","","",20,null],[13,"AssociatedItemDefIds","","",20,null],[13,"InherentImpls","","",20,null],[13,"TypeckBodiesKrate","","",20,null],[13,"TypeckTables","","",20,null],[13,"UsedTraitImports","","",20,null],[13,"HasTypeckTables","","",20,null],[13,"ConstEval","","",20,null],[12,"param_env","rustc::dep_graph::dep_node::DepConstructor","",20,null],[13,"CheckMatch","rustc::dep_graph::dep_node","",20,null],[13,"SymbolName","","",20,null],[13,"InstanceSymbolName","","",20,null],[12,"instance","rustc::dep_graph::dep_node::DepConstructor","",20,null],[13,"SpecializationGraph","rustc::dep_graph::dep_node","",20,null],[13,"ObjectSafety","","",20,null],[13,"FulfillObligation","","",20,null],[12,"param_env","rustc::dep_graph::dep_node::DepConstructor","",20,null],[12,"trait_ref","","",20,null],[13,"VtableMethods","rustc::dep_graph::dep_node","",20,null],[12,"trait_ref","rustc::dep_graph::dep_node::DepConstructor","",20,null],[13,"IsCopy","rustc::dep_graph::dep_node","",20,null],[12,"param_env","rustc::dep_graph::dep_node::DepConstructor","",20,null],[13,"IsSized","rustc::dep_graph::dep_node","",20,null],[12,"param_env","rustc::dep_graph::dep_node::DepConstructor","",20,null],[13,"IsFreeze","rustc::dep_graph::dep_node","",20,null],[12,"param_env","rustc::dep_graph::dep_node::DepConstructor","",20,null],[13,"NeedsDrop","rustc::dep_graph::dep_node","",20,null],[12,"param_env","rustc::dep_graph::dep_node::DepConstructor","",20,null],[13,"Layout","rustc::dep_graph::dep_node","",20,null],[12,"param_env","rustc::dep_graph::dep_node::DepConstructor","",20,null],[13,"TraitImpls","rustc::dep_graph::dep_node","",20,null],[13,"AllLocalTraitImpls","","",20,null],[13,"TraitSelect","","",20,null],[13,"ParamEnv","","",20,null],[13,"DescribeDef","","",20,null],[13,"DefSpan","","",20,null],[13,"LookupStability","","",20,null],[13,"LookupDeprecationEntry","","",20,null],[13,"ConstIsRvaluePromotableToStatic","","",20,null],[13,"RvaluePromotableMap","","",20,null],[13,"ImplParent","","",20,null],[13,"TraitOfItem","","",20,null],[13,"IsReachableNonGeneric","","",20,null],[13,"IsUnreachableLocalDefinition","","",20,null],[13,"IsMirAvailable","","",20,null],[13,"ItemAttrs","","",20,null],[13,"CodegenFnAttrs","","",20,null],[13,"FnArgNames","","",20,null],[13,"RenderedConst","","",20,null],[13,"DylibDepFormats","","",20,null],[13,"IsPanicRuntime","","",20,null],[13,"IsCompilerBuiltins","","",20,null],[13,"HasGlobalAllocator","","",20,null],[13,"ExternCrate","","",20,null],[13,"LintLevels","","",20,null],[13,"Specializes","","",20,null],[12,"impl1","rustc::dep_graph::dep_node::DepConstructor","",20,null],[12,"impl2","","",20,null],[13,"InScopeTraits","rustc::dep_graph::dep_node","",20,null],[13,"ModuleExports","","",20,null],[13,"IsSanitizerRuntime","","",20,null],[13,"IsProfilerRuntime","","",20,null],[13,"GetPanicStrategy","","",20,null],[13,"IsNoBuiltins","","",20,null],[13,"ImplDefaultness","","",20,null],[13,"CheckItemWellFormed","","",20,null],[13,"CheckTraitItemWellFormed","","",20,null],[13,"CheckImplItemWellFormed","","",20,null],[13,"ReachableNonGenerics","","",20,null],[13,"NativeLibraries","","",20,null],[13,"PluginRegistrarFn","","",20,null],[13,"DeriveRegistrarFn","","",20,null],[13,"CrateDisambiguator","","",20,null],[13,"CrateHash","","",20,null],[13,"OriginalCrateName","","",20,null],[13,"ExtraFileName","","",20,null],[13,"ImplementationsOfTrait","","",20,null],[12,"krate","rustc::dep_graph::dep_node::DepConstructor","",20,null],[12,"trait_id","","",20,null],[13,"AllTraitImplementations","rustc::dep_graph::dep_node","",20,null],[13,"DllimportForeignItems","","",20,null],[13,"IsDllimportForeignItem","","",20,null],[13,"IsStaticallyIncludedForeignItem","","",20,null],[13,"NativeLibraryKind","","",20,null],[13,"LinkArgs","","",20,null],[13,"ResolveLifetimes","","",20,null],[13,"NamedRegion","","",20,null],[13,"IsLateBound","","",20,null],[13,"ObjectLifetimeDefaults","","",20,null],[13,"Visibility","","",20,null],[13,"DepKind","","",20,null],[13,"CrateName","","",20,null],[13,"ItemChildren","","",20,null],[13,"ExternModStmtCnum","","",20,null],[13,"GetLangItems","","",20,null],[13,"DefinedLangItems","","",20,null],[13,"MissingLangItems","","",20,null],[13,"VisibleParentMap","","",20,null],[13,"MissingExternCrateItem","","",20,null],[13,"UsedCrateSource","","",20,null],[13,"PostorderCnums","","",20,null],[13,"EraseRegionsTy","","",20,null],[12,"ty","rustc::dep_graph::dep_node::DepConstructor","",20,null],[13,"ConstValueToAllocation","rustc::dep_graph::dep_node","",20,null],[12,"val","rustc::dep_graph::dep_node::DepConstructor","",20,null],[12,"ty","","",20,null],[13,"Freevars","rustc::dep_graph::dep_node","",20,null],[13,"MaybeUnusedTraitImport","","",20,null],[13,"MaybeUnusedExternCrates","","",20,null],[13,"StabilityIndex","","",20,null],[13,"AllTraits","","",20,null],[13,"AllCrateNums","","",20,null],[13,"ExportedSymbols","","",20,null],[13,"CollectAndPartitionMonoItems","","",20,null],[13,"IsCodegenedItem","","",20,null],[13,"CodegenUnit","","",20,null],[13,"CompileCodegenUnit","","",20,null],[13,"OutputFilenames","","",20,null],[13,"NormalizeProjectionTy","","",20,null],[13,"NormalizeTyAfterErasingRegions","","",20,null],[13,"DropckOutlives","","",20,null],[13,"EvaluateObligation","","",20,null],[13,"SubstituteNormalizeAndTestPredicates","","",20,null],[12,"key","rustc::dep_graph::dep_node::DepConstructor","",20,null],[13,"TargetFeaturesWhitelist","rustc::dep_graph::dep_node","",20,null],[13,"InstanceDefSizeEstimate","","",20,null],[12,"instance_def","rustc::dep_graph::dep_node::DepConstructor","",20,null],[13,"WasmCustomSections","rustc::dep_graph::dep_node","",20,null],[13,"Features","","",20,null],[13,"ProgramClausesFor","","",20,null],[13,"ProgramClausesForEnv","","",20,null],[13,"WasmImportModuleMap","","",20,null],[13,"ForeignModules","","",20,null],[13,"UpstreamMonomorphizations","","",20,null],[13,"UpstreamMonomorphizationsFor","","",20,null],[0,"label_strs","","Contains variant => str representations for constructing DepNode groups for tests.",null,null],[17,"Null","rustc::dep_graph::dep_node::label_strs","",null,null],[17,"Krate","","",null,null],[17,"HirBody","","",null,null],[17,"Hir","","",null,null],[17,"CrateMetadata","","",null,null],[17,"RegionScopeTree","","",null,null],[17,"Coherence","","",null,null],[17,"CoherenceInherentImplOverlapCheck","","",null,null],[17,"CoherenceCheckTrait","","",null,null],[17,"PrivacyAccessLevels","","",null,null],[17,"MirConstQualif","","",null,null],[17,"MirBuilt","","",null,null],[17,"MirConst","","",null,null],[17,"MirValidated","","",null,null],[17,"MirOptimized","","",null,null],[17,"MirShim","","",null,null],[17,"BorrowCheckKrate","","",null,null],[17,"BorrowCheck","","",null,null],[17,"MirBorrowCheck","","",null,null],[17,"UnsafetyCheckResult","","",null,null],[17,"UnsafeDeriveOnReprPacked","","",null,null],[17,"Reachability","","",null,null],[17,"MirKeys","","",null,null],[17,"CrateVariances","","",null,null],[17,"AssociatedItems","","",null,null],[17,"TypeOfItem","","",null,null],[17,"GenericsOfItem","","",null,null],[17,"PredicatesOfItem","","",null,null],[17,"ExplicitPredicatesOfItem","","",null,null],[17,"InferredOutlivesOf","","",null,null],[17,"InferredOutlivesCrate","","",null,null],[17,"SuperPredicatesOfItem","","",null,null],[17,"TraitDefOfItem","","",null,null],[17,"AdtDefOfItem","","",null,null],[17,"ImplTraitRef","","",null,null],[17,"ImplPolarity","","",null,null],[17,"FnSignature","","",null,null],[17,"CoerceUnsizedInfo","","",null,null],[17,"ItemVarianceConstraints","","",null,null],[17,"ItemVariances","","",null,null],[17,"IsConstFn","","",null,null],[17,"IsForeignItem","","",null,null],[17,"TypeParamPredicates","","",null,null],[17,"SizedConstraint","","",null,null],[17,"DtorckConstraint","","",null,null],[17,"AdtDestructor","","",null,null],[17,"AssociatedItemDefIds","","",null,null],[17,"InherentImpls","","",null,null],[17,"TypeckBodiesKrate","","",null,null],[17,"TypeckTables","","",null,null],[17,"UsedTraitImports","","",null,null],[17,"HasTypeckTables","","",null,null],[17,"ConstEval","","",null,null],[17,"CheckMatch","","",null,null],[17,"SymbolName","","",null,null],[17,"InstanceSymbolName","","",null,null],[17,"SpecializationGraph","","",null,null],[17,"ObjectSafety","","",null,null],[17,"FulfillObligation","","",null,null],[17,"VtableMethods","","",null,null],[17,"IsCopy","","",null,null],[17,"IsSized","","",null,null],[17,"IsFreeze","","",null,null],[17,"NeedsDrop","","",null,null],[17,"Layout","","",null,null],[17,"TraitImpls","","",null,null],[17,"AllLocalTraitImpls","","",null,null],[17,"TraitSelect","","",null,null],[17,"ParamEnv","","",null,null],[17,"DescribeDef","","",null,null],[17,"DefSpan","","",null,null],[17,"LookupStability","","",null,null],[17,"LookupDeprecationEntry","","",null,null],[17,"ConstIsRvaluePromotableToStatic","","",null,null],[17,"RvaluePromotableMap","","",null,null],[17,"ImplParent","","",null,null],[17,"TraitOfItem","","",null,null],[17,"IsReachableNonGeneric","","",null,null],[17,"IsUnreachableLocalDefinition","","",null,null],[17,"IsMirAvailable","","",null,null],[17,"ItemAttrs","","",null,null],[17,"CodegenFnAttrs","","",null,null],[17,"FnArgNames","","",null,null],[17,"RenderedConst","","",null,null],[17,"DylibDepFormats","","",null,null],[17,"IsPanicRuntime","","",null,null],[17,"IsCompilerBuiltins","","",null,null],[17,"HasGlobalAllocator","","",null,null],[17,"ExternCrate","","",null,null],[17,"LintLevels","","",null,null],[17,"Specializes","","",null,null],[17,"InScopeTraits","","",null,null],[17,"ModuleExports","","",null,null],[17,"IsSanitizerRuntime","","",null,null],[17,"IsProfilerRuntime","","",null,null],[17,"GetPanicStrategy","","",null,null],[17,"IsNoBuiltins","","",null,null],[17,"ImplDefaultness","","",null,null],[17,"CheckItemWellFormed","","",null,null],[17,"CheckTraitItemWellFormed","","",null,null],[17,"CheckImplItemWellFormed","","",null,null],[17,"ReachableNonGenerics","","",null,null],[17,"NativeLibraries","","",null,null],[17,"PluginRegistrarFn","","",null,null],[17,"DeriveRegistrarFn","","",null,null],[17,"CrateDisambiguator","","",null,null],[17,"CrateHash","","",null,null],[17,"OriginalCrateName","","",null,null],[17,"ExtraFileName","","",null,null],[17,"ImplementationsOfTrait","","",null,null],[17,"AllTraitImplementations","","",null,null],[17,"DllimportForeignItems","","",null,null],[17,"IsDllimportForeignItem","","",null,null],[17,"IsStaticallyIncludedForeignItem","","",null,null],[17,"NativeLibraryKind","","",null,null],[17,"LinkArgs","","",null,null],[17,"ResolveLifetimes","","",null,null],[17,"NamedRegion","","",null,null],[17,"IsLateBound","","",null,null],[17,"ObjectLifetimeDefaults","","",null,null],[17,"Visibility","","",null,null],[17,"DepKind","","",null,null],[17,"CrateName","","",null,null],[17,"ItemChildren","","",null,null],[17,"ExternModStmtCnum","","",null,null],[17,"GetLangItems","","",null,null],[17,"DefinedLangItems","","",null,null],[17,"MissingLangItems","","",null,null],[17,"VisibleParentMap","","",null,null],[17,"MissingExternCrateItem","","",null,null],[17,"UsedCrateSource","","",null,null],[17,"PostorderCnums","","",null,null],[17,"EraseRegionsTy","","",null,null],[17,"ConstValueToAllocation","","",null,null],[17,"Freevars","","",null,null],[17,"MaybeUnusedTraitImport","","",null,null],[17,"MaybeUnusedExternCrates","","",null,null],[17,"StabilityIndex","","",null,null],[17,"AllTraits","","",null,null],[17,"AllCrateNums","","",null,null],[17,"ExportedSymbols","","",null,null],[17,"CollectAndPartitionMonoItems","","",null,null],[17,"IsCodegenedItem","","",null,null],[17,"CodegenUnit","","",null,null],[17,"CompileCodegenUnit","","",null,null],[17,"OutputFilenames","","",null,null],[17,"NormalizeProjectionTy","","",null,null],[17,"NormalizeTyAfterErasingRegions","","",null,null],[17,"DropckOutlives","","",null,null],[17,"EvaluateObligation","","",null,null],[17,"SubstituteNormalizeAndTestPredicates","","",null,null],[17,"TargetFeaturesWhitelist","","",null,null],[17,"InstanceDefSizeEstimate","","",null,null],[17,"WasmCustomSections","","",null,null],[17,"Features","","",null,null],[17,"ProgramClausesFor","","",null,null],[17,"ProgramClausesForEnv","","",null,null],[17,"WasmImportModuleMap","","",null,null],[17,"ForeignModules","","",null,null],[17,"UpstreamMonomorphizations","","",null,null],[17,"UpstreamMonomorphizationsFor","","",null,null],[8,"DepNodeParams","rustc::dep_graph::dep_node","",null,null],[18,"CAN_RECONSTRUCT_QUERY_KEY","","",26,null],[11,"to_fingerprint","","This method turns the parameters of a DepNodeConstructor into an opaque Fingerprint to be used in DepNode. Not all DepNodeParams support being turned into a Fingerprint (they don't need to if the corresponding DepNode is anonymous).",26,{"i":[{"n":"self"},{"n":"tyctxt"}],"o":{"n":"fingerprint"}}],[11,"to_debug_str","","",26,{"i":[{"n":"self"},{"n":"tyctxt"}],"o":{"n":"string"}}],[11,"fmt","rustc::dep_graph","",9,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fingerprint_needed_for_crate_hash","","",19,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"clone","","",19,{"i":[{"n":"self"}],"o":{"n":"depkind"}}],[11,"fmt","","",19,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"eq","","",19,{"i":[{"n":"self"},{"n":"depkind"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",19,null],[11,"partial_cmp","","",19,{"i":[{"n":"self"},{"n":"depkind"}],"o":{"g":["ordering"],"n":"option"}}],[11,"cmp","","",19,{"i":[{"n":"self"},{"n":"depkind"}],"o":{"n":"ordering"}}],[11,"hash","","",19,null],[11,"encode","","",19,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",19,{"i":[{"n":"__d"}],"o":{"g":["depkind"],"n":"result"}}],[11,"can_reconstruct_query_key","","",19,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"is_anon","","",19,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"is_input","","",19,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"is_eval_always","","",19,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"has_params","","",19,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"clone","","",9,{"i":[{"n":"self"}],"o":{"n":"depnode"}}],[11,"eq","","",9,{"i":[{"n":"self"},{"n":"depnode"}],"o":{"n":"bool"}}],[11,"ne","","",9,{"i":[{"n":"self"},{"n":"depnode"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",9,null],[11,"partial_cmp","","",9,{"i":[{"n":"self"},{"n":"depnode"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",9,{"i":[{"n":"self"},{"n":"depnode"}],"o":{"n":"bool"}}],[11,"le","","",9,{"i":[{"n":"self"},{"n":"depnode"}],"o":{"n":"bool"}}],[11,"gt","","",9,{"i":[{"n":"self"},{"n":"depnode"}],"o":{"n":"bool"}}],[11,"ge","","",9,{"i":[{"n":"self"},{"n":"depnode"}],"o":{"n":"bool"}}],[11,"cmp","","",9,{"i":[{"n":"self"},{"n":"depnode"}],"o":{"n":"ordering"}}],[11,"hash","","",9,null],[11,"encode","","",9,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",9,{"i":[{"n":"__d"}],"o":{"g":["depnode"],"n":"result"}}],[11,"new","","",9,{"i":[{"n":"tyctxt"},{"n":"depconstructor"}],"o":{"n":"depnode"}}],[11,"from_def_path_hash","","Construct a DepNode from the given DepKind and DefPathHash. This method will assert that the given DepKind actually requires a single DefId/DefPathHash parameter.",9,{"i":[{"n":"depkind"},{"n":"defpathhash"}],"o":{"n":"depnode"}}],[11,"new_no_params","","Create a new, parameterless DepNode. This method will assert that the DepNode corresponding to the given DepKind actually does not require any parameters.",9,{"i":[{"n":"depkind"}],"o":{"n":"depnode"}}],[11,"extract_def_id","","Extract the DefId corresponding to this DepNode. This will work if two conditions are met:",9,{"i":[{"n":"self"},{"n":"tyctxt"}],"o":{"g":["defid"],"n":"option"}}],[11,"from_label_string","","Used in testing",9,{"i":[{"n":"str"},{"n":"defpathhash"}],"o":{"g":["depnode"],"n":"result"}}],[11,"has_label_string","","Used in testing",9,{"i":[{"n":"str"}],"o":{"n":"bool"}}],[11,"clone","","",10,{"i":[{"n":"self"}],"o":{"n":"workproductid"}}],[11,"fmt","","",10,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"eq","","",10,{"i":[{"n":"self"},{"n":"workproductid"}],"o":{"n":"bool"}}],[11,"ne","","",10,{"i":[{"n":"self"},{"n":"workproductid"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",10,null],[11,"partial_cmp","","",10,{"i":[{"n":"self"},{"n":"workproductid"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",10,{"i":[{"n":"self"},{"n":"workproductid"}],"o":{"n":"bool"}}],[11,"le","","",10,{"i":[{"n":"self"},{"n":"workproductid"}],"o":{"n":"bool"}}],[11,"gt","","",10,{"i":[{"n":"self"},{"n":"workproductid"}],"o":{"n":"bool"}}],[11,"ge","","",10,{"i":[{"n":"self"},{"n":"workproductid"}],"o":{"n":"bool"}}],[11,"cmp","","",10,{"i":[{"n":"self"},{"n":"workproductid"}],"o":{"n":"ordering"}}],[11,"hash","","",10,null],[11,"encode","","",10,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",10,{"i":[{"n":"__d"}],"o":{"g":["workproductid"],"n":"result"}}],[11,"from_cgu_name","","",10,{"i":[{"n":"str"}],"o":{"n":"workproductid"}}],[11,"from_fingerprint","","",10,{"i":[{"n":"fingerprint"}],"o":{"n":"workproductid"}}],[11,"hash_stable","","",10,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[0,"dep_tracking_map","","",null,null],[3,"DepTrackingMap","rustc::dep_graph::dep_tracking_map","A DepTrackingMap offers a subset of the `Map` API and ensures that we make calls to `read` and `write` as appropriate. We key the maps with a unique type for brevity.",null,null],[12,"phantom","","",8,null],[12,"graph","","",8,null],[12,"map","","",8,null],[8,"DepTrackingMapConfig","","",null,null],[16,"Key","","",27,null],[16,"Value","","",27,null],[10,"to_dep_kind","","",27,{"o":{"n":"depkind"}}],[11,"new","rustc::dep_graph","",8,{"i":[{"n":"depgraph"}],"o":{"n":"deptrackingmap"}}],[0,"graph","","",null,null],[3,"DepGraph","rustc::dep_graph::graph","",null,null],[12,"data","","",11,null],[12,"fingerprints","","",11,null],[3,"DepNodeIndex","","",null,null],[12,"0","","",13,null],[3,"DepGraphData","","",null,null],[12,"current","","The new encoding of the dependency graph, optimized for red/green tracking. The `current` field is the dependency graph of only the current compilation session: We don't merge the previous dep-graph into current one anymore.",28,null],[12,"previous","","The dep-graph from the previous compilation session. It contains all nodes and edges as well as all fingerprints of nodes that have them.",28,null],[12,"colors","","",28,null],[12,"previous_work_products","","When we load, there may be `.o` files, cached mir, or other such things available to us. If we find that they are not dirty, we load the path to the file storing those work-products here into this map. We can later look for and extract that data.",28,null],[12,"dep_node_debug","","",28,null],[12,"loaded_from_cache","","",28,null],[3,"WorkProduct","","A \"work product\" is an intermediate result that we save into the incremental directory for later re-use. The primary example are the object files that we save for each partition at code generation time.",null,null],[12,"cgu_name","","",12,null],[12,"saved_files","","Saved files associated with this CGU",12,null],[3,"CurrentDepGraph","","",null,null],[12,"nodes","","",29,null],[12,"edges","","",29,null],[12,"node_to_node_index","","",29,null],[12,"forbidden_edge","","",29,null],[12,"anon_id_seed","","",29,null],[12,"total_read_count","","",29,null],[12,"total_duplicate_read_count","","",29,null],[3,"RegularOpenTask","","",null,null],[12,"node","","",30,null],[12,"reads","","",30,null],[12,"read_set","","",30,null],[3,"AnonOpenTask","","",null,null],[12,"reads","","",31,null],[12,"read_set","","",31,null],[3,"DepNodeColorMap","","",null,null],[12,"values","","",32,null],[4,"DepNodeColor","","",null,null],[13,"Red","","",21,null],[13,"Green","","",21,null],[4,"WorkProductFileKind","","",null,null],[13,"Object","","",23,null],[13,"Bytecode","","",23,null],[13,"BytecodeCompressed","","",23,null],[4,"OpenTask","","",null,null],[13,"Regular","","",22,null],[13,"Anon","","",22,null],[13,"Ignore","","",22,null],[13,"EvalAlways","","",22,null],[12,"node","rustc::dep_graph::graph::OpenTask","",22,null],[17,"COMPRESSED_NONE","rustc::dep_graph::graph","",null,null],[17,"COMPRESSED_RED","","",null,null],[17,"COMPRESSED_FIRST_GREEN","","",null,null],[11,"clone","rustc::dep_graph","",11,{"i":[{"n":"self"}],"o":{"n":"depgraph"}}],[11,"clone","","",13,{"i":[{"n":"self"}],"o":{"n":"depnodeindex"}}],[11,"eq","","",13,{"i":[{"n":"self"},{"n":"depnodeindex"}],"o":{"n":"bool"}}],[11,"ne","","",13,{"i":[{"n":"self"},{"n":"depnodeindex"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",13,null],[11,"hash","","",13,null],[11,"partial_cmp","","",13,{"i":[{"n":"self"},{"n":"depnodeindex"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",13,{"i":[{"n":"self"},{"n":"depnodeindex"}],"o":{"n":"bool"}}],[11,"le","","",13,{"i":[{"n":"self"},{"n":"depnodeindex"}],"o":{"n":"bool"}}],[11,"gt","","",13,{"i":[{"n":"self"},{"n":"depnodeindex"}],"o":{"n":"bool"}}],[11,"ge","","",13,{"i":[{"n":"self"},{"n":"depnodeindex"}],"o":{"n":"bool"}}],[11,"cmp","","",13,{"i":[{"n":"self"},{"n":"depnodeindex"}],"o":{"n":"ordering"}}],[11,"decode","","",13,{"i":[{"n":"__d"}],"o":{"g":["depnodeindex"],"n":"result"}}],[11,"encode","","",13,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"new","","",13,{"i":[{"n":"usize"}],"o":{"n":"self"}}],[11,"index","","",13,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"fmt","","",13,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[18,"INVALID","","",13,null],[11,"clone","","",21,{"i":[{"n":"self"}],"o":{"n":"depnodecolor"}}],[11,"fmt","","",21,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"eq","","",21,{"i":[{"n":"self"},{"n":"depnodecolor"}],"o":{"n":"bool"}}],[11,"ne","","",21,{"i":[{"n":"self"},{"n":"depnodecolor"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",21,null],[11,"hash","","",21,null],[11,"is_green","","",21,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"new","","",11,{"i":[{"n":"previousdepgraph"},{"g":["workproductid","workproduct"],"n":"fxhashmap"}],"o":{"n":"depgraph"}}],[11,"new_disabled","","",11,{"o":{"n":"depgraph"}}],[11,"is_fully_enabled","","True if we are actually building the full dep-graph.",11,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"query","","",11,{"i":[{"n":"self"}],"o":{"n":"depgraphquery"}}],[11,"assert_ignored","","",11,{"i":[{"n":"self"}]}],[11,"with_ignore","","",11,{"i":[{"n":"self"},{"n":"op"}],"o":{"n":"r"}}],[11,"with_task","","Starts a new dep-graph task. Dep-graph tasks are specified using a free function (`task`) and not a closure -- this is intentional because we want to exercise tight control over what state they have access to. In particular, we want to prevent implicit 'leaks' of tracked state into the task (which could then be read without generating correct edges in the dep-graph -- see the [rustc guide] for more details on the dep-graph). To this end, the task function gets exactly two pieces of state: the context `cx` and an argument `arg`. Both of these bits of state must be of some type that implements `DepGraphSafe` and hence does not leak.",11,null],[11,"input_task","","Creates a new dep-graph input with value `input`",11,null],[11,"with_task_impl","","",11,null],[11,"with_anon_task","","Execute something within an \"anonymous\" task, that is, a task the DepNode of which is determined by the list of inputs it read from.",11,null],[11,"with_eval_always_task","","Execute something within an \"eval-always\" task which is a task",11,null],[11,"read","","",11,{"i":[{"n":"self"},{"n":"depnode"}]}],[11,"read_index","","",11,{"i":[{"n":"self"},{"n":"depnodeindex"}]}],[11,"dep_node_index_of","","",11,{"i":[{"n":"self"},{"n":"depnode"}],"o":{"n":"depnodeindex"}}],[11,"dep_node_exists","","",11,{"i":[{"n":"self"},{"n":"depnode"}],"o":{"n":"bool"}}],[11,"fingerprint_of","","",11,{"i":[{"n":"self"},{"n":"depnodeindex"}],"o":{"n":"fingerprint"}}],[11,"prev_fingerprint_of","","",11,{"i":[{"n":"self"},{"n":"depnode"}],"o":{"g":["fingerprint"],"n":"option"}}],[11,"prev_dep_node_index_of","","",11,{"i":[{"n":"self"},{"n":"depnode"}],"o":{"n":"serializeddepnodeindex"}}],[11,"previous_work_product","","Check whether a previous work product exists for `v` and, if so, return the path that leads to it. Used to skip doing work.",11,{"i":[{"n":"self"},{"n":"workproductid"}],"o":{"g":["workproduct"],"n":"option"}}],[11,"previous_work_products","","Access the map of work-products created during the cached run. Only used during saving of the dep-graph.",11,{"i":[{"n":"self"}],"o":{"n":"fxhashmap"}}],[11,"register_dep_node_debug_str","","",11,{"i":[{"n":"self"},{"n":"depnode"},{"n":"f"}]}],[11,"dep_node_debug_str","","",11,{"i":[{"n":"self"},{"n":"depnode"}],"o":{"g":["string"],"n":"option"}}],[11,"edge_deduplication_data","","",11,null],[11,"serialize","","",11,{"i":[{"n":"self"}],"o":{"n":"serializeddepgraph"}}],[11,"node_color","","",11,{"i":[{"n":"self"},{"n":"depnode"}],"o":{"g":["depnodecolor"],"n":"option"}}],[11,"try_mark_green","","",11,{"i":[{"n":"self"},{"n":"tyctxt"},{"n":"depnode"}],"o":{"g":["depnodeindex"],"n":"option"}}],[11,"is_green","","",11,{"i":[{"n":"self"},{"n":"depnode"}],"o":{"n":"bool"}}],[11,"exec_cache_promotions","","",11,{"i":[{"n":"self"},{"n":"tyctxt"}]}],[11,"mark_loaded_from_cache","","",11,{"i":[{"n":"self"},{"n":"depnodeindex"},{"n":"bool"}]}],[11,"was_loaded_from_cache","","",11,{"i":[{"n":"self"},{"n":"depnode"}],"o":{"g":["bool"],"n":"option"}}],[11,"clone","","",12,{"i":[{"n":"self"}],"o":{"n":"workproduct"}}],[11,"fmt","","",12,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"encode","","",12,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",12,{"i":[{"n":"__d"}],"o":{"g":["workproduct"],"n":"result"}}],[11,"clone","","",23,{"i":[{"n":"self"}],"o":{"n":"workproductfilekind"}}],[11,"fmt","","",23,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"encode","","",23,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",23,{"i":[{"n":"__d"}],"o":{"g":["workproductfilekind"],"n":"result"}}],[11,"new","rustc::dep_graph::graph","",29,{"o":{"n":"currentdepgraph"}}],[11,"complete_task","","",29,{"i":[{"n":"self"},{"n":"depnode"},{"n":"opentask"}],"o":{"n":"depnodeindex"}}],[11,"pop_anon_task","","",29,{"i":[{"n":"self"},{"n":"depkind"},{"n":"opentask"}],"o":{"n":"depnodeindex"}}],[11,"complete_eval_always_task","","",29,{"i":[{"n":"self"},{"n":"depnode"},{"n":"opentask"}],"o":{"n":"depnodeindex"}}],[11,"read_index","","",29,{"i":[{"n":"self"},{"n":"depnodeindex"}]}],[11,"alloc_node","","",29,{"i":[{"n":"self"},{"n":"depnode"},{"n":"smallvec"}],"o":{"n":"depnodeindex"}}],[11,"new","","",32,{"i":[{"n":"usize"}],"o":{"n":"depnodecolormap"}}],[11,"get","","",32,{"i":[{"n":"self"},{"n":"serializeddepnodeindex"}],"o":{"g":["depnodecolor"],"n":"option"}}],[11,"insert","","",32,{"i":[{"n":"self"},{"n":"serializeddepnodeindex"},{"n":"depnodecolor"}]}],[0,"prev","rustc::dep_graph","",null,null],[3,"PreviousDepGraph","rustc::dep_graph::prev","",null,null],[12,"data","","",14,null],[12,"index","","",14,null],[11,"fmt","rustc::dep_graph","",14,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"encode","","",14,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",14,{"i":[{"n":"__d"}],"o":{"g":["previousdepgraph"],"n":"result"}}],[11,"new","","",14,{"i":[{"n":"serializeddepgraph"}],"o":{"n":"previousdepgraph"}}],[11,"edges_from","","",14,{"i":[{"n":"self"},{"n":"depnode"}],"o":{"n":"option"}}],[11,"index_to_node","","",14,{"i":[{"n":"self"},{"n":"serializeddepnodeindex"}],"o":{"n":"depnode"}}],[11,"node_to_index","","",14,{"i":[{"n":"self"},{"n":"depnode"}],"o":{"n":"serializeddepnodeindex"}}],[11,"node_to_index_opt","","",14,{"i":[{"n":"self"},{"n":"depnode"}],"o":{"g":["serializeddepnodeindex"],"n":"option"}}],[11,"fingerprint_of","","",14,{"i":[{"n":"self"},{"n":"depnode"}],"o":{"g":["fingerprint"],"n":"option"}}],[11,"fingerprint_by_index","","",14,{"i":[{"n":"self"},{"n":"serializeddepnodeindex"}],"o":{"n":"fingerprint"}}],[11,"node_count","","",14,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[0,"query","","",null,null],[3,"DepGraphQuery","rustc::dep_graph::query","",null,null],[12,"graph","","",15,null],[12,"indices","","",15,null],[11,"new","rustc::dep_graph","",15,null],[11,"contains_node","","",15,{"i":[{"n":"self"},{"n":"depnode"}],"o":{"n":"bool"}}],[11,"nodes","","",15,{"i":[{"n":"self"}],"o":{"g":["depnode"],"n":"vec"}}],[11,"edges","","",15,{"i":[{"n":"self"}],"o":{"n":"vec"}}],[11,"reachable_nodes","","",15,{"i":[{"n":"self"},{"n":"depnode"},{"n":"direction"}],"o":{"g":["depnode"],"n":"vec"}}],[11,"transitive_successors","","All nodes reachable from `node`. In other words, things that will have to be recomputed if `node` changes.",15,{"i":[{"n":"self"},{"n":"depnode"}],"o":{"g":["depnode"],"n":"vec"}}],[11,"transitive_predecessors","","All nodes that can reach `node`.",15,{"i":[{"n":"self"},{"n":"depnode"}],"o":{"g":["depnode"],"n":"vec"}}],[11,"immediate_successors","","Just the outgoing edges from `node`.",15,{"i":[{"n":"self"},{"n":"depnode"}],"o":{"g":["depnode"],"n":"vec"}}],[0,"safe","","The `DepGraphSafe` trait",null,null],[3,"AssertDepGraphSafe","rustc::dep_graph::safe","A convenient override that lets you pass arbitrary state into a task. Every use should be accompanied by a comment explaining why it makes sense (or how it could be refactored away in the future).",null,null],[12,"0","","",16,null],[8,"DepGraphSafe","","The `DepGraphSafe` trait is used to specify what kinds of values are safe to \"leak\" into a task. The idea is that this should be only be implemented for things like the tcx as well as various id types, which will create reads in the dep-graph whenever the trait loads anything that might depend on the input program.",null,null],[0,"serialized","rustc::dep_graph","The data that we will serialize and deserialize.",null,null],[3,"SerializedDepNodeIndex","rustc::dep_graph::serialized","",null,null],[12,"0","","",18,null],[3,"SerializedDepGraph","","Data for use when recompiling the current crate.",null,null],[12,"nodes","","The set of all DepNodes in the graph",17,null],[12,"fingerprints","","The set of all Fingerprints in the graph. Each Fingerprint corresponds to the DepNode at the same index in the nodes vector.",17,null],[12,"edge_list_indices","","For each DepNode, stores the list of edges originating from that DepNode. Encoded as a [start, end) pair indexing into edge_list_data, which holds the actual DepNodeIndices of the target nodes.",17,null],[12,"edge_list_data","","A flattened list of all edge targets in the graph. Edge sources are implicit in edge_list_indices.",17,null],[11,"clone","rustc::dep_graph","",18,{"i":[{"n":"self"}],"o":{"n":"serializeddepnodeindex"}}],[11,"eq","","",18,{"i":[{"n":"self"},{"n":"serializeddepnodeindex"}],"o":{"n":"bool"}}],[11,"ne","","",18,{"i":[{"n":"self"},{"n":"serializeddepnodeindex"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",18,null],[11,"hash","","",18,null],[11,"partial_cmp","","",18,{"i":[{"n":"self"},{"n":"serializeddepnodeindex"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",18,{"i":[{"n":"self"},{"n":"serializeddepnodeindex"}],"o":{"n":"bool"}}],[11,"le","","",18,{"i":[{"n":"self"},{"n":"serializeddepnodeindex"}],"o":{"n":"bool"}}],[11,"gt","","",18,{"i":[{"n":"self"},{"n":"serializeddepnodeindex"}],"o":{"n":"bool"}}],[11,"ge","","",18,{"i":[{"n":"self"},{"n":"serializeddepnodeindex"}],"o":{"n":"bool"}}],[11,"cmp","","",18,{"i":[{"n":"self"},{"n":"serializeddepnodeindex"}],"o":{"n":"ordering"}}],[11,"decode","","",18,{"i":[{"n":"__d"}],"o":{"g":["serializeddepnodeindex"],"n":"result"}}],[11,"encode","","",18,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"new","","",18,{"i":[{"n":"usize"}],"o":{"n":"self"}}],[11,"index","","",18,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"fmt","","",18,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",17,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"encode","","",17,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",17,{"i":[{"n":"__d"}],"o":{"g":["serializeddepgraph"],"n":"result"}}],[11,"new","","",17,{"o":{"n":"serializeddepgraph"}}],[11,"edge_targets_from","","",17,null],[0,"label_strs","","Contains variant => str representations for constructing DepNode groups for tests.",null,null],[17,"Null","rustc::dep_graph::label_strs","",null,null],[17,"Krate","","",null,null],[17,"HirBody","","",null,null],[17,"Hir","","",null,null],[17,"CrateMetadata","","",null,null],[17,"RegionScopeTree","","",null,null],[17,"Coherence","","",null,null],[17,"CoherenceInherentImplOverlapCheck","","",null,null],[17,"CoherenceCheckTrait","","",null,null],[17,"PrivacyAccessLevels","","",null,null],[17,"MirConstQualif","","",null,null],[17,"MirBuilt","","",null,null],[17,"MirConst","","",null,null],[17,"MirValidated","","",null,null],[17,"MirOptimized","","",null,null],[17,"MirShim","","",null,null],[17,"BorrowCheckKrate","","",null,null],[17,"BorrowCheck","","",null,null],[17,"MirBorrowCheck","","",null,null],[17,"UnsafetyCheckResult","","",null,null],[17,"UnsafeDeriveOnReprPacked","","",null,null],[17,"Reachability","","",null,null],[17,"MirKeys","","",null,null],[17,"CrateVariances","","",null,null],[17,"AssociatedItems","","",null,null],[17,"TypeOfItem","","",null,null],[17,"GenericsOfItem","","",null,null],[17,"PredicatesOfItem","","",null,null],[17,"ExplicitPredicatesOfItem","","",null,null],[17,"InferredOutlivesOf","","",null,null],[17,"InferredOutlivesCrate","","",null,null],[17,"SuperPredicatesOfItem","","",null,null],[17,"TraitDefOfItem","","",null,null],[17,"AdtDefOfItem","","",null,null],[17,"ImplTraitRef","","",null,null],[17,"ImplPolarity","","",null,null],[17,"FnSignature","","",null,null],[17,"CoerceUnsizedInfo","","",null,null],[17,"ItemVarianceConstraints","","",null,null],[17,"ItemVariances","","",null,null],[17,"IsConstFn","","",null,null],[17,"IsForeignItem","","",null,null],[17,"TypeParamPredicates","","",null,null],[17,"SizedConstraint","","",null,null],[17,"DtorckConstraint","","",null,null],[17,"AdtDestructor","","",null,null],[17,"AssociatedItemDefIds","","",null,null],[17,"InherentImpls","","",null,null],[17,"TypeckBodiesKrate","","",null,null],[17,"TypeckTables","","",null,null],[17,"UsedTraitImports","","",null,null],[17,"HasTypeckTables","","",null,null],[17,"ConstEval","","",null,null],[17,"CheckMatch","","",null,null],[17,"SymbolName","","",null,null],[17,"InstanceSymbolName","","",null,null],[17,"SpecializationGraph","","",null,null],[17,"ObjectSafety","","",null,null],[17,"FulfillObligation","","",null,null],[17,"VtableMethods","","",null,null],[17,"IsCopy","","",null,null],[17,"IsSized","","",null,null],[17,"IsFreeze","","",null,null],[17,"NeedsDrop","","",null,null],[17,"Layout","","",null,null],[17,"TraitImpls","","",null,null],[17,"AllLocalTraitImpls","","",null,null],[17,"TraitSelect","","",null,null],[17,"ParamEnv","","",null,null],[17,"DescribeDef","","",null,null],[17,"DefSpan","","",null,null],[17,"LookupStability","","",null,null],[17,"LookupDeprecationEntry","","",null,null],[17,"ConstIsRvaluePromotableToStatic","","",null,null],[17,"RvaluePromotableMap","","",null,null],[17,"ImplParent","","",null,null],[17,"TraitOfItem","","",null,null],[17,"IsReachableNonGeneric","","",null,null],[17,"IsUnreachableLocalDefinition","","",null,null],[17,"IsMirAvailable","","",null,null],[17,"ItemAttrs","","",null,null],[17,"CodegenFnAttrs","","",null,null],[17,"FnArgNames","","",null,null],[17,"RenderedConst","","",null,null],[17,"DylibDepFormats","","",null,null],[17,"IsPanicRuntime","","",null,null],[17,"IsCompilerBuiltins","","",null,null],[17,"HasGlobalAllocator","","",null,null],[17,"ExternCrate","","",null,null],[17,"LintLevels","","",null,null],[17,"Specializes","","",null,null],[17,"InScopeTraits","","",null,null],[17,"ModuleExports","","",null,null],[17,"IsSanitizerRuntime","","",null,null],[17,"IsProfilerRuntime","","",null,null],[17,"GetPanicStrategy","","",null,null],[17,"IsNoBuiltins","","",null,null],[17,"ImplDefaultness","","",null,null],[17,"CheckItemWellFormed","","",null,null],[17,"CheckTraitItemWellFormed","","",null,null],[17,"CheckImplItemWellFormed","","",null,null],[17,"ReachableNonGenerics","","",null,null],[17,"NativeLibraries","","",null,null],[17,"PluginRegistrarFn","","",null,null],[17,"DeriveRegistrarFn","","",null,null],[17,"CrateDisambiguator","","",null,null],[17,"CrateHash","","",null,null],[17,"OriginalCrateName","","",null,null],[17,"ExtraFileName","","",null,null],[17,"ImplementationsOfTrait","","",null,null],[17,"AllTraitImplementations","","",null,null],[17,"DllimportForeignItems","","",null,null],[17,"IsDllimportForeignItem","","",null,null],[17,"IsStaticallyIncludedForeignItem","","",null,null],[17,"NativeLibraryKind","","",null,null],[17,"LinkArgs","","",null,null],[17,"ResolveLifetimes","","",null,null],[17,"NamedRegion","","",null,null],[17,"IsLateBound","","",null,null],[17,"ObjectLifetimeDefaults","","",null,null],[17,"Visibility","","",null,null],[17,"DepKind","","",null,null],[17,"CrateName","","",null,null],[17,"ItemChildren","","",null,null],[17,"ExternModStmtCnum","","",null,null],[17,"GetLangItems","","",null,null],[17,"DefinedLangItems","","",null,null],[17,"MissingLangItems","","",null,null],[17,"VisibleParentMap","","",null,null],[17,"MissingExternCrateItem","","",null,null],[17,"UsedCrateSource","","",null,null],[17,"PostorderCnums","","",null,null],[17,"EraseRegionsTy","","",null,null],[17,"ConstValueToAllocation","","",null,null],[17,"Freevars","","",null,null],[17,"MaybeUnusedTraitImport","","",null,null],[17,"MaybeUnusedExternCrates","","",null,null],[17,"StabilityIndex","","",null,null],[17,"AllTraits","","",null,null],[17,"AllCrateNums","","",null,null],[17,"ExportedSymbols","","",null,null],[17,"CollectAndPartitionMonoItems","","",null,null],[17,"IsCodegenedItem","","",null,null],[17,"CodegenUnit","","",null,null],[17,"CompileCodegenUnit","","",null,null],[17,"OutputFilenames","","",null,null],[17,"NormalizeProjectionTy","","",null,null],[17,"NormalizeTyAfterErasingRegions","","",null,null],[17,"DropckOutlives","","",null,null],[17,"EvaluateObligation","","",null,null],[17,"SubstituteNormalizeAndTestPredicates","","",null,null],[17,"TargetFeaturesWhitelist","","",null,null],[17,"InstanceDefSizeEstimate","","",null,null],[17,"WasmCustomSections","","",null,null],[17,"Features","","",null,null],[17,"ProgramClausesFor","","",null,null],[17,"ProgramClausesForEnv","","",null,null],[17,"WasmImportModuleMap","","",null,null],[17,"ForeignModules","","",null,null],[17,"UpstreamMonomorphizations","","",null,null],[17,"UpstreamMonomorphizationsFor","","",null,null],[8,"DepTrackingMapConfig","rustc::dep_graph","",null,null],[16,"Key","","",27,null],[16,"Value","","",27,null],[10,"to_dep_kind","","",27,{"o":{"n":"depkind"}}],[8,"DepGraphSafe","","The `DepGraphSafe` trait is used to specify what kinds of values are safe to \"leak\" into a task. The idea is that this should be only be implemented for things like the tcx as well as various id types, which will create reads in the dep-graph whenever the trait loads anything that might depend on the input program.",null,null],[0,"hir","rustc","",null,null],[3,"HirId","rustc::hir","A HirId uniquely identifies a node in the HIR of the current crate. It is composed of the `owner`, which is the DefIndex of the directly enclosing hir::Item, hir::TraitItem, or hir::ImplItem (i.e. the closest \"item-like\"), and the `local_id` which is unique within the given owner.",null,null],[12,"owner","","",33,null],[12,"local_id","","",33,null],[3,"ItemLocalId","","An `ItemLocalId` uniquely identifies something within a given \"item-like\", that is within a hir::Item, hir::TraitItem, or hir::ImplItem. There is no guarantee that the numerical value of a given `ItemLocalId` corresponds to the node's position within the owning item in any way, but there is a guarantee that the `LocalItemId`s within an owner occupy a dense range of integers starting at zero, so a mapping that maps all or most nodes within an \"item-like\" to something else can be implement by a `Vec` instead of a tree or hash map.",null,null],[12,"0","","",34,null],[3,"Label","","",null,null],[12,"name","","",35,null],[12,"span","","",35,null],[3,"Lifetime","","",null,null],[12,"id","","",36,null],[12,"span","","",36,null],[12,"name","","Either \"'a\", referring to a named lifetime definition, or \"\" (aka keywords::Invalid), for elision placeholders.",36,null],[3,"LifetimeDef","","A lifetime definition, eg `'a: 'b+'c+'d`",null,null],[12,"lifetime","","",37,null],[12,"bounds","","",37,null],[12,"pure_wrt_drop","","",37,null],[12,"in_band","","",37,null],[3,"Path","","A \"Path\" is essentially Rust's notion of a name; for instance: `std::cmp::PartialEq`. It's represented as a sequence of identifiers, along with a bunch of supporting information.",null,null],[12,"span","","",38,null],[12,"def","","The definition that the path resolved to.",38,null],[12,"segments","","The segments in the path: the things separated by `::`.",38,null],[3,"PathSegment","","A segment of a path: an identifier, an optional lifetime, and a set of types.",null,null],[12,"name","","The identifier portion of this path segment.",39,null],[12,"parameters","","Type/lifetime parameters attached to this path. They come in two flavors: `Path<A,B,C>` and `Path(A,B) -> C`. Note that this is more than just simple syntactic sugar; the use of parens affects the region binding rules, so we preserve the distinction.",39,null],[12,"infer_types","","Whether to infer remaining type parameters, if any. This only applies to expression and pattern paths, and out of those only the segments with no type parameters to begin with, e.g. `Vec::new` is `<Vec<..>>::new::<..>`.",39,null],[3,"PathParameters","","",null,null],[12,"lifetimes","","The lifetime parameters for this path segment.",40,null],[12,"types","","The type parameters for this path segment, if present.",40,null],[12,"bindings","","Bindings (equality constraints) on associated types, if present. E.g., `Foo<A=Bar>`.",40,null],[12,"parenthesized","","Were parameters written in parenthesized form `Fn(T) -> U`? This is required mostly for pretty-printing and diagnostics, but also for changing lifetime elision rules to be \"function-like\".",40,null],[3,"TyParam","","",null,null],[12,"name","","",41,null],[12,"id","","",41,null],[12,"bounds","","",41,null],[12,"default","","",41,null],[12,"span","","",41,null],[12,"pure_wrt_drop","","",41,null],[12,"synthetic","","",41,null],[12,"attrs","","",41,null],[3,"Generics","","Represents lifetimes and type parameters attached to a declaration of a function, enum, trait, etc.",null,null],[12,"params","","",42,null],[12,"where_clause","","",42,null],[12,"span","","",42,null],[3,"WhereClause","","A `where` clause in a definition",null,null],[12,"id","","",43,null],[12,"predicates","","",43,null],[3,"WhereBoundPredicate","","A type bound, eg `for<'c> Foo: Send+Clone+'c`",null,null],[12,"span","","",44,null],[12,"bound_generic_params","","Any generics from a `for` binding",44,null],[12,"bounded_ty","","The type being bounded",44,null],[12,"bounds","","Trait and lifetime bounds (`Clone+Send+'static`)",44,null],[3,"WhereRegionPredicate","","A lifetime predicate, e.g. `'a: 'b+'c`",null,null],[12,"span","","",45,null],[12,"lifetime","","",45,null],[12,"bounds","","",45,null],[3,"WhereEqPredicate","","An equality predicate (unsupported), e.g. `T=int`",null,null],[12,"id","","",46,null],[12,"span","","",46,null],[12,"lhs_ty","","",46,null],[12,"rhs_ty","","",46,null],[3,"Crate","","The top-level data structure that stores the entire contents of the crate currently being compiled.",null,null],[12,"module","","",47,null],[12,"attrs","","",47,null],[12,"span","","",47,null],[12,"exported_macros","","",47,null],[12,"items","","",47,null],[12,"trait_items","","",47,null],[12,"impl_items","","",47,null],[12,"bodies","","",47,null],[12,"trait_impls","","",47,null],[12,"trait_auto_impl","","",47,null],[12,"body_ids","","A list of the body ids written out in the order in which they appear in the crate. If you're going to process all the bodies in the crate, you should iterate over this list rather than the keys of bodies.",47,null],[3,"MacroDef","","A macro definition, in this crate or imported from another.",null,null],[12,"name","","",48,null],[12,"vis","","",48,null],[12,"attrs","","",48,null],[12,"id","","",48,null],[12,"span","","",48,null],[12,"body","","",48,null],[12,"legacy","","",48,null],[3,"Block","","",null,null],[12,"stmts","","Statements in a block",49,null],[12,"expr","","An expression at the end of the block without a semicolon, if any",49,null],[12,"id","","",49,null],[12,"hir_id","","",49,null],[12,"rules","","Distinguishes between `unsafe { ... }` and `{ ... }`",49,null],[12,"span","","",49,null],[12,"targeted_by_break","","If true, then there may exist `break 'a` values that aim to break out of this block early. Used by `'label: {}` blocks and by `catch` statements.",49,null],[12,"recovered","","If true, don't emit return value type errors as the parser had to recover from a parse error so this block will not have an appropriate type. A parse error will have been emitted so the compilation will never succeed if this is true.",49,null],[3,"Pat","","",null,null],[12,"id","","",50,null],[12,"hir_id","","",50,null],[12,"node","","",50,null],[12,"span","","",50,null],[3,"FieldPat","","A single field in a struct pattern",null,null],[12,"id","","",51,null],[12,"ident","","The identifier for the field",51,null],[12,"pat","","The pattern the field is destructured to",51,null],[12,"is_shorthand","","",51,null],[3,"Local","","Local represents a `let` statement, e.g., `let <pat>:<ty> = <expr>;`",null,null],[12,"pat","","",52,null],[12,"ty","","",52,null],[12,"init","","Initializer expression to set the value, if any",52,null],[12,"id","","",52,null],[12,"hir_id","","",52,null],[12,"span","","",52,null],[12,"attrs","","",52,null],[12,"source","","",52,null],[3,"Arm","","represents one arm of a 'match'",null,null],[12,"attrs","","",53,null],[12,"pats","","",53,null],[12,"guard","","",53,null],[12,"body","","",53,null],[3,"Field","","",null,null],[12,"id","","",54,null],[12,"ident","","",54,null],[12,"expr","","",54,null],[12,"span","","",54,null],[12,"is_shorthand","","",54,null],[3,"BodyId","","",null,null],[12,"node_id","","",55,null],[3,"Body","","The body of a function, closure, or constant value. In the case of a function, the body contains not only the function body itself (which is an expression), but also the argument patterns, since those are something that the caller doesn't really care about.",null,null],[12,"arguments","","",56,null],[12,"value","","",56,null],[12,"is_generator","","",56,null],[3,"AnonConst","","A constant (expression) that's not an item or associated item, but needs its own `DefId` for type-checking, const-eval, etc. These are usually found nested inside types (e.g. array lengths) or expressions (e.g. repeat counts), and also used to define explicit discriminant values for enum variants.",null,null],[12,"id","","",57,null],[12,"hir_id","","",57,null],[12,"body","","",57,null],[3,"Expr","","An expression",null,null],[12,"id","","",58,null],[12,"span","","",58,null],[12,"node","","",58,null],[12,"attrs","","",58,null],[12,"hir_id","","",58,null],[3,"Destination","","",null,null],[12,"label","","",59,null],[12,"target_id","","",59,null],[3,"MutTy","","",null,null],[12,"ty","","",60,null],[12,"mutbl","","",60,null],[3,"MethodSig","","Represents a method's signature in a trait declaration or implementation.",null,null],[12,"unsafety","","",61,null],[12,"constness","","",61,null],[12,"abi","","",61,null],[12,"decl","","",61,null],[3,"TraitItemId","","",null,null],[12,"node_id","","",62,null],[3,"TraitItem","","Represents an item declaration within a trait declaration, possibly including a default implementation. A trait item is either required (meaning it doesn't have an implementation, just a signature) or provided (meaning it has a default implementation).",null,null],[12,"id","","",63,null],[12,"name","","",63,null],[12,"hir_id","","",63,null],[12,"attrs","","",63,null],[12,"generics","","",63,null],[12,"node","","",63,null],[12,"span","","",63,null],[3,"ImplItemId","","",null,null],[12,"node_id","","",64,null],[3,"ImplItem","","Represents anything within an `impl` block",null,null],[12,"id","","",65,null],[12,"name","","",65,null],[12,"hir_id","","",65,null],[12,"vis","","",65,null],[12,"defaultness","","",65,null],[12,"attrs","","",65,null],[12,"generics","","",65,null],[12,"node","","",65,null],[12,"span","","",65,null],[3,"TypeBinding","","",null,null],[12,"id","","",66,null],[12,"name","","",66,null],[12,"ty","","",66,null],[12,"span","","",66,null],[3,"Ty","","",null,null],[12,"id","","",67,null],[12,"node","","",67,null],[12,"span","","",67,null],[12,"hir_id","","",67,null],[3,"BareFnTy","","",null,null],[12,"unsafety","","",68,null],[12,"abi","","",68,null],[12,"generic_params","","",68,null],[12,"decl","","",68,null],[12,"arg_names","","",68,null],[3,"ExistTy","","",null,null],[12,"generics","","",69,null],[12,"bounds","","",69,null],[12,"impl_trait_fn","","",69,null],[3,"InlineAsmOutput","","",null,null],[12,"constraint","","",70,null],[12,"is_rw","","",70,null],[12,"is_indirect","","",70,null],[3,"InlineAsm","","",null,null],[12,"asm","","",71,null],[12,"asm_str_style","","",71,null],[12,"outputs","","",71,null],[12,"inputs","","",71,null],[12,"clobbers","","",71,null],[12,"volatile","","",71,null],[12,"alignstack","","",71,null],[12,"dialect","","",71,null],[12,"ctxt","","",71,null],[3,"Arg","","represents an argument in a function header",null,null],[12,"pat","","",72,null],[12,"id","","",72,null],[12,"hir_id","","",72,null],[3,"FnDecl","","Represents the header (not the body) of a function declaration",null,null],[12,"inputs","","",73,null],[12,"output","","",73,null],[12,"variadic","","",73,null],[12,"has_implicit_self","","True if this function has an `self`, `&self` or `&mut self` receiver (but not a `self: Xxx` one).",73,null],[3,"Mod","","",null,null],[12,"inner","","A span from the first token past `{` to the last token until `}`. For `mod foo;`, the inner span ranges from the first token to the last token in the external file.",74,null],[12,"item_ids","","",74,null],[3,"ForeignMod","","",null,null],[12,"abi","","",75,null],[12,"items","","",75,null],[3,"GlobalAsm","","",null,null],[12,"asm","","",76,null],[12,"ctxt","","",76,null],[3,"EnumDef","","",null,null],[12,"variants","","",77,null],[3,"Variant_","","",null,null],[12,"name","","",78,null],[12,"attrs","","",78,null],[12,"data","","",78,null],[12,"disr_expr","","Explicit discriminant, eg `Foo = 1`",78,null],[3,"TraitRef","","TraitRef's appear in impls.",null,null],[12,"path","","",79,null],[12,"ref_id","","",79,null],[3,"PolyTraitRef","","",null,null],[12,"bound_generic_params","","The `'a` in `<'a> Foo<&'a T>`",80,null],[12,"trait_ref","","The `Foo<&'a T>` in `<'a> Foo<&'a T>`",80,null],[12,"span","","",80,null],[3,"StructField","","",null,null],[12,"span","","",81,null],[12,"ident","","",81,null],[12,"vis","","",81,null],[12,"id","","",81,null],[12,"ty","","",81,null],[12,"attrs","","",81,null],[3,"ItemId","","",null,null],[12,"id","","",82,null],[3,"Item","","An item",null,null],[12,"name","","",83,null],[12,"id","","",83,null],[12,"hir_id","","",83,null],[12,"attrs","","",83,null],[12,"node","","",83,null],[12,"vis","","",83,null],[12,"span","","",83,null],[3,"TraitItemRef","","A reference from an trait to one of its associated items. This contains the item's id, naturally, but also the item's name and some other high-level details (like whether it is an associated type or method, and whether it is public). This allows other passes to find the impl they want without loading the id (which means fewer edges in the incremental compilation graph).",null,null],[12,"id","","",84,null],[12,"name","","",84,null],[12,"kind","","",84,null],[12,"span","","",84,null],[12,"defaultness","","",84,null],[3,"ImplItemRef","","A reference from an impl to one of its associated items. This contains the item's id, naturally, but also the item's name and some other high-level details (like whether it is an associated type or method, and whether it is public). This allows other passes to find the impl they want without loading the id (which means fewer edges in the incremental compilation graph).",null,null],[12,"id","","",85,null],[12,"name","","",85,null],[12,"kind","","",85,null],[12,"span","","",85,null],[12,"vis","","",85,null],[12,"defaultness","","",85,null],[3,"ForeignItem","","",null,null],[12,"name","","",86,null],[12,"attrs","","",86,null],[12,"node","","",86,null],[12,"id","","",86,null],[12,"span","","",86,null],[12,"vis","","",86,null],[3,"Freevar","","A free variable referred to in a function.",null,null],[12,"def","","The variable being accessed free.",87,null],[12,"span","","",87,null],[3,"TraitCandidate","","",null,null],[12,"def_id","","",88,null],[12,"import_id","","",88,null],[3,"CodegenFnAttrs","","",null,null],[12,"flags","","",89,null],[12,"inline","","",89,null],[12,"export_name","","",89,null],[12,"target_features","","",89,null],[12,"linkage","","",89,null],[3,"CodegenFnAttrFlags","","",null,null],[12,"bits","","",90,null],[4,"LifetimeName","","",null,null],[13,"Implicit","","User typed nothing. e.g. the lifetime in `&u32`.",91,null],[13,"Underscore","","User typed `'_`.",91,null],[13,"Fresh","","Synthetic name generated when user elided a lifetime in an impl header, e.g. the lifetimes in cases like these:",91,null],[13,"Static","","User wrote `'static`",91,null],[13,"Name","","Some user-given name like `'x`",91,null],[4,"TyParamBound","","The AST represents all type param bounds as types. typeck::collect::compute_bounds matches these against the \"special\" built-in traits (see middle::lang_items) and detects Copy, Send and Sync.",null,null],[13,"TraitTyParamBound","","",92,null],[13,"RegionTyParamBound","","",92,null],[4,"TraitBoundModifier","","A modifier on a bound, currently this is only used for `?Sized`, where the modifier is `Maybe`. Negative bounds should also be handled here.",null,null],[13,"None","","",93,null],[13,"Maybe","","",93,null],[4,"GenericParam","","",null,null],[13,"Lifetime","","",94,null],[13,"Type","","",94,null],[4,"UnsafeGeneric","","",null,null],[13,"Region","","",95,null],[13,"Type","","",95,null],[4,"SyntheticTyParamKind","","Synthetic Type Parameters are converted to an other form during lowering, this allows to track the original form they had. Useful for error messages.",null,null],[13,"ImplTrait","","",96,null],[4,"WherePredicate","","A single predicate in a `where` clause",null,null],[13,"BoundPredicate","","A type binding, eg `for<'c> Foo: Send+Clone+'c`",97,null],[13,"RegionPredicate","","A lifetime predicate, e.g. `'a: 'b+'c`",97,null],[13,"EqPredicate","","An equality predicate (unsupported)",97,null],[4,"BindingAnnotation","","Explicit binding annotations given in the HIR for a binding. Note that this is not the final binding mode that we infer after type inference.",null,null],[13,"Unannotated","","No binding annotation given: this means that the final binding mode will depend on whether we have skipped through a `&` reference when matching. For example, the `x` in `Some(x)` will have binding mode `None`; if you do `let Some(x) = &Some(22)`, it will ultimately be inferred to be by-reference.",98,null],[13,"Mutable","","Annotated with `mut x` -- could be either ref or not, similar to `None`.",98,null],[13,"Ref","","Annotated as `ref`, like `ref x`",98,null],[13,"RefMut","","Annotated as `ref mut x`.",98,null],[4,"RangeEnd","","",null,null],[13,"Included","","",99,null],[13,"Excluded","","",99,null],[4,"PatKind","","",null,null],[13,"Wild","","Represents a wildcard pattern (`_`)",100,null],[13,"Binding","","A fresh binding `ref mut binding @ OPT_SUBPATTERN`. The `NodeId` is the canonical ID for the variable being bound, e.g. in `Ok(x) | Err(x)`, both `x` use the same canonical ID, which is the pattern ID of the first `x`.",100,null],[13,"Struct","","A struct or struct variant pattern, e.g. `Variant {x, y, ..}`. The `bool` is `true` in the presence of a `..`.",100,null],[13,"TupleStruct","","A tuple struct/variant pattern `Variant(x, y, .., z)`. If the `..` pattern fragment is present, then `Option<usize>` denotes its position. 0 <= position <= subpats.len()",100,null],[13,"Path","","A path pattern for an unit struct/variant or a (maybe-associated) constant.",100,null],[13,"Tuple","","A tuple pattern `(a, b)`. If the `..` pattern fragment is present, then `Option<usize>` denotes its position. 0 <= position <= subpats.len()",100,null],[13,"Box","","A `box` pattern",100,null],[13,"Ref","","A reference pattern, e.g. `&mut (a, b)`",100,null],[13,"Lit","","A literal",100,null],[13,"Range","","A range pattern, e.g. `1...2` or `1..2`",100,null],[13,"Slice","","`[a, b, ..i, y, z]` is represented as: `PatKind::Slice(box [a, b], Some(i), box [y, z])`",100,null],[4,"Mutability","","",null,null],[13,"MutMutable","","",101,null],[13,"MutImmutable","","",101,null],[4,"BinOp_","","",null,null],[13,"BiAdd","","The `+` operator (addition)",102,null],[13,"BiSub","","The `-` operator (subtraction)",102,null],[13,"BiMul","","The `*` operator (multiplication)",102,null],[13,"BiDiv","","The `/` operator (division)",102,null],[13,"BiRem","","The `%` operator (modulus)",102,null],[13,"BiAnd","","The `&&` operator (logical and)",102,null],[13,"BiOr","","The `||` operator (logical or)",102,null],[13,"BiBitXor","","The `^` operator (bitwise xor)",102,null],[13,"BiBitAnd","","The `&` operator (bitwise and)",102,null],[13,"BiBitOr","","The `|` operator (bitwise or)",102,null],[13,"BiShl","","The `<<` operator (shift left)",102,null],[13,"BiShr","","The `>>` operator (shift right)",102,null],[13,"BiEq","","The `==` operator (equality)",102,null],[13,"BiLt","","The `<` operator (less than)",102,null],[13,"BiLe","","The `<=` operator (less than or equal to)",102,null],[13,"BiNe","","The `!=` operator (not equal to)",102,null],[13,"BiGe","","The `>=` operator (greater than or equal to)",102,null],[13,"BiGt","","The `>` operator (greater than)",102,null],[4,"UnOp","","",null,null],[13,"UnDeref","","The `*` operator for dereferencing",103,null],[13,"UnNot","","The `!` operator for logical inversion",103,null],[13,"UnNeg","","The `-` operator for negation",103,null],[4,"Stmt_","","",null,null],[13,"StmtDecl","","Could be an item or a local (let) binding:",104,null],[13,"StmtExpr","","Expr without trailing semi-colon (must have unit type):",104,null],[13,"StmtSemi","","Expr with trailing semi-colon (may have any type):",104,null],[4,"Decl_","","",null,null],[13,"DeclLocal","","A local (let) binding:",105,null],[13,"DeclItem","","An item binding:",105,null],[4,"BlockCheckMode","","",null,null],[13,"DefaultBlock","","",106,null],[13,"UnsafeBlock","","",106,null],[13,"PushUnsafeBlock","","",106,null],[13,"PopUnsafeBlock","","",106,null],[4,"UnsafeSource","","",null,null],[13,"CompilerGenerated","","",107,null],[13,"UserProvided","","",107,null],[4,"BodyOwnerKind","","",null,null],[13,"Fn","","Functions and methods.",108,null],[13,"Const","","Constants and associated constants.",108,null],[13,"Static","","Initializer of a `static` item.",108,null],[4,"Expr_","","",null,null],[13,"ExprBox","","A `box x` expression.",109,null],[13,"ExprArray","","An array (`[a, b, c, d]`)",109,null],[13,"ExprCall","","A function call",109,null],[13,"ExprMethodCall","","A method call (`x.foo::<'static, Bar, Baz>(a, b, c, d)`)",109,null],[13,"ExprTup","","A tuple (`(a, b, c ,d)`)",109,null],[13,"ExprBinary","","A binary operation (For example: `a + b`, `a * b`)",109,null],[13,"ExprUnary","","A unary operation (For example: `!x`, `*x`)",109,null],[13,"ExprLit","","A literal (For example: `1`, `\"foo\"`)",109,null],[13,"ExprCast","","A cast (`foo as f64`)",109,null],[13,"ExprType","","",109,null],[13,"ExprIf","","An `if` block, with an optional else block",109,null],[13,"ExprWhile","","A while loop, with an optional label",109,null],[13,"ExprLoop","","Conditionless loop (can be exited with break, continue, or return)",109,null],[13,"ExprMatch","","A `match` block, with a source that indicates whether or not it is the result of a desugaring, and if so, which kind.",109,null],[13,"ExprClosure","","A closure (for example, `move |a, b, c| {a + b + c}`).",109,null],[13,"ExprBlock","","A block (`'label: { ... }`)",109,null],[13,"ExprAssign","","An assignment (`a = foo()`)",109,null],[13,"ExprAssignOp","","An assignment with an operator",109,null],[13,"ExprField","","Access of a named (`obj.foo`) or unnamed (`obj.0`) struct or tuple field",109,null],[13,"ExprIndex","","An indexing operation (`foo[2]`)",109,null],[13,"ExprPath","","Path to a definition, possibly containing lifetime or type parameters.",109,null],[13,"ExprAddrOf","","A referencing operation (`&a` or `&mut a`)",109,null],[13,"ExprBreak","","A `break`, with an optional label to break",109,null],[13,"ExprAgain","","A `continue`, with an optional label",109,null],[13,"ExprRet","","A `return`, with an optional value to be returned",109,null],[13,"ExprInlineAsm","","Inline assembly (from `asm!`), with its outputs and inputs.",109,null],[13,"ExprStruct","","A struct or struct-like variant literal expression.",109,null],[13,"ExprRepeat","","An array literal constructed from one repeated element.",109,null],[13,"ExprYield","","A suspension point for generators. This is `yield <expr>` in Rust.",109,null],[4,"QPath","","Optionally `Self`-qualified value/type path or associated extension.",null,null],[13,"Resolved","","Path to a definition, optionally \"fully-qualified\" with a `Self` type, if the path points to an associated item in a trait.",110,null],[13,"TypeRelative","","Type-related paths, e.g. `<T>::default` or `<T>::Output`. Will be resolved by type-checking to an associated item.",110,null],[4,"LocalSource","","Hints at the original code for a let statement",null,null],[13,"Normal","","A `match _ { .. }`",111,null],[13,"ForLoopDesugar","","A desugared `for _ in _ { .. }` loop",111,null],[4,"MatchSource","","Hints at the original code for a `match _ { .. }`",null,null],[13,"Normal","","A `match _ { .. }`",112,null],[13,"IfLetDesugar","","An `if let _ = _ { .. }` (optionally with `else { .. }`)",112,null],[12,"contains_else_clause","rustc::hir::MatchSource","",112,null],[13,"WhileLetDesugar","rustc::hir","A `while let _ = _ { .. }` (which was desugared to a `loop { match _ { .. } }`)",112,null],[13,"ForLoopDesugar","","A desugared `for _ in _ { .. }` loop",112,null],[13,"TryDesugar","","A desugared `?` operator",112,null],[4,"LoopSource","","The loop type that yielded an ExprLoop",null,null],[13,"Loop","","A `loop { .. }` loop",113,null],[13,"WhileLet","","A `while let _ = _ { .. }` loop",113,null],[13,"ForLoop","","A `for _ in _ { .. }` loop",113,null],[4,"LoopIdError","","",null,null],[13,"OutsideLoopScope","","",114,null],[13,"UnlabeledCfInWhileCondition","","",114,null],[13,"UnresolvedLabel","","",114,null],[4,"GeneratorMovability","","",null,null],[13,"Static","","",115,null],[13,"Movable","","",115,null],[4,"CaptureClause","","",null,null],[13,"CaptureByValue","","",116,null],[13,"CaptureByRef","","",116,null],[4,"TraitMethod","","A trait method's body (or just argument names).",null,null],[13,"Required","","No default body in the trait, just a signature.",117,null],[13,"Provided","","Both signature and body are provided in the trait.",117,null],[4,"TraitItemKind","","Represents a trait method or associated constant or type",null,null],[13,"Const","","An associated constant with an optional value (otherwise `impl`s must contain a value)",118,null],[13,"Method","","A method with an optional body",118,null],[13,"Type","","An associated type with (possibly empty) bounds and optional concrete type",118,null],[4,"ImplItemKind","","Represents different contents within `impl`s",null,null],[13,"Const","","An associated constant of the given type, set to the constant result of the expression",119,null],[13,"Method","","A method implementation with the given signature and body",119,null],[13,"Type","","An associated type",119,null],[4,"PrimTy","","Not represented directly in the AST, referred to by name through a ty_path.",null,null],[13,"TyInt","","",120,null],[13,"TyUint","","",120,null],[13,"TyFloat","","",120,null],[13,"TyStr","","",120,null],[13,"TyBool","","",120,null],[13,"TyChar","","",120,null],[4,"Ty_","","The different kinds of types recognized by the compiler",null,null],[13,"TySlice","","A variable length slice (`[T]`)",121,null],[13,"TyArray","","A fixed length array (`[T; n]`)",121,null],[13,"TyPtr","","A raw pointer (`*const T` or `*mut T`)",121,null],[13,"TyRptr","","A reference (`&'a T` or `&'a mut T`)",121,null],[13,"TyBareFn","","A bare function (e.g. `fn(usize) -> bool`)",121,null],[13,"TyNever","","The never type (`!`)",121,null],[13,"TyTup","","A tuple (`(A, B, C, D,...)`)",121,null],[13,"TyPath","","A path to a type definition (`module::module::...::Type`), or an associated type, e.g. `<Vec<T> as Trait>::Type` or `<T>::Target`.",121,null],[13,"TyTraitObject","","A trait object type `Bound1 + Bound2 + Bound3` where `Bound` is a trait or a lifetime.",121,null],[13,"TyImplTraitExistential","","An existentially quantified (there exists a type satisfying) `impl Bound1 + Bound2 + Bound3` type where `Bound` is a trait or a lifetime.",121,null],[13,"TyTypeof","","Unused for now",121,null],[13,"TyInfer","","TyInfer means the type should be inferred instead of it having been specified. This can appear anywhere in a type.",121,null],[13,"TyErr","","Placeholder for a type that has failed to be defined.",121,null],[4,"IsAuto","","Is the trait definition an auto trait?",null,null],[13,"Yes","","",122,null],[13,"No","","",122,null],[4,"Unsafety","","",null,null],[13,"Unsafe","","",123,null],[13,"Normal","","",123,null],[4,"Constness","","",null,null],[13,"Const","","",124,null],[13,"NotConst","","",124,null],[4,"Defaultness","","",null,null],[13,"Default","","",125,null],[12,"has_value","rustc::hir::Defaultness","",125,null],[13,"Final","rustc::hir","",125,null],[4,"ImplPolarity","","",null,null],[13,"Positive","","`impl Trait for Type`",126,null],[13,"Negative","","`impl !Trait for Type`",126,null],[4,"FunctionRetTy","","",null,null],[13,"DefaultReturn","","Return type is not specified.",127,null],[13,"Return","","Everything else",127,null],[4,"UseKind","","",null,null],[13,"Single","","One import, e.g. `use foo::bar` or `use foo::bar as baz`. Also produced for each element of a list `use`, e.g.",128,null],[13,"Glob","","Glob import, e.g. `use foo::*`.",128,null],[13,"ListStem","","Degenerate list import, e.g. `use foo::{a, b}` produces an additional `use foo::{}` for performing checks such as unstable feature gating. May be removed in the future.",128,null],[4,"Visibility","","",null,null],[13,"Public","","",129,null],[13,"Crate","","",129,null],[13,"Restricted","","",129,null],[12,"path","rustc::hir::Visibility","",129,null],[12,"id","","",129,null],[13,"Inherited","rustc::hir","",129,null],[4,"VariantData","","Fields and Ids of enum variants and structs",null,null],[13,"Struct","","",130,null],[13,"Tuple","","",130,null],[13,"Unit","","",130,null],[4,"Item_","","",null,null],[13,"ItemExternCrate","","An `extern crate` item, with optional original crate name if the crate was renamed.",131,null],[13,"ItemUse","","`use foo::bar::*;` or `use foo::bar::baz as quux;`",131,null],[13,"ItemStatic","","A `static` item",131,null],[13,"ItemConst","","A `const` item",131,null],[13,"ItemFn","","A function declaration",131,null],[13,"ItemMod","","A module",131,null],[13,"ItemForeignMod","","An external module",131,null],[13,"ItemGlobalAsm","","Module-level inline assembly (from global_asm!)",131,null],[13,"ItemTy","","A type alias, e.g. `type Foo = Bar<u8>`",131,null],[13,"ItemExistential","","A type alias, e.g. `type Foo = Bar<u8>`",131,null],[13,"ItemEnum","","An enum definition, e.g. `enum Foo<A, B> {C<A>, D<B>}`",131,null],[13,"ItemStruct","","A struct definition, e.g. `struct Foo<A> {x: A}`",131,null],[13,"ItemUnion","","A union definition, e.g. `union Foo<A, B> {x: A, y: B}`",131,null],[13,"ItemTrait","","Represents a Trait Declaration",131,null],[13,"ItemTraitAlias","","Represents a Trait Alias Declaration",131,null],[13,"ItemImpl","","An implementation, eg `impl<A> Trait for Foo { .. }`",131,null],[4,"AssociatedItemKind","","",null,null],[13,"Const","","",132,null],[13,"Method","","",132,null],[12,"has_self","rustc::hir::AssociatedItemKind","",132,null],[13,"Type","rustc::hir","",132,null],[4,"ForeignItem_","","An item within an `extern` block",null,null],[13,"ForeignItemFn","","A foreign function",133,null],[13,"ForeignItemStatic","","A foreign static item (`static ext: u8`), with optional mutability (the boolean is true when mutable)",133,null],[13,"ForeignItemType","","A foreign type",133,null],[5,"provide","","",null,{"i":[{"n":"providers"}]}],[0,"check_attr","","This module implements some validity checks for attributes. In particular it verifies that `#[inline]` and `#[repr]` attributes are attached to items that actually support them and if there are conflicts between multiple such attributes attached to the same item.",null,null],[3,"CheckAttrVisitor","rustc::hir::check_attr","",null,null],[12,"tcx","","",134,null],[4,"Target","","",null,null],[13,"Fn","","",135,null],[13,"Struct","","",135,null],[13,"Union","","",135,null],[13,"Enum","","",135,null],[13,"Const","","",135,null],[13,"ForeignMod","","",135,null],[13,"Expression","","",135,null],[13,"Statement","","",135,null],[13,"Closure","","",135,null],[13,"Static","","",135,null],[13,"Other","","",135,null],[5,"check_crate","","",null,{"i":[{"n":"tyctxt"}]}],[5,"is_c_like_enum","","",null,{"i":[{"n":"item"}],"o":{"n":"bool"}}],[11,"clone","","",135,{"i":[{"n":"self"}],"o":{"n":"target"}}],[11,"eq","","",135,{"i":[{"n":"self"},{"n":"target"}],"o":{"n":"bool"}}],[11,"from_item","","",135,{"i":[{"n":"item"}],"o":{"n":"target"}}],[11,"check_attributes","","Check any attribute.",134,{"i":[{"n":"self"},{"n":"item"},{"n":"target"}]}],[11,"check_inline","","Check if an `#[inline]` is applied to a function or a closure.",134,{"i":[{"n":"self"},{"n":"attribute"},{"n":"span"},{"n":"target"}]}],[11,"check_non_exhaustive","","Check if the `#[non_exhaustive]` attribute on an `item` is valid.",134,{"i":[{"n":"self"},{"n":"attribute"},{"n":"item"},{"n":"target"}]}],[11,"check_repr","","Check if the `#[repr]` attributes on `item` are valid.",134,{"i":[{"n":"self"},{"n":"item"},{"n":"target"}]}],[11,"emit_repr_error","","",134,{"i":[{"n":"self"},{"n":"span"},{"n":"span"},{"n":"str"},{"n":"str"}]}],[11,"check_stmt_attributes","","",134,{"i":[{"n":"self"},{"n":"stmt"}]}],[11,"check_expr_attributes","","",134,{"i":[{"n":"self"},{"n":"expr"}]}],[11,"check_used","","",134,{"i":[{"n":"self"},{"n":"item"},{"n":"target"}]}],[11,"nested_visit_map","","",134,{"i":[{"n":"self"}],"o":{"n":"nestedvisitormap"}}],[11,"visit_item","","",134,{"i":[{"n":"self"},{"n":"item"}]}],[11,"visit_stmt","","",134,{"i":[{"n":"self"},{"n":"stmt"}]}],[11,"visit_expr","","",134,{"i":[{"n":"self"},{"n":"expr"}]}],[0,"def","rustc::hir","",null,null],[3,"PathResolution","rustc::hir::def","The result of resolving a path before lowering to HIR. `base_def` is definition of resolved part of the path, `unresolved_segments` is the number of unresolved segments.",null,null],[12,"base_def","","",136,null],[12,"unresolved_segments","","",136,null],[3,"PerNS","","Just a helper ‒ separate structure for each namespace.",null,null],[12,"value_ns","","",137,null],[12,"type_ns","","",137,null],[12,"macro_ns","","",137,null],[3,"Export","","",null,null],[12,"ident","","The name of the target.",138,null],[12,"def","","The definition of the target.",138,null],[12,"span","","The span of the target definition.",138,null],[12,"vis","","The visibility of the export. We include non-`pub` exports for hygienic macros that get used from extern crates.",138,null],[4,"CtorKind","","",null,null],[13,"Fn","","Constructor function automatically created by a tuple struct/variant.",139,null],[13,"Const","","Constructor constant automatically created by a unit struct/variant.",139,null],[13,"Fictive","","Unusable name in value namespace created by a struct variant.",139,null],[4,"Def","","",null,null],[13,"Mod","","",140,null],[13,"Struct","","",140,null],[13,"Union","","",140,null],[13,"Enum","","",140,null],[13,"Variant","","",140,null],[13,"Trait","","",140,null],[13,"Existential","","",140,null],[13,"TyAlias","","",140,null],[13,"TyForeign","","",140,null],[13,"TraitAlias","","",140,null],[13,"AssociatedTy","","",140,null],[13,"PrimTy","","",140,null],[13,"TyParam","","",140,null],[13,"SelfTy","","",140,null],[13,"Fn","","",140,null],[13,"Const","","",140,null],[13,"Static","","",140,null],[13,"StructCtor","","",140,null],[13,"VariantCtor","","",140,null],[13,"Method","","",140,null],[13,"AssociatedConst","","",140,null],[13,"Local","","",140,null],[13,"Upvar","","",140,null],[13,"Label","","",140,null],[13,"Macro","","",140,null],[13,"GlobalAsm","","",140,null],[13,"Err","","",140,null],[4,"Namespace","","Different kinds of symbols don't influence each other.",null,null],[13,"TypeNS","","",141,null],[13,"ValueNS","","",141,null],[13,"MacroNS","","",141,null],[6,"DefMap","","Definition mapping",null,null],[6,"ExportMap","","This is the replacement export map. It maps a module to all of the exports within.",null,null],[6,"ImportMap","","Map used to track the `use` statements within a scope, matching it with all the items in every namespace.",null,null],[11,"clone","","",139,{"i":[{"n":"self"}],"o":{"n":"ctorkind"}}],[11,"eq","","",139,{"i":[{"n":"self"},{"n":"ctorkind"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",139,null],[11,"encode","","",139,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",139,{"i":[{"n":"__d"}],"o":{"g":["ctorkind"],"n":"result"}}],[11,"hash","","",139,null],[11,"fmt","","",139,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",140,{"i":[{"n":"self"}],"o":{"n":"def"}}],[11,"eq","","",140,{"i":[{"n":"self"},{"n":"def"}],"o":{"n":"bool"}}],[11,"ne","","",140,{"i":[{"n":"self"},{"n":"def"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",140,null],[11,"encode","","",140,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",140,{"i":[{"n":"__d"}],"o":{"g":["def"],"n":"result"}}],[11,"hash","","",140,null],[11,"fmt","","",140,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",136,{"i":[{"n":"self"}],"o":{"n":"pathresolution"}}],[11,"fmt","","",136,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","",136,{"i":[{"n":"def"}],"o":{"n":"self"}}],[11,"with_unresolved_segments","","",136,{"i":[{"n":"def"},{"n":"usize"}],"o":{"n":"self"}}],[11,"base_def","","",136,{"i":[{"n":"self"}],"o":{"n":"def"}}],[11,"unresolved_segments","","",136,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"kind_name","","",136,{"i":[{"n":"self"}],"o":{"n":"str"}}],[11,"clone","","",141,{"i":[{"n":"self"}],"o":{"n":"namespace"}}],[11,"eq","","",141,{"i":[{"n":"self"},{"n":"namespace"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",141,null],[11,"partial_cmp","","",141,{"i":[{"n":"self"},{"n":"namespace"}],"o":{"g":["ordering"],"n":"option"}}],[11,"cmp","","",141,{"i":[{"n":"self"},{"n":"namespace"}],"o":{"n":"ordering"}}],[11,"hash","","",141,null],[11,"fmt","","",141,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",137,{"i":[{"n":"self"}],"o":{"n":"perns"}}],[11,"default","","",137,{"o":{"n":"perns"}}],[11,"fmt","","",137,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"map","","",137,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"perns"}}],[11,"index","","",137,{"i":[{"n":"self"},{"n":"namespace"}],"o":{"n":"t"}}],[11,"index_mut","","",137,{"i":[{"n":"self"},{"n":"namespace"}],"o":{"n":"t"}}],[11,"is_empty","","Returns whether all the items in this collection are `None`.",137,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"present_items","","Returns an iterator over the items which are `Some`.",137,null],[11,"clone","","",138,{"i":[{"n":"self"}],"o":{"n":"export"}}],[11,"fmt","","",138,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"encode","","",138,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",138,{"i":[{"n":"__d"}],"o":{"g":["export"],"n":"result"}}],[11,"from_ast","","",139,{"i":[{"n":"variantdata"}],"o":{"n":"ctorkind"}}],[11,"from_hir","","",139,{"i":[{"n":"variantdata"}],"o":{"n":"ctorkind"}}],[11,"def_id","","",140,{"i":[{"n":"self"}],"o":{"n":"defid"}}],[11,"kind_name","","A human readable kind name",140,{"i":[{"n":"self"}],"o":{"n":"str"}}],[0,"def_id","rustc::hir","",null,null],[3,"CrateNum","rustc::hir::def_id","",null,null],[12,"0","","",142,null],[3,"DefIndex","","A DefIndex is an index into the hir-map for a crate, identifying a particular definition. It should really be considered an interned shorthand for a particular DefPath.",null,null],[12,"0","","",143,null],[3,"DefId","","A DefId identifies a particular definition, by combining a crate index and a def index.",null,null],[12,"krate","","",144,null],[12,"index","","",144,null],[3,"LocalDefId","","A LocalDefId is equivalent to a DefId with `krate == LOCAL_CRATE`. Since we encode this information in the type, we can ensure at compile time that no DefIds from upstream crates get thrown into the mix. There are quite a few cases where we know that only DefIds from the local crate are expected and a DefId from a different crate would signify a bug somewhere. This is when LocalDefId comes in handy.",null,null],[12,"0","","",145,null],[4,"DefIndexAddressSpace","","",null,null],[13,"Low","","",146,null],[13,"High","","",146,null],[17,"LOCAL_CRATE","","Item definitions in the currently-compiled crate would have the CrateNum LOCAL_CRATE in their DefId.",null,null],[17,"BUILTIN_MACROS_CRATE","","Virtual crate for builtin macros",null,null],[17,"INVALID_CRATE","","A CrateNum value that indicates that something is wrong.",null,null],[17,"RESERVED_FOR_INCR_COMP_CACHE","","A special CrateNum that we use for the tcx.rcache when decoding from the incr. comp. cache.",null,null],[17,"CRATE_DEF_INDEX","","The crate root is always assigned index 0 by the AST Map code, thanks to `NodeCollector::new`.",null,null],[11,"clone","","",142,{"i":[{"n":"self"}],"o":{"n":"cratenum"}}],[11,"eq","","",142,{"i":[{"n":"self"},{"n":"cratenum"}],"o":{"n":"bool"}}],[11,"ne","","",142,{"i":[{"n":"self"},{"n":"cratenum"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",142,null],[11,"hash","","",142,null],[11,"partial_cmp","","",142,{"i":[{"n":"self"},{"n":"cratenum"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",142,{"i":[{"n":"self"},{"n":"cratenum"}],"o":{"n":"bool"}}],[11,"le","","",142,{"i":[{"n":"self"},{"n":"cratenum"}],"o":{"n":"bool"}}],[11,"gt","","",142,{"i":[{"n":"self"},{"n":"cratenum"}],"o":{"n":"bool"}}],[11,"ge","","",142,{"i":[{"n":"self"},{"n":"cratenum"}],"o":{"n":"bool"}}],[11,"cmp","","",142,{"i":[{"n":"self"},{"n":"cratenum"}],"o":{"n":"ordering"}}],[11,"new","","",142,{"i":[{"n":"usize"}],"o":{"n":"self"}}],[11,"index","","",142,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"fmt","","",142,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","",142,{"i":[{"n":"usize"}],"o":{"n":"cratenum"}}],[11,"from_u32","","",142,{"i":[{"n":"u32"}],"o":{"n":"cratenum"}}],[11,"as_usize","","",142,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"as_u32","","",142,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"as_def_id","","",142,{"i":[{"n":"self"}],"o":{"n":"defid"}}],[11,"fmt","","",142,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",143,{"i":[{"n":"self"}],"o":{"n":"defindex"}}],[11,"assert_receiver_is_total_eq","","",143,null],[11,"cmp","","",143,{"i":[{"n":"self"},{"n":"defindex"}],"o":{"n":"ordering"}}],[11,"partial_cmp","","",143,{"i":[{"n":"self"},{"n":"defindex"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",143,{"i":[{"n":"self"},{"n":"defindex"}],"o":{"n":"bool"}}],[11,"le","","",143,{"i":[{"n":"self"},{"n":"defindex"}],"o":{"n":"bool"}}],[11,"gt","","",143,{"i":[{"n":"self"},{"n":"defindex"}],"o":{"n":"bool"}}],[11,"ge","","",143,{"i":[{"n":"self"},{"n":"defindex"}],"o":{"n":"bool"}}],[11,"eq","","",143,{"i":[{"n":"self"},{"n":"defindex"}],"o":{"n":"bool"}}],[11,"ne","","",143,{"i":[{"n":"self"},{"n":"defindex"}],"o":{"n":"bool"}}],[11,"hash","","",143,null],[11,"fmt","","",143,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"address_space","","",143,{"i":[{"n":"self"}],"o":{"n":"defindexaddressspace"}}],[11,"as_array_index","","Converts this DefIndex into a zero-based array index. This index is the offset within the given DefIndexAddressSpace.",143,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"from_array_index","","",143,{"i":[{"n":"usize"},{"n":"defindexaddressspace"}],"o":{"n":"defindex"}}],[11,"from_proc_macro_index","","",143,{"i":[{"n":"usize"}],"o":{"n":"defindex"}}],[11,"to_proc_macro_index","","",143,{"i":[{"n":"defindex"}],"o":{"n":"usize"}}],[11,"from_raw_u32","","",143,{"i":[{"n":"u32"}],"o":{"n":"defindex"}}],[11,"as_raw_u32","","",143,{"i":[{"n":"self"}],"o":{"n":"u32"}}],[11,"clone","","",146,{"i":[{"n":"self"}],"o":{"n":"defindexaddressspace"}}],[11,"assert_receiver_is_total_eq","","",146,null],[11,"eq","","",146,{"i":[{"n":"self"},{"n":"defindexaddressspace"}],"o":{"n":"bool"}}],[11,"hash","","",146,null],[11,"index","","",146,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"clone","","",144,{"i":[{"n":"self"}],"o":{"n":"defid"}}],[11,"assert_receiver_is_total_eq","","",144,null],[11,"cmp","","",144,{"i":[{"n":"self"},{"n":"defid"}],"o":{"n":"ordering"}}],[11,"partial_cmp","","",144,{"i":[{"n":"self"},{"n":"defid"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",144,{"i":[{"n":"self"},{"n":"defid"}],"o":{"n":"bool"}}],[11,"le","","",144,{"i":[{"n":"self"},{"n":"defid"}],"o":{"n":"bool"}}],[11,"gt","","",144,{"i":[{"n":"self"},{"n":"defid"}],"o":{"n":"bool"}}],[11,"ge","","",144,{"i":[{"n":"self"},{"n":"defid"}],"o":{"n":"bool"}}],[11,"eq","","",144,{"i":[{"n":"self"},{"n":"defid"}],"o":{"n":"bool"}}],[11,"ne","","",144,{"i":[{"n":"self"},{"n":"defid"}],"o":{"n":"bool"}}],[11,"hash","","",144,null],[11,"fmt","","",144,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"local","","Make a local `DefId` with the given index.",144,{"i":[{"n":"defindex"}],"o":{"n":"defid"}}],[11,"is_local","","",144,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"to_local","","",144,{"i":[{"n":"self"}],"o":{"n":"localdefid"}}],[11,"clone","","",145,{"i":[{"n":"self"}],"o":{"n":"localdefid"}}],[11,"assert_receiver_is_total_eq","","",145,null],[11,"eq","","",145,{"i":[{"n":"self"},{"n":"localdefid"}],"o":{"n":"bool"}}],[11,"ne","","",145,{"i":[{"n":"self"},{"n":"localdefid"}],"o":{"n":"bool"}}],[11,"cmp","","",145,{"i":[{"n":"self"},{"n":"localdefid"}],"o":{"n":"ordering"}}],[11,"partial_cmp","","",145,{"i":[{"n":"self"},{"n":"localdefid"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",145,{"i":[{"n":"self"},{"n":"localdefid"}],"o":{"n":"bool"}}],[11,"le","","",145,{"i":[{"n":"self"},{"n":"localdefid"}],"o":{"n":"bool"}}],[11,"gt","","",145,{"i":[{"n":"self"},{"n":"localdefid"}],"o":{"n":"bool"}}],[11,"ge","","",145,{"i":[{"n":"self"},{"n":"localdefid"}],"o":{"n":"bool"}}],[11,"hash","","",145,null],[11,"from_def_id","","",145,{"i":[{"n":"defid"}],"o":{"n":"localdefid"}}],[11,"to_def_id","","",145,{"i":[{"n":"self"}],"o":{"n":"defid"}}],[11,"fmt","","",145,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[0,"intravisit","rustc::hir","HIR walker for walking the contents of nodes.",null,null],[3,"IdRange","rustc::hir::intravisit","",null,null],[12,"min","","",147,null],[12,"max","","",147,null],[3,"IdRangeComputingVisitor","","",null,null],[12,"result","","",148,null],[12,"map","","",148,null],[4,"FnKind","","",null,null],[13,"ItemFn","","fn foo() or extern \"Abi\" fn foo()",149,null],[13,"Method","","fn foo(&self)",149,null],[13,"Closure","","|x, y| {}",149,null],[4,"NestedVisitorMap","","Specifies what nested things a visitor wants to visit. The most common choice is `OnlyBodies`, which will cause the visitor to visit fn bodies for fns that it encounters, but skip over nested item-like things.",null,null],[13,"None","","Do not visit any nested things. When you add a new \"non-nested\" thing, you will want to audit such uses to see if they remain valid.",150,null],[13,"OnlyBodies","","Do not visit nested item-like things, but visit nested things that are inside of an item-like.",150,null],[13,"All","","Visit all nested things, including item-likes.",150,null],[5,"walk_crate","","Walks the contents of a crate. See also `Crate::visit_all_items`.",null,{"i":[{"n":"v"},{"n":"crate"}]}],[5,"walk_macro_def","","",null,{"i":[{"n":"v"},{"n":"macrodef"}]}],[5,"walk_mod","","",null,{"i":[{"n":"v"},{"n":"mod"},{"n":"nodeid"}]}],[5,"walk_body","","",null,{"i":[{"n":"v"},{"n":"body"}]}],[5,"walk_local","","",null,{"i":[{"n":"v"},{"n":"local"}]}],[5,"walk_ident","","",null,{"i":[{"n":"v"},{"n":"ident"}]}],[5,"walk_label","","",null,{"i":[{"n":"v"},{"n":"label"}]}],[5,"walk_lifetime","","",null,{"i":[{"n":"v"},{"n":"lifetime"}]}],[5,"walk_poly_trait_ref","","",null,{"i":[{"n":"v"},{"n":"polytraitref"},{"n":"traitboundmodifier"}]}],[5,"walk_trait_ref","","",null,{"i":[{"n":"v"},{"n":"traitref"}]}],[5,"walk_item","","",null,{"i":[{"n":"v"},{"n":"item"}]}],[5,"walk_enum_def","","",null,{"i":[{"n":"v"},{"n":"enumdef"},{"n":"generics"},{"n":"nodeid"}]}],[5,"walk_variant","","",null,{"i":[{"n":"v"},{"n":"variant"},{"n":"generics"},{"n":"nodeid"}]}],[5,"walk_ty","","",null,{"i":[{"n":"v"},{"n":"ty"}]}],[5,"walk_qpath","","",null,{"i":[{"n":"v"},{"n":"qpath"},{"n":"nodeid"},{"n":"span"}]}],[5,"walk_path","","",null,{"i":[{"n":"v"},{"n":"path"}]}],[5,"walk_path_segment","","",null,{"i":[{"n":"v"},{"n":"span"},{"n":"pathsegment"}]}],[5,"walk_path_parameters","","",null,{"i":[{"n":"v"},{"n":"span"},{"n":"pathparameters"}]}],[5,"walk_assoc_type_binding","","",null,{"i":[{"n":"v"},{"n":"typebinding"}]}],[5,"walk_pat","","",null,{"i":[{"n":"v"},{"n":"pat"}]}],[5,"walk_foreign_item","","",null,{"i":[{"n":"v"},{"n":"foreignitem"}]}],[5,"walk_ty_param_bound","","",null,{"i":[{"n":"v"},{"n":"typarambound"}]}],[5,"walk_generic_param","","",null,{"i":[{"n":"v"},{"n":"genericparam"}]}],[5,"walk_generics","","",null,{"i":[{"n":"v"},{"n":"generics"}]}],[5,"walk_where_predicate","","",null,{"i":[{"n":"v"},{"n":"wherepredicate"}]}],[5,"walk_fn_ret_ty","","",null,{"i":[{"n":"v"},{"n":"functionretty"}]}],[5,"walk_fn_decl","","",null,{"i":[{"n":"v"},{"n":"fndecl"}]}],[5,"walk_fn_kind","","",null,{"i":[{"n":"v"},{"n":"fnkind"}]}],[5,"walk_fn","","",null,{"i":[{"n":"v"},{"n":"fnkind"},{"n":"fndecl"},{"n":"bodyid"},{"n":"span"},{"n":"nodeid"}]}],[5,"walk_trait_item","","",null,{"i":[{"n":"v"},{"n":"traititem"}]}],[5,"walk_trait_item_ref","","",null,{"i":[{"n":"v"},{"n":"traititemref"}]}],[5,"walk_impl_item","","",null,{"i":[{"n":"v"},{"n":"implitem"}]}],[5,"walk_impl_item_ref","","",null,{"i":[{"n":"v"},{"n":"implitemref"}]}],[5,"walk_struct_def","","",null,{"i":[{"n":"v"},{"n":"variantdata"}]}],[5,"walk_struct_field","","",null,{"i":[{"n":"v"},{"n":"structfield"}]}],[5,"walk_block","","",null,{"i":[{"n":"v"},{"n":"block"}]}],[5,"walk_stmt","","",null,{"i":[{"n":"v"},{"n":"stmt"}]}],[5,"walk_decl","","",null,{"i":[{"n":"v"},{"n":"decl"}]}],[5,"walk_anon_const","","",null,{"i":[{"n":"v"},{"n":"anonconst"}]}],[5,"walk_expr","","",null,{"i":[{"n":"v"},{"n":"expr"}]}],[5,"walk_arm","","",null,{"i":[{"n":"v"},{"n":"arm"}]}],[5,"walk_vis","","",null,{"i":[{"n":"v"},{"n":"visibility"}]}],[5,"walk_associated_item_kind","","",null,{"i":[{"n":"v"},{"n":"associateditemkind"}]}],[5,"walk_defaultness","","",null,{"i":[{"n":"v"},{"n":"defaultness"}]}],[8,"Visitor","","Each method of the Visitor trait is a hook to be potentially overridden.  Each method's default implementation recursively visits the substructure of the input via the corresponding `walk` method; e.g. the `visit_mod` method by default calls `intravisit::walk_mod`.",null,null],[10,"nested_visit_map","","The default versions of the `visit_nested_XXX` routines invoke this method to get a map to use. By selecting an enum variant, you control which kinds of nested HIR are visited; see `NestedVisitorMap` for details. By \"nested HIR\", we are referring to bits of HIR that are not directly embedded within one another but rather indirectly, through a table in the crate. This is done to control dependencies during incremental compilation: the non-inline bits of HIR can be tracked and hashed separately.",151,{"i":[{"n":"self"}],"o":{"n":"nestedvisitormap"}}],[11,"visit_nested_item","","Invoked when a nested item is encountered. By default does nothing unless you override `nested_visit_map` to return `Some(_)`, in which case it will walk the item. You probably don't want to override this method -- instead, override `nested_visit_map` or use the \"shallow\" or \"deep\" visit patterns described on `itemlikevisit::ItemLikeVisitor`. The only reason to override this method is if you want a nested pattern but cannot supply a `Map`; see `nested_visit_map` for advice.",151,{"i":[{"n":"self"},{"n":"itemid"}]}],[11,"visit_nested_trait_item","","Like `visit_nested_item()`, but for trait items. See `visit_nested_item()` for advice on when to override this method.",151,{"i":[{"n":"self"},{"n":"traititemid"}]}],[11,"visit_nested_impl_item","","Like `visit_nested_item()`, but for impl items. See `visit_nested_item()` for advice on when to override this method.",151,{"i":[{"n":"self"},{"n":"implitemid"}]}],[11,"visit_nested_body","","Invoked to visit the body of a function, method or closure. Like visit_nested_item, does nothing by default unless you override `nested_visit_map` to return `Some(_)`, in which case it will walk the body.",151,{"i":[{"n":"self"},{"n":"bodyid"}]}],[11,"visit_item","","Visit the top-level item and (optionally) nested items / impl items. See `visit_nested_item` for details.",151,{"i":[{"n":"self"},{"n":"item"}]}],[11,"visit_body","","",151,{"i":[{"n":"self"},{"n":"body"}]}],[11,"as_deep_visitor","","When invoking `visit_all_item_likes()`, you need to supply an item-like visitor.  This method converts a \"intra-visit\" visitor into an item-like visitor that walks the entire tree. If you use this, you probably don't want to process the contents of nested item-like things, since the outer loop will visit them as well.",151,{"i":[{"n":"self"}],"o":{"n":"deepvisitor"}}],[11,"visit_id","","",151,{"i":[{"n":"self"},{"n":"nodeid"}]}],[11,"visit_def_mention","","",151,{"i":[{"n":"self"},{"n":"def"}]}],[11,"visit_name","","",151,{"i":[{"n":"self"},{"n":"span"},{"n":"name"}]}],[11,"visit_ident","","",151,{"i":[{"n":"self"},{"n":"ident"}]}],[11,"visit_mod","","",151,{"i":[{"n":"self"},{"n":"mod"},{"n":"span"},{"n":"nodeid"}]}],[11,"visit_foreign_item","","",151,{"i":[{"n":"self"},{"n":"foreignitem"}]}],[11,"visit_local","","",151,{"i":[{"n":"self"},{"n":"local"}]}],[11,"visit_block","","",151,{"i":[{"n":"self"},{"n":"block"}]}],[11,"visit_stmt","","",151,{"i":[{"n":"self"},{"n":"stmt"}]}],[11,"visit_arm","","",151,{"i":[{"n":"self"},{"n":"arm"}]}],[11,"visit_pat","","",151,{"i":[{"n":"self"},{"n":"pat"}]}],[11,"visit_decl","","",151,{"i":[{"n":"self"},{"n":"decl"}]}],[11,"visit_anon_const","","",151,{"i":[{"n":"self"},{"n":"anonconst"}]}],[11,"visit_expr","","",151,{"i":[{"n":"self"},{"n":"expr"}]}],[11,"visit_ty","","",151,{"i":[{"n":"self"},{"n":"ty"}]}],[11,"visit_generic_param","","",151,{"i":[{"n":"self"},{"n":"genericparam"}]}],[11,"visit_generics","","",151,{"i":[{"n":"self"},{"n":"generics"}]}],[11,"visit_where_predicate","","",151,{"i":[{"n":"self"},{"n":"wherepredicate"}]}],[11,"visit_fn_decl","","",151,{"i":[{"n":"self"},{"n":"fndecl"}]}],[11,"visit_fn","","",151,{"i":[{"n":"self"},{"n":"fnkind"},{"n":"fndecl"},{"n":"bodyid"},{"n":"span"},{"n":"nodeid"}]}],[11,"visit_trait_item","","",151,{"i":[{"n":"self"},{"n":"traititem"}]}],[11,"visit_trait_item_ref","","",151,{"i":[{"n":"self"},{"n":"traititemref"}]}],[11,"visit_impl_item","","",151,{"i":[{"n":"self"},{"n":"implitem"}]}],[11,"visit_impl_item_ref","","",151,{"i":[{"n":"self"},{"n":"implitemref"}]}],[11,"visit_trait_ref","","",151,{"i":[{"n":"self"},{"n":"traitref"}]}],[11,"visit_ty_param_bound","","",151,{"i":[{"n":"self"},{"n":"typarambound"}]}],[11,"visit_poly_trait_ref","","",151,{"i":[{"n":"self"},{"n":"polytraitref"},{"n":"traitboundmodifier"}]}],[11,"visit_variant_data","","",151,{"i":[{"n":"self"},{"n":"variantdata"},{"n":"name"},{"n":"generics"},{"n":"nodeid"},{"n":"span"}]}],[11,"visit_struct_field","","",151,{"i":[{"n":"self"},{"n":"structfield"}]}],[11,"visit_enum_def","","",151,{"i":[{"n":"self"},{"n":"enumdef"},{"n":"generics"},{"n":"nodeid"},{"n":"span"}]}],[11,"visit_variant","","",151,{"i":[{"n":"self"},{"n":"variant"},{"n":"generics"},{"n":"nodeid"}]}],[11,"visit_label","","",151,{"i":[{"n":"self"},{"n":"label"}]}],[11,"visit_lifetime","","",151,{"i":[{"n":"self"},{"n":"lifetime"}]}],[11,"visit_qpath","","",151,{"i":[{"n":"self"},{"n":"qpath"},{"n":"nodeid"},{"n":"span"}]}],[11,"visit_path","","",151,{"i":[{"n":"self"},{"n":"path"},{"n":"nodeid"}]}],[11,"visit_path_segment","","",151,{"i":[{"n":"self"},{"n":"span"},{"n":"pathsegment"}]}],[11,"visit_path_parameters","","",151,{"i":[{"n":"self"},{"n":"span"},{"n":"pathparameters"}]}],[11,"visit_assoc_type_binding","","",151,{"i":[{"n":"self"},{"n":"typebinding"}]}],[11,"visit_attribute","","",151,{"i":[{"n":"self"},{"n":"attribute"}]}],[11,"visit_macro_def","","",151,{"i":[{"n":"self"},{"n":"macrodef"}]}],[11,"visit_vis","","",151,{"i":[{"n":"self"},{"n":"visibility"}]}],[11,"visit_associated_item_kind","","",151,{"i":[{"n":"self"},{"n":"associateditemkind"}]}],[11,"visit_defaultness","","",151,{"i":[{"n":"self"},{"n":"defaultness"}]}],[11,"clone","","",149,{"i":[{"n":"self"}],"o":{"n":"fnkind"}}],[11,"eq","","",149,{"i":[{"n":"self"},{"n":"fnkind"}],"o":{"n":"bool"}}],[11,"ne","","",149,{"i":[{"n":"self"},{"n":"fnkind"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",149,null],[11,"attrs","","",149,null],[11,"intra","","Returns the map to use for an \"intra item-like\" thing (if any). e.g., function body.",150,{"i":[{"n":"self"}],"o":{"g":["map"],"n":"option"}}],[11,"inter","","Returns the map to use for an \"item-like\" thing (if any). e.g., item, impl-item.",150,{"i":[{"n":"self"}],"o":{"g":["map"],"n":"option"}}],[11,"clone","","",147,{"i":[{"n":"self"}],"o":{"n":"idrange"}}],[11,"encode","","",147,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",147,{"i":[{"n":"__d"}],"o":{"g":["idrange"],"n":"result"}}],[11,"fmt","","",147,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"eq","","",147,{"i":[{"n":"self"},{"n":"idrange"}],"o":{"n":"bool"}}],[11,"ne","","",147,{"i":[{"n":"self"},{"n":"idrange"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",147,null],[11,"max","","",147,{"o":{"n":"idrange"}}],[11,"empty","","",147,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"contains","","",147,{"i":[{"n":"self"},{"n":"nodeid"}],"o":{"n":"bool"}}],[11,"add","","",147,{"i":[{"n":"self"},{"n":"nodeid"}]}],[11,"new","","",148,{"i":[{"n":"map"}],"o":{"n":"idrangecomputingvisitor"}}],[11,"result","","",148,{"i":[{"n":"self"}],"o":{"n":"idrange"}}],[11,"nested_visit_map","","",148,{"i":[{"n":"self"}],"o":{"n":"nestedvisitormap"}}],[11,"visit_id","","",148,{"i":[{"n":"self"},{"n":"nodeid"}]}],[0,"itemlikevisit","rustc::hir","",null,null],[3,"DeepVisitor","rustc::hir::itemlikevisit","",null,null],[12,"visitor","","",152,null],[3,"ParDeepVisitor","","",null,null],[12,"0","","",153,null],[8,"ItemLikeVisitor","","The \"item-like visitor\" visitor defines only the top-level methods that can be invoked by `Crate::visit_all_item_likes()`. Whether this trait is the right one to implement will depend on the overall pattern you need. Here are the three available patterns, in roughly the order of desirability:",null,null],[10,"visit_item","","",154,{"i":[{"n":"self"},{"n":"item"}]}],[10,"visit_trait_item","","",154,{"i":[{"n":"self"},{"n":"traititem"}]}],[10,"visit_impl_item","","",154,{"i":[{"n":"self"},{"n":"implitem"}]}],[8,"ParItemLikeVisitor","","A parallel variant of ItemLikeVisitor",null,null],[10,"visit_item","","",155,{"i":[{"n":"self"},{"n":"item"}]}],[10,"visit_trait_item","","",155,{"i":[{"n":"self"},{"n":"traititem"}]}],[10,"visit_impl_item","","",155,{"i":[{"n":"self"},{"n":"implitem"}]}],[8,"IntoVisitor","","",null,null],[16,"Visitor","","",156,null],[10,"into_visitor","","",156,null],[11,"new","","",152,{"i":[{"n":"v"}],"o":{"n":"self"}}],[11,"visit_item","","",152,{"i":[{"n":"self"},{"n":"item"}]}],[11,"visit_trait_item","","",152,{"i":[{"n":"self"},{"n":"traititem"}]}],[11,"visit_impl_item","","",152,{"i":[{"n":"self"},{"n":"implitem"}]}],[11,"visit_item","","",153,{"i":[{"n":"self"},{"n":"item"}]}],[11,"visit_trait_item","","",153,{"i":[{"n":"self"},{"n":"traititem"}]}],[11,"visit_impl_item","","",153,{"i":[{"n":"self"},{"n":"implitem"}]}],[0,"lowering","rustc::hir","Lowers the AST to the HIR.",null,null],[3,"LoweringContext","rustc::hir::lowering","",null,null],[12,"crate_root","","",157,null],[12,"sess","","",157,null],[12,"cstore","","",157,null],[12,"resolver","","",157,null],[12,"name_map","","",157,null],[12,"items","","The items being lowered are collected here.",157,null],[12,"trait_items","","",157,null],[12,"impl_items","","",157,null],[12,"bodies","","",157,null],[12,"exported_macros","","",157,null],[12,"trait_impls","","",157,null],[12,"trait_auto_impl","","",157,null],[12,"is_generator","","",157,null],[12,"catch_scopes","","",157,null],[12,"loop_scopes","","",157,null],[12,"is_in_loop_condition","","",157,null],[12,"is_in_trait_impl","","",157,null],[12,"anonymous_lifetime_mode","","What to do when we encounter either an \"anonymous lifetime reference\". The term \"anonymous\" is meant to encompass both `'_` lifetimes as well as fully elided cases where nothing is written at all (e.g., `&T` or `std::cell::Ref<T>`).",157,null],[12,"in_band_ty_params","","",157,null],[12,"lifetimes_to_define","","",157,null],[12,"is_collecting_in_band_lifetimes","","",157,null],[12,"in_scope_lifetimes","","",157,null],[12,"type_def_lifetime_params","","",157,null],[12,"current_hir_id_owner","","",157,null],[12,"item_local_id_counters","","",157,null],[12,"node_id_to_hir_id","","",157,null],[3,"LoweredNodeId","","",null,null],[12,"node_id","","",158,null],[12,"hir_id","","",158,null],[4,"ImplTraitContext","","",null,null],[13,"Universal","","Treat `impl Trait` as shorthand for a new universal generic parameter. Example: `fn foo(x: impl Debug)`, where `impl Debug` is conceptually equivalent to a fresh universal parameter like `fn foo<T: Debug>(x: T)`.",159,null],[13,"Existential","","Treat `impl Trait` as shorthand for a new universal existential parameter. Example: `fn foo() -> impl Debug`, where `impl Debug` is conceptually equivalent to a fresh existential parameter like `abstract type T; fn foo() -> T`.",159,null],[13,"Disallowed","","`impl Trait` is not accepted in this position.",159,null],[4,"ParamMode","","",null,null],[13,"Explicit","","Any path in a type context.",160,null],[13,"Optional","","The `module::Type` in `module::Type::method` in an expression.",160,null],[4,"ParenthesizedGenericArgs","","",null,null],[13,"Ok","","",161,null],[13,"Warn","","",161,null],[13,"Err","","",161,null],[4,"AnonymousLifetimeMode","","What to do when we encounter an anonymous lifetime reference. Anonymous lifetime references come in two flavors.  You have implicit, or fully elided, references to lifetimes, like the one in `&T` or `Ref<T>`, and you have `'_` lifetimes, like `&'_ T` or `Ref<'_, T>`.  These often behave the same, but not always:",null,null],[13,"CreateParameter","","For Modern cases, create a new anonymous region parameter and reference that.",162,null],[13,"PassThrough","","Pass responsibility to `resolve_lifetime` code for all cases.",162,null],[5,"lower_crate","","",null,{"i":[{"n":"session"},{"n":"cratestore"},{"n":"depgraph"},{"n":"crate"},{"n":"resolver"}],"o":{"n":"crate"}}],[5,"body_ids","","",null,{"i":[{"n":"btreemap"}],"o":{"g":["bodyid"],"n":"vec"}}],[17,"HIR_ID_COUNTER_LOCKED","","",null,null],[8,"Resolver","","",null,null],[10,"resolve_hir_path","","Resolve a hir path generated by the lowerer when expanding `for`, `if let`, etc.",163,{"i":[{"n":"self"},{"n":"path"},{"n":"bool"}]}],[10,"get_resolution","","Obtain the resolution for a node id",163,{"i":[{"n":"self"},{"n":"nodeid"}],"o":{"g":["pathresolution"],"n":"option"}}],[10,"get_import","","Obtain the possible resolutions for the given `use` statement.",163,{"i":[{"n":"self"},{"n":"nodeid"}],"o":{"g":["option"],"n":"perns"}}],[10,"definitions","","We must keep the set of definitions up to date as we add nodes that weren't in the AST. This should only return `None` during testing.",163,{"i":[{"n":"self"}],"o":{"n":"definitions"}}],[10,"resolve_str_path","","Given suffix [\"b\",\"c\",\"d\"], creates a HIR path for `[::crate_root]::b::c::d` and resolves it based on `is_value`.",163,null],[11,"clone","","",159,{"i":[{"n":"self"}],"o":{"n":"impltraitcontext"}}],[11,"fmt","","",159,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",160,{"i":[{"n":"self"}],"o":{"n":"parammode"}}],[11,"eq","","",160,{"i":[{"n":"self"},{"n":"parammode"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",160,null],[11,"fmt","","",158,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",162,{"i":[{"n":"self"}],"o":{"n":"anonymouslifetimemode"}}],[11,"lower_crate","","",157,{"i":[{"n":"self"},{"n":"crate"}],"o":{"n":"crate"}}],[11,"allocate_hir_id_counter","","",157,{"i":[{"n":"self"},{"n":"nodeid"},{"n":"t"}]}],[11,"lower_node_id_generic","","",157,{"i":[{"n":"self"},{"n":"nodeid"},{"n":"f"}],"o":{"n":"lowerednodeid"}}],[11,"with_hir_id_owner","","",157,{"i":[{"n":"self"},{"n":"nodeid"},{"n":"f"}],"o":{"n":"t"}}],[11,"lower_node_id","","This method allocates a new HirId for the given NodeId and stores it in the LoweringContext's NodeId => HirId map. Take care not to call this method if the resulting HirId is then not actually used in the HIR, as that would trigger an assertion in the HirIdValidator later on, which makes sure that all NodeIds got mapped properly. Calling the method twice with the same NodeId is fine though.",157,{"i":[{"n":"self"},{"n":"nodeid"}],"o":{"n":"lowerednodeid"}}],[11,"lower_node_id_with_owner","","",157,{"i":[{"n":"self"},{"n":"nodeid"},{"n":"nodeid"}],"o":{"n":"lowerednodeid"}}],[11,"record_body","","",157,{"i":[{"n":"self"},{"n":"expr"},{"g":["fndecl"],"n":"option"}],"o":{"n":"bodyid"}}],[11,"next_id","","",157,{"i":[{"n":"self"}],"o":{"n":"lowerednodeid"}}],[11,"expect_full_def","","",157,{"i":[{"n":"self"},{"n":"nodeid"}],"o":{"n":"def"}}],[11,"expect_full_def_from_use","","",157,null],[11,"diagnostic","","",157,{"i":[{"n":"self"}],"o":{"n":"handler"}}],[11,"str_to_ident","","",157,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"name"}}],[11,"allow_internal_unstable","","",157,{"i":[{"n":"self"},{"n":"compilerdesugaringkind"},{"n":"span"}],"o":{"n":"span"}}],[11,"with_anonymous_lifetime_mode","","",157,null],[11,"collect_in_band_defs","","Creates a new hir::GenericParam for every new lifetime and type parameter encountered while evaluating `f`. Definitions are created with the parent provided. If no `parent_id` is provided, no definitions will be returned.",157,null],[11,"maybe_collect_in_band_lifetime","","When there is a reference to some lifetime `'a`, and in-band lifetimes are enabled, then we want to push that lifetime into the vector of names to define later. In that case, it will get added to the appropriate generics.",157,{"i":[{"n":"self"},{"n":"span"},{"n":"name"}]}],[11,"collect_fresh_in_band_lifetime","","When we have either an elided or `'_` lifetime in an impl header, we convert it to",157,{"i":[{"n":"self"},{"n":"span"}],"o":{"n":"lifetimename"}}],[11,"with_in_scope_lifetime_defs","","",157,null],[11,"with_parent_impl_lifetime_defs","","",157,null],[11,"add_in_band_defs","","Appends in-band lifetime defs and argument-position `impl Trait` defs to the existing set of generics.",157,null],[11,"with_catch_scope","","",157,{"i":[{"n":"self"},{"n":"nodeid"},{"n":"f"}],"o":{"n":"t"}}],[11,"lower_body","","",157,{"i":[{"n":"self"},{"g":["fndecl"],"n":"option"},{"n":"f"}],"o":{"n":"bodyid"}}],[11,"with_loop_scope","","",157,{"i":[{"n":"self"},{"n":"nodeid"},{"n":"f"}],"o":{"n":"t"}}],[11,"with_loop_condition_scope","","",157,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"t"}}],[11,"with_new_scopes","","",157,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"t"}}],[11,"def_key","","",157,{"i":[{"n":"self"},{"n":"defid"}],"o":{"n":"defkey"}}],[11,"lower_ident","","",157,{"i":[{"n":"self"},{"n":"ident"}],"o":{"n":"name"}}],[11,"lower_label","","",157,{"i":[{"n":"self"},{"g":["label"],"n":"option"}],"o":{"g":["label"],"n":"option"}}],[11,"lower_loop_destination","","",157,{"i":[{"n":"self"},{"n":"option"}],"o":{"n":"destination"}}],[11,"lower_attrs","","",157,null],[11,"lower_attr","","",157,{"i":[{"n":"self"},{"n":"attribute"}],"o":{"n":"attribute"}}],[11,"lower_token_stream","","",157,{"i":[{"n":"self"},{"n":"tokenstream"}],"o":{"n":"tokenstream"}}],[11,"lower_token_tree","","",157,{"i":[{"n":"self"},{"n":"tokentree"}],"o":{"n":"tokenstream"}}],[11,"lower_token","","",157,{"i":[{"n":"self"},{"n":"token"},{"n":"span"}],"o":{"n":"tokenstream"}}],[11,"lower_arm","","",157,{"i":[{"n":"self"},{"n":"arm"}],"o":{"n":"arm"}}],[11,"lower_ty_binding","","",157,{"i":[{"n":"self"},{"n":"typebinding"},{"n":"impltraitcontext"}],"o":{"n":"typebinding"}}],[11,"lower_ty","","",157,{"i":[{"n":"self"},{"n":"ty"},{"n":"impltraitcontext"}],"o":{"g":["ty"],"n":"p"}}],[11,"lifetimes_from_impl_trait_bounds","","",157,null],[11,"lower_foreign_mod","","",157,{"i":[{"n":"self"},{"n":"foreignmod"}],"o":{"n":"foreignmod"}}],[11,"lower_global_asm","","",157,{"i":[{"n":"self"},{"n":"globalasm"}],"o":{"g":["globalasm"],"n":"p"}}],[11,"lower_variant","","",157,{"i":[{"n":"self"},{"n":"variant"}],"o":{"n":"variant"}}],[11,"lower_qpath","","",157,{"i":[{"n":"self"},{"n":"nodeid"},{"n":"option"},{"n":"path"},{"n":"parammode"},{"n":"impltraitcontext"}],"o":{"n":"qpath"}}],[11,"lower_path_extra","","",157,{"i":[{"n":"self"},{"n":"def"},{"n":"path"},{"g":["name"],"n":"option"},{"n":"parammode"}],"o":{"n":"path"}}],[11,"lower_path","","",157,{"i":[{"n":"self"},{"n":"nodeid"},{"n":"path"},{"n":"parammode"}],"o":{"n":"path"}}],[11,"lower_path_segment","","",157,{"i":[{"n":"self"},{"n":"span"},{"n":"pathsegment"},{"n":"parammode"},{"n":"usize"},{"n":"parenthesizedgenericargs"},{"n":"impltraitcontext"}],"o":{"n":"pathsegment"}}],[11,"lower_angle_bracketed_parameter_data","","",157,null],[11,"lower_parenthesized_parameter_data","","",157,null],[11,"lower_local","","",157,{"i":[{"n":"self"},{"n":"local"}],"o":{"g":["local"],"n":"p"}}],[11,"lower_mutability","","",157,{"i":[{"n":"self"},{"n":"mutability"}],"o":{"n":"mutability"}}],[11,"lower_arg","","",157,{"i":[{"n":"self"},{"n":"arg"}],"o":{"n":"arg"}}],[11,"lower_fn_args_to_names","","",157,{"i":[{"n":"self"},{"n":"fndecl"}],"o":{"g":["spanned"],"n":"hirvec"}}],[11,"lower_fn_decl","","",157,{"i":[{"n":"self"},{"n":"fndecl"},{"g":["defid"],"n":"option"},{"n":"bool"}],"o":{"g":["fndecl"],"n":"p"}}],[11,"lower_ty_param_bound","","",157,{"i":[{"n":"self"},{"n":"typarambound"},{"n":"impltraitcontext"}],"o":{"n":"typarambound"}}],[11,"lower_ty_param","","",157,null],[11,"lower_lifetime","","",157,{"i":[{"n":"self"},{"n":"lifetime"}],"o":{"n":"lifetime"}}],[11,"new_named_lifetime","","",157,{"i":[{"n":"self"},{"n":"nodeid"},{"n":"span"},{"n":"lifetimename"}],"o":{"n":"lifetime"}}],[11,"lower_lifetime_def","","",157,{"i":[{"n":"self"},{"n":"lifetimedef"}],"o":{"n":"lifetimedef"}}],[11,"lower_lifetimes","","",157,{"i":[{"n":"self"},{"n":"vec"}],"o":{"g":["lifetime"],"n":"hirvec"}}],[11,"lower_generic_params","","",157,{"i":[{"n":"self"},{"n":"vec"},{"n":"nodemap"},{"n":"impltraitcontext"}],"o":{"g":["genericparam"],"n":"hirvec"}}],[11,"lower_generics","","",157,{"i":[{"n":"self"},{"n":"generics"},{"n":"impltraitcontext"}],"o":{"n":"generics"}}],[11,"lower_where_clause","","",157,{"i":[{"n":"self"},{"n":"whereclause"}],"o":{"n":"whereclause"}}],[11,"lower_where_predicate","","",157,{"i":[{"n":"self"},{"n":"wherepredicate"}],"o":{"n":"wherepredicate"}}],[11,"lower_variant_data","","",157,{"i":[{"n":"self"},{"n":"variantdata"}],"o":{"n":"variantdata"}}],[11,"lower_trait_ref","","",157,{"i":[{"n":"self"},{"n":"traitref"},{"n":"impltraitcontext"}],"o":{"n":"traitref"}}],[11,"lower_poly_trait_ref","","",157,{"i":[{"n":"self"},{"n":"polytraitref"},{"n":"impltraitcontext"}],"o":{"n":"polytraitref"}}],[11,"lower_struct_field","","",157,null],[11,"lower_field","","",157,{"i":[{"n":"self"},{"n":"field"}],"o":{"n":"field"}}],[11,"lower_mt","","",157,{"i":[{"n":"self"},{"n":"mutty"},{"n":"impltraitcontext"}],"o":{"n":"mutty"}}],[11,"lower_bounds","","",157,null],[11,"lower_block","","",157,{"i":[{"n":"self"},{"n":"block"},{"n":"bool"}],"o":{"g":["block"],"n":"p"}}],[11,"lower_item_kind","","",157,{"i":[{"n":"self"},{"n":"nodeid"},{"n":"name"},{"n":"hirvec"},{"n":"visibility"},{"n":"itemkind"}],"o":{"n":"item_"}}],[11,"lower_use_tree","","",157,{"i":[{"n":"self"},{"n":"usetree"},{"n":"path"},{"n":"nodeid"},{"n":"visibility"},{"n":"name"},{"n":"hirvec"}],"o":{"n":"item_"}}],[11,"lower_trait_item","","",157,{"i":[{"n":"self"},{"n":"traititem"}],"o":{"n":"traititem"}}],[11,"lower_trait_item_ref","","",157,{"i":[{"n":"self"},{"n":"traititem"}],"o":{"n":"traititemref"}}],[11,"lower_impl_item","","",157,{"i":[{"n":"self"},{"n":"implitem"}],"o":{"n":"implitem"}}],[11,"lower_impl_item_ref","","",157,{"i":[{"n":"self"},{"n":"implitem"}],"o":{"n":"implitemref"}}],[11,"lower_mod","","",157,{"i":[{"n":"self"},{"n":"mod"}],"o":{"n":"mod"}}],[11,"lower_item_id","","",157,{"i":[{"n":"self"},{"n":"item"}],"o":{"g":["itemid"],"n":"smallvector"}}],[11,"lower_item_id_use_tree","","",157,{"i":[{"n":"self"},{"n":"usetree"},{"n":"nodeid"},{"n":"smallvector"}]}],[11,"lower_item","","",157,{"i":[{"n":"self"},{"n":"item"}],"o":{"g":["item"],"n":"option"}}],[11,"lower_foreign_item","","",157,{"i":[{"n":"self"},{"n":"foreignitem"}],"o":{"n":"foreignitem"}}],[11,"lower_method_sig","","",157,{"i":[{"n":"self"},{"n":"methodsig"},{"n":"defid"},{"n":"bool"}],"o":{"n":"methodsig"}}],[11,"lower_is_auto","","",157,{"i":[{"n":"self"},{"n":"isauto"}],"o":{"n":"isauto"}}],[11,"lower_unsafety","","",157,{"i":[{"n":"self"},{"n":"unsafety"}],"o":{"n":"unsafety"}}],[11,"lower_constness","","",157,{"i":[{"n":"self"},{"g":["constness"],"n":"spanned"}],"o":{"n":"constness"}}],[11,"lower_unop","","",157,{"i":[{"n":"self"},{"n":"unop"}],"o":{"n":"unop"}}],[11,"lower_binop","","",157,{"i":[{"n":"self"},{"n":"binop"}],"o":{"n":"binop"}}],[11,"lower_pat","","",157,{"i":[{"n":"self"},{"n":"pat"}],"o":{"g":["pat"],"n":"p"}}],[11,"lower_range_end","","",157,{"i":[{"n":"self"},{"n":"rangeend"}],"o":{"n":"rangeend"}}],[11,"lower_anon_const","","",157,{"i":[{"n":"self"},{"n":"anonconst"}],"o":{"n":"anonconst"}}],[11,"lower_expr","","",157,{"i":[{"n":"self"},{"n":"expr"}],"o":{"n":"expr"}}],[11,"lower_stmt","","",157,{"i":[{"n":"self"},{"n":"stmt"}],"o":{"g":["stmt"],"n":"smallvector"}}],[11,"lower_capture_clause","","",157,{"i":[{"n":"self"},{"n":"captureby"}],"o":{"n":"captureclause"}}],[11,"lower_visibility","","If an `explicit_owner` is given, this method allocates the `HirId` in the address space of that item instead of the item currently being lowered. This can happen during `lower_impl_item_ref()` where we need to lower a `Visibility` value although we haven't lowered the owning `ImplItem` in question yet.",157,{"i":[{"n":"self"},{"n":"visibility"},{"g":["nodeid"],"n":"option"}],"o":{"n":"visibility"}}],[11,"lower_defaultness","","",157,{"i":[{"n":"self"},{"n":"defaultness"},{"n":"bool"}],"o":{"n":"defaultness"}}],[11,"lower_block_check_mode","","",157,{"i":[{"n":"self"},{"n":"blockcheckmode"}],"o":{"n":"blockcheckmode"}}],[11,"lower_binding_mode","","",157,{"i":[{"n":"self"},{"n":"bindingmode"}],"o":{"n":"bindingannotation"}}],[11,"lower_unsafe_source","","",157,{"i":[{"n":"self"},{"n":"unsafesource"}],"o":{"n":"unsafesource"}}],[11,"lower_impl_polarity","","",157,{"i":[{"n":"self"},{"n":"implpolarity"}],"o":{"n":"implpolarity"}}],[11,"lower_trait_bound_modifier","","",157,{"i":[{"n":"self"},{"n":"traitboundmodifier"}],"o":{"n":"traitboundmodifier"}}],[11,"arm","","",157,{"i":[{"n":"self"},{"g":["p"],"n":"hirvec"},{"g":["expr"],"n":"p"}],"o":{"n":"arm"}}],[11,"field","","",157,{"i":[{"n":"self"},{"n":"ident"},{"g":["expr"],"n":"p"},{"n":"span"}],"o":{"n":"field"}}],[11,"expr_break","","",157,{"i":[{"n":"self"},{"n":"span"},{"g":["attribute"],"n":"thinvec"}],"o":{"g":["expr"],"n":"p"}}],[11,"expr_call","","",157,{"i":[{"n":"self"},{"n":"span"},{"g":["expr"],"n":"p"},{"g":["expr"],"n":"hirvec"}],"o":{"n":"expr"}}],[11,"expr_ident","","",157,{"i":[{"n":"self"},{"n":"span"},{"n":"name"},{"n":"nodeid"}],"o":{"n":"expr"}}],[11,"expr_ident_with_attrs","","",157,{"i":[{"n":"self"},{"n":"span"},{"n":"name"},{"n":"nodeid"},{"g":["attribute"],"n":"thinvec"}],"o":{"n":"expr"}}],[11,"expr_mut_addr_of","","",157,{"i":[{"n":"self"},{"n":"span"},{"g":["expr"],"n":"p"}],"o":{"n":"expr"}}],[11,"expr_std_path","","",157,null],[11,"expr_match","","",157,{"i":[{"n":"self"},{"n":"span"},{"g":["expr"],"n":"p"},{"g":["arm"],"n":"hirvec"},{"n":"matchsource"}],"o":{"n":"expr"}}],[11,"expr_block","","",157,{"i":[{"n":"self"},{"g":["block"],"n":"p"},{"g":["attribute"],"n":"thinvec"}],"o":{"n":"expr"}}],[11,"expr_tuple","","",157,{"i":[{"n":"self"},{"n":"span"},{"g":["expr"],"n":"hirvec"}],"o":{"g":["expr"],"n":"p"}}],[11,"expr","","",157,{"i":[{"n":"self"},{"n":"span"},{"n":"expr_"},{"g":["attribute"],"n":"thinvec"}],"o":{"n":"expr"}}],[11,"stmt_let_pat","","",157,{"i":[{"n":"self"},{"n":"span"},{"g":["p"],"n":"option"},{"g":["pat"],"n":"p"},{"n":"localsource"}],"o":{"n":"stmt"}}],[11,"stmt_let","","",157,null],[11,"block_expr","","",157,{"i":[{"n":"self"},{"g":["expr"],"n":"p"}],"o":{"n":"block"}}],[11,"block_all","","",157,{"i":[{"n":"self"},{"n":"span"},{"g":["stmt"],"n":"hirvec"},{"g":["p"],"n":"option"}],"o":{"n":"block"}}],[11,"pat_ok","","",157,{"i":[{"n":"self"},{"n":"span"},{"g":["pat"],"n":"p"}],"o":{"g":["pat"],"n":"p"}}],[11,"pat_err","","",157,{"i":[{"n":"self"},{"n":"span"},{"g":["pat"],"n":"p"}],"o":{"g":["pat"],"n":"p"}}],[11,"pat_some","","",157,{"i":[{"n":"self"},{"n":"span"},{"g":["pat"],"n":"p"}],"o":{"g":["pat"],"n":"p"}}],[11,"pat_none","","",157,{"i":[{"n":"self"},{"n":"span"}],"o":{"g":["pat"],"n":"p"}}],[11,"pat_std_enum","","",157,null],[11,"pat_ident","","",157,{"i":[{"n":"self"},{"n":"span"},{"n":"name"}],"o":{"g":["pat"],"n":"p"}}],[11,"pat_ident_binding_mode","","",157,{"i":[{"n":"self"},{"n":"span"},{"n":"name"},{"n":"bindingannotation"}],"o":{"g":["pat"],"n":"p"}}],[11,"pat_wild","","",157,{"i":[{"n":"self"},{"n":"span"}],"o":{"g":["pat"],"n":"p"}}],[11,"pat","","",157,{"i":[{"n":"self"},{"n":"span"},{"n":"patkind"}],"o":{"g":["pat"],"n":"p"}}],[11,"std_path","","Given suffix [\"b\",\"c\",\"d\"], returns path `::std::b::c::d` when `fld.cx.use_std`, and `::core::b::c::d` otherwise. The path is also resolved according to `is_value`.",157,null],[11,"ty_path","","",157,{"i":[{"n":"self"},{"n":"lowerednodeid"},{"n":"span"},{"n":"qpath"}],"o":{"g":["ty"],"n":"p"}}],[11,"elided_ref_lifetime","","Invoked to create the lifetime argument for a type `&T` with no explicit lifetime.",157,{"i":[{"n":"self"},{"n":"span"}],"o":{"n":"lifetime"}}],[11,"elided_path_lifetimes","","Invoked to create the lifetime argument(s) for a path like `std::cell::Ref<T>`; note that implicit lifetimes in these sorts of cases are deprecated. This may therefore report a warning or an error, depending on the mode.",157,{"i":[{"n":"self"},{"n":"span"},{"n":"usize"}],"o":{"n":"p"}}],[11,"elided_dyn_bound","","Invoked to create the lifetime argument(s) for an elided trait object bound, like the bound in `Box<dyn Debug>`. This method is not invoked when the bound is written, even if it is written with `'_` like in `Box<dyn Debug + '_>`. In those cases, `lower_lifetime` is invoked.",157,{"i":[{"n":"self"},{"n":"span"}],"o":{"n":"lifetime"}}],[11,"new_implicit_lifetime","","",157,{"i":[{"n":"self"},{"n":"span"}],"o":{"n":"lifetime"}}],[11,"maybe_lint_bare_trait","","",157,{"i":[{"n":"self"},{"n":"span"},{"n":"nodeid"},{"n":"bool"}]}],[11,"wrap_in_try_constructor","","",157,{"i":[{"n":"self"},{"n":"str"},{"n":"expr"},{"n":"span"}],"o":{"g":["expr"],"n":"p"}}],[0,"map","rustc::hir","",null,null],[3,"DefCollector","rustc::hir::map","Creates def ids for nodes in the AST.",null,null],[12,"definitions","","",164,null],[12,"parent_def","","",164,null],[12,"expansion","","",164,null],[12,"visit_macro_invoc","","",164,null],[3,"MacroInvocationData","","",null,null],[12,"mark","","",165,null],[12,"def_index","","",165,null],[3,"Forest","","Stores a crate and any number of inlined items from other crates.",null,null],[12,"krate","","",166,null],[12,"dep_graph","","",166,null],[3,"Map","","Represents a mapping from Node IDs to AST elements and their parent Node IDs",null,null],[12,"forest","","The backing storage for all the AST nodes.",167,null],[12,"dep_graph","","Same as the dep_graph in forest, just available with one fewer deref. This is a gratuitous micro-optimization.",167,null],[12,"crate_hash","","The SVH of the local crate.",167,null],[12,"map","","NodeIds are sequential integers from 0, so we can be super-compact by storing them in a vector. Not everything with a NodeId is in the map, but empirically the occupancy is about 75-80%, so there's not too much overhead (certainly less than a hashmap, since they (at the time of writing) have a maximum of 75% occupancy).",167,null],[12,"definitions","","",167,null],[12,"hir_to_node_id","","The reverse mapping of `node_to_hir_id`.",167,null],[3,"NodesMatchingSuffix","","",null,null],[12,"map","","",168,null],[12,"item_name","","",168,null],[12,"in_which","","",168,null],[12,"idx","","",168,null],[4,"Node","","",null,null],[13,"NodeItem","","",169,null],[13,"NodeForeignItem","","",169,null],[13,"NodeTraitItem","","",169,null],[13,"NodeImplItem","","",169,null],[13,"NodeVariant","","",169,null],[13,"NodeField","","",169,null],[13,"NodeAnonConst","","",169,null],[13,"NodeExpr","","",169,null],[13,"NodeStmt","","",169,null],[13,"NodeTy","","",169,null],[13,"NodeTraitRef","","",169,null],[13,"NodeBinding","","",169,null],[13,"NodePat","","",169,null],[13,"NodeBlock","","",169,null],[13,"NodeLocal","","",169,null],[13,"NodeMacroDef","","",169,null],[13,"NodeStructCtor","","NodeStructCtor represents a tuple struct.",169,null],[13,"NodeLifetime","","",169,null],[13,"NodeTyParam","","",169,null],[13,"NodeVisibility","","",169,null],[4,"MapEntry","","Represents an entry and its parent NodeID. The odd layout is to bring down the total size.",null,null],[13,"NotPresent","","Placeholder for holes in the map.",170,null],[13,"EntryItem","","All the node types, with a parent ID.",170,null],[13,"EntryForeignItem","","",170,null],[13,"EntryTraitItem","","",170,null],[13,"EntryImplItem","","",170,null],[13,"EntryVariant","","",170,null],[13,"EntryField","","",170,null],[13,"EntryAnonConst","","",170,null],[13,"EntryExpr","","",170,null],[13,"EntryStmt","","",170,null],[13,"EntryTy","","",170,null],[13,"EntryTraitRef","","",170,null],[13,"EntryBinding","","",170,null],[13,"EntryPat","","",170,null],[13,"EntryBlock","","",170,null],[13,"EntryStructCtor","","",170,null],[13,"EntryLifetime","","",170,null],[13,"EntryTyParam","","",170,null],[13,"EntryVisibility","","",170,null],[13,"EntryLocal","","",170,null],[13,"EntryMacroDef","","",170,null],[13,"RootCrate","","Roots for node trees. The DepNodeIndex is the dependency node of the crate's root module.",170,null],[5,"map_crate","","",null,{"i":[{"n":"session"},{"n":"cratestore"},{"n":"forest"},{"n":"definitions"}],"o":{"n":"map"}}],[5,"node_id_to_string","","",null,{"i":[{"n":"map"},{"n":"nodeid"},{"n":"bool"}],"o":{"n":"string"}}],[5,"describe_def","","",null,{"i":[{"n":"tyctxt"},{"n":"defid"}],"o":{"g":["def"],"n":"option"}}],[0,"blocks","","This module provides a simplified abstraction for working with code blocks identified by their integer node-id.  In particular, it captures a common set of attributes that all \"function-like things\" (represented by `FnLike` instances) share.  For example, all `FnLike` instances have a type signature (be it explicit or inferred).  And all `FnLike` instances have a body, i.e. the code that is run when the function-like thing it represents is invoked.",null,null],[3,"FnLikeNode","rustc::hir::map::blocks","An FnLikeNode is a Node that is like a fn, in that it has a decl and a body (as well as a NodeId, a span, etc).",null,null],[12,"node","","",171,null],[3,"ItemFnParts","","These are all the components one can extract from a fn item for use when implementing FnLikeNode operations.",null,null],[12,"name","","",172,null],[12,"decl","","",172,null],[12,"unsafety","","",172,null],[12,"constness","","",172,null],[12,"abi","","",172,null],[12,"vis","","",172,null],[12,"generics","","",172,null],[12,"body","","",172,null],[12,"id","","",172,null],[12,"span","","",172,null],[12,"attrs","","",172,null],[3,"ClosureParts","","These are all the components one can extract from a closure expr for use when implementing FnLikeNode operations.",null,null],[12,"decl","","",173,null],[12,"body","","",173,null],[12,"id","","",173,null],[12,"span","","",173,null],[12,"attrs","","",173,null],[4,"Code","","Carries either an FnLikeNode or a Expr, as these are the two constructs that correspond to \"code\" (as in, something from which we can construct a control-flow graph).",null,null],[13,"FnLike","","",174,null],[13,"Expr","","",174,null],[8,"MaybeFnLike","","MaybeFnLike wraps a method that indicates if an object corresponds to some FnLikeNode.",null,null],[10,"is_fn_like","","",175,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"clone","","",171,{"i":[{"n":"self"}],"o":{"n":"fnlikenode"}}],[11,"fmt","","",171,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"is_fn_like","rustc::hir","",83,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"is_fn_like","","",63,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"is_fn_like","","",58,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"clone","rustc::hir::map::blocks","",174,{"i":[{"n":"self"}],"o":{"n":"code"}}],[11,"id","","",174,{"i":[{"n":"self"}],"o":{"n":"nodeid"}}],[11,"from_node","","Attempts to construct a Code from presumed FnLike or Expr node input.",174,{"i":[{"n":"map"},{"n":"nodeid"}],"o":{"g":["code"],"n":"option"}}],[11,"new","","",173,null],[11,"from_node","","Attempts to construct a FnLikeNode from presumed FnLike node input.",171,{"i":[{"n":"node"}],"o":{"g":["fnlikenode"],"n":"option"}}],[11,"body","","",171,{"i":[{"n":"self"}],"o":{"n":"bodyid"}}],[11,"decl","","",171,{"i":[{"n":"self"}],"o":{"n":"fndecl"}}],[11,"span","","",171,{"i":[{"n":"self"}],"o":{"n":"span"}}],[11,"id","","",171,{"i":[{"n":"self"}],"o":{"n":"nodeid"}}],[11,"constness","","",171,{"i":[{"n":"self"}],"o":{"n":"constness"}}],[11,"unsafety","","",171,{"i":[{"n":"self"}],"o":{"n":"unsafety"}}],[11,"kind","","",171,{"i":[{"n":"self"}],"o":{"n":"fnkind"}}],[11,"handle","","",171,{"i":[{"n":"self"},{"n":"i"},{"n":"m"},{"n":"c"}],"o":{"n":"a"}}],[0,"collector","rustc::hir::map","",null,null],[3,"NodeCollector","rustc::hir::map::collector","A Visitor that walks over the HIR and collects Nodes into a HIR map",null,null],[12,"krate","","The crate",176,null],[12,"map","","The node map",176,null],[12,"parent_node","","The parent of this node",176,null],[12,"current_dep_node_owner","","",176,null],[12,"current_signature_dep_index","","",176,null],[12,"current_full_dep_index","","",176,null],[12,"currently_in_body","","",176,null],[12,"dep_graph","","",176,null],[12,"definitions","","",176,null],[12,"hcx","","",176,null],[12,"hir_body_nodes","","",176,null],[3,"HirItemLike","","",null,null],[12,"item_like","","",177,null],[12,"hash_bodies","","",177,null],[11,"root","","",176,{"i":[{"n":"crate"},{"n":"depgraph"},{"n":"definitions"},{"n":"stablehashingcontext"}],"o":{"n":"nodecollector"}}],[11,"finalize_and_compute_crate_hash","","",176,null],[11,"insert_entry","","",176,{"i":[{"n":"self"},{"n":"nodeid"},{"n":"mapentry"}]}],[11,"insert","","",176,{"i":[{"n":"self"},{"n":"nodeid"},{"n":"node"}]}],[11,"with_parent","","",176,{"i":[{"n":"self"},{"n":"nodeid"},{"n":"f"}]}],[11,"with_dep_node_owner","","",176,{"i":[{"n":"self"},{"n":"defindex"},{"n":"t"},{"n":"f"}]}],[11,"nested_visit_map","","Because we want to track parent items and so forth, enable deep walking so that we walk nested items in the context of their outer items.",176,{"i":[{"n":"self"}],"o":{"n":"nestedvisitormap"}}],[11,"visit_nested_item","","",176,{"i":[{"n":"self"},{"n":"itemid"}]}],[11,"visit_nested_trait_item","","",176,{"i":[{"n":"self"},{"n":"traititemid"}]}],[11,"visit_nested_impl_item","","",176,{"i":[{"n":"self"},{"n":"implitemid"}]}],[11,"visit_nested_body","","",176,{"i":[{"n":"self"},{"n":"bodyid"}]}],[11,"visit_item","","",176,{"i":[{"n":"self"},{"n":"item"}]}],[11,"visit_foreign_item","","",176,{"i":[{"n":"self"},{"n":"foreignitem"}]}],[11,"visit_generic_param","","",176,{"i":[{"n":"self"},{"n":"genericparam"}]}],[11,"visit_trait_item","","",176,{"i":[{"n":"self"},{"n":"traititem"}]}],[11,"visit_impl_item","","",176,{"i":[{"n":"self"},{"n":"implitem"}]}],[11,"visit_pat","","",176,{"i":[{"n":"self"},{"n":"pat"}]}],[11,"visit_anon_const","","",176,{"i":[{"n":"self"},{"n":"anonconst"}]}],[11,"visit_expr","","",176,{"i":[{"n":"self"},{"n":"expr"}]}],[11,"visit_stmt","","",176,{"i":[{"n":"self"},{"n":"stmt"}]}],[11,"visit_ty","","",176,{"i":[{"n":"self"},{"n":"ty"}]}],[11,"visit_trait_ref","","",176,{"i":[{"n":"self"},{"n":"traitref"}]}],[11,"visit_fn","","",176,{"i":[{"n":"self"},{"n":"fnkind"},{"n":"fndecl"},{"n":"bodyid"},{"n":"span"},{"n":"nodeid"}]}],[11,"visit_block","","",176,{"i":[{"n":"self"},{"n":"block"}]}],[11,"visit_local","","",176,{"i":[{"n":"self"},{"n":"local"}]}],[11,"visit_lifetime","","",176,{"i":[{"n":"self"},{"n":"lifetime"}]}],[11,"visit_vis","","",176,{"i":[{"n":"self"},{"n":"visibility"}]}],[11,"visit_macro_def","","",176,{"i":[{"n":"self"},{"n":"macrodef"}]}],[11,"visit_variant","","",176,{"i":[{"n":"self"},{"n":"variant"},{"n":"generics"},{"n":"nodeid"}]}],[11,"visit_struct_field","","",176,{"i":[{"n":"self"},{"n":"structfield"}]}],[11,"visit_trait_item_ref","","",176,{"i":[{"n":"self"},{"n":"traititemref"}]}],[11,"visit_impl_item_ref","","",176,{"i":[{"n":"self"},{"n":"implitemref"}]}],[11,"hash_stable","","",177,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[0,"def_collector","rustc::hir::map","",null,null],[3,"DefCollector","rustc::hir::map::def_collector","Creates def ids for nodes in the AST.",null,null],[12,"definitions","","",164,null],[12,"parent_def","","",164,null],[12,"expansion","","",164,null],[12,"visit_macro_invoc","","",164,null],[3,"MacroInvocationData","","",null,null],[12,"mark","","",165,null],[12,"def_index","","",165,null],[11,"new","rustc::hir::map","",164,{"i":[{"n":"definitions"},{"n":"mark"}],"o":{"n":"self"}}],[11,"collect_root","","",164,{"i":[{"n":"self"},{"n":"str"},{"n":"cratedisambiguator"}]}],[11,"create_def","","",164,{"i":[{"n":"self"},{"n":"nodeid"},{"n":"defpathdata"},{"n":"defindexaddressspace"},{"n":"span"}],"o":{"n":"defindex"}}],[11,"with_parent","","",164,{"i":[{"n":"self"},{"n":"defindex"},{"n":"f"}]}],[11,"visit_macro_invoc","","",164,{"i":[{"n":"self"},{"n":"nodeid"}]}],[11,"visit_item","","",164,{"i":[{"n":"self"},{"n":"item"}]}],[11,"visit_use_tree","","",164,{"i":[{"n":"self"},{"n":"usetree"},{"n":"nodeid"},{"n":"bool"}]}],[11,"visit_foreign_item","","",164,{"i":[{"n":"self"},{"n":"foreignitem"}]}],[11,"visit_variant","","",164,{"i":[{"n":"self"},{"n":"variant"},{"n":"generics"},{"n":"nodeid"}]}],[11,"visit_variant_data","","",164,{"i":[{"n":"self"},{"n":"variantdata"},{"n":"ident"},{"n":"generics"},{"n":"nodeid"},{"n":"span"}]}],[11,"visit_generic_param","","",164,{"i":[{"n":"self"},{"n":"genericparam"}]}],[11,"visit_trait_item","","",164,{"i":[{"n":"self"},{"n":"traititem"}]}],[11,"visit_impl_item","","",164,{"i":[{"n":"self"},{"n":"implitem"}]}],[11,"visit_pat","","",164,{"i":[{"n":"self"},{"n":"pat"}]}],[11,"visit_anon_const","","",164,{"i":[{"n":"self"},{"n":"anonconst"}]}],[11,"visit_expr","","",164,{"i":[{"n":"self"},{"n":"expr"}]}],[11,"visit_ty","","",164,{"i":[{"n":"self"},{"n":"ty"}]}],[11,"visit_stmt","","",164,{"i":[{"n":"self"},{"n":"stmt"}]}],[11,"visit_token","","",164,{"i":[{"n":"self"},{"n":"token"}]}],[0,"definitions","","For each definition, we track the following data.  A definition here is defined somewhat circularly as \"something with a def-id\", but it generally corresponds to things like structs, enums, etc. There are also some rather random cases (like const initializer expressions) that are mostly just leftovers.",null,null],[3,"DefPathTable","rustc::hir::map::definitions","The DefPathTable maps DefIndexes to DefKeys and vice versa. Internally the DefPathTable holds a tree of DefKeys, where each DefKey stores the DefIndex of its parent. There is one DefPathTable for each crate.",null,null],[12,"index_to_key","","",178,null],[12,"def_path_hashes","","",178,null],[3,"Definitions","","The definition table containing node definitions. It holds the DefPathTable for local DefIds/DefPaths and it also stores a mapping from NodeIds to local DefIds.",null,null],[12,"table","","",179,null],[12,"node_to_def_index","","",179,null],[12,"def_index_to_node","","",179,null],[12,"node_to_hir_id","","",179,null],[12,"macro_def_scopes","","",179,null],[12,"expansions","","",179,null],[12,"next_disambiguator","","",179,null],[12,"def_index_to_span","","",179,null],[3,"DefKey","","A unique identifier that we can use to lookup a definition precisely. It combines the index of the definition's parent (if any) with a `DisambiguatedDefPathData`.",null,null],[12,"parent","","Parent path.",180,null],[12,"disambiguated_data","","Identifier of this node.",180,null],[3,"DisambiguatedDefPathData","","Pair of `DefPathData` and an integer disambiguator. The integer is normally 0, but in the event that there are multiple defs with the same `parent` and `data`, we use this field to disambiguate between them. This introduces some artificial ordering dependency but means that if you have (e.g.) two impls for the same type in the same module, they do get distinct def-ids.",null,null],[12,"data","","",181,null],[12,"disambiguator","","",181,null],[3,"DefPath","","",null,null],[12,"data","","the path leading from the crate root to the item",182,null],[12,"krate","","what krate root is this path relative to?",182,null],[3,"DefPathHash","","",null,null],[12,"0","","",183,null],[4,"DefPathData","","",null,null],[13,"CrateRoot","","The crate root (marker)",184,null],[13,"Misc","","",184,null],[13,"Impl","","An impl",184,null],[13,"Trait","","A trait",184,null],[13,"AssocTypeInTrait","","An associated type declaration (i.e., in a trait)",184,null],[13,"AssocTypeInImpl","","An associated type value (i.e., in an impl)",184,null],[13,"TypeNs","","Something in the type NS",184,null],[13,"ValueNs","","Something in the value NS",184,null],[13,"Module","","A module declaration",184,null],[13,"MacroDef","","A macro rule",184,null],[13,"ClosureExpr","","A closure expression",184,null],[13,"TypeParam","","A type parameter (generic parameter)",184,null],[13,"LifetimeDef","","A lifetime definition",184,null],[13,"EnumVariant","","A variant of a enum",184,null],[13,"Field","","A struct field",184,null],[13,"StructCtor","","Implicit ctor for a tuple-like struct",184,null],[13,"AnonConst","","A constant expression (see {ast,hir}::AnonConst).",184,null],[13,"UniversalImplTrait","","An `impl Trait` type node in argument position.",184,null],[13,"ExistentialImplTrait","","An `impl Trait` type node in return position.",184,null],[13,"GlobalMetaData","","GlobalMetaData identifies a piece of crate metadata that is global to a whole crate (as opposed to just one item). GlobalMetaData components are only supposed to show up right below the crate root.",184,null],[4,"GlobalMetaDataKind","","",null,null],[13,"Krate","","",185,null],[13,"CrateDeps","","",185,null],[13,"DylibDependencyFormats","","",185,null],[13,"LangItems","","",185,null],[13,"LangItemsMissing","","",185,null],[13,"NativeLibraries","","",185,null],[13,"CodeMap","","",185,null],[13,"Impls","","",185,null],[13,"ExportedSymbols","","",185,null],[17,"GLOBAL_MD_ADDRESS_SPACE","","",null,null],[11,"clone","","",178,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"allocate","","",178,{"i":[{"n":"self"},{"n":"defkey"},{"n":"defpathhash"},{"n":"defindexaddressspace"}],"o":{"n":"defindex"}}],[11,"next_id","","",178,{"i":[{"n":"self"},{"n":"defindexaddressspace"}],"o":{"n":"defindex"}}],[11,"def_key","","",178,{"i":[{"n":"self"},{"n":"defindex"}],"o":{"n":"defkey"}}],[11,"def_path_hash","","",178,{"i":[{"n":"self"},{"n":"defindex"}],"o":{"n":"defpathhash"}}],[11,"add_def_path_hashes_to","","",178,{"i":[{"n":"self"},{"n":"cratenum"},{"n":"fxhashmap"}]}],[11,"size","","",178,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"encode","","",178,{"i":[{"n":"self"},{"n":"s"}],"o":{"n":"result"}}],[11,"decode","","",178,{"i":[{"n":"d"}],"o":{"g":["defpathtable"],"n":"result"}}],[11,"clone","","",179,{"i":[{"n":"self"}],"o":{"n":"self"}}],[11,"clone","","",180,{"i":[{"n":"self"}],"o":{"n":"defkey"}}],[11,"fmt","","",180,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"eq","","",180,{"i":[{"n":"self"},{"n":"defkey"}],"o":{"n":"bool"}}],[11,"ne","","",180,{"i":[{"n":"self"},{"n":"defkey"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",180,null],[11,"hash","","",180,null],[11,"encode","","",180,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",180,{"i":[{"n":"__d"}],"o":{"g":["defkey"],"n":"result"}}],[11,"compute_stable_hash","","",180,{"i":[{"n":"self"},{"n":"defpathhash"}],"o":{"n":"defpathhash"}}],[11,"root_parent_stable_hash","","",180,{"i":[{"n":"str"},{"n":"cratedisambiguator"}],"o":{"n":"defpathhash"}}],[11,"clone","","",181,{"i":[{"n":"self"}],"o":{"n":"disambiguateddefpathdata"}}],[11,"fmt","","",181,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"eq","","",181,{"i":[{"n":"self"},{"n":"disambiguateddefpathdata"}],"o":{"n":"bool"}}],[11,"ne","","",181,{"i":[{"n":"self"},{"n":"disambiguateddefpathdata"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",181,null],[11,"hash","","",181,null],[11,"encode","","",181,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",181,{"i":[{"n":"__d"}],"o":{"g":["disambiguateddefpathdata"],"n":"result"}}],[11,"clone","","",182,{"i":[{"n":"self"}],"o":{"n":"defpath"}}],[11,"fmt","","",182,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"eq","","",182,{"i":[{"n":"self"},{"n":"defpath"}],"o":{"n":"bool"}}],[11,"ne","","",182,{"i":[{"n":"self"},{"n":"defpath"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",182,null],[11,"hash","","",182,null],[11,"encode","","",182,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",182,{"i":[{"n":"__d"}],"o":{"g":["defpath"],"n":"result"}}],[11,"is_local","","",182,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"make","","",182,{"i":[{"n":"cratenum"},{"n":"defindex"},{"n":"fn"}],"o":{"n":"defpath"}}],[11,"to_string_no_crate","","Returns a string representation of the DefPath without the crate-prefix. This method is useful if you don't have a TyCtxt available.",182,{"i":[{"n":"self"}],"o":{"n":"string"}}],[11,"to_filename_friendly_no_crate","","Return filename friendly string of the DefPah without the crate-prefix. This method is useful if you don't have a TyCtxt available.",182,{"i":[{"n":"self"}],"o":{"n":"string"}}],[11,"clone","","",184,{"i":[{"n":"self"}],"o":{"n":"defpathdata"}}],[11,"fmt","","",184,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"assert_receiver_is_total_eq","","",184,null],[11,"eq","","",184,{"i":[{"n":"self"},{"n":"defpathdata"}],"o":{"n":"bool"}}],[11,"ne","","",184,{"i":[{"n":"self"},{"n":"defpathdata"}],"o":{"n":"bool"}}],[11,"hash","","",184,null],[11,"encode","","",184,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",184,{"i":[{"n":"__d"}],"o":{"g":["defpathdata"],"n":"result"}}],[11,"clone","","",183,{"i":[{"n":"self"}],"o":{"n":"defpathhash"}}],[11,"hash","","",183,null],[11,"eq","","",183,{"i":[{"n":"self"},{"n":"defpathhash"}],"o":{"n":"bool"}}],[11,"ne","","",183,{"i":[{"n":"self"},{"n":"defpathhash"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",183,null],[11,"partial_cmp","","",183,{"i":[{"n":"self"},{"n":"defpathhash"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",183,{"i":[{"n":"self"},{"n":"defpathhash"}],"o":{"n":"bool"}}],[11,"le","","",183,{"i":[{"n":"self"},{"n":"defpathhash"}],"o":{"n":"bool"}}],[11,"gt","","",183,{"i":[{"n":"self"},{"n":"defpathhash"}],"o":{"n":"bool"}}],[11,"ge","","",183,{"i":[{"n":"self"},{"n":"defpathhash"}],"o":{"n":"bool"}}],[11,"cmp","","",183,{"i":[{"n":"self"},{"n":"defpathhash"}],"o":{"n":"ordering"}}],[11,"fmt","","",183,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"encode","","",183,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",183,{"i":[{"n":"__d"}],"o":{"g":["defpathhash"],"n":"result"}}],[11,"hash_stable","","",183,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"new","","Create new empty definition map.",179,{"o":{"n":"definitions"}}],[11,"def_path_table","","",179,{"i":[{"n":"self"}],"o":{"n":"defpathtable"}}],[11,"def_index_counts_lo_hi","","Get the number of definitions.",179,null],[11,"def_key","","",179,{"i":[{"n":"self"},{"n":"defindex"}],"o":{"n":"defkey"}}],[11,"def_path_hash","","",179,{"i":[{"n":"self"},{"n":"defindex"}],"o":{"n":"defpathhash"}}],[11,"def_path","","Returns the path from the crate root to `index`. The root nodes are not included in the path (i.e., this will be an empty vector for the crate root). For an inlined item, this will be the path of the item in the external crate (but the path will begin with the path to the external crate).",179,{"i":[{"n":"self"},{"n":"defindex"}],"o":{"n":"defpath"}}],[11,"opt_def_index","","",179,{"i":[{"n":"self"},{"n":"nodeid"}],"o":{"g":["defindex"],"n":"option"}}],[11,"opt_local_def_id","","",179,{"i":[{"n":"self"},{"n":"nodeid"}],"o":{"g":["defid"],"n":"option"}}],[11,"local_def_id","","",179,{"i":[{"n":"self"},{"n":"nodeid"}],"o":{"n":"defid"}}],[11,"as_local_node_id","","",179,{"i":[{"n":"self"},{"n":"defid"}],"o":{"g":["nodeid"],"n":"option"}}],[11,"node_to_hir_id","","",179,{"i":[{"n":"self"},{"n":"nodeid"}],"o":{"n":"hirid"}}],[11,"def_index_to_hir_id","","",179,{"i":[{"n":"self"},{"n":"defindex"}],"o":{"n":"hirid"}}],[11,"opt_span","","Retrieve the span of the given `DefId` if `DefId` is in the local crate, the span exists and it's not DUMMY_SP",179,{"i":[{"n":"self"},{"n":"defid"}],"o":{"g":["span"],"n":"option"}}],[11,"create_root_def","","Add a definition with a parent definition.",179,{"i":[{"n":"self"},{"n":"str"},{"n":"cratedisambiguator"}],"o":{"n":"defindex"}}],[11,"create_def_with_parent","","Add a definition with a parent definition.",179,{"i":[{"n":"self"},{"n":"defindex"},{"n":"nodeid"},{"n":"defpathdata"},{"n":"defindexaddressspace"},{"n":"mark"},{"n":"span"}],"o":{"n":"defindex"}}],[11,"init_node_id_to_hir_id_mapping","","Initialize the ast::NodeId to HirId mapping once it has been generated during AST to HIR lowering.",179,{"i":[{"n":"self"},{"g":["nodeid","hirid"],"n":"indexvec"}]}],[11,"expansion","","",179,{"i":[{"n":"self"},{"n":"defindex"}],"o":{"n":"mark"}}],[11,"macro_def_scope","","",179,{"i":[{"n":"self"},{"n":"mark"}],"o":{"n":"defid"}}],[11,"add_macro_def_scope","","",179,{"i":[{"n":"self"},{"n":"mark"},{"n":"defid"}]}],[11,"get_opt_name","","",184,{"i":[{"n":"self"}],"o":{"g":["internedstring"],"n":"option"}}],[11,"as_interned_str","","",184,{"i":[{"n":"self"}],"o":{"n":"internedstring"}}],[11,"to_string","","",184,{"i":[{"n":"self"}],"o":{"n":"string"}}],[11,"clone","","",185,{"i":[{"n":"self"}],"o":{"n":"globalmetadatakind"}}],[11,"fmt","","",185,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"eq","","",185,{"i":[{"n":"self"},{"n":"globalmetadatakind"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",185,null],[11,"partial_cmp","","",185,{"i":[{"n":"self"},{"n":"globalmetadatakind"}],"o":{"g":["ordering"],"n":"option"}}],[11,"cmp","","",185,{"i":[{"n":"self"},{"n":"globalmetadatakind"}],"o":{"n":"ordering"}}],[11,"hash","","",185,null],[11,"encode","","",185,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",185,{"i":[{"n":"__d"}],"o":{"g":["globalmetadatakind"],"n":"result"}}],[11,"allocate_def_indices","","",185,{"i":[{"n":"definitions"}]}],[11,"def_index","","",185,{"i":[{"n":"self"},{"n":"defpathtable"}],"o":{"n":"defindex"}}],[11,"name","","",185,{"i":[{"n":"self"}],"o":{"n":"symbol"}}],[0,"hir_id_validator","rustc::hir::map","",null,null],[3,"HirIdValidator","rustc::hir::map::hir_id_validator","",null,null],[12,"hir_map","","",186,null],[12,"owner_def_index","","",186,null],[12,"hir_ids_seen","","",186,null],[12,"errors","","",186,null],[3,"OuterVisitor","","",null,null],[12,"hir_map","","",187,null],[12,"errors","","",187,null],[5,"check_crate","","",null,{"i":[{"n":"map"}]}],[11,"new_inner_visitor","","",187,{"i":[{"n":"self"},{"n":"map"}],"o":{"n":"hiridvalidator"}}],[11,"visit_item","","",187,{"i":[{"n":"self"},{"n":"item"}]}],[11,"visit_trait_item","","",187,{"i":[{"n":"self"},{"n":"traititem"}]}],[11,"visit_impl_item","","",187,{"i":[{"n":"self"},{"n":"implitem"}]}],[11,"check","","",186,{"i":[{"n":"self"},{"n":"nodeid"},{"n":"f"}]}],[11,"nested_visit_map","","",186,{"i":[{"n":"self"}],"o":{"n":"nestedvisitormap"}}],[11,"visit_id","","",186,{"i":[{"n":"self"},{"n":"nodeid"}]}],[11,"visit_impl_item_ref","","",186,{"i":[{"n":"self"},{"n":"implitemref"}]}],[17,"ITEM_LIKE_SPACE","rustc::hir::map","",null,null],[17,"REGULAR_SPACE","","",null,null],[8,"Named","","",null,null],[10,"name","","",188,{"i":[{"n":"self"}],"o":{"n":"name"}}],[11,"clone","","",169,{"i":[{"n":"self"}],"o":{"n":"node"}}],[11,"fmt","","",169,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",170,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",170,{"i":[{"n":"self"}],"o":{"n":"mapentry"}}],[11,"parent_node","","",170,{"i":[{"n":"self"}],"o":{"g":["nodeid"],"n":"option"}}],[11,"to_node","","",170,{"i":[{"n":"self"}],"o":{"g":["node"],"n":"option"}}],[11,"fn_decl","","",170,{"i":[{"n":"self"}],"o":{"g":["fndecl"],"n":"option"}}],[11,"associated_body","","",170,{"i":[{"n":"self"}],"o":{"g":["bodyid"],"n":"option"}}],[11,"is_body_owner","","",170,{"i":[{"n":"self"},{"n":"nodeid"}],"o":{"n":"bool"}}],[11,"new","","",166,{"i":[{"n":"crate"},{"n":"depgraph"}],"o":{"n":"forest"}}],[11,"krate","","",166,{"i":[{"n":"self"}],"o":{"n":"crate"}}],[11,"clone","","",167,{"i":[{"n":"self"}],"o":{"n":"map"}}],[11,"read","","Registers a read in the dependency graph of the AST node with the given `id`. This needs to be called each time a public function returns the HIR for a node -- in other words, when it \"reveals\" the content of a node to the caller (who might not otherwise have had access to those contents, and hence needs a read recorded). If the function just returns a DefId or NodeId, no actual content was returned, so no read is needed.",167,{"i":[{"n":"self"},{"n":"nodeid"}]}],[11,"definitions","","",167,{"i":[{"n":"self"}],"o":{"n":"definitions"}}],[11,"def_key","","",167,{"i":[{"n":"self"},{"n":"defid"}],"o":{"n":"defkey"}}],[11,"def_path_from_id","","",167,{"i":[{"n":"self"},{"n":"nodeid"}],"o":{"g":["defpath"],"n":"option"}}],[11,"def_path","","",167,{"i":[{"n":"self"},{"n":"defid"}],"o":{"n":"defpath"}}],[11,"local_def_id","","",167,{"i":[{"n":"self"},{"n":"nodeid"}],"o":{"n":"defid"}}],[11,"opt_local_def_id","","",167,{"i":[{"n":"self"},{"n":"nodeid"}],"o":{"g":["defid"],"n":"option"}}],[11,"as_local_node_id","","",167,{"i":[{"n":"self"},{"n":"defid"}],"o":{"g":["nodeid"],"n":"option"}}],[11,"hir_to_node_id","","",167,{"i":[{"n":"self"},{"n":"hirid"}],"o":{"n":"nodeid"}}],[11,"node_to_hir_id","","",167,{"i":[{"n":"self"},{"n":"nodeid"}],"o":{"n":"hirid"}}],[11,"def_index_to_hir_id","","",167,{"i":[{"n":"self"},{"n":"defindex"}],"o":{"n":"hirid"}}],[11,"def_index_to_node_id","","",167,{"i":[{"n":"self"},{"n":"defindex"}],"o":{"n":"nodeid"}}],[11,"local_def_id_to_hir_id","","",167,{"i":[{"n":"self"},{"n":"localdefid"}],"o":{"n":"hirid"}}],[11,"local_def_id_to_node_id","","",167,{"i":[{"n":"self"},{"n":"localdefid"}],"o":{"n":"nodeid"}}],[11,"describe_def","","",167,{"i":[{"n":"self"},{"n":"nodeid"}],"o":{"g":["def"],"n":"option"}}],[11,"entry_count","","",167,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"find_entry","","",167,{"i":[{"n":"self"},{"n":"nodeid"}],"o":{"g":["mapentry"],"n":"option"}}],[11,"krate","","",167,{"i":[{"n":"self"}],"o":{"n":"crate"}}],[11,"trait_item","","",167,{"i":[{"n":"self"},{"n":"traititemid"}],"o":{"n":"traititem"}}],[11,"impl_item","","",167,{"i":[{"n":"self"},{"n":"implitemid"}],"o":{"n":"implitem"}}],[11,"body","","",167,{"i":[{"n":"self"},{"n":"bodyid"}],"o":{"n":"body"}}],[11,"fn_decl","","",167,{"i":[{"n":"self"},{"n":"nodeid"}],"o":{"g":["fndecl"],"n":"option"}}],[11,"body_owner","","Returns the `NodeId` that corresponds to the definition of which this is the body of, i.e. a `fn`, `const` or `static` item (possibly associated), a closure, or a `hir::AnonConst`.",167,{"i":[{"n":"self"},{"n":"bodyid"}],"o":{"n":"nodeid"}}],[11,"body_owner_def_id","","",167,{"i":[{"n":"self"},{"n":"bodyid"}],"o":{"n":"defid"}}],[11,"maybe_body_owned_by","","Given a node id, returns the `BodyId` associated with it, if the node is a body owner, otherwise returns `None`.",167,{"i":[{"n":"self"},{"n":"nodeid"}],"o":{"g":["bodyid"],"n":"option"}}],[11,"body_owned_by","","Given a body owner's id, returns the `BodyId` associated with it.",167,{"i":[{"n":"self"},{"n":"nodeid"}],"o":{"n":"bodyid"}}],[11,"body_owner_kind","","",167,{"i":[{"n":"self"},{"n":"nodeid"}],"o":{"n":"bodyownerkind"}}],[11,"ty_param_owner","","",167,{"i":[{"n":"self"},{"n":"nodeid"}],"o":{"n":"nodeid"}}],[11,"ty_param_name","","",167,{"i":[{"n":"self"},{"n":"nodeid"}],"o":{"n":"name"}}],[11,"trait_impls","","",167,null],[11,"trait_auto_impl","","",167,{"i":[{"n":"self"},{"n":"defid"}],"o":{"g":["nodeid"],"n":"option"}}],[11,"trait_is_auto","","",167,{"i":[{"n":"self"},{"n":"defid"}],"o":{"n":"bool"}}],[11,"krate_attrs","","Get the attributes on the krate. This is preferable to invoking `krate.attrs` because it registers a tighter dep-graph access.",167,null],[11,"get","","Retrieve the Node corresponding to `id`, panicking if it cannot be found.",167,{"i":[{"n":"self"},{"n":"nodeid"}],"o":{"n":"node"}}],[11,"get_if_local","","",167,{"i":[{"n":"self"},{"n":"defid"}],"o":{"g":["node"],"n":"option"}}],[11,"find","","Retrieve the Node corresponding to `id`, returning None if cannot be found.",167,{"i":[{"n":"self"},{"n":"nodeid"}],"o":{"g":["node"],"n":"option"}}],[11,"get_parent_node","","Similar to get_parent, returns the parent node id or id if there is no parent. Note that the parent may be CRATE_NODE_ID, which is not itself present in the map -- so passing the return value of get_parent_node to get may actually panic. This function returns the immediate parent in the AST, whereas get_parent returns the enclosing item. Note that this might not be the actual parent node in the AST - some kinds of nodes are not in the map and these will never appear as the parent_node. So you can always walk the parent_nodes from a node to the root of the ast (unless you get the same id back here that can happen if the id is not in the map itself or is just weird).",167,{"i":[{"n":"self"},{"n":"nodeid"}],"o":{"n":"nodeid"}}],[11,"is_argument","","Check if the node is an argument. An argument is a local variable whose immediate parent is an item or a closure.",167,{"i":[{"n":"self"},{"n":"nodeid"}],"o":{"n":"bool"}}],[11,"walk_parent_nodes","","If there is some error when walking the parents (e.g., a node does not have a parent in the map or a node can't be found), then we return the last good node id we found. Note that reaching the crate root (id == 0), is not an error, since items in the crate module have the crate root as parent.",167,{"i":[{"n":"self"},{"n":"nodeid"},{"n":"f"},{"n":"f2"}],"o":{"g":["nodeid","nodeid"],"n":"result"}}],[11,"get_return_block","","Retrieve the NodeId for `id`'s enclosing method, unless there's a `while` or `loop` before reaching it, as block tail returns are not available in them.",167,{"i":[{"n":"self"},{"n":"nodeid"}],"o":{"g":["nodeid"],"n":"option"}}],[11,"get_parent","","Retrieve the NodeId for `id`'s parent item, or `id` itself if no parent item is in this map. The \"parent item\" is the closest parent node in the HIR which is recorded by the map and is an item, either an item in a module, trait, or impl.",167,{"i":[{"n":"self"},{"n":"nodeid"}],"o":{"n":"nodeid"}}],[11,"get_module_parent","","Returns the NodeId of `id`'s nearest module parent, or `id` itself if no module parent is in this map.",167,{"i":[{"n":"self"},{"n":"nodeid"}],"o":{"n":"defid"}}],[11,"get_enclosing_scope","","Returns the nearest enclosing scope. A scope is an item or block. FIXME it is not clear to me that all items qualify as scopes - statics and associated types probably shouldn't, for example. Behavior in this regard should be expected to be highly unstable.",167,{"i":[{"n":"self"},{"n":"nodeid"}],"o":{"g":["nodeid"],"n":"option"}}],[11,"get_parent_did","","",167,{"i":[{"n":"self"},{"n":"nodeid"}],"o":{"n":"defid"}}],[11,"get_foreign_abi","","",167,{"i":[{"n":"self"},{"n":"nodeid"}],"o":{"n":"abi"}}],[11,"expect_item","","",167,{"i":[{"n":"self"},{"n":"nodeid"}],"o":{"n":"item"}}],[11,"expect_impl_item","","",167,{"i":[{"n":"self"},{"n":"nodeid"}],"o":{"n":"implitem"}}],[11,"expect_trait_item","","",167,{"i":[{"n":"self"},{"n":"nodeid"}],"o":{"n":"traititem"}}],[11,"expect_variant_data","","",167,{"i":[{"n":"self"},{"n":"nodeid"}],"o":{"n":"variantdata"}}],[11,"expect_variant","","",167,{"i":[{"n":"self"},{"n":"nodeid"}],"o":{"n":"variant"}}],[11,"expect_foreign_item","","",167,{"i":[{"n":"self"},{"n":"nodeid"}],"o":{"n":"foreignitem"}}],[11,"expect_expr","","",167,{"i":[{"n":"self"},{"n":"nodeid"}],"o":{"n":"expr"}}],[11,"name","","Returns the name associated with the given NodeId's AST.",167,{"i":[{"n":"self"},{"n":"nodeid"}],"o":{"n":"name"}}],[11,"attrs","","Given a node ID, get a list of attributes associated with the AST corresponding to the Node ID",167,null],[11,"nodes_matching_suffix","","Returns an iterator that yields the node id's with paths that match `parts`.  (Requires `parts` is non-empty.)",167,null],[11,"span","","",167,{"i":[{"n":"self"},{"n":"nodeid"}],"o":{"n":"span"}}],[11,"span_if_local","","",167,{"i":[{"n":"self"},{"n":"defid"}],"o":{"g":["span"],"n":"option"}}],[11,"node_to_string","","",167,{"i":[{"n":"self"},{"n":"nodeid"}],"o":{"n":"string"}}],[11,"node_to_user_string","","",167,{"i":[{"n":"self"},{"n":"nodeid"}],"o":{"n":"string"}}],[11,"node_to_pretty_string","","",167,{"i":[{"n":"self"},{"n":"nodeid"}],"o":{"n":"string"}}],[11,"suffix_matches","","Returns true only if some suffix of the module path for parent matches `self.in_which`.",168,{"i":[{"n":"self"},{"n":"nodeid"}],"o":{"n":"bool"}}],[11,"matches_names","","",168,{"i":[{"n":"self"},{"n":"nodeid"},{"n":"name"}],"o":{"n":"bool"}}],[11,"next","","",168,{"i":[{"n":"self"}],"o":{"g":["nodeid"],"n":"option"}}],[11,"name","rustc::hir","",83,{"i":[{"n":"self"}],"o":{"n":"name"}}],[11,"name","","",86,{"i":[{"n":"self"}],"o":{"n":"name"}}],[11,"name","","",78,{"i":[{"n":"self"}],"o":{"n":"name"}}],[11,"name","","",81,{"i":[{"n":"self"}],"o":{"n":"name"}}],[11,"name","","",63,{"i":[{"n":"self"}],"o":{"n":"name"}}],[11,"name","","",65,{"i":[{"n":"self"}],"o":{"n":"name"}}],[11,"nested","rustc::hir::map","",167,{"i":[{"n":"self"},{"n":"state"},{"n":"nested"}],"o":{"n":"result"}}],[0,"pat_util","rustc::hir","",null,null],[3,"EnumerateAndAdjust","rustc::hir::pat_util","",null,null],[12,"enumerate","","",189,null],[12,"gap_pos","","",189,null],[12,"gap_len","","",189,null],[8,"EnumerateAndAdjustIterator","","",null,null],[10,"enumerate_and_adjust","","",190,{"i":[{"n":"self"},{"n":"usize"},{"g":["usize"],"n":"option"}],"o":{"n":"enumerateandadjust"}}],[11,"next","","",189,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"size_hint","","",189,null],[11,"is_refutable","rustc::hir","",50,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"is_const","","",50,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"each_binding","","Call `f` on every \"binding\" in a pattern, e.g., on `a` in `match foo() { Some(a) => (), None => () }`",50,{"i":[{"n":"self"},{"n":"f"}]}],[11,"contains_bindings","","Checks if the pattern contains any patterns that bind something to an ident, e.g. `foo`, or `Foo(foo)` or `foo @ Bar(..)`.",50,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"contains_bindings_or_wild","","Checks if the pattern contains any patterns that bind something to an ident or wildcard, e.g. `foo`, or `Foo(_)`, `foo @ Bar(..)`,",50,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"simple_name","","",50,{"i":[{"n":"self"}],"o":{"g":["name"],"n":"option"}}],[11,"simple_span","","",50,{"i":[{"n":"self"}],"o":{"g":["span"],"n":"option"}}],[11,"necessary_variants","","Return variants that are necessary to exist for the pattern to match.",50,{"i":[{"n":"self"}],"o":{"g":["defid"],"n":"vec"}}],[11,"contains_explicit_ref_binding","","Checks if the pattern contains any `ref` or `ref mut` bindings, and if yes whether it contains mutable or just immutables ones.",50,{"i":[{"n":"self"}],"o":{"g":["mutability"],"n":"option"}}],[11,"contains_explicit_ref_binding","","Checks if the patterns for this arm contain any `ref` or `ref mut` bindings, and if yes whether its containing mutable ones or just immutables ones.",53,{"i":[{"n":"self"}],"o":{"g":["mutability"],"n":"option"}}],[0,"print","","",null,null],[3,"NoAnn","rustc::hir::print","",null,null],[3,"State","","",null,null],[12,"s","","",191,null],[12,"cm","","",191,null],[12,"comments","","",191,null],[12,"literals","","",191,null],[12,"cur_cmnt","","",191,null],[12,"boxes","","",191,null],[12,"ann","","",191,null],[4,"AnnNode","","",null,null],[13,"NodeName","","",192,null],[13,"NodeBlock","","",192,null],[13,"NodeItem","","",192,null],[13,"NodeSubItem","","",192,null],[13,"NodeExpr","","",192,null],[13,"NodePat","","",192,null],[4,"Nested","","",null,null],[13,"Item","","",193,null],[13,"TraitItem","","",193,null],[13,"ImplItem","","",193,null],[13,"Body","","",193,null],[13,"BodyArgPat","","",193,null],[5,"print_crate","","Requires you to pass an input filename and reader so that it can scan the input text for comments and literals to copy forward.",null,{"i":[{"n":"codemap"},{"n":"parsesess"},{"n":"crate"},{"n":"filename"},{"n":"read"},{"g":["write"],"n":"box"},{"n":"ppann"},{"n":"bool"}],"o":{"n":"result"}}],[5,"to_string","","",null,{"i":[{"n":"ppann"},{"n":"f"}],"o":{"n":"string"}}],[5,"visibility_qualified","","",null,{"i":[{"n":"visibility"},{"n":"str"}],"o":{"n":"string"}}],[5,"expr_requires_semi_to_be_stmt","","Does this expression require a semicolon to be treated as a statement? The negation of this: 'can this expression be used as a statement without a semicolon' -- is used as an early-bail-out in the parser so that, for instance,     if true {...} else {...}      |x| 5 isn't parsed as (if true {...} else {...} | x) | 5",null,{"i":[{"n":"expr"}],"o":{"n":"bool"}}],[5,"stmt_ends_with_semi","","this statement requires a semicolon after it. note that in one case (stmt_semi), we've already seen the semicolon, and thus don't need another.",null,{"i":[{"n":"stmt_"}],"o":{"n":"bool"}}],[5,"bin_op_to_assoc_op","","",null,{"i":[{"n":"binop_"}],"o":{"n":"assocop"}}],[5,"contains_exterior_struct_lit","","Expressions that syntactically contain an \"exterior\" struct literal i.e. not surrounded by any parens or other delimiters, e.g. `X { y: 1 }`, `X { y: 1 }.method()`, `foo == X { y: 1 }` and `X { y: 1 } == foo` all do, but `(X { y: 1 }) == foo` does not.",null,{"i":[{"n":"expr"}],"o":{"n":"bool"}}],[17,"NO_ANN","","",null,null],[17,"indent_unit","","",null,null],[17,"default_columns","","",null,null],[8,"PpAnn","","",null,null],[11,"nested","","",194,{"i":[{"n":"self"},{"n":"state"},{"n":"nested"}],"o":{"n":"result"}}],[11,"pre","","",194,{"i":[{"n":"self"},{"n":"state"},{"n":"annnode"}],"o":{"n":"result"}}],[11,"post","","",194,{"i":[{"n":"self"},{"n":"state"},{"n":"annnode"}],"o":{"n":"result"}}],[11,"try_fetch_item","","",194,{"i":[{"n":"self"},{"n":"nodeid"}],"o":{"g":["item"],"n":"option"}}],[11,"try_fetch_item","rustc::hir","",47,{"i":[{"n":"self"},{"n":"nodeid"}],"o":{"g":["item"],"n":"option"}}],[11,"nested","","",47,{"i":[{"n":"self"},{"n":"state"},{"n":"nested"}],"o":{"n":"result"}}],[11,"writer","rustc::hir::print","",191,{"i":[{"n":"self"}],"o":{"n":"printer"}}],[11,"boxes","","",191,{"i":[{"n":"self"}],"o":{"n":"vec"}}],[11,"comments","","",191,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"cur_cmnt","","",191,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"cur_lit","","",191,{"i":[{"n":"self"}],"o":{"g":["literal"],"n":"option"}}],[11,"bump_lit","","",191,{"i":[{"n":"self"}],"o":{"g":["literal"],"n":"option"}}],[11,"new_from_input","","",191,{"i":[{"n":"codemap"},{"n":"parsesess"},{"n":"filename"},{"n":"read"},{"g":["write"],"n":"box"},{"n":"ppann"},{"n":"bool"}],"o":{"n":"state"}}],[11,"new","","",191,{"i":[{"n":"codemap"},{"g":["write"],"n":"box"},{"n":"ppann"},{"g":["vec"],"n":"option"},{"g":["vec"],"n":"option"}],"o":{"n":"state"}}],[11,"cbox","","",191,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"result"}}],[11,"nbsp","","",191,{"i":[{"n":"self"}],"o":{"n":"result"}}],[11,"word_nbsp","","",191,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"result"}}],[11,"head","","",191,{"i":[{"n":"self"},{"n":"str"}],"o":{"n":"result"}}],[11,"bopen","","",191,{"i":[{"n":"self"}],"o":{"n":"result"}}],[11,"bclose_","","",191,{"i":[{"n":"self"},{"n":"span"},{"n":"usize"}],"o":{"n":"result"}}],[11,"bclose_maybe_open","","",191,{"i":[{"n":"self"},{"n":"span"},{"n":"usize"},{"n":"bool"}],"o":{"n":"result"}}],[11,"bclose","","",191,{"i":[{"n":"self"},{"n":"span"}],"o":{"n":"result"}}],[11,"in_cbox","","",191,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"space_if_not_bol","","",191,{"i":[{"n":"self"}],"o":{"n":"result"}}],[11,"break_offset_if_not_bol","","",191,{"i":[{"n":"self"},{"n":"usize"},{"n":"isize"}],"o":{"n":"result"}}],[11,"synth_comment","","",191,{"i":[{"n":"self"},{"n":"string"}],"o":{"n":"result"}}],[11,"commasep_cmnt","","",191,null],[11,"commasep_exprs","","",191,null],[11,"print_mod","","",191,null],[11,"print_foreign_mod","","",191,null],[11,"print_opt_lifetime","","",191,{"i":[{"n":"self"},{"n":"lifetime"}],"o":{"n":"result"}}],[11,"print_type","","",191,{"i":[{"n":"self"},{"n":"ty"}],"o":{"n":"result"}}],[11,"print_foreign_item","","",191,{"i":[{"n":"self"},{"n":"foreignitem"}],"o":{"n":"result"}}],[11,"print_associated_const","","",191,{"i":[{"n":"self"},{"n":"name"},{"n":"ty"},{"g":["bodyid"],"n":"option"},{"n":"visibility"}],"o":{"n":"result"}}],[11,"print_associated_type","","",191,{"i":[{"n":"self"},{"n":"name"},{"g":["typarambounds"],"n":"option"},{"g":["ty"],"n":"option"}],"o":{"n":"result"}}],[11,"print_item","","Pretty-print an item",191,{"i":[{"n":"self"},{"n":"item"}],"o":{"n":"result"}}],[11,"print_trait_ref","","",191,{"i":[{"n":"self"},{"n":"traitref"}],"o":{"n":"result"}}],[11,"print_formal_generic_params","","",191,null],[11,"print_poly_trait_ref","","",191,{"i":[{"n":"self"},{"n":"polytraitref"}],"o":{"n":"result"}}],[11,"print_enum_def","","",191,{"i":[{"n":"self"},{"n":"enumdef"},{"n":"generics"},{"n":"name"},{"n":"span"},{"n":"visibility"}],"o":{"n":"result"}}],[11,"print_variants","","",191,null],[11,"print_visibility","","",191,{"i":[{"n":"self"},{"n":"visibility"}],"o":{"n":"result"}}],[11,"print_defaultness","","",191,{"i":[{"n":"self"},{"n":"defaultness"}],"o":{"n":"result"}}],[11,"print_struct","","",191,{"i":[{"n":"self"},{"n":"variantdata"},{"n":"generics"},{"n":"name"},{"n":"span"},{"n":"bool"}],"o":{"n":"result"}}],[11,"print_variant","","",191,{"i":[{"n":"self"},{"n":"variant"}],"o":{"n":"result"}}],[11,"print_method_sig","","",191,null],[11,"print_trait_item","","",191,{"i":[{"n":"self"},{"n":"traititem"}],"o":{"n":"result"}}],[11,"print_impl_item","","",191,{"i":[{"n":"self"},{"n":"implitem"}],"o":{"n":"result"}}],[11,"print_stmt","","",191,{"i":[{"n":"self"},{"n":"stmt"}],"o":{"n":"result"}}],[11,"print_block","","",191,{"i":[{"n":"self"},{"n":"block"}],"o":{"n":"result"}}],[11,"print_block_unclosed","","",191,{"i":[{"n":"self"},{"n":"block"}],"o":{"n":"result"}}],[11,"print_block_unclosed_indent","","",191,{"i":[{"n":"self"},{"n":"block"},{"n":"usize"}],"o":{"n":"result"}}],[11,"print_block_with_attrs","","",191,null],[11,"print_block_maybe_unclosed","","",191,null],[11,"print_else","","",191,{"i":[{"n":"self"},{"g":["expr"],"n":"option"}],"o":{"n":"result"}}],[11,"print_if","","",191,{"i":[{"n":"self"},{"n":"expr"},{"n":"expr"},{"g":["expr"],"n":"option"}],"o":{"n":"result"}}],[11,"print_if_let","","",191,{"i":[{"n":"self"},{"n":"pat"},{"n":"expr"},{"n":"block"},{"g":["expr"],"n":"option"}],"o":{"n":"result"}}],[11,"print_anon_const","","",191,{"i":[{"n":"self"},{"n":"anonconst"}],"o":{"n":"result"}}],[11,"print_call_post","","",191,null],[11,"print_expr_maybe_paren","","",191,{"i":[{"n":"self"},{"n":"expr"},{"n":"i8"}],"o":{"n":"result"}}],[11,"print_expr_as_cond","","Print an expr using syntax that's acceptable in a condition position, such as the `cond` in `if cond { ... }`.",191,{"i":[{"n":"self"},{"n":"expr"}],"o":{"n":"result"}}],[11,"print_expr_vec","","",191,null],[11,"print_expr_repeat","","",191,{"i":[{"n":"self"},{"n":"expr"},{"n":"anonconst"}],"o":{"n":"result"}}],[11,"print_expr_struct","","",191,null],[11,"print_expr_tup","","",191,null],[11,"print_expr_call","","",191,null],[11,"print_expr_method_call","","",191,null],[11,"print_expr_binary","","",191,{"i":[{"n":"self"},{"n":"binop"},{"n":"expr"},{"n":"expr"}],"o":{"n":"result"}}],[11,"print_expr_unary","","",191,{"i":[{"n":"self"},{"n":"unop"},{"n":"expr"}],"o":{"n":"result"}}],[11,"print_expr_addr_of","","",191,{"i":[{"n":"self"},{"n":"mutability"},{"n":"expr"}],"o":{"n":"result"}}],[11,"print_expr","","",191,{"i":[{"n":"self"},{"n":"expr"}],"o":{"n":"result"}}],[11,"print_local_decl","","",191,{"i":[{"n":"self"},{"n":"local"}],"o":{"n":"result"}}],[11,"print_decl","","",191,{"i":[{"n":"self"},{"n":"decl"}],"o":{"n":"result"}}],[11,"print_usize","","",191,{"i":[{"n":"self"},{"n":"usize"}],"o":{"n":"result"}}],[11,"print_ident","","",191,{"i":[{"n":"self"},{"n":"ident"}],"o":{"n":"result"}}],[11,"print_name","","",191,{"i":[{"n":"self"},{"n":"name"}],"o":{"n":"result"}}],[11,"print_for_decl","","",191,{"i":[{"n":"self"},{"n":"local"},{"n":"expr"}],"o":{"n":"result"}}],[11,"print_path","","",191,{"i":[{"n":"self"},{"n":"path"},{"n":"bool"}],"o":{"n":"result"}}],[11,"print_qpath","","",191,{"i":[{"n":"self"},{"n":"qpath"},{"n":"bool"}],"o":{"n":"result"}}],[11,"print_path_parameters","","",191,{"i":[{"n":"self"},{"n":"pathparameters"},{"n":"bool"},{"n":"bool"}],"o":{"n":"result"}}],[11,"print_pat","","",191,{"i":[{"n":"self"},{"n":"pat"}],"o":{"n":"result"}}],[11,"print_arm","","",191,{"i":[{"n":"self"},{"n":"arm"}],"o":{"n":"result"}}],[11,"print_fn","","",191,null],[11,"print_closure_args","","",191,{"i":[{"n":"self"},{"n":"fndecl"},{"n":"bodyid"}],"o":{"n":"result"}}],[11,"print_capture_clause","","",191,{"i":[{"n":"self"},{"n":"captureclause"}],"o":{"n":"result"}}],[11,"print_bounds","","",191,null],[11,"print_lifetime","","",191,{"i":[{"n":"self"},{"n":"lifetime"}],"o":{"n":"result"}}],[11,"print_lifetime_def","","",191,{"i":[{"n":"self"},{"n":"lifetimedef"}],"o":{"n":"result"}}],[11,"print_generic_params","","",191,null],[11,"print_ty_param","","",191,{"i":[{"n":"self"},{"n":"typaram"}],"o":{"n":"result"}}],[11,"print_where_clause","","",191,{"i":[{"n":"self"},{"n":"whereclause"}],"o":{"n":"result"}}],[11,"print_mutability","","",191,{"i":[{"n":"self"},{"n":"mutability"}],"o":{"n":"result"}}],[11,"print_mt","","",191,{"i":[{"n":"self"},{"n":"mutty"}],"o":{"n":"result"}}],[11,"print_fn_output","","",191,{"i":[{"n":"self"},{"n":"fndecl"}],"o":{"n":"result"}}],[11,"print_ty_fn","","",191,null],[11,"maybe_print_trailing_comment","","",191,{"i":[{"n":"self"},{"n":"span"},{"g":["bytepos"],"n":"option"}],"o":{"n":"result"}}],[11,"print_remaining_comments","","",191,{"i":[{"n":"self"}],"o":{"n":"result"}}],[11,"print_opt_abi_and_extern_if_nondefault","","",191,{"i":[{"n":"self"},{"g":["abi"],"n":"option"}],"o":{"n":"result"}}],[11,"print_extern_opt_abi","","",191,{"i":[{"n":"self"},{"g":["abi"],"n":"option"}],"o":{"n":"result"}}],[11,"print_fn_header_info","","",191,{"i":[{"n":"self"},{"n":"unsafety"},{"n":"constness"},{"n":"abi"},{"n":"visibility"}],"o":{"n":"result"}}],[11,"print_unsafety","","",191,{"i":[{"n":"self"},{"n":"unsafety"}],"o":{"n":"result"}}],[11,"print_is_auto","","",191,{"i":[{"n":"self"},{"n":"isauto"}],"o":{"n":"result"}}],[0,"svh","rustc::hir","Calculation and management of a Strict Version Hash for crates",null,null],[3,"Svh","rustc::hir::svh","",null,null],[12,"hash","","",195,null],[11,"clone","","",195,{"i":[{"n":"self"}],"o":{"n":"svh"}}],[11,"eq","","",195,{"i":[{"n":"self"},{"n":"svh"}],"o":{"n":"bool"}}],[11,"ne","","",195,{"i":[{"n":"self"},{"n":"svh"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",195,null],[11,"fmt","","",195,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"new","","Create a new `Svh` given the hash. If you actually want to compute the SVH from some HIR, you want the `calculate_svh` function found in `librustc_incremental`.",195,{"i":[{"n":"u64"}],"o":{"n":"svh"}}],[11,"as_u64","","",195,{"i":[{"n":"self"}],"o":{"n":"u64"}}],[11,"to_string","","",195,{"i":[{"n":"self"}],"o":{"n":"string"}}],[11,"hash","","",195,{"i":[{"n":"self"},{"n":"h"}]}],[11,"fmt","","",195,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"encode","","",195,{"i":[{"n":"self"},{"n":"s"}],"o":{"n":"result"}}],[11,"decode","","",195,{"i":[{"n":"d"}],"o":{"g":["svh"],"n":"result"}}],[11,"hash_stable","","",195,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[6,"HirVec","rustc::hir","HIR doesn't commit to a concrete storage type and has its own alias for a vector. It can be `Vec`, `P<[T]>` or potentially `Box<[T]>`, or some other container with similar behavior. Unlike AST, HIR is mostly a static structure, so we can use an owned slice instead of `Vec` to avoid keeping extra capacity.",null,null],[6,"TyParamBounds","","",null,null],[6,"CrateConfig","","",null,null],[6,"BinOp","","",null,null],[6,"Stmt","","A statement",null,null],[6,"Decl","","",null,null],[6,"Variant","","",null,null],[6,"FreevarMap","","",null,null],[6,"CaptureModeMap","","",null,null],[6,"TraitMap","","",null,null],[6,"GlobMap","","",null,null],[17,"CRATE_HIR_ID","","The `HirId` corresponding to CRATE_NODE_ID and CRATE_DEF_INDEX",null,null],[17,"DUMMY_HIR_ID","","",null,null],[17,"DUMMY_ITEM_LOCAL_ID","","",null,null],[8,"GenericParamsExt","","",null,null],[10,"lifetimes","","",196,{"i":[{"n":"self"}],"o":{"g":["iter"],"n":"filtermap"}}],[10,"ty_params","","",196,{"i":[{"n":"self"}],"o":{"g":["iter"],"n":"filtermap"}}],[11,"clone","","",33,{"i":[{"n":"self"}],"o":{"n":"hirid"}}],[11,"eq","","",33,{"i":[{"n":"self"},{"n":"hirid"}],"o":{"n":"bool"}}],[11,"ne","","",33,{"i":[{"n":"self"},{"n":"hirid"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",33,null],[11,"hash","","",33,null],[11,"partial_cmp","","",33,{"i":[{"n":"self"},{"n":"hirid"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",33,{"i":[{"n":"self"},{"n":"hirid"}],"o":{"n":"bool"}}],[11,"le","","",33,{"i":[{"n":"self"},{"n":"hirid"}],"o":{"n":"bool"}}],[11,"gt","","",33,{"i":[{"n":"self"},{"n":"hirid"}],"o":{"n":"bool"}}],[11,"ge","","",33,{"i":[{"n":"self"},{"n":"hirid"}],"o":{"n":"bool"}}],[11,"cmp","","",33,{"i":[{"n":"self"},{"n":"hirid"}],"o":{"n":"ordering"}}],[11,"fmt","","",33,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"owner_def_id","","",33,{"i":[{"n":"self"}],"o":{"n":"defid"}}],[11,"owner_local_def_id","","",33,{"i":[{"n":"self"}],"o":{"n":"localdefid"}}],[11,"default_encode","","",33,{"i":[{"n":"self"},{"n":"s"}],"o":{"n":"result"}}],[11,"default_decode","","",33,{"i":[{"n":"d"}],"o":{"g":["hirid"],"n":"result"}}],[11,"clone","","",34,{"i":[{"n":"self"}],"o":{"n":"itemlocalid"}}],[11,"eq","","",34,{"i":[{"n":"self"},{"n":"itemlocalid"}],"o":{"n":"bool"}}],[11,"ne","","",34,{"i":[{"n":"self"},{"n":"itemlocalid"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",34,null],[11,"hash","","",34,null],[11,"partial_cmp","","",34,{"i":[{"n":"self"},{"n":"itemlocalid"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",34,{"i":[{"n":"self"},{"n":"itemlocalid"}],"o":{"n":"bool"}}],[11,"le","","",34,{"i":[{"n":"self"},{"n":"itemlocalid"}],"o":{"n":"bool"}}],[11,"gt","","",34,{"i":[{"n":"self"},{"n":"itemlocalid"}],"o":{"n":"bool"}}],[11,"ge","","",34,{"i":[{"n":"self"},{"n":"itemlocalid"}],"o":{"n":"bool"}}],[11,"cmp","","",34,{"i":[{"n":"self"},{"n":"itemlocalid"}],"o":{"n":"ordering"}}],[11,"fmt","","",34,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"encode","","",34,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",34,{"i":[{"n":"__d"}],"o":{"g":["itemlocalid"],"n":"result"}}],[11,"as_usize","","",34,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"new","","",34,{"i":[{"n":"usize"}],"o":{"n":"self"}}],[11,"index","","",34,{"i":[{"n":"self"}],"o":{"n":"usize"}}],[11,"clone","","",35,{"i":[{"n":"self"}],"o":{"n":"label"}}],[11,"eq","","",35,{"i":[{"n":"self"},{"n":"label"}],"o":{"n":"bool"}}],[11,"ne","","",35,{"i":[{"n":"self"},{"n":"label"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",35,null],[11,"encode","","",35,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",35,{"i":[{"n":"__d"}],"o":{"g":["label"],"n":"result"}}],[11,"hash","","",35,null],[11,"fmt","","",35,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",36,{"i":[{"n":"self"}],"o":{"n":"lifetime"}}],[11,"eq","","",36,{"i":[{"n":"self"},{"n":"lifetime"}],"o":{"n":"bool"}}],[11,"ne","","",36,{"i":[{"n":"self"},{"n":"lifetime"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",36,null],[11,"encode","","",36,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",36,{"i":[{"n":"__d"}],"o":{"g":["lifetime"],"n":"result"}}],[11,"hash","","",36,null],[11,"fmt","","",91,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",91,{"i":[{"n":"self"}],"o":{"n":"lifetimename"}}],[11,"eq","","",91,{"i":[{"n":"self"},{"n":"lifetimename"}],"o":{"n":"bool"}}],[11,"ne","","",91,{"i":[{"n":"self"},{"n":"lifetimename"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",91,null],[11,"encode","","",91,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",91,{"i":[{"n":"__d"}],"o":{"g":["lifetimename"],"n":"result"}}],[11,"hash","","",91,null],[11,"name","","",91,{"i":[{"n":"self"}],"o":{"n":"name"}}],[11,"fmt","","",36,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"is_elided","","",36,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"is_static","","",36,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"clone","","",37,{"i":[{"n":"self"}],"o":{"n":"lifetimedef"}}],[11,"eq","","",37,{"i":[{"n":"self"},{"n":"lifetimedef"}],"o":{"n":"bool"}}],[11,"ne","","",37,{"i":[{"n":"self"},{"n":"lifetimedef"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",37,null],[11,"encode","","",37,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",37,{"i":[{"n":"__d"}],"o":{"g":["lifetimedef"],"n":"result"}}],[11,"hash","","",37,null],[11,"fmt","","",37,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",38,{"i":[{"n":"self"}],"o":{"n":"path"}}],[11,"eq","","",38,{"i":[{"n":"self"},{"n":"path"}],"o":{"n":"bool"}}],[11,"ne","","",38,{"i":[{"n":"self"},{"n":"path"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",38,null],[11,"encode","","",38,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",38,{"i":[{"n":"__d"}],"o":{"g":["path"],"n":"result"}}],[11,"hash","","",38,null],[11,"is_global","","",38,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"fmt","","",38,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",38,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",39,{"i":[{"n":"self"}],"o":{"n":"pathsegment"}}],[11,"eq","","",39,{"i":[{"n":"self"},{"n":"pathsegment"}],"o":{"n":"bool"}}],[11,"ne","","",39,{"i":[{"n":"self"},{"n":"pathsegment"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",39,null],[11,"encode","","",39,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",39,{"i":[{"n":"__d"}],"o":{"g":["pathsegment"],"n":"result"}}],[11,"hash","","",39,null],[11,"fmt","","",39,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"from_name","","Convert an identifier to the corresponding segment.",39,{"i":[{"n":"name"}],"o":{"n":"pathsegment"}}],[11,"new","","",39,{"i":[{"n":"name"},{"n":"pathparameters"},{"n":"bool"}],"o":{"n":"self"}}],[11,"with_parameters","","",39,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"r"}}],[11,"clone","","",40,{"i":[{"n":"self"}],"o":{"n":"pathparameters"}}],[11,"eq","","",40,{"i":[{"n":"self"},{"n":"pathparameters"}],"o":{"n":"bool"}}],[11,"ne","","",40,{"i":[{"n":"self"},{"n":"pathparameters"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",40,null],[11,"encode","","",40,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",40,{"i":[{"n":"__d"}],"o":{"g":["pathparameters"],"n":"result"}}],[11,"hash","","",40,null],[11,"fmt","","",40,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"none","","",40,{"o":{"n":"self"}}],[11,"is_empty","","",40,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"inputs","","",40,null],[11,"clone","","",92,{"i":[{"n":"self"}],"o":{"n":"typarambound"}}],[11,"eq","","",92,{"i":[{"n":"self"},{"n":"typarambound"}],"o":{"n":"bool"}}],[11,"ne","","",92,{"i":[{"n":"self"},{"n":"typarambound"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",92,null],[11,"encode","","",92,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",92,{"i":[{"n":"__d"}],"o":{"g":["typarambound"],"n":"result"}}],[11,"hash","","",92,null],[11,"fmt","","",92,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"span","","",92,{"i":[{"n":"self"}],"o":{"n":"span"}}],[11,"clone","","",93,{"i":[{"n":"self"}],"o":{"n":"traitboundmodifier"}}],[11,"eq","","",93,{"i":[{"n":"self"},{"n":"traitboundmodifier"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",93,null],[11,"encode","","",93,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",93,{"i":[{"n":"__d"}],"o":{"g":["traitboundmodifier"],"n":"result"}}],[11,"hash","","",93,null],[11,"fmt","","",93,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",41,{"i":[{"n":"self"}],"o":{"n":"typaram"}}],[11,"eq","","",41,{"i":[{"n":"self"},{"n":"typaram"}],"o":{"n":"bool"}}],[11,"ne","","",41,{"i":[{"n":"self"},{"n":"typaram"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",41,null],[11,"encode","","",41,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",41,{"i":[{"n":"__d"}],"o":{"g":["typaram"],"n":"result"}}],[11,"hash","","",41,null],[11,"fmt","","",41,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",94,{"i":[{"n":"self"}],"o":{"n":"genericparam"}}],[11,"eq","","",94,{"i":[{"n":"self"},{"n":"genericparam"}],"o":{"n":"bool"}}],[11,"ne","","",94,{"i":[{"n":"self"},{"n":"genericparam"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",94,null],[11,"encode","","",94,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",94,{"i":[{"n":"__d"}],"o":{"g":["genericparam"],"n":"result"}}],[11,"hash","","",94,null],[11,"fmt","","",94,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"is_lifetime_param","","",94,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"is_type_param","","",94,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"clone","","",42,{"i":[{"n":"self"}],"o":{"n":"generics"}}],[11,"eq","","",42,{"i":[{"n":"self"},{"n":"generics"}],"o":{"n":"bool"}}],[11,"ne","","",42,{"i":[{"n":"self"},{"n":"generics"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",42,null],[11,"encode","","",42,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",42,{"i":[{"n":"__d"}],"o":{"g":["generics"],"n":"result"}}],[11,"hash","","",42,null],[11,"fmt","","",42,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"empty","","",42,{"o":{"n":"generics"}}],[11,"is_lt_parameterized","","",42,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"is_type_parameterized","","",42,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"lifetimes","","",42,null],[11,"ty_params","","",42,null],[11,"attr_name","","",95,{"i":[{"n":"self"}],"o":{"n":"str"}}],[11,"carries_unsafe_attr","","",42,{"i":[{"n":"self"}],"o":{"g":["unsafegeneric"],"n":"option"}}],[11,"clone","","",96,{"i":[{"n":"self"}],"o":{"n":"synthetictyparamkind"}}],[11,"eq","","",96,{"i":[{"n":"self"},{"n":"synthetictyparamkind"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",96,null],[11,"encode","","",96,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",96,{"i":[{"n":"__d"}],"o":{"g":["synthetictyparamkind"],"n":"result"}}],[11,"hash","","",96,null],[11,"fmt","","",96,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",43,{"i":[{"n":"self"}],"o":{"n":"whereclause"}}],[11,"eq","","",43,{"i":[{"n":"self"},{"n":"whereclause"}],"o":{"n":"bool"}}],[11,"ne","","",43,{"i":[{"n":"self"},{"n":"whereclause"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",43,null],[11,"encode","","",43,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",43,{"i":[{"n":"__d"}],"o":{"g":["whereclause"],"n":"result"}}],[11,"hash","","",43,null],[11,"fmt","","",43,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"span","","",43,{"i":[{"n":"self"}],"o":{"g":["span"],"n":"option"}}],[11,"clone","","",97,{"i":[{"n":"self"}],"o":{"n":"wherepredicate"}}],[11,"eq","","",97,{"i":[{"n":"self"},{"n":"wherepredicate"}],"o":{"n":"bool"}}],[11,"ne","","",97,{"i":[{"n":"self"},{"n":"wherepredicate"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",97,null],[11,"encode","","",97,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",97,{"i":[{"n":"__d"}],"o":{"g":["wherepredicate"],"n":"result"}}],[11,"hash","","",97,null],[11,"fmt","","",97,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"span","","",97,{"i":[{"n":"self"}],"o":{"n":"span"}}],[11,"clone","","",44,{"i":[{"n":"self"}],"o":{"n":"whereboundpredicate"}}],[11,"eq","","",44,{"i":[{"n":"self"},{"n":"whereboundpredicate"}],"o":{"n":"bool"}}],[11,"ne","","",44,{"i":[{"n":"self"},{"n":"whereboundpredicate"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",44,null],[11,"encode","","",44,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",44,{"i":[{"n":"__d"}],"o":{"g":["whereboundpredicate"],"n":"result"}}],[11,"hash","","",44,null],[11,"fmt","","",44,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",45,{"i":[{"n":"self"}],"o":{"n":"whereregionpredicate"}}],[11,"eq","","",45,{"i":[{"n":"self"},{"n":"whereregionpredicate"}],"o":{"n":"bool"}}],[11,"ne","","",45,{"i":[{"n":"self"},{"n":"whereregionpredicate"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",45,null],[11,"encode","","",45,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",45,{"i":[{"n":"__d"}],"o":{"g":["whereregionpredicate"],"n":"result"}}],[11,"hash","","",45,null],[11,"fmt","","",45,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",46,{"i":[{"n":"self"}],"o":{"n":"whereeqpredicate"}}],[11,"eq","","",46,{"i":[{"n":"self"},{"n":"whereeqpredicate"}],"o":{"n":"bool"}}],[11,"ne","","",46,{"i":[{"n":"self"},{"n":"whereeqpredicate"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",46,null],[11,"encode","","",46,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",46,{"i":[{"n":"__d"}],"o":{"g":["whereeqpredicate"],"n":"result"}}],[11,"hash","","",46,null],[11,"fmt","","",46,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",47,{"i":[{"n":"self"}],"o":{"n":"crate"}}],[11,"eq","","",47,{"i":[{"n":"self"},{"n":"crate"}],"o":{"n":"bool"}}],[11,"ne","","",47,{"i":[{"n":"self"},{"n":"crate"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",47,null],[11,"encode","","",47,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",47,{"i":[{"n":"__d"}],"o":{"g":["crate"],"n":"result"}}],[11,"fmt","","",47,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"item","","",47,{"i":[{"n":"self"},{"n":"nodeid"}],"o":{"n":"item"}}],[11,"trait_item","","",47,{"i":[{"n":"self"},{"n":"traititemid"}],"o":{"n":"traititem"}}],[11,"impl_item","","",47,{"i":[{"n":"self"},{"n":"implitemid"}],"o":{"n":"implitem"}}],[11,"visit_all_item_likes","","Visits all items in the crate in some deterministic (but unspecified) order. If you just need to process every item, but don't care about nesting, this method is the best choice.",47,{"i":[{"n":"self"},{"n":"v"}]}],[11,"par_visit_all_item_likes","","A parallel version of visit_all_item_likes",47,{"i":[{"n":"self"},{"n":"v"}]}],[11,"body","","",47,{"i":[{"n":"self"},{"n":"bodyid"}],"o":{"n":"body"}}],[11,"clone","","",48,{"i":[{"n":"self"}],"o":{"n":"macrodef"}}],[11,"eq","","",48,{"i":[{"n":"self"},{"n":"macrodef"}],"o":{"n":"bool"}}],[11,"ne","","",48,{"i":[{"n":"self"},{"n":"macrodef"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",48,null],[11,"encode","","",48,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",48,{"i":[{"n":"__d"}],"o":{"g":["macrodef"],"n":"result"}}],[11,"hash","","",48,null],[11,"fmt","","",48,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",49,{"i":[{"n":"self"}],"o":{"n":"block"}}],[11,"eq","","",49,{"i":[{"n":"self"},{"n":"block"}],"o":{"n":"bool"}}],[11,"ne","","",49,{"i":[{"n":"self"},{"n":"block"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",49,null],[11,"encode","","",49,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",49,{"i":[{"n":"__d"}],"o":{"g":["block"],"n":"result"}}],[11,"hash","","",49,null],[11,"fmt","","",49,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",50,{"i":[{"n":"self"}],"o":{"n":"pat"}}],[11,"eq","","",50,{"i":[{"n":"self"},{"n":"pat"}],"o":{"n":"bool"}}],[11,"ne","","",50,{"i":[{"n":"self"},{"n":"pat"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",50,null],[11,"encode","","",50,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",50,{"i":[{"n":"__d"}],"o":{"g":["pat"],"n":"result"}}],[11,"hash","","",50,null],[11,"fmt","","",50,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"walk_","","",50,{"i":[{"n":"self"},{"n":"g"}],"o":{"n":"bool"}}],[11,"walk","","",50,{"i":[{"n":"self"},{"n":"f"}],"o":{"n":"bool"}}],[11,"clone","","",51,{"i":[{"n":"self"}],"o":{"n":"fieldpat"}}],[11,"eq","","",51,{"i":[{"n":"self"},{"n":"fieldpat"}],"o":{"n":"bool"}}],[11,"ne","","",51,{"i":[{"n":"self"},{"n":"fieldpat"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",51,null],[11,"encode","","",51,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",51,{"i":[{"n":"__d"}],"o":{"g":["fieldpat"],"n":"result"}}],[11,"hash","","",51,null],[11,"fmt","","",51,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",98,{"i":[{"n":"self"}],"o":{"n":"bindingannotation"}}],[11,"eq","","",98,{"i":[{"n":"self"},{"n":"bindingannotation"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",98,null],[11,"encode","","",98,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",98,{"i":[{"n":"__d"}],"o":{"g":["bindingannotation"],"n":"result"}}],[11,"hash","","",98,null],[11,"fmt","","",98,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",99,{"i":[{"n":"self"}],"o":{"n":"rangeend"}}],[11,"eq","","",99,{"i":[{"n":"self"},{"n":"rangeend"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",99,null],[11,"encode","","",99,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",99,{"i":[{"n":"__d"}],"o":{"g":["rangeend"],"n":"result"}}],[11,"hash","","",99,null],[11,"fmt","","",99,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",100,{"i":[{"n":"self"}],"o":{"n":"patkind"}}],[11,"eq","","",100,{"i":[{"n":"self"},{"n":"patkind"}],"o":{"n":"bool"}}],[11,"ne","","",100,{"i":[{"n":"self"},{"n":"patkind"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",100,null],[11,"encode","","",100,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",100,{"i":[{"n":"__d"}],"o":{"g":["patkind"],"n":"result"}}],[11,"hash","","",100,null],[11,"fmt","","",100,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",101,{"i":[{"n":"self"}],"o":{"n":"mutability"}}],[11,"eq","","",101,{"i":[{"n":"self"},{"n":"mutability"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",101,null],[11,"partial_cmp","","",101,{"i":[{"n":"self"},{"n":"mutability"}],"o":{"g":["ordering"],"n":"option"}}],[11,"cmp","","",101,{"i":[{"n":"self"},{"n":"mutability"}],"o":{"n":"ordering"}}],[11,"encode","","",101,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",101,{"i":[{"n":"__d"}],"o":{"g":["mutability"],"n":"result"}}],[11,"hash","","",101,null],[11,"fmt","","",101,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"and","","Return MutMutable only if both arguments are mutable.",101,{"i":[{"n":"self"},{"n":"self"}],"o":{"n":"self"}}],[11,"clone","","",102,{"i":[{"n":"self"}],"o":{"n":"binop_"}}],[11,"eq","","",102,{"i":[{"n":"self"},{"n":"binop_"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",102,null],[11,"encode","","",102,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",102,{"i":[{"n":"__d"}],"o":{"g":["binop_"],"n":"result"}}],[11,"hash","","",102,null],[11,"fmt","","",102,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"as_str","","",102,{"i":[{"n":"self"}],"o":{"n":"str"}}],[11,"is_lazy","","",102,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"is_shift","","",102,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"is_comparison","","",102,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"is_by_value","","Returns `true` if the binary operator takes its arguments by value",102,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"into","","",102,{"i":[{"n":"self"}],"o":{"n":"binopkind"}}],[11,"clone","","",103,{"i":[{"n":"self"}],"o":{"n":"unop"}}],[11,"eq","","",103,{"i":[{"n":"self"},{"n":"unop"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",103,null],[11,"encode","","",103,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",103,{"i":[{"n":"__d"}],"o":{"g":["unop"],"n":"result"}}],[11,"hash","","",103,null],[11,"fmt","","",103,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"as_str","","",103,{"i":[{"n":"self"}],"o":{"n":"str"}}],[11,"is_by_value","","Returns `true` if the unary operator takes its argument by value",103,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"fmt","","",104,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",104,{"i":[{"n":"self"}],"o":{"n":"stmt_"}}],[11,"eq","","",104,{"i":[{"n":"self"},{"n":"stmt_"}],"o":{"n":"bool"}}],[11,"ne","","",104,{"i":[{"n":"self"},{"n":"stmt_"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",104,null],[11,"encode","","",104,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",104,{"i":[{"n":"__d"}],"o":{"g":["stmt_"],"n":"result"}}],[11,"hash","","",104,null],[11,"attrs","","",104,null],[11,"id","","",104,{"i":[{"n":"self"}],"o":{"n":"nodeid"}}],[11,"clone","","",52,{"i":[{"n":"self"}],"o":{"n":"local"}}],[11,"eq","","",52,{"i":[{"n":"self"},{"n":"local"}],"o":{"n":"bool"}}],[11,"ne","","",52,{"i":[{"n":"self"},{"n":"local"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",52,null],[11,"encode","","",52,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",52,{"i":[{"n":"__d"}],"o":{"g":["local"],"n":"result"}}],[11,"hash","","",52,null],[11,"fmt","","",52,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",105,{"i":[{"n":"self"}],"o":{"n":"decl_"}}],[11,"eq","","",105,{"i":[{"n":"self"},{"n":"decl_"}],"o":{"n":"bool"}}],[11,"ne","","",105,{"i":[{"n":"self"},{"n":"decl_"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",105,null],[11,"encode","","",105,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",105,{"i":[{"n":"__d"}],"o":{"g":["decl_"],"n":"result"}}],[11,"hash","","",105,null],[11,"fmt","","",105,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"attrs","","",105,null],[11,"is_local","","",105,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"clone","","",53,{"i":[{"n":"self"}],"o":{"n":"arm"}}],[11,"eq","","",53,{"i":[{"n":"self"},{"n":"arm"}],"o":{"n":"bool"}}],[11,"ne","","",53,{"i":[{"n":"self"},{"n":"arm"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",53,null],[11,"encode","","",53,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",53,{"i":[{"n":"__d"}],"o":{"g":["arm"],"n":"result"}}],[11,"hash","","",53,null],[11,"fmt","","",53,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",54,{"i":[{"n":"self"}],"o":{"n":"field"}}],[11,"eq","","",54,{"i":[{"n":"self"},{"n":"field"}],"o":{"n":"bool"}}],[11,"ne","","",54,{"i":[{"n":"self"},{"n":"field"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",54,null],[11,"encode","","",54,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",54,{"i":[{"n":"__d"}],"o":{"g":["field"],"n":"result"}}],[11,"hash","","",54,null],[11,"fmt","","",54,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",106,{"i":[{"n":"self"}],"o":{"n":"blockcheckmode"}}],[11,"eq","","",106,{"i":[{"n":"self"},{"n":"blockcheckmode"}],"o":{"n":"bool"}}],[11,"ne","","",106,{"i":[{"n":"self"},{"n":"blockcheckmode"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",106,null],[11,"encode","","",106,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",106,{"i":[{"n":"__d"}],"o":{"g":["blockcheckmode"],"n":"result"}}],[11,"hash","","",106,null],[11,"fmt","","",106,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",107,{"i":[{"n":"self"}],"o":{"n":"unsafesource"}}],[11,"eq","","",107,{"i":[{"n":"self"},{"n":"unsafesource"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",107,null],[11,"encode","","",107,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",107,{"i":[{"n":"__d"}],"o":{"g":["unsafesource"],"n":"result"}}],[11,"hash","","",107,null],[11,"fmt","","",107,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",55,{"i":[{"n":"self"}],"o":{"n":"bodyid"}}],[11,"eq","","",55,{"i":[{"n":"self"},{"n":"bodyid"}],"o":{"n":"bool"}}],[11,"ne","","",55,{"i":[{"n":"self"},{"n":"bodyid"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",55,null],[11,"partial_cmp","","",55,{"i":[{"n":"self"},{"n":"bodyid"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",55,{"i":[{"n":"self"},{"n":"bodyid"}],"o":{"n":"bool"}}],[11,"le","","",55,{"i":[{"n":"self"},{"n":"bodyid"}],"o":{"n":"bool"}}],[11,"gt","","",55,{"i":[{"n":"self"},{"n":"bodyid"}],"o":{"n":"bool"}}],[11,"ge","","",55,{"i":[{"n":"self"},{"n":"bodyid"}],"o":{"n":"bool"}}],[11,"cmp","","",55,{"i":[{"n":"self"},{"n":"bodyid"}],"o":{"n":"ordering"}}],[11,"encode","","",55,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",55,{"i":[{"n":"__d"}],"o":{"g":["bodyid"],"n":"result"}}],[11,"hash","","",55,null],[11,"fmt","","",55,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",56,{"i":[{"n":"self"}],"o":{"n":"body"}}],[11,"eq","","",56,{"i":[{"n":"self"},{"n":"body"}],"o":{"n":"bool"}}],[11,"ne","","",56,{"i":[{"n":"self"},{"n":"body"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",56,null],[11,"encode","","",56,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",56,{"i":[{"n":"__d"}],"o":{"g":["body"],"n":"result"}}],[11,"hash","","",56,null],[11,"fmt","","",56,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"id","","",56,{"i":[{"n":"self"}],"o":{"n":"bodyid"}}],[11,"clone","","",108,{"i":[{"n":"self"}],"o":{"n":"bodyownerkind"}}],[11,"fmt","","",108,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",57,{"i":[{"n":"self"}],"o":{"n":"anonconst"}}],[11,"eq","","",57,{"i":[{"n":"self"},{"n":"anonconst"}],"o":{"n":"bool"}}],[11,"ne","","",57,{"i":[{"n":"self"},{"n":"anonconst"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",57,null],[11,"encode","","",57,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",57,{"i":[{"n":"__d"}],"o":{"g":["anonconst"],"n":"result"}}],[11,"hash","","",57,null],[11,"fmt","","",57,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",58,{"i":[{"n":"self"}],"o":{"n":"expr"}}],[11,"eq","","",58,{"i":[{"n":"self"},{"n":"expr"}],"o":{"n":"bool"}}],[11,"ne","","",58,{"i":[{"n":"self"},{"n":"expr"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",58,null],[11,"encode","","",58,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",58,{"i":[{"n":"__d"}],"o":{"g":["expr"],"n":"result"}}],[11,"hash","","",58,null],[11,"precedence","","",58,{"i":[{"n":"self"}],"o":{"n":"exprprecedence"}}],[11,"fmt","","",58,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",109,{"i":[{"n":"self"}],"o":{"n":"expr_"}}],[11,"eq","","",109,{"i":[{"n":"self"},{"n":"expr_"}],"o":{"n":"bool"}}],[11,"ne","","",109,{"i":[{"n":"self"},{"n":"expr_"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",109,null],[11,"encode","","",109,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",109,{"i":[{"n":"__d"}],"o":{"g":["expr_"],"n":"result"}}],[11,"hash","","",109,null],[11,"fmt","","",109,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",110,{"i":[{"n":"self"}],"o":{"n":"qpath"}}],[11,"eq","","",110,{"i":[{"n":"self"},{"n":"qpath"}],"o":{"n":"bool"}}],[11,"ne","","",110,{"i":[{"n":"self"},{"n":"qpath"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",110,null],[11,"encode","","",110,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",110,{"i":[{"n":"__d"}],"o":{"g":["qpath"],"n":"result"}}],[11,"hash","","",110,null],[11,"fmt","","",110,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",111,{"i":[{"n":"self"}],"o":{"n":"localsource"}}],[11,"eq","","",111,{"i":[{"n":"self"},{"n":"localsource"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",111,null],[11,"encode","","",111,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",111,{"i":[{"n":"__d"}],"o":{"g":["localsource"],"n":"result"}}],[11,"hash","","",111,null],[11,"fmt","","",111,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",112,{"i":[{"n":"self"}],"o":{"n":"matchsource"}}],[11,"eq","","",112,{"i":[{"n":"self"},{"n":"matchsource"}],"o":{"n":"bool"}}],[11,"ne","","",112,{"i":[{"n":"self"},{"n":"matchsource"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",112,null],[11,"encode","","",112,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",112,{"i":[{"n":"__d"}],"o":{"g":["matchsource"],"n":"result"}}],[11,"hash","","",112,null],[11,"fmt","","",112,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",113,{"i":[{"n":"self"}],"o":{"n":"loopsource"}}],[11,"eq","","",113,{"i":[{"n":"self"},{"n":"loopsource"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",113,null],[11,"encode","","",113,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",113,{"i":[{"n":"__d"}],"o":{"g":["loopsource"],"n":"result"}}],[11,"hash","","",113,null],[11,"fmt","","",113,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",114,{"i":[{"n":"self"}],"o":{"n":"loopiderror"}}],[11,"eq","","",114,{"i":[{"n":"self"},{"n":"loopiderror"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",114,null],[11,"encode","","",114,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",114,{"i":[{"n":"__d"}],"o":{"g":["loopiderror"],"n":"result"}}],[11,"hash","","",114,null],[11,"fmt","","",114,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",114,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",59,{"i":[{"n":"self"}],"o":{"n":"destination"}}],[11,"eq","","",59,{"i":[{"n":"self"},{"n":"destination"}],"o":{"n":"bool"}}],[11,"ne","","",59,{"i":[{"n":"self"},{"n":"destination"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",59,null],[11,"encode","","",59,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",59,{"i":[{"n":"__d"}],"o":{"g":["destination"],"n":"result"}}],[11,"hash","","",59,null],[11,"fmt","","",59,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",115,{"i":[{"n":"self"}],"o":{"n":"generatormovability"}}],[11,"eq","","",115,{"i":[{"n":"self"},{"n":"generatormovability"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",115,null],[11,"partial_cmp","","",115,{"i":[{"n":"self"},{"n":"generatormovability"}],"o":{"g":["ordering"],"n":"option"}}],[11,"cmp","","",115,{"i":[{"n":"self"},{"n":"generatormovability"}],"o":{"n":"ordering"}}],[11,"encode","","",115,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",115,{"i":[{"n":"__d"}],"o":{"g":["generatormovability"],"n":"result"}}],[11,"hash","","",115,null],[11,"fmt","","",115,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",116,{"i":[{"n":"self"}],"o":{"n":"captureclause"}}],[11,"eq","","",116,{"i":[{"n":"self"},{"n":"captureclause"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",116,null],[11,"encode","","",116,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",116,{"i":[{"n":"__d"}],"o":{"g":["captureclause"],"n":"result"}}],[11,"hash","","",116,null],[11,"fmt","","",116,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",60,{"i":[{"n":"self"}],"o":{"n":"mutty"}}],[11,"eq","","",60,{"i":[{"n":"self"},{"n":"mutty"}],"o":{"n":"bool"}}],[11,"ne","","",60,{"i":[{"n":"self"},{"n":"mutty"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",60,null],[11,"encode","","",60,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",60,{"i":[{"n":"__d"}],"o":{"g":["mutty"],"n":"result"}}],[11,"hash","","",60,null],[11,"fmt","","",60,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",61,{"i":[{"n":"self"}],"o":{"n":"methodsig"}}],[11,"eq","","",61,{"i":[{"n":"self"},{"n":"methodsig"}],"o":{"n":"bool"}}],[11,"ne","","",61,{"i":[{"n":"self"},{"n":"methodsig"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",61,null],[11,"encode","","",61,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",61,{"i":[{"n":"__d"}],"o":{"g":["methodsig"],"n":"result"}}],[11,"hash","","",61,null],[11,"fmt","","",61,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",62,{"i":[{"n":"self"}],"o":{"n":"traititemid"}}],[11,"eq","","",62,{"i":[{"n":"self"},{"n":"traititemid"}],"o":{"n":"bool"}}],[11,"ne","","",62,{"i":[{"n":"self"},{"n":"traititemid"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",62,null],[11,"partial_cmp","","",62,{"i":[{"n":"self"},{"n":"traititemid"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",62,{"i":[{"n":"self"},{"n":"traititemid"}],"o":{"n":"bool"}}],[11,"le","","",62,{"i":[{"n":"self"},{"n":"traititemid"}],"o":{"n":"bool"}}],[11,"gt","","",62,{"i":[{"n":"self"},{"n":"traititemid"}],"o":{"n":"bool"}}],[11,"ge","","",62,{"i":[{"n":"self"},{"n":"traititemid"}],"o":{"n":"bool"}}],[11,"cmp","","",62,{"i":[{"n":"self"},{"n":"traititemid"}],"o":{"n":"ordering"}}],[11,"encode","","",62,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",62,{"i":[{"n":"__d"}],"o":{"g":["traititemid"],"n":"result"}}],[11,"hash","","",62,null],[11,"fmt","","",62,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",63,{"i":[{"n":"self"}],"o":{"n":"traititem"}}],[11,"eq","","",63,{"i":[{"n":"self"},{"n":"traititem"}],"o":{"n":"bool"}}],[11,"ne","","",63,{"i":[{"n":"self"},{"n":"traititem"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",63,null],[11,"encode","","",63,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",63,{"i":[{"n":"__d"}],"o":{"g":["traititem"],"n":"result"}}],[11,"hash","","",63,null],[11,"fmt","","",63,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",117,{"i":[{"n":"self"}],"o":{"n":"traitmethod"}}],[11,"eq","","",117,{"i":[{"n":"self"},{"n":"traitmethod"}],"o":{"n":"bool"}}],[11,"ne","","",117,{"i":[{"n":"self"},{"n":"traitmethod"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",117,null],[11,"encode","","",117,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",117,{"i":[{"n":"__d"}],"o":{"g":["traitmethod"],"n":"result"}}],[11,"hash","","",117,null],[11,"fmt","","",117,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",118,{"i":[{"n":"self"}],"o":{"n":"traititemkind"}}],[11,"eq","","",118,{"i":[{"n":"self"},{"n":"traititemkind"}],"o":{"n":"bool"}}],[11,"ne","","",118,{"i":[{"n":"self"},{"n":"traititemkind"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",118,null],[11,"encode","","",118,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",118,{"i":[{"n":"__d"}],"o":{"g":["traititemkind"],"n":"result"}}],[11,"hash","","",118,null],[11,"fmt","","",118,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",64,{"i":[{"n":"self"}],"o":{"n":"implitemid"}}],[11,"eq","","",64,{"i":[{"n":"self"},{"n":"implitemid"}],"o":{"n":"bool"}}],[11,"ne","","",64,{"i":[{"n":"self"},{"n":"implitemid"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",64,null],[11,"partial_cmp","","",64,{"i":[{"n":"self"},{"n":"implitemid"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",64,{"i":[{"n":"self"},{"n":"implitemid"}],"o":{"n":"bool"}}],[11,"le","","",64,{"i":[{"n":"self"},{"n":"implitemid"}],"o":{"n":"bool"}}],[11,"gt","","",64,{"i":[{"n":"self"},{"n":"implitemid"}],"o":{"n":"bool"}}],[11,"ge","","",64,{"i":[{"n":"self"},{"n":"implitemid"}],"o":{"n":"bool"}}],[11,"cmp","","",64,{"i":[{"n":"self"},{"n":"implitemid"}],"o":{"n":"ordering"}}],[11,"encode","","",64,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",64,{"i":[{"n":"__d"}],"o":{"g":["implitemid"],"n":"result"}}],[11,"hash","","",64,null],[11,"fmt","","",64,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",65,{"i":[{"n":"self"}],"o":{"n":"implitem"}}],[11,"eq","","",65,{"i":[{"n":"self"},{"n":"implitem"}],"o":{"n":"bool"}}],[11,"ne","","",65,{"i":[{"n":"self"},{"n":"implitem"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",65,null],[11,"encode","","",65,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",65,{"i":[{"n":"__d"}],"o":{"g":["implitem"],"n":"result"}}],[11,"hash","","",65,null],[11,"fmt","","",65,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",119,{"i":[{"n":"self"}],"o":{"n":"implitemkind"}}],[11,"eq","","",119,{"i":[{"n":"self"},{"n":"implitemkind"}],"o":{"n":"bool"}}],[11,"ne","","",119,{"i":[{"n":"self"},{"n":"implitemkind"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",119,null],[11,"encode","","",119,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",119,{"i":[{"n":"__d"}],"o":{"g":["implitemkind"],"n":"result"}}],[11,"hash","","",119,null],[11,"fmt","","",119,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",66,{"i":[{"n":"self"}],"o":{"n":"typebinding"}}],[11,"eq","","",66,{"i":[{"n":"self"},{"n":"typebinding"}],"o":{"n":"bool"}}],[11,"ne","","",66,{"i":[{"n":"self"},{"n":"typebinding"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",66,null],[11,"encode","","",66,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",66,{"i":[{"n":"__d"}],"o":{"g":["typebinding"],"n":"result"}}],[11,"hash","","",66,null],[11,"fmt","","",66,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",67,{"i":[{"n":"self"}],"o":{"n":"ty"}}],[11,"eq","","",67,{"i":[{"n":"self"},{"n":"ty"}],"o":{"n":"bool"}}],[11,"ne","","",67,{"i":[{"n":"self"},{"n":"ty"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",67,null],[11,"encode","","",67,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",67,{"i":[{"n":"__d"}],"o":{"g":["ty"],"n":"result"}}],[11,"hash","","",67,null],[11,"fmt","","",67,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",120,{"i":[{"n":"self"}],"o":{"n":"primty"}}],[11,"eq","","",120,{"i":[{"n":"self"},{"n":"primty"}],"o":{"n":"bool"}}],[11,"ne","","",120,{"i":[{"n":"self"},{"n":"primty"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",120,null],[11,"encode","","",120,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",120,{"i":[{"n":"__d"}],"o":{"g":["primty"],"n":"result"}}],[11,"hash","","",120,null],[11,"fmt","","",120,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",68,{"i":[{"n":"self"}],"o":{"n":"barefnty"}}],[11,"eq","","",68,{"i":[{"n":"self"},{"n":"barefnty"}],"o":{"n":"bool"}}],[11,"ne","","",68,{"i":[{"n":"self"},{"n":"barefnty"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",68,null],[11,"encode","","",68,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",68,{"i":[{"n":"__d"}],"o":{"g":["barefnty"],"n":"result"}}],[11,"hash","","",68,null],[11,"fmt","","",68,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",69,{"i":[{"n":"self"}],"o":{"n":"existty"}}],[11,"eq","","",69,{"i":[{"n":"self"},{"n":"existty"}],"o":{"n":"bool"}}],[11,"ne","","",69,{"i":[{"n":"self"},{"n":"existty"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",69,null],[11,"encode","","",69,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",69,{"i":[{"n":"__d"}],"o":{"g":["existty"],"n":"result"}}],[11,"hash","","",69,null],[11,"fmt","","",69,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",121,{"i":[{"n":"self"}],"o":{"n":"ty_"}}],[11,"eq","","",121,{"i":[{"n":"self"},{"n":"ty_"}],"o":{"n":"bool"}}],[11,"ne","","",121,{"i":[{"n":"self"},{"n":"ty_"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",121,null],[11,"encode","","",121,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",121,{"i":[{"n":"__d"}],"o":{"g":["ty_"],"n":"result"}}],[11,"hash","","",121,null],[11,"fmt","","",121,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",70,{"i":[{"n":"self"}],"o":{"n":"inlineasmoutput"}}],[11,"eq","","",70,{"i":[{"n":"self"},{"n":"inlineasmoutput"}],"o":{"n":"bool"}}],[11,"ne","","",70,{"i":[{"n":"self"},{"n":"inlineasmoutput"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",70,null],[11,"encode","","",70,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",70,{"i":[{"n":"__d"}],"o":{"g":["inlineasmoutput"],"n":"result"}}],[11,"hash","","",70,null],[11,"fmt","","",70,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",71,{"i":[{"n":"self"}],"o":{"n":"inlineasm"}}],[11,"eq","","",71,{"i":[{"n":"self"},{"n":"inlineasm"}],"o":{"n":"bool"}}],[11,"ne","","",71,{"i":[{"n":"self"},{"n":"inlineasm"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",71,null],[11,"encode","","",71,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",71,{"i":[{"n":"__d"}],"o":{"g":["inlineasm"],"n":"result"}}],[11,"hash","","",71,null],[11,"fmt","","",71,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",72,{"i":[{"n":"self"}],"o":{"n":"arg"}}],[11,"eq","","",72,{"i":[{"n":"self"},{"n":"arg"}],"o":{"n":"bool"}}],[11,"ne","","",72,{"i":[{"n":"self"},{"n":"arg"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",72,null],[11,"encode","","",72,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",72,{"i":[{"n":"__d"}],"o":{"g":["arg"],"n":"result"}}],[11,"hash","","",72,null],[11,"fmt","","",72,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",73,{"i":[{"n":"self"}],"o":{"n":"fndecl"}}],[11,"eq","","",73,{"i":[{"n":"self"},{"n":"fndecl"}],"o":{"n":"bool"}}],[11,"ne","","",73,{"i":[{"n":"self"},{"n":"fndecl"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",73,null],[11,"encode","","",73,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",73,{"i":[{"n":"__d"}],"o":{"g":["fndecl"],"n":"result"}}],[11,"hash","","",73,null],[11,"fmt","","",73,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",122,{"i":[{"n":"self"}],"o":{"n":"isauto"}}],[11,"eq","","",122,{"i":[{"n":"self"},{"n":"isauto"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",122,null],[11,"encode","","",122,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",122,{"i":[{"n":"__d"}],"o":{"g":["isauto"],"n":"result"}}],[11,"hash","","",122,null],[11,"fmt","","",122,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",123,{"i":[{"n":"self"}],"o":{"n":"unsafety"}}],[11,"eq","","",123,{"i":[{"n":"self"},{"n":"unsafety"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",123,null],[11,"partial_cmp","","",123,{"i":[{"n":"self"},{"n":"unsafety"}],"o":{"g":["ordering"],"n":"option"}}],[11,"cmp","","",123,{"i":[{"n":"self"},{"n":"unsafety"}],"o":{"n":"ordering"}}],[11,"encode","","",123,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",123,{"i":[{"n":"__d"}],"o":{"g":["unsafety"],"n":"result"}}],[11,"hash","","",123,null],[11,"fmt","","",123,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",124,{"i":[{"n":"self"}],"o":{"n":"constness"}}],[11,"eq","","",124,{"i":[{"n":"self"},{"n":"constness"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",124,null],[11,"encode","","",124,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",124,{"i":[{"n":"__d"}],"o":{"g":["constness"],"n":"result"}}],[11,"hash","","",124,null],[11,"fmt","","",124,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",125,{"i":[{"n":"self"}],"o":{"n":"defaultness"}}],[11,"eq","","",125,{"i":[{"n":"self"},{"n":"defaultness"}],"o":{"n":"bool"}}],[11,"ne","","",125,{"i":[{"n":"self"},{"n":"defaultness"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",125,null],[11,"encode","","",125,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",125,{"i":[{"n":"__d"}],"o":{"g":["defaultness"],"n":"result"}}],[11,"hash","","",125,null],[11,"fmt","","",125,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"has_value","","",125,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"is_final","","",125,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"is_default","","",125,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"fmt","","",123,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",126,{"i":[{"n":"self"}],"o":{"n":"implpolarity"}}],[11,"eq","","",126,{"i":[{"n":"self"},{"n":"implpolarity"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",126,null],[11,"encode","","",126,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",126,{"i":[{"n":"__d"}],"o":{"g":["implpolarity"],"n":"result"}}],[11,"hash","","",126,null],[11,"fmt","","",126,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",127,{"i":[{"n":"self"}],"o":{"n":"functionretty"}}],[11,"eq","","",127,{"i":[{"n":"self"},{"n":"functionretty"}],"o":{"n":"bool"}}],[11,"ne","","",127,{"i":[{"n":"self"},{"n":"functionretty"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",127,null],[11,"encode","","",127,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",127,{"i":[{"n":"__d"}],"o":{"g":["functionretty"],"n":"result"}}],[11,"hash","","",127,null],[11,"fmt","","",127,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"span","","",127,{"i":[{"n":"self"}],"o":{"n":"span"}}],[11,"clone","","",74,{"i":[{"n":"self"}],"o":{"n":"mod"}}],[11,"eq","","",74,{"i":[{"n":"self"},{"n":"mod"}],"o":{"n":"bool"}}],[11,"ne","","",74,{"i":[{"n":"self"},{"n":"mod"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",74,null],[11,"encode","","",74,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",74,{"i":[{"n":"__d"}],"o":{"g":["mod"],"n":"result"}}],[11,"hash","","",74,null],[11,"fmt","","",74,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",75,{"i":[{"n":"self"}],"o":{"n":"foreignmod"}}],[11,"eq","","",75,{"i":[{"n":"self"},{"n":"foreignmod"}],"o":{"n":"bool"}}],[11,"ne","","",75,{"i":[{"n":"self"},{"n":"foreignmod"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",75,null],[11,"encode","","",75,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",75,{"i":[{"n":"__d"}],"o":{"g":["foreignmod"],"n":"result"}}],[11,"hash","","",75,null],[11,"fmt","","",75,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",76,{"i":[{"n":"self"}],"o":{"n":"globalasm"}}],[11,"eq","","",76,{"i":[{"n":"self"},{"n":"globalasm"}],"o":{"n":"bool"}}],[11,"ne","","",76,{"i":[{"n":"self"},{"n":"globalasm"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",76,null],[11,"encode","","",76,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",76,{"i":[{"n":"__d"}],"o":{"g":["globalasm"],"n":"result"}}],[11,"hash","","",76,null],[11,"fmt","","",76,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",77,{"i":[{"n":"self"}],"o":{"n":"enumdef"}}],[11,"eq","","",77,{"i":[{"n":"self"},{"n":"enumdef"}],"o":{"n":"bool"}}],[11,"ne","","",77,{"i":[{"n":"self"},{"n":"enumdef"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",77,null],[11,"encode","","",77,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",77,{"i":[{"n":"__d"}],"o":{"g":["enumdef"],"n":"result"}}],[11,"hash","","",77,null],[11,"fmt","","",77,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",78,{"i":[{"n":"self"}],"o":{"n":"variant_"}}],[11,"eq","","",78,{"i":[{"n":"self"},{"n":"variant_"}],"o":{"n":"bool"}}],[11,"ne","","",78,{"i":[{"n":"self"},{"n":"variant_"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",78,null],[11,"encode","","",78,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",78,{"i":[{"n":"__d"}],"o":{"g":["variant_"],"n":"result"}}],[11,"hash","","",78,null],[11,"fmt","","",78,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",128,{"i":[{"n":"self"}],"o":{"n":"usekind"}}],[11,"eq","","",128,{"i":[{"n":"self"},{"n":"usekind"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",128,null],[11,"encode","","",128,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",128,{"i":[{"n":"__d"}],"o":{"g":["usekind"],"n":"result"}}],[11,"hash","","",128,null],[11,"fmt","","",128,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",79,{"i":[{"n":"self"}],"o":{"n":"traitref"}}],[11,"eq","","",79,{"i":[{"n":"self"},{"n":"traitref"}],"o":{"n":"bool"}}],[11,"ne","","",79,{"i":[{"n":"self"},{"n":"traitref"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",79,null],[11,"encode","","",79,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",79,{"i":[{"n":"__d"}],"o":{"g":["traitref"],"n":"result"}}],[11,"hash","","",79,null],[11,"fmt","","",79,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",80,{"i":[{"n":"self"}],"o":{"n":"polytraitref"}}],[11,"eq","","",80,{"i":[{"n":"self"},{"n":"polytraitref"}],"o":{"n":"bool"}}],[11,"ne","","",80,{"i":[{"n":"self"},{"n":"polytraitref"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",80,null],[11,"encode","","",80,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",80,{"i":[{"n":"__d"}],"o":{"g":["polytraitref"],"n":"result"}}],[11,"hash","","",80,null],[11,"fmt","","",80,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",129,{"i":[{"n":"self"}],"o":{"n":"visibility"}}],[11,"eq","","",129,{"i":[{"n":"self"},{"n":"visibility"}],"o":{"n":"bool"}}],[11,"ne","","",129,{"i":[{"n":"self"},{"n":"visibility"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",129,null],[11,"encode","","",129,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",129,{"i":[{"n":"__d"}],"o":{"g":["visibility"],"n":"result"}}],[11,"hash","","",129,null],[11,"fmt","","",129,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"is_pub_restricted","","",129,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"clone","","",81,{"i":[{"n":"self"}],"o":{"n":"structfield"}}],[11,"eq","","",81,{"i":[{"n":"self"},{"n":"structfield"}],"o":{"n":"bool"}}],[11,"ne","","",81,{"i":[{"n":"self"},{"n":"structfield"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",81,null],[11,"encode","","",81,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",81,{"i":[{"n":"__d"}],"o":{"g":["structfield"],"n":"result"}}],[11,"hash","","",81,null],[11,"fmt","","",81,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"is_positional","","",81,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"clone","","",130,{"i":[{"n":"self"}],"o":{"n":"variantdata"}}],[11,"eq","","",130,{"i":[{"n":"self"},{"n":"variantdata"}],"o":{"n":"bool"}}],[11,"ne","","",130,{"i":[{"n":"self"},{"n":"variantdata"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",130,null],[11,"encode","","",130,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",130,{"i":[{"n":"__d"}],"o":{"g":["variantdata"],"n":"result"}}],[11,"hash","","",130,null],[11,"fmt","","",130,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fields","","",130,null],[11,"id","","",130,{"i":[{"n":"self"}],"o":{"n":"nodeid"}}],[11,"is_struct","","",130,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"is_tuple","","",130,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"is_unit","","",130,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"clone","","",82,{"i":[{"n":"self"}],"o":{"n":"itemid"}}],[11,"eq","","",82,{"i":[{"n":"self"},{"n":"itemid"}],"o":{"n":"bool"}}],[11,"ne","","",82,{"i":[{"n":"self"},{"n":"itemid"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",82,null],[11,"encode","","",82,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",82,{"i":[{"n":"__d"}],"o":{"g":["itemid"],"n":"result"}}],[11,"hash","","",82,null],[11,"fmt","","",82,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",83,{"i":[{"n":"self"}],"o":{"n":"item"}}],[11,"eq","","",83,{"i":[{"n":"self"},{"n":"item"}],"o":{"n":"bool"}}],[11,"ne","","",83,{"i":[{"n":"self"},{"n":"item"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",83,null],[11,"encode","","",83,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",83,{"i":[{"n":"__d"}],"o":{"g":["item"],"n":"result"}}],[11,"hash","","",83,null],[11,"fmt","","",83,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",131,{"i":[{"n":"self"}],"o":{"n":"item_"}}],[11,"eq","","",131,{"i":[{"n":"self"},{"n":"item_"}],"o":{"n":"bool"}}],[11,"ne","","",131,{"i":[{"n":"self"},{"n":"item_"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",131,null],[11,"encode","","",131,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",131,{"i":[{"n":"__d"}],"o":{"g":["item_"],"n":"result"}}],[11,"hash","","",131,null],[11,"fmt","","",131,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"descriptive_variant","","",131,{"i":[{"n":"self"}],"o":{"n":"str"}}],[11,"adt_kind","","",131,{"i":[{"n":"self"}],"o":{"g":["adtkind"],"n":"option"}}],[11,"generics","","",131,{"i":[{"n":"self"}],"o":{"g":["generics"],"n":"option"}}],[11,"clone","","",84,{"i":[{"n":"self"}],"o":{"n":"traititemref"}}],[11,"eq","","",84,{"i":[{"n":"self"},{"n":"traititemref"}],"o":{"n":"bool"}}],[11,"ne","","",84,{"i":[{"n":"self"},{"n":"traititemref"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",84,null],[11,"encode","","",84,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",84,{"i":[{"n":"__d"}],"o":{"g":["traititemref"],"n":"result"}}],[11,"hash","","",84,null],[11,"fmt","","",84,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",85,{"i":[{"n":"self"}],"o":{"n":"implitemref"}}],[11,"eq","","",85,{"i":[{"n":"self"},{"n":"implitemref"}],"o":{"n":"bool"}}],[11,"ne","","",85,{"i":[{"n":"self"},{"n":"implitemref"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",85,null],[11,"encode","","",85,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",85,{"i":[{"n":"__d"}],"o":{"g":["implitemref"],"n":"result"}}],[11,"hash","","",85,null],[11,"fmt","","",85,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",132,{"i":[{"n":"self"}],"o":{"n":"associateditemkind"}}],[11,"eq","","",132,{"i":[{"n":"self"},{"n":"associateditemkind"}],"o":{"n":"bool"}}],[11,"ne","","",132,{"i":[{"n":"self"},{"n":"associateditemkind"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",132,null],[11,"encode","","",132,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",132,{"i":[{"n":"__d"}],"o":{"g":["associateditemkind"],"n":"result"}}],[11,"hash","","",132,null],[11,"fmt","","",132,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",86,{"i":[{"n":"self"}],"o":{"n":"foreignitem"}}],[11,"eq","","",86,{"i":[{"n":"self"},{"n":"foreignitem"}],"o":{"n":"bool"}}],[11,"ne","","",86,{"i":[{"n":"self"},{"n":"foreignitem"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",86,null],[11,"encode","","",86,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",86,{"i":[{"n":"__d"}],"o":{"g":["foreignitem"],"n":"result"}}],[11,"hash","","",86,null],[11,"fmt","","",86,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",133,{"i":[{"n":"self"}],"o":{"n":"foreignitem_"}}],[11,"eq","","",133,{"i":[{"n":"self"},{"n":"foreignitem_"}],"o":{"n":"bool"}}],[11,"ne","","",133,{"i":[{"n":"self"},{"n":"foreignitem_"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",133,null],[11,"encode","","",133,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",133,{"i":[{"n":"__d"}],"o":{"g":["foreignitem_"],"n":"result"}}],[11,"hash","","",133,null],[11,"fmt","","",133,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"descriptive_variant","","",133,{"i":[{"n":"self"}],"o":{"n":"str"}}],[11,"fmt","","",87,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",87,{"i":[{"n":"self"}],"o":{"n":"freevar"}}],[11,"encode","","",87,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",87,{"i":[{"n":"__d"}],"o":{"g":["freevar"],"n":"result"}}],[11,"var_id","","",87,{"i":[{"n":"self"}],"o":{"n":"nodeid"}}],[11,"clone","","",88,{"i":[{"n":"self"}],"o":{"n":"traitcandidate"}}],[11,"fmt","","",88,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",89,{"i":[{"n":"self"}],"o":{"n":"codegenfnattrs"}}],[11,"encode","","",89,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",89,{"i":[{"n":"__d"}],"o":{"g":["codegenfnattrs"],"n":"result"}}],[11,"hash","","",89,null],[11,"eq","","",90,{"i":[{"n":"self"},{"n":"codegenfnattrflags"}],"o":{"n":"bool"}}],[11,"ne","","",90,{"i":[{"n":"self"},{"n":"codegenfnattrflags"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",90,null],[11,"clone","","",90,{"i":[{"n":"self"}],"o":{"n":"codegenfnattrflags"}}],[11,"partial_cmp","","",90,{"i":[{"n":"self"},{"n":"codegenfnattrflags"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",90,{"i":[{"n":"self"},{"n":"codegenfnattrflags"}],"o":{"n":"bool"}}],[11,"le","","",90,{"i":[{"n":"self"},{"n":"codegenfnattrflags"}],"o":{"n":"bool"}}],[11,"gt","","",90,{"i":[{"n":"self"},{"n":"codegenfnattrflags"}],"o":{"n":"bool"}}],[11,"ge","","",90,{"i":[{"n":"self"},{"n":"codegenfnattrflags"}],"o":{"n":"bool"}}],[11,"cmp","","",90,{"i":[{"n":"self"},{"n":"codegenfnattrflags"}],"o":{"n":"ordering"}}],[11,"hash","","",90,null],[11,"encode","","",90,{"i":[{"n":"self"},{"n":"__s"}],"o":{"n":"result"}}],[11,"decode","","",90,{"i":[{"n":"__d"}],"o":{"g":["codegenfnattrflags"],"n":"result"}}],[11,"fmt","","",90,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",90,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",90,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",90,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",90,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[18,"COLD","","",90,null],[18,"ALLOCATOR","","",90,null],[18,"UNWIND","","",90,null],[18,"RUSTC_ALLOCATOR_NOUNWIND","","",90,null],[18,"NAKED","","",90,null],[18,"NO_MANGLE","","",90,null],[18,"RUSTC_STD_INTERNAL_SYMBOL","","",90,null],[18,"NO_DEBUG","","",90,null],[11,"empty","","Returns an empty set of flags.",90,{"o":{"n":"codegenfnattrflags"}}],[11,"all","","Returns the set containing all flags.",90,{"o":{"n":"codegenfnattrflags"}}],[11,"bits","","Returns the raw value of the flags currently stored.",90,{"i":[{"n":"self"}],"o":{"n":"u8"}}],[11,"from_bits","","Convert from underlying bit representation, unless that representation contains bits that do not correspond to a flag.",90,{"i":[{"n":"u8"}],"o":{"g":["codegenfnattrflags"],"n":"option"}}],[11,"from_bits_truncate","","Convert from underlying bit representation, dropping any bits that do not correspond to flags.",90,{"i":[{"n":"u8"}],"o":{"n":"codegenfnattrflags"}}],[11,"is_empty","","Returns `true` if no flags are currently stored.",90,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"is_all","","Returns `true` if all flags are currently set.",90,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"intersects","","Returns `true` if there are flags common to both `self` and `other`.",90,{"i":[{"n":"self"},{"n":"codegenfnattrflags"}],"o":{"n":"bool"}}],[11,"contains","","Returns `true` all of the flags in `other` are contained within `self`.",90,{"i":[{"n":"self"},{"n":"codegenfnattrflags"}],"o":{"n":"bool"}}],[11,"insert","","Inserts the specified flags in-place.",90,{"i":[{"n":"self"},{"n":"codegenfnattrflags"}]}],[11,"remove","","Removes the specified flags in-place.",90,{"i":[{"n":"self"},{"n":"codegenfnattrflags"}]}],[11,"toggle","","Toggles the specified flags in-place.",90,{"i":[{"n":"self"},{"n":"codegenfnattrflags"}]}],[11,"set","","Inserts or removes the specified flags depending on the passed value.",90,{"i":[{"n":"self"},{"n":"codegenfnattrflags"},{"n":"bool"}]}],[11,"bitor","","Returns the union of the two sets of flags.",90,{"i":[{"n":"self"},{"n":"codegenfnattrflags"}],"o":{"n":"codegenfnattrflags"}}],[11,"bitor_assign","","Adds the set of flags.",90,{"i":[{"n":"self"},{"n":"codegenfnattrflags"}]}],[11,"bitxor","","Returns the left flags, but with all the right flags toggled.",90,{"i":[{"n":"self"},{"n":"codegenfnattrflags"}],"o":{"n":"codegenfnattrflags"}}],[11,"bitxor_assign","","Toggles the set of flags.",90,{"i":[{"n":"self"},{"n":"codegenfnattrflags"}]}],[11,"bitand","","Returns the intersection between the two sets of flags.",90,{"i":[{"n":"self"},{"n":"codegenfnattrflags"}],"o":{"n":"codegenfnattrflags"}}],[11,"bitand_assign","","Disables all flags disabled in the set.",90,{"i":[{"n":"self"},{"n":"codegenfnattrflags"}]}],[11,"sub","","Returns the set difference of the two sets of flags.",90,{"i":[{"n":"self"},{"n":"codegenfnattrflags"}],"o":{"n":"codegenfnattrflags"}}],[11,"sub_assign","","Disables all flags enabled in the set.",90,{"i":[{"n":"self"},{"n":"codegenfnattrflags"}]}],[11,"not","","Returns the complement of this set of flags.",90,{"i":[{"n":"self"}],"o":{"n":"codegenfnattrflags"}}],[11,"extend","","",90,{"i":[{"n":"self"},{"n":"t"}]}],[11,"from_iter","","",90,{"i":[{"n":"t"}],"o":{"n":"codegenfnattrflags"}}],[11,"new","","",89,{"o":{"n":"codegenfnattrs"}}],[11,"requests_inline","","True if `#[inline]` or `#[inline(always)]` is present.",89,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"contains_extern_indicator","","True if `#[no_mangle]` or `#[export_name(...)]` is present.",89,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[0,"ich","rustc","ICH - Incremental Compilation Hash",null,null],[3,"Fingerprint","rustc::ich","",null,null],[12,"0","","",197,null],[12,"1","","",197,null],[3,"CachingCodemapView","","",null,null],[12,"codemap","","",198,null],[12,"line_cache","","",198,null],[12,"time_stamp","","",198,null],[3,"StableHashingContext","","This is the context state available during incr. comp. hashing. It contains enough information to transform DefIds and HirIds into stable DefPaths (i.e. a reference to the TyCtxt) and it holds a few caches for speeding up various things (e.g. each DefId/DefPath is only hashed once).",null,null],[12,"sess","","",199,null],[12,"definitions","","",199,null],[12,"cstore","","",199,null],[12,"body_resolver","","",199,null],[12,"hash_spans","","",199,null],[12,"hash_bodies","","",199,null],[12,"node_id_hashing_mode","","",199,null],[12,"raw_codemap","","",199,null],[12,"caching_codemap","","",199,null],[12,"alloc_id_recursion_tracker","","",199,null],[4,"NodeIdHashingMode","","",null,null],[13,"Ignore","","",200,null],[13,"HashDefPath","","",200,null],[5,"hash_stable_trait_impls","","",null,{"i":[{"n":"stablehashingcontext"},{"n":"stablehasher"},{"n":"vec"},{"n":"hashmap"}]}],[5,"compute_ignored_attr_names","","",null,{"o":{"g":["symbol"],"n":"fxhashset"}}],[0,"fingerprint","","",null,null],[3,"Fingerprint","rustc::ich::fingerprint","",null,null],[12,"0","","",197,null],[12,"1","","",197,null],[11,"assert_receiver_is_total_eq","rustc::ich","",197,null],[11,"eq","","",197,{"i":[{"n":"self"},{"n":"fingerprint"}],"o":{"n":"bool"}}],[11,"ne","","",197,{"i":[{"n":"self"},{"n":"fingerprint"}],"o":{"n":"bool"}}],[11,"cmp","","",197,{"i":[{"n":"self"},{"n":"fingerprint"}],"o":{"n":"ordering"}}],[11,"partial_cmp","","",197,{"i":[{"n":"self"},{"n":"fingerprint"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",197,{"i":[{"n":"self"},{"n":"fingerprint"}],"o":{"n":"bool"}}],[11,"le","","",197,{"i":[{"n":"self"},{"n":"fingerprint"}],"o":{"n":"bool"}}],[11,"gt","","",197,{"i":[{"n":"self"},{"n":"fingerprint"}],"o":{"n":"bool"}}],[11,"ge","","",197,{"i":[{"n":"self"},{"n":"fingerprint"}],"o":{"n":"bool"}}],[11,"hash","","",197,null],[11,"fmt","","",197,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",197,{"i":[{"n":"self"}],"o":{"n":"fingerprint"}}],[18,"ZERO","","",197,null],[11,"from_smaller_hash","","",197,{"i":[{"n":"u64"}],"o":{"n":"fingerprint"}}],[11,"to_smaller_hash","","",197,{"i":[{"n":"self"}],"o":{"n":"u64"}}],[11,"as_value","","",197,null],[11,"combine","","",197,{"i":[{"n":"self"},{"n":"fingerprint"}],"o":{"n":"fingerprint"}}],[11,"to_hex","","",197,{"i":[{"n":"self"}],"o":{"n":"string"}}],[11,"encode_opaque","","",197,{"i":[{"n":"self"},{"n":"encoder"}],"o":{"n":"encoderesult"}}],[11,"decode_opaque","","",197,{"i":[{"n":"decoder"}],"o":{"g":["fingerprint","string"],"n":"result"}}],[11,"fmt","","",197,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"finish","","",197,{"i":[{"n":"stablehasher"}],"o":{"n":"self"}}],[11,"hash_stable","","",197,{"i":[{"n":"self"},{"n":"ctx"},{"n":"stablehasher"}]}],[0,"caching_codemap_view","","",null,null],[3,"CacheEntry","rustc::ich::caching_codemap_view","",null,null],[12,"time_stamp","","",201,null],[12,"line_number","","",201,null],[12,"line_start","","",201,null],[12,"line_end","","",201,null],[12,"file","","",201,null],[12,"file_index","","",201,null],[3,"CachingCodemapView","","",null,null],[12,"codemap","","",198,null],[12,"line_cache","","",198,null],[12,"time_stamp","","",198,null],[11,"clone","","",201,{"i":[{"n":"self"}],"o":{"n":"cacheentry"}}],[11,"clone","rustc::ich","",198,{"i":[{"n":"self"}],"o":{"n":"cachingcodemapview"}}],[11,"new","","",198,{"i":[{"n":"codemap"}],"o":{"n":"cachingcodemapview"}}],[11,"byte_pos_to_line_and_col","","",198,{"i":[{"n":"self"},{"n":"bytepos"}],"o":{"n":"option"}}],[0,"hcx","","",null,null],[3,"StableHashingContext","rustc::ich::hcx","This is the context state available during incr. comp. hashing. It contains enough information to transform DefIds and HirIds into stable DefPaths (i.e. a reference to the TyCtxt) and it holds a few caches for speeding up various things (e.g. each DefId/DefPath is only hashed once).",null,null],[12,"sess","","",199,null],[12,"definitions","","",199,null],[12,"cstore","","",199,null],[12,"body_resolver","","",199,null],[12,"hash_spans","","",199,null],[12,"hash_bodies","","",199,null],[12,"node_id_hashing_mode","","",199,null],[12,"raw_codemap","","",199,null],[12,"caching_codemap","","",199,null],[12,"alloc_id_recursion_tracker","","",199,null],[3,"BodyResolver","","The BodyResolver allows to map a BodyId to the corresponding hir::Body. We could also just store a plain reference to the hir::Crate but we want to avoid that the crate is used to get untracked access to all of the HIR.",null,null],[12,"0","","",202,null],[4,"NodeIdHashingMode","","",null,null],[13,"Ignore","","",200,null],[13,"HashDefPath","","",200,null],[5,"compute_ignored_attr_names","","",null,{"o":{"g":["symbol"],"n":"fxhashset"}}],[5,"hash_stable_trait_impls","","",null,{"i":[{"n":"stablehashingcontext"},{"n":"stablehasher"},{"n":"vec"},{"n":"hashmap"}]}],[8,"StableHashingContextProvider","","Something that can provide a stable hashing context.",null,null],[10,"get_stable_hashing_context","","",203,{"i":[{"n":"self"}],"o":{"n":"stablehashingcontext"}}],[11,"clone","rustc::ich","",199,{"i":[{"n":"self"}],"o":{"n":"stablehashingcontext"}}],[11,"eq","","",200,{"i":[{"n":"self"},{"n":"nodeidhashingmode"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",200,null],[11,"clone","","",200,{"i":[{"n":"self"}],"o":{"n":"nodeidhashingmode"}}],[11,"clone","rustc::ich::hcx","",202,{"i":[{"n":"self"}],"o":{"n":"bodyresolver"}}],[11,"body","","",202,{"i":[{"n":"self"},{"n":"bodyid"}],"o":{"n":"body"}}],[11,"new","rustc::ich","",199,{"i":[{"n":"session"},{"n":"crate"},{"n":"definitions"},{"n":"cratestore"}],"o":{"n":"self"}}],[11,"sess","","",199,{"i":[{"n":"self"}],"o":{"n":"session"}}],[11,"while_hashing_hir_bodies","","",199,{"i":[{"n":"self"},{"n":"bool"},{"n":"f"}]}],[11,"while_hashing_spans","","",199,{"i":[{"n":"self"},{"n":"bool"},{"n":"f"}]}],[11,"with_node_id_hashing_mode","","",199,{"i":[{"n":"self"},{"n":"nodeidhashingmode"},{"n":"f"}]}],[11,"def_path_hash","","",199,{"i":[{"n":"self"},{"n":"defid"}],"o":{"n":"defpathhash"}}],[11,"local_def_path_hash","","",199,{"i":[{"n":"self"},{"n":"defindex"}],"o":{"n":"defpathhash"}}],[11,"node_to_hir_id","","",199,{"i":[{"n":"self"},{"n":"nodeid"}],"o":{"n":"hirid"}}],[11,"hash_bodies","","",199,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"codemap","","",199,{"i":[{"n":"self"}],"o":{"n":"cachingcodemapview"}}],[11,"is_ignored_attr","","",199,{"i":[{"n":"self"},{"n":"symbol"}],"o":{"n":"bool"}}],[11,"hash_hir_item_like","","",199,{"i":[{"n":"self"},{"n":"f"}]}],[11,"get_stable_hashing_context","","",199,{"i":[{"n":"self"}],"o":{"n":"stablehashingcontext"}}],[11,"hash_stable","rustc::hir","",55,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",33,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"to_stable_hash_key","","",33,null],[0,"impls_cstore","rustc::ich","This module contains `HashStable` implementations for various data types from rustc::middle::cstore in no particular order.",null,null],[0,"impls_hir","","This module contains `HashStable` implementations for various HIR data types in no particular order.",null,null],[11,"hash_stable","rustc::hir::def_id","",144,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"to_stable_hash_key","","",144,{"i":[{"n":"self"},{"n":"stablehashingcontext"}],"o":{"n":"defpathhash"}}],[11,"hash_stable","","",145,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"to_stable_hash_key","","",145,{"i":[{"n":"self"},{"n":"stablehashingcontext"}],"o":{"n":"defpathhash"}}],[11,"hash_stable","","",142,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"to_stable_hash_key","","",142,{"i":[{"n":"self"},{"n":"stablehashingcontext"}],"o":{"n":"defpathhash"}}],[11,"hash_stable","rustc::hir","",34,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"to_stable_hash_key","","",34,{"i":[{"n":"self"},{"n":"stablehashingcontext"}],"o":{"n":"itemlocalid"}}],[11,"hash_stable","","",82,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",62,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",64,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",91,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",35,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",36,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",37,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",38,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",39,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",40,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",92,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",93,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",41,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",94,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",42,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",96,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",43,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",97,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",44,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",45,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",46,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",60,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",61,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",66,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",67,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",120,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",68,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",69,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",121,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",73,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",127,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",79,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",80,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",110,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",48,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",49,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",50,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",51,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",98,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",99,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",100,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",102,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",103,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",52,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",105,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",53,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",54,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",106,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",107,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",57,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",58,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",109,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",111,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",113,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",112,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",115,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",116,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",59,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",114,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",63,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",117,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",118,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",65,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",119,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",129,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",125,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",126,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",74,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",75,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",77,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",78,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",128,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",81,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",130,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",83,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",131,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",84,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",85,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",132,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",86,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",133,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",104,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",72,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",56,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"to_stable_hash_key","","",55,null],[11,"hash_stable","","",70,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",76,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",71,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","rustc::hir::def","",139,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",140,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","rustc::hir","",101,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",122,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",123,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",124,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","rustc::hir::def_id","",143,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"to_stable_hash_key","","",143,{"i":[{"n":"self"},{"n":"stablehashingcontext"}],"o":{"n":"defpathhash"}}],[11,"hash_stable","rustc::hir::def","",138,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","rustc::hir","",88,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"to_stable_hash_key","","",88,null],[11,"hash_stable","","",89,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",90,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[11,"hash_stable","","",87,{"i":[{"n":"self"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[0,"impls_mir","rustc::ich","This module contains `HashStable` implementations for various MIR data types in no particular order.",null,null],[0,"impls_misc","","This module contains `HashStable` implementations for various data types that don't fit into any of the other impls_xxx modules.",null,null],[0,"impls_ty","","This module contains `HashStable` implementations for various data types from rustc::ty in no particular order.",null,null],[0,"impls_syntax","","This module contains `HashStable` implementations for various data types from libsyntax in no particular order.",null,null],[5,"hash_token","rustc::ich::impls_syntax","",null,{"i":[{"n":"token"},{"n":"stablehashingcontext"},{"n":"stablehasher"}]}],[5,"stable_byte_pos","","",null,{"i":[{"n":"bytepos"},{"n":"bytepos"}],"o":{"n":"u32"}}],[5,"stable_multibyte_char","","",null,null],[5,"stable_non_narrow_char","","",null,null],[17,"ATTR_DIRTY","rustc::ich","",null,null],[17,"ATTR_CLEAN","","",null,null],[17,"ATTR_IF_THIS_CHANGED","","",null,null],[17,"ATTR_THEN_THIS_WOULD_NEED","","",null,null],[17,"ATTR_PARTITION_REUSED","","",null,null],[17,"ATTR_PARTITION_CODEGENED","","",null,null],[17,"DEP_GRAPH_ASSERT_ATTRS","","",null,null],[17,"IGNORED_ATTRIBUTES","","",null,null],[8,"StableHashingContextProvider","","Something that can provide a stable hashing context.",null,null],[10,"get_stable_hashing_context","","",203,{"i":[{"n":"self"}],"o":{"n":"stablehashingcontext"}}],[0,"infer","rustc","See the Book for more information.",null,null],[3,"TypeFreshener","rustc::infer","",null,null],[12,"infcx","","",204,null],[12,"freshen_count","","",204,null],[12,"freshen_map","","",204,null],[3,"InferOk","","",null,null],[12,"value","","",205,null],[12,"obligations","","",205,null],[3,"InferCtxt","","",null,null],[12,"tcx","","",206,null],[12,"in_progress_tables","","During type-checking/inference of a body, `in_progress_tables` contains a reference to the tables being built up, which are used for reading closure kinds/signatures as they are inferred, and for error reporting logic to read arbitrary node types.",206,null],[12,"projection_cache","","",206,null],[12,"type_variables","","",206,null],[12,"int_unification_table","","",206,null],[12,"float_unification_table","","",206,null],[12,"region_constraints","","",206,null],[12,"lexical_region_resolutions","","",206,null],[12,"selection_cache","","Caches the results of trait selection. This cache is used for things that have to do with the parameters in scope.",206,null],[12,"evaluation_cache","","Caches the results of trait evaluation.",206,null],[12,"reported_trait_errors","","",206,null],[12,"tainted_by_errors_flag","","",206,null],[12,"err_count_on_creation","","",206,null],[12,"in_snapshot","","",206,null],[12,"region_obligations","","",206,null],[12,"universe","","What is the innermost universe we have created? Starts out as `UniverseIndex::root()` but grows from there as we enter universal quantifiers.",206,null],[3,"TypeTrace","","The trace designates the path through inference that we took to encounter an error or subtyping constraint.",null,null],[12,"cause","","",207,null],[12,"values","","",207,null],[3,"RegionObligation","","See the `region_obligations` field for more information.",null,null],[12,"sub_region","","",208,null],[12,"sup_type","","",208,null],[12,"cause","","",208,null],[3,"InferCtxtBuilder","","Helper type of a temporary returned by tcx.infer_ctxt(). Necessary because we can't write the following bound: F: for<'b, 'tcx> where 'gcx: 'tcx FnOnce(InferCtxt<'b, 'gcx, 'tcx>).",null,null],[12,"global_tcx","","",209,null],[12,"arena","","",209,null],[12,"fresh_tables","","",209,null],[3,"CombinedSnapshot","","",null,null],[12,"projection_cache_snapshot","","",210,null],[12,"type_snapshot","","",210,null],[12,"int_snapshot","","",210,null],[12,"float_snapshot","","",210,null],[12,"region_constraints_snapshot","","",210,null],[12,"region_obligations_snapshot","","",210,null],[12,"universe","","",210,null],[12,"was_in_snapshot","","",210,null],[12,"_in_progress_tables","","",210,null],[4,"ValuePairs","","See `error_reporting` module for more details",null,null],[13,"Types","","",211,null],[13,"Regions","","",211,null],[13,"TraitRefs","","",211,null],[13,"PolyTraitRefs","","",211,null],[4,"SubregionOrigin","","The origin of a `r1 <= r2` constraint.",null,null],[13,"Subtype","","",212,null],[13,"InfStackClosure","","",212,null],[13,"InvokeClosure","","",212,null],[13,"DerefPointer","","",212,null],[13,"FreeVariable","","",212,null],[13,"IndexSlice","","",212,null],[13,"RelateObjectBound","","",212,null],[13,"RelateParamBound","","",212,null],[13,"RelateRegionParamBound","","",212,null],[13,"RelateDefaultParamBound","","",212,null],[13,"Reborrow","","",212,null],[13,"ReborrowUpvar","","",212,null],[13,"DataBorrowed","","",212,null],[13,"ReferenceOutlivesReferent","","",212,null],[13,"ParameterInScope","","",212,null],[13,"ExprTypeIsNotInScope","","",212,null],[13,"BindingTypeIsNotValidAtDecl","","",212,null],[13,"CallRcvr","","",212,null],[13,"CallArg","","",212,null],[13,"CallReturn","","",212,null],[13,"Operand","","",212,null],[13,"AddrOf","","",212,null],[13,"AutoBorrow","","",212,null],[13,"SafeDestructor","","",212,null],[13,"CompareImplMethodObligation","","",212,null],[12,"span","rustc::infer::SubregionOrigin","",212,null],[12,"item_name","","",212,null],[12,"impl_item_def_id","","",212,null],[12,"trait_item_def_id","","",212,null],[4,"ParameterOrigin","rustc::infer","Places that type/region parameters can appear.",null,null],[13,"Path","","",213,null],[13,"MethodCall","","",213,null],[13,"OverloadedOperator","","",213,null],[13,"OverloadedDeref","","",213,null],[4,"LateBoundRegionConversionTime","","Times when we replace late-bound regions with variables:",null,null],[13,"FnCall","","when a fn is called",214,null],[13,"HigherRankedType","","when two higher-ranked types are compared",214,null],[13,"AssocTypeProjection","","when projecting an associated type",214,null],[4,"RegionVariableOrigin","","Reasons to create a region inference variable",null,null],[13,"MiscVariable","","",215,null],[13,"PatternRegion","","",215,null],[13,"AddrOfRegion","","",215,null],[13,"Autoref","","",215,null],[13,"Coercion","","",215,null],[13,"EarlyBoundRegion","","",215,null],[13,"LateBoundRegion","","",215,null],[13,"UpvarRegion","","",215,null],[13,"BoundRegionInCoherence","","",215,null],[13,"NLL","","",215,null],[4,"NLLRegionVariableOrigin","","",null,null],[13,"FreeRegion","","",216,null],[13,"Inferred","","",216,null],[4,"FixupError","","",null,null],[13,"UnresolvedIntTy","","",217,null],[13,"UnresolvedFloatTy","","",217,null],[13,"UnresolvedTy","","",217,null],[0,"anon_types","","",null,null],[3,"AnonTypeDecl","rustc::infer::anon_types","Information about the anonymous, abstract types whose values we are inferring in this function (these are the `impl Trait` that appear in the return type).",null,null],[12,"substs","","The substitutions that we apply to the abstract that that this `impl Trait` desugars to. e.g., if:",218,null],[12,"concrete_ty","","The type variable that represents the value of the abstract type that we require. In other words, after we compile this function, we will be created a constraint like:",218,null],[12,"has_required_region_bounds","","True if the `impl Trait` bounds include region bounds. For example, this would be true for:",218,null],[3,"ReverseMapper","","",null,null],[12,"tcx","","",219,null],[12,"tainted_by_errors","","If errors have already been reported in this fn, we suppress our own errors because they are sometimes derivative.",219,null],[12,"anon_type_def_id","","",219,null],[12,"map","","",219,null],[12,"map_missing_regions_to_empty","","",219,null],[12,"hidden_ty","","initially `Some`, set to `None` once error has been reported",219,null],[3,"Instantiator","","",null,null],[12,"infcx","","",220,null],[12,"parent_def_id","","",220,null],[12,"body_id","","",220,null],[12,"param_env","","",220,null],[12,"anon_types","","",220,null],[12,"obligations","","",220,null],[6,"AnonTypeMap","","",null,null],[11,"clone","","",218,{"i":[{"n":"self"}],"o":{"n":"anontypedecl"}}],[11,"fmt","","",218,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"instantiate_anon_types","rustc::infer","Replace all anonymized types in `value` with fresh inference variables and creates appropriate obligations. For example, given the input:",206,{"i":[{"n":"self"},{"n":"defid"},{"n":"nodeid"},{"n":"paramenv"},{"n":"t"}],"o":{"n":"inferok"}}],[11,"constrain_anon_types","","Given the map `anon_types` containing the existential `impl Trait` types whose underlying, hidden types are being inferred, this method adds constraints to the regions appearing in those underlying hidden types to ensure that they at least do not refer to random scopes within the current function. These constraints are not (quite) sufficient to guarantee that the regions are actually legal values; that final condition is imposed after region inference is done.",206,{"i":[{"n":"self"},{"n":"anontypemap"},{"n":"frr"}]}],[11,"constrain_anon_type","","",206,{"i":[{"n":"self"},{"n":"defid"},{"n":"anontypedecl"},{"n":"frr"}]}],[11,"infer_anon_definition_from_instantiation","","Given the fully resolved, instantiated type for an anonymous type, i.e., the value of an inference variable like C1 or C2 (*), computes the \"definition type\" for an abstract type definition -- that is, the inferred value of `Foo1<'x>` or `Foo2<'x>` that we would conceptually use in its definition:",206,{"i":[{"n":"self"},{"n":"defid"},{"n":"anontypedecl"},{"n":"ty"}],"o":{"n":"ty"}}],[11,"new","rustc::infer::anon_types","",219,{"i":[{"n":"tyctxt"},{"n":"bool"},{"n":"defid"},{"g":["kind","kind"],"n":"fxhashmap"},{"n":"ty"}],"o":{"n":"self"}}],[11,"fold_kind_mapping_missing_regions_to_empty","","",219,{"i":[{"n":"self"},{"n":"kind"}],"o":{"n":"kind"}}],[11,"fold_kind_normally","","",219,{"i":[{"n":"self"},{"n":"kind"}],"o":{"n":"kind"}}],[11,"tcx","","",219,{"i":[{"n":"self"}],"o":{"n":"tyctxt"}}],[11,"fold_region","","",219,{"i":[{"n":"self"},{"n":"region"}],"o":{"n":"region"}}],[11,"fold_ty","","",219,{"i":[{"n":"self"},{"n":"ty"}],"o":{"n":"ty"}}],[11,"instantiate_anon_types_in_map","","",220,{"i":[{"n":"self"},{"n":"t"}],"o":{"n":"t"}}],[11,"fold_anon_ty","","",220,{"i":[{"n":"self"},{"n":"ty"},{"n":"defid"},{"n":"substs"}],"o":{"n":"ty"}}],[0,"at","rustc::infer","A nice interface for working with the infcx.  The basic idea is to do `infcx.at(cause, param_env)`, which sets the \"cause\" of the operation as well as the surrounding parameter environment.  Then you can do something like `.sub(a, b)` or `.eq(a, b)` to create a subtype or equality relationship respectively. The first argument is always the \"expected\" output from the POV of diagnostics.",null,null],[3,"At","rustc::infer::at","",null,null],[12,"infcx","","",221,null],[12,"cause","","",221,null],[12,"param_env","","",221,null],[3,"Trace","","",null,null],[12,"at","","",222,null],[12,"a_is_expected","","",222,null],[12,"trace","","",222,null],[8,"ToTrace","","",null,null],[10,"to_trace","","",223,{"i":[{"n":"obligationcause"},{"n":"bool"},{"n":"self"},{"n":"self"}],"o":{"n":"typetrace"}}],[11,"at","rustc::infer","",206,{"i":[{"n":"self"},{"n":"obligationcause"},{"n":"paramenv"}],"o":{"n":"at"}}],[11,"eq_impl_headers","rustc::infer::at","Hacky routine for equating two impl headers in coherence.",221,{"i":[{"n":"self"},{"n":"implheader"},{"n":"implheader"}],"o":{"n":"inferresult"}}],[11,"sub_exp","","Make `a <: b` where `a` may or may not be expected",221,{"i":[{"n":"self"},{"n":"bool"},{"n":"t"},{"n":"t"}],"o":{"n":"inferresult"}}],[11,"sup","","Make `actual <: expected`. For example, if type-checking a call like `foo(x)`, where `foo: fn(i32)`, you might have `sup(i32, x)`, since the \"expected\" type is the type that appears in the signature.",221,{"i":[{"n":"self"},{"n":"t"},{"n":"t"}],"o":{"n":"inferresult"}}],[11,"sub","","Make `expected <: actual`",221,{"i":[{"n":"self"},{"n":"t"},{"n":"t"}],"o":{"n":"inferresult"}}],[11,"eq_exp","","Make `expected <: actual`",221,{"i":[{"n":"self"},{"n":"bool"},{"n":"t"},{"n":"t"}],"o":{"n":"inferresult"}}],[11,"eq","","Make `expected <: actual`",221,{"i":[{"n":"self"},{"n":"t"},{"n":"t"}],"o":{"n":"inferresult"}}],[11,"lub","","Compute the least-upper-bound, or mutual supertype, of two values. The order of the arguments doesn't matter, but since this can result in an error (e.g., if asked to compute LUB of u32 and i32), it is meaningful to call one of them the \"expected type\".",221,{"i":[{"n":"self"},{"n":"t"},{"n":"t"}],"o":{"n":"inferresult"}}],[11,"glb","","Compute the greatest-lower-bound, or mutual subtype, of two values. As with `lub` order doesn't matter, except for error cases.",221,{"i":[{"n":"self"},{"n":"t"},{"n":"t"}],"o":{"n":"inferresult"}}],[11,"trace","","Sets the \"trace\" values that will be used for error-reporting, but doesn't actually perform any operation yet (this is useful when you want to set the trace using distinct values from those you wish to operate upon).",221,{"i":[{"n":"self"},{"n":"t"},{"n":"t"}],"o":{"n":"trace"}}],[11,"trace_exp","","Like `trace`, but the expected value is determined by the boolean argument (if true, then the first argument `a` is the \"expected\" value).",221,{"i":[{"n":"self"},{"n":"bool"},{"n":"t"},{"n":"t"}],"o":{"n":"trace"}}],[11,"sub","","Make `a <: b` where `a` may or may not be expected (if `a_is_expected` is true, then `a` is expected). Make `expected <: actual`",222,{"i":[{"n":"self"},{"n":"t"},{"n":"t"}],"o":{"n":"inferresult"}}],[11,"eq","","Make `a == b`; the expectation is set by the call to `trace()`.",222,{"i":[{"n":"self"},{"n":"t"},{"n":"t"}],"o":{"n":"inferresult"}}],[11,"lub","","",222,{"i":[{"n":"self"},{"n":"t"},{"n":"t"}],"o":{"n":"inferresult"}}],[11,"glb","","",222,{"i":[{"n":"self"},{"n":"t"},{"n":"t"}],"o":{"n":"inferresult"}}],[0,"canonical","rustc::infer","Canonicalization is the key to constructing a query in the middle of type inference. Ordinarily, it is not possible to store types from type inference in query keys, because they contain references to inference variables whose lifetimes are too short and so forth. Canonicalizing a value T1 using `canonicalize_query` produces two things:",null,null],[3,"Canonical","rustc::infer::canonical","A \"canonicalized\" type `V` is one where all free inference variables have been rewriten to \"canonical vars\". These are numbered starting from 0 in order of first appearance.",null,null],[12,"variables","","",224,null],[12,"value","","",224,null],[3,"CanonicalVarValues","","A set of values corresponding to the canonical variables from some `Canonical`. You can give these values to `canonical_value.substitute` to substitute them into the canonical value at the right places.",null,null],[12,"var_values","","",225,null],[3,"CanonicalVarInfo","","Information about a canonical variable that is included with the canonical value. This is sufficient information for code to create a copy of the canonical value in some other inference context, with fresh inference variables replacing the canonical values.",null,null],[12,"kind","","",226,null],[3,"QueryResult","","After we execute a query with a canonicalized key, we get back a `Canonical<QueryResult<..>>`. You can use `instantiate_query_result` to access the data in this result.",null,null],[12,"var_values","","",227,null],[12,"region_constraints","","",227,null],[12,"certainty","","",227,null],[12,"value","","",227,null],[3,"CanonicalizeAllFreeRegions","","If this flag is true, then all free regions will be replaced with a canonical var. This is used to make queries as generic as possible. For example, the query `F: Foo<'static>` would be canonicalized to `F: Foo<'0>`.",null,null],[12,"0","","",228,null],[3,"Canonicalizer","","",null,null],[12,"infcx","","",229,null],[12,"tcx","","",229,null],[12,"variables","","",229,null],[12,"indices","","",229,null],[12,"var_values","","",229,null],[12,"canonicalize_all_free_regions","","",229,null],[12,"needs_canonical_flags","","",229,null],[3,"CanonicalVarValuesSubst","","",null,null],[12,"tcx","","",230,null],[12,"var_values","","",230,null],[4,"CanonicalVarKind","","Describes the \"kind\" of the canonical variable. This is a \"kind\" in the type-theory sense of the term -- i.e., a \"meta\" type system that analyzes type-like values.",null,null],[13,"Ty","","Some kind of type inference variable.",231,null],[13,"Region","","Region variable `'?R`.",231,null],[4,"CanonicalTyVarKind","","Rust actually has more than one category of type variables; notably, the type variables we create for literals (e.g., 22 or 22.) can only be instantiated with integral/float types (e.g., usize or f32). In order to faithfully reproduce a type, we need to know what set of types a given type variable can be unified with.",null,null],[13,"General","","General type variable `?T` that can be unified with arbitrary types.",232,null],[13,"Int","","Integral type variable `?I` (that can only be unified with integral types).",232,null],[13,"Float","","Floating-point type variable `?F` (that can only be unified with float types).",232,null],[4,"Certainty","","Indicates whether or not we were able to prove the query to be true.",null,null],[13,"Proven","","The query is known to be true, presuming that you apply the given `var_values` and the region-constraints are satisfied.",233,null],[13,"Ambiguous","","The query is not known to be true, but also not known to be false. The `var_values` represent either values that must hold in order for the query to be true, or helpful tips that might make it true. Currently rustc's trait solver cannot distinguish the two (e.g., due to our preference for where clauses over impls).",233,null],[5,"substitute_value","","Substitute the values from `var_values` into `value`. `var_values` must be values for the set of cnaonical variables that appear in `value`.",null,{"i":[{"n":"tyctxt"},{"n":"canonicalvarvalues"},{"n":"t"}],"o":{"n":"t"}}],[6,"CanonicalVarInfos","","",null,null],[6,"QueryRegionConstraint","","",null,null],[8,"Canonicalize","","Trait implemented by values that can be canonicalized. It mainly serves to identify the interning table we will use.",null,null],[16,"Canonicalized","","",234,null],[10,"intern","","After a value has been fully canonicalized and lifted, this method will allocate it in a global arena.",234,null],[11,"clone","","",224,{"i":[{"n":"self"}],"o":{"n":"canonical"}}],[11,"fmt","","",224,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"eq","","",224,{"i":[{"n":"self"},{"n":"canonical"}],"o":{"n":"bool"}}],[11,"ne","","",224,{"i":[{"n":"self"},{"n":"canonical"}],"o":{"n":"bool"}}],[11,"assert_receiver_is_total_eq","","",224,null],[11,"hash","","",224,null],[11,"decode","","",224,{"i":[{"n":"__dv"}],"o":{"g":["canonical"],"n":"result"}}],[11,"encode","","",224,{"i":[{"n":"self"},{"n":"__sv"}],"o":{"n":"result"}}],[11,"clone","","",225,{"i":[