initSidebarItems({"enum":[["CanonicalTyVarKind","Rust actually has more than one category of type variables; notably, the type variables we create for literals (e.g., 22 or 22.) can only be instantiated with integral/float types (e.g., usize or f32). In order to faithfully reproduce a type, we need to know what set of types a given type variable can be unified with."],["CanonicalVarKind","Describes the \"kind\" of the canonical variable. This is a \"kind\" in the type-theory sense of the term -- i.e., a \"meta\" type system that analyzes type-like values."],["Certainty","Indicates whether or not we were able to prove the query to be true."]],"mod":[["canonicalizer","This module contains the \"canonicalizer\" itself."],["query_result","This module contains the code to instantiate a \"query result\", and in particular to extract out the resulting region obligations and encode them therein."],["substitute","This module contains code to substitute new values into a `Canonical<'tcx, T>`."]],"struct":[["Canonical","A \"canonicalized\" type `V` is one where all free inference variables have been rewriten to \"canonical vars\". These are numbered starting from 0 in order of first appearance."],["CanonicalVarInfo","Information about a canonical variable that is included with the canonical value. This is sufficient information for code to create a copy of the canonical value in some other inference context, with fresh inference variables replacing the canonical values."],["CanonicalVarValues","A set of values corresponding to the canonical variables from some `Canonical`. You can give these values to `canonical_value.substitute` to substitute them into the canonical value at the right places."],["QueryResult","After we execute a query with a canonicalized key, we get back a `Canonical<QueryResult<..>>`. You can use `instantiate_query_result` to access the data in this result."]],"type":[["CanonicalVarInfos",""],["Canonicalized",""],["CanonicalizedQueryResult",""],["QueryRegionConstraint",""],["SmallCanonicalVarValues","Like CanonicalVarValues, but for use in places where a SmallVec is appropriate."]]});